﻿USE sofia;
DROP TABLE IF EXISTS sofia.anh_vpl;
CREATE TABLE anh_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES anh_vpl WRITE;
INSERT INTO anh_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Mban ya imbɨr Jisas Kraisɨnd, ndɨn Yakŋ Ohɨrand Nor. Ya hamb mbanave ahevakarɨmar. ");
INSERT INTO anh_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Eŋambɨr han Aisaiav, wɨram Yakŋ Ohɨrand ya injambɨr ahe kahɨnd hamb mbɨ mbanave mpamar. Ndɨh wan amar. Nzɨ kaŋ ihɨnd wɨram ya hɨrandand hamb mboz injore ondari amar. Mbɨ mboz we nandɨv empasam osarɨndari amar. ");
INSERT INTO anh_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Mbɨ isupɨr wɨram mah haŋ itɨkɨrɨm aware kandari amar. Anɨŋnsar Ohɨrandɨv empasam osarɨvar arar kandari amar. Ndɨndɨv empasam impumpɨr ohɨra akŋ han omanenta sɨvar arar kandari amar. ");
INSERT INTO anh_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Mach, Jonɨmb isupɨr wɨram mah handɨh ahevakarɨmar. Ahevakare osa anchɨ han ya mbanave sɨkah omar. Amɨ mpɨ itɨmaimŋgɨn nzɨ andɨŋ yambɨŋ ŋazɨkŋirɨŋgwɨŋgw ŋambiahaŋ, Yakŋ Ohɨrav amandɨŋ enta kɨvah han usɨndari amar. ");
INSERT INTO anh_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Mach, wɨram akŋ anchɨ akŋ isupɨr Judiand aiampɨra Jerusalemɨnd hamb Jonɨnd pɨŋ ai, mbɨndɨŋ enta kɨvah sɨmŋganj han injambɨr ahah kamŋgɨmar. Kamŋgɨz mach raz, Jonɨmb ndɨŋ yamb Jordan handɨh ŋazɨkŋirɨŋgwɨŋgw ŋambiahah omar. ");
INSERT INTO anh_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jonɨmb yupɨr hɨrahɨr osapɨr kamelɨnd ndɨ han hɨranj. Mbɨ orɨham uŋkɨruŋgɨr han mɨra ohɨrand upɨrɨŋ uŋkɨranj. Unsa mbɨkɨr han etameram akaraŋk antand, mbɨ han nanj. ");
INSERT INTO anh_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Mach, mbɨ ya eŋgwe kamar. Wɨram emŋga hamb ihɨnd mapɨŋ aindari amar. Ndɨn wɨram ohɨra aŋkarɨpɨrnsɨnd, mbɨ yan epari amar. Yan wɨram imbɨm amar. Nzɨ andamesa mpɨrorɨzɨŋgwi nzɨhanave mɨrupɨr mbɨkɨr han inɨmbɨmɨñ amar. ");
INSERT INTO anh_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nzɨ andɨŋ yamb imbɨmun ŋazɨkŋirɨŋgwɨŋgw ŋambiahajin amar. Mbɨp Kɨpɨr Imbɨr Yakŋ Ohɨrand han kaz ŋkai andɨŋ ŋgwevondari amar. ");
INSERT INTO anh_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mach, haŋonaŋg Jisasɨv aiampɨra mbɨkɨr Nasaret, isupɨr Galilind haŋ erere avɨhomar. Avɨhoz Jonɨmb ndɨn yamb Jordanɨŋ ŋazɨkŋirɨŋgwi ŋambiahamar. ");
INSERT INTO anh_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ŋambiahazand sɨhawarohe waz rakav kɨrɨm ŋenduwamar. Ŋenduwazand Kɨpɨr Imbɨr Yakŋ Ohɨrand hamb apa ikŋɨŋgwɨm emamp ipɨndahe ndɨnɨŋ ŋkaimar. ");
INSERT INTO anh_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Az Yakŋ Ohɨrav mbɨkɨr Aiampɨra Ohɨra Ñaŋ handɨh ñi kamar. Nan ihɨnd Nor amar. Nzɨ nandɨvon rin amar. Ihɨnd mpɨ hamb nandɨv imbɨrpamun ñi amar. ");
INSERT INTO anh_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Mach, haŋonaŋg Kɨpɨr Imbɨr Yakŋ Ohɨrand hamb Jisasɨh ke mpimbi ŋavɨzuz isupɨr wɨram mah handɨh omar. ");
INSERT INTO anh_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","We yuŋk undɨmajɨvam ohɨra (40) ñɨz ñɨzand Satanɨmb ndɨnɨh mbɨŋgɨr eŋgwanj. Mbɨŋgɨr eŋgwazand, Jisasɨv mɨroyam antandmen ñɨzand, Yakŋ Ohɨrand mapɨŋ akŋ hamb ndɨn pɨrasɨmŋganj. ");
INSERT INTO anh_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Mach, Herotɨv Jonɨh oram kɨvahɨŋ ŋgame inchakarɨz ñɨzand, Jisasɨv erai isupɨr Galilind handɨh ahevakarɨmar. Ahevakare Yakŋ Ohɨrand ya imbɨr han hɨro hɨrai eŋgwanj. ");
INSERT INTO anh_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ave mbɨ mbanave kanj. Yuŋk Yakŋ Ohɨrav ŋgamɨmar hamb ndɨh ahevakari aranj. Yuŋk Yakŋ Ohɨrav osa anchɨ hanaveaŋg ŋɨmbɨz mbɨkɨr kwɨŋ ñɨndɨramŋgi kehamb ikwɨm ndɨh ivivmbɨri aranj. Amɨ Yakŋ Ohɨrand ya imbɨr mban njɨhame mpɨ itɨmai njɨhi aŋkarɨpɨr ŋe njɨhambar aranj. ");
INSERT INTO anh_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Mach ave, Jisasɨv yamb ohɨra ondɨhondɨh Galilind ampaŋam omar. We nde waz Saimonɨmb ranɨr Andrumen mbɨndɨŋ añaŋan han avɨzɨŋgwɨŋgw ñɨmŋgɨmar. Mbɨndɨŋ ntɨŋ han oma ŋaŋɨndɨvam. ");
INSERT INTO anh_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Az Jisasɨv ndɨŋ kamar. Amɨ ai yan mpehɨraivar amar. Aimŋgɨn nzɨ andɨŋ wɨram hanave ŋɨmbɨmb han mbɨramɨŋ amar. ");
INSERT INTO anh_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Avɨz mach, pams haŋon ŋondɨrahe mbɨndɨŋ añaŋan akŋ han erere ndɨn kɨrɨm mpehɨromŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Mach, mbɨ sɨwaŋkw sɨwaŋkw re waz Sebedind nor kɨra undɨmaj hamb Jemsɨnd Jonɨnd utɨŋg unchaŋ ñɨhɨri mbɨndɨŋ añaŋan akŋ han omanenta sɨz ñɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ñɨmŋgɨzand Jisasɨv ndɨŋ oreŋgɨmar. Oreŋgɨz, mbɨ ŋondɨrahe wanɨr mbɨndɨŋ Sebedih erere etomŋgɨmar. Sebediv mbɨkɨr wɨram kɨra ntɨŋɨndɨmen utɨŋg unchaŋ ñɨmŋgɨzand, undɨmaj hamb ŋondɨrahe Jisasɨh kɨrɨm mpehɨromŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Mach, Jisasɨv sezɨrmen aiampɨra Kaperneam handɨh omŋgɨmar. Omŋgɨz wer Yakŋ Ohɨrand Yuŋk Wɨr Ñɨñɨnd hamb ahevakarɨz, Jisasɨv Yakŋ Ohɨrand marɨvai oramɨŋ ahevohe ya sɨkanj. ");
INSERT INTO anh_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Wɨram kɨra ya Mosesɨnd injambɨr ahe sɨkahɨnd kehamb, mbɨ njɨhi wɨram emŋgand ŋe osa anchɨ han sɨkamŋganj. Jisasɨp, mbɨ nend. Mbɨ mbɨkɨrun njɨhiŋam ŋe wɨram ensansɨnd emamp sɨkanj. Handɨv wɨram akŋ anchɨ akŋ hamb Jisasɨnd ya han njɨhamam ntamŋganj. ");
INSERT INTO anh_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Mach, yuŋk emŋga haŋ Jisasɨv ya sɨkazand wɨram itɨ kɨvahɨnsɨnd hamb mbɨndɨŋ Yakŋ Ohɨrand marɨvai oramɨŋ ñɨmar. Avɨz itɨ kɨvah mbanamb aware kamar. ");
INSERT INTO anh_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Jisas, nan wɨram Nasaretɨnd amar. Amɨ arɨŋ utɨ sɨŋɨn are ain amar. Ave arɨŋ mɨŋam kiaŋgworaŋgwi kɨvah sɨŋɨn are ain oh a amar. Nzɨ nan ndɨh wajin amar. Nan wɨram Yakŋ Ohɨrav kaz aimandɨn hamb amar. ");
INSERT INTO anh_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Hanave kaz, Jisasɨv itɨ kɨvah mban ya aŋkarɨpɨr ke kamar. Amɨ ya erere wɨram mban etov amar. ");
INSERT INTO anh_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Mach, Jisasɨv hanave kaz, itɨ kɨvah mbanamb raz wɨram mbanamb nte kɨrɨm ntahorɨmar. Ntahorɨzand itɨ kɨvah hamb itɨkɨrɨmun aware kɨrɨm enduwaŋgɨŋgamar. ");
INSERT INTO anh_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Mach az, wɨram akŋ anchɨ akŋ hamb wamŋgɨz, ndɨŋ zɨŋɨmb pɨrorɨŋgaz mbon ya mbon ya ke kamŋgɨmar. Mban utɨman ya arɨmŋgɨmar. Wɨram mbanamb ya icha toh ki arɨmŋgɨmar. Ave mbɨ ya han wɨram ensansɨnd emamp kazand itɨ kɨvah hamb mbɨkɨr ya njɨhamŋgɨj arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Avɨz pams haŋon, wɨram akŋ anchɨ akŋ isupɨr Galilind hamb Jisasɨndɨv ya kɨrɨm hɨro hɨrai kamŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Mach ave, Jisasɨv Jemsmen Jonmen Yakŋ Ohɨrand marɨvai oramɨŋ ñɨhɨri ahevetai Saimonɨnd Andrund oramɨŋ omŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimonɨnd mɨŋɨr anchɨndɨrɨh mbɨkɨr yupɨr hamb pɨr ohɨra ñɨzand, antɨm mbɨkɨr handɨh ŋgañɨmar. Az Jisasɨh mahoror mbɨkɨr handɨv kamŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Kamŋgɨz we omanampɨra mbɨkɨr han ŋe ndɨn ŋambiahamar. Ndɨn ŋambiahaz mach, yupɨr mbɨkɨr hamb kɨrɨm imi ŋamar. Az ndɨŋ hɨrawi unsa eŋkwanamar. ");
INSERT INTO anh_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Mach, rapɨrɨv ŋkwuhi zuh razand, mbɨ osa anchɨ hamb wɨram mahororɨnsɨnd han, itɨ kɨvahɨnsɨnd hanez mɨŋam ŋɨmbi Jisasɨnd pɨŋ hɨraimŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Osa anchɨ aiampɨraŋ ñɨmŋgɨmar kehamb mɨŋam ai oram impikŋ handɨh aŋkwezawi ñɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Avɨz Jisasɨv wɨram akŋ anchɨ akŋ mahoror endɨraparamnsɨnd han omanenta si, mach itɨ kɨvahɨnsɨnd kehan itɨ kɨvah han mɨŋam kiaŋgworaŋgwɨmar. Itɨ kɨvah hamb Jisasɨh ndɨh wamŋganj. Ave ndɨn injambɨr ahamŋgɨmɨnj are ndɨŋ erokare kamar. Amɨ yaya kamŋgɨmɨn amar. ");
INSERT INTO anh_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mach, Jisasɨv mband zuhun ŋaiahe ahevai isupɨr wɨram mah handɨh we Yakŋ Ohɨra ahaz oror ñɨmar. ");
INSERT INTO anh_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","We ñɨzand Saimonɨmb wɨram emŋgemŋgamen Jisasɨh kɨrahɨr omŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","We ndɨn we kamŋgɨmar. Wɨram akŋ anchɨ akŋ hamb nan kɨramŋgɨmbɨri arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Az Jisasɨv ndɨŋ kamar. Aimŋgɨn aiampɨra emŋgemŋga ikwɨm ikwɨm ñɨmŋgi mbanaŋ om amar. Nzɨ wɨram akŋ anchɨ akŋ ya eŋgwaŋɨn are ondarin amar. Nzɨ ntɨŋ handɨvon aindaiyin amar. ");
INSERT INTO anh_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Mach ave, mbɨ aiampɨra emŋgemŋga Galilind handɨh we ñi mbɨndɨŋ Yakŋ Ohɨrand marɨvai oram unchaŋ ya eŋgweŋgw ndanj. Ave osa anchɨ itɨ kɨvahɨnsɨnd kehan itɨ kɨvah han kiaŋgworaŋgw ndanj. ");
INSERT INTO anh_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Mach ave, wɨram usɨ aŋkarɨpɨr yupɨr okaŋgaŋgɨnsɨnd hamb Jisasɨnd pɨŋ ai andamesa mpɨrorɨzɨŋgwi ŋgwañ ekeh akŋɨn ŋaŋ kamar. Amɨ yan akŋɨn ñɨŋan han, kan ihɨnd usɨ kɨvah aŋkarɨpɨr hamb kwevɨrɨz amar. ");
INSERT INTO anh_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Hanave kaz, Jisasɨv ndɨn akŋɨn ñi omanaka ndɨn insɨŋ ŋgame kamar. Nzɨ nan akŋɨn ñi nan ndɨh omanenta sin amar. ");
INSERT INTO anh_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Mach, Jisasɨv hanave kaz, yupɨr mbɨkɨr hamb pams haŋon omanenta ñɨz, wɨram mbanamb kɨrɨm imbɨr ramar. ");
INSERT INTO anh_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","44","Avɨz Jisasɨv wɨram mban kamar. Amɨ ov amar. We yupɨr amakɨr han wɨram hanɨhan Yakŋ Ohɨrandɨv ahaz ore ŋgamamɨnd pɨŋ hɨrohe mbɨramɨn waz amar. Mosesɨv kamar amar. Wɨram usɨ aŋkarɨpɨr yupɨr okaŋgaŋgɨnsɨnd hamb, yupɨr mbɨkɨr hamb omanenta ñɨŋɨnj han, mbɨ mɨrunsa ŋe Yakŋ Ohɨrandɨv ahaz ore ŋgamɨz arar kamar amar. Amɨ we hanavɨv amar. Amɨ hanavɨn, wɨram kɨra hanɨhan Yakŋ Ohɨrandɨv ahaz ore ŋgamamɨnd hamb we kandɨramŋgi amar. Yupɨr amakɨr hamb ndɨh omanenta ñi arar kandɨramŋgi amar. Mach, Jisasɨv hanave ke wɨram mban aŋkarɨpɨr erokare kamar. Ndɨh wan amar. Amɨ wɨram emŋga kamɨn amar. ");
INSERT INTO anh_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Az nend. Wɨram mbanamb ya Jisasɨv utuhutuh sɨmar han hɨro hɨrai kɨrɨm kamar. Handɨv Jisasɨv wɨram akŋɨnd ampɨn insɨŋ nzɨhanave aiampɨraŋ ŋgwevomɨr. Nend, mbɨ isupɨr wɨram mah haŋ ñɨzand wɨram akŋ anchɨ akŋ aiampɨra emŋgemŋgand kehamb ndɨn pɨŋ aimŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","2","Mach, Jisasɨv zuh ohɨron ñɨñ nde aiampɨra Kaperneamɨŋ ekwaŋg aimar. Mbɨ ai ñɨzand osa anchɨ ui ondond hamb kamŋgɨmar. Jisasɨv ai mbɨkɨr oramɨŋ ñɨñmbɨri arɨmŋgɨmar. Mach, hanave kamŋgɨz, wɨram akŋ anchɨ akŋ hamb ya han njɨhame ai aŋkwezawɨmŋgɨmar. Aŋkwezawɨmŋgɨz oram hamb torɨz, impikŋ hanez wɨrambam ñɨmar. Az Jisasɨv ndɨŋ ya eŋgwamar. ");
INSERT INTO anh_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mach, wɨram kɨra hamb wɨram emŋga oman andam mahahɨnd han Jisasɨnd pɨŋ hɨraiŋɨn are aimŋgɨmar. Wɨram undɨmajɨvam mbɨndɨŋ hamb iwɨnŋkarɨŋ izɨŋgwi ndɨn hɨraimŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mbɨ ndɨn hɨrai wamŋgɨz sam han osa anchɨvam torɨmar. Avɨz oram umpɨrɨŋ awarohe sam Jisasɨv ñɨmarɨŋon ŋazɨparɨmŋgɨmar. Ŋazɨparɨmŋgɨz mach raz, wɨram mban ŋambiahe kɨrɨpaŋ ŋamŋgɨzand wɨram iwɨnŋkarɨnsɨnd hamb Jisasɨnd pɨŋ ŋkwumar. ");
INSERT INTO anh_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Mach, Jisasɨv ndɨŋ waz wɨram kɨra mbanamb njɨhi aŋkarɨpɨr ŋe njɨhamŋgɨmar. Mach az, Jisasɨv wɨram oman andam mahahɨnd mban kamar. Nor amar. Nzɨ enta kɨvah amakɨr han ndɨh usin amar. ");
INSERT INTO anh_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mach, mbɨ hanave kaz, wɨram kɨra ya Mosesɨnd injambɨr ahe sɨkahɨnd hamb ŋgarɨwi mbon mbon njɨhiŋam njɨhamŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Utɨndɨv wɨram mbanamb ya kehand han ki arɨmŋgɨmar. Mbɨ Yakŋ Ohɨrah yarahi arɨmŋgɨmar. Yakŋ Ohɨrav mbonam enta kɨvah han imbɨr usɨmɨr arɨmŋgɨmar. Wɨram imbɨm hamb nend arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Hanavav njɨhamŋgɨzand, Jisasɨv mbɨndɨŋ njɨhi akŋ han ndɨh wamar. Ave ndɨŋ amare kamar. Amɨ utɨndɨv njɨhi kehan njɨhamŋgɨn amar. ");
INSERT INTO anh_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nzɨ utɨman ya wɨram oman andam mahahɨnd kehan kandarin amar. Nzɨ imbɨr kamɨñ, nzɨ amakɨr enta kɨvah han ndɨh usin o nzɨ imbɨr kamɨñ, ŋaiahe, amakɨr iwɨnŋkar han ŋe ov arar kamɨñ amar. ");
INSERT INTO anh_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Amɨ han wandɨramŋgɨn amar. Wɨramɨnd Nor hamb, mbɨ isupɨr mban ndɨn ensansɨnd, mbɨ enta kɨvah han imbɨr usɨmɨr amar. Mbɨ hanave ke wɨram oman andam mahahɨnd mban kamar. ");
INSERT INTO anh_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Nzɨ nan kin amar. Ŋaiahe amakɨr iwɨnŋkar han ŋe oramɨŋ ov amar. ");
INSERT INTO anh_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Mach, wɨram akŋ anchɨ akŋ hamb werɨmŋgɨzand, wɨram mbanamb ŋaiahe mbɨkɨr iwɨnŋkar han ŋe kɨrɨm ahevomar. Avɨz wɨram akŋ anchɨ akŋ han zɨŋɨmb pɨrorɨŋgaz, mbɨ Yakŋ Ohɨrand ensa ŋambiahe kamŋgɨmar. Arɨ enta kehan eŋambɨr han mɨwarɨm arɨmŋgɨmar. Nendon mɨŋ arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Mach, Jisasɨv we, yamb ohɨra ondɨhondɨh Galilind ampaŋam ekwaŋg omar. We ñɨzand, wɨram akŋ anchɨ akŋ hamb ndɨn pɨŋ aimŋgɨmar. Aimŋgɨz Jisasɨv ndɨŋ ya sɨkamar. ");
INSERT INTO anh_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ya sɨke mach re, we nde waz Livai Alfiusɨnd nor hamb ekwanz uŋkɨ oramɨŋ ŋkañɨmar. Az Jisasɨv ndɨnɨh kamar. Amɨ yan mpehɨraiv amar. Az ŋaiahe Jisasɨh kɨrɨm mpehɨromar. ");
INSERT INTO anh_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Mach, Jisasɨv Livaind oramɨŋ we ahevomar. Ahevohe ŋkañi unsa namar. Wɨram kɨra ekwanz uŋkɨ ŋaŋɨnd, wɨram kɨra enta kɨvah sɨzɨnd hambez, mbɨ Jisasɨnd sezɨrmen ŋgarɨwi Jisasmen unsa pamɨnd namŋgɨmar. Wɨram kɨra kehamb Jisasɨŋam mpehɨrɨndamŋganj. ");
INSERT INTO anh_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mach, wɨram untɨm Farisind wɨram kɨra ya Mosesɨnd injambɨr ahe sɨkahɨnd hamb mbɨ wamŋgɨz, Jisasɨv wɨram kɨra ekwanz uŋkɨ ŋaŋɨndmen mach wɨram kɨra enta kɨvah sɨzɨnd hamen hanave ŋgarɨwi unsa pamɨnd namŋgɨmar. Avɨz wɨram untɨm Farisind hamb Jisasɨnd sezɨr han mbanave amarɨmŋgɨmar. Utɨndɨv Jisasɨv wɨram kɨra ekwanz uŋkɨ ŋaŋɨndmen mach wɨram kɨra enta kɨvah sɨzɨnd hamen ŋgarɨwi unsa pamɨnd namŋgi arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Hanave kamŋgɨz, Jisasɨv mbɨndɨŋ ya han njɨhame kamar. Osa anchɨ mahoror mah hamb mbɨ uvitand pɨŋ momŋgɨrɨm amar. Osa anchɨ mahororɨnsɨndɨvam hamb mbɨ uvitand pɨŋ omŋgɨj amar. Handɨv nzɨ osa anchɨ imbɨr han ŋɨmbɨŋɨn are maindaim amar. Nzɨ osa anchɨ enta kɨvah sɨzɨnd han ŋɨmbɨŋɨn are aindaiyin amar. ");
INSERT INTO anh_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Mach, ui haŋonaŋg Jonɨnd sezɨr hamb unsa wɨv akarɨmŋgɨzand wɨram untɨm Farisindɨvez unsa wɨv akarɨmŋgɨmar. Unsa wɨv akare ñɨmŋgɨzand, osa anchɨ hamb ai Jisasɨh amarɨmŋgɨmar. Utɨndɨv Jonɨnd sezɨr hamb unsa wɨv akare ñɨmŋgɨzand wɨram untɨm Farisind sezɨr hambez unsa wɨv akarɨmŋgɨmbɨri arɨmŋgɨmar. Amakɨr sezarɨp nend arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Az Jisasɨv ndɨŋ ya ahɨmb kamar. Yuŋk kehaŋon wɨram emŋga hamb anchɨ han ŋaŋɨnj amar. Az kambɨrunjɨr mbɨkɨr hamb unsa wɨv haŋ imbɨr akarɨndɨramŋgi oh a amar. Wɨram kehamb mbɨkɨr kambɨrunjɨrɨmen ñɨzand nend amar. ");
INSERT INTO anh_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mbɨ ñɨz ñɨzand wɨram emŋgemŋga hamb ai ndɨn hɨromŋgɨzand mbɨkɨr kambɨrunjɨr hamb unsa wɨv haŋ akarɨndɨramŋgi amar. ");
INSERT INTO anh_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Mach, mbɨ mbahon kamar. Uñɨmb imɨn pach icha han ŋe imɨn ipɨra han samɨr amar. Mbɨ hanavɨz, imɨn pach icha hamb ŋambivɨz ipɨra hamb unchɨrahandari amar. Unchɨrahaz mɨn ohɨra ñɨndari amar. ");
INSERT INTO anh_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Uñɨmb kɨrɨpa nor yamb icha han ŋe mɨra ohɨrand upɨr aŋan ipɨra haŋ ichɨmŋgɨmɨr amar. Mbɨ hanavɨz, kɨrɨpa nor yamb hamb mpohɨrarɨz mɨra ohɨrand upɨr aŋan hamb akakŋɨndari amar. Avɨz mɨra ohɨrand upɨr aŋan hamb kɨrɨpa nor yamb hansɨnd kɨvah randari amar. Wɨram hamb kɨrɨpa nor yamb icha han ichɨŋɨn are, mɨra ohɨrand upɨr aŋan icha haŋ ichɨmŋgɨj amar. ");
INSERT INTO anh_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mach, Yakŋ Ohɨrand Yuŋk Wɨr Ñɨñɨnd emŋga haŋ Jisasɨv sezɨrmen wit warɨŋ ŋgwevohe empasamɨŋ omŋgɨmar. Omŋgɨzand, sezɨrɨv wit han erɨherɨh nan omŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Avɨz wɨram untɨm Farisind hamb Jisasɨh kamŋgɨmar. Utɨndɨv amakɨr sezarɨv chonj han kware Yakŋ Ohɨrand Yuŋk Wɨr Ñɨñɨnd haŋ ntɨŋ ŋamŋgɨmbɨri arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Az ndɨŋ kamar. Amɨ enta Devitɨv sɨmar han Yakŋ Ohɨrand anɨŋzɨŋ enta unchaŋ ñi han mamehɨmŋgɨrɨm toh amar. Abiatarɨh wɨram anɨŋnsar ohɨra hanɨhan Yakŋ Ohɨrandɨv ahaz ore ŋgamamɨnd hamb ñɨzand, Devitɨv wɨram untɨm mbɨkɨrmen ñi unsa mah raz unsandɨv mahɨmŋgɨmar amar. Ave Devitɨv Yakŋ Ohɨrand Oram unchaŋ ahevohe eŋka Yakŋ Ohɨrandɨv ahaz ore ŋgamŋgɨmar han ŋe namar amar. Eŋka kehan wɨram imbɨm hamb ŋe nan han nend amar. Chonj ohɨra amar. Wɨram kɨra hanɨhan Yakŋ Ohɨrandɨv ahaz ore ŋgamamɨnd hambam namŋgɨj amar. Hanaŋg Devitɨv ŋe ne wɨram untɨm mbɨkɨr han eŋkwanamar amar. ");
INSERT INTO anh_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Mach, Jisasɨv ekwaŋg ke ndɨŋ kamar. Yakŋ Ohɨrav osa anchɨ hamb mbɨkɨr Yuŋk Wɨr Ñɨñɨnd han hɨrawɨmŋgɨz are ŋgamɨmar oh a amar. Nend amar. Mbɨ mbɨkɨr Yuŋk Wɨr Ñɨñɨnd hamb osa anchɨ han hɨrawɨz are ŋgamɨmar amar. ");
INSERT INTO anh_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Handɨv Wɨramɨnd Nor hamb Yakŋ Ohɨrand Yuŋk Wɨr Ñɨñɨnd kehanez mbɨ Anɨŋnsar Ohɨra ñi amar. ");
INSERT INTO anh_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Mach ave, Jisasɨv we Yakŋ Ohɨrand marɨvai oramɨŋ ekwaŋg ahevomar. Ahevohe waz wɨram pamuh ñɨmar. Omanaka mbɨkɨr han mahoror kɨvahɨv arazɨŋgwɨz onsonz ñɨmar. ");
INSERT INTO anh_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Mach, wɨram untɨm Farisind hamb Jisasɨh ya oram hɨroŋɨn are ndɨn omanenton wehɨrɨmŋgɨmar. Jisasɨv Yakŋ Ohɨrand Yuŋk Wɨr Ñɨñɨnd haŋ wɨram kehan omanenta sɨz, omanaka mbɨkɨr hamb imbɨr ñɨndari han arɨ ndɨn kampɨhe kaŋarɨŋ arɨmŋgɨmar. Jisasɨv Yakŋ Ohɨrand Yuŋk Wɨr Ñɨñɨnd haŋ ntɨŋ ŋandɨŋi arar kaŋarɨŋ arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Mbɨ Jisas werer ñɨmŋgɨzand Jisasɨv wɨram omanaka mahoror kɨvahɨnsɨnd han kamar. Amɨ ai uhɨm mbanaŋ aŋkwañɨmb amar. ");
INSERT INTO anh_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Mbɨ ai ñɨzand Jisasɨv wɨram untɨm Farisind han amarɨmar. Arɨ Yakŋ Ohɨrand Yuŋk Wɨr Ñɨñɨnd haŋ enta imbɨr sɨndɨrarɨŋ oh o arɨ enta kɨvah sɨndɨrarɨŋ oh amar. Arɨ wɨram pɨrasɨrɨŋ imbɨr ñɨndari oh o arɨ wɨram mamta orɨndɨrarɨŋ oh amar. Jisasɨv hanave kaz, wɨram untɨm Farisind hamb ya mɨkamŋgɨm. ");
INSERT INTO anh_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Az Jisasɨv ndɨŋ werer nde waz mbɨ entacha amamŋgɨz handɨv Jisasɨnd mpɨ hamb pɨraz ndɨŋ aŋkwɨ sɨmar. Ave mbɨ wɨram omanaka mahoror kɨvahɨnsɨnd han kamar. Omanaka amakɨr han irɨvɨr amamb amar. Az mbɨ mbɨkɨr omanaka han irɨvɨr amaz mach mbɨkɨr omanaka hamb imbɨrun ñɨmar. ");
INSERT INTO anh_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Avɨz wɨram untɨm Farisind hamb pams haŋon ŋondɨrahe Yakŋ Ohɨrand marɨvai oram han erere omŋgɨmar. We Herotɨnd untɨm men aŋkwezawi Jisas mamta ororndɨv ya orɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Mach, Jisasɨv sezɨrmen aiampɨra han erere yamb ohɨra ondɨhondɨh Galilind ampaŋam omŋgɨmar. Omŋgɨzand wɨram akŋ anchɨ akŋ isupɨr Galilind hamb ŋondɨrahe ndɨn mpehɨromŋgɨmar. Osa anchɨ isupɨr Judiand, aiampɨra ohɨra Jerusalemɨnd, isupɨr Idumeand, yamb ŋkiŋg yamb Jordand, osa anchɨ aiampɨra Tair ikwɨm ñɨmŋgɨmar hamb, mach osa anchɨ aiampɨra Saidon ikwɨm ñɨmŋgɨmar hambez, mbɨ Jisasɨv utuhutuh akŋ han sɨmar han njɨhame ŋondɨrahe ndɨn pɨŋ aimŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","12","Jisasɨv wɨram akŋ anchɨ akŋ mahororɨnsɨnd han omanenta sanj. Avɨz itɨ kɨvah hamb ndɨn waw hanaveam ndɨn pɨŋ ŋgorahɨrahɨr kwa aworɨmŋgɨŋg kamŋganj. Nan Yakŋ Ohɨrand nor arɨmŋganj. Az Jisasɨv ndɨŋ ya aŋkarɨpɨr ke erokarar kanj. Yan injambɨr ahe kamŋgɨmɨn aranj. Avɨz osa anchɨ mahororɨnsɨnd hamb ndɨn ŋgɨŋaŋɨn arar mbɨŋ mbɨŋ ŋɨmbɨzo ŋɨmbɨzai kworaŋkworor ndɨn pɨŋ aimŋgɨmar. Osa anchɨ hamb hanavav aimŋgɨzand, Jisasɨv njɨhamɨmar. Yan kware ŋavɨzumŋgɨmɨnj amar. Handɨv mbɨ sezɨrɨh kamar. Yandɨv utɨŋg han hɨrai ikwɨm ŋgambar amar. ");
INSERT INTO anh_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Mach, Jisasɨv aparɨmaŋ awarohe wɨram kɨra ensamaŋɨn are ramar han oreŋgɨz ndɨn pɨŋ aimŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Aimŋgɨz mbɨ wɨram kɨra oman ŋkiŋkiŋg undɨmaj han ndɨnmen ñɨmŋgɨz are ŋɨmbɨmar. Ave Jisasɨv ndɨŋ kamar. Nzɨ andɨŋ wɨram kɨra mban amɨ ihɨnd ensaŋ ntɨŋ ŋaŋɨndɨv uyɨzɨŋgwin han ensamin amar. Nzɨ andɨŋ Yakŋ Ohɨrand ya hɨro hɨrai osa anchɨ eŋgweŋgwɨndɨv ensamin amar. ");
INSERT INTO anh_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ave nzɨ andɨŋ itɨ kɨvah kiaŋgworaŋgwaŋgwɨndɨvez ensa ohɨra mach aŋkarɨpɨr eŋgwin amar. ");
INSERT INTO anh_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","19","Mach ave, Jisasɨv wɨram oman ŋkiŋkiŋg undɨmaj han ensamamar. Mbɨndɨŋ ensa han mbanɨmb: Saimon, (Jisasɨv ndɨn ensa emŋga mbɨkɨr Pita eŋgwamar), Sebedind nor kɨra undɨmaj han mbɨndɨŋ ensa han Jems Jon, (Jisasɨv undɨmaj han ensa emŋga Boanerges eŋgwamar. Ensa kehand ondo han mbanɨmb: wɨram ya ema ŋkɨraŋgɨrɨnd emamp.) Andru, Filip, Bartolomyu, Matyu, Tomas, Jems Alfiusɨnd nor, Tadius, Saimon untɨm Selotɨnd, mach Judas Iskariot, mbɨ Jisasɨh kambɨrɨñɨrɨnd oman insɨŋ ŋgamɨmar. ");
INSERT INTO anh_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Mach ave, Jisasɨv mbɨkɨr sezɨrmen oramɨŋ ahevomŋgɨmar. Ahevomŋgɨz wɨram akŋ anchɨ akŋ ohɨron hamb Jisasɨnd pɨŋ ai aŋkwezawi ñɨmŋgɨz, handɨv Jisasɨv mbɨkɨr sezɨrmen ntɨŋ ohɨra ŋe unsa nzɨhanave namŋgɨmɨr. ");
INSERT INTO anh_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Avɨz Jisasɨnd zɨŋgɨr hamb han njɨhame kamŋgɨmar. Jisasɨv ndɨh eraher awi arɨmŋgɨmar. Ave ndɨn ŋaŋɨn are ŋondɨrahe aimŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Aimŋgɨzand, wɨram kɨra Jerusalemɨnd ya Mosesɨnd injambɨr ahe sɨkahɨnd hamb aiampɨra ohɨra Jerusalemɨŋ erere ŋketai eretai ñɨhɨri kamŋgɨmar. Itɨ kɨvahɨnd anɨŋnsar han, mbɨkɨr ensa Belsebul, Jisasɨh ŋgɨŋe awarohe ñɨñmbɨri arɨmŋgɨmar. Ave itɨ kɨvahɨnd anɨŋnsar mbanamb Jisasɨh aŋkarɨpɨr eŋgwazand, mbɨ itɨ kɨvah han kiaŋgworaŋgwɨj arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Hanave kamŋgɨz, Jisasɨv ndɨŋ oreŋgɨz aimŋgɨmar. Aimŋgɨz mbɨ ya ahɨmb mban kamar. Nzɨhanave Satanɨmb Satanonaŋg kiaŋgwɨmɨr amar. ");
INSERT INTO anh_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Wɨram isupɨr ohɨra kɨvah wererɨnd emŋga hamb ñɨmɨr amar. Kɨrɨm mbɨkɨr osa anchɨ hamb kwɨri mbon mbon imbɨr ñɨmah re era mpamŋgɨmɨr han isupɨr kehamb nzɨhanave ñɨmɨr amar. ");
INSERT INTO anh_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Mach, osa anchɨ zɨŋgɨrɨnd hamb kwɨri mbon mbon imbɨr ñɨmah re era mpamŋgɨmɨr han zɨŋgɨr mbanamb nzɨhanave ñɨmɨr amar. ");
INSERT INTO anh_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Mach, Satanɨnd untɨm hamb kwɨri mbon mbon imbɨr ñɨmah re era mpamŋgɨmɨr han mbɨ mɨñɨmŋgɨmɨr amar. Mbɨ mɨŋam kwevɨrɨmŋgɨmɨr amar. ");
INSERT INTO anh_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Mach, Jisasɨv ekwaŋg ke kamar. Wɨram emŋga hamb utɨzi wɨram aŋkarɨpɨrɨnd oramɨŋ ahevohe hanɨhan mbɨkɨr han mamah ŋɨmbɨmɨr amar. Nend amar. Mbɨ wɨram aŋkarɨpɨr han kɨrɨpaŋ kɨravɨhaz ŋgañɨzand imbɨr hanɨhan han mamah ŋɨmbɨmɨr amar. ");
INSERT INTO anh_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nzɨ andɨŋ mɨŋun kin amar. Wɨramb utuhutuh enta kɨvah sɨndɨramŋgi han, utuhutuh ya kɨvah Yakŋ Ohɨrah yarahe kandɨramŋgi han, Yakŋ Ohɨrav enta kɨvah kehan imbɨr usɨndari amar. ");
INSERT INTO anh_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Kɨrɨm wɨramb ya kɨvah Yakŋ Ohɨrand Kɨpɨr Imbɨrɨh yarahe kandɨramŋgi han, Yakŋ Ohɨrav enta kɨvah kehan musɨndɨram amar. Wɨram kehamb kɨvah ñɨz mbɨkɨr enta kɨvah kehambez mbah ñɨñ ndame ñɨñ ndamɨŋɨnj amar. ");
INSERT INTO anh_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Mbɨ itɨ kɨvahɨv Jisasɨh ŋgɨŋe awarohe ñɨñmbɨri arar kamŋgɨmar. Handɨv Jisasɨv ndɨŋ kamar. Yakŋ Ohɨrav enta kɨvah kehan musɨndɨram amar. ");
INSERT INTO anh_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mach, Jisasɨnd runjɨr hamb mɨŋɨr mbɨndɨŋmen ai injambɨr handɨh aŋkwañɨhɨri osa anchɨ han kamŋgɨmar. Jisasɨh kamŋgɨn ahevaiz arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Avɨz osa anchɨ ndɨn ondɨhore ŋgarɨwɨmŋgɨmar hamb ndɨn kamŋgɨmar. Ndɨh wan arɨmŋgɨmar. Yaŋarɨv arunjarmen ai injambɨr handɨh ñɨhɨri nandɨv kamŋgɨmbɨri arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Avɨz, Jisasɨv osa anchɨ han kamar. Uñɨman ihɨnd yaŋ namunj amar. ");
INSERT INTO anh_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ave mbɨ wɨram akŋ anchɨ akŋ hamb ndɨn ondɨhore ŋgarɨwɨmŋgɨmar han wehɨrehɨr ñi kamar. Mban ihɨnd yaŋ namunj amar. ");
INSERT INTO anh_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Osa anchɨ hamb Yakŋ Ohɨrand ya njɨhamŋgɨj han ndɨŋ ihɨnd yaŋunj namunj amar. ");
INSERT INTO anh_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Mach ave, Jisasɨv yamb ohɨra ondɨhondɨh ampaŋ ñi ekwaŋg ya sɨkamar. Sɨkazand wɨram akŋ anchɨ akŋ ohɨron hamb ai ndɨn ondɨhorɨmŋgɨmar. Az Jisasɨv han we utɨŋg unchaŋ ŋkwuhi ŋkañɨz, wɨram akŋ anchɨ akŋ hamb yamb ampa ikwɨmun ai ñɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jisasɨv ndɨŋ ya ahɨmb akŋ han sɨkanj. Ave mach, ya ahɨmb han mbanave kamar. ");
INSERT INTO anh_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Ndɨh wamŋgɨn amar. Wɨram emŋga hamb wit nor han aporɨŋɨn are war unchaŋ omɨr amar. ");
INSERT INTO anh_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","We wit nor han aporɨzand, hanaveaŋg empasamɨŋ ŋgorahɨrɨz apa hamb ai naŋgamɨmŋgɨmɨr amar. ");
INSERT INTO anh_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mach, wit nor hanaveaŋg nsɨham mpɨŋ ŋgorahɨrɨmŋgɨmɨr amar. Isa ohɨra kamah raz pams haŋon ahamŋgɨmɨr amar. ");
INSERT INTO anh_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kɨrɨm ntɨr omanenta kazɨŋgw mah raz, rapɨr hamb aharai kɨraz mɨŋam mahɨmŋgɨmɨr amar. ");
INSERT INTO anh_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mach, wit nor hanaveaŋg kɨrɨpahe ŋkɨraŋ ŋgorahɨrɨmŋgɨmɨr amar. Avɨz kɨrɨpahe hamb awarohe asi ŋambɨŋgwɨz mbɨ nor mɨŋgwɨndɨramŋgɨm amar. ");
INSERT INTO anh_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mach, wit nor hanaveaŋg isupɨr imbɨrɨŋ ŋgorahɨrɨmŋgɨmɨr hamb mbɨ omanenton ahamŋgɨmɨr amar. Omanenton ahe ohɨrare ñi nor omanenton ŋgwɨmŋgɨmɨr amar. Hanaveaŋg 30 ŋgwɨmŋgɨmɨr, hanaveaŋg 60, hanaveaŋg 100 ŋgwɨmŋgɨmɨr amar. ");
INSERT INTO anh_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Mach, Jisasɨv ndɨŋ kamar. Ndɨh wamŋgɨn amar. Wɨram njɨhinsɨnd hamb mbɨ njɨhamŋgɨz amar. ");
INSERT INTO anh_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Mach az, wɨram akŋ anchɨ akŋ hamb etomŋgɨz mach raz, osa anchɨ Jisas hanave ñɨmŋganj hamb sezɨr oman ŋkiŋkiŋg undɨmajɨvamen, mbɨ Jisasɨh ya ahɨmbɨnd ondo handɨv amarɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","12","Amarɨmŋgɨz kamar. Yakŋ Ohɨrav osa anchɨ hanaveaŋg ŋɨmbɨz mbɨkɨr kwɨŋ ñɨndɨramŋgi amar. Handɨv Yakŋ Ohɨrand ya mbɨkɨr mpɨ unchaŋ ñi han, han Yakŋ Ohɨrav andɨŋ ndɨh eŋgwi amar. Osa anchɨ injambɨrɨnd hamb mbɨ nend amar. Mbɨ werɨndɨramŋgiaŋg, kɨrɨm mbɨ hanɨhan han omanenta mɨwandɨramŋgɨm amar. Ave mbɨ ya ohɨron njɨhamɨndɨramŋgiaŋg, kɨrɨm mbɨ ya ondo kehan mɨwamŋgɨrɨm amar. Mbɨ hanave re imbɨr mpɨ itɨmaimŋgɨmɨr oh a amar. Nend amar. Handɨv Yakŋ Ohɨrav mbɨndɨŋ enta kɨvah han musɨndɨram amar. Handɨv re nzɨ osa anchɨ injambɨrɨnd han ya ahɨmbŋam kajin amar. ");
INSERT INTO anh_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Mach, Jisasɨv ndɨŋ kamar. Amɨ ya ahɨmbɨnd ondo mban mɨwamŋgɨrɨm toh amar. Ave amɨ ya ahɨmb akŋ emŋgemŋga han nzɨhanave wandɨramŋgɨn amar. ");
INSERT INTO anh_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Mach, wɨram wit nor apororɨnd hamb ndɨn wɨram Yakŋ Ohɨrand ya eŋgwandari haremamp amar. ");
INSERT INTO anh_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Wɨram hamb wit nor han aporɨz empasamɨŋ ŋgorahɨrɨz, apa hamb ai naŋgamɨmŋgɨmɨr han, han osa anchɨ hamb ya Yakŋ Ohɨrand han njɨhamŋgɨmɨraŋg, kɨrɨm Satanɨmb pams haŋon ai ya han ŋe hɨromɨr haremamp amar. ");
INSERT INTO anh_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Mach, osa anchɨ hanaveaŋg, ndɨŋ wit nor isa nsɨham mpɨŋ ŋgorahɨrɨmŋgɨmɨr haremamp amar. Mbɨ ya han njɨhame ŋe ŋɨñɨmbam oŋambam ñɨmŋgɨmɨr amar. ");
INSERT INTO anh_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Avɨz wɨram emŋgemŋga hamb ihɨnd ya handɨv osa anchɨ han kɨr ohɨra eŋgwe ndɨŋ enta opɨha sɨmŋgɨmɨr amar. Handɨv mbɨ yan ererɨmŋgɨmɨr amar. Mbɨ wɨndɨv mɨñɨndɨramŋgɨm amar. Nend amar. Ndɨŋ wit hamb ntɨr kazɨŋgw mah ramŋgɨmɨr haremamp amar. ");
INSERT INTO anh_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Mach, osa anchɨ hanaveaŋg, ndɨŋ wit nor kɨrɨpahe ŋkɨraŋ ŋgorahɨrɨmŋgɨmɨr haremamp amar. Mbɨ ya han njɨhamŋgɨmɨr amar. ");
INSERT INTO anh_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Kɨrɨm mbɨ hanɨhan isupɨr mbanand handɨv njɨhi aŋkarɨpɨr njɨhakɨramamŋgɨmɨr amar. Nsɨham nor hamb arɨŋ omanenta hɨrawɨz imbɨrun ñɨndɨrarɨŋ toh arar njɨhamŋgɨmɨr amar. Kɨrɨm nend amar. Ave mbɨ hanɨhan isupɨr mbanand handɨvam ntichɨmŋgɨmɨr amar. Avɨz njɨhi endɨraparam kehamb ndɨŋ irɨwazɨz ya mbanamb mamah ŋgorɨmɨr amar. ");
INSERT INTO anh_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Mach, osa anchɨ hanaveaŋg, ndɨŋ wit nor isupɨr imbɨrɨŋ ŋgorahɨrɨmŋgɨmɨr haremamp amar. Mbɨ ya han njɨhamŋgɨmɨr han, mbɨ witɨv omanenton ŋgwɨmŋgɨmɨr haremamp amar. Hanaveaŋg 30, hanaveaŋg 60, mach hanaveaŋg 100 ŋgwɨmŋgɨmɨr haremamp amar. ");
INSERT INTO anh_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Mach, Jisasɨv ndɨŋ ekwaŋg ke kamar. Wɨram hamb irɨpɨr han hɨrai nchɨ kwɨŋ ŋgamŋgɨj oh o antɨm kwɨŋ ŋgamŋgɨj oh amar. Nend amar. Mbɨ irɨpɨr han mbɨkɨr sam ñaŋ ñɨñ haŋam ŋgamŋgɨj amar. ");
INSERT INTO anh_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Wɨram hamb utuhutuh han aŋkwazɨmŋgɨz han Yakŋ Ohɨrav injambɨr ahandari amar. Wɨram hamb utuhutuh han amɨnaŋgworɨmŋgɨz hanez Yakŋ Ohɨrav injambɨr ahandari amar. ");
INSERT INTO anh_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Wɨram njɨhinsɨnd hamb mbɨ njɨhamŋgɨz amar. ");
INSERT INTO anh_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Mach, Jisasɨv ndɨŋ mbahon kamar. Amɨ ya mban njɨhame omanenta wavar amar. Amɨ hanɨhan wɨram eŋgwamŋgɨrɨn han, njɨmɨnj haŋ Yakŋ Ohɨrav andɨŋ mbɨŋ han haŋonaŋg eŋgwandari amar. Ave mbɨ andɨŋ hanaveaŋg mpaji mbah eŋgwandari amar. ");
INSERT INTO anh_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Avɨz wɨram emŋga hanɨhansɨnd han ndɨn Yakŋ Ohɨrav ekwaŋg hanaveonaŋg eŋgwandari amar. Kɨrɨm wɨram hanɨhan mah han Yakŋ Ohɨrav hanɨhan nor mbɨkɨr han mɨŋam ŋɨmbɨndari amar. ");
INSERT INTO anh_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Mach, Jisasɨv kamar. Yakŋ Ohɨrav osa anchɨ hanaveaŋg ŋɨmbɨz mbɨkɨr kwɨŋ ñɨndɨramŋgi han, han wɨram hamb wit nor han isaŋ aporɨmɨr haremamp amar. ");
INSERT INTO anh_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Az zuhɨnd rapɨrɨnd wɨram mbanamb ikwɨ ŋgañi ŋaiahazand wit nor mbanamb ahe we ohɨrarɨmɨr amar. Kɨrɨm wɨram mbanamb wit norɨv hanave ohɨrarɨj han, han mbɨ mɨwamɨr amar. ");
INSERT INTO anh_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Isavonaŋg raz kwerɨvoz ahe mach zɨŋ ampɨhamɨr amar. Ave mbɨ ohɨrare ñi apa ame nor ŋgwɨmɨr amar. ");
INSERT INTO anh_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Az wit hamb mɨŋ amaz mach raz, wit erɨherɨhɨnd iŋgi hamb ahevakarɨz wɨram mbanamb kɨrɨm erɨhamɨr amar. ");
INSERT INTO anh_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Mach, Jisasɨv ekwaŋg ke kamar. Yakŋ Ohɨrav osa anchɨ hanaveaŋg ŋɨmbɨz mbɨkɨr kwɨŋ ñɨndɨramŋgi han, han utɨman emamp amar. Handɨv arɨ ya ahɨmb han nzɨhanave kandɨrarɨŋ amar. ");
INSERT INTO anh_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","32","Yakŋ Ohɨrav osa anchɨ hanaveaŋg ŋɨmbɨz mbɨkɨr kwɨŋ ñɨndɨramŋgi han, han erampɨr mastetɨnd emamp amar. Erampɨr emŋgemŋgand nor han ohɨra amar. Mastetɨnd nor han nend amar. Mbɨkɨr nor han ntɨŋɨnd nor mɨŋ amar. Kɨrɨm wɨram hamb mastetɨnd nor han aporɨz ahe ohɨrare ñi erampɨr mɨŋam war unchand han eparɨj amar. Erampɨr kehan ena ohɨrohɨransɨnd amar. Avɨz apa hamb ai mpɨr mbɨkɨr haŋ mpɨ asɨmŋgɨj amar. ");
INSERT INTO anh_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Mach, Jisasɨv osa anchɨ han ya ahɨmb hanonaŋg hanonaŋg sɨkanj. Osa anchɨ hamb ya ahɨmb imbɨr njɨhamŋganj haŋam, Jisasɨv ndɨŋ mbahon sɨkanj. ");
INSERT INTO anh_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Mach, Jisasɨv ndɨŋ ya ahɨmbŋam sɨkanj. Kɨrɨm osa anchɨ hamb etomŋgɨz, sezɨrɨvam ndɨnmen ñɨmŋgɨz Jisasɨv ndɨŋɨh ya ahɨmbɨnd ondo han orapaizɨŋgaŋg sɨkanj. ");
INSERT INTO anh_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mach, nanempand zuh razand, yuŋk haŋonaŋg, Jisasɨv mbɨkɨr sezɨrɨh mbanave kamar. Aimŋgɨn yamb ohɨra ondɨhondɨh ŋkiŋgɨŋ evahetom amar. ");
INSERT INTO anh_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Avɨz sezɨrɨv wɨram akŋ anchɨ akŋ han erere utɨŋg Jisasɨv ñɨmar haŋ ŋkwetohe ndɨn hɨrevahomŋgɨmar. Azand, utɨŋg emŋgemŋga kehambez hanave ñɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Evahomŋgɨzand, uvika yambɨka ohɨrav ŋaiahe ichij ñɨmar. Uvika yambɨka ohɨrav ichɨz ichɨzand yamb hamb utɨŋg unchaŋ irɨzɨŋgwɨz torɨŋɨn are ramar. ");
INSERT INTO anh_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Mach, Jisasɨv utɨŋg wa handɨh ñi ikwɨ ŋgañɨmar. Nsar kwaravɨzahah han ŋgame ŋgañɨmar. Ŋgañɨz ndɨn emɨre kamŋgɨmar. Anɨŋzɨŋ entand arɨmŋgɨmar. Arɨ machun, ndɨh mandɨrarɨŋ arɨmŋgɨmar. Amɨ arɨŋ njɨhamɨn oh o nend arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Mach az, Jisasɨv ŋaiahe uvika yambɨka han aŋkarɨpɨr ke mbanave kamar. Mach, ererɨvar amar. Hanɨhaz mach uvi hamb mazand yamb hamb enta maram. ");
INSERT INTO anh_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ave mbɨkɨr sezɨrɨh amarɨmar. Amɨ utɨndɨv ezandɨkŋɨmŋgɨn amar. Amɨ njɨhi aŋkarɨpɨr mɨŋamŋgɨmbɨram amar. ");
INSERT INTO anh_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Az ndɨŋ zɨŋɨmb pɨrorɨŋgaz mbon ya mbon ya kamŋgɨmar. Wɨram mban uñɨman arɨmŋgɨmar. Mbɨ kaz uvika yambɨka hamb kɨrɨm mach ramŋgi arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Mach, Jisasɨv mbɨkɨr sezɨrmen we yamb ohɨra ondɨhondɨh Galilind ŋkiŋg handɨh evahetohe, isupɨr aiampɨra Gerasa ikwɨm handɨh ahevɨkɨrorɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Ahevɨkɨrore utɨŋg han erere ŋgahaŋkwamŋgɨz wɨram itɨ kɨvahɨnsɨnd hamb itɨ okahahɨnd aiampɨra handɨh ñi erere Jisasɨnd pɨŋ aimar. ");
INSERT INTO anh_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Wɨram kehamb itɨ okahahɨnd aiampɨra handɨh ñanj. Eŋambɨr han wɨram emŋgemŋga hamb ndɨn ŋe kɨrɨpaŋ vɨhe kɨrɨm nend ramŋganj. Ndɨn kɨrɨpa aŋkarɨpɨrɨŋez vɨhamŋganjaŋg, hanez nendaŋg. ");
INSERT INTO anh_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Wɨram aiampɨrand hamb kɨrɨpa aŋkarɨpɨrɨŋ mbɨkɨr oman andam vɨhamŋgɨzandaŋg, nend ranj. Mbɨ kɨrɨm orakazɨŋganj. Avɨz wɨram emŋgavaŋg ndɨn aminjinj han, nend ranj. ");
INSERT INTO anh_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Wɨram kehamb zuhɨnd rapɨrɨnd itɨ okahahɨnd aiampɨra handɨh ñanj. Mach aparɨma handɨhez ñɨñ kwa awarar yupɨr mbɨkɨr han nsɨham han ŋɨmbɨmb mbonaŋg ekazɨŋganj. ");
INSERT INTO anh_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Mach, wɨram mbanamb waz Jisasɨv taŋɨpɨron ñɨzand aŋɨraŋɨr ai Jisasɨnd pɨŋ andamesa mpɨrorɨzɨŋgwɨmar. ");
INSERT INTO anh_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Az Jisasɨv itɨ kɨvah han mbahon kamar. Amɨ wɨram mbanan erere etov amar. Avɨz itɨ kɨvah hamb kwa aŋkarɨpɨr aware kamar. Jisas Nan Yakŋ Ohɨra ñaŋ ohɨrand Nor amar. Amɨ yan utɨ sɨŋɨn are ain amar? Yakŋ Ohɨrav yan werɨzand nan kin amar. Amɨ yan kɨvah sɨmɨn amar. ");
INSERT INTO anh_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Avɨz Jisasɨv kamar. Amakɨr ensa han uñɨman amar. Az itɨ kɨvah mbanamb kamar. Arɨŋ ohɨron amar. Ave arɨŋɨnd ensa han Wɨram Ohɨron Aŋkwɨnd amar. ");
INSERT INTO anh_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ave mbɨ mbahon mbahon amarɨmar. Ave amɨ arɨŋ kiaŋgwɨn isupɨr mban erere etomɨrɨŋ amar. ");
INSERT INTO anh_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Mach, mɨra untɨm ohɨra hamb aparɨma ikwɨm handɨh ñɨhɨri nanan ndahɨrɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Az itɨ kɨvah kɨvah hamb mɨra untɨm ohɨra han we Jisasɨh mbahon mbahon mbanave kamŋgɨmar. Arɨŋ kan we mɨra untɨm ohɨra keŋ ŋgwevetom arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Az Jisasɨv kamar. Aria amar. Amɨ we ŋgwevetovar amar. Mach, mbɨ hanave kaz itɨ kɨvah kɨvah mbanamb wɨram mban erere we mɨra untɨm ohɨra mbanaŋ pamuh pamuh rar ŋgwevetomŋgɨmar. Ŋgwevetomŋgɨz mɨra untɨm ohɨra mbanamb ŋondɨrahe aŋkarɨpɨron aŋɨraŋɨr we yamb isantu handɨh pɨraŋgore yamb unchaŋ kŋirorɨŋgwɨmŋgɨmar. Kŋirorɨngwi yamb ne mamŋgɨmar. Mach, mɨra untɨm ohɨra han mbanave 2000. ");
INSERT INTO anh_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Mach, mɨra mbanamb hanavɨmŋgɨz wɨram kɨra mɨra wehɨrehɨrɨnd hamb kɨrɨm kɨrorɨmŋgɨmar. Kɨrore we osa anchɨ aiampɨrand han, mach osa anchɨ aiampɨra injambɨr ñɨmŋganj hanez enta Jisasɨv sɨmar handɨv ya kamŋgɨmar. Kamŋgɨz osa anchɨ hamb han njɨhame mbɨ han waŋɨn are aimŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Osa anchɨ hamb ai Jisasɨnd pɨŋ ahevɨkɨrore wamŋgɨz wɨram Jisasɨv itɨ kɨvah kɨvah kiaŋgworaŋgwɨmar hamb ndɨnmen ñɨmar. Njɨhi mbɨkɨr hamb uyakaz mbɨ imɨn epe ŋkañɨmar. Mach, osa anchɨ hamb han we ezandɨkŋɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Az wɨram mɨra wehɨrehɨrɨnd hamb Jisasɨv wɨram itɨ kɨvahɨnsɨnd han mach mɨra akŋ han enta hanave sɨz wamŋgɨmar handɨv osa anchɨ han yaya han sɨkamŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Mbɨ ya han kamŋgɨz osa anchɨ hamb njɨhame ŋondɨrahe Jisasɨh mbahon mbahon amarɨmŋgɨmar. Amɨ isupɨr arɨŋɨnd mban erere ui emŋgaŋ imbɨr etomɨn oh arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Az Jisasɨv han njɨhame ŋaiahe etoŋɨn are utɨŋg unchaŋ ŋkwuzand wɨram Jisasɨv itɨ kɨvah kiaŋgworaŋgwɨmar mbanamb ai Jisasɨh amarar kamar. Nzɨ nan imbɨr mpehɨromɨñ oh a amar. ");
INSERT INTO anh_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Az ndɨn kamar. Nend amar. Amɨ amakɨr oramɨŋ we amakɨr zɨŋgɨr han kav amar. Anɨŋnsar Ohɨrav yan akŋɨn ñi yan omanenta sɨndɨsi arar kav amar. ");
INSERT INTO anh_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Az mach, wɨram mbanamb ŋaiahe isupɨr Dekapolis handɨh we Jisasɨv ndɨn omanenta sɨmar handɨv kah ndamar. Avɨz osa anchɨ hamb njɨhame njɨhi osapɨr njɨhakɨramŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Mach, Jisasɨv utɨŋg mban ŋe ekwaŋg yamb ohɨra ondɨhondɨh ŋkiŋg evahaimar. Evahai ahevakare yamb ampaŋ ñɨzand wɨram akŋ anchɨ akŋ hamb ai aŋkwezawi ndɨn ondɨhore ñɨhɨrɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ndɨn ondɨhore ñɨmŋgɨzand wɨram emŋga hamb aimar, mbɨkɨr ensa Jairus. Ndɨn wɨram anɨŋnsar Yakŋ Ohɨrand marɨvai oramɨnd. Mbɨ ai Jisas we ndɨn pɨŋ andamesa mpɨrorɨzɨŋgwɨmar. ");
INSERT INTO anh_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Mbɨ mbahon mbahon Jisas mbanavav amarɨmar. Nanch ihɨnd hamb mahoror ohɨransɨnd ñɨñmbɨri amar. Ave mbɨ ndɨhon mandari toh amar. Amɨ ai amakɨr omanaka ndɨn insɨŋ ŋgamɨn mahoror mbɨkɨr hamb kwevɨrɨz mbɨ imbɨrun ñɨndari amar. ");
INSERT INTO anh_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Az Jisasɨv ŋaiahe ndɨnmen omar. Oz ozand wɨram akŋ anchɨ akŋ hamb ndɨn mpehɨrohe ikwɨm ikwɨm ondɨhore ñɨhɨrɨhɨr ndahɨrɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Mach, anchɨ emŋga hamb handɨh ñɨmar. Mbɨ ukɨnd osapɨr war oman ŋkiŋkiŋg undɨmaj ñɨmar. ");
INSERT INTO anh_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Mbɨ ukɨnd osapɨr ñɨñ imbɨr randarin arar uvita kɨrand pɨŋ ndandand nsɨham nor mɨŋam ŋkaranj. Avɨz uvita kɨra hamb ndɨn omanenta sɨmŋgɨzandaŋg, nend ranj. Uvita hamb anchɨ mban yupɨr pɨrɨvɨr mamah eŋgwamŋganj. Mahoror mbɨkɨr hamb kɨrɨm ohɨrar omar. ");
INSERT INTO anh_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Mach, osa anchɨ emŋgemŋgav Jisasɨndɨv ya kamŋgɨzand anchɨ mbanamb njɨhame njɨhi kɨrɨm ŋamar. Ŋe mbonaŋg ke mbonaŋg njɨhamɨmar. Nzɨ we Jisasɨnd yupɨr hɨrahɨr osapɨr han mparɨwaŋ mahoror ihɨnd hamb imbɨr randari amar. Hanave njɨhame mbɨ osa anchɨmen we Jisasɨh mpehɨrohe yupɨr hɨrahɨr osapɨr mbɨkɨr han mparɨwamar. ");
INSERT INTO anh_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Mparɨwaz mbɨkɨr ntɨ hamb kɨrɨm okarawɨmar. Okarawɨz mach yupɨr mbɨkɨr hamb imbɨr ñɨz anchɨ mbanamb han wamar. ");
INSERT INTO anh_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Mach, yupɨr hɨrahɨr osapɨr han mparɨwazand Jisasɨnd aŋkarɨpɨr hamb anchɨ mbanaŋ ŋgwevoz Jisasɨv han we enarɨŋge osa anchɨ han amarɨmar. Uñɨmb ihɨnd yupɨr hɨrahɨr osapɨr han mparɨwi amar. ");
INSERT INTO anh_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Az sezɨr mbɨkɨr hamb kamŋgɨmar. Osa anchɨ hamb nan ondɨhore kwaravɨzu kwaravɨzaimŋgi han wan oh arɨmŋgɨmar. Amɨ utɨndɨv kan, uñɨmb yan mparɨwi, arar kan arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Kɨrɨm Jisasɨv uñɨmb mbɨkɨr yupɨr hɨrahɨr osapɨr han mparɨwamar han waŋɨn arar handɨv mbah werɨmar. ");
INSERT INTO anh_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Werer ñɨzand anchɨ mbanamb ihɨnd mahoror hamb ndɨh mach ri arar ke ezandɨkŋɨmar. Az mbɨkɨr oman andam hamb ntahorɨzand mbɨ Jisasɨnd pɨŋ ai andamesa mpɨrorɨzɨŋgwɨmar. Mpɨrorɨzɨŋgwi ñi ndɨn kamar. Nzɨ imbɨr ñɨŋɨn are nan mparɨwin amar. ");
INSERT INTO anh_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Az Jisasɨv ndɨn kamar. Nanch amar. Amakɨr njɨhi aŋkarɨpɨr hamb raz amakɨr ukɨnd osapɨr hamb ndɨh mach ri amar. We omanenta ñɨmb amar. ");
INSERT INTO anh_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Mach, Jisasɨv hanave kazand wɨram kɨra emŋgemŋga oram Jairusɨnd hamb aimŋgɨmar. Mbɨ ai Jairusɨh wɨram anɨŋnsar Yakŋ Ohɨrand marɨvai oramɨŋ ntɨŋ ñanj han kamŋgɨmar. Amakɨr nanch hamb ndɨh mi arɨmŋgɨmar. Amɨ utɨndɨv Anɨŋzɨŋ entand han kɨr mbahon eŋgwan arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Avɨz Jisasɨv mbɨndɨŋ ya han njɨhameaŋg wɨram anɨŋnsar Yakŋ Ohɨrand marɨvai oramɨnd han kɨrɨm kamar. Amɨ ezandɨkŋɨmɨn amar. Yakŋ Ohɨrand aŋkarɨpɨr handɨv njɨhi aŋkarɨpɨr ŋe njɨhamb amar. ");
INSERT INTO anh_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Mach, hanave ke mbɨ Pita, Jems, mach Jemsɨnd ranɨr Jon hanave mpahɨroŋɨn are wɨram emŋgemŋga han erokare kamar. Amɨ mbanaŋ ñɨmbar amar. ");
INSERT INTO anh_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Mach, mbɨ we Jairusɨnd oramɨŋ ahevɨkɨrore wamŋgɨz wɨram akŋ anchɨ akŋ hamb handɨh ñi itɨ ŋgwañ ohɨra ekeh irɨwazaz ihɨrɨv ohɨra sɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Hanavav ñɨmŋgɨzand Jisasɨv oram unchaŋ ahevohe ndɨŋɨh kamar. Amɨ utɨndɨv itɨ ŋgwañ ekeh ihɨrɨv ohɨra sɨmŋgɨmbɨran amar. Nanch mbanamb mɨmam amar. Mbɨ ikwɨ ŋgañɨñɨmbɨri amar. ");
INSERT INTO anh_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Az mbɨ han njɨhame ndɨn ŋɨñ kah aŋkwamŋgɨmar. Avɨz Jisasɨv osa anchɨ han kiaŋgworaŋgwɨz mbɨ oram han erere ahevohe injambɨrɨŋ ñɨmŋgɨmar. Ahevohe ñɨmŋgɨzand Jisasɨv nanch hand mɨŋɨr wanɨr han mach sezɨr undɨmapam hanez ŋɨmbimar. Ŋɨmbi sam nanch hamb mamta me ŋgañɨmar handɨh mpahɨrahevomar. ");
INSERT INTO anh_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ave Jisasɨv omanaka mbɨkɨr han ŋgɨŋe ndɨn kamar. Talita kum amar. (Jisasɨnd ya mbanand ondo han: Nanch, nzɨ nan kin, amɨ ŋaiahav en.) ");
INSERT INTO anh_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Mach, Jisasɨv hanave kaz nanch mbanamb kɨrɨm ŋaiahe ndamar. Ndazand mbɨ han wamŋgɨz mbɨkɨr mɨŋɨr wanɨrɨnd zɨŋɨmb pɨrorɨŋgaz njɨhi osapɨr njɨhakɨramamŋgɨmar. Nanch mbanand war han oman ŋkiŋkiŋg undɨmaj. ");
INSERT INTO anh_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Mach avɨz, Jisasɨv mɨŋɨr wanɨrɨh ya aŋkarɨpɨr ke erokare kamar. Amɨ osa anchɨ emŋgemŋga han enta mban wamŋgɨn handɨv kamŋgɨmɨn amar. Amɨ nanch mban unsa kɨrɨm eŋkwanambar amar. ");
INSERT INTO anh_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Mach, Jisasɨv sezɨrmen aiampɨra mban erere Jisasɨnd aiampɨra ondo handɨh omŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","We ñi Yakŋ Ohɨrand Yuŋk Wɨr Ñɨñɨnd haŋ Jisasɨv Yakŋ Ohɨrand marɨvai oram mbanɨmb ahevohe ñi ondo ake ya sɨkamar. Ya sɨkazand osa anchɨ hamb ya mbɨkɨr han njɨhamŋgɨz ndɨŋ zɨŋɨmb pɨrorɨŋgaz kamŋgɨmar. Wɨram mban njɨhi imbɨr ya sɨkahɨnd han uñɨmb eŋgwandeŋgwi arɨmŋgɨmar. Ave njɨhi ohɨra kɨvah hɨrañɨñ ntɨŋ ŋaŋɨnd hanez uñɨmb ndɨn eŋgwandeŋgwi arɨmŋgɨmar. Ave wɨram mbanamb nzɨhanave mbɨkɨr ntɨŋ aŋkarɨpɨr sɨj arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Arɨ wɨram mban warɨrɨŋ arɨmŋgɨmar. Ndɨn wɨram oram asazɨnd arɨmŋgɨmar. Ndɨn Mariand nor arɨmŋgɨmar. Mbɨkɨr runjɨr han Jems Josep Judas mach Saimon arɨmŋgɨmar. Mbɨkɨr runjɨr nanch kɨra hambez arɨŋmen mbanɨmbon ñɨmŋgi arɨmŋgɨmar. Ave ndɨn mpɨ pɨr re emakoraŋgwɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Az Jisasɨv ya han njɨhame kamar. Osa anchɨ aiampɨra emŋgemŋgand hamb wɨram Yakŋ Ohɨrand ya injambɨr ahe kahɨnd hand ensa han ŋambiahamŋgɨj amar. Osa anchɨ mbɨkɨr aiampɨrand hamb mbɨ nend amar. Untɨm pamɨnd mbɨkɨr mach mbɨkɨr zɨŋgɨr hambez ensa mbɨkɨr han mɨŋambiahamŋgɨrɨm amar. ");
INSERT INTO anh_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Mach, Jisasɨv handɨh ñi ntɨŋ aŋkarɨpɨr ohɨron mɨŋam. Mbɨ osa anchɨ mahororɨnsɨnd pamuh pamuh han mbɨkɨr omanaka insɨŋ ŋgamam mahoror mbɨndɨŋ han omanenta sɨmar. ");
INSERT INTO anh_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Mbɨ waz aiampɨra ondond hamb njɨhi aŋkarɨpɨr njɨhamɨmah ramŋgɨz handɨv mbɨ njɨhi osapɨr njɨhakɨramamar. Ave mach, mbɨ aiampɨra han erere aiampɨra emŋgemŋga ikwɨm ñɨmŋgi handɨh we ndandand ya sɨkanj. ");
INSERT INTO anh_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","11","Mach ave, mbɨ ŋaiahe sezɨr oman ŋkiŋkiŋg undɨmaj han oreŋgɨz aimŋgɨmar. Aimŋgɨz Jisasɨv ndɨŋ undɨmaj undɨmaj rar omŋgɨz are kamar. Nzɨ andɨŋ ensa ohɨra aŋkarɨpɨr itɨ kɨvah kiaŋgworaŋgwaŋgwɨndɨv ndɨh eŋgwin amar. Amɨ oŋɨn are aipa mporor ndand han, amɨ han imbɨr hɨrondɨramŋgɨn amar. Amɨ mɨrupɨr hɨrɨmbɨvar amar. Kɨrɨm imɨn osapɨr undɨmaj han hɨramŋgɨmɨn amar. Pamuh pamuh mach amar. Hanɨhan emŋga han, eŋka, aŋan, nsɨham nor, han hɨromŋgɨmɨn amar. Mach, amɨ aiampɨra emŋgaŋ ahevɨkɨrore oram unchaŋ ahevondɨramŋgɨn han oram haŋam ñɨmbar amar. Oram haŋ ñɨñ ndem aiampɨra han etoŋɨn are oram han ererɨvar amar. Az aiampɨra emŋgand hamb andɨŋ ŋɨmbi oram mbɨndɨŋ hɨro mah randɨramŋgi han, ave amandɨŋ ya njɨhamɨmah randɨramŋgi han, mach aiampɨra han erere etovar amar. Etoŋɨn are isarur han andamaka amandɨŋ ñɨndari kehan ŋɨmbunjɨnzɨŋge etovar amar. Mach, osa anchɨ aiampɨrand hamb han we kandɨramŋgi amar. Arɨ enta opɨha sɨrɨŋ arɨŋ enta mban mbɨrame etomŋgi arar kandɨramŋgi amar. Ave Jisasɨv ndɨŋ kamar. Amɨ undɨmaj undɨmaj rar ovar amar. Az mbɨ ŋondɨrahe ramŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Mbɨ we osa anchɨ aiampɨra emŋgemŋgand han ya eŋgweŋgw kamŋganj. Amɨ mpɨ itɨmaivar arɨmŋganj. ");
INSERT INTO anh_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Ave mbɨ itɨ kɨvah akŋ han kiaŋgworaŋgw osa anchɨ mahororɨnsɨnd han mbɨŋgɨr yamb haŋ ampɨhambɨh mahoror mbɨndɨŋ han omanenta sɨmŋganj. ");
INSERT INTO anh_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Mach ave, osa anchɨ hamb utuhutuh Jisasɨv sɨmar handɨv yaya kamŋgɨmar. Avɨz anɨŋnsar ohɨra Herotɨv ya han njɨhamɨmar. Osa anchɨ hanaveaŋg Jisasɨndɨv kamŋgɨmar. Ndɨnɨh Jon, wɨram osa anchɨ han yambɨŋ ŋazɨkŋirɨŋgwɨŋgw ŋambiahahɨnd arɨmŋgɨmar. Mbɨ maz Yakŋ Ohɨrav ndɨn ekwaŋg ŋambiahar arɨmŋgɨmar. Handɨv mbɨ ntɨŋ aŋkarɨpɨr ŋaŋmbɨri arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mach, hanaveaŋg ndɨn Elaija arɨmŋgɨmar. Mach, hanaveaŋg ndɨn wɨram eŋambɨr Yakŋ Ohɨrand ya injambɨr ahe kahɨnd emamp arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Mach, osa anchɨ hamb Jisasɨndɨv kamŋgɨz Herotɨv han njɨhame kamar. Jonɨnd ŋgwɨrɨmb mɨŋam akoken han Yakŋ Ohɨrav ndɨn ekwaŋg ŋambiahar toh amar. ");
INSERT INTO anh_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","20","Eŋambɨr haŋ Herotɨv mbɨkɨr ranɨr Filipɨnd anchɨ han ŋoke ŋe mbondɨv hɨrañɨmar. Anchɨ kehand ensa han Herodias. Mach, Jonɨmb han njɨhame Herotɨh kamar. Amɨ aranarɨnd anchɨ ŋoke amondɨv hɨrañɨn han, han enta kɨvah mɨŋ amar. Handɨv Yakŋ Ohɨrav chonj ohɨra ŋgamɨmar amar. Avɨz Herodiasɨv han njɨhamɨz mbɨkɨr mpɨ hamb Jonɨh pɨr razand ndɨn pɨrɨtɨm emamp uŋganj. Mbɨ ndɨn mamta orɨŋɨn arar ndeaŋg, kɨrɨm nend. Az Herotɨv Herodiasɨv imbɨr ñɨz are mbɨkɨr aŋkwɨnd han kaz we Jonɨh aŋgwore ŋe hɨrohe oram kɨvahɨŋ ŋgame kɨrɨpa aŋkarɨpɨrɨŋ kɨravɨhamŋgɨmar. Avɨz Herotɨv waz Jonɨh wɨram imbɨrpamun. Mbɨ Yakŋ Ohɨrand yaŋam uŋkɨranj. Avɨz Herotɨv ndɨn ezandɨkŋɨnaŋg kɨrɨm ndɨn omanenton werer hɨrañanj. Mbɨ Jonɨnd ya han njɨhame njɨhi osapɨr njɨhakɨramanj. Az Jonɨmb ya han kazand akŋɨn apar njɨhamanj. Ave Herotɨv Jonɨh omanenta wehɨrɨz Herodiasɨv nzɨhanave ndɨn mamta orɨmɨr. ");
INSERT INTO anh_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","22","Mach ave, yuŋk emŋga haŋ Herodiasɨv waz Jon mamta ororɨnd empasam hamb ahevakarɨmar. Yuŋk ohɨra Herotɨnd mɨŋɨr hamb ndɨn akarɨmar kehamb ahevakarɨz Herotɨv nchamb ohɨra ŋgamɨmar. Ave mbɨ wɨram kɨra ndɨn gavmand ntɨŋ hɨrawɨmŋganj hamb, mach anɨŋnsar kɨra aŋkwɨnd, mach ohɨra kɨra isupɨr Galilind hanave oreŋgɨz ndɨn pɨŋ aimŋgɨmar. Ai ŋgarɨwi unsa namŋgɨzand Herodiasɨnd nanch hamb ahevai marɨvai insɨmar. Insɨzand Herotɨv wɨram kɨra mbanmen wamŋgɨz imbɨrpam ñɨmar. Mach, marɨvai insɨ mach raz Herotɨv nanchŋɨr han kamar. Amɨ yan utuhutuhɨndɨv kan nan kɨrɨmam eŋgwandarin amar. ");
INSERT INTO anh_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ave mbɨ aŋkarɨpɨr kamar. Ñaŋ ohɨra amar. Amɨ yan kan nzɨ ihɨnd isupɨr ohɨra undɨmaj han orake emŋga ihɨnd emŋga nan eŋgwandarin amar. ");
INSERT INTO anh_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Avɨz nanchŋɨr mbanamb ahevohe mɨŋɨrɨh amarɨmar. Nzɨ we kaŋ yan utɨman eŋgwaz amar. Az mbɨkɨr mɨŋɨrɨv kamar. Amɨ Herotɨh kan mbɨ Jonɨnd nsar han ŋe nan eŋgwaz amar. ");
INSERT INTO anh_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mach, mbɨ ŋaiahe Herotɨnd pɨŋ aŋɨraŋɨr we kamar. Navɨzandon Jon osa anchɨ han yambɨŋ ŋazɨkŋirɨŋgwɨŋgw ŋambiahahɨnd hand nsar han ŋe torɨŋ ŋgwame yan eŋgwav amar. ");
INSERT INTO anh_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Az Herotɨv ya han njɨhamɨz ndɨn mpɨ mbɨkɨr hamb kɨr kɨvah ñɨmar. Avɨz nend. Mbɨkɨr ya aŋkarɨpɨr kamar handɨv njɨhame kamar. Nzɨ aŋkarɨpɨr kaŋ wɨram emŋgemŋga mbanamb ndɨh njɨhamŋgɨndɨŋgi amar. Nzɨ nanchŋɨr mbanand ya han ontavɨzundarin han ampi ohɨra ŋandarin amar. ");
INSERT INTO anh_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","28","Ave mbɨ Jonɨnd nsar han hɨraindɨv kaz aŋkwɨnd emŋga hamb oram kɨvahɨŋ we Jonɨnd ŋgwɨrɨmb han akokamar. Akoke nsar mbɨkɨr han ŋe torɨŋ ŋgwame hɨrai nanchŋɨr han eŋgwamar. Eŋgwaz mbɨ hɨrohe mbɨkɨr mɨŋɨr eŋgwamar. ");
INSERT INTO anh_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Mach, Jonɨnd sezɨr hamb yansɨ han njɨhame mbɨ ai yikwɨra mbɨkɨr han ŋe hɨrohe nsɨham mɨn ŋgwamŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Mach ave, Jisasɨnd sezɨr hamb ekwaŋg ai ndɨnɨh ntɨŋ mbɨ ŋamŋgɨmar mach ya osa anchɨ sɨkamŋgɨmar handɨv kamŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Az osa anchɨ hamb mbahon oruh airuh ramŋgɨz, Jisasɨv mbɨkɨr sezɨrmen nzɨhanave unsa han namŋgɨmɨr. Avɨz Jisasɨv ndɨŋ kamar. Aronam osa anchɨ han erere isupɨr wɨram mah haŋ we wɨr ñɨm amar. ");
INSERT INTO anh_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ave mbɨ ŋaiahe utɨŋg han ŋe mbon ikumun isupɨr wɨram mah handɨh evahomŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Evahomŋgɨzand wɨram akŋ anchɨ akŋ aiampɨra emŋgand emŋgand hamb ndɨŋ wamŋgɨmar. Wamŋgɨz ŋondɨrahe aŋɨrɨmbɨri we mboz isupɨr Jisasɨv sezɨrmen omŋgɨmar handɨhonaŋg ahevɨkɨrorɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Ahevɨkɨrore ñɨmŋgɨzand Jisasɨv ahevakare waz wɨram akŋ anchɨ akŋ ohɨra ñɨmŋgɨmar. Mach, Jisasɨv waz osa anchɨ hamb sipsip wɨram anɨŋnsar mbɨ werer hamb mɨñɨm emamp ñɨmŋgɨmar. Handɨv re ndɨn akŋɨn ahaz ŋaiahe ndɨŋ ya akŋ ai akŋ ondo ake sɨkamar. ");
INSERT INTO anh_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Sɨke hɨrohe rapɨr hamb ondo ake ŋkwuzand sezɨrɨv ndɨn pɨŋ ai kamŋgɨmar. Rapɨr hamb ndɨh ŋkwumbɨri arɨmŋgɨmar. Isupɨr mban wɨram mah arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Amɨ osa anchɨ han kan aiampɨra emŋgemŋga mach aiampɨra nor ntɨŋɨnd ntɨŋɨnd ikwɨm ñɨmŋgi kehaŋ we unsa han uŋkɨ eŋgwe namŋgɨz arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Az Jisasɨv ndɨŋ kamar. Amonaŋg ndɨŋ eŋkwanambar amar. Az kamŋgɨmar. Arɨ 200 silva han hɨrohe uŋkɨ ore hɨrai ndɨŋ eŋkwanam are kan oh a arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Avɨz ndɨŋ kamar. Amɨ eŋka han nzɨhanave hɨrañɨmŋgɨn amar. We wavar amar. Az mbɨ we eŋka han amehe ai Jisasɨh kamŋgɨmar. Arɨ eŋka han oman ŋkɨpam mach oma uŋguŋg undɨmaj hɨrañɨrɨŋ arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Mach, Jisasɨv mbɨkɨr sezɨrɨh kamar. Osa anchɨ han kamŋgɨn, tamar tamar aŋkwezawaw kɨzar ŋkwɨrɨŋ insɨ mbanaŋ ŋgarɨwɨmŋgɨz amar. ");
INSERT INTO anh_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Avɨz osa anchɨ hamb tamar tamar aŋkwezawi hanaveaŋg 100 mach hanaveaŋg 50 ŋgarɨwɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Mach, Jisasɨv eŋka oman ŋkɨpam hand oma uŋguŋg undɨmaj hand ŋɨmbi ñaŋ sɨhawarohe were Yakŋ Ohɨrah ya imbɨr eŋgwe eŋka han ŋaŋepev sezɨrɨv osa anchɨ han eŋkwanamŋgɨz are ndɨŋ eŋgwamar. Eŋgwe oma uŋguŋg hanez ŋe osa anchɨ handɨv ambɨrorɨmar. ");
INSERT INTO anh_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Avɨz osa anchɨ hamb unsa han namŋgɨz mpɨkarɨmar. ");
INSERT INTO anh_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Mbɨ namŋgɨz mach raz, unsa ekeka osa anchɨ hamb ererɨmŋgɨmar han, han sezɨrɨv ŋɨmbi oman ŋkiŋkiŋg undɨmaj iŋkimpiñɨŋ mpamŋgɨz torɨmar. ");
INSERT INTO anh_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Wɨram akŋ eŋkand omand namŋgɨmar han 5000. ");
INSERT INTO anh_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ave mach, Jisasɨv sezɨrɨh kamar. Amɨ utɨŋg han ŋe injore yamb ohɨra ondɨhondɨh ŋkiŋg aiampɨra Betsaidaŋ evahovar amar. Nzɨ ñi osa anchɨ mban kaŋ etondɨramŋgi amar. Az sezɨrɨv ŋondɨrahe utɨŋg han ŋe evahoŋɨn are ramŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Mach, Jisasɨv osa anchɨ han kaz omŋgɨzand Yakŋ Ohɨra ahaz orɨŋɨn are isupɨr aparɨmansɨnd haŋ omar. ");
INSERT INTO anh_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Mach, nanempand zuh haŋ utɨŋg hamb yamb ohɨra ondɨhondɨh uhɨmɨŋun ñɨzand Jisasɨv isaŋ mbon ikumun ñɨmar. ");
INSERT INTO anh_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","50","Ñi wehɨrɨzand uvika hamb utɨŋg nsarɨŋon ichavɨzuŋɨn azand sezɨrɨv ichij pɨrasɨmŋgɨmar. Mach, hɨrohe ui hamb ŋakaŋɨn azand, Jisasɨv yamb insɨŋ ai ndɨŋ kivɨŋɨn azand sezɨrɨv ndɨn wamŋgɨmar. Mbɨ ndɨn we njɨhamŋgɨmar. Mban itɨ toh are ŋgwañ ekeh ezandɨkŋahambɨmŋgɨmar. Ezandɨkŋahambamb ñɨmŋgɨzand Jisasɨv ndɨŋ kamar. Amɨ aŋkarɨpɨr ñɨmbar amar. Han nzon amar. Ezandɨkŋɨmŋgɨmɨn amar. ");
INSERT INTO anh_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Hanɨh are utɨŋg unchaŋ ŋkwuhi sezɨrmen ñɨzand uvika ichɨmar hamb kɨrɨm okarawɨmar. Okarawɨz sezɨrɨv han wamŋgɨz ndɨŋ zɨŋɨmb pɨrorɨŋgaz yamah aimah ñɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Jisasɨv eŋka atakŋaŋ osa anchɨ eŋgwarɨmbɨmar hand ondo han mɨwamŋgɨm. Nend. Njɨhi mbɨndɨŋ hamb moyakam. ");
INSERT INTO anh_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Mach, Jisasɨv sezɨr mbɨkɨrmen yamb ohɨra ondɨhondɨh ŋkiŋg evahohe isupɨr Genesaretɨŋ ahevɨkɨrorɨmŋgɨmar. Ave utɨŋg han ŋinchi hɨrawarohe mpamŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Utɨŋg han mpe ŋgahaŋkwamŋgɨz osa anchɨ hamb Jisasɨh we kamŋgɨmar. Jisasɨv ndɨh ai arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Mbɨ aiampɨra emŋgemŋga isupɨr kehandɨh oruh airuh ramŋgɨmar. Ave kamŋgɨmar. Jisasɨv ndɨh ai aiampɨra emŋga handɨh ñi arɨmŋgɨmar. Avɨz wɨram aiampɨrand hamb ya han njɨhame osa anchɨ mahororɨnsɨnd han ŋe iwɨnŋkarɨŋ izɨŋgwɨŋgw Jisasɨnd pɨŋ hɨraimŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Avɨz aiampɨra nor, aiampɨra ohɨra, isupɨr nzɨmoh nzɨmoh Jisasɨv omar kehaŋ osa anchɨ mahororɨnsɨnd han hɨrai aiampɨra uhɨm handɨh aŋkwezawɨmŋganj. Ave mahororɨnsɨnd hamb Jisasɨh mbahon mbahon amarɨmŋganj. Eran arɨ amakɨr yupɨr hɨrahɨr osapɨr ñɨm han mparɨwarɨwam arɨmŋganj. Ave wɨram akŋ anchɨ akŋ mahororɨnsɨnd hamb hanaveam re mach imbɨr ramŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","Mach, wɨram untɨm Judand mɨŋam hamb nchonjɨrɨnd entaŋam mpehɨromŋganj. Mbɨ nchonjɨrɨnd enta han mpehɨroŋɨn are mbɨndɨŋ omanampɨra han usɨmah re unsa mɨnamŋgɨrɨm. Az wɨram untɨm Farisind hamb nchonjɨrɨnd entaŋam aŋkarɨpɨr mpehɨromŋganj. Mbɨ uŋkɨ eŋgweŋgwɨnd ampɨraŋ we ekwaŋg ai yamb imah re unsa mɨnamŋgɨrɨm. Mbɨ enta emŋgemŋga nchonjɨrɨv sɨmŋganj haŋam nchɨ tor sɨhomɨŋai yamb nand akŋ usuzɨnd enta han mpehɨromŋganj. Mach ave, wɨram kɨra ya Mosesɨnd injambɨr ahe sɨkahɨnd hamb, wɨram untɨm Farisind hamen awakŋi aiampɨra ohɨra Jerusalem erere Jisasɨnd pɨŋ aimŋgɨmar. Mbɨ ai wamŋgɨz Jisasɨnd sezɨr hamb mbɨndɨŋ omanampɨra ŋoz usi mɨnamŋgɨm, kɨrɨm mbɨ Yakŋ Ohɨrand ampɨn insɨŋ enta kɨvahɨnsɨnd ñi namŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Avɨz mbɨ Jisasɨh amarɨmŋgɨmar. Utɨndɨv amakɨr sezarɨv nchonjɨrɨnd enta han mpehɨromah ramŋgi arɨmŋgɨmar. Mbɨ mbɨndɨŋ omanampɨra ŋoz usi mɨnamŋgɨm ave mbɨ Yakŋ Ohɨrand ampɨn insɨŋ enta kɨvahɨnsɨnd ñi namŋgɨj arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Az Jisasɨv ndɨŋ kamar. Andɨŋ wɨram kɨra yosand amar. Amɨ ya imbɨr akŋ kamŋgɨrɨnaŋg, kɨrɨm amɨ ya kehan mɨmpehɨromŋgɨrɨm amar. Aisaiah, wɨram Yakŋ Ohɨrand ya injambɨr ahe kahɨnd hamb, mbɨ andɨŋndɨv mɨŋun kamar amar. Yakŋ Ohɨrav Aisaiah kaz ya mbɨkɨr han njɨhame hanave mpamar. Osa anchɨ kehamb ihɨnd ensa han mbɨndɨŋ karupɨrɨŋon mamah ŋambiahamŋgɨj arar mpamar amar. Kɨrɨm mbɨ mbɨndɨŋ mpɨ han yandɨv meŋgwamŋgɨrɨm arar mpamar amar. ");
INSERT INTO anh_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Mbɨ wɨramɨnd entaŋam sɨkamŋgɨj arar mpamar amar. Ave mban Yakŋ Ohɨrand enta arar kamŋgɨj arar mpamar amar. Ave mbɨ handɨv ihɨnd ensa han mamah oreŋgeŋg yan ŋambiahamŋgɨj arar mpamar amar. ");
INSERT INTO anh_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Amɨ Yakŋ Ohɨrand enta han erere wɨramɨnd entaŋam aŋkarɨpɨr mpehɨromŋgɨrɨn amar. ");
INSERT INTO anh_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Mach, Jisasɨv mbahon kamar. Amandɨŋ entaŋam mpehɨroŋɨn are, amɨ handɨv Yakŋ Ohɨrand enta han ontamŋgɨrɨn amar. ");
INSERT INTO anh_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mach, Mosesɨv kamar amar. Amɨ yaŋar onarɨnd kwɨŋ ñi mbɨndɨŋ njɨhiŋam ŋamb arar kamar amar. Mach, Mosesɨv mbahon kamar amar. Wɨramb mɨŋɨr wanɨrɨh ya kɨvah kandari hamb, mbɨ maz arar kamar amar. ");
INSERT INTO anh_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Kɨrɨm nend amar. Amɨ Yakŋ Ohɨrand ya han njɨhamɨmah re mbanave kamŋgɨrɨn amar. Wɨramb mɨŋɨr wanɨrɨh kaŋɨnj, nzɨ hanɨhan ihɨnd han ŋe andɨŋ imbɨr hɨrawɨmɨñaŋg, kɨrɨm nend arar kaŋɨnj arar kamŋgɨrɨn amar. Nzɨ hanɨhan ihɨnd han ŋe Yakŋ Ohɨra ndɨh eŋgwin arar kaŋɨnj arar kamŋgɨrɨn amar. ");
INSERT INTO anh_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Wɨram mbanamb hanavɨz amɨ ndɨn kamŋgɨrɨn amar. Amɨ hanɨhan amakɨr han ŋe yaŋar onar hɨrawɨmɨn arar kamŋgɨrɨn amar. ");
INSERT INTO anh_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Mach, enta amɨ sɨmŋgɨrɨn hamb raz, amɨ Yakŋ Ohɨrand ya han ŋambiŋgwɨmŋgɨz, Yakŋ Ohɨrand ya hamb aŋkarɨpɨr mah amar. Amɨ enta akŋ pɨr akŋ han si wɨram emŋgemŋga han hanavav sɨkamŋgɨrɨn amar. ");
INSERT INTO anh_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Mach, Jisasɨv ekwaŋg wɨram akŋ anchɨ akŋ han oreŋgɨz aimŋgɨmar. Aimŋgɨz kamar. Amɨ mɨŋam ihɨnd ya njɨhame omanenta wavar amar. ");
INSERT INTO anh_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Hanɨhan han wɨramb ŋe namŋgɨj han, wɨramb han ŋe ne wɨram kɨvah mahevakarɨndɨram amar. Njɨhi kɨvah kɨvah wɨramb njɨhamŋgɨj han, wɨramb njɨhi kehan njɨhame si wɨram kɨvah ahevakarɨndari amar. ");
INSERT INTO anh_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Mach, Jisasɨv wɨram akŋ anchɨ akŋ han erere oramɨŋ we ahevohe ñɨzand sezɨrɨv ndɨn ya ahɨmbɨnd ondo handɨv amarɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","Az ndɨŋɨh kamar. Andɨŋez njɨhi mah oh a amar. Amɨ mɨwamŋgɨrɨm toh amar. Mɨrunsa injambɨrɨŋ ñɨz wɨramb ŋe namŋgɨj han, wɨramb han ŋe ne wɨram kɨvah mahevakarɨndɨram amar. Mɨrunsa kehamb mpɨ unchaŋ we akand empaŋam we akoramɨŋ oj amar. Ave unsa nanɨnd kehamb wɨram kɨvah mɨsɨrɨm amar. (Jisasɨnd ya ondo han mbanɨmb: Yakŋ Ohɨrav waz mɨrunsa endɨraparam nanɨnd han mbɨkɨr ampɨn insɨ han imbɨrvamun ñɨj.) ");
INSERT INTO anh_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ave Jisasɨv mbahon kamar. Njɨhi kɨvah kɨvah wɨramb njɨhamŋgɨj han, wɨramb njɨhi kehan njɨhame si wɨram kɨvah ahevakarɨndari amar. ");
INSERT INTO anh_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","23","Njɨhi kɨvah kɨvah, osamen anchɨmen ndand, akɨm ŋaŋ, wɨram mamta oror, ntichij, enta kɨvah kɨvah, wɨram yosa kahɨnd, yahɨrɨz asambar ndand, ambarawɨrɨwɨr, ya mapɨŋ kah, Yakŋ Ohɨra yarahe kah, nzonam arar kah, wɨram njɨhi mah Yakŋ Ohɨrandɨv mɨnjɨhamɨrɨm, han enta kɨvah kɨvah wɨramb njɨhamŋgɨj kehamb wɨram kɨvah sɨj amar. ");
INSERT INTO anh_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Mach, Jisasɨv ŋaiahe isupɨr mban erere isupɨr aiampɨra Tairɨnd handɨh omar. We oram ahevohe ñi ndɨŋ erokare kamar. Wɨram emŋgavaŋg kamŋgɨmɨn amar. Jisasɨv mbah ñɨñmbɨri arar kamŋgɨmɨn amar. Kɨrɨm nend. Osa anchɨ hamb Jisasɨv oramɨŋ ñɨmar han, han wamŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Mach, anchɨ emŋga nanch mbɨkɨr han itɨ kɨvahɨnsɨnd hamb Jisasɨv ñɨmar han njɨhamɨmar. Anchɨ kehan untɨm Judand mah. Ndɨn untɨm Fonisiand isupɨr Siriand. Az mach, pams haŋon mbɨ Jisasɨnd pɨŋ ai andamesa mpɨrorɨzɨŋgwɨmar. Ave mbɨ Jisasɨh amarɨmar. Itɨ kɨvah hamb ihɨnd nanchɨŋ ŋgɨŋe awarohe ñɨñmbɨri amar. Amɨ itɨ kɨvah han kiaŋgwɨn ihɨnd nanch han erere etoz amar. ");
INSERT INTO anh_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Avɨz Jisasɨv ndɨn kamar. Arɨ nornanchɨnd unsa han ŋe uvi nor han meŋkwanarɨm amar. Arɨ nornanch ŋoz unsa han eŋkwanararɨŋ amar. ");
INSERT INTO anh_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Avɨz mbɨ Jisasɨh mbɨŋ ke kamar. Wɨram Ohɨra, han mɨŋun amar. Kɨrɨm uvi nor hambez antɨm kwɨŋ ñi unsa ekeka nornanchɨv hɨrɨzɨŋgamŋgɨj han namŋgɨjaŋg amar. ");
INSERT INTO anh_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Az Jisasɨv kamar. Amɨ ya han imbɨrun kan amar. Handɨv itɨ kɨvah hamb nancharɨh ndɨh ereri amar. Amɨ ekwaŋg ov amar. ");
INSERT INTO anh_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Hanave kaz anchɨ mbanamb mbɨkɨr oramɨŋ ekwaŋg we waz itɨ kɨvah hamb etoz, nanchɨrɨv antɨmɨŋ ŋgañɨmar. ");
INSERT INTO anh_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Mach, Jisasɨv isupɨr aiampɨra Tairɨnd erere ekwaŋg we aiampɨra Saidon ahevakarɨmar. Ahevakare avɨhohe isupɨr ohɨra Dekapolis uhɨmɨŋun akoke yamb ohɨra ondɨhondɨh Galilind ahevakarɨmar. ");
INSERT INTO anh_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ahevakare handɨh ñɨzand wɨram emŋgemŋga hamb wɨram njemɨn kɨvahɨnsɨnd han ŋe ndɨn hɨraimŋgɨmar. Mbɨ ya hɨreŋɨnd kanj. Mach, mbɨ wɨram kehan hɨrai Jisasɨh ndɨn omanaka insɨŋ ŋgamamɨndɨv mbahon mbahon amarɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Avɨz Jisasɨv wɨram mban ŋe osa anchɨ han erere hɨrohe, mbon ikumun ñɨmŋgɨmar. Ñɨmŋgɨz Jisasɨv omanamp mbɨkɨr han njemɨn ŋkiŋg ŋkiŋg sɨhoŋamar. Sɨhoŋe omanamp mbɨkɨr han mpɨñ atazivi wɨram mband zɨhina han mparɨwamar. ");
INSERT INTO anh_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Mach, Jisasɨv ñaŋ sɨhawarohe wɨr aŋkarɨpɨr savɨzɨŋgwi ndɨn kamar. Efata amar. (Jisasɨnd ya mbanand ondo han mbanɨmb: njemɨn uyaki amar.) ");
INSERT INTO anh_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Hanave kaz njemɨn mbɨkɨr hamb uyakaz zɨhina mbɨkɨr hamb imbɨr raz, ya omanenta kamar. ");
INSERT INTO anh_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Avɨz Jisasɨv osa anchɨ han erokare kamar. Wɨram emŋgemŋga kamŋgɨmɨn amar. Az nend. Jisasɨv ndɨŋ erokarɨzaŋg, osa anchɨ hamb ya aŋkarɨpɨr kampɨhe Jisasɨv utuhutuh sɨmar handɨv kamŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ave ndɨŋ zɨŋɨmb aŋkarɨpɨr pɨrorɨŋgaz kamŋgɨmar. Aia arɨmŋgɨmar. Jisasɨv utuhutuh omanenta raj arɨmŋgɨmar. Njemɨn kɨvahɨnsɨnd han, Jisasɨv ndɨŋ omanenta sɨz mbɨ njɨhamŋgɨj arɨmŋgɨmar. Ave karupɨr mahɨnsɨnd han, Jisasɨv ndɨŋez omanenta sɨz mbɨ kamŋgɨj arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mach haŋonaŋg, wɨram akŋ anchɨ akŋ hamb ekwaŋg ai aŋkwezawi ñɨhɨrɨmŋgɨmar. Mbɨ unsa mah apar. Handɨv Jisasɨv mbɨkɨr sezɨr han oreŋgɨz aimŋgɨmar. Aimŋgɨz ndɨŋ kamar. ");
INSERT INTO anh_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","Wɨram akŋ anchɨ akŋ mbanamb yanɨmen rapɨr undɨmapam ñɨmŋgɨndɨŋgi amar. Ave irɨh mbɨ unsa mah apar ñɨhɨrɨmŋgi amar. Handɨv nzɨ ndɨŋ waŋ yan akŋɨn ahi amar. ");
INSERT INTO anh_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nzɨ ndɨŋ kaŋ, mbɨndɨŋ oramɨŋ we unsandɨv mamŋgɨz, mbɨndɨŋ ampɨn hamb eraher awɨz empasamɨŋ aŋkɨramandɨramŋgi amar. Hanaveaŋg ui taŋɨpɨr ohɨra aimŋgɨndɨŋgi amar. ");
INSERT INTO anh_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Mach, sezɨrɨv mbɨŋ ndɨn kamŋgɨmar. Isupɨr mbanan wɨram mah arɨmŋgɨmar. Arɨ eŋka han nzɨhandɨh ŋe wɨram akŋ anchɨ akŋ mban eŋkwanarɨŋ ndɨŋ mpɨkarɨndari arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Avɨz Jisasɨv ndɨŋ amarɨmar. Amɨ eŋka han nzɨhanave hɨrañɨmŋgɨn amar. Az ndɨn kamŋgɨmar. Ahins arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Mach, Jisasɨv kaz wɨram akŋ anchɨ akŋ hamb isaŋ ŋgarɨwɨmŋgɨmar. Avɨz Jisasɨv eŋka ahins mban ŋe ñaŋ sɨhawarohe were Yakŋ Ohɨrah ya imbɨr eŋgwamar. Ave mbɨ eŋka mban ŋaŋepev mbɨkɨr sezɨr hamb wɨram akŋ anchɨ akŋ mban eŋkwanamŋgɨz are ndɨŋ eŋgwamar. Eŋgwaz mbɨ wɨram akŋ anchɨ akŋ han kɨrɨm eŋkwanamŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Mach, mbɨ oma uŋguŋg hanaveaŋg hɨrañɨmŋgɨmar. Avɨz Jisasɨv han ŋe Yakŋ Ohɨrah ya imbɨr eŋgwe sezɨr eŋgwaz hanez eŋkwanamŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Avɨz mbɨ namŋgɨz ndɨŋ mpɨkarɨmar. Ave unsa ekeka han aŋkwezawi iŋkimpiñ ohɨra ahins haŋ mpamŋgɨz torɨmar. ");
INSERT INTO anh_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Wɨram akŋ anchɨ akŋ hamb ñɨmŋgɨmar han 4,000 emamp. Ave Jisasɨv ndɨŋ kaz kɨrɨm omŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Mach, Jisasɨv sezɨrmen utɨŋg unchaŋ ŋkwetohe isupɨr Dalmanutand handɨh omŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mach, wɨram untɨm Farisind hamb ai Jisasmen ya amɨherɨmŋgɨmar. Jisasɨv ntɨŋ aŋkarɨpɨr pamuh han mbɨramɨz are, Yakŋ Ohɨrav ndɨn kaz mbɨ ntɨŋ Yakŋ Ohɨrand ŋaj oh o nend arɨmŋgɨmar. Han waŋɨn are ndɨn ondo mpamŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Avɨz Jisasɨv wɨr aŋkarɨpɨr ohɨra ŋaz mbɨkɨr mpɨ hamb kɨr ohɨra ñɨmar. Ave mbɨ kamar. Utɨndɨv osa anchɨ irɨh ñɨmŋgɨmbɨri mbanamb ntɨŋ aŋkarɨpɨr han waŋɨn are kamŋgi amar. Andɨŋ mɨŋun kin amar. Ntɨŋ aŋkarɨpɨr hamb mbɨramɨz Yakŋ Ohɨrav yan kaz nzɨ Yakŋ Ohɨrand ntɨŋ ŋajin han, han amɨ mɨwandɨramŋgɨm amar. Nendon amar. ");
INSERT INTO anh_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Mach ave, mbɨ ndɨŋ erere utɨŋg unchaŋ ŋkwuhi yamb ohɨra ondɨhondɨh ŋkiŋgɨŋ evahetomar. ");
INSERT INTO anh_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Mach, sezɨrɨv njɨhi eraher awi eŋka han mɨhɨraimŋgɨm. Mbɨndɨŋ eŋka pamuh hamb utɨŋg handɨh ñɨmar. ");
INSERT INTO anh_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Avɨz Jisasɨv ndɨŋ ya aŋkarɨpɨr kamar. Njɨhambar amar. Amɨ yis wɨram untɨm Farisind Herotɨnd han omanenton wehɨrɨvar amar.|f* ");
INSERT INTO anh_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Az sezɨrɨv mbon mbon kamŋgɨmar. Arɨ eŋka mah raz handɨv mbɨ ya mban ki toh arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Mach, Jisasɨv mbɨndɨŋ ya kamŋgɨmar mban ndɨh wamar. Ave ndɨŋ mbanave kamar. Utɨndɨv ya mbanan amon amon kamŋgɨn, arɨ eŋka mah arar kamŋgɨn amar. Amɨ omanenta mɨwamŋgɨrɨm oh a amar. Andɨŋ njɨhi mah oh a amar. Az handɨv amandɨŋ njɨhi hamb moyakam oh a amar. ");
INSERT INTO anh_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Andɨŋ ampɨn mbah, kɨrɨm amɨ hanɨhan han mɨwamŋgɨrɨm oh a amar. Andɨŋ njemɨn mbah, kɨrɨm amɨ ya han mɨnjɨhamŋgɨrɨm oh a amar. Amɨ njɨhi eraher awɨmŋgɨn toh amar. ");
INSERT INTO anh_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Eŋambɨr han nzɨ eŋka oman ŋkɨpam han ŋaŋepev 5,000 wɨram han eŋkwanen amar. Az amɨ unsa ekeka han iŋkimpiñ han nzɨhanave mpamŋgan amar. Az kamŋgɨmar. Oman ŋkiŋkiŋg undɨmaj arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Mach, ekwaŋg han nzɨ eŋka ahins han ŋaŋepev 4,000 wɨram akŋ anchɨ akŋ han eŋkwanen amar. Az amɨ unsa ekeka han iŋkimpiñ ohɨra han nzɨhanave mpamŋgan amar. Az ndɨn kamŋgɨmar. Ahins arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Az Jisasɨv ndɨŋ kamar. Amɨ utɨndɨv omanenta wamah ramŋgɨrɨn amar. ");
INSERT INTO anh_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Mach, Jisasɨv sezɨrmen we aiampɨra Betsaidaŋ ahevɨkɨrorɨmŋgɨmar. Avɨz osa anchɨ hamb wɨram emŋga ampɨn kɨvahɨnsɨnd han Jisasɨnd pɨŋ hɨraimŋgɨmar. Ave mbɨ Jisasɨv mbɨkɨr omanaka ndɨn insɨŋ ŋgamɨz are mbahon mbahon amarɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Mach, Jisasɨv wɨram ampɨn kɨvahɨnsɨnd mban oman uŋkɨri aiampɨra injambɨrɨŋ hɨrahevomar. Hɨrahevohe ampɨn mbɨkɨr han mpɨñ atazivɨmar. Ave mbɨ mbɨkɨr omanaka han ndɨn insɨŋ ŋgamɨmar. Ave ndɨn mbanave amarɨmar. Amɨ hanɨhan han wan oh o nend amar. ");
INSERT INTO anh_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ave wɨram mbanamb ñaŋ were kamar. Nzɨ wɨram hanaveaŋg win amar. Kɨrɨm waŋand mbɨ ai emamp ndand omŋgi aimŋgi amar. ");
INSERT INTO anh_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Az Jisasɨv mbɨkɨr omanaka han ekwaŋg mbɨkɨr ampɨnɨŋ ŋgamɨmar. Avɨz wɨram mbanamb aŋkarɨpɨron werɨz, mbɨkɨr ampɨn hamb imbɨrun ñɨmar. Ave mbɨ hanɨhan akŋ han ovɨherɨzand, mbɨkɨr werer hamb imbɨrun ahevakarɨmar. ");
INSERT INTO anh_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Mach, Jisasɨv ndɨn kamar. Amɨ amakɨr oramɨŋ ov amar. Amɨ aiampɨra uhɨmɨŋ omɨn amar. ");
INSERT INTO anh_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Mach ave, Jisasɨv sezɨrmen ŋondɨrahe aiampɨra akŋ Sisaria Filipai ikwɨm handɨh omŋgɨmar. Ave mbɨ empasamɨŋ mbɨkɨr sezɨrɨh mbanave amarɨmar. Osa anchɨ hamb yanɨh uñɨman oh arar kamŋgɨj amar. ");
INSERT INTO anh_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Az mbɨ ndɨn mbanave kamŋgɨmar. Hanaveaŋg nan Jonɨh wɨram osa anchɨ han yambɨŋ ŋazɨkŋirɨŋgwɨŋgw ŋambiahahɨnd hamb arɨmŋgɨj arɨmŋgɨmar. Hanaveaŋg nan Elaija arɨmŋgɨj arɨmŋgɨmar. Mach, hanaveaŋg nan wɨram Yakŋ Ohɨrand ya injambɨr ahe kahɨnd hamb arɨmŋgɨj arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Avɨz Jisasɨv sezɨrɨh amarɨmar. Amon han yanɨh uñɨman arar kamŋgɨn amar. Az Pitav ndɨn mbanave kamar. Nan wɨram Yakŋ Ohɨrav mbɨkɨr osa anchɨ ekwaŋg ŋɨmbɨmbɨndɨv uyɨŋgwamɨmar hamb amar. ");
INSERT INTO anh_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Avɨz Jisasɨv ndɨŋ erokare kamar. Amɨ wɨram emŋgemŋga han yandɨv kamŋgɨmɨn amar. ");
INSERT INTO anh_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Mach, Jisasɨv ondo ake sezɨrɨh ya han mbanave sɨkamar. Yakŋ Ohɨrand njɨhi hamb mbanave ñɨmar amar. Wɨramɨnd Nor hamb pɨrɨvɨr ohɨra ŋandari amar. Az wɨram untɨm ohɨra kɨra Judand, wɨram anɨŋnsar kɨra hanɨhan Yakŋ Ohɨrandɨv ahaz ore ŋgamamɨnd, mach wɨram kɨra ya Mosesɨnd injambɨr ahe sɨkahɨnd hamb, mbɨ Wɨramɨnd Nor mapɨŋ ame ndɨn mamta orɨndɨramŋgi amar. Avɨz watɨm yuŋk undɨmapam haŋ ekwaŋg ŋaiahandari amar. ");
INSERT INTO anh_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Mbɨ ndɨŋ ya han omanenton kampɨhe kaz, Pitav Jisasɨh ya aŋkarɨpɨr ke kamar. Amɨ ya han kamɨn amar. ");
INSERT INTO anh_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Avɨz Jisasɨv enarɨŋge sezɨr mbɨkɨr han wehɨre, Pitah ya aŋkarɨpɨr ke kamar. Amɨ Satan haremamp amar. Amɨ ihɨnd mapɨŋ ov amar. Amɨ Yakŋ Ohɨrand njɨhi mɨmpehɨrorɨm amar. Nend amar. Amɨ wɨramɨnd njɨhiŋam mpehɨrorɨn amar. ");
INSERT INTO anh_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ave Jisasɨv osa anchɨ han sezɨr mbɨkɨr hanez oreŋgɨz, ai awakŋɨmŋgɨmar. Aimŋgɨz Jisasɨv ndɨŋ mbanave kamar. Wɨram emŋgav yan mpehɨroŋɨn are, mbɨ mbɨkɨr njɨhi ŋambiŋgwi ai oŋkɨrand mbɨkɨr han orambi, yan mpehɨroz amar. ");
INSERT INTO anh_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Wɨram emŋgav kɨpɨr mbɨkɨr han aŋkarɨpɨr ŋambɨñɨz, kɨpɨr mbɨkɨr hamb kwevɨrɨndari amar. Kɨrɨm wɨram emŋgav yandɨv mach Yakŋ Ohɨrand ya imbɨrɨndɨv mbɨkɨr kɨpɨr han ererɨz, mbɨkɨr kɨpɨr hamb imbɨrun ñɨndari amar. ");
INSERT INTO anh_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Wɨram emŋgav hanɨhan akŋ isupɨr mbanand han ŋaz mach raz, kɨrɨm kɨpɨr mbɨkɨr hamb kwevɨrɨz, hanɨhan akŋ mbanamb ndɨnɨh nzɨhanave hɨrawɨmɨr amar. ");
INSERT INTO anh_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Handɨv wɨramb utɨmanɨŋ uŋkɨ eŋgwe kɨpɨr mbɨkɨr han ekwaŋg ŋandari amar. ");
INSERT INTO anh_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Osa anchɨ irɨh ñɨmŋgɨmbɨri mbanamb, mbɨ Yakŋ Ohɨrah mapɨŋ eŋgwe enta kɨvah kɨvah endɨraparam sɨmŋgɨj amar. Osa anchɨ emŋga mbɨndɨŋ hamb yandɨv mach ihɨnd yandɨv ampi ake ñɨmɨr amar. Mach, njɨmɨnj han Wɨramɨnd Nor hamb mpamɨnd ohɨra wanɨrɨnd ñɨñmbɨri hamb mbɨ Yakŋ Ohɨrand mapɨŋ akŋ hamen aindɨramŋgi amar. Aimŋgɨz, osa anchɨ Wɨramɨnd Norɨndɨv ampi akah kehand, mbez ndɨŋ ampi akandari amar. ");
INSERT INTO anh_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Mach, Jisasɨv ndɨŋ mbanave kamar. Nzɨ andɨŋ mɨŋun kin amar. Yakŋ Ohɨrav osa anchɨ hanaveaŋg ŋɨmbɨz mbɨkɨr kwɨŋ ñɨndɨramŋgi kehamb ahevakarɨndari amar. Han aŋkarɨpɨr ohɨransɨnd ahevakarɨndari amar. Avɨz hanaveaŋg mban ñɨmŋgɨmbɨri hamb mbɨ mamah re, mbɨ han wandɨramŋgi amar. ");
INSERT INTO anh_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Yuŋk ansɨ hamb we mach raz, mach Jisasɨv Pita Jems Jonɨh ŋɨmbi aparɨma mbɨhawar mɨŋ handɨh mpahɨrawaromar. Ave undɨmajɨvam mbon ikumun ñɨhɨrɨmŋgɨmar. Ave sezɨr undɨmapam hamb werer ñɨmŋgɨzand, Jisasɨnd yupɨr hamb enta emŋgon ahevakarɨmar. ");
INSERT INTO anh_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Yupɨr hɨrahɨr mbɨkɨr hamb raka okam emamp ahevakarɨmar. Ave okam mɨŋ ñɨmar. Wɨram emŋga isupɨr mbanand yupɨr hɨrahɨr usuzɨnd hamb imɨn han omanenta usɨz imɨn okam mbanamb Jisasɨnd imɨn okam emamp mahevakarɨmɨr. ");
INSERT INTO anh_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Avɨz Elaijav Mosesmen ahevɨkɨrorɨmŋgɨz, Jisasɨnd sezɨr hamb wamŋgɨz mbɨ Jisasmen ya kah ñɨhɨrɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Mach, sezɨr undɨmapam han we ezandɨkŋahambi ntahoror ñɨhɨrɨmŋgɨmar. Avɨz Pitav ya hanave kah han mɨwam. Ave mbɨ Jisasɨh mbanave kamar. Anɨŋzɨŋ entand, arɨ mban ñɨrɨŋ han imbɨrun amar. Arɨ imbɨr oram oram undɨmapam asɨmɨrɨŋ amar. Emŋga amakɨr emŋga Mosesɨnd emŋga Elaijand amar. ");
INSERT INTO anh_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Mach, yambaka emŋga hamb ahevakare rapɨr han asɨramamar. Avɨz ya emŋga hamb yambaka mbanand uncha haŋ mbanave kamar. Mban ihɨnd nor, nzɨ ndɨndɨvon rin amar. Amɨ mbɨkɨr ya njɨhambar amar. ");
INSERT INTO anh_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ave pams haŋon Jisasɨnd sezɨr hamb enarorɨŋge ovɨherɨmŋgɨmar. Kɨrɨm mbɨ wɨram emŋgaŋg mɨwamŋgɨm. Jisasɨv mbon ikumun ndɨŋmen ñɨmar. ");
INSERT INTO anh_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mach, mbɨ aparɨma han erere ŋketaimŋgɨmar. Az Jisasɨv ndɨŋ erokare kamar. Hanɨhan mban wamŋgɨn han wɨram emŋga kamŋgɨmɨn wem Wɨramɨnd Nor hamb me ekwaŋg mɨnsaŋ ŋaiahandari amar. ");
INSERT INTO anh_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Az mbɨ ya han mbɨndɨŋ mpɨ unchaŋ hɨrañɨmŋgɨmar. Ave mbon mbon mbanave kamŋgɨmar. Ya mban mbɨ me mɨnsaŋ ekwaŋg ŋaiahandari han, han utɨman arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ave Jisasɨh mbanave kamŋgɨmar. Utɨndɨv wɨram kɨra ya Mosesɨnd injambɨr ahe sɨkahɨnd hamb mbanave kamŋganj amar. Elaijav mboz aiz arar kamŋganj arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Az Jisasɨv mbɨndɨŋ ya enore mbanave kamar. Ya mban mɨŋun amar. Elaijav mboz ai hanɨhan ekwaŋg mɨŋam omanenta sɨndari amar. Kɨrɨm yaya Yakŋ Ohɨrand anɨŋzɨŋ entaŋ ñi han nzɨhanave ñɨz, Wɨramɨnd Nor hamb pɨrɨvɨr ohɨra kɨvah ŋaz, wɨram hamb ndɨn ŋambiŋgwi kɨvah sɨndɨramŋgi amar. ");
INSERT INTO anh_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Kɨrɨm nzɨ andɨŋ kin amar. Elaijav ndɨh air amar. Ave wɨram hamb mbɨndɨŋ njɨhiŋon mpehɨromŋgɨj amar. Mach, mbɨ ndɨnɨh enta endɨraparam sɨmŋgɨr han haremamp ya Yakŋ Ohɨrand anɨŋzɨŋ enta unchaŋ ñɨz ndɨndɨv mpamar amar. ");
INSERT INTO anh_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Mach, Jisasɨv sezɨr undɨmapamen ai sezɨr emŋgemŋgaŋ ahevɨkɨrorɨmŋgɨmar. Ahevɨkɨrore wamŋgɨz wɨram akŋ anchɨ akŋ hamb ndɨŋ ondɨhore ñɨhɨrɨmŋgɨmar. Ave wɨram kɨra ya Mosesɨnd injambɨr ahe sɨkahɨnd hamb ndɨŋmen amɨherɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Wɨram akŋ anchɨ akŋ mbanamb wamŋgɨz Jisasɨv aimar. Mbɨ aiz pams haŋon ntamŋgɨmar. Mbɨ nte ndɨn pɨŋ aŋɨraŋɨr we, ndɨn rapɨrɨnt eŋgwamŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Avɨz Jisasɨv ndɨŋ mbanave amarɨmar. Amɨ utɨndɨv ndɨŋmen ya amɨherɨmŋgɨn amar. ");
INSERT INTO anh_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Avɨz wɨram emŋga hamb wɨram akŋ anchɨ akŋɨnd uhɨmɨŋ ñɨmar hamb mbɨ Jisasɨh ya mbanave kamar. Anɨŋzɨŋ entand, itɨ kɨvah hamb ihɨnd norɨnd karupɨr aŋkwinchi ndɨnɨŋ ñɨñmbɨri amar. Handɨv nzɨ ndɨn nan pɨŋ hɨraiin amar. ");
INSERT INTO anh_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Itɨ kɨvah mbanamb ndɨnɨh hanaveon aŋkarɨpɨr kɨvah ŋaj avav ndɨn ŋaŋaŋ isaŋ avɨzɨŋgaj amar. Avɨzand karempa hamb karupɨr mbɨkɨrɨŋ ahevakarɨj avav mbɨ mbɨkɨr ampar ivɨharar kaj amar. Avɨzand yupɨr mbɨkɨr hamb mɨŋamun aŋkarɨpɨr raj amar. Ave nzɨ sezar amakɨr amarɨŋ itɨ kɨvah mban kiaŋgwɨmŋgɨzaŋg, kɨrɨm nend amar. Ndɨŋ aŋkarɨpɨr mah amar. ");
INSERT INTO anh_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jisasɨv ya mban njɨhame, wɨram akŋ anchɨ akŋ han kamar. Eee, amɨ wɨram akŋ anchɨ akŋ hamb njɨhi aŋkarɨpɨr mɨnjɨhamŋgɨm amar. Nzɨ andɨŋmen yuŋk war nzɨhanave mbahon ñɨndarin amar. Nzɨ yuŋk war nzɨhanave amandɨŋ kɨr akŋɨndarin amar. Amɨ nor kehan yan pɨŋ mbanaŋ hɨraivar amar. ");
INSERT INTO anh_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Mach, mbɨ nor kehan ndɨn pɨŋ hɨraimŋgɨmar. Avɨz itɨ kɨvah hamb Jisasɨh we, pams haŋon nor kehan sɨz itɨkɨrɨmun nte arazɨpazawɨmar. Ave nor mbanamb isaŋ aŋkɨrame enarambarɨmar. Karempa hambez karupɨr mbɨkɨrɨŋ ahevakarɨmar. ");
INSERT INTO anh_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Avɨz Jisasɨv wanɨrɨh mbanave amarɨmar. Mbɨkɨr mahoror kɨvah hamb yuŋk nzɨhanave ñi amar. Az wanɨrɨv kamar. Mbɨ sai aŋkwɨron ñɨzand ahevakarɨmar amar. ");
INSERT INTO anh_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Itɨ kɨvah mbanamb hanaveon ŋaŋaŋ pɨrɨtɨm insɨŋ yambɨŋ avɨzɨŋganj avav ndɨn mamta orɨŋɨn arar ranj amar. Amɨ imbɨr ramɨn amar. Amɨ arɨŋ akŋɨn ñi arɨŋ hɨrawɨv amar. ");
INSERT INTO anh_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Avɨz Jisasɨv ndɨnɨh kamar. Utɨndɨv mbanave kan, amɨ imbɨr ramɨn arar kan amar. Kɨrɨm amɨ njɨhi aŋkarɨpɨr ŋe njɨhame hanɨhan upi mban mɨŋamun imbɨr ramɨn amar. ");
INSERT INTO anh_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Az pams haŋon wanɨrɨv aware kamar. Nzɨ njɨhi aŋkarɨpɨr ŋe njɨhamin amar. Kɨrɨm njɨhi aŋkarɨpɨr ihɨnd han tɨm nor amar. Amɨ yan hɨrawɨv amar. ");
INSERT INTO anh_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Mach, Jisasɨv waz wɨram akŋ anchɨ akŋ ohɨron mbanamb aŋɨrɨmbɨrɨmbɨr ndɨŋ pɨŋ ikwɨm aimŋgɨmar. Az mbɨ itɨ kɨvah han ya aŋkarɨpɨr ke kamar. Nzɨ nan aŋkarɨpɨr kin amar. Nan itɨ kɨvah karupɨr aminjinjɨnd, njemɨn inchɨrɨmbɨmbɨnd, amɨ nor mbanan erere etov amar. Ave ekwaŋg ndɨn unchaŋ ŋgwevomɨn amar. ");
INSERT INTO anh_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Avɨz itɨ kɨvah mbanamb kwa hɨrɨzɨnd awarɨmar. Mbɨ raz nor mbanamb nte asu asai razand ndɨn erere etomar. Avɨz nor mbanamb me ñɨwamar. Az osa anchɨ hamb we kamŋgɨmar. Mbɨ ndɨh mi arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Kɨrɨm Jisasɨv omanaka mbɨkɨr han ŋe ndɨn ŋambiahaz aŋkwañɨmar. ");
INSERT INTO anh_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Mach, Jisasɨv we oramɨŋ ahevohe mbɨkɨr sezɨrmen mbon ikumun ñɨhɨrɨmŋgɨmar. Ave mbɨ ndɨn amarɨmŋgɨmar. Arɨ utɨndɨv itɨ kɨvah mban kiaŋgwɨ mah rarɨŋ arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Avɨz ndɨŋ kamar. Arɨ Yakŋ Ohɨrah ahaz orɨmah re, itɨ kɨvah kehand han mɨkiaŋgwɨndɨram amar. ");
INSERT INTO anh_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Mach ave, Jisasɨv mbɨ sezɨrmen aiampɨra han erere isupɨr Galili uhɨmɨŋun omŋgɨmar. Avav Jisasɨv mbɨkɨr sezɨrɨh ya sɨkanj. Handɨv mbɨ ndɨŋ erokare kamar. Amɨ wɨram emŋgavaŋg kamŋgɨmɨn amar. Jisasɨv mbah handɨh ñɨñmbɨri arar kamŋgɨmɨn amar. Ave mbɨ ndɨŋ kamar. Wɨramɨnd Nor han wɨram kɨrand oman insɨŋ ŋgamɨndɨramŋgi amar. Ave ndɨn mamta orɨmŋgɨz mandari amar. Mbɨ ndɨn mamta orɨŋgamɨndɨramŋgiaŋg, kɨrɨm mbɨ watɨm yuŋk undɨmapam haŋ ekwaŋg ŋaiahandari amar. ");
INSERT INTO anh_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Avɨz mbɨ ya mbanand ondo han mɨwamŋgɨrɨm. Handɨv mbɨ ndɨn amarɨŋɨn arar ezandɨkŋɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","34","Mach ave, Jisasɨv mbɨ sezɨrmen aiampɨra Kaperneamɨŋ omŋgɨmar. Ave sezɨrɨv mbon mbon empasamɨŋ yaŋam amɨherɨmŋgɨmar. Uñɨman wɨram arɨŋɨnd anɨŋnsar mɨŋ arɨmŋgɨmar. Mach, mbɨ Kaperneamɨŋ ahevɨkɨrore oramɨŋ ahevomŋgɨz Jisasɨv mbɨkɨr sezɨrɨh amarɨmar. Amɨ utɨman yaya empasamɨŋ kamŋgɨndɨŋgɨn amar. Avɨz mbɨ ya mah ñɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Mach, Jisasɨv ŋkañi mbɨkɨr sezɨr oman ŋkiŋkiŋg undɨmaj han oreŋge kamar. Wɨram emŋgav anɨŋnsar ñɨŋɨn are, mbɨ wɨram kɨra emŋgemŋgand kwɨŋ ñɨz amar. Handɨv mbɨ wɨram osa anchɨnd ntɨŋ ŋaŋɨnd hamb ñɨndari amar. ");
INSERT INTO anh_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ave Jisasɨv nor emŋga han ŋe uhɨmɨŋun ŋgame ŋambiahe eŋkwarɨmbɨñɨmar. Ave ndɨŋ kamar. ");
INSERT INTO anh_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","Wɨram emŋga hamb yan njɨhame nor emŋga han hɨrawi, mbɨ yanez hɨrawɨndari amar. Ave wɨram yan hɨrawɨndari hamb, mbɨ yanɨŋam mɨhɨrawɨndɨram amar. Yakŋ Ohɨrav yan kaz aimanjin han, wɨram kehamb ndɨnez hɨrawɨndari amar. ");
INSERT INTO anh_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Mach, Jonɨmb Jisasɨh kamar. Anɨŋzɨŋ entand, arɨ warɨŋand wɨram emŋga hamb itɨ kɨvah akŋ han amakɨr ensaŋ kiaŋgworaŋgwɨr amar. Kɨrɨm ndɨn wɨram arɨŋɨnd mah amar. Handɨv arɨ ndɨnɨh chonj ŋgamɨrɨŋ amar. ");
INSERT INTO anh_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Avɨz Jisasɨv ndɨŋ kamar. Amɨ ndɨn chonj ŋgamŋgɨmɨn amar. Wɨram emŋga ihɨnd ensaŋ ntɨŋ aŋkarɨpɨr ŋaŋɨnd hamb, mbɨ yan pams ya kɨvah mɨkandɨram amar. ");
INSERT INTO anh_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Wɨram arɨŋ enta kɨvah sɨmah randari kehamb ndɨn arɨŋɨnd ahambɨr amar. ");
INSERT INTO anh_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nzɨ andɨŋ ya mɨŋun kin amar. Wɨram emŋgav andɨŋ waz amɨ Kraisɨnd untɨm ñɨmŋgɨn han, mbɨ yandɨv re njɨhame andɨŋ yamb nand eŋgwandari amar. Uŋkɨ osa anchɨ hɨrawaw han Yakŋ Ohɨrav ndɨn eŋgwandari amar. ");
INSERT INTO anh_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Jisasɨv mbahon mbanave kamar. Sai nor emŋgav yandɨv njɨhi aŋkarɨpɨr ŋe njɨhamɨz, wɨram emŋgav raz sai nor mbanamb enta kɨvahɨŋ aŋkɨramaz, han enta imbɨr mah amar. Wɨram kɨra hamb nsɨham ohɨra han ŋe wɨram kehand ŋkwɨntɨr haŋ vɨhe, utɨm yambɨŋ avɨzɨŋgwɨmŋgɨz mbɨ eran yamb ne maz amar. Han imbɨr amar. ");
INSERT INTO anh_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Mach, amakɨr oman hamb nan enta kɨvah sɨzɨndɨv raŋɨnj han, mach amakɨr oman ŋkiŋg han akoke avɨzuv amar. Ave amɨ oman ŋkɨpam ñi kɨpɨr icha ipɨra ñɨñɨnd han ŋandɨran amar. Han imbɨr amar. Ave amɨ oman undɨmajɨnsɨnd ñɨn, nan Yakŋ Ohɨrav sam pɨrɨtɨm kɨvah kwevɨrɨ mah raj mbɨkɨr ensa Gehenna haŋ avɨzumɨnj amar. Han imbɨr mah amar. ");
INSERT INTO anh_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Mach, amakɨr andam hamb nan enta kɨvah sɨzɨndɨv raŋɨnj han, han akokav amar. Ave amɨ andam ŋkɨpam ñi kɨpɨr icha ipɨra ñɨñɨnd han ŋandɨran amar. Han imbɨr amar. Ave amɨ andam undɨmajɨnsɨnd ñɨn nan Yakŋ Ohɨrav Gehennaŋ avɨzumɨnj amar. Han imbɨr mah amar. ");
INSERT INTO anh_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Mach, amakɨr ampɨn hamb nan enta kɨvah sɨzɨndɨv raŋɨnj han, mach ampɨn ŋkiŋg han ŋatɨwe avɨzuv amar. Amɨ ampɨn ŋkɨpam ñi amɨ Yakŋ Ohɨrav osa anchɨ hanaveaŋg ŋɨmbɨz mbɨkɨr kwɨŋ ñɨndɨramŋgi haŋ ahevondɨran amar. Han imbɨrun amar. Ave amɨ ampɨn undɨmajɨnsɨnd ñɨn, nan Yakŋ Ohɨrav Gehennaŋ avɨzumɨnj amar. Han imbɨr mah amar. ");
INSERT INTO anh_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Aiampɨra kehan kwɨmuñ hamb mbɨndɨŋ yupɨr han namŋgɨj hamb, mbɨ mɨkwevɨrɨndɨramŋgɨm amar. ");
INSERT INTO anh_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Yakŋ Ohɨrav wɨram akŋ anchɨ akŋ han pɨrɨtɨmɨŋ avair wandari han osa anchɨ hamb unsa han utɨmɨŋ ondo mparɨwamŋgɨj haremamp amar. ");
INSERT INTO anh_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Utɨm han imbɨrpamun amar. Kɨrɨm utɨm unɨm hamb kwevɨrɨz, amɨ nzɨhanave ramŋgɨn utɨm hamb ekwaŋg unɨm ñɨndari amar. Hanaveonaŋg utɨm unɨm emampaŋg amon amon mpɨ uchɨñ ñɨmbar amar. ");
INSERT INTO anh_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Mach, Jisasɨv isupɨr Judiand handɨh oŋɨn are, mbɨ aiampɨra han ererɨmar. Erere we yamb ŋkiŋg Jordand handɨh evahomar. Evahohe we yamb ŋkiŋg Jordand handɨh ekwaŋg evahai isupɨr Judiand handɨh aimar. Avɨz wɨram akŋ anchɨ akŋ ohɨron hamb ndɨn pɨŋ ai ekwaŋg aŋkwezawɨmŋgɨmar. Az Jisasɨv mbɨkɨr enta mpehɨro ndɨŋ ya sɨkanj. ");
INSERT INTO anh_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mach, wɨram untɨm Farisind hamb Jisasɨnd pɨŋ aimŋgɨmar. Ave mbɨ Jisasɨh ondo mpendɨŋ kamŋgɨmar. Arɨŋɨnd enta han, osa hamb mbɨkɨr anchɨ han imbɨr kiaŋgwɨmɨr han, han chonj oh o nend arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Avɨz Jisasɨv ndɨŋ mbanave kamar. Mosesɨv andɨŋ utɨman enta mpehɨrondɨv eŋgwamar amar. ");
INSERT INTO anh_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Az mbɨ ndɨn kamŋgɨmar. Mosesɨv kamar arɨmŋgɨmar. Osa hamb mbɨkɨr anchɨ ererɨŋɨn are mbɨ imbɨr anɨŋzɨŋ enta mpe ndɨn eŋgwe kiaŋgwɨz ondari arar kamar arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Kɨrɨm Jisasɨv ndɨŋ mbanave kamar. Andɨŋ wɨram kɨra entachand raz, Mosesɨv enta mbanan anɨŋzɨŋ entaŋ mpe andɨŋ eŋgwamar amar. ");
INSERT INTO anh_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Eŋambɨr mɨŋun han, Yakŋ Ohɨrav kɨrɨchɨn orɨchɨn han achake kaz, osa anchɨ hamb ahevɨkɨrorɨmŋgɨmar amar. ");
INSERT INTO anh_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Handɨv wɨram hamb mbɨkɨr mɨŋɨr wanɨr han erere anchɨmen awakŋi ñɨmŋgɨj amar. ");
INSERT INTO anh_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ave undɨmaj hamb yupɨr pamɨnd ahevakarɨmŋgi amar. Yakŋ Ohɨrav hanave kaz, undɨmaj hamb yupɨr undɨmaj mɨñɨmŋgɨm nend, yupɨr pamɨnd emamp ahevakarɨmŋgi amar. ");
INSERT INTO anh_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Avɨz, hanɨhan Yakŋ Ohɨrav awakŋorɨmar han wɨram hamb kiaŋgwɨmŋgɨmɨnj amar. ");
INSERT INTO anh_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Mapɨŋ, Jisasɨv sezɨrmen oramɨŋ omŋgɨz, sezɨrɨv ya osav anchɨ erererɨnd mbandɨv ekwaŋg amarɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Az ndɨŋ mbanave kamar. Wɨram emŋgav anchɨr erere anchɨ emŋga han ŋandari han, wɨram kehamb anchɨrɨh enta kɨvah si anchɨ emŋga hamen enta kɨvah sɨz ndandɨramŋgi amar. ");
INSERT INTO anh_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Mach, anchɨ emŋga hamb mamɨr erere osa emŋga han ŋandari han, anchɨ kehamb mamɨrɨh enta kɨvah si osa emŋga hamen enta kɨvah sɨz ndandɨramŋgi amar. ");
INSERT INTO anh_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Osa anchɨ hamb Jisasɨv mbɨkɨr omanaka mbɨndɨŋ nornanch han insɨŋ ŋgamɨz are ndɨŋ Jisasɨnd pɨŋ hɨraimŋgɨmar. Kɨrɨm sezɨrɨv han we osa anchɨ kehan ya aŋkarɨpɨr ke kamŋgɨmar. Amɨ han sɨmŋgɨmɨn arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jisasɨv han waz, mbɨkɨr mpɨ hamb kɨvah ramar. Avɨz ndɨŋ mbanave kamar. Eramŋgɨn nornanch hamb yan pɨŋ aimŋgɨz amar. Amɨ ndɨŋ erokarɨmŋgɨmɨn amar. Wɨram hamb nornanch haremamp ñi, mbɨ Yakŋ Ohɨrand kwɨŋ ñɨndari amar. ");
INSERT INTO anh_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nzɨ andɨŋ mɨŋun kin amar. Yakŋ Ohɨrand kwɨ han wɨram emŋgav ŋamah randari han, nornanchɨv ŋamŋgɨj hanaveaŋg, mbɨ mahevondɨram amar. ");
INSERT INTO anh_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ave Jisasɨv nornanch han omanakaŋ ŋɨmbi, omanaka mbɨkɨr han zɨ umpɨr insɨŋ ŋgamɨ ŋgamɨ rar omar. Ave ndɨŋ omanenta sɨz are Yakŋ Ohɨra ya imbɨrɨŋ amarɨmar. ");
INSERT INTO anh_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Mach ave, Jisasɨv ŋaiahe empasamɨŋ ozand, wɨram emŋga hamb aŋɨraŋɨr ndɨn pɨŋ ai andamesa mpɨrorɨzɨŋgwɨmar. Ave mbɨ ndɨn mbanave amarɨmar. Anɨŋzɨŋ entand, nan wɨram imbɨr amar. Nzɨ nzɨhanave re kɨpɨr icha ipɨra ñɨñɨnd han ŋaŋ ñɨndarin amar. ");
INSERT INTO anh_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Avɨz Jisasɨv ndɨn mbanave kamar. Utɨndɨv yan imbɨr arar kan amar. Yakŋ Ohɨra pamuh, mbonam imbɨr amar. ");
INSERT INTO anh_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Amɨ Yakŋ Ohɨrand enta akŋ anɨŋzɨŋ enta unchaŋ ñi han ndɨh warɨn amar. Amɨ osa anchɨ emŋgemŋga han mamah mamta orɨmŋgɨmɨn amar. Amɨ amakɨr anchɨ han erere anchɨ emŋga hamen enta kɨvah sɨz ndamŋgɨmɨn amar. Anchɨ hambez mbɨkɨr mamɨr han erere osa emŋga hamen enta kɨvah sɨz ndamŋgɨmɨnj amar. Amɨ akɨm ŋamŋgɨmɨn amar. Amɨ osa anchɨ emŋgemŋga han yosa si ya oramɨŋ hɨromŋgɨmɨn amar. Amɨ wɨram emŋgemŋgand hanɨhan han mamah erɨwazi ŋinchɨmŋgɨmɨn amar. Mach, amɨ yaŋar onarɨnd kwɨŋ ñɨhɨri mbɨndɨŋ yaŋam njɨhambar amar. ");
INSERT INTO anh_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Mach, wɨram mbanamb Jisasɨh mbanave kamar. Anɨŋzɨŋ entand amar. Nzɨ sai noron ñi enta akŋ mbanan mpehɨromanjin han hɨrandem hɨrai irɨh hanaveonaŋg ñɨjin amar. ");
INSERT INTO anh_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jisasɨv ndɨn werer nde mbɨkɨr njɨhi mpɨ han wɨram kehandɨv aŋkarɨpɨr ohɨra kɨvah eŋgwamar. Ave ndɨn mbanave kamar. Amakɨr kɨpɨr han, amɨ aŋkarɨpɨr pamuh nendon amar. Amɨ amakɨr hanɨhan han hɨron uŋkɨ eŋgwamŋgɨz, nsɨham nor han ŋe wɨram kɨra hanɨhan mah han eŋgwarɨmbɨv amar. Amɨ hanave ran, amakɨr hanɨhan imbɨr hamb Yakŋ Ohɨrand Aiampɨra Ohɨra Ñaŋ handɨh ñɨndari amar. Ave yan mpehɨraiv amar. ");
INSERT INTO anh_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Wɨram mbanan mbɨkɨr hanɨhan akŋ han imbɨr mah. Ave ya han njɨhamɨz mbɨkɨr emansɨŋ hamb kɨvah ramar. Handɨv mbɨ Jisasɨh ererɨz mbɨkɨr mpɨ hamb kɨr ohɨra ñɨmar. ");
INSERT INTO anh_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Mach, Jisasɨv werer nde mbɨkɨr sezɨrɨh kamar. Wɨram kɨra hanɨhan akŋnsɨnd hamb Yakŋ Ohɨrand kwɨŋ ñɨŋɨn are pɨrasɨndɨramŋgi amar. ");
INSERT INTO anh_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Avɨz sezɨrɨv ya mbɨkɨr mban njɨhame ntamŋgɨmar. Kɨrɨm Jisasɨv ndɨŋ mbahon kamar. Nor kɨra amar. Wɨram hamb Yakŋ Ohɨrand kwɨŋ ñɨŋɨn are pɨrasɨndɨramŋgi amar. ");
INSERT INTO anh_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamel hamb ewañɨhe imɨn sazɨnd mɨn han ŋgwevoŋɨn are mbɨ pɨrasaz mah amar. Kɨrɨm nsɨham nor wɨram hamb Yakŋ Ohɨrand kwɨŋ ñɨŋɨn are pɨrasɨndari amar. ");
INSERT INTO anh_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Mach, sezɨrɨv nte arazɨpazawi mbon mbon ya ke mbanave kamŋgɨmar. Yakŋ Ohɨrav uñɨman ekwaŋg ŋandari arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Mach, Jisasɨv ndɨŋon wehɨrehɨr kamar. Wɨram hamb mbon han nend amar. Kɨrɨm Yakŋ Ohɨrav mbɨ imbɨr amar. Mbɨ hanɨhan utuhutuh han imbɨr sɨndari amar. ");
INSERT INTO anh_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Avɨz Pitav ya emŋga han Jisasɨh mbanave kamar. Wav amar. Arɨ arɨŋɨnd hanɨhan utuhutuh han erere nan mpehɨrairɨŋ amar. ");
INSERT INTO anh_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Az Jisasɨv kamar. Nzɨ andɨŋ mɨŋun kin amar. Wɨram hamb yandɨv mach Yakŋ Ohɨrand ya imbɨrɨndɨvez njɨhame oram yanɨr ranɨr mɨŋɨr wanɨr nornanch war ererɨndari hamb, ");
INSERT INTO anh_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","mbɨ hanɨhan mɨŋam ekwaŋg ŋandari amar. Wɨram mbanamb isupɨr mbanaŋ ñi han, Yakŋ Ohɨrav ndɨn hanɨhan han 100 emamp eŋgwandari amar. Ave mbɨ oram akŋ azɨŋunj namunj yaŋunj nornanch war akŋ ŋandari amar. Hanez wɨram emŋgemŋga hamb ndɨn enta kɨvah sɨndɨramŋgi amar. Kɨrɨm njɨmɨnj mbɨ kɨpɨr icha ipɨra ñɨñɨnd han ŋaŋ ñɨndari amar. ");
INSERT INTO anh_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Wɨram akŋ irɨh mboz injore anɨŋnsar ñɨmŋgi hamb, mbɨ mapɨŋ ansam ñɨndɨramŋgi amar. Wɨram akŋ irɨh mapɨŋ ansam ñɨmŋgi hamb, mbɨ mboz injore anɨŋnsar ñɨndɨramŋgi amar. ");
INSERT INTO anh_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Mach ave, Jisasɨv sezɨrmen empasam aiampɨra ohɨra Jerusalemɨnd handɨh awaromŋgɨmar. Jisasɨv mboz injore omar. Az sezɨrɨv njɨhakɨramamŋgɨmar. Osa anchɨ hamb ndɨŋ mpehɨro, mbɨ ezandɨkŋahambɨmŋgɨmar. Mach, Jisasɨv sezɨr oman ŋkiŋkiŋg undɨmaj han ekwaŋg ŋɨmbi ondo ake hanɨhan hamb ndɨnɨŋ ahevakarɨndari handɨv ndɨŋ ya sɨkamar. ");
INSERT INTO anh_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Njɨhambar amar. Arɨ irɨh Jerusalemɨŋ awarombɨrarɨŋ amar. Awarorɨŋ mbɨ Wɨramɨnd Nor han ŋe ndɨn wɨram emŋgemŋgand oman insɨŋ ŋgamɨndɨramŋgi amar. Mbɨ ndɨn wɨram kɨra anɨŋnsar hanɨhan Yakŋ Ohɨrandɨv ahaz ore ŋgamamɨnd oman hand insɨŋ mach wɨram kɨra ya Mosesɨnd injambɨr ahe sɨkahɨnd oman hanez insɨŋ ŋgamɨndɨramŋgi amar. Ave ndɨndɨv ya oramɨŋ we ya vɨhe kandɨramŋgi amar. Mbɨ mandari arar kandɨramŋgi amar. Ave mbɨ ndɨn wɨram kɨra yimbɨm emŋgand oman insɨŋ ŋgamɨndɨramŋgi amar. ");
INSERT INTO anh_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ave wɨram kɨra kehamb ndɨn yarahoparahe, kɨrɨpa aŋkarɨpɨrɨŋ ndɨn ore kɨre mpɨñ atazɨpazivi, mach ndɨn mamta orɨŋgamɨndɨramŋgi amar. Kɨrɨm watɨm ñirɨnd arar mbɨ ekwaŋg ŋaiahandari amar. ");
INSERT INTO anh_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Mach, Jemsɨh Jonɨh Sebedind nor kɨra undɨmaj hamb Jisasɨnd pɨŋ ai mbanave kamŋgɨmar. Anɨŋzɨŋ entand, arɨ undɨmaj nan amarɨŋɨn are rarɨŋ arɨmŋgɨmar. Arɨŋɨnd hanɨhan pamuhɨndɨv njɨhi aŋkarɨpɨr kɨvah njɨhamɨrɨŋ amɨ arɨŋɨndɨv kɨrɨmun randɨran arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Az Jisasɨv ndɨŋ mbanave amarɨmar. Undɨmaj, andɨŋndɨv utɨzɨŋɨn are njɨhamŋgɨn amar. ");
INSERT INTO anh_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Undɨmaj hamb ndɨn kamŋgɨmar. Wɨram akŋ anchɨ akŋ hamb mɨŋam amakɨr kwɨŋ ñɨndɨramŋgi han, arɨ undɨmaj njɨhamɨrɨŋ han, wɨram emŋga hamb eran amakɨr oman mɨŋɨndɨŋ ŋkañɨz emŋgav amakɨr oman ovejɨndɨŋ ŋkañɨz arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Kɨrɨm Jisasɨv undɨmaj han mbanave kamar. Amɨ undɨmaj yan hanɨhan kehandɨv amarɨmŋgɨn han omanenta mɨwamŋgɨrɨm amar. Sɨhomɨŋai yamb nand nzɨ naŋɨn are randarin kehan, amɨ haŋonaŋg imbɨr nandɨramŋgɨn oh a amar. Pɨrɨvɨr nzɨ ŋaŋɨn are randarin kehan, amɨ hanaveaŋg imbɨr ŋandɨramŋgɨn oh a amar. ");
INSERT INTO anh_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Avɨz mbɨ ndɨn kamŋgɨmar. Arɨ undɨmaj imbɨr arɨmŋgɨmar. Avɨz Jisasɨv ndɨŋ kamar. Mɨŋun amar. Sɨhomɨŋai yamb nand nzɨ nandarin mbanaŋ, amez haŋonaŋg nandɨramŋgɨn amar. Pɨrɨvɨr nzɨ ŋandarin han, amez ŋandɨramŋgɨnaŋg amar. ");
INSERT INTO anh_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Kɨrɨm uñɨmb ihɨnd oman mɨŋɨndɨŋ ŋkañɨzand, ovejɨndɨŋ ŋkañɨndari han, han ihɨnd hanɨhan mah amar. Nzɨ hanɨhan kehan muyɨŋgwamɨm nend amar. Sam ŋkañɨnd kehan, han mbɨndɨŋ wɨram kɨra Yakŋ Ohɨrav ndɨŋndɨv uyɨŋgwamɨmar hamb amar. ");
INSERT INTO anh_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jisasɨnd sezɨr oman ŋkiŋkiŋg hamb ya Jemsɨv Jonmen amarɨmŋgɨmar kehan njɨhame undɨmaj han aŋkwɨ sɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Az Jisasɨv ndɨŋ oreŋgɨz ndɨn pɨŋ ai aŋkwezawɨmŋgɨz ndɨŋ kamar. Amɨ wamŋgɨrɨnaŋg amar. Wɨram anɨŋnsar wɨram akŋ anchɨ akŋ yimbɨm emŋgemŋgand hamb, mbɨ mbɨndɨŋ untɨm han aŋkarɨpɨr kɨvah wehɨrɨmŋgɨj amar. Az mbɨndɨŋ wɨram kɨra ohɨra ohɨra hamb handɨv aŋkarɨpɨr ñɨmŋgɨz osa anchɨ hamb mbɨndɨŋ yaŋam mpehɨromŋgɨj amar. ");
INSERT INTO anh_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Kɨrɨm enta mbanamb andɨŋmen ñɨmɨnj nend amar. Wɨram hamb andɨŋndɨv ensa ohɨransɨnd ñɨz are, mbɨ kɨrɨmoz andɨŋ kwɨŋ ñi wɨram amandɨŋ ntɨŋ ŋaŋɨnd emampoz ñɨz amar. ");
INSERT INTO anh_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ave wɨram hamb andɨŋndɨv anɨŋnsar ñɨz are, mbɨ eran wɨram emŋgemŋga mɨŋam ndɨŋndɨv ntɨŋ mamah ŋaŋ ñɨz amar. ");
INSERT INTO anh_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Handɨv Wɨramɨnd Nor hambez mbɨ wɨram emŋgav ndɨn ntɨŋ hɨrawi ŋamŋgɨz are maim, nend amar. Mbɨ ndɨŋndɨv hɨrawi mbon mbɨkɨr kɨpɨr eŋgwe osa anchɨ han uŋkɨ eŋgwe ekwaŋg ŋɨmbɨŋɨn are air amar. ");
INSERT INTO anh_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Mach ave, Jisasɨv sezɨrmen aiampɨra Jerikoŋ ahevɨkɨrorɨmŋgɨmar. Ave Jisasɨv Jeriko erere etomar. Etozand mbɨkɨr sezɨrɨvon wɨram akŋ anchɨ akŋ hanave ndɨnmen omŋgɨmar. Bartimeusɨh, Timeusɨnd nor, ndɨnɨh ampɨn kɨvah empasam ampaŋon ŋkañɨmar. Ave ñɨñ nsɨham norɨndɨv, hanɨhan utuhutuhɨndɨv osa anchɨ han oreŋganj. ");
INSERT INTO anh_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Mbɨ njɨhamɨz Jisas Nasaretɨnd hamb ai arɨmŋgɨz, mbanave ondo ake aŋkarɨpɨron oreŋgɨmar. Jisas, nan Devitɨnd nor, yan akŋɨn ñɨmb amar. ");
INSERT INTO anh_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Avɨz wɨram akŋ anchɨ akŋ hamb ndɨn ya aŋkarɨpɨr ke kamŋgɨmar. Amɨ karupɨr se yamah ŋkañɨmb arɨmŋgɨmar. Kɨrɨm mbɨ mbahon aŋkarɨpɨr ware oreŋge kamar. Devitɨnd nor, yan akŋɨn ñɨmb amar. ");
INSERT INTO anh_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Mach, Jisasɨv aŋkwañi kamar. Ndɨn oreŋgɨmŋgɨn aiz amar. Mach, wɨram ampɨn kɨvahɨnsɨnd mban oreŋge mbanave kamŋgɨmar. Amɨ aŋkarɨpɨr ñɨmb arɨmŋgɨmar. Amɨ ŋaiahav arɨmŋgɨmar. Nan oreŋgi arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Mach, mbɨkɨr yupɨr hɨrahɨr osapɨr han avɨzɨŋge, pams haŋon ŋaiahe aŋkwañi Jisasɨnd pɨŋ omar. ");
INSERT INTO anh_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Avɨz Jisasɨv ndɨn mbanave amarɨmar. Nzɨ nan utɨzɨŋɨn are njɨhamɨn amar. Az wɨram ampɨn kɨvahɨnsɨnd hamb ndɨn kamar. Anɨŋzɨŋ entand, nzɨ wehɨrɨŋɨn are kin amar. ");
INSERT INTO anh_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Mach, Jisasɨv ndɨn kamar. Amɨ ov amar. Amakɨr njɨhi aŋkarɨpɨr hamb raz amɨ imbɨr ndɨh ñɨn amar. Avɨz pams haŋon ampɨn mbɨkɨr hamb imbɨr ñɨz wehɨrɨmar. Ave mbɨ Jisasɨh empasamɨŋ mpehɨromar. ");
INSERT INTO anh_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Mach ave, Jisasɨv mbɨkɨr sezɨrmen Jerusalem ikwɨm ivi Betfage mach Betani aiampɨraŋ ahevɨkɨrorɨmŋgɨmar. Aiampɨra undɨmaj mbanamb aparɨma Olivɨnd handɨh ñɨhɨranj. Ave Jisasɨv sezɨr undɨmaj hamb ondɨv kamar. ");
INSERT INTO anh_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ave mbɨ ndɨŋ mbanave kamar. Aiampɨra kehan wawɨmbɨrarɨŋ haŋ ovar amar. Amɨ aiampɨra kehaŋ ŋgwevohe pams haŋon donki nor han wandɨramŋgɨn amar. Mbɨ ndɨn mpamŋgɨz aŋkwañɨñɨmbɨri han, eŋambɨr wɨram emŋgav ndɨn insɨŋ mɨŋgarɨwɨmŋgɨrɨm amar. Mbɨkɨr kɨrɨpa han inɨmbi donki nor kehan ŋe hɨraivar amar. ");
INSERT INTO anh_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Avɨz wɨram emŋgav andɨŋ amarɨmɨr amar. Amɨ utɨndɨv donki nor han ŋe hɨromŋgɨn arar amarɨmɨr amar. Amɨ mbɨkɨr ya enore kavar amar. Anɨŋnsar Ohɨrav ndɨn ntɨŋ mbah, ave mbɨ ekwaŋg pams haŋon eŋgwaz aindari arar kavar amar. ");
INSERT INTO anh_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Mach, sezɨr undɨmaj hamb omŋgɨmar. Mbɨ aiampɨraŋ ŋgwevohe wamŋgɨz donki nor hamb empasamɨŋ aŋkwañɨmar. Wɨram kɨra emŋgemŋgav donki nor mbanan mpamŋgɨz oram impikŋ ikwɨm handɨh aŋkwañɨmar. Mach, sezɨr undɨmaj hamb ndɨn kɨrɨpa han inɨmbɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Avɨz wɨram kɨra ikwɨm aŋkwañɨhɨrɨmŋgɨmar hamb ndɨŋ mbanave amarɨmŋgɨmar. Amɨ undɨmaj utɨzɨŋɨn are donki nor mban inɨmbɨmŋgɨn arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Avɨz sezɨr undɨmaj hamb Jisasɨv ndɨŋ kamar hanaveonaŋg ndɨŋ kamŋgɨmar. Az wɨram kɨra hamb mpɨ imbɨrvam ñi sezɨr undɨmaj han kamŋgɨmar. Aria, ŋe hɨrovar arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Mach, sezɨr undɨmaj hamb donki nor han Jisasɨnd pɨŋ hɨraimŋgɨmar. Ave mbɨ yupɨr hɨrahɨr osapɨr mbɨndɨŋ han donki nor han insɨŋ ŋgamŋgɨmar. Az Jisasɨv hand insɨŋ ŋkañɨmar. ");
INSERT INTO anh_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Wɨram akŋ anchɨ akŋ hambez mbɨndɨŋ yupɨr hɨrahɨr osapɨr han aŋkwapai ore empasamɨŋ empɨramamŋgɨmar. Emŋgemŋgav antaŋ we aiyena akokazɨŋge empasamɨŋ amamŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ave wɨram akŋ anchɨ akŋ hamb Jisasɨh uhɨmɨŋ ŋaŋgwame hɨromŋgɨmar. Mɨŋamun hanave aware kamŋgɨmar. Ŋɨñɨmbam oŋambam Yakŋ Ohɨrandɨv ñɨm arɨmŋgɨmar. Wɨram hamb Yakŋ Ohɨrand ensaŋ aindai han, eran Yakŋ Ohɨrav ndɨn omanenta sɨz arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Arɨŋɨnd ncha Devit, mbɨkɨr kwɨ haŋ ahevakarɨndari han Yakŋ Ohɨrav omanenta sɨz arɨmŋgɨmar. Yakŋ Ohɨrav Aiampɨra Ohɨra Ñaŋ ñi han, arɨ ndɨndɨv ŋɨñɨmbam oŋambam ñɨm arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Avɨz Jisasɨv Jerusalemɨŋ ahevakare Yakŋ Ohɨrand marɨvai oram ohɨrand imbɨz unchaŋ ahevomar. Ave mbɨ werer ndamar. Kɨrɨm rapɨrɨv ŋkwuŋɨn azand mbɨ sezɨr oman ŋkiŋkiŋg undɨmaj mbɨkɨrmen Betaniŋ ekwaŋg aimŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mach, uiv ŋakaz mbɨ aiampɨra Betani erere ondamŋgɨz, Jisasɨv unsandɨv mamar. ");
INSERT INTO anh_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ave mbɨ waz ai fik hamb taŋɨpɨr kansɨnd ñɨmar. Ai kehan zɨŋɨmp ohɨra. Ave mbɨ ainor han kɨrahɨr ai kehand pɨŋ omar. Kɨrɨm ainor emŋgaŋg mɨwam, nend. Zɨŋɨmbam ñi ainor pamaŋg mɨŋgwɨm. Han ainor ŋgwɨŋgwɨnd iŋgi mah. ");
INSERT INTO anh_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Az Jisasɨv ai fik han mbanave kamar. Amɨ mɨŋ han wɨndɨv ŋgwɨmɨn avɨn wɨramb namŋgɨmɨnj, nendon mɨŋun amar. Avɨz mbɨkɨr sezɨrɨv ya mban njɨhamŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Mach, Jisasɨv sezɨrmen we Jerusalemɨŋ ahevɨkɨrorɨmŋgɨmar. Ahevɨkɨrorɨmŋgɨz Jisasɨv Yakŋ Ohɨrand marɨvai oram ohɨrand imbɨz unchaŋ ahevomar. Ahevohe osa anchɨ nsɨham nor ntɨŋ ŋaŋ ñɨmŋgɨmar han mach osa anchɨ hanɨhan uŋkɨ eŋgwamŋgɨmar hanez ondo ake kiaŋgwɨmar. Ave mbɨndɨŋ antɨm nsɨham nor enororɨnd mach ai esa sam haŋ ŋgarɨwi ikŋɨŋgwɨm uŋkɨ eŋgwamŋgɨj han ŋɨmbi akŋɨrɨzɨŋge pazɨmŋgamar. ");
INSERT INTO anh_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ave mbɨ ndɨŋ erokare kamar. Hanɨhan utuhutuh han Yakŋ Ohɨrand marɨvai oram ohɨrand imbɨz unchaŋ hɨro hɨrai rar hɨrandamŋgɨmɨn amar. ");
INSERT INTO anh_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ave ndɨŋ ya sɨkah kamar. Yakŋ Ohɨrand anɨŋzɨŋ enta ya han mbanave mpamar oh o nend amar. Oram ihɨnd han, han Yakŋ Ohɨrand oram ahaz ororɨnd arar kandɨramŋgi arar mpamar amar. Wɨram akŋ anchɨ akŋ yimbɨm emŋgemŋgand hamb, mbɨ oram mbanaŋ ai yan ahaz orɨndɨramŋgi arar mpamar amar. Kɨrɨm amɨ ndɨn ramŋgɨn ui ŋkwoŋka akɨmɨndɨnd emamp ahevakari amar. ");
INSERT INTO anh_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Avɨz osa anchɨ hamb Jisasɨnd ya han njɨhame ntamŋgɨmar. Az wɨram kɨra anɨŋnsar hanɨhan Yakŋ Ohɨrandɨv ahaz ore ŋgamamɨnd hamb wɨram kɨra ya Mosesɨnd injambɨr ahe sɨkahɨndɨmen han we handɨv mbɨ Jisasɨndɨv ezandɨkŋahambɨmŋgɨmar. Handɨv mbɨ ondo ake empasam Jisas mamta orɨŋgamamɨndiv kɨramŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Mach, nanempand zuh haŋ Jisasɨv sezɨrmen Jerusalem erere omŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mach ave, uiv ŋakaz mband zuhun Jisasɨv sezɨrmen empasamɨŋ aimŋgɨmar. Ai wamŋgɨz ai fik hamb mɨŋɨnd ntɨrɨnd zɨŋɨnd mɨŋam ndɨh pɨrɨravimar. ");
INSERT INTO anh_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Avɨz Pitav hanɨhan Jisasɨv sɨmar han njɨhame kamar. Anɨŋzɨŋ entand, wav amar. Mɨrɨh ai fik mbanamb kɨvah raz arar keman han, irɨh mɨŋam ndɨh pɨrɨri amar. ");
INSERT INTO anh_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Avɨz Jisasɨv ndɨŋ kamar. Amɨ Achakɨñŋam njɨhi aŋkarɨpɨr ŋe njɨhambar amar. ");
INSERT INTO anh_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nzɨ andɨŋ mɨŋun kin amar. Wɨram emŋga hamb aparɨma han imbɨr mbanave kamɨr amar. Amɨ ŋaiahe pɨraŋgore utɨm yambɨŋ ŋkwuv arar kamɨr amar. Mach, wɨram hamb njɨhi undɨmaj mah ñi, hanɨhan kehandɨv njɨhi aŋkarɨpɨr ŋe njɨhamɨz ya mbɨ ki kehamb ndɨndɨv imbɨr ahevakarɨndari han, mbɨ imbɨr ahevakarɨndari amar. ");
INSERT INTO anh_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Handɨv nzɨ andɨŋ kin amar. Amɨ hanaveaŋg hanɨhan ŋaŋɨn are njɨhi aŋkarɨpɨr ŋe njɨhame Yakŋ Ohɨra ahaz orɨndɨramŋgɨn han, hanɨhan amɨ amarɨmŋgɨn kehamb andɨŋndɨv imbɨr ahevakarɨndari amar. ");
INSERT INTO anh_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Mach, andɨŋ wɨram emŋgav enta kɨvah sɨz, mach amɨ aŋkwañɨhɨri Yakŋ Ohɨra ahaz ore mbɨkɨr enta kɨvah han inɨmbɨvar amar. Hanavɨmŋgɨn amandɨŋ Yakŋ mbɨkɨr Aiampɨra Ohɨra Ñaŋ ñi mbanamb mbɨ amandɨŋ enta kɨvah hanez usɨndari amar. ");
INSERT INTO anh_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Mach, Jisasɨv sezɨrmen Jerusalemɨŋ ekwaŋg aimŋgɨmar. Ave Jisasɨv Yakŋ Ohɨrand marɨvai oram ohɨrand imbɨz unchaŋ ŋgwevohe ndazand, wɨram kɨra anɨŋnsar hanɨhan Yakŋ Ohɨrandɨv ahaz ore ŋgamamɨnd, wɨram kɨra ya Mosesɨnd injambɨr ahe sɨkahɨnd, mach wɨram untɨm ohɨra kɨra Judand hamb ndɨn pɨŋ aimŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Mbɨ ai ndɨn mbanave amarɨmŋgɨmar. Amɨ ensa ohɨra han nzɨhandɨh ŋe ntɨŋ mban ŋan arɨmŋgɨmar. Ave nan ensa ohɨra han uñɨmb eŋgwe nan kaz ntɨŋ mban ŋan arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Avɨz Jisasɨv ndɨŋ mbanave kamar. Mach, nzez andɨŋ hanɨhan emŋgandɨv amarɨndarin amar. Amɨ ihɨnd amarar han omanenton kamŋgɨn, uñɨmb yan ensa ohɨrand ntɨŋ mban ŋaŋɨndɨv eŋgwar han nzɨ andɨŋ imbɨr kaŋ wandɨramŋgɨn amar. ");
INSERT INTO anh_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Eŋambɨr Jonɨmb osa anchɨ han yambɨŋ ŋazɨkŋirɨŋgwi ŋambiahanj amar. Han Yakŋ Ohɨrav ndɨn kaz ranj arar njɨhamŋgɨn oh o wɨram hamb ndɨn kamŋgɨz ranj arar njɨhamŋgɨn amar. ");
INSERT INTO anh_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Mach, mbɨ mbon mbon mbanave kamŋgɨmar. Arɨ Yakŋ Ohɨrav ndɨn kaz ranj arar kamɨrɨŋaŋg kɨrɨm mbɨ kandari arɨmŋgɨmar. Utɨndɨv amɨ ndɨnɨh eŋambɨrun njɨhi aŋkarɨpɨr njɨhamɨmah ramŋgan arar kandari toh arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Kɨrɨm arɨ kamɨrɨŋ wɨram hamb ndɨn kamŋgɨz ranj arar kamɨrɨŋ arɨmŋgɨmar. Mbɨ wɨram akŋ anchɨ akŋndɨv ezandɨkŋahambɨmŋgɨmar. Wɨram akŋ anchɨ akŋ hamb Jon ndɨnɨh wɨram Yakŋ Ohɨrand ya injambɨr ahe kanj arar njɨhamŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Handɨv Jisasɨnd ya han mbɨŋ ke kamŋgɨmar. Arɨ mɨwarɨm arɨmŋgɨmar. Avɨz Jisasɨv ndɨŋ kamar. Nzez nzɨ andɨŋ mɨkandɨram ensa ohɨra han nzɨhandɨh ŋe ntɨŋ mban ŋin han amar. ");
INSERT INTO anh_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Mach, Jisasɨv ndɨŋ ondo ake ya ahɨmb akŋ han kamar. Wɨram emŋgav kɨrɨpa nor yambɨnsɨndɨnd war uimɨr amar. Ui imbɨz han ŋakare mɨn ohɨra awamɨr amar.|f* Ave mbɨ wɨram kɨrav war mban wehɨrehɨrɨndɨv war oram asɨmɨr amar. Ave mbɨ war mban wɨram kɨra emŋgemŋgand oman insɨŋ ŋgamɨr amar. Mach, kɨrɨpa nor yambɨnsɨndɨnd wanɨrɨv kamɨr amar. Amɨ ihɨnd war mban omanenta wehɨre mach kɨrɨpa nor yambɨnd hanaveaŋg ŋandɨramŋgɨn arar kamɨr amar. Ave mbɨ isupɨr taŋɨpɨr handɨh omɨr amar. ");
INSERT INTO anh_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Avɨz kɨrɨpa nor yambɨnsɨnd hamb mɨŋ ŋgwi ntawɨmɨr amar. Ave war wanɨrɨv wɨram ntɨŋ mamah ŋamɨr pamuh kehan kaz wɨram kɨra kɨrɨpa nor yambɨnsɨndɨnd war ntɨŋ ŋamŋgɨmɨr hand pɨŋ omɨr amar. Ndɨndɨv kɨrɨpa nor yambɨnsɨnd han eŋgwamŋgɨz are omɨr amar. ");
INSERT INTO anh_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Avɨz wɨram kɨra war ntɨŋ ŋamŋgɨmɨr hamb wɨram mban ŋe orɨmŋgɨmɨr amar. Ave ndɨn kiaŋgwɨmŋgɨz mamahon omɨr amar. ");
INSERT INTO anh_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mach, war wanɨrɨv wɨram ntɨŋ mamah ŋamɨr emŋga han kaz we ndɨŋ pɨŋ omɨr amar. Avɨz mbɨ zɨ mbɨkɨr han orampɨhe ampi eŋgwe ndɨn kɨvahun sɨmŋgɨmɨr amar. ");
INSERT INTO anh_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Az war wanɨrɨv wɨram emŋga han kaz oz ndɨn mamta orɨŋgamŋgɨmɨr amar. Avɨz war wanɨrɨv wɨram akŋ han kaz ndɨŋ pɨŋ omŋgɨmɨr amar. Ave hanaveaŋg orempɨre mach hanaveaŋg mamta orempɨramŋgɨmɨr amar. ");
INSERT INTO anh_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Avɨz wɨram pamuh ñɨmɨr amar. Wɨram mban mbɨkɨr nor, mbɨ ndɨndɨvon ramɨr amar. Mach, ansam han nor mbɨkɨr han kaz mbɨ wɨram kɨra war ntɨŋ ŋamŋgɨmɨr hand pɨŋ omɨr amar. Mbɨkɨr wanɨrɨv mbon mbanave kamɨr amar. Mbɨ ihɨnd nor han we ampi ake mbɨkɨr ya han imbɨr njɨhamɨndɨramŋgi arar kamɨr amar. ");
INSERT INTO anh_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Kɨrɨm wɨram kɨra war ntɨŋ ŋamŋgɨmɨr mbanamb mbon ya mbon ya kamŋgɨmɨr amar. Wɨram mbanamb utuhutuh wanɨrɨnd han mɨŋam ŋandari arar kamŋgɨmɨr amar. Aimŋgɨn ndɨn mamta orɨm arar kamŋgɨmɨr amar. Az war mban arɨŋɨndɨvam arar kamŋgɨmɨr amar. ");
INSERT INTO anh_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ave ndɨn ŋe mamta ore kɨrɨpa nor yambɨnsɨndɨnd war akɨp handɨh avɨzumŋgɨmɨr amar. ");
INSERT INTO anh_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Avɨz war wanɨr hamb utɨzɨmɨr amar. Mbɨ ai wɨram kɨra kɨrɨpa nor yambɨnsɨndɨnd war ntɨŋ ŋamŋgɨmɨr mban mamta orempɨramɨr amar. Ave kɨrɨpa nor yambɨnsɨndɨnd war mban wɨram emŋgemŋga han eŋgwamɨr amar. ");
INSERT INTO anh_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Amɨ Yakŋ Ohɨrand anɨŋzɨŋ enta mban mamehɨmŋgɨm oh a amar. Ya mbanamb mbanave ki amar. Nsɨham mban wɨram kɨra oram asazɨnd hamb mbɨ kɨvah are ŋavɨzumŋgɨmar arar ki amar. Kɨrɨm nsɨham mbanamb nsɨham anɨŋnsar ukɨnd ñi arar ki amar. ");
INSERT INTO anh_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Yakŋ Ohɨrav mbon kaz ndɨh ahevakari arar ki amar. Handɨv arɨ ndɨn warɨŋ mbɨ arɨŋɨnd ampɨn insɨŋ imbɨrun ñi arar ki amar. ");
INSERT INTO anh_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ave mach, mbɨ wamŋgɨz, Jisasɨv ya ahɨmb ndɨŋndɨv kamar. Avɨz mbɨ Jisas aŋgwore ŋaŋɨndɨv njɨhamŋgɨmaraŋg, kɨrɨm wɨram akŋ anchɨ akŋndɨv ezandɨkŋahambɨmŋgɨmar. Ave mbɨ Jisas erere omŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Mach ave, mbɨ kamŋgɨz wɨram untɨm Farisind hamb wɨram untɨm Herotɨnd hamen Jisasɨnd pɨŋ aimŋgɨmar. Ave mbɨ Jisasɨv yaya opɨha kaz ndɨn ya oramɨŋ hɨroŋɨn are aimŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ave mbɨ ai ndɨn kamŋgɨmar. Anɨŋzɨŋ entand, arɨ ndɨh warɨŋ, amɨ wɨram ya mɨŋun karɨn arɨmŋgɨmar. Amɨ wɨram akŋ hamb handɨhambam arar njɨhame ndɨŋndɨv enta pamuh rarɨn arɨmŋgɨmar. Ave wɨram ensansɨnd o ensa mah amɨ ndɨŋndɨv hanaveam rarɨn arɨmŋgɨmar. Ya mɨŋɨndɨv amɨ wɨram akŋ anchɨ akŋ Yakŋ Ohɨrand enta akŋ han sɨkarɨn arɨmŋgɨmar. Arɨ imbɨr ekwanz uŋkɨ han Sisarɨnɨdɨv eŋgwamɨrɨŋ oh o nend arɨmŋgɨmar. Arɨ eŋgwamɨrɨŋ oh o nend toh arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Avɨz Jisasɨv mbɨndɨŋ yosa han ndɨh wamar. Ave mbɨ ndɨŋ mbanave kamar. Amɨ utɨndɨv yan ondo mpamŋgɨn amar. Amɨ nsɨham nor emŋga han ŋe hɨraimŋgɨn waŋ amar. ");
INSERT INTO anh_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Az mbɨ nsɨham nor han ŋe eŋgwamŋgɨz Jisasɨv ndɨŋ amarɨmar. Emansɨŋ mban mach ensa mban uñɨnd amar. Az mbɨ kamŋgɨmar. Han Sisarɨnd arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Avɨz Jisasɨv ndɨŋ mbanave kamar. Utuhutuh Sisarɨnd han, han amɨ Sisar eŋgwavar amar. Mach, utuhutuh Yakŋ Ohɨrand han, han Yakŋ Ohɨra eŋgwavar amar. Avɨz, mbɨ ya mbɨkɨr mban njɨhame ntamŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Mach, untɨm Sadyusind hamb Jisasɨnd pɨŋ aimŋgɨmar. Untɨm mbanamb kamŋganj. Wɨram hamb me, mbɨ ekwaŋg mɨŋaiyahandɨram arɨmŋganj. Ave mbɨ Jisasɨh mbanave amarɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Anɨŋzɨŋ entand, Mosesɨv arɨŋɨndɨv enta mbanave mpamar arɨmŋgɨmar. Wɨram emŋgav maz, anchɨrɨv mbah ñi ave nornanch mah raz, mbɨkɨr ranɨrɨv anchɨ mban ŋe nornanch akore yanɨrɨnd ensaŋ ŋɨmbɨzahaz arar mpamar arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Az mach, zɨŋgɨr pamuh hamb nor kɨra ahins ñɨmŋganj arɨmŋgɨmar. Mbɨndɨŋ azɨŋ anɨŋnsar hamb anchɨ mban ŋe, mboz mamar arɨmŋgɨmar. Mbɨ nornanch mah arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Avɨz ranɨrɨvez anchɨ mban ŋe, mbez mamar arɨmŋgɨmar. Mbez nornanch mah arɨmŋgɨmar. Az ranɨr emŋgavez enta haremampaŋg ramar arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Mach, ahins hamb nornanch mah arɨmŋgɨmar. Avɨz mapɨŋ mɨŋun haŋ, anchɨ mbanambez mamar arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Avɨz mapɨŋ haŋ, osa anchɨ hamb ekwaŋg ŋaiahamŋgɨz, anchɨ mban uñɨmanɨnd anchɨ ñɨndari arɨmŋgɨmar. Amɨ ndɨh wan, wɨram akŋ ahins hamb ndɨn ŋamŋgɨz avɨz ndɨn anchɨ mbɨndɨŋ emamp ñanj arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Avɨz Jisasɨv ndɨŋ kamar. Amɨ ya Yakŋ Ohɨrand anɨŋzɨŋ enta unchaŋ ñi han mach Yakŋ Ohɨrand aŋkarɨpɨr hanez mɨwamŋgɨrɨm amar. Handɨv amɨ ya opɨha kamŋgɨn amar. ");
INSERT INTO anh_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wɨram akŋ anchɨ akŋ mamŋgɨmar hamb, mbɨ ekwaŋg ŋondɨrahandɨramŋgi amar. Kɨrɨm wɨram akŋ anchɨ akŋ kehamb, mbɨ anuwa mah anchɨ mah ñɨhɨrɨndɨramŋgi amar. Nend amar. Mbɨ Yakŋ Ohɨrand mapɨŋ akŋ Yakŋ Ohɨrand Aiampɨra Ohɨra Ñaŋɨnd emamp ñɨndɨramŋgi amar. ");
INSERT INTO anh_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Avɨz wɨram akŋ anchɨ akŋ hamb mamŋgɨz Yakŋ Ohɨrav ndɨŋ ekwaŋg ŋɨmbɨzahandari han, amɨ ya Mosesɨnd hamb anɨŋzɨŋ enta unchaŋ ñi han mamehɨmŋgɨm oh a amar. Yakŋ Ohɨrav aisaz handɨh Mosesɨh kamar amar. Yan Yakŋ Ohɨra Abrahamɨnd Aisekɨnd Jekopɨnd arar kamar amar. ");
INSERT INTO anh_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yakŋ Ohɨrah ndɨn wɨram akŋ anchɨ akŋ mamtand Yakŋ Ohɨra mah amar. Ndɨn wɨram akŋ anchɨ akŋ kɨpɨrɨnsɨnd ñɨmŋgi hand Yakŋ Ohɨra amar. Amɨ ya opɨha ndɨh kamŋgɨn amar. ");
INSERT INTO anh_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mach, wɨram ya Mosesɨnd injambɨr ahe sɨkahɨnd emŋga hamb ai njɨhamɨzand untɨm Sadyusind hamb Jisasmen ya aŋkarɨpɨr kamŋgɨmar. Mbɨ njɨhamɨzand Jisasɨv mbɨndɨŋ ya mbɨŋ ke kamar han imbɨrun ñɨmar. Ave mbɨ Jisasɨh amarɨmar. Utɨman entav enta akŋ han epari anɨŋnsar ñi amar. ");
INSERT INTO anh_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Avɨz Jisasɨv ndɨn mbɨŋ ke kamar. Enta anɨŋnsar ñi han mbanɨmb amar. Andɨŋ Israelɨnd omanenta njɨhambar amar. Anɨŋnsar Ohɨra, ndɨn Yakŋ Ohɨra arɨŋɨnd, ndɨnɨh Anɨŋnsar Ohɨra pamuhun amar. ");
INSERT INTO anh_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Amɨ amakɨr achakɨñndɨvam rav amar. Amɨ amakɨr mpɨ unchaŋ ndɨndɨvam rav amar. Amakɨr kɨpɨrɨŋ, njɨhi amakɨrɨŋ, mach amakɨr aŋkarɨpɨrɨŋ ndɨndɨvam rav amar. ");
INSERT INTO anh_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Mach, enta emŋga han mbanɨmb amar. Amɨ amakɨr ya pamɨnd handɨv rav amondɨv rarɨn hanaveaŋg amar. Enta emŋgemŋga hamb enta undɨmaj mbanan meparɨmŋgɨm amar. ");
INSERT INTO anh_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Avɨz wɨram ya Mosesɨnd injambɨr ahe sɨkahɨnd mbanamb Jisasɨh mbanave kamar. Anɨŋzɨŋ entand, amɨ ya han mɨŋun kan amar. Yakŋ Ohɨrah ndɨn pamuhun arar kan amar. Yakŋ Ohɨra emŋgemŋgavaŋg mɨñɨm, nend arar kan amar. ");
INSERT INTO anh_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ave amɨ ya hanez kan amar. Arɨ Achakɨñndɨvam arɨŋɨnd mpɨ unchaŋ ram arar kan amar. Ave njɨhi arɨŋɨndɨŋ, mach arɨŋɨnd aŋkarɨpɨrɨŋ ndɨndɨvam ram arar kan amar. Ave arɨ arɨŋɨnd ya pamɨnd handɨv ram arondɨv rarɨŋ emamp arar kan amar. Arɨ enta undɨmaj mban mpehɨromɨrɨŋ han, enta mbanamb enta emŋgemŋga han eparɨj amar. Mbɨ enta hanɨhan Yakŋ Ohɨrandɨv ahaz ore ŋgamamɨnd pɨrɨtɨmɨŋ mɨŋam uŋgɨj han eparɨj amar. Mach, mbɨ hanɨhan emŋga Yakŋ Ohɨrandɨv ahaz ore ŋgamamɨnd hanez eparɨj amar. ");
INSERT INTO anh_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Wɨram mbanamb ya kazand Jisasɨv waz ndɨn wɨram njɨhi imbɨrɨnd emamp ñɨmar. Avɨz Jisasɨv ndɨn kamar. Amɨ Yakŋ Ohɨrand kwɨ haŋ taŋɨpɨr mɨñɨm amar. Avɨz wɨram akŋ hamb Jisas ekwaŋg amarɨŋɨn arar ezandɨkŋahambɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Mach ave, Jisasɨv Yakŋ Ohɨrand marɨvai oram ohɨrand imbɨz unchaŋ ñɨmar. Ave mbɨ wɨram akŋ anchɨ akŋ han ya sɨke amarɨmar. Utɨndɨv wɨram kɨra ya Mosesɨnd injambɨr ahe sɨkahɨnd hamb mbanave kamŋgɨj amar. Wɨram Yakŋ Ohɨrav mbɨkɨr osa anchɨ ekwaŋg ŋɨmbɨmbɨndɨv uyɨŋgwamɨmar han ndɨn Devitɨnd nor arar kamŋgɨj amar. ");
INSERT INTO anh_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Kɨpɨr Imbɨr Yakŋ Ohɨrand hamb Devitɨh njɨhi eŋgwaz mbɨ mbonam mbanave kamar amar. Yakŋ Ohɨrav Anɨŋnsar Ohɨrah ihɨnd han mbanave kamar amar. Amɨ ihɨnd oman mɨŋɨnd haŋ ŋkañɨn nzɨ imbɨr amakɨr ahambɨrɨñarɨh ichorɨŋ amakɨr kwɨŋ ñɨndɨramŋgi arar kamar amar. ");
INSERT INTO anh_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Az Devitɨv mbonam kamar amar. Wɨram mbanamb ihɨnd Anɨŋnsar Ohɨra ñi arar kamar amar. Avɨz utɨndɨv wɨram mbanamb Devitɨnd nor ñi amar. Ave mach, wɨram akŋ anchɨ akŋ ohɨron hamb Jisasɨnd ya han njɨhame ŋɨñɨmbam oŋambam ñɨhɨrɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Mach, Jisasɨv ndɨŋ sɨke kamar. Amɨ wɨram kɨra ya Mosesɨnd injambɨr ahe sɨkahɨnd han omanenta werɨvar amar. Mbɨ yupɨr hɨrahɨr osapɨr han hɨrandandɨv njɨhamŋgɨj amar. Ave wɨram akŋ anchɨ akŋ hamb ndɨŋ rapɨrɨnt eŋgwamŋgɨz are uŋkɨ eŋgweŋgw ampɨra akŋ handɨvam njɨhamŋgɨj amar. ");
INSERT INTO anh_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ave mbɨ sam ŋkañɨñɨnd hamb Yakŋ Ohɨrand marɨvai oramɨŋ anɨŋnsar ñi han ŋaŋɨndɨv njɨhamŋgɨj amar. Mach, yuŋk ohɨra unsa nand haŋ mbɨ sam ŋkañɨñɨnd anɨŋnsar ñi han ŋaŋɨndɨvez njɨhamŋgɨj amar. ");
INSERT INTO anh_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Mach, mbɨ anchɨ kɨra enduwa kɨra han yosa si mbɨndɨŋ hanɨhan utuhutuh han mɨŋam ŋɨmbɨmŋgɨj amar. Ave mbɨ Yakŋ Ohɨra osapɨr ohɨra ahaz oror ñɨmŋgɨj amar. Kɨrɨm mbɨ yosa sɨmŋgɨj amar. Handɨv yuŋk ansam yuŋk ohɨra ya kahɨnd hamb ahevakarɨz mbɨ kɨr ohɨra ŋandɨramŋgi amar. ");
INSERT INTO anh_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Mach ave, marɨvai oram ohɨra Yakŋ Ohɨrand ai esa nsɨham norɨnd hamb ñi handɨh Jisasɨv ikwɨm ŋkañɨmar. Ave mbɨ wehɨrɨzand wɨram akŋ anchɨ akŋ hamb ai nsɨham nor han ai esa nsɨham norɨnd unchaŋ hɨrɨzɨŋgwɨmŋgɨmar. Az wɨram akŋ anchɨ akŋ nsɨham norɨnsɨnd hamb nsɨham nor akŋ han ai esa unchaŋ hɨrɨzɨŋgwɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Avɨz anchɨ enduwa hanɨhan mah apar hamb ai nsɨham nor undɨmaj akav han ai esa nsɨham norɨnd unchaŋ hɨrɨzɨŋgwɨmar. ");
INSERT INTO anh_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Avɨz Jisasɨv sezɨr mbɨkɨr han oreŋgɨz aimŋgɨmar. Aimŋgɨz mbɨ ndɨŋ mbanave kamar. Nzɨ andɨŋ mɨŋun kin amar. Anchɨ hanɨhan mah apar mbɨkɨr mamɨrɨv ndɨh mamar mbanamb, mbɨ nsɨham nor ohɨra eŋgwi amar. Mbɨ wɨram akŋ anchɨ akŋ hamb nsɨham nor akŋ ai esa nsɨham norɨnd unchaŋ hɨrɨzɨŋgwɨmŋgɨmar han epari amar. ");
INSERT INTO anh_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Wɨram akŋ anchɨ akŋ hamb nsɨham nor akŋ mbɨndɨŋ han mbah amar. Mbɨ ohɨra kamah hɨrɨzɨŋgwɨmŋgi amar. Kɨrɨm anchɨ mbanamb nsɨham nor mbɨkɨr han mɨŋam hɨrɨzɨŋgwi amar. Ave mbɨ nsɨham nor unsa uŋkɨ eŋgweŋgw han apar amar. ");
INSERT INTO anh_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Mach, Jisasɨv Yakŋ Ohɨrand marɨvai oram ohɨra han erere ozand sezɨr emŋga mbɨkɨr hamb ndɨn ya mbanave kamar. Anɨŋzɨŋ entand, amɨ nsɨham ohɨra akŋ imbɨrpamun mban we nsɨham oram ohɨra akŋ imbɨrpamun mbanez wav amar. ");
INSERT INTO anh_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Az Jisasɨv ndɨn mbɨŋ mbanave kamar. Amɨ oram nsɨham ohɨra akŋ imbɨrpamun mbanan wan oh a amar. Njɨmɨnj haŋ wɨram hamb oram akŋ mbanan akore uvɨhaindɨramŋgi amar. Ave mbɨ nsɨham emŋga han ererɨmŋgɨz nsɨham emŋgand insɨŋ mɨŋkañɨndɨram amar. ");
INSERT INTO anh_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Mach, Jisasɨv aparɨma Oliv handɨh ŋkañi waz Yakŋ Ohɨrand marɨvai oram ohɨra hamb mbɨhoh handɨh ñɨmar. Az Pita, Jems, Jon, Andru, hanave mbon ikumun Jisasɨnd pɨŋ ai ndɨn amarɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Arɨŋ kan wam, hanɨhan mbanamb nzɨhandɨhaŋ ahevakarɨndɨramŋgi arɨmŋgɨmar. Utɨman mboz ahevakarɨz han we kandɨrarɨŋ arɨmŋgɨmar. Hanɨhan utuhutuh kɨr ohɨra hamb ikwɨm ndɨh ahevakarɨndɨramŋgi arar kandɨrarɨŋ arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Az Jisasɨv ndɨŋ ondo ake kamar. Amɨ omanenta wehɨrɨvar amar. Ave wɨram emŋga hamb ai andɨŋ yosa kamɨnj amar. ");
INSERT INTO anh_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Wɨram akŋ hamb ihɨnd ensaŋ ai kandɨramŋgi amar. Han nzon arar kandɨramŋgi amar. Ave mbɨ wɨram akŋ anchɨ akŋ han yosa sɨndɨramŋgi amar. ");
INSERT INTO anh_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Mach, njɨmɨnj haŋ amɨ ihɨrɨv ohɨra aŋkwɨnd han, mach yansɨ aŋkwɨ ohɨra hamb ui nzɨmoh nzɨmoh haŋ ahevakarɨz han njɨhame, amɨ ntamŋgɨmɨn amar. Yakŋ Ohɨrand njɨhi hamb mbanave ñɨmar amar. Hanɨhan utuhutuh kɨr ohɨra mbanamb ahevɨkɨrorɨndɨramŋgi amar. Kɨrɨm yuŋk ansam han ichar amar. ");
INSERT INTO anh_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Wɨram akŋ anchɨ akŋ yimbɨm pamuhɨnd hamb wɨram akŋ anchɨ akŋ yimbɨm emŋgand hamen ŋondɨrahe era mpandɨramŋgi amar. Ave wɨram akŋ anchɨ akŋ wɨram anɨŋnsar ohɨrand kwɨ ñɨmŋgɨj hamb wɨram akŋ anchɨ akŋ wɨram emŋga anɨŋnsar ohɨrand kwɨ ñɨmŋgɨj hamenez ŋondɨrahe era mpandɨramŋgi amar. Mach, isupɨr nzɨmoh nzɨmoh han oŋɨra hamb tɨm emŋga tɨm emŋga ŋandari amar. Mach, rapɨrɨvam rapɨrɨvam ñɨz unsa mah apar ñɨzand wɨram akŋ anchɨ akŋ hamb unsandɨv mahɨndɨramŋgi amar. Hanɨhan utuhutuh mbanamb ahevakarɨndɨramŋgi han anchɨ kɨrav nornanch akarɨŋɨn are pɨrɨvɨr ohɨra ŋamŋgɨj haremampaŋg amar. ");
INSERT INTO anh_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Mach, haŋonaŋg amɨ amonaŋg omanenta wehɨrɨvar amar. Mbɨ andɨŋ ŋɨmbi ya oram ohɨraŋ mach Yakŋ Ohɨrand marɨvai oramɨŋ hɨrohe andɨŋ orɨndɨramŋgi amar. Amɨ yandɨv wɨram kɨra anɨŋnsar ohɨra osa anchɨnd mach wɨram kɨra anɨŋnsarɨnd, mbɨndɨŋ emansɨŋ aŋkwañɨndɨramŋgɨn amar. Ave amɨ ndɨŋndɨv Yakŋ Ohɨrand ya imbɨr han eŋgwandɨramŋgɨn amar. ");
INSERT INTO anh_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Az Yakŋ Ohɨrand njɨhi hamb mbanave ñi amar. Wɨram akŋ anchɨ akŋ yimbɨm emŋgand emŋgand han Yakŋ Ohɨrand ya imbɨr han mboz eŋgwamŋgɨz amar. ");
INSERT INTO anh_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ave, mbɨ andɨŋ ŋɨmbi ya oramɨŋ hɨromŋgɨz amɨ ya han uti arar kandɨramŋgɨn handɨv njɨhi osapɨr njɨhamŋgɨmɨn amar. Ya akŋ pɨr akŋ han andɨŋ Yakŋ Ohɨrand Kɨpɨr Imbɨr hamb eŋgwandari han, haŋon kɨrɨmam kavar amar. Ya mbanan njɨhi amandɨŋon mɨkandɨramŋgɨm, nend amar. Kɨpɨr Imbɨr Yakŋ Ohɨrand hamb mbon kandari amar. ");
INSERT INTO anh_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Wɨram hamb mbɨkɨr ranɨrɨh mamta ororndɨv ranɨrɨh ya oramɨŋ hɨrondari amar. Mach, wanɨrɨv mbɨkɨr nornanch han hanaveonaŋg randari amar. Nornanch hambez mɨŋunjɨr wunjɨrɨnd ya han mɨnjɨhamɨndɨramŋgɨm, mbɨ ndɨŋ mamta orempɨrɨndɨramŋgi amar. ");
INSERT INTO anh_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Avɨz ihɨnd ensandɨv wɨram akŋ anchɨ akŋ hamb andɨŋ wamŋgɨz mbɨndɨŋ mpɨ hamb kɨrɨm kɨvah randɨramŋgi amar. Kɨrɨm osa anchɨ hamb aŋkarɨpɨron ñɨmŋgɨzand yuŋk ansam hamb ahevakarɨndari han Yakŋ Ohɨrav ndɨŋ ekwaŋg ŋɨmbɨndari amar. ");
INSERT INTO anh_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Jisasɨv mbahon mbanave kamar. Amɨ wamŋgɨn, nsɨham kɨvah wɨramb omanɨŋ ŋaŋ hamb sam Yakŋ Ohɨrav erokarɨj handɨh aŋkwañɨndari amar. (Wɨram anɨŋzɨŋ enta mban amehehɨnd hamb omanenta njɨhamɨz.) Mach, wɨram kɨra aiampɨra akŋ Judiand ñɨhɨrɨmŋgi hamb kɨrore aparɨma akŋ aparɨma haŋ omŋgɨz amar. ");
INSERT INTO anh_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Az wɨram oram umpɨrɨŋ ñi ŋkaindari kehamb, mbɨ mbɨkɨr hanɨhan han ŋɨmbɨŋɨn are ekwaŋg oram unchaŋ ahevomɨnj amar. ");
INSERT INTO anh_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Wɨram war unchaŋ ñɨndari kehamb, mbɨkɨr yupɨr hɨrahɨr osapɨr han ŋaŋɨn are ekwaŋg oramɨŋ omɨnj amar. ");
INSERT INTO anh_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Mach, yuŋk haŋonaŋg anchɨ kɨra mpɨnsɨnd mach anchɨ kɨra nornanch aŋkwɨrnsɨnd man icha namŋgi kehamb, mbɨ kɨr ohɨra ŋandɨramŋgi amar. ");
INSERT INTO anh_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Amɨ Yakŋ Ohɨra ahaz orɨmŋgɨn, kɨr ohɨra hamb apɨñɨnd haŋ mahevakarɨndɨram amar. ");
INSERT INTO anh_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Mach, haŋonaŋg hanɨhan kɨr ohɨra hamb ñɨndari amar. Eŋambɨrun Yakŋ Ohɨrav isupɨr mban ŋgame ŋgamɨmar han aim atɨ irɨh ñɨñmbɨrarɨŋ han, eŋambɨr han kɨr ohɨra kehand hamb mahevakarɨm ramar amar. Mach, njɨmɨnj hanez kɨr ohɨra kehand hambez ekwaŋg mahevakarɨndɨram amar. ");
INSERT INTO anh_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Kɨrɨm Yakŋ Ohɨrav kɨr ohɨra kehandɨv yuŋk han pach ŋgamɨmah ramɨr han, wɨram akŋ anchɨ akŋ hamb mɨŋamun kwevɨrɨmŋgɨmɨr amar. Kɨrɨm osa anchɨ mbondɨv uyɨzɨŋgwɨmar kehandɨv njɨhame, handɨv Yakŋ Ohɨrav yuŋk han pach ŋgamɨndari amar. ");
INSERT INTO anh_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Mach, haŋonaŋg andɨŋ wɨram emŋgav kandari amar. Wavar arar kandari amar. Wɨram Yakŋ Ohɨrav mbɨkɨr osa anchɨ ekwaŋg ŋɨmbɨmbɨndɨv uyɨŋgwamɨmar hamb, mbɨ mbanɨmb ñi o mbɨhoh kenɨmb ñi arar kandari amar. Mbɨkɨr ya han njɨhi aŋkarɨpɨr ŋe njɨhamŋgɨmɨn amar. ");
INSERT INTO anh_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Wɨram kɨra yosand hamb ahevakarɨndɨramŋgi amar. Hanaveaŋg kandɨramŋgi amar. Yan wɨram Yakŋ Ohɨrav mbɨkɨr osa anchɨ ekwaŋg ŋɨmbɨmbɨndɨv uyɨŋgwamɨmar han kaz aiin hamb arar kandɨramŋgi amar. Hanaveaŋg kandɨramŋgi amar. Yan wɨram Yakŋ Ohɨrand ya injambɨr ahe sɨkah emŋga hamb arar kandɨramŋgi amar. Ave mbɨ Yakŋ Ohɨrav ndɨŋ kaz mbɨ ntɨŋ Yakŋ Ohɨrand ŋaŋ mbɨramɨŋɨn are ntɨŋ aŋkarɨpɨr pamuh han sɨndɨramŋgi amar. Mach, mbɨ utuhutuh ntɨŋ aŋkarɨpɨr endɨraparam han sɨndɨramŋgi amar. Ave osa anchɨ Yakŋ Ohɨrav mbondɨv uyɨzɨŋgwɨmar han ŋɨmbi empasam kɨvahɨŋ hɨroŋɨn are mbɨ ndɨŋ yosa sɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Handɨv amɨ omanenton wehɨrɨvar amar. Utuhutuh hamb ahevakarɨndari handɨv, andɨŋ ya han ndɨh kandɨkin amar. ");
INSERT INTO anh_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Mach, Jisasɨv mbahon kamar. Utuhutuh kɨr ohɨra hamb mach raz, haŋonaŋg rapɨr hamb zuh razand tɨhɨr hambez mɨkɨrandɨram amar. ");
INSERT INTO anh_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Mach, ndɨvah hamb raka han erere ŋgorahɨrɨndɨramŋgi amar. Avɨz utuhutuh aŋkarɨpɨr rakand hambez kɨrɨm ntandɨramŋgi amar. ");
INSERT INTO anh_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Mach, yuŋk haŋonaŋg wɨram akŋ anchɨ akŋ hamb wamŋgɨzand Wɨramɨnd Nor hamb raka unchaŋ ñi mbɨkɨr aŋkarɨpɨr ohɨransɨnd mach mpamɨnd ohɨransɨnd aindari amar. ");
INSERT INTO anh_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Mach, yuŋk haŋonaŋg mbɨ Yakŋ Ohɨrand mapɨŋ akŋ han kaz we osa anchɨ mbondɨv uyɨzɨŋgwɨmar han isupɨr nzɨmoh nzɨmoh ñɨmŋgi handɨh aŋkwezawɨndɨramŋgi amar. ");
INSERT INTO anh_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Mach, Jisasɨv mbahon kamar. Amɨ ya ahɨmb ai fikɨnd haŋ ondo wavar amar. Aiyena nor nor mbɨkɨr hamb yambɨnsɨnd ñɨz zɨŋ ŋkwɨrɨŋ nor nor hamb ondo ake ahaj han, amɨ wamŋgɨn yambɨnd iŋgi hamb ikwɨm ndɨh ivɨndari amar. ");
INSERT INTO anh_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Mach, hanaveonaŋg, nzɨ hanɨhan andɨŋ kaŋ ahevakarɨndari han we wamŋgɨn yuŋk ansam hamb ikwɨm ndɨh ivɨndari amar. ");
INSERT INTO anh_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nzɨ andɨŋ mɨŋun kin amar. Osa anchɨ irɨh ñɨmŋgɨmbɨri mbanamb mamah ramŋgɨzand utuhutuh akŋ hamb haŋ ahevakarɨndari amar. ");
INSERT INTO anh_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Mach, rakand isupɨrɨnd mbɨ undɨmaj kwevɨrɨndɨramŋgi amar. Kɨrɨm ihɨnd ya hamb mɨkwevɨrɨndɨram amar. ");
INSERT INTO anh_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Mach, Jisasɨv mbahon kamar. Utuhutuh mbanamb ahevakarɨndari han wɨram emŋgavaŋg mbɨ yuŋk, rapɨraŋk han mɨwarɨm amar. Yakŋ Ohɨrand mapɨŋ akŋ hamb mach Nor mbɨkɨr hambez mɨwamŋgɨrɨm amar. Yakŋ Ohɨravam yuŋk mbanan waj amar. ");
INSERT INTO anh_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Utuhutuh mbanamb ahevakarɨndari han amɨ mɨwamŋgɨrɨm amar. Handɨv amɨ ŋkɨrañi omanenton wehɨrɨvar amar. ");
INSERT INTO anh_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Han, wɨram emŋgav mbɨkɨr oram erere we ui emŋgaŋ ndamɨr emampaŋg amar. Ave mbɨ mbɨkɨr wɨram kɨra ntɨŋ mamah ŋaŋɨnd hamb mbɨkɨr utuhutuh akŋ han werɨmŋgɨz are, mbɨ ndɨŋndɨv ntɨŋ pamuh pamuh rar ambɨroror eŋgwarɨmbɨmɨr amar. Ave mbɨ wɨram impikŋ wehɨrehɨrɨnd han kamɨr amar. Amez omanenta werɨv arar kamɨr amar. ");
INSERT INTO anh_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Handɨv amɨ omanenton werɨvar amar. Amɨ yuŋk oram wanɨrɨv ekwaŋg aindari han amɨ mɨwamŋgɨrɨm amar. Han mbɨ nanempand o zuh urɨm aindari han o aporamɨndɨv orazand aindari han o mband zuhun aindari hanez amɨ mɨwamŋgɨrɨm amar. ");
INSERT INTO anh_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ave mbɨ pams haŋon ai waz amɨ ikwɨ mbah ŋgañɨmŋgɨmɨn amar. ");
INSERT INTO anh_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ya mban andɨŋ eŋgwin han, wɨram akŋ anchɨ akŋ mɨŋam ndɨŋndɨvez eŋgwin amar. Handɨv amɨ omanenta wehɨrɨvar amar. ");
INSERT INTO anh_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Mach avɨz, ñir emamp haŋ, Yuŋk Ohɨra Yakŋ Ohɨrav Israelɨnd han Ŋɨmbɨzahevaimar Hamb mach Yuŋk Ohɨra Eŋka Yis Mah Hamb ahevakarɨmar. Mach, haŋonaŋg wɨram kɨra anɨŋnsar hanɨhan Yakŋ Ohɨrandɨv ahaz ore ŋgamamɨnd hamb wɨram kɨra ya Mosesɨnd injambɨr ahe sɨkahɨnd hamen hanave awakŋi ya ore kamŋgɨmar. Arɨ nzɨhanave Jisasɨh yosa si aŋgwore ŋe ya oramɨŋ hɨrohe mamta orɨŋgamɨndɨrarɨŋ arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Arɨ yuŋk ohɨra mɨroma unsa sɨzɨnd haŋ ndɨn mɨŋam arɨmŋgɨmar. Ave osa anchɨ hamb arɨŋ we aŋkwɨ ŋakamŋgɨmɨnj arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Mach ave, Jisasɨv aiampɨra Betani handɨh we, wɨram emŋga usɨ aŋkarɨpɨr yupɨr okaŋgaŋgɨnsɨnd hand oramɨŋ ñɨmar. Mbɨkɨr ensa Saimon. Jisasɨv ñi antɨmɨŋ ŋkañɨzand anchɨ emŋga hamb ai nsɨham nchɨ nor kwarupɨr emamp aiwɨr yamb uñakŋnsɨnd han hɨraimar. Aiwɨr yamb han, han wahanz mɨŋ, han nsɨham nor ohɨra. Mach, anchɨ mbanamb nsɨham nchɨ nor han ŋazɨware aiwɨr yamb han Jisasɨnd zɨ handɨh ampɨhamar. ");
INSERT INTO anh_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ampɨhazand wɨram emŋgemŋga hamb wamŋgɨz ndɨŋ mpɨkɨm pɨr raz mbon ya mbon ya kamŋgɨmar. Mbɨ utɨndɨv aiwɨr yamb han mamah ŋkari arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Arɨ wɨram eŋgwarɨŋ uŋkɨ eŋgwamŋgɨmɨr han, arɨ imbɨr nsɨham nor 300 silva ŋe osa anchɨ hanɨhan mah han eŋgwamɨrɨŋ arɨmŋgɨmar. Ave mbɨ anchɨ mbanan aŋkwɨ sɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Avɨz Jisasɨv ndɨŋɨh kamar. Ndɨn ererɨvar amar. Amɨ utɨndɨv ndɨn kɨr eŋgwamŋgɨn amar. Mbɨ yanɨh enta imbɨrun si amar. ");
INSERT INTO anh_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Osa anchɨ hanɨhan mah hamb andɨŋmen mbah mbah ñɨndɨramŋgi amar. Amɨ ndɨŋ hɨrawɨŋɨn are, amɨ imbɨr hɨrawɨndɨramŋgɨn amar. Nzɨp andɨŋmen mbah mbah mɨñɨndɨram amar. ");
INSERT INTO anh_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Enta han anchɨ mbanamb ramɨr han ndɨh ri amar. Ihɨnd yupɨr han aiwɨr yamb uñakŋnsɨndɨŋ ndɨh ampɨhi amar. Handɨv nzɨ maŋ yan hanaveonaŋg aiwɨr yamb uñakŋnsɨndɨŋ aŋkwe ŋgwamŋgɨŋɨnj amar. ");
INSERT INTO anh_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nzɨ andɨŋ mɨŋun kin amar. Mbɨ isupɨr nzɨmoh nzɨmoh we Yakŋ Ohɨrand ya imbɨr eŋgwandɨramŋgi haŋ, anchɨ mbanand enta handɨvɨnsɨnd kandɨramŋgi amar. Ave mbɨ anchɨ mbanez njɨhamɨndɨramŋgi amar. ");
INSERT INTO anh_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Mach ave, Jisasɨv oman ŋkiŋkiŋg undɨmaj sezɨrɨh ensamamar han, emŋga mbɨndɨŋ Judas Iskariot. Mach, Jisasɨh mbɨndɨŋ oman insɨŋ ŋgamɨŋɨn are, Judasɨv wɨram kɨra anɨŋnsar hanɨhan Yakŋ Ohɨrandɨv ahaz ore ŋgamamɨnd pɨŋ omar. ");
INSERT INTO anh_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Avɨz mbɨ han njɨhame mpɨ imbɨrvam ñɨhɨri ndɨn nsɨham nor eŋgwaŋɨn arar kamŋgɨmar. Az Judasɨv, Jisasɨh ŋe mbɨndɨŋ oman insɨŋ ŋgamamɨndɨv empa kɨrɨm kɨramar. ");
INSERT INTO anh_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mach ave, yuŋk anɨŋnsar Yuŋk Ohɨra Eŋka Yis Mahɨnd Hamb ndɨh ahevakarɨmar. Mach, yuŋk haŋonaŋg mbɨ Yuŋk Ohɨra Yakŋ Ohɨrav Israelɨnd han Ŋɨmbɨzahevaimarɨnd sipsip han orempɨramŋganj. Mach, yuŋk mbanamb ahevakarɨz Jisasɨnd sezɨrɨv ndɨnɨh amarɨmŋgɨmar. Arɨ nzɨhandɨh we hanɨhan omanenta sɨndɨrarɨŋ arɨmŋgɨmar. Ave mɨroma unsa han ne Yuŋk Ohɨra Yakŋ Ohɨrav Israelɨnd Han Ŋɨmbɨzahevaimar Han njɨhamɨndɨran arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Avɨz Jisasɨv mbɨkɨr sezɨr undɨmaj han kamar. Amɨ aiampɨra ohɨraŋ ahevohe wamŋgɨn wɨram emŋgav nchɨ yambɨnsɨnd han asɨŋ akŋi andɨŋ empasamɨŋ awakŋɨndari amar. Ndɨn mpehɨrovar amar. ");
INSERT INTO anh_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Mbɨ we wɨram emŋgand oramɨŋ ahevondari han, mach amɨ oram kehand wanɨr han mbanave kavar amar. Anɨŋzɨŋ entandɨv ki arar kavar amar. Oram uncha emŋga han nzɨ unsa nanɨnd han nzɨhandɨh ñi arar ki arar kavar amar. Nzɨ ihɨnd saimen mɨroma unsa ne Yuŋk Ohɨra Yakŋ Ohɨrav Israelɨnd Han Ŋɨmbɨzahevaimar Han njɨhamɨndɨrarɨŋ arar ki arar kavar amar. ");
INSERT INTO anh_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Hanave kamŋgɨn mbɨ andɨŋ oram uncha ohɨra emŋga mbɨhawarɨnd han mbɨramɨz wamŋgɨn hanɨhansɨnd ñɨndari amar. Mach, amɨ kehaŋ ahevohe arɨŋɨndɨv mɨroma unsa han kɨrɨm omanenta sɨvar amar. ");
INSERT INTO anh_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ave mbɨ we aiampɨra ohɨraŋ ahevohe wamŋgɨz hanɨhan kamar hamb hanaveon ñɨhɨrɨmar. Avɨz mach, mbɨ mɨroma unsa han kɨrɨm omanenta sɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Mach, nanempand zuh razand Jisasɨv sezɨr oman ŋkiŋkiŋg undɨmajɨmen aimŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ai antɨmɨŋ ŋgarɨwi namŋgɨzand Jisasɨv ndɨŋ kamar. Nzɨ andɨŋ mɨŋun kin amar. Wɨram emŋga amandɨŋ unsa pamɨnd yanɨmen nanmbɨri mbanambonaŋg yan ŋe ihɨnd ahambɨrunjɨnd oman insɨŋ ŋgamɨndari amar. ");
INSERT INTO anh_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Az sezɨrɨv han njɨhamŋgɨz mbɨndɨŋ mpɨ hamb kɨr ohɨra ñɨz pamuh pamuh ndɨn amarɨmŋgɨmar. Nzɨ nend toh, nzɨ nend toh arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Avɨz Jisasɨv ndɨŋ kamar. Wɨram emŋga amandɨŋ oman ŋkiŋkiŋg undɨmaj mbonaŋg tor uncha pamɨnd yanɨmen sɨŋgwɨŋaŋmbɨri hambonaŋg randari amar. ");
INSERT INTO anh_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ya Yakŋ Ohɨrand hamb anɨŋzɨŋ enta unchaŋ ñi hamb mbanave ñi amar. Wɨramɨnd Nor mbanamb mandari arar mpamar amar. Kɨrɨm wɨram mbanamb, Wɨramɨnd Nor han kambɨrɨñɨrɨnd oman insɨŋ ŋgamɨndari kehamb, mbɨ pɨrɨvɨr ohɨra ŋandari amar. Mɨŋɨrɨv ndɨn akarɨ mah ramɨr, han imbɨr amar. ");
INSERT INTO anh_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mach, mbɨ namŋgɨzand Jisasɨv eŋka han ŋe Yakŋ Ohɨrah ya imbɨr eŋgwe ŋaŋepamar. Ŋaŋepe ndɨŋ eŋgwe kamar. Mban nambar amar. Mban yupɨr ihɨnd amar. ");
INSERT INTO anh_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Mach, mbɨ sɨhomɨŋai kɨrɨpa nor yambɨnsɨnd han ŋe Yakŋ Ohɨrah ya imbɨr eŋgwe mach re ndɨŋ eŋgwaz mɨŋam namŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Namŋgɨz ndɨŋ kamar. Mban ntɨ ihɨnd, han ya aŋkarɨpɨr kehan aminjinjɨnd hamb amar. Ihɨnd ntɨ hamb wɨram akŋ anchɨ akŋndɨv akŋɨrɨzɨŋgandari amar. ");
INSERT INTO anh_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nzɨ andɨŋ mɨŋun kin amar. Nzɨ kɨrɨpa nor yamb mbanan ekwaŋg mɨnandɨram amar. Ñɨñ nde waŋ Yakŋ Ohɨrav osa anchɨ hanaveaŋg ŋɨmbɨz mbɨkɨr kwɨŋ ñɨndɨramŋgi kehamb ahevakarɨz kɨrɨpa nor yamb ichon nandarin amar. ");
INSERT INTO anh_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Mach, Jisasɨv sezɨrmen marɨvai ekamŋgɨz mach raz aiampɨra ohɨra han erere ahevetai aparɨma Olivɨŋ awaromŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Mach, Jisasɨv ndɨŋ kamar. Amɨ yan ererɨndɨramŋgɨn amar. Yakŋ Ohɨrand anɨŋzɨŋ enta hamb hanave ki amar. Nzɨ wɨram sipsip wehɨrehɨrɨnd han orɨŋgamɨŋ sipsip hamb pamuh pamuh rar kɨrorɨndɨramŋgi arar ki amar. ");
INSERT INTO anh_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Kɨrɨm Yakŋ Ohɨrav yan ekwaŋg ŋambiahaz nzoz injore isupɨr Galilindɨŋ ondarin amar. ");
INSERT INTO anh_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Mach avɨz, Pitav ndɨn kamar. Wɨram emŋgemŋgav nan ererɨmŋgɨz, nzɨ nan mererɨndɨram amar. ");
INSERT INTO anh_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Avɨz Jisasɨv ndɨn kamar. Nzɨ nan mɨŋun kin amar. Irɨh zuh han aporamɨnd hamb undɨmaj tɨm oramah razand amɨ undɨmapam tɨm kandɨran amar. Nzɨ ndɨn mɨwarɨm arar kandɨran amar. ");
INSERT INTO anh_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Az Pitav ya aŋkarɨpɨr ke kamar. Yand nand eran orempɨramŋgɨz amar. Nzɨ ndɨn mɨwarɨm arar mɨkandɨram amar. Mach, sezɨr emŋgemŋga hamb hanaveam kamŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Mach avɨz, Jisasɨv sezɨrmen isupɨr emŋga han, mbɨkɨr ensa Getsemani handɨh ahevɨkɨrorɨmŋgɨz ndɨŋ mbanave kamar. Amɨ mbanaŋ ŋgarɨwɨmŋgɨnand, nzɨ Yakŋ Ohɨra ahaz orɨndarin amar. ");
INSERT INTO anh_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ave mbɨ Pitand Jemsɨnd Jonɨnd ŋɨmbi mpahɨromar. Jisasɨv we ondo ake njɨhame hɨro hɨrai raz muyakam. Az mpɨ mbɨkɨr hamb kɨr kɨvah ñɨmar. ");
INSERT INTO anh_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ave ndɨŋ kamar. Yan mpɨ hamb kɨr kɨvah ñi amar. Kɨr hamb raz nzɨ mandarin toh amar. Amɨ mbanaŋ ñi omanenta wehɨrɨvar amar. ");
INSERT INTO anh_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ave sɨwaŋkwe paravɨzɨŋgwi ŋgañi Yakŋ Ohɨrah ahaz oror kamar. Yakŋ, ui kɨvah hamb yan imbɨr kivɨmɨr oh o nend amar. ");
INSERT INTO anh_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ooo Abba, ihɨnd Yakŋ amar. Amɨ hanɨhan utuhutuh imbɨr sɨmɨn amar. Sɨhomɨŋai mban yanɨŋ kiaŋgwɨv amar. Kɨrɨm ihɨnd njɨhiŋam ŋamɨn amar. Amakɨr njɨhiŋon ŋamb amar. ");
INSERT INTO anh_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Mach, mbɨ hanave ahaz ore ke ekwaŋg ai waz sezɨr undɨmapam hamb ikwɨ ŋgañɨmŋgɨmar. Ave mbɨ Pitah kamar. Saimon, amɨ ikwɨ ŋgañɨñɨmbɨran oh a amar. Amɨ utɨndɨv rapɨraŋk pamuh ñiaŋg wehɨrɨmah ran amar. ");
INSERT INTO anh_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Amɨ wehɨrehɨr Yakŋ Ohɨrah ahaz oror ñɨmbar amar. Ave Satanɨmb andɨŋ enta kɨvah rarɨndɨv ŋajɨmɨnj amar. Mpɨ hamb hanɨhan sɨzɨndɨv ri amar. Kɨrɨm yupɨr han ndɨn aŋkarɨpɨr mah amar. ");
INSERT INTO anh_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ave mbɨ ekwaŋg we eŋambɨr Yakŋ Ohɨra ahaz orɨmar hanaveonaŋg ahaz orɨmar. ");
INSERT INTO anh_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Mach, ndɨŋ ikwɨnd ikwɨnd ahaz ramŋgɨmar. Az Jisasɨv ekwaŋg ai waz sezɨrɨv ikwɨ ŋgañɨmŋgɨmar. Avɨz ndɨŋ emɨrazahaz mbɨ nte ndɨn ya utɨman arar kamŋgɨmɨr han mɨwamŋgɨm. ");
INSERT INTO anh_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Avɨz Jisasɨv ekwaŋg ai sezɨrɨh mbanave kamar. Amɨ mbah ŋgañi wɨr ñɨmŋgɨmbɨran oh a amar. Ui mach amar. Rapɨraŋk hamb ndɨh ahevakari amar. Mbɨ Wɨramɨnd Nor han ŋe wɨram enta kɨvah sɨzɨnd oman insɨŋ ŋgamɨndari amar. ");
INSERT INTO anh_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ŋaiahamŋgɨn om amar. Wavar amar. Wɨram yan mbɨndɨŋ oman insɨŋ ŋgamɨndari hamb ndɨh ahevakari amar. ");
INSERT INTO anh_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Mach ave, Jisasɨv ya mban kah ñɨzand mbɨkɨr sezɨr emŋga Judasɨh, ndɨn emŋga mbɨndɨŋ Jisasɨv oman ŋkiŋkiŋg undɨmaj sezɨrɨh ensamamar hamb, mbɨ pams haŋon ahevakarɨmar. Mach, wɨram kɨra anɨŋnsar hanɨhan Yakŋ Ohɨrandɨv ahaz ore ŋgamamɨnd, wɨram kɨra ya Mosesɨnd injambɨr ahe sɨkahɨnd, mach wɨram untɨm ohɨra kɨra Judand hanave kamŋgɨz wɨram akŋ hamb Judasmen aimŋgɨmar. Mbɨ naip osapɨrɨnd aitɨmɨnd hanave hɨraimŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Mach, wɨram Jisasɨh kambɨrɨñɨrɨnd oman insɨŋ ŋgamɨmar hamb ndɨŋ eŋambɨrun kamar. Nzɨ we wɨram ndɨn kɨm kandarin haŋ wavar amar. Ndɨn aŋgwore ŋe oman uŋkɨri hɨrohe omanenta ovɨherɨvar amar. ");
INSERT INTO anh_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Mach, Judasɨv ahevakare Jisasɨnd pɨŋ pams haŋon ai kamar. Anɨŋzɨŋ entand are kɨrɨm kɨm kamar. ");
INSERT INTO anh_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kɨm kaz mach, emŋgemŋga hamb ndɨn aŋgwore kɨrɨm ŋamŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Wɨram emŋga hamb wɨram anɨŋnsar ohɨra hanɨhan Yakŋ Ohɨrandɨv ahaz ore ŋgamamɨnd ntɨŋ mamah ŋaŋɨnd hamb mbez aimar. Mach, wɨram emŋga ikwɨm aŋkwañɨmar hamb naip osapɨr mbɨkɨr han ŋe wɨram kehand njempɨŋ han mɨŋam akokamar. ");
INSERT INTO anh_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Avɨz Jisasɨv ndɨŋ kamar. Yan wamŋgɨn wɨram akɨmɨnd ñɨŋ, handɨv naip osapɨrɨnd aitɨmɨnd ŋe yan aŋgwore ŋaŋɨn are aimŋgɨn oh a amar. ");
INSERT INTO anh_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nzɨ andɨŋmenam Yakŋ Ohɨrand marɨvai oram ohɨraŋ ñɨñ ya sɨkajin amar. Utɨndɨv yan haŋon aŋgwore ŋamah ramŋgan amar. Kɨrɨm eran ya anɨŋzɨŋ enta Yakŋ Ohɨrand unchaŋ ñi han hamb ahevakarɨz amar. ");
INSERT INTO anh_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Mbɨ hanave kaz, sezɨrɨv ndɨn erere kɨrɨm kɨrorɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","52","Mach avɨz, wɨram norŋɨr emŋga hamb imɨn okamɨŋam epe Jisas mpehɨromar. Mpehɨrozand ndɨn aŋgwore ŋaŋɨn arar ramŋgɨz, kɨrɨm mbɨ imɨn han erere iriŋgir okarɨmar. ");
INSERT INTO anh_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Mach avɨz, wɨram kɨra hamb Jisasɨh wɨram anɨŋnsar ohɨra hanɨhan Yakŋ Ohɨrandɨv ahaz ore ŋgamamɨnd pɨŋ hɨromŋgɨmar. Hɨromŋgɨz wɨram kɨra anɨŋnsar hanɨhan Yakŋ Ohɨrandɨv ahaz ore ŋgamamɨnd, wɨram untɨm ohɨra kɨra Judand, mach wɨram kɨra ya Mosesɨnd injambɨr ahe sɨkahɨnd mɨŋamun hanave aŋkwezawɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Wɨram emŋgemŋga hamb Jisasɨh hɨromŋgɨzand Pitav taŋɨpɨr kansɨnd mpehɨromar. Mpehɨrohe we imbɨz wɨram anɨŋnsar ohɨra hanɨhan Yakŋ Ohɨrandɨv ahaz ore ŋgamamɨnd haŋ ahevohe irɨvɨnd kɨramen pɨrɨtɨmɨŋ yupɨr iŋki ŋgarɨwɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mach, wɨram kɨra anɨŋnsar hanɨhan Yakŋ Ohɨrandɨv ahaz ore ŋgamamɨnd, mach aiyopand kɨra mɨŋamun, mbɨ Jisasɨh mamta orɨŋgamɨŋɨn are wɨram emŋgemŋga oreŋgɨmŋgɨmar. Mbɨ Jisasɨv utuhutuh enta kɨvah kɨvah sanj kehan kamŋgɨz wawɨndɨv ndɨŋ oreŋgɨmŋgɨz aimŋgɨmar. Az nend. ");
INSERT INTO anh_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Wɨram akŋ hamb ai ndɨn ya yosa yosa kamŋgɨzand kɨrɨm ya mbɨndɨŋ hamb pamɨnd mɨñɨm. ");
INSERT INTO anh_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Mach, wɨram hanaveaŋg aŋkwañɨhɨri ndɨn ya yosa mbanave kamŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","Arɨ njɨhamɨrɨŋand mbɨ hanɨh arar kar arɨmŋgɨmar. Nzɨ oram Yakŋ Ohɨrand wɨramb asɨmŋgɨmar mban akorɨndarin arar kar arɨmŋgɨmar. Mach, ñir emamp haŋ icha asɨndarin arar kar arɨmŋgɨmar. Icha han wɨramb masɨndɨramŋgɨm arar kar arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Kɨrɨm ya mbɨndɨŋ hambez pamɨnd mɨñɨm. ");
INSERT INTO anh_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Mach ave, wɨram anɨŋnsar ohɨra hanɨhan Yakŋ Ohɨrandɨv ahaz ore ŋgamamɨnd hamb, mbɨ aiyopand kɨrand uhɨmɨŋ aŋkwañi Jisasɨh amarɨmar. Amɨ nanɨh ya hamb awawɨmbɨramŋgi handɨv amɨ utɨndɨv ya han orake kamah ran amar. ");
INSERT INTO anh_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kɨrɨm Jisasɨv ya orake mɨkam. Avɨz wɨram anɨŋnsar ohɨra hanɨhan Yakŋ Ohɨrandɨv ahaz ore ŋgamamɨnd hamb ndɨn ekwaŋg amare kamar. Nan wɨram Yakŋ Ohɨrav mbɨkɨr osa anchɨ ekwaŋg ŋɨmbɨmbɨndɨv uyɨŋgwamɨmar hamb oh a amar. Nan Yakŋ Ohɨrand nor mbɨkɨr ensa ŋambiaharɨrɨŋ hand oh a amar. ");
INSERT INTO anh_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Az Jisasɨv kamar. Han nzon amar. Handɨv amɨ wamŋgɨn Wɨramɨnd Nor hamb Yakŋ Ohɨra oman mɨŋɨnd aŋkarɨpɨrnsɨnd handɨh ŋkañɨndari amar. Mbɨ raka uncha ñaŋ handɨh ñi ŋkaindari amar. ");
INSERT INTO anh_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Mbɨ hanave kaz wɨram anɨŋnsar ohɨra hanɨhan Yakŋ Ohɨrandɨv ahaz ore ŋgamamɨnd hamb yupɨr hɨrahɨr osapɨr mbɨkɨr han ŋunchɨri kamar. Arɨ wɨram emŋgemŋga han mbɨkɨr enta mban kampɨhe kahɨndɨv wɨndɨv moreŋgɨŋam amar. ");
INSERT INTO anh_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Mbon Yakŋ Ohɨrah yarahe kaz ndɨh njɨhamŋgɨn amar. Arɨ ndɨn utɨzɨndɨrarɨŋ amar. Az mbɨ mɨŋam ya vɨhe kamŋgɨmar. Mbɨ enta kɨvahɨnsɨnd, mbɨ eran maz arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Mach ave, wɨram emŋgemŋgav ondo ake ndɨn mpɨñ atazɨpazivi imɨn emansɨŋ ampɨnsɨŋ asɨrame ndɨn oror kamŋgɨmar. Nan uñɨmb ororɨmbɨramŋgi arɨmŋgɨmar. Nan Yakŋ Ohɨrav ya kaŋɨnj han kav arɨmŋgɨmar. Mbɨ yan orɨmŋgi arar kav arɨmŋgɨmar. Mach avɨz, irɨvɨnd hamb ndɨn ŋe orɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Mach, Pitav mbɨŋkw oram imbɨz uncha handɨh ñɨmar. Ñɨzand anchɨ emŋga hamb aimar. Anchɨ mbanamb wɨram anɨŋnsar ohɨra hanɨhan Yakŋ Ohɨrandɨv ahaz ore ŋgamamɨnd oramɨŋ ntɨŋ ŋanj. ");
INSERT INTO anh_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Mbɨ ai waz Pitav pɨrɨtɨmɨŋ yupɨr iŋki ŋkañɨmar. Ŋkañɨzand anchɨ mbanamb ndɨn omanenton wehɨre kamar. Amez Jisas Nasaretɨndmen ñɨrɨn amar. ");
INSERT INTO anh_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Az Pitav kamar. Nzɨ nend amar. Nzɨ amakɨr ya kan han mɨwarɨm amar. Ave ŋaiahe ahevai oram imbɨz impikŋ handɨh aŋkwañɨmar. Az aporamɨnd hamb oramar. ");
INSERT INTO anh_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Avɨz Pitav aŋkwañɨzand anchɨ mbanamb ekwaŋg we ondo ake wɨram emŋgemŋga aŋkwañɨhɨrɨmŋgɨmar han kamar. Wɨram mbanambez ndɨŋmen ñɨj amar. ");
INSERT INTO anh_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Az mbɨ ekwaŋg nend arar kamar. Mach, ñɨñ nde wɨram kɨra aŋkwañɨhɨrɨmŋgɨmar hamb Pitah kamŋgɨmar. Mɨŋun arɨmŋgɨmar. Nan wɨram mbɨndɨŋun arɨmŋgɨmar. Nan wɨram han Galilind arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Avɨz mbɨ ya aŋkarɨpɨron ke kamar. Ñaŋ ohɨra amar. Nzɨ yosa kaŋɨn han, Yakŋ Ohɨrav yan eran kɨvah sɨz amar. Amɨ wɨram ndɨndɨv kamŋgɨn kehan nzɨ mɨwarɨm amar. ");
INSERT INTO anh_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Mach, ya mban kazand pams haŋon aporamɨnd hamb ekwaŋg kɨrɨm oramar. Orazand Pitav Jisasɨv ndɨn ya kamar handɨv njɨhamɨmar. Aporamɨnd hamb undɨmaj tɨm oramah razand amɨ undɨmapam tɨm kandɨran amar. Nzɨ ndɨn mɨwarɨm arar kandɨran amar. Jisasɨnd ya kehan njɨhame Pitav njɨhi kɨrɨm ŋe ŋgwañ ohɨra ekamar. ");
INSERT INTO anh_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Mach ave, uiv ŋakaz wɨram kɨra anɨŋnsar hanɨhan Yakŋ Ohɨrandɨv ahaz ore ŋgamamɨnd, wɨram untɨm ohɨra kɨra Judand, wɨram kɨra ya Mosesɨnd injambɨr ahe sɨkahɨnd, mach aiyopand emŋgemŋga hamen hanave awakŋi Jisasɨndɨv ya orɨmŋgɨmar. Ya orɨmŋgɨz mach raz Jisasɨh vɨhe omanaka uŋkɨri hɨrohe Pailatɨnd oman insɨŋ ŋgamŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ŋgamŋgɨz Pailatɨv Jisasɨh amarɨmar. Nan wɨram anɨŋnsar ohɨra osa anchɨ Judand oh a amar. Az ndɨn kamar. Amon ndɨh kan amar. ");
INSERT INTO anh_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Mach, wɨram kɨra anɨŋnsar hanɨhan Yakŋ Ohɨrandɨv ahaz ore ŋgamamɨnd hamb Jisasɨndɨv kamŋgɨmar. Mbɨ enta kɨvah kɨvah ranj arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Avɨz Pailatɨv ndɨn ekwaŋg amarɨmar. Amɨ utɨndɨv ya kamah ran amar. Amɨ enta kɨvah kɨvah rarɨn arar kamŋgi han, ndɨh njɨhamɨnaŋg oh a amar. ");
INSERT INTO anh_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Az nend. Jisasɨv ya emŋgaŋg evoke mɨkam. Avɨz Pailatɨv njɨhi osapɨr njɨhakɨramamar. ");
INSERT INTO anh_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Mach, war pamuh pamuh yuŋk ohɨra mɨroma unsa nand hamb ahevakarɨz Pailatɨv wɨram pamuh rar oram kɨvahɨnd han enduwazand ahevetaimŋganj. Osa anchɨv wɨramɨnd ensa oreŋgɨmŋgɨz Pailatɨv njɨhame enduwazand wɨram hamb ahevaianj. ");
INSERT INTO anh_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Mach, eŋambɨr haŋ wɨram hanaveaŋg gavmanmen erampe wɨram mamta orempɨramŋgɨmar. Orempɨramŋgɨz irɨvɨnd hamb wɨram han ŋɨmbi kɨravɨhe oram kɨvahɨŋ inchakarɨmŋgɨz ñɨmŋgɨmar. Wɨram era mpambɨnd han mbɨndɨŋ emŋga mbɨkɨr ensa han Barabas. ");
INSERT INTO anh_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mach, wɨram akŋ anchɨ akŋ hamb aharai Pailatɨh amare kamŋgɨmar. Amɨ war eŋambɨr enta randɨn hanaveaŋg arɨŋɨndɨv war mbanaŋ randɨran oh o nend oh arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Avɨz Pailatɨv ndɨh wamar. Wɨram kɨra anɨŋnsar hanɨhan Yakŋ Ohɨrandɨv ahaz ore ŋgamamɨnd hamb wamŋgɨz osa anchɨ hamb Jisasɨndɨvam njɨhamŋgɨmar. Handɨv anɨŋnsar kɨra hamb ndɨn ŋe Pailatɨnd oman insɨŋ ŋgamŋgɨmar. Avɨz Pailatɨv osa anchɨ han amarɨmar. Amɨ nzɨhanave njɨhamŋgɨn amar. Andɨŋndɨv wɨram anɨŋnsar ohɨra osa anchɨ Judand han enduwaŋ ahevaindɨv njɨhamŋgɨn oh a amar. ");
INSERT INTO anh_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Kɨrɨm wɨram kɨra anɨŋnsar hanɨhan Yakŋ Ohɨrandɨv ahaz ore ŋgamamɨnd hamb osa anchɨ han kamŋgɨz mpɨ mbɨndɨŋ hamb ŋaiahaz Pailatɨh kamŋgɨmar. Arɨŋɨndɨv Barabasŋam enduwan ahevaiz arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Hanave kamŋgɨz Pailatɨv ndɨŋ ekwaŋg amarɨmar. Nzɨ wɨram mban amɨ ndɨn wɨram anɨŋnsar ohɨra osa anchɨ Judand arar kamŋgɨn han utɨzɨndarin amar. ");
INSERT INTO anh_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Az mbɨ aware kamŋgɨmar. Ndɨn ai oŋkɨrandɨŋ orɨkavɨzuv arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Avɨz Pailatɨv ndɨŋ amarɨmar. Mbɨ utɨman enta kɨvah si amar. Avɨz mbɨ ohɨra kɨvah aware kamŋgɨmar. Ndɨn ai oŋkɨrandɨŋ orɨkavɨzuv arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Mach, Pailatɨv osa anchɨ hamb imbɨr ñɨmŋgɨz are oram kɨvahɨnd han enduwaz Barabasɨv ahevaimar. Avɨz Pailatɨv kaz mbɨkɨr aŋkwɨnd hamb kɨrɨpa aŋkarɨpɨr ŋe Jisas ore kɨramŋgɨmar. Orɨmŋgɨz mach raz Pailatɨv Jisasɨh ŋe irɨvɨndɨnd oman insɨŋ ŋgame kamar. Ndɨn hɨrohe ai oŋkɨrandɨŋ orɨkavɨzuvar amar. ");
INSERT INTO anh_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Mach, irɨvɨnd hamb ndɨn oman uŋkɨri hɨrohe oram gavmand imbɨz mbɨkɨr ensa Pretorium unchaŋ hɨrahevomŋgɨmar. Ndɨn hɨrahevohe irɨvɨnd emŋgemŋga han oreŋgɨmŋgɨz aimŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ai yupɨr hɨrahɨr osapɨr opaŋg han ŋe ndɨnɨŋ ŋgamɨmar. Mbɨ kɨrɨpahensɨnd hanez ŋe uŋkɨsarkɨr anɨŋnsar ohɨrand emamp ondɨhe Jisasɨnd zɨ handɨh ŋgamŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ave mbɨ ndɨnɨh yarahe kamŋgɨmar. Rapɨrɨnd anɨŋnsar ohɨra osa anchɨ Judand arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ave mbɨ karpa han ŋe zɨ mbɨkɨr han oror ndɨn mpɨñ atazɨpazivɨmŋgɨmar. Mach, mbɨ andamesa mpɨrorɨzɨŋgwɨŋgw waroreŋge ndɨn ensa ŋambiahah ramŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ave mach, mbɨ hanave yarahoparahamŋgɨz mach raz yupɨr hɨrahɨr osapɨr opaŋg han ŋapai yupɨr hɨrahɨr akŋ mbɨkɨrun han ndɨnɨŋon ekwaŋg ŋgamŋgɨmar. Ŋgame ndɨn ai oŋkɨrandɨŋ orɨkavɨzuŋɨn are oman uŋkɨri hɨromŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Mach, wɨram emŋga mbɨkɨr ensa han Saimon, aiampɨra ohɨra mbɨkɨr Sairini. Ndɨn Aleksanderɨnd Rufusɨnd wanɨr. Mbɨ antaŋ ñi aiampɨra ohɨraŋ oŋɨn are ai ndɨŋ kivɨŋɨn azand aŋkwɨnd hamb ndɨn ŋe hɨrai Jisasɨnd ai oŋkɨrand han eŋgwamŋgɨz orambimar. ");
INSERT INTO anh_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Az mbɨ Jisasɨh isupɨr Golgota handɨh hɨromŋgɨmar. Isupɨrɨnd ensa kehand ondo han mbanave, unsɨŋ nsarɨnd. ");
INSERT INTO anh_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Mbɨ kɨrɨpa nor yamb han ai upɨr yamb mbɨkɨr ensa mɨr hansɨnd ŋe itɨmai Jisas eŋgwamŋgɨmar. Kɨrɨm mbɨ mɨnam. ");
INSERT INTO anh_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Avɨz wɨram kɨra aŋkwɨnd hamb ndɨn ai oŋkɨrandɨŋ orɨkavɨzumŋgɨmar. Orɨkavɨzu mbɨkɨr yupɨr hɨrahɨr akŋ han ŋe uñɨmb epari ñi pamuh pamuh ŋaŋɨn are Jisasɨnd yupɨr hɨrahɨr akŋ han atakŋɨŋɨn are ainor akŋ oŋa awɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Mach, rapɨraŋk ensa ohɨrand kwɨ mband haŋ ndɨnɨh ai oŋkɨrandɨŋ orɨkavɨzumŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Mach, ya ndɨn enta kɨvah ranj arar kamŋgi han ai esaŋ Jisasɨnd zumpɨr insɨ handɨh hanave mpamŋgɨmar. Wɨram anɨŋnsar ohɨra osa anchɨ Judand arar mpamŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Mbɨ wɨram undɨmaj akɨmɨnd han Jisasɨnsɨnd ai oŋkɨrandɨŋ orɨkavɨzumŋgɨmar. Emŋga Jisasɨnd oman mɨŋɨndɨŋ, emŋga oman ovejɨndɨŋ orɨkavɨzumŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Avɨz wɨram akŋ anchɨ akŋ hamb ai we yarahoparahah nde nsar onarar kamŋgɨmar. Aria arɨmŋgɨmar. Nan wɨram mbanand hamb Yakŋ Ohɨrand oram akore yuŋk undɨmapamɨŋ imbɨr asɨndɨran arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Amonaŋg hɨrawi ai oŋkɨrand han erere ŋgaŋkwav arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mach, mbɨ kamŋgɨzand wɨram kɨra anɨŋnsar hanɨhan Yakŋ Ohɨrandɨv ahaz ore ŋgamamɨnd mach wɨram kɨra ya Mosesɨnd injambɨr ahe sɨkahɨnd hanaveonaŋg mbon mbon ndɨn yarahah kamŋgɨmar. Mbɨ wɨram emŋgemŋga han hɨrawɨj arɨmŋgɨmar. Kɨrɨm mbɨ mbon hɨrawaw han nend arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ndɨn wɨram Yakŋ Ohɨrav mbɨkɨr osa anchɨ ŋɨmbɨmbɨndɨv uyɨŋgwamɨmar hamb mach wɨram anɨŋnsar ohɨra osa anchɨ Israelɨnd kehamb arɨmŋgɨmar. Mbɨ eran ai oŋkɨrand han erere ŋgaŋkwaz, han we ndɨndɨv njɨhi aŋkarɨpɨr ŋe njɨhamɨm arɨmŋgɨmar. Hanave kamŋgɨz wɨram akɨmɨnd undɨmaj ndɨn pɨŋ orɨkavɨzumŋgɨmar hambez hanaveonaŋg Jisasɨh yarahamŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Mach, andar pach haŋ zuh re ñi nanempand haŋ rapɨraŋk undɨmapam ñɨzand rapɨrɨv ekwaŋg kɨramar. ");
INSERT INTO anh_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nanempand rapɨraŋk undɨmapam ñɨzand Jisasɨv aware kamar. Eloi, Eloi, lama sabaktani amar. Ya mbanand ondo han mbanave, Yakŋ Ohɨra ihɨnd, Yakŋ Ohɨra ihɨnd, yan utɨndɨv ererɨn amar. ");
INSERT INTO anh_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Avɨz wɨram emŋgemŋga hamb ikwɨm aŋkwañɨhɨri ya han njɨhame kamŋgɨmar. Wavar arɨmŋgɨmar. Mbɨ Elaija oreŋgeŋgɨmbɨri arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Avɨz wɨram emŋgav aŋɨraŋɨr we imɨnɨsa han ŋe kɨrɨpa nor yamb ntɨkŋ haŋ ŋgwame hɨraimar. Hɨrai imɨnɨsa han aipaŋ vɨhe Jisasɨv naz are ŋambiahe eŋgwamar. Mbɨ ndɨn eŋgwe kamar. Ŋkɨrañɨr weaŋg amar. Elaijav ai ndɨn ŋenduwaz ŋgaŋkwandari oh o nend oh amar. ");
INSERT INTO anh_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Mach ave, Jisasɨv kwa aware mamta mamar. ");
INSERT INTO anh_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Mbɨ maz imɨn ohɨra Yakŋ Ohɨrand marɨvai ohɨra oram unchaŋ ñɨmar kehamb zɨndɨŋon unchɨrahe andamɨndɨŋon hɨrɨŋgwavohe tɨm undɨmaj ñɨmar. ");
INSERT INTO anh_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Mach, wɨram anɨŋnsar aŋkwɨnd kehamb ikwɨm aŋkwañi Jisasɨv mamar han we kamar. Mɨŋun amar. Wɨram mban Yakŋ Ohɨrand Nor amar. ");
INSERT INTO anh_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Anchɨ kɨra hamb mbez taŋɨpɨr kansɨnd aŋkwañi wehɨrɨmŋgɨmar. Emŋga Maria aiampɨra Makdaland. Emŋga Maria Josepɨnd mɨŋɨr, mach Josepɨnd ranɨr Jemsɨnd mɨŋɨr. Jemsɨh wɨram norŋɨr. Emŋga Salome. ");
INSERT INTO anh_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Eŋambɨr haŋ, Jisasɨv Galili handɨh ñɨzand anchɨ kɨra mbanamb mpehɨrohe ndɨn hɨrawɨmŋganj. Anchɨ kɨra emŋgemŋga hamb Jisasmen Jerusalemɨŋ aimŋgɨmar hambez aŋkwañi wehɨrɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Mach ave, Josep aiampɨra Arimateand hamb Jerusalemɨŋ ñanj. Ndɨnɨh wɨram aiyopand emŋga. Osa anchɨ hamb wamŋgɨz mbɨkɨr ensa ohɨra ñɨmar. Yakŋ Ohɨrav osa anchɨ hanaveaŋg ŋɨmbɨz mbɨkɨr kwɨŋ ñɨndɨramŋgi han, Josepɨvez kehan waŋɨn are ŋkɨrañanj. Mach, nanempand raz Yakŋ Ohɨrand Yuŋk Wɨr Ñɨñɨnd hamb ikwɨm ivɨz, handɨv osa anchɨ hanɨhan han omanenta sɨmŋgɨmar. Az handɨv Josepɨv Jisasɨnd ikwɨra han ŋe nsɨham mɨn ŋgamɨŋɨn are Pailatɨnd pɨŋ kɨrɨmam omar. Mbɨ mezandɨkŋɨm. Kɨrɨmam we Pailatɨh amare kamar. Nzɨ eran Jisasɨnd ikwɨra han ŋe hɨrohe nsɨham mɨnɨŋ ŋgamɨŋ amar. ");
INSERT INTO anh_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Avɨz Pailatɨv njɨhamam ñi kamar. Jisasɨv ndɨh mi oh a amar. Ave mbɨ wɨram anɨŋnsar aŋkwɨnd han oreŋgɨz aiz amarɨmar. Jisasɨv ndɨh mi oh o nend amar. ");
INSERT INTO anh_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Amarɨz ndɨh mi az Pailatɨv Josepɨh kamar. We Jisasɨnd ikwɨra han ŋe hɨrohe nsɨham mɨnɨŋ ŋgamb amar. ");
INSERT INTO anh_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Mach avɨz, mbɨ we imɨn okam osapɨr han uŋkɨ eŋgwe hɨrohe Jisasɨnd ikwɨra han ŋe hɨrɨŋkai imɨn okam haŋ vɨhamar. Vɨhe hɨrohe nsɨham mɨn awamŋgɨmar handɨh ŋgamŋgɨmar. Ŋgame nsɨham ohɨra ondɨhondɨh han enarɨz ai mɨn han inchakarɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria aiampɨra Makdaland Maria Josepɨnd mɨŋɨr, mbɨ hanave wehɨrehɨr ñi sam Jisas ŋgamŋgɨmar han wamŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Mach ave, Yakŋ Ohɨrand Yuŋk Wɨr Ñɨñɨnd hamb mach raz Maria aiampɨra Makdaland, Maria Jemsɨnd mɨŋɨr, mach Salome hanave we Jisasɨnd ikwɨra iramaŋɨn are aiwɨr yamb uñakŋnsɨnd han uŋkɨ eŋgwamŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Mach, mbɨ yuŋk anɨŋnsar haŋ mband zuhun ŋaiahe nsɨham mɨn Jisas ŋgamŋgɨmar handɨh omŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ave mbɨ mbon mbon kamŋgɨmar. Uñɨmb arɨŋ hɨrawi nsɨham ohɨra han mɨn inchakarɨmŋgɨr kehan enaravɨz ondari arɨmŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kah nde we sɨhowe wamŋgɨz nsɨham ohɨra hamb mɨn ampaŋ ñɨmar. Nsɨham mbanan ohɨra kɨvah. ");
INSERT INTO anh_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Mach, mbɨ nsɨham mɨn haŋ ahevohe wamŋgɨz wɨram norŋɨr yupɨr hɨrahɨr osapɨr okamɨnsɨnd hamb oman mɨŋɨnd handɨh ŋkañɨmar. Az anchɨ kɨra mbanamb wɨram mban we ntamŋgɨmar. ");
INSERT INTO anh_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Avɨz ndɨŋɨh kamar. Amɨ ntamŋgɨmɨn amar. Amɨ Jisas aiampɨra Nasaretɨnd han ai oŋkɨrandɨŋ orɨkavɨzumŋgɨr han kɨrahɨr aimŋgɨn amar. Mbɨ mban mɨñɨm amar. Ndɨn Yakŋ Ohɨrav ndɨh ŋambiahandahi amar. Amɨ sam mbɨkɨr ndɨn ŋgamŋgɨr mban wavar amar. ");
INSERT INTO anh_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Amɨ we sezɨr mbɨkɨr mach Pitahez kavar amar. Jisasɨv mboz injore isupɨr Galilindɨŋ ndɨh ombɨri arar kavar amar. Amɨ ndɨn handɨh wandɨramŋgɨn arar kavar amar. Mbɨ ya han andɨŋ eŋambɨr ndɨh kar arar kavar amar. ");
INSERT INTO anh_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Az mach, anchɨ kɨra mbanamb wamŋgɨz wer ndɨŋ zɨŋ pɨrorɨŋgaz nte mach, mbɨ nsɨham mɨnɨŋ ahevetai kɨrorɨmŋgɨmar. Mach, mbɨ ezandɨkŋahambi, ya mban hɨrohe wɨram emŋgemŋga mɨsɨkamŋgɨm. ");
INSERT INTO anh_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Mach ave, Jisasɨv yuŋk anɨŋnsar haŋ mband zuhun ŋaiahe we ahevakarɨz Maria aiampɨra Makdaland hamb mboz ndɨn wamar. Eŋambɨr han Mariav itɨ kɨvah ahinsɨnsɨnd ñanj han, Jisasɨv itɨ kɨvah akŋ kehan kiaŋgworaŋgwɨmar. ");
INSERT INTO anh_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mach, osa anchɨ Jisasmen ndahɨrɨmŋganj han akŋɨn ahaz ŋgwañ ekamŋgɨzand Mariav we ndɨŋ kamar. ");
INSERT INTO anh_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Jisasɨv ndɨh ŋaiahandahi amar. Nzɨ ndɨn wandɨwin amar. Avɨz mbɨ mbɨkɨr ya han njɨhame, njɨhi aŋkarɨpɨr mɨnjɨhamŋgɨm. ");
INSERT INTO anh_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mapɨŋ haŋ, Jisasɨnd sezɨr undɨmaj hamb aiampɨra ohɨra han erere omŋgɨzand, Jisasɨnd emansɨŋ emŋgon ahevakarɨz, mbɨ ndɨŋ pɨŋ ahevakarɨmar. ");
INSERT INTO anh_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Avɨz, undɨmaj hamb ai mbɨkɨr sezɨr emŋgemŋga han sɨkamŋgɨmar. Kɨrɨm mbɨndɨŋ ya hanez njɨhame njɨhi aŋkarɨpɨr mɨnjɨhamŋgɨm. ");
INSERT INTO anh_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Mapɨŋ han, mbɨkɨr sezɨr oman ŋkiŋkiŋg pamuh hamb ŋgarɨwi unsa nan ñɨmŋgɨzand Jisasɨv ndɨŋ pɨŋ ahevakarɨmar. Ave Jisasɨv ndɨŋ aŋkwɨ si kamar. Amɨ wɨram kɨra entachand, handɨv njɨhi aŋkarɨpɨr njɨhamɨmah ramŋgɨn amar. Osa anchɨ emŋgemŋga hamb yan wamŋgɨr hamb andɨŋ kamŋgɨr amar. Yakŋ Ohɨrav Jisasɨh ndɨh ŋambiahandahi arar kamŋgɨr amar. Kɨrɨm amɨ mbɨndɨŋ ya han njɨhi aŋkarɨpɨr mɨnjɨhamŋgɨm amar. ");
INSERT INTO anh_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Mach ave, Jisasɨv ndɨŋ kamar. Amɨ Yakŋ Ohɨrand ya imbɨr han hɨrohe isupɨr emŋgemŋga haŋ we osa anchɨ mɨŋamun eŋgwavar amar. ");
INSERT INTO anh_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Uñɨmb ya imbɨr mban njɨhame njɨhi aŋkarɨpɨr ŋe yambɨŋ kŋirɨŋgwi ŋaiahandari han Yakŋ Ohɨrav ndɨn ekwaŋg ŋandari amar. Kɨrɨm uñɨmb ya imbɨr mban njɨhame njɨhi aŋkarɨpɨr njɨhamɨmah randari hamb, mbɨ nend amar. Yakŋ Ohɨrav ndɨn ntɨŋ kɨvah eŋgwandari amar. ");
INSERT INTO anh_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Osa anchɨ hamb mbɨ ya imbɨr mban njɨhame njɨhi aŋkarɨpɨr ŋandɨramŋgi hamb mbɨ ntɨŋ aŋkarɨpɨr han ŋandɨramŋgi amar. Han wɨram akŋ anchɨ akŋ han mbɨramɨz Yakŋ Ohɨrav ndɨŋndɨv ñi hɨrawɨj amar. Mbɨ ihɨnd ensaŋ itɨ kɨvah akŋ han kiaŋgworaŋgwɨndɨramŋgi amar. Mbɨ ya han yimbɨm ichaŋ kandɨramŋgi amar. ");
INSERT INTO anh_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Mbɨ akwɨ han omanɨŋ ŋandɨramŋgi amar. Mbɨ hanɨhan kɨvah wɨramb ne mamŋgɨj han mbɨ ne mɨmandɨramŋgɨm amar. Mach mahororɨnsɨnd han mbɨndɨŋ omanaka insɨŋ ŋgamŋgɨz wer mbɨ imbɨr randɨramŋgi amar. ");
INSERT INTO anh_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Mach ave, Anɨŋnsar Ohɨra Jisasɨv ndɨŋ ya mban kaz, Yakŋ Ohɨrav ndɨn kɨrɨm ŋe mbɨkɨr Aiampɨra Ohɨra Ñaŋ handɨh hɨrawaromar. Hɨrawaroz Yakŋ Ohɨrand oman mɨŋɨnd ampaŋ ŋkañɨmar. ");
INSERT INTO anh_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Mach, sezɨrɨv aiampɨra akŋ aiampɨra han kɨrɨm hɨro hɨrai ya eŋgwamŋgɨmar. Hɨro hɨrai ya eŋgwamŋgɨzand Anɨŋnsar Ohɨrav ndɨŋ hɨrawɨmar. Mbɨ ndɨŋ hɨrawɨz ntɨŋ aŋkarɨpɨr ŋamŋgɨmar. Mach, osa anchɨ emŋgemŋga hamb ntɨŋ aŋkarɨpɨr ŋamŋgɨmar han we kamŋgɨmar. Mbɨndɨŋ ntɨŋ aŋkarɨpɨr arɨŋ mbɨramɨz Yakŋ Ohɨrav ndɨŋmen ñɨz mbɨndɨŋ ya hamb mɨŋun ñi arɨmŋgɨmar.");
ALTER TABLE anh_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
