﻿USE sofia;
DROP TABLE IF EXISTS sofia.amx_vpl;
CREATE TABLE amx_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES amx_vpl WRITE;
INSERT INTO amx_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Pwek nhenh Mark-henh angketj mwerr Jesu Christ-akert anem, Altjerr-henh Ler-akert. ");
INSERT INTO amx_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Altjerr-henh angketj angenh-angenh Isaiah rangemeh Altjerr-henh angketj pip-warn ngkwey arrernekarl, “Thang urrpey nyent lanthetjenh ngkwengeng arrwekel-arrwekel tjerrtj map-warn, rang tjey ngkweng arratj-iletjenh. ");
INSERT INTO amx_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Angketj thang awek, rrkwalel ntangkelhemel arlkerleh, ‘Arrantherr Ngkarteh tjey arratj-iletjeh!’ ” Angketj lakenh angketj angenh-angenh Isaiah-el pip-warn ngkwey arrernekarl. ");
INSERT INTO amx_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","6","Angketj nhenh arratj-irremel arlpaw-irrek. John Kwatjeh Irrpelh-ilenh-ilenh rang rrkwal-warn alhek. Rang mantarr kamwerl yenp-penh mpwarek-arleh irrpetjart, rang belt yenp-penhel ayernelhetjart. Rang inteltj ngkwarl rltwamp thwen war arlkwetjart. Itja mern ker arrpenh-arlk apek. Tjerrtj Judea ntjaper-areny map, tjerrtj town Jerusalem-areny map kwer-warn alhek. John-el inenh ilek, “Arrantherr anetjeng Altjerr-warn twep-irrerrang! Kwereng arrantherrenh thang kwatj-warn irrpelh-ilemel baptise-em-iletjenheng, Altjerrel anetj arrehantherr-henh wetjenheng.” Angketj nhenh awemel inang kangkwerrek. Inang anetj inehenh ilelhek, kwer-penh John rang inenh Jordan ulpayel kwatj-warn irrpelh-ilemel baptise-em-ilek. ");
INSERT INTO amx_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","John-elemeh tjerrtj map ilek, “Artwang arrpenh tjengeng ingkern petjem. Rang tjengeng twer anthwerr anem. Yeng anetj-anetj war anem, rang arratj anthwerr. ");
INSERT INTO amx_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Thang arrantherrenh kwatj-warn irrpelh-ilemel baptise-em-ilem. Rang arrantherrenh Kwerrern Alngaltarel-ayeng irrpelh-ilemel baptise-em-iletjenh.” ");
INSERT INTO amx_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Arltang arrpenhel Jesu Nazareth town-eng John-warn alhek. Nazareth rartek mer Galilee-el anek. John-el Jesu renh Jordan ulpayel kwatj-warn irrpelh-ilemel baptise-em-ilek. ");
INSERT INTO amx_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesu kwatjeng arratemel arek alker altjwer-irremeng. Rang arek Kwerrern Alngaltar kwerel-ayeng arrernelhetj-alhemeng, thep ntwerrert-arteh. ");
INSERT INTO amx_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kwer-penh rang Altjerr renh awek, alkereng angkemeng, “Ntwang Ler tjengenh anem. Yeng ngkweng nyerrkem. Yeng ngkweng-penh arrken anthwerr awelhem!” ");
INSERT INTO amx_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kwer-penh Kwerrern Alngaltarel Jesu renh rrkwal-warn lanthek. ");
INSERT INTO amx_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jesu rang arltang 40-eh-atwetj kweny 40-eh-atwetj rrkwalel anek. Arrentjelemeh renh arrkernek. Jesu ker nwanth-areny mapel-arleng mpwepel anek. Angel alker-areny mapel renh arntarnt-arek. ");
INSERT INTO amx_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","King Herod-elemeh John antwerrkekarleng-rlwer, Jesu mer Galilee-warn alhek. Rang tjerrtj map Altjerr-henh angketj mwerr ilek. ");
INSERT INTO amx_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Rang inenh lakenh ilek, “Kel arltang rang anememeh! Arltang nhenh Altjerrel arrwekel kwet ngkernekarl, Altjerr tjerrtj mapeh mernelhetjeh, rang Ngkart angerr ineh anemeng. Kel Altjerr-warn twep-irrerrerrang! Angketj mwerr renh naketjeh!” ");
INSERT INTO amx_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesu Galilee kwatj alay iterel nthwerl-apek. Rang Simon tjey kwerenh Andrew renh-atherrenh arek, ratherr net kwatj-warn wemeng, irrpenng antwerrketjeh. Ratherr irrpenng antwerrkenh-rrkenh anek. ");
INSERT INTO amx_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesu-el renh-atherrenh ngwek, “Tjengel-arleng petj-alherray, thang mpwelenh kaltj-anthetjeh, tjerrtj map mpwel twepelh-iletjeh Altjerr-warn.” ");
INSERT INTO amx_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Akenheng ratherr kel net kwer-atherrenh mentj imperl-alherrek. Jesu-el-arleng ratherr anharrel-ayeng alherrek. ");
INSERT INTO amx_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jesu Simon Andrew inang kwek war ntwarr alhek. Inang akenheng-atherr James John thwen arek, Zebedee-kenh ler atherr. Ratherr boat-el anetjam, net kwer-atherrenh alterrelhekarl ratherr tantherl-anerretjam. ");
INSERT INTO amx_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Jesu-el renh-atherrenh ilek, “Tjengel-arleng petj-alherrang.” Ratherr kel angey kwer-atherrenh-henh rrkwapenh-apenh map imperl-alherrek boat-arleh. Ratherr kel Jesu-el-arleng anharrel alherrek. ");
INSERT INTO amx_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Inang Capernaum town-warn alhek. Kwereng Saturday arlta angerrel Jesu rang church-warn irrpek. Rang tjerrtj map kaltj-anthek. ");
INSERT INTO amx_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Inang angketj kwerenheh anwerlkemel awek. Inang angkerrek, “Rartek angketj twerel kaltj-anthem, itja kaltj-anthenh-anthenh nheng mapel-arteh. Inartek kern war kaltj-anthem, angketj apekapel twer-kwenyel!” ");
INSERT INTO amx_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Jesu-el inenh kaltj-anthetjam, artwang kwerrern anetj-akert church-warn kwen irrpentj-alhek. Artwang rang arnterr arlkemel ilek, ");
INSERT INTO amx_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jesu, Nazareth-arenyay! Ngwenheh ntwang petjek? Nwernenh ywerrelh-iletjeh key? Yeng ngkweng kaltj! Ntwang Altjerr-henh urrpey mwerr anthwerr rang anem!” ");
INSERT INTO amx_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesu-el kwerrern anetj renh arrantjakemel ilek, “Intert-irray! Artwang kwereng arratay!” ");
INSERT INTO amx_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Kwerrern anetj rang artwang renh arrewetjeh mpwarek. Kwerrern anetj rang arlkerl-alhemel, artwang kwereng arraterl-alhekemeh. ");
INSERT INTO amx_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Tjerrtj inang nhenh aremel anwerlkek. Inang pawenherrek, “Wenham lakenhan? Rartek nwernenh angketj lyetant twer anthwerrel kaltj-anthek! Rang kwerrern anetj map twernemeng, inang kel kwer kangkwerrem!” ");
INSERT INTO amx_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Yey Jesu-akert kel Galilee ntjaper-warn antek-irrenhek. ");
INSERT INTO amx_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Kel Jesu rang church-eng arratemel alhek akenheng-atherr James John atherr-akert alhek Simon Andrew atherr-henh mer-warn. ");
INSERT INTO amx_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon-henh rtwaltj rang irlkert anthwerr intek. Inang Jesu renh ateng-ilek. ");
INSERT INTO amx_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesu-antem marl kwer-warn alhek. Rang iltjang antwerrkemel renh kemelh-ilemel ngkernek. Marl kwereng irlkert rang ywerrek, rang mwerr-irrek. Kwer-penh rang mern ineh tjang-itek. ");
INSERT INTO amx_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","33","Kel ngway-ngway irrek. Tjerrtj mer-areny ingkerrek Simon-atherr-henh merel arraw-irrek. Inang tjerrtj irlkert map tjerrtj arrentj-akert map Jesu-warn angetjewarrekarl. ");
INSERT INTO amx_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesu-el tjerrtj irlkert-akert map inenh mwerr-ilek. Rang arrentj map alharlkwek. Arrentj inang Jesu-eh kaltj anek. Jesu-el arrentj inenh arnpakek, inang itja kwer-penh angketjeh. ");
INSERT INTO amx_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kweny-rtweh Jesu kemerrek. Rang mereng arratemel alhek, nyent-areny anetjeh. Rang Angey-warn angketjam. ");
INSERT INTO amx_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon tjerrtj arrpenh maparl kwer palenthwek. ");
INSERT INTO amx_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Renh inang aremel ilek, “Tjerrtj ingkerrekel-artek ngkweng pawenhemel palenthwem!” ");
INSERT INTO amx_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesu-el inenh ilek, “Mpa, nwern mer arrpenh map-warn alhetjeh. Tjeng anem, tjerrtj inenh angketj mwerr Altjerr-henh renh kaltj-antherl-apetjeh. Yeng petjek, Altjerr-kenh angketj tjerrtj ingkerrekeh kaltj-anthetjeh.” ");
INSERT INTO amx_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Jesu mer map-warn alhek mer Galilee ntjaper-warn. Church nyentam-nyentel rang tjerrtj map angketj mwerr renh kaltj-anthek. Rang arrentj map alharlkwek tjerrtjeng. ");
INSERT INTO amx_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Artwang nyent leprosy-akert tjwen apapeth-akert rang Jesu-warn petjek, kwereng ularr amperel-arleng arrernelhek. Rang Jesu renh twerel pawenhek, “Yeng leprosy tjwen-akert anem. Yeng kaltj, ntwang tjerrtj mwerr-ilem. Ntwang ahentj apek anemeng, ntwang yengenh mwerr-iletjeh. Itjeng apek, itja kwetarl.” ");
INSERT INTO amx_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesu kwer lharrp-irrek. Rang iltjel arnpemel renh ilek, “Yeng ahentj-irrem, ngwenh mwerr-iletjeh! Ntwang kel mwerram!” ");
INSERT INTO amx_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Artwang kwer tjwen ywerrek. Artwang rang kel mwerr-irrek. ");
INSERT INTO amx_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesu-el artwang renh lanthemel ilek, ");
INSERT INTO amx_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ntwang itja tjerrtj arrpenheh nhenh-penh iletjeh. Kel ngkart priest-eh mernelhemel ilelhang. Ntwang Altjerr tjenkerr anthang, Moses-el ngkwey anthwerr tjerrtj map twernekarl-arteh. Ntwang lakenh mpwaretjeh, tjerrtj ingkerrek kaltj anetjeh, ntwang kel mwerram.” ");
INSERT INTO amx_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Jesu imperl-alhemel artwang rang kel tjerrtj ingkerrek Jesu-penh ilek, nheng Jesu-el renh mwerr-ilekarl. Lakenheng Jesu ywarn anngetherr alhek town arrpenh map-warn. Rang kethelemeh anek. Tjerrtj inang ingkerrek kwer-warn petjek. ");
INSERT INTO amx_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Arltang rrpwetj-penh Jesu Capernaum town-warn mer kwerenh-warn angkep alpek. Tjerrtj mapel awek, rang merelemeh anemeng. ");
INSERT INTO amx_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Tjerrtj arwenth warl-warn kwen irrpek, Jesu-henh angketj awetjeh. Tjerrtj arrpenh map arrewel irnek. Map arrpenh kethel irnek, mapel arrngert-ilewarrekarleng wart. Jesu-elemeh map anthwerr inenh kaltj-anthetjam. ");
INSERT INTO amx_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Kel artwang 4 inang artwang arlamarr nyent renh angetjewarrek Jesu-warn. Artwang rang antjamel intek kwet. ");
INSERT INTO amx_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Inang ywarn Jesu-warn itwek-irrek, tjerrtj mapel tjey arltwekarleng wart. Inang warl kern-warn antjek, warl kerneng altjwer-ilekemeh. Kwereng inang artwang arlamarr renh anarnpelh-ilek, rang antjam kwerenhel intemeng kwet. ");
INSERT INTO amx_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesu-el nakentj inehenh arek, inarl renh nakerleh. Rang artwang arlamarr renh ilek, “Peltj tjengenhay! Thang anetj ngkwengenh wek.” ");
INSERT INTO amx_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Moses-henh angketj kaltj-anthenh-anthenh rrpwetj inehel-arleng anek. Inang angketj nhenh awemel iterrek, ");
INSERT INTO amx_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Wenhengarl rang lakenh angkem? Rartek Altjerr arrampewem! Altjerrelant kwenh anetj tjerrtjeng wem!” ");
INSERT INTO amx_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Jesu-el iterrentj inehenh aremel alhengk-arek. Rang inenh pawenhek, “Wenhengarl arrantherr iterrem? Tjengam arrantherr pwer anem? ");
INSERT INTO amx_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nthakenham mwerran anem? Artwang arlamarr nhenh renh iletjeh apek: ‘Thang ilem, thang anetj ngkwengenh wek.’? Renh iletjeh apek, ‘Kemerrang! Antjam ngkwengenh inemel kemerremel alpang!’ Tjeng ilay! ");
INSERT INTO amx_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Tjerrtj-henh Ler kwer kwenh anem, anetj wem ahelh nhenhel. Thang arrantherrenh nhenh lyet mernetjenh.” Jesu-el artwang arlamarr renh ilek, ");
INSERT INTO amx_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Kemerrang! Antjam ngkwengenh inemel kel alpang!” ");
INSERT INTO amx_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Artwang arlamarr rang kemerrek, antjam kwerenh inemel arratenhek, tjerrtj ingkerrekel renh anngetherr rtwarek. Tjerrtj inang ywarn iterremel anwerlkek. Inang Altjerr nakek. Lakenh inang angkek, “Nwern itja lakenh-arteh arrwekel arek apek! Lyetantarl arek!” ");
INSERT INTO amx_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jesu weth Galilee kwatj alay iter-warn alpek. Tjerrtj map kwer-warn arraw-irrentj-alpek. Rang inenh kaltj-anthek. ");
INSERT INTO amx_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Kwereng kwatj iterel alhep-alhemel Jesu-el artwang Levi renh arek, lywang kwerenh kethel anerl-anemeng. Levi rartek Alphaeus-kenh ler anek. Rang tax maney kwetjetjart tjerrtj mapeng. Jesu-el renh aremel ngwek, “Tjengel-ayel petjay!” Kel Levi kemerremel kwerel-ayeng antelherl-alhek. ");
INSERT INTO amx_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kwer-penh Jesu rang kwertengerl kwerenh map-akert Levi-kenh warl-warn inang arraw-irrek, mern arlkwetjeh. Tjerrtj tax maney kwetjenh-tjenh map, tjerrtj anetj arrpenh map inarl Jesu-el-ayeng ingkerneng alhetjam, inang inehel-ayeng mern arlkwetjam. ");
INSERT INTO amx_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Moses-henh mpwareng-areng kaltj-anthenh-anthenh rrpwetj inarl Pharisee anemeng, inang kethel anek. Inang Jesu renh aremel tjerrtj anetj mapel-ayeng, inang mwekenh-irrek Jesu-ek, rarl mpwareng-areng inehenheh itja arratj kangkwerrek. Inang Jesu-henh kwertengerl map pawenhek, “Wenhengarl Jesu rang tjerrtj tax maney kwetjenh-tjenh mapel-ayeng tjerrtj anetj mapel-ayeng arlkwem? Rang anetj mpwarem lakenh!” ");
INSERT INTO amx_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesu-el inenh awek, inang lakenh angkemeng. Rang inenh ilek, “Tjerrtj mwerr-artek itja ngangkareh palenthwem. Tjerrtj irlkert war. Lakenh-arteh yeng petjek, tjerrtj anetj map Altjerr-warn twepelh-iletjeh. Itja tjerrtj mwerr mapeh.” ");
INSERT INTO amx_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Arrpenh-ingar John Kwatjeh Irrpelh-ilenh-ilenh-henh kwertengerl map, artwang Pharisee map thwen inang mern-kweny anetjam arltang rrpwetj-ingar, Altjerrant nakemel. Inang lakenh mpwaretjart. Tjerrtj rrpwetj arrpenh Jesu-warn petjek, renh pawenhek, “Lyet John-henh kwertengerl map, artwang Pharisee map thwen inang mern-kweny anem, Altjerrant nakemel. Nthakenharl kwertengerl ngkwengenh mapel mernarl arlkwem?” ");
INSERT INTO amx_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesu-el inenh ilek, “Thang angketj nhenh ilem. Artwel anew inemeng, kwer-penh rang tjenkerr mpwarem. Kwereng rang peltj kwerenh map ngwem, mern arlkwetjeh. Peltj inang ywarn merneng alharlkwelhem. Inang kwerel-ayeng nyerrkemel mern arlkwem. ");
INSERT INTO amx_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Kelant arltang arrpenhel tjerrtj arrpenh mapel artwang renh antwerrkemel angetjenh. Artwang kwer peltj map arltang arrpenhel mern-kweny anetjenh, Altjerrant nakemel.” ");
INSERT INTO amx_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Jesu-el tjerrtj map weth kaltj-anthek, “Thang angketj kwertengerl map atherr-akert ilem. Tjerrtj-henh rnwanentj ngkweyeny alterrelhem apek, tjerrtj rang itja rnwanentj lyeteny kwek akemel, rnwanentj kwer-warn ampek-arrernemel tanthem. Mantarr lyeteny alterrelhehetj. Mantarr ngkweyeny weth alterrelhemel tjep-akelhehetj. Tjerrtjel-artek mantarr ngkweyeny arrpenh akemel, mantarr ngkweyeny tanthemel. Mantarr mwerremeh rang anem.” ");
INSERT INTO amx_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Jesu-el weth kaltj-anthek, “Tjerrtjel itja wine lyeteny yenp ngkweyeny-warn thelem. Yenp alterrelhehetj, wine lyeteny yenp ngkweyenyeng thelelhehetj, nwern wine parlp-ilem. Lakenh kwenh tjerrtjel wine lyeteny yenp lyetenyehant thelem, mwerrarl antwerrkem.” ");
INSERT INTO amx_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Saturday arltel Jesu rang kwertengerl kwerenh map-akert mern wheat rlkwerr-angkwerr anper-alhek. Mern wheat inang ampeng anek. Kwertengerl mapel mern wheat inenh akerl-apetjam. ");
INSERT INTO amx_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nhenh aremel, artwang Pharisee rrpwetjel Jesu renh pawenhek, “Wenhengarl kwertengerl ngkwengenh mapel mern wheat kem? Saturday arltang tjeperrarl anem! Mpwareng-areng nwernek intem, arltang nhenhel nwern itja rrkwapem. Nhenh itja arratj anem!” ");
INSERT INTO amx_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesu-el inenh ilek, “Arrantherram King David-eh kaltj? Ngkwey David rang atwenh-atwenh kwerenh map-akert angayel anek, arrpenh mapel inenh alwernetjameng. ");
INSERT INTO amx_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","David-emeh Altjerr-henh warl amek-amek-warn irrpek. Warl kwerel mern tjenkerr intek, mern inenh tjenkerr Altjerreh anthekarl. Mern priest-elant arlkwetjart. David-el mern nhenh inemel kwenpel arlkwek angayelel wart. Rang artwang kwerel-ayel anemarl map anthek, inang arlkwetjeh, angayelel wart. Lakenh David rang itja Altjerr-henh mpwareng-arengeh kangkwerrek. Nheng lakenh irrek, Abiathar priest twernk angerr anekarl-rlwer Israel-areny mapeh.” ");
INSERT INTO amx_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesu-el inenh ilek, “Wenheng Altjerrel Saturday arltang renh ngkernek? Pharisee mapel ilem, ‘Arltang angerr Saturday-athek anem, tjerrtj map mpwareng-areng nwern-henheh kangkwerretjeh.’ Itja, mpwareng-areng nhenh inangkal ahelh-areny map-henh war! Altjerrel-artek Saturday arltang renh ngkernek, tjerrtj rang rrkwapentj-penh ltjwerretjeh, tjep-tjep-irretjeh. ");
INSERT INTO amx_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Tjerrtj-henh Ler rang anem Saturday arltek-artwey, Ngkart angerr.” ");
INSERT INTO amx_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Kwereng Jesu rang church-warn kwen irrpek. Artwang iltjang anetj-irrekarl rang church kwenel anek. ");
INSERT INTO amx_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tjerrtj Pharisee map lakenh iterrek, “Mpwareng-areng nwern-henhel kwenh arnpakem, tjerrtjel itja tjerrtj irlkert mwerr-iletjeh arltang angerrel Saturday-el. Jesu-el artwang nhenh-henh iltjang mwerr-iletjenh apek, nwern renh kel iltetjenh, rang mpwareng-areng nwern-kenh rltwakemarleng.” ");
INSERT INTO amx_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesu-el artwang iltjang anetj-irrekarl renh ngwek, “Petjang nhenh-warn arrwekel-warn.” ");
INSERT INTO amx_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kwereng rang inenh pawenhek, “Nthakenh angketj Moses-henh mpwareng-arengel-ayeng intem? Saturday arltel tjerrtj renh mwerr-iletjeh apek? Anetj-iletjeh apek? Nthakenh apek arrantherr iterl-arem? Nthenham mwerran?” Inang angketj-kweny anek. ");
INSERT INTO amx_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jesu-el inenh tjwer-arek, rang ineh ahang-irrek. Kwer-penh rang ltarrp-irrek, inang irlpareth-kweny wart anemeng. Rang artwang renh ilek, “Iltjang mernelhang.” Artwang rang iltjang mernek. Iltjangemeh kel mwerr-irrek. ");
INSERT INTO amx_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kwer-penh artwang Pharisee inang church kwereng arratemel alhek keth-warn. Inang alpek, King Herod-kenh rrkwapenh-apenh mapel-ayeng angkerrek, Jesu renh irrernng atwetjeh. ");
INSERT INTO amx_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Kwereng Jesu rang kwertengerl kwerenh map-akert Galilee kwatj alay iter-warn alhek. Tjerrtj mer Galilee ntjaper-areny mer Judea ntjaper-areny town Jerusalem-areny inang arraw-irretj-alpek kwer-warn. Tjerrtj arrpenh map petjek, mer Idumea-areny mer Jordan ulpayeng ingerr-areny, town Tyre-areny map town Sidon-areny map. Mer arreny nhenh mapeng ingkerrekel angketj Jesu-penh awek, lakenheng inang petjek Jesu kwer-warn, irlkert map-arlk inang angetjek, Jesu-el inenh mwerr-iletjenheng. Inang arraw-irretj-alpek kwatj alay Galilee iter-warn. ");
INSERT INTO amx_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Jesu-elemeh tjerrtj map anthwerr mwerr-ilek arltang kwerel. Tjerrtj irlkert arrpenh map kwer-warn itwek-irrek, renh inang arnpetjeh, inang parrp mwerr-irretjenheng. Tjerrtj mapel renh pewerl-apek. Tjerrtj aningkeng wart, lakenheng Jesu-el kwertengerl map twernek, inang boat kwek kwer angetjetjeh. Kwereng rang boat kwer antjek, tjerrtj arwenthel renh arltwekarleng. ");
INSERT INTO amx_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Tjerrtj kwerrern anetj-akert mapel inang Jesu renh aremarleng, inang kwereng ularr anyetjart. Kwerrern anetj inang arlkemel iletjam, “Ntwang kwenh Altjerr-henh Ler anem!” ");
INSERT INTO amx_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jesu-elemeh kwerrern anetj inenh arrantjakemel iletjart, “Arrantherr tjerrtj map itja tjeng-penh iletjeh.” ");
INSERT INTO amx_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Kel Jesu rang irntang-warn antjek. Rang artwang mapeh ntangkelhek. Ineh rang ahentj-irrekarl, inang kwer-warn petjek. ");
INSERT INTO amx_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Kwereng rang artwang 12 inenh ngwek. Rang inenh ilek, “Thang arrantherrenh ngwek, kwertengerl tjengenh anetjeh. Arrantherr tjengel-ayeng anetjeh. Thang arrantherrenh lanthetjenh angketj mwerr-akert, arrantherr tjerrtj map kaltj-anthetjeh. ");
INSERT INTO amx_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Thang arrantherrenh twer-ilem, arrantherr arrentj tjerrtj mapeng alharlkwetjeh.” Lakenh Jesu-el inenh ilek. ");
INSERT INTO amx_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Artwang nhenh inang anek. Simon, renh Jesu-el arreny Peter ilek. ");
INSERT INTO amx_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Akenheng-atherr James John thwen, Zebedee-henh ler atherr. Akenheng-atherr Jesu-el arreny arrpenh ilek Boanerges. (Boanerges arreny Anmatjerrel angart-wem kwatj awely-awely iltetj-irremel iltewem. Lakenh-arteh ratherr parrp ahang-irremel ilterl-alhetjart.) ");
INSERT INTO amx_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrew, Philip, Bartholomew, Matthew, Thomas, James Alphaeus-henh ler, Thaddaeus, Simon. Tjerrtjel apek Altjerr itja nakek, Simon nhenh rang ineh ahang-irretjart. ");
INSERT INTO amx_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Arrpenh anek Judas Iscariot. Judas nhenh rang Jesu renh kelant atwenh-atwenhek anthetjenharl. ");
INSERT INTO amx_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jesu rang alpek warl nyent-warn. Tjerrtj arwenth weth kwer-warn arraw-irretj-alpek. Jesu rang kwertengerl kwerenh map-akertel mern ywarn arlkwek, tjerrtj arwenthel inenh apekap-ilekarleng. ");
INSERT INTO amx_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jesu-henh peltj mapel nhenh-penh awek, inang petjek, renh anginetjeh. Inang iterl-arek, Jesu rang kwel ahert-irrekarl. ");
INSERT INTO amx_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Moses-henh angketj kaltj-anthenh-anthenh rrpwetjemeh Jerusalem-eng petjek. Inang tjerrtj map rrtjwerremel Jesu-penh lakenh ilek, “Artwang nhenh arrentj angerreh kangkwerrenh-rrenh. Arrentj rang Jesu renh twer-ilek, lakenh Jesu-el arrentj kwek map tjerrtjeng alharlkwem.” ");
INSERT INTO amx_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesu-emeh tjerrtj mapek ntangkelhek. Rang inenh ilek, “Arrentj rang tjerrtjeng arrentj arrpenh ywarn alharlkwem. ");
INSERT INTO amx_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Iterl-aray! Tjerrtj mer nyent-areny map atwerremeng, mer inehenh kel mentj-irretjenh. ");
INSERT INTO amx_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Peltj map inang kweteth atwerremeng, inang kel alperrtj-irrem. ");
INSERT INTO amx_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Arrentj angerrel apek arrentj kwek kwerenh map kwel alharlkwemeng, arrentj kwerenh twer ywerrehetj. Itja lakenh anem. Lakenheng arrentj angerrel arrentj kwek kwerenh map ywarn alharlkwem, inang nyenteng wart. ");
INSERT INTO amx_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Thang arrantherrenh ilem angketj artwang warlek-artwey-akert. Artwang warlek-artwey nhenh rang twer anthwerr anerl-anem warl kwenel, mer arntarnt-aremel. Kel artwang arwengkalth rang apek warl-warn irrpetjeh ahentj-irrem, rnwanentj rwengkel inetjeh. Rang artwang twer renh-amparr antwerrkemel ayernetjeh-amparr. Kwerengant rang rnwanentj rwengkel angetjeh. Itjeng itja kwetarl. Arrantherr angketj nhenh iterl-arem key? Arrentj rang artwang twer-arteh tjerrtj nyent kwen. Yeng kwereng twer-lkwer. Lakenh thang arrentj alharlkwem tjerrtjeng.” ");
INSERT INTO amx_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Thang angketj arrpenh ilem, angketj tjeperr. Tjerrtj nyent ngwenh apek anetj anthwerr mernelhem, Ngkart renh arrampewem apek. Kwer-penh tjerrtj nhenh apek Ngkart kwer-warn twep-irremeng, Ngkartel kel anetj kwerenh wetjenh. ");
INSERT INTO amx_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Nhenh nyent war anem: tjerrtjel Kwerrern Alngaltar itja arrampewetjeh. Rang lakenh arrampewemeng apek, Ngkartel anetj kwerenh itjarl wetjenh. Rang anetj-akert kwet anetjenh, rang Kwerrern Alngaltar renh arrampewekarleng wart.” ");
INSERT INTO amx_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesu-el inenh lakenh ilek, tjerrtj arrpenh mapel rrtjwerremel ilekarleng, rang kwel arrentj-akert anemeng. ");
INSERT INTO amx_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesu-kenh mwek tjeyekw kwerenh map inang petjek, warl kethel karelhek. Inang tjerrtj nyent lanthek, Jesu iletjeh, rang ineh-warn arratetjeh keth-warn. ");
INSERT INTO amx_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Tjerrtj inarl Jesu-el-ayeng anemeng, inang renh ilek, “Mey ngkwengenh tjey ngkwengenh map inang kwenh ngkweng kethel karelhem.” ");
INSERT INTO amx_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesu-el inenh pawenhekarl, “Ngwenham mwek tjengenh? Ngwenham tjeyatj tjengenh map anem?” ");
INSERT INTO amx_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tjerrtj map kwereng arrwekel anemarl map rang ilek, “Arrantherr kwenh mwek tjengenh tjeyatj tjengenh map anem! ");
INSERT INTO amx_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Tjerrtj inarl Altjerreh kangkwerrem, inang anem peltj map tjengenh, tjey tjengenh, angkweratj tjengenh, mwek tjengenh.” ");
INSERT INTO amx_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jesu-el tjerrtj inenh weth kaltj-anthek Galilee kwatj alay iterel. Tjerrtj map inang kwer-warn arraw-irretj-alhek. Lakenheng tjerrtj map anthwerr-hetj rang boat-warn antjemel anek. Boat kwatj iter ntwarr-kweny war anek. Tjerrtj map kwatj iterel irnetjam. ");
INSERT INTO amx_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jesu-el inenh angketj nhenh ilek, ");
INSERT INTO amx_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Awerrerrang! Artwang nyent alhek, mern anngang werl-apetjeh, mern atherrk mangketjenheng. ");
INSERT INTO amx_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Rang mern anngang werl-apemel, anngang arrpenh map tjey-warn wek. Thep map petjek, mern anngang inenh arlkwek. ");
INSERT INTO amx_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mern anngang arrpenh map ahern irntangerrarl wek. Inang parrp lyapek. ");
INSERT INTO amx_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Artekerr ywarn ahern-warn kwen irrpekarleng, aherrk rang arratemeng, aherrkel mern akwerrk inenh antjerrk-ilemel ampek. ");
INSERT INTO amx_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mern anngang arrpenhemeh lyek mpwep-warn wek. Mern mwerr, lyek thwen ratherr pwert lyapek, ratherr mwern-irrentj kwet mangkek. Alyekel mern mwerr renh anetj-ilek, mern ngwerrm-kweny-ilek. Mern inang itja kwet mern ngwerrm-akert-irrek. ");
INSERT INTO amx_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Kel mern anngang arrpenh map ahern mwerr-arleh wek. Mern inang lyapek, ngwerrm-akert-irrek. Mern arrpenh anngang nyent-penh mern ngwerrm 30-arl arratek, mern arrpenh anngang nyent-penh mern ngwerrm 60-arl arratek, mern arrpenh anngang nyent-penh mern ngwerrm 100-arl arratek.” ");
INSERT INTO amx_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Jesu-el inenh ilek, “Arrantherr kwenh irlpang-atherr-akert anem! Arrantherr angketj tjengenh werrerrang!” ");
INSERT INTO amx_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Arltang nyent kwerel rang kel nyent-areny anek. Kwertengerl 12 kwerenh tjerrtj rrpwetj arrpenh map kwer-warn inang petjek, renh angketj nheng-penh pawenhetjeh. ");
INSERT INTO amx_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesu-el inenh ilek, “Yeng ahentj-anem, arrantherr angketj alengk-welhentj tjengenh alhengk-aretjeh. Angketj nheng thang ilek, Altjerr kel petjekarl, tjerrtj mernelhetjeh, rang Ngkart angerr anemeng tjerrtj ingkerrenyek. Tjerrtj arrpenh map inarl itja peltj tjeng anemeng, inenh thang angketj war ilem. ");
INSERT INTO amx_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Thang arrantherrenh ilem Altjerr-henh angketj ngkweyeny nhenh, ‘Inang angketj tjengenh awetjenheng, inang angketj tjengenh itja alhengk-aretjenheng. Inang apek angketj tjengenh arratj kangkwerremel alhengk-aremeng, inang Altjerr-warn twep-irrehetj, Altjerrel anetj inehenh wehetjeng.’ “Angketj lakenh intem Altjerr-henh angketjel-ayeng.” ");
INSERT INTO amx_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesu-el inenh pawenhek, “Arrantherr apek angketj artwang nheng-penh ywarn alhengk-arem, artwang rarl mern anngang werl-apetjam? Nthakenh arrantherr angketj arrpenh map alhengk-aretjenh? ");
INSERT INTO amx_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Artwang rarl mern anngang werl-apem, rarteh tjerrtj nheng map-arteh anem, inarl Altjerr-henh angketj tjerrtj arrpenh mapeh kaltj-anthem. ");
INSERT INTO amx_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mern anngang nheng tjey-arleh wekarl, nhenh kel tjerrtj nheng map-arteh anem, inarl Altjerr-henh angketj awem. Inang angketj awem-arteh, arrentjel angketj renh rakemel angem inehetj. Lakenh-arteh thep mapel mern anngang inenh arlkwem ketheh. ");
INSERT INTO amx_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Mern anngang nheng map ahern irntangerrarl wekarl, nhenh kel tjerrtj nheng map-arteh, inarl angerr kangkem, Altjerr-henh angketj awetjeh. ");
INSERT INTO amx_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Lakenh-arteh tjerrtj nheng anetj mapeh: Altjerr-henh angketj ywarn irrpem iterrentj inehenh-warn. Artekerr inang ahelh-warn ywarn irrpem, lakenh-arteh Altjerr-henh angketj itja irrpem iterrentj inehenh-warn. Inang angketj kwer parrp war angwerrem. Lakenh inang Altjerr renh itja twerel nakem. Inang rwekenth-kenth irrem apek, tjerrtj arrpenhel apek inenh arrampewemeng Altjerr-henh angketjeh war, inang kel Altjerr renh mentj impem. ");
INSERT INTO amx_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","19","Mern anngang inang lyek mpwep-warnarl wekarl, inang tjerrtj nheng map-arteh anem, inarl Altjerr-henh angketjeh kangkwerrem, inang mantarreh arrkeneh maneyeh-arlkant war angerr kwet iterrem, inang perrpert-ilelhem Altjerr-henh angketjeng. Altjerr-henh angketj itja kwet mern-akert-irrem iterrentj inehenhel-ayeng. ");
INSERT INTO amx_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Mern anngang nheng ahern mwerr-warnarl wekarl, nhenh kel tjerrtj nheng map-arteh anem: tjerrtj rarl Altjerr-henh angketj awem, angketj kwer kwet ahentj-irrem. Inang arratj mernelhem tjerrtjeng ularr. Tjerrtj inang mern anngang arrpenh map ahern mwerr-arleh werl-apekarl-arteh. Mern inang lyapek, ngwerrm-akert-irrek. Mern ngwerrm arrpenh anngang nyent-penh 30-arl arratek, mern ngwerrm arrpenh anngang nyent-penh 60-arl arratek, mern ngwerrm arrpenh anngang nyent-penh 100-arl arratek.” ");
INSERT INTO amx_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesu-el inenh ilek, “Tjerrtjel rwang alngenth warl-warn kwen angemeng, rang apek antjam kwerenhel arltwem? Itja kwenh. Tjerrtj rang rwang alngenth renh kerneh arlpar-arrernem, tjerrtjel keth aretjenheng. ");
INSERT INTO amx_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Lyet tjerrtj mapel Altjerr-henh angketj itja alhengk-arem, angketj nheng tharl inenh ilem. Kelant Altjerrel angketj ineh keth-iletjenh. Angketj alengk-welhentj rarl intep-intem, renh Altjerrel keth-iletjenh. ");
INSERT INTO amx_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Arrantherr irlpang atherr-akert anem, arrantherr angketj tjengenh awetjeh.” ");
INSERT INTO amx_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","25","Rang inenh ilek, “Awerrerrang-athew mantjel! Arrantherr itja Altjerr-henh angketj war awerl-anetjeh, arrantherr kaltj-irretjeh. Arrantherr tjerrtj arrpenh mapeh Altjerr-henh angketj kaltj-anthemeng, Altjerrel arrantherrenh weth angerr kaltj-anthetjenh. Tjerrtj rarl Altjerr-henh angketjeh kangkemel awem, Altjerr-henh angketjeh angerr anthwerr kaltj-irretjeh ahentj-anemeng, renh Altjerrel wetham kaltj-anthetjenh. Tjerrtj arrpenh rarl ahentj-kweny-irrem Altjerr-henh angketjeh, rarl Altjerr-henh angketj kwek apek anyenem iterrentj kwerenhel, kwereng Altjerrel angketj angkep inem.” ");
INSERT INTO amx_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesu-el inenh ilek, “Thang angketj kwek war iletjenh, nthakenh Altjerrel tjerrtj nakenh-nakenh kwerenh map-ilem. Artwel mern anngang aherneh werl-apem. ");
INSERT INTO amx_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Anngang inenh wemarl-penh, artwang rang kwenp kwenyel ankwang intem, kwenp aherrkel nthwerl-apem. Mern anngang inang lyapem-amparr, angerr-irremel mangkem. Nthakenham anngang inang mangkem? Artwang rang itja kaltj nhenheh. ");
INSERT INTO amx_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ahern rang mern anngang inenh mangkelh-ilem. Arrwekel mern anngang rang lyapem-amparr. Kwereng anteth-amparr arratem. Kwereng mern ngwerrmemeh arratem. ");
INSERT INTO amx_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kel twern-irremengant mern ngwerrm inang ampeng anemeng, artwang rang petjemel mern inenh knife arnkwertel akemel kwetjem.” ");
INSERT INTO amx_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesu-el inenh ilek, “Nthakenham nwern arrehantherr keth-ilemel iletjenh, arrantherr alhengk-aretjeh, Altjerr rang tjerrtj nakenh-nakenh kwerenh map angerr-ilemeng? Nthakenh nwern arrehantherr angketj arratj ilemer? ");
INSERT INTO amx_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Thang arrantherrenh angketj ilem. Mern tjwerrk anngang ahernek arrernemeng, tjwerrk anngang rang kwek anthwerr. ");
INSERT INTO amx_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Tjwerrk anngang renh arrernemeng, rang kel mangkemel angerretj anthwerr irrem, arnang ngkwern arwenth-akert-irrem. Thep map arraw-irremel antjwang inehenh mpwarem arnang-arleh.” ");
INSERT INTO amx_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jesu-el tjerrtj map Altjerr-henh angketj kaltj-anthek, inenh angketj arrpenhek-arrpenh ilemel. Inarl kwek war kaltj-irrekarl, rarl inenh lakenheh-atwetj kaltj-anthek. ");
INSERT INTO amx_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Rang inenh angketj ilemelant war kaltj-anthek, keth-iletj-kweny. Kwertengerl mapel-ayeng anemarleng, rang inehant angketj ingkerrek keth-ilek. ");
INSERT INTO amx_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Kel angwerr-angwerrel arltang nyent kwerel, Jesu-el kwertengerl inenh ilek, “Mpa! Boat-warn antjerrerrang! Nwern itep arrengakw-warn alhetjeh!” ");
INSERT INTO amx_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Tjerrtj arrpenh map imperl-alhemel, inang boat-el alhek kwatj alay-angkwerr. Tjerrtj arrpenh map boat arrpenh mapel alhek. ");
INSERT INTO amx_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Inang kwenp alherl-apetjam, irlkang petjek, inenh irlkangel atwentjek. Kwatj angerr boat kwer thelelhek. Boat rang kwatj-warn irrpetjeh anek. ");
INSERT INTO amx_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesu rang boat ingkernel ankwang interl-apetjam, rtwenkel-ayeng. Kwertengerl mapelemeh renh kemelh-ilemel pawenhek, “Kaltj-anthenh-anthenhay! Nthakenh ntwang kwenp interl-apem? Nwern-arteh kwatjel ilwetjeh-irrem!” ");
INSERT INTO amx_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesu-el kemerremel irlkang renh inmerr inenh arnpakek, “Kel ywerrang!” Irlkang parrp war ywerrerl-alhek, inmerr kwek-irremel ywerrek. ");
INSERT INTO amx_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jesu-el kwertengerl kwerenh map pawenhek, “Wenhengam arrantherr ater-irrek? Thang kwenh arrantherrenh arntarnt-arem! Arrantherr kwenh yengenh nakemer!” ");
INSERT INTO amx_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Kwertengerl inang angerr anthwerr ater-irrek. Inang pawenherrek, “Artwang ngwenham nhenh rang? Irlkang kwatj inmerr-arlk kwerant kangkwerrem!” ");
INSERT INTO amx_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesu rang kwertengerl kwerenh map-akert boat-el alhek kwatj-angkwerr, kwatj alay altwerleng iter ingerr-warn, mer Gerasa kwer-warn. Kwatj alay arreny kwerenh Galilee. ");
INSERT INTO amx_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesu boat-eng anarnpek-arteh, rang artwang kwerrern anetj-akert renh arek, kwer-warn arnek-irretj-alherleh. Artwang rang awenng mpwepeng petjek. ");
INSERT INTO amx_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Artwang nhenh rartek mer kwerenh tjerrtj irrernng map-henh awenng mpwepel mpwarekarl. Tjerrtj arwenthel ywarn renh ayernetjart chain-el-arlk. ");
INSERT INTO amx_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Tjerrtj mapel apek iltjang ingkang-arlk kwerenh chain-el ayernemeng, rang chain inenh kwenpel ltwaketjart. Tjerrtjel renh ywarn kwet antwerrketjart, rang twer anthwerr anek. ");
INSERT INTO amx_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Kwenyel aherrkel-arlk rang tjerrtj irrernng-henh awenngel nthwerl-apetjart, irntang kernel-arlk rang nthwerl-apetjart. Rang irntel kelhemel arlkerl-apetjart. ");
INSERT INTO amx_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Artwang nhenh rang Jesu renh ntwarreng arek, rang kwer-warn arnekarner arrtjanetj-alhek. Rang kwereng ularr amperel-ayeng altjwernetj-alhek. ");
INSERT INTO amx_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Rang arnterr arlkemel ilelhek, “Jesu-ay! Altjerr angerr-henh Leray! Wenheham ntwang nhenh-warn petjek? Yeng atwetjeh key ntwang petjek? Altjerreng ularr alhelay, ntwang yeng itja rwekenth-kenth-iletjeh!” ");
INSERT INTO amx_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Jesu-el arrwekel-antey kwerrern anetj renh ilek, artwang kwereng arratetjeh. ");
INSERT INTO amx_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jesu-el renh pawenhek, “Wenham arreny ngkwengenh?” Artwang rang kwer ilelhek, “Arreny tjeyenh Aningk, yeng kwerrern anetj aningk-akert anemeng wart.” ");
INSERT INTO amx_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Artwang rang Jesu twer-irremel pawenhek, rang kwerrern anetj inenh mer kwereng itja anpwetjeh. ");
INSERT INTO amx_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Irntang iterel 2,000 pek-pekel atherrk arlkwetjam. ");
INSERT INTO amx_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Kwerrern anetj inang Jesu renh twerel kwet pawenhek, “Nwernenh pek-pek map-warn lanthang!” ");
INSERT INTO amx_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Kel Jesu-el inenh twernek, “Kel pek-pek map-warn irrperrerray!” Kel inang pek-pek ineh-warn irrpek. Pek-pek inang ahert-irremel arrtjanemel kwatj-warn anyerl-alhek, inang ilwek. ");
INSERT INTO amx_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Artwang pek-pek arntarnt-arenh mapel inenh arek, kel inang mer kwek map-warn arrtjanek, angketj ilerl-apetjeh. Mer-areny map petjek aretjeh. ");
INSERT INTO amx_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jesu-warn inang itwek-irremel artwang nheng arek. Rang kwerrern anetj map-akert anekarl, mwerr-antem, iterrentj mwerr-akert, mantarreharl irrpekarl. Tjerrtj inang aremel ater-irrek. Inang iterrek, “Nthakenham artwang nhenh mwerr-irrek?” ");
INSERT INTO amx_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Kwereng tjerrtj inarl arekarl, inang angketj artwang kwer-penh pek-pek map-penh thwen inenh ilek. ");
INSERT INTO amx_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Tjerrtj inang Jesu renh ilek, “Nwern ahentj-irrem, mer nwern-henheng kel ntwang alhetjehant.” ");
INSERT INTO amx_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesu rang ineh kangkwerremel boat-warn antjetjeh irrek. Artwang mwerr-irrekarl rang Jesu renh twer-irremel pawenhek, kwerel-ayeng alhetjeh. ");
INSERT INTO amx_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesu-el artwang renh lthwelth-ilerl-alhek. Rang renh ilek, “Peltj ngkwengenh map-warn alpay! Ineh lakenh ilelhay, ‘Ngkartarl nyerrkentj tjeng mernelhekarleng, rang yeng mwerr-ilek.’ ” ");
INSERT INTO amx_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Artwang rang mer map-warn alhek, Decapolis ntjaper-warn. Rang tjerrtj ingkerrekeh kwewaleny ilelherl-apetjam, Jesu-el renh mwerr-ilekarl. Tjerrtj mapel angketj nhenh-penh awemel, inang ingkerrek anwerlkek. ");
INSERT INTO amx_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jesu kwatj-angkwerr boat-el itep altwerl-warn angkep alpek, kwatj alay Galilee-el. Boat kwereng rang anarnpek-arteh, tjerrtj arwenth kwer-warn arraw-irrek. ");
INSERT INTO amx_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Artwang nyent anek, rang church-areny twernk anek. Arreny kwerenh Jairus. Rang Jesu arek, rang kwer-warn itwek-irrek, amperel-ayel arrernelhek. ");
INSERT INTO amx_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Jairus rang angkek, “Jesu-ay! Kwer marl tjeyenh rartek kel ilwetjeh-irrem. Petjang tjengel-arleng, iltjang ngkwengenh kwer-warn arrernetjeh. Kwer marl rang weth mwerr-irretjenheng.” ");
INSERT INTO amx_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesu rang kel alhek Jairus kwerel-ayel. Tjerrtj arwenth kwer-atherrel-ayeng alhek, inang renh-atherrenh ngkwal ankert-wek. ");
INSERT INTO amx_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Arrweketj nyent inehel-ayeng alhek, 12 years irlkert angerr-akert anek. ");
INSERT INTO amx_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Rang alhetjart ngangkar-warn, inang renh ywarn mwerr-ilek. Rang maney-kweny anetjart, maney kwerenh ingkerrek rang ngangkar-akert mapeh anthetjart, renh mwerr-iletjek. Rang irlkertam-irlkert irretjart. ");
INSERT INTO amx_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Marl rang awek, Jesu-el irlkert aningk mwerr-ilekarl. Rang Jesu-warn itwek-irrek, rartek lakenh iterrek, “Thang apek rnwanentj alkey kwerenh arnpemeng, yeng kel mwerr-irretjenh!” Kel rnwanentj alkey Jesu-henh arnpekemeh rang. ");
INSERT INTO amx_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Rang awelhek, mpwerrk kwerenh mwerram anemeng. ");
INSERT INTO amx_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesu-artek awelhek, twer kwerenh kwek war ywerrek. Rang alngarelhemel irnek, tjerrtj map pawenhek, “Tjerrtj ngwenhelam rnwanentj tjeyenh arnpek?” ");
INSERT INTO amx_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Kwertengerl mapel Jesu renh ilek, “Wenhengarl ntwang nwernenh pawenhem? Tjerrtj map aray, ngkwengeng rtwang irnerreharleng! Inang apek rnwanentj ngkwengenh arnpek.” ");
INSERT INTO amx_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesu rang alngarelhemel tjerrtj kwer kwet palenthwek. ");
INSERT INTO amx_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Marl rang kel kaltj anek, rang mwerr-irrekarl, rang awelhekarleng wart. Rang Jesu kwer-warn petjek, ater-irremel anthwerr. Marl rang amperel-ayeng arrernelhetj-alhemel ilelhek, “Yeng ngkwey irlkert anek. Thang rnwanentj ngkwengenh arnpek, yeng mwerr-irrek.” ");
INSERT INTO amx_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesu-el renh ilek, “Ntwang yengenh nakekarleng, yeng twer angerr anem, lakenheng Altjerr Angeyel ngwenh mwerr-ilek. Ater-irretjal anang! Altjerrel ngwenh karem!” ");
INSERT INTO amx_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesu rang marl kwer-warn angkemarleng, artwang rrpwetj petjek angketj anetj-akert twernk Jairus-kenh mereng. Inang Jairus renh ilek, “Twernkay! Kwer marl ngkwengenh kel ilwek. Kaltj-anthenh-anthenh renh mentjemeh impay, rarrp alhetjeh.” ");
INSERT INTO amx_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesu rang angketj nhenhek itja kangkwerrek. Rang Jairus renh ilek, “Ntwang itja ater-irretjeh. Kel yengenh nakay!” ");
INSERT INTO amx_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Kel Jesu-el tjerrtj arrpenh map arnpakemel ilek, “Arrantherr arrwekel mpwelhewarrang. Thang ngwerl-alhem, Peter, James, tjeyekw kwerenh John, inenhant.” Kel Jesu ineh-akert Jairus-henh warl-warn alhek. ");
INSERT INTO amx_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jairus-henh warl-warn itwek-irremel, Jesu-el arek tjerrtj map arnterr akay arnemeng. ");
INSERT INTO amx_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Rang mer-warn kwen irrpek. Rang inenh pawenhek, “Wenhengam arrantherr akay arnem? Kwer nhenh itjam ilwek. Rang ankwang war intem.” ");
INSERT INTO amx_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Inang kwer atherremel renh arrkentj-ilek. Jesu-el inenh ingkerrek warleng lanthek keth-warn. Kwereng rang angey matj kwertengerl rrpwetj-akert room-warn irrpenhek, kwer marl irrernng intetjam-warn. ");
INSERT INTO amx_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Jesu-el kwer marl irrernng iltjang rrkwemel renh ilek, “Talitha, koum!” Nhenh Anmatjerrel angart-wem, “Marlay, kemerray!” ");
INSERT INTO amx_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Marl awenk rang kel kemerrek, ingkang nthwetjam. Marl awenk nhenh rang 12 years ngkwey war anek. Nhenh aremel tjerrtj inang anwerlkek, ywarn iterremel. ");
INSERT INTO amx_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesu-el inenh arnpakemel ilek, inang itja tjerrtj arrpenh nhenh-penh iletjeh. Rang angey mwek ilek, ratherr marl awenk renh mern arlkwetjeh anthetjeh. ");
INSERT INTO amx_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesu rang mer alenh imperl-alhemel mer kwerenh-warn alpek, Nazareth town-warn. Kwertengerl kwerenh map inang kwerel-ayel alpek. ");
INSERT INTO amx_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Saturday arltang angerrel rang church kwenel tjerrtj map kaltj-anthetjam. Tjerrtj inang renh awerl-anemel anwerlkek. Inang pawenherrek, “Nthenhelam rang angketj nhenh arrwekel awek? Nthakenham rang kaltj anthwerr irrek? Ngwenhel renh twer-ilek, twer anthwerrel mpwaretjeh? Rang tjwenelhem war! ");
INSERT INTO amx_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Rang kwenh tjerrtj war nwern-arteh! Jesu nhenh rang kwenh arnang table mpwarenh-arenh! Nwern-artek kaltj Mary matj kwerenhek mer nhenh-areny! Tjey kwerenh map James, Joseph, Judas, Simon. Arrwemp kwerenh map nwernehel-ayel anekarl.” Lakenh inang kwer ahentj-kweny-irrek. ");
INSERT INTO amx_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jesu-el inenh ilek, “Tjerrtj arrpenh mapelant kwenh angketj angenh-angenh nakem. Renh tjerrtj peltj kwerenh mapel angketj angenh-angenh itjarl nakem. Lyet tjeng lakenh-arteh irrem!” ");
INSERT INTO amx_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Rang mer Nazareth kwerel ywarn twer anthwerrel mpwarek, rang kel tjerrtj rrpwetj war ngangkarel mwerr-ilek, iltjang kapert inehenh-warn arrernemel. ");
INSERT INTO amx_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Jesu rartek anwerlkek, peltj kwerenh mapel renh itja kwet nakemeng. Kwer-penhan Jesu rang mer kwek map-warn alhetjart, rang tjerrtj inenh kaltj-antherl-apetjart. ");
INSERT INTO amx_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jesu-el kwertengerl 12 kwerenh arrawelh-ilek. Rang inenh lanthek, angketj kwerenh-akert atherram-atherr mer map-warn alhetjeh. Jesu-el kwertengerl inenh twer-ilek, kwerrern anetj map tjerrtjeng alharlkwetjeh. ");
INSERT INTO amx_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Rang inenh lakenh ilek, “Arrantherr kel anem-akertant alherrerrang. Arrantherr itja mern angetjeh, yakweth apek maney apek itja angetjeh. ");
INSERT INTO amx_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Kel ingkang-henheh irrpetjeh. Arrantherr itja mantarr angetjeh. ");
INSERT INTO amx_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Arrantherr town-el irretj-alhemeng, tjerrtj merek-artwey inang arrehantherr ahentj-irremeng, kel warl nyent kwerel interl-anerrang. Kwer-penh arrantherr town arrpenh-warn alhetjenheng. ");
INSERT INTO amx_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Arrantherr town-warn irrpenhemeng, tjerrtj inang apek arrehantherr ahentj-kweny anem, inang itja ahentj-anem arrehantherr-henh angketjeh awetjeh, kel town kwereng arratay. Ahelh ulmernt ingkang arrehantherr-henheng lernemel, kel alhay. Lakenh mpwaremel, arrantherr inenh mernem, Altjerr itja kangkentj ineh anem.” Lakenh Jesu-el inenh ilek. ");
INSERT INTO amx_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Kwereng kwertengerl map inang alhek mer map-warn, tjerrtj map ilerl-apek, inang Altjerr-warn twep-irretjeh, mwerr mernelhetjenheng. ");
INSERT INTO amx_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Inang arrentj tjerrtj mapeng alharlkwek. Inang tjerrtj irlkert-akert map anterel pernemel mwerr-ilek. ");
INSERT INTO amx_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kel tjerrtj map ingkerrekel Jesu-penh inang awek. King Herod rang kwer-penh awek. Tjerrtj map arrpenh lakenh Jesu-penh angkek, “John Kwatjeh Irrpelh-ilenh-ilenh arrwetj-penh weth iteth-irrek kwel! Altjerrel renh twer-ilek, mpwaretjeh twer anthwerrel.” ");
INSERT INTO amx_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Tjerrtj arrpenh map Jesu-penh angkerrek, “Elijah rang kwel weth alkereng angkep petj-alpek nwerneh-warn.” Tjerrtj arrpenh map angkerrek, “Jesu kwel Altjerr-henh angketj angenh-angenh ngkweyeny-arteh petjek.” ");
INSERT INTO amx_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","King Herod-el angketj Jesu-penh awek, lakenh rang pal-pal angkek, “Thang John renh ntjwang rlweth-atwemel irrernng atwek, rang kwel weth iteth-irretj-alpek!” ");
INSERT INTO amx_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Arrwekel-antey King Herod-el Herodias tjey kwerenh Philip-kenh anew inek. John-el renh iltekarleng, “Nhenh itja arratj anem, ntwang tjey ngkwengenh-henh arrkar inek.” Angketj nhenh-penh King Herod-el atwenh-atwenh kwerenh map twernek, John renh antwerrketjeh. Inang renh chain-el ayernek, tjayel-warn kwernek. ");
INSERT INTO amx_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Marl Herodias rang ahentj-anek, John renh irrernng atwetjeh. Rang renh ywarn irrernng atwek, Herod-el renh arntarnt-aremarleng. ");
INSERT INTO amx_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herod John-hetj ater-irrek, rang artwang arratj anthwerr anemarleng wart. Herod John-eh kweteth ntangkelhetjart, angketj kwerenh awetjeh. Rang angketj renh pal-pal awetjart. ");
INSERT INTO amx_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Marl Herodias rang kwet ahentj-anek, John irrernng atwetjeh. Kwereng King Herod-el lakenh tjenkerr mpwarek angerrentj kwerenhek. Ngwerrm-irrentj arltang kwerenheh irlpangketjeh, mern inang arlkwetjeh. Rang mer Galilee-areny angerrepat twernk mapeh, twernk atwenh-atwenh map-henh mapeh ntangkelhek, kwerel-ayeng tjenkerr arlkwetjeh. ");
INSERT INTO amx_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Inang tjenkerr arlkwerl-anemeng, marl Herodias-henh ampekw angerrepat petjemel ineh anthep-irrek. Rang inenh angerr kangketjeh mpwarek. Lakenheng Herod-el marl renh pawenhek, “Wenheh ntwang apek ahentj-anem? Yeng pawenhay! ");
INSERT INTO amx_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Thang ngwenh Altjerr-henh arrenyel alheletjenh, ntwang apek mer tjengenheh akert arrpenheh ahentj-anemeng, thang ngwenh kel anthetjenh.” ");
INSERT INTO amx_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Marl angerrepat arratemel matj kwerenh-warn alhek, renh pawenhetjeh. “Wenheh ntwang ahentj-anem, yeng kwer nketjeh?” Matj kwerenhel renh ilek, “Herod-eh nkay, John Kwatjeh Irrpelh-ilenh-ilenh kapert kwerenh ngkweng anthetjeh.” ");
INSERT INTO amx_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kwer-penh marl angerrepat rang parrp Herod-warn alpek. Rang renh ilek, “Yeng ahentj-anem, ntwang yengenh John Kwatjeh Irrpelh-ilenh-ilenh-henh kapert anthetjeh, panth-warn arrernemel. Lyet-antey!” ");
INSERT INTO amx_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Renh awemel Herod rang ahentj-kweny-irrek. Rang renh twernk mapeng anngetherr alhelekarleng, rang marl kwer kangkwerrek. ");
INSERT INTO amx_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Lakenheng rang atwenh-atwenh nyent lanthek, tjayel-warn alhetjeh, John Kwatjeh Irrpelh-ilenh-ilenh-kenh ntjwang rlweth-atwetjeh. ");
INSERT INTO amx_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Rang kapert renh pantheh arrernemel angetj-alpek, marl renh rang anthek. Marl rang renh matj kwerenheh anthek. ");
INSERT INTO amx_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","John-henh kwertengerl mapel angketj awemel, inang tjayel-warn alhek, mpwerrk kwerenh inerl-alpek. Inang anginek awenng-warn arrernetjeh. ");
INSERT INTO amx_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Kwertengerl kwerenh map Jesu-warn petj-alpek. Kwereng inang renh ilek, “Nwern kwenh tjerrtj map kaltj-anthek, nwern ngangkarel mpwarek, arrentj alharlkwek tjerrtj mapeng, ntwarl nwernenh twernekarl-arteh.” ");
INSERT INTO amx_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Tjerrtj aningkel Jesu-henh kwertengerl map parrk-parrk anthwerr-ilek. Jesu inang mern-arlk ywarn arlkwek. Lakenh-hetj Jesu-el kwertengerl map ilek, “Mpa! Nwern rrkwal-warn alhey, kwek ltjwerremel anetjeh.” ");
INSERT INTO amx_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Boat-warn antjemel inang kwatj iter arrpenh-warn alhek. Inang itja tjerrtj map ilek, inang rrkwal-warn alhemeng. ");
INSERT INTO amx_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Tjerrtj mapel inenh arekarl, boat-eh antjekarl. Inang mer renh kel iterl-arek, inang mer kwer-warn arrengker ingketjel ingkerneng alhek. Tjerrtj inek-amparr mer kwer parrp alhek, arrwekel irrek, arrernelhetj-alhek. Boat-akert inang ingkern irretj-alhek mer kwer-warn. ");
INSERT INTO amx_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Boat-eng anarnpemel Jesu-el tjerrtj aningk inenh arek. Inang kwenh yep-yep map aningk-arteh anek, tjerrtjel inenh itja arntarnt-arem. Rang ineh ltarrp-irrek, rang inenh kaltj-anthek. ");
INSERT INTO amx_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kel angwerr-angwerr irrek. Kwertengerl kwerenh map inang Jesu-warn itwek-irrek, renh ilek, “Mer nhenh-arteh rrkwal anthwerr, mern-kweny! ");
INSERT INTO amx_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Mern itjeng ntwang tjerrtj nhenh map kel lanthay town kwek map-warn alhetjeh, mern inetjeh.” ");
INSERT INTO amx_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesu-el kwertengerl inenh ilek, “Arrantherr-atetj inenh mern arlkwetjeh antherrerrang.” Inang renh pawenhek, “Ntwang ahentj-anem, nwern ker mern-arlk tjang-inetjeh? Tjerrtj nhenh map wantetjeh? Nwernehemeh maney kwek war intem!” ");
INSERT INTO amx_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesu-el inenh pawenhek, “Nthakentjam mern arrantherr rrkwem? Aretjeh-amparr alherrerray!” Kwertengerl inang alhemel arerl-alpek. Arekarl-penh inang renh ilek, “Mern 5-arl irrpenng atherr.” ");
INSERT INTO amx_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jesu-el kwertengerl map ilek, “Arrantherr tjerrtj inenh lanthang aningkam-aningk arnamel anetjeh.” ");
INSERT INTO amx_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Tjerrtj inang aningkam-aningk arrernelhek, aningk arrpenh tjerrtj 100-akert, aningk arrpenh map tjerrtj 50-akert. ");
INSERT INTO amx_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesu-el mern 5 inenh irrpenng atherram inek, alker-warn kern-arntep aremel, rang Altjerr renh pawenhek. Kwereng rang mern inenh rlweth-akek. Rang mern ngkweltj map kwertengerl mapeh anthek, tjerrtj mapeh irrarnpelh-iletjeh. Irrpenng atherram rang rlweth-akemel ineh anthek, irrarnpelh-iletjeh. ");
INSERT INTO amx_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Kel tjerrtj arwenth anthwerrel arlkwek. Itja tjerrtj nyent apek angayel anek. ");
INSERT INTO amx_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ingkern inang panth 12-warn arrernek mern ker irrpenng ampeny-ampeny inenh inemel. ");
INSERT INTO amx_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Arltang kwerel artwang 5,000 inang mern ker arlkwek. ");
INSERT INTO amx_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jesu-el kwertengerl kwerenh map lanthek, ineh-amparr boat antjetjeh, kwatj-angkwerr arrwekel alhetjeh mer Bethsaida-warn. Rang antarl-irrek, tjerrtj inenh-amparr mer-warn lanthetjeh. ");
INSERT INTO amx_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Rang tjerrtj inenh kel lanthekarlengemeh, Jesu rang irntang iter-warn antjek, Altjerr-warn angketjeh. ");
INSERT INTO amx_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kel angwerr-angwerremeh irrek, Jesu nyent-areny ingkern anetjam irntangel. Kwertengerl map boat-el alhetjam kwatj mpwepel. ");
INSERT INTO amx_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jesu-el arek, inang iltjelay-irremeng, irlkang twerel inenh ularr-theyel atwentjemeng. Kel lyet-atheh aherlkentj-alhemeng, Jesu ineh-warn ingkang alhek kwatj-angkwerr. Rang kel anper alhetjeh irrek. ");
INSERT INTO amx_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","Kwertengerl kwerenh mapel renh arek, kwatj kernel ineh-warn ularr ingkang petjemeng, inang iterl-arek lthan kwel petjekarleng. Ater inang arlkerl-alhek. Jesu-emeh parrp ineh-warn angkek, “Yengeyay! Ater-irretjal anerrerray!” ");
INSERT INTO amx_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Jesu rang boat-warn antjek, inehel-arleng anetjeh. Irlkang twer rang ywerrek. Lakenh irrekarl-penh kwertengerl map anwerlkek. ");
INSERT INTO amx_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Inartek angwerrekarl, inang itja mern nheng-penh iterl-arek, Jesu-arl rang twer anthwerr anek. ");
INSERT INTO amx_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Inang kwatj alay iter irremel boat-eng anarnpemel, boat renh rope-el ayernek arnangel-ayel. Kwer-penh inang mer Gennesaret-warn alhek. ");
INSERT INTO amx_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Tjerrtj mapel-antem Jesu renh alhengk-arek. ");
INSERT INTO amx_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","56","Tjerrtj mer map-areny inang-antem parrp mer inehenh-warn alhek, tjerrtj irlkert map Jesu-warn angetjetjeh. Jesu-emeh mer map-warn alhek, town-warn mer kwek-warn. Tjerrtj mer-areny inang irlkert inehenh angek mer inarl arraw-irretjam-warn. Irlkert inang Jesu renh pawenhek, “Nwernenh impay, mantarr ngkwengenhant arnpetjeh!” Tjerrtj irlkert inarl mantarr kwerenh arnpekarl, inang kel mwerr-irrekemeh. ");
INSERT INTO amx_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Kwer-penh Pharisee rrpwetj, Moses-henh mpwareng-areng kaltj-anthenh-anthenh Jerusalem-areny rrpwetj inang Jesu-warn petjek. ");
INSERT INTO amx_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Inang arek Jesu-kenh kwertengerl rrpwetjel itja iltjang lhewelhekarl, mern arlkwetjeh-anngerntel. ");
INSERT INTO amx_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Artwang Pharisee mapel tjerrtj Jew arrpenh mapel iltjang inehenh lhewelhemelant mern arlkwetjart. Lakenh angerrepat inehenhel mpwareng-areng mpwarekarl. ");
INSERT INTO amx_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Tjerrtj inang shop-warn alhetjart, mern ker-arlk inetjeh. Angerrepat inang inenh aretjart, iterremel iltjang ulpert-akert. Lakenheng inang inenh iletjart, lhewelhetjeh mern renh arlkwetjeh-anngernt. Inang tjampet-arlk inehenh kweteth lhewetjart. ");
INSERT INTO amx_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Artwang Pharisee mapel kaltj-anthenh-anthenh mapel Jesu renh pawenhek, “Wenhengarl kwertengerl ngkwengenh mapel mern arlkwem, iltjang lhewelhetj-kwenhel? Wenhengam inang angerrepat map-henh mpwareng-arengeh itja kangkwerrem?” ");
INSERT INTO amx_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesu-el inenh ilek, “Arrantherr-artek artwang anetj map! Angketj angenh-angenh nheng Isaiah-el Altjerr-henh angketj arrernek, rang tjerrtj arrehantherr-penh angkek. ‘Tjerrtj nhenh mapel angketj inehenhel yengenh nakem, inang tjeng itja kangkwerrem. ");
INSERT INTO amx_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Inang tjeng arraw-irrem, angketj tjeyenh awetjeh, inang itja arratj mpwarem. Inang itja tjerrtj arrpenh mapeh angketj tjeyenh kaltj-anthem. Inartek tjerrtj-henh mpwareng-areng war kaltj-anthem.’ ” Lakenh Altjerr angkek angketj angenh-angenh Isaiah-el-ayeng. Angketj nhenh lyet arratj anthwerr-irrek. ");
INSERT INTO amx_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Arrantherr kwenh itja arratj Altjerr-henh mpwareng-arengeh kangkwerremel awem. Tjerrtj-henh mpwareng-areng war arrantherr alhengk-arem.” ");
INSERT INTO amx_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jesu-el inenh ilek, “Arrantherr kwenh Altjerr-henh mpwareng-areng mentj impem, tjerrtj-henh mpwareng-arengehemeh kangkwerretjenharl, ahelh-arenyeh. ");
INSERT INTO amx_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses-el-arleng Altjerrel arrantherrenh ilek, angey matj arrehantherr-henheh kangkwerretjeh. Angketj arrpenh nhenheh: ‘Tjerrtj ngwenh apek rang angey kwerenh matj kwerenh altherrker-wem, renh arrantherr kel irrernng atwetjeh.’ ");
INSERT INTO amx_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Arrantherr tjerrtj map lakenh ilem: ‘Tjerrtj apek angey matj itja mern rnwanentj anthem, lakenh ilemel, “Thang mern rnwanentj nhenh itja mpweleh anthetj-kwenh. Mern nhenhan tjenkerr anem, Altjerr-henhant. Thang Altjerr lakenh alhelek.” ’ Arrantherr inenh ilem, lakenh kwel mwerr anemeng. Itja kwet! ");
INSERT INTO amx_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Lakenharl arrantherr inenh ayakem-arteh, angey matj inehenh arntarnt-arehetjeng. ");
INSERT INTO amx_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Lakenheng arrantherr Altjerr-henh mpwareng-areng kweteth mentj impem, arrantherr tjerrtj-henh mpwareng-areng kaltj-anthetjenheng. Lakenhan anetjam! Iterrentj arrehantherr-henh ahelh nhenh-areny war!” ");
INSERT INTO amx_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jesu-el tjerrtj map weth arraw-ilek. Rang inenh ilek, “Nhenh awerrerray atjernpel. ");
INSERT INTO amx_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Tjerrtjel mern arrakertel arlkwem. Mernel kwenh tjerrtj renh ywarn Altjerreng ularr anetj-ilem. Angketj arrakerteng arratem. Angketj anetj rarteh tjerrtj renh Altjerreng ularr anetj-ilem.” ");
INSERT INTO amx_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Jesu kwertengerl kwerenh map-akert warl-warn kwen irrpenhek, tjerrtj arwenth inenh kethel imperl-alhemel. Kwertengerl mapel Jesu renh pawenhek, “Nwerneh keth-ilay, angketj ntwarl lyet ilekarl.” ");
INSERT INTO amx_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Rang inenh ilek, “Arrantherrenp key arratj iterrentj-kweny anem? Iterl-aray! Mern arrantherrarl arlkwem, mern nhenhel arrantherrenh ywarn Altjerreng ularr anetj-ilem. ");
INSERT INTO amx_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Mern nhenh itja iterrentj-warn irrpem, anert-warnant war. Kwereng mern rang mpwerrkeng arratenhem.” Lakenh angkemel Jesu ahentj-anek inenh iletjeh, mern ingkerrek mwerr anemeng arlkwetjeh. ");
INSERT INTO amx_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jesu-el inenh ilek, “Anetj tjerrtj-henh iterrentjengarl awelhentjeng arratem. Tjerrtjarl anetj angkemel mpwarelhem, anetj mpwarem. Lakenh tjerrtj inang Altjerreng ularr anetj-ilelhem. ");
INSERT INTO amx_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Lakenh tjerrtj anetj mernelhem. Tjerrtj ngwenh apek pal-pal iterrem. Pal-pal iterremel rang rrwernelhemel kwewaleny anetj mpwarelhem. Rang rwengkel inem, irrernng atwem. Artwang arrpenh artwang arrpenh-henh marlel-ayeng intem. ");
INSERT INTO amx_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Tjerrtj rang maneyeh-arlk alherrem, rnwanentj angerreh apek. Tjerrtj rang tjerrtj arrpenh akeng-ilem, iltem apek. Tjerrtj rang kwer-areny iterremel rrtjwerremel ilem. Tjerrtj rang tjerrtj arrpenh-henh mantarr apek aremel, maney angerr aremel apek, lakenh rang alherrem. Tjerrtj rang tjerrtj arrpenheh tjel-angkem. Tjerrtj rang tjerrtj arrpenh mapeh tjwenelhem. Tjerrtj rang arnterr angkerl-apemel ahert-ahert mernelhem. ");
INSERT INTO amx_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Alherrentj anetj ingkerrek-artek tjerrtj-henh iterrentjeng arratem. Tjerrtj inang lakenh Altjerreng ularr anetj-ilelhem.” ");
INSERT INTO amx_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesu rang mer Gennesaret renh imperl-alhek, town Tyre-eng akert-warn alhek. Rang warl nyent-warn irrpek, tjerrtj map-hetj alengk-welhemel. Rang ywarn kwet alengk-welhek. Tjerrtj map kaltj kwet anek, rarl alengk-welhekarl. ");
INSERT INTO amx_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Marl nyent lwereny warl arrpenhel anek, rang mer Phoenicia-el kwer intekarl. Kwer marl kwerenh arrentj-akert anek. Matj rang awek, Jesu-arl petjekarl. Rang parrp Jesu-warn alhek, amperel-ayel kwereng ularr arrernelhetj-alhek. Rang Jesu kwet anthwerr pawenhek, rang arrentj kwer marl kwerenheng alharlkwetjeh. ");
INSERT INTO amx_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jesu-el renh ilek, “Thang mernel kwer mapek-amparr wantetjeh. Nhenhemeh itja arratj anem, kwer-henh mern angwely mapeh anthetjeh.” ");
INSERT INTO amx_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Marl rang renh ilek, “Ngkartay! Ntwang kel arratj angkem. Angwely inem mern ngkweltj inenh arlkwem, ngkweltj nheng kwerelarl mentj impem.” ");
INSERT INTO amx_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesu-el renh ilek, “Ntwang kwenh arratj angkek! Kel alpang, arrentj kel kwer marl ngkwengenheng arratemel ywerrek!” ");
INSERT INTO amx_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Alpemel rang kwer marl kwerenh aretj-alpek antjamel intemeng, mwerr-irrekarl. Arrentj kwereng kel arratemel ywerrerl-alhekarl. ");
INSERT INTO amx_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesu rang town Tyre kwereng mer Sidon-warn alhek. Kwer-penh rang mer Sidon-eng antekerr kwet mer Decapolis-warn alhek. Mer Decapolis-angkwerr rang Galilee kwatj alay-warn petj-alpek. ");
INSERT INTO amx_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Mer-areny mapel artwang nyent inang kwer-warn angetjek. Artwang rang irlpang ahert anek, apekap anetjam. Inang Jesu renh anthwerr pawenhek, rang iltjang artwang ahert kwer-arleh arrernetjeh. ");
INSERT INTO amx_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesu-el artwang renh mapeng arratelh-ilek keth-warn, ratherrarrp irnetjeh. Kwereng rang iltjang kantj artwang ahert-kenh irlpangeh kwernek. Kwer-penh rang apelh-wemel artwang kwerenheh alenyek arrernek. ");
INSERT INTO amx_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jesu rang alker-warn-athek aremel artwang renh ahey-angkemel ilek, “Ephphatha!” Nhenh angketj Anmatjerrel angart-wem “Altjwer-irray!” ");
INSERT INTO amx_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Artwang rang kel mwerr awek, mwerr anthwerr angkek. ");
INSERT INTO amx_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesu-el tjerrtj map ilek, inang itja tjerrtj arrpenh map nhenh-penh iletjeh. Inang itja kwer kangkwerrek. Inang angketj renh tjerrtj arrpenh map wetham-weth ilek. ");
INSERT INTO amx_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Tjerrtj inartek Jesu-penh angerr anwerlkek. Inang ilerrek, “Rang kwenh iltjent anthwerr! Rang tjerrtj ahert map tjerrtj angketj-kwenh map mwerr-ilem!” ");
INSERT INTO amx_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Arltang arrpenhel tjerrtj map Jesu-warn arraw-irretj-alpek. Mern ingkerrek kel ywerrekarleng, Jesu kwertengerl kwerenh mapeh ntangkelhek, inenh rang ilek, ");
INSERT INTO amx_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nhenh map kel arltang rrpwetj nwernehel-ayeng anek mern-kweny angayel. Yeng-artek ineh ltarrp-irrem. ");
INSERT INTO amx_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Tjerrtj arrpenh map kwenh mer ntwarreng petjekarl. Thang apek inenh lyet angayel mer-warn lanthemeng, inang apek tjeyel ampwerrehetjeng.” ");
INSERT INTO amx_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Kwertengerl mapel renh ilek, “Mer nhenh-artek rrkwal anthwerr. Nthenheham nwern mern inetjenh, tjerrtj nhenh map anhwerlk-iletjeh?” ");
INSERT INTO amx_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesu-el inenh pawenhek, “Mern nthakentjam arrehantherr-henh intem?” Inang renh ilek, “Mern 7 war.” ");
INSERT INTO amx_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jesu-el tjerrtj arwenth inenh ilek, inang aherneh arrernelhetjeh. Kwereng rang mern 7 inenh inemel, rang Altjerr-warn angkek, mern arlkwetjeh-anngernt. Kwereng mern inenh ltwakemel rang mern ngkweltj inenh kwertengerl mapeh anthek, tjerrtj ineh irrarnp-iletjeh. ");
INSERT INTO amx_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ineh ker irrpenng rrpwetj intek. Rang Altjerr renh ker irrpenng ineh pawenhek. Rang kwertengerl mapeh anthek, tjerrtj mapeh irrarnp-iletjeh. ");
INSERT INTO amx_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Tjerrtj map inang mern ker irrpenng arwenth arlkwemel anhwerlk-irrek. Ingkern inang arlkwekarl-penh ampeny kwetjemel, kwertengerl inang 7 pantheh arlwelemel arrernek. Tjerrtj map inarl mern ker irrpenng arlkwekarl, inartek anek 4,000. Jesu-el tjerrtj inenh mer-warn alpetjeh lanthek. ");
INSERT INTO amx_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Kwer-penh rang boat antjerl-alhek kwertengerl kwerenh map-akert. Inang boat-el alhek kwatj alay itep arrpenh-warn, mer Dalmanuth-warn. ");
INSERT INTO amx_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Artwang Pharisee rrpwetj petjek, Jesu-el-ayeng angkerretjeh. Inang renh arrkernemel pawenhek, “Twer alker-areny ngkwengenh nwerneh mernay!” ");
INSERT INTO amx_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesu rang angerr ahey-angkek. Rang inenh pawenhek, “Arrantherr yengenh kweteth arlkarem, arrantherrenh twer tjengenh mernetjeh. Itja, thang arrantherrenh itja kwet mernetjenh.” ");
INSERT INTO amx_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Rang inenh imperl-alhek. Rang weth boat-eh antjemel rang kwatj alay-angkwerr boat-el alhek arrwengak iter-warn, kwertengerl kwerenh map-akert. ");
INSERT INTO amx_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Arrwekel kwertengerl map-artek mern arrpenheh angwerrerl-alhek. Inang mern nyentant-akert boat-warn antjerl-alhek. ");
INSERT INTO amx_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Inang alhep-alhekarleng, Jesu-el inenh alhel-aremel ilek, “Arrantherr-artek artwang Pharisee mapeng King Herod-eng arelhetjeh. Angketj inehenh-artek anem mern arlwar-ilenh-ilenh-artek.” ");
INSERT INTO amx_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Kwertengerl map angketj nhenh-penh angkerrek. Lakenh inang ilerrek, “Nwern mern itja angek. Rartek nwernenh lakenh ilek.” ");
INSERT INTO amx_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesu rang kel kaltj anek, angketj inarl angkerretjam-arleh. Rang inenh pawenhek, “Wenhengarl arrantherr mern-penh angkerrem? Arrantherr kwenh itja angketj tjengenh alhengk-arem! Arrantherr irlpang marnt kwetam? ");
INSERT INTO amx_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Arrantherr anem annga-akert. Wenheng arrantherr ywarn arem? Arrantherr anem irlpang-akert. Wenhengam arrantherr ywarn awem? Arrantherr mern nheng-penh angwerrekam? ");
INSERT INTO amx_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Panth nthakentjam arrantherr arlwelek mern ngkweltj-akert, nheng tharl tjerrtj 5,000 wantekarl mern 5-el?” Inang renh ilek, “12 panth kwenh.” ");
INSERT INTO amx_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jesu-el inenh weth pawenhek, “Panth nthakentjam arrantherr mern ngkweltj arlwelek, tjerrtj 4,000 thang wantekarleng mern 7-el?” Inang renh ilek, “7 panth kwenh.” ");
INSERT INTO amx_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Rang inenh pawenhemel ilek, “Wenh-penh yeng angkem? Arrantherr angketj tjengenh itja kwet alhengk-arem!” ");
INSERT INTO amx_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jesu kwertengerl kwerenh map-akert Bethsaida town-warn alhek. Mer-areny mapel artwang pweng nyent Jesu-warn angetjek. Tjerrtj inang Jesu pawenhek, rang artwang pweng renh arnpetjeh. ");
INSERT INTO amx_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesu-el artwang renh iltjang rrkwemel town-eng keth-warn angek. Jesu-el apelh arrernek artwang pweng-henh anngarleh. Jesu-el iltjang artwang kwer-warn arrernemel, renh pawenhek, “Ntwang apek arem?” ");
INSERT INTO amx_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Artwang rang angkek, “Yew, thang tjerrtj map arem arrkay-arrkay war.” ");
INSERT INTO amx_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jesu-el iltjang kwerenh weth arrernek artwang pweng-henh anngarleh. Artwang rang anngang mwerremeh-irrek. Rang kel keth arek. ");
INSERT INTO amx_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jesu-el artwang renh ilek, “Kel mer-warn alpay, anyenng-anyenng war. Tjerrtjel ngwenh pawenhehetjeng.” ");
INSERT INTO amx_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesu kwertengerl kwerenh map-akert town kwek map-warn anper-alhek, town nheng inarl town Caesarea Philippi-eng rtwang anemeng. Inang alhep-alhemarleng, Jesu-el kwertengerl map pawenhek, “Ngwenham tjerrtj mapel yengenh ilem?” ");
INSERT INTO amx_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Kwertengerl inang renh ilek, “Tjerrtj arrpenh mapel ngwenh ilem, ntwang kwel John Kwatjeh Irrpelh-ilenh-ilenh rang irrernngeng petj-alpekarl. Tjerrtj arrpenh mapel ngwenh ilem, angketj angenh-angenh Elijah kwel ntwang angkep petj-alpek. Tjerrtj arrpenh mapel ngwenh ilem, ntwang Altjerr-henh angketj angenh-angenh arrpenh kwel anemeng.” ");
INSERT INTO amx_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jesu-el inenh weth pawenhek, “Arrantherr-arteh? Arrantherr tjeng-penh nthakenharl iterl-arem? Ngwenham yeng?” Peter-el renh ilek, “Ntwang kwenh anem Christ anthwerr rang, king ngampekarl nheng Altjerrel ngkwey alhelekarl, nwerneh-warn lanthetjenh, rang nwernenh anetj mapeng arntarnt-aretjenheng.” ");
INSERT INTO amx_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesu-el inenh arnpakek, “Arrantherr tjerrtj arrpenh map itja iletjeh, yeng Christ rang anem.” ");
INSERT INTO amx_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","32","Kwereng Jesu rang kwertengerl kwerenh mapeh keth anthwerr ilelhek, “Tjerrtj-henh Ler kwer anem, irlkert angerr inetjeh. Aywang ngkweyeny map, ngkart Pharisee map, kaltj-anthenh-anthenh map thwen inang kwer ahentj-kwenh-irretjenh, renh inang artwang akeng-artek alharlkwetjenh, inang renh irrernng atwetjenh. Rang kweny atherr-penh irrernng intentj-penh rang weth iteth kemerretjenh.” Peter-el Jesu itep-warn angemel arrantjakek. ");
INSERT INTO amx_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesu rang alngarelhemel kwertengerl inenh-amparr arek, rang Peter renh-atetj arrantjakemel ilek, “Tjengeng alhay arrentjay! Ntwang kwenh itja Altjerr-arteh iterrem! Tjerrtj-arteh kwenh ntwang iterrem!” ");
INSERT INTO amx_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jesu-el tjerrtj inenh kwertengerl kwerenh map thwen arraw-ilek, kwer-warn itwek-irretjeh. Rang inenh ilek, “Tjerrtj apek ahentj-anem tjengel-ayel ingkern petjetjeh, nthakenham rang mernelhetjeh? Rang iterrentj kwerenheh itja weth kangkwerretjeh. Yengenh inang atwetjenh, yeng arrampewetjenh, lakenh-arteh tjerrtj rang anetjeh yeng-arteh. Rang mpatj tjeyenh ingkentetjeh. ");
INSERT INTO amx_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tjerrtj rarl athek-irrem kwer-areny iteth anetjeh, rang kel ilwetjenh. Tjerrtj rarl yengenh awem, angketj tjengenheh kangkwerrem, iterrentj kwerenheh angwerremel, rant kwenh iteth anetjenh. ");
INSERT INTO amx_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Tjerrtjel ahelh nhenhel maney angerr-akertel mantarr-arlk arwenth arlwelem, Altjerr renh iterl-aretj-kwenhel, rang kelant ilwetjenh. Nthakenham rang Altjerreng ularr anetjenh? Rang kwerrern kwerenh parlp-ilem-arteh, rang itja kwetant iteth anetjenh. ");
INSERT INTO amx_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Tjerrtjel kwenh ywarn maneyel payem-ilem, mer Altjerr-kenh-warn irrpetjeh-anngernt. Ntwang ywarn maney anthem kwerrern ngkwengenheh, itja. ");
INSERT INTO amx_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Tjerrtj arrpenh map lyet Altjerreh itja nyerrkem, inang tjerrtj anetj-akert anem. Tjerrtj rarl nyerr-irrem, tjerrtj anetj inenh angketj tjengenh iletjeh apek. Tjerrtj rarl tjengeng nyerr-irrem, rang kelant nthakenham irretjenh? Kelant Tjerrtj-henh Ler rang petj-alperleng-rlwer, rang tjerrtj nhenh kwereng nyerr-irretjenh. Nthakenh rang petj-alperleng-arteh? Rang angel alker-areny kwerenh map-akert twer arrpenh anthwerr petj-alpetjenh.” ");
INSERT INTO amx_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesu-el inenh ilek, “Mwantj awerrerrang! Tjerrtj arrpenh map inang lyet nhenhel irnerrerrem, inang yeng arerrerretjenh, petj-alperleh tjerrtj ingkerrekeh mernelhemel, yeng Ngkart angerr anemeng. Inang mpank ilwerrerretjenheng nhenh aretjenh.” ");
INSERT INTO amx_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Inang kel arlta 6-el anekarleng-antem, Jesu-el Peter James John ngwek. Rang ineh-akert irntang kern-warn antjek, inarrp anetjeh. Altjerrel Jesu renh ineheng anngetherr parrtjelh-ilek. ");
INSERT INTO amx_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Jesu-henh mantarr-antem mperlkek. Tjerrtjel ywarn mantarr mperlker lakenh mpwarem. ");
INSERT INTO amx_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Kel arrwekeleny atherr Moses Elijah ratherr Jesu-el-arleng irnetj-alhek, kwer angkerl-anerrek. ");
INSERT INTO amx_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","6","Kwertengerl inang ater-irrek anthwerr. Peter Jesu kwer pal-pal angkek, “Kaltj-anthenh-anthenhay! Nwern kangkem, nhenhel anetjeh! Mer lywang nwern artetjeh, ngkweng nyent, Moses-eh nyent, Elijah-eh nyent.” ");
INSERT INTO amx_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ankertelemeh inenh arltwetj-alhek. Altjerr ankerteng angkek, “Nhenh Ler tjengenh. Yeng kwer nyerrkem anthwerr. Arrantherr kwer kangkwerretjeh!” ");
INSERT INTO amx_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Inang alngarelhemel arek Jesu nyentemeh irnerleh. Moses Elijah ratherr kel ywerrerl-alherrek. ");
INSERT INTO amx_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Inang irntangeng anarnpentj-alpemel, Jesu-el inenh ilek, “Arrantherr itja tjerrtj arrpenheh iletjeh, nheng arrantherrarl arek. Kelant arrantherr iletjeh, Tjerrtj-henh Ler rang arrwetjeng kemerrekarl-penh. Kwer-penhant iletjeh.” ");
INSERT INTO amx_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Inang kel Jesu-ek kangkwerrek. Inang pawenherrek, “Wenham nheng rang angkek, rang kwel arrwetjeng kemerretjenharl?” ");
INSERT INTO amx_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Kwertengerl rrpwetj inang Jesu renh pawenhek, “Wenhengam Moses-henh angketj kaltj-anthenh-anthenh mapel ilem, Elijah-ek-amparr petjetjenh, kwer-penhant Christ rang petjetjenh?” ");
INSERT INTO amx_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesu-el inenh ilek, “Kel arratj. Elijah rek-amparr petjetjenh, tjerrtj ingkerrek arratj-iletjeh. Kwer-penh Tjerrtj-henh Ler rang ingkern petjetjenh. Angketj Altjerr-henh pipel-ayeng intem, ‘Tjerrtj-henh Ler rang irlkert angerr inetjeh-arlk, tjerrtj map kwer ahentj-kweny-irretjenh, inang renh alharlkwetjenh.’ ");
INSERT INTO amx_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Yew, arratj anthwerr, Elijah rang kel petj-alpek. Tjerrtj map kwer irrpelth-irrek, renh alharlkwek, Altjerrel ilekarl-arteh, angketj kwerenhel-ayeng.” Jesu-el inenh angketj nheng Elijah-akert ilek, rang John Kwatjeh Irrpelh-ilenh-ilenh kwer-penh ilek. ");
INSERT INTO amx_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jesu kwertengerl rrpwetj-akert kwertengerl arrpenh nheng map-warn petj-alpek irntangeng. Inang arek tjerrtj arwenth kwertengerl arrpenh mapel-ayeng anemeng, kwertengerl inang kaltj-anthenh-anthenh mapel-ayeng ilterremeng. ");
INSERT INTO amx_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Tjerrtj mapel Jesu renh aremel anwerlkerrerrek. Inang kwer-warn arrtjanetj-alhek. ");
INSERT INTO amx_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Rang inenh pawenhek, “Wenheng arrantherr ilterreperrem?” ");
INSERT INTO amx_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Artwang nyentel renh ilek, “Kaltj-anthenh-anthenhay! Thartek kwer rrwey tjengenh ngkweng-warn angetjek. Rang kwerrern anetj-akert anem, rang ywarn angkem-arlk. ");
INSERT INTO amx_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kwerrern anetj nhenh rang kwer rrwey tjengenh antwerrkemarleng, rang renh ahelh-warn ilatwem, arrakert kwerenh rlkwerrp-rlkwerrp irrem. Rang tetj kwerenh karlkwelhem, kwereng rang arlan-irrem. Yeng kwertengerl ngkwengenh map-warn petjek pawenhemel, inang kwerrern anetj renh ler tjengenheng alharlkwetjeh. Inang kwerrern anetj renh ywarn kwet alharlkwek.” ");
INSERT INTO amx_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesu-el tjerrtj ingkerrek arrantjakek, “Arrantherr-artek naketj-kwenh! Arrantherr itja Altjerr renh nakem! Yeng-artek arrehantherrel-ayeng kwet anthwerr anek, arrantherrenh kaltj-anthek. Yeng-artek arrantherr parrk-parrk-ilem! Kwer rrwey renh tjeng-warn angetjewarrang!” ");
INSERT INTO amx_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Inang kwer rrwey renh Jesu-warn angetjek. Arrentj rang Jesu renh arek-arteh, kwer rrwey renh rang ahelh-arleh ilatwerl-alhek. Kwer rrwey rang ahelhel welherl-apetjam, arrakert kwerenh-arlk rlkwerrp-rlkwerrp-irrek. ");
INSERT INTO amx_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesu-el kwer rrwey kwerenh nywek renh pawenhek, “Ilwengaram kwer rrwey nhenh rang lakenh irrek?” Nywek rang angkek, “Kwer rrwey nhenh rang kwer kwekeng lakenh kwet rang anentjek. ");
INSERT INTO amx_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Map-ingar kwenh kwerrern anetj rang kwer rrwey renh atwetjeh ahentj-irretjart. Renh rwangeh wemel taly-wetjart, kwatj-arlk kwernemel. Ilernehak ltarrp-irray, ilernehak tangetjel anang! Ntwang apek kwerrern anetj renh alharlkwemeram, kwer rrwey ilern-henheng.” ");
INSERT INTO amx_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesu-el renh ilek, “Wenhengarl ntwang yengenh lakenh pawenhek? Ntwang apek Ngkart renh nakem, rang renh mwerr-ilem, rang kwenh renh mwerr-iletjenhengarl.” ");
INSERT INTO amx_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kwer rrwey kwerenh nywekel Jesu renh arnterrel ilek, “Thang kwenh Ngkart renh kwek war nakem. Yengenh kaltj-anthay, thang renh twer anthwerrel naketjenheng!” ");
INSERT INTO amx_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesu-el arek, tjerrtj arwenth arnekarner ineh-warn-athek arrtjanentj-alhemeng. Rang kwerrern anetj renh arrantjakemel alharlkwek, “Kwerrern ahert-ilenh-ilenhay, kwereng arratang! Itja weth kwer-warn irrpetj-alpetjeh!” ");
INSERT INTO amx_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kwerrern anetj arlkerl-alhemel rang kwer rrwey renh arrewetjeh mpwarek. Kwerrern anetj rang kel kwereng arraterl-alhek. Kwer rang arrwetj-arteh intek. Tjerrtj arrpenh map angkek, “Rang kwenh kel ilwek.” ");
INSERT INTO amx_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesu-el kwer renh iltjangeng antwerrkemel, renh kemelh-ilemel ngkernek. ");
INSERT INTO amx_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kwer-penh Jesu rang kel warleh irrpekarleng kwertengerl kwerenh map-akert, inang renh pawenhek, “Wenhengam nwern kwerrern anetj renh ywarn alharlkwek?” ");
INSERT INTO amx_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesu-el inenh ilek, “Tjerrtjel kwerrern anetj lakenh-arteh ywarn alharlkwem, tjerrtj rang Altjerr pawenhemelant war.” ");
INSERT INTO amx_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Inang mer renh imperl-alhemel Galilee-angkwerr alhek, inarrp anetjeh. Jesu rartek kwertengerl map kaltj-antherl-anek. Jesu itja ahentj-anek, tjerrtj arrpenh map kaltj anetjeh kwer, rarl mer kwerel anem-arleh. Rang kwertengerl inenh ilek, “Tjerrtj-henh Ler renh artwang nyentel anthetjeh artwang atwenh-atwenh map-warn. Inang renh irrernng atwetjenh. Kweny atherr-penh arrwetj intemarl-penh rang weth kemerretjenh.” ");
INSERT INTO amx_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Kwertengerl mapel Jesu-henh angketj itja alhengk-arek. Inang ater-irrek, renh pawenhetjeh. ");
INSERT INTO amx_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jesu kwertengerl kwerenh map-akert Capernaum town-warn alhek, warl nyent-warn irrpenhek. Rang kwertengerl inenh pawenhek, “Wenh-penham arrantherr tjeyel ilterrerl-apetjam?” ");
INSERT INTO amx_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Inang marn war anek. Inang arrwekel pawenherrerl-apek, “Ngwenham nwerneheng twernk mwerr anemer nwerneh?” ");
INSERT INTO amx_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesu-el arrernelhemel kwertengerl 12 arraw-ilek. Rang inenh ilek, “Tjerrtj ngwenh apek tjerrtj arrpenh mapeh twernk anetjeh ahentj-anem, rang itja tjwenelhetjeh. Rang tjerrtj arrpenh mapeh tangetjel anetjeh, ineh arntarnt-aremel rrkwapetjeh.” ");
INSERT INTO amx_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jesu-el kwer kwek ngwek, kwer renh ineheng mpwepeh ngkernek. Rang kwer renh inek. Kwereng rang inenh ilek, ");
INSERT INTO amx_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Tjerrtj ngwenh apek kwer kwekeh kangkentj mernelhem, yengenh iterl-aremel, rang tjeng kangkentj mernelhem. Tjerrtj ngwenh apek tjeng kangkentj mernelhem, rang kwer kangkentj mernelhem, rarl yengenh lanthekarl.” ");
INSERT INTO amx_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Arltang arrpenhel John-el Jesu renh pawenhek, “Kaltj-anthenh-anthenhay! Nwern artwang nyent arek, kwerrern anetj map tjerrtjeng alharlkwemeng, arreny ngkwengenhel ilemel. Rang nwernehel-ayeng itja anem, lakenheng nwern renh arnpakek.” ");
INSERT INTO amx_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesu-el kwertengerl map ilek, “Arrantherr renh itja arnpaketjeh. Tjerrtj ngwenh apek tjerrtjeng kwerrern anetj alharlkwem arreny tjengenhel, kel mwerrarl! Rang itja tjeng-penh anetj angkem. ");
INSERT INTO amx_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tjerrtj ngwenh apek rang nwerneh irrpelth-irretj-kwenh anem, rang peltj nwern-henh anem. ");
INSERT INTO amx_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Arrantherr nhenh iterl-aray, ntwang angkethel apek anemeng, tjerrtj rarl ngwenh arem, alhengk-aremel ntwang Christ Jesu-henh anemeng. Rang lakenh iterrem apek, ‘Thang ngwenh kwatj antjwetjeh anthem arreny Jesu-el.’ Altjerrel kwenh tjerrtj renh kwart-wetjenh.” ");
INSERT INTO amx_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Tjerrtj ngwenh apek rang tjerrtj nakenh-nakenh nyent apek arrtjelh-ilem anetj mpwaretjeh, nhenheng angerr-lkwer anetjenh kwer: Altjerrel irntang angerretj ntjarrkwer kwer-arleh ayernetjenh, kwer-penh kwatj alay-warn renh taly-wetjenh, rarrp ilwetjeh. ");
INSERT INTO amx_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Iltjang ngkwengenhel ntwang apek anetj mpwarem. Kel iltjang renh rlweth-akayantay! Nhenh mwerr anem: ntwang Altjerr-henh mer-warn irrpetjeh iltjang nyent-akert, kwetant anetjenheng. Altjerrel ngwenh iltjang atherr-akert mer rwang ngampekarl-warn wehetjeng. Mer kwerel rwang itja kwet ilwernelhem. ");
INSERT INTO amx_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ingkang ngkwengenhel ntwang apek alhem, anetj mpwaretjeh. Kel ingkang renh rlweth-akayantay! Nhenh mwerr anem: ntwang arlamarr Altjerr-henh mer-warn irrpetjeh, kwetant anetjenheng. Altjerrel ngwenh ingkang atherr-akert mer rwang ngampekarl-warn wehetjeng. ");
INSERT INTO amx_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Anngang ngkwengenhel apek ngwenh anetj mernelhetjeh arrtjelh-ilem. Kel anngang renh rlpwentjay! Nhenh mwerr anem: ntwang Altjerr-henh mer-warn irrpetjeh anngang nyent-akert, kwetant anetjenheng. Altjerrel ngwenh anngang atherr-akert mer rwang ngampekarl-warn wehetjeng. ");
INSERT INTO amx_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Mer kwerel irnngang itja ilwem. Irnngang inang kweteth tjerrtj renh nhwetjenh. Mer kwerel rwang itja ilwernelhem, aleth amperl-anem. Tjerrtj inang kwerel kwet ampangketjenh arlkerl-anetjenh. ");
INSERT INTO amx_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Tjerrtjel arrantherrenh arrkernemel nakepakel-ilemeng, arrampewemeng apek, atwemeng apek. Tjerrtjel arrantherrenh rwang kepel-arteh itetjenh. Arrantherr itja ineh kangkwerretjeh. Arrantherr arrkernelhetjeh, arratjant anetjeh, Altjerr kwerant kangkwerretjeh. Arrantherr ilewerr-arteh kwemey anetjeh. ");
INSERT INTO amx_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ilewerrel kwenh ker kwemey-ilem. Ilewerr apek kwang-kweny-irrem, tjerrtjel ywarn ilewerr renh weth kwang-akert-ilem. Arrantherr ilewerr mwerr-arteh ularrek-ularr kangkentj mernelhetjeh, ngwerleny angkerremel anetjeh.” ");
INSERT INTO amx_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesu mer renh imperl-alhek kwertengerl kwerenh map-akert, mer Judea-warn alhek, Jordan ulpayeng ingerr-warn. Tjerrtj arwenth kwer-warn arraw-irrentj-alpek. Rang inenh kaltj-anthek. ");
INSERT INTO amx_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Artwang Pharisee rrpwetj kwer-warn petjek, renh arrkernemel pawenhek, “Nhenham arratj anem, artwel marl kwerenh mentj impetjeh?” ");
INSERT INTO amx_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesu-el inenh pawenhek, “Nthakenh Moses-el arrantherrenh ilek Altjerr-henh angketjel-ayel?” ");
INSERT INTO amx_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Inang renh ilek, “Moses-el arrwekeleny map inenh ilek, artwang rang marl kwerenh mentj impetjeh apek, rang kel pip-warn arrernetjeh angketj nhenh, ‘Yeng kel ngkwengeng impelhemant.’ Kwer-penh pip nhenh marl kwerenheh anthetjeh.” ");
INSERT INTO amx_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jesu-el inenh ilek, “Moses-el arrantherrenh impek, anew arrehantherr-henh impetjeh, arrantherr anetj wart anemeng. ");
INSERT INTO amx_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Arrwekel Altjerrel tjerrtj arrmernek, rang inenh rrwey marl arrmernek. ");
INSERT INTO amx_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Lakenheng artwel angey mwek kwerenh imperl-alhem, anew kwerenhel-ayeng kwet anetjeh. ");
INSERT INTO amx_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ratherr artwang marl thwen nyent-irrem. ");
INSERT INTO amx_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Renh-atherrenh Altjerrel nyentelh-ilekarl, tjerrtjel renh-atherrenh itja ngaketjeh.” Lakenh Jesu-el inenh kaltj-anthek. ");
INSERT INTO amx_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Jesu kwertengerl kwerenh map-akert warl kwenel anemeng, inang renh angketj nheng-penh pawenhek. ");
INSERT INTO amx_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesu-el inenh keth-ilemel ilek, “Artwang ngwenh apek rang anew kwerenh impem, marl arrpenh anew inem, rang kel anetj mpwarem. ");
INSERT INTO amx_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Marl ngwenh apek rang anew kwerenh impem, artwang arrpenh anew inem, rang kel anetj mpwarem.” ");
INSERT INTO amx_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tjerrtj mapel kwer inehenh Jesu-warn angetjek, Jesu-el iltjang kapert inehenheh arrernetjeh. Jesu-henh kwertengerl mapel tjerrtj inenh arnpakek, kwer inenh Jesu-warn angetjehetj. ");
INSERT INTO amx_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesu-el nhenh aremel kwertengerl kwerenh mapeh ahang-irrek. Rang inenh ilek, “Tjerrtj inenh ayaketjal imperrerrang. Yeng ahentj-anem, inang kwer map tjeng-warn angetjetjeh, Altjerr rang kwer map-henh Ngkart anemeng wart. ");
INSERT INTO amx_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nhenh iterl-aray, arrantherr ahentj apek Altjerr-henh mer-warn irrpetjeh, arrantherr kwer kwek nhenh map-arteh anetjeh, anetj-kweny. Itjeng apek itja kwetarl.” ");
INSERT INTO amx_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Rang kwer nyentam-nyent inemel anwarteh arrernek. Rang iltjang kapert inehenheh arrernek, rang nyentam-nyent Altjerr tjang-pawenhek kwer mapeh, Altjerrel inenh twer-iletjeh. ");
INSERT INTO amx_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesu-antem alhetjeh anek, artwang nyent kwer-warn arrtjanentj-alhek, kwereng ularr amperel-ayeng arrernelhek. Rang Jesu renh pawenhek, “Kaltj-anthenh-anthenhay, ntwang kwenh artwang mwerr! Nthakenham yeng mernelhetjeh, yeng Altjerr-henh merel kwetant iteth anetjenheng?” ");
INSERT INTO amx_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesu-el renh ilek, “Wenheng ntwang yengenh mwerr akem? Altjerr rant kwenh mwerr anem. ");
INSERT INTO amx_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ntwang kel Altjerr-henh mpwareng-arengeh kaltj. ‘Arrantherr itja tjerrtj arrpenh irrernng atwetjeh.’ ‘Arrantherr itja tjerrtj arrpenh-henh marlel-ayeng intetjeh.’ ‘Arrantherr itja tjerrtj arrpenh-henh rnwanentj rwengkel inetjeh.’ ‘Arrantherr itja tjerrtj arrpenh-penh rrtjwerrerl-apetjeh.’ ‘Arrantherr itja rrtjwerremel tjerrtj arrpenheh maneyeh rnwanentjeh-arlk ankey nketjeh alhelemel.’ ‘Arrantherr angey mwek arrehantherr-henheh kangkwerretjeh.’” ");
INSERT INTO amx_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Rang Jesu renh ilek, “Kaltj-anthenh-anthenhay, yeng mpwareng-areng nhenh ntjapereh kangkwerrek kwer kwekeng-ntjel.” ");
INSERT INTO amx_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesu-el renh rtwant arek, kwer nyerrkemel. Rang renh ilek, “Nyentant ntwang itja mpwarek: rnwanentj maney ngkwengenh ingkerrek anthang tjerrtj maney-kweny mapeh. Kwereng Altjerrel ngwenh kwart-wetjenh, ngkweng rnwanentj maney angerr mer alkerel intetjenh. Kwer-penhant tjengel-ayel petjang!” ");
INSERT INTO amx_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Artwang-el nhenh awemel rang ltarrp awelhemel alpek, iterrentj atherram-akert. Rang itja kwet kangkwerrek, rartek maney angerr-akert anek. ");
INSERT INTO amx_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jesu-el kwertengerl map tjwer-aremel ilek, “Tjerrtj maney angerr-akerteh kwenh rnpwer angerr anem, Altjerr-henh mer-warn irrpetjeh.” ");
INSERT INTO amx_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Kwertengerl kwerenh map anwerlkek. Jesu-el inenh ilek, “Nhenh-artek rnpwer anthwerr Altjerr-henh mer-warn irrpetjeh! ");
INSERT INTO amx_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Iterl-aray, kamwerl kwenh angerretj anem, needle-henh altjwer kwek-angkwerr irrpenhetjeh, pwarn anthwerreng wart. Nthakenh kamwerl rang irrpetjenh? Lakenh-arteh anem tjerrtj maney angerr-akerteh. Nthakenh rang Altjerr-henh mer-warn irrpetjenh, altjwer pwarneng wart? Itja apek.” ");
INSERT INTO amx_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kwertengerl inang angerr anwerlkek. Inang renh pawenhek, “Tjerrtj ngwenham Altjerrel mer kwerenh-warn irrpelh-iletjenh? Itja apek?” ");
INSERT INTO amx_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Kwertengerl map tjwer-aremel Jesu-el inenh ilek, “Tjerrtj ywarn irrpem Altjerr-henh mer-warn! Nakentjel-ayengant war irrpetjenh. Tjerrtj inarl Altjerr renh nakemarl map, inant war irrpetjenh. Altjerr rant inenh irrpelh-iletjenh.” ");
INSERT INTO amx_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Peter-el Jesu renh pawenhek, “Nwern-arteh? Altjerrel nwernenh mer kwerenh-warn irrpelh-iletjenh apek? Nwern kwenh rnwanentj-arlk peltj map-arlk imperl-alhek, ngkwengel-ayeng alhetjeh-anngerntel.” ");
INSERT INTO amx_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesu-el renh ilek, “Nhenh iterl-aray, tjerrtj inarl mer inehenh kakey apek angkwerek apek tjeyekw apek mwek angey apek kwer map apek peltj map apek imperl-alhemeng, tjeng rrkwapetjeh, angketj Altjerr-henh kaltj-antherl-apetjeh, ");
INSERT INTO amx_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","inenh Altjerrel angerr anthwerr kwart-wetjenh, inang ahelh nhenhel-antey anemarleng. Altjerrel inenh mer arrpenh kakey arrpenh angkwerek arrpenh tjeyekw arrpenh mwek arrpenh kwer map arrpenh anthetjenh. Ahelh nhenhel arrpenh mapel inenh alwernetjenh rwekenth-kenth-iletjenh. Kelant Altjerr-henh merel inang kwetant iteth anetjenh. ");
INSERT INTO amx_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Tjerrtj ngwenh apek twernk anem ahelh nhenhel, mer alkerel Altjerrel renh rrkwapenh-apenh war arrernetjenh. Rang itja weth twernk anetjenh. Tjerrtj ngwenh apek lyet kwek war anemeng, mer alkerel Altjerrel renh twernk arrernetjenh.” ");
INSERT INTO amx_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesu rang arrwekel alhetjam Jerusalem-warn. Kwertengerl kwerenh map pal-pal ingkern alhek. Ineheng ingkern tjerrtj arrpenh map alhep-alhek. Inang ater-irrek, nthakenh apek irretjenharl Jerusalem kwerel. Jesu-el kwertengerl 12 inenh ntangkemel ilek, nthakenh kelant anetjenharl. ");
INSERT INTO amx_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Rang lakenh inenh ilek, “Nwern-artek nhenh Jerusalem-warn alhem. Jerusalem kwerel-antem artwang nyentel Tjerrtj-henh Ler renh twernk priest map-warn Moses-henh mpwareng-areng kaltj-anthenh-anthenh map-warn anthetjenh. Inang renh urrarn-arteh pawenhetjenh. Kwereng inang renh tjerrtj lwereny mapeh anthetjenh. ");
INSERT INTO amx_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Tjerrtj lwereny inang renh arrampewetjenh, kwer pelh-wetjenh, renh whip-el atwetjenh, renh irrernng atwetjenh. Kweny atherr-penh arrwetj intemarl-penh, rang weth iteth kemerretjenh.” Lakenh Jesu-el inenh ilek. ");
INSERT INTO amx_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Kwer-penh akenheng-atherr Zebedee-henh ler atherr James John ratherr Jesu-warn petjek. Ratherr renh pawenhek, “Kaltj-anthenh-anthenhay! Ilern ngwenh angketj nyenteh pawenhetjenh. Ilern ahentj, ntwang ilerneh kel awetjeh.” ");
INSERT INTO amx_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesu-el renh-atherrenh pawenhek, “Wenham mpwel ahentj-irrem?” ");
INSERT INTO amx_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ratherr renh ilek, “Nwern alkerelemeh anemeng, ilern ahentj-irrem, ntwang ilernenh itepelant atherr arrernetjeh, ilern twernk tjerrtj mapeh anetjeh ntwarteh.” ");
INSERT INTO amx_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesu-el renh-atherrenh ilek, “Mpwel-artek marnterlpel war angkek! Mpwel apek tjengel-ayeng irlkert angerr inetjenh? Itjeng alherray! Mpwel apek tjengel-ayeng ilwemeram, tjengarl ilwetjeh anem-arteh? Itjeng alherray!” ");
INSERT INTO amx_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ratherr angkek, “Yang, kelam ilern ngkwengel-ayel irlkert angerr inetjenh!” Jesu-el renh-atherrenh ilek, “Mpwelemeh arratj irlkert angerr inetjenh yeng-arteh. Mpwel ilwetjenh, yengarl ilwetjenh-arteh. ");
INSERT INTO amx_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tjerrtj ngwenham tjengeng itep atherrel anetjenh? Thang itja renh-atherrenh urraretjenh. Altjerrelant kel tjerrtj renh-atherrenh urraretjenh.” ");
INSERT INTO amx_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Kwertengerl 10 arrpenhel James John kwer-atherr-henh angketj-penh awerrerrek, inang kwer-atherr arnkely-irrek. ");
INSERT INTO amx_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jesu-el kwertengerl inenh arraw-ilemel ilek, “Arrantherr kel kaltj, tjerrtj lwereny mapek twernk angerr rang kweteth tjwenelherl-apem, rang kweteth tjerrtj kwerenh map twernerl-apem, kwer awelhetjeh, kwer kangkwerretjeh, kwer angerr rrkwapetjeh. ");
INSERT INTO amx_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Arrantherr itja lakenh-arteh anetjeh. Tjerrtj ngwenh apek tjengenh mapeh twernk anetjeh ahentj-anem, rang itja nakelhetjeh, rang kel tjerrtj mapeh nyerrkentj mernelhetjeh, tangetjel anetjeh, arntarnt-aretjeh. ");
INSERT INTO amx_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Tjerrtj ngwenh apek tjerrtj tjengenh mapeh twernk angerr anthwerr anetjeh ahentj-anem, rang kel arrpenh map ingkerrek arntarnt-aretjeh, ineh rrkwapemel tangetjel anetjeh. ");
INSERT INTO amx_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Wenheng Tjerrtj-henh Ler rang ahelh nhenh-warn petjek? Rang key petjek, tjerrtj lwereny-henh twernk nheng-arteh anetjeh? Itja kwenh! Tjerrtj-henh Ler petjek, tjerrtj map arntarnt-aretjeh, ineh tangetjel anetjeh. Itja inang renh arntarnt-aretjeh, itja kwer tangetjel anetjeh. Rang petjek, tjerrtj mapeh tjang-ilwetjeh, inenh anetjeng iteth-iletjeh, inang kwerel-ayeng iteth kwetant anetjenheng.” Lakenh Jesu-el kwertengerl inenh kaltj-anthek. ");
INSERT INTO amx_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Kwer-penh Jesu kwertengerl kwerenh map-akert Jericho town-angkwerr anper-alhek. Tjerrtj angerr ineheng ingkern-angkwerr alhek. Artwang pweng nyent tjeyeng iterel anerl-anek, arreny kwerenh Bartimaeus. Rang merneh ankey nketjam. ");
INSERT INTO amx_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Rang awek Jesu Nazareth-areny anper alherleh, rang renh arlkemel pawenhek, “Jesu-ay! David-henh peltjay! Tjeng ltarrp-irray! Mantj-mantj-irray!” ");
INSERT INTO amx_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Mapel renh ilek, “Intert-irray! Arlketjal anay!” Rang ineh itja kangkwerrek. Rang arnterr kwet arlkemel ilek, “Jesu-ay! David-henh peltjay! Tjeng ltarrp-irray! Mantj-mantj-irray!” ");
INSERT INTO amx_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesu irnetj-alhemel ineh angkek, “Renh ntangkay!” Inang artwang pweng kwer ntangkemel angkek, “Kel arrken anay! Kemerray! Rang ngwenh ntangkemeng!” ");
INSERT INTO amx_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Rang mantarr kern-penh war rlwek, rang parrp kemerrerl-alhek, Jesu-warn petjek. ");
INSERT INTO amx_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesu-el renh pawenhek, “Wenh kweram ntwang tjeng arlketjam?” Artwang pweng rang angkek, “Twernkay! Anngang tjeyenh aretjeh mpwarang!” ");
INSERT INTO amx_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesu-el renh ilek, “Ntwang yengenh nakekarleng, thang anngang ngkwengenh aretjeh mpwarek. Kelemeh nthwerl-apang!” Artwang rang kel mwerram arek, rang Jesu-eng anharrel-ayeng alhek. ");
INSERT INTO amx_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jesu kwertengerl kwerenh map-akert alhek Jerusalem-warn-athek. Jerusalem-eng mer kwek atherr mpwepel anek, mer Bethphage mer Bethany, Olive pwert iterel. Jesu mer kwer-atherr irretj-alhemel rang kwertengerl atherr lanthek arrwekel, ");
INSERT INTO amx_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","renh-atherrenh ilemel, “Mer nhak-warn alherray! Merek irremel mpwel tangkey kwek irnerleh aretjenh, halter-akert arneh ayernekarl. Tangkey kwer tjerrtj itja arrwekel antjek. Rope renh rlwemel, tangkey renh inemel angetj-alperrang. ");
INSERT INTO amx_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mpwelenh apek arrpenhel pawenhemeng, ‘Wenheharl mpwel tangkey renh angem?’. Mpwel renh iletjeh, ‘Ngkart kwenh kwer ahentj. Rang renh parrp angkep lanthetj-alpetjenh ngkweng-warn.’ ” ");
INSERT INTO amx_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Kwertengerl ratherr alherrek, ratherr tangkey renh arek halter-el ayernekarl, arrewel kwet irnetjamarl. Ratherr rope renh rlwek. ");
INSERT INTO amx_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Tjerrtj rrpwetj irnerl-anek. Inang renh-atherrenh pawenhek, “Wenheh mpwel tangkey renh angem?” ");
INSERT INTO amx_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ratherr inenh ilek, Jesu-elarl renh-atherrenh ilekarl. Kel inang renh-atherrenh mentjemeh impek, tangkey renh mentj angetjeh. ");
INSERT INTO amx_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Kwertengerl ratherr tangkey kwek renh Jesu-warn angerl-anerrek. Ratherr antjam tangkey kwer artep-warn arrernerl-anerrek. Jesu rang tangkey kwer antjek, tjeyek irrek Jerusalem-warn. ");
INSERT INTO amx_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tjerrtj mapel mantarr inehenh tjeyek antjam-wek. Tjerrtj arrpenh map arrwekel kwet alhek, waly aketjeh. Waly-akert inang arrwekel tjwempelhek. Inang waly tjey Jesu rarl alhetjenh-angkwerr antjam-wek. ");
INSERT INTO amx_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Tjerrtj map Jesu-eng arrwekel alhek, tjerrtj arrpenh map kwereng ingkern-angkwerr alhek. Tjerrtj inang ingkerrek arlkerl-apetjam, “Nwern Altjerr renh nakem! Altjerray, urrpey ngkwengenh twer-ilang! Rang lyet nwerneh-warn petjem. ");
INSERT INTO amx_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Altjerray, renh twer-ilang, rarl arrwekeleny nwern-henh David-henh kethel king angerr anetjeh. Nwern Altjerr alker-areny renh nakem!” ");
INSERT INTO amx_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesu rang Jerusalem town-warn irrpek, kwereng church angerretj-warn rang alhek. Rang church angerretj renh tjwer-arerl-apetjam. Angwerr-angwerr wart, rang Bethany-warn angkep alpek kwertengerl 12 kwerenh map-akert. ");
INSERT INTO amx_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kweny-rtweh arrpenhel Jesu kwertengerl kwerenh map-akert mer Bethany-eng arratemel alhek. Rang tjeyek irremel angayel awelhek. ");
INSERT INTO amx_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Rang arnang tjwerrk ntwarreng arek, atherrk-atherrk mern-akerteh-athen. Jesu arnang tjwerrk kwer-warn alhek, merneh aretjeh. Rang itwek-irremel mern-kwenyam arek, mern tjwerrk mpank lyet-athek mangkemeng wart. ");
INSERT INTO amx_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jesu-el arnang tjwerrk renh ilek, “Lyeteng tjerrtjel itja weth ngkwengeng mern arlkwetjenh! Ntwang arnang antjerrk kwetam anetjenh!” Kwertengerl mapel renh awek, rang lakenh angkerleh. ");
INSERT INTO amx_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Inang Jerusalem-eh irretj-alhemel Jesu rang church angerretj-warn alhek. Church yard kethel artwang mapel mer kel mpwarekarl, inarl thep ntwerrert arnang arrpenh map-arlk sell-em-iletjam. Tjerrtj maney angart-wenh-wenh anerrerretjam. Jesu ingkerrekeh mwekenh-irrek, rang inenh alharlkwek, table inehenh-arlk ingkerrek arrarlp-wek. ");
INSERT INTO amx_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Rang tjerrtj inenh arnpakek, inang itja church angerretj-warn rnwanentj inehenh angetjetjeh. ");
INSERT INTO amx_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Rang inenh kaltj-anthek, “Angketj Altjerr-henh pipel-ayeng intem, ‘Church tjengenh tjerrtj ingkerrekeh anetjeh, mer nhenh kwer-warn inang petjem, tjeng-warn angkerrerretjeh, yeng nakewarremel.’ Arrantherr mer nhenh anyenng-henh mer-atwetjarl ulpert-ilemel mpwarek.” ");
INSERT INTO amx_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tjerrtj ingkerrek angketj kwerenheng anwerlkek. Inang ahentj-anek, renh awetjeh. Priest twernk mapel kaltj-anthenh-anthenh mapel thwen Jesu renh awek, rang lakenh angkerleh. Inang Jesu-eng ater-irrek, tjerrtj mapel renh nakekarleng wart. Inang ahentj-anek, renh irrernng atwetjeh. Lakenh inang tjel-angkerrek kwer, “Wenheharl tjerrtj nhenh mapel angketj kwerenh nakem? Nthakenham nwern Jesu renh irrernng atwetjenh? Tjerrtj map angketj kwerenheh kangkemeng wart!” ");
INSERT INTO amx_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kel angwerr-angwerr irrekemeh, Jesu kwertengerl kwerenh map-akert Jerusalem-eng arratemel alpek. ");
INSERT INTO amx_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kweny-rtweh inang weth tjey nhengel Jerusalem-warn alhep-alhek, kwertengerl mapel arek arnang tjwerrk nheng kel antjerrk-irrekarl. Artekerreng kern-atheh antjerrk-irrek ingkerrek kwet. ");
INSERT INTO amx_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Peter irlpangkemel Jesu-warn angkek, “Kaltj-anthenh-anthenhay! Arnang tjwerrk nheng ntwarl althwerrker-wek, rang kel antjerrkemeh!” ");
INSERT INTO amx_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesu-el inenh ilek, “Altjerr nakay! ");
INSERT INTO amx_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Nhenh iterl-aray, arrantherr apek irntang nhenh-warn nakentj-akertel war ilem, ‘Mer nhenheng anam-irray, kwatj alay-warn irrpang!’ Arrantherr lakenh nakentj angerr-akertel anem, Altjerrel arrehantherr lakenh mpwarem. Irntang rang kel kemerremel anam-irretjenh. ");
INSERT INTO amx_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Lakenheng arrantherr Altjerr pawenhemeng nakentj-akertel wenh-wenheh apek, kel Altjerrel arrantherrenh kel awemel mpwaretjenh. ");
INSERT INTO amx_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Ntwang Altjerr-warn angketjeh-anngernt, ntwang apek irlpangkem, tjerrtj arrpenhel ngwenh anetj-ilekarl. Kel arrwekel ntwang alhetjeh, tjerrtj kwer ilelhetjeh-amparr, ‘Nhenh yeng ngkweng-warn petjek, thang anetj ngkwengenh wetjeh. Ntwang apek yeng iterl-arehetjeng.’ Kwereng Altjerr Angeyel anetj arrehantherr-henh wetjenh.” ");
INSERT INTO amx_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jesu kwertengerl kwerenh map-akert Jerusalem-warn alhek. Jesu church angerretj iterel alhetjam, priest twernk map, angerrepat twernk map, Moses-henh mpwareng-areng kaltj-anthenh-anthenh map kwer-warn arnek-irrek. Inang renh pawenhek, ");
INSERT INTO amx_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“Ngwenhelam ngwenh lanthek, artwang map church angerreng alharlkwetjeh? Ntwang itja twernk angerr anem!” ");
INSERT INTO amx_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesu-el inenh ilek, “Thang arrantherrenh pawenhetjeh-amparr. Arrantherr yeng apek iletjenh, thang arrantherrenh iletjenh. ");
INSERT INTO amx_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Yengenh ilay, ngwenhelam John renh lanthek, tjerrtj map kwatjeh irrpelh-ilemel baptise-em-iletjeh? Altjerrel apek? Tjerrtjel apek?” ");
INSERT INTO amx_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Angketj nhenh-penh iterremel inarrp lakenh angkerrek, “Nwern apek renh ilemeng, ‘Altjerrel John lanthekarl’, rang nwernenh iletjenh, ‘Wenhengarl arrantherr John renh itja nakek?’ ");
INSERT INTO amx_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Nwern apek renh ilemeng, ‘Tjerrtjel renh lanthekarl’, tjerrtj map nwerneh arnkely-irrehetjeng.” Tjerrtj ingkerrekel nakek, John rang Altjerr-henh angketj angenh-angenh anekarl. ");
INSERT INTO amx_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Inang tjerrtj mapeng ater-irremel, lakenheng inang Jesu ilek, “Nwern itja kaltj.” Jesu-el inenh ilek, “Lakenheng thang arrantherrenh itja iletjenh, ngwenhel yengenh lanthek.” ");
INSERT INTO amx_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesu-el inenh angketj arrpenh ilek, “Artwang nyentel mern grapes farm ngkernek mer kwerenhek. Rang irntang map inemel, farm kwerenheh arrngert arrernek. Rang ipert angernek, tank ipert kwer-warn arrernek. Kelant tank kwerel rang mern grapes inenh ntjwerrketjenheng, arlkwerrng inetjenheng. Rang warl alkey artek, artwel kerneng mern grapes inenh arerl-anetjeh. Kwereng rang grapes farm renh artwang arrpenh mapeh imperl-alhek, inangrent-em-iletjeh. Farm-ek-artwey rang mer arrpenh-warn ntwarr alhek. ");
INSERT INTO amx_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Arrpenh-ingar mern grapes inang ampeng anek kwetjetjehemeh, farm-ek-artwey rang rrkwapenh-apenh nyent lanthek farm-warn, mern inetjeh. ");
INSERT INTO amx_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Rrkwapenh-apenh inang renh antwerrkemel atwek. Inang renh iltjant angkep lanthek. ");
INSERT INTO amx_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Farm-ek-artwey rang rrkwapenh-apenh arrpenh ineh-warn lanthek. Rrkwapenh-apenh nhenh renh inang arrampewemel kapert atwek. ");
INSERT INTO amx_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Kwereng merek-artwey rang rrkwapenh-apenh arrpenhemeh lanthek. Nhenh renh inang irrernng atwek. Kwereng rang rrkwapenh-apenh arrpenh map lanthek. Artwang inang rrkwapenh-apenh inenh ineheng arrpenh map atwek, arrpenh map inang irrernng atwek. ");
INSERT INTO amx_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Merek-artwey kwer rrkwapenh-apenh arrpenh itja anek lanthetjeh. Kel ler kwerenh-antem anek. Ler nhenh kwer rang angerr nyerrkek. Rang lakenh iterrek, ‘Thang ler tjeyenh lanthem, inang kwer kangkwerretjenharl.’ Kel rang ler kwerenh lanthek, mern grapes inetjeh. ");
INSERT INTO amx_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Artwang inang lakenharl angkerrek, ‘Nhenh kwenh ler kwerenh! Kelant grapes farm nhenh ler kwerenhehemeh anetjenharl. Mpa, nwern renh irrernng atweyay! Grapes farm nhenh nwernehemeh anetjeh!’ ");
INSERT INTO amx_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Inang ler renh antwerrkemel irrernng atwek, renh grapes farm-eng keth-warn angemel taly-wek.” Lakenh Jesu kwewaleny ilelhek, nthakenh irretjenharl. ");
INSERT INTO amx_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jesu-el inenh pawenhek, “Nthakenham arrantherr iterl-arem? Grapes farm-ek-artwey rang kwenh ineh ahang-irretjenh. Rang petjemel artwang inenh irrernng atwetjenh. Kwereng rang grapes farm renh arrpenh mapehemeh anthetjenh, kwer arntarnt-aretjeh. ");
INSERT INTO amx_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Arrantherr kel kaltj angketj nhenheh Altjerr-henh pip intemeng: ‘Pwert nheng warl artenh mapel mentj taly-wekarl, rang lyet pwert tjeperr anthwerr anem. ");
INSERT INTO amx_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ngkartel lakenh mpwarek, nwern anwerlkemelant arem.’ ” ");
INSERT INTO amx_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Twernk map kaltj anek, Jesu rang angketj nhenh ineh-penh ilerleh. Inang ahentj-anek, renh antwerrketjeh. Inang tjerrtj mapeng ater-irrek. Lakenheng inang renh imperl-alhemel kel alpekemeh. ");
INSERT INTO amx_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Twernk mapel artwang Pharisee rrpwetj Herod-henh rrkwapenh-apenh rrpwetj Jesu-warn lanthek, renh arrkernetjeh. ");
INSERT INTO amx_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Inang kwer-warn alhemel renh pawenhek, “Kaltj-anthenh-anthenhay, nwern kaltj, ntwang artwang arratj anthwerr anemeng. Tjerrtj arrpenh ahentj-irrem, tjerrtj maney mern map-akert war arntarnt-aretjeh, itja tjerrtj angayel map. Ntwang lakenh-kwenyarl, ntwang kenh lhewarl kwet mernelhem. Ntwang tjerrtj map kaltj-anthem, inang Altjerreng ularr arratj mernelhetjeh. Nwernenh ilay, arratj key, nwern king angerr Rome-areny Caesar tax maney anthetjeh? Itja apek?” ");
INSERT INTO amx_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Jesu rang kaltj anek, inang renh arrkernemel war pawenhemeng. Rang inenh pawenhek, “Wenhengam arrantherr yeng arrkernem? Tjeng maney ngkweltj nyent anthay, thang aretjeh.” ");
INSERT INTO amx_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Inang renh ngkweltj nyent anthek. Rang inenh pawenhek, “Ngwenh-henh inngerram nhenh anem?” Inang renh ilek, “Twernk Caesar-henh.” ");
INSERT INTO amx_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Jesu-el inenh ilek, “Arrantherr maney nhenh kel Caesar-eh renh angkep antherrerrang. Altjerrel arrantherrenh rnwanentj-arlk mern-arlk anthek, arntarnt-aretjeh. Arrantherr Altjerreh kangkwerrang! Altjerrel arrantherrenh anthekarl-arteh, arrantherr Altjerr kwer tjenkerr angkep antherrerrang, rarl ilekarl-arteh. Wenh Caesar-henh anem, Caesar-eh angkep antherrerrang. Wenh Altjerr-henh anem, Altjerreh angkep antherrerrang.” Inang angketj nhenh awemel anwerlkek. ");
INSERT INTO amx_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Artwang Sadducee map petjewarrek Jesu-warn, renh arrkernetjeh. Sadducee inartek iletjart, tjerrtj irrernngeng ywarn kemerretjenh. Inang Jesu renh pawenhek, ");
INSERT INTO amx_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Kaltj-anthenh-anthenhay, angketj Moses-kenh mpwareng-arengel-ayeng intem, ‘Artwang nyent apek kwer-kweny ilwem. Kwereng tjey kwerenhel inpert renh anewek inetjeh. Nheng kely kwerenh-henh kwer intetjenheng apek.’ Nhenh mpwareng-areng nwern-henh.” ");
INSERT INTO amx_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Inang Jesu renh angketj kwek ilek, “Arrpenh-ingar kenheng-nheng 7 anek. Kely angerr-ilek-amparr anew inek. Rang kwer-kweny kwet ilwek. ");
INSERT INTO amx_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Lakenheng tjey arrpenhel inpert renh anew inek. Rang kwer-kweny kwet ilwek. ");
INSERT INTO amx_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Lakenh kenheng-nheng 7-el marl renh anew anyenek. Ingkerrek inang kwer-kweny kwet ilwek. Ingkern marl rang ilwek. ");
INSERT INTO amx_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kelant Altjerrel tjerrtj ingkerrek irrernngeng kwel kemelh-ilemeng, ngwenh-henh anewemeh marl rang anetjenh? Kenheng-nheng 7-el kwenh marl renh anew anyenekarl. Nwernenh ilay!” ");
INSERT INTO amx_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesu-el inenh ilek, “Arrantherr-artek kely-kely kwet pawenhem! Arrantherr kwenh Altjerr-henh angketjeh kwen. Arrantherr angwerrek, Altjerr twer anthwerr anemeng. ");
INSERT INTO amx_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Kelant Altjerrel tjerrtj irrernng map kemelh-iletjenh, inang itja anewart anetjenh. Inang kel angel alker-areny map-arteh anetjenh, itja anewart. ");
INSERT INTO amx_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Altjerrel kwenh tjerrtj irrernng map kemelh-iletjenh. Arrantherr itja kwey Moses-henh pipeh read-irrek? Nthakenham Altjerr Moses-eh ilelhek, arnang nheng alngenthel ampemarleng? Rang kwenh renh ilek, ‘Yeng Abraham-henh Isaac-henh Jacob-henh Altjerr anem.’ ");
INSERT INTO amx_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Nheng Altjerr lakenh angkek, ‘Yeng Abraham-henh Isaac-henh Jacob-henh Altjerr ineh anem’, inang kwenh iteth kwerel-ayeng anem, inang awenngel apek irrernng intemeng. Artwang Sadducee mapay! Arrantherr-artek palekalek kwet iterremel angkek!” Lakenh Jesu-el inenh ilek. ");
INSERT INTO amx_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jesu rang artwang Sadducee mapel-ayeng angkerremarleng, Moses-henh mpwareng-areng kaltj-anthenh-anthenh nyent Jesu-warn petjek. Rang awek, Jesu-el artwang Sadducee inenh arratj anthwerr ilemeng. Rang Jesu renh pawenhek, “Yengenh ilay! Altjerr-henh mpwareng-areng mapeng angketj angerr renh ilay!” ");
INSERT INTO amx_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesu-el renh ilek, “Altjerr-henh mpwareng-areng mapeng nhenh angketj tjeperr rang anem. ‘Tjerrtj Israel-henh peltj mapel yengenh awerrerrang! Altjerr nyent war anem, Ngkart nwern-henh. ");
INSERT INTO amx_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ntwang Ngkart Altjerr ngkwengenheh angerr anthwerr nyerrketjeh, iterleng-iterl awelhentj ngkwengenh ntjaperel kwerrern ngkwengenh ntjaperel. Ntwang kwer kwet iterretjeh. Ntwang renhant naketjeh. Ntwang kwerant kangkwerretjeh. Ntwang itja iterrentj atherr-akert anetjeh.’ Angketj nhenh ingkerrek nyent war anem. ");
INSERT INTO amx_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Angketj arrpenh nhenh angerr anem. ‘Ntwarl ngkwewaleny nyerrkem, lakenh-arteh ntwang tjerrtj arrpenh mapeh nyerrketjeh.’ Angketj nhenh atherr anem tjeperr anthwerr.” ");
INSERT INTO amx_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Artwang rang angkek, “Kaltj-anthenh-anthenhay! Ntwang nwernenh arratj kwet ilek. Altjerr nyent war anem. Rant Altjerr nwerneh anem. Altjerr arrpenh itja anem rarteh. ");
INSERT INTO amx_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Angketj nhenh nwerneh anem: ‘Ntwang Ngkart Altjerr ngkwengenheh angerr anthwerr nyerrketjeh, iterleng-iterl awelhentj ngkwengenh ntjaperel kwerrern ngkwengenh ntjaperel. Ntwang kwer kwet iterretjeh. Ntwang renhant naketjeh. Ntwang kwerant kangkwerretjeh. Ntwang itja iterrentj atherr-akert anetjeh.’ Angketj arrpenh nheng nwerneh anem, ‘Ntwarl ngkwewaleny nyerrkem, lakenh-arteh ntwang tjerrtj arrpenh mapeh nyerrketjeh.’ Angketj nhenh-atherreh kangkwerretjeh, ratherr kwenh tjeperr anthwerr anem. Priest mapel ker tjenkerr itemel anthetjart Ngkart Altjerreh, nwern-henh anetj wetjeh. Kel tjenkerr nhenh kwekarl anem, angketj nhenh-atherr kenh tjeperrarl anem.” ");
INSERT INTO amx_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesu-el awek, rang arratj kwet angkemeng. Rang renh ilek, “Ntwang kwenh kwek war Ngkarteh peltj-irretjeh anekarl!” Angketj nhenh awemel, tjerrtj arrpenh map inang itja weth ahentj-irrek, Jesu renh pawenhetjeh. ");
INSERT INTO amx_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesu-el tjerrtj map church Altjerr-henh angerretjel lakenh kaltj-anthek, “Moses-henh kaltj-anthenh-anthenh mapel ilem, ‘Altjerrel ngkwey ilekarl, Christ rang petjetjenh David-henh peltj mapeng nwerneh-warn.’ Yengenh ilay! Nthakenham rang David-henh peltj anem? ");
INSERT INTO amx_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","King David ngkwey lakenh angkek, ‘Altjerrel Ngkart tjengenh ilek, “Tjengel-ayeng-amparr kwet anang. Tjerrtj anetj map-amparr thang atwemel ngkwengeng arratj-iletjenh, ngkweng kangkwerretjenheng.”’ Kwerrern Alngaltarel David ilek, lakenh angketjeh. ");
INSERT INTO amx_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“David-el lakenh Christ renh Ngkart anewekarleng, nthakenham David-el Christ renh Ngkart anewek, Christ kwenh David-eng ingkern petjek?” Tjerrtj arwenth inang kangkek, Jesu-el inenh mwerr anthwerr kaltj-anthemeng. ");
INSERT INTO amx_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesu-el inenh ilek, “Arrantherr-artek Moses-henh mpwareng-areng kaltj-anthenh-anthenh mapeng arelhetjeh. Inartek kangkem, mantarr amparrkey-akert nthwerl-apetjeh. Inang ahentj-anem, tjerrtj mapel inenh kwel naketjeh, shop-warn alhemeng. Lakenh-lkweran anetjam! ");
INSERT INTO amx_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Inang church-warn kwen irrpemarleng, inang ahentj-anem arrwekel anetjeh, tjerrtj mapel nakemel inenh aretjeh kwel. Lakenh-lkweran anetjam! Arrpenh-ingar apek tjerrtj arrpenhel inenh tjenkerr arlkwetjeh ngwem, inang ahentj-anem twernk arrpenh mapeng pwert anetjeh, arrpenh mapel inenh naketjeh kwel. Lakenh-lkweran anetjam! ");
INSERT INTO amx_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Inang kweteth alherremel arlweker-areny mapeh warl raketjart, inpert inenh keth-warn alharlkwetjart mereng. Lakenh-lkweran anetjam! Inang Altjerr-warn kweteth tjarr arlpentj angketjart tjerrtj mapeng anngetherr. Lakenh inang tjwenelhem. Kaltj-anthenh-anthenh nhenh mapel-artek anetj mpwarem. Altjerrel kwenh inenh angerr anthwerr atwetjenh.” ");
INSERT INTO amx_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesu rang church angerretjel anetjam. Rang arek, tjerrtj mapel tjenkerr maney arrernemarleng tjenkerr-henh tjampeteh. Rang arek, artwang maney angerr-akert mapel tjenkerr angerr kwet arrernerleh. ");
INSERT INTO amx_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Kwereng rang arek, marl inpert nyentel ngkweltj kwek atherr arrernerleh. ");
INSERT INTO amx_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesu kwertengerl kwerenh mapeh ntangkelhek. Rang inenh ilek, “Nhenh iterl-arerrerray, inpert nhenhel tjenkerr aningk-lkwer arrernek. Tjerrtj arrpenh mapel tjenkerr kwek wararl arrernek. ");
INSERT INTO amx_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Tjerrtj maney angerr-akert mapel tjenkerr arrernekarl-penh, ineh kwenh maney angerr kwetarl intem. Maney inpert kwer itjarl intem, rang mern nyent payem-iletjeh apek. Inpert rang maney ingkerrekarl arrernek.” ");
INSERT INTO amx_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesu rang Altjerr-henh church angerr kwereng arratemel keth-warn alhek, kwertengerl kwerenh map-akert. Kwer-penh kwertengerl nyentel Jesu renh ilek, “Kaltj-anthenh-anthenhay! Church angerretj nhenh aray, mwerr anthwerr! Irntang angerretj map-penh artekarl!” ");
INSERT INTO amx_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesu-el renh ilek, “Arrantherr church angerretj nhenh arem? Tjerrtj atwenh-atwenh mapel warl inenh atakemel ngkweltj-iletjenh. Inang irntang inenh ankert-werrerretjenh, ingkerrek ahernel intetjenh.” ");
INSERT INTO amx_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kwer-penh Jesu rang kwertengerl kwerenh map-akert Olive pwert-warn antjek, pwert kwerelemeh inang arrernelhetj-alpek church angerretj-warn-athek. Peter, James, John, Andrew inang Jesu kwer-warn itwek-irrek. Inang renh pawenhek, ");
INSERT INTO amx_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Nwernenh ilay! Ilwengaram lakenh irretjenh? Nthakenham nwern kaltj anetjenh, tjerrtj anetj inang petjetjeh irremeng? Warl inenh map ngkweltj-iletjeh.” ");
INSERT INTO amx_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesu-el inenh ilek, “Arrantherr-artek arelhetjeh, tjerrtj urrtjalthel arrantherrenh ilehetjeng. ");
INSERT INTO amx_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tjerrtj urrtjalth arrpenh map kwenh petjemel angketjenh, ‘Yeng kwenh Jesu Christ rang weth petj-alpek.’ Tjerrtj arwenth inang urrtjalth mapel-ayeng antelhetjenh. ");
INSERT INTO amx_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kelant arrantherr awemarleng, tjerrtj arrpenh map atwerremeng, tjerrtj arrpenh mapeh atwerretjeh irremeng, arrantherr itja ater-irretjeh. Nhenh kwenh kel lakenh anetjenharrp. Ahelh rang itjarl ywerretjenh, mpank-antey. ");
INSERT INTO amx_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Lakenh-amparr anetjenh. Mer-areny map mer ntwarr-areny arrpenh mapel-ayeng atwerretjenh. Lakenh-amparr anetjenh. Keth arrpenhel ahelh rang arrewetjenh. Lakenh-amparr anetjenh. Keth arrpenhel tjerrtj arrpenh map merneh angayel irremel ilwetjenh. Nhenh lakenh irremeng, arrantherr kaltj anetjeh, ingkern rwekenth-kenth angerr-lkwer petjetjenh. Nhenh lakenh irremeng, arrantherr kaltj anetjeh, Altjerr-henh angketj arratj-irretjenh. ");
INSERT INTO amx_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Arrantherr-artek arelhetjeh. Inang kwenh arrantherrenh rrkwemel court-warn angetjenh. Inang arrantherrenh church kwenel whip-el atwetjenh. Inang arrantherrenh twernk angerr mapeng ularr ngkernetjenh, arrantherr ilelhetjeh. Nhenh kel lakenh anetjenh, arrantherr inenh tjeng-penh iletjenheng. ");
INSERT INTO amx_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Arrantherr-artek angketj mwerr renh-amparr tjerrtj ingkerrek-warn ilerl-apetjeh mer mapel. ");
INSERT INTO amx_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Inang apek arrantherrenh rrkwemel court-warn angetjem, arrantherr apek iterrem, ‘Nthakenh yeng angketjeh?’. Arrantherr itja athek-irretjeh. Inang arrantherrenh pawenhemarleng, kel angketj nhengant angkay, Kwerrern Alngaltarel arrantherrenh iletjenharl. Rang kwenh arrantherrenh iletjenh, angketj arrantherrarl angketjenh. ");
INSERT INTO amx_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Artwangel tjey kwerenh anthetjenh, tjerrtj arrpenh mapel irrernng atwetjeh. Angeyel ler kwerenh anthetjenh, tjerrtj arrpenh mapel irrernng atwetjeh. Ler irrpelth-irrem angey matj kwer-artwey atherreh. Lerel angey matj kwerenh kwer-artwey atherr anthetjenh, tjerrtj anetj mapel inenh irrernng atwetjeh. ");
INSERT INTO amx_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Arrantherr yengenh nakemeng, tjerrtj ingkerrek arrehantherr ahentj-kweny-irretjenh. Itja tjengeng ntjwem-irretjeh, twerel arrantherr yengenh naketjeh. Arrantherr yengenh twerel nakemeng, Altjerrel arrantherrenh rrkwetjenharl, kwerel-ayeng kwet anetjenheng. ");
INSERT INTO amx_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Kelant arrantherr aretjenh altjerr rrtjwalth Altjerr-henh church angerretj kwenel irnemeng. (Tjerrtj rarl pip nhenheh read-irremeng, iterl-aretjeh!) Aremarl-penh tjerrtj Judea-areny map kel parrp irntang-warnant anam-irretjeh. ");
INSERT INTO amx_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Tjerrtj ngwenh apek warl kethel anemeng, rang kel anam-irretjehant, rang itja warl kwerenh-warn irrpetjeh, mantarr kwerenh inetjeh-amparr. ");
INSERT INTO amx_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Tjerrtj ngwenh apek kethel rrkwapemeng, rang kel anam-irretjehant. Rang itja warl kwerenh-warn alpetjeh, mantarr kwerenheh. ");
INSERT INTO amx_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Arrweketj mapeh rnpwer anthwerr anetjenh, kwer kwek-akert mapeh. ");
INSERT INTO amx_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Altjerr pawenhay, arrantherr itja lhwerrpel anam-irretjeh. ");
INSERT INTO amx_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Arltang kwerel tjerrtj map anthwerrel irlkert angerr inetjenh. Tjerrtjel itja arrwekel lakenh-arteh irlkert inek apek. ");
INSERT INTO amx_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Altjerrel tjerrtj kwerenh inenh arrwekel kwet urrarek, rarl inenh rrkwetjenh. Rang ahentj, ineh mantj-mantj mernelhetjenh, inenh anetjeng arntarnt-aretjeh. Lakenheng rang alhelek, rwekenth-kenth nhenh itja kwet anthwerr anetjeh, kwek war, tjerrtj ingkerrek ilwehetjeng, angerr irlkert inemel. ");
INSERT INTO amx_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Tjerrtjel arrantherrenh ilemeng, ‘Christ rang nhenheyay!’. Arrpenhel arrantherrenh ilemeng, ‘Alenheyay rang anem.’ Arrantherr angketj inehenh itja naketjeh. ");
INSERT INTO amx_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Urrtjalth Christ-artek map inang petjetjenh. Lakenh inang angketjenh, ‘Yeng Christ.’ Urrtjalth angketj angenh-angenh map inang petjetjenh. Lakenh inang angketjenh, ‘Yeng Altjerr-henh angketj angenh-angenh.’ Inang ngangkarel twer anthwerrel mpwaretjenh, arrtjelh-ilemel angketjenh, inang arrwekel kwet iletjenh, nthakenharl irretjenharl ngwenth. Inang Altjerr-henh peltj map rrtjwerremel ilerl-apetjenh, ineh antelhetjeh. ");
INSERT INTO amx_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Arrantherr-artek arelhetjeh! Thang arrantherrenh arrwekel war ilem, arrantherr kaltj anetjeh. ");
INSERT INTO amx_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Kwereng rwekenth-kenth nhenh-penh, ‘Altjerrel aherrk renh lwernetjenh anyentj thwen lwernetjenh, ");
INSERT INTO amx_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","rang kwerraly inenh angelh-angelh-iletjenh, inang alkereng anyetjenh.’ ");
INSERT INTO amx_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Kwereng tjerrtj ingkerrekel Tjerrtj-henh Ler renh aretjenh, rang ankertel-ayeng petjemeng. Rang twer anthwerr parrtj angerr-akert mernelhetjenh. ");
INSERT INTO amx_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Rang angel alker-areny kwerenh map inenh lanthetjenh, tjerrtj kwerenh map ahelh apanpeng arrawelh-iletjenh.” ");
INSERT INTO amx_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Arnang tjwerrk kwereng kaltj-irray! Arnang arntarlkw map aray! Arlpelh inang atherrk-atherrk arratemeng, arrantherr kel kaltj, ngwenth war twern-irretjenh. ");
INSERT INTO amx_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Lakenh-arteh arrantherr aremeng, angketj tjeyenh arratjemeh-irremeng, arrantherr kaltj anetjeh, Tjerrtj-henh Ler rang petj-alpetjeh irrem. ");
INSERT INTO amx_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Arrantherr nhenh iterl-arerray, angketj tjeyenh kel arratj anthwerr irretjenh, tjerrtj rrpwetj ahelh nhenhel iteth anemarleng-rlwer. ");
INSERT INTO amx_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Alker ahelh nhenh ywerretjenh, angketj tjeyenh itja kwet ywerretjenh, kwet anetjenh ngampekarl.” ");
INSERT INTO amx_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ilwengar anthwerr Tjerrtj-henh Ler rang petj-alpetjenh? Nhenheh tjerrtj nyent itja kaltj anem. Angel alker-areny inang itja kaltj. Ler rang itja kaltj. Angey nyent rant kaltj anem. ");
INSERT INTO amx_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Lakenh-hetj arrantherr arelhetjeh! Karr anetjeh! Arrantherr akwen wart, ilwengar anthwerr rang petj-alpetjenh. ");
INSERT INTO amx_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Lakenh-artek anem: mereh-artwey rang mer arrpenh-warn alhetjeh ahentj-anem. Rang ilerl-alhek mer arntarnt-arenh-arenh kwerenh map, inang arratj arntarnt-aretjeh. Rang warl arntarnt-arenh-arenh nyent twernk ngkernek, renh twernek, warl renh arratj karetjeh. Kwereng rang alhek. ");
INSERT INTO amx_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","“Lakenh-hetj arrantherr karr anetjeh. Arrantherr itja kaltj, ilwengar merek-artwey rang petj-alpetjenh. Rang angwerr-angwerr apek petj-alpehetjeng, kweny mpwepel apek, aherrk arratemeng apek. Tjwek-tjwek rrwey arlkemeng apek, aherrk irntarel apek. ");
INSERT INTO amx_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Arrantherr-artek karr anetjeh. Rang nheng petj-alpemeng, rang arrantherrenh ankwang intemeng aretj-alhehetjeng. ");
INSERT INTO amx_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Angketj tharl arrantherrenh ilem, thang kel tjerrtj ingkerrekeh ilem, ‘Karr anerrerrang!’ ” ");
INSERT INTO amx_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Arltang atherr tjenkerr Anper Alhekarleh arlkwetjenh-anngernt, irlpangkentj arreny Mern Ikelh thwen, priest twernk map Moses-henh mpwareng-areng kaltj-anthenh-anthenh map thwen angkerrek. Inang ahentj-anek, Jesu renh anyenng-anyenngel antwerrkemel irrernng atwetjeh. ");
INSERT INTO amx_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Tjerrtj map-artek inang Jesu-eh angerr kangkek, lakenheng inang angkerrek, “Tjerrtj mapel nwernenh ahang-irremel atwehetjeng, nwern renh itja Anper Alhekarl arltang kwerel antwerrketjeh. Arrwekek-amparr.” ");
INSERT INTO amx_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Bethany town-el artwang nyent anek, arreny kwerenh Simon. Simon rang leprosy tjwen-akert anekarl-penh, mwerr-antem anek. Jesu-el warl Simon-kenhel mern arlkwetjam, marl nyentam warl-warn irrpentjek, anter npwang mwerr anthwerr-akert angetjek tjampetel-ayeng. Anter npwang mwerr lakenh tjerrtjel maney angerr anthwerrelant payem-iletjart. Marl rang tjampet renh altjwer-ilemel, anter npwang mwerr anthwerr renh Jesu-henh kapert-arleh thelek. ");
INSERT INTO amx_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Tjerrtj rrpwetj arrpenhel nhenh aremel marl kwer arnkely-irrek. Inang angkerrek, “Wenhengarl rang anter npwang mwerr anthwerr pelkel war thelek? ");
INSERT INTO amx_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Anter nhenh nwernenh anthemer, nwern shop-warn angemer. Shop-arenyel nwern anthemer maney angerr anthwerr! Maney inenhemeh nwern tjerrtj angayel mapeh anthemer.” Inang marl renh iltek. ");
INSERT INTO amx_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jesu-el inenh ilek, “Marl yanh imperrerray! Wenhengarl arrantherr marl kwer arnkely-irrek? Rartek tjeng kangkentj angerr mernelhek! ");
INSERT INTO amx_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Tjerrtj angayel inang kwenh kweteth arrehantherrel-arleng anetjenh. Arrantherr ineh kangkentj mernelhetjeh ahentj-anem, arrantherr ineh mern apek mantarr-arlk anthetjeh. Yeng itja arrehantherrel-ayeng kwet anetjenh, yeng kwek war arrehantherrel-ayeng anem. ");
INSERT INTO amx_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Marl rang arratj tjeng mpwarek. Rartek kapert tjengenh-warn anter thelek, inarl tjengenh mpwerrk pernetjenh-arteh. ");
INSERT INTO amx_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Arrantherr iterl-arerrerrang, ahelh apanpel inang tjerrtj map angketj mwerr renh kaltj-anthetjenh, inang angketj marl nhenh-penh iletjenh, marl kwer irlpangkemel.” ");
INSERT INTO amx_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Kwereng Judas Iscariot, kwertengerl 12-eheng nyent, priest twernk map-warn alhek. Rang ahentj-anek, Jesu renh ineh anyenng-anyenng anthetjeh. ");
INSERT INTO amx_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Priest twernk inang angketj nhenh awemel kangkek. Inang Judas renh maney anthetjeh alhelek. Judas rang angerr iterrek, “Nthakenham thang Jesu renh ineh anthemer?” ");
INSERT INTO amx_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mern ikelhek irlpangkentjeh arltang arrwekeleny anek, inang tjenkerr yep-yep atwetjart, Anper Alhekarleh-amparr. Kwertengerl mapelemeh Jesu renh pawenhek, “Nthenhelam ntwang ahentj-anem, nwern mern ikelh renh nwerneh mpwaretjeh, nwern ingkerrekel arlkwetjenheng?” ");
INSERT INTO amx_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jesu-el kwertengerl atherr ilek, “Jerusalem-warn alherray! Town kwerel mpwel aretjenh, artwang nyent jar kwatj-akert ularr petjerleh. Mpwel kwereng ingkern-angkwerr alherrang. ");
INSERT INTO amx_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Artwang rang warl kwer-warnarl irrpenhetjenharl, mpwel ingkern-angkwerr irrpenherrang. Warlek-artwey kwer-warn lakenh angkerrang, ‘Kaltj-anthenh-anthenh ilern-henhel ngwenh lakenh pawenhem, “Nthenham room tjengenh, kwerel thang tjenkerr mern renh arlkwetjenh, kwertengerl tjengenh map-akertel?”’ ");
INSERT INTO amx_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Warlek-artwey rang mpwelenh mer arlpaw angerretj mernetjenh warl kerneny, room arlpaw nhenh rang kel mpwarekarl. Room arlpaw kwerelemeh mpwel mern tjenkerr nwerneh arrernerl-anerrang.” ");
INSERT INTO amx_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Kwertengerl ratherr Jerusalem kwer-warn irrpenhek. Jesu-henh angketj ingkerrek arratj-irrek. Ratherr Anper Alhekarl tjenkerr renh arrernerl-anerrek. ");
INSERT INTO amx_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kel angwerr-angwerremeh irrek. Jesu kwertengerl 12 kwerenh-akert warl kwer-warn alhek. ");
INSERT INTO amx_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Inang mern arlkwerl-anemeng, Jesu-el kwertengerl inenh ilek, “Awerrerrang. Arrehantherreng artwang nyent rang tjengel-ayeng mern arlkwem, rang yengenh twernk map-warn anthetjenh.” ");
INSERT INTO amx_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Kwertengerl angketj nhenh awemel inang ltarrp-irrek. Nyentam-nyentelemeh inang Jesu renh pawenhek, “Yengam artwang rang? Yengan artwang pelkenyarlam, yeng kaltj-kwenh! War kaltj-irrerl-apetjam ngkwengel-ayeng!” ");
INSERT INTO amx_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Rang inenh ilek, “Arrantherr 12 pel nhenhel anem, kenh artwang nyent anem, rang tjengel-ayeng rnwang nhenheng mern arlkwem, rang yengenh twernk mapeh anthetjenh. ");
INSERT INTO amx_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tjerrtj-henh Ler rang ilwetjeh, angketj Altjerr-henh pipel-ayeng intekarl-arteh. Artwang ngwenhel apek Tjerrtj-henh Ler renh twernk mapeh anthetjenh, kwer rwekenth-kenth angerr anthwerr anetjenh. Artwang rang kwetant ilwetjenh, rang anetj mernelhekarleng. Wenheh rang ngwerrm-irrek? Rang ngwerrm-irretj-kweny kwet anemer.” ");
INSERT INTO amx_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Inang mern arlkwemarleng, Jesu-el mern inek, Altjerr renh pawenhek. Kwereng rang mern renh ltwakemel, kwertengerl ineh anthek, lakenh angkemel, “Nhenh inerrerrang, arlkwerrerrang, nhenh mpwerrk tjengenh anemeng.” ");
INSERT INTO amx_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Rang paneken wine-akert inemel rang Altjerr-warn angkek wine antjwetjeh-anngernt. Rang paneken wine-akert renh anthek kwertengerl mapek, inang antjwetjeh. ");
INSERT INTO amx_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Rang inenh ilek, “Wine nhenh alhwang tjengenh anem. Alhwang tjengenh thelelhetjenh, tjerrtj aningk Altjerreh peltj-iletjeh. Nhenh rang alhelentj lyeteny anem. ");
INSERT INTO amx_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nhenh iterl-arerrerray, lyeteng thang itja weth ngkwarl wine ahelh nhenhel antjwetjenh. Kelant thang wine lyeteny antjwetjenh Altjerr-henh merel.” ");
INSERT INTO amx_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Kel inang nyent-areng alyelhek Altjerrek, kwereng inang arratemel alhek Olive pwert-warn. ");
INSERT INTO amx_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesu-el kwertengerl map inenh ilek, “Arrantherr ingkerrek tjengeng ampakelhetjenh. Angketj Altjerr-henh pipel-ayeng lakenh intem, ‘Thang arntarnt-arentj renh atwetjenh, kwereng yep-yep inang irrarnp-irretjenh.’ ");
INSERT INTO amx_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","“Altjerrel yeng kemelh-iletjenh, yeng arrehantherreng arrwekel alhetjenh mer Galilee-warn.” ");
INSERT INTO amx_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Peter rang angkek, “Inang apek ngkwengeng ampakelhetjenh, yeng itja kwetarl ngkwengeng ampakelhetjenh! Yeng ngkwengel-ayeng kwet anetjenh.” ");
INSERT INTO amx_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesu-el Peter renh ilek, “Yeng away, kwenyel lyet tjwek-tjwek rrwey rang atherr-areng arlketj-kwenyeng-antey, ntwang yeng rrpwetj-areng ywep-arrernetjenh.” ");
INSERT INTO amx_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Peter rang angkek, “Tjerrtj arrpenh map apek inang ngkweng ahentj-irremeng, ngwenh irrernng atwetjeh. Yeng-arlk inang irrernng atweyay! Yeng itja kwet ngkwengeng ampakelhetjenh.” Kwertengerl arrpenh mapemeh lakenh-arteh angkerrerrek. ");
INSERT INTO amx_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jesu kwertengerl kwerenh map-akert keth nheng-warn alhek, arreny kwerenh Gethsemane atherrk-warn. Jesu-el inenh ilek, “Nhenhel anerrerrang. Yeng Altjerr-warn angketjeh alhemarleng.” ");
INSERT INTO amx_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Kwereng Jesu-el Peter James John ngwek, ntwarr-kweny war inang alhek. Jesu rang ywarn iterremel, ltarrp angerr awelhek. ");
INSERT INTO amx_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Rang inenh ilek, “Yeng-artek ltarrp anthwerr awelhemel ilwetjeh-irrem. Nhenhel tjeng mpwelhewarray! Karr anerrerrang.” ");
INSERT INTO amx_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","36","Jesu rang kwek war ntwarr alhemel ulperr-welhek. Rang Altjerr pawenhek, “Angey tjengenhay! Ntwang key ahentj-anem, yeng irlkert angerr awelhemel ilwetjeh? Yeng itja ahentj-anem, lakenh ilwetjeh. Ntwang twer anthwerr anemeng, ntwang tjeng arrngert anay! Ntwang apek ahentj-anemeng, yeng irlkert angerr awelhemel ilwetjeh, yeng kel ngkweng kangkwerretjenh.” ");
INSERT INTO amx_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Kel Jesu kwertengerl ineh-warn petj-alpemel rang inenh ankwang intemeng aretj-alpek. Rang Peter renh pawenhek, “Simon-ay! Ntwam ankwang intem? Tjengel-ayeng karr anay! Ankwang intetjal! ");
INSERT INTO amx_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Arrantherr-artek karr anetjeh. Altjerr pawenhetjeh, arrentj rang arrantherrenh arrkernehetjeng. Kwerrern arrehantherr-henh Altjerreh kangkwerretjeh ahentj-anem. Alherrentj anetj rarl arrehantherrel-ayeng anemarl arrantherrenh lthwem.” ");
INSERT INTO amx_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jesu rang weth alhek Altjerr-warn angketjeh, renh pawenhetjeh. ");
INSERT INTO amx_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Kwereng kwertengerl ineh-warn petj-alpemel, rang aretj-alpek weth-antey inang ankwerrekarl. Kwertengerl inartek parrk anthwerr anek. Inang pal-pal irremel ywarn iterl-arek, renh iletjeh. ");
INSERT INTO amx_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Kel rrpwetj-areng Altjerr-warn angkemarl-penh petj-alpemel, rang inenh pawenhek, “Ay! Arrantherr ankwang kwetam intem! Keleyay! Inang kel petjemaw! Tjerrtj-henh Ler renh artwang anetj map-warn anthetjeh. ");
INSERT INTO amx_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Mpa! Kel kemerray! Artwang rarl yengenh artwang anetj map-warn anthetjenharl, rartek kel nhenh-warn petjem!” ");
INSERT INTO amx_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesu rang kwertengerl kwerenh map-warn angketjam-rlwer, Judas kwertengerl 12 ineheng nyent rang petjek tjerrtj atwenh-atwenh map-akert. Artwang atwenh-atwenh nhenh-artek priest twernk mapel Moses-henh mpwareng-areng kaltj-anthenh-anthenh mapel angerrepat twernk mapel Judas-el-ayeng lanthekarl, Jesu renh antwerrketjeh. Tjerrtj atwenh-atwenh inang Jesu-warn petjek knife alkey-akert anem-akert-arlk. ");
INSERT INTO amx_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas-el artwang atwenh-atwenh inenh arrwekel-antey ilekarl, “Artwang renharl thang arrwantjetjenh, renh antwerrkewarrang! Mantjel antwerrkemel anginewarrang.” ");
INSERT INTO amx_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kel Judas-emeh arratj kwet Jesu-warn alhemel angketj-alhek, “Kaltj-anthenh-anthenhay!” Kwer-penh rang renh arrwantjek. ");
INSERT INTO amx_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Artwang atwenh-atwenh mapel Jesu renh antwerrkek-anem. ");
INSERT INTO amx_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Artwang nyent rarl anek kwertengerl mapel-ayeng, rang knife alkeyel irlpang rlweth-atwek priest twernk-henh rrkwapenh-apenh nyent-henh. ");
INSERT INTO amx_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesu-el artwang atwenh-atwenh inenh ilek, “Artwang arwengkalth atwenh-atwenheh-arteh arrantherr knife alkey-akert anem-akert-arlk tjeng petjewarrek! ");
INSERT INTO amx_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Thang arrantherrenh arltang mapel church angerretjel kaltj-anthetjart. Wenhengarl arrantherr arrwekel yengenh antwerrketj-kweny? Lyetemeh arrantherr yengenh antwerrkek. Kel angketj Altjerr-henh pipel-ayeng tjeng-akert arratj anthwerr-irrek.” ");
INSERT INTO amx_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kwereng Jesu-henh kwertengerl inang ater irrarnp-irrek. ");
INSERT INTO amx_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Artwang anthetj nyent itjarl ater arrtjanek, Jesu-el-ayeng artwang atwenh-atwenh mapel-ayeng ingkern-angkwerr alhetjam. Inang renh aremel, kwer ingkernant antwerrkewarrek, mantarr kwerenhant antwerrkewarrek, ");
INSERT INTO amx_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","rang parrp arrtjanerl-alhek. ");
INSERT INTO amx_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Priest twernk map, angerrepat map, Moses-henh mpwareng-areng kaltj-anthenh-anthenh map priest twernk angerr-henh warlel arraw-irrek. Inenh Sanhedrin Council anewetjart. Artwang nheng map inarl Jesu renh antwerrkekarl, inang renh priest twernk angerr-warn-antem angek. ");
INSERT INTO amx_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Peter-el inenh ingkernengarl alwernerl-apetjam. Inang twernk priest angerr-henh warl-warn irrpenhek, kel Peter twernk priest angerr-henh yard-warnarl ingkerneng irrpenhek. Rang twernk priest angerr-henh rrkwapenh-apenh mapel-ayel arrernelhek, rwangel-ayeng ntjwetj-irretjeh. ");
INSERT INTO amx_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Priest twernk map Sanhedrin Council ingkerrek inang ahentj-anek Jesu renh irrernng atwetjeh. Inang artwang alngel arekarleh palenthwek, angketj Jesu-akert rrtjwerremel iletjeh. Ywarn kwet. ");
INSERT INTO amx_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tjerrtj mapel Jesu-eh rrtjwerremel ilek, angketj inehenh itja arratj anek. ");
INSERT INTO amx_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Kwereng rrpwetj arrpenh map kemerremel angkek, ");
INSERT INTO amx_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Nwern awek, rang lakenh angkemeng, ‘Jerusalem-el church angerr nheng tjerrtjel artekarl thang ltwaketjenh. Arltang rrpwetj-penh thang church arrpenh angkep artetjenh, artwel artetj-kweny.’ ” Lakenh inang rrtjwerremel angkek. ");
INSERT INTO amx_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Tjerrtj inehenh angketjeh Council inang ahentj-kwenyarl-anek, arratj-kweny wart. ");
INSERT INTO amx_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Priest twernk angerr rang kemerremel Jesu renh pawenhek, arrpenh mapeng anngetherr, “Ntwang itjarl ilelhem? Artwang nhenh mapel angketj ngkweng-akert ilemeng?” ");
INSERT INTO amx_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesu angketj-kweny kwet irnek. Priest twernk angerrelemeh renh weth pawenhek, “Ntwang key Christ rang anem? Altjerr mekelarey kwerenh Ler?” ");
INSERT INTO amx_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesu-el renh ilek, “Yeng kel anem. Arrantherr aretjenh Tjerrtj-henh Ler Altjerr twer anthwerrel-ayeng anemeng. Kelant arrantherr Tjerrtj-henh Ler renh arnaretjenh, ankertel-ayeng ahelh-warn petj-alperleh.” ");
INSERT INTO amx_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Priest twernk angerr rang nhenh awemel Jesu kwer mwekenh-irremel mantarr kwewaleny tjep-akek. Rang inenh ilek, “Wenhengam nwern artwang arrpenheh palenthwem, kwer-akert iletjeh? ");
INSERT INTO amx_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Arrantherr kel awek, rang Altjerr arrampewerleh! Nthakenham arrantherr iterrem?” Inang ingkerrek ahentj-irrek, renh irrernng atwetjeh. ");
INSERT INTO amx_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Arrpenh mapel Jesu kwer-arleh pelh-wek. Inang inngerr kwerenh arltwemel atwek. Inang renh pawenhek, “Ngwenhelam ngwenh atwek?” Priest twernk angerr-henh rrkwapenh-apenh mapel renh angemel atwerrerrek. ");
INSERT INTO amx_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Peter rang priest twernk angerr-henh yard-el anerl-anek. Priest twernk angerr-henh marl rrkwapenh-apenh nyentam petjek. ");
INSERT INTO amx_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Rang Peter arek rwangel-ayeng ntjwetj-irremeng. Marl rang renh arnterr arek, renh ilemel, “Ntwartek Jesu Nazareth-arenyel-ayeng anekarl!” ");
INSERT INTO amx_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Peter rang ywep-arrernelhek, “Yeng itjam kwer kaltj! Yeng itja kaltj ntwarl angkem-arleh!” Rang arrew-warn alhek. Tjwek-tjwek rrwey arlkek. ");
INSERT INTO amx_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Marl rrkwapenh-apenh rang Peter renh weth arek, rartek artwang mapel-ayel mpwepel irnetjam. Rang artwang inenh ilek, “Rang kwenh Jesu kwertengerl kwerenh mapel-ayeng anekarl!” ");
INSERT INTO amx_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Peter rang weth ywep-arrernelhek. Artwang arrpenh mapel Peter renh ilek, “Ntwartek arratj nakenh-nakenh Jesu-henh anem, ntwang Galilee-areny anemeng wart!” ");
INSERT INTO amx_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Peter-elemeh inenh ilek, “Altjerrel arem, yeng arratj anthwerr angkemeng. Yeng kwer akwenam, artwang kwer-penharl arrantherr angkem-arleh! Yeng apek rrtjwerremeng, Altjerrel kel yeng irrernng atwemer!” ");
INSERT INTO amx_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tjwek-tjwek rrwey rang weth arlkek. Peter irlpangkek, Jesu-el nheng renh ilekarl, “Tjwek-tjwek rrwey rang atherr-areng arlketj-kwenyeng, ntwang yengenh rrpwetj-areng ywep-arrernetjenh.” Peter rang arnek iterl-aremel. ");
INSERT INTO amx_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kel kweny-rtwehemeh aherrk arratekarleng-rlwer, Sanhedrin Council inang angkerrekarl-penh Jesu renh iltjang ayernemel twernk angerr-warnemeh angek. Twernk angerr kwerenh arreny Pilate. Pilate rang lwereny Rome-areny anek, twernk tjerrtj Jew map ingkerrekeh. ");
INSERT INTO amx_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilate-el Jesu renh pawenhek, “Arratjam ntwang tjerrtj Jew map-henh king rang?” Jesu-el renh ilek, “Ntwang arratj kwet angkek.” ");
INSERT INTO amx_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Priest twernk mapel Jesu-akert ilek, angkemel rang kwel anetj map mpwarekarl. ");
INSERT INTO amx_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilate-el renh weth pawenhek, “Ntwam inenh angketj-kwenyel awerl-anem? Inartek angketj map ngkweng-akert ilem!” ");
INSERT INTO amx_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesu rang angketj-kweny kwetarl irnek. Pilate-el renh aremel anwerlkek. ");
INSERT INTO amx_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Arltang Anper Alhekarlel, Pilate-el kweteth artwang nyent tjayeleng arratelh-iletjart, renh tjerrtj mapel urraretjart. ");
INSERT INTO amx_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Artwang nyent tjayelel anek, arreny kwerenh Barabbas. Rang artwang urrarn anek. Rang nheng artwang arrpenh mapel-ayeng government-ek irrpelth-irretjart. Barabbas inang tjayelel anek. ");
INSERT INTO amx_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tjerrtj map petjek Pilate-warn, renh irlpangkelh-ilek, rang artwang nyent tjayeleng arratelh-iletjeh. ");
INSERT INTO amx_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Pilate-artek kaltj anek, priest twernk map inang Jesu-eh ahentj-kweny anek. Lakenheng inang arrwekel Jesu renh kwer-warn lanthekarl. Pilate kaltj anek, Jesu-arl itja anetj mernelhekarleng. Lakenheng Pilate-el tjerrtj map pawenhek, “Arrantherr key ahentj-anem, thang tjerrtj Jew map-henh king renh rlwemel lanthetjeh?” ");
INSERT INTO amx_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Priest twernk mapel tjerrtj map twernek, inang Pilate iletjeh, rang Barabbas renh tjayeleng arratelh-iletjeh. Lakenheng tjerrtj inang arlkemel ilek, “Barabbas arratelh-ilay!” ");
INSERT INTO amx_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilate-el tjerrtj map weth pawenhek, “Jesu nhenh-artey? Renh arrantherr ilem, rarl tjerrtj Jew map-henh king anem. Thang renh nthakenham iletjenh?” ");
INSERT INTO amx_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tjerrtj inang arlkemel ilek, “Renh ntwerlkehant arlpar-arrernang!” ");
INSERT INTO amx_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilate rang inenh weth pawenhek, “Wenhengay? Rang itjam palekalek mernelhek apek!” Tjerrtj inang arnterram-arnterr arlkemel ilek, “Renh kel ntwerlkehant arlpar-arrernang!” ");
INSERT INTO amx_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilate rang ater-irrek, tjerrtj map kwer ahang-irrehetj. Lakenheng rang ineh kangkwerrek. Rang Barabbas renh tjayeleng arratelh-ilek. Rang atwenh-atwenh map kwerenh twernek, Jesu renh whip-el atwetjeh, ntwerlk-warn arlpar-arrernetjeh. ");
INSERT INTO amx_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Kwereng atwenh-atwenh mapel Jesu renh warl angerretj-warn kwen antwerrkemel angek. Inang atwenh-atwenh arrpenh map arrawelh-ilek. ");
INSERT INTO amx_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Kwereng inang Jesu renh mantarr athethekeh irrpelh-ilek, itja mantarr kwerenhek, mantarr arrpenhek. Inang inker lyek-penh-arlk mpwaremel kapert kwerenh-arleh arrernek. ");
INSERT INTO amx_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","19","Inang kwer-warn-atheh amperel-ayel arrernelhemel kwer anywerr-irremel ilek, “Yemay! Tjerrtj Jew map-henh king-ay!” Inang kapert kwerenh arnang tjetatjel atwetjam, kwer apelh-arlk wemel. ");
INSERT INTO amx_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Inang kel kwer anywerr-irrekarleng, inang mantarr athethek renh angkep akap-rlwemel mantarr kwerenh arlaltjehemeh angkep irrpelh-ilerrerrek. Kwereng inang renh keth-warnemeh angerrerrek, ntwerlkeh arlpar-arrernetjenharl. ");
INSERT INTO amx_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Inang artwang nyentam arek, anper alherleh. Inang kwer arlkek, renh twernemel, Jesu-eh ntwerlk angetjeh. Artwang nhenh kwerenh arreny anek Simon Cyrene-areny. Rang Alexander Rufus rrwey atherreh-artwey nywek anek. ");
INSERT INTO amx_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Atwenh-atwenh mapel Jesu renh mer Golgotha-warn antwerrkemel angek. Golgotha Anmatjerrel angart-wem kapert ngkwern. ");
INSERT INTO amx_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Mer kwerel inang renh wine antjwetjeh anthek, myrrh-akert. Rang itja ahentj-anek antjwetjeh. ");
INSERT INTO amx_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Inang Jesu renh ntwerlkeh arlpar-arrernemel iltjang atherr nail-el tanthek, ingkang atherr thwen. Kwereng inang mantarr kwerenh irrarnp-ilek gamble-irremel. ");
INSERT INTO amx_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Kel kweny-rtweh anek nine o'clock, nheng inang Jesu renh ntwerlkeh arlpar-arrernek. ");
INSERT INTO amx_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Inang angketj nhenh arrernek pip-arleh ntwerlk kernel, “Tjerrtj Jew map-henh king rang.” ");
INSERT INTO amx_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Inang artwang urrarn atherr-arlk ntwerlkeh arlpar-arrernek itepelant-atherr, Jesu mpwep-warn ilemel. ");
INSERT INTO amx_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Tjerrtj map anper-alhemel inang kapert lpelper-welhek. Inang Jesu renh arrampewemel iletjam, “Ntwang church angerr ltwaketjeh angkek! Renh arltang rrpwetj-penhel weth artetjeh? ");
INSERT INTO amx_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ngkwewaleny ntwerlkeng anarnpelherl-alhang!” ");
INSERT INTO amx_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Priest twernk mapel Moses-henh mpwareng-areng kaltj-anthenh-anthenh mapel inang renh arrampewemel angkek, “Rang kwel tjerrtj arrpenh map iteth-ilek, rang itjarl kwewaleny iteth-ilelhem! ");
INSERT INTO amx_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ntwang Christ rang anemeng apek, tjerrtj Israel-areny map-henh king, ntwang twer angerr-akert anemeng wart, kel ntwerlkeng anarnpay! Nwern lakenh aremel ngwenh naketjenheng!” Artwang urrarn nheng atherrarl inang Jesu-eng iter atherreh ntwerlkeh arlpar-arrernekarl, ratherr Jesu renh arrampewek. ");
INSERT INTO amx_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Arltang mpwepel alker rang ngwemernt-irrek, angwerr-angwerreh-atwetj. ");
INSERT INTO amx_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kel Jesu rang arlkemel ilelhek, “Eloi, Eloi, lama sabachthani.” Nhenh Anmatjerrel angart-wem, “Altjerr tjengenhay! Altjerr tjengenhay! Wenhengarl ntwang yengenh mentj impek!” ");
INSERT INTO amx_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Tjerrtj rrpwetj arrpenh inarl ntwerlkeng antarl irnetjam, inang Jesu renh arlkemeng awek. Inang angkerrek, “Rartek angketj angenh-angenh Elijah-eh ntangkelhek.” ");
INSERT INTO amx_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Artwang nyent wine-ek arrtjanek. Rang rnwanentj kwek wine anetj-anetj-warn arwek-arrernek. Kwereng rnwanentj kwek wine-akert renh rang arnang alkey-arleh arrernek. Rang arnang alkeyel rnwanentj-akertel Jesu-warn angek. Rang Jesu kwer mernek, Jesu-el antjwetjeh apek. Rang angkek, “Nwern karelheyay aretjeh. Elijah apek petjehetj, renh ntwerlkeng anarnpelh-iletjeh, itja apek.” ");
INSERT INTO amx_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jesu rang arnterr arlkerl-alhemel ilwerl-alhek. ");
INSERT INTO amx_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jesu rang ilwerl-alhek-arteh, mantarr alkey nheng rarl church angerr kwenel arlpar-anetjam, rang kerneng kweneh-atwetj alterrelhek. ");
INSERT INTO amx_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Atwenh-atwenh twernk nyent Jesu-warn-athek ularr irnek. Rang Jesu renh aremarleng, nthakenharl Jesu ilwern, rang angkek, “Arratj kwenh artwang nhenh Altjerr-henh Ler anek!” ");
INSERT INTO amx_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Angayekenh map inang renh ntwarreng aretjam. Angayekenh nyent anek Mary Magdalene, arrpenh anek Mary nheng Joses James kwek atherr-henh amekw. Marl arrpenh anek Salome. ");
INSERT INTO amx_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Angayekenh inartek Jesu-el-ayeng mer Galilee-el nthwerl-apetjart, renh arntarnt-aremel. Angayekenh inang Jesu-el-ayeng alhekarl mer Jerusalem-warn. ");
INSERT INTO amx_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Kel ntwely-ntwely-irrek Friday arltang kwerel. Friday arltel-artek tjerrtj Jew map lhewelhetjart-arlk mpwareng-areng inehenh alhengk-aremel, Saturday arltang angerr kwer-hetj. ");
INSERT INTO amx_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Joseph artwang mer Arimathea-areny rang kwenp alhek twernk Pilate-warn, Jesu-henh mpwerrkeh pawenhetjeh. Joseph rartek Sanhedrin Council anetjart, artwang irlpareth. Rang karelhetjam, Altjerr mernelhetjeh, rang tjerrtj ingkerrekeh Ngkart anemeng. ");
INSERT INTO amx_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Twernk Pilate rang anwerlkek, rang awekarleng, Jesu-arl parrp ilwek. Rang atwenh-atwenh twernk nhengeh ntangkelhek. Rang renh pawenhek, “Jesu key kelam ilwek?” ");
INSERT INTO amx_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Twernk rang renh ilek, “Yang, rang kelam ilwek.” Pilate-el Joseph renh ilek, rang kel Jesu-henh mpwerrkeh inetjeh. ");
INSERT INTO amx_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Joseph-el mantarr mperlker payem-ilek, kwereng Jesu-henh mpwerrk ntwerlkeng anarnpelh-ilek. Rang mantarr mperlker kwerel arltwemel, mpwerrk inteyeh kwernek. Intey nhenh-artek inang altjwer-ilemel mpwarekarl irntang-arleh. Kwereng rang intey arrew renh arltwek irntang angerrel. ");
INSERT INTO amx_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mary Magdalene Mary arrpenh nheng Joses-henh amekw ratherr arerl-anek, inarl Jesu-henh mpwerrk athenekarl. ");
INSERT INTO amx_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Saturday kwenyel Mary Magdalene, Mary arrpenh nheng James-kenh amekw, Salome inang anter npwang mwerr-akert payem-ilek, Jesu-henh mpwerrk pernetjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Kel Sunday kweny-rtweh aherrk arratekarl-rlwer, inang intey-warn alhek. ");
INSERT INTO amx_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Inang pawenherrek, “Ngwenhelam irntang angerr renh arreweng arnangelh-iletjenh?” Irntang nhenh angerretj anthwerr inarl martekarl. ");
INSERT INTO amx_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Inang arenhek irntang renh kel arnangelh-ilekarl. ");
INSERT INTO amx_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Inang intey kwer-warn irrpenhemel artwang anthetj nyent arek, mantarr mperlker-akert, arratjakw iterel anemeng. Inang anwerlkemel ater-irrek. ");
INSERT INTO amx_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Artwang anthetj rang inenh ilek, “Arrantherr itja anwerlketjeh! Arrantherr kwenh Jesu Nazareth-arenyeh palenthwem, nheng inarl ntwerlkeh arlpar-arrernekarl. Altjerrel renh irrernngeng kemelh-ilek. Rang itjemeh nhenhel intem. Keth nhenh arerrerray, inarl renh athenewarrekarl! ");
INSERT INTO amx_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Kwertengerl kwerenh map-warn Peter-warn-arlk alherrerrang! Inenh iletjeh, Jesu rang arrehantherreng arrwekel alhetjenh mer Galilee-warn. Mer kweremeh arrantherr renh aretjenh, rang nheng arrantherrenh ilekarl-arteh. Kel alherrerrang!” ");
INSERT INTO amx_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Intey kwereng angayekenh inang arraterl-alhemel, ater arrtjanek. Inang arrewerl-apek, ywarn iterl-arek. Inang ater-irrekarleng wart, inang angketj nheng Jesu arrwetjeng kemerrekarl itja tjerrtj nyent apek ilek. ");
INSERT INTO amx_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Sunday kweny-rtweh anthwerr irrernngeng kemerrekarl-penh Jesu Mary Magdalene-eh-amparr mernelhek. Mary nhenh kwereng-artek Jesu-el nheng arrentj 7 alharlkwekarl. ");
INSERT INTO amx_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mary rang arekarl-penh Jesu-henh peltj map iletj-alhek, inang ltarrp arrangketjam-warn. ");
INSERT INTO amx_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Rang inenh ilek, “Jesu tjeng mernelhekaw! Thang kwenh renh iteth arekarl!” Inang itja renh nakek. ");
INSERT INTO amx_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kel arrpenh-ingar nakenh-nakenh atherr Jerusalem-eng keth-warn alherrek, Jesu rang artwang kwer-atherr mernelhek. Ratherr Jesu renh arek mpwerrk lyeteny-akertemeh. ");
INSERT INTO amx_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ratherr kwertengerl arrpenh map-warn alherrek angketj-akert. Kwertengerl inang angketj kwer-atherr-henh itja nakek. ");
INSERT INTO amx_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kel arrpenh-ingar Jesu rang kwertengerl 11 inehemeh mernelhek, inang mern arlkwerl-anerleh. Rang inenh arrantjakek, inang angketj tjerrtj nheng map-henh itja nakekarleng, inarl Jesu arekarl-penh. ");
INSERT INTO amx_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kwereng Jesu-el inenh ilek, “Arrantherr ahelh nhenhel mer map-warn alhetjeh ahelh apanpel, tjerrtj ingkerrekeh angketj mwerr renh ilerl-apetjeh. ");
INSERT INTO amx_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Tjerrtj ngwenh apek inang angketj mwerr nhenh nakemeng, inenh arrantherr baptise-em-iletjeh kwatjeh irrpelh-ilemel, inenh Altjerrel inetjenh, kwerel-ayeng iteth ngampekarl anetj-alpetjenheng. Tjerrtj ngwenh apek inang angketj mwerr nhenh itja nakemeng, inenh Altjerrel alharlkwetjenh. ");
INSERT INTO amx_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Tjerrtj inang yengenh nakemeng, inang lakenh twer anthwerrel mpwaretjenh. Inang arreny tjengenhel arrentj map alharlkwetjenh. Tjerrtj inang angketj arrpenhek-arlk angketjenh. ");
INSERT INTO amx_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Amwang arrwengkelth-akert apek inang iltjel antwerrkemeng, inenh ywarn nhwetjenh. Arrwengkelth arrpenh inang antjwemeng, inang itja irlkert-irretjenh. Inang tjerrtj irlkert-akert mapeh iltjang arrernemel inenh mwerr-iletjenh.” ");
INSERT INTO amx_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kel Jesu-el ilekarl-penh, Altjerrel Jesu renh mer kwerenh-warn alker-warn angkep anginek. Jesu rang Altjerrel-ayeng arrernelhek, ratherr pwert kwet anem. ");
INSERT INTO amx_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nakenh-nakenh inang irrarnp-irremel mer map-warn alherrerrek, angketj mwerr renh ilerl-apetjeh. Inang twer anthwerrel mpwarerl-apek, Ngkart-henh Kwerrern rang inehel-ayeng anekarleng wart, inenh twer-ilekarleng. Arrpenh mapel inenh arek-penh kaltj anek, angketj inehenh arratj anthwerr anek. ");
INSERT INTO amx_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Yeng Luke anem. Peltj tjengenh Theophilus-ay, thang angketj nhenh ngkweng pip-warn arrernem. Arrwekel arrpenh mapel angketj inehenh pip-warn arrernek, angketj nheng Jesu-el mpwarekarl, rang nakenh-nakenh mapel-ayeng anekarl-rlwer. ");
INSERT INTO amx_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Arrwekeleny mapel-amparr ilek, inarl artwang Jesu renh arekarl-penh, rarl iteth anekarl ahelh nhenhel. Inang mer map-warn alhek, angketj Jesu-akert renh ilerl-apek, nwernenh-arlk kaltj-antherl-apek. ");
INSERT INTO amx_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Inang angketj tjeng Jesu-akert ilek. Yeng ineheng mantj kaltj-irrek, inenh angerr pawenhemel. Yeng iterrek-amparr, angketj Jesu-akert pip-warn arrernetjeh. Kel thang angketj nhenh pip-warn arrernek, ngkweng-warn lanthetjeh-anngernt. Angketj nhenh arratj anthwerr anem. ");
INSERT INTO amx_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ntwang apek kwek war kaltj anem. Thang angketj nhenh ngkweng-warn lanthem, kwereng ntwang kaltj anthwerr anetjenh, angketj nheng inarl ngwenh kaltj-anthek-arleh, rang angketj arratj anthwerr anem. ");
INSERT INTO amx_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","King Herod rang twernk anetjam-rlwer mer Judea-ek, ngkart priest nyent Judea kwerel anek, arreny kwerenh Zechariah. Rang Abijah-kenh peltj anek. Zechariah-kenh anew arreny Elizabeth anek. Elizabeth rang Aaron-kenh peltj anek. ");
INSERT INTO amx_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zechariah Elizabeth ratherr Altjerreng ularr arratj kwet mernelhetjart. Ratherr Ngkart-henh angketj ingkerrekeh arratj kwet kangkwerretjart. ");
INSERT INTO amx_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ratherr kwer-kweny kwet anek, Elizabeth rang arelh ampwangemeh anek, Zechariah rang artwang aywang anek. ");
INSERT INTO amx_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Ngkart priest mapeh angketj ineh anek, priest nyentam-nyent irrpetjeh Altjerr-henh church angerretj-warn, npwang mwerr-akert, altarkern-ampenyel ntheletjeh, intjernetjeh-anngernt. Nhenh Zechariah kwer rrkwapentj arrwekel urrarekarl. ");
INSERT INTO amx_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Zechariah rang church-warn kwen irrpenhek, rang npwang mwerr renh ntheletjeh. Tjerrtj arrpenh map inarl church-el arraw-irrekarl petjekarl, inang kethel kwet karelhetjam, Altjerr-warn angkemel. ");
INSERT INTO amx_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Altjerr-henh angel alker-areny Zechariah kwer mernelhek, arnang npwang mwerr-henh altar-eng ayerrerel angel rang irnetj-alhek. ");
INSERT INTO amx_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zechariah-el angel renh arek. Rang anwerlkemel angerr ater-irrek. ");
INSERT INTO amx_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Angel rang renh ilek, “Zechariah-ay, ater-irretj-kweny anay, thang angketj mwerr ngkweng iletjenheng! Altjerrel ngwenh awek, ntwang kwer-warn pawenhemel angkekarl. Anew ngkwengenh Elizabeth-emeh kwer-akert irretjenh. Kwer rrwey kwer ngwerrm-irretjenh. Ntwang renh arreny John anewetjeh. ");
INSERT INTO amx_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ntwang arrken anthwerr anetjenh, rang ngwerrm-irretjenhel. Tjerrtj arrpenh map arrken-antem anetjenh. ");
INSERT INTO amx_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Altjerreng ularr rang artwang tjeperr anthwerr anetjenh. Rang itja wine-arlk antjwetjenh. Ngwerrm-irrekarl-penh rang Kwerrern Alngaltar-akert kwet anetjenh. ");
INSERT INTO amx_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","17","Altjerr Angeyel twer kwer anthetjenh, rarl ngkwey angketj angenh-angenh Elijah-ek anthekarl-arteh. Altjerrel renh kwerrern kwerenh-akert tjerrtj Israel-areny map-warn lanthetjenh. Rang Ngkarteng arrwekel alhetjenh. Rang tjerrtj aningk twepelh-iletjenh Altjerr-warn. Rang tjerrtj inenh arratj-iletjenh, angey map kwer inehenh mapeh kangketjenheng. Rang tjerrtj kangkwerretj-kweny map alngampelh-iletjenh, inang Ngkarteh irlpareth kangkwerretjeh, iterrentj arratj-akert. Lakenh kwer ngkwengenh rang tjerrtj map arratj-iletjenh. Inang Ngkarteh karelhetjenh, rang ahelh-warn petjemeng.” Lakenh angelel Zechariah renh ilek. ");
INSERT INTO amx_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zechariah-elemeh angel renh pawenhek, “Yeng artwang aywang anem. Anew tjengenh rang arelh ampwang anem. Nthakenhameh ilern kwer anyenetjenh?” ");
INSERT INTO amx_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Angelel renh tjernek, “Yeng kwenh Gabriel anem. Yeng-artek Altjerrel-ayeng kwet irnem. Altjerr rarrp yengenh ngkweng-warn lanthek, ngwenh angketj mwerr nhenh iletjeh. ");
INSERT INTO amx_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Angketj nhenh arratj anthwerr. Ntwang angketj tjengenh itja nakekarleng, ntwang angketj-kweny kwet anetjenh, kwer rang ngwerrm-irretjeh-atwetj.” ");
INSERT INTO amx_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Tjerrtj map inang kethel karelhetjam Zechariah kwer. Zechariah rang kwen kwet anek arratetj-kweny, lakenheng inang iterrerl-anek, “Nthakenh rang kwet irretjam?” ");
INSERT INTO amx_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kwereng Zechariah rang church-eng arratek, rang angketj-kwenh kwet anek. Tjerrtj mapel alhengk-arek, rang anengkerr arekarl. Zechariah rang ineh iltjem-iltjemeh angkek. ");
INSERT INTO amx_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Arltang arrpenhel Zechariah rang church-el rrkwapentj mpwarekarl-penh, rang mer kwerenh-warn alpek, mer Judea pwert-pwert-angkwerr-warn. ");
INSERT INTO amx_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kel arrpenhelemeh anew kwerenh Elizabeth anertemeh nthwerl-apek. Elizabeth rang anyentj 5-el warl kwenel alengk-welhek. ");
INSERT INTO amx_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Rarrp angkek, “Arratj-athew Altjerr rang tjeng mantj-mantj mernelhek. Lyeteng tjerrtj arrpenh mapel yengenh itjemeh weth arrkentj-iletjenh.” ");
INSERT INTO amx_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Kel Elizabeth rang 6 months-emeh anert-anert anemarleng, Altjerrel angel Gabriel-emeh mer Nazareth-warn lanthek. Nazareth rartek town kwek anek, mer Galilee-el. ");
INSERT INTO amx_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Altjerrel Gabriel lanthek angketj mwerr-akert marl awenk nyent-warn, arreny kwerenh anek Mary. Mary rartek Joseph-eh alhelentj anek. Mpank ratherr inerrentj-kweny anek. Joseph rang King David-henh peltj anek. ");
INSERT INTO amx_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Angel rang Mary-warn petjek. Rang renh ilek, “Arrken-irremel anang! Ngkart ngkweng kangkem. Rang ngkwengel-ayeng lyet anem!” ");
INSERT INTO amx_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mary rang angketj awemel ywarn iterrek. “Wenhekam angel tjeng angkek?” ");
INSERT INTO amx_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Angel rang kwer weth angkek, “Mary-ay, ntwang itja ater-irretjeh! Altjerr rang ngkweng angerr nyerrkem. ");
INSERT INTO amx_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Kwer rrwey kwek ngkweng ngwerrm-irretjenh. Ntwangemeh renh arreny Jesu arrernetjek. ");
INSERT INTO amx_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Rang Altjerreng ularr tjeperr anthwerr anetjenh. Rang Altjerr angerr-henh Ler anetjenh, tjerrtjel renh alhengk-aretjenh. Ngkart Altjerrel renh ngkernetjenh, king angerr anetjeh, arrwekeleny kwerenh David-arteh twernk anetjenh. ");
INSERT INTO amx_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Rang Jacob-kenh peltj mapeh twernk kwet anetjenh, rarrp kweteth Ngkart angerr anetjenh.” ");
INSERT INTO amx_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mary-emeh angel kwer ilelhek, “Yeng-artek artwangeh akwen. Nthakenham kwer tjeng ngwerrm-irretjenh?” ");
INSERT INTO amx_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Angel rang renh ilek, “Altjerr Angey rang twer anthwerr anem. Altjerr rang ngkweng mernelhetjenh. Kwerrern Alngaltar rang ngkweng-warn irrpetjenh. Lakenheng kwer ngkwengenh mwerr anthwerr anetjenh. Tjerrtj mapel iletjenh, kwer rang Altjerr-henh Ler anetjenh. ");
INSERT INTO amx_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ntwang peltj ngkwengenh Elizabeth iterl-arem key, arelh ampwang nheng? Tjerrtj ingkerrekel iletjart, rang kwer-kwenh kwet anetjenharl. Lyetemeh rang kel 6 anyentj anertemeh anem, kwer-akert! ");
INSERT INTO amx_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Altjerr twer angerr-akert anem!” Lakenh angelel Mary renh ilek. ");
INSERT INTO amx_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mary rang angkek, “Yeng kweteth Ngkartek kangkwerrek. Angketj ngkwengenh kel arratj aney! Yeng Ngkartek karelhetjeh, rang kwer tjeng anthetjenheh-anngernt.” Kel angel rang alpekemeh, renh imperl-alhemel. ");
INSERT INTO amx_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Arltang arrpenhelemeh Mary rang parrp athek-irremel alhek, Zechariah Elizabeth kwer-atherr-henh mer-warn. Zechariah ratherr mer Judea pwert-pwert-angkwerr anek. ");
INSERT INTO amx_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Mary-emeh Zechariah-henh warl irrpenhemel rang Elizabeth kwer angkek, “Altjelatjay!” ");
INSERT INTO amx_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elizabeth-henh anertel-ayel kwer angelherl-alhek. Kwerrern Alngaltar rang Elizabeth-warn irrpek. ");
INSERT INTO amx_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Elizabeth rang kangkemel angkek, “Mary-ay! Altjerr kwenh ngkweng angerr kangkek, marl arrpenh mapeng-ntjel. Rang kwer ngkwengenheh angerr kangketjenh. ");
INSERT INTO amx_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Yengemeh arrken angerr anem, Ngkart tjeyenh-henh matj tjeng-warn yatjarr petjekarleng! ");
INSERT INTO amx_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Thang ngwenh awek tjeng-warn angkerleh, kwer tjengenhemeh arrken awelhemel angelherl-alhek! ");
INSERT INTO amx_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ntwang arrken angerr anem! Altjerr rang ngkweng kangkem, ntwang Altjerr-henh angketj nakekarleng, angketj nheng angelel ngwenh ilekarl-penheh. Altjerrel ngwenh kweteth twer-iletjenh.” Lakenh Elizabeth Mary-ek angkek. ");
INSERT INTO amx_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","49","Mary rang angkek, “Altjerr kwenh tjeng kangkek, yeng anetj-anetj anerleh! Thang Ngkart renh kangkemel naketjenh, rang yeng anetjeng arntarnt-arek. Rang yengenh arntarnt-arem twer kwerenhel-arleng. Lyeteng tjerrtj aningkel lakenh iletjenh, ‘Mary-ay, Altjerrel kwenh mwerr anthwerr mpwarekarl ngkweng.’ Yeng arrken awelhem kwer, rang yengenh urrarek. Altjerr rang arratj anthwerr anem. Rang twer angerr-akert anem. ");
INSERT INTO amx_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Tjerrtj ngwenhel apek inang renh arratj iterl-aremeng, ineh rang kweteth mantj-mantj mernelhetjenh. ");
INSERT INTO amx_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Rang mernelhekarl, rang twer anemeng. Tjerrtj nakelhemarl map inenh rang kwereng anpwek. ");
INSERT INTO amx_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Rang twernk angerr map inenh kwen-ilek, tjerrtj anetj-anetj mapemeh rang inenh tjwenek, twernk anetjeh. ");
INSERT INTO amx_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Tjerrtj angayel map rang mern arlkwetjeh anthek. Tjerrtj maney angerr-akert map rang inenh iltjant lanthek. ");
INSERT INTO amx_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Ngkwey rang angerrepat Abraham Israel-areny map thwen alhelekarl-arteh, lakenh rang inenh mantj-mantj arntarnt-arentjekarl, inehenh peltj ingkern-penh map thwen. Rang kweteth nwernenh arntarnt-aretjart, nwernenh kangkentjel anyenetjart, angwerretj-kwenh. Rang kweteth nwernenh arntarnt-aretjenh.” Lakenh Mary rang kangkemel angkek. ");
INSERT INTO amx_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mary-emeh Elizabeth-el-arleng anyentj rrpwetjeh-atwetj kwet-irrek. Kwereng Mary mer kwerenh-warn angkep alpek. ");
INSERT INTO amx_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Kel arrpenhel Elizabeth-henh kwer rrwey rang ngwerrm-irrekemeh. ");
INSERT INTO amx_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Tjerrtj mer-areny mapel angketj awek, Elizabeth-henh peltj mapel thwen. Inang arrken angerr awelhek, Ngkart rang Elizabeth kwer ltarrp-irrekarl, renh kwer rrwey anthekarleng. ");
INSERT INTO amx_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Rrwey rang arltang 8 anekarleng, peltj map petjek Zechariah Elizabeth kwer-atherrel-ayeng anetjeh, inang kwer rrwey renh artwang-iletjeh-anngernt. Moses-henh mpwareng-areng-angkwerr kwer rrwey renh arltang 8-eng artwang mpwaretjeh-anngernt. Peltj inang ahentj-anek, kwer rrwey Zechariah anewetjeh, arreny angey kwerenh-arteh. ");
INSERT INTO amx_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Matj kwerenhelemeh inenh arnpakemel ilek, “Itja, renh arreny John anewetjeh.” ");
INSERT INTO amx_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Inang tjweker-irrek, renh arreny John anewetjeh. Inang angkek kwer, “Peltj ngkwengenh arrpenh itjemeh arreny alenh-akert anem.” ");
INSERT INTO amx_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Inang Zechariah renh iltjem-iltjemel pawenhek, “Arreny wenheham ntwang ahentj-irrem, ler ngkwengenh anewetjeh?” ");
INSERT INTO amx_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zechariah iltjem-iltjemel inenh ilek, inang kwer arnang anthetjeh, rang angketj mpwaretjenh lwerenh-akertel. Arnang kwer-warn rang mpwarek, “Rang anem arreny John.” Inang nhenh aremel inang anwerlkek. ");
INSERT INTO amx_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kwereng Zechariah-henh aleny mwerremeh angkerl-anek. Zechariah rang angkek, Altjerr renh nakemel. ");
INSERT INTO amx_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tjerrtj kwerel-ayel anekarl map inang angerr anwerlkek, kwer-penh inang angketj nhenh-penh ilerl-apek mer arrpenh mapel. Tjerrtj ingkerrek inarl pwert-pwert Judea-angkwerr anetjart angketj nhenh-penh inang angkerrek. ");
INSERT INTO amx_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Inang angketj nhenh-penh kwet iterretjam, inarrpemeh pawenherretjam, “Kwer nhenhemeh nthakenh irretjenh?” Inang alhengk-arek, Ngkartel renh karemeng. ");
INSERT INTO amx_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Kwerrern Alngaltar rang Zechariah-warn irrpek. Zechariah rang inenh Altjerr-henh angketj ilek, ");
INSERT INTO amx_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Nwern Ngkart renh kangkemel naketjeh, rang tjerrtj Israel-areny map-henh Altjerr anem. Rang nwerneh-warn tjerrtj arlaltj kwerenh map-warn tangetjel petjek, nwernenh anetjeng rrkwetjeh. ");
INSERT INTO amx_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Rang artwang Iteth-ilenh-ilenh nwerneh-warn lanthetjenharl, twer angerr-akert, nwernenh iteth-iletjenheng. Artwang nhenh rang David-henh peltj mapeng ingkern petjetjenharl. ");
INSERT INTO amx_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ngkweyeng-ntjel rang angketj angenh-angenh kwerenh mapel-arleng nwernenh alhelekarl wart, ");
INSERT INTO amx_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","rang nwernenh tjerrtj ngkwantj-irrenh-irrenh mapeng rrkwetjenh. ");
INSERT INTO amx_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Rang nheng angerrepat nwern-henh map alhelekarl, rang ineh ltarrp-irretjenharl. Lakenh rang ineh mernelhek. Rang nwerneh kweteth iterrerl-anem, rarl ngkwey alhelekarl wart. ");
INSERT INTO amx_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","Altjerr rang Abraham renh ilek, ‘Thang arrantherrenh tjerrtj mapeng arntarnt-aretjenh, inarl arrehantherr ngkwantj-irrem mapeng.’ Lakenh nwernemeh Altjerr kwereng ularr anew-anew arraw-irremel anetjenheng. Nwern arratj mernelhek, kwer kweteth iterremel anetjart.” Lakenh Zechariah rang Altjerreh nakemel angkek. ");
INSERT INTO amx_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Rang ler kwerenhek-antem angkek, “Ler tjengenhay! Arrpenh mapel ngwenh anewetjenh, ntwang Altjerr angerr-henh angketj angenh-angenh. Ntwangemeh Ngkart kwereng arrwekel alhetjenh, tjerrtj inenh iletj-alhetjenh, Ngkart rang lyet war nhenh-warn petjemeng, inang kwer karelhetjeh. ");
INSERT INTO amx_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ntwang tjerrtj kwerenh map kaltj-anthetjenh, Altjerrel anetj inehenh wetjenheng, kwer-penh rang inenh rrkwetjenh, kwerel-ayengemeh inang kweteth anetjenheng. ");
INSERT INTO amx_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Lyet nwern anetjel-ayel anem, ngwemerntel-arteh anem. Nwern akwen-antey anem, arratj mernelhetj-kwenh. Nwern ater-irrem ilwehetjeng. Altjerrel artwang Iteth-ilenh-ilenh renh nwerneh-warn lanthetjenharl, rang kangkentj anemeng wart. Aherrkel nwerneh tjey mernem. Lakenh-arteh artwang Iteth-ilenh-ilenh rang nwernenh parrtjelh-iletjenh. Rang nwernenh kaltj-anthetjenh, tjey mwerrel alhetjeh, nwern ularrek-ularr ngwerleny mernelhetjenheng, nwern ater-kwenh kwet anetjenheng.” Lakenh Zechariah-el ler kwerenh ilek. ");
INSERT INTO amx_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Kwer-penh ler kwerenh John rang angerr-irrek, kwerrern kwerenh arratj kwet twer-irrenhek. Rang rrkwalel kwet nyent-areny anetjart, rang arltang alenheh-atwetj mpwelhek. Arltang kwerel rang Israel-areny mapek angketj Altjerr-kenh ilerl-apetjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Rome-areny twernk angerr arreny Caesar Augustus rang ahentj-anek, tjerrtj ingkerrek count-em-iletjeh, mer kwerenh ntjaperel. Lakenheng rang tjerrtj ingkerrek lanthek, mer anganentj inehenh-warn alpetjek, inang arreny inehenh pip-arleh arrernetjeh mer anganentj inehenhel. ");
INSERT INTO amx_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Rome-areny mapel tjerrtj ingkerrek mer ntjaperel inang count-em-iletjam, Quirinius rang mer Syria-ek twernk anetjam-rlwer. Inang itja tjerrtj inenh arrwekel count-em-ilek apek. Lyetant inang lakenh mpwarek. ");
INSERT INTO amx_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kel tjerrtj ingkerrek inang angkep alpek mer anganentj inehenh-warn, government-el arreny inehenh pip-warn arrernetjeh, inenh count-em-iletjenheng. ");
INSERT INTO amx_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Joseph rang town Nazareth-el anetjart, mer Galilee-el. Joseph rang Nazareth-eng town kwek-warn Bethlehem-warn alhek. Bethlehem rang mer Judea-el-ayeng anek. Joseph rang Bethlehem-warn alhek, mer anganentj kwerenh-warn, iterl-aremel rang King David-henh peltj anekarleng wart. Ngkwey King David rek-amparr ngwerrm-irrekarl mer Bethlehem-el. ");
INSERT INTO amx_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Joseph rang marl alhelentj kwerenh-akert alhek, government-el arreny kwer-atherr-henh pip-warn arrernetjeh-anngernt. Mary rang anertemeh anek. ");
INSERT INTO amx_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Ratherr Bethlehem-el irretj-alhek. Tjerrtj aningk arraw-irrekarleng wart, warl intenh-intenhel room-kweny anek. Ratherr pwelek-henh mer aretj-alhek, mer kwerel ratherr interl-anerrek. Kwer-penh Mary rang awelhekemeh, kwer ngwerrm-irretjeh. Kel kwer rrwey rang ngwerrm-irrek mer kwerel. Mary rang kwer renh mantarrel arltwek, renh atherrk-henh panthel-ayel athenek. ");
INSERT INTO amx_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Bethlehem-eng ntwarr-kweny yep-yep arntarnt-arenh-arenh rrpwetj kethel anetjam, yep-yep map kwenyel arntarnt-aremel. ");
INSERT INTO amx_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ngkart-henh angel alker-areny nyentemeh ineh-warn parrtj-akert arratek. Ngkart-henh parrtjelemeh inenh keth-ilek. Yep-yep arntarnt-arenh-arenh inang ater-irrek. ");
INSERT INTO amx_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Angel rang atjernpelh-ilemel inenh ilek, “Arrantherr itja ater-irretjeh! Yeng-artek angketj mwerr-akert petjek. Tjerrtj ingkerrek arrken anetjenh! ");
INSERT INTO amx_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Lyet kwenh mer Bethlehem-el kwer kwek tjeperr anthwerr arrehantherr ngwerrm-irrek, David-henh town-el. Kwer rang Iteth-ilenh-ilenh arrehantherr-henh anetjenh. Rang Ngkart ingkerrekeh anetjenh. ");
INSERT INTO amx_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kel alherrerrang, arrantherr kwer kwek renh aretj-alhetjenh, rang yep-yep map-henh merel intemarleng. Rang interl-anem atherrk panthel mpwarekarl, mantarrel arltwekarl.” ");
INSERT INTO amx_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kwer-penh angel map alkereng petjek, angel nyent kwerel-ayeng inang irnetj-alhek. Inang Altjerreh kangkemel lakenh angkek, ");
INSERT INTO amx_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Altjerr rang parrtj anthwerr-akert anem! Ahelhel rang peltj mernelhem tjerrtj ineh, ineharl rang kangkemeng wart.” ");
INSERT INTO amx_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Angel inang kel alker-warn alpekemeh. Yep-yep arntarnt-arenh-arenh inang angkerrek, “Mpa! Nwern Bethlehem-warn alherrerrey, kwer kwek renh aretjeh, Ngkartel nwernenh ilekarleng wart.” ");
INSERT INTO amx_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Inang parrp anthwerr Bethlehem-warn alherrerrek. Inang Mary Joseph renh-atherrenh aretj-alhek, kwer kwek renh thwen, atherrk panthel-ayeng interl-anerleh. ");
INSERT INTO amx_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Inang Mary Joseph kwer-atherr angel-henh angketjemeh iletj-alhek. Ingkern inang arrpenh mapeh angketj nhenh ilerl-apek. ");
INSERT INTO amx_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Tjerrtj mapel angketj nhenh awekarleng, inang anwerlkek. ");
INSERT INTO amx_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mary rang angketj nhenheh kwet iterrerl-anek. ");
INSERT INTO amx_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Arntarnt-arenh-arenh mapel Altjerr nakemel arrken anthwerr inang alpek yep-yep inehenh-warn, lakenh angkemel, “Angketj rang kwenh arratj anthwerr anem! Nwern kel kwer kwek ngwerrm arek, angelel nwernenh ilekarl-penh wart! Nwern Altjerreh kangkemel alartetjeh!” ");
INSERT INTO amx_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kwer rrwey rang arltang 8-el anekarl, inang renh artwang-ilekemeh. Inang kwer renh anewek Jesu, angelel ngkwey Mary renh ilekarl arrwekel, awenkeh-amparr anekarl. ");
INSERT INTO amx_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","23","Kel angketj angerr intek Moses-henh mpwareng-arengel-ayeng, “Arrantherr kwer rrwey arrwekeleny map tjeng anthem kwenh, inang tjengenh irretjenh.” Kenh angketj arrpenh intek, “Kwer kwek intekarl-penh mwek kwerenh rang mer kwerenh kwenek anerl-anetjeh anyentj nyentek-atwetj. Kwereng rang church angerr-warn Jerusalem-warn alhetjenheng kwer kwek-akert.” Kel anyentj nyenteh-atwetj Joseph Mary ratherr merel antarl anetjam, Moses-kenh mpwareng-arengek kangkwerremel. Kwer-penh ratherr Jerusalem-warn alherrek. Ratherr Jesu renh-arlk angek, Ngkart-warn anthetjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Angketj arrpenh intek, “Angeyel mwekel thwen tjenkerr anthetjek Altjerrek. Ratherr Altjerr renh ntwerrert atherr apek pelker kwerrk atherr apek anthetjek.” Inang tjenkerr itemel Altjerrek anthetjart. Joseph Mary ratherr angketj nhenhek kangkwerremel tjenkerr anthek Altjerrek. ");
INSERT INTO amx_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Artwang arrpenh Jerusalem-el anek, arreny kwerenh Simeon. Rartek artwang arratj anek, Altjerrek kwet kangkwerremel. Rang karerl-anetjam, Altjerrel artwang Iteth-ilenh-ilenh Israel-areny map-warn lanthetjenheng, inang arrken anthwerr anetjenheng. Simeon rang Kwerrern Alngaltar-akert anek. ");
INSERT INTO amx_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Kwerrern Alngaltarel renh arrwekel-antey ilek, “Ntwang iteth anemarl-rlwer, ntwang kwenh Ngkart-henh Christ aretjenh, nheng rang lanthetjenharl.” ");
INSERT INTO amx_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Kwerrern Alngaltarel Simeon renh ilek, church angerr-warn irrpetjeh. Simeon kel church-el anetjam, Joseph Mary ratherr Jesu-akert church-warn irrpentjek. Ratherr petjek, tjenkerr anthetjeh Moses-kenh mpwareng-arengel ilemarl wart. ");
INSERT INTO amx_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeon-el kwer kwek renh aremel inek. Rang Altjerr renh kangkemel nakek lakenh angkemel, ");
INSERT INTO amx_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","31","“Ngkart angerray, ntwang yengenh alhelekarl-arteh, thang Christ renh ngwerrmemeh arekarleng, rang tjerrtj inenh ahelh ntjaperel iteth-iletjenharl. Yeng ngwerleny kwet awelhem. Ntwang renh mapeng anngetherr arrernek, ");
INSERT INTO amx_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","parrtj angerr anetjenh. Rang tjerrtj lwereny map alngampelh-ilemel parrtjelh-iletjenh. Tjerrtj ingkerrekel peltj ngkwengenh map Israel-areny map naketjenheng.” Lakenh Simeon rang Altjerr nakek. ");
INSERT INTO amx_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Joseph-el Mary thwenel lakenh awemel, ratherr anwerlkek. ");
INSERT INTO amx_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeon-el Altjerr tjang-pawenhek kwer-atherr, renh-atherrenh kwet twer-iletjeh. Rang Mary ilek, “Tjerrtj inang kwer ngkwengenheh ahentj-kweny irretjenharl, anetj-ilelhetjenharl. Tjerrtj ngwenh apek inarl kwer kangkentj anemarleng, inenh rang arntarnt-aretjenharl. ");
INSERT INTO amx_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Lakenh tjerrtj-henh iterrentj keth-irrem. Mary, kelant ntwang ltarrp angerr arnetjenh kwer ngkwengenheh.” Lakenh Simeon-el Mary ateng-ilemel ilek arrwekel-antey. ");
INSERT INTO amx_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Altjerr-henh angketj angenh-angenh arrpenh church angerr kwerel anek. Rang arelh ampwang anek, 84 years old. Arreny kwerenh Anna. Anna rang Phanuel-kenh ler marl anek. Phanuel rang Asher-kenh peltj anek. Ngkwey rang 7 years war anew-akert anekarl. Kwer-penh rang anew kwerenh parlp-ilek. Anna rang arelh inpert anek. Rang church angerretjel kweteth anetjart, rang Altjerreh kangkentj anetjart, kwer-warn angkerl-anemel. Arrpenh-ingar Anna-emeh rang mern arlkwetj-kweny anetjart, Altjerr-warn-anem angkemel. ");
INSERT INTO amx_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Anna rang Joseph kwer-atherr-warn angath-irrek. Rang kwer kwek aremel Altjerr renh kangkentjel nakek. Rang tjerrtj arrpenh map thwen inang artwang Iteth-ilenh-ilenh kwer mpank karelhek, rang Jerusalem-areny map anetj inehenheng iteth-iletjenheng. Rang inenh angketj mwerr ilek kwer kwek nhenh-akert. ");
INSERT INTO amx_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Joseph Mary ratherr Ngkart-henh mpwareng-areng ingkerrek mpwarekarl-penh, ratherr kwer kwek Jesu-akert Nazareth town-warn angkep alperrek, mer Galilee-warn. ");
INSERT INTO amx_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kel kwer rang twer-irremel mangkek. Kwer kwekeng-ntjel kwet rang inangkal mwerr-akert anek. Altjerrel renh mantj arntarnt-arek, rang kangkentj kwer wart anemeng. ");
INSERT INTO amx_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jesu-henh angey mwek thwen ratherr year nyentam-nyent alhetjart Jerusalem kwer-warn tjenkerr arlkwetjeh, mpwareng-areng inehenhel-ayel. Tjenkerr arreny kwerenh Anper Alhekarl anek. Inang irlpangketjart, ngkwey Altjerrel Israel-kenh map angek mer Egypt-eng. ");
INSERT INTO amx_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Jesu rang kel 12 years old anekarleng wart, kwer angerr-antem, Joseph Mary Jesu-akert alherrek Jerusalem-warn. ");
INSERT INTO amx_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Tjenkerr inang anyenekarl-penh ratherr angkep alperrek, peltj mapel-ayeng pwert kwet. Jesu rang antarl irrek map arrpenhel-ayel Jerusalem-el kwet. Ratherr iterl-aretj-kwenh anek, iterl-aremel Jesu rang peltj mapel-ayeng kwet nthwerl-apetjameh-athen. ");
INSERT INTO amx_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Jesu rang Jerusalem-elarl kwet-irremel anetjam. Ratherr tjeyel alhep-alhetjam-rlwer, ratherr kwenp kwet alherretjam kweny-rtweheng angwerr-angwerreh-atwetj. Angwerr-angwerr-anem ratherr Jesu-ek palenthwek, peltj map pawenhetjam, inang apek renh arekarleng. ");
INSERT INTO amx_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ratherr kwer ywarn palenthwek. Kel ratherr angkep alperrek Jerusalem-warn, kwer palenthwetjeh. ");
INSERT INTO amx_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Arltang atherr-penh ratherr renh aretj-alhek church angerretjel anerl-anerleh. Jesu rang kaltj-anthenh-anthenh mapel-arleng mpwepel anetjam, angketj awerl-anemel inang read-em-ilemeng. Rang inenh pawenhetjam. ");
INSERT INTO amx_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tjerrtj ingkerreny kwer anwerlkek, rang kaltj anthwerr anerleh. ");
INSERT INTO amx_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Joseph ratherr renh church-el aretj-alhemel, kaltj-anthenh-anthenh mapel-ayeng mpwepel anerl-anerleh, ratherr kwer anwerlkek. Mwek kwerenhelemeh renh pawenhek, “Kwer tjengenhay! Nthakenh irreperrem ntwang? Wenhengam ntwang ilernenh mentjel rtwarek? Ilern-artek ngkwengeng kwerrern-kweny-irrek, ngkweng palenthwemel irrek!” ");
INSERT INTO amx_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesu rang renh-atherrenh ilek, “Wenhekarl mpwelanth tjeng palenthwemel petjek? Mpwelanth kaltj anemer, yeng Angey tjengenh-kenh warlel wart anemeng!” ");
INSERT INTO amx_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ratherr angketj kwerenh itja alhengk-arek. ");
INSERT INTO amx_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Kel Jesu kwer-atherrel-arleng antelherl-alhek mer Nazareth-warn. Rang kwer-atherr kangkwerremel anetjart. Mwek kwerenh angketj kwer-penh kwet iterretjart. ");
INSERT INTO amx_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesu rang mangkek angerr, kaltj anthwerr-irrek. Altjerr tjerrtj map thwen kwer kangkek. ");
INSERT INTO amx_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Kel artwang Rome-areny Tiberias rang twernk angerr anetjart 15 years-ek-atwetj ahelh apanpel. Artwang Rome-areny arrpenh arreny Pontius Pilate rang mer Judea-ek twernk anek. King Herod rang mer Galilee-ek twernk anek. Tjey kwerenh Philip rang mer Iturea-ek Trachonitis-ek thwen twernk anek. Artwang Lysanias mer Abilene-ek twernk anek. ");
INSERT INTO amx_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Artwang Jew atherr Annas Caiaphas ratherr ngkart priest angerr anekarl-rlwer town Jerusalem-el, John nheng Zechariah-kenh ler rang mer rrkwalel anek. John rang nyent-areny mer rrkwalel anetjam-rlwer, Altjerremeh kwer-warn angkek. ");
INSERT INTO amx_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Kwereng John-el tjerrtj map kaltj-antherl-apetjart Jordan ulpay-angkwerr. Rang tjerrtj inenh ilek, “Altjerr-warn twep-irrerrerray! Tjeng-warn petjewarrang, thang arrantherrenh kwatjeh irrpelh-ilemel baptise-em-iletjeh, Altjerrel anetj arrehantherr-henh wetjenheng.” ");
INSERT INTO amx_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ngkwey Altjerr-henh angketj angenh-angenh arreny Isaiah rang angketj John-akert arrwekel kwet pip-warn arrernekarl, “Artwang nyentel mer rrkwalel arlkerl-anek, ‘Tjey arratj Ngkart kwer mpwarewarrang! ");
INSERT INTO amx_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ipert map takewarrang. Pwert alkey map inenh takewarrang. Tjey amper-amper inenh arratj-ilerrerrang. Tjey pwert-pwert inenh alyelk-ilerrerrang! ");
INSERT INTO amx_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kwereng tjerrtj ingkerrekel aretjenheng, Altjerrel tjerrtj kwerenh map angetjenharl, kwerel-ayeng kwetemeh anetjenheng.’ ” Angketj nhenh lakenh-akert John rang petjek. ");
INSERT INTO amx_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Tjerrtj aningkemeh John-warn petjewarrek, rang inenh kwatj-warn irrpelh-ilemel baptise-em-iletjeh. John rang tjerrtj inenh lakenh ilek, “Amwang-arteh mapay! Altjerr ahang-irrem arrehantherr, rang arrantherrenh atwetjenh! Arrantherr itja kwereng ater alwerretjeh! ");
INSERT INTO amx_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Arrantherr anetjeng twep-irretjeh-amparr, kwereng arrantherr arratjemeh mernelhetjeh, Altjerrel aretjenheng. Arrantherr lakenh angkem, ‘Nwern Abraham-kenh peltj map anem ngkweyeng-ntjel. Altjerrel Abraham arntarnt-arek, lakenh rang itja nwernenh anpwetjenh.’ Arrantherr lakenh anetj angkem! Altjerr rang apek ahentj-anemarleng, rang pwert nhenh mapeng Abraham-henh peltj arrpenh map mpwarehetj. ");
INSERT INTO amx_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Lyet Altjerr karelhem, anetj map rwang-warn wetjeh. Tjerrtj inang arnang mern antjerrk-akert-arteh anem. Nwern arnang nhenh kem, rwang-warn taly-wemel. Arrantherr arratj mernelhetjeh arnang mwerr-arteh, mern mwerr-akert. Arrantherr mernelhetjeh, arrantherr Altjerr-warn twep-irrekarl anetj arrehantherr-henheng.” Lakenh John-el inenh ilek. ");
INSERT INTO amx_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Tjerrtj inang John renh pawenhek, “Nthakenham nwern ularrek-ularr mernelhetjeh?” ");
INSERT INTO amx_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","John rang inenh ilek, “Tjerrtj ngwenh apek ineharl mantarr atherram intemeng, inang yatjarr anthetjeh tjerrtj mantarr-kwenh mapeh. Tjerrtj ngwenh apek inang mern anyenemeng, inang mern inehenh kert anthetjeh tjerrtj mern-kweny mapeh.” ");
INSERT INTO amx_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Artwang tax maney kwetjenh-tjenh map inang John kwer-warn petjewarrek, rang inenh kwatjel-ayeng baptise-em-iletjeh. Inang renh pawenhek, “Kaltj-anthenh-anthenhay! Nthakenham nwern mernelhetjenh?” ");
INSERT INTO amx_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","John rang inenh ilek, “Tax maney arratjant inetjeh, itja wetham inetjeh! Arrantherr itja rwengkel inetjeh!” ");
INSERT INTO amx_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Artwang atwenh-atwenh mapelemeh renh pawenhek, “Nwern-arteh? Nthakenham nwern arratj mernelhetjenh?” John rang inenh ilek, “Arrantherr itja arrawey mernemel tjerrtjeng maney-arlk raketjeh, itja tjerrtj ineh rrtjwerremel ilerrerretjeh, maney ineheng war inerrerretjenheng. Maney nheng twernk arrehantherr-henhel arrantherrenh anthekarl lwerenh-akert kwenp anetjeh. Arrantherr itja rwengkel maney inetjeh tjerrtj arrpenh mapeng.” ");
INSERT INTO amx_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tjerrtj map inang athek-irrek. Inang lakenh angkerretjam, “Artwang nhenham Christ rang, kwer nwern karelhetjam, nwernenh Altjerrel ngkwey alhelekarl?” ");
INSERT INTO amx_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","John rang ilelhek ineh, “Thang arrantherrenh kwatjel war baptise-em-ilem. Artwang arrpenh rang tjengeng ingkern petjetjenh, rarl tjengeng twer anthwerr anem. Yeng itja twer anem, yeng tjerrtj ahelh-areny war anem. Artwang rang arrantherrenh Kwerrern Alngaltarel-ayeng rwangel thwen baptise-em-iletjenh, anetj arrehantherr-henh rrpwaremel. ");
INSERT INTO amx_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Rang tjerrtj ingkerrek ngaketjenh, tjerrtjelarl mern anngang mwerr map mern anngang anetjeng ngakem-arteh. Rang tjerrtj mwerr map mer kwerenh-warn angetjenh. Tjerrtj anetj map rang rwang ngampekarl-warn taly-wetjenh.” ");
INSERT INTO amx_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Lakenh John-el tjerrtj map kaltj-anthetjart, angketj Altjerr-henh mwerr renh ilerl-apemel. ");
INSERT INTO amx_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Arrpenh-ingar John rang King Herod renh iltek, “Ntwang itja arratj mernelhek! Ntwang tjey ngkwengenh-henh anew Herodias rwengkel inek! Ntwang kweteth anetj mernelhentjek!” ");
INSERT INTO amx_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","King Herod John kwer ahang-irrek, renh tjayel-warn kwernek. Herod rang kwewaleny anetj-ilelhek. ");
INSERT INTO amx_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","John-el tjerrtj kwatjeh irrpelh-ilemel baptise-em-iletjamarleng, Jesu rang kwer-warn petjek. Kwereng Jesu renhemeh John rang kwatjeh irrpelh-ilemel baptise-em-ilek. Jesu rang Altjerr-warn angkek, alker rang altjwer-irrek. ");
INSERT INTO amx_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Kwerrern Alngaltar rang thep kwerlekwek-arteh anarnpetj-alhek Jesu-warn-athek, kwerel-ayeng arrernelhetj-alhek. Tjerrtj mapel Altjerr renh awek, alkereng angkerleh. Altjerr rang Jesu renh ilek, “Ntwang Ler tjengenh kwenh anem! Yeng ngkweng angerr anthwerr nyerrkem.” ");
INSERT INTO amx_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesu rang 30 years old anemeng, rang tjerrtj map Altjerr-penh kaltj-antherl-apetjam. Inang kwer-penh ilek, Jesu kwel Joseph-kenh ler anek. Joseph rang Heli-kenh ler anek. ");
INSERT INTO amx_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heli rang Matthat-kenh ler anek. Matthat rang Levi-henh ler anek. Levi rang Melki-henh ler anek. Melki rang Jannai-kenh ler anek. Jannai rang Joseph-kenh ler anek. ");
INSERT INTO amx_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Joseph rang Mattathias-kenh ler anek. Mattathias rang Amos-kenh ler anek. Amos rang Nahum-kenh ler anek. Nahum rang Esli-kenh ler anek. Esli rang Naggai-kenh ler anek. ");
INSERT INTO amx_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Naggai rang Maath-kenh ler anek. Maath rang Mattathias-kenh ler anek. Mattathias rang Semein-kenh ler anek. Semein rang Josech-kenh ler anek. Josech rang Joda-kenh ler anek. ");
INSERT INTO amx_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda rang Joanan-kenh ler anek. Joanan rang Rhesa-kenh ler anek. Rhesa rang Zerubbabel-kenh ler anek. Zerubbabel rang Shealtiel-kenh ler anek. Shealtiel rang Neri-kenh ler anek. Neri rang Melchi-kenh ler anek. ");
INSERT INTO amx_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Melchi rang Addi-kenh ler anek. Addi rang Cosam-kenh ler anek. Cosam rang Elmadam-kenh ler anek. Elmadam rang Er-kenh ler anek. ");
INSERT INTO amx_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er rang Joshua-kenh ler anek. Joshua rang Eliezer-kenh ler anek. Eliezer rang Jorim-kenh ler anek. Jorim rang Matthat-kenh ler anek. Matthat rang Levi-kenh ler anek. ");
INSERT INTO amx_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Levi rang Simeon-kenh ler anek. Simeon rang Judah-kenh ler anek. Judah rang Joseph-kenh ler anek. Joseph rang Jonam-kenh ler anek. Jonam rang Eliakim-kenh ler anek. ");
INSERT INTO amx_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakim rang Melea-kenh ler anek. Melea rang Menna-kenh ler anek. Menna rang Mattatha-kenh ler anek. Mattatha rang Nathan-kenh ler anek. Nathan rang David-kenh ler anek. ");
INSERT INTO amx_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David rang Jesse-kenh ler anek. Jesse rang Obed-kenh ler anek. Obed rang Boaz-kenh ler anek. Boaz rang Salmon-kenh ler anek. Salmon rang Nahshon-kenh ler anek. ");
INSERT INTO amx_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahshon rang Amminadab-kenh ler anek. Amminadab rang Ram-kenh ler anek. Ram rang Hezron-kenh ler anek. Hezron rang Perez-kenh ler anek. Perez rang Judah-kenh ler anek. ");
INSERT INTO amx_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judah rang Jacob-kenh ler anek. Jacob rang Isaac-kenh ler anek. Isaac rang Abraham-kenh ler anek. Abraham rang Terah-kenh ler anek. Terah rang Nahor-kenh ler anek. ");
INSERT INTO amx_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahor rang Serug-kenh ler anek. Serug rang Reu-kenh ler anek. Reu rang Peleg-kenh ler anek. Peleg rang Eber-kenh ler anek. Eber rang Shelah-kenh ler anek. ");
INSERT INTO amx_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Shelah rang Cainan-kenh ler anek. Cainan rang Arphaxad-kenh ler anek. Arphaxad rang Shem-kenh ler anek. Shem rang Noah-kenh ler anek. Noah rang Lamech-kenh ler anek. ");
INSERT INTO amx_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamech rang Methuselah-kenh ler anek. Methuselah rang Enoch-kenh ler anek. Enoch rang Jared-kenh ler anek. Jared rang Mahalaleel-kenh ler anek. Mahalaleel rang Kenan-kenh ler anek. ");
INSERT INTO amx_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenan rang Enosh-kenh ler anek. Enosh rang Seth-kenh ler anek. Seth rang Adam-kenh ler anek. Adam rang Altjerr-kenh ler anek. ");
INSERT INTO amx_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesu rang Jordan ulpay kwereng petj-alpek. Kwerrern Alngaltar rang kwerel-ayeng anek, renh twer-ilek. Kwerrern rang renh rrkwal-warn tjey-angek. ");
INSERT INTO amx_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Arrentjel renh arltang 40-eh-atwetj arrkernetjam. Arltang 40 kwerel Jesu rang itja mern arlkwek, ker apek, rang angayel kwet anek. ");
INSERT INTO amx_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Arrentjel Jesu renh twernek, “Ntwang Altjerr-henh Ler anemeng wart, ntwang pwert nhenh inenh mern-irretjeh ilang, ntwang arlkwetjeh-anngernt, angayel apek.” ");
INSERT INTO amx_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesu-el renh ilek, “Angketj nhenh Altjerr-henh pipel-ayeng intem, ‘Tjerrtj map Altjerr-kenh anem, inang itja mern-penhant iteth anem.’ ” ");
INSERT INTO amx_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kwereng arrentjel Jesu renh kern anthwerr-warn angek. Arrentj rang kwer mer map inenh mernek, ahelh apanpel. ");
INSERT INTO amx_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Arrentj rang renh ilek, “Mer nhenh map ingkerrek tjengenh anem. Thang anthem tjerrtj arrpenheh, inang merek-artwey anetjenheng. Thang ngkweng mer nhenh ingkerrek anthetjenh, ntwang twer anthwerr anetjenheng, rnwanentj amparrkey-arrkey-akert. ");
INSERT INTO amx_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kel ntwang tjengeng ularr kelkertel-ayeng arrernelhetjeh, yengant nakemel. Kwereng thang mer nhenh ingkerrek ngkwengemeh anthetjenh.” ");
INSERT INTO amx_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesu-el renh ilek, “Angketj nhenh Altjerr-henh pipel-ayeng intem, ‘Ntwang Altjerr kwereng ularr kelkertel-ayeng arrernelhetjeh. Ntwang Altjerr ngkwengenh kwerant kangkwerretjeh!’ ” ");
INSERT INTO amx_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kwereng arrentjel Jesu renh town Jerusalem-warnemeh tjey-angek, renh church angerretj kerneh anthwerr ngkernek. Arrentj rang renh ilek, “Ntwang Altjerr-henh Ler anemeng, ntwang warl kerneng anyetj-alpang. ");
INSERT INTO amx_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","11","Angketj arrpenh Altjerr-henh pipel-ayeng intem, ‘Altjerr rang angel alker-areny kwerenh map iletjenh, ngwenh arntarnt-aretjeh. Inang ngwenh iltjang inehenhel antwerrketjenh, ntwang ngkwern ngkwewaleny ltwakelhehetjeng.’ ” Lakenh arrentjel renh arrkernek. ");
INSERT INTO amx_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesu-el renh ilek, “Angketj arrpenh Altjerr-henh pipel-ayeng intem, ‘Ntwang itja Altjerr arrkernetjeh.’ ” ");
INSERT INTO amx_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Arrentjel Jesu renh arrkernekarl-penh, rang renh imperl-alhekemeh, rang renh kelant arrkernetjeh-anngerntel. ");
INSERT INTO amx_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesu rang mer Galilee-warn alpek. Kwerrern Alngaltar rang kwerel-ayeng anek, renh twer-ilek. Tjerrtj mapel mer mapel angketj Jesu-akertemeh awek. ");
INSERT INTO amx_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Jesu rang tjerrtj map church inehenhel kaltj-anthetjam, mer arrpenh mapel-ayeng. Inang renh angerr kangkemel nakek. ");
INSERT INTO amx_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Kwer-penh Jesu rang town Nazareth-warnemeh alpek, town nheng rang mangkekarl-warn. Arltang Saturday-el anemarleng, rang church inehenh-warn alhek. Lakenh rang arltang angerrel church-warn kweteth alhetjart town arrpenh-warn-arlk. Church kwenelemeh rang kemerremel irnek, Altjerr-henh angketj read-emeh-iletjeh pipel-ayel. ");
INSERT INTO amx_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Artwang nyentel kwer pip anthek Altjerr-henh angketj-akert, nheng angketj angenh-angenh Isaiah-henh angketj-akert. Jesu-el pip renh alkakek, angketj rang read-em-ilemel ilek, ");
INSERT INTO amx_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ngkart rang Kwerrern kwerenh tjeng-warn lanthek, rang yengenh ngkernek, angketj mwerr iletjeh tjerrtj rnwanentj-kweny maney-kweny mapeh. Rang yengenh urrpey lanthek, tjerrtj arrentjel rrkwekarl map iletjeh, ‘Ngkartel kwenh arrantherrenh arrentjeng rakem!’ Thang tjerrtj pweng map iletjeh, ‘Ngkartel kwenh anngang arrehantherr-henh aretjeh mpwarem!’ Thang tjerrtj nakepakel-irrekarl map iletjeh, ‘Ngkartel kwenh arrantherrenh ilem, “Thang iterleng-iterl anetj arrehantherr-henh wem, arrantherr arrkenemeh alartewarretjenh!” ’ ");
INSERT INTO amx_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Thang tjerrtj ingkerrek iletjenh, ‘Arltang rang kel anem, arltang nheng kwerel Ngkart tjerrtj mapeh mantj-mantj ngwerleny mernelhetjenharl.’ ” Lakenh Jesu rang werlamparenyeng anngetherr read-em-ilemel ilek. ");
INSERT INTO amx_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jesu-el pip renh angkep artaper-ilek, artwang kwer angkep anthek. Kwer-penh rang arrernelhek. Tjerrtj ingkerrekel renh twant-arek. ");
INSERT INTO amx_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jesu rang inenh ilek, “Angketj tharl read-em-ilek, angketj nhenh tjeng-penh lyet arratj anthwerremeh irrek.” ");
INSERT INTO amx_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Angketj kwenh mwerr anthwerr inang awek, inang anwerlkekemeh. Lwerenh-penh inang angkerrekemeh, “Yay! Nthakenharlam rang angkek? Nwern renh alhengk-arem wart! Rang kwenh nheng Joseph-henh ler anem!” ");
INSERT INTO amx_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesu-el inenh ilek, “Arrantherr lakenh kwenh yengenh twernetjenh, ‘Jesu-ay! Ntwang twerel mpwarang mer nhenhel, ntwarl mangkekarlel!’ Arrantherr awek, thang irlkert map mwerr-ilekarl town Capernaum-el. Arrantherr yeng pawenhetjeh apek, thang lakenh mpwaretjeh. Arrantherr apek yengenh arrkentj-iletjeh, ‘Ngangkaray! Ntwang mer arrpenh-areny map mwerr-ilekarl! Nhenh-areny map-arteh? Ntwang inenh apek mwerr-iletjeh?’ ” ");
INSERT INTO amx_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jesu-el ilek, “Arratj anthwerr, artwang apek Altjerr-henh angketj angenh-angenh anemeng, arlaltj kwerenh mapel renh itja nakem. ");
INSERT INTO amx_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Arrantherr key awem? Arrantherr iterl-arem, angketj artwang angketj angenh-angenh Elijah-akert. Elijah rang ngkwey anetjam-rlwer, kwatjel itja anhek 3 years 6 months-ek-atwetj. Mern itja lyapek mer ntjaperel, ingkerrek angayel anek. Inpert map anthwerr mer Israel-el anek. ");
INSERT INTO amx_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Altjerrel artwang Elijah inpert nyent-warn lanthek, renh arntarnt-aretjek. Inpert rang lwereny anek, town Zarephath-areny mer Sidon-el anek. Altjerrel itja Elijah lanthek inpert arlaltj Israel-areny nyent-warn. ");
INSERT INTO amx_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Thang arrantherrenh ilem angketj arrpenhemeh angketj angenh-angenh-akert, arreny kwerenh Elisha-akert. Artwang Elisha anetjam-rlwer, tjerrtj arrpenh map mer Israel-el leprosy tjwen-akert anek. Elisha rang itja tjerrtj Israel-areny inenh mwerr-ilek. Rang artwang lwereny arreny Naaman mer Syria-areny nhengant mwerr-ilek, rang leprosy tjwen-akert anek.” Lakenh Jesu-el inenh ilek. ");
INSERT INTO amx_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tjerrtj inang church kwenel anemarl map, inang angketj kwerenh awemel, inang Jesu-ek angerr ahang-irrek. ");
INSERT INTO amx_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Inang kemerrek, renh antwerrkemel town-eng keth-warn tjarr-angerrerrek. Mer Nazareth rartek pwert kernel-ayel artelhek. Inang Jesu renh pwert arnkarr-warn angek, renh taly-wetjeh. ");
INSERT INTO amx_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Jesu ineheng rlkwerr-angkwerr ntjwem kwet alpek. ");
INSERT INTO amx_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesu rang Capernaum town-warn alhek, mer Galilee-angkwerr. Saturday arltang angerrel Jesu rang church-warn irrpek. Rang tjerrtj map kaltj-anthetjam. ");
INSERT INTO amx_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Inang angketj kwerenh anwerlkemel awek. Inang angkerrek, “Rang kwenh angketj twer anthwerrel nwernenh kaltj-anthem!” ");
INSERT INTO amx_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Artwang kwerrern anetj-akert nyent anek. Artwang rang arlkemel ilek, ");
INSERT INTO amx_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Jesu, Nazareth-arenyay! Wenh kwer ntwang nhenh-warn petjekan? Nwernenh ywerrelh-ilemel atwetjeh key? Yeng ngkweng kaltj! Ntwang Altjerr-henh artwang arratj anthwerr rang anem!” ");
INSERT INTO amx_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesu-el kwerrern anetj renh arrantj-akemel ilek, “Intert-irray! Artwang yanheng arratang!” Kwerrern anetj rang artwang renh ahelh-warn ilatwerl-alhek ineheng anngetherr. Kwereng kwerrern anetj rang artwangeng arraterl-alhek. Artwang rang mwerremeh anek. ");
INSERT INTO amx_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tjerrtj map anwerlkemel pawenherrek, “Wenham lakenhan? Rang nwernenh angketj twer anthwerrel kaltj-anthek! Rang kwerrern anetj map anpwem, inang kwer kangkwerremel arratem!” ");
INSERT INTO amx_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Inang angketj Jesu-akert ilerl-apek mer Galilee ntjaperel. ");
INSERT INTO amx_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Kwer-penh Jesu rang church-eng arratemel alhek Simon-henh mer-warn. Simon-henh marl rtwaltj rang irlkert angerr anek. Inang Jesu-ek ntangkelhek. ");
INSERT INTO amx_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesu rang marl kwer-warn angath-irretj-alhek. Rang angkek, “Kwereng arratemel alhay!” Marl rang parrp mwerr-irrek. Rang kemerremel irnek, kwer-penh rang mern ineh tjang-itek. ");
INSERT INTO amx_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","41","Kel aherrk irrpekarl. Tjerrtj mer-areny ingkerrek Jesu-warn arraw-irrek. Inang tjerrtj irlkert map tjerrtj arrentj-akert map thwen angetjewarrek. Jesu-el iltjang kwerenh arrernemel tjerrtj irlkert map inenh mwerr-ilek. Rang arrentj map anpwek kwerrern inehenheng. Arrentj mapel arlkemel ilek, “Ntwang Altjerr-henh Ler anem!” Arrentj inang Jesu-eh kaltj anek, rarl Christ anemeng. Jesu-el arrentj inenh arnpakek, inang itja kwer-penh angketjeh. ");
INSERT INTO amx_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Kweny-rtweh Jesu kemerrek. Rang keth-warn alhek, nyent-areny anetjek. Tjerrtj arrpenh map kwer palenthwek. Inang renh aremel arnpakek, “Ngkartay, ntwang itja nwernenh imperl-alhetjeh! Nwernehel-ayeng kwet anang!” ");
INSERT INTO amx_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jesu-el inenh ilek, “Thang tjerrtj map town arrpenh mapel angketj mwerr renh kaltj-antherl-apetjeh. Thang inenh ilerl-apetjeh, Altjerr tjerrtj ingkerrekeh Ngkart angerr anemeng. Lakenheh kwenh Altjerrel yengenh lanthekarl.” ");
INSERT INTO amx_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Rang mer Judea-angkwerr church map-warn irrperl-apetjam, angketj mwerr renh kaltj-antherl-apemel. ");
INSERT INTO amx_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Arltang arrpenhel Jesu rang kwatj alay arreny Gennesaret iterel irnetjam. Tjerrtj map kwer-warn petjewarrek, Altjerr-henh angketj awetjeh-anngernt. Inang angath-irrentj-alhek, awetjeh. Rang inenh Altjerr-henh angketj kaltj-anthetjam. ");
INSERT INTO amx_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Rang boat atherr arek kwatj iterel. Artwang irrpenng antwerrkenh-rrkwenh boat inehenh atherr inang imperl-alhekarl. Inang net inehenh lhewetjam. ");
INSERT INTO amx_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesu boat nyent-warn antjek, Simon-henh boat-warn. Jesu-el Simon renh ilek, rang boat renh kwatj mpwep-warn arrernetjeh. Itja ntwarr, itereng angath war. Jesu rang boat kwerel arrernelhemel tjerrtj inenh kaltj-antherl-anek. ");
INSERT INTO amx_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Rang inenh kaltj-anthekarl-penh, rang Simon renh ilek, “Boat nhenh angang kwatj mpwep-warn. Kel net map arrehantherr-henh kwatj-warn werrerrang, irrpenng antwerrketjenheng.” ");
INSERT INTO amx_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon-el Jesu renh ilek, “Twernkay, nwern-artek kweny ntjaper rrkwapekarl, irrpenng antwerrketjeh, pelkel war. Wenheh ntwang nwernenh ilek, nwern net inenh weth kwatj-warn wetjeh? Kel ntwang nwernenh ilekarl wart, nwern ngkweng kangkwerrem.” ");
INSERT INTO amx_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Inang boat-el kwatj mpwep-warn alhek, net inenh kwatj-warn werrerrek. Inang irrpenng map anthwerr antwerrkek, net inang ngkwa tjep-akelhetjeh anek. ");
INSERT INTO amx_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Lakenheng inang peltj inehenheh iltjerrek, inarl boat arrpenhel anemeng, inang petjetjeh, net inenh tangetjel antwerrketjeh. Arrpenh map petjek tangetjel rrkwapetjeh. Inang irrpenng map-arlk antwerrkek. Boat atherr ngkwal kwatj-warn irrpetjeh irrek! ");
INSERT INTO amx_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","10","Irrpenng antwerrkenh-rrkwenh mapel irrpenng map arek, inang anwerlkek. Map anthwerr! Simon Peter-henh peltj atherr, James John thwen anwerlkek. Ratherr Zebedee-henh ler artwang atherr anek. Simon Peter rang Jesu-eng ularr kelkertel-ayeng arrernelhek. Rang Jesu renh ilek, “Ngkartay, tjengeng alhay, yeng tjerrtj anetj-akert anemeng wart!” Jesu-el Simon renh ilek, “Ntwang itja ater-irretjeh. Ntwang irrpenng map antwerrkekarleng, lyeteng ntwang tjerrtj map antwerrketjeh, inenh tjeng-warn angetjetjeh.” ");
INSERT INTO amx_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Inang boat kwatj iter-warn tjarr-angek ngkernemel. Kwereng Simon Peter James John thwen rnwanentj ingkerrek inehenh imperl-alhek, Jesu-eng anharrel-ayeng alhek. ");
INSERT INTO amx_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Arltang arrpenhel Jesu rang town nyentel anek. Town kwerel artwang nyent leprosy-akert tjwen apapeth-akert anek. Rang Jesu renh arek, rang kwereng ularr kelkertel-arleng arrernelhek. Rang Jesu renh pawenhek, “Ngkartay, yeng kaltj, ntwang tjerrtj map mwerr-ilek. Ntwang ahentj apek anem, ntwang yengenh mwerr-iletjeh!” ");
INSERT INTO amx_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesu-el renh iltjel arnpemel ilek, “Ya, yeng ahentj-anem, ngwenh mwerr-iletjeh. Kel thang ngwenh mwerr-ilek!” Artwang kwerenh tjwen map kel ywerrekemeh. ");
INSERT INTO amx_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jesu-el artwang renh ilek, “Ntwang tjerrtj arrpenh mapeh itja ilelhetjeh, ntwang mwerr-irrekarl. Alhang church-warn, ngkart priest-warn! Kwereng ularr irnang, rang mpwerrk ngkwengenh aretjeh. Rang ngwenh aretjeh, ntwang mwerr-antem-irrek, tjwen-kweny. Kwereng ntwang Altjerreh tjenkerr anthang, Moses-el ngkwey tjerrtj map ilekarl-arteh. Ntwang lakenh mpwaretjeh, tjerrtj ingkerrek kaltj anetjenheng, ntwang kel mwerr-irrekarl.” ");
INSERT INTO amx_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Tjerrtj mapel angketj Jesu-akert ilerl-apetjam mer mapel. Tjerrtj aningk kwer-warn petjewarrek, renh awetjeh, rang irlkert inehenh mwerr-iletjenheng. ");
INSERT INTO amx_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Map-ingar Jesu rang alhetjart, nyent-areny anetjeh, Altjerr-warn angketjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Arltang arrpenhel Jesu warl kwenel anek. Rang tjerrtj aningk kaltj-anthetjam. Artwang Pharisee mapel kaltj-anthenh-anthenh mapel thwen renh awerl-anek. Nhenh map mer Galilee ntjapereng petjekarl, Judea-eng, town Jerusalem-eng thwen. Ngkartel kel Jesu renh arrwekel twer-ilekarl, tjerrtj irlkert mwerr-iletjeh. ");
INSERT INTO amx_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Artwang rrpwetj inang artwang arlamarr nyent renh angetjewarrek. Artwang arlamarr rang antjamel-ayeng intek kwet. Inang ahentj-anek, renh warl-warn kwen angetjetjeh, renh Jesu-eng ularr arrernetj-alhetjeh. ");
INSERT INTO amx_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Inang ywarn Jesu-warn itwek-irrek, tjerrtj mapel tjey arltwekarleng wart. Lakenheng inang warl kern-warn antjek, inang warl kerneng altjwer-ilek. Kwereng inang artwang arlamarr renh room mpwep-warn anarnpelh-ilek. Artwang rang antjamel-ayeng kwet intek. ");
INSERT INTO amx_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesu-el inenh aremel iterrek, “Artwang nhenh mapel iterl-arem, thang renh mwerr-iletjenharl.” Rang artwang arlamarr renh ilek, “Peltj tjengenhay! Thang anetj ngkwengenh wem.” ");
INSERT INTO amx_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Artwang Pharisee mapel kaltj-anthenh-anthenh mapel thwen angketj nhenh awemel inang iterrek, “Wenhekarl rang lakenh angkem? Rang itja lakenh angketjeh! Lakenh rang Altjerr arrampewem! Altjerrelant kwenh anetj tjerrtjeng wem!” ");
INSERT INTO amx_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesu-el iterrentj inehenh alhengk-arek. Rang inenh pawenhek, “Wenhengarl arrantherr lakenh iterrem? ");
INSERT INTO amx_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nthakenham mwerran anem, artwang arlamarr nhenh renh iletjeh apek, ‘Thang ilem, thang anetj ngkwengenh wem.’ Itjeng apek renh iletjeh, ‘Kemerrang! Antjam ngkwengenh inemel kemerremel alpang!’? Yengenh ilerrerray! ");
INSERT INTO amx_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Altjerrel Tjerrtj-henh Ler ngkernek, tjerrtj ngwenh-henh apek anetj wetjeh. Thang arrantherrenh nhenh lyet mernetjenh.” Jesu-el artwang arlamarr renh ilek, “Kemerrang! Antjam ngkwengenh inemel kel mer-warn alpang!” ");
INSERT INTO amx_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Artwang arlamarr rang kemerrek, rang antjam kwerenh inemel arratenhek, Altjerr nakemel. Tjerrtj ingkerrekel renh rtwarewarrek. ");
INSERT INTO amx_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Inang ywarn iterremel anwerlkek. Inang Altjerr kangkemel nakek. Lakenh inang angkerrek, “Lyet nwern kwenh twer arrpenh anthwerr arek!” ");
INSERT INTO amx_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Kwer-penh Jesu warleng keth-warn arratek. Rang artwang aretj-alhek, arreny kwerenh Levi, lywel kwen anerl-anemeng. Levi rang tax maney kwetjetjart tjerrtj mapeng. Jesu-el renh aremel ngwek, “Tjengel-ayeng petjang!” ");
INSERT INTO amx_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi rang kel kemerremel rnwanentj ingkerrek maney-arlk kwerenh imperl-alhek. Rang Jesu-el-ayengemeh pwert alhek. ");
INSERT INTO amx_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kwer-penh Levi-el tjenkerr rrkwapek warl kwerenhel, Jesu-ek kangkentj mernelhemel. Rang tjerrtj tax maney kwetjenh-tjenh map ntangkek, tjerrtj arrpenh map-arlk. Jesu-el inehel-ayeng mern arlkwek. ");
INSERT INTO amx_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Artwang Pharisee rrpwetj, kaltj-anthenh-anthenh thwen inang kwertengerl mapeh kwerl-angkek, “Wenhengarl arrantherr tjerrtj tax maney kwetjenh-tjenh mapel-ayeng tjerrtj anetj mapel-ayeng thwen mern arlkwem? Arrantherr Moses-henh mpwareng-arengeh itja arratj kangkwerrem! Arrantherr kwenh anetj lakenh mpwarem!” ");
INSERT INTO amx_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesu-el inenh ilek, “Ngangkarel itja mwerr map mwerr-ilem. Irlkert mapant rang mwerr-ilem. ");
INSERT INTO amx_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Arrantherr apek iterrem, yengarl petjekarl, nheng tjerrtj mwerr map ngwetjeh. Itja, yeng petjek tjerrtj anetj mapek-arlk, inenh angkep twepelh-iletjeh Altjerr-warn, inang arratj Altjerreng ularr anetjenheng.” ");
INSERT INTO amx_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Tjerrtj arrpenh inang Jesu kwer-warn angkek, “John Kwatjeh Irrpelh-ilenh-ilenh-henh kwertengerl map, artwang Pharisee map thwen inang mern arlkwetj-kweny anetjart arltang rrpwetjeh-atwetj, Altjerrant nakemel. Lakenh inang mpwaretjart. Nthakenharl kwertengerl ngkwengenh mapel mern-arlk arlkwem, wine-arlk antjwem kweteth?” ");
INSERT INTO amx_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesu-el inenh ilek, “Thang angketj kwek war ilem arrekantherrek. Artwel anew inemarleng, kwer-penh rang tjenkerr mpwarem. Arrwekel rang peltj kwerenh map ngwem, mern arlkwetjeh. Peltj inang ywarn merneng anpwelhem. Inang kwerel-ayeng kangkemel mern arlkwem. ");
INSERT INTO amx_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kelant tjerrtj arrpenh mapel artwang renh antwerrkemel angetjenh. Artwang peltj kwerenh map arltang arrpenhel mern-kweny anetjenh, irrar-irremel.” ");
INSERT INTO amx_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Jesu-el tjerrtj map kwet kaltj-anthetjam, “Mantarr ngkweyeny alterrelhem apek, tjerrtj rang itja mantarr lyeteny kwek akemel, mantarr kwer-warn ampek-arrernemel tanthem. Mantarr lyeteny alterrelhehetj. Mantarr ngkweyeny weth alterrelhemel tjep-akelhehetj. Tjerrtjel-artek mantarr ngkweyeny arrpenh kem, mantarr ngkweyeny-penh tanthemel. Lakenh rang mantarr mwerr-akertemeh anetjenh.” ");
INSERT INTO amx_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Jesu-el kwet kaltj-anthetjam, “Tjerrtjel itja wine lyeteny yenp ngkweyeny-warn thelem. Yenp alterrelhehetj, wine lyeteny yenp ngkweyenyeng thelelhehetj, tjerrtjel wine parlp-ilehetj. ");
INSERT INTO amx_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Lakenh kwenh tjerrtjel wine lyeteny yenp lyetenyehant thelem, mwerr antwerrketjenharleng.” ");
INSERT INTO amx_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Tjerrtj inarl wine ngkweyeny antjwekarl, inang itja wine lyetenyeh ahentj-anetjeh. Inang angkem, “Wine ngkweyeny rang kwenh mwerr-lkwer!” ");
INSERT INTO amx_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Saturday arltel Jesu rang kwertengerl kwerenh map-akert mern wheat map mpwep-angkwerr anper alhetjam. Mern wheat inang ampeng anek. Kwertengerl mapel mern wheat inenh akemel kek-wemel arlkwerl-apetjam. ");
INSERT INTO amx_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Artwang Pharisee rrpwetjel nhenh aremel mwekeny-irrek. Inang Jesu renh pawenhek, “Wenhengarl arrantherr lyet mern wheat akem? Saturday arltang tjeperrarl anem! Mpwareng-areng nwern-kenhel-ayeng intem, arltang nhenhelan nwern itja rrkwapem. Nhenh itja arratj anem, arrantherr Saturday arltel mern wheat aketjeh!” ");
INSERT INTO amx_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesu-el inenh pawenhek, “Arrantherr key King David-eh kaltj? Ngkwey David rang atwenh-atwenh kwerenh map-akert angayel anek, nheng atwenh-atwenh arrpenh mapel inenh alwernetjam-rlwer. ");
INSERT INTO amx_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","David Altjerr-henh church-warn irrpek. Church kwerel mern tjenkerr intek arrwekel-penh, nheng arltang angerr ngkart priest mapelant war arlkwetjeh-anngernt kelant. David-el mern nhenh inemel kwenpel arlkwek angayelel wart. Rang artwang kwerel-ayel anetjamarl mapeh anthek, inarlk arlkwetjeh, angayelel wart. Lakenh David rang kwenpel Altjerr-henh mpwareng-arengeh kangkwerretj-kweny anek.” ");
INSERT INTO amx_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jesu-el inenh ilek, “Tjerrtj-henh Ler anem arltang angerrek-artwey wart, Ngkart angerr. Thang kwenp mern aketjeh arltang angerr nhenhelan.” ");
INSERT INTO amx_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Arltang Saturday arrpenhel Jesu rang church-warn kwen irrpek, tjerrtj inenh kaltj-anthetjeh. Rang tjerrtj inenh kaltj-anthetjam. Artwang iltjang apekap-akert rang church kwenel anetjam. ");
INSERT INTO amx_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Artwang Pharisee mapel Moses-henh mpwareng-areng kaltj-anthenh-anthenh mapel thwen Jesu renh mantjel arerl-anek. Inang lakenh iterrek, “Nwern renh aretjeh-amparr, nthakenh-nthakenh rang mpwaretjenharl. Lwerenh-penh nwern renh iletjeh lakenh, ‘Ay, ntwang itja lakenh mpwaretjeh arltang nhenhel!’ Angketj nwern-henhel-ayeng intem, tjerrtjel itja tjerrtj irlkert mwerr-ilem arltang Saturday-elan.” ");
INSERT INTO amx_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Jesu-el iterrentj inehenh alhengk-arek. Rang artwang iltjang apekap renh ngwek, “Kemerremel irnang, arrwekel-warn petjay.” Artwang rang kemerremel Jesu-el-ayel irnek. ");
INSERT INTO amx_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kwereng Jesu-el tjerrtj map pawenhek, “Nthakenham nwern mpwaretjeh? Saturday arltel nwern mwerr mpwaremer key, tjerrtj irlkert mwerr-iletjeh key? Nwern anetj key mpwaremer? Nthakenham Moses-el ilek? Nthakenhameh arrantherr iterl-arem? Nthakenhameh nwern irretjenh arltang nhenhelan?” ");
INSERT INTO amx_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jesu-elemeh tjerrtj map arnterr arek, kwereng rang artwang renh ilek, iltjang kwerenh rlkerr-welhetjeh. Kel artwang rang iltjang kwerenh rlkerr-welhek, kel mwerremeh irrek apekap-penh. ");
INSERT INTO amx_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Kwer-penh artwang Pharisee map kaltj-anthenh-anthenh map thwen inang Jesu-eh ahang anthwerr irrek. Inang lakenh pawenherrek, “Nthakenham nwern irrey artwang nhenhehan?” ");
INSERT INTO amx_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Kel arltang arrpenhel Jesu rang irntang-warn antjek, Altjerr-warn angketjeh-anngernt. Rang kweny angerrel Altjerr-warn angketjam. ");
INSERT INTO amx_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kel kweny-rtwehemeh rang nakenh-nakenh map ntangkek, pwert iter-warn antjetjeh. Rang artwang 12 ineheng ngakemel ngwek, kwertengerl kwerenh anetjeh. Rang arreny arrpenh kaltj-anthenh-anthenh tjeperr ineh anthek. ");
INSERT INTO amx_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Artwang nhenh inang anek: akenheng atherr Simon Andrew thwen, Simon renh Jesu-el arreny arrpenh Peter anthek. Akenheng-atherr James John thwen, Philip, Bartholomew, ");
INSERT INTO amx_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matthew, Thomas, Alphaeus-henh ler, James. Simon arrpenh nhenh-artek atwenh-atwenh anek, Altjerr-henh arrenyeng arrngel. Arrwekel Simon rang irrpelth-irretjart, Rome-areny mapel-ayeng atwerretjeh. ");
INSERT INTO amx_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Artwang James arrpenh-kenh ler, arreny Judas. Judas arrpenh Judas Iscariot. Judas nhenh rang Jesu renh kelant atwenh-atwenh mapek anthetjenharl. ");
INSERT INTO amx_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Kwereng Jesu rang kwertengerl kwerenh map-akert pwerteng anarnpek ahelh keth-warn. Nakenh-nakenh arrpenh map kwer arrwekel karelhetjam keth kwerel. Tjerrtj aningk mer Judea-eng petjekarl, town Jerusalem-eng, town Tyre-eng town Sidon-eng-arlk thwen. Town Tyre town Sidon ratherr-artek kwatj alayeng iterel artelhetjart. ");
INSERT INTO amx_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Tjerrtj nhenh inartek petjek, Jesu renh awetjeh, Jesu rang tjerrtj peltj irlkert inehenh mwerr-iletjenheng wart, inang aretjek petjek lakenh. Jesu-el tjerrtj irlkert inenh mwerr-iletjam, kwerrern anetj rang anpwetjam tjerrtjeng. ");
INSERT INTO amx_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Tjerrtj ingkerrekel-artek Jesu renh arnpetjeh ahentj-anetjam, inang kwer kaltj anek, rang twer angerr-akert anemeng wart. Irlkert map inang renh arnpemel kel mwerr-irrek. ");
INSERT INTO amx_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesu-el nakenh-nakenh map aremel inenh ilek, “Arrantherr rnwanentj-kweny maney-kweny anem apek, arrantherr arrken anem, Altjerr rang Ngkart arrehantherr-henh anemeng wart, arrantherr Ngkart-henh peltj arlaltj anem, arrantherr mer alkerek-artwey wart anem. ");
INSERT INTO amx_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Arrantherr lyet apek angayel kwet anem, arrantherr arrken anem, Altjerrel arrantherrenh wantetjenheng wart. Arrantherr lyet arnemel ampangkem apek, arrantherr arrken anem, Altjerrel arrantherrenh arrken atherretjeh mpwaretjenheng wart. ");
INSERT INTO amx_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Tjerrtj-henh Lereng arrngel tjerrtj arrpenh map apek arrehantherr ahentj-kwenh anetjenh, inang arrantherrenh anpwetjenh apek, arrampewetjenh apek, arrehantherr-henh angketj ulpert-ilemel lhwerrkert angketjenh apek. Kelelam tjerrtj anetjel arrantherrenh arrampewem, Ngkartel arrantherrenh angketj kwerenhel mwerr-iletjenh. ");
INSERT INTO amx_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“Ngkwey arrwekeleny mapel kwenh Altjerr-henh angketj angenh-angenh map lakenh-arteh anetj-ilek. Tjerrtj inang arrantherrenh anetj-ilem apek, arrantherr arrken angerr anetjeh, Altjerrel kelant mer alkerel arrantherrenh kwet kwart-wetjenh. ");
INSERT INTO amx_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Tjerrtj rnwanentj angerr-akert mapay, arrantherr ltarrp irretjeh, arrehantherr rwekenth-kenth angerr anetjenh. Altjerrel kwenh arrantherrenh itja weth kwart-wetjenh. ");
INSERT INTO amx_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Tjerrtj arrantherrarl lyet mern angerr arlkwerl-anem, arrantherr ltarrp irretjekant, arrantherr kelant kwenh angayel anetjenh. Tjerrtj arrantherrarl lyet atherrerl-anem angerr, arrantherr kwenh ltarrp-irretjekant. Arrantherr kelant arnetjenh, angerr ampangkemel. ");
INSERT INTO amx_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Tjerrtj ingkerrekel apek arrantherrenh nakem, arrantherr ltarrp-irretjekant. “Lakenh kwenh arrwekeleny mapel angketj angenh-angenh urrtjalth map palel naketjart.” ");
INSERT INTO amx_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Arrantherrarl tjeng kangkwerrem mapay, tjerrtj inang arrehantherr ahentj-kwenh-irrem apek, arrantherr ineh kangkentj mernelhetjehant, ineh mwerr anerrerrang. ");
INSERT INTO amx_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Tjerrtj inarl arrehantherr anetj angkemeng, arrantherr ineh kangkentj mernelhetjeh. Tjerrtj inarl arrantherrenh iltem apek, ineh arrantherr Altjerr renh tjang-pawenherrerrang. ");
INSERT INTO amx_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Tjerrtj arrpenhel ngwenh apek rlkey atwem, rlkey arrpenh ngkwengenh kwer anthelhang, rang ngwenh weth atwetjeh. Tjerrtj arrpenhel apek coat ngkwengenh inem, kwer mentj impang. Rang tjart ngkwengenh inem apek, kwer kel mentj impang. ");
INSERT INTO amx_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Tjerrtj arrpenh ngkwengenh mantarreh ankey nkem, renh anthang. Tjerrtj arrpenhel apek mantarr ngkwengenh inem, ntwang renh itja lakenh angkep pawenhetjeh, ‘Mantarr tjengenh angkep anthetj-alpang!’ Mentj kwet impay! ");
INSERT INTO amx_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Arrantherr ahentj-anem apek, tjerrtj arrpenh ngkweng arratj mernelhetjeh, lakenh-arteh arrantherr-amparr arratj mernelhetjeh. ");
INSERT INTO amx_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Arrantherr peltj arrehantherr-henhehant kangkem key? Altjerr itja arrehantherr lakenheh ahentj-anem. Tjerrtj anetj-anetj inang kwenh peltj inehenhehant kangkem lakenh. Wenheham Altjerrel arrantherrenh kwart-wetjeh? Arrantherr peltj-kwenh lwereny mapeh kangketjeh-arlk. ");
INSERT INTO amx_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Arrantherram tjerrtj arrpenh mapehant kangkentj mernelhem, nheng inarl arrehantherr arrwekel tangetjel anekarl-arteh? Tjerrtj anetj-anetj map lakenh mernelhem! Arrantherr tjerrtj arrpenh mapeh kangkentj mernelhemer, inarl arrehantherr arrwekel itja kangkentj mernelhek. ");
INSERT INTO amx_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Arrantherr apek tjerrtj inehant rnwanentj lyetek war anthetjeh, inarl arrantherrenh angkep anthetjenh. Wenhameh Altjerrel arrantherrenh kwart-wetjenh? Itja apek. Nheng tjerrtj anetj anemarl map inang lakenh mpwarem, tjerrtj arrpenh mapeh apek anthem war. Nheng inang anthetjeh-anngernt, inang iletjeh, arrpenh renh angkep anthetj-alpetjehant. Lakenh mpwaretjal anay! Arrantherr rnwanentj kwetant anthetjeh, angkep pawenhetj-kwenh. ");
INSERT INTO amx_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Tjerrtj inarl arrehantherr ahentj-kwenh map ineh arrantherr nyerrkentj mernelhetjeh, ineh mwerr mpwaretjeh. Ineh rnwanentj kwetant anthetjeh. Arrantherr rnwanentj renh itja angkep raketjeh. Kwereng Altjerrel arrantherrenh angerr kwart-wetjenh. Arrantherr kwer kwerenh map anetjenh. Altjerr rang kwenh tjerrtj anetj mapeh kangkentj mernelhem, tjerrtj inarl kwer itja kangkentj angkep mernelhemeng. ");
INSERT INTO amx_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Arrantherr-artek tjerrtj arrpenh mapeh mantj-mantj mernelhetjeh, Angey arrehantherr-henharl ineh mantj-mantj mernelhem-arteh.” ");
INSERT INTO amx_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Arrantherr itja tjerrtj arrpenh lakenh iletjeh, ‘Ntwang tjerrtj anetj anem.’ Ntwang renh lakenh ilem apek, Altjerrel ngwenh iletjenh, ntwang tjerrtj anetj-akert anemeng. Arrpenhel apek ngkweng anetj mernelhem, angkep atwetj-kweny anetjek angwerremel, peltjemeh kwer mernelhay. Kwereng Altjerrel anetj arrehantherr-henh wetjenh angwerremel. ");
INSERT INTO amx_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Arrantherr tjerrtj arrpenh mapeh rnwanentj-arlk anthetjeh, kwereng Altjerrel arrantherrenh angerr kwart-wetjenh. Arrantherr tjerrtj arrpenheh apek mern-arlk angerr kwet anthemeng, Altjerrel arrantherrenh angerr angkep kwart-wetjenh. Arrantherr inenh mantarr-arlk kwek war apek anthem, Altjerrel arrantherrenh kwek war angkep kwart-wetjenh. Arrantherr tjerrtj arrpenh mapeh kangkentj mernelhem apek, Altjerr rang arrehantherr kangkentj angkep mernelhetjenh.” ");
INSERT INTO amx_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesu-el inenh ilek, “Thang angketj ilem artwang pweng atherr-akert. Artwang pwengel kwenh artwang arrpenh pweng arrpekw ywarn tjey-angem. Ratherr kel ipert-warn anyetjenh. ");
INSERT INTO amx_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Thang angketj arrpenh ilem kaltj-anthenh-anthenh-akert. Tjerrtj arrpenh rang kaltj-amparr-irrem, rang itja kaltj anem. Kaltj-anthenh-anthenh kwerenh rant kaltj anem. Tjerrtj rarl kwet angketj ingkerrek kaltj-irrekarl, rang kelant kaltj-anthenh-anthenh kwerenh-arteh anetjenh. ");
INSERT INTO amx_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","“Ntwang ilelhem mwerr kwel, ntwang rrtjwerrem war. Ntwang ahentj-anem tjerrtj arrpenh arratj-iletjeh, ngkwewaleny-amparr arratj-ilelhang. Nthakenh-nthakenh ntwang arem? Itjam, ntwang artwang pweng war anemeng wart. Nthakenh ntwang lyek kwek renhant keth arem, rarl peltj nakenh-nakenh ngkwengenh-henh anngel interleh, kwenh arnang angerr rarl anngang ngkwengenhel intemeng, ntwang itjarl arem? Nthakenhameh ntwang peltj ngkwengenh-warn angkem, ‘Peltjay, yeng impang, thang lyek kwek renh anngang ngkwengenheng arratelh-iletjek.’ Ntwang arnang angerr renh anngang ngkwengenhel itjarl arem! Nthakenhameh ntwang lyek kwek renhant peltj ngkwengenh anngelant arem? Tjerrtj urrtjalthay, ntwang war nakelhem. Ntwang arnang angerretj renh anngang ngkwengenhengek-amparr arratelh-ilang. Kwereng ntwang lyek kwek renh peltj ngkwengenh-henh anngel interleh keth aretjenh. Renh ntwang arratelh-iletjenh.” ");
INSERT INTO amx_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Thang arrantherrenh ilem angketj arnang atherr-akert. Arnang mwerrel mern mwerrant ngwerrm-ilem, itja mern anetj ngwerrm-ilem. Arnang anetjel mern anetjant ngwerrm-ilem, ywarn mern mwerr ngwerrm-ilem. ");
INSERT INTO amx_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nwern mern iterl-arem arnang arrpenh-arrpenh. Tjerrtjel itja mern tjwerrk apek lyekeng kwetjem. Tjerrtjel itja mern perlap apek arnang alangkweng kwetjem. ");
INSERT INTO amx_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Tjerrtj rang iterrem iterrentj kwerenhel-ayeng. Kel lakenh-arteh rang angkem. Rang apek mwerr anem, rang mwerr iterrem iterrentj kwerenhel-ayeng, lakenh rang angketj mwerrarl angkem. Tjerrtj arrpenh apek anetj anem, rang anetj iterrem iterrentj anetj kwerenhel-ayeng, lakenh rang anetjarl angkem, iterrentj kwerenh anetj anemarleng wart.” ");
INSERT INTO amx_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Wenhengarl arrantherr yengenh Ngkart anewem, arrantherr kangkwerretj-kweny anem tjeng? ");
INSERT INTO amx_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Tjerrtj ngwenh apek tjeng-warn petjem, angketj tjengenh awem, angketj tjengenheh kangkwerremel. Tjerrtj ngwenh-arteh inang anem? ");
INSERT INTO amx_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Thang angketj kwek ilem artwang nyent-akert arrehantherr. Artwang rang warl kwerenh irntang-arleh artekarl. Warl kwerenh artetjeh-anngernt, rang arrwekel ahelh twerel inyek irntangek-atwetj. Arltang arrpenhel kwatj rew-arlk petjemarleng, warl renh atwentjemeng, warl rang itja takelhetjenh, twer kwet anem, renh irntang-arleh wart artekarleng. ");
INSERT INTO amx_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Thang angketj arrpenh ilem artwang arrpenh-akert, rang warl artek. Rang ulpay iterel warl artek. Tjerrtj inarl angketj tjengenh awem apek, inang angketj kwer itja kangkwerrem, inang kel artwang ahert-arteh anem, inang warl inehenh ulpay iterel artekarl, ahelh kweneng lher war irntang-kwenh. Kwatj rew-arlk petjemarleng, warl renh atwentjemeng, warl rang ahelh-warn kwet takelhetjenh. Lakenh mernelhemeng apek, arrantherr itja Altjerrel-ayeng kwet anetjenh.” ");
INSERT INTO amx_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesu-el tjerrtj map kaltj-anthekarl-penh, rang town Capernaum-warn alhek. ");
INSERT INTO amx_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Town nhenh kwerel twernk nyent Rome-areny anek, rang atwenh-atwenh mapeh twernk anek. Kel twernk kwerenh rrkwapenh-apenh irlkert angerr anek, rang ilwetjeh-anngernt anek. Twernk rartek artwang nhenh kwer angerr kangkek. ");
INSERT INTO amx_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Twernk rang awek, Jesu-arl town-warn petjekarl. Rang Jew angerrepat rrpwetj Jesu-warn urrpey lanthek, Jesu renh ngwerl-alpetjeh, rrkwapenh-apenh kwerenh mwerr-iletjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Angerrepat inang Jesu-warn alherrerrek. Inang renh aretj-alhemel pawenhek, “Nwern petjek, ngwenh pawenhetjeh. Peltj nwern-kenh Rome-areny twernk anem, rartek artwang kangkentj anem. Kwerenh rrkwapenh-apenh irlkert angerr intem. Rang tjerrtj Jew nwerneh kangkem. Rang church nwerneh artek. Kwer ntwang ltarrp-irray! Petjay, ntwang rrkwapenh-apenh kwerenh renh mwerr-iletjek.” ");
INSERT INTO amx_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","8","Kel Jesu inehel-arleng antelherl-alhek. Inang warl twernk-henh-warn angath-irrentj-alhek. Twernk rang urrpey arrpenh mapemeh Jesu-warn lanthek. Twernk rang urrpey inenh ilek, angketj Jesu iletjeh. Inang Jesu renh aretj-alhemel angketj kwerenh ilek, “Twernk rang ahentj-kwenh anem, ntwang kwer-warn petjetjeh. Ntwang artwang angerr anem, rang artwang anetj-anetj war anem. Rang kwenh twernk atwenh-atwenh map-akert anem. Rang apek atwenh-atwenh nyent apek ilem, ‘Alhang’, rang kel alhem. Rang apek arrpenh ngwem, ‘Petjang’, rang kel petjem. Rang apek rrkwapenh-apenh kwerenh ilem, ‘Lakenh mpwaretjeh’, rang kel lakenh mpwarem. War angkang, rrkwapenh-apenh kwerenh rang parrp mwerr-irretjeh. Lakenh twernk rang nwernenh ilek, ngwenh iletjeh.” Lakenh twernkel angketj lanthek urrpey inehel-arleng. ");
INSERT INTO amx_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesu-el angketj nhenh awemel rang anwerlkek. Rang alngarelhemel tjerrtj inenh ilek, “Angketj lakenh kwenh thang lyetant awek! Twernk yanh rang yengenh angerr nakem! Arratj, thang itja kwenh tjerrtj lakenh-artek awek arrwekel, mer Israel ntjaperel!” ");
INSERT INTO amx_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Kwer-penh urrpey inang warl-warn angkep petj-alpek, inang rrkwapenh-apenh renh arek mwerr-irrekarlemeh. ");
INSERT INTO amx_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Arltang arrpenhel Jesu rang town Nain-warn tjeyel alherl-apetjam, kwertengerl kwerenh map-akert. Tjerrtj aningk inehel-arleng alherrerrek. ");
INSERT INTO amx_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Inang town-henh arrew itwek-irremel, inang mer-areny map arek, town-eng arratentj-alherleh. Mer-areny mapel kwer rrwey irrernng renh awenng-warn angetjam. Irrernng-henh mwek rang marl inpert anek. Kwer rrwey arrpenh itja kwer anek. Tjerrtj ltarrp map anthwerr marl inpert kwerel-ayeng alherrerrek. ");
INSERT INTO amx_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Ngkart Jesu-el marl inpert renh arek, rang kwer lharrp-irrek. Rang renh ilek, “Ntwang itja arnetjeh!” ");
INSERT INTO amx_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Inang irrernng-henh intenh-intenh angerl-apek. Jesu rang alhek intenh-intenh kwer-warn, renh iltjang kwerenhel arnpek. Inang ngkernelhetj-alhek. Jesu irrernng kwer-warn angkek, “Artwangay, yengenh awang! Ntwang kemerretjeh!” ");
INSERT INTO amx_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Artwang rang kemerremel anek, angkek-anem. Jesu-el renh ilek, mwek kwerenh-warn alhetjeh. ");
INSERT INTO amx_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tjerrtj inang nhenh aremel inang angerr anthwerr ater-irrek. Inang Altjerr renh kangkemel nakek. Inang lakenh angkerrek, “Altjerrel angketj angenh-angenh tjeperr nwerneh-warn lanthek! Altjerr kwenh nwerneh-warn yatjarr petjek, arntarnt-arerl-anetjeh!” ");
INSERT INTO amx_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Tjerrtj mapel angketj nhenh Jesu-akert ilerl-apek mer Judea ntjaperel, kwer-penh mer arrpenh map-warnemeh, inarl Judea kwereng angath anekarl-warn thwen. ");
INSERT INTO amx_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","John-henh kwertengerl mapel angketj Jesu-akert inang awek. Inang John renh ateng-ilemel ilek. John rang ywarn iterrek Jesu kwer. John rang ahentj-anek, arratjekart awetjeh kwer-penh. Rang kwertengerl kwerenh atherrek ntangkelhek, petjetjeh. Rang renh-atherrenh Jesu-warn lanthek, Jesu renh pawenhetjeh. ");
INSERT INTO amx_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ratherr alherrek Jesu kwer-warn. Ratherr renh pawenhek, “John Kwatjeh Irrpelh-ilenh-ilenhel kwenh ilernenh lanthek ngkweng-warn, ngwenh pawenhetjeh. Ntwang key Christ rang? Altjerrel arrwekel nwerneh-warn lanthetjeh alhelekarl? Nwern apek arrpenhek karelhetjeh?” ");
INSERT INTO amx_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kel yanh kwerel Jesu-el tjerrtj irlkert map-arlk mwerr-iletjam, tjerrtj arlamarr map tjerrtj kwerrern anetj-akert map tjerrtj pweng map thwen. ");
INSERT INTO amx_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jesu-el urrpey renh-atherrenh ilek, “John-warn angkep alperrang angketj nhenh-akert. Renh ateng-ilerl-anerrang, nheng mpwel anngel arerl-anerrekarl-penh. Tjerrtj pweng mapel weth arem. Tjerrtj arlamarr map kemerremel nthwem. Tjerrtj tjwen leprosy map-akert mwerr-irrekarl. Tjerrtj irlpang ahert map weth awem. Tjerrtj irrernng map iteth-irrekarl. Thang angketj mwerr kaltj-antherl-apem tjerrtj rnwanentj-kweny maney-kweny mapeh-arlk. ");
INSERT INTO amx_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Altjerrel tjerrtj inenh kwart-wetjenh, inarl yengenh kwet nakemarleh!” Lakenh Jesu-el renh-atherrenh ilek. ");
INSERT INTO amx_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","John-henh kwertengerl ratherr kel angkep alperrek. Kwer-penh Jesu rang tjerrtj map ilek angketj John-akert. Rang inenh pawenhek, “Wenh-arteh artwang renham arrantherr aretjeh alhek? Artwang angketj kwerenh rang kaltj-anthem kern-penh war yaleng key, irlkel angketj wernem apek? Itja kwenh! ");
INSERT INTO amx_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Artwang ngwenh-arteh rang, arrantherr renh aretjeh alhek? Artwang mantarr amparrkey-amparrkey-akert key? Itja kwenh! John rang mantarr anetj-anetj-akert anek. Tjerrtj ngwenh apek inarl mantarr mwerr-akert anem, inang kwenh mer amparrkey-amparrkeyel anem. Mern ker arwenth anthwerr inang anyenem. John kwenh itja lakenh-arteh anem. ");
INSERT INTO amx_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Altjerr-henh angketj angenh-angenh key arrantherr aretjeh alhek? John rang kwenh Altjerr-henh angketj-akert anem! Rang Altjerr-henh angketj angenh-angenh tjeperr anthwerr anem. ");
INSERT INTO amx_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Angketj John kwer-penh Altjerr-henh pipel-ayeng intem: ‘Thang angketj ilenh-ilenh tjengenh ngkwengeng arrwekel lanthetjenh. Rang ngkweng tjey angerr mpwaretjenh.’ ");
INSERT INTO amx_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“Arrantherr nhenh iterl-aretjeh! Tjerrtj angketj angenh-angenh arrwekeleny inang tjeperr anek. John Kwatjeh Irrpelh-ilenh-ilenh rang kwenh ineheng tjeperr angerr anem. Angketj lyeteny nhenh intem. Lyetarr Altjerr anem Ngkart tjerrtj kwerenh mapek. Lakenheng kwer map inartek John-eng tjeperr angerr-lkwer anem, inang angatheng yengenh iterl-aremarleng wart.” ");
INSERT INTO amx_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Tjerrtj mapel, tax maney kwetjenh-tjenh mapel-arlk thwen ingkerrenyel Jesu renh awek. Inang alhengk-arek, Jesu-henh angketj arratj anemeng. “Ay! Altjerr-henh tjey arratj nwerneh!” Arrwekel inang angketj arratjeh kangkwerremel John-warn alhekarl, rang inenh kwatj-warn irrpelh-ilemel baptise-em-iletjeh. ");
INSERT INTO amx_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Artwang Pharisee map, artwang Moses-henh mpwareng-areng kaltj-anthenh-anthenh map thwen inang itja Altjerreh kangkwerrek. Inang Jesu renh naketj-kwenh. Inang itja John-warn alhek, rang inenh kwatj-warn irrpelh-ilemel baptise-em-iletjeh. ");
INSERT INTO amx_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesu-el tjerrtj map inenh pawenhek, “Wenh-arteham arrantherr anem, arrantherr Altjerrek kangkwerretj-kweny? ");
INSERT INTO amx_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Thang angketj kwek arrantherrenh ilem, arrantherr awetjeh-arlk. Arrantherr kwer alenh map-arteh anem, inarl kethel arrken-irrem. Kwer nyent apek kwer arrpenh mapeh ntangkelhem, lakenh arlkemel, ‘Petjewarrang nwern arrken antheperretjeh-arlk.’ Kwer arrpenh ahentj-kweny-irrek. Kwer-penh kwer rang arrpenh-ingar kwer arrpenh mapeh ntangkelhemel arlkek, ‘Petjewarrang, nwern ltarrp anetjeh tjerrtj ilwekarleng.’ Kwer arrpenh inang itja ltarrp-irretjeh ahentj-anek. Itja kwet. Arrantherr kwer nhenh map-arteh mernelhem. ");
INSERT INTO amx_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","“Thang angketj nhenh keth-iletjeh arrehantherr. John Kwatjeh Irrpelh-ilenh-ilenh rang itja tjerrtj arrpenh map-arteh anek. Rang itja mern arlkwetjart, inteltjant war rang arlkwetjart, itja wine apek antjwetjart. Lakenheng arrantherr angkem, John rang kwel ahert anemeng, arrentj-akert. ");
INSERT INTO amx_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Arrpenh-ingar yeng petjek. Thang mern-arlk arlkwem, wine antjwem. Arrantherr ilem, yeng kwel mern arnterr arlkwenh-arlkwenh anem angwerretj. Yeng wine-arlk arnterr antjwenh-antjwenh kwel anem. Arrantherr yengenh arrampewemel ilem, yeng tax maney kwetjenh-tjenh mapeh-angkwerr tjerrtj anetj arrpenh mapeh-arlk-angkwerr peltj anemeng kwel. ");
INSERT INTO amx_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Tjerrtj inang apek Altjerr-henh angketjeh alhengk-aremel kangkwerrem, inang arratj mernelhetjenharl.” ");
INSERT INTO amx_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Arrpenh-ingar artwang Pharisee nyentel Jesu renh ngwek, kwerel-ayeng mern arlkwetjeh. Jesu rang irrpenhek warl-warn kwen, arrernelhetj-alhek mern arlkwetjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Town nhenhel-ayeng marl nyent arlkwer anek. Marl nhenhel rang awek, Jesu petjekarl artwang Pharisee nheng-henh mer-warn. Marl nhenh anter tjampetel-akert alhek warl kwer-warn. Anter nhenh anek npwang mwerr intjemarl-akert. ");
INSERT INTO amx_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Marl rang artwang Pharisee-henh warl-warn irrpenhek. Rang Jesu-el-ayel ingkern irnetj-alhek arrangkemel. Anngwentj kwerenh Jesu-henh ingkang-warn anyek. Rang ingkang Jesu-henh anngwentj kwerenh-akertel lhewek, anngwentj rrpwarek altang kwerenhel. Rang Jesu-henh ingkang arrantjwek, kwer-penh rang anter thelek ingkang kwerenh-warn, pernekemeh. ");
INSERT INTO amx_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Artwang Pharisee rang aremel iterrek, “Artwang nhenh itjam Altjerr-kenh angketj angenh-angenh anem. Rang iterl-aremer, marl nhenh anetj anthwerr anem. Rang renh anpwemer.” ");
INSERT INTO amx_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesu artwang Pharisee kwer-warn angkek, “Simon-ay, yeng ahentj, angketj kwek war ngkweng iletjeh.” Simon angkek, “Kaltj-anthenh-anthenhay, kel yengenh ilang!” ");
INSERT INTO amx_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jesu-el angketj kwer ilek, “Artwang nyent anek, rang maney arwenth-akert anek. Rang maney artwang atherrek anthek, nyentek maney angerr anthek, arrpenhek maney kwek, kelant ratherr maney angkep anthetj-alpetjenheng. ");
INSERT INTO amx_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Kwer-penh maney kwer-atherr-henh ywerrekarleng, ratherr iltjelay-irrerl-anerrek. Ratherr ywarn maney angkep anthetj-alpek. Artwang rang kel pwekap kwer-atherr-henh rrpwarek. Simon-ay, ntwang yengenh ilang, artwang alenh kwer-atherreng artwang ngwenh apek artwang maney-akert kwer angerr-lkwer kangkentj mernelhek?” ");
INSERT INTO amx_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon-el renh ilek, “Artwang rang kwenh, rang maney angerr inekarl.” Jesu angkek, “Ntwang kel arratj angkek.” ");
INSERT INTO amx_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jesu-el alngarelhemel marl renh arek. Rang Simon renh ilek, “Ntwang marl nhenh arem? Yeng warl ngkwengenh-warn irrpentj-alhek, ntwang yengenh itja kwatj anthek, ingkang lhewelhetjeh. Marl rant ingkang tjengenh anngwentj kwerenhel lhewek, kapert kwerl kwerenhel rrpwarek-arlk. ");
INSERT INTO amx_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ntwang yengenh itja kangkemel arrantjwek. Rant ingkang tjengenh kwet arrantjwerl-anek. ");
INSERT INTO amx_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ntwang itja kapert tjengenh anterel pernek. Rang ingkang tjengenh anter npwang mwerr anthwerrel pernentj-alhek. ");
INSERT INTO amx_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Marl nhenh anetj-akert anekarl. Rang tjeng kangkentj mernelhek, lakenheng Altjerrel anetj kwerenh wek, Altjerr lyet kwer kangkemel anem. Tjerrtj kwerarl Altjerrel anetj kwek wekarl, rang kwek wararl Altjerr kwer kangkem.” ");
INSERT INTO amx_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jesu-el marl renh ilek, “Kewenyay, ntwang anetj-akert anek. Altjerrel anetj ngkwengenh ingkerreny wekarl, rang ngkweng kangkentj mernelhem kwet.” ");
INSERT INTO amx_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Tjerrtj arrpenh map inarl mernek ankey petjekarl, inang lakenh pawenherrek, “Artwang nhenh nthakenh rang tjerrtj map-henh anetj wem? Artwang ngwenham yanh rang? Rang kwel Altjerr-arteh anem!” ");
INSERT INTO amx_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Jesu-el marl renh ilek, “Ntwang yengenh nakekarl, Altjerrel ngwenh anetjeng arntarnt-aremel mwerr-ilek, ntwang ngampekarl iteth anetjenh. Arrkenemeh alpang!” ");
INSERT INTO amx_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kwer-penh Jesu rang nthwerl-apetjam mer map-warn, town kwek map-warn town angerr map-warn thwen. Rang tjerrtj map angketj mwerr kaltj-antherl-apetjam, angketj Altjerr rang kel tjerrtj ingkerrekeh Ngkart angerr anemeng. Kwertengerl 12 inang kwerel-ayeng nthwerl-apetjam. ");
INSERT INTO amx_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Marl rrpwetj war inehel-ayeng alhek, inang irlkert-penh mwerr-irrekarl. Marl rrpwetj arrpenh inang kwerrern anetj-akert anekarl-penh, marl nhenh inang kel mwerr-irrekarl. Marl nyent anek Mary Magdalene, kwerengarl arrpenhel arrentj 7 anpwekarl. ");
INSERT INTO amx_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Marl arrpenh anek Joanna, anew kwerenh Chuza. Chuza rartek King Herod-kenh rrkwapenh-apenh mapeh arntarnt-arenh-arenh anek. Marl arrpenh anek Susanna. Marl nhenh inang maney inehenhel mern-arlk payem-iletjart, Jesu kwertengerl kwerenh map thwen arntarnt-arerl-anetjeh. ");
INSERT INTO amx_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tjerrtj map anthwerr inang Jesu kwer-warn arraw-irrentj-alhek, town mapeng. Jesu-el inenh angketj nhenh kaltj-anthek, ");
INSERT INTO amx_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Artwang nyent alhek mern anngang map-akert yakwethel-ayel, mern anngang werl-apetjeh, mern atherrk map mangketjenheng. Rang mern anngang werl-apetjam, anngang arrpenh map tjey-warn wek. Tjerrtjel inenh ingkel lthwek. Thep mapemeh petjek, mern anngang inenh arlkwek. ");
INSERT INTO amx_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Mern anngang arrpenh map ahelh irntangerr-arleh wek. Anngang nhenh inang kwek war mangkek. Aherrk rang arratemeng, aherrkel mern akwerrk inenh antjerrk-ilemel ampek, kwatj-kwenh-antey. ");
INSERT INTO amx_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Mern anngang arrpenh map lyek mpwep-warn wek. Mern lyek thwen ratherr pwert kwet lyapek. Lyekel mern renh anetj-ilek. ");
INSERT INTO amx_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Kel mern anngang arrpenh map ahelh mwerr-warn wek. Mern inang lyapek, ngwerrm-akert-irrek. Mern arrpenh anngang nyent-penh mern ngwerrm 100-arl arratek.” Jesu-el inenh arnterrel ilek, “Arrantherr kwenh irlpang-atherr-akert anem, arrantherr angketj nhenh awerrerrang!” ");
INSERT INTO amx_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Kwertengerl kwerenh mapel renh pawenhek, “Nwern itja angketj nhenh iterl-arem! Nwernenh kaltj-anthang, nwern kaltj anetjenheng!” ");
INSERT INTO amx_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesu-el inenh ilek, “Thang arrantherrenhant nhenh-penh kaltj-anthem, arrantherr angketj nhenh alhengk-aretjeh, Altjerr kel petjekarl, tjerrtj ingkerrekeh mernelhetjeh, rang Ngkart angerr anemeng. Tjerrtj arrpenh map inarl itja peltj tjengenh anemeng, thang inenh itja kaltj-anthetjenh, thang angketj war ilem. Yeng ineh-penh angkem, ‘Inang aretjenh, inang itja alhengk-aretjenheng. Inang angketj tjengenh awetjenh, inang angketj itja alhengk-aretjenheng.’ Angketj lakenh Altjerr-henh pipel-ayeng intem.” ");
INSERT INTO amx_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Thang angketj renh arrehantherr keth-ilemel ilem. Anngang inang Altjerr-henh angketj anem. ");
INSERT INTO amx_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Mern anngang nhenh map inang tjey-arleh wek, nhenh kel tjerrtj map-arteh anem, inarl Altjerr-henh angketj awem-amparr. Inang angketj awem-arteh, arrentjel angketj renh rakemel inehetj angem. Inang Altjerr renh nakehetjeng, Altjerrel inenh anetjeng inehetjeng. Lakenh-arteh thep mapel mern anngang inenh arlkwek. ");
INSERT INTO amx_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mern anngang nhenh map ahelh irntangerrarl wek, nhenh kel tjerrtj map-arteh anem, inarl angerr kangkem, Altjerr-henh angketj awetjeh. Lakenh-arteh anem tjerrtj nheng anetj mapeh: Altjerr-henh angketj ywarn irrpem iterrentj inehenh-warn. Artekerr inang ahelh-warn ywarn irrpem, lakenh-arteh Altjerr-henh angketj itja irrpem iterrentj inehenh-warn. Inang angketj kwer parrp war angwerrem. Lakenh inang Altjerr renh itja twerel nakem. Tjerrtj arrpenh mapel apek inenh arrkentj-ilem, inang kel Altjerreng ntjwem-irretjenh. ");
INSERT INTO amx_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Mern anngang inang lyek mpwep-warnarl wek, inang tjerrtj map-arteh anem, inarl Altjerr-henh angketjeh kangkwerrem-amparr, kwereng inang mantarreh arrkeneh maneyeh-arlkant war angerr kwet iterretjenh, inang Altjerreh angwerretjenh. Inang itja kwet rrkwapentj mwerr mpwarem Altjerrek. ");
INSERT INTO amx_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Mern anngang map ahelh mwerr-warn-arleh wek, nhenh kel tjerrtj map-arteh anem: tjerrtj inarl Altjerr-henh angketj awem, angketj kwer kwet kangkwerrem. Inang arratj mernelhem tjerrtj mapeng ularr. Mern inang lyapek, ngwerrm-akert-irrek. ");
INSERT INTO amx_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Kwenyel tjerrtjel alngenth item, keth aretjeh. Tjerrtjel ngwenhel apek rwang alngenth itemel, rang rwang alngenth warl-warn kwen angemeng, rang itja alngenth tjampetel artem, rang itja antjam-warn-arlk kweneng arrernem alengk-wemel. Rwang alngenth ilwernelhehetj, rang aretj-kweny anehetj. Rang rwang alngenth renh kerneh arrernetjenh ampetjeh, tjerrtjel keth aretjenheng. ");
INSERT INTO amx_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Tjerrtjel ngwenhel apek angketj alengk-wem, kelant Altjerrel angketj inehenh keth-ilemel iletjenh, tjerrtj arrpenh mapel angketj renh awetjenheng. ");
INSERT INTO amx_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Awerrerrang mantjel! Arrantherr itja Altjerr-henh angketj war awerl-anetjeh arrkenel, arrantherr arratj awemel kaltj-irretjeh. Tjerrtj inarl Altjerr-henh angketjeh irlparethel awem, Altjerr-henh angketjeh angerr anthwerr kaltj-irretjeh ahentj-anem, renh Altjerrel wetham kaltj-anthetjenh. Tjerrtj arrpenh inarl ahentj-kweny-irrem Altjerr-henh angketjeh, inarl Altjerr-henh angketj kwek apek anyenem iterrentj inehenhel-ayeng, inenh Altjerrel iterrentj inehenh perrpert-iletjenh.” ");
INSERT INTO amx_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesu-kenh mwek tjeyekw kwerenh map thwen inang kwer-warn petjek, renh aretjeh. Inang ntwarr irnetj-alhek, tjerrtj map anthwerreng. ");
INSERT INTO amx_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Tjerrtj inarl Jesu-el-ayeng anemeng, inang renh ateng-ilek, “Mwek ngkwengenh tjey ngkwengenh map inang ngkweng karelhem, ngwenh aretjeh.” ");
INSERT INTO amx_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesu-el inenh pawenhek, “Tjerrtj ngwenh apek inarl Altjerr-henh angketjeh kangkwerremel awem, inang kwenh tjerrtj arlaltj tjengenh map anem, mwek tjengenh tjey tjengenh apek.” ");
INSERT INTO amx_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Arltang arrpenhel Jesu-el kwertengerl kwerenh map ilek, “Mpa, boat-warn antjerrerrang! Nwern itep arrengakw-warn alhetjeh!” Kel inang boat-eh antjemel alhek. ");
INSERT INTO amx_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Inarl boat-el alhetjam-rlwer, Jesu rang ankwa irrenhek, parrk anthwerr. Inang kwenp alhek, irlkang angerr petjek, inenh irlkang angerrel atwentjek. Kwatjemeh boat kwer-warn-athek thelelhentj-alhek. Inang kel ilwetjeh irrek. ");
INSERT INTO amx_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Kwertengerl map inang Jesu kwer-warn alhek, inang renh kemelh-ilek. “Ngkartay! Kwatj angerrel nwernenh atwem, nwern ingkerrek ilwehetjeng!” Jesu kemerrek, rang irlkang renh kwatj alay thwen ilemel atjernpelh-ilek. Irlkang parrp war ywerrenhek, kwatj kwek-irremel atjernp-irrenhek. ");
INSERT INTO amx_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Jesu-el kwertengerl inenh ilek, “Thang kwenh arrantherrenh arntarnt-arem! Arrantherr kwenh yengenh nakemer!” Inang angerr anthwerr ater-irrek. Inang pawenherrek, “Ngwenham artwang nhenh? Irlkang kwatj alay thwen kwer kangkwerrem!” ");
INSERT INTO amx_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Inang boat-el alhek kwatj alay iter ingerr-warn, mer Gerasa kwer-warn, arrengakw mer Galilee-eng. ");
INSERT INTO amx_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesu boat-eng arnkarr iterel anarnpek, artwang arrentj map-akert kwer-warn arnek-irretj-alhek. Artwang rang mer-areny anek. Rang kel ngkweyeng-ntjel anthwerr mantarr-kwenh nthwerl-apetjart. Rartek itja warlel anek, rang mer kwerenh tjerrtj irrernng map-henh awenng mpwepel mpwarekarl. ");
INSERT INTO amx_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Mer-areny mapel renh chain-el ayernetjart, iltjang atherr kwerenh ingkang thwen. Arrentj-artek artwang nhenh kwer-warn angkep irrpetjart, renh twer-ilemel. Rang chain inenh ltwaketjart, kwereng arrentjel renh werrk-warn angetjart. Jesu-el renh arek, rang arrentj renh iltek, “Kwereng arratay!” Artwang rang Jesu kwereng ularr kelkertel-ayeng arrernelhek. Rang arnterr arlkemel ilelhek, “Jesu-ay! Altjerr angerr-henh Leray! Wenheh ntwang nhenh-warn petjek? Ntwang yengenh itja atwetjeh!” ");
INSERT INTO amx_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesu-el renh pawenhek, “Wenham arreny ngkwengenh?” Artwang rang kwer ilelhek, “Yeng arreny map-akert anem!” Arrentj map kwer-warn irrpekarleng wart. ");
INSERT INTO amx_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Arrentj inang Jesu pawenhek, rang inenh itja mer rwang anganentj-warn lanthetjeh. ");
INSERT INTO amx_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Irntang angath-antey anek pek-pek mapel irntang iterel atherrk arlkwetjam. Arrentj inang Jesu renh pawenhek, inenh impetjeh, inang pek-pek map-warn irrpetjeh. Kel Jesu-el inenh mentj impek. ");
INSERT INTO amx_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Arrentj map artwang kwereng arratemel pek-pek ineh-warn irrpek. Pek-pek inang ahert-irremel arrtjanemel kwatj-warn anyerl-alhek, inang kwatj kwenel ilwek. ");
INSERT INTO amx_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Artwang pek-pek arntarnt-arenh-arenh mapel inenh arek, inang mer kwek map-warn arrtjanek, angketj ilerl-apetjeh. ");
INSERT INTO amx_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Mer-areny map petjewarrek aretjeh. Inang Jesu-warn itwek-irremel artwang nhengemeh arek. Artwang rang iterrentj mwerr-akertemeh anek, mantarreh-arlk irrpekarl. Tjerrtj inang aremel ater-irrek. Inang iterrek, “Nthakenham artwang nhenh mwerr-irrek?” ");
INSERT INTO amx_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Kwer-penh tjerrtj inarl arentjekarl-penh, inang angketj artwang kwer-akert inenh ilek. ");
INSERT INTO amx_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tjerrtj mer-areny ingkerrek Jesu-warn petjewarrek. Inang renh pawenhek, rang ineheng alhetjeh. Inartek kwereng angerr anthwerr ater-irrek. Jesu rang ineh kangkwerremel boat-warn antjek. ");
INSERT INTO amx_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Artwang mwerr-irrekarl rang Jesu renh twer-irremel pawenhek, kwerel-ayeng alhetjeh. Jesu-el artwang renh lthwelth-ilek, ");
INSERT INTO amx_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Peltj ngkwengenh map-warn alpay! Ineh ilelhang, Altjerrel ngwenh mwerr-ilekarl.” Kwer-penh artwang rang town-warn alhek, tjerrtj ingkerrekeh kwewaleny ilelherl-apetjam, Jesu-el renh mwerr-ilekarl-penh. ");
INSERT INTO amx_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesu kwatj-angkwerr boat-el angkep alpek. Tjerrtj aningk kwer kangkemel arnek-irrek, inang kwer arrwekel karelhetjam. ");
INSERT INTO amx_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Artwang nyent petjek, kelkertel-ayel Jesu-eng ularr arrernelhek. Arreny kwerenh Jairus, rang church-areny twernk anek. Jairus rang renh pawenhek, “Jesu-ay, petjay warl tjengenh-warn! Ler marl tjeyenh irlkert angerr intem, ilwetjeh irrem.” Ler marl nyentant kwerenh 12 years old anek. Jesu rang alhek Jairus kwerel-ayel. Tjerrtj aningk kwer-atherrel-ayeng alhek, inang renh ngkwal angkert-wek. ");
INSERT INTO amx_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Tjerrtj mapel-ayeng marl nyent anek, rang 12 years irlkert angerr anek. Rang alhetjart ngangkar-warn, inang renh ywarn mwerr-ilek. Rang maney-kweny anek, maney kwerenh ingkerrek rang ngangkar-akert mapeh anthetjart, renh mwerr-iletjeh kwel. ");
INSERT INTO amx_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Marl rang Jesu-warn ingkerneng petjek. Rang Jesu-henh mantarr arnpek. Rang mwerr-irrerl-alhek. ");
INSERT INTO amx_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesu-el tjerrtj map pawenhek, “Ngwenhelam yengenh arnpek?” Tjerrtj ingkerrek inang ilelhek, “Itja”. Peter angkek, “Ngkartay, tjerrtj aningkel kwenh ngwenh pewerl-apem, ntwang mpwepel!” ");
INSERT INTO amx_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jesu-el inenh ilek, “Nyentel kwenh yengenh arnpek. Yeng-artek awelherl-alhek, twer tjengenh arraterl-alhek.” ");
INSERT INTO amx_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Marl rang alhengk-arek, rang ywarn Jesu-eng alengk-welhek. Rang Jesu kwer-warn arrewemel petjek, rang kelkertel-ayeng arrernelhetj-alhek. Rang anngetherr ilelhek, “Yeng kwenh! Thang kwenh mantarr ngkwengenh arnpek, yeng irlkert angerr anekarleng wart ngkweyeng-ntjel. Yeng kel mwerremeh awelhem.” ");
INSERT INTO amx_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesu-el renh ilek, “Marlay, ntwang yengenh nakek, yeng twer angerr anem. Lakenheng Altjerrel ngwenh mwerr-ilekarl. Kel arrkenel alpay!” ");
INSERT INTO amx_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Kwereng artwang urrpey petjek angketj anetj-akert twernk Jairus-kenh mereng. Rang Jairus renh ilek, “Ler ngkwengenh kel ilwek. Kaltj-anthenh-anthenh renh mentj impay, rarrp alhetjeh.” ");
INSERT INTO amx_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesu rang angketj nhenhek itja kangkwerrek. Rang Jairus renh ilek, “Ntwang itja ater-irretjeh. Kel yengenh nakang, kwereng marl ler ngkwengenh mwerr-irretjenheng.” ");
INSERT INTO amx_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kwer-penh Jesu rang Jairus-kenh warlek irretj-alhek. Rang tjerrtj arrpenh map arnpakemel ilek, “Arrantherr arrwekel karelhang. Thang ngwerl-alhemarleng Peter, John, James, marl kwerenh angey mwek inenhant.” Kel Jesu ineh-akert Jairus-henh warl-warn irrpek. ");
INSERT INTO amx_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tjerrtj ingkerrek marl kwer akay arnetjam. Rang inenh ilek, “Arrantherr itja arnetjeh. Kwer nhenh itja ilwek. Rang ankwang angerr war intem.” ");
INSERT INTO amx_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Inang renh awemel atherrek. Inang kaltj anek, marl rang ilwekarl. ");
INSERT INTO amx_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jesu-el kwer marl irrernng iltjang antwerrkemel renh ilek, “Kwer marlay, kemerray!” ");
INSERT INTO amx_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Kwerrern kwerenh petj-alpek, rang kel kemerrekemeh. Jesu-el inenh ilek, marl kwer mern anthetjeh, rang arlkwetjeh. ");
INSERT INTO amx_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Angey mwek kwerenh thwen kel anwerlkemel kangkek. Jesu-el renh-atherrenh arnpakemel ilek, ratherr itja tjerrtj arrpenh mapeh nhenh-penh iletjeh. ");
INSERT INTO amx_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Kwer-penh Jesu-el kwertengerl kwerenh map arrawelh-ilek. Rang inenh twer-ilek, arrentj map tjerrtjeng anpwetjeh, tjerrtj irlkert map mwerr-iletjeh thwen. ");
INSERT INTO amx_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Kwer-penh rang inenh lanthek, tjerrtj map ilerl-apetjeh, Altjerr tjerrtj ingkerrekeh Ngkart angerr anemeng. Inang tjerrtj irlkert map mwerr-iletjeh. ");
INSERT INTO amx_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Rang inenh ilek, “Arrantherr itja tjeyek wenh apek angerl-apetjeh. Itja anem itja yakweth itja mern itja maney itja mantarr angerl-apetjeh. ");
INSERT INTO amx_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Arrantherr apek mer arrpenheh irretj-alhemeng, merek-artweyel apek arrantherrenh ntangkem, inehel-ayeng kwet irretjeh, kel mwerr warl nyent kwerenhel intetjeh, arrantherr mer-areny inenh kaltj-anthemarleng. Itja warl arrpenh-warn ahentj-irremel apek alhetjeh. Kwereng arrantherr town arrpenh-warnemeh anper irretjeh. ");
INSERT INTO amx_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Arrantherr town arrpenh-warn alhemeng, tjerrtj inang apek arrehantherr ahentj-kwenyeng, kel town kwereng anper-alherrerrang. Ahelh ulmernt ingkang arrehantherr-henheng lernelherrerrang, kelemeh alherrerrang. Lakenh arrantherr mernelhem, inang iterl-aretjeh, Altjerr ahang-irrem ineh.” Lakenh Jesu-el kwertengerl inenh rang ilek. ");
INSERT INTO amx_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Kwertengerl inang kel alhekemeh. Inang town arrpenh map-warn alhek, angketj mwerr tjerrtj ineh ilerl-apetjeh, tjerrtj irlkert map mwerr-ilerl-apetjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","King Herod rang angketj Jesu-akert awek. Rang ywarn iterrek. Arrpenh mapel renh ilek, Altjerrel kwel John Kwatjeh Irrpelh-ilenh-ilenh renh irrernngeng kemelh-ilekarl. ");
INSERT INTO amx_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Tjerrtj arrpenh map angkerrek, “Angketj angenh-angenh nheng Elijah-arteh rang kwel alkereng angkep petj-alpek nwerneh-warn!” Tjerrtj arrpenh mapemeh angkerrek, “Altjerr-henh angketj angenh-angenh ngkweyeny-arteh kwel irrernngeng kemerremel angkep petj-alpek.” ");
INSERT INTO amx_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Lakenheng King Herod-elemeh ywarn iterl-aremel inenh pawenhek, “Thang nheng atwenh-atwenh map twernek, inang John renh ntjwang rlweth-atwemel irrernng atwek. Ngwenham artwang nhenh rang lakenh mpwarerl-apem? Thang renh aretjeh-amparr!” ");
INSERT INTO amx_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Arltang arrpenhel Jesu-henh kwertengerl map angkep petj-alpek kwer-warn. Inang kel mer mapel Altjerr-henh angketj kaltj-antherl-apetjamarl-penh. Inang ilelhetj-alpek Jesu kwer, inarl twerel mpwarerl-apetjamarl-penh. Inang arrentj map anpwek tjerrtj irlkert mapeng, arrpenh map inenh mwerr-ilek. Kwer-penh Jesu kwertengerl ineh-akert alhek mer Bethsaida-warn, inarrp anetjeh. ");
INSERT INTO amx_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Tjerrtj mapel awek, Jesu Bethsaida-warn alhekarl, inang kwer ingkern-angkwerr alhek. Jesu-el tjerrtj inenh arnarek, rang ineh-warn arnekarner alhek. Rang inenh kaltj-anthetjam, Altjerr kel tjerrtj ingkerrekeh Ngkart angerr anemeng. Rang irlkert map mwerr-ilerl-apetjam. ");
INSERT INTO amx_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Kel angwerr-angwerr irrek. Kwertengerl map Jesu-warn petjemel renh ilek, “Nwern kwenh mern-kweny anem rrkwalel! Ntwang tjerrtj nhenh map kel lanthay, town kwek map-warn alhetjeh, mern inetjeh, merel intetjeh thwen.” ");
INSERT INTO amx_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jesu-el kwertengerl inenh ilek, “Kel arrantherr ineh mern antherrerrang.” Inang renh ilek, “Nwerneh kwenh mern 5 intem, irrpenng atherram thwen. Ntwang ahentj key, nwern mern-arlk shop-eng inerl-alpetjeh, nhenh map wantetjeh-anngernt?” ");
INSERT INTO amx_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Artwang 5,000-artek anek. Jesu-el kwertengerl kwerenh map ilek, “Arrantherr tjerrtj inenh ilerrerrang, inang arrernelhetjeh. Inenh ngakemel arrernetjeh, arrpenh map 50, arrpenh map 50, lakenh mpwarewarrang.” ");
INSERT INTO amx_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Kwertengerl inang kel tjerrtj map ilek arrernelhetjeh. Tjerrtj inang kel arrernelhekemeh. ");
INSERT INTO amx_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jesu-el mern 5 inenh irrpenng atherr thwen inek, alker-warn-athek kern-arntep arnaremel, rang Altjerr kwer kangkemel angkek. Kwer-penh rang mern irrpenng thwen inenh ltwakek. Rang ngkweltj map kwertengerl mapeh anthek, kwertengerl mapel tjerrtj mapeh irrarnpelh-iletjeh. ");
INSERT INTO amx_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Kel tjerrtj ingkerrekel arlkwekarl-penh inang anhwerlkemeh anek. Ingkernemeh inang mern ampeny-ampeny inenh kwetjemel 12 yakweth-warn arrernek. Mern angerremeh intek. ");
INSERT INTO amx_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Arrpenh-ingar Jesu rang nyent-areny anetjam, rang Angey kwerenh-warn angkek. Kwer-penh kwertengerl kwerenh map inang kwer-warn angkep arraw-irrek. Rang inenh pawenhek, “Ngwenham yeng? Nthakenham tjerrtj map tjeng-penh angkerrem?” ");
INSERT INTO amx_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Kwertengerl inang renh ilek, “Tjerrtj arrpenh mapel ilem, ntwang kwel John Kwatjeh Irrpelh-ilenh-ilenh rang irrernngeng angkep kemerrentj-alpek. Tjerrtj arrpenh mapel ilem, angketj angenh-angenh nheng Elijah kwel ntwang angkep petj-alpek alkereng. Tjerrtj arrpenh mapel ilem, Altjerrel angketj angenh-angenh ngkweyeny arrpenh irrernngeng iteth-ilekarl kwel.” ");
INSERT INTO amx_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Jesu-el inenh pawenhek, “Arrantherr-arteh? Arrantherr tjeng-penh nthakenharl iterl-arem? Ngwenham yeng?” Peter-el renh ilek, “Ntwang kwenh anem Altjerr-henh Christ anthwerr rang, Altjerrel ngkwey alhelekarl, nwerneh-warn lanthetjenharl.” ");
INSERT INTO amx_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jesu-el inenh arnpakek, inang tjerrtj arrpenh map itja iletjeh, rang Christ anemeng. ");
INSERT INTO amx_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kwer-penh Jesu rang ilelhek, “Tjerrtj-henh Ler kwer anem, irlkert angerr inetjeh, nakepakel-irretjeh. Angerrepat map, ngkart priest angerr map thwen, kaltj-anthenh-anthenh map thwen inang kwer ahentj-kwenh-irretjenh. Renh inang artwang merrentj-artek anpwetjenh, inang renh irrernng atwetjenh. Rang kweny atherr-penh irrernng intentj-penh rang angkep iteth kemerretjenh.” ");
INSERT INTO amx_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jesu-el tjerrtj ingkerrek ilek, “Tjerrtj apek ahentj-anem tjengel-ayel ingkern-angkwerr petjetjeh, nthakenhameh rang mernelhetjenh? Rang iterrentj anetj kwerenheh itja weth kangkwerretjeh. Inang yengenh atwetjenh arrampewemel. Lakenh tjerrtj rang anetjeh yeng-arteh. Rang kweteth mpatj tjengenh ingkentetjeh. ");
INSERT INTO amx_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tjerrtj ngwenh apek rarl athek-irrem iteth kwet anetjeh, rang kel ilwetjenh. Tjerrtj ngwenh apek rarl yengenh awem, angketj tjengenheh kangkwerrem, iterrentj kwerenheh angwerremel, rant kwenh iteth anetjenh. ");
INSERT INTO amx_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Tjerrtjel ahelh nhenhel maney angerr-akertel mantarr-arlk arwenth arlwelem, Altjerr renh iterl-aretj-kwenhel, rang kwenh ilwetjenh. Rang kwerrern kwerenh parlp-iletjenh, rang itja iteth kwet anetjenh. ");
INSERT INTO amx_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Tjerrtj ngwenh apek inarl nyerr-irrem, tjerrtj arrpenh mapek angketj tjengenh ilerl-apetj-kwenh, tjerrtj nhenh inang kelant nthakenh irretjenh? Kelant Tjerrtj-henh Ler rang petj-alpemeng, rang tjerrtj ineheng ntjwem-irretjenh. Wenh-arteh rang petj-alpetjenh? Rang angel alker-areny kwerenh map-akert parrtj arrpenh anthwerr-akert petj-alpetjenh. ");
INSERT INTO amx_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Arratj anthwerr, tjerrtj arrpenh map inang lyet nhenhel irnem, inang itja ilwetjenh. Inarl iteth anem, inang keth aretjenh, Altjerr rang tjerrtj ingkerrekeh Ngkart angerr anemeng.” ");
INSERT INTO amx_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Arltang 8-penh Jesu-el Peter John James thwen ngwek. Rang ineh-akert irntang kern-warn antjenhek, inang Altjerr-warn angketjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jesu Altjerr-warn angketjamarleng, inngerr kwerenh angart-welhek, mantarr kwerenh mperlker anthwerr irrek. ");
INSERT INTO amx_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Artwang atherr Moses Elijah ratherr ngwerrm-irretj-alhek, Jesu-el-ayel angkerl-anerretjam. Ratherr parrtjek. Inang pwert kwet angkerretjam, “Lyet-antey ntwang Jerusalem-el nakepakel-irretjenh, alker-warn ntwang alpetjeh-anngernt.” ");
INSERT INTO amx_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Peter map-artek kel ankwa irretjam, kwereng inang karr-irremel Jesu renh arek, parrtj anthwerr-akert irnerleh, artwang atherr nhengel-ayel. ");
INSERT INTO amx_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Moses Elijah ratherr Jesu-el-arleng angkerrekarl-penh, ratherr lyet-atheh ywerrerl-apetjam. Peter-el Jesu renh ilek alhengk-aretj-kwenhel, “Kaltj-anthenh-anthenhay! Nwern kangkem, nhenhel anerl-anetjeh! Nwern mer lywang rrpwetj artetjeh, ngkweng nyent, Moses-eh nyent, Elijah-eh nyent.” ");
INSERT INTO amx_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Peter rang angketjamarleng, ankertelemeh inenh arltwetj-alhek. Kwertengerl inang angerr anthwerr ater-irrek. ");
INSERT INTO amx_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Altjerremeh ankert kweneng angkek, “Nhenh Ler tjengenh. Rang tjeperr tjeyenh anem! Arrantherr kwer kangkwerretjeh!” ");
INSERT INTO amx_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kwer-penh kwertengerl mapel Jesu nyentemeh irnerleh arek. Inang itja tjerrtj arrpenh map ilek, nheng inarl arekarl-penh. ");
INSERT INTO amx_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kel arltang arrpenhel, Jesu kwertengerl rrpwetj nheng thwen irntangeng anarnpetj-alhek. Tjerrtj aningk Jesu kwer-warn arnek-irrek. ");
INSERT INTO amx_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Artwang nyentel renh pawenhek, “Kaltj-anthenh-anthenhay! Kwer rrwey tjengenh mwerr-ilang! Rang kwenh kwer nyentant tjengenh anem! ");
INSERT INTO amx_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Kwerrern anetj kwer-warn irrpentj-alhem, kwer rang ater arlkerl-alhem, rang arrewem, arrakert kwerenhemeh rlkwerrp-rlkwerrp irrem. Kwerrern anetjel renh parrk-parrk anthem. ");
INSERT INTO amx_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Thang kwertengerl ngkwengenh map pawenhek, inang kwerrern anetj renh kwer tjengenheng anpwetjeh. Inang kwerrern anetj renh ywarn kwet anpwek.” ");
INSERT INTO amx_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesu-el inenh ilek, “Arrantherr-artek nakentj-kwenh itja, kweteth pal iterrem! Yeng-artek arrehantherrel-ayeng kwet anthwerr anek, arrantherrenh kaltj-anthetj-alhek. Arrantherr-artek yengenh parrk-parrk-ilem! Artwangay, kwer ngkwengenh renh tjeng-warn angetjang!” ");
INSERT INTO amx_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kwer renh inang angetjewarremarleng, kwerrern anetjel kwer rrwey renh ahelh-warn ilatwek. Kwer rrwey rang ahelhel arrewek. Jesu-el kwerrern anetj renh arnpakemel ilek, rrwey renh mwerr-ilek. Kwer-penh rang renh angey kwerenh-warn anginek, mwerremeh. ");
INSERT INTO amx_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Tjerrtj inang anwerlkek, Altjerr rang twer anemeng wart. Jesu rang kwertengerl kwerenh map ilek, ");
INSERT INTO amx_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Mantjel awerrerrang, angketj tharl arrantherrenh iletjenharl. Tjerrtj-henh Ler renh artwang nyentel anthetjenharl artwang anetj mapeh.” ");
INSERT INTO amx_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kwertengerl mapel Jesu-henh angketj alhengk-aretj-kweny anek, Altjerrel angketj nhenh ineheng alengk-wekarleng. Inang ater-irrek, renh angketj kwer-penh pawenhetjeh. ");
INSERT INTO amx_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kwertengerl inang lakenh pawenherrek, “Ngwenham twernk nwerneheng nyent anemer?” ");
INSERT INTO amx_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesu rang kel iterrentj inehenhek kaltj anek. Rang kwer kwek ngwek, kwer rang kwerel-ayeng pwert irnek. ");
INSERT INTO amx_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Kwer-penh rang inenh ilek, “Tjerrtj ngwenh apek rarl kwer kwek nhenheh kangkentj mernelhem, yeng iterl-aremel, rang tjeng thwen kangkentj mernelhem. Tjerrtj ngwenh apek inarl tjeng kangkentj mernelhem, inang Altjerrek kangkentj mernelhem. Altjerrel yengenh lanthekarl. Tjerrtj nyent apek arrehantherreng tjwenelhetj-kweny anem, rang kwenh angerr anthwerr anetjenh.” ");
INSERT INTO amx_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","John-el Jesu renh pawenhek, “Kaltj-anthenh-anthenhay! Nwern artwang nyent arek, kwerrern anetj map tjerrtjeng anpwerleh, arreny ngkwengenh ilemel. Rang itja nwernehel-ayeng anem, lakenheng nwern renh arnpakek.” ");
INSERT INTO amx_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesu-el renh ilek, “Ntwang renh itja arnpaketjeh. Tjerrtj ngwenh apek inarl itja arrehantherr ahang-irrem, inang kwenh peltj arrehantherr-henh anem.” ");
INSERT INTO amx_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jesu kwer arltang angathemeh anek, alker-warn alpetjeh-anngernt. Jesu rang iterrentj nyent-akert anek, Jerusalem-warn alhetjeh. ");
INSERT INTO amx_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Rang tjerrtj rrpwetj lanthek arrwekel, town kwek nyent-warn Samaria-warn, inang mer renh aretjeh, inang intetjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Jesu rang anper Jerusalem-warn alhemeng, mer-areny map inang Jesu kwer ahentj-kweny anek. ");
INSERT INTO amx_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Kwertengerl akenheng-atherrel James John-el thwen inenh aremel Jesu renh pawenhek, “Ngkartay! Ntwang ahentj-anem key, nwern Altjerr pawenhetjeh, rang rwang alkereng lanthetjeh, tjerrtj nhenh map ampetjeh?” ");
INSERT INTO amx_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesu-el alngarelhemel renh-atherrenh iltek, mentj impetjeh. ");
INSERT INTO amx_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Inang anper alhek intetj-kweny, tjerrtj anetj mapeng wart. Inang mer arrpenh-warn alhek. ");
INSERT INTO amx_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Inang tjeyel alherl-apetjam, artwang nyentel Jesu renh ilek, “Mer kwer-warn ntwang alhetjenh, yeng kel ngkwengel-ayeng anharrel alhetjenh!” ");
INSERT INTO amx_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesu-el renh ilek, “Thang angketj kwek war ilem ngkweng. Angwely arnwer-henh alhweng anem. Thep-henh antjwang kwek artelhem. Tjerrtj-henh Ler rang warl-kwenyarl anem, ankwang intetjeh apek. Ntwang arratj anthwerr tjengel-ayeng petjetjenh key?” ");
INSERT INTO amx_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesu-el artwang arrpenh ngwek, “Tjengel-ayeng anharrel petjang!” Artwang rang tjernemel angkek, “Arrwek-amparr thang angey tjeyenh-amparr parlp-iletjeh. Yeng alpetjeh-amparr, thang renh arntarnt-arerl-anetjeh. Kwer-penhant yeng ngkwengel-ayeng alhetjenheng.” ");
INSERT INTO amx_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesu-el renh ilek, “Tjerrtj nakentj-kweny map impay, inarrp arntarnt-arerretjeh, irrernng inehenh awenng-warn arrernetjeh apek. Ntwang petjang, ngkweng tjeperr anem, tjerrtj arrpenh map iletjeh, Altjerr tjerrtj ingkerrekeh Ngkart angerr anemeng.” ");
INSERT INTO amx_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Kwer-penh artwang arrpenhel Jesu renh ilek, “Ngkartay! Yeng ahentj ngkwengel-ayeng alhetjeh! Arrwek-amparr, thang peltj tjengenh map-amparr twap-antherl-alpetjeh.” ");
INSERT INTO amx_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesu-el renh ilek, “Tjerrtj ngwenh apek inarl tjengeng anharrel-ayeng petjetjeh ahentj-anem, inang itja yeng kelekant impetjeh. Inang yengant war arrwekel arrernetjeh. Tjerrtj ngwenh apek rang alngarelhem, rang itja rrkwapenh-apenh arratj anem Altjerreh.” ");
INSERT INTO amx_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ngkart Jesu-el angketj irlpwengerr-ngerr ilekarl-penh rang nakenh-nakenh 72 urraremel ngwek. Rang inenh lanthek, town map-warn mer map-warn thwen alhetjeh. Rang inenh atherrek-atherr kwet lanthek, kwereng arrwekel alhetjeh. ");
INSERT INTO amx_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Rang inenh ilek, “Awerrerray, tjerrtj map anthwerr kwenh Altjerr-henh angketj awetjeh karelhem. Ngwenhel inenh iletj-alhetjenh? Inang mern katjerr ampeng map-arteh anem, kenh arrpenhel mern katjerr aketjeh-anngernt-arteh anem, mpank. Ngwenhelam tjerrtj inenh ngwetjeh apek Altjerr-warn? Altjerr rang ahentj-anem, inang angketj kwerenh awemel kaltj-irretjeh. Kaltj-anthenh-anthenh inang rrpwetj war anem. Lakenheng arrantherr Ngkart renh pawenhetjeh, rang kaltj-anthenh-anthenh arrpenh map-arlk lanthetjeh, inang tjerrtj map Altjerr-warn twepelh-iletjeh. ");
INSERT INTO amx_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Kelemeh arrantherr alherrerrang. Thang arrantherrenh yep-yep map-arteh lanthem, angwely arnwer mapeng rlkwerr-warn lanthem. ");
INSERT INTO amx_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Arrantherr itja maney apek yakweth apek pwet apek angetjeh arrehantherrel-ayel. Arrantherr tjeyel alherl-apemeng, tjerrtj ngwenh apek arrantherr mpwepel aretj-alhemeng, angketj-kweny anper alherrerrang. ");
INSERT INTO amx_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","“Arrantherr apek warl-warn irrpetj-alhemeng, arrantherr warlek-artweyek lakenh angketjeh, ‘Altjerr rang ngkweng kangkentj mernelhem.’ ");
INSERT INTO amx_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Tjerrtj inang apek kangkemeng, Altjerr rang ineh kangkentj mernelhetjenh. Itjeng apek, itja kwetarl. ");
INSERT INTO amx_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Warl nyentel-amparr anerrerrang. Mern ker apek inang arrantherrenh wantemel anthetjenharl, arrantherr kwenpel arlkwerrerrang. Inang lakenh arrantherrenh kwart-wetjenh, tjenkerr-artek anthemeng, arrantherr tjeng rrkwapemarleng wart. Arrantherr itja warl arrpenh map-warn alhetjeh, warl nyentel-ayeng kwet anerrerrang, town arrpenh-warnemeh alhetjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Arrantherr apek town arrpenh-warn alhemeng, tjerrtj inang apek arrehantherr kangkemel arnek-irremeng, kel kwenpel arlkwerrerray, mern inarl arrehantherr wantemel anthetjenh. ");
INSERT INTO amx_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tjerrtj irlkert mer kwerel inenh mwerr-ilerrerrang. Inenh ingkerrek ilerrerrang, arltang angathemeh irremengarl, lwerenheng Altjerr rang ingkerrekeh mernelhetjenh, rang Ngkart angerr anemeng. ");
INSERT INTO amx_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Arrantherr apek town arrpenh-warn alhemeng, tjerrtj inang tjweker-irremeng apek arrehantherr, arrantherr tjerrtj inenh anngetherr iletjehant, ");
INSERT INTO amx_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ilern arrantherrenh ateng-ilem, ilern mer arrehantherr-henh ulmernt ingkangeng lernem. Nhenh iterl-arang: arltang angathemeh, Altjerr rang mernelhetjenh, rang tjerrtj ingkerrekeh Ngkart angerr anemeng wart.’ Lakenh arrantherr tjerrtj inenh iletjeh. ");
INSERT INTO amx_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Arrantherr iterl-aremam angketj town Sodom-akert? Ngkwey Altjerrel rwang alkereng lanthek, Sodom renh atwetjeh, tjerrtj inang anetj anthwerr anekarleng wart. Arratj anthwerr, arltang ingkernel rwekenth-kenth angerr anetjenh Sodom-areny mapeh, Altjerrelarl tjerrtj ingkerrek ahelh apanpel judge-em-ilemel pawenhetjenharl. Rang tjerrtj inarl angketj arrehantherr-henh awekarl kangkwerretj-kweny-arlk map lanthetjenh rwang anganentj kwer-warn. Yanh-areny mapeh rwekenth-kenth angerr-lkwer anthwerr anetjenh!” ");
INSERT INTO amx_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Jesu tjerrtj mapeng ularr angkek, “Rwekenth-kenth angerr anthwerrarl anetjenh tjerrtj Chorazin-areny mapek-arlk tjerrtj Bethsaida-areny mapek-arlk! Tjerrtj Chorazin-areny mapay, Bethsaida-areny map thwenay awerrerray! Arrehantherr rwekenth-kenth angerr anthwerr anetjenh! Thang arrehantherreng anngetherr twer angerrel mpwarerl-apek. Arrantherr itja tjeng-warn twep-irremel petj-alpek! Arrantherr yengenh ntjwemel arek. Thang apek arrwekel twer angerrel tjerrtj Tyre-areny mapeng anngetherr mpwarek, tjerrtj Sidon-areny mapeng anngetherr thwen, tjerrtj mer yanh atherr-areny maparl kel-antey Altjerr-warn twep-irremer. Inang kel ltarrp-henh mantarr-warn irrpemer nyerr-irremel, arlmenyel kapert-arlk pernelhemel thwen. Inang anetj inehenheng impemer. Arrantherr itja lakenh mernelhek. ");
INSERT INTO amx_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Arrantherr nhenh awerrerrang! Arltang ingkernel, Altjerrelarl tjerrtj ingkerrek ahelh apanpel judge-em-ilemel pawenhetjenharl, rwekenth-kenth angerr anetjenh Tyre-areny mapeh Sidon-areny mapeh thwen. Altjerr rang inenh mer rwang anganentj-warn anpwemel lanthetjenh. Arrantherr-arteh? Arrantherr itja Altjerr-henh aheng alwerretjenh! Arrehantherr rwekenth-kenth angerr-lkwer anthwerr anetjenh! ");
INSERT INTO amx_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Tjerrtj Capernaum-areny mapay! Arrantherr iterl-arem, Altjerrel kwel arrantherrenh alker-warn tjwenetjenharl. Itjeng alherrerrang! Arrantherrenh Altjerrel mer rwang anganentj-warn lanthetjenh.” ");
INSERT INTO amx_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jesu-el tjerrtj mapeng ularr ilek, “Tjerrtj inarl arrehantherr kangkwerrem, inang tjengemeh kangkwerretjeh. Tjerrtj inarl arrehantherreng ntjwem-irrem, inang tjengeng ntjwem-irrem. Tjerrtj inarl tjengeng ntjwem-irrem, inartek Altjerreng-atwetj ntjwem-irrem. Altjerrel kwenh yengenh lanthekarl.” Lakenh Jesu-el ilek artwang map, inang mer map-warn alherl-apetjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Kel atay arrpenhel nakenh-nakenh nheng map arrken anthwerr petj-alpek Jesu-warn. Inang ilelhek, “Ngkartay, arratj kwenh! Nwern kwerrern anetj inenh arreny ngkwengenhel anpwerl-apetjam, kwerrern inang nwerneh kangkwerremel alhek!” ");
INSERT INTO amx_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesu-el inenh ilek, “Thang arrentj angerr renh arek, alkerengarl anyek alharrkentj-arteh. ");
INSERT INTO amx_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Thang arrantherrenh twer-ilek, arrpenhel itja arrantherrenh atwetjeh. Arrantherr amwang mapel-ayel anem-akert mapel-ayel thwen lthwemel kwenp alhetjeh, inang arrantherrenh itja nhwetjenh. Arrentjel arrantherrenh itja atwetjenh. Rang-atwetj arrehantherretj ater-irremel alpetjenh. ");
INSERT INTO amx_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Arrantherr arrken anem, arrantherr kwerrern anetj map inenh arnpakemel ntjwem-ilekarl. Arrantherr nhenheh-atwetj arrken anetjeh! Altjerrel arrantherrenh iterl-arem, rang arreny arrehantherr-henh pip kwerenh-warn arrernekarl.” ");
INSERT INTO amx_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Jesu lakenh angkekarl-penh, Kwerrern Alngaltarel renh arrken anthwerr mpwarek. Jesu Angey kwerenheh angkek, “Angeyay, ntwang Ngkart angerr anem alkerel ahelhel thwen. Thang ngwenh nakem, ntwang angketj tjerrtj akwen mapeh keth-ilemel ilek. Itja tjerrtj kaltj mapeh. Ntwang angketj alengk-wek inehetj. Lakenh ntwang ahentj-anek.” Lakenh Jesu angkek Angey kwerenhek. ");
INSERT INTO amx_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jesu-el artwang nheng map inenh ilek, “Angeyel yengenh arratj ngkernek, tjerrtj ingkerrekeh Ngkart angerr anetjeh. Rang tjeng ingkerrek ilek. Tjerrtj nyent itja Lerek kaltj, Angey rant war. Tjerrtj nyent itja Angeyek kaltj, Ler rant war. Ler rang Angey renh tjerrtj ineh mernem, ineharl Ler rang ahentj-anem renh mernetjeh.” ");
INSERT INTO amx_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Kwer-penh Jesu ngakelhek kwertengerl 12 kwerenh map-akert, inarrpemeh anerl-anemel angketjam. Rang kwertengerl inenh ilek, “Lyet arrantherrarl anngel arek, wenh mwerr anthwerr anek. Lakenh Altjerr kel kangkentj arrehantherr mernelhek, rang arrantherrenh twer-ilekarl. ");
INSERT INTO amx_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Altjerr-henh angketj angenh-angenh arrwekeleny map king ngkweyeny map thwen, inang ahentj-anek nhenh aretjeh, arrantherrarl lyet arem-arteh. Inang itja arek. Inang ahentj-anek, angketj tjengenh awetjeh, angketj nheng arrantherrarl lyet awem, inang itja awek.” ");
INSERT INTO amx_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Artwang kaltj-anthenh-anthenh nyent kemerremel irnek. Rang arrkernemel Jesu renh pawenhek, “Kaltj-anthenh-anthenhay, nthakenham yeng mernelhetjeh, thang iteth ngampekarl inetjenheng?” ");
INSERT INTO amx_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesu-el renh angkep pawenhek, “Wenham angketj Altjerr-henh pipel-ayeng intem? Nthakenh ntwang iterrem, ntwang pip ingkerrek read-em-ilekarl-penh?” ");
INSERT INTO amx_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Artwang kaltj-anthenh-anthenh rang angkek, “Ntwang Altjerreh angerr anthwerr nyerrketjeh, iterleng-iterl ngkwengenhel awelhentj ngkwengenhel kwerrern ngkwengenhel thwen. Ntwang iterrentj nyent-akert anetjeh. Ntwang kwer kwet iterrerl-anetjeh. Ntwang renhant naketjeh. Ntwang kwerant kangkwerretjeh. Ntwarl ngkwewaleny arntarnt-arelhem-arteh, lakenh-arteh ntwang tjerrtj arrpenh map kangkemel arntarnt-aretjeh.” ");
INSERT INTO amx_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesu-el renh ilek, “Ntwang kel yengenh arratj ilek. Angketj nhenh mapek kangkwerrang, kwer-penh ntwang iteth ngampekarl renh inetjenheng.” ");
INSERT INTO amx_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Artwang kaltj-anthenh-anthenh rang iterl-arek, rang kwel angketj nhenheh kangkwerremeng. Lakenheng rang Jesu renh weth pawenhek, “Ngwenham thang arntarnt-aretjeh?” ");
INSERT INTO amx_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesu-el renh ilek, “Thang angketj ngkweng iletjeh. Artwang nyent Jerusalem-eng Jericho town-warn alherl-apetjam. Rang tjeyel alherl-apetjam, arwengkalth mapel renh antwerrkek, mantarr kwerenh-arlk kap-rlwemel, maney-arlk kwerenh rwengkel inek. Inang renh atwerrerrek, kel ilwetjehant imperl-alhek. ");
INSERT INTO amx_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kwer-penh ngkart priest nyent tjey kwerel petjek. Rang artwang renh arek, tjwen-akert irlkert interl-anerleh. Rang kwerehetj anper alhek. ");
INSERT INTO amx_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Kwer-penh artwang arrpenh petjek. Rang artwang Levi anek, church angerr-areny rrkwapenh-apenh. Rang renh tjey kwerel anperel arenhek, irlkert interl-anerleh. Rang kwerehetj anper alhek. ");
INSERT INTO amx_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kwer-penh artwang Samaria-areny nyent petjek. Rang artwang renh arek, irlkert interl-anerleh. Rang kwer lharrp-irrek. ");
INSERT INTO amx_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Rang artwang kwer-warn alhemel anter wine thelek, tjwen anterel pernek, tjwen inenh mantarrel ayernek. Kwer-penh Samaria-areny rang artwang renh tangkey kwerenh-warn tjwenemel renh anginek. Rang renh warl intenh-intenh-warn angek, rang renh arntarnt-aretjeh. ");
INSERT INTO amx_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kel kweny-rtweh rang anper alhetjenharl, rang warleh-artweyek maney anthek. Rang renh ilek, ‘Artwang irlkert nhenh arntarnt-aray! Rang apek kwet irlkert irremarl, kelant yeng petj-alpetjenheng, thang ngkweng maney weth anthetj-alpetjenh!’ ” ");
INSERT INTO amx_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jesu-el artwang kaltj-anthenh-anthenh renh pawenhek, “Nthakenham ntwang iterl-arem artwang nhenh rrpwetj-penh? Artwang ngwenhel apek tjerrtj renh mantj arntarnt-arek? Ngkart priest-el apek? Artwang Levi-el apek? Artwang Samaria-arenyel apek?” ");
INSERT INTO amx_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Artwang kaltj-anthenh-anthenh rang tjernek, “Artwang rang kwenh, rarl kwer mantj-mantj mernelhekarl! Artwang lwereny rang kwenh renh mantj-mantj-ilek!” Jesu-el renh ilek, “Lakenh ntwang alhemer, tjerrtj arrpenh map arntarnt-aremer, lwereny map-arlk, kangkentj mernelhemel. Peltj ngkwengenh mapekant iterretj-kweny anetjek.” ");
INSERT INTO amx_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Kwer-penh Jesu rang kwertengerl kwerenh map-akert town kwek nyent-warn irretj-alhek. Marl nyent kwerel anek, arreny kwerenh Martha. Rang Jesu inenh warl kwerenh-warn ngwek, kwerel-ayeng yatjarr angkerremel anerl-alpetjeh. ");
INSERT INTO amx_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martha-henh tjey, arreny kwerenh Mary, ratherr warl kwerel pwert anetjam. Mary-emeh Jesu-eng angath arrernelhek, renh awerl-anetjeh, kaltj-irretjeh angketj kwerenhek. ");
INSERT INTO amx_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martha rang perrpert-ilelhek, merneh-arlk angerr rrkwaperl-anek. Martha rang Jesu-warn alhek, rang renh ilek, “Ngkartay! Mary-el yengenh imperl-alhek, nyent rrkwapetjeh. Ntwang Mary renh ilay, ilern pwert merneh rrkwapetjeh!” ");
INSERT INTO amx_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ngkartel renh ilek, “Marthay, Marthay, peltj tjengenhay! Wenheh ntwang ahang-irrem Mary-ek? Ntwartek merneh angerr iterrem, ngkwewaleny perrpert-ilelhem. ");
INSERT INTO amx_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Nhenhant kwenh tjeperr anem, yengant awerl-anetjeh! Mary rang kaltj-irremel yengenh awek. Thang renh itja arnpaketjenh.” ");
INSERT INTO amx_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Arrpenh-ingar Jesu Angey kwerenh-warn angketjam. Rang kel angkekarl-penh, kwertengerl nyentel renh pawenhek, “Ngkartay! Nwernenh kaltj-anthay, Altjerr-warn angketjeh! John Kwatjeh Irrpelh-ilenh-ilenhel kwertengerl kwerenh map kaltj-anthekarl-arteh.” ");
INSERT INTO amx_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesu-el inenh ilek, “Arrantherr Altjerr-warn angkemarleng apek, arrantherr lakenh angketjeh: ‘Angeyay, tjerrtj ingkerrek kaltj-anthang, inang arreny ngkwengenh arratjant anewetjeh. Petjay, tjerrtj ingkerrenyeh mernelhetjeh, ntwang Ngkart angerr anemeng. ");
INSERT INTO amx_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Mern nwerneh kweteth antherl-anang. ");
INSERT INTO amx_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Anetj nwern-hetj wang. Lakenh nwern anetj inehenh wem, inarl nwernenh anetj-ilekarl-penh. Arrentj renh arnpakay, rang nwernenh arrkernehetjeng.’ ” ");
INSERT INTO amx_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesu-el inenh ilek, “Thang angketj kwek war ilem. Ntwang kweny mpwepel apek alhem peltj ngkwengenh-warn, merneh apek ankeyel pawenhetjeh. Ntwang lakenh angkem, ‘Peltj tjengenhay! Yeng petjek merneh ankey ngkweng-warn. Mern kwek apek ngkweng intem? Mern rrpwetj tjeng anthang, thang peltj tjengenh wantetjeh! ");
INSERT INTO amx_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Peltj tjengenh ntwarreng petjek tjeng-warn. Yeng itja mern-kwenh wart, kwer anthetjeh.’ ");
INSERT INTO amx_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Peltj ngkwengenh ngkweng-warn lakenh angketjenh, ‘Peltj tjengenhay, yengenh impay! Yengenh parrk-parrk-iletjal! Arrew tjengenh kel martelhentj wart, kwer tjengenh map tjengel-ayel antjamel ankwangemeh intemeng. Yeng ywarn kemerrem, ngwenh mern anthetjeh.’ ” ");
INSERT INTO amx_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Jesu-el inenh ilek, “Wenhekay? Thang arrantherrenh ilem, nthakenh rang mpwaretjenh. Peltj ngkwengenh lakenh angketjenh, ‘Thang ngkweng mern anthetjenheng.’ Lakenheng rang ngkweng mern anthem, rang nyerr-irrehetjeng arrpenh mapel nhenh-penh awehetjeng, rang itja mern anthekarleng wart. Lakenh-arteh arrantherr Altjerr renh pawenhemeng, rang kel arrehantherr anthem kangkentjel. ");
INSERT INTO amx_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Mantjel awerrerray! Arrantherr Altjerr renh pawenherrerrang. Kwereng rang arrantherrenh anthetjenh. Altjerr kwer palenthwerrerray. Kwereng rang arrehantherr mernelhetjenh. Altjerr-henh arrew rltar-atwerrerray! Kwereng rang arrehantherr altjwer-iletjenh, arrantherr irrpetjenheng. ");
INSERT INTO amx_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tjerrtj ngwenh apek rarl Altjerr renh pawenhem, renh Altjerrel awemel anthetjenh. Tjerrtj ngwenh apek rarl Altjerrek palenthwem, rang renh aretj-alhetjenh. Tjerrtj ngwenh apek rarl Altjerr-henh arrew rltar-atwem, Altjerrel kwer altjwer-iletjenh, rang irrpetjenheng. ");
INSERT INTO amx_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Ler ngkwengenhel apek ngwenh ker irrpenngeh pawenhem, ntwang renh itja amwang anthem. Ntwang kwenh renh ker irrpenng anthem! ");
INSERT INTO amx_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Rang apek kwartek ngwenh pawenhemeng, ntwang itja renh anem-akert anthem. Itja kwenh! Ntwang kwenh kwart kwer anthem. ");
INSERT INTO amx_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Arrantherr kwenh tjerrtj anetj-akert! Arrantherr kel kaltj, ler arrehantherr-henh rnwanentj mwerr anthetjeh, mern mwerr-arlk apek ker mwerr-arlk apek anthetjeh. Angey alker-areny rang angerr-lkwer anthetjenh, arrantherr renh pawenhemarleng! Arrantherr apek renh pawenhem Kwerrern Alngaltarek, rang kwenh Kwerrern Alngaltar renh arrehantherr-warn lanthem.” ");
INSERT INTO amx_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Arltang arrpenhel Jesu-el artwang kwerrern anetj-akert aretj-alhek. Kwerrern nhenh rartek artwang renh angketj-kwenh-ilekarl. Jesu rang kwerrern anetj artwang kwereng anpwek. Artwang rang angkek-anem. Tjerrtj mapel nhenh aremel anwerlkek. ");
INSERT INTO amx_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Arrpenh mapel rrtjwerremel ilek, “Artwang nhenh kwerrern anetj angerr arreny Beelzebub kwer kangkwerrenh-rrenh kwel. Beelzebub rang Jesu renh twer-ilekarleng kwel, lakenh Jesu-el kwerrern anetj map tjerrtjeng anpwerl-apem.” ");
INSERT INTO amx_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Arrpenh map ahentj-anek, Jesu renh arrkernetjeh. Inang renh pawenhek, Jesu-el ineh twer angerrel mpwaretjeh, inang kaltj anetjenheng, Altjerrel renh arratj lanthekarl apek. ");
INSERT INTO amx_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jesu kel kaltj anek iterrentj inehenheh. Rang angketj ineh ilek, “Iterl-aray! Peltj map kweteth atwerrem apek, inang itja mer nyentel kwet anetjenh, inang ingkerreny irrarnp-irretjenh. Mer inehenhel-ayeng rrpwetjant anetjenh. ");
INSERT INTO amx_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Arrantherr ilem, Beelzebub-el yengenh twer-ilekarl kwel, lakenh thang kwerrern anetj map anpwem. Nhenh itja arratj anem! Rang itja tjeng-artwey anem! Rang twernk kwerrern anetj map-kenhantarl anem. Rang itja kwerrern anetj kwerenh map anpwem. ");
INSERT INTO amx_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Arrantherr angkem, thang kwel kwerrern anetj map anpwem, Beelzebub-el yengenh twer-ilekarleng. Arrehantherr-henh map-arteh? Ngwenhelam inenh twer-ilem, kwerrern anetj map inenh anpwetjeh-anngernt? ");
INSERT INTO amx_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Thang kwerrern anetj inenh anpwem, Altjerrel yengenh twer-ilekarleng. Arrantherr yeng arekarl-penh arrentj alharlkwerleh, lakenh arrantherr iterl-aretjenheng Altjerrarl petjek, arrantherrenh ateng-iletjeh.” ");
INSERT INTO amx_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Jesu angkek, “Thang angketj kwek arrehantherr iletjeh. Artwang twerel apek warl kwerenh arntarnt-arem, arrawey kwerenh-akertel. Rnwanentj kwerenh mwerr kwet warl kwerenhel intetjenh. Arrpenhel itja rwengkel inetjenh. ");
INSERT INTO amx_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Artwang arrpenh apek petjem twer angerr-akert. Rang warlek-artwey renh athenemel atwem. Kwer-penh rang arrawey nheng irrarnpelh-ilemel anthem, rnwanentj kwerenh map thwen.” ");
INSERT INTO amx_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Jesu angkek, “Arrpenh ngwenh apek tjeng ahentj-kweny anem, rang tjengenh peltj-kweny anem, itja tjeng rrkwapem. Rang arrpenh map itja tjeng-warn angetjem. Rang inenh tjengehetj ntjwem-ilem.” ");
INSERT INTO amx_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Thang angketj nhenh ilem kwerrern anetj-akert. Kwerrern anetj rang tjerrtj nyentel-ayeng-amparr anem, kwereng renh arrpenhel anpwem twer angerr-akertel. Kwerrern anetj rang artwang impem-anem, rang werrk-angkwerr nthwerl-apem, mer arrpenhek palenthwerl-apemel. Rang merek ywarn palenthwemeng, kwerrern anetj rang lakenh angkem, ‘Yeng angkep alpetjenh, mer yengarl arratekarl kwer-warn.’ ");
INSERT INTO amx_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Kwerrern anetj rang angkep alpem, artwang kwereng rang arratekarl-warn. Rang artwang renh aretj-alhem, kwerrern anetj-kwenyarl, mwerremeh. ");
INSERT INTO amx_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kwerrern anetj rang kwerrern anetj-lkwer 7 pel ngwerl-alpem. Inang artwang kwer-warn angkep irrperrerrem, kwerel-ayeng kwetant anetjeh. Artwang rang kwerrern anetj nyent-amparr anyenek. Lyet rang anem kwerrern anetj aningk-akertemeh, anetj anthwerr. Lakenh kwer rwekenth-kenth angerr anetjenh.” ");
INSERT INTO amx_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesu angketjamarleng, marl nyent arlkemel angkek, “Mwek ngkwengenh rarl ngwenh mangkelh-ilekarl rang kwenh arrken awelhem, Altjerr kwer kangkentj angerr mernelhekarl!” ");
INSERT INTO amx_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesu tjernemel angkek, “Nhenhant tjeperr, tjerrtj inang Altjerr-henh angketjeh kangkwerremeng, inang arrken angerr awelhem, Altjerr ineh kangkentj angerr mernelhekarleng.” ");
INSERT INTO amx_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Tjerrtj inang arraw-irrek Jesu kwer-warn. Jesu-el inenh ilek, “Arrantherr tjerrtj lyet anemarl map-artek anetj anthwerr. Arrantherr aretjeh ahentj-anem, thang arrehantherr mernetjeh twer angerr alker-arenyek. Thang arrehantherr itja kwet lakenh mernetjenh. Thang arrantherrenh irlpangkelh-ilemel ilem war, artwang Altjerr-henh angketj angenh-angenh nheng Jonah-akert war. Altjerrel ngkwey twer kwerenh mernekarl Jonah-el-arleng. ");
INSERT INTO amx_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Arrantherr angketj Jonah-akert iterl-aremam?” Keth-ilentj: Irrpenng angerrel Jonah renh kwernek, kweny atherr rang intek irrpenng kwenel. Kwereng Altjerrel irrpenng renh twernek, rang Jonah renh antew arrernetjeh keth-warn, kwatj alay iter-warn. Kwer-penh Jonah rang town angerr Nineveh-warn alhek, mer-areny map iletj-alhek, inang anetjeng twep-irretjeh Altjerr-warn-anem. “Jonah-el Nineveh-areny map mernek, Altjerrel inenh ateng-ilek, twep-irretjeh kwer-warn. Inang alhengk-aremel twep-irrek Altjerr-warn. Jonah-arteh, Tjerrtj-henh Ler rang arrantherrenh mernek, arrantherr lyet anemarl mapel alhengk-aretjeh, Altjerr ahentj-anem, arrantherr twep-irretjeh kwer-warn. ");
INSERT INTO amx_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","32","Tjerrtj Nineveh-areny map arrehantherr arnkely-irremel iltetjenh. Inang kwenh twep-irrekarl, Jonah-el inenh ateng-ilemel ilekarleng wart. Lyet artwang nyent nhenhel anem, rarl arrantherrenh angketj twer-lkwerel ateng-ilemel iletjenh. Altjerr rang petjemarleng tjerrtj ingkerrek judge-em-ilemel pawenhetjeh-anngernt, tjerrtj Sheba-areny map-henh queen-el iteth-irremel arrantherrenh arnkely-irremel iltetjenh. Queen Sheba-areny rang ngkwey mer ntwarreng petjekarl, King Solomon renh awetjeh, rang inangkal anthwerr angkerleh. Lyet artwang nyentel arrantherrenh kaltj-anthem, rarl Solomon-eng inangkal-lkwer anem.” ");
INSERT INTO amx_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Jesu-el ilek angketj arrpenh rwang alngenth-akert. “Tjerrtjel rwang alngenth anthelemel rang renh itja arltwem. Rang alngenth table-ek-atwetj arrernem, tjerrtj ngwenh apek warl irrpentjemarleng, rang alernentjel aretjenheng. ");
INSERT INTO amx_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","36","Lakenh-arteh anngangel tjey nwerneh mernem, nwern keth aretjeh. Anngel mwerr aretjeh, mwerr nwerneh parrtjelh-ilem. Anngang anetj apek, nwern ywarn arem, ngwemerntel-ayeng-arteh. Anngang ngkwengenh mwerr anyenang, alernentj ngkwengenh lwernelhehetj, ntwang pweng-irrehetjeng! Ntwang kwet apek anem alernentj Altjerr-henhel, kwer kangkwerremel, ngwemerntel itja ngwenh arltwem. Ntwang itja palekalek anetjenh.” ");
INSERT INTO amx_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Artwang Pharisee nyentel Jesu renh warl kwerenh-warn merneh ngwek. Jesu rang warl-warn irrpenhek, kel merneh arrernelhek-anem. ");
INSERT INTO amx_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Artwang Pharisee-el renh aremel anwerlkek, Jesu rang itja iltjang lhewelhekarl, mern arlkwetjeh-anngerntel. ");
INSERT INTO amx_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ngkart Jesu-el artwang renh ilek, “Arrantherr-artek tjampet plate-arlk lhewem. Kenh kwerrern-arlk arrehantherr-henh anetj! ");
INSERT INTO amx_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ahert mapay! Altjerrel kwenh tjerrtj arrmernek, mpwerrk iterrentj thwen ntjaper. ");
INSERT INTO amx_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Arrantherr tjerrtj mern-kwenh mapeh kangkentjel mern anthetjeh-amparr, kwereng Altjerrel arrantherrenh tjampet plate-arlk arrehantherr-henh alngetjenh. Lakenh arrantherr kwenh Altjerreng ularr arratj mernelhek. ");
INSERT INTO amx_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Artwang Pharisee mapay, arrehantherr rwekenth-kenth angerr anetjenh! Arrantherr lyapelh-ilem mern atherrk, kwek map akemel, kert arrpenh tjenkerr anthem Altjerrek, Moses-henh mpwareng-areng-angkwerr. Mwerr lakenh. Tjerrtj arrpenh map-arteh? Arrantherr itja ineh arratj mernelhek. Arrantherr itja Altjerreh angerr kangkem. Arrantherr kangkentj mernelhemer Altjerrek arrpenh mapek thwen. Tjenkerr arratj kwet antherl-anetjeh! ");
INSERT INTO amx_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Artwang Pharisee mapay, arrehantherr rwekenth-kenth angerr anetjenh! Arrantherr church-warn alhemeng, arrantherr ahentj-anem arrwekel anthwerr anetjeh, arrpenh mapel arrantherrenh nakemel aretjenheng. Arrantherr shop-warn apek alhemarleng, arrantherr ahentj-anem, tjerrtj mapel arrantherrenh inangkal map nakemel iletjenheng. ");
INSERT INTO amx_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Arrehantherr rwekenth-kenth angerr anetjenh! Arrpenh mapel arrantherrenh arem, inang iterrem, arrantherr mwerr kwel anem. Arrantherr anetj anthwerr anem. Arrpenh map apek arrehantherreng ingkern-angkwerr alhem, inang anetj-irrem.” Lakenh Jesu-el iltek artwang Pharisee map. ");
INSERT INTO amx_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Artwang kaltj-anthenh-anthenh nyentel Jesu renh ilek, “Kaltj-anthenh-anthenhay, ntwang Pharisee map iltek, ntwang nwernenhenp iltek!” ");
INSERT INTO amx_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesu-el renh tjernemel ilek, “Artwang kaltj-anthenh-anthenh mapay, arrehantherr rwekenth-kenth angerr anetjenh! Arrantherr mpwareng-areng arrpenh map-arlk anthem tjerrtj mapeh, inang kangkwerretjenheng. Itja Moses-kenh mpwareng-arengant. Inang ywarn mpwareng-areng ingkerrekeh kangkwerrem, map anthwerreng. Arrantherr inenh perrpert-ilem, arrantherr ineh itja tangetjel anem. ");
INSERT INTO amx_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Arrehantherr rwekenth-kenth angerr anetjenh! Arrwekeleny arrehantherr-henh mapel Altjerr-henh angketj angenh-angenh map irrernng atwetjart. Arrantherr-antem angketj angenh-angenh ineh pwert ngkernem, ineh irlpangketjenheng awenng inehenheh. ");
INSERT INTO amx_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Irlpangkentj-henh pwert inenh ngkernemel, lakenh arrantherr mernem, arrantherr kangkem, arrwekeleny arrehantherr-henhel angketj angenh-angenh irrernng atwetjartarl. ");
INSERT INTO amx_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Altjerr rang arrwekel kwet kaltj anek arrehantherr. Rang angkek, ‘Thang angketj angenh-angenh map, kaltj-anthenh-anthenh map thwen tjerrtj Israel-areny map ineh-warn lanthetjeh. Angketj angenh-angenh ineheng inang arrpenh irrernng atwetjenh, arrpenh map inang alwernemel nakepakel-iletjenh.’ ");
INSERT INTO amx_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Ngkwey anthwerr Cain-el tjeyekw kwerenh Abel irrernng atwek. Arrpenh mapel atwek Altjerr-henh angketj angenh-angenh map. Altjerr-henh angenh-angenh nheng Zechariah inang irrernng atwek church angerr kwenel. Arratj anthwerr, arrengey arrehantherr-henhel angketj angenh-angenh map atwek ngkweyeng-ntjel. Lakenheng arrantherr lyet anemarl map rrwernek, arrantherr kwenh merrentj. Ineheng arrngel Altjerrel arrantherrenh ingkerreny atwetjenh. ");
INSERT INTO amx_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Artwang kaltj-anthenh-anthenh mapay, arrehantherr rwekenth-kenth angerr anetjenh! Arrantherr angketj Altjerr-henh arratj kaltj-anthetjeh, arrpenh map kaltj-irretjeh, Altjerr kwer kangkwerretjenheng. Itja kwet! Inang kaltj-irretj-kwenh-antey, arrehantherr-arteh!” Lakenh Jesu-el inenh iltek. ");
INSERT INTO amx_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Artwang kaltj-anthenh-anthenh map artwang Pharisee map thwen inang Jesu kwer arnkely-irrek. Inang Jesu renh angerr anthwerr irrpelth-irremel pawenhek. ");
INSERT INTO amx_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Inang ahentj-anek, renh mantjel awetjeh, rang apek pal angkehetjeng. ");
INSERT INTO amx_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tjerrtj aningk inang Jesu-warn petjewarrek. Inang rrpwerrketjam Jesu-warn itwek-irrerl-apemel. Jesu rang kwertengerl kwerenh map ateng-ilemel ilek, “Arrantherr-artek artwang Pharisee mapeng mantj arelhetjeh. Inartek arrantherrenh palekalek kaltj-anthehetjeng. Inang kaltj-anthem wenh apek, inang itja arratj mernelhem. ");
INSERT INTO amx_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Angketj wenh apek tjerrtjelarl lyet alengk-wem, nhenh Altjerrel kelant keth-iletjenh. Arrantherr ywarn alengk-wem anetj arrantherr mpwarekarl, Altjerrel arrantherrenh keth arem. Rang arem, rang kelant anetj keth-iletjenh, mapel alhengk-aretjenheng. ");
INSERT INTO amx_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Mantjel iterl-aretjeh. Angketj nheng arrantherrarl kwenyel angkekarl, aherrkelarl arrpenh mapel awetjenh. Angketj nheng arrantherr kwen angkemarl, arrpenh mapel keth anthwerr awetjenh.” ");
INSERT INTO amx_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Peltj tjengenh mapay, arrantherr itja tjerrtj ahangerr mapeng ater-irretjeh. Inang kwenh mpwerrkant irrernng atwem. Irrernng-penh inang itja arrantherrenh rwekenth-kenth-iletjenh. ");
INSERT INTO amx_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Arrantherr Altjerrengant ater-irretjeh. Rang kwenh tjerrtj anetj inenh rwang anganentj-warn wetjenh. Arratj kwenh arrantherr-artek Altjerrengant ater-irretjeh. ");
INSERT INTO amx_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Thep kwek map iterl-arerrerray. Tjerrtjel apek thep 5 pel payem-ilem, maney ngkweltj atherrel. Arrantherr iterl-arem, thep inang anetjeh-athen. Itja, Altjerr ineh lharrp-irrem, rang thep nyentek apek angwerretj-kweny anem. ");
INSERT INTO amx_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Arrehantherr Altjerr lharrp-irrem angerr anthwerr. Kapert altang nthakentj apek arrehantherr-henh anem? Altjerrant kel kaltj. Rang arrantherrenh ingkerreny nyentam-nyent iterl-arem. Thep map itja tjeperr anem, kenh Altjerr rang thep map arntarnt-arem. Rang thep maparl arntarnt-arem-arteh, rang arrantherrenh mantj anthwerr arntarnt-aretjenh. Lakenheng arrantherr itja ater-irretjeh. Altjerreng ularr arrantherr tjeperr anem. Rang arrantherrenh mantjel arntarnt-aretjenh. ");
INSERT INTO amx_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Tjerrtj ngwenh apek rarl tjerrtj arrpenh mapeng ularr lakenh ilelhem, ‘Thang Jesu nakem, Tjerrtj-henh Ler renh’, thangemeh angel alker-areny map iletjenh, tjerrtj nhenh rang arratj kwenh tjengenh anem. ");
INSERT INTO amx_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Tjerrtj arrpenh apek ilelhem, ‘Thang itja Jesu nakem’, thang angel map iletjenh, tjerrtj nhenh itja tjengenh anem. Yeng kwereng ntjwem-irretjenh. ");
INSERT INTO amx_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Tjerrtj ngwenh apek rarl Tjerrtj-henh Ler-penh lhwerrkert angkem, kwer-penh rang apek lakenh ilelhem, ‘Angeyay, anetj tjengenh way!’ Altjerrel kel anetj kwerenh wetjenh. Tjerrtj ngwenhel apek Kwerrern Alngaltar renh arrampewem, Altjerrel anetj kwerenh itja kwetarl wetjenh. Rang anetj-akert kwet anetjenh. ");
INSERT INTO amx_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Inang apek arrantherrenh church-warn angetjenh, twernk mapeng ularr apek ngkernetjenh, inang arrantherrenh arrkernemel pawenhetjeh-anngernt, arrantherr itja angerr iterretjeh, ‘Nthakenhameh yeng arratj ilelhetjeh?’ ");
INSERT INTO amx_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kwerrern Alngaltarel arrantherrenh iletjenh, nthakenh arrantherr ilelhetjeh.” ");
INSERT INTO amx_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Artwang nyentel Jesu pawenhek, “Kaltj-anthenh-anthenhay! Angey ilern-henh-artek ilwek. Kek tjengenhel rnwanentj ingkerreny anyenem. Renh ilang, rang tjeng rnwanentj kert arrpenh anthetjeh.” ");
INSERT INTO amx_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jesu-el renh tjernek, “Mpwel-henharrp-athek yanhan! Thang mpwelenh itja iletjenh. Mpwelarrp angkerrang.” ");
INSERT INTO amx_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Rang tjerrtj map ilek, “Arrantherr arntarnt-arelhetjeh. Arrantherr itja rnwanentj angerreh nyerrketjeh. Tjerrtj itjam iteth kwet anetjenh, rnwanentj kwerenh angerr intem.” ");
INSERT INTO amx_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jesu-el ineh angketj ilek, “Artwang maney angerr-akert nyent anek, rang farm angerr anyenek. Farm angerrel rang mern anngang angerr mangkelh-ilek. ");
INSERT INTO amx_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Artwang rang kwewaleny iterrek, ‘Tjengenh kwenh mern angerr anthwerr anem. Mern-henh warl tjengenh rrpwetj war anem. Nthenheham thang mern map arrernetjenh?’ ");
INSERT INTO amx_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Rang kwet iterremel lakenh angkek, ‘Lakenh thang mpwaretjeh. Thang mern-henh warl kwek map tjengenh taketjenh, warl angerr artetjenheng. Thang mern anngang mantarr-arlk ingkerrek warl angerretj kwer-warn arrernetjenh.’ ");
INSERT INTO amx_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kwer-penh rarrp kwewaleny nakelhemel ilelhek, ‘Mern-arlk angerr anthwerr tjeyenh intem. Kel yeng ltjwerrerl-anetjeh, arlkwerl-anetjeh, antjwerl-anetjeh, arrken war anerl-anetjeh.’ ");
INSERT INTO amx_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Altjerrel renh ilek, ‘Artwangay, ntwartek ahert! Lyet-antey kwenyel ntwang ilwetjenh, ntwang rnwanentj-arlk ngkwengenh parlp-iletjenh, ntwarl ankey angerrel ngkwengarrp anyenetjart. Mern-arlk warl-arlk mantarr-arlk ngkwengenh nthakenh irretjenh? Arrpenh mapel inenh inetjenh!’ ” ");
INSERT INTO amx_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Kwer-penh Jesu rang angkek ineh-warn, “Lakenh kwenh tjerrtj ankerleh anetjenh, inarl ahelh-arenyekant iterremel, inang rnwanentjeh arlweletjeh iterrerl-anem, inarl itja Altjerr renh iterl-arem. Altjerreng ularr inang rnwanentj-kwenh anem.” ");
INSERT INTO amx_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","23","Jesu-el kwertengerl kwerenh map ilek, “Arltang arrpenhemeh arrantherr apek arnterr iterrem lakenh, ‘Nthenhengam nwern mern inetjenh, nwern anhwerlk anetjenheng? Nthenhekam mantarr inem nwern ntjwetj anetjeh?’ Altjerrel kwenh nwernenh arrmernek, mwerr anetjeh. Rang nwerneh angwerretj-kweny, nwernenh mentj impetj-kweny, nwernenh arntarnt-arerl-anetjenh. Lakenheng nwern mernek-arlk mantarrek-arlk angerr iterrewarretjal anetjeh. ");
INSERT INTO amx_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Angank map arrantherr aray! Angank inang itja mern anngang ahelh-warn arrernem, mern lyapelh-iletjeh, tjerrtjel arrernem-arteh, itja. Inang itja mern inenh akemel arrawelh-ilem, tjerrtjel arrawelh-ilem-arteh, itja. Altjerrel inenh kwet wantem. Tjerrtj map arrantherr thepeng tjeperr-lkwer anem. Altjerr rang arem, arrantherr tjeperr anemeng. Thep angank itja tjeperr anem. ");
INSERT INTO amx_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Arrantherr apek iteth ngkwengenheh angerr iterrerl-anem, lakenh, ‘Ay! Yeng ahentj-anem iteth kwet anetjeh!’ Arrantherr lakenh iterremel ywarn iteth kwet anetjenh! ");
INSERT INTO amx_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Arrantherr-artek itja iteth kwet anem ahelh nhenhel. Wenheng arrantherr athek-athek-irrem, arrantherr kwenh mernek-arlk mantarrek-arlk angerr iterrem? Lakenh angerr anthwerr iterretjal anetjeh! ");
INSERT INTO amx_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Anteth inenh kethel lyaperleh arang! Inang itja rrkwapem, mantarr apek needle-el tanthem, itja. Arratj anthwerr, King Solomon rarl ngkwey anekarl, rang mantarr amparrkey-amparrkey-warn irrpek, anteth nhenh mapeng ularr rang anetj-anetj war anek. ");
INSERT INTO amx_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Altjerrel anteth inenh arrmernek. Anteth inang kwek war anemel, kel antjerrk-irrem. Kwer-penh tjerrtjel inenh rwang-warn wem. Altjerreng ularr arrantherr tjeperr anem, anteth map tjeperr kwek war anem. Rang kel arrehantherr mantarr mwerr anthetjenh, arrantherr irrpetjeh-anngernt. Arrantherr-artek Altjerr kwek war nakem. Arrantherr-artek Altjerr angerr-lkwer kwet nakemer! ");
INSERT INTO amx_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Arrantherr itja angerr iterretjeh, ‘Wenham nwern arlkwetjenh?’, ‘Wenham nwern antjwetjenh?’ Arrantherr itja mernek-arlk angerr iterretjeh. ");
INSERT INTO amx_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tjerrtj Altjerreh akwen map mernek-arlk angerr iterrerl-anem. Angey arrehantherr-henh kel kaltj, arrantherr mern-kweny kwatj-kweny, mantarr-kweny apek anem. ");
INSERT INTO amx_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Altjerr Ngkart angerr anem ingkerrekeh. Kwer kwet arrantherr nyerrkemel kangkwerrang, angerr rrkwapemel. Kwer-penh rang mern-arlk mantarr-arlk arrehantherr anthetjenheng. ");
INSERT INTO amx_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Kwer tjengenh mapay! Arrantherr kwenh rrpwetj war anem. Arrantherr itja ater-irretjeh, Angey arrehantherr-henh ahentj-anemeng wart, rang arrantherrenh mer anganentj kwerenh-warn anginetjenh, arrantherr kwerel-ayeng anetjenheng. ");
INSERT INTO amx_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Rnwanentj arrehantherr-henh sell-em-ilerrerrang, kwer-penh maney renh tjerrtj rnwanentj-kweny maney-kweny mapeh antherrerrang. Yakweth arrpenh Altjerrel arrehantherr mpwarem mer alkerel. Rang rnwanentj alker-areny arrehantherr anthetjenh, yakweth-warn kwernemel. Alkerel kwenh arwengkalth map itja anem, rnwanentj rwengkel inetjeh. Interrk itja kwerel anem, rnwanentj map anetj-iletjeh. ");
INSERT INTO amx_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Mer ahelh nhenhel apek arrantherr rnwanentj angerr arlwelem, mer nhenh kwer arrantherr kangketjeh. Mer alkerel apek Altjerrel arrehantherr rnwanentj angerr anthem, mer alenh kwer arrantherr kangketjeh. Nthakenh arrantherr iterrem? Mer nthenham mwerran?” ");
INSERT INTO amx_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Jesu angkek ineh, “Angketj nhenh awerrerrang. Artwang warlek-artwey rang alhek, arrpenhel arrkar inekarl-warn. Rrkwapenh-apenh kwerenh map irlpareth anek, inang karr kwet karelhek kwer alngenth-akert. Warlek-artwey rang kel arrken angerr-penh petj-alpetjenh. Rang arrew rltar-atwetj-alpemarleng, rrkwapenh-apenh inang kwer arrew kel altjwer-iletjenh. Arrantherr-artek rrkwapenh-apenh irlpareth ineh-arteh anetjeh. Kweteth karr arntarnt-arelhetjeh, Altjerrek rrkwapetjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Rrkwapenh-apenh alenh map kwenh arrken anetjenh, twernk inehenharl petj-alpetjenheng, inenh karr kwet aretj-alhem. Warlek-artwey rang inenh iletjenh, arrernelhetjeh. Kwer-penh rarrp mern mpwaretjenh, ineh mern arlkwetjeh anthetjenheng. ");
INSERT INTO amx_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Rrkwapenh-apenh alenh map arrken anetjenh, twernk inehenhel inenh karr kwet aretj-alhemeng, rang kweny mpwepel apek petj-alpemeng, ntwely mpankel aherlkentjel apek. ");
INSERT INTO amx_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Thang angketj warlek-artwey arrpenh-akert ilem. Iterl-aray, warlek-artwey rang apek kaltj anekarleng, ilwengar anthwerr artwang arwengkalth rang petjetjenh ineh-warn, rang kel kwer karelhetjeh, renh antwerrketjenheng. ");
INSERT INTO amx_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Arrantherr-artek karr anetjeh! Arrantherr itja kaltjeng wart, ilwengar anthwerr Tjerrtj-henh Ler rang petj-alpetjenh.” Lakenh Jesu-el inenh ilek. ");
INSERT INTO amx_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Peter-el Jesu renh pawenhek, “Ngkartay, ntwang angketj nhenh nwernehant key ilem? Tjerrtj arrpenh map-arteh?” ");
INSERT INTO amx_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ngkartel renh tjernek, “Thang angketj arrantherrenh warl arntarnt-arenh-arenh-akert ilem. Twernk nyentel artwang irlpareth ngkernem, warl arntarnt-arenh-arenh anetjeh, rrkwapenh-apenh kwerenh map arntarnt-aretjeh, mern inehenh arratj kwet antherl-anetjeh. ");
INSERT INTO amx_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Twernk rang petj-alpemeng, rang apek arem arntarnt-arenh-arenh arratj rrkwaperleh, rang kwer kangkem. ");
INSERT INTO amx_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Twernk rang renh ngkernetjenharl, rnwanentj ingkerrek kwerenh arntarnt-aretjeh. ");
INSERT INTO amx_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Warl arntarnt-arenh-arenh arrpenh apek itja arratj mernelhem. Rang apek iterrem, ‘Twernk tjengenh kwet anthwerr ywerrek.’ Kwer-penh rang rrkwapenh-apenh map atwem. Rarrp mern angerr arlkwem ngkwarl antjwem thwen. Rang terangk-irrem. ");
INSERT INTO amx_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Arltang arrpenhel rang itja karr karelhemeng, twernk kwerenh kel petj-alpek. Twernkel renh ngkwal irrernng atwetjenh, renh anpwetjenh, tjerrtj anetj mapel-ayel anetjeh, inarl Altjerr renh itja nakem.” ");
INSERT INTO amx_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Jesu-el angketj kwet ilek, “Rrkwapenh-apenh ngwenh apek twernk inehenhel rrkwapetjeh ilek, inang kangkwerretj-kweny, twernk inehenhel inenh angerr atwetjenh. ");
INSERT INTO amx_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Rrkwapenh-apenh arrpenh ngwenh apek kaltj-kweny anem, twernkel inenh mantj iletj-kweny apek, lakenh anetjeh. Rrkwapenh-apenh inang anetj mpwarekarl-penh, twernkel inenh kwek war nakepakel-iletjenh. Altjerrel arrpenh mapek wenh-wenh angerr anthem, rnwanentj apek inangkal apek. Altjerrel inenh ngkernem, wenh-wenh angerr arntarnt-aretjenh kwer. Altjerr ahentj-anem, inang rrkwapentj angerr mpwarem kwer, kelant rang inenh pawenhetjenh.” ");
INSERT INTO amx_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jesu-el kwertengerl kwerenh map kaltj-anthek, “Yeng petjek ahelh nhenh-warn, tjerrtj map twepelh-iletjeh. Arrpenh mapel awetj-kweny anetjenh, Altjerrel inenh rwang-warn wetjenh, kwetetharl amperl-anem-warn. Yeng ahentj-anem, Altjerrel parrp mpwaretjeh! ");
INSERT INTO amx_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Arrwekel-artek tjeng anem rwekenth-kenth angerr anthwerr irretjeh. Arrpenh mapel yeng atwetjenh. Yeng rrwampey awelhem, rwekenth-kenth kwer karelhemel. ");
INSERT INTO amx_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Arrantherr apek iterl-arehetj, yeng kwel ahelh nhenh-warn petjekarl, tjerrtj ingkerrek peltj-iletjeh kwel? Itjam. Tjerrtj map ilterrerl-anetjenh tjengeng arrngel. ");
INSERT INTO amx_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Tjerrtj 5-arl apek warl nyentel anem. Lyeteng tjerrtj rrpwetj tjerrtj atherr arrpenheh arnkely anetjenh tjengeng arrngel. Tjerrtj atherr tjerrtj rrpwetj arrpenheh arnkely anetjenh. ");
INSERT INTO amx_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Angey ler rrwey kwerenheh arnkely anetjenh tjengeng arrngel. Ler rang angey kwerenheh arnkely anetjenh. Matj rang marl kwerenheh arnkely anetjenh tjengeng arrngel. Marl rang matj kwerenheh arnkely anetjenh. Anherrenheng-atherr arnkely anetjenh tjengeng arrngel.” ");
INSERT INTO amx_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesu-el tjerrtj map inenh ilek, “Arrantherr apek ankert aremeng, altwerleng arratemeng, lakenh arrantherr angkem, ‘Kwatj angkarl angerr petjemaw!’ Kwer-penh kwatjel anhentj-alhem. ");
INSERT INTO amx_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Aretharrel apek antekerreng wernemeng, lakenh arrantherr angkem, ‘Alkeremeh irrentjemaw!’ Kel lakenh irrem. ");
INSERT INTO amx_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Aretharrel wernemeng, arrantherr kel alhengk-arem, nthakenh irretjenharl. Thang kel twer angerrel arrehantherreng anngetherr mpwarek. Arrantherr yeng itjarl alhengk-arek. Arrantherr itja kaltj anem, nthakenharl Altjerrel mpwarem, nthakenh Altjerr ahentj-anem. ");
INSERT INTO amx_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Arrantherr kaltj anetj-kwenh, arratj mernelhetjeh. ");
INSERT INTO amx_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Tjerrtj arrpenhel apek ngwenh court-warn angem. Ntwang kwerel-ayel peltj-irretjeh, mpwel court-warn alherremeng. Itjeng apek, rang ngwenh judge-eng ularr iletjenh. Judge-el rrkwentj iletjenh, ngwenh tjayel-warn kwernetjeh. ");
INSERT INTO amx_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Arratj kwenh, ntwang itja tjayeleng arratetjenh, ntwang fine ingkerrek ngkwengenh rrpwaretjeh-atwetj.” Lakenh Jesu-el map kaltj-anthek. ");
INSERT INTO amx_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Artwang rrpwetj Jesu-warn petjek angketj anetj-akert. Inang renh ilek, “Nwern angketj awek, artwang Galilee-areny map church angerretj-warn irrpek, ker tjenkerr atwemel anthetjeh Altjerrek. Inang ker map anthetjam-rlwer, twernk angerr arreny Pilate-kenh atwenh-atwenh map church-warn irrpek, inang Galilee-areny inenh irrernng atwerrerrek.” ");
INSERT INTO amx_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesu-el inenh pawenhek, “Nthakenh arrantherr iterrem? Wenheng artwang Galilee-areny nheng map ilwek? Inang rrwernelhek kwey, anetj-ilelhekarl apek? Altjerrel apek inenh rwekenth-kenth-ilek? Galilee-areny arrpenh map inang merel antarl anek. Inang mwerr-lkwer ineheng apek anek? ");
INSERT INTO amx_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Itja anthwerr! Arrantherr nhenheh-arlk kaltj anetjeh. Arrantherr anetjeng Altjerr-warn twep-irretjeh, arrantherr alenh map-arteh ilwehetjeng! ");
INSERT INTO amx_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Arrantherr angketj arrpenhek key irlpangkemam, tjerrtj 18 nheng inarl mer Siloam-el ilwekarl, warl arlpentj angerr ineh-warn takelhemel anyekarl? Arrantherr key iterrewarrem, inang kwel Jerusalem-areny arrpenh mapeng anetj-lkwer anekarl? Lakenheng key, inang ilwek? Altjerr ineh iterretj-kweny key anek, inenh arntarnt-aretj-kweny anek apek? ");
INSERT INTO amx_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Itja anthwerr! Lakenheng arrantherr nhenheh kaltj anetjeh. Arrantherr Altjerr-warn twep-irretjeh, arrantherr ilwehetjeng.” ");
INSERT INTO amx_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesu-el angketj nhenh ilek, “Artwang rang arnang tjwerrk ngkernek grapes farm kwerenhel-ayeng. Tjwerrk angerr rang mangkek. Kel arrpenh-ingar artwang rang petjek, mern tjwerrk kwetjetjeh. Artwang rang ywarek mern kwer. ");
INSERT INTO amx_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Rang rrkwapenh-apenh renh ilek, ‘Yeng 3 years-ek-atwetj kweteth merneh petjetjart, mern inenh kwel kwetjetjeh. Thang kweteth ywaretjart. Kel arnang tjwerrk renh rlweth-atwang, mern-kwenyeng wart. Rang pelkel war mangkek.’ ");
INSERT INTO amx_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Rrkwapenh-apenh rang angkek, ‘Twernkay! Arnang renh year nyent weth impang. Thang ahelh inyetjenheng-amparr, pwelek-kenh kart-amparr arrernetjenheng, kwer-penh thang kwatj angerr kwer theletjenheng. ");
INSERT INTO amx_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Rang apek mern ngwerrm-ilem, kel mwerr. Itjeng apek, thang renh rlweth-atwetjenh, ntwarl yeng ilekarl-arteh.’ ” Lakenh Jesu-el inenh ilek. ");
INSERT INTO amx_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Saturday arltang arrpenhel Jesu-el tjerrtj map kaltj-anthetjam church kwenel. ");
INSERT INTO amx_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Church kwen kwerel marl nyent anek, rarl 18 years-eh-atwetj artep anetj-akert anekarl. Kwerrern anetjel artep kwerenh anetj-ilek. Marl rang ywarn arratj irnek, altjwernemel war alhetjart. ");
INSERT INTO amx_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesu-el marl renh aremel, rang kwer ntangkelhek. Rang renh ilek, “Marlay! Artep ngkwengenh-artek kel mwerr-irrek!” ");
INSERT INTO amx_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jesu-el iltjang kwerenh kwer-arleh arrernemel, marl rang kel arratjenyemeh irnek, mwerr-irrekarl. Rang arratjenyemeh nthwerl-apek. Rang Altjerreh kangkemel nakek. ");
INSERT INTO amx_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Jesu-el marl renh Saturday arltel mwerr-ilekarleng, church-ek-artwey rang arnkely-irrekarl. Rang tjerrtj map ilek, “Arltang 6 kel anem nwerneh rrkwapetjeh. Arrantherr apek ahentj-anem, Jesu-el arrantherrenh mwerr-iletjeh, kel arltang 6 nhenh ineheng petjay. Angketj nwern-henhel-ayeng intem, arrantherr itja Saturday arltang angerrel rrkwapetjeh. Lyet Saturday arltang tjeperr nwern ltjwerretjeh. Arltang arrpenhel arrantherr petjetjeh, Jesu-el arrantherrenh mwerr-iletjeh-anngernt.” ");
INSERT INTO amx_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ngkartel artwang inenh ilek, “Arrantherr urrtjalth mapay! Arrehantherr-henh pwelek apek anem, tangkey apek. Saturday arltel arrantherr rrkwapem, renh rope kap-rlwemel kwatj-warn tjarr-angemel. Lakenh kwenh arrantherr rrkwapem arltang Saturday-el. ");
INSERT INTO amx_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Lakenh-arteh yeng lharrp-irrem marl nhenheh, rang Abraham-kenh peltj anem arrehantherr-arteh. Renh arrentj angerrel 18 years-ek-atwetj arrwengkelthel anetj-ilek. Tjeng anem Saturday arltel renh mwerr-iletjeh.” ");
INSERT INTO amx_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Tjerrtj Jesu-eh ahentj-kweny map inang nyerr-irrek. Tjerrtj arrpenh map kangkemel arrken-irrerl-anek, Jesu rang mwerr anthwerr mpwarekarleng. ");
INSERT INTO amx_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Kwer-penh Jesu-el tjerrtj inenh pawenhek, “Nthakenham Altjerr-henh nakenh-nakenh map aningkam-aningk-irrem? ");
INSERT INTO amx_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Thang arrantherrenh angketj nhenh ilem. Artwang nyentel tjwerrk anngang mer kwerenhel arrernek. Anngang rang mangkemel, arnang tjwerrk lyapek. Thep map petjek, arnang kwerel antjwang mpwarek.” ");
INSERT INTO amx_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jesu-el inenh weth pawenhek, “Nthakenham Altjerr-henh nakenh-nakenh map aningkam-aningk-irrem? ");
INSERT INTO amx_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Thang angketj mern arlwar-ilenh-ilenh-akert ilem. Marlel mern arlwar-ilenh-ilenh kwek war inem, mern arletj angerr-warn nyentelh-iletjeh. Mern arlwar-ilenh-ilenh kwek rang mern arletj renh arlwar-ilem.” ");
INSERT INTO amx_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Kwer-penh Jesu Jerusalem-warn alherl-apetjam, rang tjerrtj map kaltj-antherl-apetjam, town kwek mapel town angerr mapel thwen. ");
INSERT INTO amx_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Tjerrtj nyentel renh pawenhek, “Ngkartay, Altjerrel tjerrtj rrpwetj war key angetjenh, kwerel-ayeng iteth kwet anetjenheng?” Jesu-el inenh ilek, ");
INSERT INTO amx_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Mantj iterrerl-anetjeh, mer alkerarl anetjenheng-anngernt. Arrantherr-artek athek-irretjeh arrew pwarn kwer-angkwerr irrpetjeh-anngernt. Tjerrtj map anthwerr athek-irrem, arrew pwarn kwer-angkwerr irrpetjeh, inang ywarn irrpem arrew pwarneng wart. ");
INSERT INTO amx_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Thang angketj arrpenh ilem. Kelant warlek-artwey rang arrew renh kel martetjenh. Kwer-penh arrantherr kethel irnemel arrew kwerel rltar-atwemel angketjenh, ‘Ngkartay! Nwerneh altjwer-ilang!’ Rang arrantherrenh iletjenh, ‘Yeng itja arrehantherr kaltj! Nthenh-areny arrantherr?’ ");
INSERT INTO amx_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Kwer-penh arrantherr angketjenh, ‘Nthakenhay? Nwern kwenh ngkwengel-ayel mern-arlk arlkwek, kwatj-arlk antjwek. Ntwang nwernenh mer nwern-kenhel kaltj-anthek.’ ");
INSERT INTO amx_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Rang arrantherrenh iletjenh, ‘Yeng itja kaltj arrehantherr. Arrantherr-artek tjerrtj anetj map! Kel tjengeng alherrerrayantay!’ ");
INSERT INTO amx_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","“Altjerrel arrantherrenh kel keth-warn anpwetjenh. Arrantherr Abraham Isaac Jacob thwen Altjerr-henh angketj angenh-angenh map thwen aretjenh, Altjerr-henh mer anganentjel anerleh. Kwer-penh arrantherr arnetjenh ampangkemel. ");
INSERT INTO amx_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Tjerrtj kel ingerreng altwerleng ayerrereng antekerreng petjetjenh Altjerr-henh mer anganentj-warn, kwerel tjenkerr arlkwetjenheng. ");
INSERT INTO amx_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Tjerrtj arrpenh map inarl lyet ingkern-irrem, inang kelant arrwekeleh irretjenh. Tjerrtj arrpenh map inarl lyet arrwekel-irrem, inang ingkern-irretjenharl.” ");
INSERT INTO amx_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Kwer-penh artwang Pharisee rrpwetj Jesu-warn petjek. Inang Jesu renh ilek, “King Herod-artek ahentj-anem, ngwenh irrernng atwetjeh. Kel mer arrpenh-warnant alhang!” ");
INSERT INTO amx_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesu-el inenh ilek, “Arrantherr artwang angwely arnwer-arteh renh ilerrerrang, ‘Lyet ngwenth thwen thang arrentj map anpwetjenh, tjerrtj map-arlk thang mwerr-iletjenh. Kel arltang arrpenhel rrkwapentj tjengenh kel ywerretjenhemeh.’ ");
INSERT INTO amx_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Arltang rrpwetjel yeng tjeyel angkep alpem Jerusalem kwer-warn. Altjerrel yengenh ilek, mer kwer-warn angkep alpetjeh. Inang itja yengenh irrernng atwetjenh mer nhenhel. Jerusalem-elant kwenh inang yengenh irrernng atwetjeh, angketj angenh-angenh inenh inang atwekarl-arteh mer kwerel. Angketj angenh-angenh inang ingkerrek ilwek Jerusalem-el. ");
INSERT INTO amx_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Tjerrtj Jerusalem-areny mapay! Arrantherr kwenh Altjerr-henh angketj angenh-angenh map irrernng atwekarl! Urrpey map arrantherr inenh irntel iltewekarl, inenh Altjerrel arrehantherr-warn lanthekarl. Keweny mapay, yeng kwet ahentj-anek, arrantherrenh arrawelh-iletjeh, tjwek-tjwek marlel kwerrk kwerenh map arrawelh-ilem-arteh. Arrantherr ahentj-kwenyarl tjeng anek. ");
INSERT INTO amx_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Lyet Altjerrel church angerretj kwerenh mentjarl imperl-alhem. Arrantherr yengenh aretj-kweny anetjenh. Kelant arrantherr yengenh aretjenh, lakenh arrantherr angketjenh, ‘Nwern renh naketjeh, rarl Ngkart-henh arrenyel-ayeng petjetjenheng.’ ” Lakenh Jesu-el angketj Jerusalem-areny map-akert ilek. ");
INSERT INTO amx_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Arltang angerr Saturday arrpenhel Jesu rang alhek artwang angerr Pharisee nyent-kenh warl-warn. Pharisee rang arrwekel renh ntangkekarl, mern arlkwetjeh. Tjerrtj mapel Jesu renh mantjel arerl-anek, nthakenh rang mpwaretjenh. ");
INSERT INTO amx_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Artwang irlkert angerr Jesu-eng ularr anek. Kwerenh akwang atherr ngkwern atherr thwen wangkentj angerr. ");
INSERT INTO amx_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesu-el artwang Pharisee map kaltj-anthenh-anthenh map thwen inenh pawenhek, “Mwerr key thang arltang angerrel tjerrtj irlkert mwerr-iletjeh? Itja apek?” ");
INSERT INTO amx_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Inang intert kwet anek, tjernetj-kweny. Jesu-el artwang irlkert renh pwerlep antwerrkemel mwerr-ilek. Kel rang renh mwerremeh angkep lanthek. ");
INSERT INTO amx_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Kwer-penh Jesu rang inenh pawenhek, “Angketj nhenh iterl-arerrerrang. Ler rrwey ngkwengenh apek, pwelek ngkwengenh apek ipertek anyem arltang Saturday-el. Ntwang kwenh renh arltang Saturday kwerel kwet parrp tjarr-inetjenh.” ");
INSERT INTO amx_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Inang ywarn iterl-arek, kwer angkep angketjeh. ");
INSERT INTO amx_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Kel map anerl-anek artwang Pharisee-kenh warlel. Jesu-el arek, tjerrtj mernek petjekarl map inang ahentj-irrek, arrwekel arrernelhetjeh. Rang inenh angketj nhenh kaltj-anthemel ilek, ");
INSERT INTO amx_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Artwang ngwenhel apek ngwenh mpweny-henh tjenkerrek ngwem, ntwang itja arrwekel arrernelhetjeh, twernk angerr apek petjehetjeng-arlk. ");
INSERT INTO amx_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Kwer-penh artwang rang ngwenh tjenkerr-warn ngwekarl, rang ngkweng-warn petjem apek, ngwenh iletj-alhem, ‘Nhenheng alhay! Twernk angerr nhenhel arrernelhetjenheng!’ Kwer-penh ntwang nyerr-irremel ingkern arrernelhem. ");
INSERT INTO amx_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Lakenheng ntwang apek tjenkerr-warn petjem, ntwang ingkern arrernelhetjeh. Kwer-penh artwang rarl ngwenh ngwekarl, rang ngwenh iletjenh, ‘Peltjay! Keth mwerr-lkwerel anetjeh petjay!’ Arrpenh mapel nhenh aremel, inang ngkweng-penh kel iterretjenh, ‘Ay! Artwang mwerr anthwerram yanhan!’ ");
INSERT INTO amx_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tjerrtj ngwenh apek rarl nakelhem, renh Altjerrel ingkern arrernetjenh, nyerrel anthemel. Tjerrtj ngwenh apek rarl Altjerreng ularr mwerr nakelhetjal nyerr-nyerr mernelhem, Altjerrel renh tjeperr anewetjenh, arrpenh mapeng arrwekel arrernetjenh. Tjerrtj map kwer-penh angketjenh, ‘Ay! Artwang yanhan arratj anthwerr!’ ” ");
INSERT INTO amx_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesu artwang Pharisee kwer-warn angkek, rarl renh nheng mern tjenkerrek ngwekarl, “Ntwang apek tjenkerr mpwarem, ntwang itja ngwetjeh peltj ngkwengenh map tjey ngkwengenh map thwen arlaltj ngkwengenh map thwen maney mantarr angerr-akert map thwen, mern arlkwetjeh. Ntwang inenh ngwemeng, inang kelant ngwenh merneh angkep ngwetjenh. ");
INSERT INTO amx_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ntwang apek tjenkerr mpwarem, ntwang tjerrtj rnwanentj-kweny maney-kweny map ngwetjeh, tjerrtj iltjang anetj map thwen, tjerrtj arlamarr map thwen, tjerrtj pweng map thwen, inenhant ngwetjeh! ");
INSERT INTO amx_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ineh maney itja intem, ngwenh angkep mern arlkwetjeh ngwem. Lakenh Altjerrel ngwenh kwart-wetjenh, arltang kwerel Altjerrel tjerrtj arratj inenh irrernngeng kemelh-ilemeng.” ");
INSERT INTO amx_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Artwang arrpenh angkek, rartek merneh petjekarl. Rang lakenh angkek Jesu kwer, “Tjerrtj alenh map kweteth arrken angerr Altjerrel-ayeng anetjenh, mer angerr kwerenhel, tjenkerr-arlk arlkwerl-anemel. Altjerr rang inenh kweteth kwart-wetjenh!” ");
INSERT INTO amx_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesu-el renh kaltj-anthek, “Thang arrantherrenh angketj iletjeh twernk angerr-akert. Twernk rang tjenkerr angerr rrkwapek. Rang tjerrtj map arrwekel kwet ilek, rang inenh tjenkerreh ntangketjenharl. ");
INSERT INTO amx_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Mern-arlk ker-arlk ingkerrek kel itekarleng, twernk rang rrkwapenh-apenh kwerenh map urrpey lanthem, tjerrtj inenh weth ngwetjeh, ‘Petjewarray, mern-arlk ingkerrek kel anem.’ ");
INSERT INTO amx_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Tjerrtj inang itja ahentj-anek petjetjeh. Tjerrtj nyent angkek, ‘Thartek kel mer kwek payem-ilek. Yeng lyet alhem, mer renh arerl-alpetjeh. Yeng kelekant impang.’ ");
INSERT INTO amx_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“Tjerrtj arrpenh angkek, ‘Thang kwenh pwelek map payem-ilek. Yeng lyet alhem, inenh aretjeh. Yeng kelekant impang.’ ");
INSERT INTO amx_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Tjerrtj arrpenh angkek, ‘Thang kwenh lyet anew inek. Yeng anerl-anem kwer-akert.’ ");
INSERT INTO amx_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Rrkwapenh-apenh rang twernk kwerenh iletj-alpek. Twernk rang ahang-irremel rrkwapenh-apenh kwerenh ilek, ‘Parrp tjey angerr map-warn tjey kwek map-warn thwen alhang, town angerr nhenhel. Ntwang tjerrtj rnwanentj-kweny maney-kweny map, iltjang anetj-akert map, arlamarr map, pweng map thwen, nhenh-warn angetjang.’ ");
INSERT INTO amx_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Rrkwapenh-apenh rang alhek. Rang petj-alpemel twernk kwerenh ilek, ‘Nhenheyay inang kel petjek! Thang kel tjerrtj nhenh inenh angetjek. Keth angerr kwet anem warl ngkwengenhel.’ ");
INSERT INTO amx_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Twernk kwerenhel renh ilek, ‘Ntwang town-eng keth-warnemeh alhang. Tjerrtj map weth ngwetjeh, inenh warl tjengenh-warn angetjang, kel tjerrtj aningkemeh warl tjengenhel anetjenheng. ");
INSERT INTO amx_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Tjerrtj inenh tharl arrwekel ntangkekarl, inang ahentj-kweny-irrek petjetjeh. Inang itja anthwerr mern tjenkerr kwek apek arlkwetjenh mer tjengenhel.’ ” ");
INSERT INTO amx_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tjerrtj aningk Jesu-eng ingkern-angkwerr alhek. Jesu rang alngarelhemel inenh ilek, ");
INSERT INTO amx_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Tjerrtj ngwenh apek rarl tjengel-ayel ingkern petjetjeh ahentj, rang kel tjeng angerr kangketjeh. Rang iteth kwerenh mentj anthelhetjeh. Tjerrtj ngwenh apek rang arlaltj kwerenhehant kangkem, angey kwerenheh apek mwek kwerenheh apek, anew kwerenheh apek, kwer kwerenheh apek, kek kwerenheh apek, angkwerek kwerenheh apek, tjeyekw kwerenheh apek inehant kangkem, itja lakenh. Altjerreng ularr arlaltj kwerenh mapeh rang kwek war kangketjeh. Itjeng rang itja nakenh-nakenh tjengenh anem. ");
INSERT INTO amx_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Tjerrtj ngwenh apek tjengel-ayel ingkern petjetjeh ahentj, rang yeng-arteh anetjeh, mpatj tjeyenh ingkentetjeh. Arrpenh mapel renh atwem apek, rang kwenpel tjengel-ayel petjetjeh, impetj-kweny anetjeh. ");
INSERT INTO amx_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Thang angketj kwek arrantherrenh ilem. Artwang nyent ngwenh apek ahentj-anem warl alkey artetjeh. Rang kwenh arrwekel pawenhelhem, kwer apek maney intemeng, warl renh artetjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Itjeng apek, rang warl renh artelhemeng maney kwer ywerrehetj. Kwer-penh arrpenh mapel renh aremel arrkentj-ilehetj, ");
INSERT INTO amx_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","lakenh angkemel, ‘Rang warl alkey artetjeh anek. Rang nhenh ywarn mpwarek!’ ");
INSERT INTO amx_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","32","“Thang ilem angketj arrpenh twernk atherr-akert. Twernk nyent apek twernk arrpenhel-ayeng atwerretjeh ahentj, kwerenh anek atwenh-atwenh 10,000 war. Twernk arrpenh kwer atwenh-atwenh 20,000 anek. Twernk arrwekeleny atwenh-atwenh 10,000-akert rang arrwekel mantj iterretjeh, ‘Ay! Twernk yanhel artwang atwenh-atwenh angerr anthwerr anyenem. Thang itja tjengenh map lanthem, arrpenh mapel-ayel atwerretjeh, itja. Inang tjengenh map ingkerreny atwehetjeng!’ Lakenh rang artwang rrpwetj kwer-warn lanthetjenh, kwerel-ayeng peltj-irretjeh.” ");
INSERT INTO amx_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jesu-el inenh ilek, “Tjerrtj ngwenh apek tjengeng ingkern petjetjeh ahentj, arrwekel rang iterretjeh-amparr, rang tjengeng ntjwem-irrehetj. Rang tjeng-amparr iterretjeh. Rang rnwanentj kwerenheh kwek war iterrerl-anetjeh. Rnwanentj kwerenh mer-arlk apek rang mentj impetjeh. Rang tjengel-ayeng petjetjeh. ");
INSERT INTO amx_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","35","“Thang angketj arrpenhemeh ilem ilewerr-penh. Tjerrtjel ker-warn ilewerr arrernem, arlkwetjeh-anngerntel. Ilewerr apek mentj interl-anem, rang apek kwang-kweny-irrem. Nwern ywarn ilewerr renh weth kwang-akert-ilem. Tjerrtjel ker ilewerr-kweny itja arlkwem, itja kwemey. Nwern renh mentjemeh impem, tjerrtjel renh kel wem. Keth-ilentj: Tjerrtj irlpareth inang ilewerr mwerr-arteh anem. Inang tjerrtj arrpenh map mwerr-ilem, ilewerrel ker mwerr-ilem-arteh. Inang irlpareth-kweny irrem apek, inang ilewerr anetj-arteh irrem. Altjerrel inenh taly-wetjenh. “Arrehantherr irlpang apek intemeng, yeng awerrerrang irlpakert irremel!” ");
INSERT INTO amx_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Arrpenh-ingar artwang tax maney kwetjenh-tjenh map tjerrtj anetj-anetj arrpenh map thwen Jesu-warn arraw-irrek, angketj kwerenh awetjeh. ");
INSERT INTO amx_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Artwang Pharisee map kaltj-anthenh-anthenh map thwen inang tjel-angkerrek, “Artwang nhenh-artek tjerrtj anetj mapeh peltj anem. Rang inehel-ayeng mern-arlk arlkwem. Nwern ahentj-kwenh.” ");
INSERT INTO amx_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jesu-el inenh ilek, “Awerrerrang angketj nhenh, tharl arrehantherr keth-ilem. ");
INSERT INTO amx_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Ntwang apek yep-yep 100 anyenem. Yep-yep nyent apek parlp-irrekarl, ntwang alhem yep-yep kwer palenthwetjeh, renh ngwerrm-iletjeh-atwetj. Yep-yep arrpenh map ntwang kethel imperl-alhem. ");
INSERT INTO amx_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Yep-yep renh ntwang ngwerrm-ilemel, ntwang renh arrkenel angetj-alpem yep-yep arrpenh map-warn. ");
INSERT INTO amx_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Kwer-penh ntwang mer-warn alpemel, ntwang peltj ngkwengenh map tjerrtj mer-areny arrpenh map thwen arraw-ilemel ilem, ‘Yep-yep nheng tharl parlp-ilekarl thang renh ngwerrm-ilek! Arrantherr tjengel-ayel arrken anerrerrang!’ ");
INSERT INTO amx_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Lakenh-arteh angel alker-areny map arrken anthwerr awelhem tjerrtj nyenteh, rarl Altjerr-warn twep-irrekarl. 99 arrpenh map inang arratj kwereng ularr anem. Angel map ineh kwek war arrken awelhem.” ");
INSERT INTO amx_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Jesu angkek, “Angketj arrpenh nhenh awerrerrang. Marl nyentel ngkweltj tjeperr anyenem 10 pel. Rang ngkweltj nyent parlp-ilek. Rang rwang kep kwerenh anthelem. Rang warl kwerenh irrkerem, rang maney kwerenheh mantjel palenthwem, renh ngwerrm-iletjeh-atwetj. ");
INSERT INTO amx_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Rang ngkweltj renh ngwerrm-ilem, rang peltj kwerenh map mer-areny arrpenh map thwen ngwem. Rang inenh ilem, ‘Yeng arrken anthwerr awelhem! Ngkweltj nheng tharl parlp-ilekarl, thang kel ngwerrm-ilek. Tjengel-ayel arrken anerrerrang!’ ” ");
INSERT INTO amx_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Jesu-el inenh ilek, “Marl nheng arrken awelhek-arteh, lakenh Altjerr-henh angel alker-areny map arrken awelhem, tjerrtj anetj-akert nyent rarl Altjerr-warn twep-irremel petj-alpekemeh.” ");
INSERT INTO amx_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesu-el angketj nhenh ineh ilek, “Artwang nyenteh ler atherr anek. ");
INSERT INTO amx_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Ler ingkerneny rang angey kwerenh pawenhek, ‘Angeyay, kelant ntwang ilwemeng, ilerneh lyet-antey maney renh kert-atherr-ilang.’ Artwang rang kel kangkwerremel maney kwerenh-arlk ler kwerenh-atherreh akalkelh-ilemel anthek. ");
INSERT INTO amx_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Kel arltang arrpenhel ler ingkerneny rang rnwanentj maney thwen kwerenh-akert mer kwerenh imperl-alhek. Rang ntwarr alhek mer arrpenh-warn. Mer kwerel rang maney kwerenh intjarlkwek, ngkwarl angerr antjwemel marl map-arlk alwernerl-apemel. ");
INSERT INTO amx_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Rang maney kwerenh kel ywerrelh-ilek. “Kwer-penh kwatjel itja anhek years rrpwetjek-atwetj. Mer alenh kwerel inang palekalek-irrek merneh kwatjeh thwen. Rang arrakelakel kwenh anerl-anek, mern-kweny. ");
INSERT INTO amx_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Artwang arrpenh rang farm-ek-artwey anek, rang pek-pek map anyenek. Ler rang kwer-warn petjemel renh pawenhek, ‘Yeng ahentj-anem, ngkweng rrkwapetjeh.’ Artwang rang renh lanthek, pek-pek kwerenh map arntarnt-aretjeh. ");
INSERT INTO amx_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ler rang angayel anthwerr awelhemel anek. Rang ahentj-anek, pek-pek map-henh mern arlkwetjeh. (Pek-pek-henh mern anngang arnang arreny carob-henheng.) Tjerrtj nyentel renh itja mern arlkwetjeh anthek. ");
INSERT INTO amx_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Kel rarrp alngampemel iterrek, ‘Angey tjengenh-henh rrkwapenh-apenh mapel mern arwenth kwet arlkwerl-anem. Yeng nhenhel ngkwal ilwetjenharl, mern-kweny wart. ");
INSERT INTO amx_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Yeng kel alethehant irretjenh, yeng angey tjengenh-warn angkep alpetjenh, kwer-penh yeng kwer ilelhetjenh, “Angeyay, yeng Altjerreng ularr anetj mernelhek, ngkwengeng ularr thwen. ");
INSERT INTO amx_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Yeng itja ler ngkwengenh-arteh mernelhetjenh, lakenh ntwang yengenh itja weth ler ngkwengenh anewetjeh. Yeng kel rrkwapenh-apenh ngkwengenh aneyay.” ’ Lakenh rang arrwekel iterrek, nthakenh rang ilelhetjenh angey kwerenh-warn. ");
INSERT INTO amx_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Kwer-penh rang kel angkep alethek irrek angey kwerenh-warn. Angey kwerenhel renh ntwarr-warn ularr petjerleh arnarek. Angey rang kwer-warn arnek-arner arrtjanek, rang kwer angerr nyerrkekarleng wart. Rang renh amel-rrkwemel arrantjwek. Rang kwer lharrp-irrek. ");
INSERT INTO amx_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","“Ler rang angkek, ‘Angeyay, yeng Altjerreng ularr anetj mernelhek, ngkwengeng ularr thwen. Yeng itja ler ngkwengenh-arteh mernelhek. Lakenheng ntwang itja weth yengenh ler ngkwengenh anewetjeh.’ ");
INSERT INTO amx_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Angey rang rrkwapenh-apenh kwerenh mapeh ntangkelhek, inenh ilemel, ‘Parrpay, mantarr mwerr anthwerr kwer inetjeh alhang, renh irrpelh-ilerrerrang. Ring iltjang kwerenheh angetjewarrang, pwet ingkang kwerenheh irrpelh-ilerrerrang. ");
INSERT INTO amx_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kel arrantherr ker pwelek kwek anter angerr atwerl-atherr-alpang! Ker-arlk mern-arlk iterrerrang! Nwern ker mern tjenkerr angerr arlkwetjenheng. Nwern arrken angerr anetjenheng! ");
INSERT INTO amx_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ler tjengenh irrernng-arteh anekarleng, rang lyet weth iteth anem. Yeng iterrek, rang ilwekarleh-athen, rang weth nwerneh-warn petj-alpek. Tjenkerr kwer iterrerrang! Nwern kel arrkenel war arlkwetjenheng!’ Kel inang tjenkerr mpwaremel arrken-irrek, mern ker thwen angerr arlkwek. ");
INSERT INTO amx_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Kekw kwerenh rang farm-el rrkwapetjam. Angwerr-angwerr rang mer-warnemeh petj-alpek. Rang itwek-irremel inenh awek, alyelherleh anthep-irrerleh thwen. ");
INSERT INTO amx_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Rang rrkwapenh-apenh nyenteh ntangkelhemel renh pawenhek, ‘Nthakenham inang irreperrem?’ ");
INSERT INTO amx_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Rrkwapenh-apenh rang renh ilek, ‘Tjey ngkwengenh petj-alpek. Angey ngkwengenhel pwelek anter angerr nyent atwek, tjenkerr angerr rang mpwarek. Tjey ngkwengenh iteth kwet petj-alpekarleng.’ ");
INSERT INTO amx_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Kekw rang awemel rang arnkely irrerl-alhek. Rang itja kwet warl-warn irrpek, kethel kwet karntek. Angey kwerenh kwer-warn arratemel alhek, angketjeh. Rang renh ilek, ‘Irrpentjangaw, tjey ngkwengenh aretjeh!’ ");
INSERT INTO amx_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Kekw rang angey kwerenh-warn kwerl-angkek, ‘Yeng ngkweng kweteth rrkwapek, ngkweng arratj kangkwerrentjek. Ntwang tjeng itja billygoat kwek nyent anthek, yeng peltj tjengenh mapel-ayeng arrken-irretjeh, tjenkerr angerr arlkwemel. ");
INSERT INTO amx_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ler ngkwengenh arrpenh nhenhel maney ngkwengenh intjarlkwek, marl map alwernerl-apemel. Rang petj-alpek, ntwang nyerrkentjel kwer pwelek anter angerr kwer atwek. Wenheng ntwang lakenh mpwarek?’ ");
INSERT INTO amx_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Angey kwerenhel renh ilek, ‘Ler kewenyay! Ntwang kwenh tjengel-ayeng kweteth anerl-anem. Maney mantarr-arlk ingkerrek tjengenh kel ngkwengenh anem. ");
INSERT INTO amx_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ilehak anem, tjey ngkwengenheh kangkentj mernelhetjeh, kwerel-ayeng arrken-irretjeh. Tjey ngkwengenh rang irrernng-arteh anekarleng, lyet rang iteth angkep anem. Rang nheng kwetant alhekarl-penh, lyet rang weth nwerneh-warn petj-alpek.’ ” ");
INSERT INTO amx_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesu-el kwertengerl kwerenh mapeh angketj ilek, “Artwang nyent maney angerr-akertel artwang arrpenh anyenek, arntarnt-aretjeh maney-arlk rnwanentj-arlk rrkwapenh-apenh-arlk kwerenh ingkerrek. Artwang alenharl rang itja arratj anek. Kelant tjerrtj arrpenh mapel artwang maney angerr-akert nheng angketj ilek, ‘Arntarnt-arentj ngkwengenh mantarr-arlk mer-arlk maney-arlk ngkwengenh ingkerreny intjwarlkek.’ ");
INSERT INTO amx_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Artwang rang arntarnt-arenh-arenh renh ngwek. Rang renh ilek, ‘Thartek yey anetj ngkweng-akert awek! Nthakenh ntwang ilek maney mer-arlk tjengenh? Kel nhenh ingkerrek pip-warn arrernang. Kwer-penh thang ngwenh anpwetjenh!’ ");
INSERT INTO amx_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Arntarnt-arentj rang kwewaleny ilelhek, ‘Yeng nthakenham irretjenh? Twernk tjengenhel yengenh anpwetjenh. Nthakenhameh thang rrkwapentj arrpenhan inetjenh? Thang ywarn ipert angernetjenh, yeng-artek artwang aywang wart. Yeng ahentj-kweny nyerremeh anetjenh, tjerrtj arrpenheh ankeyel pawenhetjeh. ");
INSERT INTO amx_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Yeng apek peltj-kweny anemeng, yeng peltj arrpenheh palenthwetjeh, yeng arntarnt-aretjeh, twernk tjengenhel yengenh anpwekarleng wart. Kel thang lakenh mpwarem.’ ");
INSERT INTO amx_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Kel arntarnt-arenh-arenh rang arrpenh map ngwek, inang maney angkep anthetjeh-anngernt twernk kwerenheh. Rang artwang nyent pawenhek, ‘Nthakentj apek ntwang alhelekarl twernk tjengenheh?’ ");
INSERT INTO amx_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Artwang rang ilelhek, ‘100 drum anter-akert.’ Arntarnt-arentj rang renh ilek, ‘Pip arrpenh-warn arrernang 50. Lyet-antey 50 drum nhenhant parrp kwer kwart-wang.’ ");
INSERT INTO amx_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","“Kwereng arntarnt-arenh-arenhel artwang arrpenh pawenhek. ‘Ntwarteh? Nthakentj apek ntwang alhelekarl twernk tjengenheh?’ Rang kwer ilelhek, ‘1,000 yakweth mern wheat-akert.’ Arntarnt-arentj rang renh ilek, ‘Pip arrpenh-warn arrernang 800 yakweth. 200 yakweth nhenh kwer parrp anthang.’ Lakenh-arteh rang kwewaleny tjerrtj arrpenh map peltj mpwarek ngwerl-ilemel. ");
INSERT INTO amx_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Twernk rang arntarnt-arenh-arenh renh nakek, rang arratj mpwarekarleng wart.” Jesu-elemeh angketj nhenh keth-ilemel ilek, “Tjerrtj inang ngwenh apek ahelh-arenyekant iterrem, inang Altjerreh iterretj-kweny anem, inartek athek-irrem peltjeh-arlk mantarreh-arlk, ineh kelant intetjenheng. Inang inangkal kapert altjwer anem. Tjerrtj arrpenh map inang alker-arenyekant iterremel anemarl map, inang itja iterrem peltj mpwaretjeh, rnwanentjek-arlk mpwaretjeh. Inartek rrkwapem alker-arenyekant. Inartek iterrem Altjerreng ularr arratj anetjeh wart. Altjerrel tjerrtj nhenh map kelant kwart-wetjenh. ");
INSERT INTO amx_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Mantjel awerrerrang! Arrehantherr apek maney intemeng, maney ngkwengenh lharrp-irremel anthang tjerrtj arrpenheh, itja maney rrkwetjeh, lakenh ntwang peltj-ilem tjerrtj arrpenh. Nheng maney ywerrem apek, arrantherr ilwetjenh apek, Altjerrel arrantherrenh mer kweteth kwerenh-warn irrpelh-iletjenh. Peltj arrehantherr-henh map arnekarner arrehantherr kangketjenheng. ");
INSERT INTO amx_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Tjerrtj ngwenhel apek rnwanentj rrpwetj arratj arntarnt-arem, rang kel rnwanentj angerr arratj arntarnt-aretjenh. Tjerrtj ngwenh apek rarl rnwanentj rrpwetj arntarnt-arentj-kwenh anem, arwengkalth apek, rang itjarl rnwanentj angerr arratj arntarnt-aretjenh. ");
INSERT INTO amx_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Arrantherr apek ahelh-areny rnwanentj arntarnt-aretj-kweny, Altjerrel arrehantherr rnwanentj alker-areny anthetj-kweny anetjenh. ");
INSERT INTO amx_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Arrantherr apek tjerrtj arrpenh-henh rnwanentj arntarnt-aretj-kweny anem, kel Altjerrel arrantherrenh rnwanentj itja kwart-wetjenh. ");
INSERT INTO amx_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Itja ntwang twernk atherr anyenetjeh. Ntwang twernk arrpenheh kangkem, twernk arrpenheh itjarl, kangkentj-kweny ntwang anetjenh. Ntwang itja iterrentj atherram rrkwetjeh. Ntwang itja iterretjeh maney angerr anyenetjeh. Altjerrehant war iterremel rrkwapang.” Lakenh Jesu-el kwertengerl kwerenh map ilek. ");
INSERT INTO amx_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Artwang Pharisee mapel Jesu awek. Inartek maneyeh angerr iterrek. Inang renh arrampewetjam. ");
INSERT INTO amx_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesu-el inenh ilek, “Arrantherr kwenh iterl-arem, arrantherr kwel arratj anthwerr mernelhemeng. Arrantherr ahentj-anem, tjerrtj mapel arrantherrenh naketjeh kwel, arrantherr tjeperr anemeng wart. Altjerr rang iterrentj arrehantherr-henheh kaltj kwet, iterrentj arrehantherr-henh anetj kwet anemeng wart, arrantherr maneyehant kwet iterrerl-anem. Altjerr rang iterrentj arrehantherr-henheh ahentj-kwenh irrem.” ");
INSERT INTO amx_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Ngkwey Altjerr rang tjerrtj map-warn angkek angketj Moses-henhel-ayeng, angketj angenh-angenh kwerenh mapel-ayeng thwen, artwang John-eh-atwetj. John-eng-ntjel thang angketj mwerr anthwerr renh kaltj-anthem, angketj nhenh thang arrantherrenh ilem, Altjerr rang tjerrtj ingkerrekeh Ngkart angerr anemeng wart. Tjerrtj inang ahentj-irrem anthwerr Ngkart-henh kwer anetjeh, iteth ngampekarl anetjeh kwerel-ayel. ");
INSERT INTO amx_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Alker nhenh, ahelh thwen ywerretjenh. Altjerr-henh angketj itjarl, rang ywerretj-kwenh kwet anetjenh. ");
INSERT INTO amx_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Artwang ngwenh apek rarl anew kwerenh impem, marl arrpenh anew inemarl, rang anetj mpwarem. Artwang arrpenh ngwenh apek rarl inem marl artwang arrpenhel impekarl, rang-arlk anetj mpwarem.” ");
INSERT INTO amx_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesu-el inenh angketj nhenh ilek, “Artwang rnwanentj arwenthek-artwey kweteth mern ker angerr arlkwetjart, rang rnwanentj amparrkeyeh kweteth irrpetjart. ");
INSERT INTO amx_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Artwang nyent tjwen apapeth anetjart, arreny kwerenh Lazarus. Tjerrtj arrpenh mapel Lazarus renh artwang alenh-henh warl-warn angetjek, merneh ankey, kereh thwen. Inang renh arrewel arrernek. Angwelyelemeh tjwen kwerenh wantjek. Lazarus rang ahentj-irretjam mern ampeny-ampeny arlkwetjeh, nheng table-penh mern ker-arlk ahelh-warn anyekarl. ");
INSERT INTO amx_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Artwang Lazarus rang kel ilwek. Kwer-penh angel alker-areny map petjek, renh Altjerr-henh mer kern-warn anginek, rang Abraham-kenh mapel-ayeng iteth anetjeh. Artwang rnwanentj arwenth-akert rangemeh ilwek. Arrpenh inang artwang renh kel awenng-warn arrernek. ");
INSERT INTO amx_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Mer rwang anganentj angerrelemeh rang angerr ampangketjam, rang kern-arntep aremel, rang Abraham renh arek ntwarr anerleh. Rang Lazarus arek, Abraham kwerel-ayeng anerleh. ");
INSERT INTO amx_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Rang arlkemel pawenhek, ‘Angey Abraham-ay! Tjeng lharrp-irrang! Yeng rwang alngenth nhenhel angerr ampangkem! Lazarus yanh lanthang tjeng-warn! Rang kwatj angetjetjeh, aleny tjengenh rang ngwerl-iletjeh.’ ");
INSERT INTO amx_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Abraham-el renh ilek, ‘Ler tjengenhay, iterl-aray, ahelhel ntwang anetjart, mern arwenth ntwang rrkwetjart. Ntwang rnwanentj amparrkey-arrkey-akert anetjart, warl mwerrel anetjart. Lazarus rang ankey ngkweng-warn petjetjart, angayel, rnwanentj anetj-akert. Lyet rang tjengel-ayeng anerl-anem, Altjerrel renh arntarnt-arerl-anem. Ntwang kwenh amperl-anem rwang angerrel. ");
INSERT INTO amx_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ntwang arem, yanh nwerneheng mpwepel atwatj angerretj intem. Lakenheng tjerrtj rang apek ahentj-irrem nhenheng arrehantherr-warn alhetjeh, rang ywarn atwatj kwer-angkwerr alhetjehan. Arrantherr ywarn nhenh-warn petjetjeh, itja.’ ");
INSERT INTO amx_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Artwang rang angkek, ‘Angey Abraham-ay, Lazarus urrpey lanthang, angey tjengenh-henh mer-warn, ");
INSERT INTO amx_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","tjey tjengenh 5-arl anemarl-warn, rang inenh ateng-iletjeh, inang mer nhenh-warn petjehetjeng.’ ");
INSERT INTO amx_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Abraham-el renh ilek, ‘Inang kel angketj nheng Moses-el arrernekarl anyenem. Inang angketj inenh anyenem, Altjerr-henh angketj angenh-angenh ngkwey arrernekarl. Inang angketj nhenh map-penh read-irremel kangkwerretjeh.’ ");
INSERT INTO amx_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Artwang rang angkek, ‘Angey Abraham-ay! Inang Altjerr-henh angketjeh itja kangkwerrek. Artwang nyent apek arrwetjeng kemerremel ineh-warn petjem inenh ateng-ilemel, inangemeh Altjerr-warn kangkwerremel twep-irretjenh.’ ");
INSERT INTO amx_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Abraham-el renh ilek, ‘Inang Moses-henh pipeng read-irremel itja kangkwerrem apek, Altjerr-henh angketj angenh-angenh ngkweyeny map-henheng thwen-arlk, lakenheng inang itja Altjerr-warn twep-irretjenh, inang itja tjerrtj nyenteh kangkwerretjenh, rarl arrwetjeng kemerrekarleh.’ ” ");
INSERT INTO amx_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","2","Jesu-el kwertengerl kwerenh map ilek, “Arrpenhel kwenh arrantherrenh arrtjelh-ilem. Kwer imampwerl angerr anetjenh. Kwer mwerr-lkwer anem, arrpenhel renh kwatj alay-warn wemer, rang ilwetjeh, Altjerr kwer ahang-irrehetjeng. ");
INSERT INTO amx_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Mantjel arelhang, arrantherr arrpenh map arrtjelh-ilehetj, inang anetj mpwaretjeh. “Peltj nakenh-nakenhel apek anetj mpwarekarl. Ntwang renh ampakemel iletjeh, rang itja lakenh anetj mpwaretjeh. Rarrp apek ngkweng nyerr-irremel ilelhem, ‘Thang anetj mpwarekarl. Thang itja weth anetj mpwarem.’ Ntwang kel anetj kwerenh wetjeh. ");
INSERT INTO amx_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Rang apek arltang nyentel map-ingar anetj mpwarekarl. Arrantherr lakenh-arteh mernelhetjeh. Rang apek weth petj-alpemel ilelhem, ‘Yeng ngkwengeng nyerr-irrem, thang weth anetj mpwarekarl.’ Ntwang angketjeh kwer lakenh, ‘Yeng itja weth ngkweng arnkely anetjenh. Yeng mwerr ngkwengel-ayeng anetjenh.’ Lakenh ntwang kwer kangkentj mernelhetjeh. Rang map-ingar lakenh mpwarem apek arltang nyentel. Arrantherr kel lakenh-arteh wetham-weth angketjeh.” ");
INSERT INTO amx_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Kwertengerl mapel Ngkart renh pawenhek, “Ngkartay, nwernenh twer-ilang, nwern ngwenh kwet naketjeh!” ");
INSERT INTO amx_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jesu-el inenh ilek, “Arrantherr apek yengenh kwek war nakemeng, arrantherr arnang arrkernk yanh renh twernem, ‘Arnangay! Keth nhenheng anam-irretjeh, ntwang kwatj alay mpwepel ngkernelhetjeh.’ Kwereng arnang rang kel arrehantherr kangkwerrem, arrkernk rang kel alay mpwep-warn anam-irretjenh.” ");
INSERT INTO amx_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","8","Jesu-el angketj rrkwapenh-apenh nyent-akert ilek, “Artwang rrkwapenh-apenh apek farm-el rrkwapem twernk nyenteh. Rang arltang ntjaper rrkwaperl-anek, ipert angernekarl apek, yep-yep arntarnt-arekarl apek. Kwereng rang warl-warn petj-alpem twernk kwerenh-henh mer-warn. Twernk key angkem rrkwapenh-apenh kwer, ‘Petjay, arrernelhetjeh, mern arlkwetjeh-anngernt!’? Itja, twernk rang itja lakenh angketjenh. Lakenhant war anem. Rang renh ilemant, ‘Mern tjeng-amparr angetjang! Kwereng thang kel mern arlkwekarleng, tea antjwekarleng, ntwemeh ker-arlk arlkwetjenheng, tea-arlk antjwetjenheng.’ ");
INSERT INTO amx_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Twernk nhenhel itja rrkwapenh-apenh kwerenh nakek, rang irlpareth kwer rrkwapekarl-penh. Nhenh-artek rrkwapentj kwerenh war anek. ");
INSERT INTO amx_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Iterray, arrantherr apek Altjerrek rrkwapekarleng, arrantherr rrkwapentj angerr mpwarekarl, arrantherr itja nakelhetjeh. Arrantherr lakenh iterretjeh, ‘Yeng anetj-anetj war anem! Yeng kel Altjerrekant kangkwerretjeh war, rrkwapentj kwerenh mpwaremel!’ ” ");
INSERT INTO amx_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jesu rang Jerusalem-warn mpank alhetjam, rang mer Samaria mer Galilee thweneng mpwep-angkwerr alherl-apetjam. ");
INSERT INTO amx_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Rang mer kwek nyent-warn itwek-irrek. Artwang 10 pel leprosy tjwen-akert kwer-warn arnek-irrek. Inang ntwarr kwet irnetj-alhek. ");
INSERT INTO amx_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Inang renh ntwarreng-antey arlkemel pawenhek, “Twernk Jesu-ay, nwerneh lharrp-irrang!” ");
INSERT INTO amx_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesu-el inenh aremel ilek, “Alherrerrang artwang priest-warn, arrantherr ilelhetjeh.” Artwang irlkert-akert inang artwang priest-warn alherl-apetjam-rlwer, inang mwerremeh-irrenhek. ");
INSERT INTO amx_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Artwang nyent arelhek, tjwen kwerenh ywerrekarl. Rang angkep twep-irremel petj-alpek Jesu-warn, rang arlkemel Altjerr nakek. ");
INSERT INTO amx_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Rang amperel-ayeng arrernelhek, Jesu kwer kangkemel angkek. Artwang nhenh rang Samaria-arenyarl anek. ");
INSERT INTO amx_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesu angkek, “Thang nheng artwang 10 kwenh mwerr-ilek. Artwang arrpenh map-arteh? ");
INSERT INTO amx_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kel artwang nhenh nyentant angkep twep-irremel petj-alpek, Altjerr naketjehan? Rartek tjerrtj Samaria-arenyarl lwereny! Arrpenh map-arteh?” ");
INSERT INTO amx_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Jesu-el artwang renh ilek, “Kemerremel kel alpay! Ntwang kwenh yengenh kweteth naketj-alhekarleng, lakenheng thang ngwenh mwerr-ilekarl.” ");
INSERT INTO amx_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Artwang Pharisee rrpwetjel Jesu pawenhek, “Nthenh-angkwerram Altjerr-henh mer rang anem?” Jesu-el inenh ilek, “Arrantherr ywarn anngel arem. ");
INSERT INTO amx_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Tjerrtj nyentel ywarn arrantherrenh ilem, ‘Arerrerray, nhenheyay, Altjerr-henh mer rang!’ Altjerr rang kel mer nhenh rlkwerrel kwerenh mapel-ayeng, inarl kweteth iterrerl-anem kwerant. Arrantherr anngel ywarn arem.” ");
INSERT INTO amx_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jesu-el kwertengerl kwerenh map ilek, “Kelant arrantherr ahentj-anetjenh, Tjerrtj-henh Ler renh aretjenh, petj-alperleh. Arrantherr renh itja aretjenh. ");
INSERT INTO amx_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Arrpenh mapel arrantherrenh rrtjwerremel iletjenh, ‘Aretjeh alhang, rartek kel town-el anem!’ Arrpenh mapel rrtjwerremel iletjenh, ‘Itja, rartek mer alenhel anem.’ Arrantherr inenh itja naketjeh, itja ineh kangkwerretjeh apek. ");
INSERT INTO amx_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Tjerrtj-henh Ler rang petj-alpemarleng, tjerrtj ingkerrekel aretjenh. Inang mer ingkerrekeng parrp aretjenh, tjerrtj ingkerrekel parrp lharrkentj arem-arteh. ");
INSERT INTO amx_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Arrwekel Tjerrtj-henh Ler kwer rwekenth-kenth angerr-amparr anetjenh. Inang renh parrk-parrk-iletjenh-arlk. Tjerrtj lyet anemarl map inang kwer ahentj-kweny irretjenh. ");
INSERT INTO amx_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Kelant Tjerrtj-henh Ler rang petj-alpetjeh irremeng, nhenh kel artwang Noah-ek arltang anekarl-arteh lakenh-arteh anetjenh, kwatj angerr petjetjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Tjerrtj inang Altjerreh iterretj-kweny anek. Inang ahelh-arenyehant war iterrerl-anek. Inang kwenpel mern-arlk arlkwerrerretjart, wine-arlk antjwerrerretjart, anew-arlk inerrerretjart, rtwaltjel marl kwerenh anew anthetjart lakenh. Artwang Noah-el boat angerretj mpwaretjam, boat kwer-warn irrpetjeh-anngernt. Kwer-penh kwatj angerr petjek alkereng, ahelh kweneng arratekarl thwen, kwatj rew mpwarek, tjerrtj inenh ywerrelh-ilemel atwek. ");
INSERT INTO amx_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","“Artwang nheng Lot anekarl-arteh, lakenh-arteh anetjenh. Tjerrtj inang kwenpel arlkwerrerretjam, antjwerrerretjam thwen. Inang mantarr payem-iletjam, sell-em-iletjam-arlk. Inang mern anngang ahelh-arleh wetjam-arlk, warl-arlk artetjam. Inang pal anek, kwenp Altjerr iterretj-kweny anek. Inang wenh-wenh ahelh-arenyekant angerr nyerrketjam. ");
INSERT INTO amx_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lot rang wart mer Sodom-eng arratek-rlwer, anew kwerenh-akert marl awenk atherr-akert, Altjerrel rwang alkereng mer Sodom-warn kwatj-arteh thelek, tjerrtj ingkerrek ywerrelh-iletjeh. ");
INSERT INTO amx_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Lakenh-arteh anetjenh, Tjerrtj-henh Ler rang ahelh-warn petj-alpemeng-rlwer, tjerrtj ingkerrekeh mernelhetjeh-anngernt. Tjerrtj map pal anerl-anetjenh, Altjerreh-arlk iterrerl-anetj-kwenh alarterl-anetjenh. Tjerrtj ngkweyeny-arteh inang mern-arlk arlkwerl-anetjenh, wine-arlk antjwerl-anetjenh thwen, mantarr-arlk sell-em-ilerl-anetjenh payem-ilerl-anetjenh. Altjerr iterrerl-anetj-kwenyarl anetjenh. Lakenh-arteh inang ahelh-arenyekant athek-irrem. ");
INSERT INTO amx_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Arltang kwerel, tjerrtj rarl warl kernel anem apek, rang itja warl kwerenh-warn irrpetjeh, rnwanentj inetjeh. Tjerrtj arrpenh apek kethel anem, rang itja warl kwerenh-warn alpetjeh, rnwanentj inetjeh. Tjerrtj inang parrp arrtjanetjeh, itja wenh-wenh inehenheh iterretjeh. ");
INSERT INTO amx_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Angketj Lot-kenh anew-akertek irlpangkay.” ");
INSERT INTO amx_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Jesu-el ilek, “Tjerrtj ngwenh apek inarl athek-irrem iteth anetjehant, inang itja Altjerrek iterrem, wenh-wenh ahelh-arenyekant iterrem, anetj kwenh lakenh! Inang itja Altjerrel-ayeng kwet anetjenh. Tjerrtj arrpenh inarl alker-areny-arlkeh iterrerl-anem, kweteth arratj mernelhemel Altjerreng ularr, inang kel iteth ngampekarl anetjenharl. ");
INSERT INTO amx_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Kweny kwerel Tjerrtj-henh Ler petj-alpetjenh, tjerrtj atherr apek antjam nyentel ankwang interl-anerrem. Angelel nyent angetjenh, arrpenh rang imperl-alhetjenh. ");
INSERT INTO amx_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Marl atherrel arnwetj atherl-anerremeng, angelel nyent angetjenh, arrpenh rang imperl-alhetjenh. Lakenh-arteh anetjenh!” ");
INSERT INTO amx_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jesu-henh kwertengerl mapel renh pawenhek, “Ngkartay, nthenhay?” Rang inenh ilek, “Mer nthenhel irrernng rang intem, kwerel irretj inang arraw-irrem, ker tjelk arlkwetjeh.” ");
INSERT INTO amx_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesu-el kwertengerl kwerenh map ilek, “Altjerr-warn kweteth angkerrerrang, renh pawenhemel. Itja parrk-irremel impetjeh. Angketj nhenh awerrerrang. ");
INSERT INTO amx_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Mer nyentel artwang judge anek. Rang itja Altjerreng ater-irrek, itja kangkentj mernelhek tjerrtj arrpenheh apek. ");
INSERT INTO amx_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mer nhenh kwerel marl inpert anek. Marl inpert rang artwang judge renh kweteth pawenhetjart, ‘Artwang angerray! Tjerrtj arrpenhel yengenh nakepakel-ilem, pelkel war! Renh twernay, maney tjengenh rnwanentj-arlk angkep anthetj-alpetjeh!’ Lakenh inpert kwer nketjart. ");
INSERT INTO amx_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Judge rang itja kwet kangkwerrek. Kel arrpenhelemeh rang lakenh iterrek, ‘Arratjam, yeng itja Altjerreng ater-irrem, itja kangkentj mernelhem tjerrtj arrpenheh apek. ");
INSERT INTO amx_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Marl inpert nhenhel yengenh parrk-parrk anthem, kel thang renh arntarnt-aretjenhemeh, rang yengenh ahert-ilehetjeng! Thang artwang renh iletjenh, inpert renh impetjeh, itja renh nakepakel-iletjeh. Lakenh thang mpwaretjenh.’ ” ");
INSERT INTO amx_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ngkartel inenh ilek, “Artwang judge kwer iterrewarrang. Arrantherr angketj kwerenh awerrerrang. ");
INSERT INTO amx_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Judge-el arleng-alentj marl inpert mentjel awetjart. Arrwekel rang itja kwer kangkwerrek. Ingkernemeh rang iterrek, kwer kangkwerretjehemeh. Altjerr lakenh-kwenyarl anem! Rang arratj awenh-awenh anem, kwerenh map kwer-warn angkerleh. Inang kweteth kwer arnemel angkem, rang ineh kangkwerrem. ");
INSERT INTO amx_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Rarrp parrp kangkwerrerl-anem. Angketj nhenheh irlpangkewarrang! Tjerrtj-henh Ler rang petj-alpemeng, rang tjerrtj map inenh apek aretj-alhetjenh, renh nakerleh kwey? Rrpwetjel apek nakerleh.” ");
INSERT INTO amx_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesu kaltj anek tjerrtj arrpenh mapeh, inang nakelhemeng, inang kwel Altjerreng ularr arratj anemeng. Inang tjerrtj arrpenh mapeh tjweker-irrek. Rang tjerrtj inenh angketj nhenh ilek. ");
INSERT INTO amx_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Artwang atherr church angerr-warn alherrek, Altjerr-warn angketjeh-anngernt. Artwang nyent Pharisee anek, artwang arrpenh tax maney kwetjenh-tjenh anek. ");
INSERT INTO amx_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Artwang Pharisee rarrp arrwekel irnetj-alhek. Rang kwerarrp lakenh angkek, ‘Altjerray! Yeng kangkentj ngkweng anem, yeng artwang arratj anemeng! Yeng itja tjerrtj arrpenh map-arteh anem, yeng itja arwengkalth apek, itja anetj mpwarenh-arenh apek. Yeng kangkentj ngkweng anem, yeng itja tax maney kwetjenh-tjenh ingkern nhenh-arteh anemeng. ");
INSERT INTO amx_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Week nyent arltang atherrel yeng arltang ntjaper mern-kweny anem, ngwenh nakemel. Rnwanentj tjengenh ingkerrek thang ngwenh kert arrpenh arratj kwet antherl-anem, Moses-kenh mpwareng-areng-angkwerr.’ ");
INSERT INTO amx_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Artwang tax maney kwetjenh-tjenh rang ngkernelarl irnek, rang nyerr-irrek alker-warn-atheh aretjeh. Rang anarnk atwelhemel angkek, ‘Altjerray, yeng tjerrtj anetj anem! Tjeng mantj-mantj mernelhang.’ ” ");
INSERT INTO amx_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jesu-el inenh ilek, “Artwang tax maney kwetjenh-tjenh rang Altjerreng ularr arratj-irremel alpek, rang ilelhekarleng wart. Artwang Pharisee rang iltjelay-irremel alpek, Altjerrel renh itja arratj-ilek, rang nakelhekarleng wart. Tjerrtj ngwenh apek rarl Altjerreng ularr nakelhem, rang iltjelay-irretjenh. Kenh tjerrtj rarl Altjerreng ularr keweny mernelhem, renh Altjerrel tjwenetjenh.” ");
INSERT INTO amx_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tjerrtj mapel kwer kwek inehenh Jesu-warn angetjewarrek, Jesu-el iltjang kwerenh kapert inehenheh arrernetjeh-anngernt, Altjerr tjang-pawenhetjeh ineh. Jesu-henh kwertengerl mapel tjerrtj inenh lthwelth-ilek, kwer inehenh Jesu-warn angetjehetjeng. ");
INSERT INTO amx_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jesu-el kwer inenh aremel ntangkelhek. Rang kwertengerl inenh ilek, “Kwer map ayaketjal imperrerrang. Yeng ahentj-anem, kwer map tjeng-warn petjetjeh. Ngwenh apek rang kwer kwek nhenh map-arteh anem, inang Ngkart kwerenh anem. ");
INSERT INTO amx_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Mantjel awang! Arrantherr apek Ngkart alhengk-aretj-kweny anem, kwer nhenh mapelarl alhengk-arem-arteh, arrantherr kel Ngkart kwereng ntjwem-irrem, arrantherr itja kwet kwerenh anetjenheng.” ");
INSERT INTO amx_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Kwer-penh twernk church-areny nyentel Jesu renh pawenhek, “Ntwang kwenh kaltj-anthenh-anthenh mwerr! Ntwang yengenh ilay. Nthakenham yeng irrey, yeng Altjerr-henh merel iteth kwet anetjenheng?” ");
INSERT INTO amx_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesu-el renh ilek, “Wenheng ntwang yengenh mwerr akem? Altjerr rant kwenh mwerr anem. ");
INSERT INTO amx_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ntwang kel Altjerr-henh angketjeh kaltj. ‘Ntwang itja tjerrtj arrpenh-henh marlel-ayeng intetjeh.’, ‘Ntwang itja tjerrtj arrpenh irrernng atwetjeh.’, ‘Ntwang itja tjerrtj arrpenh-henh rnwanentj rwengkel inetjeh.’, ‘Ntwang itja rrtjwerremel tjerrtj arrpenh-akert ilerl-apetjeh.’, ‘Ntwang angey mwek ngkwengenheh kangkwerretjeh.’ ” ");
INSERT INTO amx_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Twernk rang Jesu renh ilek, “Yeng angketj nhenh ingkerrekeh kangkwerrek kwer kwekeng-ntjel.” ");
INSERT INTO amx_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesu-el renh awek. Rang renh ilek, “Kel mwerr. Angketj nyentant intem ngkweng. Rnwanentj maney ingkerrek ngkwengenh anthetjeh tjerrtj rnwanentj-kweny maney-kweny mapeh lharrp-irremel. Kwereng ntwang tjengel-ayeng petjay! Altjerrel ngwenh kwart-wetjenh, ngkweng rnwanentj-arlk angerr mer alkerel intetjenh.” ");
INSERT INTO amx_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Artwang rang angerr ltarrp-irrek, iterrentj atherram-akert, rang maney angerr-akert anekarleng wart. Rang ahentj-anek, maney kwerarrp anyenetjeharl. ");
INSERT INTO amx_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesu-el renh aremel ilek, “Tjerrtj maney angerr-akerteh kwenh nakepakel angerr anem, Altjerr-henh mer-warn irrpetjeh. Inang apek kweteth maney inehenhehant iterrerl-anem. Inang Altjerreh kwek war apek iterrerl-anem. ");
INSERT INTO amx_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Iterl-aray, kamwerl kwenh angerretj anem, needle-henh altjwer kwek-angkwerr irrpenhetjeh, arrew pwarn anemeng wart. Nthakenh kamwerl rang irrpetjenh? Lakenh-arteh anetjenh tjerrtj maney angerr-akert mapeh. Nthakenh inang Altjerr-henh mer-warn irrpetjenh?” ");
INSERT INTO amx_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Tjerrtj mapel angketj kwerenh awek, inang angerr anwerlkek. Inang renh pawenhek, “Tjerrtj ngwenham Altjerrel mer kwerenh-warn irrpelh-iletjenh, rang iteth ngampekarl kwerel-ayeng anetjenheng? Itja apek?” ");
INSERT INTO amx_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesu-el inenh ilek, “Tjerrtj ywarn irrpem Altjerr-henh mer-warn! Altjerrelant war inenh irrpelh-iletjenh, inang iteth kwet kwerel-ayeng anetjenheng.” ");
INSERT INTO amx_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Peter-el Jesu renh pawenhek, “Nwern-arteh? Altjerrel nwernenh mer kwerenh-warn irrpelh-iletjenh apekam? Nwern kwenh mer-arlk peltj map-arlk imperl-alhek, ngkwengel-ayeng alhetjeh-anngerntel.” ");
INSERT INTO amx_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesu-el renh ilek, “Arratj anthwerr, tjerrtj inarl mer inehenh anew inehenh apek imperl-alhem kakey apek angkwerek apek tjeyekw apek mwek angey thwen kwer apek peltj apek, Altjerr kwer rrkwapetjeh, tjerrtj inenh twepelh-ilemel, ");
INSERT INTO amx_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","inenh Altjerrel angerr anthwerr kwart-wetjenh, inang ahelh nhenhel-antey anemarleng. Kelant Altjerr-henh merel inang iteth kwetant anetjenh.” ");
INSERT INTO amx_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesu-el kwertengerl 12 inenh ntangkemel ilek, “Nwern kwenh Jerusalem-warn alhem. Jerusalem kwerel Tjerrtj-henh Ler rang rwekenth-kenth-irretjenh, Altjerr-henh angketj angenh-angenh ngkweyeny mapel pip-warn arrernekarl-arteh. ");
INSERT INTO amx_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Tjerrtj map inang renh tjerrtj lwereny mapeh anthetjenh. Tjerrtj lwereny inang renh arrampewetjenh, kwer pelh-wemel, nyerrel anthemel. Inang renh whip-el atwetjenh, kwereng inang renh irrernng atwetjenh. ");
INSERT INTO amx_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Kweny atherr-penh irrernng intemarl-penh, rang weth iteth kemerretjenh.” Lakenh Jesu-el inenh ilek. ");
INSERT INTO amx_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kwertengerl inang angketj nhenh itja alhengk-arek, Altjerrel iterleng-iterl inehenh martekarleng wart. ");
INSERT INTO amx_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Kwer-penh Jesu kwertengerl kwerenh map-akert Jericho town-eh itwek-irrek. Artwang pweng nyent tjeyeng iterel anerl-anek. Rang merneh ankey nketjam. ");
INSERT INTO amx_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Artwang pweng rang awetjam, tjerrtj map anper alherleh. Rang tjerrtj inenh pawenhek, “Yemay, wenh-apertay?” ");
INSERT INTO amx_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Inang renh tjernemel ilek, “Jesu mer Nazareth-areny rang kwenh anper alhem.” ");
INSERT INTO amx_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Artwang rang renh arlkemel pawenhek, “Jesu-ay! David-henh peltjay! Tjeng lharrp-irrang!” ");
INSERT INTO amx_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Tjerrtj inang renh ilek, “Intert-irray! Arlketjal anay!” Rang ineh itja kangkwerrek. Rang arnterr kwet arlkemel pawenhek, “Jesu-ay! David-henh peltjay! Tjeng lharrp-irrang!” ");
INSERT INTO amx_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesu-el irnetj-alhemel inenh ilek, artwang pweng renh kwer-warn angetjetjeh. Artwang rang kel Jesu-warn itwek-irretj-alhek. Jesu-el renh pawenhek, ");
INSERT INTO amx_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Wenh kweram ntwang tjeng arlketjam?” Artwang pweng rang angkek, “Ngkartay! Anngang tjeyenh aretjeh mpwarang!” ");
INSERT INTO amx_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesu-el renh ilek, “Anngang altjwer-ilang, ntwang aretjeh! Ntwang iterl-arek, thang ngwenh mwerr-iletjeh, lakenheng lyet ntwang mwerr arem!” ");
INSERT INTO amx_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Artwang rang kel mwerremeh arek. Rang Jesu-eng anharrel-ayeng alhek, Altjerr nakemel. Tjerrtj inarl lakenh arekarl-penh, inang Altjerr renh nakekemeh. ");
INSERT INTO amx_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jesu mer Jerusalem-warn-athek kwet alhetjam. Rang alhemel mer arreny Jericho kwerel anper-irrenhek. ");
INSERT INTO amx_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Mer kwerel artwang nyent anek, arreny kwerenh Zacchaeus. Rang artwang tax maney kwetjenh-tjenh mapeh twernk angerr anek. Zacchaeus rang artwang maney angerr-akert anek. ");
INSERT INTO amx_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Rang ahentj-anek, Jesu renh aretjeh, anper alherleh. Rang artwang karteng wart anek. Tjerrtj aningkel tjey kwer arrngertewarretjam, rang Jesu renh ywarn arek. ");
INSERT INTO amx_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Lakenheng rang arrwekel arrtjanek arneh-warn antjetjeh, arnang rartek tjey kwer iterel anekarl. Rang kel arnang kwer-warn antjek. Rang arnang kwerel mpwelhetjam, Ngkart Jesu mpank kwet petjetjamarl-rlwer. ");
INSERT INTO amx_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Jesu rang arnang kwer-warn-atheh petjetjam, angathemeh. Rang Zacchaeus renh arek, Zacchaeus rang kern anetjamarl. Rang renh ilek, “Zacchaeus-ay! Parrp anarnpay! Lyet yeng ngkwengel-ayel yatjarr anerl-alhetjenh.” ");
INSERT INTO amx_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zacchaeus rang parrp anarnpek, Jesu kwer angerr kangkemel. Rang renh warl kwerenh-warn angek. ");
INSERT INTO amx_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tjerrtj mapel renh-atherrenh arnterr arek, inang ingkerrek kwer ahentj-kweny awelhek, Jesu rang tjerrtj anetjel-ayeng angkerleh. Inang Jesu kwer tjel-angkerrek, “Rartek alhetjeh artwang anetjel-ayeng, yatjarr anerl-alhetjeh.” ");
INSERT INTO amx_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kwereng inang mern arlkwetjamarleng, Zacchaeus rang kemerremel angkek, “Ngkartay! Yeng ahentj-anem, rnwanentj tjengenh arrpenh map ngakemel anthetjeh tjerrtj rnwanentj-kweny maney-kweny mapeh. Arrpenh map thang apek ineheng rwengkel inekarl, thang renh kel maney angerr-lkwer angkep anthetj-alpetjenharl.” ");
INSERT INTO amx_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jesu-el Zacchaeus renh ilek, “Lyet Altjerrel ngwenh ngwekarl, ntwang peltj kwerenhemeh anetjenheng, peltj arlaltj ngkwengenh map-arlk thwen. Ntwang kwenh arrwekeleny Abraham-kenh peltj anem, ntwang yengenh nakekarleng, Abraham-el Altjerr renh nakekarl-arteh. ");
INSERT INTO amx_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Tjerrtj-henh Ler rang kwenh petjek, tjerrtj anetj mapeh palenthwetjeh, inenh twepelh-ilemel angkep angetj-alpetjeh Altjerr-warn.” ");
INSERT INTO amx_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jesu rang Jerusalem-eng rtwang war anek. Tjerrtj mapel renh awek. Inang iterrek, Altjerr rang Jesu renh twernk angerr ngkernetjenh kwel tjerrtj mapeng ularr. Lakenh-hetj Jesu-el inenh angketj nhenhemeh ilek, ");
INSERT INTO amx_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","13","“Angketj nhenh awerrerrang. Artwang angerr nyent angkek, rang mer arrpenh-warn ntwarr alhetjenharl, inang renh ngkernetjeh-anngernt, king anetjeh mer kwerenhel kwel. Mpank alhetjeh-anngerntel rang rrkwapenh-apenh 10 kwerenh ngwek, ineh ngkweltj gold 10 pel anthek nyentam-nyenteh. Rang inenh ilek, ‘Maney tjengenh angerr-ilerrerrang, yeng petj-alpetjeh-atwetj, thang inenh inetj-alpetjeh-anngernt.’ Kel rang alhek mer ntwarr kwer-warn. ");
INSERT INTO amx_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Mer-areny map artwang kwer ahentj-kweny anek. Inang twernk angerr arrpenh kwer-warn urrpey lanthek, renh lakenh iletjeh, ‘Nwern itja ahentj-anem, artwang nhenh king nwerneh anetjeh. Ntwang itja renh ngkernetjeh!’ ");
INSERT INTO amx_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Tjerrtj ntwarr-areny map itja ineh kangkwerrek. Inang artwang renh king ngkernek. Kwereng artwang rang mer kwerenh-warn petj-alpek. Rrkwapenh-apenh nheng map rang arrawelh-iletj-alpek. Rang inenh pawenhek, ‘Arrantherr maney tjengenh angerr-ilek key?’ ");
INSERT INTO amx_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Rrkwapenh-apenh nyentel renh ilek, ‘Twernkay, thang maney ngkwengenh angerr-ilek. Ntwang tjeng ngkweltj 10 antherl-alhek, thang 10 arrpenhemeh ngkweng angerr-ilek. Ma, nhenh kel ngkweng 20 intem.’ ");
INSERT INTO amx_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Artwang rang renh ilek, ‘Ntwang kwenh rrkwapenh-apenh mwerr! Ntwang maney kwek arratj arntarnt-arekarleng, thang ngwenh ngkernetjenh 10 town-eh twernk anetjeh.’ ");
INSERT INTO amx_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Rrkwapenh-apenh arrpenhelemeh renh ilek, ‘Twernkay, thang maney ngkwengenh angerr-ilek. Ntwang tjeng ngkweltj 10 antherl-alhek, thang 5 arrpenhemeh ngkweng weth angerr-ilek. Ma, nhenh kel ngkweng ngkweltj 15 intem.’ ");
INSERT INTO amx_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Artwang rang renh ilek, ‘Thang ngwenh ngkernetjenh, 5 town-eh twernk anetjeh.’ ");
INSERT INTO amx_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Rrkwapenh-apenh arrpenhel renh iletj-alhek, ‘Twernkay, ngkweltj 10 rang nhenhel anem. Thang maney mantarrel arltwemel alengk-wek. ");
INSERT INTO amx_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ntwang twernk angerretj anemeng wart, yeng-artek ngkwengeng ater-irrek. Ntwang arrpenh map twernem, “Tjeng rrkwapetjeh! Yengenh anthetjeh!” Ntwang mern anngang itja ngkernek, ntwang mern arrpenh kwetjem, ntwang mern ineh itja rrkwapekarleng wart. Lakenheng thang maney nhenh mantarrel arltwemel alengk-wek.’ ");
INSERT INTO amx_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Artwang rang kwer ahang-irremel angkek, ‘Ntwang arratj angkek, yeng twernk angerretj anemeng wart. Thang arrpenh map twernem, tjeng anthetjeh. Thang mern arrpenh kwetjem, yeng mern ineh itja rrkwapekarleng. Ntwang rrkwapenh-apenh anetj! Lyet thang ngwenh atwetjeh angketj ngkwengenheng arrngel. ");
INSERT INTO amx_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ntwartek maney tjengenh bank-warn arrernemer. Ntwang apek lakenh arrernekarleng, thang maney angerr-lkwer petj-alpemel inemer!’ ");
INSERT INTO amx_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Rrkwapenh-apenh arrpenh inang irnetjam. Artwang rang inenh ilek, ‘Artwang kwereng ngkweltj 10 nheng inerrerray! Arrantherr inenh artwang renh anthang, rarl ngkweltj 10 arrpenh angerr-ilekarl.’ ");
INSERT INTO amx_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Rrkwapenh-apenh inang twernk renh ilek, ‘Twernkay, kel rang anyenem ngkweltj 10! Ntwang maney arrpenhek anthemer!’ ");
INSERT INTO amx_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Artwang rang inenh ilek, ‘Tjerrtj arrpenh thang rnwanentj map anthem arntarnt-aretjeh. Rang apek rnwanentj arratj arntarnt-aremeng, thang rnwanentj map renh weth anthetjenh. Tjerrtj arrpenh thang rnwanentj kwek-lkwer anthem arntarnt-aretjeh, rang apek kwek nhenh itja arratj arntarnt-aremeng, thang rnwanentj kwek nhenh kwereng weth angkep raketjenh. ");
INSERT INTO amx_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kelemeh arrantherr tjerrtj nheng map tjeng-warn ngwerl-atherr alpay, inarl itja ahentj-anekarl, yeng king ineh anetjeh. Kwereng arrantherr inenh tjengeng anngetherr irrernng atwerrerrang.’ ” Lakenh Jesu-el angketj ineh ilek. ");
INSERT INTO amx_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Kwereng Jesu rang Jerusalem-warn-athek alhek. Tjerrtj aningk ingkernemeh alherrerrek. ");
INSERT INTO amx_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Jerusalem-eng mer kwek atherr mpwepel anek, mer Bethphage mer Bethany thwen, Olive pwert iterel. Kel Jesu rang mer kwer-atherr-warn itwek-irrekemeh, rang kwertengerl atherr lanthek arrwekel, ");
INSERT INTO amx_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","renh-atherrenh ilemel, “Mer nhak-warn alherray! Mpwel tangkey kwek irnerleh aretj-alhetjenh, halter-akert arnangel-ayeng ayernekarl. Tangkey kwer tjerrtj itja arrwekel antjekarl apek. Mpwel rope renh rlwang, tangkey renh inemel angetj-alperrang. ");
INSERT INTO amx_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Tjerrtj arrpenhel mpwelenh apek pawenhemeng, ‘Wenheharl mpwel tangkey renh angem?’. Mpwel renh iletjeh, ‘Ngkart kwenh kwer ahentj-anem.’ ” ");
INSERT INTO amx_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Kwertengerl ratherr alherrek, ratherr tangkey renh aretj-alhek, Ngkartel renh-atherrenh ilekarl-arteh. ");
INSERT INTO amx_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ratherr rope renh rlwemarleng, tangkeyeh-artweyelemeh renh-atherrenh pawenhek, “Wenheham mpwel tangkey renh rlwemel angem?” ");
INSERT INTO amx_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ratherr renh ilek, “Ngkart kwenh kwer ahentj.” ");
INSERT INTO amx_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Kwertengerl ratherr tangkey kwek renh Jesu-warn angerl-anerrek. Kwereng ratherr mantarr tangkey kwer artep-warn arrernerl-anerrek. Ratherr Jesu renh tangkey kwer antjelh-ilek. ");
INSERT INTO amx_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jesu rang tangkeyel-ayeng mpank petjetjam, tjerrtj mapel mantarr inehenh tjeyeh antjam-wek kwereng arrwekel. ");
INSERT INTO amx_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Jesu kel Olive pwerteng anarnpetj-alhemeng, nakenh-nakenh kwerenh mapel arrkenel Altjerr nakewarrek. Inang arrwekel arekarl-penh, Jesu rang twer anthwerrel mpwarekarl-penh. ");
INSERT INTO amx_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Tjerrtj inang arnterr arlkerrerretjam, “Altjerray, king nwern-henh twer-ilang! King rang lyet nwerneh-warn petjem arreny Ngkartel-ayel. Altjerr rang nwerneh ngwerleny mernelhem. Alker-areny mapel thwen renh nakem, inang arrken anemeng wart!” ");
INSERT INTO amx_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Artwang Pharisee rrpwetj inehel-ayeng irnek. Inang Jesu renh ilek, “Kaltj-anthenh-anthenhay, nakenh-nakenh ngkwengenh map intertelh-ilang!” ");
INSERT INTO amx_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jesu-el inenh ilek, “Inang apek intert anemeng, irntang kwek nhenh map inang nakemel arlketjenh!” ");
INSERT INTO amx_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jesu kel town Jerusalem-warnemeh itwek-irrekarleng, rang town renh kert-arek, rang town-areny mapeh arnek. ");
INSERT INTO amx_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Rang angkek, “Tjerrtj Jerusalem-areny mapay! Arrantherr pal anem, angketj Altjerr-henh iterl-aretj-kwenyemeh anem. Yeng ahentj-anek, arrantherrenh angkep twepelh-iletjeh Altjerr-warn. Arrantherr itja kangkwerrek tjeng. Lakenh arrantherr kaltj-kwenh anem, nthakenh arrantherr tjerrtj arrpenh mapeng ularr ngwerleny anetjenh. ");
INSERT INTO amx_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Keweny mapay! Kelant tjerrtj atwenh-atwenh map petjetjenh. Inang mer Jerusalem renh arrngert-wetjenh, tjerrtj ywarn irrpetjetjenh, ywarn arratetjenh apek. ");
INSERT INTO amx_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Inang arrantherrenh, kwer arrehantherr-henh thwen irrernng atwetjenh. Inang warl arrehantherr-henh ltwaketjenh. Nhenh lakenh irretjenh, arrantherr itja Altjerr alhengk-arekarleng, rang arrehantherr-warn yatjarr petjekarl.” Lakenh Jesu-el ltarrp-irremel ilek angketj Jerusalem-areny map-akert. ");
INSERT INTO amx_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Kwer-penh Jesu rang Altjerr-henh church angerretj-warn irrpenhek. Church kwerel artwang mapel mer kel mpwarekarl, inarl thep ntwerrert arnang arrpenh map-arlk sell-em-iletjam. Jesu rang artwang inenh anpwek. ");
INSERT INTO amx_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Rang inenh ilek, “Angketj Altjerr-henh pipel-ayeng intem, ‘Mer tjengenh tjerrtj ingkerrekeh mek-mek anetjenh. Inang mer nhenh kwer-warn petjem, tjeng-warn nakemel angketjeh.’ Arrantherr mer nhenh anyenng-henh mer-arteh ulpert-ilemel mpwarekarl.” ");
INSERT INTO amx_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Jesu-el tjerrtj map arltang rrpwetj arrpenhel kaltj-anthek church angerretjel. Priest twernk mapel artwang kaltj-anthenh-anthenh mapel thwen Jesu renh awek, rang lakenh angkerleh. Inang ahentj-anek, renh irrernng atwetjeh. Lakenh inang mwekeny-irrek kwer, “Wenheharl tjerrtj nhenh mapel angketj kwerenh nakem? Nthakenhameh nwern Jesu renh irrernng atwetjenh? Tjerrtj map angketj kwerenheh kangkemeng wart!” ");
INSERT INTO amx_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Inang renh ywarn irrernng atwek, tjerrtj inang angketj kwerenheh kangkemeng anthwerr. ");
INSERT INTO amx_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Arltang arrpenhel Jesu Altjerr-henh church angerr iterel anetjam, tjerrtj mapeh Altjerr-henh angketj kaltj-anthetjam. Priest twernk map, Moses-henh mpwareng-areng kaltj-anthenh-anthenh map angerrepat twernk map thwen kwer-warn petjek. ");
INSERT INTO amx_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Inang renh pawenhek, “Ngwenhelam ngwenh lanthek, artwang maney-akert nheng map church nhenheng anpwetjeh? Church nhenhelan kaltj-anthetjeh? Ntwang nyentelek-ahepel mpwarek apek!” ");
INSERT INTO amx_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesu-el inenh ilek, “Thang arrantherrenh pawenhetjeh-amparr. ");
INSERT INTO amx_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Ngwenhelam John renh lanthek, tjerrtj map kwatjeh irrpelh-ilemel baptise-em-iletjeh? Altjerrel apek? Tjerrtjel apek? Arrantherr-amparr yengenh tjernang!” ");
INSERT INTO amx_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Inarrp angketj nhenh-penh akwen war angkerrek, “Nwern apek renh ilem, ‘Altjerrel John lanthekarl’, rang nwernenh iletjenh, ‘Wenhengarl arrantherr John renh itja nakek?’ ");
INSERT INTO amx_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Nwern apek renh ilem, ‘Tjerrtjel renh lanthekarl’, tjerrtj mapel nwernenh iltewehetjeng. Tjerrtj ingkerrek iterrem, John rang Altjerr-henh angketj angenh-angenh kwel anekarl.” ");
INSERT INTO amx_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Lakenheng inang Jesu ilek, “Nwern itja kaltj.” ");
INSERT INTO amx_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Jesu-el inenh ilek, “Lakenheng thang arrantherrenh itja ilem, ngwenhel yengenh lanthek.” ");
INSERT INTO amx_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jesu-el inenh angketj nhenh ilek, “Artwang nyentel mern grapes farm ngkernek mer kwerenheh. Kwereng rang grapes farm renh artwang arrpenh mapeh rent-em-ilerl-alhek. Farm-ek-artwey rang mer arrpenh-warn ntwarr alhek. ");
INSERT INTO amx_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Arrpenh-ingar mern grapes inang ampeng anek kwetjetjeh-anngernt, artwang farm-ek-artwey rang rrkwapenh-apenh nyent lanthek farm-warn, grapes mapeng kert arrpenh angetj-alpetjeh. Artwang inang rrkwapenh-apenh renh atwek. Inang renh iltjant angkep lanthek. ");
INSERT INTO amx_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Farm-ek-artwey rang rrkwapenh-apenh arrpenhemeh ineh-warn lanthek. Rrkwapenh-apenh nhenh renh inang arrampewemel atwek, renh iltjant angkep lanthek. ");
INSERT INTO amx_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Kwereng merek-artwey rang rrkwapenh-apenh arrpenhemeh lanthek. Nhenh renh inang atwek, renh anpwek. ");
INSERT INTO amx_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Farm-ek-artwey rang lakenh iterrek, ‘Nthakenhameh yeng irretjenh? Thang kel ler tjengenh ineh-warn lanthetjenh, ler nheng kwerarl yeng angerr nyerrkem. Inang kwerant apek kangkwerretjenh.’ ");
INSERT INTO amx_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Artwang inang ler renh arnekarner arek petjerleh. Lakenh inang angkerrek, ‘Nhenh kwenh ler kwerenh! Kelant grapes farm nhenh ler kwerenhehemeh anetjenh. Mpa, nwern renh irrernng atweyay! Grapes farm nhenh nwernehemeh anetjenheng!’ ");
INSERT INTO amx_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Inang ler renh antwerrkemel irrernng atwek, renh farm-eng keth-warn angemel taly-wek.” Jesu-el ilek, “Nthakenhameh arrantherr iterl-arem? Grapes farm-ek-artwey rang nthakenh irretjenh? ");
INSERT INTO amx_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Rang kwenh ineh ahang-irretjenh. Rang petjemel artwang inenh irrernng atwetjenh. Kwereng rang grapes farm renh arrpenh mapehemeh anthetjenh, inang kwer arntarnt-aretjeh.” Tjerrtj map angkek, “Itja lakenh!” ");
INSERT INTO amx_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesu-el inenh twant-aremel ilek, “Arrantherr kel Altjerr-henh angketj nhenheh kaltj. ‘Pwert nheng warl artenh mapel mentj taly-wekarl, rang lyet pwert tjeperr anthwerremeh intem, pwert mapel-ayeng mpwepel intem, pwert arrpenh map anyenemeng.’ ");
INSERT INTO amx_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Tjerrtj inarl pwert alenheng anyenhemeng, renh Altjerrel ngkweltj-iletjenh. Kenh tjerrtj kwer-arleharl pwert anyemeng, pwertel renh mweltj-iletjenh.” ");
INSERT INTO amx_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Moses-henh mpwareng-areng kaltj-anthenh-anthenh map priest twernk map thwen kaltj anek, Jesu rang angketj nhenh ineh-akert ilemeng. Inang ahentj-anek, renh antwerrketjeh. Inang tjerrtj mapeng ater-irrek, lakenheng inang renh itja antwerrkewarrek. ");
INSERT INTO amx_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Inang artwang rrpwetj Jesu-warn lanthek, renh mantjel arerl-anetjeh. Artwang nhenh inang tjerrtj mwerr-arteh mernelhek. Inang karelhetjam, Jesu pal angketjeh apek, inang renh twernk Rome-arenyeng ularr pawenhetjenheng. ");
INSERT INTO amx_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Inang kwer-warn petjemel renh pawenhek, “Kaltj-anthenh-anthenhay, nwern kaltj, ntwang arratj kaltj-anthem. Ntwang itja tjerrtjeng ater-irrem, lepwel kwet ntwang mernelhem tjerrtj ingkerrekeh. Ntwang tjerrtj map kaltj-anthem, inang Altjerreng ularr arratj mernelhetjeh. ");
INSERT INTO amx_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Nwernenh ilay, mpwareng-areng nwern-henheng ularr arratj apek key, nwern twernk Rome-areny angerr Caesar tax maney anthetjeh? Itja apek?” ");
INSERT INTO amx_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesu rang kaltj anek, inang renh arrkernemel war pawenhemeng. ");
INSERT INTO amx_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Rang inenh ilek, “Tjeng maney ngkweltj nyent anthay, thang aretjeh.” Inang kwer ngkweltj nyent anthek. Rang inenh pawenhek, “Ngwenh-henh inngerremeh nhenh anem?” ");
INSERT INTO amx_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Inang renh ilek, “Twernk angerr Caesar-henh.” Jesu-el inenh ilek, “Altjerrel arrantherrenh rnwanentj-arlk mern-arlk anthek, inenh arntarnt-aretjeh. Arrantherr Altjerreh kangkwerrang! Altjerrel arrantherrenh anthekarl-arteh, arrantherr Altjerr kwer tjenkerr angkep antherrerrang, rarl ilekarl-arteh. Wenh Caesar-henh anem, Caesar-eh angkep antherrerrang. Wenh Altjerr-henh anem, Altjerreh angkep antherrerrang.” ");
INSERT INTO amx_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Artwang inang itja kwet awek, Jesu tjerrtj mapeng anngetherr pal apek angkerleh. Inang angketj kwerenh awemel anwerlkek. Inang renh itja weth pawenhek. ");
INSERT INTO amx_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Artwang Sadducee rrpwetj inang petjek Jesu-warn. Sadducee inartek iletjart, tjerrtj inang kwel itja irrernngeng kemerretjenh. ");
INSERT INTO amx_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Inang Jesu renh pawenhek, “Kaltj-anthenh-anthenhay, Moses-henh mpwareng-arengel-ayeng angketj intem lakenh, ‘Artwang nyent apek kwer-kweny ilwem. Kwereng tjey kwerenhel inpert renh anew inetjeh. Nheng inpert kwer apek kwer ngwerrm-irrem, kwer rang artwang irrernng kwerenh kwet anem. Tjey rang kwer renh mangkelh-iletjeh kek kwer.’ Nhenh mpwareng-areng nwern-henh anem.” ");
INSERT INTO amx_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Inang Jesu kwer iterrentj inehenh-akertel ilek, “Arrpenh-ingar kenheng-nheng 7 anek, angerrepatelek-amparr anew inek. Rang kwer-kweny kwet ilwek. ");
INSERT INTO amx_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Lakenheng tjey arrpenhel inpert renh anew inek. Rang kwer-kweny ilwek. ");
INSERT INTO amx_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kwereng tjey arrpenhel inpert renh anew inek. Rang kwer-kweny kwet ilwek. Lakenh kenheng-nheng 7-el marl renh anew anyenek. Inang ingkerrek kwer-kweny kwet ilwek. ");
INSERT INTO amx_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ingkern marl inpert rang ilwek. ");
INSERT INTO amx_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kelant Altjerrel tjerrtj ingkerrek irrernngeng kwel kemelh-ilemeng, ngwenh-henh anewemeh marl rang anetjenh? Kenheng-nheng 7-el kwenh marl renh anew anyenekarl. Nthakenh ntwang iterrem, angketj nhenh-penh?” ");
INSERT INTO amx_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesu-el inenh ilek, “Lyet ahelh nhenhel artwel anew inem. Tjerrtj marl inehenh inang anew rtwaltjeh anthem. ");
INSERT INTO amx_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Kelant tjerrtj mwerr map inang Altjerr-henh mer kweteth kwerel anetjenh, inang itja weth anewart anetjenh, itja rtwaltjeh anthetjenh. ");
INSERT INTO amx_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Inang kel angel alker-areny map-arteh anetjenh. Inang itja weth ilwetjenh. Inang kemerrekarleng wart inang kel Altjerr-henh leremeh anetjenh. ");
INSERT INTO amx_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Arrantherr angketj arnang ampetjamarl-penh iterl-arem key? Moses-el mernek, Altjerrel kwenh tjerrtj irrernng map kemelh-iletjenh. Moses-el kwenh Ngkart renh anewek Abraham-henh Isaac-henh Jacob-henh Altjerr. ");
INSERT INTO amx_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Altjerr tjerrtj iteth mapehant Altjerr anem. Itja tjerrtj irrernng mapeh. Altjerreng ularr kwenh tjerrtj map kweteth iteth anem.” Lakenh Jesu-el inenh ilek. ");
INSERT INTO amx_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Artwang Moses-henh mpwareng-areng kaltj-anthenh-anthenh mapel nhenh awemel inang Jesu renh ilek, “Kaltj-anthenh-anthenhay! Ntwartek arratj ilek!” ");
INSERT INTO amx_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kwer-penh inang renh itja weth pawenhek. ");
INSERT INTO amx_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesu-el inenh pawenhek, “Artwang kaltj-anthenh-anthenh mapel lakenh ilem, ‘Altjerrel ngkwey ilekarl, Christ rang petjetjenh David-henh peltj ingkerneny mapeng nwerneh-warn.’ Tjeng ilay! Nthakenhameh Christ rang David-henh peltj anem? ");
INSERT INTO amx_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","King David ngkwey lakenh angkek pwek Psalms-el-ayeng, ‘Altjerrel Ngkart tjengenh ilek, “Tjengel-ayeng-amparr kwet anang. ");
INSERT INTO amx_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Tjerrtj anetj mapek-amparr thang atwemel ngkwengeng arratj-iletjenh, inang ngkweng kangkwerretjenheng.” ’ ");
INSERT INTO amx_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“David-el lakenh Christ renh Ngkart anewekarleng, nthakenhameh David-el Christ renh Ngkart anewek, Christ kwenh David-eng ingkern petjek?” ");
INSERT INTO amx_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Jesu-el kwertengerl kwerenh map ilek, tjerrtj mapeng anngetherr, ");
INSERT INTO amx_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Arrantherr-artek artwang Moses-henh mpwareng-areng kaltj-anthenh-anthenh mapeng arelhetjeh. Inartek kangkem, mantarr amparrkey-akert nthwerl-apetjeh. Inang ahentj-anem, tjerrtj mapel inenh kwel naketjeh, inang shop-warn alherleh. Lakenh-lkweran anetjam! Inang church-warn kwen irrpemarleng, inang ahentj-anem arrwekel anetjeh, tjerrtj mapel nakemel inenh aretjeh kwel. Lakenh-lkweran anetj! Arrpenh-ingar apek tjerrtj arrpenhel inenh tjenkerr arlkwetjeh ngwem, inang ahentj-anem twernk arrpenh mapeng pwert anetjeh, arrpenh mapel inenh naketjeh kwel. Lakenh-lkweran anetj! ");
INSERT INTO amx_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Inang kweteth ahentj-irretjam arlweker-areny map-hetj warl-arlk raketjeh, inpert inenh keth-warn anpwetjeh mereng. Lakenh-lkweran anetj! Inang Altjerr-warn kweteth tjarr arlpentj angketjart tjerrtj mapeng anngetherr. Lakenh inang tjwenelhem. Artwang kaltj-anthenh-anthenh nhenh mapel-artek anetj mpwarem. Altjerrel kwenh inenh angerr anthwerr atwetjenh.” Lakenh Jesu-el inenh ilek. ");
INSERT INTO amx_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesu rang arek, tjerrtj maney angerr-akert mapel tjenkerr maney arrernetjam tjenkerr-henh tjampet-warn. ");
INSERT INTO amx_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Kwereng rang arek, marl inpert nyentel ngkweltj kwek atherr arrernerleh. ");
INSERT INTO amx_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Rang kwertengerl kwerenh map ilek, “Arratj anthwerr, inpert nhenhel tjenkerr aningk-lkwer arrernek. Tjerrtj arrpenh mapel tjenkerr kwek wararl arrernek. ");
INSERT INTO amx_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Tjerrtj maney angerr-akert mapel tjenkerr anthekarl-penh, ineh kwenh maney angerr kwetarl intem. Maney inpert kwer itjarl intem, rang mern nyent payem-iletjeh apek. Inpert rang maney ingkerrekarl kwerenh arrernek.” ");
INSERT INTO amx_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Kwertengerl rrpwetj inang church angerretjeng arratemel angkerrek, “Aray, church renh pwert amparrkey-arrkey map-penh artekarl! Arnang mwerr anthwerr map-penh thwen, inang tjenkerr Ngkartek anthekarl!” Jesu-el inenh ilek, ");
INSERT INTO amx_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Arrantherr church nhenh arem? Tjerrtj anetj inang church nhenh ataketjenh. Ahelhelemeh pwert inang ingkerrek irrarnpelh-ilekarlemeh intetjenh.” ");
INSERT INTO amx_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Kwertengerl inang renh pawenhek, “Kaltj-anthenh-anthenhay, nwernenh ilang. Ilwengaram inang ataketjenh? Nthakenham nwern kaltj anetjeh, tjerrtj inang apek anyenng-anyenng petjetjenh, warl inenh ataketjeh-anngernt?” ");
INSERT INTO amx_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesu-el inenh ilek, “Arrantherr-artek arelhetjeh! Tjerrtj anetj arrpenh mapel arrantherrenh rrtjwerremel iletjenh. Tjerrtj anetj nyentam-nyent kwenh petjemel angketjenh, ‘Yeng anem Christ rang, yeng nhenh petj-alpek.’ Arrpenh angketjenh apek, ‘Arltang rang angathemeh anem, Jesu petj-alpetjeh!’ Arrantherr ineh itja kangkwerretjeh. ");
INSERT INTO amx_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kelant arrantherr awemarleng, tjerrtj arrpenh map atwerrerleh, tjerrtj arrpenh mapeh ngkwal atwerretjeh irrem, arrantherr itja ater-irretjeh. Nhenh kwenh lakenh anetjenh. Ahelh rang itjarl ywerretjenh, mpank-antey. ");
INSERT INTO amx_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","“Lakenh anetjenh. Mer-areny map mer ntwarr-areny arrpenh mapel-ayeng atwerretjenh. ");
INSERT INTO amx_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Keth arrpenhel ahelh rang arrewetjenh. Keth arrpenhel tjerrtj arrpenh map merneh angayel irremel ilwetjenh. Tjerrtj arrpenh map irlkert angerrel atwetjenh. Tjerrtj inang ater-irretjenh, inang aremarleng, Altjerrel kwerraly-arlk inenh angelh-angelh-ilerleh. ");
INSERT INTO amx_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Nhenh map lakenh mpank anetjenheng, inang kwenh arrantherrenh antwerrkemel court-warn angetjenh-anngernt, arrantherrenh church kwenel rwekenth-kenth-iletjenh-anngernt. Inang arrantherrenh twernk angerr mapeng ularr ngkernetjenh, arrantherr ilelhetjeh. Inang arrantherrenh tjayel-warn kwernetjenh-anngernt tjengeng arrngel. ");
INSERT INTO amx_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nhenh kel lakenh anetjenh, arrantherr ineheng ularr tjeng-penh iletjenheng. ");
INSERT INTO amx_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Inang apek arrantherrenh antwerrkemel court-warn angetjem, arrantherr apek iterrem, ‘Nthakenh yeng ilelhetjenh?’ Arrantherr itja angerr iterretjeh. ");
INSERT INTO amx_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Inang arrantherrenh pawenhemarleng, kel angketj nhengant angkay, tharl arrantherrenh iletjenharl, angketj arrantherrarl angketjenh. Inang angketj arrehantherr-henheh ywarnemeh iterrerl-anetjeh, ywarn angkep angketjeh arrehantherr-warn. ");
INSERT INTO amx_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Arrehantherrek-artwey mapel-arlk, tjey mapel-arlk, kek mapel-arlk, peltj arrpenh mapel-arlk arrantherrenh court-warn angetjenh, rrkwentjel arrantherrenh atwetjenh-anngernt. Arrehantherreng rrpwetj inang irrernng atwetjenh. ");
INSERT INTO amx_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Arrantherr yengenh nakemarleng, tjerrtj ingkerrek arrehantherr yerrng-irretjenh. ");
INSERT INTO amx_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Altjerrel wart arrantherrenh arntarnt-aretjenh, iteth anyenemel. ");
INSERT INTO amx_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Arrantherr twerel kwet apek yengenh nakemeng, arrantherr iteth ngampekarl kwet anetjenheng wart.” ");
INSERT INTO amx_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Jesu-el ilek, “Arrantherr aremarleng, tjerrtj atwenh-atwenh mapel antjwang mpwarekarl, Jerusalem-eng kethel alartemeng, tjerrtj mer-areny map arratehetjeng, arrpenh map irrpehetjeng, arrantherr kaltj anetjeh, atwenh-atwenh map inang Jerusalem renh kel atwetjeh irremeng. ");
INSERT INTO amx_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","22","Ngkwey Altjerr-henh angketj angenh-angenhel angketj nhenh pip-warn arrernek: kelant Altjerrel atwenh-atwenh lwereny map lanthetjenh, Judea-areny map atwerl-apetjenh. Kelant nhenh lakenh-arteh arratj irretjenh. Kwereng tjerrtj Judea-areny map kel parrp irntang-warnant anam-irretjeh. Tjerrtj inarl town arrpenhek-arrpenhel anemeng, inang kel anam-irretjehant. Tjerrtj inarl kethel anemeng, inang itja town-warn alhetjeh. ");
INSERT INTO amx_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Marl mapeh rwekenth-kenth anthwerr anetjenh, kwer kwek-akert mapeh-arlk, anert-anert mapeh-arlk thwen. Kel tjerrtj ingkerrekeh rwekenth-kenth angerr anetjenh. Altjerrel tjerrtj Judea-areny map atwetjenh. ");
INSERT INTO amx_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Atwenh-atwenh mapel inenh knife alkeyel irrernng atwetjenh. Inang inenh mer arrpenh-warn anamelh-iletjenh. Jerusalem kwerel tjerrtj lwereny mapel mer ntjaperel rrpwerrkerl-apetjenh, warl ingkerrek atakemel. Kwer-penhant atwenh-atwenh mapel Jerusalem imperl-alhetjenh.” ");
INSERT INTO amx_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","26","“Arltang kwerel aherrk, anyentj, kwerraly map-arlk inang arrpenh anthwerr irremel arrewetjenh. Kwatj alay rang angerr-irremel ywerr-angketjenh. Tjerrtj inang kwerrern-kweny irretjenh. ");
INSERT INTO amx_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Arltang kwerel tjerrtj ingkerrekel arnaretjenh, Tjerrtj-henh Ler rang ankertel petj-alperleh. Rang twer angerr-akert parrtj angerrel-ayeng anthwerr rang mernelhetjenh tjerrtj mapeh. Lakenh rang petj-alpetjenh. ");
INSERT INTO amx_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nhenh ingkerrek lakenh irremeng, arrantherr anew-anew arnekarner irremel irnetjeh. Yeng petjem, arrantherrenh inerl-alpetjeh mer anganentj tjengenh-warn.” ");
INSERT INTO amx_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesu-el inenh angketj ilek, “Arnang tjwerrk kwereng kaltj-irray! Arrantherr arnang tjwerrk arem, arnang arrpenh apek. ");
INSERT INTO amx_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Inang anteth-akert irrem apek, arrantherr kaltj anetjeh, ngwenth war twern-irretjenh. ");
INSERT INTO amx_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Lakenh-arteh arrantherr aremeng, angketj tjeyenh keth irremeng, arrantherr kaltj anetjeh, arltang rang itwekemeh irrentjem, yeng petj-alpemel anngetherr mernelhetjeh-anngernt, yeng Ngkart anemeng tjerrtj ingkerrekeh, tjengenh mapemeh thang arntarnt-aremel inerl-alpetjenh. ");
INSERT INTO amx_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Angketj tjeyenh kel ngwerrm-irretjenh, tjerrtj lyet nhenh anemarl rrpwetj iteth anemarleng-rlwer. ");
INSERT INTO amx_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Alker ahelh nhenh ywerretjenh. Angketj tjeyenh itja kwet ywerretjenh, anentjekarl kwet anetjenh.” ");
INSERT INTO amx_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Arrantherr arelhetjeh, arrantherr wenh-wenheh apek itja angerr iterretjeh, mern-penh-arlk ngkwarl-penh-arlk apek mantarr-penh-arlk itja angerr iterretjeh. Kwereng yeng petj-alpemarleng, thang arrantherrenh anwerlkelh-ilehetjeng. ");
INSERT INTO amx_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Tjerrtj ingkerrek anwerlketjenh yeng petj-alpemeng, inang arltang kwer kaltj-kwenheng wart. ");
INSERT INTO amx_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Arrantherr karr kwet anetjeh. Arrantherr Altjerr-warn kweteth angkerl-anetjeh. Renh pawenherrerrang, rang arrantherrenh arntarnt-aretjeh, arrantherr renh twerel kwet naketjeh. Tjerrtj-henh Ler rang petj-alpemeng, rang arrantherrenh aretj-alhehetjeng, arrantherr kwer itja karr anemeng.” Lakenh Jesu-el inenh kaltj-anthek. ");
INSERT INTO amx_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Arltang mapel Jesu-el tjerrtj map church angerretjel kaltj-anthetjart. Angwerr-angwerr rang Olive pwert-warnarl alpetjart, intetjeh. ");
INSERT INTO amx_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kwereng kweny-rtweh tjerrtj ingkerrek church angerretj-warn petjetjart, renh awetjeh. ");
INSERT INTO amx_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Tjerrtj inang kel mern tjenkerr rrkwapekarl, inang irlpangkentj arreny Mern Arlwar-ilenh-ilenh-kweny anyenetjeh-anngernt. Inang mern arlwar-ilenh-ilenh-kweny arlkwep-arlkwetjart. Irlpangkentj arreny arrpenh anek Anper Alhekarl. ");
INSERT INTO amx_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Priest twernk map Moses-henh mpwareng-areng kaltj-anthenh-anthenh map thwen ahentj-anek, Jesu renh antwerrkemel irrernng atwetjeh. Inang ater-irrek renh alngetherr antwerrketjeh, tjerrtj map kikart alhehetjeng. ");
INSERT INTO amx_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Arrentj Judas Iscariot-warn irrpek. Judas rartek kwertengerl Jesu-henh anekarl. ");
INSERT INTO amx_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Judas rang priest twernk map-warn alhek, rrkwentj map-warn thwen, inarl church angerretj arntarnt-aretjart-warn. Rang inenh ilek, rang ahentj-anemeng, Jesu renh ineh anthetjeh. ");
INSERT INTO amx_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Inang awemel arrken awelhek. Inang alhelek, Judas kwer maney anthetjeh. ");
INSERT INTO amx_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas kel nhenhekant angerr-lkwer iterrek, “Nthakenham thang Jesu renh anyenng-anyenngel ineh anthemer? Kel rrpwetj-rlwerant apek anthetjenheng?” ");
INSERT INTO amx_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Arltang angerr anek, irlpangkentj nheng kwer. Kel inang ker yep-yep kwek inenh atwetjeh anek, irlpangkentj tjenkerr arreny Anper Alhekarleh arlkwetjeh. ");
INSERT INTO amx_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesu-el Peter John renh-atherrenh ilek, “Kel alherray, tjenkerr renh nwerneh mpwaretjeh, nwern renh arlkwetjenheng.” ");
INSERT INTO amx_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ratherr renh pawenhek, “Nthenheham ntwang ahentj-anem, ilern tjenkerr renh mpwaretjeh?” ");
INSERT INTO amx_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesu-el renh-atherrenh ilek, “Mpwel town-warn irremeng, mpwel artwang nyent aretjenh, jar angerr kwatj-akert ntjwel angerl-aperleh. Kel mpwel ingkern-angkwerr alherrang warl kwerenh-warn. ");
INSERT INTO amx_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Kwereng mpwel warlek-artwey renh iletjeh, ‘Kaltj-anthenh-anthenhel ngwenh pawenhem, “Nthenham room rang, kwerel nwern tjenkerr renh arlkwetjeh?”’ ");
INSERT INTO amx_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Artwang rang mpwelenh room angerretj mernetjenh, warl kernel. Room yanh kwerel rang antjam kel wekarl. Kwer-warn irrpetjeh, room kwenel mpwel tjenkerr renh mpwarerl-anerrang.” ");
INSERT INTO amx_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Kel Peter John ratherr alherrek. Inang arek, ingkerrek anek, Jesu-elarl arrwekel ilekarl-artek. Ratherr tjenkerr renh mpwarek. ");
INSERT INTO amx_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Angwerr-angwerrel Jesu alhek mer kwer-warn, kwertengerl kwerenh map-akert. Inang ingkerreny arrernelhek, mern arlkwetjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Jesu-el inenh ilek, “Yeng angerr ahentj-anek, tjenkerr nhenh arrehantherrel-ayel arlkwetjeh, yeng rwekenth-kenth-warn irretjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Thang kwenh tjenkerr nhenh-lkwer itja weth arlkwetjenh. Kelant thang arlkwetjenh, nwern tjenkerr Anper Alhekarl arlkwemeng Altjerr-henh merel-ayel.” ");
INSERT INTO amx_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jesu-el tjampet wine-akert inek. Rang Altjerr-warn kangkemel angkek. Kwereng rang inenh ilek, “Tjampet nhenheng nyentam-nyentel antjwerrerrang. ");
INSERT INTO amx_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Thang itja weth wine antjwetjenh ahelh nhenhel. Kelant thang antjwetjenh, Altjerr rang mernelhemeng-rlwer, rang tjerrtj ingkerrekeh Ngkart anemeng.” ");
INSERT INTO amx_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Jesu-el mern inek. Rang Altjerr kwer kangkemel angkek. Kwereng rang mern renh ltwakek. Rang ineh mern renh anthemel ilek, “Nhenh mpwerrk tjengenh anem. Thang mpwerrk tjengenh anthetjenh tjenkerr-arteh arrehantherr. Nhenh arlkwerrerray, tjeng irlpangkemel.” ");
INSERT INTO amx_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Inang kel tjenkerr arlkwekarleng, Jesu rang tjampet ngkwarl wine-akert inek. Rang inenh ilek, “Nhenh alhwang tjengenh anem. Alhwang tjengenh thelelhem, rang arrantherrenh Altjerrel-ayel peltj-iletjeh. Lakenh thang alhelentj lyeteny ngkernem. ");
INSERT INTO amx_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Arerrerrang, artwang rarl yengenh atwenh-atwenh mapeh anthetjenharl, rang tjengel-ayel nhenhel anem. ");
INSERT INTO amx_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Tjerrtj-henh Ler kwer anem ilwetjeh, Altjerrel ilekarl-arteh. Artwang rarl renh alethang atwenh-atwenh mapeh anthemeng, Altjerrel renh rwekenth-kenth-iletjenh.” ");
INSERT INTO amx_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Kwertengerl inang pawenherrek, “Ngwenhelam renh atwenh-atwenh mapeh anthetjenh?” ");
INSERT INTO amx_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kwereng kwertengerl map inang pawenherrek. Kwertengerl nyent angkek, “Yeng twernk arrehantherr.” Kenh arrpenh angkek, “Itja, yeng-atwetj twernk arrehantherr anemer.” ");
INSERT INTO amx_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jesu-el inenh ilek, “Tjerrtj lwereny map-henh twernk map, inang kwenh tjerrtj inehenh twernerl-apem. Inang ahentj-anem, tjerrtj mapel inenh naketjeh, inenh ilemel inang mwerr anthwerr kwel. ");
INSERT INTO amx_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Arrantherr itja twernk nhenh map-arteh anetjeh. Artwang ngwenh apek rarl twernk arrehantherr anemeng, rang kel tjey arrehantherr-henh-arteh mernelhetjeh. Rang kel rrkwapenh-apenh arrehantherr-henh-arteh mernelhetjeh. ");
INSERT INTO amx_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Yeng angketj kwek iletjeh ahentj. Artwang atherr apek anem. Nyent kel kwenp arrernelhem, mern arlkwetjeh. Kenh arrpenh rrkwapem, artwang kwer mern anthetjeh. Artwang nhenh atherreng ngwenh apek artwang arrpenheh twernk anem? Artwang rang kwenh, rarl kwenp arrernelhemel mern arlkwemant. Yeng kwenh arrehantherr mernelhem, yeng artwang rrkwapenh-apenh-arteh anem. ");
INSERT INTO amx_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Yeng rwekenth-kenth-warn irrekarleng, arrantherr tjengel-ayel kwet anek, arrantherr yengenh itja imperl-alhek. ");
INSERT INTO amx_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Lakenheng thang arrantherrenh ngkernetjenh, arrantherr king-arteh twernk irretjenh, Angey tjengenhel yengenh ngkernekarl-arteh. ");
INSERT INTO amx_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Yeng kel mer tjengenhel anemeng, arrantherr tjengel-ayel mern arlkwetjenh. Arrantherr nyentam-nyent king-henh chair amparrkey-arrkeyel anetjenh, arrantherr Israel-henh peltj map ingkerrek arntarnt-aremel twernk irretjenh. ");
INSERT INTO amx_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simon-ay, Simon-ay, yeng-amparr awang, arrentj rartek Altjerr renh pawenhek, arrantherrenh arrkernetjeh. Arrentj rang ahentj-anem arrantherrenh nakepakel-ilemel arrkernetjeh, arrantherr apek yengenh arratj nakemeng. Arrantherr yengenh mentj impetjeh apek. ");
INSERT INTO amx_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Simon-ay, thang Altjerr renh pawenhek, ngwenh twer-iletjeh, ntwang yengenh twerel kwet naketjeh. Thang iterl-arem, ntwang tjeng-hetj ntjwem-irretjenh. Kelant ntwang Altjerr-warn twep-irremarleng, ntwang kwertengerl nhenh map arntarnt-aretjeh, inang yengenh twerel naketjenheng.” ");
INSERT INTO amx_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Peter-el Jesu renh ilek, “Itjaw, Ngkartay! Yeng-artek anew-anew ngkwengel-ayel anetjeh. Inang ngwenh tjayel-warn kwernetjeh apek, yeng-arlk inang kwernetjeh. Inang ngwenh irrernng atwetjeh apek, yeng-arlk inang irrernng atwetjeh.” ");
INSERT INTO amx_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Jesu-el renh ilek, “Peter-ay, arratj ngwentheh-atwetj ntwang tjeng-hetj rrpwetj-ingar anyenngel ilelhetjenh, ntwang tjeng kaltj-kwenh anemeng, tjwek-tjwek rrwey rang arlketj-kwenyel-antey mpank.” ");
INSERT INTO amx_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesu-el kwertengerl kwerenh map pawenhek, “Arrantherr key iltjelay-irrek, thang nheng arrantherrenh maney-kwenh yakweth-kwenh pwet-kwenh lanthekarleng?” Inang tjernemel angkek, “Itjam!” ");
INSERT INTO amx_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Rang inenh lakenh ilek, “Lyet arrpenh-lkwer anem! Maney apek rnwanentj apek yakweth apek arrehantherr-henh intem apek, kel angerrerrang arrehantherrel-ayel. Arrehantherr apek knife angerr itja anyenetj-kwenh, rnwanentj apek arrehantherr-henh maneyeh antherrerrang, knife angerr-lkwer apek arrantherr payem-iletjenheng. ");
INSERT INTO amx_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Angketj lakenh Altjerr-henh pipel-arleng intem, ‘Inang renh kwenh artwang merrentj-arteh ilek.’ Inang kwenh angketj nhenh tjeng-akert pip-warn arrernekarl. Lyet inang yengenh merrentj kwel iletjenh, angketj nhenh-arteh.” ");
INSERT INTO amx_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Kwertengerl inang renh ilek, “Ngkartay, aray, kel nwerneh kwenh knife angerr atherr intem.” Jesu-elemeh inenh ilek, “Kel mwerr.” ");
INSERT INTO amx_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Kel Jesu warleng arratek, kwertengerl kwerenh map-akert. Inang mer Olive irntang-warn alhek. Inang kweteth mer Olive-warn alhetjart. ");
INSERT INTO amx_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Inang Olive irntang kwerel anerl-anek. Jesu-el inenh ilek, “Altjerr renh pawenherrerrang, rang arrantherrenh arntarnt-aretjeh, arrentjel arrantherrenh arrkernehetjeng.” ");
INSERT INTO amx_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Jesu ntwarr-kweny war alhek, amperel-ayeng rang arrernelhek. Rang Altjerr pawenhek, ");
INSERT INTO amx_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Angey tjengenhay, yeng itja ahentj-anem, irlkert angerr inemel ilwetjeh. Ntwang war kwenh tjeng ahentj-anem, yeng ilwetjeh, yeng kel ngkweng kangkwerretjenh.” ");
INSERT INTO amx_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Angel nyent kwer-warn petjek alkereng, renh twer-iletjeh. ");
INSERT INTO amx_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesu rang ywarn iterremel, rang wetham-weth Altjerr pawenhek. Antjey kwerenh ahelh-arleh alhwang-arteh anyetjam. ");
INSERT INTO amx_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Jesu rang kemerrek, kwertengerl kwerenh map-warn angkep alhek, inarl ankwa intetjam-warn. Inang ankwang interleh, inang ltarrp angerr anemeng wart. ");
INSERT INTO amx_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Rang inenh pawenhek, “Wenhengarl arrantherr ankwerrek? Kemerremel Altjerr pawenherrerrang, rang arrantherrenh arntarnt-aretjeh, arrentj rang petjehetj, arrantherrenh arrkernehetjeng.” ");
INSERT INTO amx_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesu rang kwertengerl kwerenh map-warn angketjam-rlwer, atwenh-atwenh aningk petjewarrek. Judas rang inenh angetjek. Judas rang kwertengerl Jesu-henh anek. Rang itwek-irremel Jesu renh arrantjwetjeh anek. ");
INSERT INTO amx_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Jesu-el Judas renh pawenhek, “Judas-ay, wenheh ntwang yengenh arrantjwem? Ntwang war Tjerrtj-henh Ler renh ineh anyenng-anyenngel mernetjeh key?” ");
INSERT INTO amx_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Kwertengerl mapel alhengk-arek, inang Jesu renh antwerrketjenharl. Inang renh pawenhek, “Ngkartay, nwern key inenh atwey?” ");
INSERT INTO amx_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Kwertengerl nyentelemeh artwang nyent knife alkeyel irlpang rlweth-atwek. Artwang rang priest twernk angerr-henh rrkwapenh-apenh anek. ");
INSERT INTO amx_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesu-el kwertengerl renh ilek, “Kel impay!” Kwer-penh Jesu-el artwang rrkwapenh-apenh renh irlpang arnpemel mwerr-ilek. ");
INSERT INTO amx_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jesu-el priest twernk map atwenh-atwenh map angerrepat map thwen ilek, “Yeng anyenngalth anetj-kwenh! Wenheng arrantherr arrawey-akert petjewarrek, yengenh antwerrketjeh, knife-akert kweter-akert-arlk? ");
INSERT INTO amx_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Yeng kwenh arltang mapel church-warn alhetjart, arrantherr yengenh itjarl antwerrkewarrek. Lyet Altjerrel arrantherrenh impem, yengenh antwerrketjeh, arrentj ahentj-anemeng wart.” ");
INSERT INTO amx_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Inang Jesu renh antwerrkemel priest twernk-henh warl-warn kwen angerrerrek. Peter rang ineheng ingkern-angkwerr alhek. ");
INSERT INTO amx_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Inang rwang anthelek, priest twernk-henh yard kwenel, inang ntjwetj-irretjeh-anngernt. Inang ingkerrek rwang kwerel-ayel arrernelhemel ntjwetj-irrek. Peter inehel-ayeng arrernelhetj-alhek, ntjwetj-irretjeh. ");
INSERT INTO amx_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Marl rrkwapenh-apenh nyentelemeh renh arek, rwel anerleh. Marl rang renh alhengk-aremel angkek, “Artwang nhenh-artek Jesu-henh peltj, rang kwerel-ayeng anetjam!” ");
INSERT INTO amx_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Peter-el renh ilek, “Marlay, yeng-artek itja kwer kaltj!” ");
INSERT INTO amx_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ingkernemeh artwang arrpenhel Peter renh aremel ilek, “Ntwang kwenh Jesu-el-ayeng anek!” Peter rang renh tjernemel ilek, “Artwangay, itjeyay!” ");
INSERT INTO amx_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kelant artwang arrpenhemeh angkek, “Artwang nhenh-artek arratj Jesu-el-arleng anek, rang artwang Galilee-areny anemeng wart!” ");
INSERT INTO amx_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Peter-el renh tjernemel ilek, “Artwangay, ntwartek ahert war angkem. Yeng-artek kaltj-kwenh anem kwer!” Peter rang angketjam-rlwer, tjwek-tjwek rrweyemeh arlkerl-alhek. ");
INSERT INTO amx_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ngkart rang alngarelhemel Peter renh twant-arek. Peter irlpangkek, Ngkartelarl nheng arrwekel angketj kwer-akert ilekarl-penheh: “Ntwang kwenh yengenh anyenng-anyenng ilelhetjenh rrpwetj-ingar, tjwek-tjwek rrwey rang arlketj-kwenyeng kwet.” ");
INSERT INTO amx_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Peter yard kweneng arratemel, angerr arnek. ");
INSERT INTO amx_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Artwang atwenh-atwenh inarl Jesu rrkwerl-anek, inang renh arrampewemel atwek. ");
INSERT INTO amx_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Inang anngang kwerenh tjerlarrel-arteh ayernemel arltwek, arehetjeng. Kwereng inang renh pawenhek, “Ntwang Altjerr-henh angketj angenh-angenh key? Nwernenhemeh ilay, ngwenhelam ngwenh atwek?” ");
INSERT INTO amx_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Inang renh kwet arrkentj-iletjam. ");
INSERT INTO amx_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Aherlkentjel angerrepat twernk map priest twernk map Moses-henh mpwareng-areng kaltj-anthenh-anthenh map thwen inang arraw-irrek. Inang Council angerr anek. Inang Jesu renh tjey-angemel rlkwerr-warn arrernek. Inang renh pawenhek, ");
INSERT INTO amx_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Nwernenh ilay, ntwang apek Christ rang anem? Altjerrelarl ngkwey alhelekarl-penh, rarl ahelh nhenh-warn lanthetjenharl?” Jesu-el inenh ilek, “Wenheham thang arrantherrenh iletjeh? Yeng apek arrehantherr ilelhem, arrantherr yengenh naketj-kwenh anetjenh. ");
INSERT INTO amx_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Thang apek arrantherrenh pawenhem, arrantherremeh yengenh itja tjernetjenh. ");
INSERT INTO amx_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Lyeteng Tjerrtj-henh Ler alpetjenh, Altjerrel-ayeng anetj-alpetjenh, ratherr twer angerr-akert kwet anetjenh.” ");
INSERT INTO amx_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Inang renh pawenhek, “Ntwang key Altjerr-henh Ler anemam?” Jesu-el inenh ilek, “Arrantherr kwenh arratj angkek.” ");
INSERT INTO amx_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Inang pawenherrek, “Nwern kel angketj kwerenh awek! Nwern itja artwang arrpenheh palenthwetjeh.” ");
INSERT INTO amx_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Council kemerremel inang Jesu renh twernk Rome-areny-warn arreny kwerenh Pilate-warn tjey-angek. ");
INSERT INTO amx_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Inang renh Pilate-eng ularr rrtjwerremel ilek, “Nwernarrp artwang nhenh arek awek thwen, rang tjerrtj map ilek, inang itja Rome-areny government-eh kangkwerretjeh. Inang twernk angerr Caesar-eh tax maney anthetj-kwenh anetjeh. Rang ilelhek, rang Christ king-arl kwel nwerneh anemeng.” ");
INSERT INTO amx_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilate-el Jesu renh pawenhek, “Arratjam ntwang tjerrtj Jew map-henh king anem?” Jesu-el renh tjernemel ilek, “Ntwang kwenh arratj angkek.” ");
INSERT INTO amx_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pilate-elemeh priest twernk map tjerrtj aningk ingkern petjekarl map thwen ilek, “Artwang nhenh itja merrentj anem. Thang renh mentj impem, alpetjeh.” ");
INSERT INTO amx_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Inang ahang-irremel ilek, “Jesu rartek tjerrtj map ilek, inang itja government-eh kangkwerretjeh! Rang tjerrtj rwekenth-kenth-ilenh-ilenh! Rang mer Judea ntjaperel tjerrtj map lakenh pal kaltj-antherl-apetjart. Jesu rang nheng mer Galilee-el-amparr rwekenth-kenth-ilerl-apetjam, kwereng rang kwewaleny rrwernelhekarl mer nhenhelemeh.” ");
INSERT INTO amx_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilate-el nhenh awemel rang inenh pawenhek, “Artwang nhenh mer Galilee-areny key?” ");
INSERT INTO amx_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Inang renh ilek, “Rang kwenh artwang Galilee-areny anem.” Herod rang twernk anek mer Galilee-ek. Pilate-el renh king Herod-warn lanthek. Herod rang arltang kwerel Jerusalem kwerel anek, yatjarr petjekarl. ");
INSERT INTO amx_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herod-el arrwekel angketj Jesu-akert awentjekarl. Rang ahentj-anek, Jesu renh aretjeh ngkweyeng-ntjel. Rang ahentj-anek, Jesu-el kwereng ularr alker-areny twer angerrel mpwaretjeh kwel. Lakenheng rang kangkek, Pilate-el Jesu renh kwer-warn lanthekarleng. ");
INSERT INTO amx_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kel inang Jesu renh Herod kwer-warn angek. Herod-el Jesu renh map-ingar pawenhek. Jesu rang intert kwet angketj-kweny anek. ");
INSERT INTO amx_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Priest twernk map artwang Moses-henh mpwareng-areng kaltj-anthenh-anthenh map thwen inang irnetjam. Inang Jesu renh ahang-irremel ilterrerretjam. ");
INSERT INTO amx_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Kwereng Herod-el atwenh-atwenh kwerenh mapel thwen Jesu renh arrkentj-iletjam-arlk. King-henh mantarr amparrkey-arrkey-warn inang renh kwernek. Kwereng Herod-el renh Pilate-warn angkep lanthek. ");
INSERT INTO amx_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Arltang kwerel Herod Pilate ratherr peltjemeh irrek. Arrwekel ratherr arnkely-arnkely anerrek. ");
INSERT INTO amx_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Kwereng Pilate-el priest twernk map arraw-ilek, angerrepat twernk map tjerrtj arrpenh map-arlk thwen. ");
INSERT INTO amx_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Rang inenh ilek, “Arrantherr artwang nhenh tjeng-warn angetjek. Arrantherr yengenh ilek, rang kwel tjerrtj map ilerleh, inang government-ek itja kangkwerretjeh. Thang renh mantjel pawenhek arrehantherreng anngetherr. Yeng iterrem, rang itja merrentj anem. ");
INSERT INTO amx_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herod-el ilek, rang itja merrentj anem, renh nwerneh-warn angkep lanthemel. Thang itja renh pelkel irrernng atwetjeh. ");
INSERT INTO amx_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Lakenheng thang atwenh-atwenh map iletjenh, renh whip-el atwetjeh. Kwer-penh thang renh mentjemeh impetjenh.” ");
INSERT INTO amx_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Inang ingkerrek arlkemel ilek, “Renh atwerrerrang! Barabbas renh-amparr nwerneh tjayeleng arratelh-ilerrerrang!” ");
INSERT INTO amx_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Barabbas rang nheng tjerrtj map ilekarleng, inang itja Rome-areny government-eh kangkwerretjeh. Inang atwenh-atwenh mapel-ayeng atwerretjart. Rang tjerrtj arrpenh map irrernng atwek. Lwerenh-penh inang renh tjayel-warn merrentjemeh kwernek.) ");
INSERT INTO amx_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilate ahentj-anek, Jesu renh mentjemeh impetjeh. Lakenheng rang tjerrtj inenh weth ilek, “Nhenh kwenh artwang pelkeny!” ");
INSERT INTO amx_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Inang arlkemel angkek, “Renh kel ntwerlkeh arrernewarrang! Renh kel ntwerlkeh arrernewarrang!” ");
INSERT INTO amx_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Pilate-el inenh pawenhek, “Wenham rang anetj mpwarek? Thang renh itja irrernng atwem, rang artwang pelkeny anemeng. Lakenheng thang atwenh-atwenh map iletjenh, renh whip-el atwetjeh war. Kwereng thang renh kel mentjemeh impetjenh, artwang pelkeny wart.” ");
INSERT INTO amx_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Inang kwet arnterram-arnterr arlkek, rang Jesu renh ntwerlkeh arrernetjeh kwet. Pilate-el inenh ywarn kwet intertelh-ilek. ");
INSERT INTO amx_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Lakenheng rang ineh kel kangkwerrek. ");
INSERT INTO amx_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pilate rang artwang merrentj nheng tjayeleng arratelh-ilek, artwang rarl tjerrtj map ilekarl, itja government-eh kangkwerretjeh. Rang Jesu renh atwenh-atwenh map-warn lanthek, inang renh ntwerlkeh arrernetjeh, tjerrtj map ahentj-anekarl-arteh. ");
INSERT INTO amx_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Atwenh-atwenh mapel Jesu renh Jerusalem-eng keth-warn tjey-angek, ntwerlkeh arrernetjeh-anngernt. Inang artwang nyent arek ularr petjerleh, arreny kwerenh Simon. Rang artwang mer Cyrene-areny anek. Atwenh-atwenh mapel Simon renh rrkwek. Inang ntwerlk kwer-arleh tjwenek, renh twernemel, ntwerlk renh Jesu-eng anharrel-ayeng angerl-apetjeh. ");
INSERT INTO amx_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Tjerrtj aningk Jesu-eng ingkern-angkwerr petjewarretjam. Marl rrpwetj-arlk inehel-ayeng petjek. Inang Jesu-eh angerr akay arnek. ");
INSERT INTO amx_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesu-el inenh alngarelhemel arek. Rang inenh ilek, “Marl Jerusalem-areny mapay, tjeng arnetjal anerrerrang! Arrantherr arrehantherrarrp arnelh-arnelh-ilerrang, amenheng-nheng arrehantherr-henheh. ");
INSERT INTO amx_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","30","Kelant inang arrantherrenh Jerusalem-areny map rwekenth-kenth-iletjenh. Arrantherr angketjenh, ‘Marl kwer-kwenh map kwenh arrken anem! Marl kwer-akert map ltarrp-irrem-anem, atwenh-atwenh mapel kwer inehenh atwetjenharl.’ Arltang kwerel arrantherr Altjerr renh pawenhetjenh, ‘Atwenh-atwenh mapel irrernng atwehetj, pwert nhenh map ntwang arrewetjeh mpwarang, nwerneh-arleh kerneng anyemel arltwetjeh.’ ");
INSERT INTO amx_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","“Lyet inang yeng, tjerrtj pelkeny rwekenth-kenth-ilemel atwem. Ngwenth war inang arrantherrenh tjerrtj ahelh-areny map angerr-lkwer rwekenth-kenth-ilemel atwetjenh!” ");
INSERT INTO amx_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Artwang merrentj atherr arrpenh thwen inang Jesu-el-ayel tjey-angek, renh-atherrenh ntwerlkeh arrernetjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Inang mer kwer irretj-alhek, renharl inang ilem, “Kapert ngkwern”. Inang Jesu renh ntwerlkeh nail-el tanthemel arrernek. Kwereng artwang anetj nheng atherr inang ntwerlkeh arrernek, Jesu-eng iter atherrel, Jesu kenh mpwepelarl. ");
INSERT INTO amx_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesu angkek, “Angeyay, anetj inehenh wang. Inang kwenh itja kaltj, inarl Ler ngkwengenh irrernng atwemeng.” Atwenh-atwenh inang Jesu-henh mantarr map irrarnpelh-ilek gamble-irremel. ");
INSERT INTO amx_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Tjerrtj petjekarl mapel renh aretjamarl. Twernk mapel renh arrampewetjam. Inang lakenh angkerrek, “Rang arrpenh map iteth-ilek irrernngeng. Lwerenheng kwel rang apek Christ anemeng, renharl Altjerrel ngkernekarl, rang ntwerlkeng anarnpemel kwewaleny iteth-ilelhemer!” ");
INSERT INTO amx_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Atwenh-atwenh map itwek-irrek, renh arrampewetjeh. Inang kwer wine tjekert anthek. ");
INSERT INTO amx_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Inang renh arrkentj-ilemel iletjam, “Ntwang arratj key tjerrtj Jew map-henh king anem? Kel ntwerlkeng ngkwewaleny anarnp-ilelhang!” ");
INSERT INTO amx_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Tjerrtj arrpenh mapel arrwekel angketj nhenh arnang kwek-warn tanthekarl, “Nhenh rang kwenh tjerrtj Jew map-henh king.” Kwereng atwenh-atwenh nyentel arnang nhenh ntwerlkeh ampek-arrernek, Jesu-henh kaperteng kernenyel. ");
INSERT INTO amx_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Artwang merrentj nyent, rarl ntwerlkel arlpar-irnetjam, rang Jesu renh arrampewemel ilek, “Ntwang key Christ rang? Ngkwewaleny anarnp-ilelhang, ilernenh-arlk!” ");
INSERT INTO amx_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Artwang merrentj arrpenhel renh arnpakemel ilek, “Renh impay, arrkentj-iletj-kweny anetjeh! Ntwang ater-irretjeh Altjerreng! Inang nwernenh rrpwetj merrentj ilek, ntwerlkel ilwetjeh rrpwetj-antey. ");
INSERT INTO amx_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nhenh kel arratj anem, ilern ilwetjeh lakenh, ilern anetj mernelhekarleng. Kenh artwang nhenh pelkenyarl anem.” ");
INSERT INTO amx_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Rang Jesu-warn angkek, “Jesu-ay, tjeng irlpangkay, ntwang tjerrtj ingkerrekeh Ngkart anemeng mer ngkwengenhel.” ");
INSERT INTO amx_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesu-el renh tjernemel ilek, “Thang ngwenh alhelem, lyet ntwang tjengel-ayel anetjenh mer mwerrel.” ");
INSERT INTO amx_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kel aherrk irntarel anek. Aherrk rang ngwemernt-irrek, mer ntjaper ngwemernt anek angwerreh-atwetj. ");
INSERT INTO amx_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Mantarr angerretj nheng, rarl Altjerr-henh church angerr kwenel arlpar-anetjamarl, rang mpwep anthwerr kerneng kwenelakw alterrelherl-alhek. ");
INSERT INTO amx_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jesu-el arnterr arlkemel ilek, “Angeyay, thang ngkweng-warn kwerrern tjengenh lanthem, ntwang arntarnt-aretjeh.” Rang lakenh angkemel kel ilwekemeh. ");
INSERT INTO amx_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Atwenh-atwenh map-henh twernkel nhenh aremel, rang Altjerr nakek, lakenh angkemel, “Artwang nhenh arratjam anek, anetj-kwenh!” ");
INSERT INTO amx_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Tjerrtj arrpenh map, inarl war aretjeh petjekarl, inang nhenh arekarleng, inang ltarrp-irrek. Inang arnangk atwelhemel alpekemeh. ");
INSERT INTO amx_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jesu-henh peltj map, marl nheng map thwen, inarl mer Galilee-eng-ntjel kwereng anharrel-ayeng petjekarl, inang nhenh ingkerrek ntwarreng aretjam. ");
INSERT INTO amx_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Artwang angerrepat nyent anek, arreny kwerenh Joseph. Rang town Arimathea-areny anek, mer Judea-el. Joseph nhenh artwang irlpareth anek. Rang karelhetjam, Altjerr mernelhetjeh, rang tjerrtj ingkerrekeh Ngkart anemeng. Rang Council-areny anek. Rang itja ahentj-anek, Council inang Jesu renh court-ilemel merrentj iletjeh. ");
INSERT INTO amx_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Jesu-arl ilwekarl-penh, Joseph rang twernk Pilate-warn alhek, Jesu-henh mpwerrkeh pawenhetjeh. ");
INSERT INTO amx_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kwereng rang Jesu-henh mpwerrk ntwerlkeng anarnpelh-ilek. Rang mpwerrk mantarrel arltwemel artaper-ilek, kwereng intey-warn renh angemel arrernerl-alpek. Tjerrtj irrernng itja arrwekel intey nhenh kwerel arrernekarl apek. ");
INSERT INTO amx_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Nhenh kel Friday angwerr-angwerr, ngkwa arltang angerr Saturday anek, ltjwerrenh-rrenh. Inang arltang kwereng arrwekel kwet mpwarek. ");
INSERT INTO amx_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Marl nheng map inarl Jesu-eng anharrel-ayeng petjekarl mer Galilee-eng-ntjel, inang Joseph-eng ingkern-angkwerr alhek. Inang arek, rang Jesu-henh mpwerrk inemel, awelng-warn arrernekarl-penh. ");
INSERT INTO amx_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kwereng inang mer-warn alpek. Inang anter npwang mwerr-akert inek, Jesu-henh mpwerrk kelant pernetjeh-anngerntel. Inang itja arltang Saturday-el alhek, Jesu-henh mpwerrk pernetjeh, Altjerr-henh angketjel arnpakekarleng, itja arltang angerr Saturday-el rrkwapetjeh. ");
INSERT INTO amx_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sunday ntwely mpank anek. Marl inang intey nheng kwer-warn alhek, anter npwang mwerr-akert, Jesu-henh mpwerrk pernetjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Inang intey-warn itwek-irremel, inang arek pwert angerr nheng ankert-wekarl. ");
INSERT INTO amx_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Inang intey kwer-warn irrpenhek. Ngkart Jesu-henh mpwerrkeh inang ywarek. ");
INSERT INTO amx_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Inang ywarn iterrek. Kwereng artwang atherr ineheng kwet irnetj-alhek, mantarr mperlker anthwerr-akert. ");
INSERT INTO amx_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Inang angerr ater-irrek. Inang amperel-ayeng arrernelhemel, inngerr kwen-irrek. Artwang ratherr pawenhek, “Wenheng arrantherr tjerrtj itethek palenthwem awenngel? ");
INSERT INTO amx_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Jesu itja nhenhel anem! Rang irrernngeng iteth-irremel kemerrek! Arrantherr apek irlpangkemam, rarl nheng arrantherrenh mer Galilee-el ilekarleh? ");
INSERT INTO amx_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","‘Tjerrtj-henh Ler renh kwenh inang artwang anetj-warn lanthetjenh, inang renh ntwerlkeh arrernetjenheng. Kweny atherr-penh rang weth iteth-irremel kemerretjenh.’ ” Lakenh angel atherrel inenh ilek. ");
INSERT INTO amx_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Marl inang Jesu-henh angketjeh irlpangkek. ");
INSERT INTO amx_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Inang angkep alpek. Inang angketj nhenh kwertengerl inenh iletj-alpek, nakenh-nakenh arrpenh map-arlk thwen. ");
INSERT INTO amx_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Marl inarl nheng intey-warn alhekarl, inang anek Mary Magdalene, Joanna, Mary nheng James-henh mwek, marl arrpenh map thwen. ");
INSERT INTO amx_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Kwertengerl inang naketj-kwenh anek, inang iterl-arek angketj inehenh pal-pal war angkekarl kwel. ");
INSERT INTO amx_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Kel Peter rang irnetj-alhemel intey kwer-warn arrtjanek. Intey arrew kwerel rang altjwernemel kwenemeh kert-arek. Rang mantarrant arek interleh. Rang alpemel ywarn iterrerl-anek, “Nthakenh irrekay?” ");
INSERT INTO amx_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Arltang Sunday kwerel Jesu nakenh-nakenh atherr arrpenh town Emmaus-warn alherrek. Emmaus rartek town kwek anek, Jerusalem-eng altwerl, 12 kilometres-arteh. ");
INSERT INTO amx_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nakenh-nakenh ratherr tjeyel alhep-alhemel angketj Jesu-akert angkerrerl-apetjam. Ratherr angkerrek, nheng arrpenh mapel Jesu renh irrernng atwekarleh, kwer-penh mpwerrk kwerenh ywerrek inteyeng. ");
INSERT INTO amx_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ratherr angkerrerl-apetjam-rlwer, Jesu kwer-atherr ingkerneng petjek, kwer-atherrel-ayel alhep-alhek. ");
INSERT INTO amx_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ratherr renh arek, ratherr renh itjarl alhengk-arek, Altjerrel iterleng-iterl kwer-atherr-henh mart-ilekarleng wart. ");
INSERT INTO amx_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesu-el renh-atherrenh pawenhek, “Ngwenh-penham mpwel angkerrerl-apetjam?” Ratherr irnetj-alhek, inngerr kwenelakw. ");
INSERT INTO amx_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Artwang nyent arreny kwerenh Cleopas, rang renh pawenhek, “Ntwang Jerusalem-warn yatjarr petjekarl key? Nthakenharl ntwang anetj nhengeh kaltj-kwenh anem, nheng ngwerr arrpenh anekarl?” ");
INSERT INTO amx_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesu-el renh-atherrenh pawenhek, “Wenh-penh mpwel angkerrerl-apetjam?” Ratherr renh ilek, “Jesu Nazareth-areny. Rang Altjerr-henh angketj angenh-angenh anek. Rang tjerrtj map kaltj-anthetjart. Rang twer angerrel tjerrtj mwerr-iletjart. Altjerr kwer kangkek, tjerrtj ingkerrek thwen. ");
INSERT INTO amx_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Priest twernk mapel angerrepat twernk mapel thwen, inang renh twernk Pilate-warn lanthek, Pilate-el renh court-el pawenhetjeh-anngernt. Pilate-el renh atwenh-atwenh map-warn lanthek, inang renh ntwerlkeh arrernetjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nwern iterl-arek, rang kwel tjerrtj Israel-areny nwernenh arntarnt-aretjenharl atwenh-atwenh mapeng, inenh anpwemel. Itja. Nhenh kel arltang rrpwetjemeh, rarl ilwekarl kwer-penh. ");
INSERT INTO amx_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Lyet marl rrpwetj nwern-henh inang nwernenh anwerlkelh-ilek. Lyet kweny-rtweh inang intey-warn alhek. ");
INSERT INTO amx_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Inangemeh Jesu-henh mpwerrkeh ywarek. Inang petj-alpek, nwernenh iletj-alpek, inang kwel angel alker-areny atherr arekarl. Angel ratherr kwenh inenh ilekarl, Jesu iteth anerleh. ");
INSERT INTO amx_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nwern-henh arrpenh map-antem intey-warn alhek. Inang kel arek, intey rang rltwang anerleh, marl inarl ilekarl-arteh. Jesu renh inang itjarl arekarl.” ");
INSERT INTO amx_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Jesu rang kwer-atherr-warn angkek, “Ywekay, mpwel-artek ahert apek, arratj iterretj-kweny! Mpwel irrpelth-irrem key angketj Christ-akert, ngkweyarl Altjerr-henh angketj angenh-angenh mapel pip-warn arrernekarl? ");
INSERT INTO amx_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Mpwel apek angketj inehenh nakek, mpwel kaltj anemer, Christ rang rwekenth-kenth-amparr anetjenh ilwetjeh-anngernt. Kwer-penhant Altjerrel renh ngkernetjeh, Ngkart angerr anetjeh-anngernt.” ");
INSERT INTO amx_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kwer-penh Jesu-el kwer-atherr angketj Moses-henh keth-ilemel kaltj-anthek, Altjerr-henh angketj angenh-angenh map-henh angketj thwen. Rang renh-atherrenh keth-ilemel ilek, angketj Altjerr-henh pipel-ayeng Jesu kwer-akert intemeng. ");
INSERT INTO amx_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Inang kel mer Emmaus kwer itwek-irrek. Jesu anper alhetjeh irrek. ");
INSERT INTO amx_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Nakenh-nakenh ratherr renh arnpakek, “Ilernehel-ayel-amparr anang, kel angwerr-angwerr irrekarlemeh.” Rang warl-warn irrpenhek, kwer-atherrel-ayel anek. ");
INSERT INTO amx_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Inang arrernelhek, mern arlkwetjeh. Jesu-el mern inek, Altjerreh kangkemel angkek. Kwer-penh rang mern renh ltwakemel, kwer-atherr anthek. ");
INSERT INTO amx_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ratherr renh alhengk-arekemeh, “Nhenh Jesu-an!” Jesu rang kel ywerrerl-alhek. ");
INSERT INTO amx_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ratherr angkerrek, “Yay, rang nheng tjeyel petjetjam-rlwer, rang kwenh ilernenh tjep-tjep-ilek, ilerneh Altjerr-henh angketj renh keth-ilemel kaltj-anthek!” ");
INSERT INTO amx_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ratherr kel kemerremel angkep Jerusalem-warn alperrek, nakenh-nakenh map-warn. Ratherr kwertengerl inenh aretj-alpek. ");
INSERT INTO amx_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Tjerrtj inang renh-atherrenh ilek, “Ngkart arratj irrernngeng iteth-irremel kemerrek, rang Simon-eh mernelhek.” ");
INSERT INTO amx_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ratherr inenh ilek, Jesu kwer-atherrel-ayel town Emmaus-warn alhekarl. Ratherr inenh ilek, “Rang mern ltwakekarleng, ilern renh alhengk-arekemeh.” ");
INSERT INTO amx_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Inang angketj Jesu-akert angkerretjam-rlwer, Jesu rarrp ineheng mpwepel irnetj-alhek. Rang inenh ilek, “Altjerr arrehantherr ngwerleny mernelhem.” ");
INSERT INTO amx_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Inang lthan kwel arekarleh-athen, inang ywarn iterl-arek, kwerrern-kweny irrek. ");
INSERT INTO amx_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Rang inenh pawenhek, “Wenheng arrantherr tjeng-hetj ater-irrem naketj-kwenhel? ");
INSERT INTO amx_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Iltjang tjengenh arerrerrang! Ingkang tjengenh arerrerrang! Yeng kwenh Jesu! Yengenh iltjel anpang, arrantherr alhengk-aretjenheng, nhenh yeng anemeng, itja lthan! Lthan kwenh itja yeng-arteh mpwerrk-akert, tjelk-akert.” ");
INSERT INTO amx_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Rang ineh iltjang kwerenh, ingkang kwerenh mernek. ");
INSERT INTO amx_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Inang arrken anthwerr awelhemel anwerlkek. Inang angkerrek, “Arratj Jesu rang nhenh! Kenh nthakenh rang iteth-irrek?” Lakenheng rang inenh pawenhek, “Arrehantherr apek arlkwetjeh intem?” ");
INSERT INTO amx_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Inang renh ker irrpenng ampeng anthek. ");
INSERT INTO amx_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Rang nhenh ineheng ularr arlkwek. ");
INSERT INTO amx_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Jesu-el inenh irlpangkelh-ilemel ilek, “Yeng nheng arrehantherrel-ayel anetjam-rlwer, thang arrantherrenh ilek, angketj Moses-elarl tjeng-akert ilekarl, Altjerr-henh angketj angenh-angenh mapelarl tjeng-akert ilekarl thwen, pwek Psalms-el tjeng-akert ilekarl thwen. Kel lyet angketj nhenh arratj anthwerr anem, yeng kwenh angkep iteth-irrek irrernngeng.” ");
INSERT INTO amx_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kwer-penh rang Altjerr-henh angketj inenh keth-ilemel kaltj-anthek, inang arratj alhengk-aretjenheng. ");
INSERT INTO amx_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Rang inenh ilek, “Angketj Altjerr-henh pipel-ayeng intem, Christ rang irlkert angerr inemel ilwetjenh. Kweny atherr-penh rang irrernngeng iteth-irremel kemerretjenh.” ");
INSERT INTO amx_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Altjerr-henh pipel-ayel angketj arrpenh intem, “Inang tjerrtj ingkerrek ilerl-apetjeh ahelh ntjaperel, inang Altjerr-warn twep-irretjeh, Altjerrel anetj inehenh wetjenheng. Lakenh Jerusalem-el-amparr, kwer-penh mer ingkerrekel ahelh ntjaperel. ");
INSERT INTO amx_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Arrantherr yengenh arek anngel, arrantherr angketj tjeng-akert ilerl-apetjeh, yengarl ilwekarl-penh, yengarl angkep iteth-irretj-alpekarl-penh thwen. ");
INSERT INTO amx_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Angey tjengenhel kwenh ngkwey alhelek, Kwerrern Alngaltar renh kwerenh map-warn lanthetjeh. Thang renh kel arrehantherr-warn lanthetj-alpetjenh. Arrantherr-antem Jerusalem-el karelhetjeh, Kwerrern rang alkereng petjetjenheng, arrantherrenh twer-iletjeh.” Lakenh Jesu-el kwertengerl kwerenh map ilek. ");
INSERT INTO amx_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jesu rang kwertengerl kwerenh map-akert tjeyel mer Bethany-warn alhek. Kwer-penh rang iltjang kwerenh kern-ilemel Altjerr tjang-pawenhek ineh, rang inenh twer-iletjeh. ");
INSERT INTO amx_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Rang ineh angkemarleng, rang alkerek-irrerl-alhek. Altjerrel renh angek, kwerel-ayeng anetj-alpetjeh. ");
INSERT INTO amx_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Kwertengerl inang amperel-ayeng arrernelhemel renh nakek. Kwer-penh inang Jerusalem-warn arrken awelhemel angkep alpek. ");
INSERT INTO amx_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Inang arltang mapel kwet Altjerr-henh church angerretj-warn alhetjart, Altjerr renh kangkemel naketjeh. ");
INSERT INTO amx_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Angketj rang anganentj kwet anek. Angketj rang Altjerrel-ayel anek. Angketj rang Altjerr anek. ");
INSERT INTO amx_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Angketj rang Altjerrel-ayel anek anganentj. ");
INSERT INTO amx_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","5","Angketj nhenhel-ayel Altjerrel ahelh-arlk alker-arlk tjerrtj-arlk ingkerrek arrmernek. Angketj rang iteth anthek ingkerrekeh. Iteth rang parrtj anek. Parrtj nhenh ngwemerntel parrtjelh-ilek tjerrtjeh kwetant. Ngwemerntel parrtj renh ywarn ilwernem. ");
INSERT INTO amx_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Altjerrel artwang nyent tjerrtj map-warn lanthek, artwang nhenh kwerenh arreny anek John. ");
INSERT INTO amx_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","John rang tjerrtj map-warn alhek, inenh parrtj nhenh kwer-penh iletjeh. Kwereng inang parrtj kwer-penh awemeng, inang Altjerr renh naketjenheng. ");
INSERT INTO amx_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","John rang kwenh itja parrtjentj-akert anek. Rang tjerrtj map parrtj kwer-penh ilekant war. ");
INSERT INTO amx_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Rang inenh lakenh ilek, “Parrtj anthwerr rang, nheng tjerrtj ingkerrek parrtjelh-iletjenh, rang ahelh nhenh-warn petjetjenh.” ");
INSERT INTO amx_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Angketj rang ahelhel anek. Tjerrtj inang angketj renh itja alhengk-arek, rang inehel-arleng anetjam. Angketj rang ahelh nhenh arrmernekarl! ");
INSERT INTO amx_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Angketj rang tjerrtj arlaltj kwerenh map-warn petjek, inang kwer ahentj-kwenyarl anek. ");
INSERT INTO amx_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Kenh tjerrtj inang angketj renh alhengk-aremel nakek, angketj rang inenh ilek, “Arrantherr Altjerr-henh peltjemeh anem.” ");
INSERT INTO amx_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Tjerrtj inang Altjerreh peltj-irrek, Altjerr rarrp ahentj-anek-arleng wart, inang peltj kwerenh anetjeh. Inang itja iterrentj inehenh-akert nhenh mpwarek, Altjerrelant inenh twer angerr-akertel peltj-ilek. ");
INSERT INTO amx_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Angketj rangemeh ngwerrm-irrek, nwernehel-ayeng anerl-alpek. Nwern renh arek, alkereng parrtj angerr-akert, Angey-henh Ler nyentant anemeng. Rang arratj anthwerr anek, nyerrkentj mernelhemel ahelh nhenh-warn petjek. ");
INSERT INTO amx_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","John-el tjerrtj map arlkemel ilek, “Nhenh kwenh artwang rang, kwer-penh thang nheng arrantherrenh arrwekel ilekarl, ‘Artwang rang tjengeng ingkern petjem. Rang anek tjeng-kwenyel-amparr. Lakenh rang kwenh tjengeng angerr anthwerr anem.’ ");
INSERT INTO amx_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Rang nyerrkentj anthwerr anem, rang nwerneh ingkerrekeh nyerrkentj mernelhem kwetant. ");
INSERT INTO amx_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Altjerrel arrwekel nheng tjerrtj mapeh mpwareng-areng kwerenh ilek Moses-el-ayeng, rang ingkernemeh nwerneh Jesu Christ-el-ayeng kangkentj kwet mernelhek, rang nwernenh angketj arratj renh ilek Jesu Christ-el-ayeng. ");
INSERT INTO amx_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tjerrtj nyentel itja kwet Altjerr renh arek apek. Kel Ler nyent kwerenhelant renh arek, rang kwerel-ayeng kwet anemeng. Rant Altjerr nwerneh mernek.” ");
INSERT INTO amx_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Tjerrtj Jew twernk map inang town Jerusalem-el anetjam, inang priest rrpwetj thwen church angerretj-henh rrkwapenh-apenh rrpwetj thwen John-warn lanthek. Inang renh pawenherrerrek, “Ngwenham ntwang? Nthenh-arenyam ntwang?” ");
INSERT INTO amx_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","John rang tjernemel ilelhek, “Yeng itja Christ rang anem, Altjerrel ngkwey alhelekarl.” ");
INSERT INTO amx_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Inang renh wetharlam pawenherrerrek, “Ngwenham ntwang? Ntwang Altjerr-henh angketj angenh-angenh Elijah nheng key?” Rang tjernemel ilelhek, “Yeng itja Elijah.” Inang renh pawenherrerrek wetharlam, “Ntwam Altjerr-henh angketj angenh-angenh nheng key, ngkweyeny alhelekarl-penh?” Rang tjernemel ilelhek, “Itjaw!” ");
INSERT INTO amx_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Inang renh wethemeharlam pawenhek, “Ngwenham ntwang? Kwewaleny ilelhay! Artwang nhak map, nthakenham nwern inenh iletjenh?” ");
INSERT INTO amx_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","John-el inenh angketj angenh-angenh Isaiah-henh angketjel ilek, “Yeng kwenh tjerrtj rrkwal-arenyarl, thang arrantherrenh ateng-ilemel ilerl-apem, ‘Ngkarteh arrwekel tjey mpwarewarrangaw!’ Angketj tjengenh alhengk-arerrerray!” ");
INSERT INTO amx_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Artwang Pharisee rrpwetj twernk inehenhel lanthek, ");
INSERT INTO amx_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","inang renh ilek, “Ntwang ilelhek, ntwang itja Christ rang anem, itja Elijah apek, itja Altjerr-henh angketj angenh-angenh arrpenh nheng Moses-arl anek-arteh apek. Wenheham ntwang tjerrtj map kwatj-warn irrpelh-ilemel baptise-em-ilem? Yanh itja arratj anem, lakenh mpwaretjeh!” ");
INSERT INTO amx_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","John rang ilelhek, “Thang tjerrtj kwatjel war irrpelh-ilemel baptise-em-ilem. Artwang nyent kel ahelh nhenhel anem, arrantherr kwer akwenarl anem. ");
INSERT INTO amx_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Rang kwenh tjengeng ingkern petjem. Yeng itja rarteh anem. Rang mwerr anthwerr anem. Yeng anetj-anetj war, pwet kwerenh kap-rlwetjeh apek.” ");
INSERT INTO amx_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Lakenh John rang ilelhek, rang tjerrtj map kwatj-warn irrpelh-ilemel baptise-em-iletjart-penh, mer Bethany-el Jordan ulpayeng ingerr-angkwerr. ");
INSERT INTO amx_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Arltang arrpenhel John-el Jesu renh arek, ularr kwer-warn petjerleh. Rang tjerrtj map ilek, “Arerrerrang, artwang nhenh kwenh Altjerr-henh Yep-yep kwek rang. Rang tjerrtj map-henh anetj rrpwaremel wem. ");
INSERT INTO amx_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Artwang nhenh thang arrantherrenh arrwekel-antey ilek, ‘Artwang rang kwenh tjeng ingkerneng petjetjenh, rang tjengeng arrwekel-antey anek tjeng-kwenyel-amparr. Lakenheng rang tjengeng inangkal-lkwer anem.’ ");
INSERT INTO amx_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Thang renh itja alhengk-arek arrwekel, lyetan thang renh alhengk-arem. Yeng kwenh petjekarl, arrantherrenh kwatjel-ayel baptise-em-iletjeh, kelant arrantherr renh alhengk-aremel aretjenh.” ");
INSERT INTO amx_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","John-el inenh Jesu kwer-penh ilek, “Thang Kwerrern renh arek, alkereng kwer-warn thep ntwerrert-arteh arrernelhetj-alhemeng kwerel-ayeng kwetemeh irrek. ");
INSERT INTO amx_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Thang renh itja-amparr alhengk-arek. Altjerrel yengenh lanthek, tjerrtj map kwatj-warn irrpelh-ilemel baptise-em-iletjenh. Rang yengenh lakenh ilek, ‘Ntwang aretjenh Kwerrern rang artwang ngwenheh apek arrernelhetj-alherleh, ntwang renh alhengk-aretjenh, Christ rang anem. Artwang nhenhel tjerrtj map Kwerrern Alngaltarel baptise-em-iletjenh.’ ");
INSERT INTO amx_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Thang renh alhengk-arekemeh. Thang arrantherrenh ilem, artwang nhenh rang Altjerr-henh Ler anemeng.” ");
INSERT INTO amx_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Arltang arrpenhel John rang mer Bethany-el anetjam, ulpay Jordan-eng ingerr, kwertengerl kwerenh atherr-akert. ");
INSERT INTO amx_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","John-el Jesu talkw alherleh rtwarek. Rang renh aremel angkek, “Artwang nhak arerl-anerray! Rang kwenh Yep-yep Altjerr-henh anem!” ");
INSERT INTO amx_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Kwertengerl ratherr John renh awek, rang lakenh angkemeng. Ratherr John imperl-alhemel Jesu-eng ingkern-angkwerr alherrek. ");
INSERT INTO amx_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesu-el alngarelhemel renh-atherrenh arek, kwereng ingkerneng petj-alherremeng. Rang renh-atherrenh pawenhek, “Wenham mpwel ahentj-irrem?” Ratherr angkek, “Rabbi! Mer nthenhel ntwang anem?” (Rabbi Anmatjerr angketjel angart-wem kaltj-anthenh-anthenh.) ");
INSERT INTO amx_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Rang renh-atherrenh ilek, “Aretjeh petj-alherray!” Ratherr kwerel-ayeng alhek mer kwerenh-warn. Ratherr kwerel-ayeng antarl-irrek angway-angwayek-atwetj. ");
INSERT INTO amx_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Kwertengerl atherreng nyent anek Andrew, Simon Peter-henh tjey. ");
INSERT INTO amx_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Kweny-rtwehemeh Andrew rang parrp alhek, kekw kwerenh Simon-eh palenthwetjeh. Rang renh aretj-alhemel ilek, “Nwern Messiah renh arek!” Hebrew angketjel renh ilem Messiah. Angketj arrpenh mapel renh anewem Christ. Christ renh Altjerrel ngkwey alhelek, renh Israel-areny map-warn lanthetjeh. ");
INSERT INTO amx_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andrew rang kekw kwerenh Jesu-warn ngwerl-alpek. Jesu-el Simon renh rtwant anthwerr arek. Rang renh ilek, “Ntwang kwenh arreny Simon, ntwang John-henh ler anem. Thang ngwenh arreny Cephas ilem.” Cephas angketj arrpenhel anewem Peter. ");
INSERT INTO amx_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Arltang arrpenhel Jesu rang ahentj-anek mer Galilee-warn alhetjeh. Rang alherl-apemel Philip renh arek. Rang renh ngwek, “Petj-alhay tjengel-arleng.” ");
INSERT INTO amx_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Philip rang mer Bethsaida-areny anek. Andrew Peter kenheng atherr mer alenh kwer-areny-antey anek. ");
INSERT INTO amx_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Philip Nathanael-eh palenthwek. Rang renh aretj-alhemel pawenhek, “Ntwang irlpangkem key, artwang nheng-penh Moses-el Altjerr-kenh angketj angenh-angenh mapel thwen pip-warn arrernekarleh? Nwern renh arek. Arreny rang anem Jesu, Joseph-henh ler, Nazareth-areny.” ");
INSERT INTO amx_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nathanael-el tjweker-irremel renh pawenhek, “Nazareth-areny key artwang mwerr anem? Itja apek!” Philip-el renh ilek, “Kel aretjehant petjay!” ");
INSERT INTO amx_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jesu-el Nathanael renh arnarek ularr petjerleh. Rang artwang nhenh kwer-penh angkek, “Artwang nhenh kwenh Israel-kenh peltj anem. Rang artwang irlpareth anem. Artwang arratj.” ");
INSERT INTO amx_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nathanael-el renh pawenhek, “Nthakenharl ntwang tjeng kaltj anek?” Jesu-el renh ilek, “Thang ngwenh arrwekel kwet arek, ntwang arnang tjwerrkel-ayeng lywel anemeng. Philip-el ngwenh ngwetj-kwenyeng-antey.” ");
INSERT INTO amx_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nathanael-el renh ilek, “Kaltj-anthenh-anthenhay! Ntwang kwenh Altjerr-henh Ler rang anem, mer Israel-ek king!” ");
INSERT INTO amx_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesu-el renh ilek, “Ntwang kwenh yengenh nakem, thang ngwenh ilek-arleng, thang ngwenh arekarl, arnang tjwerrkel-ayeng lywel anerleh. Kelant ntwang aretjenh, thang twer angerr tjengenh mernetjenh. ");
INSERT INTO amx_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Thang ngwenh arratj ilem, arrantherr alker renh aretjenh altjwer-irrerleh, angel alker-areny aretjenh, Tjerrtj-henh Ler kwer-warn anarnpetj-alherleh. Kwereng arrantherr aretjenh, inang alker-warn angkep alperleh.” ");
INSERT INTO amx_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Kweny atherr-penh tjerrtj map town kwek Cana-el mer Galilee-el arraw-irrek, artwang marl thwen-henh tjenkerr arlkwetjeh-anngernt. Artwang marl thwen-henh tjenkerr, ratherr anewartemeh inerretjenh, lakenh tjenkerr angerr arrken anyenetjenh. Jesu-kenh mwek Mary, inehel-ayeng ngwerrm anek. ");
INSERT INTO amx_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Jesu kwertengerl kwerenh map-akert mer kwerel anek-antim, tjenkerreh-artweyel inenh ngwek-arleng wart. ");
INSERT INTO amx_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Tjenkerr inang arlkwemarleng, wine inehenh ywerrek, tjerrtj inang ingkerrek antjwek-arleng wart. Jesu-henh mwekelemeh Jesu renh ilek, “Wine ingkerrek antjwerrerrekaw!” ");
INSERT INTO amx_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jesu-el renh tjernemel ilek, “Tjengan arltang nhenh itja anem, yeng rrkwapetjehan. Yeng arnterr pawenhetjal anay. Mpank arltang arrpenh-ingar yeng rrkwapetjenh mernelhetjehan, kelant inang yeng alhengk-aretjenheng.” ");
INSERT INTO amx_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Mary-el rrkwapenh-apenh map ilek, “Rang apek arrantherrenh twernemeng, arrantherr kel kwer kangkwerretjehant!” ");
INSERT INTO amx_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Tjerrtj Jew map kweteth iltjang inngerr-arlk lhewelhetjart, mpwareng-areng inehenh-angkwerr. Warl kwerel drum kwatj-kenh 6 irnek, nheng inarl tjerrtj lhewelhetjenheng. Drum nyentel kwatj 100 litres antwerrkem. Drum nhenh inang pwertengarl mpwarekarl. ");
INSERT INTO amx_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesu-el rrkwapenh-apenh inenh twernek, “Drum map-warn kwatj thelewarrang, angerr-ilemel kerneh-atwetj.” Kel inang drum inenh-warn kwatj angerr thelek. ");
INSERT INTO amx_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Kwereng rang inenh ilek, “Kwatj kwek tjampetel anweng-inemel, arrantherr nhenh twernk tjenkerreh-artwey-warn angerrerrang, rang arrkernetjeh.” Kel inang lakenh mpwarek, rang wart inenh twernekarl. ");
INSERT INTO amx_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Tjenkerrek-artwey rangemeh kwatj wine irrekarl renh arrkernemel antjwek. Rrkwapenh-apenh inang kaltj anek, wine renh drum kwatj-akerteng inekarl. Tjenkerrek-artwey rang nhenheh itjarl kaltj anek. Rang artwang arrkar inekarl kwer ntangkelhek. ");
INSERT INTO amx_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Rang renh ilek, “Nhenh-artek wine mwerr anthwerr, tjekert anetj-kweny! Tjerrtjel kwenh wine mwerr-lkwer-amparr antjwetjeh anthem! Kwereng wine mwerr inehenh ingkerrek antjwek-arleng, wine tjekert inang ingkern anthem. Wenhengam ntwang wine mwerr alengk-wek? Nhenh-artek wine mwerr anthwerr!” ");
INSERT INTO amx_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jesu-el twer angerr kwerenh rrkwapek, town kwek Cana-el mer Galilee-el. Lakenh rang twer angerr alker-areny anthwerr mernelhemel mpwarek tjerrtj mapeng ularr. Kwertengerl kwerenh mapel renh nakek-antem. ");
INSERT INTO amx_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Kwer-penh Jesu rang town Capernaum-warn peltj kwerenh mapel-ayeng alhek. Matj kwerenh, kenheng-nheng kwerenh kwertengerl kwerenh map inehel-ayeng angkep alpek. Inang Capernaum mer kwerel arltang rrpwetj war anek. ");
INSERT INTO amx_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Tjerrtj Jew map-henh irlpangkentjeh arltang rang angathemeh irrerl-apetjam. Irlpangkentj arreny kwerenh Anper Alhekarl anek. Inang irlpangketjart, Altjerrel arrwekeleny map angek mer Egypt-eng. Jesu rang arrwekel Jerusalem-warn alhek, tjenkerr renh kelant arlkwetjeh. ");
INSERT INTO amx_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Rang arentj-alpek, church angerr iterel yard-el pwelek yep-yep ntwerrert-arlk maneyeh sell-em-iletjart. Artwang arrpenh map maney angart-wenh-wenh table inehenhel anetjam. ");
INSERT INTO amx_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jesu-el whip mpwarek rope-penh. Kwereng rang artwang inenh yard-eng anhelemel anpwek, yep-yep inehenh-akert pwelek inehenh-akert. Artwang maney angart-wenh-wenh map-henh table rang angart-wemel taly-wek. Maney inehenh-arlk irrarnp-wek. ");
INSERT INTO amx_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Rang thep ntwerrerteh-artwey map inenh mwekeny-irremel ilek, “Thep ntwerrert nhenh map keth-warn angerrerrang! Arrantherr itja angey tjengenh-henh warl shop mpwaretjeh! Warl nhenh kwenh amek-amek, arrantherr ulpert-ilem!” ");
INSERT INTO amx_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Kwertengerl kwerenh mapemeh irlpangkek Altjerr-henh angketj nhengeh pipel-ayeng interleh, “Altjerray, yeng warl ngkwengenheng mwekenh-irrem!” ");
INSERT INTO amx_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Tjerrtj Jew twernk mapel Jesu renh pawenhek, “Wenheng ntwang lakenh mpwarek? Twer ngkwengenh mernay, nwern kaltj anetjenheng, Altjerrel ngwenh arrernek, lakenh mpwaretjeh?” ");
INSERT INTO amx_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesu-el inenh ilek, “Warl nhenh takewarrang, kwereng thang renh arltang atherr-penhel weth artetjenh.” ");
INSERT INTO amx_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Tjerrtj Jew twernk inang renh ilek, “Inang warl angerretj nhenheh 46 years-ek-atwetj rrkwapek, renh artetjeh. Kenh ntwang renh arltang atherr-penhel artetjeh angkemarl kwel! Itjeng alhay!” ");
INSERT INTO amx_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jesu rang warl arrpenh-penharl angkek, nheng mpwerrk kwerenh-penh angkek. Inang pal-pal war angkek church angerr-penh. ");
INSERT INTO amx_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Kelant Altjerrel renh irrernngeng kemelh-ilek, kwertengerl kwerenh map angketj kwerenheh irlpangkek. Kwereng inang Altjerr-henh angketj nakek, Jesu-henh angketj thwen nakek. ");
INSERT INTO amx_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","24","Jesu rang tjerrtj mapel-ayeng Jerusalem-el anetjam-rlwer irlpangkentj Anper Alhekarleh, rang twer angerr kwerenh mernelhek. Tjerrtj mapel renh nakek twer kwerenheh. Jesu-el alhengk-arek iterrentj inehenh, inang renh lakenhant war nakek, itja arratj nakek, kwek war. Lakenheng rang ineh tjweker-irrek. ");
INSERT INTO amx_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Jesu rang tjerrtj ingkerrekeh kaltj anek, iterrentj inehenheh-arlk. ");
INSERT INTO amx_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Tjerrtj Jew twernk nyent anek, arreny kwerenh Nicodemus. Rang Pharisee anek. ");
INSERT INTO amx_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Rang Jesu-warn kwenyel petjek. Rang renh pawenhek, “Kaltj-anthenh-anthenhay, nwern-artek kaltj, Altjerrelant kwenh tjerrtj twer-ilem, twer kwerenh-akertel rrkwapetjeh, ntwang kwenh lakenh rrkwapekarl-arteh. Nwern kwenh kaltj, nwern ngwenh arek Altjerr-henh twer-akertel rrkwaperleh. Lakenheng nwern kaltj, ngwenh Altjerrel nwerneh-warn lanthekarl, nwernenh kaltj-anthetjeh.” ");
INSERT INTO amx_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesu-el Nicodemus renh ilek, “Arratj anthwerray, tjerrtj apek ahentj-anemeng, Altjerr-henh peltj anetjeh, rang weth ngwerrm-irretjeh-amparr. Kwereng rang Altjerr-henh peltj anetjenh kwer kwek-arteh anetjenh. Tjerrtj apek itja Kwerrernel-ayeng ngwerrm-irrek-arleng, rang itja kwet Altjerr-henh peltj anem.” ");
INSERT INTO amx_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nicodemus-el renh ilek, “Nthakenhameh tjerrtj rang weth ngwerrm-irretjenh? Tjerrtj kwenh kel mangkekarl anem, inang itja weth kwer kwek anetjenh.” ");
INSERT INTO amx_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Kenh Jesu-el renh ilek, “Arratj anthwerray, tjerrtj kwenh ngwerrm-irrem kwatjel-arleng Kwerrern Alngaltarel-arleng thwen. Kwerengant rang Altjerr-henh peltj anem, Altjerr twernk angerr kwer anem. Itjeng apek itja kwetarl. ");
INSERT INTO amx_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Iterl-arang! Tjerrtj angey mwekeng ngwerrm-irremarl, inang tjerrtj ahelh nhenh-areny war anem. Kenh tjerrtj ngwenh apek inang Kwerrern Alngaltarel-arleng ngwerrm-irrem, inang Altjerreh peltj-irrem, inang kwerrern alker-areny inemel anetjenh. ");
INSERT INTO amx_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Thang ngwenh ilek-arleng, ntwang weth ngwerrm-irretjeh, lakenheng ntwang itja anwerlketjeh. ");
INSERT INTO amx_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Iterl-arang! Irlkel wernemarleng, ntwang arnangant angelherleh arem. Ntwang irlkang renh ywarn twernem, ‘Ingerreng petjang’, altwerleng apek. Lakenh-arteh tjerrtjel Altjerr-henh Kwerrern renh ywarn arem, Kwerrern rang tjerrtj ineh-warn irrpemeng.” Lakenh Jesu-el renh alngampelh-ilemel ilek. ");
INSERT INTO amx_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nicodemus-el renh weth pawenhek, “Nthakenham tjerrtj rang weth ngwerrm-irretjenh?” ");
INSERT INTO amx_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesu-el renh ilek, “Ntwang nhenhek akwen key? Ntwang kwenh tjerrtj Israel-areny mapeh inangkal angerr anemeng-artany? ");
INSERT INTO amx_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Mantj awerrerrang. Nwern kaltj wart anem, lakenheng wart arrantherrenh ilem, kaltj-irrekarl arrwekel kwet arentjekarl-penh, arratj anthwerr. Wenhengam arrantherr angketj nwern-henh itja nakem? ");
INSERT INTO amx_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Thang ngwenh angketj ahelh-areny-penh keth-ilemel ilek. Ntwang angketj tjengenh naketj-kwenyarl. Ntwang key alhengk-arem, tharl angketj alker-areny-penh ilem? Itja apek. ");
INSERT INTO amx_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Tjerrtj nyent itja Altjerr-henh merel anek apek, Tjerrtj-henh Ler rant. Rang alkereng ahelh-warn petjek. ");
INSERT INTO amx_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moses-el nheng amwang bronze kern arrernek, lakenh-arteh inang Tjerrtj-henh Ler renh arnang-arleh kern arrernetjenh. ");
INSERT INTO amx_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Tjerrtj ngwenhel apek Tjerrtj-henh Ler renh nakemeng, inang Altjerrel-ayel iteth ngampekarl anetjenh. ");
INSERT INTO amx_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Altjerr kwenh tjerrtj ahelh-areny mapeh nyerrkek, lakenheng rang Ler kwerenh nyent renh ahelh-warn lanthek. Kwereng tjerrtj ngwenhel apek Ler kwerenh nakemeng, inang itja kwetant ilwetjenh, inang Altjerrel-ayel iteth ngampekarl anetjenh. ");
INSERT INTO amx_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Altjerrel kwenh Ler kwerenh tjerrtj ahelh-areny map-warn lanthek, inenh anetjeng twepelh-iletjeh. Itja inenh atwetjenh. ");
INSERT INTO amx_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Tjerrtj ngwenhel apek Ler renh nakemeng, Altjerrel inenh itja alharlkwetjenh. Kenh tjerrtj ngwenhel apek Ler renh itja nakemeng, Altjerrel inenh kel alharlkwetjenh kwetant, inang Altjerr-henh Ler nyent itja nakek-arleng. ");
INSERT INTO amx_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","“Altjerr-henh Parrtj rang tjerrtj ahelh-areny map-warn petjek. Tjerrtj inang Parrtj nhenhek ahentj-kweny anek. Tjerrtj inang ahentj-anek anetj kwet mpwaretjek, inarrp anetj-akert. ");
INSERT INTO amx_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Tjerrtj inang anetj kwet mpwarem, inang kwenh Altjerr-henh Parrtjeh ahentj-kweny. Inang Parrtj nhenhek itja nyerrkem, Parrtjel keth-ilemeng anetj inehenh. ");
INSERT INTO amx_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Tjerrtj inang arratj mpwarem, inang Altjerr-henh Parrtjek nyerrkem, inenh parrtjelh-iletjeh, tjerrtjel keth aretjeh, inang Altjerreng ularr tjerrtj arratj anemeng.” ");
INSERT INTO amx_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Kel arltang arrpenhelemeh Jesu rang kwertengerl kwerenh map-akert mer Judea-warn alhek. Jesu mer kwerel kwet antarl-irretj-alpek kwertengerl kwerenh map-akert. Inang tjerrtj map kwatj-warn irrpelh-ilemel baptise-em-iletjam. ");
INSERT INTO amx_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","24","King Herod-el itja-antey John renh tjayel-warn kwernek, mpank-amparr. Tjerrtj map John-warn petjetjart mer Aenon-warn, rang inenh kwatjeh irrpelh-ilemel baptise-em-iletjeh. Mer Aenon mer Salim-eng rtwang war, kwatj rew-akert. ");
INSERT INTO amx_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","John-kenh kwertengerl map artwang mer-arenyel-ayeng thwen ilterretjam Moses-henh mpwareng-areng lhewelhentj-penh. ");
INSERT INTO amx_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Inang John-warn alhemel renh ilek, “Kaltj-anthenh-anthenhay! Ntwang artwang nheng iterl-aremam, rang nheng ngkwengel-ayeng anekarl, mer nheng Jordan ulpayel? Ntwang artwang kwer-akert tjerrtj map iletjam, rang artwang mwerr anem, Altjerrengarl petjek. Rang kwenh tjerrtj map lyet kwatj-warn irrpelh-ilemel baptise-em-ilem! Tjerrtj aningk kwer-warn alhem!” ");
INSERT INTO amx_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","John-el inenh ilek, “Tjerrtj aningk inang kwer-warn alhem, Altjerrel inenh lanthemeng wart kwer-warn. ");
INSERT INTO amx_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Arrantherr kel kaltj, yeng nheng arrehantherr ilelhek, ‘Yeng itja Christ rang anem, Altjerrel ngkwey alhelekarl. Yeng tjerrtj war anem ahelh-areny, Altjerrel yeng Christ-eng arrwekel lanthekarl.’ ");
INSERT INTO amx_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Thang arrantherrenh ilem angketj anthetj-penh. Artwang anthetj renharl rtwaltj kwerenhel marl alhelentj kwerenh anthem, artwang rant kwenh anew renh inem. Itja tjey kwerenhel apek. Tjey kwerenh kel nyerrkemantarl, rang aremeng artwang rang anewek inemeng. Jesu rang artwang anthetj rarteh anem. Lakenh-arteh yeng Jesu-eh nyerrkem, peltj tjengenheh. ");
INSERT INTO amx_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Tjerrtj mapel kwenh Jesu renh angerr-lkwer naketjehant, rang kwenh twernk angerr mpwareng-arengeh anem. Rang tjengeng arrwekel inangkal-lkwer anem.” ");
INSERT INTO amx_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","John-el weth kaltj-anthek, “Tjerrtj rang alkereng petjem, rang kel tjerrtj ingkerrekeh Ngkart anetjenh. Tjerrtj renharl Altjerrel ahelheng mpwarek, rang ahelh-areny war anem. Rang mern-penhant rnwanentj-penhant thwen iterrem. Tjerrtj rang alkereng petjem ahelh-warn, rang Ngkart anem tjerrtj ingkerrekeh. ");
INSERT INTO amx_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Tjerrtj rang alkereng petjem, rang Altjerrek kaltj. Rang tjerrtj map Altjerr-akert kaltj-anthem. Tjerrtj mapel angketj kwerenh itja nakek. ");
INSERT INTO amx_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Tjerrtj ngwenhel apek angketj kwerenh nakemeng, lakenh inang mernemel ilem, ‘Altjerr rang arratj anem.’ ");
INSERT INTO amx_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Tjerrtj renh Altjerrel lanthekarl, rang tjerrtj mapeh Altjerr-henh angketj ilem, Altjerr-henh Kwerrernel renh twer-ilem. ");
INSERT INTO amx_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Angey rang kwenh Ler kwerenhek nyerrkem. Rang Ler renh ngkernek, tjerrtj ahelh-arenyek alker-arenyek thwen Ngkart anetjek. ");
INSERT INTO amx_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Tjerrtj ngwenhel apek Ler kwerenh nakem, inang iteth ngampekarl anetjenh. Kenh tjerrtj ngwenhel apek Ler renh naketj-kweny itja, inang itjarl iteth ngampekarl anetjenh. Altjerrel kwenh inenh lanthetjenh rwang ngampekarl kwer-warn kwetanteh.” ");
INSERT INTO amx_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Artwang Pharisee mapel awek, tjerrtj aningkarl Jesu-warn petjek kwel, rang inenh kwatj-warn irrpelh-ilemel baptise-em-ilek, inang kwerenh nakenh-nakenhemeh irrek. Jesu-el aningk inenh baptise-em-ilek, John-el rrpwetj war baptise-em-iletjam arrwekel. Jesu rarrp itja tjerrtj map baptise-em-ilek. Kwertengerl kwerenh mapelarlam tjerrtj inenh baptise-em-iletjaman. Jesu rang awek, artwang Pharisee mapel yey nhenh-akert awekarl. Lakenheng rang mer Judea-eng tjeyel angkep alhep-alhetjam mer Galilee-warn, ayerrer-atheh. ");
INSERT INTO amx_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Jesu rang mer Samaria-angkwerr anper alhek mer Galilee-warn. ");
INSERT INTO amx_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Rang town nyent-angkwerr anper alhek, arreny kwerenh Sychar, mer Samaria-el. Mer Sychar kwereng rtwang war farm nyent anek. Farm nhenhan arrwekeleny Jacob-el ler kwerenheh Joseph-eh ngkwey anthekarl. ");
INSERT INTO amx_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","8","Jacob-henh kwatj angentj mer kwerel anek, rang ngkwey angernekarl-penh. Jesu kwatj angentj kwerel arrernelhetj-alhek. Rang pwarrk awelhek, mer ntwarreng petjekarl-penh. Kwertengerl kwerenh map anper alhek town-warn, mern inetjeh. Kel aherrk mpwepel, Jesu ingareny kwatj angentj kwerel antarl-irrek. Marl Samaria-areny nyent petjek kwatj angentj kwer-warn, kwatj inetjeh. Jesu-emeh kwer kwatjeh nkek, “Yeng angketh-irrek, tjeng arwekel antjwetjeh anthang.” ");
INSERT INTO amx_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Marl rang renh ilek, “Ntwang kwenh tjerrtj Jew, kenh yeng marl Samaria-arenyarl. Nthakenharl ntwang tjeng kwatjeh nkem? Nwern unpartek-unpart anem Judea-areny mapek, peltj-kweny!” ");
INSERT INTO amx_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesu-el renh ilek, “Ntwang itja kaltj anem, Altjerr rang ngkweng nyerrkentj mernelhetjeh ahentj-anem. Itja ntwang kaltj-kwenh tjeng. Ntwang apek tjeng kaltj anek-arleng, tjeng-atwetj kwatjeh nketjeh, thangant ngwenh kwatj iteth-henh renh anthehetjan.” ");
INSERT INTO amx_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Marlelemeh tjernek, “Rnwang ngkwengenh itja anem, ntwang kwatj arwek-inemel antjwetjeh. Kwatj angentj nhenhan kwen anthwerr. Nthenhengam ntwang kwatj iteth renh inetjenh? ");
INSERT INTO amx_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Ntwang arrwekeleny angerrepat nwern-henh nheng Jacob-eh kaltj key? Jacob rang kwenh kwatj angentj nhenh nwerneh angernemel arrernerl-alhek. Ngkwey ler kwerenh map inang kwatj angentj nhenheng antjwetjart, yep-yep-arlk kwerenh mapel thwen. Nthakenharlam ntwang Jacob-eng inangkal-lkwer?” ");
INSERT INTO amx_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesu-el renh ilek, “Tjerrtj ngwenhel apek kwatj angentj nhenh-penh antjwemeng, inang weth angketh-irretjenh. ");
INSERT INTO amx_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Tjerrtj ngwenhel apek kwatj arrpenheng antjwemeng, tharl inenh anthetjenh, inang itja weth angketh-irretjenh. Kwatj nhak-penh inang apek antjwetjenharl, yanh kwenh kwatj rew-arteh thelelhetjenh kwetant. Kwatj nhenh itja ywerretjenh. Tjerrtj ngwenhel apek kwatj nhenh antjwem, inang iteth ngampekarl anetjenh.” ");
INSERT INTO amx_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Marl rang renh ilek, “Tjerrtjay, tjeng kwatj renh anthay, yeng weth angkethel irretj-kweny! Yeng itja weth kweteth nhenh-warn petjerl-anetjenheng kwatjeh.” ");
INSERT INTO amx_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesu-el renh ilek, “Artwang anew ngkwengenh ngwerl-alpang. Kwer-akert tjeng-warn petj-alpang.” ");
INSERT INTO amx_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Marl rang ilelhek, “Yengan anew-kweny anem.” Jesu-el renh ilek, “Ntwang arratj angkek. ");
INSERT INTO amx_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ntwang kel anew 5 arrwekel anyenekarl. Artwang alenh rang ngkwengel-ayeng lyet anem, rang meyt-meyt war ngkweng anem. Lakenh ntwang arratj kwet ilelhek, ntwang anew-kweny anemeng.” ");
INSERT INTO amx_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Marl rang renh ilek, “Twernkay! Yeng kel kaltjemeh, ntwang Altjerr-henh angketj angenh-angenh anemeng. ");
INSERT INTO amx_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Arrwekeleny map inang Altjerreh arraw-irretjart irntang nhenhel arreny Gerizim-el kwel, Altjerr kwer amperel-ayeng arrernelhetjeh. Kenh tjerrtj Jew arrantherr ilem, mer Jerusalem-warnant kwel tjerrtj arraw-irretjeh, kwer amperel-ayeng arrernelhetjenheng. Nthenham rang Ngkart-henh irntang anganentj, nwern kwer arratj arraw-irretjeh? Irntang nhenh apek? Irntang Jerusalem apek? Nthenham arratjan?” ");
INSERT INTO amx_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesu-el renh ilek, “Marlay, yeng away. Kelant tjerrtj itja Angeyeh arraw-irretjenh irntang nhenhelant, itja Jerusalem-el apek, amperel-ayeng arrernelhetjeh. ");
INSERT INTO amx_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Samaria-areny arrantherr-artek Altjerr nakem, kenh arrantherr renh itja arratj alhengk-arem. Tjerrtj Jew nwern-atwetj Altjerr kwer kaltj anem, renh arratj nakem. Arrwekel-antey Altjerrel nwernehant angketj mwerr kwerenh anthek, nwern angketj renh ilerl-apetjeh ahelh ntjaperel. ");
INSERT INTO amx_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Lyetan Kwerrern Alngaltarel tjerrtj kwerenh inenh kaltj-anthemel twer-ilem, inang arratj iterl-aremel Angey renh naketjeh. Tjerrtj lakenh-lkwereh kwenh Angeyan ahentj-anem. ");
INSERT INTO amx_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Altjerr rang Kwerrern anem. Tjerrtj nakenh-nakenh inang kwerrern inehenh Altjerr kwer anthelhetjeh, renh arratj iterl-aremel naketjeh, Kwerrern Alngaltarel inenh kaltj-anthemel twer-ilemeng wart.” ");
INSERT INTO amx_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Marl rang renh ilek, “Yeng kaltj, Messiah rang petjetjenharl, renhant nwern Christ anewem, Altjerrel nwernenh alhelekarl-penh ngkwey. Rang nwernenh angketj Altjerr-akert arratj kaltj-anthetjenh.” ");
INSERT INTO amx_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesu-arl kwewaleny ilelhek, “Yeng kwenh ngkweng ilelhem, yeng kwenh rang.” ");
INSERT INTO amx_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jesu rang marl kwer-warn angketjam-rlwer, kwertengerl kwerenh map mern-akert petj-alpek. Inang aretj-alpemel anwerlkek, rang marl Samaria-arenyel-ayeng angkemeng. Inang iterrek, Jesu renh pawenhetjeh, kenh inang itja renh pawenhek. Inang intert kwet arrernelhetj-alpek. ");
INSERT INTO amx_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Marl rang rnwang kwerenh imperl-alhemel town-warn urrpey alhek. Rangemeh Sychar mer-areny map iletj-alhek, ");
INSERT INTO amx_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Aray, artwang nyent aretjeh petjewarrangaw! Rang tjeng kaltj kwel! Rang yeng ilek anew tjengenh map-akert. Artwang nhak rang apek Christ rang, Altjerrel ngkwey alhelekarl?” ");
INSERT INTO amx_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Kel tjerrtj aningk inang town-eng Jesu-warn alherrerrek. ");
INSERT INTO amx_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Tjerrtj town-areny tjeyel petjetjam-rlwer, kwertengerl mapel Jesu renh ilek, “Kaltj-anthenh-anthenhay, mern arlkway!” ");
INSERT INTO amx_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Rang inenh ilek, “Tjeng mern intem, kwer arrantherr itja kaltj.” ");
INSERT INTO amx_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Kwertengerl mapel inarrpemeh pawenherrerrek, “Arrpenhel key renh mern anthek, arlkwetjeh?” ");
INSERT INTO amx_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesu-el inenh ilek, “Angey tjengenh ahentj-anem, thang tjerrtj map anetjeng twepelh-iletjeh. Nhenh rang rrkwapentj tjengenh anem. Rang wart yengenh lanthek, rrkwapentj nhenh mpwaremel mangk-iletjeh. Rrkwapentj nhenh kel tjeng mern-arteh anem, tjeperr. ");
INSERT INTO amx_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Thang arrantherrenh ilem angketj kwenameny-penh Altjerr-henh farm-akert. Nheng arrantherr mern anngang aherneh kwernem, anngang kwer-penh mernemeh mangkem. Arrantherr angkem apek, ‘Mpankaw! Kel nwern 4 months-eh-atwetj karelhem, kwereng nwern mern renh ampengemeh kwetjetjenh.’ Nhenh awerrerrang, tjerrtj ingkerrek mern-arteh anem Altjerr-henh farm-el. Altjerr-henh farm renh arerrerrang! Mern ingkerrek kel ampeng anem, arrantherr kel kwetjetjeh. ");
INSERT INTO amx_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Lyet tjerrtj aningkel mer apanpel mern kwetjem Altjerr-henh farm-el. Nhenh-atwetj inang tjerrtj inenh arraw-ilem, Altjerr kwerel-ayeng inang iteth ngampekarl anetjeh-anngernt. Altjerrel rrkwapenh-apenh inenh kwart-wetjeh. Lakenheng rrkwapenh-apenh ngwenhel apek mern anngang inenh aherneh kwernekarl, rrkwapenh-apenh arrpenh inang mern inenh kwetjetjehemeh, inang ingkerrek nyent-irremel arrken anetjenh. ");
INSERT INTO amx_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Angketj nhenh kwenh arratj anem, ‘Artwang mapel mern anngang aherneh kwernem. Artwang arrpenh mapel mern anngang kwetjem.’ ");
INSERT INTO amx_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Thang arrantherrenh Altjerr-henh farm-warn lanthem, mern kwetjetjeh. Arrantherr kwerel itja arrwekel rrkwapek. Arrpenh map kwenh arrwekel rrkwapek. Arrantherremeh rrkwapentj inehenh-penh mern kwetjetjehan.” Lakenh Jesu-el tjerrtj map-akert ilek iter-angkwerr mern-akert-arrpantey. ");
INSERT INTO amx_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Town kwerel Samaria-areny mapel marl nheng-henh angketj nakek, nheng rang ilelhekarl-penh, “Rang-atwetj tjeng kaltj anem. Rang yeng anew tjengenh map-akert ilek.” Lakenheng tjerrtj Samaria-areny mapel Jesu renh nakekemeh. ");
INSERT INTO amx_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kel inang Jesu-warn petjekarl-penh, inang renh ayakek, inehel-ayeng antarl-irretjeh. Jesu-an inehel-ayeng arltang atherr antarl-irrek. ");
INSERT INTO amx_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Tjerrtj Samaria-areny mapel Jesu-henh angketj awek, inang renh kwetemeh nakek. ");
INSERT INTO amx_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Inang marl renh ilek, “Nwern angketj ngkwengenh-amparr awek, nwern ngwenh kwek war nakek. Lyet nwernarrp renh angkerleh awekarl, lwerenheng nwern renh arratj-lkweremeh naketjenh. Nwern kel kaltj, tjerrtj ahelh-areny mapeh rang tjeperr anthwerr anem. Rang petjek, tjerrtj map twepelh-iletjeh ahelh apanpel.” ");
INSERT INTO amx_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jesu rang arltang atherr-ingar tjerrtj Samaria-areny mapel-ayel anekarl-penh, rang mer Galilee-warn alpek. ");
INSERT INTO amx_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesu-el arrpenh-areng kel tjerrtj inenh ilek, “Tjerrtj mer arrpenh-areny mapelant Altjerr-henh angketj angenh-angenh nakem. Kenh mer-areny mapel renh itja kwetarl renh nakem.” ");
INSERT INTO amx_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Jesu rang mer Galilee-warn alpek, mer-areny mapel renh arnekarner kwer kangkek. Inang arrwekel-antey Jerusalem-warn alhek, irlpangkentj tjenkerr nheng arlkwetjeh-anngernt. Irlpangkentj arreny kwerenh Anper Alhekarl anek. Kwerel-antem inang Jesu renh alhengk-arek, rang twer angerr rrkwapekarl. Lakenh inang kwer kangkek. ");
INSERT INTO amx_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jesu rang weth town Cana-warn alpek, town nhenhel rang nheng kwatj angart-wekarl wine-warn. Twernk nyent Capernaum town-el anek, ler kwerenh irlkert-akert. Artwang rang anek rrkwapenh-apenh King Herod-ek. ");
INSERT INTO amx_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Artwang nhenh rang awek, Jesu rang mer Judea-eng petjekarl. Rang kwer-warn alhemel nkek, “Tjengel-ayeng petjang, ler tjengenh mwerr-iletjeh! Rang ilwetjeh-irrem!” ");
INSERT INTO amx_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesu-el renh ilek, “Arrantherr kwenh yengenh nakem, arrantherr twer tjengenh aremelant war!” ");
INSERT INTO amx_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Rang renh ilek, “Ngkartay! Kel petjang! Ler tjengenh ilwehetjeng!” ");
INSERT INTO amx_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesu-el renh ilek, “Kel alpay! Ler ngkwengenh kel mwerr-irrek.” Artwang rang Jesu-henh angketj nakek, mer kwerenh-warn rang alpek. ");
INSERT INTO amx_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Rang tjeyel alhep-alhetjamarl, artwang rrkwapenh-apenh rrpwetj kwer-warn arnekarner petjek. Inang renh ilek, ler kwerenh mwerr-irrekarl. ");
INSERT INTO amx_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Rang inenh pawenhek, “Ilwengar anthwerram rang mwerr-irrek?” Inang renh ilek, angwerreh angwerrel rang mwerr-irrek. ");
INSERT INTO amx_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Artwang rang irlpangkemel ilelhek, “Ay! Arltang kwerel rang yeng ilekarl, ‘Ler ngkwengenh kel mwerr-irrekaw!’ ” Artwang rangemeh peltj kwerenh map-arlk rrkwapenh-apenh kwerenh map-arlk inang kel nakenh-nakenhemeh irrek Jesu-kenhan. ");
INSERT INTO amx_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Nwern angkep-atheh arem. Arrwekel Jesu rang mer Judea-eng Galilee-warn alpek. Twer anthwerr kwerenh rang mer Galilee-el-amparr mernek, nheng kwatj-penh wine-warnemeh angart-wek mer Cana-el. Kwer-penh rang kwer nyentemeh mwerr-ilek, mer nyent kwerelan. Lakenh rang kwewaleny mernelhek, nthakenh rang twer angerr kwerenh-akertel mpwarek. ");
INSERT INTO amx_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kel arltang arrpenhelant Jesu rang Jerusalem-warn alhek, tjenkerr arlkwetjeh. Aretharr-rlwer tjerrtj Jew mapel tjenkerr nhenh arlkwetjart. ");
INSERT INTO amx_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalem-el arrew arrpenh anek, kwerengarl inang yep-yep map town-warn irrpelh-iletjart. Arrew nhenhel kwereng kwet kwatj anek, tjerrtjel mpwarekarl. Hebrew-henh angketjel inang kwatj renh arreny Bethesda iletjart. Kwatj kwereng kernel lywang angerretj 5 artelhek. ");
INSERT INTO amx_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Lywang 5 nhenhel tjerrtj irlkert map anthwerr intetjart, pweng map-arlk rnwerr map-arlk inang intetjart. ");
INSERT INTO amx_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Artwang nyent ahenp 38 years-ek-atwetj irlkert kwet anetjart. ");
INSERT INTO amx_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesu-el renh intemeng arek. Rang alhengk-arek, artwang rang kwet anthwerr irlkert intekarl. Jesu-el renh pawenhek, “Ntwang apek mwerr-irretjeh ahentj-irrem?” ");
INSERT INTO amx_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Artwang irlkert rang renh ilek, “Twernkay! Kwatj rang angelhem-arteh, tjeng itja peltj anem, yengenh kwatjeh kwernetjeh. Yeng-amparr kwatjeh irrpetjeh, tjerrtj arrpenh kweteth tjengeng arrwekel irrpem. Yeng ahentj, yeng-amparr irrpetjeh. Kenh tjerrtj arrpenh ramparr irrpem. Nthakenham yeng mwerr-irretjenh?” ");
INSERT INTO amx_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jesu-el renh twernek, “Kemerrang! Antjam ngkwengenh inemel kel kemerremel alhang!” ");
INSERT INTO amx_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Jesu rang angketjamarleng-antey, artwang kel mwerr-irrek. Rang kel antjam kwerenh inemel nthwerl-apetjam. Arltang kwerel-ayel Jesu-el artwang renh mwerr-ilekarl, rartek Saturday arltang angerr anek. ");
INSERT INTO amx_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Tjerrtj Jew twernk mapel artwang mwerr-irrekarl renh arek. Lakenheng inang renh ilek, “Lyet kwenh Saturday arltang angerr anem! Nhenh kwenh itja arratj anem, ntwang antjam angerl-apetjeh! Mpwareng-areng nwern-henh intem, ‘Arrantherr itja arltang angerr Saturday-el rrkwapetjeh.’ ” ");
INSERT INTO amx_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Artwang rang inenh ilek, “Artwang rarl yeng mwerr-ilekarl, rartek lakenh yengenh twernek, ‘Antjam ngkwengenh inemel, kemerremel alhang!’ ” ");
INSERT INTO amx_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Inang renh pawenhek, “Artwang ngwenham rang? Nthenh-areny rang, rarl ngwenh twernekarl, antjam ngkwengenh inemel alhang?” ");
INSERT INTO amx_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Artwang mwerr-irrekarl rang itja kaltj anek Jesu-eh. Jesu rartek ywerrerl-alhek tjerrtj aningk map-angkwerr. ");
INSERT INTO amx_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kelant Jesu-el artwang mwerr-irrekarl renh church angerretjeharl aretj-alhek. Rang renh ilek, “Ntwang kel mwerram anem. Lyeteng ntwang itja weth anetj mernelhang! Irlkert angerr anthwerrel ngwenh atwehetjeng!” ");
INSERT INTO amx_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Artwang rang tjerrtj Jew twernk map-warn iletj-alhek, “Jesu-el kwenh yeng mwerr-ilek!” ");
INSERT INTO amx_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Jesu artwang arltang angerr Saturday-el mwerr-ilemeng, lakenheng tjerrtj Jew twernk map Jesu-eh rrwernek, inang Jesu renh irrernng atwetjeh ahentj-anek. ");
INSERT INTO amx_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jesu-el inenh ilek, “Angey tjengenh kweteth rrkwapem, rang lyet rrkwapem. Lakenheng yeng rrkwapem angey tjengenh-arteh.” ");
INSERT INTO amx_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Tjerrtj Jew twernk map inangemeh ahentj anthwerr anek, Jesu renh irrernng atwetjeh. Wenheng? Rang Saturday arltel rrkwapekarl, mpwareng-areng inehenheh rang itja kangkwerrek. Rang angkek-arleng, Altjerr angey kwerenh anemeng, rang Altjerrel-ayel nyent kwet anemeng. ");
INSERT INTO amx_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jesu-el inenh ilek, “Mantjel awerrerrang. Ler rang itja nyent rrkwapem. Ler rang angey kwerenh rrkwapemeng arem, kwereng rang lakenharlam rrkwapem. Nheng Angey rang rrkwapem-arteh, lakenh Ler rang rrkwapem. ");
INSERT INTO amx_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Angey rang kwenh Ler kwerenheh nyerrkem. Lakenheng rang Ler kwerenheh rrkwapentj kwerenh ingkerrek mernem. Angey rang Ler kwerenheh rrkwapentj angerr anthwerr mernetjenh, arrantherr anwerlketjenh. ");
INSERT INTO amx_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Angeyel tjerrtj irrernng map kemelh-ilemel iteth-ilem. Lakenh-arteh Ler rang tjerrtj inenh iteth-ilem, rang ahentj-anemeng wart. ");
INSERT INTO amx_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Angey rang ahentj-anem, tjerrtj ingkerrekel Ler kwerenh naketjeh kwel, inang Angey renh nakemarl-arteh. Lakenhan rang Ler kwerenheh impek, tjerrtj inenh judge-em-iletjeh. Angey rang tjerrtj inenh itja weth judge-em-ilem. Angey rang kwenh Ler renh ahelh-warn lanthek. Lakenheng tjerrtj inang Ler renh naketjeh. Itjengan, renh naketj-kwenh lakenhan inang Angey renh naketj-kwenyarlam. ");
INSERT INTO amx_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Arratj anthwerr, tjerrtj ngwenhel apek angketj tjengenh awem, inang apek Angey nakem, rang yeng lanthekarl, Angey tjengenhel inenh itja atwetjenh. Tjerrtj inang kwetant iteth anetjenh. ");
INSERT INTO amx_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Arratj anthwerr, ngwenth-lkwer tjerrtj irrernng mapel Altjerr-henh Ler-henh angketj awetjenh. Tjerrtj ngwenh apek angketj nhenheh kangkwerrem, inang kel kemerremel kwetant iteth anetjenh. ");
INSERT INTO amx_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Angey ilernakehan anganentj anem. Angey rang tjerrtj inenh Iteth-ilenh-ilenh. Angey rang Ler kwerenh twer-ilek, Ler rang tjerrtj inenh Iteth-ilenh-ilenharlam kwet. ");
INSERT INTO amx_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Rang Tjerrtj-henh Ler anemarleng, lakenheng Angey rang Ler kwerenh ngkernek, tjerrtj ingkerrek ahelh apanpel judge-em-ilemel pawenhetjenh. ");
INSERT INTO amx_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Arrantherr itja anwerlketjeh. Kelant tjerrtj irrernng intemarl mapel Ler renh awetjenh, rang inenh ngwemarleng. ");
INSERT INTO amx_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Inang awenng inehenheng twep-welhetjenh. Tjerrtj ngwenhel apek arratj mernelhekarl ahelh nhenhel inang iteth-amparr anekarl, inang kwetant iteth anetjenh. Kenh tjerrtj arrpenh inang ahelh nhenhel iteth-amparr anekarl inang anetj mernelhekarl, inenh Jesu-el alharlkwetjenh kwetant mer kwerenheng. ");
INSERT INTO amx_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Yeng itja nyent rrkwapem. Angey tjengenhel yengenh ahelh-warn lanthek, rang tjengel-ayel rrkwapem. Ilernak pwert rrkwapem. Lakenheng thang tjerrtj map arratj judge-em-iletjenh, rang yeng twernem. Yeng itja iterrentj tjengenh-akert rrkwapem, yeng Angey tjengenhehant war kangkwerrem.” ");
INSERT INTO amx_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Thant apek arrantherrenh ilemeng, yeng Altjerr-henh Ler anem wart, arrantherr itja yengenh naketjeh. ");
INSERT INTO amx_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Angey tjengenhel arrantherrenh ilemeng, yeng Jesu Ler kwerenh anem wart, arrantherr angketj kwerenh naketjeharlam. Yeng kaltj, angketj kwerenh arratj wart. ");
INSERT INTO amx_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Arrantherr nheng John-warn urrpey rrpwetj lanthek. John rang urrpey inenh angketj arratj ilek tjeng-akert. ");
INSERT INTO amx_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Yeng itja arnaratj John-henh angketjeh, rang tjerrtj war anem wart. Thang arrantherrenh John-henh angketj-akert war irlpangkelh-ilem, arrantherr yengenh naketjenheng, Altjerrel arrantherrenh twepelh-iletjenheng. ");
INSERT INTO amx_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Altjerrel nheng John ngkernek, rwang alngenth-arteh amperl-anetjeh, tjerrtj map parrtjelh-iletjeh. Arrantherr kangkek, angketj kwerenh awerl-anetjeh. ");
INSERT INTO amx_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“John rang arratj angkek tjeng-akert. Rang tjerrtj war. Angeyel yengenh lanthek, twer angerretjel rrkwapemel mpwaretjeh. Lakenh thang mpwarerleh, arrantherr iterl-aretjeh, Angeyel yengenh lanthekarl. ");
INSERT INTO amx_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Angey rang yengenh lanthek, rang angketj tjeng-akert ilekarl. Arrantherr Angey itja awek. Arrantherr renh itja arek. ");
INSERT INTO amx_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Rang yengenh arrehantherr-warn lanthek, arrantherr kenh yengenh itjarl nakek. Lakenheng angketj kwerenh itja arrehantherrel-ayeng antarl-irrem. Arrantherr angketj kwerenh itja nakek. ");
INSERT INTO amx_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Arrantherr Altjerr-henh angketj pipel-ayeng irlpareth kaltj-irrem. Arrantherr iterrem, angketj inang arrantherrenh kwel kwetant iteth-iletjenh. Angketj nhenhel-ayeng arrantherr tjeng-akert read-irrem. ");
INSERT INTO amx_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Arrantherr itja ahentj-anem, tjeng-warn petjetjeh. Arrantherr itja ahentj-anem, thang arrantherrenh kwetant iteth-iletjeh. ");
INSERT INTO amx_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Yeng itja ahentj-anem, tjerrtjel yengenh lakenh nakemel iletjeh, ‘Tjerrtj mwerram ntwang!’ Nhenh tjerrtj-henh-angkwerr. ");
INSERT INTO amx_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Yeng arrehantherr kaltj, arrantherr itjam Altjerreh nyerrkem. ");
INSERT INTO amx_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yeng arrehantherr-warn petjek, Angey rarrp yengenh lanthekarl. Arrantherr yengenh itja peltj-ilek. Kenh tjerrtj arrpenh petjemel ilelhemeng, rang tjerrtj angerr anemeng kwel, arrantherr renh kel peltj-ilemantarl. ");
INSERT INTO amx_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Arrantherr Altjerr renh itja nakem. Arrantherr kwet ahentj-anemeng, tjerrtjel arrantherrenh naketjeh. Arrantherr itja Altjerreh kweteth iterrerl-anem, nthakenh rang iterrem arrehantherr. ");
INSERT INTO amx_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Arrantherr itja iterl-aretjeh, thang arrantherrenh Angeyeng ularr iltetjenh. Arrantherr kwenh Moses-henh mpwareng-areng-akert nakelhem. Mpwareng-areng nhenhel-ayeng Moses-el arrantherrenh Angeyeng ularr iltetjenh. ");
INSERT INTO amx_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moses rang angketj tjeng-akert pip-warn arrernekarl. Arrantherr apek renh nakek-arleng, arrantherr yengenh nakemer. ");
INSERT INTO amx_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Arrantherr Moses-henh angketj itja nakek. Nthakenham arrantherr angketj tjengenh naketjenh?” ");
INSERT INTO amx_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Kelant arltang arrpenh-ingar Jesu kwatj alayel boat-el arrwengak alhek, kwertengerl kwerenh map-akert. Kwatj alay arreny kwerenh Galilee anek. Kwatj alay nhenh renh inang arreny arrpenh Tiberias iletjart. ");
INSERT INTO amx_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Tjerrtj map inang twer angerr kwerenh arek-arleng, rang tjerrtj irlkert map mwerr-ilemeng, inang kwereng ingkern-angkwerr alhek. ");
INSERT INTO amx_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","4","Tjerrtj Jew mapel irlpangkentj anyenetjart, arreny kwerenh Anper Alhekarl. Inang tjenkerr arlkwetjart. Inang irlpangketjart, Altjerrel arrwekeleny map angek mer Egypt-eng. Irlpangkentjeh arltang angerr rang mpank-amparr anetjenh-anngernt. Jesu-emeh irntangeh antjek kwertengerl kwerenh map-akert. Inang arrernelhek. ");
INSERT INTO amx_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jesu-el arnarek, tjerrtj map aningk ularr petjerleh. Rang Philip renh pawenhek, “Nthenhengam nwern mern inemer, tjerrtj aningk lakenh wantetjeh?” ");
INSERT INTO amx_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Jesu-el-artek Philip renh arrkernemel war pawenhek, nthakenh rang angketjenh. Jesu rang kel kaltj anek, rang tjerrtj map wantetjenharl. ");
INSERT INTO amx_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Philip-el renh ilek, “Nwerneh maney kwek anthwerr! Nthakenham nwern tjerrtj aningk lakenheh mern payem-iletjenh?” ");
INSERT INTO amx_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Andrew, Simon Peter-henh tjey kwertengerl nyent anek. Rang angkek, ");
INSERT INTO amx_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Kwer rrwey nyent nhenhel anem. Rang mern 5 kwek anyenem, ker irrpenng atherr. Mern kwek lakenhel tjerrtj arwenth ywarn wantemel anhwerlk-ilem!” ");
INSERT INTO amx_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Arnam atherrk angerr anek mer kwerel. Jesu-el kwertengerl kwerenh map ilek, “Tjerrtj map arrernelhetjeh twernang.” Kel artwang 5,000-arteh aningk kwerel anek. ");
INSERT INTO amx_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesu-el mern inenh inek, Altjerr renh merneh pawenhek. Kwereng rang mern inenh kwertengerl mapeh anthek, irrarnpelh-iletjeh tjerrtj mapeh. Kwereng rang lakenh-arteh irrpenng renh-atherrenh inemel, Altjerr pawenhek. Kwereng rang ker irrpenng inenh kwertengerl mapeh anthek, irrarnpelh-iletjeh tjerrtj mapeh. ");
INSERT INTO amx_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Tjerrtj aningkel kel arlkwemel anhwerlk-irrekemeh. Jesu-el kwertengerl kwerenh mapemeh twernek, mern ngkweltj ingkerrek kwetjetjeh. ");
INSERT INTO amx_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Mern 5 ineheng kwertengerl inang panth 12-warn mern ngkweltj arlwelek. ");
INSERT INTO amx_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Lakenh Jesu-el twer angerr-akertel rrkwapek. Tjerrtj inang nhenh aremel, inang lakenh anwerlkemel angkek, “Nhenheh-apel Altjerr-henh angketj angenh-angenh tjeperr rang, renh Altjerrel ngkwey nwerneh alhelekarl, ahelh nhenh-warn lanthetjeh anekarl!” ");
INSERT INTO amx_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesu rang kaltj anek, inang iterremeng. Inang lakenh iterrek, “Nwern renh rrkwetjeh, renh ngkernetjeh, king nwerneh anetjeh!” Jesu rang ahentj-kweny-irrek, twernk angerr ineh anetjeh. Lakenheng rang irntang-warn anam-irrek, nyent-areny anetjeh. ");
INSERT INTO amx_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kel angwerr-angwerremeh irrek, Jesu-henh kwertengerl map kwatj alay iter-warn alhek. ");
INSERT INTO amx_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Jesu itja ineh-warn petjekarl. Inang boat-el antjemel, kwatj alayel arrwengak ntwarr-lkwer kwet kel alhetjam, Capernaum town-warn. ");
INSERT INTO amx_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Kweny mpwepel irlkang twerelemeh kwatj angelh-iletjeh mpwarek. Kwatj rang angerr-irrek. ");
INSERT INTO amx_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Kwertengerl inang kwatj mpwep-warn boat-el anenhetjam, kel 5 kilometres-artek alhetjam, arnangel push-em-ilerl-apetjam. Kel inang Jesu renh arek, kwatj kernel ingkang ineh-warn ularr petjerleh. Rang ineh-warn itwek-irremarleng, inang kwerrern-kweny-irrek ater-irremel. ");
INSERT INTO amx_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jesu rang ineh arlkemel ilelhek, “Yengeyay! Ater-irretjal anerrerrang!” ");
INSERT INTO amx_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Inang ahentj-anek, renh boat-eh antjelh-iletjeh. Boat rang parrp anthwerr kwatj iter itwek-irretj-alhek. ");
INSERT INTO amx_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Arltang arrpenhel tjerrtj inang kwatj alayeng ntwarr antarl-irrekarl, inang irlpangkek, boat nyent war arrwekel anekarl. Inang irlpangkek, Jesu rang itja kwertengerl kwerenh mapel-ayeng boat-eh antjekarl, kwatj alayeng boat-el alhetjeh. ");
INSERT INTO amx_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tjerrtj map boat rrpwetjeng Tiberias town-eng petjek, keth nheng Jesu-el Altjerr merneh pawenhekarl-penh-warn, Jesu-el tjerrtj map 5,000 wantekarl-warn. ");
INSERT INTO amx_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Tjerrtj arwenth inang ywarek, Jesu ywerremel alhekarl, kwertengerl kwerenh map-arlk. Inang boat inehenh-warn antjemel, kwatj alayel alhek Capernaum town-warn. Inang ahentj-anek, Jesu-eh palenthwetjeh. ");
INSERT INTO amx_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Inang boat-eng anarnpek, kwer palenthwek. Inang Jesu renh aremel pawenhek, “Kaltj-anthenh-anthenhay! Nthakenham ntwang nhenh-warn petjek?” ");
INSERT INTO amx_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesu-el inenh ilek, “Wenham arrantherr tjeng palenthwem? Arrantherr-artek yengenh naketj-kwenh, itja kwenh! Arratj anthwerr, arrantherr-arteh tjeng palenthwek, arrantherr mern arwenth arlkwek-arleng war anhwerlk-irrek-arleng wart. ");
INSERT INTO amx_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Arrantherr arltang arrpanenhel merneh palenthwem, angayelel. Arrantherr itja mern ahelh-arenyeh athek-irretjeh. Arrantherr kwenh mern kwer palenthwetjeh, nheng rang tjerrtj inenh kwetant iteth anyenem. Altjerr Angeyel Tjerrtj-henh Ler renh arrernek, rang arrantherrenh mern renh anthetjeh.” ");
INSERT INTO amx_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Inang renh pawenhek, “Nthakenham Altjerrel nwernenh twernem, nwern mernelhetjeh?” ");
INSERT INTO amx_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesu-el inenh ilek, “Altjerrel arrantherrenh twernem, arrantherr yengenh naketjeh, urrpey renh rang lanthekarl.” ");
INSERT INTO amx_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Inang pwer anemel renh pawenhek, “Wenham ntwang twer angerrel mpwaretjenh, nwern kaltj anetjenheng, ntwang arratj angkemeng? Nwernemeh ngwenh naketjenheng? ");
INSERT INTO amx_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Angerrepat nwern-henh mapel rrkwalel alhemeng, inang mern alkereng anyekarl arlkwetjart. Angketj lakenh Altjerr-henh pipel-ayeng intem, ‘Rang inenh mern alkereng anthek arlkwetjeh.’ ” ");
INSERT INTO amx_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jesu-el inenh ilek, “Arratj anthwerr, Moses-el itjam arrantherrenh mern alker-areny renh anthwerr anthek. Angey alker-areny tjengenhelant arrantherrenh mern alker-areny renh kwet anthem. ");
INSERT INTO amx_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Mern Altjerrelarl tjerrtj anthem, inenh iteth anyenetjenh. Mern nhenh rartek tjerrtj rang anem, nheng rang alkereng petjekarl.” ");
INSERT INTO amx_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Tjerrtj inang Jesu-ek nkek, “Mern nhenh renh nwerneh kweteth antherl-anay.” ");
INSERT INTO amx_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesu rang ilelhek, “Yeng kwenh mern rang anem, rang tjerrtj inenh kwetant iteth-ilem. Tjerrtj ngwenhel apek yeng merneh ankey nkemeng, inang itja wetham angayel irretjenh. Tjerrtj ngwenhel apek yengenh nakemeng, inang itja weth angkethel irretjenh. ");
INSERT INTO amx_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Thang arrantherrenh kel ilekarl, ‘Arrantherr yengenh kel arek, arrantherr yengenh itja kwet nakem.’ ");
INSERT INTO amx_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tjerrtj inenharl Angey tjeyenhel anthem, inang tjeng-warn petjetjenh, tjerrtj inenh map thang itja alharlkwetjenh. ");
INSERT INTO amx_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Yeng itja petjek iterrentj tjengenh-akert. Yeng petjek iterrentj Altjerr-kenh-akert. Rang yengenh lanthekarl. Yeng ahentj-anem kwerant kangkwerretjeh. ");
INSERT INTO amx_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nthakenham yeng kwer kangkwerrem? Thang tjerrtj nheng inenh rang anthekarl ingkerrek arratj arntarnt-arem. Itja nyent apek parlp-iletjeh. Thang inenh arltang ingkernel kemelh-iletjenh. ");
INSERT INTO amx_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Angey tjengenh ahentj-anem, tjerrtj ingkerrek Ler kwerenh-warn petjetjeh, renh naketjeh. Tjerrtj ngwenhel apek Ler kwerenh nakemeng, inenh Angey tjengenhel ilem, inang iteth ngampekarl anetjenh. Thang inenh arltang ingkernel kemelh-iletjenh.” Jesu lakenh ilelhek ineh-warn. ");
INSERT INTO amx_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Rang ilelhek-arleng, “Yeng anem mern rang, nheng alkereng petjekarl”, lakenheng tjerrtj Jew mapemeh kwer mwekenh-irremel tjel-angkerrek, ");
INSERT INTO amx_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","“Nwern itja renh nakem! Nhenh kwenh Jesu, Joseph-kenh ler! Nwern angey matj kwerenheh kaltj anem. Nthakenham rang ilelhem, rang alkereng petjekarl kwel?” ");
INSERT INTO amx_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesu-el inenh ilek, “Tjel-angkerretjal anerrerrang! ");
INSERT INTO amx_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Angey rang yengenh lanthekarl rant kwenh tjerrtj tjeng-warn angetjem. Tjerrtj inarrp ywarn tjeng-warn petjem. Tjerrtj inang tjeng-warn petjem, thang inenh arltang ingkernel kemelh-iletjenh. ");
INSERT INTO amx_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Altjerr-henh angketj angenh-angenh arrpenhel ngkwey ilek, ‘Altjerrel tjerrtj ingkerrek kaltj-anthetjenh.’ Lakenheng tjerrtj ngwenhel apek Angey tjengenh awemeng, kwer kangkwerremeng, inang kel tjeng-warn petjem. ");
INSERT INTO amx_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Tjerrtj nyentel Angey tjengenh itja arek apek. Artwang nheng rang Angeyeng petjekarl, rant Angey renh arek. ");
INSERT INTO amx_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Mantjel awerrerrang; tjerrtj ngwenhel apek yengenh nakemeng, inang iteth kwetant anetjenh. ");
INSERT INTO amx_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yeng anem mern rang, nheng rang tjerrtj inenh kwetant iteth anyenem. ");
INSERT INTO amx_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ngkwey angerrepat arrehantherr-henhel mern inang alkereng anyekarl arlkwetjart, inang rrkwalel anekarl-rlwer. Inang ingkerrekarl ilwek. ");
INSERT INTO amx_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mern arrpenh nhenh rang alkereng petjekarl, tjerrtjel renh arlkwemeng, inang itjarl ilwetjenh. ");
INSERT INTO amx_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yeng anem mern rang, nheng rang tjerrtj inenh kwetant iteth anyenem. Yeng alkereng petjekarl. Tjerrtj ngwenhel apek mern nhenh arlkwemeng, inang iteth kwetant anetjenh. Mern nhenh tjelk tjengenh anem. Thang tjelk tjengenh tjenkerr-arteh anthem tjerrtj ahelh-areny ingkerrekeh.” Lakenh Jesu ilelhek ineh-warn. ");
INSERT INTO amx_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Tjerrtj Jew mapel angketj nhenh awemel, inang angkerrek, “Nthakenh artwang nhenhel tjelk kwerenh nwerneh arlkwetjeh anthetjenh?” ");
INSERT INTO amx_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesu-el inenh ilek, “Nhenh mwantj awerrerrang; arrantherr Tjerrtj-henh Ler-henh tjelk renh itja arlkwemeng, alhwang kwerenh itja antjwemeng, arrantherr itja kwetant iteth anetjenh. ");
INSERT INTO amx_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Tjerrtj ngwenhel apek tjelk tjengenh arlkwemeng, alhwang tjengenh antjwemeng, inang iteth ngampekarl anetjenh. Thang inenh arltang ingkernel kemelh-iletjenh. ");
INSERT INTO amx_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Tjelk tjengenh kwenh mern rang anem, alhwang tjengenh antjwentj rang anem. ");
INSERT INTO amx_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Tjerrtj ngwenhel apek tjelk tjengenh arlkwemeng, alhwang tjengenh antjwemeng, inang tjengel-ayel nyent-irrekarl anetjenh. Yeng inehel-ayel nyent-irrekarl anetjenh. ");
INSERT INTO amx_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Angey rang yengenh lanthekarl, rang arratj iteth anem. Thang iteth tjeyenh inem kwer-angkwerr. Lakenh-arteh tjerrtj ngwenhel apek tjelk tjengenh arlkwemeng, thang inenh iteth kwetant anthetjenh. ");
INSERT INTO amx_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Nhenh kwenh mern rang anem, nheng rang alkereng petjekarl. Rang itja anem mern nheng-arteh angerrepat arrehantherr-henhel mer rrkwalel arlkwekarl. Inang mern renh arlkwemel kwenh ilwek. Tjerrtj ngwenhel apek mern nhenh arlkwemeng nhenh-atwetj tjelk tjengenh, inang kwetant iteth anetjenh.” ");
INSERT INTO amx_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesu-el tjerrtj map lakenh kaltj-anthek church kwenel mer Capernaum-el. ");
INSERT INTO amx_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Kenh nakenh-nakenh arrpenh mapel angketj nhenh awemel palekalek-irrek, itja kangkwerrek. Inarrp angkerrek, “Angketj nhenh arrpenh anthwerr! Itja nwern kangkwerrem!” ");
INSERT INTO amx_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesu kaltj anek, inang kwer tjel-angkemeng. Rang inenh pawenhek, “Thang arrantherrenh perrpert-ilek apek? ");
INSERT INTO amx_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Kelant arrantherr aretjenh Tjerrtj-henh Ler, rang alker-warn alpemeng. Arrantherr yengenh naketjenh apek, itja apek? ");
INSERT INTO amx_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Altjerr-henh Kwerrernel kwenh tjerrtj inenh iteth-ilem. Itja tjerrtj-henh kwerrernel iteth-ilem. Angketj tjengenh Kwerrern anem. Lakenh-arteh angketj tjengenhel tjerrtj inenh iteth-ilem. ");
INSERT INTO amx_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Arrehantherreng arrpenh mapel inang yengenh itja nakem.” Lakenh Jesu-el inenh kaltj-anthek. Jesu arrwekel kwet kaltj anek tjerrtj ineh, nheng inang renh itja naketjenharleh. Rang artwang nyent kwer kaltj anek, nheng rang renh atwenh-atwenh mapeh anthetjenharl. ");
INSERT INTO amx_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jesu rang weth angkek, “Angey tjengenhelant tjerrtj inenh tjeng-warn angetjem. Tjerrtj inarrp ywarn tjeng-warn petjem. Lakenh thang nheng arrantherrenh arrwekel ilekarl.” ");
INSERT INTO amx_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kwereng nakenh-nakenh arrpenh map inang Jesu-eng ampakelhek. Inang itja weth kwerel-ayeng anharrel alhek. Inang itja ahentj-anek, nakenh-nakenh kwerenh weth anetjeh. ");
INSERT INTO amx_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Lakenheng Jesu-el kwertengerl 12 arlaltj kwerenh map pawenhek, “Arrantherr-arteh? Arrantherr tjengeng ampakelhetjeh?” ");
INSERT INTO amx_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Peter-el renh ilek, “Ngkartay! Tjerrtj ngwenh-warnemeh nwern alhetjenhan? Angketj ngkwengenhelant kwenh tjerrtj inenh iteth ngampekarl anyenem! ");
INSERT INTO amx_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nwern kwenh kaltj, nwern ngwenh nakem, ntwang Altjerr-henh artwang arratj anthwerr anemeng wart.” ");
INSERT INTO amx_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesu-el inenh ilek, “Thang kwenh artwang 12 arrantherrenh ngwek, kwertengerl tjengenh anetjeh. Kenh arrehantherreng artwang nyent arrentj anem.” ");
INSERT INTO amx_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesu rartek Judas-penh angkek, Simon Iscariot-henh ler-penh. Judas rartek Jesu-kenh kwertengerl anekarl. Rang Jesu renh kelant artwang atwenh-atwenh mapeh anthetjenharl. ");
INSERT INTO amx_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Tjerrtj Jew twernk map ahentj-anekarl, Jesu renh irrernng atwetjeh. Lakenheng Jesu rang itja ahentj-anek, mer Judea-warn alhetjeh. Rang mer Galilee-angkwerr alherl-apek. ");
INSERT INTO amx_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Lyet-atheh lhwerrp-irrentj irlpangkentjeh arltang rang anek, arreny “Tak artetjeh” Inang lhwerrp-henh tak artetjart. ");
INSERT INTO amx_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jesu-henh tjey mapel renh ilek, “Ntwarteh arrwekel mer Judea-warn alhemer! Nakenh-nakenh ngkwengenh mapel ngwenh keth aretjenheng, ntwang twer anthwerrel mpwaremarleng. ");
INSERT INTO amx_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Tjerrtj ngwenh apek rang ahentj-anemeng, tjerrtj arrpenh mapel renh alhengk-aretjenheng, rang alengk-welhetj-kweny alhetjeh. Kel tjerrtj mapeng anngetherr twer renh mernelhang!” ");
INSERT INTO amx_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Lakenh inang palekalek war angkek. ");
INSERT INTO amx_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","8","Jesu-el inenh ilek, “Mpank-amparr. Tjerrtj ahelh-areny map itja arrehantherr arnkely-irrem. Tjeng inang arnkely-irrem, thang inenh ilemeng, inang anetj kwet mernelhemeng. Kel arrantherr irlpangkentjeh tjenkerr-warn alherrerrang. Yeng itja lyet irlpangkentjeh tjenkerr-warn alhem, mpank.” Lakenh rang tjey kwerenh map ilek. ");
INSERT INTO amx_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Mpank-amparr Jesu mer Galilee-el kwet antarl-irrek. ");
INSERT INTO amx_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Jesu-henh tjey map lhwerrpeh irlpangkentjeh alhekemeh Jerusalem-warn, tjenkerr arlkwetjeh. Kwereng Jesu ingkern-angkwerr alhek, anyenng-anyenng. ");
INSERT INTO amx_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Tjerrtj map lhwerrpeh irlpangkentj arltang arrwekel kwerel Jerusalem-el arraw-irrek. Tjerrtj Jew twernk mapel Jesu-eh palenthwek. Tjerrtj map inang pawenherl-apetjam, “Nthenham artwang nhengan?” ");
INSERT INTO amx_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","13","Tjerrtj inang twernk map ineheng ater-irrek-arleng wart, inang itja Jesu kwer-penh anngetherr angkerrek. Arrpenh map arretjemel war kwer-penh angketjam, “Rang artwang mwerram anem!” Kenh arrpenh map arretjemel war angketjam, “Rang tjerrtj mapeh rrtjwerremel ilelhem.” ");
INSERT INTO amx_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Arltang irlpangkentjek arrpenhel, Jesu church angerr-warn alhek, rang tjerrtj map kaltj-anthek. ");
INSERT INTO amx_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Tjerrtj Jew twernk mapel renh awek-arleng, inang anwerlkek. Inang lakenh patemel pawenherrek, “Nthakenharl artwang nhenh kaltj anthwerr anem? Ngwenhelam renh kaltj-anthek? Nwern itjam renh kaltj-anthek!” ");
INSERT INTO amx_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesu-el inenh ilek, “Thang arrantherrenh itja angketj tjengenh ilem. Altjerrel-artek yengenh lanthek, thang arrantherrenh angketj kwerenh ilem. ");
INSERT INTO amx_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Tjerrtj ngwenh apek Altjerr-henh angketjeh kangkwerrem, rang kel kaltj anetjenh, thang arrantherrenh arratj ilem, thang Altjerr-henh angketj kaltj-anthemeng, itja angketj tjengenh. ");
INSERT INTO amx_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Tjerrtj ngwenh apek rang ahentj-irrem, tjerrtj mapel renh naketjeh, rang angketj kwerenh ilem, itja arrpenh-henh angketj. Rang rrtjwerremel war angkem. Kenh tjerrtj ngwenh apek ahentj-irrem, tjerrtj mapel arrpenh naketjeh, rang urrpeyel-arteh iletjeh arrpenh-henh angketj. Rang itjarl rrtjwerrem. Lakenh thang arratj arrantherrenh ilem, itja rrtjwerremel. ");
INSERT INTO amx_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moses-el arrantherrenh Altjerr-henh mpwareng-areng renh ilek, arrantherr kenh mpwareng-areng kwer itja kangkwerrem. Arrehantherreng rrpwetj ahentj-anem, yengenh irrernng atwetjenh. Lakenh arrantherr Altjerr-henh mpwareng-arengeh itja kangkwerrem. Wenhengam arrantherr ahentj-anem, yengenh irrernng atwetjeh?” ");
INSERT INTO amx_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Tjerrtj inang renh ilek, “Wenhengam ntwang lakenh angkem? Ntwang arert-arert war angkem! Ngwenhelam ngwenh irrernng atwetjeh? Ntwartek arrentj-akert!” ");
INSERT INTO amx_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesu-el inenh ilek, “Thang arltang angerr Saturday-el twer anthwerrel nyent-ingar mpwarek, arrantherr ingkerrek tjeng anwerlkek. ");
INSERT INTO amx_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Moses-el nheng arrantherrenh twernek, kwer rrwey map arrantherr artwang-iletjeh, inang arltang 8 anemarleng. Itja Moses anthwerrel arrantherrenh twernekarl, angerrepat arrehantherr-henhel-atwetj. Arltang angerr Saturday-el arrantherr kwenpel artwang-ilem, mpwareng-arengel wart. ");
INSERT INTO amx_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Arrantherr inenh artwang-ilem, Moses-el arrantherrenh twernek-arleng, arltang angerr Saturday-el apek artwang-iletjeh. Thang artwang nyent Saturday arltel mwerr-ilek. Wenheham arrantherr yeng ilem, ‘Nhenh itja arratj anem?’ ");
INSERT INTO amx_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Arrantherr itja tjerrtj arrpenh pelkel ahang-irremel pawenhetjeh! Kel tjerrtj-penh arratjant angkay!” ");
INSERT INTO amx_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Tjerrtj Jerusalem-areny rrpwetj arrpenh mapelemeh anwerlkemel pawenherrek, “Artwang nhenham inang irrernng atwetjeh ahentj-anem? ");
INSERT INTO amx_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Kel rang tjerrtj map anngetherr kaltj-anthem. Inang renh itja arnpakem. Twernk nwern-henh map inang kaltj apek, nhenh rang Christ anemeng, Altjerrel ngkwey alhelekarl? ");
INSERT INTO amx_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Nwern kaltj, rang mer Nazareth-areny anemeng. Christ-henh merek kwenh tjerrtj itja kaltj anem. Nthakenharl rang Christ anem?” ");
INSERT INTO amx_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","29","Jesu-el inenh awek, lakenh angkemeng, rang kaltj-anthetjam-rlwer. Rang inenh angketj wentarel ilek, “Arrantherr tjeng arratj kaltj key? Mer tjengenheh arrantherr kaltj key, nthenheng yeng petjek? Itja kwet! Yeng ahelh nhenhel anem, Altjerrel yengenh lanthekarl. Yeng itja rrkwapem iterrentj tjengenh-akert. Yeng Altjerr-henh iterrentj-akert rrkwapem. Arrantherr kenh kwer akwenarl. Yeng kwer kaltjarl, yeng kwereng petjekarl wart.” ");
INSERT INTO amx_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Tjerrtj inang Jesu renh antwerrketjeh ahentj-anek. Itja antwerrketj-kweny, arltang kwer ilwetjeh mpank kwet. ");
INSERT INTO amx_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Tjerrtj arrpenh mapel renh nakekarl-penh wart, lakenh angkek, “Christ rang petjemarleng, rang twer angerr-akertel mpwaremeng, artwang nhenhelarl mpwaretjenh-arteh? Itja kwenh! Nhenh kwenh Christ rang!” ");
INSERT INTO amx_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Artwang Pharisee mapel tjerrtj map awek, Jesu-akert angkerrekarl. Pharisee inang priest twernk mapel thwen, inang church arntarnt-arenh-arenh rrkwentj inenh lanthek, Jesu renh antwerrketjeh. ");
INSERT INTO amx_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesu-el inenh ilek, “Yeng kwek war weth arrehantherrel-ayeng anetjenh. Kwereng yeng kwer-warn alpetjenh, rang wart yeng lanthekarl kwer-warn. ");
INSERT INTO amx_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Arrantherr tjeng palenthwetjenh, arrantherr kenh yengenh itja aretjenh. Mer kwer-warn yeng alhem, kwer-warn arrantherr ywarn alhem.” ");
INSERT INTO amx_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Tjerrtj Jew mapel patemel pawenherrek, “Nthenh-warnam artwang nhenh alhetjeh angkem? Wenheng nwern kwer ywarn palenthwetjenh? Peltj nwern-henh map-warn apek rang alhetjenh, inang mer Greece-el anemeng, inenhemeh rang kaltj-anthetjenh? ");
INSERT INTO amx_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Wenh lakenh rang nwernenh ilek, ‘Arrantherr tjeng palenthwetjenh, arrantherr kenh yengenh itja aretjenh. Mer kwer-warn yeng alhetjenh, kwer-warn arrantherr ywarn alhem?’ ” Lakenh inang pawenherrek. ");
INSERT INTO amx_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Irlpangkentjeh arltang ingkern kwerel Jesu rang kemerrek, rang tjerrtj map ineh wentarel ilek, “Tjerrtj ngwenh apek inang angkethel anemeng, inang tjeng-warn petjetjeh antjwetjeh. ");
INSERT INTO amx_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Tjerrtj ngwenh apek inang yeng nakem, angketj Altjerr-henh pipel-ayel ineh-akert lakenh intem, ‘Tjerrtj inehel-ayel kweneng kwatj iteth rang rew-arteh alhetjenh.’ ” ");
INSERT INTO amx_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesu rang kwatj iteth-akert angketjam. Kenh angketj kwenameny intek, rang Kwerrern Alngaltar-akert angketjam. Kwerrern renh Altjerrel tjerrtj nakenh-nakenh map-warn lanthetjeh-anngernt. Jesu rang Kwerrern Alngaltar renh mpank-amparr lanthetj-kwenh, rang itja mer alker-warn alpek. ");
INSERT INTO amx_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Tjerrtj arrpenh mapel nhenh awek, inang lakenh angkek, “Artwang nhenh-artek arratj Altjerr-henh angenh-angenh rang anem!” ");
INSERT INTO amx_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Arrpenh map angkek, “Nhenh kwenh arratj Christ rang anem, Altjerrel ngkwey alhelekarl.” Arrpenh mapel ilek, “Christ rang itjam mer Galilee-areny anem. ");
INSERT INTO amx_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Angketj Altjerr-henh pipel-ayeng arrernekarl intem, ‘Christ rang David-henh peltj anetjenh, mer Bethlehem-areny. Bethlehem kwenh David-henh mer anek.’ ” ");
INSERT INTO amx_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Tjerrtj inang ularrek-ularr ilterrek Jesu-eng arrngel. ");
INSERT INTO amx_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Arrpenh mapel renh kel antwerrketjeh ahentj-irrek. Inang renh itja antwerrkek. ");
INSERT INTO amx_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Rrkwentj nheng map iltjant alpek. Artwang Pharisee mapel priest twernk mapel thwen inenh pawenhek, “Wenhengarl arrantherr Jesu renh mentj impek, antwerrketj-kwenh? Nwerneh-warn arrantherr angetjemer?” ");
INSERT INTO amx_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Rrkwentj inang inenh ilek, “Rang kwenh tjerrtj map mwerr anthwerr kaltj-anthek. Nwern itja angketj lakenh-arteh arrwekel awek apek.” ");
INSERT INTO amx_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Artwang Pharisee mapel inenh ilek, “Arrantherrenh-arlkemeh rang perrpert-ilek! ");
INSERT INTO amx_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Tjerrtj nwern-henheng itja nyentel Jesu renh nakem. Priest twernk mapel itja renh nakem. ");
INSERT INTO amx_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Tjerrtj nhenh map palekalek-irrem inang Moses-henh mpwareng-arengeh akwen anemeng. Lakenheng inang Jesu renh nakem. Altjerrel kwenh inenh atwetjenh.” ");
INSERT INTO amx_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemus artwang Pharisee nheng rang Jesu-warn kwenyel alhekarl, rang inenh awek, lakenh angkerleh. Rang inenh ilek, ");
INSERT INTO amx_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Mpwareng-areng nwern-henhel kwenh nwernenh arnpakem. Itja tjerrtj arrpenh war atwetjehant, nwern renh awetjeh-amparr.” ");
INSERT INTO amx_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Artwang Pharisee arrpenhel Nicodemus renh ilek, “Ntwam artwang Galilee-areny? Altjerr-henh angketjeh read-irray! Ntwang kaltj anetjenh, Altjerr-henh angketj angenh-angenh itja anthwerr mer Galilee-eng petjetjenh apek.” ");
INSERT INTO amx_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Inang ingkerrek kel mer-warn alpek. ");
INSERT INTO amx_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesu rang irntang-warn alhek. Irntang arreny kwerenh Olive. ");
INSERT INTO amx_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kweny-rtweh rang weth church angerretj-warn petj-alpek. Tjerrtj map kwer-warn arnek-irremel petjek. Rang arrernelhek, inenh kaltj-anthetjeh. ");
INSERT INTO amx_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","6","Moses-henh mpwareng-areng kaltj-anthenh-anthenh map artwang Pharisee map thwen inang ahentj-anek, Jesu renh arrkernetjeh. Lakenheng inang marl nyent Jesu-warn angetjek. Marl nhenh renh-artek arrpenh mapel arekarl, artwang arrpenhel-arleng intek-arleng, itja anew kwerenhel-arleng. Inang marl renh tjerrtj mapeng mpwepel ngkernek. Inang Jesu renh arrkernemel pawenhek, “Kaltj-anthenh-anthenhay, awang-athew! Marl nhenh tjerrtjel arek, rang anetj mpwarek. Mpwareng-areng nwern-henhel-ayeng Moses-el nwernenh twernek, nwern tjerrtj nhenh irntel iltewetjeh kwel, irrernngeh-atwetj. Nthakenham ntwang iterrem? Nhenh key arratj, lakenh mpwaretjeh? Nwern renh irrernng atwemer key?” Jesu-emeh intert anek. Rang artep arrernelhemel iltjang kantj kwerenhel aherneh mpatj arrernek. ");
INSERT INTO amx_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Inang kwet anthwerr pawenhek marl nhenh-penh. Rang irnemel inenh ilek, “Tjerrtj ngwenh apek mwerr anemeng anetj-kweny, rek-amparr renh irntel iltewetjeh.” ");
INSERT INTO amx_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kwereng rang wetham artep arrernelhemel aherneh angketj mpatj arrernek. ");
INSERT INTO amx_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Tjerrtj mapel angketj kwerenh awemarleng, inang lakenh iterrek, “Ay! Nwern kwenh anetj-akert!” Inang ingkerrek nyerr-irremel alhek, nyentam-nyent alhek. Aywang mapek-amparr, kwereng anthetj map alhek. Ingkern Jesu-emeh marl thwen anek. ");
INSERT INTO amx_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesu-el irnemel marl renh pawenhek, “Nthenhameh tjerrtj inarl ngwenh marl arlkwer-arlkwer ilekarl? Nyentel apek ngwenh irntel iltewetjenh?” ");
INSERT INTO amx_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Marl rang angkek, “Itjaw, twernkay!” Jesu-el renh ilek, “Thang ngwenh itja urrarn ilem. Kel alpay. Ntwang mwerr anetjeh, anetj mpwaretjal anay!” ");
INSERT INTO amx_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jesu-elemeh inenh weth ilek, “Yeng parrtj rang anem tjerrtj ahelh-areny ingkerrekeh. Tjerrtj ngwenh apek tjengel-ayel anharrel petjem, inang itja ngwemerntel nthwerl-apetjenh. Inang parrtjel kwet nthwerl-apem, inang kwetant iteth anetjenh.” ");
INSERT INTO amx_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Artwang Pharisee mapel renh ilek, “Ntwang kwenh ngkwewaleny ilelhem! Nthenham tjerrtj angerrepat nwerneh ilelhem, angketj ngkwengenhel-arleng twer mpwaretjeh, nthakenh-nthakenh apek ntwang ilelhem? Lakenhehant nwern ngwenh naketjeh apek! Lakenheng angketj ngkwengenh itja arratj anem!” ");
INSERT INTO amx_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesu-el inenh ilek, “Yeng kaltj anem, mer kwereng wart yeng petjekarl. Yeng kaltj mer kwer-warn yeng angkep alpetjenh. Lakenheng yeng nyent apek arrehantherr ilelhem, arrantherr kel angketj tjengenh naketjeh kwet. Arrantherr itja kaltj anem, mer kwereng yeng petjekarl. Arrantherr itja kaltj, mer kwer-warn yeng angkep alpem. ");
INSERT INTO amx_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Arrantherr tjeng kaltj-kwenh anem, arrantherr tjeng tjel-angkerrem, arrantherr ahelh-areny wart. Kenh thang nyentel itja tjerrtj judge-em-iletjehan. ");
INSERT INTO amx_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Angeyel tjerrtj ingkerrek judge-em-iletjenh. Angeyel yengenh lanthek ahelh nhenh-warn. Lakenh ilernakan ingkerrek arratj judge-em-iletjehan anem. ");
INSERT INTO amx_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Angketj mpwareng-areng arrehantherr-henhel-ayeng intem, ‘Tjerrtj atherr apek angketj nyent angkemeng, tjerrtj arrpenh mapel angketj kwer-atherr-henh kel naketjehant, lakenh angkemeng, “Angketj nhenh arratj.”’ ");
INSERT INTO amx_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yeng ilelhem, yeng Altjerr-henh Ler anemeng. Angeyel yengenh lanthekarl, rang tjeng-akert angkek, ‘Nhenh Ler tjengenh anem.’ Angketj nhenh atherr anem.” Lakenh Jesu-el inenh ilek. ");
INSERT INTO amx_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Inang Jesu renh pawenhek, “Nthenham angey ngkwengenhan?” Jesu-el inenh ilek, “Arrantherr tjeng itja kaltj, angey tjengenheh thwen. Arrantherr tjeng kaltj anemer, kwereng arrantherr Angey tjengenheh kaltj anemer. Itja.” ");
INSERT INTO amx_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jesu rang lakenh ilelhek, rang tjerrtj map church angerretj kwenel kaltj-anthemeng, rang room ngkweltj tjenkerr map-akertel iterel anekarl. Tjerrtj nyentel renh itja antwerrkek, Altjerrel inenh arnpakekarl. Arltang rang ilwetjeh irretjenharl, mpank kwet wart. ");
INSERT INTO amx_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jesu-el tjerrtj Jew map weth ilek, “Yeng mer arrpenh-warn alhetjenh, arrantherr kwer-warn ywarn alhem. Arrantherr ywarn tjeng palenthwetjenh. Arrantherr anetj-akert ilwetjenh, anetj arrehantherrel-ayel anemarleng-antey.” ");
INSERT INTO amx_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Inang angketj nhenh pal awek. Inang pawenherrek, “Wenheng rang nheng angkek-arleng wart, ‘Mer kwer-warn yeng alpetjeh, arrantherr ywarn alhetjenh.’? Rang key irrernng atwelhetjenh?” ");
INSERT INTO amx_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesu-el inenh ilek, “Arrantherr kwenh ahelh kwen-areny, yeng kenh kern-arenyarl. Yeng itja kwetarl ahelh-areny anem. ");
INSERT INTO amx_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Thang nheng arrantherrenh ilek, arrantherr anetj-akert ilwetjenh, anetj arrehantherrel-ayel anemarl-antey. Arrantherr itja yengenh nakemeng, yeng Angey-kenh Ler anemeng, Altjerrel anetj arrehantherr-henh itja rrpwaremel wetjenh. Arrantherr anetj-akert kwet ilwetjenh.” ");
INSERT INTO amx_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Inang Jesu renh pawenhek, “Ngwenham ntwang?” Jesu-el inenh ilek, “Thang arrantherrenh arrwekel nheng kaltj-anthekarl. ");
INSERT INTO amx_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ayeng angketj angerr arrpenh-arrpenh-akert anem, arrantherrenh iltetjeh. Mentj thang impem. Altjerr rang yeng lanthekarl, angketj kwerenh arratj anem. Thang angketj kwerenh awek, thang angketj kwerenhant ilem tjerrtj ahelh-areny ingkerrekeh.” ");
INSERT INTO amx_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Rang inenh angketj Angey-akert iter-angkwerr ilek. Inang angketj kwerenh itja iterl-arek. ");
INSERT INTO amx_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Jesu ineh weth ilelhek, “Kelant arrantherr Tjerrtj-henh Ler renh kern-iletjenh, kwereng arrantherr kaltj anetjenh, yeng Angey-henh Ler anemeng. Arrantherr kaltj anetjenh, Angeyel yengenh kaltj-anthekarl-arteh, lakenh yeng angkem. ");
INSERT INTO amx_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Angey rang yengenh lanthekarl, rang tjengel-ayel anem. Rang yengenh itja mentj impem. Yeng kwer kwet kangkwerrem.” ");
INSERT INTO amx_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Tjerrtj mapel angketj nhenh awek, inang Jesu renh nakek. ");
INSERT INTO amx_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jesu-el tjerrtj nakenh-nakenh irrekarl map inenh ilek, “Arrantherr apek angketj tjengenheh kwet kangkwerremeng, kel arrantherr arratj kwertengerl tjengenh anetjenh. ");
INSERT INTO amx_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Arrantherr angketj arratj tjengenheh kaltjemeh anetjenheng. Angketj arratjel arrantherrenh arratelhelem tjey anetjeng, arrantherr kethelemeh tjey arratjel alhetjenheng.” ");
INSERT INTO amx_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Tjerrtj mapel renh ilek, “Nwern kwenh arrwekeleny Abraham-kenh peltj anem! Nwern kel tjey arratjel alhem! Tjerrtj arrpenh map nwerneh itjemeh twernk apek anem! Wenheng ntwang nwernenh twernem, nwern tjey arratjel kwel alhetjeh?” ");
INSERT INTO amx_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesu-el inenh ilek, “Arratj anthwerr, tjerrtj ngwenh apek rang alherrentj anetj kwerenhek kangkwerrem, alherrentj anetj rang tjerrtj renh kwet antwerrketjenh. Tjerrtj rang rrkwapenh-apenh-arteh anem twernk kwerenheh. ");
INSERT INTO amx_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Thang arrantherrenh ilem angketj mer-akert. Rrkwapenh-apenh rang itja merek-artwey anetjenh. Ler ngwenh-kenh apek anem, rant merek-artwey anetjenh. Kwerant anem, merel kwet antarl-irretjeh. ");
INSERT INTO amx_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kwereng Ler nhengel arrantherrenh tjey arratjeh arrernemeng, arrantherr itja weth alherrentj anetj arrehantherr-henh kangkwerretjeh. Kwereng alherrentj anetj rang itja weth twernk arrehantherr anem, arrantherr kel kethelemeh anetjenh. ");
INSERT INTO amx_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Yeng kaltj, arrantherr Abraham-henh peltj anemeng. Arrantherr angketj tjengenheh ahentj-kwenh anemeng, lakenheng arrantherr ahentj-anem, yeng irrernng atwetjeh. ");
INSERT INTO amx_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yeng Angeyel-ayeng anek, thang arrantherrenh angketj kwerenh ilem. Arrantherr angketj nhengeh kangkwerrekarl, angey arrehantherr-henhel angketj ilekarleh.” ");
INSERT INTO amx_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Inang Jesu renh ilek, “Nwern arratj kwenh angey Abraham-henh peltj anem!” Jesu-el inenh ilek, “Arrantherr apek Abraham-henh peltj arratj anemeng, arrantherr Abraham-arteh mernelhemer. ");
INSERT INTO amx_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Arrantherr kenh ahentj-anem, yeng irrernng atwetjehant. Wenheng? Thang arrantherrenh arratj anthwerr ilek-arleng, angketj renh thang Altjerreng awekarl. Abraham itja arrantherr-arteh mernelhek. ");
INSERT INTO amx_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Arrantherr-artek arrehantherr-henh angey-arteh mernelhem.” Inang Jesu renh ilek, “Nwern itjam kwetjentj anem, Altjerr rarrp Angey nwern-henh anem.” ");
INSERT INTO amx_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesu-el inenh weth ilek, “Yeng kwenh Angeyeng petjek, rarrp yengenh arrehantherr-warn lanthek. Yeng itja nyent iterrek, petjetjeh. Arrantherr tjeng itja nyerrkem, lakenheng Altjerr itja angey arrehantherr-henh anem. ");
INSERT INTO amx_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Wenhengam arrantherr angketj tjengenh itja nakem? Thang arrantherrenh ileyay, arrantherr-artek alhengk-aretj-kweny war anem. ");
INSERT INTO amx_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Arrentj rang kwenh angey arrehantherr-henh anem. Arrantherr ahentj-anem kwer kangkwerretjeh. Rang kweteth irrernng atwenh-atwenh anganentj anentjek. Rang kweteth angketj rrtjwerrentj ilem, rang kwenh urrtjalth anem. Rang tjerrtj rrtjwerrenh-rrenh mapek angey anem. ");
INSERT INTO amx_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Thang arrantherrenh angketj arratj ilek-arleng-artany, arrantherr yengenh itja nakem. ");
INSERT INTO amx_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ngwenhel yengenh ilemer, thang anetj mpwarekarl? Itja kwenh! Yeng arratj angkem. Wenhengam arrantherr yengenh itja nakem? ");
INSERT INTO amx_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Tjerrtj ngwenh apek Altjerr-henh peltj anem, inang arratj awem, Altjerrel inenh ilemeng. Arrantherremeh itja Altjerr-henh peltj anem, lakenheng arrantherr Altjerr-henh angketj itja arratj awem.” ");
INSERT INTO amx_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Tjerrtj mapel Jesu renh ilek, “Nwern ngwenh arratj anthwerr ilem, ntwang Samaria-areny anemeng, artwang arrentj-akert.” ");
INSERT INTO amx_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesu-el inenh ilek, “Yeng itjam arrentj-akert. Thang angey tjengenhant nakem. Arrantherr yengenh rrtjwekel-wemarl. ");
INSERT INTO amx_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Yeng itja tjwenelherl-apem, Angey rarrp yengenh tjwenerl-apem. Rang ahentj, tjerrtj mapel yengenh naketjeh. Rang kwenh judge-em-iletjenharlam. ");
INSERT INTO amx_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Angketj nhenh arratj anthwerr, tjerrtj ngwenh apek angketj tjengenheh kwet kangkwerrem, rang itja kwetarl ilwetjenh.” ");
INSERT INTO amx_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Tjerrtj inang renh ilek, “Nwern kaltjam, ntwang arrentj-akert anemeng. Abraham rang ilwek, Altjerr-henh angketj angenh-angenh ngkweyeny map ilwek. Kenh ntwang ilem, tjerrtj rang angketj ngkwengenheh kangkwerremeng, rang kwel itja kwetarl ilwetjenh. ");
INSERT INTO amx_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Abraham Altjerr-henh angketj angenh-angenh ngkweyeny map thwen inang ingkerrek ilwek. Ntwang key Abraham-eng angerr-lkwer anem? Rang peltj nwern-henh. Ngwenhemeh ntwang ilelhem? Ntwartek itja Abraham-arteh anem!” ");
INSERT INTO amx_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesu-el inenh ilek, “Yeng itja tjwenelhem. Angketj tjengenh itja pelkel war anem. Angey rang tjeng nyerrkem. Arrantherremeh ilelhem, rang Altjerr arrehantherr-henh kwel anemeng. ");
INSERT INTO amx_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Arrantherr kwer akwenarl. Yeng kenh kwer kaltjarl. Yeng apek tjerrtj arrpenhek ilelhemeng, yeng kwel Altjerr kwer akwen anemeng, lakenh yeng rrtjwerrem war, arrantherrarl rrtjwerrem-arteh. Yeng itja lakenh ilelhem. Yeng kwer kaltjarl, yeng angketj kwerenheh kangkwerrem. ");
INSERT INTO amx_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Peltj arrehantherr-henh Abraham tjeng kaltj anek, yeng ahern nhenh-warn petjetjenharl. Rang arrken anthwerr anek.” ");
INSERT INTO amx_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Inang Jesu renh ilek, “Mentjemeh impay! Ntwang itjam angerrepat anem! Ntwang Abraham renh itja arek!” ");
INSERT INTO amx_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesu-el inenh ilek, “Mantjel awerrerrang! Abraham itja anek ahern nhenhel, yeng kweteth anentjek alker kernel.” ");
INSERT INTO amx_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Tjerrtj mapel pwert inek, Jesu renh irntel iltewetjeh. Jesu ineheng alengk-welhemel, church-henh yard-eng arratenhek. ");
INSERT INTO amx_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesu tjeyel alhep-alhetjam, rang artwang pweng renh arek. Artwang aywang pweng anek kwekeng-ntjel. ");
INSERT INTO amx_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Kwertengerl inang Jesu renh pawenhek, “Kaltj-anthenh-anthenhay, wenh-penh rang anngang pweng kwet anek kwekeng-ntjel? Ngwenham anetj mernelhek? Artwang pweng nhenh key? Itja apek, angey kwerenh apek? Matj kwerenh apek?” ");
INSERT INTO amx_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesu-el inenh ilek, “Itjam artwang nhenh anetj mpwarelhek. Angey matj kwerenh itja anetj mpwarelhek. Artwang yanh anek anngang pweng kwekeng-ntjel, thang apek renh mwerr-iletjenheng. Kwereng tjerrtj ingkerrekel aretjenh, Altjerr rang twer anthwerr anem. ");
INSERT INTO amx_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Altjerrel kwenh yengenh ahelh nhenh-warn lanthek, kwer rrkwapetjeh. Lyet arltang angerremeh anem, nwern rrkwapetjeh. Kel kweny-irremel tjerrtj ywarn rrkwapem. ");
INSERT INTO amx_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Yeng tjerrtj ahelh-areny mapel-ayeng anemarleng, yeng parrtj ineh anem.” ");
INSERT INTO amx_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Kwer-penh Jesu-el ahelh-warn apelh-wek, apelhel ahelh anthwerrng mpwarek. Kwereng rang artwang pweng kwer anngang anthwerrngel pernek. ");
INSERT INTO amx_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Rang renh ilek, “Alhay Siloam-warn, kwatj angentj-warn. Anngang ngkwengenh lhewelhetjeh.” Arreny Siloam nhenh Anmatjerrel-ayel intem “Lanthekarl”. Artwang rang kel alhek, anngang lhewelhetjeh. Kwer-penh rang anngang mwerrelemeh arek, kethemeh. Kwer-penh rang mer-warn alpek. ");
INSERT INTO amx_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Tjerrtj mer-areny map inang renh arek, mwerremeh aremel talkw alherleh ineh-angkwerr. Inang patemel pawenherrek, “Artwang nhenhan pweng nheng key? Artwang pwengek-amparr anekarl-penh. Rang merneh ankey nketj-alhetjart? Rang key?” ");
INSERT INTO amx_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Arrpenh map angkek, “Rang anthwerram yanh!” Kenh arrpenh map angkek, “Itjaw! Artwang arrpenham yanh! Inngerr rarteh.” Artwang rang ilelhek, “Yeng kwenh rang!” ");
INSERT INTO amx_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Inang renh pawenhek, “Nthakenham anngang ngkwengenh mwerr-irrek?” ");
INSERT INTO amx_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Rang inenh ilek, “Artwang nyentel ahern anthwerrng mpwarek, anngang tjengenh pernek. Kwerenh arreny Jesu. Kwereng rang yengenh kwatj angentj-warn lanthek, anngang lhewelhetjeh. Kwatj angentj nhakan arreny Siloam. Yengemeh alhek, anngang lhewelhetjeh. Thangan arek keth-anem.” ");
INSERT INTO amx_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Inang renh pawenhek, “Nthenham artwang yang?” Artwang pwengarl anek angkek, “Ywek.” ");
INSERT INTO amx_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Arltang kwerel Jesu-el ahern anthwerrng mpwarek, artwang pweng yanh anngang mwerr-iletjeh, arltang angerr kwenh anek, Saturday. Kwer-penh tjerrtj inang artwang pweng kwekeng-ntjelarl anek renh artwang Pharisee map-warn tjey-angek. ");
INSERT INTO amx_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Artwang Pharisee mapelemeh artwang pweng kwekeng-ntjel anekarl renh pawenhek, “Nthakenham anngang ngkwengenh mwerr-irrek?” Rang inenh ilek, “Rang anngang tjengenh ahern anthwerrngel pernek, yengemeh anngang kwatjel lhewelhek. Thang keth-anem arek.” ");
INSERT INTO amx_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Artwang Pharisee rrpwetj angkek, “Artwang alenh rang arltang angerr Saturday-el rrkwapek. Nhenh itja arratj anem. Angketj mpwareng-areng nwern-henhel-ayeng intemeng wart. Nwern kwer mwekenh-irrem mpwareng-areng nwern-henheng. Lakenheng artwang rang itja Altjerr-henh anem.” Kenh artwang Pharisee arrpenh map lakenharl angkek, “Artwang anetjel itja ngangkarel mpwarem! Artwang mwerrelant kwenh ngangkarel mpwarem!” ");
INSERT INTO amx_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Lakenheng inang weth pawenhek artwang pweng kwekeng-ntjelarl anek renh, “Nthakenh apek ntwang iterl-arem? Artwang nhengel ngwenh anngang mwerr-ilekarl, ngwenham rang? Nwernenh ilang!” Rang inenh ilek, “Rang Altjerr-henh angketj angenh-angenh anem.” ");
INSERT INTO amx_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Twernk mapel artwang renh itja nakek. Inang tjweker-irrek, rang kwewaleny ilelhek, rang pweng kwekeng-ntjel anentjekarl-penh wart. Inang kwer-artwey atherreh ntangkelhemel ngwek. ");
INSERT INTO amx_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Inang renh-atherrenh pawenhek, “Artwang nhenh mpwel-kenham? Rang kwel anngang pweng kwekeng-ntjel kwet anentjekarl? Nthakenham rang arem?” ");
INSERT INTO amx_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","23","Angey mwek thwen kwerenh ratherr twernk mapeng ater-irrek. Inang lyet mpwareng-areng nhenh ngkernek-arleng, “Tjerrtj ngwenh apek rang Jesu-akert angkemeng, iterl-aremel Jesu rang Christ anemeng, Altjerrel ngkwey alhelekarl, renh church-eng alharlkwetjeh.” Lakenheng ratherr inenh ilek, “Ilern kaltj, rang ler ilern-henh anemeng. Ilern kaltj, rang anngang pweng kwet kwekeng-ntjel anekarl. Nthakenham rang lyet arem? Ilern nhenhek itja kaltj. Ngwenhel renh anngang mwerr-ilek, ilern itja kaltj anek. Rang itja kwer anem, renhant pawenhay! Rang kel arrehantherr kwewaleny ilelhetjenh!” ");
INSERT INTO amx_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Inang artwang pweng kwekeng-ntjel anekarl kwer weth-antey ntangkelhek, inang renh pawenhetjeh. Inang angkek, “Altjerrel ngwenh arem, arratj anthwerr ilelhang! Nwern kwenh kaltj, artwang nheng rang ngwenh mwerr-ilekarl, rartek artwang anetj anem!” ");
INSERT INTO amx_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Artwang pweng anekarl rang inenh ilek, “Yeng itja kaltj, artwang alenh anetj apek anemeng, mwerr apek. Yeng nhenhekant kaltj, yeng pweng anekarl, lyet thang keth-anem arem!” ");
INSERT INTO amx_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Inang renh pawenhek, “Nthakenh anthwerram rang ngwenh anngang mwerr-ilek?” ");
INSERT INTO amx_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Rang inenh ilek, “Thang arrantherrenh kelam ilek. Arrantherr angketj tjengenheh itja kangkwerrek! Wenheham arrantherr yengenh kwet pawenhem? Arrantherr kwer nakenh-nakenh anetjeh ahentj-irrem?” ");
INSERT INTO amx_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Inang renh arrampewek, “Ntwang kel nakenh-nakenh kwerenh anem! Nwern Moses-henh nakenh-nakenh anem! ");
INSERT INTO amx_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nwern kaltj, Altjerr rang ngkwey Moses-el-ayel angkekarl. Kenh nwern artwang arrpenh nhenh mer kwerenhek-arlk kaltj-kwenyarl!” ");
INSERT INTO amx_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Artwang rang inenh pawenhek, “Nthakenharl artwang rang yengenh anngang mwerr-ilek? Kenh arrantherr mer kwerenhek-arlk kaltj-kwenyarl! ");
INSERT INTO amx_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nwern kaltj, Altjerr rang itja tjerrtj anetjeh kangkwerrem. Tjerrtj inang Altjerreh kangkwerremel nakem, Altjerr rang tjerrtj inehant kangkwerrem. ");
INSERT INTO amx_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Ngkweyeng-ntjel nwern itja kwet awentjek, tjerrtj nyentel apek tjerrtj anngang pweng kwekeng-ntjelarl anngang mwerr-ilekarl. ");
INSERT INTO amx_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Artwang nhenh apek itja Altjerr-areny key? Nthakenham rang yengenh ngangkarel mpwarek?” ");
INSERT INTO amx_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Inang renh ilek, “Ntwang kwer kwekeng-ntjel anetj kwet mernelhek! Ntwang iterrem, ntwang kwel nwernenh kaltj-anthetjenharl! Itjeng alhang!” Inang renh church kwereng keth-warn alharlkwek, kweteth. ");
INSERT INTO amx_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesu-el awek-arleng, Pharisee inang artwang nheng church-eng alharlkwekarl, rang kwer palenthwek. Rang renh aremel pawenhek, “Ntwang Christ renh nakem kwey, Altjerrelarl ngkwey alhelekarl?” ");
INSERT INTO amx_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Artwang rang renh ilek, “Artwangay, ngwenham rang? Tjeng ilay, thang renh naketjenheng!” ");
INSERT INTO amx_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesu-el renh ilek, “Ntwang renh awek, ntwang renh arek, ntwang kwer angkem.” ");
INSERT INTO amx_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Artwang rang Jesu renh alhengk-aremel ilek, “Ngkartay! Thang ngwenh nakem!” Rang amperel-ayeng arrernelhemel renh kangkemel nakek. ");
INSERT INTO amx_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jesu angkek, “Yeng ahelh nhenh-warn petjek, tjerrtj map ahelh apanpel judge-em-iletjeh. Tjerrtj arrpenh map inang tjerrtj pweng-arteh war anem, yengenh iterl-aretj-kweny anem. Thang inenh anngang alngampelh-iletjenh. Thang inenh kaltj-anthem, inang yengenh iterl-aretjehemeh. Tjerrtj arrpenh map inang nakelhem, inang mwerr-arrpantey, inang tjey anetjel kwet alherl-apetjenh, artwang pweng-arteh ngwemerntel-arteh alherl-apem. Inang yengenh iterl-aretj-kweny anem, nakentj-kweny anem. Thang inenh itja mwerr-iletjenh, itja kaltj-anthetjenh.” ");
INSERT INTO amx_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Artwang Pharisee rrpwetj inang kwereng arrer irnek, inang renh awek, lakenh angkerleh. Inang renh pawenhek, “Ntwang nwernenh ilek, anngang pweng kwel?” ");
INSERT INTO amx_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesu-el inenh ilek, “Arrantherr apek pweng anem, arrantherr itja anetj-akert anem. Arrantherr ilelhem, arrantherr kwel Altjerr-henh angketj iterl-arem. Arrantherr anetj-akert kwetarl anem!” ");
INSERT INTO amx_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesu-el inenh weth ilek, “Thang arrantherrenh angketj nhenh ilem, artwang atherr-akert yep-yep map-akert thwen. Yep-yep map parrik kwenel irnetjam. Artwang ngwenh apek parrik-angkwerr kwen irrpem, rang itja arrew-angkwerr irrpem, lakenh nwern alhengk-arem, artwang rang anyenngamp anem, atwenh-atwenh apek. ");
INSERT INTO amx_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Kenh artwang arrpenh rang arrew arratj-angkwerr irrpenhem, nwern alhengk-arem, rang yep-yepek-artwey anem. Rang arntarnt-arenh-arenh mwerr anem yep-yep ineh. ");
INSERT INTO amx_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Artwang arrewek-artwey rang arntarnt-arenh-arenh kwer arrew altjwer-ilem, arntarnt-arenh-arenh rang arrew-angkwerr irrpenhetjenheng. Yep-yep mapel arntarnt-arenh-arenh inehenh awem. Arntarnt-arenh-arenh rang yep-yep kwerenh map arreny anewemel ngwem, rang inenh parrik kweneng keth-warn arratelh-ilemel angem. ");
INSERT INTO amx_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Kwereng rang inenh arratelh-ilekarl-penh, arntarnt-arenh-arenh rang ineheng arrwekel-irrem. Kwereng yep-yep inang kwereng ingkern-angkwerr alhem, inang angketj kwerenheh kaltjeng wart. ");
INSERT INTO amx_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Inang itja tjerrtj lwerenyeng ingkern-angkwerr alhem, itja. Inang kel aterel arerl-alhem, inang angketj kwerenhek kweneng wart.” ");
INSERT INTO amx_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesu-el inenh angketj kwenameny nhenh ilek. Inang angketj renh pal awek. ");
INSERT INTO amx_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Jesu rang ilelhek, “Arratj anthwerr, yeng anem arrew-arteh yep-yep tjengenh mapeh. ");
INSERT INTO amx_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Arntarnt-arenh-arenh arrpenh inang tjeng arrwekel anekarl, inang ingkerrek anyenngamp atwenh-atwenh anek. Yep-yep inang ineh itja kangkwerrek. ");
INSERT INTO amx_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yeng arrew tjeperr rang anem. Tjerrtj ngwenh apek tjeng-angkwerr irrpenhem, inang tjengel-ayeng kwetant iteth anetjenh. Inang irrperl-anetjenh arraterl-anetjenh yep-yep-arteh. Inang mern angerr kwet arlkwerl-anetjenh. ");
INSERT INTO amx_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Anyenngamp kenh petjem, yep-yep inenh anyenngel inetjeh, irrernng atwetjeh apek, ywerrelh-iletjehant apek. Yeng itja lakenh-arteh anem. Yeng petjek, yep-yep inenh iteth anyenetjeh, inang tjengel-ayeng kwetant iteth anetjeh-anngernt.” ");
INSERT INTO amx_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Jesu rang weth ilelhek, “Yeng arntarnt-arenh-arenh mwerr rang anem. Arntarnt-arenh-arenh mwerr rang kel yep-yep kwerenh mapek tjang-ilwem. ");
INSERT INTO amx_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","13","Arntarnt-arenh-arenh arrpenh ngwenhel apek yep-yep map maneyek war arntarnt-arem. Rang itja yep-yepeh-artwey anem. Rang angwely arnwer nhwenh-nhwenh aremeng, rang aterel arrtjanem, yep-yep inenh aterel imperl-alhemel. Arnwer rang yep-yep inenh nhwem, inenh nhwemel irrarnpelh-ilem. ");
INSERT INTO amx_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Yeng anem arntarnt-arenh-arenh mwerr rang. Yeng yep-yep tjengenh mapeh kaltj anem. Inang tjeng kaltj anem. ");
INSERT INTO amx_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Yeng ineh kaltj, Angey rang tjeng kaltj anemarl-arteh. Yeng Angey kwer kaltjarlam. Yengemeh yep-yep tjengenh mapeh tjang-ilwetjenh, inang iteth anetjenheng. Yeng iteth tjengenh ineh mentj anthelhetjenh. ");
INSERT INTO amx_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Yep-yep arrpenh map inang tjeng mpank-antey anem. Inang itja yep-yep nhenh mapel-ayeng anem. Inang angketj tjengenh awetjenh, kwereng thang inenh Altjerr-warn angetjetjenh. Kel yep-yep map nyentemeh anetjenh, arntarnt-arenh-arenh nyent ingkerrekeh anetjenh. ");
INSERT INTO amx_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Angey ahentj, yeng iteth tjengenh mentj anthelhetjeh. Yeng kwer kangkwerremeng, lakenheng rang tjeng angerr anthwerr nyerrkem. Kelant rang iteth tjeng angkep anthetjenheng. ");
INSERT INTO amx_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Arrpenhel yengenh ywarn irrernng atwem. Yengarrp Angeyek kangkwerremel ilwetjenh. Tjengan anem ilwetjeh, kwer-penh kemerretjenh. Angey rarrp yengenh lakenh twernek.” Lakenh Jesu rang ilelhek. ");
INSERT INTO amx_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Tjerrtj inang angketj nhenh awekarl-penh, inang angkerrek. ");
INSERT INTO amx_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Arrpenh map arnpakemel angkek, “Jesu rartek arrentj-akert, artwang ahert. Tjerrtj itja kwer kangkwerretjeh.” ");
INSERT INTO amx_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Arrpenh map lakenharl angkek, “Nthakenh Jesu arrentj-akert anem? Artwang arrentj-akert ywarn lakenh angkem. Artwang arrentj-akertel ywarn tjerrtj pweng anngang aretjeh mpwarem!” ");
INSERT INTO amx_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Kel lhwerrpemeh anek. Lhwerrpel tjerrtj Jew map kweteth Jerusalem-el arraw-irretjart, tjenkerr anyenetjeh. Tjenkerr arreny kwerenh Church Angerr Ngkernentj. Lakenheng Jesu rang anek Jerusalem-el. ");
INSERT INTO amx_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Arltang arrpenhel Jesu rang lywang nyent kwerel nthwetjam. Lywang rang anek church angerr iterel. Lywang renh inang iletjart King Solomon-kenh lywang. ");
INSERT INTO amx_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Tjerrtj map kwer-warn arraw-irrek. Inang renh pawenhek, “Nwern-artek ngkweng-akert ywarn iterrek. Ntwang arratj ilelhay nwerneh! Ntwang Christ key, Altjerrel ngkwey arrwekeleny nwern-kenh mapek alhelekarl, ngwenharl ahelh nhenh-warn lanthetjenharl?” ");
INSERT INTO amx_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesu-el inenh ilek, “Thang arrantherrenh kel ilek, kenh arrantherr yengenh itjarl nakek. Thang twer angerrel mpwarek, lakenh yeng mernelhek, Angeyelarl yengenh lanthek. Lakenheng arrantherr kaltj anemer, yeng Christ anemeng. ");
INSERT INTO amx_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Arrantherr itja yep-yep tjengenh anem, lakenheng arrantherr itja yengenh nakem. ");
INSERT INTO amx_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Yep-yep tjengenh mapel yengenh arratj alhengk-awem, tjeng inang kaltj wart. Yeng ineh kaltj. Yeng ineheng arrwekel alhem, inang tjengeng anharrel petjem. ");
INSERT INTO amx_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Thang inenh iteth-ilem, inang tjengel-ayeng kwetant iteth anetjenh. Inang itja kwetant ilwetjenh. Arrpenhel inenh itja tjengeng raketjenh. ");
INSERT INTO amx_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Angey tjengenhel tjeng yep-yep map anthek. Rang arrentjeng-arlk twer-lkwer anem. Arrpenhel inenh ywarn kwet Angeyeng raketjenh. ");
INSERT INTO amx_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Angey ilernak nyent kwet anem.” ");
INSERT INTO amx_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Tjerrtj inang angketj kwerenheh ahentj-kweny awelhek. Inang irntang inek, irntel renh wetjeh anek, renh irrernng atwetjeh. ");
INSERT INTO amx_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jesu-el inenh ilek, “Angeyel yengenh twernekarl wart, thang tjerrtj mapeng alngetherr twer angerr-akertel wenh-wenh mpwarek. Thang lakenh mpwarek map-ingar. Thang tjerrtj irlkert map mwerr-ilek, arrpenh-ingar thang arrentj map alharlkwek. Wenheng arrantherr tjeng mwekenh-irrem, yengenh irntel wetjeh arrantherr ahentj-anem?” ");
INSERT INTO amx_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Inang renh ilek, “Nwern ngwenh itja pelkel irntel iltewetjeh ahentj-anem, ntwang mwerr mpwarekarl-penheh. Nwern ngwenh irntel iltewetjenh, ntwang Altjerr renh arrampewekarl-penh! Ntwang kwenh tjerrtj war, kenh ntwang lyet ilelhek, ntwang kwel Altjerr anem.” ");
INSERT INTO amx_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesu-el inenh ilek, “Angketj nhenh Altjerr-henh pipel-ayeng intem, ‘Arrantherr altjerr yeng-arteh anetjek.’ ");
INSERT INTO amx_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Lakenh Altjerr twernk angerrepat arrehantherr-henh-warn angkek. Rang inenh ilek, ‘Arrantherr altjerr anem.’ Altjerr kwenh itja rrtjwerrem. ");
INSERT INTO amx_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Rarrp yengenh ngakek, ahelh nhenh-warn lanthetjeh-anngernt. Yeng arrehantherr ilelhek, ‘Yeng Altjerr-henh Ler rang anem.’ Wenheng arrantherr tjeng ahang-irrem, thang kwel Altjerr renh arrampewek-arleng? ");
INSERT INTO amx_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Yeng apek Angey tjengenheh itja kangkwerremeng, itja rrkwapentj kwerenh mpwaremeng, arrantherr yengenh itja naketjeh. ");
INSERT INTO amx_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Yeng kwenh Angey tjengenheh kangkwerrem, arrantherr yengenh nakemer. Yeng kaltj, arrantherr itja yengenh nakem. Arrantherr Angey renh nakem key? Rang yengenh twer-ilek, twer mpwaretjeh angerr anthwerr. Arrantherr twer tjengenh aremeng kaltj anemer, Angey rang tjengel-arleng kwet anem, yeng Angeyel-arleng kwet anem.” Lakenh Jesu rang ilelhek. ");
INSERT INTO amx_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Inang weth ahentj-anek, renh antwerrketjeh. Rang rlkwerr-angkwerr rwerrenhek. ");
INSERT INTO amx_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Kwer-penh Jesu kwertengerl kwerenh map-akert Jordan kwatj ulpay-angkwerr anper kwet alhek. Inang keth nheng kwer-warn alhek, kwerel John-el arrwekel tjerrtj map kwatj-warn irrpelh-ilemel baptise-em-iletjamarl. Mer kwerel inang anetj-alpek kwek war. ");
INSERT INTO amx_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Tjerrtj map Jesu kwer-warn petjek. Inang pawenherrek, “John-el itja twer angerrel mpwarek. Angketj nhenh John-el nwernenh Jesu-penh ilekarl, angketj nhenh arratj-irremel keth-irrekemeh.” ");
INSERT INTO amx_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Tjerrtj arrpenh mapel Jesu renh nakewarrek, kenh tjerrtj rrpwetjel itjarl. Mer-areny arrpenh mapel Jesu renh aretj-alhek, inang renh kwetemeh nakek. ");
INSERT INTO amx_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Artwang Lazarus irlkert-irrek, rang Bethany town-areny anek. Kwerenh angkwer atherr Mary Martha thwen town alenh kwer-areny anek. Mary nhenhel kwenh Jesu-henh ingkang anter npwang mwerrel theletjenharl-anngernt. Rang renh kapert kwerl kwerenhelemeh ingkang renh arnngelhetjenharl. ");
INSERT INTO amx_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Mary-el Martha-el thwen angketj urrpey lanthek Jesu-warn ateng-iletjeh, “Ngkartay, peltj ngkwengenh irlkert-irrek.” ");
INSERT INTO amx_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesu-el angketj nhenh awek. Rang angkek, “Lazarus kwel irlkert-irrekaw. Rang itja kwet ilwetjenh. Rang irlkert-irrek, tjerrtj mapel Altjerr Ler kwerenh thwen naketjenheng.” ");
INSERT INTO amx_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesu angkwerenheng-atherrek Martha-ek Mary-ek tjey kwer-atherrenh Lazarus-ek thwen nyerrkek. ");
INSERT INTO amx_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Kwer-penh Jesu rang atherr-ingar antarl-irrek. ");
INSERT INTO amx_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Kwer-penh rang kwertengerl kwerenh map ngwek, “Mpa, nwern mer Judea-warnemeh angkep alpey.” ");
INSERT INTO amx_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Kwertengerl inang renh ilek, “Kaltj-anthenh-anthenhay! Angwerreh war tjerrtj Jew map ngkweng palenthwek, ngwenh irntel iltewetjeh. Ntwang kenh alpetjeharl angkem!” ");
INSERT INTO amx_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesu-emeh angkek, “Parrtj angerr anem kweny-rtweheng-ntjel angwerr-angwerreh-atwetj. Tjerrtj ngwenh apek parrtjel nthwerl-apetjeh, rang mwerr aretjenh. Rang itja ahern-warn anyetjenh. ");
INSERT INTO amx_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Tjerrtj ngwenh apek kwenyel nthwerl-apem, rang ywarn arem. Renh kel arnel-arlk arlkwatetjenh.” Jesu rang iter-angkwerr angkek, rang kwenh parrtj anem. ");
INSERT INTO amx_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Kwereng Jesu-el inenh ilek, “Peltj Lazarus ankwang war intem. Yeng kel nhenh kwer-warn alhem, renh kemelh-iletjeh.” ");
INSERT INTO amx_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","13","Kwertengerl inang iterl-arek, Jesu-el inenh ilek, Lazarus rang kwel ankwang intemarl. Kenh Jesu-el inenh iter-angkwerr iletjam, Lazarus rang arrwetj intemarl. Kwertengerl mapel renh ilek, “Ngkartay, rang apek ankwang intemarl, rang kel mwerr-irretjenh.” ");
INSERT INTO amx_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Lakenh Jesu-el inenh keth ilek, “Lazarus kwenh ilwek. ");
INSERT INTO amx_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Yeng itja kwerel-ayel anek, nheng rang ilwekarl. Nhenh mwerr arrehantherr anem, arrantherr alhengk-aretjeh. Ngwenth war yengenh arrantherr naketjenh. Mpa, nwern kwer-warn alheyemeh.” ");
INSERT INTO amx_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Thomas kwertengerl arrpenh rang anek. Rang kwertengerl arrpenh map ilek, “Nwern kel ilwetjeh-anngernt wart alhey kwerel-ayel!” Thomas arreny arrpenh kwerenh anek Tjew-atherr. ");
INSERT INTO amx_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jesu rang kel mer kwek Bethany-ek itwekemeh irretj-alhek, kwertengerl kwerenh map-akert. Rang awek, Lazarus rang kel arltang 4 irrernng intek. Inang arrwekel renh intey-warn kwernewarrek. ");
INSERT INTO amx_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Mer Bethany rang Jerusalem-eng angath anek, 3 kilometres. ");
INSERT INTO amx_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Tjerrtj map anthwerr Martha Mary thwen angkwerenheng-atherr-warn lharrp petjek Jerusalem-eng, renh-atherrenh alngwelng-ilemel tjep-tjep-iletjeh. ");
INSERT INTO amx_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Arrpenh mapel-anem ilek Martha renh, Jesu rang angath petjerleh. Martha-emeh kwer-warn arnekarner alhek. Mary rang merel antarl-irrek. ");
INSERT INTO amx_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martha-el Jesu renh ilek, “Ngkartay! Ntwang parrp petjemer, tjey tjengenh itja ilwemer. ");
INSERT INTO amx_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ntwang lyet Altjerr pawenhetjeh. Yeng kwenh kel kaltj, rang ngwenh kel awetjenheng. Ntwang renh pawenhetjeh, rang kel mpwaretjenheng.” ");
INSERT INTO amx_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesu-el renh ilek, “Tjey ngkwengenh iteth-irremel kemerretjenh.” ");
INSERT INTO amx_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martha-el renh ilek, “Yeng kel kaltj, rang kemerretjenh arltang ingkernel, Altjerrelarl tjerrtj map ingkerrek kemelh-iletjenh.” ");
INSERT INTO amx_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesu-el renh ilek, “Tharrp tjerrtj irrernng map iteth-ilem. Tjerrtj kwenh ilwetjenh. Kenh tjerrtj ngwenhel apek yengenh nakem, inang iteth kwet anetjenh. ");
INSERT INTO amx_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Inang itja irrernng kwet intetjenh. Ntwang key angketj nhenh nakem?” ");
INSERT INTO amx_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Martha-el renh ilek, “Arratj, Ngkartay. Thang ngwenh nakem. Ntwang Christ rang anem, Altjerr-henh Ler. Altjerrel angerrepat map nwern-henh ngkwey alhelekarl, rang Ler kwerenh tjerrtj ahelh-areny ingkerrek-warn lanthetjenharl.” ");
INSERT INTO amx_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Martha lakenh angkekarl-penh, rang warl kwerenh-warn angkep alpek. Rang tjey kwerenh Mary renh intert-intertel war ilek, “Kaltj-anthenh-anthenh rang kel petjek. Rang ngkweng ntangkelhek.” ");
INSERT INTO amx_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mary-el renh awemel parrp kemerrek, Jesu-warn arnekarner alhek. ");
INSERT INTO amx_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesu rang itja-antey town kwek kwer-warn petjek. Rang keth kwerel-antey anetjam, kwerelarl rang Martha-el-ayeng angkekarl. ");
INSERT INTO amx_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Tjerrtj map inang Mary-henh merel anek, inang renh alngwelng-ilemel tjep-tjep-iletjeh. Inang arek, rang parrp kemerrentjek, keth-warn arratenhek, inang iterrek rang kwel intey-warn alhemarlengeh-athen, arnetjeh. Lakenh inang anharrel ingkern alhek. ");
INSERT INTO amx_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mary rang Jesu-warn petjek. Rang kwereng ularr amperel-ayeng arrernelhek. Rang renh ilek, “Ngkartay! Ntwang apek nhenhel anemer, tjey tjengenh kwenh itja ilwemer. Itja.” ");
INSERT INTO amx_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesu-el Mary arek arnerleh. Tjerrtj arrpenh map thwen akay arnek. Rang rrwampey awelhek. ");
INSERT INTO amx_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Rang inenh pawenhek, “Nthenheham arrantherr irrernng renh arrernek?” Inang renh ilek, “Ngkartay, petjang aretjeh.” ");
INSERT INTO amx_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesu-emeh arnek. ");
INSERT INTO amx_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Tjerrtj mapel renh aremel ilerrek, “Arerrerrang, rang kwenh Lazarus-ek nyerrkek angerr anthwerr.” ");
INSERT INTO amx_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Rrpwetj arrpenhel lakenharl ilerrek, “Rang kwenh artwang pweng nheng-henh anngang mwerr-ilekarl. Rang apek irrernng nhenh renh arrwekel kwet mwerr-ilemer!” Lakenh inang pwer anemel angkek. ");
INSERT INTO amx_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jesu lharrp kwet awelhemel alhek. Rang intey-warn alhek. Intey rang anek irntang angerrelarl martekarl. ");
INSERT INTO amx_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesu-el inenh ilek, “Irntang renh arnangelh-ilang!” Martha rang renh ilek, “Ngkartay! Rang kel intertemeh intjem. Rang kwenh arltang 4 arrwetj intekarl!” ");
INSERT INTO amx_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesu-el renh ilek, “Thang ngwenh nheng ilek, ntwang yengenh nakemer. Ntwang aretjenh, Altjerr rang alker-areny anthwerr anemarl, twer anthwerrel mpwarerleh.” ");
INSERT INTO amx_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Inang irntang angerretj renh arnangelh-ilek. Jesu rang alker-warn-athek arek. Rang angkek, “Angeyay, ntwang yengenh awek, lakenh yeng ngkweng nyerrkem. ");
INSERT INTO amx_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Thang ngwenh kweteth pawenherl-anem. Yeng kaltj, ntwang yengenh kweteth awerl-anem. Thang ngwenh anngetherr pawenhem, tjerrtj nhenh map kaltj anetjenheng, ntwang yengenh lanthekarl.” ");
INSERT INTO amx_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Kwereng Jesu rang arnterrel arlkemel angkek, “Lazarus-ay, arratang!” ");
INSERT INTO amx_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lazarus kel arratekemeh intey kweneng mantarr artaper-ilekarl-akert. Inang arrwekel nheng renh rnwanentjel ayernekarl, iltjang kwerenh ingkang kwerenh ayernekarl. Inang inngerr kwerenh rnwanentj arrpenhel arltwekarl. Jesu-el inenh ilek, “Rnwanentj inenh kwereng kap-rlwerrerrang, rang kethel nthwetjenheng.” ");
INSERT INTO amx_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Tjerrtj map Mary-el-ayel anekarl inang arek, Jesu-el Lazarus renh iteth-ilek. Tjerrtj map angerrel Jesu renh kwet nakek. ");
INSERT INTO amx_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Kenh rrpwetj arrpenh artwang Pharisee map-warn angketj-akert alhek. ");
INSERT INTO amx_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kwereng priest twernk mapel artwang Pharisee mapel thwen Sanhedrin Council inenh arrawelh-ilek. Council inang angkerrek, “Artwang nhenhel twer anthwerrel mpwarek tjerrtj mapeng anngetherr. Nwern-artek renh arnpaketjeh. ");
INSERT INTO amx_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nwern-artek apek renh itja impetjeh, tjerrtj mapel renh nakehetjeng! Rome-areny atwenh-atwenh map petjehetjeng, inang mer nwern-henh church angerr-arlk ingkerrek ulpert-ilehetjeng. Nwern nthakenh irretjenh? Inang nwernenh ingkerrek ywerrelh-ilehetjeng!” ");
INSERT INTO amx_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Priest twernk angerr anek, arreny kwerenh Caiaphas. Rang priest twernk angerr anek year nyent war. Rang inenh ilek, “Arrantherr iterl-aretj-kweny! ");
INSERT INTO amx_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nhenh angerr anem: artwang nyent tjerrtj mapeh tjang-ilwetjeh. Itjeng apek, Rome-areny atwenh-atwenh mapel tjerrtj ingkerrek ywerrelh-ilehetjeng.” ");
INSERT INTO amx_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Rang itja nyentarrp angkek, rang angkek tjerrtj kwerenh mapel-ayeng. Altjerr-henh Kwerrernel-artek renh ilekarl, Jesu rang tjerrtj Jew ingkerrekeh tjang-ilwetjenharl. ");
INSERT INTO amx_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Jesu rang tjerrtj Jew mapeh war itja ilwetjenh kwel, rang Altjerr-henh peltj ilwetjenh, ahelh apanpelarl anem ingkerrekeh. Lakenh rang inenh ingkerrek arraw-iletjenh. ");
INSERT INTO amx_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Arltang lyeteng Sanhedrin Council inang ahentj-anek, Jesu renh irrernng atwetjeh. Inang angkerrek, “Nthakenh nwern Jesu renh irrernng atwetjeh?” ");
INSERT INTO amx_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jesu tjerrtj Jew mapeng alengk-welhek. Rang Ephraim town kwek-warn alhek. Town nhenh rartek rrkwaleng angath war anek. Town kwerel Jesu rang antarl irretj-alhek kwertengerl kwerenh map-akert. ");
INSERT INTO amx_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Kel tjerrtj map mer mapeng arrwekel kwet Jerusalem-warn arraw-irrek. Moses-henh mpwareng-arengel-ayeng angketj anek: inang kwatj-warn-amparr irrpetjeh, inang lhewelhetjeh, tjenkerr arlkwetjenh-anngernt. Tjenkerr arreny kwerenh “Anper Alhekarl” anek. Tjerrtj Jew map irlpangketjart, Altjerrel arrwekeleny map angek mer Egypt-eng. ");
INSERT INTO amx_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Inang Jesu-eh ywarn palenthwek. Inang church angerretj iterel nthwerl-apetjam. Inang pawenherl-apek, lakenh iterl-aremel, “Rang apek tjenkerreh petjehetj.” ");
INSERT INTO amx_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Priest twernk mapel artwang Pharisee mapel thwen tjerrtj map ilekarl, “Arrantherr Jesu renh apek aremarl, nwernenh ilerrerrang. Nwern renh antwerrketjenheng.” ");
INSERT INTO amx_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Arltang 6-penh inang kelant tjenkerr irlpangkemel arlkwetjeh-anngernt, mpank anek. Tjenkerr arreny kwerenh Anper Alhekarl anek. Tjerrtj Jew map irlpangketjart, Altjerrel arrwekeleny map angek mer Egypt-eng. Jesu-emeh Bethany town-warn alpek, kwertengerl kwerenh map-akert. Town nheng-warn Lazarus anetjamarl-warn. Jesu-el nheng renh irrernngeng kemelh-ilekarl-warn. ");
INSERT INTO amx_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Angkwerenheng-atherr Martha Mary atherrel ineh mern tjang-itek. Inang arrernelhek, mern arlkwetjeh. Lazarus rang anek. Kwereng Martha-el mern ineh irrarnpelh-ilemel anthek. ");
INSERT INTO amx_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mary-elemeh tjampet anter npwang mwerr-akert inek. Arrwekel rang anter renh maney angerrel payem-ilek. Kwereng rang tjampet-akert Jesu-warn alhek. Anter renh rang Jesu-henh ingkang-warn thelek. Kwereng rang Jesu-henh ingkang arnngelhek kapert kwerl kwerenhel. Warl kwenelemeh inang npwang renh intjernek. ");
INSERT INTO amx_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Judas Iscariot rang Jesu-henh kwertengerl nyent anek. Rang Jesu renh kelant atwenh-atwenh mapeh anyenng-anyenngel anthetjenharl. Judas rang ahentj-kweny-irremel angkek, ");
INSERT INTO amx_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Marl yanhel anter intjarlkwek! Rang anter renh arrehantherr anthemer, arrantherr renh maney angerreh sell-em-iletjeh. Arrantherr maney inemel inenh tjerrtj mern-kweny rnwanentj-kweny mapeh anthemer, inang mern-arlk rnwanentj-arlk inetjenheng.” ");
INSERT INTO amx_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas rang tjerrtj mern-kweny rnwanentj-kweny mapeh itja lharrp-irrek. Rang ahentj-anek anter-penh maney kwerarrp inetjeh. Rang anyenngalth anek. Tjerrtj map inang Jesu-henh kwertengerl mapeh maney anthetjart. Maney inenhemeh inang Judas renh anthetjart, rang inenh arntarnt-aretjeh kwel. Rang maney nhenheng rwengkel inetjart. ");
INSERT INTO amx_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jesu-el inenh ilek, “Marl renh impay! Rang yengenh anterel pernek, lakenh-arteh inang yengenh pernetjenh, awenng-warn arrernetjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Tjerrtj mern-kweny rnwanentj-kweny map kwenh arrehantherrel-ayeng kweteth anerl-anem. Yeng kenh itjarl arrehantherrel-ayeng kwet anetjenh.” ");
INSERT INTO amx_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Tjerrtj mapel awek, Jesu rang Bethany-el anetj-alhek. Inang petjek, Lazarus-arlk aretjeh. Lazarus nheng Jesu-el renh iteth-ilek arrwetj-penh. ");
INSERT INTO amx_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Tjerrtj arrpenh mapel angketj awek Lazarus-akert. Inang priest mapeng ampakelhek. Inang Jesu-antem nakek. Priest twernk map ahentj-anek, Lazarus renh irrernng atwetjeh, Jesu thwen. ");
INSERT INTO amx_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Tjerrtj map Jerusalem-warn kel arraw-irrek, tjenkerr renh arlkwetjeh. Tjerrtj Jew map irlpangketjart, Altjerrel arrwekeleny map angek mer Egypt-eng. Tjerrtj inang awek, Jesu rang tjenkerr-warn tjeyel petjerleh. ");
INSERT INTO amx_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Inang arnang waly akemel, waly-akert kwer-warn arnek-irrek. Inang arlkerl-apetjam, “Altjerray, nwern ngwenh nakem! Nyerrkentj mernelhang angketj angenh-angenh ngkwengenheh! Rang nwerneh-warn lyet petjem. King nwern-kenh twer-ilang! Ntwang kwer nyerrkentj mernelhang!” ");
INSERT INTO amx_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesu-el tangkey kwek arek, tangkey kwer rang antjek. Angketj nhenh Altjerr-henh pipel-ayel intem, ");
INSERT INTO amx_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Tjerrtj Jerusalem-areny mapay, arrantherr itja ater-irretjeh! Arerrerray, king arrehantherr-henh rang petjem, tangkey kwekel-ayel anerl-aperleh.” Angketj nhenh lyet arratjemeh irrek. ");
INSERT INTO amx_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Kwertengerl mapel Jesu renh aremel, tangkeyel anerl-aperleh, inang Altjerr-henh angketj nhenhek itja irlpangkek. Kelant Altjerrel Jesu renh iteth-ilekarl-penh, Jesu rang alker-warn alpekarl-penh, inang angketj renh alhengk-arekemeh, angketj rang arratjemeh irrek. Angketj nheng Altjerr-henh pipel-ayel intem, king rang tangkey-akert petjetjenharl Jerusalem-warn. ");
INSERT INTO amx_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Tjerrtj nheng map inang Jesu renh arekarl, rang Lazarus renh arrwetjeng iteth-ilek, inang nhenh-penh kwet irlpangketjart. ");
INSERT INTO amx_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Tjerrtj arrpenh map angketj nheng kwer-penh inang awek, inang Jesu-warn pwert arnek-arner alhek. ");
INSERT INTO amx_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Kwereng artwang Pharisee map angkerrek, “Nwern kwenh renh ywarn arnpakek! Nthakenham nwern irretjenh? Lyet tjerrtj ingkerrekemeh kwereng anharrel alhem!” ");
INSERT INTO amx_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Tjerrtj Greece-areny rrpwetj Jerusalem-el yatjarr petjek, inang petjekarl tjenkerr arlkwetjeh, Altjerr kwer kangkemel. Tjenkerr arreny kwerenh Anper Alhekarl. ");
INSERT INTO amx_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Philip rang anek. Philip rang artwang Bethsaida-areny anek. Bethsaida town rang mer Galilee-el anek. Tjerrtj alethang nheng inang Philip kwer-warn alhek, pawenhetjeh-amparr. Inang Philip renh pawenhek, “Twernkay! Nwern ahentj, Jesu renh aretjeh.” ");
INSERT INTO amx_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Philip rang Andrew kwer-warn-amparr alhek. Kwereng ratherr Jesu-warn urrpey alhek, renh iletjeh. ");
INSERT INTO amx_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesu rang kwewaleny ilelhek, “Arltang tjengenh angathemeh irrerl-apem, Angey tjengenhel tjerrtj ingkerrekeh mernetjeh, Tjerrtj-henh Ler rang alker-areny anthwerr anemeng, twer angerr-akert. ");
INSERT INTO amx_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Thang arrantherrenh angketj tjeperr ilem anngang-penh. Tjerrtjel ipert inyemel wheat anngang aherneh arrernemel arltwem. Kwereng wheat anngang rang ilwem-amparr. Arnamek-amparr lyapem kwek war anngang kwereng. Kwereng arnam rang annga-akert-irrem. Lakenh anngang nyent ilwemeng, kwereng anngang map-anem-irrem. Anngang nyent ilwetj-kwenyeng, rang nyent kwetarl anem, ywarn anngang map-akert irrem. ");
INSERT INTO amx_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Lakenh-arteh tjerrtj ngwenh apek athek-irrem kwewaleny war iterremel, ahelh nhenh-areny war iteth anetjeh, inang kwetant ilwetjenh. Kenh tjerrtj inang itja athek-irrem ahern nhenhel iteth anetjeh, inang iteth ngampekarl anetjenh. ");
INSERT INTO amx_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Tjerrtj ngwenh apek ahentj-anem tjeng kangkwerretjeh, inang kel tjengeng anharrel petjetjeh. Kwereng inang tjengel-ayel kwet anetjenh. Tjerrtj inang tjeng kangkwerremeng, Angey tjengenhel inenh naketjenh.” ");
INSERT INTO amx_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Jesu kwertengerl kwerenh mapek ilelhek, “Yengan lyet lharrp awelhem. Yeng iterrem, nthakenh yeng Altjerr-warn angketjenh. Yeng itja lakenh angkem, ‘Angeyay, yeng itja ahentj-anem, irlkert angerr inetjeh.’ Lakenheh kwel yeng ahelh nhenh-warn petjek. ");
INSERT INTO amx_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Angeyay, ntwemeh tjerrtj ingkerrekeh mernelhay, ntwang alker-areny anthwerr anemarl, parrtj angerr-akert.” Altjerrel alkereng tjernek, “Yeng kel mernelhek, yeng alker-areny anthwerr anemarl, twer angerr-akert. Yeng weth mernelhetjenh!” ");
INSERT INTO amx_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Tjerrtj inang awek, arrpenh angkemarl-arteh. Arrpenh map angkek, “Angel alker-areny-artek kwer-warn angkek.” Kenh arrpenh map angkek, “Kwatj angkemeng awerrerrang!” ");
INSERT INTO amx_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jesu-el inenh ilek, “Altjerr rang itja tjeng-warn angkem, rang arrehantherr-warn angkek. ");
INSERT INTO amx_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Lyet Altjerrel tjerrtj ahelh-areny judge-em-iletjenh, mwerr map anetj mapeng ngakemel. Lyet Altjerrel ahelhek-artwey arrentj renh anpwetjenh. ");
INSERT INTO amx_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Kelant inang yengenh tjwenetjenh aherneng, tjerrtj ingkerrek tjeng-warn arraw-irrentjem.” ");
INSERT INTO amx_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Rang lakenh angkek, inang kaltj anetjenheng, rang ntwerlkel ilwetjenharl. ");
INSERT INTO amx_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Tjerrtj inang lakenh ilek, “Angketj nhenh Altjerr-henh pipel-ayel intem, ‘Christ rang iteth kwet anetjenharl.’ Nthakenham ntwang ilem, ‘Inang Tjerrtj-henh Ler renh tjwenetjenharl.’? Ngwenham Tjerrtj-henh Ler rang anem?” ");
INSERT INTO amx_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesu-el inenh ilek, “Kwek war parrtj rang arrehantherrel-ayeng anetjenh. Parrtj-antem anemarleng nthwerl-apang kweny-irrehetjeng-athath. Tjerrtj ngwenh apek kwenyel nthwem, rang pal-pal war nthwerl-apem. ");
INSERT INTO amx_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Arrantherr renh naketjeh, nheng rang arrehantherr parrtj anemarl. Kwereng arrantherr parrtj kwer ler map anetjenh.” Kwer-penh Jesu alhek tjerrtj mapeng alengk-welhemel. ");
INSERT INTO amx_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesu-el arrwekel kwet rrkwapentj kwerenh mpwaretjam twer kwerenhel tjerrtj mapel-ayel. Tjerrtj inang kenh renh itja kwet nakek. ");
INSERT INTO amx_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Altjerr-henh angketj angenh-angenh nheng Isaiah rang arrwekel-antey angketj pip-warn arrernek. Angketj nhenh arratjemeh irremel arlpaw-irrek. “Ngkartay, tjerrtj ngwenhelam angketj nwern-henh nakek? Itja kwenh! Tjerrtj ngwenhel renh alhengk-arek, Ngkart rang twer anthwerrel mpwaremeng? Itja kwenh!” ");
INSERT INTO amx_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Tjerrtj inang Jesu renh ywarn nakek. Isaiah-el angketj arrpenh nhenh pip-warn arrernek, ");
INSERT INTO amx_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Altjerrel anngang tjerrtj map-henh pweng-ilek, inang anngang inehenhel arehetj. Rang iterrentj inehenh perrpert-ilek, inang arratj iterl-arehetj. Kwereng inang twep-irrehetj, Altjerrel inenh mwerr-ilehetj.” ");
INSERT INTO amx_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaiah rang arrwekel kwet kwerrern-angkwerr arek, Jesu rang alker-areny anthwerr anerleh, parrtj angerr-akert. Rang ilek arrwekel kwet Jesu-akert. ");
INSERT INTO amx_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Tjerrtj twernk arrpenh mapel Jesu renh nakek. Kenh inang itja ilelhek, inang renh nakemarl, artwang Pharisee mapel inenh church-eng alharlkwehetjeng. ");
INSERT INTO amx_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Twernk inartek angerr ahentj-anek, tjerrtj mapel inenhant naketjeh. Inang kwek war ahentj-anek, Altjerrel inenh naketjeh. ");
INSERT INTO amx_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesu-el inenh wentarel ilek, “Tjerrtj ngwenhel apek yengenh nakemarl, inang Altjerr renh nakem. Altjerr rang yengenh lanthek-arleng wart. ");
INSERT INTO amx_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Tjerrtj ngwenhel apek yengenh aremel alhengk-arem, inang Altjerr renh aremel alhengk-arem. Altjerr rang yengenh lanthek-arleng wart. ");
INSERT INTO amx_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yeng ahelh nhenh-warn petjek, tjerrtj ingkerrekeh parrtj anetjeh. Lakenheng tjerrtj ngwenhel apek yengenh nakemarl, inang itja weth kwenyel-arteh anem. ");
INSERT INTO amx_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Tjerrtj ngwenhel apek angketj tjengenh awemarl, inang angketj kwer itja kangkwerrem, thang inenh itja judge-em-iletjenh. Yeng kwenh petjek, tjerrtj ahelh-areny map anetjeng twepelh-iletjeh. Yeng itja ahentj-anem, inenh judge-em-iletjenh. ");
INSERT INTO amx_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Tjerrtj ngwenh apek tjeng ahentj-kweny anemarl, inang angketj tjengenh itja nakem, inenh Altjerrel judge-em-ilemel anpwetjenh arltang ingkernel. ");
INSERT INTO amx_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Angketj tharl arrantherrenh ilem, itja angketj tjengenh anem. Angey rang yengenh arrehantherr-warn lanthekarl, rang yeng twernek, angketj nhenh arrantherrenh iletjeh. ");
INSERT INTO amx_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Yeng kaltj, angketj kwerenhel tjerrtj iteth-ilem, inang kwetant iteth anetjeh. Lakenheng thang angketj kwerenhant arrantherrenh ilem.” ");
INSERT INTO amx_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Arltang irlpangkentj rang mpank anek. Arreny kwerenh Anper Alhekarl. Tjerrtj Jew map irlpangketjart, Altjerrel arrwekeleny map angek mer Egypt-eng. Jesu kel kaltj anek, lyet-atheh war rang ahelh nhenheng Angey-warn alpetjeh-anngernt. Rang nakenh-nakenh kwerenh mapeh nyerrkek. Rang ineh kwet nyerrkek, rang ilwetjeh-atwetj. ");
INSERT INTO amx_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Angwerr-angwerr Jesu kwertengerl kwerenh map-akert arraw-irrek, mern arlkwetjeh. Arrentjel-artek arrwekel-antey Judas kel twernekarl, Judas-el Jesu renh artwang atwenh-atwenh mapeh anyenng-anyenngel anthetjeh-anngernt. Judas nheng rang Simon Iscariot-henh ler anek. ");
INSERT INTO amx_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesu rang kaltj anek, Angeyelarl renh twer-ilek, rang twernk angerr tjerrtj kwerenh mapeh anetjeh. Rang kaltj anek, rang Altjerreng petjekarl, rang angkep Altjerr-warn alpetjenharl. ");
INSERT INTO amx_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Inang mern arlkwetjam-rlwer, Jesu rang kemerremel mantarr kern-penh kwerenh rang rlwelhek. Rang towel inemel, kwerel ayernelhek-amparr. ");
INSERT INTO amx_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Rang kwatj rnwang-warn thelek, kwereng rang kwertengerl kwerenh mapeh nyentam-nyent-henh ingkang lhewek, towel kwerel rang ingkang inehenh arnngelhek. ");
INSERT INTO amx_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Rang Simon Peter-henh ingkangeh lhewetjeh ahentj-irrek. Peter angkek, “Ngkartay, yeng ahentj-kweny, ntwang yeng ingkang lhewetjeh!” ");
INSERT INTO amx_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesu-el renh ilek, “Ntwang lyet itja iterrem, thang ingkang ngkwengenh lhewetjeh. Kelant ntwang kaltj-irretjenh.” ");
INSERT INTO amx_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Peter-el renh arnpakek, “Ntwang itja ingkang tjengenh lhewetjeh!” Jesu-el renh ilek, “Thang apek ngwenh lhewetj-kweny, ntwang kwenh itja peltj tjengenh anetjenh!” ");
INSERT INTO amx_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Peter kwer-warn angkek, “Ngkartay, itja ingkang tjeyenhant lhewetjeh, iltjang inngerr tjengenh-arlk lhewetjeh!” ");
INSERT INTO amx_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesu-el renh ilek, “Tjerrtj ngwenh apek rang lhewelhekarl, rang ulpert-kweny anem. Kel ingkang kwerenhant weth ulpert-irrem. Thang kwenh arrantherrenh kel lhewek. Arrantherr ulpert-kweny anem. Artwang nyent war ulpert-akert kwet anem.” ");
INSERT INTO amx_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesu rang kel kaltj anek artwang kwer, rang renh atwenh-atwenh mapeh anyenng-anyenngel anthetjeh-anngernt. Lakenheng rang ilek, “Artwang nyent war ulpert-akert kwet anem.” ");
INSERT INTO amx_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jesu kel ingkang inehenh lhewekarl-penh, rang weth mantarr kern-penh kwerenheh irrpek. Rang arrernelhek, inenh pawenhek, “Wenheng thang ingkang arrehantherr-henh lhewek? ");
INSERT INTO amx_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Arrantherr yengenh ilem, yeng kaltj-anthenh-anthenh anemeng, Ngkart thwen. Lakenh arrantherr arratj ilem. ");
INSERT INTO amx_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Yeng kaltj-anthenh-anthenh arrehantherr-henh anem, Ngkart thwen. Thang ingkang arrehantherr-henh lhewek. Lakenheng arrantherr nyentam-nyentel arrpenh-henh ingkang lhewetjeh. ");
INSERT INTO amx_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Yengarl arrehantherr mernelhekarl-arteh, lakenh arrantherr tjerrtj arrpenheh mernelhetjeh. ");
INSERT INTO amx_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Thang arrantherrenh nhenh arratj ilem, rrkwapenh-apenh ngwenh apek inang itja twernk inehenheng angerr anem. Thang angketj arrpenh nhenh ilem. Urrpey ngwenh apek inang itja angerr anem, tjerrtj kwereng rang inenh lanthekarl. ");
INSERT INTO amx_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Arrantherr angketj tjengenh kel awek. Arrantherr angketj tjengenheh kangkwerrem apek, kwereng arrantherr arrken anetjenh. ");
INSERT INTO amx_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Yeng tjerrtj nyent-akert war angkem. Thang arrantherrenh alhengk-arem. Kenh arrehantherreng tjerrtj nyent anetj anem. Rang yengenh atwenh-atwenh map-warn anyenng-anyenngel anthetjenh. Rang yengenh atwenh-atwenh mapeh anthemarleng, angketj nhenh Altjerr-henh pipel-ayeng intemeng, arratjemeh irremel arlpaw-irretjenh, ‘Artwang nyent rang nwernehel-ayeng mern arlkwem, rang kwenh tjengeng ntjwem-irrek.’ ");
INSERT INTO amx_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","“Thang arrantherrenh nhenh arrwekel ilem, kwereng nhenh arratj-irremarleng, arrantherr kaltj anetjenh, Altjerr-henh angketj nhenh tjeng-akert angkemeng, arrantherr yengenh naketjenheng. ");
INSERT INTO amx_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Angketj nhenh awerrerrang. Tjerrtj ngwenh apek urrpey tjengenheh kangkentj mernelhemeng, inang tjeng kangkentj mernelhem. Tjerrtj ngwenh apek tjeng kangkentj mernelhem, inartek Altjerr kwer kangkentj mernelhem. Altjerrel yengenh lanthek.” ");
INSERT INTO amx_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jesu lakenh angkekarl-penh rang rrwampey awelhek. Rang inenh ilek, “Arratj anthwerr, kwertengerl nyentel yengenh atwenh-atwenh mapeh anyenng-anyenngel anthetjenh.” ");
INSERT INTO amx_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Kwertengerl inang ywarn iterremel, patemel arerrek. Inang pawenherrek, “Ngwenheh rang angkem?” ");
INSERT INTO amx_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Kwertengerl arrpenh kwerarl Jesu angerr nyerrkek, rang Jesu-eng rtwang anek. ");
INSERT INTO amx_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Peter kwertengerl kwer iltjerrek, rang Jesu renh pawenhetjeh, “Ngwenheham ntwang angkem?” ");
INSERT INTO amx_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kwertengerl rang Jesu-warn angath-irremel pawenhek, “Ngkartay! Ngwenheham ntwang angkem?” ");
INSERT INTO amx_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesu-el kwertengerl renh ilek, “Artwang kwerarl kwey thang mern ngkweltj nhenh ker kwatj arwek-wemel anthetjenharl, ntwang alhengk-aretjenh, artwang rang-athew anem.” Kwereng Jesu-el mern ngkweltj arwek-wemel Judas-eh anthek. Judas rang Simon Iscariot-henh ler anek. ");
INSERT INTO amx_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas-el wart mern renh inek, kel arrentj rang kwer-warn irrpek. Jesu-elemeh Judas renh ilek, “Wenh apek ntwang mpwaretjeh ahentj, kel alhang!” ");
INSERT INTO amx_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Kwertengerl map inang Jesu-henh angketj itja alhengk-arek. ");
INSERT INTO amx_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas-el nheng maney inehenh anyenetjart. Kwertengerl arrpenh map iterrek, Jesu-el kwel renh ilemeng, tjenkerreh mern inetjeh. Kenh kwertengerl arrpenh map inang iterrek, rang kwel Judas renh lanthek, tjerrtj rnwanentj-kweny map ineh maney anthetjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas-el mern ngkweltj renh inemel-arteh, rang keth-warn arratemel alhek. Kel kwenyemeh anek. ");
INSERT INTO amx_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas kel alhekarl-rlwer, Jesu-el inenh ilek, “Lyet Altjerrel keth-ilem, Tjerrtj-henh Ler rang alker-areny anthwerr anemeng, twer angerr-akert. Ler nhenhel-arleng Altjerr rang mernelhem, rang alker-areny anthwerr anemeng, twer angerr-akert wart. ");
INSERT INTO amx_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ler nhenhel tjerrtj map mernem, Altjerr rang alker-areny anthwerr anemeng. Altjerrel tjerrtj map mernem, Ler rang alker-areny anthwerr anemeng, ngwenth-lkwer. ");
INSERT INTO amx_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Kwer tjengenh mapay! Yeng kwek waremeh arrehantherrel-ayeng anetjenh. Kwereng arrantherr tjeng palenthwetjenh, arrantherr yengenh itja aretjenh. Thang nheng tjerrtj map ilekarl, thang nhenh arrantherrenh weth ilem, ‘Yeng mer arrpenh-warn alhetjenh, arrantherr kwer-warn ywarn alhem.’ ");
INSERT INTO amx_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","“Thang arrantherrenh mpwareng-areng lyetenyemeh ilem, yengarl arrehantherr nyerrkekarl-arteh, lakenh arrantherr ularrek-ularr nyerrkentj mernelhetjeh. ");
INSERT INTO amx_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Arrantherr ularrek-ularr nyerrkentj mernelhemeng, lakenh tjerrtj ingkerrekel alhengk-aretjenh, arrantherr nakenh-nakenh tjengenh anemeng.” ");
INSERT INTO amx_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Peter-el Jesu renh pawenhek, “Ngkartay, nthenh-warnam ntwang alhetjenh?” Jesu-el renh ilek, “Mer kwer-warn yeng alhetjenh, ntwang lyet ywarn tjeng anharrel petjem. Kelant ntwang tjengel-ayeng anharrel petjetjenh.” ");
INSERT INTO amx_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Peter-el renh weth pawenhek, “Ngkartay, wenhengarl yeng lyet ngkwengeng ywarn anharrel alhetjenh? Yeng kel ngkweng tjang-ilwemer!” ");
INSERT INTO amx_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesu-el Peter renh pawenhek, “Arratj key ntwang tjeng tjang-ilwetjenh? Peter-ay, arratj anthwerr, tjwek-tjwek rrwey rang arlketj-kwenyeng-antey, ntwang yengenh kel rrpwetj-ingar ywep-arrernetjenh.” ");
INSERT INTO amx_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesu-el kwertengerl kwerenh map ilek, “Arrantherr itja lharrp awelhetjeh. Altjerr renh nakewarrang, yeng thwen. ");
INSERT INTO amx_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Angey tjengenh-henh mer angerretj anthwerr. Yeng itja rrtjwerrem, yeng arratj angkem. Yeng alpetjenh, arrehantherr nyentam-nyenteh mer mpwaretjeh. ");
INSERT INTO amx_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Kwer-penh yeng petj-alpetjenh, thang arrantherrenh ngwerl-alpetjenh. Arrantherr tjengel-ayeng kwet anetjenheng Angey tjengenh-henh merel. ");
INSERT INTO amx_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Tjey rang Angey-henh mer-warn intenhem, kwer arrantherr kaltj.” ");
INSERT INTO amx_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Kwertengerl nyent arreny kwerenh Thomas rang renh pawenhek, “Ngkartay, nwern-artek mer kwer akwen. Tjey nthenhelam nwern alhetjenh?” ");
INSERT INTO amx_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesu ilelhek, “Yeng kwenh tjey rang anem. Thang angketj arratj ingkerrekeh kaltj-anthem. Thant tjerrtj inenh iteth-ilem, mwerr anetjeh. Tjeng-kwenyel tjerrtj inang Angey-warn ywarn alhem. ");
INSERT INTO amx_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Arrantherr apek yengenh arratj alhengk-arek-arleng, arrantherr kwenh Angey tjengenh alhengk-aretjeh. Lyet arrantherr kel kwer kaltjemeh anem, arrantherr renh kel arek-arleng wart.” ");
INSERT INTO amx_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Kwertengerl arrpenhel arreny kwerenh Philip-el renh pawenhek, “Ngkartay, nwern ahentj-anem Angey renh aretjeh. Kel renhant nwerneh mernang, nwern kwer kangketjeh wart!” ");
INSERT INTO amx_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesu-el renh ilek, “Philip-ay, yeng kwenh kwet anentjekarl arrehantherrel-ayel. Kenh ntwang yengenh itja alhengk-arem! Tjerrtj ngwenhel apek yengenh arekarl, inartek Angey renh arek. Wenheham ntwang yengenh pawenhem, thang Angey renh arrehantherr mernetjeh? ");
INSERT INTO amx_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Wenhengam ntwang angketj tjeyenh itja nakem, yeng kwenh Angeyel-ayeng anem, Angey rang tjengel-ayeng anem, Angey ilernak kwenh nyent anem? Angketj tjengenh angketj kwerenh anem. Angey rang tjengel-ayeng arrehantherr-warn angkem. Lakenh ilernak pwert rrkwapem. ");
INSERT INTO amx_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Angey rang tjengel-ayeng kwet anem, yeng kwerel-arleng kwet anem, Angey ilernakemeh pwert anem, arrantherr angketj nhenh naketjehant. Itjeng apek, arrantherr rrkwapentj tjengenh-penh irlpangkemel yengenh naketjeh. ");
INSERT INTO amx_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Arratj anthwerr, tjerrtj ngwenhel apek yengenh nakemeng, inang twerel mpwaretjeh, thang mpwarem-arteh. Inang twer angerr-akertel mpwaretjeh, yeng Angey tjengenh-warn alpemarl-rlwer. ");
INSERT INTO amx_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Arrantherr apek yeng pawenhemeng arreny tjengenhel-ayeng, wenheh apek, thang arrehantherr mpwaretjenh. Lakenh thang tjerrtj ingkerrekeh mernetjenh, Angey tjengenh rang alker-areny anthwerr anemeng, twer angerr-akert. ");
INSERT INTO amx_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Arrantherr apek arreny tjengenhel pawenhemeng, thang kel arrantherrenh awetjenh, thang lakenh arrehantherr mpwaretjenh.” ");
INSERT INTO amx_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Arrantherr apek tjeng nyerrkem, arrantherr tjeng kangkwerretjeh. ");
INSERT INTO amx_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Thang Angey pawenhetjenh, rang Ilperrepwentj renh arrehantherr-warn lanthetjenheng, arrantherrenh arntarnt-aretjeh. Rang rlkwatherr arrehantherrel-ayeng kwet anetjenh. ");
INSERT INTO amx_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Kwerrern nhenh rang arrehantherr arratj mernem. Tjerrtj ahelh-areny inang Kwerrern Alngaltar renh itja arem, inang akwen kwer anem. Lakenh inang Kwerrern kwer ahentj-kwenyarl anem. Arrantherr kenh kwer kaltjarl, rang arrehantherrel-ayeng kwet rlkwerrel anetjenh. ");
INSERT INTO amx_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Yeng alpetjeh angkem. Thang arrantherrenh itja lhamp-arteh imperl-alhetjenh. Yeng weth arrehantherr-warn petj-alpetjenh. ");
INSERT INTO amx_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ngwenth war tjerrtj ahelh-areny mapel yengenh itja weth aretjenh. Arrantherr kenh yengenh weth aretjenh. Yeng iteth kwet anemeng, lakenheng arrantherr iteth kwet anem. ");
INSERT INTO amx_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Kelant arrantherr kaltj anetjenh, yeng Angeyel-arleng pwert kwet anemeng. Arrantherr kaltj anetjenh, arrantherr tjengel-ayeng kwet anem, yeng arrehantherrel-ayeng kwet anem. ");
INSERT INTO amx_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Tjerrtj ngwenh apek tjeng nyerrkem, inang angketj tjengenheh kangkwerrem. Angey tjengenh rang ineh nyerrketjenh. Yeng ineh nyerrkentj mernelhetjenh.” Lakenh Jesu-el inenh ilek. ");
INSERT INTO amx_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Kwertengerl arrpenh anek, arreny kwerenh Judas. Itja Judas arrpenh nheng, rang Jesu atwenh-atwenh mapeh anthetjenharl, Judas nhenh mwerr. Judas-el Jesu renh pawenhek, “Ngkartay, nthakenharl ntwang nwernehant mernelhetjenh? Wenh-apert tjerrtj arrpenh mapeharl ntwang mernelhetj-kweny?” ");
INSERT INTO amx_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesu-el renh ilek, “Tjerrtj ngwenh apek tjeng nyerrkem, inang angketj tjengenheh kangkwerrem. Angey tjengenh ineh nyerrketjenh. Kwereng Angey ilernak ineh-warn petjetjenh, inehel-ayeng kwet anerl-alpetjeh. ");
INSERT INTO amx_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Tjerrtj ngwenh apek tjeng itja nyerrkem, inang angketj tjengenheh itja kangkwerrem. Angketj arrantherrarl awem, rang itja angketj tjengenh anem. Nhenh-artek Angey-henh angketj anem, Angeyel yengenh lanthekarl. ");
INSERT INTO amx_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Thang arrantherrenh nhenh ingkerrek ilek, yengarl arrehantherrel-ayeng anem-rlwer-antey. ");
INSERT INTO amx_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Angeyel Ilperrepwentj renhemeh tjeng-angkwerr arrehantherr-warn lanthetjenh, Kwerrern Alngaltar renh. Rang arrantherrenh ingkerrek kaltj-anthetjenh. Rang arrantherrenh irlpangkelh-iletjenh, angketj ingkerrek thang arrantherrenh kel ilekarl. ");
INSERT INTO amx_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Thant kwenh arrantherrenh kel Altjerrel-ayeng peltj-ilek, arrantherr ngwerleny arrken kwet awelhetjeh. Lakenh arrantherr itja lharrp awelhetjeh, itja ater-irretjeh. ");
INSERT INTO amx_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Thang nheng arrantherrenh arrwekel ilek, ‘Yeng alpetjenh, yeng weth petj-alpetjenh.’ Yeng Angey-warn-amparr alpem. Arrantherr apek tjeng arratj nyerrkemeng, arrantherr arrken awelhemer, yengarl angkep alpetjenharl Angey-warn. Angey rang tjengeng angerr anem. ");
INSERT INTO amx_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Thang arrantherrenh nhenh arrwekel war ilem, arrantherr yengenh naketjenheng. Kelant angketj nhenh arratj anthwerr-irremel arlpaw-irrekarl-penh, arrantherr lakenh angketjenh, ‘Angketj kwerenh kwenh kel arratj anthwerr!’ ");
INSERT INTO amx_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Yeng itja arrehantherrel-ayeng weth angerr angketjenh. Tjerrtj ahelh-areny map-henh twernk angerr, arrentj rang kwenh arrer-irrem. Rang yengenh ywarn twernem. ");
INSERT INTO amx_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Tjerrtj ahelh-areny map kaltj anetjenheng, yeng Angey tjengenheh nyerrkemeng, yeng kwer kangkwerremeng. Mpa, nwern mer nhenheng arratemel kel alheyemeh.” ");
INSERT INTO amx_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Yeng anem arnang grapes rang. Angey tjengenh arnang arntarnt-arenh-arenh anem. ");
INSERT INTO amx_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Arnang arntarlkw arrpenh tjeyenh map apek mern-kweny anemeng, Angeyel arntarlkw inenh akemel taly-wem. Arntarlkw tjengenh arrpenh map mern ngwerrm-akert anemeng, Angeyel arntarlkw kwek war akem, inang weth-antey mern-akert irretjenh. ");
INSERT INTO amx_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Lakenh arrantherrenh Angeyel kwek war kek angketj tjengenhel-arleng, arrantherr alyelkemeh ulpert-kweny anetjeh. ");
INSERT INTO amx_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Arrantherr tjengel-arleng kwet anetjeh, kwereng yeng arrehantherrel-arleng kweteth anetjenh. Arnang inenh kek-arleng nthakenham inang mern lyapetjenh? Itja kwet. Arrantherr apek itja tjengel-arleng kwet anem, lakenh arrantherr ywarn mern anngang-akert-irrem. ");
INSERT INTO amx_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Yeng anem arnang grapes rang. Kenh arrantherr-artek arnang arntarlkw-arteh anem. Tjerrtj ngwenh apek inang tjengel-ayel kwet anem, yeng inehel-ayel kwet anem, inang mern angerr lyapelh-ilem. Tjeng-kwenyel apek arrantherr mern ywarn lyapelh-ilem. Lakenheng arrantherr itja mwerr mernelhem. ");
INSERT INTO amx_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Tjerrtj ngwenh apek itja tjengel-ayel kwet anem, inang arntarlkw mern-kweny-artek anem. Angeyel inenh akemel taly-wetjenh, inang antjerrk-irretjenh. Kwereng tjerrtj inang arntarlkw antjerrk map kwetjemel taly-wetjenh rwang-warn. Tjerrtj lakenh nakentj-kweny antjerrk-irrem. ");
INSERT INTO amx_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Arrantherr tjengel-ayel kwet anetjeh, arrantherr angketj tjengenheh kwet irlpangketjeh, kwereng arrantherr yengenh pawenhemeng, wenheh apek, thang arrantherrenh kel awetjenh. ");
INSERT INTO amx_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Arrantherr mern angerr lyapelh-ilem apek, lakenh-arteh arrantherr arrpenh mapeh mernelhetjeh, arrantherr nakenh-nakenh tjengenh anem. Arrantherr mwerr mernelhemeng, kel tjerrtj inang arrantherrenh aretjenh, inarlk lakenh angketjenh Angey nakemel, ‘Angey rang alker-areny anthwerr anem, twer angerr-akert!’ ");
INSERT INTO amx_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Yeng kwenh arrehantherr nyerrkem, Angey tjengenh tjeng nyerrkem-arteh. Arrantherr itja tjeng-hetj ntjwem-irretjeh. Kwet tjengel-ayel anerrerray! ");
INSERT INTO amx_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Yeng Angey tjengenheh kangkwerrek-arleng, lakenheng rang tjeng kwet nyerrkem. Lakenh-arteh arrantherr tjeng kangkwerretjeh, yeng arrehantherr kwet nyerrkemarleng. ");
INSERT INTO amx_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Thang arrantherrenh nhenh ilek, arrantherr anetjenh arrken anthwerr. ");
INSERT INTO amx_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Angketj nhenh thang arrehantherr arrernem: yeng arrehantherr nyerrkentj mernelhem, lakenh-antim arrantherr ularrek-ularr nyerrkentj mernelhetjeh. ");
INSERT INTO amx_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Tjerrtj nyent ngwenh apek peltj kwerenheh tjang-ilwem, lakenh-arteh tjerrtj rang kel mernelhem, rang peltj kwer angerr nyerrkem. ");
INSERT INTO amx_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Arrantherr tjeng kangkwerrem, lakenheng arrantherr kel peltj tjengenh map anem. ");
INSERT INTO amx_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Thang arrantherrenh ilem rrkwapenh-apenh-akert. Rrkwapenh-apenh ngwenh apek inang itja twernk inehenheh iterrentj alhengk-arem. Inang patem. Yeng itja twernk-arteh anem arrehantherr. Angketj nheng Angeyel tjeng anthekarl-penh, lwerenh thang arrehantherr keth-ilemel ilek. Twernk mapel anewem inenh rrkwapenh-apenh inehenharl kwel. Thang kenh arrantherrenh peltj map war anewem, itja rrkwapenh-apenh anewetjeh. ");
INSERT INTO amx_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Arrantherr tjeng itja ahentj-anem, yengarrp arrehantherr ahentj-anem. Thang arrantherrenh ngakek, arrantherr mern angerr lyapelh-iletjeh. Mern inang kwet anetjenh, ywerretj-kweny anetjenh. Lakenh arrantherr mwerr mernelhetjeh, tjerrtj mapel alhengk-aretjeh, arrantherr kwenh Altjerr-henh anem. Kwereng arrantherr Angey tjengenh pawenhem arreny tjengenhel-ayeng, rang arrantherrenh kel awetjenh. ");
INSERT INTO amx_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Thang arrantherrenh twernem, arrantherr ularrek-ularr nyerrkentj mernelhetjeh. ");
INSERT INTO amx_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Tjerrtj map inang arrehantherr arnkely-irretjenh. Arrantherr irlpangketjeh, inang tjeng-amparr arnkely-irrekarl. ");
INSERT INTO amx_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Arrantherr kwel peltj ineh anem, inang kel arrehantherr nyerrkemer. Arrantherr kenh itja peltj ineh anem. Thang arrantherrenh ayerrp-ilek, peltj tjengenhemeh anetjeh. Lakenheng inang arrehantherr arnkely-irretjenh. ");
INSERT INTO amx_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Arrantherremeh irlpangketjeh, thang nheng arrantherrenh ilek, rrkwapenh-apenh inang itja angerr anem. Twernk inehenhant angerr anem. Tjerrtj inang yengenh alwernekarl atwetjeh, lakenh inang kel arrantherrenhemeh alwernemel atwetjenh. Tjerrtj arrpenh ngwenh apek tjeng kangkwerrem, lakenh inang arrehantherr kangkwerretjenh. ");
INSERT INTO amx_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","“Tjerrtj inang tjeng ahentj-kweny-irrek, lakenh inang arrehantherr ahentj-kweny-irretjenharlam, arrantherr tjengenh anemeng wart. Inang Angey kwer kaltj-kweny wart alartem. Angey rang yeng lanthekarl-arteh. ");
INSERT INTO amx_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Yeng kel petjek, ineh-warn angkek. Inang anetj kwet wart anemeng, anetj anthwerr mpwarekarl. Lakenh-mpernenh Altjerrel tjerrtj inenh anpwetjenh. ");
INSERT INTO amx_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Tjerrtj ngwenh apek inang tjeng arnkely-irrem, inang Angey tjengenheh arnkely-irrem-arlk. ");
INSERT INTO amx_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Thang twerel mpwarek aningk-ingar tjerrtj mapeng anngetherr. Tjerrtj arrpenhel itja lakenh mpwarek. Tjerrtj inang yengenh arek. Inang tjeng Angey tjengenheh thwen arnkely kwet anem. Lakenheng inang anetj-akert kwet anem, inang nhenh map arek-arleng-artany. ");
INSERT INTO amx_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Lakenh angketj nhenh Altjerr-henh pipel-ayel intemeng arratj-irremel arlpaw-irrek, ‘Tjerrtj inang tjeng pelkel war arnkely-irrek.’ ");
INSERT INTO amx_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Thang Ilperrepwentj nheng arrehantherr-warn lanthetjenh, Kwerrern Alngaltar renh. Rang ingkerrek arratj mernem Angeyeng. Rang Angeyeng petjemarleng, rang angketj tjeng-akert arrantherrenh iletjenh. ");
INSERT INTO amx_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Arrantherr kwenh tjengel-ayeng kwet anentjek-arleng, lakenheng arrantherr tjerrtj map tjeng-penh iletjenheng. ");
INSERT INTO amx_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Thang arrantherrenh angketj angerrel ilek, arrantherr tjengehetj ntjwem-irrehetjeng. ");
INSERT INTO amx_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Tjerrtj inang arrantherrenh werlamparenyeng alwernemel alharlkwetjenh. Ngwenth war, tjerrtj map lakenh pal-pal iterretjenh, ‘Ay! Jesu-henh nakenh-nakenh map anem anetj! Tjerrtj lakenh-lkweran irrernng atwetjeh! Lakenh Altjerr nwerneh nyerrkentj mernelhetjenheng.’ ");
INSERT INTO amx_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Wenheng inang lakenh mpwaretjenh? Inang Angey ilernehak akwen anemeng wart. ");
INSERT INTO amx_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Thang arrantherrenh nhenh arrwekel war ilem, kelant arrantherr iterl-aretjenheng, thang arrantherrenh ilekarleh. “Thang itja arrantherrenh arrwekel ilek, yeng arrehantherrel-ayeng anetjam-rlwer. ");
INSERT INTO amx_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Yeng kel kwer-warn alpetjenh, rang yengenh ahelh nhenh-warn lanthekarl-warn. Arrantherr yengenh itja pawenhek, ‘Nthenh-warn ntwang alpetjenh?’ ");
INSERT INTO amx_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Yeng alpetjeh angkek-arleng, arrantherr tjeng lharrp awelhem. ");
INSERT INTO amx_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Arratj anthwerr, angketj nhenh-artek mwerr arrehantherr anetjenh, yeng alpemarleng-rlwer. Yeng alpemarleng, thang Ilperrepwentj renh lanthetjenh arrehantherr-warn. Ilperrepwentj nhenh Kwerrern Alngaltar rang anem. ");
INSERT INTO amx_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Kwerrern rang petjetjenh, rang tjerrtj ahelh-areny map judge-em-ilemel iletjenh, inang anetj mernelhekarl. Rang inenh iletjenh, inang ularrek-ularr arratj mernelhetjeh. Rang inenh iletjenh, inang anetj-akert kwet anek-arleng, Altjerrel inenh anpwetjenh. ");
INSERT INTO amx_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Wenheng Kwerrern rang tjerrtj inenh iletjenh, inang anetj-akert kwet anemeng? Inang yengenh itja nakek-arleng. ");
INSERT INTO amx_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Tjerrtj inang itja Altjerr arratj alhengk-arek. Lakenheng Kwerrern rang inenh iletjenh, inang itja arratj mernelhek. Tjerrtj inang arratjant alhengk-aremel mernelhetjeh. Yeng Angey-warn alpetjenh, arrantherremeh yengenh itja weth aretjenh. ");
INSERT INTO amx_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Altjerrel tjerrtj ahelh-areny mapek-artwey kel alharlkwek. Tjerrtj mapel alhengk-aretj-kweny anem angketj nhenh-akert. Lakenheng Kwerrernel inenh judge-em-ilemel iletjenh, inang itja arratj anemeng. ");
INSERT INTO amx_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Thang rrkwem angketj arrpenh map, thang itja arrantherrenh ilem. Wenheng thang arrantherrenh iletj-kweny anem? Arrantherr angketj nhenheh patetjenharl. ");
INSERT INTO amx_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Kwerrern rang petjetjenh, rang arrantherrenh angketj tjengenh iletjenh, arrantherr wetham-weth kaltj-irretjenheng. Angketj kwerenh rang arratj anthwerr anetjenh. Kwerrern rang itja arrehantherr angketj kwerenharrp iletjenh. Angketj rang tjengeng awekarl, rang renh arrantherrenh iletjenh. Rang arrantherrenh ateng-iletjenh, nthakenh kelant anetjenharl, arrantherr kaltj anetjenheng. ");
INSERT INTO amx_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Kwerrern rang arrantherrenh angketj tjengenh iletjenh, lakenheng rang arrantherrenh mernetjenh, yeng alker-areny anthwerr anemeng, arrantherr yengenh nyerrkemel naketjenheng. ");
INSERT INTO amx_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Angey rang ingkerrekeh-artwey anem, rang ingkerrek twer kwerenhel rrkwem. Yeng Angey tjengenh-arteh anem, wenh-wenh ingkerrekeh-artwey. Ilernak anem ingkerrekeh-artwey. Lakenheng thang arrantherrenh ilek, Kwerrern rang arrantherrenh angketj tjengenh iletjenh, arrantherr kaltj anetjenheng. ");
INSERT INTO amx_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Arltang rrpwetjeh-atwetj arrantherr yengenh itja weth aretjenh. Kwereng arltang rrpwetj arrpenh-penh arrantherr yengenh weth aretjenh.” ");
INSERT INTO amx_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Inang awek-arleng, kwertengerl inang lakenh pawenherrek, “Wenhengam rang nheng nwerneh lakenh ilelhek, ‘Arltang rrpwetjeh-atwetj arrantherr yengenh itja weth aretjenh. Kwereng arltang rrpwetj-penhel arrantherr yengenh weth aretjenh.’? Wenhengam rang nheng nwerneh ilelhek, rang Angey-warn alpetjeh?” ");
INSERT INTO amx_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Inang weth pawenherrek, “Wenham arltang rrpwetj inang? Nwern itja nhenh alhengk-arem.” ");
INSERT INTO amx_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesu kaltj anek, inang ahentj-anek, renh pawenhetjeh. Lakenh rang inenh ilek, “Arrantherr kwenh pawenherrem, angketj nheng yengarl angkekarl-penheh, ‘Arltang rrpwetjeh-atwetj arrantherr yengenh itja weth aretjenh, kwereng arltang rrpwetj arrpenh-penh arrantherr yengenh weth aretjenh.’ ");
INSERT INTO amx_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Arratj anthwerr, arrantherr tjeng ltarrp-irremel arnetjenh, kenh tjerrtj ahelh-areny arrpenh map angketj tjeng-akert awemel arrken awelhetjenharl. Arrantherr kenh tjeng ltarrpel arnetjenh. Kelant Altjerrel arrantherrenh weth arrken-iletjenh. ");
INSERT INTO amx_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Thang ilem angketj kwer kwek-akert. Kwer kwek ngwerrm-irretjeh irremeng, arrwekel marl ngwenh apek inang irlkert awelhem. Kelant kwer kwek ngwerrm intemeng, lakenh-arteh marl inang kel arrken awelhem, kwer kwek inehenh ngwerrm-irrek-arleng wart. ");
INSERT INTO amx_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Lakenh-arteh arrantherr lyet ltarrp anem. Kelant thang arrantherrenh weth aretjenh, kwereng arrantherr arrken anetjenheng. Arrpenhel itja arrken arrehantherr-henh ltwaketjenh. ");
INSERT INTO amx_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Arltang alenh kwerel arrantherr yengenh itja weth pawenhetjenh. Arratj anthwerr, arrantherr Angey pawenhetjeh wenheh apek, arreny tjeyenhel-ayeng, rang kel arrantherrenh awetjenh. ");
INSERT INTO amx_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Arrwekel arrantherr itja Angey renh pawenhek arreny tjengenhel-ayeng. Lyeteng renh pawenhay, kwereng rang arrantherrenh kel awetjenh. Lakenheng arrantherr arrken anetjenh. ");
INSERT INTO amx_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Thang kwenh arrantherrenh angketj kwenameny Angey-akert ilekarl. Kelant thang arrantherrenh Angey-akert keth anthwerr iletjenh. ");
INSERT INTO amx_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Kelant tjengan itja anetjenh, Angey renh pawenhetjenh arrehantherr. Arrantherrarrp renh pawenhetjenh arreny tjengenhel-ayeng. ");
INSERT INTO amx_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Thang arrantherrenh ilek, yeng Angey kwereng petjek-arleng wart. Arrantherr yengenh nakek-arleng, kwer-penh arrantherr tjeng nyerrkek. Lakenheng Angey rang arrehantherr nyerrkem. ");
INSERT INTO amx_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Yeng nheng Angeyeng ahelh nhenh-warn petjek. Lyet thang ahelh nhenh imperl-alhetjenhemeh, yeng Angey-warn angkep alpetjenh.” Lakenh Jesu ineh ilelhek. ");
INSERT INTO amx_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Kwertengerl inang renh ilek, “Lyet ntwang nwerneh kethemeh angkem. ");
INSERT INTO amx_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nwern kel alhengk-arem, ntwang ingkerrekeh kaltj. Nwern ngwenh itja weth pawenhetjenh. Ntwang ilelhekarl, ntwang Altjerreng petjekarl, nwern ngwenh nakem.” ");
INSERT INTO amx_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesu-el inenh pawenhek, “Arratjam arrantherr yengenh nakem? ");
INSERT INTO amx_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ngwenth war arrantherr ingkerrek tjengeng ater irrarnp-irremel arrtjanetjenh, nyentam-nyent mer arrehantherr-henh-warn alpetjenh. Arrantherr yengenh nyent-areny imperl-alhetjenh. Yeng itja ingareny anetjenh, Angey rang wart tjengel-ayeng anemengemeh. ");
INSERT INTO amx_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","“Thang arrantherrenh nhenh ilem, arrantherr angketj nhenh alhengk-aremeng, arrantherr arrken kwet anetjenheng. Tjerrtj ahelh-areny mapel arrantherrenh rwekenth-kenth-iletjenh. Arrantherr anew-anew kwet anetjeh. Thang angketj ahelh-areny ingkerrek kel rlpwerrkek.” ");
INSERT INTO amx_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesu kwertengerl kwerenh mapek angkekarl-penh rang alker-warn-atheh arek. Rang Altjerr pawenhek, “Angeyay, lyet kwenh tjengan anem, yeng ilwetjehemeh. Ntwang tjerrtj ingkerrek ineh mernang, Ler ngkwengenh alker-areny anthwerr anemeng. Kwereng Ler ngkwengenhel ngwenh tjerrtj ingkerrekeh mernetjenheng, ntwang alker-areny anthwerr anemeng, twer angerr-akert. ");
INSERT INTO amx_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ntwang kwenh Ler ngkwengenh ngkernek, tjerrtj ingkerrekeh-artwey anetjeh. Tjerrtj map ntwarl anthekarl, Lerel inenh iteth ngampekarl anyenetjenh. ");
INSERT INTO amx_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Tjerrtj ngwenh apek kaltj anem angketj ngkwengenheh, inang iteth ngampekarl anem. Ntwang Altjerr nyentant arratj anem. Ngkweng inang kaltj anem, tjeng thwen, Jesu Christ rang, ntwang ahelh nhenh-warn lanthekarl. ");
INSERT INTO amx_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Yeng kel rrkwapek ahelh nhenhel, ntwarl yengenh twernek-arleng. Lakenh thang ngwenh tjerrtj ingkerrekeh mernek, ntwang alker-areny anthwerr anemeng, twer angerr-akert. ");
INSERT INTO amx_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Angey, ntwang yengenh weth alker-areny mpwaretjeh ngkwengel-arleng parrtj angerr-akert. Lakenh yengarl alker-areny kwet anentjekarl, parrtj angerr-akert, ilernak kwenh arrwekel alker-areny anek, ahelh nhenh-kwenyel-amparr. ");
INSERT INTO amx_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Tjerrtj ahelh-areny arrpenh mapeng ntwang tjerrtj nhenh map anthek, kwertengerl tjengenh anetjeh. Thang ineh ngwenh mernek. Kwertengerl inang ngkwengenh anek. Ntwang inenh tjeng anthek. Inang angketj ngkwengenheh kangkwerrek. ");
INSERT INTO amx_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Inang kel kaltj anem, angketj ingkerrek tharl inenh ilek, angketj rang ngkwengenh anem, ntwarl yeng ilekarl. ");
INSERT INTO amx_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Thang inenh angketj ngkwengenh kaltj-anthek. Inang angketj ngkwengenh nakek. Inang kaltj, yeng ngkwengeng petjekarl, ntwarl yengenh ahelh nhenh-warn lanthekarl. ");
INSERT INTO amx_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Lyet thang ngwenh kwertengerl ineh pawenhem. Itja tjerrtj ahelh-areny arrpenh mapeh, kwertengerl nhenh mapehant, ntwarl tjeng anthekarleh. Inang kwenh ngkwengenharl anem. ");
INSERT INTO amx_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tjerrtj tjengenh map ngkwengenh anem. Tjerrtj ngkwengenh map tjengenh anem. Tjerrtj nhenh inang kwenh yengenh tjerrtj arrpenh mapeh mernek, yeng alker-areny anthwerr anemeng. ");
INSERT INTO amx_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Yeng kwenh ngkweng-warn angkep alpetjenh, yeng itja weth ahelh nhenhel anetjenh. Inang kenh ahelh nhenhel antarl-irretjenharl. Angey Kangkentjay, ntwarrp inenh arntarnt-arang twer ngkwengenh-akertel. Twer ngkwengenh arreny ngkwengenhel-arleng intem. Ntwang arreny yanh-arteharlam tjeng-arlk anthek. Ntwang inenh anetjeng arntarnt-arang, inang kel nyent anetjenheng, ilernakarl nyent anem-arteh. ");
INSERT INTO amx_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Yeng inehel-arleng anemarleng, thang inenh arntarnt-arek, ntwang wart yengenh twer-ilekarl. Twer nhenh arreny ngkwengenhel-arleng kwet intem. Thang inenh arntarnt-arek-arleng, thang itja tjerrtj nyent parlp-ilek. Artwang nyent nhengant thang parlp-ilek, rang ngkwengeng ntjwem-irrekarl. Rant parlp-irrekan, kweran anek-arleng wart. Lakenh angketj nheng Altjerr-henh pipel-arleng arratj anthwerr-irremel arlpaw-irrek. ");
INSERT INTO amx_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Angeyay, yeng lyet ngkweng-warn alpetjenh. Yeng nhenh kwertengerl tjengenh map-warn angkem, yeng ahelhel anemarl-rlwer. Yeng ineh-warn angkem, inang arrken anetjenheng, yengarl arrken anem-arteh. ");
INSERT INTO amx_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Thang inenh angketj ngkwengenh ilek. Inang itja tjerrtj ahelh-areny arrpenh map-arteh iterrem, inang yeng-arteh iterretjeh. Lakenh tjerrtj ahelh-areny arrpenh map arnkely anem ineh. ");
INSERT INTO amx_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Thang itja ngwenh pawenhem, inenh ahelh nhenheng inerl-alhetjeh, itja. Thang ngwenh pawenhem, ntwang inenh arrentjeng arntarnt-aretjehant. ");
INSERT INTO amx_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Inang itja ahelh-areny, inang yeng-arteh iterrem. Yeng alker-arenyarl anem. ");
INSERT INTO amx_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Angketj ngkwengenh kwenh arratj anem. Kwertengerl inenh twer-ilang angketj ngkwengenhel-arleng, inang ngkweng arratj rrkwapetjenheng kweteth. ");
INSERT INTO amx_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ntwang yengenh tjerrtj ahelh-areny map-warn lanthek-arteh, lakenh thang inenh tjerrtj ahelh-areny map-warn lanthemarlam. ");
INSERT INTO amx_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Yeng ngkweng kwet iterremel ngkwengant kangkwerrem. Yeng kel iteth tjengenh mentj anthelhek, tjerrtj inang ngkwengenh anetjeh-anngernt. Ntwang inenh kaltj-anthang, inang ngkweng kwet iterretjeh, ngkwengant kangkwerretjeh, ngkwengenh anetjenheng.” ");
INSERT INTO amx_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Angey, thang lyet nakenh-nakenh arrpenh mapeh-arlk ngwenh pawenhem, inang yengenh kelant naketjenharl, angketj mwerr awemel. ");
INSERT INTO amx_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Yeng ahentj, inang ingkerrek nyent anetjeh, awelhentj nyent, iterrentj nyent, angketj nyent. Angey, ntwang tjengel-ayeng kwet anem-arteh, yeng ngkwengel-ayeng kwet anemeng-arteh. Yeng ahentj, inang ilernakel-ayeng kwet anetjeh. Kwereng tjerrtj ahelh-areny mapel alhengk-aretjenh, ntwarl yengenh ahelh-warn lanthekarl. ");
INSERT INTO amx_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ntwang yengenh ilek, yeng alker-areny anthwerr anemeng, twer angerr-akert. Lakenh-arteh thang inenh ilek, inang alker-areny anthwerr anem, twer angerr-akert, inang nyent anetjenheng, ilernan nyent kwet anem-arteh. ");
INSERT INTO amx_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Yeng inehel-ayeng kwet anem, ntwarl tjengel-ayeng kwet anem-arteh. Lakenh inang ingkerrek nyent anetjenh, awelhentj nyent, iterrentj nyent, angketj nyent. Kwereng tjerrtj ahelh-areny map kaltj anetjenh, ntwarl yengenh ahelh-warn lanthekarl. Inang kaltj anetjenh, ntwarl ineh nyerrkem, ntwarl tjeng nyerrkem-arteh. ");
INSERT INTO amx_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Angeyay, ntwang tjeng nakenh-nakenh map anthek. Yeng ahentj-anem, inang ingkerrek tjengel-ayeng anetjeh, mer kwerel yengarl anetjenh. Inang aretjenharl, yeng alker-areny anthwerr anemeng, parrtj angerr-akert. Angeyay, ntwang kwenh tjeng nyerrkek ahelh nhenh-kwenyel-amparr. ");
INSERT INTO amx_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Angey arratjay, tjerrtj ahelh-areny map kwenh itja ngkweng kaltj. Yengant ngkweng kaltj, thant ngwenh alhengk-arem. Kwertengerl nhenh map kaltj, ntwang yengenh ahelh-warn lanthekarleh. ");
INSERT INTO amx_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Thang inenh kel ngkweng-penh kaltj-anthek, thang inenh weth kaltj-anthetjenh. Kwereng inang nyerrkentj mernelhetjenheng, ntwarl tjeng nyerrkentj mernelhemarl-arteh. Yengemeh inehel-ayeng kwet anetjenheng.” ");
INSERT INTO amx_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesu rang Altjerrek angkekarl-penh, rang kwertengerl kwerenh map-akert alhekemeh. Mer rrpwang kwereng inang anarnpenhewarrek kwenelak, intjer-warn-atheh anarnpenhek. Intjer rang arreny Kidron Valley. Kwereng inang kern-atheh weth antjenhek, rrpwang arrpenh-warnemeh antjenhek. Inang lywang-warn alhek arnang olive map-warn. ");
INSERT INTO amx_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Kwertengerl nyent nheng Judas rang kelant Jesu renh atwenh-atwenh mapeh anthetjenh. Judas kaltj anek, Jesu rartek lywang kwer-warn alhetjart, kwertengerl kwerenh map-akert. ");
INSERT INTO amx_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Kel Judas rang lywang nhenh kwer-warn alhek, atwenh-atwenh map-akert rrkwentj map-akert thwen. Rrkwentj inenh priest twernk mapel lanthekarl, artwang Pharisee mapel thwen. Inang Jesu kwer ankang petjek rwang alngenth-akert arrawey-akert thwen. ");
INSERT INTO amx_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesu rang kel kaltj anek, inang renh antwerrketjenharl, kelant inang renh atwetjenh-arlk. Rang ineh-warn arnek-arner alhek. Rang inenh pawenhek, “Ngwenheham arrantherr palenthwem?” ");
INSERT INTO amx_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Inang renh ilek, “Jesu Nazareth-areny kwer.” Jesu rang ilelhek, “Yeng kwenh!” Judas rang inehel-ayeng rtwang irnek. ");
INSERT INTO amx_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jesu ineh ilelhek-arleng, atwenh-atwenh arrpenh map tjenelhemel ahelh-warn anyerl-alhek, kwerrern-kweny. ");
INSERT INTO amx_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jesu-el inenh weth pawenhek, “Ngwenheham arrantherr palenthwem?” Inang renh ilek, “Nwern palenthwem Jesu Nazareth-areny kwer.” ");
INSERT INTO amx_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesu-el inenh tjernek, “Thang nheng arrantherrenh kel ilek, ‘Yeng kwenh.’ Arrantherr tjeng wart palenthwem, arrpenh nhenh map kel imperrerrang.” ");
INSERT INTO amx_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Lakenheng angketj nhenh arratj-irremel arlpaw-irrek rang arrwekel-antey angkek, “Tjerrtj map ntwarl tjeng anthekarl arntarnt-aretjeh, thang nyent itja parlp-ilek.” ");
INSERT INTO amx_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Kwer-penh Simon Peter-el knife alkey kwerenh rlpwentjek. Rang artwang nyent irlpang kwerenh rlweth-akek. Artwang rang priest twernk angerr-kenh rrkwapenh-apenh anek, arreny kwerenh anek Malchus. ");
INSERT INTO amx_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jesu-el Peter arnpakek, “Knife alkey angkep arrernang! Tjengan anem, irlkert angerr inetjenh, Angey tjengenhel yeng twernekarl wart.” ");
INSERT INTO amx_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Kwereng atwenh-atwenh mapel twernk inehenhel-arlk tjerrtj Jew rrkwentj mapel-arlk inang Jesu renh antwerrkemel rope-el ayernek. ");
INSERT INTO amx_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Inang Jesu renh Annas-warnek-amparr angerrerrek. Annas rartek Caiaphas-kenh rtwaltj anek. Caiaphas rang year nhenh kwerel priest twernk angerr anek. ");
INSERT INTO amx_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Caiaphas nheng rang tjerrtj Jew map inenh arrwekel ilekarl, “Nhenh mwerr kwenh tjerrtj nyent nwerneh tjang-ilwetjeh.” ");
INSERT INTO amx_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Rrkwentj mapel Jesu renh angek-arleng, Simon Peter kwertengerl nyent arrpenh thwen ratherr ingkerneng alherrek. Priest twernk angerr rang kwertengerl arrpenh nhenh kwer kaltj anek. Kwertengerl nhenh rang Jesu-eng ingkern-angkwerr priest twernk angerr-henh yard-warn irrpenhek. ");
INSERT INTO amx_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Peter rang arreweng rtwang anek, yard-eng kethel. Kwertengerl arrpenh nheng rang weth arratek, Peter renh ngwetjeh yard-warn kwen. Rang marl renh pawenhek, rang arrew renh arntarnt-aretjart. Kwereng kwertengerl ratherr yard-warn kwen irrpentjek. ");
INSERT INTO amx_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Marl rang Peter renh alhengk-aremel pawenhek, “Ntwang key artwang nheng-henh kwertengerl anem?” Peter-el renh ilek, “Yeng itja.” ");
INSERT INTO amx_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Yard kwenel rwang ampetjam nywateyeng wart. Rrkwapenh-apenh map rrkwentj map thwen inang rwang kwerel ntjwetj-irretjam. Peter rang petjemel rwang iter kwerel irnemel ntjwetj-irretjam. ");
INSERT INTO amx_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Priest twernk angerr Annas rang Jesu renh pawenhek, “Ngwenh kwertengerl ngkwengenh map? Nthakenham ntwang inenh kaltj-anthem?” ");
INSERT INTO amx_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesu-el renh tjernemel ilek, “Thang kwenh tjerrtj map alngetherr kaltj-anthem. Thang kweteth church kwek mapel kaltj-anthetjam, church angerretj nyentel thwen, keth nheng tjerrtj Jew map arraw-irretjartarl kwerel thwen. Thang itja kwet tjerrtj map anyenng-anyenngel kaltj-anthek. Alngetherr kwet. ");
INSERT INTO amx_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Wenheng ntwang yengenh pawenhem lakenh, ‘Nthakenham ntwang tjerrtj map kaltj-anthem?’ Tjerrtj inenh pawenhang, inang yengenh awetjartarl, tharl inenh kaltj-anthetjam-penh. Inang kwenh angketj tjengenheh kaltj anem.” Lakenh Jesu-el renh ilek. ");
INSERT INTO amx_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Rrkwentj nyent Jesu-eng iterel irnetjam. Jesu rang ilelhek-arleng, rang renh rlkey atwek. Rang Jesu renh ilek, “Ntwang itja priest twernk angerr-warn lakenh angketjeh!” ");
INSERT INTO amx_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesu-el rrkwentj renh ilek, “Yeng apek pal angkek-arleng, yengenh ilay! Yeng apek arratj angkek-arleng, wenheharlam ntwang yeng atwekan?” ");
INSERT INTO amx_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Annas-el Jesu renh priest twernk angerr Caiaphas-warn lanthek. Inang itja rope kwereng rlwek. ");
INSERT INTO amx_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon Peter rwang iterel irnemel ntjwetj-irretjam. Arrpenhel renh pawenhek, “Ntwang key artwang nheng-henh kwertengerl anem?” Peter rang weth ywep-arrernelhek, “Yeng itja kaltj kwer!” ");
INSERT INTO amx_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Priest twernk-henh rrkwapenh-apenh arrpenh anek. Artwang peltj kwerenh artwang nheng anek, Peter-el nheng irlpang kwerenh rlweth-akekarl. Artwang rang Peter-ek ilemel irlpangkek, “Thang ngwenh arek, kwerel-ayeng irnerleh lywang nhengel!” ");
INSERT INTO amx_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Peter weth ywep-arrernelhek. Kel tjwek-tjwek rrweyemeh arlkek. ");
INSERT INTO amx_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kel kweny-rtweh anek. Inang Jesu renh Caiaphas-henh warleng weth angek twernk Rome-areny angerr-henh warl-warn. Tjerrtj Jew twernk map inang itja warl angerr-warn kwen irrpek, inang kethel irnek. Inang lakenh angkek, “Nwern akethel irnetjeh, tjenkerr ingkernant arlkwetjeh-anngernt.” Tjenkerr arreny kwerenh “Anper Alhekarl”. Inang iterrek inang ulpert-ilelhehetjeng. ");
INSERT INTO amx_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Lakenheng twernk angerr rang ineh-warn arratemel alhek. Arreny kwerenh Pilate. Rang inenh pawenhek, “Wenhengam arrantherr artwang nhenh angetjewarrek? Wenh anetj rang mpwarek?” ");
INSERT INTO amx_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Inang renh tjernek, “Rang kwenh artwang anetj. Rang apek artwang mwerr anek-arleng, nwern renh itja ngkweng-warn angetjemer. Itja kwetarl.” ");
INSERT INTO amx_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilate-el inenh ilek, “Kel arrantherrarrp court arrehantherrel-ayeng renh pawenherrerrang, mpwareng-areng arrehantherr-henh-angkwerr.” Tjerrtj inang renh ilek, “Nwern ahentj, renh atwetjeh. Kenh nwernehan itja anem, tjerrtj renh irrernng atwetjeh, ntwerlkeh arrernetjeh apek. Lakenh.” ");
INSERT INTO amx_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Jesu-el arrwekel-antey kwertengerl kwerenh mapek angketj ilek, nthakenh rang ilwetjenharl. Angketj nhenh arratjemeh arlpaw-irrek. ");
INSERT INTO amx_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilate rang warl angerr-warn kwen weth angkep irrpenhek. Kwereng rang Jesu renh weth ngwerl-alhek. Rang renh pawenhek, “Arratj key ntwang tjerrtj Jew map-henh king anem?” ");
INSERT INTO amx_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesu-el renh tjernek, “Ntwarrp key lakenh iterremel yengenh pawenhem? Itjeng apek, ngwenhelam ngwenh ilek?” ");
INSERT INTO amx_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilate rang renh ilek, “Yeng itjam tjerrtj Jew anem! Tjerrtj ngkwengenh mapel priest twernk mapel-arlk inang ngwenh tjeng anthekarl. Wenh-penharlam inang ngwenh nhenh-warn angetjewarrek?” ");
INSERT INTO amx_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesu kwer ilelhek, “Yeng apek ahelh nhenhel king anek-arleng, tjerrtj tjengenh map tjeng-arrngel atwerremer, twernk map inenh arnpaketjeh, twernk mapel yengenh antwerrkehetj. Itja kwet, yeng mer arrpenhel king anem.” ");
INSERT INTO amx_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pilate-el renh pawenhek, “Arratjam ntwang king anem?” Jesu-el renh ilek, “Ntwang arratj angkek, yeng king rang anem. Yeng-artek ahelh nhenhel kwer ngwerrm-irrekarl, thang tjerrtj ingkerrekeh angketj arratj renh iletjeh. Tjerrtj ngwenh apek ahentj-anem, angketj arratj renh awetjeh, tjerrtj inang tjeng kangkwerrem.” ");
INSERT INTO amx_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilate-el Jesu renh pawenhek, “Nthenham angketj arratj?” Pilate rang weth warl angerr kwerenheng arratemel alhek. Rang tjerrtj map ilek, “Thang artwang nhenh renh pawenhek, rang itja merrentj anem. ");
INSERT INTO amx_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Tjenkerr arltangel thang kweteth artwang tjayel-areny nyent war arrehantherr arratelh-ilem. Wenhek arrantherr ahentj-anem? King arrehantherr-henh key thang arratelh-ilemel lanthetjeh?” ");
INSERT INTO amx_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Inang arnterrel arlkemel ilek, “Itja renh! Barabbas renh-atwetj anthang!” Barabbas rartek artwang merrentj anek, atwenh-atwenh. Rang Government mapel-ayeng atwerretjart, itja ineh kangkwerretjart. Lakenheng Rome-areny inang renh arrwekel tjayel-warn kwernek. ");
INSERT INTO amx_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Pilate-el atwenh-atwenh kwerenh map twernek, inang Jesu renh whip-el atwetjeh. ");
INSERT INTO amx_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Atwenh-atwenh inang irrketj mpwarek lyek apapeth-akert, kapert kwerenheh arrernetjeh. Inang rnwanentj athethek alkeyeh renh irrpelh-ilek, arrkentj-ilemel rang king-arrpantey. ");
INSERT INTO amx_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Kwereng inang kwer-warn itwek-irrek, inang renh arrkentj-ilek, “Nthakenhay? King tjerrtj Jew map-henh key?” Inang renh rlkey atwek. ");
INSERT INTO amx_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilate weth warl angerr kwerenheng arratetj-alhek tjerrtj twernk map-warn. Rang inenh ilek, “Thang renh weth arrehantherr mernetjenh, arrantherr kaltj anetjenheng, yeng iterrem, rang itja merrentj anem.” ");
INSERT INTO amx_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Jesu keth-warn arratek, irrketj lyek apapeth kapertel-ayel-akert mantarr athethek alkey nheng-akert. Pilate-el inenh ilek, “Artwang renh arerrerrang!” ");
INSERT INTO amx_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Priest twernk mapel priest-henh rrkwapenh-apenh mapel-arlk renh arek-arleng, inang arlkemel ilek, “Renh ntwerlk-arleh arrernewarrang! Renh ntwerlk-arleh arrernewarrang!” Kwer-penh Pilate-el inenh ilek, “Arrantherrarrp renh ntwerlkeh arrernewarrang. Tjengeng ularr rang itja merrentj anem.” ");
INSERT INTO amx_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Tjerrtj twernk mapel renh ilek, “Nwern mwekeny-irrem kwer. Rang ilelhek, rang kwel Altjerr-henh Ler anemeng. Rang lakenh ilelhek-arleng, rang Altjerr renh arrampewek. Rang mpwareng-areng nwern-henheh itja kangkwerrek, lakenheng nwern renh irrernngant atwetjenh.” ");
INSERT INTO amx_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pilate-el nhenh lakenh awemel ater-irrek. ");
INSERT INTO amx_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Rang weth warl angerr-warn kwen irrpenhek. Rang Jesu renh pawenhek, “Mer nthenh-arenyam ntwang?” Jesu rang intert kwet irnek, rang itja renh tjernek. ");
INSERT INTO amx_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilate-el renh weth pawenhek, “Wenhengarl ntwang tjernetj-kweny anem? Ntwang key itjam kaltj, thang ngwenh apek mer-warn lanthehetj? Ntwerlk-warn apek ngwenh arrernehetj? Nthakenh ntwang iterrem?” ");
INSERT INTO amx_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesu-el renh tjernek, “Altjerrel ngwenh ngkernek, judge tjengan anetjeh, yeng atwetjeh apek. Itjeng apek itjarl. Tjerrtj ngwenhel apek yengenh lanthekarl ngkweng-warn, kenh tjerrtj rang ngkwengeng anetj-lkwer anem.” ");
INSERT INTO amx_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Kwereng Pilate ahentj-anek, Jesu renh lanthemel arratelh-iletjeh. Tjerrtj twernk map kwet arlkemel ilek, “Ntwang apek artwang nhenh renh lanthemel arratelh-ilem, ntwang itja Rome-areny twernk angerr Caesar-henh peltj anetjenh! Artwang rang ilelhem, rang kwel king anemeng. Rang lakenh ilelhemeng, rang kel Caesar-ek kangkwerrenh-rrenh itja anem!” ");
INSERT INTO amx_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Kwereng Pilate rang Jesu renh weth warl angerr kwereng arratelh-ilek. Rang judge-henh chair-eh arrernelhek. Chair kwerel-ayeng arrwekel tjerrtj inang ahernel arrernelhek. Mer rang arreny Irntangerr. Angketj Hebrew-el inang mer nhenh iletjart Gabbatha. ");
INSERT INTO amx_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Nhenh kwenh arltang rang anek, kwerelarl tjerrtj Jew mapel tjenkerr mpwaretjart, arlkwetjeh-anngerntel. Inang arltang arrpenhel arlkwetjeh-anngerntel. Tjenkerr renh inang anewem Anper Alhekarl. Kel twern irntarel anek. Pilate-el tjerrtj twernk map ilek, “King arrehantherr-henh arerrerrang!” ");
INSERT INTO amx_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Inang kwet arlkemel ilek, “Renh angerrerrang! Renh angerrerrang! Renh ntwerlkeh arrernewarrang!” Pilate rang pawenhek, “Arrantherr ahentj-anem kwey, thang king arrehantherr-henh ntwerlkeh arrernetjeh?” Priest twernk mapel kwer pwer anemel renh ilek, “Twernk angerr Caesar-ant nwern-henh king anem!” ");
INSERT INTO amx_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Kwereng Pilate-el Jesu renh atwenh-atwenh mapehemeh anthek, inang renh ntwerlkeh arrernetjeh-anngernt. Atwenh-atwenh mapel Jesu renh antwerrkemel angerrerrek. ");
INSERT INTO amx_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jesu rang ntwerlk kwewaleny angerl-apetjam Kapert Ngkwern-henh mer-warn. Mer inang iletjart Hebrew-henh angketjel arreny Golgotha. ");
INSERT INTO amx_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Mer Golgotha-el atwenh-atwenh mapel renh nail-el tanthemel ntwerlkeh arrernewarrek. Kwer-angkwerr inang arrernewarrek artwang atherremeh wetharlam ntwerlkeh, kwereng iterel akalk atherr. Jesu-eng itepelant atherr ntwerlkeh arrernewarrek, kenh Jesu rang mpwepelarl. ");
INSERT INTO amx_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","20","Pilate-el artwang arrpenh arrwekel kwet ilek, rang angketj kwek war tanthetjeh arnang kwek-arleh, tjerrtjel alhengk-aretjeh. Angketj yanh kwenh intek lakenh, “Jesu Nazareth-areny rang tjerrtj Jew map-henh king rang anem.” Angketj rrpwetjel rang tanthekarl, angketj Hebrew-el angketj Latin-el angketj Greek-el thwen. Inang arnang kwekel-ayeng ampek-arrernek ntwerlkeh kaperteng kern. Mer Golgotha rartek Jerusalem-eng kethel anek, ntwarr-kweny war anek. Tjerrtj map angketj nhenheh read-irremel arek. ");
INSERT INTO amx_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Lakenheng priest twernk inang Pilate-warn alhemel, inang Pilate kwer mwekeny-irrek, “Wenhekarlam lakenh arreny ntwang tanthek? Ntwang arreny Jew map-henh king arrernekarl! Nwern mwekeny-irrem lakenh angketj ntwang tanthek-arleh! Ntwang angketj arrpenh-lkwer arrernemer, ‘Rang ilelhek, rang kwel tjerrtj Jew map-henh king rang anemeng.’ ” ");
INSERT INTO amx_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilate-el inenh ilek, “Angketj nheng thang tanthekarl, itja arrantherr angart-wetjeh!” ");
INSERT INTO amx_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Atwenh-atwenh artwang atherram-atherr Jesu renh ntwerlkeh arrernekarl-penh, inang mantarr Jesu-henh kwereng rlwek. Mantarr arrpenh map inang irrarnpelh-ilek nyentam-nyenteh. Mantarr arrpenh nyent anek, arterrp alkey kwet. ");
INSERT INTO amx_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Inang angkerrek, “Nwern itja kwet mantarr nhenh tjep-aketjeh. Rang mwerr anthwerr. Nwern kwer kel kartengant arrken-irreyay!” Atwenh-atwenh inang mantarr kwer arrken-irrek. Angketj nhenh Altjerr-henh pipel-ayeng intekarl, “Inang mantarr tjengenh nyentam-nyenteh irrarnpelh-ilemel antherrek. Lwerenh-penh inang mantarr tjengenh arrpenh arrkenel anthekarl.” Angketj nhenh arratj-irremel arlpaw-irrek. ");
INSERT INTO amx_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Marl map angath irnetjam. Marl nyent anek mwek Jesu-ek-artwey, arreny kwerenh anek Mary. Kenh marl arrpenh irnetjam tjeyarl Mary-kenh. Mary marl arrpenh irnetjam Clopas-kenh anew. Marl arrpenhemeh irnetjam Mary Magdalene-arlk inehel-ayel. ");
INSERT INTO amx_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesu-el matj kwerenh arek, kwertengerl kwerenh nyent thwen irnetjamarl. Kwertengerl nheng kwer rang nyerrketjart angerr. Rang matj kwerenh ilek, “Artwang nhenhemeh kel ampengkw ngkwengenh aney!” ");
INSERT INTO amx_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Jesu-el kwertengerl renh ilek, “Artwangay! Rang mwekemeh ngkwengenh aney! Ntwang renh arntarnt-aretjehemeh.” Kelant kwertengerl rang marl renh warl kwerenh-warn anginek, renh matj kwerenh-arteh arntarnt-aretjenheng. ");
INSERT INTO amx_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jesu rang kaltj anek, rrkwapentj kwerenh kel ywerrekemeh. Angey kwerenhel anthekarl rrkwapentj kwer mpwaretjeh. Jesu rang angkek, “Yeng angkethelemeh anem.” Rang lakenh angkemel, angketj arrpenh Altjerr-henh pipel-arleng intemarl angketj rang arratj-irremel arlpaw-irrek. ");
INSERT INTO amx_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Wine tjekert rang tjampetel-ayeng irnek. Tjerrtj nyentel mantarr kwek inek, mantarr wine kwer-warn arrernemel arwek-wek. Kwereng rang mantarr kwek arnang alkey-warn ayernek. Kwereng rang arnang mantarr-akert renh angek Jesu kwer-warn. Rang arnang renh kern-ilek Jesu-warn, rang kwer anthek antjwetjeh. ");
INSERT INTO amx_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jesu-el wine renh antjwekarl-penh rang angkek, “Thang kel rrkwapentj tjengenh ywerrelh-ilek!” Kwereng rang kapert kwen-irremel kel ilwekemeh. ");
INSERT INTO amx_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nhenh kel arltang rang tjerrtj Jew mapeh anek, tjenkerr renh inang mpwaretjart arrwekel-arrwekel arlkwetjeh-anngernt. Tjerrtj inang angkerrek, “Ngwenth kwenh Saturday arltang rang anetjenh, arltang tjeperr anthwerr. Nhenh itja arratj anem, artwang inehenh mpwerrk ntwerlkel arlpar-irnetjeh. Arrwekel-arrwekel artwang inehenh mpwerrk anarnpelh-iletjeh!” Lakenh kwereng tjerrtj inang Pilate pawenhek, “Artwang nhak map ngkwern lyweper rltwakang, inang parrp ilwetjeh. Mpwerrk inehenh ntwerlkeng anarnpelh-iletjeh-anngernt.” Pilate rang ineh kangkwerrek. ");
INSERT INTO amx_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Kwereng atwenh-atwenh mapel artwang atherr-henh lyweper ngkwern ltwakek, ratherr parrp ilwetjenheng. ");
INSERT INTO amx_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Kwereng inang Jesu-warn alhek. Inang renh arek, rang kel ilwekarl. Lakenheng inang ngkwern kwerenh itja ltwakek. ");
INSERT INTO amx_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Atwenh-atwenh nyentel irrtjartel Jesu-henh ltwang tanthemel altjwer-ilek. Kel alhwang kwatj thwen thelelhek. ");
INSERT INTO amx_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Thang anngetherr nhenh arek, irrtjartelarl renh tanthek. Thang arrantherrenh ilem, angketj nhenh arratj, arrantherremeh angketj nhenh naketjenheng. ");
INSERT INTO amx_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Angketj nhenh intem arrwekel arrernekarl-penh Altjerr-henh pipel-ayeng, “Inang itja ngkwern nyent kwerenh ltwaketjenh.” Angketj nhenh arratj-irremel arlpaw-irrekemeh. ");
INSERT INTO amx_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Angketj arrpenh arrwekel arrernekarl-penh Altjerr-henh pipel-ayeng intem, “Inang renh tanthetjenharl, kenh tjerrtj arrpenh map inang alhem renh aretjeh war.” Angketj nhenh arratj-irremel arlpaw-irrek. ");
INSERT INTO amx_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Joseph mer Arimathea-areny rang Jesu-henh kwertengerl mapel-ayeng iterel nthwerl-apetjart. Rang tjerrtj Jew twernk mapeng ater-irrek-arleng, rang itja kwewaleny ilelhek arrpenh mapeh, “Yeng Jesu-henh nakenh-nakenh kwenh anem.” Jesu ilwekarl-penh, Joseph rang Pilate pawenhek Jesu-henh mpwerrkeh. Pilate-el renh kel ilek, rang Jesu-henh mpwerrk renh inemel angetjeh. Joseph rang Jesu-henh mpwerrk ntwerlkeng anarnpelh-ilemel angek. ");
INSERT INTO amx_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemus rang kwerel-ayel rlkwatherr alhek, rang anter npwang mwerr-akert angek. Anter rang 34 kilos anek. Nicodemus nheng rarl arrwekel Jesu-warn kwenyel petjekarl. ");
INSERT INTO amx_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Joseph ratherr Jesu-henh mpwerrk anter kwerel renh pernek. Ratherr mantarrel arltwemel ayernerl-anerrek. Lakenh tjerrtj Jew map-henh mpwareng-areng anek. ");
INSERT INTO amx_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ntwarr-kweny war arrer nheng Jesu ilwekarl, mer atherrkenyel anek. Irntang rang anek angath iter war. Irntang kwerel intey lyeteny anek, tjerrtjel mpwarekarl. Intey nhenhel tjerrtj irrernng arrpenh itja arrernekarl. ");
INSERT INTO amx_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Intey nhenh rang arrer wart anem-arleng, kwenyengemeh wart, ratherr parrp Jesu-kenh mpwerrk renhant intey nhenh kwer arrernerl-anerrek. ");
INSERT INTO amx_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sunday ntwely mpankel aherlkentjel Mary Magdalene rang intey-warn alhek, awenng-warn. Kwereng rang aretj-alhek irntang renh anamelh-ilekarl intey arrew kwereng. ");
INSERT INTO amx_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Mary Magdalene rang angkep twep-irremel arrtjanek kwertengerl atherr-warn. Nheng Simon Peter-warn kwertengerl arrpenh nheng-warn thwen, kwerarl Jesu nyerrketjart. Mary rang renh-atherrenh ateng-iletj-alhek, “Arrpenh mapel kwenh Ngkart-henh mpwerrk intey nhengeng inemel alengk-wek. Nwern itja kaltj, nthenh inang renh arrernekarl.” ");
INSERT INTO amx_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Peter kwertengerl arrpenh nheng thwen arrtjanerl-anerrek intey-warn, aretjeh. ");
INSERT INTO amx_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Kwertengerl arrpenh nheng arrengker arrtjanek, Peter kwereng arrwekel-irrek. Rek-amparr intey kwer irnetj-alhek. ");
INSERT INTO amx_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Rang kwen-irremel kert-arek intey kwen renh. Rang mantarr interleh arek. Mantarr bandage-arteh alkey map. Rang itja intey-warn irrpek, kethel ntwarreng war rang arek. ");
INSERT INTO amx_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Kwereng Peter rang intey-warn kwen irrpenhek, mantarr inenhant interleh aretj-alhek. Mantarr alkey map bandage-arteh. ");
INSERT INTO amx_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Mantarr arrpenh kapert-henh rang arek iterel interleh, artaper kwer interleh. ");
INSERT INTO amx_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kwertengerl arrpenh nheng intey-warn kwen irrpenhek, arratjekart aretjeh. Rang arek mantarr alkey map bandage-arteh, kenh Jesu-henh mpwerrk rang ywarek. Rang nakek, Jesu rang kemerrekarl. ");
INSERT INTO amx_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Kwertengerl inang itja alhengk-arek, angketj nheng Altjerr-henh pipel-arleng interleh, Jesu rang arrwetj-penh iteth-irremel kemerretjenharl. ");
INSERT INTO amx_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ratherr mer-warn angkep alperrek. ");
INSERT INTO amx_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mary rang inteyeng kethel ingkern akay arnetjam. Rang arnetjam-rlwer, rang kwen-irremel intey kwen kert-arek. ");
INSERT INTO amx_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Rang angel alker-areny atherr arek, mantarr mperlker-akert. Angel nyent Jesu-henh kapert intekarl-penh kwerel anetjam. Angel arrpenh Jesu-henh ingkang intekarl-penh kwerel anetjam. ");
INSERT INTO amx_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Angel ratherr renh pawenhek, “Arrweketjay! Wenheng ntwang arnem?” Mary-el renh-atherrenh ilek, “Inang kwenh Ngkart-henh mpwerrk angek! Yeng itja kaltj, mer nthenhel apek, inang mpwerrk renh alengk-wekarleh.” ");
INSERT INTO amx_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Lakenh rang angkekarl-penh rang alngarelhek, artwang irnerleh arek. Rang itja alhengk-arek, artwang rang Jesu irnerleh. ");
INSERT INTO amx_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesu-el renh pawenhek, “Wenhengarl ntwang arnem? Ngwenheham ntwang palenthwem?” Mary rang iterl-arek, rang artwang arrpenheh-athen, rang kwel atherrk arntarnt-arenh-arenh irnerleh. Rang renh ilek, “Twernkay! Ntwang apek mpwerrk keth arrpenhek alengk-wek-arleng, yeng ilang, thang mpwerrk renh inerl-alpetjenheng.” ");
INSERT INTO amx_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesu kwer-warn angkek, “Mary-ay!” Mary-el alngarelhemel renh alhengk-arekemeh. “Rabboni”, rang angkek. Rabboni Hebrew-henh angketjel-ayel intem kaltj-anthenh-anthenh. ");
INSERT INTO amx_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesu-el renh ilek, “Ntwang yengenh itja antwerrketjeh. Yeng itja Angey-warn alpek, mpank-antey. Ntwang kwertengerl tjengenh map-warn alpang. Inenh arteng-ilang lakenh, ‘Yeng Angey tjengenh-warn angkep alpetjenh. Angey arrehantherr-henh-warn thwen. Altjerr tjengenh-warn, Altjerr arrehantherr-henh-warn thwen.’ ” ");
INSERT INTO amx_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Kwereng Mary Magdalene kwertengerl map-warn alpek, ateng-iletjeh. Rang inenh ilek, “Thang Ngkart arekaw!” Kwer-penhan rang inenh Jesu-henh angketj iletj-alpek. ");
INSERT INTO amx_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Angwerr-angwerrel kwertengerl inang warl kwenel anek. Inang tjerrtj twernk mapeng ater-irrek. Arrew ingkerrek martekarl. Jesu rang ineheng mpwepel irnetj-alhek. Rang inenh ilek, “Altjerr rang arrehantherr nyerrkentj mernelhem, arrantherr ngwerleny arrken kwet anerrerrang.” ");
INSERT INTO amx_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Rang ineh mernelhek, iltjang kwerenh ltwang kwerenh thwen. Kwertengerl inang Ngkart renh aremel arrken awelhek. ");
INSERT INTO amx_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jesu-el inenh weth ilek, “Altjerr rang arrehantherr nyerrkentj mernelhem, arrantherr ngwerleny arrken kwet anerrerrang. Angey rang yengenh tjerrtj ahelh-areny map-warn lanthekarl. Lakenh-arteh thang arrantherrenh lanthem tjerrtj ineh-warn.” ");
INSERT INTO amx_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kwereng rang inenh pew-ilemel ilek, “Kwerrern Alngaltar rang kel arrehantherrel-arleng anememeh. ");
INSERT INTO amx_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Arrantherr apek tjerrtj arrpenh-henh anetj rrpwaremel wem, Altjerrel anetj kwerenh rrpwaremel wetjenh. Arrantherr apek tjerrtj arrpenh-henh anetj itja rrpwarentj-kweny, Altjerrel anetj kwerenh itja rrpwaretjenh. Lakenh.” Lakenh Jesu-el inenh ilek. ");
INSERT INTO amx_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Thomas rang itja kwertengerl arrpenh mapel-arleng anek, itja Jesu renh iteth arek. Thomas arreny kwerenh arrpenh anek Tjew-atherr. ");
INSERT INTO amx_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Arltang arrpenhel inang Thomas renh aremel ilek, “Nwern Ngkart arekaw!” Thomas rang inenh irrpelth-irremel ilek, “Thang renh ngwerrm iltjang kwerenh aretjeh-amparr, thang apek arnpetjeh iltjang kwerenh nail-penh iltjang tjengenhel, ltwang renh arnpetjeh-amparr, kwer-penhant thang angketj arrehantherr-henh naketjenh!” ");
INSERT INTO amx_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Kel arltang arrpenhel kwertengerl inang weth warl nyent kwerel anek. Thomas rang inehel-arleng ngwerrmemeh anek. Inang kwenel anerl-anek. Arrew ingkerrek martekarl. Jesu weth ineheng mpwepel irnetj-alhek. Rang inenh ilek, “Altjerr rang kwet arrehantherr nyerrkentj mernelhem, arrantherr ngwerleny arrken kwet anerrerrang!” ");
INSERT INTO amx_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Rang Thomas renh ilek, “Aray, iltjang tjengenh anpay, iltjang ngkwengenhel. Rltwang-arlk. Ntwang yengenh kwet kel naketjehant!” ");
INSERT INTO amx_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Thomas-el renh ilek, “Ntwang Ngkart tjengenh anem, Altjerr tjengenh thwen!” ");
INSERT INTO amx_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesu-el renh ilek, “Ntwang yengenh arek-arleng, lakenheng ntwang yengenh nakek. Tjerrtj ngwenh apek yengenh nakem, inang yengenh itja arek-arleng, lakenheng Altjerr ineh angerr nyerrkem.” ");
INSERT INTO amx_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesu-el twerel aningk-ingar mpwarerl-apetjam, kwertengerl kwerenh mapeng anngetherr. Thang rrkwapentj inenh itja pip nhenh-warn arrernek. ");
INSERT INTO amx_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Thang arrernek rrkwapentj nhenh map-penhant pip-warn, arrantherr Jesu naketjenheng, rang Christ anemeng, Altjerrel ngkwey alhelekarl. Thang arrernek, arrantherr renh naketjenheng, rang Altjerr-henh Ler anemeng. Arrantherr renh lakenh naketjenheng, arrantherr iteth ngampekarl anyenetjenheng. ");
INSERT INTO amx_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Jesu-henh kwertengerl map kwatj alayel iterel anerl-anek. Kwatj alay-kenh arreny Tiberias anek. ");
INSERT INTO amx_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon anek; arreny arrpenh kwerenh Peter anek; Thomas anek, arreny arrpenh kwerenh Tjew-atherr; Nathanael anek, town Cana-areny; Cana town rang mer Galilee-el anek. Akenheng-atherr Zebedee-kenh ler atherr James John thwen anek. Kwertengerl arrpenh atherr-arlk anek. ");
INSERT INTO amx_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Peter-elemeh inenh ilek, “Yeng alhemaw, irrpenng antwerrketjeh.” Arrpenh mapel renh ilek, “Nwern-arlk ngkwengel-ayel alhetjeh.” Inang boat-warn antjemel, irrpenng net-el antwerrketjeh alhek. Kweny ntjaperel inang rrkwapek, inang ywarn kwet irrpenng antwerrkek. ");
INSERT INTO amx_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Aherrk arratetjeh-anngernt, inang artwang nyent kwatj iterel irnerleh arek. Rang Jesu irnek. Kwertengerl inang renh itja alhengk-arek. ");
INSERT INTO amx_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jesu-elemeh inenh arlkemel pawenhek, “Peltj mapay! Arrantherr key ker irrpenng inerrerrek?” Inang renh tjernemel ilek, “Itjaw!” ");
INSERT INTO amx_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Jesu-el inenh ilek, “Boat-eng iter ntwarr-lkwer net renh arrantherr kwatj-warn werrerrang. Arrantherr kel irrpenng antwerrketjenhemeh!” Inang kangkwerremel net kwatjeh wek. Kwer-penh inang net renh ywarn boat-warn tjarr-inek, irrpenng map anthwerr-akert. ");
INSERT INTO amx_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Kwertengerl arrpenh nheng kwerarl Jesu angerr nyerrkek, rang Peter renh ilek, “Ngkart nhakeyay irnem!” Peter-el nhenh awemel mantarr alkey kwerenheh angkep irrpek. (Arrwekel rang mantarr alkey kwerenh rlwek-amparr irrpenng antwerrketjeh-anngernt.) Rang boat-eng anarnpemel kwatj-warn irrpenhek, rang kwer-warn arnekarner pwerlp-irrenhek. ");
INSERT INTO amx_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Kwertengerl arrpenh map inang boat-el kwet anek, inang kwatj itereng itja ntwarr anek, kel arrer war, 100 metres war apek. Inang net irrpenng map-akert renh tjarr-angetjek kwatj iter-warn. ");
INSERT INTO amx_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Inang boat kwereng anarnpek-arteh, kwertengerl inang rwang amperleh arek, ker irrpenng perrkel amperleh. Inang arek mern ampeng arlkwetjeh-anngernt rwang iterel interleh. ");
INSERT INTO amx_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesu-el inenh ilek, “Irrpenng rrpwetj angetjewarrang.” ");
INSERT INTO amx_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Peter weth boat-warn antjek. Inang net renh kwatj alay iter-warn tjarr-angek. Net kwerel irrpenng 153 map-akert. Net rang itja ltwakelhek. ");
INSERT INTO amx_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesu-el inenh ngwek, “Petjewarrang arlkwetjeh.” Kwertengerl map inang kaltj anek, rang Ngkart anerleh. Inang nyerr-irrek renh pawenhetjeh, “Ntwangam Jesu?” ");
INSERT INTO amx_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesu-el inenh mern inemel anthek, arlkwetjeh. Kwer-penh rang irrpenngemeh ineh anthek arlkwetjeh. ");
INSERT INTO amx_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Nhenh kel rrpwetj-ingaremeh anek, Jesu rang mernelhek kwertengerl kwerenh mapek, rang irrernngeng kemerrekarl-penh. ");
INSERT INTO amx_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Inang kel arlkwekarl-penh, Jesu Peter thwen ngakelherrek mapeng. Jesu-el Simon Peter renh pawenhek, “Simon-ay, John-kenh leray, ntwangam tjeng angerr nyerrkem?” Simon Peter-el renh ilek, “Yaw, Ngkartay. Ntwang kel kaltj, yeng ngkweng nyerrkem.” Jesu-el renh ilek, “Yep-yep tjengenh kwek map anhwerlk-ilemel wantang.” ");
INSERT INTO amx_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jesu-el Peter renh weth pawenhek, “Simon John-henh leray, ntwang key arratj tjeng nyerrkem?” Simon Peter-el renh ilek, “Yaw, Ngkartay, ntwang kel kaltj, yeng ngkweng nyerrkem.” Jesu-el renh ilek, “Yep-yep tjengenh map arntarnt-arang.” ");
INSERT INTO amx_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Kel nyent-ingar weth Jesu-el Peter renh pawenhek, “Simon, John-henh leray, ntwang key tjeng nyerrkem?” Jesu-el Peter renh tjelk-atwek, lakenh angkemel. Jesu-el renh pawenhek-arleng rrpwetj-ingaremeh, “Ntwang key tjeng nyerrkemam?” Rang Jesu renh ilek, “Ngkartay, ntwartek kaltj anthwerr ingkerrekeh anem. Ntwang nhenhek kaltj anem, yeng ngkweng nyerrkemeng.” Jesu-el renh ilek, “Yep-yep tjengenh map anhwerlk-ilemel wantang. ");
INSERT INTO amx_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Peter-ay, arratj anthwerr, ntwang nheng anthetjeh-amparr anetjam-rlwer, ntwarrp belt-el ayernelhetjart, ntwarrp alhetjart, ntwang ahentj-irremel-arteh. Ntwang artwang aywang-irremel, arrpenhelemeh mwerlt ngkwengenh atherr kern-iletjenh. Inang ngwenh belt-el-arlk ayernemel tjey-angetjenh mer kwer-warn ntwang ahentj-kweny.” ");
INSERT INTO amx_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesu-el Peter angketj nhenh ilek, rang kaltj anetjenheng, arrpenh mapel Peter renh kelant irrernng atwetjenharl. Peter rang ilwetjenhel, kwer-penh tjerrtj arrpenh mapel nhenh aremeng, inang Altjerr renh naketjenheng. Kwereng Jesu-el Peter renh ilek, “Tjengel-ayel anharrel petjang!” ");
INSERT INTO amx_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Peter rang alngarelhemel arek kwertengerl nheng kwerarl Jesu rang angerr nyerrkek, rang kwer-atherreng ingkerneng petjerleh. Arrwekel kwertengerl nhenh-artek nheng Jesu-eng kwet arlkany intemel, inang kweny nyentel mern arlkwetjam. Kweny kwerel rang nheng Jesu renh pawenhek, “Ngkartay, ngwenhelam ngwenh atwenh-atwenh mapeh anyenng-anyenngel anthetjenh?” ");
INSERT INTO amx_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Peter-el kwertengerl renh aremel rang Jesu renh pawenhek, “Ngkartay, rarteh nthakenh irretjenh?” ");
INSERT INTO amx_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesu-el Peter renh ilek, “Yeng apek ahentj-anem, rang iteth anetjeh yeng petj-alpetjeh-atwetj, nhenh itja ngkwengan anem. Kwer itja iterretjeh. Ngkwengan war anem, tjengeng ingkern-angkwerr petjetjeh.” ");
INSERT INTO amx_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Angketj nhenheng nakenh-nakenh inang iterl-arek, kwertengerl nheng kwel itja ilwetjenharl. Jesu itja angkek, kwertengerl nheng rang kwel itja ilwetjenharl. Rang war Peter renh ilek, “Yeng apek ahentj-anemeng, rang iteth anetjeh yeng petj-alpetjeh-atwetj, nhenh itja ngkwengan anem.” ");
INSERT INTO amx_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Kwertengerl nhenh rang kwenh angketj nhenh ingkerrek pip-warn tanthemel arrernek. Rang tjerrtj mapeng alngetherr angketj nhenh ilek. Nwern kaltj, angketj kwerenh arratj anem. ");
INSERT INTO amx_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesu rang arrwekel angerr arrpenh mpwarek. Thang itja angketj ingkerrek pip-warn tanthek. Wenheng? Rrkwapentj angerreng kwenh! ");
INSERT INTO amx_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Theophilus-ay, ntwang iterl-arem key, thang angketj arrpenh arrwekel-antey pip-warn arrernekarl-penh? Pip nhengel-ayeng thang ngwenh ilek, nthakenh Jesu-el mpwarekarl arrwekel, kaltj-anthekarl thwen. Angketj pip arreny Luke-el-ayeng intem, lakenh. ");
INSERT INTO amx_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Jesu nheng alker-warn alpetjeh-anngernt, rang kaltj-anthek-amparr kaltj-anthenh-anthenh tjeperr map Kwerrern Alngaltarel-ayeng, nheng rang arrwekel urraremel inekarl, kwertengerl kwerenh anetjeh. Rang inenh kaltj-anthek, nthakenh-nthakenh inang mpwaretjeh, rang itja inehel-ayeng kwet anetjenhengarl wart. ");
INSERT INTO amx_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Irrernngeng kemerrekarl-penh Jesu rang ineh mernelhek, inang kaltj anthwerr anetjenheng, rang kwenh iteth anek. Arltang 40-eh-atwetj rang inenh kaltj-anthetjam, Altjerr rang tjerrtj kwerenh map-warn petjekarl, rang ineh Ngkart angerr anemeng. ");
INSERT INTO amx_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Arltang arrpenhel Jesu rang kaltj-anthenh-anthenh inehel-arleng mern arlkwetjam-rlwer, rang inenh ilek, “Arrantherr Jerusalem-el karelherrerrang, Angeyel arrehantherr-warn Kwerrern Alngaltar lanthetjeh-atwetj. Thang arrantherrenh arrwekel ilek, rang arrantherrenh alhelekarleng wart. ");
INSERT INTO amx_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Arrwekel John-el tjerrtj map inenh kwatj-warn irrpelh-ilemel baptise-em-iletjam. Ngwenth war Altjerrel arrantherrenh Kwerrern Alngaltarel-arleng baptise-em-iletjenh, Kwerrern rang arrehantherrel-ayeng kwen kwet anetjenheng.” ");
INSERT INTO amx_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Arrpenh-ingar kaltj-anthenh-anthenh tjeperr map inang arraw-irrek Jesu kwer-warn. Inang renh pawenhek, “Ngkartay, ntwang key Rome-areny map mer Israel-eng anpwetjenh? Ntwang key tjerrtj nyent arrernem, king nwerneh Israel-areny mapeh anetjek? Ilwengar, lyet key?” ");
INSERT INTO amx_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesu-elemeh inenh ilek, “Angeyant arrwekel kwet iterrek, nthakenh irretjenharl. Rang nwernenh itja nhenh ilem. ");
INSERT INTO amx_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Kwerrern Alngaltar rang arrehantherr-warn petjetjenh, rang arrehantherrel-ayel kwetant anetjenh. Rang arrantherrenh twer-iletjenh. Kwereng arrantherr tjerrtj ingkerrek tjeng-penh iletjeh, mer Jerusalem-el mer ingkerrekel Judea ntjaperel, mer ingkerrekel Samaria ntjaperel thwen, ahelh apanpel thwen.” ");
INSERT INTO amx_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Kwereng Jesu rang alkereh irrek. Inang renh artwaretjam. Kwereng rang ywerrenhek. Ankertelemeh renh inehetj arltwekarl. ");
INSERT INTO amx_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Tjerrtj inang kern-atheh artwaretjam-rlwer, artwang atherremeh inehel-ayel irnetj-alhek, mantarr mperlker-akert. ");
INSERT INTO amx_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Artwang ratherr inenh pawenhek, “Artwang mer Galilee-areny mapay! Wenheham arrantherr alker-warn-athek kwet arerl-anem? Jesu rang alker-warn alpek. Rang angkep petj-alpetjenh lakenh-arteh kwenh.” ");
INSERT INTO amx_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","13","Kaltj-anthenh-anthenh tjeperr nhenh map mer Olive pwertel anek: Peter, John, James, Andrew, Philip, Thomas, Bartholomew, Matthew, James nheng Alphaeus-kenh ler, Simon nheng rarl Rome-areny Government-ek irrpelth-irretjart, Judas arrpenh nheng James-kenh ler. Mer Olive rartek Jerusalem-eng angath war anek. Kwereng kaltj-anthenh-anthenh inang Jerusalem-warn alpek. Inang warl nyent-warn kwen irrpenhemel inang room kern-warnemeh antjenhek. Warl kwerelemeh inang kwet anek. ");
INSERT INTO amx_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Inang kwet Altjerr-warn angketjart. Mary Jesu-kenh mwek, marl arrpenh map thwen, Jesu-henh tjey rrpwetj inarl inehel-ayeng anek thwen, inang angketjart Altjerr-warn. ");
INSERT INTO amx_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Arltang arrpenhel nakenh-nakenh aningk 120 arraw-irrek. Peter-elemeh kemerremel inenh ilek, ");
INSERT INTO amx_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","“Tjengenh mapay, ngkwey anthwerr Kwerrern Alngaltarel King David-el-ayel angketj kwertengerl nheng-henh Judas-akert ilek. Angketj nhenhan ingkernemeh arratek keth-irremel. Ngkart Jesu-el Judas renh ngwek, kwer rrkwapetjeh. Judas rang nwernehel-ayel pwert anek! Pwert kwet rrkwapek. Kwereng Judas rang Jesu renh atwenh-atwenh mapek anthekarl.” Lakenh Peter-el inenh ilek. ");
INSERT INTO amx_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Priest twernk mapel arrwekel Judas-ek ngkweltj anthek, rang Jesu ineh anthetjenheng-anngernt. Ngkweltj nhenhel rang meremeh payem-ilek. Mer kwerelemeh Judas rang kapert kwenelakw anyerl-alhek ahelh-warn. Anert kwerenh alterrelhekarl, kwereng lyep-lyep kwerenh arratek ahelh-warn anyerl-alhek. ");
INSERT INTO amx_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Tjerrtj Jerusalem-areny aningkelemeh angketj Judas-akert awek, rarl ilwekarl. Inang mer arreny arrpenh-anem anewek, Akeldama. Mer nhenh arreny anem alhwang-akert.) ");
INSERT INTO amx_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Peter-el inenh ilek, “Altjerr-henh pip Psalms-el-ayeng David-el angketj nhenh pip-warn arrernekarl, ‘Mer kwerenh rltwang kwet anetjeh, tjerrtj map itja kwerel anetjeh.’ “Angketj nhenh arrpenh David-el pip-warn arrernek, ‘Tjerrtj mapel kaltj-anthenh-anthenh tjeperr arrpenhemeh ngkernetjeh, kaltj-anthenh-anthenh rarl ywerrekarleng.’ ” ");
INSERT INTO amx_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Peter-el ilek, “Artwang arrpenh nwern urraremel inetjeh, rang nwernehel-ayeng arrpenh mapeh angketj mwerr ilerl-apetjenheng, Jesu rarl irrernngeng kemerremel iteth-irrekarl-penh. Artwang ngwenh apek rang nwernehel-ayel kwet nthwerl-apetjart. Nheng rang Jesu arentjek, renharl John-el nheng kwatjel baptise-em-ilekarleng, rang kwet nwernehel-ayel anentjek, Jesu nheng alker-warn alpetjeh-atwetj.” ");
INSERT INTO amx_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Kaltj-anthenh-anthenh inang artwang atherreh iterrek, kaltj-anthenh-anthenh tjeperr apek anetjeh. Arreny kwer-atherr-henh anek Joseph Barsabbas, Matthias thwen. Joseph renh-artek inang arreny arrpenh Justus iletjart. ");
INSERT INTO amx_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Kwereng inang Altjerr renh pawenhek, “Ngkartay, ntwang tjerrtj ingkerrek-henh iterrentj arem. Ntwangemeh nwerneh keth-ilang, artwang nhenh atherreng nyent, ngwenh apek ntwang urraretjenheng, kaltj-anthenh-anthenh tjeperr nwerneh anetjenheng, Judas rang ilwekarleng.” Lakenh inang Altjerr pawenhek. ");
INSERT INTO amx_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Inang arreny kwer-atherr-henh irntang kwek atherr-warn arrernek. Arreny nyent irntang nyentel-ayel anek. Arreny arrpenh irntang arrpenhel-ayel anek. Inang irntang kwek atherr tjampet-warn kwernek, arreny atherr-akert. Kwereng artwang nyentel tjampet kwereng lernek. Irntang nyent ahelh-warn anyetj-alpek. Inang arreny nyentant arek, Matthias-henh arreny. Joseph-henh arreny itjarl inang arek. Lakenheng inang Matthias renh kaltj-anthenh-anthenh tjeperr ngkernek, arrpenh mapel-ayeng anetjeh, inang kaltj-anthenh-anthenh tjeperr 12 pelemeh anetjenheng. ");
INSERT INTO amx_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Kwereng Pentecost arltangemeh anek. (Jew mapel arltang irlpangkentj renh anyenetjart arltang Pentecost-el.) Jesu nakenh-nakenh map ingkerreny anek warl nyentel. ");
INSERT INTO amx_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Inang awek ywerr-angkentj angerr-akert, irlkarteh alkereng warl-warn kwen irrpentjerleh. ");
INSERT INTO amx_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Inang arek, rwang alngenth-arteh irrarnp-irrerleh, nakenh-nakenh ineh-warn arrernelhetj-alherleh nyentam-nyent-warn, rwang aleny-arteh kapert inehel-ayel. ");
INSERT INTO amx_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Kwerrern Alngaltar rang nakenh-nakenh ineh-warn irrpetj-alhek. Kwerrern Alngaltar rang ineh angketj arrpenh map-kenh anthek, inang angkek angketj arrpenhek-arrpenhel. Angketj inang anek map anthwerr. ");
INSERT INTO amx_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Tjerrtj Jew arrpenh map Jerusalem-el anek, inang mer arrpenh mapeng yatjarr petjewarrekarl, Jerusalem kwerel Altjerr naketjeh. ");
INSERT INTO amx_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Jew nhenh map inang ywerr-angkentj nhenh awekarleng, inang arraw-irretj-alhek Jesu nakenh-nakenh ineh-warn. Inang awek, Jesu nakenh-nakenh map angketj inehenh anthwerr angkerleh! Lwerenh-penh inang pal awetjam, nthakenh-nthakenh inang lakenh angketjam. ");
INSERT INTO amx_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Inang pawenherrek, “Yekay! Nhenh map kwenh mer Galilee-areny map! ");
INSERT INTO amx_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Nthakenharlam inang angkem angketj arrpenhek-arrpenh? Nwern inenh awem, inang angkerleh angketj nwern-henh-arlk! ");
INSERT INTO amx_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nwern kwenh mer arrpenhek-arrpenheng petjek. Nwern mer nhetenh-areny map: mer Parthia-areny, Media-areny, Elam-areny, Mesopotamia-areny, Judea-areny, Cappadocia-areny, Pontus-areny, Asia-areny, ");
INSERT INTO amx_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Phrygia-areny, Pamphylia-areny, Egypt-areny, Libya-areny nheng Cyrene town-eng rtwang, tjerrtj Rome town-areny yatjarr petjekarl, ");
INSERT INTO amx_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Crete-areny, Arabia-areny. Nwern Jew map anem. Arrpenh map nwerneheng arrwekel Jew-kweny anek, kwereng inang Jew irrekarl. Nwern ingkerrek Galilee-areny nhenh map angkerleh awem. Inang angkem, ‘Altjerr kwenh mwerr angerr, rang kwenh twer anthwerr mpwarekarl!’ Nwern ingkerrek awem, inang angketj nwern-henh anthwerr angkem! ");
INSERT INTO amx_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Nthakenham lakenhan?” ");
INSERT INTO amx_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Arrpenh map Jesu nakenh-nakenh ineh pwer anek, lakenh angkemel, “Tjerrtj nhenh map ngkwarl-penh angkerl-anem!” ");
INSERT INTO amx_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Peter-emeh kemerremel irnek, kwertengerl 11 ineh-akert. Peter-elemeh map inenh untarel ilek, “Peltj mapay! Arrantherr ingkerrek Jew map, Jerusalem-areny map-arlk, yeng-amparr ntertel awerrerrang, thang arrantherrenh keth-ilemel iletjeh! ");
INSERT INTO amx_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Arrantherr iterrem, artwang nhenh map terangk kwel angkerleh. Inang itja terangk anem! Nhenh kwenh kweny-rtweh mpank 9 o'clock. ");
INSERT INTO amx_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Nhenhel lyet arrantherr awek ywerr-angkerleh, tjerrtj map angkek angketj arrpenh map-arlk. Nhenh-penh artwang angketj angenh-angenh nheng Joel-el ngkwey ilekarl, ");
INSERT INTO amx_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Mpank Ngkart petj-alpetjeh-anngernt, thang Kwerrern tjengenh tjerrtj map-warn lanthetjenh. Ler arrehantherr-henh mapel rrwey marl thwenel angketj tjengenh ilerl-apetjenh. Artwang anthetj mapel aywang mapel-arlk thwen inang anengkerr aretjenh. ");
INSERT INTO amx_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Thang rrkwapenh-apenh tjengenh map-warn rrwey marl thwen-warn Kwerrern Alngaltar tjengenh lanthetjenh, inang angketj tjengenh iletjenheng. ");
INSERT INTO amx_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","20","Ngkart rang petj-alpetj-kweny-antey, thang-amparr arrehantherreng ularr mernetjenh alkerel ahelhel thwen. Tjerrtj mapel anwerlketjenh nhenh aremel. Inang alhwang, rwang kwert-arlk aretjenh. Aherrk rang kweny-irretjenh, atay rang athethek-irretjenh alhwang-arteh, Kwereng Ngkart rang alkereng petj-alpetjenh twer angerr-akert, tjerrtj ingkerrek court angerrel pawenhemel judge-em-iletjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ngkart mpank petj-alpetjenh-kweny-amparr, tjerrtj ngwenh apek inang Altjerr renh arlkemel pawenhetjenh, “Ngkartay, yengenh inay!”, Ngkartel inenh kel inetjenh, kwerel-ayel iteth ngampekarl anetjenheng.’” “Lakenh Joel-el Altjerr-henh angketj pip-warn tanthemel arrernek.” ");
INSERT INTO amx_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Peter-el ilek, “Artwang Israel-areny mapay, angketj nhenh arrantherr awerrerrang, tharl arrantherrenh ilem. Altjerrel kwenh Jesu Nazareth-areny arrehantherr-warn lanthek, rang tjerrtj irlkert map mwerr-ilek arrehantherreng alngetherr. Arrantherr kwenh kaltj anem yanhek. ");
INSERT INTO amx_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Altjerrel arrwekel kwet iterl-arek, nheng nthakenh irretjenharl, artwang anetjel Jesu renh arrehantherr-warn anthetjenh. Altjerr rang arrwekel kwet nhenhek ahentj-irrek. Arrantherr Jesu renh antwerrkek, tjerrtj anetj mapek anthek. Inang renh nail-el tanthemel ntwerlk-warn arrernek, rarrp ilwetjeh. ");
INSERT INTO amx_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Altjerrel Jesu renh irrernngeng kemelh-ilek iteth-ilek. Rang itja renh impek, awenngel kwet intetjeh! ");
INSERT INTO amx_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","“Ngkwey King David angkek, ‘Ngkart rang tjengeng ularr rtwang kwet anem. Tjerrtj arrpenhel yengenh ywarn anetj-iletjenh, Ngkart rang rtwang anemeng wart. Lakenheng yeng itja ater-irrem. ");
INSERT INTO amx_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Yeng Altjerr-warn angkem, “Ngkartay, yeng arrken awelhem, yeng ngkweng kangkem, ntwarl kwet wart yengenh arntarnt-arerl-anem. Yeng anew-anew karelhem ngkweng. ");
INSERT INTO amx_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Yeng ngkwengenh anem, tjeperr, yeng kweteth ngkweng kangkwerrem, lakenheng ntwang yengenh itja awenngel imperl-alhetjenh. Ntwang yengenh awenngeng inetjenh. Lakenheng yeng itja ahelhel arntert-irretjenh. ");
INSERT INTO amx_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ntwang yengenh ilek, ntwang yengenh irrernngeng iteth-iletjenh. Ntwang yengenh tjep-tjep-iletjenh, yeng ngkwengel-ayel arrken awelhetjenh.” ’ ” ");
INSERT INTO amx_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Peter-el angketj nhenh keth-ilemel ilek, “Peltj mapay, King David lakenh angkek ngkwey. Angketj nhenh kwenh Jesu-penh anem. Thang arrantherrenh angketj arratj anthwerr ilem King David-akert. David rang ilwek, inang renh awenng-warn kwernek, rang awenngel kwen kwet intem. Awenng kwerenh mer Judea-el lyet anem kwet. ");
INSERT INTO amx_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","David rang kwenh Altjerr-henh angketj angenh-angenh anek. David rang iterl-arek, Altjerrel nheng renh alhelekarleh, peltj kwerenh ingkern-penh mapeng king nyent anetjenharl. ");
INSERT INTO amx_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","“David rang kaltj anek, nthakenh-nthakenh irretjenharl, Altjerrel kwer mernekarleng wart. David rang arrwekel kwet ilek, Altjerrel Christ renh irrernngeng kemelh-iletjenharl, rang renh itja awenngel imperl-alhetjenh. Christ rang itja npwang arntert-irretjenh awenngel-ayel. ");
INSERT INTO amx_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Altjerrel kwenh Jesu renh iteth-ilemel kemelh-ilek. Nwern nhenheh kaltj, nwern renh iteth arekarleng wart. ");
INSERT INTO amx_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Jesu rang alker-warnemeh angkep alpek. Lyet rang Altjerrel-ayel anem, ratherr pwert anem, Ngkart ingkerrekeh wart anem. Arrwekel Angey kwerenhel renh ilekarl, rang Kwerrern Alngaltar kwer anthetjeh. Angketj nhenh lakenh arratemel keth-irrek. Rang Kwerrern Alngaltar Ngkart Jesu kwer-amparr anthek. Lyet Jesu-el Kwerrern nhenh nwernehemeh lanthem. Lyet arrantherr nwernenh aremel awem, nwern angkemarl angketj arrpenhek-arrpenhel Kwerrern Alngaltarel-ayel. ");
INSERT INTO amx_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","King David rang itja alker-warn alpek. David rang ngkwey angketj nhenh ilek, pip Psalms-el-ayel, ‘Altjerrel Ngkart tjengenh ilek, “Tjengel-ayeng-amparr kwet anang! ");
INSERT INTO amx_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Tjerrtj ahang-irrenh-irrenh map thang atwemel arratj-iletjenh, inang kangkwerretjenheng ngkweng.” ’ “Angketj nhenh kwenh Jesu-akert anem.” ");
INSERT INTO amx_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Peter-el ilek, “Tjerrtj Israel-areny mapay, lakenheng arrantherr nhenheh kaltj anetjeh: Jesu nheng arrantherr ntwerlk-warn arrernekarl, renhemeh Altjerrel ngkernek, Ngkart angerr tjerrtj ingkerrekeh anetjek, Christ, rang nwerneh ngkwey alhelekarl.” ");
INSERT INTO amx_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Peter-el angketj lakenh angkemel tjerrtj inenh tjelk-atwek. Tjerrtj mapel inang nyerr-irremel inenh pawenhek, “Tjey mapay, nthakenham irreyam nwern?” ");
INSERT INTO amx_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Peter-el inenh ilek, “Arrantherr anetjeng twep-irretjehant. Arrantherr nwerneh-warn petjetjeh, nwern arrantherrenh Jesu Christ arrenyel-ayeng kwatj-warn irrpelh-ilemel baptise-em-iletjeh, Altjerrel anetj arrehantherr-henh wetjenheng, rang ngwerleny arrehantherr mernelhetjenheng. Kwereng Altjerrel Kwerrern Alngaltar arrehantherr-warn lanthetjenh, arrehantherrel-ayel kwetemeh anetjenheng. ");
INSERT INTO amx_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Altjerrelemeh alhelek, Kwerrern kwerenh lanthetjeh tjerrtj ineh, rang inenh ntangkekarl, tjerrtj kwerenh anetjenhengemeh. Nhenh-artek arrantherrenh, peltj ingkerneny arrehantherr-henh, tjerrtj mer arrpenh mapel-arlk.” ");
INSERT INTO amx_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Peter-elemeh inenh weth kaltj-anthek. Rang inenh ateng-ilemel ilek, “Altjerr pawenherrerrang, rang arrantherrenh anetjeng inem, rang arrantherrenh atwehetjeng tjerrtj anetj nhenh mapel-arleng.” ");
INSERT INTO amx_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Arltang kwerelemeh tjerrtj mapemeh 3,000 Peter kwer kangkwerrek, nakenh-nakenh mapel-ayeng inang nyent-irrek. Kaltj-anthenh-anthenh tjeperr mapel inenh kwatj-warn irrpelh-ilemel baptise-em-ilek. ");
INSERT INTO amx_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Kaltj-anthenh-anthenh tjeperr mapel inang nakenh-nakenh map kaltj-anthetjart. Nakenh-nakenh inang mantjel anthwerr awetjart, ineh kangkwerremel. Inang kangkentj ularrek-ularremeh mernelhetjart. Inang mern ltwakemel pwertel arlkwetjart. Inang Altjerr-warn kweteth angketjart. ");
INSERT INTO amx_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Kaltj-anthenh-anthenh tjeperr mapel twer angerr-akertel rrkwapetjart. Inang tjerrtj irlkert map mwerr-iletjart. Tjerrtj ingkerrekel nhenh lyetant aremel anwerlkek, inang kwek war ateremeh-irrek. ");
INSERT INTO amx_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Tjerrtj nakenh-nakenh inang pwert arraw-irretjart. Inang ingkerreny peltj anetjart. Inang mern-arlk ingkerrek mpwepeh arlkwetjart. ");
INSERT INTO amx_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Inang rnwanentj-arlk mer-arlk thwen inehenh sell-em-iletjart, maney inetjenhengarl wart. Kwereng inang maney nhenh tjerrtj angayel mapeh anthetjart. Inang kweteth yard kwenel arraw-irretjart, Altjerr-henh church angerretj-angwerr. ");
INSERT INTO amx_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Inang warl nyentam-nyentel arraw-irretjart, mern ltwakemel arlkwetjart, Jesu-eh irlpangkemel. Inang arrken awelhemel anetjart. ");
INSERT INTO amx_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Inang Altjerr angerr kangkemel nakek. Tjerrtj arrpenh map inang kangkek ineh, lakenh angkemel, “Yay! Tjerrtj nhenh map irlpareth kwenh anem!” Ngkartel wetharlam tjerrtj map inetjam, inang ngampekarl iteth anetjenheng. Inang Jesu nakenh-nakenhemeh irrek, werlampareny inehel-ayeng nyentemeh-irrek. ");
INSERT INTO amx_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Kel arltang arrpenh-ingar angwerrel, Peter John ratherr Altjerr-henh church angerretj-warn alherretjam, Altjerr-warn angketjeh-anngernt. Aherrk angwerrelarl tjerrtj Jew inang angketjart kweteth Altjerr-warn. Lakenh anek. ");
INSERT INTO amx_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Arrpenh mapel artwang arlamarr nyent angetjam arrew nyent kwer-warn, church angerretj iter-warn. Artwang rang kwer kwekeng-ntjel arlamarr anentjekarl. Arrew renh inang arreny mwerr anthwerr iletjart. Arltang arrpanenhel inang artwang arlamarr renh angetjetjart arrew nhenh-warn, rang maneyeh ankey nketjart arrew kwerel. ");
INSERT INTO amx_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Artwang arlamarrel arek Peter John thwen arrew-warn alherleh, church angerretj yard-warn irrpenhetjeh-anngernt. Rang kwer-atherr maneyeh ankey nkek. ");
INSERT INTO amx_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Peter John ratherr renh twant-arek. Peter-elemeh renh ilek, renh-atherrenh aretjeh. ");
INSERT INTO amx_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Artwang arlamarr rang renh-atherrenh twant-arek. Rang iterrek, ratherr kwer maney anthetjenharl kwel. ");
INSERT INTO amx_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Peter rang kwer ilelhek, “Yeng kwenh maney-kweny! Thang ngwenh warant ilem, Jesu Christ Nazareth-areny arrenyel-arleng, kemerremel nthwerl-apang!” ");
INSERT INTO amx_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Peter-elemeh renh iltjang antwerrkemel kemelh-ilemel ngkernek. Artwang arlamarr kwerenh ingkang nwererrk thwen twer-irrek-amparr alhetjeh-anngerntan. ");
INSERT INTO amx_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Artwang rang arlamarr-penh kemerremel mwerr alhekemeh. Rang Peter atherrel-ayeng church angerretj yard-warn irrpenhek. Rang arrken-irrerl-apetjam Altjerr renh nakek. ");
INSERT INTO amx_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Tjerrtj mapel renh arek nthwerl-aperleh, mwerremeh. ");
INSERT INTO amx_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Inang alhengk-arek artwang arlamarr renh. Rang arrew nhengel-ayel kwet intetjart, maneyehan ankey nketjart. Inang anwerlkemel pawenherrek, “Artwang nhenh kwenh arlamarrarl anek! Nthakenharlam rang mwerr-irrek?” ");
INSERT INTO amx_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Artwang rang Peter John renh-atherrenh kwet antwerrkek, ratherr lywang kwerel irnetjam. Tjerrtj mapel lywang iletjart Solomon-kenh lywang angerr. Tjerrtj mapemeh ineh-warn arrtjanentj-alhek anwerlkemel. ");
INSERT INTO amx_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Peter-el tjerrtj inenh arnaremel pawenhek, “Artwang Israel-areny mapay, wenh-penham arrantherr anwerlkek? Wenheham arrantherr ilernenh rtwant arerl-anem? Arrantherr iterl-arehetj apek, nheng ilernarl kwel renh mwerr-ilekarl? Itja, ilern itja renh mwerr-ilek. Ilern twer-kwenh anem. ");
INSERT INTO amx_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Altjerr nheng Abraham, Isaac, Jacob mapel nakentj-alhekarl, arrwekeleny nwern-henh mapel thwen renh naketjartarlam. Altjerrel rrkwapenh-apenh kwerenh Jesu kwenh alker-warn angkep anginek. Lyet Jesu rang parrtj angerrel-ayeng anem. Arrwekel arrantherr Jesu twernk Pilate-eh anthek. Pilate rang ahentj-anek, Jesu renh mer-warn lanthetjeh. Arrantherr ahentj-kweny-irrekarl. ");
INSERT INTO amx_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jesu rang arratj anthwerr anek, pelkeny. Arrantherr kwer ahentj-kweny anek. Arrantherr renh mentj impek. Arrantherr ahentj-anek, Pilate-el artwang arrpenhant mer-warn lanthetjeh, artwang merrentj nheng. ");
INSERT INTO amx_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Arrantherr artwang tjeperr renhant irrernng atwek. Rang kwenh tjerrtj Iteth-ilenh-ilenh anek! Altjerrel renh irrernngeng kemelh-ilek. Nwern kwer kaltj anem, nwern renh iteth arekarleng wart. ");
INSERT INTO amx_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Artwang nhenh arerrerray! Kwer arrantherr kaltj anem. Rang Jesu nakek. Lakenheng Altjerrel renh mwerr-ilek Jesu-henh arrenyel-ayel. Arrantherr nhenh keth arem. ");
INSERT INTO amx_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Peltj mapay, yeng kwenh kaltj, arrantherr angerrepat arrehantherr-henh mapel-arlk itja alhengk-arek, Jesu rang Altjerr-henh Ler anekarl wart. Lakenh arrantherr Pilate pawenhek, Jesu renh irrernng atwetjeh. ");
INSERT INTO amx_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Altjerrel nheng ngkwey ilekarl angketj angenh-angenh kwerenhel-arleng, inang Christ renh irlkert angerr anthwerr atwemel mpwaretjenh. Angketj nhenh kelant keth-irrek. ");
INSERT INTO amx_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Lakenheng arrantherr anetj impetjeh. Altjerr-warnant twep-irrerrerray, rang anetj arrehantherr-henh wetjenh. Kwereng rang arrantherrenh tjep-tjep-iletjenh. ");
INSERT INTO amx_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Kelant rang Christ arrehantherr-warn angkep lanthetjenh, artwang nheng Altjerrel arrwekel kwet ilek, Christ rang petjetjenh arrehantherr-warn. Jesu rang kwenh Christ nhenh anem, Altjerr rang alhelekarl arrehantherreh. ");
INSERT INTO amx_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Jesu mpank-amparr alkerel anetjeh. Altjerrel alker ahelh-arlk ingkerrek arratj-ilemel lyeteny-iletjenh. Kwereng Christ rang petj-alpetjenh. Altjerrel ngkwey nhenh arrwekel alhelekarl-penh angketj angenh-angenh kwerenh mapel-arleng. ");
INSERT INTO amx_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ngkwey Moses rang tjerrtj map ilek, ‘Altjerrel angketj angenh-angenh arrpenhemeh arrehantherr-warn lanthetjenh. Rang yeng-arteh anetjenh. Arrantherr kwer kangkwerretjeh! ");
INSERT INTO amx_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Tjerrtj ngwenh apek inarl angketj angenh-angenh nhenh kwer kangkwerretj-kweny anem, Altjerrel inenh anpwetjenh. Inang itja Altjerr-henh peltj anetjenh.’ Angketj nhenh Altjerrel Moses arrwekel kwet ilek. ");
INSERT INTO amx_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Samuel nhengel Altjerr-henh angketj angenh-angenh ingkern-penh mapel-arlk tjerrtj mapeh angketj artwang nheng Jesu Christ-akert arrwekel kwet ilek, nthakenh lyetarr irrekarl, lakenh-arteh anetjenh. ");
INSERT INTO amx_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Angketj alhelentj nhenh arrehantherr anem. Altjerrel nheng Abraham alhelek, ‘Peltj ngkwengenhel-arleng artwang nyent arratetjenh, thang tjerrtj ingkerrek ahelh-areny kwerel-arleng mwerr-iletjenh.’ Kelant alhelentj nhenh arrehantherr anthwerremeh anem. ");
INSERT INTO amx_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Altjerrel rrkwapenh-apenh tjeperr kwerenh arrehantherr-warn lanthek. Rang ahentj-anek arrantherrenh anetjeng twepelh-iletjeh, arrantherrenh mwerr-iletjenheng.” ");
INSERT INTO amx_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","2","Peter John ratherr tjerrtj mapeh angketjam-rlwer, priest map inang petjek kwer-atherr-warn, atwenh-atwenh twernk nyent-akert, artwang Sadducee map-akert-arlk. Inang ahentj-kweny-irrek angketj kwer-atherr-henheh, inarl tjerrtj inenh kaltj-anthetjam, tjerrtj ingkerrek kelant irrernngeng kemerretjenharl, Jesu rarl irrernngeng kemerrekarl-arteh. ");
INSERT INTO amx_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Kel angwerr-angwerr irrekarleng inang renh-atherrenh antwerrkemel tjayel-warn kwernek, kweny-rtwehemeh kwer-atherrel-ayel angkerretjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Tjerrtj mapel angketj kwer-atherr-henh nheng awekarl-penh, inang angketj renh nakek. Nakenh-nakenh inang aningk anthwerremeh irrek. Inang kel artwang 5,000 anek. ");
INSERT INTO amx_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Kel kweny-rtwehemeh twernk map, angerrepat map, Moses-henh mpwareng-areng kaltj-anthenh-anthenh map-arlk inang Jerusalem-el arraw-irrek, angkerretjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Annas priest twernk angerr rang, Caiaphas, John, Alexander, peltj arrpenh map inehenh-arlk, inang nyent-irrek. ");
INSERT INTO amx_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Inang Peter John renh-atherrenh tjayeleng arratelh-ilemel ngwek, inang renh-atherrenh mpwepeh ngkernek. Inang renh-atherrenh pawenhekemeh, “Nthakenham mpwel artwang arlamarr renh mwerr-ilek? Ngwenhelam mpwelenh twer-ilek, renh mwerr-iletjeh? Ngwenh-henh arrenyelam mpwel renh mwerr-ilek?” ");
INSERT INTO amx_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Peter renh Kwerrern Alngaltarel twer-ilek, rang ineh-warn angketjeh-anngernt. Peter rang angkek, “Twernk mapay, angerrepat map-arlkay! ");
INSERT INTO amx_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Wenhekam arrantherr pawenhem artwang arlamarrekan? Arrantherr alhengk-aretjeh key, nthakenh ilern renh mwerr-ilek? ");
INSERT INTO amx_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ilern lakenhant arrantherrenh ilem, arrantherr awetjehant. Ilern kwenh renh mwerr-ilek, Jesu Christ Nazareth-areny arrenyel-ayeng. Jesu renh arrantherr ntwerlkeh arrernekarl, Altjerrel renh irrernngeng kemelh-ilekarl. ");
INSERT INTO amx_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Arrantherr Jesu renh kwel anetjeh-athen arek. Arrantherr ahentj-kwenh anek, rang pel tjeperr anthwerr ingkerrekeh. ");
INSERT INTO amx_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Jesu rant kwenh tjerrtj anetjengan inem. Tjerrtj ngwenh apek inang ahentj-irrem, Altjerrel inenh anetjeng inetjeh, inang ngampekarl iteth anetjenheng, inang Jesu renhant naketjenh, arreny kwerenh ilemel. Kwereng Altjerrel inenh peltj-iletjenh, inang Altjerr-henh arlaltj mapel-ayeng anetjenheng.” Lakenh Peter-el inenh ilek. ");
INSERT INTO amx_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Artwang twernk inang Peter John renh-atherrenh twant-arek, ratherr anew-anew anthwerr angkerleh. Inang alhengk-arek, ratherr anetj-anetj war anek, inangkal-kweny. Lakenheng inang anwerlkek. Inang alhengk-arek, ratherr Jesu-el-arleng anekarl. ");
INSERT INTO amx_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Artwang mwerr-irrekarl rang kwer-atherrel-ayeng angath irnetjam, lakenheng twernk inang angketj-kwenyemeh irrek. ");
INSERT INTO amx_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kwereng inang Peter John renh-atherrenh lanthek keth-warn, inarrpemeh angkerretjenh. ");
INSERT INTO amx_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Artwang nhenh-atherrenh nwern nthakenh ileyay? Tjerrtj Jerusalem-areny ingkerrek kaltj, ratherr twer angerr-akertel mpwarekarl. Nwern nhenh-penhan itja pal-angketjeh. ");
INSERT INTO amx_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Nwern renh-atherrenh arnpaketjeh, tjerrtj arrpenh mapel nhenh-penh awehetjeng. Ratherr itja Jesu-kenh angketjeng kaltj-anthetjeh tjerrtj map.” ");
INSERT INTO amx_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Inang kwer-atherr weth ntangkelhek, kwen petj-alpetjeh. Inang renh-atherrenh arnpakek, “Mpwel itja angketj Jesu-henh arrenyel-ayel kaltj-anthetjeh!” ");
INSERT INTO amx_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Peter John ratherr inenh ilek, “Arrantherrarrp iterrewarray, wenh apek Altjerreng ularr arratj anem? Ilern ngwenheham kangkwerretjenh? Altjerreh apek? Arrehantherr apek? Ilern arrehantherr kangkwerretj-kweny anetjenh, ilern kangkwerrem Altjerrekant. ");
INSERT INTO amx_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ilern itja awenp anetjenh. Kel ilern nheng arekarl awekarl-arlk, ilern kaltj-anthetjekant tjerrtj map.” ");
INSERT INTO amx_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Tjerrtj ingkerrekel Altjerr renh nakekarl, rarl tjerrtj nyent mwerr-ilekarl. Lakenheng twernk inang ywarn iterrek. “Nwern itja renh-atherrenh atwetjeh tjerrtj mapeng anngetherr.” Inang renh-atherrenh iltekant war, “Mpwel apek anetj mpwarem, nwern mpwelenh atwemant!” Kwereng inang renh-atherrenh mentj impek, ratherr alherretjeh. ");
INSERT INTO amx_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Artwang nheng Peter-el John-el thwen mwerr-ilek, artwang rartek 40 years old, aywang anek. ");
INSERT INTO amx_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kwereng ratherr nakenh-nakenh map-warn alpek. Ratherr ingkerrek inenh ilek, nheng nthakenh-nthakenh priest twernk mapel angerrepat mapel-arlk renh-atherrenh ilek. ");
INSERT INTO amx_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Nakenh-nakenh inang nhenh awemel, inang Altjerr-warn angkek, “Ngkartay! Ntwang kwenh alker ahelh-arlk alay-arlk arrmernek. Ntwang alker-areny ahelh-areny kwatj-areny ingkerrek arrmernek. ");
INSERT INTO amx_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ntwang kwenh arrwekeleny David-el-ayel angkekarl. Ntwang David renh ilek, lakenh rang angkek Kwerrern Alngaltarel-ayel, ‘Wenheng tjerrtj lwereny map arnkely-irrem? Wenhengam inang ngkwantj-irretjeh? ");
INSERT INTO amx_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","King ahelh-areny map twernk map-arlk arraw-irremel nyent-irrek, angkerretjeh-amparr. Inang ahentj-kweny anek Ngkarteh irrpelth-irrek, Christ kwerenheh thwen.’ Lakenh King David-el Kwerrern Alngaltarel-ayeng ilek, arrwekel kwet.” ");
INSERT INTO amx_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Inang ilek, “Mer nhenh Jerusalem-el, King Herod Pontius Pilate thwen ratherr nyent-irrek tjerrtj lwereny mapel-ayeng, tjerrtj Israel-areny mapel-ayel-arlk thwen. Inang angkerrek, rrkwapenh-apenh tjeperr ngkwengenh Jesu atwetjeh-anngernt. Jesu rang Christ ngkwengenh anem. ");
INSERT INTO amx_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Inang Jesu renh irrernng atwek, ntwarl arrwekel kwet ilekarl-arteh. ");
INSERT INTO amx_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ngkartay, nwern rrkwapenh-apenh ngkwengenh anem. Ntwang kel arem, nwerneh inang ngkwantj-irremarleng. Nwern ngwenh pawenhem, ntwang nwernenh twer-iletjeh, nwern angketj ngkwengenh anew-anewel kwet kaltj-anthetjenheng. ");
INSERT INTO amx_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ntwang tjerrtj irlkert map mwerr-iletjeh! Twer angerr ngkwengenh-akertel wart mpwaretjeh! Nwern ngwenh pawenhem, nheng Jesu-henh arrenyel-ayel tjerrtj irlkert map-arlk mwerr-iletjeh. Rang kwenh arratj anthwerr anem, rrkwapenh-apenh ngkwengenh.” Lakenh inang Altjerr pawenhek. ");
INSERT INTO amx_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Tjerrtj map warl kwenel anetjam. Warl rang ineh-akert arrewek. Kwerrern Alngaltar ineh-warn irrpek. Kwereng inang anew-anewel Altjerr-henh angketj iletjart. ");
INSERT INTO amx_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Tjerrtj nakenh-nakenh inang pwertemeh anek, iterrentj nyent-akert. Inang rnwanentj mpwepehemeh arrernek, arrpenhel apek rnwanentj inetjeh apek ahentj-irrem, kel rang inetjeh. Inang itja rnwanentj inehenh ayerrp-iletjeh. ");
INSERT INTO amx_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Kaltj-anthenh-anthenh tjeperr inang angketj twerel kaltj-antherl-apetjam, Ngkart Jesu irrernngeng kemerrekarl-penh. Altjerrel inenh ingkerrek arntarnt-arek, inang twer kwet anetjeh. ");
INSERT INTO amx_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Inang mern antherl-apetjam, itja nyent angayel anek, itja nyent rnwanentj-kweny-arlk anek. Arrpenh map farm-eh-artwey apek, warleh-artwey apek, inang farm apek warl apek sell-em-iletjart, maneyeh ankeyel. ");
INSERT INTO amx_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Kwereng inang maney inehenh kaltj-anthenh-anthenh mapeh anthetjart. Kaltj-anthenh-anthenh inang maney rnwanentj-kweny mapeh anthetjart, lharrp-irremel. ");
INSERT INTO amx_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Artwang nyent arreny Joseph mer Cyprus-el mangkekarl. Rang anek Levi-henh peltj-penh. Kaltj-anthenh-anthenh tjeperr map angkek, “Joseph-el kwenh tjerrtj map tjep-tjep-ilek!” Lakenheng inang renh arreny arrpenhemeh anthek Barnabas. ");
INSERT INTO amx_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Barnabas-el farm kwerenh maneyeh ankeyel sell-em-ilek. Rang maney renh kaltj-anthenh-anthenh mapeh anthek. ");
INSERT INTO amx_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Anewart Ananias Sapphira ratherr nakenh-nakenh anek. Ratherr mer farm kwer-atherr-henh sell-em-ilek, maney mpwarek. ");
INSERT INTO amx_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ananias rang maney arrpenh ngakek, werlamparenyeh anthetjeh, kenh maney arrpenh kwewalenyarl anyenek. Anew kwerenh kaltj anek nhenhek. Ratherr rrtjwerrek, maney ingkerrek anthetjeh kwel werlamparenyeh. Ananias rang maney arrpenh kaltj-anthenh-anthenh tjeperr map-warn angek. Rang maney ineh anthek. ");
INSERT INTO amx_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Peter-elemeh renh ilek, “Ananias-ay, ntwang Kwerrern Alngaltarek rrtjwerrek! Lakenh ntwang arrentjekarrp kangkwerrek! Ntwang maney ingkerrek anthek-arrpantey kwel werlamparenyeh, ntwang kwenh kel maney arrpenh ngakek, ngkwewaleny rrkwetjeh! Ntwang kert arrpenhant anthek. ");
INSERT INTO amx_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Mer farm rang kwenh ngkwengenh anek. Mer renh sell-em-ilekarl-penh, maney rang ngkwengenh anek. Kel mwerr lakenheh-atwetj, ntwang maney ingkerrek war anyenetjeh ngkwengarrp. Ntwang ilem, ntwang ingkerrek anthekarl kwel. Itja! Ntwang kwenh arrpenh ngakemel alengk-wek! Wenhengam ntwang anetj mpwarek? Ntwang kwenh Altjerreh rrtjwerrek, itja nwernehant!” ");
INSERT INTO amx_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananias-el lakenh awemel rang ahelh-warn irrernng anyerl-alhek. Tjerrtj mapel angketj Ananias-akert awek, inang ater-irrek. ");
INSERT INTO amx_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Artwang map petjek Ananias kwer-warn, inang renh mantarrel arltwek. Inang renh keth-warn angerrerrek awenng-warn, kel inang renh awenngel-antem arrernek. ");
INSERT INTO amx_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kelant anew kwerenh Sapphira irrpentj-alhek warl-warn. Sapphira rang pal awetj-kweny anek, nheng anew kwerenh ilwekarleng. ");
INSERT INTO amx_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Peter-elemeh renh pawenhek, “Tjeng ilay, mer mpwel-henh sell-em-ilekarl-penh. Arratjam maney mpwel-henh anthek ingkerreny key?” Marl rang angkek, “Yew, ilern maney ingkerreny anthek.” ");
INSERT INTO amx_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Peter-elemeh renh ilek, “Wenheham mpwel nyent-irrek, Ngkart-henh Kwerrerneh rrtjwerremel ilelhetjehan? Aray, tjerrtj kethel karelhem, anew ngkwengenh awenngel arrernekarl-penh. Inang ngkwengemeh kethel karelhem! Inang ngwenh-arlk angenhetjenh awenng-warn!” ");
INSERT INTO amx_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Sapphira rang kel Peter-eng ularr irrernng anyerl-alhekarl. Artwang inang irrpentjek, inang arek marl rang kel ilwek. Inang renh keth-warn angerrerrek, artwang anew kwerenh-angkwerr arrernek awenng nyent kwerel. ");
INSERT INTO amx_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Werlamparenyel tjerrtj ingkerrekel thwen inang angketj nhenh awek, inang ater anthwerremeh irrek. ");
INSERT INTO amx_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Kaltj-anthenh-anthenh tjeperr inang twer angerr-akertel tjerrtj map mwerr-iletjart. Werlampareny inang kweteth lywang-warn arraw-irretjart Altjerr-henh church angerretj-angkwerr, arreny Solomon-henh lywang-warn. ");
INSERT INTO amx_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Tjerrtj arrpenh mapel inenh aremel nakek. Inang iterrek, werlamparenyel-ayel nyent-irretjeh. Inang ater-irrek twernk Jew map-hetj. Lakenh-hetj inang itja nyent-irrek ineh-warn. ");
INSERT INTO amx_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Tjerrtj aningkelemeh Ngkart renh nakek, artwang mapel marl mapel-arlk. ");
INSERT INTO amx_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kwereng tjerrtj mapel irlkert map arlamarr map-arlk inenh keth-warn angetjart, antjamel intetjeh. Tjerrtj irlkert inang mpwelhetjam, Peter rang apek anper alhetjenheng, lywang kwerenhel inenh mwerr-iletjenh apek. ");
INSERT INTO amx_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jerusalem-warn town kwek map-penh tjerrtj aningk anthwerr inang petjek. Inang tjerrtj irlkert tjerrtj kwerrern anetj-akert-arlk kaltj-anthenh-anthenh tjeperr map-warn angetjewarrek. Kaltj-anthenh-anthenh mapel inenh ingkerreny mwerr-ilek. ");
INSERT INTO amx_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Priest twernk angerr artwang Sadducee map thwen kaltj-anthenh-anthenh tjeperr mapeh arnkely-irremel anngwenhek. ");
INSERT INTO amx_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Inang kaltj-anthenh-anthenh inenh antwerrkemel tjayel-warn kwernek. ");
INSERT INTO amx_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Kwenyel Ngkart-henh angel ngwerrm-irrek tjayelel kwen. Angelel tjayel-henh door map altjwer-ilek, inenh keth-warn tjey-angekemeh. ");
INSERT INTO amx_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Rang ilek, “Church angerretj-warn alherrerray, yard-warn kwen! Arrantherr tjerrtj map ilay angketj ingkerrek Jesu-akert, rang iteth-ilenh-ilenh anem.” Kwereng angel rang ywerrenhek. ");
INSERT INTO amx_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Aherrk lyet-atheh arratetjam-rlwer inang church angerretj yard-warn irrpenhek, tjerrtj inenh kaltj-anthetjeh. Priest twernk angerr rang artwang kwerenh mapel-arlk angerrepat map-arlk arrawelh-ilek, angkerretjeh. Inang Council map lakenh wart anek. Inang rrkwentj lanthek, kaltj-anthenh-anthenh inenh tjayeleng arratelh-iletjeh. Inang iterrek, kaltj-anthenh-anthenh inang kwel tjayelel kwet anemarleh-athen. ");
INSERT INTO amx_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Artwang rrkwentj inang tjayel-warn irrpenhek. Inang kaltj-anthenh-anthenh ineh ywarek. Inang angkep alpek, twernk inenh iletj-alpetjeh, ");
INSERT INTO amx_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Nwern tjayel-warn alhek, arrew ingkerrek mart-ilentj kwet arentj-alhek. Nwern arrew arntarnt-arenh-arenh inenh arek, arratj arntarnt-arerleh. Nwern arrew map-angkwerr irrpenhek tjayel-warn kwen, artwang ineh ywarek, inang ywerreh!” ");
INSERT INTO amx_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Rrkwentj twernkel priest twernk mapel-arlk angketj nhenh awemel inang ywarn iterrek, “Nthakenharlam?” ");
INSERT INTO amx_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Artwang nyent petjek, inenh ateng-iletjeh, “Artwang nheng map arrantherrarl palenthwem, inartek church angerretj yard-el tjerrtj map kaltj-antherl-anem!” ");
INSERT INTO amx_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Rrkwentj twernk alhek rrkwentj rrpwetj-akert, kaltj-anthenh-anthenh inenh ngwerl-alpetjeh. Rrkwentj inang itja kaltj-anthenh-anthenh ineh ahang-irrek. Rrkwentj mapan tjerrtj mapeng inang ater-irrek wart, pwertel inenh iltewehetjeng. ");
INSERT INTO amx_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Kel kaltj-anthenh-anthenh tjeperr inenh ngwerl-alpek, inenh ngkernek Council mapel-arleng mpwepel. Priest twernk angerrel inenh ilek, ");
INSERT INTO amx_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Nwern kwenh arrantherrenh nheng arnpakekarl, itja arrantherr kaltj-anthetjeh Jesu-henh angketj. Kenh arrantherr itja kangkwerrekarl. Arrantherr tjerrtj Jerusalem-areny ingkerrek kaltj-anthekarl kwel, rrtjwerremel war! Arrantherr angketjam, nwern Jesu renh irrernng atwekarl kwel!” ");
INSERT INTO amx_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Peter-el kaltj-anthenh-anthenh arrpenh mapel thwen inenh ilek, “Nwern Altjerrehant kangkwerrem, nwern itja kangkwerretjenh tjerrtj arrpenh mapeh apek! ");
INSERT INTO amx_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Iterl-arerrerray, arrantherr Jesu renh ntwerlk-warn arrernek, arrantherr renh irrernng-warn atwekarl. Altjerr nhengel arrehantherr-henh peltj mapel renh naketjart, Altjerr Angeyel kwenh Jesu renh irrernngeng kemelh-ilekan. ");
INSERT INTO amx_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Kwer-penh Altjerrel renh ngkernek, twernk angerr kwetant anetjeh, Arntarnt-arenh-arenh tjeperr angerr. Tjerrtj inarl kwer-warn twep-irrem, rang anetj inehenh wem. Kwereng Altjerr rang kangkentj angerr anetjenh ineh. ");
INSERT INTO amx_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nwern kaltj anem Jesu-ek, nwern renh arekarl-penh. Kwerrern Alngaltar rang kaltj. Nwern arrehantherr angketj nhenh ilem, Kwerrern Alngaltarel nwernenh twer-ilekarleng. Tjerrtj arrpenh map inarl Altjerreh kangkwerrem, Altjerr rang ineh Kwerrern Alngaltar anthem.” Lakenh Peter-el inenh ilek, arrpenh mapel-arlk. ");
INSERT INTO amx_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Council inenh awemel ineh ahang-irrek. Inang ahentj-anek, kaltj-anthenh-anthenh inenh irrernng atwetjeh. ");
INSERT INTO amx_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Council ineheng artwang nyent kemerremel irnek. Rang artwang Pharisee anek, arreny kwerenh Gamaliel. Gamaliel rang Moses-henh mpwareng-areng kaltj-anthenh-anthenh anek. Tjerrtj mapel renh naketjart. Rang rrkwentj map ilek, kaltj-anthenh-anthenh inenh keth-warn lanthetjeh-amparr. ");
INSERT INTO amx_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Kwereng rang Council inenh ilek, “Artwang Israel-areny mapay! Arrantherr mantj anthwerr iterretjeh-amparr, artwang nhenh map atwetjenheng-anngerntan. ");
INSERT INTO amx_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Iterl-arang artwang nheng arreny Theudas. Year arrpenh-lkwer war Theudas rang nakelhek, rang kwel artwang tjeperr anemeng. Artwang 400 kwer-warn nyent-irrek. Artwang atwenh-atwenh mapel renh irrernng-warn atwek. Aningk kwerenh map ateremeh arrtjanewarrek. Kel inang irrarnp-irrek. ");
INSERT INTO amx_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Kwereng artwang arrpenhemeh petjek, arreny kwerenh Judas, mer Galilee-areny nheng. Rang nakelhek, nwernenh nheng Government-el count-em-iletjam-rlwer. Kwereng artwang arrpenh map nyent-irrek Judas kwer-warn. Artwang inang ahang-irrek Government-ek, ngkwal atwerretjeh anek. Atwenh-atwenh mapel Judas renh irrernng-warn atwek. Kwereng tjerrtj kwerenh map ater arrtjanewarrek. ");
INSERT INTO amx_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","39","Lakenheng thang arrantherrenh ateng-ilem: Angketj lyeteny nhenh inarl tjerrtj map kaltj-anthem, nhenh apek tjerrtj-henh angketj war anemeng, angketj rang ywerretjenh. Angketj nhenh map-kenh rang apek Altjerr-henh angketj anemeng, nwern inenh ywarn kwet arnpakem. Nwern rwekenth-kenth-irretjenh Altjerrel-ayeng! Artwang nhenh map kel impang, inarrp alhetjeh.” Lakenh Gamaliel-el ilek Council-eng ularr. ");
INSERT INTO amx_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Council inang Gamaliel-ek kangkwerrek. Inang kaltj-anthenh-anthenh mapeh weth ntangkek. Inang atwenh-atwenh map ilek, kaltj-anthenh-anthenh inenh whip-el atwetjeh. Inang kaltj-anthenh-anthenh inenh ilek, “Arrantherr itja weth tjerrtj map Jesu-kenh angketjel kaltj-anthetjeh.” Kwereng inenh lanthek. ");
INSERT INTO amx_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Kaltj-anthenh-anthenh tjeperr inang Council map-hetj alpek, arrken anthwerr awelhemel. Inang iterrek, “Altjerrel nwernenh arek, nwern itja ntjwem-irretj-kwenh anek Jesu-henh arrenyeh, nwern kwenpel kwet arreny kwerenh kaltj-anthek. Altjerr rang arrken awelhek nwerneh.” ");
INSERT INTO amx_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kaltj-anthenh-anthenh tjeperr inang kweteth church angerretj yard-el kaltj-anthetjart, mer arrpenh mapel-arlk. Inang tjerrtj inenh angketj Jesu-akert kaltj-anthetjart, Jesu rang Christ nheng anemeng, Altjerrel ngkwey alhelekarl, ahelh-warn lanthetjenh kelant. ");
INSERT INTO amx_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Kel town Jerusalem-el tjerrtj aningk nakenh-nakenh irrekarlemeh. Arrpenh map angketj Greek angkenh-angkenh anek, arrpenh map angketj Hebrew angkenh-angkenh map anek. Kwereng tjerrtj Greek angkenh-angkenh map tjerrtj Hebrew angkenh-angkenh mapeh inang merneng kwerl-angketjart, “Inang itja inpert map nwern-henh mernel wantek!” ");
INSERT INTO amx_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kaltj-anthenh-anthenh tjeperr inang nakenh-nakenh ingkerrek ntangkemel arrawelh-ilek. Kwereng inang inenh ilek, “Tjeperr anem nwerneh, nwern Altjerr-henh angketj kaltj-anthetjeh arrantherrenh. Nwern itja nhenh mentj impetjek. Nwern itja arrantherrenh mernel wantetjenh. Nwern Altjerr-henh angketj itja mentj impetjek. ");
INSERT INTO amx_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Peltj mapay, lakenheng arrantherr artwang 7 urraremel ngkernetjeh, artwang Kwerrern Alngaltar-akert iterrentj mwerr-akert thwen, nwernemeh inenh ngkernetjenheng, arrantherrenh wantetjeh mernel. ");
INSERT INTO amx_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nwern kenh kwetarl rrkwapentj arrpenh nhenh mpwaretjeh, Altjerrek angkemel pawenhetjeh, Altjerr-henh angketj kaltj-anthetjeh kwet.” Lakenh kaltj-anthenh-anthenh mapel werlampareny inenh ilek. ");
INSERT INTO amx_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Werlampareny inang angketj nhenheh kangkek. Inang Stephen-amparr urraremel inek. Rang artwang nakentj angerr-akert anek wart, Kwerrern Alngaltar twer angerr-akert. Inang nakenh-nakenh arrpenh mapemeh nyentam-nyent urrarek: Philip, Procorus, Nicanor, Timon, Parmenas, Nicolas. Nicolas nhenh rartek Antioch town-areny anek. Arrwekel rang itja Jew anek. Kwereng rang Jew irrek-amparr, ingkern rang Jesu nakek. ");
INSERT INTO amx_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Artwang 7 inenh werlamparenyel kaltj-anthenh-anthenh tjeperr map-warnemeh angetjek. Kaltj-anthenh-anthenh inang iltjang arrernek inehenh kapert-warn, Altjerr tjang-pawenhemel ineh. ");
INSERT INTO amx_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Kwereng werlamparenyel tjerrtj map kaltj-anthetjam-antim. Tjerrtj Jerusalem-areny aningk nakenh-nakenhemeh irrek. Priest mapel-arlk Jesu renh nakek-antim. ");
INSERT INTO amx_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Altjerr rang Stephen-eh kangkentj mernelhetjart, lwerenh-penh wart rang twer angerr-akertel mpwaretjart tjerrtj mapeng anngetherr. ");
INSERT INTO amx_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Artwang arrpenh map Stephen kwer ahentj-kweny-irrek. Tjerrtj nhenh inang Jew anek, Cyrene town-areny Alexandria town-areny thwen arrwekel petjekarl. Inang church nyentel irrpetjart, church kwerenh arreny anek “Church twernk-kweny map-kenh”. Inang arrwekel rrkwapenh-apenh twernk-akert anetjart, kwereng inarrp war twernk-kwenyemeh anek. Artwang nhenh Stephen renh inang iltetjamemeh ahang-irremel. Artwang rrpwetj arrpenh inarl mer Cilicia-eng mer Asia-eng thwen petjekarl inang renh iltetjam. ");
INSERT INTO amx_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Stephen rang inangkal anthwerr anek, Kwerrern Alngaltar-akert. Rang anew-anewel kwet inenh ilek, inenh intertelh-ilek. Inang ywarn iterrekemeh, nthakenharl inang renh tjernetjenh. ");
INSERT INTO amx_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kwereng artwang nhenh inang artwang anetj rrpwetj lanthek, angketj Stephen-akert rrtjwerremel ilerl-apetjeh. Artwang rrtjwerrentj inang tjerrtj mapeng ularr ilerl-apetjam lakenh angkemel, “Nwern Stephen renh awek, arrampewerleh Moses Altjerr thwen!” ");
INSERT INTO amx_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Lakenh inang artwang Jew map tjerrtj angerrepat map artwang Moses-henh mpwareng-areng kaltj-anthenh-anthenh map thwen inenh rrwampey-ilek. Inang Stephen renh antwerrkemel Council-warn angerrerrek. ");
INSERT INTO amx_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Inang artwang rrpwetj twernek, Council-eng ularr rrtjwerretjeh, “Artwang nhenhel kwenh Altjerr-henh church angerretj Moses-henh mpwareng-areng thwen kweteth arrampewem kwel. ");
INSERT INTO amx_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nwern renh awek, rang tjerrtj map ilerleh, Jesu Nazareth-areny nhengel kwel church angerretj nhenh taketjenharl. Jesu rang kwel angketj nwern-henh angart-wetjenheng, angketj nheng Moses-el ngkwey angerrepat nwern-henh kaltj-anthekarl.” ");
INSERT INTO amx_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Council inang Stephen renh twant-arek. Inang arek, inngerr kwerenh angel alker-areny-arteh amparrkerleh. ");
INSERT INTO amx_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Priest twernk angerrel Stephen renh pawenhek, “Angketj arratj key ngkweng-akert inang ilem?” ");
INSERT INTO amx_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stephen-elemeh inenh ilek, “Peltj mapay! Angerrepat mapay! Yeng-amparr awerrerrang! Altjerr nheng nwernarl nakem rang parrtj angerr-akert anem. Altjerr rang kwenh arrwekeleny nwern-henh Abraham kwer angkek, ngkwey anthwerr, rang nheng mer Mesopotamia-elarl anetjam-rlwer, rang mpank-amparr Haran-warn alhetjeh-anngernt anetjam. ");
INSERT INTO amx_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Altjerrel Abraham renh ilek, ‘Mer ngkwengenh peltj ngkwengenh map thwen imperl-alhang, ntwang mer arrpenh-warn alhang, tharl ngkweng mer renh mernetjenharl.’ ");
INSERT INTO amx_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Abraham-el mer Chaldea imperl-alhemel, rang mer Haran-warn alhek, mer nhenhel rang antarl-irrek. Angey kwerenh Terah ilwekemeh mer Haran kwerel. Kwereng Altjerrel Abraham renh mer nhenh-warn lanthek, mer kwerel nwern lyet anemarl-warn. ");
INSERT INTO amx_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Altjerrelemeh mer renh itja kwer anthek, mpank-amparr. Rang Abraham alhelekant war, mer renh anthetjeh kwel, kelant apek anthetjenh mer renh arlaltj kwerenh mapehan. Altjerr Abraham kwer angketjamarl-rlwer, Abraham rang ler-kweny-amparr anek, mpank kwet. ");
INSERT INTO amx_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Altjerrel Abraham renh ilek, ‘Peltj arlaltj ngkwengenh map tjerrtj arrpenh map-henh merel-ayeng-amparr anetjenh 400 years-ek-atwetj. Inang tjerrtj mer kwer-areny mapeh angerr rrkwapetjeh-amparr. Tjerrtj mer-areny mapel itja rrkwapentj-penheh maney kwart-wem. Inang irlkert angerrant war anetjenh. ");
INSERT INTO amx_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ingkern thang tjerrtj lwereny map irlkert angerr anthwerr anthetjenh. Kwereng peltj arlaltj ngkwengenh map mer lwereny kwereng anam-irretjenh, inang mer nhenh-warn alpetjenh, inang nhenhel kelkertel-ayel yengenh arrernelhemel naketjenh, lakenh.’ ");
INSERT INTO amx_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Altjerrelemeh Abraham renh ilek, ‘Ntwang, peltj ngkwengenh map-akertel, arrantherr rrwey ingkerrek artwang-iletjeh, kel inang 8 days old-emeh anemarleng wart.’ Kelant Abraham-el ler rrwey kwerenh Isaac artwang-ilek, rang 8 days old-emeh anekarleng. Kel ingkernemeh Isaac rang ler rrwey kwerenh Jacob renh artwang-ilek. Ingkernemeh Jacob-el ler rrwey kwerenh 12 inenh artwang-ilek-antimarlam. Nwern ingkerrek Jacob-kenh ler 12-eng arratekarl, lakenh nwern anem. ");
INSERT INTO amx_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Jacob-henh ler map inang tjey inehenheh Joseph-eh arnkely-irrek. Kwerenh kekw mapel Joseph renh artwang lwereny mapeh sell-em-ilek. Artwang lwereny mapelemeh Joseph renh mer arrpenh-warn Egypt-warn anginek. Joseph rang angerr rrkwapek, inang renh itja rrkwapentj-penh kwart-wek. Altjerr rang Joseph-el-ayeng kwet anek. ");
INSERT INTO amx_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Rwekenth-kenth-rlwer Altjerrel renh arntarnt-arek. Altjerrel renh iterrentj mwerr anthek, rang kaltj anek inangkal anthwerr. Egypt-areny-henh king arreny Pharaoh anek, rang Joseph-eh arrken anthwerr awelhek. Pharaoh-el renh ngkernek, mer Egypt ingkerrekeh twernk angerr anetjeh, warl angerr kwerenh rnwanentj kwerenh arntarnt-aretjeh. ");
INSERT INTO amx_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Kwer-penh kwatj-kwenyemeh mer apanpel anek, mern-kweny ker-kweny-arlk. Mer Egypt ntjaperel mer Canaan ntjaperel thwen tjerrtjeh arrakelakel anthwerr anek mern-kweny. Arrwekeleny inang angayel anetjart. Tjerrtj ingkerrek pwelek-arlkemeh angayel irrek. ");
INSERT INTO amx_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Jacob-elemeh awek, mern angerr kwel Egypt kwerel anetjamarl. Jacob rang ler kwerenh map mer Egypt-warn lanthek. ");
INSERT INTO amx_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Inang Egypt-warn alhek, mern angkep anginek mer Canaan-warn. Mern nhenh ywerrekarleng inang weth Egypt-warn angkep alhek, mern inetjeh. Inang Egypt-el anetjam-rlwer, Joseph rang kwewaleny ilelhekemeh kekw mapeh, rang tjey ineh anthwerr wart anek. Ingkern Pharaoh-el awek angketj Joseph-akert, artwang nheng inang yatjarr petjekarl inang Joseph-kenh kekw map anek. ");
INSERT INTO amx_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Kwereng Joseph-el ilek angerrepat kwerenh map, ‘Angkep alperrerrang, angey nwern-henh peltj nwern-henh-arlk ngwerl-atherr-alpang nhenh-warn, ingkerrek-antey.’ Peltj inenh inang tjerrtj 75 pel anek. ");
INSERT INTO amx_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Kel Jacob rang Egypt-warn alhek, peltj kwerenh mapel-arleng. Mer Egypt kwerelemeh Jacob ilwek. Kelant ingkern-penh arrpenh map Egypt kwerel ilwek. ");
INSERT INTO amx_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Kel arrpenhelemeh inang Jacob-henh ler map inehenh ngkwern map angkep angenhewarrek mer Canaan-warn town Shechem-warn. Inang ngkwern inehenh intey-warn kwernek, intey nheng Abraham-el ngkwey Hamor-henh ler mapeng payem-ilekarl. ");
INSERT INTO amx_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Mer Egypt-el kel nwern-henh peltjemeh aningk-irrek. Altjerremeh iterrek, inenh mer Canaan-warn angkep anginetjeh, mer nheng rang Abraham renh arrwekel alhelekarl-warn, mer nhenh anthetjeh. ");
INSERT INTO amx_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kwereng king arrpenhemeh mer Egypt kwerel inang ngkernek. King rartek itja angketj Joseph-akert awekarl apek, rang pal war anek. ");
INSERT INTO amx_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Rang tjerrtj nwern-henh map rrtjwerremel war iletjam, ineh ahang-irremel. Rang inenh twernek, kwer ampelyerrk map keth-warn mentj wetjeh, inarrp ilwetjeh. ");
INSERT INTO amx_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“King Pharaoh nhenh rang anetjam-rlwer, Moses-emeh ngwerrm-irrek. Moses rang ntwat anthwerr anek. Angey matj kwerenhel thwen renh warl kwenel alengk-wek, 3 months-ek-atwetj. ");
INSERT INTO amx_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Matj kwerenhel renh panthel-ayel arrernek, kwereng kwatj-warnemeh arrernek. Pharaoh-henh ler marlelemeh renh panthel-ayeng intetjamarl ngwerrm-ilek-amparr. Kelant rang renh mer kwerenh-warnemeh anginek, rang kwer kwerenhemeh anek, rang renh mangkelh-ilemel ayerrpelh-ilek, kwewaleny. ");
INSERT INTO amx_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Egypt-areny mapelemeh Moses renh inang kaltj-anthek angerr anthwerr. Rang kaltj anthwerr irrek, twer anthwerr irrek.” ");
INSERT INTO amx_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Moses rang 40 years old anek. Rang iterrek tjerrtj arlaltj kwerenh map-warn Israel-kenh map-warn yatjarr alhetjeh, inenh arerl-alpetjeh. ");
INSERT INTO amx_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Rang talkw alhetjam-rlwer, rang arerl-alhek, artwang Egypt-arenyel artwang arrpenh atwetjamarl, artwang renh kwenh Moses-kenh peltj anek. Kwereng Moses rang artwang Egypt-areny irrernng atwek ankwerl. ");
INSERT INTO amx_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moses-emeh lakenh iterretjam, ‘Lyet nhenh map inang iterrem kwel, nheng Altjerrel yengenh lanthekarl wart, inenh arntarnt-aretjeh.’ Itja kwenh, inang kwenh itja kaltj anek. ");
INSERT INTO amx_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Arltang arrpenhel rang arek artwang Israel-kenh peltj atherr atwerrerleh. Rang renh-atherrenh arnpakemel ilek, ‘Mpwel kwenh akenheng-atherr, mer nyent-areny atherr! Wenhengam mpwel atwerrem?’ ");
INSERT INTO amx_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Artwang rarl artwang arrpenheh ahang-irrekarl, artwang arrpenhelan Moses anampart-wek. Rang Moses renh angkep iltek, ‘Ntwang ilernenh itja lakenh iletjeh! Ngwenham ntwang, twernk angerr kwel? ");
INSERT INTO amx_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ntwang key ahentj-anem, ntwang yengenh irrernng atwetjeh, ntwarl artwang arrpenh nheng angwerreh irrernng atwekarl-arteh?’ ");
INSERT INTO amx_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Moses rang ater arrtjanek renh iltekarl-penh mer Midian-warn. Mer Midian kwerel rang kwet irretj-alpek. Arltang arrpenhel rang anew inek, kwereng kwer rrwey atherr ngwerrm-irrek. ");
INSERT INTO amx_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Rang 40 years-eh-atwetj mer Midian-el anek. Kwereng angel alker-areny kwer-warn mernelhek, rrkwalel nheng Sinai Pwerteng iterel. Arnang nyent ampetjamel-arleng angel rang mernelhek. ");
INSERT INTO amx_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses-el rwang amperleh aremel anwerlkek. Rang itwek-irrek arnang nhenh aretjeh. Rwang amperleh rang arek. Ngkartemeh kwer angkek, ");
INSERT INTO amx_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Yeng kwenh Altjerr nheng arrwekeleny ngkwengenh mapel nakekarl, Abraham-el Isaac-el Jacob-el thwen.’ Moses rang arrewemel ater-irrek, renh aretjeh. ");
INSERT INTO amx_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Ngkartelemeh renh ilek, ‘Pwet ngkwengenh rlwang. Keth yanh ntwarl irnem yanh-artek mek-mek anem, ahelh mwerr anthwerr. ");
INSERT INTO amx_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mer Egypt lyet anem rwekenth-kenth anthwerr, tjerrtj tjengenh map inenh kweteth atwerl-anem. Thang inenh awek arlkerleh-arlk irlkert angerr-akert. Yengemeh kerneng anarnpek, inenh mer yanheng inetjeh. Lakenh thang ngwenh mer Egypt-warn angkep lanthem.’ Lakenh Altjerrel Moses renh ilek.” ");
INSERT INTO amx_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Stephen-el kwet iletjam, “Artwang nhenh Moses rang kwenh ineh twernk irretjeh anek. Arrwekeleny inang ahentj-kweny anek, rang twernk kwel anetjeh ineh. Artwang ratherr lakenh angkek Moses-ek, ‘Ntwang itja ilernenh twernetjeh!’ Altjerr rant Moses-warn angkek angel kwerenhel-arleng. Angel rang nheng Moses-warn mernelhek arnang ampetjamarl-rlwer. Moses renh Altjerrel lanthek, tjerrtj kwerenh map inenh inetjeh Egypt-areny mapeng, ineh twernk anetjeh. ");
INSERT INTO amx_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Moses-el twer angerrel mpwaretjam, tjerrtj arlaltj kwerenh map inenh tjey-angetjam 40 years-ek-atwetj. Kel arrantherr iterl-arem, rang Israel-kenh map mer Egypt-eng tjey-angek. Inang alhek kwatj alay Athethek-warn. Rang twer angerr mpwarek, inang kwatj kwerel alhetjenheng, ingkerrek iteth anyenemel. Rang twer angerr mpwaretjart mer rrkwalel, inarl nthwetjart 40 years-eh-atwetj. ");
INSERT INTO amx_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Moses nhenh rang Israel-kenh peltj map arrwekel iletjam, ‘Kelant Altjerrel artwang angketj angenh-angenh arrpenh arrehantherr-warn lanthetjenh. Rang yeng-arteh anthwerr anetjenh. Rang artwang Israel-kenh anetjenh.’ ");
INSERT INTO amx_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moses rang tjerrtj map arrawelh-ilek rrkwalel, pwert-warn antjetjeh-anngerntel. Moses kwer-warn angel nheng angkek Sinai pwert kernel. Kwereng Moses-el anarnpemel angketj renh tjerrtj ineh iletj-alpek, inang kangkwerremel iteth anetjenheng. ");
INSERT INTO amx_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Arrwekeleny nwern-henh map inang itja Moses-eh kangkwerrek, kwer ahentj-kweny anek. Inang ahentj-anek, Egypt-warn angkep alpetjeh kwel. ");
INSERT INTO amx_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Inang Moses-henh kek Aaron renh pawenhek, ‘Tjey ngkwengenh Moses nthakenh irrekay? Kwetant kwenh rang ywerrek! Wenhek-ahepel rang nwernenh Egypt-eng mer nhenh-warn tjey-angetjek? Rang nwernenh imperl-alhetjeh-anngernt key? Altjerr arrpenh nwerneh mpwaray! Rang nwernenh tjey-angetjeh!’ ");
INSERT INTO amx_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Inang altjerr-arrpantey mpwarek, pwelek kwek-arteh. Kwereng inang arraw-irrek, altjerr-arrpantey nhenh kangkemel naketjenheng. Inang kwer ker tjenkerr-arlk anthek. Arrken angerr inang rrkwek rntwemel. Altjerr-arrpantey nhenh inarl iltjel mpwarekarl! ");
INSERT INTO amx_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","“Kwereng Altjerremeh ineheng ntjwem-irrek. Rang inenh impek. Inang kwerraly-arlkemeh kelkertel-ayeng arrernelhemel nakek. Lakenh Altjerr-henh angketj angenh-angenh nheng Amos-el ngkwey ilekarl, ‘Tjerrtj Israel-kenh peltj mapay, awerrerrang! Nheng arrantherrarl mer rrkwalel alhetjam-rlwer 40 years-ek-atwetj, arrantherr ker pwelek apek yep-yep apek kweteth irrernng atwerl-apetjart, arrantherr tjeng key ker tjenkerr anthek? Arrantherr itja tjenkerr tjeng anthekarl! ");
INSERT INTO amx_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Molech-ek Rephan-ek war arrantherr mer kwer atherr-henh angerl-apetjart, altjerr-arrpantey-henh, kel itjarl tjengan. Arrantherr altjerr-arrpantey renh-atherrenh iltjel mpwarekarl-penh angerl-apetjam, arrantherr nhenh kwer-atherr kelkertel-ayeng arrernelhemel nakek. Lakenheng thang arrantherrenh ntwarr lanthetjenh, mer Babylon-eng ntwarr-warn.’ ” Stephen-el weth ilek, “Lakenh Amos-el arrwekel ilek. Angketj nhenh keth-warn arratek. ");
INSERT INTO amx_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Ngkwey arrwekeleny nwern-henh mapel tent tjeperr rrkwalel-ayeng angerl-apetjam. Arrwekel Altjerrel Moses ilek, nthakenh rang tent mpwaretjeh, kel Moses-el lakenh tent mpwarek. Altjerr-henh angketj tent kwenel anek irntang atherrel-ayeng. Tent nhenh arrwekeleny nwern-henh mapel rrkwalel-ayeng angenherl-apetjam. ");
INSERT INTO amx_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ler inehenh mapel tent renh angerrerrek, nheng Joshua-el inenh mer-warn tjey-angek, mer nheng Altjerrel ineh arrwekel alhelekarl kwer-warn. Altjerrelemeh mer Canaan-areny map anpwek, kwereng arrwekeleny nwern-henh map mer kwerel anetj-alpek lwerenh-penhan. Tent rang mer yanhel kwet antarl-irrek, King David anetjeh-atwetj. ");
INSERT INTO amx_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Altjerr David-eh kangkek. David-elemeh Altjerr renh pawenhek, rang warl angerretj artetjeh kwer, Altjerr rang anetjenheng kwerel-ayeng. ");
INSERT INTO amx_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Altjerrel David arnpakek. Kelant ler kwerenhel Solomon-el wart warl angerretj artek Altjerrek, David rang ilwekarl-penh. ");
INSERT INTO amx_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Altjerr itjarl mek-mek kwerel anem, warl tjerrtjel artek-penh. Itja kwenh! Altjerr ngkwey ilelhek angketj angenh-angenh kwerenhel-arleng, ");
INSERT INTO amx_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Alkerel chair angerretj tjengenh anem, thang ingkang tjengenh ahelhek arrernem. Warl wenh-arteham arrantherr tjeng artemer, yeng apek anetjeh-anngernt? ");
INSERT INTO amx_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Thang kwenh alker-arlk ahelh-arlk tjerrtj-arlk ingkerrek mpwarekarl.’ “Lakenh Ngkart rang ilelhek.” ");
INSERT INTO amx_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stephen-el inenh ilek, “Arrantherr-artek ahert map anem! Itja arratj kangkwerretj-kwenh. Arrantherr kwenh arrwekeleny arrehantherr-henh map-arteh anem! Arrwekeleny arrehantherr-henhel kwenh Kwerrern Alngaltarek irrpelth-irrek! ");
INSERT INTO amx_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Arrwekeleny arrehantherr-henh kwenh Altjerr-henh angketj angenh-angenh mapeh ahentj-kweny mernelhek. Inang arrpenh inenh irrernng atwek, inarl tjerrtj map arrwekel kwet ilekarl, ‘Artwang arratj anthwerr rang petjetjenharl.’ Artwang nhenh kel petjek. Arrantherremeh artwang arratj renh atwenh-atwenh mapeh anthekarl, renh irrernng atwetjeh. Arrantherr kel renh irrernng atwek! ");
INSERT INTO amx_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Arrantherr Altjerr-henh angketj rrkwemarleng-artany, angketj nheng angel alker-areny mapel Moses kwer ilekarl-penh. Arrantherremeh angketj ineh itjarl kangkwerrek.” Lakenh Stephen-el inenh ilek. ");
INSERT INTO amx_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Council-areny inang awekarl-penh arrengker awelhek. ");
INSERT INTO amx_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Stephen renh Kwerrern Alngaltarel twer-ilek. Rang kern-antep alker arek, rang Altjerr renh arek, Jesu kwerel-ayel irnemeng. Ratherr amparrkek anthwerr. ");
INSERT INTO amx_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Stephen-el inenh ilek, “Thang alker renh altjwer arem, Tjerrtj-henh Ler rang Altjerrel-ayel irnemeng!” ");
INSERT INTO amx_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Inang nhenh awemel arlkek, irlpang arltwelhemel. Kwereng inang Stephen-warn arrtjanemel renh antwerrkek. ");
INSERT INTO amx_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Inang Stephen renh Jerusalem-eng keth-warn tjarr-angek. Kwereng inang renh irntel iltewek. Artwang inang mantarr alkey kern-penh rlwemel artwang nyenteh anthek, rang mantarr anyenetjeh. Artwang kwerenh arreny anek Saul. ");
INSERT INTO amx_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Inang Stephen renh irntel iltewetjam-rlwer, Stephen rang angkek, “Ngkart Jesu-ay, yeng ilwemeng, ntwang kwerrern tjengenh inang!” ");
INSERT INTO amx_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Rang kelkertel-ayeng arrernelhek. Rang arlkemel ilek, “Ngkartay, ntwang inenh itja angkep atwetjeh!” Lakenh ilekarl-penh rang ilwekemeh. ");
INSERT INTO amx_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Saul-el kangkemel arek, inang Stephen renh irrernng atwerleh. Nakenh-nakenh rrpwetjel Stephen renh mpwerrk inemel angerrerrek, renh awenng-warn arrernetjek. Inang ltarrp angerr awelhemel inang kwer arnek. Arltang kwerel priest twernk map inang Jesu nakenh-nakenh mapek ahentj-kweny-irrek. Inang inenh atwetjehemeh alwernek. Lakenheng nakenh-nakenh map Jerusalem-eng ater alherrerrek, mer Judea-angkwerr-warn mer Samaria-angkwerr-warn thwen inang alherrerrek. Kaltj-anthenh-anthenh tjeperr mapant kweteth Jerusalem-el antarl anetjam. ");
INSERT INTO amx_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Artwang nheng Saul rang ahentj-anek, Jesu nakenh-nakenh inenh ywerrelh-iletjeh. Saul rang kwenh nakenh-nakenh mapeh palenthwek warl ingkerrekeh. Rang nakenh-nakenh aretj-alhemarleng, rang inenh tjarr-inemel kwernek tjayel-warn, artwang map marl map thwen. ");
INSERT INTO amx_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Nakenh-nakenh irrarnp-irrekarl map inang mer-areny map kaltj-antherl-apetjam angketj mwerr Jesu Christ kwer-akert. ");
INSERT INTO amx_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Artwang nakenh-nakenh nheng arreny kwerenh Philip mer Samaria-warn alhek, town nyent-warn. Rang tjerrtj map kaltj-antherl-apetjam angketj Jesu Christ-akert, nheng Altjerrel ngkwey alhelekarl-akert. ");
INSERT INTO amx_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","7","Tjerrtj town-areny inang Philip awek. Inang arek, rang twer anthwerrel mpwarerleh. Philip rang tjerrtj kwerrern anetj-akert map mwerr-ilek, kwerrern anetj tjerrtj mapeng anpwemel. Kwerrern anetj inang arratemel arlkek. Rang tjerrtj arlamarr map mwerr-ilek-arlk. Lakenheng tjerrtj town-areny inang renh mantjel awek. ");
INSERT INTO amx_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Inang arrken anthwerr awelhek. ");
INSERT INTO amx_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Town kwerel artwang arrpenh anek, arreny kwerenh Simon. Rang arrwengkelth mpwaretjart. Tjerrtj Samaria-areny map inang nhenh aremel anwerlkek. Simon rang nakelhetjart anthwerr. ");
INSERT INTO amx_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Tjerrtj ingkerrekel kwer-warn arraw-irremel renh nakek, twernk mapel tjerrtj anetj-anetj mapel-arlk. Inang renh arnterr naketjart, “Rang nwerneh altjerr-artek anem!” ");
INSERT INTO amx_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Inang Simon kwer ingkern-angkwerr alhetjart, rang ineheng anngetherr mpwarerl-apetjam. Inang anwerlkemel aretjart, rang arrwengkelthel-arteh mpwarerleh. ");
INSERT INTO amx_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Kwereng Philip rang town-areny map angketj mwerr inenh kaltj-antherl-apetjart, Altjerr rang tjerrtj kwerenh map-warn petjekarl, rang ineh Ngkart angerr anemeng, arreny Jesu Christ-kenh-arlk. Tjerrtj inang angketj kwerenh nakemel Philip-warn petjewarretjart, artwang marl thwen. Rang inenh kwatj-warn irrpelh-ilemel baptise-em-iletjart. ");
INSERT INTO amx_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon rang Jesu Christ renh nakek. Rang petjek, Philip-el renh kwatj-warn irrpelh-ilemel baptise-em-iletjeh. Kwereng rang Philip-el-ayeng pwertemeh ratherr nthwerl-apetjart. Rang angerr anthwerr anwerlkek, rang Philip renh arek, rang twer anthwerrel mpwarerleh. ");
INSERT INTO amx_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Kaltj-anthenh-anthenh tjeperr inang awek Jerusalem-el, tjerrtj Samaria-areny mapel Altjerr-henh angketj nakerleh. Lakenheng inang Peter John renh-atherrenh ineh-warn lanthek, Samaria-warn. ");
INSERT INTO amx_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Ratherr Samaria-el irrpentj-alhemel alhengk-aretj-alhek, Kwerrern Alngaltar rartek itja nakenh-nakenh Samaria-areny ineh-warn irrpek, mpank-antey. Nakenh-nakenh inenh kwatj-akertel war baptise-em-ilek Ngkart Jesu-henh arreny-akertel war. Lakenheng ratherr Altjerr renh pawenhek, rang Kwerrern Alngaltar renh Samaria-areny ineh-warn lanthetjeh. ");
INSERT INTO amx_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Peter ratherr iltjang kwer-atherr-henh kapert inehenh-warn arrernek, kwereng Kwerrern Alngaltar rang ineh-warn irrpek. ");
INSERT INTO amx_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simon-el arek, kaltj-anthenh-anthenh ratherr iltjang kwer-atherr-henh arrpenh map-henh kapert-warn arrernerleh, Kwerrern rang ineh-warn irrperleh. Rang ahentj-anek, Peter John kwer-atherr maney anthetjeh. ");
INSERT INTO amx_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Lakenh rang renh-atherrenh pawenhek, “Mpwel yengenh twer-ilang, thang lakenh mpwaretjenheng mpwel mpwarem-arteh, thang iltjang kapert inehenh-warn arrernemarleng, Kwerrern rang ineh-warn irrpetjeh-anngernt.” ");
INSERT INTO amx_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Peter-elemeh renh arnpakemel ilek, “Ntwang kwenh pal-palel ilernenh pawenhek! Itja kwenh, ntwang ywarn maneyel payem-ilem Altjerr-henh angketj twer nhenh! Itjeng alhay! Altjerrel ngwenh irrernng atwehetjeng, itja mentj impay! ");
INSERT INTO amx_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ntwang kwenh Altjerr kwer pal kwet iterrem! Lakenheng ntwang ywarn ilernehel-ayeng rrkwapem! ");
INSERT INTO amx_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Nthakenharlam ntwang pal iterrekarl, Altjerr-henh twer maneyel kwel payem-iletjehan? Ngkart renh pawenhang, rang iterrentj anetj ngkwengenh arratj-iletjeh, rang apek anetj ngkwengenh wetjeh, rang ngwerleny anetjenheng ngkweng. ");
INSERT INTO amx_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Thang ngwenh arem, ntwang ahentj-anem, ilern-arteh anetjeh, twerel mpwarerl-apetjeh, tjerrtj mwerr-ilemel. Itja ntwang lakenh iterretjeh! Ntwang kwenh iterrentj pal-pal-akertel war pawenhek!” ");
INSERT INTO amx_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simon-elemeh Peter John thwen pawenhek, “Tjeng Ngkart renh tjang-pawenherl-anerray, rang yengenh itja atwetjeh!” ");
INSERT INTO amx_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Peter ratherr mer-areny map Ngkart-henh angketj kaltj-anthek. Kwereng Jerusalem-warn ratherr angkep alperrek. Tjeyel alhep-alhemel mpank-antey, ratherr angkerl-apetjam town kwek mapel Samaria-angkwerr, ratherr tjerrtj mapeh angketj mwerr renh kaltj-antherl-apetjam. ");
INSERT INTO amx_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Arltang arrpenhel Altjerr-henh angel alker-arenyelemeh Philip renh ilek, “Ntwang antekerr alhang tjey-warn, tjey rarl antekerr intenhemarl-warn town Jerusalem-eng town Gaza-warn-atheh, rrkwal-angkwerr.” ");
INSERT INTO amx_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Philip rang kangkwerremel alhek tjey kwerel. Tjey kwerel alhep-alhemel rang artwang nyent arek, pakey kwerenhel-arleng anerl-aperleh. Artwang nhenh mer Ethiopia-areny anek. Rang marl arreny Queen Candace-henh rrkwapenh-apenh anek. Rang queen kwerenh maney ingkerrek arntarnt-aretjart. Rang Jerusalem-eng mer Ethiopia-warn-atheh alpetjam. Rang arrwekelek-amparr Jerusalem-el church angerretj-warn irrpekarl, kelkertel-ayeng arrernelhemel Altjerr renh nakek. ");
INSERT INTO amx_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Artwang rantem mer-warn-atheh alpetjam, pakeyel ingkern anerl-apemel, rang pip read-em-ilerl-apetjam, nheng Altjerr-henh angketj angenh-angenh Isaiah-el arrernekarl-penh. ");
INSERT INTO amx_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Altjerr-kenh Kwerrernelemeh Philip renh ilek, “Parrp alhay, angath-irremel pakey kwerel alherl-apetjeh iterel.” ");
INSERT INTO amx_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Philip rang pakey kwer-warn arrtjanek. Rang artwang renh awek, rarl Altjerr-henh angketj angenh-angenh Isaiah-henh pip read-em-ilerl-aperleh. Philip rang renh pawenhek, “Ntwang angketj nhenh alhengk-arem key?” ");
INSERT INTO amx_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Artwang Ethiopia-areny rang renh ilek, “Nthakenhameh thang angketj nhenh alhengk-aretjenh? Tjerrtj arrpenhel itja tjeng angketj nhenh keth-ilemel ilek.” Rang Philip renh ngwek, “Antjentj-alhang pakey-warn.” ");
INSERT INTO amx_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Artwang rang angketj nhenh kweteth read-em-ilerl-apetjam, “Tjerrtjel yep-yep rope-akertel tjarr-angem atwetjeh-anngernt, nheng lakenh-arteh inang artwang nyent renh tjarr-angetjenh, yep-yep-arteh atwetjenh-anngernt, lakenh. Rang ntert irnetjenh arlketj-kweny yep-yep kwek-arteh, inang yep-yep kwek renh altang wool akemarl-arteh, yep-yep rang ntert irnem. ");
INSERT INTO amx_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Inang kwer ahang-irremel tjerrtj mapeng ularr pawenhetjenh, nyent apek itja kwer arrngert angketjenh. Inang renh irrernng atwetjehant impetjenh.” ");
INSERT INTO amx_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Artwang rang Philip renh pawenhek, “Yeng ilay, ngwenham inang atwem? Angketj angenh-angenh Isaiah key? Tjerrtj arrpenh apek?” ");
INSERT INTO amx_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Philip-el ilek, “Isaiah-el ilem, inang artwang nyent atwetjeh. Thang ngkweng keth-ilemelemeh ilem, artwang nhenh arreny anem Jesu. Jesu ntert kwet irnek, inarl renh irrernng atwetjeh anekarl-rlwer, yep-yep nheng-arteh.” Kwereng Philip-el artwang kwer angketj mwerr Jesu-akert kaltj-anthemel ilek. ");
INSERT INTO amx_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Inang pakeyel alherl-apetjam-rlwer, inang kwatj angentj arek. Artwang rang Philip renh pawenhek, “Aray, kwatj angerr intem. Ntwang key yengenh kwatj-warn irrpelh-ilemel baptise-em-iletjeh?” ");
INSERT INTO amx_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Artwang rang pakey angenh-angenh kwerenh ilek, “Pakey renh ngkernetjeh!” Kwereng Philip ratherr kwatj kwer-warn anarnpemel alherrek. Philip-elemeh renh kwatj-warn irrpelh-ilemel baptise-em-ilek. ");
INSERT INTO amx_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ratherr kwatj kwereng arratemel alherrek, Ngkart-henh Kwerrernel Philip renh arrkay-ilemel angek. Artwang Ethiopia-arenyel renh itja weth arek. Kwereng artwang rang mer kwerenh-warn arrken awelhemel alpek. ");
INSERT INTO amx_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Tjerrtj mapel Philip renh mer arrpenh Azotus-elemeh arek. Philip rang kwereng ayerrer-atheh alhek, town kwek map-angkwerr anper kwet alhek, town angerr Caesarea-eh-atwetj. Rang tjerrtj mapeh angketj mwerr Jesu-akert kaltj-antherl-apetjam. ");
INSERT INTO amx_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","2","Saul rang athek-irrek, Ngkart Jesu nakenh-nakenh map irrernng atwerl-apetjeh ywerrelh-ilemel. Rang ahentj-irrek anthwerr town Damascus-warn alhetjeh, nakenh-nakenh map antwerrkemel angetj-alpetjenheng Jerusalem-warn, tjayel-warn kwernetjenheng. Lakenh rang priest twernk angerr-warn alhek, renh pawenhek, “Ntwang tjeng pip tanthemel anthang, thang renh Damascus-warn angetjeh, church-ek-artwey map anthetjenheng. Inang kangkwerremeng apek, thang nakenh-nakenh map artwang marl thwen antwerrkemel nhenh-warn angkep angetj-alpetjeh.” Kel priest twernk angerr rang kangkwerremel pip Saul kwer tanthemel anthek. ");
INSERT INTO amx_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Saul rang pip inemel tjeyek-irrek town Damascus-warn-athek, rlkwatherr rrpwetj-akert. Inang kel Damascus kwer-warn angathemeh-irrek. Parrtj angerrelemeh alharrkemel renh palekalek-ilek. ");
INSERT INTO amx_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Saul-emeh ahelh-warn anyerl-alhek. Rang angketj awek alkereng, kwer-warn angkerleh, “Saul-ay, Saul-ay! Wenhengam ntwang yengenh atwetjeh alwernem?” ");
INSERT INTO amx_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saul rang renh pawenhek, “Ngwenham ntwang, Ngkart key?” Rang kwer tjernemel ilelhek, “Yeng kwenh Jesu, ntwarl atwetjeh alwernem renh. ");
INSERT INTO amx_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Kel kemerray, town nhak-warn alhang. Artwang nyentel ngwenh iletjenh, nthakenh ntwang irretjeh.” ");
INSERT INTO amx_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Artwang inarl Saul-el-ayeng rlkwatherr alhekarl, inang ntertarl irnetjam. Inang kel awek, arrpenh angkerleh, inang tjerrtj itja arek. ");
INSERT INTO amx_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Saul-emeh kemerrek, rang anngang kwerenh alngampelh-ilek, aretjeh kwel. Rang itja kwet arek, rang pweng-irrekarleng. Kwereng artwang arrpenh inang renh Damascus-warn iltjeng tjey-angerrerrek. ");
INSERT INTO amx_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Arltang rrpwetj-ingar rang pweng kwet anek. Rang itja mern apek arlkwek, itja kwatj-arlk apek antjwek. ");
INSERT INTO amx_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Town Damascus kwerel Jesu nakenh-nakenh nyent anek, arreny kwerenh Ananias. Ananias rang Ngkart renh arrkay-arrkayel war arek. Ngkart kwer angkek, “Ananias-ay!” Rang renh tjernek, “Wenhekay Ngkart?” ");
INSERT INTO amx_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ngkartelemeh renh ilek, “Tjey nheng-warn alhang, arreny kwerenh ‘Tjey arratj’. Ntwang alhang Judas-henh mer-warn, ntwang artwang nyent Tarsus-areny Saul-eh ntwang pawenhang. Saul rartek lyet-antey Altjerr-warn angkem. ");
INSERT INTO amx_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Saul rartek anengkerr arek. Rang ngwenh arek, kwer-warn ularr petjerleh, ntwang iltjang ngkwengenh kapert kwerenh-warn arrernerleh, anngang kwerenhemeh mwerr-iletjeh-anngernt.” ");
INSERT INTO amx_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananias-elemeh Ngkart renh tjernemel ilek, “Ngkartay, thang angketj anetj artwang nhenh-penh awek. Rang nakenh-nakenh ngkwengenh map Jerusalem-el alwernemel atwek. ");
INSERT INTO amx_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Rang nhenh-warn petjek, priest twernk map-henh pip-akert. Angketj pip rarl anyenemel-ayeng intem, ‘Tjerrtj ngwenhel apek Jesu nakem, Saul rang inenh antwerrkemel angkep anginetjeh Jerusalem kwer-warn.’ Rang lakenheh petjek.” ");
INSERT INTO amx_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ngkartelemeh Ananias renh ilek, “Kel alhay! Thang artwang renh kel urraremel inek. Thang renh lanthetjenh tjerrtj lwereny map-warn, king inehenh map-warn, tjerrtj Israel-areny map-warn thwen. Rang inenh angketj tjeyenh kaltj-anthetjek. ");
INSERT INTO amx_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Kelant tjerrtj mapel kwer irrpelth-irremel renh atwetjenh. Thang arrwekel kwet renh ateng-iletjenh, lakenh kwer-ketj.” Lakenh Ngkartel Ananias renh ilek. ");
INSERT INTO amx_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Kwereng Ananias rang alhek Judas-henh warl-warn. Rang irrpenhemel-artek iltjang kwerenh Saul-henh kaperteh arrernek. Rang renh ilek, “Saul-ay, peltj tjengenhay! Ngkart Jesu nheng ngkweng tjeyel arratekarl, rang yengenh ngkweng-warn lanthek. Rang tjengel-arleng anngang ngkwengenh mwerr-iletjenheng, Kwerrern Alngaltar rang ngkweng-warn irrpetjeh-anngernt.” ");
INSERT INTO amx_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Kwereng Saul-henh anngangeng apereltj-arteh kap-rlwelhemel ahelh-warn anyek rarrp kwet. Rang mwerremeh arek. Rang kemerrek. Kwereng Ananias-el renh kwatj-warn irrpelh-ilemel baptise-em-ilek. ");
INSERT INTO amx_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Kwereng Saul rang mernemeh arlkwek, tweremeh irrek. Saul-emeh arltang rrpwetjeh nakenh-nakenh mapel-ayeng-amparr anetjam, town Damascus kwerel. ");
INSERT INTO amx_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Kwereng rang Jew map-kenh church map irrperl-apetjam, kaltj-antherl-apetjeh tjerrtj map, ilemel Jesu kwenh Altjerr-henh Ler anemeng. ");
INSERT INTO amx_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Tjerrtj inang awekarl-penh anwerlkemel angkerrek, “Artwang nhenhel rang Jesu nakenh-nakenh map alwernemel atwetjart Jerusalem-el! Rang nhenh-warn petjek, nakenh-nakenh map antwerrketjeh. Rang inenh priest twernk map-warn anginetjeh anekarl. Nthakenhameh rang lyet tjerrtj map angketj Jesu-akert kaltj-anthem, rarl arrwekel nakenh-nakenh inenh atwerl-apetjam-penh?” Lakenh inang ywarn iterl-aremel ilerrek. ");
INSERT INTO amx_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Kwerrern Alngaltarelemeh Saul-henh angketj tweram-twer-ilek. Tjerrtj Jew Damascus-areny mapemeh ywarn-antey kwer irrpelth-irrek, rarl inenh iletjamarl, Jesu rang Christ anemeng, nheng Altjerrel inenh ngkwey alhelekarl-penh. Lakenh inang ywarn iterl-aremel ntert anek. ");
INSERT INTO amx_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Kel arrpenhelemeh inang angkerrek, Saul renh irrernng atwetjeh. ");
INSERT INTO amx_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Saul-el awek angketj kwer-akert, arrpenh map angkerrerl-anemeng, inang town arrew inenh kwenyel aherrkel thwen mpwelhemel karelhetjam, renh antwerrkemel atwetjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Kweny arrpenhelemeh Saul-henh peltj mapel basket angerr-warn renh arrernewarrek, kwereng inang basket renh rope-el ayernemel anarnpelh-ilek Saul kwer-akert wall kerneng, wall nheng mer town kwerel arrngert anekarl. Kwereng arrengakw-ampeny, rang keth kwereng ater alhetjeh. Jew map-hetj rang arratemel alhek, anyenng-anyenng alwerremel Jerusalem-warn-athek. ");
INSERT INTO amx_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saul rang Jerusalem-warn angkep alpek. Rang ahentj-anek, nakenh-nakenh map-warn nyent-irretjeh. Nakenh-nakenh map-anem Saul kwereng ater-irrek. Inang kaltj kwer anek, rang ahangerr atwenh-atwenh anekarl wart. ");
INSERT INTO amx_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Barnabas-elemeh Saul renh kaltj-anthenh-anthenh tjeperr map-warn angek. Rang inenh ilek, “Saul rang Ngkart arekarl, rarl Damascus-warn alhekarlel. Ngkart rang Saul renh ilek. Kwereng Saul rang tjerrtj map anew-anewel kaltj-anthek Damascus kwerel.” ");
INSERT INTO amx_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Kaltj-anthenh-anthenh tjeperr mapel Barnabas kangkwerremel awek. Inang nakenh-nakenh arrpenh map ilek, “Saul rang nwern-artehemeh anem!” Lakenheng Saul rang nakenh-nakenh mapel-ayeng kwenpemeh anek, rang Jerusalem kwerel kwenpemeh nthwerl-apetjam. Tjerrtj map rang anew-anewelemeh angketj Ngkart Jesu-akert kaltj-antherl-apetjam. ");
INSERT INTO amx_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Saul rang tjerrtj Greek angkenh-angkenh mapel-ayeng angketj Jesu-akert ilerl-apetjam. Inang ahentj-anek, renh irrernng atwetjeh. ");
INSERT INTO amx_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Peltj nakenh-nakenh mapel angketj kwereng awekarl, inang renh Caesarea town-warnemeh angerrerrek. Kwereng inang Saul renh town Tarsus-warnemeh lanthek, rang kwerelemeh kwet anetj-alpek. ");
INSERT INTO amx_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Kwereng tjerrtj ingkerrek nakenh-nakenh map ineh ngwerlenyemeh mernelhek, nakenh-nakenh inarl mer Judea ntjaperel mer Galilee ntjaperel, mer Samaria ntjaperel thwen anek. Kwerrern Alngaltarel nakenh-nakenh inenh twer-ilek, inang anew-anew anetjeh ater-kwenh. Mer arrpenhek-arrpenhel nakenh-nakenh aningk arraw-irretjam, Altjerr-warn angketjeh-anngernt. Nakenh-nakenh inang arratj kwet mernelhek Ngkarteng ularr. ");
INSERT INTO amx_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Kel arltang arrpenhel Peter rang mer kwek map-warn alhetjam, tjerrtj nakenh-nakenh mapel-ayeng yatjarr anerl-alpetjeh. Rang mer kwek arreny Lydda-warn alhek, tjerrtj nakenh-nakenh map-warn inehel-arleng yatjarr anerl-alpetjeh. ");
INSERT INTO amx_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Mer kwerel artwang arlamarr nyent anek, arreny kwerenh Aeneas. Rang 8 years-ek-atwetj antjam kwerenhel intetjart. ");
INSERT INTO amx_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Peter-el renh aremel ilek, “Aeneas-ay, Jesu Christ-el ngwenh mwerr-ilek! Kelemeh kemerrang! Antjam ngkwengenh artaper-ilang!” Aeneas kel kemerremel irnek. ");
INSERT INTO amx_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Tjerrtj Lydda mer-areny mapel mer Sharon-areny mapel thwen artwang arlamarr mwerr-irrekarl arek, inang Ngkart-warn twep-irrek, nakenh-nakenhemeh irrek. ");
INSERT INTO amx_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Joppa town-el nakenh-nakenh marl nyent anek, arreny kwerenh Tabitha. Angketj Greek-el arreny kwerenh angart-wekarl Dorcas. Marl nhenh rartek tjerrtj ingkerrekeh tangetjel anetjart. Rang tjerrtj anetj-anetj maney-kwenh map mernel rnwanentjel-arlk thwen arntarnt-aretjart. ");
INSERT INTO amx_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Arltang arrpenhel Tabitha rang irlkert-irrek, kwereng rang ilwekemeh. Peltj kwerenhelemeh mpwerrk kwerenh lhewek, rang renh room kern-warn angemel athenek. ");
INSERT INTO amx_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Mer Lydda rartek town Joppa-eng angath war anek. Nakenh-nakenh mapel awek, Peter rang mer Lydda-el anerleh, angath war. Inang artwang urrpey atherr kwer-warn lanthek, renh ngwerl-alpetjek. Ratherr ilek, “Peter, parrp petjay!” ");
INSERT INTO amx_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Peter rang kel pwertemeh kwer-atherrel-ayeng alhek. Inang Tabitha-kenh warl-warn irrpetj-alhek. Ratherr Peter room kwer-warn angek, kwerel marl rang irrernng intetjam-warn. Peter rantem room irrpemel arek, inpert map akay arnerl-anerleh. Inpert inang Peter rnwanentj mernek, Tabitha rarl itethel-amparr tanthekarl. ");
INSERT INTO amx_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Peter-elemeh tjerrtj ingkerrek room-eng keth-warn lanthek. Kwereng rang kelkertel-ayeng arrernelhemel Altjerr renh pawenhek. Rang marl irrernng renh ilek, “Tabithay, kel kemerray!” Tabitha rang alngampemel Peter renh arek, kemerremel anetjeh-anngerntarl. ");
INSERT INTO amx_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Peter-elemeh renh iltjeng antwerrkemel kemelh-ilek. Kwereng Peter rang inpert mapeh ntangkelhek, nakenh-nakenh mapeh thwen, “Aretjeh petjewarrang!” Inang anwerlkemel arek, Tabitha itethemeh irnerleh. ");
INSERT INTO amx_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Tjerrtj Joppa-areny ingkerrekel angketj nhenh-penh awek, mapelemeh Ngkart renh nakek. ");
INSERT INTO amx_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Peter rang mer Joppa-elemeh kwet-irrek, yatjarr anetj-alpek artwang arreny Simon-el-ayel. Simon rang kwenh pwelek-henh yenpeng leather mpwarenh-arenh anek. ");
INSERT INTO amx_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Town Caesarea-el artwang alethang Rome-areny anek, arreny kwerenh Cornelius. Rang artwang atwenh-atwenh Rome-areny map anyenek. Atwenh-atwenh nhenh map inehenh arreny anek Italy, inarl mer Italy-eng petjekarl. ");
INSERT INTO amx_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Cornelius-el peltj kwerenh mapel thwen inang Altjerr-henh angketjekant athek-irremel awetjart, Altjerrant naketjart. Rang tjerrtj anetj-anetj maney-kweny map mantj arntarnt-aretjart. Altjerr kwer-warn rang kweteth angketjart. ");
INSERT INTO amx_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Arltang arrpenhelemeh angwerrel Cornelius rang anengkerr arek. Rang keth anthwerr Altjerr-kenh angel alker-areny arek. Angel rang itwek-irremel renh ilek, “Cornelius-ay!” ");
INSERT INTO amx_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Cornelius-el ater-irremel renh arek. Kwereng rang angel renh pawenhek, “Wenh kweray Ngkartay?” Angelel renh ilek, “Altjerrel ngwenh arek, ntwang tjerrtj anetj-anetj maney-kweny mapeh kangkemel maney antherleh. Rang ngwenh awek, ntwang kwer-warn angkerleh. Altjerr rang ngkweng kangkentj awelhem. ");
INSERT INTO amx_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ntwangemeh artwang urrpey rrpwetj lanthetjeh mer Joppa-warn. Inang artwang arreny Simon Peter renh ngwerl-alpetjeh. ");
INSERT INTO amx_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Rang lyet artwang Simon arrpenh rang kwerel-ayeng anem. Simon nhenh rang yenpeng leather mpwarenh-arenh anem. Kwerenh warl kwatj alay iterel artelhek.” ");
INSERT INTO amx_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Kwereng angel rang alpekemeh. Cornelius rang rrkwapenh-apenh atherreh ntangkelhek, atwenh-atwenh nyenteh thwen. Atwenh-atwenh nhenh rang Cornelius-henh rnwanentj-arlk arntarnt-aretjart. Rang artwang Altjerreh kaltj anek. ");
INSERT INTO amx_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Cornelius-elemeh artwang inenh angel-henh angketj ilek. Kwereng rang inenh town Joppa-warn lanthek, Peter renh ngwerl-alpetjeh. ");
INSERT INTO amx_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Arrpenh-ingar aherrk irntarel Cornelius-kenh urrpey inang kel town Joppa-ek angathemeh irrentjek. Inang mpank-antey petjetjam, Peter warl kern-warn antjek, Altjerr-warn angketjeh. ");
INSERT INTO amx_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Rang Altjerr-warn angketjam, rang angayel awelhek. Rang ahentj-anek, mern arlkwetjeh. Mernek karelhemeng, Peter rang karntemel anetj-alpek, kwereng rang anengkerr arek. ");
INSERT INTO amx_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Rang alker altjwer-irrerleh arek, kwereng alker kwerel-anem rang arek mantarr-artek anarnpemel petjerleh kwer-warn. ");
INSERT INTO amx_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Mantarr kwerel ker arrpenhek-arrpenh inang anek, ahelhel nthwerl-apenh-apenh map, arnerrenh-rrenh map, thep alker-areny map-arlk. (Ker nhenh map Moses-el Israel-kenh map arnpakek, inang arlkwetjal impetjeh.) ");
INSERT INTO amx_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Rang awek, Ngkartelemeh renh kemelh-ilerleh, “Peter, kemerray, ker nyent atwemel arlkway!” ");
INSERT INTO amx_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Peter rang renh tjweker-irremel ilek, “Ngkartay, itja lakenh! Thang itja ker anetj yanh map arlkwetjeh! Moses-el ngkwey nwernenh arnpakek, itja ker yanh map arlkwetjeh!” ");
INSERT INTO amx_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ngkartel renh weth ilek, “Thang ngwenh ilem, ker yanh map mwerr kwenh arlkwetjeh. Ntwang tjweker-irretjal anetjeh!” ");
INSERT INTO amx_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Lakenh rrpwetj-ingar angketj rang awek. Kwereng Ngkartel mantarr-artek renh alker-warn angkep anginek. ");
INSERT INTO amx_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","18","Peter rang anengkerr-penh ywarn iterrek. Rang ywarn iterremarleng, artwang nheng map inenharl Cornelius-el lanthekarl, inang Simon-henh warl-warn irnetj-alhek. Inang gate-eng-anem arlkemel pawenhek, “Artwang arreny Simon Peter warl nhenhel anem key?” ");
INSERT INTO amx_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Peter rang kwet iterretjam, wenh rarl arekarl-penheh. Kwerrern Alngaltarelemeh renh ateng-ilemel ilek, “Simon-ay! Artwang rrpwetj-artek ngkweng palenthwem. ");
INSERT INTO amx_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Kwen anarnpang, tjerrtj inenh aretjeh! Thang kwenh inenh ngkweng-warn lanthek. Inehel-arleng alhang!” ");
INSERT INTO amx_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Peter artwang ineh-warn anarnpetj-alhemel rang ineh ilelhek, “Yeng kwenh Simon Peter rang! Wenheham tjeng arrantherr palenthwem?” ");
INSERT INTO amx_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Artwang inang renh ilek, “Cornelius rang twernk angerr anem atwenh-atwenh mapek. Rang nwernenh lanthek ngkweng-warn, ngwenh ngwerl-alpetjeh. Tjerrtj Jew ingkerrek kaltj, rang artwang Altjerreh kaltj anemarleh. Rang Altjerr arratj iterl-arem. Angwerrek Altjerr-henh angel kwer-warn petjek. Angelel renh ilek, ngkweng ntangkelhetjeh. Rang ngwenh awetjeh kwel.” ");
INSERT INTO amx_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Peter-elemeh inenh ayakemel ilek, “Kwen irrpentjewarrang, intetjeh-amparr.” Kweny-rtwehemeh Peter rang artwang ineh-arleng aletheh-irrek. Artwang nakenh-nakenh map Joppa-areny inehel-arleng alhek. ");
INSERT INTO amx_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Arltang arrpenhelemeh inang Caesarea town-eh irretj-alhek. Kwerel Cornelius rang ineh karelhek, peltj kwerenh map-akert. ");
INSERT INTO amx_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Peter wart Cornelius-henh warlel anetj-alhek. Cornelius-el iterl-arek, Peter rang kwel alker-arenyeh-athen, rang kwereng ularr kelkertel-ayeng arrernelhek. ");
INSERT INTO amx_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Peter-elemeh renh arnpakemel ilek, “Peltj tjengenhay, itja lakenh! Kemerray, yeng-artek tjerrtj ntwarteh anem!” ");
INSERT INTO amx_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Peter rang warl-warn-anem kwen irrpenhek. Rang tjerrtj aningkemeh arek. ");
INSERT INTO amx_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Rang inenh ilek, “Arrantherr kel kaltj, tjerrtj Jew nwern kwenh ywarn tjerrtj alethang mapel-ayel yatjarr anem, yatjarr apek angkerremel, nwern anetj-ilelhehetjeng. Nwern Moses-henh mpwareng-arengeh kangkwerremeng wart. Ngwerreh Altjerrel yengenh ilek, yeng itja alethang ineh mwekeny-irretjeh. ");
INSERT INTO amx_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Lakenheng yeng kel petjek, Cornelius rang tjeng ntangkelhekarleng. Kelemeh yengenh ilang. Wenheh ntwang tjeng ntangkelhek?” ");
INSERT INTO amx_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelius-elemeh renh ilek, “Angwerreh-lkweremeh angwerrel yeng Altjerr-warn angketjam-rlwer, artwang mantarr arlter amparrkey-akert tjengel-ayel irnetj-alhek. ");
INSERT INTO amx_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Rang yengenh ilek, ‘Cornelius-ay! Altjerrel ngwenh awek, ntwang kwer-warn angkerleh. Rang ngwenh arek, ntwang tjerrtj anetj-anetj maney-kweny ineh kangkentj mernelhemel rnwanentj-arlk antherleh. ");
INSERT INTO amx_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ntwangemeh town Joppa-warn urrpey lanthang, Simon Peter ngwerl-alpetjeh. Rang lyet artwang Simon leather yenpeng mpwarenh-arenh kwerel-arleng anem. Simon leather yenpeng mpwarenh-arenh warl kwerenh kwatj alay iterel artelhem.’ Lakenh angelel yeng ilek. ");
INSERT INTO amx_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Thang kwenh urrpey kel lanthek, ngwenh ngwerl-alpetjeh. Nwernemeh kangkem, ntwang kwenp petjekarleng nwerneh-warn. Nwern ngkweng arrwekel arraw-irrekarl, Altjerreng ularr thwen. Nwern ahentj-anem, angketj ngkwengenh awetjeh. Nthakenh Ngkartel ngwenh ilekarl-penh, nwernenh iletjeh?” ");
INSERT INTO amx_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Peter rang angkek, “Thang kel alhengk-arem, Altjerr rang itja tjerrtj Jew nwernehant kangkem. ");
INSERT INTO amx_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Rang tjerrtj ingkerrekeh kangkem, Jew mapeh akwen mapeh thwen, tjerrtj inehant inarl renh arratj nakemeng, arratj mernelhemeng. ");
INSERT INTO amx_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Arrantherr kel kaltj, Altjerrel tjerrtj Jew map-warn nwerneh-warn angketj mwerr lanthek, nheng Altjerr rang ahentj-anek, rang tjerrtj Jew nwernehel-arleng peltj-irretjeh Jesu Christ-el-arleng, rang nwerneh ngwerleny mernelhetjenheng. Jesu Christ nhenh rang tjerrtj mapek Ngkart anem ahelh apanpel. ");
INSERT INTO amx_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Arrantherr kel kaltj, angketj angerr anek mer Judea ntjaperel. John-el-amparr mer Galilee-el rang tjerrtj map kaltj-anthemel kwatj-warn irrpelh-ilemel baptise-em-iletjam. ");
INSERT INTO amx_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Kwereng Altjerrel Kwerrern Alngaltar renh Jesu Nazareth-areny-warn lanthek, renh twer-iletjeh. Jesu rang mer arrpenh mapel mwerr mpwarerl-apek, rang tjerrtj inenharl mwerr-ilemel arrentj map-arlk tjerrtj ineheng anpwetjam. Altjerr rang Jesu kwerel-ayeng anekarleng wart. ");
INSERT INTO amx_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Nwernarrp kwer kaltj, nwern arekarleng, rang twer angerrel mpwarerl-apekarl tjerrtj Jew map-kenh merel town Jerusalem-el thwen. Tjerrtjel-anem renh ntwerlk-warn arrernemel irrernng atwek. ");
INSERT INTO amx_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Altjerrel renh kemelh-ilek kweny atherr-penhel irrernng intentj-penh. Altjerrelemeh renh nwerneh mernek, nwern renh aretjeh, rang iteth anemeng. ");
INSERT INTO amx_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Tjerrtj ingkerrekel itja renh arek, tjerrtj rrpwetjel war arek, nwernant. Altjerrel arrwekel kwet nwernenhant urrarekarl, nwern Jesu ngwerrm aretjeh, nwern ilerl-apetjeh, ‘Jesu kwenh ngwerrm anem!’ Jesu rang irrernngeng kemerrekarl-penh nwernemeh kwerel-ayeng mern-arlk arlkwek, kwatj antjwek thwen. ");
INSERT INTO amx_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Jesu Christ-elemeh nwernenh ilek, nwern tjerrtj ingkerrekeh angketj mwerr renh kaltj-antherl-apetjeh. Nwern inenh ilerl-apetjeh, Altjerrel Jesu renh ngkernek, rant kwenh tjerrtj ingkerrek judge-em-ilemel pawenhetjenh, iteth map irrernng map thwen. Rang tjerrtj mwerrant map kwer-warn ngaketjenh, tjerrtj anetj map rang anpwetjenh. ");
INSERT INTO amx_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Altjerr-henh angketj angenh-angenh arrwekeleny mapel Jesu kwer-penh ilek, ‘Artwang rang ingkern petjetjenh. Tjerrtj ngwenh apek inarl artwang nhenh nakemarleng, Altjerrelemeh anetj inehenh wetjenh arreny kwerenhel-arleng, Altjerr rang ngwerleny anetjenheng ineh.’ ” Lakenh Peter-el Cornelius peltj kwerenh map-arlk ilek. ");
INSERT INTO amx_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Peter rang inenh kaltj-anthetjamarleng, Kwerrern Alngaltar rang ineh-warn irrpek. ");
INSERT INTO amx_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Nakenh-nakenh Jew rrpwetj nheng inarl Peter-el-arleng petjekarl, inartek tjerrtj alethang map inenh awek, inang angketj arrpenhek-arrpenhel angkerleh, angketj lwereny map-kenhel. Inang awek, inang Altjerr-arlk kangkemel nakerleh. Inang anwerlkek, Altjerrel Kwerrern Alngaltar renh tjerrtj alethang map-warn lanthek. Peter rang angkek, ");
INSERT INTO amx_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Kwerrern Alngaltar rartek tjerrtj nhenh map-warn irrpek, rarl nwerneh-warn irrpentj-alhek-arteh. Lakenheng nwern kel inenh kwatj-warn irrpelh-ilemel baptise-em-iletjeh.” ");
INSERT INTO amx_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Peter rang kwerenh map ilek, inang inenh Jesu Christ-henh arrenyel-arleng kwatj-warn irrpelh-ilemel baptise-em-iletjeh. Kel inang inenh kwatj-warn irrpelh-ilemel baptise-em-ilek. Kwereng Cornelius inang Peter renh-arlk kwerenh map thwen inenh arnpakek, inehel-arleng arltang rrpwetj-ingar anetjeh. ");
INSERT INTO amx_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Kaltj-anthenh-anthenh mapel nakenh-nakenh mer Judea ntjaper-areny mapel thwen awek, tjerrtj alethang mapel-arlk Altjerr-henh angketj inang awemel nakerleh. ");
INSERT INTO amx_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Peter-emeh Jerusalem-warn angkep petj-alpek. Kwereng artwang Jew arrpenh map inarl nakenh-nakenh anemeng Peter-el-ayeng ilterrek. ");
INSERT INTO amx_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Inang Peter renh mwekeny-irremel ilek, “Ntwartek tjerrtj lwereny mapel-ayeng warlel anek, inehel-ayeng mern-arlk arlkwek. Lakenh kwenh anetj!” ");
INSERT INTO amx_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Peter-el inenh angketj keth-ilemel ilek, ");
INSERT INTO amx_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Yeng Joppa town-el anek. Arltang arrpenhel yeng Altjerr-warn angketjam-rlwer, thang mantarr angerr-artek arek, alkereng anarnpetj-alherleh tjeng-warn-athek. ");
INSERT INTO amx_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Thang mantarr kwenemeh arek, ker arrpenhek-arrpenh thang interleh arek, ahelhel nthwerl-apenh-apenh map arnerrenh-rrenh map thep alker-areny map thwen. ");
INSERT INTO amx_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Thang awek, Ngkartelemeh yengenh kemelh-ilerleh, ‘Peter kemerray! Ker nyent atwemel arlkway!’ ");
INSERT INTO amx_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Yeng angkek, ‘Ngkartay, itjam lakenh! Thang itja ker anetj yanh map arlkwetjenh! Moses-el ngkwey nwernenh arnpakek, itja ker yanh-arteh map arlkwetjeh!’ ");
INSERT INTO amx_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Ngkartel yengenh weth ilek, ‘Thang ngwenh ilem, ker yanh map mwerr kwenh arlkwetjeh. Ntwang tjweker-irretjal anetjeh!’ ");
INSERT INTO amx_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Lakenh rrpwetj-ingar angketj thang awek. Kwereng Ngkartel mantarr-artek renh alker-warn angkep anginek. ");
INSERT INTO amx_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Kwer-penh artwang rrpwetjemeh gate arrewel irnetj-alhek warleng kwet, mer yengarl anep-anemengel-ayeng. Artwang inenh Caesarea town kwereng lanthekarl, yengenh ngwerl-alpetjeh. ");
INSERT INTO amx_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Kwerrern Alngaltar rang yengenh ateng-ilemel ilek, yeng ineh-arleng kwenp alhetjeh. Artwang nakenh-nakenh 6 Joppa-areny tjengel-arleng rlkwatherr alhek. Nwern Cornelius-henh warl-warn alhek, kwen irrpenhek. ");
INSERT INTO amx_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Artwang Cornelius rang nwernenh ilek, ‘Angel kwenh warl tjengenh-warn petjekarl. Angelel yengenh ilekarl, urrpey Joppa-warn lanthetjeh, artwang arreny Simon Peter ngwerl-alpetjeh. ");
INSERT INTO amx_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Simon Peter rang arrantherrenh angketj tjengenh iletjenh. Ntwang angketj nhenh nakem apek, Altjerrel ngwenh arlaltj ngkwengenh map ingkerrek thwen anetjeng inetjenh, arrantherr iteth ngampekarl anetjenheng!’ ");
INSERT INTO amx_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Yengemeh Cornelius map-warn angketjam-rlwer, Kwerrern Alngaltar rang ineh-warn irrpek, rarl arrwekel nheng nwerneh-warn irrpetjamarl-arteh. ");
INSERT INTO amx_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Yengemeh irlpangkek, Ngkart Jesu-el arrwekel nwernenh ilekarl, ‘John-el kwenh tjerrtj map kwatjel-ayeng baptise-em-ilek. Thangemeh arrantherrenh Kwerrern Alngaltarel-ayeng baptise-em-iletjenh, Kwerrern rang arrehantherrel-ayeng kwen kwet anetjenheng.’ ");
INSERT INTO amx_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Lakenheng thangemeh alhengk-arek, inang Ngkart Jesu renh nakemeng, nwernarl Ngkart Jesu renh nakem-arteh. Altjerrel Kwerrern Alngaltar renh ineh-warn lanthekarl, rang renh nwerneh-warn lanthekarl-arteh. Lakenheng yeng ywarn Altjerreh irrpelth-irrek.” Lakenh Peter-el inenh ilek. ");
INSERT INTO amx_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Nakenh-nakenh mapel Peter renh awekarl-penh inang ntertemeh anek. Inang Altjerreh kangkek, lakenh angkemel, “Arratj kwenh Altjerrel tjerrtj lwereny map ngwem, anetjeng kwer-warn-atheh twep-irretjeh, inang iteth ngampekarl anetjenheng.” ");
INSERT INTO amx_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Arrwekel Jew map inang Stephen renh irrernng atwekarl-penh, inang nakenh-nakenh arrpenh map inenh atwetjeh alwernek. Nakenh-nakenh mapemeh Jerusalem-eng ater arrtjanewarrekarl. Inang mer Phoenicia-eh-atwetj mer Cyprus-eh-atwetj mer Antioch-eh-atwetj thwen ater alhekarl. Inang angketj mwerr Ngkart Jesu-akert ilerl-apek tjerrtj Jew mapehant. ");
INSERT INTO amx_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Kwereng nakenh-nakenh rrpwetj mer Cyprus-areny Cyrene town-areny thwen inang town Antioch-warn alhek. Inang tjerrtj Greek angkenh-angkenh map angketj mwerr Ngkart Jesu-akert kaltj-anthek. ");
INSERT INTO amx_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ngkartel angketj inehenh twer-ilek. Mapelemeh Ngkart renh nakek, rang inenh kwer-warn twepelh-ilek. ");
INSERT INTO amx_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","24","Werlampareny inarl Jerusalem-el anetjamarl, inang angketj nhenh-penh awek. Inang artwang Barnabas renh ineh-warn lanthek town Antioch kwer-warn. Barnabas rartek artwang mwerr anek, nakentj angerr-akert, Kwerrern Alngaltarel renh twer-ilekarleng wart. Rang Antioch kwer-warn alhek. Rang alhengk-arek, Altjerr rang Antioch-areny ineh kangkentj mernelhekarl. Barnabas rang arrken angerr awelhek. Rang inenh twer-ilemel tjep-tjep-ilek, inang Ngkart renh twerel kwet naketjeh. Tjerrtj arrpenh mapel renh awemel, tjerrtj aningk Ngkart-warn twep-irrek. ");
INSERT INTO amx_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Kwereng Barnabas rang mer Tarsus-warn alhek, Saul-ek palenthwetjeh. ");
INSERT INTO amx_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Rang renh ngwenm aretj-alhek, rang anginek renh Antioch town-warn. Kwereng year nyentel ratherr Antioch werlampareny kaltj-anthetjart. Town Antioch kwerel-amparr nakenh-nakenh map inenh arreny Christian anthek. ");
INSERT INTO amx_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Barnabas Saul ratherr Antioch-el anetjam-rlwer, Altjerr-henh angketj angenh-angenh rrpwetj inang Jerusalem-eng petjek. ");
INSERT INTO amx_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","30","Artwang nyent arreny Agabus-el werlamparenyeng ularr irnemel ilek, kwatj-kweny mer apanpel anetjenh. Tjerrtj map-anem mernek-arlk kwatjek-arlk arrakelakel irretjenh. Kwerrern Alngaltarel renh-amparr ilekarl. Nakenh-nakenh map angkerrek, Judea-areny map-warn tjenkerr maney lanthetjeh. Kwereng inang tjenkerr maney renh Barnabas Saul kwer-atherr-amparr anthek, ratherr maney renh Judea-warn anginetjeh, Jerusalem werlampareny-henh arntarnt-arentj mapeh anthetjeh. Kelant kwatj-kweny rang anek ahelh ntjaperel, artwang Claudius Rome-areny rarl twernk angerr anetjam-rlwer mer ntjapereh. ");
INSERT INTO amx_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Arltang arrpenhel King Herod-elemeh nakenh-nakenh inenh atwetjeh alwernek. Rang arrpenh map antwerrkemel atwek. ");
INSERT INTO amx_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Rang atwenh-atwenh kwerenh map twernek, inang kaltj-anthenh-anthenh nyent arreny kwerenh James irrernng atwetjeh. Inang renh atwek. James rang John-kenh kekw anek. ");
INSERT INTO amx_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Herod-elemeh angketj awek, tjerrtj Jew angerrepat map inarl nhenheh kangkekarl. Lakenh rang atwenh-atwenh kwerenh map ilek, Peter-emeh antwerrketjeh. Inang Peter renh-anem antwerrkek irlpangkentj angerr anetjam-rlwer. Irlpangkentj nhenhel nheng Jew mapel kweteth arltang 8-rlwer anyenem, mern arlwar-ilenh-ilenh-kweny itja kwenh inang arlkwetjart. ");
INSERT INTO amx_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Inang Peter angemel tjayel-warn kwernek. Herod rang atwenh-atwenh 16 ilek, inang renh mantjel arntarnt-aretjeh, Peter rang ater arrtjanehetjeng. Kel arrwekel atwenh-atwenh 4 pelelek-amparr renh arntarnt-aretjeh, kwereng 4 pel arrpenh mapel renh arntarnt-aretjeh. Lakenh-artek arrpenhek-arrpenhel renh arntarnt-arek aherrkel kwenyel thwen. Herod rartek ahentj-anek, Peter renh court-el pawenhetjeh tjerrtj mapeng alngetherr. Mpank kwet, rang karelhetjam irlpangkentj anekarl-penhekant. ");
INSERT INTO amx_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Peter rang tjayelel kwet anek. Nakenh-nakenh inang Altjerr tjang-pawenhetjam kwer, Altjerrel renh arntarnt-aretjeh. ");
INSERT INTO amx_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Kweny arrpenhelemeh Herod rang iterrek, “Ngwenth thang Peter renh pawenhetjenheng mapeng alngetherr.” Kweny kwerel Peter rang ankwang intetjam tjayel kwenel. Rang atwenh-atwenh atherreng mpwepel intek. Peter-kenh mwerlt chain-el ayernekarl atwenh-atwenh nyent-henh mwerlt-warn. Peter-kenh mwerlt arrpenh chain-el ayernekarl atwenh-atwenh arrpenh-henh mwerlt-warn. Peter rang mpwepel intek, atwenh-atwenh atherram itepelant-atherr intek. Atwenh-atwenh atherr arrpenhel tjayeleh arrew arntarnt-aretjam. ");
INSERT INTO amx_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ngkart-henh angelemeh tjayel kwenel irnetj-alhek. Parrtj rang tjayel kwenel parrtjek. Angelel Peter renh ltwang tanthemel renh kemelh-ilemel ilek, “Parrp kemerray!” Peter-henh chain ratherr Peter-henh iltjang atherreng rlwelherl-alhek. ");
INSERT INTO amx_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Angel rang renh ilek, “Rnwanentj ngkwengenheh irrpang, pwet ngkwengenheh thwen.” Kel Peter mantarr kwer irrpek. Kwereng angelel renh ilek, “Mantarr arrpenh inemel artelhang. Tjengel-ayeng anharrel petjang.” ");
INSERT INTO amx_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Kelemeh Peter rang angel kwer-atherrel-ayeng anharrel alhek. Peter-anem iterrek, anengkerr rang aretjamarleh-athen. ");
INSERT INTO amx_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ratherr atwenh-atwenh arntarnt-arentj atherreng arraterl-alherrek, mpwep-angkwerr. Kwereng ratherr gate angerretj-warnemeh alhek. Gate rang altjwer-irrek, ratherremeh keth-warn arratenhek. Angel rang kwek war Peter-el-ayeng alhek, kwereng rang ywerrerl-alhek. ");
INSERT INTO amx_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Peter rang kel alhengk-aremel angkek, “Thang kwenh alhengk-arem, Altjerrel angel kwerenh lanthekarl, yengenh tjayeleng arratelh-iletjeh. Herod tjerrtj Jew map-arlk thwen inang kwenh yengenh irrernng atwetjeh ahentj-anek.” ");
INSERT INTO amx_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Kwereng Peter rang Mary-henh warl-warn alhek. Mary nhenh rartek John-henh mwek anek. John nheng kwerenh arreny arrpenh anek Mark. Mary-henh warlel nakenh-nakenh map anek, inang Altjerr Peter kwer tjang-pawenhetjam. ");
INSERT INTO amx_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Peter-elemeh door rltar-rltar-atwek. Door rang martelhentj anek. Marl rrkwapenh-apenh nyentemeh rang door-warn aretjeh petjek, arreny kwerenh Rhoda. ");
INSERT INTO amx_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Rhoda rang Peter renh angkerleh awek, rang renh alhengk-awek. Rang angerr arrken awelhemel, rang angwerrek, Peter-eh door altjwer-iletjeh. Rang parrp angkep map-warn irrpenhek. Rang inenh ilek, “Peter nhengeyay door-el irnetj-alhek!” ");
INSERT INTO amx_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Inang marl renh ilek, “Ntwang key ahert-irrek?” Marl rang twer-irremel angkek, “Peter nhengeyay door-el irnetj-alhek!” Inang angkek, “Angel kwerenh apekaw!” ");
INSERT INTO amx_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Peter-elemeh door renh kwet rltar-rltar-atwetjam, inang kwer altjwer-iletjeh-atwetj. Inang door renh altjwer-ilemelemeh arek, Peter arratj irnerleh. Inang anwerlkek renh aremel. ");
INSERT INTO amx_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Peter-elemeh iltjem-iltjemel inenh ntertelh-ilek. Rang inenh ilek, nthakenh angelel renh tjayeleng arratelh-ilek. “Arrantherr James peltj arrpenh map thwen iletjeh, yeng lyet tjayeleng arratekarleng.” Rang inenh imperl-alhekemeh. Peter rang mer arrpenh-warnemeh alhek. ");
INSERT INTO amx_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kweny-rtwehemeh tjayel kwenel atwenh-atwenh map athek-irremel ywarn iterrek. Inartek Peter-ek ywarn palenthwek. “Nthakenhameh rang arratek?” ");
INSERT INTO amx_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Herod-el Peter-eh ywarn palenthwek. Rang atwenh-atwenh kwerenh map pawenhek, inarl Peter renh arntarnt-aretjam. Rang inenh ywarn pawenhemel rang inenh atwenh-atwenh arrpenh map-warn lanthek, inang inenh irrernng atwetjeh. Kwereng Herod rang mer Judea-eng town Caesarea-warn alhek, kwerelemeh war anetjeh. ");
INSERT INTO amx_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","King Herod tjerrtj town Tyre-areny mapeh Sidon town-areny mapeh thwen arnkely kweteth anetjart. Tjerrtj inang athek-irrek, Herod-elemeh mern inehenh arrngert-ilehetj. Inang mern inehenh Herod-henh mereng payem-iletjart. Lakenheng inang urrpey lanthek Herod-kenh warl-warn. Urrpey inangemeh Herod-kenh warl arntarnt-arenh-arenh arek, kwerel-ayeng angkerrek. Artwang arreny kwerenh Blastus anek. Inang Blastus renh pawenhek, “Nwern kwenh Herod-ek angketjeh ahentj-anem. Ntwang key angketj nhenh kwer-warn lanthem?” Kel Blastus ineh kangkwerrek. Rantem angketj inehenh Herod-warn angek. ");
INSERT INTO amx_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Arltang arrpenhelemeh inang petjek Herod-warn, angkerretjeh. King Herod-emeh petjek mantarr amparrkey-arrkey-akert, chair angerretj kwerenhel rang arrernelhek. Rang tjerrtj ineheng anngetherr angkek. ");
INSERT INTO amx_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Tjerrtj map inang renh awek. Inang arlkemel ilek, “Herod rang itja artwang-artek angkem! Altjerr-artek kwenh rang angkem!” ");
INSERT INTO amx_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Herod rang ntert anek, rang inenh itja arnpakek. Lakenheng Ngkart-kenh angelel Herod renh irlkertemeh-ilek. Irnngang mapel-anem anert kwerenhel kwen inang arlkwetjam, kwereng rang ilwekemeh. ");
INSERT INTO amx_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Nakenh-nakenh mapel Altjerr-henh angketj kaltj-antherl-apetjam mer arrpenh mapeh. Tjerrtj aningkel-anem Jesu renh nakek, inang kwer-warn twep-irrek. ");
INSERT INTO amx_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabas Saul ratherr kel tjenkerr maney nheng Jerusalem-areny werlamparenyeh angetjemel antherl-alhek. Tjenkerr maney nheng werlampareny Antioch-areny mapel arrwekel anthekarl. Kel ratherr artwang nyent ngwek Jerusalem-eng, arreny kwerenh John Mark. Kwereng inang pwert-anem Antioch town-warn angkep alpek. ");
INSERT INTO amx_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antioch town-el werlamparenyel-ayeng artwang Altjerr-henh angketj angenh-angenh map anetjart, kaltj-anthenh-anthenh map thwen. Arreny inehenh Barnabas, Simeon, arreny arrpenh kwerenh Rrpwerl, Lucius Cyrene town-areny, Manaen, rang nheng Herod Antipas-el-ayeng mangkek. Artwang arrpenh anek Saul. ");
INSERT INTO amx_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Arltang nyentel artwang nhenh map alyelhemel Ngkart naketjam, kwer-warn angketjam. Inang Ngkartant iterl-aremel mern-kweny anetjam. Kwereng Kwerrern Alngaltarel inenh ilek, “Arrantherr Barnabas Saul renh-atherrenh ngkernang, ratherr angketj mwerr mer mapel kaltj-antherl-apetjeh.” ");
INSERT INTO amx_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Inang weth mern-kweny anek, Altjerr-warn angkemel. Kwereng inang iltjang inehenh Barnabas Saul kwer-atherr-henh kaperteh arrernek. Kwereng inang renh-atherrenh lanthekemeh. ");
INSERT INTO amx_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Kwerrern Alngaltarelemeh Barnabas Saul renh-atherrenh town Seleucia-warn lanthek. Town nhenhel inang boat-eh antjek, mer Cyprus-warn alhetjeh-anngernt. Cyprus rartek mer island angerr anek kwatj alay mpwepel. Inang boat-el alhek kwatj alay-angkwerr, antekerr altwerl mer Cyprus-warn-athek. ");
INSERT INTO amx_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Salamis town kwerel inang boat-eng anarnpek. Inang alhek church nyentam-nyent-warn, Altjerr-henh angketj kaltj-antherl-apetjeh. Tjerrtj Jew map inang church nhenh map-warn arraw-irretjart. John Mark rang kwer-atherrel-ayeng tangetjel anek. ");
INSERT INTO amx_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","8","Inang town Salamis renh imperl-alhemel altwerl-atheh inang alhek mer island iter arrwengak-warn, town Paphos-warn. Town Paphos kwerel artwang Jew nyent anetjart, rang arrwengkelth mpwaretjart. Rang rrtjwerremel nakelhetjart, rang Altjerr-henh angketj angenh-angenh kwel anek. Arreny kwerenh Bar-Jesus. Arreny kwerenh arrpenh anek Elymas. Elymas rang peltj anek artwang Sergius Paulus-kenh. Sergius Paulus rang Rome-areny government-eh twernk angerr anek mer island Cyprus ntjaperek. Rang artwang inangkal anek. Sergius Paulus rang angketj awek, Barnabas Saul ratherr mer Cyprus-el anemeng. Rang kwer-atherr ntangkelhek, ratherr renh Altjerr-henh angketj kaltj-anthetjeh. Kel ratherr kwer-warn alhek, Altjerr-kenh angketj kaltj-anthetjam. Artwang nheng Elymas rang kwer-atherr arrngert angkek. Rang Sergius Paulus renh ilek, “Ntwang angketj nhenh naketjal anay! Mentj impang!” Rang ahentj-kweny-irrek, peltj kwerenhel angketj Ngkart-akert awemel nakehetjeng. ");
INSERT INTO amx_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Kwerrern Alngaltarelemeh Saul renh twer-ilek. Saul rang arreny Paul-anem. Paul-elemeh Elymas anngang aremel renh ilek, ");
INSERT INTO amx_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Ntwartek arrentj-arteh anem! Ntwang tjerrtj mwerr mapeh kweteth ahentj-kweny-irreperrem! Ntwang rrtjwerremel Altjerr-henh angketj perrpert-ilerl-apem! ");
INSERT INTO amx_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Altjerrelemeh ngwenh atwetjenh pweng-ilemel! Kwek war ntwang pweng anetjenh. Kelant ntwang anngang alngampetjenh.” Elymas rang kel pweng-anem anek. Rang tjerrtj arrpenh ngwek, renh tjey angerl-apetjeh. ");
INSERT INTO amx_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Twernk Sergius Paulus-el renh anwerlkemel arek. Rang anwerlkek, rang angketj Ngkart Jesu-akert awekarleng. Rang angkek, “Thang kwenh angketj nhenh arrwekeleng awetj-kweny!” Rang kel Ngkart renh nakek-anem. ");
INSERT INTO amx_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paul inang boat angerr-warn antjek. Inang boat-el Paphos town-eng kwatj alay-angkwerr ayerrer-atheh alhek, town Perga-warn. Town Perga rang mer Pamphylia-el artelhek. Inang town Perga-el irretj-alhemel inang boat-eng anarnpek. John Mark-elemeh renh-atherrenh mer kwerel imperl-alhek. Rang nyent Jerusalem-warn angkep alpek. ");
INSERT INTO amx_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Paul Barnabas ratherremeh Perga kwereng Antioch town-warn anper-irrenhek. Antioch nhenh-artek mer Pisidia-el anek. Arltang angerr Saturday-el ratherr tjerrtj Jew map-kenh church-warnemeh alherrek. Ratherr church kwen irrpenhemel arrernelhetj-alhek. ");
INSERT INTO amx_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Artwang arrpenhel angketj Moses-el arrernekarl read-em-ilek, kwereng rang angketj nheng Altjerr-henh angketj angenh-angenh mapel arrernekarl read-em-ilek. Kwereng church-ek-artweyel urrpey lanthek, Paul Barnabas renh-atherrenh ngwerl-alpetjeh. Urrpey rantem renh-atherrenh pawenhek, “Artwang atherray! Mwerr key mpwel apek nwernenh angketj ilemel kaltj-anthetjeh?” ");
INSERT INTO amx_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Paul rang kemerremel inenh iltjel war ilek. Rang inenh ilek, “Artwang Israel-areny mapay, arrantherr yengenh awerrerrang! Tjerrtj arrpenh mapel thwen, arrantherrarl Altjerr nakem! ");
INSERT INTO amx_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Altjerr rang arrwekeleny nwern-henh map urrarek, arlaltj kwerenh map anetjeh. Inang mer Egypt kwerel anetjam-rlwer, Altjerr rang inenh twer-ilek, inang aningkam-aningk irrek. Kwereng Altjerrel Egypt-areny map kwatjel atwek, Altjerrel kwerenh mapant arratelh-ilek mer Egypt-eng. ");
INSERT INTO amx_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Rang inenh rrkwal angerrel arntarnt-arentjek 40 years-eh-atwetj. Inang Altjerr kwer kwet wenng-angketjam, Altjerrel inenh arntarnt-aretjam kwet, rang inenh itja impek. ");
INSERT INTO amx_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Altjerrel inenh mer Canaan-warn angek. Mer Canaan kwerel tjerrtj mer 7 pel-areny anekarl. Altjerr rang tjerrtj Canaan-areny map atwemel ywerrelh-iletjam, rantem mer Canaan renh anthek arrwekeleny nwern-henh mapek. ");
INSERT INTO amx_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Tjerrtj nwern-henh map mer Egypt-el 400 years-ek-atwetj anek. Kwereng inang mer Egypt-eng arratek. 50 years arrpenh-penh Altjerrel-anem mer nhenh arreny Canaan renh anthek ineh. “Inang mer nhenhel anetjam-rlwer, Altjerrel artwang alkwert map ineh nyentam-nyent urraretjart, ineh twernk anetjeh, ahelenp-arlk inenh arntarnt-aretjeh. Kwereng Altjerrel Samuel renh-anem urrarek. Samuel rartek Altjerr-henh angketj angenh-angenh anek. ");
INSERT INTO amx_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Kwereng nwern-henh mapel Altjerr renh pawenhek king-eh, ineh twernk angerr anetjeh. Kwereng Altjerrelemeh Saul urrarek, king ineh anetjeh. Saul-kenh angey rang arreny Kish anek. Kish rang Benjamin-kenh peltj ingkerneny mapeng petjek. Saul rang king-anem ineh anek 40 years-eh-atwetj. ");
INSERT INTO amx_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kwereng Altjerrelemeh Saul renh anpwek, David-anem rang ngkernek, king ineh anetjeh. Altjerr angkek, ‘David rang kwenh tjeng war kangkwerrem, lakenh yeng angerr kwer kangkem.’ David nhenh rang Jesse-henh ler anek.” ");
INSERT INTO amx_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Paul-el inenh ilek, “Altjerrelemeh tjerrtj Israel-areny mapeh arrwekel kwet alhelek, rang artwang nyent ineh-warn lanthetjenh, inenh arntarnt-aretjeh. Artwang rang David-kenh peltj ingkerneny mapeng petjetjenharl. Jesu rang kwenh artwang Arntarnt-arenh-arenh rang anem. ");
INSERT INTO amx_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jesu kwereng arrwekel John rek-amparr petjek. John rang tjerrtj Israel-areny map kaltj-anthek, inang anetjeng Altjerr-warn twep-irretjeh, rang inenh kwatj-warn irrpelh-ilemel baptise-em-iletjenheng. ");
INSERT INTO amx_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","John-el rrkwapentj kwerenh mpwaretjam-rlwer, rang tjerrtj map pawenhek, ‘Ngwenham yeng? Nthakenh arrantherr tjeng-penh iterl-arem? Thang arrantherrenh ilem, yeng itja Arntarnt-arenh-arenh nheng anem, kwerarl arrantherr karelhem. Arntarnt-arenh-arenh rang ngwenth war arrehantherr-warn petjetjenh. Yeng ahelh-areny war anemeng, rang kwenh mwerr anem alkerengarl lanthek.’ ");
INSERT INTO amx_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Peltj mapay, nwern-artek Abraham-henh peltj ingkerneny mapeng petjekarl. Yengemeh awerrerrang! Tjerrtj arrpenh iter-penh mapay, arrantherr-arlk Altjerr nakem. Arrantherremeh yengenh ingkerrekel awerrerrang! Altjerrel-artek nwernenh ilek, rang ahentj, tjerrtj nwernenh anetjeng inetjeh, nwern iteth ngampekarl kwerel-ayeng anetjenheng. ");
INSERT INTO amx_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Tjerrtj Jerusalem-areny map angerrepat inehenh thwen inang itja alhengk-arek, Jesu rang Christ anekarl, nheng Altjerrelarl ngkwey alhelekarl. Arltang angerr Saturday-el inang Altjerr-henh angketj kweteth awetjartarl, nheng Altjerr-henh angketj angenh-angenh mapel ngkwey pip-warn arrernekarl. Angketj nhenh ingkern-anem arratemel keth-irrek, nheng tjerrtj Jerusalem-areny inang Jesu renh merrentj-arteh atwekarleng. ");
INSERT INTO amx_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Inang Jesu renh pelkel pawenhek. Inang twernk Pilate renh pawenhek, rang Jesu renh irrernng kwet atwetjeh. ");
INSERT INTO amx_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Angketj nhenh Altjerr-henh pipel-ayeng intem, ‘Rrkwapenh-apenh Altjerr-kenh inang irrernng atwetjenharl.’ Atwenh-atwenh mapel kwenh Jesu renh ntwerlk-warn arrernemel irrernng atwek, lakenh angketj nhenh kel arratj-irremel arlpaw-irrek. Kwereng inang renh ntwerlkeng anarnpelh-ilek. Inang renh inteyeh kwernek. ");
INSERT INTO amx_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Altjerrel-anem Jesu renh irrernngeng kemelh-ilemel iteth-ilekarl. ");
INSERT INTO amx_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Kwereng nakenh-nakenh aningkel renh irrernng-penh kemerrekarl arek. Nakenh-nakenh kwerenh map inarl arrwekel kwerel-ayeng itethel-ayeng-amparr nheng nthwerl-apetjart, mer Galilee-eng town Jerusalem-warn. Nakenh-nakenh nhenh mapelemeh lyet tjerrtj ingkerrek ilerl-apem, Jesu kwenh irrernngeng kemerrekarl. ");
INSERT INTO amx_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Nwern arrantherrenh lyet angketj mwerr renh ilem. Iterl-aray, Altjerrel nheng arrwekeleny nwern-henh map alhelekarl, rang kelant Christ renh lanthetjenh. ");
INSERT INTO amx_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Altjerrel kel Christ nwerneh-warn lanthek. Christ rang kwenh Jesu anem. Nheng pip Psalm 2-el-ayeng nwern angketj Jesu-akert ilem, ‘Ntwang ler tjengenh, yeng angey ngkwengenh-anem.’ ");
INSERT INTO amx_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Altjerrel Jesu renh irrernngeng kemelh-ilek, mpwerrk kwerenh rang itja ntert-irretjeh impek. Nhenh angketj arrpenh Altjerr-henh pipel-ayeng intem, ‘Thang ngwenh alhelem, tharl arrwekel David nheng alhelekarl-arteh.’ Nhenh-atwetj Altjerr rang alhelek, renh irrernngeng kemelh-ilemel iteth-iletjek. ");
INSERT INTO amx_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","“Angketj arrpenh intem, David-el arrwekel pip-warn arrernekarl, ‘Altjerrel itja tjerrtj tjeperr mpwerrk kwerenh renh impetjenh, rarrp ntert-irretjeh.’ ");
INSERT INTO amx_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“David rang iteth anetjam, rang Altjerreh kangkwerrek. Kwereng rang ilwek, inang renh awenng-warn kwernek, angerrepat kwerenh mapel-ayeng. Awenngel mpwerrk kwerenhemeh ntert-irremel ywerrek. ");
INSERT INTO amx_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Altjerrelemeh Jesu irrernngeng kemelh-ilek. Mpwerrk kwerenh itja ntert-irrek. ");
INSERT INTO amx_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Artwang peltj mapay! Thang arrantherrenh nhenh ilem, Jesu ilwekarleng, lakenh Altjerr tjey mpwarek arrehantherr, rang anetj arrehantherr-henh wetjeh, rang ngwerleny arrehantherr anetjenheng, atwetj-kweny. ");
INSERT INTO amx_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Arrantherr Jesu renh nakemeng, kwereng arrantherr Altjerreng ularr arratj anetjeh. Arrantherr apek Moses-henh mpwareng-arengehant kangkwerremeng war, arrantherremeh itja Altjerreng ularr arratj anem. ");
INSERT INTO amx_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Arrantherremeh mantjel arelhetjeh, arrantherr itja tjerrtj arrpenh-arteh mernelhetjeh. Ineh-penh Altjerr-henh angketj angenh-angenh arrpenhel ilek, lakenh-hetj, ");
INSERT INTO amx_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Tjerrtj arrantherremeh arrampewenh-wenh mapay! Arrantherr kelant anwerlketjenh, ilwetjenh-anngernt. Arrantherr aretjenh, thang arrpenh anthwerr mpwaretjenh. Arrantherremeh nhenh ywarn kwet iterl-aretjeh. Arrpenhel apek arrantherrenh nhenh-penh ilekarleng.’ ” Lakenh Paul-el werlampareny inenh arteng-ilemel ilek. ");
INSERT INTO amx_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Paul Barnabas ratherr church kwereng arratentj-alhek, tjerrtj mapel renh-atherrenh ngwek, “Saturday arrpenhel nhenh-warn mpwelanth petjetjeh, nwernenh weth kaltj-anthetjeh.” ");
INSERT INTO amx_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Kel werlampareny map church-eng arratek. Tjerrtj Jew arrpenh map tjerrtj Altjerr nakenh-nakenh arrpenh map thwen inang Paul Barnabas kwer-atherrel-ayeng alherl-apetjam. Ratherr inenh ilerl-apetjam, inang Altjerr renh twerel kwet naketjeh. ");
INSERT INTO amx_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Saturday arrpenhelemeh town-areny ingkerrek anthwerremeh arraw-irrek, Ngkart-henh angketj awetjeh. ");
INSERT INTO amx_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Tjerrtj Jew mapel tjerrtj aningk inenh aremel inang Paul kwer-atherr may-irremel tjel-angkerrerrek. ");
INSERT INTO amx_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Paul Barnabas ratherr anew-anewel kwet inenh ilek, “Altjerrel ilernenh ilek, ilern arrehantherr-amparr angketj mwerr Jesu-akert renh iletjeh. Arrantherr kwenh angketj kwereng ntjwem-irrekarl. Arrantherr itja ahentj-anem, iteth kwet Altjerrel-ayeng anetjeh. Lakenheng ilernarrp kel tjerrtj lwereny map-warnemeh alhetjeh, inehemeh Altjerr-henh angketj kaltj-anthemel iletjeh. ");
INSERT INTO amx_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Ngkart rang ilernenh lakenh ilek, ‘Thang mpwelenhanth arrernek, tjerrtj lwereny mapeh parrtj anetjeh. Mpwelanth tjerrtj ingkerrek ahelh apanpel iletjeh-anngernt, yeng ahentj-anem, tjerrtj inenh arntarnt-aretjeh, inang iteth kwet tjengel-ayeng anetjenh.’ ” Lakenh Paul-el inenh ilek. ");
INSERT INTO amx_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Tjerrtj lwereny inang Paul-henh angketj awek. Inang Ngkart-henh angketj kangkemel nakek. Altjerrel arrwekel kwet tjerrtj inenh urrarekarl, inang kwerel-ayeng iteth ngampekarl anetjenheng. Inant renh kangkemel nakek. ");
INSERT INTO amx_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Nakenh-nakenh mapel Ngkart-henh angketj tjerrtj ingkerrekemeh kaltj-antherl-apetjam mer Pisidia ntjaperel. ");
INSERT INTO amx_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Mer kwerel marl angerrepat rrpwetj anek, inarl Altjerr nakenh-nakenh anek. Tjerrtj Jew mapelemeh marl inenh artwang angerrepat mer-areny map thwen rrwampey-ilek. Angerrepat inang Paul Barnabas kwer-atherr ngkwantj-irrek. Kwereng inang renh-atherrenh mer inehenheng anpwek. ");
INSERT INTO amx_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Paul Barnabas ratherremeh ingkang-henh rlwelhemel nmwernt-arlk lernerl-alhemel angkek, “Ilern lakenh mpwarem, arrantherrarl angketj Jesu-akert pal awekarleng. Arrantherr ilernenh iltekarleng, Ngkarteng arrantherr kel ntjwem-irrekarl!” Kel ratherr town arrpenh-warn Iconium-warn alherrek. ");
INSERT INTO amx_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ngkart nakenh-nakenh map mer Pisidian Antioch-el inang arrken kwetarl anek, Kwerrern Alngaltar rang inehel-arleng anekarleng wart. ");
INSERT INTO amx_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Kwereng Iconium town-el Paul Barnabas ratherr tjerrtj Jew map-kenh church-warn irrpek, angketj mwerr renh iletjeh-anngernt. Tjerrtj Jew mapel tjerrtj iter-penh mapel thwen renh-atherrenh awekarl-penh, tjerrtj aningkelemeh inang angketj Ngkart Jesu-akert nakek. ");
INSERT INTO amx_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Tjerrtj Jew arrpenh mapel itja renh-atherrenh nakek. Inang tjerrtj iter-penh map rrwampey-iletj-alhek, kwereng tjerrtj iter-penh arrpenh map nakenh-nakenh mapeh ahentj-kweny anek. ");
INSERT INTO amx_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Paul Barnabas ratherr town Iconium-el kwetemeh anek, ratherr tjerrtj map angketj Ngkart Jesu-akert anew-anewel kwet kaltj-antherl-apetjam. Ngkartel renh-atherrenh twer-ilek, ratherr twerel mpwaretjeh. Ratherr tjerrtj irlkert map mwerr-ilek, kwerrern anetj map-arlk anpwemel. Lakenh Ngkartel tjerrtj mapeh mernek, Paul kwer-atherr-henh angketj arratj anemeng. ");
INSERT INTO amx_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Iconium-areny map patemel anek. Tjerrtj arrpenh inang Jew mapant kangkwerremel nakek, Paul Barnabas kwer-atherr inang ahentj-kwenyarl anek. Tjerrtj arrpenh mapel renh-atherrenh nakek. ");
INSERT INTO amx_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Kwereng tjerrtj iter-penh arrpenh map, tjerrtj Jew arrpenh map thwen angerrepat inehenhel-ayeng inang angkerrek, Paul renh-atherrenh irrernng atwetjeh, irntel iltewemel. ");
INSERT INTO amx_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Paul Barnabas ratherr angketj kwereng awekarleng, ratherr Lycaonia-angkwerr ateremeh alherrek. Ratherr town angerr atherr-warn Lystra-warn Derbe-warn thwen alherrek. ");
INSERT INTO amx_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Ratherremeh tjerrtj mapeh angketj mwerr renh kwet kaltj-antherl-apetjam, town kwer-atherrel-ayeng, mer kwek mapel thwen. ");
INSERT INTO amx_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Town Lystra-el artwang arrpenh anek, rang arlamarr kwet anentjekarl kwer kwekeng-ntjel. Rang itja kwet nthwerl-apek. ");
INSERT INTO amx_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Rang Paul awetjam, Paul rang tjerrtj map kaltj-anthetjam-rlwer. Paul-el artwang renh aremel alhengk-arek, artwang rang angketj kwerenh nakerleh. Artwang rang nakentj-akert anemeng wart, lakenheng Paul rang kaltj anek, rang artwang renh mwerr-iletjeh. ");
INSERT INTO amx_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Rang artwang arlamarr renh arlkemel ilek, “Kemerremel irnay!” Artwang rang kel kemerremel irnek, nthwekemeh. ");
INSERT INTO amx_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Tjerrtj mapel nhenh arekarl-penh, inang angketj Lycaonia-el untarel ilek, “Yay! Altjerr nwern-henh atherr kwenh tjerrtj-arteh irrek, kwenelakw nwerneh-warn ratherr petjek!” ");
INSERT INTO amx_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Inang Barnabas Paul renh-atherrenh inang arreny altjerr-arrpantey anewek, Barnabas arreny Zeus, Paul arreny Hermes. Tjerrtj inang angketjart, Zeus rang altjerr kwel anek, Hermes rang Zeus-henh angketj ilenh-ilenh kwel anek. Lakenh inang Paul arreny Hermes anewek, rang angketj ilenh-ilenh mwerr anemeng wart. ");
INSERT INTO amx_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Warl angerretj altjerr-arrpantey nheng Zeus-kenh rang town-eng kethel artelhek, ntwarr-kwenh. Zeus kwerenh warlek-artwey rang pwelek rrwey-akert waly-akert thwen town gate-warn petjek. Warlek-artwey town-areny map thwen inang ahentj-anek, Paul Barnabas kwer-atherr ker tjenkerr-arlk anthetjeh. ");
INSERT INTO amx_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Paul Barnabas ratherr nhenh-penh awek. Ratherr mantarr kwer-atherr-henh alterrek, ahentj-kweny-irremel. Ratherr rlkwerr-warn tjerrtj aningk-warn arrtjanek. Ratherr inenh untarel ilek, ");
INSERT INTO amx_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Artwang mapay, itja lakenh mpwaretjeh! Ilern kwenh tjerrtj arrehantherr-arteh anem! Ilern-artek arrantherrenh angketj mwerr ilerl-apem. Altjerr-arrpantey arrekantherr-kenh mentj imperrerray! Arrantherr Altjerr ngwerrm-warn twep-irrerrerrang! Altjerr nhenh rarl alker ahelh thwen kwatj alay thwen arrmernekarl kwer-warn, thep thwen ker irrpenng thwen ker ingkerrek rang arrmernekarl kwer-warn. ");
INSERT INTO amx_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ngkweyeng-ntjel Altjerrel tjerrtj ingkerrek impek, inang altjerr-arrpantey inehenh naketjeh, inang ahentj-anekarleng wart. ");
INSERT INTO amx_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Altjerr rang kangkentjel mernelhek arrekantherrek, arrehantherr kwatj alker-areny-arlk anthemel mern arrpenhek-arrpenh ingkerrek. Rang kweteth arrantherrenh wantem, arrantherrenh tjep-tjep mpwarem.” Lakenh Paul ratherr inenh ilek. ");
INSERT INTO amx_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Tjerrtj inang Paul-henh angketj awekarleng, inang ahentj-anek kwet Paul Barnabas kwer-atherr ker tjenkerr atwemel anthetjeh-anngernt. Ratherr kwet ahentj-kwenyarl anek. Mentjemeh inang pwelek renh atwetjal impek. ");
INSERT INTO amx_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Kwereng tjerrtj Jew rrpwetj inang Antioch town-eng Iconium town-eng thwen petjek. Inang tjerrtj map rrwampey-ilek. Mer-areny inang Jew nhenh ineh kangkwerrek. Inang Paul renh irntel iltewek. Kel inang iterl-aremel rang kwel irrernng intemeng wart, inang renh town-eng keth-warnemeh tjarr-angemel wek. ");
INSERT INTO amx_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Kel nakenh-nakenh mapemeh kwer-warn petjemel arraw-irrek. Paul rang kemerrek, rang inehel-arleng town-warn angkep alpek. Kwereng kweny-rtwehemeh Paul Barnabas ratherr Derbe town-warn alherrek. ");
INSERT INTO amx_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Ratherr town Derbe kwerelemeh tjerrtj map angketj mwerr Jesu-akert kaltj-antherl-apetjam. Mapelemeh angketj renh nakek, inang nakenh-nakenh mapemeh irrek. Kwereng ratherr Lystra town-warn-amparr alperrek. Kwereng Iconium town-warn Antioch town-warn thwen ratherr angkep alperrek. ");
INSERT INTO amx_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ratherr nakenh-nakenh map twer-ilemel inenh tjep-tjep-ilek, inang Jesu twerel naketjeh kwet. Ratherr inenh ilek, “Nwern kwenh rwekenth-kenth-warn irretjeh-amparr, Altjerr-henh mer-warn irrpetjeh-anngernt, iteth ngampekarl kwerel-ayeng anetjeh-anngernt.” ");
INSERT INTO amx_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Paul Barnabas ratherr arntarnt-arentj rrpwetj urrarek ngkernetjeh-anngernt, werlampareny inehenh mapeh. Ratherr mern-kweny-amparr anek, Altjerrekant angketjam. Kwereng ratherr Ngkart renh pawenhek-amparr, rang arntarnt-arentj inenh kwet anyenetjeh. Kwereng ratherr inenh ngkernekemeh. ");
INSERT INTO amx_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Paul ratherremeh mer Pisidia kwer-angkwerr anper-alhek mer Pamphylia-warn petj-alpek. ");
INSERT INTO amx_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Town Perga kwerel ratherr mer-areny mapemeh Altjerr-henh angketj kaltj-antherl-apek. Kwereng ratherr Attalia town-warn anper-irrenhek. ");
INSERT INTO amx_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Attalia kwerelemeh ratherr boat angerretj antjemel town Antioch-warn angkep alperrek, kwatj alay-angkwerr. Antioch town nheng kwereng werlamparenyel renh-atherrenh nheng arrwekel Altjerreh kwer-atherr tjang-pawenhek, inenh lanthekarl, angketj mwerr kaltj-antherl-apetjeh. Ratherr kel-antey nhenh mpwarekarl. ");
INSERT INTO amx_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Ratherr Antioch-warn alhemel ratherr boat-eng anarnpetj-alhek, kwereng ratherr werlampareny arrawelh-ilek. Ratherr inenh ilek, “Ilern kwenh angketj mwerr renh tjerrtj lwereny mapeh kaltj-antherl-apetjam. Altjerrel kwenh tjey altjwer-ilek tjerrtj lwereny mapek, inang Jesu renh naketjeh, nakenh-nakenh kwerenh map anetjeh-anngernt.” ");
INSERT INTO amx_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Ratherr nakenh-nakenh mapel-ayeng kwetemeh anek, Antioch town-el. ");
INSERT INTO amx_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Town Antioch-el werlamparenyel-ayeng nakenh-nakenh arrpenh map itja tjerrtj Jew anek. Artwang Jew rrpwetj mer Judea-eng Antioch town-warn petjekarl, inang Jesu nakenh-nakenh anek. Inang artwang map werlamparenyel-ayeng inenh ilek, “Rrwey ngwenh apek werlamparenyel-ayeng nyent-irretjeh ahentj, rang artwang irretjeh-amparr Moses-el ilekarl-arteh. Renh artwang ilekarl-penhant, Altjerr rang renh anetjeng inetjenh, rang ngampekarl iteth anetjenheng kwerel-ayel. Rang apek artwang anetj-kwenh, Altjerr rang renh itja inetjenh.” ");
INSERT INTO amx_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Angketj nhenh awemel Paul Barnabas ratherr inehel-ayeng ilterretjam. Kwereng Antioch-areny werlamparenyelemeh Paul Barnabas renh-atherrenh artwang rrpwetj arrpenh thwen ilek, inang Jerusalem-warn alhetjeh. Inang inenh ilek, kaltj-anthenh-anthenh tjeperr mapel-ayeng Jerusalem werlampareny-henh arntarnt-arentj mapel-ayeng thwen angketj nhenh-penh angkerretjeh. ");
INSERT INTO amx_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Kel werlamparenyel artwang inenh lanthek. Paul map mer Phoenicia-angkwerr mer Samaria-angkwerr thwen anper alhek. Inang nakenh-nakenh arrpenh map inenh ilerl-apetjam, tjerrtj lwereny inang Altjerr kwer-warn twep-irrekarl-penh. Nakenh-nakenh inang angketj nhenh awemel kangkek. ");
INSERT INTO amx_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Paul mapemeh Jerusalem kwerel anetj-alpek, kwereng werlamparenyel kaltj-anthenh-anthenhel arntarnt-arentjel thwen inang inenh kangkemel ngwek. Paul Barnabas ratherr inenh ilek, ratherr mwerr mpwarekarl mer mapel-ayeng, Altjerrel renh-atherrenh twer-ilekarleng wart. ");
INSERT INTO amx_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Werlamparenyel-ayeng artwang rrpwetj Pharisee anek. Inang kemerremel angkek, “Tjerrtj lwereny inarl Jesu renh nakem, inang artwang irretjeh-amparr Moses-henh mpwareng-areng-angkwerr. Kwereng inang mpwareng-areng Moses-kenh ingkerrekeh kangkwerretjeh.” ");
INSERT INTO amx_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Kaltj-anthenh-anthenh tjeperr map angerrepat arntarnt-arentj map thwen inang arraw-irrek, angketj nhenh-penh angkerretjeh. ");
INSERT INTO amx_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Inang kwet anthwerr angkerrek. Kwereng Peter-el kemerremel inenh ilek, “Artwang peltj mapay! Arrantherr kel kaltj, Altjerrel nheng yengenh ngwek, angketj mwerr renh tjerrtj lwereny map kaltj-antherl-apetjeh, inang Jesu renh naketjenheng. ");
INSERT INTO amx_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Altjerr rang tjerrtj ingkerrek-henh iterrentjeh kaltj. Rang Kwerrern Alngaltar renh tjerrtj lwereny map-warn lanthek, rang arrwekel nwerneh-warn-amparr lanthekarl-arteh. Lakenh rang mernelhek, rang tjerrtj lwereny mapeh kangkem, rarl nwerneh kangkekarl-arteh. ");
INSERT INTO amx_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Tjerrtj lwereny map inang Jesu renh nakekarleng, Altjerrel inenh arratj-ilek, anetj inehenh wemel. Lakenh-arteh Altjerrel nwernenh arratj-ilek irrkatj-angkwerr, nwern Jesu renh nakekarleng. ");
INSERT INTO amx_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Iterl-aray, nwern ywarn Moses-henh mpwareng-arengeh arratj kangkwerrek! Angerrepat nwern-henh map Moses-henh mpwareng-arengeh kangkwerretj-kweny anek, angketj rang ineh rnpwer anekarleng wart. Wenheham arrantherr nakenh-nakenh yanh map twernem, angketj kwer kangkwerretjeh? Wenhengarl arrantherr ineh rnpwer mpwarem? Altjerr rang arrehantherr ahang-irrehetj! ");
INSERT INTO amx_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ngkart Jesu-el kwenh nwernenh anetjeng inek kangkentj kwerenhel-ayeng, nwern ngampekarl iteth anetjenheng kwerel-ayeng. Rang kwenh tjerrtj lwereny map thwen anetjeng inek kangkentj kwerenhel-arleng, inang ngampekarl iteth anetjenheng.” Lakenh Peter rang inenh ilek. ");
INSERT INTO amx_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Kwereng Paul Barnabas ratherr inenh ilek, Altjerrel tjerrtj lwereny mapeng ularr twer angerr mpwarekarl kwer atherrel-arleng, mer mapel-ayeng. Angerrepat mapel renh-atherrenh ntertel awetjam. ");
INSERT INTO amx_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Kwereng ratherr kel ntertemeh anetjam. James rang angkek, “Artwang peltj mapay, yengemeh awerrerrang! ");
INSERT INTO amx_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon Peter rang nwernenh ilek, Altjerr rang lwereny arrpenh urrarek, tjerrtj arlaltj kwerenh map anetjeh. Lakenh Altjerr rang tjerrtj lwereny mapeh kangkentj mernelhek. ");
INSERT INTO amx_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Altjerr-henh angketj angenh-angenh map inang ngkwey pip-warn arrernekarl, lakenh kwet anetjenharl. Altjerr-henh angketj nhenh intem pipel-ayeng, ");
INSERT INTO amx_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Yeng Ngkart angkem. Ngkwey David-henh peltj ingkern-penh mapeng king anek, kwereng inang mentj-irrek, atwenh-atwenh mapel inenh anpwekarleng. Kelant yeng petj-alpetjenh, thang artwang nyent David-kenh peltj ingkerneny ngkernetjenh, rang king angerr anetjenh, tjerrtj nwern-henh map arntarnt-aretjenheng, King David-el tjerrtj kwerenh map arntarnt-arekarl-arteh. ");
INSERT INTO amx_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Kwereng tjerrtj lwereny mapemeh tjeng-warn twep-irretjenh, tjerrtj nheng map thang arrwekel urrarekarl. ");
INSERT INTO amx_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ngkweyeng-ntjel thang arrantherrenh nhenh alhelekarl.’ “Lakenh Ngkartel ilek.” ");
INSERT INTO amx_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","James angkek, “Yeng lakenh iterrem, nwern itja tjerrtj lwereny mapeh rnpwer mpwaretjeh, inang Altjerr-warn twep-irretjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Nwern angketj lakenhant pip-warn arrernetjeh ineh, inang itja mern ker thwen arlkwetjeh, altjerr-arrpanteyeh tjenkerr anthekarl-penh. Inang ker atwemeng, inang alhwang-amparr mentj impetjeh thelelhetjeh-amparr. Inang alhwang antjwetj-kwenh anetjeh, ker alhwakert arlkwetj-kwenh anetjeh. Inang anew arrpenh-henhel-ayeng intetjal anetjeh. Angketj rrpwetj nhenh angerr anthwerr anem nwerneh. ");
INSERT INTO amx_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Iterl-aray, ngkweyeng-ntjel tjerrtj Jew map nwern Moses-henh mpwareng-areng kaltj-antherl-apetjart lyeteh-atwetj. Saturday arltel nwern Moses-henh mpwareng-areng read-em-ilerl-apetjart church nwern-henhel-ayeng.” Lakenh James-el inenh ilek. ");
INSERT INTO amx_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Kwereng kaltj-anthenh-anthenh mapel werlampareny-henh arntarnt-arentj mapel thwen werlampareny thwen inang Judas Silas renh-atherrenh urrarek, Paul Barnabas kwer-atherrel-ayeng Antioch town-warn alhetjeh-anngernt. Judas arreny kwerenh arrpenh anek Barsabbas. Judas Silas ratherr-artek artwang twernk anek. ");
INSERT INTO amx_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Inangemeh pip tanthek, pip nhenh inehel-arleng lanthek werlampareny Antioch-warn. Pip kwerel inang angketj lakenh arrernek: “Peltj mapay! Nwern kaltj-anthenh-anthenh tjeperr mapel thwen arntarnt-arentj mapel thwen, nwern kel angketj nhenh pip-warn arrernemel lanthem arrehantherr-warn, nwern arrehantherr kangkentj awelhem. Arrantherr-artek ingkerrek Jesu nakenh-nakenh anem, itja artwang Jew anem. Arrpenh map Antioch town-el anem, arrpenh map mer Syria-el anem, arrpenh map mer Cilicia-el anem. ");
INSERT INTO amx_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","“Nwern awek, artwang rrpwetj werlampareny nhenheng arrehantherr-warn alhekarl, inang arrantherrenh perrpert-ilek. Nwern inenh itja arrehantherr-warn lanthekarl. ");
INSERT INTO amx_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Nwernemeh angkerrekarl-penh, nwern iterrek, urrpey atherr arrpenh arrehantherr-warn lanthetjeh, Barnabas Paul kwer-atherrel-ayeng alhetjeh. Nwern-artek Barnabas Paul kwer-atherr angerr kangkentj anem. ");
INSERT INTO amx_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Arrpenh mapel renh-atherrenh irrernng atwetjeh anek, ratherr angketj Ngkart Jesu Christ-kenh kaltj-anthemeng wart. ");
INSERT INTO amx_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Nwernemeh Judas Silas renh-atherrenh kwer-atherrel-ayeng lanthem, ratherr arrantherrenh iletjenh, angketj nhenh pip nhenhel-ayeng intem, rang arratj kwet anem. ");
INSERT INTO amx_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Kwerrern Alngaltarel nwernenh ilek, nwern itja rnpwer arrehantherr mpwaretjeh. Lakenheng nwern rrpwetj-ingarant nhenh ilem: ");
INSERT INTO amx_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Arrantherr mern ker thwen arlkwetj-kweny anetjeh, nheng altjerr-arrpanteyeh tjenkerr anthekarl-penheh. Arrantherr ker atwemeng, arrantherr alhwang-amparr mentj impang thelelhetjeh-amparr. Arrantherr alhwang antjwetj-kweny anetjeh, ker alhwakert arlkwetj-kwenh anetjeh. Arrantherr anew arrpenh-henhel-ayeng intetjal anetjeh. Arrantherr angketj nhenheh kangkwerremeng, lakenh-artek arrehantherr mwerr anetjeh. Kel angketj lakenh war anem.” ");
INSERT INTO amx_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Kwereng werlamparenyel artwang inenh lanthek, artwang inang Antioch town-warn alhek. Inang town-el irretj-alhemel inang werlampareny arrawelh-ilek, pip renh inang ineh anthek. ");
INSERT INTO amx_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Mapemeh pip kwer read-irrek. Angketj renh awemel werlampareny inang kangkek, rang angketj mwerr anthwerr anemeng. ");
INSERT INTO amx_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas Silas ratherr Altjerr-henh angketj angenh-angenh anek. Kwereng ratherremeh werlampareny angerr tjep-tjep-ilemel twer-ilek. ");
INSERT INTO amx_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Ratherr kweteth Antioch-el anek. Kwereng werlamparenyel renh-atherrenh Jerusalem-warn angkep lanthek, mwerr kwet kwer-atherr inang kangkek. ");
INSERT INTO amx_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","35","Paul Barnabas ratherr Antioch-el antarl-irrek. Mer kwerel ratherr tjerrtj arrpenh mapel thwen Ngkart-henh angketj kaltj-antherl-apetjart. ");
INSERT INTO amx_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Arltang arrpenhelemeh Paul-el Barnabas renh ilek, “Ntwang town nheng mapeh irlpangkem key? Town nheng mapel ilern arrwekel Ngkart-henh angketj kaltj-antherl-apetjam? Mpa, ilern town ineh-warn angkep alperretjeh, nakenh-nakenh inenh angkep arerl-alpetjeh, inang apek mwerr kwet Ngkart Jesu nakerleh!” ");
INSERT INTO amx_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas-emeh ahentj-anek, John Mark renh angetjeh kwer-atherrel-ayeng. ");
INSERT INTO amx_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Paul rang itja ahentj-anek, renh angetjeh. Paul angkek, “Mark rang nheng itja ahentj-anekarl, ilernehel-arleng kwet rrkwapetjeh. Rang nheng ilernenh imperl-alhek mer Pamphylia-el. Lakenh yeng itja ahentj-anem, ilern renh weth angetjeh.” ");
INSERT INTO amx_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Ratherremeh Mark kwereng ilterrek. Ratherr ywarn kwet arratj-ilemel ratherr kel akalkemeh irrerl-anerrek. Barnabas-elemeh John Mark renh ngwerl-alhek. Ratherremeh boat-eh antjerl-alhek, mer Cyprus-warn alhetjeh kwatj alay-angkwerr. ");
INSERT INTO amx_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Paul-elemeh Silas urrarek, kwerel-ayeng rlkwatherr alhetjeh-anngernt. Werlampareny inang kwer-atherr Ngkart renh tjang-pawenhek, Ngkartel renh-atherrenh arntarnt-aretjeh. ");
INSERT INTO amx_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Kwereng ratherr mer Syria-angkwerr anper alherrek, mer Cilicia-angkwerr thwen, werlampareny inenh kaltj-antherl-apemel twer-ilek. ");
INSERT INTO amx_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Paul Silas ratherr Derbe town-angkwerr anper alherrek. Kwereng ratherr Lystra town kwer-warn alhek. Town nhenh kwerel nakenh-nakenh nyent anek, arreny kwerenh Timothy. Timothy-henh mwek nakenh-nakenh anek, rang marl Jew anek. Timothy-henh angey artwang Greece-arenyarl anek, itja artwang Jew. ");
INSERT INTO amx_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Nakenh-nakenh inarl Lystra-el anetjart, town Iconium-el thwen, inang Timothy kwer kangkek. ");
INSERT INTO amx_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Lakenheng Paul-emeh ahentj-anek, Timothy renh angetjeh. Tjerrtj Jew ingkerrek kaltj anek, Timothy-henh angey Greece-areny anek. Lakenheng Paul-el Timothy renh artwang-ilek-amparr Moses-el ilekarl-arteh, tjerrtj Jew map mwekeny-irrehetj kwer. ");
INSERT INTO amx_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Inang town map-warn nthwerl-apetjam, inang nakenh-nakenh mapeh angketj lyeteny ilerl-apetjam, angketj kaltj-anthenh-anthenh mapel Jerusalem-areny werlampareny-henh arntarnt-arentj mapel thwen arrwekel pip-warn arrernekarl, tjerrtj lwereny map-warn lanthetjeh-anngernt, inarl Ngkart Jesu nakemarl map-warn. Inang nakenh-nakenh map iletjam, inang angketj kwer kangkwerretjeh. ");
INSERT INTO amx_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Angketj nhenhel werlampareny map inenh twer-iletjam. Tjerrtj arrpenh map Altjerr-warn twep-irretjam. Lakenh nakenh-nakenh inang aningk-irrek. ");
INSERT INTO amx_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Paul inang ahentj-anek mer Asia-warn alhetjeh, Altjerr-henh angketj kaltj-antherl-apetjeh. Kwerrern Alngaltar rang Paul inenh arnpakek. Lakenheng inang mer Phrygia-angkwerr mer Galatia-angkwerr thwen anper alhek. ");
INSERT INTO amx_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Inang mer Mysia-ek itwek-irrek. Kwereng inang ahentj-anek, mer Bithynia-warn alhetjeh. Ngkart Jesu-henh Kwerrern rang inenh arnpakek. ");
INSERT INTO amx_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Inang mer Mysia-angkwerr anper alhek town Troas-warn, kwatj alay iter-warn. ");
INSERT INTO amx_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Kwenyel Paul-elemeh anengkerr arek. Rang artwang Macedonia-areny arek, renh ngwerleh, “Macedonia-warn petjang, nwerneh tangetjel anetjeh!” ");
INSERT INTO amx_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Kwereng nwern iterl-arek, Altjerrel nwernenh ngwekarleng, tjerrtj Macedonia-areny mapeh angketj mwerr kaltj-antherl-apetjeh. Boat-eh-amparr nwern palenthwek, mer Macedonia-warn alhetjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Town Troas kwerel nwern boat-warn antjek. Nwern mer Samothrace kwer-warn boat-el alhek, mer kwek kwatj alay mpwepel. Mer kwerel nwern intek. Kwereng arltang arrpenhel nwern boat-el alhek town Neapolis-warn; alay iterel town rang artelhek. Kwerel nwern boat-eng anarnpek. ");
INSERT INTO amx_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Nwern ingkemeh alhek town Philippi-warn. Philippi rartek town angerr anek, mer Macedonia-el. Town nhenh kwerel tjerrtj Rome-eng petjekarl map anetjart. Town kwerel nwern arltang rrpwetj anek. ");
INSERT INTO amx_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Saturday arltang angerrel nwern town arreweng keth-warn alhek ulpay kwatj-akert-warn. Nwern iterl-arek, keth nhenhel tjerrtj Jew map inang arraw-irretjenharl apek, Altjerr-warn angketjeh-anngernt. Nwern keth kwerel arrernelhemel marl mapel-ayengemeh angketjam. ");
INSERT INTO amx_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Marl nyent arreny kwerenh Lydia rang anek. Rang Thyatira town-areny anek. Rang mantarr athethek payem-iletjart, kwereng rang mer arrpenh-warnemeh sell-em-iletjeh angetjart. Lydia rang Altjerreh kangkwerremel naketjart. Ngkartelemeh iterrentj kwerenh altjwer-ilek, rang Paul-henh angketj alhengk-aretjenheng. Rang Ngkart Jesu nakekemeh. ");
INSERT INTO amx_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Kwereng Paul-elemeh renh kwatj-warn irrpelh-ilemel baptise-em-ilek, peltj kwerenh map inenh-arlk. Kwereng Lydia-el nwernenh ayakek, “Arrantherr itja alhetjeh. Tjengel-ayel petjewarrang, warl tjengenhelemeh intetjeh.” Nwern kel kwerel-ayel alhek, kwerel-ayel anetjeh-amparr. ");
INSERT INTO amx_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Arltang arrpenhelemeh nwern keth kwer-warn weth alhetjam, nheng tjerrtj Jew map arraw-irretjartarl kwer-warn, Altjerr-warn angketjeh-anngernt. Nwern marl awenk nyentemeh aretj-alhek, rang kwerrern anetj-akert anek. Kwerrern anetj rang renh iletjart, nthakenh-nthakenh anetjenh tjerrtj arrpenh kwer. Tjerrtj inang ahentj-anek, kwereng kaltj-irretjeh, nthakenh-nthakenharl apek anetjenharl. Inang maney kwer anthetjart, nhenh-penh kaltj-irretjeh. Marl awenk rang rrkwapenh-apenh war anek, lakenh rang maney angerr mpwaretjart twernk kwerenh mapeh. ");
INSERT INTO amx_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Marl awenk rang Paul nwerneh ingkerneng alwernemel untarel ilerl-apetjam, “Artwang nhenh map-arteh Altjerr angerr-henh rrkwapenh-apenh anem! Inang arrantherrenh ilem, nthakenh Altjerrel arrantherrenh anetjeng inetjenharl, arrantherr kwerel-ayeng ngampekarl iteth anetjenh!” ");
INSERT INTO amx_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Marl awenk rang nwernenh kwet alwernerl-apetjam anharr-angkwerrarl, arltang rrpwetjeh-atwetj. Rang angketj nyent kwet arlkemel ilerl-apetjam. Paul rang ahentj-kweny-irrek, renh awetjeh. Paul-elemeh alngarelhemel kwerrern anetj ilek, “Thang ngwenh ilem Jesu Christ-henh arreny anewemel, marl kwereng arratemel alhang!” Kwereng kwerrern anetj marl kwereng arratek. ");
INSERT INTO amx_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Marl awenk-henh twernk mapelemeh renh arek, rang mwerremeh irrekarl. Nthakenhameh maney ineh rang mpwaretjenh? Kwereng inang Paul Silas kwer-atherr ahang-irrek. Inang renh-atherrenh antwerrkemel town mpwep-warn angek, keth nyent-warn. ");
INSERT INTO amx_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Kwereng inang court-ek-artwey map ilek, “Artwang nhenh atherr-artek Jew anem. Ratherr tjerrtj ingkerrek rrwampey-ilem! ");
INSERT INTO amx_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Ratherr nwernenh ilem, nwern mpwareng-areng inehenheh kangkwerretjeh kwel. Nwern ahentj-kweny anem, inehenh mpwareng-arengeh kangkwerretjeh. Nwern Rome-areny anem! Nwern mpwareng-areng arlaltj-akert anem, Rome-areny mpwareng-areng-akert.” ");
INSERT INTO amx_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Tjerrtj arrpenh map arraw-irrek, Paul renh-atherrenh antwerrketjeh. Kwereng court-ek-artwey mapel rrkwentj map ilek, Paul Silas kwer-atherreng mantarr kap-rlwetjeh, renh-atherrenh whip-el atwetjenheng. ");
INSERT INTO amx_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Inang renh-atherrenh nyant atwek, kwereng inang renh-atherrenh tjayel-warnemeh kwernek. Inang tjayeleh-artwey renh ilek, renh-atherrenh mantjel arntarnt-aretjeh. ");
INSERT INTO amx_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Lakenheng tjayeleh-artweyel renh-atherrenh tjayel kwen anthwerr-warn kwernek, rang ingkang kwer-atherr-henh arnang angerr-arleh chain-el ayernek, ratherr alwerrehetjeng. ");
INSERT INTO amx_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Kwereng kweny mpwepel Paul Silas ratherr Altjerr kwer-warn-atheh angketjam, arrkenel alyelhetjam kwer. Tjayel-areny arrpenh mapel renh-atherrenh awetjam. ");
INSERT INTO amx_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Kwereng ahelh kwen-arlk rang angerr anthwerr arrewek, tjayel kwenel. Kwereng tjayel-henh door ingkerrekemeh altjwer-irrek, chain map ingkerrek ltwakelhek. Chain inang artwang tjayel-areny mapeng rlwelhek. ");
INSERT INTO amx_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Tjayeleh-artwey rang karr-irrek, rang arek tjayel-henh door ingkerrek altjweremeh anerleh. Rang iterl-arek, tjayel-areny ingkerrek alwerrekarleh-athen. Lakenheng rang knife arlpentj inemel kwewaleny irrernng atwelhetjeh anek. Rang ater-irrek, twernk Rome-arenyel renh irrernng atwehetjeng, tjayel-areny map alwerrekarleh-athen. ");
INSERT INTO amx_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Paul-elemeh renh arrantj-akemel ilek, “Nwern-arteh nhenh ngwerrm anem! Irrernng atwelhetjal anay!” ");
INSERT INTO amx_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Tjayeleh-artwey rang rrkwapenh-apenh kwerenh inenh pawenhek, “Rwang alep map angetjewarrang!” Rang irrpenhek tjayel-warn kwen, Paul Silas kwer-atherreng ularr kelkertel-ayeng arrernelhek, ater arrewemel. ");
INSERT INTO amx_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Rang kemerremel renh-atherrenh keth-warn arratelh-ilek. Kwereng rang renh-atherrenh pawenhek, “Twernk tjeyenh atherray! Nthakenham yeng mernelhetjeh Altjerreng ularr, Altjerr rang yengenh inetjeh, yeng ngampekarl iteth kwerel-ayeng anetjenheng?” ");
INSERT INTO amx_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Ratherr renh ilek, “Ngkart Jesu renh nakay! Kwereng Altjerrel ngwenh inetjenh, kwerel-ayeng iteth ngampekarl anetjenh, peltj ngkwengenh map-arlk, rrkwapenh-apenh ngkwengenh map thwen.” ");
INSERT INTO amx_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Kwereng Paul ratherr renh Ngkart-henh angketj kaltj-anthek, tjerrtj arrpenh map-arlk inenh thwen, inarl warl kwerenhel anetjam. ");
INSERT INTO amx_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Kweny nyentel kwet, tjayeleh-artweyel tjwen kwer-atherr-henh kwatjel lhewek. Kwereng Paul ratherr renh peltj kwerenh map-arlk rrkwapenh-apenh kwerenh map thwen kwatj-warn irrpelh-ilemel baptise-em-ilek. ");
INSERT INTO amx_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Tjayeleh-artwey rang peltj kwerenh map-arlk thwen inang pwert arrken awelhemel anek, inang nakenh-nakenh irrekarl-penh. Kwereng tjayeleh-artweyel renh-atherrenh warl kwerenh-warnemeh tjey-angek. Rang kwer-atherr mernemeh arlkwetjeh anthek. ");
INSERT INTO amx_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Kweny-rtwehemeh court-ek-artwey inang rrkwentj rrpwetj lanthek tjayel-warn, tjayeleh-artwey renh iletjeh, “Artwang nheng atherr kel arratelh-ilang!” ");
INSERT INTO amx_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Tjayeleh-artwey rang Paul renh ilek, “Court-ek-artwey inang angketj lanthek, Silas mpwelenh arratelh-iletjeh. Mpwelanthemeh kwenp alherrang ater-irretjal!” ");
INSERT INTO amx_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Paul-el rrkwentj inenh ilek, “Inang ilernenh whip-elemeh pelkel atwek tjerrtj mapeng anngetherr! Inang ilernenh court-warn-amparr angemer! Inang ilernenh tjayel-warn kwernek! Inang ilernenh itja arrwekel pawenhek, arratj apek ilern ilelhetjeh. Ilern kwenh Rome-areny pip-akert anem. Angketj pip atherrel-ayeng intem, ilern-kenh twernk kwenh Rome-areny Caesar-arl! Inang itja arratj mpwarek! Lyetemeh inang ahentj-anem, ilernenh anyenng-anyenngel arratelh-iletjeh kwel. Inenh iletjeh alpang, inang petjetjeh, alngetherr ilernenh tjayeleng arratelh-iletjeh!” ");
INSERT INTO amx_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Rrkwentj inang twernk inehenh iletj-alpek. Twernk inang awek, Paul Silas ratherr pip anyenek angketj-akert, nheng Rome-areny Caesar-arl twernk kwer-atherr-henh anek. Inang ater-irrek, inang anketj-warn irrehetjengemeh. ");
INSERT INTO amx_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Inang tjayel-warn alhemel renh-atherrenh angketj mwerrelemeh iletj-alpek. Kwereng inang renh-atherrenh tjayeleng arratelh-ilek. Inang renh-atherrenh ilek, mer arrpenh-warnemeh alhetjeh. ");
INSERT INTO amx_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Paul Silas ratherr tjayeleng arratemel-arteh ratherr marl Lydia-henh warl-warn-amparr alherrek, nakenh-nakenh map warl kwerel aretjeh-amparr. Ratherremeh inenh ilek, inang kwet Jesu renh naketjeh. Kwereng ratherr kel alethemeh irrek. ");
INSERT INTO amx_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Inang town Amphipolis Apollonia thweneng anper kwet alhek, Thessalonica town-warn inang alhek. Town nhenhel tjerrtj Jew map-henh church artelhek. ");
INSERT INTO amx_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Paul-emeh Saturday arltang angerrel church-warn alhek. Rartek kweteth church-warn alhetjart arltang angerrel. Saturday arltang rrpwetjelemeh rang Altjerr-henh angketj pipel-ayeng tjerrtj map kaltj-anthek. ");
INSERT INTO amx_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Rang inenh keth-ilemel kaltj-anthek angketj pipel-ayeng intek Christ kwer-akert. Angketj pip nhenhel-ayeng intek, Christ rang irlkert angerr awelhemel ilwetjenh. Kwereng Christ rang irrernngeng iteth kemerretj-alpetjenh. Rang inenh ilek, “Jesu nhenh kwer-penh thang kaltj-anthem, rang kwenh Christ rang anem, Altjerrel ngkwey alhelekarl.” Lakenh Paul-el ineh Altjerr-henh angketj keth-ilemel kaltj-anthek. ");
INSERT INTO amx_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Tjerrtj Jew arrpenh mapel angketj kwerenh nakek. Artwang Greek angkenh-angkenh irlpareth mapel thwen nakek. Marl angerrepat rrpwetjel thwen. Inang Paul Silas kwer-atherr-warn nyent-irrek. ");
INSERT INTO amx_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Kwereng tjerrtj Jew arrpenh mapemeh Paul kwer-atherr ahentj-kweny-irrek. Inang artwang anetj rrpwetj ngwek, tjerrtj map rrwampey-iletjeh. Artwang anetj map inang tjerrtj ingkerrek arraw-ilemel rrwampey-ilerl-apek. Inang Jason-henh warl-warn alhek, Paul Silas renh-atherrenh antwerrketjeh. Inang ahentj-anek, Paul Silas thwen angetjetjeh keth-warn, tjerrtj maparl karelhetjam-warn. ");
INSERT INTO amx_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Inang Jason-henh warl ywarerl-alpek Paul Silas kwer-atherr, renh-atherrenh antwerrkerl-alpetjeh kwel. Jason renhant inang antwerrkek, nakenh-nakenh rrpwetj arrpenh map thwen. Inang inenh town-ek-artwey map-warn tjarr-angek. Inang arrantj-akemel ilek, “Paul Silas thwen tjerrtj ingkerrek mer arrpenh mapel rrwampey-ilerl-apek! Kwereng ratherr nhenh-warnemeh petj-alherrek! ");
INSERT INTO amx_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Jason nhenhel kwenh renh-atherrenh ngwek, mer kwerenhel anetjeh. Inang ingkerrekel nwernenh ilek, Jesu king angerr kwel anem. Lakenh inang twernk nwern-henh Caesar-ek irrpelth-irrek!” Lakenh inang arrantj-akemel ilek. ");
INSERT INTO amx_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Town-ek-artwey mapel tjerrtj ingkerrekel thwen angketj nhenh awemel inang rrwampey-irremel arrantj-akek. ");
INSERT INTO amx_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Town-ek-artwey inang Jason nakenh-nakenh arrpenh inenh thwen fine anthek, inang maney anthemel alhetjenheng. Kel inang fine payem-ilek, kwereng town-ek-artwey mapel inenh mer-warn angkep lanthek. ");
INSERT INTO amx_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Kweny nyent kwerel nakenh-nakenh mapel Paul Silas renh-atherrenh Berea town-warn lanthek. Ratherr Berea town-ek irretj-alhemel ratherr tjerrtj Jew map-henh church-warn alherrek. ");
INSERT INTO amx_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Berea town-areny inang arrkenel awek Paul-henh angketj Ngkart Jesu-akert. Inang irlpareth anek. Thessalonica town-areny map inang itja irlpareth anek. Berea-areny inang ahentj-anek, arratjekarl alhengk-aretjeh, Altjerr-henh angketj pipel-ayeng read-em-ilerleh. Paul-el apek inenh arratj kaltj-antherleh. ");
INSERT INTO amx_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Jew mapel angketj nakek, Paul-elarl inenh kaltj-antherl-apetjam. Marl Greek angkenh-angkenh rrpwetj inarl angerrepat anek inang nakek, artwang Greek angkenh-angkenh mapel thwen. Inang ingkerrek nakenh-nakenhemeh irrek. ");
INSERT INTO amx_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Tjerrtj Jew Thessalonica-areny mapel angketj awek, Paul-el mer Berea-el Altjerr-henh angketj kaltj-antherleh. Inang Berea-warn alhek, tjerrtj Berea-areny map rrwampey-iletjeh. Inang tjerrtj map ilek, Paul-elarl rrtjwerremel war kaltj-antherleh. Inang tjerrtj inenh Paul-ek ahentj-kweny-irretjeh mpwarek. ");
INSERT INTO amx_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Lakenheng nakenh-nakenh mapel Paul renh parrp lanthek kwatj alayeng iter-warn. Silas Timothy ratherr town Berea-el antarl-irrek. ");
INSERT INTO amx_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Artwang rrpwetj Paul-el-ayel rlkwatherr alhek. Kwatj alay iterel inang boat-el antjerl-alhek, kwereng inang boat-el alhek town Athens-warn. Town Athens-el irretj-alhemel inang Paul renh imperl-alhek. Paul rang inenh ilek, “Silas Timothy renh-atherrenh parrp angkep lanthetj-alpetjeh, ratherr petj-alherretjeh tjeng-warn. Yeng kwer-atherr mer nhenhel karelhemarleng.” ");
INSERT INTO amx_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paul rang Silas Timothy kwer-atherr Athens town-el karelhetjam. Rang town-angkwerr war nthwerl-apemel arerl-apetjam, rang arnang-penh pwert-penh map anthwerr arerl-apetjam, iltjel mpwarekarl. Tjerrtj inang arnang ineheng ularr kelkertel-ayeng arrernelhemel naketjart, altjerr kwel anemarleng. Paul rang rrwampey anthwerr awelhek. ");
INSERT INTO amx_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Lakenheng rang church-warn alhetjart, tjerrtj Jew mapel-ayeng angkerretjeh, Greece-areny irlpareth mapel-ayeng thwen, inarl Altjerr renh arratj iterl-arek. Rang kweteth mer-areny mapel-ayeng angkerretjart town mpwep kwerel. Keth nyentel shop angerretj anek, kwer-warn inarl arraw-irretjart angkerretjeh-arlk. ");
INSERT INTO amx_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Rang kwerel anetjam-rlwer, Paul rang inangkal angerr mapel-ayeng anek, inang angketj arrpenh lyeteny-penh angkerretjam, wenh-wenheh kaltj-irretjeh. Inang tjerrtj map nyent anewek Epicurea-areny map, arrpenh map inang anewek Stoic-areny map. Inang Paul pawenhek, “Ngwenham ntwang nakem?” Inang Paul-henh angketj renh alhengk-aretj-kweny anek, Paul-el inenh angketj mwerr Jesu Christ-akert kaltj-antherleh. Rang inenh ilek, Jesu rang irrernngeng kemerrekarl-penh. Artwang rrpwetj lakenh angkek, “Artwang nhenh-arteh ahert! Nthakenham rang nwernenh ilem?” Artwang rrpwetj arrpenh kwenh lakenh kwereng angkek, “Rartek altjerr arrpenh lwereny map-kenh-penh kwel angkem.” ");
INSERT INTO amx_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Artwang nhenh inang Paul renh Areopagus council-warn angek. Council inang kel arraw-irrek-anem. Council-areny inang renh pawenhek, “Ntwang nwernenh ilang, angketj nheng ntwarl tjerrtj map kaltj-antherl-apetjam-penh. ");
INSERT INTO amx_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Nwern kwenh lyet anwerlkekan, angketj ngkwengenh renh lyetant awemel. Ntwang angketj ngkwengenh nwerneh keth-ilang.” ");
INSERT INTO amx_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Tjerrtj Athens-areny map tjerrtj inang Athens-warn yatjarr petjekarl map thwen inartek ahentj-anetjart angketj lyeteny inenh awetjeh, angketj kwerengemeh kweteth angkerremel. ");
INSERT INTO amx_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Paul-emeh kemerremel Council inenh rang anngetherr ilek, “Artwang Athens-areny mapay! Thang arek, arrantherr altjerr map anthwerr nakerleh! ");
INSERT INTO amx_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Town arrehantherr-henhel yeng nthwerl-apetjam, altjerr-arrpantey map thang arerl-apetjam, arrantherrarl inenh pwert-penh-arlk mpwarekarl. Pwert arrpenhel-ayeng thang arek, arrantherr angketj kwer-arleh arrernekarl. Pwert rang irnem angketj lakenh-akert, ‘Nwern Altjerr renh nakem kwet, kwerarl nwern kaltj anetj-kwenh.’ Altjerr renharl arrantherr nakem, kwer arrantherr akwen kwet anem, yeng ahentj-anem arrantherrenh kaltj-anthetjeh Altjerr nhenh kwer-akert. ");
INSERT INTO amx_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Altjerr nhenh rang alker ahelh thwen arrmernekarl, tjerrtj ker-arlk thwen rang inenh ingkerrek arrmernek. Rang Ngkart ingkerrekeh anem, alkerek-artwey ahelhek-artwey thwen. Rang itja church-el anem, church nheng tjerrtjelarl artekarl kwerel, itja kwenh. ");
INSERT INTO amx_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Tjerrtjel ywarn mpwarem wenh-wenh kwer, kwer-akertel renh naketjeh. Rang tjerrtj map iteth anthemel anyenem, ineh mern-arlk anthemel. ");
INSERT INTO amx_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ngkwey rang artwang nyent arrmernek. Artwang nyenteng tjerrtj aningk irrekemeh, ahelh ntjaperel anetjek angketj arrpenhek-arrpenh inehenh-akert. Rang arrwekel kwet iterrek, rang tjerrtj map nyentam-nyenteh mer inehenh anthetjeh-anngernt. Rang kaltj anek, arrpenh map ywerretjenharl, arrpenh map inang mer inehenhel ingkernemeh anetjenh. ");
INSERT INTO amx_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Altjerr rang lakenh mpwarek, tjerrtj inang kwer palenthwetjeh, renh apek iterl-aretjenheng. Altjerr rang nwerneheng ntwarr-kwenh war anem. ");
INSERT INTO amx_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Rang nwernenh twer-ilem, arntarnt-arem, iteth anyenemel. Ahelh nhenhel nwern kwerel-ayeng kweteth anerl-anem. Artwang inangkal nyentel arrantherrenh ilek, ‘Nwern ingkerrek ler kwerenh anem, rang Angey anganentj nwern-henh anem.’ ");
INSERT INTO amx_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Nwern Altjerr-henh ler wart anem, nwern alhwengkeltj iterl-aretjal anetjeh. Altjerr Angey rang itja altjerr-arrpantey nheng map-arteh anem, inarl pwerteng-arlk mpwarekarl, gold-eng apek silver-eng apek. Rang itja ineh-arteh anem. Rant kwenh Altjerr iteth anem. ");
INSERT INTO amx_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Tjerrtj mapel ngkweyeng-ntjel altjerr-arrpantey pwerteng-arlk mpwaremel naketjart. Altjerrel inenh impek, inang akwen wart anekarleng. Lyeteng rang tjerrtj map ilem, itja weth lakenh mpwaretjehemeh, inarl ngkweyeng-ntjel mpwaretjart-arteh. Altjerrel lyet ilem, tjerrtj ingkerrek ahelh ntjaperel inang kel anetjeng kwer-warnemeh twep-irretjeh. ");
INSERT INTO amx_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Altjerr rang kaltj, arltang kwerel rang tjerrtj ingkerrek judge-em-ilemel pawenhetjenh. Rang kel artwang nyent ngkernekarl, artwang rang arltang kwerel tjerrtj ingkerrek pawenhetjeh-anngernt. Nthakenh nwern kaltj anetjek, angketj nhenh arratj anemeng? Rang artwang ngkernekarl nheng irrernngeng kemelh-ilekarl. Lakenheng nwern kaltj anetjenheng, angketj nhenh arratj anem.” Lakenh Paul-el inenh kaltj-anthetjam. ");
INSERT INTO amx_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Inang renh awemel Altjerrel kwel artwang nyent irrernngeng kemelh-ilekarl, arrpenh map inang atherrek. Arrpenh mapel Paul renh ilek, “Nwern ahentj, ntwang angketj nhenh-penh weth kaltj-anthetjeh. Arltang arrpenhelant.” ");
INSERT INTO amx_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Kwereng Paul rang Council-eng alhekemeh. ");
INSERT INTO amx_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Artwang rrpwetjelemeh angketj kwerenh nakek, kwereng inang Paul-el-ayeng nyent-irrek. Artwang nyent anek Dionysius, rang Council-areny anek. Marl nyent arreny kwerenh Damaris rang angketj kwerenh nakek, tjerrtj rrpwetj arrpenh mapel thwen. ");
INSERT INTO amx_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Kwereng Paul rang Athens town renh imperl-alhemel town Corinth-warn-atheh alhek. Mer Corinth kwerelemeh rang anetj-alpek. ");
INSERT INTO amx_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Rang artwang Jew-emeh aretj-alhek, arreny kwerenh Aquila. Aquila rartek mer Pontus-el mangkekarl. Aquila rang ngwerreh-lkwer waremeh Corinth-warn petjekarl, anew kwerenh-akert arreny Priscilla-akert. Ratherr arrwekel mer Italy-el anetjart, Rome town-el. Twernk angerr Claudius-elemeh tjerrtj Jew map mer Rome-eng anpwekarl. Lakenheng Aquila ratherr Corinth-warn arrwekel petj-alperrek. Paul rang Aquila kwer-atherr-henh warl-warn alhek. ");
INSERT INTO amx_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Paul rang awek, Aquila ratherr tent mpwarenh-arenh anerleh. Paul rang tent mpwarenh-arenh ratherr-arteh anetjart. Lakenh rang kwer-atherrel-ayeng kwet-irretj-alhek. Paul rang kwer-atherrel-ayeng tent mpwaretjart. ");
INSERT INTO amx_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Saturday arltang angerr-el rang Jew map-kenh church-warn irrpetjart, tjerrtj Jew mapel-ayeng Greece-areny mapel-ayeng thwen angkerretjeh. ");
INSERT INTO amx_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Arltang arrpenhel Silas Timothy ratherremeh mer Macedonia-eng petjek, Paul-el-ayeng yatjarr anetjeh. Kwereng Paul rang rrkwapentj kwerenh impek. Rang kel kweteth tjerrtj Jew map kaltj-antherl-anek. Rang inenh angketj Jesu-akert ilerl-apetjam, Jesu rang Christ anemeng, nheng Altjerrelarl ngkwey alhelekarl. ");
INSERT INTO amx_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Arltang arrpenhel tjerrtj Jew inang Paul-ek ngkwantj-irrek, renh arrkentj-ilemel. Lakenheng Paul-el nmwernt renh mantarr kwerenheng lernemel inenh ilek, “Altjerrel arrantherrenh kelant atwetjenh! Arrantherr merrentj anem, yeng itja merrentj anem. Lyeteng thang kel tjerrtj Greek angkenh-angkenh mapehemeh angketj mwerr renh kaltj-antherl-apetjeh.” ");
INSERT INTO amx_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Paul rang inenh imperl-alhemel church kwereng arratemel alhek. Rang warl arrpenh-warn alhek, Titius Justus-kenh warl-warn. Artwang Titius Justus Altjerr kwer kangkwerremel naketjart. Warl rang church-eng angath artelhek. Warl kwerel-anem Paul rang anetjam. ");
INSERT INTO amx_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Artwang arreny Crispus rarl church-eh-artwey anekarl, rang peltj kwerenh mapel thwen rrkwapenh-apenh kwerenh mapel thwen Ngkart renh nakek. Corinth-areny arrpenh mapel Paul-henh angketj renh awek, inang thwen Ngkart renh nakekarl. Kwereng Paul rang inenh kwatj-warn irrpelh-ilemel baptise-em-ilek. ");
INSERT INTO amx_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Kweny arrpenhel Paul-el anengkerremeh arek. Rang awek, Ngkartel renh ilerleh, “Paul-ay! Ntwang itja ater-irretjeh! Kwenpel kwet tjerrtj map kaltj-anthay! Itja ntwang parrk-irretjeh! ");
INSERT INTO amx_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Yeng ngkwengel-ayeng kwet anetjenh. Tjerrtjel ngwenh itja atwetjenh. Tjerrtj tjengenh map town nhenhel anem.” Lakenh Ngkartel renh ilek anengkerrel-ayeng. ");
INSERT INTO amx_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Paul rang 18 months-eh-atwetj town Corinth kwerel anetjart. Rang tjerrtj map kaltj-anthetjartemeh Altjerr-henh angketj. ");
INSERT INTO amx_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Artwang arreny Gallio twernk angerr anetjart mer Achaia-el. Arltang arrpenhel tjerrtj Jew angerrepat mapelemeh nyent-irremel Paul renh antwerrkewarrek. Inang renh court-warn angerrerrek. ");
INSERT INTO amx_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Inang Gallio ilek, “Artwang nhenhel-artek tjerrtj inenh pal war kaltj-anthem! Rang inenh kaltj-anthem, inang Moses-henh mpwareng-areng mentj impetjeh. Rang inenh kaltj-anthem, inang angketj arrpenh-angkwerr Altjerreng ularr kelkertel-ayeng arrernelhemel renh naketjeh.” ");
INSERT INTO amx_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Paul rang angketjeh irrek, Gallio rang angkek, “Tjerrtj Jew mapay, nthakenh artwang nhenh anetj mernelhek? Arrantherr yengenh itja ilek. Lakenheng yeng arrehantherr kangkwerretj-kweny anetjeh. ");
INSERT INTO amx_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Arrantherr arrwekeleny arrehantherr-henh map-henh arreny mapeng arrngel ilterrem, angketj arrehantherr-henheng arrngel thwen. Arrantherrarrp angketj nhenh arratj-ilerrerrang. Tjeng itja anem, angketj nhenh-penh angketjeh. Yengan mentj imperrerrang!” ");
INSERT INTO amx_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Gallio rang tjerrtj inenh court-eng anpwek. ");
INSERT INTO amx_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Tjerrtj mer-areny inang artwang Sosthenes renh antwerrkemel ineheng anngetherr atwek. Sosthenes rartek church-eh-artwey anek. Gallio rang inenh kwenpel mentj aretjam. ");
INSERT INTO amx_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Paul rang kwet nakenh-nakenh mapel-ayeng anetjamemeh mer Corinth-el. Kwereng rang Corinth-areny map imperl-alhek. Rang ahentj-anek Syria-warn alhetjeh, kwatj alay-angkwerr. Priscilla Aquila thwen kwerel-ayeng pwert alhek. Inang town Cenchrea-el irretj-alhemel Paul rang kapert kwerl kwerenh akelhek, Jew map-kenh mpwareng-areng-angkwerr. Kwereng inang boat-warn antjek, mer Syria-warn kwatj alay-angkwerr alhetjeh. ");
INSERT INTO amx_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Kwereng inang Ephesus town-warn alhek boat-el. Town kwerel inang boat-eng anarnpek. Priscilla Aquila thwen ratherr Ephesus kwerel kwetemeh anetj-alpek. Paul rang church-warn irrpek, kwereng rang tjerrtj Jew mapel-ayeng angkerrek. ");
INSERT INTO amx_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Tjerrtj inang renh ayakek, inehel-arleng kwek war anetjeh-amparr. Rang itja ahentj-anek. ");
INSERT INTO amx_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Alhetjeh-anngerntel rang inenh alhelerl-alhek, “Yeng arrehantherr-warn angkep petj-alpetjenh, Altjerr rang ahentj-anemeng wart.” Rang boat-warn antjemel alhekemeh mer Ephesus-eng. ");
INSERT INTO amx_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Rang kwatj alay-angkwerr boat-elemeh alhek town Caesarea-warn. Kwereng rang boat-eng anarnpek Caesarea-el. Kwereng rang Jerusalem-warn-amparr alhek, werlampareny inehel-arleng yatjarr anerl-alpetjeh. Kwereng rang town Antioch-warn angkep alpek. ");
INSERT INTO amx_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Town Antioch-el rang kwetemeh anetjam. Kwereng rang mer Galatia-warn mer Phrygia-warn thwen alhek, nakenh-nakenh map twer-ilerl-apetjeh. ");
INSERT INTO amx_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Apollos rang artwang Jew anek. Rartek town Alexandria kwerel mangkekarl. Rang artwang inangkal anek, Altjerr-henh angketjeh kaltj anthwerr anek. Rang Ephesus town-warn alhek. ");
INSERT INTO amx_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Tjerrtj arrpenhel renh Ngkart-henh angketj arrwekel kaltj-anthek. Rang twer anthwerr angketjart. Rang arrpenh map angketj Jesu-akert kaltj-antherl-apetjart. Arratj anthwerr rang kaltj-anthetjart. Rang itja kaltj anek, Jesu-henh arrenyel-arleng tjerrtj inenh kwatj-warn irrpelh-ilemel baptise-em-iletjeh. Rang angketj John Kwatjeh Irrpelh-ilenh-ilenh-kenhekant kaltj anek. ");
INSERT INTO amx_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Artwang Apollos nhenh rang church-el tjerrtj map anew-anewel kaltj-anthek. Priscilla-el Aquila thwenel renh awekarl-penh, ratherr renh mer kwer-atherr-henh-warn anginek, ratherremeh renh Altjerr-kenh angketj weth keth-ilemel kaltj-anthek. ");
INSERT INTO amx_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apollos rang ahentj-anek, anper alhetjeh mer Achaia-angkwerr. Kel nakenh-nakenh mapel nhenh awemel kwer kangkek. Inang pip kwer tanthek, rang kwerel-ayeng angetjeh Achaia-warn. Pip kwerel-ayeng angketj inehenh intek. Inang nakenh-nakenh Achaia-areny map pawenhek, nakenh-nakenh inang Apollos renh kangkemel inetjek. Apollos rang mer Achaia-el irretj-alhemel nakenh-nakenh mer kwer-areny mapel renh ngwemel arntarnt-arek. Rang nakenh-nakenh inenh twer-ilemel kaltj-anthek. Inang kwenh Ngkart Jesu nakek, Altjerr ineh kangkentj mernelhekarleng wart. ");
INSERT INTO amx_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Apollos rang tjerrtj Jew mapel-ayeng ilterrek, tjerrtj arrpenh mapeng anngetherr. Rang inenh Altjerr-henh angketj keth-ilemel ilek, Jesu rang kwenh Christ anekarl, Altjerrel ngkwey alhelekarl. Rang inenh ntertelh-ilek. ");
INSERT INTO amx_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Apollos rang Corinth town-el anetjamarleng, Paul rang Ephesus town kwer-warn-atheh tjey arrpenh irntang-angkwerr anper alhek. Rang Ephesus-el irretj-alhek, kwereng rang nakenh-nakenh rrpwetj aretj-alhek. ");
INSERT INTO amx_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Paul rang inenh pawenhek, “Arrantherr nheng Jesu renh nakekarleng, Kwerrern Alngaltar rang arrehantherr-warn irrpek key?” Inang renh ilek, “Itjam, nwern Kwerrern Alngaltar kwer itjam kaltj. Wenham Kwerrern Alngaltar rang?” ");
INSERT INTO amx_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Paul-el inenh weth pawenhek, “Ngwenhelam arrantherrenh kwatj-warn irrpelh-ilemel baptise-em-ilek?” Inang renh ilek, “John Kwatjeh Irrpelh-ilenh-ilenh kwerenh kwertengerl mapel inang kwenh!” ");
INSERT INTO amx_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Paul-elemeh inenh ilek, “John-el kwenh tjerrtj map ilek, inang anetjeng Altjerr-warn twep-irretj-alpetjeh. Rang inenh kwatj-warn irrpelh-ilemel baptise-em-ilek. Rang inenh ilek, ‘Arrantherr kelant artwang renh naketjeh-anngernt, rarl tjengeng ingkern petjetjenharl.’ John rang inenh ilek, Jesu renh naketjeh.” ");
INSERT INTO amx_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Kwereng Paul rang nakenh-nakenh inenh Jesu-henh arrenyelemeh ilemel kwatj-warn irrpelh-ilemel baptise-em-ilek. ");
INSERT INTO amx_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Kwereng rang iltjang kwerenh kapert-warn arrernek nyentam-nyenteh. Kwerrern Alngaltar rang ineh-warn irrpekemeh. Inang angketj arrpenh anthwerr angketjam. Kwereng inang Altjerr-henh angketjemeh iletjam, Kwerrern Alngaltarel-arleng. ");
INSERT INTO amx_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Inang artwang 12 pel anek. ");
INSERT INTO amx_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Town Ephesus kwerelemeh Paul rang tjerrtj Jew map inenh kaltj-anthetjart church inehenhel months rrpwetjeh-atwetj. Rang inenh anew-anewel ilek, Altjerr rang tjerrtj kwerenh map-warn petjekarl, rang ineh Ngkart angerr anemeng. ");
INSERT INTO amx_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Tjerrtj arrpenh map inang marnt kwetarl anek, inang ahentj-kweny-irrek angketj kwerenh naketjeh. Inang angketj Jesu-henh arrampewetjam tjerrtj mapeng anngetherr. Lakenheng Paul rang ineheng ampakelhek. Rang Jesu nakenh-nakenh map-akert alhek kwerl nyent-warn, artwang Tyrannus-el kaltj-anthetjart-warn. Paul rang kweteth kwerel tjerrtj map kaltj-anthetjart. ");
INSERT INTO amx_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Lakenh rang kwerl kwerel year atherreh-atwetj tjerrtj map kaltj-anthetjart. Kel tjerrtj ingkerrekelemeh Ngkart-henh angketj awek, mer Asia kwerel, tjerrtj Jew mapel tjerrtj angketj Greek angkenh-angkenh mapel thwen. ");
INSERT INTO amx_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Altjerrelemeh Paul renh twer-ilek, rang twer angerr-akertel mpwaretjek. ");
INSERT INTO amx_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Mantarr Paul irrpetjartarl-penh, arrpenhel mantarr kwer-akertel tjerrtj arrpenh irlkert mapeh ampek-arrernerl-apetjart. Tjerrtj irlkert inang mwerr-irremel kemerretjart. Tjerrtj kwerrern anetj-akert map, kwerrern anetj inang ineheng arratemel alhetjart. ");
INSERT INTO amx_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Tjerrtj Jew rrpwetj arrpenh mer arrpenhek-arrpenhel nthwerl-apetjam, kwerrern anetj map tjerrtjeng anpwetjeh. Inang iterrek, kwerrern anetj inenh anpwetjeh Jesu-henh arrenyel-ayel. Inang kwerrern anetj inenh lakenh ilek, “Paul rang angketj Jesu-akert kaltj-anthem, thang arrantherrenh ilem, Jesu nheng-henh arrenyel-arleng arratetjeh!” ");
INSERT INTO amx_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Artwang nyent arreny Sceva anek. Rang priest twernk angerr anek Jew mapek. Sceva kwerenh ler 7 pel anek. Arltang arrpenhel artwang 7 nhenh inang iterrek, kwerrern anetj inenh anpwetjeh kwel. Inang kwerrern anetj ilek, “Paul rang angketj Jesu-akert kaltj-anthem, nwern ngwenh ilem, Jesu nheng-henh arrenyel-arleng arratetjeh!” ");
INSERT INTO amx_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Kwerrern anetj rang inenh angkep tjernek, “Jesu-ek yeng kaltj, Paul-ek thwen. Arrantherr ngwenharl?” ");
INSERT INTO amx_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Kwereng artwang kwerrern anetj-akert rang kemerremel inenh nyant atwek, mantarr inehenh alterremel. Artwang 7 inang warleng ater arrtjanek keth-warn, mantarr-kwenh alhwang thelelherl-apemel ineheng. ");
INSERT INTO amx_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Tjerrtj Ephesus-areny mapel angketj ineh-penh awek, tjerrtj Jew mapel tjerrtj Greek angkenh-angkenh mapel thwen, inang awemel ater-irrek. Inang Ngkart Jesu-henh arreny nakek, renh iterl-aremel rang twer anthwerr anemeng. ");
INSERT INTO amx_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Nakenh-nakenh arrpenh map inang tjerrtj mapeng ularr ilelhetjam, inang anetj mpwaretjart-penh. ");
INSERT INTO amx_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Tjerrtj rrpwetj ilelhek, inang arrwengkelth mpwarenh-arenh anetjart. Inang pip inehenh angetjek, arrwengkelth-henh arreny map-akert. Inang pip inenh rwel itek tjerrtj mapeng ularr. Pip inenh inarl arrwekel maney angerrel payem-ilekarl, 50,000 ngkweltj silver-el. ");
INSERT INTO amx_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Tjerrtj aningkel mer mapel angketj Ngkart Jesu-akert awemel nakekemeh. Inang ilek, “Angketj Ngkart-kenh twer anthwerr anem!” ");
INSERT INTO amx_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Kwereng Paul rang iterrek, Jerusalem-warnemeh alhetjeh. Rang iterrek altwerl-amparr alhetjeh, mer Macedonia-angkwerr mer Achaia-angkwerr thwen-amparr. Rang inehel-arleng yatjarr anetjeh. Rang ilelhek, “Kelant Jerusalem-penh yeng alhetjenheng Rome town-warnemeh.” ");
INSERT INTO amx_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Kwereng rang artwang Timothy Erastus thwen arrwekel lanthek mer Macedonia-warn. Rang mer Asia-el antarl-irrek-amparr, kwek war anetjeh. ");
INSERT INTO amx_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ephesus town-elemeh mer-areny map inang ahentj-kweny-irrek Ngkart Jesu nakenh-nakenh mapeh. ");
INSERT INTO amx_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Tjerrtj mer-areny mapel naketjart marl altjerr-arrpantey pwerteng mpwarekarl arreny kwerenh Artemis. Artemis kwer artelhek warl angerr. Inang warl-warn irrpetjart, kelkertel-ayeng arrernelhemel Artemis renh naketjart. Artwang silver mpwarenh-arenh anek, arreny kwerenh Demetrius. Rang warl-arrpantey map mpwaretjart silver-penh. Warl kwek nhenh map warl angerr Artemis-kenh-arteh anek. Rang inenh sell-em-iletjart, maney angerr mpwaretjart. Arrpenh mapel thwen lakenh warl-arrpantey kwek mpwaretjart, maney angerreh sell-em-iletjart. ");
INSERT INTO amx_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Demetrius rang tjerrtj warl mpwarenh-arenh arrpenh map inenh arrawelh-ilek angkerretjeh. Demetrius rang angkek, “Artwang mapay! Arrantherr-artek kaltj, nwern kwenh maney angerr inem, warl-arrpantey inenh sell-em-ilekarl-penh. ");
INSERT INTO amx_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Arrantherr kwenh kaltj, arrantherr arek awekarl thwen angketj artwang Paul kwer-akert, rang nheng tjerrtj map mer nhenhel-ayeng palekalek kaltj-antherl-apetjam, mer apanpel Asia-el thwen. Paul rang inenh rrtjwerremel iletjam, altjerr nwernarl iltjel mpwarekarl inang itjarl altjerr kwel anemeng. ");
INSERT INTO amx_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Paul-el apek tjerrtj map lakenh kwet kaltj-anthemeng, inang nwernenh arrampewehetjeng. Inang marl Artemis-kenh warl angerr arrampewehetjeng, kwer-warn irrpetjal anetjeh. Ngkweyeng-ntjel tjerrtj mapel Artemis renh kangkwerremel nakem kwet mer Asia-el ahelh apanpel thwen. Lyeteng inang Artemis mentj impehetjeng, inang renh naketj-kweny anem, kwer-warn arraw-irretj-kweny anehetjeng-arlk!” Lakenh Demetrius-el inenh ateng-ilemel ilek. ");
INSERT INTO amx_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Artwang silver mpwarenh-arenh inang angketj nhenh awemel ahang-irrek Paul kwer. Inang arlkemel ilerl-apetjam, “Artemis rang Ephesus-areny nwern-henh marl altjerr tjeperr anthwerr rang anem!” ");
INSERT INTO amx_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Tjerrtj ingkerrek town kwerel arrtjanerl-apemel arlkerl-apetjam. Inang Paul-henh peltj atherr Gaius Aristarchus thwen antwerrkek. Artwang nhenh-atherr kel mer Macedonia-eng petjekarl Paul-el-ayeng. Inang tjerrtj ingkerrekemeh keth nyent-warn angkerrenh-rrenh-warn arrtjanewarretjam. ");
INSERT INTO amx_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Paul rang ahentj-anek, tjerrtj aningk-warn alhetjeh, ineh angketjeh. Peltj kwerenh mapel renh ayakek. ");
INSERT INTO amx_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Mer-areny twernk rrpwetj inang peltj Paul-eh anek, inang urrpey kwer-warn lanthek, renh ayaketjeh. ");
INSERT INTO amx_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Artwang aningk inartek palekalek anthwerr arlkerl-apetjam. Arrpenh map inang angwaremel arlkerl-apetjam! ");
INSERT INTO amx_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Tjerrtj Jew mapelemeh artwang nyent arreny Alexander twernek, tjerrtj mapeng ularr irnemel angketjeh. Arrpenh map inang Alexander kwer arlketjam. Alexander rang iltjem-iltjemel kwerremel inenh ntert-iletjeh ahentj-anek, rang ineh-warn angketjenheng. ");
INSERT INTO amx_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Tjerrtj mapelemeh alhengk-arek, Alexander rang artwang Jew anemeng. Inang kwet anthwerr arlketjam, “Artemis rang Ephesus-areny nwern-henh altjerr marl tjeperr anthwerr rang anem!” ");
INSERT INTO amx_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Kwereng twernk nyentel tjerrtj map inenh ntertelh-ilek. Rang inenh ilek, “Artwang Ephesus-areny mapay! Tjerrtj ingkerrek inang kel kaltj anem, nwern altjerr Artemis-kenh warl anyenem. Nwern pwert anganentj inngerr kwerenh-akert nheng alkereng anyekarl arntarnt-arem. ");
INSERT INTO amx_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Nhenh arratj wart anem, arrantherr ntert irretjeh. Itja alngernt-irretjeh. ");
INSERT INTO amx_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Artwang rrpwetj nhenh map inartek itja Artemis-kenh warleng anyenngel inek. Inang Artemis renh itja arrampewek. Arrantherr pelkel inenh nhenh-warn angetjek. ");
INSERT INTO amx_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Artwang Demetrius silver mpwarenh-arenh arrpenh map thwen inang ahentj-anem apek, artwang nhenh inenh nakepakel-iletjeh, inang inenh court-warn angetjeh, court-ek-artwey rang inenh pawenhetjeh. ");
INSERT INTO amx_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Arrantherr apek angketj arrpenh-akert anem, arrantherr inenh council-warn angetjeh, nwern angkerretjeh-amparr angketj kwereng. ");
INSERT INTO amx_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Roman government-el awehetj imampwerl nhenh-akert, nwern ingkerreny nhenh-penh anketj-warn irrehetjeng, Roman government-el nwernenh pawenhehetjeng.” ");
INSERT INTO amx_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Twernk rang inenh ilekarl-penh, rang inenh kel mer inehenh-warn lanthekemeh. ");
INSERT INTO amx_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Imampwerl-penh tjerrtj Ephesus-areny map inang ngwerrekarlemeh anek. Paul rang nakenh-nakenh mapeh ntangkelhek. Rang inenh twer-ilek angketj kwerenhel. Kwereng rang inenh twap-antherl-alpek, mer Macedonia-warn alhetjeh-anngerntarl. ");
INSERT INTO amx_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Rang Macedonia kwer-angkwerr anper-alhemel nakenh-nakenh mer-areny map inenh twer-ilemel angketj mwerrel ilerl-alhek. Kwereng rang mer Greece-warn alhek. ");
INSERT INTO amx_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Rang mer Greece kwerel months rrpwetjeh-atwetj anek. Paul rang ahentj-anek, boat-el mer Syria-warn alhetjeh. Kwereng artwang arrpenhel renh ilek, tjerrtj Jew map twernelhekarl, renh irrernng atwetjeh. Lakenheng rang mer Macedonia-angkwerr angkep anper alpek. ");
INSERT INTO amx_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Artwang nhenh map Paul-el-ayel pwert alhek. Sopater Pyrrhus-kenh ler, rang Berea town-areny anek. Aristarchus Secundus thwen artwang ratherr Thessalonica town-areny anek. Gaius rang Derbe town-areny anek. Timothy artwang Asia-areny atherr thwen Tychichus Trophimus anek. ");
INSERT INTO amx_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Artwang nhenh inang arrwekel boat-el alhek town Troas-warn. Town Troas kwerelemeh inang nwerneh karelhek. ");
INSERT INTO amx_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Nwern karelhek-amparr irlpangkentj arreny Mern Arlwar-ilenh-ilenh-kweny anyenetjeh-anngernt, kwereng nwern Philippi town-el boat-ekemeh antjerl-alhek. Nwern boat kwerelemeh arltang 5 kwatj alay-angkwerr alhekarl-penh, nwern kel mer Troas kwerelemeh boat-eng anarnpek. Mer kwerelemeh nwern artwang nheng arrwekel-penh mapel-ayeng weth nyent-irrek, inarl nheng arrwekel alhekarl. Nwern arltang 7-eh-atwetj mer kwerel anek. ");
INSERT INTO amx_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Nwern Sunday angwerr-angwerrel arraw-irrek tjerrtj mer-areny mapel-ayeng, mern arltang angerrel arlkwetjeh-anngernt. Paul-el nwernenh kaltj-anthek-amparr kweny mpwepeh-atwetj, rang kweny-rtweh anper alhetjenheng. ");
INSERT INTO amx_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Warl kern anthwerr kwerel nwern room nyentel arraw-irrek. Rwang alngenth map ampetjam. ");
INSERT INTO amx_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Artwang nyent arreny kwerenh Eutychus rang window iterel anetjam, room kern anthwerr kwerel. Paul rang kaltj-anthetjamarleng, Eutychus rang parrk-irremel ankwang awelhek. Rang ankwang angerr ahelh-warn anyek. Inang anarnpemel renh inek. Rang kel ilwekarl. ");
INSERT INTO amx_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Paul rang kerneng anarnpetj-alhek, rang artwang kwer-arleh ampek-welhek renh amel-rrkwemel. Rang inenh ilek, “Arrantherr itja ater-irretjek, rang iteth anem.” ");
INSERT INTO amx_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Paul rang weth warl kern-warn angkep antjek, nwernehel-ayeng mern arlkwetjenheng. Paul-el nwernenh weth kaltj-anthek aherlkentjeh-atwetj. Kwereng Paul nwern alethemeh alhek. ");
INSERT INTO amx_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Nakenh-nakenh mapel artwang nheng renh iteth angkep angek mer kwerenh-warn. Inang ingkerrek arrken anthwerr anek. ");
INSERT INTO amx_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Nwern boat-ek antjemel, nwern kwatj alayel Assos town-warn alhek. Nwern Paul renh imperl-alhek ingkern. Paul rartek ahentj-anek, town Assos kwer-warn ingkang alhetjeh. ");
INSERT INTO amx_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Arltang arrpenhel Paul nwern arerrek Assos town kwerel. Rang nwernehel-ayeng boat-ek antjek, nwern pwertemeh town Mitylene-warn alhek kwatj alay-angkwerr. ");
INSERT INTO amx_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Nwern mer map-angkwerr anperam-anper alhek Miletus town-ek-atwetj, arltang arrpenhel mer Kios-warn, kwereng arltang arrpenhelemeh mer Samos-warn, kwereng arltang arrpenhel nwern town Miletus-warn alhek. ");
INSERT INTO amx_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Paul rang ahentj-anek, Jerusalem-warn alhetjeh arltang Pentecost kwer. Lakenh rang ahentj-anek, Ephesus town-eng anper kwet alhetjeh, nakenh-nakenh mapel renh kwet ayakehetjeng mer Asia-el. ");
INSERT INTO amx_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Paul-elemeh mer Miletus-eng urrpey lanthek Ephesus town-warn, werlamparenyeh arntarnt-arentj map-warn. Urrpey rang angketj inenh ilek, inang petjetjeh, Paul renh arerl-alpetjeh. ");
INSERT INTO amx_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Arntarnt-arentj kel petjekarlengemeh, Paul rang ineh ilelhek, “Arrantherr kel yengenh ngkweyeng arek, yeng arrehantherrel-ayeng anetjamarleng mer Asia-el, yeng kweteth arratj mernelhek. ");
INSERT INTO amx_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Tjerrtj Jew map angketjam, yengenh atwetjeh. Map-ingar yeng arnek ltarrp awelhemel. Thang arrantherrenh angketj Ngkart-akert kwenpel kwet kaltj-antherl-apek. Yeng itja nakelhek. ");
INSERT INTO amx_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Thang itja Altjerr-henh angketj nyent apek arrehantherreng alengk-wek. Thang angketj ingkerrek ilerl-apek arrehantherr kethel, church arrehantherr-henhel thwen mer arrehantherr-henhel apek. ");
INSERT INTO amx_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Thang tjerrtj Jew map tjerrtj lwereny map thwen ilek, anetjeng Altjerr-warn twep-irretjeh, Ngkart Jesu renh nakemel. ");
INSERT INTO amx_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Lyet yeng Jerusalem-warn alhetjenh, Kwerrern Alngaltarel yengenh ilekarleng. Yeng apek nthakenh irretjenh Jerusalem-el? Nhenheh yeng itja kaltj anem. ");
INSERT INTO amx_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Kwerrern Alngaltarel yengenh mer mapel nhenhant iletjam, ‘Ntwang tjayel-warn irrpetjenh, ntwang imampwerl angerrel anetjenh.’ ");
INSERT INTO amx_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Yeng itja ater-irrem ilwetjeh apek. Yeng ahentj-anem, rrkwapentj tjengenh arratj mpwarerl-apetjeh, Jesu-el yengenh lanthekarleng wart, thang angketj mwerr tjerrtj ingkerreny kaltj-antherl-apetjeh, Altjerr rang ineh kangkentj mernelhemeng. ");
INSERT INTO amx_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Yeng kel kaltj, arrantherr yengenh itja weth aretjenh. Thang arrantherrenh kel kaltj-anthek, Altjerr rang Ngkart tjerrtj ingkerrekeh anem. ");
INSERT INTO amx_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Nhenhemeh thang twerel arrantherrenh ateng-ilemel ilem. Tjerrtj arrpenhel apek angketj Ngkart-kenh awemel Jesu naketj-kwenh anetjenh. Kwereng arltang ingkernel inang itja Ngkart-kenh anetjenh. Inang apek yengenh lakenh iletjenh, ‘Artwang nhenhel itja nwernenh arratj ilek arrwekel.’ ");
INSERT INTO amx_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Itja. Thang kwenh arrantherrenh Altjerr-henh angketj ingkerrek kaltj-anthek, nthakenh arrantherr Altjerreng ularr arratj mernelhetjeh. ");
INSERT INTO amx_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Arrantherrarrpemeh mantj arntarnt-arelhetjeh, arrantherr pal iterremel Ngkart Jesu-eng tjenelhehetj. Arrantherr werlampareny arratj arntarnt-arang, Kwerrern Alngaltarel arrantherrenh ngkernekarleng, inenh arntarnt-aretjeh. Altjerr-henh werlampareny kwet arntarnt-arang, yep-yep arntarnt-arenh-arenhel yep-yep kwerenh arntarnt-aremarl-arteh. Altjerrel kwenh werlampareny inek, Ler kwerenh anthemel, Ler rang ineh tjang-ilwetjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Yeng kwenh kaltj, yeng alpetjenharleng, tjerrtj anetj mapemeh arrehantherr-warn petjetjenh. Inang werlampareny pal kaltj-anthetjenh, tjerrtj arrpenh map pal iterretjenheng, tjey anetjel-arlk alhetjenheng. Tjerrtj anetj inang angwely arnwerel-artek anetjenh, yep-yep map nhwemel-artek. ");
INSERT INTO amx_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Werlampareny arrehantherr-henheng rrpwetj arrpenhel arrantherrenh pal kaltj-anthemel tjey-angetjenh. Inang ahentj-anetjenh, werlampareny inehemeh kangkwerretjenh. ");
INSERT INTO amx_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Thang arrantherrenh lakenh ilentjekarl 3 years-eh-atwetj, angerr arnemel. Arrantherremeh karr anerrerrang! ");
INSERT INTO amx_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Thang lyet Altjerr renh tjang-pawenhem, rang arrantherrenh arntarnt-aretjeh. Rang arrehantherr kwet kangkentj mernelhetjeh, rang arrantherrenh twer-iletjeh angketj kwerenhel-ayeng. Kelant arrantherr tjerrtj kwerenh mapel-ayeng anetjenh, ineh-arteh arratj anem-arteh, Altjerrel arrehantherr ingkerrek mwerr anthetjenh, arrantherr ler kwerenh anemeng wart. ");
INSERT INTO amx_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Yeng itja tjerrtj arrpenh-henh maneyeh apek rnwanentjeh apek ahentj-anek. ");
INSERT INTO amx_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Arrantherr kel kaltj, yengarrp iltjang tjengenhel merneh rnwanentjeh thwen rrkwapekarl. Yeng rrkwapek, tjerrtj tjengel-ayel rlkwatherr anetjamarl map thwen wantetjeh. ");
INSERT INTO amx_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Thang lakenh mernek, arrantherr arrpenh map arntarnt-aretjeh mern-arlk anthemel. Ngkart Jesu rang nheng ilekarl, ‘Altjerreng ularr nhenh mwerr anem, ayerrp-iletj-kweny anetjeh, arrantherr-atwetj arrpenh mapeh war anthetjeh. Kwereng Altjerrel arrantherrenh kwart-wentj-penharl arrken-iletjenhemeh.’ ” ");
INSERT INTO amx_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Paul rang lakenh ilelhekarl-penh, rang arntarnt-arentj inehel-ayeng kelkertel-ayeng arrernelhek. Rang Altjerr ineh tjang-pawenhek. ");
INSERT INTO amx_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Inang ingkerrek angerr arnek, inang renh amel-rrkwemel arrantjwek. ");
INSERT INTO amx_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Rang ineh ilelhekarleng, inang renh itja weth aretjenharl, lakenh inang lharrp awelhemel arnek. Kwereng inang kwerel-ayeng boat-warn alhek, renh arteng-wetjeh. ");
INSERT INTO amx_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nwern inenh imperl-alhek Miletus town-el. Nwern boat-el antjerl-alhek, kwatj alay-angkwerr island Cos-warn alhek. Kwereng arltang arrpenhel nwern island Rhodes-warn alhek, kwereng nwern town Patara-warnemeh alhek. ");
INSERT INTO amx_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Patara kwerel nwern boat-eng anarnpek. Nwern boat arrpenh angerretj arek, mer Phoenicia-warn alhetjeh-anngernt. Nwern antjekemeh boat kwer-warn, kwereng nwern alethemeh alhek. ");
INSERT INTO amx_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Mer Cyprus renh nwern anperel arenhek, nwern Cyprus-eng antekerr-angkwerr alhek mer Syria-warn-atheh. Nwern town Tyre-el irretj-alhek. Town nhenh kwerel boat-eh-artwey map ahentj-anek, rnwanentj inehenh imperl-alhetjeh. ");
INSERT INTO amx_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Nwern boat-eng anarnpek, kwereng nwern nakenh-nakenh town-areny map aretjeh alhek. Nwern inenh ngwerrm aretj-alhek. Inang nwernenh ayakek, inehel-ayeng intetjeh arltang 7-eh-atwetj. Kwerrern Alngaltarel nakenh-nakenh inenh ilek, Paul rang town Jerusalem-el nakepakel-irretjenharl. Lakenheng inang arrkernelhek, Paul renh ayaketjeh, Jerusalem-warn alhehetjeng. ");
INSERT INTO amx_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Paul rang itja ineh kangkwerrek. Rang ahentj-anek, Jerusalem-warn alhetjeh kwet. Kel nwern alhek boat aretjeh, aleth alhetjeh-anngernt. Nakenh-nakenh inang nwernehel-arleng alhek boat-warn artwaretjeh, anew kwer thwen inehenh-akert. Nwern ingkerrekemeh kelkertel-ayeng arrernelhemel Altjerr-warn angkek, kwatj alay iterel, arnkarr kwerel. ");
INSERT INTO amx_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Inang nwernenh twap-anthek. Kwereng nwern boat-ehemeh antjerl-alhek. Inang mer inehenh-warn angkep alpek. ");
INSERT INTO amx_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Tyre town-eng-ntjel nwern town Ptolemais kwer-warn boat-el alhek. Ptolemais kwerel nwern boat-eng anarnpek. Nwern nakenh-nakenh arrpenh map aretj-alhemel inehel-arleng kweny nyentel intek. ");
INSERT INTO amx_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Kwereng arltang arrpenhel nwern Caesarea town-warn alhek, kweny rrpwetj interl-alhetjeh. Artwang nheng Philip town kwerel anek. Philip rang angketj mwerr Jesu-akert kaltj-anthetjart. Renh kwenh Jerusalem-areny werlamparenyel arrwekel arrernekarl, artwang 6 arrpenh inenh thwen, mernel wantetjeh werlampareny. Nwern kwerel-arleng arltang rrpwetj anek. ");
INSERT INTO amx_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Philip-henh marl awenk atherram-atherr anek, arlweker-areny. Marl nhenh inang Altjerr-henh angketj angenh-angenh anek. ");
INSERT INTO amx_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Nwern town Caesarea kwerel arltang rrpwetj anek. Altjerr-henh angketj angenh-angenh arrpenh mer Judea-eng petjek, arreny kwerenh anek Agabus. ");
INSERT INTO amx_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Agabus rang nwerneh-warn petjek. Rang Paul-henh belt kap-rlwemel rang iltjang ingkang thwen kwewaleny belt-el ayernelhek. Rang nwernenh ilek, “Kwerrern Alngaltar rartek lakenh ilem, ‘Artwang belt kwer-artwey angerrepat Jerusalem-areny inang lakenh-arteh renh ayernetjenh. Kwereng inang renh tjerrtj lwereny mapeh anthetjenh.’ ” Lakenh Agabus rang arrwekel war ilek, nthakenh Paul-eh anetjenharl. ");
INSERT INTO amx_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Nwern nhenh awemel nwern mer-areny mapel thwen Paul renh ywarn arnpakewarrek, Jerusalem-warn alhehetjeng. ");
INSERT INTO amx_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Paul rang nwernenh pawenhek, “Wenhengarl arrantherr arnem? Arrantherr yengenh-artek ltarrp mpwarem! Arnpaketjal yengenh imperrerrang! Yeng ngampwerrp awelhem, inang apek ahentj-anem, yengenh Jerusalem-el tjayel-warn kwernetjeh, irrernng-arlk atwetjeh apek Ngkart Jesu-henh arrenyeng arrngel. Kel.” ");
INSERT INTO amx_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Nwern renh ywarn kwet arnpakek. Nwern kel lakenhant angkek, “Kel alhang, Ngkart rang ngkweng ahentj-anemeng wart.” ");
INSERT INTO amx_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Kwereng nwern rnwanentj pelangket-arlk angemel Jerusalem-warnemeh alhek. ");
INSERT INTO amx_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Nakenh-nakenh rrpwetj Caesarea-areny nwernehel-ayel alhek. Nwern Jerusalem-el irretj-alhemel inang nwernenh artwang Mnason-kenh warl-warn tjey-angek, nwern warl kwerelemeh anek. Mnason rartek artwang Cyprus-areny anetjart arrwekel-penh, kwereng rang Jerusalem-warn anam-irrekarl. Rang Jesu nakenh-nakenh anek. ");
INSERT INTO amx_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Nakenh-nakenh Jerusalem-areny mapel nwernenh aremel inang nwernenh kangkentjel ngwek. ");
INSERT INTO amx_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Arltang arrpenhel Paul nwern thwen James aretjeh alhek. Werlamparenyeh arntarnt-arentj map inang James-el-ayel anek. ");
INSERT INTO amx_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Paul rang inenh kangkemel ilek, “Thang tjerrtj lwereny mapeh angketj mwerr renh kaltj-antherl-apetjam mer mapel. Altjerr rang tjengel-ayeng twer angerr kwerenhel mpwarek, tjerrtj lwereny map Jesu-warn twepelh-iletjeh. Aningkel kwetemeh Jesu renh nakek.” ");
INSERT INTO amx_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","James mapel angketj nhenh awemel inang Altjerr renh kangkemel nakek. Kwereng inang Paul renh ilek, “Peltjay! Tjerrtj Jew aningkelemeh Jesu renh lyet nakem. Inang Moses-henh mpwareng-arengeh kwet kangkwerrem. ");
INSERT INTO amx_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Inang awek, ntwang kwel mer mapel Jew map ilerl-apek, inang Moses-henh mpwareng-areng mentj impetjeh. Inang kwer rrwey inehenh itja artwang-iletjeh. ");
INSERT INTO amx_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Tjerrtj nhenh mapel kwenh awetjenh ntwarl Jerusalem-warn petj-alpekarl. Inang ngkweng ahang-irrehetjeng, nthakenh nwern irretjenh? ");
INSERT INTO amx_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ntwang nwerneh kangkwerretjeh. Artwang 4 pel lyet nwernehel-arleng anem, inang Altjerr renh alhelekarl. ");
INSERT INTO amx_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Ntwang artwang nhenh inehel-arleng Altjerr-henh church angerretj-warn alhang. Arrantherr lhewelhetjeh-amparr Moses-henh mpwareng-areng-angkwerr. Kwereng arrantherr ngkart priest-eh ilelhewarrang. Kwereng ntwang Altjerreh tjenkerremeh anthang ngkweng artwang ineh thwen, arrantherr kapert kwerl akelhetjeh-anngernt. Lakenh ntwang tjerrtj mapeh mernelhetjenh, ntwang Moses-henh mpwareng-arengeh kangkwerremarl. Inang alhengk-aretjenh, angketj nhenh ngkweng-penh rrtjwerrentj war anem, inang pal awek. ");
INSERT INTO amx_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Tjerrtj lwereny nheng map ntwang inenh arrwekel kaltj-anthekarl, nwern kel ineh-warn pip lanthekarl, nwern nheng inenh arnpakemel ilek, inang mern ker thwen arlkwetjal anetjeh, nheng altjerr-arrpanteyeh tjenkerr anthekarl-penheh. Inang ker atwemeng, inang alhwang-amparr mentj impetjeh thelelhetjeh-amparr. Inang alhwang antjwetj-kwenh anetjeh, ker alhwakert arlkwetj-kwenh anetjeh. Inang anew arrpenh-henhel-ayeng intetjal anetjeh.” Lakenh James-el arntarnt-arenh-arenh mapel thwen nwernenh ilek. ");
INSERT INTO amx_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Arltang arrpenhel Paul rang artwang atherram-atherr inenh ngwek. Inang lhewelhek Moses-henh mpwareng-areng-angkwerr. Kwereng rang artwang ineh-akert Altjerr-henh church angerretj-warn irrpenhek. Rang artwang priest inenh irlpangkelh-ilek, arltang 7-penh inang Altjerreh ker tjenkerremeh itemel anthetjeh. ");
INSERT INTO amx_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Arltang 6-penh tjerrtj Jew Asia-areny rrpwetjelemeh Paul renh Altjerr-henh church angerretjel arek. Inang tjerrtj arrpenh mapemeh rrwampey-ilek. Kwereng inang Paul renh antwerrkekemeh. ");
INSERT INTO amx_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Inang arlkemel ilek, “Peltj mapay, ularr petjewarrang! Nhenh kwenh artwang rang, rarl mer mapel tjerrtj nwerneh tjel-angkem! Rang Altjerr-henh church angerretj nhenh Moses-henh mpwareng-areng thwen arrampewem! Lyet rang tjerrtj lwereny map church angerretj nhenh-warn angetjekarleng, artwang Greece-arenyarl!” Lakenh inang Paul-eh mwekeny-irremel arnkely-irrek. ");
INSERT INTO amx_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Inartek arrwekel Paul Trophimus renh-atherrenh arekarl, ratherr town-el pwert nthwerl-aperleh. Artwang Trophimus rartek Ephesus town-areny anek. Inang iterrek, Paul-el kwel Trophimus renh church angerretj-henh yard-warn kwen angekarleh-athen, mpwareng-areng inehenh ltwakekarleh-athen. ");
INSERT INTO amx_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Tjerrtj aningk inang angketj lakenh awemel church angerretj kwer-warn arlkemel arrtjanek, Paul renh antwerrketjeh. Inang renh church yard-eng keth-warn tjarr-angek. Arrpenh mapel gate map inenharl martek. ");
INSERT INTO amx_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Tjerrtj inang Paul renh ngkwal irrernng atwek. Arrpenhel Rome-areny atwenh-atwenh map-henh twernk ateng-ilek, tjerrtj Jerusalem-areny map atwerremeng. ");
INSERT INTO amx_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Twernk rang atwenh-atwenh kwerenh mapeh ntangkelhek, rang atwenh-atwenh ineh-akert aningk ineh-warn arrtjanek. Aningk inang twernk renh arek, atwenh-atwenh map-akert petjerleh, inang Paul renh atwetj-kwenhelemeh imperl-alhek. ");
INSERT INTO amx_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Twernk rang Paul renh antwerrkek, atwenh-atwenh rrpwetjemeh rang ilek, Paul renh chain atherrel ayernetjeh. Rang tjerrtj inenh pawenhek, “Ngwenham artwang nhenhan? Wenheng arrantherr renh atwek?” ");
INSERT INTO amx_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Twernk rang inenh ywarn pawenhek, inang ingkerrek arlketjamarleng angketj arrpenhek-arrpenhel. Lakenheng rang atwenh-atwenh kwerenh map ilek, Paul renh atwenh-atwenh map-henh warl-warn angetjek. ");
INSERT INTO amx_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Inang warleh itwek-irrek, warl kern-warn antjetjeh, warl angerr irrpetjeh-anngernt. Tjerrtj map inang ahentj-anek, Paul renh irrernng atwetjeh. Lakenheng atwenh-atwenh inang renh tjwenemel angek. ");
INSERT INTO amx_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Tjerrtj inang ingkern-angkwerr alwernemel arlkerl-apetjam, “Renh irrernng atwerrerrang! Renh irrernng atwerrerrang!” ");
INSERT INTO amx_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Inang wart Paul renh atwenh-atwenh-henh warl-warn irrpelh-iletjeh anek, Paul rang twernk kwer angkek, “Twernkay, thang apek ngwenh pawenhemeram?” Twernk rang renh pawenhek, “Ntwang angketj Greek angkenh-angkenh kwey? ");
INSERT INTO amx_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Thang iterl-arek, ntwang kwel Egypt-areny nheng anemarleh-athen, rarl ngwerreh war tjerrtj map rwekenth-kenth-ilekarl-penh. Kwereng rang artwang atwenh-atwenh 4,000-akert rrkwal-warn alhek. Artwang nhenh inang ingkerreny arrawey-akert anek. Ntwang artwang rang key?” ");
INSERT INTO amx_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Paul rang ilelhek, “Yeng itja artwang rang anem. Yeng kwenh artwang Jew mer Tarsus-areny. Tarsus rang town angerr mer Cilicia-el. Ntwang apek yengenh impemer, tjerrtj yanh map-warn angketjeh-amparr?” ");
INSERT INTO amx_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Twernk rang angkek, “Ntwarrp ilelhang.” Paul-el tjerrtj map kwerremel ilek, inang ntert-amparr irretjeh. Inang kel ntert-irrekarlengemeh, Paul rang ineh Hebrew angketjel ilelhek. ");
INSERT INTO amx_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Artwang peltj mapay, aywang map thwenay! Tjeng-amparr kangkwerrerrerrang!” ");
INSERT INTO amx_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Rang inenh Hebrew angketjel ilekarleng angketj kwerenhel, angketj inehenhel-ayeng thwen, inang ntert-irrek. Paul rang ilelhek. ");
INSERT INTO amx_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Yeng kwenh artwang Jew. Yeng kwer ngwerrm-irrek Tarsus town-el mer Cilicia-el. Kwereng yeng Jerusalem nhenhel mangkek. Yeng kaltj-anthenh-anthenh arreny Gamaliel-el-ayeng kaltj-irrek Moses-henh mpwareng-arengeh. Rang yengenh mpwareng-areng ingkerrek kaltj-anthek. Yeng athek-irrek, Altjerreh kangkwerretjeh, arrantherr lyet Altjerreh kangkwerretjeh athek-irrem-arteh. ");
INSERT INTO amx_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Thang arrwekel tjerrtj inenh irrernng atwetjeh alwernek, inarl Jesu nakenh-nakenh map anetjart. Thang inenh artwang marl thwen antwerrketjart, thang inenh tjayel-warn kwernetjart. ");
INSERT INTO amx_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Priest twernk angerr rang tjeng kaltj anek, Council thwen. Inang tjeng-penh angkemer, arrantherrenh irlpangkelh-iletjeh. Inang kwenh pip tanthemel anthek tjeng, thang Damascus-warn angetjeh, angerrepat Damascus-areny map anthetjeh-anngernt, thang nakenh-nakenh map Jerusalem-warn angkep angetj-alpetjeh, angerrepat nhenh-areny mapel inenh atwetjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Yeng Damascus kwer-warn angathemeh-irrek, arltang mpwepel parrtj angerrelemeh yengenh alkereng parrtjelh-ilek. ");
INSERT INTO amx_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Yeng ahelheh anyerl-alhek. Thang angketj war awek, rang tjeng-warn angkerleh, ‘Saul-ay! Saul-ay! Wenhengam ntwang yengenh atwetjeh alwernem?’ ");
INSERT INTO amx_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Thang renh pawenhek, ‘Ngwenham ntwang, Ngkart key?’ “Rang tjeng tjernemel ilelhek, ‘Yeng kwenh Jesu Nazareth-areny anem, ntwarl atwetjeh alwernem rang!’ ");
INSERT INTO amx_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Artwang inang tjengel-ayel alhekarl, inang parrtj renh arek, inang itja Jesu-henh angketj awek, rang tjeng-warn angkerleh. ");
INSERT INTO amx_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Thang Jesu renh pawenhek, ‘Ngkartay, nthakenhameh yeng irretjeh?’ “Rang yengenh ilek, ‘Kel kemerray! Damascus town-warn alhay. Town kwerelemeh artwang nyentel ngkweng iletjenh, nthakenh ntwang mpwaretjeh.’ ");
INSERT INTO amx_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Parrtj angerr rartek anngang tjengenh pweng-ilekarl, lakenheng artwang inarl tjengel-ayeng alhekarl mapelemeh yengenh iltjeng Damascus-warn tjey-angek. ");
INSERT INTO amx_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Damascus kwerel artwang Ananias rang anek, artwang irlpareth. Rang Moses-henh mpwareng-arengeh kangkwerretjart. Tjerrtj Jew map ingkerrek town kwer-areny inang Ananias kwereng angketj iletjart, ‘Rang artwang mwerr anthwerr.’ Ananias rang tjeng-warn petjek. ");
INSERT INTO amx_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Rang tjengel-ayeng iterel irnek. Rang yengenh ilek, ‘Saul-ay, peltj tjengenhay! Anngang ngkwengenh kel alngampang, yengemeh arang!’ Thang renh anngang mwerrelemeh arek. ");
INSERT INTO amx_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Ananias-el yengenh ilek, ‘Altjerr nheng arrwekeleny nwern-henh mapel nakekarl, rang ngwenh urrarek, kwereng kaltj-irretjeh. Altjerr rang mernetjenh, nthakenh ntwang mpwaretjeh. Rang ngwenh urrarek, ntwarrp artwang arratj anthwerr renh aretjeh awetjeh thwen. ");
INSERT INTO amx_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ntwang tjerrtj ingkerrek ilerl-apetjenh, ntwarl arekarl awekarl thwen. ");
INSERT INTO amx_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Kel kemerray! Ngkart-warn ilelhang, thang ngwenh kwatj-warn irrpelh-ilemel baptise-em-iletjenheng, Altjerrel anetj ngkwengenh wetjenheng.’ ");
INSERT INTO amx_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Kwer-penh yeng Jerusalem-warn angkep alpek. Arltang arrpenhelemeh yeng Altjerr-henh church angerretj-warn kwen irrpek, Altjerr-warn angketjeh-anngernt. Yeng kwer-warn angketjamarleng, thang anengkerr arek. ");
INSERT INTO amx_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Ngkart rang yengenh ilek, ‘Kel Jerusalem-eng parrp alhay! Tjerrtj mer-areny inang angketj ngkwengenheh itja kangkwerretjenh, ntwang inenh angketj tjeng-penh ilerleh.’ ");
INSERT INTO amx_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Thang renh ilek, ‘Ngkartay, inartek kaltj, yeng church nyentam-nyent inehenh-warn irrpetjart, nakenh-nakenh ngkwengenh map antwerrkemel inenh angetjart. Inang kaltj, thang nakenh-nakenh map tjayeleh kwernetjart, inenh atwetjart thwen. ");
INSERT INTO amx_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Inang kaltj, thang arrwekel kwenpel arerl-anek, inang Stephen renh irrernng atwerleh. Stephen nheng rarl tjerrtj map angketj arratj iletjart Altjerr-penh. Yeng kangkek, inang renh irrernng atwerleh. Thang atwenh-atwenh map-henh rnwanentj arntarnt-arek.’ ");
INSERT INTO amx_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Ngkartel yengenh ilek, ‘Kel alhay! Thang ngwenh lanthem tjerrtj lwereny map-warn, ntwarr mer apanp-warn.’ ” ");
INSERT INTO amx_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Tjerrtj inang Paul renh ntertel awetjam, kwereng rang tjerrtj lwereny map-warn alhetjeh angkek. Kwereng tjerrtj inang arlkemel ilek, “Renh kel irrernngant atwerrerray! Rang kwenh artwang anetj!” ");
INSERT INTO amx_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Inang kwet arlketjam, rnwanentj kern-penh inehenh rlwemel wetjam. Inang ahelh-arlk alker-warn wek. ");
INSERT INTO amx_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Twernk angerrelemeh atwenh-atwenh kwerenh map ilek, Paul renh warleh inehenh-warn-amparr irrpelh-iletjeh. Kwereng rang atwenh-atwenh rrpwetj ilek, Paul renh whip-el atwetjeh. Rang inenh ilek, Paul renh pawenhetjeh, “Wenhengam tjerrtj map ngkweng ahentj-kweny anem?” ");
INSERT INTO amx_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Inang renh ayernek, renh whip-el atwetjeh-anngernt. Paul-el twernk kwek renh-amparr pawenhek, “Wenh kwereng arrantherr yengenh pelkel atwetjeh? Yeng anem Rome-areny pip-akert. Angketj pipel-ayeng intem, ilern-henh twernk kwenh Rome-areny Caesar-arl! Arrantherr-artek itja yengenh court-warn-amparr angek!” ");
INSERT INTO amx_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Twernk kwekel renh awemel rang twernk angerr kwer-warnemeh alhek, renh ateng-iletjeh. “Ntwang ywarn artwang nhenh whip-el atwem, rang ilelhek, rang kwel Rome-areny pip-akert anem.” ");
INSERT INTO amx_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Twernk angerr rang Paul-warn petjemel renh pawenhek, “Tjeng ilelhay! Ntwam arratj Rome-areny pip-akert anem?” Paul rang tjernek, “Yaw, yeng anem.” ");
INSERT INTO amx_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Twernk angerr rang renh ilek, “Thang kwenh government renh maney angerr anthek, Rome-areny pip nheng inetjeh-anngernt.” Paul rang ilelhek, “Yeng kwenh Rome-areny pip-akertarl, yeng ngwerrm-irrekarleng.” ");
INSERT INTO amx_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Atwenh-atwenh inarl Paul renh atwetjeh anek, inang parrp kwereng tjenelhek. Twernk angerr rang ater-irrek, rang Paul renh chain-el ayernekarleng, Paul rang Rome-areny pip-akert anemeng wart. ");
INSERT INTO amx_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Arltang arrpenhelemeh twernk angerr rang Council angerr priest twernk angerr map thwen inenh arrawelh-ilek. Rartek ahentj-anek, inenh awetjeh, wenheng inang Paul-eh ngkwantj-irrek. Rang atwenh-atwenh inenh ilek, Paul-eng chain rlwetjeh. Rang Paul ilek, ineheng ularr irnetjeh. ");
INSERT INTO amx_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Paul-el Council inenh arnterr aremel ilek, “Peltj mapay, lyeteh-atwetj yeng Altjerreh arratj kwet kangkwerrentjekarl, anetj-kwenh.” ");
INSERT INTO amx_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Artwang rrpwetj Paul-el-ayel iterel irnek. Priest twernk angerr anek, arreny kwerenh Ananias. Ananias rang inenh twernek, Paul renh arrakert atwetjeh. ");
INSERT INTO amx_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Paul-el priest twernk renh ilek, “Artwang anetjay, Altjerrel ngwenh atwetjenh! Ntwang ahentj-anem, Moses-henh mpwareng-arengel-ayeng ntwang yeng pawenhetjeh. Ntwang artwang map twernem, yeng atwetjeharl! Lakenh ntwang mpwareng-areng kwer itja kangkwerrekarl!” ");
INSERT INTO amx_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Artwang inang Paul renh ilek, “Ntwang nyerr-kwenyel key Altjerr-henh priest twernk angerr arrampewemel ilek?” ");
INSERT INTO amx_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Paul-el inenh ilek, “Peltj mapay! Yeng itja kaltj anek, rang priest twernk angerr anerleh. Angketj Altjerr-henh pipel-ayeng kwenh intem, ‘Ntwang itja twernk angerr kwer-warn angketj anetj angketjeh.’ ” ");
INSERT INTO amx_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Paul rang alhengk-arek, ineheng arrpenh map artwang Sadducee map anerleh, arrpenh map artwang Pharisee-arl anerleh. Paul rang untarel ilelhek, “Artwang peltj mapay! Yeng kwenh Pharisee anem, angey tjengenh rang Pharisee anekarleng. Thang nakem, Altjerr rang tjerrtj irrernng map kemelh-iletjenh. Lakenheng inang lyet yengenh court-warn angem, yengenh pawenhetjeh-anngernt.” ");
INSERT INTO amx_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Kwereng artwang Sadducee map artwang Pharisee mapel-ayeng ilterretjam. ");
INSERT INTO amx_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Sadducee mapel-artek tjerrtj map kaltj-anthetjart, tjerrtj irrernng map kwel itja kemerretj-alpetjenharl, angel alker-areny map kwerrern thwen itja kwel anem. Pharisee mapel tjerrtj map kaltj-anthetjart, tjerrtj irrernng map kemerretj-alpetjenharl, angel alker-areny map kwerrern map thwen arratj anthwerr anemeng. ");
INSERT INTO amx_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Inang angerr anthwerr ilterretjam. Kwereng artwang Moses-henh mpwareng-areng kaltj-anthenh-anthenh arrpenh map inarl Pharisee anekarl inang angkek, “Artwang nhenh itja merrentj. Kwerrernel apek angelel apek arratj renh ilek!” ");
INSERT INTO amx_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Inang ngkwal atwerrek. Rome-areny twernk angerr rang ater-irrek, inang Paul renh ampakemel atwehetj. Lakenheng rang atwenh-atwenh kwerenh map ilek, Paul renh warl inehenh-warn anginetjeh. Kel inang Paul renh warl-warn kwen irrpelh-ilek, renh arntarnt-aretjeh map-hetj. ");
INSERT INTO amx_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Kweny arrpenhel Ngkart rang Paul-el-ayeng iterel irnek. Rang renh ilek, “Anew-anew kwet anang! Ntwang kel Jerusalem-areny map angketj tjeng-akert ilek. Lakenh ntwang Rome-warn alhetjeh, kel ntwang Rome-areny map angketj tjeng-penh iletjeh.” ");
INSERT INTO amx_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Kweny-rtwehemeh artwang Jew inang arraw-irrek angkerretjeh. Inang alhelerrek, “Nwern mern arlkwetj-kweny aney, antjwetj-kweny thwen, Paul renh irrernng atwetjeh-anngernt!” ");
INSERT INTO amx_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Lakenh artwang Jew aningk 40 pel inang alhelerrek. ");
INSERT INTO amx_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Kwereng inang priest twernk map-warn angerrepat map-warn thwen inenh iletj-alpek, “Nwern kwenh kel ilerrek, mern arlkwetj-kweny anetjeh, nwern Paul renh irrernng atwetjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Nwern ahentj-anem, arrantherrarl Council arrpenh mapel thwen urrpey lanthetjeh atwenh-atwenh twernk angerr nheng-warn, angketj lakenh rrtjwerremel iletjeh, ‘Paul renh lanthang angerrepat Jew map-warn. Inang renh arratjekarl pawenhetjeh ahentj-anem.’ Nwern kel renh irrernng atwetjenh, inang renh tjey-angkwerr angetjerleh.” Lakenh inang twernk inenh pawenhek. ");
INSERT INTO amx_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Paul-henh amarleyel angketj lakenh awek. Rang atwenh-atwenh-henh warl-warn irrpenhemel Paul renh ateng-ilemel ilek. ");
INSERT INTO amx_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Paul-el twernk nyent ngwemel renh ilek, “Anthetj nhenh twernk angerr-warn angay. Rang twernk renh ateng-iletjeh.” ");
INSERT INTO amx_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Kel twernk rang artwang renh twernk angerr-warn angek. Twernk rang twernk angerr renh ilek, “Paul artwang nheng nwernan angwerreh antwerrkekarl, rartek yengenh ilek, artwang nhenh renh ngkweng-warn angetjetjeh. Rang ahentj-anem, angketj nhenh ngwenh iletjeh.” ");
INSERT INTO amx_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Twernk angerr rang artwang renh iltjeng ngwemel angek, ratherr atherrarrp angkerretjeh. Rang artwang renh pawenhek, “Wenham ntwang yeng iletjeh ahentj-anem?” ");
INSERT INTO amx_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Anthetj rang twernk angerr renh ilek, “Tjerrtj Jew map-artek angkerrek, Paul renh irrernng atwetjeh. Ngwenth inang ngwenh pawenhetjenh, ntwang Paul renh Council ineh-warn lanthetjeh, inang renh weth arratjekart pawenhetjenheng. Angketj rang itja arratj anek, inang war rrtjwerrek. ");
INSERT INTO amx_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ntwang ineh itja kangkwerretjeh. Artwang 40-eng aningk-lkwer tjey iterel inang kwer karelhemel alengk-welhetjenh, renh irrernng atwetjeh-anngernt. Artwang nhenh inartek ilerrek, arlkwetj-kweny antjwetj-kweny-amparr anetjeh, inang Paul renh irrernng atwetjenheng. Inang karelhek-amparr, ngkwengeng inang angketj awetjeh-amparr.” ");
INSERT INTO amx_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Twernk angerr rang artwang renh ilek, “Ntwang tjerrtj arrpenh iletjal anetjeh, ntwarl tjeng-warn petjek.” Kwereng rang artwang renh angkep lanthek. ");
INSERT INTO amx_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Twernk angerr rang twernk kwek arrpenh atherr ngwek. Rang renh-atherrenh ilek, “Mpwel atwenh-atwenh 200 pel inetjeh, Paul renh arntarnt-aretjeh. Lyet kwenyel 9 o'clock-el Caesarea town-warn alhetjeh-anngernt. Mpwel atwenh-atwenh 70 pel arrpenh nanth-akert map inetjeh. Atwenh-atwenh 200 pel arrpenh irrtjart-akert map inetjeh. ");
INSERT INTO amx_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Kwereng mpwel Paul renh nantheh tjwenemel atwenh-atwenh nhenh mapel-arleng lanthetjeh, twernk angerr Felix-warn angerrerretjeh.” ");
INSERT INTO amx_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Twernk angerr rang pip tanthek, ratherr Felix renh anthetjenheng. Angketj nhenh pipel-ayeng intek, Felix renh ateng-iletjeh. ");
INSERT INTO amx_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Felix twernk angerray! Yeng Claudius Lysias anem. Thang pip nhenh ngkweng-warn lanthem. ");
INSERT INTO amx_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","“Tjerrtj Jew mapel-artek artwang Paul nhenh antwerrkek. Inang renh irrernng atwetjeh anekarl. Thang awek, rang Rome-areny pip-akert anerleh. Lakenheng yeng atwenh-atwenh map-akert alhek, thang renh arntarnt-aretjeh. ");
INSERT INTO amx_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Thang renh Council-warn anginek, inenh pawenhetjeh, ‘Wenheng arrantherr artwang nhenh renh atwetjeh anek?’ ");
INSERT INTO amx_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Inang tjeng-warn angkekarleng, thang alhengk-arek, inang mpwareng-areng inehenh-akertel war ahentj-anek, renh pawenhetjeh. Rome-areny mpwareng-areng-angkwerr rang itja merrentj anem. Nwern renh itja irrernng atwetjeh, itja tjayel-warn apek kwernetjeh. ");
INSERT INTO amx_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Kelant thang awek, inang weth angkerrekarl, renh irrernng atwetjeh kwel. Lakenheng thang renh ngkweng-warnemeh parrp lanthek. Thang tjerrtj Jew angerrepat map ilek, inang renh ngkweng-warn-amparr angetjeh, renh ngkwengeng ularremeh pawenhetjeh-anngernt.” Lakenh twernk angerr rang angketj pip-warn arrernek. ");
INSERT INTO amx_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Atwenh-atwenh inang twernk inehenheh kangkwerrek. Kwenyel inang Paul renh Antipatris town-warn angerrerrek. ");
INSERT INTO amx_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Kweny-rtweh atwenh-atwenh nheng mapel inarl ingkang petjekarl, inang Jerusalem-warn angkep alpek. Kwereng atwenh-atwenh nanth-akert mapelemeh Paul renh anper angerrerrek. ");
INSERT INTO amx_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Inang Caesarea town-el irretj-alhek, kwereng inang pip nheng Felix kwer anthek, Paul thwen. ");
INSERT INTO amx_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Felix rang pip nhenh read-em-ilekarl-penh, rang Paul renh pawenhek, “Mer nthenh-arenyam ntwang?” Paul rang ilelhek, “Yeng kwenh Cilicia-areny anem.” ");
INSERT INTO amx_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","Felix-el renh ilek, “Tjerrtj Jew twernk map inang petjetjenheng, kwerengant thang ngwenh awetjenheng.” Kwereng rang atwenh-atwenh kwerenh map ilek, inang Paul renh Herod-henh warl angerrel kwen anyenetjeh, inang kwerel renh arntarnt-aretjeh. ");
INSERT INTO amx_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Arltang 5-penh Ananias-emeh Jerusalem-eng Caesarea town-warn alhek, twernk Felix-warn. Ananias rartek priest twernk angerr anek. Ananias kwerel-ayeng angerrepat rrpwetj alhek. Inang artwang ilperrepwentj arreny kwerenh Tertullus inehel-arleng angek, Tertullus rang Paul renh Felix-eng ularr pawenhetjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Felix-elemeh atwenh-atwenh kwerenh map ilek, inang Paul renh warl-warn kwen angetjetjeh. Kwereng Tertullus rang kwet angketjam Felix-eng ularr. Rang ilek, “Felix-ay! Nwern-artek ngwerleny anek mer nyentam-nyentel, ntwang wart nwerneh twernk mwerr anekarleng. ");
INSERT INTO amx_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Nwern ngkweng kangkem, ntwang nwernenh arratj arntarnt-arentjekarleng. ");
INSERT INTO amx_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Yeng itja ahentj-anem kwet angkerl-apetjeh, ngwenh parrk anthehetjeng. Yeng kwek war ahentj-anem angketjeh ngkweng-warn. ");
INSERT INTO amx_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Paul-artek artwang rrwampey-ilenh-ilenh anem. Rang tjerrtj Jew map ahelh ntjaperel rrwampey-ilerl-apekarl. Kwereng inang ahel ilterrek. Rang twernk anem tjerrtj mapek, inarl artwang Nazareth-areny nakem. ");
INSERT INTO amx_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Ngwerreh war rang church angerretj nwern-henheng mwekeny-irrek. Lakenheng nwern renh antwerrkekemeh. ");
INSERT INTO amx_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","8","Ntwarrpemeh renh pawenhang, ntwang kel alhengk-aretjenh, nwern renh arratj anthwerr pawenhekarl.” Lakenh Tertullus-el rrtjwerremel ilek Paul-penh. ");
INSERT INTO amx_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Tjerrtj Jew inarl Tertullus-el-ayeng petjekarl, inang kwenh Tertullus rarteh rrtjwerremel angkek. ");
INSERT INTO amx_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Felix rang Paul renh kwerremel ilek, Paul rang ilelhetjeh. Paul rang renh ilek, “Twernk Felix-ay, ntwang kwenh year rrpwetj nwerneh twernk anek. Ntwang kwenh nwerneh kaltj anem. Lakenh yeng ngkweng arratj ilelhem. ");
INSERT INTO amx_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Yeng ngwerreh-lkwer war Jerusalem-warn petj-alpekarl, Altjerr-henh church angerretj-warn, kelkertel-ayeng arrernelhemel Altjerr naketjeh-anngernt, tjenkerr-arlkemeh kwer anthetjeh-anngernt. Yeng arratj ilelhem. Ntwang tjerrtj arrpenh ngwenh apek pawenhem, inang ngkweng angketj nyent kwet iletjenh. ");
INSERT INTO amx_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Tjerrtj nhenh inang yengenh lyet nakepakel-ilem, inang kaltj, yeng church angerretjel tjerrtj arrpenhel-ayeng itja ilterrek apek. Thang itja tjerrtj mer-areny map rrwampey-ilek, church inehenhel apek, keth arrpenhel Jerusalem kwerel apek. ");
INSERT INTO amx_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Inang yengenh lyet rrtjwerremel war nakepakel-ilem ngkwengeng ularr. ");
INSERT INTO amx_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Yeng ngkweng arratj ilelhem. Thang kelkertel-ayeng arrernelhemel Altjerr nakem, arrwekeleny nwern-kenh map inarl kelkertel-ayeng arrernelhemel renh nakekarl-arteh. Thang tjey Ngkart Jesu-kenh ingkentem, lakenheng twernk inang yengenh nakepakel-ilem, thang kwel tjey anetjel ingkentem. Yeng angketj Moses-kenheh kwet kangkwerrem, angketj Altjerr-henh angketj angenh-angenh map-henheh thwen ingkerrekeh. ");
INSERT INTO amx_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Yeng Altjerreh karelhem, inarl Altjerreh karelhem-arteh, rang irrernngepat map kemelh-iletjenharleh, tjerrtj mwerr map tjerrtj anetj map thwen. ");
INSERT INTO amx_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Lakenh yeng ahentj-anem, Altjerreng ularr tjerrtjeng ularr thwen merrentj-kwenh anetjeh. ");
INSERT INTO amx_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Yeng year rrpwetj mer arrpenh mapel anerl-apetjart, thangemeh tjenkerr maney ineheng kwetjemel angetj-alpek. Yeng ahentj-anek, Jerusalem-warn angkep petj-alpetjeh, thang tjerrtj maney-kweny map ineh tjenkerr maney anthetjeh, Altjerreh thwen tjenkerr anthetjeh-anngernt. Lakenh yeng Jerusalem-warn angkep petj-alpek. ");
INSERT INTO amx_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Yeng Altjerr-henh church angerretj-henh yard-warn irrpek, kwatjel-arlk lhewelhetjeh Moses-henh mpwareng-areng-angkwerr. Tjerrtj rrpwetjelemeh yengenh yard kwerel arek. Yeng itja aningkel-ayeng anek. Thang itja tjerrtj nyent rrwampey-ilek apek. ");
INSERT INTO amx_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Tjerrtj Jew Asia-areny rrpwetj church yard kwerel anek. Inang tjerrtj inenh rrwampey-ilek. Inang nhenh-warn petjemer, yengenh ngkwengeng ularr pawenhemer. Itja kwet, inang itja nhenh-warn petjek. ");
INSERT INTO amx_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Inang itja nhenhel anemarleng, tjerrtj Jew nhenh inang lyet irnemarl, inang ngwenh ilemer, nthakenh thang anetj mpwarekarl-penh kwel. Inang yengenh awek, yeng ilelhetjam Jew angerrepat mapeng ularr Jerusalem-el. ");
INSERT INTO amx_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Inang nheng yengenh pawenhekarleng, thang inenh lakenhant ilek, ‘Thang Altjerr renh nakem, rarl tjerrtj irrernng map kemelh-iletjenharl! Lakenheng arrantherr yengenh lyet pawenhem!’ ” Lakenh Paul rang ilelhek Felix-eng ularr. ");
INSERT INTO amx_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Felix rartek arrwekel-antey angketj Ngkart Jesu-akert awekarl. Rang inenh ilek, “Yeng ahentj, twernk atwenh-atwenh Lysias kwerenh angketj awetjeh-amparr. Kwerengant thang Paul-penh iletjeh, rang merrentj apek, itja apek.” Kwereng Felix rang tjerrtj ingkerrek court-eng lanthek. ");
INSERT INTO amx_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Felix-elemeh atwenh-atwenh twernk ilek, inang Paul renh atwenh-atwenh-henh warl kwenel karetjeh. “Ntwang peltj kwerenh mapeh impang, inang kwerel-ayeng yatjarr anetjeh apek, inang mernel-arlk kerel kwatj thwen renh wantetjeh.” ");
INSERT INTO amx_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Arltang rrpwetj-penh Felix Caesarea-warn petj-alpek, anew kwerenh Drusilla-akert. Drusilla rartek marl Jew anek. Felix rang Paul ngwek, renh awek, Paul rang renh-atherrenh angketj Jesu Christ-akert ilek, ratherr Jesu renh nakemer. ");
INSERT INTO amx_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Paul rang renh-atherrenh lakenh kaltj-anthek, ratherr Altjerreng ularr arratj mernelhetjeh. Rang renh-atherrenh ilek, ratherr mantj iterretjeh-amparr, anetj mpwarehetj. Rang renh-atherrenh ilek, arltang ingkernel Altjerrel tjerrtj ingkerrek judge-em-ilemel pawenhetjenharl. Felix-el nhenh awemel rang ater-irrek. Rang Paul renh ilek, “Kel impay, aherrk arrpenhek. Thang apek ngwenh weth ntangketjenh. Kel alpangemeh.” ");
INSERT INTO amx_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Felix rartek ahentj-anek, Paul-el renh maney anthetjeh, rang renh arratelh-iletjeh-anngernt. Lakenheng rang Paul kwer kweteth ntangkelhetjart, ratherr angkerretjeh. Paul rang itja maney kwer anthek. ");
INSERT INTO amx_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Felix rang ahentj-anek, tjerrtj Jew twernk map kwer kwet kangketjenheng, lakenheng rang Paul renh tjayeleh imperl-alhek. Rang itja renh arratelh-ilek. Year atherr-penh Rome-areny twernk angerrel Felix renh lanthek, artwang arrpenh arreny Porcius Festus-emeh arrernek, twernk anetjeh. ");
INSERT INTO amx_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Artwang Rome-areny arreny Festus petjek Caesarea-warn, twernk angerr anetjeh Jew mapek. Arltang rrpwetj-penh Festus Caesarea town-eng Jerusalem-warn alhek. ");
INSERT INTO amx_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Mer kwerelemeh, priest twernk mapel tjerrtj Jew angerrepat rrpwetjel thwen renh angketj Paul-akert ilek. ");
INSERT INTO amx_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Inang Festus renh pawenhek, rang Paul Jerusalem-warn angetjetjeh. Inang lakenh anyenng-anyenng war pawenhek, inartek ahentj-anekarleng, Paul renh tjeyel petjerleh renh irrernng atwetjeh. ");
INSERT INTO amx_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Festus-el inenh ilek, “Paul rang Caesarea-el arrwekel tjeng karelhem. Yeng arltang rrpwetj-penh Caesarea-warn angkep alpetjenh. ");
INSERT INTO amx_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Arrantherr ilem, rang artwang anetj kwel. Twernk rrpwetj arrehantherr-henh tjengel-ayeng petjetjeh, renh tjengeng ularr pawenhetjenheng.” Lakenh Festus-el inenh ilek. ");
INSERT INTO amx_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festus arltang 10-el Jerusalem-el inehel-arleng antarl-irrek. Kwereng rang Caesarea-warnemeh angkep alpek. Arltang arrpenhel rang court-warn irrpek, Paul renh ngwerl-alhemel. ");
INSERT INTO amx_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Paul rang court-warnemeh irrpek. Tjerrtj Jew Jerusalem-eng petjekarl map inang court-warn irrpek. Inang Paul kwer-warn arraw-irrek, renh pawenhetjeh. Inang ywarn renh pawenhek, angketj inehenh itja arratj anekarleng wart. ");
INSERT INTO amx_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Paul rang ilelhek, “Yeng merrentj-kweny anem. Thang itja mpwareng-areng nwern-henh arrkentj-ilek, Altjerr-kenh church angerretj renh apek. Thang itja twernk Caesar renh apek arrampewek.” ");
INSERT INTO amx_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Festus rang ahentj-anek, tjerrtj Jew map kwer kangketjeh. Lakenheng rang Paul renh pawenhek, “Ntwang key tjengel-ayeng petjemer Jerusalem-warn, inang ngwenh Jerusalem kwerel pawenhetjeh, tjengeng ularr?” ");
INSERT INTO amx_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Paul-el renh tjernemel ilek, “Itja, yeng ahentj-kweny. Nhenh yeng irnem ngkwengeng ularr. Ngwenh kwenh twernk angerr Caesar Rome-arenyel arrernek, twernk nhenhel anetjeh. Nhenhel ntwarrp yengenh pawenhetjeh! Ntwang kel kaltj anem, thang itja tjerrtj Jew map-henh mpwareng-areng arrkentj-ilek. ");
INSERT INTO amx_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Yeng apek merrentj anemeng, yeng kel ineh anthelhemer, inarrp yengenh irrernng atwetjeh. Yeng itja merrentj anem. Lakenheng ntwang itja yengenh tjerrtj Jew map-warn lanthetjeh. Kel twernk Caesar-warnant yengenh lanthang! Yeng ahentj, rang yengenh pawenhetjeh!” Lakenh Paul rang twernk renh ilek. ");
INSERT INTO amx_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Festus-el lakenh awemel rang artwang arrpenh mapel-ayeng-amparr angkerrek. Artwang nhenh inartek Rome-henh mpwareng-arengeh kaltj anek. Kwereng rang Paul renh ilek, “Ntwang wart ahentj-anekarleng, twernk angerr Caesar-el ngwenh pawenhetjeh, thang ngwenh kel Caesar kwer-warn lanthetjenh.” ");
INSERT INTO amx_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Kel arltang rrpwetj-penh King Agrippa town Caesarea-warn alhek, tjey kwerenh-akert, arreny kwerenh Bernice-akert. Agrippa rang king arrpenh anek. Rang kaltj anek Jew map-kenh mpwareng-arengek. Ratherr petjek twernk Festus-warn, kwerel-ayeng yatjarr anerl-alpetjeh. ");
INSERT INTO amx_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Arltang arrpenhel Festus King Agrippa-el-ayeng angketj Paul-penh angkerrek. Rang renh ilek, “Twernk arrpenh Felix-el-artek artwang nyent tjayeleh imperl-alhek. ");
INSERT INTO amx_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Yeng Jerusalem-el anetjamarleng, priest twernk map angerrepat map thwen inang tjeng-warn petjek. Inang Paul tjengeng ularr ilek, rang artwang merrentj anek kwel. Inang yengenh ilek, thang renh pawenhetjeh, renh irrernng atwetjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","“Thang inenh ilek, mpwareng-areng Rome-areny-henh arrpenh anem, nwern itja tjerrtj renh pelkel irrernngant atwetjeh. Inang renh alngetherr pawenhetjeh-amparr court-el. Kwereng tjerrtj rang ilelhetjeh-amparr. Ilelhekarlengant war thang renh merrentj apek iletjenh. ");
INSERT INTO amx_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Ngwerreh war tjerrtj Jew inang tjengel-ayeng nhenh-warn petjewarrek. Arltang arrpenhel yeng Paul-ehemeh ntangkelhek, thang angketj kwerenh awetjenheng. ");
INSERT INTO amx_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Tjerrtj Jew map inang kemerremel renh pawenhek. Yeng kel pal war iterrek, artwang rang anetj anthwerr mpwarekarleh-athen, lakenheng inang renh court-el ngkernewarrek pawenhetjeh. Thang alhengk-arekemeh, inang renh pelkel pawenhek. ");
INSERT INTO amx_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Inartek ilerrek Altjerr inehenh-penh, inang artwang irrernng-penh angkerrek, arreny kwerenh Jesu-penh. Paul rang ilek, artwang Jesu rang iteth kwel anerleh. ");
INSERT INTO amx_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","“Yengemeh ywarn iterrek. Thang Paul renh pawenhek, ‘Ntwang key tjengel-ayeng petjemer, inang ngwenh Jerusalem kwerel court-el pawenhetjeh?’ ");
INSERT INTO amx_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Paul rang angkek, ‘Itja! Yeng ahentj-anem, twernk angerr Caesar-elant yengenh pawenhetjeh.’ Lakenheng thang renh tjayelel kwet anyenem, thangemeh renh twernk Caesar-warn town Rome-warn lanthetjeh-anngernt.” Lakenh Festus-el King Agrippa renh ilek. ");
INSERT INTO amx_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","King Agrippa rang Festus renh ilek, “Yeng-artek ahentj-anem, artwang angketj kwerenh awetjeh-amparr.” Festus-el renh ilek, “Ntwang kel renh ngwenthant awetjenheng.” ");
INSERT INTO amx_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Arltang arrpenh kwerelemeh King Agrippa tjey kwerenh Bernice thwen ratherr Festus-henh warl angerr-warn irrpek, rnwanentj amparrkey anthwerr ratherr irrpekarl-akert. Atwenh-atwenh twernk map angerrepat mer-areny map thwen inang kwer-warn arraw-irretj-alhek. Kwereng Festus rang atwenh-atwenh nyent ilek, Paul renh ngwerl-alpetjeh. Kel rang Paul renh ngwek. ");
INSERT INTO amx_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festus rang angkek, “King Agrippay! Twernk map thwenay! Arrantherr key artwang nhenh arem? Tjerrtj Jew ingkerrekel artwang nhenh renh inang angerr nakepakel-ilek, Jerusalem-el town nhenh Caesarea-el thwen! Inang yengenh ilek, thang renh irrernng atwetjeh kwel. ");
INSERT INTO amx_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Thang inenh pawenhek, wenheng inang renh nakepakel-ilek. Inang ilek, rang anetj mpwarek. Angketj inehenh itja arratj anek. Thang itja renh pelkel irrernng atwetjenh. Rang angkekarleng, ‘Caesar-elant yengenh pawenhetjeh’, lakenheng thang renh Caesar kwer-warn lanthetjenh, town Rome-warn. ");
INSERT INTO amx_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Nthakenhameh thang angketj pip-warn arrernetjenh Paul kwer-akert? Thang ywarn iterl-arem. King Agrippay, lakenh kwereng yeng ngkweng ntangkelhek, arrpenh mapeh thwen, arrantherr renh mantj anthwerrel pawenhetjeh. Yeng ahentj-anem, ntwang angketj arratj yengenh iletjeh artwang Paul-akert, thang pip kwer tanthetjenheng, Caesar kwer-warn lanthetjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Caesar-el alhengk-aretjeh, Paul renh wenh-penh inang renh nakepakel-ilemeng.” Lakenh Festus rang King Agrippa ilek. ");
INSERT INTO amx_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","King Agrippa-elemeh Paul renh ilek, “Ntwang ilelhay.” Paul rang iltjang kwerremel tjerrtj inenh ntertelh-ilek. Kwereng rang ilelhekemeh. ");
INSERT INTO amx_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","3","“King Agrippay! Yeng kangkem, ngkwengeng ularr ilelhetjeh. Ntwang kwenh kaltj tjerrtj Jew nwern-henh mpwareng-arengeh, nthakenh nwern arrwekel angkerretjart thweneh. Tjerrtj nhenh mapel kwenh yengenh pelkel nakepakel-ilemel pawenhem. Inang ilek, thang mpwareng-areng nwern-henh arrkentj-ilek kwel. Yeng lyet ngkweng-warn ilelhem, yengenh mantjel awang. ");
INSERT INTO amx_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Tjerrtj Jew ingkerrek tjeng kaltj, yeng arratj kwet mernelhentjekarl kwer kwekeng-ntjel. Yeng lakenh mernelhek mer tjengenhel town Jerusalem-el thwen. ");
INSERT INTO amx_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Inang tjeng kaltj anentjekarl ngkweyeng-ntjel. Inang ngwenh arratj ilemer, yeng Pharisee anentjekarl, lakenheng yeng kweteth Moses-henh mpwareng-arengek mantj kangkwerrentjek. ");
INSERT INTO amx_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Kel yeng nhenhel irnem court-eng ularr, thang iterl-arem Altjerrelarl mpwaretjenh, nthakenh rang arrwekeleny nwern-henh mapek alhelek ngkwey. Rang inenh lakenh-atwetj alhelek, rang irrernngepat map kemelh-ilemel iteth-iletjenh. ");
INSERT INTO amx_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ngkweyeng-ntjel peltj map 12 pel aningkam-aningk Israel-areny map kweteth Altjerr nakentj-alhek, kelkertel-ayeng arrernelhemel. Nwernemeh lyet renh nakem, nthakenharl Altjerr ngkwey alhelek arrwekeleny nwern-henh map. Jew nhenh mapel yengenh pelkel nakepakel-ilek. Thang nakem, Altjerr rang mpwaretjenh, rarl alhelekarl-penh. ");
INSERT INTO amx_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Wenhengam arrantherr naketj-kweny iterrem, Altjerr rang itja arrwetj-penh map iteth-ilemel kemelh-iletjenh? ");
INSERT INTO amx_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Arrwekel thang Jesu Nazareth-areny-henh nakenh-nakenh map alwernemel atwerl-apetjart. Yeng iterrek, lakenh mwerr kwel anek. ");
INSERT INTO amx_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Yeng artwang atwenh-atwenh anetjart mer Jerusalem-el. Priest twernk mapel yengenh ilek, Jesu Christ nakenh-nakenh map antwerrketjeh kwet. Thang inenh antwerrkemel tjayel-warn kwernetjart. Council map angkerrekarleng, inenh apek irrernng atwetjeh, yeng lakenheh kangketjart. ");
INSERT INTO amx_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Yeng nakenh-nakenh mapeh palenthwerl-apetjart, church map-angkwerr, thang inenh nakepakel-iletjeh-anngernt. Thang nakenh-nakenh arrpenh map twernetjart, Jesu-henh arreny arrampewetjeh. Yeng town arrpenh map-arlk-warn alhetjart, inenh antwerrkemel angetj-alpetjeh. ");
INSERT INTO amx_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Arrpenh-ingar thang lakenh mpwarek. Yeng Damascus town kwer-warn tjeyel alhetjam. Arrwekel priest twernk mapel-artek yeng ilekarl, thang Jesu nakenh-nakenh map Damascus kwerel antwerrkemel angetj-alpetjeh. ");
INSERT INTO amx_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","King-ay, yeng arltang mpwepel alhep-alhetjam, thang arek parrtj angerrelemeh alkereng parrtjelh-ilentj-alherleh. Twernel-arteh parrtjelh-ilek angerr anthwerr. Parrtj rang yengenh, artwang rlkwatherr tjengel-ayeng alhetjamarl map thwen parrtjelh-ilek. ");
INSERT INTO amx_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Nwern ingkerrek ahelh-warn anyek. Thang awek, rang Hebrew angketjel tjeng-warn angkerleh, ‘Saul-ay, Saul-ay! Wenhengam ntwang yengenh atwetjek alwernem? Ntwang ahentj-anem, tjengel-ayeng atwerretjeh! Lakenh ntwang ngkwewaleny war atwelhem!’ ");
INSERT INTO amx_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Thang renh pawenhek, ‘Ngwenham ntwang? Ngkart angerr key?’ “Ngkart tjeng tjernemel ilelhek, ‘Yeng kwenh Jesu, ntwarl atwetjeh alwernem rang! ");
INSERT INTO amx_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Kel kemerremel irnang! Yeng-artek ngkweng mernelhem, thang ngwenh urrarem, tjengemeh ntwang rrkwapetjeh, ntwang tjerrtj map iletjeh, ntwarl yengenh arekarl-penh. Kelant ntwang inenh angketj arrpenh iletjenh, angketj nheng thang ngwenh iletjenh. ");
INSERT INTO amx_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Thang ngwenh tjerrtj arlaltj ngkwengenh map-warn tjerrtj lwereny map-warn thwen lanthem. Inang ngwenh atwehetjeng apek, thang ngwenh ineheng arntarnt-aretjenh. ");
INSERT INTO amx_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Thang ngwenh lanthem, ntwang inenh angketj tjengenh iletjeh, anetj inehenheng ntjwem-irretjeh, arrentj-henh angketjeng-arlk. Inang anetjeng Altjerr-warn twep-irretjeh, Altjerrel anetj inehenh wetjenheng. Rang inenh atwetj-kweny anetjenh, ngwerleny mernelhetjenh ineh. Inang yengenh nakemarleng apek, Altjerrel inenh tjerrtj arlaltj tjengenh mapel-ayeng nyentelh-iletjenheng, inenharl Altjerrel arrwekel arratj-ilekarl.’ ");
INSERT INTO amx_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“King Agrippay! Yeng kwenh Ngkartekant kangkwerrek, rang yengenh ilekarleng. ");
INSERT INTO amx_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Thang tjerrtj map kaltj-antherl-apek town Damascus kwerel-amparr, kwereng mer Jerusalem-elemeh mer Judea ntjaperelemeh thwen, tjerrtj lwereny map thwen. Thang inenh ilek, inang anetj inehenh impemel Altjerr-warn twep-irretjeh. Inang arratj mernelhetjeh, arrpenh mapel alhengk-aretjenheng, inang kel twep-irrekarl. ");
INSERT INTO amx_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Lakenheng tjerrtj Jew rrpwetj inang yengenh Altjerr-henh church angerretjel antwerrkek. Inang arrkernelhek, yengenh irrernng atwetjeh. ");
INSERT INTO amx_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Itja. Ngkweyeng-ntjel Altjerrelemeh yengenh arntarnt-arentjek. Lyet thang tjerrtj ingkerrek angketj Christ-akert ilem, twernk mapeng anngetherr tjerrtj anetj-anetj mapeng anngetherr thwen. Angketj tjengenh rang arratj anem. Altjerr-henh angketj angenh-angenh ngkweyeny mapel Moses-el thwen lakenh inang ilentjekarl. ");
INSERT INTO amx_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Inang ngkwey ilentjekarl, Christ rang nakepakel-irremel ilwetjenharl. Kwereng Christ rek-amparr arrwekel irrernngeng kemerretjenh. Kwereng rang tjerrtj arlaltj kwerenh mapeh tjerrtj lwereny mapeh thwen ineh angketj nhenh iletjenh, ‘Altjerr-henh parrtj kel petjekarl.’ ” ");
INSERT INTO amx_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Paul rang angketjamarleng, Festus rang arlkemel renh ilek, “Paul-ay, ntwartek ahert! Ntwang angerr kaltj-irremel perrpert-ilelhek!” ");
INSERT INTO amx_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Paul-el renh ilek, “Festus twernk angerray, yeng itja ahert. Angketj nhenh yeng angkemarleng arratj anem. ");
INSERT INTO amx_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Christ kwenh tjerrtjeng alngetherr ilwek, kwereng rang iteth-irremel kemerrek. Angketj nhenh itja arlweperr anem. King nhenh kwenh angketj nhenhek kaltj. Lakenheng yeng kwer-warn anew-anew kwet angkem.” ");
INSERT INTO amx_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Paul-elemeh King Agrippa renh pawenhek, “Ntwang Altjerr-henh angketj angenh-angenh map-henh angketj nakem key? Yeng kaltj, ntwang angketj inehenh nakem.” ");
INSERT INTO amx_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","King Agrippa-elemeh Paul renh ilek, “Ntwang key iterl-aremam, thang kwek war awekarl-penh, thang kel Christ renh naketjenharl? Itja apek.” ");
INSERT INTO amx_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Paul-el renh ilek, “Ntwang key kwek war apek angerr apek kaltj-irrekarl, kel. Thang Altjerr tjang-pawenhem ngkweng tjerrtj mapek-arlk, inarl yengenh lyet awem, arrantherr Christ nakenh-nakenh anetjeh yeng-arteh, lakenh-hetj chain-kweny anetjeh.” ");
INSERT INTO amx_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Kel inang angketj renh impekemeh. King Agrippa twernk Festus Bernice thwen inang kemerrek, tjerrtj inehel-arleng anetjamarl map inang kemerrek. ");
INSERT INTO amx_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","Kwereng twernk inarrpemeh room kwereng arratenhemel angkerrenhek, “Artwang nhenh itjam merrentj. Nwern renh itja pelkel atwem. Nwern itja renh tjayelel kwet anyenetjeh.” ");
INSERT INTO amx_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","King Agrippa-elemeh Festus renh ilek, “Rang arrwekel nheng nwernenh pawenhek, rang Caesar aretjeh, renh kwel Caesar-elant pawenhetjenheng. Kel nwern renh Caesar-warn lanthetjehemeh!” ");
INSERT INTO amx_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Twernk Festus rang iterrek, Paul renh mer Rome-warn lanthetjeh, twernk angerr Caesar-warn. Lakenh rang Paul renh tjayel-areny rrpwetj arrpenh thwen atwenh-atwenh twernk nyent-warn lanthek, rang inenh Rome town-warn angetjeh. Atwenh-atwenh twernk Rome-areny kwerenh arreny Julius anek. ");
INSERT INTO amx_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Nwern boat angerr nyent-warn antjek. Boat nhenh town Adramyttium-eng petjekarl, mer Asia-warn alhetjeh-anngernt. Nwern boat kwer-warn antjemel nwern alhek-antem kwatj alay-angkwerr, mer Asia-warn. Artwang Macedonia-areny arreny Aristarchus rarl Thessalonica town-el anetjart, rang nwernehel-arleng alhek. ");
INSERT INTO amx_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Arltang arrpenhel nwern kel town Sidon-eh irretj-alhek. Julius rang kangkentj anek Paul-ek. Rang Paul renh ilek, peltj kwerenh map-warn inenh arerl-alpetjeh. Paul rang boat kwereng anarnpemel-arteh alhek peltj kwerenh map-warn. Inang kwer mern-arlk anthek. Kwereng rang petj-alpek boat-warn mern-arlk-akert. ");
INSERT INTO amx_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Nwern weth kwatj-warn irremel boat-el alhek, irlkang angerrel nwernenh atwentjek, lakenh nwern mer island Cyprus-eng rtwang war alhetjam, tak-angkwerr. ");
INSERT INTO amx_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Kwereng nwern mer Cilicia-eng mer Pamphylia-eng antekerrarl kwet alhetjam. Nwern town Myra kwer irretj-alhek. Myra rartek Lycia-el artelhek. Nwern boat-eng anarnpetj-alhek town kwerel. ");
INSERT INTO amx_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Twernk Julius rang boat angerr arrpenh arek, town Alexandria-eng petjekarl. Boat nhenh rang mer Italy-warn alhetjeh anetjam. Lakenheng Julius rang nwernenh ilek, boat nhenh kwer-warn antjetjeh. ");
INSERT INTO amx_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Kwereng nwern boat angerrel kwatj-angkwerr alhekemeh. Nwern arltang rrpwetj mantj alhetjam town Cnidus-warn. Nwern atjernp kwet alhek, ywarn Cnidus-warn itwek-irrek, irlkang angerrel wernetjam-rlwer. Kwereng nwern antekerr-atheh alhek, mer island Crete-warn-atheh, tak-angkwerr alhetjeh. Nwern town Salmone-warn-atheh itwek-irremel anper alhek, antekerr-atheh kwet. ");
INSERT INTO amx_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Kwereng nwern altwerl-athehemeh alhetjam, Crete kwereng antekerr-ampenyel alhetjeh. Nwern-artek Crete kwereng rtwang war alhetjam, atjernp kwet. Irlkang angerr kwet wernetjam. Nwern mer Fair Havens-el irretj-alhek. Mer Fair Havens rartek Lasea town-eng rtwang war anek. ");
INSERT INTO amx_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Nwern kwerel anetjamarleng, nwern iterrek, “Ay! Nwern atjernp kwet petjek. Lyetemeh kel lhwerrpemeh anem, tjerrtj Israel-areny mapel kel arltang irlpangkentj anyenek. Nwern apek anper alhem, irlkang angerrel apek boat renh ltwakehetj!” Paul-elemeh artwang inenh ilek, ");
INSERT INTO amx_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“Artwang mapay! Yeng kaltj, nwern apek anper alhemeng, nwern imampwerl-warn irretjenh. Boat rang ltwakelhetjenh. Nwern rnwanentj ingkerrek parlp-iletjenh, nwern ingkerrek ilwetjenh.” ");
INSERT INTO amx_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Twernk Julius rang Paul-eh itjarl kangkwerrek. Rang boat angenh-angenh boat-ek-artwey thwen kwer-atherrant kangkwerrek. ");
INSERT INTO amx_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Mer Fair Havens rang itja tak mwerr anek boat-ek, nheng lhwerrpel irnetjeh. Lakenh boat-el anetjam map ahentj-anek, town Phoenix-warn anper alhetjeh. Phoenix kwerel tak mwerr anek. Phoenix rang nwerneheng altwerl anek, mer Crete-el. Boat-el anetjam map ahentj-anek, town Phoenix kwerel lhwerrpel anetjeh. ");
INSERT INTO amx_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Arltang nyent kwerel irlkang kwek antekerreng wernetjam. Inang iterrek, “Nwern war arrkernelhey, Phoenix kwer-warn anper irretjeh.” Inang boat rlwek, kwatj alay iter-angkwerr kwet alhetjam, Crete-eng antekerr. ");
INSERT INTO amx_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Kwereng irlkang angerrelemeh boat renh ayerrer ingerreng atwentj-alhek, mer island kwereng atwentj-alhek. ");
INSERT INTO amx_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Irlkang angerrel boat renh altwerl antekerr-atheh angetjam. Nwern boat renh impek, rarrp antekerr-atheh alhetjeh. ");
INSERT INTO amx_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Irlkang rang nwernenh mer island kwek iter tak-angkwerr kwer-warn-atheh angek, arreny kwerenh Cauda-warn. Nwern boat kwek kerneh tjwenek, boat nheng boat angerrel tjarr-angetjam. Rrkwapentj angerr anthwerr anek nwerneh. ");
INSERT INTO amx_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Inang boat kwek renh boat kern-warn ayernek. Kwereng inang rope map boat angerr kweneng-ampeny arrernek, boat rope mapel ayernek twer-ilemel, irlkel nwernenh kwet angetjam-rlwer. Nwern ater-irrek, boat rang lhereh kwatj kweneng mwernelhehetjeng mer Syrtis iterel. Inang kalikew sail renh rlwemel kwen-ilek, boat renh atjernpelh-iletjenheng. ");
INSERT INTO amx_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Irlkang rang angerr kwet wernetjam. Lakenheng arltang arrpenhel inang boat-eng rnwanentj kwatj-warn wek, mern wheat-akert-arlk thwen. ");
INSERT INTO amx_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Kwereng arltang rrpwetj-penh inang boat-henh sail-arlk ropes-arlk kwatj-warn wek. ");
INSERT INTO amx_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Arltang rrpwetjeh-atwetj nwernemeh aherrk renh kwerraly map thwen itja arek, irlkang rang angerr kwet wernetjam. Nwern iterrek, nwern ingkerreny ilwetjenharl. ");
INSERT INTO amx_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Nwern arleng-alentj mern-kweny anek angayelemeh. Paul-elemeh artwang inenh irlpangkelh-ilemel ilek, “Arrantherr kangkwerremer tjeng. Nwern apek mer Crete-el kwet anemer, boat rang mwerr kwet anemer, rnwanentj ingkerrekemeh mwerr kwet intemer. ");
INSERT INTO amx_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Arrantherr itja ater-irremel kwerrern-kweny-irretjeh. Arrantherr itja ilwetjenh. Boat rant tjep-akelhetjenh. ");
INSERT INTO amx_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Altjerr rang tjeng-artwey anem, thang renhant nakem. Kwenyel rang tjeng-warn angel lanthek. ");
INSERT INTO amx_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","Angel rang yengenh ilek, ‘Paul-ay, itja ntwang ater-irretjeh. Altjerr rang ahentj-anem, ntwang twernk angerr Caesar-eng ularr ilelhetjeh. Altjerr rang kangkentj anemeng wart, rang artwang ingkerrek kwatjeng arntarnt-aretjenh ngkwengel-arleng.’ ");
INSERT INTO amx_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Arrantherr itja ater-irretjeh. Thang Altjerr renh nakem. Angketj kwerenh arratj anem. Rang nwernenh kwatjeng arntarnt-aretjenh. ");
INSERT INTO amx_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Boat nhenh rang nwerneh-akert mer arrpenhel mwernelhetj-alhetjenh.” Lakenh Paul-el inenh ilek. ");
INSERT INTO amx_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Nwern arltang 14 kweny 14-eh-atwetj kwatj alay kwerel anek, irlkang rang boat renh kwet angerl-apetjamarleng altwerl-atheh. Kwatj alay arreny kwerenh Adriatic. Kweny mpwepel boat-henh rrkwapenh-apenh map iterrek, nwern itwekemeh irrek ahelh kwer-warn-atheh. ");
INSERT INTO amx_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Inang rope iron thwen kwentj atherr kwatj-warn wek, aretjeh kwatj rang apek kwen angerr anehetj. Inang rope renh kwatjeng angkep tjarr-inek. Inang arek kwatj rang 37 metres kwen angerr anerleh. Kwereng inang rope weth kwatj-warn wek. Inang arek kwatj rang 27 metres kwen angerr anerleh. ");
INSERT INTO amx_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Boat-henh rrkwapenh-apenh map ater-irrek, boat pwertel apek atwehetjeng. Lakenheng inang anchor 4 pel kwatjeh wek boat-eng ingkernel, boat renh atjernpelh-iletjeh. Kwereng inang aherlkentjeh karelhek, keth aretjenheng. Inang Altjerr renh pawenhek, “Parrp parrtj mpwaretjeh, nwern keth aretjenheng!” ");
INSERT INTO amx_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Kwereng boat-henh rrkwapenh-apenh inang iterrek, boat angerr imperl-alhemel alwerretjeh. Inang boat kwek inemel kwatj-warn anarnpelh-ilek, arrpenh mapek rrtjwerremel ilek, inang kwel anchor arrpenh boat-eng wek. ");
INSERT INTO amx_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Paul-elemeh inenh aremel, rang twernk Julius atwenh-atwenh map thwen ilek, “Artwang nhenh map apek boat-eng alwerretjenh, Altjerrel arrantherrenh itja arntarnt-aretjenh, arrantherr kwatjel-ayel ilwetjenh. Inang boat-el kwet anetjeh!” ");
INSERT INTO amx_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Atwenh-atwenh mapelemeh rope renh akek, rope rarl boat kwek renh antwerrketjam. Boat kwek rang kwatj-warn anyek. ");
INSERT INTO amx_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Aherlkentj mpank anek. Paul rang artwang ingkerrek inenh arlkwetjeh ilek. Rang inenh ilek, “Arrantherr kwenh arltang 14-eh-atwetj ater-ater war anek. Arrantherr mern itja arlkwek. ");
INSERT INTO amx_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Kel mern arlkwerrerrang, arrantherr ingkerrek ilwehetjeng.” ");
INSERT INTO amx_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Kwereng Paul rang mern inek. Rang ineheng alngetherr Altjerr-warn yatey angkek. “Ntwang kwenh nwerneh kangkentj mernelhek, mern nhenh nwerneh anthemel.” Paul-el mern kwek ltwakekarl-penh rang arlkwekemeh. ");
INSERT INTO amx_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Inang renh arekarl-penh inang twerelemeh mern arlkwek. ");
INSERT INTO amx_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Artwang nwern 276 pel boat kwerel anek. ");
INSERT INTO amx_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Inang ingkerrekel kel mernemeh arlkwek. Boat rang mern wheat angerr-akert anekarleng wart, inang mern wheat yakwethel-ayel inemel alay-warn taly-wek. ");
INSERT INTO amx_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Aherrk rang lyet-atheh arratetjamarleng, boat-henh rrkwapenh-apenh inang arnkarr arek. Inang itja mer alhengk-arek. Inang arnkarr mwerr renh keth aremel, inang ahentj-anek, boat renh arnkarr-warn-atheh antjelh-iletjeh. ");
INSERT INTO amx_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Lakenheng inang anchor map-henh rope akek, anchor map kwatj-warn mentj taly-wek. Inang boat turn-em-ilek, rang arnkarr-warn-athek arratj kwet alhetjeh. Kwereng inang kalikew sail rlwang kern-ilek, irlkel boat renh arnkarr-warn-atheh angetjenheng. ");
INSERT INTO amx_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Kel kwatj kweneng lher theltj anek. Boat rlwangel lher renh atwek, rang kel mwernelhekemeh lher kwerel. Kwereng kwatj angerrel boat ingkern-ampeny ngkweltj-ilek. ");
INSERT INTO amx_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Atwenh-atwenh mapemeh iterrek, inang tjayel-areny ingkerrek irrernng atwetjeh, inang pwerlp-irremel alwerrehetjeng kwel inehetj. ");
INSERT INTO amx_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Twernk Julius rang ahentj-anek, Paul renh iteth anyenetjeh. Lakenheng rang atwenh-atwenh kwerenh map arnpakek. Rang arrpenh map ilek, inarl kaltj anek pwerlp-irretjeh, inang kwatj-angkwerr arnkarr-warn-atheh alhetjeh. ");
INSERT INTO amx_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Akwen map rang ilek, inang arnang ltwakekarl kwerel-ayeng antjenhetjeh arnkarr-warn-atheh. Kel nwern mwerr kwet arnkarr kwer-warn irretj-alhek. ");
INSERT INTO amx_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Nwern ingkerreny arnkarrelemeh anetjam, mer kwer-areny mapel nwernenh ilek, mer arreny kwerenh Malta anek. Mer Malta rang island anek, kwatj alay mpwepel. ");
INSERT INTO amx_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Mer-areny inang nwerneh kangkentj anthwerr mernelhek. Inang nwerneh rwang itek nywatey-rlwer, kwatjel anhetjam-rlwer. ");
INSERT INTO amx_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Paul-elemeh rwang irrweltj map kwetjemel rwangeh arrernek. Amwang rwangeng arratemel renh iltjang nhwek. ");
INSERT INTO amx_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Mer-areny mapel Paul renh arek, amwang iltjang kwerenheng arlparernerleh, inang lakenhemeh iterrek, “Artwang rang lyet itja kwatjel ilwek, rang lyet kel amwang nhenh-penhemeh ilwetjenh! Lakenhan rang merrentj apek anem!” ");
INSERT INTO amx_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Paul rang amwang renh rwang-warn taly-wek. Rang itja irlkert-irrek. ");
INSERT INTO amx_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Mer-areny mapel renh kwet aretjam. Inang aretjam, mpwerrk kwerenh wangketjeh apek, rarrp irrernng ilwerl-alhetjeh apek. Inang renh kweteth aretjam, Paul rang mwerr kwet anek. Inang lakenh iterremel angkerrek, “Artwang nhenh-artek altjerr apek anem!” ");
INSERT INTO amx_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Artwang Publius rang mer kwer twernk angerr anek. Farm nyent kwerenh anek, nwerneheng rtwang war. Publius rang nwernenh warl kwerenh-warn anginek, yatjarr kwerel-ayeng anerl-alpetjeh. Nwern arltang rrpwetj kwerel-ayeng anerl-alpek. ");
INSERT INTO amx_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Nwern awek, Publius-kenh angey irlkert angerr intetjam ampeltjey-penh. Paul kwer-warn alhemel rang Altjerr tjang-pawenhek kwer. Kwereng rang iltjang kwerenh artwang irlkert-arleh arrernek. Publius-kenh angey rang mwerr-irrekemeh. ");
INSERT INTO amx_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Tjerrtj irlkert inang angketj nhenh-penh awekarleng, inang Paul-warn petjewarrek mer mapeng. Paul-elemeh inenh ingkerrek mwerr-ilek. ");
INSERT INTO amx_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Tjerrtj inang nwernenh angerr nakek. Atay rrpwetj nwern mer kwerel anekarl-penh nwern boat arrpenh-warn antjetjeh irremeng, inang nwernenh mern-arlk ker-arlk rnwanentj-arlk angerr anthek, boat-el arlkwetjenheng. ");
INSERT INTO amx_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Malta kwerel boat angerr arrpenh anek, lhwerrpelarl arrwekel kwet petjekarl. Boat rang Alexandria town-eng petjekarl. Altjerr-arrpantey atherram arnang-penh mpwarekarl inang boat-eng arrwekelel arrernekarl. Altjerr-arrpantey-henh arreny kwer-atherr-henh Castor, arrpenh-henh Pollux. Alhwerrpel nwern Malta kwerel 3 months-ek-atwetj anekarl-penh kel nwern boat nhenh kwer antjemel, kwatj alayel-anem kwet alhek. ");
INSERT INTO amx_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Nwern Syracuse town kwerel irretj-alhek, nwern boat-eng anarnpemel arltang rrpwetjeh mer kwerel interl-alhek. ");
INSERT INTO amx_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Kwereng nwern mer renh imperl-alhemel, boat-warn antjemel alhek ayerrer-athek. Nwern Rhegium town-el irretj-alhek, kweny nyent interl-alhek kwerel. Arltang arrpenhelemeh irlkang antekerreng wernek. Nwern mer renh imperl-alhek, arltang nyentel kwatj alay-angkwerr alhekarl-penh, kel arltang arrpenhelemeh nwern mer Puteoli-el irretj-alhek. Nwern boat-eng anarnpemel alhekemeh. ");
INSERT INTO amx_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Town kwerel nwern nakenh-nakenh rrpwetj arek. Inang nwernenh ayakek, inehel-arleng week nyent anerl-alhetjeh. Kwereng nwern Rome town-warn ingkang tjeyek-irrenhek. ");
INSERT INTO amx_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Nakenh-nakenh Rome-areny mapel awek, nwern petjerleh. Inang nwerneh-warn arnekarner petjek. Inang nwernenh mer Appius-el Warl Angerr Rrpwetjel thwen aretj-alhek. Paul rang inenh aremel arrken awelhek. Kwereng rang Altjerr kwer-warn kangkemel angkek, “Mwerr ntwang nhenh map angetjek!” ");
INSERT INTO amx_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Nwern Rome-eh irretj-alhemel twernk Julius-el Paul renh impek, rarrp warlel anetjeh. Rang atwenh-atwenh nyent ilek, renh karetjeh. ");
INSERT INTO amx_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Arltang rrpwetj-penh Paul rang angketj lanthek tjerrtj Jew angerrepat map-warn, inenh ngwerl-alpetjeh. Inang kel kwer-warn arraw-irrek. Paul ineheng ularr ilelhek, “Artwang peltj mapay! Yeng tjerrtj tjengenh mapeh anetj mpwaretjal anek. Thang itja arrwekeleny nwern-henh map-henh mpwareng-areng arrkentj-ilek. Jerusalem-el tjerrtj mapel yengenh antwerrkemel twernk Rome-arenyek anthek. ");
INSERT INTO amx_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Rome-areny twernkel yengenh pawenhekarl-penh, rang alhengk-arek, yeng artwang pelkeny anerleh. Rang ahentj-anek, yengenh tjayeleng arratelh-iletjeh. ");
INSERT INTO amx_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Tjerrtj Jew twernk map inang yengenh nakepakel-ilek kwet. Lakenheng yeng angkek, ‘Yeng kel ahentj-anem, twernk Caesar-elant yengenh pawenhetjeh!’ Yeng itja ahentj-anem, Caesar-eng ularr tjerrtj nwerneh-artwey map pawenhetjeh apek. ");
INSERT INTO amx_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Nhenheng arrngel thang arrantherrenh ngwek: yeng arrehantherreng ularr ilelhem. Yeng kwenh lyet chain-akert anem, inang yengenh ayernekarl, thang Altjerr-henh alhelentj renh nakekarleng. Alhelentj nheng Altjerrel tjerrtj Israel-areny map-warn Arntarnt-arenh-arenh lanthetjenh.” Lakenh Paul rang ineh ilelhek. ");
INSERT INTO amx_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Angerrepat inang Paul renh ilek, “Tjerrtj Judea-areny mapel itja pip nwerneh-warn lanthek angketj ngkweng-akert. Tjerrtj Jew Judea-eng petjekarl mapel itja angketj anetj ngkweng-akert ilek. ");
INSERT INTO amx_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Nwern ahentj-anem, ngwenh awetjeh. Nwern-arteh awek, tjerrtj map tjerrtj Jesu nakenh-nakenh mapek inang ahentj-kweny anerleh, ahelh apanpel.” Lakenh inang Paul renh ilek. ");
INSERT INTO amx_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Inang ilerrek, arltang arrpenhel weth arraw-irretjeh, Paul renh awetjeh. Arltang kwerel inang Paul-warn petjek, arrpenh map-arlk petjek. Paul rang inenh ilek, kweny-rtweheng-ntjel angwerr-angwerreh-atwetj. Rang inenh ilek, Altjerr rang tjerrtj ingkerrekeh Ngkart angerr anemeng. Rang inenh kaltj-anthek Moses-henh mpwareng-areng-penh, Altjerr-henh angketj angenh-angenh map-henh angketj-penh thwen, inarl angketj Jesu-penh ilekarl. ");
INSERT INTO amx_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Arrpenh mapel Paul nakek, arrpenh mapel itjarl. ");
INSERT INTO amx_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Inang ilterrekemeh. Paul-elemeh arek, Jew arrpenh map kwer kangkwerretj-kweny anek, inangemeh alpetjeh anek, lakenh rang inenh ilek, “Kwerrern Alngaltarel lakenh ilek Altjerr-henh angketj angenh-angenh Isaiah-el-arleng, rang nheng angerrepat arrehantherr-henh ilekarl, ");
INSERT INTO amx_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Tjerrtj nhenh map-warn inenh ilerl-alhang, “Arrantherr angketj Altjerr-kenh kweteth awerl-anem, kel angketj nhenh awekarl-penh arrantherr kwet iterl-aretj-kweny anem. Arrantherr kweteth arerl-anem, nthakenharl Altjerrel mpwarem, arrantherr kwet iterl-aretj-kwenyarl, wenharl rang arrantherrenh kaltj-anthetjeh ahentj-anem. ");
INSERT INTO amx_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Tjerrtj mapel itja iterl-arem inang marnt anemeng wart. Inang irlpang-akertarl, kenh inang awemel iterl-aretj-kwenyarl. Inang anngangarl martelhek, inarl ahentj-kweny anem aretjeh, nthakenh Altjerrel mpwaremeng. Inang apek arratj awemel kangkwerremeng, nthakenharl Altjerrel inenh ilemeng, kel inang aremel iterl-aretjenheng, wenh apek Altjerr rang mpwarerleh. Lakenh mpwaremel inang apek twep-irretjenheng tjeng-warn, thangemeh inenh mwerr-iletjenheng.” ’ ” ");
INSERT INTO amx_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Paul-el inenh ilek, “Arrantherr kaltj anetjeh angketj Altjerr-kenh, nheng Altjerr ahentj-anem, tjerrtj map inetjenh, inang ngampekarl iteth anetjenheng kwerel-ayel. Kel thang angketj nhenh tjerrtj lwereny mapemeh iletjenh. Inang kwenh angketj nhenheh kangkwerretjenh!” ");
INSERT INTO amx_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Kwereng tjerrtj Jew map inang alpekemeh. ");
INSERT INTO amx_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Paul rang year atherr kwet anek, warl nyent rang rent-em-ilemel anek. Rang tjerrtj ingkerrekeh peltj mernelhetjart, inarl kwer-warn yatjarr petjetjart. ");
INSERT INTO amx_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Paul rang inenh anew-anewel kwet kaltj-anthetjart, Altjerr rang tjerrtj kwerenh map-warn petjekarl, rang ineh Ngkart angerr anemeng. Rang inenh kaltj-anthetjart angketj Ngkart Jesu Christ-akert. Nyentel apek renh itja arnpakek. ");
INSERT INTO amx_vpl VALUES ("H11_1","082_1_1","1TH","1","1","1","Paul, Silas, Timothy nwern pip nhenh arrehantherr-warn lanthem, arrantherr werlampareny Thessalonica town-el anem map-warn. Arrantherr Altjerr Angey-henh anem, Ngkart Jesu Christ-henh thwen. Nwern Altjerr tjang-pawenhem, rang arrehantherr kangkentj kwet mernelhetjeh, arrantherr ater-kwenh ngwerleny anetjenheng. ");
INSERT INTO amx_vpl VALUES ("H11_2","082_1_2","1TH","1","2","3","Nwern Altjerr-warn angkemarl-rlwer, nwern kweteth arrehantherr iterremel irlpangkem. Nwern Altjerr renh ilem, arrantherr renh nakemeng, arrantherr kwenp kwet rrkwapetjam kwer, parrk-kweny. Arrantherr tjerrtj arrpenh mapeh tangetjel anekarleng, arrantherr ineh nyerrkentj mernelhekarleng. Arrantherr anew-anew tjwempelhem Ngkart Jesu Christ rang petj-alpetjeh-atwetj. Lakenh nwern renh ilem. ");
INSERT INTO amx_vpl VALUES ("H11_4","082_1_4","1TH","1","4","4","Peltj mapay, Altjerr kwenh arrehantherr nyerrkem. Nwern kaltj, rang arrantherrenh urrarekarl, peltj kwerenh anetjeh. ");
INSERT INTO amx_vpl VALUES ("H11_5","082_1_5","1TH","1","5","5","Nwern nheng arrantherrenh angketj mwerr kaltj-anthekarleng, Kwerrern Alngaltarel angketj nwern-henh renh twer-ilek, arrantherr angketj renh naketjenheng. Arrantherr kaltj, nwern arratj mernelhek, nwern arrehantherrel-ayeng anetjam-rlwer. ");
INSERT INTO amx_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","Arrantherr angketj mwerr nakek, arrantherr tjey nwern-henhel ingkern-angkwerr petjewarrek, Ngkart-henh tjeyel. Arrpenh mapel nheng arrantherrenh atwetjeh alwernek, arrantherrenh nakepakel-ilek. Kenh Kwerrern Alngaltarel arrantherrenh twer-ilemel tjep-tjep-ilek. Arrantherr angketj mwerr renh arrken awelhemel nakek. ");
INSERT INTO amx_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","Lakenh arrantherr kwenp mernelhek, nakenh-nakenh arrpenh mapel arrantherrenh aremel inang-arlk Ngkart-kenh angketj twerel naketjenh-arlk. Nakenh-nakenh nhenh map anem mer Macedonia-el mer Achaia-el thwen. ");
INSERT INTO amx_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","Arrantherr tjerrtj nhenh map kaltj-anthekarl-penh, inang tjerrtj arrpenh map mer ntjaperel kaltj-antherl-apekarl. Tjerrtj mapel Ngkart-henh angketj awek mer Macedonia ntjaperel mer Achaia ntjaperel thwen. Tjerrtj ingkerrek inang kaltj, arrantherr Altjerr renh nakemeng. Nwernehemeh itja anem, weth inenh arrehantherr-akert iletjeh. ");
INSERT INTO amx_vpl VALUES ("H11_9","082_1_9","1TH","1","9","9","Tjerrtj nhenh inang ilem, arrantherr nwernenh nyerrkemel ngwek, arrantherr altjerr-arrpantey pwert-penh mpwarekarl map mentj impekarl, Altjerr iteth kwer rrkwapetjeh-anngerntarl. Altjerr kwenh ngwerrm anem. ");
INSERT INTO amx_vpl VALUES ("H11_10","082_1_10","1TH","1","10","10","Inang ilem, arrantherr kel tjwempelhem Altjerr-henh Lereh, alkereng petj-alpetjenharl. Ler rang petj-alpetjenh, renharl kemelh-ilek irrernng-penh. Ler-kenh arreny Jesu anem. Arltang ingkernel rang nwernenh Altjerr-henh aheng inemel anginetjenh, nwern kwerel-ayel iteth ngampekarl anetjenheng. ");
INSERT INTO amx_vpl VALUES ("H12_1","082_2_1","1TH","2","1","1","Peltj mapay, arrantherr kel kaltj, nwern arrantherrenh itja pelkel kaltj-anthek. Arrantherr irlpareth kaltj-irrekarl. ");
INSERT INTO amx_vpl VALUES ("H12_2","082_2_2","1TH","2","2","2","Arrantherr irlpangkem key, nwern mer Philippi-warn-ek-amparr alhekarl, inang nheng nwernenh mer kwerel arrampewemel atwek? Mer-areny inang nwerneh alharlkwemel anpwek. Lwerenh-penh nwern arrehantherr-warnemeh petjek. Altjerrel nwernenh twer-ilek, nwern arrehantherr angketj mwerr kwerenh anew-anewel kwet kaltj-anthetjeh. ");
INSERT INTO amx_vpl VALUES ("H12_3","082_2_3","1TH","2","3","3","Nwern arrantherrenh arratj kwet kaltj-anthek, rrtjwerretj-kwenyel. Nwern itja ahentj-anek, maney arrehantherr-henheh kaltj-anthetjehant war. Nwern ahentj-anek, tjerrtj mapel Altjerr renhant naketjeh, itja nwernenh naketjeh. Nwern war kaltj-anthenh-anthenh anem. Altjerr-kenh tjey tjetjeny-iletjeh. ");
INSERT INTO amx_vpl VALUES ("H12_4","082_2_4","1TH","2","4","5","Altjerrel nwernenh arrkernek, kwer-penh rang ilek, nwern arratj anemeng. Lwerenh-penham rang nwernenh ngkernek, angketj mwerr renh kaltj-anthetjeh. Nwern ahentj-anem, Altjerr rant nwern naketjehan. Itja tjerrtj-arrpwetjel nwernenh naketjehan. Arrantherr kaltj, nwern itja arrantherrenh rrtjwerremel ilek. Angketj arratj kwenh arrantherrenh ilek. Altjerr rang kaltj, nwern itja maneyeh arrantherrenh kaltj-anthek. ");
INSERT INTO amx_vpl VALUES ("H12_6","082_2_6","1TH","2","6","6","Nwern itja ahentj-anek, arrantherr nwernenh naketjeh, tjerrtj arrpenh mapel apek. Nwern arrehantherr-warn alhek, Christ-el nwernenh lanthekarl. Nwern kaltj-anthenh-anthenh tjeperr kwerenh anemengarl wart, nwernehan anek, arrantherrenh ankeyel merneh-arlk pawenhetjehan war. Nwern itja arrantherrenh pawenhetjeh anekan. ");
INSERT INTO amx_vpl VALUES ("H12_7","082_2_7","1TH","2","7","7","Nwern mantj-mantj arrehantherrel-ayeng rrkwapek, lakenhant. Mwek ngwenhel apek kwer kwek inehenh mantj-mantj-ilemeng, lakenh-arteh nwern mantj-mantj arrehantherrel-ayeng anek. ");
INSERT INTO amx_vpl VALUES ("H12_8","082_2_8","1TH","2","8","8","Nwern arrehantherr angerr nyerrkekarl, nwern arrantherrenh angketj mwerr renh kaltj-anthentjek. Nwern arrken awelhek. Nwern ahentj-anek, nyent kwet arrehantherrel-ayeng anetjeh, peltj anetjeh. ");
INSERT INTO amx_vpl VALUES ("H12_9","082_2_9","1TH","2","9","9","Peltj mapay, arrantherr irlpangkem, nwern kweteth rrkwapentjek, mern nwern-henh aretjeh rrkwapek, arltang arrpanenhel nwern arrehantherrel-ayeng kaltj-anthekarl-rlwer. Lakenh nwern Altjerr-henh angketj mwerr itja pelkel kaltj-anthentjek, nwern itja arrehantherr merneh nkek. ");
INSERT INTO amx_vpl VALUES ("H12_10","082_2_10","1TH","2","10","10","Nwern anekarl arrehantherrel-arleng, arrantherr arek, nwern arratj kwet mernelhek. Altjerrel-arlk alkereng arek. ");
INSERT INTO amx_vpl VALUES ("H12_11","082_2_11","1TH","2","11","11","Arrantherr kaltj, nwern arrantherrenh arntarnt-arekarl, tjerrtj ngwenhel apek ler kwerenh arntarnt-aremarl-arteh. Lakenh. ");
INSERT INTO amx_vpl VALUES ("H12_12","082_2_12","1TH","2","12","12","Nwern arrantherrenh alngwelng-ilemel tjep-tjep-ilek. Nwern arrantherrenh twer-ilek, arrantherr arratj mernelhetjeh. Lakenh Altjerr rang arrken awelhetjenh arrehantherr. Iterl-arang, Altjerrel arrantherrenh urrarekarl, mer alker-areny kwerenhel kwetant anetjeh-anngernt. ");
INSERT INTO amx_vpl VALUES ("H12_13","082_2_13","1TH","2","13","13","Nwern Altjerr-warn angkemarleng, nwern renh kangkentjel arrehantherr-akert ilem. Arrantherr nheng angketj nwerneheng awekarleng, arrantherr alhengk-aremel nakek, nhenh Altjerr-henh angketj arratj anemeng. Itja tjerrtj-henh angketj. Arrantherr angketj nhenheh kwet kangkwerremeng, kwerrern arrehantherr-henh twer-irretjenh. ");
INSERT INTO amx_vpl VALUES ("H12_14","082_2_14","1TH","2","14","14","Peltj mapay, mer-areny mapel arrantherrenh nakepakel-ilemel arnpakem-arteh. Mer Judea ntjaperelek-amparr lakenh anek. Tjerrtj Jew mapel werlampareny inenh atwemel nakepakel-ilek. Arrantherr werlampareny Judea-areny map-arteh tjey irrkatj nhengel-antey anem. ");
INSERT INTO amx_vpl VALUES ("H12_15","082_2_15","1TH","2","15","16","Ngkwey arrwekeleny mapel Altjerr-henh angketj angenh-angenh map-amparr irrernng atwek. Lakenh Jew mapel Ngkart Jesu renh irrernng atwekarl. Inang nwernenh atwetjeh alwernek-antim. Lakenheng Altjerr ahang-irrem ineh. Inang arrkernelhem, nwernenh arnpaketjeh, nwern tjerrtj lwereny map kaltj-anthehetj, nheng Altjerr ahentj, inenh anetj inehenheng inetjenh, inang iteth ngampekarl anetjenheng. Lakenh tjerrtj Jew map anetjam-anetj-ilelhek. Altjerrel inenh atwemel alharlkwetjenh. ");
INSERT INTO amx_vpl VALUES ("H12_17","082_2_17","1TH","2","17","17","Peltj mapay, irlpangkewarray, Judea-areny atwenh-atwenh mapel nwernenh alharlkwekarl mer Thessalonica-eng. Inang nwernenh kwek war arnpakek, arrehantherr-warn alhehetjeng. Nwern itja arrehantherr angwerrek. Nwern ywarn iterremel kwet irrar-irrek, arrantherrenh weth aretjeh. ");
INSERT INTO amx_vpl VALUES ("H12_18","082_2_18","1TH","2","18","18","Lakenh nwern kwet iterrek, arrehantherr-warn alhetjeh. Yeng Paul atherr-ingar alhetjeh arrkernelhek. Kenh arrentjel nwernenh kwet arnpakek. ");
INSERT INTO amx_vpl VALUES ("H12_19","082_2_19","1TH","2","19","20","Ngkart Jesu rang petj-alpemeng, nwern ahentj-anem, arrehantherr-akert kwereng ularr irnetjeh. Wenheh? Arrantherr mernelhemeng, nwern arrehantherrel-ayeng irlpareth rrkwapekarleng. Lakenh arrantherr nwernenh arrken-ilem, nwern arrehantherr-akert nakelhem. ");
INSERT INTO amx_vpl VALUES ("H13_1","082_3_1","1TH","3","1","2","Kel nwern kwet-irrekarl antarl town Athens-el, nwern ywarn iterrek arrehantherr. Silas ilern iterremel angkek, “Mwerr key ilern antarl anetjehan? Timothy-ant apek alhetjeh Thessalonica-warn.” Timothy rang Altjerr-henh rrkwapenh-apenh anem, kaltj-anthenh-anthenh thwen angketj mwerr Christ-akert. Timothy ilern lanthek, arrantherrenh twer-ilemel tjep-tjep-iletjeh. Ilern arrpenh mapel-ayel town Athens-el antarl-irrekarl-rlwer. ");
INSERT INTO amx_vpl VALUES ("H13_3","082_3_3","1TH","3","3","3","Arrpenh mapel arrantherrenh nakepakel-ilem, arrantherr Christ nakemeng. Kenh nwern itja ahentj-anek, arrantherr Christ-eng ampakelhetjeh. Arrantherr kel kaltj anem, nwernenh arrpenh mapel nakepakel mpwaretjenh. ");
INSERT INTO amx_vpl VALUES ("H13_4","082_3_4","1TH","3","4","4","Nwern arrehantherrel-arleng anekarleng, nwern arrantherrenh ateng-ilekarl-penh, nhenh lakenh arratjemeh irrek. Nwernenh kwenh inang nakepakel mpwarek. Arrantherr kel kaltj anem, nthakenh nwerneh anek. ");
INSERT INTO amx_vpl VALUES ("H13_5","082_3_5","1TH","3","5","5","Lakenheng nwern arrehantherr ywarn iterrek, ampakelhehetjeng arrantherr. Nwern lakenh angkerrek, “Inang apek Altjerr twerel kwet nakem? Itja apek. Nwern apek inenh pelkel kaltj-anthehetj. Arrentjel apek inenh arrkernehetj, inang Altjerreng ampakelhehetj.” Lakenheng ilern Timothy renh arrehantherr-warn lanthek, arrantherrenh arerl-alpetjeh. Arrantherr apek Christ renh twerel kwet nakemeng. ");
INSERT INTO amx_vpl VALUES ("H13_6","082_3_6","1TH","3","6","6","Ilern tjwempelhetjam Timothy-ek, rang angketj-akert petjetjenharl. Angwerreh-lkwer Timothy rang petj-alpemel ilernenh iletj-alpek, “Peltj nakenh-nakenh map Thessalonica-areny map Christ renh kwet nakemeng. Inangemeh arrpenh mapeh nyerrkentj mernelhem. Inang nwerneh kwet iterremel irlpangkek, nwernenh aretjeh kwel.” Lakenh Timothy-el ilernenh iletj-alpek. Ilern arrehantherr iterretjam-lkwer, arrantherr ilerneh iterretjamarlam, ilernenh aretjeh kwel. ");
INSERT INTO amx_vpl VALUES ("H13_7","082_3_7","1TH","3","7","8","Nwern angketj nhenh awekarl, nwern kangkentj awelhek. Peltj mapay, lyet nwern anem nakepakel, kenh nwern arrken awelhem arrehantherr, arrantherr Ngkart renh twerel kwet nakemeng wart. ");
INSERT INTO amx_vpl VALUES ("H13_9","082_3_9","1TH","3","9","9","Nwern iterl-arem, Altjerrel arrantherrenh arntarnt-arem. Lakenh rang nwernenh arrken awelhetjeh mpwarem. Nwern kweteth kangkemel renh nakem, arrantherr kwer kangkwerrekarleng. ");
INSERT INTO amx_vpl VALUES ("H13_10","082_3_10","1TH","3","10","10","Nwern Altjerr renh kweteth wart pawenhetjenh, arrantherrenh weth aretjeh, arrantherrenh kaltj-anthetjenheng. Nwern ahentj-anem, arrantherremeh angerr-lkwer kaltj-irremel twer-irretjeh. ");
INSERT INTO amx_vpl VALUES ("H13_11","082_3_11","1TH","3","11","11","Nwern Altjerr Angey pawenhem, Ngkart Jesu thwen, nwern arrehantherr-warn alhetjeh, arrehantherrel-ayeng yatjarr anerl-alpetjeh. ");
INSERT INTO amx_vpl VALUES ("H13_12","082_3_12","1TH","3","12","12","Nwern Ngkart renh pawenhem, rang arrantherrenh kaltj-anthemel twer-iletjeh, arrantherr ularrek-ularr nyerrkentj mernelhetjeh, tjerrtj arrpenh mapeh-arlk nyerrkentj mernelhetjeh, nwernarl arrehantherr nyerrkem-arteh. ");
INSERT INTO amx_vpl VALUES ("H13_13","082_3_13","1TH","3","13","13","Nwern pawenhem, rang iterleng-iterl arrehantherr-henh twer-iletjeh, arrantherr arratj anetj-kweny anetjenheng. Nwern iterrem arltang ingkern-penh, nheng Ngkart rang angkep petj-alpetjenh angel kwerenh map-akert. Nwern pawenhem Ngkart Jesu, rang arrantherrenh ngkernetjenh tjerrtj arratj anetj-kweny Altjerr Angeyeng ularr. ");
INSERT INTO amx_vpl VALUES ("H14_1","082_4_1","1TH","4","1","2","Peltj mapay, nwern nheng arrwekel arrantherrenh kaltj-anthekarl, nthakenh arrantherr Altjerreng ularr arratj mernelhetjenh. Lakenh Ngkart Jesu-el nwernenh ilek. Arrantherr arratj kangkwerremel kaltj-irrek. Altjerr rang kwenh arrehantherr arrken awelhem. Nwern weth arrantherrenh ilem: arratj mernelhetjeh, nwern nheng arrantherrenh kaltj-anthekarl-arteh arrwekel. ");
INSERT INTO amx_vpl VALUES ("H14_3","082_4_3","1TH","4","3","3","Altjerr ahentj-anem, arrantherr tjerrtj arratj anetjeh, anetj-kweny. Lakenheng arrantherr itja anetj mpwaretjeh, arrpenh-henh anewel-ayeng intemel. ");
INSERT INTO amx_vpl VALUES ("H14_4","082_4_4","1TH","4","4","5","Arrantherr anew nyent-akertant arratj anetjeh. Arrantherr itja arrpenh-henh mpwerrkek ahentj-anetjeh. Lakenh tjerrtj Altjerreh kaltj-kweny map arrpenh-henh mpwerrkek ahentj-anem, anetj-ilelhemel. Arrantherr alherrentj anetj impetjeh. ");
INSERT INTO amx_vpl VALUES ("H14_6","082_4_6","1TH","4","6","6","Altjerrel ngkwey inenh ilek, “Itja arrpenh-henh anew anyenngel inetjeh.” Nakenh-nakenh nyent apek inekwel alpekarleng, arrpenhel itja anew kwerenh ingkern anyenngel inetjeh. Tjerrtj ngwenh apek mernelhem lakenh, Ngkartel inenh atwetjenh. Nwern arrantherrenh arrwekel kwet lakenh ateng-ilemel ilek. ");
INSERT INTO amx_vpl VALUES ("H14_7","082_4_7","1TH","4","7","7","Altjerrel nwernenh ngwek, kwerenh anetjeh. Rang ahentj, nwern arratj mernelhetjeh. Itja nwern ulpert-iletjeh mpwerrk nwern-henh, palekalek-irrehetjeng apek. ");
INSERT INTO amx_vpl VALUES ("H14_8","082_4_8","1TH","4","8","8","Tjerrtj ngwenh apek inang kangkwerretj-kwenh anem, inang itja tjerrtjeng ntjwem-irrem, inang Altjerreng-arlk ntjwem-irrem. Altjerr rang Kwerrern Alngaltar kwerenh arrehantherr-warn anthekarl. ");
INSERT INTO amx_vpl VALUES ("H14_9","082_4_9","1TH","4","9","9","Altjerrel arrantherrenh kel kaltj-anthek, ularrek-ularr nyerrkentj mernelhetjeh. Kel arrantherr kaltj wart, arrantherr kwer kangkwerrekarl. Lakenheng nwern itja ahentj-anem, angketj nhenh-akert arrehantherr pip-warn arrernetjeh. ");
INSERT INTO amx_vpl VALUES ("H14_10","082_4_10","1TH","4","10","10","Nwern kaltj, arrantherr peltj nakenh-nakenh ingkerrekeh nyerrkemeng, mer Macedonia ntjaperel. Peltj mapay, nwern ahentj, arrantherr angerr-lkwer nyerrkentj mernelhetjeh. ");
INSERT INTO amx_vpl VALUES ("H14_11","082_4_11","1TH","4","11","11","Arrantherr apekap intert-intert anetjeh, arratj mernelhetjeh, itja tjerrtj arrpenh twernerl-apetjeh. Arrantherr rrkwapetjehant, mern arrehantherr-henheh-arlk mantarreh-arlk aretjeh, nwern arrantherrenh kaltj-anthekarl-arteh. Lakenh arratj anem. ");
INSERT INTO amx_vpl VALUES ("H14_12","082_4_12","1TH","4","12","12","Kwereng tjerrtj Altjerreh akwen mapel aretjenheng, arrantherr tjerrtj irlpareth anemeng. Arrantherr itja kweteth ankeyalth nthwerl-apetjeh. ");
INSERT INTO amx_vpl VALUES ("H14_13","082_4_13","1TH","4","13","13","Peltj mapay, nwern ahentj-anem, arrantherrenh kaltj-anthetjeh angketj arrwekeleny nakenh-nakenh map-akert, inarl arrwekel ilwekarl. Ngkart Jesu-ek akwen map inang ltarrp angerr-lkwer arnem peltj arlaltj inehenh parlp-ilekarl-penh, inang iterl-arem, inang itja weth arerretjenh kwel. Arrantherr itja angerr arnetjeh. ");
INSERT INTO amx_vpl VALUES ("H14_14","082_4_14","1TH","4","14","14","Nwern kel kaltj, Jesu rang ilwekarl, kwereng Altjerrel renh irrernngeng iteth-ilekarl. Lakenheng nwern kaltj, Altjerrel Jesu renh angkep lanthetjenh. Tjerrtj arrwekeleny ilwekarl inarl renh nakekarl wart arrwekel, tjerrtj yanh map kwenh petjetjenh Jesu-el-arleng. ");
INSERT INTO amx_vpl VALUES ("H14_15","082_4_15","1TH","4","15","15","Angketj nwern awek Ngkart Jesu-eng, rarrp nwernenh ilerleh, nwernemeh arrantherrenh angketj nhenh renh ilem keth-ilemel. Angketj nhenh arrantherr kwenh kangkwerretjekant, tjeperr anthwerr impen. Jesu rang petj-alpetjenh-rlwer, nwern tjerrtj iteth kwet anemarl map nthakenham nwern irretjenharlam? Nwern itjarl nakenh-nakenh ilwekarl mapeh arrwekel irretjenh. ");
INSERT INTO amx_vpl VALUES ("H14_16","082_4_16","1TH","4","16","16","Lakenheh-amparr anetjenh. Angel alker-areny twernk rang arlketjenh-amparr. Angel arrpenhel Altjerr-henh trumpet angkelh-angkelh-iletjenh-amparr. Kwereng Ngkart Jesu Christ alkereng anarnpetj-alhetjenh. Kwereng tjerrtj Christ renh nakenh-nakenh ilwekarl map inek-amparr iteth-irremel kemerretjenh. ");
INSERT INTO amx_vpl VALUES ("H14_17","082_4_17","1TH","4","17","17","Kwer-penh Altjerrel nwernenh iteth anemarl map thwen arrwetj-penh nheng map thwen ankert-warn tjwenemel antjelh-iletjenh. Nwern ingkerrek Ngkart kwerel-arleng nyent-irremel pwertemeh anetjenh. Nwern kwetant Ngkart kwerel-ayeng anetjenh. ");
INSERT INTO amx_vpl VALUES ("H14_18","082_4_18","1TH","4","18","18","Arrantherr angketj nhenh ularrek-ularr twerelh-ilemel ilerretjeh, arrantherr anew-anew anetjenheng, arrantherr iterl-aretjenheng, “Yew, nakenh-nakenh ilwekarl map inang iteth-irremel kemerretjenh, nwern iteth anemarl mapel-ayeng nyent-irretjenh, nheng Jesu petj-alpetjenharl.” ");
INSERT INTO amx_vpl VALUES ("H15_1","082_5_1","1TH","5","1","1","Peltj mapay, arrwekel arrantherr yengenh pawenhetjart, “Ilwengar Ngkart Jesu rang petj-alpetjenh?” Thang nheng arrantherrenh arrwekel kaltj-anthek. Arrantherr kwenh kaltj, Ngkart Jesu-arl petj-alpetjenhek. Yeng mentj angketj wetham-weth arrernetjehan pipel-ayel. Angketj arrpenh thang lyet arrernetjenh. ");
INSERT INTO amx_vpl VALUES ("H15_2","082_5_2","1TH","5","2","2","Arltang ingkernel tjerrtj Altjerr iterl-aretj-kweny map kwenh pal anetjenh. Thang arrantherrenh ilem angketj anyenngalth-akert. Anyenngalth alhem mer arrpenh-warn kwenyel, lakenh-arteh rang anetjenh. Mer-areny map ankwang pal intetjenh, kwer karelhetj-kweny. Lakenh-arteh Ngkart rang anyenng-anyenng petj-alpetjenh. ");
INSERT INTO amx_vpl VALUES ("H15_3","082_5_3","1TH","5","3","3","Tjerrtj Altjerreh akwen map itja athek-irrem Ngkart Jesu rang petj-alpetjenhek. Inang pal iterl-aremel ilelhetjenh lakenh, “Nwern kwenh mwerr anetjeh. Ngkartel itja kwenh nwernenh atwetjenh!” Ngkart rang petj-alpetjenharl, lakenh-arteh anetjenh. Kwereng Ngkart Jesu rang petj-alpetjenh, tjerrtj inenh ywerrelh-iletjeh-anngernt. Angketj marl-akertek iterray. Marl akayak anthwerr apek anem, anert-anert, kwer rang anyenetjeh-anngernt. Rang ywarn angkem, “Mpankaw!” Lakenh-arteharlam tjerrtj itja Ngkart-warn “Arrwekaw” angketjeh. Inang ywarn Ngkarteng alwerretjenh, Ngkart rang petj-alpemarleng. ");
INSERT INTO amx_vpl VALUES ("H15_4","082_5_4","1TH","5","4","8","Peltj mapay, arrantherr itja akwen arrpenh map-arteh mernelhetjeh, Altjerr alhengk-aretj-kweny map-arteh. Inang kwenh ngwemerntel anem iterrentj irlpang-kwenh. Nwern itja ineh-arteh anetjeh. Nwern parrtjel anem, lakenh nwern karr anetjeh iterrentj arratj-akert, Jesu rang petj-alpetjenharl lwerenhek. Lakenh nwern anwerlketj-kwenh anetjenh kaltj wart, lakenh-arteh, nheng anyenngalthel tjerrtj anwerlkelh-ilemeng-arteh. Tjerrtj apek ankwang intetjeh ahentj, rang kel kwenyel ankwang intem. Tjerrtj apek terangk-irretjeh ahentj-anem, rang kel kwenyel terangk-irrem. Nwern itja lakenh-arteh anetjeh. Nwern iterrentj arratj-akert anetjeh. Lakenheng nwern arntarnt-arelhetjeh, kweteth Altjerr renh nakemel, tjerrtj arrpenheh nyerrkentj mernelhemel. Nwern kwenp kwet tjwempelhem kwer, Ngkartel nwernenh inerl-alpetjeh-atwetj. ");
INSERT INTO amx_vpl VALUES ("H15_9","082_5_9","1TH","5","9","9","Altjerrel arrantherrenh urraremel ngakek, rang arrantherrenh Ngkart Jesu Christ-el-arleng iteth kwetant inerl-alpetjenheng, kwerel-ayeng iteth ngampekarl anetjeh-anngernt. Rang itja iterrek, arrantherrenh atwetjeh kwel. ");
INSERT INTO amx_vpl VALUES ("H15_10","082_5_10","1TH","5","10","10","Nwern ilwetjeh apek, nwern iteth anetjeh apek, Ngkart Jesu petj-alpetjeh-atwetj. Nwern itja kaltj. Iterl-aray, nwern ingkerrek Ngkart Jesu-el-ayeng arraw-irretjeh, kwerel-ayeng kwet anetj-alpetjenh. ");
INSERT INTO amx_vpl VALUES ("H15_11","082_5_11","1TH","5","11","11","Angketj nhenhel twer-ilelhemel alngwelng-ilelhewarrang. Yeng kaltj, arrantherr lyet lakenh mpwarem. ");
INSERT INTO amx_vpl VALUES ("H15_12","082_5_12","1TH","5","12","12","Peltj mapay, mantjel awerrerrang angketj nhenh. Arrantherr arratj iterremel mernelhetjeh ngkart mapek, werlampareny-henh arntarnt-arenh-arenh mapek apek. Inang arrantherrenh arntarnt-arem, arrehantherr angerr rrkwapem thwen. Inang arrantherrenh patelh-ilem, itja anetj mpwaretjeh, arrantherr arratjant mernelhetjeh. ");
INSERT INTO amx_vpl VALUES ("H15_13","082_5_13","1TH","5","13","13","Arrantherr ineh angerr nyerrketjehan, rrkwapentj inehenheng. Ineh unpartek-unpart-kweny alartetjeh. Arrantherr ingkerrek ularrek-ularr ngwerleny mernelhetjeh. ");
INSERT INTO amx_vpl VALUES ("H15_14","082_5_14","1TH","5","14","14","Peltj mapay, angketj arrpenh nhenh arrantherr awerrerrang. Tjerrtj ngwenh apek inang itja ahentj-anem rrkwapetjeh, ankeyant war inang nthwerl-apem. Arrantherr ilpwengerr-ngerr ineh angketjeh, inang rrkwapetjeh, mern inehenh inang aretjenheng. Arrpenh map ateralth anem. Inenh anew-anew-iletjeh. Arrpenh map theltj anem. Inenh twer-ilemel iletjeh, inang arntarnt-arelhetjeh. Tjerrtj ingkerrek arrantherr mantj-mantj-iletjeh. ");
INSERT INTO amx_vpl VALUES ("H15_15","082_5_15","1TH","5","15","15","Artwang nyentel apek anetj mpwarem arrpenhek. Artwang arrpenh rang apek angkep atwetjeh ahentj-irrem, arrantherr renh arnpaketjehant. Arrantherr ularrek-ularr tjerrtj arrpenh mapeh-arlk kangkentj mernelhetjeh. ");
INSERT INTO amx_vpl VALUES ("H15_16","082_5_16","1TH","5","16","16","Kweteth arrkenant anerrerrang. ");
INSERT INTO amx_vpl VALUES ("H15_17","082_5_17","1TH","5","17","17","Kweteth Altjerr-warn angkerrerrang. Itja angwerretjeh. ");
INSERT INTO amx_vpl VALUES ("H15_18","082_5_18","1TH","5","18","18","Arrantherr apek rwekenth-kenth anemeng, arrantherr arrken apek anemeng, kangkentjel Altjerr renh pawenherrerrang. Altjerr ahentj-anem, arrantherr lakenh mernelhetjeh, arrantherr Jesu Christ-henh anemeng wart. ");
INSERT INTO amx_vpl VALUES ("H15_19","082_5_19","1TH","5","19","19","Arrantherr itja Kwerrern Alngaltareng ntjwem-irretjeh. Kwerrern Alngaltar apek angkemeng arrehantherr-warn, arrantherr kwer kangkwerretjehant, itja mentjel awetjeh. ");
INSERT INTO amx_vpl VALUES ("H15_20","082_5_20","1TH","5","20","20","Arrpenhel apek ilemeng, “Kwerrern Alngaltarel yengenh ilek.” Mantjel awerrerrang angketj kwerenh. Kwerrern Alngaltar rang arrantherrenh arratj ilemeng, arrantherr kwer kangkwerretjehant, itja mentjel awetjeh. ");
INSERT INTO amx_vpl VALUES ("H15_21","082_5_21","1TH","5","21","21","Arrantherr angketj arrpenh map-henh mantjel awetjeh-amparr, angketj pal apek anehetjeng. Angketj arratjehant arrantherr kangkwerretjeh. ");
INSERT INTO amx_vpl VALUES ("H15_22","082_5_22","1TH","5","22","22","Angketj anetj arrantherr impetjehant. ");
INSERT INTO amx_vpl VALUES ("H15_23","082_5_23","1TH","5","23","23","Altjerr rang ngwerleny anem. Thang Altjerr renh pawenhem, rang arrantherrenh mwerr anthwerr-iletjeh. Thang renh pawenhem, rang kwerrern, mpwerrk arrehantherr-henh mwerr anyenetjenheng, Ngkart Jesu Christ rang petj-alpetjeh-atwetj. ");
INSERT INTO amx_vpl VALUES ("H15_24","082_5_24","1TH","5","24","24","Altjerr rang arrantherrenh itja impem. Rang kwenh arrantherrenh arratj-ilem, mwerr anyenem. ");
INSERT INTO amx_vpl VALUES ("H15_25","082_5_25","1TH","5","25","25","Peltj mapay, nwerneh Altjerr tjang-pawenherrerrang. ");
INSERT INTO amx_vpl VALUES ("H15_26","082_5_26","1TH","5","26","26","Arrantherr peltj ingkerrek amel-rrkwetjeh, inarl nakenh-nakenh anemeng. Tjey-arteh mernelhetjeh. ");
INSERT INTO amx_vpl VALUES ("H15_27","082_5_27","1TH","5","27","27","Ngkart Jesu-el nwernenh aremeng wart, thang arrantherrenh ilem, arrantherr pip nhenh werlamparenyek read-irremel iletjeh. ");
INSERT INTO amx_vpl VALUES ("H15_28","082_5_28","1TH","5","28","28","Thang Ngkart Jesu Christ renh pawenhem, rang arrehantherr kangkentj kwet mernelhetjeh. ");
INSERT INTO amx_vpl VALUES ("H21_1","083_1_1","2TH","1","1","1","Paul Silas Timothy nwern pip nhenh lanthem werlampareny-warn, Thessalonica town-el anemarl map-warn. Arrantherr kwenh Altjerr Angey-henh peltj arlaltj anem, Ngkart Jesu Christ-henh thwen. ");
INSERT INTO amx_vpl VALUES ("H21_2","083_1_2","2TH","1","2","2","Nwern Altjerr Angey Ngkart Jesu Christ thwen renh-atherrenh pawenhem, ratherr arrehantherr kangkentj kwet mernelhetjeh, ratherr arrantherrenh alngwelng-ilemel anyenetjeh, arrantherr ater-kwenh ngwerleny anetjenheng. ");
INSERT INTO amx_vpl VALUES ("H21_3","083_1_3","2TH","1","3","3","Peltj mapay, nwern Altjerr kwerel-arleng angkemarleng, nwern kweteth arrehantherr iterrem, nwern renh kangkentj-akertel ilem, arrantherr renh twer anthwerrel nakemeng, arrantherr wetham-weth nyerrkentj mernelhemeng tjerrtj arrpenhek-arrpenhek werlamparenyel-ayeng. ");
INSERT INTO amx_vpl VALUES ("H21_4","083_1_4","2TH","1","4","4","Lakenh nwern arrantherrenh nakerl-apem, nwern Altjerr-henh werlampareny arrpenh map-warn alhemeng mer ntjaperel. Nwern inenh ilem, arrantherr Christ twerel kwet nakemeng, arrpenh mapel arrantherrenh atwetjeh alwernemeng, nakepakel-ilemeng. Arrantherr Christ renh itja impek. ");
INSERT INTO amx_vpl VALUES ("H21_5","083_1_5","2TH","1","5","6","Arrpenh mapel arrantherrenh nakepakel-ilek, kenh arrantherr kwenp kwet Christ nakekarl. Lyet-antey Altjerrel arrantherrenh twer-ilem, kelant arrantherr mwerr anthwerr anetjenh, rang arrantherrenh mer kwerenh-warn irrpelh-iletjenh. Altjerr rang tjerrtj ingkerrekeh arratj mpwarem. Tjerrtj inarl arrantherrenh alwernemeng nakepakel-ilemel, kenh Altjerrelemeh tjerrtj inenh angkep nakepakel mpwaretjenh, lakenh. ");
INSERT INTO amx_vpl VALUES ("H21_7","083_1_7","2TH","1","7","7","Rang mwerr mpwaretjenh arrehantherr rwekenth-kenth-ketj nwerneh-arlk. Rang lakenh mpwaretjenh, Ngkart Jesu rang petj-alpemeng angel alker-areny kwerenh map-akert, rwang alngenth-akert. ");
INSERT INTO amx_vpl VALUES ("H21_8","083_1_8","2TH","1","8","8","Ngkart Jesu-el tjerrtj arrpenh map inenh atwetjenh, nheng inarl Altjerreh akwen anemeng, inang angketj mwerr kwerenheh itja kangkwerrekarleng wart. ");
INSERT INTO amx_vpl VALUES ("H21_9","083_1_9","2TH","1","9","10","Inang itja kwet irrpetjenh Ngkart-henh mer alker-warn. Arltang kwerel rang inenh kwereng kwetant alharlkwetjenh, rang petjemarleng twer angerr-akert. Kwereng Jesu nakenh-nakenh map anetj-alpetjenh kwerel-ayeng. Inang renh naketj-alpetjenh lakenh angkemel, “Jesu rang mwerr anthwerr.” Arrantherr tjerrtj inehel-arleng anetjenh, arrantherr angketj nwern-henh nakekarleng wart. ");
INSERT INTO amx_vpl VALUES ("H21_11","083_1_11","2TH","1","11","11","Altjerrel arrantherrenh urraremel ngakek. Nwern kweteth renh tjang-pawenhem arrehantherr, rang arrantherrenh arntarnt-aretjeh, arrantherr ntjwem-irrehetj. Nwern renh tjang-pawenhem, rang arrantherrenh twer-iletjeh, arrantherr wenh-wenh mwerr mpwaretjenheng. ");
INSERT INTO amx_vpl VALUES ("H21_12","083_1_12","2TH","1","12","12","Altjerr Ngkart Jesu Christ thwen arrehantherr kangkentj mernelhek. Nwern Altjerr renh tjang-pawenhem tjerrtj lwereny mapek, inang twep-irretjenheng Altjerr-warn. Inang apek arrantherrenh aremeng, arrantherr mwerr mpwarerleh, inang arrehantherr kangkentj awelhetjenh. Kwereng inang Ngkart Jesu renh naketjenheng. Kwereng Altjerr rang arrantherrenh naketjenh. ");
INSERT INTO amx_vpl VALUES ("H22_1","083_2_1","2TH","2","1","1","Peltj mapay, nwern angketj nheng arrwekel-antey arrehantherr ilek, Ngkart Jesu Christ-arl angkep petj-alpetjenh-akert. Nwern arrantherrenh kel ilek, Altjerrel nwernenh arraw-iletjenh, Jesu Christ-warn arnekarner alhetjeh. Angketj arrpenh nhenhemeh awerrerrang! ");
INSERT INTO amx_vpl VALUES ("H22_2","083_2_2","2TH","2","2","2","Tjerrtj arrpenh mapel apek arrantherrenh pal ilemeng, Ngkart Jesu Christ petj-alpekarl kwel. Inang apek arrantherrenh iletjenh, Kwerrern Alngaltarel inenh kwel ilekarl. Itja, angketj nhenh rrtjwerrentj. Arrpenh apek pal angkemel ilelhem, “Thang awek, Paul lakenh angkerleh, ‘Ngkart Jesu-an kel petj-alpek ahern nhenh-warn.’ ” Itja, angketj nhenh rrtjwerrentj anem. Arrpenhel-anem apek ilem, “Paul mapel kwenh nhenh pip-warn arrernek, ‘Jesu-an kel petj-alpek ahern nhenh-warn.’ ” Itja, angketj nhenh rrtjwerrentj anem. Lakenh arrantherr awem apek, arrantherr itja athek-irretjeh, itja rrwampey awelhetjeh. ");
INSERT INTO amx_vpl VALUES ("H22_3","083_2_3","2TH","2","3","3","Arrantherr itja angketj rrtjwerrentj inehenh naketjeh. Nwern itja lakenh ilek. Thang arrantherrenh ilem, nthakenhameh arrwekel nwernehan anetjenh, nheng Ngkart Jesu rang petj-alpetjenheng. Arrwekel tjerrtj map-artek Altjerrek irrpelth-irretjek, kwereng artwang Altjerreh Irrpelth-irrenh-irrenh nhengemeh rang petjetjenh. Artwang renh Altjerrel mernetjenh. Ingkern Ngkart Jesu rang petj-alpemeng, kwereng artwang renh rang atwemel ywerrelh-iletjenh. ");
INSERT INTO amx_vpl VALUES ("H22_4","083_2_4","2TH","2","4","4","Artwang Altjerreh Irrpelth-irrenh-irrenh rang Altjerr-henh church angerretj-warn irrpetjenh, rarrp twernk angerr ngkernelhemel arrernelhetjenh. Rang lakenh ilelhetjenh, “Tjerrtj mapel kwenh ahern-areny war naketjart, altjerr-arrpantey map apek. Yeng nhenh mapeng angerr. Yeng Altjerr alker-arenyeng angerr anem. Yengant Altjerr anem tjerrtj ingkerrekeh. Tjerrtj ingkerrekel arrantherr yengenh naketjeh.” Rang lakenh rrtjwerremel ilelhetjenh. ");
INSERT INTO amx_vpl VALUES ("H22_5","083_2_5","2TH","2","5","5","Arrantherr angketj nhenh irlpangkem key, thang nheng arrantherrenh arrwekel ilekarl, yeng arrehantherrel-ayel anetjam-rlwer? ");
INSERT INTO amx_vpl VALUES ("H22_6","083_2_6","2TH","2","6","7","Nwern artwang nheng kwer itja kaltj. Lyet rang arrweperel kwet rrkwapem, arnpakenh-ilenh-ilenhel renh arnpakemeng wart. Arnpakenh-ilenh-ilenh nhenh rang artwang Altjerreh Irrpelth-irrenh-irrenh renh arnpaketjenh, artwang rang itja angerr anetj mpwaretjeh arrtjelh-iletjenh. Arrantherr kaltj arnpakenh-ilenh-ilenh nheng kwer. Altjerrel arltang urraretjenh, arltang kwerel artwang Altjerreh Irrpelth-irrenh-irrenh rang keth ngwerrm-irretjenh. Arltang kwerel Altjerrel arnpakenh-ilenh-ilenh renhek-amparr tjeyeng arnangelh-iletjenh. ");
INSERT INTO amx_vpl VALUES ("H22_8","083_2_8","2TH","2","8","12","Artwang Altjerreh Irrpelth-irrenh-irrenh rangemeh keth-irretjenh, arrwekel-amparr nwern renh alhengk-aretjeh. Rang twer angerr-akertel mpwaretjenh, tjerrtj map rrtjwerremel iletjenh. Rang ane