﻿USE sofia;
DROP TABLE IF EXISTS sofia.amuNT_vpl;
CREATE TABLE amuNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES amuNT_vpl WRITE;
INSERT INTO amuNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Luaa ñꞌoom na matseijndaaꞌñenaꞌ tsjaaⁿ nnꞌaⁿ na tuiiñe Jesucristo, na wjaacꞌoomnaꞌ David ñequio Abraham na jndyowicantyjooꞌ joona na tueꞌcañoomnaꞌ jom. ");
INSERT INTO amuNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham, jom tsotye Isaac, Isaac tsotye Jacob, Jacob tsotye Judá ñequio ntyjee tsaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá ñequio yuscu na jndyu Tamar, ndana Fares ñequio Zara. Fares tsotye Esrom, Esrom tsotye Aram. ");
INSERT INTO amuNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram tsotye Aminadab, Aminadab tsotye Naasón, Naasón tsotye Salmón. ");
INSERT INTO amuNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón ñequio yuscu Rahab, ndana Booz, Booz ñequio scoomꞌm Rut, ndana Obed, Obed tsotye Isaí. ");
INSERT INTO amuNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí tsotye David tsaⁿ na tyoluiiñe rey, David toꞌñoom scuuꞌ tsꞌoo Urías, tꞌoom ndana Salomón. ");
INSERT INTO amuNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón tsotye Roboam, Roboam tsotye Abías, Abías tsotye Asa. ");
INSERT INTO amuNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa tsotye Josafat, Josafat tsotye Joram, Joram tsotye Uzías. ");
INSERT INTO amuNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías tsotye Jotam, Jotam tsotye Acaz, Acaz tsotye Ezequías. ");
INSERT INTO amuNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías tsotye Manasés, Manasés tsotye Amón, Amón tsotye Josías. ");
INSERT INTO amuNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías tsotye Jeconías ñequio ntyjee tsaⁿꞌñeeⁿ. Joona tuiindyena tiempo quia tyꞌe nnꞌaⁿ Israel na pra̱so ndyuaa Babilonia ncꞌe na ticanaⁿndye nnꞌaⁿ Israel ndiaꞌ ñꞌeⁿ nnꞌaⁿ ndyuaaꞌñeeⁿ. Tyꞌecho naⁿꞌñeeⁿ joona na tyondyeꞌntjomtyeⁿna. ");
INSERT INTO amuNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Jnda̱ teinom na tyꞌecho nnꞌaⁿ Babilonia nnꞌaⁿ Israel ndyuaana, tuiiñe jnda Jeconías ndyuaaꞌñeeⁿ. Jndyu tsaⁿꞌñeeⁿ Salatiel, Salatiel jom tsotye Zorobabel. ");
INSERT INTO amuNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel tsotye Abiud, Abiud tsotye Eliaquim, Eliaquim tsotye Azor. ");
INSERT INTO amuNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor tsotye Sadoc, Sadoc tsotye Aquim, Aquim tsotye Eliud. ");
INSERT INTO amuNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud tsotye Eleazar, Eleazar tsotye Matán, Matán tsotye Jacob. ");
INSERT INTO amuNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob tsotye José, José saaꞌ María. Ndoꞌ Maríaꞌñeeⁿ na seincueⁿ Jesús na cwiluiiñe Cristo. ");
INSERT INTO amuNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Jnda̱a̱ꞌ canchooꞌñequiee ndiiꞌ tsjaaⁿ na jndyowicantyjooꞌ, jnaⁿnaꞌ Abraham, tueꞌcañoomnaꞌ hasta David. Ndoꞌ cwiicheⁿ canchooꞌñequiee ndiiꞌ tsjaaⁿ na jndyowicantyjooꞌ, jnaⁿnaꞌ David, tueꞌcañoomnaꞌ tiempo quia na tyꞌe nnꞌaⁿ Israel na pra̱so ndyuaa Babilonia. Ndoꞌ cwiicheⁿ canchooꞌñequiee ndiiꞌ tsjaaⁿ na jndyowicantyjooꞌ, jnaⁿnaꞌ quia tyꞌecho nnꞌaⁿ Babilonia nnꞌaⁿ Israel, tueꞌcañoomnaꞌ hasta xjeⁿ na tuiiñe nquii na cwiluiiñe Cristo. ");
INSERT INTO amuNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Luaa waa na tuiiñe Jesucristo. Quia waacheⁿ ñomcaaꞌ tsoñeeⁿ María ñequio José, ndoꞌ cwii tjo̱o̱cheⁿ na nntjomndyena, teitquiooꞌ na majndeiiñe María cantyja najndeii Espíritu Santo. ");
INSERT INTO amuNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ndoꞌ José, tsaⁿ na nluiiñe saaꞌ María, jom tsꞌaⁿ na ñequiiꞌcheⁿ tyocantyjaaꞌ tsꞌom na ntsꞌaa yuu na matyꞌiomyanaꞌ. Ticalꞌue tsꞌoom na nluiꞌjnaaⁿꞌñe tsaⁿꞌñeeⁿ, joꞌ chii seitioom na cweꞌ ñemaaⁿꞌ nntyuiiꞌ ñomca. ");
INSERT INTO amuNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Yocheⁿ na luaaꞌ matseitioom, tsoomꞌm ndaa na teitquiooꞌñe cwii ángel cwentaaꞌ Tyꞌo̱o̱tsꞌom nnoom. Tso tsaⁿꞌñeeⁿ: —ꞌU José na cwiluiindyuꞌ tsjaaⁿ David na jndyowicantyjooꞌ tintyꞌueꞌ na nncoꞌñomꞌ María na nluiiñê scuꞌ. Ee cantyja najndeii Espíritu Santo joꞌ na jndeiiñê. ");
INSERT INTO amuNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nntseincueⁿ cwii yuꞌndaa na tsaⁿsꞌa. Ndoꞌ ꞌu nntseicajndyuꞌ juu Jesús. Ee na tseixmaaⁿ na nncwjiꞌnꞌmaaⁿñê nnꞌaⁿ na mꞌaⁿ cantyja ꞌnaaⁿꞌaⁿ. Nntseicanoomꞌm jnaⁿ na laꞌxmaⁿ naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Chaꞌtso nmeiⁿꞌ tuii cha catseicanda̱a̱ꞌñenaꞌ ñꞌoom na seineiⁿ Tyꞌo̱o̱tsꞌom ñequio ñꞌoom ꞌndyoo profeta. ");
INSERT INTO amuNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Tso tsaⁿꞌñeeⁿ: Queⁿꞌyoꞌ cwenta, nndeiiñe cwii yuscundyua. Nntseincueⁿ cwii tyochjoo ndoꞌ njndyu Emanuel. Ñꞌoom Emanuel matsonaꞌ: Tyꞌo̱o̱tsꞌom mꞌaaⁿ ñꞌeⁿndyo̱ jaa. ");
INSERT INTO amuNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Jnda̱ na lcwii tsꞌom José na tsoomꞌm ndaa, quia joꞌ seicana̱a̱ⁿ ñꞌoom na sa̱ꞌntjom ángel cwentaaꞌ Tyꞌo̱o̱tsꞌom, toꞌñoom María na scoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Sa̱a̱ ticatjomndyena na mandiñoomꞌ hasta quia jnda̱ seincuii scoomꞌm yuꞌndaaꞌñeeⁿ. Quia joꞌ José seicajñoom yuꞌndaaꞌñeeⁿ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ncuee na tyomꞌaaⁿ Herodes rey, tuiiñe Jesús tsjoom Belén tsꞌo̱ndaa Judea. Luaa tuii, tquieꞌcañom nnꞌaⁿ na jndo̱ꞌ nꞌom Jerusalén, na jnaⁿ jo ndoꞌ na macaluiꞌ ñeꞌquioomꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Tyotaꞌxꞌeendyena: —¿Yuu mꞌaaⁿ nqueⁿ na tuiiñê rey cwentaa nnꞌaⁿ judíos? Ee jâ jnda̱ ntyꞌiaayâ na teitquiooꞌñe caxjuu cwentaaⁿꞌaⁿ na ndicwaⁿ mꞌaaⁿyâ ndyuaayâ jo ndoꞌ yuu na macaluiꞌ ñeꞌquioomꞌ. Joꞌ na tquio̱o̱yâ na nlatꞌmaaⁿꞌndyô̱ jom. ");
INSERT INTO amuNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Quia na jndii Herodes ñꞌoomwaaꞌ, jeeⁿ seiñꞌeeⁿꞌñenaꞌ jom ndoꞌ mati chaꞌtso nnꞌaⁿ Jerusalén. ");
INSERT INTO amuNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Joꞌ chii seitjoom chaꞌtso ntyee na cwiluiitquiendye, ñequio nnꞌaⁿ na mꞌaⁿ tsjoomꞌñeeⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés. Ndoꞌ taxꞌeeñê nda̱a̱ naⁿꞌñeeⁿ yuu tsonaꞌ na nluiiñe juu na cwiluiiñe Cristo. ");
INSERT INTO amuNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Naⁿꞌñeeⁿ jluena nnoom: —Ndiꞌ, matso ljeii na tsjoom Belén tsꞌo̱ndaa Judea, joꞌ joꞌ nluiiñê. Ee luaa waa na seiljeii profeta: ");
INSERT INTO amuNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","ꞌO nnꞌaⁿ tsjoom Belén, tsꞌo̱ndaa Judá, meiⁿchjoo ticjuꞌcjenaꞌ tsjomꞌyoꞌ quiiꞌntaaⁿ njoom ntꞌmaⁿ chaꞌwaa tsꞌo̱ndaa Judá. Ee quiiꞌntaaⁿꞌyoꞌ nluiꞌ cwii tsꞌaⁿ na nluiitquieñe na nnteixꞌee nnꞌaaⁿya Israel. ");
INSERT INTO amuNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Quia joꞌ cweꞌ ntyꞌiu tqueeⁿꞌñe Herodes nnꞌaⁿ na jndo̱ꞌ nꞌom na jnaⁿ jo ndoꞌ na macaluiꞌ ñeꞌquioomꞌ. Tcuu tcuu taxꞌeeñê nda̱a̱na ꞌñeeⁿ xjeⁿꞌñeeⁿ na teiꞌtquiooꞌñe caxjuu. ");
INSERT INTO amuNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Jnda̱ joꞌ jñoom joona na cꞌoona tsjoom Belén. Tsoom nda̱a̱na: —Catsaꞌyoꞌ, ndoꞌ cataꞌxꞌeeꞌjndaaꞌndyoꞌ yuu mꞌaaⁿ tyochjooꞌñeeⁿ. Ndoꞌ quia na jnda̱ jliuꞌyoꞌ jom, quiolaꞌcandiiꞌyoꞌ ja, cha mati ja nncjo̱, nntseitꞌmaaⁿꞌndyo̱ jom. ");
INSERT INTO amuNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Naⁿꞌñeeⁿ, quia na jnda̱ jndyena ñꞌomꞌndyoo rey Herodesꞌñeeⁿ mana tyꞌena. Ndoꞌ juu caxjuu na teiꞌtquiooꞌñe nda̱a̱na na ndicwaⁿ mꞌaⁿna ndyuaana jo ndoꞌ na macaluiꞌ ñeꞌquioomꞌ, tjajndyeenaꞌ jo nda̱a̱na hasta tueꞌcañoomnaꞌ ndyeyu yuu na mꞌaaⁿ tyochjooꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Jeeⁿ tjaweeꞌ nꞌomna quia ntyꞌiaanndaꞌna caxjuuꞌñeeⁿ. Tꞌmaⁿ tquiaanaꞌ na neiiⁿna. ");
INSERT INTO amuNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Quia tyꞌequieꞌna naquiiꞌ wꞌaa, ntyꞌiaana juu tyochjoo ñequio tsoñeeⁿ María. Tyꞌecataꞌna cantyena na tyolaꞌtꞌmaaⁿꞌndyena jom. Tjeiiꞌna ꞌnaⁿ na jnda na cwileiꞌchona. Lꞌana naya jom sꞌom cajaⁿ ñꞌeⁿ suu ndoꞌ ñꞌeⁿ nasei cachi na tuiinaꞌ ñꞌeⁿ ntsueeꞌ tsꞌoom mirra. ");
INSERT INTO amuNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Jnda̱ chii cwiicheⁿ nato tyꞌelcweeꞌna ndyuaa tsjoomna ee sꞌaa Tyꞌo̱o̱tsꞌom na tsoona ndaa, joꞌ na seijndo̱ꞌnaꞌ nꞌomna na ticꞌoolcweeꞌna na mꞌaaⁿ Herodesꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Jnda̱ na jluiꞌ naⁿꞌñeeⁿ, teitquiooꞌñe cwii ángel cwentaaꞌ Ta Tyꞌo̱o̱tsꞌom nnom José xjeⁿ na tsoomꞌm ndaa. Tso ángelꞌñeeⁿ nnoom: —Quicantyjaꞌ, cjaꞌñꞌoomꞌ tyochjoo ñequio tsoñeeⁿ. Caleiꞌnomꞌyoꞌ, catsaꞌyoꞌ ndyuaa Egipto, ndoꞌ joꞌ joꞌ cꞌomꞌyoꞌ hasta xjeⁿ na nntseicandiiya. Ee nlꞌue Herodes tyochjoo na nntseicueⁿꞌeⁿ juu. ");
INSERT INTO amuNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Quia joꞌ teicantyjaaⁿ, ndoꞌ cweꞌ natsjom tjañꞌoom tyochjoo ñequio tsondyee. Tyꞌena Egipto. ");
INSERT INTO amuNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Joꞌ joꞌ tꞌomna hasta na tueꞌ Herodes. Na tuii na luaaꞌ seicanda̱a̱ꞌñenaꞌ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na tyoñequiaa profeta. Matsonaꞌ: “Tjeiiꞌa Jndaaya na mꞌaaⁿ ndyuaa Egipto.” ");
INSERT INTO amuNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Juu Herodes, jnda̱ na ljeiiⁿ na joo nnꞌaⁿ na jndo̱ꞌ nꞌom ticalaꞌñꞌoomꞌndyena jom, seiwꞌiiyayaaⁿ. Jñoom sondaro tsjoom Belén ndoꞌ chaꞌwaa ndiocheⁿ yuu na mꞌaⁿ nnꞌaⁿ. Sa̱ꞌntjoom na calaꞌcwjee naⁿꞌñeeⁿ chaꞌtso tyonchꞌu na we ndyuu ndoꞌ na cjeti mꞌaⁿ. Ee laaꞌtiꞌ tjeiiⁿꞌeⁿ cwenta cwanti xuee na teitquiooꞌñe jndyee caxjuuꞌñeeⁿ cantyja ꞌnaaⁿꞌ ñꞌoom ndyuee nnꞌaⁿ na jndo̱ꞌ nꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ndoꞌ na luaaꞌ sꞌaaⁿ, seicanda̱a̱ꞌñenaꞌ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na seiljeii profeta Jeremías. Ee seineiiⁿ ñꞌoom tjañoomꞌ chiuu seichjooꞌnaꞌ nꞌom yolcu judías tsjoom Belén na jlaꞌcwjee sondaro ndana. ");
INSERT INTO amuNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Tsoom: Teicꞌuaa naquiiꞌ tsjoom Ramá na cwityuee londyee yocanchꞌu. Jndeii cwilaꞌxuaana, cwityueena cantyja ꞌnaaⁿ ndana meiⁿ taleiquiaanaꞌ na nnjoomna, ee tja̱ ndana. ");
INSERT INTO amuNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Jnda̱ na tueꞌ Herodes, quia joꞌ teitquiooꞌñenndaꞌ ángel cwentaaꞌ Tyꞌo̱o̱tsꞌom nnom José xjeⁿ na tsoomꞌm ndaa. Ndicwaⁿ mꞌaⁿna ndyuaa Egipto. ");
INSERT INTO amuNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Tso nnoom: —Quicantyjaꞌ, cjaꞌñꞌoomꞌ tyochjoo ñequio tsoñeeⁿ. Tsalcweꞌyoꞌ ndyuaa nnꞌaⁿ Israel. Ee jnda̱ tja̱ nnꞌaⁿ na ñelꞌueeꞌndye na ñeꞌcalaꞌcueeꞌ jom. ");
INSERT INTO amuNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Quia joꞌ teicantyjaaⁿ, tjañꞌoom tyochjoo ñꞌeⁿ tsondyee. Tyꞌelcweeꞌna ndyuaana ndyuaa Israel. ");
INSERT INTO amuNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Joo ncueeꞌñeeⁿ mꞌaaⁿ Arquelao tsꞌiaaⁿ tsꞌo̱ndaa Judea yuu na tyotsa̱ꞌntjom tsotyeeⁿ Herodes. Sa̱a̱ quia na jndii José na ljoꞌ, tꞌoom na nquiaⁿꞌaⁿ na nncjaⁿ Judea. Mati sꞌaanndaꞌ Tyꞌo̱o̱tsꞌom na tsoomꞌm ndaa na tancjaⁿ joꞌ joꞌ. Joꞌ chii tjaaⁿ cwiicheⁿ ntyja, tsꞌo̱ndaa Galilea. ");
INSERT INTO amuNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Tjaaⁿ cwii tsjoom na jndyu Nazaret. Joꞌ joꞌ ljooꞌñê. Na tuii na luaaꞌ seicanda̱a̱ꞌñenaꞌ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na tyoñeꞌquia profetas na nntseicajndyunaꞌ Jesús tsꞌaⁿ Nazaret. ");
INSERT INTO amuNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tueꞌntyjo̱ xuee na teitquiooꞌñe Juan, to̱o̱ⁿꞌo̱ⁿ na tyotseitsꞌoomñê nnꞌaⁿ. Tyoñequiaaⁿ ñꞌoom nda̱a̱na tsꞌo̱ndaa Judea jo ndoꞌ yuu tjaa nnꞌaⁿ cꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Tyotsoom: —Calcweꞌ nꞌomꞌyoꞌ ee juu na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom mandyocwjeꞌcañoomnaꞌ ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Cantyja ꞌnaaⁿꞌ Juanꞌñeeⁿ na tyotseineiⁿ profeta Isaías, tsoom: Mꞌaaⁿ cwii tsꞌaⁿ jo ndoꞌ yuu tjaa nnꞌaⁿ cꞌoom na jndeii matseineiⁿ nda̱a̱na. Matso tsaⁿꞌñeeⁿ: “Calajndaaꞌndyoꞌ naquiiꞌ nꞌomꞌyoꞌ chaꞌcwijom cwii nato na juu joꞌ nndyocwjeꞌcañoom nquii na cwiluiiñe na nntsa̱ꞌntjom ꞌo. Cataꞌndyoꞌxcweꞌyoꞌ chaꞌcwijom na cwilayo̱ꞌyoꞌ nato na nñoom.” ");
INSERT INTO amuNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juanꞌñeeⁿ tyocweⁿ liaa na tuii ñequio sooꞌ camello. Tyochuꞌtyeⁿ tsiaⁿꞌaⁿ ñequio cwii tjaⁿ. Ndoꞌ nantquie na tyocwaaⁿꞌaⁿ calcaa ntyueꞌ ñequio tsiomꞌ jnda̱a̱. ");
INSERT INTO amuNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ndoꞌ jndye nnꞌaⁿ tsjoom Jerusalén ñequio nnꞌaⁿ na mꞌaⁿ chaꞌwaa tsꞌo̱ndaa Judea ndoꞌ mati nnꞌaⁿ na mꞌaⁿ cantsu ꞌndyoo jndaa Jordán, tyoꞌoona na mꞌaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Seitsꞌoomñê joona tsꞌom jndaa Jordán jnda̱ na lcweꞌ nꞌomna jnaaⁿna. ");
INSERT INTO amuNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Sa̱a̱ quia na ntyꞌiaaⁿꞌaⁿ na jndye nnꞌaⁿ fariseos ñequio saduceos tquiona na mꞌaaⁿ na ñeꞌcwitsꞌoomndyena, quia joꞌ tsoom nda̱a̱na: —ꞌO cwiluiindyoꞌ chaꞌna canduu na cwileiꞌnomꞌyoꞌ na nquiaayoꞌ na nntꞌuiiwiꞌnaꞌ jooyoꞌ. Ee ꞌo cwinquioꞌyoꞌ na mꞌaaⁿya na nquiaꞌyoꞌ na nntseiwꞌii Tyꞌo̱o̱tsꞌom ꞌo. ¿ꞌÑeeⁿ tꞌmo̱ⁿ nda̱a̱ꞌyoꞌ na waa na nnda̱a̱ nluiꞌnꞌmaaⁿndyoꞌ nawiꞌ na quia nndyo? ");
INSERT INTO amuNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Caꞌndyeꞌyoꞌ na tisꞌa ndoꞌ calꞌaꞌyoꞌ yuu na ya, quia joꞌ mꞌmo̱ⁿnaꞌ na mayuuꞌcheⁿ cwilcweꞌ nꞌomꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Meiⁿ ticalasꞌandyoꞌ cheⁿncjoꞌyoꞌ naquiiꞌ nꞌomꞌyoꞌ na nnduꞌyoꞌ: “Jaa tjaa na teincuuꞌ nacjooya ee Abraham cwiluiiñê weloo welooya.” Candyeꞌyoꞌ nntsjo̱o̱, meiiⁿ cweꞌ ljo̱ꞌmeiiⁿ nnda̱a̱ nntseicwaqueⁿ Tyꞌo̱o̱tsꞌom na nluiindyenaꞌ tsjaaⁿ Abraham na jndyowicantyjooꞌ, quia joꞌ nꞌndiinaꞌ ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ꞌO matseijomnaꞌ chaꞌcwijom nꞌoom na tisꞌa ta̱ cwilꞌa. Ndoꞌ manquiuꞌyoꞌ nꞌoom na ticalꞌa ta̱ naya, maxjeⁿ nntꞌuanaꞌ. Ndoꞌ xeⁿ jnda̱ tꞌua nꞌoomꞌñeeⁿ nntioom nnꞌaⁿ joonaꞌ quiiꞌ chom. Maluaaꞌ matseijomnaꞌ nntsꞌaa Tyꞌo̱o̱tsꞌom ñꞌeⁿndyoꞌ ꞌo xeⁿ ticalꞌaꞌyoꞌ yuu na ya. ");
INSERT INTO amuNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ja mayuuꞌ matseitsꞌo̱o̱ⁿndyo̱ ꞌo ñequio ndaatioo ee na cwilcweꞌ nꞌomꞌyoꞌ. Sa̱a̱ mandyontyjo̱ nqueⁿ na nntseitsꞌoomñê ꞌo ñequio Espíritu Santo naquiiꞌ nꞌomꞌyoꞌ ndoꞌ ñequio chom. Nqueⁿ tꞌmaⁿti tseixmaaⁿ, nchiiti ja. Meiⁿ ticatseixmaⁿya na cweꞌ ja nntꞌuiya lcoomꞌm na nñequiaya joonaꞌ na nñjoom. ");
INSERT INTO amuNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Jnda̱ jaawindyooꞌ na nntuꞌxeⁿndyoꞌ ee laxmaⁿꞌyoꞌ chaꞌcwijom lqueeⁿ na ndicwaⁿ cwajndii. Luaa tsꞌiaaⁿ cantyja ꞌnaaⁿꞌ lqueeⁿ. Matseicueeñe tsꞌaⁿ lqueeⁿ hasta na nljuꞌñꞌeⁿ. Jnda̱ chii nntseiweeⁿ lqueeⁿ na ya naquiiꞌ wꞌaa. Sa̱a̱ nchuaaꞌnaꞌ njñoom chom. Maluaaꞌ matseijomnaꞌ na nntsꞌaa Tyꞌo̱o̱tsꞌom. Nnꞌaⁿ na ya cwilꞌa macoꞌñoom joona sa̱a̱ nnꞌaⁿ na tisꞌa cwilꞌa, nntseicoom joona ñequio chom na tijoom canduuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Quia joꞌ jnaⁿ Jesús tsꞌo̱ndaa Galilea, tjaaⁿ jndaa Jordán na nntseitsꞌoomñe Juan jom. ");
INSERT INTO amuNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Sa̱a̱ tiñeꞌnquiaañe Juan na caluii na ljoꞌ. Tsoom: —Cwa jnda̱ tyjeꞌcañoomꞌ ja na catseitsꞌoomndyo̱ ꞌu meiiⁿ na matsonaꞌ na ꞌu catseitsꞌoomndyuꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Tꞌo̱ Jesús, matsoom nnom: —Jeꞌ quiaandyuꞌtoꞌ na caluii na ljoꞌ. Ee macaⁿnaꞌ na laaꞌtiꞌ calacanda̱a̱ꞌndyo̱ chaꞌtso cantyja na matyꞌiomyanaꞌ. Ndoꞌ tancueeꞌ Juan. ");
INSERT INTO amuNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jnda̱ na teitsꞌoomñe Jesús, jlueeⁿꞌeⁿ quiiꞌ ndaa. Ndoꞌ seicanaaⁿñenaꞌ tsjo̱ꞌluee. Ntyꞌiaaⁿꞌaⁿ Espíritu na cwiluiiñe Tyꞌo̱o̱tsꞌom ndyocue chaꞌcwijom catuꞌ. Jndyocaljo nacjoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ndoꞌ nandye cañoomꞌluee teicꞌuaa na seineiⁿ Tyꞌo̱o̱tsꞌom. Tsoom: —Luaañe Jndaaya na jeeⁿ candyaꞌ tsꞌo̱o̱ⁿ. Cantyja ꞌnaaⁿꞌ jom mañequiaanaꞌ na neiⁿya. ");
INSERT INTO amuNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Jnda̱ joꞌ tjañꞌoom Espíritu Santo Jesús jo ndoꞌ yuu tjaa nnꞌaⁿ cꞌom. Joꞌ joꞌ tyoqueⁿñe tsaⁿjndii na nntsꞌaa xjeⁿ jom. ");
INSERT INTO amuNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Tyomꞌaaⁿ wenꞌaaⁿ xuee ndoꞌ wenꞌaaⁿ tsjom tîcwaaⁿꞌaⁿ, jnda̱ chii jndyo na ñejnoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ndoꞌ tyjeꞌcañoom tsaⁿjndii na machꞌee xjeⁿ nnꞌaⁿ. Tso nnoom: —Xeⁿ mayuuꞌcheⁿ cwiluiindyuꞌ Jnda Tyꞌo̱o̱tsꞌom, cwa catsa̱ꞌntjomꞌ ljo̱ꞌmeiiⁿ na catseicwaqueⁿnaꞌ tyooꞌ joonaꞌ na nlcwaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Tꞌo̱ Jesús: —Ja xocatsꞌaa na ljoꞌ ee waa ljeii ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom na matsonaꞌ: “Nchii cweꞌ cantyja ꞌnaaⁿꞌ tyooꞌ na wandoꞌ tsꞌaⁿ, sa̱a̱ cantyja ꞌnaaⁿ chaꞌtso ñꞌoom na mañequiaa Tyꞌo̱o̱tsꞌom.” ");
INSERT INTO amuNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Jnda̱ joꞌ tjañꞌoom tsaⁿjndii Jesús Jerusalén tsjoom na ljuꞌ cwentaaꞌ Tyꞌo̱o̱tsꞌom. Tqueeⁿ juu xqueⁿ tsiuꞌ watsꞌom tꞌmaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Tsoom nnom Jesús: —Xeⁿ mayuuꞌcheⁿ cwiluiindyuꞌ Jnda Tyꞌo̱o̱tsꞌom, cwa cjuꞌndyuꞌ jo nacje. Ee luaa matso ñꞌoom ꞌnaaⁿꞌaⁿ: Nquii Tyꞌo̱o̱tsꞌom nñequiaaⁿ ꞌu luee ángeles cwentaaⁿꞌaⁿ na calꞌana cwenta ꞌu. Ndoꞌ nntyjeeꞌ lueena ꞌu cha tincjaacañjom ljo̱ꞌ ncꞌeꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Quia joꞌ tꞌo̱ Jesús nnom, tsoom: —Ja tijoom catsꞌaa chaꞌna matsuꞌ luaaꞌ ee mati waa cwiicheⁿ ljeii ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom na matsonaꞌ: “Tintsaꞌ xjeⁿ Ta Tyꞌo̱o̱tsꞌom cwentaꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Jnda̱ chii tjañꞌoom tsaⁿjndii Jesús cwii sjo̱ nandye. Joꞌ joꞌ tꞌmo̱o̱ⁿ nnom chaꞌtsoti nꞌiaaⁿ tꞌmaⁿ na mꞌaⁿ nnꞌaⁿ tsjoomnancue, ñequio na tꞌmaⁿ matseitꞌmaaⁿꞌñenaꞌ joo. ");
INSERT INTO amuNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ndoꞌ tsoom nnom: —Chaꞌtso nmeiⁿꞌ nntio̱o̱ lꞌo̱ꞌ xeⁿ nlcoꞌ xtyeꞌ na nntseitꞌmaaⁿꞌndyuꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ndoꞌ tꞌo̱ Jesús nnoom, tso: —Quindyo̱o̱ꞌ nacañomya ꞌu Satanás, ee ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na teiljeii matsonaꞌ: “Catseitꞌmaaⁿꞌndyuꞌ nquii Ta Tyꞌo̱o̱tsꞌom cwentaꞌ, ndoꞌ macanda̱ nnom nqueⁿ candiꞌntjomꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Quia joꞌ ꞌndii tsaⁿjndii jom. Ndoꞌ tquieꞌcañom ángeles, tyondyeꞌntjomna nnoom. ");
INSERT INTO amuNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Quia jndii Jesús na jnda̱ mamꞌaaⁿ Juan pra̱so, tjalcweeⁿꞌeⁿ tsꞌo̱ndaa Galilea. ");
INSERT INTO amuNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Tjaaⁿ tsjomꞌm Nazaret, sa̱a̱ taticaljooꞌñê joꞌ joꞌ. Tjaaⁿ na nljooꞌñê tsjoom Capernaum na mꞌaaⁿnaꞌ ꞌndyoo ndaaluee. Joꞌ joꞌ ndyuaa cwentaa nnꞌaⁿ tmaaⁿꞌ Zabulón ñequio Neftalí. ");
INSERT INTO amuNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ndoꞌ joo ndyuaaꞌñeeⁿ tyomꞌaaⁿ cha nntseicanda̱a̱ꞌñenaꞌ ñꞌoom na seiljeii profeta Isaías, matsonaꞌ: ");
INSERT INTO amuNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Nntseixueeñenaꞌ jo nda̱a̱ nnꞌaⁿ na mꞌaⁿ ndyuaa cwentaaꞌ Zabulón ndoꞌ jo nda̱a̱ nnꞌaⁿ na mꞌaⁿ ndyuaa cwentaaꞌ Neftalí. Nntseixueeñenaꞌ jo nda̱a̱ nnꞌaⁿ na mꞌaⁿ ndyuaa ꞌndyoo ndaaluee, ñequio ndyuaa xndyaaꞌ jndaa Jordán, ñequio tsꞌo̱ndaa Galilea yuu na mꞌaⁿ nnꞌaⁿ na nchii nnꞌaⁿ judíos. ");
INSERT INTO amuNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Naⁿꞌñeeⁿ mꞌaⁿna nacje ꞌnaaⁿꞌ najaaⁿñe, sa̱a̱ jeꞌ jeꞌ jnda̱ teitquiooꞌ cwii na jeeⁿ caxueeñe jo nda̱a̱na. Ndoꞌ mati mꞌaⁿna na manchjenaꞌ joona na wiꞌ cwitjoomna, sa̱a̱ jeꞌ jnda̱ seicaxueeñenaꞌ jo nda̱a̱na. ");
INSERT INTO amuNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Xjeⁿꞌñeeⁿ jnaⁿnaꞌ na to̱ꞌ Jesús na tyoñequiaaⁿ ñꞌoom. Tsoom: —Calcweꞌ nꞌomꞌyoꞌ, ee juu na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom mandyocwjeꞌcañoomnaꞌ ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Xjeⁿ na mawinom Jesús ꞌndyoo ndaaluee Galilea, ljeiiⁿ we nnꞌaⁿ na ñenquii tsꞌaⁿ ntseinda, Simón, tsaⁿ na jndyu Pedro ñequio Andrés tyjee tsaⁿꞌñeeⁿ. Cwitueeꞌna tsquiꞌ ꞌnaaⁿna tsꞌom ndaaluee ee nnꞌaⁿ cwitjeiiꞌ calcaa joona. ");
INSERT INTO amuNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Tso Jesús nda̱a̱na: —Quiolajomndyoꞌ ñꞌeⁿndyo̱ ndoꞌ ja nntsꞌaa na nlaꞌtjomꞌyoꞌ nnꞌaⁿ tachii cweꞌ calcaa. ");
INSERT INTO amuNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Joona mañoomꞌ ꞌndyena nlquiꞌ ꞌnaaⁿna, tyꞌelaꞌjomndyena ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Ndoꞌ na tja tjatyeeⁿ ljeiiⁿ cwiicheⁿ we tsꞌaⁿ, ntseinda Zebedeo naⁿꞌñeeⁿ, Jacobo ñꞌeⁿ tyjeeⁿ Juan. Ñjomndyena tsꞌom wꞌaandaa. Cwilaꞌyo̱na nlquiꞌ ꞌnaaⁿna ñequio tsotyena Zebedeo. Quia joꞌ tꞌmaⁿ Jesús joona. ");
INSERT INTO amuNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ndoꞌ mañoomꞌ ꞌndyena wꞌaandaa ñꞌeⁿ tsotyena, tyꞌelajomndyena ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Tyomanom Jesús chaꞌwaa tsꞌo̱ndaa Galilea. Tyoꞌmo̱o̱ⁿ nda̱a̱ nnꞌaⁿ naquiiꞌ lanꞌom ꞌnaaⁿna. Tyoñequiaaⁿ ñꞌoom naya cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. Ndoꞌ tyotseinꞌmaaⁿ nnꞌaⁿ chaꞌtso nnom ntycu na wiina. ");
INSERT INTO amuNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Ndoꞌ tꞌom ñꞌoom cantyja ꞌnaaⁿꞌaⁿ chaꞌwaa ndyuaa Siria. Naⁿꞌñeeⁿ tquiochona chaꞌtso nnꞌaⁿwii na mꞌaaⁿ na cwitjoom jndye nnom ntycu ñequio na maquiinaꞌ joo. Mati ñꞌeeⁿ nnꞌaⁿ na cwileiꞌcho jndyetia joo, ñꞌeeⁿ nnꞌaⁿ na maleiñꞌoom tycuweeꞌ, ndoꞌ ñꞌeeⁿ nnꞌaⁿ na cwitjoom tycutqueeⁿ. Seinꞌmaaⁿ joona. ");
INSERT INTO amuNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Joꞌ chii tꞌmaⁿ ntmaaⁿꞌ nnꞌaⁿ tyꞌentyjo̱ naxeeⁿꞌeⁿ. Jnaⁿ naⁿꞌñeeⁿ tsꞌo̱ndaa Galilea, ñꞌeⁿ nnꞌaⁿ ndyuaa njoom Decápolis, ñꞌeⁿ tsjoom Jerusalén, ñꞌeⁿ tsꞌo̱ndaa Judea, ndoꞌ xndyaaꞌ jndaa Jordán. ");
INSERT INTO amuNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Quia na ntyꞌiaaꞌ Jesús na jndye nnꞌaⁿ, tjawaaⁿ cwii ta. Jnda̱ na tjacjom, tyꞌentyjaꞌ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","To̱o̱ⁿꞌo̱ⁿ na tꞌmo̱o̱ⁿ nda̱a̱na. ");
INSERT INTO amuNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Tsoom: —Mañequiaanaꞌ na neiiⁿ nnꞌaⁿ na cwilaꞌno̱ⁿꞌ na ntyꞌiaandye jo nnom Tyꞌo̱o̱tsꞌom, ee naⁿꞌñeeⁿ cwilaꞌjomndyena cantyja na matsa̱ꞌntjoom. ");
INSERT INTO amuNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","’Mañequiaanaꞌ na neiiⁿ nnꞌaⁿ na chjooꞌ nꞌom cantyja jnaaⁿna, ee quia nñequiaa Tyꞌo̱o̱tsꞌom na tꞌmaⁿ nꞌomna. ");
INSERT INTO amuNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","’Mañequiaanaꞌ na neiiⁿ nnꞌaⁿ na cwitueeꞌndyecje jo nnom Tyꞌo̱o̱tsꞌom ee nndaana na nncꞌomna tsjoomnancue xco. ");
INSERT INTO amuNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","’Mañequiaanaꞌ na neiiⁿ nnꞌaⁿ na mꞌaⁿna chaꞌcwijom na ñeꞌjndoꞌna ndoꞌ ñeꞌcwena ee na ntyjaaꞌ nꞌomna na nnda̱a̱ nlꞌana yuu na matyꞌiomyanaꞌ. Ee canda̱a̱ꞌya nñequiaa Tyꞌo̱o̱tsꞌom na cwicantyjaaꞌ nꞌomna. ");
INSERT INTO amuNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","’Mañequiaanaꞌ na neiiⁿ nnꞌaⁿ na mꞌaⁿ na wiꞌ nꞌom ncꞌiaa, ee nncꞌoom Tyꞌo̱o̱tsꞌom na wiꞌ tsꞌoom joona. ");
INSERT INTO amuNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","’Mañequiaanaꞌ na neiiⁿ nnꞌaⁿ na ljuꞌ naquiiꞌ nꞌom, ee nntyꞌiaa nda̱a̱na nquii Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","’Mañequiaanaꞌ na neiiⁿ nnꞌaⁿ na cwitaꞌya ncꞌiaa na cwilaꞌntjaꞌndye, ee nntseicajndyu Tyꞌo̱o̱tsꞌom joona ntseinaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","’Mañequiaanaꞌ na neiiⁿ nnꞌaⁿ na cwintyjo̱ ncꞌiaana joona ncꞌe na mꞌaⁿna cantyja na matyꞌiomyanaꞌ, ee laꞌxmaⁿ naⁿꞌñeeⁿ cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","’Mañequiaanaꞌ na neiⁿꞌyoꞌ quia na cwilaꞌjnaaⁿꞌ nnꞌaⁿ ꞌo, ndoꞌ quia cwitaꞌwiꞌna ꞌo ndoꞌ cwitueeꞌna chaꞌtso nnom ñꞌoomwiꞌ nacjoꞌyoꞌ na cweꞌ cantu ncꞌe na mꞌaⁿꞌyoꞌ cantyja ꞌnaⁿya. ");
INSERT INTO amuNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Cꞌomꞌyoꞌ na tꞌmaⁿ nꞌomꞌyoꞌ ndoꞌ catseicwaljooꞌtinaꞌ na neiⁿꞌyoꞌ ee tꞌmaⁿ naya cwentaꞌyoꞌ cwiwiwe cañoomꞌluee. Ee malaaꞌtiꞌ tyoleiꞌntyjo̱ nnꞌaⁿ profetas na tyoñeꞌquia ñꞌoomꞌ Tyꞌo̱o̱tsꞌom tandyo xuee, cwii tjo̱o̱cheⁿ na nntjomꞌ ꞌo nawiꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","’ꞌO cwiluiindyoꞌ tsjaaⁿꞌchjeⁿꞌ, sa̱a̱ xeⁿ na jnda̱ jluiꞌ na chjeⁿꞌnaꞌ, ¿ljoꞌ ñꞌeⁿ cwii nleichjeⁿꞌnndaꞌnaꞌ? Meiⁿchjoo tjaa yuu cwii nleilꞌuenaꞌ, joꞌ chii cweꞌ cwityeⁿnquieeꞌ nnꞌaⁿ ndoꞌ cwicandyuena joonaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","’ꞌO cwiluiindyoꞌ chom na cwiwixuee jo nda̱a̱ nnꞌaⁿ tsjoomnancue. Cwii tsjoom na wacatyeeⁿ xqueⁿ ta, xocanda̱a̱ nncwantyꞌiu juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Mati xotseicwꞌaa tsꞌaⁿ cwii xjocanti ndoꞌ nncwjaaꞌñeyom juunaꞌ nacjeeꞌ tsꞌoom castom. Maxjeⁿ nntseintyja tsꞌaⁿ juunaꞌ cha ya nntseixueenaꞌ nda̱a̱ chaꞌtso nnꞌaⁿ na mꞌaⁿ naquiiꞌ wꞌaa. ");
INSERT INTO amuNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Malaaꞌtiꞌ cꞌomꞌ ꞌo na calaxueendyoꞌ nda̱a̱ nnꞌaⁿ cha nlaꞌno̱ⁿꞌna na cwilꞌaꞌyoꞌ chaꞌtso nnom na matyꞌiomyanaꞌ. Ndoꞌ cantyja ꞌnaⁿꞌyoꞌ nlaꞌtꞌmaaⁿꞌndyena Tsotyeꞌyoꞌ na mꞌaaⁿ cañoomꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Mati tso Jesús: —Ticalaꞌtiuuꞌyoꞌ na jndyo̱o̱ na nntseityuiiꞌa chiuu waa na tꞌmaⁿ ljeii na tqueⁿ Moisés, meiⁿ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na tyoñeꞌquia profetas. Jndyo̱o̱ na nntseicanda̱ya joonaꞌ cha nleiꞌtquiooꞌ chiuu waa na mayuuꞌcheⁿ ñeꞌcatꞌmo̱o̱ⁿnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ee mayuuꞌcheⁿ nndyeꞌyoꞌ nntsjo̱o̱, yocheⁿ na ndicwaⁿ waa tsjo̱ꞌluee ñequio tsjoomnancue, xocaꞌndiinaꞌ meiⁿcwii ljeii cachjoo na ndiiꞌnaꞌ naquiiꞌ ljeii na tqueⁿ Moisés, hasta xjeⁿ jnda̱ jluiꞌljuuꞌñꞌeⁿnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ncꞌe na luaaꞌ, meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na titseicanda̱ cwii ñꞌoommeiiⁿ na cachjoonaꞌ, ndoꞌ maꞌmo̱o̱ⁿ nda̱a̱ ncꞌiaaⁿꞌaⁿ ya meiiⁿ tilaꞌcanda̱na juunaꞌ, tjaa yuu lꞌueñê cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. Sa̱a̱ ꞌñeeⁿ juu na matseicanda̱ ñꞌoommeiiⁿ ndoꞌ naljoꞌ maꞌmo̱ⁿ na calꞌa ncꞌiaaꞌ, juu matseijndaaꞌñenaꞌ na tꞌmaⁿ lꞌueñe cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Joꞌ chii candyeꞌyoꞌ nntsjo̱o̱, xeⁿ tilacanda̱a̱ꞌndyoꞌtiꞌyoꞌ jo nnom Tyꞌo̱o̱tsꞌom, nchiiti na cwilꞌa nnꞌaⁿ fariseos ñequio nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés, quia joꞌ xonnda̱a̱ ntsaquieeꞌndyoꞌ cantyja na matsa̱ꞌntjoom. Macaⁿnaꞌ na ꞌo nncwinomꞌtiꞌyoꞌ na ya nlꞌaꞌyoꞌ nchiiti chaꞌna cwilꞌa naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","’ꞌO jnda̱ jndyeꞌyoꞌ ñꞌoom na tyolue nnꞌaⁿ nda̱a̱ welooya na matsonaꞌ: “Tintseicueꞌ xꞌiaꞌ ndoꞌ meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na nntsꞌaa na ljoꞌ, maxjeⁿ nntꞌuiityeⁿnaꞌ juu.” ");
INSERT INTO amuNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Joꞌ chii nndyeꞌyoꞌ nntsjo̱o̱, meiiⁿ cweꞌ na nntseiwꞌii tsꞌaⁿ xꞌiaaꞌ maxjeⁿ nntꞌuiityeⁿnaꞌ jom. Ndoꞌ meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na matseineiⁿ ñꞌomjnaaⁿꞌ nnom xꞌiaaꞌ, maxjeⁿ nntuꞌxeⁿ nnꞌaⁿ na cwiluiitquiendye watsꞌom tꞌmaⁿ juu. Ndoꞌ meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na nntseijoomꞌñe quiooꞌ xꞌiaaꞌ, maxjeⁿ matsonaꞌ na nntioomñê juunaꞌ naquiiꞌ chom bꞌio. ");
INSERT INTO amuNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","’Joꞌ chii quia na maꞌtiooꞌ ꞌnaⁿ jo nnom tio na mañequiaaꞌ cwentaaꞌ Tyꞌo̱o̱tsꞌom, ndoꞌ xeⁿ juu xjeⁿꞌñeeⁿ macjaañjoomꞌ tsꞌomꞌ na tiya mꞌaaⁿ xꞌiaꞌ ñꞌeⁿndyuꞌ, ");
INSERT INTO amuNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","quia joꞌ caꞌndiiꞌ ꞌnaⁿꞌ joꞌ joꞌ, chii cjaꞌ, catsaꞌjndyeeꞌ na caljoyaandyoꞌ ñꞌeⁿ xꞌiaꞌ. Nda̱nquia, chii candyoꞌnndaꞌ na nñequiaaꞌ cwentaaꞌ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","’Yocheⁿ na ndicwaⁿ wanaaⁿ, queⁿndyuꞌ na caljondyoꞌyaꞌyoꞌ ñꞌoom na maleichuunaꞌ ꞌo ñꞌeⁿ xꞌiaꞌ cha tintsꞌaanaꞌ na juu tsꞌaⁿ na mꞌaⁿꞌntiaaꞌndyoꞌ ñꞌeⁿñe nntseiquioom ꞌu lꞌo̱ jwe. Ndoꞌ jweꞌñeeⁿ nñequiaaⁿ cwenta ꞌu luee sondaro, Ndoꞌ joona mana nntueeꞌna ꞌu wꞌaancjo. ");
INSERT INTO amuNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Mayuuꞌcheⁿ matsjo̱o̱ njomꞌ, xocaluiꞌ joꞌ joꞌ, hasta quia na jnda̱ tiomꞌnchaaꞌndyuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","’ꞌO jnda̱ jndyeꞌyoꞌ ñꞌoom na tyoñeꞌquia nnꞌaⁿ na matsonaꞌ: “Tijoom xuee nncꞌoomꞌyaꞌ ñꞌeⁿ cwiicheⁿ tsꞌaⁿ.” ");
INSERT INTO amuNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Sa̱a̱ nndyeꞌyoꞌ nntsjo̱o̱, meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na cweꞌ mantyꞌiaaꞌ cwii yuscu na matseiqueeⁿ tsꞌoom juu, maxjeⁿ matsonaꞌ na mamꞌaaⁿyaaⁿ ñꞌeⁿñe ee na luaaꞌ matseitioom. ");
INSERT INTO amuNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","’Macweꞌ joꞌ xeⁿ cantyja na mantyꞌiaꞌ wjaañꞌoomnaꞌ ꞌu na matseiꞌtjo̱o̱ndyuꞌ nnom Tyꞌo̱o̱tsꞌom, queⁿꞌ cheⁿnncuꞌ xjeⁿ chaꞌcwijom na macwjiꞌ tsꞌom njomꞌ ndoꞌ matquieꞌ juunaꞌ cha taxocatseitjo̱o̱ndyuꞌtiꞌ. Ee ñecuaa meiiⁿ na tacanda̱a̱ꞌndyuꞌ sa̱a̱ nncuꞌ nluiꞌnꞌmaaⁿndyuꞌ. Ndoꞌ xeⁿ tiñeꞌqueⁿꞌ cheⁿnncuꞌ xjeⁿ cantyja ꞌnaⁿꞌ, meiiⁿ na canda̱a̱ꞌndyuꞌ ñeꞌcꞌoomꞌ, meiⁿchiuucheⁿ bꞌio nncjuꞌnaꞌ ꞌu. ");
INSERT INTO amuNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ndoꞌ xeⁿ wjaañꞌoomnaꞌ ꞌu na matseiꞌtjo̱o̱ndyuꞌ nnom Tyꞌo̱o̱tsꞌom jnaaⁿꞌ tsꞌo̱ꞌ ntyjaya, queⁿꞌ cheⁿnncuꞌ xjeⁿ chaꞌcwijom na matyjeeꞌ ndoꞌ matquieꞌ juunaꞌ cha xotseitjo̱o̱ndyuꞌtiꞌ. Ee ñecuaa meiiⁿ na tacanda̱a̱ꞌndyuꞌ sa̱a̱ nncuꞌ nluiꞌnꞌmaaⁿndyuꞌ. Ee xeⁿ tiqueⁿꞌ cheⁿnncuꞌ xjeⁿ cantyja ꞌnaⁿꞌ, meiiⁿ na canda̱a̱ꞌndyuꞌ ñeꞌcꞌoomꞌ, maxjeⁿ nncjuꞌnaꞌ ꞌu bꞌio. ");
INSERT INTO amuNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","’Mati waa ñꞌoom na tyoñequiaa Moisés na meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na matseityuiiꞌ ljeii ꞌnaaⁿꞌ ñꞌeⁿ scuuꞌ, tsaⁿꞌñeeⁿ nnoomꞌm na nluii ljeii cantyja na mato̱ⁿꞌñê ñꞌeⁿ scoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Sa̱a̱ jeꞌ candyeꞌyoꞌ ñꞌoom na nntsjo̱o̱ nnco̱. Meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na matseityuiiꞌ ljeii ꞌnaaⁿꞌ ñꞌeⁿ scuuꞌ, cwii na meiⁿnquia na sꞌaa scoomꞌm na nchii ñetꞌoomya ñequio cwiicheⁿ tsꞌaⁿ, chaꞌcwijom nqueⁿ machꞌeeⁿ na cꞌoomya scoomꞌm ñꞌeⁿ cwiicheⁿ tsꞌaⁿ. Ndoꞌ meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na nncoco ñꞌeⁿ yuscuꞌñeeⁿ, matsonaꞌ na cweꞌ mꞌaⁿyana. ");
INSERT INTO amuNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","’Mati jnda̱ jndyeꞌyoꞌ ñꞌoom na tyolue nnꞌaⁿ teiyo nda̱a̱ welooya na matsonaꞌ: “Tilqueⁿꞌtyeⁿꞌ ñꞌoom na ntyjiꞌyaꞌ na xonda̱a̱ nntseicanda̱a̱ꞌndyuꞌ, sa̱a̱ ñꞌoom na jnda̱ tqueⁿꞌtyeⁿꞌ, catseicanda̱a̱ꞌndyuꞌ juunaꞌ nnom Ta Tyꞌo̱o̱tsꞌom.” ");
INSERT INTO amuNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Sa̱a̱ jeꞌ nnco̱ matsjo̱o̱ nndyeꞌyoꞌ: Meiⁿcwii ñꞌoom tilqueⁿꞌtyeⁿꞌyoꞌ na nntjeiꞌyoꞌyoꞌ ñꞌoom jiiꞌ Tyꞌo̱o̱tsꞌom. Ee jom tjacantyja na tꞌmaⁿ cwiluiiñê. Mati meiⁿcwii ñꞌoom tilqueⁿꞌtyeⁿꞌyoꞌ na nntjeiꞌyoꞌyoꞌ ñꞌoom na ntyjii cañoomꞌluee, ee juunaꞌ cwiluiiñenaꞌ ndio ꞌnaaⁿꞌaⁿ, ndoꞌ na ljoꞌ nnduꞌyoꞌ matseijomnaꞌ na cwinduꞌyoꞌ jiiꞌ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Meiⁿcwii ñꞌoom tilqueⁿꞌtyeⁿꞌyoꞌ na nntjeiꞌyoꞌyoꞌ ñꞌoom na ntyjii tsjoomnancue, ee juunaꞌ mꞌaaⁿnaꞌ nacje ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom. Ndoꞌ na nnduꞌyoꞌ naljoꞌ, matseijomnaꞌ na cwinduꞌyoꞌ jiiꞌ Tyꞌo̱o̱tsꞌom. Ndoꞌ meiⁿcwii ñꞌoom tilqueⁿꞌtyeⁿꞌyoꞌ na nntjeiꞌyoꞌyoꞌ ñꞌoom na ntyjii tsjoom Jerusalén, ee tsjoomꞌñeeⁿ cwiluiiñenaꞌ tsjoomꞌ nquii Tyꞌo̱o̱tsꞌom na matsa̱ꞌntjom. Ndoꞌ na nnduꞌyoꞌ naljoꞌ matseijomnaꞌ na cwinduꞌyoꞌ jiiꞌ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ndoꞌ meiⁿcwii ñꞌoom tilqueⁿꞌtyeⁿꞌ cjoꞌ nncuꞌ ee ꞌu tjaa ljoꞌ tseixmaⁿꞌ na nntsaꞌ na nleicanchiiꞌ oo nleintom meiiⁿ ñeꞌcwii sooxqueⁿꞌ. Macanda̱ nquii Tyꞌo̱o̱tsꞌom nnda̱a̱ nntsꞌaaⁿ na ljoꞌ. Joꞌ chii na nntsuꞌ ñꞌoomꞌñeeⁿ matseijomnaꞌ na matsuꞌ jiiꞌ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Quia na macwjiꞌyuuꞌndyuꞌ cwii ñꞌoom ndoꞌ matsuꞌ na mayuuꞌ juunaꞌ, catsꞌaanaꞌ na mayuuꞌ ñꞌoomꞌñeeⁿ. Ndoꞌ quia na matsuꞌ na tiyuuꞌ, catsꞌaanaꞌ na tiyuuꞌ ñꞌoomꞌñeeⁿ. Ee cantyjati ñꞌoom na nntseicwaljoꞌtiꞌ na nntseijndeiiꞌ ꞌndyoꞌ hasta nntseitiuuꞌ na nntsuꞌ jiiꞌ Tyꞌo̱o̱tsꞌom, ñꞌoomꞌñeeⁿ cwinaⁿnaꞌ na mꞌaaⁿ nquii tsaⁿjndii. ");
INSERT INTO amuNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","’ꞌO jnda̱ jndyeꞌyoꞌ ñꞌoom na tyolue nnꞌaⁿ teiyo na matsonaꞌ: “Cwaaⁿ cwii nnom nawiꞌ machꞌee tsꞌaⁿ ñꞌeⁿ xꞌiaaⁿꞌaⁿ, mati nleijndaaꞌ na nntjom jom. Aa tsꞌomnnom xꞌiaaⁿꞌaⁿ seiquieeꞌñê, mati catjom jom. Aa tseiꞌnꞌom xꞌiaaⁿꞌaⁿ tcoom, maxjeⁿ mati jom majoꞌti catjoom.” ");
INSERT INTO amuNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Sa̱a̱ jeꞌ nnco̱ matsjo̱o̱ nndyeꞌyoꞌ: Tilꞌueendyuꞌ na nnjoom quia na macoꞌwiꞌ tsꞌaⁿ ꞌu. Ee meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na mmeiⁿꞌ ndaꞌ ntsmaⁿꞌ ntyjaya, mati ntyjatymaaⁿꞌ quiaaꞌ na mmeiiⁿꞌeⁿ ndaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ꞌÑeeⁿ juu na maqueⁿ ñꞌoom nacjoꞌ na ñeꞌcueeꞌ ñꞌoom ꞌu watsꞌiaaⁿ ñeꞌcwjeeⁿꞌeⁿ cotomꞌ, mati quiaaꞌ na nncjaañꞌoom liaasoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ꞌÑeeⁿ juu na machꞌee na jndeiꞌnaꞌ cjaꞌ ñꞌeⁿñê na ncjaꞌchuꞌ xuu ꞌnaaⁿꞌaⁿ cwii kilómetro, cjaꞌ meiiⁿ we. ");
INSERT INTO amuNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tsꞌaⁿ na macaⁿ ꞌnaⁿ njomꞌ, quiaaꞌ nnoom, ndoꞌ tsꞌaⁿ na maco̱ⁿ, nchii nntsaꞌ ndooꞌ ticandiꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","’Mati ꞌo jnda̱ jndyeꞌyoꞌ ñꞌoom na tyolue nnꞌaⁿ teiyo, na matsonaꞌ: “Catsaꞌ na wiꞌ tsꞌomꞌ xꞌiaꞌ ndoꞌ catseita̱a̱ꞌ tsꞌomꞌ tsꞌaⁿ na jndooꞌ ꞌu.” ");
INSERT INTO amuNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Sa̱a̱ jeꞌ nnco̱ matsjo̱o̱ nndyeꞌyoꞌ: Calꞌaꞌyoꞌ na wiꞌ nꞌomꞌyoꞌ nnꞌaⁿ na jndoo ꞌo. Ndoꞌ calaneiⁿꞌyoꞌ nnom Tyꞌo̱o̱tsꞌom cantyja ꞌnaaⁿ nnꞌaⁿ na cwitaꞌwiꞌ ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Quia joꞌ nluiindyoꞌ ntseinda Tsotyeꞌyoꞌ na mꞌaaⁿ cañoomꞌluee. Ee jom machꞌeeⁿ na mantyꞌiaaꞌ ñeꞌquioomꞌ ꞌnaaⁿꞌaⁿ nnꞌaⁿ na ya nnꞌaⁿndye ndoꞌ mati nnꞌaⁿ na wiꞌndye. Ndoꞌ matseicuaaꞌaⁿ yuu na mꞌaⁿ nnꞌaⁿ na cwilꞌa na matyꞌiomyanaꞌ, ndoꞌ nnꞌaⁿ na cwilꞌa na ticatyꞌiomyanaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ee xeⁿ macanda̱ nnꞌaⁿ na wiꞌ nꞌom ꞌo, cwilꞌaꞌyoꞌ na wiꞌ nꞌomꞌyoꞌ, ¿aa cwilaꞌtiuuꞌyoꞌ na cjaaweeꞌ tsꞌom Tyꞌo̱o̱tsꞌom? ¿Aa nchii majoꞌti cwilꞌa nnꞌaⁿ na cwitoꞌñoom sꞌom cwentaaꞌ gobiernom? ");
INSERT INTO amuNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ndoꞌ xeⁿ cweꞌ ncjoondyoꞌ cwiñeꞌquiaꞌyoꞌ na xmaⁿndyoꞌ, ¿yuuwaa na jeeⁿ ya cwilꞌaꞌyoꞌ? Ee malaaꞌtiꞌ mꞌaⁿ nnꞌaⁿ na tyoolaꞌtꞌmaaⁿꞌndye Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Cꞌomꞌyoꞌ na canda̱a̱ꞌ na wiꞌ nꞌomꞌyoꞌ nnꞌaⁿ chaꞌxjeⁿ nquii Tsotyeꞌyoꞌ na mꞌaaⁿ cañoomꞌluee, canda̱a̱ꞌ mꞌaaⁿ na candyaꞌ tsꞌoom joona. ");
INSERT INTO amuNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","’Queⁿꞌyoꞌ cwenta quia na nlꞌaꞌyoꞌ cwii nnom na matyꞌiomyanaꞌ, nchii nlꞌaꞌyoꞌ cweꞌ cha na cantyꞌiaa nnꞌaⁿ, ee xeⁿ na ljoꞌ, tjaaꞌnaⁿ naya ꞌnaⁿꞌyoꞌ jo nnom Tsotyeꞌyoꞌ na mꞌaaⁿ cañoomꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Cweꞌ ncꞌe joꞌ quia macheꞌ naya cwii tsꞌaⁿ, catsaꞌ na ñenncuꞌ ntyjiꞌ, tintseixuaandyuꞌ. Ee mꞌaⁿ nnꞌaⁿ na cweꞌ cwilꞌaya na ya nnꞌaⁿndye. Cwiꞌoona lanꞌom ñequio nꞌom nantaa cꞌuaa ndyueena na cwilꞌana naya ndyeñeeⁿꞌ, cha queⁿ nnꞌaⁿ cwenta ndoꞌ calaꞌtꞌmaaⁿꞌndye nnꞌaⁿ joona. Mayuuꞌcheⁿ nntsjo̱o̱ nndyeꞌyoꞌ, cweꞌ tomti juu cantyja na cwilaꞌtꞌmaaⁿꞌndye nnꞌaⁿ joona, joꞌ na cwitaꞌntjomna. ");
INSERT INTO amuNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Sa̱a̱ ꞌu jeꞌ, quia na macheꞌ naya tsꞌaⁿ, ticaꞌmo̱ⁿꞌ na nljeii cwiicheⁿ tsꞌaⁿ, meiiⁿ tsꞌaⁿ na jeeⁿ ya ñꞌoom ñꞌeⁿndyuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Catsꞌaanaꞌ na ñenncuꞌ ntyjiꞌ naya na macheꞌ. Ndoꞌ nquii Tsotyeꞌ na mantyꞌiaaⁿꞌaⁿ ljoꞌ macheꞌ na cweꞌ ntyꞌiu, jom nntseinoomñê ljoꞌ na matseitjo̱o̱naꞌ ꞌu. ");
INSERT INTO amuNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","’ꞌO quia na cwilaneiⁿꞌyoꞌ nnom Tyꞌo̱o̱tsꞌom, talꞌaꞌyoꞌ chaꞌna joo nnꞌaⁿ na cweꞌ cwilꞌaya na ya nnꞌaⁿndye. Ee joona jeeⁿ ya nquiuna na jndooꞌcheⁿ nnꞌaⁿ cwimeintyjeeꞌna, cwilaꞌneiⁿna nnom Tyꞌo̱o̱tsꞌom naquiiꞌ lanꞌom ndoꞌ jo nqui nantaa. Mayuuꞌcheⁿ nndyeꞌyoꞌ nntsjo̱o̱, cweꞌ tomti juu na cwilaꞌtꞌmaaⁿꞌndye nnꞌaⁿ joona joꞌ na cwitaꞌntjomna. ");
INSERT INTO amuNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Sa̱a̱ ꞌu jeꞌ, quia matseiꞌneiⁿꞌ nnom Tyꞌo̱o̱tsꞌom, cjaꞌquieꞌ naquiiꞌ waꞌ, catseicuꞌ ꞌndyootsꞌaꞌ, ndoꞌ catseineiⁿꞌ nnom Tsotyeꞌ na mꞌaaⁿ na titquiooꞌñe. Ndoꞌ jom na noomꞌm meiiⁿ titquiooꞌñê, nntseinoomñê ljoꞌ na matseitjo̱o̱naꞌ ꞌu. ");
INSERT INTO amuNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","’Quia na cwilaneiⁿꞌyoꞌ nnom Tyꞌo̱o̱tsꞌom, tanduꞌyoꞌ ñꞌoom na ñejuu ñejuunaꞌ, chaꞌxjeⁿ quilꞌa nnꞌaⁿ na ticataꞌjnaaⁿꞌ Tyꞌo̱o̱tsꞌom. Ee joona cwilaꞌtiuuna na jndye ndiiꞌ cwiluena, joꞌ na mañeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ꞌO jeꞌ tilꞌaꞌyoꞌ chaꞌna cwilꞌa joona. Ee Tsotyeꞌyoꞌ ntyjiijndaaꞌñê cwaaⁿ ꞌnaⁿ na macaⁿnaꞌ ꞌo cwii tjo̱o̱cheⁿ na cwitaⁿꞌyoꞌ nnoom. ");
INSERT INTO amuNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Quia na cwilaneiⁿꞌyoꞌ nnom Tyꞌo̱o̱tsꞌom, luaa canduꞌyoꞌ: Tsotya̱a̱yâ na mꞌaaⁿꞌ cañoomꞌluee, ñequiiꞌcheⁿ catseitꞌmaaⁿꞌñenaꞌ xueꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Candyo cantyja na matsa̱ꞌntjomꞌ. Caluii cantyja na lꞌue tsꞌomꞌ nnom tsjoomnancue chaꞌxjeⁿ na macwiluii cañoomꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Quiaaꞌ nantquie ꞌnaⁿꞌ na macaⁿnaꞌ jâ xuee jeꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Catseitꞌmaⁿ tsꞌomꞌ jâ natia na jnda̱ lꞌaayâ chaꞌxjeⁿ jâ cwilatꞌmaⁿ nꞌo̱o̱ⁿyâ nnꞌaⁿ na cwilaꞌtjo̱o̱ndye nda̱a̱yâ. ");
INSERT INTO amuNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Cateijndeiꞌ na ticjaachuunaꞌ jâ na nlꞌaayâ yuu na ticatsa̱ꞌntjomnaꞌ. Ndoꞌ catseicandyaandyuꞌ jâ cantyja ꞌnaaⁿꞌ juu natia. Ee chaꞌwaa na yo na cwii wjaanaꞌ ꞌu cwiluiindyuꞌ na matsa̱ꞌntjomꞌ, ndoꞌ cwiluiindyuꞌ najnduꞌ, ndoꞌ tseixmaⁿꞌ na catseitꞌmaaⁿꞌñenaꞌ ꞌu. Amén. ");
INSERT INTO amuNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","’Xeⁿ ꞌo cwilatꞌmaⁿ nꞌomꞌyoꞌ nnꞌaⁿ na cwilaꞌtjo̱o̱ndye nda̱a̱ꞌyoꞌ, quia joꞌ mati Tsotyeꞌyoꞌ na mꞌaaⁿ cañoomꞌluee, nntseitꞌmaⁿ tsꞌoom ꞌo na cwilaꞌtjo̱o̱ndyoꞌ nnoom. ");
INSERT INTO amuNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Sa̱a̱ xeⁿ ꞌo ticalatꞌmaⁿ nꞌomꞌyoꞌ ncꞌiaaꞌyoꞌ na cwilaꞌtjo̱o̱ndye nda̱a̱ꞌyoꞌ, quia joꞌ mati Tsotyeꞌyoꞌ xocatseitꞌmaⁿ tsꞌoom ꞌo jnaⁿꞌyoꞌ na waa. ");
INSERT INTO amuNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","’Quia na cwilaꞌcwejndoꞌndyoꞌ, tilꞌaꞌyaꞌyoꞌ na taquiomya nda̱a̱ꞌyoꞌ cweꞌ cha na caliu nnꞌaⁿ na ljoꞌ cwilꞌaꞌyoꞌ. Ee mꞌaⁿ nnꞌaⁿ na cweꞌ cwilꞌayana taquiomya nda̱a̱na, cha caꞌmo̱ⁿnaꞌ nda̱a̱ nnꞌaⁿ na cwilaꞌcwejndoꞌndyena. Mayuuꞌcheⁿ nndyeꞌyoꞌ nntsjo̱o̱, cweꞌ tomti juu na cwilaꞌtꞌmaaⁿꞌndye nnꞌaⁿ joona, joꞌ na matseinoomñenaꞌ na cwilaꞌcweꞌjndoꞌndyena. ");
INSERT INTO amuNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Sa̱a̱ ꞌu jeꞌ quia matseiꞌcwejndoꞌndyuꞌ, cwjaaꞌndyuꞌ ncheⁿꞌ xqueⁿꞌ, camaⁿꞌ njomꞌ, ");
INSERT INTO amuNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","cha ticwitquiooꞌ jo nda̱a̱ nnꞌaⁿ na matseiꞌcwejndoꞌndyuꞌ, macanda̱ nquii Tsotyeꞌ na mꞌaaⁿ na titquiooꞌñê nlqueeⁿ cwenta. Ndoꞌ jom na noomꞌm meiiⁿ titquiooꞌñê, nntioꞌnaaⁿñê ꞌu. ");
INSERT INTO amuNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","’Tilatjomꞌyoꞌ ꞌnaⁿ na jndanaꞌ nnom tsjoomnancue yuu mꞌaⁿ cantyꞌua na nlaꞌndaaꞌ joonaꞌ, ndoꞌ yuu na nlquii chꞌmeiⁿ, ndoꞌ yuu na nnda̱a̱ nncꞌooquieꞌ naⁿcantyꞌue na nntjeiiꞌna joonaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Sa̱a̱ joo naya ꞌnaⁿꞌyoꞌ na quitꞌmaⁿ nꞌomꞌyoꞌ calatjomꞌyoꞌ joonaꞌ jo nandye cañoomꞌluee yuu na xocwaꞌ cantyꞌua, meiⁿ na nlquii chꞌmeiⁿ ndoꞌ meiⁿ na nncꞌooquieꞌ naⁿcantyꞌue na nntjeiiꞌ joonaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ee yuu na cwilaꞌweꞌyoꞌ naya na cwilatjomꞌyoꞌ, joꞌ joꞌ ntyjaaꞌ nꞌomꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","’Quia na mandiꞌ ñꞌoom na mayuuꞌ, matseijomnaꞌ ꞌu chaꞌna tsꞌaⁿ na tquiooꞌya na xuee mantyꞌiaaꞌ. Ee quia matseiꞌno̱ⁿꞌ ñꞌoom na mayuuꞌñeeⁿ quia joꞌ mateijndeiinaꞌ chaꞌwaa na mꞌaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Sa̱a̱ xeⁿ tiñeꞌcandiꞌ ñꞌoom na mayuuꞌ, matseijomnaꞌ ꞌu chaꞌna tsꞌaⁿ na tisꞌa nꞌomnnom na mꞌaaⁿ na nchjaaⁿꞌ. Ee meiiⁿ na mandiꞌ ñꞌoomꞌñeeⁿ sa̱a̱ xeⁿ tixocatseiꞌno̱ⁿꞌ na mayuuꞌ juunaꞌ, naquiiꞌ tsꞌomꞌ matseiꞌxmaⁿꞌ chaꞌcwijom na jaaⁿñeñꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","’Tjaaꞌnaⁿ ꞌñeeⁿ juu na nnda̱a̱ nndiꞌntjomtyeⁿ nnom we patrom na ñejom. Ee nncꞌoom tsꞌaⁿ na ticueeꞌ tsꞌoom cwii patromꞌñeeⁿ, ndoꞌ nncꞌoom na wiꞌ tsꞌoom cwiicheⁿ. Oo nntsꞌaanaꞌ na nntseitꞌmaaⁿꞌñê cwii naⁿꞌñeeⁿ, ndoꞌ cwiicheⁿ tilꞌueñe. Xeⁿ na jeeⁿ cwiqueⁿndyoꞌ na nlaꞌtjomꞌyoꞌ ꞌnaⁿ na nleityandyoꞌ xocjuꞌnaaⁿñenaꞌ na nlaꞌtꞌmaaⁿꞌndyoꞌ Tyꞌo̱o̱tsꞌom, ee we ntyja nmeiⁿꞌ xonda̱a̱ nndyeꞌntjomꞌyoꞌ na ñejom. ");
INSERT INTO amuNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","’Cweꞌ ncꞌe joꞌ, nndyeꞌyoꞌ nntsjo̱o̱: Tancꞌomꞌyoꞌ na jeeⁿ jndye mꞌaaⁿꞌ nꞌomꞌyoꞌ na cwitandoꞌyoꞌ tsjoomnancue, ljoꞌ na nlcwaꞌyoꞌ oo na nncweꞌyoꞌ, ndoꞌ liaꞌyoꞌ chiuu nleitsaaⁿꞌndyoꞌ. Ee Tyꞌo̱o̱tsꞌom mantyjeeⁿ cantyjati na cwitandoꞌyoꞌ majndeiiticheⁿ na cweꞌ nantquie na cwicwaꞌyoꞌ. Mantyjeeⁿ hasta chaꞌwaandyoꞌ ꞌo, majndeiiticheⁿ na cweꞌ liaa na cwicweeꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Queⁿꞌyoꞌ cwenta cantyja ꞌnaaⁿ cantsaa na maꞌntyja jo nandye. Jooyoꞌ tjaa ljoꞌ cwinomyoꞌ na nntyjeendyeyoꞌ na nlaꞌweyoꞌ nantquie na nleilꞌue ꞌio cha. Sa̱a̱ meiiⁿ na ljoꞌ, nquii Tsotyeꞌyoꞌ na mꞌaaⁿ cañoomꞌluee mañequiaaⁿ na cwicwaꞌ jooyoꞌ. Ndoꞌ ꞌo cajndandyoꞌtiꞌyoꞌ ntyjeeⁿ, nchiiti cantsaa. ");
INSERT INTO amuNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Mati ¿cwaaⁿ cwiindyoꞌ ꞌo nnda̱a̱ nntsꞌaa na nleitcooñeti cweꞌ na jeeⁿ jndye matseitiuu? ");
INSERT INTO amuNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","’Quia joꞌ ¿chiuu na jeeⁿ jndye mꞌaaⁿꞌ nꞌomꞌyoꞌ cantyja chiuu na nleitsaaⁿꞌndyoꞌ? Queⁿꞌyoꞌ cwenta, nꞌoom ljaaꞌ quiiꞌ jnda̱a̱, ya cwiwijnda̱naꞌ. Neiⁿncooꞌ cwiwaaꞌ ljaaꞌ. Tiquilꞌanaꞌ tsꞌiaaⁿ, meiⁿ tiquilꞌanaꞌ tsaⁿ na nluii liaanaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Sa̱a̱ nndyeꞌyoꞌ nntsjo̱o̱: Juu rey Salomón meiiⁿ jeeⁿ tyañê, ndoꞌ tjacantyja na ya ꞌnaⁿ na tyoleichom, sa̱a̱ tîcatseijomnaꞌ na neiⁿncooꞌ liaⁿꞌaⁿ chaꞌna neiⁿncooꞌ cwii ljaaꞌmeiⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ndoꞌ xeⁿ laaꞌtiꞌ matseichjoomñe Tyꞌo̱o̱tsꞌom ljaaꞌ quiiꞌ jnda̱a̱ na niomnaꞌ xuee jeꞌ ndoꞌ ꞌio cha nlconaꞌ, majndeiiticheⁿ ntyjeeⁿ chiuu nlcweeꞌyoꞌ liaa, ꞌo nnꞌaⁿ na ticalaꞌyuꞌya nꞌomꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Joꞌ chii tancꞌomꞌyoꞌ na jeeⁿ jndye mꞌaaⁿꞌ nꞌomꞌyoꞌ na nnduꞌyoꞌ: “¿Chiuu nlꞌaayo̱o̱ na nlcwaaꞌa ndoꞌ na nncwa̱a̱ya?” oo nnduꞌyoꞌ: “¿Chiuu nlꞌaayo̱o̱ na nleijndaaꞌ liaaya?” ");
INSERT INTO amuNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ee ñenquiiꞌcheⁿ nmeiⁿꞌ cwilꞌueeꞌndye nnꞌaⁿ na ticꞌom nacje ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom. Sa̱a̱ nqueⁿ na cwiluiiñê Tsotyeꞌyoꞌ na mꞌaaⁿ cañoomꞌluee mantyjeeⁿ na tjo̱o̱ndyoꞌ chaꞌtso nmeiⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Sa̱a̱ najndyee quiandyoꞌ na nntsa̱ꞌntjom Tyꞌo̱o̱tsꞌom ꞌo. Ndoꞌ calꞌaꞌyoꞌ yuu na matyꞌiomyanaꞌ chaꞌxjeⁿ na lꞌue tsꞌoom, quia joꞌ nñequiaaⁿ chaꞌtso nmeiⁿꞌ na macaⁿnaꞌ ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Joꞌ chii tincꞌomꞌyoꞌ na jeeⁿ jndye mꞌaaⁿꞌ nꞌomꞌyoꞌ cantyja ꞌnaaⁿꞌ ꞌnaⁿ na nlcaⁿnaꞌ ꞌo xuee na cwii wjaanaꞌ. Ee xuee ꞌio waanquia ñꞌomtiuu cwentaaꞌnaꞌ. Xuee jeꞌ maleiꞌtyeⁿ nawiꞌ na chuunaꞌ cwentaꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","’Tilꞌueeꞌndyoꞌ jnaaⁿ nnꞌaⁿ na cweꞌ xjeⁿto ꞌo cha ticuꞌxeⁿ Tyꞌo̱o̱tsꞌom ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ee mañejuuti ñꞌoom na cwilꞌueꞌyoꞌ nacjoo ncꞌiaaꞌyoꞌ, majuunaꞌ nleilꞌueeꞌñe Tyꞌo̱o̱tsꞌom na nncuꞌxeⁿnaꞌ ꞌo. Ndoꞌ chaꞌxjeⁿ na cwitjeiꞌyoꞌ cwenta na catꞌuiinaꞌ ncꞌiaaꞌyoꞌ, malaaꞌtiꞌ nntsꞌaaⁿ ñꞌeⁿndyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Chiuu na jeeⁿ maqueⁿꞌ cwenta meiiⁿ chjoowiꞌ ljoꞌ machꞌee xꞌiaꞌ? Ndoꞌ manncuꞌtiꞌ tiqueⁿꞌ cwenta na tꞌmaⁿ matseiꞌtjo̱o̱ndyuꞌ. Machꞌeenaꞌ cantyja ꞌnaⁿꞌ chaꞌcwijom jeeⁿ ndoꞌ ntquiooꞌ jnda̱ na njom tsꞌomnnom xꞌiaꞌ, sa̱a̱ meiⁿchjoo tiqueⁿꞌ cwenta tsꞌoom tscaaꞌ na njom tsꞌomnjomꞌ nncuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Aa nntsuꞌyuꞌ nnom xꞌiaꞌ: “Cwa, quiaaꞌ na nncwjiiꞌa ntquiooꞌ jnda̱ na njom tsꞌomnjomꞌ”? Ndoꞌ ꞌu jeꞌ ndicwaⁿ njom tsꞌoom tscaaꞌ tsꞌomnjomꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ꞌU tsꞌaⁿ na we waa na matseixmaⁿꞌ cwjiꞌjndyeeꞌ tsꞌoom tscaaꞌ na njom tsꞌomnjomꞌ nncuꞌ quia joꞌ tquioꞌyaꞌ na nncwjiꞌ ntquiooꞌ jnda̱ na njom tsꞌomnnom xꞌiaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","’Tiñeꞌquiaꞌyoꞌ ꞌnaⁿ na ljuꞌ laꞌxmaⁿnaꞌ nda̱a̱ nnꞌaⁿ na ticalaꞌñꞌoomꞌndye Tyꞌo̱o̱tsꞌom na ticalaꞌxmaⁿ na nntoꞌñoom joonaꞌ. Ee xeⁿ na luaaꞌ nlꞌaꞌyoꞌ matseijomnaꞌ chaꞌcwijom cwiñeꞌquiaꞌyoꞌ ꞌnaⁿ na ya na laꞌxmaⁿnaꞌ cwentaaꞌ Tyꞌo̱o̱tsꞌom nda̱a̱ calueꞌ. Ndoꞌ calueꞌñeeⁿ nntaꞌqueⁿyoꞌ na nntquiiyoꞌ ꞌo. Meiⁿ tiñeꞌquiaꞌyoꞌ ꞌnaⁿ na jnda nda̱a̱ naⁿꞌñeeⁿ, ee xeⁿ na ljoꞌ nlꞌaꞌyoꞌ, matseijomnaꞌ chaꞌcwijom cwitueꞌyoꞌ tsꞌuaa ta̱ꞌ na jeeⁿ jnda nda̱a̱ calcu. Ndoꞌ calcuꞌñeeⁿ cweꞌ nntyueyoꞌ joonaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","’Ñequiiꞌcheⁿ cataⁿꞌyoꞌ nnom Tyꞌo̱o̱tsꞌom quia joꞌ nndaꞌyoꞌ juu na cwitaⁿꞌyoꞌ. Ñequiiꞌcheⁿ calꞌueꞌyoꞌ chiuuya jo nnoom quia joꞌ nliuꞌyoꞌ. Ñequiiꞌcheⁿ caꞌmaⁿꞌyoꞌ jom quia joꞌ nnaaⁿ chaꞌcwijom ꞌndyootsꞌa jo nda̱a̱ꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ee cwii tsꞌaⁿ na waa na macaaⁿ nnom Tyꞌo̱o̱tsꞌom, maxjeⁿ nncoꞌñoom juunaꞌ. Ndoꞌ mati tsꞌaⁿ na malꞌue yuu na lꞌue tsꞌom Tyꞌo̱o̱tsꞌom, maxjeⁿ nljeiiⁿ. Ndoꞌ juu tsꞌaⁿ na maꞌmaⁿ, maxjeⁿ nntseicanaaⁿñe Tyꞌo̱o̱tsꞌom chaꞌcwijom ꞌndyootsꞌa jo nnom. ");
INSERT INTO amuNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","’¿ꞌÑeeⁿ cwiindyoꞌ ꞌo na mꞌaaⁿ yucachjoo jnda, ndoꞌ xeⁿ macaaⁿ tyooꞌ njomꞌ, aa nñequiaaꞌyuꞌ tsjo̱ꞌ nnoom? Tjaaꞌnaⁿ ꞌñeeⁿ nntsꞌaa na ljoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ndoꞌ xeⁿ macaⁿ yucachjoo jndaꞌ cwii catscaa njomꞌ, ¿aa nñequiaaꞌyuꞌ catsuu nnoom? Xocatsaꞌ na ljoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Quia joꞌ ꞌo nnꞌaⁿ na tia nnꞌaⁿndyoꞌ, xeⁿ manquiuꞌyoꞌ na nñeꞌquiaꞌyoꞌ ꞌnaⁿ na ya nda̱a̱ ndaꞌyoꞌ, majndeiiticheⁿ nquii Tsotyeꞌyoꞌ na mꞌaaⁿ cañoomꞌluee nñequiaaⁿ ꞌnaⁿ na yaticheⁿ nda̱a̱ nnꞌaⁿ na cwitaⁿ nnoom. ");
INSERT INTO amuNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","’Quia joꞌ meiⁿnquia na lꞌue nꞌomꞌyoꞌ na calꞌa nnꞌaⁿ ñꞌeⁿndyoꞌ majoꞌti calꞌaꞌ ꞌo ñꞌeⁿndye joona. Ee laaꞌtiꞌ matsa̱ꞌntjom ljeii na tqueⁿ Moisés ñequio ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na tyoñeꞌquia profetas tandyo xuee. ");
INSERT INTO amuNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","’ꞌO catsaquieꞌyoꞌ ꞌndyootsꞌa cantuu na nncꞌomꞌyoꞌ natooꞌ Tyꞌo̱o̱tsꞌom. Ee waa ꞌndyootsꞌa tmeiⁿ na matseicanaaⁿñenaꞌ nato tꞌmaⁿ. Juunaꞌ wjaañꞌoomnaꞌ tsꞌaⁿ na nntsuuñe ndoꞌ jndye nnꞌaⁿ cwiꞌooquieꞌ joꞌ joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Sa̱a̱ ꞌndyootsꞌa cantuu matseicanaaⁿñenaꞌ nato cajneiⁿ. Natoꞌñeeⁿ wjaañꞌoomnaꞌ tsꞌaⁿ na ticantycwii na nncwandoꞌ sa̱a̱ tijndye nnꞌaⁿ cwiliu juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","’Calꞌaꞌyoꞌ cwenta ñequio joo nnꞌaⁿ na tiyuuꞌ ñꞌoom cwiñeꞌquia. Cwiquieꞌcañomna ꞌo na ndooꞌ jeeⁿ nioomꞌ nꞌomna chaꞌna nioomꞌ tsꞌom catsmaⁿ sa̱a̱ naquiiꞌ nꞌomna laxmaⁿna na wiꞌndyena chaꞌcwijom lobo. ");
INSERT INTO amuNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nntaꞌjnaⁿꞌyoꞌ ꞌñeeⁿ joona quia cwiqueⁿꞌyoꞌ cwenta chiuu cwilꞌana. ¿Aa nntsꞌaacheⁿnaꞌ na nntseicjoo tsꞌaⁿ ta̱uva lꞌo̱o̱nioom? Oo ¿aa nntseicjoo tsꞌaⁿ ta̱higos tsꞌoom nioom? Xocatsꞌaanaꞌ na ljoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ee ticwii cwii tsꞌoom na ya, cwiweꞌ ta̱ na ya, ndoꞌ ticwii cwii tsꞌoom na tisꞌa, cwiweꞌ ta̱ na tisꞌa. ");
INSERT INTO amuNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tsꞌoom na ya xocueꞌ ta̱ na tisꞌa, ndoꞌ tsꞌoom na tisꞌa xocueꞌ ta̱ na ya. ");
INSERT INTO amuNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ticwii cwii tsꞌoom na ticatsꞌaa ta̱ na ya, cwitꞌuanaꞌ, jnda̱ chii cwitueeꞌ nnꞌaⁿ juunaꞌ quiiꞌ chom. ");
INSERT INTO amuNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Luaaꞌ waa na nntaꞌjnaⁿꞌyoꞌ naⁿꞌñeeⁿ, ee mꞌmo̱ⁿnaꞌ na tiyuuꞌ ñꞌoom na cwiñeꞌquiana quia na nleitquiooꞌ chiuu waa na cwilꞌana. ");
INSERT INTO amuNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","’Majndye nnꞌaⁿ cwilue nno̱o̱ⁿ Ta, sa̱a̱ tichaꞌtsondyena nncꞌooquieeꞌndyena cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. Ñequiiꞌcheⁿ joo nnꞌaⁿ na cwilꞌa ljoꞌ na lꞌue tsꞌom Tsotya̱ya na mꞌaaⁿ cañoomꞌluee, naⁿꞌñeeⁿ nncꞌooquieeꞌndye cantyja na matsa̱ꞌntjoom. ");
INSERT INTO amuNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Xuee na nncueꞌntyjo̱ na nntuꞌxeⁿndye nnꞌaⁿ, majndye nnꞌaⁿ nluena no̱o̱ⁿ: “Jeeⁿ ꞌu Ta, ¿aa nchii jnda̱ tquiaayâ ñꞌoom naya ꞌnaⁿꞌ ñequio najndeii na matseiꞌxmaⁿꞌ ndoꞌ tjeiiꞌâ jndyetia naquiiꞌ nꞌom nnꞌaⁿ, ndoꞌ lꞌaayâ jndye ꞌnaaⁿ ñequio najnduꞌ nncuꞌ na tixocaluiinaꞌ cantyja najndeii na matseixmaⁿ tsꞌaⁿ?” ");
INSERT INTO amuNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Quia joꞌ nncꞌo̱ya ndyuee naⁿꞌñeeⁿ, nntsjo̱o̱: “Meiⁿchjoo ticwajnaⁿꞌa ꞌñeeⁿ ꞌo. Quindyo̱ꞌyoꞌ nacañomya, ꞌo nnꞌaⁿ na tia nnꞌaⁿndyoꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","’Ticwii cwii tsꞌaⁿ na mandii ñꞌoom na matsjo̱o̱ nmeiiⁿ ndoꞌ matseicanda̱ joonaꞌ, matseijomnaꞌ tsaⁿꞌñeeⁿ chaꞌna cwii tsꞌaⁿ na jndo̱ꞌ tsꞌom na sꞌaa waaꞌ nacjooꞌ tsjo̱ꞌtꞌmaⁿ na tyeⁿ wacatyeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Jnaⁿnaꞌ tuaꞌ, tyjeeꞌ jndaa, tioo jndye jndeii, teicaljoonaꞌ wꞌaaꞌñeeⁿ, sa̱a̱ tiquioonaꞌ ee na tꞌuiityeⁿnaꞌ nacjooꞌ tsjo̱ꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Sa̱a̱ ticwii cwii tsꞌaⁿ na mandii ñꞌoom na matsjo̱o̱ ndoꞌ titseicanda̱ joonaꞌ, matseijomnaꞌ tsaⁿꞌñeeⁿ chaꞌna cwii tsꞌaⁿ na tijndo̱ꞌ tsꞌom na sꞌaa waaꞌ nacjooꞌ teiꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Jnaⁿnaꞌ tuaꞌ, tyjeeꞌ jndaa, tioo jndye jndeii, teicaljoonaꞌ wꞌaaꞌñeeⁿ, mana tioonaꞌ. Ndoꞌ matꞌmaⁿ tsuu cantyja ꞌnaaⁿꞌ wꞌaaꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Quia na jnda̱ jnda̱ seineiⁿ Jesús chaꞌtso ñꞌoommeiⁿꞌ, nnꞌaⁿ na jndyendye jeeⁿ tjaweeꞌ nꞌomna ñꞌoom na tꞌmo̱o̱ⁿ nda̱a̱na. ");
INSERT INTO amuNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Ee tyoꞌmo̱o̱ⁿ na waa najndeii na matseixmaaⁿ, nchii chaꞌna cwitꞌmo̱o̱ⁿ nnꞌaⁿ na jndo̱ꞌ nꞌom cantyja ꞌnaaⁿꞌ ljeii na tqueⁿ Moisés. ");
INSERT INTO amuNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Quia na jndyocue Jesús ta na tjaaⁿ, jndyendye nnꞌaⁿ tquiontyjo̱ naxeeⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tyjeeꞌcañoom cwii tsꞌaⁿ na chuu tycu lepra, tjatseicandyooꞌñe, tcoꞌ xtye jo nnoom, tso: —Ta, ntyjii na ꞌu nnda̱a̱ nntseinꞌmaⁿꞌ ja, xeⁿ lꞌue tsꞌomꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ndoꞌ Jesús seintyjo̱o̱ⁿ tsꞌo̱o̱ⁿ, tyenquioomꞌm tsaⁿꞌñeeⁿ, matsoom nnom: —Lꞌue tsꞌo̱o̱ⁿ. Canꞌmaⁿꞌ. Ndoꞌ mañoomꞌ nꞌmaⁿ tsaⁿꞌñeeⁿ, mana tsu tycu lepra. ");
INSERT INTO amuNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Quia joꞌ tso Jesús nnoom: —Ndiꞌ nntsjo̱o̱, meiⁿcwii tsꞌaⁿ ticatsuꞌ nnom chiuu waa na tuii. Sa̱a̱ cjaꞌ, cjaꞌtseicaꞌmo̱ⁿndyuꞌ nnom tyee, ndoꞌ quiaaꞌ quiooꞌ nnoom na tseixmaⁿ cwentaaꞌ Tyꞌo̱o̱tsꞌom chaꞌxjeⁿ na sa̱ꞌntjom Moisés. Luaaꞌ catsaꞌ cha caluiꞌyuuꞌnaꞌ nda̱a̱ nnꞌaⁿ na jnda̱ nꞌmaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Xjeⁿ na mawjaaquieeꞌ Jesús tsjoom Capernaum, cwii capeitaⁿ na matsa̱ꞌntjom cwii siaⁿnto sondaro seicandyooꞌñe nacañomꞌm. Sꞌaa tyꞌoo nnoom. ");
INSERT INTO amuNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Tso: —ꞌU Ta, moso ꞌnaⁿya macanda̱ cweꞌ waaⁿ na waa wꞌaya, teiꞌcaljoo tycutqueeⁿ jom. Jeeⁿ cwajndii maquiinaꞌ jom. ");
INSERT INTO amuNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Tso Jesús nnom: —Nncjo̱, nntseinꞌmaⁿya jom. ");
INSERT INTO amuNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Sa̱a̱ tꞌo̱ capeitaⁿ, tsoom: —ꞌU Ta, ticatseixmaⁿya na nncjaꞌquieꞌ naquiiꞌ wꞌaya. Mantyjii meiiⁿ cweꞌ ñꞌoom catsuꞌ, mana nnꞌmaⁿ moso ꞌnaⁿya. ");
INSERT INTO amuNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ee mati ja mꞌaaⁿya nacje ꞌnaaⁿ nnꞌaⁿ na cwitsa̱ꞌntjom. Ndoꞌ mati nnco̱ mꞌaⁿ sondaro na matsa̱ꞌntjo̱ⁿ. Quitsjo̱o̱ nnom cwii joona: “Cjaꞌ luaaꞌ”, ndoꞌ wjaa. Quitsjo̱o̱ nnom cwiicheⁿ: “Candyoꞌ luaa”, ndoꞌ ndyo. Quitsjo̱o̱ nnom cwii cwii moso ꞌnaⁿya: “Catsaꞌ tsꞌiaaⁿwaaꞌ”, ndoꞌ ntsꞌaa. ");
INSERT INTO amuNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jeeⁿ tjaweeꞌ tsꞌom Jesús quia na jñeeⁿ ñꞌoom ꞌndyoo tsaⁿꞌñeeⁿ. Tsoom nda̱a̱ nnꞌaⁿ na cwiꞌoontyjo̱ naxeeⁿꞌeⁿ: —Mayuuꞌcheⁿ nndyeꞌyoꞌ nntsjo̱o̱, meiⁿ quiiꞌntaaⁿ nnꞌaⁿ Israel tyooljei cwii tsꞌaⁿ na matseiyuꞌya tsꞌom chaꞌna tsaⁿmꞌaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Candyeꞌyoꞌ nntsjo̱o̱, jndye nnꞌaⁿ na nchii nnꞌaⁿ Israel nnaⁿ naⁿꞌñeeⁿ jo ntyja na macaluiꞌ ñeꞌquioomꞌ ñequio ntyja na mawjaacue ñeꞌquioomꞌ. Ndoꞌ yuu na mꞌaⁿ Abraham ñꞌeⁿ Isaac ñꞌeⁿ Jacob yuu na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom, ñequio na neiiⁿna nncwindyuaandyena na nlcwaꞌna ñꞌeⁿ naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Sa̱a̱ nquiee nnꞌaⁿ judíos na qui na cwentaana cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom, nncwjiꞌnaꞌ joona joꞌ joꞌ. Nncjuꞌnaꞌ joona yuu na tjacantyja na jaaⁿñe. Joꞌ joꞌ nncꞌomna na nlaꞌxuaana na matseiꞌndaaꞌnaꞌ nꞌomna. Ndoꞌ nnteinquiena ndeiꞌnꞌomna na maquiinaꞌ joona. ");
INSERT INTO amuNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Quia joꞌ tso Jesús nnom capeitaⁿꞌñeeⁿ: —Chaꞌxjeⁿ na jnda̱ seiyuꞌ, maxjeⁿ joꞌ nluii. Cjaꞌlcweꞌ na waa waꞌ. Ndoꞌ mañejuu xjeⁿꞌñeeⁿ nꞌmaⁿ mosooꞌ tsaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Tjaquieeꞌ Jesús waaꞌ Pedro. Ljeiiⁿ na waa sta̱xeeⁿꞌ tsaⁿꞌñeeⁿ cjooꞌ jnduu. Matseiconaꞌ juu. ");
INSERT INTO amuNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Tyenquioomꞌm tsꞌo̱ tsaⁿꞌñeeⁿ ndoꞌ mañoomꞌ tjameintyjeeꞌ na matseiconaꞌ juu. Teicantyja, to̱ꞌ na mandiꞌntjom nda̱a̱na. ");
INSERT INTO amuNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Quia na jnda̱ tmaaⁿya, tquiocho nnꞌaⁿ jndye ncꞌiaana na cwileiꞌcho jndyetia na mꞌaaⁿ Jesús. Ñeꞌcwii sa̱ꞌntjoom na caluiꞌ jndyetia, quia joꞌ jluiꞌna naquiiꞌ nꞌom naⁿꞌñeeⁿ. Ndoꞌ seinꞌmaaⁿ chaꞌtso nnꞌaⁿwii. ");
INSERT INTO amuNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Luaaꞌ tuii cha caluiꞌljuuꞌ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na tyoñequiaa profeta Isaías. Tso tsaⁿꞌñeeⁿ: “Manquiityeeⁿ teijneiⁿ jaa cantyja na tijndeiiꞌ nꞌo̱o̱ⁿya. Ndoꞌ mati seinꞌmaaⁿ jaa chaꞌtso ntycu na ñejleichuunaꞌ jaa.” ");
INSERT INTO amuNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Quia na ntyꞌiaaꞌ Jesús na jndyendye nnꞌaⁿ mꞌaⁿ nacañomꞌm, tsoom nda̱a̱ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê na calaꞌjndaaꞌndyena wꞌaandaa na nncꞌoona xndyaaꞌ ndaaluee. ");
INSERT INTO amuNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ndoꞌ tjantyjaaꞌ cwii tsꞌaⁿ na maꞌmo̱ⁿ ljeii na tqueⁿ Moisés. Matso nnoom: —Maestro, nncjo̱ntyjo̱ naxeⁿꞌ meiⁿyuucheⁿ na wjaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Tꞌo̱ Jesús nnom, tsoom: —Joo canndye maniom lueꞌwꞌaayoꞌ ndoꞌ cantsaa na cwimaꞌntyja mati maniom cantquiaayoꞌ, sa̱a̱ ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee meiⁿ yuu na nncwajndya̱, tjaaꞌnaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Cwiicheⁿ tsꞌaⁿ na matseijomñe ñꞌeⁿñê, matso nnoom: —Ta, quiaaꞌ ñꞌomꞌ na nndiꞌntjo̱ⁿtya̱ nnom tsotya̱, hasta xeⁿ jnda̱ tyꞌiuya jom, quia joꞌ yuuꞌ jeꞌ nñꞌa̱ⁿya ñꞌeⁿndyuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Tꞌo̱ Jesús nnom, matsoom: —Jndye nnꞌaⁿ mꞌaⁿ na tyootandoꞌ cantyja ꞌnaⁿya. Mꞌaⁿna chaꞌcwijom lꞌoo. Caꞌndiiꞌ na joona catyꞌiuundye ntyjeena. Sa̱a̱ ꞌu jeꞌ, candyoꞌtseijomndyuꞌ ñꞌeⁿndyo̱. ");
INSERT INTO amuNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Quia joꞌ tuo̱o̱ⁿ tsꞌom wꞌaandaa, mandi ñꞌeeⁿ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Luaa tuii, tyoowijndye ꞌoona, tioo cwii jndye tꞌmaⁿ jndeii nnom ndaaluee, mawaa na wjaanchjeeñe nmo̱ⁿ wꞌaandaa. Ndoꞌ jom watsom. ");
INSERT INTO amuNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ndoꞌ tyꞌentyjaaꞌ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê jlaꞌnlcwina jom, jluena: —Jeeⁿ ꞌu Ta, cwjiꞌnꞌmaaⁿndyuꞌ jaa, manncwja̱a̱ya. ");
INSERT INTO amuNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Quia joꞌ tsoom nda̱a̱na: —ꞌO nnꞌaⁿ na ticalaꞌyuꞌya nꞌomꞌyoꞌ ñꞌeⁿ Tyꞌo̱o̱tsꞌom, ¿chiuu na cwilacatyuendyoꞌ? Ndoꞌ teicantyjaaⁿ, seitiaaⁿꞌaⁿ jndyeꞌñeeⁿ ñequio ndaaluee, mana teicheⁿñꞌeⁿnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Cweꞌ seiñꞌeeⁿꞌtonaꞌ naⁿꞌñeeⁿ, jluena: —¿ꞌÑeeⁿ cwiluiiñe tsaⁿmꞌaaⁿꞌ na jeeⁿcheⁿ ndyaꞌ waljooꞌ? Jndaꞌjom meiiⁿ jndye, meiiⁿ ndaaluee cwilaꞌcanda̱naꞌ ñꞌoom na matsa̱ꞌntjoom. ");
INSERT INTO amuNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jnda̱ joꞌ jluiꞌna cwiicheⁿ xndyaaꞌ ndaaluee, ndyuaa nnꞌaⁿ gadarenos, we nnꞌaⁿ na laꞌxmaⁿ naⁿjndii tyꞌecatjomndye jom. Jluiꞌna yuu niom ndeiꞌluaa, jeeⁿcheⁿ ndyaꞌ wjeena hasta leicanda̱a̱ nncwinom tsꞌaⁿ natoꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Luaa tuii, jndeii jlaꞌxuaana, jluena: —¿Ljoꞌ nntsaꞌ ñꞌeⁿndyô̱, ꞌu Jesús, Jnda Tyꞌo̱o̱tsꞌom? ¿Aa jnda̱ jndyoꞌ na nlcoꞌwiꞌ jâ, meiiⁿ tyooweꞌntyjo̱ xjeⁿ na nntuꞌxeⁿndyô̱? ");
INSERT INTO amuNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Joꞌ joꞌ chjooti matquio̱o̱ꞌti mꞌaⁿ cwii tmaaⁿꞌ tꞌmaⁿ calcu na cwicwaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ndoꞌ naⁿjndiiꞌñeeⁿ jlaꞌtyꞌoondyena nnoom jluena: —Xeⁿ na nncwjiꞌ jâ naquiiꞌ nꞌom naⁿmꞌaⁿ, quiaaꞌ ñꞌomꞌ na nntsaquia̱a̱ꞌâ naquiiꞌ nꞌom calcu na mꞌaⁿ luaaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Quia joꞌ tsoom nda̱a̱na: —Cwa, catsaꞌyoꞌ. Mana jluiꞌna, tyꞌequieꞌnomna naquiiꞌ nꞌom calcuꞌñeeⁿ. Ndoꞌ chaꞌwaa tmaaⁿꞌ calcuꞌñeeⁿ tmaⁿꞌnquioyoꞌ, mana teiꞌtyuꞌyoꞌ ꞌndyoo ndaaluee. Tja̱yoꞌ quiiꞌ ndaa. ");
INSERT INTO amuNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ndoꞌ nnꞌaⁿ na cwijndooꞌ jooyoꞌ, jleiꞌnomna, tyꞌequieꞌna quiiꞌ tsjoom. Tcuu tcuu tyolaꞌcandiina chiuu waa na tjoomna ñꞌeⁿ calcuꞌñeeⁿ ñequio chiuu waa na nꞌmaaⁿ we naⁿꞌñeeⁿ na tyoleiꞌcho naⁿjndii. ");
INSERT INTO amuNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Quia joꞌ chaꞌtso nnꞌaⁿ tsjoomꞌñeeⁿ jluiꞌna, tyꞌena na mꞌaaⁿ Jesús. Ndoꞌ quia na tjomndyena jom, lꞌana tyꞌoo nnoom na calueeⁿꞌeⁿ ndyuaana. ");
INSERT INTO amuNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Quia joꞌ tuo̱nndaꞌ Jesús tsꞌom wꞌaandaa ñequio nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê. Teiꞌtyꞌiooꞌna ndaaluee. Mana tquiena tsjoom yuu na macꞌeⁿ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Ndoꞌ tquioñꞌom nnꞌaⁿ cwii tsꞌaⁿwiiꞌ na mꞌaaⁿ, cweꞌ ñꞌeⁿ tsuee. Tsaⁿꞌñeeⁿ tycutqueeⁿ teiꞌljoo jom mana teintjeiⁿ ncꞌeeⁿ. Quia na ntyꞌiaaꞌ Jesús na tꞌmaⁿ cwilaꞌyuꞌya nꞌom naⁿꞌñeeⁿ, tsoom nnom tsaⁿwiiꞌ: —ꞌU jndaaya, cꞌomꞌ tꞌmaaⁿꞌndyuꞌ tsꞌomꞌ. Ja jnda̱ seitꞌmaⁿ tsꞌo̱o̱ⁿya ꞌu chaꞌtso jnaⁿꞌ na waa. ");
INSERT INTO amuNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Quia joꞌ cwanti nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés tyomꞌaaⁿꞌ nꞌomna, cwiluena: “Tsaⁿmꞌaaⁿꞌ ñꞌoom ntjeiⁿ matseineiiⁿ ee machꞌeeⁿ na ljoꞌyu cwiluiiñê ñꞌeⁿ Tyꞌo̱o̱tsꞌom.” ");
INSERT INTO amuNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Jesús maxjeⁿ mantyjeeⁿ na luaaꞌ cwilaꞌtiuuna. Joꞌ chii tsoom nda̱a̱na: —¿Chiuu na ticuaaya nquiuꞌyoꞌ ñꞌeⁿndyo̱? ");
INSERT INTO amuNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Cwaaⁿ ñꞌoom cwilaꞌtiuuꞌyoꞌ na tijndeiꞌtinaꞌ na nntsjo̱o̱ nnom tsaⁿmꞌaaⁿ, aa nchii chaꞌna jnda̱ tsjo̱o̱ nnoom na matseitꞌmaⁿ tsꞌo̱o̱ⁿya jnaaⁿꞌaⁿ na waa? Oo ¿aa nchii nquiuꞌyoꞌ na jndeiꞌtinaꞌ na nntsjo̱o̱ quicantyjaaⁿ, cjaacaⁿ? ");
INSERT INTO amuNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Queⁿꞌyoꞌ cwenta, ja na cwiluiindyo̱ tsaⁿ na jnaⁿ cañoomꞌluee mꞌmo̱o̱ⁿya nda̱a̱ꞌyoꞌ na waa na jndo̱ na matseixmaⁿya tsjoomnancuewaañe na nntseitꞌmaⁿ tsꞌo̱o̱ⁿya jnaaⁿ nnꞌaⁿ. Quia joꞌ tsoom nnom tsꞌaⁿ na ntjeiⁿ ncꞌee: —ꞌU re, quicantyjaꞌ, catseilcwiindyuꞌ tsuee ꞌnaⁿꞌ. Cjaꞌtoꞌ waꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ndoꞌ teicantyjaaⁿ, mana tjaaⁿ waⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ndoꞌ tmaaⁿꞌ nnꞌaⁿ na ntyꞌiaa na luaaꞌ, tyueneiiⁿna ndoꞌ tyolaꞌtꞌmaaⁿꞌndyena Tyꞌo̱o̱tsꞌom na tquiaaⁿ najneiⁿ nnom Jesús na nnteijndeiinaꞌ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jluiꞌ Jesús joꞌ joꞌ, mana tjaaⁿ. Ndoꞌ ljeiiⁿ ja na jndyuya Mateo. Wacatya̱ⁿ wꞌaa yuu cwitioom nnꞌaⁿ tsꞌiaaⁿnda̱a̱na cwentaaꞌ gobiernom. Tsoom no̱o̱ⁿ: —Candyoꞌtseijomndyuꞌ ñequio tsꞌiaaⁿ na matsꞌaa. Mañoomꞌ teicantyjaya, tjo̱tseijomndyo̱ ñequioñê. ");
INSERT INTO amuNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Luaa tuii, wacatyeeⁿ Jesús nacañoomꞌ meiⁿsa wꞌaya. Ndoꞌ naⁿcwitoꞌñoom tsꞌiaaⁿnda̱a̱ nnꞌaⁿ cwentaaꞌ gobiernom ñꞌeⁿ nnꞌaⁿ na cwilaꞌtjo̱o̱ndye nnom Tyꞌo̱o̱tsꞌom cantyja na nquiu nnꞌaⁿ fariseos, ñeꞌnaaⁿꞌ meindyuaandyena ñꞌeⁿñê ñequio nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Sa̱a̱ quia na ntyꞌiaa nnꞌaⁿ fariseos na luaaꞌ machꞌeeⁿ, taꞌxꞌeena nda̱a̱ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê, jluena: —¿Chiuu na macwaꞌ maestro ꞌnaⁿꞌyoꞌ ñequio naⁿcwitoꞌñoom tsꞌiaaⁿnda̱a̱ nnꞌaⁿ cwentaaꞌ gobiernom ndoꞌ ñequio nnꞌaⁿ na cwilaꞌtjo̱o̱ndye nnom Tyꞌo̱o̱tsꞌom? ");
INSERT INTO amuNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Quia na jndii Jesús na luaaꞌ cwiluena, tsoom: —Nnꞌaⁿ na tiwii titjo̱o̱ndyena tsꞌaⁿ na machꞌee nasei. Sa̱a̱ nnꞌaⁿ na wii tjo̱o̱ndyena tsaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Waa ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na luaa matsonaꞌ: “Ja cajndati ntyjii na nncꞌomꞌyoꞌ na wiꞌ nꞌomꞌyoꞌ ncꞌiaaꞌyoꞌ nchiiti na cwiñeꞌquiaꞌyoꞌ quiooꞌ na cwilaꞌtꞌmaaⁿꞌndyoꞌ ja.” Tsoti Jesús: —Catsaꞌyoꞌ ndoꞌ calaꞌno̱ⁿꞌyoꞌ ljoꞌ ñeꞌcaꞌmo̱ⁿ ñꞌoomwaaꞌ. Ee ja nchii na jndyo̱o̱ na nncwaⁿya nnꞌaⁿ na cwilꞌa na matyꞌiomyanaꞌ, sa̱a̱ jndyo̱o̱ na nncwaⁿya nnꞌaⁿjnaⁿ na calcweꞌ nꞌomna. ");
INSERT INTO amuNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Quia joꞌ nnꞌaⁿ na cwilaꞌjomndye ñꞌoom na mañequiaa Juan, tyquieꞌcañomna Jesús. Tyolaꞌncjooꞌndyena, jluena: —¿Chiuu na jâ ñequio nnꞌaⁿ fariseos jndye ndiiꞌ cwilaꞌcwejndoꞌndyô̱, sa̱a̱ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿndyuꞌ tiquilaꞌcwejndoꞌndyena? ");
INSERT INTO amuNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Tꞌo̱ Jesús nda̱a̱ naⁿꞌñeeⁿ, seineiiⁿ ñꞌoom tjañoomꞌ: —Joo nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿ nquii tsꞌaⁿ na macoco, ¿aa nncꞌomna na chjooꞌ nꞌomna yocheⁿ na cwiwitꞌmaaⁿꞌ na ndicwaⁿ mꞌaaⁿ tsaⁿꞌñeeⁿ quiiꞌntaaⁿna? Xocatsꞌaanaꞌ. Sa̱a̱ nncueꞌntyjo̱ xuee na nncwjiꞌnaꞌ juu tsꞌaⁿ na macoco quiiꞌntaaⁿna. Quia ljoꞌcheⁿ nncꞌomna na chjooꞌ nꞌomna ndoꞌ nlaꞌcwejndoꞌndyena. ");
INSERT INTO amuNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Quia joꞌ seineiⁿti Jesús ñꞌoom tjañoomꞌ cantyja ꞌnaaⁿꞌ ñꞌoom xco na jndyoñꞌoom. Tsoom: —Ticatyꞌiomyanaꞌ na nntseiyo̱ tsꞌaⁿ liaa ntsaa ñꞌeⁿ cwii taⁿꞌ liaa xco na tyootmaⁿ. Ee xeⁿ na ljoꞌ nntsꞌaa, nncjaateii liaa xco, nncꞌiooꞌñenaꞌ liaa ntsaa ndoꞌ liaa ntsaa cwajndiiti njndiiꞌñenaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Meiⁿ xocatiom tsꞌaⁿ winom xco tsꞌom tjaⁿ na jnda̱ teilꞌue, ee xeⁿ na luaaꞌ ntsꞌaa tsꞌaⁿ, ntyꞌiooꞌ tjaⁿ, mana cwiwindaaꞌñꞌeⁿ juunaꞌ ndoꞌ mati nlcweꞌ winom. Maxjeⁿ nntiom tsꞌaⁿ winom tsꞌom tjaⁿ xco ndoꞌ laaꞌtiꞌ meiⁿ tjaⁿ xocwiꞌndaaꞌ meiⁿ winom. ");
INSERT INTO amuNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yocheⁿ na matseineiⁿ Jesús ñꞌoommeiⁿꞌ, tyjeꞌcañoom cwii tsꞌaⁿ na cwiluiitquieñe watsꞌom ꞌnaaⁿ nnꞌaⁿ judíos. Tcoꞌ xtye jo nnoom, tso: —Jeꞌndyo tueꞌ nomjndaaya. Sa̱a̱ xeⁿ wjaꞌ na nntioꞌ tsꞌo̱ꞌ nacjoomꞌm, nncwandoꞌnnaaⁿꞌaⁿ. Cwa cjaꞌ, catioꞌyaꞌ tsꞌo̱ꞌ nacjoomꞌm, quia joꞌ nncwandoꞌxcoom. ");
INSERT INTO amuNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ndoꞌ teicantyja Jesús, tjantyjo̱o̱ⁿ naxeⁿꞌ tsaⁿꞌñeeⁿ ñequio jâ nnꞌaⁿ na cwilajomndyô̱ ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Luaa tuii, jndyontyjo̱ cwii yuscu naxeⁿꞌ Jesús na nioom wiiꞌ. Yuscuꞌñeeⁿ jnda̱ canchooꞌwe chu na tyoocameintyjeeꞌ na cwicaa nioomꞌm. Jndyotseicandyooꞌñê, tꞌueeⁿ ꞌndyoo liaaꞌ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ee seitioom naquiiꞌ tsꞌoom: “Xeⁿ cweꞌ na nnda̱a̱ nñequiuuꞌa liaⁿꞌaⁿ, quia joꞌ nnꞌmaⁿya.” ");
INSERT INTO amuNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Taqueⁿ Jesús ntyꞌiaaⁿꞌaⁿ yuscuꞌñeeⁿ. Tsoom nnom: —ꞌU jndaaya, cꞌomꞌ tꞌmaaⁿꞌndyuꞌ tsꞌomꞌ. Ncꞌe na matseiyuꞌya tsꞌomꞌ ñꞌeⁿndyo̱, jnda̱ nꞌmaⁿꞌ. Ndoꞌ mañejuu xjeⁿꞌñeeⁿ nꞌmaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Jnda̱ tueeꞌ Jesús waaꞌ Jairoꞌñeeⁿ, tjaqueⁿꞌeⁿ naquiiꞌ wꞌaa. Ntyꞌiaaⁿꞌaⁿ nnꞌaⁿ na cwitjo̱o̱ꞌ nmaaⁿ, ñequio jndye ntꞌomcheⁿ nnꞌaⁿ na tacwaxua ndyuee. ");
INSERT INTO amuNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Tsoom nda̱a̱ naⁿꞌñeeⁿ: —Caluiꞌyoꞌ, ee nchii na jnda̱ tueꞌ yuscuchjoomꞌaaⁿꞌ. Cweꞌ watsoo. Sa̱a̱ cweꞌ teincona jom. ");
INSERT INTO amuNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jnda̱ na tjeiiⁿꞌeⁿ naⁿꞌñeeⁿ chꞌeⁿ, tjaqueⁿꞌeⁿ yuu ndiiꞌ tsꞌoochjoo, tꞌueeⁿ tsꞌo̱. Teintyja yuꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Chaꞌwaa tsꞌo̱ndaaꞌñeeⁿ tꞌom ñꞌoom na tuii na luaaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Na mawjaati Jesús tyꞌentyjo̱ we naⁿnchjaaⁿ naxeeⁿꞌeⁿ. Jndeii tyolaꞌxuaana, tyoluena: —Ta, ꞌu na cwiluiindyuꞌ tsjaaⁿ ꞌnaaⁿꞌ David na jndyowicantyjooꞌ, cꞌoomꞌ na wiꞌ tsꞌomꞌ jâ. ");
INSERT INTO amuNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Quia na tjaqueⁿꞌeⁿ quiiꞌ wꞌaa, tyꞌentyjo̱ naⁿnchjaaⁿꞌñeeⁿ naxeeⁿꞌeⁿ. Tsoom nda̱a̱na: —¿Aa cwilayuꞌyoꞌ na nnda̱a̱ nntsꞌaaya na nntyꞌiaꞌyoꞌ? Tꞌo̱o̱na nnoom jluena: —Ta, cwilayuuꞌâ na nnda̱a̱ nntsaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Quia joꞌ tyenquioomꞌm luaꞌnda̱a̱na, tsoom: —Catsꞌaanaꞌ chaꞌxjeⁿ na cwilayuꞌya nꞌomꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Mana tcoꞌyanaꞌ nꞌomnda̱a̱ naⁿꞌñeeⁿ. Ndoꞌ tqueⁿtyeⁿ Jesús ñꞌoom nda̱a̱na, tsoom: —Calꞌaꞌyoꞌ cwenta na meiⁿcwii tsꞌaⁿ ticalaneiⁿꞌyoꞌ nnom ꞌñeeⁿ seinꞌmaⁿ ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Sa̱a̱ yuu waa, jluiꞌ naⁿꞌñeeⁿ joꞌ joꞌ, to̱ꞌna, tyotꞌoomna ñꞌoom ya cantyja ꞌnaaⁿꞌaⁿ chaꞌwaa tsꞌo̱ndaaꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Xjeⁿ na cwiꞌoo naⁿꞌñeeⁿ, luaa tuii, tquioñꞌom nnꞌaⁿ cwii tsꞌaⁿ na mꞌaaⁿ Jesús. Tileicatseineiⁿ na maleiñꞌoom jndyetia juu. ");
INSERT INTO amuNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Quia na jnda̱ tjeiiⁿꞌeⁿ jndyetia naquiiꞌ tsꞌom tsaⁿꞌñeeⁿ, jnaaⁿ na matseineiⁿ. Tyueneiiⁿ nnꞌaⁿ, jluena: —Meiⁿ chaꞌwaa ndyuaaya ndyuaa Israel, tijoom ñentyꞌiaaya cwii nnom chaꞌna luaaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Sa̱a̱ nnꞌaⁿ fariseos tueeꞌna ñꞌoom nacjooꞌ Jesús, jluena: —Cantyja najndeii nquii na cwiluiitquieñe nda̱a̱ naⁿjndii, joꞌ na macwjeeⁿꞌeⁿ naⁿjndii naquiiꞌ nꞌom nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Tyomanom Jesús chaꞌtso njoom tꞌmaⁿ ñequio njoom nchꞌu tsꞌo̱ndaa Galilea. Tyoꞌmo̱o̱ⁿ nda̱a̱ nnꞌaⁿ naquiiꞌ lanꞌom. Tyoñequiaaⁿ ñꞌoom naya cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. Tyotseinꞌmaaⁿ nnꞌaⁿ ticwii cwii nnom tycu na wiina, ñꞌeⁿ ticwii cwii nnom na tajndeiiꞌ nꞌomna na maquiinaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Quia na ntyꞌiaaⁿꞌaⁿ nnꞌaⁿ na jndyendye, tꞌoom na wiꞌ tsꞌoom naⁿꞌñeeⁿ ee cweꞌ mꞌaⁿntjeiⁿtona ndoꞌ tjaa ꞌñeeⁿ na nnteijndeii joona. Laxmaⁿna chaꞌcwijom cwii tmaaⁿꞌ canmaⁿ na tjaa ꞌñeeⁿ juu na ya nnteixꞌee. ");
INSERT INTO amuNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Quia joꞌ to̱o̱ⁿꞌo̱ⁿ na maꞌmo̱o̱ⁿ na jndye nnꞌaⁿ mamꞌaⁿ na nndye ñꞌoomꞌ Tyꞌo̱o̱tsꞌom sa̱a̱ tijndye nnꞌaⁿ na nntjeiꞌyuuꞌndye nda̱a̱na. Tsoom ñꞌoom tjañoomꞌ nda̱a̱ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê: —Jeeⁿ ya jnda̱ tueꞌ ntjom, sa̱a̱ naⁿntjom tijndyendyena. ");
INSERT INTO amuNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Joꞌ chii calaꞌtyꞌoondyoꞌ nnom Tyꞌo̱o̱tsꞌom na jom cwentaaⁿꞌaⁿ ntjomꞌñeeⁿ, na cajñoom nnꞌaⁿ na cꞌoocatyjeendye ntjoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesús tqueeⁿꞌñê jâ nnꞌaⁿ canchooꞌwe. Tquiaaⁿ cantyja najndeii na matseixmaaⁿ nda̱a̱yâ na catjeiiꞌâ jndyetia naquiiꞌ nꞌom nnꞌaⁿ, ndoꞌ na calaꞌnꞌmaaⁿyâ nnꞌaⁿ chaꞌtso nnom ntycu na wiina ñequio chaꞌtso nnom na tajndeiiꞌ nꞌomna na maquiinaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nmeiiⁿ ncuee canchooꞌwendyô̱ apóstoles na jñoom tsꞌiaaⁿ ꞌnaaⁿꞌaⁿ. Najndyee Simón, na mati jndyu Pedro, jnda̱ we tyjeeⁿ Andrés, jnda̱ joꞌ Jacobo ñequio tyjeeⁿ Juan ntseinda Zebedeo, ");
INSERT INTO amuNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe ñequio Bartolomé, Tomás ñequio ja Mateo na ñetoꞌño̱ⁿ tsꞌiaaⁿnda̱a̱ nnꞌaⁿ, ndoꞌ Jacobo jnda Alfeo ñequio Lebeo, tsaⁿ na cwiluena Tadeo, ");
INSERT INTO amuNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón, tsꞌaⁿ na ndiiꞌñe tmaaⁿꞌ nnꞌaⁿ partido cananista, ndoꞌ ñꞌeⁿ Judas Iscariote, tsaⁿ na tquiaa cwenta Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ndoꞌ canchooꞌwendyô̱ jâ jñom Jesús, jnda̱ tquiaaⁿ ñꞌoom nda̱a̱yâ, tsoom: —Tintsaquieꞌyoꞌ quiiꞌntaaⁿ nnꞌaⁿ na nchii nnꞌaⁿ judíos ndoꞌ tintsaquieꞌyoꞌ naquiiꞌ meiⁿcwii tsjoom ꞌnaaⁿ nnꞌaⁿ samaritanos. ");
INSERT INTO amuNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Sa̱a̱ catsaꞌyoꞌ na mꞌaⁿ nnꞌaaⁿya, nnꞌaⁿ Israel na cwiluiindyena chaꞌcwijom canmaⁿ na jnda̱ tsuundye. ");
INSERT INTO amuNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ndoꞌ yocheⁿ na tsacoꞌndiiꞌndyoꞌ, quiaꞌyoꞌ ñꞌoom, canduꞌyoꞌ na jnda̱ tueꞌntyjo̱ na nntsa̱ꞌntjom Tyꞌo̱o̱tsꞌom naquiiꞌ nꞌom nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Calaꞌnꞌmaⁿꞌyoꞌ nnꞌaⁿwii ñequio nnꞌaⁿ na cho tycu lepra. Calanlcwiꞌyoꞌ lꞌoo. Catjeiꞌyoꞌ naⁿjndii naquiiꞌ nꞌom nnꞌaⁿ. Chaꞌxjeⁿ na jnda ꞌo na cweꞌyu naya na matseixmaⁿ Tyꞌo̱o̱tsꞌom, malaaꞌtiꞌ quiaꞌ ꞌo na nndaa ntꞌomcheⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","’Tintsachoꞌyoꞌ sꞌom cajaⁿ, meiⁿ sꞌom xuee, meiⁿ sꞌom wee na ñjom chetsjaꞌ na ntyjaandyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Meiⁿ chetsjaꞌ tintsachoꞌyoꞌ na tsaꞌyoꞌ nato, ñecwii ljo liaa, meiⁿ lcoom, meiⁿ tsꞌoomlꞌeii. Ee tsꞌaⁿ na mandiꞌntjom nnom Tyꞌo̱o̱tsꞌom, tseixmaaⁿ na coꞌñoom na nleilꞌueeꞌñê na macaⁿnaꞌ jom. ");
INSERT INTO amuNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","’Ndoꞌ meiⁿyuucheⁿ na nntsaquieꞌyoꞌ, meiiⁿ tsjoom tꞌmaⁿ, meiiⁿ tsjoom chjoo, joꞌ joꞌ calꞌueeꞌndyoꞌ ꞌñeeⁿ juu tseixmaⁿ na ya tsꞌaⁿñe. Waaꞌ tsaⁿꞌñeeⁿ joꞌ caljooꞌndyoꞌ hasta quia na nluiꞌyoꞌ tsjoomꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Quia na cwitsaquieꞌyoꞌ naquiiꞌ wꞌaaꞌñeeⁿ, canduꞌyoꞌ nda̱a̱ nnꞌaⁿ na Tyꞌo̱o̱tsꞌom matioꞌnaaⁿñê joona. ");
INSERT INTO amuNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ndoꞌ xeⁿ wꞌaaꞌñeeⁿ mꞌaⁿ nnꞌaⁿ na ya nnꞌaⁿndye, quia joꞌ nluii chaꞌxjeⁿ na cwinduꞌyoꞌ na catioꞌnaaⁿñe Tyꞌo̱o̱tsꞌom joona. Sa̱a̱ xeⁿ ticꞌomna na ya nnꞌaⁿndyena, quia joꞌ tixocaluii chaꞌxjeⁿ na cwinduꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ndoꞌ xeⁿ nntsꞌaanaꞌ na mꞌaaⁿ ꞌñeeⁿ juu na tiñeꞌcatseiljo ꞌo, oo tiñeꞌcandii ñꞌoom na cwinduꞌyoꞌ, quia na cwicaluiꞌyoꞌ wꞌaaꞌñeeⁿ oo tsjoomꞌñeeⁿ calaꞌquiaꞌyoꞌ tsꞌojnda̱a̱ na chuuꞌ ncꞌeeꞌyoꞌ. Ee na nlꞌaꞌyoꞌ na luaaꞌ cwicaluiꞌyuuꞌnaꞌ na joona tiñeꞌcatoꞌñoomna ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na cwiñeꞌquiaꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mayuuꞌcheⁿ nndyeꞌyoꞌ nntsjo̱o̱, juu xuee na nncuꞌxeⁿ Tyꞌo̱o̱tsꞌom nnꞌaⁿ, matꞌmaⁿti nlcoꞌwiꞌnaꞌ nnꞌaⁿ tsjoomꞌñeeⁿ yuu na tîcatoꞌñoom nnꞌaⁿ ñꞌoom naya, nchiiti na nlcoꞌwiꞌnaꞌ nnꞌaⁿ ndyuaa Sodoma ñequio Gomorra na teiyo seityuiiꞌ Tyꞌo̱o̱tsꞌom cwii cwii tsjoomna ncꞌe na wiꞌndye naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","’Queⁿꞌyoꞌ cwenta, majño̱o̱ⁿya ꞌo quiiꞌntaaⁿ nnꞌaⁿ na wiꞌndye. Cwiluiindyoꞌ chaꞌcwijom canmaⁿ na mꞌaⁿ quiiꞌntaaⁿ lobo. Cweꞌ joꞌ cꞌomꞌcꞌeendyoꞌ chaꞌna catsuu cha tiquiuꞌnnꞌaⁿnaꞌ ꞌo. Ndoꞌ cꞌomꞌyoꞌ na tjaa mayaⁿꞌyoꞌ chaꞌna catuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Matsjo̱o̱ calꞌaꞌyoꞌ cwenta naⁿꞌñeeⁿ ee nncꞌoochona ꞌo nda̱a̱ naⁿmaⁿnꞌiaaⁿ ndoꞌ nlaꞌseiꞌna ꞌo meiiⁿ naquiiꞌ lanꞌom ꞌnaaⁿna. ");
INSERT INTO amuNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ndoꞌ nncꞌoochona ꞌo jo nda̱a̱ gobiernom ñequio jo nda̱a̱ nnꞌaⁿ na cwiluiitꞌmaⁿndyeti ncꞌe cwilaꞌxmaⁿꞌyoꞌ cwentaya. Joꞌ na nñequiaanaꞌ na wanaaⁿ na nntjeiꞌyuuꞌndyoꞌ cantyja ꞌnaⁿya nda̱a̱ naⁿꞌñeeⁿ ndoꞌ mati nda̱a̱ nnꞌaⁿ na tyoocandaa ñꞌoomꞌ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Sa̱a̱ tincꞌomꞌyoꞌ ñꞌomtiuu ñꞌoom na nntjeiꞌyuuꞌndyoꞌ oo chiuuya nlanchuꞌyoꞌ ñꞌoom. Ee nquii Tyꞌo̱o̱tsꞌom mꞌmo̱o̱ⁿ naquiiꞌ nꞌomꞌyoꞌ cwaaⁿ ñꞌoom na nnduꞌyoꞌ quia na jeꞌ mamacaⁿnaꞌ na nntjeiꞌyuuꞌndyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ee ñꞌoom na nnduꞌyoꞌ nchii na jndo̱ꞌ nꞌomꞌ ncjoꞌyoꞌ ee nquii Espíritu na cwiluiiñe Tyꞌo̱o̱tsꞌom nntseijno̱o̱ⁿꞌo̱ⁿ nꞌomꞌyoꞌ cwaaⁿ ñꞌoom nntꞌo̱ꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","’Ee ntseinda tsꞌaⁿ nñequiana cwenta tyjeena na nlaꞌcueeꞌ naⁿmaⁿnꞌiaaⁿ juu. Ndoꞌ ñꞌeeⁿ nnꞌaⁿ na nñeꞌquiana cwenta ndana na cwje. Ndoꞌ nda nnꞌaⁿ nlaꞌwendyena nacjoo tyendyeena cha cwje naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ndoꞌ chaꞌtsondye nnꞌaⁿ nncꞌomna na jndoona ꞌo, ncꞌe na cwilaxmaⁿꞌyoꞌ cantyja ꞌnaⁿya. Sa̱a̱ juu tsꞌaⁿ na tyeⁿ cwiljooꞌñe ñꞌeⁿndyo̱ hasta na macanda̱, tsaⁿꞌñeeⁿ nluiꞌnꞌmaaⁿñe. ");
INSERT INTO amuNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Quia cwitaꞌwiꞌna ꞌo na mꞌaⁿꞌyoꞌ cwii tsjoom, caluiꞌyoꞌ joꞌ joꞌ, catsaꞌyoꞌ cwiicheⁿ tsjoom. Ee ñꞌoom na mayuuꞌcheⁿ matsjo̱o̱, tyooluiꞌñꞌeⁿ njoom ndyuaa Israel na nntjeiꞌyuuꞌndyoꞌ nda̱a̱ nnꞌaⁿ ndoꞌ ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee nncwja̱nndaꞌa. ");
INSERT INTO amuNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Tsoti Jesús ñꞌoom tjañoomꞌ nda̱a̱ jâ nnꞌaⁿ na cwilajomndyô̱ ñꞌeⁿñê. Tsoom: —Juu tsꞌaⁿ na matseiꞌnaaⁿꞌ ticaluiitꞌmaⁿñê, ee nquii maestro ꞌnaaⁿꞌaⁿ cwiluiitꞌmaⁿñeti nchiiti jom. Ndoꞌ mati juu tsꞌaⁿ na mandiꞌntjom ticaluiitꞌmaⁿñê, ee nquii patrom ꞌnaaⁿꞌaⁿ tꞌmaⁿti cwiluiiñe nchiiti jom. ");
INSERT INTO amuNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Juu tsꞌaⁿ na matseiꞌnaaⁿꞌ matsonaꞌ na catjoom chaꞌxjeⁿ na matjom maestro ꞌnaaⁿꞌaⁿ. Ndoꞌ mati juu tsꞌaⁿ na mandiꞌntjom matyꞌiomnaꞌ na cjaawinoom chaꞌxjeⁿ na mawinom tsꞌaⁿ na mandiꞌntjoom nnom. Ndoꞌ nquii tsꞌaⁿ na cwiluiitquieñe cwii wꞌaa, xeⁿ nlue nnꞌaⁿ na cwiluiiñê tsaⁿjndiitquiee, majndeiiticheⁿ tinluena ñꞌoomwiꞌ nacjoo nnꞌaⁿ waⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","’Quia joꞌ tintyueꞌyoꞌ ljoꞌ na nlꞌa nnꞌaⁿ ꞌo. Ee chaꞌtso na wantyꞌiuuꞌ mꞌaaⁿnaꞌ jeꞌ, maxjeⁿ nleitquiooꞌ. Ndoꞌ meiⁿ tjaaꞌnaⁿ cwii na cweꞌ ntyꞌiu tuii na tixocwitquiooꞌnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Cweꞌ joꞌ joo ñꞌoom tjañoomꞌ na matseina̱ⁿya nda̱a̱ꞌyoꞌ, ꞌo calaneiⁿꞌ ndyeyuꞌyoꞌ nda̱a̱ nnꞌaⁿ. Ndoꞌ ñꞌoom na matseina̱ⁿya nda̱a̱ꞌyoꞌ na ñencjoꞌyoꞌ, canduꞌyoꞌ na candye chaꞌtso nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Tincꞌomꞌyoꞌ na nquiaꞌyoꞌ joo nnꞌaⁿ na cwilaꞌcwjee ncꞌiaa ee tixonda̱a̱ nlaꞌcatsuuna añmaaⁿ nnꞌaⁿ. ꞌO jeꞌ cꞌomꞌyoꞌ na nquiaꞌyoꞌ nquii Tyꞌo̱o̱tsꞌom ee jom waa najneiⁿ na nncjoomꞌm tsꞌaⁿ quiiꞌ bꞌio, na nntsuuñe añmaaⁿꞌ tsꞌaⁿ na macanda̱. ");
INSERT INTO amuNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","’ꞌO manquiuꞌyoꞌ na meiⁿchjoo ticajnda cwiwilꞌua we cantsaa nchꞌu. Sa̱a̱ nquii Tsotyeꞌyoꞌ Tyꞌo̱o̱tsꞌom machꞌeeⁿ cwenta jooyoꞌ. Meiⁿcwiindye jooyoꞌ xocueꞌ na ticaljeiiⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Mati ticwii cwii soonqueⁿꞌyoꞌ majndaaꞌ ntyjeeⁿ ljoꞌ joonaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Cweꞌ joꞌ tilacatyuendyoꞌ ee jndandyoꞌtiꞌyoꞌ ntyjeeⁿ nchiiti cantsaa nchꞌu. ");
INSERT INTO amuNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","’Ndoꞌ meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na nncwjiꞌyuuꞌñe cantyja ꞌnaⁿya jo nda̱a̱ nnꞌaⁿ, ja nncwjiꞌyuuꞌndyo̱ na mawajnaⁿꞌa jom jo nnom Tsotya̱ya na mꞌaaⁿ cañoomꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Sa̱a̱ ꞌñeeⁿ tsꞌaⁿ na nncwjiꞌñe cantyja ꞌnaⁿya jo nda̱a̱ nnꞌaⁿ, mati ja nncwjiꞌyuuꞌndyo̱ na ticwajnaⁿꞌa jom jo nnom Tsotya̱ya na mꞌaaⁿ cañoomꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","’Ticalaꞌtiuuꞌyoꞌ na jndyo̱o̱ tsjoomnancue na ya nncꞌom nnꞌaⁿ ñꞌeⁿ ncꞌiaana. Ee ja nchii na jndyo̱o̱ na caljoya nꞌom nnꞌaⁿ ñequio ncꞌiaana. Ee cantyja ꞌnaⁿya nncꞌom nnꞌaⁿ na jndoondye ntyjeena. ");
INSERT INTO amuNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ee cantyja ꞌnaⁿ ja nnto̱ⁿꞌnaꞌ tsaⁿsꞌa ñꞌeⁿ tsotyeeⁿ, mati tsaⁿscu ñꞌeⁿ tsoñeeⁿ, ndoꞌ tsaⁿnntsa ñꞌeⁿ sta̱xeeⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Cweꞌ joꞌ cwii cwii tsꞌaⁿ na matseiyuꞌ ñꞌeⁿndyo̱, nquiee nnꞌaⁿ waⁿꞌaⁿ nlaꞌjndoona jom. ");
INSERT INTO amuNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","’ꞌÑeeⁿ juu tsꞌaⁿ na jndati ntyjii tsotye, tsondyee, nchiiti ja, tsaⁿꞌñeeⁿ titseixmaaⁿ na nncꞌoomñê cwentaya. Mati juu tsꞌaⁿ na jndati ntyjii ñꞌeⁿ tiꞌjnda, oo nomjnda, nchiiti ñꞌeⁿndyo̱ ja, tsaⁿꞌñeeⁿ ticatsonaꞌ na nncꞌoomñe cwentaya. ");
INSERT INTO amuNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ndoꞌ meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na nntseijomñe cantyja na matsꞌaa, xeⁿ tiljoya tsꞌom nawiꞌ na matjom cantyja ꞌnaⁿya, meiiⁿ cueꞌ, tsaⁿꞌñeeⁿ ticatsonaꞌ na nntseixmaaⁿ cwentaya. ");
INSERT INTO amuNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ee meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na mañequiaañe na catjom ljoꞌ na nntjom ncꞌe na mꞌaaⁿ cantyja ꞌnaⁿya, nluiꞌnꞌmaaⁿñe tsaⁿꞌñeeⁿ. Ndoꞌ meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na malꞌueeꞌñe cheⁿnquii chiuu nluiꞌnꞌmaaⁿñê, majoꞌto joꞌ nntsuuñê. ");
INSERT INTO amuNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","’Meiⁿquia tsꞌaⁿ na matseiljo ꞌo, mati ja matseiljo tsaⁿꞌñeeⁿ. Ndoꞌ juu tsꞌaⁿ na matseiljo ja, mati matseiljo tsaⁿꞌñeeⁿ Tsotya̱ya na jñom ja. ");
INSERT INTO amuNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Meiⁿquia tsꞌaⁿ na matseiljo cwii profeta na mañequiaa ñꞌoomꞌ Tyꞌo̱o̱tsꞌom, juu naya na macandaaꞌ cwii profeta, majoꞌti nndaaꞌ tsaⁿꞌñeeⁿ. Ndoꞌ meiⁿquia tsꞌaⁿ na matseiljo cwii tsꞌaⁿ na mꞌaaⁿ cantyja na matyꞌiomyanaꞌ, ncꞌe na mantyꞌiaaⁿꞌaⁿ na ya machꞌee tsaⁿꞌñeeⁿ, mañejuu naya na macandaaꞌ tsꞌaⁿ na ya machꞌee, majoꞌti nndaꞌ tsaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ndoꞌ meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na machꞌee naya meiiⁿ ñeꞌchjoowiꞌ ndaatioo teiⁿ na nncꞌuu cwii tsꞌaⁿ na titꞌmaⁿ cwiluiiñe ncꞌe na matseijomñe ñꞌeⁿndyo̱, ñꞌoom na mayuuꞌ na matsjo̱o̱ nda̱a̱ꞌyoꞌ, tsaⁿꞌñeeⁿ waa naya ꞌnaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Quia na jnda̱ tꞌmo̱ⁿ Jesús ñꞌoommeiⁿꞌ nda̱a̱ jâ nnꞌaⁿ na canchooꞌwendye na cwilajomndyô̱ ñꞌeⁿñê, quia joꞌ jlueeⁿꞌeⁿ joꞌ joꞌ. Tjaaⁿ na mꞌmo̱o̱ⁿ ndoꞌ na nñequiaaⁿ ñꞌoom naquiiꞌ njoom ndyuaaꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juan tsaⁿ na tyotseitsꞌoomñe nnꞌaⁿ, mꞌaaⁿ wꞌaancjo quia na jñeeⁿ ñꞌoom cantyja ꞌnaaⁿꞌ tsꞌiaaⁿ na tyochꞌee Cristo. Jñoom we nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê na cꞌootaꞌxꞌee cwii ñꞌoom ꞌndyoo Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Jluena: —¿Aa ꞌu cwiluiindyuꞌ Cristo na nncwjeeꞌcañoom tsjoomnancue, oo aa nncwindo̱o̱ꞌâ cwiicheⁿ? ");
INSERT INTO amuNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Tꞌo̱ Jesús nda̱a̱ naⁿꞌñeeⁿ, tsoom: —Catsaꞌyoꞌ ndoꞌ canduꞌyoꞌ nnom Juan cantyja ñꞌoom naya na cwindyeꞌyoꞌ ndoꞌ na cwintyꞌiaꞌnda̱a̱ꞌyoꞌ na jndye nnꞌaⁿ cwinꞌmaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ndoꞌ canduꞌyoꞌ nnoom nnꞌaⁿ na ñetꞌom na nchjaaⁿ jnda̱ teitquioo. Nnꞌaⁿ na ñetꞌom na ntjeiⁿ ncꞌeeꞌ jeꞌ ya cwiꞌoocaꞌ. Nnꞌaⁿ na ñecho tycu lepra, jeꞌ jnda̱ ljuuꞌndye. Nnꞌaⁿ na ñetꞌom na cantaa, jeꞌ ya cwindye. Ndoꞌ nnꞌaⁿ na jnda̱ tja̱, jeꞌ jnda̱ cwitaꞌndoꞌxcona. Ndoꞌ joo nnꞌaⁿ na ntyꞌiaandye jnda̱ macwindyena ñꞌoom naya na macwjiꞌnꞌmaaⁿñe Tyꞌo̱o̱tsꞌom joona. ");
INSERT INTO amuNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ndoꞌ neiiⁿꞌ tsꞌom tsꞌaⁿ na ñeꞌcwii matseitiuu cantyja ꞌnaⁿya ee juu xotseijnaaⁿꞌnaꞌ. Ñꞌoommeiⁿꞌ seineiⁿ Jesús nda̱a̱ nnꞌaⁿ na jñom Juan. ");
INSERT INTO amuNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Quia na jnda̱ tyꞌelcweeꞌ naⁿꞌñeeⁿ, to̱ꞌ Jesús na matseineiiⁿ nda̱a̱ tmaaⁿꞌ nnꞌaⁿ na mꞌaⁿ nacañomꞌm cantyja ꞌnaaⁿꞌ Juan. Tsoom: —¿Chiuu waa na saacantyꞌiaꞌyoꞌ na saꞌyoꞌ na mꞌaaⁿ Juan jo ndoꞌ yuu tjaa nnꞌaⁿ cꞌom? ¿Aa ntyꞌiaꞌyoꞌ na jom tsꞌaⁿ na we waa na matseineiⁿ chaꞌcwijom cwii tsmaaⁿ na maleiñꞌoomñe jndye? Ntyjii nchii joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Quia joꞌ ¿chiuu waa na saacantyꞌiaꞌyoꞌ na saꞌyoꞌ? ¿Aa ntyꞌiaꞌyoꞌ cwii tsꞌaⁿ na cwee liaa na jnda? Ntyjii nchii joꞌ. Ee ꞌo nquiuꞌyoꞌ na macanda̱ nnꞌaⁿ na tjacantyja na tꞌmaⁿ nꞌiaaⁿ, joona cwicweeꞌna liaa jnda ñequio nnꞌaⁿ wꞌaana. ");
INSERT INTO amuNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Quia joꞌ ¿chiuu waa na saacantyꞌiaꞌyoꞌ? ¿Aa ntyꞌiaꞌyoꞌ cwii profeta? Ja ntyjii na joꞌ. Ndoꞌ jom tꞌmaⁿti cwiluiiñê nchiiti ntꞌomcheⁿ profeta. ");
INSERT INTO amuNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ee ljeii ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom matseineiⁿnaꞌ cantyja ꞌnaaⁿꞌaⁿ. Luaa matsonaꞌ: Ja majño̱o̱ⁿñetya̱ya cwii moso ꞌnaⁿya na wjaajndyee jo njomꞌ. Jom nncwjiꞌyuuꞌñê cantyja ꞌnaⁿꞌ, cha nncꞌomcꞌeendye nnꞌaⁿ quia na nncueꞌcañoomꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ndoꞌ tsoticheⁿ Jesús: —Mayuuꞌcheⁿ nndyeꞌyoꞌ nntsjo̱o̱, tijoom ñeteitquiooꞌñe cwii tsꞌaⁿ na tꞌmaⁿti cwiluiiñe quiiꞌntaaⁿ chaꞌtsondye nnꞌaⁿ chaꞌna juu Juan, tsꞌaⁿ na tyotseitsꞌoomñe nnꞌaⁿ. Sa̱a̱ meiiⁿ na ljoꞌ, meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na jnda̱ tjaquieeꞌñe cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom, meiiⁿ titꞌmaⁿ cwiluiiñe, sa̱a̱ tꞌmaⁿti cwiluiiñe, nchiiti Juan. ");
INSERT INTO amuNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Ndoꞌ seineiⁿti Jesús, tsoom: —Quia na to̱ꞌ Juan na tyotseitsꞌoomñe nnꞌaⁿ teitquiooꞌ na cwilaꞌjnda̱ nnꞌaⁿ na nncꞌooquieeꞌndyena cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom hasta xjeⁿ jeꞌ. Ndoꞌ naⁿꞌñeeⁿ cwiqueⁿ nꞌomna na nnaⁿjnda̱na cha nnda̱a̱ nlaꞌxmaⁿna cantyja ꞌnaaⁿꞌ juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Chaꞌtso ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na tyotjeiiꞌyuuꞌndye profetas ñequio ljeii na tqueⁿ Moisés tjoomꞌ tꞌmo̱o̱ⁿnaꞌ cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. Ndoꞌ quia na tyjeeꞌ Juan, jom tꞌmo̱o̱ⁿ na jnda̱ tueꞌntyjo̱ na mamatsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Toom cweꞌ nlayuꞌyoꞌ na Juan matseinoomñê cwentaaꞌ profeta Elías tsaⁿ na waa ñꞌoom na nndyonndaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ꞌÑeeⁿ juu na niom lueꞌ nꞌom luaꞌqui na nndii, candii. ");
INSERT INTO amuNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","’¿Ljoꞌ ñꞌoom na nntseijo̱o̱ⁿꞌa cantyja ꞌnaaⁿ nnꞌaⁿ na mꞌaⁿ tiempomeiiⁿ? Joona matseijomnaꞌ chaꞌna yocanchꞌu na cwinquiooꞌ naquiiꞌ tsjoom. ");
INSERT INTO amuNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Cwilaꞌxuaana nda̱a̱ ncꞌiaana, cwiluena: “Ñetjo̱o̱ꞌâ tsmaaⁿ juu som na cwitjo̱ꞌ na toco tsꞌaⁿ sa̱a̱ ꞌo tîcalaꞌjnomꞌyoꞌ. Jnda̱ chii ñetjo̱o̱ꞌâ som tsꞌoo, sa̱a̱ ꞌo tîcatyueeꞌyoꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Maluaaꞌ matseijomnaꞌ na cwilꞌa nnꞌaⁿ na mꞌaⁿ tiempomeiiⁿ. Ee tyjeꞌcañoom Juan quiiꞌntaaⁿꞌyoꞌ, tꞌoom chaꞌcwijom tsꞌaⁿ na chjooꞌ tsꞌom. Tîcwaaⁿꞌaⁿ nantquie na ya, meiⁿ tîcꞌom winom. Sa̱a̱ ꞌo cwinduꞌyoꞌ tsaⁿjndii matseixmaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Jnda̱ joꞌ tyja̱caño̱o̱ⁿ nnco̱ na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee. Ja matseijomndyo̱ ñꞌeⁿ nnꞌaⁿ, macwaꞌa ñꞌeⁿndyena. Sa̱a̱ ꞌo cwinduꞌyoꞌ cantyja ꞌnaⁿya: “Luaaꞌ tsꞌaⁿ jeeⁿ cwaꞌ, jeeⁿ ꞌuu. Juu jeeⁿ ya matseixꞌiaaꞌñe ñꞌeⁿ nnꞌaⁿ na cwilaꞌtjo̱o̱ndye nnom Tyꞌo̱o̱tsꞌom ñequio nnꞌaⁿ na cwitoꞌñoom tsꞌiaaⁿnda̱a̱ nnꞌaⁿ cwentaaꞌ gobiernom.” Sa̱a̱ tintsꞌaa, ee cwiwitquiooꞌ na jndo̱ꞌ tsꞌom Tyꞌo̱o̱tsꞌom ee chaꞌtso na matseijndaaꞌñê maꞌmo̱ⁿnaꞌ na ljoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jnda̱ chii to̱ꞌ Jesús na matseitiaaⁿꞌaⁿ nnꞌaⁿ njoom yuu na jndyeti tsꞌiaaⁿ sꞌaaⁿ na maꞌmo̱ⁿnaꞌ na tseixmaaⁿ najndeii Tyꞌo̱o̱tsꞌom ee na tîcalcweꞌ nꞌom naⁿꞌñeeⁿ. Matsoom: ");
INSERT INTO amuNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—Jee jndoꞌcheⁿꞌyoꞌ ꞌo nnꞌaⁿ tsjoom Corazín. Jee jndoꞌcheⁿꞌyoꞌ ꞌo nnꞌaⁿ tsjoom Betsaida. Ee quiiꞌntaaⁿꞌyoꞌ jndye tsꞌiaaⁿ tꞌmaⁿ sꞌaa sa̱a̱ tîcalcweꞌ nꞌomꞌyoꞌ. Xeⁿ sꞌaa tsꞌiaaⁿmeiⁿꞌ quiiꞌntaaⁿ nnꞌaⁿ tsjoom Tiro ñꞌeⁿ Sidón, tyuaaꞌti jnda̱ tcweeꞌna liaa tsjaꞌ ndoꞌ jnda̱ tioona tsjaaꞌ nqueⁿna na cwitꞌmo̱o̱ⁿna na cwilcweꞌ nꞌomna. ");
INSERT INTO amuNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nndyeꞌyoꞌ nntsjo̱o̱, xuee na nncuꞌxeⁿ Tyꞌo̱o̱tsꞌom nnꞌaⁿ tꞌmaⁿti nlcoꞌwiꞌnaꞌ ꞌo nchiiti nnꞌaⁿ tsjoom Tiro ñꞌeⁿ Sidón. ");
INSERT INTO amuNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ndoꞌ ꞌo nnꞌaⁿ tsjoom Capernaum, ¿aa cwilaꞌtiuuꞌyoꞌ na cañoomꞌlueecheⁿ nntseiwendyenaꞌ ꞌo cweꞌ ee na jndye tsꞌiaaⁿ sꞌaaya quiiꞌntaaⁿꞌyoꞌ? Maxjeⁿ nntiom Tyꞌo̱o̱tsꞌom ꞌo yuu na meindooꞌ lꞌoo. Mana ntsuuñꞌeⁿ tsjomꞌyoꞌ Capernaum. Xeⁿ nnꞌaⁿ na ñetꞌom tsjoom Sodoma ntyꞌiaana tsꞌiaaⁿ tꞌmaⁿ chaꞌna sꞌaaya quiiꞌntaaⁿꞌyoꞌ, ndicwaⁿ waa tsjoomna xjeⁿ jeꞌcheⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nndyeꞌyoꞌ nntsjo̱o̱ xuee na nncuꞌxeⁿ Tyꞌo̱o̱tsꞌom nnꞌaⁿ tꞌmaⁿti nlcoꞌwiꞌnaꞌ ꞌo nchiiti nnꞌaⁿ na ñetꞌom ndyuaa tsjoom Sodoma. ");
INSERT INTO amuNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ndoꞌ majuu xjeⁿꞌñeeⁿ to̱ꞌ Jesús na matseineiiⁿ nnom Tyꞌo̱o̱tsꞌom, tsoom: —Matseitꞌmaaⁿꞌndyo̱ ꞌu Tsotya̱ya na cwiluiindyuꞌ na matsa̱ꞌntjomꞌ cañoomꞌluee ñequio nnom tsjoomnancue. Ee ꞌu jnda̱ tantyꞌiuuꞌndyuꞌ ñꞌoommeiⁿꞌ nda̱a̱ nnꞌaⁿ na jndo̱ꞌ nꞌom ñequio nnꞌaⁿ na jeeⁿ tꞌmaⁿ cwilaꞌno̱ⁿꞌ, sa̱a̱ jnda̱ seicano̱o̱ⁿꞌ joonaꞌ nda̱a̱ nnꞌaⁿ na cje cwilꞌa. ");
INSERT INTO amuNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Mayuuꞌ Ta, ee luaaꞌ waa na tjaweeꞌ tsꞌomꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Tsonndaꞌ Jesús nda̱a̱ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê: —Chaꞌtso na cwilaꞌxmaⁿ najnda̱, Tsotya̱ya Tyꞌo̱o̱tsꞌom jnda̱ tquiaaⁿ joonaꞌ lꞌo̱o̱ya. Tjaa ꞌñeeⁿ tseiꞌno̱ⁿꞌ chiuu tseixmaⁿya na cwiluiindyo̱ Jnaaⁿ, macanda̱ nqueⁿ ntyjeeⁿ. Meiⁿ tjaa ꞌñeeⁿ tseiꞌno̱ⁿꞌ chiuu tseixmaⁿ Tsotya̱ya, macanda̱ ja na cwiluiindyo̱ Jnaaⁿ mantyjiiya. Mati meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na lꞌue tsꞌo̱o̱ⁿ na nntseiꞌno̱ⁿꞌ chiuu tseixmaⁿ Tsotya̱ya mañequia na nntseiꞌno̱ⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Quioꞌyoꞌ na mꞌaaⁿya chaꞌtsondyoꞌ na jnda̱ teijndyaꞌyoꞌ cantyja ꞌnaaⁿ jnaⁿꞌyoꞌ na joonaꞌ matseijaaꞌñenaꞌ nacjoꞌyoꞌ chaꞌcwijom xuu na tileicanaⁿꞌyoꞌ ndoꞌ ja nñequiaya na nntaꞌjndyeeꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Calajomndyoꞌ ñꞌeⁿndyo̱ chaꞌna cwilaꞌjomndye quiooꞌndyo na ljoyu cwilꞌa tsꞌiaaⁿ. Ndoꞌ quiaandyoꞌ na nntaꞌjnaⁿꞌyoꞌ cantyja ꞌnaⁿya. Ee ja tincꞌuaaꞌ tsꞌo̱o̱ⁿya ndoꞌ mꞌaaⁿya na wiꞌ tsꞌo̱o̱ⁿya ꞌo. Ndoꞌ nliuꞌyoꞌ na nntaꞌjndyee añmaaⁿꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ee na nlaxꞌiaaꞌndyoꞌ ñꞌeⁿndyo̱ xocanchjenaꞌ ꞌo chaꞌna manchje tsꞌoom na ljo cantyaꞌ quiooꞌndyo. Ndoꞌ ñꞌoom na maqua̱ⁿya nda̱a̱ꞌyoꞌ cweꞌ na ya ya xjeⁿ jnda̱ꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Luaa tuii cwii xuee na cwitaꞌjndyee nnꞌaⁿ. Mawinom Jesús yuu waa ntjom lqueeⁿ trigo. Ndoꞌ jâ nnꞌaⁿ na cwilajomndyô̱ ñꞌeⁿñê na ñeꞌjndo̱o̱ꞌâ, to̱o̱ꞌâ tyotyja̱a̱yâ xuꞌlqueeⁿ. Tyotyꞌueendyô̱, tyotquia̱a̱yâ joonaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ndoꞌ nnꞌaⁿ fariseos quia na ntyꞌiaana na luaaꞌ cwilꞌaayâ, jluena nnom Jesús: —Queⁿꞌ cwenta, nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿndyuꞌ cwilꞌana yuu na ticatyꞌiomnaꞌ xuee na cwitaꞌjndyee nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Tꞌo̱o̱ⁿ nda̱a̱ naⁿꞌñeeⁿ, tsoom: —ꞌO, ¿aa tyoolaꞌnaⁿꞌyoꞌ ñꞌoom chiuu sꞌaa David ñequio nnꞌaⁿ na ñꞌeeⁿ ñꞌeⁿñê na ñeꞌjndoꞌna? Sa̱a̱ tyoolancjooꞌndyoꞌ cantyja ꞌnaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ee tjaqueⁿꞌeⁿ watsꞌom cwentaaꞌ Tyꞌo̱o̱tsꞌom, tcaaⁿ ntyooꞌ nnom tyee. Tcwaaⁿꞌaⁿ joonaꞌ ndoꞌ mati tquiaaⁿ na tcwaꞌ nnꞌaⁿ na ñꞌeeⁿ ñꞌeⁿñê. Ndoꞌ ntyooꞌñeeⁿ na jnda̱ tqueⁿ nnꞌaⁿ joonaꞌ nnom Tyꞌo̱o̱tsꞌom, ticwanaaⁿ na nlcwaꞌ meiⁿnquia tsꞌaⁿ. Macanda̱ nquiee ntyee wanaaⁿ na nlcwaꞌna. ");
INSERT INTO amuNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ndoꞌ cwaaⁿti jnda̱ jlaꞌnaⁿꞌyoꞌ naquiiꞌ ljeii na tqueⁿ Moisés na matsonaꞌ na nquiee ntyee jndye tsꞌiaaⁿ cwilꞌana naquiiꞌ watsꞌom tꞌmaⁿ na cwindyeꞌntjomna juu xuee na cwitaꞌjndya̱a̱ya. Sa̱a̱ tjaa jnaaⁿna na ljoꞌ cwilꞌana. ");
INSERT INTO amuNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Jeꞌ nndyeꞌyoꞌ nntsjo̱o̱, ljoo jnda̱ tyja̱caño̱o̱ⁿya naquiiꞌ ntaaⁿꞌyoꞌ na tꞌmaⁿti cwiluiindyo̱ nchiiti juu watsꞌom tꞌmaⁿ na jeeⁿ cwilaꞌtꞌmaaⁿꞌndyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","ꞌO tyoolaꞌno̱ⁿꞌyoꞌ ljoꞌ ñeꞌcatso ñꞌoomwaa na tso Tyꞌo̱o̱tsꞌom: “Ja cajndati ntyjii na nncꞌomꞌyoꞌ na wiꞌ nꞌomꞌyoꞌ ncꞌiaꞌyoꞌ nchiiti na cwiñeꞌquiaꞌyoꞌ quiooꞌ na cwilaꞌtꞌmaaⁿꞌndyoꞌ ja.” Xeⁿ jlaꞌno̱ⁿꞌyoꞌ ñꞌoomwaaꞌ tixoqueⁿꞌyoꞌ xjeⁿ nnꞌaⁿ na tjaa jnaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ncꞌe na luaaꞌ waa, ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee waa na matseixmaⁿya na nntsjo̱o̱ ljoꞌ calꞌa nnꞌaⁿ xuee na cwitaꞌjndya̱a̱ya. ");
INSERT INTO amuNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jnda̱ chii jluiꞌ Jesús joꞌ joꞌ. Tjaaⁿ, tjaqueⁿꞌeⁿ watsꞌom ꞌnaaⁿna. ");
INSERT INTO amuNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ndoꞌ joꞌ joꞌ mꞌaaⁿ cwii tsaⁿsꞌa na ntjeiⁿ tsꞌo̱. Ndoꞌ nnꞌaⁿ fariseos na mꞌaⁿ watsꞌomꞌñeeⁿ jeeⁿ tyolꞌueendyena chiuu nlꞌayoona na nñeꞌquiana cwenta Jesús. Taꞌxꞌeena nnoom, jluena: —Juu xuee na cwitaꞌjndya̱a̱ya ¿aa matyꞌiomnaꞌ na nntseinꞌmaⁿ tsꞌaⁿ tsꞌaⁿwiiꞌ, oo aa tisꞌa? ");
INSERT INTO amuNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Tꞌo̱ Jesús nda̱a̱na, matsoom: —Calaꞌtiuuꞌyoꞌ, xeⁿ mꞌaaⁿ cwiindyoꞌ ꞌo na mꞌaaⁿ catsmaⁿ tsmeiⁿꞌ, ndoꞌ xeⁿ nncjuꞌnaꞌ juuyoꞌ tsꞌom tsueꞌtsjoom, ¿aa nchii nntseityuaꞌ na wjaꞌcwjiꞌ juuyoꞌ meiiⁿ juu xuee na cwitaꞌjndyee nnꞌaⁿ? ");
INSERT INTO amuNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nquii Tyꞌo̱o̱tsꞌom jndati ntyjeeⁿ cwii tsꞌaⁿ nchiiti cweꞌ catsmaⁿ. Joꞌ chii matyꞌiomnaꞌ na cateijndeii tsꞌaⁿ xꞌiaaⁿꞌaⁿ nawiꞌ na matjom, meiiⁿ juu xuee na cwitaꞌjndyee nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Quia joꞌ tsoom nnom tsꞌaⁿwiiꞌ: —Catseiliuuꞌ tsꞌo̱ꞌ. Mana seiliuu tsꞌo̱. Mañoomꞌ tcoꞌyanaꞌ chaꞌxjeⁿ cwiicheⁿ tsꞌo̱o̱ⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ndoꞌ fariseosꞌñeeⁿ jluiꞌna. Jlaꞌtjomndyena, to̱ꞌna tyoꞌmaⁿna chiuu nlꞌayoona na nlaꞌcueeꞌna Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Sa̱a̱ seiꞌno̱ⁿꞌ Jesús na luaaꞌ ñecalꞌana ñꞌeⁿñê. Joꞌ chii jlueeⁿꞌeⁿ joꞌ joꞌ ndoꞌ jndye nnꞌaⁿ tyꞌentyjo̱na naxeeⁿꞌeⁿ. Seinꞌmaaⁿ chaꞌtso nnꞌaⁿwii. ");
INSERT INTO amuNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ndoꞌ tqueⁿtyeeⁿ ñꞌoom nda̱a̱na na ticatꞌoomna ñꞌoom ꞌñeeⁿ cwiluiiñê. ");
INSERT INTO amuNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ndoꞌ na luaaꞌ tsoom, seicanda̱a̱ꞌñenaꞌ ñꞌoom na seiljeii profeta Isaías, na matsonaꞌ: ");
INSERT INTO amuNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Luaa tsꞌaⁿ na jnda̱ tjeiiꞌndyo̱ cwentaya na cwiluiiñê na mandiꞌntjoom no̱o̱ⁿ. Jnda ntyjiiya jom ndoꞌ jeeⁿ neiⁿya cantyja ꞌnaaⁿꞌaⁿ. Nñequiaya Espíritu Santo na juu nncꞌoomñe ñꞌeⁿñê. Ndoꞌ nñequiaaⁿ ñꞌoomya chiuu waa na matyꞌiomyanaꞌ nda̱a̱ nnꞌaⁿ na nchii judíos. ");
INSERT INTO amuNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Jom xocatseintjaꞌñê, meiⁿ xocatseijndeiiꞌ ꞌñom. Ndoꞌ xocaljeiꞌ jom tsꞌom nataa na macwjaaꞌñê tiaꞌ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Xocoꞌweeⁿꞌeⁿ tsꞌaⁿ na tityeⁿ matseiyuꞌ na juu matseijomnaꞌ chaꞌna tsmaaⁿ na jnda̱ tomndyaa. Ee jom jaateijndeiityeeⁿ tsaⁿꞌñeeⁿ. Meiⁿ xotseicanduuꞌñꞌeeⁿ cantyja ꞌnaaⁿꞌ tsꞌaⁿ na tixuee naquiiꞌ tsꞌom na juu matseijomnaꞌ chaꞌna chom canti na ncuencue canduuꞌ. Ee jom nñequiaatyeeⁿ naxuee naquiiꞌ tsꞌom tsaⁿꞌñeeⁿ. Joꞌ chii nntsꞌaaⁿ na nnaⁿjndeii cantyja na matyꞌiomyanaꞌ naquiiꞌ nꞌom nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ndoꞌ nnꞌaⁿ na nchii judíos nlaꞌcantyjaaꞌ nꞌomna jom. ");
INSERT INTO amuNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tquioñꞌomna cwii tsꞌaⁿ na mꞌaaⁿ Jesús na jnda̱ tuo̱ naⁿjndii naquiiꞌ tsꞌom. Tsaⁿꞌñeeⁿ nchjaaⁿꞌaⁿ ndoꞌ tileicatseineiiⁿ lꞌa naⁿjndiiꞌñeeⁿ. Seinꞌmaⁿ Jesús jom. Quia joꞌ to̱o̱ⁿꞌo̱ⁿ na matseineiiⁿ ndoꞌ teitquiooꞌnnaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ntoꞌ chaꞌtso nnꞌaⁿ na ntyꞌiaa na luaaꞌ tuii, jeeⁿ tjaweeꞌ nꞌomna. Jluena: —¿Aa ntsꞌaacheⁿnaꞌ na tsaⁿmꞌaaⁿꞌ cwiluiiñê nquii na meindo̱o̱ꞌa na nluiiñe tsjaaⁿ David na jndyowicantyjooꞌ? ");
INSERT INTO amuNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ndoꞌ nnꞌaⁿ fariseos, quia jndyena ñꞌoomwaaꞌ, tyoluena: —Tsaⁿsꞌamꞌaaⁿꞌ matseixmaaⁿ najndeii Beelzebú nquii tsaⁿjndiitquiee. Joꞌ chii cwicanda̱a̱ macwjeeⁿꞌeⁿ naⁿjndii naquiiꞌ nꞌom nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Seiꞌno̱ⁿꞌ Jesús ñꞌoom na tyomꞌaaⁿꞌ nꞌomna. Tsoom nda̱a̱na: —Xeⁿ mꞌaaⁿ cwii gobiernom na cwito̱ⁿꞌndye nnꞌaⁿ ꞌnaaⁿꞌaⁿ, ntꞌom cwiꞌoo nacjoomꞌm ndoꞌ ntꞌom cwilaꞌjomndye ñꞌeⁿñê, ndoꞌ na luaaꞌ waa xocaljooꞌñetyeeⁿ tsꞌiaaⁿ. Ndoꞌ chaꞌna nnꞌaⁿ na ñecwii tsjoom oo nnꞌaⁿ na ñeꞌcwii wꞌaa, xeⁿ cwilaꞌntjaꞌndyena, maxjeⁿ nnto̱ⁿꞌndyena. Ndoꞌ na ljoꞌ cwilaꞌtyuiiꞌndye cheⁿnquieena. ");
INSERT INTO amuNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ee xeⁿ na mayuuꞌ chaꞌna cwinduꞌyoꞌ na nquii tsaⁿjndiitquiee macwjeeⁿꞌeⁿ ntyje naⁿjndiiñê naquiiꞌ nꞌom nnꞌaⁿ, quia joꞌ maꞌmo̱ⁿnaꞌ na matseityuiiꞌñe cheⁿnqueⁿ. ¿Chiuu nntsꞌaayom na nljotyeⁿ cantyja najneiⁿ na matsa̱ꞌntjoom? ");
INSERT INTO amuNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ꞌO cwinduꞌyoꞌ na ja cweꞌ cantyja najndeii Beelzebú joꞌ na macwjiiꞌa naⁿjndii naquiiꞌ nꞌom nnꞌaⁿ. Xeⁿ na mayuuꞌ na ljoꞌ, quia joꞌ mati ncꞌiaaꞌyoꞌ, ñequio najndeii jom cwitjeiiꞌna naⁿjndii naquiiꞌ nꞌom nnꞌaⁿ. Sa̱a̱ ncꞌe na tiyuuꞌ na ljoꞌ, cantyja na cwilꞌa nquieena cwiluiꞌyuuꞌ na tixcwe cwitjeiꞌyoꞌ cwenta. ");
INSERT INTO amuNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Sa̱a̱ ncꞌe ja ñequio najndeii Espíritu na cwiluiiñe Tyꞌo̱o̱tsꞌom, joꞌ na macwjiiꞌa naⁿjndii naquiiꞌ nꞌom nnꞌaⁿ, joꞌ chii maꞌmo̱ⁿnaꞌ juu na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom, jnda̱ tyjeeꞌcañoomnaꞌ ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","’Cwii tsaⁿcanchꞌue xonda̱a̱ nncjaaqueⁿꞌeⁿ waaꞌ tsꞌaⁿ na waa najndeii na nncwjeeⁿꞌeⁿ ꞌnaaⁿꞌ. Sa̱a̱ xeⁿ nntseityeⁿjñeeⁿ tsaⁿꞌñeeⁿ quia joꞌ nnda̱a̱ na nncwjiꞌñꞌeeⁿ ꞌnaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","’ꞌÑeeⁿ juu na ticꞌoomñe cantyja ꞌnaⁿya, maxjeⁿ mꞌaaⁿ nacjoya. Ndoꞌ ꞌñeeⁿ juu na ticatseitjom nnꞌaⁿ ñꞌeⁿndyo̱, jom machꞌeeⁿ na matseilcweꞌnaꞌ nnꞌaⁿ na ticalaꞌyuꞌna ñꞌeⁿndyo̱. ");
INSERT INTO amuNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","’Joꞌ chii matsjo̱o̱ nda̱a̱ꞌyoꞌ, Tyꞌo̱o̱tsꞌom nntseitꞌmaⁿ tsꞌoom chaꞌtso jnaⁿ na cwilaꞌxmaⁿ nnꞌaⁿ ñequio chaꞌtso ñꞌomntjeiⁿ na cwiluena. Sa̱a̱ meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na matseineiⁿ ñꞌoom wiꞌ nacjooꞌ Espíritu Santo, tsaⁿꞌñeeⁿ xocatseitꞌmaⁿ tsꞌom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ndoꞌ meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na matseineiⁿ ñꞌoom wiꞌ nacjo ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee, nnda̱a̱ nntseitꞌmaⁿ tsꞌom Tyꞌo̱o̱tsꞌom tsaⁿꞌñeeⁿ. Sa̱a̱ meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na matsoyuu na cwiluii tsꞌiaaⁿ ꞌnaⁿya cweꞌ cantyja najndeii tsaⁿjndii, tsaⁿꞌñeeⁿ matseineiⁿ ñꞌoom wiꞌ nacjooꞌ Espíritu Santo. Ndoꞌ na ljoꞌ tijoom nntseitꞌmaⁿ tsꞌom Tyꞌo̱o̱tsꞌom tsaⁿꞌñeeⁿ, meiiⁿ tiempomeiiⁿcheⁿ ndoꞌ meiiⁿ ncuee na jnda̱ ntycwii tsjoomnancue. ");
INSERT INTO amuNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","’Quia joꞌ seineiⁿ Jesús cwii ñꞌoom tjañoomꞌ na macaⁿnaꞌ na catjeiiꞌna cwenta cantyja ꞌnaaⁿꞌaⁿ. Seijoomꞌñe nqueⁿ chaꞌcwijom cwii tsꞌoom na ya ta̱a̱ꞌnaꞌ. Tsoom: —Xeⁿ cwintyꞌiaꞌyoꞌ na ya ta̱ na ntyja cwii tsꞌoom, cwilaꞌno̱ⁿꞌyoꞌ na mati nquii tsꞌoom cwiluiiñenaꞌ tsꞌoom na ya. Ndoꞌ xeⁿ cwintyꞌiaꞌyoꞌ na tisꞌa ta̱ na ntyja cwii tsꞌoom, cwilaꞌno̱ⁿꞌyoꞌ na mati tisꞌa tsꞌoomꞌñeeⁿ. Ee cantyja chiuu waa ta̱ na machꞌee cwii cwii tsꞌoom joꞌ nntaꞌjnaⁿꞌyoꞌ cwaaⁿ tsꞌoom na ya ndoꞌ cwaaⁿ tsꞌoom na tisꞌa. ");
INSERT INTO amuNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Chaꞌna catsuutsja jeeⁿ wjee ndaaꞌndyooyoꞌ, maluaaꞌ matseijomnaꞌ ꞌo. Chiuu nlꞌaꞌyoꞌ na nlaneiⁿꞌyoꞌ ñꞌoom ya ndoꞌ naquiiꞌ nꞌomꞌyoꞌ tooꞌcheⁿ natia. Ee cantyjati na matseitiuu tsꞌaⁿ naquiiꞌ tsꞌoom, mantyja joꞌ ñꞌoom na cwicaluiꞌ ꞌñom. ");
INSERT INTO amuNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Juu tsꞌaⁿ na ya tsꞌaⁿñe matseineiⁿ ñꞌoom ya ee naquiiꞌ tsꞌoom cwinaⁿ naya na matseitioom. Sa̱a̱ juu tsꞌaⁿ na tia tsꞌaⁿñe matseineiⁿ ñꞌoom tia ee naquiiꞌ tsꞌoom cwinaⁿ natia na matseitioom. ");
INSERT INTO amuNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nndyeꞌyoꞌ nntsjo̱o̱, juu xuee na nncuꞌxeⁿ Tyꞌo̱o̱tsꞌom nnꞌaⁿ, quia joꞌ nñequiana cwenta nnoom cantyja ꞌnaaⁿꞌ cwii cwii ꞌndyo ñꞌoom na cweꞌ tsꞌiaaⁿꞌndyo na ñejlaꞌneiⁿna. ");
INSERT INTO amuNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ee cantyjati ñꞌoom na cwilaneiⁿꞌyoꞌ, Tyꞌo̱o̱tsꞌom nncuꞌxeeⁿ ꞌo. Ñꞌoom na ya na cwinduꞌyoꞌ nncwañoomꞌnaꞌ ꞌo. Ndoꞌ ñꞌoom tia na cwinduꞌyoꞌ nntꞌuiityeⁿnaꞌ ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Quia joꞌ ntꞌom nnꞌaⁿ fariseos ñequio nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés jluena nnom Jesús: —Cwa, Maestro, lꞌue nꞌo̱o̱ⁿyâ na mꞌmo̱ⁿꞌ cwii ꞌnaaⁿ na tꞌmaⁿ na nntyꞌiaayâ. ");
INSERT INTO amuNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Tꞌo̱ Jesús nda̱a̱na: —Nnꞌaⁿ na mꞌaⁿ jeꞌ jeeⁿ tia nnꞌaⁿndye, jnda̱ ꞌndyena Tyꞌo̱o̱tsꞌom. Joꞌ chii cwitaⁿna ꞌnaaⁿ na tꞌmaⁿti na nntyꞌiaanda̱a̱na cha nntaꞌjnaaⁿꞌna ꞌñeeⁿ cwiluiindyo̱. Sa̱a̱ taxocaꞌmo̱o̱ⁿya. Macanda̱ nntyꞌiaana cwii ꞌnaaⁿ na nntseijomnaꞌ chaꞌna tjom profeta Jonás. ");
INSERT INTO amuNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ee Jonás tyomꞌaaⁿñê ndyee xuee ndoꞌ ndyee tsjom tsꞌom tsiaaꞌ catscaa tꞌmaaⁿ. Maluaaꞌ matseijomnaꞌ na nntjo̱ⁿ ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee. Ee ndyee xuee ndoꞌ ndyee tsjom nljooꞌndyo̱ naquiiꞌ tseiꞌtsua. ");
INSERT INTO amuNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Xuee na nncuꞌxeⁿ Tyꞌo̱o̱tsꞌom nnꞌaⁿ na jnda̱ tja̱, nlcwinndaꞌ nnꞌaⁿ tsjoom Nínive. Mati nnꞌaⁿ na mꞌaⁿ jeꞌ na quia nncꞌoowje, nntandoꞌnndaꞌna quia ljoꞌ. Ndoꞌ nntꞌuiityeⁿnaꞌ joona cweꞌ cantyja na yati lꞌa nnꞌaⁿ tsjoomꞌñeeⁿ. Ee naⁿꞌñeeⁿ ntyja lcweꞌ nꞌomna quia na jndyena ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na tyoñequiaa Jonás. Ndoꞌ queⁿꞌyoꞌ cwenta, ja jnda̱ tyja̱ quiiꞌntaaⁿꞌyoꞌ na cwiluiitꞌmaⁿndyo̱tya̱, nchiiti Jonás. ");
INSERT INTO amuNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ndoꞌ xuee na nntuꞌxeⁿndye nnꞌaⁿ na jnda̱ tja̱, mati nlcwinndaꞌ juu yuscu na tyotsa̱ꞌntjom nnꞌaⁿ ndyuaa jo ndoꞌ na macaluiꞌ caxjuu tsꞌoomꞌnaaⁿ. Mati nnꞌaⁿ na mꞌaⁿ jeꞌ na quia nncwje, nntandoꞌnndaꞌna quia ljoꞌ. Ndoꞌ nntꞌuiityeⁿnaꞌ joona cweꞌ cantyja na xcweeꞌti tsꞌom yuscuꞌñeeⁿ. Ee jom jeeⁿ ndyaꞌ tquia jnaaⁿ, jñoom na ñeꞌcañeeⁿ ñꞌoom ꞌndyoo Salomón, tsꞌaⁿ na jndo̱ꞌti tsꞌom. Ndoꞌ queⁿꞌyoꞌ cwenta, ja jnda̱ tyja̱ quiiꞌntaaⁿꞌyoꞌ na cwiluiitꞌmaⁿndyo̱tya̱, nchiiti Salomón. ");
INSERT INTO amuNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","’Cwii tsaⁿjndii quia na jnda̱ tjeiꞌnaꞌ jom naquiiꞌ tsꞌom tsꞌaⁿ, cweꞌ manomtoom jo ndoꞌ yuu na tjaa nnꞌaⁿ cꞌom na malꞌueeⁿ yuu na nljooꞌñê. Sa̱a̱ na tîcaljeiiⁿ joꞌ, seitioom naquiiꞌ tsꞌoom, tsoom: ");
INSERT INTO amuNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Jeꞌ jo̱nlcwa̱ꞌnndaꞌa naquiiꞌ tsꞌom tsꞌaⁿ yuu na tjeiꞌnaꞌ ja.” Ndoꞌ quia na nncueⁿꞌeⁿ joꞌ joꞌ nljeiiⁿ naquiiꞌ tsꞌom tsaⁿꞌñeeⁿ chaꞌcwijom naquiiꞌ wꞌaa na tjaaꞌnaⁿ tsꞌaⁿ candiiꞌ. Sa̱a̱ jnda̱ taa ljuꞌ ndoꞌ jnda̱ teijndaaꞌya. ");
INSERT INTO amuNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Quia joꞌ tjacachoom ntquieeꞌ naⁿjndii na wiꞌndyeti nchiiti jom. Tyꞌequieꞌna naquiiꞌ tsꞌom tsaⁿꞌñeeⁿ ndoꞌ mana ljooꞌndyetyeⁿna joꞌ joꞌ. Ndoꞌ na jnda̱ we luaaꞌ, manioomti matjom tsaⁿꞌñeeⁿ nchiiti na ñetjomjñeeⁿ. Maluaaꞌ nntjoom nnꞌaⁿ na mꞌaⁿ jeꞌ na jeeⁿ tia nnꞌaⁿndye. ");
INSERT INTO amuNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ndicwaⁿ matseineiⁿ Jesús nda̱a̱ tmaaⁿꞌ nnꞌaⁿ quia na tquieꞌcañom ntyjeeⁿ ñequio tsoñeeⁿ. Ñeꞌcalaꞌneiⁿna ñꞌeⁿñê sa̱a̱ ljooꞌndyena chꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Seicandii cwii tsꞌaⁿ Jesús, tso: —Aa ndiꞌ Ta, jnda̱ tyjeꞌcañoom tsoꞌndyoꞌ ñꞌeⁿ ndyentyꞌiuꞌ na ñeꞌcalaꞌneiⁿna ñꞌeⁿndyuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Sa̱a̱ jom tꞌo̱o̱ⁿ nnom tsaⁿꞌñeeⁿ, tsoom: —Candiꞌ nntsjo̱o̱ njomꞌ ꞌñeeⁿ juu cwiluiiñe tsondyo̱ ndoꞌ ꞌñeeⁿ joo cwiluiindye ndyentyjo̱. ");
INSERT INTO amuNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Quia joꞌ seilioom tsꞌo̱o̱ⁿ, tꞌmo̱o̱ⁿ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê, tsoom: —Naⁿmꞌaⁿ cwiluiindyena tsondyo̱ ñequio ndyentyjo̱. ");
INSERT INTO amuNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ee meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na machꞌee ljoꞌ na lꞌue tsꞌom Tsotya̱ya na mꞌaaⁿ cañoomꞌluee, tsaⁿꞌñeeⁿ cwiluiiñe tiꞌtyjo̱ ndoꞌ nomtyjo̱, ndoꞌ tsondyo̱. ");
INSERT INTO amuNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Tjawiquiuuꞌti majuu xueeꞌñeeⁿ jluiꞌ Jesús naquiiꞌ wꞌaa, tjaaⁿ, tjacjom ꞌndyoo ndaaluee. ");
INSERT INTO amuNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ndoꞌ jeeⁿ jndye nnꞌaⁿ tjomndye na mꞌaaⁿ. Joꞌ chii tjacuo̱o̱ⁿ tsꞌom wꞌaandaa na mantyjo̱cheⁿnaꞌ nnom ndaaluee. Joꞌ joꞌ tjacjom sa̱a̱ chaꞌtsondye naⁿꞌñeeⁿ ljooꞌndyena, meintyjeeꞌna tyuaatcwii ꞌndyoo ndaaluee. ");
INSERT INTO amuNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Quia joꞌ to̱o̱ⁿꞌo̱ⁿ na matseineiiⁿ nda̱a̱ naⁿꞌñeeⁿ. Jndye ñꞌoom tꞌmo̱o̱ⁿ nda̱a̱na ñequio ñꞌoom tjañoomꞌ. Tsoom: —Tyomꞌaaⁿ cwii tsꞌaⁿ na machꞌee tsꞌiaaⁿ jnda̱a̱. Tjaaⁿ, tjacjoomꞌm tsjaaⁿ lqueeⁿ trigo. ");
INSERT INTO amuNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ndoꞌ yocheⁿ na majoomꞌm lqueeⁿꞌñeeⁿ ntꞌom tquiaa tsꞌom nato. Mañoomꞌ tquieꞌcañom cantsaa, tcwaꞌyoꞌ lqueeⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ndoꞌ ntꞌom lqueeⁿ tquiaanaꞌ yuu na jeeⁿ ljo̱ꞌ, yuu na tita mꞌaaⁿ tsꞌo. Tyuaaꞌ tꞌoomnaꞌ ee tita mꞌaaⁿ tsꞌo. ");
INSERT INTO amuNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Sa̱a̱ quia na jnda̱ teijmeiⁿꞌ na mantyꞌiaaꞌ ñeꞌquioomꞌ, tꞌuaanaꞌ, tjacaaⁿnaꞌ ee na tinjoom tyꞌe nchꞌiooꞌnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ndoꞌ ntꞌom lqueeⁿ tquiaanaꞌ yuu na tooꞌ ndaꞌ lꞌo̱o̱nioom. Tyuaaꞌti tjawindye lꞌo̱o̱nioomꞌñeeⁿ, jlaꞌcantoꞌndyenaꞌ nacjooꞌ ntjom. ");
INSERT INTO amuNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Sa̱a̱ ntꞌom lqueeⁿ tquiaanaꞌ yuu na ya tsꞌo, jeeⁿ ya tueꞌnaꞌ. Cwii taⁿꞌ tjeiꞌnaꞌ ñequiee xuu lqueeⁿ trigo na cwii tsꞌoom lqueeⁿ tjacjuꞌ tsꞌaⁿꞌñeeⁿ. Ndoꞌ cwii taⁿꞌ tjeiꞌnaꞌ we xuu waljooꞌ xcwe na cwii tsꞌoom lqueeⁿ tjacjoomꞌm. Ndoꞌ cwiicheⁿ cwii taⁿꞌ tjeiꞌnaꞌ cwii xuu waljooꞌ yom tsꞌoom na cwii tsꞌoom lqueeⁿ tjacjoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ꞌÑeeⁿ juu na niom lueꞌ nꞌom luaꞌqui na nndii, candii. ");
INSERT INTO amuNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿ Jesús tyꞌentyjaaꞌna jom. Taꞌxꞌeena nnoom: —Ticalaꞌno̱o̱ⁿꞌâ chiuu na cweꞌ ñꞌoom wjaañoomꞌ matseiꞌneiⁿꞌ nda̱a̱ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Tꞌo̱o̱ⁿ nda̱a̱na: —Luaa waa na machꞌee Tyꞌo̱o̱tsꞌom, mañequiaaⁿ na ꞌo caliuꞌyoꞌ ñꞌoom na wantyꞌiuuꞌ mꞌaaⁿnaꞌ cantyja na matsa̱ꞌntjoom. Sa̱a̱ ntꞌomcheⁿ nnꞌaⁿ tinquiaaⁿ na nlaꞌno̱ⁿꞌna. ");
INSERT INTO amuNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na macoꞌñom ñꞌoom na maꞌmo̱o̱ⁿya, nñequiaa Tyꞌo̱o̱tsꞌom na nntseiꞌno̱ⁿꞌtyeeⁿ. Sa̱a̱ meiⁿquia tsꞌaⁿ na tîcoꞌñom ñꞌoom na maꞌmo̱o̱ⁿya, nntsꞌaanaꞌ na cweꞌ tsꞌiaaⁿꞌndyo cantyjati chjoowiꞌ na matseiꞌno̱o̱ⁿꞌo̱ⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Joꞌ chii ñꞌoom tjañoomꞌ matseina̱ⁿya nda̱a̱ nnꞌaⁿ. Ee meiiⁿ ñequiiꞌcheⁿ cwintyꞌiaana tsꞌiaaⁿ na matsꞌaa sa̱a̱ maxjeⁿ tixoqueⁿna cwenta. Ndoꞌ meiiⁿ cwindyena ñꞌoom na mañequia sa̱a̱ mꞌaⁿna chaꞌcwijom na tyoondyena, meiⁿ ticalaꞌno̱ⁿꞌna ljoꞌ cwindyena. ");
INSERT INTO amuNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Cantyja ꞌnaaⁿ naⁿꞌñeeⁿ matseicanda̱a̱ꞌñenaꞌ ñꞌoom na seiljeii profeta Isaías, tsoom: Meiiⁿ na jndye na cwindyeꞌyoꞌ sa̱a̱ tixocalaꞌno̱ⁿꞌyoꞌ, ndoꞌ meiiⁿ na jndye cwintyꞌiaꞌnda̱a̱ꞌyoꞌ, sa̱a̱ tixoqueⁿꞌyoꞌ cwenta. ");
INSERT INTO amuNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ee naⁿmꞌaⁿꞌ jnda̱ jlaꞌquieꞌ nꞌomna, cha ticoꞌxcwenaꞌ cantyja na cwilaꞌtiuuna. Ndoꞌ tañeꞌquiandyena na nndyena cha tintsꞌaanaꞌ na nlaꞌno̱ⁿꞌna. Ndoꞌ cwilꞌa nquieena chaꞌcwijom ticajndooꞌna cha ticaⁿnaꞌ na nlqueⁿna cwenta. Joona cwilꞌayana nmeiⁿꞌ cha ticalcweꞌ nꞌomna, tincwjiꞌnꞌmaaⁿndyo̱ joona. ");
INSERT INTO amuNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Seineiⁿti Jesús nda̱a̱ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê. Tsoom: —Sa̱a̱ jeeⁿ matioꞌnaaⁿñe Tyꞌo̱o̱tsꞌom ꞌo na cwintyꞌiaꞌnda̱a̱ꞌyoꞌ tsꞌiaaⁿ na matsꞌaa ndoꞌ mati ñꞌoom na cwindyeꞌyoꞌ cwilaꞌno̱ⁿꞌyoꞌ juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mayuuꞌcheⁿ nndyeꞌyoꞌ nntsjo̱o̱, jndye profetas na tyoñeꞌquia ñꞌoomꞌ Tyꞌo̱o̱tsꞌom tandyo xuee ñequio jndye nnꞌaⁿ na tyomꞌaⁿ cantyja na matyꞌiomyanaꞌ, jeeⁿ tyocantyjaaꞌ nꞌomna na nntyꞌiaanda̱a̱na ljoꞌ na cwintyꞌiaꞌ ꞌo ndoꞌ na nndyena chaꞌna cwindyeꞌ ꞌo sa̱a̱ tîcantyꞌiaana meiⁿ tîcandyena. ");
INSERT INTO amuNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","’Candyeꞌyoꞌ luaa maꞌmo̱ⁿ ñꞌoom tjañoomꞌ cantyja na tjacjuꞌ tsꞌaⁿ tsjaaⁿ lqueeⁿ trigo. ");
INSERT INTO amuNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ntꞌom lqueeⁿ na tquiaa tsꞌom nato na tcwaꞌ cantsaa, joꞌ joꞌ nnꞌaⁿ na cwindye ñꞌoomꞌ Tyꞌo̱o̱tsꞌom. Ee meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na mandii ñꞌoom cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom sa̱a̱ ticatseiꞌno̱o̱ⁿꞌo̱ⁿ, maxjeⁿ macwjeꞌcañoom tsaⁿjndii na nncwjiꞌ ñꞌoom naya naquiiꞌ tsꞌoom. ");
INSERT INTO amuNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ndoꞌ ntꞌom lqueeⁿ na tquiaa yuu na jeeⁿ ljo̱ꞌ, mannꞌaⁿ na cwindye ñꞌoomꞌ Tyꞌo̱o̱tsꞌom ndoꞌ ñequio na neiiⁿna cwitoꞌñoomna juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Sa̱a̱ naⁿꞌñeeⁿ chaꞌcwijom ntjom na tinjoom tyꞌe nchꞌiooꞌnaꞌ, na tyuaaꞌ tcaaⁿnaꞌ. Ee quia na macoꞌwiꞌnaꞌ joona oo cwileiꞌntyjo̱ nnꞌaⁿ joona cantyja ꞌnaaⁿꞌ ñꞌoom naya, mantyja cwiꞌndyena. ");
INSERT INTO amuNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ndoꞌ lqueeⁿ na tquiaa yuu na tooꞌ ndaꞌ lꞌo̱o̱nioom, mannꞌaⁿ na cwindye ñꞌoom naya. Sa̱a̱ naⁿꞌñeeⁿ jeeⁿ mꞌaⁿna ñomtiuu chiuu na cwii ꞌoomꞌaⁿyoona, ndoꞌ chiuu ya nleityandyetina. Joꞌ chii tileicanaⁿndyena na nlꞌana yuu na matsonaꞌ. Ee ñꞌomtiuuꞌñeeⁿ matseicuꞌnaꞌ na nlaꞌcanda̱na nnom Tyꞌo̱o̱tsꞌom chaꞌxjeⁿ lꞌa joo lꞌo̱o̱nioom na jlaꞌcantoꞌndyenaꞌ nacjooꞌ ntjom. ");
INSERT INTO amuNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Sa̱a̱ lqueeⁿ na tquiaa yuu na jeeⁿ ya tsꞌo mannꞌaⁿ na cwindye ñꞌoom naya. Cwilaꞌno̱ⁿꞌna juunaꞌ ndoꞌ cantyja na cwilꞌana cwiwitquiooꞌ na cwinaⁿndyena chiuu waa na matsonaꞌ. Ntꞌom naⁿꞌñeeⁿ tjacantyja na ya cwilꞌana. Matseijomnaꞌ joona chaꞌna cwii tsꞌoom lqueeⁿꞌñeeⁿ na tjeiꞌnaꞌ ñequiee xuu. Ndoꞌ ntꞌom naⁿꞌñeeⁿ xcweyandyo cwilꞌana yuu na ya. Matseijomnaꞌ joona chaꞌna cwii tsꞌoom lqueeⁿꞌñeeⁿ na tjeiꞌnaꞌ we xuu waljooꞌ xcwe. Ndoꞌ ntꞌom naⁿꞌñeeⁿ tiqueⁿndyena na cwilꞌana yuu na ya. Joꞌ chii matseijomnaꞌ joona chaꞌna cwii tsꞌoom lqueeⁿꞌñeeⁿ na tjeiꞌnaꞌ ñeꞌcwii xuu waljooꞌ yom tsꞌoom. ");
INSERT INTO amuNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ndoꞌ seineiⁿ Jesús cwiicheⁿ ñꞌoom tjañoomꞌ. Tsoom nda̱a̱na: —Juu na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom, matseijomnaꞌ juunaꞌ chaꞌna cwii tsꞌaⁿ na tja na waa tyuaaꞌ, tjacjoomꞌm lqueeⁿ tsjaaⁿ na ya. ");
INSERT INTO amuNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Sa̱a̱ cwii teijaaⁿ yocheⁿ na watsom ñequio nnꞌaⁿ waⁿꞌaⁿ tyjeꞌcañoom cwii tsꞌaⁿ na jndooꞌ jom. Tjatseiñꞌeeⁿꞌñe tsaⁿꞌñeeⁿ lqueeⁿ jnda̱a̱ quiiꞌntaaⁿ lqueeⁿ trigo. Jnda̱ chii tja. ");
INSERT INTO amuNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Tjawindye jnda̱ lqueeⁿ, tjaꞌmeiiⁿndyenaꞌ, quia joꞌ chii teitquiooꞌ na ñꞌeeⁿꞌ lqueeⁿ jnda̱a̱ naquiiꞌ ntjomꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Naⁿntjom ꞌnaaⁿꞌ tsaⁿꞌñeeⁿ tqueⁿna cwenta na nmeiiⁿꞌ niom. Tyꞌentyjaaꞌna jom, jluena nnoom: “Ta, aa nchii ñequiiꞌcheⁿ lqueeⁿ na ya tjaꞌcjuꞌ, quia joꞌ ¿chiuu na cwiwitquiooꞌ lqueeⁿ jnda̱a̱ quiiꞌntaaⁿ jnda̱ lqueeⁿ ꞌnaⁿꞌ?” ");
INSERT INTO amuNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Tꞌo̱o̱ⁿ nda̱a̱ naⁿꞌñeeⁿ, tsoom: “Tsꞌaⁿ na jndooꞌ ja sꞌaa na luaaꞌ.” Ndoꞌ taꞌxꞌee naⁿntjomꞌñeeⁿ nnoom: “¿Aa lꞌue tsꞌomꞌ na nntsaacatjeiiꞌndyô̱ joonaꞌ naquiiꞌ ntjom ꞌnaⁿꞌ?” ");
INSERT INTO amuNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Tꞌo̱o̱ⁿ nda̱a̱ naⁿntjoomꞌm, tsoom: “Tilꞌaꞌyoꞌ na ljoꞌ ee xeⁿ nntjeiiꞌndyoꞌ joonaꞌ, nntsꞌaacheⁿnaꞌ na mati nncꞌoomnaꞌ ntjom na ya. ");
INSERT INTO amuNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Caꞌndyeꞌyoꞌ na ñejom cꞌoowijnda̱naꞌ hasta na mmaⁿjndyeenaꞌ.” Quia joꞌ nntsjo̱o̱ nda̱a̱ nnꞌaⁿ na nntyje: “Catyjeꞌjndyeeꞌyoꞌ jnda̱ lqueeⁿ jnda̱a̱, calꞌaꞌyoꞌ cantsa̱a̱ꞌ joonaꞌ ee na nlconaꞌ. Nda̱nquia catyjeꞌyoꞌ jnda̱ lqueeⁿ na ya na nncꞌoocuenaꞌ tsꞌom tsa̱ꞌ ꞌnaⁿya.” ");
INSERT INTO amuNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Seineiⁿticheⁿ Jesús cwiicheⁿ ñꞌoom tjañoomꞌ na maꞌmo̱ⁿnaꞌ na maxjeⁿ nleijndyendyeti nnꞌaⁿ na nntsa̱ꞌntjom Tyꞌo̱o̱tsꞌom naquiiꞌ nꞌom. Tsoom nda̱a̱na: —Juu na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom matseijomnaꞌ chaꞌna cwii lqueeⁿꞌ mostaza. Tjatseicꞌoom tsꞌaⁿ juunaꞌ naquiiꞌ ntjoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Lqueeⁿꞌ mostaza jeeⁿ cajnda̱a̱naꞌ sa̱a̱ xeⁿ jnda̱ teijndeii tsꞌoom, nleindyenaꞌ, nncwinomꞌnaꞌ ntꞌom nꞌoom ntjom na tiquiwindye. Juunaꞌ nleitꞌmaⁿtinaꞌ hasta nnda̱a̱ nnaⁿ lꞌo̱ tsꞌoomꞌñeeⁿ cantquiaa cantsaa. ");
INSERT INTO amuNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jnda̱ chii cwiicheⁿ ñꞌoom tjañoomꞌ seineiⁿ Jesús nda̱a̱ naⁿꞌñeeⁿ, tsoom: —Juu na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom matseijomnaꞌ juunaꞌ chaꞌna ndaaljoꞌ na seitjoomꞌ yuscu ñꞌeⁿ ndyee tsuaꞌxjo jnda̱a̱ tyooꞌ. Seicandeiiꞌnaꞌ chaꞌwaa tsqueeⁿ tyooꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ñequiiꞌcheⁿ ñꞌoom tjañoomꞌ seineiⁿ Jesús na tyoꞌmo̱o̱ⁿ ñꞌoommeiⁿꞌ nda̱a̱ nnꞌaⁿ. Meiⁿcwii ñꞌoom tîcatseineiiⁿ nda̱a̱na na nchii ñꞌoom tjañoomꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Joꞌ chii seicanda̱a̱ꞌñenaꞌ ñꞌoom ꞌndyoo profeta, tsoom: Ja nntseina̱ⁿya ñꞌoom tjañoomꞌ nda̱a̱ nnꞌaⁿ. Nntseicano̱o̱ⁿya ñꞌoom na wantyꞌiuuꞌ mꞌaaⁿnaꞌ nda̱a̱ nnꞌaⁿ cantyjati na jnaⁿ tsjoomnancue. ");
INSERT INTO amuNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jnda̱ na jñom Jesús nnꞌaⁿ na cꞌoolcweeꞌna, quia joꞌ tjaqueⁿꞌeⁿ naquiiꞌ wꞌaa. Ndoꞌ jâ nnꞌaⁿ na cwilajomndyô̱ ñꞌeⁿñê santyjaaꞌâ jom. Lꞌuuyâ nnoom: —Catsuꞌ nda̱a̱yâ ljoꞌ ñeꞌcaꞌmo̱ⁿ ñꞌoom tjañoomꞌ cantyja ꞌnaaⁿꞌ lqueeⁿ jnda̱a̱ na tꞌoomnaꞌ naquiiꞌ ntjom na ya. ");
INSERT INTO amuNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Tꞌo̱o̱ⁿ nda̱a̱yâ, tsoom: —Tsꞌaⁿ na tjacjuꞌ lqueeⁿ tsjaaⁿ na ya, joꞌ joꞌ nnco̱ na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ndoꞌ tyuaa ꞌnaaⁿꞌ tsaⁿꞌñeeⁿ, joꞌ joꞌ tsjoomnancue. Lqueeⁿ tsjaaⁿ na ya, joꞌ joꞌ nnꞌaⁿ na cwilaꞌjomndye cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. Ndoꞌ lqueeⁿ tsjaaⁿ jnda̱a̱, joꞌ joꞌ nnꞌaⁿ na mꞌaⁿ cantyja ꞌnaaⁿꞌ tsaⁿjndii. ");
INSERT INTO amuNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Juu tsꞌaⁿ na wiꞌñe na tjatseiñꞌeeⁿꞌñe tsjaaⁿ lqueeⁿ jnda̱a̱, joꞌ joꞌ nquii tsaⁿjndii. Ndoꞌ xuee na jnda̱ tmaⁿ ntjom na tyꞌecatyje naⁿntjom, joꞌ joꞌ xuee na cwintycwii tsjoomnancue. Joo naⁿntjom na tyꞌecatyje lqueeⁿ, joꞌ joꞌ ángeles cwentaaꞌ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ndoꞌ chaꞌxjeⁿ lꞌa naⁿntjom cantsa̱a̱ꞌ jnda̱ lqueeⁿ jnda̱a̱ na nlconaꞌ quiiꞌ chom, maluaaꞌ matseijomnaꞌ na nluii xuee quia na cwintycwii tsjoomnancue. ");
INSERT INTO amuNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ee ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee njño̱o̱ⁿya ángeles cwentaya na nntjeiiꞌndyo̱na nnꞌaⁿ na wiꞌndye ñequio nnꞌaⁿ na cwilaꞌjndo̱ꞌ nꞌom ncꞌiaa na calꞌa naⁿꞌñeeⁿ natia. ");
INSERT INTO amuNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ndoꞌ ángeles nntueeꞌna naⁿꞌñeeⁿ naquiiꞌ chom bꞌio. Joꞌ joꞌ nndyuee naⁿꞌñeeⁿ ndoꞌ nnteinquiena ndeiꞌnꞌomna na wiꞌ cwitjoomna. ");
INSERT INTO amuNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Sa̱a̱ nnꞌaⁿ na cwilaꞌcanda̱a̱ꞌndye chaꞌxjeⁿ na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom, ntsꞌaanaꞌ na caxueendyena chaꞌna xuee nnom ñeꞌquioomꞌ. ꞌÑeeⁿ juu na niom lueꞌ nꞌom luaꞌqui na nndii, candii. ");
INSERT INTO amuNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","’Juu na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom matseijomnaꞌ chaꞌna castom na ñjom sꞌom cajaⁿ na wantyꞌiunaꞌ quiiꞌ tyuaa. Ljeii cwii tsꞌaⁿ castomꞌñeeⁿ sa̱a̱ tantyꞌiunnaaⁿꞌaⁿ juunaꞌ. Tjaaⁿ na jeeⁿ neiiⁿꞌeⁿ, tjacajna̱a̱ⁿ chaꞌtso ꞌnaaⁿꞌaⁿ na niom. Jnda̱ chii seijnaaⁿ tyuaaꞌñeeⁿ yuu na ndiiꞌ castom. ");
INSERT INTO amuNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","’Juu na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom mati matseijomnaꞌ chaꞌna cwii tsꞌaⁿ na matseijnda ndoꞌ majnda̱a̱ ta̱ꞌ na ñequiiꞌcheⁿ malꞌueeⁿ ta̱ꞌ perlas na yati. ");
INSERT INTO amuNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Quia na ljeiiⁿ cwii ta̱ꞌ perla na jeeⁿcheⁿ ndyaaꞌ ya ndoꞌ jndanaꞌ, tja tsaⁿꞌñeeⁿ tjacajna̱a̱ⁿ chaꞌtso ꞌnaaⁿꞌaⁿ, jnda̱ chii seijnaaⁿ ta̱ꞌ perlaꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","’Juu na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom mati matseijomnaꞌ chaꞌna cwii tsquiꞌ tꞌmaⁿ na tueeꞌ nnꞌaⁿ tsꞌom ndaaluee. Jndye nnom calcaa matseitꞌuenaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Quia na jnda̱ tooꞌ tsquiꞌ na ñjomndye calcaa, ꞌoocantyjaandye nnꞌaⁿ juunaꞌ tyuaatcwii. Meindyuaandyena, cwitjeiiꞌndyena calcaa na yati. Cwitioomna jooyoꞌ nꞌom lquiee sa̱a̱ calcaa na cwantindyo cwityeⁿꞌquieeꞌna jooyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Malaaꞌtiꞌ nntsꞌaanaꞌ xuee quia na cwintycwii tsjoomnancue. Nñequiocue ángeles na nntjeiiꞌndyena nnꞌaⁿ na wiꞌndye quiiꞌntaaⁿ nnꞌaⁿ na mꞌaⁿ cantyja na matyꞌiomyanaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ndoꞌ nntioomna nnꞌaⁿ na wiꞌndye naquiiꞌ chom bꞌio. Joꞌ joꞌ nndyuee naⁿꞌñeeⁿ ndoꞌ nnteinquiena ndeiꞌnꞌomna na wiꞌ cwitjoomna. ");
INSERT INTO amuNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Quia joꞌ taxꞌee Jesús nda̱a̱ jâ nnꞌaⁿ na cwilaꞌjomndyô̱ ñꞌeⁿñê, tsoom: —¿Aa cwilaꞌno̱ⁿꞌyoꞌ chaꞌtso ñꞌoommeiⁿꞌ? Tꞌo̱o̱yâ nnoom, lꞌuuyâ: —Mayuuꞌ, Ta, macwilaꞌno̱o̱ⁿꞌâ. ");
INSERT INTO amuNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Quia joꞌ tsoom nda̱a̱yâ: —Jeꞌ jnda̱ jlaꞌno̱ⁿꞌyoꞌ ljoꞌ ñeꞌcatꞌmo̱o̱ⁿ ñꞌoom tjañoomꞌmeiⁿꞌ. Nndyeꞌyoꞌ nntsjo̱o̱, ticwii cwii tsꞌaⁿ na jnda̱ teijndo̱ꞌ tsꞌom chiuu tꞌmaⁿ ljeii na tqueⁿ Moisés ndoꞌ mati jnda̱ seiꞌno̱ⁿꞌ cantyja ꞌnaaⁿꞌ juu na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom, tsaⁿꞌñeeⁿ matseijomnaꞌ jom chaꞌna tsꞌaⁿ na cwiluiitquieñe cwii wꞌaa. Ee tsꞌaⁿ na cwiluiitquieñe matseilꞌueeꞌñê ꞌnaⁿ na tquie ndoꞌ matseitjoom ꞌnaⁿ na xco. Quia joꞌ meiⁿquia xjeⁿ na macaⁿnaꞌ cwii nmeiⁿꞌ mawaacꞌeenaꞌ na nleilꞌueeꞌñê. ");
INSERT INTO amuNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Quia na jnda̱ seineiⁿ Jesús ñꞌoommeiⁿꞌ na tjañoomꞌ, jlueeⁿꞌeⁿ joꞌ joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Tjalcweeⁿꞌeⁿ ndyuaa tsjomꞌm. Joꞌ joꞌ tyotseineiiⁿ nda̱a̱ nnꞌaⁿ naquiiꞌ watsꞌom. Ndoꞌ chaꞌtsondye nnꞌaⁿ jeeⁿ tjaweeꞌ nꞌomna ñꞌoom na seineiiⁿ. Tyoluena: —Tsaⁿmꞌaaⁿꞌ ¿chiuu sꞌaayom na jeeⁿ jndo̱ꞌ tsꞌoom? Ndoꞌ ¿yuu jnaⁿ najneiⁿ na machꞌeeⁿ tsꞌiaaⁿ tꞌmaⁿ na tyoontyꞌiaaya? ");
INSERT INTO amuNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Aa nchii tsaⁿmꞌaaⁿꞌ jnda tsꞌaⁿ na macuuñe nꞌoom? Ndoꞌ ¿aa nchii tsoñeeⁿ jndyu María? Ndoꞌ ntyjeeⁿ, ¿aa nchii Jacobo, José, Simón ñequio Judas? ");
INSERT INTO amuNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ndoꞌ mati ntyjeeⁿ na yolcu mꞌaⁿna quiiꞌntaaⁿya. Quia joꞌ ¿chiuu waa na jeeⁿ jndo̱ꞌ tsꞌoom ndoꞌ cweꞌ tsꞌaⁿ tsjoom ñjaaⁿ jom? ");
INSERT INTO amuNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Cweꞌ joꞌ ticalañꞌoomꞌndyena Jesús. Joꞌ chii tsoom nda̱a̱na: —Meiⁿquiayuucheⁿ na wjaa cwii profeta, nlaꞌtꞌmaaⁿꞌndye nnꞌaⁿ jom. Sa̱a̱ joo nnꞌaⁿ ndyuaaⁿꞌaⁿ ñequio nnꞌaⁿ waⁿꞌaⁿ, xocalaꞌtꞌmaaⁿꞌndyena jom. ");
INSERT INTO amuNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ndoꞌ tijndye tsꞌiaaⁿ tꞌmaⁿ sꞌaaⁿ joꞌ joꞌ, ncꞌe na ticalaꞌyuꞌ naⁿꞌñeeⁿ ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Majoo ncueeꞌñeeⁿ tyomꞌaaⁿ Herodes tsꞌiaaⁿ tsꞌo̱ndaa Galilea. Jñeeⁿ ñꞌoom cantyja ꞌnaaⁿꞌ jndye nnom tsꞌiaaⁿ tꞌmaⁿ na machꞌee Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Tsoom nda̱a̱ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê: —Tsaⁿmꞌaaⁿ, maxjeⁿ Juan, tsꞌaⁿ na tyotseitsꞌoomñe nnꞌaⁿ. Jnda̱ wandoꞌxcoom joꞌ chii cwiwitquiooꞌ tsꞌiaaⁿ tꞌmaⁿ na machꞌeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Ee luaa waa na tuii. Herodes tyomꞌaaⁿ ñequio Herodías, scuuꞌ tyjeeⁿ Felipe. Ndoꞌ tso Juan nnoom na ticatyꞌiomyanaꞌ na mꞌaaⁿ ñꞌeⁿ scuuꞌ tyjeeⁿ. Joꞌ chii sa̱ꞌntjoom na calaꞌtyeⁿna Juan, catueeꞌna juu wꞌaancjo. ");
INSERT INTO amuNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ndoꞌ Herodes, meiiⁿ na ñeꞌcatseicueⁿꞌeⁿ Juan sa̱a̱ nquiaⁿꞌaⁿ nnꞌaⁿ. Ee jndye nnꞌaⁿ nquiuna na Juan cwiluiiñe tsꞌaⁿ na mañequiaa ñꞌoomꞌ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Quia na jlaꞌtꞌmaaⁿꞌndye nnꞌaⁿ na tueeꞌ xueechuuꞌ Herodes, quia joꞌ yuscundyua jnda Herodías seijnom jo nda̱a̱ nnꞌaⁿ. Ndoꞌ Herodes jeeⁿ tjaweeꞌ tsꞌoom cantyja na ntyꞌiaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Tjoomꞌm ñꞌomtyeⁿ cjoomꞌm na tsoom nnom yuscundyuaꞌñeeⁿ na nñequiaaⁿ meiⁿquia ljoꞌ na nlcaⁿ nnoom. ");
INSERT INTO amuNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ndoꞌ yuscundyuaꞌñeeⁿ seijndo̱ꞌ tsoñeeⁿ tsꞌoom na caaⁿ xqueⁿ Juan. Quia joꞌ tsoom nnom Herodes: —Luaa macaⁿꞌa. Quiaaꞌ cwii xio ñjaaⁿ na njom xqueⁿ Juan, tsaⁿ na ñeseitsꞌoomñe nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ndoꞌ na luaaꞌ tsoom, seichjooꞌnaꞌ tsꞌom Herodes, sa̱a̱ cweꞌ ncꞌe ñꞌomtyeⁿ na tjoomꞌm nacjoomꞌm ndoꞌ ncꞌe na ndyecheⁿ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê, joꞌ chii tsoom na quiana ljoꞌ na macaⁿ yuscundyuaꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Quia joꞌ sa̱ꞌntjoom na cjaacano̱ⁿ xtyoꞌ Juan naquiiꞌ wꞌaancjo. ");
INSERT INTO amuNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Jnda̱ tuii na ljoꞌ, jndyoñꞌoom tsꞌaⁿ xqueⁿ Juan na njomnaꞌ tsꞌom xio. Chii tquiaa juunaꞌ nnom yuscundyuaꞌñeeⁿ ndoꞌ jom tjañꞌoom joꞌ na mꞌaaⁿ tsoñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jnda̱ joꞌ nnꞌaⁿ na cwilaꞌjomndye ñꞌoom na tyoñequiaa Juan tquieꞌcañomna, tyꞌeñꞌomna seiꞌtsꞌo ꞌnaaⁿꞌaⁿ. Tyꞌecatyꞌiuuna jom, jnda̱ chii tyꞌelaꞌcandiina Jesús ñꞌoommeiⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jnda̱ na jndii Jesús na jnda̱ tueꞌ Juan, jlueeⁿꞌeⁿ joꞌ, tuo̱o̱ⁿ tsꞌom wꞌaandaa ñꞌeⁿ jâ nnꞌaⁿ na cwilaꞌjomndyô̱ ñꞌeⁿñê. Saayâ cwii joo yuu na tjaaꞌnaⁿ nnꞌaⁿ. Quia jliu nnꞌaⁿ na jnda̱ tja Jesús na nncwityꞌioom ndaaluee, quia joꞌ jluiꞌna njoomna, tyꞌecaꞌna, tyꞌenquiandyena ꞌndyoo ndaaluee na tyꞌentyjo̱na naxeeⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Quia na jnda̱ jluiiꞌñe wꞌaandaa tsꞌom ndaaluee, ljeii Jesús na teijndyendye nnꞌaⁿ jnda̱ tquieꞌcañom joꞌ joꞌ. Tioo na jeeⁿ wiꞌ tsꞌoom joona. Seinꞌmaaⁿ nnꞌaⁿwii na tquiochona. ");
INSERT INTO amuNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Quia na jnda̱ tmaaⁿ, jâ nnꞌaⁿ na cwilaꞌjomndyô̱ ñꞌeⁿñê saantyjaaꞌâ jom, lꞌuuyâ nnoom: —Jnda̱ tmaaⁿ jeꞌ ndoꞌ yuu na mꞌaaⁿya ñjaaⁿñe cweꞌ jnda̱a̱. Cajñomꞌ naⁿmꞌaⁿꞌ na cꞌoona njoom nchꞌu na nndyooꞌ na nlaꞌjndana na nlcwaꞌna. ");
INSERT INTO amuNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Tso Jesús nda̱a̱yâ: —Meiⁿ ticaⁿnaꞌ na nncꞌoona. ꞌO quiaꞌyoꞌ na nlcwaꞌna. ");
INSERT INTO amuNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Tꞌo̱o̱yâ nnoom, lꞌuuyâ: —Tjaaꞌnaⁿ na cwileiꞌñꞌo̱o̱ⁿyâ ñjaaⁿ, macanda̱ ñeꞌom taⁿꞌ tyooꞌ ñequio we catscaa. ");
INSERT INTO amuNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Tsoom nda̱a̱yâ: —Quiochoꞌyoꞌ joonaꞌ ñjaaⁿñe. ");
INSERT INTO amuNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Sa̱ꞌntjoom na cwindyuaandye nnꞌaⁿ nacjooꞌ jnda̱ nchꞌu. Quia joꞌ tꞌueeⁿ ꞌom taⁿꞌ tyooꞌ ñequio we catscaaꞌñeeⁿ, ntyꞌiaaⁿꞌaⁿ cañoomꞌluee ndoꞌ tquiaaⁿ na quianlꞌuaaꞌ Tyꞌo̱o̱tsꞌom cantyja ꞌnaaⁿ joonaꞌ. Jnda̱ chii tyjeeⁿ ndoꞌ tquiaaⁿ joonaꞌ nda̱a̱ jâ nnꞌaⁿ na cwilaꞌjomndyô̱ ñꞌeⁿñê. Ndoꞌ jâ tquiaayâ joonaꞌ nda̱a̱ nnꞌaⁿ na jndyendye. ");
INSERT INTO amuNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ndoꞌ chaꞌtsondye nnꞌaⁿ na jndyendye tcwaꞌ tjacjoo. Jnda̱ chii jlaꞌtjo̱o̱ⁿyâ ntaⁿꞌ ntyooꞌ ñequio calcaa na ꞌndiinaꞌ. Tooꞌ canchooꞌwe tsquiee. ");
INSERT INTO amuNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nnꞌaⁿ na tcwaꞌ tueꞌntyjo̱ chaꞌna ꞌom meiⁿ naⁿnom, meiⁿ tîcatuꞌnchondye naⁿlcu ñequio yocanchꞌu. ");
INSERT INTO amuNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jnda̱ tuii na luaaꞌ jñom Jesús jâ nnꞌaⁿ na cwilaꞌjomndyô̱ ñꞌeⁿñê na cuo̱nndaaꞌâ tsꞌom wꞌaandaa, na cwityꞌio̱o̱ꞌjndya̱a̱yâ na nntsquia̱a̱yâ xndyaaꞌ ndaaluee. Sa̱a̱ jom ljooꞌñetyeeⁿ na njñoom nnꞌaⁿ na jndyendye. ");
INSERT INTO amuNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ndoꞌ jnda̱ na jñoom naⁿꞌñeeⁿ na cꞌoolcweeꞌna, quia joꞌ tjawaaⁿ cwii ta na ñenqueⁿ na nntseineiiⁿ nnom Tyꞌo̱o̱tsꞌom. Quia tjawijaaⁿ ndicwaⁿ mꞌaaⁿñê joꞌ joꞌ na ñenqueⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ndoꞌ wꞌaandaa na ñjomndyô̱ jnda̱ tueeꞌ xcwe na wjaanaꞌ sa̱a̱ leicjaanaꞌ ee na jndeii maquiꞌljoo nmo̱ⁿ ndoꞌ matseilcweꞌtyaꞌ jndye juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Sꞌaanaꞌ chaꞌna ñequiee na cwitsjoom jndyotseicandyooꞌñe Jesús na mꞌaaⁿyâ, jndyocaⁿ nnom ndaaluee. ");
INSERT INTO amuNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Quia na ntyꞌiaayâ na mandyocaⁿ nnoom ndaaluee, jeeⁿ ndyaaꞌ tyua̱a̱yâ. Jlaxuaayâ na nquiaayâ, lꞌuuyâ: —Jeeⁿ sa, jndii luaaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Sa̱a̱ mañoomꞌ tꞌmaⁿ Jesús jâ, tsoom: —Cꞌomꞌ tꞌmaaⁿꞌndyoꞌ nꞌomꞌyoꞌ. Maja luaa. ");
INSERT INTO amuNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ndoꞌ tꞌo̱ Pedro ꞌndyoo Jesús, tsoom: —Ta, xeⁿ na manncuꞌtiꞌ, cweꞌ catsuꞌ na cjo̱ca nnom ndaatioo na jo̱catjomndyo̱ ꞌu. ");
INSERT INTO amuNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Tso Jesús nnoom: —Candyoꞌ. Joꞌ chii jluiꞌ Pedro tsꞌom wꞌaandaa, to̱o̱ⁿꞌo̱ⁿ na mawjaacaⁿ nnom ndaatioo na mawjaacatjomñê Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Sa̱a̱ quia na ntyꞌiaaⁿꞌaⁿ na jeeⁿ jndeii mꞌaaⁿ jndye, sꞌaanaꞌ na nquiaⁿꞌaⁿ. Jnaⁿnaꞌ na nchjeeñenaꞌ jom. Quia joꞌ seixuaⁿ, tsoom: —Ta, cwjiꞌnꞌmaaⁿndyuꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Mañoomꞌ seicjaa lꞌo̱ Jesús jom, tsoom nnom: —ꞌU re, cwa titꞌmaⁿ matseiꞌyuꞌyaꞌ tsꞌomꞌ, ¿chiuu na tiñecwii matseiꞌtiuuꞌ? ");
INSERT INTO amuNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ndoꞌ quia jnda̱ tuo̱na tsꞌom wꞌaandaa, mañoomꞌ teicheⁿ jndye. ");
INSERT INTO amuNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ndoꞌ jâ na maxjeⁿ ñjomndyô̱ tsꞌom wꞌaandaaꞌñeeⁿ taaꞌâ cantya̱a̱yâ, jlaꞌtꞌmaaⁿꞌndyô̱ jom. Lꞌuuyâ nnoom: —ꞌU mayuuꞌcheⁿ cwiluiindyuꞌ Jnda Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Quia na jnda̱ teiꞌtyꞌio̱o̱ꞌâ, jluiiꞌâ ndyuaa Genesaret. ");
INSERT INTO amuNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Jnda̱ na taꞌjnaaⁿꞌ nnꞌaⁿ ndyuaaꞌñeeⁿ jom, jlaꞌcwanomna ñꞌoom chaꞌwaa ndiocheⁿ ndyuaaꞌñeeⁿ. Ndoꞌ tquiocho nnꞌaⁿ chaꞌtso nnꞌaⁿwii na mꞌaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Tyolaꞌtyꞌoondyena nnoom na nñequiaaⁿ ñꞌoomꞌm na nntꞌuena meiiⁿ cweꞌ ꞌndyoo liaⁿꞌaⁿ. Ee ticwii cwii tsꞌaⁿ na tyenquiuuꞌ liaⁿꞌaⁿ, nꞌmaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Quia joꞌ cwanti nnꞌaⁿ fariseos ñequio nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés, jnaⁿna Jerusalén, tquieꞌcañomna Jesús. Taꞌxꞌeena nnoom: ");
INSERT INTO amuNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Nnꞌaⁿ na cwilaꞌjomndye ñꞌoom na mañequiaaꞌ, ¿chiuu na cwiwincjeꞌna ñꞌoom na tqueⁿ welooya nda̱a̱ya? Queⁿꞌ cwenta tiquindyuuꞌna quia na nlcwaꞌna. ");
INSERT INTO amuNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ndoꞌ tꞌo̱ Jesús nda̱a̱na, tsoom: —Ndoꞌ ꞌo jeꞌ, ¿chiuu na cwiwincjeꞌyoꞌ ñꞌoom na sa̱ꞌntjom Tyꞌo̱o̱tsꞌom cweꞌ ñeꞌcatsantyjo̱ꞌyoꞌ ñꞌoom na tqueⁿ lotya̱a̱ya? ");
INSERT INTO amuNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ee ñꞌoomꞌ Tyꞌo̱o̱tsꞌom luaa matsonaꞌ: “Catseitꞌmaaⁿꞌndyuꞌ tsotyeꞌ ñꞌeⁿ tsoꞌndyoꞌ.” Ndoꞌ matsotinaꞌ: “ꞌÑeeⁿ juu na matso ñꞌoom wiꞌ nacjooꞌ tsotye, tsondyee tsaⁿꞌñeeⁿ matsonaꞌ na maxjeⁿ calaꞌcueeꞌ nnꞌaⁿ juu.” ");
INSERT INTO amuNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Sa̱a̱ ꞌo cwinduꞌyoꞌyoꞌ na wanaaⁿ na nntso tsꞌaⁿ nnom tsotyeeⁿ, tsoñeeⁿ: “Catseitꞌmaⁿ tsꞌomꞌ, taxocanda̱a̱ nnteijndeiya ꞌu ꞌnaⁿ na tjo̱o̱ndyuꞌ, ee chaꞌtso na matseixmaⁿya jnda̱ tqua̱a̱ⁿya joonaꞌ cwentaaꞌ Tyꞌo̱o̱tsꞌom.” ");
INSERT INTO amuNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ndoꞌ na luaaꞌ cwilaꞌtiuuꞌyoꞌ joꞌ chii cwitꞌmo̱ⁿꞌyoꞌ tacaⁿnaꞌ na nntseitꞌmaaⁿꞌñe tsꞌaⁿ tsotyeeⁿ, tsoñeeⁿ. Cwilꞌaꞌyoꞌ na tajndeii ñꞌoomꞌ Tyꞌo̱o̱tsꞌom ee na cwilaꞌtꞌmaaⁿꞌndyoꞌtiꞌyoꞌ ñꞌoom na tqueⁿ lotyeꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ꞌO nnꞌaⁿ na we waa na cwilꞌaꞌyoꞌ, jeeⁿ xcwe mꞌaaⁿ ñꞌoom na tyoñequiaa profeta Isaías cantyja ꞌnaⁿꞌyoꞌ. Luaa matsonaꞌ: ");
INSERT INTO amuNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Naⁿmꞌaⁿꞌ cweꞌ ñequio ntjaⁿndyueena cwilaꞌtꞌmaaⁿꞌndyena ja, sa̱a̱ tꞌmaⁿ waa na tixcweeꞌ nꞌomna ñꞌeⁿndyo̱. ");
INSERT INTO amuNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Cweꞌ tsꞌiaaⁿꞌndyo na cwilaꞌtꞌmaaⁿꞌndyena ja, ee cwitꞌmo̱o̱ⁿna ñꞌoom na cweꞌ cwilꞌueendye nnꞌaⁿ, tachii ñꞌoomya. ");
INSERT INTO amuNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Quia joꞌ tꞌmaⁿ Jesús nnꞌaⁿ na jndyendye, tsoom: —Candyeꞌyoꞌ ñꞌoom na nntsjo̱o̱ ndoꞌ calaꞌno̱ⁿꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Nantquie na macwaꞌ tsꞌaⁿ, xocatsꞌaanaꞌ na tilꞌueñe tsꞌaⁿ jo nnom Tyꞌo̱o̱tsꞌom. Sa̱a̱ ñꞌoom na matseineiⁿ tsꞌaⁿ, joonaꞌ cwilꞌanaꞌ na tilꞌueñe tsꞌaⁿ jo nnom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Quia joꞌ jâ nnꞌaⁿ na cwilaꞌjomndyô̱ ñꞌeⁿ Jesús, saantyjaaꞌâ jom, lꞌuuyâ nnoom: —¿Aa ntyjiꞌ quia na jndye nnꞌaⁿ fariseos ñꞌoom na tsuꞌ luaaꞌ, sꞌaanaꞌ na ticjaaweeꞌ nꞌomna? ");
INSERT INTO amuNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Tꞌo̱o̱ⁿ nda̱a̱yâ cwii ñꞌoom tjañoomꞌ, tsoom: —Tsotya̱ya na mꞌaaⁿ cañoomꞌluee, ticwii cwii tsꞌoom ntjom na nchii nqueⁿ tcoomꞌm, maxjeⁿ nnqueeⁿ juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Joꞌ chii caꞌndyeꞌyoꞌ naⁿmꞌaⁿꞌ. Ee matseijomnaꞌ joona chaꞌna naⁿnchjaaⁿ na cwitꞌmo̱o̱ⁿna nato nda̱a̱ ntyjenchjaaⁿna. Ndoꞌ manquiuꞌyoꞌ tsaⁿnchjaaⁿꞌ quia na wjaañꞌoom tyjenchjaaⁿꞌaⁿ, wendyena nntiomnaꞌ tsueꞌtsjoom. ");
INSERT INTO amuNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Quia joꞌ tso Pedro nnom Jesús: —Caꞌmo̱ⁿꞌ nda̱a̱yâ ljoꞌ ñecatso ñꞌoom tjañoomꞌwaaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Tꞌo̱ Jesús nnom, matsoom: —¿Aa mati ꞌo ndicwaⁿ tjo̱o̱cheⁿ na nlaꞌno̱ⁿꞌyoꞌ? ");
INSERT INTO amuNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Aa ticaliuꞌyoꞌ na chaꞌtso nantquie na macwaꞌ tsꞌaⁿ, cwiꞌoocuenaꞌ tsꞌom tsiaaꞌ nchii naquiiꞌ tsꞌom. Ndoꞌ jnda̱ chii nnteiiꞌ juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Sa̱a̱ ñꞌoom na matseineiⁿ tsꞌaⁿ cwinaaⁿꞌ naquiiꞌ tsꞌom, ndoꞌ joonaꞌ cwilꞌanaꞌ na tiljuꞌñe jo nnom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ee naquiiꞌ tsꞌom tsꞌaⁿ cwinaaⁿꞌ ñꞌoom na tia na matseitiuu na nntseicueⁿꞌeⁿ xꞌiaaⁿꞌaⁿ, na nncꞌoomyaaⁿ ñequio cwiicheⁿ tsꞌaⁿ, oo na nncꞌoomyaaⁿ ñequio sꞌandyua oo scundyua, oo na nnchꞌueeⁿ ꞌnaaⁿꞌ tsꞌaⁿ, oo na nntseineiiⁿ cantu oo ñꞌoom jnaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Chaꞌtso nmeiⁿꞌ cwilꞌanaꞌ na tiljuꞌ naquiiꞌ tsꞌom tsꞌaⁿ jo nnom Tyꞌo̱o̱tsꞌom. Sa̱a̱ na nlcwaꞌ tsꞌaⁿ na cweꞌ na ticañoomꞌm chaꞌxjeⁿ ñꞌoom na cwiqueⁿ nnꞌaⁿ fariseos, xocatseiꞌndaaꞌnaꞌ jom jo nnom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Quia joꞌ jluiꞌ Jesús joꞌ joꞌ ndi ñꞌa̱a̱ⁿyâ ñꞌeⁿñê, tjaaⁿ jo ndyuaa tsjoom Tiro ñꞌeⁿ Sidón. ");
INSERT INTO amuNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ndoꞌ cwii yuscu tsjaaⁿ nnꞌaⁿ cananita na macꞌeⁿ ndyuaaꞌñeeⁿ jndyotseicandyooꞌñê na mꞌaaⁿ Jesús, cꞌuaa seineiiⁿ, seityꞌooñê tsoom: —ꞌU Ta, na cwiluiindyuꞌ tsjaaⁿ David na jndyowicantyjooꞌ, cꞌoomꞌ na wiꞌ tsꞌomꞌ ñꞌeⁿndyo̱. Mꞌaaⁿ nomjndaaya na jeeⁿ cwajndii matjoom. Maleiñꞌoom jndyetia jom. ");
INSERT INTO amuNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Sa̱a̱ Jesús meiⁿcwii ñꞌoom ticꞌo̱o̱ⁿ. Quia joꞌ jâ saantyjaaꞌâ jom, jlaꞌtyꞌoondyô̱ nnoom, lꞌuuyâ: —Cwa cajñomꞌ yuscumꞌaaⁿꞌ, ee jeeⁿ cꞌuaa ꞌñom ndyontyjo̱o̱ⁿ nanqua̱a̱ⁿꞌa. ");
INSERT INTO amuNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Quia joꞌ tso Jesús: —Macanda̱ na mꞌaⁿ nnꞌaⁿ ndyuaa Israel na jñom Tyꞌo̱o̱tsꞌom ja. Ee joona cwiluiindyena chaꞌcwijom canmaⁿ na jnda̱ tsuundye. ");
INSERT INTO amuNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ndoꞌ tyjeꞌcañoom yuscuꞌñeeⁿ jom, tcoꞌ xtye jo nnoom, tso: —Jeeⁿ ꞌu Ta, cateijndeiꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Sa̱a̱ tꞌo̱o̱ⁿ nnom yuscuꞌñeeⁿ, tsoom: —Ticatsonaꞌ na nncwjiꞌ tsꞌaⁿ tyooꞌ cwentaa yocanchꞌu ndoꞌ nncjuꞌyom juunaꞌ nda̱a̱ calueꞌ nchꞌu. ");
INSERT INTO amuNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Tso yuscuꞌñeeⁿ nnoom: —Mayuuꞌ Ta, sa̱a̱ meiiⁿ na ljoꞌ, cwicwaꞌ calueꞌ nchꞌu nacajnda̱a̱ na cwiquiaa nacjeeꞌ meiⁿsa ꞌnaaⁿꞌ ntyꞌoyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Quia joꞌ tꞌo̱o̱ⁿ nnom yuscuꞌñeeⁿ, tsoom: —ꞌU yuscu, tꞌmaⁿ waa na matseiꞌyuꞌyaꞌ tsꞌomꞌ. Catsꞌaanaꞌ chaꞌxjeⁿ na lꞌue tsꞌomꞌ. Ndoꞌ xjeⁿꞌñeeⁿ mañoomꞌ nꞌmaⁿ nomjnda yuscuꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jnda̱ jluiꞌ Jesús joꞌ joꞌ ndi ñꞌa̱a̱ⁿyâ ñꞌeⁿñê, tjaaⁿ ꞌndyoo ꞌndyoo ndaaluee Galilea. Tjawaaⁿ cwii ta, tjacjom joꞌ joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ndoꞌ tquieꞌcañom jndyendye nnꞌaⁿ na mꞌaaⁿ. Tquiochona ntꞌom nnꞌaⁿ na ntjeiⁿ ncꞌeeꞌ, nnꞌaⁿ nchjaaⁿ, nnꞌaⁿ na tileicalaꞌneiⁿ, nnꞌaⁿ na ticanda̱a̱ꞌndye ndoꞌ ñequio jndye ntꞌomcheⁿ nnꞌaⁿwii. Tyotsa̱ꞌna nnꞌaⁿwiiꞌñeeⁿ nacañoomꞌ Jesús, ndoꞌ seinꞌmaaⁿ naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Jndyendye nnꞌaⁿ ntyꞌiaana na cwilaꞌneiⁿ nnꞌaⁿ na tileicalaꞌneiⁿ, ndoꞌ tcoꞌyanaꞌ nnꞌaⁿ na ticanda̱a̱ꞌndye, ndoꞌ cwiꞌoocaꞌ nnꞌaⁿ na ntjeiⁿ ncꞌeeꞌ, ndoꞌ ya cwintyꞌiaa nnꞌaⁿ na nchjaaⁿ. Joꞌ chii sꞌaanaꞌ na jeeⁿ tjaweeꞌ nꞌomna. To̱ꞌna na tyolaꞌtꞌmaaⁿꞌndyena nquii Tyꞌo̱o̱tsꞌom na cwilaꞌtꞌmaaⁿꞌndye nnꞌaⁿ Israel. ");
INSERT INTO amuNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Quia joꞌ tꞌmaⁿ Jesús jâ nnꞌaⁿ na cwilaꞌjomndyô̱ ñꞌeⁿñê. Tsoom nda̱a̱yâ: —Jeeⁿ wiꞌ tsꞌo̱o̱ⁿya tmaaⁿꞌ nnꞌaⁿmꞌaⁿꞌ, ee jnda̱ ndyee xuee na mꞌaⁿna ñꞌeⁿndyo̱ ndoꞌ tatjaaꞌnaⁿ ljoꞌ cwii cwileiꞌñꞌomtina na nlcwaꞌna. Ticalꞌue tsꞌo̱o̱ⁿ na njño̱o̱ⁿ joona na cꞌoona lꞌaana na ñeꞌjndoꞌna, tintsꞌaanaꞌ na tajndeiiꞌ nꞌomna na ꞌoona nato. ");
INSERT INTO amuNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Quia joꞌ lꞌuuyâ nnoom: —Ñjaaⁿñe mꞌaaⁿya jo jnda̱a̱ tjaaꞌnaⁿ yuu ya nliuuyâ nantquie na jndye na nnda̱a̱ꞌ nncjaacjoo nnꞌaⁿ na jndyendye. ");
INSERT INTO amuNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Taxꞌee Jesús nda̱a̱yâ: —¿Cwanti tyooꞌ cwileiꞌñꞌomꞌyoꞌ? Tꞌo̱o̱yâ nnoom, lꞌuuyâ: —Ntquieeꞌ taⁿꞌ tyooꞌ ndoꞌ ñꞌeⁿ cwantindye calcaa nchꞌu. ");
INSERT INTO amuNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Quia joꞌ sa̱ꞌntjoom na cwindyuaandye nnꞌaⁿ nomtyuaa. ");
INSERT INTO amuNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Toꞌñoom ntyooꞌñeeⁿ ñequio calcaa ndoꞌ tquiaaⁿ na quianlꞌuaaꞌ Tyꞌo̱o̱tsꞌom cantyja ꞌnaaⁿnaꞌ. Jnda̱ joꞌ tyjeeⁿ ndoꞌ tquiaaⁿ joonaꞌ nda̱a̱yâ na cwilaꞌjomndyô̱ ñꞌeⁿñê. Ndoꞌ jâ tꞌo̱o̱ⁿyâ joonaꞌ nda̱a̱ chaꞌtsondye nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Chaꞌtsondye naⁿꞌñeeⁿ tcwaꞌtjacjoona. Ndoꞌ jlaꞌcato̱o̱ꞌâ ntquieeꞌ tsquiee ñequio ntaⁿꞌ ntyooꞌ ñequio calcaa na ꞌndiicheⁿnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nnꞌaⁿ na tcwaꞌ quia joꞌ tueeꞌ chaꞌna ñequiee meiⁿ naⁿnom. Meiⁿ tîcatuꞌnchondye naⁿlcu ñequio yocanchꞌu. ");
INSERT INTO amuNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Quia na jnda̱ tꞌmaⁿ Jesús nnꞌaⁿ ee mana cwito̱ⁿꞌndyena, quia joꞌ tuo̱o̱ⁿ tsꞌom wꞌaandaa. Saayâ, squia̱a̱yâ ndyuaa Magdala. ");
INSERT INTO amuNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Nnꞌaⁿ fariseos ñequio nnꞌaⁿ saduceos tquieꞌcañomna na mꞌaaⁿ Jesús. Ñeꞌcalꞌana xjeⁿ jom, joꞌ na taⁿna nnoom na catsꞌaaⁿ cwii ꞌnaaⁿ na nntyꞌiaana na mꞌmo̱o̱ⁿnaꞌ na Tyꞌo̱o̱tsꞌom jñom jom. ");
INSERT INTO amuNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Sa̱a̱ tꞌo̱ Jesús nda̱a̱ naⁿꞌñeeⁿ, tsoom: —Quia na jnda̱ tmaaⁿ cwintyꞌiaꞌyoꞌ na jeeⁿ tmaaⁿ nchquiu, cwinduꞌyoꞌ: “Matseinmaaⁿñeyanaꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ndoꞌ quia na cwitsjoom cwintyꞌiaꞌyoꞌ na jeeⁿ neiⁿncooꞌ nchquiu ꞌndaa, cwinduꞌyoꞌ: “Jeꞌ maxjeⁿ nncuaꞌ.” ꞌO nnꞌaⁿ na tiñecwii mꞌaaⁿꞌ nꞌomꞌyoꞌ, jeeⁿ ya cwilaꞌnoⁿꞌyoꞌ ꞌnaaⁿ na cwitꞌmo̱o̱ⁿ nchquiu na mꞌaⁿ tsjo̱ꞌluee sa̱a̱ tileicalaꞌno̱ⁿꞌyoꞌ ljoꞌ cwii ndyochꞌeetinaꞌ cantyja na cwitꞌmo̱o̱ⁿ tsꞌiaaⁿ tꞌmaⁿ na cwintyꞌiaꞌyoꞌ na matsꞌaa. ");
INSERT INTO amuNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Nnꞌaⁿ na mꞌaⁿ jeꞌ jeeⁿ tia nnꞌaⁿndye, jnda̱ ꞌndyena Tyꞌo̱o̱tsꞌom sa̱a̱ meiiⁿ na ljoꞌ, cwitaⁿna cwii ꞌnaaⁿ tꞌmaⁿ na ñeꞌcantyꞌiaana. Sa̱a̱ xonquiaya na nntyꞌiaana cwii ꞌnaaⁿ na tꞌmaⁿ. Macanda̱ calaꞌno̱ⁿꞌna ljoꞌ ñeꞌcaꞌmo̱ⁿnaꞌ juu na tjom Jonás. Mana tjaaⁿ, ꞌñeeⁿ joona. ");
INSERT INTO amuNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Quia joꞌ saanndaaꞌâ cwiicheⁿ xndyaaꞌ ndaaluee. Ndoꞌ quia na squia̱a̱yâ joꞌ joꞌ ñꞌeⁿ Jesús jliuuyâ na tjaaꞌnaⁿ nantquie cañꞌeⁿ, jnda̱ tsuuꞌ nꞌo̱o̱ⁿyâ juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Tso Jesús nda̱a̱yâ: —Cꞌomcꞌeendyoꞌ na calꞌaꞌyoꞌ cwenta cantyja ꞌnaaⁿꞌ ndaaljoꞌ ꞌnaaⁿ nnꞌaⁿ fariseos ñequio nnꞌaⁿ saduceos. ");
INSERT INTO amuNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ndoꞌ jâ na cwilaꞌjomndyô̱ ñꞌeⁿñê to̱o̱ꞌâ na cwilana̱a̱ⁿ cheⁿncjo̱o̱yâ. Lꞌuuyâ: —Macwjeeⁿꞌeⁿ ñꞌoomwaaꞌ nda̱a̱ya ncꞌe na tjaaꞌnaⁿ tyooꞌ cwileiꞌñꞌo̱o̱ⁿya. ");
INSERT INTO amuNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ndoꞌ seiꞌno̱ⁿꞌ Jesús na mꞌaaⁿꞌ nꞌo̱o̱ⁿyâ cantyja ꞌnaaⁿꞌ tyooꞌ ñꞌeⁿ ndaaljoꞌ. Tsoom nda̱a̱yâ: —ꞌO nnꞌaⁿ na titꞌmaⁿ cwilaꞌyuꞌya nꞌomꞌyoꞌ, ¿chiuu na jeeⁿ jndye mꞌaaⁿꞌ nꞌomꞌyoꞌ na tjaaꞌnaⁿ tyooꞌ cwileiꞌñꞌomꞌyoꞌ? ");
INSERT INTO amuNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Aa maxjeⁿ ticalaꞌno̱ⁿꞌyoꞌ ñꞌoom na tsjo̱o̱ luaaꞌ? ¿Aa ticjaañjoomꞌ nꞌomꞌyoꞌ ꞌom taⁿꞌ tyooꞌñeeⁿ na tyja̱ya na tcwaꞌ ꞌom meiⁿ nnꞌaⁿ, ndoꞌ na jndye tsquiee tyooꞌ jlaꞌweꞌyoꞌ na seicwaljooꞌnaꞌ? ");
INSERT INTO amuNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ndoꞌ ¿aa meiⁿ ticjaañjoomꞌ nꞌomꞌyoꞌ cwiicheⁿ ntquieeꞌ taⁿꞌ tyooꞌ na tyja̱ya na tcwaꞌ ñequiee meiⁿ nnꞌaⁿ, ndoꞌ mati lojoo tsquiee ntaⁿꞌ tyooꞌ jlaꞌweꞌyoꞌ na seicwaljooꞌnaꞌ? Nnda̱a̱ nntsꞌaa na nleijndaaꞌ nantquie na nlcwaꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Joꞌ chii ¿chiuu na tiqueⁿꞌyoꞌ cwenta na nchii matseina̱ⁿya cantyja ꞌnaaⁿꞌ tyooꞌ? Ja tsjo̱o̱ na calꞌaꞌyoꞌ cwenta cantyja ꞌnaaⁿꞌ ndaaljoꞌ ꞌnaaⁿ nnꞌaⁿ fariseos ñequio nnꞌaⁿ saduceos. ");
INSERT INTO amuNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Quia ljoꞌcheⁿ jlaꞌno̱o̱ⁿꞌâ na nchii cantyja ꞌnaaⁿꞌ ndaaljoꞌ na cwiluii tyooꞌ na calꞌaayâ cwenta, sa̱a̱ tañeꞌquiandyô̱ cantyja ꞌnaaⁿꞌ ñꞌoom na cwitꞌmo̱o̱ⁿ nnꞌaⁿ fariseos ñequio nnꞌaⁿ saduceos. ");
INSERT INTO amuNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Quia joꞌ tja Jesús ndaatyuaa tsjoom Cesarea Filipo. Jnda̱ squia̱a̱yâ joꞌ joꞌ taxꞌeeⁿ nda̱a̱ jâ nnꞌaⁿ na cwilaꞌjomndyô̱ ñꞌeⁿñê, tsoom: —Ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee ¿ꞌñeeⁿ cwilue nnꞌaⁿ na cwiluiindyo̱? ");
INSERT INTO amuNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Tꞌo̱o̱yâ nnoom lꞌuuyâ: —Mꞌaⁿ nnꞌaⁿ na cwilue na ꞌu Juan, tsꞌaⁿ na tyotseitsꞌoomñe nnꞌaⁿ. Ndoꞌ ntꞌom cwilue Elías ꞌu, ntꞌom cwilue na Jeremías oo cwiicheⁿ profeta. ");
INSERT INTO amuNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Tso Jesús nda̱a̱yâ: —Ndoꞌ ꞌo jeꞌ, ¿ꞌñeeⁿ cwinduꞌyoꞌ na cwiluiindyo̱? ");
INSERT INTO amuNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Tꞌo̱ Simón Pedro nnoom, tso: —ꞌU cwiluiindyuꞌ nquii Cristo, Jnda Tyꞌo̱o̱tsꞌom na wandoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Tso Jesús nnom: —ꞌU Simón, jnda Jonás, tꞌmaⁿ waa na matioꞌnaaⁿñe Tyꞌo̱o̱tsꞌom ꞌu na luaaꞌ matseiꞌno̱ⁿꞌ. Ee nchii cweꞌ tsꞌaⁿ na tꞌmo̱ⁿ ñꞌoommeiⁿꞌ njomꞌ. Nquii Tsotya̱ya na mꞌaaⁿ cañoomꞌluee tquiaaⁿ na matseiꞌno̱ⁿꞌ cantyja ꞌnaⁿya. ");
INSERT INTO amuNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mati matsjo̱o̱ njomꞌ na ꞌu jndyuꞌ Pedro, ñꞌoom na maꞌmo̱ⁿnaꞌ tsjo̱ꞌ. Nacjooꞌ juu tsjo̱ꞌwaañe nlqua̱a̱ⁿya tmaaⁿꞌ nnꞌaⁿ na macwjiiꞌndyo̱ cwentaya. Ndoꞌ meiⁿ naⁿjndii na mꞌaⁿ quiiꞌ bꞌio na jeeⁿ jnda̱ cwilaꞌxmaⁿna, xocanaⁿjnda̱na nacjooꞌ tmaaⁿꞌ nnꞌaⁿ na cwjiiꞌndyo̱ cwentaya. ");
INSERT INTO amuNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ja nñequiaya na tꞌmaⁿ nntseixmaⁿꞌ quiiꞌntaaⁿ nnꞌaⁿ na mꞌaⁿ cantyja ꞌnaaⁿꞌ nqueⁿ na matsa̱ꞌntjoom cañoomꞌluee. Ñꞌoom na nntsuꞌ na ticatyꞌiomnaꞌ na calꞌa nnꞌaⁿ na mꞌaⁿ tsjoomnancuewaa, ñꞌoomꞌñeeⁿ nntseixꞌiaaꞌñenaꞌ ñequio ñꞌoom na ntyjii Tyꞌo̱o̱tsꞌom. Ndoꞌ ñꞌoom na nntsuꞌ na wanaaⁿ na calꞌa nnꞌaⁿ mati nntseixꞌiaaꞌñenaꞌ ñequio juu ñꞌoom na ntyjii Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Quia joꞌ Jesús tqueⁿtyeeⁿ ñꞌoom nda̱a̱yâ na meiⁿcwii nnom tsꞌaⁿ ticatꞌmo̱o̱ⁿyâ na jom cwiluiiñê Cristo. ");
INSERT INTO amuNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Xjeⁿꞌñeeⁿ to̱ꞌ Jesús na maꞌmo̱o̱ⁿ nda̱a̱ jâ nnꞌaⁿ na cwilaꞌjomndyô̱ ñꞌeⁿñê na jndeiꞌnaꞌ na nncjaⁿ Jerusalén. Joꞌ joꞌ tꞌmaⁿ nawiꞌ nntjoom nlꞌa nnꞌaⁿ na cwiluiitquiendye, ñequio ntyee na cwiluiitquiendye, ñequio nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés. Naⁿꞌñeeⁿ nlaꞌcueeꞌna jom, sa̱a̱ xuee jnda̱ ndyee nncwandoꞌxcoom. ");
INSERT INTO amuNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Quia joꞌ tjañꞌoom Pedro Jesús cwii ntyja, to̱o̱ⁿꞌo̱ⁿ na matsoom nnom na ticatsa̱ꞌntjomnaꞌ na nntjom na luaaꞌ. Tsoom: —Tijoom quiaa Tyꞌo̱o̱tsꞌom na nntjomꞌ na luaaꞌ. Tixoquiaaⁿ na nluii naljoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Teiqueⁿ Jesús tsoom nnom Pedro: —Quindyo̱o̱ꞌ nacañomya ꞌu Satanás. Ñeꞌcatseitsaⁿꞌ ja. ꞌU ñeꞌcatseiꞌnndaꞌ tsꞌo̱o̱ⁿya ee ñꞌoom na matseiꞌtiuuꞌ jnaⁿnaꞌ cweꞌ cantyja na cwilaꞌtiuu nnꞌaⁿ, nchii chaꞌxjeⁿ na lꞌue tsꞌom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jnda̱ chii tso Jesús nda̱a̱yâ: —Meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na lꞌue tsꞌom na nncwꞌaaꞌñe ja, cwjiꞌñê ljoꞌ na matseitiuu nqueⁿ. Caljoya tsꞌoom nawiꞌ na matjoom meiiⁿ cueeⁿꞌeⁿ. Ndoꞌ candyontyjo̱o̱ⁿ cantyja na matsꞌaa. ");
INSERT INTO amuNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ee meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na mañequiaañe na catjom ljoꞌ na nntjom, ncꞌe na mꞌaaⁿ cantyja ꞌnaⁿya, tsaⁿꞌñeeⁿ nluiꞌnꞌmaaⁿñê. Ndoꞌ meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na malꞌueeꞌñe cheⁿnquii chiuu nluiꞌnꞌmaaⁿñe, majoꞌto joꞌ nntsuuñe. ");
INSERT INTO amuNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Meiiⁿ chaꞌwaa tsjoomnancue cuaanaꞌ cwentaaꞌ tsꞌaⁿ sa̱a̱ yuu waa na mateijndeiinaꞌ tsaⁿꞌñeeⁿ ee xocꞌo̱naꞌ ñꞌeⁿñê na ticatsuu añmaaⁿꞌaⁿ. Ndoꞌ ¿aa nnda̱a̱ nntiomlꞌua tsꞌaⁿ na nluiꞌnꞌmaaⁿñe añmaaⁿꞌaⁿ? ¿Cwaaⁿ nnda̱a̱? ");
INSERT INTO amuNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee nncwja̱caño̱o̱ⁿnndaꞌa tsjoomnancue ñequio ángeles cwentaaꞌ Tsotya̱ya. Quia ljoꞌ nntseitꞌmaaⁿꞌñenaꞌ ja chaꞌxjeⁿ na matseitꞌmaaⁿꞌñenaꞌ nquii Tsotya̱ya. Ndoꞌ nntsꞌaa na nncoꞌñom ticwii cwii tsꞌaⁿ cantyjati na ñesꞌaa, aa na ya, aa na tisꞌa. ");
INSERT INTO amuNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ñꞌoom na mayuuꞌ matsjo̱o̱ nda̱a̱ꞌyoꞌ, mamꞌaⁿ nnꞌaⁿ ljooñe na tixocwjena hasta na jnda̱ ntyꞌiaanda̱a̱na ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee na macwja̱caño̱o̱ⁿ na nntsa̱ꞌntjo̱ⁿya. ");
INSERT INTO amuNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Jnda̱ teinom yom xuee, quia joꞌ tjañꞌoom Jesús Pedro ñequio Jacobo ñequio Juan tyjee Jacoboꞌñeeⁿ. Tjachom joona cwii sjo̱ nandye yuu na ñenquieena. ");
INSERT INTO amuNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Xcwe na cwintyꞌiaana ndoꞌ seichuiiꞌnaꞌ jom jo nda̱a̱na. Sꞌaanaꞌ na jeeⁿ caxuee nnoom chaꞌcwijom nnom ñeꞌquioomꞌ. Ndoꞌ seicwaqueⁿnaꞌ liaⁿꞌaⁿ na canchiiꞌ chaꞌna nntyꞌiaaꞌ tsꞌaⁿ chom lámpara. ");
INSERT INTO amuNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ndoꞌ juu xjeⁿꞌñeeⁿ nacañomꞌm teitquiooꞌndye we nnꞌaⁿ na ñetꞌom teiyo, juu Moisés ñꞌeⁿ Elías. Cwilaꞌneiⁿna ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Quia joꞌ tso Pedro nnoom: —Ta, jeeⁿ ya nquiuuyâ na mꞌaaⁿyâ ñjaaⁿ. Xeⁿ cjaaweeꞌ tsꞌomꞌ, nluii ndyee xquieꞌ ñjaaⁿñe, cwii cwentaꞌ nncuꞌ, cwii cwentaaꞌ Moisés ndoꞌ cwiicheⁿ cwentaaꞌ Elías. ");
INSERT INTO amuNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ndicwaⁿ matseineiⁿ Pedro ndoꞌ jndyoquioo cwii nchquiu na jeeⁿ canchiiꞌ caxuee juunaꞌ. Seicata̱ꞌnaꞌ joona ndoꞌ teicꞌuaa na seineiⁿ Tyꞌo̱o̱tsꞌom naquiiꞌ nchquiuꞌñeeⁿ, tsoom: —Luaañe tiꞌJndaaya na jeeⁿ candyaꞌ tsꞌo̱o̱ⁿya. Cantyja ꞌnaaⁿꞌ jom ñequiiꞌcheⁿ mañequiaanaꞌ na neiⁿya. Candyeꞌyoꞌ ñꞌoom na matseineiiⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Ndyee naⁿꞌñeeⁿ na cwilaꞌjomndye ñꞌeⁿ Jesús, jnda̱ na jndyena ñꞌoomwaaꞌ, tyꞌetaꞌnquiona xjeⁿ nomtyuaacheⁿ ee jeeⁿ tꞌmaⁿ jlaꞌcatyuendyena. ");
INSERT INTO amuNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Quia joꞌ seicandyooꞌñe Jesús nacañoomna. Tyeⁿnquioomꞌm joona, tsoom nda̱a̱na: —Quicantyjaꞌyoꞌ. Talacatyuendyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Jlunda̱a̱ndyena. Meiⁿcwii tsꞌaⁿ tîcantyꞌiaana macanda̱ ñenquii Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ndoꞌ yocheⁿ na tquiocuena sjo̱ꞌñeeⁿ, sa̱ꞌntjom Jesús joona, tsoom: —Yocheⁿ na ndicwaⁿ wando̱ꞌa, ticanduꞌyoꞌ nnom meiⁿcwii tsꞌaⁿ ꞌnaⁿ na ntyꞌiaꞌyoꞌ jeꞌ. Ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee nncꞌio̱ ndoꞌ nncwando̱ꞌxco̱, quia ljoꞌcheⁿ wanaaⁿ na nnduꞌyoꞌ cantyja na ntyꞌianda̱a̱ꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Quia joꞌ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê, taꞌxꞌeena nnoom, jluena: —Nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés, cwitꞌmo̱o̱ⁿna na macaⁿnaꞌ na cwjeeꞌjndyee Elías. Ñeꞌcandya̱a̱yâ ¿chiuu na luaaꞌ cwitꞌmo̱o̱ⁿna? ");
INSERT INTO amuNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Tꞌo̱o̱ⁿ nda̱a̱na: —Mayuuꞌ na mandyocwjeeꞌcañoom Elías, ndoꞌ tseixmaaⁿ na nntseijndaaꞌñê chaꞌtso, ");
INSERT INTO amuNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","sa̱a̱ candyeꞌyoꞌ nntsjo̱o̱ na jnda̱ tyjeeꞌ Elías sa̱a̱ tîcalaꞌno̱ⁿꞌ nnꞌaⁿ cantyja ꞌnaaⁿꞌaⁿ. Lꞌana chaꞌxjeⁿ na lꞌue nꞌomna ñꞌeⁿñê. Ndoꞌ malaaꞌtiꞌ nlꞌana ñꞌeⁿndyo̱ ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Quia ljoꞌcheⁿ jlaꞌno̱ⁿꞌna na seineiiⁿ nda̱a̱na cantyja ꞌnaaⁿꞌ Juan, tsaⁿ na tyotseitsꞌoomñe nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Quia na jnda̱ tquienndaꞌna yuu na mꞌaⁿ nnꞌaⁿ na jndyendye, jndyotseicandyooꞌñe cwii tsaⁿsꞌa na mꞌaaⁿ Jesús. Tcoomꞌm xtyeeⁿ jo nnom, tsoom: ");
INSERT INTO amuNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Ta, cꞌoomꞌ na wiꞌ tsꞌomꞌ ñꞌeⁿ tiꞌjndaaya. Ee maleiñꞌoom jndyetia jom ndoꞌ jeeⁿ cwajndii matjoom. Jndye ndiiꞌ machꞌeenaꞌ na cwiquiooñê naquiiꞌ chom ndoꞌ naquiiꞌ ndaa. ");
INSERT INTO amuNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ndoꞌ jndyo̱ñꞌo̱ⁿya jom na mꞌaⁿ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿndyuꞌ sa̱a̱ tileicanda̱a̱ na nlaꞌnꞌmaⁿna jom. ");
INSERT INTO amuNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Tꞌo̱ Jesús, tsoom nda̱a̱yâ: —ꞌO nnꞌaⁿ na ticalayuꞌya nꞌomꞌyoꞌ, ndoꞌ jeeⁿ tixcwe cwilaꞌtiuuꞌyoꞌ, ¿cwanti yo cwii macaⁿnaꞌ na nljooꞌndyo̱ ñꞌeⁿndyoꞌ na mꞌmo̱o̱ⁿtya̱ nda̱a̱ꞌyoꞌ? ¿Cwanti xuee cwii nnda̱a̱ nntseiquii tsꞌo̱o̱ⁿya ñꞌeⁿndyoꞌ? Quioñꞌomꞌyoꞌ tiꞌchjoomꞌaaⁿꞌ ñjaaⁿñe. ");
INSERT INTO amuNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Quia joꞌ seitiaꞌ Jesús jndyetiaꞌñeeⁿ, joꞌ chii jluiꞌ naquiiꞌ tsꞌom tyochjoo. Mañoomꞌ nꞌmaⁿ juu. ");
INSERT INTO amuNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Jnda̱ tuii na luaaꞌ, quia joꞌ jâ nnꞌaⁿ na cwilaꞌjomndyô̱ ñꞌeⁿñê jluiiꞌâ cwii ntyja na ñencjo̱o̱yâ ñꞌeⁿñê. Taꞌxꞌa̱a̱yâ nnoom, lꞌuuyâ: —¿Chiuu na jâ tîcanda̱a̱ nntjeiiꞌâ jndyetiaꞌñeeⁿ? ");
INSERT INTO amuNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Tꞌo̱ Jesús nda̱a̱yâ, tsoom: —Ncꞌe na ticalaꞌyuꞌya nꞌomꞌyoꞌ joꞌ chii tîcanda̱a̱ lꞌaꞌyoꞌ. Sa̱a̱ candyeꞌyoꞌ nntsjo̱o̱, mayuuꞌcheⁿ meiiⁿ na cachjoo cwilayuꞌya nꞌomꞌyoꞌ chaꞌna cachjoo lqueeⁿꞌ mostaza sa̱a̱ matꞌmaⁿ tsꞌiaaⁿ nnda̱a̱ nlꞌaꞌyoꞌ. Meiiⁿ waa cwii na jeeⁿ jndeiꞌnaꞌ cwiwinomꞌyoꞌ hasta matseijomnaꞌ chaꞌna cwii sjo̱ndye nquiuꞌyoꞌ, sa̱a̱ nnda̱a̱ nlꞌaꞌyoꞌ. Nntsꞌaanaꞌ chaꞌcwijom na nnduꞌyoꞌ nnom sjo̱waaꞌ: “Quindyo̱ꞌ ñjaaⁿ, cjaꞌ laꞌñeⁿ”, ndoꞌ nleindyo̱o̱naꞌ. Ee tjaaꞌnaⁿ cwii na xocanda̱a̱ nlꞌaꞌyoꞌ xeⁿ na mayuuꞌ cwilayuꞌya nꞌomꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Sa̱a̱ cantyja ꞌnaaⁿꞌ jndyetiameiⁿꞌ cwicaluiꞌncꞌuaaꞌndyena, joꞌ chii macaⁿnaꞌ na catseicwejndoꞌñe tsꞌaⁿ ndoꞌ catseineiiⁿ nnom Tyꞌo̱o̱tsꞌom cha nnda̱a̱ nntsꞌaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ndoꞌ yocheⁿ na tyomaꞌno̱o̱ⁿyâ tsꞌo̱ndaa Galilea, tso Jesús nda̱a̱yâ na jom na cwiluiiñê tsꞌaⁿ na jnaⁿ cañoomꞌluee, mamꞌaaⁿ ꞌñeeⁿ juu na nñequiaa cwenta jom luee nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ndoꞌ nlaꞌcueeꞌ nnꞌaⁿ jom, sa̱a̱ xuee jnda̱ ndyee nñequiaa Tyꞌo̱o̱tsꞌom na nncwandoꞌxcoom na tueeⁿꞌeⁿ. Quia na jndya̱a̱yâ na luaaꞌ, sꞌaanaꞌ na jeeⁿ tia nquiuuyâ. ");
INSERT INTO amuNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Tueeꞌ Jesús tsjoom Capernaum ñequio jâ nnꞌaⁿ na cwilaꞌjomndyô̱ ñꞌeⁿñê. Ndoꞌ nnꞌaⁿ na cwitoꞌñoom sꞌom tsꞌiaaⁿnda̱a̱ nnꞌaⁿ judíos cwentaaꞌ watsꞌom tꞌmaⁿ tyꞌentyjaaꞌna Pedro, jluena nnoom: —Tsaⁿ na maꞌmo̱ⁿ nda̱a̱ꞌyoꞌ, ¿aa tiquitioom sꞌom tsꞌiaaⁿnnoom cwentaaꞌ watsꞌom tꞌmaⁿ? ");
INSERT INTO amuNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Tꞌo̱ Pedro, matsoom: —Quitioom tsꞌiaaⁿnnoom. Tyoowiquiuuꞌ na tuii na luaaꞌ, tjaquieeꞌ Pedro quiiꞌ wꞌaa. Tyuaaꞌti to̱ꞌ Jesús na matseineiiⁿ nnom Pedro. Tsoom: —¿Chiuu mꞌaaⁿꞌ tsꞌomꞌ ꞌu, Simón? Joo nnꞌaⁿ na mꞌaⁿ nꞌiaaⁿ, ¿ꞌñeeⁿ matseiꞌtiuuꞌ na cwiqueⁿna xjeⁿ na catioom tsꞌiaaⁿnda̱a̱? ¿Aa nnꞌaⁿ wꞌaana oo aa ntꞌomcheⁿ nnꞌaⁿ? ");
INSERT INTO amuNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Tꞌo̱ Pedro nnoom, tso: —Ntꞌomcheⁿ nnꞌaⁿ cwitioom tsꞌiaaⁿnda̱a̱, sa̱a̱ nnꞌaⁿ wꞌaana tiquitioom. Tso Jesús nnom Pedro: —Quia joꞌ naⁿꞌñeeⁿ maꞌndiinaꞌ nnꞌaⁿ wꞌaana. ");
INSERT INTO amuNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Sa̱a̱ meiiⁿ na ljoꞌ cha tilaꞌteincuuꞌndye nnꞌaⁿ na cwitoꞌñoom sꞌom, nntio̱o̱ⁿya cwanti na lꞌue nꞌomna. Joꞌ chii cjaꞌcjuꞌ tseiꞌnchquia ndaaluee. Catscaa na nncwjiꞌjndyeeꞌ, cato̱o̱ⁿꞌndyuꞌ ꞌndyooyoꞌ, joꞌ joꞌ nljeiꞌ cwii tsjo̱ꞌñjeeⁿ na nleijndeiinaꞌ tsꞌiaaⁿnda̱a̱ya. Cjaꞌñꞌoomꞌ, nñequiaaꞌ juunaꞌ nda̱a̱na cwentaaya. ");
INSERT INTO amuNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ndoꞌ xjeⁿꞌñeeⁿ jâ nnꞌaⁿ na cwilaꞌjomndyô̱ ñꞌeⁿ Jesús squia̱a̱caño̱o̱ⁿyâ jom. Taꞌxꞌa̱a̱yâ nnoom, lꞌuuyâ: —¿ꞌÑeeⁿ juu nncꞌoom na tꞌmaⁿñeti yuu na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom? ");
INSERT INTO amuNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Quia joꞌ tꞌmaⁿ Jesús cwii tyochjoo, tqueeⁿ juu xcwe quiiꞌntaaⁿyâ. ");
INSERT INTO amuNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ndoꞌ tsoom nda̱a̱yâ: —Mayuuꞌcheⁿ nndyeꞌyoꞌ nntsjo̱o̱, xeⁿ tilcweꞌ nꞌomꞌyoꞌ jnaⁿꞌyoꞌ ndoꞌ cꞌomꞌyoꞌ chaꞌna yocanchꞌu na tiqueeⁿ nꞌom na nluiitꞌmaⁿndyena, quia joꞌ xonda̱a̱ nntsaquieeꞌndyoꞌ cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Cweꞌ joꞌ tsꞌaⁿ na majuꞌñecje ndoꞌ ticalꞌueeꞌñe na nluiitꞌmaⁿñe, matseijomnaꞌ tsaⁿꞌñeeⁿ chaꞌna tyochjoomꞌaaⁿ. Ndoꞌ na ljoꞌ cwiluiitꞌmaⁿñê cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ndoꞌ meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na neiiⁿꞌ cwii yuchjoo chaꞌna tyochjoomꞌaaⁿ, maja neiiⁿꞌ tsaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","’Meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na matseijndo̱ꞌ tsꞌom cwii yucachjoo na catsꞌaa natia, tsaⁿꞌñeeⁿ yati xeⁿ cjuꞌnaꞌ jom tsꞌom ndaaluee na chuꞌtyeⁿ xtyoomꞌm cwii tsjo̱ꞌsuu tꞌmaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Jeeⁿ wiꞌ cwitjoom nnꞌaⁿ tsjoomnancue na jndye nnom neiⁿncooꞌ niom na macjaachuunaꞌ joona na cwilaꞌtjo̱o̱ndyena. Sa̱a̱ tjaa chiuu ya ee maxjeⁿ niomnaꞌ. Sa̱a̱ nntꞌuiiwiꞌnaꞌ tsꞌaⁿ na matseijndo̱ꞌ tsꞌom xꞌiaaꞌ na catsꞌaa yuu na tia. ");
INSERT INTO amuNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","’Xeⁿ na wjaañꞌoomnaꞌ ꞌu na matseiꞌtjo̱o̱ndyuꞌ nnom Tyꞌo̱o̱tsꞌom jnaaⁿꞌ tsꞌo̱ꞌ oo xꞌeꞌ, catsaꞌ xjeⁿ joonaꞌ chaꞌcwijom catyjeeꞌ, catyenquieꞌ joonaꞌ cha tintseiꞌtjo̱o̱ndyuꞌtiꞌ. Ee yati na nnda̱a̱ nntseixmaⁿꞌ na ticantycwii na wandoꞌ añmaaⁿꞌ meiiⁿ chaꞌcwijom na ticanda̱a̱ꞌndyuꞌ, nchiiti na canda̱a̱ꞌndyuꞌ ndoꞌ nncjuꞌnaꞌ ꞌu quiiꞌ chom na tijoom canduuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ndoꞌ xeⁿ cweꞌ cantyja na mantyꞌiaꞌ wjaañꞌoomnaꞌ ꞌu na matseiꞌtjo̱o̱ndyuꞌ nnom Tyꞌo̱o̱tsꞌom, catsaꞌ xjeⁿ chaꞌcwijom na cwjiꞌ tsꞌomnjomꞌ ndoꞌ catquieꞌ juunaꞌ cha tintseiꞌtjo̱o̱ndyuꞌtiꞌ. Ee yati na nnda̱a̱ nntseixmaⁿꞌ na ticantycwii na wandoꞌ añmaaⁿꞌ meiiⁿ chaꞌcwijom ñeꞌcwii tsꞌomnjomꞌ, nchiiti na we tsꞌomnjomꞌ ndoꞌ nncjuꞌnaꞌ ꞌu quiiꞌ chom bꞌio. ");
INSERT INTO amuNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","’Calꞌaꞌyoꞌ cwenta na tincꞌomꞌyoꞌ na ticueeꞌ nꞌomꞌyoꞌ meiⁿcwii yucachjoo. Ee nndyeꞌyoꞌ nntsjo̱o̱ jo nandye mꞌaⁿ ángeles na cwilꞌa cwenta yocanchꞌu. Ndoꞌ ángelesꞌñeeⁿ meiⁿnquia xjeⁿ cwilaꞌneiⁿna nnom Tsotya̱ya na mꞌaaⁿ cañoomꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ee ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee jndyo̱o̱ na nncwjiꞌnꞌmaaⁿndyo̱ nnꞌaⁿ na cwitsuundye. ");
INSERT INTO amuNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","’¿Chiuu mꞌaaⁿꞌ nꞌomꞌyoꞌ? Xeⁿ mꞌaaⁿ cwii tsꞌaⁿ na mꞌaⁿ cwii siaⁿnto canmaⁿ ntsmeiiⁿꞌeⁿ ndoꞌ cwiindye jooyoꞌ nntsuuñe, aa nchii nꞌñeeⁿ ñequieenꞌaaⁿ nchooꞌ qui nchooꞌ ñjeeⁿ jooyoꞌ cjooꞌ tyueꞌ ndoꞌ wjaacalꞌueeⁿ juu quiooꞌ na tsuuñe. ");
INSERT INTO amuNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ndoꞌ xeⁿ na nljeiiⁿ juuyoꞌ, nndyeꞌyoꞌ nntsjo̱o̱, mayuuꞌcheⁿ tꞌmaⁿti nñequiaanaꞌ na neiiⁿꞌeⁿ cantyja ꞌnaaⁿꞌ catsmaⁿꞌñeeⁿ nchiiti cantyja ꞌnaaⁿ chaꞌtsondye ntꞌom canmaⁿ na tyootsuundye. ");
INSERT INTO amuNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Calaꞌno̱ⁿꞌyoꞌ na nquii Tsotyeꞌyoꞌ na mꞌaaⁿ cañoomꞌluee malaaꞌtiꞌ jeeⁿ xueeⁿ ꞌo. Tilꞌue tsꞌoom na nntsuundye meiⁿcwiindye joo nnꞌaⁿ na titꞌmaⁿti cwiluiindye. ");
INSERT INTO amuNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","’Xeⁿ mꞌaaⁿ cwii xꞌiaꞌ na matseiyuꞌ na matseiꞌtjo̱o̱ñê njomꞌ, cwa cjaꞌcwaⁿꞌyaꞌ jom. Catseiꞌno̱o̱ⁿꞌo̱ⁿ yuu matseitjo̱o̱ñê njomꞌ ndoꞌ calantycwiiꞌyoꞌ ñꞌoom na ñeꞌwendyoꞌ. Ndoꞌ xeⁿ na nñeeⁿ ñꞌoom na matsuꞌ quia joꞌ jnda̱ teijndeiꞌ xꞌiaꞌ na tcoꞌxcwenaꞌ jom. ");
INSERT INTO amuNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Sa̱a̱ xeⁿ tiñeꞌcañeeⁿ ñꞌoom na matsuꞌ quia joꞌ cjaañꞌeⁿ cwii oo we tsꞌaⁿ ñꞌeⁿndyuꞌ cha joo naⁿꞌñeeⁿ nndyena ñꞌoom na cwiꞌmaⁿꞌyoꞌ ñꞌeⁿ xꞌiaꞌ ndoꞌ na ljoꞌ nquiujndaaꞌndyena chiuu tꞌmaⁿꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Sa̱a̱ xeⁿ tiñeꞌcañeeⁿ ñꞌoom na nlue naⁿꞌñeeⁿ quia joꞌ caꞌmo̱ⁿꞌ ñꞌoomꞌñeeⁿ nda̱a̱ tmaaⁿꞌ nnꞌaⁿ na macwjiiꞌndyo̱ cwentaya. Ndoꞌ xeⁿ meiⁿ ticañeeⁿ ñꞌoom na nlue chaꞌtso naⁿꞌñeeⁿ quia joꞌ tjaa chiuu ya. Caliuꞌyoꞌ na jom cwiluiiñê chaꞌcwijom tsꞌaⁿ na tyootseitꞌmaaⁿꞌñe Tyꞌo̱o̱tsꞌom oo chaꞌcwijom tsaⁿcoꞌñom tsꞌiaaⁿnda̱a̱ nnꞌaⁿ cwentaaꞌ gobiernom na tia tsꞌaⁿñe. ");
INSERT INTO amuNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","’Mayuuꞌcheⁿ nndyeꞌyoꞌ nntsjo̱o̱, meiⁿljoꞌcheⁿ na cwinduꞌyoꞌ na ticatyꞌiomnaꞌ na calꞌa nnꞌaⁿ na mꞌaⁿ tsjoomnancuewaa, ñꞌoomꞌñeeⁿ nntseixꞌiaaꞌñenaꞌ ñequio ñꞌoom na ntyjii Tyꞌo̱o̱tsꞌom. Ndoꞌ meiⁿljoꞌcheⁿ na cwinduꞌyoꞌ na wanaaⁿ na calꞌa nnꞌaⁿ, mati nntseixꞌiaaꞌñenaꞌ ñequio ñꞌoom na ntyjii Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","’Mati candyeꞌyoꞌ nntsjo̱o̱, xeⁿ wendyoꞌ ꞌo ñeꞌcwii mꞌaaⁿꞌ nꞌomꞌyoꞌ ñꞌoom na cwitaⁿꞌyoꞌ nnom Tsotya̱ya Tyꞌo̱o̱tsꞌom na mꞌaaⁿ cañoomꞌluee, quia joꞌ nñeeⁿ ndoꞌ nñequiaaⁿ ñꞌoom na cwitaⁿꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ee meiⁿnquiayuucheⁿ na mꞌaⁿ we ndyee nnꞌaⁿ na cwitjomndye ñequio xueya, majoꞌ joꞌ mꞌaaⁿya quiiꞌntaaⁿna. ");
INSERT INTO amuNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Quia joꞌ tjatseindyooꞌñe Pedro na mꞌaaⁿ Jesús. Tsoom nnom: —Ta, cwii xꞌiaya na matseitjo̱o̱ñe no̱o̱ⁿ, ¿cwanti ndiiꞌ na macaⁿnaꞌ na catseitꞌmaⁿ tsꞌo̱o̱ⁿya jom? ¿Aa nncueꞌntyjo̱ hasta ntquieeꞌ ndiiꞌ? ");
INSERT INTO amuNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Tꞌo̱ Jesús nnoom: —Ticatsjo̱o̱ na ñeꞌntquieeꞌ ndiiꞌ. Matsjo̱o̱ na catseitꞌmaⁿ tsꞌomꞌ jom ndyeenꞌaaⁿ nchooꞌ qui ndiiꞌ na ntquieeꞌ ntquieeꞌ. Maxjeⁿ ñequiiꞌcheⁿ catseitꞌmaⁿ tsꞌomꞌ jom. ");
INSERT INTO amuNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","’Cweꞌ joꞌ calaꞌno̱ⁿꞌyoꞌ cantyja ꞌnaaⁿꞌ nqueⁿ na matsa̱ꞌntjoom cañoomꞌluee. Matseijomnaꞌ jom chaꞌna cwii patrom na seitioom na nntyjo̱o̱ⁿ mosoomꞌm na choꞌjnaⁿ nnoom. ");
INSERT INTO amuNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","To̱o̱ⁿꞌo̱ⁿ na macwjeeⁿꞌeⁿ cwenta ndoꞌ tquioñꞌomna cwii tsꞌaⁿ na chujnaⁿ jndye meiⁿyom sꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Quia na ntyꞌiaaꞌ patromꞌñeeⁿ na meiⁿcwii tsjo̱ꞌñjeeⁿ tîcanda̱a̱ nntiom mosoomꞌm, quia joꞌ sa̱ꞌntjoom na nleilꞌuañe tsaⁿꞌñeeⁿ na nncjaaquieeꞌñe na nndiꞌntjomtyeⁿ, ndoꞌ mati scuuꞌ tsaⁿꞌñeeⁿ ñequio ndana ñequio chaꞌtso ꞌnaaⁿna, cha nncꞌiooꞌñe na chujnaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Quia joꞌ mosoꞌñeeⁿ tcoomꞌm xtyeeⁿ nnom patrom ꞌnaaⁿꞌaⁿ, tꞌmaⁿ tyꞌoo sꞌaa nnom tsaⁿꞌñeeⁿ. Tsoom: “Ta, macaⁿꞌa ñꞌomtꞌmaⁿ tsꞌom njomꞌ na nncwindoꞌyaꞌ ndoꞌ nntio̱o̱ⁿñꞌa̱ⁿ na cho̱jnaⁿ njomꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Quia joꞌ patromꞌñeeⁿ tyꞌoom na wiꞌ tsꞌoom mosoomꞌm. Seitꞌmaⁿ tsꞌoom juu chaꞌwaa na chujnaⁿ ndoꞌ seicandyaañê juu. ");
INSERT INTO amuNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Tyoowiquiuuꞌ na jluiꞌ mosoꞌñeeⁿ naquiiꞌ wꞌaa ndoꞌ tjomñê cwii xꞌiaaⁿꞌaⁿ na matyjemosoñê. Chujnaⁿ tsaⁿꞌñeeⁿ nnoom cwii siaⁿnto sꞌom. Ndoꞌ seicjaa lꞌo̱o̱ⁿ tsaⁿꞌñeeⁿ, tyonchjeeⁿ xtyoꞌ. Tsoom nnom: “Catiomꞌ na chujnaⁿꞌ no̱o̱ⁿ.” ");
INSERT INTO amuNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ndoꞌ tcoꞌ xꞌiaaⁿꞌaⁿ xtye jo nnoom. Sꞌaa tyꞌoo nnoom, tso: “Macaⁿꞌa ñꞌomtꞌmaⁿ tsꞌom njomꞌ na nncwindoꞌyaꞌ ndoꞌ nntio̱o̱ⁿ na cho̱jnaⁿ njomꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Sa̱a̱ jom tîcwinomꞌm, matjaqueeⁿ ñꞌoom. Tjoomꞌm tsaⁿꞌñeeⁿ wꞌaancjo hasta na nntiom na chujnaⁿ nnoom. ");
INSERT INTO amuNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ndoꞌ ntyjemosondyena, quia na ntyꞌiaana na luaaꞌ sꞌaaⁿ, jeeⁿ tꞌmaⁿ seiꞌndaaꞌnaꞌ nquiuna. Tyꞌentyjaaꞌna patrom ꞌnaaⁿna ndoꞌ jluena chaꞌtso na jnda̱ tuii. ");
INSERT INTO amuNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Quia joꞌ patromꞌñeeⁿ tqueeⁿꞌñê mosoomꞌm, tsoom nnom: “Cwa jeeⁿ ndyaꞌ wiꞌndyuꞌ, ꞌu mosoya. Ja jnda̱ seitꞌmaⁿ tsꞌo̱o̱ⁿya chaꞌtso na chujnaⁿꞌ ee na jeeⁿ seintyꞌiaaꞌndyuꞌ no̱o̱ⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ndoꞌ mati ꞌu matsonaꞌ na cꞌoomꞌ na wiꞌ tsꞌomꞌ xꞌiaꞌ chaꞌxjeⁿ tꞌo̱o̱ⁿ na wiꞌ tsꞌo̱o̱ⁿ ñꞌeⁿndyuꞌ ꞌu.” ");
INSERT INTO amuNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Quia joꞌ jeeⁿ tꞌmaⁿ seiwꞌii patromꞌñeeⁿ. Tqueeⁿ ñꞌoom na catueeꞌna mosoomꞌm wꞌaancjo na cataꞌwiꞌna juu hasta na nntiomñꞌeⁿ chaꞌwaati na chujnaⁿ nnoom. ");
INSERT INTO amuNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Seicanda̱ Jesús ñꞌoom tjañoomꞌmeiⁿꞌ. Tsoom: —Maluaaꞌ nntsꞌaa Tsotya̱ya na mꞌaaⁿ cañoomꞌluee ñꞌeⁿndyoꞌ ꞌo, xeⁿ nchii na xcweeꞌ nꞌomꞌyoꞌ nlaꞌtꞌmaⁿ nꞌomꞌyoꞌ ncꞌiaaꞌyoꞌ na cwilaꞌtjo̱o̱ndye nda̱a̱ꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jnda̱ jnda̱ seineiⁿ Jesús ñꞌoommeiⁿꞌ, quia joꞌ jlueeⁿꞌeⁿ tsꞌo̱ndaa Galilea, tjaaⁿ tsꞌo̱ndaa Judea, xndyaaꞌ jndaa Jordán. ");
INSERT INTO amuNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Jndyendye nnꞌaⁿ tyꞌentyjo̱ naxeeⁿꞌeⁿ. Ndoꞌ seinꞌmaaⁿ chaꞌtso nnꞌaⁿwii joꞌ joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Quia joꞌ jlaꞌcandyooꞌndye nnꞌaⁿ fariseos na mꞌaaⁿ na ñecalꞌana xjeⁿ jom. Taꞌxꞌeena nnoom: —¿Aa wanaaⁿ na nntseityuiiꞌ tsꞌaⁿ ljeii na tocoom ñꞌeⁿ scoomꞌm ncꞌe meiⁿnquia na seitjo̱o̱ñe tsaⁿꞌñeeⁿ nnoom? ");
INSERT INTO amuNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tꞌo̱ Jesús nda̱a̱na: —Cwaⁿti jnda̱ jlaꞌnaⁿꞌyoꞌ ljeii ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom na matseineiⁿnaꞌ chiuu to̱ꞌjñeeⁿ na tqueeⁿ chaꞌtso. Matsonaꞌ: “Sꞌaaⁿ tsaⁿsꞌa ñꞌeⁿ tsaⁿscu.” ");
INSERT INTO amuNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Mati matso ljeiiꞌñeeⁿ: “Macweꞌ joꞌ nꞌndii tsaⁿsꞌa tsotyeeⁿ, tsoñeeⁿ ndoꞌ nncꞌoomtyeeⁿ ñꞌeⁿ scoomꞌm. Wendye naⁿꞌñeeⁿ ñeꞌcwii seiꞌ nlaꞌxmaⁿna.” ");
INSERT INTO amuNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Joꞌ chii tacalaꞌxmaⁿna na we tsꞌaⁿ. Ndoꞌ ncꞌe na luaaꞌ seijndaaꞌñe Tyꞌo̱o̱tsꞌom, jo chii ticatsonaꞌ na cweꞌ tsꞌaⁿ nntseityuiiꞌ cantyja na mꞌaⁿna. ");
INSERT INTO amuNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ndoꞌ taꞌxꞌeena nnoom: —Quia joꞌ ¿chiuu na sa̱ꞌntjom Moisés na wanaaⁿ na nntyuiiꞌ ljeii ꞌnaaⁿꞌ tsꞌaⁿ ñꞌeⁿ scoomꞌm, jnda̱ joꞌ ya na caꞌñeeⁿ juu? ");
INSERT INTO amuNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Tꞌo̱o̱ⁿ nda̱a̱ naⁿꞌñeeⁿ: —Ncꞌe na ꞌo jeeⁿ quieꞌ nꞌomꞌyoꞌ, joꞌ chii tquiaa Moisés na wanaaⁿ na nntyuiiꞌ ljeii ꞌnaⁿꞌyoꞌ ñꞌeⁿ lcuuꞌyoꞌ. Sa̱a̱ nchii laaꞌtiꞌ teijndaaꞌ najndyee. ");
INSERT INTO amuNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ja matsjo̱o̱ nda̱a̱ꞌyoꞌ, juu tsaⁿsꞌa na nntseityuiiꞌ ljeii na toco ñꞌeⁿ scuuꞌ ndoꞌ nncoco ñꞌeⁿ cwiicheⁿ yuscu, matsonaꞌ na cweꞌ mꞌaaⁿya ñꞌeⁿ yuscuꞌñeeⁿ. Wanaaⁿ na nntseityueeⁿꞌeⁿ ljeii ꞌnaaⁿꞌaⁿ ñꞌeⁿ scoomꞌm xeⁿ na mꞌaaⁿ tsaⁿꞌñeeⁿ ñꞌeⁿ cwiicheⁿ tsaⁿsꞌa. Ndoꞌ meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na nncoco ñꞌeⁿ cwii yuscu na jnda̱ tyuiiꞌ ljeii ꞌnaaⁿꞌ ñꞌeⁿ saaꞌ, tsaⁿꞌñeeⁿ matseijndaaꞌñenaꞌ na cweꞌ mꞌaaⁿyaaⁿ ñꞌeⁿ yuscuꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jâ nnꞌaⁿ na cwilaꞌjomndyô̱ ñꞌeⁿ Jesús lꞌuuyâ nnoom: —Xeⁿ luaaꞌ waa na nntseityeⁿnaꞌ tsꞌaⁿ ñꞌeⁿ scoomꞌm, quia joꞌ yati na tincoco tsꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Tso Jesús nda̱a̱yâ: —Tichaꞌtsondye nnꞌaⁿ nnda̱a̱ nlaꞌcanda̱na ñꞌoomwaaꞌ. Cweꞌ ñejndaaꞌ nnꞌaⁿ na nnda̱a̱ nlaꞌcanda̱ ncꞌe na jnda̱ tquiaa Tyꞌo̱o̱tsꞌom na ljoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ee mꞌaⁿ nnꞌaⁿ na ticunco ncꞌe maxjeⁿ tuiindyena na titjo̱o̱ndyena yuscu, ndoꞌ ntꞌomcheⁿ ticunco ncꞌe na tuii nasei joona cha titjo̱o̱ndyena yuscu. Sa̱a̱ mꞌaⁿ ntꞌomcheⁿ nnꞌaⁿ na cwilaꞌjndaaꞌndye cheⁿnquiee na ticunco ee ñeꞌcandyeꞌntjomna nnom Tyꞌo̱o̱tsꞌom na mꞌaaⁿ cañoomꞌluee. ꞌÑeeⁿ juu tsꞌaⁿ na matseiꞌno̱ⁿꞌ ndoꞌ nnda̱a̱ nntseicanda̱ ñꞌoomwaaꞌ, catseicana̱a̱ⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Tquiocho nnꞌaⁿ yonchꞌu na mꞌaaⁿ Jesús na nntioom tsꞌo̱o̱ⁿ nacjoona ndoꞌ na nntseineiiⁿ nnom Tyꞌo̱o̱tsꞌom cantyja ꞌnaaⁿna. Sa̱a̱ jâ nnꞌaⁿ na cwilaꞌjomndyô̱ ñꞌeⁿñê jlaꞌtiaaꞌâ nnꞌaⁿ na tquiocho yonchꞌuꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Quia joꞌ tso Jesús: —Caꞌndyeꞌyoꞌ na quiontyjaaꞌ yonchꞌu ja. Tilantycwiꞌyoꞌ joona, ee matseijomnaꞌ joona chaꞌna nnꞌaⁿ na cwiñeꞌquiandye na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom naquiiꞌ nꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ndoꞌ tioom lꞌo̱o̱ⁿ nacjoo yonchꞌuꞌñeeⁿ, jnda̱ chii jlueeⁿꞌeⁿ joꞌ joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Cwiicheⁿ xuee jndyotseicandyooꞌñe cwii tsꞌaⁿ na titquieeñe na mꞌaaⁿ Jesús. Taxꞌee tsaⁿꞌñeeⁿ nnoom: —ꞌU Maestro na ya tsꞌaⁿndyuꞌ, ¿aa waa cwii nnom na yati na tseixmaⁿya na catsꞌaa cha nncoꞌño̱ⁿ na ticantycwii na wando̱ꞌa? ");
INSERT INTO amuNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Tꞌo̱ Jesús nnom: —¿Chiuu na matsuꞌ na ya tsꞌaⁿndyo̱ ja? Tjaa ꞌñeeⁿ cꞌoom na jeeⁿ ya tsꞌaⁿñe macanda̱ nquii Tyꞌo̱o̱tsꞌom. Sa̱a̱ ꞌu jeꞌ, xeⁿ ñeꞌcjaꞌquieeꞌndyuꞌ cantyja na ticantycwii na wandoꞌ macaⁿnaꞌ na catseicanda̱ꞌ chiuu tꞌmaⁿ ljeii na matsa̱ꞌntjomnaꞌ na tqueⁿ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Tso tsaⁿꞌñeeⁿ nnoom: —¿Cwaaⁿ ljeii? Tꞌo̱ Jesús nnom, tsoom: —Tintseicueꞌ tsꞌaⁿ. Tincꞌomꞌyaꞌ ñꞌeⁿ cwiicheⁿ tsꞌaⁿ. Tinchꞌueeꞌ ꞌnaaⁿꞌ tsꞌaⁿ. Tintseineiⁿꞌ cantu nacjooꞌ tsꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Catseitꞌmaaⁿꞌndyuꞌ tsotyeꞌ ñꞌeⁿ tsoꞌndyoꞌ. Ndoꞌ cꞌoomꞌ na wiꞌ tsꞌomꞌ ncꞌiaꞌ chaꞌxjeⁿ na jnda ntyjiꞌ ñequio nncuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Tso tsaⁿꞌñeeⁿ nnoom: —Chaꞌtso ñꞌoommeiⁿꞌ matseicanda̱ya xjeⁿ na cachjoondyo̱cha̱ⁿ. ¿Aa waa na matseitjo̱o̱tinaꞌ ja na catsꞌaa? ");
INSERT INTO amuNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Tꞌo̱ Jesús nnom, tsoom: —Xeⁿ ꞌu ñeꞌcatseicanda̱ꞌñꞌeⁿꞌ, quia joꞌ cjaꞌ, cajnda̱a̱ꞌ chaꞌtso ꞌnaⁿꞌ na niom. Quiaaꞌ sꞌomꞌñeeⁿ nda̱a̱ ndyeñeeⁿꞌ quia joꞌ nncꞌoomꞌ na tyandyuꞌ cañoomꞌluee. Ndoꞌ candyoꞌtseijomndyuꞌ ñequio tsꞌiaaⁿ na matsꞌaa. ");
INSERT INTO amuNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Jnda̱ na jndii tsaⁿꞌñeeⁿ ñꞌoommeiⁿꞌ, mana tjaaⁿ na chjooꞌ tsꞌoom ee jeeⁿ ndyaꞌ tyañê. ");
INSERT INTO amuNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Quia joꞌ tso Jesús nda̱a̱ jâ nnꞌaⁿ na cwilaꞌjomndyô̱ ñꞌeⁿñê: —Nndyeꞌyoꞌ nntsjo̱o̱ na mayuuꞌcheⁿ jeeⁿ jndeiꞌnaꞌ ncjuꞌcjeñe cwii tsaⁿtya na nntsa̱ꞌntjom Tyꞌo̱o̱tsꞌom jom. ");
INSERT INTO amuNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mati matsjo̱o̱tya̱ nda̱a̱ꞌyoꞌ, jndeiꞌtinaꞌ na nncjuꞌcjeñe cwii tsaⁿtya na nntsa̱ꞌntjom Tyꞌo̱o̱tsꞌom jom, nchiiti na nncwicandiiꞌñe quiooꞌ camello tsueꞌ xꞌee tseiꞌnchquia. ");
INSERT INTO amuNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Quia na jndya̱a̱yâ ñꞌoomwaaꞌ, jeeⁿ seiñꞌeeⁿꞌnaꞌ jâ. Tyotaxꞌa̱a̱yâ nda̱a̱ ntyja̱a̱yâ, lꞌuuyâ: —¿Quia joꞌ ꞌñeeⁿ tsꞌaⁿ nnda̱a̱ nluiꞌnꞌmaaⁿñe? ");
INSERT INTO amuNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ntyꞌiaaꞌ Jesús nda̱a̱yâ, tsoom: —Tijoom canda̱a̱ nncwjiꞌnꞌmaaⁿñe cheⁿnquii tsꞌaⁿ. Sa̱a̱ Tyꞌo̱o̱tsꞌom chaꞌtso nnda̱a̱ nntsꞌaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ndoꞌ tso Pedro nnoom: —Ta, cantyꞌiaꞌ, jâ jnda̱ ꞌndya̱a̱yâ chaꞌtso cha nnda̱a̱ nlaꞌjomndyô̱ ñequio tsꞌiaaⁿ ꞌnaⁿꞌ. ¿Aa waa naya ꞌnaaⁿyâ? ");
INSERT INTO amuNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Tꞌo̱ Jesús nda̱a̱yâ, tsoom: —Nndyeꞌyoꞌ nntsjo̱o̱, mayuuꞌcheⁿ quia na nncueꞌntyjo̱ xjeⁿ na nncuaaxco tsjoomnancue, mati ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee nncjo̱cajmaⁿya ndio ꞌnaⁿya yuu na nntseitꞌmaaⁿꞌñenaꞌ ja. Ndoꞌ ꞌo na jnda̱ macwilaꞌjomndyoꞌ ñꞌeⁿndyo̱ mati maniom canchooꞌwe ndio ꞌnaⁿꞌyoꞌ na nntsaacwindyuaandyoꞌ na nntuꞌxeⁿꞌyoꞌ canchooꞌwe ntmaaⁿꞌ nnꞌaⁿ ntseinda Israel. ");
INSERT INTO amuNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ndoꞌ ticwii cwii tsꞌaⁿ na jnda̱ ꞌndii waaꞌ oo tiꞌnquio oo ndyencjo oo tsotye oo tsondyee oo scuuꞌ oo ntseinda oo ndyuaaꞌ ncꞌe na jnda̱ jndyoquieeꞌñe cantyja ꞌnaⁿya, tsaⁿꞌñeeⁿ cwii siaⁿnto ndiiꞌ nncoꞌñoom na nleinoom cantyja na jnda̱ ꞌñeeⁿ. Ndoꞌ nnaaⁿꞌaⁿ na ticantycwii na wanoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ee majndye nnꞌaⁿ mꞌaⁿ jeꞌ na cwilaꞌtiuu nquiee na tꞌmaⁿ cwiluiindye, sa̱a̱ nncueꞌntyjo̱ na mancjuꞌcjenaꞌ joona. Ndoꞌ jndye nnꞌaⁿ mꞌaⁿ jeꞌ na majuꞌcjenaꞌ joona, sa̱a̱ nda̱nquia nntseiwendyenaꞌ joona. ");
INSERT INTO amuNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Seineiⁿti Jesús ñꞌoom tjañoomꞌ, tsoom: —Juu na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom cañoomꞌluee, matseijomnaꞌ juunaꞌ chaꞌna cwii patrom na waa ntjoomꞌ. Cwitsjoom tjacalꞌue patromꞌñeeⁿ naⁿntjom na nncꞌooquieꞌ tsꞌiaaⁿ ꞌnaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Tꞌmaⁿna ñꞌeⁿ naⁿntjom ꞌnaaⁿꞌaⁿ na nntoꞌñoomna cwii denario na cwii xuee chaꞌxjeⁿ cwitaꞌntjom nnꞌaⁿ. Jnda̱ chii jñoom joona na waa ntjoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Chaꞌna ñjeeⁿ na cwitsjoom tjaaⁿ xcwe quiiꞌ tsjoom, joꞌ joꞌ ljeiiⁿ ntꞌomcheⁿ nnꞌaⁿ na cweꞌ mandiꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Tsoom nda̱a̱na: “Cwa catsaꞌyoꞌ na waa ntjom ꞌnaⁿya na nlꞌaꞌyoꞌ tsꞌiaaⁿ. Ja nntiomlꞌuaya ꞌo chaꞌxjeⁿ na matsonaꞌ.” Mana tyꞌe naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Chaꞌna quiajmeiⁿꞌ matjanndaꞌ patromꞌñeeⁿ quiiꞌ tsjoom. Ljeiiⁿ ntꞌomcheⁿ naⁿntjom. Ndoꞌ majoꞌti sꞌaaⁿ chaꞌna ndyee na matmaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Manncueeꞌ na ꞌom na matmaaⁿ, tjannaaⁿꞌaⁿ quiiꞌ tsjoom. Mañoomcheⁿ na ljeiiⁿ na cweꞌ mꞌaⁿcheⁿ. Tsoom nda̱a̱na: “¿Chiuu na meiiⁿchaaꞌ xuee ñjaaⁿ mꞌaⁿꞌyoꞌ na tjaa tsꞌiaaⁿ cwilꞌaꞌyoꞌ?” ");
INSERT INTO amuNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Jluena nnoom: “Mayuuꞌ, ee tjaa ꞌñeeⁿ cotsa̱ꞌntjom jâ.” Tsoom nda̱a̱na: “Cwa catsaꞌyoꞌ, nlꞌaꞌyoꞌ tsꞌiaaⁿ ꞌnaⁿya na waa ntjoomya. Ja nntiomlꞌuaya ꞌo chaꞌxjeⁿ na matsonaꞌ.” Ndoꞌ mati tyꞌe naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Quia na jnda̱ tmaaⁿncue tso patrom nnom moso tquiee ꞌnaaⁿꞌaⁿ: “Cwaⁿꞌ naⁿntjommꞌaⁿꞌ ndoꞌ catiomꞌlꞌuaꞌ joona. Cato̱ꞌjndyeeꞌ ñequio joo nnꞌaⁿ na tyꞌequieꞌ na macanda̱. Tcuu cjaanaꞌ hasta nncueeꞌcañoomnaꞌ nnꞌaⁿ na tyꞌequieꞌjndyee.” ");
INSERT INTO amuNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Quia joꞌ tquiontyjaaꞌ nnꞌaⁿ na tyꞌequieꞌ tsꞌiaaⁿ chaꞌna ꞌom na matmaaⁿ. Ticwii cwii joona toꞌñoomna cwii denario chaꞌxjeⁿ na nncwantjom tsꞌaⁿ na cwii xuee. ");
INSERT INTO amuNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ndoꞌ quia tueeꞌcañoomnaꞌ nnꞌaⁿ na tyꞌequieꞌjndyee tsꞌiaaⁿ, jlaꞌtiuuna na joona jndyeti nntaꞌntjomna. Sa̱a̱ mati ticwiindye joona toꞌñoomna cwii denario. ");
INSERT INTO amuNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Jnda̱ na toꞌñoomna sꞌomꞌñeeⁿ to̱ꞌna na tyolaꞌncjooꞌndyena nacjooꞌ patrom ꞌnaaⁿna. ");
INSERT INTO amuNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Jluena: “Joo naⁿmꞌaⁿꞌ na tyꞌequieꞌna tsꞌiaaⁿ na macanda̱, ñecwii hora lꞌana tsꞌiaaⁿ, sa̱a̱ ꞌu ñeꞌcwii xjeⁿ macheꞌ ñꞌeⁿndye joona chaꞌxjeⁿ ñꞌeⁿndyô̱ jâ. Ndoꞌ jâ tyolajnda̱a̱yâ meiiⁿchaaꞌ xuee, tyolaquii nꞌo̱o̱ⁿyâ meiiⁿ jeeⁿ jmeiⁿꞌ nquiuuyâ.” ");
INSERT INTO amuNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Tꞌo̱ patrom nnom cwii joo naⁿꞌñeeⁿ, tsoom: “ꞌU re, tjaaꞌnaⁿ na seitjo̱o̱ndyo̱ njomꞌ. ¿Aa nchii tꞌmaaⁿya ñꞌeⁿndyuꞌ na cwii denario nncwantjomꞌ chaꞌxjeⁿ quitaꞌntjom nnꞌaⁿ? ");
INSERT INTO amuNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Coꞌñomꞌ sꞌom ꞌnaⁿꞌ, cjaꞌtoꞌ waꞌ. Nnco̱ ntyjii xeⁿ ljoꞌyu nntiomlꞌuaya ꞌu ñequio cwiicheⁿ tsaⁿmꞌaaⁿꞌ na teinioomꞌ tjaquieeꞌ tsꞌiaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Aa ticatseitiuuꞌ na wanaaⁿ na nntsꞌaa chaꞌxjeⁿ na lꞌue tsꞌo̱o̱ⁿ ñequio sꞌom ꞌnaⁿya? ¿Aa matseiꞌcandyaꞌ tsꞌomꞌ sꞌom na ja titseintycwiꞌa?” ");
INSERT INTO amuNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Joꞌ chii luaa ñeꞌcaꞌmo̱ⁿ ñꞌoom tjañoomꞌwaaꞌ. Nnꞌaⁿ na ticalaꞌtiuu na tꞌmaⁿ cwiluiindye ljoꞌyu nntseitꞌmaaⁿꞌñe Tyꞌo̱o̱tsꞌom joona chaꞌxjeⁿ matseitꞌmaaⁿꞌñê ntꞌomcheⁿ. Ndoꞌ nnꞌaⁿ na cwilaꞌtiuu nquiee na tꞌmaⁿ cwiluiindye, quia nleitquiooꞌ na ljoꞌyu laꞌxmaⁿna jo nnom Tyꞌo̱o̱tsꞌom ñequio meiⁿnquia nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yocheⁿ na njom Jesús nato na wjaⁿ Jerusalén, tjachom jâ na canchooꞌwendyô̱ cwii ntyja na ñencjo̱o̱yâ. Tsoom nda̱a̱yâ: ");
INSERT INTO amuNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Queⁿꞌyoꞌ cwenta, jeꞌ tsawaaya Jerusalén. Ndoꞌ ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee, joꞌ joꞌ nñequiaa tsꞌaⁿ cwenta ja luee ntyee na cwiluiitquiendye ñequio nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés. Naⁿꞌñeeⁿ nlꞌana na nntꞌuiityeⁿnaꞌ ja na nncꞌio̱. ");
INSERT INTO amuNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nñeꞌquiana cwenta ja luee nnꞌaⁿ na nchii judíos na nlaꞌjnaaⁿꞌ naⁿꞌñeeⁿ ja. Nntjaaꞌna ja ndoꞌ nntyꞌioomna ja tsꞌoomꞌnaaⁿ na nncꞌio̱, sa̱a̱ xuee jnda̱ ndyee nncwando̱ꞌxco̱. ");
INSERT INTO amuNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Scuuꞌ Zebedeo ñequio ntseinaaⁿ Jacobo ñꞌeⁿ Juan tquiolaꞌcandyooꞌndyena na mꞌaaⁿ Jesús. Tcoomꞌm xtyeeⁿ jo nnom na tcaaⁿ cwii naya. ");
INSERT INTO amuNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Tso Jesús nnoom: —¿Ljoꞌ lꞌue tsꞌomꞌ? Tꞌo̱ yuscuꞌñeeⁿ nnom, tsoom: —Quia na nncueꞌntyjo̱ na nntsa̱ꞌntjomꞌ, quiaaꞌ ñꞌomꞌ na we ntseindaaya nmeiiⁿ nluiitꞌmaⁿndyena ñꞌeⁿndyuꞌ. Cwii joona nncꞌoom tsꞌo̱ꞌ ntyjaya ndoꞌ cwiicheⁿ nncꞌoom tsꞌo̱ꞌ ntyjatymaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Sa̱a̱ tꞌo̱ Jesús nda̱a̱ we naⁿꞌñeeⁿ, tsoom: —ꞌO ticalaꞌno̱ⁿꞌyoꞌ ljoꞌ cwitaⁿꞌyoꞌ. Juu nawiꞌ na nncwino̱o̱ⁿ, ¿aa nnda̱a̱ nnaⁿndyoꞌ? Ndoꞌ ¿aa nnda̱a̱ nljoya nꞌomꞌyoꞌ na nncwjeꞌyoꞌ chaꞌxjeⁿ na jnda̱ ljoya tsꞌo̱o̱ⁿ na nncꞌio̱? Tꞌo̱o̱na nnoom, jluena: —Nnda̱a̱. ");
INSERT INTO amuNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jom tsoom nda̱a̱na: —Mayuuꞌ juu nawiꞌ na nncwino̱o̱ⁿya, nncwinomꞌyoꞌ. Ndoꞌ chaꞌxjeⁿ na cwiljoya tsꞌo̱o̱ⁿ na nncꞌio̱ mati macaⁿnaꞌ na caljoya nꞌomꞌyoꞌ na nlaꞌcwjee nnꞌaⁿ ꞌo. Sa̱a̱ titseixmaⁿya na nntseijndaaꞌndyo̱ ꞌñeeⁿ juu nncwacatyeeⁿ ntyjaaꞌa ntyjaya oo ntyjatymaaⁿꞌ. Nquii Tsotya̱ya nñequiaaⁿ nayaꞌñeeⁿ nda̱a̱ joo nnꞌaⁿ na jnda̱ seijndaaꞌñê na nntoꞌñoom juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ndoꞌ cwiicheⁿ quindyô̱ jâ na cwilaꞌjomndyô̱ ñꞌeⁿ Jesús, quia na jndya̱a̱yâ ñꞌoom na tcaⁿ yuscuꞌñeeⁿ, jeeⁿ tyolaꞌwja̱a̱yâ nacjoo we nnꞌaaⁿyâ naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ndoꞌ naljoꞌ, tqueeⁿꞌ Jesús chaꞌtsondyô̱ na mꞌaaⁿ. Tsoom nda̱a̱yâ: —ꞌO manquiuꞌyoꞌ na nquiee nnꞌaⁿ na cwiluiitquiendye cwii cwii ndyuaa cwilaꞌsꞌandyena nda̱a̱ nnꞌaⁿ na cwitsa̱ꞌntjomna. Ndoꞌ nnꞌaⁿ na cwiluiitꞌmaⁿndye cwiqueⁿna xjeⁿ nnꞌaⁿ na mꞌaⁿ nacje ꞌnaaⁿna. ");
INSERT INTO amuNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Sa̱a̱ quiiꞌntaaⁿ ꞌo ticatsonaꞌ na luaaꞌ nlꞌaꞌyoꞌ. Ee meiⁿcwiꞌñeeⁿcheⁿ ꞌo na ntyjaaꞌ tsꞌom na nncꞌoom na tꞌmaⁿñe naquiiꞌ ntaaⁿꞌyoꞌ, tsaⁿꞌñeeⁿ matsonaꞌ na catseixmaaⁿ tsꞌaⁿ na mandiꞌntjom nda̱a̱ ncꞌiaaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ndoꞌ ꞌñeeⁿ cwiindyoꞌ ꞌo na maqueⁿ tsꞌom na nlcoꞌnnomnaꞌ juu jo nda̱a̱ꞌyoꞌ, tsaⁿꞌñeeⁿ matsonaꞌ na cꞌoom chaꞌcwijom moso ꞌnaⁿꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Maluaaꞌ na jndyo̱o̱ ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee. Jndyo̱o̱ na nndiꞌntjo̱ⁿya nda̱a̱ nnꞌaⁿ nchii na nndyeꞌntjom nnꞌaⁿ no̱o̱ⁿ. Ndoꞌ jndyo̱o̱ na nñequiaandyo̱ na cꞌio̱ na nntio̱o̱ⁿya jnaaⁿ nnꞌaⁿ na jndyendye, cha nndyaandyena na nntꞌuii jnaaⁿna joona. ");
INSERT INTO amuNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Quia na saacaluiiꞌâ naquiiꞌ tsjoom Jericó, tquiontyjo̱ cwii tmaaⁿꞌ nnꞌaⁿ naxeⁿꞌ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Joꞌ joꞌ ꞌndyoo nato meindyuaandye we naⁿnchjaaⁿ. Quia na jndyena ñꞌoom na juu Jesús mawinoom joꞌ joꞌ, jlaꞌxuaana, jluena: —ꞌU Ta, na cwiluiindyuꞌ jndacantyjo David, cꞌoomꞌ na wiꞌ tsꞌomꞌ ñꞌeⁿndyô̱ jâ. ");
INSERT INTO amuNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Sa̱a̱ nnꞌaⁿ na mꞌaⁿ joꞌ joꞌ jlaꞌtiaꞌna naⁿnchjaaⁿꞌñeeⁿ. Ñeꞌcalaꞌcheⁿna naⁿꞌñeeⁿ, sa̱a̱ yacheⁿ jndeii tyolaꞌxuaa, jlue: —ꞌU Ta, na cwiluiindyuꞌ jndacantyjo David, cꞌoomꞌ na wiꞌ tsꞌomꞌ ñꞌeⁿndyô̱ jâ. ");
INSERT INTO amuNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Tjameintyjeeꞌ Jesús, tꞌmaaⁿ naⁿꞌñeeⁿ. Tsoom nda̱a̱na: —¿Ljoꞌ lꞌue nꞌomꞌyoꞌ na nntsꞌaaya ꞌo? ");
INSERT INTO amuNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Tꞌo̱o̱ naⁿnchjaaⁿꞌñeeⁿ nnoom, jluena: —Jeeⁿ ꞌu ta, toom cweꞌ nnda̱a̱ nntyꞌiaayâ. ");
INSERT INTO amuNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Quia joꞌ Jesús tyꞌoom na wiꞌ tsꞌoom joona. Tyeⁿnquioomꞌm luaꞌnda̱a̱na. Mañoomꞌ teitquioona. Tyꞌentyjo̱na naxeeⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Quia na jnda̱ teindyo̱o̱ꞌâ Jerusalén, na nndyooꞌ ta na jndyu Olivos, squia̱a̱yâ tsjoom Betfagé. Jñom Jesús we nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Tsoom nda̱a̱na: —Catsaquieꞌyoꞌ tsjoom chjoo ndyeyu jo nda̱a̱ꞌyoꞌ. Joꞌ joꞌ mantyja nliuꞌyoꞌ cwii snomxquie na ñjomyoꞌ, mati ñꞌeⁿ jndayoꞌ. Calacanaⁿꞌyoꞌ, quiochoꞌyoꞌ jooyoꞌ na mꞌaaⁿya ñjaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ndoꞌ xeⁿ nncwaxꞌee tsꞌaⁿ ndyueꞌyoꞌ chiuu na cwitsachoꞌyoꞌ quiooꞌ ntsmeiiⁿꞌeⁿ, luaa canduꞌyoꞌ nnoom: “Nquii Ta tjo̱o̱ñê jooyoꞌ.” Quia joꞌ mañoomꞌ nñequiaa tsꞌaⁿ na nquiochoꞌyoꞌ jooyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Luaaꞌ tuii cha catseicanda̱a̱ꞌñenaꞌ ñꞌoom na seineiⁿ profeta, luaa seiljeiⁿ: ");
INSERT INTO amuNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Canduꞌyoꞌ nda̱a̱ nnꞌaⁿ tsjoom Sión: “Queⁿꞌyoꞌ cwenta macwjeeꞌcañoom nquii rey na cwiluiiñe na matsa̱ꞌntjom ꞌo, ticatseitꞌmaaⁿꞌñe cheⁿnqueⁿ, ee cweꞌ snom waꞌljoom. Snom chjoo, quiooꞌ na maxjeⁿ tsꞌiaaⁿꞌ na nnchuu xuu.” ");
INSERT INTO amuNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Quia joꞌ we naⁿꞌñeeⁿ na cwilaꞌjomndye ñꞌeⁿ Jesús, tyꞌena, lꞌana chaꞌxjeⁿ ñꞌoom na tsoom nda̱a̱na. ");
INSERT INTO amuNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Tquieꞌñꞌomna snomxquieꞌñeeⁿ ñequio jndayoꞌ. Ndoꞌ tioona liaana nanqueⁿꞌ quiooꞌñeeⁿ, chii tjawaꞌljoom. ");
INSERT INTO amuNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Jndyendye nnꞌaⁿ tyꞌeñꞌeeⁿna ñꞌeⁿ Jesús. Ntꞌom naⁿꞌñeeⁿ tyolaꞌnꞌmeiiⁿꞌna liaana tsꞌom nato yuu na wjaⁿ. Ndoꞌ ntꞌom nnꞌaⁿ tyotyje luee nꞌoom, tsa̱ꞌna joonaꞌ tsꞌom nato. ");
INSERT INTO amuNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nnꞌaⁿ na ꞌoojndyee ñequio nnꞌaⁿ na ꞌoontyjo̱ to̱ꞌna tyolaꞌxuaana, tyoluena: —Matseitꞌmaaⁿꞌñenaꞌ nquii rey na cwiluiiñe jndacantyjo David. Matioꞌnaaⁿñenaꞌ nqueⁿ na macwjeeꞌcañoom tsꞌiaaⁿ ꞌnaaⁿꞌ Ta Tyꞌo̱o̱tsꞌom. Matseitꞌmaaⁿꞌñenaꞌ jom nandye cañoomꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Quia na tjaquieeꞌ Jesús Jerusalén jeeⁿ tꞌmaⁿ seitsꞌeiinaꞌ naquiiꞌ nꞌom chaꞌtsondye nnꞌaⁿ tsjoomꞌñeeⁿ. Tyoluena nda̱a̱ ncꞌiaana: —¿ꞌÑeeⁿ tsꞌaⁿ tsaⁿmꞌaaⁿꞌ? ");
INSERT INTO amuNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tꞌo̱o̱ nnꞌaⁿ na ñꞌeeⁿ ñꞌeⁿñê, jluena: —Tsaⁿmꞌaaⁿ jñoom Jesús. Cwiluiiñê profeta na jnaaⁿ tsjoom Nazaret tsꞌo̱ndaa Galilea. ");
INSERT INTO amuNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Tjaquieeꞌ Jesús watsꞌom tꞌmaⁿ, jleintyjo̱o̱ⁿ chaꞌtso nnꞌaⁿ na cwinda̱a̱ ndoꞌ na cwilaꞌjnda ꞌnaⁿ joꞌ joꞌ. Seicantqueeⁿ meiⁿsa ꞌnaaⁿ nnꞌaⁿ na cwilaꞌjndyoondye sꞌom ndoꞌ majoꞌti sꞌaaⁿ ñequio ntsula̱ ꞌnaaⁿ nnꞌaⁿ na cwinda̱a̱ cantuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Tsoom nda̱a̱ naⁿꞌñeeⁿ: —Waa ljeii ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom na matsonaꞌ: “Wꞌaya jndyunaꞌ wꞌaa yuu na cwilaꞌneiⁿ nnꞌaⁿ nnom Tyꞌo̱o̱tsꞌom”, sa̱a̱ ꞌo cwilꞌaꞌyoꞌ juunaꞌ chaꞌcwijom tsueꞌtsjo̱ꞌ yuu na cwicatooꞌndye naⁿcantyꞌue. ");
INSERT INTO amuNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ndoꞌ naⁿnchjaaⁿ ñꞌeeⁿ nnꞌaⁿ na tileicꞌoocaꞌ, tquieꞌcañomna watsꞌom tꞌmaⁿ na mꞌaaⁿ Jesús. Seinꞌmaaⁿ joona. ");
INSERT INTO amuNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Sa̱a̱ ntyee na cwiluiitquiendye ñequio nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés ntyꞌiaana tsꞌiaaⁿ tꞌmaⁿ na matseinꞌmaaⁿ nnꞌaⁿ. Ndoꞌ mati tyondyena na tyolaxuaa yocanchꞌu na tyolue: “Matseitꞌmaaⁿꞌñenaꞌ nquii rey na cwiluiiñe jndacantyjo David.” Quia joꞌ tꞌmaⁿ jlaꞌwjee naⁿꞌñeeⁿ jom. ");
INSERT INTO amuNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Jluena nnoom: —¿Aa ticandiꞌ ljoꞌ cwilue yocanchꞌumꞌaⁿꞌ? Tꞌo̱ Jesús nda̱a̱na, tsoom: —Mandiiya. Ndoꞌ ꞌo, aa tijoom ñejlaꞌnaⁿꞌyoꞌ ljeii ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom na matsonaꞌ: ꞌU jnda̱ seijndaaꞌndyuꞌ na yonchꞌu ñequio yoꞌndaa na ndicwaⁿ cwinteiꞌ joona nlaꞌtꞌmaaⁿꞌndyena ja ñequio na xcweeꞌ nꞌomna. ");
INSERT INTO amuNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Mana ꞌndii Jesús joona, jlueeⁿꞌeⁿ tsjoom Jerusalén, tjaaⁿ tsjoom chjoo Betania. Joꞌ joꞌ ljooꞌñê natsjom. ");
INSERT INTO amuNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Teincoo cwiicheⁿ xuee wjaalcweeⁿꞌeⁿ tsjoom Jerusalén. Jndyo na ñejnoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Ntyꞌiaaⁿꞌaⁿ cwii tsꞌoom higuera na meintyjeeꞌ ꞌndyoo nato. Tjatseicandyooꞌñê sa̱a̱ ljeiiⁿ na meiⁿcwii ta̱ higo tjaa na cantyja, macanda̱ tsco na ntyjoo. Tso Jesús nacjooꞌ tsꞌoomꞌñeeⁿ: —Tajom xuee cwii nntsaꞌnndaꞌ ta̱. Mañoomꞌ tjacaaⁿ tsꞌoom higueraꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ndoꞌ jâ nnꞌaⁿ na cwilajomndyô̱ ñꞌeⁿ Jesús, quia na ntyꞌiaayâ na tuii na luaaꞌ, jeeⁿ tjaweeꞌ nꞌo̱o̱ⁿyâ. Taxꞌa̱a̱yâ nnoom: —¿Chiuu waayuu na mañoomꞌ tjacaaⁿ tsꞌoom higuerawaaꞌ? ");
INSERT INTO amuNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Tꞌo̱ Jesús nda̱a̱yâ, tsoom: —Mayuuꞌcheⁿ nndyeꞌyoꞌ nntsjo̱o̱, xeⁿ na cwilayuꞌya nꞌomꞌyoꞌ ndoꞌ ticꞌomꞌyoꞌ na we waa na cwilaꞌtiuuꞌyoꞌ, nnda̱a̱ nlꞌaꞌyoꞌ chaꞌna sꞌaaya ñꞌeⁿ tsꞌoom higuerawaaꞌ. Ndoꞌ nchii macanda̱ joꞌ sa̱a̱ meiⁿnquia na nquiuꞌyoꞌ na jeeⁿ jndeiꞌnaꞌ nnda̱a̱ nlꞌaꞌyoꞌ. Nntsꞌaanaꞌ chaꞌcwijom na nnduꞌyoꞌ nnom sjo̱waaꞌ: “Quindyo̱ꞌ ñjaaⁿ. Cjuꞌnaꞌ ꞌu tsꞌom ndaaluee,” maxjeⁿ nnda̱a̱ nnaⁿndyoꞌ. Meiiⁿ waa cwii na jeeⁿ jndeiꞌnaꞌ na cwiwinomꞌyoꞌ, hasta matseijomnaꞌ chaꞌna cwii sjo̱ tꞌmaⁿ nquiuꞌyoꞌ sa̱a̱ nnda̱a̱ nnaⁿndyoꞌ ñꞌeⁿ juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ee chaꞌtso na cwitaⁿꞌyoꞌ na cwilaneiⁿꞌyoꞌ nnom Tyꞌo̱o̱tsꞌom, xeⁿ tyeⁿ cwilayuꞌyoꞌ, maxjeⁿ nntoꞌñoomꞌyoꞌ chaꞌxjeⁿ na cwitaⁿꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Tjaquieeꞌnndaꞌ Jesús watsꞌom tꞌmaⁿ. Yocheⁿ na maꞌmo̱o̱ⁿ nda̱a̱ nnꞌaⁿ joꞌ joꞌ, ntyee na cwiluiitquiendye ñequio nnꞌaⁿ na cwiluiitquiendye jo nda̱a̱ nnꞌaⁿ judíos tquiontyjaaꞌna jom. Taꞌxꞌeena nnoom, jluena: —¿ꞌÑeeⁿ najndeii ñꞌeⁿ na macheꞌ na nmeiiⁿꞌ? Ndoꞌ ¿ꞌñeeⁿ juu tquiaa na matseiꞌxmaⁿꞌ najnduꞌ? ");
INSERT INTO amuNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Tꞌo̱ Jesús nda̱a̱ naⁿꞌñeeⁿ, tsoom: —Mati ja nncwaxꞌa̱ya cwii ñꞌoom nda̱a̱ꞌyoꞌ. Xeⁿ nntꞌo̱ꞌyoꞌ juunaꞌ quia joꞌ mati ja nntsjo̱o̱ nda̱a̱ꞌyoꞌ ꞌñeeⁿ juu tquiaa najndo̱ na nmeiiⁿꞌ matsꞌaa. ");
INSERT INTO amuNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Quia joꞌ taxꞌeeⁿ nda̱a̱na, tsoom: —Na tyotseitsꞌoomñe Juan nnꞌaⁿ, ¿yuu jnaⁿ najndeii na tyotseixmaaⁿ? ¿Aa na mꞌaaⁿ Tyꞌo̱o̱tsꞌom jnaⁿnaꞌ oo aa nnꞌaⁿ jlue na ljoꞌ catsꞌaaⁿ? Quia joꞌ to̱ꞌna, tyoꞌmaⁿ cheⁿnquieena ñꞌeⁿ ncꞌiaana, tyoluena: —Jeeⁿ sa ¿chiuu nntꞌo̱o̱yo̱o̱ na luaaꞌ mawaxꞌeeⁿ? Ee xeⁿ nlꞌuuya na jnaⁿnaꞌ cantyja ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom, quia joꞌ majoꞌto nntsoom nda̱a̱ya: “¿Chiuu na tîcalayuꞌyoꞌ ñꞌoom na tso Juan?” ");
INSERT INTO amuNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Sa̱a̱ xeⁿ nlꞌuuya na jnaⁿnaꞌ cweꞌ cantyja ꞌnaaⁿ nnꞌaⁿ, nnda̱a̱ nlcoꞌwiꞌnaꞌ jaa nlꞌa nnꞌaⁿ na jndyendye, ee chaꞌtsondye joona cwilaꞌyuꞌna na Juan cwiluiiñê tsꞌaⁿ na tyoñequiaa ñꞌoomꞌ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Joꞌ chii tꞌo̱o̱na nnom Jesús, jluena: —Jeeⁿ ticaliuuyâ. Tso Jesús nda̱a̱na: —Aa ya, mati ja xocatsjo̱o̱ nda̱a̱ꞌyoꞌ yuu jnaⁿ najndeii na matseixmaⁿya na sꞌaaya nmeiiⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Quia joꞌ tsoti Jesús nda̱a̱ naⁿꞌñeeⁿ: —Cꞌoomꞌ nꞌomꞌyoꞌ cantyja ꞌnaaⁿꞌ ñꞌoomwaa na tjañoomꞌ na manntsjo̱o̱. Tꞌoom cwii tsꞌaⁿ. Tyomꞌaⁿ we ntseinaaⁿ yonom. Tjantyjaaⁿꞌaⁿ tsꞌaⁿ na tuiiñejndyee, tsoom nnom: “ꞌU re jndaaya, cjaꞌ jeꞌ catsaꞌ tsꞌiaaⁿ na waa ntjoomya.” ");
INSERT INTO amuNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Tꞌo̱ tsaⁿꞌñeeⁿ, “Ja, ta, maxjeⁿ ticjo̱.” Sa̱a̱ jnda̱ jeꞌ seichuiiꞌnaꞌ na seitiuu, tja tjacatsꞌaa tsꞌiaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Jnda̱ chii tjantyjaaⁿꞌaⁿ cwiicheⁿ jnaaⁿ. Majoꞌti tsoom nnom tsaⁿ na jnda̱ we. Tꞌo̱ tsaⁿꞌñeeⁿ nnoom: “Aa ya, ta, jo̱ya.” Sa̱a̱ tîcjaa. ");
INSERT INTO amuNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ndoꞌ taxꞌee Jesús, tsoom: —Canduꞌyoꞌ jeꞌ, ¿Cwaaⁿ cwii na wendye joona sꞌaa yuu na lꞌue tsꞌom tsotyena? Jlue naⁿꞌñeeⁿ: —Juu jnaaⁿ na tjantyjaaꞌjñeeⁿ. Quia joꞌ tso Jesús nda̱a̱na: —Mayuuꞌcheⁿ nndyeꞌyoꞌ nntsjo̱o̱, na nquiee naⁿcwitoꞌñoom sꞌom ndoꞌ mati lculjaaꞌ tyuaaꞌti nñeꞌquiandyena na nntsa̱ꞌntjom Tyꞌo̱o̱tsꞌom naquiiꞌ nꞌomna, nchiiti ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ee tyjeeꞌcañoom Juan quiiꞌntaaⁿꞌyoꞌ na tyoñequiaaⁿ ñꞌoom cantyja na matyꞌiomyanaꞌ sa̱a̱ ꞌo maxjeⁿ tîcalaꞌyuꞌyoꞌ ñꞌoom na tyoñequiaaⁿ. Nnꞌaⁿ na cwitoꞌñoom sꞌom ñequio lculjaaꞌ, joona jlaꞌyuꞌna ñꞌoom na tyoñequiaaⁿ. ꞌO tqueⁿꞌyoꞌ cwenta na ljoꞌ sa̱a̱ chaaꞌ lꞌuu lcweꞌ nꞌomꞌyoꞌ na nlayuꞌyoꞌ ñꞌoom na tjeiꞌyuuꞌñê. ");
INSERT INTO amuNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","’Candyeꞌyoꞌ jeꞌ cwiicheⁿ ñꞌoom tjañoomꞌ: Tyomꞌaaⁿ cwii tsꞌaⁿ na tꞌmaⁿ ndyuaaꞌ niom. Tcoomꞌm lꞌo̱o̱ uva. Sꞌaaⁿ tiom ndiocheⁿ. Sꞌaaⁿ peila na nncꞌoocue ndaa na jnda̱ ꞌndiindyena ta̱uva. Mati sꞌaaⁿ cwii tatsiaⁿndye na nljo tsꞌaⁿ na nntsꞌaa cwenta ntjomꞌñeeⁿ. Jnda̱ chii tioom cwenta ntjomꞌñeeⁿ luee nnꞌaⁿ na nlꞌayana tsꞌiaaⁿ. Quia na ncueꞌ ta̱a̱ꞌ ntjom, nncoꞌñoom na tseixmaⁿnaꞌ cwentaaⁿꞌaⁿ. Jnda̱ na seijndaaꞌñê chaꞌtso nmeiⁿꞌ, tjaaⁿ cwiicheⁿ ndyuaa. ");
INSERT INTO amuNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Ndoꞌ quia tueꞌntyjo̱ xjeⁿ na jnda̱ tquie ta̱, jñoom mosoomꞌm na mꞌaⁿ naⁿꞌñeeⁿ na cꞌoocachona ta̱ na tantjom tyuaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Sa̱a̱ nnꞌaⁿ na cwilꞌa tsꞌiaaⁿ joꞌ joꞌ jlaꞌcjaa lueena mosoꞌñeeⁿ. Cwii tsaⁿꞌñeeⁿ tjaaꞌna jom. Cwiicheⁿ tsaⁿꞌñeeⁿ jlacueeꞌna jom. Ndoꞌ cwiicheⁿ tsaⁿ na jnda̱ ndyee tyojñomna ljo̱ꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Quia na jndii patrom na luaaꞌ, majndyeti mosoomꞌm jñomnnaaⁿꞌaⁿ na mꞌaⁿ naⁿꞌñeeⁿ. Sa̱a̱ majoꞌti tjoomna lꞌa naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","’Na cwii macanda̱ jñoom jnda nqueⁿ ee seitioom naquiiꞌ tsꞌoom: “Tiꞌjndaaya luaa, nlaꞌtꞌmaaⁿꞌndyena juu.” ");
INSERT INTO amuNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Sa̱a̱ nnꞌaⁿ na cwilꞌa tsꞌiaaⁿ quia ntyꞌiaana jnda nquii patromꞌñeeⁿ, jluena nda̱a̱ ncꞌiaana: “Luaaꞌ jnda nquii patrom. Tsaⁿmꞌaaⁿꞌ nnaaⁿꞌaⁿ tyuaawaa. Cwa nlacua̱a̱ꞌa jom cha nljo ꞌnaaⁿꞌaⁿ lua̱a̱ jaa.” ");
INSERT INTO amuNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ndoꞌ tꞌuena jom, tjeiiꞌna jom nnom ntjom. Joꞌ joꞌ jlaꞌcueeꞌna jom. ");
INSERT INTO amuNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Quia joꞌ taxꞌee Jesús nda̱a̱ naⁿꞌñeeⁿ, tsoom: —Quia na nncwjeeꞌnndaꞌ nquii tsꞌaⁿ na ꞌnaaⁿꞌ ntjomꞌñeeⁿ, ¿ljoꞌ cwilatiuuꞌyoꞌ na nntsꞌaaⁿ ñequio nnꞌaⁿ na cwilꞌa tsꞌiaaⁿ nnom tyuaaⁿꞌaⁿ? ");
INSERT INTO amuNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Jluena nnoom: —Xocꞌoom na wiꞌ tsꞌoom naⁿꞌñeeⁿ, maxjeⁿ nntseicwjeⁿ naⁿꞌñeeⁿ na jeeⁿ tia nnꞌaⁿndyena. Ndoꞌ nñequiaaⁿ ntjoomꞌm luee ntꞌomcheⁿ nnꞌaⁿ na joo nñeꞌquia na tantjom tyuaaⁿꞌaⁿ quia na nncueꞌ ntjom. ");
INSERT INTO amuNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Quia joꞌ seineiⁿti Jesús nda̱a̱ naⁿꞌñeeⁿ cwii ñꞌoom na seijoomꞌñe cheⁿnqueⁿ na tsjo̱ꞌ na ya jom. Tsoom: —¿Aa tijoom ñejlaꞌnaⁿꞌyoꞌ ljeii ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom na matsonaꞌ?: Majuuto tsjo̱ꞌ na tixocwilꞌue nquiu luañe na cwilꞌa tsiaⁿtsjo̱ꞌ, jnda̱ mawacatyeeⁿnaꞌ nqui tsiaⁿtsjo̱ꞌ. Nquii Ta Tyꞌo̱o̱tsꞌom seijndaaꞌñê na ljoꞌ. Ndoꞌ jeeⁿ cwijaaweeꞌ nꞌo̱o̱ⁿya na cwintyꞌiaaya na luaaꞌ tuii. ");
INSERT INTO amuNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Joꞌ chii candyeꞌyoꞌ nntsjo̱o̱, juu na laxmaⁿꞌyoꞌ cantyja ꞌnaaⁿꞌ na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom, nncwjeeⁿꞌeⁿ nayaꞌñeeⁿ lueeꞌyoꞌ, ndoꞌ nñequiaaⁿ na ntꞌomcheⁿ nnꞌaⁿ nlaxmaⁿna juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ndoꞌ mati cantyja ꞌnaaⁿꞌ tsjo̱ꞌwaaꞌ na seina̱ⁿya nda̱a̱ꞌyoꞌ, meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na tileicatseiꞌno̱ⁿꞌ cantyja ꞌnaⁿya, nlcoꞌwiꞌnaꞌ tsaⁿꞌñeeⁿ chaꞌcwijom tsꞌaⁿ na toomñe na tiooñe nacjooꞌ tsjo̱ꞌ. Sa̱a̱ tsꞌaⁿ na tiñeꞌcatseiyuꞌ ñꞌeⁿndyo̱ maxjeⁿ nlcoꞌwiꞌnaꞌ jom quia na nncueꞌntyjo̱ xjeⁿ na nncuꞌxeⁿ Tyꞌo̱o̱tsꞌom nnꞌaⁿ. Quia joꞌ nntseijomnaꞌ tsaⁿꞌñeeⁿ chaꞌcwijom tsꞌaⁿ na tioo cwii tsjo̱ꞌ tꞌmaⁿ nacjooꞌ na seitiuujnda̱a̱naꞌ juu. ");
INSERT INTO amuNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Ndoꞌ ntyee na cwiluiitquiendye ñequio nnꞌaⁿ fariseos, jnda̱ na jndyena ñꞌoom tjañoomꞌmeiⁿꞌ na seineiⁿ Jesús, jlaꞌno̱ⁿꞌna na cantyja ꞌnaaⁿna tjeiiⁿꞌeⁿ ñꞌoomwaaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Joꞌ chii seijmeiⁿꞌnaꞌ joona na ñeꞌcatꞌuena jom. Sa̱a̱ nquiaana nnꞌaⁿ na jndyendye. Ee naⁿꞌñeeⁿ cwitjeiiꞌna cwenta na jom cwiluiiñê profeta. ");
INSERT INTO amuNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Cwiicheⁿ cwii ndiiꞌ seineiⁿnndaꞌ Jesús nda̱a̱ ntyee na cwiluiitquiendye ñequio nda̱a̱ nnꞌaⁿ fariseos. Tsoom nda̱a̱na: ");
INSERT INTO amuNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Juu na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom nandye cañoomꞌluee, matseijomnaꞌ juunaꞌ chaꞌna cwii rey na tꞌmaⁿ xuee sꞌaa na ncoco tiꞌjnda. ");
INSERT INTO amuNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Jñoom mosoomꞌm na ꞌoocaꞌmaⁿna chaꞌtso nnꞌaⁿ na jnda̱ jndye na nnquiolaꞌjomndye. Sa̱a̱ naⁿꞌñeeⁿ tiñeꞌquiontyjaaꞌna. ");
INSERT INTO amuNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Jñomnnaaⁿꞌaⁿ ntꞌomcheⁿ mosoomꞌm, tsoom nda̱a̱na: “Canduꞌyoꞌ nda̱a̱ nnꞌaⁿ na jnda̱ tꞌmaaⁿyâ na nlaꞌjomndyena na jnda̱ maya waa. Jnda̱ seicwja̱ quiooꞌndyo ñequio ntꞌom quiooꞌ na jnda̱ seicaꞌma̱ⁿ. Chaꞌtso jnda̱ teiñꞌoomꞌ, joꞌ chii quiona na nlaꞌjomndyena na macoco tiꞌjndaaya.” ");
INSERT INTO amuNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Sa̱a̱ naⁿꞌñeeⁿ na tyꞌecwaⁿ mosoomꞌm tîcalanꞌoomꞌndyena jom. Tyꞌena tsꞌiaaⁿ ꞌnaaⁿna. Cwii tsaⁿꞌñeeⁿ tjaaⁿ ranchoomꞌm. Cwiicheⁿ tsaⁿꞌñeeⁿ tjaaⁿ, tjacajna̱a̱ⁿ ꞌnaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ndoꞌ ntꞌom naⁿꞌñeeⁿ tꞌuena mosoomꞌm, cwajndii tjaaꞌna joo hasta jlaꞌcwjeena mosoꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Jnda̱ na jndii reyꞌñeeⁿ chiuu tjoom mosoomꞌm jeeⁿcheⁿ ndyaaꞌ seiliooꞌñê. Jñoom sondaro ꞌnaaⁿꞌaⁿ na cꞌoolaꞌcwjee nnꞌaⁿ na lꞌa nata̱ꞌ mosoomꞌm. Ndoꞌ nlaꞌcona tsjoom naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ndoꞌ tsoom nda̱a̱ ntꞌom mosoomꞌm: “Jnda̱ teijndaaꞌya chaꞌtso cantyja na nleitꞌmaaⁿꞌ na nncoco tiꞌjndaaya sa̱a̱ nnꞌaⁿ na jnda̱ tqua̱a̱ⁿꞌa na nlaꞌjomndye ñꞌeⁿndyo̱, tacatsonaꞌ na cwii nntseitꞌmaaⁿꞌndyo̱ joona. ");
INSERT INTO amuNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Jeꞌ catsaꞌyoꞌ nqui nantaa ntꞌmaⁿ, joꞌ joꞌ caꞌmaⁿꞌyoꞌ ticwii cwii tsꞌaⁿ na nliuꞌyoꞌ, canduꞌyoꞌ nda̱a̱na na quiontyjaaꞌna ja na macoco tiꞌjndaaya.” ");
INSERT INTO amuNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Quia joꞌ jluiꞌ mosoꞌñeeⁿ tyoꞌoona nqui nantaa. Jlaꞌtjomna chaꞌtso nnꞌaⁿ na jliuna. Ñꞌeeⁿ nnꞌaⁿ na tia nnꞌaⁿndye ndoꞌ ñꞌeeⁿ nnꞌaⁿ na ya nnꞌaⁿndye. Ndoꞌ laaꞌtiꞌ seicatooꞌnaꞌ wꞌaa ñequio nnꞌaⁿ na jlaꞌjomndye na toco jnda reyꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","’Jnda̱ chii tjaquieeꞌ rey quiiꞌntaaⁿ nnꞌaⁿ na nncwaaⁿ joona. Ljeiiⁿ ñꞌeⁿ cwii tsꞌaⁿ na ticwee liaa chaꞌxjeⁿ liaa cwicweeꞌ nnꞌaⁿ na cwilaꞌjomndye quia na macoco tsꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Tsoom nnom tsaⁿꞌñeeⁿ: “ꞌU re, ¿chiuu tuiiyuu na jndyoꞌtseiꞌjomndyuꞌ ndoꞌ ticweꞌ liaa chaꞌxjeⁿ na cwicweeꞌ nnꞌaⁿ quia na macoco tsꞌaⁿ?” Sa̱a̱ tîcanda̱a̱ nncꞌo̱ tsaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Quia joꞌ nquii rey tsoom nda̱a̱ mosoomꞌm: “Calatyeⁿꞌyoꞌ ncꞌeeⁿ ñequio lꞌo̱o̱ⁿ. Catjeiꞌyoꞌ jom chꞌeⁿ yuu na jaaⁿñe. Joꞌ joꞌ nntyꞌioom ndoꞌ nneiⁿnqueeⁿ ndeiꞌnꞌoom.” ");
INSERT INTO amuNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Seintycwii Jesús ñꞌoom, luaa tsoom: —Majndyendye nnꞌaⁿ mꞌaⁿ na macwaⁿ Tyꞌo̱o̱tsꞌom, sa̱a̱ tijndye nnꞌaⁿ na macwjiiꞌñê cwentaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Quia joꞌ tyꞌe nnꞌaⁿ fariseos, tyoꞌmaⁿ cheⁿnquieena chiuu ya nlꞌana na nncꞌomna jom ñequio ñꞌoom na matseineiiⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Joꞌ chii jñoomna nnꞌaⁿ ꞌnaaⁿna ñequio ntꞌom nnꞌaⁿ ꞌnaaⁿꞌ Herodes na cꞌootaꞌjndoondyena Jesús. Tyꞌe naⁿꞌñeeⁿ, jluena: —ꞌU Maestro, manquiuuyâ na ꞌu tsꞌaⁿ na xcweeꞌ tsꞌomꞌ, ndoꞌ tiquiquiuꞌnnꞌaⁿꞌ ñꞌoom na maꞌmo̱o̱ⁿꞌ cantyja ꞌnaaⁿꞌ natooꞌ Tyꞌo̱o̱tsꞌom. Ndoꞌ mati meiⁿ tjaa na cochꞌeenaꞌ ꞌu ljoꞌ cwilaꞌtiuu nnꞌaⁿ oo meiⁿljoꞌcheⁿ na cwiluiindyena. ");
INSERT INTO amuNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Catsuꞌ nndya̱a̱yâ. Chiuu matseiꞌtiuuꞌ: ¿Aa matyꞌiomnaꞌ na catio̱o̱ⁿya tsꞌiaaⁿnda̱a̱ya nnom tsaⁿmatsꞌiaaⁿ tꞌmaⁿ tsjoom Roma, oo aa ticatyꞌiomnaꞌ? ");
INSERT INTO amuNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Sa̱a̱ Jesús seiꞌno̱o̱ⁿꞌo̱ⁿ natia na cwilaꞌtiuuna. Tsoom nda̱a̱na: —¿Chiuu na ñeꞌcalꞌaꞌyoꞌ xjeⁿ ja, ꞌo nnꞌaⁿ na tixcwe cwitsamꞌaⁿꞌyoꞌ? ");
INSERT INTO amuNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Catꞌmo̱ⁿꞌyoꞌ no̱o̱ⁿ tsjo̱ꞌñjeeⁿ na cwitiomꞌyoꞌ tsꞌiaaⁿnda̱a̱ꞌyoꞌ. Quia joꞌ tjeiiꞌna cwii denario, tꞌmo̱o̱ⁿna juunaꞌ nnoom. ");
INSERT INTO amuNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jnda̱ na ntyꞌiaaⁿꞌaⁿ, tsoom nda̱a̱na: —¿ꞌÑeeⁿ ꞌndyoonnom ñoom nacjooꞌ tsjo̱ꞌñjeeⁿwaa ndoꞌ ꞌñeeⁿ xueeꞌ ljeiimeiiⁿ? ");
INSERT INTO amuNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Tꞌo̱o̱na nnoom, jluena: —ꞌNdyoonnom tsaⁿmatsꞌiaaⁿ luaaꞌ ndoꞌ xueⁿꞌeⁿ ñoom. Quia joꞌ tso Jesús nda̱a̱na: —Catiomꞌyoꞌ tsꞌiaaⁿnda̱a̱ꞌyoꞌ nnom tsaⁿmatsꞌiaaⁿ yuu na tseixmaⁿnaꞌ na nncoꞌñoom. Ndoꞌ quiaꞌyoꞌ cwentaaꞌ Tyꞌo̱o̱tsꞌom yuu na tseixmaⁿnaꞌ cwentaaꞌ nqueⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Jnda̱ na jndyena na luaaꞌ, jeeⁿcheⁿ ndyaaꞌ tjaweeꞌ nꞌomna. Mana ꞌndyena jom, tyꞌena. ");
INSERT INTO amuNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mañejuu xueeꞌñeeⁿ tquieꞌcañom nnꞌaⁿ saduceos na mꞌaaⁿ Jesús. Nnꞌaⁿ saduceos cwilaꞌyuꞌtyeⁿna na xocatandoꞌnndaꞌ nnꞌaⁿ na jnda̱ tja̱. Joꞌ chii jluena cwii ñꞌoom nnoom: ");
INSERT INTO amuNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—ꞌU Maestro, waa ñꞌoom na ꞌndii Moisés lua̱a̱ya na matsonaꞌ xeⁿ tueꞌ cwii tsaⁿsꞌa ndoꞌ tjaaꞌnaⁿ ntseinaaⁿ, quia joꞌ tyjee tsꞌooꞌñeeⁿ cocoom ñꞌeⁿ scuuꞌ xioom. Nncꞌom ntseinaaⁿ ñꞌeⁿ yuscuꞌñeeⁿ cha nntseinoomñê na tjaa ntseinda xioom tꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ndoꞌ quiiꞌntaaⁿ jâ tyomꞌaⁿ ntquieeꞌ naⁿnom na ñenquii tsꞌaⁿ ntseinda. Juu tsaⁿtquiee tocoom, ndoꞌ tyuaaꞌ tueeⁿꞌeⁿ. Tjaaꞌnaⁿ ntseinaaⁿ ñꞌeⁿ scoomꞌm. Quia joꞌ ljoñe scoomꞌm lꞌo̱ tiꞌtyjeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Sa̱a̱ majoꞌti tjom tsꞌaⁿ na jnda̱ we, tjaaꞌnaⁿ ndana ñꞌeⁿ yuscuꞌñeeⁿ ndoꞌ tueeⁿꞌeⁿ. Mati tjom tsꞌaⁿ na jnda̱ ndyee ndoꞌ malaaꞌtiꞌ hasta tsꞌaⁿ na jnda̱ ntquieeꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ndoꞌ jnda̱ tja̱ chaꞌtsondye naⁿꞌñeeⁿ mati tueꞌ yuscu. ");
INSERT INTO amuNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Joꞌ na ñeꞌcataꞌxꞌa̱a̱yâ njomꞌ, Ta, quia na nntandoꞌxco nnꞌaⁿ na jnda̱ tja̱, ¿cwaaⁿ cwii na ntquieeꞌndye joona scuuꞌ jom? Ee jom ñetꞌoom scuu chaꞌtsondye naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Tso Jesús nda̱a̱na: —ꞌO tixcwe cwitjeiꞌyoꞌ cwenta, ee meiiⁿ na cwilaꞌnaⁿꞌyoꞌ ljeii ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom na waa sa̱a̱ ticalaꞌno̱ⁿꞌyoꞌ ljoꞌ maꞌmo̱ⁿnaꞌ meiⁿ cantyja ꞌnaaⁿꞌ najndeii na matseixmaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ee quia na nntandoꞌxco nnꞌaⁿ na jnda̱ tja̱, taxocunconndaꞌna, meiⁿ naⁿnom, meiⁿ naⁿlcu. Ee quia joꞌ nlaꞌxmaⁿna chaꞌna ángeles na mꞌaⁿ cañoomꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ndoꞌ cantyja ꞌnaaⁿꞌ na nntandoꞌxco nnꞌaⁿ na jnda̱ tja̱, ¿aa tijoom ñejlaꞌnaⁿꞌyoꞌ ljeii ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom? Luaa matsoom: ");
INSERT INTO amuNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Ja cwiluiindyo̱ Tyꞌo̱o̱tsꞌom cwentaaꞌ Abraham, ndoꞌ Isaac, ndoꞌ Jacob.” Joꞌ chii caliuꞌyoꞌ na cwitaꞌndoꞌ naⁿꞌñeeⁿ ee jom cwiluiiñê Tyꞌo̱o̱tsꞌom cwentaa nnꞌaⁿ na cwitaꞌndoꞌ, nchii cwentaa lꞌoo. ");
INSERT INTO amuNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Ndoꞌ nnꞌaⁿ na jndyendye, quia na jndyena ñꞌoommeiⁿꞌ na tꞌmo̱o̱ⁿ, jeeⁿ tjaweeꞌ nꞌomna. ");
INSERT INTO amuNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Jnda̱ na jndye nnꞌaⁿ fariseos na jnda̱ seicheⁿ Jesús nnꞌaⁿ saduceos, quia joꞌ jlaꞌtjomndyena. ");
INSERT INTO amuNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ndoꞌ cwiindye joona, tsꞌaⁿ na maꞌmo̱ⁿ ljeii na tqueⁿ Moisés taꞌxꞌeeⁿ cwii ñꞌoom nnom Jesús cha catꞌuiinaꞌ juu. Tsoom: ");
INSERT INTO amuNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—ꞌU Maestro, naquiiꞌ ljeii ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom na tqueⁿ Moisés, ¿cwaaⁿ ñꞌoom na tꞌmati cwiluiiñenaꞌ? ");
INSERT INTO amuNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Tꞌo̱ Jesús nnom tsaⁿꞌñeeⁿ, tsoom: —“Cꞌoomꞌ na candyaꞌ tsꞌomꞌ Ta Tyꞌo̱o̱tsꞌom cwentaꞌ, ñequio na xcweeꞌya tsꞌomꞌ, ñequio chaꞌwaa na jnda ntyjiꞌ, ndoꞌ ñequio chaꞌwaa na jndo̱ꞌya tsꞌomꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ñꞌoomwaaꞌ jndati tseixmaⁿnaꞌ ndoꞌ tꞌmaⁿti matsa̱ꞌntjomnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ndoꞌ ñꞌoom na jnda̱ we matseijomnaꞌ ñꞌoomꞌñeeⁿ, luaa matsonaꞌ: “Cꞌoomꞌ na wiꞌ tsꞌomꞌ xꞌiaꞌ chaꞌxjeⁿ na jnda ntyjiꞌ ñequio nncuꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","We ñꞌoommeiⁿꞌ laxmaⁿnaꞌ xꞌee chaꞌtso ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na tqueⁿ Moisés ñequio ñꞌoom na tyoñeꞌquia profetas. ");
INSERT INTO amuNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Yocheⁿ na tyootꞌoomꞌndye nnꞌaⁿ fariseos, taxꞌee Jesús cwii ñꞌoom nda̱a̱na. ");
INSERT INTO amuNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Tsoom: —¿Chiuu cwilaꞌno̱ⁿꞌyoꞌ cantyja ꞌnaaⁿꞌ nquii na cwiluiiñe Cristo? ¿ꞌÑeeⁿ jnda jom? Tꞌo̱o̱na nnoom, jluena: —Nluiiñê tsjaaⁿ David na jndyowicantyjooꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Tsoom nda̱a̱na: —Mayuuꞌ. Ndoꞌ nquii David, ncꞌe na tꞌmo̱ⁿ Espíritu Santo naquiiꞌ tsꞌoom seiljeiⁿ cwii ñꞌoom cantyja ꞌnaaⁿꞌ Cristo. Tsoom na juu cwiluiiñe na matsa̱ꞌntjom jom. ¿Ljoꞌ maꞌmo̱ⁿnaꞌ na luaaꞌ tsoom? ee seiljeiⁿ: ");
INSERT INTO amuNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Nquii Ta Tyꞌo̱o̱tsꞌom tsoom nnom juu Ta na matsa̱ꞌntjom ja: “Cajmaⁿꞌ ntyjaaꞌa ntyjaya yuu na matseitꞌmaaⁿꞌñenaꞌ ꞌu hasta xjeⁿ na jnda̱ tsa̱ꞌa nnꞌaⁿ na jndoo ꞌu na cꞌomna nacje ꞌnaⁿꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ncꞌe na luaaꞌ matso ljeiiꞌñeeⁿ, joꞌ mawaxꞌa̱ya nda̱a̱ꞌyoꞌ: “¿Chiuu waayuu na cwiluiiñe Cristo tsjaaⁿ David na jndyowicantyjooꞌ ee manquiiti David tsoom na juu cwiluiiñe Ta na matsa̱ꞌntjom jom?” ");
INSERT INTO amuNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Sa̱a̱ meiⁿcwiindye joona tîcanda̱a̱ nncꞌo̱ ꞌñom meiⁿ ñeꞌcwii ꞌndyoo ñꞌoom. Ndoꞌ xuee na tja tjatinaꞌ meiⁿcwii tsꞌaⁿ tîcanda̱a̱ꞌ tsꞌom na nncwaxꞌeeti ñꞌoom ꞌñom. ");
INSERT INTO amuNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Quia joꞌ seineiⁿ Jesús nda̱a̱ nnꞌaⁿ na jndyendye ñequio nda̱a̱ jâ nnꞌaⁿ na cwilajomndyô̱ ñꞌeⁿñê, tsoom: ");
INSERT INTO amuNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—Nquiee nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés ñequio nnꞌaⁿ fariseos toꞌñoomna tsꞌiaaⁿ na ñeseixmaⁿ Moisés na cwitꞌmo̱o̱ⁿna ljeii ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom na matsa̱ꞌntjomnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Joꞌ chii queⁿꞌyoꞌ cwenta ñꞌoom na cwitꞌmo̱o̱ⁿna. Ndoꞌ calꞌaꞌyoꞌ chaꞌtso na cwitsa̱ꞌntjomna na calꞌaꞌyoꞌ. Sa̱a̱ tintsantyjo̱ꞌyoꞌ chaꞌna cwilꞌana, ee joona ya ñꞌoom cwiñeꞌquiana sa̱a̱ nquieena ñoomñoom na cwilꞌana. ");
INSERT INTO amuNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ee joona cwiqueⁿna ñꞌoom na jndeiꞌnaꞌ na catseicanda̱a̱ꞌñe tsꞌaⁿ. Matseijomnaꞌ chaꞌcwijom cwilaꞌtyeⁿna cwii xuu na jaaꞌ na cwitioona cantyaꞌ naⁿꞌñeeⁿ. Sa̱a̱ nquieena nchaaꞌ lꞌuu nntiiꞌndyena meiiⁿ ñeꞌcwii nda̱a̱ lueena na nnteiꞌjndeiina naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Chaꞌtso na cwilꞌana lꞌue nꞌomna na cantyꞌiaa nnꞌaⁿ. Ee cwilꞌana na jeeⁿ ntmeiⁿ ntjaⁿ na chuuꞌ ljeii ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom na cwiwityeⁿ cantaana ñequio lueena. Ndoꞌ mati teincooti nmaⁿ ꞌndyoo liaateincoo na cwicweeꞌna nchiiti liaa ntꞌomcheⁿ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Cwiqueⁿ nꞌomna na nquieena nncwindyuaandyena nacañoomticheⁿ quia na cwiweeꞌ ncuee. Ndoꞌ naquiiꞌ lanꞌom cwilaꞌyuunda̱a̱na ntsula̱ nacañoomcheⁿ yuu na nntseitꞌmaaⁿꞌñetinaꞌ joona. ");
INSERT INTO amuNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Jeeⁿ cjaaweeꞌ nꞌomna na nlaꞌtꞌmaaⁿꞌndye nnꞌaⁿ joona quia cwiwincwindyena tsꞌom nataa yuu na jndooꞌ nnꞌaⁿ. Ndoꞌ lꞌue nꞌomna na nlue nnꞌaⁿ na maestro joona. ");
INSERT INTO amuNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","’Sa̱a̱ ꞌo ticalꞌueendyoꞌ na nlue nnꞌaⁿ na maestro ꞌo ee chaꞌtsondyoꞌ ñecwii tmaaⁿꞌ cwilaxmaⁿꞌyoꞌ ndoꞌ ñecwii na cwiluiiñe Maestro ꞌnaⁿꞌyoꞌ, juu Cristo. ");
INSERT INTO amuNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Meiⁿcwii tsꞌaⁿ tsjoomnancue ticalatꞌmaaⁿꞌndyoꞌ na nnduꞌyoꞌ nnom na tsotyeꞌyoꞌ juu chaꞌna quinduꞌyoꞌ na Tsotyeꞌyoꞌ Tyꞌo̱o̱tsꞌom. Ee ñeꞌcwii mꞌaaⁿ na cwiluiiñe Tsotyeꞌyoꞌ, nqueⁿ na mꞌaaⁿ cañoomꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ndoꞌ meiⁿ tiñeꞌquiandyoꞌ na nlue nnꞌaⁿ na ꞌo cwitsajndyeeꞌyoꞌ ee ñecwii mꞌaaⁿ na wjaajndyee jo nda̱a̱ꞌyoꞌ, nquii Cristo. ");
INSERT INTO amuNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Juu tsꞌaⁿ na cwiluiitꞌmaⁿñeti quiiꞌntaaⁿꞌyoꞌ, tsaⁿꞌñeeⁿ maxjeⁿ matsonaꞌ na candiꞌntjoom nda̱a̱ꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na matseiwendyeñe cheⁿnquii, maxjeⁿ nntseiquioo Tyꞌo̱o̱tsꞌom juu. Ndoꞌ ꞌñeeⁿ juu na majuꞌñecje, maxjeⁿ nntseiwe Tyꞌo̱o̱tsꞌom tsaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","’ꞌO nnꞌaⁿ fariseos ñꞌeⁿ ꞌo nnꞌaⁿ na cwitꞌmo̱ⁿꞌyoꞌ ljeii na tqueⁿ Moisés, nntꞌuiiwiꞌnaꞌ ꞌo cweꞌ cwilꞌaꞌyaꞌyoꞌ na jeeⁿ ya nnꞌaⁿndyoꞌ ee cwilaꞌñꞌeeⁿꞌndyoꞌ nnꞌaⁿ cha xocanda̱a̱ nncꞌooquieeꞌndyena cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. Ncjoꞌyoꞌ tiñeꞌcatsaquieeꞌndyoꞌ na jom nntsa̱ꞌntjoom ꞌo, meiⁿ tiñeꞌquiaꞌyoꞌ na nncꞌooquieeꞌndye ntꞌom ncꞌiaꞌyoꞌ cantyja na matsa̱ꞌntjoom. ");
INSERT INTO amuNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","’ꞌO nnꞌaⁿ fariseos ñꞌeⁿ ꞌo nnꞌaⁿ na cwitꞌmo̱ⁿꞌyoꞌ ljeii na tqueⁿ Moisés, nntꞌuiiwiꞌnaꞌ ꞌo ee cweꞌ cwilꞌaꞌyaꞌyoꞌ na jeeⁿ ya nnꞌaⁿndyoꞌ. ꞌO mantyjo̱ꞌyoꞌ ꞌnaaⁿ lꞌoo na cweꞌ ñeꞌcatjeiꞌtoꞌyoꞌ luee yolcu na jnda̱ tja̱ sꞌaa. Sa̱a̱ majuu xjeⁿꞌñeeⁿ teincoo ñꞌoom cwilaneiⁿꞌyoꞌ nnom Tyꞌo̱o̱tsꞌom cha ticaꞌmo̱ⁿnaꞌ na wiꞌndyoꞌ. Cweꞌ joꞌ na tꞌmaⁿti nlcoꞌwiꞌnaꞌ ꞌo quia na nncuꞌxeeⁿ ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","’ꞌO nnꞌaⁿ fariseos ñꞌeⁿ ꞌo nnꞌaⁿ na cwitꞌmo̱ⁿꞌyoꞌ ljeii na tqueⁿ Moisés, nntꞌuiiwiꞌnaꞌ ꞌo ee cweꞌ cwilꞌaꞌyaꞌyoꞌ na jeeⁿ ya nnꞌaⁿndyoꞌ. ꞌO jeeⁿ tquia maꞌnomꞌyoꞌ hasta ndaaluee cwiwityꞌiooꞌyoꞌ na cwilꞌueꞌyoꞌ meiiⁿ ñeꞌcwii tsꞌaⁿ na nntseijomñe ñꞌeⁿndyoꞌ. Ndoꞌ xeⁿ jnda̱ jnda̱a̱ lꞌaꞌyoꞌ na wjaantyjo̱o̱ⁿ chaꞌna cwilꞌaꞌyoꞌ quia joꞌ wjaañꞌoomnaꞌ jom na cwajndiiti nntsꞌaaⁿ. Ndoꞌ na ljoꞌ, tꞌmaⁿti nlcoꞌwiꞌnaꞌ jom quiiꞌ bꞌio, nchiiti ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","’Ndoꞌ ꞌo nnꞌaⁿ na cwitꞌmo̱ⁿꞌyoꞌ nda̱a̱ ncꞌiaaꞌyoꞌ, mati nntꞌuiiwiꞌnaꞌ ꞌo ee laxmaⁿꞌyoꞌ chaꞌcwijom nchjaaⁿꞌyoꞌ. Cwinduꞌyoꞌ tityeⁿ ñꞌoom na maqueⁿtyeⁿ tsꞌaⁿ nacjoomꞌm quia na macwjeeⁿꞌeⁿ xueeꞌ watsꞌom tꞌmaⁿ. Sa̱a̱ tyeⁿti ñꞌoom na nncwjiꞌ tsꞌaⁿ xueeꞌ sꞌom cajaⁿ na ñꞌeⁿ teichjoomnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ꞌO jeeⁿcheⁿ ndyaaꞌ ntjeiⁿndyoꞌ, laxmaⁿꞌyoꞌ nnꞌaⁿ na nchjaaⁿꞌyoꞌ. ¿Cwaaⁿ cwii na we nmeiⁿꞌ tꞌmaⁿti tseixmaⁿnaꞌ? ¿Aa sꞌom cajaⁿ na ñꞌeⁿ teichjoom watsꞌom oo aa nquii watsꞌom? Juu watsꞌom tꞌmaⁿti tseixmaⁿnaꞌ ee cantyja ꞌnaaⁿꞌ juunaꞌ maqueⁿljuꞌnaꞌ sꞌom cajaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Mati cwinduꞌyoꞌ na tityeⁿ ñꞌoom na cweꞌ xueeꞌ tio naquiiꞌ watsꞌom nncwjiꞌ tsꞌaⁿ. Tyeⁿti ñꞌoom cwinduꞌyoꞌ quia na nncwjiꞌ tsꞌaⁿ xueeꞌ seii quiooꞌ na cwitioo nnꞌaⁿ joꞌ joꞌ cwentaaꞌ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ꞌO jeeⁿcheⁿ nchjaaⁿꞌyoꞌ. ¿Cwaaⁿ na we nmeiⁿꞌ tꞌmaⁿti tseixmaⁿnaꞌ? ¿Aa seii quiooꞌ na cwitioo nnꞌaⁿ nacjooꞌ tio, oo aa juu tio? Tꞌmaⁿti tseixmaⁿ nquii tio yuu na cwicantyjo seiꞌñeeⁿ ee ncꞌe juunaꞌ maqueⁿljuꞌnaꞌ seiꞌ na nnda̱a̱ nncoꞌñom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ee tsꞌaⁿ na maqueⁿtyeⁿ cwii ñꞌoom nacjooꞌ nquii na macwjiꞌ xueeꞌ tio naquiiꞌ watsꞌom tꞌmaⁿ, nchii macanda̱ cantyja ꞌnaaⁿꞌ tioꞌñeeⁿ maqueⁿtyeⁿ ñꞌoom, maxjeⁿ mawꞌatꞌmaⁿtonaꞌ chaꞌtso ꞌnaⁿ na cwicantyjo nacjooꞌnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ndoꞌ juu tsꞌaⁿ na maqueⁿtyeⁿ cwii ñꞌoom nacjooꞌ nquii na macwjiꞌ xueeꞌ watsꞌom tꞌmaⁿ, nchii macanda̱ cantyja ꞌnaaⁿꞌ juunaꞌ maqueⁿtyeⁿ ñꞌoom, maxjeⁿ mañꞌoomnaꞌ nquii Tyꞌo̱o̱tsꞌom ee jom macꞌeeⁿ joꞌ joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ndoꞌ juu tsꞌaⁿ na maqueⁿtyeⁿ cwii ñꞌoom nacjooꞌ nquii na macwjiꞌ xueeꞌ cañoomꞌluee nchii macanda̱ cweꞌ cantyja ꞌnaaⁿꞌ cañoomꞌluee maqueⁿtyeⁿ ñꞌoom, maxjeⁿ mañꞌoomnaꞌ nquii Tyꞌo̱o̱tsꞌom ñequio tio yuu na mawacatyeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","’ꞌO nnꞌaⁿ fariseos ñꞌeⁿ ꞌo nnꞌaⁿ na cwitꞌmo̱ⁿꞌyoꞌ ljeii na tqueⁿ Moisés, nntꞌuiiwiꞌnaꞌ ꞌo ee cweꞌ cwilꞌaꞌyaꞌyoꞌ na jeeⁿ ya nnꞌaⁿndyoꞌ. Ee cwiñeꞌquiaꞌyoꞌ diezmo cwentaaꞌ Tyꞌo̱o̱tsꞌom na cwiweꞌ ntjoomꞌyoꞌ hasta meiⁿ cweꞌ tscojñom tsꞌoomjndya ñequio tscolcoo ñequio lqueeⁿ cameiⁿnom sa̱a̱ ticalacanda̱ꞌyoꞌ ñꞌoom na tꞌmaⁿti naquiiꞌ ñꞌoom na tqueⁿ Moisés. Ñꞌoomꞌñeeⁿ maꞌmo̱ⁿnaꞌ chiuu na cꞌomꞌyoꞌ cantyja na matyꞌiomyanaꞌ ndoꞌ cꞌomꞌyoꞌ na wiꞌ nꞌomꞌyoꞌ ncꞌiaaꞌyoꞌ ndoꞌ calacanda̱ꞌyoꞌ ñꞌoom na cwinduꞌyoꞌ. Maxjeⁿ matyꞌiomyanaꞌ na cwiñeꞌquiaꞌyoꞌ diezmo sa̱a̱ mati calacanda̱ꞌyoꞌ ñꞌoommeiⁿꞌ na tꞌmaⁿti na sa̱ꞌntjom Moisés. ");
INSERT INTO amuNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Matseijomnaꞌ ꞌo chaꞌna nnꞌaⁿ na cwilaꞌcwꞌaaⁿꞌndye ndaatioo na cwiwe cha caꞌndiinaꞌ quiooꞌ na cajnda̱a̱ sa̱a̱ tiqueⁿna cwenta na jo nandye njom cwii quiooꞌ tꞌmaaⁿñe na jaato̱ꞌ. Ee jeeⁿ cwiqueⁿndyoꞌ na ñeꞌcalaꞌcanda̱ꞌyoꞌ ñꞌoom na niom nchꞌunchꞌu sa̱a̱ tiñeꞌcalaꞌcanda̱ꞌyoꞌ ñꞌoom na tꞌmaⁿti na macaⁿnaꞌ. Joꞌ chii ꞌo laxmaⁿꞌyoꞌ nnꞌaⁿ na cwitꞌmo̱ⁿꞌyoꞌ nato nda̱a̱ ncꞌiaꞌyoꞌ sa̱a̱ ncjoꞌyoꞌ chaꞌcwijom na nchjaaⁿꞌyoꞌ na tiñeꞌcatsaꞌjndyeeꞌyoꞌ natoꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","’ꞌO nnꞌaⁿ fariseos ñꞌeⁿ ꞌo nnꞌaⁿ na cwitꞌmo̱ⁿꞌyoꞌ ljeii na tqueⁿ Moisés nntꞌuiiwiꞌnaꞌ ꞌo ee cweꞌ cwilꞌaꞌyaꞌyoꞌ na jeeⁿ ya nnꞌaⁿndyoꞌ ee yaya cwilaljuꞌyoꞌ naxeⁿꞌ waso ñequio xio na cwiwilꞌueeꞌndyoꞌ sa̱a̱ tsꞌomnaꞌ cwajndii. Ee nantquie na cwicwaꞌyoꞌ cwicañjom joꞌ, laꞌxmaⁿnaꞌ ꞌnaaⁿ ncꞌiaaꞌyoꞌ na cwintyꞌueeꞌyoꞌ ee na tiñeꞌqueⁿꞌ cheⁿncjoꞌyoꞌ xjeⁿ na cwilaqueeⁿ nꞌomꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ꞌO nnꞌaⁿ fariseos cwiluiindyoꞌ chaꞌcwijom naⁿnchjaaⁿ. Cataꞌndyoꞌxcweꞌyoꞌ jo nnom Tyꞌo̱o̱tsꞌom quia joꞌ nntsꞌaanaꞌ chaꞌcwijom na cwilaljuꞌyoꞌ tsꞌom waso ñequio xio. Ndoꞌ na ljoꞌ nntseiljoyunaꞌ na ljuꞌ tsꞌomnaꞌ ñꞌeⁿ naxeⁿꞌnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","’ꞌO nnꞌaⁿ fariseos ñꞌeⁿ ꞌo nnꞌaⁿ na cwitꞌmo̱ⁿꞌyoꞌ ljeii na tqueⁿ Moisés nntꞌuiiwiꞌnaꞌ ꞌo ee cweꞌ cwilꞌaꞌyaꞌyoꞌ na jeeⁿ ya nnꞌaⁿndyoꞌ. Matseijomnaꞌ ꞌo chaꞌna ndeiꞌluaa na jeeⁿ canchiiꞌ lꞌa nnꞌaⁿ, na cweꞌ nacjooꞌnaꞌ nntyꞌiaaꞌ tsꞌaⁿ na jeeⁿ neiⁿncooꞌ sa̱a̱ naquiiꞌnaꞌ tooꞌ ndeii nnꞌaⁿ ñequio chaꞌtso nnom na tsꞌiaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Maluaaꞌ matseijomnaꞌ cantyja ꞌnaⁿꞌyoꞌ ee jo nda̱a̱ nnꞌaⁿ ndooꞌ xeⁿ matyꞌiomyanaꞌ ljoꞌ cwilꞌaꞌyoꞌ, sa̱a̱ naquiiꞌ nꞌomꞌyoꞌ ñenquiiꞌcheⁿ na we waa na cwilꞌaꞌyoꞌ ndoꞌ tooꞌñꞌeⁿ mꞌaaⁿ natia. ");
INSERT INTO amuNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","’ꞌO nnꞌaⁿ fariseos ñꞌeⁿ ꞌo nnꞌaⁿ na cwitꞌmo̱ⁿꞌyoꞌ ljeii na tqueⁿ Moisés nntꞌuiiwiꞌnaꞌ ꞌo ee cweꞌ cwilꞌaꞌyaꞌyoꞌ na jeeⁿ ya nnꞌaⁿndyoꞌ. Ee cwilꞌaꞌyoꞌ ndeiꞌluaa profetas ndoꞌ cwilachjoomndyoꞌ ndeiꞌluaa ꞌnaaⁿ nnꞌaⁿ na ñelꞌa cantyja na matyꞌiomyanaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Jnda̱ chii cwinduꞌyoꞌ: “Xeⁿ jaa mamꞌaaⁿya ncuee na ñetꞌom welooya teiyo, tixocalajomndyo̱ na jlaꞌcwjeena profetas.” ");
INSERT INTO amuNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ndoꞌ na luaaꞌ cwinduꞌyoꞌ cwitjeiꞌyuuꞌndyoꞌ cheⁿncjoꞌyoꞌ ñꞌoom nacjoꞌyoꞌ na ꞌo cwiluiindyoꞌ tsjaaⁿ ꞌnaaⁿ nquiee nnꞌaⁿ na tyolaꞌcwjee profetas. ");
INSERT INTO amuNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Joꞌ chii calacanda̱ꞌyoꞌ chiuu waa na to̱ꞌ jndyee nnꞌaⁿ tsjaaⁿ na tuiindyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","’ꞌO cwiluiindyoꞌ chaꞌcwijom nda canduulja na jeeⁿ tia cwilꞌaꞌyoꞌ. Chiuu nlꞌaꞌyoꞌyoꞌ na nnda̱a̱ nluiiꞌndyoꞌ nawiꞌ na cwitjoom nnꞌaⁿ na cwiꞌoo bꞌio. ");
INSERT INTO amuNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Queⁿꞌyoꞌ cwenta, ja njño̱o̱ⁿya profetas na nncꞌom naquiiꞌ ntaaⁿꞌyoꞌ ndoꞌ na nlaꞌneiⁿna cantyja na jndo̱ꞌ tsꞌom Tyꞌo̱o̱tsꞌom ndoꞌ na nntꞌmo̱o̱ⁿna ñꞌoom na matsa̱ꞌntjoom. Sa̱a̱ ꞌo nlaꞌcwjeꞌyoꞌ cwantindye naⁿꞌñeeⁿ. Ndoꞌ ntꞌom naⁿꞌñeeⁿ nntyꞌiomꞌyoꞌ nꞌoomꞌnaaⁿ. Ndoꞌ ntꞌom nntjaꞌyoꞌ naquiiꞌ lanꞌom ꞌnaⁿꞌyoꞌ. Ndoꞌ ntꞌomndye joona nleiꞌntyjo̱ꞌyoꞌ cwii ndoꞌ cwii tsjoom. ");
INSERT INTO amuNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Joꞌ chii choꞌnqueⁿꞌyoꞌ jnaⁿ cantyja nawiꞌ na nntjoom naⁿꞌñeeⁿ, ndoꞌ mati cantyja na tja̱ chaꞌtso nnꞌaⁿ na nchii jnaaⁿna hasta xjeⁿ na tuii tsjoomnancue. Nnaⁿnaꞌ na waa jnaⁿꞌyoꞌ xjeⁿ na seicueeꞌ Caín tyjeeⁿ Abel, tsaⁿ na tyotseixmaⁿ na matyꞌiomyanaꞌ, nndyowanaꞌ hasta na tueꞌ Zacarías jnda Berequías lꞌa weloꞌyoꞌ xcwe quiiꞌntaaⁿ tio tꞌmaⁿ ñequio ta watsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Nndyeꞌyoꞌ nntsjo̱o̱, mayuuꞌcheⁿ nntꞌuiinaꞌ ꞌo nnꞌaⁿ na mꞌaⁿꞌyoꞌ jeꞌ cantyja chaꞌtso nawiꞌmeiⁿꞌ na tjoom naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","’ꞌO nnꞌaⁿ Jerusalén, cwilacwjeꞌyoꞌ nnꞌaⁿ na cwiñeꞌquia ñꞌoomꞌ Tyꞌo̱o̱tsꞌom ndoꞌ cwijñomꞌyoꞌ ljo̱ꞌ nnꞌaⁿ na majñoom na mꞌaⁿꞌyoꞌ. Majndye ndiiꞌ ñentyjaaꞌ tsꞌo̱o̱ⁿ na nntseitjo̱ⁿya ꞌo na nncꞌomꞌyoꞌ cwentaya chaꞌxjeⁿ matseitjom caxtixquie ntseinaaⁿ nacjeeꞌ ntsqueeⁿ. Sa̱a̱ ꞌo cwaaⁿ tquiandyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Queⁿꞌyoꞌ cwenta, maꞌndii Tyꞌo̱o̱tsꞌom ꞌo. Taxocꞌoomñê watsꞌom tꞌmaⁿ ꞌnaⁿꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Nndyeꞌyoꞌ nntsjo̱o̱ na taxocantyꞌiaꞌyoꞌ ja hasta na nncueꞌntyjo̱ xuee na nnduꞌyoꞌ: “Matioꞌnaaⁿñenaꞌ nquii na macwjeeꞌcañoom ñequio najndeii na matseixmaⁿ Ta Tyꞌo̱o̱tsꞌom.” ");
INSERT INTO amuNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jluiꞌ Jesús watsꞌom tꞌmaⁿ na mawjaⁿ. Ndoꞌ jâ nnꞌaⁿ na cwilaꞌjomndyô̱ ñꞌeⁿñê squieꞌcaño̱o̱ⁿyâ jom. To̱o̱ꞌâ na cwitꞌmo̱o̱ⁿyâ chiuu waa na jeeⁿ neiⁿncooꞌ lꞌaa cwentaaꞌ watsꞌom tꞌmaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Sa̱a̱ jom tꞌo̱o̱ⁿ nda̱a̱yâ, tsoom: —¿Aa cwintyꞌiaꞌyoꞌ na jeeⁿ ya chaꞌtso nmeiⁿꞌ? Candyeꞌyoꞌ nntsjo̱o̱ na mayuuꞌcheⁿ tixocaꞌndiinaꞌ cwii tsjo̱ꞌ nacjooꞌ xꞌiaaꞌnaꞌ. Nntyuiiꞌñꞌeⁿ lꞌaameiⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Quia joꞌ saayâ ta na jndyu Olivos. Ndoꞌ quia jnda̱ tacatyeeⁿ Jesús joꞌ joꞌ jâ nnꞌaⁿ na cwilaꞌjomndyô̱ ñꞌeⁿñê saantyjaaꞌâ jom cha nnda̱a̱ nlana̱a̱ⁿyâ ñꞌeⁿñê na ñencjo̱o̱yâ. Lꞌuuyâ: —Catsuꞌ nda̱a̱yâ cwaaⁿ nluii na nmeiiⁿꞌ. Ndoꞌ ¿cwaaⁿ ꞌnaaⁿ na nleitquiooꞌ na mꞌmo̱ⁿnaꞌ na manndyoꞌnndaꞌ ndoꞌ na nntycwii tsjoomnancue? ");
INSERT INTO amuNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Tꞌo̱ Jesús nda̱a̱yâ, tsoom: —Calꞌaꞌyoꞌ cwenta na tjaa ꞌñeeⁿ nnquiuꞌnnꞌaⁿ ꞌo cantyja ꞌnaaⁿ ñꞌoommeiⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ee jndye nnꞌaⁿ nñequiona ñequio xueya na nluena: “Ja cwiluiindyo̱ nquii Cristo”, na nñeꞌquioꞌnnꞌaⁿna nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ee nntyꞌiaꞌyoꞌ na nndyocwjeeꞌcañoom ntiaꞌ ndoꞌ nleicꞌuaa ñꞌoom na cwiluii ntiaꞌ cwiicheⁿ ntyja. Sa̱a̱ tiñeꞌquiandyoꞌ na nlacatyuendyoꞌ ee maxjeⁿ jndeiꞌnaꞌ na nmeiⁿꞌ cwinomjndyee. Sa̱a̱ ndicwaⁿ tjo̱o̱cheⁿ na nntycwii tsjoomnancue. ");
INSERT INTO amuNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nlaꞌwendye nnꞌaⁿ cwii ndyuaa nacjoo nnꞌaⁿ cwiicheⁿ ndyuaa. Ndoꞌ cwii tsaⁿmatsꞌiaaⁿ tꞌmaⁿ nntseiweñê nacjooꞌ cwiicheⁿ tsaⁿmatsꞌiaaⁿ. Jndye joo nncꞌoom jndoꞌ tꞌmaⁿ ndoꞌ nnconom ntycu na wjaatcuuñenaꞌ ndoꞌ jndye jo jndeii nntsꞌeii. ");
INSERT INTO amuNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Chaꞌtso nawiꞌmeiⁿꞌ cweꞌ weꞌyandyo laꞌxmaⁿnaꞌ. Quia nlquieꞌntyjo̱ ntꞌomcheⁿ nawiꞌ na jaaꞌti. ");
INSERT INTO amuNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","’Jndye nnꞌaⁿ hasta ndiocheⁿ tsjoomnancue nncꞌomna na jndoona ꞌo ncꞌe na mꞌaⁿꞌyoꞌ cantyja ꞌnaⁿya. Joꞌ na nlaꞌquioo nnꞌaⁿ ꞌo luee nnꞌaⁿ na nntaꞌwiꞌna ꞌo, ndoꞌ nlaꞌcwjeena ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Jndye nnꞌaⁿ nntjeiiꞌndyena cantyja na cwilaꞌyuꞌya nꞌomna. Nncꞌomna na jndoondye ntyjeena hasta na nlꞌueeꞌndyena ñꞌoom na nntꞌuiinaꞌ ncꞌiaana. ");
INSERT INTO amuNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ndoꞌ jndye nnꞌaⁿ nluena na profeta joona sa̱a̱ tiyuuꞌ ñꞌoom cwiñequiana. Ndoꞌ jndye nnꞌaⁿ nñeꞌquioꞌnnꞌaⁿna. ");
INSERT INTO amuNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ndoꞌ ncꞌe na nncjaantyꞌee nncjaantyꞌee natia, juunaꞌ nntsꞌaanaꞌ na tawiꞌ nꞌomndye ntyjeena. ");
INSERT INTO amuNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Sa̱a̱ juu tsꞌaⁿ na tyeⁿ cwiljooꞌñe cantyja ꞌnaⁿya hasta na macanda̱, tsaⁿꞌñeeⁿ nluiꞌnꞌmaaⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Chaꞌwaa tsjoomnancue nncꞌoo nnꞌaⁿ na nñeꞌquiana ñꞌoom nayawaañe cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. Juunaꞌ nncwjiꞌyuuꞌñenaꞌ chiuu calꞌa nnꞌaⁿ cwii cwii ndyuaa, quia ljoꞌcheⁿ nncueꞌntyjo̱ na nntycwii tsjoomnancue. ");
INSERT INTO amuNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","’ꞌÑeeⁿ juu tsꞌaⁿ na matseiꞌnaaⁿꞌ ñꞌoommeiiⁿ, catseiꞌno̱ⁿꞌ ljoꞌ ñecatsonaꞌ. Juu profeta Daniel, seiljeiⁿ ñꞌoom cantyja ꞌnaaⁿꞌ juu na jeeⁿcheⁿ ndyaaꞌ tiaaꞌ na nntseityuiiꞌ chaꞌtso. Quia na nntyꞌiaꞌyoꞌ na jnda̱ mamꞌaaⁿ naquiiꞌ watsꞌom tꞌmaⁿ yuu na ljuꞌti na cwiluiiñenaꞌ cwentaaꞌ Tyꞌo̱o̱tsꞌom, ");
INSERT INTO amuNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","quia joꞌ chaꞌtsondyoꞌ na mꞌaⁿꞌyoꞌ tsꞌo̱ndaa Judea catsaleiꞌnomꞌyoꞌ quiiꞌ ntsjo̱. ");
INSERT INTO amuNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Juu xjeⁿꞌñeeⁿ ꞌñeeⁿ tsꞌaⁿ na ljo nacjooꞌ waaꞌ ticandyocueeⁿ na nncjaaqueⁿꞌeⁿ joꞌ na nncwjeeⁿꞌeⁿ ꞌnaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ndoꞌ tsꞌaⁿ na mꞌaaⁿ jo jnda̱a̱, na machꞌee tsꞌiaaⁿ, ticjaalcweeⁿꞌeⁿ na nncjaacachoom liaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ndoꞌ joo ncueeꞌñeeⁿ jeeⁿ wiꞌ nntjoom yolcu na ndeiindye ñequio yolcu na ꞌndaandye ndana. ");
INSERT INTO amuNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Calꞌaꞌyoꞌ tyꞌoo nnom Tyꞌo̱o̱tsꞌom na nchii xcwe ncuee na teiⁿ, meiⁿ nchii xuee na cwitaꞌjndyee nnꞌaⁿ na nlcaⁿnaꞌ na caleiꞌnomꞌyoꞌ nawiꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ee quia ljoꞌcheⁿ nnquioo cwii nawiꞌ na tꞌmaⁿticheⁿ na meiⁿjom ndiiꞌ tyootjoom nnꞌaⁿ cantyjati xjeⁿ na tuii tsjoomnancue hasta jeꞌ. Ndoꞌ xuee na cwii wjaatinaꞌ, meiⁿ tajom cwii nluiinndaꞌ cwiicheⁿ nawiꞌ chaꞌna juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ndoꞌ xeⁿ ticatsꞌaa Tyꞌo̱o̱tsꞌom na tijndyeti xuee na nncꞌoom nawiꞌñeeⁿ quia joꞌ meiⁿcwii tsꞌaⁿ xocaluiꞌnꞌmaaⁿñe cantyja ꞌnaaⁿꞌnaꞌ. Sa̱a̱ ncꞌe na wiꞌ tsꞌoom nnꞌaⁿ na jnda̱ tjeiiꞌñê cwentaaⁿꞌaⁿ, nntsꞌaaⁿ na tijndyeti xuee na nncꞌoom nawiꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","’Joꞌ chii xeⁿ nntso cwii tsꞌaⁿ nda̱a̱ꞌyoꞌ: “Cantyꞌiaꞌyoꞌ ljo mꞌaaⁿ nquii na cwiluiiñe Cristo”, oo nntso tsꞌaⁿ: “Cantyꞌiaꞌyoꞌ, laꞌñeⁿ mꞌaaⁿ”, tilayuꞌyoꞌ ñꞌoomꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ee maxjeⁿ nlquieꞌcañom nnꞌaⁿ ꞌo na nluena joona cwiluiindyena Cristo. Ndoꞌ nluena na profeta joona sa̱a̱ tiyuuꞌ ñꞌoom na cwiñeꞌquiana. Nlꞌana jndye nnom ꞌnaaⁿ tꞌmaⁿ ñequio jndye nnom tsꞌiaaⁿ tꞌmaⁿ na nncjaaweeꞌ nꞌom nnꞌaⁿ cha xeⁿ na nnda̱a̱ nlꞌana na nñequioꞌnnꞌaⁿna nnꞌaⁿ na macwjiꞌ Tyꞌo̱o̱tsꞌom cwentaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Matyuaaꞌti matseicandiiya ꞌo cwii tjo̱o̱cheⁿ na nluii joonaꞌ cha calꞌaꞌyoꞌ cwenta. ");
INSERT INTO amuNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Quia joꞌ xeⁿ nlue nnꞌaⁿ nda̱a̱ꞌyoꞌ: “Queⁿꞌyoꞌ cwenta, laꞌñeⁿ mꞌaaⁿ ndyuaa yuu tjaa nnꞌaⁿ cꞌoom”, tintsaꞌyoꞌ joꞌ joꞌ. Ndoꞌ xeⁿ na nluena: “Cantyꞌiaꞌyoꞌ, luaaꞌ mꞌaaⁿ naquiiꞌ wꞌaa”, tilayuꞌyoꞌ na ljoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ee ja na cwiluiindyo̱ tsaⁿ na jnaⁿ cañoomꞌluee quia na nndyo̱o̱nndaꞌa nleitquiooꞌndyo̱ nda̱a̱ nnꞌaⁿ na chaꞌwaa tsjoomnancue, chaꞌxjeⁿ na cwiwixuee chomtsuee yuu na macaluiꞌ ñeꞌquioomꞌ hasta wjaantycwiinaꞌ ntyja na majaacue ñeꞌquioomꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Sa̱a̱ nawiꞌñeeⁿ na jnda̱ tsjo̱o̱ na nntjomꞌyoꞌ, maxjeⁿ ticwinomꞌnaꞌ ee queⁿꞌyoꞌ cwenta, meiⁿyuucheⁿ na meindyuaa ꞌnaⁿ to̱ꞌ, joꞌ joꞌ nntjomndye cantꞌeiⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","’Quia na jnda̱ teinomncue nawiꞌ tꞌmaⁿ ncueeꞌñeeⁿ, nleijaaⁿñe ñeꞌquioomꞌ, ndoꞌ mati chiꞌ taxocwixueeñe. Nntquiaandye cancjuu. Ndoꞌ chaꞌtso na cwilaꞌxmaⁿ najnda̱ na mꞌaⁿ tsjo̱ꞌluee nntyuiiꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Quia joꞌ ja na cwiluiindyo̱ tsaⁿ na jnaⁿ cañoomꞌluee, nleitquiooꞌ ꞌnaaⁿ cantyja ꞌnaⁿya. Ndoꞌ nntseityꞌioonaꞌ chaꞌtsondye nnꞌaⁿ na mꞌaⁿ tsjoomnancue. Ee nntyꞌiaana ja, tsaⁿ na jnaⁿ cañoomꞌluee na nluiiꞌa joꞌ joꞌ. Nndyo̱cua̱ naquiiꞌ nchquiu ñequio najndeii na matseixmaⁿya ndoꞌ ñequio na neiⁿncooꞌ nacaxuee na cwiluiitꞌmaⁿndyo̱. ");
INSERT INTO amuNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ndoꞌ njño̱o̱ⁿya ángeles ꞌnaⁿya na jndeii ntjo̱ꞌna ndu na nncꞌoona chaꞌwaa tsjoomnancue, na nlaꞌtjomna nnꞌaⁿ na jnda̱ tjeiiꞌndyo̱ cwentaya. ");
INSERT INTO amuNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","’Calaꞌno̱ⁿꞌyoꞌ ꞌnaaⁿ na maꞌmo̱ⁿnaꞌ nda̱a̱ꞌyoꞌ cantyja ꞌnaaⁿꞌ tsꞌoom higuera. Quia na cwintyꞌiaꞌyoꞌ na cwinnteiꞌ lꞌo̱naꞌ ndoꞌ cwicaluiꞌ tsco ꞌndaa juunaꞌ, quia joꞌ cwilaꞌno̱ⁿꞌyoꞌ na majnda̱ jaawindyooꞌ ncueesuaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ndoꞌ majoꞌti quia na cwintyꞌiaꞌyoꞌ na cwiluii chaꞌtso nmeiⁿꞌ na jnda̱ tsjo̱o̱ nda̱a̱ꞌyoꞌ, quia joꞌ calaꞌno̱ⁿꞌyoꞌ na jnda̱ teindyooꞌ mꞌaaⁿnaꞌ. Manncwja̱caño̱o̱ⁿnndaꞌa. ");
INSERT INTO amuNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Candyeꞌyoꞌ nntsjo̱o̱, mayuuꞌcheⁿ na xocwjeñꞌeⁿ nnꞌaⁿ na mꞌaⁿ jeꞌ hasta xjeⁿ na jnda̱ seicanda̱a̱ꞌñenaꞌ chaꞌtso ñꞌoommeiⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Tsjo̱ꞌluee ñꞌeⁿ tsjoomnancue nntycwiiñꞌeⁿnaꞌ sa̱a̱ ñꞌoom ꞌnaⁿya tijoom xuee nntsꞌaanaꞌ na xotseicanda̱a̱ꞌñenaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","’Sa̱a̱ meiⁿcwii tsꞌaⁿ ticaljeii cwaaⁿ xuee ndoꞌ ꞌñeeⁿ xjeⁿ na nluii chaꞌtso nmeiⁿꞌ. Meiⁿ nquiee ángeles na mꞌaⁿ cañoomꞌluee ticaliuna, meiⁿ ja na cwiluiindyo̱ Jnda Tyꞌo̱o̱tsꞌom ticaljeiiya. Macanda̱ ñenquiicheⁿ Tsotya̱ya ntyjeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","’Chaꞌxjeⁿ na tyomꞌaⁿ nnꞌaⁿ ncuee quia ñetꞌoom Noé, maluaaꞌ matseijomnaꞌ na nlꞌa nnꞌaⁿ quia na nncwja̱caño̱o̱ⁿya na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ee ncueeꞌñeeⁿ cwii tjo̱o̱cheⁿ na seicatsuu ndaaluaꞌntyꞌa tsjoomnancue tyomꞌaⁿ nnꞌaⁿ. Tyocwaꞌna, tyowena, tyowuncona, tyoñeꞌquiana ndana na nncꞌunco hasta juu xuee quia na tjaquieeꞌ Noé wꞌaandaa tꞌmaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Sa̱a̱ tiqueⁿna cwenta na waa na teincuuꞌ hasta matsꞌia joꞌ tyjeeꞌ ndaaluaꞌntyꞌa. Tyjeeꞌ candaa, tjachuunaꞌ chaꞌtsondye naⁿꞌñeeⁿ. Maluaaꞌ matseijomnaꞌ na nntjoom nnꞌaⁿ quia na nncwja̱caño̱o̱ⁿ ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ee juu xueeꞌñeeⁿ nntseijomnaꞌ mꞌaⁿ we nnꞌaⁿ na cwilꞌa tsꞌiaaⁿ jo jnda̱a̱. Cwii tsaⁿꞌñeeⁿ wjaañꞌoomnaꞌ jom na mꞌaaⁿya ndoꞌ cwii maꞌndiinaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nntseijomnaꞌ mꞌaⁿ we yolcu na cwitua. Cwii tsaⁿꞌñeeⁿ wjaañꞌoomnaꞌ jom na mꞌaaⁿya ndoꞌ cwii maꞌndiinaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","’Joꞌ chii ñequiiꞌcheⁿ cꞌomꞌcꞌeendyoꞌ ee na ticaliuꞌyoꞌ cwaaⁿ xuee nncwjeeꞌcañoom nqueⁿ na matsa̱ꞌntjoom ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ñꞌoomwaa calaꞌno̱ⁿꞌyoꞌ: Xeⁿ ntyjii tsꞌaⁿ cwaaⁿ nlquie naⁿcantyꞌue waⁿꞌaⁿ, tixocatsom meiⁿ xonquiaaⁿ na nncꞌooquieꞌna na nntjeiiꞌna ꞌnaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Joꞌ chii mati ꞌo cꞌomꞌcꞌeendyoꞌ ee juu xjeⁿ na ticalaꞌtiuuꞌyoꞌ, majuuto xjeⁿꞌñeeⁿ nncwja̱caño̱o̱ⁿ ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","’Calꞌuu mꞌaaⁿ cwii moso na jndo̱ꞌ tsꞌom ndoꞌ matseicanda̱, jom nlcoꞌjndyee patrom ꞌnaaⁿꞌaⁿ na catsa̱ꞌntjoom chaꞌtso ntꞌomcheⁿ moso wꞌaaꞌñeeⁿ na nñequiaaⁿ nantquie nda̱a̱na quia na maweꞌntyjo̱ xjeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Quia na nncwjeeꞌ patrom ꞌnaaⁿꞌaⁿ na tja cwii joo ndoꞌ nljeii na jeeⁿ ya cwenta machꞌeeⁿ, tꞌmaⁿ nñequiaanaꞌ na neiiⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Candyeꞌyoꞌ nntsjo̱o̱, mayuuꞌcheⁿ na chaꞌtso ꞌnaⁿ na matseixmaⁿ patromꞌñeeⁿ, nntioom cwenta lꞌo̱ mosoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Sa̱a̱ calꞌuu na juu mosoꞌñeeⁿ cwiluiiñê na tia tsꞌaⁿñê ndoꞌ nntseitioom naquiiꞌ tsꞌoom na taxocwjeeꞌ patrom ꞌnaaⁿꞌaⁿ na tyuaaꞌ, ");
INSERT INTO amuNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ndoꞌ nnto̱o̱ⁿꞌo̱ⁿ na nncwjaaⁿꞌaⁿ ntyjemosoñe na mꞌaⁿ nacje ꞌnaaⁿꞌaⁿ. Nlcwaꞌjndooꞌñê ndoꞌ nntseijomñê nncꞌom ñequio naⁿcandyee. ");
INSERT INTO amuNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Matsꞌia joꞌ nncwjeeꞌ patrom ꞌnaaⁿꞌaⁿ cwii xuee na ticꞌomcꞌeⁿ ndoꞌ hora na ticatseitioom na nncwjeeꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Cwajndii nntseiseiꞌ patrom jom, jnda̱ nncjuꞌ tsaⁿꞌñeeⁿ jom yuu na mꞌaⁿ nnꞌaⁿ na cweꞌ cwilꞌaya na ya nnꞌaⁿndye. Joꞌ joꞌ nntyꞌioom ndoꞌ nneiⁿnqueeⁿ ndeiꞌnꞌoom. ");
INSERT INTO amuNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","’Seineiⁿti Jesús ñꞌoom tjañoomꞌ cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom cañoomꞌluee. Tsoom: —Tyomꞌaⁿ qui yolcundyua tyꞌechona xjocanti ꞌnaaⁿna na ntyjo chom na cwico seitye. Jluiꞌna, tyꞌecatjomndyena juu tsaⁿsꞌa na macoco. ");
INSERT INTO amuNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ꞌOmndye joona tijndo̱ꞌ nꞌomna ndoꞌ ꞌomndye naⁿꞌñeeⁿ majndo̱ꞌ nꞌomna. ");
INSERT INTO amuNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Joo yolcu na tijndo̱ꞌ nꞌom quia na tyꞌechona xjocanti ꞌnaaⁿna, taticꞌoochotina seitye na nlco. ");
INSERT INTO amuNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Sa̱a̱ yolcu na jndo̱ꞌ nꞌom tyꞌechona xjocanti ꞌnaaⁿna na ntyjo chom ndi ñꞌeeⁿ lioo na ñjomti seitye. ");
INSERT INTO amuNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ndoꞌ yocheⁿ na meindooꞌna nquii tsaⁿsꞌa na macoco, jnaⁿnaꞌ na maꞌoondana ndoꞌ mana jndana. ");
INSERT INTO amuNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Quia tueeꞌ xcwe tsjom, teicꞌuaa na matseixuaa tsꞌaⁿ. Matso: “Cꞌomꞌcꞌeendyoꞌ, macwjeeꞌcañoom tsꞌaⁿ na macoco. Quioꞌyoꞌ na nlajomndyoꞌ ñꞌeⁿñê.” ");
INSERT INTO amuNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Quia joꞌ teiꞌcantyja yolcuꞌñeeⁿ. Jlaꞌyo̱na nmaⁿ na ntyjo chom xjocanti ꞌnaaⁿna. ");
INSERT INTO amuNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ndoꞌ joo yolcu na tijndo̱ꞌ nꞌom jluena nda̱a̱ ncꞌiaana na jndo̱ꞌ nꞌom: “Jeeⁿ ꞌo leii, cateijndeiꞌyaꞌyoꞌ seitye na cwileiꞌñꞌomꞌyoꞌ ee majaanduuꞌ chom ꞌnaaⁿyâ.” ");
INSERT INTO amuNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Sa̱a̱ yolcu na jndo̱ꞌ nꞌom tꞌo̱o̱na nda̱a̱ naⁿꞌñeeⁿ: “Xonda̱a̱, ee xeⁿ nntsꞌaacheⁿnaꞌ na xocwijndeii na nleilꞌueeꞌndyo̱ ncjo̱o̱yâ ndoꞌ mati ꞌo. Yati catsalajndaꞌyoꞌ na nleilꞌueeꞌndyoꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ndoꞌ yocheⁿ na tyꞌelaꞌjnda naⁿꞌñeeⁿ seitye, tyjeeꞌcañoom nquii tsaⁿsꞌa na macoco. Quia joꞌ joo yolcu na mꞌaⁿcꞌeendye tyꞌequieꞌna quiiꞌ wꞌaa ñꞌeⁿñê yuu na nleitꞌmaaⁿꞌ na macocoom. Jnda̱ joꞌ ta̱ꞌ ndyueelꞌa. ");
INSERT INTO amuNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Jnda̱ chii mati tquieꞌcañom ntꞌomcheⁿ yolcundyuaꞌñeeⁿ. Jluena: “Aa ndiꞌ ta, catseicanaaⁿndyuꞌ ꞌndyootsꞌa. Aa ndiꞌ ta.” ");
INSERT INTO amuNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Tꞌo̱ tsaⁿꞌñeeⁿ nda̱a̱na: “Mayuuꞌcheⁿ matsjo̱o̱ nda̱a̱ꞌyoꞌ ticwajnaⁿꞌa ꞌo.” ");
INSERT INTO amuNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ndoꞌ tso Jesús nda̱a̱yâ: —Calaꞌno̱ⁿꞌyoꞌ na ñꞌoommeiⁿꞌ cwitꞌmo̱o̱ⁿnaꞌ na cꞌomꞌcꞌeendyoꞌ, ee ticaliuꞌyoꞌ cwaaⁿ xuee ndoꞌ cwaaⁿ hora na ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee nncwja̱caño̱o̱ⁿya ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","’Nntseina̱ⁿtya̱ nnda̱a̱ꞌyoꞌ cwiicheⁿ ñꞌoom tjañoomꞌ cantyja ꞌnaaⁿꞌ na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom cañoomꞌluee. Tyomꞌaaⁿ cwii tsꞌaⁿ na seijndaaꞌñe na wjaa cwiicheⁿ tsjoomnancue na tquia. Tqueeⁿꞌñê mosoomꞌm ndoꞌ tquiaaⁿ tsjo̱ꞌñjeeⁿ ꞌnaaⁿꞌaⁿ nda̱a̱na na nlꞌana tsꞌiaaⁿ ñꞌeⁿ joonaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","’Nnom cwii joo naⁿꞌñeeⁿ tquiaaⁿ ꞌom meiⁿ sꞌom. Nnom cwiicheⁿ tquiaaⁿ ñeꞌwe meiⁿ ndoꞌ nnom cwiicheⁿ ñeꞌcwii meiⁿ cwii tquiaaⁿ. Tquiaaⁿ nnom cwii cwii joona cantyjati na seiꞌno̱o̱ⁿꞌo̱ⁿ na nnda̱a̱ nntsꞌaa. Jnda̱ joꞌ jlueeⁿꞌeⁿ, tjaaⁿ cwiicheⁿ tsjoomnancue. ");
INSERT INTO amuNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Juu tsꞌaⁿ na toꞌñom ꞌom meiⁿ sꞌom mantyjacheⁿ tyochꞌeeⁿ tsꞌiaaⁿ ñꞌeⁿ joonaꞌ. Ndoꞌ tantjomtyeeⁿ cwiicheⁿ ꞌom meiⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Mati juu tsꞌaⁿ na toꞌñom we meiⁿ, tyochꞌeeⁿ tsꞌiaaⁿ ñꞌeⁿ joonaꞌ ndoꞌ tantjoom cwiicheⁿ we meiⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Sa̱a̱ juu tsꞌaⁿ na ñecwii meiⁿ toꞌñom, tjaaⁿ tjacaꞌñeeⁿ quiiꞌ tyuaa, joꞌ joꞌ tantyꞌioom sꞌom ꞌnaaⁿꞌ patrom ꞌnaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","’Majndye xuee tjacaanaꞌ ndoꞌ tyjeeꞌnndaꞌ patrom ꞌnaaⁿna. Seijndaaꞌñê na nncwjeeⁿꞌeⁿ cwenta ñꞌeⁿndyena cwanti tueꞌntyjo̱ taꞌntjomna ñꞌeⁿ sꞌom ꞌnaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Tyjeeꞌcañoomjndyee juu tsꞌaⁿ na toꞌñom ꞌom meiⁿ sꞌom. Maleichuuñꞌeeⁿ sꞌomꞌñeeⁿ, mandi ñꞌeⁿ ꞌom meiⁿ na tantjoom. Tquiaaⁿ joonaꞌ nnom patrom ꞌnaaⁿꞌaⁿ. Tsoom: “ꞌU ta, tquiaaꞌ ꞌom meiⁿ sꞌom no̱o̱ⁿ. Cantyꞌiaꞌ jeꞌ luaa cwiicheⁿ ꞌom meiⁿ na jnda̱ tantjo̱ⁿya.” ");
INSERT INTO amuNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Tso patrom nnoom: “ꞌU moso ꞌnaⁿya, ya saꞌ. Tquiooꞌ na tjooꞌ tsꞌomꞌ ndoꞌ na seicanda̱ꞌ. Meiiⁿ cweꞌ cwii tsꞌiaaⁿ na cachjoo sa̱a̱ ꞌu seicanda̱ꞌ. Jeꞌ nlqua̱a̱ⁿya ꞌu na tꞌmaⁿti tsꞌiaaⁿ nntseixmaⁿꞌ. Ndoꞌ na luaaꞌ wendyo̱ nncꞌo̱o̱ⁿya na neiiⁿya.” ");
INSERT INTO amuNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Jnda̱ chii tyjeeꞌcañoom juu tsꞌaⁿ na toꞌñom we meiⁿ sꞌom. Tsoom: “ꞌU ta, tquiaaꞌ we meiⁿ sꞌom no̱o̱ⁿ. Cantyꞌiaꞌ jeꞌ luaa cwiicheⁿ we meiⁿ na jnda̱ tantjo̱ⁿya.” ");
INSERT INTO amuNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Tso patrom nnoom: “ꞌU moso ꞌnaⁿya, ya saꞌ. Tquiooꞌ na tjooꞌ tsꞌomꞌ ndoꞌ na seicanda̱ꞌ. Meiiⁿ cweꞌ cwii tsꞌiaaⁿ na cachjoo sa̱a̱ ꞌu seicanda̱ꞌ. Jeꞌ nlqua̱a̱ⁿya ꞌu na tꞌmaⁿti tsꞌiaaⁿ nntseixmaⁿꞌ. Ndoꞌ na luaaꞌ wendyo̱ nncꞌo̱o̱ⁿya na neiiⁿya.” ");
INSERT INTO amuNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Quia joꞌ na macanda̱ tyjeeꞌcañoom juu moso na ñeꞌcwii meiⁿ sꞌom toꞌñom. Tsoom nnom patrom ꞌnaaⁿꞌaⁿ: “ꞌU ta, mantyjiiya na ꞌu tsꞌaⁿ na jeeⁿ majñoomꞌ ꞌndyoꞌ moso ꞌnaⁿꞌ. ꞌU cweꞌ matseiꞌweꞌ cantyja na cwiweꞌ ntjom ꞌnaⁿꞌ, meiⁿ na nnomꞌ, meiⁿ na nntseicueendyuꞌ. Macanda̱ nencjo̱o̱yâ moso ꞌnaⁿꞌ jeeⁿ cwilajnda̱a̱yâ. ");
INSERT INTO amuNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Cweꞌ na nquiaya ꞌu, joꞌ chii tjo̱, tjo̱catyꞌiuya sꞌom ꞌnaⁿꞌ quiiꞌ tyuaa. Luaa juunaꞌ, coꞌñomꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ndoꞌ tꞌo̱ patrom ꞌnaaⁿꞌaⁿ nnoom: “ꞌU re moso na tia tsꞌaⁿndyuꞌ ndoꞌ na nchqueⁿꞌ, cwa maxjeⁿ ntyjiꞌ na matseiwa̱ya ntjom meiiⁿ nchii nnco̱ jno̱o̱ⁿꞌa, ndoꞌ mawantjo̱ⁿya meiiⁿ nchii nnco̱ matseicatsuundyo̱. ");
INSERT INTO amuNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Cweꞌ ncꞌe joꞌ yati xeⁿ ꞌu seiweꞌ sꞌom ꞌnaⁿya wꞌaa banco yuu na cwileiweya sꞌom ꞌnaaⁿ nnꞌaⁿ, quia joꞌ toꞌño̱ⁿ sꞌom ꞌnaⁿya ñequio tsꞌiaaⁿnnomnaꞌ quia na tyja̱.” ");
INSERT INTO amuNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ndoꞌ tso patrom nda̱a̱ ntꞌomcheⁿ mosoomꞌm: “Catjeiꞌyoꞌ cwii meiⁿwaaꞌ lꞌo̱o̱ⁿ ndoꞌ quiaꞌyoꞌ juunaꞌ lꞌo̱ juu tsꞌaⁿ na maleiñꞌoom qui meiⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ee cantyjati na matseixmaⁿ ticwii cwii tsꞌaⁿ, xeⁿ ya tsꞌiaaⁿ machꞌeeⁿ ñꞌeⁿ juunaꞌ quia joꞌ nncoꞌñomtyeeⁿ na nleilꞌueeꞌñê. Sa̱a̱ juu tsꞌaⁿ na tisꞌa tsꞌiaaⁿ machꞌee, nluiꞌ cantyjati chjoowiꞌ na maleiñꞌoomtyeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Cweꞌ joꞌ catueꞌyoꞌ moso nchqueeⁿꞌmꞌaaⁿꞌ chꞌeⁿ yuu na jaaⁿñe. Joꞌ joꞌ nntyꞌioom ndoꞌ nneiⁿnqueeⁿ ndeiꞌnꞌoom.” ");
INSERT INTO amuNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","’Ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee, nndyo̱o̱nndaꞌa ñequio chaꞌtso ángeles ꞌnaⁿya, na nntsa̱ꞌntjo̱ⁿya. Quia joꞌ nntseitꞌmaaⁿꞌñenaꞌ ja na nncjo̱cajmaⁿ ntio ꞌnaⁿya na jeeⁿ neiⁿncooꞌ caxuee na nncuꞌxa̱ⁿya nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ndoꞌ nnꞌaⁿ na chaꞌwaa tsjoomnancue nntjomndyena jo no̱o̱ⁿ. Quia joꞌ nnto̱ⁿꞌa joona chaꞌxjeⁿ na mato̱ⁿꞌ cwii pasto canmaⁿ ñequio canchꞌioo ntsmeiiⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nntsꞌaaⁿ na nncwintyjeeꞌ canmaⁿ ntyjaaⁿꞌaⁿ ntyjaya ndoꞌ canchꞌioo nntsꞌaaⁿ na nncwintyjeeꞌ ntyjatymaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Maluaaꞌ nntsꞌaa ja na cwiluiindyo̱ na matsa̱ꞌntjo̱ⁿya. Nntsjo̱o̱ nda̱a̱ nnꞌaⁿ na mꞌaⁿ ntyjaaꞌa ntyjaya: “Quioꞌyoꞌ ꞌo nnꞌaⁿ na jnda̱ jndaꞌyoꞌ na matioꞌnaaⁿñe Tsotya̱ya ꞌo. Catoꞌñoomꞌyoꞌ naya na mañequiaaⁿ na mati ꞌo cwilajomndyoꞌ ñequio na matsa̱ꞌntjoom. Ee luaaꞌ teiyoti seijndaaꞌñê cwentaꞌyoꞌ quia na tqueeⁿ tsjoomnancue. ");
INSERT INTO amuNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ee tyomꞌaaⁿya na ñejndo̱ꞌa ndoꞌ tquiaꞌyoꞌ na tcwaaꞌa. Tyomꞌaaⁿya na ñeꞌcꞌua ndaa ndoꞌ tquiaꞌyoꞌ na tꞌua. Tyomaꞌno̱o̱ⁿya cwii cwii tsjomꞌyoꞌ yuu na ticataꞌjnaaⁿꞌ nnꞌaⁿ ja ndoꞌ toꞌñoomꞌyoꞌ ja naquiiꞌ lꞌaꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Tyomꞌaaⁿya na ntsaandyo̱ ndoꞌ ꞌo jlaꞌtsaaⁿꞌndyoꞌ ja. Tyomꞌaaⁿya na wiiꞌa ndoꞌ ꞌo tyotsacajndoꞌyoꞌ ja. Tyomꞌaaⁿya pra̱so ndoꞌ tyotsantyjaꞌyoꞌ ja.” ");
INSERT INTO amuNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Quia joꞌ nnꞌaⁿ na mꞌaⁿ ntyjaaꞌa ntyjaya na laꞌxmaⁿna cantyja na matyꞌiomyanaꞌ nntꞌo̱o̱na, nluena: “Ta, ¿cwaaⁿ ntyꞌiaayâ ꞌu na ñeꞌjndoꞌ ndoꞌ tquiaayâ na tcwaꞌ, oo ntyꞌiaayâ ꞌu na ñeꞌcꞌuaꞌ ndaa ndoꞌ ñetquiaayâ ndaatioo na tꞌuaꞌ? ");
INSERT INTO amuNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Cwaaⁿ ntyꞌiaayâ ꞌu na tyomaꞌnoomꞌ yuu na ticataꞌjnaaⁿꞌ nnꞌaⁿ ꞌu ndoꞌ toꞌño̱o̱ⁿyâ ꞌu quiiꞌntaaⁿyâ, oo na ntyꞌiaayâ ꞌu na ntsaandyuꞌ ndoꞌ jlaꞌtsaaⁿꞌndyô̱ ꞌu? ");
INSERT INTO amuNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Cwaaⁿ ntyꞌiaayâ ꞌu na wiꞌ oo na mꞌaaⁿꞌ pra̱so ndoꞌ sacajndo̱o̱ꞌâ ꞌu?” ");
INSERT INTO amuNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Quia joꞌ ja na cwiluiindyo̱ na matsa̱ꞌntjo̱ⁿya nntsjo̱o̱ nda̱a̱ naⁿꞌñeeⁿ: “Mayuuꞌcheⁿ matsjo̱o̱ nda̱a̱ꞌyoꞌ, meiⁿquia na lꞌaꞌyoꞌ na teijndeiꞌyoꞌ cwii nnꞌaⁿya nmeiiⁿ na titꞌmaⁿ cwiluiiñe, nnco̱ teijndeiꞌyoꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","’Jnda̱ chii, ja na matsa̱ꞌntjo̱ⁿya nntsjo̱o̱ nda̱a̱ nnꞌaⁿ na mꞌaⁿ ntyjaaꞌa ntyjatymaaⁿꞌ: “Quindyo̱o̱ꞌyoꞌ nacañomya ꞌo nnꞌaⁿ na jnda̱ tso Tyꞌo̱o̱tsꞌom na catꞌuiiwiꞌnaꞌ ꞌo. Jeꞌ jeꞌ nntsaꞌyoꞌ quiiꞌ chom na tijoom canduuꞌ na juu joꞌ seijndaaꞌñe Tyꞌo̱o̱tsꞌom cwentaaꞌ tsaⁿjndii na nlcoꞌwiꞌnaꞌ jom ñequio ángeles ꞌnaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ee tyomꞌaaⁿya na ñeꞌjndo̱ꞌa sa̱a̱ tînquiaꞌyoꞌ na nlcwaaꞌa. Tyomꞌaaⁿya na ñeꞌcꞌua ndaatioo sa̱a̱ tînquiaꞌyoꞌ na nncꞌua. ");
INSERT INTO amuNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Tyomaꞌno̱o̱ⁿya yuu na ticataꞌjnaaⁿꞌ nnꞌaⁿ ja sa̱a̱ tîcatoꞌñoomꞌyoꞌ ja. Tyomꞌaaⁿya na ntsaandyo̱ sa̱a̱ tîcalaꞌtsaaⁿꞌndyoꞌ ja. Tyomꞌaaⁿya na wiiꞌa sa̱a̱ tîcatsajndoꞌyoꞌ ja. Tyomꞌaaⁿya na pra̱so sa̱a̱ tîcatsantyjaꞌyoꞌ ja.” ");
INSERT INTO amuNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Quia joꞌ nntꞌo̱o̱ naⁿꞌñeeⁿ no̱o̱ⁿ, nluena: “Ta, ¿cwaaⁿ ñentyꞌiaayâ ꞌu na ñeꞌjndoꞌ, oo na ñeꞌcꞌuaꞌ ndaa, oo na ñetoꞌnoomꞌ yuu na ticataꞌjnaaⁿꞌ nnꞌaⁿ ꞌu, oo na ñetꞌoomꞌ na ntsaandyuꞌ, oo na ñeteiwiꞌ, oo na ñetꞌoomꞌ pra̱so sa̱a̱ tîcateiꞌjndeiiyâ ꞌu?” ");
INSERT INTO amuNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Quia joꞌ nntsjo̱o̱ nda̱a̱ naⁿꞌñeeⁿ: “Mayuuꞌcheⁿ matsjo̱o̱ nda̱a̱ꞌyoꞌ, ncꞌe na tîcateijndeiꞌyoꞌ nnꞌaⁿya nmeiiⁿ na titꞌmaⁿ cwiluiindye, matyꞌiomnaꞌ nnco̱ tîcateiꞌjndeiꞌyoꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ndoꞌ nncꞌoo naⁿꞌñeeⁿ yuu na tijoom cantycwii na nlcoꞌwiꞌnaꞌ joona. Sa̱a̱ nnꞌaⁿ na mꞌaⁿ cantyja na matyꞌiomyanaꞌ nntoꞌñoomna na tijoom cantycwii na nntaꞌndoꞌna. ");
INSERT INTO amuNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jnda̱ na seineiⁿ Jesús chaꞌtso ñꞌoommeiⁿꞌ, seineiiⁿ nda̱a̱ jâ nnꞌaⁿ na cwilajomndyô̱ ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Tsoom: —ꞌO nquiuꞌyoꞌ na we xuee cwii tjo̱o̱ ndoꞌ nncueeꞌ xuee pascua. Ndoꞌ ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee maquialjoꞌ nñeꞌquia nnꞌaⁿ cwenta ja luee nnꞌaⁿ na nntyꞌioomna ja tsꞌoomꞌnaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ndoꞌ ntyee na cwiluiitquiendye ñequio nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés ñequio nnꞌaⁿ na cwiluiitquiendye naquiiꞌ tsjoom, mañejuu xjeⁿꞌñeeⁿ tjomndyena tachꞌeeⁿꞌ wꞌaa tꞌmaⁿ, waaꞌ tyee na cwiluiitquieñe na jndyu Caifás. ");
INSERT INTO amuNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Tyoꞌmaⁿna ñꞌeⁿ ncꞌiaana chiuu nlꞌayoona na nñequioꞌnnꞌaⁿna Jesús cha ntꞌuena jom, ndoꞌ na nlaꞌcueeꞌna jom. ");
INSERT INTO amuNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Jlaꞌtiuuna, jluena nda̱a̱ ncꞌiaana: —Sa̱a̱ ticatꞌua̱a̱ya jom xcwe ncuee cha ticalaꞌwendye nnꞌaⁿ nacjooya. ");
INSERT INTO amuNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Tyomꞌaaⁿ Jesús tsjoom Betania waaꞌ Simón, tsaⁿ na ñechuu tycu lepra. ");
INSERT INTO amuNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Wacatyeeⁿ nacañoomꞌ meiⁿsa ndoꞌ tueeꞌcañoom cwii yuscu na maleiñꞌoom cwii tsioo na tuiinaꞌ ñꞌeⁿ tsjo̱ꞌ canchiiꞌ na jndyu alabastro. Tsiooꞌñeeⁿ ñjom ncheⁿꞌ cachi na jeeⁿ jnda. Tuꞌnquioom joonaꞌ xqueⁿ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ndoꞌ jâ nnꞌaⁿ na cwilajomndyô̱ ñꞌeⁿñê, quia na ntyꞌiaayâ na luaaꞌ, jlaꞌliooꞌndyô̱, lꞌuuyâ: —Jeeⁿcheⁿ ndyaaꞌ cweꞌchi tsuu ncheⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Yati xeⁿ teilꞌuanaꞌ ee jndye sꞌom nncwjiꞌnaꞌ na nluii naya ndyeñeeⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Quia seiꞌno̱ⁿꞌ Jesús na luaaꞌ cwilꞌuuyâ, tsoom nda̱a̱yâ: —¿Chiuu na cwilaꞌliooꞌndyoꞌ ñꞌeⁿ yuscumꞌaaⁿꞌ? ee jeeⁿ tjacanjoomꞌ nayawaaꞌ na sꞌaaⁿ ñꞌeⁿndyo̱. ");
INSERT INTO amuNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ee ja nchii ñequiiꞌcheⁿ nncꞌo̱o̱ⁿya ñꞌeⁿndyoꞌ sa̱a̱ ndyeñeeⁿꞌ ñequiiꞌcheⁿ mꞌaⁿna quiiꞌntaaⁿꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Yuscumꞌaaⁿꞌ na tuꞌnquioom ncheⁿꞌ nacjoya, matseijndaaꞌñenaꞌ na nncjaacantyꞌiuuꞌndyo̱. ");
INSERT INTO amuNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Mayuuꞌcheⁿ nndyeꞌyoꞌ nntsjo̱o̱, meiⁿyuucheⁿ na nñeꞌquia nnꞌaⁿ ñꞌoom naya ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom na chaꞌwaa tsjoomnancue, maxjeⁿ nlaꞌneiⁿna cantyja ꞌnaaⁿꞌ naya na sꞌaa yuscumꞌaaⁿꞌ cha ticatsuu ñꞌoom cantyja ꞌnaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ndoꞌ cwii jâ nnꞌaⁿ na canchooꞌwendyô̱, juu tsaⁿ na jndyu Judas Iscariote, tjaaⁿ na mꞌaⁿ ntyee na cwiluiitquiendye. ");
INSERT INTO amuNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Tsoom nda̱a̱na: —¿Cwanti nncwantjo̱ⁿ nlꞌaꞌyoꞌ, nñequia cwenta Jesús lueeꞌyoꞌ? Jlaꞌjndaaꞌndyena, tquiana ntquiuu nchooꞌ qui sꞌom xuee. ");
INSERT INTO amuNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ndoꞌ xjeⁿꞌñeeⁿ to̱o̱ⁿꞌo̱ⁿ, tyolꞌueeꞌñê chiuu ya nntsꞌaaⁿ na nñequiaaⁿ cwenta Jesús lueena. ");
INSERT INTO amuNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Tueeꞌ xuee na cwiwityeⁿ ncuee na cwicwaꞌ nnꞌaⁿ tyooꞌ na tjaa ndaaljoꞌ tjaquieeꞌ. Jâ nnꞌaⁿ na cwilajomndyô̱ ñꞌeⁿ Jesús jlaꞌcandyooꞌndyô̱ na mꞌaaⁿ, lꞌuuyâ: —¿Yuu lꞌue tsꞌomꞌ na nntsalajndaaꞌndyô̱ cantyja ꞌnaaⁿꞌ xuee pascua na nleiñꞌoomꞌ na nlquiꞌ catsmaⁿ? ");
INSERT INTO amuNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Tꞌo̱o̱ⁿ nda̱a̱yâ, tsoom: —Catsaquieꞌyoꞌ quiiꞌ tsjoom, canduꞌyoꞌ nnom juu tsꞌaⁿ na nliuꞌyoꞌ: “Ndiꞌ matso Maestro tsꞌaⁿ na maꞌmo̱o̱ⁿ nda̱a̱yâ na majnda̱ jaaweꞌntyjo̱ xjeⁿ na nlcoꞌwiꞌnaꞌ jom. Lꞌue tsꞌoom na nnteijndeiꞌ waꞌ na nleijndaaꞌ na nlcwaaⁿꞌaⁿ, nlqueeⁿ catsmaⁿ na nntseitꞌmaaⁿꞌñê xuee pascua ñequio jâ nnꞌaⁿ na cwilajomndyô̱ ñꞌeⁿñê.” ");
INSERT INTO amuNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ndoꞌ lꞌaayâ chaꞌxjeⁿ na tsoom. Jlajndaaꞌndyô̱ na nlcwaaꞌâ natmaaⁿ xuee pascua. ");
INSERT INTO amuNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Jnda̱ na teinco̱o̱ⁿꞌ ncue, tjawacatyeeⁿ Jesús nacañoomꞌ meiⁿsa ñequio jâ na canchooꞌwendyô̱. ");
INSERT INTO amuNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ndoꞌ yocheⁿ na cwicwaaꞌâ to̱o̱ⁿꞌo̱ⁿ, seineiiⁿ nda̱a̱yâ, tsoom: —Mayuuꞌcheⁿ nndyeꞌyoꞌ nntsjo̱o̱, cwiindyoꞌ ꞌo nñequiaa cwenta ja luee nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ñꞌoomwaaꞌ jeeⁿ ndyaaꞌ seichjooꞌnaꞌ nꞌo̱o̱ⁿyâ. To̱o̱ꞌâ cwii ndoꞌ cwiindyô̱ taꞌxꞌa̱a̱yâ nnoom, lꞌuuyâ: —Ta, ¿aa nntsꞌaacheⁿnaꞌ na ja? ");
INSERT INTO amuNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Tꞌo̱o̱ⁿ nda̱a̱yâ, tsoom: —Cwii tsꞌaⁿ na jnda̱ tjoom xiowaa ñꞌeⁿndyo̱, tsaⁿꞌñeeⁿ nñequiaaⁿ cwenta ja. ");
INSERT INTO amuNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ndoꞌ maxjeⁿ nlcoꞌwiꞌnaꞌ ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee chaꞌxjeⁿ na matso ljeii ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom. Sa̱a̱ jeeⁿ ntyꞌiaaꞌñe juu tsꞌaⁿ na nñequiaa cwenta ja luee nnꞌaⁿ. Yati xeⁿ tîcaluiiñe tsaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Quia joꞌ tꞌo̱ Judas, tsaⁿ na nñequiaa cwenta jom. Tso: —ꞌU Maestro, ¿aa nntsꞌaacheⁿnaꞌ na ja? Tꞌo̱ Jesús nnoom: —Majoꞌndyo chaꞌxjeⁿ jnda̱ tsuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Yocheⁿ na cwicwaaꞌâ toꞌñom Jesús tyooꞌ, seitꞌmaaⁿꞌñê Tyꞌo̱o̱tsꞌom cantyja ꞌnaaⁿꞌnaꞌ. Tyjeeⁿ juunaꞌ, tquiaaⁿ nda̱a̱yâ. Tsoom: —Catoꞌñoomꞌyoꞌ cwaꞌyoꞌ tyooꞌwaa, ee cwiluiiñenaꞌ seiiꞌa. ");
INSERT INTO amuNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Mati toꞌñoom cwii waso na ñjom ndaa winom, tquiaaⁿ na quianlꞌuaaꞌ Tyꞌo̱o̱tsꞌom. Jnda̱ chii tquiaaⁿ juunaꞌ nda̱a̱yâ, tsoom: —Luaa cweꞌyoꞌ. Caluiꞌ cjaanaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ndaa winomwaa cwiluiiñenaꞌ nioomꞌa na ñequio juunaꞌ maqua̱ⁿtya̱ⁿya ñꞌoom xco cha nnda̱a̱ ntseitꞌmaⁿ tsꞌom Tyꞌo̱o̱tsꞌom jnaaⁿ jndyendye nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nndyeꞌyoꞌ nntsjo̱o̱, xuee na cwii wjaatinaꞌ taxocꞌuanndaꞌa ndaa winom hasta quia jnda̱ tueꞌntyjo̱ na mamatsa̱ꞌntjom Tsotya̱. Quia ljoꞌcheⁿ nncꞌuaxco̱ juunaꞌ ñꞌeⁿndyoꞌ yuu na matsa̱ꞌntjoom. ");
INSERT INTO amuNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Taayâ cwii luantsa, jnda̱ chii jluiiꞌâ joꞌ joꞌ. Saayâ ta na jndyu Olivos. ");
INSERT INTO amuNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Quia joꞌ tso Jesús nda̱a̱yâ: —Tsjom jeꞌ chaꞌtsondyoꞌ ꞌo nntjeiꞌndyoꞌ ñꞌeⁿndyo̱. Ee ljeii ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom matsonaꞌ: “Nlaꞌcueeꞌ nnꞌaⁿ juu tsꞌaⁿ na machꞌee cwenta canmaⁿ. Ndoꞌ canmaⁿ ntsmeiiⁿꞌeⁿ nntꞌoomꞌndyeyoꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ndoꞌ tsotyeeⁿ nda̱a̱yâ: —Ja quia na jnda̱ mawando̱ꞌxco̱ na jnda̱ tyꞌio̱, nncjo̱jndya̱a̱ tsꞌo̱ndaa Galilea, xeⁿ jnda̱ nntsantyjo̱ꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ndoꞌ tꞌo̱ Pedro nnoom, tso: —Meiiⁿ chaꞌtsondye naⁿmꞌaⁿꞌ nntjeiiꞌndyena ñꞌeⁿndyuꞌ sa̱a̱ ja tijoom cwjiꞌndyo̱ ñꞌeⁿndyuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Tꞌo̱ Jesús nnoom, tso: —Mayuuꞌcheⁿ matsjo̱o̱ njomꞌ, tsjom jeꞌ, cwii tjo̱o̱cheⁿ na nntseixuaa caxtijndyo, sa̱a̱ ꞌu jnda̱ ndyee ndiiꞌ macwjiꞌndyuꞌ ñꞌeⁿndyo̱. ");
INSERT INTO amuNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Tso Pedro nnoom: —Meiiⁿ na nncjuꞌnaꞌ na cꞌio̱ ñꞌeⁿndyuꞌ sa̱a̱ tijoom cwjiꞌndyo̱ cantyja ꞌnaⁿꞌ. Ndoꞌ majuu ñꞌoom tꞌo̱o̱yâ na chaꞌtsondyô̱ na cwilajomndyô̱ ñꞌeⁿ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ndoꞌ squia̱a̱yâ cwii joo na jndyunaꞌ Getsemaní. Tsoom nda̱a̱yâ: —Cwindyuaandyoꞌ ñjaaⁿñe yocheⁿ na jo̱ luaaꞌ na nntseina̱ⁿya nnom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Quia joꞌ tjatyeeⁿ, tjañꞌoom Pedro ñequio we ntseinda Zebedeo. Jnaⁿnaꞌ na tꞌmaⁿ matseiꞌndaaꞌnaꞌ ntyjeeⁿ, ndoꞌ jeeⁿ matseichjooꞌnaꞌ tsꞌoom. ");
INSERT INTO amuNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Tsoom nda̱a̱na: —Jeeⁿcheⁿ ndyaaꞌ matseichjooꞌnaꞌ tsꞌo̱o̱ⁿ hasta jom ndyoweꞌ tsꞌo̱o̱ⁿ. Caljooꞌndyoꞌ ljoo. Cꞌomꞌcꞌeendyoꞌ, calajomndyoꞌ ñꞌeⁿndyo̱, nchii cwindaꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Quia joꞌ tjatjatyeeⁿ chjoowiꞌ. Tjawanquioom na matseitꞌmaaⁿꞌñê Tyꞌo̱o̱tsꞌom. Tyochꞌeeⁿ tyꞌoo nnom, tsoom: —Tsotya̱ya, xeⁿ aa waa na nnda̱a̱ nluii, quiaaꞌ na tincwino̱o̱ⁿya nawiꞌwaa na matseijomnaꞌ cwii na jeeⁿ ja. Sa̱a̱ meiiⁿ na luaaꞌ macaⁿꞌa, caluii chaꞌxjeⁿ na lꞌue tsꞌomꞌ nncuꞌ, nchii chaꞌxjeⁿ na lꞌue tsꞌo̱o̱ⁿ ja. ");
INSERT INTO amuNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Jnda̱ joꞌ jndyolcweeⁿꞌeⁿ na mꞌaⁿ ndyee naⁿꞌñeeⁿ na cwilaꞌjomndye ñꞌeⁿñê. Ljeiiⁿ na cwindana. Tsoom nnom Pedro: —ꞌU Pedro, ¿aa tîcanda̱a̱ nlaquii nꞌomꞌyoꞌ meiiⁿ ñeꞌcwii hora na ticandaꞌyoꞌ na nlajomndyoꞌ ñꞌeⁿndyo̱? ");
INSERT INTO amuNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Chaꞌtsondyoꞌ cꞌomꞌcꞌeendyoꞌ na calaneiⁿꞌyoꞌ nnom Tyꞌo̱o̱tsꞌom cha ticjaachuunaꞌ ꞌo xjeⁿ ꞌnaaⁿꞌnaꞌ quia wiꞌ cwitjomꞌyoꞌ. Mayuuꞌ, jeeⁿ mꞌaaⁿcꞌeeꞌ tsꞌom tsꞌaⁿ na nntsꞌaa yuu na macaⁿnaꞌ sa̱a̱ ncꞌe na tsꞌaⁿ tseixmaaⁿ, tileicanaⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jnda̱ joꞌ tjannaaⁿꞌaⁿ na jnda̱ we ndiiꞌ na nntseineiiⁿ nnom Tyꞌo̱o̱tsꞌom. Tsoom: —Tsotya̱ya, xeⁿ xocanda̱a̱ na nncwinomꞌnaꞌ nawiꞌ na nntjo̱ⁿya, ñecuaa, caluii chaꞌxjeⁿ na lꞌue tsꞌomꞌ nncuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Jndyonnaaⁿꞌaⁿ na mꞌaⁿ naⁿꞌñeeⁿ. Ljeiiⁿ maxjeⁿ cwindana, ee jeeⁿ tyeⁿ maleichuu tsaⁿtsjom joona. ");
INSERT INTO amuNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Quia joꞌ ꞌñeeⁿ joona, tjannaaⁿꞌaⁿ na seineiiⁿ nnom Tyꞌo̱o̱tsꞌom na jnda̱ ndyee ndiiꞌ. Mañejooti ñꞌoom tyotseityꞌooñê. ");
INSERT INTO amuNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Tyjeeꞌcañoomnnaaⁿꞌaⁿ naⁿꞌñeeⁿ, tsoom nda̱a̱na: —¿Aa maxjeⁿ ndicwaⁿ cwindaꞌyoꞌ? Ya na mañjom cwitaꞌjndyeeꞌyoꞌ. Cwa jeꞌ cꞌomꞌcꞌeendyoꞌ, ee jnda̱ tueꞌntyjo̱ xjeⁿ cantyja ꞌnaⁿya na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee. Jeꞌ mañequiaa tsꞌaⁿ cwenta ja luee nnꞌaⁿ na wiꞌndye. ");
INSERT INTO amuNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Quicantyjaꞌyoꞌ, cjaaya. Cantyꞌiaꞌyoꞌ luaaꞌ mandyocwjeeꞌcañoom juu tsꞌaⁿ na mañequiaa cwenta ja luee nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Ndicwaⁿ matseineiⁿ Jesús ndoꞌ tyjeeꞌcañoom Judas, cwii jâ nnꞌaⁿ na canchooꞌwendyô̱. Jndyochom jndye nnꞌaⁿ na mꞌaⁿ cantyja ꞌnaaⁿ ntyee na cwiluiitquiendye ndoꞌ cantyja ꞌnaaⁿ nnꞌaⁿ na cwiluiitquiendye naquiiꞌ tsjoom. Cwileiꞌcho naⁿꞌñeeⁿ ncjo espadas ñequio nꞌoom nchꞌio. ");
INSERT INTO amuNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ndoꞌ Judas, tsaⁿ na tquiaa cwenta Jesús, jnda̱ tꞌmo̱o̱ⁿ ꞌnaaⁿ chiuu waa na nntsꞌaaⁿ. Tsoom: —Tsꞌaⁿ na nncꞌua ntsmaⁿꞌ maxjeⁿ juu na cwilꞌueꞌyoꞌ. Mana catꞌueꞌyoꞌ jom. ");
INSERT INTO amuNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Mañoomꞌ tyjeeꞌcañoom nacañoomꞌ Jesús. Tsoom nnom: —Xmaⁿndyuꞌ Maestro. Ndoꞌ tꞌom ntsmaⁿꞌ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Tso Jesús nnoom: —Xmaⁿndyuꞌ. Tsꞌiaaⁿ na jndyoꞌ, mana catseicanda̱a̱ꞌndyuꞌ. Quia joꞌ tquieꞌcañom naⁿꞌñeeⁿ Jesús, tꞌuena jom. Jlaꞌtyeⁿna jom. ");
INSERT INTO amuNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ndoꞌ cwiindyô̱ jâ na ñꞌa̱a̱ⁿyâ ñꞌeⁿ Jesús, tjeiꞌñoomñe xjooꞌ. Tyjee tsuaꞌqui mosooꞌ tyee na cwiluiitquieñe. ");
INSERT INTO amuNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Quia joꞌ tso Jesús nnoom: —Cwjaaꞌndyuꞌnndaꞌ xjoꞌ naquiiꞌ tjaⁿwaaꞌnaꞌ. Ee juu tsꞌaⁿ na machꞌee nata̱ꞌ quio xjo mañequio joꞌ nncueeⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Aa ticatseitiuuꞌ na nnda̱a̱ nlcaaⁿꞌa nnom Tsotya̱ ndoꞌ jom mañoomꞌ njñoom meiⁿcheⁿ ntmaaⁿꞌ ángeles na nnteiꞌjndeiina ja? ");
INSERT INTO amuNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Sa̱a̱ xeⁿ na nmeiⁿꞌ nntsꞌaa, ¿chiuu nntseicanda̱a̱ꞌñeyuunaꞌ ljeii ꞌnaaⁿꞌaⁿ na matsonaꞌ na tseixmaⁿya na catjo̱ⁿya na luaa? ");
INSERT INTO amuNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ndoꞌ tso Jesús nda̱a̱ chaꞌtso nnꞌaⁿ: —Jndaꞌjom ñꞌeⁿ ncjo espadas ñꞌeⁿ nꞌoom nchꞌio tquiocatꞌueꞌyoꞌ ja chaꞌcwijom tquioꞌyoꞌ nacjooꞌ cwii tsaⁿcanchꞌue. ꞌIo ndii ꞌio ñetaꞌcatya̱ⁿ naquiiꞌ watsꞌom tꞌmaⁿ na ñetꞌmo̱o̱ⁿ nda̱a̱ꞌyoꞌ, sa̱a̱ tîcatꞌueꞌyoꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Sa̱a̱ chaꞌtso na matjo̱ⁿ nmeiiⁿ cwicaluiꞌyuuꞌ ñꞌoom ndyuee profetas. Quia joꞌ chaꞌtsondyô̱ na cwilajomndyô̱ ñꞌeⁿ Jesús jleiꞌno̱o̱ⁿyâ, ꞌndya̱a̱yâ jom na ñenqueⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Quia joꞌ nquiee nnꞌaⁿ na tꞌue Jesús, tyꞌeñꞌomna jom waaꞌ Caifás, juu tyee na cwiluiitquieñe. Joꞌ joꞌ jnda̱ tjomndye nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés, ñequio nnꞌaⁿ na cwiluiitquiendye naquiiꞌ tsjoom. ");
INSERT INTO amuNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ndoꞌ Pedro tquiacheⁿ tquia tjantyjo̱o̱ⁿ naxeⁿꞌ Jesús. Tueⁿꞌeⁿ waaꞌ tyee na cwiluiitquieñe. Tjaqueⁿꞌeⁿ tachꞌeeⁿꞌ wꞌaaꞌñeeⁿ. Tjacjom quiiꞌntaaⁿ nnꞌaⁿ na cwilꞌa cwenta watsꞌom, cha nntyꞌiaaⁿꞌaⁿ chiuu nncjaajuꞌyuunaꞌ cantyja ꞌnaaⁿꞌ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ndoꞌ ntyee na cwiluiitquiendye ñequio nnꞌaⁿ na cwiluiitquiendye naquiiꞌ tsjoom ñequio chaꞌtsondye ntꞌomcheⁿ nnꞌaⁿ na mꞌaⁿ nꞌiaaⁿ, tyolꞌueena nnꞌaⁿ na calue ñꞌoom cantu nacjooꞌ Jesús cha nnda̱a̱ nleijndaaꞌ jnaaⁿꞌaⁿ na cueeⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Sa̱a̱ meiiⁿ na jndye nnꞌaⁿ jlue ñꞌoom cantu nacjoomꞌm na waa jnaaⁿꞌaⁿ maxjeⁿ ticaluiꞌyuuꞌ ñꞌoomꞌñeeⁿ. Jnda̱ chii wendye naⁿꞌñeeⁿ tjoomꞌ cantu jluena: ");
INSERT INTO amuNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","—Tsaⁿmꞌaaⁿꞌ ñetsoom jom nntseityueeⁿꞌeⁿ watsꞌom tꞌmaⁿ cwentaaꞌ Tyꞌo̱o̱tsꞌom, ndoꞌ ñendyee xuee na nntsꞌaaxcoom cwiicheⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Quia joꞌ nquii tyee na cwiluiitquieñe teintyjeeⁿꞌeⁿ, tsoom nnom Jesús: —¿Aa maxjeⁿ meiⁿcwii ñꞌoom ticꞌo̱ꞌ? ¿Chiuu waayuu na nmeiiⁿꞌ ñꞌoom cwitjeiꞌyuuꞌndye naⁿmꞌaⁿꞌ nacjoꞌ? ");
INSERT INTO amuNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Sa̱a̱ Jesús meiⁿcwii ñꞌoom ticꞌo̱o̱ⁿ. Quia joꞌ nquii tyee na cwiluiitquieñe tso nnoom: —Ñequio xueeꞌ Tyꞌo̱o̱tsꞌom na wandoꞌ, tyeⁿ matsa̱ꞌntjo̱ⁿya ꞌu, catsuꞌ ñꞌoom na mayuuꞌ. Catsuꞌndyeyuꞌ nndya̱a̱yâ, ¿aa ꞌu cwiluiindyuꞌ Cristo, Jnda Tyꞌo̱o̱tsꞌom? ");
INSERT INTO amuNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Tꞌo̱ Jesús nnoom: —Majoꞌndyo ñꞌoom na matsuꞌ. Ndoꞌ mati matseicandiiya ꞌo na ꞌio cha xuee na cwii wjaatinaꞌ nntyꞌiaꞌnda̱a̱ꞌyoꞌ ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee na mꞌaaⁿndyo̱ yuu na matseitꞌmaaⁿꞌñenaꞌ ja ntyjaaꞌ Tyꞌo̱o̱tsꞌom ntyjaya. Jom tseixmaaⁿ chaꞌtso najnda̱. Ndoꞌ nntyꞌiaꞌyoꞌ ja na nnaaⁿ cañoomꞌluee na nndyo̱cua̱nndaꞌa ñequio nchquiu. ");
INSERT INTO amuNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Quia joꞌ tyee na cwiluiitquieñe jndiiꞌñê liaⁿꞌaⁿ na lioomꞌm, tsoom: —Tsaⁿmꞌaaⁿ jnda̱ seineiiⁿ ñꞌomntjeiⁿ nacjooꞌ Tyꞌo̱o̱tsꞌom. Ticaⁿtinaꞌ ꞌñeeⁿ na nncwjiꞌyuuꞌñe nacjoomꞌm. ꞌO cwindyeꞌyoꞌ ñꞌomntjeiⁿ na tsoom. ");
INSERT INTO amuNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Ljoꞌ cwilatiuuꞌyoꞌ jeꞌ ñꞌeⁿñê? Tꞌo̱o̱ nnꞌaⁿ nnoom, jluena: —Tsaⁿmꞌaaⁿꞌ maxjeⁿ tseixmaaⁿ na cueeⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ndoꞌ tyojñomna ndaajnaⁿꞌ nnoom. Tyotioona ndaꞌ jom ndoꞌ ntꞌom tyotmeiiⁿꞌ ndaꞌ watmeiⁿ nnoom. ");
INSERT INTO amuNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ndoꞌ jluena nnoom: —ꞌU na cwiluiindyuꞌ Cristo na jñom Tyꞌo̱o̱tsꞌom, cwa cjaaweeꞌ ꞌndyoꞌ ꞌñeeⁿ tmeiⁿꞌ ndaꞌ ꞌu. ");
INSERT INTO amuNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Yocheⁿ na cwiluii na nmeiiⁿꞌ, Pedro wacatyeeⁿ tachꞌeⁿ ndoꞌ tyjeeꞌcañoom cwii yuscu na mandiꞌntjom joꞌ joꞌ. Tso tsaⁿꞌñeeⁿ nnoom: —ꞌU maxjeⁿ ñeñꞌeⁿꞌ ñꞌeⁿ Jesús, tsaⁿ na jnaⁿ Galilea. ");
INSERT INTO amuNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Sa̱a̱ Pedro tjeiꞌñê ñequio na ndye chaꞌtsondye naⁿꞌñeeⁿ. Tsoom: —Meiⁿchjoo ticaljeii ñꞌoom na matsuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Jnda̱ chii tjaaⁿ na waa ꞌndyootsꞌa tꞌmaⁿ ndoꞌ cwiicheⁿ yuscu na mandiꞌntjom joꞌ joꞌ ljeii jom. Tso tsaⁿꞌñeeⁿ nda̱a̱ nnꞌaⁿ na mꞌaⁿ na nndyooꞌ: —Tsaⁿmꞌaaⁿ maxjeⁿ ñeñꞌeeⁿ ñꞌeⁿ Jesús, tsaⁿ na jnaⁿ Nazaret. ");
INSERT INTO amuNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Cwiicheⁿ cwii ndiiꞌ tjeiꞌñe Pedro mana tjeiꞌyom xueeꞌ Tyꞌo̱o̱tsꞌom. Tsoom: —Ntyjii Tyꞌo̱o̱tsꞌom na ticwajnaⁿꞌa tsaⁿmꞌaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Tyoowiquiuuꞌ ndoꞌ ntꞌomcheⁿ nnꞌaⁿ na meintyjeeꞌ joꞌ joꞌ tyꞌentyjaaꞌna jom. Jluena nnoom: —Mayuuꞌcheⁿ na ꞌu cwii joo nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿ tsaⁿmꞌaaⁿꞌ. Ee ñꞌoom na matseiꞌneiⁿꞌ maꞌmo̱ⁿnaꞌ na Galilea jnaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Quia joꞌ to̱ꞌ Pedro na tjuꞌ cheⁿnqueⁿ ñꞌomwiꞌ nacjoomꞌm. Tsoom na ntyjiicheⁿ Tyꞌo̱o̱tsꞌom na mayomꞌm. Tsoom: —Ja maxjeⁿ ticwajnaⁿꞌa tsaⁿmꞌaaⁿꞌ. Ndoꞌ majoꞌto xjeⁿꞌñeeⁿ seixuaa caxtijndyo. ");
INSERT INTO amuNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Mañoomꞌ tjañjoomꞌ tsꞌom Pedro juu ñꞌoom na jnda̱ tso Jesús nnoom: “Cwii tjo̱o̱cheⁿ na nntseixuaa caxtijndyo sa̱a̱ ꞌu jnda̱ ndyee ndiiꞌ macwjiꞌndyuꞌ ñꞌeⁿndyo̱.” Mana jlueeⁿꞌeⁿ chꞌeⁿ. Seiꞌndaaꞌñꞌeⁿnaꞌ ntyjeeⁿ, tyotyꞌioom. ");
INSERT INTO amuNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Quia na jnda̱ teincoo chaꞌtso ntyee na cwiluiitquiendye ñequio nnꞌaⁿ na cwiluiitquiendye quiiꞌ tsjoom nda̱a̱ nnꞌaⁿ judíos ñeꞌcwii jlaꞌtjoomꞌna ñꞌoom na tꞌmaⁿna cueꞌ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Jlaꞌtyeⁿna jom, tyꞌeñꞌomna jom. Tyꞌecatioona cwenta jom lꞌo̱ nquii Poncio Pilato na juu cwiluiiñe gobiernom. ");
INSERT INTO amuNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ndoꞌ Judas, tsꞌaⁿ na tquiaa cwenta Jesús luee naⁿꞌñeeⁿ, quia na ntyꞌiaaⁿꞌaⁿ na jnda̱ teijndaaꞌ na nncueꞌ Jesús, tioo na jeeⁿ tia ntyjeeⁿ cantyja na sꞌaaⁿ. Tjatseilcweeⁿꞌeⁿ ntquiuu nchooꞌ nqui sꞌom xuee nda̱a̱ ntyee na cwiluiitquiendye ñequio nda̱a̱ nnꞌaⁿ na cwiluiitquiendye quiiꞌ tsjoom. ");
INSERT INTO amuNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Tsoom nda̱a̱ naⁿꞌñeeⁿ: —Tꞌmaⁿ jnaⁿya waa na seiquio̱o̱ya cwii tsꞌaⁿ lueeꞌyoꞌ na tjaaꞌnaⁿ jnaⁿ tseixmaⁿ. Tꞌo̱o̱ naⁿꞌñeeⁿ nnoom, jluena: —¿Ljoꞌ machꞌeenaꞌ jâ na ljoꞌ? Candoꞌ nncuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Quia joꞌ Judas tyeⁿnqueeⁿꞌeⁿ sꞌom xueeꞌñeeⁿ naquiiꞌ watsꞌom tꞌmaⁿ. Jnda̱ joꞌ jlueeⁿꞌeⁿ, tjaaⁿ. Tjatseintyjañê, seicueeꞌñe cheⁿnqueⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ntyee na cwiluiitquiendye jlaꞌxcwiina sꞌomꞌñeeⁿ. Jluena: —Sꞌommeiiⁿ jnda̱ njomlꞌua na nncueꞌ tsꞌaⁿ. Joꞌ chii ticatyꞌiomyanaꞌ na nlatjo̱o̱ⁿꞌa joonaꞌ ñequio sꞌom na cwiquioo cwentaaꞌ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Jnda̱ na jlaꞌtjoomꞌna ñꞌoom ñꞌeⁿ ncꞌiaana, jlaꞌcatsuuna sꞌomꞌñeeⁿ. Tiomlꞌuana cwii taⁿꞌ tyuaa na jnda̱a̱ tsꞌaⁿ na machꞌee ncuaa. Joꞌ joꞌ lꞌana watsꞌom tyueꞌ yuu na nncꞌoocatyꞌiuuna lꞌoo, nnꞌaⁿ na cweꞌ cwiquieya tsjoomna. ");
INSERT INTO amuNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Cweꞌ joꞌ hasta xuee jeꞌ jndyu tyuaaꞌñeeⁿ Tyuaa Niomꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ndoꞌ na luaaꞌ tuii seicanda̱a̱ꞌñenaꞌ ñꞌoom ꞌndyoo profeta Jeremías, tsoom: “Nnꞌaⁿ Israel jlaꞌjndaaꞌndyena na njomlꞌuañe tsꞌaⁿ ntquiuu nchooꞌ nqui sꞌom xuee. Jnda̱ chii toꞌñoomlcweꞌna sꞌomꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ñequio joonaꞌ jlaꞌjndana cwii taⁿꞌ tyuaaꞌ tsꞌaⁿ na machꞌee ncuaa chaꞌxjeⁿ na tꞌmo̱ⁿ Tyꞌo̱o̱tsꞌom no̱o̱ⁿ na maxjeⁿ nluii.” ");
INSERT INTO amuNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Tyꞌeñꞌomna Jesús, tyomeintyjeeⁿꞌeⁿ jo nnom gobiernom Pilato. Taxꞌee tsaⁿꞌñeeⁿ nnoom: —¿Aa ꞌu cwiluiindyuꞌ Rey cwentaa nnꞌaⁿ judíos? Tꞌo̱ Jesús, tsoom: —Maxjeⁿ joꞌ ja, chaꞌna matsuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ntyee na cwiluiitquiendye ñequio nnꞌaⁿ na cwiluiitquiendye quiiꞌ tsjoom tquiana jnaaⁿꞌaⁿ nnom Pilato. Ndoꞌ meiiⁿ na cwiqueⁿna ñꞌoom nacjoomꞌm sa̱a̱ jom meiⁿcwii ñꞌoom tîcꞌo̱o̱ⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Joꞌ chii tso Pilato nnoom: —¿Aa maxjeⁿ ticandiꞌ ñꞌoommeiiⁿ na cwitjeiꞌyuuꞌndyena nacjoꞌ? ");
INSERT INTO amuNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Sa̱a̱ meiⁿcwii ꞌndyoo ñꞌoom tîcꞌo̱o̱ⁿ cantyja ñꞌoom na tueeꞌna nacjoomꞌm. Joꞌ chii sꞌaanaꞌ na jeeⁿ tjaweeꞌ tsꞌom Pilato na tîcꞌo̱ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ndoꞌ ticwii chu na nncueeꞌ xuee pascua tyowaa costumbre na nquii gobiernom nntseicandyaañê meiⁿcwiꞌñeeⁿcheⁿ pra̱so na nntaⁿ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ndoꞌ quia joꞌ tyomꞌaaⁿ cwii pra̱so na jndyu Barrabás wꞌaancjo na tꞌmaⁿ ñꞌoom waa nacjoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ndoꞌ quia na tjomndye nnꞌaⁿ, taxꞌee Pilato nda̱a̱na, tsoom: —Jeꞌ canduꞌyoꞌ, ¿ꞌñeeⁿ juu lꞌue nꞌomꞌyoꞌ na nntseicandyaandyo̱? ¿Aa juu Barrabás, oo ¿aa Jesús na cwilue nnꞌaⁿ na cwiluiiñe Cristo? ");
INSERT INTO amuNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ee seiꞌno̱ⁿꞌ Pilato na cweꞌ na jndoona Jesús joꞌ chii jlaꞌquioona juu lꞌo̱o̱ⁿ nchii ee na waa jnaaⁿꞌ tsaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ndoꞌ yocheⁿ na wacatyeeⁿ na nncuꞌxeeⁿ ñꞌoomꞌñeeⁿ seicwanom scoomꞌm cwii ñꞌoom na mꞌaaⁿ. Tso: “Ticatiiꞌndyuꞌ ñꞌoomwaaꞌ ee tsaⁿmꞌaaⁿꞌ matseixmaaⁿ cantyja na matyꞌiomyanaꞌ. Ee tsjom teincooquiuuꞌ jeeⁿ ñeseicachjuu tsaⁿtsjom ja cantyja ꞌnaaⁿꞌaⁿ.” ");
INSERT INTO amuNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ndoꞌ ntyee na cwiluiitquiendye ñequio nnꞌaⁿ na cwiluiitquiendye quiiꞌ tsjoom tyolaꞌjndo̱ꞌna nꞌom nnꞌaⁿ na cataⁿ naⁿꞌñeeⁿ na candyaañe juu Barrabás ndoꞌ Jesús cueeⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Joꞌ chii taxꞌeenndaꞌ Pilato nda̱a̱ nnꞌaⁿ na jndyendye, tsoom: —Cwa canduꞌyoꞌ, ¿cwaaⁿ cwii na wendye joona lꞌue nꞌomꞌyoꞌ na catseicandyaandyo̱? Joona tꞌo̱o̱na, jluena: —Juu Barrabás. ");
INSERT INTO amuNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Taxꞌeenndaꞌ Pilato nda̱a̱na. Tsoom: —Xeⁿ juu Barrabás nndyaañê quia joꞌ ¿chiuu nntsꞌaayo̱ ñequio Jesús na cwinduꞌyoꞌ na cwiluiiñe Cristo? Chaꞌtsondye naⁿꞌñeeⁿ tꞌo̱o̱na nnoom, jluena: —Catyꞌioomꞌ jom tsꞌoomꞌnaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Quia joꞌ taxꞌee Pilato nda̱a̱na, tsoom: —¿Ljoꞌ jnaⁿ tseixmaaⁿ nquiuꞌyoꞌ? Sa̱a̱ majndeiiti jlaꞌxuaa naⁿꞌñeeⁿ, jluena: —Catyꞌioomꞌ jom tsꞌoomꞌnaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Jnda̱ na ntyꞌiaaꞌ Pilato na tîcanaⁿñê ñꞌoomꞌñeeⁿ hasta manndyo na nlaꞌwendyena nacjoomꞌm, quia joꞌ tcaaⁿ ndaatioo, jñoomꞌm na jndooꞌ chaꞌtsondye naⁿꞌñeeⁿ. Tsoom: —Jeꞌ mandyuuꞌa cha caluiꞌyuuꞌnaꞌ na ticacho̱o̱ jnaⁿ xeⁿ nlacueꞌyoꞌ tsaⁿmꞌaaⁿꞌ na tjaa jnaaⁿꞌ. Joꞌ chii, cajndoꞌ ncjoꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Sa̱a̱ tꞌo̱o̱ chaꞌtsondye naⁿꞌñeeⁿ, jluena: —Ljoꞌ chꞌeenaꞌ jâ. Ncjo̱o̱yâ nncho̱o̱nqua̱a̱ⁿyâ jnaⁿ ñequio ndaayâ na nncueꞌ tsaⁿmꞌaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Joꞌ chii Pilato seicandyaañê Barrabás chaꞌxjeⁿ na taⁿ nnꞌaⁿ. Ndoꞌ sa̱ꞌntjoom na calaꞌseiꞌ sondaro ꞌnaaⁿꞌaⁿ Jesús. Jnda̱ joꞌ tquiaaⁿ juu lueena na catyꞌioomna juu tsꞌoomꞌnaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Jnda̱ joꞌ tyꞌeñꞌom sondaroꞌñeeⁿ Jesús naquiiꞌcheⁿ watsꞌiaaⁿ. Joꞌ joꞌ jlaꞌtjomndye chaꞌtso ntmaaⁿꞌ sondaro nacañomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Tjeiiꞌna liaⁿꞌaⁿ ndoꞌ jlaꞌcweena cwiicheⁿ liaa jom, liaatco colo wee juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Ndoꞌ jlaꞌtyjoondyena nꞌoomnioom cwii tsei. Tioomna juunaꞌ xqueeⁿ chaꞌcwijom corona. Ndoꞌ tjaaꞌndyena cwii tsmaaⁿ tsꞌo̱o̱ⁿ ntyjaya chaꞌcwijom tsꞌoomlꞌeiiꞌ tsaⁿmatsꞌiaaⁿ tꞌmaⁿ. Jnda̱ chii tyotaꞌna cantyena jo nnoom na cweꞌ cwincona jom. Tyoluena: —Cwilaꞌtꞌmaaⁿꞌndyô̱ ꞌu Rey cwentaa nnꞌaⁿ judíos. ");
INSERT INTO amuNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Mati tyotueeꞌna ndaajnaⁿꞌ cjoomꞌm. Tjeiiꞌndyena tsmaaⁿ na ndiiꞌ tsꞌo̱o̱ⁿ, tyotmeiiⁿꞌna juunaꞌ xqueeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Jnda̱ tjacjoona na cwincona jom, quia joꞌ tjeiiꞌna liaatcoꞌñeeⁿ, jlaꞌcweenndaꞌna liaⁿꞌaⁿ jom. Jnda̱ chii tyꞌeñꞌomna jom na nntyꞌioomna jom tsꞌoomꞌnaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Xjeⁿ na maꞌoocaluiꞌna quiiꞌ tsjoom, tjomndyena cwii tsꞌaⁿ tsjoom Cirene na jndyu Simón. Lꞌana na jndeiꞌnaꞌ na cjaañꞌoom tsꞌoomꞌnaaⁿ na nñoom Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Tquiena cwii joo na jndyu Gólgota. Ñꞌoomwaaꞌ ñecatsonaꞌ Ta Tseiꞌxqueⁿ Tsꞌoo. ");
INSERT INTO amuNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tquiana winom na nncꞌom na tjoomꞌnaꞌ ñequio cwii nasei na ja. Sa̱a̱ taticꞌom quia ljeiiⁿ na tjoomꞌ naseiꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ndoꞌ quia jnda̱ tyꞌioom sondaro jom tsꞌoomꞌnaaⁿ, tyoꞌoona xꞌiaa na nntyꞌiaana ꞌñeeⁿ nleijnoomꞌ cwii cwii liaⁿꞌaⁿ. Ndoꞌ na luaaꞌ tuii seicanda̱a̱ꞌñenaꞌ ñꞌoom na seiljeii profeta. Tso: “Tyoꞌoona xꞌiaa na nntyꞌiaana ꞌñeeⁿ joona nleijnoomꞌ cwii cwii liaya.” ");
INSERT INTO amuNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Jnda̱ chii tyꞌecwindyuaandye sondaroꞌñeeⁿ na cwilꞌana cwenta Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ndoꞌ jo ndyeyu tsꞌom xqueeⁿ tyꞌioomna ljeii na tꞌmo̱ⁿnaꞌ jnaaⁿꞌaⁿ. Tsonaꞌ: “Luaañe juu Jesús na cwiluiiñe Rey cwentaa nnꞌaⁿ judíos.” ");
INSERT INTO amuNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Mati joꞌ joꞌ tyꞌioomna we naⁿcantyꞌue nꞌoomꞌnaaⁿ, cwii tsaⁿꞌñeeⁿ ñoom tsꞌoomꞌnaaⁿ na meintyjeeꞌ ntyjaaꞌ Jesús ntyjaya. Ndoꞌ cwiicheⁿ tsaⁿꞌñeeⁿ ñoom tsꞌoomꞌnaaⁿ na meintyjeeꞌ ntyjatymaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ndoꞌ nnꞌaⁿ na tyowinom joꞌ joꞌ tyoluena ñꞌomwiꞌ nacjooꞌ Jesús. Tyolaꞌcaandyena nqueⁿna. ");
INSERT INTO amuNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Tyoluena: —ꞌU tsꞌaⁿ na matsuꞌ na nntseityuiꞌ watsꞌom tꞌmaⁿ ndoꞌ ñendyee xuee nntseiweꞌnndaꞌ juunaꞌ, cwa jeꞌ cwjiꞌnꞌmaaⁿndyuꞌ cheⁿnncuꞌ. Xeⁿ mayuuꞌ na cwiluiindyuꞌ Jnda Tyꞌo̱o̱tsꞌom, cwa candyoꞌcueꞌ tsꞌoomꞌnaaⁿwaaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ndoꞌ ntyee na cwiluiitquiendye ñequio nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés, ñequio nnꞌaⁿ tmaaⁿꞌ fariseos, ñequio nnꞌaⁿ na cwiluiitquiendye naquiiꞌ tsjoom chaꞌtsondye naⁿꞌñeeⁿ mati maluaaꞌ tyolaꞌjnaaⁿꞌna Jesús. Tyoluena: ");
INSERT INTO amuNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Jeeⁿ ya ñetjeiꞌnꞌmaaⁿñê ntꞌomcheⁿ sa̱a̱ tileicanda̱a̱ nncwjiꞌnꞌmaaⁿñe cheⁿnqueⁿ. Xeⁿ mayuuꞌ na cwiluiiñê Rey cwentaa jaa nnꞌaⁿ Israel, cwa candyocueeⁿ na nñoom tsꞌoomꞌnaaⁿ quia joꞌ nlayuuꞌa ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Jom matseicantyjaaꞌ tsꞌoom ñequio Tyꞌo̱o̱tsꞌom ee tsoom nda̱a̱ya na jom cwiluiiñê Jnda Tyꞌo̱o̱tsꞌom. Joꞌ chii xeⁿ na mayuuꞌ na jnda ntyjii Tyꞌo̱o̱tsꞌom ñꞌeⁿñe, cwjiꞌnꞌmaaⁿñê juu. ");
INSERT INTO amuNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ndoꞌ mati naⁿcantyꞌue na ñom nꞌoomꞌnaaⁿ ñꞌeⁿ Jesús, tyotueeꞌna ñꞌomwiꞌ nacjoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Quia na tueeꞌ na quiajmeiⁿꞌ, teijaaⁿ chaꞌwaa tsjoomnancue hasta na ndyee na matmaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Juu xjeⁿꞌñeeⁿ jndeii seixuaa Jesús, tsoom: —Elí, Elí, lama sabactani. (Ñꞌoomwaaꞌ matsonaꞌ: Tsotya̱ya Tyꞌo̱o̱tsꞌom, ¿chiuu na maꞌndiiꞌ ja?) ");
INSERT INTO amuNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Cwantindye joo nnꞌaⁿ na mꞌaⁿ nndyooꞌ quia na jndyena ñꞌoommeiⁿꞌ, jluena: —Tsaⁿmꞌaaⁿꞌ macwaaⁿ profeta Elías. ");
INSERT INTO amuNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ndoꞌ mantyja jleinom cwii tsꞌaⁿ, tjacꞌoom cwii ꞌnaⁿ na ya mawꞌanaꞌ ndaa. Nchjeeñê juunaꞌ naquiiꞌ winom na ta̱, tioom juunaꞌ nnom tsmaaⁿ cha nnda̱a̱ nncueꞌcañoomnaꞌ ꞌndyoo Jesús na nncꞌuu. ");
INSERT INTO amuNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Sa̱a̱ ntꞌomcheⁿ nnꞌaⁿ tyoluena: —Caꞌndiiꞌ jom. Ñeꞌcantyꞌiaayâ aa nncwjeꞌcañoom Elías na nncwjiꞌnꞌmaaⁿñe jom. ");
INSERT INTO amuNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Quia joꞌ seixuaanndaꞌ Jesús jndeii, mana tueeⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ndoꞌ xjeⁿꞌñeeⁿ liaatco na ntyjatyꞌio watsꞌom tꞌmaⁿ jndiiꞌtconaꞌ hasta xjeⁿ nomtyuaacheⁿ. Jndeii sꞌeii tyuaa ndoꞌ tiuu ljo̱ꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mati jnaaⁿ ndeiꞌluaa ndoꞌ jndye nnꞌaⁿ na jnda̱ tja̱ na tyolaꞌyuꞌ ñequio Tyꞌo̱o̱tsꞌom tandoꞌnndaꞌna xjeⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Quia na jnda̱ tandoꞌnndaꞌ Jesús, mati naⁿꞌñeeⁿ jluiꞌna naquiiꞌ ndeiꞌluaana, tyꞌequieꞌna quiiꞌ tsjoom Jerusalén. Joꞌ joꞌ teitquiooꞌndyena nda̱a̱ jndye nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ndoꞌ juu capeitaⁿ ñequio sondaro ꞌnaaⁿꞌaⁿ na cwilꞌa cwenta Jesús quia na ntyꞌiaana na sꞌeii ndoꞌ tqueⁿna cwenta chaꞌtso na tuii, jeeⁿ ndyaꞌ tyuena. Jluena: —Mayuuꞌcheⁿ tsaⁿmꞌaaⁿꞌ tyoluiiñê Jnda Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ndoꞌ joꞌ joꞌ mꞌaⁿ jndye yolcu na cweꞌ cwintyꞌiaatquiana ljoꞌ cwiluii. Jnaⁿ naⁿꞌñeeⁿ tsꞌo̱ndaa Galilea, tquiontyjo̱na naxeⁿꞌ Jesús na cwindyeꞌntjomna nnoom. ");
INSERT INTO amuNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Quiiꞌntaaⁿ yolcuꞌñeeⁿ ñꞌeⁿ María Magdalena ñequio María tsondyee Jacobo ñꞌeⁿ José, ndoꞌ ñequio tsondyee ntseinda Zebedeo. ");
INSERT INTO amuNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Quia tueeꞌ na tmaaⁿ, cwii tsaⁿtya na jndyu José na jnaⁿ tsjoom Arimatea, cwiluiiñe tsꞌaⁿ na matseijomñe ñꞌoom na tꞌmo̱ⁿ Jesús, ");
INSERT INTO amuNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","tjaaⁿ na mꞌaaⁿ Pilato, tjacaaⁿ tsꞌoo Jesús. Ndoꞌ tquiaa Pilato ñꞌoomꞌm na nñeꞌquia sondaro seiꞌtsꞌo ꞌnaaⁿꞌ Jesús nnom José. ");
INSERT INTO amuNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Quia joꞌ tjacoꞌñom José Jesús, seityjooñê liaa sábana na ljuꞌ juu tsꞌooꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Jnda̱ chii tjaaꞌñê tsꞌooꞌñeeⁿ naquiiꞌ tsueꞌtsjo̱ꞌ xco na jnda̱ tuiiya na tseixmaⁿnaꞌ tseiꞌtsuaa ꞌnaaⁿꞌaⁿ. Jnda̱ joꞌ seicuuꞌñê ꞌndyoo tseiꞌtsuaa ñequio cwii tsjo̱ꞌ tꞌmaⁿ, mana tjaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ndoꞌ María Magdalena ñequio cwiicheⁿ María ntyꞌiaacheⁿna na luaaꞌ sꞌaaⁿ. Tyꞌewindyuaandyena ndyeyu ꞌndyoo tseiꞌtsuaaꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Xuee na tuii na luaaꞌ, maxuee na cwilaꞌjndaaꞌndye nnꞌaⁿ ꞌnaⁿ na nlcaⁿnaꞌ joona ee na ꞌio xuee na nntaꞌjndyeena. Quia na teincoo cwiicheⁿ xuee, ntyee na cwiluiitquiendye ñequio nnꞌaⁿ fariseos, ñecwii tmaaⁿꞌ tyꞌena na mꞌaaⁿ Pilato. ");
INSERT INTO amuNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Jluena nnoom: —ꞌU ta gobiernom, cwijaañjoomꞌ nꞌo̱o̱ⁿyâ ñꞌoom na tyotso tsaⁿcantuꞌñeeⁿ quia ndi wanoomꞌm. Tsoom na xuee jnda̱ ndyee nncwandoꞌxcoom jnda̱ na tueeⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Cweꞌ joꞌ lꞌue nꞌo̱o̱ⁿyâ na catsa̱ꞌntjomꞌ sondaro ꞌnaⁿꞌ, na cꞌoocalꞌana cwenta tseiꞌtsuaⁿꞌaⁿ hasta xeⁿjnda̱ teinom ndyee xuee cha nntseicuꞌnaꞌ na joo nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê nlquieꞌcañomna ndoꞌ nntyꞌueena seiꞌtsꞌo ꞌnaaⁿꞌaⁿ, jnda̱ joꞌ nluena nda̱a̱ nnꞌaⁿ na jom jnda̱ mawandoꞌxcoom na tueeⁿꞌeⁿ. Ndoꞌ juu cantuwaaꞌ tꞌmaⁿti nñequiuꞌnnꞌaⁿnaꞌ nnꞌaⁿ nchiiti ñꞌoom na ñeseineiiⁿ xjeⁿ na ñetanoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Tꞌo̱ Pilato nda̱a̱na, tsoom: —Nmeiiⁿ sondaro na mañequia lueeꞌyoꞌ. Cwa catsaꞌyoꞌ ñꞌeⁿndyena. Ya ya cwenta calꞌaꞌyoꞌ tseiꞌtsuaaꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Quia joꞌ tyꞌe naⁿꞌñeeⁿ. Tyꞌelaꞌcuꞌtyeⁿna tseiꞌtsuaa. Tyꞌioomna sa̱yo yuu na ntjom ꞌndyoo tsueꞌtsjo̱ꞌ quio tsjo̱ꞌ tꞌmaⁿ cha nno̱o̱ⁿ xeⁿ nntseicanaaⁿñe tsꞌaⁿ. Jnda̱ chii ꞌndyena sondaro na nlꞌa cwenta tseiꞌtsuaa. ");
INSERT INTO amuNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Jnda̱ teinom xuee na cwitaꞌjndyee nnꞌaⁿ judíos ndoꞌ jnda̱ jaawixuee xuee najndyee smanaⁿ, quia joꞌ tja María Magdalena ñequio cwiicheⁿ María, tyꞌecajndooꞌna tseiꞌtsuaa. ");
INSERT INTO amuNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Matsꞌia joꞌ jndeii sꞌeii. Ee cwii ángel cwentaaꞌ Tyꞌo̱o̱tsꞌom jnaaⁿ cañoomꞌluee, jndyocueeⁿ na waa tseiꞌtsuaa. Teiño̱o̱ⁿ tsjo̱ꞌ na ta̱ꞌ ꞌndyoo tseiꞌtsuaaꞌñeeⁿ, tjacjom nacjooꞌnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Chaꞌwaañê caxueeñê chaꞌcwijom chomtsuee. Ndoꞌ canchiiꞌ liaⁿꞌaⁿ chaꞌna canchiiꞌ tsaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ndoꞌ sondaro na cwilꞌa cwenta tseiꞌtsuaa, quia na ntyꞌiaana ángelꞌñeeⁿ tyoteindyena, tquiaandyena nomtyuaa, chaꞌcwijom lꞌoo joona. ");
INSERT INTO amuNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Quia joꞌ seineiⁿ ángel nda̱a̱ yolcuꞌñeeⁿ, tsoom: —Tilacatyuendyoꞌ. Ee mantyjiiya na Jesús cwilꞌueꞌyoꞌ, nquii tsaⁿ na tyꞌioom nnꞌaⁿ tsꞌoomꞌnaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Jeꞌ tacꞌoomñê ñjaaⁿ, ee na jnda̱ mawandoꞌxcoom na tueeⁿꞌeⁿ chaꞌxjeⁿ ñꞌoom ñetsoom. Quiocantyꞌiaꞌyoꞌ yuu ñetacatyeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Jnda̱ joꞌ calatyuaꞌyoꞌ, catsalacandiiꞌyoꞌ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê na jnda̱ mawandoꞌxcoom. Ndoꞌ canduꞌyoꞌ na mawjaañetyeeⁿ tsꞌo̱ndaa Galilea, jnda̱ joꞌ catsantjo̱ꞌyoꞌ. Joꞌ joꞌ nleicwindyoꞌ ñꞌeⁿñê. Ñꞌoommeiiⁿ jndyo̱catsjo̱o̱ya nda̱a̱ꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ndoꞌ yolcuꞌñeeⁿ, jndeii jluiꞌna tseiꞌtsuaa, jeeⁿ tyuena ndoꞌ neiiⁿna. Jlaꞌtyuaaꞌna na nlaꞌcandiina nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê na luaaꞌ jndyena. ");
INSERT INTO amuNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ndoꞌ matsꞌia joꞌ tjomndyena Jesús. Tquiaaⁿ na xmaⁿndyena. Ndoꞌ taꞌna cantyena, taꞌxcweendyena ncꞌeeⁿ na tyolaꞌtꞌmaaⁿꞌndyena jom. ");
INSERT INTO amuNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ndoꞌ tso Jesús nda̱a̱na: —Tilacatyuendyoꞌ. Catsaꞌyoꞌ, tsalacandiiꞌyoꞌ nnꞌaaⁿya na cꞌoona tsꞌo̱ndaa Galilea. Joꞌ joꞌ nntyꞌiaana ja. ");
INSERT INTO amuNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Yocheⁿ na ꞌoo yolcuꞌñeeⁿ, ntꞌom sondaro na tyolꞌa cwenta tseiꞌtsuaa tyꞌequieꞌna quiiꞌ tsjoom Jerusalén, tyꞌelaꞌcandiina ntyee na cwiluiitquiendye chaꞌtso na tuii. ");
INSERT INTO amuNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ndoꞌ ntyeeꞌñeeⁿ jlaꞌtjoomꞌna ñꞌoom ñequio nnꞌaⁿ na cwiluiitquiendye naquiiꞌ tsjoom, matꞌmaaⁿꞌ tsjo̱ꞌñjeeⁿ tquiana nda̱a̱ sondaroꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Ndoꞌ jluena nda̱a̱ naⁿꞌñeeⁿ: —Canduꞌyoꞌ nda̱a̱ nnꞌaⁿ na cweꞌ natsjom tquieꞌcañom nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿ Jesús. Tquiocantyꞌueena seiꞌtsꞌo ꞌnaaⁿꞌaⁿ xjeⁿ na cwindaꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Tincꞌomꞌyoꞌ ñꞌomtiuu tjaa ljoꞌ nntjomꞌyoꞌ, ee xeⁿ nndii gobiernom ñꞌoomwaaꞌ, jâ manquiuuyâ chiuu nluiꞌljuuꞌ ñꞌoom ꞌnaⁿꞌyoꞌ luaaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ndoꞌ toꞌñoom sondaro tsjo̱ꞌñjeeⁿꞌñeeⁿ. To̱ꞌna, tyotꞌoomna ñꞌoom chaꞌxjeⁿ na jnda̱ jndyena na caluena. Cweꞌ joꞌ hasta jeꞌcheⁿ ndicwaⁿ cwilaꞌneiⁿ nnꞌaⁿ judíos na tyꞌecantyꞌuee nnꞌaⁿ seiꞌtsꞌo ꞌnaaⁿꞌ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Quia joꞌ jâ na canchooꞌcwiindyô̱ saayâ tsꞌo̱ndaa Galilea. Saawaayâ cwii ta yuu na jnda̱ seicandii Jesús na catsaayâ. ");
INSERT INTO amuNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Xjeⁿ na ntyꞌiaayâ jom tyolatꞌmaaⁿꞌndyô̱ jom. Sa̱a̱ ñꞌeeⁿ cwantindyô̱ na tijndaaꞌ nquiuuyâ aa mayuuꞌ na jom. ");
INSERT INTO amuNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Quia joꞌ seicandyooꞌñê nacañoomyâ. Tsoom nda̱a̱yâ: —Nandye cañoomꞌluee ñequio tsjoomnancue, chaꞌwaa matseixmaⁿya najndo̱, ");
INSERT INTO amuNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","joꞌ chii catsaꞌyoꞌ na mꞌaⁿ nnꞌaⁿ ticwii cwii ndyuaa. Nñeꞌquiaꞌyoꞌ ñꞌoom naya nda̱a̱na cha nlaꞌyuꞌna ñꞌeⁿndyo̱. Calatsꞌoomndyoꞌ joona ñequio xueeꞌ Tsotya̱ya, ñequio xuee Ja na Jnaaⁿ, ndoꞌ ñequio xueeꞌ Espíritu Santo. ");
INSERT INTO amuNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Catꞌmo̱ⁿꞌyoꞌ na calaꞌcanda̱na chaꞌtso ñꞌoom na jnda̱ tquiaya nda̱a̱ꞌyoꞌ. Ndoꞌ cjaañjoomꞌ nꞌomꞌyoꞌ na mꞌaaⁿya ñꞌeⁿndyoꞌ ticwii xuee, hasta na nntycwii tsjoomnancue. Amén.");
INSERT INTO amuNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Luaa waa na jnaⁿ ñꞌoom naya cantyja ꞌnaaⁿꞌ Jesucristo, Jnda Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Jnda̱ seicanda̱a̱ꞌñenaꞌ ñꞌoom na seiljeii profeta Isaías, matsonaꞌ: Majño̱o̱ⁿñetya̱ya cwii moso ꞌnaⁿya na wjaajndyee jo njomꞌ. Jom nncwjiꞌyuuꞌñê cantyja ꞌnaⁿꞌ, cha mamꞌaⁿcꞌeendye nnꞌaⁿ quia na nncueꞌcañoomꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Jom tsꞌaⁿ na jndeii matseineiⁿ nda̱a̱ nnꞌaⁿ jo ndoꞌ yuu tjaa nnꞌaⁿ cꞌom. Matsoom: “Calajndaaꞌndyoꞌ naquiiꞌ nꞌomꞌyoꞌ chaꞌcwijom cwii nato na juu joꞌ nndyocwjeeꞌcañoom nquii na nntsa̱ꞌntjom ꞌo. Cataꞌndyoꞌxcweꞌyoꞌ chaꞌcwijom cwilayo̱ꞌyoꞌ nato na nñoom.” ");
INSERT INTO amuNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ñꞌoommeiⁿꞌ seicanda̱a̱ꞌñenaꞌ quia na to̱ꞌ Juan na tyotseitsꞌoomñê nnꞌaⁿ ndyuaa yuu tjaa nnꞌaⁿ cꞌom. Tyoñequiaaⁿ ñꞌoom na calcweꞌ nꞌomna jnaaⁿna cha nntseitꞌmaⁿ tsꞌom Tyꞌo̱o̱tsꞌom joona ndoꞌ nleitsꞌoomndyena. ");
INSERT INTO amuNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Jndye nnꞌaⁿ tyꞌe na mꞌaaⁿ na jnaⁿna chaꞌwaa tsꞌo̱ndaa Judea ñequio tsjoom Jerusalén. Jnda̱ na lcweꞌ nꞌomna jnaaⁿna, seitsꞌoomñê joona tsꞌom jndaa Jordán. ");
INSERT INTO amuNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juanꞌñeeⁿ tyocweⁿ liaa na tuiinaꞌ ñꞌeⁿ sooꞌ camello. Chiꞌtyeⁿ xcweeⁿꞌeⁿ cwii tjaⁿ. Tyocwaaⁿꞌaⁿ calcaa ntyueꞌ ndoꞌ tyoꞌom tsiomꞌ jnda̱a̱. ");
INSERT INTO amuNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Luaa ñꞌoom na tyoñequiaaⁿ nda̱a̱ nnꞌaⁿ, tyotsoom: —Mandyontyjo̱ nqueⁿ na tꞌmaⁿti tseixmaaⁿ, nchiiti ja. Ticatseixmaⁿya na cweꞌ ja nndiꞌntjo̱ⁿya nnoom na nntseicanaⁿꞌa lcoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ja matseitsꞌoomndyo̱ ꞌo ñequio ndaatioo, sa̱a̱ nqueⁿ nntseitsꞌoomñê ꞌo ñequio Espíritu Santo. ");
INSERT INTO amuNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Tiempoꞌñeeⁿ jnaⁿ Jesús tsjoom Nazaret, tsꞌo̱ndaa Galilea. Tyjeꞌcañoom Juan ndyuaa yuu na tjaa nnꞌaⁿ cꞌom. Ndoꞌ seitsꞌoomñe Juan jom tsꞌom jndaa Jordán. ");
INSERT INTO amuNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Quia na jlueeⁿꞌeⁿ naquiiꞌ ndaa mantyjacheⁿ ntyꞌiaaⁿꞌaⁿ na seicanaaⁿñenaꞌ tsjo̱ꞌluee. Jndyocue Espíritu Santo chaꞌcwijom catuꞌ. Jndyocaljo nacjoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ndoꞌ teicꞌuaa na seineiⁿ Tyꞌo̱o̱tsꞌom cañoomꞌluee. Matso: —ꞌU cwiluiindyuꞌ Jndaaya na jeeⁿ candyaꞌ tsꞌo̱o̱ⁿya. Cantyja ꞌnaⁿꞌ ꞌu ñequiiꞌcheⁿ mañequiaanaꞌ na neiⁿya. ");
INSERT INTO amuNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ndoꞌ mantyjacheⁿ tjañꞌoom Espíritu Santo Jesús cwiicheⁿ ntyja yuu tjaa nnꞌaⁿ cꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Joꞌ ljooꞌñê wenꞌaaⁿ xuee. Tyoqueⁿñe tsaⁿjndii na nlqueⁿ xjeⁿ jom. Mati tyomꞌaaⁿ Jesús quiiꞌntaaⁿ quiooꞌ wjee. Ndoꞌ tquieꞌcañom ángeles na tyondyeꞌntjomna nnoom. ");
INSERT INTO amuNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Jnda̱ na tjuꞌ Herodes Juan wꞌaancjo, quia joꞌ tja Jesús tsꞌo̱ndaa Galilea. Joꞌ joꞌ tyoñequiaaⁿ ñꞌoom naya nda̱a̱ nnꞌaⁿ cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Tyotsoom: —Jnda̱ tueꞌntyjo̱ xjeⁿ na nñeꞌquiandyoꞌ na nntsa̱ꞌntjom Tyꞌo̱o̱tsꞌom ꞌo. Calayuꞌyoꞌ ñꞌoom naya ꞌnaaⁿꞌaⁿ ndoꞌ calcweꞌ nꞌomꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yocheⁿ na mawinom Jesús ꞌndyoo ndaaluee Galilea, ntyꞌiaaⁿꞌaⁿ Simón ñequio tyjee tsaⁿꞌñeeⁿ Andrés. Cwitueeꞌna tsquiꞌ ꞌnaaⁿna tsꞌom ndaaluee ee joona tsꞌiaaⁿ ꞌnaaⁿna na cwitjeiiꞌna calcaa. ");
INSERT INTO amuNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Quia joꞌ tso Jesús nda̱a̱na: —Quioꞌyoꞌ ñꞌeⁿndyo̱ ndoꞌ ja nntsꞌaa na nlatjomꞌyoꞌ nnꞌaⁿ tachii cweꞌ calcaa. ");
INSERT INTO amuNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Joona mañoomꞌ ꞌndyena lquiꞌ ꞌnaaⁿna. Tyꞌena ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Tjatjatyeeⁿ chjoowiꞌ ꞌndyoo ndaaluee. Tueeꞌcañoom Jacobo ñꞌeⁿ tyjee tsaⁿꞌñeeⁿ na jndyu Juan. Joona ntseinda Zebedeo. Mꞌaⁿna tsꞌom wꞌaandaa, cwilaꞌyo̱na lquiꞌtsaⁿ ꞌnaaⁿna. ");
INSERT INTO amuNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Mantyja tqueeⁿꞌñê joona, quia joꞌ ꞌndyena tsotyena Zebedeo tsꞌom wꞌaandaa ñequio naⁿntjoomꞌm. Tyꞌena ñequio Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Tyꞌena tquiena tsjoom Capernaum. Quia na tueꞌntyjo̱ xuee na cwitaꞌjndyee nnꞌaⁿ judíos quia joꞌ tjaquieeꞌ Jesús naquiiꞌ watsꞌom. To̱o̱ⁿꞌo̱ⁿ na tyoꞌmo̱o̱ⁿ nda̱a̱ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ndoꞌ ñꞌoom na tyoñequiaaⁿ, jeeⁿ tjaweeꞌ nꞌomna. Tꞌmo̱ⁿnaꞌ nda̱a̱na na waa najndeii na matseixmaaⁿ, ee ñꞌoom na tyoꞌmo̱o̱ⁿ cajndatinaꞌ, nchii cweꞌ chaꞌna ñꞌoom na cwitꞌmo̱o̱ⁿ nnꞌaⁿ na jndo̱ꞌ nꞌom chiuu tꞌmaⁿ ljeii na tqueⁿ Moisés. ");
INSERT INTO amuNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ndoꞌ naquiiꞌ watsꞌomꞌñeeⁿ tyjeꞌcañoom cwii tsꞌaⁿ na maleiñꞌoom jndyetia juu. Jndeii tyotseixuaa tsaⁿꞌñeeⁿ ñꞌoom ndyuee jndyetiaꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Tsoom nnom Jesús: —¿Ljoꞌ lꞌue tsꞌomꞌ ñꞌeⁿndyô̱ jâ, ꞌu Jesús na jnaⁿꞌ Nazaret? ¿Aa jndyoꞌ na jndyoꞌtseiꞌtyuiꞌ na laxmaaⁿyâ najnda̱a̱yâ? Jâ macwitajnaaⁿꞌâ ꞌñeeⁿ cwiluiindyuꞌ. Nncuꞌ cwiluiindyuꞌ na ljuꞌ tsꞌomꞌ na jnaⁿꞌ na mꞌaaⁿ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Quia joꞌ seitiaꞌ Jesús jndyetiaꞌñeeⁿ. Tsoom: —Catseicheⁿꞌ. Caluiꞌ naquiiꞌ tsꞌom tsaⁿmꞌaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ndoꞌ sꞌaa jndyetiaꞌñeeⁿ na seicantyeeⁿñe tsaⁿꞌñeeⁿ ndoꞌ tyoteiñe. Sꞌaaⁿ na seixuaa jndeii, jnda̱ joꞌ jlueeⁿꞌeⁿ naquiiꞌ tsꞌom tsaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ndoꞌ chaꞌtso nnꞌaⁿ na ntyꞌiaa na luaaꞌ tuii jeeⁿ tyuena. Tyotaꞌxꞌeena nda̱a̱ ncꞌiaana, tyoluena: —¿Ljoꞌ maꞌmo̱ⁿnaꞌ na luaaꞌ tuii? Cwa cwii ñꞌoom xco cwindya̱a̱ya jeꞌ. Ee tsaⁿmꞌaaⁿꞌ waa najneiⁿ na matsa̱ꞌntjoom meiⁿ jndyetia ndoꞌ cwilaꞌcanda̱na ñꞌoom na matsoom. ");
INSERT INTO amuNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Mañoomꞌ tꞌom ñꞌoom cantyja ꞌnaaⁿꞌ Jesús chaꞌwaa tsꞌo̱ndaa Galilea. ");
INSERT INTO amuNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ndoꞌ jnda̱ na jluiꞌna watsꞌom, tyꞌena waaꞌ Simón ñꞌeⁿ Andrés, ndi ñꞌeⁿ Jacobo ñꞌeⁿ Juan. ");
INSERT INTO amuNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tquiena. Ndoꞌ joꞌ joꞌ mꞌaaⁿ sta̱xeeⁿꞌ Simón. Waa cjooꞌ jnduu na matseiconaꞌ juu. Mañoomꞌ jlaꞌcandii nnꞌaⁿ Jesús na wiiꞌ yuscuꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Quia joꞌ tjantyjaaꞌ Jesús tsaⁿꞌñeeⁿ, tꞌueeⁿ tsꞌo̱, seiweeⁿ juu. Mañoomꞌ ntquiuuñe na matseiconaꞌ juu. Mana to̱ꞌ na mandintjom nda̱a̱na. ");
INSERT INTO amuNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Majuu tmaaⁿꞌñeeⁿ jnda̱ na tjacue ñeꞌquioomꞌ, tquieꞌcho nnꞌaⁿ nnꞌaⁿwii ñꞌeⁿ nnꞌaⁿ na maleichuu jndyetia na mꞌaaⁿ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Manndyo ndyuendye nnꞌaⁿ tsjoomꞌñeeⁿ na tquiena na cweꞌ ꞌndyootsꞌa wꞌaaꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Xjeⁿꞌñeeⁿ seinꞌmaaⁿ jndye nnꞌaⁿwii chaꞌtso nnom ntycu na cwitjoomna. Mati jndye jndyetia tjeiiⁿꞌeⁿ naquiiꞌ nꞌom nnꞌaⁿ. Meiⁿ tînquiaaⁿ na nlaꞌneiⁿ jndyetiaꞌñeeⁿ meiⁿcwii ñꞌoom ee ticalꞌue tsꞌoom na nndye nnꞌaⁿ cantyja ꞌnaaⁿꞌaⁿ. Ee jndyetiaꞌñeeⁿ manquiuna ꞌñeeⁿ cwiluiiñê. ");
INSERT INTO amuNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Teincoo cwiicheⁿ xuee ndicwaⁿ jaaⁿcheⁿ teicantyjaaⁿ, tjaaⁿ cwii joo yuu na ñenqueⁿ. Joꞌ joꞌ tyotseineiiⁿ nnom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ndoꞌ Simón ñequio ncꞌiaaⁿꞌaⁿ tyꞌentyjo̱na naxeⁿꞌ Jesús na cwilꞌueena jom. ");
INSERT INTO amuNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Jnda̱ na jliuna jom, jluena nnoom: —Jndye nnꞌaⁿ jeeⁿ cwilꞌuee ꞌu. ");
INSERT INTO amuNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Tsoom nda̱a̱na: —Cjaaya ntꞌomcheⁿ njoom na nndyooꞌ cha mati joꞌ nñequiaya ñꞌoom naya na nndye nnꞌaⁿ. Ee maxjeⁿ tsꞌiaaⁿwaaꞌ na qui na jndyo̱o̱ya. ");
INSERT INTO amuNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Quia joꞌ tyomanoom chaꞌwaa tsꞌo̱ndaa Galilea. Tyoñequiaaⁿ ñꞌoom naya naquiiꞌ lanꞌom ꞌnaaⁿ naⁿꞌñeeⁿ cwii cwii joo. Ndoꞌ tyocwjeeⁿꞌeⁿ jndyetia naquiiꞌ nꞌom nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Tyjeeꞌcañoom cwii tsꞌaⁿ na mꞌaaⁿ Jesús na chuu tycu lepra. Tcoꞌxtye jo nnoom, sꞌaa tyꞌoo, tso: —Ta, ntyjii ꞌu nnda̱a̱ nntseinꞌmaⁿꞌ ja, xeⁿ wajnaⁿꞌ na matyꞌiomnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús tꞌoom na wiꞌ tsꞌoom tsaⁿꞌñeeⁿ. Seilioom tsꞌo̱o̱ⁿ, tyeⁿnquioomꞌm juu. Tsoom nnom: —Maxjeⁿ matyꞌiomnaꞌ na ljoꞌ. Canꞌmaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Mantyja tsu tycu lepra. Mana ljuuꞌ tjaaⁿꞌaⁿ chaꞌwaañê. ");
INSERT INTO amuNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jnda̱ joꞌ jñom Jesús tsaⁿꞌñeeⁿ, tyeⁿ ñꞌoom tsoom nnom: ");
INSERT INTO amuNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Meiⁿcwii ñꞌoom ticatsuꞌ nda̱a̱ nnꞌaⁿ chiuu tuii na nꞌmaⁿꞌ. Sa̱a̱ cjaꞌ, cjaꞌtseicaꞌmo̱ⁿndyuꞌ nnom tyee. Ndoꞌ quiaaꞌ quiooꞌ nnoom na matseitꞌmaaⁿꞌndyuꞌ Tyꞌo̱o̱tsꞌom chaꞌxjeⁿ na tyotsa̱ꞌntjom Moisés. Ee laaꞌtiꞌ nncwjiꞌyuuꞌñenaꞌ nda̱a̱ nnꞌaⁿ na jnda̱ nꞌmaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Sa̱a̱ quia na tja tsaⁿꞌñeeⁿ, to̱o̱ⁿꞌo̱ⁿ na tyotseineiiⁿ, tyotsoñꞌeeⁿ chiuu waa na nꞌmaaⁿ. Joꞌ chii mañoomꞌ tꞌom ñꞌoom ndiocheⁿ. Cweꞌ joꞌ seicuꞌnaꞌ na nncjaaquieeꞌ Jesús meiⁿnquia tsjoom ee jeeⁿ jndye nnꞌaⁿ nncꞌoontyjaaꞌna xeⁿ nliuna jom. Joꞌ chii ljooꞌñê yuu tjaa nnꞌaⁿ cꞌoom ndoꞌ tquieꞌcañom nnꞌaⁿ na mꞌaaⁿ na jndye joo jnaⁿna. ");
INSERT INTO amuNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Jnda̱ na teinom cwantindyo xuee, tueꞌcañoomnndaꞌ Jesús tsjoom Capernaum. Ndoꞌ teicꞌuaa ñꞌoom na jnda̱ tyjeeⁿꞌeⁿ, mꞌaaⁿ waaꞌ cwii tsꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Jndye nnꞌaⁿ tjomndyena joꞌ joꞌ hasta tileicwiijndeii wꞌaa. Meiⁿ cweꞌ ꞌndyootsꞌa tîcanda̱a̱ nlquieꞌcañomna. Ndoꞌ tyoñequiaaⁿ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom nda̱a̱na. ");
INSERT INTO amuNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ndoꞌ joꞌ tquieꞌcañom ñequiee nnꞌaⁿ na mꞌaaⁿ Jesús. Tquioñꞌomna cwii tsꞌaⁿ na ntjeiⁿ ncꞌee. ");
INSERT INTO amuNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Quia na ntyꞌiaana na tîcanda̱a̱ nncꞌoontyjaaꞌna na mꞌaaⁿ ee na jeeⁿ tyeeⁿ mꞌaⁿ nnꞌaⁿ, quia joꞌ tyꞌewana xqueⁿ wꞌaa. Jlaꞌcanaaⁿndyena ndyeyu na meintyjeeꞌ Jesús. Jlaꞌcꞌo̱ⁿna tsuee na ndiiꞌ tsꞌaⁿwiiꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Quia na ntyꞌiaaꞌ Jesús na cwilaꞌyuꞌya nꞌom naⁿꞌñeeⁿ, tsoom nnom nquii tsꞌaⁿ na wiiꞌ: —ꞌU jndaaya, jnda̱ seitꞌmaⁿ tsꞌo̱o̱ⁿya ꞌu chaꞌtso jnaⁿꞌ na niom. ");
INSERT INTO amuNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ndoꞌ ntꞌom nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés na teindyuaandye joꞌ joꞌ, jndye ñꞌoom tyolaꞌtiuuna naquiiꞌ nꞌomna na ticueeꞌ nꞌomna Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","Jlaꞌneiⁿ cheⁿnquieena naquiiꞌ nꞌomna, jluena: “Tsaⁿmꞌaaⁿꞌ ¿chiuu na luaaꞌ matsoom? Cwa ñꞌoom ntjeiⁿ matseineiiⁿ nacjooꞌ Tyꞌo̱o̱tsꞌom ee macanda̱ jom nnda̱a̱ nntseitꞌmaⁿ tsꞌoom jnaaⁿ nnꞌaⁿ.” ");
INSERT INTO amuNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ndoꞌ ntyjii Jesús na luaaꞌ mꞌaaⁿꞌ nꞌomna. Tsoom nda̱a̱na: —¿Chiuu na ticuaaya nquiuꞌyoꞌ ñꞌeⁿndyo̱? ");
INSERT INTO amuNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Cwaaⁿ ñꞌoom cwilaꞌtiuuꞌyoꞌ na tijndeiꞌtinaꞌ na nntsjo̱o̱ nnom tsaⁿwiiꞌmꞌaaⁿ? ¿Aa nchii chaꞌna jnda̱ tsjo̱o̱ nnoom na matseitꞌmaⁿ tsꞌo̱o̱ⁿya jnaaⁿꞌaⁿ na waa? Oo ¿aa nchii jndeiꞌtinaꞌ nquiuꞌyoꞌ na nntsjo̱o̱ na quicantyjaaⁿ, catseilcwiiñê tsuee ꞌnaaⁿꞌaⁿ ndoꞌ cjaacaⁿ? ");
INSERT INTO amuNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Queⁿꞌyoꞌ cwenta, ja na cwiluiindyo̱ tsaⁿ na jnaⁿ cañoomꞌluee nntsjo̱o̱ juu ñꞌoom na nquiuꞌ ꞌo na jndeiꞌtinaꞌ. Quia joꞌ quia na jnda̱ tcoꞌyanaꞌ tsaⁿmꞌaaⁿ nlaꞌno̱ⁿꞌyoꞌ na majndeiiticheⁿ ja waa najndo̱ nnom tsjoomnancue na nnda̱a̱ nntseitꞌmaⁿ tsꞌo̱o̱ⁿya jnaaⁿ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Quia joꞌ tsoom nnom tsꞌaⁿ na ntjeiⁿ ncꞌee: —ꞌU re, matsjo̱o̱ya njomꞌ, quicantyjaꞌ. Catseilcwiindyuꞌ tsuee ꞌnaⁿꞌ. Cjaꞌtoꞌ waꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ndoꞌ mantyja teicantyja tsaⁿꞌñeeⁿ, seilcwiiñê tsuee ꞌnaaⁿꞌaⁿ. Jlueeⁿꞌeⁿ na jndooꞌ chaꞌtsondye naⁿꞌñeeⁿ. Jeeⁿ tjaweeꞌ nꞌomna na luaaꞌ tuii. Tyolaꞌtꞌmaaⁿꞌndyena Tyꞌo̱o̱tsꞌom, tyoluena: —Meiⁿjom ndiiꞌ tyoontyꞌiaaya na nluii na luaaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jnda̱ tuii na luaaꞌ, tja Jesús cwiicheⁿ cwii ndiiꞌ ꞌndyoo ndaaluee ndoꞌ jndye nnꞌaⁿ tyꞌentyjaaꞌna jom. Tyoꞌmo̱o̱ⁿ nda̱a̱na. ");
INSERT INTO amuNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Cwii xuee mawinoom yuu na cwitioom nnꞌaⁿ tsꞌiaaⁿnda̱a̱na cwentaaꞌ gobiernom. Joꞌ joꞌ noomꞌm cwii tsꞌaⁿ na jndyu Leví jnda Alfeo. Wacatyeeⁿ tsaⁿꞌñeeⁿ na macoꞌñoom sꞌom na cwitioom nnꞌaⁿ. Tso Jesús nnoom: —Candyoꞌtseijomndyuꞌ ñequio tsꞌiaaⁿ ꞌnaⁿya. Ndoꞌ teicantyja tsaⁿꞌñeeⁿ, tjatseijomñe ñꞌeⁿ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Cwii xuee mꞌaaⁿ Jesús waaꞌ Leví ñequio nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê. Joꞌ joꞌ wacatyeeⁿ nacañoomꞌ meiⁿsa ñequio naⁿꞌñeeⁿ na cwicwaꞌna. Ndoꞌ mati majndye nnꞌaⁿ na cwitoꞌnoom tsꞌiaaⁿnda̱a̱ nnꞌaⁿ cwentaaꞌ gobiernom ñequio nnꞌaⁿ na cwilaꞌtjo̱o̱ndye nnom Tyꞌo̱o̱tsꞌom cantyja na nquiu nnꞌaⁿ fariseos, teindyuaandyena ñꞌeⁿñê. Ee jndye nnꞌaⁿ tyꞌentyjo̱na naxeeⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Sa̱a̱ nnꞌaⁿ fariseos ñequio ncꞌiaana na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés, quia na ntyꞌiaana na macwaꞌ Jesús ñequio nnꞌaⁿ na cwilaꞌtjo̱o̱ndye nnom Tyꞌo̱o̱tsꞌom ndoꞌ ñequio nnꞌaⁿ na cwitoꞌñoom sꞌom cwentaaꞌ gobiernom, taꞌxꞌeena nda̱a̱ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê, jluena: —¿Chiuu waayuu na macwaaⁿꞌaⁿ ñꞌeⁿ nnꞌaⁿ na cwitoꞌñoom sꞌom ndoꞌ ñꞌeⁿ nnꞌaⁿ na cwilaꞌtjo̱o̱ndye nnom Tyꞌo̱o̱tsꞌom? ");
INSERT INTO amuNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jnda̱ na jndii Jesús na luaaꞌ cwiluena, tsoom nda̱a̱na: —Nnꞌaⁿ na tiwii titjo̱o̱ndyena tsꞌaⁿ na machꞌee nasei. Sa̱a̱ nnꞌaⁿ na wii, tjo̱o̱ndyena tsaⁿꞌñeeⁿ. Ja nchii na jndyo̱o̱ na nncwaⁿya nnꞌaⁿ na mꞌaⁿ cantyja na matyꞌiomyanaꞌ, ja jndyo̱o̱ na nncwaⁿya nnꞌaⁿjnaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nnꞌaⁿ na cwilaꞌjomndye ñꞌoom na tyoñequiaa Juan tsaⁿ na tyotseitsꞌoomñe nnꞌaⁿ ñequio nnꞌaⁿ na cwilaꞌjomndye ñꞌoom na cwilaꞌnaaⁿ nnꞌaⁿ fariseos, mꞌaⁿna na cwilaꞌcwejndoꞌndyena cwii xuee. Ndoꞌ ntꞌomndye joona tyꞌentyjaaꞌna Jesús, taꞌxꞌeena nnoom, jluena: —Nnꞌaⁿ na cwilaꞌjomndye ñꞌoom na mañequiaa Juan cwilaꞌcwejndoꞌndyena ndoꞌ majoꞌti cwilꞌa nnꞌaⁿ fariseos, sa̱a̱ nnꞌaⁿ na cwilaꞌjomndye ñꞌoom na mañequiaaꞌ, tyoolaꞌcwejndoꞌndyena. ¿Chiuu na tyoolꞌana? ");
INSERT INTO amuNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Tꞌo̱ Jesús cwii ñꞌoom na cweꞌ tjañoomꞌ cantyja ꞌnaaⁿꞌ nqueⁿ. Tsoom nda̱a̱ naⁿꞌñeeⁿ: —Nnꞌaⁿ na cwilaꞌjomndye na macoco tsꞌaⁿ ¿aa matyꞌiomnaꞌ na nlaꞌcwejndoꞌndyena yocheⁿ na ndii ñꞌeⁿ tsaⁿsꞌaꞌñeeⁿ ñꞌeⁿndyena? Cantyjati xuee na mꞌaaⁿ ñꞌeⁿndye naⁿꞌñeeⁿ na cwiwitꞌmaaⁿꞌ na tocoom, ticatsonaꞌ na nlaꞌcwejndoꞌndyena. ");
INSERT INTO amuNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Sa̱a̱ manncueꞌntyjo̱ xuee na nncwjiꞌnaꞌ jom quiiꞌntaaⁿna, quia ljoꞌcheⁿ nlaꞌcwejndoꞌndyena. ");
INSERT INTO amuNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Seineiⁿticheⁿ Jesús cwii ñꞌoom na tjañoomꞌ cantyja ꞌnaaⁿꞌ ñꞌoom xco na maꞌmo̱o̱ⁿ nda̱a̱na. Tsoom: —Tsꞌaⁿ na matseiyo̱ liaa, ticatyꞌiomnaꞌ na nncwjaaꞌñê cwii taⁿꞌ liaa xco na tyootmaⁿ na nntseiyo̱o̱ⁿ liaa ntsaa. Ee na ljoꞌ nntsꞌaaⁿ, quia nntmaⁿ liaa tquie quia joꞌ nncjaateii liaa xco, nntyjaañenaꞌ liaa ntsaa, ndoꞌ cwajndiiti nncꞌiooꞌñenaꞌ liaa ntsaaꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Mati tsꞌaⁿ na machꞌee winom tijoom nntioom juunaꞌ tjaⁿ na jnda̱ teijndyo. Ee xeⁿ na ljoꞌ nntsꞌaa tsꞌaⁿ nntꞌiooꞌ tjaⁿꞌñeeⁿ, mana cwiwiꞌndaaꞌnaꞌ, ndoꞌ mati nlcweꞌ winom. Joꞌ chii matyꞌiomnaꞌ na tsꞌom tjaⁿ xco nncꞌoocuenaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Cwii xuee na cwitaꞌjndyee nnꞌaⁿ judíos, mawinom Jesús yuu na niom ntjom lqueeⁿ trigo. Ndoꞌ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê, yocheⁿ na cwiwinomna joꞌ joꞌ, to̱ꞌna na cwitꞌiooꞌndyena meiⁿ ndyee xuꞌlqueeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ntꞌom nnꞌaⁿ fariseos jluena nnom Jesús: —Queⁿꞌ cwenta naⁿmꞌaⁿꞌ, ¿chiuu na cwilꞌana cwii na ticatsa̱ꞌntjomnaꞌ xuee na cwitaꞌjndya̱a̱ya? ");
INSERT INTO amuNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Tꞌo̱ Jesús, tsoom nda̱a̱na: —ꞌO, ¿aa nchii jnda̱ jlaꞌnaⁿꞌyoꞌ ñꞌoom chiuu sꞌaa David quia na seitjo̱o̱naꞌ na nlcwaaⁿꞌaⁿ? Sa̱a̱ tyoolancjooꞌndyoꞌ cantyja ꞌnaaⁿꞌaⁿ. Jom tꞌoom na ñejnoomꞌm ndoꞌ mati nnꞌaⁿ na ñꞌeeⁿ ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Tjaqueⁿꞌeⁿ naquiiꞌ watsꞌom ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom ndoꞌ tcaaⁿ tyooꞌ nnom Abiatar tyee na cwiluiitquieñe. Jnaaⁿꞌaⁿ ntyooꞌñeeⁿ. Tcwaaⁿꞌaⁿ joonaꞌ ndoꞌ mati tquiaaⁿ na tcwaꞌ nnꞌaⁿ na ñꞌeeⁿ ñꞌeⁿñê. Ndoꞌ ntyooꞌñeeⁿ na jnda̱ tquia nnꞌaⁿ nnom Tyꞌo̱o̱tsꞌom, ticwanaaⁿ na nlcwaꞌ meiⁿnquia tsꞌaⁿ, macanda̱ ntyee wanaaⁿ na nlcwaꞌna juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Tsoticheⁿ Jesús nda̱a̱na: —Tqueⁿ Tyꞌo̱o̱tsꞌom xuee na nntaꞌjndyee nnꞌaⁿ cha na nnteijndeiinaꞌ joona, nchii seijndaaꞌñê na nntsꞌaanaꞌ xjeⁿ ꞌo na nnduꞌyoꞌ na jeeⁿ tꞌmaⁿ xuee tseixmaⁿnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Joꞌ chii ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee waa na matseixmaⁿya na nntsjo̱o̱ ljoꞌ wanaaⁿ na calꞌa nnꞌaⁿ xuee na cwitaꞌjndya̱a̱ya. ");
INSERT INTO amuNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Cwiicheⁿ cwii ndiiꞌ tjaquieeꞌ Jesús naquiiꞌ watsꞌom. Joꞌ joꞌ mꞌaaⁿ cwii tsaⁿsꞌa na jnda̱ tjateii cwii tsꞌo̱. ");
INSERT INTO amuNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Jeeⁿ tyoqueⁿ nnꞌaⁿ fariseos cwenta ljoꞌ nntsꞌaaⁿ, aa nntseinꞌmaaⁿ tsaⁿꞌñeeⁿ juu xuee na cwitaꞌjndyeena, ee jeeⁿ queeⁿ nꞌomna na nnda̱a̱ nlqueⁿna ñꞌoom nacjoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Quia joꞌ tsoom nnom tsꞌaⁿ na jnda̱ tjateii tsꞌo̱: —Quicantyjaꞌ, cwintyjeꞌ xcwe quiiꞌntaaⁿ naⁿmꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ndoꞌ tsoom nda̱a̱ nnꞌaⁿ na mꞌaⁿ joꞌ joꞌ: —Ja mawaxꞌa̱ya nda̱a̱ꞌyoꞌ, xuee na cwitaꞌjndya̱a̱ya ¿aa wanaaⁿ na cateijndeii tsꞌaⁿ xꞌiaaⁿꞌaⁿ na wiꞌ matjom, oo aa ticateijneiⁿ juu? ¿Aa cwjiꞌnꞌmaaⁿñê xꞌiaaⁿꞌaⁿ na ticueꞌ, oo aa caꞌñeeⁿ na cueꞌ? Sa̱a̱ joona yacheⁿ jlaꞌcheⁿna. ");
INSERT INTO amuNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Quia joꞌ ntyꞌiaaⁿꞌaⁿ nda̱a̱ nnꞌaⁿ ndiocheⁿ, seiliooꞌñê ñꞌeⁿndyena. Tquiaanaꞌ na chjooꞌ tsꞌoom ee seiꞌno̱o̱ⁿꞌo̱ⁿ na jeeⁿ quieꞌ nꞌomna. Tsoom nnom tsaⁿsꞌaꞌñeeⁿ: —Catseiliuuꞌ tsꞌo̱ꞌ. Seiliuu tsaⁿꞌñeeⁿ tsꞌo̱o̱ⁿ ndoꞌ mana tcoꞌyanaꞌ jom. ");
INSERT INTO amuNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Sa̱a̱ nnꞌaⁿ fariseos mantyja jluiꞌna, tyoꞌmaⁿna ñequio nnꞌaⁿ ꞌnaaⁿꞌ Herodes chiuu nlꞌayoona na nlaꞌcueeꞌna Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Quia joꞌ tjanndaꞌ Jesús ꞌndyoo ndaaluee ñequio nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê. Cwii tmaaⁿꞌ nnꞌaⁿ tyꞌentyjo̱ naxeeⁿꞌeⁿ na jnaⁿna tsꞌo̱ndaa Galilea. ");
INSERT INTO amuNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Ndoꞌ mati ntꞌomcheⁿ nnꞌaⁿ tyondyena cantyja ꞌnaaⁿ jndye nnom tsꞌiaaⁿ tꞌmaⁿ na tyochꞌeeⁿ. Quia joꞌ jndyendyena jnaⁿna tsꞌo̱ndaa Judea ñequio tsjoom Jerusalén, ñequio ndyuaa Idumea, ñequio xndyaaꞌ jndaa Jordán, ndoꞌ ñequio ndiocheⁿ tsjoom Tiro ñꞌeⁿ Sidón. Tyꞌentyjaaꞌna jom. ");
INSERT INTO amuNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Joꞌ chii sa̱ꞌntjoom nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê na calaꞌjndaaꞌndyena cwii wꞌaandaa chjoo na nleilꞌueeꞌñê cha tintsꞌaanaꞌ na ꞌoontquieena jom ee tyeeⁿ na jeeⁿ jndye nnꞌaⁿ mꞌaⁿ nacañomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ee ncꞌe na jnda̱ seinꞌmaaⁿ jndyendye nnꞌaⁿ, joꞌ chii chaꞌtso ntꞌomcheⁿ nnꞌaⁿ na ndicwaⁿ chona ntycu, tyolaꞌcantoꞌndyena nacañomꞌm na ñeꞌnquioꞌna jom cha nnꞌmaaⁿna. ");
INSERT INTO amuNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ndoꞌ jndyetia na mꞌaⁿ naquiiꞌ nꞌom nnꞌaⁿ, meiⁿyuucheⁿ na ntyꞌiaana jom, lꞌana naquiiꞌ nꞌom naⁿꞌñeeⁿ na cataꞌna cantyena jo nnoom. Tyolaꞌxuaana, tyoluena: —ꞌU cwiluiindyuꞌ Jnda Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Sa̱a̱ Jesús jndeiꞌnaꞌ tyotsa̱ꞌntjoom na ticatꞌmo̱o̱ⁿna ꞌñeeⁿ cwiluiiñê. ");
INSERT INTO amuNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tjawa Jesús cwii ta, ndoꞌ tqueeⁿꞌñê nnꞌaⁿ na macwjiiꞌñê cwentaaⁿꞌaⁿ na cꞌoona na mꞌaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Tqueeⁿ canchooꞌwendyena na nñꞌeeⁿna ñꞌeⁿñê ndoꞌ na njñoom joona na nñeꞌquiana ñꞌoom naya ꞌnaaⁿꞌaⁿ nda̱a̱ nnꞌaⁿ. Matseicajndyunaꞌ joona apóstoles. ");
INSERT INTO amuNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Tquiaaⁿ cantyja najndeii na tseixmaaⁿ na nlaꞌxmaⁿna cha nnda̱a̱ nlaꞌnꞌmaaⁿna nnꞌaⁿ ndoꞌ nnda̱a̱ nntjeiiꞌna jndyetia naquiiꞌ nꞌom nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nmeiiⁿ ncuee nchooꞌwe nnꞌaⁿ na tjeiiꞌñe Jesús cwentaaⁿꞌaⁿ: Simón, tsaⁿ na seicajñoom Pedro, ");
INSERT INTO amuNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo ñequio tyjeeⁿ Juan, ntseinda Zebedeo, joona seicajñoom Boanerges, ñꞌoomwaaꞌ maꞌmo̱ⁿnaꞌ na jeeⁿ chona ndyueena, ");
INSERT INTO amuNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés, Felipe, Bartolomé, Mateo, Tomás, Jacobo jnda Alfeo, Tadeo, Simón, tsaⁿ na matiiꞌñe ñꞌoom ñꞌeⁿ tmaaⁿꞌ nnꞌaⁿ cananista. ");
INSERT INTO amuNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ndoꞌ ñꞌeⁿ Judas Iscariote, tsꞌaⁿ na tquiaa cwenta Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jnda̱ joꞌ tja Jesús yuu na macꞌeeⁿ, ndi ñꞌeeⁿ naⁿꞌñeeⁿ. Ndoꞌ tjomndyenndaꞌ cwii tmaaⁿꞌ nnꞌaⁿ yuu na mꞌaaⁿ hasta tileinquiaanaꞌ na nlcwaaⁿꞌaⁿ ñꞌeⁿ nnꞌaⁿ na ñꞌeeⁿ ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jnda̱ na jndye nnꞌaaⁿꞌ nqueⁿ na luaaꞌ matjoom, tyꞌecꞌomna jom na jndeiꞌnaꞌ ee cwilue nnꞌaⁿ na jnda̱ seintjeiⁿnaꞌ jom. ");
INSERT INTO amuNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ntꞌom nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés na jnaⁿ Jerusalén, tyoluena: —Tsaⁿmꞌaaⁿꞌ matseixmaaⁿ Beelzebú, juu tsaⁿjndiitquiee. Ncꞌe najndeii na matseixmaⁿ, joꞌ na macwjeeⁿꞌeⁿ jndyetia naquiiꞌ nꞌom nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Tqueeⁿꞌñe Jesús naⁿꞌñeeⁿ ndoꞌ seineiiⁿ ñꞌoom tjañoomꞌ nda̱a̱na. Tsoom: —¿Chiuu nntsꞌaayuunaꞌ na nquii Satanás mawjaⁿ nacjooꞌ nqueⁿ na macwjeeⁿꞌeⁿ jndyetia ñequio ntyjenaⁿjndiiñê naquiiꞌ nꞌom nnꞌaⁿ? ");
INSERT INTO amuNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Xeⁿ mꞌaaⁿ cwii gobiernom na cwito̱ⁿꞌndye nnꞌaⁿ ꞌnaaⁿꞌaⁿ, ntꞌom cwiꞌoo nacjoomꞌm ndoꞌ ntꞌom cwilaꞌjomndye ñꞌeⁿñê, tsaⁿꞌñeeⁿ xocaljooꞌñetyeeⁿ tsꞌiaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ndoꞌ mati nnꞌaⁿ na mꞌaⁿ cwii wꞌaa xeⁿ cwilaꞌntjaꞌndyena, xocꞌomna na ñeꞌnaaⁿꞌ, maxjeⁿ nntꞌoomꞌndyena. ");
INSERT INTO amuNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ndoꞌ majoꞌti cantyja ꞌnaaⁿꞌ Satanás, xeⁿ na matseiweñê nacjooꞌ ntyjenaⁿjndiiñê quia joꞌ xocaljotyeⁿ cantyja najneiⁿ na matsa̱ꞌntjoom joona. Ee xeⁿ na luaaꞌ machꞌeeⁿ, quia joꞌ matseintycwiiñe cheⁿnqueⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","’Tjaaꞌnaⁿ tsꞌaⁿ na nnda̱a̱ na cweꞌ nncjaaquieeꞌto waaꞌ tsꞌaⁿ na jeeⁿ jndeii na nncwjiꞌ ꞌnaaⁿꞌ tsaⁿꞌñeeⁿ. Sa̱a̱ xeⁿ nntseityeⁿjñeeⁿ tsaⁿꞌñeeⁿ quia ljoꞌcheⁿ nnda̱a̱ nncwjiꞌñꞌeeⁿ ꞌnaaⁿꞌ. Maluaaꞌ matseijomnaꞌ ñꞌeⁿndyo̱ ja quia macwjiiꞌa naⁿjndii ñꞌeⁿ jndyetia naquiiꞌ nꞌom nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","’Mayuuꞌcheⁿ candyeꞌyoꞌ nntsjo̱o̱, nnda̱a̱ nntseitꞌmaⁿ tsꞌom Tyꞌo̱o̱tsꞌom chaꞌtso nnom na cwilaꞌtjo̱o̱ndye nnꞌaⁿ ñequio meiⁿnquia ñꞌoom wiꞌ na ntjeiⁿnaꞌ na cwiluena. ");
INSERT INTO amuNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Sa̱a̱ meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na matsoyuu na cwiluii tsꞌiaaⁿ ꞌnaⁿya cweꞌ cantyja najndeii tsaⁿjndii, tsaⁿꞌñeeⁿ matseineiiⁿ ñꞌoom ntjeiⁿ nacjooꞌ Espíritu Santo. Ndoꞌ na ljoꞌ tijoom nntseitꞌmaⁿ tsꞌom Tyꞌo̱o̱tsꞌom tsaⁿꞌñeeⁿ. Jnaⁿwaaꞌ tijoom cantycwiinaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Luaaꞌ tsoom nda̱a̱ naⁿꞌñeeⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés. Ee joona tyoluena na jom tseixmaaⁿ tsaⁿjndiitquiee. ");
INSERT INTO amuNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tquiecañom ntyjee Jesús ñequio tsoñeeⁿ yuu na mꞌaaⁿ sa̱a̱ chꞌeⁿ ljooꞌndyena ncꞌe na jeeⁿ tyeeⁿ mꞌaⁿ nnꞌaⁿ. Cweꞌ jlaꞌcwanomna ñꞌoom na calueeⁿꞌeⁿ chꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Joꞌ chii nnꞌaⁿ na meindyuaandye nacañomꞌm jluena nnoom: —Aa ndiꞌ, jnda̱ tyjeeꞌ tsoꞌndyoꞌ ñꞌeⁿ ndyentyꞌiuꞌ. Mꞌaⁿna chꞌeⁿ, cwilꞌueena ꞌu. ");
INSERT INTO amuNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Sa̱a̱ tꞌo̱o̱ⁿ nda̱a̱na tsoom: —Nndyeꞌyoꞌ nntsjo̱o̱ nda̱a̱ꞌyoꞌ ꞌñeeⁿ cwiluiiñe tsondyo̱ ndoꞌ ndyentyjo̱. ");
INSERT INTO amuNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Jnda̱ chii ntyꞌiaaⁿꞌaⁿ ndiocheⁿ nda̱a̱ nnꞌaⁿ na meindyuaandye nacañomꞌm, tsoom nda̱a̱na: —Queⁿꞌyoꞌ cwenta, ncjoꞌyoꞌ cwiluiindyoꞌ tsondyo̱ ñequio ndyentyjo̱. ");
INSERT INTO amuNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ee meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na machꞌee yuu na lꞌue tsꞌom Tyꞌo̱o̱tsꞌom, tsaⁿꞌñeeⁿ cwiluiiñe tiꞌtyjo̱, ndoꞌ nomtyjo̱, ndoꞌ tsondyo̱. ");
INSERT INTO amuNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Cwiicheⁿ cwii ndiiꞌ tquieꞌcañom cwii tmaaⁿꞌ nnꞌaⁿ na jndyendye na mꞌaaⁿ Jesús ꞌndyoo ndaaluee. To̱o̱ⁿꞌo̱ⁿ na maꞌmo̱o̱ⁿ nda̱a̱na. Ndoꞌ jeeⁿ ndyaꞌ tyolaꞌcantoꞌndyena nacañomꞌm. Joꞌ chii tjacuo̱o̱ⁿ tsꞌom wꞌaandaa chjoo na meintyjeꞌcheⁿnaꞌ tsꞌom ndaaluee. Tjacjom tsꞌomnaꞌ ndoꞌ chaꞌtsondye nnꞌaⁿ ljooꞌndyena ꞌndyoowiꞌ ndaaluee tyuaatcwii. ");
INSERT INTO amuNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jndye ñꞌoom tjañoomꞌ teilꞌueeꞌñê na tyoꞌmo̱o̱ⁿ nda̱a̱ nnꞌaⁿ. Tueꞌcañoomnaꞌ na tsoom ñꞌoomwaa: ");
INSERT INTO amuNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Candyeꞌyoꞌ ñꞌoomwaa: Tyomꞌaaⁿ cwii tsꞌaⁿ, tjacjoomꞌm lqueeⁿ trigo. ");
INSERT INTO amuNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ndoꞌ yocheⁿ na majoomꞌm lqueeⁿꞌñee, ntꞌom tquiaa tsꞌom nato. Ndoꞌ tquie cantsaa, tcwaꞌyoꞌ joonaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ntꞌom lqueeⁿ tquiaanaꞌ tyuaa na jeeⁿ ljo̱ꞌ yuu na tita mꞌaaⁿ tsꞌo. Lqueeⁿꞌñeeⁿ tyuaaꞌ tꞌoomnaꞌ ee tita tionaꞌ tsꞌo. ");
INSERT INTO amuNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Sa̱a̱ na jeeⁿ jmeiⁿꞌ tyontyꞌiaaꞌ ñeꞌquioomꞌ, tꞌuaanaꞌ. Tjacaaⁿnaꞌ ee na tinjoom tyꞌe nchꞌiooꞌnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ntꞌom lqueeⁿ tquiaanaꞌ yuu na meintyjeeꞌ ndaꞌ lꞌo̱o̱ nioom. Tyuaaꞌti tjawindye lꞌo̱o̱ nioomꞌñeeⁿ, tco̱ꞌnaꞌ ntjom, ncꞌe naljoꞌ tjaaꞌnaⁿ ljoꞌ tueꞌ lꞌa lqueeⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Sa̱a̱ ntꞌom lqueeⁿ tquiaanaꞌ yuu na ya tsꞌo. Tꞌoomnaꞌ, tyꞌewijnda̱naꞌ, jndye lqueeⁿ tueꞌ. Ntꞌom tjeiꞌnaꞌ cwii xuu waljooꞌ yom tsꞌoom lqueeⁿ trigo na cwii tsꞌoom lqueeⁿ tjacjuꞌ tsaⁿꞌñeeⁿ. Ndoꞌ ntꞌom tjeiꞌnaꞌ we xuu waljooꞌ xcwe na cwii tsꞌoom lqueeⁿ tjacjoomꞌm. Ndoꞌ ntꞌom tjeiꞌnaꞌ ñequiee xuu na cwii tsꞌoom lqueeⁿ na tjacjoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Quia joꞌ tso Jesús nda̱a̱na: —ꞌÑeeⁿ juu na niom lueꞌ nꞌom luaꞌqui na nndii, candii. ");
INSERT INTO amuNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jnda̱ na tjuꞌnaꞌ na ñenquii Jesús ñequio nnꞌaⁿ canchooꞌwendye ndoꞌ ñequio ntꞌom nnꞌaⁿ na mati cwicañꞌeeⁿtyeⁿ ñꞌeⁿñê, taꞌxꞌeena ljoꞌ ñeꞌcaꞌmo̱ⁿ ñꞌoom tjañoomꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ndoꞌ tsoom nda̱a̱na: —Mañequiaa Tyꞌo̱o̱tsꞌom na ꞌo calaꞌno̱ⁿꞌyoꞌ ñꞌoom na tyooliu nnꞌaⁿ cantyja na matsa̱ꞌntjoom. Sa̱a̱ nnꞌaⁿ na tyoolaꞌjomndye ñꞌeⁿndyo̱, ñenquiiꞌ ñꞌoom tjañoomꞌ matseina̱ⁿya nda̱a̱na. ");
INSERT INTO amuNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Joꞌ chii machꞌeenaꞌ na mayuuꞌcheⁿ meiiⁿ na jndye ndiiꞌ nndyena ñꞌoom na mañequiaya, sa̱a̱ xocalaꞌno̱ⁿꞌna. Ndoꞌ meiiⁿ na jndye ndiiꞌ nntyꞌiaana tsꞌiaaⁿ na matsꞌaa sa̱a̱ tixoqueⁿna cwenta. Ee cwilꞌayana na nmeiiⁿꞌ cha tilcweꞌ nꞌomna, tintseitꞌmaⁿ tsꞌom Tyꞌo̱o̱tsꞌom jnaaⁿna. ");
INSERT INTO amuNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Quia joꞌ tsoom nda̱a̱na: —¿Aa maxjeⁿ ticalaꞌno̱ⁿꞌyoꞌ ñꞌoom tjañoomꞌwaaꞌ? ¿Chiuu nlꞌaa na nlaꞌno̱ⁿꞌyoꞌ ntꞌomcheⁿ ñꞌoom tjañoomꞌ? ");
INSERT INTO amuNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Juu tsꞌaⁿ na tjacjuꞌ lqueeⁿ trigo, joꞌ tsꞌaⁿ na mañequiaa ñꞌoomꞌ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Lqueeⁿ na tquiaa tsꞌom nato, joꞌ nnꞌaⁿ na cwindye ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na mañequiaa tsꞌaⁿ, sa̱a̱ mantyja macwjiꞌ Satanás ñꞌoomꞌñeeⁿ naquiiꞌ nꞌomna. ");
INSERT INTO amuNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ndoꞌ lqueeⁿ na tquiaa yuu na jeeⁿ ljo̱ꞌ tyuaa, joꞌ nnꞌaⁿ na ya cwindye ñꞌoomꞌ Tyꞌo̱o̱tsꞌom. Neiiⁿna cwitoꞌñoomna juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Sa̱a̱ tiyo cwindyena ee matseijomnaꞌ joona chaꞌna jnda̱ lqueeⁿꞌñeeⁿ na tinjoom tyꞌe nchꞌiooꞌnaꞌ. Ndoꞌ quia na macoꞌwiꞌnaꞌ joona oo cwilaꞌwjee nnꞌaⁿ joona ncꞌe na cwilaꞌyuꞌna, mantyja cwiꞌndyena. ");
INSERT INTO amuNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Lqueeⁿ na tquiaa naquiiꞌ lꞌo̱o̱ nioom, joꞌ nnꞌaⁿ na ya Cwindye ñꞌoomꞌ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Sa̱a̱ naⁿꞌñeeⁿ jeeⁿ mꞌaaⁿꞌ nꞌomna chiuu cwii ꞌoomꞌaⁿtina. Maquiuꞌnnꞌaⁿnaꞌ joona na ñeꞌcwityandyena, ndoꞌ jeeⁿ cwilaꞌqueeⁿ nꞌomna na ñeꞌcaleiꞌchona chaꞌtso nnom ꞌnaⁿ. Chaꞌtso nmeiⁿꞌ matseicatsuunaꞌ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom naquiiꞌ nꞌomna. Joꞌ chii tileicanaⁿjndeiinaꞌ na nlꞌana yuu na cjaweeꞌ ntyjii Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Sa̱a̱ mꞌaⁿ nnꞌaⁿ na ya cwindye ñꞌoomꞌ Tyꞌo̱o̱tsꞌom. Cwilaꞌljona juunaꞌ naquiiꞌ nꞌomna. Cwiqueⁿndyena na cwilꞌana yuu na ya. Matseijomnaꞌ joona chaꞌna lqueeⁿ na tquiaa yuu na jeeⁿ ya tsꞌo. Ntꞌom naⁿꞌñeeⁿ matseijomnaꞌ cantyja ꞌnaaⁿna chaꞌna cwii tsꞌoom lqueeⁿꞌñeeⁿ na tjeiꞌnaꞌ cwii xuu waljooꞌ yom tsꞌoom. Ndoꞌ ntꞌomndyena matseijomnaꞌ chaꞌna cwii tsꞌoom lqueeⁿꞌñeeⁿ na tjeiꞌnaꞌ we xuu waljooꞌ xcwe. Ndoꞌ ntꞌomndye naⁿꞌñeeⁿ matseijomnaꞌ joona chaꞌna cwii tsꞌoom lqueeⁿꞌñeeⁿ na tjeiꞌnaꞌ ñequiee xuu. ");
INSERT INTO amuNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jnda̱ joꞌ seineiⁿtyeeⁿcheⁿ nda̱a̱na: —¿Aa nntsꞌaacheⁿnaꞌ na nntseicwꞌaa tsꞌaⁿ xjocanti ndoꞌ nncwjaaꞌñeyom juunaꞌ nacjeeꞌ tsꞌoom maquila, oo na nlcoomꞌm juunaꞌ nacjeeꞌ jnduu? ¿Aa nchii ndye nntseintyjaaⁿ juunaꞌ? ");
INSERT INTO amuNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Chaꞌtso na matsꞌaa jeꞌ na ticaliu chaꞌtsondye nnꞌaⁿ, mancjoꞌyoꞌ nlacano̱o̱ⁿꞌyoꞌ nda̱a̱na. Ndoꞌ cwii cwii ñꞌoom wjaañoomꞌ na matseina̱ⁿya jeꞌ maxjeⁿ nncueꞌntyjo̱ na nlaꞌno̱ⁿꞌ nnꞌaⁿ meiⁿnquiayuucheⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ꞌÑeeⁿ juu na niom lueꞌ nꞌom luaꞌqui na nndii, candii. ");
INSERT INTO amuNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ndoꞌ mati tsoom nda̱a̱na: —Queⁿꞌyoꞌ cwenta cantyja ꞌnaaⁿ ñꞌoommeiⁿꞌ na cwindyeꞌyoꞌ. Ee chaꞌxjeⁿ na cwiqueⁿndyoꞌ na cwindyeꞌyoꞌ, malaaꞌtiꞌ nñequiaa Tyꞌo̱o̱tsꞌom na nlaꞌno̱ⁿꞌyoꞌ. Ndoꞌ nntsꞌaaⁿ na nntsaalaꞌno̱ⁿꞌtiꞌyoꞌ ncꞌe na cwiqueⁿꞌyoꞌ cwenta. ");
INSERT INTO amuNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ee meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na mayuuꞌ matseiljo ñꞌoomya naquiiꞌ tsꞌom, mꞌmo̱o̱ⁿtya̱ya nnom. Sa̱a̱ tsꞌaⁿ na ticatseiljo ñꞌoomya naquiiꞌ tsꞌom, tsaⁿꞌñeeⁿ machꞌeenaꞌ cweꞌ tsꞌiaaⁿꞌndyo cantyjati chjoowiꞌ ñꞌoom na mantyjiityeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Mati tsonndaꞌ Jesús nda̱a̱na: —Juu na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom, matseijomnaꞌ chaꞌxjeⁿ na cwiluii quia na majuꞌ tsꞌaⁿ lqueeⁿ trigo nomtyuaa. ");
INSERT INTO amuNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Jnda̱ na tjoomꞌm lqueeⁿ wjaⁿ. Nntsom, nneiⁿncooñê, mmaaⁿñê, cweꞌ laaꞌtiꞌ cwiwinom jndye xuee, jndye tsjom. Ndoꞌ lqueeⁿꞌñeeⁿ nncꞌoomnaꞌ, wjaawindyenaꞌ sa̱a̱ tsaⁿꞌñeeⁿ ticatseiꞌno̱o̱ⁿꞌo̱ⁿ chiuu cwiluiiyuu na cwiꞌoowijnda̱naꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ee tyuaa ticaⁿnaꞌ tsꞌaⁿ na nnteijndeii na nncꞌoom ntjom. Najndyee cwiꞌoom jnda̱, ndoꞌ ꞌoowindyenaꞌ. Ndoꞌ cwiwaaꞌ xuꞌlqueeⁿ. Jnda̱ joꞌ macwjaaꞌñenaꞌ nꞌom lqueeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ndoꞌ quia na jnda̱ tmaⁿ lqueeⁿ, ꞌoocatyje nnꞌaⁿ joonaꞌ ee na jnda̱ tueꞌntyjo̱ xjeⁿ na nno̱ⁿnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ndoꞌ mati tsoom: —Juu na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom, ¿ljoꞌ ñꞌeⁿ matseijomnaꞌ? Ndoꞌ ¿ljoꞌ ñꞌeⁿ nlajo̱o̱ⁿꞌa na mꞌmo̱ⁿnaꞌ chiuu jaawitꞌmaⁿ cantyja na matsa̱ꞌntjoom? ");
INSERT INTO amuNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Matseijomnaꞌ chaꞌna cwii lqueeⁿ mostaza na nnomꞌ tsꞌaⁿ. Tjaaꞌnaⁿ cwiicheⁿ lqueeⁿ na cachjooti na cwinom nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Jnda̱ na jnomꞌ tsꞌaⁿ lqueeⁿꞌñeeⁿ cwiꞌoomnaꞌ, wjaawindyenaꞌ, mawinomꞌnaꞌ chaꞌtso ntjom na tiquiwindye. Cwileitanaꞌ hasta cantsaa na cwiꞌoontyja cwitaꞌjndyeeyoꞌ ncwaⁿꞌ lꞌo̱ tsꞌoomꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jndye ntꞌomcheⁿ ñꞌoom tjañoomꞌ teilꞌueeꞌñe Jesús quia tyotseineiiⁿ nda̱a̱ tmaaⁿꞌ naⁿꞌneeⁿ, cantyjati na nnda̱a̱ nlaꞌno̱ⁿꞌna. ");
INSERT INTO amuNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Chaꞌtso ñꞌoom na tyotseineiiⁿ nda̱a̱na, ñenquiiꞌcheⁿ ñꞌoom tjañoomꞌ. Ndoꞌ jnda̱nquia quia na tjuꞌnaꞌ na ñenqueⁿ ñequio nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê, quia joꞌ seineiⁿndyeyoom ñꞌoomꞌñeeⁿ nda̱a̱na. ");
INSERT INTO amuNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mañejuu xueeꞌñeeⁿ quia na jnda̱ tmaaⁿ, tsoom nda̱a̱ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê: —Cjaaya xndyaaꞌ ndaaluee, ntyjawaꞌñeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Quia joꞌ ꞌndyena nnꞌaⁿ na jndyendye. Tuo̱na tsꞌom wꞌaandaa na maxjeⁿ njom Jesús. Tyꞌeñꞌomna jom. Mati tyꞌelaꞌjomndye ntꞌomcheⁿ lꞌaandaa. ");
INSERT INTO amuNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Xjeⁿꞌñeeⁿ jndeii tioo jndye nnom ndaaluee tyontquienaꞌ nmo̱ⁿ tsꞌom wꞌaandaa hasta wjaatooꞌnaꞌ wjaatiomnaꞌ ndaatioo. ");
INSERT INTO amuNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Sa̱a̱ nquii Jesús watsom jo tsꞌaaⁿ wꞌaandaa, wantyeeⁿ cwii liaa ndyaa. Joona jlaꞌnlcwina jom, jluena nnoom: —ꞌU Maestro, ¿aa maxjeⁿ tjaa na cochꞌeenaꞌ ꞌu meiiⁿ na nncwja̱a̱ya? ");
INSERT INTO amuNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Quia joꞌ teicantyja Jesús, seitiaaⁿꞌaⁿ jndye. Seineiiⁿ nnom ndaaluee, tsoom: —Cuacheeⁿ, cjameiⁿntyjeꞌ. Quia joꞌ teicheⁿ jndye ndoꞌ su sꞌaanaꞌ nnom ndaaluee. ");
INSERT INTO amuNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ndoꞌ tsoom nda̱a̱ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê: —¿Chiuu na jeeⁿcheⁿ tyueꞌyoꞌ? ¿Aa maxjeⁿ tjo̱o̱cheⁿ na nlayuꞌya nꞌomꞌyoꞌ? ");
INSERT INTO amuNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Sa̱a̱ joona yacheⁿ tyocatyuena. Tyoluena nda̱a̱ ntyjeena: —¿ꞌÑeeⁿ cwiluiiñe tsaⁿmꞌaaⁿꞌ? Jndaꞌjom meiiⁿ jndye, meiiⁿ ndaaluee cwilaꞌcanda̱naꞌ ñꞌoom na matsa̱ꞌntjoom. ");
INSERT INTO amuNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Tquiena xndyaaꞌ ndaaluee, ndyuaa Gadara. ");
INSERT INTO amuNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Quia na jluiꞌ Jesús tsꞌom wꞌaandaa mantyja jnaⁿ cwii tsꞌaⁿ watsꞌomtyueꞌ na mꞌaaⁿ jndyetia naquiiꞌ tsꞌom. Jndyocatjomñe Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ñequiiꞌ macꞌeⁿ tsaⁿꞌñeeⁿ yuu niom ndeiꞌluaa. Ndoꞌ meiⁿcwii tsꞌaⁿ taticanda̱a̱ nntseityeⁿ jom, meiiⁿ ñꞌeⁿ lꞌuaancjo. ");
INSERT INTO amuNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ee jndye ndiiꞌ jnda̱ ñejlaꞌtyeⁿ nnꞌaⁿ ncꞌeeⁿ ñequio lꞌo̱o̱ⁿ ñꞌeⁿ lꞌuaancjo. Sa̱a̱ jom tyocꞌiooꞌñê lꞌuaancjoꞌñeeⁿ nchꞌu nchꞌu ntaⁿꞌ. Tjaa meiⁿ cwii tsꞌaⁿ na nnda̱a̱ nlqueⁿ xjeⁿ jom. ");
INSERT INTO amuNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Naxuee, natsjom ñequiiꞌcheⁿ tyomanoom quiiꞌntaaⁿ ndeiꞌluaa ndoꞌ quiiꞌ jnda̱a̱. Matseixuaⁿ jndeii ndoꞌ matseiquieeꞌñe cheⁿnqueⁿ ñequio ljo̱ꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Quia na ntyꞌiaaꞌtquiaaⁿ Jesús, jndyoleinoom, tjantyjaaⁿꞌaⁿ tcoomꞌm xtyeeⁿ jo nnom. ");
INSERT INTO amuNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","To̱ꞌ Jesús na matseineiⁿ nnom jndyetia, tsoom: —ꞌU jndyetia, caluiꞌ naquiiꞌ tsꞌom tsaⁿmꞌaaⁿꞌ. Joꞌ chii tꞌo̱ tsaⁿꞌñeeⁿ. Jndeii seineiⁿ tso: —¿Ljoꞌ nntsaꞌ ñꞌeⁿndyo̱ ja, ꞌu Jesús na cwiluiindyuꞌ Jnda Tyꞌo̱o̱tsꞌom na mꞌaaⁿ nandyeticheⁿ? Ñequio xueeꞌ Tyꞌo̱o̱tsꞌom, matsꞌaa tyꞌoo njomꞌ na tilcoꞌwiꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ndoꞌ taxꞌee Jesús ꞌndyoo tsaⁿꞌñeeⁿ, tsoom: —¿Chiuu jndyuꞌ? Tꞌo̱ jndyetia, tso: —Ja jndyuya Jndye Meiⁿ, ee na jndye meiⁿ caya. ");
INSERT INTO amuNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Quia joꞌ jndye tyꞌoo tyochꞌee tsaⁿꞌñeeⁿ na tincwjiꞌ Jesús joo jndyetia ndyuaaꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ndoꞌ joꞌ joꞌ nndyooꞌ waa cwii ta yuu na mꞌaaⁿ cwii tmaaⁿꞌ calcu na cwicwaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Joo jndyetiaꞌñeeⁿ tyolꞌana tyꞌoo nnom Jesús, jluena: —Cweꞌ na cajñomꞌ jâ yuu na mꞌaⁿ calcu. Quiaaꞌ ñꞌomꞌ na nncuo̱o̱yâ naquiiꞌ nꞌom jooyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Quia joꞌ tquiaa Jesús ñꞌoomꞌm na ljoꞌ calꞌana. Joꞌ chii jluiꞌna, tyꞌequieꞌna naquiiꞌ nꞌom calcuꞌñeeⁿ. Jleinomyoꞌ, teityuꞌyoꞌ yuu na ntyꞌa ꞌndyoo ndaaluee. Mana nchjeeñenaꞌ jooyoꞌ quiiꞌ ndaa. Ndoꞌ tmaaⁿꞌ calcuꞌñeeⁿ tueeꞌ chaꞌna we meiⁿ jooyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Quia joꞌ nnꞌaⁿ na tyojndooꞌ calcu jlaꞌtyuaaꞌna, tyꞌelaꞌcandiina nnꞌaⁿ quiiꞌ tsjoom ndoꞌ jo jnda̱a̱ na luaaꞌ tuii. Jluiꞌ nnꞌaⁿ, tquiocantyꞌiaana chiuu waa na tuii. ");
INSERT INTO amuNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Tquiena na mꞌaaⁿ Jesús. Jliuna tsꞌaⁿ na jeeⁿ cwajndii ñetjom, jnda̱ macweⁿ liaa ndoꞌ jnda̱ tcoꞌyañꞌeⁿnaꞌ jom. Jeeⁿ ndyaꞌ seicatyꞌuenaꞌ joona. ");
INSERT INTO amuNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ndoꞌ nnꞌaⁿ na ntyꞌiaanda̱a̱ chiuu waa na tuii, tcuu tcuu jlaꞌneiⁿna nda̱a̱ nnꞌaⁿ na tquiocantyꞌiaa. Jlaꞌcandiina chiuu waa na nꞌmaⁿ tsꞌaⁿ na ñejleiñꞌoom jndyetia ndoꞌ chiuu na tjoom calcuꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Quia joꞌ chaꞌtso nnꞌaⁿ to̱ꞌna na tyotaⁿna nnom Jesús na calueeⁿꞌeⁿ ndyuaa tsjoomna. ");
INSERT INTO amuNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Xjeⁿ na majaacuo̱nnaⁿꞌaⁿ tsꞌom wꞌaandaa, tjatseicandyooꞌñe juu tsꞌaⁿ na ñeseixmaⁿ jndyetia naquiiꞌ tsꞌom, macaⁿ na wjaa ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Sa̱a̱ Jesús ticwancueⁿꞌeⁿ. Tsoom nnom tsaⁿꞌñeeⁿ: —Cjaꞌlcweꞌ waꞌ na mꞌaⁿ nnꞌaⁿꞌ. Catsuꞌ nda̱a̱na cwanti na jeeⁿ tꞌmaⁿ naya na sꞌaa Tyꞌo̱o̱tsꞌom ñꞌeⁿndyuꞌ, ndoꞌ chiuu na tyꞌoom na wiꞌ tsꞌoom ꞌu. ");
INSERT INTO amuNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Quia joꞌ tja tsaⁿꞌñeeⁿ ndyuaa na mꞌaⁿ njoom Decápolis. To̱o̱ⁿꞌo̱ⁿ na tyotseicañeeⁿ nnꞌaⁿ cantyja ꞌnaaⁿꞌ naya na sꞌaa Jesús ñꞌeⁿñê. Ndoꞌ chaꞌtsondye nnꞌaⁿ ndyuaaꞌñeeⁿ jeeⁿ tjaweeꞌ nꞌomna. ");
INSERT INTO amuNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Teixndyaañenndaꞌ Jesús ndaaluee ñequio wꞌaandaa. Quia na tueⁿꞌeⁿ mantyja tyꞌentyjaaꞌ cwiicheⁿ cwii tmaaⁿꞌ nnꞌaⁿ jom. ");
INSERT INTO amuNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Cwii tsꞌaⁿ na jndyu Jairo na cwiluiitquieñe cantyja ꞌnaaⁿꞌ watsꞌom ꞌnaaⁿ nnꞌaⁿ judíos, tyjeꞌcañoom tsaⁿꞌñeeⁿ joꞌ joꞌ. Quia na ljeiiⁿ Jesús, tcoomꞌm xtyeeⁿ jo nnom. ");
INSERT INTO amuNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Sꞌaaⁿ tyꞌoo, tsoom: —Nomjndaaya mañeꞌcueeⁿꞌeⁿ. ¿Aa tijoom nntsaꞌ cwii nayaꞌñeeⁿ na nncjaꞌ, cjaꞌcatiooꞌ lꞌo̱ꞌ nacjoomꞌm cha na nnꞌmaaⁿ na nncwandoꞌtyeeⁿ? ");
INSERT INTO amuNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ndoꞌ tja Jesús ñꞌeⁿ tsaⁿꞌñeeⁿ. Mati jndye ntꞌomcheⁿ nnꞌaⁿ tyꞌentyjo̱, joꞌ chii sꞌaanaꞌ na jeeⁿ tyeeⁿ wjaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ndoꞌ na quiiꞌntaaⁿ naⁿꞌñeeⁿ ñꞌeⁿ cwii yuscu na jeeⁿ nioom wiiꞌ na jnda̱ canchooꞌwe chu na tyoojaameintyjeeꞌ na cwicaa nioomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Jeeⁿ wiꞌ ñetjoom na jndye nnom nasei tyolꞌa nnꞌaⁿ jom. Ndoꞌ chaꞌtso ꞌnaaⁿꞌaⁿ jnda̱ seicatsoom. Sa̱a̱ tjaaꞌnaⁿ na teijndeiinaꞌ jom, yacheⁿ nioomti matjoom. ");
INSERT INTO amuNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jnda̱ ñejñeeⁿ ñꞌoom cantyja ꞌnaaⁿꞌ Jesús, joꞌ chii tjantyjo̱o̱ⁿ naxeⁿꞌ quiiꞌntaaⁿ nnꞌaⁿ ndoꞌ tyenquioomꞌm liaaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ee na jnda̱ seitioom naquiiꞌ tsꞌoom: “Xeⁿ cweꞌ na nnda̱a̱ nñequiuuꞌa liaⁿꞌaⁿ, quia joꞌ nnꞌmaⁿya.” ");
INSERT INTO amuNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ndoꞌ jnda̱ na tyenquioomꞌm, mantyja ta̱a̱ꞌ. Ntyjiicheeⁿ na jnda̱ nꞌmaaⁿ tycu na weeⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Sa̱a̱ Jesús seiꞌno̱o̱ⁿꞌo̱ⁿ na nꞌmaⁿ cwii tsꞌaⁿ ñequio najndeii na matseixmaaⁿ. Quia joꞌ taqueeⁿ, ntyꞌiaaⁿꞌaⁿ nda̱a̱ chaꞌtso nnꞌaⁿ. Taxꞌeeñê nda̱a̱na: —¿ꞌÑeeⁿ cwii ꞌo tyenquiuuꞌ liaya? ");
INSERT INTO amuNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê jluena nnoom: —Jeeⁿ ꞌu Ta, jeeⁿ tyeeⁿ mꞌaⁿ nnꞌaⁿ nacañomꞌ. Ndoꞌ na mawaxeꞌ nda̱a̱yâ, xocanda̱a̱ nlꞌuuyâ ꞌñeeⁿ tyenquiuuꞌ liaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Sa̱a̱ mantyꞌiaaⁿꞌaⁿ ndiocheⁿ nacañomꞌm cha nljeiiⁿ ꞌñeeⁿ juu tyenquiuuꞌ liaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ndoꞌ juu yuscuꞌñeeⁿ, jeeⁿ cwiteiñê na macatyꞌueeⁿ ee na ntyjiicheeⁿ na jom jnda̱ tcoꞌyanaꞌ. Seicandyooꞌñê, tcoomꞌm xtyeeⁿ jo nnom Jesús. Tjeiꞌyuuꞌñê na jom tyenquioomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Tso Jesús nnoom: —ꞌU nomjndaaya, ncꞌe na matseiꞌyuꞌ ñꞌeⁿndyo̱, joꞌ na jnda̱ nꞌmaⁿꞌ. Jnda̱ jndyaandyuꞌ tycu na ñetjomꞌ. Cjaꞌtoꞌ waꞌ. Tyꞌo̱o̱tsꞌom cjaa ñꞌeⁿndyuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yocheⁿ na ndicwaⁿ matseineiⁿ Jesús nnom yuscuꞌñeeⁿ, tquieꞌcañom nnꞌaⁿ na jnaⁿ waaꞌ Jairo, juu tsꞌaⁿ na cwiluiitquieñe watsꞌom ꞌnaaⁿ nnꞌaⁿ judíos. Jluena nnoom: —Jnda̱ tueꞌ nomjndaꞌ. ¿Ljoꞌ nntsaꞌ na cwimatseicachjuuꞌtiꞌ Maestromꞌaaⁿꞌ? ");
INSERT INTO amuNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Sꞌaa Jesús ndooꞌ ticañeeⁿ ñꞌoom na jlue naⁿꞌñeeⁿ. Tsoom nnom tsꞌaⁿ na cwiluiitquieñe cantyja ꞌnaaⁿꞌ watsꞌom: —Tintyꞌueꞌ. Macanda̱ na catseiyuꞌ ñꞌeⁿndyo̱ ja. ");
INSERT INTO amuNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Meiⁿ tatinquiaaⁿ na nncꞌoolaꞌjomndye ntꞌomcheⁿ nnꞌaⁿ ñꞌeⁿñê na wjaⁿ waaꞌ tsaⁿꞌñeeⁿ. Macanda̱ tjañꞌoom Pedro, ñequio Jacobo ñꞌeⁿ Juan, tyjee Jacoboꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Jnda̱ na tquiena waaꞌ tsꞌaⁿ na cwiluiitquieñe cantyja ꞌnaaⁿꞌ watsꞌom, jndyena na jeeⁿ cꞌuaa camꞌaⁿ nnꞌaⁿ najndeii cwilaꞌxuaa na cwityuee. ");
INSERT INTO amuNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jnda̱ na tjaqueⁿꞌeⁿ quiiꞌ wꞌaa, tsoom nda̱a̱ naⁿꞌñeeⁿ: —¿Chiuu na jeeⁿ cꞌuaa mꞌaⁿꞌyoꞌ na cwityueeꞌyoꞌ? Yuscuchjoomꞌaaⁿꞌ nchii na jnda̱ tueeⁿꞌeⁿ. Cweꞌ na watsom. ");
INSERT INTO amuNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Sa̱a̱ joona cweꞌ cwincona jom. Quia joꞌ tjeiiⁿꞌeⁿ chaꞌtsondye naⁿꞌñeeⁿ chꞌeⁿ. Jnda̱ joꞌ tjañꞌoom tsotye yuscuchjoo ñꞌeⁿ tsondyee, mati ndyee naⁿꞌñeeⁿ na ñꞌeeⁿ ñꞌeⁿñê. Tyꞌequieꞌna na mꞌaaⁿ tsꞌoo chjoo. ");
INSERT INTO amuNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Tꞌueeⁿ tsꞌo̱ tsꞌoo chjoo. Tsoom nnom: —Talita, cumi. (Ñꞌoomwaaꞌ matsonaꞌ: ꞌU leii, matsjo̱o̱ njomꞌ, quicantyjaꞌ.) ");
INSERT INTO amuNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Mañoomꞌ teicantyja yuscuchjooꞌñeeⁿ. To̱o̱ⁿꞌo̱ⁿ na manoom ee tsꞌaⁿ na canchooꞌwe chuuꞌ jom. Ndoꞌ nnꞌaⁿ na mꞌaⁿ joꞌ joꞌ mañoomꞌ tquiaanaꞌ na jeeⁿ tjaweeꞌ nꞌomna, hasta tyueneiiⁿna. ");
INSERT INTO amuNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Quia joꞌ Jesús seicoomꞌm ndyueena na ticaluena nnom meiⁿcwii tsꞌaⁿ ljoꞌ tuii. Ndoꞌ tsoom na quiana na nlcwaꞌ yuscuchjooꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jluiꞌ Jesús tsjoomꞌñeeⁿ, tjalcweeⁿꞌeⁿ ndyuaa tsjomꞌm. Ndoꞌ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê tyꞌena ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Quia na tueeꞌ xuee na cwitaꞌjndyee nnꞌaⁿ judíos, tjaquieeꞌ Jesús naquiiꞌ watsꞌom ꞌnaaⁿna, to̱o̱ⁿꞌo̱ⁿ na tyoꞌmo̱o̱ⁿ nda̱a̱na. Ndoꞌ jndye nnꞌaⁿ na tyondye ñꞌoom na tyoñequiaaⁿ jeeⁿ tjaweeꞌ nꞌomna. Jluena: —¿Yuu chuu tsaⁿmꞌaaⁿ chaꞌtso ñꞌoommeiⁿꞌ na jeeⁿ yanaꞌ? Ndoꞌ ¿yuu jnaⁿ na jeeⁿ jndo̱ꞌ tsꞌoom? ¿Chiuu waayuu na jeeⁿ jndye nnom tsꞌiaaⁿ tꞌmaⁿ machꞌeeⁿ na tiquintyꞌiaaya? ");
INSERT INTO amuNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Ndoꞌ tsaⁿmꞌaaⁿꞌ, ¿aa nchii cweꞌ tsꞌaⁿ na macuuñe nꞌoom? ¿Aa tiyuuꞌ na jom jnda María? Ndoꞌ ntyjeeⁿ, ¿aa nchii Jacobo ñequio José ndoꞌ Judas ñequio Simón? Ndoꞌ mati yolcu ntyjeeⁿ mꞌaⁿna quiiꞌntaaⁿya. Joꞌ chii tꞌomna na tineiiⁿna jom. ");
INSERT INTO amuNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Quia joꞌ tso Jesús nda̱a̱na: —Majndye nnꞌaⁿ mꞌaⁿ na cwilaꞌtꞌmaaⁿꞌndye profeta. Sa̱a̱ macanda̱ nnꞌaⁿ ndyuaaⁿꞌaⁿ ñequio nnꞌaaⁿꞌaⁿ ñequio nnꞌaⁿ waⁿꞌaⁿ tixocalaꞌtꞌmaaⁿꞌndyena jom. ");
INSERT INTO amuNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Macweꞌ joꞌ tjaaꞌnaⁿ tsꞌiaaⁿ tꞌmaⁿ na sꞌaaⁿ quiiꞌntaaⁿna. Macanda̱ tioom lꞌo̱o̱ⁿ nacjoo cwantindye nnꞌaⁿwii na seinꞌmaaⁿ joona. ");
INSERT INTO amuNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ndoꞌ sꞌaanaꞌ na jeeⁿ jnda ntyjeeⁿ na tileicaꞌlaꞌyuꞌ naⁿꞌñeeⁿ. Jnda̱ chii tjawinoom njoom nchꞌu na nndyooꞌ tsjomꞌm. Tyoꞌmo̱ⁿtyeeⁿ nda̱a̱ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Quia joꞌ tꞌmaaⁿ nnꞌaⁿ canchooꞌwe na cwilaꞌjomndye ñꞌeⁿñê. Tquiaaⁿ najndeii na tseixmaaⁿ na nlaꞌxmaⁿna cha nnda̱a̱ nntjeiiꞌna jndyetia naquiiꞌ nꞌom nnꞌaⁿ. Ndoꞌ to̱o̱ⁿꞌo̱ⁿ na majñoom we wendyena tsꞌiaaⁿ ꞌnaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ndoꞌ sa̱ꞌntjoom na meiⁿcwii ꞌnaⁿ ticꞌooñꞌomna nato, meiⁿ chetsjaꞌ, meiⁿ tyooꞌ, meiⁿ tsjo̱ꞌñjeeⁿ. Macanda̱ tsꞌoom lꞌeii wanaaⁿ na nncꞌooñꞌomna, ");
INSERT INTO amuNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ñequio lcoom na ñjoomna. Ndoꞌ manda̱ liaa na cweeꞌna na cwiꞌoona. ");
INSERT INTO amuNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Mati tsoom nda̱a̱na: —Meiⁿyuucheⁿ waaꞌ tsꞌaⁿ na nntsquieꞌyoꞌ, caljooꞌndyoꞌ joꞌ joꞌ hasta xjeⁿ na nluiꞌyoꞌ tsjoomꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Sa̱a̱ xeⁿ nntsquieꞌyoꞌ cwii tsjoom na tiñeꞌcatoꞌñoom nnꞌaⁿ ꞌo, meiⁿ tiñeꞌcandyena ñꞌoom ndyueꞌyoꞌ, quia na nluiꞌyoꞌ tsjoomꞌñeeⁿ, calaquiaꞌyoꞌ tsꞌojnda̱a̱ na chuuꞌ ncꞌeeꞌyoꞌ cha na nncwjiꞌyuuꞌñenaꞌ nacjoo naⁿꞌñeeⁿ na tîcatoꞌñoomna ñꞌoomꞌ Tyꞌo̱o̱tsꞌom. Mayuuꞌcheⁿ nndyeꞌyoꞌ nntsjo̱o̱, xuee na nncuꞌxeⁿ Tyꞌo̱o̱tsꞌom nnꞌaⁿ, tꞌmaⁿti nawiꞌ nntjoom nnꞌaⁿ tsjoomꞌñeeⁿ, nchiiti na nntjoom nnꞌaⁿ tsjoom Sodoma ñꞌeⁿ Gomorra. ");
INSERT INTO amuNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ndoꞌ jluiꞌ nnꞌaⁿ na jñom Jesús. Tyꞌenquiana ñꞌoom na calcweꞌ nꞌom nnꞌaⁿ jnaaⁿna. ");
INSERT INTO amuNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Mati majndye jndyetia tyotjeiiꞌna naquiiꞌ nꞌom nnꞌaⁿ. Tyotyꞌoomndyena seitye nacjoo nnꞌaⁿ wii na tyolaꞌnꞌmaⁿna naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ndoꞌ Herodes, tsꞌaⁿ na matsa̱ꞌntjom, jñeeⁿ cantyja ꞌnaaⁿꞌ Jesús ee chaꞌwaa ndyuaaꞌñeeⁿ jnda̱ tꞌoomꞌ ñꞌoomꞌñeeⁿ. Sa̱a̱ luaa seitioom cantyja ꞌnaaⁿꞌ Jesús, tsoom: —Tsaⁿmꞌaaⁿꞌ ¿aa nchii juu Juan, tsꞌaⁿ na tyotseitsꞌoomñe nnꞌaⁿ? ¿Aa nchii jom jnda̱ wandoꞌxcoom na tueeⁿꞌeⁿ, joꞌ chii waa na matseixmaaⁿ na cwicanda̱a̱ machꞌeeⁿ tsꞌiaaⁿ tꞌmaⁿmeiⁿꞌ? ");
INSERT INTO amuNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Sa̱a̱ ntꞌomcheⁿ nnꞌaⁿ tyolue: —Profeta Elías luaaꞌ. Ndoꞌ ntꞌomcheⁿ tyolue: —Luaaꞌ profeta chaꞌna joo profeta na tyomꞌaⁿ tandyo xuee. ");
INSERT INTO amuNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Quia na jndii Herodes ñꞌoommeiⁿꞌ na cwilue ntꞌomcheⁿ, tsonnaaⁿꞌaⁿ: —Maxjeⁿ Juan luaaꞌ, tsꞌaⁿ na sa̱ꞌntjo̱ⁿ na catyjena xtyoꞌ. Jnda̱ wandoꞌxcoom na tueeⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Ee Herodes ñequio tsaⁿ na jndyu Felipe joona cwii nquieendyena. Sa̱a̱ Herodes mꞌaaⁿ ñꞌeⁿ scuuꞌ tyjeeⁿ. Herodías jndyu yuscuꞌñeeⁿ. Ndoꞌ tyotso Juan nnoom: —ꞌU ticatsa̱ꞌntjomnaꞌ na mañꞌoomꞌ scuuꞌ tꞌiuꞌ. Jnaaⁿꞌ ñꞌoomwaaꞌ na jeeⁿ ndyaꞌ jndooꞌ yuscu Herodías Juan. Joꞌ chii seincjooꞌñe yuscuꞌñeeⁿ nnom Herodes ndoꞌ jom jeꞌ seiyoomꞌm, sa̱ꞌntjoom na calaꞌtyeⁿna Juan, chii catueeꞌna juu wꞌaancjo. Herodías queeⁿ tsꞌoom Juan hasta lꞌue tsꞌoom na calacueeꞌna juu sa̱a̱ tileicanda̱a̱. ");
INSERT INTO amuNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Ee Herodes nquiaⁿꞌaⁿ juu. Seiꞌno̱o̱ⁿꞌo̱ⁿ na tseixmaⁿ Juan cantyja na matyꞌiomyanaꞌ ndoꞌ na jnda̱ tqueⁿljuꞌ Tyꞌo̱o̱tsꞌom naquiiꞌ tsꞌom tsaⁿꞌñeeⁿ. Joꞌ chii tyowañomꞌm juu cha ticatsꞌaa yuscuꞌñeeⁿ nawiꞌ ñꞌeⁿñe. Ñequio na xcweeꞌ tsꞌoom tyoñeeⁿ ñꞌoom na tyoñeꞌquiaa tsaⁿꞌñeeⁿ sa̱a̱ tijndye seiꞌno̱o̱ⁿꞌo̱ⁿ ñꞌoom na tyotseineiⁿ Juan. ");
INSERT INTO amuNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Sa̱a̱ tueꞌntyjo̱ xjeⁿ na juu Herodías ljeiiⁿ chiuu ya na nnda̱a̱ nntsꞌaaⁿ. Ee tueeꞌ xueechuuꞌ Herodes, tyolaꞌtꞌmaaⁿꞌndyena jom. Tquiaaⁿ nantquie na tcwaꞌ nnꞌaⁿ na cwiluiitquiendye cantyja ꞌnaaⁿꞌaⁿ, ñequio nnꞌaⁿ na cwitsa̱ꞌntjom sondaro, ndoꞌ ñequio ntꞌomcheⁿ nnꞌaⁿ na cwiluiitquiendye tsꞌo̱ndaa Galilea. ");
INSERT INTO amuNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Quia joꞌ tjaquieeꞌ yuscundyua jnda Herodías yuu cwicwaꞌ naⁿꞌñeeⁿ, seijnom jo nda̱a̱na. Jeeⁿ tjaweeꞌ tsꞌom Herodes ndoꞌ mati nnꞌaⁿ na jlaꞌjomndye ñꞌeⁿñê. Tsoom nnom yuscundyuaꞌñeeⁿ: —Caⁿꞌ cantyjati na lꞌue tsꞌomꞌ no̱o̱ⁿ, ndoꞌ ja nñequia. ");
INSERT INTO amuNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Seityeⁿtyeeⁿ ñꞌoom, tsoom: —Meiⁿnquia na nlcaⁿꞌ no̱o̱ⁿ, nñequia hasta meiiⁿ xcwe cantyja na matsa̱ꞌntjo̱ⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Jluiꞌ yuscuꞌñeeⁿ quiiꞌntaaⁿ nnꞌaⁿ, taxꞌeeⁿ nnom tsoñeeⁿ: —Naⁿ, ¿ljoꞌ nlcaaⁿꞌa? Tꞌo̱ tsaⁿꞌñeeⁿ nnom jnaaⁿ: —Caⁿꞌ xqueⁿ Juan, tsaⁿ na tyotseitsꞌoomñe nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Mantyja seityuaaⁿꞌaⁿ, tjaquieeꞌnnaaⁿꞌaⁿ na mꞌaaⁿ rey Herodes, tsoom: —Ja lꞌue tsꞌo̱o̱ⁿ na majeꞌndyo quiaaꞌ no̱o̱ⁿ cwii xio na njom xqueⁿ Juan, tsaⁿ na tyotseitsꞌoomñe nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Na luaaꞌ tso tsaⁿꞌñeeⁿ, jeeⁿ seichjooꞌnaꞌ tsꞌom Herodes. Sa̱a̱ ncꞌe na jnda̱ tqueⁿtyeeⁿ ñꞌoomꞌm ñequio na ndyecheⁿ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê, joꞌ chii tîcanda̱a̱ꞌ tsꞌoom na nntseichueeⁿꞌeⁿ ñꞌoom. ");
INSERT INTO amuNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Mantyja jñoom cwii sondaro ꞌnaaⁿꞌaⁿ, sa̱ꞌntjoom na cjaacꞌoom tsaⁿꞌñeeⁿ xqueⁿ Juan. ");
INSERT INTO amuNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Quia joꞌ tja sondaroꞌñeeⁿ wꞌaancjo, tjacatyjeeⁿ xtyoꞌ Juan. Jnda̱ chii jndyoñꞌoom juunaꞌ tsꞌom cwii xio. Tquiaaⁿ nnom yuscuꞌñeeⁿ ndoꞌ juu tquiaa nnom tsondyee. ");
INSERT INTO amuNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jnda̱ na jndye nnꞌaⁿ na tyocañꞌeeⁿ ñꞌeⁿ Juan, quia joꞌ tyꞌecꞌomna seiꞌtsꞌo ꞌnaaⁿꞌaⁿ. Tyꞌecatꞌiuuna jom. ");
INSERT INTO amuNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Nnꞌaⁿ na jñom Jesús tsꞌiaaⁿ ꞌnaaⁿꞌaⁿ tjomndyenndaꞌna na mꞌaaⁿ. Tyoluena nnoom chaꞌtso tsꞌiaaⁿ na jnda̱ ñelꞌana ndoꞌ chaꞌtso ñꞌoom na jnda̱ ñetꞌmo̱o̱ⁿna. ");
INSERT INTO amuNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Quia joꞌ tsoom nda̱a̱na: —Cjaaya, nntsaaya cwii joo yuu na ñencjo̱o̱ jo jnda̱a̱ na nntaꞌjndya̱a̱ya. Ee yuu na tyomꞌaⁿna jndye tsꞌaⁿ, nnꞌaⁿ na cwiquie ndoꞌ nnꞌaⁿ na cwiꞌoo, meiⁿ tileicjuꞌnaaⁿñenaꞌ na nlcwaꞌna. ");
INSERT INTO amuNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Joꞌ chii jluiꞌna na ñenquieena ñꞌeⁿ wꞌaandaa na ꞌoona cwii joo yuu na tjaaꞌnaⁿ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Sa̱a̱ jndye nnꞌaⁿ ntyꞌiaatquia na cwiꞌoona ndoꞌ taꞌjnaaⁿꞌ naⁿꞌñeeⁿ joona na ꞌoowinomna. Ndoꞌ jlaꞌtyuaaꞌti naⁿꞌñeeⁿ, jnaⁿna njoomna tyꞌecaꞌna, tyꞌenquiandyena ꞌndyoo ndaaluee. Joona tquiejndyeena yuu na wjaa Jesús ñequio nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Quia jlueeⁿꞌeⁿ tsꞌom wꞌaandaa ntyꞌiaaⁿꞌaⁿ na jeeⁿ jndye nnꞌaⁿ jnda̱ tjomndye joꞌ joꞌ. Tyꞌoom na jeeⁿ wiꞌ tsꞌoom naⁿꞌñeeⁿ ee cweꞌ mꞌaⁿtona chaꞌcwijom cwii tmaaⁿꞌ canmaⁿ na tjaa ꞌñeeⁿ juu na ya nnteixꞌee. Quia joꞌ to̱o̱ⁿꞌo̱ⁿ na jndye ñꞌoom tyoꞌmo̱o̱ⁿ nda̱a̱na. ");
INSERT INTO amuNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Quia na jnda̱ tmaaⁿ, nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê tyꞌentyjaaꞌna jom, jluena nnoom: —Jeꞌ jnda̱ tmaaⁿ ndoꞌ tjaaꞌnaⁿ lꞌaa meiⁿ rancho ꞌnaaⁿ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Cajñomꞌ naⁿmꞌaⁿꞌ na nncꞌoona ranchoo nnꞌaⁿ oo njoom nchꞌu na nndyooꞌ nndyooꞌ cha joꞌ joꞌ nnda̱a̱ nlaꞌjndana na nlcwaꞌna. Ee joona tjaaꞌnaⁿ na cꞌomna na nlcwaꞌna. ");
INSERT INTO amuNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Tꞌo̱ Jesús nda̱a̱na, tsoom: —ꞌO quiaꞌyoꞌ na nlcwaꞌna. Quia joꞌ jluena nnoom: —¿Cwaaⁿ nnda̱a̱ nleijndeii meiiⁿ nntsalajndaayâ chaꞌna we siaⁿnto sꞌom denario tyooꞌ na nñeꞌquiaayâ na nlcwaꞌ naⁿmꞌaⁿꞌ? ");
INSERT INTO amuNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Taxꞌeeⁿ nda̱a̱na, tsoom: —¿Cwanti tyooꞌ cwileiñꞌomꞌyoꞌ? Cantyꞌiaꞌyoꞌ cwanti na mawaa. Jnda̱ na lꞌueena, jluena nnoom: —Ñeꞌom taⁿꞌ tyooꞌ ñꞌeⁿ we catscaa cwileinꞌo̱o̱ⁿyâ. ");
INSERT INTO amuNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Quia joꞌ sa̱ꞌntjoom na calꞌa nnꞌaⁿ cwii cwii tmaaⁿꞌ ndoꞌ cwindyuaandyena nacjooꞌ jnda̱ nchꞌu. ");
INSERT INTO amuNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ntꞌom naⁿꞌñeeⁿ tyꞌemeindyuaandyena cwii siaⁿnto na cwii cwii tmaaⁿꞌ, ndoꞌ ntꞌom naⁿꞌñeeⁿ lꞌana wenꞌaaⁿ nchooꞌ nqui na cwii cwii tmaaⁿꞌ joona. ");
INSERT INTO amuNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jnda̱ na toꞌñoom ꞌom taⁿꞌ tyooꞌ ñequio we catscaa, quia joꞌ jlunda̱a̱ñê cañoomꞌluee. Tquiaaⁿ na quianlꞌuaaꞌ Tsotyeeⁿ. Jnda̱ joꞌ tyjeeⁿ tyooꞌñeeⁿ, tquiaaⁿ joonaꞌ nda̱a̱ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê cha joona nntꞌoomna joonaꞌ nda̱a̱ nnꞌaⁿ na meindyuaandye. Majoꞌti sꞌaaⁿ ñꞌeⁿ we catscaa. ");
INSERT INTO amuNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tcwaꞌ chaꞌtsondye nnꞌaⁿ hasta tjacjoona. ");
INSERT INTO amuNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ndoꞌ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê jlaꞌtjomna ntaⁿꞌ ntyooꞌ ñꞌeⁿ calcaa na ꞌndiinaꞌ. Tooꞌ canchooꞌwe tsquiee. ");
INSERT INTO amuNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ndoꞌ jndye nnꞌaⁿ na tcwaꞌ ntyooꞌ na tyotꞌoom naⁿꞌñeeⁿ. Tueꞌntyjo̱ chaꞌna ꞌom meiⁿ na cweꞌ naⁿnom. ");
INSERT INTO amuNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Quia joꞌ mantyja jñom Jesús nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê na cuo̱na tsꞌom wꞌaandaa, cꞌooñetina, nncwitꞌiooꞌna xndyaaꞌ ndaaluee na nlquiena tsjoom Betsaida. Jom nljooꞌñetyeeⁿ yocheⁿ na majñoom nnꞌaⁿ na jndyendye. ");
INSERT INTO amuNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ndoꞌ jnda̱ na jñoom naⁿꞌñeeⁿ, tjawaaⁿ cwii joo quiiꞌ jnda̱a̱ yuu na ñenqueⁿ na nntseineiiⁿ nnom Tsotyeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Quia na jnda̱ teinco̱o̱ⁿꞌ, juu wꞌaandaaꞌñeeⁿ mamꞌaaⁿnaꞌ xcwe tsꞌom ndaaluee, ndoꞌ Jesús ñenqueⁿ cwii mꞌaaⁿ tyuaatcwii. ");
INSERT INTO amuNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ntyꞌiaaⁿꞌaⁿ na jeeⁿ wiꞌ cwitjoom naⁿꞌñeeⁿ na ñjomndye wꞌaandaa, ee matseilcweꞌtyaꞌ jndye juunaꞌ. Jeeⁿ cwilaꞌjnda̱na na cwicantyjaandyena nꞌoom palaꞌ cwentaaꞌ wꞌaandaaꞌñeeⁿ. Chaꞌna ñequiee na cwitsjoom jnaaⁿ tjacaⁿ nnom ndaaluee. Tueeꞌcañoom na mꞌaⁿna, ndooꞌ cweꞌ nncwinoomꞌm joona. ");
INSERT INTO amuNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Quia ntyꞌiaana na mawjaacaⁿ nnom ndaaluee, jlaꞌtiuuna jndii cwintyꞌiaana. Jndeii tyolaꞌxuaana. ");
INSERT INTO amuNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Jeeⁿ ndyaꞌ tyuena ee chaꞌtsondyena ntyꞌiaana jom. Mantyja tꞌmaaⁿ joona, tsoom nda̱a̱na: —Cꞌomꞌyoꞌ na tꞌmaⁿ nꞌomꞌyoꞌ. Mannco̱ luaa. Tilacatyuendyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Quia joꞌ tuo̱o̱ⁿ tsꞌom wꞌaandaa yuu na ñjomndyena, mana teicheⁿ jndye. Joꞌ chii jeeⁿ seiñꞌeeⁿꞌñenaꞌ joona cantyja ꞌnaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ee tilaꞌno̱ⁿꞌna cantyja ꞌnaaⁿꞌ tsꞌiaaⁿ tꞌmaⁿ na sꞌaa Jesús ñequio ntyooꞌ na tcwaꞌ nnꞌaⁿ. Ndoꞌ ndicwaⁿ tileiqueⁿna cwenta ꞌñeeⁿ cwiluiiñê. ");
INSERT INTO amuNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Quia na jnda̱ teiꞌxndyaandyena ndaaluee, tquiena ndyuaa Genesaret. Joꞌ joꞌ teicjoomna wꞌaandaa ꞌndyoo ndaaluee. ");
INSERT INTO amuNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Quia jluiꞌna wꞌaandaa mañoomꞌ taꞌjnaaⁿꞌ nnꞌaⁿ ndyuaaꞌñeeⁿ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Jlaꞌtyuaaꞌna, tyꞌena chaꞌwaa ndyuaaꞌñeeⁿ, tyoꞌoochona nnꞌaⁿwii cweꞌ ñꞌeⁿ nduu meiⁿyuucheⁿ joo na ndyena na maweeꞌ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Ndoꞌ meiⁿyuucheⁿ na tueⁿꞌeⁿ, meiiⁿ njoom nchꞌu, meiiⁿ njoom tꞌmaⁿ, meiiⁿ jo ndoꞌ jnda̱a̱, tyotsa̱ꞌna nnꞌaⁿwii tsꞌom nato. Ndoꞌ joo nnꞌaⁿwiiꞌñeeⁿ tyolaꞌtyꞌoondyena nnoom na nñequiaaⁿ meiiⁿ cweꞌ ꞌndyoo liaⁿꞌaⁿ na nñeꞌquioꞌna. Ndoꞌ chaꞌtso nnꞌaⁿ na tyeꞌnquioꞌ ꞌndyoo liaⁿꞌaⁿ nꞌmaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nnꞌaⁿ fariseos ñequio nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés, jnaⁿna Jerusalén, tquiena na mꞌaaⁿ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ee jnda̱ tqueⁿna cwenta chiuu cwilꞌa nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê na cwicwaꞌ na tyootjeiꞌljuuꞌndyena chaꞌxjeⁿ costumbre na waa ee tyoondyuuꞌna chaꞌxjeⁿ nquiu naⁿꞌñeeⁿ na macaⁿnaꞌ. Joꞌ chii tyolaꞌncjooꞌndye naⁿꞌñeeⁿ nacjoona. ");
INSERT INTO amuNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ee nnꞌaⁿ fariseos ñequio chaꞌtso nnꞌaⁿ judíos, jeeⁿ cwiqueⁿndyena na cwilaꞌcanda̱na costumbre na tqueⁿ nnꞌaⁿ na tyoluiitquiendye nda̱a̱na. Joꞌ chii mati ticwaꞌna xeⁿ nchii na nndyuuꞌjndyeena chaꞌxjeⁿ na matso costumbreꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ndoꞌ quia na cwinquiolcweeꞌna na tyꞌena tsꞌua ticwaꞌna xeⁿ nchii na cwiqueⁿljuꞌndyejndyeena. Mati jndye ntꞌomcheⁿ costumbre cwilaꞌwena na matseijndaaꞌñenaꞌ chiuu waa na nntmaaⁿ waso, ñequio caseito, ñequio xjo casuela, ñequio jnduu. ");
INSERT INTO amuNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Quia joꞌ nnꞌaⁿ fariseos ñequio nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés, taꞌxꞌeena nnom Jesús, jluena: —Nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿndyuꞌ ¿chiuu na ticalaꞌcanda̱na costumbre na tqueⁿ nnꞌaⁿ na tyoluiitquiendye nda̱a̱ya na cwicwaꞌna na ndicwaⁿ mꞌaⁿna na tiqueⁿljuꞌndyena? ");
INSERT INTO amuNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Tꞌo̱ Jesús nda̱a̱na, tsoom: —ꞌO nnꞌaⁿ na we waa cwilaꞌtiuuꞌyoꞌ, jeeⁿ teixcwe ñꞌoom tjeiꞌ profeta Isaías cantyja ꞌnaⁿꞌyoꞌ quia na seiljeiⁿ ñꞌoom na matsonaꞌ: Naⁿmꞌaⁿꞌ ndooꞌ na jeeⁿ cwilaꞌtꞌmaaⁿꞌndyena ja, sa̱a̱ tꞌmaⁿ waa na tixcweeꞌ nꞌomna ñꞌeⁿndyo̱. ");
INSERT INTO amuNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Cweꞌ tsꞌiaaⁿꞌndyo na cwilaꞌtꞌmaaⁿꞌndyena ja ee cwitꞌmo̱o̱ⁿna ñꞌoom na cweꞌ cwiqueⁿ nnꞌaⁿ, tachii ñꞌoomya. ");
INSERT INTO amuNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ndoꞌ tsoti Jesús nda̱a̱na: —ꞌO yacheⁿ cwiꞌndyeꞌyoꞌ ñꞌoom na sa̱ꞌntjom Tyꞌo̱o̱tsꞌom ndoꞌ cwitsantyjo̱ꞌyoꞌyoꞌ costumbre na cweꞌ nnꞌaⁿ tqueⁿ. Joo costumbreꞌñeeⁿ cwitꞌmo̱o̱ⁿnaꞌ chiuu waa na nntmaaⁿ caseito, ñequio waso, ndoꞌ jndye ntꞌomcheⁿ ñꞌoom na laaꞌtiꞌ macaⁿnaꞌ na calacanda̱ꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ndoꞌ tsotyeeⁿ nda̱a̱ naⁿꞌñeeⁿ: —ꞌO jeeⁿ cwilꞌaꞌyoꞌ na tilꞌue ljeii na sa̱ꞌntjom Tyꞌo̱o̱tsꞌom, cha nnda̱a̱ nntsantyjo̱ꞌyoꞌ costumbre na cwilꞌueeꞌndyoꞌ ncjoꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ee matso Moisés: “Catseitꞌmaaⁿꞌndyuꞌ tsotyeꞌ ñꞌeⁿ tsoꞌndyoꞌ”, ndoꞌ mati matsoom: “ꞌÑeeⁿ juu na matso ñꞌoomwiꞌ nacjooꞌ tsotye oo tsondyee, calaꞌcueeꞌ nnꞌaⁿ juu.” ");
INSERT INTO amuNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Sa̱a̱ ꞌo cwinduꞌyoꞌ wanaaⁿ na nntso tsꞌaⁿ nnom tsotyeeⁿ oo tsoñeeⁿ: “Catseitꞌmaⁿ tsꞌomꞌ taxocanda̱a̱ nnteijndeiya ꞌu ꞌnaⁿ na tjo̱o̱ndyuꞌ ee chaꞌtso ꞌnaⁿya na niom laꞌxmaⁿnaꞌ Corbán.” (Ñꞌoomwaaꞌ maꞌmo̱ⁿnaꞌ na chaꞌtso ꞌnaaⁿꞌ tsꞌaⁿ jnda̱ tqueeⁿ joonaꞌ cwentaaꞌ Tyꞌo̱o̱tsꞌom). ");
INSERT INTO amuNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ndoꞌ quia na luaaꞌ cwinduꞌyoꞌ cwilꞌaꞌyoꞌyoꞌ na tacaⁿnaꞌ na cateijndeii tsꞌaⁿ tsotyeeⁿ oo tsoñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ndoꞌ laaꞌtiꞌ cwilꞌaꞌyoꞌ na tilꞌue ñꞌoom na tqueⁿ Tyꞌo̱o̱tsꞌom ee cwilacanda̱ꞌyoꞌ costumbre na tqueⁿ nnꞌaⁿ. Mati jndye ntꞌomcheⁿ nnom na cwilꞌaꞌyoꞌ chaꞌna nmeiⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Cwiicheⁿ cwii ndiiꞌ tꞌmaⁿ Jesús nnꞌaⁿ na jndyendye na mꞌaaⁿ, tsoom nda̱a̱na: —Candyeꞌyoꞌ chaꞌtsondyoꞌ ndoꞌ calaꞌno̱ⁿꞌyoꞌ: ");
INSERT INTO amuNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Tjaaꞌnaⁿ cwii nantquie na macwaꞌ tsꞌaⁿ na nntsꞌaanaꞌ na tilꞌueñê jo nnom Tyꞌo̱o̱tsꞌom. Sa̱a̱ ñꞌoom na cwinaaⁿꞌ naquiiꞌ tsꞌoom nlꞌanaꞌ na tilꞌueñê. ");
INSERT INTO amuNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","ꞌÑeeⁿ juu na niom lueꞌ nꞌom luaꞌqui na nndii, candii. ");
INSERT INTO amuNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Quia joꞌ ꞌndii Jesús nnꞌaⁿ na jndyendye, tjaqueⁿꞌeⁿ quiiꞌ wꞌaa. Ndoꞌ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê taꞌxꞌeendyena cantyja ꞌnaaⁿꞌ ñꞌoom tjañoomꞌ na seineiiⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Quia joꞌ tsoom nda̱a̱na: —¿Aa maxjeⁿ mati ꞌo tilaꞌno̱ⁿꞌyoꞌ? ¿Aa tiqueⁿꞌyoꞌ cwenta na tjaaꞌnaⁿ cwii nnom nantquie na cwicwaꞌ nnꞌaⁿ na juunaꞌ nntsꞌaanaꞌ na tilꞌueñe tsꞌaⁿ jo nnom Tyꞌo̱o̱tsꞌom? ");
INSERT INTO amuNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ee nchii naquiiꞌ tsꞌom tsꞌaⁿ nncueeꞌnaꞌ. Maxjeⁿ tsꞌom tsiaⁿꞌaⁿ nncueeꞌnaꞌ, jnda̱ chii nnteiⁿꞌeⁿ juunaꞌ. Luaaꞌ tsoom na maꞌmo̱o̱ⁿ na ya nlcwaꞌ tsꞌaⁿ chaꞌtso nnom nantquie. ");
INSERT INTO amuNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jnda̱ chii tsoom nda̱a̱na: —Joo na cwinaaⁿꞌ naquiiꞌ tsꞌom tsꞌaⁿ cwilꞌanaꞌ na tilꞌueñê jo nnom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ee cantyjati na tseixmaⁿ naquiiꞌ tsꞌom tsꞌaⁿ joꞌ na cwiwitquiooꞌ natia na matseitiuu chaꞌna cweꞌ nncꞌoomya tsꞌaⁿ ñꞌeⁿ xꞌiaaⁿꞌaⁿ, oo ñꞌeⁿ sculjaaꞌ, chaꞌna nntseicueeꞌ tsꞌaⁿ xꞌiaaⁿꞌaⁿ, ");
INSERT INTO amuNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","chaꞌna nnchꞌuee tsꞌaⁿ, chaꞌna nntseiqueeⁿ tsꞌom tsꞌaⁿ ꞌnaaⁿꞌ xꞌiaaⁿꞌaⁿ, chaꞌna nncꞌoom tsꞌaⁿ na wiꞌñe, chaꞌna cweꞌ ñequiuꞌnnꞌaⁿ tsꞌaⁿ, chaꞌna meiⁿ cweꞌ tajnaaⁿꞌto tsꞌaⁿ, chaꞌna nntseita̱a̱ꞌ tsꞌom tsꞌaⁿ, chaꞌna nntioꞌñꞌoom tsꞌaⁿ xꞌiaaⁿꞌaⁿ, chaꞌna nntseisꞌañe oo nntseiscuñe tsꞌaⁿ, oo chaꞌna nntseintjeiⁿñe cheⁿnquii tsꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Chaꞌtso natiameiⁿꞌ cwinaaⁿꞌnaꞌ naquiiꞌ tsꞌom tsꞌaⁿ ndoꞌ joonaꞌ cwilꞌanaꞌ na tjaa yuu lꞌueñe jo nnom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jluiꞌ Jesús joꞌ joꞌ, tjaaⁿ ndyuaa Tiro ñꞌeⁿ Sidón. Joꞌ tjaqueⁿꞌeⁿ quiiꞌ wꞌaa ee ticalꞌue tsꞌoom na nndye nnꞌaⁿ na joꞌ mꞌaaⁿ. Sa̱a̱ tîcanda̱a̱ nncwantyꞌioom. ");
INSERT INTO amuNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Mañoomꞌ jndii cwii yuscu na joꞌ mꞌaaⁿ. Tyjeꞌcañoom joꞌ joꞌ ndoꞌ tcoꞌ xtye jo nnom Jesús. Ee mꞌaaⁿ yuscuchjoo jnda yuscuꞌñeeⁿ na maleiñꞌoom jndyetia. ");
INSERT INTO amuNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ndoꞌ jom nchii tsꞌaⁿ judío. Jom tsꞌaⁿ sirofenicia. Sꞌaa tyꞌoo nnom Jesús na cwjiꞌ tsaⁿꞌñeeⁿ jndyetia naquiiꞌ tsꞌom yuscuchjoo jnaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Sa̱a̱ tso Jesús nnoom: —Matsonaꞌ na nlcwaꞌjndyee yocanchꞌu, ee ticatyꞌiomnaꞌ na nntjeiiꞌa na cwicwaꞌna na nñeꞌquiaayo̱o̱ joonaꞌ nda̱a̱ calueꞌ nchꞌu. ");
INSERT INTO amuNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Yuscuꞌñeeⁿ tꞌo̱o̱ⁿ nnom Jesús. Tsoom: —Jeeⁿ mayuuꞌ, ꞌu Ta, sa̱a̱ cantyꞌiaꞌ, calueꞌ nchꞌu ndyaꞌ cwicwaꞌyoꞌ meiiⁿ cweꞌ nacajnda̱a̱ na cwiquiaa nacjeeꞌ meiⁿsa na jlaꞌquiaa yocanchꞌu. ");
INSERT INTO amuNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Quia joꞌ tso Jesús nnom yuscuꞌñeeⁿ: —Jeeⁿ majoꞌndyo ñꞌoom na tsuꞌ. Ya xeⁿ wjaꞌtoꞌ waꞌ. Jnda̱ jluiꞌ jndyetia naquiiꞌ tsꞌom yuscuchjoo jndaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Tja tsaⁿꞌñeeⁿ ndoꞌ quia na tueⁿꞌeⁿ waⁿꞌaⁿ, ljeiiⁿ na mawaacheⁿ yuscuchjoo cjooꞌ jnduu. Mayuuꞌ na jnda̱ jluiꞌ jndyetia naquiiꞌ tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tjalcweꞌ Jesús na ñetꞌoom joꞌ joꞌ. Tjawinoom ndyuaa Tiro, ndoꞌ ndyuaa Sidón ñequio ndyuaa jo ndoꞌ njoom Decápolis. Tueⁿꞌeⁿ ndaaluee chjoo tsꞌo̱ndaa Galilea. ");
INSERT INTO amuNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ndoꞌ tquioñꞌom nnꞌaⁿ cwii tsꞌaⁿ na cantaaꞌ ndoꞌ cancheeꞌñe. Lꞌana tyꞌoo nnom Jesús na catioom tsꞌo̱o̱ⁿ nacjooꞌ tsaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Quia joꞌ tjeiꞌño̱o̱ⁿ tsaⁿꞌñeeⁿ quiiꞌntaaⁿ naⁿꞌñeeⁿ, tyꞌena yuu na ñeꞌwendyena. Tjaaꞌñê nda̱a̱lꞌo̱o̱ⁿ nꞌom luaꞌqui tsaⁿꞌñeeⁿ, seicanaⁿꞌaⁿ nomtsꞌo̱o̱ⁿ ñꞌeⁿ ndaajnaaⁿꞌaⁿ, quia joꞌ tyenquioomꞌm nomtsaa tsaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jnda̱ joꞌ ntyꞌiaaⁿꞌaⁿ cañoomꞌluee, ndoꞌ tcom tsꞌoom na jnda ntyjeeⁿ, tsoom: —Efata. (Ñꞌoomwaaꞌ matsonaꞌ: Catseicanaaⁿñenaꞌ.) ");
INSERT INTO amuNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Mantyja jnaaⁿ nꞌom luaꞌqui tsaⁿꞌñeeⁿ ndoꞌ mati xꞌee tsaa. Ndoꞌ mana jnaⁿnaꞌ na ya matseineiiⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Quia joꞌ seicuꞌ Jesús ndyuee naⁿꞌñeeⁿ na ticaluena nnom meiⁿcwii tsꞌaⁿ cantyja na tuii. Sa̱a̱ meiiⁿ na ñenquiiꞌcheⁿ tyotsoom nda̱a̱na na ticaluena, joona yacheⁿ jndyeti tyolaꞌneiⁿna nda̱a̱ ncꞌiaana. ");
INSERT INTO amuNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ndoꞌ jeeⁿ tjaweeꞌ nꞌom naⁿꞌñeeⁿ, tyolaꞌneiⁿna, tyoluena: —Jesús jeeⁿ ya machꞌeeⁿ ee nnꞌaⁿ na cantaa, machꞌeeⁿ na ya cwindyena. Ndoꞌ nnꞌaⁿ na tileicalaꞌneiⁿ machꞌeeⁿ na ya cwilaneiⁿna. ");
INSERT INTO amuNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Joo ncueeꞌñeeⁿ tjomndyenndaꞌ cwii tmaaⁿꞌ nnꞌaⁿ na jndyendye. Ndoꞌ tjaaꞌnaⁿ na cwileiñꞌom naⁿꞌñeeⁿ na nlcwaꞌna. Joꞌ chii tꞌmaⁿ Jesús nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê, tsoom nda̱a̱na: ");
INSERT INTO amuNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Wiꞌ tsꞌo̱o̱ⁿya tmaaⁿꞌ nnꞌaⁿmꞌaⁿꞌ, ee jeꞌ jnda̱ ndyee xuee na mꞌaⁿna ñꞌeⁿndyo̱ ndoꞌ tatjaaꞌnaⁿ ljoꞌ cwii cwileiñꞌomna na nlcwaꞌna. ");
INSERT INTO amuNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ndoꞌ xeⁿ njño̱o̱ⁿya joona na cꞌoolcweeꞌna lꞌaana na ñeꞌjndoꞌna, quia joꞌ nato mꞌaⁿna nntycwii na jndeiiꞌ nꞌomna ee ñꞌeeⁿ ntꞌomndye joona na tquia jnaⁿna. ");
INSERT INTO amuNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Quia joꞌ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê jluena nnoom: —Tjaaꞌnaⁿ chiuu ya na nntsꞌaa tsꞌaⁿ na nñequiaaⁿ na nlcwaꞌ naⁿmꞌaⁿꞌ na jndyendyena, ee ljoo na mꞌaaⁿya jo jnda̱a̱. ");
INSERT INTO amuNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Taxꞌeeñê nda̱a̱na: —¿Cwanti tyooꞌ cwileiꞌñꞌomꞌyoꞌ? Tꞌo̱o̱na, jluena: —Ntquieeꞌ taⁿꞌ tyooꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Quia joꞌ sa̱ꞌntjoom na cꞌoocwindyuaandye nnꞌaⁿ nomtyuaa. Toꞌñoom ntquieeꞌ taⁿꞌ tyooꞌñeeⁿ, tquiaaⁿ na quianlꞌuaaꞌ Tyꞌo̱o̱tsꞌom, jnda̱ joꞌ tyjeeⁿ joonaꞌ. Tquiaaⁿ joonaꞌ nda̱a̱ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê ndoꞌ joona tquiana joonaꞌ nda̱a̱ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Mati cwileiñꞌomna cwantindyo calcaa nchꞌu. Jnda̱ na tquiaaⁿ na quianlꞌuaaꞌ Tyꞌo̱o̱tsꞌom, tsoom na quiana jooyoꞌ nda̱a̱ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ndoꞌ chaꞌtsondye naⁿꞌñeeⁿ tcwaꞌ tjacjoona. Tooꞌ ntquieeꞌ tsquiee na jlaꞌtjomna ntaⁿꞌ ntyooꞌ ñequio ntaⁿꞌ calcaa na ꞌndiinaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ndoꞌ joo nnꞌaⁿ na tcwaꞌ joꞌ tueeꞌ chaꞌna ñequiee meiⁿ joona. Quia joꞌ tꞌmaⁿ Jesús naⁿꞌñeeⁿ na cꞌootona. ");
INSERT INTO amuNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Jnda̱ chii tuo̱o̱ⁿ tsꞌom wꞌaandaa ñꞌeⁿ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê. Tyꞌena ndyuaa Dalmanuta. ");
INSERT INTO amuNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Tquieꞌcañom nnꞌaⁿ fariseos na mꞌaaⁿ Jesús, to̱ꞌna na cwilaꞌncjooꞌndyena ñꞌeⁿñê. Ndoꞌ cha na nlqueⁿna xjeⁿ jom, taⁿna na caꞌmo̱o̱ⁿ nda̱a̱na cwii ꞌnaaⁿ na nnaⁿnaꞌ na mꞌaaⁿ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesús jeeⁿ tcom tsꞌoom na chjooꞌ tsꞌoom, tsoom: —Naⁿmꞌaⁿꞌ cwitaⁿna cwii ꞌnaaⁿ na nntyꞌiaana na nnaⁿnaꞌ cañoomꞌluee. Ñꞌoom na mayuuꞌcheⁿ matsjo̱o̱ nda̱a̱ꞌyoꞌ, maxjeⁿ xonquia na nntyꞌiaana meiⁿcwii ꞌnaaⁿ meiiⁿ na cwitaⁿna. ");
INSERT INTO amuNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Quia joꞌ tjaaⁿ. ꞌÑeeⁿ naⁿꞌñeeⁿ. Tuo̱nnaaⁿꞌaⁿ tsꞌom wꞌaandaa, teixndyaañê cwiicheⁿ nantyja ñequio nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ndoꞌ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿ Jesús ñecwii taⁿꞌ tyooꞌ cwileiñꞌomtina tsꞌom wꞌaandaa ee tsuuꞌ nꞌomna na nncꞌooñꞌomna na nlcwaꞌna. ");
INSERT INTO amuNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Quia joꞌ seijno̱o̱ⁿꞌo̱ⁿ nꞌomna na ticjaañꞌoomnaꞌ joona cantyja ꞌnaaⁿ ñꞌoom na cwitꞌmo̱o̱ⁿ nnꞌaⁿ fariseos. Ndoꞌ seijoomꞌñê ñꞌoomꞌñeeⁿ ñequio ndaaljoꞌ na cwiluii tyooꞌ. Tsoom nda̱a̱na: —Cꞌomꞌcꞌeendyoꞌ na calꞌaꞌyoꞌ cwenta cantyja ꞌnaaⁿꞌ tyooꞌ ꞌnaaⁿ nnꞌaⁿ fariseos ñequio Herodes ee ndaaljoꞌ ꞌnaaⁿna tisꞌa laxmaⁿnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Quia joꞌ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿ Jesús to̱ꞌna na cwilaneiⁿna nda̱a̱ ncꞌiaana cantyja ꞌnaaⁿꞌ ñꞌoomwaaꞌ. Jluena: —Luaaꞌ matsoom cweꞌ ee tjaaꞌnaⁿ tyooꞌ tquiocho̱o̱ya. ");
INSERT INTO amuNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Seiꞌno̱ⁿꞌ Jesús na ljoꞌ cwilaꞌtiuuna. Tsoom nda̱a̱na: —¿Chiuu na jeeⁿ matseiñꞌeeⁿꞌñenaꞌ ꞌo cweꞌ jnaaⁿꞌ na tjaaꞌnaⁿ tyooꞌ tquiochoꞌyoꞌ? ¿Aa maxjeⁿ ndicwaⁿ ticalaꞌno̱ⁿꞌyoꞌ ndoꞌ na tileicjo̱ ñꞌoom naquiiꞌ nꞌomꞌyoꞌ? ¿Aa maxjeⁿ tileiqueⁿꞌyoꞌ cwenta? ");
INSERT INTO amuNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ꞌO na niom nꞌomnda̱a̱ꞌyoꞌ, ¿aa maxjeⁿ ticajndoꞌyoꞌ? Ndoꞌ ꞌo na niom lueꞌ nꞌom luaꞌquiꞌyoꞌ, ¿aa maxjeⁿ ticandyeꞌyoꞌ? ¿Aa tacjaanjoomꞌ nꞌomꞌyoꞌ ljoꞌ sꞌaaya quia na seitjo̱o̱naꞌ na nlcwaꞌ nnꞌaⁿ? ");
INSERT INTO amuNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Quia na tyja̱ya ꞌom taⁿꞌ tyooꞌ na tcwaꞌ ꞌom meiⁿ nnꞌaⁿ, ¿cwanti lquiee na ñjom tyooꞌ ꞌndiinaꞌ na jlaꞌweꞌyoꞌ? Tꞌo̱o̱na, jluena nnoom: —Canchooꞌwe lquiee ꞌndiinaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Ndoꞌ cwiicheⁿ cwii ndiiꞌ quia na tyja̱ya ntquieeꞌ taⁿꞌ tyooꞌ na tcwaꞌ ñequiee meiⁿ nnꞌaⁿ, ¿cwanti lquiee na ꞌndiinaꞌ? Joona tꞌo̱o̱na nnoom, jluena: —Ntquieeꞌ ꞌndiinaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Quia joꞌ matsoom nda̱a̱na: —¿Aa maxjeⁿ hasta jeꞌ ticalaꞌno̱ⁿꞌyoꞌ? ");
INSERT INTO amuNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Quia na jnda̱ tquiena tsjoom Betsaida tquioñꞌom nnꞌaⁿ cwii tsaⁿnchjaaⁿꞌ na mꞌaaⁿ Jesús. Tyolꞌana tyꞌoo na catioyaaⁿ tsꞌo̱o̱ⁿ nacjooꞌ tsaⁿꞌñeeⁿ na catseinꞌmaaⁿ juu. ");
INSERT INTO amuNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Quia joꞌ tꞌueeⁿ tsꞌo̱ tsaⁿnchjaaⁿꞌ. Tjañꞌoom juu nnom tsjoom. Tyꞌoomñê ndaajnaaⁿꞌaⁿ luaꞌnnom ndoꞌ tyenquioomꞌm luaꞌnnom tsaⁿꞌñeeⁿ, jnda̱ chii taxꞌeeⁿ nnom, tsoom: —¿Aa waa ljoꞌ mantyꞌiaꞌ? ");
INSERT INTO amuNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Seinꞌmeiiⁿꞌ tsaⁿnchjaaⁿꞌñeeⁿ luaꞌnnoom, tsoom: —Mantyꞌia nnꞌaⁿ ndooꞌ ntyjii chaꞌcwijom nꞌoom joona, sa̱a̱ cwiꞌoocaꞌna. ");
INSERT INTO amuNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Cwiicheⁿ cwii ndiiꞌ tionndaꞌ Jesús lꞌo̱o̱ⁿ cjooꞌ luaꞌnnom tsaⁿꞌñeeⁿ. Quia joꞌ nquiee ntyꞌiaaꞌ tsaⁿnchjaaⁿꞌ ndoꞌ mana nꞌmaaⁿ, xueeya ntyꞌiaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jnda̱ chii jñom Jesús jom. Tso nnoom: —Cjaꞌtoꞌ, cjaꞌndyeꞌyuꞌ waꞌ. Ticwinoomꞌ quiiꞌ tsjoom, meiⁿ tintsuꞌ nnom meiⁿcwii tsꞌaⁿ chiuu tuii. ");
INSERT INTO amuNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jnda̱ chii jluiꞌ Jesús tsjoom Betsaida ñequio nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê. Tyꞌena njoom nchꞌu ndyuaa tsjoom Cesarea Filipo. Ndoꞌ xcwe na ñjomndyena nato, taxꞌeeⁿ nda̱a̱na, tsoom: —¿ꞌÑeeⁿ cwilue nnꞌaⁿ na cwiluiindyo̱? ");
INSERT INTO amuNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Naⁿꞌñeeⁿ tꞌo̱o̱na, jluena: —Ntꞌom nnꞌaⁿ cwilue na ꞌu Juan, tsꞌaⁿ na tyotseitsꞌoomñe nnꞌaⁿ. Ndoꞌ ntꞌomcheⁿ cwilue Elías ꞌu. Sa̱a̱ ntꞌomcheⁿ cwilue na ꞌu cwii profeta na jnda̱ wandoꞌxcoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Quia joꞌ taxꞌeennaaⁿꞌaⁿ ndyueena, tsoom: —Ndoꞌ ꞌo jeꞌ, ¿ꞌñeeⁿ juu cwinduꞌyoꞌ na cwiluiindyo̱? Tꞌo̱ Pedro, tso: —ꞌU maxjeⁿ nquii Cristo cwiluiindyuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesús ñecwii ñꞌoom sa̱ꞌntjoom na ticaluena nnom meiⁿcwii tsꞌaⁿ na cwiluiiñê na ljoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Quia joꞌ to̱o̱ⁿꞌo̱ⁿ na tyoꞌmo̱o̱ⁿ nda̱a̱na cantyja ꞌnaaⁿꞌ nqueⁿ na cwiluiiñê tsꞌaⁿ na jnaⁿ cañoomꞌluee. Tsoom jndye nawiꞌ tseixmaaⁿ na catjoom. Ndoꞌ tyoꞌmo̱o̱ⁿ na xocatoꞌñoom nnꞌaⁿ judíos na cwiluiitquiendye jom, meiⁿ ntyee na cwiluiitquiendye, meiⁿ nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés. Maxjeⁿ nlaꞌcueeꞌna jom sa̱a̱ xuee jnda̱ ndyee, nncwandoꞌnnaaⁿꞌaⁿ na nncueeⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ndyeyu seineiiⁿ ñꞌoommeiⁿꞌ nda̱a̱na. Ndoꞌ Pedro tjañꞌoom Jesús cwii ntyja. To̱o̱ⁿꞌo̱ⁿ na matseitiaaⁿꞌaⁿ juu na nmeiⁿꞌ matso na nluii. ");
INSERT INTO amuNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Teiqueⁿ Jesús, ntyꞌiaaⁿꞌaⁿ nda̱a̱ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê. Seitiaaⁿꞌaⁿ Pedro, tsoom: —Quindyo̱o̱ꞌ nacañomya ꞌu na matseijomndyuꞌ ñꞌeⁿ Satanás. Ee ñꞌoom na matseiꞌtiuuꞌ jnaⁿnaꞌ cweꞌ cantyja na cwilaꞌtiuu nnꞌaⁿ, nchii cantyja na lꞌue tsꞌom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Quia joꞌ tꞌmaaⁿ cwii tmaaⁿꞌ nnꞌaⁿ yuu na mꞌaaⁿ ñequio nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê. Tsoom nda̱a̱na: —Meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na lꞌue tsꞌom na nncwꞌaaꞌñe ja, cwjiꞌñê cantyja na matseitiuu nqueⁿ. Caljoya tsꞌoom nawiꞌ na matjoom, meiiⁿ cueeⁿꞌeⁿ. Ndoꞌ candyontyjo̱o̱ⁿ cantyja na matsꞌaa. ");
INSERT INTO amuNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ee meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na mañequiaaⁿñe na catjom ljoꞌ na nntjom ee na mꞌaaⁿ cantyja ꞌnaⁿya ñequio ñꞌoom naya, juu tsaⁿꞌñeeⁿ nluiꞌnꞌmaaⁿñê. Ndoꞌ meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na malꞌueeꞌñe cheⁿnquii chiuu nluiꞌnꞌmaaⁿñe, majoꞌto joꞌ nntsuuñe. ");
INSERT INTO amuNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Meiiⁿ chaꞌwaa tsjoomnancue cuaanaꞌ cwentaaꞌ tsꞌaⁿ, sa̱a̱ ¿yuu waa na mateijndeiinaꞌ juu ee xocꞌo̱naꞌ ñꞌeⁿñê na ticatsuuñe añmaaⁿꞌaⁿ? ");
INSERT INTO amuNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Aa nnda̱a̱ nntsꞌaa tsꞌaⁿ na nnjomlꞌua na nluiꞌnꞌmaaⁿñe añmaaⁿꞌaⁿ? Cwaaⁿ nnda̱a̱. ");
INSERT INTO amuNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Tiempo jeꞌ laxmaⁿ nnꞌaⁿ na ticalaꞌyuꞌya nꞌomna ñꞌeⁿ Tyꞌo̱o̱tsꞌom ndoꞌ laꞌxmaⁿna jnaⁿ, xeⁿ jnaaⁿna ja ñequio ñꞌoom naya na mañequia, mati ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee, quia na nndyo̱nndaꞌa ñequio na matseitꞌmaaⁿꞌñenaꞌ Tsotya̱ ñequio ángeles na ljuꞌ nꞌom, nncꞌo̱o̱ⁿ na jnaaⁿꞌa naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Mati tso Jesús nda̱a̱na: —Mayuuꞌcheⁿ nndyeꞌyoꞌ nntsjo̱o̱, mꞌaⁿ nnꞌaⁿ ñjaaⁿ na xocwjena hasta xeⁿ jnda̱ ntyꞌiaanda̱a̱na na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom ñequio chaꞌtso najnda̱ na matseixmaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Jnda̱ na teinom yom xuee, tjañꞌoom Jesús Pedro ñꞌeⁿ Jacobo ñꞌeⁿ Juan. Tyꞌena cwii sjo̱ nandye yuu na ñenquieena. Ndoꞌ joꞌ joꞌ seichuiiꞌnaꞌ jom jo nda̱a̱na. ");
INSERT INTO amuNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Sꞌaanaꞌ na caxuee liaⁿꞌaⁿ, canchiiꞌtinaꞌ chaꞌna tsaaⁿ. Meiⁿ tjaaꞌnaⁿ cwii tsꞌaⁿ na nnda̱a̱ mmaⁿ cwii liaa na nleicanchiiꞌti juunaꞌ chaꞌna liaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ndoꞌ xjeⁿꞌñeeⁿ teitquiooꞌñe Elías ñꞌeⁿ Moisés na cwilaꞌneiⁿna ñꞌeⁿ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Quia joꞌ tso Pedro nnom Jesús: —Jeeⁿ ndyaꞌ ya na mꞌaaⁿya ñjaaⁿ. Cwa, nlꞌaayâ ndyee xquieꞌ ncwaⁿꞌ. Cwii cwentaꞌ nncuꞌ, cwii cwentaaꞌ Moisés, ndoꞌ cwii cwentaaꞌ Elías. ");
INSERT INTO amuNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ñꞌoommeiⁿꞌ tsoyom cweꞌ ncꞌe na seiñꞌeeⁿꞌñꞌeⁿnaꞌ jom ee na jeeⁿ ndyaꞌ cwicatyuena. ");
INSERT INTO amuNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Quia joꞌ jndyocue cwii nchquiu na seincwaaⁿꞌñenaꞌ nacjoona. Ndoꞌ teicꞌuaa na seineiⁿ Tyꞌo̱o̱tsꞌom naquiiꞌ nchquiuꞌñeeⁿ, tsoom: —Luaañe Jndaaya na jeeⁿ candyaꞌ tsꞌo̱o̱ⁿya. Candyeꞌyoꞌ ñꞌoom na matseineiiⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Matsꞌiaa joꞌ quia jleityꞌiomnda̱a̱na, jliuna cwa tacꞌoomñe Elías ñꞌeⁿ Moisés ñꞌeⁿndyena. Macanda̱ ñenquii Jesús cwimꞌaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Yocheⁿ na cwinquiocuena sjo̱ꞌñeeⁿ, sa̱ꞌntjom Jesús na meiⁿcwii ñꞌoom ticaluena nda̱a̱ nnꞌaⁿ chiuu waa na ntyꞌiaana na seichuiiꞌnaꞌ jom. Ñequiiꞌcheⁿ na nlaꞌneiⁿna ñꞌoomwaaꞌ quia jnda̱ mawandoꞌxcoom xeⁿ jnda̱ jlaꞌcueeꞌ nnꞌaⁿ jom. ");
INSERT INTO amuNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ndoꞌ tyolaꞌwena ñꞌoomꞌñeeⁿ ñequio na jeeⁿ xcweeꞌ nꞌomna. Tyotaꞌxꞌeendye cheⁿnquieena nda̱a̱na ljoꞌ ñecatso ñꞌoom na tsoom na quia nncwandoꞌxcoom na nncueeⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Quia joꞌ jluena nnoom: —Nquiee nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés cwilue macaⁿnaꞌ na Elías nndyojñeeⁿ. —¿Chiuu na luaaꞌ cwilue naⁿꞌñeeⁿ? ");
INSERT INTO amuNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ndoꞌ tꞌo̱ Jesús nda̱a̱na tsoom: —Mayuuꞌ na ncwjeeꞌjndyee Elías na nntseijndaaꞌñê chaꞌtso. Sa̱a̱ ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee, ¿chiuu waa na matso ljeii ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom cantyja ꞌnaⁿya? Matsonaꞌ na jndye nawiꞌ catjo̱ⁿ ndoꞌ nncꞌom nnꞌaⁿ na ticueeꞌ nꞌomna ja. ");
INSERT INTO amuNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Sa̱a̱ matsjo̱o̱ nda̱a̱ꞌyoꞌ na nquii na cwiluiiñe Elías, jnda̱ tyjeeⁿꞌeⁿ, ndoꞌ tyolꞌa nnꞌaⁿ chaꞌxjeⁿ na lꞌue nꞌomna ñꞌeⁿñê ee luaaꞌ matso ljeii ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom na tseixmaaⁿ na catjoom. ");
INSERT INTO amuNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jnda̱ na tquienndaꞌna yuu ljooꞌndye ntꞌomcheⁿ ncꞌiaana, quia joꞌ ntyꞌiaana na jnda̱ tquieꞌcañom cwii tmaaⁿꞌ nnꞌaⁿ na jndyendye nacañoom naⁿꞌñeeⁿ. Ñꞌeeⁿ nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés, na cwilaꞌñꞌeeⁿꞌ ndyueena ñꞌeⁿ naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ndoꞌ nnꞌaⁿ tmaaⁿꞌñeeⁿ quia na ntyꞌiaana jom, tꞌomna na jeeⁿ tjaweeꞌ nꞌomna. Jlaꞌtyuaaꞌna, tyꞌecatjomndyena jom. Tquiana na xmaⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Quia joꞌ taxꞌeeⁿ nda̱a̱na, tsoom: —¿Ljoꞌ ñꞌoom na jeeⁿ cwilañꞌeeⁿꞌ ndyueeꞌyoꞌ? ");
INSERT INTO amuNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Cwii tsꞌaⁿ na mꞌaaⁿ naquiiꞌ tmaaⁿꞌ naⁿꞌñeeⁿ, tꞌo̱o̱ⁿ. Tsoom: —Maestro, jndyo̱ñꞌo̱ⁿya tiꞌjndaaya ñjaaⁿ, ee maleiñꞌoom jndyetia jom ndoꞌ machꞌee na tileicatseineiiⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Ndoꞌ meiⁿyuucheⁿ na mꞌaaⁿñê quia jnda̱ jnaⁿnaꞌ maxjeⁿ matseiquioo jndyetia jom nomtyuaa. Cwiluiꞌ chomꞌ ꞌñom, mati manqueeⁿ ndeiꞌnꞌoom, ndoꞌ cwileiquiiñê. Maꞌndiinaꞌ jom na tajneiⁿ. Ndoꞌ jnda̱ sꞌaa tyꞌoo nda̱a̱ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿndyuꞌ na catjeiiꞌna jndyetiaꞌñeeⁿ, sa̱a̱ tîcanda̱a̱ lꞌana. ");
INSERT INTO amuNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Quia joꞌ tso Jesús: —ꞌO nnꞌaⁿ na ticalaꞌyuꞌyaꞌ nꞌomꞌyoꞌ ñꞌeⁿ Tyꞌo̱o̱tsꞌom, ¿cwanti yo macaⁿnaꞌ na cwii nljooꞌndyo̱ ñꞌeⁿndyoꞌ na mꞌmo̱o̱ⁿtya̱ nda̱a̱ꞌyoꞌ? ¿Cwanti xuee cwii nnda̱a̱ nntseiquii tsꞌo̱o̱ⁿya ñꞌeⁿndyoꞌ? Quioꞌñꞌomꞌyoꞌ tyochjoomꞌaaⁿꞌ ñjaaⁿñe. ");
INSERT INTO amuNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Quia joꞌ tquioñꞌomna tyochjoo na mꞌaaⁿ Jesús. Ndoꞌ quia ntyꞌiaaꞌ jndyetia Jesús, sꞌaanaꞌ na tyocoñoomñenaꞌ tyochjooꞌñeeⁿ. Tiooñê nomtyuaa, tyotseicantyeeⁿñê ndoꞌ tyocaluiꞌ chomꞌ ꞌñom. ");
INSERT INTO amuNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Taꞌxꞌee Jesús nnom tsotye tyochjoo, tsoom: —¿Cwanti xuee na luaaꞌ matjoom? Tꞌo̱ tsotyeeⁿ, tso: —Xjeⁿ na cachjooñêcheⁿ jnaⁿnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ndoꞌ teijndye ndiiꞌ matseiquioonaꞌ jom quiiꞌ chom ndoꞌ quiiꞌ ndaa, cha cueeⁿꞌeⁿ. Joꞌ chii cꞌoomꞌ na wiꞌ tsꞌomꞌ ñꞌeⁿndyô̱ xeⁿ waa na nnda̱a̱ nntsaꞌ, cateijndeiꞌ jâ. ");
INSERT INTO amuNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Tso Jesús nnom: —Matsuꞌ xeⁿ nnda̱a̱ ntsꞌaa. Chaꞌtso nnda̱a̱ nluii quia na matseiyuꞌ tsꞌaⁿ ñꞌeⁿ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Quia joꞌ jndeii seineiⁿ tsotye tyochjoo, tso: —Ja matseiyuꞌa. Cateijndeiꞌ ja na nntseiyuꞌyatya̱. ");
INSERT INTO amuNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Quia na ntyꞌiaaꞌ Jesús na ntyjantyja jaawijndyendye nnꞌaⁿ nacañomꞌm, quia joꞌ seitiaaⁿꞌaⁿ jndyetiaꞌñeeⁿ, tsoom: —ꞌU jndyetia na macheꞌ na cantaa nnꞌaⁿ ndoꞌ na tileicalaꞌneiⁿna, matsa̱ꞌntjo̱ⁿ na caluiꞌ ndoꞌ tajom nncjaꞌquieꞌnndaꞌ naquiiꞌ tsꞌom tyochjoomꞌaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Quia joꞌ jndeii seixuaa jndyetia. Sꞌaaⁿ na jeeⁿ tyocoꞌñoomñenaꞌ tyochjoo, mana jlueeⁿꞌeⁿ. ꞌNdiinaꞌ juu chaꞌcwijom tsꞌoo. Joꞌ chii majndyeti nnꞌaⁿ jluena na jnda̱ tueꞌ tyochjoo. ");
INSERT INTO amuNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Sa̱a̱ Jesús tꞌueeⁿ tsꞌo̱ tyochjooꞌñeeⁿ, seiweeⁿ juu. Mañoomꞌ teintyjeeꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jnda̱ joꞌ tjaquieeꞌ Jesús quiiꞌ wꞌaa. Tjuꞌnaꞌ na ñenqueⁿ ñꞌeⁿ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê. Ndoꞌ taꞌxꞌeena ñꞌoomꞌñeeⁿ ꞌñom, jluena: —¿Chiuu waayuu na jâ tîcanda̱a̱ nntjeiiꞌâ jndyetiamꞌaaⁿꞌ? ");
INSERT INTO amuNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Quia joꞌ tsoom nda̱a̱na: —Chaꞌna jndyetiamꞌaⁿꞌ, tjaaꞌnaⁿ ꞌneeⁿ nnda̱a̱ nncwjiꞌ joona xeⁿ nchii na nntseineiⁿ tsꞌaⁿ nnom Tyꞌo̱o̱tsꞌom ndoꞌ na nntseicwejndoꞌñe. ");
INSERT INTO amuNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Jnda̱ na jluiꞌ Jesús joꞌ joꞌ ñꞌeⁿ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê, tyꞌena, teinomna tsꞌo̱ndaa Galilea. Sa̱a̱ ticalꞌue tsꞌoom na nliu nnꞌaⁿ na joꞌ wjaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ee maꞌmo̱o̱ⁿ chiuu waa na nntjoom na cwiluiiñê tsꞌaⁿ na jnaⁿ cañoomꞌluee na nñequiaa tsꞌaⁿ cwenta jom luee nnꞌaⁿ ndoꞌ nlaꞌcueeꞌ jom sa̱a̱ xeⁿ jnda̱ ndyee xuee na tueeⁿꞌeⁿ maxjeⁿ nncwandoꞌxcoom. ");
INSERT INTO amuNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Sa̱a̱ joona ticalaꞌno̱ⁿꞌna ñꞌoom na tsoom ndoꞌ nquiaana na nntaꞌxꞌeena nnoom ljoꞌ ñeꞌcaꞌmo̱ⁿnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Tquiena Capernaum. Ndoꞌ quia na jnda̱ mamꞌaⁿna quiiꞌ wꞌaa, quia joꞌ taxꞌeeⁿ nda̱a̱na, tsoom: —¿Cwaaⁿ ñꞌoom ñejlaꞌncjooꞌndyoꞌ nda̱a̱ ntyjeeꞌyoꞌ xjeⁿ na ñetquio̱o̱ya nato? ");
INSERT INTO amuNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Sa̱a̱ joona yacheⁿ jlaꞌcheⁿna, ee mayuuꞌ xjeⁿ na ñeñjomndyena nato tyolaꞌncjooꞌndyena ꞌñeeⁿ cwii joona tꞌmaⁿti cwiluiiñe. ");
INSERT INTO amuNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jnda̱ na tjacjoo Jesús, tqueeⁿꞌñê canchooꞌwendye joona na cꞌoontyjaaꞌtina. Tsoom nda̱a̱na: —ꞌÑeeⁿ juu tsꞌaⁿ na maqueⁿ tsꞌom na nlcoꞌnnomnaꞌ juu jo nda̱a̱ꞌyoꞌ, tsaⁿꞌñeeⁿ matsonaꞌ na cjuꞌñecjeeⁿ ndoꞌ candiꞌntjoom nda̱a̱ chaꞌtso ncꞌiaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Quia joꞌ tꞌueeⁿ cwii tyochjoo, tcoomꞌm juu xcwe quiiꞌntaaⁿna. Jnda̱ chii tyꞌoom juu ndoꞌ tsoom nda̱a̱na: ");
INSERT INTO amuNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na macoꞌñom cwii yucachjoo ñequio xueya chaꞌna yucachjoomꞌaaⁿ, ja macoꞌñom tsaⁿꞌñeeⁿ. Ndoꞌ tsꞌaⁿ na macoꞌñom ja, nchii macanda̱ ñennco̱ macoꞌñom. Mati macoꞌñom nqueⁿ na jñoom ja. ");
INSERT INTO amuNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Tso Juan nnom Jesús: —Maestro, ntyꞌiaayâ cwii tsꞌaⁿ na macwjiꞌ jndyetia naquiiꞌ nꞌom nnꞌaⁿ ñequio xueꞌ. Juu tsaⁿꞌñeeⁿ tyootseijomñê ñꞌeⁿndyo̱ jaa. Joꞌ chii jlaꞌtsaaⁿꞌndyô̱ jom. ");
INSERT INTO amuNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Sa̱a̱ tso Jesús nda̱a̱na: —Talaꞌtsaaⁿꞌndyoꞌ jom ee meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na machꞌee tsꞌiaaⁿ tꞌmaⁿ ñequio xueya, xocatsꞌaanaꞌ na nda̱nquia nntso cwii ñꞌoom wiꞌ nacjoya. ");
INSERT INTO amuNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ee tsꞌaⁿ na ticꞌoom nacjoya, cwiluiiñe tsꞌaⁿ na mꞌaaⁿ cantyja ꞌnaⁿya. ");
INSERT INTO amuNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ndoꞌ meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na nñequiaa meiⁿ ñechjoowiꞌ ndaatioo na nncweꞌyoꞌ ncꞌe na cwilaxmaⁿꞌyoꞌ cantyja ꞌnaⁿ nnco̱ na cwiluiindyo̱ Cristo, mayuuꞌcheⁿ waa naya ꞌnaaⁿꞌ tsaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","’Meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na ntsꞌaa na catseitjo̱o̱ñe cwii tsꞌaⁿ na cachjoo matseiyuꞌ ñꞌeⁿndyo̱, juu tsaⁿꞌñeeⁿ yati xeⁿ cwityeⁿ cwii tsjo̱ꞌsuu xtyoomꞌm, ndoꞌ catueeꞌ nnꞌaⁿ jom tsꞌom ndaaluee. ");
INSERT INTO amuNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Xeⁿ na wjaañꞌoomnaꞌ ꞌu na matseiꞌtjo̱o̱ndyuꞌ nnom Tyꞌo̱o̱tsꞌom jnaaⁿꞌ cwii tsꞌo̱ꞌ, catsaꞌ xjeⁿ juunaꞌ chaꞌcwijom na catyjeeꞌ juunaꞌ cha tintseiꞌtjo̱o̱ndyuꞌtiꞌ. Ee yati nntseixmaⁿꞌ na ticantycwii na nncwandoꞌ meiiⁿ chaꞌcwijom na ticanda̱a̱ꞌ we tsꞌo̱ꞌ nchiiti na canda̱a̱ꞌndyuꞌ ndoꞌ nncjuꞌnaꞌ ꞌu quiiꞌ bꞌio yuu na tijoom canduuꞌ chom. ");
INSERT INTO amuNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Yuu tijoom cwje canti meiⁿ na nnduuꞌ chom. ");
INSERT INTO amuNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ndoꞌ xeⁿ wjaañꞌoomnaꞌ ꞌu na matseiꞌtjo̱o̱ndyuꞌ nnom Tyꞌo̱o̱tsꞌom jnaaⁿꞌ cwii xꞌeꞌ, catsaꞌ xjeⁿ chaꞌcwijom na catyjeeꞌ juunaꞌ cha tintseiꞌtjo̱o̱ndyuꞌtiꞌ. Ee yati nntseixmaⁿꞌ na ticantycwii na nncwandoꞌ meiiⁿ chaꞌcwijom ticanda̱a̱ꞌ we ncꞌeꞌ nchiiti na canda̱a̱ꞌndyuꞌ ndoꞌ nncjuꞌnaꞌ ꞌu quiiꞌ bꞌio yuu na tijoom canduuꞌ chom. ");
INSERT INTO amuNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ndoꞌ tijoom cwje canti meiⁿ na nnduuꞌ chom. ");
INSERT INTO amuNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ndoꞌ xeⁿ cweꞌ cantyja na mantyꞌiaꞌ wjaañꞌoomnaꞌ ꞌu na matseiꞌtjo̱o̱ndyuꞌ nnom Tyꞌo̱o̱tsꞌom, catsaꞌ xjeⁿ chaꞌcwijom na cwjiꞌ tsꞌomnjomꞌ cha tintseiꞌtjo̱o̱ndyuꞌtiꞌ. Ee yati na nncjaꞌquieꞌ cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom meiiⁿ chaꞌcwijom na nchjaⁿꞌ nchiiti na canda̱a̱ꞌ we nꞌomnjomꞌ ndoꞌ nncjuꞌnaꞌ ꞌu quiiꞌ bꞌio ");
INSERT INTO amuNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","yuu na tijoom cwje canti ndoꞌ meiⁿ na nnduuꞌ chom. ");
INSERT INTO amuNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","’Ee ticwii cwii tsꞌaⁿ nleichjeⁿꞌñê ñequio chom. Cwilaꞌchjeⁿꞌ nnꞌaⁿ seii quiooꞌ na cwiñeꞌquiana na cwilaꞌtꞌmaaⁿꞌndyena Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Jeeⁿ lꞌue tsjaaⁿꞌ sa̱a̱ xeⁿ jnda̱ jluiꞌ na chjeⁿꞌnaꞌ, tjaa yuu cwii nlꞌue juunaꞌ. Joꞌ chii ꞌo cꞌomꞌyoꞌ chaꞌna tsjaaⁿꞌ na xocaluiꞌ na chjeⁿꞌnaꞌ quia joꞌ ñenquiiꞌcheⁿ nleilꞌuendyoꞌ quiiꞌntaaⁿ ncꞌiaꞌyoꞌ ndoꞌ tjoomꞌ ñꞌoom nncꞌomꞌyoꞌ ñꞌeⁿndyena. ");
INSERT INTO amuNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Cwiicheⁿ cwii ndiiꞌ jnaⁿ Jesús Capernaum, tjaaⁿ, tueⁿꞌeⁿ tsꞌo̱ndaa Judea. Teinoom cwiicheⁿ nantyjaaꞌ jndaa Jordán. Tjomndyenndaꞌ cwii tmaaⁿꞌ nnꞌaⁿ yuu na mꞌaaⁿ. Quia joꞌ tꞌmo̱o̱ⁿ nda̱a̱na chaꞌxjeⁿ na quichꞌeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Majuu xjeⁿꞌñeeⁿ tquieꞌcañom nnꞌaⁿ fariseos na mꞌaaⁿ na ñeꞌcalꞌana xjeⁿ jom. Taꞌxꞌeena nnoom: —¿Aa matsa̱ꞌntjomnaꞌ na tsaⁿsꞌa nntseityueeⁿꞌeⁿ ljeii na tocoom ñꞌeⁿ scoomꞌm? ");
INSERT INTO amuNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jom tꞌo̱o̱ⁿ, tsoom nda̱a̱na: —Juu ñꞌoom na tqueⁿ Moisés, ¿ljoꞌ matsonaꞌ na calꞌaꞌyoꞌ? ");
INSERT INTO amuNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Quia joꞌ jluena: —Moisés tquiaaⁿ na wanaaⁿ na nntyuiiꞌ ljeii na toco tsaⁿsꞌa ñequio scoomꞌm. Ndoꞌ tsaⁿscu nncoꞌñoom cwiicheⁿ ljeii na matsonaꞌ na macanda̱ cwito̱ⁿꞌndyena ñꞌeⁿ saaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Tꞌo̱ Jesús nda̱a̱na, tsoom: —Cweꞌ ee na ꞌo jeeⁿ quieꞌ nꞌomꞌyoꞌ, joꞌ na seiljeii Moisés ñꞌoomwaaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Sa̱a̱ cantyjati xuee na to̱ꞌ Tyꞌo̱o̱tsꞌom na tqueeⁿ chaꞌtso, sꞌaaⁿ tsaⁿsꞌa ñꞌeⁿ tsaⁿscu. ");
INSERT INTO amuNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ndoꞌ tsoom: “Macweꞌ joꞌ na nꞌndii tsaⁿsꞌa tsotyeeⁿ, tsoñeeⁿ, cha tyeⁿ nncꞌoom ñꞌeⁿ scoomꞌm, ");
INSERT INTO amuNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ndoꞌ wendyena ñeꞌcwii seiꞌ nlaꞌxmaⁿna.” Joꞌ chii meiiⁿ na we tsꞌaⁿ ñejlaꞌxmaⁿna sa̱a̱ jeꞌ ñecwii tsꞌaⁿ cwiluiindyena. ");
INSERT INTO amuNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ndoꞌ ncꞌe na luaaꞌ, seijndaaꞌñe nquii Tyꞌo̱o̱tsꞌom na ñecwii tsꞌaⁿ cwiluiindyena, joꞌ chii ticatsonaꞌ na cweꞌ tsꞌaⁿ nntseityuiiꞌ na luaaꞌ cwiluiindyena. ");
INSERT INTO amuNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ndoꞌ quia na tquienndaꞌna na waa wꞌaa, nquiee nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿ Jesús jlaꞌlcwiiꞌndyenndaꞌna juu ñꞌoomwaaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Tsoom nda̱a̱na: —ꞌÑeeⁿ juu tsꞌaⁿ na nntseityuiiꞌ ljeii na toco ñꞌeⁿ scuuꞌ ndoꞌ nncoco ñꞌeⁿ cwiicheⁿ yuscu, tsaⁿꞌñeeⁿ waa jnaaⁿꞌ nnom scuuꞌ ncꞌe na matsonaꞌ cantyja ꞌnaaⁿꞌ na cweꞌ mꞌaaⁿya ñequio cwiicheⁿ yuscu. ");
INSERT INTO amuNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ndoꞌ mati xeⁿ mꞌaaⁿ cwii yuscu na nntseityuiiꞌ ljeii na toco ñꞌeⁿ saaꞌ ndoꞌ nncoco ñꞌeⁿ cwiicheⁿ tsaⁿsꞌa, majoꞌti matseijndaaꞌñenaꞌ na waa jnaaⁿꞌ na mꞌaaⁿ ñꞌeⁿ cwiicheⁿ tsaⁿsꞌa. ");
INSERT INTO amuNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Ndoꞌ tyonquiocho ntꞌom nnꞌaⁿ yocanchꞌu na mꞌaaⁿ Jesús na catioom lꞌo̱o̱ⁿ nacjoona. Sa̱a̱ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê jlaꞌtiaꞌna nnꞌaⁿ na tquiocho yocanchꞌuꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Quia ntyꞌiaaꞌ Jesús na ljoꞌ cwilꞌana, seiliooꞌñê ñꞌeⁿndyena. Tsoom nda̱a̱na: —Caꞌndyeꞌyoꞌ na quiontyjaaꞌ yocanchꞌumꞌaⁿꞌ ja. Tilacuꞌyoꞌ joona, ee yuu na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom macanda̱ nncꞌooquieeꞌndye nnꞌaⁿ na ntyjaandye ja chaꞌna cwilꞌa yocanchꞌu. ");
INSERT INTO amuNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ñꞌoom na mayuuꞌ matsjo̱o̱ nda̱a̱ꞌyoꞌ, meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na ntyjaañe Tyꞌo̱o̱tsꞌom chaꞌna ntyjaandye yocanchꞌu ja, ndoꞌ mañequiaañe na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom juu, tsaⁿꞌñeeⁿ nnda̱a̱ nncjaaquieeꞌñê cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Quia joꞌ toꞌñoom yocanchꞌuꞌñeeⁿ naquiiꞌ lꞌo̱o̱ⁿ. Tioom lꞌo̱o̱ⁿ nacjoona na tioꞌnaaⁿñê joona. ");
INSERT INTO amuNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Tjatjati Jesús nato. Ndoꞌ cwii tsaⁿsꞌa maleinom na jndyontyjaaꞌ jom. Jndyocoꞌ xtye jo nnoom. Tso: —ꞌU Maestro na ya tsꞌaⁿndyuꞌ, ¿ljoꞌ macaⁿnaꞌ na catsꞌaa cha nntseixmaⁿya na ticantycwii na nncwaꞌndo̱ꞌa? ");
INSERT INTO amuNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ndoꞌ tso Jesús nnom: —¿Chiuu na matsuꞌ na ya tsꞌaⁿndyo̱ ja? Macanda̱ nquii Tyꞌo̱o̱tsꞌom cwiluiiñê na ljoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ꞌU mantyjiꞌ ljeii naqui na matsa̱ꞌntjoom. Matsonaꞌ: “Tincꞌomꞌyaꞌ ñꞌeⁿ cwiicheⁿ tsꞌaⁿ. Tintseiꞌcueꞌ tsꞌaⁿ. Tinchꞌueeꞌ ꞌnaaⁿꞌ tsꞌaⁿ. Tintseineiⁿꞌ ñꞌoom na cweꞌ cantu nacjooꞌ tsꞌaⁿ. Tiñenquiuꞌnnꞌaⁿꞌ tsꞌaⁿ. Catseitꞌmaaⁿꞌndyuꞌ tsotyeꞌ ñꞌeⁿ tsoꞌndyoꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Tsaⁿꞌñeeⁿ tsoom nnom Jesús: —Maestro, chaꞌtso ñꞌoommeiⁿꞌ matseicanda̱ya xjeⁿ na cachjoondyo̱cha̱ⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesús ntyꞌiaaⁿꞌaⁿ nnom tsaⁿꞌñeeⁿ. Sꞌaanaꞌ na jeeⁿ wiꞌ tsꞌoom juu. Tsoom nnom: —Cwii waa na matseitjo̱o̱naꞌ ꞌu. Cjaꞌ, cajnda̱a̱ꞌ chaꞌtso ꞌnaⁿꞌ. Sꞌomꞌñeeⁿ quiaaꞌ nda̱a̱ ndyeñeeⁿꞌ. Quia joꞌ nncꞌoomꞌ na tyandyuꞌ nandye cañoomꞌluee. Ndoꞌ caljoya tsꞌomꞌ nawiꞌ na nntjomꞌ hasta meiiⁿ xeⁿ nntseicueeꞌnaꞌ ꞌu. Candyoꞌtseiꞌjomndyuꞌ ñꞌeⁿndyo̱. ");
INSERT INTO amuNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jnda̱ na jñeeⁿ ñꞌoomwaaꞌ quia joꞌ jeeⁿ seiꞌndaaꞌnaꞌ ntyjeeⁿ. Tjaaⁿ na chjooꞌ tsꞌoom ee jeeⁿ jndye ꞌnaaⁿꞌaⁿ niom. ");
INSERT INTO amuNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Quia joꞌ taqueⁿ Jesús nda̱a̱ nnꞌaⁿ na mꞌaⁿ nacañomꞌm na cwilaꞌjomndye ñꞌeⁿñê. Tsoom nda̱a̱na: —Nnꞌaⁿ na tyandye jeeⁿ ndyaꞌ jndeiꞌnaꞌ na nñeꞌquiandyena na nntsa̱ꞌntjom Tyꞌo̱o̱tsꞌom joona. ");
INSERT INTO amuNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jnda̱ na jndyena ñꞌoomwaaꞌ, seitsaⁿꞌnaꞌ joona. Quia joꞌ tsonnaaⁿꞌaⁿ nda̱a̱na: —ꞌO nnꞌaⁿya, joo nnꞌaⁿ na quitꞌmaⁿ nꞌom ꞌnaⁿ jeeⁿ jndeiꞌnaꞌ na nñeꞌquiandyena na nntsa̱ꞌntjom Tyꞌo̱o̱tsꞌom joona. ");
INSERT INTO amuNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Jndeiꞌtinaꞌ na nncjuꞌñecje cwii tsaⁿtya na nntsa̱ꞌntjom Tyꞌo̱o̱tsꞌom jom, nchiiti na nncwicandiiꞌñe quiooꞌ camello tsueꞌ xꞌe tseiꞌnchquia. ");
INSERT INTO amuNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jnda̱ na jndyena ñꞌoomwaaꞌ yacheⁿ seiñꞌeeⁿꞌñꞌeⁿnaꞌ joona. Taꞌxꞌeendye cheⁿnquieena nda̱a̱ ntyjeena, jluena: —Quia joꞌ ¿ꞌñeeⁿ tsꞌaⁿ nnda̱a̱ nluiꞌnꞌmaaⁿñe? ");
INSERT INTO amuNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ntyꞌiaaꞌ Jesús nda̱a̱na, tsoom: —Tijoom canda̱a̱ nncwjiꞌnꞌmaaⁿñe cheⁿnquii tsꞌaⁿ. Macanda̱ nquii Tyꞌo̱o̱tsꞌom nnda̱a̱ nncwjiꞌnꞌmaaⁿñê tsꞌaⁿ. Ee tjaaꞌnaⁿ cwii na xocanda̱a̱ nntsꞌaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ndoꞌ tso Pedro nnom Jesús: —Aa ndiꞌ Ta, jâ jnda̱ ꞌndya̱a̱yâ chaꞌtso ꞌnaaⁿyâ na cwitsaantyjo̱o̱yâ naxeⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Tso Jesús nda̱a̱na: —Candyeꞌyoꞌ nntsjo̱o̱ ñꞌoom na mayuuꞌcheⁿ. Meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na maꞌndii waaꞌ, oo tiꞌnquio oo ndyencjo, oo tsotye, oo tsondyee, oo scuuꞌ oo ntseinda, oo ndyuaaꞌ ncꞌe na matseijomñe ñꞌoom na mañequia na macwjiꞌnꞌmaaⁿñe Tyꞌo̱o̱tsꞌom nnꞌaⁿ, ");
INSERT INTO amuNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","juu tsaⁿꞌñeeⁿ tiempomeiiⁿñe nncoꞌñoom siaⁿnto ndiiꞌcheⁿ lꞌaⁿꞌaⁿ, tiꞌnquioom, ndyencjoom, loñeeⁿ, ntseinaaⁿ, ndyuaaⁿꞌaⁿ ñequio na nntaꞌwiꞌ nnꞌaⁿ jom. Sa̱a̱ ncuee na cwii nndyonaꞌ, ticantycwii na nncwanoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ee jndye nnꞌaⁿ mꞌaⁿ na cwilaꞌtiuu nquiee na tꞌmaⁿ cwiluiindye, sa̱a̱ nncueꞌntyjo̱ na nncjuꞌcjenaꞌ joona. Ndoꞌ jndye nnꞌaⁿ mꞌaⁿ na majuꞌcjenaꞌ sa̱a̱ nda̱nquia nntseiwendyenaꞌ joona. ");
INSERT INTO amuNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesús ñequio nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê, ñjomndyena nato na cwiꞌoona Jerusalén. Jom wjaajñeeⁿ jo nda̱a̱na. Jeeⁿ matseiñꞌeeⁿꞌnaꞌ joona ndoꞌ cwicatyuena na cwiꞌoontyjo̱na naxeeⁿꞌeⁿ. Quia joꞌ tjeiꞌño̱o̱ⁿ nnꞌaⁿ na canchooꞌwendye, to̱o̱ⁿꞌo̱ⁿ na matseineiiⁿ nda̱a̱na chiuu waa na nntjom nqueⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Tsoom: —Queⁿꞌyoꞌ cwenta, macwitsaawaaya Jerusalén. Ndoꞌ ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee nñequiaa tsꞌaⁿ cwenta ja luee ntyee na cwiluiitquiendye, ñequio nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés na nlaꞌjndaaꞌndyetyeⁿna na nncꞌio̱ ndoꞌ nñeꞌquiana cwenta ja luee nnꞌaⁿ na nchii judíos. ");
INSERT INTO amuNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ndoꞌ naⁿꞌñeeⁿ nneiⁿꞌncona ndoꞌ njñomna ndaajnaⁿꞌ ja. Nntjaaꞌna ja ñꞌeⁿ tjaⁿtseiꞌ ndoꞌ nlaꞌcueeꞌna ja. Sa̱a̱ xuee jnda̱ ndyee nncwaꞌndo̱ꞌxco̱. ");
INSERT INTO amuNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Quia joꞌ ntseinda Zebedeo, Jacobo ñꞌeⁿ Juan tquiontyjaaꞌna Jesús, jluena: —Aa ndiꞌ Ta, lꞌue nꞌo̱o̱ⁿyâ na nñequiaaꞌ cwii naya na cwitaaⁿyâ njomꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Tsoom nda̱a̱na: —¿Ljoꞌ lꞌue nꞌomꞌyoꞌ na catsꞌaa ꞌo? ");
INSERT INTO amuNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Tꞌo̱o̱na nnoom, jluena: —Quia jnda̱ mamꞌaaⁿꞌ yuu na matseitꞌmaaⁿꞌñenaꞌ ꞌu, quiaaꞌ na cwii jâ nncwacatyeeⁿ ntyjaꞌ ntyjaya ndoꞌ cwiicheⁿ jâ nncwacatyeeⁿ ntyjatymaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Quia joꞌ matso Jesús nda̱a̱na: —ꞌO maxjeⁿ ticalaꞌno̱ⁿꞌyoꞌ ljoꞌ cwitaⁿꞌyoꞌ no̱o̱ⁿ. Na wiꞌtꞌmaⁿ na nncwino̱o̱ⁿ, ¿aa nnda̱a̱ nnaⁿndyoꞌ? ¿Aa nnda̱a̱ nljoya nꞌomꞌyoꞌ na nlaꞌcwjee nnꞌaⁿ ꞌo chaꞌxjeⁿ na jnda̱ ljoya tsꞌo̱o̱ⁿ na nlaꞌcueeꞌna ja? ");
INSERT INTO amuNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Joona tꞌo̱o̱na, jluena: —Nnda̱a̱. Tsoom nda̱a̱na: —Mayuuꞌ macaⁿnaꞌ na mañejuu nawiꞌ na nncwino̱o̱ⁿya, nncwiꞌnomꞌyoꞌ. Ndoꞌ macaⁿnaꞌ na caljoya nꞌomꞌyoꞌ na nlaꞌcwjee nnꞌaⁿ ꞌo chaꞌna cwiljoya tsꞌo̱o̱ⁿ na nlaꞌcueeꞌna ja. ");
INSERT INTO amuNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Sa̱a̱ nchii nnco̱ tseixmaⁿya na nntseijndaaꞌndyo̱ ꞌñeeⁿ juu nncwacatyeeⁿ ntyjaaꞌa ntyjaya oo ntyjatymaaⁿꞌ. Nquii Tyꞌo̱o̱tsꞌom nñequiaaⁿ nayaꞌñeeⁿ nda̱a̱ nnꞌaⁿ na jnda̱ seijndaaꞌñê na nntoꞌñoom juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ndoꞌ joo nquindye naⁿꞌñeeⁿ na cwilaꞌjomndye ñꞌeⁿ Jesús to̱ꞌna tyolaꞌwjeena we ncꞌiaana Jacobo ñꞌeⁿ Juan. ");
INSERT INTO amuNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Joꞌ chii Jesús tcwaaⁿ joona, tsoom nda̱a̱na: —ꞌO manquiuꞌyoꞌ nnꞌaⁿ na cwiluiitquiendye cwii cwii tsjoomnancue cwilaꞌsꞌandyena nda̱a̱ nnꞌaⁿ na cwitsa̱ꞌntjomna. Ndoꞌ nnꞌaⁿ na cwiluiitꞌmaⁿndye cwiqueⁿna xjeⁿ nnꞌaⁿ na mꞌaⁿ nacje ꞌnaaⁿna. ");
INSERT INTO amuNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Sa̱a̱ nchii laaꞌtiꞌ nlꞌaꞌyoꞌ quiiꞌntaaⁿꞌyoꞌ. Ee meiⁿcwiꞌñeeⁿcheⁿ ꞌo na ntyjaaꞌ tsꞌom na nncꞌoom na tꞌmaⁿñe quiiꞌntaaⁿꞌyoꞌ, tsaⁿꞌñeeⁿ matsonaꞌ na jom candiꞌntjoom nda̱a̱ꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ndoꞌ ꞌñeeⁿ juu quiiꞌntaaⁿꞌyoꞌ na maqueⁿ tsꞌom na juu nlcoꞌnnomnaꞌ jo nda̱a̱ꞌyoꞌ, matsonaꞌ na cateijndeii ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ee ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee jndyo̱o̱ na nndiꞌntjo̱ⁿya nda̱a̱ nnꞌaⁿ, nchii na nndyeꞌntjom nnꞌaⁿ no̱o̱ⁿ. Ndoꞌ jndyo̱o̱ na nñequiaandyo̱ na cꞌio̱ na nntio̱o̱ⁿya jnaaⁿ nnꞌaⁿ na jndyendye cha nndyaandyena jnaaⁿna na waa. ");
INSERT INTO amuNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ndoꞌ tquiena tsjoom Jericó. Jnda̱ joꞌ majaacaluiꞌ Jesús ñequio nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê ndoꞌ ñequio cwii tmaaⁿꞌ nnꞌaⁿ na jndyendye. Juu xjeⁿꞌñeeⁿ wacatyeeⁿ tsaⁿnchjaaⁿꞌ Bartimeo ꞌndyoo nato. Jom jnda Timeo. Macaaⁿ ljoꞌ na nleilꞌueeꞌñê. ");
INSERT INTO amuNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Quia na jñeeⁿ na mawinom Jesús tsꞌaⁿ Nazaret, to̱o̱ⁿꞌo̱ⁿ na matseixuaⁿ, tsoom: —ꞌU Jesús, na cwiluiindyuꞌ tsjaaⁿ David na jndyowicantyjooꞌ, cꞌoomꞌ na wiꞌ tsꞌomꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Jndye nnꞌaⁿ jlaꞌtiaꞌna jom na catseicheeⁿ, sa̱a̱ jom yacheⁿ tyotseixuaatyeeⁿ, tsoom: —ꞌU, na cwiluiindyuꞌ tsjaaⁿ David na jndyowicantyjooꞌ, cꞌoomꞌ na wiꞌ tsꞌomꞌ ñꞌeⁿndyo̱. ");
INSERT INTO amuNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesús tjameintyjeeⁿꞌeⁿ, tsoom: —Cwaⁿꞌyoꞌ jom. Quia joꞌ tcwaⁿna tsaⁿnchjaaⁿꞌ, jluena nnoom: —Cꞌomꞌtꞌmaaⁿꞌndyuꞌ tsꞌomꞌ. Quicantyjaꞌ ee macwaaⁿ ꞌu. ");
INSERT INTO amuNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ndoꞌ jom cweꞌ tjuꞌtoom liaa na wanjoomꞌñê, teicantyjaaⁿ, tjaaⁿ na mꞌaaⁿ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Taxꞌee Jesús nnoom: —¿Aa waa na nntsaꞌ ja? Tꞌo̱ tsaⁿnchjaaⁿꞌ, tsoom: —Jeeⁿ ꞌu Ta, lꞌue tsꞌo̱o̱ⁿ na nleitquioya. ");
INSERT INTO amuNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Tso Jesús nnoom: —Cjaꞌtoꞌ. Jnda̱ nꞌmaⁿꞌ ncꞌe na matseiꞌyuꞌ ñꞌeⁿndyo̱. Mañoomꞌ teitquioomꞌm. Tjantyjo̱o̱ⁿ naxeⁿꞌ Jesús na tyꞌetyꞌetina nato. ");
INSERT INTO amuNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jnda̱ tyꞌewindyoona Jerusalén na nndyooꞌ tsjoom Betfagé ñequio Betania. Tquiena ndyeyu ta Olivos, quia joꞌ jñom Jesús we nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê na cꞌoona lꞌaa. ");
INSERT INTO amuNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Tsoom nda̱a̱na: —Catsaaquieꞌyoꞌ tsjoom chjoo laꞌñeⁿ. Quia na jnda̱ squieꞌyoꞌ mantyjacheⁿ nliuꞌyoꞌ cwii snom xcoo na ñjom. Juuyoꞌ quiooꞌ na meiⁿjom ndiiꞌ tyooljo tsꞌaⁿ. Calaꞌnaⁿꞌyoꞌ ndoꞌ quioꞌñꞌomꞌyoꞌ juuyoꞌ luaa. ");
INSERT INTO amuNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Xeⁿ mꞌaaⁿ ꞌñeeⁿ juu na nntso nda̱a̱ꞌyoꞌ chiuu na luaaꞌ cwilꞌaꞌyoꞌ, canduꞌyoꞌ nnom na nquii tsaⁿ na matsa̱ꞌntjom ꞌo tjo̱o̱ñê snomꞌñeeⁿ ndoꞌ mantyja nntseicwanomnnaaⁿꞌaⁿ juuyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Quia joꞌ tyꞌena, jliuna snom xcoo na ñjomyoꞌ ꞌndyootsꞌa waaꞌ tsꞌaⁿ ꞌndyoo nato. Ndoꞌ jlacanaⁿꞌna juuyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Jlue ntꞌom nnꞌaⁿ na meintyjeeꞌ joꞌ joꞌ: —¿Ljoꞌ cwilꞌaꞌyoꞌ? ¿Chiuu na cwilacanaⁿꞌyoꞌ snom xcoomꞌaaⁿꞌ? ");
INSERT INTO amuNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Joona tꞌo̱o̱na nda̱a̱ naⁿꞌñeeⁿ chaꞌxjeⁿ na jnda̱ tso Jesús na caluena. Quia joꞌ ꞌndye naⁿꞌñeeⁿ na cꞌoona. ");
INSERT INTO amuNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Tyꞌeñꞌomna snom xcoo na mꞌaaⁿ Jesús. Tioona liaana naxeⁿꞌyoꞌ, jnda̱ joꞌ tjaljoom juuyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Jndye nnꞌaⁿ tyotsa̱ꞌna liaana tsꞌom nato na wjaⁿ, ndoꞌ ntꞌom tyotyje tsco, tyotsa̱ꞌ joonaꞌ tsꞌom natoꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ndoꞌ nnꞌaⁿ na cwiꞌoojndyee ñequio nnꞌaⁿ na cwiꞌoontyjo̱, ñequiiꞌcheⁿ tyolaꞌxuaana, tyoluena: —Matseitꞌmaaⁿꞌñenaꞌ tsaⁿmꞌaaⁿ. Matioꞌnaaⁿñenaꞌ jom na macwjeeꞌcañoom tsꞌiaaⁿ ꞌnaaⁿꞌ Ta Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Matioꞌnaaⁿñenaꞌ jom na nntsa̱ꞌntjoom chaꞌxjeⁿ na ñesa̱ꞌntjom welooya David tiyo. Matseitꞌmaaⁿꞌñenaꞌ Tyꞌo̱o̱tsꞌom nandye cañoomꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Tjaquieeꞌ Jesús naquiiꞌ tsjoom Jerusalén. Tjaaⁿ watsꞌom tꞌmaⁿ. Ndoꞌ quia jnda̱ ntyꞌiaaⁿꞌaⁿ ndiocheⁿ naquiiꞌ watsꞌom quia joꞌ tjalcweeⁿꞌeⁿ Betania ñꞌeⁿ nnꞌaⁿ na canchooꞌwendye ee na jnda̱ tmaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Teincoo cwiicheⁿ xuee quia na mꞌaⁿna nato na jnaⁿna Betania, jndyo na ñeꞌjndoꞌ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ntyꞌiaaꞌtquiaaⁿ cwii tsꞌoom higuera na niom tscooꞌnaꞌ. Seicandyooꞌñê, tjacantyꞌiaaⁿꞌaⁿ aa nljeiiⁿ ta̱ na nlqueeⁿ. Sa̱a̱ quia na tueꞌcañoom, cweꞌ tsco ljeiiⁿ ee tjo̱o̱cheⁿ na nncueꞌ ta̱. ");
INSERT INTO amuNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Tsoom nnom tsꞌoomꞌñeeⁿ: —Tajom xuee nntsaꞌnndaꞌ ta̱ na nlquii tsꞌaⁿ. Ndyecheⁿ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê na luaaꞌ ñꞌoom tsoom. ");
INSERT INTO amuNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jnda̱ na tquienndaꞌna Jerusalén, quia joꞌ cwiicheⁿ cwii ndiiꞌ tjaquieeꞌ Jesús naquiiꞌ watsꞌom tꞌmaⁿ. Joꞌ joꞌ niom jndye nnom ꞌnaⁿ ñꞌeⁿ quiooꞌ na cwinda̱a̱ nnꞌaⁿ ndoꞌ cwilaꞌjnda nnꞌaⁿ na macaⁿnaꞌ joona na cwilaꞌtꞌmaaⁿꞌndyena Tyꞌo̱o̱tsꞌom. To̱ꞌ Jesús na tyocwjeeⁿꞌeⁿ naⁿꞌñeeⁿ chꞌeⁿ. Tyotseicantqueeⁿ meiⁿsa ꞌnaaⁿ nnꞌaⁿ na cwilaꞌjndyoondye sꞌom, ñequio ntsula̱ ꞌnaaⁿ nnꞌaⁿ na cwinda̱a̱ cantuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Meiⁿ tatinquiaaⁿ na nncwinom nnꞌaⁿ tachꞌeeⁿꞌ watsꞌom tꞌmaⁿ na cwileiꞌchona ꞌnaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Tꞌmo̱o̱ⁿ nda̱a̱ naⁿꞌñeeⁿ, tsoom: —Aa nchii mawaa ljeii ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom na matsonaꞌ: “Wꞌaya tseixmaⁿnaꞌ wꞌaa yuu chaꞌtso nnꞌaⁿ tsjoomnancue cwilaꞌneiⁿna nnom Tyꞌo̱o̱tsꞌom.” Sa̱a̱ ꞌo cwilꞌaꞌyoꞌ juunaꞌ chaꞌcwijom tsueꞌtsjo̱ꞌ yuu na cwicatooꞌndye naⁿcantyꞌue. ");
INSERT INTO amuNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ntyee na cwiluiitquiendye ñequio nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés, quia tyondyena na luaaꞌ matso Jesús, tyolꞌueendyena chiuu ya nlꞌana na nlaꞌcueeꞌna jom. Sa̱a̱ nquiaana na nntꞌuena jom ee na chaꞌtsondye nnꞌaⁿ jeeⁿ tjaweeꞌ nꞌom ñꞌoom na tyoꞌmo̱o̱ⁿ nda̱a̱. ");
INSERT INTO amuNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ndoꞌ ticwii tmaaⁿ tyocaluiꞌ Jesús Jerusalén. ");
INSERT INTO amuNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Teincoo cwiicheⁿ xuee teiꞌnomnndaꞌna xꞌee tsꞌoom higueraꞌñeeⁿ. Ntyꞌiaana na jnda̱ tcaaⁿñꞌeⁿnaꞌ xjeⁿ quiiꞌ nchꞌiooꞌnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Quia joꞌ tjañjoomꞌ tsꞌom Pedro, tsoom nnom Jesús: —Cantyꞌiaꞌ Maestro, tsꞌoom na tjuꞌwiꞌ ñꞌoom nacjooꞌ jnda̱ tcaaⁿñꞌeⁿnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Tꞌo̱ Jesús, tsoom: —Cꞌomꞌyoꞌ na cwilayuꞌya nꞌomꞌyoꞌ ñꞌeⁿ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mayuuꞌcheⁿ nndyeꞌyoꞌ nntsjo̱o̱, meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na ñeꞌcwii waa na matseitiuu ndoꞌ matseiyoomꞌm naquiiꞌ tsꞌoom na nluii chaꞌxjeⁿ na matsoom, nntsoom nnom sjo̱waaꞌ: “Quicantyjaꞌ, cjaꞌ, cjuꞌndyuꞌ tsꞌom ndaaluee.” Ndoꞌ nluii chaꞌxjeⁿ na matsoom. ");
INSERT INTO amuNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Cweꞌ joꞌ matsjo̱o̱ nda̱a̱ꞌyoꞌ, chaꞌtso na cwitaⁿꞌyoꞌ quia na cwilaneiⁿꞌyoꞌ nnom Tyꞌo̱o̱tsꞌom, calayuꞌyoꞌ na cwitoꞌñoomꞌyoꞌ joonaꞌ, quia joꞌ nntoꞌñoomꞌyoꞌ na cwitaⁿꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ndoꞌ quia xcwe na matseiꞌneiⁿꞌ nnom Tyꞌo̱o̱tsꞌom xeⁿ waa na machꞌeenaꞌ ꞌu ñꞌeⁿ xꞌiaꞌ, catseitꞌmaⁿ tsꞌomꞌ jom, cha mati Tsotyeꞌ na mꞌaaⁿ cañoomꞌluee, nnda̱a̱ nntseitꞌmaⁿ tsꞌoom ꞌu jnaⁿꞌ na waa. ");
INSERT INTO amuNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ee xeⁿ ꞌu tiñeꞌcatseitꞌmaⁿ tsꞌomꞌ xꞌiaꞌ, mati Tsotyeꞌ na mꞌaaⁿ cañoomꞌluee xocatseitꞌmaⁿ tsꞌoom ꞌu juu na matseiꞌtjo̱o̱ndyuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Quia joꞌ cwiicheⁿ ndiiꞌ tquienndaꞌna Jerusalén. Ndoꞌ yocheⁿ na matseicaañe Jesús nomchꞌeⁿ watsꞌom tꞌmaⁿ tyꞌentyjaaꞌ ntyee na cwiluiitquiendye jom, ñequio nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés, ñequio nnꞌaⁿ na cwiluiitquiendye nda̱a̱ nnꞌaⁿ judíos. ");
INSERT INTO amuNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Taꞌxꞌeena nnoom: —¿ꞌÑeeⁿ najndeii ñꞌeⁿ na tjeiꞌ naⁿꞌñeeⁿ watsꞌom? Ndoꞌ ¿ꞌñeeⁿ tquiaa na matseiꞌxmaⁿꞌ juunaꞌ? ");
INSERT INTO amuNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Tso Jesús nda̱a̱na: —Mati nncwaxꞌa̱ ja cwii ñꞌoom nda̱a̱ꞌyoꞌ. Catꞌo̱ꞌyoꞌ no̱o̱ⁿya quia joꞌ mati ja nntsjo̱o̱ nda̱a̱ꞌyoꞌ ꞌñeeⁿ juu tquiaa najndeii na matseixmaⁿya na sꞌaaya na ljoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Juu na tyotseitsꞌoomñe Juan nnꞌaⁿ, ¿yuu jnaⁿ najndeii na tyotseixmaaⁿ? ¿Aa na mꞌaaⁿ Tyꞌo̱o̱tsꞌom? oo ¿aa nnꞌaⁿ jlue na ljoꞌ catsꞌaaⁿ? Catꞌo̱ꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Quia joꞌ to̱ꞌna na tyolaꞌneiⁿ cheⁿnquieena, tyolaꞌñꞌeeⁿꞌ ndyueena. Jluena: —¿Chiuu lꞌuuyo̱o̱? Xeⁿ nlꞌuuya juu najndeii na tyotseixmaaⁿ jnaⁿnaꞌ na mꞌaaⁿ Tyꞌo̱o̱tsꞌom, quia joꞌ majoꞌto nntso Jesús nda̱a̱ya: “¿Chiuu na ticalayuꞌyoꞌ ñꞌoom na tyoñequiaaⁿ?” ");
INSERT INTO amuNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ndoꞌ xeⁿ nlꞌuuya na jnaⁿnaꞌ cweꞌ ee na nnꞌaⁿ jlue na ljoꞌ catsꞌaaⁿ, ¿chiuu nntjo̱o̱ⁿyo̱o̱? Luaaꞌ jlaꞌtiuuna na nquiaana nnꞌaⁿ na jndyendye. Ee chaꞌtsondye nnꞌaⁿ cwilaꞌyuꞌ na mayuuꞌcheⁿ Juan cwiluiiñê profeta. ");
INSERT INTO amuNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Joꞌ chii tꞌo̱o̱na nnom Jesús, jluena: —Aa jâ maxjeⁿ ticaliuuyâ. Tsoom nda̱a̱na: —Mati ja xocatsjo̱o̱ nda̱a̱ꞌyoꞌ ꞌñeeⁿ tquiaa najndeii na matseixmaⁿya na matsꞌaa tsꞌiaaⁿmeiⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Quia joꞌ to̱ꞌ Jesús na tyotseineiiⁿ ñꞌoom tjañoomꞌ nda̱a̱ naⁿꞌñeeⁿ. Tsoom: —Tyomꞌaaⁿ cwii tsꞌaⁿ. Jnoomꞌm lꞌo̱o̱ ta̱uva nnom tyuaaⁿꞌaⁿ. Sꞌaaⁿ tiom ndiocheⁿ nnom ntjoomꞌm. Mati sꞌaaⁿ cwii peila na nncꞌoocue ndaa na jnda̱ ꞌndiindyena ta̱ꞌñeeⁿ. Na macanda̱ sꞌaaⁿ cwii tatsiaⁿndye yuu na nntsꞌaa tsꞌaⁿ cwenta ntjoomꞌm. ’Ndoꞌ teijneiⁿ tyuaaⁿꞌaⁿ ntꞌomcheⁿ nnꞌaⁿ na nlꞌa tsꞌiaaⁿ, jnda̱ joꞌ tjayaaⁿ cwiicheⁿ ndyuaa. ");
INSERT INTO amuNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Quia na jnda̱ tquie ntjom, jñoom cwii mosoomꞌm yuu mꞌaⁿ nnꞌaⁿ na cwilꞌa tsꞌiaaⁿ tyuaaⁿꞌaⁿ na nñeꞌquia naⁿꞌñeeⁿ ta̱ na tseixmaⁿ cwentaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Sa̱a̱ joona yacheⁿ tꞌuena mosoꞌñeeⁿ, cwajndii tyotjaaꞌna juu. Jñoomna juu na meiⁿcwii tjaa ljoꞌ tjañꞌoom. ");
INSERT INTO amuNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Quia joꞌ jñomnnaaⁿꞌaⁿ cwiicheⁿ mosoomꞌm. Juu tsaⁿꞌñeeⁿ jñomna ljo̱ꞌ. Jlaꞌquieeꞌndyena xqueⁿ ndoꞌ tyolaꞌjnaaⁿꞌna juu. ");
INSERT INTO amuNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Sa̱a̱ tsꞌaⁿ na ꞌnaaⁿꞌ tyuaa jñomnnaaⁿꞌaⁿ cwiicheⁿ mosoomꞌm, tsaⁿꞌñeeⁿ jlaꞌcueeꞌna jom. Ndoꞌ malaaꞌtiꞌ lꞌana ñequio jndye ntꞌomcheⁿ mosoomꞌm na jñoom. Tjaaꞌna ntꞌom naⁿꞌñeeⁿ ndoꞌ ntꞌom jlaꞌcwjeena. ");
INSERT INTO amuNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","’Ñecwii tsꞌaⁿ cwii mꞌaaⁿ na matseitioom na njñoom, nquii jnaaⁿ joꞌ, na jeeⁿ candyaꞌ tsꞌoom. Tsaⁿꞌñeeⁿ jñoom na macanda̱, ee luaa seitioom: “Matsonaꞌ na nlaꞌtꞌmaaⁿꞌndyena tiꞌjndaaya.” ");
INSERT INTO amuNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Sa̱a̱ nquiee nnꞌaⁿ na cwilꞌa tsꞌiaaⁿ tyuaaⁿꞌaⁿ, tyoluena nda̱a̱ ntyjeena: “Juu tsaⁿmꞌaaⁿꞌ nljo ntjomwaañe lꞌo̱o̱ⁿ ee jom jnda nquii tsꞌaⁿ na ꞌnaaⁿꞌ tyuaawaa. Chiuu ticalaꞌcua̱a̱ꞌa tsaⁿmꞌaaⁿꞌ cha jaa nljonaꞌ ꞌnaaⁿya.” ");
INSERT INTO amuNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Joꞌ chii tꞌuena tsaⁿꞌñeeⁿ, jlaꞌcueeꞌna jom. Tyꞌecatquieeꞌna jom tquia nnom ntjomꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Quia joꞌ taxꞌee Jesús nda̱a̱na, tsoom: —Nquii tsꞌaⁿ na ꞌnaaⁿꞌ tyuaaꞌñeeⁿ, ¿chiuu nntsꞌaaⁿ? Maxjeⁿ nñoom, nntseicwjeⁿ naⁿꞌñeeⁿ ndoꞌ nñequiaaⁿ tyuaaⁿꞌaⁿ nda̱a̱ ntꞌomcheⁿ nnꞌaⁿ na nlꞌa tsꞌiaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","’¿Aa tyoolaꞌnaⁿꞌyoꞌ ljeii ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom na matsonaꞌ: Majuuto tsjo̱ꞌ na tixocwilꞌue nquiu luañeⁿ na cwilꞌa tsiaⁿtsjo̱ꞌ, jnda̱ mawacatyeeⁿnaꞌ nqui tsiaⁿtsjo̱ꞌ? ");
INSERT INTO amuNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Nquii Ta Tyꞌo̱o̱tsꞌom seijndaaꞌñê na ljoꞌ ndoꞌ jeeⁿ cwijaaweeꞌ nꞌo̱o̱ⁿya na cwintyꞌiaaya na luaaꞌ tuii. ");
INSERT INTO amuNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ndoꞌ nnꞌaⁿ na tyondye ñꞌoommeiⁿꞌ tyoqueⁿndyena na nntꞌuena Jesús, ee jlaꞌno̱ⁿꞌna na cjoo joona seineiiⁿ ñꞌoom tjañoomꞌwaaꞌ. Sa̱a̱ nquiaana nnꞌaⁿ na jndyendye, cweꞌ joꞌ ꞌndyena jom, mana tyꞌena. ");
INSERT INTO amuNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Jnda̱nquia nnꞌaⁿ fariseos jñoomna cwantindye ncꞌiaana ñequio nnꞌaⁿ ꞌnaaⁿꞌ Herodes na mꞌaaⁿ Jesús. Naⁿꞌñeeⁿ nncꞌomna cwenta ñꞌoom na matseineiiⁿ cha nnda̱a̱ nntꞌuiinaꞌ jom cantyja ꞌnaaⁿꞌnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Jnda̱ na tquiena na mꞌaaⁿ, jluena nnoom: —Maestro, nquiuuyâ na maxjeⁿ ñꞌoom na mayuuꞌ matseiꞌneiⁿꞌ ndoꞌ ñecwii xjeⁿ macheꞌ ñequio meiⁿnquia nnꞌaⁿ ee titseiñꞌoomꞌndyuꞌ ljoꞌ waa na cwiluiindyena. Mayuuꞌ ñꞌoom na maꞌmo̱o̱ⁿꞌ cantyja ꞌnaaⁿꞌ natooꞌ Tyꞌo̱o̱tsꞌom. ¿Aa matsa̱ꞌntjomnaꞌ na nntio̱o̱ⁿya tsꞌiaaⁿnda̱a̱ya nnom César, oo aa ticatsa̱ꞌntjomnaꞌ? ¿Aa laxmaaⁿya na catio̱o̱ⁿya joꞌ oo aa ticalaxmaaⁿya? ");
INSERT INTO amuNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ndoꞌ seiꞌno̱ⁿꞌ Jesús na cweꞌ cwilueyana. Tsoom nda̱a̱na: —¿Chiuu na ñeꞌcatꞌueꞌyoꞌ ja? Quiaꞌyoꞌ cwii tsjo̱ꞌñjeeⁿ denario na nntyꞌiaya. ");
INSERT INTO amuNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Tquiana cwii denario ndoꞌ jnda̱ na ntyꞌiaaⁿꞌaⁿ tsoom nda̱a̱na: —¿ꞌÑeeⁿ ꞌndyoo nnom luaa? Ndoꞌ ¿ꞌñeeⁿ xueeꞌ teiljeii luaa? Ndoꞌ tꞌo̱o̱na, jluena: —Tsaⁿmaⁿtsꞌiaaⁿ tꞌmaⁿ, César. ");
INSERT INTO amuNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ndoꞌ tsoom: —Catiomꞌyoꞌ tsꞌiaaⁿnda̱a̱ꞌyoꞌ nnom César yuu na tseixmaⁿnaꞌ cwentaaⁿꞌaⁿ. Ndoꞌ mati quiaꞌyoꞌ cwentaaꞌ Tyꞌo̱o̱tsꞌom yuu na tseixmaⁿnaꞌ cwentaaꞌ nqueⁿ. Tjaweeꞌ nꞌomna ñꞌoom na tꞌo̱o̱ⁿ sa̱a̱ tiya nquiuna na ticatꞌuiinaꞌ jom. ");
INSERT INTO amuNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Jnda̱ joꞌ tquio ntꞌom nnꞌaⁿ saduceos na mꞌaaⁿ Jesús. Naⁿꞌñeeⁿ ticalaꞌyuꞌna na nntaꞌndoꞌxco nnꞌaⁿ na jnda̱ tja̱. Taꞌxꞌeena nnoom, jluena: ");
INSERT INTO amuNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Maestro, waa ljeii na ꞌndii Moisés lua̱a̱ya na matsonaꞌ xeⁿ tueꞌ cwii tsaⁿsꞌa ndoꞌ ꞌndiinaꞌ scuuꞌ na ñenquii, tjaaꞌnaⁿ ndana, quia joꞌ tyjee tsꞌooꞌñeeⁿ cocoom ñꞌeⁿ scuuꞌ xioom. Nncꞌom ntseinaaⁿ ñꞌeⁿ yuscuꞌñeeⁿ cha nntseinoomñê na tjaa ntseinda xioom tꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Tyomꞌaⁿ ntquieeꞌ naⁿnom na ñenquii tsꞌaⁿ ntseinda. Juu tsaⁿtquiee tocoom sa̱a̱ tyuaaꞌ tueeⁿꞌeⁿ, tjaaꞌnaⁿ ndana ñꞌeⁿ scoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Quia joꞌ tsaⁿ na jnda̱ we tocoom ñꞌeⁿ scuuꞌ xioom sa̱a̱ mati jom tueeⁿꞌeⁿ ndoꞌ tjaaꞌnaⁿ ndana ñꞌeⁿ yuscuꞌñeeⁿ. Mati tsaⁿ na jnda̱ ndyee tocoom ñꞌeⁿ scuuꞌ xioom ndoꞌ majoꞌti tjoom. ");
INSERT INTO amuNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Malaaꞌtiꞌ chaꞌtso ntquieeꞌndye naⁿnomꞌñeeⁿ tuncona ñequio yuscuꞌñeeⁿ ndoꞌ majoꞌti quia tja̱na, tjaaꞌnaⁿ ndana ñꞌeⁿñe. Ndoꞌ na macanda̱ tueꞌto yuscuꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ñeꞌcataꞌxꞌa̱a̱yâ njomꞌ, Ta, quia na nntaꞌndoꞌxco chaꞌtso nnꞌaⁿ na jnda̱ tja̱, quia joꞌ ¿ꞌñeeⁿ cwiindye joona na nluii scuuꞌ yuscuꞌñeeⁿ? Ee jom ñetꞌoom scuu chaꞌtso na ntquieeꞌndye naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Matso Jesús nda̱a̱na: —Aa nchii ñꞌoomwaaꞌ matseicano̱o̱ⁿnaꞌ na tixcwe cwitjeiꞌyoꞌ cwenta, ee meiiⁿ na cwilaꞌnaⁿꞌyoꞌ ljeii ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom sa̱a̱ ticalaꞌno̱ⁿꞌyoꞌ ljoꞌ maꞌmo̱ⁿnaꞌ. Meiⁿ cantyja ꞌnaaⁿꞌ najndeii na matseixmaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ee quia na nntaꞌndoꞌxco nnꞌaⁿ na jnda̱ tja̱ taxocꞌunconndaꞌ meiⁿ naⁿnom, meiⁿ naⁿlcu ee nncꞌomna chaꞌna ángeles na mꞌaⁿ cañoomꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Sa̱a̱ cantyja ꞌnaaⁿꞌ ñꞌoom na nntaꞌndoꞌxco nnꞌaⁿ na jnda̱ tja̱, ¿aa chii jnda̱ ñejlaꞌnaⁿꞌyoꞌ libro na seiljeii Moisés yuu na matseineiⁿnaꞌ cantyja ꞌnaaⁿꞌ tsꞌoom nioom na ntyꞌiaaⁿꞌaⁿ? Joꞌ joꞌ xcwe naquiiꞌ ntsaachom na cwico tsꞌoomꞌñeeⁿ, teicꞌuaa na matseineiⁿ Tyꞌo̱o̱tsꞌom nnoom, tso: “Ja cwiluiindyo̱ Tyꞌo̱o̱tsꞌom cwentaaꞌ Abraham, Isaac ndoꞌ Jacob.” ");
INSERT INTO amuNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Joꞌ chii caliuꞌyoꞌ na cwitaꞌndoꞌ naⁿꞌñeeⁿ ee jom nchii cwiluiiñê Tyꞌo̱o̱tsꞌom cwentaa lꞌoo. Jom cwiluiiñê Tyꞌo̱o̱tsꞌom cwentaa nnꞌaⁿ na cwitaꞌndoꞌ. Cweꞌ joꞌ maꞌmo̱ⁿnaꞌ na ꞌo meiⁿchjoo ticalaꞌno̱ⁿꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Cwii tsꞌaⁿ na maꞌmo̱ⁿ ljeii na tqueⁿ Moisés tyjeeꞌcañoom na mꞌaⁿ nnꞌaⁿ saduceosꞌñeeⁿ. Tyondiiñecheeⁿ chaꞌtso ñꞌoom na tyolaꞌneiⁿna ndoꞌ tyoqueeⁿ cwenta na jeeⁿ xcwe ñꞌoom tꞌo̱ Jesús nda̱a̱na. Taxꞌeeⁿ nnom Jesús, tsoom: —Quiiꞌntaaⁿ chaꞌtso ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na matsa̱ꞌntjomnaꞌ, ¿cwaaⁿ cwii joonaꞌ na tꞌmaⁿti tseixmaⁿnaꞌ? ");
INSERT INTO amuNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Tꞌo̱ Jesús, tsoom: —Luaa matso ñꞌoom na tꞌmaⁿti: “Candyeꞌyoꞌ, ꞌo nnꞌaⁿ Israel. Nquii Ta Tyꞌo̱o̱tsꞌom cwentaaya, macanda̱ ñenqueⁿ cwiluiiñê na matsa̱ꞌntjoom. ");
INSERT INTO amuNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Cꞌoomꞌ na candyaꞌ tsꞌomꞌ Ta Tyꞌo̱o̱tsꞌom cwentaꞌ ñequio na xcweeꞌya tsꞌomꞌ, ñequio chaꞌwaa na jnda ntyjiꞌ, ñequio chaꞌwaa na jndo̱ꞌya tsꞌomꞌ, ndoꞌ ñequio chaꞌwaa najnduꞌ.” Luaaꞌ ñꞌoom na tꞌmaⁿti na matsa̱ꞌntjomnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ndoꞌ ñꞌoom na jnda̱ we matseijomnaꞌ ñꞌoomꞌñeeⁿ. Luaa matsonaꞌ: “Cꞌoomꞌ na wiꞌ tsꞌomꞌ ncꞌiaꞌ chaꞌxjeⁿ na jnda ntyjiꞌ ñequio nncuꞌ. Tjaaꞌnaⁿ cwiicheⁿ ñꞌoom na tꞌmaⁿti na matsa̱ꞌntjomnaꞌ chaꞌna ñꞌoommeiⁿꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Quia joꞌ tꞌo̱ tsaⁿꞌñeeⁿ na maꞌmo̱ⁿ ljeii na tqueⁿ Moisés, tsoom: —Maxjeⁿ ya, ꞌu Maestro. Luaaꞌ ñꞌoom na mayuuꞌ matsuꞌ na ñecwii Tyꞌo̱o̱tsꞌom. Tjaaꞌnaⁿ cwiicheⁿ na matsa̱ꞌntjom, macanda̱ jom. ");
INSERT INTO amuNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ndoꞌ na nncꞌoom tsꞌaⁿ na candyaꞌ tsꞌoom Tyꞌo̱o̱tsꞌom ñequio na xcweeꞌya tsꞌoom, ñequio chaꞌwaa na jndo̱ꞌya tsꞌoom, ñequio chaꞌwaa na jnda ntyjeeⁿ, ndoꞌ ñequio chaꞌwaa najneiⁿ, ndoꞌ mati na nncꞌoom na wiꞌ tsꞌoom ncꞌiaaⁿꞌaⁿ chaꞌxjeⁿ jnda ntyjii nqueⁿ, chaꞌtso nmeiⁿꞌ lꞌueti nchiiti quiooꞌ na nlco na mañequiaa tsꞌaⁿ nnom Tyꞌo̱o̱tsꞌom ñequio meiⁿnquia ntꞌomcheⁿ na cwiñeꞌquia nnꞌaⁿ na cwilaꞌtꞌmaaⁿꞌndyena jom. ");
INSERT INTO amuNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jnda̱ na ntyꞌiaaꞌ Jesús na jndo̱ꞌ tsꞌom tsaⁿꞌñeeⁿ ñꞌoom na tꞌo̱, tsoom nnom: —Jnda̱ teindyooꞌ na nñequiaandyuꞌ na nntsa̱ꞌntjom Tyꞌo̱o̱tsꞌom ꞌu. Jnda̱ joꞌ tjaaꞌnaⁿ ꞌñeeⁿ cwii jnda̱a̱ꞌ tsꞌom na nncwaxꞌeti. ");
INSERT INTO amuNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Cwiicheⁿ ndiiꞌ na tyomꞌaaⁿ Jesús naquiiꞌ watsꞌom tꞌmaⁿ na tyoꞌmo̱o̱ⁿ nda̱a̱ nnꞌaⁿ, tsoom: —Nquiee nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés cwiluena na nquii Cristo cwiluiiñê tsjaaⁿ David na jndyowicantyjooꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Sa̱a̱ manquiiti David cantyja na tꞌmo̱ⁿ Espíritu Santo nnoom tsoom na Cristo cwiluiiñê Ta na matsa̱ꞌntjom jom. Tsoom: Nquii Ta Tyꞌo̱o̱tsꞌom tsoom nnom juu Ta na matsa̱ꞌntjom ja: “Cajmaⁿꞌ ntyjaaꞌa ntyjaya yuu na matseitꞌmaaⁿꞌñenaꞌ ꞌu hasta xjeⁿ na jnda̱ tsa̱ꞌa nnꞌaⁿ na jndoo ꞌu na cꞌomna nacje ꞌnaⁿꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Cweꞌ joꞌ mawaxꞌa̱a̱ya nda̱a̱ꞌyoꞌ ¿chiuu waayuu na cwiluiiñe Cristo tsjaaⁿ David na jndyowicantyjooꞌ ee manquiiti David tsoom na juu cwiluiiñe Ta na matsa̱ꞌntjom jom? Ndoꞌ jndyendye nnꞌaⁿ ñequio na neiiⁿna tyondyena ñꞌoom na seineiiⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Naquiiꞌ ñꞌoom na tyoꞌmo̱o̱ⁿ, tsoom: —Calꞌaꞌyoꞌ cwenta nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés ee joona jeeⁿ cjaaweeꞌ nꞌomna na nncoꞌnomna na cweeꞌna liaa jnda na teiꞌncoo ndoꞌ na nntaⁿ nnꞌaⁿ lueena na nlaꞌtꞌmaaⁿꞌndye joona ñequio na jndooꞌcheⁿ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Joona jeeⁿ ñeꞌcwindyuaandyena ntsula̱ nacañoomticheⁿ naquiiꞌ lanꞌom ndoꞌ majoꞌti cwilꞌana quia na cwicwaꞌna na waa xuee. ");
INSERT INTO amuNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Mati cwitjeiiꞌna ꞌnaaⁿ yolcu na jnda̱ ljondye na tja̱ sꞌaa, ndoꞌ cha nntseicuꞌnaꞌ na luaaꞌ laꞌxmaⁿna, jeeⁿ yo cwilaꞌneiⁿna nnom Tyꞌo̱o̱tsꞌom. Joꞌ tꞌmaⁿti nntꞌuiiweeⁿꞌeⁿ joona. ");
INSERT INTO amuNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Cwii xuee wacatyeeⁿ Jesús ndyeyu na meintyjeeꞌ castom na cwitueeꞌ nnꞌaⁿ sꞌom cwentaaꞌ watsꞌom tꞌmaⁿ. Ntyꞌiaaꞌcheeⁿ na cwitioom nnꞌaⁿ sꞌom tsꞌom castom ndoꞌ na jndye naⁿtya tꞌmaaⁿꞌ sꞌom cwitioomna. ");
INSERT INTO amuNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Mati tyjeꞌcañoom cwii yuscu na jnda̱ ljoñe. Jeeⁿcheⁿ ndyaꞌ jñeeⁿꞌñê. Tjacjoomꞌm we tsjo̱ꞌñjeeⁿ chjoo sꞌom wee na meiⁿchjoo titꞌmaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Chii tꞌmaⁿ Jesús nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê. Tsoom nda̱a̱na: —Na mayuuꞌcheⁿ nndyeꞌyoꞌ nntsjo̱o̱, yuscumꞌaaⁿꞌ tsꞌaⁿ na jnda̱ tueꞌ saaꞌ ndoꞌ jeeⁿ jñeeⁿꞌñê, sa̱a̱ tꞌmaaⁿꞌti tjoomꞌm tsꞌom castom, nchiiti chaꞌtso ntꞌomcheⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ee chaꞌtsondye naⁿmꞌaⁿꞌ tioomna sꞌom na cweꞌ waljooꞌ na cwileiꞌchona, sa̱a̱ jom meiiⁿ na jeeⁿcheⁿ ntyꞌiaaꞌñê, tjuꞌñꞌeeⁿ chaꞌwaati na maleiñꞌoom na nntseijnaaⁿ na nlcwaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Xjeⁿ na jaacaluiꞌ Jesús na waa watsꞌom tꞌmaⁿ seineiⁿ cwii tsꞌaⁿ na matseijomñe ñꞌeⁿñê, tso nnoom: —Maestro, cantyꞌiaꞌ, jeeⁿ tjacanjoomꞌ tsꞌiaaⁿ na tuii ñꞌeⁿ ljo̱ꞌmeiⁿꞌ ndoꞌ jeeⁿ neiⁿncooꞌ lꞌaameiⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Tsoom nnom tsaⁿꞌñeeⁿ: —Mayuuꞌ na jeeⁿ neiⁿncooꞌ lꞌaa na mantyꞌiaꞌ. Sa̱a̱ queⁿꞌ cwenta, ljo̱ꞌmeiⁿꞌ xocaljooꞌtyeⁿnaꞌ nacjoo ncꞌiaanaꞌ. Maxjeⁿ nntyuiiꞌñꞌeⁿnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Tyꞌena ta na jndyu Olivos ndyeyu yuu na meintyjeeꞌ watsꞌom tꞌmaⁿ. Joꞌ joꞌ tjacjoo Jesús. Ndoꞌ Pedro ñꞌeⁿ Jacobo, ñꞌeⁿ Juan ñꞌeⁿ Andrés tyꞌentyjaaꞌna jom cha nnda̱a̱ nlaꞌneiⁿna ñꞌeⁿñê na ñenquieena. Taꞌxꞌeena nnoom, jluena: ");
INSERT INTO amuNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Catsuꞌ nda̱a̱yâ, ¿cwaaⁿ nncueꞌntyjo̱ na nluii nmeiⁿꞌ? Ndoꞌ ¿cwaaⁿ ꞌnaaⁿ mꞌmo̱ⁿnaꞌ na manndyooꞌ nluii nmeiⁿꞌ? ");
INSERT INTO amuNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Quia joꞌ to̱ꞌ Jesús tyotseineiiⁿ nda̱a̱na: —Calꞌaꞌyoꞌ cwenta na meiⁿcwii tsꞌaⁿ tinquiuꞌnnꞌaⁿ ꞌo cantyja ꞌnaaⁿꞌ ñꞌoommeiⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ee nleitquiooꞌndye nnꞌaⁿ cwii cwii ntyja na nlaꞌcajndyundyena xueya ee nluena na joona cwiluiindyena Cristo. Ndoꞌ jndye nnꞌaⁿ nñeꞌquioꞌnnꞌaⁿna na ljoꞌ nlꞌana. ");
INSERT INTO amuNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","’Nntyꞌiaꞌyoꞌ na nndyocwjeꞌcañoom ntiaꞌ ndoꞌ nleicꞌuaa ñꞌoom na cwiluii ntiaꞌ cwiicheⁿ ntyja, sa̱a̱ tiñeꞌquiandyoꞌ na nlacatyuendyoꞌ, ee maxjeⁿ jndeiꞌnaꞌ na nmeiⁿꞌ nncwinomjndyee. Sa̱a̱ tyooweꞌntyjo̱ xjeⁿ na nntycwiiñꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nlaꞌwendye nnꞌaⁿ cwii ndyuaa nacjoo nnꞌaⁿ cwiicheⁿ ndyuaa. Ndoꞌ cwii tsaⁿmaⁿtsꞌiaaⁿ tꞌmaⁿ nntseiweñe nacjooꞌ cwiicheⁿ tsaⁿmaⁿtsꞌiaaⁿ. Jndye joo nntsꞌeii ndoꞌ nncꞌoom jndoꞌ tꞌmaⁿ ndoꞌ tꞌmaⁿ nntseiñꞌeeⁿꞌnaꞌ nnꞌaⁿ. Sa̱a̱ chaꞌtso nawiꞌmeiⁿꞌ cweꞌ weꞌyandyo laꞌxmaⁿnaꞌ. Quia nnquioo ntꞌomcheⁿ nawiꞌ na jaaꞌti. ");
INSERT INTO amuNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","’Sa̱a̱ ꞌo cꞌomꞌcꞌeendyoꞌ, ee mꞌaⁿ nnꞌaⁿ na nñeꞌquia cwenta ꞌo luee nnꞌaⁿ na cwiluiitquiendye naquiiꞌ lanꞌom ndoꞌ joona nntsa̱ꞌntjomna na catjaaꞌ nnꞌaⁿ ꞌo naquiiꞌ lanꞌom. Mati nlꞌa nnꞌaⁿ na jndeiꞌnaꞌ nncwintyjeꞌjnaⁿꞌyoꞌ jo nda̱a̱ gobiernom ñequio jo nda̱a̱ ntꞌomcheⁿ nnꞌaⁿ na cwitsa̱ꞌntjom ncꞌe na laxmaⁿꞌyoꞌ cantyja ꞌnaⁿya. Ndoꞌ na luaaꞌ nntjomꞌyoꞌ, nñequiaanaꞌ na ꞌo nntjeiꞌyuuꞌndyoꞌ ñꞌoom naya ꞌnaⁿya nda̱a̱ naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ee cwii tjo̱o̱cheⁿ na nntsuu tsjoomnancue nñeꞌquia nnꞌaⁿ ñꞌoom cantyja na macwjiꞌnꞌmaaⁿñe Tyꞌo̱o̱tsꞌom nnꞌaⁿ na chaꞌwaa tsjoomnancue. ");
INSERT INTO amuNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ndoꞌ quia na nntꞌuena ꞌo na nñeꞌquiana cwenta ꞌo, tincꞌomꞌyoꞌ ñomtiuu cwaaⁿ ñꞌoom na nnduꞌyoꞌ nda̱a̱ naⁿmanꞌiaaⁿ. Ee xjeⁿꞌñeeⁿ mꞌmo̱ⁿ Tyꞌo̱o̱tsꞌom cwaaⁿ ñꞌoom na nntꞌo̱ꞌyoꞌ. Ee nchii nlaneiⁿꞌyoꞌ ñꞌoom na nquiuꞌ ncjoꞌyoꞌ sa̱a̱ nquii Espíritu Santo nntsꞌaaⁿ naquiiꞌ nꞌomꞌyoꞌ ljoꞌ ñꞌoom na nnduꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Maxio tsꞌaⁿ nñequiaa cwenta jom na cueeⁿꞌeⁿ. Ndoꞌ majoꞌti nntsꞌaa tsꞌaⁿ ñꞌeⁿ ntseinaaⁿ. Ndoꞌ nda nnꞌaⁿ nlaꞌwendyena nacjoo lotyena, londyeena, nlꞌueendyena chiuu nncwje naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ndoꞌ chaꞌtsondye nnꞌaⁿ nlaꞌjndoona ꞌo ncꞌe na mꞌaⁿꞌyoꞌ cantyja ꞌnaⁿya. Sa̱a̱ juu tsꞌaⁿ na tyeⁿ cwiljooꞌñe ñꞌeⁿndyo̱ hasta na macanda̱, tsaⁿꞌñeeⁿ nluiꞌnꞌmaaⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","’ꞌÑeeⁿ juu tsꞌaⁿ na matseiꞌnaaⁿꞌ ñꞌoommeiiⁿ, catseiꞌno̱ⁿꞌ ljoꞌ ñecatsonaꞌ. Juu profeta Daniel, seiljeiⁿ ñꞌoom cantyja ꞌnaaⁿꞌ tsaⁿ na jeeⁿcheⁿ ndyaꞌ tiaaꞌ na nntseityuiiꞌ chaꞌtso. Quia na nntyꞌiaꞌyoꞌ na jnda̱ mameintyjeeⁿꞌeⁿ naquiiꞌ watsꞌom tꞌmaⁿ yuu na meiⁿchjoo ticatsa̱ꞌntjomnaꞌ na nncꞌoom, quia joꞌ ꞌo na mꞌaⁿꞌyoꞌ tsꞌo̱ndaa Judea catsaaleiꞌnomꞌyoꞌ quiiꞌ ntsjo̱. ");
INSERT INTO amuNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ndoꞌ majuu xjeⁿꞌñeeⁿ, tsꞌaⁿ na ljo nacjooꞌ waaꞌ yuu na su, ticandyocueeⁿ na nncjaaqueⁿꞌeⁿ na nncwjeeⁿꞌeⁿ ꞌnaaⁿꞌaⁿ. Catseityuaaⁿꞌaⁿ, caleiꞌnoom. ");
INSERT INTO amuNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ndoꞌ tsꞌaⁿ na mꞌaaⁿ jo jnda̱a̱ na machꞌee tsꞌiaaⁿ tyuaaꞌ, ticjaalcweeⁿꞌeⁿ na nncjaacachoom liaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Juu xjeⁿꞌñeeⁿ jeeⁿ wiꞌ nntjoom yolcu na ndeiindye ñequio joo yolcu na ꞌndaandye nda. ");
INSERT INTO amuNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Cataⁿꞌyoꞌ nnom Tyꞌo̱o̱tsꞌom na nchii xcwe ncuee na teiⁿ na nlcaⁿnaꞌ na caleiꞌnomꞌyoꞌ nawiꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ee quia ljoꞌcheⁿ nnquioo cwii nawiꞌ na tꞌmaⁿticheⁿ na meiⁿjom ndiiꞌ tyootjoom nnꞌaⁿ cantyjati na tqueⁿ Tyꞌo̱o̱tsꞌom tsjoomnancue hasta jeꞌ. Ndoꞌ xuee na cwiwjaatinaꞌ meiⁿ tajom cwinluiinndaꞌ cwiicheⁿ nawiꞌ chaꞌna juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Xeⁿ nchii nquii Ta Tyꞌo̱o̱tsꞌom tqueeⁿ na tijndyeti xuee nncꞌoom nawiꞌñeeⁿ, meiⁿcwii tsꞌaⁿ xocaluiꞌnꞌmaaⁿñe cantyja ꞌnaaⁿꞌnaꞌ. Sa̱a̱ ncꞌe na wiꞌ tsꞌoom joo nnꞌaⁿ na jnda̱ tjeiiꞌñê cwentaaⁿꞌaⁿ, joꞌ chii nntsꞌaaⁿ na tijndyeti xuee nncꞌoom nawiꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","’Ndoꞌ xeⁿ quia ljoꞌ nntso cwii tsꞌaⁿ nda̱a̱ꞌyoꞌ: “Cantyꞌiaꞌyoꞌ, ljoo mꞌaaⁿ Cristo”, oo nntso: “Cantyꞌiaꞌyoꞌ, laaꞌñeⁿ mꞌaaⁿ”, ticalayuꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ee maxjeⁿ nlquieꞌcañom profetas na tiyuuꞌ ñꞌoom cwiñequia ñequio nnꞌaⁿ na nlue na joona cwiluiindyena Cristo. Nlꞌana jndye nnom ꞌnaaⁿ tꞌmaⁿ ñequio tsꞌiaaⁿ tꞌmaⁿ na nncjaaweeꞌ nꞌom nnꞌaⁿ hasta nquiee nnꞌaⁿ na macwjiꞌ Tyꞌo̱o̱tsꞌom cwentaaⁿꞌaⁿ nñequioꞌnnꞌaⁿ tsꞌiaaⁿꞌñeeⁿ joona xeⁿ na nnda̱a̱ nlꞌana. Sa̱a̱ Tyꞌo̱o̱tsꞌom tixonquiaaⁿ na nnda̱a̱ nlꞌana. ");
INSERT INTO amuNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Chaꞌtso nmeiⁿꞌ jnda̱ tsjo̱o̱ nda̱a̱ꞌyoꞌ cwii tjo̱o̱cheⁿ na nluii cha calꞌaꞌyoꞌ cwenta. ");
INSERT INTO amuNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","’Ncuee quia na jnda̱ teinom nawiꞌ tꞌmaⁿꞌñeeⁿ, quia joꞌ nleijaaⁿñe ñeꞌquioomꞌ, ndoꞌ taxocwixueeñe chiꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Nntquiaandye cancjuu. Ndoꞌ chaꞌtso najnda̱ na matseixmaⁿ tsjo̱ꞌluee nntyuiiꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Quia ljoꞌcheⁿ nntyꞌiaa nnꞌaⁿ ja na cwiluiindyo̱ tsaⁿ na jnaⁿ cañoomꞌluee na macwja̱caño̱o̱ⁿnndaꞌa tsjoomnancue. Nndyo̱o̱ naquiiꞌ nchquiu ñequio najndeii na matseixmaⁿya ndoꞌ ñequio na neiⁿncooꞌ nacaxuee na matseitꞌmaaⁿꞌñenaꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Njño̱o̱ⁿya ángeles ꞌnaⁿya na cꞌoona cwii cwii ntyjaaꞌ tsjoomnancue ndoꞌ mati ndiocheⁿ cañoomꞌluee na nlaꞌtjomna nnꞌaⁿ na jnda̱ tjeiiꞌndyo̱ cwentaya. ");
INSERT INTO amuNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","’Calaꞌno̱ⁿꞌyoꞌ ꞌnaaⁿ na maꞌmo̱ⁿnaꞌ nda̱a̱ꞌyoꞌ cantyja ꞌnaaⁿꞌ tsꞌoom higuera. Quia na cwintyꞌiaꞌyoꞌ na cwinteiꞌ lꞌo̱naꞌ ndoꞌ cwicandeiꞌ tscoꞌndaa juunaꞌ, quia joꞌ cwilaꞌno̱ⁿꞌyoꞌ na jaawindyooꞌ ncueesuaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Majoꞌti quia na cwintyꞌiaꞌyoꞌ na cwiluii chaꞌtso nmeiⁿꞌ na jnda̱ tsjo̱o̱ nda̱a̱ꞌyoꞌ, quia joꞌ calaꞌno̱ⁿꞌyoꞌ na jnda̱ teitsio̱o̱ꞌ mꞌaaⁿnaꞌ. Mawaa mawaa xjeⁿ nncwja̱caño̱o̱ⁿnndaꞌa. ");
INSERT INTO amuNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Candyeꞌyoꞌ nntsjo̱o̱, mayuuꞌcheⁿ na xocwjeñꞌeⁿ nnꞌaⁿ na mꞌaⁿ jeꞌ hasta xjeⁿ na jnda̱ seicanda̱a̱ꞌñenaꞌ chaꞌtso ñꞌoommeiⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Tsjo̱ꞌluee ñꞌeⁿ tsjoomnancue nntycwiiñꞌeⁿnaꞌ sa̱a̱ ñꞌoom ꞌnaⁿya maxjeⁿ nntseicanda̱a̱ꞌñenaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","’Sa̱a̱ meiⁿcwii tsꞌaⁿ ticaljeii cwaaⁿ xuee ndoꞌ ꞌñeeⁿ xjeⁿ na nluii chaꞌtso nmeiⁿꞌ. Meiⁿ ángeles na mꞌaⁿ cañoomꞌluee ticaliuna, meiⁿ ja na cwiluiindyo̱ Jnda Tyꞌo̱o̱tsꞌom ticaljeiiya cwaaⁿ. Macanda̱ ñenquiicheⁿ Tsotya̱ya ntyjeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","’Joꞌ chii cꞌomꞌcꞌeendyoꞌ ndoꞌ queⁿꞌyoꞌ cwenta. Ndoꞌ calaneiⁿꞌyoꞌ nnom Tyꞌo̱o̱tsꞌom, ee ticaliuꞌyoꞌ cwaaⁿ nncueꞌntyjo̱ tiempoꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nmeiⁿꞌ matseijomnaꞌ chaꞌna machꞌee cwii tsꞌaⁿ na wjaa cwii ndyuaa na tquia. Cwii tjo̱o̱cheⁿ na nnaaⁿ waⁿꞌaⁿ, nntyꞌioom tsꞌiaaⁿ mosoomꞌm, cwii cwii nnom tsꞌiaaⁿ na cwii cwiindyena. Ndoꞌ nntsa̱ꞌntjoom tsꞌaⁿ na machꞌee cwenta ꞌndyootsꞌa na ñeꞌquiiꞌcheⁿ catsꞌaa cwenta. ");
INSERT INTO amuNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Malaaꞌtiꞌ matseijomnaꞌ ꞌo ee na ticaliuꞌyoꞌ ꞌñeeⁿ xjeⁿ na nncwjeeꞌ nquii na matsa̱ꞌntjom ꞌo. ¿Aa nncwjeeⁿꞌeⁿ natmaaⁿ, oo aa nateijaaⁿ? ¿Aa nncwjeeⁿꞌeⁿ xcwe tsjom, oo aa na jaancoo? Joꞌ chii cꞌomꞌcꞌeendyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ee ticatsonaꞌ na matsꞌia joꞌ nncwjeeⁿꞌeⁿ ndoꞌ nljeiiⁿ ꞌo chaꞌcwijom na cwindaꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ñꞌoom na jnda̱ tsjo̱o̱ luaaꞌ nda̱a̱ꞌyoꞌ, juunaꞌ matsjo̱o̱ nda̱a̱ꞌyoꞌ na chaꞌtsondyoꞌ, ñeꞌquiiꞌcheⁿ cꞌomꞌcꞌeendyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","We xuee cwii tjo̱o̱ na nncueeꞌ xuee pascua ñequio xuee na cwicwaꞌ nnꞌaⁿ ntyooꞌ na tjaa ndaaljoꞌ tjaquieeꞌ. Ndoꞌ ntyee na cwiluiitquiendye ñequio nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés, tyolꞌueendyena chiuu nlꞌayoona na nñeꞌquioꞌnnꞌaⁿna Jesús cha nntꞌuena jom, ndoꞌ na nlaꞌcueeꞌna jom. ");
INSERT INTO amuNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Jlaꞌtiuuna, jluena nda̱a̱ ntyjeena: —Sa̱a̱ ticatꞌua̱a̱ya jom xcwe ncuee, tintsꞌaanaꞌ na nlaꞌwendye nnꞌaⁿ nacjooya. ");
INSERT INTO amuNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Tyomꞌaaⁿ Jesús tsjoom Betania, waaꞌ Simón, tsꞌaⁿ na ñechuu tycu lepra. Yocheⁿ na meindyuaandyena nacañoomꞌ meiⁿsa, tueꞌcañoom cwii yuscu na maleiꞌñꞌoom cwii tsioo na tuii ñꞌeⁿ tsjo̱ꞌ canchiiꞌ na jndyu alabastro. Ñjom ncheⁿꞌ na jndyu nardo na jeeⁿ cachi, ndoꞌ jeeⁿ jndanaꞌ. Tyjeeⁿ yuu na ta̱ꞌtyeⁿ tsiooꞌñeeⁿ, chii tuꞌnquioom ncheⁿꞌñeeⁿ xqueⁿ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ntꞌom nnꞌaⁿ na mꞌaⁿ joꞌ joꞌ jlaꞌliooꞌndyena nacjooꞌ yuscuꞌñeeⁿ. Jluena nda̱a̱ ntyjeena: —Jeeⁿ ndyaꞌ cweꞌchi ncheⁿꞌ ꞌnaaⁿꞌaⁿ na seicatsoom. ");
INSERT INTO amuNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Yati xeⁿ teilꞌuanaꞌ ee nncwinom ndyee siaⁿnto denarios nncwjiꞌnaꞌ. Sꞌomꞌñeeⁿ nnluii naya ndyeñeeⁿꞌ. Jnaaⁿꞌ luaaꞌ na tyolaꞌwjeena yuscuꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Sa̱a̱ tso Jesús: —Caꞌndyeꞌyoꞌ tsaⁿmꞌaaⁿꞌ. ¿Chiuu na cwilaꞌliooꞌndyoꞌ ñꞌeⁿñê? Ee jeeⁿ tjacañjoomꞌ nayawaaꞌ na sꞌaaⁿ ñꞌeⁿndyo̱. ");
INSERT INTO amuNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ee ja nchii ñequiiꞌcheⁿ nncꞌo̱o̱ⁿya ñꞌeⁿndyoꞌ. Sa̱a̱ ndyeñeeⁿꞌ ñequiiꞌcheⁿ na mꞌaⁿna quiiꞌntaaⁿꞌyoꞌ ndoꞌ quia na ñeꞌcalꞌaꞌyoꞌ naya joona, wanaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Yuscumꞌaaⁿꞌ sꞌaaⁿ cwanti na nnda̱a̱ nntsꞌaaⁿ. Jom tuꞌnquioom ncheⁿꞌ nacjoya cwii tjo̱o̱cheⁿ na nntꞌiuu nnꞌaⁿ ja. ");
INSERT INTO amuNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Na mayuuꞌcheⁿ nndyeꞌyoꞌ nntsjo̱o̱, meiⁿyuucheⁿ na nñeꞌquia nnꞌaⁿ ñꞌoom chaꞌwaa tsjoomnancue na macwjiꞌnꞌmaaⁿñe Tyꞌo̱o̱tsꞌom nnꞌaⁿ, maxjeⁿ nlaꞌneiⁿna cantyja ꞌnaaⁿꞌ naya na sꞌaa yuscumꞌaaⁿꞌ cha ticatsuu ñꞌoom cantyja ꞌnaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Jnda̱ tuii na luaaꞌ, quia joꞌ Judas Iscariote, cwindye nnꞌaⁿ na canchooꞌwendye, tjaaⁿ na mꞌaⁿ ntyee na cwiluiitquiendye na nntseijndaaꞌñê ñequio joona na nñequiaaⁿ cwenta Jesús lueena. ");
INSERT INTO amuNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Jnda̱ na jndye naⁿꞌñeeⁿ na ljoꞌ nntsꞌaaⁿ tquiaanaꞌ na jeeⁿ neiiⁿna. Tꞌmaⁿna na nñeꞌquiana sꞌom nnoom. Quia joꞌ Judas tyolꞌueeꞌñetyeeⁿ chiuu ya nntsꞌaaⁿ na nñequiaaⁿ cwenta Jesús lueena. ");
INSERT INTO amuNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Quia joꞌ xuee na cwiwityeⁿ ncuee na cwicwaꞌ nnꞌaⁿ judíos tyooꞌ na tjaa ndaaljoꞌ tjaquieeꞌ, mañejuu xuee na cwilaꞌcwjeena canmaⁿ nchꞌu, nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿ Jesús taꞌxꞌeena nnoom, jluena: —¿Yuu lꞌue tsꞌomꞌ na nntsaalajndaaꞌndyô̱ cantyja ꞌnaaⁿꞌ xuee pascua, na nleiñꞌoomꞌ na nlquiꞌ catsmaⁿ chjoo? ");
INSERT INTO amuNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ndoꞌ jñoom we nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê cwii lꞌaa. Tsoom nda̱a̱na: —Catsaꞌquieꞌyoꞌ quiiꞌ tsjoom. Joꞌ joꞌ nliuꞌyoꞌ cwii tsaⁿsꞌa na maleiñꞌoom cwii tsjoo ndaatioo. Catsaantyjo̱ꞌyoꞌ naxeeⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Yuu na nncjaaqueⁿꞌeⁿ canduꞌyoꞌ nnom tsꞌaⁿ na waaꞌ: “Luaa matso nqueⁿ na matsa̱ꞌntjoom jaa: ¿yuu waa cuarto na nlcwaaꞌa na nntseitꞌmaaⁿꞌndyo̱ xuee pascua ñequio nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿndyo̱?” ");
INSERT INTO amuNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Juu tsaⁿꞌñeeⁿ mꞌmo̱o̱ⁿ cwii cuarto tꞌmaⁿ wꞌaa nandye teicantyjooꞌ. Maniom canda̱a̱ꞌ ꞌnaⁿ na macaⁿnaꞌ na nncuaa xuee. Joꞌ calajndaaꞌndyoꞌ nantquie na nlcwaaꞌa ñꞌeⁿndyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ndoꞌ tyꞌe we naⁿꞌñeeⁿ. Quia na tquiena tsjoomꞌñeeⁿ jliuna chaꞌxjeⁿ na jnda̱ tsoom nda̱a̱na. Joꞌ joꞌ jlaꞌjndaaꞌndyena nantquie na nlcwaꞌna na nlaꞌtꞌmaaⁿꞌndyena xuee pascua. ");
INSERT INTO amuNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Cweꞌ tmaaⁿya, xjeⁿ na tyjeꞌcañoom Jesús ñequio nnꞌaⁿ canchooꞌwe na cwilaꞌjomndye ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Yocheⁿ na meindyuaandyena nacañoomꞌ meiⁿsa na cwicwaꞌna, tso Jesús nda̱a̱na: —Mayuuꞌcheⁿ candyeꞌyoꞌ nntsjo̱o̱, cwiindyoꞌ ꞌo na macwaꞌ ñꞌeⁿndyo̱ nñequiaa cwenta ja luee nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ñꞌoomwaaꞌ jeeⁿ ndyaꞌ seichjooꞌnaꞌ nꞌomna. To̱ꞌna cwii ndoꞌ cwiindyena taꞌxꞌeena nnoom, jluena: —¿Aa ndyaꞌ nntsꞌaanaꞌ na ja? ");
INSERT INTO amuNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Quia joꞌ tsoom nda̱a̱na: —Cwii ꞌo na canchooꞌwendyoꞌ, cwii tsꞌaⁿ na cwinchjeendyô̱ tyooꞌ ñꞌeⁿñe tsꞌom xio jom nñequiaaⁿ cwenta ja. ");
INSERT INTO amuNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ee na mayuuꞌcheⁿ, ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee, maxjeⁿ wjaañꞌoomnaꞌ ja na nncꞌio̱ chaꞌxjeⁿ na matso ljeii ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom. Sa̱a̱ jeeⁿ ntyꞌiaaꞌñe tsꞌaⁿ na mañequiaa cwenta ja, yaticheⁿ xeⁿ tîcaluiiñe tsaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Yocheⁿ na cwicwaꞌna, toꞌñom Jesús tyooꞌ, tquiaaⁿ na quianlꞌuaaꞌ Tyꞌo̱o̱tsꞌom. Jnda̱ joꞌ tyjeeⁿ juunaꞌ, tquiaaⁿ nda̱a̱na. Tsoom: —Catoꞌñoomꞌyoꞌ, cwaꞌyoꞌ tyooꞌwaa, ee cwiluiiñenaꞌ seiiꞌa. ");
INSERT INTO amuNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Mati toꞌñoom cwii waso na ñjom ndaa winom. Jnda̱ na tquiaaⁿ na quianlꞌuaaꞌ Tyꞌo̱o̱tsꞌom, quia joꞌ tquiaaⁿ juunaꞌ nda̱a̱na, chaꞌtsondyena ta̱na. ");
INSERT INTO amuNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ndoꞌ tsoom nda̱a̱na: —Ndaa winomwaa cwiluiiñenaꞌ nioomꞌa na nnquioo na nncwjiꞌnꞌmaaⁿndyo̱ jndyendye nnꞌaⁿ. Ñꞌeⁿ juunaꞌ maqua̱ⁿtya̱ⁿya ñꞌoom xco. ");
INSERT INTO amuNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Candyeꞌyoꞌ nntsjo̱o̱ na mayuuꞌcheⁿ taxocꞌuanndaꞌa winom hasta juu xuee na nncꞌuaxco̱ juunaꞌ quia na nntsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ndoꞌ jnda̱ na tana luantsa, jluiꞌna joꞌ joꞌ. Tyꞌena ta Olivos. ");
INSERT INTO amuNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Quia joꞌ tso Jesús nda̱a̱na: —Tsjom jeꞌ chaꞌtsondyoꞌ ꞌo nntjeiꞌndyoꞌ ñꞌeⁿndyo̱. Ee ljeii ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom matsonaꞌ: “Nntseicua̱ꞌa tsꞌaⁿ na machꞌee cwenta canmaⁿ, ndoꞌ canmaⁿ ntsmeiiⁿꞌeⁿ nntꞌoomꞌndyeyoꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Sa̱a̱ tso Jesús: —Ndoꞌ ja quia jnda̱ na mawando̱ꞌxco̱ nncjo̱jndya̱a̱ tsꞌo̱ndaa Galilea, xeⁿ jnda̱ nntsaantyjo̱ꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Quia joꞌ tso Pedro nnoom: —Meiiⁿ chaꞌtsondye naⁿmꞌaⁿꞌ nntjeiiꞌndyena ñꞌeⁿndyuꞌ, sa̱a̱ ja tijoom cwjiꞌndyo̱ ñꞌeⁿndyuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Tꞌo̱ Jesús, tsoom nnom: —Ñꞌoom na mayuuꞌ matsjo̱o̱ njomꞌ, tsjom jeꞌ cwii tjo̱o̱cheⁿ na nnda̱a̱ꞌ we ndiiꞌ na matseixuaa caxtijndyo, sa̱a̱ ꞌu xjeⁿꞌñeeⁿ jnda̱ ndyee ndiiꞌ jnda̱ tjeiꞌndyuꞌ ñꞌeⁿndyo̱. ");
INSERT INTO amuNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Sa̱a̱ Pedro yacheⁿ jndeiiꞌ ñꞌoom tꞌo̱o̱ⁿ: —Meiiⁿ cꞌio̱ ñꞌeⁿndyuꞌ, sa̱a̱ tijoom cwjiꞌndyo̱ cantyja ꞌnaⁿꞌ. Ndoꞌ chaꞌtso ncꞌiaaⁿꞌaⁿ majoꞌti jluena. ");
INSERT INTO amuNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Quia joꞌ tquiena cwii joo na jndyu Getsemaní. Tsoom nda̱a̱na: —Cwindyuaandyoꞌ ñjaaⁿñe yocheⁿ na jo̱ luaaꞌ na nntseina̱ⁿya nnom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Joꞌ chii tjatyeeⁿ, tjañꞌoom Pedro ñꞌeⁿ Jacobo ñꞌeⁿ Juan. Ndoꞌ jnaⁿnaꞌ na tꞌmaⁿ matseiꞌndaaꞌnaꞌ ntyjeeⁿ ndoꞌ jeeⁿ matseichjooꞌnaꞌ tsꞌoom. ");
INSERT INTO amuNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Tsoom nda̱a̱ naⁿꞌñeeⁿ: —Jeeⁿ matseichjooꞌnaꞌ tsꞌo̱o̱ⁿ hasta jom ndyoweꞌ tsꞌo̱o̱ⁿ. Caljooꞌndyoꞌ ljooñe. Cꞌomꞌcꞌeendyoꞌ, nchii cwindaꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Quia joꞌ tjatjatyeeⁿcheⁿ, tjacwanquioom nomtyuaa. Tyocaaⁿ nnom Tyꞌo̱o̱tsꞌom xeⁿ wanaaⁿ tintjoom nawiꞌ na meiⁿndooꞌnaꞌ jom juu xjeⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Tsoom: —Tsotya̱ya, ꞌu chaꞌtso nnda̱a̱ nntsaꞌ. Catseicandyaandyuꞌ ja na ticwino̱o̱ⁿya nawiꞌwaa. Sa̱a̱ catsaꞌ chaꞌxjeⁿ na lꞌue tsꞌomꞌ nncuꞌ nchii chaꞌxjeⁿ na lꞌue tsꞌo̱o̱ⁿ ja. ");
INSERT INTO amuNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Quia joꞌ jndyolcweꞌ Jesús na mꞌaⁿ ndyee naⁿꞌñeeⁿ. Ndoꞌ ljeiiⁿ na cwindana. Tsoom nnom Pedro: —Aa ndiꞌ Simón, ¿aa waꞌtsuꞌ? ¿Aa maxjeⁿ tîcanda̱a̱ nntsaꞌ na ticatsuꞌ meiⁿ ñeꞌcwii hora? ");
INSERT INTO amuNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ñequiiꞌcheⁿ cꞌomꞌcꞌeendyoꞌ na calaneiⁿꞌyoꞌ nnom Tyꞌo̱o̱tsꞌom cha ticjaachuunaꞌ ꞌo quia na ñeꞌcatsꞌaanaꞌ xjeⁿ ꞌo. Jeeⁿ mꞌaaⁿcꞌeeꞌ tsꞌom tsꞌaⁿ na nntsꞌaa yuu na ya, sa̱a̱ ncꞌe na tsꞌaⁿ tseixmaⁿ, tileicanaaⁿñe na nntsꞌaa na ljoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Jnda̱ joꞌ cwiicheⁿ ndiiꞌ tjannaaⁿꞌaⁿ. Mañejooti ñꞌoom seineiiⁿ nnom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Quia na jndyolcweꞌnnaaⁿꞌaⁿ na mꞌaⁿna, majoꞌti ljeiiⁿ na cwindana, ee jeeⁿ tyeⁿ waa na maleichuu tsaⁿtsjom joona. Ndoꞌ meiⁿ cweꞌ ticaliuna ljoꞌ nluena nnoom. ");
INSERT INTO amuNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tjannaaⁿꞌaⁿ na nntseineiiⁿ nnom Tyꞌo̱o̱tsꞌom ndoꞌ quia tyjeeⁿꞌeⁿ na jnda̱ ndyee ndiiꞌ na mꞌaⁿna, tsoom nda̱a̱na: —Cwa ndicwaⁿ cwindaꞌyoꞌ na cwitaꞌjndyeeꞌyoꞌ. Maleiꞌtyeⁿ. Jnda̱ tueꞌntyjo̱ xjeⁿ ꞌnaⁿya. Jeꞌ manntꞌue nnꞌaⁿ na wiꞌndye ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Quicantyjaꞌyoꞌ. Cjaaya. Luaaꞌ mandyocwjeeꞌcañoom juu tsꞌaⁿ na tjacatio cwenta ja luee nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ndicwaⁿ matseineiⁿ Jesús ndoꞌ tyjeeꞌcañoom Judas, cwii joo nnꞌaⁿ na canchooꞌwendye. Ñꞌeeⁿ cwii tmaaⁿꞌ nnꞌaⁿ ñꞌeⁿñê na cwileiꞌcho ncjo espadas ñequio nꞌoom nchꞌio. Naⁿꞌñeeⁿ nnꞌaⁿ ꞌnaaⁿ ntyee na cwiluiitquiendye, ñequio nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés ñequio nnꞌaⁿ na cwiluiitquiendye naquiiꞌ tsjoom. ");
INSERT INTO amuNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ndoꞌ Judas, tsꞌaⁿ na tquiaa cwenta jom luee naⁿꞌñeeⁿ, jnda̱ tꞌmo̱o̱ⁿ ꞌnaaⁿ nda̱a̱na chiuu nntsꞌaaⁿ. Tsoom: —Juu tsꞌaⁿ na nncꞌua ntsmaⁿꞌ, majom joꞌ. Tyeⁿ catꞌueꞌyoꞌ jom ndoꞌ tsaañꞌomꞌyoꞌ jom. Calꞌaꞌyoꞌ cwenta na ticalacanomꞌyoꞌ jom. ");
INSERT INTO amuNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ndoꞌ quia tquieꞌcañomna Jesús, mantyja seicandyooꞌñê, tsoom nnom Jesús: —Xmaⁿndyuꞌ Maestro. Ndoꞌ tꞌom ntsmaⁿꞌ tsaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Quia joꞌ jlaꞌcjaa lueena Jesús. Tyeⁿ tꞌuena jom. ");
INSERT INTO amuNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Cwii tsꞌaⁿ na matseijomñe ñꞌeⁿ Jesús na meintyjeeꞌ joꞌ tjeiiⁿꞌeⁿ xjo espada ꞌnaaⁿꞌaⁿ. Tioom juunaꞌ mosooꞌ nquii tyee na cwiluiitquieñe. Jno̱ⁿ tsuaꞌqui. ");
INSERT INTO amuNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ndoꞌ tso Jesús nda̱a̱na: —Jndaꞌjom tquioꞌcatꞌueꞌyoꞌ ja chaꞌcwijom tquioꞌyoꞌ nacjooꞌ cwii tsaⁿcanchꞌue na choꞌyoꞌ ncjo espadas ñꞌeⁿ nꞌoom nchꞌio. ");
INSERT INTO amuNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ꞌIo ndii ꞌio ñetꞌo̱o̱ⁿya quiiꞌntaaⁿꞌyoꞌ na ñetꞌmo̱o̱ⁿya nda̱a̱ꞌyoꞌ naquiiꞌ watsꞌom tꞌmaⁿ sa̱a̱ tîcatꞌueꞌyoꞌ ja. Ñecuaa ee cwiluii na luaaꞌ cha catseicanda̱a̱ꞌñenaꞌ ljeii ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom na waa. ");
INSERT INTO amuNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Quia joꞌ chaꞌtsondye nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿ Jesús, jleiꞌnomna, ꞌndyena jom na ñenqueⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ndoꞌ joꞌ joꞌ mꞌaaⁿ cwii tsaⁿsꞌandyua na tjantyjo̱o̱ⁿ naxeⁿꞌ Jesús. Macanda̱ chuꞌtyjooñê cwii sábana. Mati jom tꞌue naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Sa̱a̱ jom jeꞌ jluiiꞌñê naquiiꞌ sábana ꞌnaaⁿꞌaⁿ, ꞌñeeⁿ juunaꞌ, jleiꞌnoom na ñecaseiꞌñê. ");
INSERT INTO amuNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Quia joꞌ tyꞌeñꞌomna Jesús jo nnom nquii tyee na cwiluiitquieñe nda̱a̱ ntyjentyeeñe. Joꞌ joꞌ tjomndye chaꞌtsondye ntyee na cwiluiitquiendye ñequio nnꞌaⁿ na cwiluiitquiendye naquiiꞌ tsjoom ñequio nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés. ");
INSERT INTO amuNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ndoꞌ Pedro tquiacheⁿ tquia tjantyjo̱o̱ⁿ. Macanda̱ tueeꞌtyeeⁿ tachꞌeeⁿꞌ waaꞌ tyee na cwiluiitquieñe. Joꞌ joꞌ tjacjom nacañoom nnꞌaⁿ na cwindyeꞌntjom watsꞌom tꞌmaⁿ. Tyotseiwiñê ꞌndyoo chom. ");
INSERT INTO amuNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Quia joꞌ ntyee na cwiluiitquiendye ñequio chaꞌtsondye naⁿmanꞌiaaⁿ cwentaa nnꞌaⁿ judíos tyolꞌueena nnꞌaⁿ na calue ñꞌoom cantu nacjooꞌ Jesús cha nnda̱a̱ nleijndaaꞌ jnaaⁿꞌaⁿ na cueeⁿꞌeⁿ. Sa̱a̱ tileicaliuna. ");
INSERT INTO amuNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ee majndye nnꞌaⁿ tyꞌenquia ñꞌoom na cweꞌ cantu sa̱a̱ tiñecwii ñꞌoom tquiana joꞌ chii ticaluiꞌyuuꞌ ñꞌoomꞌñeeⁿ nacjoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Jnda̱ joꞌ teiꞌcantyja ntꞌomcheⁿ nnꞌaⁿ na tquia cwiicheⁿ ñꞌoom na tiyuuꞌ nacjoomꞌm, jluena: ");
INSERT INTO amuNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Jâ jndya̱a̱yâ na tso tsaⁿmꞌaaⁿꞌ na jom nntseityueeⁿꞌeⁿ watsꞌom tꞌmaⁿwaa na lꞌa nnꞌaⁿ, ndoꞌ ñendyee xuee nntsꞌaaxcoom cwiicheⁿ na nchii nnꞌaⁿ nlꞌa. ");
INSERT INTO amuNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Sa̱a̱ meiiⁿ jluena ñꞌoomwaaꞌ, maxjeⁿ ticatjoomꞌ ñꞌoom. ");
INSERT INTO amuNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Quia joꞌ teintyjeeꞌ nquii tyee na cwiluiitquieñe xcwe quiiꞌ ntaaⁿna, taxꞌeeⁿ ꞌndyoo Jesús, tsoom: —¿Aa maxjeⁿ meiⁿcwii ñꞌoom ticꞌo̱ꞌ? ¿Chiuu waayuu cantyja ꞌnaaⁿꞌ ñꞌoom na cwitueeꞌna nacjoꞌ? ");
INSERT INTO amuNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Sa̱a̱ Jesús ñemaaⁿꞌcheeⁿ mꞌaaⁿ. Meiⁿcwii ñꞌoom ticꞌo̱o̱ⁿ. Quia joꞌ juu tyee na cwiluiitquieñe taxꞌeeñennaaⁿꞌaⁿ, tsoom: —¿Aa ꞌu cwiluiindyuꞌ Cristo, Jnda nquii Tyꞌo̱o̱tsꞌom na cwilaꞌtꞌmaaⁿꞌndyô̱? ");
INSERT INTO amuNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Tꞌo̱ Jesús, tsoom: —Mayuuꞌ na joꞌ ja. Ndoꞌ nntyꞌiaꞌyoꞌ ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee na nncwaꞌcatya̱ⁿ ntyjaaꞌ Tyꞌo̱o̱tsꞌom ntyjaya na jom matseixmaⁿñꞌeeⁿ chaꞌtso nnom najnda̱ na nndyo̱cua̱ya, na nnaaⁿ cañoomꞌluee ñequio nchquiu. ");
INSERT INTO amuNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Quia joꞌ juu tyee na cwiluiitquieñe jndiiꞌñê tscaꞌnnoom na lioomꞌm, tsoom: —¿Aa cwimacaⁿtinaꞌ ꞌñeeⁿ nñequiotjeiꞌyuuꞌndyeti jnaaⁿꞌaⁿ? ");
INSERT INTO amuNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ꞌO macwindyeꞌyoꞌ ñꞌoom ntjeiⁿ na matseineiiⁿ nacjooꞌ Tyꞌo̱o̱tsꞌom. ¿Chiuu cwilatiuuꞌyoꞌ ñꞌeⁿñê? Ndoꞌ chaꞌtsondyena ñeꞌcwii jlaꞌjomndyena na waa jnaaⁿꞌaⁿ ndoꞌ tseixmaaⁿ na cueeⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Cwantindyena to̱ꞌna na tyojñomna ndaajnaⁿꞌ jom. Jlaꞌcata̱ꞌna nnoom, tyotmeiiⁿꞌna ndaꞌ jom, jluena: —Cjaaweeꞌ ꞌndyoꞌ ꞌñeeⁿ tquiaa ꞌu. Mati nnꞌaⁿ na cwilꞌa cwenta watsꞌom tyoñeꞌquiana ndaꞌ watmeiiⁿ nnoom. ");
INSERT INTO amuNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Yocheⁿ na mꞌaaⁿ Pedro jo nacje, tachꞌeⁿ wꞌaaꞌñeeⁿ, tjantyjaaꞌ cwii yuscu jom na mandiꞌntjom nnom tyee na cwiluiitquieñe. ");
INSERT INTO amuNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Quia na ljeiiⁿ Pedro na matseiwiñe ꞌndyoo chom, quiee tyontyꞌiaaⁿꞌaⁿ tsaⁿꞌñeeⁿ. Tsoom: —ꞌU mati ñeñꞌeⁿꞌ ñꞌeⁿ Jesús, tsꞌaⁿ tsjoom Nazaret. ");
INSERT INTO amuNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Sa̱a̱ tjeiꞌñe Pedro, tsoom: —Ja ticwajnaⁿꞌa tsaⁿꞌñeeⁿ. Meiⁿchjoo ticaljeiiya ñꞌoom na matsuꞌ luaaꞌ. Jnda̱ joꞌ teiño̱o̱ⁿ nacañoom nnꞌaⁿ, tjaaⁿ yuu waa ꞌndyootsꞌatiom. Xjeⁿꞌñeeⁿ mana seixuaa caxtijndyo. ");
INSERT INTO amuNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ndoꞌ majuu yuscu na mandiꞌntjom, cwiicheⁿ cwii ndiiꞌ ntyꞌiaaꞌnnaaⁿꞌaⁿ Pedro. To̱o̱ⁿꞌo̱ⁿ na tsonnaaⁿꞌaⁿ nda̱a̱ nnꞌaⁿ na mꞌaⁿ joꞌ joꞌ: —Tsaⁿmꞌaaⁿꞌ maxjeⁿ cwiindye joona jom. ");
INSERT INTO amuNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ndoꞌ Pedro tjeiꞌñennaaⁿꞌaⁿ. Ndoꞌ tiyocheⁿ majluenndaꞌ nnꞌaⁿ na meintyjeeꞌ joꞌ joꞌ nnoom: —Mayuuꞌcheⁿ cwiluiindyuꞌ cwii joona. Tsꞌaⁿ Galilea ꞌu ee ljoꞌyu ñꞌoom na matseiꞌneiⁿꞌ chaꞌna cwilaꞌneiⁿ joona. ");
INSERT INTO amuNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Quia joꞌ to̱o̱ⁿꞌo̱ⁿ na tjuꞌ cheⁿnqueⁿ ñꞌomwiꞌ nacjoomꞌm, ndoꞌ tsoom na ntyjiicheⁿ Tyꞌo̱o̱tsꞌom na mayomꞌm. Tsoom: —Meiⁿchjoo ticwajnaⁿꞌa tsꞌaⁿ na cwinduꞌyoꞌ luaaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ndoꞌ mañoomꞌ seixuaa caxtijndyo na jnda̱ we ndiiꞌ. Quia joꞌ tjañjoomꞌ tsꞌom Pedro ñꞌoom na tso Jesús nnoom: “Cwii tjo̱o̱cheⁿ na nntseixuaa caxtijndyo we ndiiꞌ, sa̱a̱ ꞌu jeꞌ jnda̱ ndyee ndiiꞌ macwjiꞌndyuꞌ cantyja ꞌnaⁿya.” Ndoꞌ quia tjañjoomꞌ tsꞌoom ñꞌoommeiⁿꞌ, jeeⁿ ndyaꞌ tyotyꞌioom. ");
INSERT INTO amuNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ndoꞌ na jaawixuee ntyee na cwiluiitquiendye tjomndyena ñequio nnꞌaⁿ na cwiluiitquiendye naquiiꞌ tsjoom ñequio nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés ñequio chaꞌtso naⁿmanꞌiaaⁿ cwentaa nnꞌaⁿ judíos. Jlaꞌjndaaꞌndyena. Jnda̱ joꞌ jlaꞌtyeⁿna Jesús, tyꞌeñꞌomna jom. Tyꞌecatioona cwenta jom lꞌo̱ Pilato. ");
INSERT INTO amuNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ndyeyu taxꞌee Pilato nnoom, tso: —¿Aa ꞌu cwiluiindyuꞌ rey cwentaa nnꞌaⁿ judíos? Ndoꞌ tꞌo̱o̱ⁿ: —Majoꞌndyo chaꞌxjeⁿ na matsuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ndoꞌ ntyee na cwiluiitquiendye jndye jnaaⁿꞌaⁿ tquiana. ");
INSERT INTO amuNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Quia joꞌ taxꞌeenndaꞌ Pilato nnoom, tso: —¿Aa maxjeⁿ meiⁿcwii ñꞌoom xocꞌo̱ꞌ? Queⁿꞌ cwenta na jndye jnaⁿꞌ cwiluena nacjoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Sa̱a̱ tjaa na tꞌo̱ti Jesús hasta tquiaanaꞌ na jeeⁿ tyomꞌaaⁿꞌ tsꞌom Pilato. ");
INSERT INTO amuNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ndoꞌ ticwii chu na cwiweeꞌ xuee pascua waa costumbre na matseicandyaañe Pilato meiⁿcwiꞌñeeⁿcheⁿ pra̱so na lꞌue nꞌom nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Quia ljoꞌcheⁿ mꞌaaⁿ cwii tsꞌaⁿ na jndyu Barrabás wꞌaancjo ñequio ntꞌomcheⁿ pra̱so. Joona jlaꞌwendyena nacjooꞌ gobiernom, ndoꞌ jlaꞌcwjeena nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Tyꞌentyjaaꞌ cwii tmaaⁿꞌ nnꞌaⁿ na mꞌaaⁿ Pilato. To̱ꞌna na tyotaⁿna na catsꞌaaⁿ chaꞌxjeⁿ quichꞌeeⁿ na nntseicandyaañê cwii tsꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Quia joꞌ tso Pilato nda̱a̱na: —¿Aa lꞌue nꞌomꞌyoꞌ na catseicandyaandyo̱ juu rey cwenta ꞌo nnꞌaⁿ judíos? ");
INSERT INTO amuNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Luaaꞌ tsoom ee jnda̱ seiꞌno̱o̱ⁿꞌo̱ⁿ na joo ntyee na cwiluiitquiendye ta̱a̱ꞌ nꞌomna Jesús, joꞌ na tyꞌecatioona tsaⁿꞌñeeⁿ lꞌo̱o̱ⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ndoꞌ joona tyolaꞌjndo̱ꞌna nꞌom nnꞌaⁿ na jndyendye na cataⁿna nnom Pilato na catseicandyaañê Barrabás, nchii Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Quia joꞌ taxꞌeenndaꞌ Pilato nda̱a̱ nnꞌaⁿ na jndyendye, tsoom: —Ndoꞌ ¿ljoꞌ lꞌue nꞌomꞌyoꞌ na catsꞌaaya ñꞌeⁿ juu tsꞌaⁿ na cwinduꞌyoꞌ na cwiluiiñe rey cwentaꞌ ꞌo nnꞌaⁿ judíos? ");
INSERT INTO amuNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Tacwaxua ndyueena, jluena: —Catyꞌiomꞌ jom tsꞌoomꞌnaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Taxꞌee Pilato nda̱a̱na: —¿Ljoꞌ jeeⁿ tisꞌa sꞌaaⁿ nquiuꞌyoꞌ? Sa̱a̱ joona ñeꞌquiiꞌcheⁿ najndeii tyolaꞌxuaana, jluena: —Catyꞌiomꞌ jom tsꞌoomꞌnaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Quia joꞌ Pilato, cweꞌ ee na lꞌue tsꞌoom na calue nnꞌaⁿ na ya tsꞌaⁿñê, joꞌ na seicandyaañê Barrabás. Ndoꞌ sa̱ꞌntjoom na catjaaꞌ sondaro Jesús ñꞌeⁿ tjaⁿtseiꞌ. Jnda̱ joꞌ tquiaaⁿ juu lueena na catyꞌioomna juu tsꞌoomꞌnaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ndoꞌ tyꞌeñꞌom sondaroꞌñeeⁿ Jesús naquiiꞌcheⁿ watsꞌiaaⁿ cwentaaꞌ gobiernom. Joꞌ joꞌ tjomndye chaꞌtso ncꞌiaana. ");
INSERT INTO amuNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Jlaꞌcweena cwii liaa colo catsiooꞌ jom. Tyolaꞌtyjoondyena lꞌo̱o̱ nioom, lꞌana cwii tsei, tioomna juunaꞌ xqueeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Jnda̱ joꞌ to̱ꞌna, ndooꞌ na cwilaꞌtꞌmaaⁿꞌndyena jom, jluena: —Catseitꞌmaaⁿꞌñenaꞌ ꞌu na cwiluiindyuꞌ rey cwentaa nnꞌaⁿ judíos. ");
INSERT INTO amuNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ndoꞌ tyotmeiiⁿꞌna tsꞌoom xqueeⁿ. Tyojñomna ndaajnaⁿꞌ jom, tyotaꞌna cantyena jo nnoom chaꞌcwijom cwilaꞌtꞌmaaⁿꞌndyena jom. ");
INSERT INTO amuNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Quia na jnda̱ jlaꞌjnaaⁿꞌñꞌeⁿna jom, quia joꞌ tjeiiꞌna liaa catsiooꞌ. Jlaꞌcweenndaꞌna jom liaⁿꞌaⁿ. Jnda̱ joꞌ tyꞌeñꞌomna jom na nntyꞌioomna jom tsꞌoomꞌnaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Xcwe na cwiꞌoocaluiꞌna naquiiꞌ tsjoom ndoꞌ tjomndyena tsꞌaⁿ tsjoom Cirene na jndyu Simón na jnaⁿ jnda̱a̱. Jom tsotye Alejandro ñequio Rufo. Lꞌa sondaro na jndeiꞌnaꞌ cjaañꞌoom tsꞌoom na nñoom Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Quia joꞌ tyꞌeñꞌomna Jesús Gólgota. Ñꞌoomwaaꞌ maꞌmo̱ⁿnaꞌ cwii ta na jndyunaꞌ Tseiꞌxqueⁿ Tsꞌoo. ");
INSERT INTO amuNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ndoꞌ tquiana winom na nncꞌom na tjoomꞌnaꞌ ñequio mirra. Sa̱a̱ jom tîcoꞌñoom juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Jnda̱ chii tyꞌioomna jom tsꞌoomꞌnaaⁿ. Ndoꞌ sondaro tyoꞌoona xꞌiaa, cha nntyꞌiaana cwaaⁿ liaⁿꞌaⁿ nleijnoomꞌ cwii cwii joona. Laaꞌtiꞌ tꞌoomna liaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Jnda̱ tueeꞌ chaꞌna ñjeeⁿ nacwitsjoom quia tyꞌioomna jom tsꞌoomꞌnaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ndoꞌ jnaaⁿꞌaⁿ na teiljeii luaa matsonaꞌ: “Rey cwenta nnꞌaⁿ judíos.” ");
INSERT INTO amuNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Mati tyꞌioomna we naⁿcantyꞌue nacjoo noomꞌnaaⁿ. Cwii tsaⁿꞌñeeⁿ ntyjaaⁿꞌaⁿ ntyjaya ndoꞌ cwiicheⁿ tsaⁿꞌñeeⁿ ntyjatymaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ndoꞌ na lꞌana na ljoꞌ, seicanda̱a̱ꞌñenaꞌ na matso ljeii ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom: “Seicañꞌeⁿyuunaꞌ jom quiiꞌntaaⁿ nnꞌaⁿ na wiꞌndye.” ");
INSERT INTO amuNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Nnꞌaⁿ na tyowinom joꞌ joꞌ, tyolaꞌjnaaⁿꞌna jom. Tyolaꞌcaandyena nqueⁿna, tyoluena: —ꞌU jeꞌ, na nntseityuiꞌ watsꞌom tꞌmaⁿ ꞌnaaⁿyâ ndoꞌ ñendyee xuee nntseiweꞌnndaꞌ juunaꞌ, ");
INSERT INTO amuNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","cwjiꞌnꞌmaaⁿndyuꞌ cheⁿnncuꞌ. Candyoꞌcueꞌ na ñoomꞌ tsꞌoomꞌnaaⁿwaaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mati ntyee na cwiluiitquiendye ñequio nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés malaaꞌtiꞌ tyolaꞌjnaaⁿꞌna jom. Jluena: —Jeeⁿ ya ñetjeiꞌnꞌmaaⁿñe tsaⁿmꞌaaⁿꞌ ntꞌomcheⁿ nnꞌaⁿ sa̱a̱ tileicanda̱a̱ nncwjiꞌnꞌmaaⁿñe cheⁿnqueⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Jom na matsoom na cwiluiiñê Cristo ndoꞌ Rey cwentaa jaa nnꞌaⁿ Israel, cwa candyocueeⁿ na ñoom tsꞌoomꞌnaaⁿ cha nntyꞌiaaya quia joꞌ nlayuuꞌa ñꞌeⁿñê. Ndoꞌ mati we nnꞌaⁿ na ñom noomꞌnaaⁿ ñꞌeⁿñê tyolaꞌjnaaⁿꞌna jom. ");
INSERT INTO amuNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Quia na jnda̱ tueeꞌ na quiajmeiⁿꞌ, teijaaⁿñe tsjoomnancue hasta na ndyee na matmaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Juu xjeⁿꞌñeeⁿ jndeii seixuaa Jesús, tsoom: —Eloi, Eloi, ¿lama sabactani? (Ñꞌoommeiiⁿ matsonaꞌ: Tyꞌo̱o̱tsꞌomya, Tyꞌo̱o̱tsꞌomya, ¿chiuu na maꞌndiiꞌ ja?) ");
INSERT INTO amuNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Ntꞌom nnꞌaⁿ na meintyjeeꞌ nndyooꞌ nacañomꞌm, quia jndyena na seixuaⁿ, jluena: —Aa ndyeꞌyoꞌ, macwaaⁿ profeta Elías. ");
INSERT INTO amuNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Quia joꞌ jleinom cwii tsꞌaⁿꞌñeeⁿ, jndyoñꞌoom cwii ꞌnaⁿ na ya mawꞌanaꞌ ndaa. Nchjeeñê juunaꞌ naquiiꞌ winom na ta̱. Tjaaꞌñê juunaꞌ nnom cwii tsꞌoom, chii tyꞌioom juunaꞌ ꞌndyoo Jesús na cateiiꞌñe. Tsoom: —Cwa jeꞌ nntyꞌiaaya aa nncwjeeꞌcañoom Elías na nncwjiiꞌñe jom na ñoom tsꞌoomꞌnaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Jnda̱ na seixuaa Jesús jndeii mana tueeⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ndoꞌ liaa na ntyjatyꞌio na matseicuꞌnaꞌ yuu na ljuꞌti naquiiꞌcheⁿ watsꞌom tꞌmaⁿ, jndiiꞌtconaꞌ hasta xjeⁿ nomtyuaacheⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Juu capeitaⁿ na meintyjeeꞌ ndyeyu jo nnom Jesús, quia jñeeⁿ na seixuaa ndoꞌ ntyꞌiaaⁿꞌaⁿ na luaaꞌ tuii na tueꞌ tsaⁿꞌñeeⁿ, quia joꞌ tsoom: —Mayuuꞌcheⁿ tsaⁿmꞌaaⁿꞌ cwiluiiñê Jnda Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Mati joꞌ joꞌ meintyjeeꞌtquia ntꞌom yolcu na jeeⁿ cwintyꞌiaa na ljoꞌ tuii. Quiiꞌntaaⁿ joona mꞌaaⁿ María Magdalena ñequio Salomé ñequio cwiicheⁿ María, tsondyee José ñꞌeⁿ Jacobo, tsaⁿ na titquieñeti. ");
INSERT INTO amuNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Joo yolcumꞌaⁿꞌ tyocañꞌeeⁿna ñꞌeⁿ Jesús quia ñetꞌoom tsꞌo̱ndaa Galilea. Tyondyeꞌntjomna nnoom. Ndoꞌ mati joꞌ joꞌ meintyjeeꞌ jndye ntꞌomcheⁿ yolcu na jnaⁿ Galilea na ñencwi tquiowana Jerusalén ñꞌeⁿ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Tmaaⁿndye nnꞌaⁿ joꞌ joꞌ. Ndoꞌ juu xjeⁿꞌñeeⁿ xuee na cwilaꞌjndaaꞌndye nnꞌaⁿ jndíos ꞌnaⁿ na nlcaⁿnaꞌ joona ee jnda̱ jnaⁿnaꞌ xuee na nntaꞌjndyeena. ");
INSERT INTO amuNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Mati joꞌ joꞌ mꞌaaⁿ cwii tsꞌaⁿ tsjoom Arimatea na jndyu José. Jom tꞌmaⁿ cwiluiiñê naquiiꞌ tmaaⁿꞌ naⁿmanꞌiaaⁿ cwentaa nnꞌaⁿ judíos. Jeeⁿ meinomꞌm xuee na nntyꞌiaaꞌnnoom na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. Ndoꞌ ncꞌe na jnda̱ jaamaaⁿ chii tjaaⁿ na mꞌaaⁿ Pilato. Tyꞌoomtꞌmaaⁿꞌñê tsꞌoom tjacaaⁿ seiꞌtsꞌo ꞌnaaⁿꞌ Jesús nnom tsaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Jeeⁿ seitsaⁿꞌnaꞌ Pilato quia na jñeeⁿ na tyuaaꞌ tueꞌ Jesús. Ee ntyjeeⁿ yo cwiñom nnꞌaⁿ noomꞌnaaⁿ ndoꞌ cwiwjena. Joꞌ chii tqueeⁿꞌñê capeitaⁿ, taxꞌeeñê ꞌndyoo tsaⁿꞌñeeⁿ aa maxjeⁿ jnda̱ tueꞌ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ndoꞌ quia na jñeeⁿ ñꞌoom ꞌndyoo capeitaⁿ na mayuuꞌ na ljoꞌ, quia joꞌ tquiaaⁿ ñꞌoomꞌm na cjaañꞌoom José seiꞌtsꞌo ꞌnaaⁿꞌ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Quia joꞌ tjatseijnda José cwii sábana ya, jnda̱ joꞌ tjacatyjeeñê seiꞌtsꞌo ꞌnaaⁿꞌ Jesús, seityjooñê liaaꞌñeeⁿ juu, ndoꞌ tjacatyꞌioom juu naquiiꞌ tsueꞌtsjo̱ꞌ na tuiiya. Jnda̱ chii seicuuꞌñê ꞌndyoo tsueꞌtsjo̱ꞌ ñequio cwii tsjo̱ꞌ tꞌmaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ndoꞌ María Magdalena ñequio María, tsondyee José, ntyꞌiaana na tjacantꞌiuuꞌñe Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Jnda̱ na tjacue ñeꞌquioomꞌ juu xuee na cwitaꞌjndyee nnꞌaⁿ judíos, tja María Magdalena ñequio Salomé ñequio María, tsondyee Jacobo, tyꞌelaꞌjndana ncheⁿꞌ cachi na nncꞌoocatyꞌoomndyena seiꞌtsꞌo ꞌnaaⁿꞌ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ndoꞌ cwitsjoomya xuee najndyee smanaⁿ manluiꞌnom ñeꞌquioomꞌ, tyꞌena yuu waa tseiꞌtsuaaꞌ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Nato ñjomndyena tyoluecheⁿnquieena nda̱a̱ ntyjeena: —¿ꞌÑeeⁿ ya nnteijndeii jaa na nnquindyo̱ tsjo̱ꞌ ꞌndyoo tseiꞌtsuaa? ");
INSERT INTO amuNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Sa̱a̱ quia na jnda̱ tquiena joꞌ, jleintyꞌiaana, jliuna cwa jnda̱ teindyo̱ tsjo̱ꞌ. Ndoꞌ juunaꞌ jeeⁿ tꞌmaⁿnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ndoꞌ jnda̱ na tyꞌequieꞌna quiiꞌ tseiꞌtsuaaꞌñeeⁿ, ntyꞌiaana chaꞌcwijom cwii tsaⁿsꞌandyua wacatyeeⁿ ntyjaya. Cweⁿ cwii liaatco, liaa canchiiꞌ. Jeeⁿ ndyaꞌ nioom tyuena. ");
INSERT INTO amuNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Tso tsaⁿꞌñeeⁿ nda̱a̱na: —Tintyueꞌyoꞌ. ꞌO cwilꞌueꞌyoꞌ Jesús na jnaⁿ Nazaret, jom na tyꞌioom nnꞌaⁿ tsꞌoomꞌnaaⁿ. Jnda̱ tandoꞌxcoom na tueeⁿꞌeⁿ. Tacꞌoomñê ñjaaⁿ. Cantyꞌiaꞌyoꞌ yuu na tqueⁿna jom. ");
INSERT INTO amuNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Jeꞌ catsaꞌyoꞌ na mꞌaaⁿ Pedro ñequio ntꞌomcheⁿ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿ Jesús. Calacandiiꞌyoꞌ joona na nncjaajñeeⁿ Galilea, jnda̱nquia nncꞌoontyjo̱na. Joꞌ joꞌ nleicwindyena ñꞌeⁿñê chaꞌxjeⁿ jnda̱ tsoom nda̱a̱ꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Quia joꞌ jluiꞌna naquiiꞌ tseiꞌtsuaa. Jndeii tyꞌelcweeꞌna ndoꞌ cwiteindyena, ndooꞌ nquiuna na tanchii joona. Ndoꞌ cweꞌ na jeeⁿ tyuena, joꞌ na seitsaⁿꞌnaꞌ joona, meiⁿ tîcaluena nnom meiⁿcwii tsꞌaⁿ chiuu tuii. ");
INSERT INTO amuNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Mañejuuti cwitsjoom xuee najndyee smanaⁿ quia na jnda̱ tandoꞌxco Jesús, najndyee teitquiooꞌñê nnom María Magdalena, tsaⁿ na tjeiiⁿꞌeⁿ ntquieeꞌ jndyetia naquiiꞌ tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ndoꞌ Maríaꞌñeeⁿ tjatseicañeeⁿ nquiee nnꞌaⁿ na tyocañꞌeeⁿ ñꞌeⁿ Jesús. Xjeⁿꞌñeeⁿ jeeⁿ xcwe na mꞌaⁿna na chjooꞌ nꞌomna ndoꞌ cwityueena. ");
INSERT INTO amuNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Sa̱a̱ quia jndyena na Jesús jnda̱ mawaꞌndoꞌxcoom, ndoꞌ juu yuscuꞌñeeⁿ jnda̱ ntyꞌiaaꞌnnom jom, maxjeⁿ tîcalaꞌyuꞌna. ");
INSERT INTO amuNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Jnda̱nquia teitquiooꞌñe Jesús nda̱a̱ we nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê na cwiꞌoo nato jnda̱a̱, sꞌaanaꞌ na cwiicheⁿ ljo waaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ndoꞌ tyꞌelcweeꞌ naⁿꞌñeeⁿ Jerusalén, tyꞌelaꞌcandiina ncꞌiaana. Sa̱a̱ meiiⁿ ñꞌomndyuee joona, tjaa ꞌñeeⁿ seiyuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Jnda̱ joꞌ teitquiooꞌñê nda̱a̱ canchooꞌcwii nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê yocheⁿ na cwimeindyuaandyena nacañoomꞌ meiⁿsa na cwicwaꞌna. Ncꞌe na tiñeꞌcalaꞌyuꞌya nꞌomna, joꞌ na seitiaaⁿꞌaⁿ joona na quieꞌ nꞌomna. Ee tîcalaꞌyuꞌna na jnda̱ wandoꞌxcoom meiiⁿ na jlaꞌcandii nnꞌaⁿ na jnda̱ ntyꞌiaanda̱a̱ jom. ");
INSERT INTO amuNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Xjeⁿꞌñeeⁿ tsoom nda̱a̱na: —Catsaꞌyoꞌ chaꞌwaa tsjoomnancue, nñeꞌquiaꞌyoꞌ ñꞌoom naya nda̱a̱ chaꞌtso nnꞌaⁿ na macwjiꞌñꞌmaaⁿñe Tyꞌo̱o̱tsꞌom joona. ");
INSERT INTO amuNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Juu tsꞌaⁿ na nntseiyuꞌ ndoꞌ nleitsꞌoomñe, nluiꞌnꞌmaaⁿñe. Sa̱a̱ juu tsꞌaⁿ na ticatseiyuꞌ, maxjeⁿ nntꞌuiityeⁿnaꞌ juu cantyja jnaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ndoꞌ nnꞌaⁿ na cwilaꞌyuꞌ jndye tsꞌiaaⁿ tꞌmaⁿ nlꞌana. Ñequio xueya nntjeiiꞌna jndyetia naquiiꞌ nꞌom nnꞌaⁿ, ndoꞌ nlaꞌneiⁿna ntꞌomcheⁿ nnom ñꞌoom na tjachuiiꞌ. ");
INSERT INTO amuNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Xeⁿ nntꞌuena canduu ñequio lueena oo xeⁿ nncwena nasei wjee, tjaaꞌnaⁿ ljoꞌ nntjoomna. Ndoꞌ quia na nntioona lueena nacjoo nnꞌaⁿwii, nnꞌmaaⁿ naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Quia na jnda̱ teinom na seineiⁿ Ta Jesús nda̱a̱ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê, tjañꞌoomnaꞌ jom cañoomꞌluee. Tjacjom ntyjaaꞌ tsꞌo̱ Tyꞌo̱o̱tsꞌom ntyjaya yuu na matseitꞌmaaⁿꞌñenaꞌ jom. ");
INSERT INTO amuNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Quia joꞌ jnaⁿ naⁿꞌñeeⁿ tyꞌena, tyoñeꞌquiana ñꞌoom naya nda̱a̱ nnꞌaⁿ meiⁿyuucheⁿ na tyꞌena. Ndoꞌ manquiiti Ta Jesús tyoteijneiⁿ joona. Tquiaaⁿ na tyocanda̱a̱ tyolꞌana tsꞌiaaⁿ tꞌmaⁿ na tjeiꞌyuuꞌndyenaꞌ na mayuuꞌ ñꞌoom na tyoñeꞌquiana. Amén.");
INSERT INTO amuNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Na mꞌaaⁿꞌ ꞌu Teófilo, na jeeⁿ ya tsꞌaⁿndyuꞌ, matseiljeiya ñꞌoommeiiⁿ. Majndye nnꞌaⁿ jnda̱ jlaꞌljeii ñꞌoom cantyja ꞌnaaⁿꞌ Jesús chiuu waa na mayuuꞌcheⁿ na jnda̱ tuii quiiꞌntaaⁿyâ. ");
INSERT INTO amuNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Jlaꞌljeiina ñꞌoomꞌñeeⁿ chaꞌxjeⁿ ñꞌoom na toꞌño̱o̱ⁿyâ na tquia nnꞌaⁿ na ntyꞌiaanda̱a̱ chiuu waa na tuii xjeⁿ na jnaⁿcheⁿnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Jaachꞌee xuee mañjom tsꞌo̱o̱ⁿya chaꞌtso na tuii. Jeꞌ machꞌeenaꞌ tsꞌo̱o̱ⁿ na mati ja nntseiljeitcuundyo̱ ñꞌoomwaa na nntseiꞌnaⁿꞌ, ");
INSERT INTO amuNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","cha catseiꞌno̱ⁿꞌ na mayuuꞌ ñꞌoom na jnda̱ tꞌmo̱o̱ⁿ nnꞌaⁿ njomꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ncuee quia tyomꞌaaⁿ Herodes tsaⁿmaⁿtsꞌiaaⁿ tꞌmaⁿ tsꞌo̱ndaa Judea, tyomꞌaaⁿ cwii tyee cwentaa nnꞌaⁿ judíos na jndyu Zacarías. Jom tyocañꞌeeⁿ ñꞌeⁿ tmaaⁿꞌ ntyee na seicajndyunaꞌ Abías. Scoomꞌm jndyu Elisabet, cwii tsꞌaⁿ tsjaaⁿ Aarón. ");
INSERT INTO amuNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Wendye joona, tyolꞌana na matyꞌiomyanaꞌ jo nnom Tyꞌo̱o̱tsꞌom. Meiⁿcwii na chaꞌtso ñꞌoom na matsa̱ꞌntjom Ta Tyꞌo̱o̱tsꞌom tîcwiꞌnomꞌna, tyolaꞌcanda̱na juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Sa̱a̱ tjaaꞌnaⁿ ndana ee Elisabet tîcꞌoom jnaaⁿ. Ndoꞌ jeeⁿ jnda̱ tquiendyena. ");
INSERT INTO amuNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Quia na tueꞌcañoomnaꞌ tmaaⁿꞌ ntyee na ñꞌeⁿ Zacarías na nndyeꞌntjomna jo nnom Tyꞌo̱o̱tsꞌom naquiiꞌ watsꞌom tꞌmaⁿ, ");
INSERT INTO amuNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","chaꞌxjeⁿ na waa ñꞌoom nda̱a̱ ntyee, tyoꞌoona xꞌiaa, ꞌñeeⁿ nleijnoomꞌ na nncjaaquieeꞌ naquiiꞌ watsꞌom tꞌmaⁿ cwentaaꞌ Tyꞌo̱o̱tsꞌom. Zacarías teijnoomꞌm na nncjaaqueⁿꞌeⁿ na nntsꞌaaⁿ tsioom suu. Quia joꞌ tjaqueⁿꞌeⁿ ndoꞌ to̱o̱ⁿꞌo̱ⁿ na matseicoom suu. ");
INSERT INTO amuNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Yocheⁿ na machꞌeeⁿ tsioom suu jndye nnꞌaⁿ mꞌaⁿ tachꞌeeⁿꞌ watsꞌom tꞌmaⁿ na cwilaꞌneiⁿ nnom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Xjeⁿꞌñeeⁿ teitquiooꞌñe cwii ángel cwentaaꞌ Tyꞌo̱o̱tsꞌom nnoom. Meintyjeeꞌ ángelꞌñeeⁿ ntyjaaꞌ tio ntyjaya yuu na cwico suu. ");
INSERT INTO amuNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Seiñꞌeeⁿꞌnaꞌ Zacarías quia na ntyꞌiaaⁿꞌaⁿ juu. Jeeⁿ seicatyꞌuenaꞌ jom. ");
INSERT INTO amuNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Sa̱a̱ tso ángel nnoom: —Tintyꞌueꞌ, Zacarías. Majnda̱ jndii Tyꞌo̱o̱tsꞌom ñꞌoom na macaⁿꞌ. Ndoꞌ scuꞌ Elisabet nntseincueⁿ yuꞌndaa ndaꞌyoꞌ. Ndoꞌ nntseicajndyuꞌ juu Juan. ");
INSERT INTO amuNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Cantyja ꞌnaaⁿꞌ juu nñequiaanaꞌ na jeeⁿ neiⁿꞌ ndoꞌ nncjaaweeꞌ tsꞌomꞌ. Mati jndye nnꞌaⁿ nncꞌomna na jeeⁿ neiiⁿna na nluiiñê. ");
INSERT INTO amuNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ee jom tꞌmaⁿ nntseixmaaⁿ jo nnom Tyꞌo̱o̱tsꞌom. Tixocꞌom winom meiⁿ nta na wjeeti. Ndoꞌ chaꞌwaa naquiiꞌ tsꞌoom nncꞌoom Espíritu Santo meiiⁿ na ndi njoom tsꞌom tsiaaꞌ tsoñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Cantyja ꞌnaaⁿꞌ jom jndyendye nnꞌaⁿ tsjaaⁿ Israel nlcweꞌ nꞌomna jo nnom Ta Tyꞌo̱o̱tsꞌom cwentaana. ");
INSERT INTO amuNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Jom nndyojñeeⁿ jo nnom Ta Jesucristo cwii tjo̱o̱cheⁿ na nndyo. Ndoꞌ nndiꞌntjoom nnom ñequio najndeii na ñejndiꞌntjom Elías. Nntsꞌaaⁿ na caljoya nꞌom nnꞌaⁿ ñꞌeⁿ ndana cha nnꞌaⁿ na cwilaꞌquieꞌ nꞌom, nnquiooꞌ nꞌomna cantyja na jndo̱ꞌ nꞌom nnꞌaⁿ na cwilꞌa yuu na matyꞌiomyanaꞌ. Luaaꞌ nntsꞌaaⁿ cha nntseijndaaꞌñeyanaꞌ naquiiꞌ nꞌom nnꞌaⁿ na nncꞌom cwentaaꞌ Ta Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Quia joꞌ tso Zacarías nnom ángel: —¿Chiuu nntsꞌaayuunaꞌ na luaaꞌ nluii? Ee ja luaa jnda̱ tquiendyo̱ ndoꞌ mati scuya jnda̱ tquieñê. ");
INSERT INTO amuNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Tꞌo̱ ángel nnoom, tso: —Ja jndyuya Gabriel na mandiꞌntjo̱ⁿya nnom Tyꞌo̱o̱tsꞌom. Jom jñoom ja na catseicandiiya ꞌu ñꞌoom nayameiiⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Sa̱a̱ queⁿꞌ cwenta, jeꞌ nnta̱ꞌ na matseiꞌneiⁿꞌ jnaaⁿꞌ na ticatseiyuꞌ ñꞌoom na matsjo̱o̱ njomꞌ. Ndoꞌ nnaaⁿnndaꞌ na nntseineiⁿꞌ juu xuee quia na nntseicanda̱a̱ꞌñenaꞌ ñꞌoomwaaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ndoꞌ joo nnꞌaⁿ na tyomeindooꞌ Zacarías, jeeⁿ tyomꞌaaⁿꞌ nꞌomna chiuu waa na jeeⁿ yo tjaqueⁿꞌeⁿ naquiiꞌ watsꞌom tꞌmaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Sa̱a̱ quia na jlueeⁿꞌeⁿ taleicatseineiiⁿ, joꞌ na jlaꞌno̱ⁿꞌna na waa na tcoꞌnaꞌ ntyꞌiaaⁿꞌaⁿ naquiiꞌ watsꞌom. Cweꞌ tyotsꞌo̱o̱ lꞌo̱o̱ⁿ nda̱a̱na. Ee jnda̱ ta̱ꞌ na matseineiiⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Quia na jnda̱ jnda̱a̱ꞌ xuee na mandiꞌntjoom naquiiꞌ watsꞌom tꞌmaⁿ, tjalcweeⁿꞌeⁿ waⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Jnda̱nquia teitquiooꞌ na jndeiiñe scoomꞌm Elisabet. Tyomꞌaaⁿcheⁿ tsaⁿꞌñeeⁿ wꞌaana cwii ꞌom chiꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Quia joꞌ tso juu Elisabet: “Luaa naya machꞌee Ta Tyꞌo̱o̱tsꞌom ñꞌeⁿndyo̱. Seijndaaꞌñê na cantycwii na cwicaluiꞌjnaaⁿꞌndyo̱ jo nda̱a̱ nnꞌaⁿ na tjaaꞌnaⁿ jndaaya.” ");
INSERT INTO amuNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Joꞌ joꞌ chiꞌ na jnda̱ yom na teitquiooꞌñe ángel Gabriel nnom Zacarías, ndoꞌ majñomnndaꞌ Tyꞌo̱o̱tsꞌom jom cwiicheⁿ tsjoom na jndyu Nazaret, tsꞌo̱ndaa Galilea ");
INSERT INTO amuNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","na mꞌaaⁿ cwii yuscundyua na jndyu María, tsaⁿꞌñeeⁿ mawaa ñomcaaⁿꞌaⁿ ñequio cwii tsaⁿsꞌa na jndyu José tsjaaⁿ David. ");
INSERT INTO amuNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Jnda̱ tjaquieeꞌ ángel yuu na mꞌaaⁿ, tso nnoom: —Xmaⁿndyuꞌ, ꞌu na tꞌmaⁿti naya na macandaꞌ. Nquii Tyꞌo̱o̱tsꞌom mꞌaaⁿñê ñꞌeⁿndyuꞌ. Quiiꞌntaaⁿ chaꞌtso ntyjelcuꞌ, ꞌu matioꞌnaaⁿñetyeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ndoꞌ María quia na jñeeⁿ ñꞌoommeiⁿꞌ, jeeⁿ seiñꞌeeⁿꞌñenaꞌ jom ndoꞌ jeeⁿ tyomꞌaaⁿꞌ tsꞌoom ljoꞌ maꞌmo̱ⁿ ñꞌoommeiⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Quia joꞌ tso ángel nnoom: —María, tintyꞌueꞌ. Ee ꞌu tꞌmaⁿ naya jnda̱ teijnomꞌ na macandaꞌ jo nnom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Luaa nluii, nndeiindyuꞌ ndoꞌ nntseincuiꞌ cwii tyochjoo ndoꞌ nntseicajndyuꞌ juu Jesús. ");
INSERT INTO amuNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Jom nluiitꞌmaⁿñê. Nntseicajndyunaꞌ jom Jnda nquii Tyꞌo̱o̱tsꞌom na mꞌaaⁿ nandyeticheⁿ. Ndoꞌ nñequiaaⁿ na nluiiñe rey chaꞌxjeⁿ ñeseixmaⁿ David na tyotsa̱ꞌntjom. ");
INSERT INTO amuNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Maxjeⁿ nljotyeⁿ na nntsa̱ꞌntjoom ntseindacantyjo Jacob, ndoꞌ tijoom cantycwii cantyja na nntsa̱ꞌntjoom. ");
INSERT INTO amuNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Tso María nnom ángel: —¿Chiuu nntsꞌaayuunaꞌ na nluii na luaaꞌ? Ee tyoomꞌaaⁿya ñꞌeⁿ tsaⁿsꞌa. ");
INSERT INTO amuNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Quia joꞌ tꞌo̱ ángel nnoom, tso: —Juu Espíritu Santo nntsꞌaaⁿ cwii tsꞌiaaⁿ tꞌmaⁿ ñꞌeⁿndyuꞌ. Ndoꞌ juu na jndeii na matseixmaⁿ nquii Tyꞌo̱o̱tsꞌom na mꞌaaⁿ nandyeticheⁿ, nncꞌoomnaꞌ ñꞌeⁿndyuꞌ. Ee joꞌ na nluiiñe yuꞌndaa na ljuꞌ tsꞌom, ndoꞌ nntseicajndyunaꞌ juu Jnda nquii Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ndoꞌ queⁿꞌ cwenta, mati nomnnꞌaⁿꞌ Elisabet meiiⁿ na jnda̱ tquieñê majndeiiñê cwii tyochjoo. Jeꞌ chiꞌ na jnda̱ yom na jndeiiñê. Ndoꞌ jom tsꞌaⁿ na cwilue nnꞌaⁿ na tileicꞌoom jnda. ");
INSERT INTO amuNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ee tjaaꞌnaⁿ cwii nnom na xocanda̱a̱ nntsꞌaa Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ndoꞌ tso María nnom ángel: —Ja tsꞌaⁿ mandiꞌntjomtyeⁿ nnom Ta Tyꞌo̱o̱tsꞌom. Catsꞌaanaꞌ ñꞌeⁿndyo̱ chaꞌxjeⁿ ñꞌoom na jnda̱ tsuꞌ. Quia joꞌ mana jluiꞌ ángel na mꞌaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Jnda̱ joꞌ seijndaaꞌñe María, seityuaaⁿꞌaⁿ tjaaⁿ. Tjaaⁿ cwii tsjoom naquiiꞌ ntsjo̱ tsꞌo̱ndaa Judá. ");
INSERT INTO amuNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Tueⁿꞌeⁿ waaꞌ Zacarías. Tjaqueⁿꞌeⁿ ndoꞌ tquiaaⁿ na xmaⁿñe Elisabet. ");
INSERT INTO amuNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Jnda̱ na jndii Elisabet jndyeeꞌ María na tquiaa na xmaⁿñê, quia joꞌ seijndeii yuꞌndaa tsꞌom tsiaⁿꞌaⁿ. Ndoꞌ xjeⁿꞌñeeⁿ tjaquieeꞌ Espíritu Santo chaꞌwaa naquiiꞌ tsꞌoom. ");
INSERT INTO amuNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ndoꞌ jndeii seineiiⁿ, tsoom: —Quiiꞌntaaⁿ chaꞌtsondye tyja̱a̱lcuuya, ꞌu na matioꞌnaaⁿñeti Tyꞌo̱o̱tsꞌom. Ndoꞌ matioꞌnaaⁿñê yuꞌndaa na njom tsꞌom tsiaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Sa̱a̱ ja, ¿ꞌñeeⁿ cwiluiindyo̱ na jndaꞌjom nncuꞌ na cwiluiindyuꞌ tsondyee quii Ta na matsa̱ꞌntjom ja tyjeeꞌcañoomꞌ jndyocandoꞌ ja? ");
INSERT INTO amuNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ee quia na jndiiya na matsuꞌ na xmaⁿndyo̱, quia joꞌ mantyjacheⁿ seijndeii yuꞌndaa tsꞌom tsiaya na neiiⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Matioꞌnaaⁿñe Tyꞌo̱o̱tsꞌom ꞌu. Ee matseiꞌyuꞌ na nntseicanda̱a̱ꞌñenaꞌ ñꞌoom na seicañeeⁿ ꞌu, na tso ángel njomꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Quia joꞌ tso María: Ñequio na xcweeꞌ tsꞌo̱o̱ⁿ matseitꞌmaaⁿꞌndyo̱ Ta Tyꞌo̱o̱tsꞌom, ");
INSERT INTO amuNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ndoꞌ neiiⁿꞌ tsꞌo̱o̱ⁿya jom, ee cwiluiiñê na macwjiꞌnꞌmaaⁿñê ja. ");
INSERT INTO amuNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Ee tyꞌoom na wiꞌ tsꞌoom ñꞌeⁿndyo̱, meiiⁿ tsꞌaⁿ na cweꞌ cwantindyo ja na mandiꞌntjo̱ⁿtya̱ⁿ nnoom. Ndoꞌ jeꞌ jeꞌ, xuee na cwii wjaanaꞌ, chaꞌtsondye nnꞌaⁿ tsjaaⁿ na wjaawicantyjooꞌ nluena na matioꞌnaaⁿñê ja. ");
INSERT INTO amuNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Ee nqueⁿ na chaꞌtso najndeii matseixmaaⁿ, tꞌmaⁿ naya jnda̱ sꞌaaⁿ ñꞌeⁿndyo̱. Jom ljuꞌ cwiluiiñê, ndoꞌ maxjeⁿ joꞌ joꞌ xueⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Chaꞌwaa na ndyowanaꞌ, mꞌaaⁿ na wiꞌ tsꞌoom chaꞌtsoti nnꞌaⁿ na cwii wjaawicantyjooꞌ na cwilaꞌtꞌmaaⁿꞌndye jom. ");
INSERT INTO amuNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ee cantyja na sꞌaaⁿ, tꞌmo̱ⁿnaꞌ chiuu waa najndeii na matseixmaaⁿ. Sꞌaaⁿ na tꞌoomꞌndye nnꞌaⁿ na cwilaꞌtꞌmaaⁿꞌndye cheⁿnquiee cantyja na cwilaꞌtiuu. ");
INSERT INTO amuNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Tyotseitꞌmaaⁿꞌñê nnꞌaⁿ na cweꞌ cwantindyo ndoꞌ tjeiiⁿꞌeⁿ nnꞌaⁿ na waa najnda̱ na mꞌaⁿ nꞌiaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Teijneiⁿ nnꞌaⁿ na nquiu na tjo̱o̱ndye jom. Sa̱a̱ nnꞌaⁿ na nquiu na tjaa ljoꞌ cotseitjo̱o̱naꞌ joo, tîcateijneiⁿ naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Tyoteijneiⁿ welooya, nnꞌaⁿ Israel na tyondyeꞌntjom nnoom, cha caꞌmo̱ⁿnaꞌ na mañjom tsꞌoom na nntseicanda̱a̱ꞌñê ñꞌoom na tsoom nda̱a̱na na nntsꞌaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ee tsoom na tijoom cantycwii na wiꞌ tsꞌoom chaꞌtsondye nnꞌaⁿ tsjaaⁿ Israel, majuu Abraham ñequio nnꞌaⁿ na tuiindye tsjaaⁿ tsaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ndoꞌ ljooꞌñe María chaꞌna ndyee chiꞌ ñequio Elisabet. Jnda̱ chii tjalcweeⁿꞌeⁿ waⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tueꞌntyjo̱ xjeⁿ na nntseincuii Elisabet, quia joꞌ seincueⁿ cwii tyochjoo. ");
INSERT INTO amuNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ndoꞌ nnꞌaaⁿꞌaⁿ ñequio nnꞌaⁿ na mꞌaⁿ nndyooꞌ jndyena na jeeⁿ wiꞌ tsꞌom Tyꞌo̱o̱tsꞌom jom. Joꞌ chii tꞌomna na neiiⁿna ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Xuee na jnda̱ ñeeⁿ na tuiiñe yuꞌndaa, tjomndyena na nlaꞌcanda̱a̱ꞌndyena costumbre na waa jo nda̱a̱na na cwilꞌana ñꞌeⁿ yoꞌndaa na naⁿnom. Ndoꞌ tyolꞌana na nlaꞌcajndyuna jom xueeꞌ tsotyeeⁿ, Zacarías. ");
INSERT INTO amuNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Sa̱a̱ tꞌo̱ tsoñeeⁿ, matso: —Nchii joꞌ, maxjeⁿ Juan njñoom. ");
INSERT INTO amuNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Jluena nnoom: —¿Chiuu na luaaꞌ? ndoꞌ tjaaꞌnaⁿ cwii nnꞌaⁿꞌyoꞌ na luaaꞌ jndyu. ");
INSERT INTO amuNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Quia joꞌ sꞌo̱o̱ lueena nnom tsotye yuꞌndaa na cwitaxꞌeena chiuu lꞌue tsꞌoom na njndyu jnaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ndoꞌ jom tcaaⁿ cwii tsom nda̱a̱na. Seiljeiⁿ nacjooꞌnaꞌ: “Juan xueeꞌ yuꞌndaamꞌaaⁿꞌ.” Ndoꞌ chaꞌtsondyena tjaweeꞌ nꞌomna. ");
INSERT INTO amuNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Mañejuu xjeⁿꞌñeeⁿ, jnaaⁿ na matseineiⁿ Zacarías, seitꞌmaaⁿꞌñê Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Jeeⁿ ndyaaꞌ tyueneiiⁿ chaꞌtsondye nnꞌaⁿ na mꞌaⁿ nndyooꞌ ñꞌeⁿndyena. Tꞌom ñꞌoom chaꞌwaa naquiiꞌ ntsjo̱ tsꞌo̱ndaa Judea cantyja na nmeiiⁿꞌ tuii. ");
INSERT INTO amuNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ndoꞌ chaꞌtso nnꞌaⁿ na tyondye ñꞌoommeiⁿꞌ, jeeⁿ tyolaꞌwena ñꞌoomꞌñeeⁿ naquiiꞌ nꞌomna. Jeeⁿ tyomꞌaaⁿꞌ nꞌomna, tyotaꞌxꞌeena nda̱a̱ ntyjeena: —¿Ljoꞌto cwiluiiñe yuꞌndaamꞌaaⁿꞌ? Ee jlaꞌno̱ⁿꞌna na Tyꞌo̱o̱tsꞌom mꞌaaⁿ tsꞌo̱ nacjooꞌ yuꞌndaaꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ndoꞌ Zacarías, tsotye yuꞌndaa, tooꞌ quiiꞌ tsꞌoom mꞌaaⁿ Espíritu Santo. Tyoñequiaaⁿ ñꞌoom na tquiaa Tyꞌo̱o̱tsꞌom naquiiꞌ tsꞌoom. Tsoom: ");
INSERT INTO amuNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Catseitꞌmaaⁿꞌñenaꞌ nquii Ta Tyꞌo̱o̱tsꞌom cwentaa jaa nnꞌaⁿ Israel, ee jnda̱ jndyoteijneiⁿ jaa nnꞌaaⁿꞌaⁿ ndoꞌ tiomlꞌuaaⁿ jnaaⁿya. ");
INSERT INTO amuNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Quiiꞌntaaⁿ jaa jnda̱ tqueeⁿ nquii na tjacantyja cwiluiitꞌmaⁿñe na macwjiꞌnꞌmaaⁿñe nnꞌaⁿ. Cwiluiiñe tsjaaⁿ David na jndyowicantyjooꞌ na ñejndiꞌntjom nnoom. ");
INSERT INTO amuNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Teiyo tsoom na luaaꞌ nntsꞌaaⁿ ñequio ñꞌoom ndyuee profetas cwentaaⁿꞌaⁿ na ljuꞌ nꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Na nncwjiiꞌñê jaa luee nnꞌaⁿ na jndoo jaa, ndoꞌ ñequio luee nnꞌaⁿ na ticueeꞌ nꞌom jaa. ");
INSERT INTO amuNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ndoꞌ nncꞌoom na wiꞌ tsꞌoom welooya na ñetꞌom teiyo. Macañjom tsꞌoom ñꞌoomꞌñeeⁿ na seijndaaꞌñetyeeⁿ na ljuꞌ tseixmaⁿnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Juu ñꞌoomꞌñeeⁿ tsoom na nntsꞌaaⁿ nnom welooya Abraham na ñetꞌoom teiyoticheⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Joꞌ na nntseicandyaañê jaa luee nnꞌaⁿ na jndoo jaa cha nndya̱ꞌntjo̱o̱ⁿya nnoom ñequio na tiꞌmaaⁿꞌ nꞌo̱o̱ⁿya. ");
INSERT INTO amuNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Ndoꞌ chaꞌwaati xuee na cwii mꞌaaⁿtya̱a̱ya, nncꞌo̱o̱ⁿya naquiiꞌ na jnda̱ tqueⁿljoomꞌm jaa. Nndya̱ꞌntjo̱o̱ⁿya nnoom cantyja na matyꞌiomyanaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ndoꞌ ꞌu jndaaya, nluiindyuꞌ profeta cwentaaꞌ nquii Tyꞌo̱o̱tsꞌom na mꞌaaⁿ nandyeticheⁿ. Ee ꞌu nncjaꞌjndyeeꞌ jo nnom Ta na nncwjiꞌyuuꞌndyuꞌ cantyja ꞌnaaⁿꞌaⁿ chaꞌcwijom tsꞌaⁿ na matseijndaaꞌñe nato, cha mamꞌaⁿcꞌeendye nnꞌaⁿ quia nncueeꞌcañoom. ");
INSERT INTO amuNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ꞌU nñequiaaꞌ na nlaꞌno̱ⁿꞌ nnꞌaⁿ na mꞌaⁿ cwentaaⁿꞌaⁿ na macwiluiꞌnꞌmaaⁿndyena ncꞌe na matseitꞌmaⁿ tsꞌoom jnaaⁿna. ");
INSERT INTO amuNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ncꞌe na tjacantyja na wiꞌ tsꞌom Tyꞌo̱o̱tsꞌom jaa, juu na nnaⁿ nandyeticheⁿ, njñoom juu na nntseixueeñe jo nda̱a̱ya. ");
INSERT INTO amuNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Juu nntseixueeñe nda̱a̱ nnꞌaⁿ na mꞌaⁿ nacje ꞌnaaⁿꞌ najo̱o̱ⁿñe na manchjenaꞌ joo na wiꞌ na cwitjoom. Ndoꞌ nncjaachom jaa nato na ya nncꞌo̱o̱ⁿya jo nnom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Tjawijndeii tyochjoo Juan. Tjawijndo̱ꞌ tsꞌoom cantyja najndeii na matseixmaⁿ Tyꞌo̱o̱tsꞌom. Ndoꞌ quia na tueꞌntyjo̱ na tsaⁿsꞌa jom, tyomꞌaaⁿ jo ndoꞌ yuu tjaa nnꞌaⁿ cꞌoom hasta xjeⁿ na seicaꞌmo̱ⁿñê nda̱a̱ nnꞌaⁿ Israel. ");
INSERT INTO amuNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Joo ncueeꞌñeeⁿ tqueⁿ Augusto César ñꞌoom na nleiljeii ncuee chaꞌtso nnꞌaⁿ na chaꞌtso ndyuaa na matsa̱ꞌntjoom. ");
INSERT INTO amuNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Luaaꞌ najndyee na teiljeii ncuee nnꞌaⁿ. Maquialjoꞌ tyomꞌaaⁿ Cirenio gobiernom ndyuaa Siria. ");
INSERT INTO amuNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Joꞌ chii chaꞌtsondye nnꞌaⁿ tyoꞌoona tsjoomna na nleiljeii ncueena. ");
INSERT INTO amuNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Joꞌ jnaⁿ José tsjoom Nazaret, tsꞌo̱ndaa Galilea. Tjawaaⁿ tsꞌo̱ndaa Judea, tsjoomꞌ David na jndyu Belén. Ee juu José cwiluiiñê tsjaaⁿ David. ");
INSERT INTO amuNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Tjaaⁿ ñequio María, tsaⁿ na waa ñomca ñꞌeⁿñê na nleiljeii ncueena. Ndoꞌ juu majndeiiñe, jnda̱ teinndyooꞌ na nntseincuii. ");
INSERT INTO amuNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ndoꞌ yocheⁿ na mꞌaⁿna Belén, tueꞌntyjo̱ xuee na nntseincuii María. ");
INSERT INTO amuNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Seincueⁿ jnaaⁿ na cweꞌ jndyee. Tyochjoo juu. Seityjooñê liaa juu, chii tqueeⁿ juu tsꞌom ꞌnaⁿ na quicanjom na cwicwaꞌ quiooꞌ. Ee ticwanaaⁿ lꞌaa yuu na cweꞌ cwiquieya nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ndyooꞌ tsjoom Belén jo ndoꞌ jnda̱a̱, tyomꞌaⁿ nnꞌaⁿ na cwilꞌa cwenta quiooꞌ njmeiⁿꞌ natsjom. ");
INSERT INTO amuNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Ñejomto teitquiooꞌñe cwii ángel cwentaaꞌ Ta Tyꞌo̱o̱tsꞌom jo nda̱a̱na, ndoꞌ juu nacaxuee na matseixmaaⁿ seixueeñenaꞌ nacañoomna. Ndoꞌ tꞌmaⁿ waa na jlaꞌcatyuendyena. ");
INSERT INTO amuNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ndoꞌ tso ángel nda̱a̱na: —Tilaꞌcatyuendyoꞌ, mañequiaya ñꞌoom na jeeⁿ ya nda̱a̱ꞌyoꞌ. Juunaꞌ nntsꞌaanaꞌ na jeeⁿ neiiⁿ chaꞌtsondye nnꞌaⁿ tsjoomnancue. ");
INSERT INTO amuNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ee tsjom jeꞌ naquiiꞌ tsjoomꞌ David tuiiñe cwii tsꞌaⁿ na nncwjiꞌnꞌmaaⁿñe ꞌo. Majuu Cristo na cwiluiiñê na matsa̱ꞌntjoom. ");
INSERT INTO amuNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Luaa waa na nnda̱a̱ nntaꞌjnaⁿꞌyoꞌ jom. Nliuꞌyoꞌ yuꞌndaaꞌñeeⁿ na chuꞌtyjooñê liaa ndoꞌ njoom yuu cwicwaꞌ quiooꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ndoꞌ matsꞌia joꞌ teitquiooꞌ cwii tmaaⁿꞌ ángeles ñequio ángelꞌñeeⁿ. Cwilcwiiꞌna Tyꞌo̱o̱tsꞌom. Cwiluena: ");
INSERT INTO amuNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","Catseitꞌmaaⁿꞌñenaꞌ nquii Ta Tyꞌo̱o̱tsꞌom na mꞌaaⁿ nandyeticheⁿ. Catsꞌaanaꞌ na tjaa ñomtiuu cꞌom nnꞌaⁿ tsjoomnancue jo nnoom, ee jeeⁿ cjaaweeꞌ tsꞌoom joona. ");
INSERT INTO amuNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Jnda̱ joꞌ tyꞌelcweeꞌ ángelesꞌñeeⁿ cañoomꞌluee. Quia joꞌ nnꞌaⁿ na cwilꞌa cwenta quiooꞌ njmeiⁿꞌ jluena nda̱a̱ ncꞌiaana: —Cjaaya Belén. Tsaacantyꞌiaaya chiuu waa na jnda̱ tuii na luaaꞌ maꞌmo̱ⁿ Ta Tyꞌo̱o̱tsꞌom nda̱a̱ya. ");
INSERT INTO amuNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ndoꞌ jlaꞌtyuaaꞌna, tyꞌena. Quia na tquiena, jliuna María ñequio José ñꞌeⁿ yuꞌndaa na njoom yuu cwicwaꞌ quiooꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Jnda̱ na ntyꞌiaana na luaaꞌ, jlaꞌcano̱o̱ⁿna chiuu waa na jnda̱ jndyena cantyja ꞌnaaⁿꞌ yuꞌndaaꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Chaꞌtso nnꞌaⁿ na jndye ñꞌoom na jluena, sꞌaanaꞌ na jeeⁿ tjaweeꞌ nꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ndoꞌ María jeeⁿ tyoqueeⁿ cwenta chaꞌtso na tuii. Wjaawa, wjaacue na tyotseitioom. ");
INSERT INTO amuNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Quia na tyꞌelcweeꞌ nnꞌaⁿ na cwilꞌa cwenta quiooꞌ njmeiⁿꞌ, tyolaꞌtꞌmaaⁿꞌndyena Tyꞌo̱o̱tsꞌom. Tyolcwiiꞌna jom cantyja chaꞌtso na jnda̱ jndyena ndoꞌ na jnda̱ ntyꞌiaana chaꞌxjeⁿ na tso ángel nda̱a̱na. ");
INSERT INTO amuNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Jnda̱ jnda̱a̱ꞌ ñeeⁿ xuee na tuiiñe yuꞌndaa, quia joꞌ chii jlaꞌcanda̱a̱ꞌndyena costumbre na waa jo nda̱a̱na na cwilꞌa nnꞌaⁿ judíos ñꞌeⁿ yoꞌndaa na naⁿnom. Ndoꞌ jlaꞌcajndyuna jom Jesús. Ee luaaꞌ jnda̱ tqueⁿ ángel xueⁿꞌeⁿ cwii tjo̱o̱cheⁿ na nndeiiñe María jom. ");
INSERT INTO amuNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Jnda̱ teinom wenꞌaaⁿ xuee na seincuii María, tueꞌntyjo̱ xjeⁿ na nntjeiꞌljuuꞌndyena chaꞌxjeⁿ na matsa̱ꞌntjom ljeii na tqueⁿ Moisés. Quia joꞌ tyꞌena Jerusalén, tyꞌeñꞌomna Jesús na nlqueⁿna juu lꞌo̱ Ta Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ee luaa tso ljeii ꞌnaaⁿꞌaⁿ: “Ticwii cwii tyochjoo na nluiiñejndyee, queⁿ tsotyeeⁿ, tsoñeeⁿ jom cwentaaꞌ Ta Tyꞌo̱o̱tsꞌom.” ");
INSERT INTO amuNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Joꞌ chii tyꞌena na nñeꞌquiana quiooꞌ cwentaaꞌ Tyꞌo̱o̱tsꞌom. Quiooꞌñeeⁿ nlaꞌcwjee ntyee chaꞌxjeⁿ na tꞌmaⁿ ljeii ꞌnaaⁿꞌaⁿ. Tsonaꞌ: nñequiana cwii ljo xencoo oo we cantuꞌ ndyua. ");
INSERT INTO amuNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tyomꞌaaⁿ cwii tsaⁿsꞌa na jndyu Simeón tsjoom Jerusalén. Tsaⁿꞌñeeⁿ tyomꞌaaⁿ cantyja na matyꞌiomyanaꞌ ndoꞌ jeeⁿ xcweeꞌ tsꞌoom ñꞌeⁿ Tyꞌo̱o̱tsꞌom. Ñequio na ntyjaaꞌ tsꞌoom tyomeinomꞌm na nntyꞌiaaⁿꞌaⁿ nquii na nntseinjoomꞌ nꞌom nnꞌaⁿ Israel. Ndoꞌ tyomꞌaaⁿ Espíritu Santo ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Jnda̱ tꞌmo̱ⁿ Espíritu Santo nnoom na xocueeⁿꞌeⁿ cwitjo̱o̱cheⁿ na nntyꞌiaaⁿꞌaⁿ nquii Cristo na tqueⁿ Ta Tyꞌo̱o̱tsꞌom na nndyo. ");
INSERT INTO amuNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Sꞌaa Espíritu Santo naquiiꞌ tsꞌoom na nncjaⁿ watsꞌom tꞌmaⁿ. Ndoꞌ maxjeⁿꞌñeeⁿ nnꞌaⁿ na nda yuꞌndaa Jesús tyꞌeñꞌomna juu joꞌ joꞌ na nluii ñꞌeⁿñê chaꞌxjeⁿ waa costumbre na matsa̱ꞌntjom ljeii na tqueⁿ Moisés. ");
INSERT INTO amuNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Quia joꞌ toꞌñom Simeón yuꞌndaa, teiꞌcaljoom juu lꞌo̱o̱ⁿ. Tyolcweeⁿꞌeⁿ Tyꞌo̱o̱tsꞌom. Tsoom: ");
INSERT INTO amuNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ta, juu ñꞌoom na jnda̱ tsuꞌ no̱o̱ⁿ, jnda̱ seicanda̱a̱ꞌñenaꞌ. Jeꞌ ja na cwiluiindyo̱ moso ꞌnaⁿꞌ, quiaaꞌ na nncꞌio̱to̱ na meiⁿcwii ñomtiuu ticꞌo̱o̱ⁿya. ");
INSERT INTO amuNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ee na jnda̱ mamantyꞌiano̱o̱ⁿ nquii na nncwjiꞌnꞌmaaⁿñe nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Majuu na jnda̱ tqueⁿꞌ jo nda̱a̱ chaꞌtsondye nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Juu cwiluiiñe naxuee na mꞌmo̱ⁿ ñꞌoom na mayuuꞌ nda̱a̱ nnꞌaⁿ na nchii judíos. Ndoꞌ chaꞌtsondye nnꞌaⁿ ꞌnaⁿꞌ, nnꞌaⁿ Israel, nntsꞌaaⁿ na nluiitꞌmaⁿndyena cantyja ꞌnaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","José ñequio tsondyee Jesús jeeⁿ tjaweeꞌ nꞌomna chaꞌtso ñꞌoom na seineiⁿ Simeón cantyja ꞌnaaⁿꞌ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ndoꞌ Simeón seitꞌmaaⁿꞌñê joona, tsoom nnom María, tsondyee Jesús: —Queⁿꞌ cwenta, yuꞌndaamꞌaaⁿ, maqueⁿ Tyꞌo̱o̱tsꞌom jom na ntꞌom nnꞌaⁿ Israel nntsuundyena ncꞌe na ticalaꞌyuꞌna ñꞌeⁿñê. Ndoꞌ ntꞌom nnꞌaⁿ Israel nluiꞌnꞌmaaⁿndyena ncꞌe na nlaꞌyuꞌna ñꞌeⁿñê. Mꞌmo̱o̱ⁿ chiuu waa na matyꞌiomyanaꞌ na calꞌa nnꞌaⁿ. Sa̱a̱ ñꞌeeⁿꞌ nnꞌaⁿ nntioꞌñꞌoomna jom. ");
INSERT INTO amuNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ndoꞌ na luaaꞌ nlꞌana, nntseicano̱o̱ⁿnaꞌ ñꞌomtiuu ꞌnaaⁿna. Ndoꞌ ꞌu jeꞌ, quia na nntyꞌiaꞌ na ljoꞌ, nntseiꞌndaaꞌnaꞌ ntyjiꞌ chaꞌcwijom na nncwicandiꞌ espada ꞌu. ");
INSERT INTO amuNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ndoꞌ joꞌ joꞌ tyomꞌaaⁿ cwii yuscu na jndyu Ana, jom cwiluiiñê tsꞌaⁿ na tyoñequiaa ñꞌoomꞌ Tyꞌo̱o̱tsꞌom. Tsaⁿꞌñeeⁿ jnda Fanuel, tsaⁿ na cwiluiiñe tsjaaⁿ na jndyowicantyjooꞌ Aser. Xjeⁿ na scundyua jom tocoom, tꞌoom ñequio saaⁿꞌaⁿ ntquieeꞌ chu, ");
INSERT INTO amuNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","jnda̱ chii ljoñê na tueꞌ saaⁿꞌaⁿ. Ndoꞌ jnda̱ tquieñê, jnda̱ ñequieenꞌaaⁿ nchooꞌ ñequiee choomꞌm. Ndoꞌ tîcalueeⁿꞌeⁿ naquiiꞌ watsꞌom tꞌmaⁿ. Tyondiꞌntjoom nnom Tyꞌo̱o̱tsꞌom naxuee ndoꞌ natsjom. Tyotseicwejndoꞌñê ndoꞌ tyotseineiiⁿ nnom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Majuu xjeⁿꞌñeeⁿ na matseineiⁿ Simeón, seicandyooꞌñe Ana nacañoomna. Tquiaaⁿ na quianlꞌuaaꞌ Tyꞌo̱o̱tsꞌom cantyja ꞌnaaⁿꞌ yuꞌndaa Jesús. Jnda̱ chii tyotseineiiⁿ cantyja ꞌnaaⁿꞌ juu nda̱a̱ chaꞌtsondye nnꞌaⁿ Jerusalén ñequio nnꞌaⁿ ntꞌomcheⁿ njoom na cwimeindooꞌ na nndyaandye na cwilaxmaⁿ jnaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","José ñꞌeⁿ María quia na jnda̱ jlaꞌcanda̱a̱ꞌndyena chaꞌtsoti na matso ljeii na tqueⁿ Tyꞌo̱o̱tsꞌom, tyꞌelcweeꞌna tsjoomna Nazaret, tsꞌo̱ndaa Galilea. ");
INSERT INTO amuNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Tjawijndeii tyochjooꞌñeeⁿ, tjawitquiooꞌ na wandoꞌ tsꞌoom ndoꞌ canda̱a̱ꞌya tjawijndo̱ꞌ tsꞌoom. Ndoꞌ tꞌmaⁿ waa na matseixmaaⁿ naya ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ticwii chu tyocaa José ñꞌeⁿ María Jerusalén quia cwiweeꞌ xuee pascua. ");
INSERT INTO amuNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ndoꞌ quia na jnda̱a̱ꞌ canchooꞌwe chuuꞌ Jesús, tyꞌewana ñꞌeⁿñê Jerusalén chaꞌxjeⁿ waa costumbre na quiꞌoona xuee pascuaꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Jnda̱ teinom xuee, José ñequio tsondyee Jesús macwiꞌoolcweeꞌna. Sa̱a̱ tiqueⁿna cwenta na ljooꞌñe tyochjoo Jesús Jerusalén. ");
INSERT INTO amuNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Jlaꞌtiuuna na ñꞌeeⁿ quiiꞌntaaⁿ nnꞌaⁿ na macwiꞌoolcweeꞌ na tyꞌe xuee. Meiiⁿchaaꞌ xuee tyocañjomndyena nato. Jnda̱ chii to̱ꞌna, tyolꞌueena jom quiiꞌntaaⁿ nnꞌaaⁿna ñequio nnꞌaⁿ na taꞌjnaaⁿꞌna. ");
INSERT INTO amuNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Sa̱a̱ na tîcaliuna jom, joꞌ chii tyꞌelcweeꞌnndaꞌna Jerusalén, na cwilꞌueena jom. ");
INSERT INTO amuNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Xuee na jnda̱ ndyee, ndoꞌ jliuna jom naquiiꞌ watsꞌom tꞌmaⁿ. Wacatyeeⁿ quiiꞌntaaⁿ nnꞌaⁿ na jndo̱ꞌ nꞌom na cwitꞌmo̱o̱ⁿ ñꞌoom na tqueⁿ Moisés. Maqueeⁿ cwenta ñꞌoom na cwilaꞌneiⁿ naⁿꞌñeeⁿ ndoꞌ mawaxꞌeeⁿ nda̱a̱na. ");
INSERT INTO amuNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Chaꞌtsondyena na tyondyena ñꞌoom na tyotseineiiⁿ, jeeⁿ tyojaaweeꞌ nꞌomna na cjee matseiꞌno̱o̱ⁿꞌo̱ⁿ ndoꞌ majoꞌndyo ñꞌoom matseilcweeⁿꞌeⁿ nda̱a̱na. ");
INSERT INTO amuNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ndoꞌ nnꞌaⁿ na nda jom quia na ntyꞌiaana, jeeⁿ seiñꞌeeⁿꞌnaꞌ joona. Tso tsoñeeⁿ nnoom: —ꞌU jndaaya, ¿chiuu na luaaꞌ saꞌ? Ja ñꞌeⁿ tsotyeꞌ ñequio na chjooꞌ nꞌo̱o̱ⁿyâ cwilꞌua̱a̱yâ ꞌu. ");
INSERT INTO amuNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Quia joꞌ tsoom nda̱a̱na: —¿Chiuu waa na cwilꞌueꞌyoꞌ ja? ¿Aa ticaliuꞌyoꞌ na tseixmaⁿya na cꞌo̱o̱ⁿya naquiiꞌ waaꞌ Tsotya̱? ");
INSERT INTO amuNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Sa̱a̱ tîcalaꞌno̱ⁿꞌna ñꞌoom na seilcweeⁿꞌeⁿ nda̱a̱na. ");
INSERT INTO amuNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Quia joꞌ tjalcweeⁿꞌeⁿ ñꞌeⁿndyena tsjoom Nazaret. Ndoꞌ tyomꞌaaⁿñê na ndyaañê nda̱a̱na. Jeeⁿ tyocañjom tsꞌom tsoñeeⁿ chaꞌtso na tuii. ");
INSERT INTO amuNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jesús tjawijndo̱ꞌti tsꞌoom ndoꞌ tjawijndeiityeeⁿ. Tjaweeꞌ tsꞌom Tyꞌo̱o̱tsꞌom ñꞌeⁿñê ndoꞌ mati nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Chu na jnda̱ quinꞌoom na mꞌaaⁿ Tiberio César tsaⁿmaⁿtsꞌiaaⁿ tꞌmaⁿ tsjoom Roma, quia joꞌ tyomꞌaaⁿ Poncio Pilato gobiernom tsꞌo̱ndaa Judea. Ndoꞌ Herodes tyomꞌaaⁿ gobiernom tsꞌo̱ndaa Galilea. Tyjeeⁿ Felipe tyomꞌaaⁿ gobiernom tsꞌo̱ndaa Iturea ñequio tsꞌo̱ndaa Traconite. Lisanias tyomꞌaaⁿ gobiernom tsꞌo̱ndaa Abilinia. ");
INSERT INTO amuNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ndoꞌ Anás ñequio Caifás, joona ntyee na tyoluiitquiendyena nda̱a̱ ntyee quia joꞌ. Ndoꞌ Juan jnda Zacarías, xjeⁿꞌñeeⁿ tquiaa Tyꞌo̱o̱tsꞌom ñꞌoom nnoom quia na mꞌaaⁿ yuu tjaa nnꞌaⁿ cꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Tyomanoom chaꞌwaa ndyuaa na nndyooꞌ jndaa Jordán. Tyoñequiaaⁿ ñꞌoom na calcweꞌ nꞌom nnꞌaⁿ jnaaⁿna cha nntseitꞌmaⁿ tsꞌom Tyꞌo̱o̱tsꞌom joona, ndoꞌ nleitsꞌoomndyena. ");
INSERT INTO amuNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Tuii na luaaꞌ chaꞌxjeⁿ na matso ljeii libro na chuu ñꞌoom ꞌndyoo profeta Isaías. Matso ljeiiꞌñeeⁿ: Mꞌaaⁿ tsꞌaⁿ na matseineiⁿ nda̱a̱ nnꞌaⁿ yuu tjaa nnꞌaⁿ cꞌom. Matso tsaⁿꞌñeeⁿ: “Calaꞌjndaaꞌndyoꞌ naquiiꞌ nꞌomꞌyoꞌ chaꞌcwijom cwii nato na juu joꞌ nndyocwjeeꞌcañoom nquii na nntsa̱ꞌntjom ꞌo. Cataꞌndyoꞌxcweꞌyoꞌ chaꞌcwijom cwilayo̱ꞌyoꞌ nato na nñoom. ");
INSERT INTO amuNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Maxjeⁿ nntseicatooꞌnaꞌ ticwii cwii cantmaⁿꞌ ndoꞌ ticwii cwii sjo̱ ñequio ta nleisunaꞌ. Nanto na cancꞌeeⁿ, nntseiliuunaꞌ, ndoꞌ nanto na cwajndii nntseiyo̱naꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Quia joꞌ nntyꞌiaa chaꞌtsondye nnꞌaⁿ Nquii na maqueⁿ Tyꞌo̱o̱tsꞌom na nncwjiꞌnꞌmaaⁿñê joo.” ");
INSERT INTO amuNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Jndyendye nnꞌaⁿ tyoꞌoontyjaaꞌna Juan na nntseitsꞌoomñê joona. Quia joꞌ tyotsoom nda̱a̱na: —ꞌO tsjaaⁿ canduulja, ¿ꞌñeeⁿ tꞌmo̱ⁿ nda̱a̱ꞌyoꞌ na caleiꞌnomꞌyoꞌ na nndyocwjeeꞌcañoom na nntseiwꞌii Tyꞌo̱o̱tsꞌom ꞌo? ");
INSERT INTO amuNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Cꞌomꞌyoꞌ na ndyaandyoꞌ cha mꞌmo̱ⁿnaꞌ na mayuuꞌcheⁿ cwilcweꞌ nꞌomꞌyoꞌ. Ndoꞌ ticalaꞌsꞌandyoꞌ cheⁿncjoꞌyoꞌ naquiiꞌ nꞌomꞌyoꞌ na nnduꞌyoꞌ: “Jaa cwiluiindyo̱ tsjaaⁿ Abraham.” Nndyeꞌyoꞌ nntsjo̱o̱, meiiⁿ cweꞌ ljo̱ꞌmeiiⁿ nnda̱a̱ nntseicwaqueⁿ Tyꞌo̱o̱tsꞌom na nluiindyenaꞌ tsjaaⁿ Abraham, quia joꞌ nꞌndiinaꞌ ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ꞌO matseijomnaꞌ chaꞌcwijom nꞌoom na tisꞌa ta̱ cwilꞌa. Ndoꞌ manquiuꞌyoꞌ nꞌoom na ticalꞌa ta̱ na ya, maxjeⁿ nntꞌuaꞌnaꞌ. Ndoꞌ xeⁿ jnda̱ nntioom nnꞌaⁿ joonaꞌ quiiꞌ chom. Maluaaꞌ matseijomnaꞌ na nntsꞌaa Tyꞌo̱o̱tsꞌom ñꞌeⁿndyoꞌ ꞌo xeⁿ ticalꞌaꞌyoꞌ yuu na ya. ");
INSERT INTO amuNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Quia joꞌ taꞌxꞌee naⁿꞌñeeⁿ nnoom: —¿Chiuu macaⁿnaꞌ na calꞌaayâ xeⁿ yuuꞌ na ljoꞌ? ");
INSERT INTO amuNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Tꞌo̱o̱ⁿ nda̱a̱na, tsoom: —Tsꞌaⁿ na maleiñꞌoom we cotom, quiaa cwii nnom tsꞌaⁿ na tjaa na cuaa. Ndoꞌ ꞌñeeⁿ na waa nantquie, catsꞌaa naya tsꞌaⁿ na tjaaꞌnaⁿ chiuu ya. ");
INSERT INTO amuNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Mati nnꞌaⁿ na cwitoꞌñoom sꞌom cwentaaꞌ gobiernom tquiona namꞌaaⁿ na nleitsꞌoomndyena. Jluena nnoom: —Ta, ¿chiuu macaⁿnaꞌ na calꞌaayâ? ");
INSERT INTO amuNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Tꞌo̱o̱ⁿ nda̱a̱na: —Tancwinomꞌyoꞌ na cwitjeiꞌyoꞌ tsꞌiaaⁿnda̱a̱ nnꞌaⁿ. Cataⁿꞌyoꞌ tomti na matsonaꞌ na nntioomna. ");
INSERT INTO amuNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Mati taꞌxꞌee sondaro nnoom: —Ndoꞌ jâ jeꞌ, ¿chiuu macaⁿnaꞌ na calꞌaayâ? Tꞌo̱o̱ⁿ nda̱a̱na: —Talacatyꞌueꞌyoꞌ nnꞌaⁿ, ndoꞌ talaco̱ꞌyoꞌ cantu joona cweꞌ cha na nnda̱a̱ nntjeiꞌyoꞌ sꞌom ꞌnaaⁿna. Caljoya nꞌomꞌyoꞌ cwanti na cwitantjomꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Chaꞌtsondye nnꞌaⁿ jeeⁿ tyocantyjaaꞌ nꞌomna na nncwjeeꞌ juu Cristo. Joꞌ chii tyomꞌaaⁿꞌ nꞌomna cantyja ꞌnaaⁿꞌ Juan, ¿aa nntsꞌaacheⁿnaꞌ na jom cwiluiiñê Cristo? ");
INSERT INTO amuNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Joꞌ chii tꞌo̱o̱ⁿ nda̱a̱ chaꞌtsondyena, tsoom: —Ja matseitsꞌo̱o̱ⁿndyo̱ ꞌo ñequio ndaatioo, sa̱a̱ mandyontyjo̱ nqueⁿ na nntseitsꞌoomñê ꞌo na nñequiaaⁿ Espíritu Santo naquiiꞌ nꞌomꞌyoꞌ. Sa̱a̱ ntꞌomndyoꞌ ꞌo nntsꞌaanaꞌ chaꞌcwijom nntseitsꞌoomñê ꞌo ñequio chom ee na nntꞌuiityeⁿnaꞌ ꞌo cantyja jnaⁿꞌyoꞌ. Nqueⁿ tꞌmaⁿti cwiluiiñê nchiiti ja. Meiⁿ ticatseixmaⁿya na cweꞌ ja na nntseicanaⁿꞌa lcoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Jnda̱ wjaawindyooꞌ na nntuꞌxeⁿndyoꞌ. Ee ꞌo laꞌxmaⁿꞌyoꞌ chaꞌcwijom lqueeⁿ na ndicwaⁿ cwajndii. Luaa tsꞌiaaⁿ cantyja ꞌnaaⁿꞌ lqueeⁿ. Matseicueeñe tsꞌaⁿ lqueeⁿ trigo, cha ya ya nljuꞌnaꞌ. Quia na jnda̱ ljuꞌya lqueeⁿꞌñeeⁿ, mana nntseiweeⁿ joonaꞌ tsꞌom tsa̱ꞌ. Sa̱a̱ lqueeⁿ lueꞌ ñꞌeⁿ toꞌ njñoom chom joꞌ. Maluaaꞌ matseijomnaꞌ na machꞌee Tyꞌo̱o̱tsꞌom. Nnꞌaⁿ na ya cwilꞌa macoꞌñoom joona sa̱a̱ nnꞌaⁿ na tisꞌa cwilꞌa, nntseicoom joona ñequio chom na tijoom canduuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Nmeiⁿꞌ ñꞌoom na tyotseijndo̱ꞌ Juan nꞌom nnꞌaⁿ ñequio jndye ntꞌomcheⁿ ñꞌoom na tyotseicañeeⁿ joona ñꞌoom naya. ");
INSERT INTO amuNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Herodes, tsaⁿ na mꞌaaⁿ gobiernom tsꞌo̱ndaa Galilea, jom cweꞌ mꞌaaⁿyaaⁿ ñꞌeⁿ Herodías, scuuꞌ tyjeeⁿ Felipe. Joꞌ na seitiaꞌ Juan jom na ticatsa̱ꞌntjomnaꞌ na ljoꞌ machꞌeeⁿ ndoꞌ ñequio chaꞌtso natia na jnda̱ ñesꞌaa tsaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Luaa seicwaljooꞌtyeeⁿ nacjoo chaꞌtso natia na sꞌaaⁿ, na tjoomꞌm Juan wꞌaancjo. ");
INSERT INTO amuNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Quia na jnda̱ teitsꞌoomndye jndye nnꞌaⁿ, mati teitsꞌoomñe Jesús, xcwe na matseineiiⁿ nnom Tyꞌo̱o̱tsꞌom ndoꞌ seicanaaⁿñenaꞌ tsjo̱ꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Jndyocue Espíritu Santo nacjoomꞌm chaꞌcwijom catuꞌ. Ndoꞌ teicꞌuaa na seineiⁿ Tyꞌo̱o̱tsꞌom cañoomꞌluee, matso: —ꞌU cwiluiindyuꞌ Jndaaya na candyaꞌ tsꞌo̱o̱ⁿya. Jeeⁿ neiⁿya ꞌu. ");
INSERT INTO amuNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ndoꞌ Jesús chaꞌna ntquiuu nchooꞌ qui choomꞌm quia na to̱o̱ⁿꞌo̱ⁿ tsꞌiaaⁿ na jñom Tyꞌo̱o̱tsꞌom jom. Tyolue nnꞌaⁿ jnda José jom. Ndoꞌ José jnda Elí, ");
INSERT INTO amuNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí jnda Matat, Matat jnda Leví, Leví jnda Melqui, Melqui jnda Jana, Jana jnda José, ");
INSERT INTO amuNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José jnda Matatías, Matatías jnda Amós, Amós jnda Nahum, Nahum jnda Esli, Esli jnda Nagai, ");
INSERT INTO amuNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai jnda Maat, Maat jnda Matatías, Matatías jnda Semei, Semei jnda José, José jnda Judá, ");
INSERT INTO amuNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá jnda Joana, Joana jnda Resa, Resa jnda Zorobabel, Zorobabel jnda Salatiel, Salatiel jnda Neri, ");
INSERT INTO amuNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri jnda Melqui, Melqui jnda Adi, Adi jnda Cosam, Cosam jnda Elmodam, Elmodam jnda Er, ");
INSERT INTO amuNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er jnda Josué, Josué jnda Eliezer, Eliezer jnda Jorim, Jorim jnda Matat, ");
INSERT INTO amuNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat jnda Leví, Leví jnda Simeón, Simeón jnda Judá, Judá jnda José, José jnda Jonán, Jonán jnda Eliaquim, ");
INSERT INTO amuNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim jnda Melea, Melea jnda Mainán, Mainán jnda Matata, Matata jnda Natán, ");
INSERT INTO amuNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán jnda David, David jnda Isaí, Isaí jnda Obed, Obed jnda Booz, Booz jnda Salmón, Salmón jnda Naasón, ");
INSERT INTO amuNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón jnda Aminadab, Aminadab jnda Aram, Aram jnda Esrom, Esrom jnda Fares, Fares jnda Judá, ");
INSERT INTO amuNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá jnda Jacob, Jacob jnda Isaac, Isaac jnda Abraham, Abraham jnda Taré, Taré jnda Nacor, ");
INSERT INTO amuNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor jnda Serug, Serug jnda Ragau, Ragau jnda Peleg, Peleg jnda Heber, Heber jnda Sala, ");
INSERT INTO amuNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala jnda Cainán, Cainán jnda Arfaxad, Arfaxad jnda Sem, Sem jnda Noé, Noé jnda Lamec, ");
INSERT INTO amuNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec jnda Matusalén, Matusalén jnda Enoc, Enoc jnda Jared, Jared jnda Mahalaleel, Mahalaleel jnda Cainán, ");
INSERT INTO amuNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán jnda Enós, Enós jnda Set, Set jnda Adán, Adán jnda Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Mawjaalcweꞌ Jesús tsꞌo̱ndaa Galilea na jnaaⁿ jndaa Jordán. Ndoꞌ chaꞌwaañꞌeⁿ naquiiꞌ tsꞌoom tooꞌ mꞌaaⁿ Espíritu Santo. Tjañꞌoom Espíritu jom cwii joo yuu na tjaa nnꞌaⁿ cꞌoom. ");
INSERT INTO amuNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Joꞌ joꞌ wenꞌaaⁿ xuee tyolꞌueeꞌñe tsaⁿjndii chiuu nntsꞌaaⁿ cha catseitjo̱o̱ñe Jesús. Chaꞌwaati xueewaaꞌ meiⁿchjoo ticwaꞌ Jesús, jnda̱ chii tyjeeꞌ na ñeꞌjnoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Quia joꞌ tso tsaⁿjndii nnoom: —Xeⁿ mayuuꞌ ꞌu cwiluiindyuꞌ Jnda Tyꞌo̱o̱tsꞌom, cwa catsa̱ꞌntjomꞌ tsjo̱ꞌwaaꞌ na catseicwaqueⁿnaꞌ tyooꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Tꞌo̱ Jesús nnom, tsoom: —Ja xocatsꞌaa na ljoꞌ ee waa ljeii ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom na matsonaꞌ: “Nchii cweꞌ cantyja ꞌnaaⁿꞌ nantquie na wandoꞌ tsꞌaⁿ, sa̱a̱ cantyja ꞌnaaⁿ chaꞌtso ñꞌoom na mañequiaa Tyꞌo̱o̱tsꞌom.” ");
INSERT INTO amuNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Jnda̱ chii tjañꞌoom tsaⁿjndii jom xqueⁿ cwii sjo̱ nandye. Ndoꞌ mantyjacheⁿ tꞌmo̱ⁿ nnoom chaꞌtsoti nꞌiaaⁿ ntꞌmaⁿ na mꞌaⁿ nnꞌaⁿ tsjoomnancue. ");
INSERT INTO amuNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Ndoꞌ tso nnoom: —Lꞌo̱ꞌ ꞌu nntio̱o̱ cwenta chaꞌtso najnda̱nmeiⁿꞌ na cwilaꞌxmaⁿ naⁿmaⁿnꞌiaaⁿ ntꞌmaⁿ ñequio chaꞌtso na cwiluiitꞌmaⁿndyena. Ee lꞌo̱o̱ya jnda̱ ljonaꞌ ndoꞌ ꞌñeeⁿ juu na lꞌue tsꞌo̱o̱ⁿ nñequiaya joonaꞌ nnom. ");
INSERT INTO amuNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Xeⁿ ꞌu nlcoꞌ xtyeꞌ na nntseitꞌmaaⁿꞌndyuꞌ ja, quia joꞌ chaꞌtso joonaꞌ maꞌnaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Tꞌo̱ Jesús nnom, tsoom: —Quindyo̱o̱ꞌ nacañomya, ꞌu Satanás. Ja tijoom nntseitꞌmaaⁿꞌndyo̱ ꞌu ee waa ljeii ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom na matsonaꞌ: “Macanda̱ nquii Ta Tyꞌo̱o̱tsꞌom cwentaꞌ catseitꞌmaaⁿꞌndyuꞌ ndoꞌ macanda̱ nnom jom nndiꞌntjomꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Jnda̱ joꞌ tjañꞌoom tsaⁿjndii Jesús tsjoom Jerusalén ndoꞌ tqueⁿ jom xqueⁿ tsiuꞌ watsꞌom tꞌmaⁿ. Tso nnoom: —Xeⁿ ꞌu cwiluiindyuꞌ Jnda Tyꞌo̱o̱tsꞌom, cwa cjuꞌndyuꞌ jo nacje, ");
INSERT INTO amuNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ee waa ljeii ꞌnaaⁿꞌaⁿ na matsonaꞌ: Nñequiaa Tyꞌo̱o̱tsꞌom ꞌu luee ángeles cwentaaⁿꞌaⁿ na calꞌana cwenta ꞌu. ");
INSERT INTO amuNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ndoꞌ nntyjeeꞌ lueena ꞌu cha tincjaañjom ljo̱ꞌ ncꞌeꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Sa̱a̱ tꞌo̱ Jesús nnom, tsoom: —Ja tijoom catsꞌaa chaꞌna matsuꞌ luaaꞌ ee mati waa cwiicheⁿ ljeii ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom na matsonaꞌ: “Tintsaꞌ xjeⁿ Ta Tyꞌo̱o̱tsꞌom cwentaꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Quia jnda̱a̱ꞌ chaꞌtso nnom na tyochꞌee tsaⁿjndii na nntsꞌaaⁿ xjeⁿ Jesús, ꞌñeeⁿ juu hasta jnda̱nquiacheⁿ nntyꞌiaaⁿꞌaⁿ aa nnda̱a̱ nntsꞌaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ndoꞌ tjalcweꞌ Jesús tsꞌo̱ndaa Galilea. Juu najndeii na matseixmaⁿ Espíritu Santo, canda̱a̱ꞌñꞌeⁿ tyotseixmaaⁿ joꞌ. Ndoꞌ tꞌom ñꞌoom cantyja ꞌnaaⁿꞌaⁿ chaꞌwaa ndyuaaꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Tyoꞌmo̱o̱ⁿ nda̱a̱ nnꞌaⁿ naquiiꞌ lanꞌom ꞌnaaⁿ nnꞌaⁿ judíos, ndoꞌ chaꞌtso nnꞌaⁿ jeeⁿ tyolaꞌtꞌmaaⁿꞌndyena jom. ");
INSERT INTO amuNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Tjaaⁿ Nazaret yuu na tjawijneiⁿ. Xuee na cwitaꞌjndyee nnꞌaⁿ, tjaaⁿ watsꞌom chaꞌxjeⁿ na quichꞌeeⁿ. Ndoꞌ teicantyjaaⁿ na nntseiꞌnaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Quia joꞌ tquiana ljeii lꞌo̱o̱ⁿ na seiljeii profeta Isaías, seicano̱o̱ⁿꞌo̱ⁿ ljeiiꞌñeeⁿ ndoꞌ tueꞌcañoom yuu na matsonaꞌ: ");
INSERT INTO amuNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Nquii Espíritu cwentaaꞌ Ta Tyꞌo̱o̱tsꞌom mꞌaaⁿñe ñꞌeⁿndyo̱. Ee nqueⁿ jnda̱ tqueⁿño̱o̱ⁿ ja na nñequiaya ñꞌoom naya nda̱a̱ nnꞌaⁿ na ntyꞌiaaꞌndye. Ndoꞌ jnda̱ jñoom ja na jndyo̱o̱ na catseinjo̱o̱ⁿꞌa nnꞌaⁿ na chjooꞌ nꞌom. Ndoꞌ catseicandiiya nnꞌaⁿ na matseicandyaandyo̱ joona jnaaⁿna na waa. Ndoꞌ catsꞌaaya na nleitquioo nnꞌaⁿ na nchjaaⁿ. Ndoꞌ catseicandyaandyo̱ nnꞌaⁿ na manchje nawiꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ndoꞌ catseicandiiya cantyja ꞌnaaⁿꞌ tiempo na tqueⁿ Tyꞌo̱o̱tsꞌom na nluiꞌnꞌmaaⁿndye añmaaⁿ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jnda̱ joꞌ seilcwiiñe Jesús tsom na chuu ljeiiꞌñeeⁿ ndoꞌ seilcweeⁿꞌeⁿ juunaꞌ nnom tsꞌaⁿ na mandiꞌntjom. Jnda̱ chii tjacwacatyeeⁿ. Ndoꞌ chaꞌtso nnꞌaⁿ na tooꞌndye watsꞌomꞌñeeⁿ jeeⁿ tyontyꞌiaana nnoom. ");
INSERT INTO amuNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Quia joꞌ to̱o̱ⁿꞌo̱ⁿ tyotseineiiⁿ nda̱a̱na. Ndoꞌ tsoom: —Maxuee jeꞌ matseicanda̱a̱ꞌñenaꞌ ljeiiwaaꞌ yocheⁿ na cwindyeꞌyoꞌ na matseiꞌnaⁿya juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Chaꞌtso nnꞌaⁿ tyolue ñꞌoom ya cantyja ꞌnaaⁿꞌaⁿ. Tjaweeꞌ nꞌomna na jeeⁿ cajnda ñꞌoom na tyotseineiiⁿ. Tyoluena: —Cwa cweꞌ jnda José tsaⁿmꞌaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Tso Jesús nda̱a̱na: —Jeꞌ jeꞌ nnduꞌyoꞌ no̱o̱ⁿ ñꞌoomwaañe na cweꞌ wjaañoomꞌ na matsonaꞌ: “ꞌU tsꞌaⁿ na machꞌee nasei, catseinꞌmaⁿndyuꞌ cheⁿnncuꞌ.” Ndoꞌ cwaaⁿti nnduꞌyoꞌ no̱o̱ⁿ: “Tsꞌiaaⁿ na cwindya̱a̱yâ na ñesaꞌ tsjoom Capernaum, mati catsaꞌ joonaꞌ ñjaaⁿñe ndyuaa tsjomꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Quia joꞌ tsotyeeⁿcheⁿ nda̱a̱na: —Mayuuꞌcheⁿ matsjo̱o̱ nda̱a̱ꞌyoꞌ, tixocalaꞌljo nnꞌaⁿ cwii profeta na mañecwii ndyuaana ñꞌeⁿñe na mañequiaa ñꞌoomꞌ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ñꞌoom na mayuuꞌ matsjo̱o̱ nda̱a̱ꞌyoꞌ, jndye yolcu na jnda̱ ljondye tyomꞌaⁿ ndyuaa Israel joo ncuee na ñetꞌoom Elías. Ncueeꞌñeeⁿ ndyee chu waljooꞌ xcwe tîcuaꞌ, ndoꞌ teijndoꞌ chaꞌwaa ndyuaaꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Sa̱a̱ nchii na mꞌaaⁿ cwii joo naⁿlcuꞌñeeⁿ jñom Tyꞌo̱o̱tsꞌom Elías, jñomyom juu na mꞌaaⁿ cwii yuscu na jnda̱ ljoñe tsjoom Sarepta ndyuaa Sidón. ");
INSERT INTO amuNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ndoꞌ mati jndye nnꞌaⁿ na tyoleiꞌcho ntycu lepra tyomꞌaⁿ ndyuaa Israel joo ncuee na tyomꞌaaⁿ profeta Eliseo. Sa̱a̱ meiⁿcwiindye naⁿꞌñeeⁿ ticatseinꞌmaaⁿ, macanda̱ quii Naamán, tsꞌaⁿ ndyuaa Siria. ");
INSERT INTO amuNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Sa̱a̱ quia jndyena na luaaꞌ tso Jesús, quia joꞌ chaꞌtso nnꞌaⁿ na tooꞌndye watsꞌom, jeeⁿcheⁿ ndyaꞌ jlaꞌwjeena. ");
INSERT INTO amuNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Jlaꞌtyuaaꞌna, tjeiiꞌna jom nnom tsjoom. Tyꞌeñꞌomna jom xqueⁿ ta yuu waa tsjoomna cha nlaꞌcwatyuꞌna jom. ");
INSERT INTO amuNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Sa̱a̱ jom jluiiꞌñê quiiꞌntaaⁿna, mana tjaaⁿ yuu na wjaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Tjacue Jesús Capernaum, cwii tsjoom tsꞌo̱ndaa Galilea. Joꞌ joꞌ tyoꞌmo̱o̱ⁿ nda̱a̱ nnꞌaⁿ judíos xuee na cwitaꞌjndyeena. ");
INSERT INTO amuNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ndoꞌ jeeⁿ tjaweeꞌ nꞌomna ñꞌoom na tyotseineiiⁿ, ee tyoꞌmo̱ⁿnaꞌ na waa najndeii na matseixmaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Naquiiꞌ watsꞌomꞌñeeⁿ tyomꞌaaⁿ cwii tsaⁿsꞌa na mꞌaaⁿ jndyetia naquiiꞌ tsꞌom. Jndeii seixuaⁿ ñꞌoom ꞌndyoo jndyetiaꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Tsoom: —Caꞌndiiꞌ jâ ꞌu Jesús tsꞌaⁿ Nazaret. ¿Ljoꞌ nntsaꞌ ñꞌeⁿndyô̱ jâ? ¿Aa jndyoꞌ na nntseityuiiꞌ jâ? Mawajnaⁿꞌa ꞌñeeⁿ cwiluiindyuꞌ. ꞌU cwiluiindyuꞌ Jnda Tyꞌo̱o̱tsꞌom na ljuꞌ tsꞌomꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Seitiaꞌ Jesús juu, matsoom: —Catseicheⁿꞌ ndoꞌ caluiꞌyoꞌ naquiiꞌ tsꞌom tsaⁿmꞌaaⁿ. Ndoꞌ jnda̱ na seiquioo jndyetia juu quiiꞌntaaⁿ nnꞌaⁿ, mana jluiꞌ jndyetia ñꞌeⁿ naⁿjndii naquiiꞌ tsꞌom. Ndoꞌ meiⁿcwii nata̱ꞌ tîcalꞌana ñꞌeⁿñe. ");
INSERT INTO amuNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Jeeⁿ tyue chaꞌtsondye nnꞌaⁿ na ljoꞌ sꞌaa Jesús. Jluena nda̱a̱ ncꞌiaana: —Ñꞌoommeiⁿꞌ cwitꞌmo̱o̱ⁿnaꞌ na cwiluiiñê tsꞌaⁿ na maqueⁿ xjeⁿ. Ee waa najndeii na matseixmaaⁿ na matsa̱ꞌntjoom meiiⁿ jndyetia, meiiⁿ naⁿjndii, cwicaluiꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Tjantyꞌee ñꞌoom cantyja ꞌnaaⁿꞌaⁿ chaꞌwaa ndiocheⁿ ndyuaaꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Quia joꞌ teicantyjaaⁿ, jlueeⁿꞌeⁿ naquiiꞌ watsꞌomꞌñeeⁿ. Tjaqueⁿꞌeⁿ waaꞌ Simón. Ndoꞌ Simónꞌñeeⁿ jeeⁿ nioom matseiconaꞌ sta̱xeeⁿꞌeⁿ. Lꞌana tyꞌoo nnom Jesús na catseinꞌmaaⁿ juu. ");
INSERT INTO amuNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Joꞌ chii tjantyjaaⁿꞌaⁿ tsaⁿꞌñeeⁿ, sa̱ꞌntjoom na caꞌndii tycuꞌñeeⁿ juu. Ndoꞌ mañoomꞌ tcoꞌyanaꞌ tsaⁿꞌñeeⁿ. Mana teicantyja, seiñꞌoomꞌñe na tcwaꞌna. ");
INSERT INTO amuNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Quia na jnda̱ tmaaⁿ na manndyooꞌ wjaacue ñeꞌquioomꞌ, chaꞌtsondye nnꞌaⁿ na mꞌaⁿ nnꞌaaⁿna na jndye nnom ntycu cwitjoom, tquiochona joo na mꞌaaⁿ Jesús. Tioom lꞌo̱o̱ⁿ nacjoo ticwii cwii joo naⁿꞌñeeⁿ, mana nꞌmaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Mati jndyendye nnꞌaⁿ sa̱ꞌntjoom na caluiꞌ jndyetia naquiiꞌ nꞌom. Tyolaꞌxuaa jndyetiaꞌñeeⁿ, tyolue: —ꞌU cwiluiindyuꞌ Jnda nquii Ta Tyꞌo̱o̱tsꞌom. Sa̱a̱ jom seitiaaⁿꞌaⁿ jndyetia, tinquiaaⁿ na nlaꞌneiⁿ, ee manquiuna na jom cwiluiiñê Cristo. ");
INSERT INTO amuNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Quia jnda̱ teincoo jlueeⁿꞌeⁿ quiiꞌ tsjoom. Tjaaⁿ yuu na wataaⁿꞌ quiiꞌ jnda̱a̱. Tyꞌecalꞌuee nnꞌaⁿ jom ndoꞌ jliuna yuu mꞌaaⁿ. Ñeꞌcalaꞌtsaaⁿꞌndyena jom na wjaatyeeⁿ, cha ticaꞌñeeⁿ joona. ");
INSERT INTO amuNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Sa̱a̱ tsoom nda̱a̱na: —Mati macaⁿnaꞌ na nñequiaya ñꞌoom naya cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom nda̱a̱ nnꞌaⁿ ntꞌomcheⁿ njoom. Ee maxjeⁿ joꞌ tsꞌiaaⁿ na jñoom ja. ");
INSERT INTO amuNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ndoꞌ tyojaanquiaaⁿ ñꞌoomꞌñeeⁿ naquiiꞌ lanꞌom tsꞌo̱ndaa Galilea. ");
INSERT INTO amuNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Cwii ndiiꞌ tyomꞌaaⁿ Jesús ꞌndyoo ndaaluee chjoo na jndyu Genesaret. Jeeⁿ tyonchjenaꞌ jom na jlaꞌcantoꞌndye nnꞌaⁿ nacañomꞌm cha nnda̱a̱ nndyena ñꞌoomꞌ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ntyꞌiaaⁿꞌaⁿ we wꞌaandaa ꞌndyoo ndaalueeꞌñeeⁿ. Sa̱a̱ nnꞌaⁿ na cwitjeiiꞌ calcaa jnda̱ jluiꞌna joꞌ joꞌ. Macwitmaaⁿna nlquiꞌ ꞌnaaⁿna. ");
INSERT INTO amuNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Quia joꞌ tjacuo̱o̱ⁿ tsꞌom cwii wꞌaandaaꞌñeeⁿ. Wꞌaandaa ꞌnaaⁿꞌ Simón joꞌ. Tcaaⁿ na cjaañꞌoomti tsaⁿꞌñeeⁿ juunaꞌ chjoowiꞌ cha nꞌndiinaꞌ tyuaatcwii. Ndoꞌ tjacjom. Tquiaaⁿ ñꞌoom nda̱a̱ nnꞌaⁿ xjeⁿ na wacatyeeⁿcheⁿ tsꞌom wꞌaandaa. ");
INSERT INTO amuNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Quia na jnda̱ jnda̱ seineiiⁿ, tsoom nnom Simón: —Catsaañꞌomꞌyoꞌ wꞌaandaawaa, wjaawjaatya̱a̱ya yuu na njoomti. Ndoꞌ catueꞌyoꞌ nlquiꞌ ꞌnaⁿꞌyoꞌ na nntjeiꞌyoꞌ calcaa. ");
INSERT INTO amuNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Tꞌo̱ Simón nnoom: —Ta, meiiⁿchaaꞌ tsjom ñelꞌaayâ tsꞌiaaⁿ ndoꞌ meiⁿcwii catscaa tîcatjeiiꞌâ. Sa̱a̱ cantyja ñꞌoom ꞌndyoꞌ ꞌu nncjuꞌnndaꞌa tsquiꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Jnda̱ na lꞌana na ljoꞌ, jeeⁿ jndye calcaa tyꞌoomnaꞌ tsꞌom tsquiꞌ ꞌnaaⁿna hasta ñeꞌcatyꞌiooꞌnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Joꞌ chii sꞌo̱o̱ lueena nda̱a̱ ntꞌomcheⁿ ncꞌiaana na ñjomndye cwiicheⁿ wꞌaandaa na quioteiꞌjndeii naⁿꞌñeeⁿ joona. Tquio naⁿꞌñeeⁿ. Ndoꞌ jlaꞌcatooꞌna we wꞌaandaa ñꞌeⁿ calcaa, hasta ncuencue na cꞌuꞌnaꞌ joonaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Quia jnda̱ ntyꞌiaaꞌ Simón Pedro na luaaꞌ, tcoomꞌm xtyeeⁿ jo nnom Jesús. Tsoom: —Ta, ticatyꞌiomyanaꞌ na nñꞌeⁿꞌ ñꞌeⁿndyo̱, ee ja tsꞌaⁿjnaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ee jeeⁿ ndyaꞌ seicatyꞌuenaꞌ jom ñequio ntꞌomcheⁿ ncꞌiaaⁿꞌaⁿ na ñꞌeeⁿ ñꞌeⁿñê cantyja ꞌnaaⁿ calcaa na tjeiiꞌna. ");
INSERT INTO amuNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Majoꞌti tjom Jacobo ñequio Juan, ntseinda Zebedeo. Joona mañecwii tꞌmaⁿ tsꞌiaaⁿ cwilꞌana ñequio Simón. Quia joꞌ tso Jesús nnom Simón: —Tintyꞌueꞌ, jeꞌ mamanaⁿtonaꞌ na nnꞌaⁿ nntseitjomꞌ na nlaꞌjomndyena ñꞌeⁿndyo̱, tachii cweꞌ calcaa. ");
INSERT INTO amuNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Jnda̱ na tquiena tyuaatcwii ñꞌeⁿ lꞌaandaa, mana ꞌndyena tsꞌiaaⁿ ꞌnaaⁿna. Tyꞌelajomndyena ñꞌeⁿ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Quia na tyomꞌaaⁿ Jesús cwii tsjoom, tyjeeꞌcañoom cwii tsaⁿsꞌa na chaꞌwaañe chuu tycu lepra. Quia na ntyꞌiaaⁿꞌaⁿ Jesús, tjacwanquioom nomtyuaa, sꞌaaⁿ tyꞌoo, tsoom: —Ta, ntyjii na ꞌu nnda̱a̱ nntseinꞌmaⁿꞌ ja, xeⁿ lꞌue tsꞌomꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Quia joꞌ Jesús seintyjo̱o̱ⁿ tsꞌo̱o̱ⁿ tyeⁿnquioomꞌm tsaⁿꞌñeeⁿ. Tsoom nnom: —Maxjeⁿ lꞌue tsꞌo̱o̱ⁿ na canꞌmaⁿꞌ. Ndoꞌ mantyjacheⁿ nꞌmaⁿ tsaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jnda̱ chii tsoom nnom: —Tintseineiⁿꞌ nnom meiⁿcwii tsꞌaⁿ na luaaꞌ tuii. Sa̱a̱ cjaꞌ, catseicaꞌmo̱ⁿndyuꞌ nnom tyee ndoꞌ quiaaꞌ quiooꞌ na nncueꞌ cantyja na jnda̱ nꞌmaⁿꞌ chaꞌxjeⁿ na sa̱ꞌntjom Moisés. Na nntsaꞌ na luaaꞌ nluiꞌyuuꞌnaꞌ nda̱a̱ nnꞌaⁿ na jnda̱ nꞌmaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Sa̱a̱ tjantyꞌeeti ñꞌoom cantyja ꞌnaaⁿꞌ Jesús. Ndoꞌ jndyendye nnꞌaⁿ tyoꞌoontyjaaꞌ na nndye ñꞌoom na tyoñequiaaⁿ. Mati ñeꞌcanꞌmaaⁿna ntycu na wiina. ");
INSERT INTO amuNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Sa̱a̱ jom teiño̱o̱ⁿ, tjaaⁿ jo yuu na ñenqueⁿ. Joꞌ joꞌ tyotseineiiⁿ nnom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Cwii xueeꞌñeeⁿ maꞌmo̱ⁿ Jesús nda̱a̱ nnꞌaⁿ. Joꞌ joꞌ meindyuaandye ntꞌom nnꞌaⁿ fariseos ñequio nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés. Naⁿꞌñeeⁿ jnaⁿna chaꞌtso njoom nchꞌu tsꞌo̱ndaa Galilea ñequio Judea ndoꞌ mati tsjoom Jerusalén. Ndoꞌ juu najndeii na matseixmaⁿ Tyꞌo̱o̱tsꞌom mꞌaaⁿnaꞌ ñꞌeⁿ Jesús na matseinꞌmaaⁿ nnꞌaⁿwii. ");
INSERT INTO amuNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Mañejuu xjeⁿꞌñeeⁿ tquieꞌcañom ntꞌom naⁿnom na chona tsuee na ndiiꞌ tsꞌaⁿ na jnda̱ teintjeiⁿ ncꞌee na teiꞌcaljoo tycutqueeⁿ. Tyolꞌueeꞌndyena chiuu ya na nncꞌooñꞌomna tsaⁿꞌñeeⁿ naquiiꞌ wꞌaa na nlqueⁿna jom jo nnom Jesús. ");
INSERT INTO amuNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Sa̱a̱ tîcaliuna chiuu ya nlꞌana ee na jeeⁿ jndye nnꞌaⁿ. Joꞌ chii tyꞌewana nacjooꞌ wꞌaa, tjo̱o̱na nquioo, jlaꞌcꞌo̱ⁿna jom na njoom tsuee. Tqueⁿna jom quiiꞌntaaⁿ nnꞌaⁿ jo nnom Jesús. ");
INSERT INTO amuNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Quia na ntyꞌiaaꞌ Jesús na cwilaꞌyuꞌya nꞌom naⁿꞌñeeⁿ, tsoom: —ꞌU re, matseitꞌmaⁿ tsꞌo̱o̱ⁿya jnaⁿꞌ na matseixmaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Quia joꞌ nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés ñequio nnꞌaⁿ fariseos to̱ꞌna na tiya nquiuna ñꞌeⁿñê. Tyolaꞌtiuuna naquiiꞌ nꞌomna: “¿ꞌÑeeⁿ cwiluiiñe tsaⁿmꞌaaⁿꞌ na tiꞌmaaⁿꞌ tsꞌoom na matseineiⁿ ñꞌoom na wjaanaꞌ nacjooꞌ Tyꞌo̱o̱tsꞌom?” ");
INSERT INTO amuNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Seiꞌno̱ⁿꞌ Jesús ñꞌomtiuu ꞌnaaⁿna. Tsoom nda̱a̱na: —¿Chiuu na ticuaaya nquiuꞌyoꞌ ñꞌeⁿndyo̱? ");
INSERT INTO amuNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Cwaaⁿ ñꞌoom na tijndeiꞌtinaꞌ na catsjo̱o̱ya? ¿Aa na nntsjo̱o̱: “Matseitꞌmaⁿ tsꞌo̱o̱ⁿya chaꞌtso jnaⁿꞌ”, oo aa na nntsjo̱o̱: “Quicantyjaꞌ, cjaꞌcaꞌ”? ");
INSERT INTO amuNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Sa̱a̱ cha caliuꞌyoꞌ na cwiluiindyo̱ tsaⁿ na jnaⁿ cañoomꞌluee ndoꞌ na waa najndeii na matseixmaⁿya nnom tsjoomnancuewaa na catseitꞌmaⁿ tsꞌo̱o̱ⁿya jnaaⁿ nnꞌaⁿ, quia joꞌ tsoom nnom tsꞌaⁿ na ntjeiⁿ ncꞌee: —ꞌU re, matsjo̱o̱ya njomꞌ, quicantyjaꞌ, catseilcwiindyuꞌ tsueꞌ cjaꞌtoꞌ waꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Mañoomꞌ teicantyja tsaⁿꞌñeeⁿ na jndooꞌ chaꞌtso nnꞌaⁿ. Seilcwiiñê tsuee ꞌnaaⁿꞌaⁿ na ñetuaaⁿ. Mana tjaaⁿ waⁿꞌaⁿ. Jeeⁿ matseitꞌmaaⁿꞌñê Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ndoꞌ tyueneiiⁿ chaꞌtsondye nnꞌaⁿ. Tyolaꞌtꞌmaaⁿꞌndyena Tyꞌo̱o̱tsꞌom. Jluena ñequio na tyueneiiⁿna: —Xuee jeꞌ ntyꞌiaa nda̱a̱ya cwii na jeeⁿ tꞌmaⁿ, na meiⁿjom tiquintyꞌiaaya. ");
INSERT INTO amuNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Jnda̱ tuii na luaaꞌ, jluiꞌ Jesús joꞌ joꞌ. Ljeiiⁿ cwii tsaⁿcoꞌñom sꞌom na jndyu Leví. Wacatyeeⁿ tsaⁿꞌñeeⁿ wꞌaa yuu na cwiꞌoocatioom nnꞌaⁿ sꞌom tsꞌiaaⁿnda̱a̱na cwentaaꞌ gobiernom. Quia joꞌ tsoom nnom tsaⁿꞌñeeⁿ: —Candyoꞌntyjo̱ꞌ naxa̱ⁿꞌa. ");
INSERT INTO amuNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Mantyja teicantyja Leví, tjeiꞌñê cantyja ꞌnaaⁿꞌ tsꞌiaaⁿꞌñeeⁿ, chii tjatseijomñê ñꞌeⁿ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ndoꞌ seiñꞌoomꞌñê cwii nantquie tꞌmaⁿ waⁿꞌaⁿ cwentaaꞌ Jesús. Seitjoom jndye ncꞌiaaⁿꞌaⁿ na ñequio ñetoꞌñoom sꞌom tsꞌiaaⁿnda̱a̱ nnꞌaⁿ cwentaaꞌ gobiernom. Teindyuaandyena nacañoomꞌ meiⁿsa ñꞌeⁿñê ndoꞌ ñꞌeⁿ Jesús ñequio ntꞌomcheⁿ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ndoꞌ nnꞌaⁿ fariseos ñequio nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés tyolaꞌncjooꞌndyena nacjoo nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿ Jesús. Jluena nda̱a̱ naⁿꞌñeeⁿ: —¿Chiuu na cwicwaꞌyoꞌ ndoꞌ cwiweꞌyoꞌ ñequio nnꞌaⁿ na cwitoꞌñoom sꞌom cwentaaꞌ gobiernom, ndoꞌ ñequio nnꞌaⁿ na cwilaꞌtjo̱o̱ndyena nnom Tyꞌo̱o̱tsꞌom? ");
INSERT INTO amuNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Tꞌo̱ Jesús nda̱a̱na, tsoom: —Nnꞌaⁿ na tiwii titjo̱o̱ndyena tsꞌaⁿ na machꞌee nasei, sa̱a̱ nnꞌaⁿ na wii tjo̱o̱ndyena jom. ");
INSERT INTO amuNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ja nchii jndyo̱o̱ya na nncwaⁿya nnꞌaⁿ na cwilaꞌjomndye cantyja na matyꞌiomyanaꞌ. Ja jndyo̱o̱ya na nncwaⁿya nnꞌaⁿjnaⁿ na calcweꞌ nꞌomna. ");
INSERT INTO amuNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Quia joꞌ tyoluena nnom Jesús: —Nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿ Juan, jndye ndiiꞌ cwilaꞌcwejndoꞌndyena ndoꞌ cwilaꞌneiⁿna nnom Tyꞌo̱o̱tsꞌom. Ndoꞌ majoꞌti cwilꞌa nnꞌaⁿ tmaaⁿꞌ fariseos. Sa̱a̱ joo nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿndyuꞌ cwicwaꞌna ndoꞌ cwiwena. ¿Chiuu na luaaꞌ cwilꞌana? ");
INSERT INTO amuNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Tꞌo̱o̱ⁿ nda̱a̱na: —¿Aa ndyaꞌ nnduꞌyoꞌ nda̱a̱ nnꞌaⁿ na tquiolaꞌjomndyena na macoco tsꞌaⁿ na calaꞌcwejndoꞌndyena yocheⁿ na ndicwaⁿ mꞌaaⁿ nquii tsaⁿsꞌa na macoco quiiꞌntaaⁿna? ");
INSERT INTO amuNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Sa̱a̱ nncueꞌntyjo̱ xuee na nncwjiꞌnaꞌ jom quiiꞌntaaⁿna, ncueeꞌñeeⁿ nlaꞌcwejndoꞌndyena. ");
INSERT INTO amuNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Mati seineiiⁿ nda̱a̱na ñꞌoom na wjaañoomꞌ cantyja ꞌnaaⁿꞌ ñꞌoom xco na maꞌmo̱o̱ⁿ nda̱a̱na. Tsoom: —Tjaaꞌnaⁿ ꞌñeeⁿ nntyjee cwii taⁿꞌ liaaꞌ, liaa xco na nntseiyo̱ liaa ntsaa ñꞌeⁿ juunaꞌ. Ee xeⁿ luaaꞌ nntsꞌaa tsꞌaⁿ, nntseiꞌnaaⁿꞌaⁿ liaaⁿꞌaⁿ liaa xcoꞌñeeⁿ ndoꞌ nchii macanda̱ joꞌ, mati tixocatseixꞌiaaꞌñenaꞌ ñequio liaa ntsaaꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Meiⁿ tjaa ꞌñeeⁿ juu nntiom winom xco nꞌom ntjaⁿ teindyo. Ee xeⁿ na ljoꞌ nntsꞌaa tsꞌaⁿ, nntyꞌiooꞌnaꞌ nlꞌa winom xcoꞌñeeⁿ, mana cwiwiꞌndaaꞌ winom ndoꞌ mati ntjaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Joꞌ chii macaⁿnaꞌ na nncꞌoocue winom xco nꞌom ntjaⁿ xco cha meiⁿ ntjaⁿ xcoꞌñeeⁿ ticwiꞌndaaꞌnaꞌ ndoꞌ meiⁿ winom. ");
INSERT INTO amuNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ee tsꞌaⁿ na maꞌuu winom tquie, meiⁿchjoo ticaꞌnaⁿ ntyjii winomxco. Ee matsoom na joo winom tquie, joꞌ caꞌnaⁿti. ");
INSERT INTO amuNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Luaa tuii cwii xuee na cwitaꞌjndyee nnꞌaⁿ judíos. Mawinom Jesús yuu na niom ntjom lqueeⁿ trigo. Ndoꞌ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê, tyꞌiooꞌndyena xuꞌlqueeⁿ. Tyꞌueeꞌndyena joonaꞌ nꞌom lueena jnda̱ chii tquiina. ");
INSERT INTO amuNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Quia joꞌ ntꞌom nnꞌaⁿ tmaaⁿꞌ fariseos jluena: —¿Chiuu na cwilꞌaꞌyoꞌ cwii na ticatsa̱ꞌntjomnaꞌ xuee na cwitaꞌjndyee nnꞌaⁿ? ");
INSERT INTO amuNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Tꞌo̱ Jesús, tsoom nda̱a̱na: —ꞌO, ¿aa tyoolaꞌnaⁿꞌyoꞌ ñꞌoom chiuu sꞌaa David quia na tꞌoom na ñeꞌjnoomꞌm, ndoꞌ mati nnꞌaⁿ na ñꞌeeⁿ ñꞌeⁿñê? ");
INSERT INTO amuNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Tjaqueⁿꞌeⁿ watsꞌom cwentaaꞌ Tyꞌo̱o̱tsꞌom, tcaaⁿ ntyooꞌ na jnda̱ tqueⁿ nnꞌaⁿ jo nnom Tyꞌo̱o̱tsꞌom. Ndoꞌ ntyooꞌñeeⁿ macanda̱ ntyee wanaaⁿ na nlcwaꞌna joonaꞌ. Sa̱a̱ tcwaꞌ David joonaꞌ ndoꞌ mati tquiaaⁿ na tcwaꞌ nnꞌaⁿ na ñꞌeeⁿ ñꞌeñê. ");
INSERT INTO amuNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Quia joꞌ tsoom nda̱a̱na: —Ja na cwiluiindyo̱ tsaⁿ na jnaⁿ cañoomꞌluee waa na jndo̱ na nntsjo̱o̱ ljoꞌ calꞌa nnꞌaⁿ meiiⁿ xuee na cwitaꞌjndya̱a̱ya. ");
INSERT INTO amuNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Cwiicheⁿ xuee na cwitaꞌjndyee nnꞌaⁿ, tjaquieeꞌ Jesús watsꞌom chjoo. Tyoꞌmo̱o̱ⁿ nda̱a̱ nnꞌaⁿ. Ndoꞌ joꞌ joꞌ mꞌaaⁿ cwii tsaⁿsꞌa na jnda̱ tjateii tsꞌo̱ ntyjaya. ");
INSERT INTO amuNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ndoꞌ nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés ñequio nnꞌaⁿ fariseos, jeeⁿ tyoqueⁿna cwenta xeⁿ na nntseinꞌmaⁿ Jesús tsꞌaⁿwiiꞌ xuee na cwitaꞌjndyeena, cha quia joꞌ nnda̱a̱ nñeꞌquiana jnaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Sa̱a̱ mantyjeeⁿ chiuu cwilaꞌtiuuna, joꞌ chii tsoom nnom tsꞌaⁿ na jnda̱ tjateii tsꞌo̱: —Quicantyjaꞌ, cwintyjeꞌ quiiꞌntaaⁿ nnꞌaⁿ. Ndoꞌ teicantyja tsaⁿꞌñeeⁿ, teintyjeeⁿꞌeⁿ xcwe. ");
INSERT INTO amuNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Jnda̱ joꞌ tso Jesús nda̱a̱na: —Nncwaxꞌa̱ cwii ñꞌoom nda̱a̱ꞌyoꞌ, xuee na cwitaꞌjndya̱a̱ya, ¿aa wanaaⁿ na cateijndeii tsꞌaⁿ xꞌiaaⁿꞌaⁿ na wiꞌ matjom oo aa ticateijneiⁿ juu? ¿Aa cwjiꞌnꞌmaaⁿñê xꞌiaaⁿꞌaⁿ cha ticueꞌ oo aa caꞌñeeⁿ na cueꞌ? ");
INSERT INTO amuNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jnda̱ chii ntyꞌiaaⁿꞌaⁿ nda̱a̱ chaꞌtsondye nnꞌaⁿ, tsoom nnom tsꞌaⁿwiiꞌ: —Catseiliuuꞌ tsꞌo̱ꞌ. Sꞌaa tsaⁿꞌñeeⁿ na ljoꞌ ndoꞌ tcoꞌyaꞌñꞌeⁿnaꞌ tsꞌo̱o̱ⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Jnaaⁿꞌ joꞌ jeeⁿ jlaꞌwjeena Jesús. Ndoꞌ tyoꞌmaⁿna ñꞌeⁿ ncꞌiaana ljoꞌ nnda̱a̱ nlꞌana jom. ");
INSERT INTO amuNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Joo ncueeꞌñeeⁿ tjawa Jesús cwii ta naquiiꞌ jnda̱a̱ na nntseineiiⁿ nnom Tyꞌo̱o̱tsꞌom. Ndoꞌ meiiⁿnchaaꞌ tsjom tyotseineiiⁿ nnom. ");
INSERT INTO amuNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Quia na jnda̱ teixuee, tcwaaⁿ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê. Quiiꞌntaaⁿna tjeiiꞌñê canchooꞌwendye nnꞌaⁿ na seicajñoom joona apóstoles, nnꞌaⁿ na majñom Tyꞌo̱o̱tsꞌom tsꞌiaaⁿ ꞌnaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Nmeiiⁿ ncueena: Simón, tsaⁿ na seicajñoom Pedro, ñequio tyjee tsaⁿꞌñeeⁿ, Andrés, ñꞌeⁿ Jacobo ñequio Juan, ñꞌeⁿ Felipe ñequio Bartolomé, ");
INSERT INTO amuNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ñꞌeⁿ Mateo ñequio Tomás, ñꞌeⁿ Jacobo jnda Alfeo, ndoꞌ ñꞌeⁿ Simón na cwiluena cananista, ");
INSERT INTO amuNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ñꞌeⁿ Judas jnda Jacobo ñequio Judas Iscariote, tsꞌaⁿ na tquiaa cwenta Jesús. ");
INSERT INTO amuNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jndyocue Jesús ñequio chaꞌtso nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê. Tyꞌemeintyjeeꞌna cwii su. Joꞌ joꞌ jnda̱ tquieꞌcañom ntꞌomcheⁿ nnꞌaⁿ na cwilaꞌjomndye ñꞌoom na mañequiaaⁿ ñequio jndyendye nnꞌaⁿ na jnaⁿ chaꞌwaa Judea ñequio Jerusalén ñequio ꞌndyoo ndaaluee na nndyooꞌ tsjoom Tiro ñꞌeⁿ Sidón. Naⁿꞌñeeⁿ tquiona na nndyena ñꞌoom na mañequiaaⁿ, ndoꞌ na nntseinꞌmaaⁿ joona ntycu na cwitjoomna. ");
INSERT INTO amuNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Mati seinꞌmaaⁿ nnꞌaⁿ na jeeⁿ cwajndii tyoleichuu jndyetia. ");
INSERT INTO amuNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Chaꞌtsondye nnꞌaⁿ tyolꞌueeꞌndyena chiuu ya cha nnda̱a̱ nñeꞌquioꞌna jom, ee waa najneiⁿ na nnꞌmaⁿ tsꞌaⁿ xeⁿ nnda̱a̱ nñequiuuꞌ jom. Joꞌ chii chaꞌtsondyena nꞌmaaⁿna. ");
INSERT INTO amuNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Quia joꞌ ntyꞌiaaⁿꞌaⁿ nda̱a̱ nnꞌaⁿ na cwilaꞌjomndye ñꞌoom na mañequiaaⁿ, tsoom nda̱a̱na: —ꞌO nnꞌaⁿ na ntyꞌiaandyoꞌ, mañequiaanaꞌ na neiⁿꞌyoꞌ, ee cwilaxmaⁿꞌyoꞌ cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","’ꞌO nnꞌaⁿ na cwiweꞌjndoꞌyoꞌ jeꞌ, mañequiaanaꞌ na neiⁿꞌyoꞌ ee quia nñequiaa Tyꞌo̱o̱tsꞌom chaꞌcwijom na jnda̱ tjacjoꞌyoꞌ. ’ꞌO nnꞌaⁿ na cwityueeꞌyoꞌ jeꞌ, mañequiaanaꞌ na neiⁿꞌyoꞌ ee macwjiꞌ Tyꞌo̱o̱tsꞌom na chjooꞌ nꞌomꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","’Mañequiaanaꞌ na neiⁿꞌyoꞌ quia na cwilaꞌjndoo nnꞌaⁿ ꞌo na cwileiꞌntyjo̱na ꞌo, na cwilaꞌjnaaⁿꞌna ꞌo, ndoꞌ na cwilꞌana na ticueeꞌ nꞌomna ꞌo ncꞌe na mꞌaⁿꞌyoꞌ cantyja ꞌnaⁿ ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Manmeiiⁿꞌ tyotaꞌwiꞌ weloo naⁿꞌñeeⁿ profetas na tyoñequia ñꞌoomꞌ Tyꞌo̱o̱tsꞌom tandyo xuee. Joꞌ chii cꞌomꞌyoꞌ na tꞌmaⁿ nꞌomꞌyoꞌ xuee na cwitjomꞌyoꞌ nawiꞌmeiⁿꞌ. Ee tꞌmaⁿ naya ꞌnaⁿꞌyoꞌ cwiwiwe cañoomꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","’Sa̱a̱ nntꞌuiiwiꞌnaꞌ ꞌo nnꞌaⁿ na cwiluiitꞌmaⁿndyoꞌ na quitꞌmaⁿ nꞌomꞌyoꞌ juu na tyandyoꞌ. Ee cweꞌ cantyjati jeꞌ na mañequiaanaꞌ na tꞌmaⁿ nꞌomꞌyoꞌ na jeeⁿ lꞌue mꞌaⁿꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","’Nntꞌuiiwiꞌnaꞌ ꞌo nnꞌaⁿ na cwicwaꞌjaacjoꞌyoꞌ jeꞌ. Ee nncueꞌntyjo̱ xuee na nncꞌomꞌyoꞌ chaꞌcwijom na ñejndoꞌyoꞌ. ’Nntꞌuiiwiꞌnaꞌ ꞌo nnꞌaⁿ na jeeⁿ neiⁿꞌyoꞌ jeꞌ. Ee nncueꞌntyjo̱ xuee na nntyueeꞌyoꞌ ndoꞌ nlaꞌxuaꞌyoꞌ na chjooꞌ nꞌomꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","’Nntꞌuiiwiꞌnaꞌ ꞌo nnꞌaⁿ na jeꞌ jndye nnꞌaⁿ cwitjeiiꞌyana ꞌo. Ee maluaaꞌ ñelꞌa weloo naⁿꞌñeeⁿ. Tyoluena ñꞌoom ya cantyja ꞌnaaⁿ joo profetas na cweꞌ tyonquioꞌnnꞌaⁿ joona. ");
INSERT INTO amuNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","’Sa̱a̱ matsjo̱o̱ya nda̱a̱ꞌ ꞌo nnꞌaⁿ na cwindyeꞌyoꞌ ñꞌoom na mañequiaya: Cꞌomꞌyoꞌ na wiꞌ nꞌomꞌyoꞌ nnꞌaⁿ na jndoo ꞌo. Ndoꞌ calꞌaꞌyoꞌ na ya nnꞌaⁿndyoꞌ ñꞌeⁿ nnꞌaⁿ na ticueeꞌ nꞌom ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Cataⁿꞌyoꞌ na catioꞌnaaⁿñe Tyꞌo̱o̱tsꞌom nnꞌaⁿ na cwitueeꞌ ñꞌoom wiꞌ nacjoꞌyoꞌ. Ndoꞌ calaneiⁿꞌyoꞌ nnoom cantyja ꞌnaaⁿ nnꞌaⁿ na cwilaꞌjnaaⁿꞌna ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ꞌÑeeⁿ na mmeiⁿꞌ ndaꞌ ntsmaⁿꞌ, mati cwiicheⁿ ntyja quiaaꞌ na mmeiⁿꞌ ndaꞌ. Ndoꞌ ꞌñeeⁿ na nncwjiꞌ liaatco ꞌnaⁿꞌ, mati quiaaꞌ cotomꞌ na nncjaañꞌoom. ");
INSERT INTO amuNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Meiⁿꞌñeeⁿcheⁿ tsꞌaⁿ na macaⁿ cwii ꞌnaⁿ njomꞌ, quiaaꞌ. Ndoꞌ xeⁿ tjañꞌoom tsꞌaⁿ ꞌnaⁿꞌ ndoꞌ tiñeꞌcatseilcweeⁿꞌeⁿ juunaꞌ, tintseincjooꞌndyuꞌ na calcweꞌnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Chaꞌxjeⁿ na lꞌue nꞌomꞌyoꞌ na calꞌa nnꞌaⁿ ñꞌeⁿndyoꞌ, majoꞌti calꞌaꞌ ꞌo ñꞌeⁿndye joona. ");
INSERT INTO amuNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","’Xeⁿ mꞌaⁿꞌyoꞌ na wiꞌ nꞌomꞌyoꞌ cweꞌ tomti nnꞌaⁿ na mati wiꞌ nꞌom ꞌo, quia joꞌ ¿yuu waa na yaticheⁿ cwilꞌaꞌyoꞌ? Ee nnꞌaⁿ na tyoolaꞌtꞌmaaⁿꞌndyena Tyꞌo̱o̱tsꞌom mꞌaⁿna na wiꞌ nꞌomna ncꞌiaana na wiꞌ nꞌom joona. ");
INSERT INTO amuNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Xeⁿ cwilꞌaꞌyoꞌ na ya nnꞌaⁿndyoꞌ cweꞌ tomti ñꞌeⁿ nnꞌaⁿ na mati cwilꞌa na ya nnꞌaⁿndyena ñꞌeⁿndyoꞌ, ¿yuu waa na jeeⁿ ya cwilꞌaꞌyoꞌ? Ee mati nnꞌaⁿ na cwilaꞌxmaⁿ jnaⁿ majoꞌti cwilꞌana. ");
INSERT INTO amuNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ndoꞌ xeⁿ cwiteiꞌjndeiꞌyoꞌ ꞌnaⁿ nnꞌaⁿ na nquiuꞌyoꞌ na mati joo nnteiꞌjndeii ꞌo, quia joꞌ ¿yuu waa na yaticheⁿ cwilꞌaꞌyoꞌ? Ee mati nnꞌaⁿ na cwilaꞌxmaⁿ jnaⁿ cwiteiꞌjndeiina ꞌnaⁿ nda̱a̱ ncꞌiaana ee manquiuna na nnjoom joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Sa̱a̱ ꞌo jeꞌ cꞌomꞌyoꞌ na wiꞌ nꞌomꞌyoꞌ nnꞌaⁿ na jndoo ꞌo. Calꞌaꞌyoꞌ na ya nnꞌaⁿndyoꞌ ñequio chaꞌtsondye nnꞌaⁿ. Cateiꞌjndeiꞌyoꞌ ꞌnaⁿ na cwileiꞌñꞌomꞌyoꞌ nnꞌaⁿ, meiiⁿ ticantyjaaꞌ nꞌomꞌyoꞌ na nlaꞌlcweꞌna. Quia joꞌ tꞌmaⁿ naya nndaꞌyoꞌ cañoomꞌluee. Ndoꞌ nlaxmaⁿꞌyoꞌ ntseinda Tyꞌo̱o̱tsꞌom na mꞌaaⁿ nandyeticheⁿ. Ee mati jom mꞌaaⁿ na wiꞌ tsꞌoom meiiⁿ nnꞌaⁿ na lꞌo̱ meiiⁿ machꞌeeⁿ ya joona. Ndoꞌ wiꞌ tsꞌoom nnꞌaⁿ na wiꞌndye. ");
INSERT INTO amuNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Cꞌomꞌyoꞌ na wiꞌ nꞌomꞌyoꞌ chaꞌtsondye nnꞌaⁿ chaꞌxjeⁿ nquii Tsotyeꞌyoꞌ mꞌaaⁿ na wiꞌ tsꞌoom chaꞌtsondye nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Tintuꞌxeⁿꞌyoꞌ nnꞌaⁿ na cweꞌ xjeⁿto ꞌo, cha meiⁿ tincuꞌxeⁿ Tyꞌo̱o̱tsꞌom ꞌo. Tintioꞌyoꞌ nnꞌaⁿ lꞌo̱ nawiꞌ cha tintioom ꞌo lꞌo̱ nawiꞌ. Calaꞌtꞌmaⁿ nꞌomꞌyoꞌ nnꞌaⁿ cha mati nntseitꞌmaⁿ tsꞌoom ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Quiaꞌyoꞌ na cateijndeiinaꞌ nnꞌaⁿ, quia joꞌ mati nntoꞌñoomꞌyoꞌ na nnteijndeiinaꞌ ꞌo. Ee Tyꞌo̱o̱tsꞌom nñequiaaⁿ na nntoꞌñoomꞌyoꞌ cwii na canda̱a̱ꞌ tuꞌxeⁿnaꞌ. Joꞌ joꞌ matseijomnaꞌ chaꞌcwijom cwii ꞌnaⁿ na teincwiiꞌnaꞌ, tyeⁿ tyꞌecuenaꞌ hasta tooꞌ wantyjo. Ee cantyjati xjeⁿ na cwiñeꞌquiaꞌyoꞌ nda̱a̱ nnꞌaⁿ, majoꞌti nntseilcweꞌ Tyꞌo̱o̱tsꞌom na cwii nnjoom nda̱a̱ꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Mati seineiⁿ Jesús nda̱a̱na cwii ñꞌoom na tjañoomꞌ, tsoom: —¿Aa nnda̱a̱ nncjaañꞌoom tsaⁿnchjaaⁿꞌ cwiicheⁿ tyjenchjaaⁿꞌaⁿ? ¿Aa nchii wendyena nntiomnaꞌ tsꞌom tsueꞌtsjoom? ");
INSERT INTO amuNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Xocatsꞌaanaꞌ na tsꞌaⁿ na matseiꞌnaaⁿꞌ cwiluiitꞌmaⁿñetyeeⁿ, nchiiti tsꞌaⁿ na maꞌmo̱ⁿ nnoom. Sa̱a̱ quia na jnda̱ seiꞌnaaⁿꞌñꞌeeⁿ chaꞌtso na tꞌmo̱ⁿ tsaⁿꞌñeeⁿ nnoom, quialjoꞌcheⁿ nntseijomnaꞌ jom chaꞌna tsꞌaⁿ na tꞌmo̱ⁿ nnoom. ");
INSERT INTO amuNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","’¿Chiuu na jeeⁿ ndoꞌ jnda̱ na njom tsꞌomnnom xꞌiaꞌ, sa̱a̱ tiqueⁿꞌ cwenta tsꞌoom tscaaꞌ na njom tsꞌomnjomꞌ nncuꞌ? ");
INSERT INTO amuNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","¿Chiuu na jeeⁿ ñeꞌcatseijndaaꞌndyuꞌ jnaaⁿꞌ xꞌiaꞌ? ¿Aa nntsuꞌyuꞌ nnoom: “Cwa ꞌu nnꞌaⁿya, quiaaꞌ na nncwjiiꞌa ntquiooꞌ jnda̱ na njom tsꞌomnjomꞌ”, sa̱a̱ manncuꞌ tiqueⁿꞌ cwenta tsꞌoom tscaaꞌ na njom tsꞌomnjomꞌ? ꞌU tsꞌaⁿ na macheꞌ na matseicanda̱a̱ꞌndyuꞌ cha cantyꞌiaa nnꞌaⁿ, najndyee cwjiꞌ tsꞌoom tscaaꞌ na njom tsꞌomnjomꞌ nncuꞌ, quia joꞌ tquioꞌyaꞌ na nncwjiꞌ ntquiooꞌ jnda̱ tsꞌomnnom xꞌiaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","’Ticwii cwii tsꞌoom na ya xocatsꞌaanaꞌ ta̱ na tisꞌa. Ndoꞌ tsꞌoom na tisꞌa meiⁿ xocatsꞌaanaꞌ ta̱ na ya. ");
INSERT INTO amuNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ticwii cwii tsꞌoom, ta̱a̱ꞌnaꞌ maꞌmo̱ⁿnaꞌ ljoꞌ tsꞌoom juunaꞌ. Ee tijoom nntseicjoo tsꞌaⁿ ta̱ higo tsꞌoom nioom. Meiⁿ tijoom nntseicjoo tsꞌaⁿ ta̱uva cwii tsꞌo̱o̱ nioom. ");
INSERT INTO amuNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Maluaaꞌ matseijomnaꞌ nnꞌaⁿ chaꞌna nꞌoom ntjom. Juu tsꞌaⁿ na ya tsꞌaⁿñe, machꞌeeⁿ yuu na ya, ee naquiiꞌ tsꞌoom cwinaⁿ na ya na matseitioom. Sa̱a̱ tsꞌaⁿ na wiꞌñe, machꞌeeⁿ yuu na tisꞌa, ee naquiiꞌ tsꞌoom cwinaⁿ nawiꞌ na matseitioom. Ticwii cwii tsꞌaⁿ cantyjati na matseitiuu naquiiꞌ tsꞌom, maxjeⁿ joꞌ matseineiⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","’¿Chiuu na cwinduꞌyoꞌ na Ta ja quia na cwiꞌmaⁿꞌyoꞌ ja ndoꞌ tiñeꞌcalacanda̱ꞌyoꞌ ñꞌoom na matsjo̱o̱ nda̱a̱ꞌyoꞌ? ");
INSERT INTO amuNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ticwii cwii tsꞌaⁿ na macwjeeꞌcañoom ja na mandii ñꞌoom na matsjo̱o̱ nmeiiⁿ, ndoꞌ matseicanda̱ joonaꞌ, mꞌmo̱o̱ⁿya nda̱a̱ꞌyoꞌ chiuu matseijomnaꞌ tsaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Matseijomnaꞌ jom chaꞌcwijom cwii tsꞌaⁿ na jndo̱ꞌ tsꞌom na sꞌaa waaꞌ. Tyocaꞌñeeⁿ njoom, tyeⁿ tqueeⁿ tsiaⁿtsjo̱ꞌ cha jndeii wꞌaa. Quia na tyjeeꞌ jndaa, tco̱o̱naꞌ tyuaatcwii, jndeii tyocjaacameiiⁿꞌñenaꞌ ndaa wꞌaaꞌñeeⁿ. Sa̱a̱ tîcatsꞌeiinaꞌ ee na tyeⁿ tjaluiinaꞌ nacjooꞌ tsiaⁿtsjo̱ꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Sa̱a̱ juu tsꞌaⁿ na cweꞌ mandii ñꞌoom na matsjo̱o̱ ndoꞌ titseicanda̱ joonaꞌ, tsaⁿꞌñeeⁿ matseijomnaꞌ chaꞌcwijom cwii tsꞌaⁿ na tijndo̱ꞌ tsꞌom na sꞌaa waaꞌ na cweꞌ jnaⁿtonaꞌ nomtyuaa. Tjaaꞌnaⁿ niaⁿljo̱ꞌ tuii. Quia na tyjeeꞌ jndaa ndoꞌ jndeii tyocjaacameiiⁿꞌñenaꞌ wꞌaaꞌñeeⁿ, mantyja tmeiⁿꞌnaꞌ juunaꞌ. Ndoꞌ tꞌmaaⁿꞌ tsuu cantyja ꞌnaaⁿꞌnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jnda̱ na seineiⁿ Jesús chaꞌtso ñꞌoommeiⁿꞌ na tyondye nnꞌaⁿ, quia joꞌ tjaaⁿ tsjoom Capernaum. ");
INSERT INTO amuNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Tsjoomꞌñeeⁿ mꞌaaⁿ cwii capeitaⁿ na matsa̱ꞌntjom cwii siaⁿnto sondaro. Ndoꞌ mꞌaaⁿ cwii mosoomꞌm na jeeⁿ wiꞌ tsꞌoom, mañeꞌcueꞌ na nioom wiiꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Quia na jñeeⁿ ñꞌoom cantyja ꞌnaaⁿꞌ Jesús, jñoom ntꞌom nnꞌaⁿ na cwiluiitquiendye nda̱a̱ nnꞌaⁿ judíos na cꞌoocalꞌana tyꞌoo na candyoya Jesús na nntseinꞌmaⁿ tsaⁿꞌñeeⁿ mosoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Jnda̱ tquiena na mꞌaaⁿ Jesús, ñequio ñꞌoom tyꞌoo tyoluena nnoom: —Tsꞌaⁿ na jñom jâ, ya tsꞌaⁿñe, joꞌ chii matyꞌiomnaꞌ na catseiñꞌoomꞌndyuꞌ jom. ");
INSERT INTO amuNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ee jeeⁿ wiꞌ tsꞌoom jaa nnꞌaⁿ tsjaaⁿ Israel, ndoꞌ sꞌaaⁿ watsꞌom ꞌnaaⁿyâ. ");
INSERT INTO amuNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Quia joꞌ tja Jesús ñꞌeⁿ naⁿꞌñeeⁿ. Quia maꞌooquiena waaꞌ capeitaⁿ, jñom tsaⁿꞌñeeⁿ ntꞌom nnꞌaⁿ na ya ñꞌoom jom ñꞌeⁿndye na cꞌoocaluena nnom Jesús: —Ta, ndiꞌ matso tsꞌaⁿ na wiiꞌ mosooꞌ ticatseixmaaⁿ na nncjaꞌquieꞌ naquiiꞌ waⁿꞌaⁿ, joꞌ chii tiñeꞌtseicachjuutyeeⁿ ꞌu. ");
INSERT INTO amuNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Meiⁿ cweꞌ na nndyocatjomñê ꞌu, ticatseixmaaⁿ. Ndoꞌ ntyjeeⁿ na meiiⁿ cweꞌ ñꞌoom na nntsuꞌ, nnꞌmaⁿ mosoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ee jom mꞌaaⁿ nacje ꞌnaaⁿꞌ tsꞌaⁿ na matsa̱ꞌntjom jom. Ndoꞌ mati mꞌaⁿ sondaro nacje ꞌnaaⁿꞌaⁿ. Quia na nntsoom nnom cwii joona: “Luaaꞌ cjaꞌ”, wjaa tsaⁿꞌñeeⁿ. Ndoꞌ quia na nntsoom nnom cwiicheⁿ: “Candyoꞌ luaa”, ndyo. Mati quitsoom nnom cwii cwii mosoomꞌm: “Catsaꞌ luaa”, ndoꞌ nntsꞌaa. ");
INSERT INTO amuNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Quia na jndii Jesús ñꞌoomwaaꞌ, jeeⁿ tjaweeꞌ tsꞌoom cantyja ꞌnaaⁿꞌ tsaⁿꞌñeeⁿ. Taqueeⁿ ntyꞌiaaⁿꞌaⁿ nda̱a̱ nnꞌaⁿ na ꞌoontyjo̱ naxeeⁿꞌeⁿ, tsoom: —Candyeꞌyoꞌ nntsjo̱o̱, meiⁿ cwii tsꞌaⁿ tyooljeiya quiiꞌntaaⁿ jaa nnꞌaⁿ Israel, na tꞌmaⁿ matseiyuꞌya tsꞌom chaꞌna tsaⁿmꞌaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Quia na jnda̱ tyꞌelcweeꞌ nnꞌaⁿ na jñom capeitaⁿ, jliuna na jnda̱ nꞌmaⁿ moso na wiiꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Jnda̱ tuii na luaaꞌ, tja Jesús tsjoom na jndyu Naín. Ndoꞌ jndye nnꞌaⁿ na cwilaꞌjomndye ñꞌoom na mañequiaaⁿ tyꞌena ñꞌeⁿñê ñequio jndye ntꞌomcheⁿ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Quia na jnda̱ teindyoona ꞌndyootsꞌa tatiom nnom tsjoom, jliuna na cwicaluiꞌ nnꞌaⁿ na ꞌoocatyꞌiuu tsꞌoo, tsaⁿsꞌa jnda cwii yuscu na jnda̱ ljoñe. Tsaⁿsꞌaꞌñeeⁿ macanda̱ ñenquii tuiiñe. Jndye nnꞌaⁿ tsjoomꞌñeeⁿ tyꞌelaꞌjomndye ñꞌeⁿ yuscuꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jnda̱ na ntyꞌiaaꞌ Ta Jesús yuscuꞌñeeⁿ tioo na jeeⁿ wiꞌ tsꞌoom juu. Tsoom nnom: —Tantyꞌiooꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Quia joꞌ tjantyjaaⁿꞌaⁿ, tyeⁿnquioomꞌm yuu na njom tsꞌoo. Ndoꞌ nnꞌaⁿ na cho juunaꞌ, tyꞌemeiꞌntyjeeꞌna. Matsoom nnom tsꞌooꞌñeeⁿ: —Aa ndiꞌ sa, matsjo̱o̱ njomꞌ: Quicantyjaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ndoꞌ teicantyja tsꞌaⁿ na jnda̱ tueꞌ, to̱o̱ⁿꞌo̱ⁿ na matseineiiⁿ. Tquiaa Jesús jom lꞌo̱ tsoñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Jeeⁿ ndyaꞌ seicatyꞌuenaꞌ chaꞌtso nnꞌaⁿ. Tyolaꞌtꞌmaaⁿꞌndyena Tyꞌo̱o̱tsꞌom, tyoluena: —Jnda̱ teitquiooꞌñe cwii profeta quiiꞌntaaⁿya na tꞌmaⁿ tseixmaaⁿ. Ndoꞌ mati tyoluena: —Tyꞌo̱o̱tsꞌom jnda̱ tyjeeꞌcañoom na mateijneiⁿ jaa na cwiluiindyo̱ cwentaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ndoꞌ tjantyꞌee ñꞌoom cantyja ꞌnaaⁿꞌ na luaaꞌ sꞌaa Jesús chaꞌwaa tsꞌo̱ndaa Judea ñequio njoom na niom ndiocheⁿ joꞌ joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Nnꞌaⁿ na cwilaꞌjomndye ñꞌoom na mañequiaa Juan, jlaꞌcandiina jom chaꞌtso ñꞌoommeiⁿꞌ. Quia joꞌ tꞌmaaⁿ wendye naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Jñoom joona na cꞌootaꞌxꞌena ꞌndyoo Jesús, ¿aa jom cwiluiiñê nquii na nncwjeeꞌcañoom tsjoomnancue oo aa nncwindooꞌna cwiicheⁿ? ");
INSERT INTO amuNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ndoꞌ quia na jnda̱ tquieꞌcañom naⁿꞌñeeⁿ Jesús, jluena nnoom: —Juan tsaⁿ na matseitsꞌoomñe nnꞌaⁿ, jom jñoom jâ na mꞌaaⁿꞌ na cataꞌxꞌa̱a̱yâ njomꞌ: “¿Aa ꞌu cwiluiindyuꞌ nquii na nncwjeeꞌcañoom tsjoomnancue, oo aa nncwindo̱o̱ꞌâ cwiicheⁿ?” ");
INSERT INTO amuNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Juu xjeⁿꞌñeeⁿ tyotseinꞌmaⁿ Jesús jndye nnꞌaⁿ na wii ñequio ntycu na tcuu wjaanaꞌ. Mati tyotseinꞌmaaⁿ nnꞌaⁿ na maleichuu jndyetia, ndoꞌ sꞌaaⁿ na ntyꞌiaa nnꞌaⁿ na nchjaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jnda̱ chii tsoom nda̱a̱ nnꞌaⁿ na jñom Juan: —Catsaꞌyoꞌ, calaꞌcandiiꞌyoꞌ Juan ljoꞌ na jnda̱ jndyeꞌyoꞌ, ndoꞌ na jnda̱ ntyꞌiaꞌnda̱a̱ꞌyoꞌ jndye nnꞌaⁿ nꞌmaaⁿ. Nnꞌaⁿ na nchjaaⁿ jnda̱ teitquioo. Ndoꞌ nnꞌaⁿ na ntjeiⁿ ncꞌeeꞌ, jeꞌ ya cwiꞌoocaꞌ. Nnꞌaⁿ na cho tycu lepra, jeꞌ jnda̱ nꞌmaaⁿ. Nnꞌaⁿ na candaa, jeꞌ ya cwindye. Nnꞌaⁿ na jnda̱ tja̱, jnda̱ cwitandoꞌnndaꞌ. Ndoꞌ ndyeñeeⁿꞌ jnda̱ macwindye ñꞌoom naya ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ndoꞌ mañequiaanaꞌ na neiiⁿꞌ meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na ticwjiꞌñe cantyja ꞌnaⁿya. ");
INSERT INTO amuNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Jnda̱ na tyꞌelcweeꞌ nnꞌaⁿ na jñom Juan, to̱ꞌ Jesús na matseineiiⁿ nda̱a̱ nnꞌaⁿ na mꞌaⁿ nacañomꞌm cantyja ꞌnaaⁿꞌ Juan. Matsoom: —¿Chiuu waa saacantyꞌiaꞌyoꞌ na saꞌyoꞌ ndyuaa na tja nnꞌaⁿ cꞌoom yuu na tyomꞌaaⁿ Juan? ¿Aa ntyꞌiaꞌyoꞌ jom chaꞌcwijom cwii tsmaaⁿ na maleiñꞌoomñe jndye? Ntyjii nchii joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Quia joꞌ ¿chiuu waa na saacantyꞌiaꞌyoꞌ? ¿Aa ntyꞌiaꞌyoꞌ jom na cweⁿ liaa na jeeⁿ jnda? Ntyjii nchii joꞌ. Queⁿꞌyoꞌ cwenta, nnꞌaⁿ na cwicweeꞌ liaa na jnda, joona jeeⁿ lꞌue mꞌaⁿna ndoꞌ ya cwicꞌeeⁿna quiiꞌ lanꞌiaaⁿ ntꞌmaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Quia joꞌ ¿chiuu waa na saacantyꞌiaꞌyoꞌ na saꞌyoꞌ? ¿Aa ntyꞌiaꞌyoꞌ na cwiluiiñê profeta? Mayuuꞌ na joꞌ jom. Ndoꞌ tꞌmaⁿti matseixmaaⁿ, nchiiti meiⁿnquia profeta. ");
INSERT INTO amuNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ee waa ljeii na matseineiⁿnaꞌ cantyja ꞌnaaⁿꞌaⁿ. Matsonaꞌ: Ja majño̱o̱ⁿñetya̱ya cwii moso ꞌnaⁿya na wjaajndyee cantyja na nncjaꞌ na wjaañꞌoom ñꞌoomya. Jom nncwjiꞌyuuꞌñê cantyja ꞌnaⁿꞌ cha nncꞌomcꞌeendye nnꞌaⁿ quia na nncueꞌcañoomꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Candyeꞌyoꞌ nntsjo̱o̱, quiiꞌntaaⁿ nnꞌaⁿ na mꞌaⁿ tsjoomnancue, tijoom ñetꞌoom cwii profeta na tꞌmaⁿti cwiluiiñe chaꞌna Juan. Sa̱a̱ meiiⁿ na ljoꞌ, tsꞌaⁿ na cjeti machꞌee, juu tꞌmaⁿti cwiluiiñe yuu na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom, nchiiti Juan. ");
INSERT INTO amuNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Chaꞌtso nnꞌaⁿ na jndye ñꞌoom na seineiⁿ Juan mandiñꞌeeⁿ nnꞌaⁿ na cwitoꞌñoom sꞌom tsꞌiaaⁿnda̱a̱ nnꞌaⁿ cwentaaꞌ gobiernom, ñequio chaꞌtso ntꞌomcheⁿ nnꞌaⁿ, teitsꞌoomndyena sꞌaa Juan ee jlaꞌno̱ⁿꞌna na xcwe machꞌee Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Sa̱a̱ nnꞌaⁿ fariseos ñequio nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés, lꞌana na ticwilꞌue ñꞌoom na seijndaaꞌñe Tyꞌo̱o̱tsꞌom na nluiꞌnꞌmaaⁿndyena, joꞌ chii tînquiandyena na nntseitsꞌoomñe Juan joona. ");
INSERT INTO amuNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Quia joꞌ tso Jesús nda̱a̱na: —¿Ljoꞌ nntseijoomꞌndyo̱ cantyja ꞌnaⁿꞌyoꞌ ñequio chaꞌtso ntꞌomcheⁿ ncꞌiaaꞌyoꞌ na mꞌaⁿ jeꞌ? Ndoꞌ ¿ꞌñeeⁿ matseijomnaꞌ ꞌo? ");
INSERT INTO amuNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Matseijomnaꞌ ꞌo chaꞌna yocanchꞌu na tileicatjoomꞌ na cwinquiooꞌ na meindyuaandye tsꞌom nataa. Cwilaꞌxuaana nda̱a̱ ncꞌiaana, cwiluena: “Cwitjo̱o̱ꞌâ tsmaaⁿ na macoco tsꞌaⁿ sa̱a̱ ꞌo tiñeꞌcalaꞌjnomꞌyoꞌ. Cwitaayâ som tsꞌoo sa̱a̱ mati tiñecatyueeꞌyoꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ee tyjeeꞌcañoom Juan, tsꞌaⁿ na ñeseitsꞌoomñe nnꞌaⁿ, jom tîcwaaⁿꞌaⁿ nantquie na ya, meiⁿ winom tîcꞌom. Sa̱a̱ ꞌo cwinduꞌyoꞌ: “Tsaⁿjndii matseixmaaⁿ.” ");
INSERT INTO amuNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ndoꞌ ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee, jnda̱ tyja̱caño̱o̱ⁿya ꞌo. Ja matseijomndyo̱ ñꞌeⁿ nnꞌaⁿ, macwaꞌa ndoꞌ maꞌua. Sa̱a̱ ꞌo cwinduꞌyoꞌ na ja cwiluiindyo̱ tsꞌaⁿ na jeeⁿ cwaꞌ, jeeⁿ ꞌuu. Ndoꞌ mati cwinduꞌyoꞌ na ja matseixꞌiaaꞌndyo̱ ñꞌeⁿ nnꞌaⁿ na cwitoꞌñoom sꞌom cwentaaꞌ gobiernom ñequio nnꞌaⁿ na cwilaꞌtjo̱o̱ndye nnom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Sa̱a̱ tintsꞌaa ee chaꞌtso ljoꞌ na machꞌee Tyꞌo̱o̱tsꞌom cwitꞌmo̱o̱ⁿnaꞌ na jndo̱ꞌ tsꞌoom. ");
INSERT INTO amuNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Cwii tsꞌaⁿ fariseo tqueeⁿꞌñê Jesús waⁿꞌaⁿ na nlcwaꞌna. Ndoꞌ tjaquieeꞌ Jesús quiiꞌ waaꞌ fariseoꞌñeeⁿ ndoꞌ tjacjom nacañomꞌ meiⁿsa. ");
INSERT INTO amuNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Cwii yuscu tsjoomꞌñeeⁿ na cweꞌ luaaꞌ mꞌaaⁿ ñꞌeⁿ naⁿnom, quia na jñeeⁿ na wacatyeeⁿ Jesús nacañoomꞌ meiⁿsa waaꞌ fariseo, jndyoñꞌoom cwii tsioo na tuiinaꞌ ñꞌeⁿ tsjo̱ꞌ canchiiꞌ na njom ncheⁿꞌ cachi. ");
INSERT INTO amuNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jndyomeintyjeeⁿꞌeⁿ nacañoomꞌ ncꞌee Jesús. To̱o̱ⁿꞌo̱ⁿ na matyꞌioom ndoꞌ cwiquiaa ndaannoom nacjooꞌ ncꞌee Jesús. Ñequio sooxqueeⁿ tyoweeꞌñê ncꞌee Jesús. Tyoꞌom ncꞌee ndoꞌ tyoñꞌoomñê ncheⁿꞌ cachiꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ndoꞌ juu tsꞌaⁿ fariseo na tqueeⁿꞌñê Jesús na catseijomñe ñꞌeⁿñê, ntyꞌiaaⁿꞌaⁿ na luaaꞌ. Quia joꞌ seitioom naquiiꞌ tsꞌoom: “Tsaⁿmꞌaaⁿ, xeⁿ mayuuꞌ cwiluiiñê profeta, jnda̱ seiꞌno̱o̱ⁿꞌo̱ⁿ ꞌñeeⁿ yuscumꞌaaⁿꞌ na manquiuꞌ jom, ndoꞌ ljoꞌ mayaaⁿꞌ. Ee tsaⁿmꞌaaⁿꞌ, tsꞌaⁿ na cweꞌ luaaꞌ mꞌaaⁿ ñꞌeⁿ naⁿnom.” ");
INSERT INTO amuNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Quia joꞌ tso Jesús nnom fariseoꞌñeeⁿ: —Aa ndiꞌ, Simón, waa cwii na ñeꞌcatsjo̱o̱ njomꞌ. Tꞌo̱ Simón, tsoom: —Ta, catsuꞌ nndii. ");
INSERT INTO amuNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Tso Jesús: —Tyomꞌaaⁿ cwii tsꞌaⁿ na teijndeii sꞌom nnꞌaⁿ. Ndoꞌ tꞌom we nnꞌaⁿ na tyocachoꞌjnaⁿ nnoom. Cwii tsaⁿꞌñeeⁿ tyocachujnaaⁿ ꞌom siaⁿnto denarios. Ndoꞌ cwiicheⁿ tsaⁿꞌñeeⁿ tyocachujnaaⁿ ñewenꞌaaⁿ nchooꞌ qui denarios. ");
INSERT INTO amuNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ndoꞌ naⁿꞌñeeⁿ tîcanda̱a̱ nntioomna, sa̱a̱ meiiⁿ na ljoꞌ, wendyena seitꞌmaⁿ tsꞌoom. Quia joꞌ ¿cwaaⁿ cwii na wendye naⁿꞌñeeⁿ nncꞌoom na jndati ntyjii ñꞌeⁿñê? ");
INSERT INTO amuNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Tꞌo̱ Simón, matsoom: —Matseitiuuya tsꞌaⁿ na tꞌmaaⁿꞌti chujnaⁿ nnoom, juu tsaⁿꞌñeeⁿ jndati ntyjii jom. Quia joꞌ matso Jesús nnoom: —Majoꞌndyo macwjiꞌ cwenta. ");
INSERT INTO amuNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jnda̱ joꞌ taqueeⁿ, ntyꞌiaaⁿꞌaⁿ yuscuꞌñeeⁿ, matsoom nnom Simón: —¿Aa mantyꞌiaꞌ yuscumꞌaaⁿꞌ? Ja jndyo̱quia̱ꞌa waꞌ, tînquiaaꞌ ndaa na nntmaⁿ ncꞌa̱ sa̱a̱ tsaⁿmꞌaaⁿꞌ jeꞌ, jnda̱ tmaaⁿ ncꞌa̱ ñequio ndaannoom. Ndoꞌ jnda̱ tyueeꞌñê ncꞌa̱ ñequio sooxqueeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ꞌU tîcꞌuaꞌ ntsmaaⁿꞌa chaꞌna waa costumbre, sa̱a̱ tsaⁿmꞌaaⁿꞌ cantyjati na jndyo̱quia̱ꞌa waꞌ, tyoocjaameintyjeeⁿꞌeⁿ na maꞌom ncꞌa̱. ");
INSERT INTO amuNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ꞌU tîcwjaaꞌndyuꞌ seitye xqua̱a̱ⁿ sa̱a̱ tsaⁿmꞌaaⁿꞌ jnda̱ tyꞌoomñê ncheⁿꞌ cachi ncꞌa̱. ");
INSERT INTO amuNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Joꞌ chii matsjo̱o̱ njomꞌ chaꞌtso na matseitjo̱o̱ñê jnda̱ seitꞌmaⁿ tsꞌo̱o̱ⁿ, joꞌ na jeeⁿ jnda ntyjeeⁿ ja. Sa̱a̱ juu tsꞌaⁿ na mꞌaaⁿꞌ tsꞌom nquii na titꞌmaⁿ matseitjo̱o̱ñe, meiiⁿ na matseitꞌmaⁿ tsꞌo̱o̱ⁿ juu, maxjeⁿ ticueeꞌ na jnda ntyjii ñꞌeⁿndyo̱. ");
INSERT INTO amuNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Jnda̱ chii matsoom nnom yuscuꞌñeeⁿ: —Jnda̱ seitꞌmaⁿ tsꞌo̱o̱ⁿya chaꞌtso jnaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Nnꞌaⁿ na meindyuaandye ñꞌeⁿñê nacañoomꞌ meiⁿsa, to̱ꞌna na cwiluena nda̱a̱ ncꞌiaana: —¿ꞌÑeeⁿ cwiluiiñe tsaⁿmꞌaaⁿꞌ na mati matseitꞌmaⁿ tsꞌoom jnaaⁿ nnꞌaⁿ? ");
INSERT INTO amuNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Sa̱a̱ matsoom nnom yuscuꞌñeeⁿ: —Ncꞌe na matseiꞌyuꞌya tsꞌomꞌ ñꞌeⁿndyo̱, joꞌ na jnda̱ jluiꞌyaꞌ. Cjaꞌ na meiⁿcwii ñomtiuu tancꞌoomꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Jnda̱ joꞌ tja Jesús chaꞌtso njoom ntꞌmaⁿ ñequio njoom nchꞌu na tyoñequiaaⁿ ñꞌoom. Tyotseicañeeⁿ nnꞌaⁿ ñꞌoom naya cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. Ndoꞌ ñꞌeeⁿ nnꞌaⁿ na canchooꞌwe ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Mati tyꞌe ñꞌeeⁿ yolcu na jnda̱ seinꞌmaaⁿ na ñejleichuu jndyetia. Ndoꞌ ñꞌeeⁿ ntꞌomcheⁿ yolcu na jnda̱ seinꞌmaaⁿ cwii cwii nnom ntycu na ñetjoom. Cwii joona jndyu María Magdalena, tsaⁿ na jnda̱ tjeiꞌ Jesús ntquieeꞌ naⁿjndii naquiiꞌ tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Ndoꞌ ñꞌeⁿ Juana, jom scuuꞌ Chuza, tsꞌaⁿ na mandoꞌ tsꞌiaaⁿ ꞌnaaⁿꞌ Herodes. Ndoꞌ mati ñꞌeⁿ Susana, ñequio jndyendye ntꞌomcheⁿ yolcu. Tyocaljondyena sꞌom na tyoteiꞌjndeiina Jesús ꞌnaⁿ na macaⁿnaꞌ jom ñꞌeⁿ nnꞌaⁿ canchooꞌwe. ");
INSERT INTO amuNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Tjomndye cwii tmaaⁿꞌ tꞌmaⁿ nnꞌaⁿ nacañoomꞌ Jesús, na jnaⁿna cwii cwii njoom. Tyotseineiiⁿ ñꞌoom na tjañoomꞌ nda̱a̱na. ");
INSERT INTO amuNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Matsoom: —Tyomꞌaaⁿ cwii tsꞌaⁿ na tyochꞌee tsꞌiaaⁿ jnda̱a̱. Tjaaⁿ, tjacjoomꞌm lqueeⁿ trigo. Ndoꞌ yocheⁿ na tyojoomꞌm lqueeⁿꞌñeeⁿ, ntꞌom joꞌ tquiaa tsꞌom nato. Joonaꞌ ndyue nnꞌaⁿ ndoꞌ ntꞌom tcwaꞌ cantsaa. ");
INSERT INTO amuNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ndoꞌ ntꞌom lqueeⁿꞌñeeⁿ tquiaanaꞌ yuu na jeeⁿ ljo̱ꞌ. Quia jnda̱ tꞌoomnaꞌ, mantyja tjacaaⁿnaꞌ ee titeiiⁿꞌ tyuaa. ");
INSERT INTO amuNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ndoꞌ ntꞌom lqueeⁿꞌñeeⁿ tquiaanaꞌ yuu na tooꞌ ndaꞌ lꞌo̱o̱ nioom. Ñeꞌnaaⁿꞌ tyꞌewijnda̱naꞌ, sa̱a̱ lꞌo̱o̱ nioomꞌñeeⁿ tco̱ꞌnaꞌ joonaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ndoꞌ ntꞌom tsjaaⁿ lqueeⁿꞌñeeⁿ tquiaanaꞌ yuu na ya tsꞌo. Tꞌoomnaꞌ ndoꞌ lꞌanaꞌ cwii cwii siaⁿnto lqueeⁿ na cwiinaꞌ. Jnda̱ na tsoom ñꞌoommeiⁿꞌ, seineiiⁿ na cꞌuaati, matsoom: —ꞌÑeeⁿ juu na niom lueꞌ nꞌom luaꞌqui na nndii, candiiya. ");
INSERT INTO amuNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ndoꞌ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê taꞌxꞌeena nnoom chiuu maꞌmo̱ⁿ ñꞌoom tjañoomꞌwaaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Tꞌo̱ Jesús matsoom: —Nda̱a̱ꞌ ꞌo mañequiaa Tyꞌo̱o̱tsꞌom na caliuꞌyoꞌ ñꞌoom wantyꞌiuuꞌ cantyja ꞌnaaⁿꞌ na matsa̱ꞌntjoom. Sa̱a̱ nda̱a̱ ntꞌomcheⁿ nnꞌaⁿ matseina̱ⁿya ñꞌoom na wjaañoomꞌ, cha meiiⁿ na cwintyꞌiaa nda̱a̱na sa̱a̱ tixoqueⁿna cwenta ndoꞌ meiiⁿ na cwindyena sa̱a̱ xocalaꞌno̱ⁿꞌna. ");
INSERT INTO amuNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","’Luaa maꞌmo̱ⁿ ñꞌoom tjañoomꞌwaaꞌ. Lqueeⁿ trigo na tjacjuꞌ tsꞌaⁿ, ñꞌoomꞌ Tyꞌo̱o̱tsꞌom joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Lqueeⁿ na tquiaa tsꞌom nato, joꞌ joꞌ nnꞌaⁿ na cwindye ñꞌoomꞌ Tyꞌo̱o̱tsꞌom. Mantyja ndyo tsaⁿjndii, macwjeeⁿꞌeⁿ ñꞌoomꞌñeeⁿ naquiiꞌ nꞌomna cha tilaꞌyuꞌna, tiluiꞌyana. ");
INSERT INTO amuNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Lqueeⁿ na tquiaa yuu na jeeⁿ ljo̱ꞌ, joꞌ joꞌ nnꞌaⁿ na cwindye ñꞌoomꞌ Tyꞌo̱o̱tsꞌom. Cwilaꞌyuꞌna cwantindyo xuee sa̱a̱ quia na mandyo cwii na macoꞌwiꞌnaꞌ joona, cwiꞌndyena. ");
INSERT INTO amuNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ndoꞌ lqueeⁿ na tquiaa yuu na tooꞌ ndaꞌ lꞌo̱o̱ nioom, mati nnꞌaⁿ na cwindye ñꞌoomꞌ Tyꞌo̱o̱tsꞌom. Sa̱a̱ joona, jeeⁿ mꞌaⁿna ñꞌomtiuu chiuu na cwii ꞌoomꞌaⁿtina. Ñeꞌcuaa ꞌnaaⁿna, ndoꞌ ñeꞌcꞌomna cantyja na neiⁿnco tsjoomnancue. Joꞌ chii tjaaꞌnaⁿ cwii nnom na cwiwitquiooꞌ cantyja ꞌnaaⁿna na cwilaꞌñꞌoomꞌndyena ñꞌoomꞌ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ndoꞌ tsjaaⁿ na tquiaa yuu na ya tsꞌo, mantꞌomcheⁿ nnꞌaⁿ na cwindye ñꞌoomꞌ Tyꞌo̱o̱tsꞌom. Ñequio na xcweeꞌ nꞌomna cwilaꞌwena ñꞌoom na cwindyena naquiiꞌ nꞌomna. Ticaꞌndyencꞌuaaꞌndyena meiiⁿ nawiꞌ cwitjoomna. Cantyja na cwilꞌana cwiwitquiooꞌ na cwinaⁿndyena yuu na matsonaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Seineiⁿ Jesús cwiicheⁿ ñꞌoom na tjañoomꞌ. Tsoom nda̱a̱na: —Tjaaꞌnaⁿ ꞌñeeⁿ juu na nntseicwꞌaa lámpara jnda̱ chii nntseicoomꞌm juunaꞌ ñꞌeⁿ xuaa oo nncwjaaꞌñê juunaꞌ nacjeeꞌ jnduu. Maxjeⁿ nntseintyja tsꞌaⁿ juunaꞌ cha na xuee nntyꞌiaa nnꞌaⁿ na nncꞌooquieꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Chaꞌtso na matsꞌaa jeꞌ na ticaliu chaꞌtsondye nnꞌaⁿ, mancjoꞌyoꞌ nlacano̱o̱ⁿꞌyoꞌ joonaꞌ nda̱a̱na. Ndoꞌ cwii cwii ñꞌoom wjaañoomꞌ na matseina̱ⁿya jeꞌ maxjeⁿ nncueꞌntyjo̱ na meiⁿquiayuucheⁿ nlaꞌno̱ⁿꞌ nnꞌaⁿ juunaꞌ. Maxjeⁿ nncuaa tyenquionaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","’Joꞌ chii queⁿꞌyaꞌyoꞌ cwenta joo ñꞌoommeiiⁿ na matseina̱ⁿya nda̱a̱ꞌyoꞌ. Ee juu tsꞌaⁿ na mamaleiñꞌoom nloꞌñomti sa̱a̱ tsꞌaⁿ na tjaa ljoꞌ coleiñꞌoom, nluiꞌñꞌeⁿ mandiñꞌeⁿ ljoꞌ na matseitioom na niom naquiiꞌ lꞌo̱o̱ⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Tsondyee Jesús ñequio ntyjeeⁿ tquieꞌcañomna, sa̱a̱ tîcanda̱a̱ nncꞌoontyjaaꞌna jom ee jeeⁿ jndye nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ndoꞌ seicandii tsꞌaⁿ jom, tso: —Chꞌeⁿ mꞌaaⁿ tsoꞌndyoꞌ ñequio ntyꞌiuꞌ. Ñeꞌcalaꞌneiⁿna ñꞌeⁿndyuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Tꞌo̱o̱ⁿ tsoom: —Joo nnꞌaⁿ na cwindye ñꞌoom ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom ndoꞌ cwilaꞌcanda̱ juunaꞌ, naⁿꞌñeeⁿ cwiluiindye tsondyo̱ya ndoꞌ ntyjo̱ya. ");
INSERT INTO amuNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Cwii xueeꞌñeeⁿ tuo̱ Jesús tsꞌom cwii wꞌaandaa ñequio nnꞌaⁿ na cwilaꞌjomndye ñꞌoomꞌm. Tsoom nda̱a̱na: —Cjaaya xndyaaꞌ ndaaluee. Quia joꞌ jnaⁿna tsꞌo̱ndaa Galilea, to̱ꞌna na ꞌoowityꞌiooꞌna juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Yocheⁿ na cwiwiꞌtyꞌiooꞌna, tsoo Jesús. Ndoꞌ jndeii tioo jndye nnom ndaalueeꞌñeeⁿ. Tiomnaꞌ ndaa tsꞌom wꞌaandaa. Waa na teincuuꞌ na nncꞌuꞌnaꞌ juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Ndoꞌ tyꞌentyjaaꞌna jom, jlaꞌnlcwina jom, jluena: —ꞌU Maestro, manncwja̱a̱ya. Jnda̱ na lcweeⁿ, seitiaaⁿꞌaⁿ jndye ñequio nmo̱ⁿ ndoꞌ jlaꞌcheⁿnaꞌ. Sꞌaanaꞌ na wacheeⁿ nnom ndaaluee. ");
INSERT INTO amuNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Quia joꞌ tsoom nda̱a̱na: —¿Yuu waa na maꞌmo̱ⁿnaꞌ na cwilayuꞌya nꞌomꞌyoꞌ? Sa̱a̱ joona jlaꞌcatyuendyena ndoꞌ tjaaweeꞌ nꞌomna. Tyoluena nda̱a̱ ncꞌiaana: —¿ꞌÑeeⁿ cwiluiiñe tsaⁿmꞌaaⁿ na matsa̱ꞌntjoom meiiⁿ jndye, meiiⁿ ndaaluee ndoꞌ cwilaꞌcanda̱naꞌ ñꞌoom na matsoom? ");
INSERT INTO amuNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jnda̱ joꞌ jluiꞌna xndyaaꞌ ndaaluee, ndyuaa tsjoom nnꞌaⁿ Gadara na waa ndyeyu tsꞌo̱ndaa Galilea. ");
INSERT INTO amuNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jnda̱ na jluiꞌ Jesús tyuaatcwii, jndyocatjomñe cwii tsꞌaⁿ tsjoomꞌñeeⁿ jom. Tsaⁿꞌñeeⁿ jnda̱ sꞌaa xuee na matseixmaaⁿ naⁿjndii naquiiꞌ tsꞌoom. Tacocweⁿ liaa ndoꞌ tacocꞌeeⁿ na waa wꞌaa. Macꞌeⁿyom yuu na cwijaacantyꞌiuuꞌndye lꞌoo. ");
INSERT INTO amuNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Quia na ntyꞌiaaⁿꞌaⁿ Jesús, jndeii seixuaⁿ sꞌaa jndyetia. Tcoomꞌm xtyeeⁿ jo ncꞌee Jesús. Jndeii seineiiⁿ, tsoom: —¿Ljoꞌ nntsaꞌ ñꞌeⁿndyo̱, ꞌu Jesús, Jnda Tyꞌo̱o̱tsꞌom na mꞌaaⁿ nandyeticheⁿ? Matsꞌaaya tyꞌoo njomꞌ, na tilcoꞌwiꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Tsoom ñꞌoomwaaꞌ ee jnda̱ sa̱ꞌntjom Jesús na caluiꞌ jndyetia naquiiꞌ tsꞌom tsaⁿꞌñeeⁿ. Teijndye xuee maleiñꞌoom jndyetia juu. Tyolatyeⁿ nnꞌaⁿ lꞌuaancjo lꞌo̱o̱ⁿ ndoꞌ ncꞌeeⁿ. Sa̱a̱ tyocꞌiooꞌñê joonaꞌ ndoꞌ tyowjaañꞌoom jndyetiaꞌñeeⁿ jom yuu na tjaa nnꞌaⁿ cꞌoom. ");
INSERT INTO amuNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Quia joꞌ taxꞌee Jesús nnom, matsoom: —¿Ljoꞌ jndyuꞌ? Tꞌo̱ ꞌñom, tso: —Ja jndyuya Jndye Meiⁿ. Luaaꞌ tsoom ee jeeⁿ jndye naⁿjndii jnda̱ tuo̱ naquiiꞌ tsꞌoom. ");
INSERT INTO amuNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ndoꞌ tyolaꞌtyꞌoondye naⁿjndiiꞌñeeⁿ nnom Jesús na ticajñoom joona yuu na wiꞌ nntjoomna. ");
INSERT INTO amuNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Joꞌ joꞌ tyomꞌaⁿ cwii tmaaⁿꞌ calcu quiiꞌ jnda̱a̱ na cwicwaꞌ. Naⁿjndiiꞌñeeⁿ tyolꞌana tyꞌoo nnoom na quiaaⁿ na nncꞌooquieꞌna naquiiꞌ nꞌom calcuꞌñeeⁿ. Quia joꞌ tquiaaⁿ na wanaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ndoꞌ jnda̱ na jluiꞌ jndyetia ñꞌeⁿ naⁿjndii naquiiꞌ tsꞌom tsaⁿꞌñeeⁿ, tyꞌequieꞌna naquiiꞌ nꞌom calcu. Ndoꞌ tmaaⁿꞌ calcuꞌñeeⁿ jleiꞌnomyoꞌ, teiꞌtyuꞌyoꞌ yuu na ntyꞌa ꞌndyoo ndaalueeꞌñeeⁿ, mana nchjeeñenaꞌ jooyoꞌ quiiꞌ ndaa. ");
INSERT INTO amuNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nnꞌaⁿ na cwiteiꞌxꞌee calcuꞌñeeⁿ, jnda̱ na ntyꞌiaana na luaaꞌ tuii, jleiꞌnomna, tyolaꞌneiⁿna ñꞌoomwaaꞌ naquiiꞌ tsjoom ndoꞌ jo jnda̱a̱. ");
INSERT INTO amuNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Quia joꞌ tyꞌe nnꞌaⁿ, tyꞌecantyꞌiaa ljoꞌ tuii. Tquieꞌcañomna Jesús ndoꞌ jliuna tsꞌaⁿ na jnda̱ jluiꞌ naⁿjndii naquiiꞌ tsꞌom, wacatyeeⁿ nacañoomꞌ Jesús. Macweⁿ liaa ndoꞌ jnda̱ tcoꞌyañꞌeⁿnaꞌ jom. Ndoꞌ naⁿꞌñeeⁿ, jeeⁿ tyuena. ");
INSERT INTO amuNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Joo nnꞌaⁿ na jndooꞌ chiuu tuii na nꞌmaⁿ tsꞌaⁿ na ñeseixmaⁿ naⁿjndii, jlaꞌneiⁿna nda̱a̱ nnꞌaⁿ na tyꞌecantyꞌiaa. ");
INSERT INTO amuNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ndoꞌ chaꞌtso nnꞌaⁿ na mꞌaⁿ chaꞌwaa ndyuaa Gadara, lꞌana tyꞌoo nnom Jesús na calueeⁿꞌeⁿ quiiꞌntaaⁿna, ee joona jeeⁿ nquiaana. Joꞌ chii tuo̱nndaꞌ Jesús tsꞌom wꞌaandaa mana tjalcweeⁿꞌeⁿ tsꞌo̱ndaa Galilea. ");
INSERT INTO amuNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Juu tsꞌaⁿ na jnda̱ jluiꞌ naⁿjndii naquiiꞌ tsꞌom, tyochꞌee tyꞌoo nnom Jesús na quiaa tsaⁿꞌñeeⁿ ñꞌoomꞌ na nñꞌeⁿ ñꞌeⁿñê, sa̱a̱ sa̱ꞌntjom Jesús na caljooꞌñê. ");
INSERT INTO amuNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","Tsoom nnom: —Cjaꞌlcweꞌ na waa waꞌ, catseineiⁿꞌ nda̱a̱ nnꞌaⁿ cwanti tꞌmaⁿ naya jnda̱ sꞌaa Tyꞌo̱o̱tsꞌom ñꞌeⁿndyuꞌ. Ndoꞌ tja tsaⁿꞌñeeⁿ, tyotseineiiⁿ nda̱a̱ nnꞌaⁿ chaꞌwaa quiiꞌ tsjoom na tꞌmaⁿ naya sꞌaa Jesús ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Teityꞌionndaꞌ Jesús ndaaluee. Quia na jlueeⁿꞌeⁿ wꞌaandaa, jndyendye nnꞌaⁿ toꞌñoomna jom ñequio na neiiⁿna, ee chaꞌtsondyena mameiꞌndooꞌna jom. ");
INSERT INTO amuNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tyjeeꞌcañoom cwii tsꞌaⁿ na jndyu Jairo. Jom cwiluiitquieñê naquiiꞌ watsꞌom ꞌnaaⁿ nnꞌaⁿ judíos. Tcoomꞌm xtyeeⁿ jo ncꞌee Jesús, sꞌaaⁿ tyꞌoo na cjaa tsaⁿꞌñeeⁿ waⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ee mꞌaaⁿ jnaaⁿ na yuscu, na macanda̱ juu. Chaꞌna canchooꞌwe chuuꞌ yuꞌñeeⁿ ndoꞌ mañeꞌcueꞌ. Yocheⁿ na njom Jesús nato na mawjaⁿ waaꞌ tsaⁿꞌñeeⁿ, sꞌaanaꞌ na jeeⁿ tyeeⁿ nacañomꞌm na jeeⁿ jndye nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ndoꞌ quiiꞌntaaⁿna mꞌaaⁿ cwii yuscu na jnda̱ canchooꞌwe chu wiiꞌ tycu na cwicaa nioomꞌ. Jnda̱ seicatsoom chaꞌtso ꞌnaaⁿꞌaⁿ ñequio nnꞌaⁿ na cwilꞌa nasei. Sa̱a̱ meiⁿcwiindye joona tîcanda̱a̱ nntseinꞌmaⁿ jom. ");
INSERT INTO amuNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Tjatseicandyooꞌñê jo naxeⁿꞌ Jesús ndoꞌ tyenquioomꞌm ꞌndyoo liaatco na cwee Jesús. Mañoomꞌ tjameintyjeeꞌ na cwicaa nioomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Quia joꞌ taxꞌe Jesús, tsoom: —¿ꞌÑeeⁿ juu tyenquiuuꞌ ja? Chaꞌtsondye nnꞌaⁿ jlue ticaliu. Ndoꞌ tso Pedro ñequio ncꞌiaaⁿꞌaⁿ: —Ta, jndyendye nnꞌaⁿ jnda̱ seicantoꞌnaꞌ nacañomꞌ hasta manchjenaꞌ ꞌu cwilꞌana, ndoꞌ mawaxeꞌ: “¿ꞌÑeeⁿ juu tyenquiuuꞌ ja?” ");
INSERT INTO amuNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Tꞌo̱ Jesús, tsoom: —Mꞌaaⁿ ꞌñeeⁿ juu na wiiꞌ tyenquiuuꞌ ja. Ee ntyjiiya na jnda̱ teilꞌue juu najndeii na matseixmaⁿya na nꞌmaⁿ tsꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Jnda̱ na ljeii yuscuꞌñeeⁿ na xocanda̱a̱ nncwantyꞌiuuꞌñê, ñequio na cwiteiñê jndyocoomꞌm xtyeeⁿ jo nnom Jesús. Ndoꞌ ñequio na ndye chaꞌtsondye nnꞌaⁿ tjeiꞌyuuꞌñê chiuu na tyenquioomꞌm liaaꞌ Jesús ndoꞌ na mañoomꞌ nꞌmaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Quia joꞌ tso Jesús nnoom: —ꞌU jndaaya, ncꞌe na matseiꞌyuꞌyaꞌ tsꞌomꞌ ñꞌeⁿndyo̱ joꞌ na jnda̱ nꞌmaⁿꞌ. Cjaꞌ na meiⁿncwii ñomtiuu tancꞌoomꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Ndicwaⁿ matseineiiⁿ ndoꞌ tyjeeꞌ tsꞌaⁿ na jnaⁿ waaꞌ Jairo, tsꞌaⁿ na cwiluiitquieñe watsꞌom. Matso tsaⁿꞌñeeⁿ: —Tantseicachjuuꞌtiꞌ Tamꞌaaⁿꞌ ee jnda̱ tueꞌ nomjndaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jnda̱ na jndii Jesús ñꞌoomwaaꞌ, tsoom nnom Jairo: —Tintyꞌueꞌ, macanda̱ na catseiyuꞌ ñꞌeⁿndyo̱, quia joꞌ nnꞌmaⁿ nomjndaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ndoꞌ jnda̱ na tueⁿꞌeⁿ na waa wꞌaa, meiⁿcwii tsꞌaⁿ tînquiaaⁿ na nncjaaquieeꞌ ñꞌeⁿñê, macanda̱ Pedro ñequio Juan ñequio Jacobo, ndoꞌ tsotye yuscuchjoo ñꞌeⁿ tsondyee. ");
INSERT INTO amuNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Chaꞌtso nnꞌaⁿ jndeii cwilaꞌxuaana, cwityueena cantyja ꞌnaaⁿꞌ tsꞌoochjoo. Sa̱a̱ matso Jesús nda̱a̱na: —Tantyueeꞌyoꞌ ee tyooweeⁿꞌeⁿ, cweꞌ watsom. ");
INSERT INTO amuNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Sa̱a̱ joona, cweꞌ tyoncona Jesús ee manquiuyana na jnda̱ tueꞌ tsaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Quia joꞌ tꞌueeⁿ tsꞌo̱, seineiiⁿ jndeii, tsoom: —Yuscuchjoo, quicantyjaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Mantyja tandoꞌnndaꞌ ndoꞌ mañoomꞌ teicantyja. Sa̱ꞌntjom Jesús na quiana na nlcwaꞌ yuscuchjooꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nnꞌaⁿ na nda tsaⁿꞌñeeⁿ tꞌomna na jeeⁿ tꞌmaⁿ tjaweeꞌ nꞌomna, sa̱a̱ Jesús sa̱ꞌntjoom na ticaluena nnom meiⁿcwii tsꞌaⁿ chiuu tuii. ");
INSERT INTO amuNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Quia jnda̱ seitjom Jesús canchooꞌwe nnꞌaⁿ na cwilajomndye ñꞌeⁿñê, tquiaaⁿ na calaꞌxmaⁿna najneiⁿ cha nnda̱a̱ nntjeiiꞌna naⁿjndii, ndoꞌ na nnda̱a̱ nlaꞌnꞌmaⁿna nnꞌaⁿ wii. ");
INSERT INTO amuNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Jñoom joona na cꞌoonquiana ñꞌoom cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom ndoꞌ na nlaꞌnꞌmaⁿna nnꞌaⁿwii. ");
INSERT INTO amuNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Tsoom nda̱a̱na: —Meiⁿcwii tjaa ljoꞌ catsaañꞌomꞌyoꞌ na nleilꞌueeꞌndyoꞌ nato, meiⁿ tsꞌoomlꞌeii, meiⁿ ꞌnaⁿ na cwicañjom sꞌom, meiⁿ nantquie, meiⁿ tsjo̱ꞌñjeeⁿ, manda̱ liaa na cweeꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Meiⁿnquia wꞌaa yuu na nntsquieꞌyoꞌ, joꞌ caljooꞌndyoꞌ. Ndoꞌ majoꞌ nluiꞌyoꞌ na nntsaꞌtsaꞌtiꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Meiⁿnquia tsjoom na tiñeꞌcatoꞌñoom nnꞌaⁿ ꞌo, quia na cwicaluiꞌyoꞌ tsjoomꞌñeeⁿ, calaquiaꞌyoꞌ tsꞌojnda̱a̱ na chuuꞌ ncꞌeeꞌyoꞌ. Luaaꞌ nlꞌaꞌyoꞌ cha caluiꞌyuuꞌ nacjoo naⁿꞌñeeⁿ na tîcatoꞌñoomna ñꞌoomꞌ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Quia joꞌ jluiꞌna, tyꞌena chaꞌtso njoom nchꞌu, tyoñeꞌquiana ñꞌoom chiuu na nluiꞌnꞌmaaⁿndye nnꞌaⁿ ndoꞌ tyolaꞌnꞌmaⁿna nnꞌaⁿ wii. ");
INSERT INTO amuNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Jndii Herodes, tsꞌaⁿ na mꞌaaⁿ gobiernom, chaꞌtso na tyochꞌee Jesús. Tꞌmaⁿ seiñꞌeeⁿꞌnaꞌ jom na tyolue ntꞌom nnꞌaⁿ na Juan jnda̱ wandoꞌnndaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ntꞌom tyolue na Elías jnda̱ teitquiooꞌñenndaꞌ. Ndoꞌ ntꞌom tyolue na jnda̱ wandoꞌnndaꞌ cwii profeta na teiyo tyoñequia ñꞌoomꞌ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Sa̱a̱ tso Herodes: —Nnco̱ sa̱ꞌntjo̱ⁿ na catyjena xtyoꞌ Juan. Quia joꞌ ¿ꞌñeeⁿ luaaꞌ na teijndye ñꞌoom mandii cantyja ꞌnaaⁿꞌ? Ndoꞌ tyojooꞌ tsꞌoom na nntyꞌiaaⁿꞌaⁿ juu. ");
INSERT INTO amuNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jnda̱ na lcweeꞌnndaꞌ nnꞌaⁿ na canchooꞌwe tsꞌiaaⁿ na jñom Jesús joona, jlaꞌcandiina jom chaꞌtso na jnda̱ lꞌana. Quia joꞌ tjachom joona, tyꞌena cwii ntyja jo jnda̱a̱ nndyooꞌ tsjoom Betsaida. ");
INSERT INTO amuNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Quia na jliu nnꞌaⁿ na ljoꞌ, tyꞌentyjo̱na naxeeⁿꞌeⁿ. Toꞌñoom joona ndoꞌ tyotseineiiⁿ nda̱a̱na cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. Ndoꞌ seinꞌmaaⁿ nnꞌaⁿ wii. ");
INSERT INTO amuNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Jnda̱ na jaamaaⁿ, tyꞌentyjaaꞌ nnꞌaⁿ na canchooꞌwendye jom. Jluena: —Cajñomꞌ nnꞌaⁿ na cꞌoona njoom nchꞌu oo jo ranchoo nnꞌaⁿ nmeiⁿꞌ ndiocheⁿ na nlꞌueena yuu nlquiena ndoꞌ cha nliuna na nlcwaꞌna, ee ñjaaⁿ tjaa chiuuya, tjaa ljoꞌ quiom. ");
INSERT INTO amuNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Sa̱a̱ matsoom nda̱a̱na: —ꞌO quiaꞌyoꞌ na nlcwaꞌna. Tꞌo̱o̱ naⁿꞌñeeⁿ nnoom, jluena: —Macanda̱ ñeꞌom taⁿꞌ tyooꞌ ñequio we catscaa cwileiñꞌo̱o̱ⁿyâ. ¿Ljoꞌti nntso luaaꞌ? Macanda̱to xeⁿ tsaalajndaayâ nantquie na nlcwaꞌ chaꞌtsondye naⁿmꞌaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ndoꞌ naⁿꞌñeeⁿ na cweꞌ tomti naⁿnom, chaꞌna ꞌom meiⁿndyena. Quia joꞌ tsoom nda̱a̱ nnꞌaⁿ canchooꞌwe: —Canduꞌyoꞌ nda̱a̱ naⁿmꞌaⁿꞌ na cwindyuaandyena xjeⁿ ntmaaⁿꞌ na wenꞌaaⁿ wenꞌaaⁿ nchooꞌ qui na cwii cwii tmaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ndoꞌ lꞌana na ljoꞌ, teindyuaandye chaꞌtsondye nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jnda̱ joꞌ toꞌñoom ꞌom taⁿꞌ tyooꞌ ñequio we catscaaꞌñeeⁿ. Jlunda̱a̱ñê cañoomꞌluee, tquiaaⁿ na quianlꞌuaaꞌ Tyꞌo̱o̱tsꞌom. Jnda̱ chii tyjeeⁿ joonaꞌ, tquiaaⁿ nda̱a̱ nnꞌaⁿ na tꞌmaaⁿ na cwilaꞌjomndye ñꞌeⁿñê tsꞌiaaⁿ na machꞌeeⁿ na catꞌoom naⁿꞌñeeⁿ joonaꞌ nda̱a̱ nnꞌaⁿ na jndyendye. ");
INSERT INTO amuNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Chaꞌtsondye naⁿꞌñeeⁿ tcwaꞌ tjacjoona. Ndoꞌ ꞌndiicheⁿnaꞌ na tîcandyue lcwaꞌna. Quia na jnda̱ jlaꞌtjomna joꞌ, tooꞌ canchooꞌwe tsquiee. ");
INSERT INTO amuNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Cwii xueeꞌñeeⁿ mꞌaaⁿndyo̱ Jesús cwii ntyja na matseineiiⁿ nnom Tyꞌo̱o̱tsꞌom. Mañꞌeeⁿ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê. Taxꞌeeⁿ nda̱a̱na, matsoom: —¿ꞌÑeeⁿ juu cwilue nnꞌaⁿ na cwiluiindyo̱? ");
INSERT INTO amuNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Joona tꞌo̱o̱na nnoom: —Ntꞌom nnꞌaⁿ cwilue ꞌu Juan, tsꞌaⁿ na tyotseitsꞌoomñe nnꞌaⁿ. Ndoꞌ ntꞌomcheⁿ cwilue ꞌu Elías. Ndoꞌ ntꞌomcheⁿ cwilue na ꞌu cwii profeta na tyoñequia ñꞌoomꞌ Tyꞌo̱o̱tsꞌom tandyo xuee na jnda̱ wandoꞌnndaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ndoꞌ tsoom nda̱a̱na: —Ndoꞌ ꞌo jeꞌ, ¿ꞌñeeⁿ juu cwinduꞌyoꞌ na cwiluiindyo̱? Tꞌo̱ Pedro, tsoom: —ꞌU cwiluiindyuꞌ nquii Cristo na jnaⁿꞌ na mꞌaaⁿ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Quia joꞌ sa̱ꞌntjoomtyeeⁿ na meiⁿcwii tsꞌaⁿ ticaluena nnom na ljoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Matsoom: —Ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee maxjeⁿ tseixmaⁿya na jndye nawiꞌ catjo̱ⁿ. Nnꞌaⁿ na cwiluiitquiendye, ñequio ntyee na cwiluiitquiendye, ñequio nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés nncꞌomna na ticueeꞌ nꞌomna ja. Nlaꞌcueeꞌna ja, sa̱a̱ xuee jnda̱ ndyee nncwaꞌndo̱ꞌxco̱. ");
INSERT INTO amuNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Jnda̱nquia tsoom nda̱a̱ chaꞌtsondyena: —Meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na lꞌue tsꞌom na nncwꞌaaꞌñe ja, cwjiꞌñê cantyja na matseitiuu nqueⁿ. Caljoya tsꞌoom nawiꞌ na matjoom ticwii xuee, ndoꞌ candyontyjo̱o̱ⁿ cantyja na matsꞌaa, meiiⁿ quio joꞌ cueeⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ee meiⁿnquia tsꞌaⁿ na mañequiaañe na catjom ljoꞌ na nntjom ncꞌe na mꞌaaⁿ cantyja ꞌnaⁿya, tsaⁿꞌñeeⁿ nluiꞌnꞌmaaⁿñê. Sa̱a̱ meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na malꞌueeꞌñe cheⁿnquii chiuu nluiꞌnꞌmaaⁿñê, majoꞌto joꞌ nntsuuñe. ");
INSERT INTO amuNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Quia joꞌ yuu waa jeꞌ na mateijndeiinaꞌ tsꞌaⁿ meiiⁿ chaꞌwaa tsjoomnancue cuaanaꞌ na ꞌnaaⁿꞌaⁿ xeⁿ nntsuu añmaaⁿꞌaⁿ ndoꞌ matseityuiiꞌñe cheⁿnqueⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ndoꞌ meiⁿquia tsꞌaⁿ na mꞌaaⁿ na jnaaⁿꞌ cantyja ꞌnaⁿya ñequio ñꞌoom naya ꞌnaⁿya, ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee ncꞌo̱o̱ⁿya na jnaaⁿꞌa tsaⁿꞌñeeⁿ quia nndyo̱o̱nndaꞌa na matseitꞌmaaⁿꞌñenaꞌ ja, ñequio na matseitꞌmaaⁿꞌñenaꞌ Tsotya̱ ndoꞌ ñequio ángeles na ljuꞌndye. ");
INSERT INTO amuNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Sa̱a̱ mayuuꞌcheⁿ, nndyeꞌyoꞌ nntsjo̱o̱, ntꞌom nnꞌaⁿ na mꞌaⁿ ñjaaⁿ xocwjena hasta xeⁿ jnda̱ ntyꞌiaanda̱a̱na cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jnda̱a̱ chaꞌna ñeeⁿ xueendyo na seineiiⁿ ñꞌoommeiⁿꞌ, tjawaaⁿ cwii ta na nntseineiiⁿ nnom Tyꞌo̱o̱tsꞌom. Tjañꞌoom Pedro ñequio Juan ñꞌeⁿ Jacobo. ");
INSERT INTO amuNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ndoꞌ yocheⁿ na matseineiiⁿ nnom Tyꞌo̱o̱tsꞌom, seichuiiꞌnaꞌ nnoom. Ndoꞌ sꞌaanaꞌ na jeeⁿcheⁿ ndyaꞌ canchiiꞌ liaⁿꞌaⁿ, jndaꞌjom macoꞌnaꞌ luiꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ndoꞌ teitquiooꞌndye we naⁿnom na cwilaꞌneiⁿ ñꞌeⁿñê, Moisés ñꞌeⁿ Elías joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Seixueeñenaꞌ ndiocheⁿ nacañoomna, ndoꞌ jlaꞌneiⁿna ñꞌeⁿñê cantyja na nlaꞌcueeꞌ nnꞌaⁿ jom quia na nncjaⁿ Jerusalén. ");
INSERT INTO amuNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ndoꞌ Pedro, jeeⁿ seijaaꞌñe tsaⁿtsjom nacjoomꞌm ñequio nnꞌaⁿ na ñꞌeeⁿ ñꞌeⁿñê sa̱a̱ jnda̱a̱ lꞌana na tîcandana. Joꞌ chii ntyꞌiaana nacaxuee na matseixmaⁿ Jesús ndoꞌ ntyꞌiaa nda̱a̱na we naⁿnomꞌñeeⁿ na teitquiooꞌndye ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Juu xjeⁿ na cwito̱ⁿꞌndye naⁿꞌñeeⁿ ñꞌeⁿ Jesús, tso Pedro nnoom: —Ta, jeeⁿ ya na mꞌaaⁿyâ ñjaaⁿ. Cwa nlꞌaayâ ndyee xquieꞌncwaⁿꞌ, cwii cwentaꞌ ꞌu, cwii cwentaaꞌ Moisés ndoꞌ cwii cwentaaꞌ Elías. Sa̱a̱ ticatseiꞌno̱ⁿꞌ Pedro ljoꞌ na tsoom. ");
INSERT INTO amuNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Yocheⁿ na matseineiiⁿ na ljoꞌ, jndyocue cwii nchquiu na seicata̱ꞌnaꞌ joona. Ndoꞌ jeeⁿ nioom tyuena na tjaaꞌñenaꞌ joona naquiiꞌ nchquiuꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ndoꞌ teicꞌuaa jndyeeꞌ Tyꞌo̱o̱tsꞌom naquiiꞌ nchquiuꞌñeeⁿ, matso: —Luaañe Jndaaya na jeeⁿ candyaꞌ tsꞌo̱o̱ⁿya. Candyeꞌyoꞌ ñꞌoom ꞌñom. ");
INSERT INTO amuNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Jnda̱ na teicheⁿ na seineiⁿ Tyꞌo̱o̱tsꞌom, jliuna ñenquii Jesús cwii mꞌaaⁿ. Ndoꞌ xuee na cwityomꞌaⁿtina, meiⁿcwii tsꞌaⁿ tîcaluena nnom chiuu waa na ntyꞌiaana. ");
INSERT INTO amuNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Cwiicheⁿ xuee quia na jnda̱ tquiocuena sjo̱ꞌñeeⁿ, tjacatjomñe cwii tmaaⁿꞌ tꞌmaⁿ nnꞌaⁿ joona. ");
INSERT INTO amuNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Naquiiꞌ tmaaⁿꞌñeeⁿ seixuaa cwii tsꞌaⁿ, tso: —Ta, matsꞌaaya tyꞌoo njomꞌ na cantyꞌiaꞌ ljoꞌ matjom tiꞌjndaaya, ee ñenqueⁿ tuiiñê. ");
INSERT INTO amuNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Luaa matjoom, matꞌuii jndyetia jom, ndoꞌ machꞌee na jndeii matseixuaⁿ. Cwiteiñê ndoꞌ cwicaluiꞌ chomꞌ ꞌñom. Ncꞌuaaꞌ maꞌndii jom xeⁿ jnda̱ seityꞌuiiñe jom. ");
INSERT INTO amuNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ndoꞌ jnda̱ seityꞌoondyo̱ nda̱a̱ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿndyuꞌ na catjeiiꞌna jndyetia sa̱a̱ tîcanda̱a̱ lꞌana. ");
INSERT INTO amuNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Tꞌo̱ Jesús, matsoom: —ꞌO nnꞌaⁿ na tiñeꞌcalaꞌyuꞌyoꞌ ndoꞌ quieꞌ nꞌomꞌyoꞌ, hasta cwanti yo na macaⁿnaꞌ na cꞌo̱o̱ⁿya ñꞌeⁿndyoꞌ ndoꞌ na matseiquii tsꞌo̱o̱ⁿya quiondyoꞌ. Jnda̱ joꞌ tsoom nnom tsotye tyochjooꞌñeeⁿ: —Candyoꞌñꞌoomꞌ tiꞌjndaꞌ ñjaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ndoꞌ yocheⁿ na mandyotseicandyooꞌñe tyochjoo, seiquioo tsaⁿjndii jom ndoꞌ sꞌaa na jndeii tyoteiñê. Sa̱a̱ seitiaꞌ Jesús tsaⁿjndii. Seinꞌmaaⁿ tyochjoo jnda̱ chii tquiaaⁿ juu nnom tsotye. ");
INSERT INTO amuNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Chaꞌtso nnꞌaⁿ na ntyꞌiaa na luaaꞌ, jeeⁿ tjaweeꞌ nꞌomna cantyja na tꞌmaⁿ najndeii na matseixmaⁿ Tyꞌo̱o̱tsꞌom. Ndoꞌ ncueeꞌñeeⁿ jndyendye nnꞌaⁿ jeeⁿ tyojaaweeꞌ nꞌomna chaꞌtso na tyochꞌee Jesús. Ndoꞌ seineiiⁿ nda̱a̱ nnꞌaⁿ na cwilaꞌjomndye ñꞌoom na mañequiaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","Tsoom: —Quiandyoꞌ na cjo̱ ñꞌoommeiiⁿ nꞌom luaꞌquiꞌyoꞌ. Ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee maxjeⁿ nñequiaa tsꞌaⁿ cwenta ja luee nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Sa̱a̱ joona tîcalaꞌno̱ⁿꞌna ñꞌoommeiⁿꞌ ee seicuꞌna na nliuna joonaꞌ. Ndoꞌ nquiaana na nntaꞌxꞌeena ꞌñom chiuu maꞌmo̱ⁿnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Joo nnꞌaⁿ canchooꞌwe tyolaꞌñꞌeeⁿꞌ ndyueena ꞌñeeⁿ cwii joona nncꞌoom na tꞌmaⁿti nntseixmaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jnda̱ na seiꞌno̱ⁿꞌ Jesús chiuu waa na mꞌaaⁿꞌ nꞌomna, quia joꞌ toꞌñoom cwii yucachjoo, tqueeⁿ juu nacañomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Tsoom nda̱a̱na: —Meiⁿnquia tsꞌaⁿ na macoꞌñom yucachjoomꞌaaⁿ ncꞌe xueya, ja macoꞌñom tsaⁿꞌñeeⁿ, ndoꞌ meiⁿnquia tsꞌaⁿ na macoꞌñom ja, mati macoꞌñom tsaⁿꞌñeeⁿ nquii na jñom ja. Ncꞌe na luaaꞌ, tsꞌaⁿ na cjeti cwiluiiñe quiiꞌntaaⁿꞌyoꞌ, tsaⁿꞌñeeⁿ cwiluiitꞌmaⁿñetyeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Quia joꞌ tꞌo̱ Juan, tsoom: —Ta, ntyꞌiaayâ cwii tsꞌaⁿ na macwjiꞌ naⁿjndii naquiiꞌ nꞌom nnꞌaⁿ ñequio xueꞌ. Ndoꞌ lꞌuuyâ nnoom ticwanaaⁿ ee nchii ñꞌeⁿ jaa matseijomñê. ");
INSERT INTO amuNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Sa̱a̱ Jesús tsoom nnom: —Tinduꞌyoꞌ na ticwanaaⁿ ee juu tsꞌaⁿ na ticꞌoom nacjooya, maxjeⁿ matseijomñê ñꞌeⁿndyo̱ jaa. ");
INSERT INTO amuNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Quia na jnda̱ jaaweꞌntyjo̱ xjeⁿ na nncoꞌñom Tyꞌo̱o̱tsꞌom jom cañoomꞌluee, quia joꞌ ñeꞌcwii seijndaaꞌñê na wjaⁿ Jerusalén. ");
INSERT INTO amuNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ndoꞌ jñomjñeeⁿ nnꞌaⁿ na cꞌoo cwii tsjoom chjoo, tsjoom nnꞌaⁿ samaritanos. Tyꞌe naⁿꞌñeeⁿ na nlaꞌjndaaꞌndyena cantyja na nncueeꞌcañoom ñequio nnꞌaⁿ na ñꞌeeⁿ ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Sa̱a̱ nnꞌaⁿ tsjoomꞌñeeⁿ ticalꞌue nꞌomna na nljooꞌñê tsjoomna ee jlaꞌno̱ⁿꞌna na Jerusalén wjaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Quia joꞌ we nnꞌaⁿ na cwilaꞌjomndye ñꞌoomꞌm, Jacobo ñꞌeⁿ Juan, quia na ntyꞌiaana na luaaꞌ, jluena: —Aa ndiꞌ Ta, ¿aa nncwancueꞌ na nlꞌaayâ chaꞌna sꞌaa Elías? Nntaaⁿyâ na quioo chom na nnaⁿ cañoomꞌluee nacjoo naⁿmꞌaⁿꞌ cha nntseicwjeenaꞌ joona. ");
INSERT INTO amuNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Sa̱a̱ jom taqueeⁿ, seitiaaⁿꞌaⁿ joona, tsoom: —ꞌO ticalaꞌno̱ⁿꞌyoꞌ ljoꞌ cwii nnom cwilaxmaⁿꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ee ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee tîcandyo̱o̱ na nncwjiiꞌa na cwitaꞌndoꞌ nnꞌaⁿ. Ja jndyo̱o̱ na nncwjiꞌnꞌmaaⁿndyo̱ joona. Mana tyꞌetyꞌetina cwiicheⁿ tsjoom chjoo. ");
INSERT INTO amuNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yocheⁿ na ñjomndyena nato, tso cwii tsꞌaⁿ nnoom: —Ta, ja nntseijomndyo̱ ñꞌeⁿndyuꞌ meiⁿyuucheⁿ na wjaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Tꞌo̱ Jesús nnom, tsoom: —Candye majndaaꞌ lueꞌlꞌaayoꞌ, ndoꞌ cantsaa majndaaꞌ cantquiaayoꞌ, sa̱a̱ ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee, meiⁿ yuu na nncwajndya̱, tijndaaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ndoꞌ tsoom nnom cwiicheⁿ tsꞌaⁿ: —Candyotseijomndyuꞌ ñꞌeⁿndyo̱. Sa̱a̱ tso tsaⁿꞌñeeⁿ nnoom: —Jeeⁿ sa ꞌu Ta, quiaaꞌ na wanaaⁿ na catyꞌiujndya̱a̱ tsotya̱, quia joꞌ yuuꞌ jeꞌ, nñꞌa̱ⁿya ñꞌeⁿndyuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ndoꞌ tso Jesús nnom tsaⁿꞌñeeⁿ: —Caꞌndiiꞌ nmeiⁿꞌ. Mꞌaⁿ ntꞌom nnꞌaⁿ na ticataꞌndoꞌ cantyja ꞌnaⁿya, laꞌxmaⁿna chaꞌcwijom lꞌoo. Joona catyꞌiuundye ntyjeena. Sa̱a̱ ꞌu cjaꞌquiaaꞌ ñꞌoom cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom nda̱a̱ chaꞌtso nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Tso cwiicheⁿ tsꞌaⁿ nnoom: —Ta, nntseijomndyo̱ ñꞌeⁿndyuꞌ, sa̱a̱ quiaaꞌ ñꞌomꞌ na jo̱cwaⁿjndya̱a̱ nnꞌaⁿ wꞌaya na majo̱. ");
INSERT INTO amuNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Tꞌo̱ Jesús nnom, matsoom: —Meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na mato̱ꞌ na matseijomñe ñꞌeⁿndyo̱, a̱a̱ tixcweeꞌ tsꞌom, ñenquiiꞌcheⁿ ñjom tsꞌom cantyja na jnda̱ ꞌndii, matseijomnaꞌ tsaⁿꞌñeeⁿ chaꞌcwijom tsꞌaⁿ na matꞌuii tsꞌoomsnda sa̱a̱ mawaqueⁿxeⁿꞌ, tsaⁿꞌñeeⁿ ticatsonaꞌ na nncjaaquieeꞌñe cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Jnda̱ teinom nmeiⁿꞌ, tjeiiꞌñe Jesús ntꞌomcheⁿ nnꞌaⁿ, ndyeenꞌaaⁿ nchooꞌ qui nchooꞌ wendyena. Jñoom we we, we wendyena na cꞌoojndyeena ticwii tsjoom ndoꞌ ticwii joo yuu na quia nncjaa nqueⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Tsoom nda̱a̱na: —Jndye nnꞌaⁿ mꞌaⁿ na tyoondye ñꞌoom naya. Matseijomnaꞌ naⁿꞌñeeⁿ chaꞌcwijom lqueeⁿ na jnda̱ tmaⁿ. Sa̱a̱ naⁿntjom na nntyje lqueeⁿ, meiⁿchjoo tijndye. Cweꞌ joꞌ cataⁿꞌyoꞌ nnom Ta Tyꞌo̱o̱tsꞌom na cajñomtyeeⁿ ntꞌomcheⁿ naⁿntjom na nnteiꞌjndeii ꞌo na nntjeiꞌyuuꞌndyoꞌ ñꞌoom naya nda̱a̱ naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ndoꞌ tsotyeeⁿcheⁿ nda̱a̱na: —Catsaꞌyoꞌ. Queⁿꞌyoꞌ cwenta, majño̱o̱ⁿya ꞌo quiiꞌntaaⁿ nnꞌaⁿ na wiꞌndye. Matseijomnaꞌ ꞌo chaꞌcwijom canmaⁿ na mꞌaⁿ quiiꞌntaaⁿ lobo. ");
INSERT INTO amuNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Tintsaañꞌomꞌyoꞌ ꞌnaⁿ na cwicañjom sꞌom, meiⁿ chetsjaꞌ, meiⁿ lcoom. Ndoꞌ nchii na nlaꞌchjuundyoꞌ na nlaneiⁿꞌyoꞌ ñꞌeⁿ nnꞌaⁿ nato. ");
INSERT INTO amuNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Meiⁿnquia wꞌaa na nntsquieꞌyoꞌ, canduꞌjndyeeꞌyoꞌ nda̱a̱ nnꞌaⁿ wꞌaaꞌñeeⁿ: “Quiaa Tyꞌo̱o̱tsꞌom na ya mꞌaⁿꞌyoꞌ ñꞌeⁿ ntyjeeꞌyoꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ndoꞌ nnꞌaⁿ wꞌaaꞌñeeⁿ xeⁿ cwilaꞌxmaⁿ na catoꞌñoom nayaꞌñeeⁿ, quia joꞌ caljonaꞌ quiondyena, sa̱a̱ xeⁿ na ticalaꞌxmaⁿna na nntoꞌñoomna juunaꞌ, quia joꞌ calcweꞌnndaꞌnaꞌ ñꞌeⁿndyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ndoꞌ wꞌaa yuu na nntsquieꞌyoꞌ, joꞌ caljooꞌndyoꞌ. Nchii cweꞌ cwii ndoꞌ cwii wꞌaa nncꞌomꞌyoꞌ. Cwaꞌyoꞌ ndoꞌ cweꞌyoꞌ nantquie na nñeꞌquiana nda̱a̱ꞌyoꞌ. Ee tsaⁿntjom maxjeⁿ tseixmaaⁿ na coꞌñoom na mawantjoom. ");
INSERT INTO amuNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Meiⁿnquia tsjoom na nntsquieꞌyoꞌ ndoꞌ nntoꞌñoomna ꞌo, cwaꞌyoꞌ meiⁿnquia nantquie na nñeꞌquiana nda̱a̱ꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Calanꞌmaⁿꞌyoꞌ nnꞌaⁿwii na mꞌaⁿ joꞌ joꞌ ndoꞌ canduꞌyoꞌ nda̱a̱na: “ꞌO nnꞌaⁿ, juu na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom nnꞌaⁿ, matseindyooꞌñenaꞌ jo nda̱a̱ꞌyoꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Sa̱a̱ meiⁿnquia tsjoom na nntsquieꞌyoꞌ na tiñeꞌcalaꞌljo nnꞌaⁿ ꞌo, caluiꞌyoꞌ tsꞌom nataa ndoꞌ canduꞌyoꞌ: ");
INSERT INTO amuNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Cwilaquiaayâ tsꞌo jnda̱a̱ na niom tsjomꞌyoꞌ na chuuꞌ ncꞌa̱a̱ꞌâ. Nmeiiⁿ cwilꞌaayâ na cwitꞌmo̱o̱ⁿyâ na ꞌo tiñeꞌcatoꞌñoomꞌyoꞌ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom. Sa̱a̱ calaꞌno̱ⁿꞌyoꞌ juu na matsa̱ꞌntjoom nnꞌaⁿ matseicandyooꞌñenaꞌ na mꞌaⁿꞌyoꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Quia joꞌ tsotyeeⁿcheⁿ nda̱a̱na: —Nndyeꞌyoꞌ nntsjo̱o̱ quia na nncueꞌntyjo̱ xuee na nncuꞌxeⁿ Tyꞌo̱o̱tsꞌom nnꞌaⁿ, nlcoꞌwiꞌtinaꞌ nnꞌaⁿ tsjoomꞌñeeⁿ, nchiiti nnꞌaⁿ tsjoom Sodoma. ");
INSERT INTO amuNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","’Wiꞌ nntjomꞌyoꞌ ꞌo nnꞌaⁿ tsjoom Corazín. Mati ꞌo nnꞌaⁿ tsjoom Betsaida, ee xeⁿ jo nda̱a̱ nnꞌaⁿ tsjoom Sidón ñꞌeⁿ Tiro tꞌmo̱o̱ⁿya juu najndeii na matseixmaⁿya chaꞌxjeⁿ tꞌmo̱o̱ⁿya nda̱a̱ꞌ ꞌo, tyuaaꞌ jlaꞌcanda̱a̱ꞌndye naⁿꞌñeeⁿ na teindyuaandyena na tcweeꞌna liaa na ta̱a̱ ndoꞌ tioona tsjaaꞌ nqueⁿna na cwitꞌmo̱o̱ⁿna na cwilcweꞌ nꞌomna. ");
INSERT INTO amuNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Cweꞌ joꞌ, xuee na nntuꞌxeⁿndye nnꞌaⁿ, tꞌmaⁿti nlcoꞌwiꞌnaꞌ ꞌo nchiiti nnꞌaⁿ tsjoom Tiro ñꞌeⁿ Sidón. ");
INSERT INTO amuNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ꞌO nnꞌaⁿ tsjoom Capernaum, ¿aa ndyaꞌ cwilatiuuꞌyoꞌ na cañoomꞌlueecheⁿ nntseiwendyenaꞌ ꞌo, cweꞌ ee na jndye tsꞌiaaⁿ sꞌaaya quiiꞌntaaⁿꞌyoꞌ? Maxjeⁿ nntiom Tyꞌo̱o̱tsꞌom ꞌo yuu na njoomticheⁿ na macoꞌwiꞌnaꞌ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","’Tsꞌaⁿ na mandii ñꞌoom na cwiñeꞌquiaꞌyoꞌ, mañꞌoomya joꞌ mañeeⁿ. Sa̱a̱ ꞌñeeⁿ na ntsꞌo̱o̱ ꞌo, maja machꞌee tsaⁿꞌñeeⁿ na ntsꞌo̱o̱ⁿ. Ndoꞌ ꞌñeeⁿ na ntsꞌo̱o̱ ja, nquii na jñom ja machꞌee tsaⁿꞌñeeⁿ na ntsꞌo̱o̱ⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Quia na jnda̱ tquienndaꞌ ndyeenꞌaaⁿ nchooꞌ qui nchooꞌ we naⁿꞌñeeⁿ na jñom Jesús, ñequio na neiiⁿna jluena: —Ta, hasta naⁿjndii tueeꞌndyecje nda̱a̱yâ ñequio xueꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Tso Jesús nda̱a̱na: —Ntyjiiya na jnda̱ tyuiiꞌ najndeii na ñeseixmaⁿ Satanás. Ñejomto tiooñê chaꞌcwijom tioo chom tsuee. ");
INSERT INTO amuNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Ja jnda̱ tquiaya najnda̱ꞌyoꞌ, cha meiiⁿ candyueꞌyoꞌ canduu ñꞌeⁿ caljo̱, meiⁿchjoo tjaa ljoꞌ nntjomꞌyoꞌ. Ndoꞌ nnaⁿndyoꞌ ñequio chaꞌtso najndeii na matseixmaⁿ Satanás na mꞌaaⁿ nacjoꞌyoꞌ. Meiⁿcwii nmeiⁿꞌ xocalꞌa nata̱ꞌ ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Sa̱a̱ tincꞌomꞌyoꞌ na neiⁿꞌyoꞌ cweꞌ cantyja na cwitueeꞌndyecje naⁿjndii nda̱a̱ꞌyoꞌ. Cꞌomꞌyoꞌ na neiⁿꞌyoꞌ ncꞌe na jnda̱ teiljeii ncueꞌyoꞌ cañoomꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Mañejuuti xjeⁿꞌñeeⁿ, tioo na neiiⁿꞌ Jesús ncꞌe Espíritu Santo. To̱o̱ⁿꞌo̱ⁿ na matseineiiⁿ nnom Tyꞌo̱o̱tsꞌom, tsoom: —Matseitꞌmaaⁿꞌndyo̱ ꞌu Tsotya̱ya na cwiluiindyuꞌ na matsa̱ꞌntjomꞌ cañoomꞌluee ñequio nnom tsjoomnancue. Ee jnda̱ tantyꞌiuuꞌndyuꞌ ñꞌoommeiⁿꞌ nda̱a̱ nnꞌaⁿ na cweꞌ jndo̱ꞌto nꞌom ñequio nnꞌaⁿ na jeeⁿ tꞌmaⁿ cwilaꞌno̱ⁿꞌ. Ndoꞌ jnda̱ seicano̱o̱ⁿꞌ joonaꞌ nda̱a̱ nnꞌaⁿ na cje cwilꞌa. Mayuuꞌ Ta, ee luaaꞌ waa na tjaweeꞌ tsꞌomꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jnda̱ joꞌ seineiⁿnndaꞌ Jesús nda̱a̱ nnꞌaⁿ na cwindye, tsoom: —Nquii Tsotya̱ya Tyꞌo̱o̱tsꞌom chaꞌtso nnom jnda̱ tioom lꞌo̱o̱ya. Tjaa ꞌñeeⁿ matseiꞌno̱ⁿꞌ chiuu tseixmaⁿya na cwiluiindyo̱ Jnaaⁿ, macanda̱ nqueⁿ ntyjeeⁿ. Meiⁿ tjaa ꞌñeeⁿ matseiꞌno̱ⁿꞌ chiuu tseixmaⁿ Tsotya̱ya, macanda̱ ja na cwiluiindyo̱ Jnaaⁿ mantyjiiya. Ndoꞌ mati meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na lꞌue tsꞌo̱o̱ⁿ na nntseiꞌno̱ⁿꞌ chiuu tseixmaⁿ Tsotya̱ya, mañequia na nntseiꞌno̱ⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Quia joꞌ taqueeⁿ, ntyꞌiaaⁿꞌaⁿ nda̱a̱ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê, tsoom nda̱a̱na na ñenquieena: —Jeeⁿ neiiⁿ nnꞌaⁿ na cwintyꞌiaanda̱a̱ tsꞌiaaⁿ na cwintyꞌiaꞌyoꞌ na matsꞌaaya. ");
INSERT INTO amuNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Candyeꞌyoꞌ nntsjo̱o̱, jndye profetas ñequio reyes na tyotsa̱ꞌntjom, jeeⁿ tyocantyjaaꞌ nꞌomna na nntyꞌiaanda̱a̱na tsꞌiaaⁿmeiⁿꞌ na cwintyꞌiaꞌ ꞌo na matsꞌaa ndoꞌ na nndyena ñꞌoom na cwindyeꞌ ꞌo na mañenquia, sa̱a̱ tîcantyꞌiaana meiⁿ tîcandyena. ");
INSERT INTO amuNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Teintyjeeꞌ cwii tsꞌaⁿ na maꞌmo̱ⁿ ljeii na tqueⁿ Moisés. Taxꞌee nnom Jesús na cweꞌ ñeꞌcantyꞌiaaꞌ chiuu nntsꞌaaⁿ. Matso: —Ta, ¿cwaaⁿ na tseixmaⁿya na catsꞌaa cha na nndaya na ticantycwii na nncwaꞌndo̱ꞌa? ");
INSERT INTO amuNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Tꞌo̱ Jesús nnom, tsoom: —¿Chiuu tꞌmaⁿ ljeii na mawaa? ¿Chiuu matseiꞌno̱ⁿꞌ na matseiꞌnaⁿꞌ juunaꞌ? ");
INSERT INTO amuNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Tꞌo̱ tsaⁿꞌñeeⁿ, matso: —Ljeiiꞌñeeⁿ luaa matsa̱ꞌntjomnaꞌ: “Cꞌoomꞌ na candyaꞌ tsꞌomꞌ Ta Tyꞌo̱o̱tsꞌom cwentaꞌ ñequio na xcweeꞌya tsꞌomꞌ, ñequio chaꞌwaa na jnda ntyjiꞌ, ñequio chaꞌwaa na jnduꞌ ndoꞌ ñequio chaꞌwaa na jndo̱ꞌya tsꞌomꞌ.” Ndoꞌ mati matsonaꞌ: “Cꞌoomꞌ na wiꞌ tsꞌomꞌ xꞌiaꞌ chaꞌxjeⁿ na jnda ntyjiꞌ ñequio nncuꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Quia joꞌ tso Jesús nnom: —Majoꞌndyo ñꞌoom na tꞌo̱ꞌ. Catseicanda̱ꞌ nmeiⁿꞌ, quia joꞌ nndaꞌ na nncwandoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Sa̱a̱ tsaⁿꞌñeeⁿ na ñeꞌcwjiꞌyañe cheⁿnqueⁿ taxꞌeennaaⁿꞌaⁿ ꞌndyoo Jesús, tsoom: —¿ꞌÑeeⁿ juu cwiluiiñe xꞌiaya? ");
INSERT INTO amuNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Tꞌo̱ Jesús, tsoom: —Ndiꞌ, tꞌoom cwii tsaⁿsꞌa. Jnaaⁿ Jerusalén na wjaacueeⁿ tsjoom Jericó ndoꞌ tioondye naⁿcantyꞌue cjoomꞌm. Tjeiiꞌna ꞌnaaⁿꞌaⁿ, jlaꞌquieeꞌndyena jom, ꞌndyena jom na majaaweeⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ndoꞌ seijomnaꞌ na wjaacue cwii tyee cwentaa nnꞌaⁿ judíos juu natoꞌñeeⁿ. Ndoꞌ quia na ljeiiⁿ juu tsꞌaⁿ na tquieeꞌñe, tjanquiaañê, chii teinoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Majoꞌti sꞌaa cwii tsꞌaⁿ levita. Jnda̱ na mawjaawiñoomꞌm joꞌ joꞌ ndoꞌ ljeiiⁿ juu, majoꞌti tjanquiaañê chii teinoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Sa̱a̱ cwii tsꞌaⁿ ndyuaa Samaria na wjaa natoꞌñeeⁿ, quia na tjawiñoomꞌm tsaⁿꞌñeeⁿ ndoꞌ na ntyꞌiaaⁿꞌaⁿ juu tioo na jeeⁿ wiꞌ tsꞌoom. ");
INSERT INTO amuNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Tjantyjaaⁿꞌaⁿ juu. Tioom seitye ñꞌeⁿ winom yuu na tquieeꞌñe, jnda̱ chii seityeeⁿ liaa. Jnda̱ joꞌ teiꞌcaljoom juu quiooꞌ na ñeljoom. Tjañꞌoom juu wꞌaa na cweꞌ cwiquieya nnꞌaⁿ. Joꞌ joꞌ teixꞌeeⁿ juu. ");
INSERT INTO amuNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Cwiicheⁿ xuee quia na mawjaⁿ, tjeiiⁿꞌeⁿ we tsjo̱ꞌñjeeⁿ sꞌom denarios, tquiaaⁿ joonaꞌ nnom tsꞌaⁿ na waaꞌ wꞌaaꞌñeeⁿ. Tsoom nnom: “Cateixꞌeeꞌ jom ndoꞌ xeⁿ nlcaⁿtinaꞌ sꞌom, quia nndyo̱lcwa̱ꞌa, ntseicanda̱a̱ꞌndyo̱.” ");
INSERT INTO amuNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Quia joꞌ taxꞌee Jesús ꞌndyoo tsaⁿ na matseiꞌnaaⁿꞌ ljeii na tqueⁿ Moisés, tsoom: “¿Chiuu matseiꞌtiuuꞌ, ꞌñeeⁿ cwii na ndyeendye naⁿꞌñeeⁿ cwiluiiñe xꞌiaaꞌ tsꞌaⁿ na tioondye naⁿcantyꞌue nacjooꞌ?” ");
INSERT INTO amuNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Tꞌo̱ tsaⁿꞌñeeⁿ, matso: —Juu tsꞌaⁿ na tyꞌoom na wiꞌ tsꞌom ñꞌeⁿñê cwiluiiñe xꞌiaaⁿꞌaⁿ. Ndoꞌ tso Jesús nnom: —Cjaꞌ, ndoꞌ majoꞌti catsaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Tjatjati Jesús ñequio nnꞌaⁿ na cwiꞌoo ñꞌeⁿñê. Tquiena cwii tsjoom chjoo. Ndoꞌ cwii yuscu na jndyu Marta, seiljo joona waaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mꞌaaⁿ tyjee tsaⁿꞌñeeⁿ na jndyu María, juu tjacjoo cwii ntyjaaꞌ Jesús na mandii ñꞌoom na matseineiiⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Sa̱a̱ Marta, tileicaluiꞌñê na jeeⁿ matseinꞌoomꞌñê. Tjantyjaaⁿꞌaⁿ Jesús, tsoom nnom: —Ta, ¿aa mandoꞌ na ñenco̱ maꞌndii nomtyjo̱ na catseiꞌnꞌo̱o̱ⁿꞌndyo̱? Catsuꞌ nnoom na cateijneiⁿ ja. ");
INSERT INTO amuNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Tꞌo̱ Jesús, tsoom nnom: —ꞌU leii, Marta, tꞌmaⁿ matseiñꞌeeⁿꞌnaꞌ ꞌu na jndye ñꞌomtiuu mꞌaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Sa̱a̱ ñecwii waa na macaⁿnaꞌ, ndoꞌ nomtyꞌiuꞌ María jnda̱ tjeiiꞌñê cwii na yati cwentaaⁿꞌaⁿ, na mañeeⁿ ñꞌoom naya. Ndoꞌ tjaa ꞌñeeⁿ nncwjiꞌ na matseixmaaⁿ juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Tyomꞌaaⁿ Jesús cwii joo na matseineiiⁿ nnom Tsotyeeⁿ. Quia na jnda̱ jnda̱ seineiiⁿ, cwiindye joo nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê, tso nnoom: —Ta, caꞌmo̱ⁿꞌ nda̱a̱yâ chiuu nlana̱a̱ⁿyâ nnom Tyꞌo̱o̱tsꞌom, chaꞌxjeⁿ na tꞌmo̱ⁿ Juan nda̱a̱ nnꞌaⁿ na tyolaꞌjomndye ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Tsoom nda̱a̱na: —Quia na cwilaneiⁿꞌyoꞌ nnom Tyꞌo̱o̱tsꞌom, canduꞌyoꞌ: Tsotya̱a̱yâ na mꞌaaⁿꞌ cañoomꞌluee ñequiiꞌcheⁿ catseitꞌmaaⁿꞌñenaꞌ xueꞌ. Candyo cantyja na matsa̱ꞌntjomꞌ naquiiꞌ nꞌo̱o̱ⁿyâ. Caluii cantyja na ꞌu lꞌue tsꞌomꞌ nnom tsjoomnancue chaꞌxjeⁿ na cwiluii cañoomꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Quiaaꞌ na nlcwaaꞌâ ticwii xuee. ");
INSERT INTO amuNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Ndoꞌ catseitꞌmaⁿ tsꞌomꞌ jâ jnaaⁿyâ, ee mati cwilaꞌtꞌmaⁿ nꞌo̱o̱ⁿyâ chaꞌtso nnꞌaⁿ na cwilaꞌtjo̱o̱ndye nda̱a̱yâ. Cateijndeiꞌ na tincjaachuuñenaꞌ jâ na nlꞌaayâ yuu na ticatsa̱ꞌntjomnaꞌ. Ndoꞌ catseicandyaandyuꞌ jâ lꞌo̱ juu natia. ");
INSERT INTO amuNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Mati tsoom nda̱a̱na: —Calꞌuuya xeⁿ cwiindyoꞌ ꞌo ya ñꞌoom ñequio cwii tsꞌaⁿ, ndoꞌ xcwe tsjom nncjaꞌ na mꞌaaⁿ tsaⁿꞌñeeⁿ na nntsuꞌ nnoom: “Aa ndiꞌ, cateijndeiꞌyaꞌ ndyee taⁿꞌ tyooꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ee jeꞌndyo tyjeeꞌ cwii tsꞌaⁿ na ya ñꞌoom ja ñꞌeⁿñe wꞌaya na cweꞌ mawinomyaaⁿ, tquia quia wjaatyeeⁿcheⁿ. Ndoꞌ ja tjaaꞌnaⁿ ljoꞌ ya na nlcwaaⁿꞌaⁿ.” ");
INSERT INTO amuNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Quia joꞌ naquiiꞌ wꞌaacheⁿ nncꞌo̱o̱ⁿ, nntsoom: “Jeeⁿ sa ꞌu, tañeꞌquicantyja, ee jnda̱ seicuꞌtya̱ⁿ ꞌndyootsꞌa, ndoꞌ jnda̱ mawaya cjooꞌ jnduu. Mati ntseindaaya jnda̱ jndana. Joꞌ chii xonda̱a̱ na nnteijndei na maco̱ⁿꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Candyeꞌyoꞌ nntsjo̱o̱, meiiⁿ na tsꞌaⁿ na ya ñꞌoom ꞌu ñꞌeⁿñe, xoquintyjaaⁿ na nnteijneiⁿ ꞌu. Cweꞌ ee na jndeiiꞌ ꞌndyoꞌ, joꞌ na nnquicantyjatoom na nñequiaaⁿ chaꞌtso na macaⁿnaꞌ ꞌu. ");
INSERT INTO amuNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Joꞌ chii ja matsjo̱o̱ nda̱a̱ꞌyoꞌ: Cataⁿꞌyoꞌ nnom Tyꞌo̱o̱tsꞌom quia joꞌ nñequiaaⁿ. Cjooꞌya nꞌomꞌyoꞌ na calꞌueeꞌndyoꞌ chiuu ya jo nnoom, quia joꞌ nliuꞌyoꞌ. Macweꞌ na caꞌmaⁿꞌyoꞌ ndoꞌ nnaaⁿ chaꞌcwijom cwii ꞌndyootsꞌa jo nda̱a̱ꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ee meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na waa na macaⁿ nnom Tyꞌo̱o̱tsꞌom, maxjeⁿ nloꞌñom. Ndoꞌ tsꞌaⁿ na malꞌue, maxjeⁿ nljeii. Ndoꞌ tsꞌaⁿ na maꞌmaⁿ, maxjeⁿ nnaaⁿ jo nnom. ");
INSERT INTO amuNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Aa ndyaꞌ mꞌaaⁿ cwiindyoꞌ ꞌo xeⁿ nlcaⁿ jndaꞌ tyooꞌ njomꞌ, ¿aa cweꞌ tsjo̱ꞌ nñequiaaꞌyuꞌ nnoom? Oo xeⁿ nlcaaⁿ catscaa njomꞌ, ¿aa catsuu nñequiaaꞌ nnoom? ");
INSERT INTO amuNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Oo xeⁿ nlcaaⁿ tseiꞌcaxti njomꞌ, ¿aa nñequiaaꞌyuꞌ catsjo̱ nnoom? ");
INSERT INTO amuNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Joꞌ chii xeⁿ na ꞌo na tia nnꞌaⁿndyoꞌ nquiuꞌyoꞌ na nñequiaꞌyoꞌ ꞌnaⁿ na ya nda̱a̱ ndaꞌyoꞌ, majndeiiticheⁿ nquii Tsotyeꞌyoꞌ na mꞌaaⁿ cañoomꞌluee nñequiaaⁿ Espíritu Santo naquiiꞌ nꞌom nnꞌaⁿ na cwitaⁿ juu nnoom. ");
INSERT INTO amuNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Tjeiꞌ Jesús tsaⁿjndii naquiiꞌ tsꞌom tsꞌaⁿ na tileicatseineiⁿ. Jnda̱ na jluiꞌ tsaⁿjndii, quia joꞌ tcoꞌyanaꞌ tsaⁿꞌñeeⁿ, ya seineiiⁿ. Ndoꞌ jeeⁿ tjaweeꞌ nꞌom nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Sa̱a̱ cwantindye joona tyoluena: —Tsaⁿmꞌaaⁿꞌ macwjeeⁿꞌeⁿ naⁿjndii naquiiꞌ nꞌom nnꞌaⁿ cweꞌ ncꞌe na matseixmaaⁿ najndeii tsaⁿjndiitquiee Beelzebú. ");
INSERT INTO amuNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ndoꞌ ntꞌomcheⁿ cweꞌ na ñeꞌcalꞌa xjeⁿ jom, tyotaⁿ cwii ꞌnaaⁿ cha caꞌmo̱ⁿnaꞌ na cañoomꞌluee cwinaⁿ najneiⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Sa̱a̱ jom na mantyjeeⁿ ñꞌomtiuu ꞌnaaⁿna, tsoom nda̱a̱na: —Xeⁿ cwito̱ⁿꞌndye nnꞌaⁿ ndyuaa yuu na matsa̱ꞌntjom cwii gobiernom, maxjeⁿ nntyuiiꞌ cantyja na matsa̱ꞌntjoom. Ndoꞌ nnꞌaⁿ na mꞌaⁿ cwii wꞌaa, xeⁿ titjoomꞌ cwiꞌmaⁿ, maxjeⁿ cwilaꞌtyuiiꞌndye cheⁿnquieena. ");
INSERT INTO amuNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Mati Satanás xeⁿ mato̱ⁿꞌñe cheⁿnqueⁿ, quia joꞌ ¿chiuu nntsꞌaayuunaꞌ na nljotyeⁿ cantyja na matsa̱ꞌntjoom? Luaaꞌ matsjo̱o̱ya ee ꞌo cwinduꞌyoꞌ na ja macwjiiꞌa naⁿjndii naquiiꞌ nꞌom nnꞌaⁿ ncꞌe Beelzebú. ");
INSERT INTO amuNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ee xeⁿ mayuuꞌ na ja macwjiiꞌa naⁿjndii ñequio najndeii na matseixmaⁿ Beelzebú, quia joꞌ mati ncꞌiaaꞌyoꞌ, ñequio najndeii jom cwitjeiiꞌna naⁿjndii naquiiꞌ nꞌom nnꞌaⁿ. Sa̱a̱ ncꞌe na tiyuuꞌ na ljoꞌ, joꞌ chii cantyja na cwilꞌa joona macwjiꞌyuuꞌñenaꞌ na tixcwe cwitjeiꞌyoꞌ cwenta. ");
INSERT INTO amuNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ee xeⁿ ja ñequio najndeii na matseixmaⁿ Tyꞌo̱o̱tsꞌom macwjiiꞌa naⁿjndii naquiiꞌ nꞌom nnꞌaⁿ, maꞌmo̱ⁿnaꞌ na juu na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom nnꞌaⁿ, jnda̱ tyjeeꞌcañoomnaꞌ ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","’Manquiuꞌyoꞌ tsꞌaⁿ na maleichuu lꞌo̱ tsꞌiaaⁿ cwentaaꞌ tiaꞌ, waa najneiⁿ. Joꞌ na ya machꞌeeⁿ cwenta waⁿꞌaⁿ. Ndoꞌ tjaaꞌnaⁿ ljoꞌ nntjoom ꞌnaaⁿꞌaⁿ na niom. ");
INSERT INTO amuNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Sa̱a̱ quia nncwjeeꞌcañoom cwiicheⁿ tsꞌaⁿ na jndeiiti, nchiiti jom, quia joꞌ taxocanaⁿjneiⁿ ñꞌeⁿ tsaⁿꞌñeeⁿ. Chaꞌtso lꞌo̱ tsꞌiaaⁿ na quitꞌmaⁿ tsꞌoom, nncwjiꞌ tsaⁿꞌñeeⁿ ndoꞌ nleilꞌueeꞌñe ꞌnaaⁿꞌaⁿ na niom. ");
INSERT INTO amuNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","’ꞌÑeeⁿ juu na ticꞌoomñe cantyja ꞌnaⁿya, maxjeⁿ mꞌaaⁿ nacjoya. Ndoꞌ ꞌñeeⁿ juu na ticatseitjom nnꞌaⁿ ñꞌeⁿndyo̱, matseilcweeⁿꞌeⁿ nnꞌaⁿ cha ticalaꞌyuꞌna ñꞌeⁿndyo̱. ");
INSERT INTO amuNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","’Cwii tsaⁿjndii quia na jnda̱ tjeiꞌnaꞌ jom naquiiꞌ tsꞌom cwii tsꞌaⁿ, cweꞌ manomtoom yuu na tjaaꞌnaⁿ ndaa, malꞌueeⁿ yuu nncwajñeeⁿ. Ndoꞌ na tîcaljeiiⁿ joꞌ, seitioom: “Jo̱nlcwa̱ꞌnndaꞌa naquiiꞌ tsꞌom tsꞌaⁿ yuu na jluiiꞌa.” ");
INSERT INTO amuNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Quia na nncueⁿꞌeⁿ joꞌ joꞌ, nljeiiⁿ na jnda̱ taa ndoꞌ jnda̱ teijndaaꞌya. ");
INSERT INTO amuNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Joꞌ chii nncjaacachoom ntꞌomcheⁿ ntquieeꞌ naⁿjndii na wiꞌndyeti, nchiiti jom. Nncꞌooquieꞌna naquiiꞌ tsꞌom tsaⁿꞌñeeⁿ ndoꞌ joꞌ joꞌ nncꞌomna. Tsaⁿꞌñeeⁿ manioomti ntjoom na jnda̱ we. ");
INSERT INTO amuNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Xjeⁿ na matseineiⁿ Jesús ñꞌoommeiⁿꞌ, cwii yuscu quiiꞌntaaⁿ nnꞌaⁿ na jndyendye, seiwe jndyeeꞌ ndoꞌ tso nnoom: —Matioꞌnaaⁿñe Tyꞌo̱o̱tsꞌom tsꞌaⁿ na seincuii ꞌu ndoꞌ seicateiꞌ ꞌu. ");
INSERT INTO amuNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Sa̱a̱ jom tꞌo̱o̱ⁿ nnom, tsoom: —Matꞌmaⁿti matioꞌnaaⁿñê nnꞌaⁿ na cwindye ñꞌoomꞌm ndoꞌ cwilaꞌcanda̱ joonaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Jnda̱ tjawijndyeti nnꞌaⁿ na cañoomꞌ Jesús, to̱o̱ⁿꞌo̱ⁿ na matsoom nda̱a̱na: —Nnꞌaⁿ na mꞌaⁿ jeꞌ, jeeⁿ ndyaꞌ tia nnꞌaⁿndye. Cwitaⁿna na caluii cwii ꞌnaaⁿ na nntyꞌiaana na xocanda̱a̱ nntsꞌaa na cweꞌ tsꞌaⁿ, sa̱a̱ taxocaluii na cwitaⁿna, macanda̱ nluii ꞌnaaⁿ chaꞌxjeⁿ na tjom Jonás. ");
INSERT INTO amuNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ee juu Jonás tyotseixmaaⁿ ꞌnaaⁿ jo nda̱a̱ nnꞌaⁿ tsjoom Nínive ncꞌe na jluiꞌnꞌmaaⁿñê tsꞌom tsiaaꞌ catscaa tꞌmaaⁿ xuee jnda̱ ndyee na tioyoꞌ jom. Maluaaꞌ ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee nntseixmaⁿya ꞌnaaⁿ jo nda̱a̱ nnꞌaⁿ na mꞌaⁿ jeꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Xuee quia na nncuꞌxeⁿ Tyꞌo̱o̱tsꞌom nnꞌaⁿ, nncwandoꞌnndaꞌ yuscu na tyotsa̱ꞌntjom nnꞌaⁿ ndyuaa jo ndoꞌ na macaluiꞌ caxjuu tsꞌoomꞌnaaⁿ. Ndoꞌ nñequiaaⁿ jnaaⁿ nnꞌaⁿ na mꞌaaⁿ jeꞌ, ee jeeⁿ ndyaꞌ tquia jnaaⁿ na ñeꞌcañeeⁿ ñꞌoomjndo̱ꞌtsꞌom na tyotseineiⁿ Salomón. Ndoꞌ ljoo mꞌaaⁿya jeꞌ na tꞌmaⁿti cwiluiindyo̱, nchiiti Salomón, sa̱a̱ tiñecandyeꞌyoꞌ ñꞌoom na mañequia. ");
INSERT INTO amuNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Xuee na nncuꞌxeⁿ Tyꞌo̱o̱tsꞌom nnꞌaⁿ na jnda̱ tja̱, nntaꞌndoꞌnndaꞌ nnꞌaⁿ tsjoom Nínive, mandiñꞌeeⁿ nnꞌaⁿ na mꞌaaⁿ jeꞌ na quia nncꞌoowjee. Ndoꞌ nntꞌuiityeⁿnaꞌ joona ncꞌe na yati lꞌa nnꞌaⁿ Nínive. Ee joo naⁿꞌñeeⁿ lcweꞌ nꞌomna quia na tyoñequiaa Jonás ñꞌoomꞌ Tyꞌo̱o̱tsꞌom nda̱a̱na. Ndoꞌ ꞌo jeꞌ, ja jnda̱ tyja̱ quiiꞌntaaⁿꞌyoꞌ na cwiluiitꞌmaⁿndyo̱tya̱, nchiiti Jonás, sa̱a̱ nchaaꞌ lꞌuu ñeꞌcalcweꞌ nꞌomꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Tso Jesús: —Tjaaꞌnaⁿ tsꞌaⁿ na ntseicwꞌaa lámpara, jnda̱ joꞌ nncwjaaꞌñeyom juunaꞌ yuu na wantyꞌiuuꞌ oo nacjeeꞌ castom. Maxjeⁿ nntseintyjaaⁿ juunaꞌ yuu na ndye cha xuee nncꞌooquieꞌ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Laꞌxmaⁿ nꞌomnnom tsꞌaⁿ chaꞌcwijom lámpara cwentaaꞌ chaꞌwaañe tsꞌaⁿ. Xeⁿ na ya nꞌomnjomꞌ quia joꞌ chaꞌwaandyuꞌñꞌeⁿꞌ mꞌaaⁿꞌ na xueeñe. Sa̱a̱ xeⁿ tisꞌa nꞌomnjomꞌ quia joꞌ chaꞌwaandyuꞌñꞌeⁿꞌ mꞌaaⁿꞌ na jaaⁿñe. ");
INSERT INTO amuNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Quia joꞌ catsaꞌ cwenta na juu na cwiluiiñe naxuee cantyja ꞌnaⁿꞌ, tintseicwaqueⁿnaꞌ joꞌ najaaⁿñe. ");
INSERT INTO amuNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Xeⁿ chaꞌtso cantyja ꞌnaⁿꞌ matseiꞌxmaⁿꞌ naxuee ndoꞌ tjaa yuu candiiꞌ najaaⁿ, quia joꞌ nntseijomnaꞌ cantyja ꞌnaⁿꞌ chaꞌcwijom lámpara na matseixueeñe chom nda̱a̱ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Quia na jnda̱ seineiⁿ Jesús, cwii tsꞌaⁿ fariseo tso nnoom na cjaⁿ, nlcwaaⁿꞌaⁿ waaꞌ. Jnda̱ tueⁿꞌeⁿ, tjaqueⁿꞌeⁿ quiiꞌ wꞌaa ndoꞌ tyꞌewindyuaandyena nacañoomꞌ meiⁿsa. ");
INSERT INTO amuNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Juu fariseoꞌñeeⁿ, jeeⁿ ticjaaweeꞌ tsꞌom quia ntyꞌiaaꞌ na ticandyuuꞌ Jesús cwii tjo̱o̱cheⁿ na nlcwaaⁿꞌaⁿ chaꞌxjeⁿ costumbre cwilꞌa joona. ");
INSERT INTO amuNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Tso Ta Jesús nnom: —ꞌO nnꞌaⁿ fariseos, jeeⁿ cwilaljuꞌyoꞌ nacjoo watso ñꞌeⁿ nquio sa̱a̱ nꞌomnaꞌ ndicwaⁿ cwajndii. Maluaaꞌ matseijomnaꞌ naquiiꞌ nꞌomꞌyoꞌ ee tooꞌcheⁿ mꞌaaⁿ ñomtiuu chiuu nnda̱a̱ nntyꞌueeꞌyoꞌ ꞌnaⁿ ñequio ntꞌomcheⁿ natia na cwilꞌaꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ntjeiⁿndyoꞌ ꞌo. Manquiuꞌyoꞌ na Tyꞌo̱o̱tsꞌom seijndaaꞌñê nacjooꞌ tsꞌaⁿ, mati seijndaaꞌñê naquiiꞌ tsꞌom tsꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Calꞌaꞌyoꞌ naya ndyeñeeⁿꞌ, quia joꞌ mꞌmo̱ⁿnaꞌ na ljuꞌ cwiluiindyoꞌ naquiiꞌ nꞌomꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","’Nntꞌuiiwiꞌnaꞌ ꞌo nnꞌaⁿ fariseos, meiiⁿ jeeⁿ cwilacanda̱ꞌyoꞌ na cwiñeꞌquiaꞌyoꞌ diezmo cwentaaꞌ Tyꞌo̱o̱tsꞌom hasta meiiⁿ cweꞌ ñequio tscojñom tsꞌoomjndya ñequio tsco na ja, ndoꞌ chaꞌtso ntꞌomcheⁿ nnom tsco na cwicwaꞌyoꞌ, sa̱a̱ tquia cwiꞌndyeꞌyoꞌ na nlꞌaꞌyoꞌ yuu na matyꞌiomyanaꞌ ñequio ncꞌiaaꞌyoꞌ. Mati meiⁿchjoo ticajnda nquiuꞌyoꞌ Tyꞌo̱o̱tsꞌom. Nmeiⁿꞌ macaⁿnaꞌ na calacanda̱ꞌyoꞌ ndoꞌ titsaawiꞌntyjeꞌyoꞌ na cwiñeꞌquiaꞌyoꞌ diezmo cwentaaꞌ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","’Nntꞌuiiwiꞌnaꞌ ꞌo nnꞌaⁿ fariseos, ee ꞌo cwilayuunda̱a̱ꞌyoꞌ ntsula̱ na cañoomticheⁿ naquiiꞌ lanꞌom. Ndoꞌ jeeⁿ lꞌue nꞌomꞌyoꞌ na calaꞌtꞌmaaⁿꞌndye nnꞌaⁿ ꞌo quia cwiwincwindyoꞌ nataa cha cantyꞌiaa nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","’Nntꞌuiiwiꞌnaꞌ ꞌo nnꞌaⁿ na cwitꞌmo̱ⁿꞌyoꞌ ljeii na tqueⁿ Moisés ñequio ꞌo nnꞌaⁿ fariseos na cwilꞌaꞌyaꞌyoꞌ na jeeⁿ yannꞌaⁿndyoꞌ cweꞌ cha queⁿ nnꞌaⁿ cwenta. Cantyja ꞌnaⁿꞌ ꞌo jndye nnꞌaⁿ wjaachuuñenaꞌ na meiⁿchjoo ticaliuna na tisꞌa cwilꞌana. Matseijomnaꞌ ꞌo chaꞌna ndeiꞌluaa na jnda̱ tsu. Meiiⁿ cwico̱ꞌ nnꞌaⁿ nacjoonaꞌ sa̱a̱ ticaliuna na ndeiꞌluaa joꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Tꞌo̱ cwiindye naⁿꞌñeeⁿ na maꞌmo̱ⁿ ljeii na tqueⁿ Moisés. Tso nnoom: —Jeeⁿ ꞌu Ta, ñꞌoom na matsuꞌ luaaꞌ, mati matseijnaaⁿꞌnaꞌ jâ. ");
INSERT INTO amuNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Quia joꞌ tsoom nnom tsaⁿꞌñeeⁿ: —Mati ꞌo nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés nntꞌuiiwiꞌnaꞌ ꞌo na cwilaꞌjnda̱ꞌyoꞌ na calaꞌcanda̱ nnꞌaⁿ ñꞌoom na jeeⁿ jndeiꞌnaꞌ chaꞌcwijom na cwityꞌiomꞌyoꞌ xuu nnꞌaⁿ sa̱a̱ ncjoꞌyoꞌ, nchaaꞌ lꞌuu nntiiꞌ lueeꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","’Nntꞌuiiwiꞌnaꞌ ꞌo ee cwilꞌaꞌxcoꞌyoꞌ ndeiꞌluaa ꞌnaaⁿ profetas na tyolaꞌcwje weloꞌyoꞌ tandyo xuee, cha cantyꞌiaa nnꞌaⁿ na jeeⁿ cwilaꞌtꞌmaaⁿꞌndyoꞌ naⁿꞌñeeⁿ. Ndoꞌ manquieeti weloꞌyoꞌ na ñetꞌom quia ljoꞌ jlaꞌcwjeena naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ndoꞌ na luaaꞌ cwilꞌaꞌyoꞌ, cwiluiꞌyuuꞌ na cwilajomndyoꞌ na luaaꞌ lꞌana. Ee joona jlaꞌcwjeena naⁿꞌñeeⁿ ndoꞌ ꞌo jeꞌ cwilꞌaꞌxcoꞌyoꞌ ndeiꞌluaa naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","’Joꞌ chii cantyja na jndo̱ꞌ tsꞌom Tyꞌo̱o̱tsꞌom, joꞌ na tsoom: “Quiiꞌntaaⁿ nnꞌaⁿ njño̱o̱ⁿya profetas ñequio apóstoles. Ntꞌomndye joona nlaꞌcwjee nnꞌaⁿ, ndoꞌ ntꞌomcheⁿ nleiꞌntyjo̱na.” ");
INSERT INTO amuNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Joꞌ chii, nnꞌaⁿ na mꞌaⁿ jeꞌ nntsꞌaa Tyꞌo̱o̱tsꞌom na chojnaⁿna nioom chaꞌtso profetas na tyolaꞌcwjee nnꞌaⁿ xjeⁿ na jnaⁿcheⁿ tsjoomnancue. ");
INSERT INTO amuNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Wjaacꞌoomnaꞌ na tioo nioomꞌ Abel na seiquioo Caín hasta na macanda̱ na tioo nioomꞌ Zacarías, tsꞌaⁿ na jlaꞌcueeꞌ nnꞌaⁿ quiiꞌntaaⁿꞌ tio tꞌmaⁿ ñequio ta watsꞌom. Nndyeꞌyoꞌ nntsjo̱o̱, maxjeⁿ nntioomndye nnꞌaⁿ na mꞌaⁿ jeꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","’Nntꞌuiiwiꞌnaꞌ ꞌo nnꞌaⁿ na cwitꞌmo̱ⁿꞌyoꞌ ljeii na tqueⁿ Moisés. Ee jnda̱ jlaꞌcuꞌyoꞌ ñꞌoom na mañequiaanaꞌ na wjaatseijndo̱ꞌnaꞌ nꞌom nnꞌaⁿ. Mancjoꞌtiꞌyoꞌ ticjooꞌ nꞌomꞌyoꞌ na nlaꞌno̱ⁿꞌyoꞌ ñꞌoomꞌñeeⁿ meiⁿ tiñeꞌquiaꞌyoꞌ na nncꞌooliu nnꞌaⁿna queeⁿ nꞌom na ñecalaꞌno̱ⁿꞌna juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jnda̱ na seineiⁿ Jesús ñꞌoommeiⁿꞌ nda̱a̱na, quia joꞌ nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés ñequio nnꞌaⁿ fariseos, to̱ꞌna na tꞌmaⁿ tyolaꞌncjooꞌndyena ñꞌeⁿñê. To̱ꞌna na tyolaꞌliooꞌna jom na jndye ñꞌoom tyotaꞌxꞌeena nnoom. ");
INSERT INTO amuNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Tyoqueⁿna cwenta xeⁿ nntsoom cwii ñꞌoom na nñequiaanaꞌ na ntꞌuiinaꞌ jom. ");
INSERT INTO amuNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Yocheⁿ na luaaꞌ, jndye meiⁿ nnꞌaⁿ tjatjomndye hasta tyoteiꞌcaljoondye ntyjeena na tyeeⁿ mꞌaⁿna. To̱o̱ⁿꞌo̱ⁿ na tyotseineiⁿjñeeⁿ nda̱a̱ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê. Matsoom: —Calꞌaꞌyoꞌ cwenta ñꞌoom na cwitꞌmo̱o̱ⁿ fariseos, ee we waa cwilaꞌtiuuna. Ndoꞌ ñꞌoomꞌñeeⁿ wjaantyꞌeenaꞌ chaꞌna cwiwicandiꞌ ndaaljoꞌ naquiiꞌ tsqueeⁿ tyooꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Tjaaꞌnaⁿ cwii na cweꞌ wantyꞌiuuꞌ waa na xocano̱o̱ⁿ ndoꞌ tjaaꞌnaⁿ meiⁿcwii na cweꞌ ntyꞌiu na xocaliu nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Cweꞌ ncꞌe joꞌ, chaꞌtso na ñejnduꞌyoꞌ yuu najaaⁿñe, maxjeⁿ nleitquiooꞌ ñꞌoomꞌñeeⁿ yuu na xuee. Ndoꞌ ñꞌoom na jnda̱ jlaneiⁿꞌyoꞌ na ñemaaⁿꞌ ñemaaⁿꞌ naquiiꞌ lꞌaa na ta̱ꞌ, maxjeⁿ nleicꞌuaanaꞌ chꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","’ꞌO nnꞌaⁿ na ya ñꞌoom ja ñꞌeⁿndyoꞌ, nndyeꞌyoꞌ nntsjo̱o̱, tincꞌomꞌyoꞌ na nquiaꞌyoꞌ nnꞌaⁿ na cwilaꞌcwjee nnꞌaⁿ ee tjaa ljoꞌ cwii nnda̱a̱ nlꞌatina ñꞌeⁿndyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ja mꞌmo̱o̱ⁿ ꞌñeeⁿ na nncꞌomꞌyoꞌ na nquiaꞌyoꞌ. Cꞌomꞌyoꞌ na nquiaꞌyoꞌ nquii Tyꞌo̱o̱tsꞌom. Ee jom waa najneiⁿ na nncjoomꞌm ꞌo naquiiꞌ bꞌio quia na jnda̱ tjeiiⁿꞌeⁿ na cwitandoꞌyoꞌ. Mayuuꞌ matsjo̱o̱ nda̱a̱ꞌyoꞌ, jom cꞌomꞌyoꞌ na nquiaꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","’ꞌOm cantsaa nchꞌu ¿aa nchii ñewe tsjo̱ꞌñjeeⁿ cwileilꞌuandyeyoꞌ? Sa̱a̱ meiiⁿ na ljoꞌ, meiⁿcwiindye jooyoꞌ tyootsuuꞌ tsꞌom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Majndeiiticheⁿ ꞌo. Hasta ticwii cwii soonqueⁿꞌyoꞌ, jnda̱ teiꞌnchonaꞌ. Joꞌ chii tintyueꞌyoꞌ, ee ꞌo jndandyoꞌtiꞌyoꞌ nchiiti cantsaa nchꞌu na jndyendye. ");
INSERT INTO amuNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","’Nndyeꞌyoꞌ nntsjo̱o̱, meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na macwjiꞌyuuꞌñe cantyja ꞌnaⁿya jo nda̱a̱ nnꞌaⁿ, mati ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee nncwjiꞌyuuꞌndyo̱ na mawajnaⁿꞌa tsaⁿꞌñeeⁿ jo nda̱a̱ ángeles cwentaaꞌ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Sa̱a̱ juu tsꞌaⁿ na macwjiꞌñe cantyja ꞌnaⁿya jo nda̱a̱ nnꞌaⁿ, mati ja nntsjo̱o̱ na ticwajnaⁿꞌaⁿ tsaⁿꞌñeeⁿ jo nda̱a̱ ángeles cwentaaꞌ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","’Meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na matso cwii ñꞌomntjeiⁿ nacjo ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee, Tyꞌo̱o̱tsꞌom nnda̱a̱ nntseitꞌmaⁿ tsꞌoom tsaⁿꞌñeeⁿ. Sa̱a̱ tsꞌaⁿ na nncjuꞌ ñꞌomwiꞌ nacjooꞌ Espíritu Santo, taxocatseitꞌmaⁿ tsꞌom Tyꞌo̱o̱tsꞌom juu. ");
INSERT INTO amuNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","’Quia na nncꞌoocho nnꞌaⁿ ꞌo jo nda̱a̱ nnꞌaⁿ na cwituꞌxeⁿ ñꞌoom naquiiꞌ lanꞌom nchꞌu, oo jo nda̱a̱ naⁿmaⁿnꞌiaaⁿ, xjeⁿꞌñeeⁿ tincꞌomꞌyoꞌ ñꞌomtiuu cwaaⁿ ñꞌoom nlaꞌlcweꞌyoꞌ ");
INSERT INTO amuNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ee xjeⁿꞌñeeⁿ nquii Espíritu Santo mꞌmo̱o̱ⁿ nda̱a̱ꞌyoꞌ cwaaⁿ ñꞌoom nnduꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Quia joꞌ cwii tsꞌaⁿ quiiꞌntaaⁿ nnꞌaⁿ na jndyendye, tso: —Ta, catsuꞌ nnom tiꞌxio̱o̱ na cato̱o̱ⁿꞌo̱ⁿ ꞌnaⁿ na ꞌndii tsotya̱a̱yâ, nloꞌño̱ⁿya na tseixmaⁿnaꞌ cwentaya. ");
INSERT INTO amuNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Tꞌo̱ Jesús nnom, matsoom: —ꞌU re, ja nchii cwiluiindyo̱ na cuꞌxa̱ⁿya ñꞌoom ꞌnaⁿꞌyoꞌ oo na cato̱o̱ⁿꞌa ꞌnaⁿꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Jnda̱ joꞌ tsoom nda̱a̱ chaꞌtsondye nnꞌaⁿ: —¿Aa jndoꞌyoꞌ? Nmeiiⁿꞌ quichꞌeenaꞌ. Queⁿndyoꞌ cwenta na tilaqueeⁿ nꞌomꞌyoꞌ ꞌnaⁿ. Ee na wandoꞌ tsꞌaⁿ nchii manaⁿnaꞌ cweꞌ na jndye ꞌnaaⁿꞌaⁿ niom. ");
INSERT INTO amuNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Quia joꞌ mati seineiiⁿ cwii ñꞌoom na cweꞌ tjañoomꞌ, tsoom: —Tyomꞌaaⁿ cwii tsaⁿtya na ya tyuaaⁿꞌaⁿ ndoꞌ jeeⁿ ya tyoweꞌ ntjoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Tyotseitioom naquiiꞌ tsꞌoom, matsoom: “Chiuu chiuu nntsꞌaayo̱ ee tjaaꞌnaⁿ yuu ya nntseiwa̱ya ꞌnaⁿ na tueꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Seineiⁿ cheⁿnqueⁿ, tsoom: “Ntyjii chiuu nntsꞌaa, nntseityuiiꞌa nda̱ꞌ yuu na cwicañjom na cwiweꞌ ndoꞌ nntsꞌaa ntꞌomcheⁿ na ntꞌmaⁿti. Joꞌ joꞌ nntseiwa̱ chaꞌtso na tueꞌ ñequio ntꞌomcheⁿ ꞌnaⁿya. ");
INSERT INTO amuNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ndoꞌ nntsjo̱o̱cheⁿnco̱ no̱o̱ⁿ: Jeꞌ jeꞌ yuuꞌa, jndye ꞌnaⁿya jnda̱ seiwa̱ na nleijndeiinaꞌ jndye ndyu. Jeꞌ nncwajndya̱, nlcwaaꞌa ndoꞌ nncꞌua. Nncꞌo̱o̱ⁿ na neiⁿnco tsꞌo̱o̱ⁿ.” ");
INSERT INTO amuNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Sa̱a̱ tso Tyꞌo̱o̱tsꞌom nnoom: “Ntjeiⁿndyuꞌ ꞌu. Tsjom jeꞌ nncꞌioꞌ ndoꞌ chaꞌtso ꞌnaⁿꞌ na jnda̱ seiweꞌ, ¿ꞌñeeⁿ nljonaꞌ lꞌo̱?” ");
INSERT INTO amuNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Maluaaꞌ nntjom tsꞌaⁿ na tomti ñjom tsꞌom na matseitꞌue ꞌnaaⁿꞌ. Sa̱a̱ jo nnom Tyꞌo̱o̱tsꞌom tseixmaⁿ na jñeeⁿꞌñe. ");
INSERT INTO amuNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ndoꞌ tso Jesús nda̱a̱ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê: —Cweꞌ joꞌ na matsjo̱o̱ nda̱a̱ꞌyoꞌ, tancꞌomꞌyoꞌ na jeeⁿ jndye mꞌaaⁿꞌ nꞌomꞌyoꞌ cantyja ꞌnaⁿ na macaⁿnaꞌ ꞌo tsjoomnancue, yuu nluiꞌ na nlcwaꞌyoꞌ ndoꞌ na nlcweeꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ee tꞌmaⁿti tseixmaⁿ na cwitandoꞌyoꞌ nchiiti nantquie na cwicwaꞌyoꞌ. Ndoꞌ cajndandyoꞌtiꞌyoꞌ nchiiti liaꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Queⁿꞌyoꞌ cwenta candyaa, tiquinomyoꞌ, meiⁿ tiquilaꞌweyoꞌ ntjom na cwiweꞌ, meiⁿ lꞌaa yuu na nlaꞌweyoꞌ nantquie tjaaꞌnaⁿ, ndoꞌ meiⁿ nda̱ꞌ ꞌnaaⁿyoꞌ tjaaꞌnaⁿ sa̱a̱ Tyꞌo̱o̱tsꞌom mateixꞌeeⁿ jooyoꞌ. ꞌO cajndandyoꞌti ntyjeeⁿ, nchiiti cweꞌ candyaa. ");
INSERT INTO amuNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","¿ꞌÑeeⁿ cwii ꞌo nnda̱a̱ nntsꞌaa na nleitcooñeti meiiⁿ ñeꞌchjoowiꞌ, cweꞌ na jeeⁿ jndye matseitiuu? ");
INSERT INTO amuNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Quia joꞌ xeⁿ xonda̱a̱ nlꞌaꞌyoꞌ meiⁿ ñechjoowiꞌ luaaꞌ, cweꞌ tsꞌiaaⁿꞌ na jeeⁿ jndye cwilatiuuꞌyoꞌ cantyja ꞌnaaⁿ ntꞌomcheⁿ na majndeiiticheⁿ joꞌ xonda̱a̱ nlꞌaꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","’Queⁿꞌyoꞌ cwenta chiuu waa na neiⁿncooꞌ ljaaꞌ canchiiꞌ. Tiquilꞌanaꞌ tsꞌiaaⁿ, meiⁿ tiquilꞌanaꞌ canduu na nluii liaanaꞌ. Sa̱a̱ nndyeꞌyoꞌ nntsjo̱o̱, meiⁿ nquii rey Salomón, xcwe xjeⁿ na tjacantyja na tyañê ticueꞌntyjo̱ na neiⁿncooꞌ liaⁿꞌaⁿ chaꞌna neiⁿncooꞌ cwii ljaaꞌ canchiiꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Xeⁿ luaaꞌ waa na machꞌee Tyꞌo̱o̱tsꞌom, na neiⁿncooꞌ ljaaꞌ tscojnda̱a̱, ndoꞌ ꞌio cha nlconaꞌ, aa nchii majndeiiticheⁿ ntyjeeⁿ chiuu nlcweeꞌ ꞌo liaa, ꞌo nnꞌaⁿ na ticalayuꞌya nꞌomꞌyoꞌ ñꞌeⁿ jom. ");
INSERT INTO amuNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ncꞌe joꞌ tancꞌomꞌyoꞌ na jaawa jaacue mꞌaaⁿꞌ nꞌomꞌyoꞌ na nlcwaꞌyoꞌ ndoꞌ na nncweꞌyoꞌ. Tancꞌomꞌyoꞌ na jeeⁿ chjooꞌ nꞌomꞌyoꞌ cantyja ꞌnaaⁿꞌ nmeiⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Ee ñenquiiꞌcheⁿ nmeiⁿꞌ cwilꞌuee nnꞌaⁿ chaꞌwaa tsjoomnancue. Sa̱a̱ nquii Tsotyeꞌyoꞌ, mantyjeeⁿ na tjo̱o̱ndyoꞌ chaꞌtso nmeiⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Joꞌ chii ꞌo, calꞌueꞌyoꞌ cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom ndoꞌ ntoꞌñoomꞌyoꞌ chaꞌtso ꞌnaⁿmeiⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","’ꞌO nnꞌaⁿ tmaaⁿꞌ chjoo cwentaya, tilaꞌcatyuendyoꞌ, ee cjaaweeꞌ ntyjii Tsotyeꞌyoꞌ na nlaxmaⁿꞌyoꞌ cantyja na matsa̱ꞌntjoom. ");
INSERT INTO amuNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Canda̱a̱ꞌyoꞌ ꞌnaⁿꞌyoꞌ na niom ndoꞌ calꞌaꞌyoꞌ naya ndyeñeeⁿꞌ. Xeⁿ luaaꞌ nlꞌaꞌyoꞌ, cañoomꞌluee nlatꞌueꞌyoꞌ ꞌnaⁿꞌyoꞌ yuu na xocandyue ee joꞌ joꞌ xocanda̱a̱ nncjaaquieeꞌ tsaⁿcanchꞌue meiⁿ candiu tixocalaꞌndaaꞌyoꞌ joonaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ee yuu na cwilaweꞌyoꞌ naya ꞌnaⁿꞌyoꞌ, joꞌ joꞌ quitꞌmaⁿ nꞌomꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Seineiⁿ Jesús chiuu nntsꞌaanaꞌ quia na nncwjeeꞌnnaaⁿꞌaⁿ. Tsoom: —Cꞌomꞌcꞌeendyoꞌ na cwimeiꞌndoꞌyoꞌ ja. Cꞌomꞌyoꞌ chaꞌna nnꞌaⁿ na mꞌaⁿ moso na ñequiiꞌcheⁿ xuee chom lámpara ꞌnaaⁿna. ");
INSERT INTO amuNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Cwimeiꞌndooꞌna patrom ꞌnaaⁿna na nncwjeeⁿꞌeⁿ na tjaaⁿ yuu toco tsꞌaⁿ. Quia na mꞌmaaⁿ ꞌndyootsꞌa, mꞌaⁿcꞌeendyena na nlaꞌcanaaⁿndyena. ");
INSERT INTO amuNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Matseineiiⁿꞌñe patrom mosoomꞌm quia na nncwjeꞌcañoom na nljeiiⁿ na ya cwenta cwilꞌana. Mayuuꞌcheⁿ matsjo̱o̱ nda̱a̱ꞌyoꞌ, nntseijndaaꞌñê na nntseiñꞌoomꞌñê ljoꞌ nlcwaꞌna. Ndoꞌ nntsꞌaaⁿ na cwindyuaandyena nacañoomꞌ meiⁿsa na nndiꞌntjoom nda̱a̱na. ");
INSERT INTO amuNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Maxjeⁿ matioꞌnaaⁿñenaꞌ mosoꞌñeeⁿ xeⁿ nljeiiⁿ na mꞌaⁿcꞌeendyena, meiiⁿ aa nncwjeeⁿꞌeⁿ xcwe tsjom oo jaancoo. ");
INSERT INTO amuNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ndoꞌ calaꞌno̱ⁿꞌyoꞌ ñꞌoomwaa, juu tsꞌaⁿ na cwiluiitquieñe naquiiꞌ wꞌaa, xeⁿ ntyjeeⁿ ljoꞌ xjeⁿ nncwjeeꞌ tsaⁿcachꞌue, quia joꞌ nncꞌoomcꞌeeñê ndoꞌ tixonquiaaⁿ na nncjaaquieeꞌ tsaⁿꞌñeeⁿ naquiiꞌ wꞌaa. ");
INSERT INTO amuNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Mati ꞌo cꞌomꞌcꞌeendyoꞌ, ee ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee majuuto xjeⁿ na ticalatiuuꞌyoꞌ na nncwja̱, majoꞌto xjeⁿꞌñeeⁿ nncwja̱ꞌcaño̱o̱ⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Quia joꞌ tso Pedro nnoom: —Aa ndiꞌ Ta, ¿aa cweꞌ nda̱a̱ jâ matseiꞌneiⁿꞌ ñꞌoom tjañoomꞌwaaꞌ, oo aa mati nda̱a̱ chaꞌtsondye nnꞌaⁿ? ");
INSERT INTO amuNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Tꞌo̱ Jesús, tsoom: —¿ꞌÑeeⁿ juu joꞌ matseitiuuꞌ na cwiluiiñe moso tquiee na cjee matseino̱ⁿꞌ ndoꞌ na matseicanda̱? Tsaⁿꞌñeeⁿ nntyꞌiom patrom tsꞌiaaⁿ na candoꞌ tsaⁿꞌñeeⁿ ntyje mosoñe na nñequiaa nantquie na nlcwaꞌ naⁿꞌñeeⁿ quia cwiweeꞌ xjeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Mañequiaanaꞌ na neiiⁿꞌ mosoꞌñeeⁿ quia na nncwjeꞌcañoom patrom ꞌnaaⁿꞌaⁿ na nljeii na ya machꞌeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mayuuꞌcheⁿ matsjo̱o̱ nda̱a̱ꞌyoꞌ, lꞌo̱ juu nñequiaa patrom chaꞌtso ꞌnaaⁿꞌaⁿ na niom na cateixꞌee joonaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Sa̱a̱ xeⁿ mosotquieeꞌñeeⁿ nntseitioom: “Tjo̱o̱cheⁿ na nncwjeeꞌ patrom ꞌnaⁿya.” Ndoꞌ joꞌ na nnto̱o̱ⁿꞌo̱ⁿ na nncwjaaⁿꞌaⁿ chaꞌtso ntyjemosoñê, naⁿnom ndoꞌ naⁿlcu. Nlcwaꞌjndooꞌñê, nncꞌom ndoꞌ nñeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Majuuto xuee na ticꞌoomcꞌeⁿ ndoꞌ na taqueⁿtoom cwenta, nncwjeꞌcañoom patrom ꞌnaaⁿꞌaⁿ, quia joꞌ cwajndii nnchoomꞌm. Jnda̱ joꞌ nncjuꞌnaꞌ jom yuu na mꞌaⁿ nnꞌaⁿ na tîcalaꞌyuꞌ ñꞌeⁿ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","’Ee mosoꞌñeeⁿ mantyjeeⁿ ljoꞌ lꞌue tsꞌom patrom ꞌnaaⁿꞌaⁿ na catsꞌaaⁿ sa̱a̱ tîcatseijndaaꞌñê, meiⁿ tîcatseicana̱a̱ⁿ yuu na lꞌue tsꞌom tsaⁿꞌñeeⁿ, joꞌ chii jeeⁿ jndye nnchoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Sa̱a̱ moso na seitjo̱o̱ñe cweꞌ ticatseiꞌno̱ⁿꞌ ljoꞌ nntsꞌaa, meiiⁿ na nnchuuꞌ sa̱a̱ tijndye. Meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na tꞌmaⁿ tsꞌiaaⁿ macoꞌñom, jndye nlcaⁿnaꞌ na catsꞌaaⁿ. Ndoꞌ tsꞌaⁿ na tꞌmaⁿ xuu jnda̱ tyꞌiom tsꞌaⁿ juu, majndyeti nnom nñequiaaⁿ cwenta. ");
INSERT INTO amuNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","’Ja jndyo̱o̱ na jndyo̱cwjaaꞌndyo̱ chom quiiꞌntaaⁿ nnꞌaⁿ tsjoomnancue. Ndoꞌ toom cweꞌ na cwiluii naljoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Waa cwii na jndeiꞌnaꞌ na catjo̱ⁿya, na nncꞌio̱ya. Ndoꞌ jeeⁿ matseiꞌndaaꞌnaꞌ ntyjii hasta xuee na nntseicanda̱a̱ꞌñenaꞌ joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ticalaꞌtiuuꞌyoꞌ na jndyo̱o̱ tsjoomnancue na caljoyaandye nnꞌaⁿ ñꞌeⁿ ncꞌiaana. Ja jndyo̱o̱ na jndyo̱cwjaaꞌndyo̱ tiaꞌ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ee jeꞌ xuee na cwii wjaatinaꞌ, nnꞌaⁿ na ñeꞌcwii wꞌaa nnto̱ⁿꞌndyena, ndyeendye naⁿꞌñeeⁿ nncꞌomna nacjoo we, ndoꞌ wendye naⁿꞌñeeⁿ nncꞌomna nacjoo ndyee. ");
INSERT INTO amuNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Maxjeⁿ nnto̱ⁿꞌndye nnꞌaⁿ. Tsotye tsꞌaⁿ wjaⁿ nacjooꞌ tiꞌjnaaⁿ, ndoꞌ tiꞌjnaaⁿ wjaa nacjoomꞌm. Tsondyee tsꞌaⁿ wjaⁿ nacjooꞌ nomjnaaⁿ ndoꞌ nomjnaaⁿ wjaa nacjoomꞌm. Ndoꞌ wjaⁿ nacjooꞌ nomnntsaaⁿꞌaⁿ ndoꞌ nomnntsaaⁿꞌaⁿ wjaa nacjoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Mati tso Jesús nda̱a̱ nnꞌaⁿ na jndyendye: —Quia na cwintyꞌiaꞌyoꞌ na cwicaluiꞌ nchquiu ntyja na majaacue ñeꞌquioomꞌ, mantyja quinduꞌyoꞌ na manncuaꞌ, ndoꞌ mayuuꞌ na ljoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ndoꞌ quia na cwintyꞌiaꞌyoꞌ na manaⁿ jndye ntyja na macaluiꞌ caxjuu tsoomꞌnaaⁿ, quinduꞌyoꞌ: “Jeꞌ nleijmeiⁿꞌ”, ndoꞌ mayuuꞌ na ljoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ꞌO nnꞌaⁿ na cweꞌ cwilꞌaꞌyaꞌyoꞌ na jeeⁿ cwilacanda̱a̱ꞌndyoꞌ cweꞌ cha cantyꞌiaa nnꞌaⁿ, jeeⁿ jndo̱ꞌ nꞌomꞌyoꞌ na cwiliuꞌyoꞌ cantyja na cwichuiiꞌ nnom tsjoomnancue ñequio tsjo̱ꞌluee. Sa̱a̱ ¿chiuu na tileicalaꞌno̱ⁿꞌyoꞌ cantyja na matsꞌaaya quiiꞌntaaⁿꞌyoꞌ jeꞌ? ");
INSERT INTO amuNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Tsoticheⁿ Jesús nda̱a̱na: —¿Chiuu na ticatjeiꞌyoꞌ cwenta yuu waa na matyꞌiomyanaꞌ? ");
INSERT INTO amuNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Quia na nlqueⁿ tsꞌaⁿ na quio matseintjaꞌndyuꞌ ñꞌoom nacjoꞌ, yocheⁿ na ñjomndyoꞌ nato na tsaꞌyoꞌ na nntjomndyoꞌ watsꞌiaaⁿ, queⁿndyuꞌ na cwaⁿꞌyaꞌ jom, cha tintsꞌaanaꞌ na nleiñꞌoomtsco̱o̱ꞌñê ꞌu ñꞌeⁿ ñꞌoom jo nnom jwe. Ndoꞌ jweꞌñeeⁿ nñequiaaⁿ cwenta ꞌu luee sondaro. Ndoꞌ joona nntueeꞌnaꞌ ꞌu wꞌaancjo. ");
INSERT INTO amuNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nndiꞌ nntsjo̱o̱, taxocaluiꞌ joꞌ joꞌ hasta na jnda̱ tiomꞌnchaaꞌndyuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Maxjeⁿꞌñeeⁿ tquieꞌcañom nnꞌaⁿ na jlaꞌcandiina Jesús na sa̱ꞌntjom Pilato na cwje ntꞌom nnꞌaⁿ galileos xcwe xjeⁿ na cwilaꞌcwjeena quiooꞌ na cwilaꞌtꞌmaaⁿꞌndyena Tyꞌo̱o̱tsꞌom. Seitjoomꞌnaꞌ nioomna ñequio nioom quiooꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Tꞌo̱ Jesús nda̱a̱na, matsoom: —¿Aa cwilaꞌtiuuꞌyoꞌ na luaaꞌ tjoomna ee na tꞌmaⁿti jnaaⁿna waa, nchiiti chaꞌtso ntꞌomcheⁿ ncꞌiaana ndyuaaꞌñeeⁿ? ");
INSERT INTO amuNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nndyeꞌyoꞌ nntsjo̱o̱, meiⁿchjoo nchii joꞌ. Ee mati xeⁿ ticalcweꞌ nꞌomꞌyoꞌ, chaꞌtsondyoꞌ nntsuundyoꞌ chaꞌxjeⁿ na tsuundye joona. ");
INSERT INTO amuNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ndoꞌ joo quinꞌoom nchooꞌ ndyee nnꞌaⁿ na tja̱ quia na tioo wꞌaandye nacjoona nndyooꞌ peila Siloé, ¿aa cwilatiuuꞌyoꞌ na naⁿꞌñeeⁿ tꞌmaⁿti tyolaꞌtjo̱o̱ndyena, nchiiti chaꞌtsondye nnꞌaⁿ na tyomꞌaⁿ Jerusalén? ");
INSERT INTO amuNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nndyeꞌyoꞌ nntsjo̱o̱, meiⁿchjoo nchii joꞌ, ee mati meiiⁿ ꞌo xeⁿ ticalcweꞌ nꞌomꞌyoꞌ, chaꞌtsondyoꞌ maluaaꞌ nntsuundyoꞌ chaꞌxjeⁿ na tsuundye joona. ");
INSERT INTO amuNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Quia joꞌ seineiiⁿ ñꞌoomwaa na tjañoomꞌ na maꞌmo̱ⁿnaꞌ na macaⁿnaꞌ na calcweꞌ nꞌom nnꞌaⁿ. Matsoom: —Tyomꞌaaⁿ cwii tsꞌaⁿ, tyomeintyjeeꞌ tsꞌoom higuera naquiiꞌ ntjoomꞌm. Ndoꞌ tjacalꞌueeⁿ ta̱a̱ꞌ tsꞌoomꞌñeeⁿ sa̱a̱ tjaa ljoꞌ ljeiiⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Joꞌ chii tsoom nnom tsꞌaⁿ na machꞌee cwenta ntjoomꞌm: “Cantyꞌiaꞌ, tsꞌoom higuerawaañe, jnda̱ ndyee chu na mandyo̱o̱calꞌua̱ ta̱a̱ꞌnaꞌ ndoꞌ tjaa ljoꞌ coljeiya. Cwa cꞌuaꞌ juunaꞌ ee cweꞌ tsꞌiaaⁿꞌ matseityeeⁿñenaꞌ nomtyuaa.” ");
INSERT INTO amuNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Sa̱a̱ tꞌo̱ tsaⁿꞌñeeⁿ nnoom, tso: “Ta, caꞌndiiꞌyaꞌ juunaꞌ meiiⁿ cweꞌ chuwaa hasta na jnda̱ ꞌña̱a̱ⁿ ndiocheⁿ xꞌeenaꞌ ndoꞌ nntio̱o̱ⁿ tsꞌo toꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Xeⁿ nntsꞌaanaꞌ ta̱, ya. Ndoꞌ xeⁿ tjaaꞌnaⁿ, quia ljoꞌcheⁿ cꞌuaꞌ juunaꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Cwii xuee na cwitaꞌjndyee nnꞌaⁿ tyoꞌmo̱ⁿ Jesús naquiiꞌ watsꞌom chjoo. ");
INSERT INTO amuNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Joꞌ joꞌ tyomꞌaaⁿ cwii yuscu na jnda̱ quinꞌoom nchooꞌ ndyee chu na teiꞌcaljoo jndyewꞌii naxeⁿꞌ. Jeeⁿ ntyjo̱ tyojaacaⁿ ndoꞌ meiⁿchjoo tileicwintyjeeⁿꞌeⁿ nayuu. ");
INSERT INTO amuNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Quia na ntyꞌiaaꞌ Jesús tsaⁿꞌñeeⁿ, tꞌmaaⁿ juu, tsoom nnom: —ꞌU nomxjo̱o̱, jeꞌ jnda̱ jndyaandyuꞌ tycu na wiꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Quia joꞌ tioom lꞌo̱o̱ⁿ nacjooꞌ, mantyja jliuu naxeⁿꞌ. Ndoꞌ tyotseitꞌmaaⁿꞌñe Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Sa̱a̱ juu tsꞌaⁿ na cwiluiitquieñe watsꞌomꞌñeeⁿ, seiwꞌeeⁿ na seinꞌmaⁿ Jesús tsaⁿꞌñeeⁿ xuee na cwitaꞌjndyeena. Tsoom nda̱a̱ nnꞌaⁿ: —Yom xuee wanaaⁿ na calꞌaꞌyoꞌ tsꞌiaaⁿ. Joo ncueemeiⁿꞌ quioꞌyoꞌ na nnꞌmaaⁿꞌyoꞌ, nchii xuee na cwitaꞌjndya̱a̱ya. ");
INSERT INTO amuNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ndoꞌ tꞌo̱ Jesús nnom, tsoom: —ꞌO nnꞌaⁿ na cweꞌ cwilꞌaꞌyoꞌ na ndooꞌ na jeeⁿ cwilacanda̱a̱ꞌndyoꞌ, ¿aa meiⁿcwindyoꞌ ꞌo tiquilaꞌcanaⁿꞌyoꞌ quiooꞌjndyo oo snom njmeiⁿꞌyoꞌ yuu na macwaꞌyoꞌ ndoꞌ na nntsaalaꞌcꞌuꞌyoꞌ ndaa juuyoꞌ xuee na cwitaꞌjndya̱a̱ya? ");
INSERT INTO amuNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ee yuscumꞌaaⁿꞌ, na cwiluiiñe tsjaaⁿ ꞌnaaⁿꞌ Abraham na jnda̱ quinꞌoom nchooꞌ ndyee chu na macoꞌwiꞌ Satanás jom, ¿aa ticatyꞌiomnaꞌ na nndyaañê nawiiꞌwaaꞌ xuee na cwitaꞌjndya̱a̱ya? ");
INSERT INTO amuNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yocheⁿ na matseineiiⁿ ñꞌoommeiⁿꞌ, tioo na jeeⁿ jnaaⁿ chaꞌtso nnꞌaⁿ na jndoo jom. Sa̱a̱ nnꞌaⁿ na jndyendye, sꞌaanaꞌ na jeeⁿ neiiⁿna ncꞌe chaꞌtso tsꞌiaaⁿ na cajnda na tyochꞌeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jnda̱ chii tsotyeeⁿcheⁿ nda̱a̱na: —Juu na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom, ¿ljoꞌ ñꞌeⁿ matseijomnaꞌ cantyja ꞌnaaⁿꞌnaꞌ? ");
INSERT INTO amuNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Juunaꞌ matseijomnaꞌ chaꞌna lqueeⁿꞌ tsꞌoom mostaza na jeeⁿ cajnda̱a̱. Seicꞌoom tsꞌaⁿ juunaꞌ naquiiꞌ ntjoomꞌm. Tyuaaꞌ tjawijndeiinaꞌ, tueꞌntyjo̱ na teitꞌmaⁿnaꞌ hasta tyolꞌa cantsaa cantquiaayoꞌ naquiiꞌ lꞌo̱naꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ndoꞌ tsonnaaⁿꞌaⁿ nda̱a̱na: —¿Ljoꞌ cwiicheⁿ na nntseijo̱o̱ⁿꞌa juu na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom? ");
INSERT INTO amuNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Juunaꞌ matseijomnaꞌ chaꞌna ndaaljoꞌ na tjaaꞌñe cwii yuscu naquiiꞌ ndyee tsuaꞌ xjeⁿ jnda̱a̱ tyooꞌ. Ndoꞌ seicandeiiꞌnaꞌ chaꞌwaa tsqueeⁿ tyooꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Quia joꞌ tjawinom Jesús njoom ntꞌmaⁿ ndoꞌ njoom nchꞌu na tyoꞌmo̱o̱ⁿ nda̱a̱ nnꞌaⁿ yocheⁿ na tyocanjoom nato na wjaⁿ Jerusalén. ");
INSERT INTO amuNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Cwii tsꞌaⁿ taxꞌee nnoom, tso: —Ta, ¿aa tijndye nnꞌaⁿ na nluiꞌnꞌmaaⁿndye? ");
INSERT INTO amuNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Tꞌo̱o̱ⁿ, matsoom nda̱a̱na: —ꞌNdyootsꞌa cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom, cantuunaꞌ. Calajnda̱ꞌyoꞌ na ntsaaquieꞌyoꞌ juunaꞌ. Ee jndye nnꞌaⁿ na ñeꞌcꞌooquieꞌ joꞌ joꞌ, sa̱a̱ xocanda̱a̱ nlꞌana. ");
INSERT INTO amuNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Ee quia na jnda̱ teicantyja nquii tsꞌaⁿ na waaꞌ wꞌaaꞌñeeⁿ na nntseicuꞌtyeeⁿ ꞌndyootsꞌa, quia joꞌ ꞌo na mꞌaⁿꞌyoꞌ chꞌeⁿ nnto̱ꞌyoꞌ na ncwaⁿꞌyoꞌ. Nnduꞌyoꞌ: “Ta, catseicanaaⁿndyuꞌ na ntsaquia̱a̱ꞌâ.” Sa̱a̱ jom nncꞌo̱o̱ⁿ nndyueꞌyoꞌ, nntsoom: “Ticaljeii yuu nnꞌaⁿ ꞌo.” ");
INSERT INTO amuNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Quia joꞌ nnto̱ꞌyoꞌ na nnduꞌyoꞌ nnoom: “Jâ tsuu, tyocwaaꞌâ ñꞌeⁿndyuꞌ ndoꞌ tyoꞌmo̱o̱ⁿꞌ nda̱a̱yâ xcwe naquiiꞌ tsjoomyâ.” ");
INSERT INTO amuNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Sa̱a̱ jom nncꞌo̱o̱ⁿ, nntsoom: “Jnda̱ tsjo̱o̱ nda̱a̱ꞌyoꞌ na ticaljeii yuu nnꞌaⁿ ꞌo. Quindyo̱ꞌyoꞌ ñjaaⁿ, ꞌo nnꞌaⁿ na cwilꞌaꞌyoꞌ natia.” ");
INSERT INTO amuNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Joꞌ joꞌ nncꞌomꞌyoꞌ na nlaxuaꞌyoꞌ na matseiꞌndaaꞌnaꞌ nquiuꞌyoꞌ ndoꞌ nnteiⁿnquieꞌyoꞌ ndeiꞌnꞌomꞌyoꞌ na maquiinaꞌ ꞌo. Ee nntyꞌiaꞌyoꞌ Abraham, Isaac, Jacob ndoꞌ ñꞌeeⁿ chaꞌtso profetas, na mꞌaⁿna yuu na matsa̱ꞌntjoom, sa̱a̱ ꞌo jnda̱ ꞌndiinaꞌ chꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Quia ljoꞌ nlquie nnꞌaⁿ na nnaⁿ ndiocheⁿ tsjoomnancue. Ñequio na neiiⁿ naⁿꞌñeeⁿ nncwindyuaandyena nacañoomꞌ meiⁿsa yuu na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom na nlcwaꞌna. ");
INSERT INTO amuNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Queⁿꞌyoꞌ cwenta, mꞌaⁿ nnꞌaⁿ jeꞌ na cwilatiuuꞌyoꞌ na majuꞌcjenaꞌ joona. Sa̱a̱ nda̱nquia nntseiwendyenaꞌ joona. Ndoꞌ mꞌaⁿ nnꞌaⁿ jeꞌ na cwilaꞌtiuu nquiee na tꞌmaⁿ cwiluiindye, sa̱a̱ nncueꞌntyjo̱ na nncjuꞌcjenaꞌ joona. ");
INSERT INTO amuNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Majuuti xueeꞌñeeⁿ, tquieꞌcañom ntꞌom nnꞌaⁿ fariseos Jesús, jluena nnoom: —Caluiꞌ ñjaaⁿ, cjaꞌ cwiicheⁿ joo ee ñeꞌcatseicueeꞌ Herodes ꞌu. ");
INSERT INTO amuNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Tsoom nda̱a̱na: —Catsaꞌyoꞌ, canduꞌyoꞌ nnom cajndyeꞌñeeⁿ: “Queⁿꞌ cwenta, ja manncwjiiꞌtya̱ya naⁿjndii naquiiꞌ nꞌom nnꞌaⁿ. Ndoꞌ nntseinꞌmaⁿtya̱ya nnꞌaⁿwii ꞌio cha luaaꞌ. Ndoꞌ tajndye cwii tjo̱o̱ na nntseicanda̱a̱ꞌndyo̱ tsꞌiaaⁿ na jndyo̱o̱ya.” ");
INSERT INTO amuNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Sa̱a̱ jndeiꞌnaꞌ na jeꞌ, ꞌio ndoꞌ cha jo̱jo̱tya̱ cantyja ꞌnaaⁿꞌ tsꞌiaaⁿ na matsꞌaaya, ee ticatsonaꞌ na nchii Jerusalén na nncueꞌ cwii profeta. ");
INSERT INTO amuNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","’ꞌO nnꞌaⁿ Jerusalén na cwilacwjeꞌyoꞌ profetas ndoꞌ majñoomꞌ ljo̱ꞌ nnꞌaⁿ na majño̱o̱ⁿya na mꞌaaⁿꞌ. Jndye ndiiꞌ ñentyjaaꞌ tsꞌo̱o̱ⁿ na nntseitjo̱ⁿya ntseindaꞌ chaꞌxjeⁿ matseitjom caxtixquie ntseinaaⁿ nacjeeꞌ ntsqueeⁿ. Sa̱a̱ ꞌu cwaaⁿ tquiaandyuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Queⁿꞌyoꞌ cwenta, Tyꞌo̱o̱tsꞌom maꞌñeeⁿ ꞌo. Taxocꞌoom watsꞌom tꞌmaⁿ ꞌnaⁿꞌyoꞌ. Quia joꞌ seineiiⁿ nda̱a̱ nnꞌaⁿ, tsoom: —Nndyeꞌyoꞌ nntsjo̱o̱ na taxocantyꞌiaꞌyoꞌ ja hasta na nncueꞌntyjo̱ xuee na nnduꞌyoꞌ: “Matioꞌnaaⁿñenaꞌ nqueⁿ na mañoom ñequio xueeꞌ Ta Tyꞌo̱o̱tsꞌom.” ");
INSERT INTO amuNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Cwii xuee na cwitaꞌjndyee nnꞌaⁿ, tjatseijomñe Jesús waaꞌ tsꞌaⁿ na cwiluiitquieñe cantyja ꞌnaaⁿ nnꞌaⁿ fariseos, na nlcwaaⁿꞌaⁿ joꞌ joꞌ. Ndoꞌ ñꞌeeⁿ nnꞌaⁿ fariseos na tyoqueⁿ cwenta ljoꞌ nntsꞌaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Joꞌ joꞌ tjameintyjeeꞌ cwii tsꞌaⁿ na wiiꞌ jo nnoom na ndiiꞌ tcooꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ndoꞌ taxꞌeeⁿ nda̱a̱ nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés ñequio nnꞌaⁿ fariseos, tsoom: —¿Aa matyꞌiomyanaꞌ na nntseinꞌmaⁿ tsꞌaⁿ tsaⁿwiiꞌ xuee na cwitaꞌjndyee nnꞌaⁿ, oo aa ticatyꞌiomnaꞌ? ");
INSERT INTO amuNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Sa̱a̱ joona yacheⁿ jlaꞌcheⁿna. Quia joꞌ toꞌñoom tsꞌaⁿwiiꞌ, seinꞌmaaⁿ juu ndoꞌ tsoom nnom: —Ya xeⁿ na wjaꞌtoꞌ waꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jnda̱ joꞌ tsoom nda̱a̱ fariseosꞌñeeⁿ: —¿Aa mꞌaaⁿ cwiindyoꞌ ꞌo na xocatseicjeeñe na nncwjiꞌ snom oo quioꞌjndyo tsmeiⁿꞌ na tjuꞌnaꞌ tsꞌom tsueꞌtsjoom, meiiⁿ na juu xuee na cwitaꞌjndyee nnꞌaⁿ? ");
INSERT INTO amuNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Sa̱a̱ ticatꞌo̱o̱na ꞌñom. ");
INSERT INTO amuNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ndoꞌ naⁿꞌñeeⁿ na tqueeⁿꞌ tsꞌaⁿ fariseo na nlcwaꞌ ñꞌeⁿñê, tqueⁿ Jesús cwenta ljoꞌ lꞌana. Jlaꞌyuu nda̱a̱na ntsula̱ nacañoomꞌticheⁿ nacañoomꞌ meiⁿsa. Joꞌ chii seineiiⁿ ñꞌoom tjañoomꞌ nda̱a̱na. ");
INSERT INTO amuNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Tsoom: —Quia na maqueeⁿꞌ tsꞌaⁿ ꞌu na catseijomndyuꞌ na macoco jnaaⁿ, tincjaꞌcajmaⁿꞌ sula̱ nacañoomꞌticheⁿ. Ee xeⁿ nntseijomnaꞌ tqueeⁿꞌñê cwiicheⁿ tsꞌaⁿ na tꞌmaⁿti cwiluiiñe, nchiiti ꞌu, ");
INSERT INTO amuNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","quia joꞌ jom na tqueeⁿꞌñê ꞌo, nncjaantyjaaⁿꞌaⁿ ꞌu, nntsoom njomꞌ: “ꞌU quiaaꞌ na tsaⁿmꞌaaⁿ nncjom yuu na wacatyeⁿꞌ.” Quia joꞌ nluiꞌjnaaⁿꞌndyuꞌ na nncjaꞌcajmaⁿꞌ sula̱ na macanda̱. ");
INSERT INTO amuNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Joꞌ chii, quia na maqueeⁿꞌñe tsꞌaⁿ ꞌu, cjaꞌcajmaⁿꞌ sula̱ na weꞌyandyo, cha quia na nncjaantyjaaꞌ tsꞌaⁿ na tqueeⁿꞌñe ꞌu, nntsoom njomꞌ: “ꞌU xꞌiaya, cwinoomꞌ nacañoomcheⁿ.” Quia joꞌ nntseitꞌmaaⁿꞌñenaꞌ ꞌu jo nda̱a̱ chaꞌtso nnꞌaⁿ na meindyuaandye nacañoomꞌ meiⁿsa ñꞌeⁿndyuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ee meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na matseiwendyeñe cheⁿnquii, maxjeⁿ nntseiquioo Tyꞌo̱o̱tsꞌom juu. Ndoꞌ meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na majuꞌñecje, maxjeⁿ nntseiwendye Tyꞌo̱o̱tsꞌom tsaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Mati tso Jesús nnom tsꞌaⁿ na tqueeⁿꞌñe jom: —Quia na maqueⁿꞌ nnꞌaⁿ na calaꞌjomndye na nlcwaꞌyoꞌ na quiajmeiⁿꞌ oo natmaaⁿ, tilqueⁿꞌ ncꞌiaꞌ, meiⁿ nnꞌaⁿꞌ nncuꞌ, meiⁿ nnꞌaⁿꞌ na jnda̱ teitquio̱o̱ꞌ, meiⁿ naⁿtya na mꞌaⁿ nndyooꞌ. ¿Ee aa nchii nncueeꞌ xuee na majoꞌti nlꞌa joona, cha nnjoom chaꞌxjeⁿ na saꞌ ꞌu? ");
INSERT INTO amuNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Joꞌ chii quia na nntsaꞌ nantquie na tꞌmaⁿ na nlcwaꞌ nnꞌaⁿ, queⁿꞌ ndyeñeeⁿꞌ ñꞌeⁿ nnꞌaⁿ na ticanda̱a̱ꞌ luee, ncꞌeeꞌ, ndoꞌ nnꞌaⁿ na tileicꞌoocaꞌ ñequio nnꞌaⁿ na nchjaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Quia joꞌ nncꞌoomꞌ na neiⁿꞌ na luaaꞌ nntsaꞌ. Ee joona xocanda̱a̱ nlꞌana na nnjoom ljoꞌ na saꞌ, sa̱a̱ ꞌu nncoꞌñomꞌ na nnjoom quia na nntaꞌndoꞌnndaꞌ nnꞌaⁿ na ñelꞌa yuu na matyꞌiomyanaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Cwii tsꞌaⁿ na ñꞌeⁿ meindyuaandyena nacañoomꞌ meiⁿsa, quia na jndii na luaaꞌ, tso nnom Jesús: —Nñequiaanaꞌ na neiiⁿꞌ tsꞌaⁿ na nntseijomñe nantquie tꞌmaⁿ yuu na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Tꞌo̱ Jesús cwii ñꞌoom na tjañoomꞌ. Maꞌmo̱ⁿnaꞌ na nchii chaꞌtsondye nnꞌaⁿ nncꞌooquieeꞌndye yuu na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. Tsoom: —Tyomꞌaaⁿ cwii tsꞌaⁿ, jom jnoomꞌm cwii nantquie tꞌmaⁿ ndoꞌ tqueeⁿꞌñê jndye nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Quia na tueeꞌntyjo̱ xjeⁿ na nlcwaꞌna natmaaⁿ jñoom mosoomꞌm na cjaacatso nda̱a̱ nnꞌaⁿ na maqueeⁿꞌñê: “Aa ndyeꞌyoꞌ, cjaaya, ee chaꞌtso jnda̱ maya waa.” ");
INSERT INTO amuNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Sa̱a̱ chaꞌtsondye naⁿꞌñeeⁿ cwii cwii nnom jlaꞌcajñoomꞌndyena. Tsaⁿ najndyee tso: “Catsaꞌ cwii nayaꞌñeeⁿ na catsuꞌ nnom patrom ꞌnaⁿꞌ na catseitꞌmaⁿ tsꞌoom ja, ee jnda̱ seijndaya cwii taⁿꞌ tyuaa ndoꞌ macaⁿnaꞌ na cjo̱cando̱o̱ꞌa juunaꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ndoꞌ tso cwiicheⁿ tsꞌaⁿ nnom moso: “Ja jnda̱ seijndaya ꞌom ljo quiooꞌndyo na nlꞌa tsꞌiaaⁿ ndoꞌ jeꞌ jo̱cantyꞌia aa ndyaaꞌ ya nlꞌayoꞌ. Joꞌ chii catsaꞌ cwii nayaꞌñeeⁿ na catsuꞌ nnoom na catseitꞌmaⁿ tsꞌoom ja.” ");
INSERT INTO amuNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ndoꞌ cwiicheⁿ tso: “Cweꞌ xcondyo na tmaⁿꞌco̱, joꞌ na xocanda̱a̱ nncjo̱.” ");
INSERT INTO amuNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Tjalcweꞌ moso tjatseicañeeⁿ patrom ꞌnaaⁿꞌaⁿ chaꞌtso ñꞌoommeiⁿꞌ. Ndoꞌ seiliooꞌñe patrom. Tsoom nnom mosoomꞌm: “Catseityuaꞌ, cjaꞌ jo tsꞌua ndoꞌ nꞌom nantaa naquiiꞌ tsjoom ndoꞌ candyoꞌchuꞌ ndyeñeeⁿꞌ ñequio nnꞌaⁿ na ticanda̱a̱ꞌ luee, ncꞌeeꞌ, nnꞌaⁿ na ntjeiⁿ ncꞌeeꞌ ñequio nnꞌaⁿ na nchjaaⁿ.” ");
INSERT INTO amuNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Jnda̱ chii seicandii mosoꞌñeeⁿ, tsoom: “Ta, jnda̱ tuii chaꞌxjeⁿ na sa̱ꞌntjomꞌ sa̱a̱ ndicwaⁿ wanaaⁿti.” ");
INSERT INTO amuNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Quia joꞌ tso patrom nnoom: “Cjaꞌ jo nꞌom nato ntꞌmaⁿ ñequio chaꞌtso nato cajneiⁿ. Catsaꞌ na jndeiꞌnaꞌ na nñequio nnꞌaⁿ cha na nntooꞌ wꞌaya. ");
INSERT INTO amuNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Jeꞌ nndyeꞌyoꞌ nntsjo̱o̱ na meiⁿcwiindye nnꞌaⁿ na tqua̱a̱ⁿꞌndyo̱jndya̱a̱ xocaljeii chiuu waa nantquie tꞌmaⁿ na mando̱o̱ꞌa.” ");
INSERT INTO amuNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Tꞌmaⁿ tmaaⁿꞌ nnꞌaⁿ tyꞌe ñꞌeⁿ Jesús. Quia joꞌ taqueeⁿ, tsoom nda̱a̱na: ");
INSERT INTO amuNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na nndyo ñꞌeⁿndyo̱ xeⁿ ticꞌoom na jndati ntyjeeⁿ ñꞌeⁿndyo̱, nchiiti tsotyeeⁿ, tsoñeeⁿ, scoomꞌm, ntseinaaⁿ, tiꞌnquioom ñequio ndyencjoom, hasta cantyja na wandoꞌ nqueⁿ, tsaⁿꞌñeeⁿ xocanda̱a̱ nntseijomñê ñꞌeⁿndyo̱. ");
INSERT INTO amuNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ndoꞌ meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na nndyontyjo̱ cantyja na matsꞌaa, xeⁿ ticꞌoom na cwiljoya tsꞌoom nawiꞌ na matjoom cantyja ꞌnaⁿya meiiⁿ cueeⁿꞌeⁿ, tsaⁿꞌñeeⁿ xocanda̱a̱ nntseijomñê ñꞌeⁿndyo̱. ");
INSERT INTO amuNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Xeⁿ cwiindyoꞌ ꞌo ñeꞌcatsꞌaa wꞌaandye, ¿aa nchii nncjaacjoojndyee, nntseitiuuya chiuuxjeⁿ nlcaⁿnaꞌ cha ntyjii aa nleijndeii cwanti na maleiñꞌoom hasta na nnda̱a̱ꞌ wꞌaaꞌñeeⁿ? ");
INSERT INTO amuNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Xeⁿ ticatsꞌaaⁿ na ljoꞌ, jnda̱ sꞌaaⁿ tsiaⁿtsjo̱ꞌ ndoꞌ nljeiiⁿ na taticatquii nntsꞌaaⁿ, quia joꞌ chaꞌtso nnꞌaⁿ na nntyꞌiaa na ljoꞌ, nnto̱ꞌna na nlaꞌjnaaⁿꞌna jom. ");
INSERT INTO amuNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Nluena: “Tsaⁿmꞌaaⁿꞌ to̱o̱ⁿꞌo̱ⁿ cwii tsꞌiaaⁿ sa̱a̱ cweꞌ tsꞌiaaⁿ taⁿꞌ. Tîtseicanda̱a̱ꞌñê.” ");
INSERT INTO amuNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Mati cwii rey na tseixmaⁿ qui meiⁿ sondaro, ¿aa ntsꞌaacheⁿnaꞌ na nncjaacatjomñê cwiicheⁿ rey na nndyocatsꞌaa tiaꞌ nacjoomꞌm na matseixmaⁿ ntquiuu meiⁿ sondaro? ¿Aa chii nncjaacjoojñeeⁿ na nntseitiuuyaaⁿ, aa nnda̱a̱ nntsꞌaaⁿ? ");
INSERT INTO amuNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ndoꞌ xeⁿ nntyꞌiaaⁿꞌaⁿ na tixocanda̱a̱ nntsꞌaaⁿ, quia joꞌ nntseicwanoom ñꞌoom ñequio tsꞌaⁿ ꞌnaaⁿꞌaⁿ na nntseityꞌooñê na cwitsaaⁿꞌ tiaꞌ, cwii na ndicwaⁿ tquia ndyo tsaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Joꞌ chii meiⁿcwiꞌñeeⁿcheⁿ ꞌo na ticaꞌndii chaꞌtso na matseixmaⁿ nquii, xocanda̱a̱ nntseijomñê ñꞌeⁿndyo̱. ");
INSERT INTO amuNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","’Jeeⁿ lꞌue tsjaaⁿꞌ, sa̱a̱ xeⁿ nluiꞌ na chjeⁿꞌnaꞌ, ¿ljoꞌ ñꞌeⁿ cwii nleichjeⁿꞌnndaꞌnaꞌ? ");
INSERT INTO amuNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Taxocwilꞌuenaꞌ, meiⁿ quio tyuaa, meiⁿ ñꞌeⁿ toꞌ. Cweꞌ quiityeⁿꞌquieeꞌ nnꞌaⁿ joonaꞌ. Maluaaꞌ matseijomnaꞌ ꞌo, mꞌaⁿꞌyoꞌ chaꞌcwijom tsjaaⁿꞌ na tilꞌue xeⁿ tyooteiꞌjndeiꞌyoꞌ ntꞌomcheⁿ nnꞌaⁿ. ꞌÑeeⁿ juu na niom lueꞌ nꞌom luaꞌqui na nndii, candiiya. ");
INSERT INTO amuNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Chaꞌtsondye nnꞌaⁿ na cwitoꞌñoom sꞌom cwentaaꞌ gobiernom Roma ñequio nnꞌaⁿ na cwilaꞌtjo̱o̱ndye nnom Tyꞌo̱o̱tsꞌom cantyja na nquiu nnꞌaⁿ fariseos, jlaꞌcandyooꞌndyena namꞌaaⁿ Jesús na nndyena ñꞌoom na nntseineiiⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Nnꞌaⁿ fariseos ñequio nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés tyotioꞌñꞌoomna jom. Jluena: —Tsaⁿmꞌaaⁿꞌ ya ñꞌoom jom ñꞌeⁿ nnꞌaⁿ na cwilaꞌtjo̱o̱ndye nnom Tyꞌo̱o̱tsꞌom ndoꞌ macwaaⁿꞌaⁿ ñꞌeⁿndyena. ");
INSERT INTO amuNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Quia joꞌ seineiiⁿ ñꞌoom na tjañoomꞌ nda̱a̱na, tsoom: ");
INSERT INTO amuNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Xeⁿ cwiindyoꞌ ꞌo mꞌaaⁿ cwii siaⁿnto canmaⁿ ntsmeiⁿꞌ ndoꞌ xeⁿ nntsuuñe cwii jooyoꞌ, ¿aa nchii nꞌndiiyaaⁿ ñequieenꞌaaⁿ nchooꞌ qui nchooꞌ ñjeeⁿ quiooꞌñeeⁿ yuu na cwicwaꞌyoꞌ ndoꞌ nncjaacalꞌueeⁿ juu catsmaⁿ na tsuuñe hasta xjeⁿ na nljeiiⁿcheⁿ? ");
INSERT INTO amuNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Xeⁿ jnda̱ ljeiiⁿ catsmaⁿꞌñeeⁿ, nleiꞌcaljoom juuyoꞌ xtyoomꞌm ñequio na neiiⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ndoꞌ quia na nncueⁿꞌeⁿ waⁿꞌaⁿ, nntseitjoom ncꞌiaaⁿꞌaⁿ ñequio nnꞌaⁿ na mꞌaⁿ nndyooꞌ waⁿꞌaⁿ. Nntsoom nda̱a̱na: “Cꞌo̱o̱ⁿya na neiiⁿya, ee catsmaⁿ tsma̱a̱ⁿꞌa na tsuuñe jnda̱ ljeinndaꞌa juuyoꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Luaa nntsjo̱o̱ nndyeꞌyoꞌ, maluaaꞌ na tꞌmaⁿti neiiⁿꞌ Tyꞌo̱o̱tsꞌom na mꞌaaⁿ cañoomꞌluee cantyja ꞌnaaⁿꞌ cwii tsꞌaⁿjnaⁿ na cwilcweꞌ tsꞌom, nchiiti ñequieenꞌaaⁿ nchooꞌ nqui nchooꞌ ñjeeⁿ tsꞌaⁿ na mamachꞌee yuu na matyꞌiomyanaꞌ na ticaⁿnaꞌ na nlcweꞌ tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","’Oo calꞌuu na mꞌaaⁿ cwii yuscu na maleiñꞌoom qui xjeⁿ sꞌom xuee, ndoꞌ xeⁿ nntsuuñê cwii joonaꞌ naquiiꞌ wꞌaa, ¿aa nchii nntseicanaaⁿñê chom, ndoꞌ ya ya nlcaañe, tcuutcuu nlꞌueeⁿ juunaꞌ hasta xjeⁿ na nljeiiⁿcheⁿ? ");
INSERT INTO amuNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ndoꞌ xeⁿ jnda̱ ljeiiⁿ, nntseitjoom ncꞌiaaⁿꞌaⁿ ñequio nnꞌaⁿ na mꞌaⁿ nndyooꞌ waⁿꞌaⁿ ndoꞌ nntsoom nda̱a̱na: “Cꞌo̱o̱ⁿya na neiiⁿya, ee jnda̱ ljeiya tsjo̱ꞌñjeeⁿ na tsuu.” ");
INSERT INTO amuNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Luaa nntsjo̱o̱ nndyeꞌyoꞌ, maluaaꞌ jeeⁿ cwilaꞌneiiⁿꞌndye ángeles cwentaaꞌ Tyꞌo̱o̱tsꞌom cantyja ꞌnaaⁿꞌ cwii tsꞌaⁿjnaⁿ na cwilcweꞌ tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Seineiⁿticheⁿ Jesús, tsoom: —Tyomꞌaaⁿ cwii tsꞌaⁿ, tyomꞌaⁿ we ntseinaaⁿ na naⁿnom. ");
INSERT INTO amuNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Juu tsaⁿchee tsoom nnom tsotyeeⁿ: “Ta, quiaaꞌ ꞌnaⁿꞌ na tseixmaⁿya na nncoꞌño̱ⁿ.” Quia joꞌ to̱ⁿꞌ tsotyeeⁿ ꞌnaⁿ na niom, tquiaa nnoom. ");
INSERT INTO amuNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Tyoowijndye xuee na tuii na ljoꞌ, seitjoom chaꞌtso ꞌnaaⁿꞌaⁿ, tjaaⁿ tquia cwiicheⁿ ndyuaa. Joꞌ joꞌ seico̱o̱ⁿ chaꞌtso ꞌnaaⁿꞌaⁿ cweꞌ luaaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Jnda̱ na ndyueñꞌeⁿ seicatsoom, seijomnaꞌ jndyo cwii jndoꞌ tꞌmaⁿ tyuaaꞌñeeⁿ. Jnaⁿnaꞌ na tcoꞌwiꞌnaꞌ jom na tjaaꞌnaⁿ ljoꞌ cwii ya nleilꞌueeꞌñê. ");
INSERT INTO amuNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Quia joꞌ tjaaⁿ, tjaquieeꞌtoom na nntsꞌaaⁿ tsꞌiaaⁿ moso ꞌnaaⁿꞌ cwii tsꞌaⁿ ndyuaaꞌñeeⁿ. Jñom tsaⁿꞌñeeⁿ jom na nnteixꞌeeⁿ calcu jo jnda̱a̱. ");
INSERT INTO amuNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Jeeⁿ ñeꞌcwaaⁿꞌaⁿ meiiⁿ cweꞌ nlcwa jnda̱a̱ na cwicwaꞌ calcu. Sa̱a̱ meiⁿcwii tjaa ꞌñeeⁿ tquiaa ljoꞌ nlcwaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Quia joꞌ tjañjoomꞌ tsꞌoom, seitioom: “Jndye moso mꞌaⁿ waaꞌ tsotya̱, hasta maꞌndiinaꞌ nantquie na cwicwaꞌna. Ndoꞌ ja ñjaaⁿ mꞌaaⁿya, mañeꞌcꞌio̱ya na ñeꞌjndo̱ꞌa. ");
INSERT INTO amuNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Jeꞌ yuuꞌ nluiiꞌa ljoo, nncjo̱lcwa̱ꞌnndaꞌa mꞌaaⁿ tsotya̱ya, ndoꞌ nntsjo̱o̱ nnoom: Ta, jnda̱ seitjo̱o̱ndyo̱ nnom Tyꞌo̱o̱tsꞌom ndoꞌ njomꞌ ꞌu. ");
INSERT INTO amuNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Tacatseixmaⁿya na nntsuꞌ na jndaꞌ ja. Catsaꞌ cweꞌ chaꞌna cwii mosoꞌ ja.” ");
INSERT INTO amuNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Quia joꞌ mana tjalcweeⁿꞌeⁿ na mꞌaaⁿ tsotyeeⁿ. ’Tquia ndicwaⁿ wjaanoom, ljeii tsotyeeⁿ jom. Tioo na jeeⁿ jnda ntyjii ñꞌeⁿñê. Jleinom, tjacatjomñe jom. Taxcweeñe ndoꞌ tꞌuu ntsmaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Quia joꞌ tso jnaaⁿ nnoom: “Ta, jnda̱ seitjo̱o̱ndyo̱ nnom Tyꞌo̱o̱tsꞌom ndoꞌ njomꞌ ꞌu. Tacatseixmaⁿya na nntsuꞌ na jndaꞌ ja.” ");
INSERT INTO amuNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Jnda̱ tquiena na waa wꞌaa, tso tsotyeeⁿ nda̱a̱ mosooꞌ: “Cwa queⁿndyoꞌ quiaꞌyoꞌ liaa na yati, ndoꞌ calaꞌcweꞌyoꞌ joonaꞌ jom. Ndoꞌ catjaaꞌndyoꞌ tseiꞌxꞌii tsꞌo̱o̱ⁿ calaꞌñjomꞌyoꞌ lcoom jom. ");
INSERT INTO amuNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ndoꞌ mati tsaacꞌomꞌyoꞌ quiooꞌjndyo chjoo na tꞌmeiiⁿñe. Calaꞌcueꞌyoꞌ juuyoꞌ. Nlcwaaꞌa ndoꞌ nlꞌaaya xuee. ");
INSERT INTO amuNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ee tiꞌjndaaya luaa, chaꞌcwijom jnda̱ tueeⁿꞌeⁿ ndoꞌ wandoꞌnnaaⁿꞌaⁿ, tsuuñê ndoꞌ teijndaaꞌñennaaⁿꞌaⁿ.” Quia joꞌ to̱ꞌna na tyolaꞌtꞌmaaⁿꞌndyena. ");
INSERT INTO amuNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","’Sa̱a̱ jnaaⁿ tsaⁿtquiee, ticꞌoomñe, jnda̱a̱ tja. Quia na jnda̱ tyjeeꞌ ndyowindyooꞌ na waa wꞌaana, jndii na cwitjo̱ꞌ ndoꞌ camꞌaaⁿ jnoom. ");
INSERT INTO amuNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Tcwaaⁿ cwii mosoona, taxꞌeeⁿ ꞌndyoo ljoꞌ cwiluii. ");
INSERT INTO amuNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Tꞌo̱ tsaⁿꞌñeeⁿ nnoom: “Tiꞌtyꞌiuꞌ jnda̱ tyjeeⁿꞌeⁿ joꞌ na seicueeꞌ tsotyeꞌ quiooꞌjndyo chjoo na tꞌmeiiⁿñe ee ya tyjeeⁿꞌeⁿ, tiweeⁿꞌeⁿ.” ");
INSERT INTO amuNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Sa̱a̱ tsaⁿꞌñeeⁿ seiwꞌeeⁿ, meiⁿ quiiꞌ wꞌaa tiꞌcjaaqueⁿꞌeⁿ. Joꞌ chii jluiꞌ tsotyeeⁿ ndoꞌ sꞌaa tyꞌoo nnoom na cjaaqueⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Sa̱a̱ jom tꞌo̱o̱ⁿ nnom tsotyeeⁿ, tsoom: “Queⁿꞌ cwenta, teijndye ndyu mandiꞌntjo̱ⁿya njomꞌ meiⁿ tyootseiquieꞌ tsꞌo̱o̱ⁿya yuu na matsa̱ꞌntjomꞌ ja. Sa̱a̱ meiⁿcwii ndiiꞌ tyooñequiaaꞌ meiiⁿ cweꞌ canchꞌioo ndyua na nntseicua̱ꞌa na nncꞌo̱o̱ⁿya na neiⁿya ñequio ncꞌiaya. ");
INSERT INTO amuNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Sa̱a̱ jeꞌ na tyjeeꞌ tiꞌjndaꞌ luaaꞌ na tjatseico̱o̱ⁿ ꞌnaⁿꞌ ñequio lculjaaꞌ, jndaꞌjom quioꞌjndyo chjoo na tꞌmeiiⁿñe jnda̱ seicueꞌ cwentaaⁿꞌaⁿ.” ");
INSERT INTO amuNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ndoꞌ tꞌo̱ tsotyeeⁿ nnoom, tso: “ꞌU jndaaya, maxjeⁿ mꞌaaⁿꞌ ñꞌeⁿndyo̱ ndoꞌ chaꞌtso ꞌnaⁿya ꞌu ꞌnaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Sa̱a̱ matyꞌiomnaꞌ na calꞌaaya xuee ndoꞌ cꞌo̱o̱ⁿya na neiiⁿya ee tiꞌtyꞌiuꞌ luaaꞌ chaꞌcwijom jnda̱ tueeⁿꞌeⁿ ndoꞌ wandoꞌnnaaⁿꞌaⁿ, jnda̱ tsuuñê sa̱a̱ teijndaaꞌñennaaⁿꞌaⁿ.” ");
INSERT INTO amuNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Mati seineiⁿ Jesús nda̱a̱ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê, tsoom: —Tyomꞌaaⁿ cwii tsaⁿtya ndoꞌ tꞌoom cwii mosotquiee ꞌnaaⁿꞌaⁿ. Jlaꞌcandii nnꞌaⁿ jom na cweꞌ matseicatsuuto tsaⁿꞌñeeⁿ ꞌnaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Quia joꞌ tqueeⁿꞌñê juu, tsoom nnom: “¿Chiuu waayuu ñꞌoom na mandii cantyja ꞌnaⁿꞌ? Quiaaꞌ cwenta tsꞌiaaⁿ na macheꞌ ee maꞌndiinaꞌ ꞌu na mꞌaaⁿꞌ mosotquiee.” ");
INSERT INTO amuNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Quia joꞌ seitiuu mosotquiee naquiiꞌ tsꞌoom: “¿Chiuu nntsꞌaayo̱ na cwii nncwantjo̱ⁿ? Ee patrom ꞌnaⁿya macwjeeⁿꞌeⁿ ja na mꞌaaⁿya mosotquiee. Ee tijndo̱ na nntsꞌaa tsꞌiaaⁿ jnda̱a̱ ndoꞌ jnaaⁿꞌa na cweꞌ nda̱a̱ nnꞌaⁿ nlcaaⁿꞌa ljoꞌ na macaⁿnaꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Mantyjii chiuu nntsꞌaa cha nntoꞌñoom nnꞌaⁿ ja lꞌaana xeⁿ jnda̱ ꞌndiinaꞌ ja na mosotquiee.” ");
INSERT INTO amuNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Quia joꞌ tqueeⁿꞌñê cwii ndoꞌ cwii nnꞌaⁿ na choꞌjnaⁿ nnom patrom ꞌnaaⁿꞌaⁿ. Taxꞌeeⁿ nnom tsꞌaⁿ najndyee: “¿Cwanti tꞌmaaⁿꞌ chujnaⁿꞌ nnom patrom ꞌnaⁿya?” ");
INSERT INTO amuNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Tꞌo̱ tsaⁿꞌñeeⁿ nnoom, tso: “Ja cho̱jnaⁿ cwii siaⁿnto ncjo seitye.” Ndoꞌ tsoom nnom: “Luaa coꞌñomꞌ tsom na teiljeii cwanti chujnaⁿꞌ. Queⁿndyuꞌ, cajmaⁿꞌ, catseiljeiꞌxcoꞌ na ñeꞌwenꞌaaⁿ nchooꞌ qui ncjo chujnaⁿꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Jnda̱ joꞌ taxꞌeeⁿ nnom cwiicheⁿ, tsoom: “Ndoꞌ ꞌu jeꞌ, ¿cwanti chujnaⁿꞌ?” Tꞌo̱ tsaⁿꞌñeeⁿ nnoom: “Ja cho̱jnaⁿ cwii siaⁿnto xuu lqueeⁿ trigo.” Quia joꞌ tsoom nnom: “Luaa coꞌñomꞌ tsom na chuunaꞌ cwanti chujnaⁿꞌ. Catseiljeiꞌxcoꞌ na ñeꞌñequieenꞌaaⁿ xuu lqueeⁿ trigo chujnaⁿꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Ndoꞌ tjaweeꞌ tsꞌom tsaⁿtya na luaaꞌ sꞌaa moso tiaaꞌñeeⁿ, ee na jndo̱ꞌ tsꞌoom tsꞌiaaⁿ na sꞌaaⁿ. Ee nnꞌaⁿ na mꞌaⁿ cantyja ꞌnaaⁿꞌ tsjoomnancuewaa, jndo̱ꞌti nꞌomna quiiꞌntaaⁿ ncꞌiaana, nchiiti nnꞌaⁿ na laꞌxmaⁿ cantyja ꞌnaaⁿꞌ naxuee. ");
INSERT INTO amuNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","’Candyeꞌyoꞌ ntsjo̱o̱, cwilꞌueeꞌndyoꞌ ꞌnaⁿꞌyoꞌ na niom tsjoomnancue na quio nlaꞌjndyeendyoꞌ nnꞌaⁿ na nljoya ñꞌoom ñꞌendyoꞌ. Quia joꞌ quia na nntycwii ꞌnaⁿꞌyoꞌ joꞌ, mꞌaⁿ ꞌñeeⁿ nntoꞌñoom ꞌo jo nandye cañoomꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","’Tsꞌaⁿ na ya matseicanda̱ ñꞌoom na titꞌmaⁿ, mati ntseicana̱a̱ⁿ ñꞌoom na tꞌmaⁿ. Ndoꞌ tsꞌaⁿ na titseicanda̱ meiiⁿ ñꞌoom na tiꞌtꞌmaⁿ tseixmaⁿnaꞌ, majndeiiticheⁿ tiꞌxotseicana̱a̱ⁿ ñꞌoom na tꞌmaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Sa̱a̱ xeⁿ ꞌo ticalacanda̱ꞌyoꞌ ñequio ꞌnaⁿꞌyoꞌ na waa tsjoomnancuejnaⁿwaa, tjaa ꞌñeeⁿ juu nñequiaa na nntoꞌñoomꞌyo ꞌnaⁿ na mayuuꞌcheⁿ na jnda matseixmaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ndoꞌ xeⁿ ꞌo tisꞌa cwenta cwilꞌaꞌyoꞌ ñequio ꞌnaⁿ na nchii ꞌnaⁿꞌyoꞌ joonaꞌ, meiⁿ tjaa ꞌñeeⁿ juu na nñequiaa naya lueeꞌyoꞌ na nlaꞌxmaⁿnaꞌ cwentaꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","’Tjaaꞌnaⁿ moso na nda̱a̱ nndiꞌntjom nnom we patrom. Ee nncꞌoom na ticueeꞌ tsꞌoom cwii, ndoꞌ cwiicheⁿ nncjaaweeꞌ tsꞌoom. Oo na nncjaañꞌoomñê ñꞌeⁿ cwii, sa̱a̱ cwiicheⁿ nntseijnaaⁿꞌaⁿ. ꞌO xocanda̱a̱ nndyeꞌntjomꞌyoꞌ nnom Tyꞌo̱o̱tsꞌom ndoꞌ mati nda̱a̱ sꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Nnꞌaⁿ fariseos na mꞌaⁿ joꞌ joꞌ, tyondyena chaꞌtso ñꞌoommeiⁿꞌ na seineiⁿ Jesús. Ndoꞌ tyolaꞌjnaaⁿꞌna jom, ee jeeⁿ cwilaꞌcandyaꞌ nꞌomna sꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Sa̱a̱ tsoom nda̱a̱na: —ꞌO cwitjeiꞌyandyoꞌ cheⁿncjoꞌyoꞌ jo nda̱a̱ nnꞌaⁿ sa̱a̱ Tyꞌo̱o̱tsꞌom wajnaⁿꞌaⁿ naquiiꞌ nꞌomꞌyoꞌ. Chaꞌtso nnom na jeeⁿ neiⁿncooꞌ nquiu nnꞌaⁿ na cwilaꞌtꞌmaaⁿꞌndyena, Tyꞌo̱o̱tsꞌom jnoomꞌm nmeiⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","’Tyolaꞌneiⁿ nnꞌaⁿ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na tqueⁿ Moisés, ñequio ñꞌoom ndyuee profetas hasta quia na tyjeeꞌ Juan. Quia ljoꞌcheⁿ jnaⁿnaꞌ na cwiwineiⁿ ñꞌoom cantyja ꞌnaaⁿꞌ na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom nnꞌaⁿ. Ndoꞌ jeꞌ jeꞌ jnda̱ tueꞌntyjo̱ xjeⁿ na ticwii cwii tsꞌaⁿ matseijndeii cha nnda̱a̱ nncjaaquieeꞌñe cantyja ꞌnaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","’Tijndeiꞌtinaꞌ na nntsuu tsjo̱ꞌluee ñequio tsjoomnancue, nchiiti na titseicanda̱a̱ꞌñenaꞌ meiiⁿ ñeꞌcwii ljeii cachjoo na quio teiljeii ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na matsa̱ꞌntjomnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","’Meiⁿꞌñeeⁿcheⁿ tsꞌaⁿ na nntseityuiiꞌ ljeii ꞌnaaⁿꞌ ñꞌeⁿ scuuꞌ ndoꞌ nncoco ñꞌeⁿ cwiicheⁿ yuscu, tsaⁿꞌñeeⁿ machꞌeenaꞌ na cweꞌ mꞌaaⁿyaaⁿ ñꞌeⁿ yuscuꞌñeeⁿ. Ndoꞌ mati meiⁿꞌñeeⁿcheⁿ tsꞌaⁿ na nncoco ñꞌeⁿ yuscu na jnda̱ tyuiiꞌ ljeii ꞌnaaⁿꞌ ñꞌeⁿ saaꞌ, mati tsaⁿꞌñeeⁿ machꞌeenaꞌ na cweꞌ mꞌaaⁿyaaⁿ ñꞌeⁿ yuscuꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","’Tyomꞌaaⁿ cwii tsaⁿtya na ñequiiꞌcheⁿ tyocweⁿ liaa na jeeⁿ ya ndoꞌ jndanaꞌ na tuiinaꞌ ñꞌeⁿ tsaⁿ lino. Ndoꞌ ꞌio ndii ꞌio tyocwaaⁿꞌaⁿ nantquie na yaticheⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Jo ꞌndyootsꞌa tiom waaꞌ tsaⁿtyaꞌñeeⁿ tyowacatyeeⁿ cwii tsaⁿjñeeⁿꞌ na jndyu Lázaro. Chaꞌwaañê chom ntyjeꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Tyocantyjaaꞌ tsꞌoom na nlcwaaⁿꞌaⁿ meiiⁿ cweꞌ na cajnda̱a̱ na cwiquiaa nacjeeꞌ meiⁿsa ꞌnaaⁿꞌ tsaⁿtya. Ndoꞌ calueꞌ tyonquiocatyueendyeyoꞌ ntyjeꞌ na chom. ");
INSERT INTO amuNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Tueꞌntyjo̱ xuee na tueꞌ tsaⁿjñeeⁿꞌ, ndoꞌ tyꞌeñꞌom ángeles añmaaⁿꞌaⁿ paraíso na mꞌaaⁿ Abraham. Mati tueꞌ tsaⁿtya ndoꞌ tjacantyꞌiuuꞌñê. ");
INSERT INTO amuNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Tyomꞌaaⁿñê yuu na ñjomndye lꞌoo. Jlunda̱a̱ñê, ntyꞌiaaꞌtquiaaⁿ na mꞌaaⁿ Lázaro nacañoomꞌ Abraham. ");
INSERT INTO amuNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Quia joꞌ seixuaⁿ, tsoom: “Tsotya̱ya, Abraham, cꞌoomꞌ na wiꞌ tsꞌomꞌ ja. Cajñomꞌ Lázaro na canchjeeñê nomtsꞌo̱o̱ⁿ naquiiꞌ ndaatioo cha nntseicanaⁿꞌaⁿ tsaya. Ee jeeⁿ tꞌmaⁿ wiꞌ matjo̱ⁿya naquiiꞌ chomwaa.” ");
INSERT INTO amuNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Sa̱a̱ tso Abraham nnoom: “Jndaaya, cjaañjoomꞌ tsꞌomꞌ chaꞌtso na ya na ñetoꞌñomꞌ xjeⁿ na ñetandoꞌ, ndoꞌ Lázaro wiꞌ ñetjoom. Sa̱a̱ jeꞌ jeꞌ jom ljoo mawajñeeⁿ ndoꞌ ꞌu jeꞌ, wiꞌ matjomꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ndoꞌ nchii macanda̱ cweꞌ joꞌ. Quiiꞌntaaⁿ jâ ñꞌeⁿndyoꞌ ꞌo waa cwii tsueꞌtsjoom na tjaa yuu cwintycwii na njoom, cha ꞌñeeⁿ jâ na ñeꞌcꞌoo na mꞌaⁿꞌ ꞌo, xocanda̱a̱ nncwinom. Ndoꞌ meiⁿ nnꞌaⁿ namꞌaⁿ yuu joꞌ xocanda̱a̱ nncwinom ntyjawaa.” ");
INSERT INTO amuNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Quia joꞌ matso tsaⁿtya: “Ta, matsꞌaa tyꞌoo njomꞌ, cwa cajñomꞌ jom waaꞌ tsotya̱, ");
INSERT INTO amuNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ee joꞌ joꞌ mꞌaⁿ ꞌom tiꞌntyjo̱. Cjaanquiaaⁿ ñꞌoom nda̱a̱na cha ticandyochuunaꞌ joona ljooñe yuu na jeeⁿ wiꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Sa̱a̱ tso Abraham nnoom: “Joona macwileiꞌñꞌomna ñꞌoom na tyoñequiaa Moisés ñequio profetas. Ñꞌoommeiⁿꞌ candyena.” ");
INSERT INTO amuNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Sa̱a̱ jom tsoom nnom Abraham: “Tiyuuꞌ ta, xeⁿ cwii joo nnꞌaⁿ na jnda̱ tja̱ wjaa na mꞌaⁿna, maxjeⁿ nlcweꞌ nꞌomna.” ");
INSERT INTO amuNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ndoꞌ tꞌo̱ Abraham nnoom: “Xeⁿ tiñeꞌcandyena ñꞌoom na tyoñequiaa Moisés ñequio profetas, mati xocandyena ñꞌoom ꞌndyoo cwii tsꞌaⁿ meiiⁿ na nncwandoꞌnndaꞌ na jnda̱ tueꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Tso Jesús nda̱a̱ nnꞌaⁿ na cwilaꞌjomndye ñꞌoomꞌm: —Tijoom jaawintyjeeꞌnaꞌ na ñeꞌcatseiquiaanaꞌ nnꞌaⁿ na calꞌana jnaⁿ, sa̱a̱ nntꞌuiiwiꞌnaꞌ tsꞌaⁿ na jnaaⁿꞌ juu nncjaachuunaꞌ nnꞌaⁿ na mati nlꞌana jnaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Yati xeⁿ cwityeⁿ cwii tsjo̱ꞌsuu xtyoꞌ tsaⁿꞌñeeⁿ ndoꞌ catueeꞌ nnꞌaⁿ jom tsꞌom ndaaluee nchiiti na nntseiquioonaꞌ cwii joo nnꞌaⁿ na tyoowijnda̱ya cantyja na cwilaꞌyuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Queⁿꞌyoꞌ cwenta cantyja ꞌnaⁿꞌyoꞌ. ’Xeⁿ cwii nnꞌaⁿꞌ na matseiyuꞌ matseitjo̱o̱ñê njomꞌ, cwaⁿꞌyaꞌ jom. Ndoꞌ xeⁿ cwilcweꞌ tsꞌoom, catseitꞌmaⁿ tsꞌomꞌ jom. ");
INSERT INTO amuNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ndoꞌ meiiⁿ matseitjo̱o̱ñê njomꞌ ntquieeꞌ ndiiꞌ na cwii xuee, ndoꞌ cwii cwii ndiiꞌ nncjaacatsoom njomꞌ: “Catseitꞌmaⁿ tsꞌomꞌ ja, cwilcweꞌ tsꞌo̱o̱ⁿ”, maxjeⁿ ñequiiꞌcheⁿ catseitꞌmaⁿ tsꞌomꞌ jom. ");
INSERT INTO amuNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Apóstoles jluena nnom Ta Jesús: —Quiaaꞌ na tꞌmaⁿti nlayuꞌya nꞌo̱o̱ⁿya. ");
INSERT INTO amuNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Tsoom nda̱a̱na: —Meiiⁿ na jeeⁿ cachjoo cwilayuꞌya nꞌomꞌyoꞌ cweꞌ chaꞌna cachjoo cwii tsꞌom lqueeⁿ mostaza, nnda̱a̱ nnduꞌyoꞌ nnom tsꞌoom sicómorowaaꞌ: “Catyendyuꞌ ndoꞌ coꞌnaꞌ ꞌu tsꞌom ndaaluee.” Ndoꞌ maxjeⁿ nntseicanda̱naꞌ ñꞌomndyueꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","’Calꞌuu cwiindyoꞌ ꞌo mꞌaaⁿ mosooꞌ na matseindyaa oo na machꞌee cwenta quiooꞌ jo jnda̱a̱, ndoꞌ quia jnda̱ tyjeeꞌ tsaⁿꞌñeeⁿ na jnaⁿ jnda̱a̱, ¿aa mantyja nntsuꞌ nnom: “Cwinoomꞌ luaa, cajmaⁿꞌ na nlcwaꞌ”? ");
INSERT INTO amuNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","¿Aa nchii najndyee nntsuꞌ nnoom?: “Cwa catseijndaaꞌndyuꞌ jeꞌ, catseiñꞌoomꞌndyuꞌ na nlcwaaꞌa. Xeⁿ jnda̱ tcwaaꞌa ndoꞌ jnda̱ tꞌua, quia ljoꞌcheⁿ nlcwaꞌ ndoꞌ nncꞌuaꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Aa nntsꞌaacheⁿnaꞌ na nñequiaaꞌ na quianlꞌuaaꞌ mosoꞌ ncꞌe na seicana̱a̱ⁿ ñꞌoom na sa̱ꞌntjomꞌ jom? Matseitiuu xocatsaꞌ na ljoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Mati ꞌo, quia na jnda̱ lꞌaꞌyoꞌ chaꞌtso na matsa̱ꞌntjomnaꞌ na calꞌaꞌyoꞌ, quia joꞌ canduꞌyoꞌ: “Jâ cwiluiindyô̱ moso na tjaa yuu lꞌuendye. Ee cweꞌ tomti na laxmaaⁿyâ na calꞌaayâ jnda̱ ñelꞌaayâ.” ");
INSERT INTO amuNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Quia joꞌ tjatjati Jesús na mawjaⁿ Jerusalén, teinoom tyencooꞌ tsꞌo̱ndaa Samaria ñequio tsꞌo̱ndaa Galilea. ");
INSERT INTO amuNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Chaꞌna tjaqueⁿꞌeⁿ cwii tsjoom chjoo, jluiꞌnom qui nnꞌaⁿ na cho tycu lepra, tquia tyꞌemeiꞌntyjeeꞌna. ");
INSERT INTO amuNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Jndeii jlaꞌxuaana, jluena: —ꞌU Jesús na maꞌmo̱o̱ⁿꞌ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom nda̱a̱ nnꞌaⁿ, cꞌoomꞌ na wiꞌ tsꞌomꞌ jâ. ");
INSERT INTO amuNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Quia na ntyꞌiaaꞌ Jesús joona, tsoom nda̱a̱na: —Catsalaꞌcaꞌmo̱ⁿndyoꞌ nda̱a̱ ntyee. Ndoꞌ yocheⁿ na cwiꞌoona, jliuna cwa jnda̱ ljuuꞌndyena tycuꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ndoꞌ cwii tsaⁿꞌñeeⁿ, quia na ljeiiⁿ na jnda̱ nꞌmaaⁿ, tjalcweeⁿꞌeⁿ, cꞌuaa ꞌñom na matseitꞌmaaⁿꞌñe Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Tcoomꞌm xtyeeⁿ jo nnom Jesús, tquiaaⁿ na quianlꞌuaaꞌ. Tsꞌaⁿ samaritano tsaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Quia joꞌ tso Jesús: —¿Aa nchii quindye nnꞌaⁿ na ljuuꞌndye? Ndoꞌ ntꞌomcheⁿ ñjeeⁿ jeꞌ ¿yuu mꞌaⁿ? ");
INSERT INTO amuNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Macanda̱ juu tsaⁿmꞌaaⁿ na nchii tsꞌaⁿ judío, jndyotseitꞌmaaⁿꞌñê Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Quia joꞌ tso Jesús nnom: —Quicantyjaꞌ, cjaꞌtoꞌ. Ncꞌe na matseiꞌyuꞌya tsꞌomꞌ ñꞌeⁿndyo̱ jnda̱ nꞌmaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Tyotaꞌxꞌee nnꞌaⁿ fariseos nnom Jesús cwaaⁿ nncwjeeꞌcañoom juu na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. Tꞌo̱o̱ⁿ nda̱a̱na, tsoom: —Xocalaꞌno̱ⁿꞌyoꞌ aa jnda̱ tueꞌntyjo̱ juunaꞌ cweꞌ cwii ꞌnaaⁿ na nleitquiooꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Tjaa ꞌñeeⁿ nnda̱a̱ nntso: “Luaaꞌ mꞌaaⁿ”, oo “Laꞌñeeⁿ mꞌaaⁿ na matsa̱ꞌntjoom”, ee jnda̱ mamatsa̱ꞌntjom Tyꞌo̱o̱tsꞌom naquiiꞌ nꞌomꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Tsoom nda̱a̱ nnꞌaⁿ na cwilaꞌjomndye ñꞌoomꞌm: —Manncueꞌntyjo̱ xuee na nntseiqueeⁿnaꞌ nꞌomꞌyoꞌ na ñeꞌcantyꞌiaꞌnndaꞌyoꞌ ja na cwiluiindyo̱ nquii na jnaⁿ cañoomꞌluee, sa̱a̱ taxocantyꞌiaꞌyoꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nluena nda̱a̱ꞌyoꞌ: “Luaaꞌ jom”, oo “Luaa.” Sa̱a̱ tintsantyjaꞌyoꞌ. Meiⁿ tintsantyjo̱ꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ee chaꞌxjeⁿ na macoꞌ tsueechom matseixueenaꞌ cwii ntyjaaꞌ tsjo̱ꞌluee xjeⁿ cwiicheⁿ ntyjaaꞌnaꞌ, maluaaꞌ nntseijomnaꞌ quia na nndyo̱o̱nndaꞌa na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Sa̱a̱ najndyee macaⁿnaꞌ na tꞌmaⁿ nawiꞌ catjo̱ⁿ ndoꞌ mati calꞌa nnꞌaⁿ na mꞌaⁿ jeꞌ na ticueeꞌ nꞌomna ja. ");
INSERT INTO amuNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Chaꞌxjeⁿ na tyolꞌa nnꞌaⁿ xjeⁿ na tyomꞌaaⁿ Noé, maluaaꞌ nntseijomnaꞌ nlꞌa nnꞌaⁿ xjeⁿ na manndyo̱o̱nndaꞌa na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ee quia ljoꞌcheⁿ tyocwaꞌna, tyowena. Tyoꞌuncona, tyoñequiana ndana na nncꞌunco hasta xuee quia na tuo̱ Noé tsꞌom wꞌaandaa. Quia joꞌ jnaⁿnaꞌ na tuaꞌntyꞌa, tja̱ chaꞌtsondye naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ndoꞌ majoꞌti tuii quia na tyomꞌaaⁿ Lot, tyocwaꞌna, tyowena. Tyolaꞌjndana, tyonda̱a̱na. Tyonomna ntjom, tyolꞌana lꞌaa. ");
INSERT INTO amuNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Sa̱a̱ juu xuee na tjeiꞌ Tyꞌo̱o̱tsꞌom Lot tsjoom Sodoma, tuaꞌ ndaaluaaꞌ chom ñequio ljo̱ꞌ sufra̱ na jnaⁿnaꞌ tsjo̱ꞌluee. Ndoꞌ seicwjeenaꞌ chaꞌtso nnꞌaⁿ tsjoomꞌ ñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Maluaaꞌ nntsꞌaanaꞌ xuee na nleitquiooꞌndyo̱ ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","’Majuu xueeꞌñeeⁿ, tsꞌaⁿ na mꞌaaⁿ chꞌeⁿ, tintseicandyaꞌ tsꞌoom ꞌnaaⁿꞌaⁿ na nncjaaqueⁿꞌeⁿ naquii wꞌaa na nncwjeeⁿꞌeⁿ joonaꞌ. Ndoꞌ majoꞌti tsꞌaⁿ na mꞌaaⁿ jo jnda̱a̱ tindyolcweeⁿꞌeⁿ na nndyochoom ꞌnaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Cjaañjoomꞌ nꞌomꞌyoꞌ cantyja ꞌnaaⁿꞌ scuuꞌ Lot. ");
INSERT INTO amuNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na ñeꞌcwjiꞌnꞌmaaⁿñe cheⁿnquii, majoꞌto joꞌ nntsuuñe. Sa̱a̱ meiⁿnquia tsꞌaⁿ na mañequiaañe na catjom ljoꞌ na nntjom, tsaⁿꞌñeeⁿ nluiꞌnꞌmaaⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","’Candyeꞌyoꞌ nntsjo̱o̱, juu teijaaⁿꞌñeeⁿ quia na nndyo̱o̱nndaꞌa, we nnꞌaⁿ maⁿꞌ cjooꞌ jnduu, cwii tsaⁿꞌñeeⁿ wjaañꞌoomnaꞌ jom na mꞌaaⁿya, ndoꞌ cwiicheⁿ maꞌndiinaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","We yolcu ñeꞌnaaⁿꞌ cwitua, cwii tsaⁿꞌñeeⁿ wjaañꞌoomnaꞌ jom na mꞌaaⁿya, ndoꞌ cwiicheⁿ maꞌndiinaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","We nnꞌaⁿ mꞌaⁿ jo jnda̱a̱ na cwilꞌa tsꞌiaaⁿ, cwii tsaⁿꞌñeeⁿ wjaañꞌoomnaꞌ jom na mꞌaaⁿya, ndoꞌ cwiicheⁿ maꞌndiinaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Quia joꞌ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê, taꞌxꞌeena nnoom, jluena: —¿Yuu cwii jom joꞌ, Ta? Tꞌo̱o̱ⁿ ndyueena cwii ñꞌoom na tjañoomꞌ na maꞌmo̱ⁿnaꞌ na maxjeⁿ nntuꞌxeⁿndye naⁿꞌñeeⁿ. Tsoom: —Yuu na meindyuaa ꞌnaⁿ to̱ꞌ, joꞌ joꞌ nntjomndye cantꞌeiⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Mati seineiⁿ Jesús cwiicheⁿ ñꞌoom na tjañoomꞌ. Maꞌmo̱ⁿnaꞌ na ñeꞌquiiꞌcheⁿ calaꞌneiⁿ nnꞌaⁿ nnom Tyꞌo̱o̱tsꞌom, tincwintqueeⁿna. ");
INSERT INTO amuNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Tsoom nda̱a̱na: —Tyomꞌaaⁿ cwii jwe cwii tsjoom. Juu tsaⁿꞌñeeⁿ meiⁿ Tyꞌo̱o̱tsꞌom tinquiaⁿꞌaⁿ, meiⁿ nnꞌaⁿ tiquitseitꞌmaaⁿꞌñê. ");
INSERT INTO amuNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Mati tyomꞌaaⁿ cwii yuscu tsjoomꞌñeeⁿ na jnda̱ ljoñe na tueꞌ saaꞌ. Juu yuscuꞌñeeⁿ ñequiiꞌcheⁿ na tyocaa na mꞌaaⁿ jweꞌñeeⁿ na catseijndaaꞌñe ñꞌoom ꞌnaaⁿꞌaⁿ. Tyotsoom nnom: “Cwañomꞌ ja ñꞌoom cantu na sꞌaa tsꞌaⁿ nacjoya.” ");
INSERT INTO amuNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Jndye xuee tîcatseinꞌoomꞌñe jwe yuscuꞌñeeⁿ, sa̱a̱ jnda̱ joꞌ seitioom naquiiꞌ tsꞌoom: “Meiiⁿ na tinquiaya Tyꞌo̱o̱tsꞌom ndoꞌ meiiⁿ na ticatseitꞌmaaⁿꞌndyo̱ nnꞌaⁿ, ");
INSERT INTO amuNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","sa̱a̱ cweꞌ ee na jeeⁿ matseiliooꞌ yuscumꞌaaⁿꞌ ja, nncwaño̱ⁿꞌto̱ jom cwitjo̱o̱cheⁿ nntycwii na tꞌmaⁿ tsꞌo̱o̱ⁿ ñꞌeⁿñê.” ");
INSERT INTO amuNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Tso Ta Jesús: —Jweꞌñeeⁿ meiiⁿ na wiꞌñe sa̱a̱ ¿aa cwiqueⁿꞌyoꞌ cwenta na tsoom na nncwañomꞌtoom yuscuꞌñeeⁿ? ");
INSERT INTO amuNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Majndeiiticheⁿ nquii Tyꞌo̱o̱tsꞌom, ¿aa nchii nncwañomꞌm nnꞌaⁿ na jnda̱ tjeiiꞌñê cwentaaⁿꞌaⁿ, na cwilcwiiꞌna jom naxuee ndoꞌ natsjom? Xocatsꞌaaⁿ na mayo ticatseiñꞌoomꞌñê joona. ");
INSERT INTO amuNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nndyeꞌyoꞌ nntsjo̱o̱, jom mantyja nntseiñꞌoomꞌñê. Sa̱a̱ quia na nndyo̱o̱nndaꞌa, ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee, ¿aa ndyaꞌ cwii nljei na mꞌaⁿ nnꞌaⁿ na cwilaꞌyuꞌya nꞌom ñꞌeⁿ Tyꞌo̱o̱tsꞌom? ");
INSERT INTO amuNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Mati seineiⁿ Jesús ñꞌoom tjañoomꞌwaa nda̱a̱ nnꞌaⁿ na cwitjeiiꞌ cheⁿnquiee cwenta na jeeⁿ ya cwilꞌa, sa̱a̱ mꞌaⁿna na ticueeꞌ nꞌomna ntꞌomcheⁿ nnꞌaⁿ. Tsoom: ");
INSERT INTO amuNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Tyomꞌaaⁿ cwii tsꞌaⁿ fariseo ndoꞌ mati tyomꞌaaⁿ cwii tsaⁿquiñom sꞌom cwentaaꞌ gobiernom. We naⁿꞌñeeⁿ mañejuu xjeⁿ tyꞌena watsꞌom tꞌmaⁿ na nlaꞌneiⁿna nnom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Juu fariseo teintyjeeⁿꞌeⁿ, luaa waa ñꞌoom na tsoom nnom Tyꞌo̱o̱tsꞌom: “ꞌU Ta Tyꞌo̱o̱tsꞌom, mañequiaya na quianlꞌuaꞌ na ticatseixmaⁿya chaꞌna ntꞌomcheⁿ nnꞌaⁿ, chaꞌna nnꞌaⁿ na cantyꞌuendye, nnꞌaⁿ na quilꞌa yuu na ticatyꞌiomyanaꞌ, nnꞌaⁿ na cweꞌ mꞌaⁿya ñꞌeⁿ ncꞌiaa, mati meiiⁿ nchii chaꞌ tsaⁿmꞌaaⁿꞌ, tsaⁿquiñom sꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Ja we ndiiꞌ matseicwejndoꞌndyo̱ na cwii smaⁿna, ndoꞌ chaꞌtso na mawantjo̱ⁿ mañequiaya diezmo.” ");
INSERT INTO amuNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Sa̱a̱ juu tsaⁿquiñom sꞌom, tquia tjameintyjeeⁿꞌeⁿ, meiⁿ na nluꞌnda̱a̱ñê tsjo̱ꞌluee. Macanda̱ tyomeiiⁿꞌeⁿ ndaꞌ tseiꞌjñaaⁿ na tyotseintyꞌiaaꞌñê, tsoom: “ꞌU Tyꞌo̱o̱tsꞌom, cꞌoomꞌ na wiꞌ tsꞌomꞌ ja tsꞌaⁿjnaⁿ.” ");
INSERT INTO amuNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Candyeꞌyoꞌ nntsjo̱o̱, tsaⁿquiñoom sꞌom tjalcweeⁿꞌeⁿ waⁿꞌaⁿ na jnda̱ seitꞌmaⁿ tsꞌom Tyꞌo̱o̱tsꞌom jom, nchiiti cwiicheⁿ tsaⁿꞌñeeⁿ. Ee meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na matseiwendyeñe cheⁿnquii, maxjeⁿ nntseiquioo Tyꞌo̱o̱tsꞌom juu. Ndoꞌ tsꞌaⁿ na majuꞌcjeñe, maxjeⁿ nntseitꞌmaaⁿꞌñeⁿ Tyꞌo̱o̱tsꞌom tsaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Tquiocho nnꞌaⁿ yocanchꞌu na mꞌaaⁿ Jesús na nntioom lꞌo̱o̱ⁿ nacjoona. Ndoꞌ quia na ntyꞌiaa nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê na luaaꞌ, jlaꞌtiaꞌna nnꞌaⁿ na tquiocho yocanchꞌuꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Quia joꞌ tqueeⁿꞌñe Jesús yocanchꞌu ndoꞌ tsoom nda̱a̱ nnꞌaⁿ: —Caꞌndyeꞌyoꞌ na nñequio yocanchꞌu na mꞌaaⁿya, tilaꞌntycwiꞌyoꞌ joona ee yuu na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom, juunaꞌ matseixmaⁿnaꞌ cwentaa nnꞌaⁿ na ntyjaandye ja chaꞌna quilꞌa yosanchꞌumꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Mayuuꞌcheⁿ matsjo̱o̱ nda̱a̱ꞌyoꞌ, meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na ticantyjaaꞌ tsꞌom na nntsa̱ꞌntjom Tyꞌo̱o̱tsꞌom juu chaꞌna ntyjaaꞌ tsꞌom cwii yucachjoo, tsaⁿꞌñeeⁿ xocanda̱a̱ nncjaaquieeꞌñe joꞌ joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Cwii tsꞌaⁿ judío na cwiluiitquieñe taxꞌee nnoom: —ꞌU Ta na maꞌmo̱o̱ⁿꞌ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom nda̱a̱ nnꞌaⁿ na ya tsꞌaⁿndyuꞌ, ¿chiuu ya nntsꞌaa cha nndaya na ticantycwii na nncwaꞌndo̱ꞌa? ");
INSERT INTO amuNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Tꞌo̱ Jesús nnom: —Matsuꞌ na ja ya tsꞌaⁿndyo̱, macanda̱ nquii Tyꞌo̱o̱tsꞌom cwiluiiñê na ljoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ꞌU mantyjiꞌ ñꞌoom na matsa̱ꞌntjoom na matsonaꞌ: “Tincꞌoomꞌyaꞌ ñꞌeⁿ cwiicheⁿ tsꞌaⁿ. Tintseicueꞌ tsꞌaⁿ. Tinchꞌueeꞌ ꞌnaaⁿꞌ tsꞌaⁿ. Tintseineiⁿꞌ cantu nacjooꞌ tsꞌaⁿ. Catseitꞌmaaⁿꞌndyuꞌ tsotyeꞌ ñꞌeⁿ tsoꞌndyoꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Tso tsaⁿꞌñeeⁿ nnoom: —Chaꞌtso ñꞌoommeiⁿꞌ matseicanda̱ xjeⁿ na cachjoondyo̱. ");
INSERT INTO amuNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Quia na jndii Jesús na luaaꞌ, tsoom nnom: —Cwii waa na cwii matseiꞌtjo̱o̱ꞌ. Cajnda̱a̱ꞌ chaꞌtso na maleichuꞌ ndoꞌ quiaaꞌ nda̱a̱ ndyeñeeⁿꞌ. Quia joꞌ nncꞌoomꞌ na tyandyuꞌ cañoomꞌluee. Jnda̱ joꞌ candyotseijomndyuꞌ ñequiondyo̱. ");
INSERT INTO amuNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Sa̱a̱ quia na jndii tsaⁿꞌñeeⁿ na luaaꞌ, seichjooꞌnaꞌ tsꞌoom ee jeeⁿ tyañê. ");
INSERT INTO amuNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Quia na ntyꞌiaaꞌ Jesús na jeeⁿ chjooꞌ tsꞌoom, tso: —Jeeⁿ ndyaꞌ jndeiꞌnaꞌ na nñeꞌquiandye naⁿtya na nntsa̱ꞌntjom Tyꞌo̱o̱tsꞌom joona. ");
INSERT INTO amuNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Tijndeiꞌtinaꞌ na nncwicandiiꞌñe quiooꞌ camello tsueꞌ xꞌee tseiꞌnchquia nchiiti na nncjaaquieeꞌ cwii tsaⁿtya ntyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ndoꞌ nnꞌaⁿ na jndye ñꞌoomwaaꞌ, tyolue: —¿Quia joꞌ ꞌñeeⁿ juu nnda̱a̱ nluiꞌnꞌmaaⁿñe? ");
INSERT INTO amuNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Tso Jesús nda̱a̱na: —Yuu na xocanda̱a̱ nlꞌa nnꞌaⁿ, nquii Tyꞌo̱o̱tsꞌom nnda̱a̱ nntsꞌaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Tso Pedro: —Cantyꞌiaꞌ, jâ jnda̱ ꞌndya̱a̱yâ chaꞌtso ꞌnaaⁿyâ na cwilajomndyô̱ ñꞌeⁿndyuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Tso Jesús nda̱a̱na: —Mayuuꞌcheⁿ matsjo̱o̱ nda̱a̱ꞌyoꞌ, meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na maꞌndii waaꞌ oo scuuꞌ, ntyjee, tsotye, tsondyee, oo ntseinda ncꞌe na matseijomñe cantyja ꞌnaaⁿꞌ na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom, ");
INSERT INTO amuNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","tsaⁿꞌñeeⁿ jndyeti nmeiⁿꞌ nncoꞌñoom tiempomeiiⁿ, ndoꞌ xuee na cwii nndyotinaꞌ nncꞌoom na ticantycwii na wanoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Quia joꞌ tjeiꞌndyo̱ Jesús nnꞌaⁿ canchooꞌwendye. Tsoom nda̱a̱na: —Queⁿꞌyoꞌ cwenta, jeꞌ macwitsaawaaya Jerusalén. Joꞌ joꞌ nntseicanda̱a̱ꞌñenaꞌ chaꞌtso ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na jlaꞌljeii profetas cantyja ꞌnaⁿya na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ee nñeꞌquia nnꞌaⁿ cwenta ja luee nnꞌaⁿ gentiles, nlaꞌjnaaⁿꞌna ja, cwajndii ñꞌoom na nluena cjoya ndoꞌ njñomna ndaajnaⁿꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Mati nntjaaꞌna ja, ndoꞌ xeⁿ jnda̱ nlaꞌcueeꞌna ja, sa̱a̱ xuee jnda̱ ndyee nncwando̱ꞌxco̱. ");
INSERT INTO amuNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Sa̱a̱ naⁿꞌñeeⁿ tîcalaꞌno̱ⁿꞌna ljoꞌ cwitꞌmo̱o̱ⁿ ñꞌoommeiⁿꞌ ee tyootseicano̱o̱ⁿ Tyꞌo̱o̱tsꞌom joonaꞌ nda̱a̱na. Joꞌ chii tîleicalaꞌno̱ⁿꞌna. ");
INSERT INTO amuNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Luaa tuii. Quia na tyꞌewindyoona tsjoom Jericó, joꞌ wacatyeeⁿ cwii tsaⁿnchjaaⁿꞌ ꞌndyoo nato, macaaⁿ ljoꞌ tjo̱o̱ñê nda̱a̱ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Quia na jñeeⁿ na jndyendye nnꞌaⁿ cawiꞌnom, taxꞌeeⁿ ljoꞌ cwiluii. ");
INSERT INTO amuNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Jluena nnoom: —Jesús na jnaⁿ Nazaret jom luaaꞌ mawinoom. ");
INSERT INTO amuNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Quia joꞌ seixuaⁿ, tsoom: —Jesús, ꞌu na cwiluiindyuꞌ tsjaaⁿ ꞌnaaⁿꞌ David na jndyowicantyjooꞌ, cꞌoomꞌ na wiꞌ tsꞌomꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Nnꞌaⁿ na ꞌoojndyee jlaꞌtiaꞌna jom, jluena catseicheeⁿ, sa̱a̱ jom yacheⁿ jndeii seixuaⁿ: —ꞌU na cwiluiindyuꞌ tsjaaⁿ ꞌnaaⁿꞌ David na jndyowicantyjooꞌ, cꞌoomꞌ na wiꞌ tsꞌomꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Quia joꞌ tjameintyjeeꞌ Jesús, sa̱ꞌntjoom na quioñꞌomna tsaⁿꞌñeeⁿ na mꞌaaⁿ. Quia tueeꞌcañoom tsaⁿꞌñeeⁿ, taxꞌeeⁿ nnom, matsoom: ");
INSERT INTO amuNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Ljoꞌ lꞌue tsꞌomꞌ na catsꞌaa ñꞌeⁿndyuꞌ? Tꞌo̱ tsaⁿꞌñeeⁿ nnoom: —Jeeⁿ ꞌu Ta, lꞌue tsꞌo̱o̱ⁿ na nleitquioya. ");
INSERT INTO amuNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Tꞌo̱ Jesús nnom: —Cwitquioꞌ. Ncꞌe na matseiꞌyuꞌya tsꞌomꞌ ñꞌeⁿndyo̱, joꞌ na jnda̱ nꞌmaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Mañoomꞌ teitquioomꞌm. Tjantyjo̱o̱ⁿ naxeⁿꞌ Jesús, tyotseitꞌmaaⁿꞌñê Tyꞌo̱o̱tsꞌom. Ndoꞌ mati nnꞌaⁿ na jndyendye, quia ntyꞌiaana na luaaꞌ, tyolaꞌtꞌmaaⁿꞌndyena Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Quia na jnda̱ tjaquieeꞌ Jesús tsjoom Jericó, tjawinoom quiiꞌ tsjoom. ");
INSERT INTO amuNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Joꞌ joꞌ tyomꞌaaⁿ cwii tsaⁿtya na jndyu Zaqueo. Tsaⁿꞌñeeⁿ cwiluiitquieñê jo nda̱a̱ nnꞌaⁿ na cwitoꞌñoom sꞌom cwentaaꞌ gobiernom. ");
INSERT INTO amuNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Tyoqueⁿñê na nncwajnaⁿꞌaⁿ ꞌñeeⁿ joꞌ na Jesús, sa̱a̱ tileicanda̱a̱ ee jeeⁿ jndye nnꞌaⁿ ndoꞌ na catꞌa̱a̱ꞌñê. ");
INSERT INTO amuNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Joꞌ chii jleinoom, tjañetyeeⁿ, tjawaaⁿ cwii tsꞌoom sicómoro na nntyꞌiaaⁿꞌaⁿ Jesús ee na joꞌ joꞌ nncwinom tsaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Quia na tueꞌcañoom Jesús joꞌ joꞌ, jlunda̱a̱ñê, tsoom nnom: —Zaqueo, catseityuaaꞌ, candyoꞌcueꞌ ee xuee jeꞌ macaⁿnaꞌ na caljooꞌndyo̱ waꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Quia joꞌ seityuaaⁿꞌaⁿ jndyocueeⁿ. Ñequio na neiiⁿꞌeⁿ seiljoom Jesús waⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Sa̱a̱ quia na ntyꞌiaa nnꞌaⁿ na luaaꞌ, chaꞌtsondyena tyolaꞌncjooꞌndyena, jluena: —Cwa jndaaꞌ tjaqueⁿꞌeⁿ na nljooꞌñê waaꞌ tsꞌaⁿ na matseitjo̱o̱ñe nnom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ndoꞌ teintyjeeꞌ Zaqueo, tsoom nnom Jesús: —Aa ndiꞌ, Ta, xcwe ꞌnaⁿya na niom manñequiaya nda̱a̱ ndyeñeeⁿꞌ ndoꞌ xeⁿ na xꞌua̱ya ꞌnaaⁿꞌ tsꞌaⁿ, jeꞌ manntseilcwa̱ꞌa ñequiee ndiiꞌ chaꞌxjeⁿ na tjeiiꞌa. ");
INSERT INTO amuNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Tso Jesús nnoom: —Xuee jeꞌ juu na macwjiꞌnꞌmaaⁿñe Tyꞌo̱o̱tsꞌom nnꞌaⁿ, jnda̱ tyjeeꞌnaꞌ wꞌaawaa. Ee mati tsaⁿmꞌaaⁿ cwiluiiñê tsꞌaⁿ tsjaaⁿ Abraham. ");
INSERT INTO amuNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Ee ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee jndyo̱calꞌua̱ ndoꞌ jndyo̱cwjiꞌnꞌmaaⁿndyo̱ nnꞌaⁿ na cwitsuundye añmaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nnꞌaⁿ na tyondye ñꞌoommeiⁿꞌ jlaꞌtiuuna tyuaaꞌ nleitquiooꞌ cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom, ee manndyooꞌ mꞌaaⁿ Jesús tsjoom Jerusalén. Joꞌ chii, tsotyeeⁿ ñꞌoom na tjañoomꞌ nda̱a̱na. ");
INSERT INTO amuNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Tsoom: —Tyomꞌaaⁿ cwii tsꞌaⁿ na tꞌmaⁿ cwiluiiñe. Tjaaⁿ tquia cwiicheⁿ ndyuaa na nncoꞌñoom tsꞌiaaⁿ na nntseixmaaⁿ rey, ndoꞌ xeⁿ jnda̱ nndyolcweeⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Cwii tjo̱o̱cheⁿ na nncjaⁿ, tqueeⁿꞌñê qui nnꞌaⁿ na cwindyeꞌntjomtyeⁿ nnoom. Tꞌmaⁿ sꞌom teijndeiiyaaⁿ nnom cwii cwii tsaⁿꞌñeeⁿ. Tsoom nda̱a̱na: “Calꞌueendyoꞌ chiuu nlꞌaꞌyoꞌ tsꞌiaaⁿ na nntantjomꞌyoꞌ ñꞌeⁿ joonaꞌ yocheⁿ na ja nncwja̱.” ");
INSERT INTO amuNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Sa̱a̱ nnꞌaⁿ ndyuaa tsjomꞌm, jndoona jom. Joꞌ jñoomna nnꞌaⁿ ndyuaa yuu na tjaaⁿ, tyꞌecalue naⁿꞌñeeⁿ: “Jâ ticalꞌue nꞌo̱o̱ⁿyâ na tsaⁿmꞌaaⁿꞌ nluiiñê rey cwentaaya.” ");
INSERT INTO amuNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Jnda̱ na toꞌñom tsaⁿꞌñeeⁿ nꞌiaaⁿ na nncꞌoom, jndyolcweeⁿꞌeⁿ. Tqueeⁿꞌñê nnꞌaⁿ na tquiaaⁿ sꞌom ꞌnaaⁿꞌaⁿ nda̱a̱. Ee ñeꞌcaljeiiⁿ cwanti jnda̱ taꞌntjom cwii cwiindye naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Tyjeeꞌ tsaⁿ najndyee, tso nnoom: “Nmeiiⁿ sꞌom ꞌnaⁿꞌ, ta, qui ndiiꞌ chaꞌxjeⁿ na toꞌño̱ⁿ jnda̱ tantjo̱ⁿ ñꞌeⁿ juunaꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Quia joꞌ tsoom nnom: “Ya saꞌ, ꞌu mosoya, meiiⁿ cachjoo na toꞌñomꞌ sa̱a̱ seicanda̱ꞌ. Joꞌ chii jeꞌ maqua̱ⁿya ꞌu nncꞌoomꞌ tsꞌiaaⁿ, nntsa̱ꞌntjomꞌ qui tsjoom.” ");
INSERT INTO amuNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ndoꞌ tyjeeꞌ tsaⁿ na jnda̱ we, tso nnoom: “Nmeiiⁿ sꞌom ꞌnaⁿꞌ, ta, ꞌom ndiiꞌ chaꞌxjeⁿ na toꞌño̱ⁿ jnda̱ tantjo̱ⁿya ñꞌeⁿ juunaꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Quia joꞌ majoꞌti tsoom nnom: “Jeꞌ maqua̱ⁿya ꞌu nncꞌoomꞌ tsꞌiaaⁿ, nntsa̱ꞌntjomꞌ ꞌom tsjoom tꞌmaⁿ.” ");
INSERT INTO amuNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Tyjeeꞌ cwiicheⁿ tsꞌaⁿ, tso nnoom: “Luaa sꞌom ꞌnaⁿꞌ, ta, na seiwa̱ naquiiꞌ payom. ");
INSERT INTO amuNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ee ja jeeⁿ nquiaya ꞌu na jeeⁿ jnda̱ ñꞌoom tseineiⁿꞌ. Ee ꞌu macoꞌñomꞌ yuu na nchii cwentaꞌ, ndoꞌ quitseiꞌweꞌ yuu na nchii ꞌu jnomꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Quia joꞌ tsoom nnom: “ꞌU moso ꞌnaⁿya na tia matseitiuuꞌ, majuuti ñꞌoom ꞌndyoꞌ nntsꞌaaya na nncuꞌxeⁿnaꞌ ꞌu. Xeⁿ ntyjiꞌ na ja tsꞌaⁿ na jeeⁿ jnda̱ ñꞌoom tseineiⁿ ndoꞌ na macoꞌño̱ⁿ yuu na nchii cwentaya ndoꞌ na quitseiwa̱ya yuu na nchii nnco̱ jno̱o̱ⁿꞌa, ");
INSERT INTO amuNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","quia joꞌ ¿chiuu na tîcjaꞌcaꞌndiiꞌ sꞌom ꞌnaⁿya banco yuu na nncwantjomnaꞌ cha quia na nndyo̱o̱nndaꞌa, nncoño̱ⁿ sꞌom ꞌnaⁿya mandiñꞌeeⁿ tsꞌiaaⁿnda̱a̱naꞌ?” ");
INSERT INTO amuNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Ndoꞌ tsoom nda̱a̱ ntꞌomcheⁿ nnꞌaⁿ na mꞌaⁿ nacañomꞌm: “Catjeiꞌyoꞌ sꞌom ꞌnaⁿya lꞌo̱o̱ⁿ ndoꞌ quiaꞌyoꞌ juunaꞌ nnom tsaⁿmꞌaaⁿꞌ na tantjom qui ndiiꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Tꞌo̱o̱ naⁿꞌñeeⁿ, jluena: “Ta, ¿chiuu ndoꞌ mamaleiñꞌoom qui ndiiꞌ na laaꞌtiꞌ?” ");
INSERT INTO amuNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Candyeꞌyoꞌ nntsjo̱o̱, meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na maniom na maleichuu, nloꞌñomti. Sa̱a̱ tsꞌaⁿ na tjaaꞌnaⁿ na cuaa lꞌo̱, nluiꞌñꞌeⁿ cwanti na maleiñꞌoom. ");
INSERT INTO amuNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Mati joo nnꞌaⁿ na jndoo ja, na ticalꞌue nꞌom na nntsa̱ꞌntjo̱ⁿya joo, quiochoꞌyoꞌ joona ñjaaⁿñe ndoꞌ ñequio na ndo̱o̱ꞌa catyjeꞌyoꞌ cantyoꞌna. ");
INSERT INTO amuNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jnda̱ seineiⁿ Jesús ñꞌoomwaaꞌ, tjatjatyeeⁿ na nncueⁿꞌeⁿ Jerusalén. ");
INSERT INTO amuNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ndoꞌ quia na tjawiñoomꞌm tsjoom Betfagé ñequio tsjoom Betania nndyooꞌ yuu waa ta na jndyu Olivos, jñoom we nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê na cꞌoona lꞌaa. ");
INSERT INTO amuNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Tsoom nda̱a̱na: —Catsaꞌyoꞌ juu tsjoom chjoo na mꞌaaⁿ ndyeyu jo nda̱a̱ꞌyoꞌ, ndoꞌ chaꞌna nntsaaquieꞌyoꞌ joꞌ, nliuꞌyoꞌ cwii snom chjoo na ñjom. Juu quiooꞌñeeⁿ meiⁿcwii ndiiꞌ tyoowaꞌljoo tsꞌaⁿ. Calacanaⁿꞌyoꞌ, nquioñꞌomꞌyoꞌ juuyoꞌ ñjaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ndoꞌ xeⁿ mꞌaaⁿ ꞌñeeⁿ juu na nncwaxꞌee nda̱a̱ꞌyoꞌ chiuu na cwilacanaⁿꞌyoꞌ juuyoꞌ, luaa canduꞌyoꞌ nnom: “Nquii Ta na matsa̱ꞌntjom jâ tjo̱o̱ñê juuyoꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Quia joꞌ tyꞌena lꞌaa na jñoom joona ndoꞌ jliuna chaꞌxjeⁿ na tsoom. ");
INSERT INTO amuNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Yocheⁿ na cwilaꞌcanaⁿꞌna snom, jlue nnꞌaⁿ na njmeiⁿꞌ juuyoꞌ: —¿Chiuu na cwilacanaⁿꞌyoꞌ snommꞌaaⁿꞌ? ");
INSERT INTO amuNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Quia joꞌ tꞌo̱o̱na: —Nquii Ta tjo̱o̱ñê juuyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Mana tyꞌeñꞌomna snomꞌñeeⁿ na mꞌaaⁿ Jesús. Jnda̱ tioona liaana naxeⁿꞌyoꞌ, teiꞌcaljoona jom. ");
INSERT INTO amuNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Yocheⁿ na mawjaawinoom, tyotsa̱ꞌ nnꞌaⁿ liaateincoo ꞌnaaⁿna tsꞌom nato. ");
INSERT INTO amuNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Quia na jnda̱ ꞌoowindyoona tsjoom Jerusalén yuu na wjaacue nato ta na jndyu Olivos, chaꞌtsondye nnꞌaⁿ na cwilaꞌjomndye ñꞌoomꞌm, to̱ꞌna na jndeii tyolaꞌxuaana. Tyolaꞌtꞌmaaⁿꞌndyena Tyꞌo̱o̱tsꞌom cantyja chaꞌtso tsꞌiaaⁿ tꞌmaⁿ na ntyꞌiaana na tyochꞌee Jesús. ");
INSERT INTO amuNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Jluena: —Tsaⁿmꞌaaⁿ cwiluiiñê Rey na matsa̱ꞌntjoom jaa. Macwjeꞌcañoom ñequio xueeꞌ nquii na tjacantyja cwiluii tꞌmaⁿñe. Jom catioꞌnaaⁿñe Tyꞌo̱o̱tsꞌom na mꞌaaⁿ cañoomꞌluee. Cwiljoya tsꞌoom ñequio nnꞌaⁿ. Catseitꞌmaaⁿꞌñenaꞌ nqueⁿ na mꞌaaⁿ nandyeticheⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ntꞌom nnꞌaⁿ fariseos na ñꞌeeⁿꞌndye quiiꞌntaaⁿ nnꞌaⁿ na jndyendye jluena: —ꞌU na maꞌmo̱o̱ⁿꞌ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom nda̱a̱ nnꞌaⁿ, catseitiaꞌ naⁿmꞌaⁿꞌ na cwilaꞌjomndye ñꞌomꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Tꞌo̱o̱ⁿ nda̱a̱na, tsoom: —Candyeꞌyoꞌ nntsjo̱o̱, xeⁿ naⁿmꞌaⁿ nlaꞌcheⁿna, quia joꞌ joo ljo̱ꞌ nlaꞌtꞌmaaⁿꞌndyenaꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Quia tueⁿꞌeⁿ nnom tsjoomꞌñeeⁿ, ndoꞌ quia ntyꞌiaaⁿꞌaⁿ juunaꞌ, tyꞌioom cantyja ꞌnaaⁿ nnꞌaⁿ na mꞌaⁿ joꞌ joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Tyotseineiiⁿ chaꞌcwijom nda̱a̱ naⁿꞌñeeⁿ, tsoom: —Toom cweꞌ xuee jeꞌ cwilaꞌno̱ⁿꞌyoꞌ ljoꞌ na macaⁿnaꞌ cha nnda̱a̱ ljoya tsꞌom Tyꞌo̱o̱tsꞌom ñꞌeⁿndyoꞌ. Sa̱a̱ jeꞌ cweꞌ wantyꞌiuuꞌ mꞌaaⁿnaꞌ jo nda̱a̱ꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ee nncueꞌntyjo̱ xuee na joo nnꞌaⁿ na jndoo ꞌo nlꞌana tiomtsjo̱ꞌ ndiocheⁿ nnom tsjomꞌyoꞌ na nncwañoomꞌnaꞌ joona. Ndoꞌ nnta̱ꞌna ꞌo meiⁿnquia ntyja. ");
INSERT INTO amuNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Nlaꞌtyuiiꞌñꞌeⁿna ꞌo ndoꞌ nlaꞌcwjeena ndaꞌyoꞌ. Ndoꞌ nlaꞌtyuiiꞌna niaⁿljo̱ꞌ tsjomꞌyoꞌ. Meiⁿcwii tsjo̱ꞌ taxocaꞌndyena nacjooꞌ xꞌiaaꞌnaꞌ, cweꞌ ncꞌe na ticalañꞌoomꞌndyoꞌ ja na jñom Tyꞌo̱o̱tsꞌom cha nnda̱a̱ nluiꞌnꞌmaaⁿndyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jnda̱ joꞌ tjaquieeꞌ Jesús watsꞌom tꞌmaⁿ, to̱o̱ⁿꞌo̱ⁿ tjeiiⁿꞌeⁿ nnꞌaⁿ chꞌeⁿ, joo nnꞌaⁿ na cwinda̱a̱ ndoꞌ nnꞌaⁿ na cwilaꞌjnda joꞌ joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Tsoom nda̱a̱na: —Waa ljeii ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom na matsonaꞌ: “Wꞌaya cwiluiiñenaꞌ wꞌaa yuu na cwilaꞌneiⁿ nnꞌaⁿ nnom Tyꞌo̱o̱tsꞌom.” Sa̱a̱ ꞌo cwilꞌaꞌyoꞌ juunaꞌ chaꞌcwijom tsueꞌtsjo̱ꞌ yuu na cwicatooꞌndye naⁿcantyꞌue. ");
INSERT INTO amuNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ndoꞌ ticwii xuee tyoꞌmo̱o̱ⁿ nda̱a̱ nnꞌaⁿ naquiiꞌ watsꞌom tꞌmaⁿ. Sa̱a̱ nnꞌaⁿ na cwiluiitquiendye nda̱a̱ ntyee ñequio nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés, ñequio nnꞌaⁿ na cwiluiitquiendye naquiiꞌ tsjoom, tyolꞌueeꞌndyena chiuu ya nlꞌana na nlaꞌcueeꞌna jom. ");
INSERT INTO amuNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Sa̱a̱ meiⁿchjoo tileicaliuna chiuu ya nlꞌana ee chaꞌtsondye nnꞌaⁿ tyocantyjaaꞌ nꞌom ñꞌoom na tyotseineiiⁿ nda̱a̱na. ");
INSERT INTO amuNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Tjuꞌnaꞌ cwii xueeꞌñeeⁿ na maꞌmo̱ⁿ Jesús nda̱a̱ nnꞌaⁿ naquiiꞌ watsꞌom tꞌmaⁿ. Mañequiaaⁿ ñꞌoom naya na macwjiꞌnꞌmaaⁿñe Tyꞌo̱o̱tsꞌom nnꞌaⁿ, ndoꞌ xjeⁿꞌñeeⁿ tquieꞌcañom ntyee na cwiluiitquiendye nda̱a̱ ntyee ñequio nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés, ñequio nnꞌaⁿ na cwiluiitquiendye quiiꞌ tsjoom. ");
INSERT INTO amuNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Jlue naⁿꞌñeeⁿ nnoom: —Catsuꞌ nda̱a̱yâ, ¿yuu tyꞌomꞌ najnduꞌ na macheꞌ nmeiiⁿꞌ? Ndoꞌ ¿ꞌñeeⁿ tquiaa na matseixmaⁿꞌ na luaaꞌ? ");
INSERT INTO amuNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Quia joꞌ tꞌo̱ Jesús nda̱a̱na: —Mati ja mawaxꞌa̱ cwii ñꞌoom nda̱a̱ꞌyoꞌ. Catꞌo̱ꞌyoꞌ nndii. ");
INSERT INTO amuNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Na tyotseitsꞌoomñe Juan nnꞌaⁿ, ¿yuu jnaⁿ najneiⁿ? ¿Aa namꞌaaⁿ Tyꞌo̱o̱tsꞌom oo aa cweꞌ ñꞌom ndyuee nnꞌaⁿ? ");
INSERT INTO amuNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Quia joꞌ tyolaꞌneiⁿ cheⁿnquieena ñꞌeⁿ ncꞌiaana, tyoluena: —Xeⁿ nlꞌuuya na mꞌaaⁿ Tyꞌo̱o̱tsꞌom jnaⁿnaꞌ, quia joꞌ nntsoom: “¿Chiuu na tîcalaꞌyuꞌyoꞌ ñꞌeⁿñê?” ");
INSERT INTO amuNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Sa̱a̱ xeⁿ nlꞌuuya namꞌaⁿ nnꞌaⁿ jnaⁿnaꞌ, nlaꞌcwjee nnꞌaⁿ jaa ñꞌeⁿ ljo̱ꞌ, ee cwilayuꞌyana na Juan cwiluiiñê profeta. ");
INSERT INTO amuNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Joꞌ chii tꞌo̱o̱na nnoom: —Jâ ticaliuuyâ yuu jnaⁿyuu najndeii Juan na tyotseitsꞌoomñê nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Quia joꞌ tso Jesús nda̱a̱na: —Meiⁿ ja, xocatsjo̱o̱ nda̱a̱ꞌyoꞌ ꞌñeeⁿ mañequiaa najndo̱ na matsꞌaa nmeiiⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","To̱o̱ⁿꞌo̱ⁿ na tyotseineiiⁿ ñꞌoom tjañoomꞌwaa nda̱a̱ nnꞌaⁿ, tsoom: —Tyomꞌaaⁿ cwii tsꞌaⁿ. Tcoomꞌm lꞌo̱o̱ uva tyuaaⁿꞌaⁿ. Jnda̱ joꞌ teijndeiiyaaⁿ joonaꞌ nnꞌaⁿ na nlꞌa tsꞌiaaⁿ joꞌ joꞌ ndoꞌ jndye xuee tjaaⁿ cwiicheⁿ ntyja. ");
INSERT INTO amuNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Quia na tueꞌntyjo̱ xjeⁿ na tquie ntjomꞌñeeⁿ, jñoom cwii mosoomꞌm na mꞌaⁿ naⁿꞌñeeⁿ na nñeꞌquiana na tseixmaⁿ cwentaaⁿꞌaⁿ. Sa̱a̱ tyotjaaꞌ naⁿꞌñeeⁿ juu, jñoomna juu na tjaa ljoꞌ tjachuu. ");
INSERT INTO amuNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Joꞌ chii jñomnnaaⁿꞌaⁿ cwiicheⁿ mosoomꞌm. Mati tsaⁿꞌñeeⁿ tyotjaaꞌna ndoꞌ tyolajnaaⁿꞌna juu, jnda̱ chii jñoomna juu na tjaa ljoꞌ tjachuu. ");
INSERT INTO amuNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Jñomnnaaⁿꞌaⁿ cwiicheⁿ moso na jnda̱ ndyee. Juu tsaⁿꞌñeeⁿ jlaꞌquieeꞌndyena, jnda̱ chii tjeiiꞌna juu naquiiꞌ ntjomꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","’Quia joꞌ tso tsꞌaⁿ na ntjoomꞌ joꞌ: “¿Chiuu chiuu nntsꞌaayo̱? Luaa nntsꞌaa, njño̱o̱ⁿ nquii tiꞌjndaa na jeeⁿ candyaꞌ tsꞌo̱o̱ⁿ. Nntsꞌaacheⁿndyo quia na nntyꞌiaana jom, nlaꞌtꞌmaaⁿꞌndyena jom.” ");
INSERT INTO amuNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Sa̱a̱ nnꞌaⁿ na cwilꞌa tsꞌiaaⁿ tyuaaⁿꞌaⁿ, quia na ntyꞌiaana na nquii jnaaⁿ joꞌ, tyoluena nda̱a̱ ncꞌiaana: “Luaaꞌ tsꞌaⁿ na cwiljo ntjom lꞌo̱. Cwa nlaꞌcua̱a̱ꞌa jom cha jaa nljo ntjom lua̱a̱ya.” ");
INSERT INTO amuNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Joꞌ chii, tjeiiꞌna jom nnom ntjom ndoꞌ jlaꞌcueeꞌna jom. Taxꞌee Jesús nda̱a̱ nnꞌaⁿ, tsoom: —Nquii tsꞌaⁿ na ntjoomꞌ joꞌ, ¿ljoꞌ ntsꞌaaⁿ quio naⁿꞌñeeⁿ? ");
INSERT INTO amuNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nñoom ndoꞌ nntseicwjeⁿ joona. Ndoꞌ nñeꞌquiaaⁿ ntjom ꞌnaaⁿꞌaⁿ nda̱a̱ ntꞌomcheⁿ nnꞌaⁿ. Jnda̱ na jndyena na seineiⁿ Jesús ñꞌoommeiⁿꞌ, jluena: —Tijoom cwancueeꞌ Tyꞌo̱o̱tsꞌom na caluii na luaaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Sa̱a̱ Jesús nquiee ntyꞌiaaⁿꞌaⁿ nda̱a̱na. Tjeiiⁿꞌeⁿ cwii ñꞌoom na seijoomꞌñe cheⁿnqueⁿ na tsjo̱ꞌ na ya jom. Tsoom: —Quia joꞌ ¿ljoꞌ ñeꞌcaꞌmo̱ⁿ ljeii ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom na mawaa na matsonaꞌ?: Majuu tsjo̱ꞌ na tîcwilꞌueeꞌndye luañeⁿ na cwilꞌa tsiaⁿtsjo̱ꞌ, jnda̱ mameiⁿntyjeeꞌnaꞌ nqui tsiaⁿtsjo̱ꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na tileicatseiꞌno̱ⁿꞌ cantyja ꞌnaⁿya, majuꞌwiꞌnaꞌ juu chaꞌcwijom tsꞌaⁿ na toomñe na tiooñe nacjooꞌ tsjo̱ꞌ. Sa̱a̱ tsꞌaⁿ na tiñeꞌcatseiyuꞌ ñꞌeⁿndyo̱, maxjeⁿ nlcoꞌwiꞌnaꞌ jom. Nntseijomnaꞌ tsaⁿꞌñeeⁿ chaꞌcwijom tsꞌaⁿ na tioo cwii tsjo̱ꞌ tꞌmaⁿ nacjooꞌ, na seitiuujnda̱a̱naꞌ juu. ");
INSERT INTO amuNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Nquiee ntyee na cwiluiitquiendye nda̱a̱ ntyee ñequio nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés, mañejuu xjeⁿꞌñeeⁿ tyolaꞌjnda̱na na nntꞌuena Jesús, ee jlaꞌno̱ⁿꞌna na nacjoo joona seineiiⁿ ñꞌoom na tjañoomꞌwaaꞌ. Sa̱a̱ nquiaana nnꞌaⁿ na jndyendye, ");
INSERT INTO amuNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","joꞌ chii jñoomna nnꞌaⁿ na tyꞌequeⁿ cwenta ñꞌoom na matseineiiⁿ. Tyolꞌa naⁿꞌñeeⁿ na ya nnꞌaⁿndyena, cha nntyꞌiaana aa nntseineiiⁿ ñꞌoom na quio majuutinaꞌ nnda̱a̱ nlaꞌquioona jom lꞌo̱ gobiernom na cuꞌxeⁿ tsaⁿꞌñeeⁿ jom. ");
INSERT INTO amuNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Joo naⁿꞌñeeⁿ taꞌxꞌee nnoom: —ꞌU Maestro na maꞌmo̱o̱ⁿꞌ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom nda̱a̱ nnꞌaⁿ, nquiuuyâ na ndyeyu matseiꞌneiⁿꞌ ndoꞌ ya maꞌmo̱o̱ⁿꞌ meiⁿ tyoocheꞌ na cweꞌ jndaaꞌ ꞌñeeⁿ neiⁿꞌ. Ñeꞌquiiꞌcheⁿ ñꞌoom na mayuuꞌ maꞌmo̱o̱ⁿꞌ cantyja ꞌnaaⁿꞌ natooꞌ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ndoꞌ jeꞌ Ta, ñeꞌcandya̱a̱yâ, ¿aa matsonaꞌ na nñeꞌquiaayâ tsꞌiaaⁿnda̱a̱yâ nnom César, oo aa ticatsa̱ꞌntjomnaꞌ? ");
INSERT INTO amuNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Sa̱a̱ jom seiꞌno̱o̱ⁿꞌo̱ⁿ cweꞌ na ñeꞌcꞌomna cwenta jom. Tsoom nda̱a̱na: —¿Chiuu na ñeꞌcalꞌaꞌyoꞌ na catꞌuiinaꞌ ja? ");
INSERT INTO amuNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Catꞌmo̱ⁿꞌyoꞌ cwii tsjo̱ꞌñjeeⁿ no̱o̱ⁿ. ¿ꞌÑeeⁿ ꞌndyoonnom luaa ndoꞌ ꞌñeeⁿ xueeꞌ ljeiiwaa? Jlue naⁿꞌñeeⁿ: —Nquii César, tsaⁿmaⁿtsꞌiaaⁿ tꞌmaⁿ tsjoom Roma. ");
INSERT INTO amuNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Quia joꞌ tsoom nda̱a̱na: —Catiomꞌyoꞌ tsꞌiaaⁿnda̱a̱ꞌyoꞌ nnom César yuu na tseixmaⁿnaꞌ cwentaaⁿꞌaⁿ, ndoꞌ quiaꞌyoꞌ cwentaaꞌ Tyꞌo̱o̱tsꞌom yuu na tseixmaⁿnaꞌ cwentaaꞌ nqueⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Tîcanda̱a̱ nncꞌomna jom ñꞌeⁿ ñꞌoom na matseineiiⁿ. Yacheⁿ jlaꞌcheⁿna na tjaweeꞌ nꞌomna ñꞌoom na tꞌo̱o̱ⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Jnda̱ joꞌ tquieꞌcañom ntꞌom nnꞌaⁿ saduceos namꞌaaⁿ Jesús. Joona nnꞌaⁿ na cwilue na xocataꞌndoꞌnndaꞌ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Taꞌxꞌeena nnoom, jluena: —ꞌU Maestro na maꞌmo̱o̱ⁿꞌ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom nda̱a̱ nnꞌaⁿ, ꞌndii Moisés ñꞌoom lua̱a̱yâ na matsonaꞌ xeⁿ nncueꞌ cwii tsaⁿsꞌa ndoꞌ nljoñe scoomꞌm na tjaaꞌnaⁿ ntseinda, quia joꞌ tyjee tsꞌooꞌñeeⁿ cocoom ñꞌeⁿ scuuꞌ xioom. Nncꞌom ntseinaaⁿ ñꞌeⁿ yuscuꞌñeeⁿ cha nntseinoomñê na tjaa ntseinda xioom tꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Luaa tuii. Tyomꞌaⁿ ntquieeꞌ naⁿnom ñenquii tsꞌaⁿ ntseinda. Juu tsaⁿtquiee tocoom ndoꞌ tyuaaꞌ tueeⁿꞌeⁿ, tjaa ndana ñꞌeⁿ scoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Jnda̱ chii tsaⁿ na jnda̱ we tocoom ñꞌeⁿ scuuꞌ xioom, ndoꞌ mati jom tueeⁿꞌeⁿ, tjaa ntseinaaⁿ ñꞌeⁿ yuscuꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Quia joꞌ tsaⁿ na jnda̱ ndyee tocoom ñꞌeⁿ yuscuꞌñeeⁿ. Ndoꞌ majoꞌti chaꞌtso ntquieeꞌndyena cwii ndoꞌ cwiindyena toꞌñoomna jom na scuuna ndoꞌ tja̱na. Meiⁿcwii ndana tjaaꞌnaⁿ ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ndoꞌ na cwiimacanda̱ tueꞌ yuscuꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Quia joꞌ quia na nntaꞌndoꞌxco nnꞌaⁿ na jnda̱ tja̱, ¿ꞌñeeⁿ cwiindye joona na saaⁿꞌaⁿ? Ee chaꞌtso ntquieeꞌndye naⁿꞌñeeⁿ scuuna jom. ");
INSERT INTO amuNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Tꞌo̱ Jesús nda̱a̱na, tsoom: —Nnꞌaⁿ tsjoomnancue cwiꞌunco ndoꞌ cwiñeꞌquia nda na cwiꞌunco. ");
INSERT INTO amuNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Sa̱a̱ mꞌaⁿ nnꞌaⁿ na majnda̱ majndaaꞌya na laꞌxmaⁿ na nntaꞌndoꞌxcona na jnda̱ tja̱. Ndoꞌ laꞌxmaⁿna na nncꞌomna tiempo na nncuaaxco tsjoomnancue. Naⁿꞌñeeⁿ taxocꞌuncona, meiⁿ naⁿnom, ndoꞌ meiⁿ naⁿlcu. ");
INSERT INTO amuNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Meiⁿ taxocwjenndaꞌna ee nntseijomnaꞌ joona chaꞌna ángeles. Ndoꞌ ncꞌe na cwicandaana na nntaꞌndoꞌxcona, joꞌ chii matseijomnaꞌ na cwitaꞌndoꞌna chaꞌna wandoꞌ nquii Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Sa̱a̱ cantyja ꞌnaaⁿꞌ na nntaꞌndoꞌxco nnꞌaⁿ na jnda̱ tja̱, maquiiti Moisés tꞌmo̱o̱ⁿ na ljoꞌ ñequio ñꞌoom na seiljeiⁿ cantyja ꞌnaaⁿꞌ tsꞌoom nioom zarza. Naquiiꞌ ñꞌoomꞌñeeⁿ tsoom na Ta Tyꞌo̱o̱tsꞌom cwiluiiñê Tyꞌo̱o̱tsꞌom cwentaaꞌ Abraham, Isaac, ndoꞌ Jacob. ");
INSERT INTO amuNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ee jom nchii cwiluiiñê Tyꞌo̱o̱tsꞌom cwentaa lꞌoo, jom cwentaa nnꞌaⁿ na cwitaꞌndoꞌ. Joꞌ chii maxjeⁿ maꞌmo̱ⁿnaꞌ na chaꞌtso nnꞌaⁿ cwitaꞌndoꞌna cantyja ꞌnaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Cwantindye nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés tꞌo̱o̱na nnoom, jluena: —ꞌU Maestro na maꞌmo̱o̱ⁿꞌ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom nda̱a̱ nnꞌaⁿ majoꞌndyo ñꞌoom matsuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ndoꞌ taticanda̱a̱ꞌ nꞌom nnꞌaⁿ saduceos na cwii nntaꞌxꞌeetina nnoom. ");
INSERT INTO amuNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Tso Jesús nda̱a̱ chaꞌtso nnꞌaⁿ: —¿Chiuu na cwilue nnꞌaⁿ na Cristo cwiluiiñê tsjaaⁿ David na jndyowicantyjooꞌ? ");
INSERT INTO amuNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ee naquiiꞌ libro na chuu Salmos, maquiiti David tsoom: Nquii Ta Tyꞌo̱o̱tsꞌom tsoom nnom juu Ta na matsa̱ꞌntjom ja: “Cajmaⁿꞌ ntyjaaꞌa ntyjaya yuu na matseitꞌmaaⁿꞌñenaꞌ ꞌu, ");
INSERT INTO amuNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","hasta xjeⁿ na jnda̱ tsa̱ꞌa nnꞌaⁿ na jndoo ꞌu na cꞌomna nacje ꞌnaⁿꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Cweꞌ joꞌ mawaxꞌa̱ya nda̱a̱ꞌyoꞌ: —¿Chiuu nntsꞌaayuunaꞌ na cwiluiiñe Cristo tsjaaⁿ David na jndyowicantyjooꞌ ee manquiiti David matsoom na juu cwiluiiñe Ta na matsa̱ꞌntjom jom? ");
INSERT INTO amuNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Luaa ñꞌoom na tsoom nda̱a̱ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê, ñequio na ndye chaꞌtsondye nnꞌaⁿ: ");
INSERT INTO amuNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Queⁿndyoꞌ cwenta na tilꞌaꞌyoꞌ chaꞌna cwilꞌa nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés, ee joona jeeⁿ neiiⁿna na nncoꞌnomna na cweeꞌna liaa na jnda na teiꞌncoo. Ndoꞌ lꞌue nꞌomna na nlaꞌtꞌmaaⁿꞌndye nnꞌaⁿ joona na quia naⁿꞌñeeⁿ na xmaⁿndyena ñequio na jndooꞌ jndye nnꞌaⁿ. Mati na nncwindyuaandyena yuu na matseitꞌmaaⁿꞌñetinaꞌ joona naquiiꞌ lanꞌom. Ndoꞌ na nncwindyuaandyena yuu na yati cwiwiñꞌoomꞌ na waa xuee. ");
INSERT INTO amuNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ndoꞌ cwintyꞌuetyeⁿnquiona ꞌnaaⁿ yolcu na jnda̱ ljondye na tja̱ noom. Juu xjeⁿ na cwilꞌana na ljoꞌ, jeeⁿ teincoo ñꞌoom cwilaꞌneiⁿna nnom Tyꞌo̱o̱tsꞌom cha tino̱o̱ⁿ na ljoꞌ cwilaꞌxmaⁿna. Tꞌmaⁿti lcoꞌwiꞌnaꞌ naⁿꞌñeeⁿ nntsꞌaa Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Mꞌaaⁿ Jesús watsꞌom tꞌmaⁿ, ndoꞌ jleintyꞌiaaⁿꞌaⁿ naⁿtya na cwiñeꞌquia ofrendas cwentaaꞌ Tyꞌo̱o̱tsꞌom. Cwitioomna joonaꞌ tsꞌom castom. ");
INSERT INTO amuNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Mati ntyꞌiaaⁿꞌaⁿ cwii yuscu na jnda̱ ljoñe, na jeeⁿ jñeeⁿꞌñe. Tsaⁿꞌñeeⁿ tjacjoomꞌm we tsjo̱ꞌñjeeⁿ na ticajndanaꞌ joꞌ joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Tso Jesús: —Mayuuꞌcheⁿ nndyeꞌyoꞌ nntsjo̱o̱, yuscumꞌaaⁿꞌ na jnda̱ ljoñe, ndoꞌ jñeeⁿꞌñê, sa̱a̱ tꞌmaaⁿꞌti tquiaaⁿ cwentaaꞌ Tyꞌo̱o̱tsꞌom, nchiiti na tquia chaꞌtsondye ntꞌomcheⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ee chaꞌtso naⁿmꞌaⁿꞌ cweꞌ na waljooꞌ tueeꞌna na cwiñeꞌquiana nnom Tyꞌo̱o̱tsꞌom, sa̱a̱ yuscumꞌaaⁿ meiiⁿ na jñeeⁿꞌñê, tjuꞌñꞌeeⁿ mandi cantyja na nlcwaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Tyolaꞌneiⁿ ntꞌom nnꞌaⁿ cantyja ꞌnaaⁿꞌ watsꞌom tꞌmaⁿ na jeeⁿ chjoomnaꞌ ñequio ljo̱ꞌ na neiⁿncooꞌ ndoꞌ ñequio ꞌnaⁿ na ya na cwiñeꞌquia nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Tsoom: —Chaꞌtso na cwintyꞌiaꞌyoꞌ nmeiⁿꞌ, manncueꞌntyjo̱ xuee na nntyuiiꞌñꞌeⁿnaꞌ. Taxocaljooꞌ cwii tsjo̱ꞌ nacjooꞌ xꞌiaaꞌnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Quia joꞌ taꞌxꞌeena nnoom: —ꞌU Maestro na maꞌmo̱o̱ⁿꞌ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom nda̱a̱ nnꞌaⁿ, ¿cwaaⁿ nluii na luaaꞌ? Ndoꞌ ¿cwaaⁿ cwii ꞌnaaⁿ mꞌmo̱ⁿnaꞌ na jnda̱ teinndyooꞌ nluii nmeiⁿꞌ? ");
INSERT INTO amuNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Tsoom nda̱a̱na: —Queⁿꞌyoꞌ cwenta cha tinquioꞌnnꞌaⁿ nnꞌaⁿ ꞌo. Ee jndye nnꞌaⁿ nlquieꞌcañom na nlue na joona cwiluiindyena Cristo. Nluena: “Ja cwiluiindyo̱ Cristo”, ndoꞌ nluena: “Jeꞌ jnda̱ tueꞌntyjo̱ xjeⁿ.” Sa̱a̱ ꞌo tilajomndyoꞌ ñequio naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Meiⁿ tilaꞌcatyuendyoꞌ quia na cwindyeꞌyoꞌ na nndyocwjeꞌcañoom ntiaꞌ ndoꞌ cwilaꞌwendye nnꞌaⁿ nacjoo gobiernom ꞌnaaⁿna. Ee jndeiꞌnaꞌ na nmeiⁿꞌ cwinomjndyee, sa̱a̱ tyooweꞌntyjo̱ xjeⁿ na nntsuu tsjoomnancue. ");
INSERT INTO amuNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ndoꞌ tsotyeeⁿcheⁿ nda̱a̱na: —Nlaꞌwendye nnꞌaⁿ cwii ndyuaa nacjoo nnꞌaⁿ cwiicheⁿ ndyuaa. Ndoꞌ cwii tsaⁿmaⁿtsꞌiaaⁿ tꞌmaⁿ nntseiweñê nacjooꞌ cwiicheⁿ tsaⁿmaⁿtsꞌiaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Jndye joo jndeii nntsꞌeii ndoꞌ nncꞌoom jndoꞌ ntꞌmaⁿ ñequio ntycu na wjaatcuuñenaꞌ. Ndoꞌ tꞌmaⁿ nlaꞌcatyuendye nnꞌaⁿ na nntyꞌiaana jndye ꞌnaaⁿ tꞌmaⁿ na nleitquiooꞌ tsjo̱ꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","’Sa̱a̱ cwii tjo̱o̱cheⁿ na nluii chaꞌtso nmeiⁿꞌ, nntꞌue nnꞌaⁿ ꞌo nawiꞌ ndoꞌ nleiꞌntyjo̱na ꞌo ndoꞌ mati nñeꞌquiana cwenta ꞌo nda̱a̱ nnꞌaⁿ naquiiꞌ lanꞌom nchꞌu ndoꞌ nntioomna ꞌo lꞌaancjo. Ndoꞌ nncꞌoochona ꞌo jo nda̱a̱ nnꞌaⁿ na cwitsa̱ꞌntjom ñequio naⁿmaⁿnꞌiaaⁿ tꞌmaⁿ, cweꞌ cantyja ꞌnaaⁿꞌ xueya. ");
INSERT INTO amuNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Quia na nntjomꞌyoꞌ nmeiⁿꞌ nncjuꞌnaaⁿñenaꞌ na nntjeiꞌyuuꞌndyoꞌ cantyja ꞌnaⁿya. ");
INSERT INTO amuNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Calaꞌjndaaꞌndyoꞌyaꞌyoꞌ na tincꞌoomꞌ nꞌomꞌyoꞌ cwaaⁿ ñꞌoom na nntꞌo̱ꞌyoꞌ cha nncwañoomꞌnaꞌ ꞌo, ");
INSERT INTO amuNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ee xjeⁿꞌñeeⁿ nnco̱ nncwjaaꞌndyo̱ ñꞌoom quiiꞌ ndyueꞌyoꞌ ndoꞌ nñequia na jndo̱ꞌ nꞌomꞌyoꞌ hasta meiⁿcwiindye joo nnꞌaⁿ na jndoo ꞌo xonda̱a̱ nluena na tilꞌue ñꞌoom na nnduꞌyoꞌ meiⁿ na nluena na tiyuuꞌnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Mati lotyeꞌyoꞌ, londyeeꞌyoꞌ, ntyjeeꞌyoꞌ, nnꞌaⁿꞌyoꞌ, nnꞌaⁿ na ya ñꞌoom ꞌo ñꞌeⁿndye, nñeꞌquiana cwenta ꞌo luee nnꞌaⁿ ndoꞌ ntꞌomndyoꞌ nlaꞌcwjee naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Chaꞌtsondye nnꞌaⁿ nncꞌomna na ticueeꞌ nꞌomna ꞌo cweꞌ ncꞌe na mꞌaⁿꞌyoꞌ cantyja ꞌnaaⁿꞌ xueya. ");
INSERT INTO amuNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Sa̱a̱ xocaꞌndiya na nntsuundyoꞌ. Hasta meiⁿ cweꞌ cwii soonqueⁿꞌyoꞌ xocatsuunaꞌ ñꞌeⁿndyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ndoꞌ ncꞌe na ticaꞌndyencꞌuaaꞌndyoꞌ nntoꞌñoomꞌyoꞌ na ticantycwii na nntandoꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","’Sa̱a̱ quia na nntyꞌiaꞌyoꞌ na cwitjaaꞌndye sondaro tsei ndiocheⁿ Jerusalén, quia joꞌ calaꞌno̱ⁿꞌyoꞌ na jnda̱ tueꞌntyjo̱ xjeⁿ na nntyuiiꞌ tsjoomꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Quia ljoꞌ nnꞌaⁿ na mꞌaⁿ tsꞌo̱ndaa Judea, cꞌooleinomna, cꞌoona quiiꞌ ntsjo̱. Ndoꞌ nnꞌaⁿ na mꞌaⁿ quiiꞌ tsjoomꞌñeeⁿ caluiꞌna joꞌ joꞌ. Ndoꞌ nnꞌaⁿ na mꞌaⁿ jo jnda̱a̱ tincꞌoolcweꞌna tsjoomꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Ee quia joꞌ ncuee na cwitioomndye nnꞌaⁿ cantyja na wiꞌndyena cha nntseicanda̱a̱ꞌñenaꞌ chaꞌtso ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na jnda̱ teiljeii. ");
INSERT INTO amuNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Ntyꞌiaandye yolcu na ndeiindye joo ncueeꞌñeeⁿ ñequio yolcu na ꞌndaandye nda. Ee nnquioo cwii nawiꞌ tꞌmaⁿ nacjoo nnꞌaⁿ tyuaawaa ndoꞌ jeeⁿ tꞌmaⁿ nawiꞌ na nntꞌuiinaꞌ joona. ");
INSERT INTO amuNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Nncwjena ñꞌeⁿ xjo ndoꞌ ntꞌom nncꞌoocho nnꞌaⁿ pra̱so na ticwii cwii ndyuaa. Ndoꞌ nnꞌaⁿ na nchii judíos nlco̱ꞌna tsjoom Jerusalén jndye xuee, hasta nncueeꞌ xjeⁿ na jnda̱ seijndaaꞌñe Tyꞌo̱o̱tsꞌom na nncjaawintyjeeꞌ na cwiluii na ljoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","’Tꞌmaⁿ ꞌnaaⁿ nleitquiooꞌ nntyꞌiaa nnꞌaⁿ nnom ñeꞌquioomꞌ ñꞌeⁿ chiꞌ ñꞌeⁿ cancjuu. Ndoꞌ nnom tsjoomnancue tꞌmaⁿ nntseiꞌndaaꞌnaꞌ nꞌom nnꞌaⁿ. Nntseiñꞌeeⁿꞌnaꞌ joona quia na nndyena na jeeⁿ cꞌuaa manquiuuꞌ nmo̱ⁿ ndaaluee, nntseicatyꞌuenaꞌ joona. ");
INSERT INTO amuNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nntsꞌaanaꞌ na tajndeiiꞌ nꞌomna ncꞌe na cwicatyuena ñequio na mꞌaaⁿꞌticheⁿ nꞌomna chiuu cwii wjaachꞌeetinaꞌ nnom tsjoomnancue. Ee nntseicwachuuꞌñenaꞌ chaꞌtso ꞌnaⁿ najnda̱ na matseixmaⁿ tsjo̱ꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Quia ljoꞌcheⁿ nntyꞌiaana ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee na macwja̱caño̱o̱ⁿnndaꞌa tsjoomnancue. Nndyo̱o̱ naquiiꞌ nchquiu ñequio najndeii na matseixmaⁿya ndoꞌ ñequio na neiⁿncooꞌ nacaxuee na cwiluiitꞌmaⁿndyo̱. ");
INSERT INTO amuNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Quia na jnda̱ jnaⁿnaꞌ na cwiluii chaꞌtso nmeiⁿꞌ, cꞌomtꞌmaaⁿꞌndyoꞌ nꞌomꞌyoꞌ, cꞌomꞌcꞌeendyoꞌ ee jnda̱ teindyooꞌ na nluinꞌmaaⁿndyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Mati seineiiⁿ ñꞌoom na tjañoomꞌ nda̱a̱na, tsoom: —Calaꞌno̱ⁿꞌyoꞌ cantyja ꞌnaaⁿꞌ tsꞌoom higuera ndoꞌ chaꞌtso ntꞌomcheⁿ nꞌoom. ");
INSERT INTO amuNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Quia cwintyꞌiaꞌyoꞌ na jnda̱ macwicaluiꞌ tscooꞌnaꞌ, cwilaꞌno̱ⁿꞌyoꞌ na jnda̱ teindyooꞌ ncueesuaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Mati quia na cwintyꞌiaꞌyoꞌ na cwiluii chaꞌtso nmeiⁿꞌ, calaꞌno̱ⁿꞌyoꞌ na jnda̱ teindyooꞌ mꞌaaⁿnaꞌ na nntsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","’Candyeꞌyoꞌ nntsjo̱o̱, mayuuꞌcheⁿ na xocwjeñꞌeⁿ nnꞌaⁿ na mꞌaⁿ jeꞌ hasta xjeⁿ na jnda̱ seicanda̱a̱ꞌñenaꞌ chaꞌtso ñꞌoommeiⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Tsjo̱ꞌluee ñꞌeⁿ tsjoomnancue nntycwiiñꞌeⁿnaꞌ sa̱a̱ juu ñꞌoom ꞌnaⁿya tijoom cwinomꞌnaꞌ juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","’Calꞌandyoꞌ cwenta na tincjaachunaꞌ ꞌo na ñoomñoom na nlꞌaꞌyoꞌ, oo na nncꞌomꞌyoꞌ na candyeꞌyoꞌ, oo na nncuaa ñꞌomtiuu ꞌnaⁿꞌyoꞌ ꞌnaⁿ na macaⁿnaꞌ ꞌo. Cha tintsꞌaanaꞌ na ticꞌomcꞌeendyoꞌ ndoꞌ majndeiito nncwjeeꞌcañoom xueeꞌñeeⁿ ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Tintjomꞌyoꞌ chaꞌcwijom na nnquioo cwii teincoꞌ ee nntꞌuiinaꞌ nnꞌaⁿ na mꞌaⁿ chaꞌwaa nnom tsjoomnancue. ");
INSERT INTO amuNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Joꞌ chii cꞌomꞌcꞌeendyoꞌ chaꞌwaa xuee na mꞌaⁿꞌyoꞌ. Ndoꞌ calatyꞌoondyoꞌ nnom Tyꞌo̱o̱tsꞌom cha nncꞌoom jndeiiꞌ nꞌomꞌyoꞌ na nnda̱a̱ nnaⁿndyoꞌ nawiꞌ na quia nndyo, ndoꞌ nnda̱a̱ nncwintyjeꞌtyeⁿꞌyoꞌ jo no̱o̱ⁿ na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Naxuee tyoꞌmo̱ⁿ Jesús nda̱a̱ nnꞌaⁿ naquiiꞌ watsꞌom tꞌmaⁿ. Ndoꞌ quia tmaaⁿ tyocalueeⁿꞌeⁿ, tyocaⁿ ta na jndyu Olivos. ");
INSERT INTO amuNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ndoꞌ chaꞌtso nnꞌaⁿ cwitsjoom tyoquiena watsꞌom tꞌmaⁿ na nndyena ñꞌoom na nñequiaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Majnda̱ jaawindyooꞌ nncueeꞌ xuee pascua na cwicwaꞌ nnꞌaⁿ judíos tyooꞌ na tjaa ndaaljoꞌ tjaquieeꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ndoꞌ ntyee na cwiluiitquiendye nda̱a̱ ntyee ñequio nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés, cweꞌ ntyꞌiu tyolꞌueendyena chiuu ya cha nnda̱a̱ nlaꞌcueeꞌna Jesús, ee nquiaana nnꞌaⁿ na neiiⁿ jom. ");
INSERT INTO amuNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Xjeⁿꞌñeeⁿ tuo̱ Satanás naquiiꞌ tsꞌom Judas, tsaⁿ na mati jndyu Iscariote. Jom cwii joo nnꞌaⁿ na canchooꞌwendye. ");
INSERT INTO amuNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Tjaaⁿ na mꞌaⁿ ntyee na cwiluiitquiendye nda̱a̱ ntyee quiiꞌntaaⁿ nnꞌaⁿ judíos, ñꞌeⁿ nnꞌaⁿ na cwijndooꞌ tsꞌiaaⁿ na cwiluii watsꞌom. Tjatseijndaaꞌñê chiuu ya nntsꞌaaⁿ na nñequiaaⁿ cwenta Jesús lueena. ");
INSERT INTO amuNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ndoꞌ naⁿꞌñeeⁿ jeeⁿ jlaꞌneiiⁿꞌndyena, tjoomꞌ tꞌmaⁿna na nñeꞌquiana sꞌom nnoom. ");
INSERT INTO amuNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Mati jom seijomñê na ljoꞌ. Tyolꞌueeⁿ cwaaⁿ nncjuꞌnaaⁿñenaꞌ na nñequiaaⁿ cwenta Jesús lueena xjeⁿ na ticajndooꞌ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Tueꞌntyjo̱ ncuee na cwicwaꞌ nnꞌaⁿ judíos tyooꞌ na tjaa ndaaljoꞌ tjaquieeꞌ. Ncueeꞌñeeⁿ macaⁿnaꞌ na calaꞌcwjeena canmaⁿ cantyja ꞌnaaⁿꞌ ncuee pascua. ");
INSERT INTO amuNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ndoꞌ jñom Jesús Pedro ñequio Juan, tsoom nda̱a̱na: —Catsaꞌyoꞌ, nlajndaaꞌndyoꞌ yuu na nlcwaaꞌa cantyja ꞌnaaⁿꞌ ncuee pascua. ");
INSERT INTO amuNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Taꞌxꞌeena nnoom: —¿Yuu lꞌue tsꞌomꞌ na nlajndaaꞌndyô̱? ");
INSERT INTO amuNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Tꞌo̱o̱ⁿ nda̱a̱na: —Quia na jnda̱ saaquieꞌyoꞌ naquiiꞌ tsjoomwaꞌñeⁿ, nntjomndyoꞌ cwii tsaⁿsꞌa na ñꞌoom tsjoo na ñjom ndaa. Catsaantyjo̱ꞌyoꞌ naxeeⁿꞌeⁿ hasta na nncueⁿꞌeⁿ wꞌaa yuu na nncjaaqueⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Joꞌ joꞌ canduꞌyoꞌ nnom tsꞌaⁿ na waaꞌ wꞌaaꞌñeeⁿ: “Nquii tsꞌaⁿ na maꞌmo̱ⁿ nda̱a̱ya mawaxꞌeeⁿ: ¿Yuu waa cuarto na nlcwaaꞌâ cwentaaꞌ xuee pascua ñequio nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿndyo̱?” ");
INSERT INTO amuNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Quia joꞌ juu tsaⁿꞌñeeⁿ mꞌmo̱o̱ⁿ nda̱a̱ꞌyoꞌ cwii cuarto tꞌmaⁿ, wꞌaa nandye na maniomcanda̱a̱ꞌ ꞌnaⁿ. Joꞌ joꞌ calajndaaꞌndyoꞌyaꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Tyꞌena ndoꞌ jliuna chaꞌxjeⁿ na tsoom. Ndoꞌ jlaꞌjndaaꞌndyena na nlcwaꞌna, nntquiina catsmaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Quia na jnda̱ tmaaⁿ, tueꞌcañoom Jesús, tjacjom nacañoomꞌ meiⁿsa ñequio canchooꞌwe nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Tsoom nda̱a̱na: —Jeeⁿ ntyjaaꞌ tsꞌo̱o̱ⁿya na nlcwaaꞌa nantquie pascuawaa ñꞌeⁿndyoꞌ cwii tjo̱o̱cheⁿ na nncꞌio̱. ");
INSERT INTO amuNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ee candyeꞌyoꞌ nntsjo̱o̱, taxocwaꞌnndaꞌa juunaꞌ hasta xjeⁿ na jnda̱ seicanda̱a̱ꞌñenaꞌ yuu na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jnda̱ joꞌ toꞌñoom cwii waso, jnda̱ chii tquiaaⁿ na quianlꞌuaaꞌ Tyꞌo̱o̱tsꞌom ndoꞌ tsoom nda̱a̱na: —Catoꞌñoomꞌyoꞌ wasowaa, caluiꞌ cjaanaꞌ cwii ndoꞌ cwiindyoꞌ, cweꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ee candyeꞌyoꞌ nntsjo̱o̱, jeꞌ na cwii wjaatinaꞌ, taxocꞌua ndaawinom hasta quia nncueꞌntyjo̱ xjeⁿ na nntsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ndoꞌ toꞌñoom tyooꞌ, tquiaaⁿ na quianlꞌuaaꞌ Tyꞌo̱o̱tsꞌom, jnda̱ chii tyjeeⁿ juunaꞌ, tquiaaⁿ nda̱a̱na. Tsoom: —Tyooꞌwaa cwiluiiñenaꞌ seiiꞌa na mañequiaandyo̱ na nncꞌio̱. Luaaꞌ nntsaalꞌaꞌyoꞌ na cwicañjom nꞌomꞌyoꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Jnda̱ na tcwaꞌna tyooꞌñeeⁿ, majoꞌti sꞌaaⁿ, toꞌñoom waso. Tsoom: —Juu ndaa winom na ñjom wasowaa tseixmaⁿnaꞌ ñꞌoom xco na maqua̱ⁿtya̱ⁿ ñequio nioomꞌa na nnquioo cwentaꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","’Sa̱a̱ queⁿꞌyoꞌ cwenta, ñeꞌcwii meiⁿsa na cañomꞌ meindyuaandyo̱ ñequio tsꞌaⁿ na mañequiaa cwenta ja. ");
INSERT INTO amuNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ndoꞌ ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee, mayuuꞌcheⁿ manntjo̱ⁿ chaꞌxjeⁿ na jnda̱ teijndaaꞌ cantyja ꞌnaⁿya, sa̱a̱ nntꞌuiiwiꞌnaꞌ juu tsꞌaⁿ na mañequiaa cwenta ja. ");
INSERT INTO amuNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Quia joꞌ to̱ꞌna na tyotaꞌxꞌeendyena nda̱a̱na, ꞌñeeⁿ cwiindye joona na nntsꞌaa na ljoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Mati jlaꞌñꞌeeⁿꞌ ndyueena ꞌñeeⁿ cwiindye joona na nncꞌoom na tꞌmaⁿñeti. ");
INSERT INTO amuNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Sa̱a̱ jom tsoom nda̱a̱na: —Nnꞌaⁿ na mꞌaⁿ nꞌiaaⁿ tsjoomnancuewaa ñequio nnꞌaⁿ na cwitsa̱ꞌntjom, cwinchjeena nnꞌaⁿ na cwindyeꞌntjom nda̱a̱na, sa̱a̱ cwilaꞌcajndyu yoꞌñeeⁿ joona nnꞌaⁿ na ya cwilꞌa. ");
INSERT INTO amuNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Sa̱a̱ quiiꞌntaaⁿꞌ ꞌo nchii luaaꞌ nncuaa. Ee juu tsꞌaⁿ na cwiluiitquieñeti cꞌoom chaꞌna tsꞌaⁿ na cje tseixmaⁿ. Ndoꞌ tsꞌaⁿ na matsa̱ꞌntjom cꞌoom chaꞌna tsꞌaⁿ na mandiꞌntjom. ");
INSERT INTO amuNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ee ¿ꞌñeeⁿ cwiluiitꞌmaⁿñeti, aa juu tsꞌaⁿ na wacatyeeⁿ nacañoomꞌ meiⁿsa, oo aa juu tsꞌaⁿ na mandiꞌntjom joꞌ joꞌ? ¿Aa nchii maxjeⁿ juu tsꞌaⁿ na wacatyeeⁿ nacañoomꞌ meiⁿsa? Sa̱a̱ queⁿꞌyoꞌ cwenta, ja mꞌaaⁿya quiiꞌntaaⁿꞌyoꞌ na mandiꞌntjo̱ⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","’ꞌO ñequiiꞌcheⁿ ñꞌeⁿꞌyoꞌ ñꞌeⁿndyo̱ chaꞌtsoti na maqueⁿnaꞌ xjeⁿ ja. ");
INSERT INTO amuNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Joꞌ chii chaꞌxjeⁿ na tqueⁿtyeⁿ Tsotya̱ya ñꞌoom na ja nntsa̱ꞌntjo̱ⁿ, malaaꞌtiꞌ maqua̱ⁿ na ꞌo nntsa̱ꞌntjomꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Yuu na nntsa̱ꞌntjo̱ⁿya, joꞌ nñequiaya na nlcwaꞌyoꞌ ndoꞌ nncweꞌyoꞌ ñꞌeⁿndyo̱ cañoomꞌ meiⁿsa ꞌnaⁿya. Ndoꞌ nncwindyuaandyoꞌ ntio yuu na nntuꞌxeⁿꞌyoꞌ canchooꞌwe ntmaaⁿꞌ nnꞌaⁿ Israel. ");
INSERT INTO amuNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Tso ta Jesús: —ꞌU Simón, queⁿꞌ cwenta, jnda̱ tcaⁿ Satanás ñꞌoom na nntseiteiꞌncweeⁿꞌeⁿ ꞌo chaꞌna matseicueeñe tsꞌaⁿ lqueeⁿ trigo, ");
INSERT INTO amuNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","sa̱a̱ ja jnda̱ ñesꞌaa tyꞌoo nnom Tyꞌo̱o̱tsꞌom cantyja ꞌnaⁿꞌ cha tintseintycwiinaꞌ na matseiꞌyuꞌyaꞌ tsꞌomꞌ. Ndoꞌ xeⁿ jnda̱ tcoꞌndyuꞌxcweꞌnndaꞌ, quiaaꞌ ñꞌoom tꞌmaⁿ tsꞌom nda̱a̱ nnꞌaⁿꞌ nmeiiⁿ na cwilaꞌyuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Tꞌo̱ Simón nnoom, matso: —Ta, mꞌaaⁿcꞌeendyo̱ na nncjo̱ wꞌaancjo ñꞌeⁿndyuꞌ. Ndoꞌ tintsꞌaa meiiⁿ na nncꞌio̱ ñꞌeⁿndyuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Tso Jesús nnoom: —Aa ndiꞌ, Pedro, njomꞌ matsjo̱o̱, cwii tjo̱o̱cheⁿ na nntseixuaa caxtijndyo jeꞌjeꞌcheⁿ, sa̱a̱ ꞌu xjeⁿꞌñeeⁿ jnda̱ ndyee ndiiꞌ macwjiꞌndyuꞌ na ticwajnaⁿꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Tso Jesús nda̱a̱na: —Quia na jño̱o̱ⁿya ꞌo na saanquiaꞌyoꞌ ñꞌoom ꞌnaⁿya, tsjo̱o̱ na tîcatsañꞌomꞌyoꞌ tsjo̱ꞌñjeeⁿ, meiⁿ chetsjaꞌ, meiⁿ lcoom, ¿aa waa na seitjo̱o̱naꞌ ꞌo? Jluena nnoom: —Meiⁿcwii tjaaꞌnaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Tsotyeeⁿcheⁿ nda̱a̱na: —Sa̱a̱ jeꞌ, ꞌñeeⁿ juu na maleiñꞌoom ꞌnaⁿ na cwicañjom sꞌom, cjaañꞌoom juunaꞌ ndoꞌ mati chetsjaꞌ. Ndoꞌ ꞌñeeⁿ juu na tjaaꞌnaⁿ xjo espada, cajnda̱a̱ liaatco ꞌnaaⁿꞌ, chii cꞌoom xjooꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ee candyeꞌyoꞌ nntsjo̱o̱, maxjeⁿ jndeiꞌnaꞌ na catseicanda̱a̱ꞌñenaꞌ ljeii na mawaa cantyja ꞌnaⁿya na matsonaꞌ: “Tjeiiꞌna cwenta na ljoꞌyu wiꞌñê chaꞌxjeⁿ nnꞌaⁿ na wiꞌndye.” ");
INSERT INTO amuNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Jluena nnoom: —Ta, cantyꞌiaꞌ, luaa mawaa we xjo espadas. Tꞌo̱o̱ⁿ nda̱a̱na, tsoom: —Maleiꞌtyeⁿ luaaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Quia joꞌ jlueeⁿꞌeⁿ wꞌaa yuu na tcwaꞌna, tjaaⁿ ta na jndyu Olivos yuu na maxjeⁿ quicaⁿ. Ndoꞌ nnꞌaⁿ na cwilaꞌjomndye ñꞌoomꞌm, mandiꞌntyjo̱na naxeeⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Quia na tquiena joꞌ joꞌ, tsoom nda̱a̱na: —Calaneiⁿꞌyoꞌ nnom Tyꞌo̱o̱tsꞌom cha juu na ñequeⁿnaꞌ xjeⁿ ꞌo tincwantjomnaꞌ ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ndoꞌ teiño̱o̱ⁿ nacañoomna, tjaaⁿ chaꞌna tquia na nncjuꞌ tsꞌaⁿ cwii tsjo̱ꞌ. Tcoomꞌm xtyeeⁿ ndoꞌ seineiiⁿ nnom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Tsoom: —Tsotya̱ya, xeⁿ ꞌu lꞌue tsꞌomꞌ, catseicandyaandyuꞌ ja nawiꞌwaa. Sa̱a̱ ticaluii ljoꞌ na lꞌue tsꞌo̱o̱ⁿ ja, caluii ljoꞌ na lꞌue tsꞌomꞌ nncuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ndoꞌ xjeⁿꞌñeeⁿ tyjeꞌcañoom cwii ángel nacañomꞌm na jnaⁿ cañoomꞌluee na tyoñequiaa najneiⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yocheⁿ na tyotseiꞌndaaꞌnaꞌ tsꞌoom, tyoqueⁿñetyeeⁿ na tyotseineiiⁿ nnom Tyꞌo̱o̱tsꞌom ñequio chaꞌwaa najneiⁿ. Ndoꞌ ndaatmeiiⁿꞌeⁿ tyotseijomnaꞌ chaꞌna tꞌmaⁿ ndaateiⁿ niomꞌ, ñecwii ndiiꞌ cwiꞌiuunaꞌ xjeⁿ nomtyuaacheⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Quia na jnda̱ teicantyjaaⁿ na seineiiⁿ nnom Tyꞌo̱o̱tsꞌom, tjantyjaaⁿꞌaⁿ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿñê ndoꞌ ljeiiⁿ na cwindana. Ee tîcanaⁿndyena na jeeⁿ chjooꞌ nꞌomna. ");
INSERT INTO amuNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Tsoom nda̱a̱na: —¿Chiuu na cwindaꞌyoꞌ? Quicantyjaꞌyoꞌ, calaneiⁿꞌyoꞌ nnom Tyꞌo̱o̱tsꞌom cha juu na ñeꞌqueⁿnaꞌ xjeⁿ ꞌo, tincjaachuunaꞌ ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Ndicwaⁿ matseineiⁿ Jesús ndoꞌ tquieꞌcañom nnꞌaⁿ na jndyendye. Jo nda̱a̱ naⁿꞌñeeⁿ wjaajndyee Judas, cwii joo nnꞌaⁿ na canchooꞌwe. Seicandyooꞌñê nacañoomꞌ Jesús na nncꞌom ntsmaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Tso Jesús nnoom: —ꞌU Judas, ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee, ¿aa maꞌtiooꞌ cwenta ja luee nnꞌaⁿ ñequio na maꞌuaꞌ ntsmaaⁿꞌa? ");
INSERT INTO amuNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ndoꞌ nnꞌaⁿ na ñꞌeeⁿ ñꞌeⁿñê, quia na ntyꞌiaana chiuu wjaachꞌeenaꞌ, jluena nnoom: —Ta, ¿aa mañejom nntua̱a̱ꞌa xjo? ");
INSERT INTO amuNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ndoꞌ cwii joona mañoomꞌ seiquieeꞌñe mosooꞌ tyee na cwiluiitquieñe. Tyjee tsuaꞌqui tsaⁿꞌñeeⁿ ntyjaya. ");
INSERT INTO amuNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Quia joꞌ tso Jesús nda̱a̱na: —Maya, caꞌndyeꞌyoꞌ. Ndoꞌ tyenquioomꞌm tsuaꞌqui tsaⁿꞌñeeⁿ, seinꞌmaaⁿ juu. ");
INSERT INTO amuNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ndoꞌ nnꞌaⁿ na tquio nacjoomꞌm, joo ntyee na cwiluiitquiendye ñequio nnꞌaⁿ na cwijndooꞌ tsꞌiaaⁿ cwentaaꞌ watsꞌom, ñequio nnꞌaⁿ na cwiluiitquiendye naquiiꞌ tsjoom, tsoom nda̱a̱ naⁿꞌñeeⁿ: —Jndaꞌjom ñequio ncjo espadas ndoꞌ ñꞌeⁿ nꞌoom nchꞌio na tquioꞌyoꞌ nacjoya. Ndooꞌ na tquiocꞌomꞌyoꞌ cwii tsaⁿcanchꞌue. ");
INSERT INTO amuNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ꞌIo ndii ꞌio tyomꞌaaⁿya quiiꞌntaaⁿꞌyoꞌ naquiiꞌ watsꞌom tꞌmaⁿ meiⁿ tîcatꞌueꞌyoꞌ ja. Sa̱a̱ jeꞌ jeꞌ jnda̱ tueꞌntyjo̱ na juu na jaaⁿñe maqueⁿnaꞌ xjeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jnda̱ na tꞌue naⁿꞌñeeⁿ jom, tyꞌeñꞌomna jom waaꞌ tyee na cwiluiitquieñe. Ndoꞌ Pedro tjantyjo̱o̱ⁿ tquiacheⁿ tquia. ");
INSERT INTO amuNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Joꞌ joꞌ jlaꞌntjoomndye nnꞌaⁿ chom tachꞌeⁿ, tyomeindyuaandyena ndiocheⁿ nacañoomꞌ chom. Ndoꞌ mati Pedro tjacjom quiiꞌntaaⁿna. ");
INSERT INTO amuNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Cwii yuscu na mandiꞌntjom ljeii jom na wacatyeeⁿ ꞌndyoo chom, jeeⁿ nquiee ntyꞌiaaꞌ nnoom ndoꞌ tso: —Mati tsaⁿmꞌaaⁿ ñeñꞌeeⁿ ñꞌeⁿ tsaⁿmꞌaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Sa̱a̱ jom tjeiꞌñê, tsoom: —Jeeⁿ ꞌu yuscu ticwajnaⁿꞌa tsaⁿmꞌaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Tyoowiquiuuꞌ ljeii cwiicheⁿ tsꞌaⁿ jom, tso nnoom: —ꞌU, maxjeⁿ cwiindye joona. Sa̱a̱ tꞌo̱o̱ⁿ: —Nchii joꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Jnda̱ tjawiquiuuꞌticheⁿ, chaꞌna cwii hora, cwiicheⁿ tsꞌaⁿ tyotseijndeiiꞌ ꞌndyoo, tso: —Tsaⁿmꞌaaⁿ, mayuuꞌcheⁿ ñeñꞌeeⁿ ñꞌeⁿ tsaⁿmꞌaaⁿꞌ ee tsꞌaⁿ tsꞌo̱ndaa Galilea jom. ");
INSERT INTO amuNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Tꞌo̱ Pedro nnom: —Ja re, meiⁿchjoo ticaljeii ñꞌoom na matsuꞌ. Ndicwaⁿ matseineiiⁿ ñꞌeⁿ tsaⁿꞌñeeⁿ ndoꞌ seixuaa caxtijndyo. ");
INSERT INTO amuNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Quia joꞌ taqueⁿ Ta Jesús ndyeyu jo ndoꞌ na mꞌaaⁿ Pedro ndoꞌ ntyꞌiaaꞌ nnoom. Ndoꞌ mañoomꞌ tjañjoomꞌ tsꞌoom ñꞌoom na jnda̱ tso nnoom: “Cwii tjo̱o̱cheⁿ na nntseixuaa caxtijndyo jeꞌjeꞌcheⁿ sa̱a̱ xjeⁿꞌñeeⁿ ꞌu jnda̱ ndyee ndiiꞌ macwjiꞌndyuꞌ ñꞌeⁿndyo̱.” ");
INSERT INTO amuNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Quia joꞌ mana jluiꞌ Pedro quiiꞌntaaⁿ naⁿꞌñeeⁿ. Jeeⁿcheⁿ ndyaꞌ tyotyꞌioom na jnda ntyjeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Nnꞌaⁿ na tyolꞌa cwenta Jesús, tyolaꞌjnaaⁿꞌna ndoꞌ tyotjaaꞌna jom. ");
INSERT INTO amuNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Mati tyolaꞌtyeⁿna liaa nnoom, tyotmeiiⁿꞌna ndaꞌ nnoom ndoꞌ tyoluena: —Cjaaweeꞌ ꞌndyoꞌ ꞌñeeⁿ juu macwjaꞌ ꞌu. ");
INSERT INTO amuNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ndoꞌ jndye ñꞌoom ticueeꞌ tsꞌom tyoluena nacjoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Quia na jnda̱ teixuee, tjomndye ntyee na cwiluiitquiendye nda̱a̱ ntyee ñequio nnꞌaⁿ na cwijndooꞌ tsꞌiaaⁿ watsꞌom tꞌmaⁿ ñequio nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés. Tyꞌeñꞌomna Jesús na mꞌaⁿ nnꞌaⁿ na cwiluiindyena nꞌiaaⁿ nda̱a̱ nnꞌaⁿ judíos. Jlue naⁿꞌñeeⁿ nnoom: ");
INSERT INTO amuNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Catsuꞌ nda̱a̱yâ, ¿aa ꞌu cwiluiindyuꞌ Cristo? Jom tꞌo̱o̱ⁿ nda̱a̱na: —Meiiⁿ xeⁿ na nntsjo̱o̱ nda̱a̱ꞌyoꞌ, sa̱a̱ xocalaꞌyuꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ndoꞌ meiiⁿ xeⁿ na cwaxꞌa̱ya nda̱a̱ꞌyoꞌ, ꞌo xocatꞌo̱ꞌyoꞌ ꞌndyo̱, xocalacandyaandyoꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Sa̱a̱ jeꞌ xuee na cwii wjaanaꞌ, ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee nncjo̱cajmaⁿ ntyjaaꞌ Tyꞌo̱o̱tsꞌom ntyjaya yuu na matseitꞌmaaⁿꞌñetinaꞌ ja. Joꞌ joꞌ nntseijomndyo̱ ñꞌeⁿñê chaꞌtso najndeii na matseixmaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Chaꞌtsondyena taꞌxꞌeena: —Quia joꞌ ¿aa ꞌu cwiluiindyuꞌ Jnda Tyꞌo̱o̱tsꞌom? Tꞌo̱o̱ⁿ nda̱a̱na: —Mancjoꞌtiꞌyoꞌ jnda̱ macwinduꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Quia joꞌ jluena: —¿Ljoꞌ cwii macaⁿtinaꞌ na nluiꞌyuuꞌ nacjoomꞌm? Ee mancjo̱o̱tya̱a̱ jnda̱ jndya̱a̱ya ñꞌoom ꞌñom. ");
INSERT INTO amuNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Quia joꞌ chaꞌtsondye nnꞌaⁿ na tjomndye joꞌ joꞌ, teiꞌcantyjana, tyꞌeñꞌomna Jesús na mꞌaaⁿ Pilato. ");
INSERT INTO amuNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","To̱ꞌna na tyoñequiana jnaaⁿꞌaⁿ. Jluena: —Tsaⁿmꞌaaⁿꞌ jnda̱ jliuuyâ na matseiꞌnaⁿꞌaⁿ nꞌom nnꞌaⁿ ndyuaayâ. Ee quitsoom na ticwanaaⁿ na nñeꞌquiaayâ tsꞌiaaⁿnda̱a̱yâ nnom César. Ndoꞌ manquiityeeⁿ matsoom na cwiluiiñê Cristo ndoꞌ rey jom. ");
INSERT INTO amuNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Quia joꞌ taꞌxꞌee Pilato nnoom, tso: —¿Aa ꞌu cwiluiindyuꞌ rey na catsa̱ꞌntjom nnꞌaⁿ judíos? Tꞌo̱ Jesús nnom: —Maxjeⁿ joꞌ ja, chaꞌxjeⁿ na matsuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ndoꞌ tso Pilato nda̱a̱ ntyee na cwiluiitquiendye nda̱a̱ ntyee ñequio nnꞌaⁿ na jndyendye: —Ja meiⁿcwii jnaaⁿꞌ tsaⁿsꞌamꞌaaⁿꞌ ticaljeiya. ");
INSERT INTO amuNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Sa̱a̱ naⁿꞌñeeⁿ jlaꞌjndeiiꞌ ndyueena, jluena: —Ñꞌoom na maꞌmo̱o̱ⁿ matseijmeiⁿꞌnaꞌ nnꞌaⁿ chaꞌwaa tsꞌo̱ndaa Judea. Tyochꞌeeⁿ na ljoꞌ tsꞌo̱ndaa Galilea, ndoꞌ mati ñjaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Jnda̱ na jndii Pilato ñꞌoom cantyja ꞌnaaⁿꞌ Galilea, taxꞌeeⁿ: —¿Aa tsꞌaⁿ tsꞌo̱ndaa Galilea tsaⁿsꞌamꞌaaⁿꞌ? ");
INSERT INTO amuNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Quia na ljeiijndaaꞌñê na jnaⁿ Jesús tsꞌo̱ndaa Galilea yuu na matsa̱ꞌntjom Herodes, quia joꞌ seicwanoom Jesús na mꞌaaⁿ Herodesꞌñeeⁿ na tsaⁿꞌñeeⁿ cuꞌxeeⁿ Jesús. Ee tyjeeꞌ tsaⁿꞌñeeⁿ Jerusalén quia joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ndoꞌ jeeⁿ neiiⁿꞌeⁿ quia na ntyꞌiaaⁿꞌaⁿ Jesús ee jaachꞌee xuee na jeeⁿ ñeꞌcwajnaⁿꞌaⁿ juu ndoꞌ na jndye ñꞌoom jnda̱ jñeeⁿ cantyja ꞌnaaⁿꞌ. Joꞌ jeeⁿ queeⁿ tsꞌoom na nntyꞌiaaⁿꞌaⁿ na nntsꞌaa Jesús cwii tsꞌiaaⁿ na xocanda̱a̱ nntsꞌaa na cweꞌ cwii tsꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ndoꞌ jndye ñꞌoom tyowaxꞌeeⁿ, sa̱a̱ meiⁿcwii ñꞌoom ticꞌo̱ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ndoꞌ ntyee na cwiluiitquiendye ñequio nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés, mati tyꞌena na mꞌaaⁿ. Tyoqueⁿya nꞌomna na tyoñequiana jnaaⁿꞌ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ndoꞌ mati Herodes ñequio sondaro ꞌnaaⁿꞌaⁿ, cweꞌ tyoncona Jesús ndoꞌ tyolaꞌjnaaⁿꞌna jom. Jlaꞌcweena jom cwii liaa na jnda, jnda̱ chii jlaꞌcwanomnndaꞌna jom na mꞌaaⁿ Pilato. ");
INSERT INTO amuNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Juu xueeꞌñeeⁿ ljoyaañe Pilato ñꞌeⁿ Herodes, ee ñetꞌomntiaaꞌndyena. ");
INSERT INTO amuNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Quia joꞌ seitjom Pilato ntyee na cwiluiitquiendye nda̱a̱ ntyee ñequio nnꞌaⁿ na laꞌxmaⁿ nꞌiaaⁿ ñequio nnꞌaⁿ na jndyendye. ");
INSERT INTO amuNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Tsoom nda̱a̱na: —ꞌO tquioñꞌomꞌyoꞌ tsaⁿsꞌamꞌaaⁿ na cwinduꞌyoꞌ matseijmeiiⁿꞌeⁿ nnꞌaⁿ judíos. Sa̱a̱ queⁿꞌyoꞌ cwenta, jo nda̱a̱ chaꞌtsondyoꞌ jnda̱ tcaaⁿꞌa ñꞌoom nnoom, ndoꞌ meiⁿcwii jnaaⁿꞌaⁿ tîcaljei na chaꞌtso ñꞌoom na cwiqueⁿꞌyoꞌ nacjoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Meiⁿ Herodes tîcaljeii jnaaⁿꞌaⁿ, joꞌ na seicwanomnndaꞌ tsaⁿꞌñeeⁿ jom na mꞌaaⁿya. Queⁿꞌyoꞌ cwenta, meiⁿcwii tyootseitjo̱o̱ñê na matsa̱ꞌntjomnaꞌ na cueeⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Joꞌ chii nnchuuꞌjñeeⁿ xeⁿ jnda̱ nntseicandyaandyo̱ jom. ");
INSERT INTO amuNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ndoꞌ waa costumbre na jndeiꞌnaꞌ na catseicandyaañe Pilato cwii pra̱so jo nda̱a̱ nnꞌaⁿ xcwe na waa xuee. ");
INSERT INTO amuNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Sa̱a̱ chaꞌtso nnꞌaⁿ na jndyendye, ñeꞌcwii ñꞌoom jlaꞌxuaana, jluena: —Quindyo̱o̱ꞌ luaaꞌ ñjaaⁿñe ndoꞌ catseicandyaandyuꞌ Barrabás. ");
INSERT INTO amuNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Tsaⁿꞌñeeⁿ tueeꞌna jom wꞌaancjo ee teijndaaꞌ jnaaⁿꞌaⁿ na seiweñê nacjooꞌ gobiernom. Ndoꞌ seicueⁿꞌeⁿ tsꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ndoꞌ Pilato ncꞌe na ñeꞌcatseicandyaañê Jesús, seineiⁿnnaaⁿꞌaⁿ nda̱a̱ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Sa̱a̱ joo naⁿꞌñeeⁿ jndeiiti jlaꞌxuaanndaꞌna, jluena: —Catyꞌiomꞌ jom tsꞌoomꞌnaaⁿ. Catyꞌiomꞌ jom tsꞌoomꞌnaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Tsoom nda̱a̱na na jnda̱ ndyee ndiiꞌ: —¿Ljoꞌ jeeⁿcheⁿ tisꞌa sꞌaaⁿ? Meiⁿcwii jnaaⁿꞌaⁿ tîcaljeiya na matsa̱ꞌntjomnaꞌ na cueeⁿꞌeⁿ. Joꞌ chii nnchuuꞌ jñeeⁿ, xeⁿ jnda̱ nntseicandyaandyo̱ jom. ");
INSERT INTO amuNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Sa̱a̱ naⁿꞌñeeⁿ jndeiiꞌ ndyueena, jndeii tyolaꞌxuaana, tyotaⁿna na cañoom tsꞌoomꞌnaaⁿ. Ndoꞌ ñꞌoomꞌñeeⁿ na tyoluena ñequio ntyee na cwiluiitquiendye nda̱a̱ ntyee jnaⁿjndeiinaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Joꞌ chii Pilato tquiaañetoom ñꞌoom na caluii chaꞌxjeⁿ na cwitaⁿna. ");
INSERT INTO amuNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Seicandyaañê tsꞌaⁿ na tyotaⁿna na mꞌaaⁿ wꞌaancjo, meiiⁿ na tyotseiweñe nacjooꞌ gobiernom ndoꞌ seicueeꞌ tsꞌaⁿ. Ndoꞌ tquiaaⁿ Jesús lueena na calꞌana chiuu na lꞌue nꞌomna. ");
INSERT INTO amuNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Xjeⁿ na tyꞌeñꞌom sondaro Jesús na nntyꞌioomna jom tsꞌoomꞌnaaⁿ, tꞌuena cwii tsꞌaⁿ na jnaⁿ jnda̱a̱, tsꞌaⁿ tsjoom Cirene na jndyu Simón. Jlaꞌcachuuna jom tsꞌoomꞌnaaⁿ tyojaantyjo̱o̱ⁿ naxeⁿꞌ Jesús ñꞌeⁿ juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ndoꞌ cwii tmaaⁿꞌ tꞌmaⁿ nnꞌaⁿ tyꞌentyjo̱ naxeⁿꞌ Jesús, ndii ñꞌeeⁿ yolcu na jeeⁿ cwityuee ndoꞌ cwilaꞌxuaa na matseiꞌndaaꞌnaꞌ nꞌom na cwintyꞌiaa na luaaꞌ matjoom. ");
INSERT INTO amuNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Sa̱a̱ taqueⁿ Jesús, tsoom: —ꞌO yolcu Jerusalén, tandyueeꞌyoꞌ cantyja ꞌnaⁿ ja luaa, catyueeꞌyoꞌ cantyja ꞌnaⁿꞌ ncjoꞌyoꞌ ñꞌeⁿ ndaꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ee queⁿꞌyoꞌ cwenta, manncueꞌntyjo̱ xuee na nlue nnꞌaⁿ: “Jeeⁿ teijnoom yolcu na tileicꞌom nda, na tîcandeiindye, meiⁿ tjaa yoꞌndaa jlaꞌcanteiꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ncueeꞌñeeⁿ nnto̱ꞌ nnꞌaⁿ na nluena nda̱a̱ ntsjo̱: “Catquiaandyoꞌ nacjooyâ”, ndoꞌ nluena nda̱a̱ nta: “Calaꞌcata̱ꞌyoꞌ jâ.” ");
INSERT INTO amuNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ee xeⁿ nmeiiⁿ macwilꞌa nnꞌaⁿ ñꞌeⁿndyo̱ ja na tjaa jnaⁿ tseixmaⁿya, cwanti na tꞌmaⁿti nawiꞌ nntjoom naⁿꞌñeeⁿ na waa jnaaⁿna. ");
INSERT INTO amuNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Ndoꞌ mati tyꞌechona we nnꞌaⁿ na wiꞌndye na nntyꞌioomna nꞌomꞌnaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Quia na tquiena cwii joo na jndyu Ta Tseiꞌxqueⁿ Tsꞌoo, tyꞌioomna jom tsꞌoomꞌnaaⁿ joꞌ joꞌ ñequio naⁿꞌñeeⁿ na wiꞌndye, cwii tsaⁿꞌñeeⁿ ntyjaaⁿꞌaⁿ ntyjaya ndoꞌ cwiicheⁿ tsaⁿꞌñeeⁿ ntyjaaⁿꞌaⁿ ntyjatymaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Tsoom: —Tsotya̱ya, catseitꞌmaⁿ tsꞌomꞌ joona, ee ticalaꞌno̱ⁿꞌna ljoꞌ cwilꞌana ñꞌeⁿndyo̱. Ndoꞌ tyoꞌoo sondaro xꞌiaa na nntyꞌiaana ꞌñeeⁿ nleijnoomꞌ cwii cwii liaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Joꞌ joꞌ jndye nnꞌaⁿ na cweꞌ tyꞌecantyꞌiaa na luaaꞌ. Sa̱a̱ naⁿmaⁿnꞌiaaⁿ jeeⁿ ticueeꞌ nꞌomna jom, tyoluena: —Jeeⁿ ya tjeiꞌnꞌmaaⁿñê ntꞌomcheⁿ nnꞌaⁿ, jeꞌ cwjiꞌnꞌmaaⁿñe cheⁿnqueⁿ xeⁿ mayuuꞌ cwiluiiñê nquii Cristo tsaⁿ na tjeiiꞌñe Tyꞌo̱o̱tsꞌom na catsa̱ꞌntjom. ");
INSERT INTO amuNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Mati tyolaꞌjnaaⁿꞌ sondaro Jesús. Tyꞌentyjaaꞌna na nñeꞌquiana winom na ta̱ na nncꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Jluena: —Xeⁿ ꞌu cwiluiindyuꞌ Rey na catsa̱ꞌntjomꞌ nnꞌaⁿ judíos, cwjiꞌnꞌmaaⁿndyuꞌ cheⁿnncuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ndoꞌ jo ndyeyu tsꞌom xqueeⁿ tyꞌioomna ljeii ñꞌoom griego, latyeⁿ, ñꞌeⁿ hebreo. Matsonaꞌ: “Luaañe Rey cwentaa nnꞌaⁿ judíos.” ");
INSERT INTO amuNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Cwii joo naⁿꞌñeeⁿ na wiꞌndye na ñoom ñꞌeⁿñê, seijnaaⁿꞌ jom. Tso: —¿Aa nchii Cristo cwiluiindyuꞌ? Cwa cwjiꞌnꞌmaaⁿndyuꞌ cheⁿnncuꞌ ndoꞌ mati jâ. ");
INSERT INTO amuNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Sa̱a̱ tꞌo̱ cwiicheⁿ tsaⁿꞌñeeⁿ, seitiaaⁿꞌaⁿ xꞌiaaⁿꞌaⁿ, tsoom: —Cwa tinquiaꞌ Tyꞌo̱o̱tsꞌom. Ndoꞌ ꞌu jnda̱ tꞌuiityeⁿnaꞌ na maxjeⁿ nncꞌioꞌ. ¿Aa ticandoꞌ mañejoꞌti matjomꞌ chaꞌxjeⁿ matjom jom? ");
INSERT INTO amuNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ndoꞌ wendyo̱ jaa nmeiiⁿ mayuuꞌcheⁿ matyꞌiomyanaꞌ na catjo̱o̱ⁿya na luaa ee cwitio̱o̱ⁿndyo̱ cantyja na ñelꞌaaya. Sa̱a̱ juu Tamꞌaaⁿꞌ meiⁿcwii nawiꞌ tîcatsꞌaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Quia joꞌ tsoom nnom Jesús: —ꞌU Ta, cjaañjoomꞌ tsꞌomꞌ ja quia na nndyoꞌ na nntsa̱ꞌntjomꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Tso Jesús nnom tsaⁿꞌñeeⁿ: —Mayuuꞌcheⁿ matsjo̱o̱ njomꞌ, xuee jeꞌ nncꞌoomꞌ ñꞌeⁿndyo̱ jo paraíso yuu na mꞌaaⁿ nquii Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Xjeⁿ na tueeꞌ quiajmeiⁿꞌ, teijaaⁿ chaꞌwaa tsjoomnancue hasta na ndyee na matmaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ee na teijaaⁿ ñeꞌquioomꞌ. Ndoꞌ juu liaa tco na ntyjatyꞌio naquiiꞌ watsꞌom tꞌmaⁿ tyꞌiooꞌxcwenaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Quia joꞌ jndeii seixuaa Jesús, tsoom: —Tsotya̱ya, maꞌndiya cantyja na wando̱ꞌa naquiiꞌ lꞌo̱ꞌ. Jnda̱ tsoom na luaaꞌ, mana tueeⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Quia na ntyꞌiaaꞌ tyo na matsa̱ꞌntjom sondaro chiuu waa na tuii, seitꞌmaaⁿꞌñê Tyꞌo̱o̱tsꞌom, tsoom: —Mayuuꞌcheⁿ tsaⁿmꞌaaⁿꞌ matseixmaaⁿ tsꞌaⁿ na ljuꞌ cwiluiiñe. ");
INSERT INTO amuNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ndoꞌ chaꞌtso nnꞌaⁿ na tjomndye na ntyꞌiaa na ljoꞌ tuii, quia tyꞌelcweeꞌna lꞌaana, tyotmeiiⁿꞌna ndaꞌ ndeiꞌcandyaana na cwitꞌmo̱o̱ⁿna na matseiꞌndaaꞌnaꞌ nquiuna. ");
INSERT INTO amuNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ndoꞌ chaꞌtso nnꞌaⁿ na taꞌjnaaⁿꞌna Jesús ñequio yolcu na tyꞌentyjo̱ naxeeⁿꞌeⁿ na jnaⁿ Galilea, tyontyꞌiaa tquiana na luaaꞌ tjom Jesús. ");
INSERT INTO amuNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Tyomꞌaaⁿ cwii tsꞌaⁿ na jndyu José na jnaⁿ tsjoom Arimatea tsꞌo̱ndaa Judea. Tsaⁿꞌñeeⁿ cwii joo nnꞌaⁿ na mꞌaⁿ nꞌiaaⁿ cwentaa nnꞌaⁿ judíos. Jom ya tsꞌaⁿñê ndoꞌ machꞌeeⁿ na matyꞌiomyanaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Mati tyomeinomꞌm juu na nntsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. Tîcatseijomñê ñꞌoom na tꞌmaⁿ ntꞌomcheⁿ ncꞌiaaⁿꞌaⁿ na cueꞌ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Tjaaⁿ na mꞌaaⁿ Pilato ndoꞌ tcaaⁿ tsꞌoo Jesús. ");
INSERT INTO amuNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Jnda̱ chii tjacatyjeeñê juu. Seityjooñê liaa sábana tsaⁿ lino ndoꞌ tjaaꞌñê juu naquiiꞌ tsueꞌtsjo̱ꞌ na tuiiya. Joꞌ joꞌ meiⁿcwii tjaaꞌnaⁿ ꞌñeeⁿ cojaaquieeꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Juu xueeꞌñeeⁿ, maxuee na cwilaꞌjndaaꞌndye nnꞌaⁿ na nntaꞌjndyeena xuee sábado. Ndoꞌ xjeⁿꞌñeeⁿ majaaweeꞌya xjeⁿ cantyja ꞌnaaⁿꞌnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Yolcu na tquio ñꞌeⁿñê na jnaⁿna Galilea, tyꞌentyꞌiaana tseiꞌtsuaa, tqueⁿna cwenta chiuu waa na tjacantyꞌiuuꞌñê. ");
INSERT INTO amuNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Jnda̱ joꞌ tyꞌelcweeꞌna Jerusalén, tyꞌelaꞌjndaaꞌndyena nasei cachi ndoꞌ ncheⁿꞌ. Ndoꞌ taꞌjndyeena juu xuee na cwitaꞌjndyee nnꞌaⁿ chaꞌxjeⁿ matsa̱ꞌntjom ljeii naqui. ");
INSERT INTO amuNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Cwitsjoomya xuee najndyee smanaⁿ, tyꞌena yuu waa tseiꞌtsuaa. Tyꞌechona nasei cachi na jnda̱ jlaꞌjndaaꞌndyena. ");
INSERT INTO amuNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Jnda̱ na tquiena jliuna na jnda̱ teindyo̱ tsjo̱ꞌ na ta̱ꞌ ꞌndyoo tsueꞌtsjo̱ꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Quia na tyꞌequieꞌna joꞌ joꞌ, taticaliuna seiꞌtsꞌo ꞌnaaⁿꞌ Ta Jesús. ");
INSERT INTO amuNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Xcwe na matseiñꞌeeⁿꞌñenaꞌ joona na cwicatyuena, ndoꞌ teitquiooꞌndye we nnꞌaⁿ nacañoomna na jeeⁿ canchiiꞌ, caxuee liaa. ");
INSERT INTO amuNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Jeeⁿ ndyaꞌ tyuena, jlaꞌntyjanquioondyena nqueⁿna nomtyuaa. Jlue naⁿꞌñeeⁿ nda̱a̱na: —¿Chiuu quiiꞌntaaⁿ lꞌoo cwilꞌueꞌyoꞌ tsꞌaⁿ na wandoꞌ? ");
INSERT INTO amuNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Tacꞌoomñê ñjaaⁿ, jnda̱ wandoꞌxcoom. Cjaañjoomꞌ nꞌomꞌyoꞌ ñꞌoom na seineiiⁿ nda̱a̱ꞌyoꞌ quia na ndi mꞌaaⁿ tsꞌo̱ndaa Galilea. ");
INSERT INTO amuNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Tsoom na nqueⁿ na cwiluiiñê tsꞌaⁿ na jnaⁿ cañoomꞌluee, nñeꞌquia nnꞌaⁿ cwenta jom luee nnꞌaⁿjnaⁿ. Ndoꞌ naⁿꞌñeeⁿ nntyꞌioomna jom tsꞌoomꞌnaaⁿ. Sa̱a̱ xuee jnda̱ ndyee ncwandoꞌxcoom. ");
INSERT INTO amuNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Quia joꞌ tjañjoomꞌ nꞌomna ñꞌoom na tyotseineiiⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Jnaⁿna yuu na waa tseiꞌtsuaa, tyꞌelcweeꞌna ndoꞌ jlaꞌcandiina nnꞌaⁿ canchooꞌcwii ñequio chaꞌtso ntꞌomcheⁿ nnꞌaⁿ chiuu waa na tuii. ");
INSERT INTO amuNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","María Magdalena, ñꞌeⁿ Juana, ñꞌeⁿ María tsondyee Jacobo, ñꞌeeⁿ ntꞌomcheⁿ yolcu na ñꞌeeⁿ ñꞌeⁿndyena, joona jlaꞌcandiina nnꞌaⁿ canchooꞌcwii ñꞌoomꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Sa̱a̱ apóstoles ndooꞌ nquiuna cweꞌ ñꞌomnco joꞌ. Tîcalaꞌyuꞌna. ");
INSERT INTO amuNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Sa̱a̱ Pedro teicantyjaaⁿ, jleinoom, tjaaⁿ yuu waa tseiꞌtsuaa. Quia na ntyꞌiaaⁿꞌaⁿ naquiiꞌ tseiꞌtsuaa, cweꞌ liaa canchiiꞌ ljeiiⁿ. Ndoꞌ tjalcweꞌnnaaⁿꞌaⁿ waⁿꞌaⁿ, jaawa jaacue tyomꞌaaⁿꞌ tsꞌoom chaꞌtso na jnda̱ tuii. ");
INSERT INTO amuNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Majuuti xueeꞌñeeⁿ we nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿ Jesús cwiꞌoona cwii tsjoom chjoo na jndyu Emaús na mꞌaaⁿ naꞌ canchooꞌcwii kilómetros na tquianaꞌ ñꞌeⁿ Jerusalén. ");
INSERT INTO amuNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ndoꞌ cheⁿnquieena cantyja chaꞌtso na nmeiiⁿꞌ tuii. ");
INSERT INTO amuNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Yocheⁿ na luaaꞌ jeeⁿ cwilaꞌneiⁿna, manquiiti Jesús tueꞌntyjo̱o̱ⁿ joona. Ñeꞌcwi tjaaⁿ ñꞌeⁿndyena. ");
INSERT INTO amuNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Sa̱a̱ tîcataꞌjnaaⁿꞌna jom ee sꞌaanaꞌ nꞌomnda̱a̱na chaꞌcwijom na titquioona. ");
INSERT INTO amuNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Tsoom nda̱a̱na: —¿Ljoꞌ ñꞌoom jeeⁿ cwilaneiⁿꞌyoꞌ na tsaꞌyoꞌ nato? Quia joꞌ tyꞌemeintyjeeꞌna na chjooꞌ nꞌomna. ");
INSERT INTO amuNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ndoꞌ cwiindye joona na jndyu Cleofas tꞌo̱ nnoom, tso: —¿Aa ꞌu cwii tsꞌaⁿ na cweꞌ tyjeꞌya Jerusalén, joꞌ chii ticaljeiꞌ chiuu waa na tuii wja mawenaꞌ? ");
INSERT INTO amuNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Quia joꞌ tꞌo̱o̱ⁿ nda̱a̱na: —¿Ljoꞌ tuii? Joona tꞌo̱o̱na nnoom: —Aa, waa na tuii cantyja ꞌnaaⁿꞌ Jesús, tsꞌaⁿ tsjoom Nazaret na tyotseixmaⁿ profeta. Tꞌmaⁿ najneiⁿ tsꞌiaaⁿ na tyochꞌeeⁿ ñequio ñꞌoom na tyotseineiiⁿ jo nda̱a̱ chaꞌtso nnꞌaⁿ ndoꞌ jo nnom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Sa̱a̱ nquiee ntyee na cwiluiitquiendye nda̱a̱ ntyee ñequio naⁿmaⁿnꞌiaaⁿ cwentaayâ tquiana cwenta jom na catꞌuiityeⁿnaꞌ jom na cueeⁿꞌeⁿ, ndoꞌ tyꞌioom nnꞌaⁿ jom tsꞌoomꞌnaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ndoꞌ jâ jeeⁿ ñentyjaaꞌ nꞌo̱o̱ⁿyâ na jom nluiiñê nquii na nntseicandyaañe nnꞌaⁿ Israel. Ndoꞌ waa cwiicheⁿ, jeꞌ jnda̱ ndyee xuee na tuii na nmeiiⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ndoꞌ nchii macanda̱ joꞌ, mati joo yolcu na ñꞌeeⁿ tmaaⁿꞌ na laxmaaⁿyâ, tquioñꞌomna ñꞌoom na jeeⁿ seiñꞌeeⁿꞌnaꞌ jâ. Ee mateincooquiuuꞌ tyꞌena yuu waa tseiꞌtsuaⁿꞌaⁿ, ");
INSERT INTO amuNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","sa̱a̱ taticaliuna seiꞌtsꞌo ꞌnaaⁿꞌaⁿ. Tquiolcweeꞌna, tyoluena na mati tcoꞌnaꞌ ángeles nda̱a̱na na jlue yoꞌñeeⁿ nda̱a̱na na jom wanoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Joꞌ chii tyꞌe ntꞌom ncꞌiaayâ yuu waa tseiꞌtsuaa ndoꞌ jliuna na mayuuꞌ chaꞌxjeⁿ na jlue yolcuꞌñeeⁿ. Sa̱a̱ maxjeⁿ tîcantyꞌiaana nquii Jesús. ");
INSERT INTO amuNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Quia joꞌ tso Jesús nda̱a̱na: —ꞌO nnꞌaⁿ na tileicalaꞌno̱ⁿꞌyoꞌ maxjeⁿ tiqueⁿꞌyoꞌ cwenta ndoꞌ ticjooꞌ nꞌomꞌyoꞌ na nlayuꞌyoꞌ chaꞌtso ñꞌoom na tyolue profetas. ");
INSERT INTO amuNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Aa nchii maxjeⁿ matsonaꞌ na nquii Cristo catjoom chaꞌtso nawiꞌmeiⁿꞌ cwitjo̱o̱cheⁿ na nntseitꞌmaaⁿꞌñenaꞌ jom. ");
INSERT INTO amuNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Quia joꞌ tyoꞌmo̱o̱ⁿ naquiiꞌ ljeii ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom chaꞌtso ñꞌoom na matseineiⁿnaꞌ cantyja ꞌnaaⁿꞌ nqueⁿ. To̱o̱ⁿꞌo̱ⁿ ñequio ljeii na tqueⁿ Moisés ndoꞌ tcuu tyꞌoomnaꞌ hasta xjeⁿ ljeii na tqueⁿ chaꞌtso profetas. ");
INSERT INTO amuNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Quia na tyꞌewindyoona tsjoom chjoo yuu na cwiꞌoona, quia joꞌ sꞌaaⁿ na ndooꞌ wjaatyeeⁿcheⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Sa̱a̱ joona lꞌana na jndeiꞌnaꞌ na caljooꞌñê ñꞌeⁿndyena. Jluena: —Caljooꞌndyuꞌ ñꞌeⁿndyô̱ ee jeꞌ jnda̱ tmaaⁿ ndoꞌ manleinco̱o̱ⁿꞌ. Joꞌ chii tjaqueⁿꞌeⁿ naquiiꞌ wꞌaa na nljooꞌñê. ");
INSERT INTO amuNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ndoꞌ quia na tjacjom nacañoomꞌ meiⁿsa ñꞌeⁿndyena, toꞌñoom tyooꞌ, tquiaaⁿ na quianlꞌuaaꞌ Tyꞌo̱o̱tsꞌom cantyja ꞌnaaⁿꞌnaꞌ, tyjeeⁿ ndoꞌ tquiaaⁿ juunaꞌ nda̱a̱na. ");
INSERT INTO amuNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ndoꞌ xjeⁿꞌñeeⁿ sꞌaanaꞌ joona chaꞌcwijom tsꞌaⁿ na ya teitquiooꞌnndaꞌ ndoꞌ taꞌjnaaⁿꞌna na manquii Jesús joꞌ. Sa̱a̱ jom mana tsuñê jo nda̱a̱na. ");
INSERT INTO amuNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Tyoluena nda̱a̱ ntyjeena: —Aa tiyuuꞌ sꞌaanaꞌ jndaꞌjom teiiⁿ nꞌo̱o̱ⁿya yocheⁿ na matseineiiⁿ nda̱a̱ya xjeⁿ na ñjomndyo̱ nato quia na seicano̱o̱ⁿ chiuu maꞌmo̱ⁿ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na teiljeii. ");
INSERT INTO amuNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ndoꞌ mañejuu xjeⁿꞌñeeⁿ teicantyjana, tyꞌelcweeꞌna Jerusalén. Jliuna nnꞌaⁿ na canchooꞌcwii ñeꞌnaaⁿꞌ mꞌaⁿ naⁿꞌñeeⁿ ñequio ntꞌomcheⁿ ncꞌiaana. ");
INSERT INTO amuNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Quia joꞌ jlue naⁿꞌñeeⁿ nda̱a̱na: —Jeeⁿ sa, mayuuꞌcheⁿ jnda̱ mawandoꞌxco Ta Jesús, ee jnda̱ teitquiooꞌñê nnom Simón. ");
INSERT INTO amuNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Quia joꞌ joona tyolaꞌneiⁿna chiuu waa na tuii quia na mꞌaⁿna nato ndoꞌ chiuu waa na taꞌjnaaⁿꞌna jom quia na tyjeeⁿ tyooꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Yocheⁿ na cwilaꞌneiⁿna ñꞌoommeiⁿꞌ, teitquiooꞌ meintyjeeꞌ Jesús xcwe quiiꞌntaaⁿna. Tquiaaⁿ na xmaⁿndyena. Tsoom: —Cꞌomꞌyoꞌ na tjaañomtiuu quiiꞌ nꞌomꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Sa̱a̱ joona nioom tyuena, ee jlaꞌtiuuna na cweꞌ ncwaaⁿꞌaⁿ joꞌ cwintyꞌiaana. ");
INSERT INTO amuNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ndoꞌ tsoom nda̱a̱na: —¿Chiuu na jeeⁿ matseiꞌndaaꞌnaꞌ nquiuꞌyoꞌ ndoꞌ na luaaꞌ mꞌaaⁿꞌ nꞌomꞌyoꞌ? ");
INSERT INTO amuNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Cantyꞌiaꞌyoꞌ lꞌo̱o̱ya ñꞌeⁿ ncꞌa̱ya na mannco̱tya̱ luaa. Ndoꞌ nquioꞌyoꞌ ja, ee ncwaaⁿꞌ tsꞌaⁿ tjaaꞌnaⁿ seiꞌ cachuunaꞌ, meiⁿ ndeiꞌ chaꞌna cwintyꞌiaꞌyoꞌ na cho̱ ja. ");
INSERT INTO amuNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Jnda̱ tsoom na luaaꞌ, tꞌmo̱o̱ⁿ lꞌo̱o̱ⁿ ndoꞌ ncꞌeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Sa̱a̱ ndicwaⁿ cweꞌ matseitsaⁿꞌtonaꞌ joona na jeeⁿ neiiⁿna, jeeⁿ cjaaweeꞌ nꞌomna, hasta tileicalayuꞌna na jom. Quia joꞌ tsoom nda̱a̱na: —¿Aa cwileiꞌñꞌomꞌyoꞌ na ya nlcwaꞌ tsꞌaⁿ? ");
INSERT INTO amuNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Joꞌ chii tquiana cwii taⁿꞌ catscaa jneiiⁿ ñequio tscuu na ñjom tsiomꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Toꞌñoom ndoꞌ tcwaaⁿꞌaⁿ ñequio na jndooꞌna. ");
INSERT INTO amuNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ndoꞌ tsoom nda̱a̱na: —Chaꞌtso ñꞌoom na teiljeii cantyja ꞌnaⁿya naquiiꞌ ñꞌoom na tqueⁿ Moisés ñequio profetas, ndoꞌ mati naquiiꞌ salmos, ñꞌoomꞌñeeⁿ tyoꞌmo̱o̱ⁿya nda̱a̱ꞌyoꞌ quia na ndicwaⁿ mꞌaaⁿya ñꞌeⁿndyoꞌ. Joonaꞌ wjaatseicanda̱a̱ꞌñenaꞌ, ndoꞌ jeꞌ macwiluii chaꞌxjeⁿ na tsjo̱o̱. ");
INSERT INTO amuNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Quia joꞌcheⁿ tquiaa Jesús na nlaꞌno̱ⁿꞌna ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na teiljeiinaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Tsoom nda̱a̱na: —Ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na teiljeii, matsonaꞌ na nquii na cwiluiiñe Cristo, jndeiꞌnaꞌ na nntjoom nawiꞌ tꞌmaⁿ, ndoꞌ xuee na jnda̱ ndyee nncwandoꞌxcoom na tueeⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ñequio xueeꞌ jom nñeꞌquia nnꞌaⁿ ñꞌoom na calcweꞌ nꞌom nnꞌaⁿ jnaaⁿna cha na nntseitꞌmaⁿ tsꞌom Tyꞌo̱o̱tsꞌom joona. Ñꞌoommeiiⁿ nnaⁿnaꞌ Jerusalén, nncjaantyꞌeenaꞌ xjeⁿ chaꞌwaa tsjoomnancue. ");
INSERT INTO amuNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ndoꞌ ꞌo laꞌxmaⁿꞌyoꞌ na catjeiꞌyuuꞌndyoꞌ ñꞌoommeiiⁿ. ");
INSERT INTO amuNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Queⁿꞌyoꞌ cwenta, ja njño̱o̱ⁿya nquii Espíritu Santo na jnda̱ tso Tsotya̱ya na nñequiaaⁿ nda̱a̱ꞌyoꞌ. Joꞌ chii, caljooꞌndyoꞌ tsjoom Jerusalén hasta na nntoꞌñoomꞌyoꞌ juu na nnaⁿ nandye na nñequiaa najnda̱ꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Quia joꞌ jluiꞌna tsjoomꞌñeeⁿ. Tjachom joona nndyooꞌ tsjoom Betania. Seintyjo̱o̱ⁿ lꞌo̱o̱ⁿ nacjoona, tioꞌnaaⁿñê joona. ");
INSERT INTO amuNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Majuu xjeⁿ na matioꞌnaaⁿñê joona to̱ⁿꞌnaꞌ jom ñꞌeⁿndyena. Tjañꞌoomnaꞌ jom nandye cañoomꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ndoꞌ joona, quia jnda̱ jlaꞌtꞌmaaⁿꞌndyena jom, tyꞌelcweeꞌna Jerusalén na jeeⁿcheⁿ ndyaꞌ neiiⁿna. ");
INSERT INTO amuNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Ñeꞌquiiꞌcheⁿ tyomꞌaⁿna watsꞌom tꞌmaⁿ na tyolaꞌtꞌmaaⁿꞌndyena Tyꞌo̱o̱tsꞌom. Mantyjati luaaꞌndyo.");
INSERT INTO amuNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Xjeⁿ na to̱ꞌ Tyꞌo̱o̱tsꞌom na tqueeⁿ chaꞌtso, juu na cwiluiiñe ñꞌoomꞌm maxjeⁿ mꞌaaⁿ ñꞌeⁿñê. Ndoꞌ chaꞌtso na cwiluiiñê mati juu canda̱a̱ꞌñꞌeⁿ cwiluiiñe. ");
INSERT INTO amuNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Juu na cwiluiiñe ñꞌoomꞌ Tyꞌo̱o̱tsꞌom mꞌaaⁿ ñꞌeⁿñê xjeⁿ na jnaⁿjndyeecheⁿnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Chaꞌtso na maniom na tqueⁿ Tyꞌo̱o̱tsꞌom, ñꞌeeⁿ quia tqueⁿna joonaꞌ. Cwii cwii nnom na maniom, ñequiiꞌcheⁿ na ñꞌeeⁿ na tqueⁿna joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Tseixmaⁿ cheⁿnqueⁿ na ticantycwii na wanoomꞌm. Juu joꞌ na matseixmaaⁿ matseijomnaꞌ chaꞌcwijom chom na matseixueeñenaꞌ nda̱a̱ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Juu naxuee na matseixmaaⁿ, matseicano̱o̱ⁿnaꞌ chaꞌtso na cwiꞌoo nacjooꞌ Tyꞌo̱o̱tsꞌom. Sa̱a̱ chaꞌtso joo joꞌ tîcanda̱a̱ nlqueⁿnaꞌ xjeⁿ ꞌnaaⁿnaꞌ jom. ");
INSERT INTO amuNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Tyomꞌaaⁿ cwii tsaⁿsꞌa na jñom Tyꞌo̱o̱tsꞌom na mꞌaⁿ nnꞌaⁿ judíos. Juan jndyu tsaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Jñoom na tyꞌiom Tyꞌo̱o̱tsꞌom tsꞌiaaⁿ jom na nncwjiꞌyuuꞌñê cantyja ꞌnaaⁿꞌ Cristo na cwiluiiñe naxueeñe, tyochꞌeeⁿ na ljoꞌ cha chaꞌtsondye nnꞌaⁿ ñꞌeⁿ Cristo nlaꞌyuꞌna. ");
INSERT INTO amuNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Nchii nqueⁿ cwiluiiñê naxueeñe sa̱a̱ jñoom na nncwjiꞌyuuꞌñê cantyja ꞌnaaⁿꞌ juu na cwiluiiñe naxueeñe. ");
INSERT INTO amuNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Cristo cwiluiiñê naxueeñe na mayuuꞌcheⁿ, tuiiñê tsjoomnancue. Jom mañequiaaⁿ naxuee nnom ticwii cwii tsꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nquii na cwiluiiñe ñꞌoomꞌ Tyꞌo̱o̱tsꞌom, tyomꞌaaⁿñe tsjoomnancue, sa̱a̱ meiiⁿ na jom tqueeⁿ juunaꞌ, maxjeⁿ tîcalaꞌno̱ⁿꞌ nnꞌaⁿ ꞌñeeⁿ cwiluiiñê. ");
INSERT INTO amuNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Tyjeꞌcañoom nnꞌaⁿ judíos na mañecwii ndyuaana ñꞌeⁿñê, sa̱a̱ tîcatoꞌñoomna jom. ");
INSERT INTO amuNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Sa̱a̱ ntꞌomndye joona toꞌñoomna jom, ndoꞌ tyolaꞌyuꞌna ñꞌeⁿñê. Nda̱a̱ joona tquiaaⁿ na cwilaꞌxmaⁿna ntseinda Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nchii cwiluiindyena ntseinaaⁿ chaꞌxjeⁿ na cwiluiindye nda nnꞌaⁿ. Meiⁿ nchii cwiluiindyena ntseinaaⁿ ee na queeⁿya tsꞌom cwii tsꞌaⁿ. Tomti maqueⁿnaꞌ joona ntseinaaⁿ ee nqueⁿ lꞌue tsꞌoom. ");
INSERT INTO amuNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nquii na cwiluiiñe ñꞌoomꞌ Tyꞌo̱o̱tsꞌom tuiiñe na tsꞌaⁿ, tyomꞌaaⁿñe quiiꞌntaaⁿna. Canda̱a̱ꞌya mꞌaaⁿ na candyaꞌ tsꞌom nnꞌaⁿ, ndoꞌ cwiluiiñe na mayuuꞌ. Ntyꞌiaanda̱a̱yâ quia seitꞌmaaⁿꞌñe Tyꞌo̱o̱tsꞌom juu. Quia tuii na ljoꞌ saaliuuyâ na ñenquii cwiluiiñe Jnda Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Juanꞌñeeⁿ tyocwjiꞌyuuꞌñê cantyja ꞌnaaⁿꞌ juu quia seiweeⁿ jñeeⁿꞌeⁿ nda̱a̱ nnꞌaⁿ. Tsoom: —Nquiuꞌyoꞌ na jnda̱ ñetsjo̱o̱ na ꞌio cha nleitquiooꞌñe cwii tsꞌaⁿ quiiꞌntaaⁿꞌyoꞌ na meiⁿchjoo ticꞌoomꞌnaꞌ ja ñꞌeⁿñê, ee maxjeⁿ mꞌaaⁿ cwii tjo̱o̱cheⁿ na nluiindyo̱. Manquii tsꞌaⁿ na mandyowindyooꞌ luaaꞌ joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Jom canda̱a̱ꞌñꞌeⁿ naya matseixmaaⁿ. Cantyja ꞌnaaⁿꞌ joꞌ matioꞌnaaⁿñe Tyꞌo̱o̱tsꞌom chaꞌtsondyo̱. Cwii nnom na jnda̱ toꞌño̱o̱ⁿya na matioꞌnaaⁿñê jaa, jnda̱ mañoomcheⁿ na cwitoꞌño̱o̱ⁿya. ");
INSERT INTO amuNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Lꞌo̱ Moisés tquiaa Tyꞌo̱o̱tsꞌom ljeii na matsa̱ꞌntjomnaꞌ. Sa̱a̱ cantyja ꞌnaaⁿꞌ Jesucristo cwiliuuya na candyaꞌ tsꞌom Tyꞌo̱o̱tsꞌom jaa ndoꞌ na cwiluiiñê ñꞌoom na mayuuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Tjaaꞌnaⁿ cwii tsꞌaⁿ na jnda̱ ntyꞌiaaꞌ Tyꞌo̱o̱tsꞌom. Macanda̱ nquii Jnaaⁿ na ñecwiiñe, juu jnda̱ tꞌmo̱ⁿ nda̱a̱ya chiuu cwiluiiñê. ");
INSERT INTO amuNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Nnꞌaⁿ judíos na cwiluiitquiendye Jerusalén jñoomna ntyee cwentaana na mꞌaaⁿ Juan ñequio ntꞌom levitas na cwindyeꞌntjom naquiiꞌ watsꞌom. Tyꞌioomna tsꞌiaaⁿ ntyeeꞌñeeⁿ na cataꞌxꞌee naⁿꞌñeeⁿ nnom Juan ꞌñeeⁿ cwiluiiñê. ");
INSERT INTO amuNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jom ndyeyu tjeiꞌyuuꞌñê, tsoom: —Ja nchii Cristo cwiluiindyo̱. ");
INSERT INTO amuNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Joꞌ chii taꞌxꞌeetina nnoom: —¿Aa profeta Elías ꞌu? Jom tꞌo̱o̱ⁿ: —Nchii joꞌ ja. Taꞌxꞌeenndaꞌna nnoom: —Quia joꞌ, ¿aa cwiluiindyuꞌ profetaꞌñeeⁿ na matso Moisés na nñequiaa ñꞌoomꞌ Tyꞌo̱o̱tsꞌom nda̱a̱ya? Sa̱a̱ tꞌo̱o̱ⁿ: —Nchii joꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Joꞌ chii jluena nnoom: —¿Quia joꞌ ꞌñeeⁿ cwiluiindyuꞌ? Catsuꞌ cha ya nntꞌo̱o̱yâ nda̱a̱ nnꞌaⁿ na jñoom jâ. ¿Chiuu matsuꞌ cheⁿnncuꞌ cantyja ꞌnaaⁿꞌ tsꞌiaaⁿ na matseiꞌxmaⁿꞌ? ");
INSERT INTO amuNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Luaa ñꞌoom na seilcweeⁿꞌeⁿ nda̱a̱ naⁿꞌñeeⁿ. Matsoom: —Ja matsꞌaa chaꞌxjeⁿ na tso profeta Isaías quia tsoom: “Mꞌaaⁿ cwii tsꞌaⁿ na matseiwe jndyeeꞌ jo ndoꞌ ndyuaa yuu tjaa nnꞌaⁿ cꞌoom. Calajndaaꞌndyoꞌ na nquii na tjacantyja na cwiluiitꞌmaⁿñe nntsa̱ꞌntjom ꞌo.” ");
INSERT INTO amuNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nnꞌaⁿ na laꞌxmaⁿ tmaaⁿꞌ fariseos jñoomna naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Ndoꞌ taꞌxꞌeendyeti naⁿꞌñeeⁿ nnoom. Jluena: —Matsuꞌ na ꞌu meiⁿ nchii Cristo cwiluiindyuꞌ, meiⁿ Elías, meiⁿ nquii profeta na tso Moisés na nñequiaa ñꞌoomꞌ Tyꞌo̱o̱tsꞌom nda̱a̱ya, quia joꞌ ¿chiuu na matseitsꞌoomndyuꞌ nnꞌaⁿ? ");
INSERT INTO amuNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ndoꞌ tꞌo̱ Juan nda̱a̱na. Tsoom: —Ja matseitsꞌoomndyo̱ nnꞌaⁿ ñequio ndaatioo, sa̱a̱ quiiꞌntaaⁿꞌyoꞌ mꞌaaⁿ cwii tsꞌaⁿ na ticalaꞌno̱ⁿꞌyoꞌ cantyja ꞌnaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Majom na nntsꞌaaⁿ tsꞌiaaⁿ ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom quia na jnda̱ ꞌndiinaꞌ ja, ee maxjeⁿ mꞌaaⁿ cwii tjo̱o̱cheⁿ na nluiindyo̱. Ja meiⁿ cweꞌ na nndiꞌntjo̱ⁿya nnoom tilꞌuendyo̱. ");
INSERT INTO amuNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Luaaꞌ tuii cwii joo na jndyu Betábara, jo ntyja na macaluiꞌ ñeꞌquioomꞌ xndyaaꞌ jndaa Jordán yuu na tyotseitsꞌoomñe Juan nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Xuee na jnda̱ we na tuii na luaaꞌ, ntyꞌiaaꞌ Juan na ndyowindyooꞌ Jesús na mꞌaaⁿ. Matsoom nda̱a̱ jâ na mꞌaaⁿyâ ñꞌeⁿñê joꞌ joꞌ: —Queⁿꞌyoꞌ cwenta, luaaꞌ tsꞌaⁿ na cwiluiiñe catsmaⁿ tsmeiⁿꞌ Tyꞌo̱o̱tsꞌom na juu matseicanduuꞌ jnaaⁿ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Mañejuu tsꞌaⁿ na jnda̱ ñetsjo̱o̱ya nda̱a̱ꞌyoꞌ cantyja ꞌnaaⁿꞌ na ꞌio cha nleitquiooꞌñe cwii tsꞌaⁿ quiiꞌntaaⁿꞌyoꞌ na tꞌmaⁿti cwiluiiñe, nchiiti ja. Ee mꞌaaⁿ cwii tjo̱o̱cheⁿ na nluiindyo̱. ");
INSERT INTO amuNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Xjeⁿ na to̱ꞌa na matseitsꞌoomndyo̱ nnꞌaⁿ ñequio ndaatioo, meiⁿ ticatseiꞌno̱ⁿꞌa na jom tsꞌiaⁿꞌaⁿ na nntseicanoomꞌm jnaaⁿ nnꞌaⁿ. Sa̱a̱ matsꞌaa tsꞌiaaⁿmeiiⁿ cha catseicaꞌmo̱ⁿnaꞌ nda̱a̱ nnꞌaⁿ Israel na ljoꞌ cwiluiiñê. ");
INSERT INTO amuNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ndoꞌ Juan tjeiꞌyuuꞌñetyeeⁿ nda̱a̱yâ. Matsoom: —Ntyꞌiano̱o̱ⁿ na jnaⁿ Espíritu Santo cañoomꞌluee. Jndyocue chaꞌcwijom catuꞌ, ljooꞌñe ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Xjeⁿꞌñeeⁿ meiⁿ tîcatseiꞌno̱ⁿꞌa ꞌñeeⁿ juu na nluiiñe nquii na nntseicanduuꞌ jnaaⁿ nnꞌaⁿ. Sa̱a̱ tjañjoomꞌ tsꞌo̱o̱ⁿ quia jñom Tyꞌo̱o̱tsꞌom ja na catseitsꞌoomndyo̱ nnꞌaⁿ, tsoom no̱o̱ⁿ: “Nntyꞌiaꞌnjomꞌ na nndyocue Espíritu nacjooꞌ cwii tsꞌaⁿ, ndoꞌ nljooꞌñe ñꞌeⁿñê. Juu tsaⁿꞌñeeⁿ jnda̱ tyꞌio̱ⁿya tsꞌiaaⁿ jom na nntseitsꞌoomñê nnꞌaⁿ ñꞌeⁿ Espíritu Santo.” ");
INSERT INTO amuNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ndoꞌ jnda̱ ntyꞌiano̱o̱ⁿya na tuii na ljoꞌ ñꞌeⁿñê. Joꞌ chii macwjiꞌyuuꞌndyo̱ na jom cwiluiiñê Jnda Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Cwiicheⁿ xuee meintyjeeꞌnndaꞌ Juan ñequio wendyô̱ jâ nnꞌaⁿ na cwilaꞌjomndyô̱ ñꞌoom na mañequiaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ndoꞌ quia ntyꞌiaaⁿꞌaⁿ Jesús na mawjaawinom joꞌ joꞌ, matsoom nda̱a̱yâ: —Cantyꞌiaꞌyoꞌ, luaaꞌ tsꞌaⁿ na cwiluiiñe catsmaⁿ tsmeiⁿꞌ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Ndoꞌ wendyô̱ jâ na cwilaꞌjomndyô̱ ñꞌoom na tyoñequiaaⁿ, quia na jndya̱a̱yâ ñꞌoomwaaꞌ, saantyjo̱o̱yâ naxeⁿꞌ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Taqueⁿ Jesús ndoꞌ ntyꞌiaaⁿꞌaⁿ na cwitsaantyjo̱o̱yâ naxeeⁿꞌeⁿ. Taxꞌeeñê nda̱a̱yâ, tsoom: —¿Aa waa na nlꞌaꞌyoꞌ ja? Ndoꞌ lꞌuuyâ nnoom: —Rabí, ¿cwaaⁿ wꞌaa nncjaꞌmeintyjeꞌ jeꞌ? Ñꞌoom rabí matsonaꞌ tsꞌaⁿ na maꞌmo̱ⁿ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Matsoom nda̱a̱yâ: —Quioꞌyoꞌ mana nntyꞌiaꞌyoꞌ. Quia joꞌ saayâ ñꞌeⁿñê wꞌaa na tjameintyjeeⁿꞌeⁿ. Ndoꞌ chaꞌna ñequiee na matmaaⁿ na squia̱a̱yâ ñꞌeⁿñê. Ljooꞌndyô̱ ñꞌeⁿñê hasta na jnda̱ teinco̱o̱ⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ja Juan ñequio Andrés, tyjee Simón Pedro, jâ jndya̱a̱yâ ñꞌoom na tso Juanꞌñeeⁿ, ndoꞌ saantyjo̱o̱yâ naxeⁿꞌ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Juu Andrésꞌñeeⁿ tjacalꞌueeⁿ xioom Simón. Matsoom nnom: —Jnda̱ jliuuyâ juu na cwiluiiñe Mesías. (Ñꞌoomwaaꞌ matsonaꞌ Cristo, nquii na tqueⁿ Tyꞌo̱o̱tsꞌom na cwjiꞌnꞌmaaⁿñe nnꞌaⁿ.) ");
INSERT INTO amuNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Quia joꞌ tjañꞌoom Andrés xioom na mꞌaaⁿ Jesús. Ntyꞌiaaꞌ Jesús juu, ndoꞌ matsoom: —ꞌU re, Simón, jnda Jonás ꞌu. Jeꞌ nntseicajndyuya ꞌu Cefas. (Ñꞌoomwaaꞌ matsonaꞌ Pedro.) ");
INSERT INTO amuNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Cwiicheⁿ xuee seijndaaꞌñe Jesús na nncjaⁿ tsꞌo̱ndaa Galilea. Quia ljoꞌcheⁿ teincwiñê ñꞌeⁿ Felipe. Matsoom nnom: —Candyoꞌtseijomndyuꞌ ñꞌeⁿndyo̱ tsꞌiaaⁿ na matsꞌaa. ");
INSERT INTO amuNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Juu Felipeꞌñeeⁿ mañeꞌcwii tsjomꞌm ñequio Andrés ñꞌeⁿ Pedro. Joona nnꞌaⁿ tsjoom Betsaida. ");
INSERT INTO amuNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ndoꞌ tjacalꞌue Felipe Natanael. Matsoom nnom: —Jnda̱ jliuuyâ nquii na cantyja ꞌnaaⁿꞌ seiljeii Moisés nacjooꞌ libro na chuunaꞌ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na matsa̱ꞌntjomnaꞌ. Ndoꞌ mati ntꞌomcheⁿ profetas tyolaꞌljeiina cantyja ꞌnaaⁿꞌ tsaⁿmꞌaaⁿꞌ. Majuu Jesús joꞌ, tsꞌaⁿ tsjoom Nazaret, na cwilue nnꞌaⁿ na jnda José juu. ");
INSERT INTO amuNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Tso Natanael: —Ndooꞌ ntyjii na cweꞌ Nazaret xocwitquiooꞌñe cwii tsꞌaⁿ na tꞌmaⁿ nnteijneiⁿ nnꞌaⁿ. Tꞌo̱ Felipe nnoom, matso: —Candyoꞌ sa. Nntyꞌiaꞌnjomꞌ jom. ");
INSERT INTO amuNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ntyꞌiaaꞌ Jesús na ndyocwjeꞌcañoom Natanael jom. Matsoom: —Cantyꞌiaꞌyoꞌ tsaⁿmꞌaaⁿꞌ tiquinquiuꞌnnꞌaaⁿ nnꞌaⁿ. Jom mayuuꞌcheⁿ cwiluiiñê tsꞌaⁿ Israel. ");
INSERT INTO amuNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Taxꞌeeñe Natanael nnoom: —¿Chiuu ljeiꞌyuꞌ Ta na ljoꞌ matseixmaⁿya? Tꞌo̱ Jesús, matsoom nnom: —Cwii tjo̱o̱cheⁿ na nncjaacwaⁿ Felipe ꞌu, ntyꞌiaya ꞌu quia mꞌaaⁿꞌ waꞌ xꞌee tsꞌoom higuera ꞌnaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ndoꞌ tꞌo̱ Natanael, matsoom: —ꞌU tsꞌaⁿ na maꞌmo̱o̱ⁿꞌ ñꞌoom naya nda̱a̱ nnꞌaⁿ, ꞌu maxjeⁿ cwiluiindyuꞌ Jnda Tyꞌo̱o̱tsꞌom. ꞌU cwiluiindyuꞌ rey cwentaa jâ nnꞌaⁿ Israel. ");
INSERT INTO amuNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Tꞌo̱ Jesús: —¿Aa cweꞌ ncꞌe na tsjo̱o̱ya na ntyꞌiaya ꞌu xꞌee tsꞌoom higuera ꞌnaⁿꞌ, aa cweꞌ joꞌ na matseiyuꞌ ñꞌeⁿndyo̱? Maxjeⁿ maniom na jndati laꞌxmaⁿnaꞌ cantyja ꞌnaⁿya na quia wjaꞌntyꞌiaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ndoꞌ matsotyeeⁿ nnom: —Ñꞌoom na mayuuꞌcheⁿ matsjo̱o̱ya nda̱a̱ꞌyoꞌ. ꞌO nntyꞌiaꞌyoꞌ na nnaaⁿ cañoomꞌluee. Ndoꞌ nntyꞌiaꞌyoꞌ na nnquiocue ángeles na mꞌaaⁿ ja na cwiluiindyo̱ tsꞌaⁿ na jnaaⁿya na mꞌaaⁿ Tyꞌo̱o̱tsꞌom, ndoꞌ na nncꞌoowanndaꞌna. ");
INSERT INTO amuNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Xuee jnda̱ ndyee na tuii na luaaꞌ toco cwii tsꞌaⁿ tsjoom Caná, tsꞌo̱ndaa Galilea. Ndoꞌ seijomñe tsondyee Jesús. ");
INSERT INTO amuNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ndoꞌ joo nnꞌaⁿ na tꞌunco tꞌmaⁿna Jesús ñequio jâ nnꞌaⁿ na cwilaꞌjomndyô̱ ñꞌeⁿñê na mati calajomndyô̱ ñꞌeⁿndyena na cwiꞌuncona. ");
INSERT INTO amuNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Jnda̱ na ntquieꞌ winom, tsondyee Jesús tso nnoom: —Ticwijndeii winom. ");
INSERT INTO amuNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Tꞌo̱ Jesús nnom, matsoom: —Naⁿ, ¿ljoꞌ nntsaꞌ ja? Tyooweꞌntyjo̱ xjeⁿ na nntsꞌaa cwii nnom na tixocanda̱a̱ nluii na cweꞌ tsꞌaⁿ nntsꞌaa. ");
INSERT INTO amuNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Matso tsoñeeⁿ nda̱a̱ nnꞌaⁿ na cwindyeꞌntjom joꞌ joꞌ: —Calꞌaꞌyoꞌ chaꞌtso na nntsa̱ꞌntjoom ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Maniom ñꞌoom na cwiqua̱a̱ⁿ jaa nnꞌaⁿ judíos na cwinndyuuꞌa ñequio na cwitmaaⁿya ꞌnaⁿ. Wꞌaa yuu na toco tsaⁿꞌñeeⁿ meintyjeeꞌ yom ljoo tꞌmaⁿ na tuiinaꞌ ñꞌeⁿ ljo̱ꞌ, na quiwilꞌueeꞌndyena na cwilaꞌcanda̱a̱ꞌndyena costumbreꞌñeeⁿ. Cwiwijndeii cwii cwii tsjooꞌñeeⁿ chaꞌna ñequiee hasta yom xjo lata ndaa. ");
INSERT INTO amuNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Seineiⁿ Jesús nda̱a̱ nnꞌaⁿ na cwindyeꞌntjom joꞌ joꞌ. Matsoom: —Calacatoꞌyoꞌ ljoomeiⁿꞌ ñequio ndaatioo. Ndoꞌ jlaꞌcatooꞌ naⁿꞌñeeⁿ joonaꞌ hasta tooꞌ cwijomnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Jnda̱ joꞌ matsoom nda̱a̱na: —Jeꞌ catjeiꞌyoꞌ chjoowiꞌ juunaꞌ. Catsaañꞌomꞌyoꞌ na mꞌaaⁿ tsꞌaⁿ na matsa̱ꞌntjom nnꞌaⁿ na cwilaꞌñꞌoomꞌndye nantquie. Joꞌ chii tyꞌeñꞌomna juunaꞌ na mꞌaaⁿ tsaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ndoꞌ juu tsꞌaⁿ na matsa̱ꞌntjom naⁿꞌñeeⁿ tꞌuu chjoowiꞌ ndaatioo na jnda̱ seicwaqueⁿ Jesús na winom. Ticaljeii tsaⁿꞌñeeⁿ yuu jnaⁿnaꞌ sa̱a̱ nnꞌaⁿ na cwindyeꞌntjom joꞌ joꞌ nquiucheⁿna yuu tjeiiꞌna juunaꞌ. Quia joꞌ tcwaⁿ tsaⁿꞌñeeⁿ tsꞌaⁿ na macoco. ");
INSERT INTO amuNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Matsoom nnom: —Ticwii cwii joo na ñetjo̱ na tꞌunco nnꞌaⁿ, najndyee tyoñeꞌquia nnꞌaⁿ winom na yaticheⁿ na nncwe ncꞌiaana. Ndoꞌ quia na jnda̱ mawjaacjoo naⁿꞌñeeⁿ na cwiwena, quia joꞌ cwiñeꞌquiana winom na ticueꞌntyjo̱ na yanaꞌ. Sa̱a̱ ꞌu jeꞌ, jnda̱ seiljoꞌ winom na yaticheⁿ na quia jeꞌcheⁿ nleilꞌuenaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Mꞌaaⁿ Jesús Caná tsꞌo̱ndaa Galilea quia sꞌaajñeeⁿ tsꞌiaaⁿ na tixocaluii na cweꞌ tsꞌaⁿ nntsꞌaa. Ndoꞌ na luaaꞌ sꞌaaⁿ tꞌmo̱o̱ⁿ na tꞌmaⁿ cwiluiiñê. Mancꞌe joꞌ na jâ nnꞌaⁿ na cwilaꞌjomndyô̱ ñꞌeⁿñê, jnaⁿnaꞌ na cwilayuuꞌâ ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Jnda̱ na tuii na luaaꞌ, quia joꞌ jâ nnꞌaⁿ na cwindya̱a̱yâ ñꞌoom na mañequiaaⁿ, saayâ Capernaum ñꞌeⁿñê, ñequio tsoñeeⁿ ñequio ntyjeeⁿ. Ndoꞌ ljooꞌndyô̱ joꞌ joꞌ cwantindyo xuee. ");
INSERT INTO amuNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Juu xjeⁿꞌñeeⁿ jnda̱ wjaawindyooꞌ nncueeꞌ ncuee pascua quia jaa nnꞌaⁿ judíos cwilacwja̱a̱ canmaⁿ. Joꞌ chii saayâ Jerusalén ñꞌeⁿ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Tachꞌeeⁿꞌ watsꞌom tꞌmaⁿ, joꞌ joꞌ ljeiiⁿ nnꞌaⁿ na cwinda̱a̱ quioondyo ñꞌeⁿ canmaⁿ ñꞌeⁿ cantuꞌ. Ndoꞌ mati meindyuaandye nnꞌaⁿ na cwilaꞌjndyoondye sꞌom ꞌnaaⁿ nnꞌaⁿ na cwiꞌooquieꞌ watsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ndoꞌ jnda̱ na ntyꞌiaaⁿꞌaⁿ na luaaꞌ, quia joꞌ sꞌaaⁿ lꞌuaa tsjaꞌjneiⁿ, jnda̱ chii jleintyjo̱o̱ⁿ naⁿꞌñeeⁿ. Tjeiiⁿꞌeⁿ chaꞌtsondye joona chꞌeeⁿꞌ tachꞌeⁿ watsꞌomꞌñeeⁿ. Mati canmaⁿ ñꞌeⁿ quioondyo. Ndoꞌ seicantqueeⁿ meiⁿsa na cwileiꞌcho nnꞌaⁿ na cwilaꞌjndyoondye sꞌom joꞌ joꞌ. Seiquiaⁿ sꞌom ꞌnaaⁿ naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ndoꞌ nda̱a̱ nnꞌaⁿ na cwinda̱a̱ cantuꞌ matsoom: —Catjeiꞌyoꞌ quiooꞌmꞌaⁿꞌ ñjaaⁿñe. Tacalꞌaꞌyoꞌ na waaꞌ Tsotya̱ya na matseijomnaꞌ chaꞌna tsꞌua. ");
INSERT INTO amuNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Quia joꞌ jâ nnꞌaⁿ na tꞌmaaⁿ na calaꞌjomndyô̱ ñꞌeⁿñê tsꞌiaaⁿ na machꞌeeⁿ tjañjoomꞌ nꞌo̱o̱ⁿyâ ñꞌoom na mawaa cjooꞌ libro Salmos. Matsonaꞌ: “Nlaꞌcueeꞌ nnꞌaⁿ ja jnaaⁿꞌ na queeⁿ tsꞌo̱o̱ⁿya na nleilꞌueeꞌndyena waaꞌ Tyꞌo̱o̱tsꞌom chaꞌxjeⁿ na matsa̱ꞌntjomnaꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ndoꞌ taꞌxꞌee nnꞌaⁿ judíos nnoom, jluena: —¿Cwaaⁿ tsꞌiaaⁿ nntsaꞌ na tixocaluii juunaꞌ na cweꞌ tsꞌaⁿ nntsꞌaa na mꞌmo̱ⁿnaꞌ nda̱a̱yâ na waa najndeii na matseixmaⁿꞌ na nmeiiⁿꞌ macheꞌ? ");
INSERT INTO amuNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Tꞌo̱ Jesús nda̱a̱na, matsoom: —Calatyuiꞌyoꞌ watsꞌomwaañe ndoꞌ ñeꞌndyee xuee nntseiwa̱nndaꞌa juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ndoꞌ tꞌo̱o̱ nnꞌaⁿ judíosꞌñeeⁿ: —Wenꞌaaⁿ nchooꞌ yom ntyu tjacaa na tuii watsꞌomwaañe, ndoꞌ ꞌu jeꞌ ¿aa cweꞌ ñeꞌndyee xuee nntseiweꞌ juunaꞌ? ");
INSERT INTO amuNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Sa̱a̱ seijoomꞌñê na juu seiiⁿꞌeⁿ cwiluiiñenaꞌ watsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Joꞌ chii jnda̱ na tquiaa Tyꞌo̱o̱tsꞌom na tandoꞌxcoom jnda̱ na tueeⁿꞌeⁿ, jâ nnꞌaⁿ na cwindya̱a̱yâ ñꞌoom na mañequiaaⁿ tjañjoomꞌ nꞌo̱o̱ⁿyâ na ljoꞌ tsoom. Ndoꞌ jlayuuꞌâ ñꞌoom na seineiiⁿ ndoꞌ mati ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na teiyo teiljeii. ");
INSERT INTO amuNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Yocheⁿ na tyomꞌaaⁿ Jesús Jerusalén na tyowaa xuee Pascua quia jaa nnꞌaⁿ judíos cwilaꞌwja̱a̱ya canmaⁿ, nnꞌaⁿ na mꞌaⁿ joꞌ joꞌ tyontyꞌiaana jndye nnom tsꞌiaaⁿ na tyochꞌeeⁿ na tixocanda̱a̱ nluii na cweꞌ tsꞌaⁿ nntsꞌaa. Joꞌ chii jndyendyena tyolaꞌyuꞌna na cwiluiiñê Cristo. ");
INSERT INTO amuNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Sa̱a̱ tînquiaañê ñꞌeⁿndyena, ee ntyjeeⁿ chiuu nꞌomna. ");
INSERT INTO amuNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Meiⁿ ticaⁿnaꞌ na cwjiꞌyuuꞌñe tsꞌaⁿ nnoom cantyja ljoꞌ laꞌxmaⁿ nnꞌaⁿ, ee maxjeⁿ mantyjeeⁿ chiuu nꞌomna. ");
INSERT INTO amuNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Tyomꞌaaⁿ cwii tsꞌaⁿ na tyoluiitquieñe quiiꞌntaaⁿ nnꞌaⁿ judíos. Tsaⁿꞌñeeⁿ tyotseijomñê ñꞌoom na quitꞌmaⁿ nꞌom nnꞌaⁿ tmaaⁿꞌ fariseos. Jom jñoom Nicodemo. ");
INSERT INTO amuNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Jñoom na mꞌaaⁿ Jesús cwii teijaaⁿ. Matsoom nnom: —Maestro, manquiuuyâ na ꞌu cwiluiindyuꞌ tsꞌaⁿ na jñom Tyꞌo̱o̱tsꞌom na caꞌmo̱ⁿꞌ ñꞌoom naya ꞌnaaⁿꞌaⁿ nda̱a̱yâ. Ee xocanda̱a̱ nntsaꞌ tsꞌiaaⁿmeiⁿꞌ xeⁿ nchii Tyꞌo̱o̱tsꞌom mꞌaaⁿ ñꞌeⁿndyuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesús tꞌo̱o̱ⁿ, matsoom nnom: —Ñꞌoom na mayuuꞌcheⁿ matsjo̱o̱ njomꞌ, xeⁿ ticaluiixcoñe tsꞌaⁿ tixocanda̱a̱ nntseijomñe cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ndoꞌ taxꞌeeñe Nicodemo nnoom, matso: —¿Chiuu nntsꞌaa tsꞌaⁿ na nluiiñennaaⁿꞌaⁿ na jnda̱ tquieñê? Ee tixocanda̱a̱ nncjaaquieeꞌnnaaⁿꞌaⁿ tsiatsjaaⁿꞌ tsoñeeⁿ ndoꞌ na nluiiñennaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesús tꞌo̱o̱ⁿ, matsoom nnom: —Ñꞌoom na mayuuꞌcheⁿ matsjo̱o̱ya njomꞌ. Xeⁿ ticaluiiñe tsꞌaⁿ cantyja ꞌnaaⁿꞌ ndaatioo ndoꞌ ñequio Espíritu, tixocanda̱a̱ nncjaquieeꞌñê cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ncꞌe na nnꞌaⁿ jaa, joꞌ chii mati ndaaya mannꞌaⁿ joona. Maluaaꞌ matseijomnaꞌ tsꞌaⁿ na tuiiñe cantyja ꞌnaaⁿꞌ Espíritu Santo. Tseixmaⁿ tsaⁿꞌñeeⁿ cantyja ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Tinntseiñꞌeeⁿꞌñenaꞌ tsꞌomꞌ juu ñꞌoom na matsjo̱o̱ya: “Maxjeⁿ jndeiꞌnaꞌ na caluiindyoꞌxcoꞌyoꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ndiꞌ na cꞌuaa camꞌaaⁿ jndye, sa̱a̱ tileicantyjo̱ꞌ yuu jnaⁿnaꞌ, meiⁿ yuu wjaanaꞌ. Malaaꞌtiꞌ matseijomnaꞌ na tileicalaꞌno̱ⁿꞌ nnꞌaⁿ chiuu waa na tuiiñe tsꞌaⁿ cantyja ꞌnaaⁿꞌ Espíritu. ");
INSERT INTO amuNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Tꞌo̱ Nicodemo, tsonnaaⁿꞌaⁿ: —Maxjeⁿ ticatseiꞌno̱ⁿꞌa. ");
INSERT INTO amuNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Matso Jesús: —Aa ljoꞌ, ndoꞌ ꞌu tꞌmaⁿ cwiluiindyuꞌ na maꞌmo̱o̱ⁿꞌ nda̱a̱ nnꞌaⁿ Israel. Joꞌ chii ticatseitiuuya na tileicatseiꞌno̱ⁿꞌ ñꞌoommeiiⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ñꞌoom na mayuuꞌcheⁿ matsjo̱o̱ya njomꞌ. Matseina̱ⁿya cantyja na mantyjiiya, ndoꞌ macwjiꞌyuuꞌndyo̱ ljoꞌ na jnda̱ ntyꞌiano̱o̱ⁿ, sa̱a̱ ꞌo tiñeꞌcalayuꞌyoꞌ ñꞌoomꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Jnda̱ mamatseina̱ⁿya nda̱a̱ nnꞌaⁿ cantyja ꞌnaaⁿ ꞌnaⁿ na niom tsjoomnancue cha calaꞌno̱ⁿꞌyoꞌ, sa̱a̱ tiñeꞌcalayuꞌyoꞌ ñꞌoomꞌñeeⁿ. Quia joꞌ, ¿chiuu ya nntsꞌaa cha na nlayuꞌyoꞌ ñꞌoom na mañequia cantyja ꞌnaaⁿꞌ cañoomꞌluee? ");
INSERT INTO amuNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","’Ee tjaaꞌnaⁿ tsꞌaⁿ na jnda̱ tjawa cañoomꞌluee cha nnda̱a̱ nntseicandii nnꞌaⁿ chiuu macaⁿnaꞌ na calꞌana na nlcoꞌxcwenaꞌ ntyjii Tyꞌo̱o̱tsꞌom ñꞌeⁿndyena. Macanda̱ ja na cwiluiindyo̱ tsꞌaⁿ na jnaaⁿya cañoomꞌluee ntyjiiya. ");
INSERT INTO amuNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Quia ñetꞌom nnꞌaⁿ judíos jo ndoꞌ ndyuaa yuu na tjaa nnꞌaⁿ cꞌom, quia joꞌ tyꞌiom Moisés cwii xjo na tuiinaꞌ chaꞌna catsuu cjooꞌ cwii tsꞌoom. Maluaaꞌ matseijomnaꞌ na nntyꞌioom nnꞌaⁿ ja tsꞌoomꞌnaaⁿ na cwiluiindyo̱ tsꞌaⁿ na jnaaⁿya cañoomꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Luaaꞌ nluii cha meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na matseiyuꞌ ñꞌeⁿndyo̱ nntseixmaⁿ na ticantycwii na nncwandoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","’Ncꞌe Tyꞌo̱o̱tsꞌom tꞌmaⁿ waa na mꞌaaⁿ na candyaꞌ tsꞌoom nnꞌaⁿ tsjoomnancue, joꞌ chii Ja na ñennco̱ na cwiluiindyo̱ Jnaaⁿ tquiaaⁿ na tuiindyo̱ cha ticwii cwii tsꞌaⁿ na nntseiyuꞌ ñꞌeⁿndyo̱ tixocatsuuñe. Mꞌaaⁿ na ticantycwii na wandoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ja na cwiluiindyo̱ Jnda Tyꞌo̱o̱tsꞌom nchii jñoom ja quiiꞌntaaⁿ nnꞌaⁿ cha na catꞌuiiya joona cantyja jnaaⁿna. Jom jñoom ja cha nnda̱a̱ nluiꞌnꞌmaaⁿndyena. ");
INSERT INTO amuNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","’Meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na nntseiyuꞌ ñequio ja, ticatꞌuii Tyꞌo̱o̱tsꞌom juu cantyja ꞌnaaⁿꞌ jnaaⁿꞌ. Sa̱a̱ meiⁿquia tsꞌaⁿ na tiñeꞌcatseiyuꞌ, jeꞌ mamatꞌuiinaꞌ juu cantyja jnaaⁿꞌ, ee na tiñeꞌcatseiyuꞌ ñꞌeⁿndyo̱ na macanda̱ ja cwiluiindyo̱ Jnaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Jnda̱ mamatꞌuiinaꞌ nnꞌaⁿ na tyoolayuꞌ ee ja na cwiluiindyo̱ naxuee jnda̱ tyja̱cano̱o̱ⁿya joona, sa̱a̱ neiiⁿtinaꞌ na cwilaꞌjomndyena cantyja ꞌnaaⁿꞌ na jo̱o̱ⁿñe, ee cwilꞌana yuu na ticatsa̱ntjomnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ee ticwii cwii tsꞌaⁿ na machꞌee natia, jeeⁿ jnoomꞌm ja na cwiluiindyo̱ naxueeñe. Tsaⁿꞌñeeⁿ tiñeꞌcatseijomñê ñꞌeⁿndyo̱ ja, ee jeeⁿ nquiaⁿꞌaⁿ na nntseicano̱o̱ⁿya natia na machꞌeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Sa̱a̱ juu tsꞌaⁿ na machꞌee yuu na matyꞌiomyanaꞌ, tsaⁿꞌñeeⁿ matseijomñê ñꞌeⁿndyo̱ ja na cwiluiindyo̱ naxueeñe. Ndoꞌ na ljoꞌ cwiwitquiooꞌya na chaꞌtso na machꞌeeⁿ, machꞌeeⁿ ncꞌe Tyꞌo̱o̱tsꞌom mꞌaaⁿ ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Jnda̱ joꞌ jluiꞌ Jesús Jerusalén ndoꞌ jâ nnꞌaⁿ na tꞌmaaⁿ na calaꞌjomndyô̱ ñꞌeⁿ tsꞌiaaⁿ na machꞌeeⁿ, mati jluiiꞌâ ñꞌeⁿñê. Tyomaꞌno̱o̱ⁿyâ ñꞌeⁿñê tsꞌo̱ndaa Judea. Tyomꞌaaⁿyâ joꞌ joꞌ cwantindyo xuee. Ndoꞌ jndye nnꞌaⁿ tquieꞌcañom jom na nleitsꞌoomndye. ");
INSERT INTO amuNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Mati Juan tyotseitsꞌoomñê nnꞌaⁿ cwii joo na jndyu Enón, manndyooꞌ Salim, ee majndye ndaatioo mꞌaaⁿ joꞌ. Ndoꞌ tyoꞌoo nnꞌaⁿ na tyotseitsꞌoomñê joona. ");
INSERT INTO amuNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ee xjeⁿꞌñeeⁿ tyoojuꞌ Herodes jom wꞌaancjo. ");
INSERT INTO amuNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Quia joꞌ ntꞌom nnꞌaⁿ judíos na cwilaꞌjomndye ñꞌoom na mañequiaa jom, jlaꞌñꞌeeⁿꞌ ndyueena ñequio ncꞌiaana nnꞌaⁿ judíos na cweꞌ tquieya. Ee cwilaꞌntjaꞌndye naⁿꞌñeeⁿ ñꞌeⁿndyena cwaaⁿ cwii nnom na jndati tseixmaⁿ na cwiwitsꞌoomndye nnꞌaⁿ. ¿Aa cantyja ꞌnaaⁿꞌ ñꞌoom na mañequiaa Juan, oo, aa cantyja ꞌnaaⁿꞌ Jesús? ");
INSERT INTO amuNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Quia joꞌ nnꞌaⁿ na cwilaꞌjomndye ñꞌoom na mañequiaa Juan tyꞌentyjaaꞌna jom. Jluena nnoom: —ꞌU ta na maꞌmo̱o̱ⁿꞌ cantyja ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom nda̱a̱yâ, juu tsꞌaⁿ na tyocañꞌeⁿ ñꞌeⁿndyuꞌ xndyaaꞌ jndaa Jordán, nquii na tjeiꞌyuuꞌndyuꞌ cantyja ꞌnaaⁿꞌ nda̱a̱yâ, cantyꞌiaꞌ, cwiwitsꞌoomndye nnꞌaⁿ cantyja ꞌnaaⁿꞌaⁿ, ndoꞌ chaꞌtsondye nnꞌaⁿ cwiꞌoontyjo̱ naxeeⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Juan tꞌo̱o̱ⁿ nda̱a̱na, matsoom: —Tjaa na nnda̱a̱ nntsꞌaa tsꞌaⁿ xeⁿ nchii Tyꞌo̱o̱tsꞌom matseijndaaꞌñê ljoꞌ nntseixmaⁿ tsꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mancjoꞌyoꞌ nquiuꞌyoꞌ na ñetsjo̱o̱ cantyja ꞌnaⁿya, ja nchii Cristo cwiluiindyo̱. Tyꞌo̱o̱tsꞌom tyꞌioom tsꞌiaaⁿ ja na catseijndo̱ꞌa nꞌom nnꞌaⁿ na calaꞌjndaaꞌndyena naquiiꞌ nꞌomna na calaꞌljona Cristo. ");
INSERT INTO amuNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ꞌO cwilaꞌno̱ⁿꞌyoꞌ ñꞌoom na tjañoomꞌ na juu tsaⁿsꞌa na macoꞌñom yuscu na macoco ñꞌeⁿñê, masaaꞌ yuscuꞌñeeⁿ jom. Sa̱a̱ juu tsꞌaⁿ na matseijomñe ñꞌeⁿ tsaⁿsꞌaꞌñeeⁿ, nchii mꞌaaⁿ na liooꞌ na macoꞌñom xꞌiaaꞌ yuscuꞌñeeⁿ. Nchii joꞌ. Cwiquioo na neiiⁿꞌ na mandiiñe ñꞌoom na matseineiⁿ xꞌiaaꞌ. Maluaaꞌ matseijomnaꞌ na matseicanda̱a̱ꞌñenaꞌ na neiⁿya cantyja ꞌnaaⁿꞌ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Joꞌ chii jeeⁿ xcwe na jom cjaaluiitꞌmaⁿñetyeeⁿ sa̱a̱ ja catseicjetinaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Tsoti Juan: —Ncꞌe tsaⁿmꞌaaⁿꞌ jnaaⁿ cañoomꞌluee, tꞌmaⁿti cwiluiiñê, nchiiti chaꞌtsondye nnꞌaⁿ. Ja na cweꞌ tsꞌaⁿ ja, matseixmaⁿya cantyja ꞌnaaⁿꞌ tsjoomnancue ndoꞌ matseina̱ⁿya cantyja ꞌnaaⁿꞌnaꞌ. Sa̱a̱ nquii tsaⁿmꞌaaⁿꞌ na jnaaⁿ cañoomꞌluee, cwiluiitꞌmaⁿñetyeeⁿ na chaꞌtso. ");
INSERT INTO amuNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ndoꞌ macwjiꞌyuuꞌñê cantyja na jnda̱ ntyꞌiaaⁿꞌaⁿ ñequio na jnda̱ jñeeⁿ, sa̱a̱ tjaaꞌnaⁿ ꞌñeeⁿ juu ñeꞌcoꞌñom ñꞌoom na macwjiꞌyuuꞌñê. ");
INSERT INTO amuNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Juu tsꞌaⁿ na macoꞌñom ñꞌoom na macwjiꞌyuuꞌñê, matseijomñe tsaⁿꞌñeeⁿ na Tyꞌo̱o̱tsꞌom cwiluiiñe na mayuuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ee nquii na jñom Tyꞌo̱o̱tsꞌom jo nda̱a̱ nnꞌaⁿ, ñꞌoomꞌm matseineiⁿ, ee canda̱a̱ꞌya mañequiaaⁿ Espíritu na cwiluiiñê naquiiꞌ tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Nquii Tyꞌo̱o̱tsꞌom na cwiluiiñê Tsotya̱a̱ya mꞌaaⁿ na candyaꞌ tsꞌoom Jnaaⁿ. Ndoꞌ naquiiꞌ lꞌo̱ jnda̱ tqueeⁿ chaꞌtsoti na maniom. ");
INSERT INTO amuNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na matseiyuꞌ ñequio Jnda Tyꞌo̱o̱tsꞌom, matseixmaⁿ na ticantycwii na wandoꞌ añmaaⁿꞌ. Sa̱a̱ ꞌñeeⁿ juu na ticatseiñꞌoomꞌñe na nntseiyuꞌ ñequio Jnaaⁿ, tsaⁿꞌñeeⁿ xocandaaꞌ na nncwandoꞌ añmaaⁿꞌ. Tyeⁿ waa na matseiwꞌii Tyꞌo̱o̱tsꞌom juu. ");
INSERT INTO amuNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Nnꞌaⁿ na cwiluiindye tmaaⁿꞌ nnꞌaⁿ fariseos tyondyena na majndyendyeti nnꞌaⁿ teitsꞌoomndye cantyja ꞌnaaⁿꞌ Jesús, nchiiti cantyja ꞌnaaⁿꞌ Juan. ");
INSERT INTO amuNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Sa̱a̱ na mayuuꞌcheⁿ nquii Jesús tîcatseitsꞌoomñê nnꞌaⁿ. Macanda̱ jâ nnꞌaⁿ na tꞌmaaⁿ na calaꞌjomndyô̱ ñꞌeⁿñê, jâ lꞌaayâ tsꞌiaaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Joꞌ chii quia na jñeeⁿ na luaaꞌ cwilue fariseosꞌñeeⁿ, jlueeⁿꞌeⁿ tsꞌo̱ndaa Judea ñꞌeⁿndyô̱ na nntsaayâ Galilea. ");
INSERT INTO amuNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ndoꞌ na cwitsaayâ joꞌ joꞌ majndaaꞌ na nncwino̱o̱ⁿyâ tsꞌo̱ndaa Samaria. ");
INSERT INTO amuNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Joꞌ chii squia̱a̱yâ cwii tsjoom na jndyu Sicar tsꞌo̱ndaa Samaria. Tsjoomꞌñeeⁿ manndyooꞌ mꞌaaⁿnaꞌ yuu waa tyuaa na jndaaꞌ José nnom tsotyeeⁿ Jacob. ");
INSERT INTO amuNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Joꞌ joꞌ tyowaa tsuiꞌ na sꞌaa Jacob. Ndoꞌ Jesús, na teijñaⁿꞌaⁿ na jñoom nato, tjacjom nacañoomꞌ tsuiꞌñeeⁿ. Ndoꞌ jnda̱ tueeꞌ quiajmeiⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Xjeⁿꞌñeeⁿ tyjeꞌcañoom cwii yuscu Samaria joꞌ joꞌ na nncwjiꞌ ndaatioo. Matsoom nnom: —Quiaaꞌ ndaatioo nncꞌua. ");
INSERT INTO amuNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ndoꞌ jâ nnꞌaⁿ na tꞌmaaⁿ na calaꞌjomndyô̱ ñꞌeⁿñê, xjeⁿꞌñeeⁿ jnda̱ saayâ quiiꞌ tsjoom. Saalajndaayâ na nlcwaaꞌâ ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Matso yuscu Samaria nnoom: —¿Chiuu na macaⁿꞌ ndaatioo no̱o̱ⁿ, ee ꞌu cwiluiindyuꞌ tsꞌaⁿ judío ndoꞌ ja cwiluiindyo̱ samaritana? Luaaꞌ tso yuscuꞌñeeⁿ ncꞌe nnꞌaⁿ judíos tiquilaꞌtjoomꞌndyena ñequio nnꞌaⁿ samaritanos. ");
INSERT INTO amuNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Tꞌo̱ Jesús nnom, tsoom: —Xeⁿ cweꞌ matseiꞌno̱ⁿꞌ na jeeⁿ jnda tseixmaⁿ naya na ñeꞌcatsꞌaa Tyꞌo̱o̱tsꞌom ꞌu, ndoꞌ xeⁿ matseiꞌno̱ⁿꞌ ꞌñeeⁿ cwiluiindyo̱ na macaⁿꞌa ndaatioo njomꞌ, nntseityꞌoondyuꞌ no̱o̱ⁿ na cateijndeiya ꞌu, ndoꞌ ja jnda̱ tquiaya cwii na matseijomnaꞌ ndaatioo na nñequiaanaꞌ na ticantycwii na wandoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Matso yuscuꞌñeeⁿ nnoom: —Ta, tjaaꞌnaⁿ ꞌnaⁿ cꞌoomꞌ na nncwjiꞌ ndaatioo, ndoꞌ tsuiꞌwaa, jeeⁿ njoomnaꞌ. Quia joꞌ ¿yuu nncꞌoomꞌyuꞌ ndaatiooꞌñeeⁿ na nntseixmaⁿya na ticantycwii na wando̱ꞌa? ");
INSERT INTO amuNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","¿Aa nntsꞌaacheⁿnaꞌ na macheꞌ na ꞌu cwiluiitꞌmaⁿndyuꞌtiꞌ nchiiti weloo welooya Jacob? Ee jom tyoꞌom ndaa tsuiꞌwaa, mati ntseinaaⁿ ñequio quiooꞌ ntsmeiiⁿꞌeⁿ, ndoꞌ tquiaaⁿ juunaꞌ nda̱a̱ jâ. ");
INSERT INTO amuNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Tꞌo̱ Jesús nnom, matsoom: —Chaꞌtso nnꞌaⁿ na cwiwe ndaatioomeiiⁿ nndyo na ñeꞌcwenndaꞌna. ");
INSERT INTO amuNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Sa̱a̱ nnꞌaⁿ na cwiwena ndaa na mañequia tixocatsꞌaanaꞌ na ñecwetina ee nntsꞌaanaꞌ naquiiꞌ nꞌomna chaꞌcwijom ndaa na cwileiꞌwo̱o̱naꞌ tsꞌom xo̱ꞌ na ticantquieeꞌnaꞌ na nntsꞌaanaꞌ na tijoom cantycwii na nntaꞌndoꞌna. ");
INSERT INTO amuNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ndoꞌ yuscuꞌñeeⁿ matso: —Jeeⁿ ꞌu Ta quiaaꞌ ndaatioowaaꞌ cha na tacandyo na ñeꞌcꞌuatya̱, meiⁿ tantseicachjuundyo̱ na ñequiiꞌcheⁿ na candyo̱cwjiiꞌa juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Matso Jesús nnom: —Cjaꞌ, cwaaⁿꞌ saꞌ, ndoꞌ jnda̱ joꞌ quioꞌyoꞌ ñjaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Tꞌo̱ yuscuꞌñeeⁿ nnoom: —Ja tjaaꞌnaⁿ sꞌaya. Matso Jesús nnom: —Majoꞌndyo ñꞌoom na matsuꞌ na ꞌu tjaaꞌnaⁿ saꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ee jnda̱ ñetꞌoom ꞌom saꞌ ndoꞌ juu tsꞌaⁿ na mꞌaaⁿ ñꞌeⁿndyuꞌ jeꞌ, nchii saꞌ jom. Cantyja na luaaꞌ waa, mayuuꞌ ñꞌoom tsuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Jnda̱ na jndii yuscuꞌñeeⁿ ñꞌoomwaaꞌ, tsoom: —Jeeⁿ ꞌu Ta, matseiꞌno̱ⁿꞌa na ꞌu cwiluiindyuꞌ profeta. ");
INSERT INTO amuNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Weloo weloo jâ nnꞌaⁿ samaritanos tyolaꞌtꞌmaaⁿꞌndyena Tyꞌo̱o̱tsꞌom sjo̱waa. Sa̱a̱ ꞌo nnꞌaⁿ judíos cwinduꞌyoꞌ watsꞌom tꞌmaⁿ ꞌnaⁿꞌyoꞌ Jerusalén joꞌ joꞌ calaꞌtꞌmaaⁿꞌndye nnꞌaⁿ jom. ");
INSERT INTO amuNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Matso Jesús nnom yuscuꞌñeeⁿ: —ꞌU yuscu, catseiyuꞌ ñꞌoom na matsjo̱o̱ njomꞌ na manncueꞌntyjo̱ xjeⁿ na nlaꞌtꞌmaaⁿꞌndye nnꞌaⁿ Tsotya̱ya meiⁿquiayuucheⁿ, nchii cweꞌ sjo̱waa oo Jerusalén. ");
INSERT INTO amuNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ꞌO nnꞌaⁿ Samaria jeeⁿ cachjoo cwilaꞌno̱ⁿꞌyoꞌ cantyja ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom, ndoꞌ cweꞌ cwilaꞌtꞌmaaⁿꞌndyoꞌtoꞌyoꞌ jom. Sa̱a̱ jâ nnꞌaⁿ judíos cwilaꞌno̱o̱ⁿꞌyayâ ꞌñeeⁿ cwilaꞌtꞌmaaⁿꞌndyô̱. Ee cantyja ꞌnaaⁿyâ joꞌ na macwjiꞌnꞌmaaⁿñê nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Sa̱a̱ manncueꞌntyjo̱ xjeⁿ, ndoꞌ jeꞌ mamaweꞌntyjo̱ na joo nnꞌaⁿ na mayuuꞌcheⁿ na cwilaꞌtꞌmaaⁿꞌndye Tsotya̱ya, macaⁿnaꞌ na calaꞌtmaaⁿꞌndyena jom cantyja ꞌnaaⁿꞌ Espíritu na cwiluiiñê ndoꞌ ñequio na mayoona. Ee lꞌue tsꞌom Tsotya̱ya na luaaꞌ calaꞌtꞌmaaⁿꞌndye nnꞌaⁿ jom. ");
INSERT INTO amuNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Tyꞌo̱o̱tsꞌom cwiluiiñê Espíritu. Joꞌ chii joo nnꞌaⁿ na ñeꞌcalaꞌtꞌmaaⁿꞌndye jom, macaⁿnaꞌ na cꞌomna nacje ꞌnaaⁿꞌ Espíritu Santo, ndoꞌ ñequio na mayoona. ");
INSERT INTO amuNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Matso yuscuꞌñeeⁿ nnoom: —Ja ntyjii na nncwjeꞌcañoom Mesías, manqueⁿ na cwiluiiñê Cristo. Jom quia na nncwjeeⁿꞌeⁿ, nntseinchoomꞌm chaꞌtso ñꞌoommeiⁿꞌ nda̱a̱ya. ");
INSERT INTO amuNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Matso Jesús nnom: —Mannco̱ na matseina̱ⁿya ñꞌeⁿndyuꞌ cwiluiindyo̱ nqueⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Majuu xjeⁿꞌñeeⁿ jâ nnꞌaⁿ na cwilaꞌjomndyô̱ ñꞌeⁿñê squieꞌcaño̱o̱ⁿyâ joona. Ticjaweeꞌ nꞌo̱o̱ⁿyâ na matseineiiⁿ ñꞌeⁿ cwii yuscu, sa̱a̱ meiiⁿ na ljoꞌ tjaaꞌnaⁿ na taꞌxꞌa̱a̱yâ ꞌndyoo yuscuꞌñeeⁿ: “¿Ljoꞌ lꞌue tsꞌomꞌ?” oo na lꞌuuyâ nnom Ta Jesús: “¿Cwaaⁿ ñꞌoom matseineiⁿꞌ ñequio yuscumꞌaaⁿꞌ?” ");
INSERT INTO amuNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ndoꞌ ꞌndii yuscuꞌñeeⁿ tsjoo ꞌnaaⁿꞌaⁿ, tjalcweeⁿꞌeⁿ tsjoom. Tjacatsoom nda̱a̱ nnꞌaⁿ na mꞌaⁿ joꞌ joꞌ: ");
INSERT INTO amuNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Quioꞌyoꞌ na nntsaacantyꞌiaꞌyoꞌ cwii tsaⁿsꞌa na jnda̱ tso no̱o̱ⁿ chaꞌtso na tijoꞌndyo na jnda̱ ñesꞌaa. Mꞌaaⁿꞌ tsꞌo̱o̱ⁿ na juu cwiluiiñe Mesías. ");
INSERT INTO amuNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ndoꞌ jluiꞌ naⁿꞌñeeⁿ tsjoomna, tyꞌena yuu na mꞌaaⁿyâ ñꞌeⁿ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Yocheⁿ na tyooquiena, jâ nnꞌaⁿ na tꞌmaaⁿ na calaꞌjomndyô̱ ñꞌeⁿñê lꞌuuyâ nnoom: —ꞌU Maestro, cwa sa, cwaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Sa̱a̱ matsoom nda̱a̱yâ: —Ja mañꞌo̱ⁿ cwii na nlcwaaꞌa na ꞌo ticaliuꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Quia joꞌ jâ na cwindya̱a̱yâ ñꞌoom na mañequiaaⁿ jlana̱a̱ⁿ cheⁿncjo̱o̱yâ nda̱a̱ ncꞌiaayâ. Lꞌuuyâ: —¿Aa nntsꞌaacheⁿnaꞌ na jndyoñꞌoom cwii tsꞌaⁿ na nlcwaaⁿꞌaⁿ? ");
INSERT INTO amuNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Sa̱a̱ matso Jesús nda̱a̱yâ: —Luaa waa na matseijomnaꞌ nantquie ꞌnaⁿya, na catsꞌaaya yuu na lꞌue tsꞌom nqueⁿ na jñoom ja, hasta na jnda̱ jnda̱a̱ꞌ tsꞌiaaⁿ na tyꞌioom ja. ");
INSERT INTO amuNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","ꞌO waa ñꞌoom tjañoomꞌ na cwinduꞌyoꞌ na ñequiee chiꞌ cwii tjo̱o̱ ndoꞌ nntyjeendye nnꞌaⁿ. Sa̱a̱ ja matsjo̱o̱ nda̱a̱ꞌyoꞌ: Caleityꞌiom nda̱a̱ꞌyoꞌ, ndoꞌ cantyꞌiaꞌyoꞌ ndiocheⁿ na mꞌaⁿ nnꞌaⁿ chaꞌcwijom ntjom na jnda̱ tmaⁿ na nncwantjom tsꞌaⁿ cwentaaꞌ Tyꞌo̱o̱tsꞌom. Matseijomnaꞌ joona na jnda̱ tueꞌntyjo̱ xjeⁿ na ntyjeeñe tsꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Juu tsꞌaⁿ na matyjee ntjom na jnda̱ tueꞌ waa na mawantjoom ee matseitjoom nnꞌaⁿ na nndaana na ticantycwii na cwitaꞌndoꞌna. Ndoꞌ na luaaꞌ waa, juu tsꞌaⁿ na manomꞌ ntjom ñecwiixjeⁿ na nñequiaanaꞌ na neiiⁿꞌeⁿ chaꞌxjeⁿ juu tsꞌaⁿ na matyjee ntjom. ");
INSERT INTO amuNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ee juu ñꞌoom na cwilue nnꞌaⁿ na cwii tsꞌaⁿ manomꞌ sa̱a̱ cwiicheⁿ tsꞌaⁿ matyjeeñe, ñꞌoom na mayuuꞌ joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Na majño̱o̱ⁿya ꞌo naquiiꞌ tsꞌiaaⁿ ꞌnaⁿya matseijomnaꞌ chaꞌcwijom na cwitsacatyjeendyoꞌ yuu na nchii ncjoꞌyoꞌ jlaꞌcato̱ꞌyoꞌ tsꞌiaaⁿ. Ntꞌomcheⁿ nnꞌaⁿ jnda̱ jlaꞌnchuꞌna na nncuaa tsꞌiaaⁿ ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom naquiiꞌ nꞌom nnꞌaⁿ ndoꞌ ꞌo jnda̱ macwitsaquieꞌyoꞌ tsꞌiaaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ndoꞌ jndyendye nnꞌaⁿ samaritanos tsjoomꞌñeeⁿ tyolaꞌyuꞌna ñꞌeⁿ Jesús, cweꞌ ncꞌe ñꞌoom ꞌndyoo yuscuꞌñeeⁿ na tjeiꞌyuuꞌñe nda̱a̱na na matso: “Jnda̱ tꞌmo̱o̱ⁿ no̱o̱ⁿ chaꞌtso na tijoꞌndyo na jnda̱ ñesꞌaa.” ");
INSERT INTO amuNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Jnda̱ na tquieꞌcañom nnꞌaⁿ samaritanosꞌñeeⁿ yuu na mꞌaaⁿ Jesús, tyotaⁿna nnoom na caljooꞌñê ñꞌeⁿndyena, ndoꞌ ljooꞌñê tsjoomna we xuee. ");
INSERT INTO amuNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ndoꞌ quia tyondyena ñꞌoom na tyoñequiaaⁿ, jndyendyetina tyolaꞌyuꞌna. ");
INSERT INTO amuNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Ndoꞌ tyoluena nnom yuscuꞌñeeⁿ: —Jeꞌ tachii macanda̱ cweꞌ ñꞌoom na tsuꞌ, joꞌ chii cwilayuuꞌâ. Ee mancjo̱o̱tya̱a̱yâ jnda̱ jndya̱a̱yâ ñꞌoom ꞌñom. Jeꞌ cwilaꞌno̱o̱ⁿꞌâ na jom mayuuꞌcheⁿ cwiluiiñê Cristo na macwjiꞌnꞌmaaⁿñê nnꞌaⁿ tsjoomnancue. ");
INSERT INTO amuNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ndoꞌ quia na jnda̱ teinom we xueeꞌñeeⁿ jluiꞌ Jesús joꞌ joꞌ. Saalcwa̱a̱ꞌâ ñꞌeⁿñê Galilea. ");
INSERT INTO amuNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ee manquiityeeⁿ tjeiꞌyuuꞌñê na ticalaꞌtꞌmaaⁿꞌndye nnꞌaⁿ cwii profeta na mañeꞌcwii ndyuaaⁿꞌaⁿ ñꞌeⁿndyena. ");
INSERT INTO amuNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ndoꞌ quia na squia̱a̱yâ Galilea ñꞌeⁿñê nnꞌaⁿ na mꞌaⁿ joꞌ joꞌ jeeⁿ neiiⁿna jom, jlaꞌljona jom. Ee mati joona tyꞌena Jerusalén quia tueeꞌ ncuee Pascua, ndoꞌ ntyꞌiaana chaꞌtso ꞌnaaⁿ tꞌmaⁿ na tyochꞌeeⁿ joꞌ joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jnda̱ joꞌ saanndaaꞌâ ñꞌeⁿñê Caná tsꞌo̱ndaa Galilea, yuu na seicwaqueeⁿ ndaa na sꞌaanaꞌ winom. Ndoꞌ tsjoom Capernaum tyomꞌaaⁿ cwii tsꞌaⁿ na cwiluiitꞌmaⁿñe cantyja ꞌnaaⁿꞌ gobiernom. Tyochjoo, jnda tsaⁿꞌñeeⁿ, mꞌaaⁿ na wiiꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Quia na jndii tsaⁿꞌñeeⁿ na jnda̱ squia̱a̱yâ Galilea ñꞌeⁿ Jesús na jnaaⁿyâ Judea, tja tsaⁿꞌñeeⁿ na mꞌaaⁿyâ. Sꞌaa tyꞌoo nnoom na cjaⁿ waaꞌ, na catseinꞌmaaⁿ tyochjoo jnda, ee juu mañeꞌcueꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ndoꞌ matso Jesús nnom: —ꞌO maxjeⁿ tixocalaꞌyuꞌyoꞌ na waa najndo̱ xeⁿ ticantyꞌiaꞌnda̱a̱ꞌyoꞌ na nntsꞌaa yuu na xocanda̱a̱ na nluii na cweꞌ tsꞌaⁿ nntsꞌaa. ");
INSERT INTO amuNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Nquii tsꞌaⁿ na cwiluiitꞌmaⁿñe ñꞌeⁿ gobiernom tꞌo̱ ꞌndyoo Jesús. Tso: —Jeeⁿ ꞌu Ta, majeꞌndyo cjaꞌ wꞌaya, cwii tyooweꞌ tiꞌjndaaya. ");
INSERT INTO amuNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Tso Jesús nnom tsaⁿꞌñeeⁿ: —Cjaꞌ ee maxjeⁿ nlcoꞌyanaꞌ tyochjoo jndaꞌ. Ndoꞌ juu tsaⁿsꞌaꞌñeeⁿ seiyoomꞌm ñꞌoom na tso Jesús. Tjalcweeⁿꞌeⁿ waⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ndoꞌ yocheⁿ na mawjaaweⁿꞌeⁿ Capernaum, tquiocatjomndye mosoomꞌm. Jlaꞌcandiina jom, jluena: —Jnda̱ wjaacoꞌyanaꞌ tyochjoo jndaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Taxꞌeeⁿ nda̱a̱ naⁿꞌñeeⁿ ljoꞌ xjeⁿ jnaⁿnaꞌ na tjacoꞌyanaꞌ jnaaⁿ. Ndoꞌ tꞌo̱o̱ naⁿꞌñeeⁿ nnoom: —Wjacheⁿ chjooti na teinom na quiajmeiⁿꞌ ꞌndii tycu na matseiconaꞌ jom. ");
INSERT INTO amuNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Quia joꞌ tsotye tyochjooꞌñeeⁿ seiꞌno̱o̱ⁿꞌo̱ⁿ na mañejuu xjeⁿꞌñeeⁿ tso Jesús nnoom na nlcoꞌyanaꞌ tyochjoo jnaaⁿ. Ndoꞌ seiyoomꞌm ñꞌeⁿ Jesús, mati chaꞌtsondye nnꞌaⁿ waⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Luaaꞌ tsꞌiaaⁿ na jnda̱ we na sꞌaa Jesús na tueⁿꞌeⁿ Galilea na jnaaⁿ Judea, na juu tsꞌiaaⁿꞌñeeⁿ tixocaluii na cweꞌ meiⁿnquia tsꞌaⁿ nntsꞌaa. ");
INSERT INTO amuNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Jnda̱ na tuii nmeiⁿꞌ, saayâ Jerusalén ñꞌeⁿ Jesús ee tyowaa xuee na jaa nnꞌaⁿ judíos cwilaꞌtꞌmaaⁿꞌndyo̱. ");
INSERT INTO amuNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Nnom tsjoom Jerusalén tyowaa cwii ꞌndyootsꞌa tꞌmaⁿ na jlaꞌcajndyuna ꞌNdyootsꞌa Canmaⁿ. Manndyooꞌ juunaꞌ tyowaa cwii peila tꞌmaⁿ na ñequio ñꞌoom hebreo jndyunaꞌ Betesda. Ndiocheⁿ peilaꞌñeeⁿ niom ꞌom lꞌaa na cweꞌ wanaaⁿto. ");
INSERT INTO amuNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Naquiiꞌ lꞌaaꞌñeeⁿ tyomaⁿꞌ cwii tmaaⁿꞌ nnꞌaⁿwii, ñꞌeⁿ nnꞌaⁿ na nchjaaⁿ, ñꞌeⁿ nnꞌaⁿ na tileicꞌoocaꞌ, ñequio nnꞌaⁿ na jnda̱ teintjeiⁿ luee, ncꞌeeꞌ. Tyomeindooꞌna na nleiwo̱o̱ ndaatioo na ñjom peilaꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ee tquiacheⁿ tquia mandyocue cwii ángel na matseitsja̱ ndaatiooꞌñeeⁿ. Ndoꞌ quia na jnda̱ tuii na ljoꞌ, juu tsꞌaⁿ najndyee na nncuo̱ joꞌ joꞌ, nnꞌmaⁿ meiⁿquia tycu na matjom. ");
INSERT INTO amuNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Joꞌ joꞌ tyomꞌaaⁿ cwii tsaⁿsꞌa na jnda̱ ntquiuu nchooꞌ quii nchooꞌ ñeeⁿ chu na wiiꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Ntyꞌiaaꞌ Jesús juu na waa. Ndoꞌ ncꞌe na ntyjeeⁿ na jnda̱ teijndye xuee na matjom na luaaꞌ, matsoom nnom: —¿Aa ñeꞌcanꞌmaⁿꞌ? ");
INSERT INTO amuNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ndoꞌ tꞌo̱ tsꞌaⁿ na wiiꞌ nnoom. Matso: —Ta, tjaa ꞌñeeⁿ nnchjeeñe ja quiiꞌ ndaa quia na cwitsja̱naꞌ, ee yocheⁿ na matseijndo̱, cwiicheⁿ tsꞌaⁿ jnda̱ teinomꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ndoꞌ matso Jesús nnom: —Quicantyjaꞌ, catseilcwiindyuꞌ tsueꞌ ndoꞌ cjaꞌcaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Mañoomꞌ tcoꞌyanaꞌ tsaⁿꞌñeeⁿ, nꞌmaaⁿ. Jnda̱ joꞌ seilcwiiñê tsuee ꞌnaaⁿꞌaⁿ, to̱o̱ⁿꞌo̱ⁿ na tjacaⁿ. Ndoꞌ xueeꞌñeeⁿ xuee na jaa nnꞌaⁿ judíos cwitaꞌjndya̱a̱ya. ");
INSERT INTO amuNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Cweꞌ joꞌ ntꞌom nnꞌaⁿ judíos tyoluena nnom juu tsꞌaⁿ na jnda̱ nꞌmaⁿ: —Jeꞌ xuee na cwitaꞌjndya̱a̱ya. Ljeii na matsa̱ꞌntjomnaꞌ tinquiaanaꞌ na wanaaⁿ na nncjaꞌñꞌoomꞌ tsueꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Tꞌo̱ tsaⁿꞌñeeⁿ nda̱a̱na: —Nquii tsꞌaⁿ na seinꞌmaⁿ ja matso no̱o̱ⁿ na catseilcwiindyo̱ tsuee ꞌnaⁿya ndoꞌ cjo̱ñꞌo̱ⁿya juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Taꞌxꞌee naⁿꞌñeeⁿ nnoom, jluena: —¿ꞌÑeeⁿ juu tsaⁿꞌñeeⁿ na matso njomꞌ na catseilcwiindyuꞌ tsueꞌ ndoꞌ cjaꞌcaꞌ? ");
INSERT INTO amuNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Sa̱a̱ juu tsꞌaⁿ na jnda̱ nꞌmaⁿ ticaljeiiⁿ ꞌñeeⁿ seinꞌmaⁿ jom. Ee ncꞌe jndye nnꞌaⁿ tyomꞌaⁿ joꞌ joꞌ, joꞌ chii teindyo̱o̱ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Jnda̱nquia ljeii Jesús tsaⁿꞌñeeⁿ naquiiꞌ watsꞌom tꞌmaⁿ ꞌnaaⁿ nnꞌaⁿ judíos. Matsoom nnom: —Jeꞌ queⁿꞌ cwenta, jnda̱ nꞌmaⁿꞌ, cjaꞌmeintyjeꞌ na matseiꞌtjo̱o̱ndyuꞌ nnom Tyꞌo̱o̱tsꞌom cha tintjomꞌ cwii na cwajndiiticheⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ndoꞌ tsaⁿsꞌaꞌñeeⁿ tjacatsoom nda̱a̱ nnꞌaⁿ judíos na nquii Jesús seinꞌmaⁿ jom. ");
INSERT INTO amuNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Cweꞌ ncꞌe joꞌ tyolꞌuee nnꞌaⁿ judíosꞌñeeⁿ na catꞌuiinaꞌ Jesús. Tyojooꞌ nꞌomna na nlaꞌcueeꞌna jom, ee tyochꞌeeⁿ tsꞌiaaⁿmeiⁿꞌ meiiⁿ xuee na cwitaꞌjndyeena. ");
INSERT INTO amuNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Sa̱a̱ Jesús tꞌo̱o̱ⁿ nda̱a̱na, tsoom: —Tsotya̱ya ñequiiꞌcheⁿ machꞌeeⁿ tsꞌiaaⁿ, ndoꞌ mati ja. ");
INSERT INTO amuNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Jnaaⁿꞌ ñꞌoomwaaꞌ nnꞌaⁿ judíosꞌñeeⁿ tyojooꞌti nꞌomna na nlaꞌcueeꞌna jom. Ee cantyja na cwitjeiiꞌna cwenta nchii macanda̱ na seitjo̱o̱ñê cantyja ꞌnaaⁿꞌ xuee na cwitaꞌjndyeena, sa̱a̱ mati nquiuna na seitjo̱o̱ñê na tsoom na Tyꞌo̱o̱tsꞌom cwiluiiñe Tsotyeeⁿ, ee na laaꞌtiꞌ machꞌeeⁿ na ñeꞌcwii cwiluiiñê ñꞌeⁿñe. ");
INSERT INTO amuNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Quia joꞌ matso Jesús nda̱a̱ naⁿꞌñeeⁿ: —Ñꞌoom na mayuuꞌcheⁿ matseina̱ⁿya nda̱a̱ꞌyoꞌ. Ja na cwiluiindyo̱ Jnda Tyꞌo̱o̱tsꞌom, ticalatiuuꞌyoꞌ na ñequiiꞌ cantyja na lꞌue tsꞌo̱o̱ⁿ nntsꞌaa. Ja ñequiiꞌcheⁿ cantyja na mantyꞌia na machꞌee Tsotya̱, joꞌ na matsꞌaa. Ee ja na cwiluiindyo̱ Jnaaⁿ, ñequiiꞌcheⁿ matsꞌaa chaꞌxjeⁿ na mantyꞌiaya na machꞌeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Ee Tsotya̱ya mꞌaaⁿ na candyaꞌ tsꞌoom ja na cwiluiindyo̱ Jnaaⁿ. Maꞌmo̱o̱ⁿ no̱o̱ⁿ chaꞌtso na machꞌeeⁿ. Ndoꞌ mꞌmo̱ⁿtyeeⁿcheⁿ tsꞌiaaⁿ na tꞌmaⁿti na catsꞌaa cha catsꞌaanaꞌ na cjaaweeꞌticheⁿ nꞌomꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ee chaꞌxjeⁿ nquii Tsotya̱ya mañequiaaⁿ na cwitandoꞌ lꞌoo, mati ja na cwiluiindyo̱ Jnaaⁿ meiⁿquia tsꞌaⁿ na lꞌue tsꞌo̱o̱ⁿ mañequia na tseixmaⁿ na ticantycwii na wandoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Tsotya̱ya meiⁿcwii tsꞌaⁿ ticuꞌxeeⁿ. Sa̱a̱ lꞌo̱o̱ ja na cwiluiindyo̱ Jnaaⁿ jnda̱ tquiaaⁿ chaꞌwaati na nntuꞌxeⁿndye nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ee lꞌue tsꞌoom na ñecwii xjeⁿ calaꞌtꞌmaaⁿꞌndye nnꞌaⁿ ja na cwiluiindyo̱ Jnaaⁿ, chaꞌxjeⁿ cwilaꞌtꞌmaaⁿꞌndyena jom. Sa̱a̱ meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na tiñeꞌcatseitꞌmaaⁿꞌñe ja na cwiluiindyo̱ Jnaaⁿ meiⁿ Tsotya̱ya ticatseitꞌmaaⁿꞌñe tsaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","’Ñꞌoom na mayuuꞌcheⁿ matsjo̱o̱ nda̱a̱ꞌyoꞌ. ꞌÑeeⁿ juu na mandii ñꞌoom ꞌndyo̱ ndoꞌ matseiyuꞌ ñequio nqueⁿ na jñoom ja, juu tsaⁿꞌñeeⁿ matseixmaⁿ na ticantycwii na wandoꞌ, meiⁿ ticatuꞌxeⁿñe cantyja jnaaⁿꞌ. Ñeseixmaⁿ na tsꞌoo juu sa̱a̱ jeꞌ matseixmaⁿ na ticantycwii na wandoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ñꞌoom na mayuuꞌcheⁿ matsjo̱o̱ nda̱a̱ꞌyoꞌ. Nncueꞌntyjo̱ xjeⁿ ndoꞌ jeꞌ maweꞌntyjo̱naꞌ quia na nndye nnꞌaⁿ na jnda̱ tja̱ jndye ja na cwiluiindyo̱ Jnda Tyꞌo̱o̱tsꞌom. Ndoꞌ nnꞌaⁿ na cwilaꞌyuꞌ ñꞌeⁿndyo̱ nñequia na nntaꞌndoꞌna. ");
INSERT INTO amuNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ee chaꞌxjeⁿ nquii Tsotya̱ya matseixmaaⁿ na wanoomꞌm cantyja ꞌnaaⁿꞌ nqueⁿ, malaaꞌtiꞌ jnda̱ tquiaaⁿ no̱o̱ⁿ na cwiluiindyo̱ Jnaaⁿ, na matseixmaⁿya na wando̱ꞌa cantyja ꞌnaⁿ nnco̱. ");
INSERT INTO amuNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ndoꞌ jnda̱ tquiaaⁿ najndeii na matseixmaaⁿ na ja nncuꞌxa̱ⁿ nnꞌaⁿ cantyja jnaaⁿna, ncꞌe cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Tacalꞌaꞌyoꞌ na jeeⁿ cwijaaweeꞌ nꞌomꞌyoꞌ na luaaꞌ tsjo̱o̱ ee nncueꞌntyjo̱ xjeⁿ na chaꞌtso lꞌoo na tooꞌndye ndeiꞌluaa, nndyena jndyeya. ");
INSERT INTO amuNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Joo nnꞌaⁿ na jnda̱ ñelꞌa na matyꞌiomyanaꞌ, nntandoꞌxcona na ticantycwii na cwitaꞌndoꞌna. Sa̱a̱ joo nnꞌaⁿ na tyoolaxmaⁿ na matyꞌiomyanaꞌ, nntandoꞌnndaꞌna na nntꞌuiityeⁿnaꞌ joona. ");
INSERT INTO amuNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","’Tjaa na nnda̱a̱ nntsꞌaa cantyja na matseixmaⁿ nnco̱. Chaꞌxjeⁿ na matseijndo̱ꞌ Tyꞌo̱o̱tsꞌom tsꞌo̱o̱ⁿya, joꞌ na macuꞌxa̱ⁿ. Ndoꞌ macuꞌxa̱ⁿya chaꞌxjeⁿ na matyꞌiomyanaꞌ. Ee nchii malꞌueeꞌndyo̱ na nluii yuu na lꞌue tsꞌo̱o̱ⁿ nnco̱. Malꞌueeꞌndyo̱ na nntsꞌaa yuu na lꞌue tsꞌom Tsotya̱ na jñom ja quiiꞌntaaⁿꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Xeⁿ macwjiꞌyuuꞌndyo̱ cantyja ꞌnaⁿya, ticajnda ñꞌoomꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Sa̱a̱ mꞌaaⁿ cwiicheⁿ na macwjiꞌyuuꞌñe cantyja ꞌnaⁿya, majuu Juan. Ndoꞌ ntyjiiyaya na juu ñꞌoomꞌñeeⁿ tseixmaⁿnaꞌ na mayuuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Mancjoꞌyoꞌ jñomꞌyoꞌ nnꞌaⁿ na mꞌaaⁿ ndoꞌ ñꞌoom na tjeiꞌyuuꞌñê cantyja ꞌnaⁿya, ñꞌoom na mayuuꞌ juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Sa̱a̱ ja ticantyjaaꞌ tsꞌo̱o̱ⁿ ñꞌoom na cwitjeiꞌyuuꞌndye nnꞌaⁿ cantyja ꞌnaⁿya. Luaaꞌ matsjo̱o̱ cha nnda̱a̱ nncwjiꞌnꞌmaaⁿndyo̱ ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juanꞌñeeⁿ tyoseixmaaⁿ chaꞌcwijom lámpara na matseixueenaꞌ jo nda̱a̱ nnꞌaⁿ. Ndoꞌ ꞌo xjeⁿ na ñetꞌoom tꞌomꞌyoꞌ na neiⁿꞌyoꞌ ee nquiuꞌyoꞌ ñꞌoom na tyoñequiaaⁿ chaꞌcwijom seixueeñenaꞌ naquiiꞌ nꞌomꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Sa̱a̱ waa ñꞌoom na macwjiꞌyuuꞌñenaꞌ cantyja ꞌnaⁿya na tꞌmaⁿti cwiluiiñenaꞌ, nchiiti ñꞌoom na tjeiꞌyuuꞌñe Juan. Joo tsꞌiaaⁿ na tquiaa Tsotya̱ya na catseicanda̱a̱ꞌndyo̱ na matsꞌaa, joonaꞌ cwitjeiꞌyuuꞌndyenaꞌ cantyja ꞌnaⁿya na nqueⁿ jñoom ja. ");
INSERT INTO amuNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ndoꞌ nqueⁿ na jñoom ja quiiꞌntaaⁿꞌyoꞌ macwjiꞌyuuꞌñê cantyja ꞌnaⁿya naquiiꞌ ñꞌoomꞌm. ꞌO meiⁿjom ndiiꞌ tyoondyeꞌyoꞌ jñeeⁿꞌeⁿ, meiⁿ na nntyꞌiaꞌyoꞌ chiuu waaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Meiⁿ ñꞌoomꞌm ticꞌoomnaꞌ naquiiꞌ nꞌomꞌyoꞌ, ee ꞌo tiñeꞌcalaꞌyuꞌyoꞌ ñequio ja na jñoom. ");
INSERT INTO amuNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Tcuu tcuu cwilaꞌnaⁿꞌyoꞌ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na teiljeii teiyo ee cwilaꞌtiuuꞌyoꞌ cweꞌ na cwilꞌaꞌyoꞌ na ljoꞌ, joꞌ na nndaꞌyoꞌ na ticantycwii na cwitandoꞌyoꞌ jo nnoom. Ndoꞌ joonaꞌ cwitjeiꞌyuuꞌndyenaꞌ cantyja ꞌnaⁿya. ");
INSERT INTO amuNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Sa̱a̱ tiñeꞌcalaꞌjomndyoꞌ cantyja ꞌnaⁿya cha nnda̱a̱ nlaxmaⁿꞌyoꞌ na ticantycwii na cwitandoꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","’Ja ticantyjaaꞌ tsꞌo̱o̱ⁿ na nlaꞌtꞌmaaⁿꞌndye nnꞌaⁿ ja. ");
INSERT INTO amuNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ee matseiꞌno̱ⁿꞌa cantyja ꞌnaⁿꞌyoꞌ na juu na mꞌaaⁿ Tyꞌo̱o̱tsꞌom na candyaꞌ tsꞌoom nnꞌaⁿ, ticalaꞌxmaⁿꞌyoꞌ joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mꞌaaⁿya quiiꞌntaaⁿꞌyoꞌ ñequio xueeꞌ Tsotya̱ya, sa̱a̱ ꞌo ticalaꞌljoꞌyoꞌ ja. Sa̱a̱ xeⁿ cwiicheⁿ tsꞌaⁿ nncwjeeꞌ ñequio xueeꞌ nquii, maxjeⁿ nlaꞌljoꞌyoꞌ juu. ");
INSERT INTO amuNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ꞌO cwilꞌueꞌyoꞌ na nlaꞌtꞌmaaⁿꞌndye ncꞌiaꞌyoꞌ ꞌo, sa̱a̱ ticalꞌueꞌyoꞌ na ntseitꞌmaaⁿꞌñe nquii Tyꞌo̱o̱tsꞌom ꞌo. Ndoꞌ na luaaꞌ cwilꞌaꞌyoꞌ, tixocanda̱a̱ nlaꞌyuꞌyoꞌ ñꞌeⁿndyo̱. ");
INSERT INTO amuNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Sa̱a̱ ticalaꞌtiuuꞌyoꞌ na mannco̱tya̱ nntsjo̱o̱ jnaⁿꞌyoꞌ nnom Tsotya̱. Mꞌaaⁿ cwiicheⁿ na mañequiaa jnaⁿꞌyoꞌ, manquiiti Moisés, tsaⁿ na jeeⁿ cwicantyjaaꞌ nꞌomꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Xeⁿ cwilaꞌyuꞌyoꞌ ñequio Moisés, quia joꞌ mati nlaꞌyuꞌyoꞌ ñꞌeⁿndyo̱, ee seiljeiⁿ cantyja ꞌnaⁿya. ");
INSERT INTO amuNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Sa̱a̱ xeⁿ ꞌo tiñeꞌcalaꞌyuꞌyoꞌ ñꞌoom na seiljeiⁿ, quia joꞌ ¿chiuu ya nlꞌaꞌyoꞌ na nlaꞌyuꞌyoꞌ ñꞌoom na matseina̱ⁿ? ");
INSERT INTO amuNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Jnda̱ teinom na nmeiiⁿꞌ, teityꞌio̱o̱ꞌâ ndaaluee Galilea ñꞌeⁿ Jesús na mati jndyu juunaꞌ Tiberias. ");
INSERT INTO amuNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ndoꞌ cwii tmaaⁿꞌ nnꞌaⁿ na jndyendye tyꞌentyjo̱na naxeeⁿꞌeⁿ ee jnda̱ ntyꞌiaanda̱a̱na tsꞌiaaⁿ tꞌmaⁿ na tyochꞌeeⁿ na tyotseinꞌmaaⁿ nnꞌaⁿwii. ");
INSERT INTO amuNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Quia joꞌ jâ nnꞌaⁿ na tꞌmaaⁿ na calaꞌjomndyô̱ tsꞌiaaⁿ na machꞌeeⁿ, saawaayâ cwii sjo̱ ñꞌeⁿñê. Joꞌ joꞌ saawindyuaandyô̱. ");
INSERT INTO amuNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ndoꞌ quia ljoꞌ manndyooꞌ nncueeꞌ xuee pascua na jaa nnꞌaⁿ judíos cwilacwja̱a̱ya canmaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Ndoꞌ Jesús jleityꞌiom nnoom, mantyꞌiaaⁿꞌaⁿ jnda̱ manquioquie cwii tmaaⁿꞌ nnꞌaⁿ na jndyendye. Quia joꞌ matsoom nnom Felipe: —¿Yuu nlaꞌjndaaya nantquie cha nnda̱a̱ nlcwaꞌ chaꞌtsondye naⁿmꞌaⁿꞌ? ");
INSERT INTO amuNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Luaaꞌ matsoom cha nleitquiooꞌ chiuu mꞌaaⁿꞌ tsꞌom Felipe. Ee nqueⁿ mantyjiicheeⁿ ljoꞌ nntsꞌaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Tꞌo̱ Felipe nnoom, matso: —Meiⁿ xeⁿ we siaⁿnto sꞌom denarios na nlacatsuuya na nlaꞌjndaaya ntyooꞌ, sa̱a̱ maxjeⁿ xocwijndeii juunaꞌ na nlcwaꞌ cwii cwii joona meiiⁿ ñeꞌchjoowiꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Cwii ncjo̱o̱ndyô̱ nnꞌaⁿ na cwindya̱a̱yâ ñꞌoom na mañequiaaⁿ, tsaⁿ na jndyu Andrés, tyjee Simón Pedro, matso nnom Jesús: ");
INSERT INTO amuNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Ñjaaⁿ mꞌaaⁿ cwii tyochjoo na maleiñꞌoom ꞌom taⁿꞌ tyooꞌ na tuiinaꞌ ñequio jnda̱a̱tyooꞌ lqueeⁿ cebada ñꞌeⁿ we catscaa chjoo na jnda̱ jneiiⁿ sa̱a̱ ¿cwaaⁿ nnda̱a̱ꞌ nmeiⁿꞌ na jndyendye nnꞌaⁿ? ");
INSERT INTO amuNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Tꞌo̱ Jesús, matsoom nda̱a̱yâ: —Canduꞌyoꞌ nda̱a̱ nnꞌaⁿ na cwindyuaandyena. Ndoꞌ joꞌ joꞌ jndye jnda̱ nchꞌu niom. Quia joꞌ teindyuaandye nnꞌaⁿ, ndoꞌ tueeꞌ chaꞌna ꞌom meiⁿndye naⁿnom. ");
INSERT INTO amuNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Quia joꞌ toꞌñom Jesús ntyooꞌñeeⁿ. Tquiaaⁿ na quianlꞌuaaꞌ Tsotyeeⁿ cantyja ꞌnaaⁿ joonaꞌ. Jnda̱ joꞌ tyocꞌoom joonaꞌ nda̱a̱ jâ nnꞌaⁿ na tꞌmaaⁿ na calaꞌjomndyô̱ ñꞌeⁿñê. Ndoꞌ jâ tꞌo̱o̱ⁿyâ joonaꞌ nda̱a̱ nnꞌaⁿ na meindyuaandye. Ndoꞌ malaaꞌtiꞌ sꞌaaⁿ ñequio calcaa nchꞌu, cwanti na ñeꞌcatquiina na cwii cwiindyena. ");
INSERT INTO amuNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Jnda̱ na tjacjoona, quia joꞌ nda̱a̱ jâ na cwilaꞌjomndyô̱ ñꞌeⁿñê tsoom: —Calaꞌtjomꞌyoꞌ ntaⁿꞌ cajnda̱a̱ na ꞌndiinaꞌ cha tintsꞌaanaꞌ na cweꞌ nleiꞌndaaꞌnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ndoꞌ jlatjo̱o̱ⁿyâ ntaⁿꞌ ntyooꞌ na ꞌndiinaꞌ na tcwaꞌ naⁿꞌñeeⁿ na tuiinaꞌ ñꞌeⁿ jnda̱a̱tyooꞌ cebada. Jlaꞌcato̱o̱ꞌâ canchooꞌwe tsquiee ñꞌeⁿ joonaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ndoꞌ naⁿꞌñeeⁿ, jnda̱ na ntyꞌiaana tsꞌiaaⁿꞌñeeⁿ na sꞌaaⁿ na maꞌmo̱ⁿnaꞌ na waa najndeii na cwiluiiñê, tyoluena: —Mayuuꞌcheⁿ tsaⁿsꞌamꞌaaⁿꞌ cwiluiiñê nquii profeta na mawaa ljeii na matsonaꞌ na nncwjeꞌcañoom tsjoomnancue na nñequiaa ñꞌoomꞌ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ndoꞌ seiꞌno̱ⁿꞌ Jesús na mawaa xjeⁿ na nnquiocꞌom naⁿꞌñeeⁿ jom ndoꞌ ñequio najndeiꞌnaꞌ na nlqueⁿna jom na nluiiñê rey. Cweꞌ joꞌ cwiicheⁿ cwii ndiiꞌ tjannaaⁿꞌaⁿ na ñenqueⁿ jo sjo̱. ");
INSERT INTO amuNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ndoꞌ quia na tueeꞌ na jnda̱ tmaaⁿ, jâ nnꞌaⁿ na tꞌmaⁿ Jesús na calaꞌjomndyô̱ ñꞌeⁿñê, saacua̱a̱yâ, squia̱a̱yâ ꞌndyoo ndaaluee. ");
INSERT INTO amuNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Joꞌ joꞌ tuo̱o̱yâ cwii wꞌaandaa, na nncwityꞌio̱o̱ꞌâ ndaaluee na nntsquia̱a̱yâ Capernaum. Ndoꞌ quia tueeꞌ na teijaaⁿ, ticandoꞌ na nncwjeꞌcañoom jâ. ");
INSERT INTO amuNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ndoꞌ ncꞌe na jndeii tioo jndye tyotseiwenaꞌ ndaalueeꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Joꞌ chii ñeꞌom oo yom kilómetros jnda̱ tjacaa wꞌaandaaꞌñeeⁿ na cwicantyjaandyô̱ nꞌoom palaꞌ. Xjeⁿꞌñeeⁿ ntyꞌiaayâ na mandyocaa Jesús nnom ndaaluee na matseicandyooꞌñê na mꞌaaⁿyâ. Jeeⁿ ndyaꞌ jlaꞌcatyuendyô̱. ");
INSERT INTO amuNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Tsoom nda̱a̱yâ: —Mannco̱ luaañe, tilacatyuendyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Jeeⁿ ndyaꞌ neiiⁿyâ sꞌaanaꞌ na toꞌño̱o̱ⁿyâ jom tsꞌom wꞌaandaa. Ndoꞌ mantyjacheⁿ tueꞌcañoom juunaꞌ yuu na cwitsaayâ. ");
INSERT INTO amuNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ndoꞌ teincoo cwiicheⁿ xuee, nnꞌaⁿ na jndyendye na ljooꞌndye xndyaaꞌ ndaaluee yuu na tquiaa Jesús na tcwaꞌna, tyoqueⁿna cwenta na ñeꞌcwii wꞌaandaa chjoo ñetuaa. Tjañjoomꞌ nꞌomna na tîcuo̱o̱ⁿ juunaꞌ ñequiondyô̱ jâ nnꞌaⁿ na cwilaꞌjomndyô̱ tsꞌiaaⁿ na machꞌeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Sa̱a̱ ntꞌomcheⁿ lꞌaandaa nchꞌu na jnaⁿ Tiberias, tquieꞌcañomnaꞌ yuu na tcwaꞌ naⁿꞌñeeⁿ ntyooꞌñeeⁿ na jnda̱ tquiaa Ta Jesús na quianlꞌuaaꞌ Tsotyeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Quia joꞌ tuo̱ naⁿꞌñeeⁿ lꞌaandaa nchꞌuꞌñeeⁿ. Tyꞌena tquiena Capernaum na tyꞌecalꞌueena Jesús. Ee jlaꞌno̱ⁿꞌna na tacꞌoomñê yuu na tquiaaⁿ na tcwaꞌna, meiⁿ jâ nnꞌaⁿ na tꞌmaaⁿ na calaꞌjomndyô̱ ñꞌeⁿñê tsꞌiaaⁿ na machꞌeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ndoꞌ quia na jnda̱ jliuna Jesús cwiicheⁿ xndyaaꞌ ndaaluee, tyoluena nnoom: —Maestro, ¿ljoꞌ xjeⁿ jndyoꞌ luaa? ");
INSERT INTO amuNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Tꞌo̱o̱ⁿ nda̱a̱na, matsoom: —Ñꞌoom na mayuuꞌcheⁿ na matsjo̱o̱ nda̱a̱ꞌyoꞌ. ꞌO cwilꞌueꞌyaꞌyoꞌ ja nchii ncꞌe na ntyꞌiaꞌyoꞌ tsꞌiaaⁿ na sꞌaa na tixocanda̱a̱ ntsꞌaa cweꞌ meiⁿquia tsꞌaⁿ sa̱a̱ cweꞌ ncꞌe na tcwaꞌyoꞌ tyooꞌ na tquiaanaꞌ na tjacjoꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ꞌO cwijooꞌ nꞌomꞌyoꞌ na nleijndaaꞌ nantquie, ndoꞌ joonaꞌ ꞌnaⁿ na cwileiꞌndaaꞌ. Sa̱a̱ ticatyꞌiomnaꞌ na cwilꞌaꞌyoꞌ na ljoꞌ. Calajnda̱ꞌyoꞌ na nliuꞌyoꞌ cwii na chaꞌcwijom nantquie na cantyja ꞌnaaⁿꞌ juu joꞌ nlaꞌxmaⁿꞌyoꞌ na ticantycwii na cwitandoꞌyoꞌ. Ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee nñequia juu na matseijomnaꞌ nantquie naquiiꞌ nꞌomꞌyoꞌ ee Tsotya̱ya Tyꞌo̱o̱tsꞌom maꞌmo̱o̱ⁿ na jnda̱ tqueeⁿ ja tsꞌiaaⁿmeiiⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Quia joꞌ ntꞌomndyena jluena nnoom: —¿Ljoꞌ macaⁿnaꞌ na calꞌaayâ cha na nncjaaweeꞌ ntyjii Tyꞌo̱o̱tsꞌom jâ? ");
INSERT INTO amuNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Tꞌo̱ Jesús nda̱a̱na, matsoom: —Luaa waa na lꞌue tsꞌoom ñꞌeⁿndyoꞌ na calaꞌyuꞌyoꞌ ñequio ja na jñoom. ");
INSERT INTO amuNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Joꞌ chii tꞌo̱o̱na nnoom: —¿Cwaaⁿ cwii nnom na nntsaꞌ nntyꞌiaayâ na tixocaluii na cweꞌ tsꞌaⁿ nntsꞌaa cha mꞌmo̱ⁿnaꞌ nda̱a̱yâ na waa na cwiluiindyuꞌ ndoꞌ cha na nlaꞌyuuꞌâ ñꞌeⁿndyuꞌ? ");
INSERT INTO amuNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Nquiee weloo welooya tyocwaꞌna maná quia tyomꞌaⁿna ndyuaa yuu na tjaa nnꞌaⁿ cꞌom, chaꞌxjeⁿ na matso ljeii ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na teiyo teiljeii: “Tquiaa Tyꞌo̱o̱tsꞌom tyooꞌ na jnaⁿ cañoomꞌluee na tcwaꞌna.” ");
INSERT INTO amuNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Tꞌo̱ Jesús nda̱a̱na, matsoom: —Ñꞌoom na mayuuꞌcheⁿ matsjo̱o̱ nda̱a̱ꞌyoꞌ. Juu maná na tquiaa Moisés nchii cwiluiiñenaꞌ tyooꞌ na jnaⁿ na mꞌaaⁿ Tyꞌo̱o̱tsꞌom. Sa̱a̱ nquii Tsotya̱ya mañequiaaⁿ juu na mayuuꞌ na jnaⁿ na mꞌaaⁿ cañoomꞌluee na matseijomnaꞌ juu chaꞌna tyooꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Juu na cwiluiiñe tyooꞌ na mañequiaa Tyꞌo̱o̱tsꞌom, cañoomꞌluee jnaⁿ jndyocue. Juu mañequiaa na laꞌxmaⁿ nnꞌaⁿ na ticantycwii na cwitaꞌndoꞌna. ");
INSERT INTO amuNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Quia joꞌ tyoluena nnoom: —Jeeⁿ ꞌu Ta, ñenquiiꞌcheⁿ quiaaꞌ tyooꞌmeiⁿꞌ nda̱a̱yâ. ");
INSERT INTO amuNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ndoꞌ tꞌo̱ Jesús nda̱a̱na, matsoom: —Ja cwiluiindyo̱ tyooꞌ na mañequiaya na laꞌxmaⁿ nnꞌaⁿ na ticantycwii na cwitaꞌndoꞌna. ꞌÑeeⁿ juu tsꞌaⁿ na nntioñe lꞌo̱o̱, matseijomnaꞌ juu chaꞌcwijom tsꞌaⁿ na jnda̱ tjacjooꞌ na macwaꞌ. Ndoꞌ ꞌñeeⁿ tsꞌaⁿ na matseiyuꞌ ñꞌeⁿndyo̱ nquioo na teiiⁿ naquiiꞌ tsꞌom chaꞌna quia maꞌuu tsꞌaⁿ ndaa. ");
INSERT INTO amuNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Sa̱a̱ chaꞌna ñꞌoom na jnda̱ tsjo̱o̱ya nda̱a̱ꞌyoꞌ, meiiⁿ na jnda̱ ntyꞌiaꞌnda̱a̱ꞌyoꞌ tsꞌiaaⁿ na matsꞌaa, maxjeⁿ tîcalaꞌyuꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Chaꞌtso nnꞌaⁿ na mañequiaa Tsotya̱ya lꞌo̱o̱, nntioondyena lꞌo̱o̱. Ndoꞌ ꞌñeeⁿ juu tsꞌaⁿ na nntioñe lꞌo̱o̱ya tijoom nntsꞌaa na ticoꞌño̱ⁿ juu. ");
INSERT INTO amuNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ee ja na jnaaⁿya caáoomꞌluee nchii na jndyo̱o̱ na catsꞌaa ljoꞌ na lꞌue tsꞌo̱o̱ⁿ. Sa̱a̱ jndyo̱o̱ na catsꞌaaya yuu na lꞌue tsꞌom nqueⁿ na jñoom ja. ");
INSERT INTO amuNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ndoꞌ Tsotya̱ya na jñoom ja luaa waa na lꞌue tsꞌoom na catsꞌaa, na chaꞌtsondye nnꞌaⁿ na jnda̱ tquiaaⁿ lꞌo̱o̱ya, meiⁿcwiindye joona ticatsuuñe añmaaⁿꞌ. Ndoꞌ xuee na macanda̱ nñequia na nntaꞌndoꞌxco chaꞌtsondye joona. ");
INSERT INTO amuNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ee Tsotya̱ya lꞌue tsꞌoom na chaꞌtsondye nnꞌaⁿ na cwintyꞌiaa ja na cwiluiindyo̱ Jnaaⁿ na cwilaꞌyuꞌ ñꞌeⁿndyo̱ nntoꞌñoomna na ticantycwii na cwitaꞌndoꞌna. Ndoꞌ xuee na macanda̱ ja nñequia na nntaꞌndoꞌxco joo nnꞌaⁿ na jnda̱ tja̱. ");
INSERT INTO amuNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jnda̱ na tso Jesús ñꞌoomwaaꞌ, tyolaꞌncjooꞌndye nnꞌaⁿ judíosꞌñeeⁿ ñꞌoom na tsoom: “Ja cwiluiindyo̱ tyooꞌ na jnaaⁿya cañoomꞌluee.” ");
INSERT INTO amuNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ee tyoluena: —Jesúsmꞌaaⁿꞌ ¿aa nchii jnda José jom? Cwitaꞌjnaaⁿꞌa tsotyeeⁿ, tsoñeeⁿ. ¿Chiuu na tsoom na jnaaⁿ cañoomꞌluee, jndyocueeⁿ? ");
INSERT INTO amuNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Tꞌo̱ Jesús, matsoom nda̱a̱ naⁿꞌñeeⁿ: —Talaꞌncjooꞌndyoꞌ cantyja ꞌnaaⁿꞌ ñꞌoomwaaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ee tjaaꞌnaⁿ cwii tsꞌaⁿ na nnda̱a̱ nntioñe lꞌo̱o̱ xeⁿ nchii Tsotya̱ na jñoom ja nntsꞌaaⁿ na catsꞌaa tsaⁿꞌñeeⁿ na ljoꞌ. Ndoꞌ xuee na macanda̱ ja nntsꞌaa na nncwandoꞌxco tsaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Ee profetas, waa ñꞌoom na jlaꞌljeiina na matsonaꞌ: “Mꞌmo̱ⁿ Tyꞌo̱o̱tsꞌom nda̱a̱ chaꞌtso nnꞌaⁿ.” Luaaꞌ ñeꞌcatsonaꞌ na ticwii cwii tsꞌaⁿ na jnda̱ jndii ñꞌoom na maꞌmo̱ⁿ Tyꞌo̱o̱tsꞌom ndoꞌ jnda̱ seiꞌno̱ⁿꞌ juunaꞌ, tsaⁿꞌñeeⁿ nntioñe lꞌo̱o̱ya. ");
INSERT INTO amuNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","’Ñꞌoomwaaꞌ ticaꞌmo̱ⁿnaꞌ na jnda̱ ntyꞌiaaꞌ tsꞌaⁿ Tsotya̱ya Tyꞌo̱o̱tsꞌom. Macanda̱ ja na jñoom quiiꞌntaaⁿꞌyoꞌ, ja jnda̱ ntyꞌiano̱o̱ⁿya jom. ");
INSERT INTO amuNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ñꞌoom na mayuuꞌcheⁿ matsjo̱o̱ nda̱a̱ꞌyoꞌ, ñeeⁿ juu na matseiyuꞌ ñꞌeⁿndyo̱ juu matseixmaⁿ na ticantycwii na wandoꞌ añmaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ja cwiluiindyo̱ tyooꞌ na mañequiaya na cwitaꞌndoꞌ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Weloo welooꞌyoꞌ tcwaꞌna maná jo ndyuaa yuu na tjaa nnꞌaⁿ cꞌom, ndoꞌ tja̱na. ");
INSERT INTO amuNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ja cwiluiindyo̱ tyooꞌ na jnaaⁿya cañoomꞌluee. Meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na nlcwaꞌ, tixocatsuuñe. ");
INSERT INTO amuNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ja na jnaaⁿya cañoomꞌluee cwiluiindyo̱ tyooꞌ na mañequiaya na cwitaꞌndoꞌ nnꞌaⁿ. Meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na nlcwaꞌ tyooꞌwaa mamatseixmaⁿ na ticantycwii na wandoꞌ. Ndoꞌ juu tyooꞌ na mañequiaya cha na nntaꞌndoꞌna jo nnom Tyꞌo̱o̱tsꞌom, seiiꞌa cwiluiiñe Joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ñꞌoomwaaꞌ sꞌaanaꞌ na jlaꞌncjooꞌndye nnꞌaⁿ judíosꞌñeeⁿ ñequio ncꞌiaana. Tyoluena: —Manquiuuya na xocanda̱a̱ nñequiaa tsaⁿmꞌaaⁿꞌ seiiⁿꞌeⁿ na nntquia̱a̱. ");
INSERT INTO amuNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Quia joꞌ tsoticheⁿ Jesús nda̱a̱na: —Ñꞌoom na mayuuꞌcheⁿ matsjo̱o̱ nda̱a̱ꞌyoꞌ, xeⁿ ticatquieꞌyoꞌ seiiꞌ ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee ndoꞌ na cweꞌyoꞌ nioomꞌa, ticalaꞌxmaⁿꞌyoꞌ nnꞌaⁿ na tandoꞌ añmaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nquii tsꞌaⁿ na jnda̱ tquii seiiꞌa ndoꞌ jnda̱ tꞌuu nioomꞌa tseixmaⁿ na ticantycwii na wandoꞌ. Ndoꞌ xuee na macanda̱ nntsꞌaaya na nncwandoꞌxcoom. ");
INSERT INTO amuNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ee seiiꞌa matseixmaⁿnaꞌ nantquie na tjacantyja naya ndoꞌ nioomꞌa matseixmaⁿnaꞌ juu na nncꞌuu tsꞌaⁿ na tjacantyja naya. ");
INSERT INTO amuNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na maquii seiiꞌa ndoꞌ maꞌuu nioomꞌa, tyeⁿ matseitjoomꞌnaꞌ tsaⁿꞌñeeⁿ ñꞌeⁿndyo̱, ndoꞌ tyeⁿ matseitjoomꞌnaꞌ ja ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nquii Tsotya̱ya na jñoom ja quiiꞌntaaⁿꞌyoꞌ, jom wanoomꞌm ndoꞌ cantyja ꞌnaaⁿꞌaⁿ mati wando̱ꞌa. Maluaaꞌ matseijomnaꞌ ñꞌeⁿ tsꞌaⁿ na maquii seiiꞌa, nncwandoꞌ añmaaⁿꞌ cantyja ꞌnaⁿya. ");
INSERT INTO amuNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Matseina̱ⁿya cantyja ꞌnaaⁿꞌ nquii na cwiluiiñe tyooꞌ na jnaⁿ cañoomꞌluee. Tyooꞌwaa titseixmaⁿnaꞌ chaꞌna maná na tcwaꞌ weloo weloꞌyoꞌ ndoꞌ tja̱na. Sa̱a̱ ticatseijomnaꞌ cantyja ꞌnaⁿya chaꞌna manáꞌñeeⁿ. Ee meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na nlcwaꞌ tyooꞌ na matseixmaⁿya, tijoom nncueꞌ, mꞌaaⁿ ndoꞌ mꞌaaⁿ na wandoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ñꞌoommeiⁿꞌ seineiⁿ Jesús yocheⁿ na tyoꞌmo̱o̱ⁿ nda̱a̱ nnꞌaⁿ quiiꞌ watsꞌom ꞌnaaⁿ nnꞌaⁿ judíos tsjoom Capernaum. ");
INSERT INTO amuNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Majndye nnꞌaⁿ na tyolaꞌjomndye ñꞌoom na tyoñequiaaⁿ, quia jndyena ñꞌoomwaaꞌ jluena: —Jeeⁿ jndeiꞌnaꞌ ñꞌoom na matseineiiⁿ, tixocanda̱a̱ nlajomndyo̱ juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ntyjii Jesús naquiiꞌ tsꞌoom na cwilaꞌncjooꞌndye naⁿꞌñeeⁿ cantyja ñꞌoom na seineiiⁿ nda̱a̱na. Joꞌ chii tsoom nda̱a̱na: —¿Aa cwilaꞌlcweꞌ ñꞌoommeiⁿꞌ ꞌo? ");
INSERT INTO amuNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Quia joꞌ cꞌoomꞌyaya nꞌomꞌyoꞌ chiuu nntsꞌaanaꞌ ꞌo quia nntyꞌiaꞌnda̱a̱ꞌyoꞌ ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee na nncjo̱waanndaꞌa nandye yuu na ñetꞌo̱o̱ⁿjndya̱a̱. ");
INSERT INTO amuNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Macanda̱ nquii Espíritu mañequiaaⁿ na cwitaꞌndoꞌ nnꞌaⁿ jo nnom Tyꞌo̱o̱tsꞌom. Nchii cantyja ꞌnaaⁿ seiina na laꞌxmaⁿna na ljoꞌ. Ñꞌoom na mañequiaya cwiluiiñenaꞌ cantyja ꞌnaaⁿꞌ Espíritu ndoꞌ ncꞌe juunaꞌ joꞌ na wandoꞌ tsꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Sa̱a̱ ndicwaⁿ ñꞌeeⁿꞌndyoꞌ na ticalayuꞌyoꞌ ñꞌeⁿndyo̱. Luaaꞌ matsoom nda̱a̱na ee cantyjati na to̱o̱ⁿꞌo̱ⁿ na mañequiaaⁿ ñꞌoom, mantyjeeⁿ ꞌñeeⁿ joo na ticalaꞌyuꞌ ñꞌeⁿñê, ndoꞌ ꞌñeeⁿ juu na nñequiaa cwenta jom. ");
INSERT INTO amuNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Matsotyeeⁿcheⁿ: —Cweꞌ ncꞌe joꞌ na jnda̱ tsjo̱o̱ nda̱a̱ꞌyoꞌ macanda̱ nnda̱a̱ ntseijomñe tsꞌaⁿ ñꞌeⁿndyo̱ quia mañequiaa Tsotya̱ya na caluii na ljoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ndoꞌ ncꞌe ñꞌoomwaaꞌ, majndye nnꞌaⁿ na tyondyejndyeena ñꞌoom na tyoñequiaaⁿ, tyꞌelcweeꞌna. Taticalaꞌjomndyetina ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Joꞌ na taxꞌeeñê nda̱a̱ jâ nnꞌaⁿ na canchooꞌwe na tꞌmaaⁿ na calaꞌjomndyô̱ ñꞌeⁿñê, matsoom: —Ndoꞌ ꞌo jeꞌ ¿aa mati nnto̱ⁿꞌndyoꞌ ñꞌeⁿndyo̱? ");
INSERT INTO amuNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simón Pedro tꞌo̱o̱ⁿ, matsoom: —Jeeⁿ ꞌu Ta, ticatsonaꞌ na nlaꞌjomndyô̱ ñꞌeⁿ cwiicheⁿ tsꞌaⁿ, ee ñꞌoom na matseineiⁿꞌ mañequiaanaꞌ na ticantycwii na cwitando̱o̱ꞌâ. ");
INSERT INTO amuNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ndoꞌ jâ jnda̱ macwilaꞌyuuꞌâ ndoꞌ jnda̱ macwilaꞌno̱o̱ⁿꞌâ na ꞌu cwiluiindyuꞌ Cristo, Jnda Tyꞌo̱o̱tsꞌom na wandoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Tꞌo̱ Jesús, matsoom nda̱a̱yâ: —Ja tjeiiꞌa ꞌo na canchooꞌwendyoꞌ. Ndoꞌ cwii ꞌo mꞌaaⁿñe cantyja ꞌnaaⁿꞌ tsaⁿjndii. ");
INSERT INTO amuNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Luaaꞌ matsoom na maꞌmo̱o̱ⁿ Judas Iscariote, jnda Simón. Ee tsaⁿꞌñeeⁿ nñequiaa cwenta jom. Mati juu cwii jâ na canchooꞌwendyô̱. ");
INSERT INTO amuNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Jnda̱ tuii na nmeiiⁿꞌ tyomaꞌno̱o̱ⁿyâ tsꞌo̱ndaa Galilea ñꞌeⁿ Jesús. Ee jnaaⁿꞌ na tyoqueⁿndye nnꞌaⁿ na cwiluiitquiendye nda̱a̱ nnꞌaⁿ judíos na ñeꞌcalaꞌcueeꞌna jom, joꞌ chii tiñeꞌcjaⁿ Judea. ");
INSERT INTO amuNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ndoꞌ jaawindyooꞌ na nncueeꞌ ncuee na cwilaꞌtꞌmaaⁿꞌndye nnꞌaⁿ judíos quia na quilꞌana xeⁿnquieꞌ ncwaⁿꞌ na cwijaañjoomꞌ nꞌomna chiuu ñetꞌom weloo weloona ndyuꞌñeeⁿcheⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ndoꞌ na manncueeꞌ xueeꞌñeeⁿ tyolue ntyjeeⁿ nnoom: —Cwa sa, caluiꞌ ñjaaⁿñe. Cjaꞌ Judea cha nnꞌaⁿ na mꞌaⁿ laꞌñeⁿ na cwilaꞌjomndye ñꞌoom na mañequiaaꞌ mati nntyꞌiaana tsꞌiaaⁿ na macheꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ee tsꞌaⁿ na matseicantyjaaꞌ tsꞌom na calaꞌyuꞌ nnꞌaⁿ ñꞌeⁿñe, ticatsonaꞌ na nljooꞌñe jo jnda̱a̱. Quiaandyuꞌ na caliu chaꞌtso nnꞌaⁿ tsꞌiaaⁿ na macheꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Nmeiiⁿꞌ jluena nnoom ee meiⁿ joona tîcalaꞌyuꞌna ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Quia joꞌ matsoom nda̱a̱na: —Tyooweꞌntyjo̱ xjeⁿ na caꞌmo̱o̱ⁿya nda̱a̱ nnꞌaⁿ na cwiluiitquiendye na cwiluiindyo̱ nquii na macwjiꞌnꞌmaaⁿñe nnꞌaⁿ. Sa̱a̱ ꞌo meiⁿquia xjeⁿ na ñeꞌconomꞌyoꞌ, tjaaꞌnaⁿ na teincuuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Joo nnꞌaⁿ tsjoomnancue tijndoona ꞌo. Sa̱a̱ cantyja ꞌnaⁿ ja luaañe, ñequiiꞌcheⁿ mꞌaⁿna na jndoona ja, cweꞌ ncꞌe na macwjiꞌyuuꞌndyo̱ cantyja ꞌnaaⁿ natia na cwilꞌana. ");
INSERT INTO amuNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Tsaꞌyoꞌ na ñencjoꞌyoꞌ xueewaaꞌ, ja tjo̱o̱cheⁿ na nncjo̱ xuee. Ee tjo̱o̱cheⁿ na nntseicaꞌmo̱ⁿndyo̱ na cwiluiindyo̱ nquii na macwjiꞌnꞌmaaⁿñe nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Ndoꞌ jnda̱ na tsoom na luaaꞌ nda̱a̱na, ljooꞌñetyeeⁿ we ndyee xuee Galilea. ");
INSERT INTO amuNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ndoꞌ jnda̱ na tyꞌe ntyjeeⁿ na tueeꞌ xuee, quia joꞌ mati jom tjantyjo̱o̱ⁿ, sa̱a̱ tîtseicaꞌmo̱ⁿñê nda̱a̱ nnꞌaⁿ. Tjaaⁿ chaꞌcwijom tsꞌaⁿ na ticalꞌue tsꞌom na caliu nnꞌaⁿ na mꞌaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ndoꞌ nnꞌaⁿ judíos na ticueeꞌ nꞌomna jom jeeⁿ tyolꞌueena jom quiiꞌntaaⁿ nnꞌaⁿ na tquio ncuee. Tyotaꞌxꞌeena, tyoluena: —¿Yuu mꞌaaⁿ tsaⁿꞌñeeⁿ? ");
INSERT INTO amuNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ndoꞌ tꞌmaⁿ waa na ticatjoomꞌ na jlaꞌneiⁿ nnꞌaⁿ na jndyendye cantyja ꞌnaaⁿꞌaⁿ. Ee cwantindye joona tyolue: “Ya tsꞌaⁿñe tsaⁿmꞌaaⁿꞌ.” Sa̱a̱ ntꞌomcheⁿ tyolue: “Tiyuuꞌ, ee manquiuꞌnnꞌaaⁿ nnꞌaⁿ.” ");
INSERT INTO amuNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Sa̱a̱ cweꞌ ncꞌe na nquiaana nnꞌaⁿ judíos na cwiluiitquiendye nda̱a̱na, joꞌ na tîcalaꞌneiⁿndyeyuna cantyja ꞌnaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Jnda̱ na tueeꞌ xcwe ncuee, tjaqueⁿꞌeⁿ naquiiꞌ watsꞌom tꞌmaⁿ ndoꞌ joꞌ joꞌ tyoꞌmo̱o̱ⁿ nda̱a̱ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Sa̱a̱ tileicalaꞌno̱ⁿꞌ nnꞌaⁿ judíos na cwiluiitquiendye. Tyoluena: —Nchaaꞌ lꞌuu na tja tsaⁿmꞌaaⁿꞌ scwela. Quia joꞌ ¿chiuu na jeeⁿ ya matseitjoomꞌm ñꞌoom? ");
INSERT INTO amuNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Tꞌo̱ Jesús nda̱a̱na, matsoom: —Nchii nnco̱ matseijndaaꞌndyo̱ ñꞌoom na maꞌmo̱o̱ⁿya. Nqueⁿ na jñoom ja seijndaaꞌñê chiuu catsjo̱o̱ya. ");
INSERT INTO amuNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na ñeꞌcatsꞌaa cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom, juu nntseiꞌno̱ⁿꞌ aa Tyꞌo̱o̱tsꞌom seijndaaꞌñe ñꞌoom na maꞌmo̱o̱ⁿya, oo aa cweꞌ ñꞌoom na seitiuu nnco̱ na mañequiaya. ");
INSERT INTO amuNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na macwjiꞌ ñꞌoom cantyja ꞌnaaⁿꞌ nquii, matseijndeii tsaⁿꞌñeeⁿ na caluiitꞌmaⁿñê nda̱a̱ ncꞌiaaⁿꞌaⁿ. Sa̱a̱ tsꞌaⁿ na matseijndeii na catseitꞌmaaⁿꞌñenaꞌ nquii na jñom jom, tsaⁿꞌñeeⁿ cwiluiiñê na mayomꞌm. Tiquinquiuꞌnnꞌaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","’Moisés seiljeiⁿ ñꞌoom na tqueⁿ Tyꞌo̱o̱tsꞌom nda̱a̱ꞌyoꞌ na matsa̱ꞌntjomnaꞌ. Sa̱a̱ meiiⁿ na ljoꞌ, meiⁿcwiindyoꞌ ꞌo tyoolaꞌcanda̱a̱ꞌndyoꞌ juunaꞌ. Ee xeⁿ cwilaꞌcanda̱ꞌyoꞌ juunaꞌ xoqueⁿndyoꞌ na nlacueꞌyoꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Nnꞌaⁿ na jndyendye tꞌo̱o̱na nnoom, jluena: —ꞌU tsaⁿjndii matseixmaⁿꞌ. ¿ꞌÑeeⁿ tsꞌaⁿ maqueⁿñe na nntseicueeꞌ ꞌu? ");
INSERT INTO amuNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Tꞌo̱ Jesús nda̱a̱na, matsoom: —Xuee na cwitaꞌjndya̱a̱ya seinꞌmaⁿya tsꞌaⁿ na leicjacaa, ndoꞌ sꞌaanaꞌ na tjoomꞌ ticalaꞌno̱ⁿꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Sa̱a̱ calaꞌno̱ⁿꞌyoꞌ ñꞌoom na nntsjo̱o̱. Tso Moisés na calꞌaꞌyoꞌ costumbre yonom ndaꞌyoꞌ na ꞌndaandye. Ndoꞌ cwilaꞌcanda̱a̱ꞌndyoꞌ ñꞌoomꞌñeeⁿ meiiⁿ xuee na cwitaꞌjndya̱a̱ya. Sa̱a̱ nchii jom seicato̱o̱ⁿꞌo̱ⁿ costumbreꞌñeeⁿ. Nquiee weloo welooya jlaꞌcato̱o̱ꞌna juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nquiuꞌyoꞌ na mañequiaa ljeii na tqueeⁿ na wanaaⁿ na cwilꞌaꞌyoꞌ costumbreꞌñeeⁿ meiⁿ xuee na cwitaꞌjndya̱a̱ya. Ndoꞌ na luaaꞌ waa, chiuu na cwilaꞌwjeeꞌyoꞌ ja ncꞌe na juu xuee na cwitaꞌjndya̱a̱ya seinꞌmaⁿya cwii tsꞌaⁿ na wiiꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Joꞌ chii tintjeiꞌyoꞌ cwenta na cweꞌ tomti cantyja na cwiwitquiooꞌ. Catjeiꞌyoꞌ cwenta cantyja na matyꞌiomyanaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Quia joꞌ ntꞌom nnꞌaⁿ Jerusalén tyotaꞌxꞌeena nda̱a̱ ncꞌiaana: —¿Aa nchii tsaⁿsꞌamꞌaaⁿꞌ tsꞌaⁿ na cwilꞌuee naⁿmaⁿnꞌiaaⁿ na nlaꞌcueeꞌna? ");
INSERT INTO amuNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Sa̱a̱ cantyꞌiaꞌyoꞌ ñequio na jndooꞌ jndye nnꞌaⁿ matseineiiⁿ, meiⁿ tjaa ljoꞌ coluena nnoom. ¿Aa nntsꞌaacheⁿnaꞌ na cwilaꞌtiuu naⁿmaⁿnꞌiaaⁿ cwentaaya na tsaⁿmꞌaaⁿꞌ mayuuꞌcheⁿ cwiluiiñê Cristo? ");
INSERT INTO amuNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Sa̱a̱ nqueⁿ quia nncwjeeⁿꞌeⁿ tjaa ꞌñeeⁿ juu nntseiꞌno̱ⁿꞌ yuu jnaⁿyom. Sa̱a̱ tsaⁿmꞌaaⁿꞌ manquiuuyaaya yuu jnaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jnda̱ jndii Jesús na jluena ñꞌoomwaaꞌ, seiweeⁿ jñeeⁿꞌeⁿ. Matsoom: —Machꞌeenaꞌ na cwitaꞌjnaⁿꞌyoꞌ ja ndoꞌ manquiuꞌyaꞌyoꞌ yuu tsꞌaⁿ ja. Sa̱a̱ nchii na jndyo̱o̱ cantyja ꞌnaⁿ nnco̱. Nqueⁿ na jñoom ja quiiꞌntaaⁿꞌyoꞌ cwiluiiñê na mayomꞌm, sa̱a̱ jom ticataꞌnaⁿꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Sa̱a̱ ja mawajnaⁿꞌa jom, ee jnaaⁿya jo nnoom, ndoꞌ manquiityeeⁿ jñoom ja quiiꞌntaaⁿꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Cweꞌ ncꞌe na tsoom ñꞌoomwaaꞌ, tyoqueⁿndye naⁿmaⁿnꞌiaaⁿ na nntꞌuena jom. Sa̱a̱ ncꞌe na tyooweꞌntyjo̱ na ntyjii Tyꞌo̱o̱tsꞌom na nncwinoom nawiꞌ tꞌmaⁿ, joꞌ chii meiⁿcwiindyena tîcatꞌuii jom. ");
INSERT INTO amuNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ndoꞌ jndyendye nnꞌaⁿ na tyomꞌaⁿna joꞌ joꞌ, jlaꞌyuꞌna ñꞌeⁿñê. Ndoꞌ tyoluena nda̱a̱ ncꞌiaana: —Quia nncwjeeꞌ nquii Cristo, ¿aa nntsꞌaacheⁿnaꞌ jndyeti tsꞌiaaⁿ nntsꞌaaⁿ na tixocanda̱a̱ na nluii na cweꞌ tsꞌaⁿ nntsꞌaa nchiiti na machꞌee tsaⁿmꞌaaⁿꞌ? ");
INSERT INTO amuNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Nnꞌaⁿ tmaaⁿꞌ fariseos tyondyena na nmeiiⁿꞌ ñꞌoom tyolaꞌneiⁿ nnꞌaⁿ na jndyendye cantyja ꞌnaaⁿꞌ Jesús. Joꞌ chii jlaꞌjomndyena ñequio ntyee na cwiluiitquiendye nda̱a̱ ncꞌiaana nnꞌaⁿ judíos. Jñoomna nnꞌaⁿ na cwilꞌa cwenta watsꞌom na cꞌoocatꞌue naⁿꞌñeeⁿ jom. ");
INSERT INTO amuNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Matso Jesús nda̱a̱ nnꞌaⁿ na jndyendye: —Chjootindyo cwii mꞌaaⁿtya̱ ñꞌeⁿndyoꞌ. Ndoꞌ nda̱nquia nncjo̱lcwa̱ꞌnndaꞌa na mꞌaaⁿ nqueⁿ na jñoom ja na mꞌaⁿꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Quia ljoꞌcheⁿ nlꞌueꞌyoꞌ ja sa̱a̱ taxocaliuꞌyoꞌ ja. Ndoꞌ yuu na nncꞌo̱o̱ⁿya, ꞌo xocanda̱a̱ nntsquieꞌcañomꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Quia joꞌ ntꞌom nnꞌaaⁿya nnꞌaⁿ judíos tyoluena nda̱a̱ ncꞌiaana: —¿Yuu nncjaayuu tsaⁿmꞌaaⁿꞌ na xocanda̱a̱ nliuuya jom? ¿Aa nncꞌoomñê quiiꞌntaaⁿ ncꞌiaaya nnꞌaⁿ judíos na jnda̱ tꞌoomꞌndye quiiꞌntaaⁿ nnꞌaⁿ griegos, cha nnda̱a̱ mꞌmo̱o̱ⁿ nda̱a̱na? ");
INSERT INTO amuNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Ljoꞌ ñeꞌcatso ñꞌoom na matseineiiⁿ luaaꞌ na nlꞌua̱a̱ya jom sa̱a̱ xocaliuuya jom? Ndoꞌ na matsoom yuu na wjaⁿ jaa xocanda̱a̱ nntsquia̱caño̱o̱ⁿya jom. ");
INSERT INTO amuNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Xuee na cwintycwii ncuee cwilꞌana na tꞌmaⁿti xuee juunaꞌ na cwilaꞌtꞌmaaⁿꞌndyena. Juu xueeꞌñeeⁿ tjameintyjeeꞌ Jesús, seiweeⁿ jñeeⁿꞌeⁿ. Tsoom: —ꞌÑeeⁿ juu na matseiqueeⁿnaꞌ tsꞌom na ñecꞌoomñe nacje ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom, candyontyjo̱ naxa̱ⁿꞌa, ndoꞌ catseiyuꞌ ñꞌeⁿndyo̱. ");
INSERT INTO amuNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nntsꞌaanaꞌ ñꞌeⁿ tsaⁿꞌñeeⁿ chaꞌxjeⁿ matso ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na jnda̱ teiljeii. Juu tsꞌaⁿ na matseiyuꞌ ñꞌeⁿndyo̱, nnaaⁿꞌ quiiꞌ tsꞌoom chaꞌcwijom candaa na cwiñeꞌquia na ticantycwii na wandoꞌ tsꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Luaaꞌ matsoom na maꞌmo̱o̱ⁿ cantyja ꞌnaaⁿꞌ Espíritu Santo na juu nntoꞌñoom nnꞌaⁿ na cwilaꞌyuꞌ ñꞌeⁿñê. Ee xjeⁿꞌñeeⁿ tjo̱o̱cheⁿ na nñequiaa Tyꞌo̱o̱tsꞌom juu naquiiꞌ nꞌom nnꞌaⁿ, ee tyooweꞌntyjo̱ xjeⁿ na nntseitꞌmaaⁿꞌñê Jesús. ");
INSERT INTO amuNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Ndoꞌ quiiꞌntaaⁿ nnꞌaⁿ na jndyendye quia tyondyena ñꞌoommeiⁿꞌ, tyoluena: —Mayuuꞌcheⁿ tsaⁿsꞌamꞌaaⁿꞌ cwiluiiñê nquii tsꞌaⁿ na waa ñꞌoom na nncwjeꞌcañoom tsjoomnancue na nñequiaa ñꞌoomꞌ Tyꞌo̱o̱tsꞌom nda̱a̱ya. ");
INSERT INTO amuNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ndoꞌ jlue ntꞌomcheⁿ: —Tsaⁿmꞌaaⁿꞌ cwiluiiñê Cristo. Ndoꞌ ntꞌom jlue: —Chiuu sa ꞌo, juu Cristo ticatsonaꞌ na nnaaⁿ Galilea. ");
INSERT INTO amuNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ee ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na teiljeii matsonaꞌ na juu Cristo cwiluiiñê tsjaaⁿ David na jndyowicantyjooꞌ. Ndoꞌ mati jom tsꞌaⁿ tsjoom chjoo Belén yuu na jnaⁿ David. ");
INSERT INTO amuNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ñꞌoomwaaꞌ to̱ⁿꞌnaꞌ nnꞌaⁿ cantyja ꞌnaaⁿꞌ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ee cwantindye joona ñeꞌcatꞌuena jom, sa̱a̱ meiⁿcwii tsꞌaⁿ tîcatꞌuii jom. ");
INSERT INTO amuNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Quia joꞌ nquiee nnꞌaⁿ na cwilꞌa cwenta watsꞌom tyꞌelcweeꞌna na mꞌaⁿ ntyee na cwiluiitquiendye ñequio nnꞌaⁿ tmaaⁿꞌ fariseos. Taxꞌee naⁿꞌñeeⁿ nda̱a̱ nnꞌa na cwilꞌa cwenta watsꞌom: —¿Chiuu na tînquioꞌñꞌomꞌyoꞌ jom? ");
INSERT INTO amuNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Tꞌo̱o̱ naⁿꞌñeeⁿ na cwilꞌa cwenta watsꞌom, jluena: —Meiⁿjom ndiiꞌ tyoondya̱a̱yâ na nntseineiⁿ cwii tsꞌaⁿ chaꞌna na matseineiⁿ tsaⁿmꞌaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Quia joꞌ fariseosꞌñeeⁿ tꞌo̱o̱na nda̱a̱ naⁿꞌñeeⁿ, jluena: —¿Aa chaꞌ mati ꞌo manquiuꞌnnꞌaⁿnaꞌ? ");
INSERT INTO amuNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Tjaaꞌnaⁿ cwii tsꞌaⁿ na matseixmaⁿ nꞌiaaⁿ oo cwii fariseo na matseiyuꞌ ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Sa̱a̱ naⁿmꞌaⁿꞌ na cje cwilꞌa, ticalaꞌno̱ⁿꞌna ljeii na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. Joona laꞌxmaⁿna na catsuundyena. ");
INSERT INTO amuNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Tꞌo̱ Nicodemo, tsaⁿ na tyjeꞌcañoom na mꞌaaⁿ Jesús cwii teijaaⁿ. Jom macañꞌeeⁿ ñꞌeⁿ naⁿmaⁿnꞌiaaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","Tsoom: —Ñꞌoom na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom na teiljeiinaꞌ na cwileiñꞌo̱o̱ⁿya, manquiuuya na matsonaꞌ na ticatyꞌiomyanaꞌ na nntuꞌxa̱a̱ⁿya cwii tsꞌaⁿ cwii tjo̱o̱cheⁿ na nndya̱a̱ya jnaaⁿꞌ, ndoꞌ na nliuuya ljoꞌ sꞌaa. ");
INSERT INTO amuNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Tꞌo̱o̱ naⁿꞌñeeⁿ nnoom, jluena: —¿Aa maxjeⁿ mati ꞌu tsꞌaⁿ na jnaⁿꞌ Galilea? Tcuu tcuu catseiꞌnaⁿꞌ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na teiljeii, quia joꞌ nljeiꞌ tjaaꞌnaⁿ cwii profeta na nnaⁿ Galilea. ");
INSERT INTO amuNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ndoꞌ cwii ndoꞌ cwiindyena tyꞌena wꞌaana. ");
INSERT INTO amuNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Sa̱a̱ Jesús tjaaⁿ ta na jndyu Olivos. ");
INSERT INTO amuNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ndoꞌ teincoo cwiicheⁿ xuee, lcweeⁿꞌeⁿ, tjaquieeꞌnnaaⁿꞌaⁿ watsꞌom tꞌmaⁿ. Ndoꞌ jndyendye nnꞌaⁿ tquieꞌcañomna jom. Quia na jnda̱ tjacjom, tyoꞌmo̱o̱ⁿ nda̱a̱na. ");
INSERT INTO amuNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ndoꞌ juu xjeⁿꞌñeeⁿ joo nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés na matsa̱ꞌntjomnaꞌ ñequio nnꞌaⁿ tmaaⁿꞌ fariseos tquioñꞌomna cwii yuscu na mꞌaaⁿ. Yuscuꞌñeeⁿ jliuna juu xcwe na matseitjo̱o̱ñe na mꞌaaⁿ ñꞌeⁿ cwii tsaⁿsꞌa. Tquioqueⁿna juu xcwe quiiꞌntaaⁿna. ");
INSERT INTO amuNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Ndoꞌ jluena nnom Jesús: —ꞌU na maꞌmo̱o̱ⁿꞌ cantyja ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom, jliuuyâ yuscumꞌaaⁿꞌ xcwe na matseitjo̱o̱ñê ñꞌeⁿ cwii tsaⁿsꞌa. ");
INSERT INTO amuNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ndoꞌ naquiiꞌ ljeii na tqueⁿ Moisés matsa̱ꞌntjomnaꞌ na catua̱a̱ꞌa ljo̱ꞌ cjoo yolcu na cwilꞌa na luaaꞌ. Sa̱a̱ ꞌu jeꞌ, ¿chiuu matsuꞌ? ");
INSERT INTO amuNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Luaaꞌ jluena nnoom cweꞌ ee cwilꞌueena na catꞌuiinaꞌ jom. Sa̱a̱ jom jeꞌ, seintquieꞌñê, seiljeiⁿ nomtyuaa ñequio nomtsꞌo̱o̱ⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ndoꞌ cweꞌ ncꞌe na ticꞌoowintyjeeꞌna na cwitaꞌxꞌeena ñꞌoomwaaꞌ nnoom, teintyjeeꞌyuñê. Matsoom nda̱a̱na: —ꞌÑeeⁿ cwiindyoꞌ ꞌo na tjaa jnaⁿ tseixmaⁿ, juu cjuꞌjndyee tsjo̱ꞌ nacjooꞌ yuscumꞌaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Jnda̱ joꞌ seintquieꞌñennaaⁿꞌaⁿ nomtyuaa, seiljeiityeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Sa̱a̱ quia jndye naⁿꞌñeeⁿ ñꞌoomwaaꞌ, jnaⁿnaꞌ na macoꞌtianaꞌ nquiuna. Quia joꞌ to̱ꞌna na cwii ndoꞌ cwiindyena jluiꞌna joꞌ joꞌ. Nnꞌaⁿ na tquiendye jluiꞌjndyeena, jnda̱ joꞌ nnꞌaⁿ na cjeti mꞌaⁿ. Na macanda̱ ꞌndiinaꞌ nquii Jesús ñequio yuscuꞌñeeⁿ na meintyjeeꞌ jo nnoom. ");
INSERT INTO amuNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jnda̱ joꞌ teintyjeeꞌyuu Jesús, ndoꞌ cweꞌ ncꞌe meiⁿcwiindye naⁿꞌñeeⁿ tacꞌoomndyena, macanda̱ juu yuscuꞌñeeⁿ cwii mꞌaaⁿ, joꞌ chii tsoom nnom: —ꞌU yuscu, ¿yuu mꞌaⁿ nnꞌaⁿ na tquiocalue jnaⁿꞌ? ¿Aa meiⁿncwii tsꞌaⁿ ticatseijndaaꞌñe jnaⁿꞌ? ");
INSERT INTO amuNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Tꞌo̱ nnoom, matso: —Mayuuꞌ Ta, meiⁿcwii tsꞌaⁿ tjaljoꞌ sꞌaa. Matso Jesús nnom: —Meiⁿ ja ticatsꞌaaya na catꞌuiinaꞌ ꞌu. Cjaꞌtoꞌ, tantsaꞌnndaꞌ jnaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ndoꞌ seineiⁿnndaꞌ Jesús nda̱a̱ nnꞌaⁿ. Matsoom: —Ja cwiluiindyo̱ naxueeñe na mañequia naxuee jo nda̱a̱ nnꞌaⁿ tsjoomnancue. Meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na matseijomñe ñꞌeⁿndyo̱, nntseixmaⁿ naxuee na mañequia na ticantycwii na wandoꞌ tsꞌaⁿ. Tijoom nntseixmaⁿ cantyja ꞌnaaⁿꞌ najaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Quia joꞌ nnꞌaⁿ fariseos jluena nnoom: —ꞌU macwjiꞌyuuꞌndyuꞌ cheꞌnncuꞌ cantyja ꞌnaⁿꞌ. Ndoꞌ ñꞌoomꞌñeeⁿ meiⁿ tiyuuꞌ joonaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Tꞌo̱ Jesús nda̱a̱na: —Meiiⁿ na macwjiꞌyuuꞌndyo̱ cantyja ꞌnaⁿya, sa̱a̱ ñꞌoom na mayuuꞌ juunaꞌ, ncꞌe ntyjiiya yuu jnaaⁿya, ndoꞌ ntyjiiya yuu jo̱yo̱. Sa̱a̱ ꞌo ticaliuꞌyoꞌ yuu jnaaⁿya, meiⁿ yuu na jo̱. ");
INSERT INTO amuNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ꞌO cwilajndaaꞌndyoꞌ jnaaⁿ nnꞌaⁿ cantyjati na jndo̱ꞌ nꞌom nnꞌaⁿ sa̱a̱ ja meiⁿcwii tsꞌaⁿ ticatꞌuiya juu cantyja jnaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Sa̱a̱ quia nncueꞌntyjo̱ xjeⁿ na nncuꞌxa̱ⁿ, nncuꞌxa̱ⁿ chaꞌxjeⁿ na matyꞌiomyanaꞌ. Ee nchii mꞌaaⁿya na ñenco̱ na nntsꞌaa tsꞌiaaⁿꞌñeeⁿ. Nquii Tsotya̱ na jñoom ja, mꞌaaⁿñê ñꞌeⁿndyo̱. ");
INSERT INTO amuNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Naquiiꞌ ñꞌoom na sa̱ꞌntjom Tyꞌo̱o̱tsꞌom na teiljeiinaꞌ na cwileiñꞌomꞌyoꞌ, waa ñꞌoom na matsonaꞌ: “Quia na cwitjoomꞌ ñꞌoom na cwitjeiꞌyuuꞌndye we nnꞌaⁿ, maxjeⁿ cwicaluiꞌyuuꞌ ñꞌoomꞌñeeⁿ.” ");
INSERT INTO amuNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Joꞌ chii ncꞌe na luaaꞌ matsonaꞌ, ja cwiluiindyo̱ cwii tsꞌaⁿ na macwjiꞌyuuꞌndyo̱ cantyja ꞌnaⁿya, ndoꞌ Tsotya̱ya cwiluiiñê cwiicheⁿ na jnda̱ we. ");
INSERT INTO amuNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Quia joꞌ taxꞌeena nnoom: —¿Yuu mꞌaaⁿ Tsotyeꞌ? Tꞌo̱ Jesús matsoom: —ꞌO ticalaꞌno̱ⁿꞌyoꞌ cantyja ꞌnaⁿya meiⁿ cantyja ꞌnaaⁿꞌ Tsotya̱ya. Ee xeⁿ cwilaꞌno̱ⁿꞌyoꞌ cantyja ꞌnaⁿya mati nlaꞌno̱ⁿꞌyoꞌ cantyja ꞌnaaⁿꞌ jom. ");
INSERT INTO amuNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ñꞌoommeiiⁿ seineiⁿ Jesús yocheⁿ na tyoꞌmo̱o̱ⁿ naquiiꞌ watsꞌom tꞌmaⁿ ꞌnaaⁿ nnꞌaⁿ judíos, yuu cwitueeꞌ nnꞌaⁿ sꞌom cwentaaꞌ Tyꞌo̱o̱tsꞌom. Ndoꞌ meiⁿcwii tsꞌaⁿ tîcatꞌuii jom, ee tyooweꞌntyjo̱ xjeⁿ na nntjoom nawiꞌ tꞌmaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Cwiicheⁿ cwii ndiiꞌ matso Jesús nda̱a̱na: —Ja majo̱, ndoꞌ ꞌo nlꞌueꞌyoꞌ ja, sa̱a̱ ndicwaⁿ choꞌnqueⁿꞌyoꞌ jnaⁿ ndoꞌ nncwjeꞌyoꞌ. Ndoꞌ yuu na jo̱ ꞌo xocanda̱a̱ nntsquieꞌcañomꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Cweꞌ ncꞌe ñꞌoomwaaꞌ, jlue nnꞌaⁿ judíos: —¿Aa nntsꞌaacheⁿnaꞌ na nntseicueeꞌñe cheⁿnqueⁿ, na matsoom yuu na mawjaⁿ jaa xocanda̱a̱ nntsquieꞌcaño̱o̱ⁿya? ");
INSERT INTO amuNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Joꞌ chii tꞌo̱o̱ⁿ nda̱a̱na, tsoom: —ꞌO ticalaxmaⁿꞌyoꞌ cantyja ꞌnaaⁿꞌ cañoomꞌluee sa̱a̱ ja tseixmaⁿya joꞌ. ꞌO laxmaⁿꞌyoꞌ cantyja ꞌnaaⁿꞌ tsjoomnancuewaañe, sa̱a̱ ja nchii joꞌ tseixmaⁿya. ");
INSERT INTO amuNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Cweꞌ ncꞌe ñꞌoomwaaꞌ joꞌ na tsjo̱o̱ya nda̱a̱ꞌyoꞌ na ndicwaⁿ choꞌnqueⁿꞌyoꞌ jnaⁿꞌyoꞌ ndoꞌ nncwjeꞌyoꞌ. Ee xeⁿ ticalayuꞌyoꞌ na ja cwiluiindyo̱ nquii na jñom Tyꞌo̱o̱tsꞌom, quia joꞌ meiⁿchiuucheⁿ ndicwaⁿ choꞌnqueⁿꞌyoꞌ jnaⁿꞌyoꞌ quia na nncwjeꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Quia joꞌ taxꞌeenndaꞌna nnoom, jluena: —ꞌU jeꞌ, ¿ꞌñeeⁿ cwiluiindyuꞌ? Matso Jesús nda̱a̱na: —Majoꞌ chaꞌxjeⁿ na jnda̱ ñetsjo̱o̱ nda̱a̱ꞌyoꞌ xjeⁿ na to̱ꞌa na mañequiaya ñꞌoom naya. ");
INSERT INTO amuNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Nqueⁿ na jñoom ja cwiluiiñê na mayomꞌm. Jndye ñꞌoom tsoom no̱o̱ⁿ na catsjo̱o̱ya nda̱a̱ꞌyoꞌ. Ndoꞌ ñequiiꞌcheⁿ matseiteinco̱o̱ꞌa joo ñꞌoomꞌñeeⁿ nda̱a̱ nnꞌaⁿ. Sa̱a̱ jndye niom na ntyjeeⁿ ñꞌeⁿndyoꞌ na macaⁿnaꞌ na cuꞌxa̱ⁿya. ");
INSERT INTO amuNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Sa̱a̱ naⁿꞌñeeⁿ tîcalaꞌno̱ⁿꞌna na maꞌmo̱o̱ⁿ nda̱a̱na na Tyꞌo̱o̱tsꞌom cwiluiiñe Tsotyeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Quia joꞌ matsoom nda̱a̱na: —Ja cwiluiindyo̱ nquii tsꞌaⁿ na jnaⁿ cañoomꞌluee. Quia na jnda̱ jlaꞌweꞌyoꞌ ja na nlacueꞌyoꞌ, quia ljoꞌcheⁿ nlaꞌno̱ⁿꞌyoꞌ na joꞌ cwiluiindyo̱, ndoꞌ nncjaantyjo̱o̱ꞌ nꞌomꞌyoꞌ na tjaaꞌnaⁿ cwii na matsꞌaa cantyja na matseixmaⁿ nnco̱. Cantyjati na tꞌmo̱ⁿ Tsotya̱ no̱o̱ⁿ, ntyjati joꞌndyo na matsꞌaa. ");
INSERT INTO amuNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ndoꞌ Tsotya̱ na jñoom ja mꞌaaⁿñê ñꞌeⁿndyo̱. Ticaꞌñeeⁿ ja na ñenco̱, ee ñequiiꞌcheⁿ matsꞌaa yuu na cjaweeꞌ ntyjeeⁿ ñꞌeⁿndyo̱. ");
INSERT INTO amuNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jnda̱ na seineiiⁿ ñꞌoommeiⁿꞌ, jndye nnꞌaⁿ jlaꞌyuꞌ ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ndoꞌ matso Jesús nda̱a̱ nnꞌaⁿ judíos na jnda̱ macwilaꞌyuꞌ ñꞌeⁿñê: —Xeⁿ cwiljooꞌndyoꞌtyeⁿꞌyoꞌ ñequio ñꞌoom naya quia joꞌ mayuuꞌcheⁿ na cwiluiindyoꞌ nnꞌaⁿ na cwilajomndyoꞌ ñꞌoom na mañequiaya. ");
INSERT INTO amuNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ndoꞌ nlaꞌno̱ⁿꞌyoꞌ cwaaⁿ ñꞌoom tseixmaⁿnaꞌ ñꞌoom na mayuuꞌ, ndoꞌ juu ñꞌoom na mayuuꞌñeeⁿ nntseicandyaañenaꞌ ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Joo naⁿꞌñeeⁿ tꞌo̱o̱na nnoom, jluena: —Jâ cwiluiindyô̱ tsjaaⁿ Abraham na jndyowicantyjooꞌ. Meiⁿjom ndiiꞌ tyoomꞌaaⁿyâ moso nda̱a̱ ntꞌomcheⁿ nnꞌaⁿ. ¿Chiuu na matsuꞌ na nncꞌo̱o̱ⁿcandyaaꞌndyô̱ na mꞌaaⁿyâ nacje ꞌnaaⁿꞌ cwiicheⁿ? ");
INSERT INTO amuNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Tꞌo̱ Jesús nda̱a̱ naⁿꞌñeeⁿ, matsoom: —Ñꞌoom na mayuuꞌcheⁿ matsjo̱o̱ya nda̱a̱ꞌyoꞌ. Meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na matseitjo̱o̱ñe nnom Tyꞌo̱o̱tsꞌom mꞌaaⁿ xjeⁿ ꞌnaaⁿꞌ jnaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ndoꞌ tsꞌaⁿ na cweꞌ moso mꞌaaⁿ nnda̱a̱ nntsꞌaanaꞌ na tixocaljooꞌñetyeⁿ na mꞌaaⁿ patrom ꞌnaaⁿꞌ, sa̱a̱ nquii jnda patrom ñenquiicheⁿ mꞌaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ja na cwiluiindyo̱ Jnda Tyꞌo̱o̱tsꞌom, ja nntseicandyaandyo̱ ꞌo. Macweꞌ ncꞌe joꞌ nncꞌomꞌyoꞌ na canda̱a̱ꞌya na jnda̱ jndyaandyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mantyjiiya na ꞌo cwiluiindyoꞌ tsjaaⁿ Abraham na jndyowicantyjooꞌ, sa̱a̱ cwiqueⁿndyoꞌ na nlacueꞌyoꞌ ja jnaaⁿꞌ na tileicjo̱ ñꞌoom ꞌnaⁿya naquiiꞌ nꞌomꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ljoꞌ na jnda̱ ñentyꞌiaya na ñetꞌo̱o̱ⁿya ñequio Tsotya̱, joꞌ matseina̱ⁿya nda̱a̱ꞌyoꞌ. Sa̱a̱ ꞌo jeꞌ, cantyja na jnda̱ ñejndyeꞌyoꞌ ñꞌoom ꞌndyoo tsotyeꞌyoꞌ, joꞌ cwilꞌaꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Tꞌo̱o̱ naⁿꞌñeeⁿ nnoom, jluena: —Abraham cwiluiiñê tsotya̱a̱ya. Matso Jesús nda̱a̱na: —Xeⁿ ꞌo na mayuuꞌcheⁿ cwiluiindyoꞌ ntseinda Abraham na jndyowicantyjooꞌ, quia joꞌ nlꞌaꞌyoꞌ chaꞌxjeⁿ sꞌaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Sa̱a̱ jeꞌ cwijooꞌ nꞌomꞌyoꞌ na ñeꞌcalacueꞌyoꞌ ja na cwiluiindyo̱ tsꞌaⁿ na matseina̱ⁿya ñꞌoom na mayuuꞌ nda̱a̱ꞌyoꞌ. Ndoꞌ joo ñꞌoomꞌñeeⁿ ñequiiꞌcheⁿ ñꞌoom na jndiiya ꞌndyoo Tyꞌo̱o̱tsꞌom. Nquii Abraham tîcatsꞌaaⁿ chaꞌna ñeꞌcalꞌaꞌ oꞌ ñꞌeⁿndyo̱. ");
INSERT INTO amuNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ꞌO cwilꞌaꞌyoꞌ chaꞌxjeⁿ na machꞌee nquii tsotyeꞌyoꞌ. Jluena nnoom: —Jâ nchii na tuiindyô̱ na tijndaaꞌ tsotya̱a̱yâ. Jâ laꞌxmaaⁿyâ na ñecwii tsotya̱a̱yâ, nquii Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Tꞌo̱ Jesús nda̱a̱na, matsoom: —Xeⁿ na mayuuꞌcheⁿ Tyꞌo̱o̱tsꞌom cwiluiiñê tsotyeꞌyoꞌ, quia joꞌ mati nncꞌomꞌyoꞌ na jnda nquiuꞌyoꞌ ja ee jnaaⁿya na mꞌaaⁿ ndoꞌ jndyo̱o̱ya na mꞌaⁿꞌyoꞌ. Nchii jndyo̱o̱ cantyja ꞌnaⁿ nnco̱, nqueⁿ jñoom ja. ");
INSERT INTO amuNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Chiuu na tileicalaꞌno̱ⁿꞌyoꞌ ñꞌoom na matseina̱ⁿ? Maxjeⁿ cwitjomꞌyoꞌ na nmeiiⁿꞌ ncꞌe na tiñeꞌcalañꞌoomꞌndyoꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ꞌO laxmaⁿꞌyoꞌ cantyja ꞌnaaⁿꞌ tsotyeꞌyoꞌ, juu tsaⁿjndii. Yuu na lꞌue tsꞌom jom, joꞌ ñeꞌcalacanda̱a̱ꞌndyoꞌ. Jom cwiluiiñê na matseicwjeⁿ nnꞌaⁿ cantyjati xjeⁿ na tuii tsjoomnancue. Jom tjaaꞌnaⁿ ñꞌoom na mayuuꞌ catseixmaaⁿ, ee tjaaꞌnaⁿ ñꞌoom na mayuuꞌ naquiiꞌ tsꞌoom. Quia matseineiiⁿ cantu, matseineiiⁿ cantyjati na matseixmaaⁿ, cweꞌ ncꞌe tsaⁿcantu jom, ndoꞌ cwiluiiñê tsotye chaꞌtso ñꞌoom na cantu. ");
INSERT INTO amuNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Sa̱a̱ ja meiiⁿ na matseina̱ⁿya ñꞌoom na mayuuꞌ maxjeⁿ tiñeꞌcalayuꞌyoꞌ ñꞌeⁿndyo̱. ");
INSERT INTO amuNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Tjaa ꞌñeeⁿ cwiindyoꞌ ꞌo nnda̱a̱ nncjuꞌ jnaⁿ nacjoya. Ñꞌoom na matsjo̱o̱ nda̱a̱ꞌyoꞌ cwiluiiñenaꞌ ñꞌoom na mayuuꞌ, quia joꞌ ¿chiuu na tiñeꞌcalayuꞌyoꞌ ñꞌeⁿndyo̱? ");
INSERT INTO amuNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na mꞌaaⁿñe cantyja ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom mandii ñꞌoom ꞌñom. Sa̱a̱ cweꞌ ncꞌe na ticaluiindyoꞌ cantyja ꞌnaaⁿꞌaⁿ, joꞌ chii tiñeꞌcandyeꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Quia joꞌ tꞌo̱o̱ nnꞌaⁿ judíos nnoom. Jluena: —Jeeⁿ xcwe cwilꞌuuyâ na ꞌu cwiluiindyuꞌ tsꞌaⁿ Samaria. Mati mꞌaaⁿ tsaⁿjndii quiiꞌ tsꞌomꞌ joꞌ na matseintjeiⁿnaꞌ ꞌu. ");
INSERT INTO amuNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesús tꞌo̱o̱ⁿ nda̱a̱na. Matsoom: —Ja ticꞌoom tsaⁿjndii quiiꞌ tsꞌo̱o̱ⁿ. Ja Tsotya̱ya matseitꞌmaaⁿꞌndyo̱, sa̱a̱ ꞌo cwilajnaⁿꞌyoꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Sa̱a̱ nchii malꞌueeꞌndyo̱ na calatꞌmaaⁿꞌndyoꞌ ja. Mꞌaaⁿ cwiicheⁿ na machꞌee na nluiitꞌmaaⁿꞌndyo̱, ndoꞌ manquii nncuꞌxeⁿ aa cwiluii na ljoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ñꞌoom na mayuuꞌcheⁿ na matsjo̱o̱ nda̱a̱ꞌyoꞌ. Meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na matseiñꞌoomꞌñe ñꞌoom ꞌnaⁿya, tijoom nntsuuñe. ");
INSERT INTO amuNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Tꞌo̱o̱ nnꞌaⁿ judíos, jluena: —Jeꞌ manquiujndaaꞌndyo̱ na matseiꞌxmaⁿꞌ tsaⁿjndii quiiꞌ tsꞌomꞌ. Tueꞌ Abraham, ndoꞌ mati profetas. Sa̱a̱ ꞌu matsuꞌ: “Xeeⁿ mꞌaaⁿ ꞌñeeⁿ juu na matseiñꞌoomꞌñe ñꞌoom ꞌnaⁿꞌ, tijoom cueꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Chaa lꞌuu na cwiluiitꞌmaⁿndyuꞌtiꞌ, nchiiti weloo welooya Abraham tsaⁿ na teiyo tueꞌ ndoꞌ mati jnda̱ tja̱ profetas. ¿ꞌÑeeⁿ juu macheꞌ cheⁿnncuꞌ na cwiluiindyuꞌ? ");
INSERT INTO amuNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Tꞌo̱ Jesús, matsoom: —Xeⁿ ñequiiꞌcheⁿ na matseitꞌmaaⁿꞌndyo̱ cheⁿnnco̱, maxjeⁿ cweꞌ tsꞌiaaⁿꞌndyo. Juu Tsotya̱ya cwiluiiñê na matseitꞌmaaⁿꞌñê ja, nqueⁿ na cwiluiiñê Tyꞌo̱o̱tsꞌom na cwilaꞌtꞌmaaⁿꞌndyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Meiⁿ ticataꞌjnaaⁿꞌyoꞌ jom. Ja mayuuꞌ mawajnaⁿꞌa jom, ndoꞌ xeⁿ nntsjo̱o̱ na ticwajnaⁿꞌa jom, quia joꞌ nntsꞌaa cheⁿnnco̱ na cantundyo̱ chaꞌxjeⁿ ꞌo. Sa̱a̱ mayuuꞌcheⁿ mawajnaⁿꞌa jom, ndoꞌ matseicanda̱a̱ꞌndyo̱ ñꞌoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Tioo na neiiⁿꞌ tsꞌom welooꞌyoꞌ Abraham tsaⁿ na ñetꞌoom teiyo na seiꞌno̱o̱ⁿꞌo̱ⁿ na nncueeꞌ xjeⁿ na nluiindyo̱ na tsꞌaⁿ ja. Ntyꞌiaaⁿꞌaⁿ joꞌ, ndoꞌ tquiaanaꞌ na jeeⁿ neiiⁿꞌeⁿ cantyja ꞌnaaⁿꞌ na ljoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ndoꞌ jlue nnꞌaⁿ judíos nnoom: —Nchaa lꞌuu mayuuꞌ na jnda̱ ntyꞌiaꞌ Abraham ee ꞌu meiⁿ cweꞌ wenꞌaaⁿ nchooꞌ nqui chuꞌ tyooweeꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Tꞌo̱ Jesús nda̱a̱ naⁿꞌñeeⁿ, matsoom: —Ñꞌoom na mayuuꞌcheⁿ matsjo̱o̱ nda̱a̱ꞌyoꞌ, cwii tjo̱o̱cheⁿ na nluiiñe Abraham, sa̱a̱ ja maxjeⁿ mamꞌaaⁿya. ");
INSERT INTO amuNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Quia joꞌ jlaꞌxcwiina ljo̱ꞌ na njñomna jom. Meiⁿ tiqueⁿna cwenta teiño̱o̱ⁿ xcwe quiiꞌntaaⁿna. Mana jlueeⁿꞌeⁿ watsꞌom tꞌmaⁿ ꞌnaaⁿna. ");
INSERT INTO amuNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jâ nnꞌaⁿ na canchooꞌwe na tꞌmaⁿ Jesús na calajomndyô̱ ñꞌeⁿñê tyomaꞌno̱o̱ⁿyâ ñꞌeⁿñê. Yocheⁿ na saawiꞌno̱o̱ⁿyâ cwii joo, ntyꞌiaayâ cwii tsaⁿsꞌa xjeⁿ na tuiiñe na nchjaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ndoꞌ taxꞌa̱a̱yâ nnoom, lꞌuuyâ: —ꞌU Maestro, ¿ꞌñeeⁿ juu seitjo̱o̱ñe nnom Tyꞌo̱o̱tsꞌom, joꞌ na tuiiñe tsaⁿmꞌaaⁿꞌ na nchjaaⁿꞌaⁿ? ¿Aa nqueⁿ oo aa nnꞌaⁿ na nda jom? ");
INSERT INTO amuNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Tꞌo̱ Jesús nda̱a̱yâ, matsoom: —Meiⁿ nchii jnaaⁿꞌ nquii na tuiiñe na nchjaaⁿꞌ, meiⁿ nchii jnaaⁿ nnꞌaⁿ na nda juu. Luaaꞌ tjom cha cantyja ꞌnaaⁿꞌ caꞌmo̱ⁿnaꞌ na nquii Tyꞌo̱o̱tsꞌom waa najndeii na matseixmaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tseixmaⁿya na catsꞌaaya tsꞌiaaⁿ ꞌnaaⁿꞌ nqueⁿ na jñoom ja yocheⁿ na ndicwaⁿ wando̱ꞌa. Ee quia nncueꞌntyjo̱ xjeⁿ na nncwja̱a̱ya, quia joꞌ xonda̱a̱ nlꞌaatya̱a̱ya tsꞌiaaⁿ ꞌnaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Yocheⁿ na mꞌaaⁿya quiiꞌntaaⁿ nnꞌaⁿ, cwiluiindyo̱ chom na mañequiaa naxuee jo nda̱a̱na. ");
INSERT INTO amuNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jnda̱ na tsoom na luaaꞌ, tjoomꞌm ndaajnaⁿꞌ nomtyuaa. Sꞌaaⁿ tsooꞌ ñequio juunaꞌ, jnda̱ joꞌ tyꞌoomñê tsooꞌñeeⁿ luaꞌnnom tsaⁿnchjaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ndoꞌ tsoom nnom: —Cjaꞌ peila na jndyu Siloé, camaⁿꞌ nꞌomnjomꞌ. Ñꞌoom Siloé matsonaꞌ jñom tsꞌaⁿ xꞌiaaⁿꞌaⁿ. Ndoꞌ tja tsaⁿꞌñeeⁿ, tmaaⁿ nnoom. Ndoꞌ quia jndyolcweeⁿꞌeⁿ xuee mantyꞌiaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ndoꞌ nnꞌaⁿ na nndyooꞌ mꞌaⁿ yuu na macꞌeeⁿ ñequio nnꞌaⁿ na ñentyꞌiaana jom na ñetcaaⁿ ljoꞌ tjo̱o̱ñê, taꞌxꞌeena nda̱a̱ ntyjeena: —¿Aa nchii luaaꞌ tsaⁿnchjaaⁿꞌ na tacatyeeⁿ na tcaⁿ ljoꞌ tjo̱o̱ñe? ");
INSERT INTO amuNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Ntꞌomndye joona jluena: —Majom luaaꞌ. Sa̱a̱ ntꞌomcheⁿ jlue: —Nchii jom, cweꞌ na jeeⁿ tseijomnaꞌ. Sa̱a̱ nqueⁿ matsoom: —Maja luaa. ");
INSERT INTO amuNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Joꞌ na taꞌxꞌeena nnoom, jluena: —¿Chiuu tuiiyuu na ya teitquioꞌ jeꞌ? ");
INSERT INTO amuNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Tꞌo̱o̱ⁿ nda̱a̱na, tsoom: —Juu tsꞌaⁿ na jndyu Jesús sꞌaaⁿ tsooꞌ, tyꞌoomñê juunaꞌ luaꞌno̱o̱ⁿ. Jnda̱ joꞌ matso na cjo̱ya Siloé na cjo̱camaaⁿ no̱o̱ⁿ. Ndoꞌ tjo̱ joꞌ, tmaaⁿ no̱o̱ⁿ, ndoꞌ jeꞌ xuee mantyꞌiaya. ");
INSERT INTO amuNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Quia joꞌ taꞌxꞌeetina nnoom, jluena: —¿Ndoꞌ juu tsaⁿꞌñeeⁿ, yuu mꞌaaⁿ? Tꞌo̱o̱ⁿ nda̱a̱na: —Ticaljeiiya. ");
INSERT INTO amuNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Quia joꞌ tyꞌeñꞌomna juu tsꞌaⁿ na ñetꞌoom na nchjaaⁿꞌ jo nda̱a̱ nnꞌaⁿ judíos na laꞌxmaⁿ tmaaⁿꞌ fariseos. ");
INSERT INTO amuNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ee xuee na cwitaꞌjndyee nnꞌaⁿ quia sꞌaa Jesús tsooꞌ na sꞌaaⁿ na ya mantyꞌiaaꞌ tsaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Ndoꞌ mati nnꞌaⁿ fariseosꞌñeeⁿ tyotaꞌxꞌeena nnoom. Tyoluena: —¿Chiuu tuiiyuu na ya mantyꞌiaꞌ? Tꞌo̱o̱ⁿ nda̱a̱ naⁿꞌñeeⁿ, tsoom: —Juu tsaⁿꞌñeeⁿ tyꞌoomñê tsooꞌ luaꞌno̱o̱ⁿ, jnda̱ chii tmaaⁿya luaꞌno̱o̱ⁿ, ndoꞌ jeꞌ ya mantyꞌiaya. ");
INSERT INTO amuNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Sa̱a̱ ntꞌom fariseosꞌñeeⁿ tyoluena: —Tsaⁿsꞌamꞌaaⁿꞌ nchii mꞌaaⁿ cantyja ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom, ee ticatseitꞌmaaⁿꞌñê xuee na cwitaꞌjndya̱a̱ya. Ndoꞌ ntꞌom ncꞌiaana jlue: —Tsꞌaⁿ na tseixmaⁿ jnaⁿ tixocanda̱a̱ nntsꞌaaⁿ cwii tsꞌiaaⁿ tꞌmaⁿ chaꞌna luaaꞌ. Ndoꞌ laaꞌtiꞌ tîcwijom ñꞌoom na jlaꞌneiⁿna. ");
INSERT INTO amuNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Joꞌ chii taꞌxꞌeenndaꞌna nnom tsꞌaⁿ na ñetꞌoom na nchjaaⁿꞌ. Jluena nnoom: —Ndoꞌ ꞌu jeꞌ, ¿ljoꞌ matsuꞌ cantyja ꞌnaaⁿꞌaⁿ na sꞌaaⁿ na ya mantyꞌiaꞌ? Tꞌo̱o̱ⁿ, matsoom: —Tsaⁿꞌñeeⁿ cwiluiiñê profeta. ");
INSERT INTO amuNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Sa̱a̱ nnꞌaⁿ judíosꞌñeeⁿ maxjeⁿ tiñeꞌcalaꞌyuꞌna na ñetꞌoom na nchjaaⁿꞌaⁿ ndoꞌ jeꞌ jnda̱ ljoya mantyꞌiaaⁿꞌaⁿ. Joꞌ chii tqueeⁿꞌndyena nnꞌaⁿ na nda jom. ");
INSERT INTO amuNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Ndoꞌ taꞌxꞌeena nda̱a̱ naⁿꞌñeeⁿ, jluena: —Tsaⁿmꞌaaⁿꞌ, ¿aa ndaꞌyoꞌ jom? Chiuu cwinduꞌyoꞌ, ¿aa mayuuꞌ na tuiiñê na nchjaaⁿꞌaⁿ? ");
INSERT INTO amuNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ndoꞌ tꞌo̱o̱ nnꞌaⁿ na nda jom. Jluena: —Manquiuuyâ na ndaayâ jom, ndoꞌ manquiuuyâ na tuiiñê na nchjaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Sa̱a̱ cantyja chiuu tuiiyuu na ya mantyꞌiaaⁿꞌaⁿ jeꞌ, joꞌ ticaliuuyâ. Meiⁿ ticaliuuyâ ꞌñeeⁿ sꞌaa na ya mantyꞌiaaⁿꞌaⁿ. Sa̱a̱ jnda̱ tueꞌntyjo̱ choomꞌm. Joꞌ chii cataꞌxꞌeeꞌyoꞌ ꞌñom chiuu waa. Manquiityeeⁿ nntsoom chiuu tuii. ");
INSERT INTO amuNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Luaaꞌ ñꞌoom tꞌo̱o̱ joo nnꞌaⁿ na nda jom, ee nquiaana nnꞌaⁿ na cwiluiitquiendye nda̱a̱ nnꞌaaⁿna. Ee jnda̱ jlaꞌjomndyena xeⁿ na nncwjiꞌyuuꞌñe meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na Jesús cwiluiiñê Cristo, tixonquiana na wanaaⁿ na nntseijomñe tsaⁿꞌñeeⁿ xjeⁿ na cwitjomndye nnꞌaⁿ na nlaꞌtꞌmaaⁿꞌndyena Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Cweꞌ na luaaꞌ waa, joꞌ na jlue nnꞌaⁿ na nda jom: “Jnda̱ tueꞌntyjo̱ ñoomꞌm. Cataꞌxꞌeeꞌyoꞌ ꞌñom.” ");
INSERT INTO amuNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Quia joꞌ jnda̱ we ndiiꞌ tqueeⁿꞌ nnꞌaⁿ judíos juu tsaⁿ na ñetꞌoom na nchjaaⁿꞌ. Tyoluena nnoom: —Ñequio na ndoꞌ Tyꞌo̱o̱tsꞌom catseineiⁿꞌ ñꞌoom na mayuuꞌcheⁿ. Jâ cwilaꞌno̱o̱ⁿꞌâ na juu tsaⁿsꞌamꞌaaⁿꞌ matseixmaaⁿ jnaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ndoꞌ tꞌo̱o̱ⁿ nda̱a̱na, matsoom: —Ticaljeiiya, aa jom tsꞌaⁿ na matseixmaⁿ jnaⁿ. Ñeꞌcwii waa na matseiꞌno̱ⁿꞌa, meiiⁿ na ñetꞌo̱o̱ⁿ na nchjaⁿya, sa̱a̱ jeꞌ ya mantyꞌiaya. ");
INSERT INTO amuNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Quia joꞌ taꞌxꞌeenndaꞌna nnoom. Jluena: —¿Ljoꞌ sꞌaaⁿ ꞌu? ¿Chiuu sꞌaayom na ya mantyꞌiaꞌ? ");
INSERT INTO amuNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Tꞌo̱o̱ⁿ nda̱a̱ naⁿꞌñeeⁿ, matsoom: —Majnda̱ tsjo̱o̱ya nda̱a̱ꞌyoꞌ, sa̱a̱ ticalañꞌoomꞌndyoꞌ. Ndoꞌ jeꞌ ¿chiuu na ñeꞌcandyeꞌnndaꞌyoꞌ? ¿Aa mati ꞌo ñeꞌcalajomndyoꞌ ñꞌoom na mañequiaaⁿ? ");
INSERT INTO amuNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ndoꞌ jlaꞌjnaaⁿꞌ naⁿꞌñeeⁿ tsꞌaⁿ na ñetꞌoom na nchjaaⁿꞌ. Jluena: —ꞌU cwiluiindyuꞌ tsꞌaⁿ na matseijomñe ñꞌoomꞌm, sa̱a̱ jâ cwilajomndyô̱ ñꞌoom na tyoñequiaa Moisés. ");
INSERT INTO amuNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Jâ manquiuuyayâ na seineiⁿ Tyꞌo̱o̱tsꞌom nnom Moisés, sa̱a̱ tsaⁿmꞌaaⁿꞌ meiⁿ cweꞌ ticaliuuyâ yuu jnaⁿyom. ");
INSERT INTO amuNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Tꞌo̱ tsaⁿꞌñeeⁿ nda̱a̱na, matsoom: —Jeeⁿcheⁿ ndyaꞌ cjaaweeꞌ tsꞌo̱o̱ⁿ na luaaꞌ, na ꞌo ticaliuꞌyoꞌ yuu jnaⁿyom, ndoꞌ jnda̱ tquiaaⁿ na ya mantyꞌiaya. ");
INSERT INTO amuNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Chaꞌtsondyo̱ manquiuuya na Tyꞌo̱o̱tsꞌom xocañeeⁿ ñꞌoom ndyuee nnꞌaⁿ na laxmaⁿ jnaⁿ. Sa̱a̱ meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na matseitꞌmaaⁿꞌñe jom ndoꞌ na machꞌee yuu na lꞌue tsꞌoom, tsaⁿꞌñeeⁿ nñeeⁿ ñꞌoom ꞌndyoo. ");
INSERT INTO amuNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Cantyjati xuee na jnaⁿ tsjoomnancue, meiⁿjom ndiiꞌ tyoondye nnꞌaⁿ na ñetꞌoom cwii tsꞌaⁿ na sꞌaa na ya mantyꞌiaaꞌ cwii tsꞌaⁿ na tuiiñe na nchjaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Xeⁿ nchii Tyꞌo̱o̱tsꞌom mꞌaaⁿ ñꞌeⁿ tsaⁿmꞌaaⁿꞌ, tjaa na nnda̱a̱ nntsꞌaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Tꞌo̱o̱na nnoom, jluena: —ꞌU chaꞌtso na chaꞌtso cantyja na tuiindyuꞌ matseiꞌxmaⁿꞌ jnaⁿ. Ndoꞌ ¿aa matseijnduꞌ na mꞌmo̱ⁿꞌ nda̱a̱ jâ? Quia joꞌ tjeiiꞌna jom watsꞌom chjoo ꞌnaaⁿna yuu cwitjomndyena. ");
INSERT INTO amuNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jndii Jesús na tjeiiꞌna tsaⁿꞌñeeⁿ quiiꞌntaaⁿna. Quia ljeiiⁿ juu, matsoom nnom: —¿Aa matseiyuꞌ ñequio Jnda Tyꞌo̱o̱tsꞌom? ");
INSERT INTO amuNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Tꞌo̱ tsaⁿꞌñeeⁿ, matsoom: —Jeeⁿ ꞌu Ta, ¿cwaaⁿ tsꞌaⁿ jom cha ya nntseiyuꞌa ñꞌeⁿñê? ");
INSERT INTO amuNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Matso Jesús nnoom: —Majnda̱ ntyꞌiaꞌ jom. Mannco̱ na matseina̱ⁿya njomꞌ cwiluiindyo̱ nqueⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Quia joꞌcheⁿ matsoom: —ꞌU Ta, matseiyuꞌa ñꞌeⁿndyuꞌ. Ndoꞌ seitꞌmaaⁿꞌñê Jesús. ");
INSERT INTO amuNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ndoꞌ Jesús matsotyeeⁿcheⁿ: —Ja jndyo̱o̱ tsjoomnancuewaañe na nnto̱ⁿꞌa nnꞌaⁿ. Nquiee nnꞌaⁿ na ndooꞌ nquiuna na cwilaꞌno̱ⁿꞌna chiuu waa cantyja ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom nntsꞌaa na nncꞌomna chaꞌcwijom tsꞌaⁿ na nchjaaⁿꞌ. Ndoꞌ joo nnꞌaⁿ na ndooꞌ nquiuna na mꞌaⁿna na nchjaaⁿna cantyja ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom, joona nñequiaya na canda̱a̱ꞌya nlaꞌno̱ⁿꞌna cantyja ꞌnaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Nndyooꞌ meintyjeeꞌ cwantindye nnꞌaⁿ tmaaⁿꞌ fariseos, ndoꞌ jndyena na luaaꞌ tso Jesús. Quia joꞌ taꞌxꞌeena nnoom, jluena: —¿Aa mati jâ machꞌeenaꞌ na nchjaaⁿyâ? ");
INSERT INTO amuNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Tꞌo̱ Jesús nda̱a̱na, matsoom: —Xeⁿ na jeꞌ laxmaⁿꞌyoꞌ chaꞌna nnꞌaⁿ na ticalaꞌno̱ⁿꞌ cantyja ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom quia joꞌ tjaaꞌnaⁿ jnaⁿ na cwilaxmaⁿꞌyoꞌ. Sa̱a̱ ncꞌe na cwinduꞌyoꞌ na ꞌo laxmaⁿꞌyoꞌ nnꞌaⁿ na canda̱a̱ꞌya cwilaꞌno̱ⁿꞌ cantyja ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom, joꞌ chii cwilaxmaⁿꞌyoꞌ na choꞌnqueⁿꞌyoꞌ jnaⁿꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","’Ñꞌoom na mayuuꞌcheⁿ na matsjo̱o̱ nda̱a̱ꞌyoꞌ, juu tsꞌaⁿ na nchii ꞌndyootsꞌa tiom wjaaquieeꞌ yuu na ñjomndye canmaⁿ, sa̱a̱ cwiicheⁿ joo wjaawaaⁿ juu tiomꞌñeeⁿ na nncwincjeeⁿꞌeⁿ juunaꞌ, tsaⁿꞌñeeⁿ cwiluiiñê tsaⁿcanchꞌue ndoꞌ tsaⁿ na mawincjeꞌ tiom. ");
INSERT INTO amuNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Sa̱a̱ nquii tsꞌaⁿ na cwiluiiñe na mateixꞌee canmaⁿ, xcwe ꞌndyootsꞌa tiom nncjaaqueⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Tsꞌaⁿ na machꞌee cwenta ꞌndyootsꞌa tiomꞌñeeⁿ, matseicanaaⁿñe na nncwinoom. Ndoꞌ joo canmaⁿꞌñeeⁿ na mateixꞌeeⁿ cwitaꞌjnaaⁿꞌyoꞌ jñeeⁿꞌeⁿ. Macwjeeⁿꞌeⁿ ncueeyoꞌ, wjaachom jooyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ndoꞌ quia na jnda̱ tjeiiⁿꞌeⁿ chaꞌtso canmaⁿ na machꞌeeⁿ cwenta, wjaajñeeⁿ jo nda̱a̱yoꞌ, ꞌoontyjo̱yoꞌ naxeeⁿꞌeⁿ ee cwitaꞌjnaaⁿꞌyoꞌ jñeeⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Cwii tsꞌaⁿ na ticataꞌjnaaⁿꞌyoꞌ na nchii tyꞌoyoꞌ, xocꞌoontyjo̱yoꞌ naxeⁿꞌ, hasta nleiꞌnomyoꞌ juu. Ee ticataꞌjnaaⁿꞌyoꞌ jndyeeꞌ cwiicheⁿ tsꞌaⁿ na nchii tyꞌoyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Luaaꞌ ñꞌoom na cweꞌ tjañoomꞌ na seineiⁿ Jesús nda̱a̱na. Sa̱a̱ tîcalaꞌno̱ⁿꞌna ljoꞌ ñeꞌcatsonaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ndoꞌ seineiⁿticheⁿ Jesús nda̱a̱ naⁿꞌñeeⁿ. Tsoom: —Ñꞌoom na mayuuꞌcheⁿ matsjo̱o̱ nda̱a̱ꞌyoꞌ, ja cwiluiindyo̱ ꞌndyootsꞌa tiom na cwiꞌooquieꞌ canmaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Chaꞌtso ntꞌomcheⁿ nnꞌaⁿ na jnda̱ tquiocalue na cwiluiindye na nnteiꞌxꞌee canmaⁿ cwii tjo̱o̱cheⁿ na jndyo̱o̱, joo naⁿꞌñeeⁿ laꞌxmaⁿna naⁿcantyꞌue ndoꞌ nnꞌaⁿ na cwiwincjeꞌ tiom. Sa̱a̱ joo canmaⁿ na mayuuꞌcheⁿ cwiluiindye cwentaya tînquiandyena cantyja ꞌnaaⁿ naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ja ꞌndyootsꞌa tiom cwiluiindyo̱. Meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na nncjaaquieeꞌ cantyja ꞌnaⁿya, tsaⁿꞌñeeⁿ nluiꞌnꞌmaaⁿñê. Nntseijomnaꞌ jom chaꞌcwijom cwii catsmaⁿ na maljeiiyoꞌ na nlcwaꞌ na macaluiꞌyoꞌ tiomꞌñeeⁿ ndoꞌ na macwjeeꞌnndaꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","’Tsaⁿcanchꞌue ñequiiꞌcheⁿ na macwjeeⁿꞌeⁿ na nnchꞌueeⁿ nntseicueⁿꞌeⁿ ndoꞌ na nntseiꞌnaⁿꞌaⁿ. Ja jndyo̱o̱ na nñequia na ticantycwii na cwitaꞌndoꞌ nnꞌaⁿ, ndoꞌ cha na canda̱a̱ꞌya na nlaꞌxmaⁿna juu joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ja cwiluiindyo̱ tsꞌaⁿ na canda̱a̱ꞌya mateixꞌee canmaⁿ. Juu tsꞌaⁿ na canda̱a̱ꞌya na mateixꞌee canmaⁿ ntsmeiⁿꞌ, mañequiaañe na cueꞌ cwentaayoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Sa̱a̱ juu tsaⁿntjom na nchii cwiluiiñê tyꞌoyoꞌ ee cweꞌ machꞌeeⁿ cwenta jooyoꞌ, noomꞌm na ndyocwjeeꞌcañoom lobo. Quia joꞌ maꞌñeeⁿ canmaⁿꞌñeeⁿ, maleinoom. Ndoꞌ juu loboꞌñeeⁿ mantyjo̱ ndoꞌ matꞌuii jooyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Maleinom tsaⁿꞌñeeⁿ ee cweꞌ tsaⁿntjom jom, joꞌ chii ticajnda ntyjeeⁿ canmaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","’Ja cwiluiindyo̱ tsꞌaⁿ na canda̱a̱ꞌya mateixꞌa̱ya canmaⁿ. Ndoꞌ chaꞌxjeⁿ wajnaaⁿꞌ Tsotya̱ ja, mati ja mawajnaⁿꞌa jom. Maluaaꞌ matseijomnaꞌ na wajnaⁿꞌa canmaⁿ ntsma̱a̱ⁿꞌa, ndoꞌ quiooꞌ ntsma̱a̱ⁿꞌa cwitajnaaⁿꞌyoꞌ ja. Ndoꞌ mañequiaandyo̱ na cꞌio̱ cwentaa canmaⁿ ntsma̱a̱ⁿꞌa. ");
INSERT INTO amuNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mati mamꞌaⁿ ntꞌomcheⁿ nnꞌaⁿ na cwiluiindyena canmaⁿ ntsma̱a̱ⁿꞌa na ticꞌomna tmaaⁿꞌwaa. Mati joona cwiluiindyo̱ na cjo̱cacho̱o̱ya, ndoꞌ nnquiontyjo̱na na nncwaⁿya joona. Ndoꞌ nncuaa na ñeꞌcwii tmaaⁿꞌ, ndoꞌ ñeꞌcwii tsꞌaⁿ na nnteixꞌee joona. ");
INSERT INTO amuNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","’Nquii Tsotya̱ jeeⁿ candyaꞌ tsꞌoom ja, ee mañequiaandyo̱ na cꞌio̱ cwentaa nnꞌaⁿ na cwiluiindye canmaⁿ ntsma̱a̱ⁿꞌa cha nñequiaaⁿ na nncwando̱ꞌnndaꞌa. ");
INSERT INTO amuNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Tjaaꞌnaⁿ ꞌñeeⁿ juu na nnda̱a̱ nntseicueeꞌ ja na nchii ñꞌoomya. Mannco̱tya̱ mañequiaandyo̱ na ljoꞌ catjo̱ⁿ. Waa najndo̱ na cwiluiindyo̱ na catsꞌaa na ljoꞌ, ndoꞌ mati waa na jndo̱ na nncwando̱ꞌxco̱. Luaaꞌ ñꞌoom na sa̱ꞌntjom Tsotya̱ya na catseixmaⁿya. ");
INSERT INTO amuNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jnda̱ na jndye nnꞌaⁿ judíos ñꞌoommeiⁿꞌ sꞌaanaꞌ na tîcatjoomꞌnndaꞌ na jlaꞌneiⁿna cantyja ꞌnaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ee jndyendye joona jluena: —Tsaⁿjndii matseixmaaⁿ, ndoꞌ jnda̱ teintjeiⁿñê. ¿Chiuu na cwindyeꞌyoꞌ ñꞌoom na matseineiiⁿ? ");
INSERT INTO amuNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Sa̱a̱ ntꞌomndye joona jlue: —Nchaa lꞌuu ñꞌoommeiⁿꞌ laꞌxmaⁿnaꞌ ñꞌoom na nntseineiⁿ tsꞌaⁿ na mꞌaaⁿ nacje ꞌnaaⁿꞌ tsaⁿjndii. ¿Aa nntsꞌaacheⁿnaꞌ cwii tsꞌaⁿ na mꞌaaⁿ nacje ꞌnaaⁿꞌ tsaⁿjndii nnda̱a̱ nntsꞌaa na nntyꞌiaaꞌ tsꞌaⁿ na nchjaaⁿꞌ? ");
INSERT INTO amuNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Tsjoom Jerusalén tueeꞌ xuee quia cwilaꞌtꞌmaaⁿꞌndye nnꞌaⁿ judíos na cwijaañjoomꞌ nꞌomna xjeⁿ na tiooxconndaꞌ weloo weloona cwenta watsꞌom tꞌmaⁿ lꞌo̱ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Ndoꞌ xcwe ncueesuaꞌ quia tueeꞌ xueeꞌñeeⁿ. Jesús mꞌaaⁿ watsꞌom tꞌmaⁿ ꞌnaaⁿna. Manoom naquiiꞌ cwii wꞌaa cwentaaꞌ watsꞌomꞌñeeⁿ na cweꞌ wanaaⁿ ndiocheⁿ na sꞌaa Salomón. ");
INSERT INTO amuNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Quia joꞌ nnꞌaⁿ na cwiluiitquiendye nda̱a̱ nnꞌaⁿ judíos tjaaꞌndyena tsei Jesús. Taꞌxꞌeena nnoom jluena: —¿Cwanti yo na maleichuꞌ jâ na matseiñꞌeeⁿꞌndyuꞌ jâ? Xeⁿ na mayuuꞌ cwiluiindyuꞌ Cristo, ntyjayu catsuꞌ nda̱a̱yâ. ");
INSERT INTO amuNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Matso Jesús nda̱a̱na: —Jnda̱ tsjo̱o̱ na ljoꞌ nda̱a̱ꞌyoꞌ, sa̱a̱ maxjeⁿ tîcalayuꞌyoꞌ. Majoo tsꞌiaaⁿ na matsꞌaa ñequio najndeii na matseixmaⁿ Tsotya̱, joonaꞌ cwitjeiꞌyuuꞌndyenaꞌ cantyja ꞌnaⁿya. ");
INSERT INTO amuNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Sa̱a̱ ꞌo tiñeꞌcalayuꞌyoꞌ ñꞌeⁿndyo̱ cweꞌ ncꞌe nchii cwiluiindyoꞌ canmaⁿ ntsma̱a̱ⁿꞌa. ");
INSERT INTO amuNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ee nnꞌaⁿ na cwiluiindye canmaⁿ ntsma̱a̱ⁿꞌa cwindyena jndyeya, ndoꞌ ja mawajnaⁿꞌa joona, ndoꞌ joona cwinquiontyjo̱na naxa̱ⁿꞌa. ");
INSERT INTO amuNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ja mañequia na ticantycwii na cwitaꞌndoꞌna, meiⁿ tajom catsuundyena. Ndoꞌ tjaa meiⁿcwii tsꞌaⁿ na nnda̱a̱ nncwjiꞌ joona lꞌo̱o̱. ");
INSERT INTO amuNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ee nquii Tsotya̱ na tquiaaⁿ joona lꞌo̱o̱, jom cwiluiitꞌmaⁿñetyeeⁿ na chaꞌtso, ndoꞌ meiⁿcwii tjaa ꞌñeeⁿ juu nnda̱a̱ nncwjiꞌ joona lꞌo̱o̱ⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ja ñequio Tsotya̱ ñeꞌcwii cwiluiindyo̱ ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jnda̱ na jndye nnꞌaⁿ judíosꞌñeeⁿ na luaaꞌ ñꞌoom tso Jesús, jlaꞌxcwiinndaꞌna ljo̱ꞌ na nntueeꞌna nacjoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Quia joꞌ tsoom nda̱a̱na: —Majndye tsꞌiaaⁿ na ya jnda̱ sꞌaaya jo nda̱a̱ꞌyoꞌ ñequio najndeii na matseixmaⁿ Tsotya̱ya. ¿Cwaaⁿ cwii juunaꞌ na machꞌeenaꞌ na ñeꞌcajñomꞌyoꞌ ljo̱ꞌ ja? ");
INSERT INTO amuNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ndoꞌ tꞌo̱o̱ judíosꞌñeeⁿ nnoom, jluena: —Nchii ñeꞌcajño̱o̱ⁿyâ ljo̱ꞌ ꞌu cweꞌ cwii tsꞌiaaⁿ na ya macheꞌ. Nlꞌaayâ na luaaꞌ ꞌu ee matseiꞌjnaⁿꞌ Tyꞌo̱o̱tsꞌom. Ee ꞌu cweꞌ tsꞌaⁿ ꞌu, sa̱a̱ macheꞌ na cwiluiindyuꞌ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesús tꞌo̱o̱ⁿ nda̱a̱na, tsoom: —Naquiiꞌ ljeii ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na cwileiñꞌomꞌyoꞌ, manquiuꞌyoꞌ na nquii Tyꞌo̱o̱tsꞌom matsoom: “Nda̱a̱ꞌ ꞌo na cwiluiitquiendyoꞌ jo nda̱a̱ nnꞌaⁿ matsjo̱o̱ na matseijomnaꞌ ꞌo chaꞌna nnco̱.” ");
INSERT INTO amuNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Matsoticheⁿ Jesús: —Tso Tyꞌo̱o̱tsꞌom nda̱a̱ nnꞌaⁿ na cwiluiitquiendye nda̱a̱ nnꞌaⁿ judíos na matseijomnaꞌ joona chaꞌna nqueⁿ. Ndoꞌ manquiuuya na tixocatsꞌaanaꞌ na cweꞌ cantu ñꞌoom na tsoom. ");
INSERT INTO amuNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Joꞌ chii tixcwe na cwinduꞌyoꞌ na matseijnaaⁿꞌa jom ncꞌe na tsjo̱o̱ na cwiluiindyo̱ Jnaaⁿ. Ee nqueⁿ tyꞌioom tsꞌiaaⁿ ja, ndoꞌ sa̱ꞌntjoom ja na candyocꞌo̱o̱ⁿndyo̱ quiiꞌntaaⁿꞌ ꞌo nnꞌaⁿ tsjoomnancue. ");
INSERT INTO amuNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Joꞌ chii xeⁿ nchii tsꞌiaaⁿ ꞌnaaⁿꞌ Tsotya̱ matsꞌaa, ticalayuꞌyoꞌ ñꞌeⁿndyo̱. ");
INSERT INTO amuNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Sa̱a̱ ncꞌe na matsꞌaa tsꞌiaaⁿ ꞌnaaⁿꞌaⁿ, joꞌ chii calayuꞌyoꞌ cantyja ꞌnaaⁿ mañejoo tsꞌiaaⁿꞌñeeⁿ meiiⁿ na tiñeꞌcalayuꞌyoꞌ ñꞌeⁿndyo̱ ja. Ee cantyja ꞌnaaⁿ joonaꞌ nliuꞌyoꞌ ndoꞌ nlaꞌno̱ⁿꞌyoꞌ na nquii Tsotya̱ ñeꞌcwii cwiluiiñê ñꞌeⁿndyo̱, ndoꞌ ja ñeꞌcwii cwiluiindyo̱ ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Quia joꞌ cwiicheⁿ cwii ndiiꞌ jlaꞌjndaaꞌndyena na nntꞌuena jom, sa̱a̱ tîcanda̱a̱ lꞌana, tjaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Quia joꞌ teiꞌtyꞌio̱o̱nndaaꞌâ jndaa Jordán ñꞌeⁿ Jesús yuu ñetꞌoomjndyee Juan na tyotseitsꞌoomñê nnꞌaⁿ. Ndoꞌ majndye xuee ñetꞌo̱o̱ⁿyâ joꞌ joꞌ ñꞌeⁿ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ndoꞌ jndye nnꞌaⁿ tquieꞌcañom na mꞌaaⁿyâ na ñeꞌcandyena ñꞌoom na tyoñequiaaⁿ. Tyoluena nda̱a̱ ncꞌiaana: —Juan meiⁿcwii tsꞌiaaⁿ tyoochꞌeeⁿ na xocanda̱a̱ nluiinaꞌ na cweꞌ tsꞌaⁿ nntsꞌaa. Sa̱a̱ chaꞌtso ñꞌoom na tyoñequiaaⁿ cantyja ꞌnaaⁿꞌ tsaⁿmꞌaaⁿꞌ, ñequiiꞌcheⁿ na mayuuꞌ joonaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ndoꞌ majndye nnꞌaⁿ tyolaꞌyuꞌ ñꞌeⁿ Jesús joꞌ joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Tyomꞌaaⁿ cwii tsꞌaⁿ wiiꞌ na jndyu Lázaro. Juu tsaⁿꞌñeeⁿ tyomꞌaaⁿ tsjoom Betania ñequio María ñequio xjoom Marta. ");
INSERT INTO amuNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Majuu María, xjo Lázaroꞌñeeⁿ, tsaⁿ na tuꞌnquio ncheⁿꞌ ncꞌee Jesús, ndoꞌ ñequio sooxqueeⁿ tyueeꞌñê ncꞌee. ");
INSERT INTO amuNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ndoꞌ joo yolcuꞌñeeⁿ jlaꞌcwanomna ñꞌoom na mꞌaaⁿ Jesús. Jluena: —ꞌU Ta, juu tsꞌaⁿ na jeeⁿ candyaꞌ tsꞌomꞌ, weeⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jnda̱ na jndii Jesús ñꞌoomwaaꞌ, matsoom: —Tycuwaaꞌ nchii macanda̱ na cweꞌ nntseicueeꞌnaꞌ jom. Matjoom na luaaꞌ cha caluiitꞌmaaⁿꞌñe Tyꞌo̱o̱tsꞌom cantyja ꞌnaaⁿꞌaⁿ. Ndoꞌ mati nntseitꞌmaaⁿꞌñê ja na cwiluiindyo̱ Jnaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jeeⁿ wiꞌ tsꞌom Jesús Marta ñequio tyjee tsaⁿꞌñeeⁿ ñequio nquii Lázaro. ");
INSERT INTO amuNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Jnda̱ na jñeeⁿ na wiiꞌ Lázaroꞌñeeⁿ, ljooꞌñetyeeⁿ we xuee joꞌ joꞌ yuu na mꞌaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Jnda̱ teinom we xueeꞌñeeⁿ, jâ nnꞌaⁿ na tꞌmaaⁿ na calajomndyô̱ ñꞌeⁿñê tsꞌiaaⁿ na machꞌeeⁿ, matsoom nda̱a̱yâ: —Tsaanndaaꞌa Judea. ");
INSERT INTO amuNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Joꞌ chii lꞌuuyâ nnoom: —ꞌU ta na maꞌmo̱o̱ⁿꞌ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom nda̱a̱yâ, tyoowijndye xuee na jlaꞌjndaaꞌndye nnꞌaⁿ judíos na njñomna ljo̱ꞌ ꞌu, ndoꞌ ¿aa joꞌ wjaꞌnndaꞌ? ");
INSERT INTO amuNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Tꞌo̱ Jesús nda̱a̱yâ, matsoom: —Ndicwaⁿ waa xjeⁿ na nntsꞌaatya̱ tsꞌiaaⁿ cwii tjo̱o̱cheⁿ na nntꞌue nnꞌaⁿ judíos ja. Ndoꞌ na luaaꞌ waa matseijomnaꞌ chaꞌcwijom na cwii xuee na canda̱a̱ꞌya canchooꞌwe horas na nntsꞌaa tsꞌaⁿ tsꞌiaaⁿ. Quia naxuee manom tsꞌaⁿ, xocwityꞌueeⁿ, ee ya tquioomꞌm ncꞌe na mantyꞌiaaꞌ ñeꞌquioomꞌ tsjoomnancuewaañe. ");
INSERT INTO amuNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Sa̱a̱ tixocanda̱a̱ nntsꞌaa tsꞌaⁿ tsꞌiaaⁿ natsjom. Xeⁿ nntsꞌaaⁿ na ljoꞌ nncwityꞌueeⁿ, ee tjaaꞌnaⁿ naxuee cꞌoom ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jnda̱ tsoom na luaaꞌ nda̱a̱yâ, tsotyeeⁿcheⁿ: —Juu tiꞌxꞌiaaya Lázaro watsom, sa̱a̱ jo̱ na nntseilcwiya jom. ");
INSERT INTO amuNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Quia joꞌ tꞌo̱o̱yâ, lꞌuuyâ: —Jeeⁿ ꞌu Ta, xeⁿ na cweꞌ watsom, maxjeⁿ nlcoꞌyanaꞌ jom. ");
INSERT INTO amuNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Seineiⁿ Jesús ñꞌoomwaaꞌ ee na mꞌaaⁿ tsꞌooñe Lázaro, sa̱a̱ jâ jlatiuuyâ na maꞌmo̱o̱ⁿ na watsoo tsaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Quia joꞌ tsondyeyoom nda̱a̱yâ: —Jnda̱ tueꞌ Lázaro. ");
INSERT INTO amuNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Ndoꞌ neiⁿya na ticꞌo̱o̱ⁿya joꞌ joꞌ quia na tueeⁿꞌeⁿ cha na nlayuꞌyoꞌ. Jeꞌ cjaaya na mꞌaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomás, tsaⁿ na cwilacajndyuuyâ catyeⁿnquiee, juu cwii jâ nnꞌaⁿ na canchooꞌwendyô̱ na tꞌmaⁿ Jesús na calajomndyô̱ ñꞌeⁿñê, matso tiꞌñeeⁿ nda̱a̱yâ: —Mati cjaaya cha mañejom cwja̱a̱ya ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Quia joꞌ saayâ, squia̱a̱yâ Betania. Jnda̱ na squia̱a̱yâ joꞌ joꞌ tyolue nnꞌaⁿ nnom Jesús na jnda̱ ñequiee xuee na ndiiꞌ Lázaro tseiꞌtsuaa. ");
INSERT INTO amuNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Tsjoomꞌñeeⁿ chaꞌna we kilómetros waljooꞌ xcwe na tquia mꞌaaⁿnaꞌ ñꞌeⁿ Jerusalén. ");
INSERT INTO amuNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Ndoꞌ majndye nnꞌaⁿ judíos jnda̱ tquieꞌcañom Marta ñequio María. Tquiolaꞌjomndyena na cwiñeꞌquiana na tꞌmaⁿ nꞌom naⁿꞌñeeⁿ na tueꞌ Lázaro. ");
INSERT INTO amuNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jnda̱ na jndii Marta na jnda̱ wjaawindyo̱o̱ꞌâ ñꞌeⁿ Jesús, jlueeⁿꞌeⁿ na jndyocatjomñê juu yuu na mꞌaaⁿyâ. Sa̱a̱ María ljooꞌñê na waa wꞌaa. ");
INSERT INTO amuNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Matso Marta nnom Jesús: —ꞌU Ta, toom cweꞌ mꞌaaⁿꞌ ñjaaⁿ, tîcueꞌ ñetyjo̱. ");
INSERT INTO amuNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Sa̱a̱ meiiⁿ na jnda̱ tueeⁿꞌeⁿ ntyjiiyaya na meiⁿcwiꞌñeeⁿcheⁿ ñꞌoom na nlcaⁿꞌ nnom Tyꞌo̱o̱tsꞌom, nñequiaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Tꞌo̱ Jesús, matsoom nnom: —Ncwandoꞌnndaꞌ tiꞌtyꞌiuꞌ meiiⁿ na jnda̱ tueeⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Tꞌo̱ Marta nnoom, matso: —Ntyjiiya na nncwandoꞌnndaꞌ ñetyjo̱ xuee na macanda̱ quia na nntseinlcwi Tyꞌo̱o̱tsꞌom nnꞌaⁿ na jnda̱ tja̱. ");
INSERT INTO amuNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Matso Jesús nnom: —Ja cwiluiindyo̱ na mañequia na cwitaꞌndoꞌxco nnꞌaⁿ, ndoꞌ ja mañequia na ticantycwii na mawandoꞌ tsꞌaⁿ. ꞌÑeeⁿ juu na matseiyuꞌ ñꞌeⁿndyo̱, meiiⁿ na cueꞌ, maxjeⁿ nncwandoꞌxco. ");
INSERT INTO amuNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ndoꞌ ticwii cwii tsꞌaⁿ na matseiyuꞌ ñꞌeⁿndyo̱, ticantycwii na nncwandoꞌ, ndoꞌ meiⁿ tijoom nntsuuñe. ¿Aa matseiyuꞌ na ljoꞌ? ");
INSERT INTO amuNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Matsoom nnom Jesús: —Mayuuꞌ Ta, matseiyuꞌa na ꞌu cwiluiindyuꞌ Cristo, Jnda Tyꞌo̱o̱tsꞌom. Maꞌu joꞌ na tseixmaⁿꞌ na nncwjeꞌcañoomꞌ tsjoomnancue. ");
INSERT INTO amuNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Jnda̱ na tso Marta na luaaꞌ, quia joꞌ tjaaⁿ, tjacwaaⁿ tyjeeⁿ María. Ñemaaⁿꞌ matsoom nnom tsaⁿꞌñeeⁿ: —Jnda̱ tyjeeꞌ nquii Maestro ndoꞌ maqueeⁿꞌñê ꞌu. ");
INSERT INTO amuNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Quia na jndii María na ljoꞌ, seityuaaⁿꞌaⁿ, jndyocatjomñê Jesús yuu na mꞌaaⁿyâ. ");
INSERT INTO amuNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ee xjeⁿꞌñeeⁿ tyootsaaquia̱a̱ꞌâ quiiꞌ tsjoom ñꞌeⁿ Jesús. Ndi mꞌaaⁿyâ ñꞌeⁿñê yuu na tjacatjomñe Marta jâ. ");
INSERT INTO amuNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ndoꞌ joo nnꞌaⁿ judíos na cwilaꞌjomndye ñꞌeⁿ María na cwiñeꞌquia na tꞌmaⁿ tsꞌoom, quia ntyꞌiaana na seityuaaⁿꞌaⁿ, teicantyjaaⁿ, jlueeⁿꞌeⁿ quiiꞌ wꞌaa, tyꞌentyjo̱na naxeeⁿꞌeⁿ. Ee jlaꞌtiuuna na wjaacatyꞌioom yuu waa tseiꞌtsuaa. ");
INSERT INTO amuNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Quia na tueⁿꞌeⁿ na mꞌaaⁿyâ ñꞌeⁿ Jesús, tcoomꞌm xtyeeⁿ jo ncꞌee. Matsoom nnom: —Jeeⁿ ꞌu Ta, toom cweꞌ mꞌaaⁿꞌ ñjaaⁿñe, quia joꞌ tîcueꞌ ñetyjo̱. ");
INSERT INTO amuNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ntyꞌiaaꞌ Jesús na jeeⁿ matyꞌioo María, ndoꞌ jeeⁿ cwityuee nnꞌaⁿ judíos na tquiontyjo̱ naxeeⁿꞌeⁿ. Quia joꞌ jeeⁿ seichjooꞌnaꞌ tsꞌom Jesús, ndoꞌ seiꞌndaaꞌna ntyjeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Taxꞌeeⁿ nda̱a̱na, matsoom: —¿Yuu cwijom tyꞌiuꞌyoꞌ jom? Jluena nnoom: —Ta, candyoꞌ cantyꞌiaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ndoꞌ Jesús tyꞌioom. ");
INSERT INTO amuNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Quia joꞌ joo nnꞌaⁿ judíos jlue: —Queⁿꞌyoꞌ cwenta na jeeⁿ wiꞌ tsꞌoom tiꞌtsꞌoo. ");
INSERT INTO amuNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Sa̱a̱ cwantindye joona jluena: —Tsaⁿsꞌamꞌaaⁿꞌ sꞌaaⁿ na ya ntyꞌiaaꞌ tsaⁿnchjaaⁿꞌ. ¿Aa nchii mati nnda̱a̱ nntsꞌaaⁿ na tîcueꞌ Lázaro? ");
INSERT INTO amuNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Seiꞌndaaꞌnndaꞌnaꞌ ntyjii Jesús. Saayâ ñꞌeⁿñê yuu na waa tsueꞌtsjo̱ꞌ na tuii tseiꞌtsuaa juunaꞌ. Cwita̱ꞌ tsjo̱ꞌ ꞌndyootsꞌaaꞌnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Tso Jesús nda̱a̱na: —Quindyo̱ꞌyoꞌ tsjo̱ꞌwaa. Juu Marta, xjo tsꞌoo, matsoom: —Jeeⁿ ꞌu Ta, jeꞌ jnda̱ teicꞌeeñê ee jnda̱ jnda̱a̱ꞌ ñequiee xuee na tueeⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Matso Jesús nnom: —¿Aa nchii jnda̱ tsjo̱o̱ njomꞌ, xeⁿ nntseiyuꞌ nntyꞌiaꞌnjomꞌ na nntseitꞌmaaⁿꞌñenaꞌ Tyꞌo̱o̱tsꞌom? ");
INSERT INTO amuNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Quia ljoꞌcheⁿ teiꞌndyo̱o̱na tsjo̱ꞌ yuu na tjaaꞌndyena tsꞌoo. Ndoꞌ jlunda̱a̱ñê, matsoom: —Jeeⁿ quianlꞌuaꞌ ꞌu Tsotya̱ya na mandiꞌ ñꞌoom ꞌndyo̱ya. ");
INSERT INTO amuNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ee mantyjiiya na ñequiiꞌcheⁿ mandiꞌ ñꞌoom na matseina̱ⁿya njomꞌ. Sa̱a̱ cweꞌ ncꞌe nnꞌaⁿ na jndyendye na mꞌaⁿna na cañomya joꞌ chii tsjo̱o̱ya ñꞌoomwaaꞌ cha calaꞌyuꞌna na ꞌu jñomꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Ndoꞌ quia na jnda̱ tsoom na luaaꞌ, seiweeⁿ jñeeⁿꞌeⁿ, tsoom: —Lázaro, caluiꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ndoꞌ juu tsꞌoo Lázaro, jlueeⁿꞌeⁿ na chuꞌtyjoo liaa na tintmeiⁿ ncꞌeeⁿ ndoꞌ lꞌo̱o̱ⁿ. Ndoꞌ ta̱ꞌ nnoom payom. Matso Jesús nda̱a̱ naⁿꞌñeeⁿ: —Calacano̱ⁿꞌyoꞌ liaameiⁿꞌ cha nnda̱a̱ nncjaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ndoꞌ majndye nnꞌaⁿ judíosꞌñeeⁿ quia na ntyꞌiaana na luaaꞌ sꞌaa Jesús, jlaꞌyuꞌna ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Sa̱a̱ ntꞌomndye joona tyꞌentyjaaꞌna nnꞌaⁿ fariseos. Tyoluena chiuu ntyꞌiaana na sꞌaa Jesús. ");
INSERT INTO amuNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Joꞌ chii tjomndye nquiee ntyee na cwiluiitquiendye ñequio nnꞌaⁿ fariseos ñequio ntꞌomcheⁿ ncꞌiaana na mꞌaⁿ nꞌiaaⁿ. Tyoluena nda̱a̱ ncꞌiaana: —¿Chiuu nlꞌaayo̱o̱? Ee teijndye tsꞌiaaⁿ tꞌmaⁿ machꞌee tsaⁿmꞌaaⁿꞌ na tixocaluii na cweꞌ tsꞌaⁿ nntsꞌaa. ");
INSERT INTO amuNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ndoꞌ xeⁿ cweꞌ nꞌndya̱a̱to̱o̱ na ncjaachꞌeetyeeⁿ na luaaꞌ, quia joꞌ chaꞌtso nnꞌaⁿ nlaꞌyuꞌ ñꞌeⁿñê. Ndoꞌ na ljoꞌ nquiee naⁿmaⁿnꞌiaaⁿ nnꞌaⁿ romanos nlaꞌtyuiiꞌna watsꞌom ꞌnaaⁿ jaa nnꞌaⁿ judíos ñequio ndaandyuaa ꞌnaaⁿya. ");
INSERT INTO amuNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Caifás jndyu cwiindye joo naⁿꞌñeeⁿ na luaaꞌ tso. Juu cwiluiitquieñê chuꞌñeeⁿ nda̱a̱ ntyee cwentaa jaa nnꞌaⁿ judíos. Matsoom nda̱a̱ naⁿꞌñeeⁿ: —ꞌO meiⁿchjoo ticalaꞌno̱ⁿꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Meiⁿ ticaliuꞌyoꞌ na yati xeⁿ na cueꞌ cwii tsaⁿsꞌa cwentaa chaꞌtsondye nnꞌaⁿ ndyuaaya, cha tintsꞌaa gobiernom na cwja̱a̱ya na chaꞌtsondyo̱. ");
INSERT INTO amuNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Sa̱a̱ nchii cantyja na jndo̱ꞌ tsꞌom nqueⁿ na luaaꞌ ñꞌoom tjeiiⁿꞌeⁿ. Jom ncꞌe na cwiluiiñê tyee na cwiluiitꞌmaⁿñê nda̱a̱ jaa nnꞌaⁿ judíos chuꞌñeeⁿ, joꞌ chii seijndo̱ꞌ Tyꞌo̱o̱tsꞌom tsꞌoom na nncueꞌ Jesús cwentaa nnꞌaⁿ judíos. ");
INSERT INTO amuNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ndoꞌ nchii macanda̱ cweꞌ cantyja ꞌnaaⁿ nnꞌaⁿ judíos, mati nntjoom na ljoꞌ cha chaꞌtsondye nnꞌaⁿ na meiⁿquiayuucheⁿ na mꞌaⁿ na quitꞌmaⁿ nꞌom jom nntseitjom Tyꞌo̱o̱tsꞌom joona cantyja ꞌnaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Joꞌ chii ncꞌe na luaaꞌ tso Caifás, cantyjati xueeꞌñeeⁿ jnaⁿnaꞌ na jlaꞌjomndye naⁿmaⁿnꞌiaaⁿꞌñeeⁿ na nlaꞌcueeꞌna Jesús. ");
INSERT INTO amuNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Cweꞌ ncꞌe joꞌ, tîconom xcweyaaⁿ quiiꞌntaaⁿ nnꞌaⁿ judíos. Joꞌ chii jluiiꞌâ tsꞌo̱ndaa Judea ñꞌeⁿñê, saayâ cwii tsjoom chjoo na jndyu Efraín. Tsjoomꞌñeeⁿ candyooꞌ mꞌaaⁿnaꞌ ñequio ndyuaa na tjaa nnꞌaⁿ cꞌoom. Tꞌo̱o̱ⁿyâ ñꞌeⁿñê joꞌ joꞌ cwantindyo xuee. ");
INSERT INTO amuNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ndoꞌ jnda̱ jaawindyooꞌ na nncueeꞌ xuee pascua na jaa nnꞌaⁿ judíos cwilacwja̱a̱ya canmaⁿ. Cwii tjo̱o̱cheⁿ na nncueeꞌ xuee pascuaꞌñeeⁿ, jndyendye nnꞌaⁿ jluiꞌna njoomna, tyꞌena Jerusalén cha nnda̱a̱ nntjeiꞌljuuꞌndyena cantyja ꞌnaaⁿꞌ ñꞌoom na cwilaꞌtꞌmaaⁿꞌndyo̱ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Joo nnꞌaⁿ na tyꞌe xuee tyolꞌueena Jesús. Yocheⁿ na tyomꞌaⁿna watsꞌom, tyoluena nda̱a̱ ncꞌiaana: —¿Chiuu mꞌaaⁿꞌ nꞌomꞌyoꞌ, aa nntsꞌaacheⁿnaꞌ na ticañoom ncuee? ");
INSERT INTO amuNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ntyee na cwiluiitquiendye nda̱a̱ jaa nnꞌaⁿ judíos ñequio nnꞌaⁿ tmaaⁿꞌ fariseos tqueⁿna ñꞌoom na jndeiꞌnaꞌ. Sa̱ꞌntjomna xeⁿ mꞌaaⁿ meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na ntyjii yuu mꞌaaⁿ Jesús, catseicandii tsaⁿꞌñeeⁿ joona, cha na nnda̱a̱ nntꞌuena jom. ");
INSERT INTO amuNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Yom xuee cwii tjo̱o̱ na nlaꞌtyeⁿ nnꞌaⁿ judíos xuee pascua quia cwilaꞌcwjeena canmaⁿ, ndoꞌ squia̱a̱yâ tsjoom Betania ñꞌeⁿ Jesús. Squia̱a̱yâ na mꞌaaⁿ Lázaro, tsaⁿ na tquiaaⁿ na wandoꞌ xco jnda̱ na tueꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Tyolaꞌtꞌmaaⁿꞌndyena Jesús joꞌ joꞌ. Jlaꞌjndaaꞌndyena cwii nantquie na tcwaaꞌâ. Marta tyondiꞌntjoom nda̱a̱yâ ndoꞌ juu Lázaroꞌñeeⁿ tacatyeeⁿ ñꞌeⁿndyô̱ na meindyuaandyô̱ nacañoomꞌ meiⁿsa ñꞌeⁿ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ndoꞌ juu María maleiñꞌoom cwii tsuaꞌ xjo ncheⁿꞌ na ñequiiꞌcheⁿ nardo. Juunaꞌ jeeⁿ jndanaꞌ. Tuꞌnquioom ncheⁿꞌñeeⁿ ncꞌee Jesús, jnda̱ joꞌ tyoweeꞌñê ncꞌee ñequio sooxqueeⁿ. Na sꞌaaⁿ na ljoꞌ tjuꞌnaꞌ jndye cachi chaꞌwaa quiiꞌ wꞌaa. ");
INSERT INTO amuNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Mañꞌeⁿ Judas Iscariote, jnda Simón, juu mawaa xjeⁿ na nñequiaa cwenta Jesús. Tsaⁿꞌñeeⁿ cwii jâ na tꞌmaⁿ Jesús na calajomndyô̱ ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Matso: —Cwa nchii na teilꞌua ncheⁿꞌwaaꞌ na cwii ndyee siaⁿnto sꞌom denario. Ñequio sꞌomꞌñeeⁿ nnda̱a̱ nnteijndeii tsꞌaⁿ ndyeñeeⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Sa̱a̱ nchii tsoom na luaaꞌ ncꞌe na jeeⁿ wiꞌ tsꞌoom ndyeñeeⁿꞌ sa̱a̱ ee na jeeⁿ canchꞌueñe ndoꞌ ncꞌe na jom maleiñꞌoom tjaⁿche na ñjom sꞌom na cwileilꞌueeꞌndyô̱ na chaꞌtsondyô̱, ndoꞌ xjeⁿto jom macwjeeⁿꞌeⁿ sꞌom joꞌ joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Sa̱a̱ matso Jesús: —Caꞌndiiꞌ yuscumꞌaaⁿꞌ na luaaꞌ machꞌeeⁿ. Matseijndaaꞌñê cantyja ꞌnaaⁿꞌ xuee na nncjaantyꞌiuuꞌndyo̱. ");
INSERT INTO amuNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ee ndyeñeeⁿꞌ ñequiiꞌcheⁿ na mꞌaⁿna ñꞌeⁿndyoꞌ, sa̱a̱ ja nchii ñequiiꞌcheⁿ na nncꞌo̱o̱ⁿya ñꞌeⁿndyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Joꞌ chii quia na jndye nnꞌaⁿ na jndyendye na joꞌ joꞌ mꞌaaⁿ Jesús, tquieꞌcañomna na mꞌaaⁿyâ. Ee nchii macanda̱ ncꞌe na ñeꞌcantyꞌiaana Jesús, sa̱a̱ mati ñeꞌcantyꞌiaana Lázaro, tsꞌaⁿ na tueꞌ na tquiaa Jesús na tandoꞌxco. ");
INSERT INTO amuNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Cweꞌ ncꞌe joꞌ, ntyee na cwiluiitquiendye nda̱a̱ nnꞌaⁿ judíos, mati jlaꞌjndaaꞌndyena na nlaꞌcueeꞌna Lázaro. ");
INSERT INTO amuNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ee cweꞌ cantyja ꞌnaaⁿꞌ jom majndye nnꞌaⁿ judíosꞌñeeⁿ to̱ⁿꞌndye cantyja ꞌnaaⁿ ntyee, jlaꞌyuꞌna ñꞌeⁿ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Teincoo cwiicheⁿ xuee nnꞌaⁿ na jndyendye na tquio ncuee, jndyena na manndyooꞌ na nntsquia̱a̱yâ Jerusalén ñꞌeⁿ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Joꞌ chii tyꞌechona njom, tyꞌecatjomndyena jâ ñꞌeⁿñê. Tyolaꞌxuaana tyoluena: —Caluiitꞌmaⁿñe Tyꞌo̱o̱tsꞌom. Catioꞌnaaⁿñê nquii tsꞌaⁿ na mandyo ñequio xueeꞌ nquii na cwiluiiñe Rey cwentaa jaa nnꞌaⁿ Israel. ");
INSERT INTO amuNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ndoꞌ ljeii Jesús cwii snom chjoo. Tjaljoom juuyoꞌ. Ndoꞌ na ljoꞌ sꞌaaⁿ seicanda̱a̱ꞌñenaꞌ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na teiyo teiljeii. ");
INSERT INTO amuNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Matsonaꞌ: ꞌO nnꞌaⁿ tsjoom Jerusalén, tilaꞌcatyuendyoꞌ. Cantyꞌiaꞌyoꞌ macwjeeꞌcañoom nqueⁿ na cwiluiiñê Rey cwentaꞌ ꞌo, na waljoom snom. ");
INSERT INTO amuNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Jâ nnꞌaⁿ na tꞌmaⁿ Jesús na calaꞌjomndyô̱ ñꞌeⁿñê tîcalaꞌno̱o̱ⁿꞌâ ñꞌoommeiⁿꞌ najndyee. Sa̱a̱ nda̱nquia quia na jnda̱ seitꞌmaaⁿꞌñe Tyꞌo̱o̱tsꞌom jom, tjañjoomꞌ nꞌo̱o̱ⁿyâ na teiljeii ñꞌoommeiⁿꞌ cantyja ꞌnaaⁿꞌaⁿ, ndoꞌ maxjeⁿ tuii na ljoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Mꞌaⁿ cwii tmaaⁿꞌ nnꞌaⁿ judíos quia tꞌmaⁿ Jesús Lázaro na ñejndiiꞌ quiiꞌ tseiꞌtsuaa. Jnda̱ na tquiaaⁿ na wandoꞌxco Lázaroꞌñeeⁿ, quia joꞌ tyotjeiiꞌyuuꞌndye naⁿꞌñeeⁿ chiuu ntyꞌiaana na tuii. ");
INSERT INTO amuNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Macweꞌ juu tsꞌiaaⁿꞌñeeⁿ na sꞌaa Jesús na tixocanda̱a̱ nluii na cweꞌ tsꞌaⁿ nntsꞌaa, joꞌ na tyꞌecatjomndye nnꞌaⁿ na jndyendye jom quia jnda̱ jndyena na ljoꞌ sꞌaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Sa̱a̱ joo fariseosꞌñeeⁿ tyoluena nda̱a̱ ncꞌiaana: —¿Aa jndoꞌyoꞌ jeꞌ? Maxjeⁿ tjaa na nnda̱a̱ nlꞌaaya. Chaꞌtsondye nnꞌaⁿ cwilajomndye ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ndoꞌ tyomꞌaⁿ cwantindye nnꞌaⁿ na cwilaꞌneiⁿ ñꞌoom griego quiiꞌntaaⁿ nnꞌaⁿ na tyꞌe ncuee quia cwilaꞌcwjee nnꞌaⁿ judíos canmaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Tquieꞌcañom naⁿꞌñeeⁿ Felipe. Jom tsꞌaⁿ tsjoom Betsaida, tsꞌo̱ndaa Galilea. Nnꞌaⁿ griegosꞌñeeⁿ tyꞌecataⁿna cwii nayaꞌñeeⁿ nnoom, jluena: —Aa re sa, lꞌue nꞌo̱o̱ⁿyâ na nlana̱a̱ⁿyâ ñꞌeⁿ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Quia joꞌ tja Felipe, matsoom na ljoꞌ nnom Andrés, ndoꞌ wendye joona tyꞌecaluena na ljoꞌ nnom Jesús. ");
INSERT INTO amuNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Tso Jesús nda̱a̱na: —Ja cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee. Jnda̱ tueꞌntyjo̱ xjeⁿ na tꞌmaⁿ nlcoꞌwiꞌnaꞌ ja, ndoꞌ cantyja ꞌnaaⁿꞌ joꞌ Tyꞌo̱o̱tsꞌom nntseitꞌmaaⁿꞌñê ja. ");
INSERT INTO amuNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Ñꞌoom na mayuuꞌcheⁿ matsjo̱o̱ya nda̱a̱ꞌyoꞌ, cwii lqueeⁿ na cwiquioo, xeⁿ ticjaaquieeꞌnaꞌ quiiꞌ tsꞌo yuu na nntseijomnaꞌ chaꞌcwijom na nncueꞌnaꞌ, cwiljonaꞌ na ñenquiinaꞌ. Sa̱a̱ xeⁿ nnomꞌ tsꞌaⁿ juunaꞌ quiiꞌ tsꞌo yuu na matseijomnaꞌ na nncueꞌnaꞌ, quia joꞌ majndye nncueꞌ nntsꞌaanaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ꞌÑeeⁿ juu na matseicandyaꞌ tsꞌom cantyja na matseijndaaꞌñe nquii na nncwandoꞌ, jnaaⁿꞌ joꞌ nntsuuñe. Sa̱a̱ juu tsꞌaⁿ na machꞌee na jndooꞌ cantyja na wjaamꞌaaⁿ, nndaaꞌ tsaⁿꞌñeeⁿ na ticantycwii na nncwanoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ꞌÑeeⁿ juu tsꞌaⁿ na ñeꞌcandiꞌntjom no̱o̱ⁿ, candyontyjo̱o̱ⁿ naxa̱ⁿꞌa. Ndoꞌ yuu na nncꞌo̱o̱ⁿya majoꞌ joꞌ nncꞌoom tsꞌaⁿ na mandiꞌntjom no̱o̱ⁿ. Ndoꞌ ꞌñeeⁿ juu tsꞌaⁿ na nndiꞌntjom no̱o̱ⁿ nntseitꞌmaaⁿꞌñe Tsotya̱ya tsaⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","’Jeꞌ mamatseiꞌndaaꞌnaꞌ tsꞌo̱o̱ⁿ, ndoꞌ ¿chiuu nntsjo̱o̱ cantyja ꞌnaaⁿꞌ joꞌ? ¿Aa nntsjo̱o̱: “Tsotya̱ya, cwjiꞌnꞌmaaⁿndyuꞌ ja juu xjeⁿ na nntjo̱ⁿya nawiꞌwaañe”? Sa̱a̱ xocatsjo̱o̱ na ljoꞌ ee jnda̱ jndyo̱o̱ cha na nncꞌio̱ cwentaa nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ꞌU Tsotya̱ya, quiaaꞌ na catseitꞌmaaⁿꞌñenaꞌ ꞌu. Xjeⁿꞌñeeⁿ teicꞌuaa jndyeeꞌ Tsotyeeⁿ cañoomꞌluee. Tꞌo̱: —Jnda̱ tquia na matseitꞌmaaⁿꞌñenaꞌ ja ndoꞌ wjaatseitꞌmaaⁿꞌñetinaꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Nnꞌaⁿ na jndyendye na meintyjeeꞌ nacañoomyâ joꞌ joꞌ, jndyena na ljoꞌ. Jluena nda̱a̱ ntyjeena na seixuaa tsuee. Sa̱a̱ ntꞌom nnꞌaⁿ jlue: —Cwii ángel seineiⁿ nnoom. ");
INSERT INTO amuNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Tso Jesús nda̱a̱na: —Jndyeꞌyoꞌ na teicꞌuaa na seineiiⁿ cha cateijndeiinaꞌ ꞌo, nchii cha cateijndeiinaꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ee jnda̱ tueꞌntyjo̱ xjeⁿ na nncuꞌxeⁿnaꞌ nnꞌaⁿ tsjoomnancue. Ndoꞌ mati nntyuiiꞌ na matseixmaⁿ tsaⁿjndii na matsa̱ꞌntjom quiiꞌ nꞌom nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ndoꞌ quia na jnda̱ jlaꞌwe nnꞌaⁿ ja na nlaꞌcueeꞌna ja, quia joꞌ nntsꞌaa na nntseitjomnaꞌ nnꞌaⁿ cantyja ꞌnaⁿya. ");
INSERT INTO amuNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ñꞌoomwaaꞌ matsoom cha caꞌmo̱ⁿnaꞌ cwaaⁿ cwii nnom na nntjoom na nncueeⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Tꞌo̱o̱ nnꞌaⁿ na jndyendye, jluena: —Majnda̱ macwindya̱a̱ya na matso ñꞌoom na sa̱ꞌntjom Tyꞌo̱o̱tsꞌom na teiljeiinaꞌ na juu Cristo xocantycwii na mꞌaaⁿñê. Quia joꞌ ¿chiuu na matsuꞌ na matsonaꞌ na nlaꞌwe nnꞌaⁿ juu na cwiluiiñe tsꞌaⁿ na jnaⁿ cañoomꞌluee na nlaꞌcueeꞌna juu? ¿ꞌÑeeⁿ juu luaaꞌ na matsuꞌ na cwiluiiñe tsꞌaⁿ na jnaⁿ cañoomꞌluee? ");
INSERT INTO amuNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Quia joꞌ matso Jesús nda̱a̱na: —Ja na cwiluiindyo̱ naxuee quiiꞌntaaⁿ nnꞌaⁿ ndicwaⁿ mꞌaaⁿtya̱ya quiiꞌntaaⁿꞌyoꞌ. Joꞌ chii ñequiiꞌcheⁿ cꞌomꞌyoꞌ cantyja ꞌnaⁿya yocheⁿ na cwii mꞌaaⁿtya̱ya ñꞌeⁿndyoꞌ, cha tincwinomꞌ natia ꞌo. Ee tsꞌaⁿ na mꞌaaⁿñe nacje ꞌnaaⁿꞌ natia, ticaljeii yuu wjaañꞌoomnaꞌ juu. ");
INSERT INTO amuNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Yocheⁿ na mꞌaaⁿya na mañequia naxuee quiiꞌ nꞌomꞌyoꞌ, calayuꞌyoꞌ ñequiondyo̱ ja na cwiluiindyo̱ naxueeñe. Ee na nlꞌaꞌyoꞌ na ljoꞌ nlaxmaⁿꞌyoꞌ cantyja ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom na nqueⁿ cwiluiiñê naxueeñe. Jnda̱ na seineiⁿ Jesús ñꞌoommeiⁿꞌ, tjaaⁿ yuu na xocaliu naⁿꞌñeeⁿ jom. ");
INSERT INTO amuNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Meiiⁿ jndye tsꞌiaaⁿ na tyochꞌeeⁿ jo nda̱a̱na na tixocaluii na cweꞌ tsꞌaⁿ nntsꞌaa, sa̱a̱ tiñeꞌcalaꞌyuꞌna ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Luaaꞌ tuii cha catseicanda̱a̱ꞌñenaꞌ ñꞌoom na tyotseiljeii profeta Isaías, matso: Ta, ¿ꞌñeeⁿ juu na matseiyuꞌ ñꞌoom na cwiñeꞌquiaayâ? Ndoꞌ tsotyeeⁿ cwiicheⁿ ñꞌoom: ¿ꞌÑeeⁿ juu na jnda̱ tꞌmo̱ⁿ Tyꞌo̱o̱tsꞌom nnom najndeii na matseixmaaⁿ? ");
INSERT INTO amuNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Tꞌmo̱ⁿ Isaías chiuu waa na tileicanda̱a̱ nlaꞌyuꞌ nnꞌaⁿ judíos, ee waa cwiicheⁿ ñꞌoom na matsoom: ");
INSERT INTO amuNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Chaꞌxjeⁿ tileicantyꞌiaaꞌ tsꞌaⁿ na nchjaaⁿꞌ, maluaaꞌ sꞌaa Tyꞌo̱o̱tsꞌom quiiꞌ nꞌomna, ndoꞌ tquiaaⁿ na jlaꞌquieꞌ nꞌomna jo nnoom. Nmeiiⁿꞌ tuii cha tixocaliuna chiuu lꞌue tsꞌoom ñꞌeⁿndyena, meiⁿ na nlaꞌno̱ⁿꞌna quiiꞌ nꞌomna. Ee xeⁿ nncꞌooliuna chiuu lꞌue tsꞌoom ndoꞌ nlaꞌno̱ⁿꞌna, maxjeⁿ nlcweꞌ nꞌomna ndoꞌ nncwjiꞌnꞌmaaⁿñê joona. ");
INSERT INTO amuNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Seineiⁿ Isaías ñꞌoommeiⁿꞌ quia na tcoꞌnaꞌ nnoom na seitꞌmaaⁿꞌñe Tyꞌo̱o̱tsꞌom Jesús, ndoꞌ seineiiⁿ cantyja ꞌnaaⁿꞌ juu. ");
INSERT INTO amuNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Sa̱a̱ meiiⁿ na luaaꞌ tso Isaías, majndyendye nnꞌaⁿ na mꞌaⁿ nꞌiaaⁿ jo nda̱a̱ nnꞌaⁿ judíos, tyolaꞌyuꞌna ñꞌeⁿ Jesús. Sa̱a̱ jnaaⁿꞌ na nquiaana nnꞌaⁿ tmaaⁿꞌ fariseos, joꞌ chii ticatjeiꞌyuuꞌndyena na ljoꞌ. Ee xeⁿ nlꞌana na ljoꞌ tixonquia fariseosꞌñeeⁿ na wanaaⁿ na nlaꞌjomndyena xjeⁿ na cwiꞌoona watsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ee joona neiiⁿtina na calue ncꞌiaana na ya cwilꞌana, nchiiti na ntyjaaꞌ nꞌomna na catso Tyꞌo̱o̱tsꞌom na ya ntyjeeⁿ ñꞌeⁿndyena. ");
INSERT INTO amuNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jndeii seineiⁿ Jesús. Matsoom: —ꞌÑeeⁿ juu na matseiyuꞌ ñꞌeⁿndyo̱, nchii macanda̱ ñequio ja matseiyuꞌ tsaⁿꞌñeeⁿ. Mati matseiyuꞌ ñequio nquii Tsotya̱ na jñom ja quiiꞌntaaⁿꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ndoꞌ ꞌñeeⁿ juu na mantyꞌiaaꞌ ja, mati mantyꞌiaaꞌ tsaⁿꞌñeeⁿ nquii na jñom ja quiiꞌntaaⁿꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ja na cwiluiindyo̱ naxuee, jndyo̱o̱ tsjoomnancue, cha meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na matseiyuꞌ ñꞌeⁿndyo̱ nncwjiꞌnaꞌ juu naquiiꞌ natia. ");
INSERT INTO amuNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Sa̱a̱ xeⁿ cweꞌ na mandii tsꞌaⁿ ñꞌoom na mañequiaya, meiⁿ ticatseinda̱ joonaꞌ, nchii ja tseixmaⁿya na nncuꞌxa̱ⁿ tsaⁿꞌñeeⁿ. Ee nchii tyꞌiom Tsotya̱ tsꞌiaaⁿ ja na nncuꞌxa̱ⁿya nnꞌaⁿ, tyꞌioom tsꞌiaaⁿ ja na cwjiꞌnꞌmaaⁿndyo̱ joona. ");
INSERT INTO amuNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ꞌÑeeⁿ juu na ticueeꞌ tsꞌom ja, meiⁿ ticoꞌñom ñꞌoom na mañequiaya, waa cwii na nncuꞌxeⁿnaꞌ tsaⁿꞌñeeⁿ. Ee xuee na macanda̱ majooti ñꞌoom na jnda̱ seina̱ⁿya, joonaꞌ nntuꞌxeⁿnaꞌ jom. ");
INSERT INTO amuNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ticalatiuuꞌyoꞌ na cweꞌ na jndeiiꞌ ꞌndyo̱ nnco̱ ñꞌoommeiⁿꞌ na matseina̱ⁿ. Nquii Tsotya̱ na jñom ja, nqueⁿ sa̱ꞌntjoom na nmeiiⁿꞌ catseina̱ⁿya ndoꞌ na caꞌmo̱o̱ⁿya joonaꞌ nda̱a̱ꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ndoꞌ ntyjiiya ñꞌoom na matsa̱ꞌntjoom mañequiaanaꞌ na nntseixmaⁿ tsꞌaⁿ na ticantycwii na wandoꞌ. Joꞌ chii matseina̱ⁿya chaꞌxjeⁿ ñꞌoom na jnda̱ tsoom no̱o̱ⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Cantyjati na jnaⁿnaꞌ na tꞌmaⁿ Jesús jâ na cwilajomndyô̱ ñꞌeⁿñê, tꞌmo̱o̱ⁿ na jeeⁿ candyaꞌ tsꞌoom jâ. Ntyjeeⁿ na jnda̱ jaaweꞌntyjo̱ xjeⁿ na nlueeⁿꞌeⁿ tsjoomnancuewaañe na nncjaalcweꞌnnaaⁿꞌaⁿ na mꞌaaⁿ Tsotyeeⁿ. Joꞌ chii quia majaaweꞌntyjo̱ xjeⁿ na nlatya̱a̱ⁿ jaa nnꞌaⁿ judíos xuee pascua quia cwilacwja̱a̱ya canmaⁿ, tꞌmo̱ⁿtyeeⁿ na jeeⁿ tꞌmaⁿ waa na candyaꞌ tsꞌoom jâ. ");
INSERT INTO amuNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Cwicwaaꞌâ ñꞌeⁿ Jesús natmaaⁿ. Xjeⁿꞌñeeⁿ jnda̱ seijndo̱ꞌ tsaⁿjndii tsꞌom xꞌiaayâ Judas Iscariote, jnda Simón, na quiaa tsaⁿꞌñeeⁿ cwenta jom. ");
INSERT INTO amuNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ndoꞌ jom majndaaꞌya ntyjeeⁿ na lꞌo̱o̱ⁿ jnda̱ tquiaa Tsotyeeⁿ na meiⁿcwii tintjoom na nchii ñꞌoomꞌ nquii. Mantyjeeⁿ na jnaaⁿ na mꞌaaⁿ Tyꞌo̱o̱tsꞌom, ndoꞌ na majoꞌ wjaalcweeⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Teicantyjaaⁿ yocheⁿ na cwicwaaꞌâ natmaaⁿ. Tjeiiⁿꞌeⁿ liaatco na cweⁿ, toꞌñoom cwii liaa na cwityueeꞌ lua̱a̱yâ, seityeeⁿ juunaꞌ tsiaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Jnda̱ joꞌ tioom ndaatioo tsꞌom ꞌnaⁿ na cwicandyuuꞌâ. To̱o̱ⁿꞌo̱ⁿ na mamaaⁿ ncꞌa̱a̱ꞌâ na tꞌmaaⁿ na calajomndyô̱ ñꞌeⁿñê, jnda̱ chii maweeꞌñê ncꞌa̱a̱ꞌâ ñequio liaaꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ndoꞌ quia na tueꞌcañoom yuu na wacatyeeⁿ Simón Pedro, matso tsaⁿꞌñeeⁿ nnoom: —Ta, ¿aa mmaⁿꞌ ncꞌa̱ya? ");
INSERT INTO amuNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Tꞌo̱o̱ⁿ nnom, matsoom: —Tsꞌiaaⁿ na matsꞌaa tileicatseiꞌno̱ⁿꞌ na majeꞌndyo, sa̱a̱ nda̱quiacheⁿ nntseiꞌno̱ⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Matso Pedro nnoom: —Xoya na mmaⁿꞌ ncꞌa̱ya. Tꞌo̱ Jesús, matsoom nnom: —Xeⁿ ticamaaⁿya ncꞌeꞌ ticatseixmaⁿꞌ cantyja ꞌnaⁿya. ");
INSERT INTO amuNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Matso Simón Pedro nnoom: —Xeⁿ luaaꞌwaa Ta, nchii macanda̱ ncꞌa̱. Mati camaⁿꞌ lꞌo̱o̱ya ñequio xqua̱a̱ⁿya. ");
INSERT INTO amuNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Matso Jesús nnom: —Cwii tsꞌaⁿ na jnda̱ jnda̱a̱ꞌ, ticaⁿnaꞌ na nntmaⁿñe na chaꞌwaañe ee jnda̱ ljuꞌñe, manda̱ ncꞌee macaⁿnaꞌ na nntmaⁿ. ꞌO laxmaⁿꞌyoꞌ na ljuꞌ nꞌomꞌyoꞌ sa̱a̱ tichaꞌtsondyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ee ntyjeeⁿ ꞌñeeⁿ juu nñequiaa cwenta jom luee ntyee. Macweꞌ joꞌ na matsoom: “Sa̱a̱ tichaꞌtsondyoꞌ laxmaⁿꞌyoꞌ na ljuꞌ nꞌomꞌyoꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Quia na jnda̱ tmaaⁿ ncꞌa̱a̱ꞌâ, ndoꞌ tcweennaaⁿꞌaⁿ liaatco ꞌnaaⁿꞌaⁿ, jnda̱ joꞌ tjacjoonnaaⁿꞌaⁿ nacañoomꞌ meiⁿsa. Matsoom nda̱a̱yâ: —¿Aa cwilaꞌno̱ⁿꞌyoꞌ cantyja na sꞌaaya ꞌo? ");
INSERT INTO amuNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","ꞌO cwilacajndyuꞌyoꞌ ja Maestro ndoꞌ na cwiluiindyo̱ na matsa̱ꞌntjo̱ⁿya ꞌo. Ndoꞌ matyꞌiomyanaꞌ na ljoꞌ cwinduꞌyoꞌ, ee maxjeⁿ joꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ndoꞌ na jnda̱ tmaaⁿya ncꞌeeꞌyoꞌ na cwiluiindyo̱ na matsa̱ꞌntjo̱ⁿya ꞌo ndoꞌ na maꞌmo̱o̱ⁿya ñꞌoom naya ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom nda̱a̱ꞌyoꞌ, mati ꞌo matsonaꞌ na nntueꞌndyoꞌcjeꞌyoꞌ na nndyeꞌntjomꞌyoꞌ nda̱a̱ ncꞌiaaꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Ee jnda̱ sꞌaaya cwii nnom na maꞌmo̱ⁿnaꞌ nda̱a̱ꞌyoꞌ cha mati calꞌaꞌyoꞌ ñequio ntꞌomcheⁿ chaꞌxjeⁿ jnda̱ sꞌaaya ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ñꞌoom na mayuuꞌcheⁿ matsjo̱o̱ya nda̱a̱ꞌyoꞌ, juu tsꞌaⁿ na mꞌaaⁿ moso ticaluiitꞌmaⁿñe chaꞌna nquii tsꞌaⁿ na matsa̱ꞌntjom juu. Mati tsꞌaⁿ na mawjaa tsꞌiaaⁿ na jñom tsꞌaⁿ juu, ticaluiitꞌmaⁿñeti chaꞌxjeⁿ nquii tsꞌaⁿ na jñom juu. ");
INSERT INTO amuNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Xeⁿ cwilaꞌno̱ⁿꞌyoꞌ ñꞌoommeiⁿꞌ ndoꞌ cwilꞌaꞌyoꞌ na ljoꞌ, nntioꞌnaaⁿñe Tyꞌo̱o̱tsꞌom ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","’Nchii matsjo̱o̱ ñꞌoomwaaꞌ cantyja ꞌnaⁿꞌyoꞌ na chaꞌtsondyoꞌ. Mantyjiiya chiuu nꞌomꞌ ꞌo na jnda̱ tjeiiꞌndyo̱. Ee maxjeⁿ macaⁿnaꞌ na catseicanda̱a̱ꞌñenaꞌ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na teiljeii. Matsonaꞌ: “Manquii na macwaꞌ ñꞌeⁿndyo̱ malcweꞌ nacjoya.” ");
INSERT INTO amuNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Jeꞌ matsjo̱o̱ya ñꞌoomwaaꞌ nda̱a̱ꞌyoꞌ cwii tjo̱o̱cheⁿ na nluii na ljoꞌ, cha quia na nntseicanda̱a̱ꞌñenaꞌ nlayuꞌyoꞌ na ja cwiluiindyo̱ manquiiti na jnda̱ tsjo̱o̱ nda̱a̱ꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ñꞌoom na mayuuꞌcheⁿ matsjo̱o̱ nda̱a̱ꞌyoꞌ. ꞌÑeeⁿ juu na matseiljo tsꞌaⁿ na majño̱o̱ⁿya, ja matseiljo tsaⁿꞌñeeⁿ. Ndoꞌ ꞌñeeⁿ juu na matseiljo ja, matseiljo tsaⁿꞌñeeⁿ nqueⁿ na jñoom ja. ");
INSERT INTO amuNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jnda̱ na tso Jesús ñꞌoomwaaꞌ, seiꞌndaaꞌnaꞌ ntyjeeⁿ, ndoꞌ ndyeyu tjeiꞌyuuꞌñê nda̱a̱yâ. Tsoom: —Ñꞌoom na mayuuꞌcheⁿ matsjo̱o̱ nda̱a̱ꞌyoꞌ, cwiindyoꞌ ꞌo nñequiaa cwenta ja. ");
INSERT INTO amuNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Quia joꞌ jâ nnꞌaⁿ na cwilajomndyô̱ ñꞌeⁿñê tyontyꞌiaa ntyja̱a̱yâ nda̱a̱yâ. Ee ticalaꞌno̱o̱ⁿꞌâ ꞌñeeⁿ cwiindyo̱ jâ na matsoom na luaaꞌ nntsꞌaa. ");
INSERT INTO amuNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Xjeⁿꞌñeeⁿ ja Juan na jeeⁿ candyaꞌ tsꞌom Jesús, mawacatya̱ⁿ nacañomꞌm na cwicwaaꞌâ. ");
INSERT INTO amuNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ndoꞌ Simón Pedro sꞌo̱o̱ lꞌo̱o̱ⁿ no̱o̱ⁿ na cwaxꞌa̱ ꞌndyoo Jesús cwaaⁿ cwiindyo̱ jâ na nñequiaa cwenta jom. ");
INSERT INTO amuNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Joꞌ chii seintyjo̱ndyo̱ jo ndoꞌ jndya Jesús, taxꞌa̱ya nnoom, tsjo̱o̱: —Aa ndiꞌ Ta, ¿ꞌñeeⁿ cwii jâ na nntsꞌaa na ljoꞌ? ");
INSERT INTO amuNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Tꞌo̱o̱ⁿ no̱o̱ⁿ, tsoom: —Majuu tsꞌaⁿ na nnom nñequiaya cwii taⁿꞌ tyooꞌ xjeⁿ na jnda̱ seicandaꞌa juunaꞌ. Ndoꞌ quia na jnda̱ seicanaⁿꞌaⁿ tyooꞌñeeⁿ tquiaaⁿ juunaꞌ nnom Judas Iscariote, jnda Simón. ");
INSERT INTO amuNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ndoꞌ Judas, jnda̱ na toꞌñoom taⁿꞌ tyooꞌñeeⁿ, mana tuo̱ Satanás quiiꞌ tsꞌoom. Ndoꞌ tso Jesús nnoom: —Queⁿndyuꞌ tsꞌiaaⁿ na nntsaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Sa̱a̱ meiⁿcwiindyo̱ jâ na meindyuaandyô̱ nacañoomꞌ meiⁿsa ñꞌeⁿñê tîcalaꞌno̱o̱ⁿꞌâ chiuu na luaaꞌ ñꞌoom tsoom. ");
INSERT INTO amuNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ndoꞌ ee na manquiuuyâ na Judas maleiñꞌoom tjaⁿche na ñjom sꞌom na cwiwilꞌueeꞌndyô̱, joꞌ chii ntꞌomndyo̱ jâ jlaꞌtiuuyâ na ñeꞌcatso Jesús nnoom na catseijnaaⁿ ljoꞌtindyo na macaⁿnaꞌ na nleilꞌueeꞌndyô̱ na waa xuee, oo quiaaⁿ cwantindyo nda̱a̱ ndyeñeeⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ndoꞌ jnda̱ na tcwaꞌ Judas tyooꞌñeeⁿ, mañoomꞌ jlueeⁿꞌeⁿ. Juu xjeⁿꞌñeeⁿ jnda̱ teijaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Jnda̱ na jluiꞌ Judas quiiꞌntaaⁿyâ, matso Jesús nda̱a̱yâ: —Jeꞌ ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee, manntseitꞌmaaⁿꞌñenaꞌ ja. Ndoꞌ cantyja ꞌnaaⁿꞌ ljoꞌ na manntjo̱ⁿya nntseitꞌmaaⁿꞌñenaꞌ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ndoꞌ xeⁿ nntseitꞌmaaⁿꞌñenaꞌ jom cantyja na manntjo̱ⁿ, quia joꞌ mati cantyja ꞌnaaⁿꞌ joꞌ nntseitꞌmaaⁿꞌñê ja na cwiluiindyo̱ tsꞌaⁿ na jnaⁿ cañoomꞌluee, ndoꞌ tyuaaꞌ nntsꞌaaⁿ na ljoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ꞌO ntseindaaya na jeeⁿ wiꞌ tsꞌo̱o̱ⁿya, chjootindyo cwii mꞌaaⁿya ñꞌeⁿndyoꞌ. Nlꞌueꞌyoꞌ ja, ndoꞌ chaꞌxjeⁿ tsjo̱o̱ya nda̱a̱ ncꞌiaaꞌyoꞌ nnꞌaⁿ judíos, jeꞌ mati matsjo̱o̱ nda̱a̱ꞌ ꞌo: ꞌO xocanda̱a̱ nntsquieꞌcañomꞌyoꞌ yuu na nncjo̱. ");
INSERT INTO amuNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Cwii ñꞌoom xco na matsa̱ꞌntjomnaꞌ mañequiaya nda̱a̱ꞌyoꞌ, na cꞌomꞌyoꞌ na wiꞌ nꞌomꞌyoꞌ ncꞌiaaꞌyoꞌ. Chaꞌxjeⁿ na mꞌaaⁿya na candyaꞌ tsꞌo̱o̱ⁿya ꞌo, malaaꞌtiꞌ cꞌomꞌ ꞌo na wiꞌ nꞌomꞌ ncꞌiaaꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Na nlꞌaꞌyoꞌ na ljoꞌ nlaꞌno̱ⁿꞌ chaꞌtsondye nnꞌaⁿ na ꞌo cwiluiindyoꞌ nnꞌaⁿ na cwilajomndyoꞌ ñꞌeⁿndyo̱, xeⁿ mꞌaⁿꞌyoꞌ na wiꞌ nꞌomꞌ ncꞌiaaꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Taxꞌeeñe Simón Pedro nnoom. Matso: —Ta, ¿yuu wjaꞌyuꞌ? Tꞌo̱ Jesús, matsoom nnom: —Cantyja na nntjo̱ⁿ jeꞌ ꞌu xocanda̱a̱ nntseijomndyuꞌ, sa̱a̱ mati ꞌu nncueꞌntyjo̱ nntjomꞌ na ljoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Matso Pedro nnoom: —Ta, ¿chiuu na xocanda̱a̱ nntseijomndyo̱ jeꞌ ljoꞌ na nntjomꞌ? Tintsꞌaa meiiⁿ quio joꞌ cꞌio̱. ");
INSERT INTO amuNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Tꞌo̱ Jesús, matsoom nnom: ꞌU matseiꞌtiuuꞌ na nñequiaandyuꞌ na nncꞌioꞌ cantyja ꞌnaⁿya. Ñꞌoom na mayuuꞌcheⁿ matsjo̱o̱ njomꞌ, cwii tjo̱o̱cheⁿ na nntseixuaa caxtijndyo na jaawixuee, sa̱a̱ ꞌu jnda̱ ndyee ndiiꞌ macwjiꞌndyuꞌ cantyja ꞌnaⁿya. ");
INSERT INTO amuNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Tiñeꞌquiandyoꞌ na nntseiñꞌeeⁿꞌñenaꞌ nꞌomꞌyoꞌ. Calaꞌyuꞌyoꞌ ñꞌeⁿ Tyꞌo̱o̱tsꞌom ndoꞌ mati calaꞌyuꞌyoꞌ ñꞌeⁿndyo̱ ja. ");
INSERT INTO amuNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Naquiiꞌ waaꞌ Tsotya̱ya jndye joo niom yuu na ya nncꞌom nnꞌaⁿ. Xeⁿ nchii na luaaꞌ waa, jnda̱ tsjo̱o̱ nda̱a̱ꞌyoꞌ. Manncjo̱ na nntseijndaaꞌndyo̱ joonaꞌ na nleilꞌueeꞌndyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Ndoꞌ na jo̱ na nntseijndaaꞌndyo̱ yuu na nncꞌomꞌyoꞌ, nndyo̱lcwa̱ꞌnndaꞌa na nncjo̱cho̱ ꞌo yuu na mꞌaaⁿya, cha yuu na macꞌa̱ⁿya, majoꞌ nncꞌomꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ndoꞌ ꞌo manquiuꞌyoꞌ yuu na majo̱ ndoꞌ mati cwitaꞌjnaⁿꞌyoꞌ nato. ");
INSERT INTO amuNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Matso Tomás nnoom: —ꞌU Ta, ticaliuuyâ yuu wjaꞌ, joꞌ chii ¿chiuu ya na nlaꞌno̱o̱ⁿꞌâ yuu waa natoꞌñeeⁿ? ");
INSERT INTO amuNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Tꞌo̱ Jesús, matsoom nnom: —Ja cwiluiindyo̱ nato, ndoꞌ ñꞌoom na mayuuꞌ, ndoꞌ na tijoom cwintycwii na wandoꞌ tsꞌaⁿ. Ñequiiꞌcheⁿ cantyja ꞌnaⁿ ja joꞌ na nnda̱a̱ nncueeꞌ tsꞌaⁿ na mꞌaaⁿ Tsotya̱ya. ");
INSERT INTO amuNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Xeⁿ na cwilaꞌno̱ⁿꞌyoꞌ ꞌñeeⁿ cwiluiindyo̱, quia joꞌ mati nlaꞌno̱ⁿꞌyoꞌ cantyja ꞌnaaⁿꞌ Tsotya̱. Na jeꞌ na cwii wjaatinaꞌ ncꞌe na cwitaꞌjnaⁿꞌyoꞌ ja, mati cwitaꞌjnaⁿꞌyoꞌ jom, ndoꞌ jnda̱ ntyꞌiaꞌnda̱a̱ꞌyoꞌ jom. ");
INSERT INTO amuNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Matso Felipe nnoom: —Ta, quiaaꞌ na nntyꞌiaanda̱a̱yâ Tsotyeꞌ, quialjoꞌcheⁿ nljoya nꞌo̱o̱ⁿyâ. ");
INSERT INTO amuNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Tꞌo̱ Jesús nnom: —Chiuu sa ꞌu Felipe, jaachꞌee xuee mꞌaaⁿya ñꞌeⁿndyoꞌ, ¿aa maxjeⁿ ticwajnaⁿꞌ ja? Tsꞌaⁿ na jnda̱ ntyꞌiaaꞌ ja, mati jnda̱ ntyꞌiaaⁿꞌaⁿ Tsotya̱. ¿Chiuu na matsuꞌ: “Quiaaꞌ na nntyꞌiaanda̱a̱yâ Tsotyeꞌ”? ");
INSERT INTO amuNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿Aa ticatseiyuꞌ na ljoꞌyu cwiluiindyo̱ ñequio Tsotya̱ya, ndoꞌ jom ljoꞌyu cwiluiiñê ñꞌeⁿndyo̱ ja? Ñꞌoom na matseina̱ⁿya nda̱a̱ꞌyoꞌ, nchii matseina̱ⁿya joonaꞌ cantyja ꞌnaaⁿꞌ na jndo̱ꞌ tsꞌo̱o̱ⁿ nnco̱. Nquii Tsotya̱ na ñequiiꞌcheⁿ mꞌaaⁿñê ñꞌeⁿndyo̱, nqueⁿ machꞌeeⁿ tsꞌiaaⁿ ꞌnaaⁿꞌaⁿ cantyja ꞌnaⁿya. ");
INSERT INTO amuNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Calaꞌyuꞌyoꞌ na ljoꞌyu cwiluiindyo̱ ñequio Tsotya̱, ndoꞌ Tsotya̱ya ljoꞌyu cwiluiiñê ñꞌeⁿndyo̱ ja. Xeⁿ tileicalaꞌyuꞌyoꞌ na ljoꞌ, sa̱a̱ quiandyoꞌ na nlaꞌyuꞌyoꞌ ñꞌeⁿndyo̱ cantyja ꞌnaaⁿ mañejoo tsꞌiaaⁿmeiiⁿ na matsꞌaa. ");
INSERT INTO amuNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ñꞌoom na mayuuꞌcheⁿ matsjo̱o̱ nda̱a̱ꞌyoꞌ, ꞌñeeⁿ juu tsꞌaⁿ na matseiyuꞌ ñꞌeⁿndyo̱, mañejoo tsꞌiaaⁿ na matsꞌaa nntsꞌaaⁿ. Hasta jndaticheⁿ tsꞌiaaⁿ nntsꞌaaⁿ, ncꞌe na majo̱ na mꞌaaⁿ Tsotya̱ya. ");
INSERT INTO amuNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ndoꞌ meiⁿcwiꞌñeeⁿcheⁿ ñꞌoom na nntaⁿꞌyoꞌ nnom Tsotya̱ ñequio xueya, joꞌ joꞌ nñequia cha na catseitꞌmaaⁿꞌñenaꞌ jom cantyja ꞌnaⁿ ja na cwiluiindyo̱ Jnaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Chaꞌtso na cwitaⁿꞌyoꞌ ñequio xueya, joꞌ joꞌ nntsꞌaa. ");
INSERT INTO amuNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","’Xeⁿ mꞌaⁿꞌyoꞌ na jnda nquiuꞌyoꞌ ja, quia joꞌ calaꞌcanda̱ꞌyoꞌ ñꞌoom na matsa̱ꞌntjo̱ⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ndoꞌ ja nlcaaⁿꞌa nnom Tsotya̱ya na nñequiaaⁿ cwiicheⁿ na nnteijndeii ꞌo, nquii Espíritu na cwiluiiñe na mayuuꞌ na ñequiiꞌcheⁿ nncꞌoomñe ñꞌeⁿndyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Nnꞌaⁿ na mꞌaⁿ cantyja ꞌnaaⁿꞌ tsjoomnancue xocanda̱a̱ nntoꞌñoomna jom, ee tyoontyꞌiaana jom, meiⁿ ticataꞌjnaaⁿꞌna jom. Sa̱a̱ ꞌo cwitaꞌjnaⁿꞌyoꞌ jom, ee mꞌaaⁿñê naquiiꞌ nꞌomꞌyoꞌ, ndoꞌ ñequiiꞌcheⁿ nncꞌoomñê ñꞌeⁿndyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Tixocaꞌndiya ꞌo na macanda̱, maxjeⁿ nncwja̱nndaꞌa na mꞌaⁿꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mawaa xjeⁿ na nlaꞌcueeꞌ nnꞌaⁿ ja, ndoꞌ jnda̱ joꞌ taxocantyꞌiaana ja. Sa̱a̱ ñꞌeⁿndyoꞌ ꞌo ñequiiꞌcheⁿ na nncꞌo̱o̱ⁿya, ee ncꞌe na nncwando̱ꞌxco̱, joꞌ chii mati ꞌo nlaxmaⁿꞌyoꞌ na ticantycwii na nntandoꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Quia na jnda̱ tueꞌntyjo̱ xjeⁿꞌñeeⁿ nlaꞌno̱ⁿꞌyoꞌ na mꞌaaⁿya ñꞌeⁿ Tsotya̱, ndoꞌ ꞌo mꞌaⁿꞌyoꞌ ñꞌeⁿndyo̱, ndoꞌ ja mꞌaaⁿya ñꞌeⁿndyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","ꞌÑeeⁿ juu na matseiljo ñꞌoom na matsa̱ꞌntjo̱ⁿ ndoꞌ matseicanda̱ joonaꞌ, tsaⁿꞌñeeⁿ jnda ntyjeeⁿ ja. Ndoꞌ ꞌñeeⁿ juu na jnda ntyjii ja, nquii Tsotya̱ya candyaꞌ tsꞌoom juu. Ndoꞌ mati ja candyaꞌ tsꞌo̱o̱ⁿya juu, ndoꞌ mꞌmo̱o̱ⁿya cantyja ꞌnaⁿya nnom. ");
INSERT INTO amuNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Tsaⁿ na jndyu Judas, sa̱a̱ nchii Judas Iscariote, matso: —Ta, ¿chiuu na cweꞌ nda̱a̱ jâ mꞌmo̱ⁿꞌ cantyja ꞌnaⁿꞌ sa̱a̱ nda̱a̱ nnꞌaⁿ tsjoomnancue xocatsaꞌ na ljoꞌ? ");
INSERT INTO amuNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Tꞌo̱ Jesús nnom, matsoom: —ꞌÑeeⁿ juu na jnda ntyjii ja maxjeⁿ nntseiñꞌoomꞌñe ñꞌoom na maqua̱ⁿ. Nncꞌoom Tsotya̱ na candyaꞌ tsꞌoom tsaⁿꞌñeeⁿ, ndoꞌ nntsquia̱caño̱o̱ⁿyâ juu. Nncꞌo̱o̱ⁿyâ ñꞌeⁿñe. ");
INSERT INTO amuNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ꞌÑeeⁿ juu na ticajnda ntyjii ja, tsaⁿꞌñeeⁿ tiñeꞌcatseicana̱a̱ⁿ ñꞌoom na mañequiaya. Ndoꞌ ñꞌoom na matseina̱ⁿ nda̱a̱ꞌyoꞌ nchii ñꞌoom ꞌndyo̱ nnco̱ya. Matseixmaⁿnaꞌ ñꞌoom ꞌndyoo Tsotya̱ya ee jom jñoom ja quiiꞌntaaⁿꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","’Ñꞌoommeiⁿꞌ matseina̱ⁿ nda̱a̱ꞌyoꞌ yocheⁿ na ndicwaⁿ mꞌaaⁿndyo̱ ñꞌeⁿndyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Sa̱a̱ ja nlcaaⁿꞌa nnom Tsotya̱ya na njñoom Espíritu Santo na nnteijndeii ꞌo. Juu mꞌmo̱ⁿti ñꞌoom nda̱a̱ꞌyoꞌ na macaⁿnaꞌ na nliuꞌyoꞌ. Ndoꞌ nntsꞌaa na nncjaañjoomꞌ nꞌomꞌyoꞌ chaꞌtso ñꞌoom na jnda̱ ñetsjo̱o̱ nda̱a̱ꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","’Ja tjaaꞌnaⁿ ñomtiuu tseixmaⁿya. Mañequiaya na calaꞌxmaⁿꞌyoꞌ juunaꞌ naquiiꞌ nꞌomꞌyoꞌ. Juu na mañequia na cwicandaꞌyoꞌ tꞌmaⁿti tseixmaⁿnaꞌ, nchiiti juu na tjaa ñomtiuu cꞌom nnꞌaⁿ na mañequiaa tsjoomnancue. Tiñeꞌquiandyoꞌ na nntseiñꞌeeⁿꞌñenaꞌ nꞌomꞌyoꞌ ljoꞌ cwii nntjomꞌyoꞌ meiⁿ tilaꞌcatyuendyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Jnda̱ jndyeꞌyoꞌ na tsjo̱o̱ nda̱a̱ꞌyoꞌ, majo̱, sa̱a̱ nndyo̱nndaꞌa na mꞌaⁿꞌyoꞌ. Xeⁿ na mayuuꞌ jnda nqiuꞌyoꞌ ja, quia joꞌ nñequiaanaꞌ na neiⁿꞌyoꞌ meiiⁿ na tsjo̱o̱ na majo̱ ee na mꞌaaⁿ Tsotya̱ya jo̱. Jom tꞌmaⁿti cwiluiiñê, nchiiti ja. ");
INSERT INTO amuNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ndoꞌ jeꞌ cwitjo̱o̱cheⁿ na nluii na ljoꞌ matsjo̱o̱ya nda̱a̱ꞌyoꞌ, cha quia na jnda̱ tueꞌntyjo̱ juunaꞌ quia joꞌ nlaꞌyuꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","’Tajndye cwimatseina̱ⁿtya̱ya ñꞌeⁿndyoꞌ, ee mandyo nquii na cwiluiitquieñe quiiꞌ nꞌom nnꞌaⁿ tsjoomnancuewaañe. Sa̱a̱ tjaa meiⁿcwii na matseixmaⁿya na juu joꞌ nnda̱a̱ nleilꞌueeꞌñe na catꞌuiinaꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Sa̱a̱ cha nncꞌooliu nnꞌaⁿ tsjoomnancue na mꞌaaⁿya na candyaꞌ tsꞌo̱o̱ⁿya Tsotya̱, ndoꞌ na matseicanda̱a̱ꞌndyo̱ chaꞌtso na matsa̱ꞌntjoom ja, mañequiaandyo̱ na nncꞌio̱. Quicantyjaꞌyoꞌ, cjaaya, caluiiꞌa ñjaaⁿñe. ");
INSERT INTO amuNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","’Ja cwiluiindyo̱ tsꞌo̱o̱ ntjom na mayuuꞌ ndoꞌ Tsotya̱ya cwiluiiñê tsꞌaⁿ na mateixꞌee juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Matyjeeⁿ meiⁿnquia lꞌo̱ tsꞌo̱o̱ꞌñeeⁿ na tyoolꞌanaꞌ ta̱. Sa̱a̱ ticwii lꞌo̱ tsꞌo̱o̱ꞌñeeⁿ na cwilꞌanaꞌ ta̱, matyjeeⁿ nqueⁿnaꞌ cha majndyeti ta̱ calꞌanaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Mati joo ñꞌoom na maꞌmo̱o̱ⁿ nda̱a̱ꞌyoꞌ maqueⁿljuꞌnaꞌ nꞌomꞌyoꞌ cha ya nlꞌaꞌyoꞌ tsꞌiaaⁿ ꞌnaⁿya. ");
INSERT INTO amuNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Joꞌ chii caljooꞌndyoꞌtyeⁿꞌyoꞌ cantyja ꞌnaⁿya, chaꞌxjeⁿ macwiljooꞌndyo̱tya̱ⁿya ñꞌeⁿndyoꞌ. Ee chaꞌxjeⁿ tsꞌo̱ tsꞌo̱o̱ xonda̱a̱ nntsꞌaa cheⁿnquiinaꞌ ta̱ xeⁿ ticatꞌuiinaꞌ nquii tsꞌo̱o̱, majoꞌti cantyja ꞌnaⁿꞌyoꞌ, meiⁿ xocatsꞌaanaꞌ na nncueꞌ ta̱ nlꞌaꞌyoꞌ xeⁿ ticaljooꞌndyoꞌ cantyja ꞌnaⁿya. ");
INSERT INTO amuNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","’Ja cwiluiindyo̱ xꞌee tsꞌo̱o̱, ndoꞌ ꞌo cwiluiindyoꞌ lꞌo̱ tsꞌo̱o̱. ꞌÑeeⁿ cwii ꞌo na tyeⁿ matseijomñe cantyja ꞌnaⁿya, ndoꞌ na cwiljooꞌndyo̱ ñꞌeⁿñe, tsaⁿꞌñeeⁿ jndye chaꞌcwijom ta̱ nncueꞌ cantyja ꞌnaaⁿꞌaⁿ. Sa̱a̱ xeⁿ na nnto̱ⁿꞌñe cantyja ꞌnaⁿya, tjaaꞌnaⁿ ljoꞌ cwii nnda̱a̱ nntsꞌaa. ");
INSERT INTO amuNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ꞌÑeeⁿ juu na ticaljooꞌñe cantyja ꞌnaⁿya, nntquieꞌnaꞌ juu chaꞌxjeⁿ cwityeⁿnquieꞌ lꞌo̱ tsꞌo̱o̱, ndoꞌ joꞌ joꞌ cwicaaⁿnaꞌ. Jnda̱ chii cwicajñeeⁿꞌ nnꞌaⁿ lꞌo̱o̱ꞌñeeⁿ, cwitioomna joonaꞌ quiiꞌ chom. ");
INSERT INTO amuNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","’Xeⁿ cwilaꞌjomndyoꞌtyeⁿꞌyoꞌ cantyja ꞌnaⁿya, meiⁿ ticatsuuꞌ nꞌomꞌyoꞌ ñꞌoom na mañequiaya, quia joꞌ cataⁿꞌyoꞌ nnom Tyꞌo̱o̱tsꞌom chaꞌtso na lꞌue nꞌomꞌyoꞌ, ndoꞌ nñequiaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Luaa waa na matseitꞌmaaⁿꞌñenaꞌ Tsotya̱ya, na cantyja ꞌnaⁿꞌyoꞌ jndye ta̱ nncueꞌ. Ee laaꞌtiꞌ mꞌmo̱ⁿnaꞌ na mayuuꞌcheⁿ cwilaꞌxmaⁿꞌyoꞌ nnꞌaⁿ na cwilaꞌjomndyoꞌ ñequio ñꞌoom na mañequia. ");
INSERT INTO amuNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Chaꞌxjeⁿ juu Tsotya̱ya candyaꞌ tsꞌoom ja, mati ja candyaꞌ tsꞌo̱o̱ⁿya ꞌo. Joꞌ chii caljooꞌndyoꞌtyeⁿꞌyoꞌ cantyja na mꞌaaⁿya na candyaꞌ tsꞌo̱o̱ⁿya ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Ja matseicanda̱a̱ꞌndyo̱ ñꞌoom na matsa̱ꞌntjom Tsotya̱, ndoꞌ cwiljooꞌndyo̱ cantyja na candyaꞌ tsꞌoom ja. Ñequiiꞌcheⁿ calaꞌcanda̱ꞌyoꞌ ñꞌoom na matsa̱ꞌntjo̱ⁿya ꞌo, ee na nlꞌaꞌyoꞌ na ljoꞌ, nljooꞌndyoꞌtyeⁿꞌyoꞌ cantyja na candyaꞌ tsꞌo̱o̱ⁿya ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","’Ñꞌoommeiiⁿ matseina̱ⁿya nda̱a̱ꞌyoꞌ cha nlaꞌxmaⁿꞌyoꞌ na neiⁿꞌyoꞌ ñꞌeⁿndyo̱ ndoꞌ cha canda̱a̱ꞌya nncꞌomꞌyoꞌ na neiⁿꞌyoꞌ. Hasta quiaanaꞌ na waljooꞌcheⁿ na neiⁿꞌyoꞌ na cwilaꞌcanda̱a̱ꞌndyoꞌ yuu na matsa̱ꞌntjo̱ⁿya. ");
INSERT INTO amuNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Luaa waa ñꞌoom na matsa̱ꞌntjo̱ⁿ: Cꞌomꞌyoꞌ na wiꞌ nꞌomꞌyoꞌ ncꞌiaaꞌyoꞌ, chaꞌxjeⁿ mꞌaaⁿya na candyaꞌ tsꞌo̱o̱ⁿya ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Tjaaꞌnaⁿ cwii na tꞌmaⁿti na maꞌmo̱ⁿnaꞌ na wiꞌ tsꞌom tsꞌaⁿ ncꞌiaaꞌ chaꞌna juu tsꞌaⁿ na nñequiaañe na cueꞌ cwentaa ncꞌiaaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ꞌO cwiluiindyoꞌ ncꞌiaya xeⁿ cwilaꞌcanda̱a̱ꞌndyoꞌ na matsa̱ꞌntjo̱ⁿya ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Jeꞌ tacatsjo̱o̱tya̱ya na ꞌo cwiluiindyoꞌ moso. Ee tsꞌaⁿ na mꞌaaⁿ moso ticaljeiiⁿ ljoꞌ matseijndaaꞌñe patrom ꞌnaaⁿꞌaⁿ. Jeꞌ matsjo̱o̱ya na ꞌo cwiluiindyoꞌ nnꞌaⁿ na ya ñꞌoom ñꞌeⁿndyo̱ ee jnda̱ tquiaya na caliuꞌyoꞌ chaꞌtso ñꞌoom na jnda̱ jndiiya ꞌndyoo Tsotya̱ya. ");
INSERT INTO amuNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ꞌO nchii tjeiiꞌndyoꞌ na nlaꞌxmaⁿꞌyoꞌ cantyja ꞌnaⁿya, nnco̱ tjeiiꞌndyo̱ ꞌo, ndoꞌ jnda̱ tyꞌio̱ⁿya tsꞌiaaⁿ ꞌo na catsaꞌyoꞌ ndoꞌ calꞌaꞌyoꞌ yuu na ñenquiiꞌcheⁿ nntseitꞌmaaⁿꞌñenaꞌ Tyꞌo̱o̱tsꞌom. Ee na ljoꞌ nlꞌaꞌyoꞌ meiⁿquia ñꞌoom na ntaⁿꞌyoꞌ nnom Tsotya̱ ñequio xueya, jom nñequiaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Luaa ñꞌoom na matsa̱ꞌntjo̱ⁿya ꞌo: Cꞌomꞌyoꞌ na wiꞌ nꞌomꞌyoꞌ ncꞌiaaꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","’Quia ticueeꞌ nꞌom nnꞌaⁿ tsjoomnancue ꞌo, calaꞌno̱ⁿꞌyoꞌ na ja tyuaaꞌti tꞌomna na ticueeꞌ nꞌomna. ");
INSERT INTO amuNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Xeⁿ cwilaꞌxmaⁿꞌyoꞌ cantyja ꞌnaaⁿꞌ tsjoomnancue, nnꞌaⁿ cwentaaꞌnaꞌ nncꞌomna na neiiⁿna ꞌo chaꞌxjeⁿ na neiiⁿna ncꞌiaana, sa̱a̱ ncꞌe jnda̱ tjeiiꞌa ꞌo quiiꞌntaaⁿna, joꞌ chii ticalaꞌxmaⁿꞌyoꞌ cantyja ꞌnaaⁿꞌ tsjoomnancue, ndoꞌ joꞌ na jndoo nnꞌaⁿ ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Cjaañjoomꞌ nꞌomꞌyoꞌ ñꞌoom na jnda̱ ñetsjo̱o̱ nda̱a̱ꞌyoꞌ, na juu tsꞌaⁿ na mꞌaaⁿ moso ticaluiitꞌmaⁿñê chaꞌxjeⁿ nquii tsꞌaⁿ na matsa̱ꞌntjom jom. Ncꞌe na cwitaꞌwiꞌ nnꞌaⁿ ja, mati nntaꞌwiꞌna ꞌo. Ndoꞌ xeⁿ cwilaꞌcanda̱a̱ꞌndyena ñꞌoom na mañequiaya, quia joꞌ mati nlaꞌcanda̱a̱ꞌndyena ñꞌoom na nñeꞌquiaꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Chaꞌtso nmeiⁿꞌ nlꞌana ꞌo cweꞌ ncꞌe na laꞌxmaⁿꞌyoꞌ cwentaya ee ticataꞌjnaaⁿꞌna nqueⁿ na jñoom ja quiiꞌntaaⁿna. ");
INSERT INTO amuNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","’Xeⁿ nchii na jndyotseina̱ⁿya nda̱a̱na, quia joꞌ tixocwijndaaꞌ na laꞌxmaⁿna jnaⁿ. Sa̱a̱ jeꞌ tixocanda̱a̱ nluena na ticaliuna na cwilaꞌtjo̱o̱ndyena nnoom. ");
INSERT INTO amuNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ee ꞌñeeⁿ juu na jndooꞌ ja, mati jndooꞌ tsaⁿꞌñeeⁿ nqueⁿ na cwiluiiñê Tsotya̱. ");
INSERT INTO amuNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Tijoom ñesꞌaa cwiicheⁿ tsꞌaⁿ tsꞌiaaⁿ quiiꞌntaaⁿ nnꞌaⁿ chaꞌxjeⁿ tsꞌiaaⁿ na matsꞌaa. Xeⁿ na nchii tsꞌiaaⁿmeiⁿꞌ matsꞌaa, quia joꞌ tixocwijndaaꞌ na cwilaꞌtjo̱o̱ndyena nnoom, sa̱a̱ jeꞌ meiiⁿ na jnda̱ ñentyꞌiaana tsꞌiaaⁿ na matsꞌaa cantyjati xjeⁿ na to̱ꞌa, mꞌaⁿna na jndoona ja ndoꞌ mati nqueⁿ na cwiluiiñê Tsotya̱. ");
INSERT INTO amuNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Sa̱a̱ luaaꞌ waa cha catseicanda̱a̱ꞌñenaꞌ ñꞌoom na teiljeii naquiiꞌ ljeii na cwileiꞌñꞌomna na matsa̱ꞌntjomnaꞌ, na matsonaꞌ: “Jndoona ja meiiⁿ tjaaꞌnaⁿ cwii nnom cantyja ꞌnaⁿya na matseijndaaꞌñenaꞌ na nlꞌana na ljoꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","’Ja nlcaaⁿꞌa nnom Tsotya̱ na cajñoom Espíritu na cwiluiiñe na mayuuꞌ naquiiꞌ nꞌomꞌyoꞌ. Quia na jnda̱ tyjeeⁿꞌeⁿ nncwjiꞌyuuꞌñê cantyja ꞌnaⁿya. ");
INSERT INTO amuNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ndoꞌ mati ꞌo nntjeiꞌyuuꞌndyoꞌ cantyja ꞌnaⁿya, ee mꞌaⁿꞌyoꞌ ñꞌeⁿndyo̱ xjeⁿ na to̱ꞌjndya̱a̱ tsꞌiaaⁿmeiiⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Matso Jesús: —Ñꞌoommeiⁿꞌ jnda̱ seina̱ⁿ cantyja ꞌnaⁿya nda̱a̱ꞌyoꞌ cha tintseiquiaanaꞌ ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ee nntjeiiꞌ nnꞌaⁿ judíos ꞌo naquiiꞌ lanꞌom ꞌnaaⁿna. Ndoꞌ manncueꞌntyjo̱ xjeⁿ na meiⁿquiandyo tsꞌaⁿ na nntseicueeꞌ cwii ꞌo nntseitiuutoom na mandiꞌntjoom nnom Tyꞌo̱o̱tsꞌom na ljoꞌ nntsꞌaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nmeiiⁿꞌ nlꞌana cweꞌ ncꞌe tîcalaꞌno̱ⁿꞌna cantyja ꞌnaaⁿꞌ Tsotya̱, meiⁿ cantyja ꞌnaⁿ ja. ");
INSERT INTO amuNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Sa̱a̱ jnda̱ tsjo̱o̱ya ñꞌoommeiⁿꞌ nda̱a̱ꞌyoꞌ cha quia na nncueꞌntyjo̱ xjeⁿꞌñeeⁿ nncjaañjoomꞌ nꞌomꞌyoꞌ ñꞌoom na jnda̱ tsjo̱o̱ nda̱a̱ꞌyoꞌ. ’Tîcatsjo̱o̱ ñꞌoommeiⁿꞌ nda̱a̱ꞌyoꞌ quia na to̱ꞌjndya̱a̱ tsꞌiaaⁿ na maleiñꞌo̱ⁿya ncꞌe mꞌaaⁿya ñꞌeⁿndyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Sa̱a̱ jeꞌ majo̱lcwa̱ꞌa na mꞌaaⁿ nqueⁿ na jñoom ja quiiꞌntaaⁿꞌyoꞌ, ndoꞌ meiⁿcwii ꞌo tyoowaxeꞌ no̱o̱ⁿ yuu jo̱. ");
INSERT INTO amuNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Sa̱a̱ cweꞌ ee na tsjo̱o̱ ñꞌoommeiⁿꞌ nda̱a̱ꞌyoꞌ, joꞌ na jeeⁿ ndyaꞌ chjooꞌ nꞌomꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Sa̱a̱ ñꞌoom na mayuuꞌ matsjo̱o̱ya nda̱a̱ꞌyoꞌ, maxjeⁿ nnteijndeiitinaꞌ ꞌo xeⁿ jo̱ya. Ee xeⁿ ticjo̱, nqueⁿ na nnteijneiⁿ ꞌo ndoꞌ na nñequiaaⁿ na tꞌmaⁿ nꞌomꞌyoꞌ tixocwjeeꞌcañoom ꞌo. Ndoꞌ na nncjo̱, njño̱o̱ⁿya jom na nñoom na mꞌaⁿꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ee quia na jnda̱ tyjeeꞌcañoom, nntsꞌaaⁿ na nlcoꞌtianaꞌ nquiu nnꞌaⁿ na laꞌxmaⁿna jnaⁿ ndoꞌ na calaꞌno̱ⁿꞌna na cꞌomna cantyja na matyꞌiomyanaꞌ ndoꞌ na nncuꞌxeⁿ Tyꞌo̱o̱tsꞌom joona. ");
INSERT INTO amuNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Mꞌmo̱o̱ⁿ na laꞌxmaⁿ nnꞌaⁿ jnaⁿ cweꞌ ncꞌe na tiñeꞌcalaꞌyuꞌna ñꞌeⁿndyo̱. ");
INSERT INTO amuNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ndoꞌ mꞌmo̱o̱ⁿ chiuu waa na matyꞌiomyanaꞌ na cꞌomna ncꞌe jo̱ na mꞌaaⁿ Tsotya̱ ndoꞌ taxocantyꞌiaatina ja. ");
INSERT INTO amuNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Mꞌmo̱o̱ⁿ chiuu na nncuꞌxeⁿ Tyꞌo̱o̱tsꞌom nnꞌaⁿ ee na jnda̱ tuꞌxeⁿñe nquii na cwiluiitquieñe tsjoomnancuewaañe. ");
INSERT INTO amuNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","’Ndoꞌ niom jndye ntꞌomcheⁿ ñꞌoom na macaⁿnaꞌ na catsjo̱o̱ya nda̱a̱ꞌyoꞌ, sa̱a̱ tileicalaꞌno̱ⁿꞌyoꞌ joo ñꞌoomꞌñeeⁿ jeꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Sa̱a̱ quia na nncwjeeꞌcañoom juu Espíritu na cwiluiiñe na mayuuꞌ, juu nncjaaꞌmo̱ⁿ nda̱a̱ꞌyoꞌ chaꞌtso ñꞌoom na mayuuꞌ ee nchii nntseineiⁿ cantyja ꞌnaaⁿꞌ nquii, nntseineiⁿ ticwii cwii ñꞌoom na mandii na matseineiⁿ Tyꞌo̱o̱tsꞌom. Ndoꞌ mꞌmo̱ⁿ nda̱a̱ꞌyoꞌ ꞌnaⁿ na quia nluii. ");
INSERT INTO amuNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Juu nntseitꞌmaaⁿꞌñe ja, ee nncoꞌñom chaꞌtso ñꞌoom na ñeꞌcatseicandiiya ꞌo, ndoꞌ mꞌmo̱ⁿ joonaꞌ nda̱a̱ꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Chaꞌtso na matseixmaⁿ cwentaaꞌ Tsotya̱ya macwentaya joonaꞌ. Cweꞌ ncꞌe joꞌ na tsjo̱o̱ na nncoꞌñom juu Espíritu chaꞌtso ñꞌoom na ñeꞌcatseicandiiya ꞌo ndoꞌ mꞌmo̱ⁿ joonaꞌ nda̱a̱ꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","’Chjootindyo cwii ñꞌa̱ⁿtya̱ ñꞌeⁿndyoꞌ, ndoꞌ jnda̱ joꞌ taxocantyꞌiaꞌyoꞌ ja. Ndoꞌ nda̱nquia chjootindyo cwii nntyꞌiaꞌtiꞌyoꞌ ja, cweꞌ ncꞌe nncjo̱ na mꞌaaⁿ Tsotya̱. ");
INSERT INTO amuNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Jnda̱ tsoom ñꞌoommeiⁿꞌ cwantindyô̱ jâ nnꞌaⁿ na cwilaꞌjomndyô̱ ñꞌeⁿñê tsꞌiaaⁿ na machꞌeeⁿ lꞌuuyâ nda̱a̱ ntyja̱a̱yâ: —¿Chiuu ñecaꞌmo̱ⁿ ñꞌoomwaaꞌ na matseineiiⁿ nda̱a̱yâ, na chjootindyo cwii ñꞌeⁿtyeeⁿ ñꞌeⁿndyo̱, ndoꞌ xeⁿ jnda̱cheⁿ taxocantyꞌiaaꞌya jom, ndoꞌ nda̱nquia joꞌ chjootindyo cwii nntyꞌianndaꞌa jom? Ndoꞌ na tsoom cweꞌ ncꞌe na wjaⁿ na mꞌaaⁿ Tsotyeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Lꞌuutya̱a̱yâ: —Juu ñꞌoomwaaꞌ na chjootindyo na tsoom, ¿ljoꞌ ñeꞌcaꞌmo̱ⁿnaꞌ? Ticalaꞌno̱o̱ⁿꞌâ ñꞌoom na matseineiiⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ndoꞌ seiꞌno̱ⁿꞌ Jesús na ñeꞌcataꞌxꞌeendyo̱tya̱a̱yâ ñꞌoomwaaꞌ nnoom. Quia joꞌ matsoom nda̱a̱yâ: —¿Aa cwitaꞌxeꞌyoꞌ nda̱a̱ ntyjeeꞌyoꞌ cantyja ñꞌoommeiⁿꞌ na matsjo̱o̱ na chjootindyo meiⁿ taxocantyꞌiaꞌyoꞌ ja, ndoꞌ nda̱nquiacheⁿ na chjootindyo quia joꞌ nntyꞌiaꞌnndaꞌyoꞌ ja? ");
INSERT INTO amuNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ñꞌoom na mayuuꞌcheⁿ matsjo̱o̱ya nda̱a̱ꞌyoꞌ, joo nnꞌaⁿ na mꞌaⁿ cantyja ꞌnaaⁿꞌ tsjoomnancue, ñequio na neiiⁿna nntyꞌiaana ljoꞌ nntjo̱ⁿ. ꞌNaⁿ na nntjo̱ⁿ nntsꞌaanaꞌ na ꞌo nntyueeꞌyoꞌ na matseichjooꞌnaꞌ nꞌomꞌyoꞌ, sa̱a̱ juu na chjooꞌ nꞌomꞌyoꞌ, xeⁿ jnda̱cheⁿ nntseicwaqueⁿnaꞌ na nncꞌoomꞌyoꞌ na neiⁿꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Manquiuꞌyoꞌ cwii yuscu quia manntseincuii, maquiinaꞌ juu, cweꞌ ee jnda̱ tueꞌntyjo̱ xjeⁿ na nntseincuii. Sa̱a̱ quia na jnda̱ tuiiñe yuꞌndaa, cwitsuuꞌ tsꞌoom na tquiinaꞌ jom, ee mꞌaaⁿ na neiiⁿꞌeⁿ na jnda̱ tuiiñe yuꞌndaa. ");
INSERT INTO amuNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Maluaaꞌ matseijomnaꞌ ꞌo. Jeꞌ mꞌaⁿꞌyoꞌ na chjooꞌ nꞌomꞌyoꞌ, sa̱a̱ quia na nntyꞌianndaꞌa ꞌo, quia ljoꞌcheⁿ nñequiaanaꞌ na neiⁿꞌyoꞌ. Ndoꞌ xjeⁿꞌñeeⁿ meiⁿcwii tsꞌaⁿ xocanda̱a̱ nncwjiꞌ na neiⁿꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","’Juu xueeꞌñeeⁿ, taxocaⁿnaꞌ na nntaꞌxeꞌtiꞌyoꞌ ñꞌoom no̱o̱ⁿ. Ñꞌoom na mayuuꞌcheⁿ matsjo̱o̱ nda̱a̱ꞌyoꞌ, chaꞌtso na ntaⁿꞌyoꞌ nnom Tsotya̱ya cha catseitꞌmaaⁿꞌñenaꞌ ja, joꞌ nñequiaaⁿ na nndaꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Hasta xjeⁿ jeꞌcheⁿ tyoocaⁿnaꞌ na canduꞌyoꞌ na catseitꞌmaaⁿꞌñenaꞌ ja joo ñꞌoom na nntaⁿꞌyoꞌ nnoom. Sa̱a̱ jeꞌ calꞌaꞌyoꞌ na ljoꞌ quia joꞌ nntoꞌñoomꞌyoꞌ ñꞌoom na cwilatyꞌoondyoꞌ, cha nñequiaanaꞌ na canda̱a̱ꞌya na neiⁿꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","’Jnda̱ seina̱ⁿ ñꞌoommeiⁿꞌ nda̱a̱ꞌyoꞌ na cweꞌ tjañoomꞌ. Sa̱a̱ manncueꞌntyjo̱ xjeⁿ na taxocatseina̱ⁿ nda̱a̱ꞌyoꞌ ñꞌoom na cweꞌ wjaañoomꞌ, ee nntseina̱ⁿ nda̱a̱ꞌyoꞌ ñꞌoom na ndyeyu cantyja ꞌnaaⁿꞌ Tsotya̱. ");
INSERT INTO amuNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ndoꞌ juu xjeⁿꞌñeeⁿ, nntaⁿꞌyoꞌ nnoom ñequio xueya cha catseitꞌmaaⁿꞌñenaꞌ ja. Ndoꞌ quia ljoꞌcheⁿ meiⁿ taxocaⁿnaꞌ na nntseityꞌoondyo̱ nnom jom na nñequiaaⁿ ñꞌoom na cwitaⁿꞌyoꞌ, ");
INSERT INTO amuNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ee manquiiti Tsotya̱ya mꞌaaⁿ na candyaꞌ tsꞌoom ꞌo, ncꞌe na jnda nquiuꞌyoꞌ ja ndoꞌ jnda̱ macwilayuꞌyoꞌ na jnaaⁿya na mꞌaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Ja jnaaⁿya na mꞌaaⁿ, tyja̱ꞌcaño̱o̱ⁿya tsjoomnancuewaa. Ndoꞌ jeꞌ jeꞌ maꞌndiya juunaꞌ na manncjo̱lcwa̱ꞌa na mꞌaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Quia joꞌ jâ nnꞌaⁿ na cwilajomndyô̱ ñꞌeⁿñê lꞌuuyâ: —Jeꞌ ndyeyu matseiꞌneiⁿꞌ, nchii cweꞌ ñꞌoom na wjaañoomꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Jeꞌ macwilaꞌno̱o̱ⁿꞌâ na ꞌu chaꞌtso ntyjiꞌ meiⁿ ticaⁿnaꞌ na nntaꞌxꞌa̱a̱tya̱a̱yâ njomꞌ. Joꞌ chii cwilayuuꞌâ na mayuuꞌ na jnaⁿꞌ na mꞌaaⁿ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Tꞌo̱ Jesús nda̱a̱yâ, matsoom: —Jeꞌ cwilaꞌtiuuꞌyoꞌ na cwilayuꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Sa̱a̱ manncueꞌntyjo̱ xjeⁿ, ndoꞌ jeꞌ cwiweꞌntyjo̱naꞌ na nntꞌoomꞌndyoꞌ. Cwii ndoꞌ cwiindyoꞌ nntsaꞌyoꞌ na waa wꞌaꞌyoꞌ ndoꞌ nꞌndyeꞌyoꞌ ja na ñenco̱. Sa̱a̱ tiñenco̱ mꞌaaⁿya, ee nquii Tsotya̱ya mꞌaaⁿñê ñꞌeⁿndyo̱. ");
INSERT INTO amuNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Jnda̱ seina̱ⁿya ñꞌoommeiⁿꞌ nda̱a̱ꞌyoꞌ cha cantyja na cwilajomndyoꞌ ñꞌeⁿndyo̱ meiⁿcwii ñomtiuu tancꞌoom. Ñequiiꞌ nawiꞌ nntjomꞌyoꞌ na mꞌaⁿꞌyoꞌ tsjoomnancue, sa̱a̱ cꞌomꞌtꞌmaaⁿꞌndyoꞌ nꞌomꞌyoꞌ, ee jnda̱ jnaⁿndyo̱ ñequio juu na matseixmaⁿ tsjoomnancue. ");
INSERT INTO amuNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jnda̱ na seineiⁿ Jesús ñꞌoommeiⁿꞌ, jlunda̱a̱ñê cañoomꞌluee. Matsoom: —Tsotya̱ya, jnda̱ tueꞌntyjo̱ na nluii chaꞌtso na teijndaaꞌ cantyja ꞌnaⁿya. Jeꞌ catseitꞌmaaⁿꞌndyuꞌ ja na cwiluiindyo̱ Jndaꞌ, cha mati ja nntseitꞌmaaⁿꞌndyo̱ ꞌu. ");
INSERT INTO amuNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ee ꞌu jnda̱ tqueⁿꞌ na waa na jndo̱ na matseixmaⁿya jo nda̱a̱ chaꞌtso nnꞌaⁿ tsjoomnancue na ticwii cwii tsꞌaⁿ na mañequiaaꞌ lꞌo̱o̱ya na nñequiaya na tseixmaⁿ na ticantycwii na wandoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Luaa waa na nntseixmaⁿ tsꞌaⁿ na ticantycwii na wandoꞌ añmaaⁿꞌaⁿ, na catseiꞌno̱o̱ⁿꞌo̱ⁿ na ñenncuꞌcheⁿꞌ cwiluiindyuꞌ Tyꞌo̱o̱tsꞌom na mayuuꞌ ndoꞌ mati na ja Jesús cwiluiindyo̱ Cristo na jñomꞌ ja quiiꞌntaaⁿ nnꞌaⁿ tsjoomnancue. ");
INSERT INTO amuNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","’Ja jnda̱ seitꞌmaaⁿꞌndyo̱ ꞌu quiiꞌntaaⁿ nnꞌaⁿ tsjoomnancue. Ndoꞌ majnda̱ mamañequiaandyo̱ na cꞌio̱ cwentaa nnꞌaⁿ, mañejuu tsꞌiaaⁿꞌñeeⁿ na tquiaaꞌ no̱o̱ⁿ na catsꞌaa. ");
INSERT INTO amuNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ndoꞌ jeꞌ jeꞌ ꞌu Tsotya̱ya, catseitꞌmaaⁿꞌndyuꞌ ja chaꞌxjeⁿ na cwiluiitꞌmaⁿndyuꞌ yuu na mꞌaaⁿꞌ, na juu joꞌ matseixmaⁿya ñꞌeⁿndyuꞌ cwii tjo̱o̱cheⁿ na nncuaa tsjoomnancue. ");
INSERT INTO amuNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","’Nda̱a̱ nnꞌaⁿ na mꞌaⁿ tsjoomnancue na tquiaaꞌ joona lꞌo̱o̱, jnda̱ tꞌmo̱o̱ⁿya chiuu cwiluiindyuꞌ. Tyomꞌaⁿna cwentaꞌ, ndoꞌ tquiaaꞌ na cwilaꞌxmaⁿna cwentaya. Joona cwilaꞌwena ñꞌoom naya ꞌnaⁿꞌ ndoꞌ cwilaꞌcanda̱na juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ndoꞌ macwilaꞌno̱ⁿꞌna na chaꞌtso na cwicanda̱a̱ matsꞌaa, ñenncuꞌ tquiaaꞌ na matseixmaⁿya na ljoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ee ñꞌoom na tsuꞌ no̱o̱ⁿya, jnda̱ tquia joonaꞌ nda̱a̱na. Ndoꞌ joona jnda̱ toꞌñoomna ñꞌoomꞌñeeⁿ. Cwilaꞌno̱ⁿꞌna na mayuuꞌcheⁿ jnaaⁿya na mꞌaaⁿꞌ, ndoꞌ cwilaꞌyuꞌna na ꞌu jñomꞌ ja quiiꞌntaaⁿ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","’Macaⁿꞌa naya njomꞌ cantyja ꞌnaaⁿna, nchii cantyja ꞌnaaⁿ nnꞌaⁿ tsjoomnancue. Ja macaⁿꞌa na cateijndeiꞌ joo na jnda̱ tquiaaꞌ lꞌo̱o̱ya, ee cwilaꞌxmaⁿna cwentaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Chaꞌtsondye joona na laꞌxmaⁿna cwentaya, mati laꞌxmaⁿna cwentaꞌ. Ndoꞌ joona na laꞌxmaⁿna cwentaꞌ, mati laꞌxmaⁿna cwentaya, ndoꞌ matseitꞌmaaⁿꞌñenaꞌ ja cantyja ꞌnaaⁿna. ");
INSERT INTO amuNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","’Jeꞌ taxocꞌo̱o̱ⁿtya̱ tsjoomnancue, sa̱a̱ joo naⁿmꞌaⁿꞌ cwiljooꞌndyena juunaꞌ, ee ja jo̱nlcwa̱ꞌa na mꞌaaⁿꞌ. ꞌU Tsotya̱ya na ljuꞌ cwiluiindyuꞌ, catsaꞌ cwenta naⁿmꞌaⁿ na jnda̱ tquiaaꞌ lꞌo̱o̱ ñequio juu najndeii na matseiꞌxmaⁿꞌ cha nntsꞌaanaꞌ ñeꞌcwii nlaꞌxmaⁿna chaꞌxjeⁿ jaa ñeꞌcwii cwilaxmaaⁿya. ");
INSERT INTO amuNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Yocheⁿ na tyomꞌaaⁿya naquiiꞌntaaⁿ naⁿmꞌaⁿ na jnda̱ tquiaaꞌ lꞌo̱o̱, tyotsꞌaa cwenta joona ñequio najndeii na matseiꞌxmaⁿꞌ nncuꞌ. Ndoꞌ meiⁿcwiindyena tîcatsuuñe, macanda̱ tsuuñe juu tsꞌaⁿ na matseixmaⁿ na catsuuñe, cha na catseicanda̱a̱ꞌñenaꞌ ñꞌomꞌ na teiljeii. ");
INSERT INTO amuNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","’Sa̱a̱ jeꞌ na nncjo̱lcwa̱ꞌa na mꞌaaⁿꞌ. Ndoꞌ matseina̱ⁿya ñꞌoommeiiⁿ yocheⁿ na ndi mꞌaaⁿya tsjoomnancuewaañe, cha juu na mꞌaaⁿya na neiⁿya, canda̱a̱ꞌ nlaꞌxmaⁿna juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Jnda̱ tquiaya ñꞌoom naya ꞌnaⁿꞌ nda̱a̱na, sa̱a̱ nnꞌaⁿ tsjoomnancue ticueeꞌ nꞌom joona ee ticalaꞌxmaⁿna cantyja ꞌnaaⁿꞌ tsjoomnancue, chaꞌxjeⁿ ja meiⁿ ticatseixmaⁿya cantyja ꞌnaaⁿꞌnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Nchii macaⁿꞌa na cwjiꞌ joona tsjoomnancue, sa̱a̱ na cwañomꞌ joona ljoꞌ na ñeꞌcatsꞌaa tsaⁿjndii ñꞌeⁿndyena. ");
INSERT INTO amuNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Joona ticalaxmaⁿna cantyja ꞌnaaⁿꞌ tsjoomnancue chaꞌxjeⁿ ja meiⁿ ticatseixmaⁿya cantyja ꞌnaaⁿꞌnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Queⁿꞌ joona na cwiluiindyena na ljuꞌ nꞌomna ncꞌe ñꞌoom na mayuuꞌ. Juunaꞌ cwiluiiñenaꞌ na mayuuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Chaꞌxjeⁿ na jñomꞌ ja na jndyo̱o̱ tsjoomnancue, mati majño̱o̱ⁿya joona na cꞌoocatjeiꞌyuuꞌndyena nda̱a̱ nnꞌaⁿ tsjoomnancue. ");
INSERT INTO amuNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ee ncꞌe joona maqua̱ⁿ cheⁿnnco̱ na ljuꞌ tsꞌo̱o̱ⁿ jo njomꞌ cha mati nlqueⁿljuꞌnaꞌ nꞌomna ncꞌe ñꞌoom na mayuuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","’Ndoꞌ nchii macanda̱ macaⁿꞌa cantyja ꞌnaaⁿ joo naⁿmꞌaⁿꞌ. Mati macaⁿꞌa na cateijndeiꞌ joo nnꞌaⁿ na quia nlaꞌyuꞌ ñꞌeⁿndyo̱ ncꞌe ñꞌoom na quia nntjeiꞌyuuꞌndyena ");
INSERT INTO amuNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","cha ñeꞌcwii nlaꞌxmaⁿna, chaꞌxjeⁿ ꞌu Tsotya̱ya ñeꞌcwii cwiluiindyuꞌ ñꞌeⁿndyo̱, ndoꞌ ja ñeꞌcwii cwiluiindyo̱ ñꞌeⁿndyuꞌ. Ee na ljoꞌ mati joona nnda̱a̱ nlaꞌxmaⁿna na ñeꞌcwii cwiluiindyena ñequiondyo̱ jaa. Quia joꞌ nlaꞌyuꞌ nnꞌaⁿ tsjoomnancue na ꞌu jñomꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Juu na tquiaaꞌ na matseitꞌmaaⁿꞌñenaꞌ ja, mati tquiaya joꞌ na calaꞌxmaⁿna, cha na ñeꞌcwii calaꞌxmaⁿna chaꞌxjeⁿ jaa ñeꞌcwii cwilaꞌxmaaⁿya. ");
INSERT INTO amuNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ja mꞌaaⁿya ñꞌeⁿndye joona, ndoꞌ ꞌu mꞌaaⁿꞌ ñꞌeⁿndyo̱ ja cha nntsꞌaanaꞌ na ñeꞌcwii cwilaꞌxmaⁿna. Ndoꞌ na ljoꞌ nlaꞌno̱ⁿꞌ nnꞌaⁿ na ꞌu jñomꞌ ja, ndoꞌ na candyaꞌ tsꞌomꞌ joona chaꞌxjeⁿ na candyaꞌ tsꞌomꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","’ꞌU Tsotya̱ya mꞌaaⁿꞌ na candyaꞌ tsꞌomꞌ ja cwii tjo̱o̱cheⁿ na tqueⁿꞌ tsjoomnancue. Lꞌue tsꞌo̱o̱ⁿ na naⁿmꞌaⁿꞌ na jnda̱ tquiaaꞌ lꞌo̱o̱ya, cꞌomna yuu na mꞌaaⁿya ñꞌeⁿndyuꞌ. Ee quia ljoꞌcheⁿ nnda̱a̱ juu na matseitꞌmaaⁿꞌñenaꞌ ja na tquiaaꞌ na matseixmaⁿya. ");
INSERT INTO amuNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tsotya̱ya ꞌu na cwiluiindyuꞌ na matyꞌiomyanaꞌ, nnꞌaⁿ na laꞌxmaⁿna cantyja ꞌnaaⁿꞌ tsjoomnancue ticalaꞌno̱ⁿꞌna cantyja ꞌnaⁿꞌ, sa̱a̱ ja mawajnaⁿꞌa ꞌu ndoꞌ naⁿmꞌaⁿꞌ cwilaꞌno̱ⁿꞌna na ꞌu jñomꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Jnda̱ tꞌmo̱o̱ⁿya cantyja ꞌnaⁿꞌ nda̱a̱na, ndoꞌ mꞌmo̱o̱ⁿtya̱ya joꞌ nda̱a̱na. Luaaꞌ nntsꞌaa cha juu na mꞌaaⁿꞌ na candyaꞌ tsꞌomꞌ ja, mati nlaxmaⁿna juunaꞌ. Ndoꞌ mati nncꞌo̱o̱ⁿya ñꞌeⁿndye joona. ");
INSERT INTO amuNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jnda̱ na seineiⁿ Jesús ñꞌoommeiⁿꞌ nnom Tyꞌo̱o̱tsꞌom, mana jlueeⁿꞌeⁿ joꞌ joꞌ ñꞌeⁿndyô̱ jâ na cwilajomndyô̱ ñꞌeⁿñê. Teiꞌtyꞌio̱o̱ꞌâ tsjoꞌ Cedrón. Squia̱a̱yâ cwii joo yuu waa cwii ntjom, joꞌ joꞌ santyjo̱o̱yâ na tjaqueⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ndoꞌ Judas, juu xꞌiaayâ na tquiaa cwenta jom, mati mantyjii joꞌ joꞌ, ee majndye ndiiꞌ ñesaayâ joꞌ joꞌ ñꞌeⁿ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Quia joꞌ Judasꞌñeeⁿ, toꞌñoom cwii tmaaⁿꞌ sondaro ñꞌeⁿ ntꞌom nnꞌaⁿ na cwindyeꞌntjom nda̱a̱ ntyee na cwiluiitquiendye, ndoꞌ mañꞌeeⁿ ntꞌom nnꞌaⁿ tmaaⁿꞌ fariseos. Tjachom naⁿꞌñeeⁿ joꞌ joꞌ. Tyꞌechona lioochom ndoꞌ chom nlca ñꞌeⁿ lꞌo̱ tsꞌiaaⁿ ntiaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ndoꞌ Jesús, ncꞌe na mantyjeeⁿ chaꞌtso na mawaa xjeⁿ na nntjoom, tjacatjomñê naⁿꞌñeeⁿ. Taxꞌeeⁿ nda̱a̱na, matsoom: —¿ꞌÑeeⁿ juu cwilꞌueꞌyoꞌ? ");
INSERT INTO amuNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Tꞌo̱o̱na, jluena: —Cwilꞌua̱a̱yâ Jesús na jnaⁿ Nazaret. Matsoom: —Maja luaa joꞌ. Ndoꞌ mati Judas na tquiaa cwenta jom, mañꞌeⁿ ñequio naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Ndoꞌ quia tso Jesús: “Maja luaa joꞌ”, seilcweꞌntyaꞌnaꞌ joona hasta xjeⁿ nomtyuaacheⁿ tquiaandyena. ");
INSERT INTO amuNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Quia joꞌ taxꞌeeñenndaꞌ Jesús nda̱a̱na: —¿ꞌÑeeⁿ juu cwilꞌueꞌyoꞌ? Ndoꞌ joona tꞌo̱o̱nndaꞌna nnoom: —Jesús tsaⁿ na jnaⁿ Nazaret. ");
INSERT INTO amuNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Tꞌo̱ Jesús nda̱a̱na: —Jnda̱ tsjo̱o̱ya, maja luaa joꞌ. Joꞌ chii xeⁿ ja cwilꞌueꞌyoꞌ, caꞌndyeꞌyoꞌ naⁿmꞌaⁿ na nncꞌoona. ");
INSERT INTO amuNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Luaaꞌ tuii cha catseicanda̱a̱ꞌñenaꞌ ñꞌoom na tsoom quia seineiiⁿ nnom Tsotyeeⁿ. Tsoom: “Nnꞌaⁿ na jnda̱ tquiaaꞌ lꞌo̱o̱ya, meiⁿcwiindye joona tîtseicatsuuya.” ");
INSERT INTO amuNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Quia joꞌ Simón Pedro tjeiꞌñoomñê xjo na maleiñꞌoom. Seiquieeꞌñê tsꞌaⁿ na jndyu Malco. Tyjeeⁿ tsuaꞌqui tsaⁿꞌñeeⁿ ntyjaya. Juu tsaⁿꞌñeeⁿ mosooꞌ tyee na cwiluiitquieñe. ");
INSERT INTO amuNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Matso Jesús nnom Pedro: —Cwjaꞌndyuꞌnndaꞌ xjoꞌ quiiꞌ tjaⁿwaaꞌnaꞌ. ¿Aa matseitiuuꞌ na ticatyꞌiomyanaꞌ na catjo̱ⁿya nawiꞌ tꞌmaⁿ na seijndaaꞌñe Tsotya̱ya na nntjo̱ⁿ? ");
INSERT INTO amuNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Quia joꞌ sondaroꞌñeeⁿ ñequio capeitaⁿ na cwiluiitquieñe nda̱a̱na ñequio naⁿꞌñeeⁿ na cwindyeꞌntjom nda̱a̱ ntyee na cwiluiitquiendye nda̱a̱ nnꞌaⁿ judíos, tꞌuena Jesús, jlaꞌtyeⁿna jom. ");
INSERT INTO amuNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Tyꞌeñꞌomjndyeena jom na mꞌaaⁿ Anás, xeeⁿꞌ tyee na jndyu Caifás na cwiluiitquieñe chuꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Majuu Caifásꞌñeeⁿ jnda̱ seijno̱o̱ⁿꞌo̱ⁿ nꞌom ncꞌiaaⁿꞌaⁿ nnꞌaⁿ judíosꞌñeeⁿ na yaticheⁿ na cwii tsꞌaⁿ cueꞌ cwentaa chaꞌtsondye joona. ");
INSERT INTO amuNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Wendyô̱ jâ, nquii Simón Pedro ñꞌeⁿ ja Juan saantyjo̱o̱yâ nanqueⁿꞌ naⁿꞌñeeⁿ. Juu tyee na cwiluiitquieñe mawajnaⁿꞌaⁿ ja. Macweꞌ joꞌ tjo̱quia̱ꞌa tachꞌeⁿ waaꞌ tyeeꞌñeeⁿ xjeⁿ na tyꞌeñꞌomna Jesús joꞌ joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Sa̱a̱ Pedro tjawintyjeeⁿꞌeⁿ ꞌndyootsꞌa tatiom. Joꞌ chii ja na mawajnaaⁿꞌ tyee na cwiluiitquieñe, jluiiꞌa chꞌeⁿ, seina̱ⁿ nnom yuscu na machꞌee cwenta ꞌndyootsꞌaꞌñeeⁿ. Ndoꞌ juu tquiaa ñꞌoomꞌ na jndyoquieeꞌ Pedro tachꞌeⁿ wꞌaa. ");
INSERT INTO amuNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ndoꞌ taxꞌee yuscuꞌñeeⁿ nnom Pedro: —¿Aa nchii ꞌu cwii joona na matseijomñe ñꞌoom na mañequiaa tsaⁿmꞌaaⁿꞌ? Tꞌo̱ Pedro matsoom: —Nchii joꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ndoꞌ nnꞌaⁿ na cwindyeꞌntjom wꞌaaꞌñeeⁿ, ñequio ntꞌomcheⁿ nnꞌaⁿ na cwilꞌa cwenta watsꞌom, jnda̱ jlaꞌcwꞌaana ñoom. Meintyjeeꞌna na cwilaꞌwindyena, ee jeeⁿ teiⁿ. Ndoꞌ mati meintyjeeꞌ Pedro quiiꞌntaaⁿna, matseiwiñê ñꞌeⁿndyena. ");
INSERT INTO amuNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ndoꞌ nquii tyee na cwiluiitquieñe nda̱a̱ ntyee, taxꞌeeñe nnom Jesús ꞌñeeⁿ jâ nnꞌaⁿ na cwilajomndyô̱ ñꞌeⁿñê tsꞌiaaⁿ na machꞌeeⁿ, ndoꞌ mati chiuu waa ñꞌoom na tyoñequiaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Tꞌo̱ Jesús matsoom: —Ñequiiꞌcheⁿ ñequio na jndooꞌ nnꞌaⁿ tyotseina̱ⁿya. Ndoꞌ na tyoꞌmo̱o̱ⁿya nda̱a̱ nnꞌaⁿ judíos naquiiꞌ lanꞌom ꞌnaaⁿna ñequio watsꞌom tꞌmaⁿ yuu na cwitjomndyena. Meiⁿcwii ñꞌoom tyootseina̱ⁿ na cweꞌ ñeꞌwe ndyee tsꞌaⁿ ndii. ");
INSERT INTO amuNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Na mawaxeꞌ no̱o̱ⁿ, ¿chiuu na ticwaxeꞌ nda̱a̱ nnꞌaⁿ na jnda̱ ñejndyena ñꞌoom na mañequiaya ljoꞌ ñetsjo̱o̱? Naⁿꞌñeeⁿ nquiujndaaꞌndyena ñꞌoom na ñetꞌmo̱o̱ⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Ndoꞌ quia na jnda̱ tso Jesús ñꞌoomwaaꞌ, cwii naⁿꞌñeeⁿ na cwilꞌa cwenta watsꞌom na tyomꞌaⁿ joꞌ joꞌ tquiaa tsaⁿꞌñeeⁿ ndaꞌ watmeiⁿ jom. Tso tsaⁿꞌñeeⁿ nnoom: —¿Aa laaꞌtiꞌ mawꞌo̱ꞌ ꞌndyoo nquii tsꞌaⁿ na cwiluiitquieñe nda̱a̱ ntyee cwentaaya? ");
INSERT INTO amuNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Tꞌo̱ Jesús, matsoom: —Xeⁿ tia ñꞌoom na matsjo̱o̱, cwjiꞌyuuꞌndyuꞌ cantyja ꞌnaaⁿꞌ ñꞌomtiaꞌñeeⁿ, sa̱a̱ xeⁿ ñꞌoom na matyꞌiomyanaꞌ matseina̱ⁿ, tisꞌa na macwjaꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Quia joꞌ seicwanom Anás Jesús na ndi chuꞌtyeⁿñê lꞌo̱ Caifás, tyee na cwiluiitquieñe nda̱a̱ nnꞌaⁿ judíos. ");
INSERT INTO amuNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Yocheⁿ na meintyjeeꞌ Pedro ꞌndyoo chom na matseiwiñê, taꞌxꞌeena nnoom: —Ndoꞌ ꞌu jeꞌ, ¿aa nchii macwii nquiee naⁿꞌñeeⁿ na cwilajomndyoꞌ ñꞌeⁿñê? Sa̱a̱ jom tjeiꞌñê, tsoom: —Nchii joꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ndoꞌ joꞌ joꞌ mꞌaaⁿ cwii tsꞌaⁿ na machꞌee tsꞌiaaⁿ ꞌnaaⁿꞌ tyee na cwiluiitquieñe nda̱a̱ ntyee. Juu tsaⁿꞌñeeⁿ mannꞌaaⁿꞌaⁿ tsꞌaⁿ na tyjee Pedro tsuaꞌqui. Matso tsaⁿꞌñeeⁿ nnom Pedro: —¿Aa nchii ntyꞌiaya ꞌu na ñꞌeⁿꞌ ñꞌeⁿñê yuu waa ntjom? ");
INSERT INTO amuNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Sa̱a̱ Pedro tjeiꞌñennaaⁿꞌaⁿ. Ndoꞌ mañoomꞌ seixuaa caxtijndyo. ");
INSERT INTO amuNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Quia joꞌ tyꞌeñꞌom nnꞌaⁿ judíos Jesús, jnaⁿna waaꞌ Caifás, tquiena wꞌaa yuu na macꞌeⁿ gobiernom. Ndoꞌ ndicwaⁿ cwitsjoom xjeⁿꞌñeeⁿ. Sa̱a̱ ticꞌooquieꞌ nnꞌaⁿ judíos naquiiꞌ watsꞌiaaⁿ ꞌnaaⁿꞌ gobiernom cha tintsꞌaanaꞌ na tiljuꞌ laxmaⁿna, ee xeⁿ na ljoꞌ tixonquiaanaꞌ na wanaaⁿ na nlaꞌjomndyena xuee na cwitquiina catsmaⁿ chjoo. ");
INSERT INTO amuNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Joꞌ chii jluiꞌ Pilato quiiꞌ wꞌaaꞌñeeⁿ tjatseineiiⁿ nda̱a̱ nnꞌaⁿ. Tsoom: —¿Ljoꞌ ñꞌoom cwiqueⁿꞌyoꞌ nacjooꞌ tsaⁿsꞌamꞌaaⁿ? ");
INSERT INTO amuNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Joona tꞌo̱o̱na nnoom: —Xeⁿ nchii tsꞌaⁿ na tia tsꞌaⁿñe jom, xonquio̱o̱ñꞌo̱o̱ⁿyâ jom na mꞌaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ndoꞌ tso Pilato nda̱a̱ judíosꞌñeeⁿ: —Ncjoꞌyoꞌ catsaañꞌomꞌyoꞌ jom. Catuꞌxeⁿꞌyoꞌ jom cantyja ꞌnaaⁿꞌ ljeii ꞌnaⁿꞌyoꞌ na waa. Tꞌo̱o̱ naⁿꞌñeeⁿ nnoom: —Tjaaꞌnaⁿ najnda̱a̱ya na nlacua̱a̱ꞌâ tsꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Luaaꞌ tuii cha catseicanda̱a̱ꞌñenaꞌ ñꞌoom na seineiⁿ Jesús na tꞌmo̱o̱ⁿ cwaaⁿ cwii nnom na nntseicueeꞌnaꞌ jom. ");
INSERT INTO amuNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ndoꞌ tjaquieeꞌnndaꞌ Pilato quiiꞌ watsꞌiaaⁿ ꞌnaaⁿꞌaⁿ. Taxꞌeeñê nnom Jesús: —¿Aa ꞌu cwiluiindyuꞌ Rey cwentaa nnꞌaⁿ judíos? ");
INSERT INTO amuNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Tꞌo̱ Jesús, matsoom nnom: —¿Aa luaaꞌ matsuꞌ ee na matseiꞌno̱ⁿꞌ cheⁿnncuꞌ? Oo, ¿aa mꞌaⁿ ntꞌomcheⁿ nnꞌaⁿ na cwilue na ljoꞌ cantyja ꞌnaⁿya njomꞌ? ");
INSERT INTO amuNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Tꞌo̱ Pilato, matsoom: —Ja nchii tsꞌaⁿ judío ja. Manquiee nnꞌaⁿ ndyuaꞌ ñequio nnꞌaⁿ na cwiluiitquiendye nda̱a̱ ntyee ꞌnaⁿꞌyoꞌ, joona tquiana cwenta ꞌu lꞌo̱o̱ya. ¿Ljoꞌ saꞌ? ");
INSERT INTO amuNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Tꞌo̱ Jesús nnoom: —Juu na cwiluiindyo̱ na catsa̱ꞌntjo̱ⁿya, nchii cantyja ꞌnaaⁿꞌ tsjoomnancuewaañe na matseixmaⁿnaꞌ. Ee xeⁿ cwiluiiñenaꞌ na ljoꞌ, quia joꞌ nnꞌaⁿ na cwilaꞌjomndye ñꞌeⁿndyo̱ nlꞌana tiaꞌ cha na tiñequiaa tsꞌaⁿ cwenta ja luee nnꞌaⁿya nnꞌaⁿ judíos, sa̱a̱ nchii cantyja ꞌnaaⁿꞌ tsjoomnancue tseixmaⁿya na catsa̱ꞌntjo̱ⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ndoꞌ taxꞌee Pilato nnoom: —Quia joꞌ, ¿Aa cwiluiindyuꞌ rey? Tꞌo̱ Jesús, matsoom nnom: —Maxjeⁿ joꞌ cwiluiindyo̱. Macweꞌ joꞌ na tuiindyo̱ na jndyo̱o̱ tsjoomnancue, cha cwjiꞌyuuꞌndyo̱ ñꞌoom na mayuuꞌ. Ticwii cwii tsꞌaⁿ na matseijomñe ñꞌoom na mayuuꞌñeeⁿ, tsaⁿꞌñeeⁿ mandii ñꞌoom na mañequiaya. ");
INSERT INTO amuNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Taxꞌeeñe Pilato nnom Jesús: —¿Ljoꞌ joꞌ na cwiluiiñenaꞌ na mayuuꞌ? Ndoꞌ jnda̱ na tso Pilato na luaaꞌ, jluiꞌnnaaⁿꞌaⁿ jo nda̱a̱ nnꞌaⁿ judíos. Tsoom nda̱a̱na: —Tjaa jnaⁿ tseixmaⁿ tsaⁿmꞌaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Sa̱a̱ mawaa costumbre quiiꞌntaaⁿꞌyoꞌ na catseicandyaandyo̱ cwii pra̱so na nntio̱o̱ juu lueeꞌyoꞌ xuee na cwitquieꞌyoꞌ catsmaⁿ chjoo. Quia joꞌ ¿aa lꞌue nꞌomꞌyoꞌ na nntseicandyaandyo̱ juu rey na matseixmaⁿ na catsa̱ꞌntjom ꞌo? ");
INSERT INTO amuNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ndoꞌ jlaꞌxuaana, jluena: —Nchii tsaⁿmꞌaaⁿꞌ. Catseicandyaandyuꞌ Barrabás. Luaaꞌ ñꞌoom taⁿ naⁿꞌñeeⁿ. Ndoꞌ juu Barrabásꞌñeeⁿ, tsaⁿcanchꞌue joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Quia joꞌ sa̱ꞌntjom Pilato na catjaaꞌ sondaro Jesús. ");
INSERT INTO amuNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ndoꞌ sondaroꞌñeeⁿ lꞌana tsei nioom, jnda̱ chii tioomna juunaꞌ xqueⁿ Jesús, ndoꞌ jlaꞌcweena jom cwii liaatco colo catsiooꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ndoꞌ tyꞌentyjaaꞌ ntꞌom sondaroꞌñeeⁿ jom. Cweꞌ tyoncona, jluena: —Caluitꞌmaⁿndyuꞌ ꞌu Rey na cwiluiindyuꞌ na catsa̱ꞌntjomꞌ nnꞌaⁿ judíos. Ndoꞌ tyotmeiiⁿꞌna ndaꞌ watmeiⁿ nnoom. ");
INSERT INTO amuNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Jnda̱ joꞌ jluiꞌnndaꞌ Pilato jo nda̱a̱na. Matsoom: —Cantyꞌiaꞌyoꞌ, macwjiiꞌa jom jo nda̱a̱ꞌyoꞌ cha queⁿꞌyoꞌ cwenta meiⁿcwii jnaⁿ ticatseixmaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Xjeⁿꞌñeeⁿ jluiꞌ Jesús jo nda̱a̱na na ñjom tsei nioom xqueeⁿ, ndoꞌ cweⁿ liaatco colo catsiooꞌ. Tso Pilato nda̱a̱na: —Luaañe tsaⁿsꞌamꞌaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ndoꞌ ntyee na cwiluiitquiendye ñequio nnꞌaⁿ na cwilꞌa cwenta watsꞌom, quia ntyꞌiaana Jesús, jlaꞌxuaana: —Catyꞌiomꞌ jom tsꞌoomꞌnaaⁿ. Catyꞌiomꞌ jom tsꞌoomꞌnaaⁿ. Tꞌo̱ Pilato nda̱a̱na, matsoom: —Ncjoꞌyoꞌ catoꞌñoomꞌyoꞌ jom ndoꞌ catyꞌiomꞌyoꞌ jom tsꞌoomꞌnaaⁿ ee jnda̱ ljeiya na meiⁿcwii jnaⁿ ticatseixmaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Tꞌo̱o̱nndaꞌ nnꞌaⁿ judíos nnoom, jluena: —Mawaa ljeii na cwileiñꞌo̱o̱ⁿyâ, ndoꞌ cantyja ꞌnaaⁿꞌ juunaꞌ matsa̱ꞌntjomnaꞌ na cueeⁿꞌeⁿ ee na tsoom na Jnda Tyꞌo̱o̱tsꞌom cwiluiiñê. ");
INSERT INTO amuNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Jnda̱ na jndii Pilato ñꞌoommeiⁿꞌ, seicatyꞌuetinaꞌ jom. ");
INSERT INTO amuNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ndoꞌ tjaquieeꞌnnaaⁿꞌaⁿ watsꞌiaaⁿ ꞌnaaⁿꞌaⁿ. Taxꞌeeñê ꞌndyoo Jesús: —¿ꞌU yuu jnaⁿꞌyuꞌ? Sa̱a̱ Jesús meiⁿcwii ñꞌoom tîcꞌo̱o̱ⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Joꞌ chii matso Pilato nnoom: —¿Chiuu na ticꞌo̱ꞌ ꞌndyo̱? Ja waa na jndo̱ na nntseicandyaandyo̱ ꞌu, oo na nntyꞌio̱ⁿya ꞌu tsꞌoomꞌnaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Tꞌo̱ Jesús, matsoom: —Xeⁿ nchii Tyꞌo̱o̱tsꞌom tquiaa na jnduꞌ tjaa meiⁿcwii na nnda̱a̱ nntsaꞌ ñꞌeⁿndyo̱. Macweꞌ joꞌ juu tsꞌaⁿ na tio ja lꞌo̱ꞌ matꞌmaⁿti jnaaⁿꞌ mawaa. ");
INSERT INTO amuNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Quia na jndii Pilato ñꞌoomwaaꞌ, seijneiⁿ na nntseicandyaañê Jesús. Sa̱a̱ nnꞌaⁿ na cwiluiitquiendye nda̱a̱ nnꞌaⁿ judíos jlaꞌxuaana: —Xeⁿ nntseicandyaandyuꞌ tsaⁿmꞌaaⁿꞌ, tiñeꞌcatseixꞌiaaꞌndyuꞌ ñequio César, tsaⁿmaⁿtsꞌiaaⁿ tꞌmaⁿ, ee meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na ñeꞌcaluiiñe rey chaꞌna tsaⁿmꞌaaⁿꞌ, mawjaa nacjooꞌ César. ");
INSERT INTO amuNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Ndoꞌ jnda̱ na jndii Pilato ñꞌoommeiⁿꞌ, tjeiiⁿꞌeⁿ Jesús jo nda̱a̱na. Tjacjom ntio ꞌnaaⁿꞌaⁿ cwii joo na jndyu Nataa Ljo̱ꞌ yuu quicuꞌxeeⁿ ñꞌoom. Ñequio ñꞌoom na cwilaꞌneiⁿ nnꞌaⁿ judíos jndyunaꞌ Gabata. ");
INSERT INTO amuNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ndoꞌ juu xueeꞌñeeⁿ, xuee na cwilajndaaꞌndyo̱ jaa nnꞌaⁿ judíos na nntquia̱a̱ya catsmaⁿ chjoo. Tuii na luaaꞌ chaꞌna quiajmeiⁿꞌ. Quia joꞌ matso Pilato nda̱a̱ nnꞌaⁿ judíosꞌñeeⁿ: —Cantyꞌiaꞌyoꞌ, luaañe rey na tseixmaⁿ na nntsa̱ꞌntjom ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Sa̱a̱ naⁿꞌñeeⁿ jlaꞌxuaana: —Catseicueꞌ jom. Catseicueꞌ jom. Catyꞌiomꞌ jom tsꞌoomꞌnaaⁿ. Matso Pilato nda̱a̱na: —Nquii rey na nntsa̱ꞌntjom ꞌo, ¿aa maxjeⁿ catyꞌio̱ⁿya jom tsꞌoomꞌnaaⁿ? Ntyee na cwiluiitquiendye tꞌo̱o̱na, jluena: —Jâ tjaaꞌnaⁿ cwiicheⁿ rey na catsa̱ꞌntjom jâ, macanda̱ nquii César. ");
INSERT INTO amuNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Quia joꞌcheⁿ tquiaa Pilato Jesús nda̱a̱ naⁿꞌñeeⁿ na catyꞌioomna jom tsꞌoomꞌnaaⁿ. Ndoꞌ mana tyꞌeñꞌomna jom. ");
INSERT INTO amuNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Quia joꞌ tjachuu Jesús tsꞌoomꞌnaaⁿ cwentaaⁿꞌaⁿ cwii joo na jndyunaꞌ Tseiꞌxqueⁿ Tsꞌoo. Ñequio ñꞌoom na cwilaꞌneiⁿ nnꞌaⁿ judíos jndyunaꞌ Gólgota. ");
INSERT INTO amuNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ndoꞌ joꞌ joꞌ tyꞌioomna jom tsꞌoomꞌnaaⁿ. Ndoꞌ mati tyꞌioomna cwiicheⁿ we tsꞌaⁿ noomꞌnaaⁿ. Cwii cwii tsꞌaⁿ ñoom tsꞌoomꞌnaaⁿ na cwii ntyjaaⁿꞌaⁿ, ndoꞌ mꞌaaⁿñê xcwe. ");
INSERT INTO amuNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ndoꞌ sa̱ꞌntjom Pilato na teiljeii cwii ñꞌoom na tyꞌiom sondaro xqueⁿ tsꞌoomꞌnaaⁿ. Ñꞌoomꞌñeeⁿ matsonaꞌ: “Luaa Jesús, tsꞌaⁿ Nazaret na cwiluiiñe rey na matsa̱ꞌntjom nnꞌaⁿ judíos.” ");
INSERT INTO amuNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jndye nnꞌaⁿ judíos jlaꞌnaaⁿna ljeiiwaaꞌ, ee yuu na tyꞌioomna Jesús tsꞌoomꞌnaaⁿ manndyooꞌ nnom tsjoom. Juu ñꞌoomꞌñeeⁿ teiljeiinaꞌ ñequio ñꞌoom na cwilaꞌneiⁿ nnꞌaⁿ judíos, nnꞌaⁿ romanos, ndoꞌ nnꞌaⁿ griegos. ");
INSERT INTO amuNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Quia joꞌ jlaꞌneiⁿ ntyee na cwiluiitquiendye cwentaa nnꞌaⁿ judíos nnom Pilato. Jluena: —Tintseiljeiꞌ na tsaⁿmꞌaaⁿꞌ cwiluiiñê rey na nntsa̱ꞌntjoom jâ. Luaa catseiljeiꞌ: “Tsaⁿmꞌaaⁿꞌ matsoom: Ja cwiluiindyo̱ Rey na catsa̱ꞌntjo̱ⁿya nnꞌaⁿ judíos.” ");
INSERT INTO amuNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Tꞌo̱ Pilato nda̱a̱na, matsoom: —Cantyja na jnda̱ seiljeiya, mantyjati joꞌndyo. ");
INSERT INTO amuNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Jnda̱ na tyꞌioom sondaro Jesús tsꞌoomꞌnaaⁿ, quia joꞌ ñequieendye joona toꞌñoomna cwii cwii liaⁿꞌaⁿ. Mati toꞌñoomna liaatco ꞌnaaⁿꞌaⁿ na tuiinaꞌ na tjaa yuu ñjoomꞌnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Jluena nda̱a̱ ncꞌiaana: —Ticajndiiꞌndyo̱ juunaꞌ, xꞌiaa nncjaaya na nntyꞌiaaya ꞌñeeⁿ cwii jaa nncwantjom juunaꞌ. Luaaꞌ lꞌana cha catseicanda̱a̱ꞌñenaꞌ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na teiyo teiljeii nacjooꞌ libro Salmos. Matsonaꞌ: “Tquiana cwii cwii liaya nda̱a̱ ncꞌiaana, ndoꞌ tyꞌena xꞌiaa na taꞌntjomna liaya.” Ncꞌe na luaaꞌ matso ljeiiꞌñee, joꞌ chii lꞌa sondaro na ljoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ndoꞌ macañoomꞌ tsꞌoomꞌnaaⁿ na ñoom Jesús meintyjeeꞌ tsoñeeⁿ. Mati joꞌ joꞌ mꞌaaⁿ María tyjee tsoñeeⁿ, scuuꞌ Cleofas, ñequio María Magdalena. ");
INSERT INTO amuNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jnda̱ na ntyꞌiaaꞌ Jesús na joꞌ joꞌ meintyjeeꞌ tsoñeeⁿ na cañom ja na jeeⁿ candyaꞌ tsꞌoom, tsoom nnom: —ꞌU naⁿ, tsaⁿmꞌaaⁿꞌ nntseixmaaⁿ tiꞌjndaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Jnda̱ joꞌ matso Jesús no̱o̱ⁿ: —Luaañe tsoꞌndyoꞌ. Ndoꞌ majuu xjeⁿꞌñeeⁿ toꞌño̱ⁿya tsoñeeⁿ. Teixꞌa̱ya juu chaꞌcwijom cwii tsꞌaⁿ wꞌaya. ");
INSERT INTO amuNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jnda̱ tuii na luaaꞌ, ntyjii Jesús na jnda̱ jnda̱a̱ꞌ chaꞌtso cantyja ꞌnaaⁿꞌaⁿ. Joꞌ chii cha na nntseicanda̱a̱ꞌñenaꞌ chaꞌtso ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na teiljeii, matsoom: —Ñeꞌcꞌua ndaa. ");
INSERT INTO amuNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Ndoꞌ joꞌ joꞌ waa cwii xuaa na cwicañjom winom na ta̱. Quia joꞌ nchjeendye sondaroꞌñeeⁿ cwii ꞌnaⁿ na ya mawꞌanaꞌ winomꞌñeeⁿ. Chii tioona juunaꞌ nnom cwii tsꞌoom hisopo, jnda̱ chii tyꞌioomna juunaꞌ ꞌndyoo Jesús. ");
INSERT INTO amuNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ndoꞌ jnda̱ na tjaweꞌnaꞌ ꞌñom, matsoom: —Jnda̱ seicanda̱a̱ꞌñenaꞌ chaꞌtso cantyja ꞌnaⁿya. Jnda̱ chii seintyjanquiooñê xqueeⁿ. Tioom cantyja na wanoomꞌm lꞌo̱ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Xuee na cwilaꞌtyeⁿ nnꞌaⁿ judíos xuee pascua quia tyꞌioomna Jesús tsꞌoomꞌnaaⁿ. Nnꞌaⁿ na mꞌaⁿ nꞌiaaⁿ quiiꞌntaaⁿ nnꞌaⁿ judíos, ticalꞌue nꞌomna na nñom ndyee naⁿꞌñeeⁿ noomꞌnaaⁿ xuee na cwitaꞌjndyeena. Ee juu xueeꞌñeeⁿ jeeⁿ tꞌmaⁿ xuee tseixmaⁿnaꞌ quia cwilaꞌcueeꞌna catsmaⁿ chjoo. Joꞌ chii tyꞌecataⁿna nnom Pilato na catsa̱ꞌntjoom na catom ndeiꞌncꞌeeꞌ naⁿꞌñeeⁿ cha catseityuaaꞌnaꞌ na nncwjena, ndoꞌ cha tyuaaꞌ nntaaꞌndyena naⁿꞌñeeⁿ noomꞌnaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Joꞌ chii sondaroꞌñeeⁿ tyꞌecatomna ndeiꞌncꞌee tsꞌaⁿ najndyee, ndoꞌ majoꞌti lꞌana cwiicheⁿ tsaⁿꞌñeeⁿ na tyꞌioomna jom tsꞌoomꞌnaaⁿ cwiicheⁿ ntyjaaꞌ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Sa̱a̱ quia na tyꞌentyjaaꞌna Jesús, jliuna na jnda̱ tueeⁿꞌeⁿ. Tatîcatomna ndeiꞌncꞌeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Sa̱a̱ meiiⁿ na ljoꞌ cwii sondaroꞌñeeⁿ tjaaꞌñe lantsa tseiꞌntsqueeⁿꞌeⁿ. Mañoomꞌ jluiꞌ niomꞌ ñequio ndaa. ");
INSERT INTO amuNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ja ntyꞌia na ljoꞌ tuii, ndoꞌ macwjiꞌyuuꞌndyo̱. Calaꞌno̱ⁿꞌyoꞌ na mayuꞌa ñꞌoom matseina̱ⁿ cha mati nnda̱a̱ nlaꞌyuꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ee nmeiiⁿꞌ tuii cha na catseicanda̱a̱ꞌñenaꞌ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na teiyo teiljeiinaꞌ nacjooꞌ libro Salmos. Matsonaꞌ: “Meiⁿcwii tseiiⁿꞌeⁿ tîcatom.” ");
INSERT INTO amuNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ndoꞌ mati waa cwiicheⁿ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na teiljeiinaꞌ na matsonaꞌ: “Nntyꞌiaana nquii tsꞌaⁿ na jlaꞌcjoondyena tseiꞌntsquieeꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Jnda̱ teinom nmeiⁿꞌ, José tsꞌaⁿ na jnaⁿ Arimatea, tjacaaⁿ nnom Pilato na nñequiaa tsaⁿꞌñeeⁿ seiꞌtsꞌo ꞌnaaⁿꞌ Jesús. Joséꞌñeeⁿ matseijomñê ñꞌoom na mañequiaa Jesús sa̱a̱ cweꞌ ntyꞌiu ee nquiaⁿꞌaⁿ nnꞌaⁿ judíos. Pilato tquiaaⁿ ñꞌoomꞌm. Joꞌ chii José tjaaⁿ, tjacꞌoom seiꞌtsꞌo ꞌnaaⁿꞌ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ñꞌeⁿ Nicodemo, tsaⁿ na tja na mꞌaaⁿ Jesús cwii teijaaⁿ. Jom tjañꞌoom chaꞌna ntquiuu nchooꞌ nqui kilos ncheⁿꞌ na tjoomꞌnaꞌ mirra ñequio áloes na nntyꞌoomndyena juunaꞌ seiꞌtsꞌo ꞌnaaⁿꞌ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Quia joꞌ toꞌñoomna tsꞌoo Jesús, tyꞌoomndyena ncheⁿꞌ cachiꞌñeeⁿ liaa na jndyunaꞌ lino. Jnda̱ chii jlaꞌtyjoondyena liaaꞌñeeⁿ jom. Ee luaaꞌ waa costumbre ꞌnaaⁿ nnꞌaⁿ judíos na cwityꞌiuuna lꞌoo. ");
INSERT INTO amuNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Yuu na tyꞌioom nnꞌaⁿ Jesús tsꞌoomꞌnaaⁿ waa cwii ntjom. Naquiiꞌ ntjomꞌñeeⁿ waa cwii tseiꞌtsuaa xco, na meiⁿjom ndiiꞌ tyoojaantyꞌiuuꞌñe tsꞌoo. ");
INSERT INTO amuNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Ndoꞌ ncꞌe na mawaa xjeⁿ na nncꞌooquieꞌ nnꞌaⁿ judíos xuee sauroꞌ, joꞌ chii joꞌ joꞌ tyꞌecatjaaꞌndyena tsꞌoo Jesús. Ee tseiꞌtsuaaꞌñeeⁿ nndyooꞌ waanaꞌ yuu na tyꞌioom nnꞌaⁿ Jesús tsꞌoomꞌnaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Jaancoo xuee neiⁿncoꞌ, xuee najndyee smaⁿna, tyjeeꞌcañoom María Magdalena tseiꞌtsuaaꞌñeeⁿ, ndicwaⁿ jaaⁿcheⁿ. Ntyꞌiaaⁿꞌaⁿ na jnda̱ teindyo̱ tsjo̱ꞌ na ñejñoom ꞌndyoo juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Quia joꞌ jleinoom, tjaaⁿ yuu na mꞌaaⁿ ja na jeeⁿ candyaꞌ tsꞌom Jesús ñꞌeⁿ Simón Pedro. Matsoom nda̱a̱yâ: —Jnda̱ tjeiiꞌna seiꞌtsꞌo ꞌnaaⁿꞌ Ta Jesús tseiꞌtsuaa, meiⁿ ticaliuuyâ yuu tqueⁿna juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Quia joꞌ ja ñequio Pedro saayâ, squia̱a̱yâ yuu waa tseiꞌtsuaa. ");
INSERT INTO amuNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Ñeꞌcwi saayâ, jleino̱o̱ⁿyâ, sa̱a̱ jndeiiti jleino̱o̱ⁿ, nchiiti Pedro. Joꞌ chii ja tua̱jndya̱a̱ya yuu waa tseiꞌtsuaa. ");
INSERT INTO amuNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Seintyjanquiondyo̱, ntyꞌiaya liaa na ñechuꞌtyjooñe Jesús meindyuaanaꞌ naquiiꞌ tseiꞌtsuaa, sa̱a̱ tîcjo̱quia̱ꞌa. ");
INSERT INTO amuNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Ndoꞌ quia na tueeꞌcañoom Simón Pedro joꞌ joꞌ, na cwijndyontyjo̱o̱ⁿ naxa̱ⁿꞌa, jom tjaqueⁿꞌeⁿ hasta naquiiꞌcheⁿ tseiꞌtsuaa. Mati ntyꞌiaaⁿꞌaⁿ joo liaaꞌñeeⁿ na ñechuꞌtyjooñe Jesús meindyuaanaꞌ joꞌ joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Ndoꞌ juu liaa na ñeta̱ꞌ xqueⁿ Jesús ljeiiⁿ na ticwacatyeeⁿnaꞌ ñequio ntꞌomcheⁿ liaa na ñechuꞌtyjooñê. Wacatyeeⁿnaꞌ na ñenquiinaꞌ, chiꞌlcwiinaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Quia joꞌ mati ja na matseijomndyo̱ ñꞌeⁿ Jesús, tjo̱quia̱ꞌa naquiiꞌcheⁿ tseiꞌtsuaa. Ntyꞌiaya na ljoꞌ waa, ndoꞌ quia ljoꞌcheⁿ seiyuꞌa. Ee meiiⁿ na ja tua̱jndya̱a̱ joꞌ joꞌ, sa̱a̱ tîcjo̱quia̱ꞌa na mandiñoomꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ee xjeⁿꞌñeeⁿ ndicwaⁿ tjo̱o̱cheⁿ nlaꞌno̱o̱ⁿꞌâ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na teiljeii na matsonaꞌ maxjeⁿ nñequiaa Tyꞌo̱o̱tsꞌom na nncwandoꞌxco Jesús xeⁿ jnda̱ tueꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Quia joꞌ wendyô̱ jâ na cwilajomndyô̱ ñꞌeⁿñê jluiiꞌâ tseiꞌtsuaa. Saalcwa̱a̱ꞌâ na waa wꞌaayâ. ");
INSERT INTO amuNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Sa̱a̱ María meintyjeeꞌcheeⁿ nacañoomꞌ tseiꞌtsuaa, matyꞌioom. Yocheⁿ na matyꞌioom joꞌ joꞌ, seintyjanquioñê na ntyꞌiaaⁿꞌaⁿ naquiiꞌcheⁿ tseiꞌtsuaa. ");
INSERT INTO amuNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Joꞌ joꞌ ntyꞌiaaⁿꞌaⁿ we ángeles, jeeⁿ canchiiꞌ liaa cweeꞌna. Cwii tsaⁿꞌñeeⁿ wacatyeeⁿ jo yuu na ñetꞌoom xqueⁿ Jesús, ndoꞌ xꞌiaaⁿꞌaⁿ wacatyeeⁿ jo yuu ñetꞌom ncꞌee Jesús. ");
INSERT INTO amuNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ndoꞌ taꞌxꞌeena nnoom: —¿Chiuu ꞌu tsꞌaⁿ na matyꞌiooꞌ? Tsoom nda̱a̱na: —Jnda̱ tyꞌeñꞌomna nqueⁿ na cwiluiiñê na matsa̱ꞌntjoom ja, meiⁿ ticaljeiiya yuu tyꞌequeⁿna jom. ");
INSERT INTO amuNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Jnda̱ ncue na tsoom na luaaꞌ, quia joꞌ teiqueeⁿ, ntyꞌiaaⁿꞌaⁿ na meintyjeeꞌ Jesús joꞌ joꞌ, sa̱a̱ ticwajnaⁿꞌaⁿ na nquii Jesús joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Tso Jesús nnoom: —ꞌU yuscu, ¿chiuu na jeeⁿ matyꞌiooꞌ? ¿ꞌÑeeⁿ juu malꞌueꞌ? Ndooꞌ ntyjeeⁿ tsꞌaⁿ na machꞌee cwenta ntjomꞌñeeⁿ juu Jesús. Joꞌ chii matsoom nnom: —Aa ndiꞌ ta, xeⁿ ꞌu tjañꞌoomꞌ jom, catsuꞌ no̱o̱ⁿ yuu tjaꞌqueⁿꞌ jom, quia joꞌ nncjo̱cꞌo̱ⁿya jom. ");
INSERT INTO amuNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Quia joꞌ matso Jesús: —María. Jnda̱ na jñeeⁿ na tjeiꞌ Jesús xueⁿꞌeⁿ, quia joꞌ teiqueeⁿ. Tꞌo̱o̱ⁿ ñequio ñꞌoom na cwilaꞌneiⁿ nnꞌaⁿ judíos. Matsoom: —Raboni. Ñꞌoomꞌñeeⁿ matsonaꞌ tsꞌaⁿ na maꞌmo̱ⁿ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom nda̱a̱ ncꞌiaaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Matso Jesús nnoom: —Tintꞌuiiꞌtyeⁿꞌ ja, ee tyoocjo̱waa na mꞌaaⁿ Tsotya̱ya. Sa̱a̱ cjaꞌ na mꞌaⁿ tiꞌncꞌiaya na cwiteijndeiina ja, catseicandiiꞌ na majo̱waa na mꞌaaⁿ Tsotya̱ya na mati cwiluiiñê Tsotyeꞌyoꞌ, na mꞌaaⁿ Tyꞌo̱o̱tsꞌomya ndoꞌ Tyꞌo̱o̱tsꞌom cwentaꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Quia joꞌ tja María Magdalena, tjatseicañeeⁿ jâ na cwilajomndyô̱ ñꞌeⁿ Jesús. Juu María tꞌmo̱o̱ⁿ nda̱a̱yâ ñꞌoom na jnda̱ seineiⁿ Jesús nnoom, ndoꞌ na jnda̱ ntyꞌiaaⁿꞌaⁿ juu. ");
INSERT INTO amuNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ndoꞌ mañejuu tmaaⁿ xuee neiⁿncoꞌñeeⁿ, jâ nnꞌaⁿ na tꞌmaⁿ Jesús tjomndyô̱ na ñeꞌnaaⁿꞌ. Jlaꞌcata̱ꞌtya̱a̱ⁿyâ ndyueelꞌa ncꞌe na nquiaayâ ncꞌiaaya nnꞌaⁿ judíos. Xjeⁿꞌñeeⁿ tyjeeꞌcañoom na mꞌaaⁿyâ, teintyjeeⁿꞌeⁿ xcwe quiiꞌntaaⁿyâ. Matsoom: —Cꞌoomꞌyoꞌ na tjaa ñomtiuu. ");
INSERT INTO amuNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Ndoꞌ jnda̱ tsoom na luaaꞌ, tꞌmo̱o̱ⁿ lꞌo̱o̱ⁿ ñequio tseiꞌntsqueeⁿꞌeⁿ nda̱a̱yâ. Ndoꞌ tquiaanaꞌ na jeeⁿ neiiⁿyâ na ntyꞌiaanndaaꞌâ jom. ");
INSERT INTO amuNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ndoꞌ tsoom nda̱a̱yâ: —Quiaa Tyꞌo̱o̱tsꞌom na tjaa ñomtiuu laxmaⁿꞌyoꞌ. Chaꞌxjeⁿ jnda̱ jñoom ja ñequio ñꞌoom naya ꞌnaaⁿꞌaⁿ malaaꞌtiꞌ majño̱o̱ⁿya ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ndoꞌ quia na jnda̱ tsoom na luaaꞌ, tjoomꞌm jndye nda̱a̱yâ. Tsoom: —Catoꞌñoomꞌyoꞌ Espíritu Santo. ");
INSERT INTO amuNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ꞌÑeeⁿ joo na cwilatꞌmaⁿ nꞌomꞌyoꞌ jnaaⁿ, mati Tyꞌo̱o̱tsꞌom matseitꞌmaⁿ tsꞌoom jnaaⁿna. Sa̱a̱ ꞌñeeⁿ joo na ticalacandyaandyoꞌ cantyja ꞌnaaⁿ jnaaⁿ, maxjeⁿ tyeⁿ jnda̱ tꞌuii jnaaⁿna joona. ");
INSERT INTO amuNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Xjeⁿ na jndyojndyee Jesús, juu Tomás, cwii jâ na cwilajomndyô̱ tsꞌiaaⁿ na machꞌeeⁿ ticꞌoomñê, jom tsaⁿ na cwilꞌuuyâ catyeⁿnquiee. ");
INSERT INTO amuNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Joꞌ chii ntꞌomndyô̱ jâ lꞌuuyâ nnom Tomás: —Jnda̱ ntyꞌiaayâ nquii Jesús. Sa̱a̱ tꞌo̱o̱ⁿ nda̱a̱yâ: —Ja xeⁿ ticantyꞌiano̱o̱ⁿ ꞌnaaⁿ yuu na tjaa clavos nꞌomlꞌo̱o̱ⁿ, ndoꞌ na nncwjaaꞌndyo̱ nnomtsꞌo̱o̱ yuu na jlaꞌcjoondye clavos, ndoꞌ xeⁿ ticantquieendyo̱ jndaꞌtsꞌo̱o̱ tseiꞌntsqueeⁿꞌeⁿ maxjeⁿ xocatseiyuꞌa na wandoꞌxcoom. ");
INSERT INTO amuNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Jnda̱ ñeeⁿ xuee na tuii na luaaꞌ quia joꞌ jâ nnꞌaⁿ na tꞌmaⁿ Jesús na calajomndyô̱ ñꞌeⁿñê tyomꞌaaⁿnndaaꞌâ wꞌaaꞌñeeⁿ, ndoꞌ quia ljoꞌcheⁿ mati ñꞌeⁿ Tomás. Ndoꞌ tyjeeꞌcañoom Jesús naquiiꞌ ntaaⁿyâ na ndi ta̱ꞌ ndyueelꞌa. Tsonnaaⁿꞌaⁿ nda̱a̱yâ: —Cꞌomꞌyoꞌ na tjaa ñomtiuu. ");
INSERT INTO amuNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Mañoomꞌ matsoom nnom Tomás: —Catyꞌiomꞌ nnomtsꞌo̱ꞌ tsꞌom tsꞌo̱o̱ya, ndoꞌ cantyꞌiaꞌ lꞌo̱o̱ya. Ndoꞌ cwjaaꞌndyuꞌ jndaꞌtsꞌo̱ꞌ tseiꞌntsquieeya. Tantsaꞌ na tiñeꞌcatseiyuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tꞌo̱ Tomás nnoom, tso: —Jeeⁿ ꞌu Ta, ꞌu cwiluiindyuꞌ Tyꞌo̱o̱tsꞌomya ndoꞌ nquii na matsa̱ꞌntjom ja. ");
INSERT INTO amuNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Matso Jesús nnoom: —ꞌU Tomás, cweꞌ na jeꞌ jnda̱ ntyꞌiaꞌnjomꞌ ja, joꞌ na matseiꞌyuꞌ. Matioꞌnaaⁿñe Tyꞌo̱o̱tsꞌom nnꞌaⁿ na cwilaꞌyuꞌ ñꞌeⁿndyo̱ meiiⁿ tyoontyꞌiaanda̱a̱na ja. ");
INSERT INTO amuNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jâ nnꞌaⁿ na tꞌmaⁿ Jesús na calajomndyô̱ ñꞌeⁿñê jndo̱o̱ꞌnda̱a̱yâ na jndye ntꞌomcheⁿ tsꞌiaaⁿ sꞌaaⁿ na tixocaluii na cweꞌ meiⁿquia tsꞌaⁿ nntsꞌaa. Joonaꞌ tîcwiljeii nacjooꞌ librowaa. ");
INSERT INTO amuNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Sa̱a̱ nmeiiⁿ matseiljeiya cha na calayuꞌyoꞌ na juu Jesús cwiluiiñê Cristo, ndoꞌ Jnda Tyꞌo̱o̱tsꞌom. Matseiljeiya nmeiiⁿ cha cantyja na cwilayuꞌyoꞌ ñꞌeⁿñê nntoꞌñoomꞌyoꞌ na ticantycwii na cwitandoꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Jnda̱ tuii nmeiⁿꞌ, Jesús seicaꞌmo̱ⁿñennaaⁿꞌaⁿ nda̱a̱ jâ nnꞌaⁿ na cwilajomndyô̱ ñꞌeⁿñê. Sꞌaaⁿ na ljoꞌ yocheⁿ na mꞌaaⁿyâ xndyaaꞌ ndaaluee Tiberias. Luaa waa na seicaꞌmo̱ⁿñê nda̱a̱yâ. ");
INSERT INTO amuNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ñeꞌnaaⁿꞌ mꞌaaⁿ Simón Pedro ñequio Tomás tsaⁿ na cwilꞌuuyâ catyeⁿnquiee, ñequio Natanael na jnaⁿ Caná tsꞌo̱ndaa Galilea, ñequio wendyô̱ jâ ntseinda Zebedeo ñequio ntꞌomcheⁿ ncꞌiaayâ na tꞌmaⁿ Jesús na calaꞌjomndyô̱ ñꞌeⁿñê. ");
INSERT INTO amuNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Tso Simón Pedro nda̱a̱yâ: Jo̱cwjiiꞌa catscaa. Lꞌuuyâ nnoom: —Cwitsaayâ ñꞌeⁿndyuꞌ. Quia joꞌ saayâ, tuo̱o̱yâ tsꞌom wꞌaandaa. Sa̱a̱ juu tsjomꞌñeeⁿ meiⁿcwii catscaa tîcatjeiiꞌâ. ");
INSERT INTO amuNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ndoꞌ jnda̱ wjaawixuee, quia joꞌ tyjeeꞌcañoom Jesús jâ. Meintyjeeⁿꞌeⁿ ꞌndyoo ndaaluee, sa̱a̱ tîcalaꞌno̱o̱ⁿꞌâ na manqueⁿ joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Quia joꞌ taxꞌeeñê nda̱a̱yâ: —ꞌO tyja̱no̱ⁿ, ¿aa jnda̱ tjeiꞌyoꞌ calcaa? Tꞌo̱o̱yâ nnoom: —Tjaaꞌnaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Matsoom nda̱a̱yâ: —Catueꞌyoꞌ tsquiꞌ ꞌnaⁿꞌyoꞌ ntyjaaꞌ wꞌaandaa ntyjaya, quia ljoꞌcheⁿ nliuꞌyoꞌ calcaa. Ndoꞌ tua̱a̱ꞌâ juunaꞌ joꞌ joꞌ, jnda̱ joꞌ tileicanda̱a̱ nntjeiiꞌâ juunaꞌ cweꞌ ee jeeⁿcheⁿ ndyaꞌ jndye calcaa chuunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Quia joꞌ ja na jeeⁿ wiꞌ tsꞌom Jesús, tsjo̱o̱ya nnom Pedro: —Juu Ta Jesús luaaꞌ. Quia jñeeⁿ na ljoꞌ tsjo̱o̱, tcweeⁿ liaa maseta, ee jnda̱ tjeiiⁿꞌeⁿ juunaꞌ na machꞌeeⁿ tsꞌiaaⁿ. Jnda̱ joꞌ tjuꞌñê tsꞌom ndaaluee, mana tueⁿꞌeⁿ tyuaatcwii. ");
INSERT INTO amuNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ndoꞌ ntꞌomndyô̱ jâ tquio̱ntyjo̱o̱yâ chaꞌna wenꞌaaⁿ nchooꞌ nqui ncꞌaa ñꞌeⁿ wꞌaandaa chjoo, chii squia̱a̱yâ tyuaatcwii. Ndoꞌ saantyjaandyô̱ tsquiꞌ na tooꞌ ñjom calcaa. ");
INSERT INTO amuNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Quia na jnda̱ squia̱a̱yâ tyuaatcwii, ntyꞌiaayâ ñoom na cwico, ndoꞌ ljo catscaa ñꞌeⁿ tyooꞌ cjoo ñoomꞌñeeⁿ, cwineiiⁿnaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Matso Jesús nda̱a̱yâ: —Quiochoꞌyoꞌ ntꞌom calcaa na jnda̱ tjeiꞌyoꞌ jeꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Quia joꞌ tuo̱ Simón Pedro tsꞌom wꞌaandaa chjoo. Jndyoñꞌoom tsquiꞌ tyuaatcwii na tooꞌnaꞌ ñjom calcaa ntꞌmaⁿ. Tueꞌntyjo̱ jooyooꞌ cwii siaⁿnto waljooꞌ wenꞌaaⁿ nchooꞌ nqui nchooꞌ ndyeeyoꞌ. Ndoꞌ meiiⁿ na jeeⁿ ndyaꞌ jndye calcaaꞌñeeⁿ, sa̱a̱ tîcatyꞌiooꞌ tsquiꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Matso Jesús nda̱a̱yâ: —Quioꞌyoꞌ nlcwaꞌyoꞌ. Sa̱a̱ meiⁿcwiindyô̱ jâ na cwilajomndyô̱ ñꞌeⁿñê, ticꞌoom na tꞌmaⁿ tsꞌom na nncwaxꞌee nnoom, ¿ꞌÑeeⁿ ꞌu? Ee manquiuuyaayâ na manquii Ta Jesús joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Quia joꞌ seicandyooꞌñe Jesús nacañoomyâ. Toꞌñoom tyooꞌ ñꞌeⁿ catscaa. Tquiaaⁿ joonaꞌ nda̱a̱yâ. ");
INSERT INTO amuNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Cantyjati na tquiaa Tyꞌo̱o̱tsꞌom na tandoꞌxcoom na tueeⁿꞌeⁿ, luaaꞌ jnda̱ ndyee ndiiꞌ na seicaꞌmo̱ⁿñê nda̱a̱ jâ na cwilajomndyô̱ ñꞌeⁿñê tsꞌiaaⁿ na machꞌeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ndoꞌ quia na jnda̱ tcwaaꞌâ taxꞌee Jesús ꞌndyoo Simón Pedro. Tsoom: —ꞌU Simón jnda Jonás, ¿aa ja jndati ntyjiꞌ nchiiti tsꞌiaaⁿmeiⁿꞌ na macheꞌ? Tꞌo̱o̱ⁿ, matsoom: —Mayuuꞌ Ta, ntyjiꞌ na ꞌu wiꞌ tsꞌo̱o̱ⁿya. Matso Jesús nnoom ñꞌoom na wjaañoomꞌ: —Quiaaꞌ na nlcwaꞌ canmaⁿ nchꞌu cwentaya. ");
INSERT INTO amuNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jnda̱ we ndiiꞌ taxꞌeennaaⁿꞌaⁿ nnom Pedro: —ꞌU Simón, jnda Jonás, ¿aa mayuuꞌ na jndati ntyjiꞌ ja? Tꞌo̱ Pedro: —Mayuuꞌ Ta, ntyjiꞌ na wiꞌ tsꞌo̱o̱ⁿya ꞌu. Tsonndaꞌ Jesús ñꞌoom na wjaañoomꞌ: —Cateixeꞌ canmaⁿ cwentaya. ");
INSERT INTO amuNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Na jnda̱ ndyee ndiiꞌ taxꞌeeñê nnom Pedro. Tsoom: —ꞌU Simón, jnda Jonás, ¿aa wiꞌ tsꞌomꞌ ja? Seichjooꞌnaꞌ tsꞌom Pedro na jnda̱ ndyee ndiiꞌ mawaxꞌeeñe Jesús: “¿Aa wiꞌ tsꞌomꞌ ja?” Quia joꞌ tꞌo̱o̱ⁿ, tsoom: —Ta, chaꞌtso matseiꞌno̱ⁿꞌ. Ndoꞌ mantyꞌiaꞌnchaaꞌndyuꞌ na wiꞌ tsꞌo̱o̱ⁿya ꞌu. Matso Jesús nnoom: —Cateixeꞌ canmaⁿ cwentaya. ");
INSERT INTO amuNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ñꞌoom na mayuuꞌcheⁿ matseicandiiya ꞌu. Quia ñetꞌoomꞌ na xcwe tsꞌaⁿndyuꞌ, seijndaaꞌndyuꞌ na nntsaꞌ meiⁿljoꞌcheⁿ na lꞌue tsꞌomꞌ, ndoꞌ tjaa ꞌñeeⁿ juu na nntseitsaaⁿꞌñe ꞌu yuu na ñeꞌcjaꞌ. Sa̱a̱ quia na jnda̱ teincꞌuaaꞌndyuꞌ nntseiliuuꞌ lꞌo̱ꞌ ndoꞌ nntseityeⁿ cwiicheⁿ tsꞌaⁿ ꞌu na nncjaañꞌoom ꞌu yuu na tiñeꞌcjaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Luaaꞌ ñꞌoom na tso Jesús na maꞌmo̱o̱ⁿ ljoꞌ cwii nnom na nntsꞌaanaꞌ na nncueꞌ Pedro, na cantyja ꞌnaaⁿꞌ joꞌ nntseitꞌmaaⁿꞌñenaꞌ Tyꞌo̱o̱tsꞌom. Quia na jnda̱ seineiiⁿ ñꞌoommeiⁿꞌ, matsoom: —ꞌU candyoꞌntyjo̱ꞌ naxa̱ⁿꞌa. ");
INSERT INTO amuNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Teiqueⁿ Pedro ndoꞌ ntyꞌiaaⁿꞌaⁿ na jo̱ntyjo̱ ja na candyaꞌ tsꞌom Jesús ja, ndoꞌ maja na seintyjo̱ndyo̱ jo ndoꞌ jñaaⁿ quia na tcwaaꞌâ teijaaⁿꞌñeeⁿ ñꞌeⁿñê juu xjeⁿ na taxꞌa̱ya ꞌñom: “Ta, ¿ꞌñeeⁿ juu tsꞌaⁿ na nñequiaa cwenta ꞌu?” ");
INSERT INTO amuNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ndoꞌ quia ntyꞌiaaꞌ Pedro na jo̱ntyjo̱, taxꞌeeñê ꞌndyoo Jesús. Tsoom: —Ta, ndoꞌ tsaⁿmꞌaaⁿꞌ jeꞌ, ¿ljoꞌ cwii nnom na nntjoom? ");
INSERT INTO amuNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Tꞌo̱ Jesús nnoom: —Xeⁿ lꞌue tsꞌo̱o̱ⁿ na ñecꞌoom hasta quia nndyo̱o̱nndaꞌa, ¿ljoꞌ machꞌeenaꞌ ꞌu? ꞌU candyoꞌntyjo̱ꞌ naxa̱ⁿꞌa. ");
INSERT INTO amuNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Quia joꞌ tꞌom ñꞌoom quiiꞌntaaⁿ nnꞌaⁿ na cwilaꞌyuꞌ na tso Jesús na xocꞌio̱ya. Sa̱a̱ nchii matsoom na xocꞌio̱. Tomti tsoom: “Xeⁿ lꞌue tsꞌo̱o̱ⁿ na ñecꞌoom hasta quia nndyo̱o̱nndaꞌa, ¿ljoꞌ machꞌeenaꞌ ꞌu, Pedro?” ");
INSERT INTO amuNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Maja luaa joꞌ. Maja matseiljeiya ñꞌoommeiⁿꞌ. Ndoꞌ joo ñꞌoom na macwjiꞌyuuꞌndyo̱, ñꞌoom na mayuuꞌ joꞌ, nchii cweꞌ na maquiuꞌnnꞌaⁿya. ");
INSERT INTO amuNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ndoꞌ jndye ntꞌomcheⁿ tsꞌiaaⁿ maniom na sꞌaa Jesús. Mꞌaaⁿꞌ tsꞌo̱o̱ⁿ xeⁿ nleiljeii cwii ndoꞌ cwii joonaꞌ, machꞌeenaꞌ ntyjii na xocwijndeii tsjoomnancue libros na nluii na nleiljeii joo joꞌ. Mantyjati luaaꞌndyo.");
INSERT INTO amuNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","ꞌU ta Teófilo, tsom na seiljeijndya̱a̱ na seicwano̱ⁿ na mꞌaaⁿꞌ seicandiiya ꞌu cantyja chaꞌtso na tyochꞌee Jesús ndoꞌ na tyoꞌmo̱o̱ⁿ hasta xuee na tjawaaⁿ cañoomꞌluee. Cwii tjo̱o̱cheⁿ na nncjaawaaⁿ tjeiiꞌñê apóstoles. Ndoꞌ cantyja ꞌnaaⁿꞌ Espíritu Santo tꞌmo̱o̱ⁿ nda̱a̱ naⁿꞌñeeⁿ chiuu nlꞌana. ");
INSERT INTO amuNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jnda̱ na tueeⁿꞌeⁿ, tandoꞌnnaaⁿꞌaⁿ, teitquiooꞌñê nda̱a̱na ñequio jndye nnom na tꞌmo̱ⁿnaꞌ na wandoꞌxcoom. Wenꞌaaⁿ xuee tyomꞌaaⁿ na ntyꞌiaana jom. Ndoꞌ seineiiⁿ nda̱a̱na cantyja ꞌnaaⁿꞌ na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Yocheⁿ na tyomꞌaaⁿ ñꞌeⁿndyena sa̱ꞌntjoom na ticaluiꞌna tsjoom Jerusalén. Tsoom nda̱a̱na: —Cwindoꞌyoꞌ hasta xeⁿ jnda̱ seicanda̱a̱ꞌñenaꞌ ñꞌoom na tqueⁿtyeⁿ Tsotya̱ya na tsoom na nndyo Espíritu Santo chaꞌxjeⁿ jnda̱ ñejndyeꞌyoꞌ na tsjo̱o̱ nda̱a̱ꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ee Juan tyotseitsꞌoomñê nnꞌaⁿ ñequio ndaatioo, sa̱a̱ ꞌo tajndye xuee ndoꞌ njñom Tyꞌo̱o̱tsꞌom Espíritu Santo naquiiꞌ nꞌomꞌyoꞌ. Luaaꞌ waa na nleitsꞌoomndyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Quia na tyomꞌaⁿ naⁿꞌñeeⁿ ñꞌeⁿ Jesús taꞌxꞌeena nnoom, jluena: —Ta, ¿aa jeꞌ na nntsaꞌ na catsa̱ꞌntjomndyenndaꞌ nnꞌaⁿ Israel? ");
INSERT INTO amuNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Tsoom nda̱a̱na: —Tsotya̱ya waa najndeii na matseixmaaⁿ na matseijndaaꞌñê cwaaⁿ xuee oo ljoꞌ xjeⁿ ntyjeeⁿ na nluii cwii cwii nnom na matseijndaaꞌñê. ");
INSERT INTO amuNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Sa̱a̱ quia na jnda̱ jndyo Espíritu Santo naquiiꞌ nꞌomꞌyoꞌ, quia joꞌ nñequiaaⁿ na nlaxmaⁿꞌyoꞌ najndeii na cwiluiiñê. Ndoꞌ nntjeiꞌyuuꞌndyoꞌ cantyja ꞌnaⁿ ja naquiiꞌ tsjoom Jerusalén, ñꞌeⁿ chaꞌwaa tsꞌo̱ndaa Judea ñꞌeⁿ ndyuaa Samaria, ndoꞌ hasta chaꞌwaa nnom tsjoomnancue. ");
INSERT INTO amuNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Jnda̱ na tsoom na luaaꞌ jndooꞌcheⁿna tjawaaⁿ. Ndoꞌ jndyo cwii nchquiu, mana seicuꞌnaꞌ na cwintyꞌiaana jom. ");
INSERT INTO amuNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nquiee cwintyꞌiaana jo nandye tsjo̱ꞌluee xjeⁿ na mawjaaⁿ, ndoꞌ matsꞌiaa joꞌ teitquiooꞌndye we yonom nacañoomna na jeeⁿ canchiiꞌ liaa cweeꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Jlue naⁿꞌñeeⁿ nda̱a̱na: —ꞌO nnꞌaⁿ Galilea, ¿chiuu na jeeⁿ cwintyꞌiaꞌyoꞌ jo nandye tsjo̱ꞌluee? Jesúsmꞌaaⁿꞌ na jnaaⁿ jo nda̱a̱ꞌyoꞌ xjeⁿ cañoomꞌlueecheⁿ tjaaⁿ. Ndoꞌ chaꞌxjeⁿ na tjawaaⁿ maluaaꞌ nndyonnaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Quia joꞌ tyꞌelcweeꞌna Jerusalén na ñetꞌomna ta na jndyu Olivos. Juu taꞌñeeⁿ tquia mꞌaaⁿnaꞌ ñequio tsjoom Jerusalén chaꞌna tquia na wanaaⁿ na nntseicaañe tsꞌaⁿ judío xuee na cwitaꞌjndyeena. ");
INSERT INTO amuNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Jnda̱ na tyꞌequieꞌna quiiꞌ tsjoom, tquiena yuu waa wꞌaa. Tyꞌewana cuarto nandye wꞌaa yuu cwicꞌeeⁿyana. Ndoꞌ ñꞌeⁿ Pedro ñequio Jacobo, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo, Jacobo jnda Alfeo, Simón tsꞌaⁿ na cwilue nnꞌaⁿ cananista ndoꞌ ñꞌeⁿ Judas tyjee Jacobo. ");
INSERT INTO amuNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Chaꞌtsondyena ñecwii jlaꞌjomndyena na ꞌio ndi ꞌio tyolaneiⁿna nnom Tyꞌo̱o̱tsꞌom. Mati jlaꞌjomndye ntꞌom yolcu, ndoꞌ ñꞌeeⁿ tiꞌntyjee Jesús ñꞌeⁿ tsoñeeⁿ María. ");
INSERT INTO amuNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Cwii xueeꞌñeeⁿ teicantyja Pedro quiiꞌntaaⁿ nnꞌaⁿ na cwilaꞌyuꞌ. Joo naⁿꞌñeeⁿ chaꞌna cwii siaⁿnto waljooꞌ ntquiuundyena. ");
INSERT INTO amuNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","Matsoom nda̱a̱na: —ꞌO nnꞌaⁿya na cwilayuꞌyoꞌ, jndeiꞌnaꞌ na seicanda̱a̱ꞌñenaꞌ ñꞌoom na seiljeii David cantyja ꞌnaaⁿꞌ Judas chaꞌxjeⁿ tso Espíritu Santo nnoom cantyja ꞌnaaⁿꞌ Judasꞌñeeⁿ tsaⁿ na tjacaꞌmo̱ⁿ Jesús nda̱a̱ nnꞌaⁿ na tꞌue jom. ");
INSERT INTO amuNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judasꞌñeeⁿ tyocañꞌeeⁿ ñꞌeⁿndyô̱ jâ ndoꞌ ñeseijomñê tsꞌiaaⁿ na cwilaxmaaⁿyâ. ");
INSERT INTO amuNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ñequio sꞌom na tantjoom cantyja natia na sꞌaaⁿ, tiomlꞌuaaⁿ cwii taⁿꞌ tyuaa. Joꞌ joꞌ tiooñê meintyjeeꞌ xqueeⁿ, tꞌiooꞌñexcweeⁿ. Jluiꞌ chaꞌtso tsiaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ndoꞌ chaꞌtso nnꞌaⁿ Jerusalén nquiuna na luaaꞌ sꞌaaⁿ. Quia joꞌ ñequio ñꞌoom na cwilaꞌneiⁿna jlaꞌcajndyuna tyuaaꞌñeeⁿ Acéldama. Ñꞌoomwaaꞌ matsonaꞌ Tyuaa Niomꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ee waa ñꞌoom nacjooꞌ libro Salmos na matsonaꞌ: Caljo waⁿꞌaⁿ na ñeⁿnquiinaꞌ. Tincꞌom nnꞌaⁿ juunaꞌ. Mati matsonaꞌ: Cwiicheⁿ tsꞌaⁿ coñom tsꞌiaaⁿ na ñeseixmaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","’Quia joꞌ cwii tsꞌaⁿ na maxjeⁿ ñꞌeeⁿ ñꞌeⁿndyô̱ chaꞌwaati xuee na tyocañꞌa̱a̱ⁿyâ ñꞌeⁿ nquii Ta Jesús na tjawa tjacueeⁿ tyomanoom naquiiꞌ njoom, ");
INSERT INTO amuNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","tsꞌaⁿ na maxjeⁿ ñꞌeeⁿ ñꞌeⁿndyô̱ cantyjati xuee na teitsꞌoomñe Jesús sꞌaa Juan hasta xuee quia na tjawaaⁿ. Macaⁿnaꞌ na nntseijomñê tsaⁿꞌñeeⁿ ñꞌeⁿndyô̱ na nntjeiꞌyuuꞌndyô̱ na jnda̱ tandoꞌxco Jesús. ");
INSERT INTO amuNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Quia joꞌ tyotꞌmo̱o̱ⁿna we tsꞌaⁿ, José ñequio Matías. Joséꞌñeeⁿ mati cwilaꞌcajndyuna jom Barsabás, ndoꞌ xqueⁿ xueⁿꞌeⁿ Justo. ");
INSERT INTO amuNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Tyolaneiⁿna nnom Tyꞌo̱o̱tsꞌom, tyoluena: —ꞌU Ta na mawaꞌnaⁿꞌ naquiiꞌ nꞌom chaꞌtsondye nnꞌaⁿ, caꞌmo̱ⁿꞌ cwaaⁿ cwii na wendye naⁿmꞌaⁿꞌ na nncwjiiꞌndyuꞌ na nntseijomñe ñequio nnꞌaⁿ na maꞌjñoomꞌ tsꞌiaaⁿ ꞌnaⁿꞌ. Nntseinoomñe tsaⁿꞌñeeⁿ tsꞌiaaⁿ na ñeseixmaⁿ Judas na jnda̱ tjeiꞌñe, ndoꞌ jnda̱ tja yuu tseixmaⁿ na nncjaa cantyja ꞌnaaⁿꞌ jnaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Quia joꞌ tyꞌena xꞌiaa cha mꞌmo̱ⁿnaꞌ ꞌñeeⁿ nleijnoomꞌ tsꞌiaaⁿꞌñeeⁿ. Ndoꞌ teijnoomꞌ Matías. Joꞌ chii tyꞌoomnaꞌ jom tsꞌiaaⁿ chaꞌxjeⁿ tsꞌiaaⁿ na mꞌaⁿ canchooꞌcwii apóstoles. ");
INSERT INTO amuNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Quia na tueeꞌ xuee Pentecostés, chaꞌtsondye nnꞌaⁿ na cwilaꞌyuꞌ ñeꞌcwii tmaaⁿꞌ tjomndyena. ");
INSERT INTO amuNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Matsꞌia joꞌ jnaⁿ na teicꞌuaa jo nandye cañoomꞌluee chaꞌcwijom quia na jndeii mandyo jndye. Ndoꞌ sꞌaanaꞌ na cꞌuaa chaꞌwaa naquiiꞌ wꞌaa yuu na meindyuaandyena. ");
INSERT INTO amuNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Teitquiooꞌ ntyꞌiaana nacjoo chaꞌtsondyena ntyjo chaꞌcwijom ntsaachom. ");
INSERT INTO amuNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ndoꞌ chaꞌtsondyena tꞌomna na tooꞌ Espíritu Santo chaꞌwaañꞌeⁿ naquiiꞌ nꞌomna. Tquiaaⁿ na laꞌxmaⁿna cantyja najneiⁿ. Ndoꞌ jnaⁿnaꞌ na jlaꞌneiⁿna ntꞌomcheⁿ nnom ñꞌoom na nchii ñꞌoom na maxjeⁿ cwilaꞌneiⁿna. ");
INSERT INTO amuNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Joo ncueeꞌñeeⁿ mꞌaⁿya nnꞌaⁿ judíos naquiiꞌ tsjoom Jerusalén na jeeⁿ queeⁿ nꞌom tsꞌiaaⁿ ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom. Naⁿꞌñeeⁿ jnaⁿna chaꞌwaa nnom tsjoomnancue. ");
INSERT INTO amuNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Quia na teicꞌuaa na luaaꞌ, quia joꞌ tyꞌecantyꞌiaana. Meiⁿ leicalaꞌno̱ⁿꞌna ee chaꞌtsondyena tyondyena na tyolaꞌneiⁿ naⁿꞌñeeⁿ cwii cwii nnom ñꞌoom na cwilaꞌneiⁿ nquieena. ");
INSERT INTO amuNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Jeeⁿ ndyaꞌ tyueneiiⁿna, ndoꞌ tyomꞌaaⁿꞌ nꞌomna. Tyoluena nda̱a̱ ntyjeena: —Chaꞌtsondye naⁿmꞌaⁿꞌ na cwilaꞌneiⁿna ñequiiꞌcheⁿ nnꞌaⁿ tsꞌo̱ndaa Galilea joona, ");
INSERT INTO amuNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","quia joꞌ ¿chiuu waayuu na cwindya̱a̱ya na ya cwilaꞌneiⁿna cwii cwii nnom ñꞌoom na cwilana̱a̱ⁿya xjeⁿ na tquiowijnda̱a̱ya? ");
INSERT INTO amuNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ee jaa tiñeꞌcwii ndyuaa jnaaⁿya. Ntꞌomndyo̱ jnaaⁿ ndyuaa Partia, ntꞌomndyo̱ Media, Elam ñꞌeⁿ Mesopotamia, tsꞌo̱ndaa Judea ñꞌeⁿ Capadocia, mati Ponto ñꞌeⁿ ndyuaa Asia. ");
INSERT INTO amuNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Ndoꞌ ntꞌomndyo̱ jaa jnaaⁿya ndyuaa Frigia ñꞌeⁿ Panfilia, Egipto ñꞌeⁿ ntꞌomcheⁿ lꞌo̱ndaa África na manndyooꞌ Cirene. Ndoꞌ ntꞌomndyo̱ jnaaⁿya tsjoom Roma, na tuiindyo̱ nnꞌaⁿ judíos ndoꞌ mati ñꞌeⁿ nnꞌaⁿ meiⁿ nchii tuiindyena nnꞌaⁿ tsjaaⁿ jaa, sa̱a̱ macwilaꞌtꞌmaaⁿꞌndyena Tyꞌo̱o̱tsꞌom chaꞌxjeⁿ na jaa nnꞌaⁿ judíos cwilatꞌmaaⁿꞌndyo̱ jom. ");
INSERT INTO amuNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ndoꞌ ntꞌomndyo̱ jaa jnaaⁿya Creta ñꞌeⁿ Arabia. Sa̱a̱ chaꞌtsondyo̱ cwindya̱a̱ na ya cwilaꞌneiⁿ naⁿmꞌaaⁿꞌ ñꞌoomya. Cwiluena cantyja na jeeⁿ tꞌmaⁿ machꞌee Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Chaꞌtsondye naⁿꞌñeeⁿ na jnaⁿ cwii cwii joo, jeeⁿ ndyaꞌ tyojaaweeꞌ nꞌomna ndoꞌ seiñꞌeeⁿꞌnaꞌ joona. Tyoluena nda̱a̱ ncꞌiaana: —¿Ljoꞌ ñecaꞌmo̱ⁿnaꞌ na luaaꞌ cwiluii? ");
INSERT INTO amuNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Sa̱a̱ ntꞌomcheⁿ cweꞌ tyonco, tyolue: —Naⁿmꞌaⁿꞌ jnda̱ jndyeena. ");
INSERT INTO amuNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Quia joꞌ Pedro teintyjeeⁿꞌeⁿ ñequio canchooꞌcwii apóstoles. Jndeii seineiiⁿ, tsoom nda̱a̱ nnꞌaⁿ: —ꞌO nnꞌaⁿya ntyja̱ño̱ⁿya nnꞌaⁿ judíos ñequiondyoꞌ ꞌo na tsjomꞌyoꞌ ñjaaⁿ Jerusalén, queⁿꞌyoꞌ cwenta ndoꞌ candyeꞌyoꞌ ñꞌoom na nntsjo̱o̱. ");
INSERT INTO amuNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ee naⁿmꞌaⁿꞌ nchii na candyeena chaꞌxjeⁿ na cwilaꞌtiuuꞌyoꞌ, ee jeꞌ quia tueeꞌcheⁿ na ñjeeⁿ na cwitsjoom. ");
INSERT INTO amuNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Sa̱a̱ juu na cwintyꞌiaꞌyoꞌ na cwiluii matseicanda̱a̱ꞌñenaꞌ ñꞌoom na tyoñequiaa profeta Joel, tsoom: ");
INSERT INTO amuNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Ncuee na macanda̱, matso Tyꞌo̱o̱tsꞌom, njño̱o̱ⁿya Espíritu na cwiluiindyo̱ naquiiꞌ nꞌom jndye nnꞌaⁿ. Ndaꞌyoꞌ na naⁿnom ñequio ndaꞌyoꞌ na naⁿlcu nlaꞌneiⁿna ñꞌoom na nntsjo̱o̱ nda̱a̱na. Naⁿnom na titquiendye waa na nlcoꞌnaꞌ nda̱a̱na na nntyꞌiaana. Ndoꞌ naⁿnom na tquiendye ndaa nntsoona. ");
INSERT INTO amuNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ncueeꞌñeeⁿ njño̱o̱ⁿya Espíritu na cwiluiindyo̱ naquiiꞌ nꞌom nnꞌaⁿ na cwindyeꞌntjom no̱o̱ⁿ meiiⁿ naⁿnom ndoꞌ meiiⁿ naⁿlcu. Nñequia naⁿꞌñeeⁿ ñꞌoom na nntsjo̱o̱ nda̱a̱na. ");
INSERT INTO amuNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ndoꞌ nntsꞌaaya na nleitquiooꞌ jndye nnom ꞌnaaⁿ jo nandye tsjo̱ꞌluee na nlaꞌcatyuendye nnꞌaⁿ quia na nntyꞌiaana. Ndoꞌ nntsꞌaaya ꞌnaaⁿ na nleitquiooꞌ jo nacje nnom tsjoomnancue, chaꞌna niomꞌ ñequio chom ñequio ndioom. ");
INSERT INTO amuNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ñeꞌquioomꞌ nntseicwaqueⁿnaꞌ na jo̱o̱ⁿñe nnom, ndoꞌ chiꞌ nntseicwaqueⁿnaꞌ chaꞌcwijom niomꞌ. Nmeiⁿꞌ nluii cwii tjo̱o̱cheⁿ na nncueeꞌ xuee cantyja ꞌnaⁿ ja na cwiluiindyo̱ na matsa̱ꞌntjo̱ⁿ. Juu xueeꞌñeeⁿ tꞌmaⁿticheⁿ matseixmaⁿnaꞌ na nleitquiooꞌ najndeii na matseixmaⁿya. ");
INSERT INTO amuNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Sa̱a̱ cwii cwii tsꞌaⁿ na nncwjiꞌ xueya na cwiluiindyo̱ na matsa̱ꞌntjo̱ⁿ, juu tsaⁿꞌñeeⁿ nluiinꞌmaaⁿñe.” Luaaꞌ ñꞌoom na tso Tyꞌo̱o̱tsꞌom ñequio ꞌndyoo Joel. ");
INSERT INTO amuNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Tsoti Pedro: —ꞌO nnꞌaⁿya Israel, candyeyaꞌyoꞌ na nntsjo̱o̱ cantyja ꞌnaaⁿꞌ Jesús tsaⁿ na jnaⁿ Nazaret. Tquiooꞌ na nquii Tyꞌo̱o̱tsꞌom jñom jom ee jndye nnom tsꞌiaaⁿ tꞌmaⁿ sꞌaaⁿ quiiꞌntaaⁿꞌyoꞌ na nchii na nnda̱a̱ nnluii na cweꞌ tsꞌaⁿ nntsꞌaa, meiⁿ xocjaantyjo̱o̱ꞌ nꞌom nnꞌaⁿ chiuu tuiiyuu. Ndoꞌ ꞌo manquiuꞌyoꞌ na ljoꞌ ee cantyja najndeii na matseixmaⁿ nquii Tyꞌo̱o̱tsꞌom, joꞌ na tyochꞌee Jesús ꞌnaaⁿ tꞌmaⁿ quiiꞌntaaⁿꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Maxjeⁿ teiyo ntyjii Tyꞌo̱o̱tsꞌom na nncꞌoom Jesús lueeꞌyoꞌ ee seijndaaꞌñê na tuii na ljoꞌ. Joꞌ na tioꞌyoꞌ Jesús luee nnꞌaⁿ romanos. ꞌO lꞌaꞌyoꞌ na tyꞌioomna jom tsꞌoomꞌnaaⁿ na jlacueeꞌna jom. ");
INSERT INTO amuNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Sa̱a̱ Tyꞌo̱o̱tsꞌom tquiaa na tandoꞌxcoom na tueeⁿꞌeⁿ. Seicandyaañe jom na ñetꞌomtsꞌooñê ee tijoom jndaa caljooꞌñê nacje ꞌnaaⁿꞌ na cwiwje nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Seineiⁿ rey David na ndooꞌ matseineiⁿ nquii Jesús. Matsoom: Mantyꞌiaya Tyꞌo̱o̱tsꞌom na ñequiiꞌcheⁿ mꞌaaⁿñê jo no̱o̱ⁿya. Ncꞌe na mꞌaaⁿñê ñꞌeⁿndyo̱, joꞌ chii xocjuꞌcjenaꞌ ja. ");
INSERT INTO amuNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Joꞌ na jeeⁿ neiⁿnco tsꞌo̱o̱ⁿya, ndoꞌ ñequio na neiⁿya mataya. Ndoꞌ cweꞌ ncꞌe meindo̱o̱ꞌntyꞌiaandyo̱, joꞌ na machꞌeenaꞌ na mawajndya̱ya. ");
INSERT INTO amuNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ee xonquiaaꞌ na nljooꞌndyo̱ tseiꞌtsuaa meiⁿ xonquiaaꞌ na nnto̱ꞌndyo̱ ee cwiluiindyo̱ na ljuꞌ tsꞌo̱o̱ⁿ na mandiꞌntjo̱ⁿya njomꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ꞌU tꞌmo̱ⁿꞌ no̱o̱ⁿya nato cantyja na nncwandoꞌxco tsꞌaⁿ. Ndoꞌ na nncꞌo̱o̱ⁿya ñꞌeⁿndyuꞌ nntsꞌaanaꞌ na neiⁿtya̱ya. Luaaꞌ ñꞌoom na seineiⁿ David. ");
INSERT INTO amuNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Tsoti Pedro: —ꞌO nnꞌaⁿya, ndyeyu nntsjo̱o̱ nndyeꞌyoꞌ na tueꞌ welooya David na ñetꞌoom teiyo. Tyꞌecatꞌiuuna jom, ndoꞌ tseiꞌtsuaⁿꞌaⁿ ndicwaⁿ waanaꞌ tsjoom ñjaaⁿ hasta xuee jeꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Jom tyoluiiñê profeta, ndoꞌ ntyjiiyaaⁿ na tso Tyꞌo̱o̱tsꞌom ñꞌoomtyeⁿ nnoom na nluiiñe Cristo quiiꞌntaaⁿ nnꞌaⁿ tsjaaⁿ ꞌnaaⁿꞌaⁿ na nndyowicantyjooꞌ ndoꞌ juu tsaⁿꞌñeeⁿ nncjaacjoo ntio na ñetacatyeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Ndoꞌ chaꞌcwijom na nntyꞌiaaꞌ nnoom najnda̱ tuiinaꞌ, joꞌ na tsoom na xocaljooꞌñe añmaaⁿꞌ yuu na cwiljooꞌndye añmaaⁿ nnꞌaⁿ na jnda̱ tja̱ ndoꞌ meiⁿ seiiꞌ xocato̱o̱ꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ñꞌoommeiⁿꞌ seineiiⁿ cantyja ꞌnaaⁿꞌ Jesús. Ndoꞌ chaꞌtsondyô̱ cwitjeiꞌyuuꞌndyô̱ na mayuuꞌ na tquiaa Tyꞌo̱o̱tsꞌom na tandoꞌxco juu. ");
INSERT INTO amuNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Jeꞌ mꞌaaⁿ ntyjaaꞌ tsꞌo̱ Tyꞌo̱o̱tsꞌom ntyjaya yuu na matseitꞌmaaⁿꞌñenaꞌ jom. Joꞌ na jnda̱ jñom Tsotyeeⁿ Espíritu Santo naquiiꞌ nꞌom nnꞌaⁿ chaꞌxjeⁿ ñꞌoomtyeⁿ na tqueⁿ ndoꞌ na cwiluii chaꞌtso na cwintyꞌiaꞌyoꞌ jeꞌ ndoꞌ na cwindyeꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Ee nchii nquii David tja cañoomꞌluee. Joꞌ chii maꞌmo̱ⁿnaꞌ cantyja ꞌnaaⁿꞌ Jesús seneiiⁿ. Ee tso David: Seineiⁿ Ta Tyꞌo̱o̱tsꞌom nnom Ta na matsa̱ꞌntjom ja. Matsoom nnom: “Cajmaⁿꞌ jo ntyjaaꞌ tsꞌo̱o̱ya ntyjaya ");
INSERT INTO amuNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","hasta xjeⁿ na jnda̱ tsa̱ꞌa nnꞌaⁿ na jndoo ꞌu cjeeꞌ ncꞌeꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Tsoti Pedro: —Quia joꞌ chaꞌtsondyoꞌ ꞌo nnꞌaⁿ Israel calaꞌno̱ⁿꞌyoꞌ na mayuuꞌ na juu Jesús na tyꞌiomꞌyoꞌ tsꞌoomꞌnaaⁿ, tqueⁿ Tyꞌo̱o̱tsꞌom na Ta jom na matsa̱ꞌntjoom jaa ndoꞌ na Cristo jom na macwjiꞌnꞌmaaⁿñê jaa. ");
INSERT INTO amuNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ndoꞌ quia jndye nnꞌaⁿ Israel na luaaꞌ, jeeⁿ seiꞌndaaꞌnaꞌ nquiuna. Jluena nnom Pedro ñequio nda̱a̱ ntꞌomcheⁿ apóstoles: —ꞌO nnꞌaaⁿya, ¿chiuu macaⁿnaꞌ na calꞌaayâ? ");
INSERT INTO amuNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Quia joꞌ tꞌo̱ Pedro nda̱a̱na: —Ticwiindyoꞌ ꞌo calcweꞌ nꞌomꞌyoꞌ ndoꞌ cwitsꞌoomndyoꞌ ñequio xueeꞌ Jesucristo, cha nntseitꞌmaⁿ tsꞌom Tyꞌo̱o̱tsꞌom jnaⁿꞌyoꞌ. Quia joꞌ nntoꞌñoomꞌyoꞌ Espíritu Santo naquiiꞌ nꞌomꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ee ñꞌoomtyeⁿwaaꞌ tseixmaⁿnaꞌ cwentaꞌ ꞌo ñꞌeⁿ ndaꞌyoꞌ, ndoꞌ cwentaa chaꞌtso nnꞌaⁿ na mꞌaⁿ na tquia, ndoꞌ mati ticwii cwii tsꞌaⁿ na maꞌmaⁿ Ta Tyꞌo̱o̱tsꞌom cwentaaya. ");
INSERT INTO amuNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pedro jndye ntꞌomcheⁿ ñꞌoom tyocwjiꞌyuuꞌñetyeeⁿ nda̱a̱na. Ndoꞌ tyotseijndo̱ꞌtyeeⁿ nꞌomna. Tsoom: —Catjeiꞌndyoꞌ cantyja ꞌnaaⁿ nnꞌaⁿ na mꞌaⁿ jeꞌ na quieꞌ nꞌom cha nnda̱a̱ nluiꞌnꞌmaaⁿndyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Quia joꞌ nnꞌaⁿ na jlaꞌyuꞌ ñꞌoom na tsoom teitsꞌoomndyena. Juu xueeꞌñeeⁿ, chaꞌna ndyee meiⁿndyena jlaꞌyuꞌna. ");
INSERT INTO amuNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Tyoqueⁿndyena na tyondyena ñꞌoom na tyotꞌmo̱o̱ⁿ apóstolesꞌñeeⁿ. Tjoomꞌ tyomꞌaⁿna ñequio naⁿꞌñeeⁿ. Tyotjomndyena na tyotyjena tyooꞌ na tyocañjom nꞌomna Jesús. Ndoꞌ tyolaꞌneiⁿna nnom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Chaꞌtsondye nnꞌaⁿ tyotseitsaⁿꞌnaꞌ joona ee na tyontyꞌiaana jndye tsꞌiaaⁿ tꞌmaⁿ na tyolꞌa apóstoles na xocanda̱a̱ nluii na cweꞌ na jnda̱ nquieena meiⁿ xocjaantyjo̱o̱ꞌ nꞌom nnꞌaⁿ ꞌnaaⁿ na tuii. ");
INSERT INTO amuNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Chaꞌtsondye nnꞌaⁿ na jnda̱ jlaꞌyuꞌ, ñeꞌcwii nꞌomna. Ndoꞌ chaꞌtso ꞌnaⁿ na tyowilꞌueeꞌndyena tjom na ꞌnaaⁿna joonaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Tyonda̱a̱na ndyuaana ñequio ntꞌomcheⁿ ꞌnaaⁿna na waa. Ndoꞌ sꞌom na tyotoꞌñoomna tyoto̱ⁿꞌna joonaꞌ, tyoñequiana nda̱a̱ nnꞌaⁿ na tyotseitjo̱o̱naꞌ joo. ");
INSERT INTO amuNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ꞌIo ndi ꞌio tyotjomndyena watsꞌom tꞌmaⁿ. Mati naquiiꞌ lꞌaana tyolaꞌjomndyena na tyotyjena tyooꞌ na tyocañjom nꞌomna Jesús. Tyocwaꞌna ñequio na neiiⁿna ndoꞌ na xcweeꞌ nꞌomna. ");
INSERT INTO amuNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Tyolaꞌtꞌmaaⁿꞌndyena Tyꞌo̱o̱tsꞌom ndoꞌ chaꞌtsondye ntꞌomcheⁿ nnꞌaⁿ tyotjeiiꞌya joona. Ndoꞌ ꞌio ndi ꞌio tyocwjiꞌnꞌmaaⁿñeticheⁿ Tyꞌo̱o̱tsꞌom nnꞌaⁿ. Joꞌ chii tjawitꞌmaⁿti tmaaⁿꞌ nnꞌaⁿ na macwjiꞌ Tyꞌo̱o̱tsꞌom cwentaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Cwii xuee Pedro ñꞌeⁿ Juan ljoꞌyu tyꞌena watsꞌom tꞌmaⁿ na ndyee na matmaaⁿ xjeⁿ na cwiꞌoolaꞌneiⁿ nnꞌaⁿ nnom Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ndoꞌ joꞌ joꞌ mꞌaaⁿ cwii tsaⁿsꞌa na tuiiñe na ntjeiⁿ ncꞌee. Juu tsaⁿꞌñeeⁿ ꞌio ndi ꞌio tyoꞌooñꞌom nnꞌaⁿ jom watsꞌom tꞌmaⁿ, tyoqueⁿna jom ꞌndyootsꞌa na jndyunaꞌ Jeeⁿ Neiⁿncooꞌ cha nnda̱a̱ nlcaaⁿ ljoꞌ na matseitjo̱o̱naꞌ jom nda̱a̱ nnꞌaⁿ na cwiꞌooquieꞌ joꞌ joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Quia na ntyꞌiaaⁿꞌaⁿ Pedro ñꞌeⁿ Juan na macwiꞌooquieꞌna naquiiꞌ watsꞌomꞌñeeⁿ tcaaⁿ sꞌom nda̱a̱na. ");
INSERT INTO amuNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ndoꞌ ntyꞌiaaꞌ Pedro ñequio Juan jom. Tso Pedro nnoom: —Aa re sa, cantyꞌiaꞌ nda̱a̱yâ. ");
INSERT INTO amuNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Quia joꞌ ntyꞌiaaⁿꞌaⁿ nda̱a̱na ee seitioom waa na nñequiana na nncoꞌñoom. ");
INSERT INTO amuNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Sa̱a̱ matso Pedro nnoom: —Ja meiⁿ sꞌom xuee meiⁿ sꞌom cajaⁿ tjaaꞌnaⁿ na maleiñꞌo̱ⁿya, sa̱a̱ cantyja na maleiñꞌo̱ⁿtya̱ nñequiaya na nncoꞌñomꞌ. Ñequio xueeꞌ Jesucristo, tsaⁿ na jnaⁿ Nazaret, quicantyjaꞌ ndoꞌ cjaꞌcaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Jnda̱ chii tꞌuii Pedro tsꞌo̱o̱ⁿ ntyjaya seiwe tsaⁿꞌñeeⁿ jom. Mañoomꞌ tcoꞌyanaꞌ ndaꞌncꞌeeⁿ ñequio candyoꞌncꞌeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Joꞌ na ñejomto teicantyjaaⁿ. Teintyjeeⁿꞌeⁿ ndoꞌ to̱o̱ⁿꞌo̱ⁿ na tjacaⁿ. Tjaqueⁿꞌeⁿ naquiiꞌ watsꞌom tꞌmaⁿ ñꞌeⁿndyena. Tyojaacaⁿ ndoꞌ tyowantyjaaⁿ ndoꞌ tyotseitꞌmaaⁿꞌñê Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Ndoꞌ chaꞌtsondye nnꞌaⁿ na tooꞌndye naquiiꞌ watsꞌom tyontyꞌiaana na tyojaacaⁿ ndoꞌ tyotseitꞌmaaⁿꞌñê Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ee tajnaaⁿꞌna na jom tsꞌaⁿ na ñetacatyeeⁿ ꞌndyootsꞌa watsꞌom tꞌmaⁿꞌñeeⁿ na jndyunaꞌ Jeeⁿ Neiⁿncooꞌ. Majom na tyocaaⁿ ljoꞌ na matseitjo̱o̱naꞌ jom nda̱a̱ nnꞌaⁿ. Joꞌ na jeeⁿ tyotseitsaⁿꞌnaꞌ joona ndoꞌ jeeⁿ tjaweeꞌ nꞌomna na jnda̱ tcoꞌyanaꞌ ncꞌeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Watsꞌomꞌñeeⁿ waa cwii leirooꞌnaꞌ na jndyunaꞌ Salomón. Joꞌ joꞌ tquiontyjaaꞌ chaꞌtsondye nnꞌaⁿ na cwityueneiiⁿna. Ee tsꞌaⁿ na tcoꞌyanaꞌ ncꞌee joꞌ joꞌ tiñeꞌcaꞌñeeⁿ Pedro ñequio Juan. ");
INSERT INTO amuNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Quia na ntyꞌiaaꞌ Pedro na chaꞌtsondye nnꞌaⁿ jnda̱ jlaꞌcandyooꞌndyena, matsoom nda̱a̱na: —ꞌO re nnꞌaⁿya Israel, ¿chiuu na jeeⁿ matseitsaⁿꞌnaꞌ ꞌo? ¿Chiuu na jeeⁿ cwintyꞌiaꞌyoꞌ nda̱a̱yâ na chacwijom cwilaꞌtiuuꞌyoꞌ na cweꞌ na jnda̱a̱ ncjo̱o̱yâ oo cweꞌ ncꞌe na jeeⁿ cwilaꞌtꞌmaaⁿꞌndyô̱ Tyꞌo̱o̱tsꞌom joꞌ na majaacaa tsaⁿmꞌaaⁿꞌ? Meiⁿchjoo nchiijoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ee nquii Tyꞌo̱o̱tsꞌom na tyotseitꞌmaaⁿꞌñe welooya Abraham na ñetꞌoom teiyo, na tyotseitꞌmaaⁿꞌñe welooya Isaac, ndoꞌ welooya Jacob, ndoꞌ tyolaꞌtꞌmaaⁿꞌndye ntꞌomcheⁿ welooya na jndyowiꞌcantyjooꞌ, jom seitꞌmaaⁿꞌñê Jnaaⁿ Jesús, na jlaꞌquiooꞌyoꞌ luee naⁿmaⁿnꞌiaaⁿ cha cueꞌ. Ndoꞌ meiiⁿ Pilato ñeꞌcatseicandyaañe jom, sa̱a̱ tîtancueꞌyoꞌ. Saꞌyoꞌ nacjoomꞌm meiiⁿ juu ñeꞌcatseicandyaañe jom. ");
INSERT INTO amuNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","ꞌO nchii taⁿꞌyoꞌ na nndyaañe nquii na cwiluiiñe na ljuꞌ tsꞌom ndoꞌ na tyochꞌee yuu na matyꞌiomyanaꞌ. ꞌO taⁿꞌyoꞌyoꞌ na nndyaañe tsꞌaⁿ na ñeseicwjee nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Jlaꞌcueꞌyoꞌ nqueⁿ na mañequiaaⁿ na cwitandoꞌ nnꞌaⁿ. Sa̱a̱ Tyꞌo̱o̱tsꞌom tquiaa na tandoꞌxcoom na tueeⁿꞌeⁿ ndoꞌ jâ cwitjeiꞌyuuꞌndyô̱ na ljoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ncꞌe na cwilayuꞌya cwii nꞌo̱o̱ⁿyâ ñꞌeⁿ xueeꞌ Jesús, joꞌ na tquiaanaꞌ najnda̱ ncꞌee tsaⁿmꞌaaⁿꞌ na cwintyꞌiaꞌyoꞌ ndoꞌ na cwitaꞌjnaⁿꞌyoꞌ. Ee ncꞌe juu na cwilayuuꞌyâ nꞌo̱o̱ⁿyâ ñequio Jesús, joꞌ na chaꞌtsondyoꞌ cwintyꞌiaꞌyoꞌ na canda̱a̱ꞌ tcoꞌyanaꞌ tsaⁿmꞌaaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","’Ndoꞌ ntyjiiya, ꞌo nnꞌaⁿya, na tîcalaꞌno̱ⁿꞌyoꞌ ljoꞌ lꞌaꞌyoꞌ ñequio naⁿmaⁿnꞌiaaⁿ ꞌnaⁿꞌyoꞌ jlaꞌcueꞌyoꞌ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Sa̱a̱ laaꞌtiꞌ waa na seicanda̱a̱ꞌñe Tyꞌo̱o̱tsꞌom ñꞌoom na seineiiⁿ ñequio ndyuee profetas na maxjeⁿ nncueꞌ Cristo tsaⁿ na jñoom. ");
INSERT INTO amuNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Joꞌ chii calcweꞌ nꞌomꞌyoꞌ ndoꞌ cataꞌndyoꞌxcweꞌyoꞌ nnom Tyꞌo̱o̱tsꞌom cha nntseicanoomꞌm jnaⁿꞌyoꞌ ndoꞌ na nñequiaaⁿ na ntseixconaꞌ cantyja na cwitsaamꞌaⁿꞌyoꞌ joo nnoom. ");
INSERT INTO amuNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Ndoꞌ na ljoꞌ njñomnnaaⁿꞌaⁿ Jesucristo, tsaⁿ na nncwjiꞌnꞌmaaⁿñe ꞌo, ee teiyo seijndaaꞌñê na luaaꞌ nntsꞌaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Sa̱a̱ macaⁿnaꞌ na caljooꞌñe Jesucristo cañoomꞌluee hasta quia na jnda̱ seicanda̱a̱ꞌñenaꞌ chaꞌtso ñꞌoom na seineiiⁿ ñequio ndyuee profetas na tyoñequia ñꞌoomꞌm tandyo xuee. ");
INSERT INTO amuNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Ee tyotso Moisés nda̱a̱ welooya na ñetꞌom teiyo: “Nquii Ta Tyꞌo̱o̱tsꞌom njñoom cwii nnꞌaⁿꞌyoꞌ na mꞌaⁿꞌyoꞌ na nñequiaa ñꞌoomꞌm chaꞌxjeⁿ na jñoom ja. Queⁿꞌyoꞌ cwenta chaꞌtso ñꞌoom na nntseineiⁿ tsaⁿꞌñeeⁿ nda̱a̱ꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ee meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na tiqueⁿ cwenta ñꞌoom na nntso tsaⁿꞌñeeⁿ nncwjiꞌndyo̱naꞌ juu quiiꞌntaaⁿ nnꞌaⁿ Israel.” ");
INSERT INTO amuNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Tsoti Pedro: —Chaꞌtsondye profetas chaꞌna Samuel ñequio nnꞌaⁿ na cwiñetꞌom jnda̱ na tueꞌ tsaⁿꞌñeeⁿ, tyoluena na nluii chaꞌxjeⁿ na cwiluii jeꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ñequio ndyuee profetas tquiaa Tyꞌo̱o̱tsꞌom ñꞌoomtyeⁿ ndoꞌ ꞌo laxmaⁿꞌyoꞌ na nndaꞌyoꞌ naya na cwitꞌmo̱o̱ⁿ joonaꞌ ndoꞌ chaꞌxjeⁿ ñꞌoom na seijndaaꞌñetyeⁿ Tyꞌo̱o̱tsꞌom nda̱a̱ welooya na ñetꞌom teiyo quia tsoom nnom welooya Abraham: “Quiiꞌntaaⁿ nnꞌaⁿ tsjaaⁿ ꞌnaⁿꞌ na nncjaawiꞌcantyjooꞌ nluiiñe tsꞌaⁿ na njño̱o̱ⁿya na mꞌaⁿꞌyoꞌ. Ndoꞌ ncꞌe juu nntioꞌnaaⁿndyo̱ chaꞌtsondye nnꞌaⁿ tsjoomnancue.” ");
INSERT INTO amuNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Joꞌ chii quia na sꞌaa Tyꞌo̱o̱tsꞌom na taꞌndoꞌxco Jnaaⁿ na tueꞌ, najndyee tioꞌnaaⁿñê ꞌo na jñoom juu na mꞌaⁿꞌyoꞌ cha tincwiindyoꞌ ꞌo nlcweꞌ nꞌomꞌyoꞌ natia na cwilꞌaꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedro ñꞌeⁿ Juan xcwe na cwilaꞌneiⁿna nda̱a̱ nnꞌaⁿ, ndoꞌ tquie ntyee na mꞌaⁿna ñequio tsꞌaⁿ na matsa̱ꞌntjom nnꞌaⁿ na cwilꞌa cwenta watsꞌom tꞌmaⁿ. Mati ntꞌom nnꞌaⁿ judíos na laxmaⁿna tmaaⁿꞌ saduceos tquiena. ");
INSERT INTO amuNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Jnda̱ teilioo naⁿꞌñeeⁿ ee Pedro ñꞌeⁿ Juan cwitꞌmo̱o̱ⁿna nda̱a̱ nnꞌaⁿ na jnda̱ mawandoꞌxco Jesús, joꞌ chii mati nnꞌaⁿ na jnda̱ tja̱ maxjeⁿ ntandoꞌxcona. ");
INSERT INTO amuNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Quia joꞌ tꞌue naⁿꞌñeeⁿ joona. Ndoꞌ cweꞌ ncꞌe na jnda̱ tmaaⁿ, joꞌ chii tioomya naⁿꞌñeeⁿ joona wꞌaancjo hasta quia nneiⁿncoo cwiicheⁿ xuee. ");
INSERT INTO amuNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Sa̱a̱ nnꞌaⁿ na tyondye ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na tyoñeꞌquiana, jndyendye naⁿꞌñeeⁿ jlaꞌyuꞌna. Ndoꞌ chaꞌtsoñꞌeⁿ nnꞌaⁿ na cwilaꞌyuꞌ tueꞌntyjo̱ chaꞌna ꞌom meiⁿndyena na cweꞌ naⁿnom. ");
INSERT INTO amuNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Teincoo cwiicheⁿ xuee naquiiꞌ Jerusalén tjomndye nnꞌaⁿ na mꞌaⁿ nꞌiaaⁿ cwentaa nnꞌaⁿ judíos ñequio nnꞌaⁿ na cwiluiitquiendye, ñequio nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés. ");
INSERT INTO amuNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Ñꞌeⁿ Anás, tyee na cwiluiitquieñe, ñequio Caifás, ñꞌeⁿ Juan ñequio Alejandro, ndoꞌ ñꞌeeⁿ chaꞌtsondye ntꞌomcheⁿ nnꞌaⁿ na nnꞌaaⁿna ntyee na cwiluiitquiendye. ");
INSERT INTO amuNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Tqueeⁿꞌndyena Pedro ñꞌeⁿ Juan ndoꞌ tsa̱ꞌna naⁿꞌñeeⁿ quiiꞌntaaⁿna. Jluena: —¿ꞌÑeeⁿ tquiaa na jnda̱ꞌyoꞌ, ndoꞌ ꞌñeeⁿ tsꞌaⁿ xueeꞌ cwileiꞌñꞌomꞌyoꞌ na luaaꞌ cwilꞌaꞌyoꞌ? ");
INSERT INTO amuNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ndoꞌ Pedro tooꞌ quiiꞌ tsꞌoom mꞌaaⁿ Espíritu Santo, matsoom nda̱a̱na: —ꞌO re nnꞌaⁿ na mꞌaⁿꞌyoꞌ nꞌiaaⁿ ñequio ꞌo nnꞌaⁿ na cwiluiitquiendyoꞌ joo nda̱a̱ jaa nnꞌaⁿ Israel, ");
INSERT INTO amuNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","na cwitaꞌxꞌeeꞌyoꞌ nda̱a̱yâ cantyja naya na tuii ñꞌeⁿ tsꞌaⁿ na ñetꞌoom na ntjeiⁿ ncꞌee, ¿aa ñeꞌcandyeꞌyoꞌ chiuu tuiiyuu na jnda̱ tcoꞌyanaꞌ jom? ");
INSERT INTO amuNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Xeⁿ na ljoꞌ, quia joꞌ chaꞌtsondyoꞌ ꞌo ñequio chaꞌtsondye nnꞌaⁿ Israel calaꞌno̱ⁿꞌyoꞌ chiuu waa. Nquii Jesucristo, tsꞌaⁿ na jnaⁿ Nazaret na tyꞌiomꞌyoꞌ tsꞌoomꞌnaaⁿ, tquiaa Tyꞌo̱o̱tsꞌom na tandoꞌxcoom jnda̱ na tueeⁿꞌeⁿ. Ñequio xueeꞌ jom joꞌ na jnda̱ nꞌmaⁿ tsaⁿsꞌamꞌaaⁿꞌ na cwintyꞌiaꞌyoꞌ na meintyjeeⁿꞌeⁿ jo nda̱a̱ꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Juu Jesús cwiluiine tsjo̱ꞌ na ꞌo na cwiluiitquiendyoꞌ jo nda̱a̱ya jnda̱ tquieꞌyoꞌ. Sa̱a̱ jnda̱ tacatyeeⁿtyeⁿ tsjo̱ꞌñeeⁿ nquii tsiaⁿtsjo̱ꞌ yuu na tꞌmaⁿti matseixmaⁿnaꞌ na chaꞌtso ljo̱ꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Tjaaꞌnaⁿ ꞌñeeⁿ cwiicheⁿ na nnda̱a̱ nncwjiꞌnꞌmaaⁿñe nnꞌaⁿ macanda̱ nquii Jesús. Ee chaꞌwaa nnom tsjoomnancue tjaaꞌnaⁿ xueeꞌ cwiicheⁿ na tqueⁿ Tyꞌo̱o̱tsꞌom na juu nnda̱a̱ nncwjiꞌnꞌmaaⁿñe jaa. ");
INSERT INTO amuNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Jnda̱ na ntyꞌiaa naⁿmaⁿnꞌiaaⁿ na tinquiaaꞌ Pedro ñꞌeⁿ Juan, ndoꞌ jlaꞌno̱ⁿꞌna na tyoolaꞌnaaⁿ naⁿꞌñeeⁿ chaꞌxjeⁿ na nquiuna, ee cweꞌ nnꞌaⁿ meiⁿquiandye joona, quia joꞌ jeeⁿ tyotseitsaⁿꞌnaꞌ joona, ndoꞌ tjañjoomꞌ nꞌomna na tyocañꞌeeⁿ naⁿꞌñeeⁿ ñꞌeⁿ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ndoꞌ majndeiiti quia na ntyꞌiaana nacañoom naⁿꞌñeeⁿ meintyjeeꞌ tsꞌaⁿ na jnda̱ tcoꞌyanaꞌ, joꞌ chii seicuꞌñꞌeⁿnaꞌ na nluena ñꞌoom nacjoo naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Quia joꞌ tjeiiꞌyana naⁿꞌñeeⁿ quiiꞌntaaⁿna. Jnda̱ chii tyolaꞌneiⁿ cheⁿnquieena. ");
INSERT INTO amuNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Tyoluena: —¿Chiuu nlꞌaayo̱o̱ ñequio tiꞌmꞌaⁿꞌ? Ee chaꞌtsondye nnꞌaⁿ tsjoom ñjaaⁿ Jerusalén manquiuyana na jnda̱ lꞌa naⁿmꞌaⁿꞌ cwii tsꞌiaaⁿ tꞌmaⁿ na xocanda̱a̱ nntsꞌaa na cweꞌ na jndeii nquii tsꞌaⁿ ndoꞌ jaa xonda̱a̱ nlꞌuuya na tiyuuꞌ na ljoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Joꞌ chii yati calꞌuuya nda̱a̱ naⁿmꞌaⁿꞌ ñequio na jndeiꞌnaꞌ meiⁿcwii nnom tsꞌaⁿ talaꞌneiⁿtina ñꞌoom cantyja ꞌnaaⁿꞌ Jesús, cha tantꞌomti ñꞌoommeiⁿꞌ quiiꞌntaaⁿ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Quia joꞌ tꞌmaⁿna naⁿꞌñeeⁿ. Sa̱ꞌntjomna na meiⁿcwii ñꞌoom talaꞌneiⁿti naⁿꞌñeeⁿ, tantꞌmo̱o̱ⁿna ñequio xueeꞌ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Sa̱a̱ Pedro ñequio Juan, jluena: —Ncjoꞌyoꞌ calatiuuꞌyaꞌyoꞌ aa matyꞌiomnaꞌ jo nnom Tyꞌo̱o̱tsꞌom na calacanda̱a̱yâ ñꞌoom na cwinduꞌ ꞌo, nchii ñꞌoom na matso jom. ");
INSERT INTO amuNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ee jâ tijoom jndaa caꞌndya̱a̱yâ na nlana̱a̱ⁿyâ ljoꞌ na ñentyꞌiaayâ na tyochꞌee Jesús ndoꞌ na tyondya̱a̱yâ na tyotseineiiⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Sa̱a̱ joo naⁿmaⁿnꞌiaaⁿ jndeiiꞌti ñꞌoom tyoluena nda̱a̱ naⁿꞌñeeⁿ. Jnda̱ chii jñoomna naⁿꞌñeeⁿ, ee tileicaliuna chiuu ya nntaꞌwiꞌna naⁿꞌñeeⁿ ee nquiaana nnꞌaⁿ quiiꞌ tsjoom, ee chaꞌtsondye nnꞌaⁿ tyolatꞌmaaⁿꞌndyena Tyꞌo̱o̱tsꞌom cantyja na ntyꞌiaana na tcoꞌyanaꞌ tsꞌaⁿ na ñetꞌoom na ntjeiⁿ ncꞌee. ");
INSERT INTO amuNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ee tsaⁿsꞌaꞌñeeⁿ, na jeeⁿ tꞌmaⁿ tsꞌiaaⁿ sꞌaa Tyꞌo̱o̱tsꞌom na tcoꞌyanaꞌ jom, jnda̱ teinom wenꞌaaⁿ choomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pedro ñꞌeⁿ Juan, jnda̱ na jndyaandyena, tyꞌena na mꞌaⁿ ncꞌiaana. Jlaꞌcandiina naⁿꞌñeeⁿ chaꞌtso ñꞌoom na tyolue ntyee na cwiluiitquiendye ñequio nnꞌaⁿ na cwiluiitquiendye quiiꞌ tsjoom. ");
INSERT INTO amuNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ndoꞌ joo naⁿꞌñeeⁿ, quia na jndyena ñꞌoomꞌñeeⁿ, ñeꞌcwii tꞌmaⁿ jlaꞌneiⁿna nnom Tyꞌo̱o̱tsꞌom, jluena: —ꞌU Ta Tyꞌo̱o̱tsꞌom, macanda̱ ꞌU na mayuuꞌcheⁿ na matsa̱ꞌntjomꞌ. ꞌU tqueⁿꞌ cañoomꞌluee ñequio tsjoomnancue, ñequio ndaaluee, ndoꞌ ñequio chaꞌtso na niom. ");
INSERT INTO amuNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ñequio Espíritu Santo seijndo̱ꞌ tsꞌom mosoꞌ David. Joꞌ na seiljeiⁿ ñꞌoom na tsuꞌ. Tsoom: ¿Chiuu na cwilaꞌwjee nnꞌaⁿ na nchii judíos? Ndoꞌ ¿chiuu na cwilaꞌtiuu nnꞌaⁿ judíos cwii na cweꞌ tsꞌiaaⁿꞌndyo? ");
INSERT INTO amuNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Nnꞌaⁿ tsjoomnancue na cwitsa̱ꞌntjom jlaꞌwendyena. Ndoꞌ nnꞌaⁿ na mꞌaⁿ nꞌiaaⁿ jlaꞌjomndyena. Ñeꞌcwii tyꞌena nacjooꞌ nquii Tyꞌo̱o̱tsꞌom, ñequio Cristo tsaⁿ na jñoom. ");
INSERT INTO amuNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Jlueti naⁿꞌñeeⁿ nnom Tyꞌo̱o̱tsꞌom: —Mayuuꞌ ñꞌoomꞌñeeⁿ na tso David ee Herodes ñequio Poncio Pilato jlaꞌjomndyena naquiiꞌ tsjoomwaa ñequio nnꞌaⁿ judíos ñequio nnꞌaⁿ na nchii judíos. Tyꞌena nacjooꞌ Jndaꞌ na ljuꞌ tseixmaaⁿ ndoꞌ na majndaaꞌ tsꞌiaⁿꞌaⁿ na tqueⁿꞌ jom. ");
INSERT INTO amuNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Tandyo xuee seijndaaꞌndyuꞌ ljoꞌ nlꞌana. Ndoꞌ majoꞌ jnda̱ lꞌana jeꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ndoꞌ jeꞌ jeꞌ ꞌu Ta, queⁿꞌ cwenta ñꞌoom wiꞌ na jndeiꞌnaꞌ na cwiluena nda̱a̱yâ, ndoꞌ cateijndeiꞌ jâ na cwindya̱ꞌntjo̱o̱ⁿyâ njomꞌ na calana̱a̱ⁿyâ ñꞌoom naya ꞌnaⁿꞌ ñequio na tꞌmaⁿ nꞌo̱o̱ⁿyâ. ");
INSERT INTO amuNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ndoꞌ catseintyjo̱ꞌ tsꞌo̱ꞌ nacjoo nnꞌaⁿwii. Catseinꞌmaⁿꞌ joona. Catsaꞌ ꞌnaaⁿ tꞌmaⁿ ñequio ꞌnaaⁿ na xocjaantyjo̱o̱ꞌ nꞌom nnꞌaⁿ chiuu tuiiyuu. Nmeiⁿꞌ catsaꞌ ee cwilcwiiꞌâ xueeꞌ Jndaꞌ Jesús na ljuꞌ tseixmaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Jnda̱ na jlaꞌneiⁿna nnom Tyꞌo̱o̱tsꞌom teiꞌncwiiꞌ wꞌaa yuu na cwitjomndyena. Ndoꞌ joona tooꞌ mꞌaaⁿ Espíritu Santo naquiiꞌ nꞌomna. Ndoꞌ tyolaꞌneiⁿna ñꞌoomꞌ Tyꞌo̱o̱tsꞌom ñequio na tꞌmaⁿ nꞌomna. ");
INSERT INTO amuNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Chaꞌtsondye nnꞌaⁿ na cwilaꞌyuꞌ tyomꞌaⁿna na ñeꞌcwii nꞌomna, ndoꞌ ñeꞌcwii tyolaꞌtiuuna. Meiⁿcwiindye joona ticatso na joo ꞌnaⁿ na maleiñꞌoom macanda̱ juu ꞌnaaⁿꞌ joꞌ, ee chaꞌtso ꞌnaⁿ na tyoleichona tyolꞌana na tjom na ꞌnaaⁿna joonaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ndoꞌ nquiee apóstoles tyotjeiiꞌyuuꞌndyena ñequio najndeii na matseixmaaⁿ na jnda̱ mawandoꞌxco Ta Jesús. Ndoꞌ tꞌmaⁿ tioꞌnaaⁿñe Tyꞌo̱o̱tsꞌom joona. ");
INSERT INTO amuNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Ndoꞌ quiiꞌntaaⁿ chaꞌtso nnꞌaⁿ na cwilaꞌyuꞌ tjaaꞌnaⁿ ꞌñeeⁿ cꞌoom na matseitjo̱o̱naꞌ juu ee nnꞌaⁿ na niom ndyuaa ndoꞌ niom lꞌaa tyonda̱a̱na joonaꞌ ndoꞌ cantyjati sꞌom na toꞌñoomna na nda̱a̱na joonaꞌ tquioñꞌomna. ");
INSERT INTO amuNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Tquiana sꞌomꞌñeeⁿ nda̱a̱ apóstoles. Ndoꞌ naⁿꞌñeeⁿ tyoñequiana joonaꞌ nnom ticwii cwii tsꞌaⁿ na matseitjo̱o̱naꞌ ꞌnaⁿ na macaⁿnaꞌ juu. ");
INSERT INTO amuNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Quiiꞌntaaⁿna tyomꞌaaⁿ tsꞌaⁿ na jndyu José. Jom tsꞌaⁿ tsjaaⁿ Leví na jndyowicantyjooꞌ, tuiiñê tyuaaxeⁿncwe Chipre. Apóstoles tqueⁿna xueeⁿꞌeⁿ Bernabé. Ñꞌoomwaaꞌ matsonaꞌ tsꞌaⁿ na mañequiaa na tꞌmaⁿ tsꞌom xꞌiaaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Jom waa tyuaaⁿꞌaⁿ. Jna̱a̱ⁿ juunaꞌ, jnda̱ chii jndyoñꞌoom sꞌom na toꞌñoom, tquiaaⁿ sꞌomꞌñeeⁿ nda̱a̱ apóstoles. ");
INSERT INTO amuNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Sa̱a̱ cwii tsaⁿsꞌa na jndyu Ananías ñequio scoomꞌm Safira nda̱a̱na cwii tyuaana. ");
INSERT INTO amuNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ananíasꞌñeeⁿ seitjo̱o̱ⁿ cantyja na jna̱a̱ⁿ juunaꞌ, ndoꞌ mati ntyjii scoomꞌm na ljoꞌ. Jndyochom meiⁿ ndyee sꞌomꞌñeeⁿ tquiaaⁿ joonaꞌ nda̱a̱ apóstoles. ");
INSERT INTO amuNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Quia joꞌ matso Pedro nnoom: —ꞌU re Ananías, ¿chiuu na tquiaandyuꞌ na seicatooꞌ Satanás naquiiꞌ tsꞌomꞌ na tsuꞌ cantu nnom Espíritu Santo na seitjo̱o̱ꞌ sꞌom cantyja na jnda̱a̱ꞌ tyuaꞌ? ");
INSERT INTO amuNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Yocheⁿ na tyoojnda̱a̱ꞌ juunaꞌ tseixmaⁿnaꞌ cwentaꞌ. Ndoꞌ mati meiiⁿ na jnda̱ jnda̱a̱ꞌ juunaꞌ wanaaⁿ na nntsaꞌ yuu na lꞌue tsꞌomꞌ ñequio sꞌomꞌñeeⁿ. ꞌU jeꞌ ¿chiuu na luaaꞌ seitiuuꞌ naquiiꞌ tsꞌomꞌ? Ee nchii nda̱a̱ nnꞌaⁿ saꞌ cantu, nnom nquii Tyꞌo̱o̱tsꞌom waa jnaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Jnda̱ na jndii Ananías ñꞌoommeiⁿꞌ cweꞌ tiooñetoom na tsꞌoo jom. Quia joꞌ chaꞌtsondye nnꞌaⁿ na nquiuna na luaaꞌ tuii, jeeⁿ ndyaꞌ nioom tyuena. ");
INSERT INTO amuNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Teicantyja naⁿnom na titquiendye. Jlaꞌtyjoondyena liaa jom. Jnda̱ chii tjeiiꞌna jom, mana tyꞌecatꞌiuuna jom. ");
INSERT INTO amuNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Jnda̱ teinom chaꞌna ndyee hora na tuii na ljoꞌ ndoꞌ tyjeeꞌ scuuꞌ Ananías. Meiⁿchjoo ticaljeiiⁿ aa waa ljoꞌ tuii. ");
INSERT INTO amuNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Quia joꞌ Pedro matsoom nnom tsaⁿꞌñeeⁿ: —Catsuꞌ no̱o̱ⁿ, ¿aa mayuuꞌ na laaꞌtiꞌndyo nda̱a̱ꞌyoꞌ tyuaaꞌyoꞌ? Ndoꞌ matso tsaⁿꞌñeeⁿ nnoom: —Mayuuꞌ na laaꞌtiꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Matso Pedro nnoom: —Chiuu na jlaꞌtjomꞌyoꞌ ñꞌoom na tquioꞌnnꞌaⁿꞌyoꞌ Espíritu na cwiluiiñe Tyꞌo̱o̱tsꞌom. Aa ndiꞌ, jeꞌ cwiquie nnꞌaⁿ na tyꞌecatꞌiuu saꞌ. Mati ꞌu majeꞌndyo nncꞌoocatꞌiuuna ꞌu. ");
INSERT INTO amuNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Mantyjacheⁿ cweꞌ tiooñetoom jo ncꞌee Pedro, mana tueeⁿꞌeⁿ. Quia na tyꞌequieꞌ naⁿnom na titquiendye jliuna na jnda̱ tueeⁿꞌeⁿ. Mati tjeiiꞌna jom, tyꞌecatꞌiuuna jom nacañoomꞌ saaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Quia joꞌ, tmaaⁿꞌ nnꞌaⁿ na macwjiꞌ Tyꞌo̱o̱tsꞌom cwentaaⁿꞌaⁿ, jeeⁿ tꞌmaⁿ seicatyꞌuenaꞌ ndoꞌ mati ntꞌomcheⁿ nnꞌaⁿ na tyondye na luaaꞌ tuii. ");
INSERT INTO amuNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Nnꞌaⁿ na cwiluiindyena apóstoles jndye nnom ꞌnaaⁿ lꞌana ñequio tsꞌiaaⁿ tꞌmaⁿ na xonda̱a̱ nluii na cweꞌ najndeii nquii tsꞌaⁿ. Ndoꞌ chaꞌtsondye nnꞌaⁿ na jnda̱ cwilaꞌyuꞌ tjoomꞌ tꞌmaⁿna na tyotjomndyena watsꞌom tꞌmaⁿ na jndyu leirooꞌnaꞌ Salomón. ");
INSERT INTO amuNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Sa̱a̱ ntꞌomcheⁿ nnꞌaⁿ nquiaana na nlaꞌjomndyena, meiiⁿ na ljoꞌ tyotjeiiꞌyana nnꞌaⁿ na cwilaꞌyuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ndoꞌ tjawijndyendyeti nnꞌaⁿ na tyolaꞌyuꞌ ñequio Ta Jesús, naⁿnom ndoꞌ naⁿlcu. ");
INSERT INTO amuNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Tyotsa̱ꞌna nnꞌaⁿwii ndyuee nantaa, cjooꞌ nduu ndoꞌ cjooꞌ luee, cha quia na wjaawinom Pedro nnquioo ncwaaⁿꞌaⁿ nacjoo cwantindye joona cha nnꞌmaaⁿna. ");
INSERT INTO amuNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Mati nnꞌaⁿ na mꞌaⁿ njoom na nndyooꞌ Jerusalén tquiochona nnꞌaⁿwii ñꞌeⁿ nnꞌaⁿ na tyoleichuu jndyetia. Ndoꞌ chaꞌtsondye naⁿꞌñeeⁿ nꞌmaaⁿna. ");
INSERT INTO amuNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Quia joꞌ tyee na cwiluiitquieñe ñequio tmaaⁿꞌ nnꞌaⁿ judíos na ñꞌeeⁿ ñꞌeⁿñê na jndyu saduceos, jlawendyena nacjoo apóstoles ee jeeⁿ lioona naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Joꞌ chii tꞌuena naⁿꞌñeeⁿ. Tioomna joo wꞌaancjo. ");
INSERT INTO amuNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Sa̱a̱ teijaaⁿ tyjeeꞌ cwii ángel cwentaaꞌ Ta Tyꞌo̱o̱tsꞌom. Seicanaaⁿñê ndyueelꞌa wꞌaancjo. Tjeiiⁿꞌeⁿ naⁿꞌñeeⁿ chꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","Matsoom nda̱a̱na: —Catsaꞌyoꞌ watsꞌom tꞌmaⁿ. Calaneiⁿꞌyoꞌ nda̱a̱ nnꞌaⁿ ñꞌoomwaaꞌ cantyja ꞌnaaⁿꞌ na nncwandoꞌ añmaaⁿꞌ tsꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Jnda̱ na jndyena ñꞌoomwaaꞌ tyꞌena. Ndoꞌ cwitsjoom tyꞌequieꞌna watsꞌom tꞌmaⁿ. Tyotꞌmo̱o̱ⁿna nda̱a̱ nnꞌaⁿ. Quia joꞌ tyee na cwiluiitquieñe ñequio nnꞌaⁿ na ñꞌeeⁿ ñꞌeⁿñê, jnda̱ na tjomndyena ñequio chaꞌtsondye nnꞌaⁿ na cwiluiindye naⁿmaⁿnꞌiaaⁿ nda̱a̱ nnꞌaⁿ Israel, sa̱ꞌntjomna na cjaacandyooꞌndye apóstoles na tioomna wꞌaancjo. ");
INSERT INTO amuNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Sa̱a̱ quia na jnda̱ tquie sondaro ꞌndyootsꞌa wꞌaancjo jliuna na tacꞌom naⁿꞌñeeⁿ joꞌ joꞌ. Joꞌ chii tyꞌelcweeꞌna. Tyꞌelaꞌcandiina na tacꞌom naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Jluena: —Quia na squia̱a̱yâ ꞌndyootsꞌa wꞌaancjo tyeⁿ ta̱ꞌnaꞌ ndoꞌ mꞌaⁿ sondaro na cwilꞌa cwenta, sa̱a̱ quia na jlaꞌcanaaⁿndyô̱ joꞌ jliuuyâ tjaaꞌñeeⁿ cꞌoom. ");
INSERT INTO amuNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Ndoꞌ tyee na cwiluiitquieñe ñequio tsꞌaⁿ na matsa̱ꞌntjom nnꞌaⁿ na cwilꞌa cwenta watsꞌom tꞌmaⁿ ñequio ntꞌomcheⁿ ntyee na cwiluiitquiendye, quia na jndyena na luaaꞌ, tyomꞌaaⁿꞌ nꞌomna chiuu ya nluii cha nleicheⁿ ñꞌoomwaaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ndoꞌ mañejuu xjeⁿꞌñeeⁿ tyjeeꞌcañoom cwii tsꞌaⁿ, seicandii joona, matso: —Nnꞌaⁿ na tiomꞌyoꞌ wꞌaancjo, naquiiꞌ watsꞌom tꞌmaⁿ meintyjeeꞌna jeꞌ. Cwitꞌmo̱o̱ⁿna nda̱a̱ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Quia joꞌ tsꞌaⁿ na matsa̱ꞌntjom tjaaⁿ ñꞌeⁿ nnꞌaⁿ ꞌnaaⁿꞌaⁿ. Tyꞌecachona naⁿꞌñeeⁿ sa̱a̱ nchii ñequio na jndeiꞌnaꞌ ee nquiaana xeⁿ nnꞌaⁿ na cwindye ñꞌoomꞌñeeⁿ njñom ljo̱ꞌ joona. ");
INSERT INTO amuNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ndoꞌ quia na jnda̱ tquienndaꞌna yuu cwitjomndye naⁿmanꞌiaaⁿ, tquiana cwenta pra̱so nda̱a̱ naⁿꞌñeeⁿ. Ndoꞌ tyee na cwiluiitquieñe, seilcwiiꞌñê nda̱a̱ pra̱soꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Matsoom: —Mandyeꞌyoꞌ na tyolꞌuuyâ nda̱a̱ꞌyoꞌ ñequio ñꞌoom na jndeiꞌnaꞌ na tantꞌmo̱ⁿꞌyoꞌ ñꞌoom cantyja ꞌnaaⁿꞌ Jesús. Sa̱a̱ ꞌo jeꞌ chaꞌwaa naquiiꞌ Jerusalén jnda̱ manquiu nnꞌaⁿ ñꞌoom na cwitꞌmo̱ⁿꞌyoꞌ nda̱a̱na. Mati cwinduꞌyoꞌ na jâ cho̱o̱yâ jnaⁿ na tueꞌ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Quia joꞌ Pedro ñequio ntꞌomcheⁿ apóstoles, tꞌo̱o̱na, jluena: —Jndeiꞌtinaꞌ na calacanda̱a̱yâ ñꞌoom na matso Tyꞌo̱o̱tsꞌom nchiiti ñꞌoom na cwilue nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Manqueⁿ na tyolaꞌtꞌmaaⁿꞌndye welooya na ñetꞌom teiyo, tquiaaⁿ na wandoꞌxco Jesús na jlaꞌcueꞌyoꞌ na tyꞌiomꞌyoꞌ nacjooꞌ tsꞌoomꞌnaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Seitꞌmaaⁿꞌñê juu. Tqueeⁿ juu ntyjaaꞌ tsꞌo̱o̱ⁿ ntyjaya. Tqueeⁿ juu na cwiluiitꞌmaaⁿñe ndoꞌ na macwjiꞌnꞌmaaⁿñe nnꞌaⁿ cha calcweꞌ nꞌom nnꞌaⁿ Israel ndoꞌ na nntseitꞌmaⁿ tsꞌom jnaaⁿna. ");
INSERT INTO amuNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Jâ cwitjeiꞌyuuꞌndyô̱ cantyja ꞌnaaⁿ ñꞌoommeiiⁿ, ndoꞌ majoꞌti machꞌee Espíritu Santo, nquii na mañequiaa Tyꞌo̱o̱tsꞌom naquiiꞌ nꞌom nnꞌaⁿ na cwilaꞌcanda̱ ñꞌoom na matsoom. ");
INSERT INTO amuNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Jnda̱ na jndye naⁿmaⁿnꞌiaaⁿ ñꞌoommeiⁿꞌ jeeⁿ ndyaꞌ lioona hasta ñeꞌcalaꞌcwjeena naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Sa̱a̱ teicantyja cwiindye joona, tsꞌaⁿ na jndyu Gamaliel. Jom tsꞌaⁿ tmaaⁿꞌ fariseos ndoꞌ maꞌmo̱o̱ⁿ chiuu matsa̱ꞌntjom ljeii na tqueⁿ Moisés, chaꞌtsondye nnꞌaⁿ ya ñꞌoom nquiuna cantyja ꞌnaaⁿꞌaⁿ. Teintyjeeⁿꞌeⁿ ndoꞌ sa̱ꞌntjoom na caluiꞌya apóstoles chꞌeⁿ chjoowiꞌ taⁿꞌndyo. ");
INSERT INTO amuNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Tsoom nda̱a̱ ncꞌiaaⁿꞌaⁿ: —ꞌO ntyja̱ño̱ⁿ nnꞌaⁿ Israel, calꞌaꞌyoꞌ cwenta ljoꞌ na cwilatiuuꞌyoꞌ na ñeꞌcalꞌaꞌyoꞌ ñꞌeⁿ naⁿnommꞌaⁿꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ee cjañjoomꞌ nꞌomꞌyoꞌ jaachꞌeeti xuee tyomꞌaaⁿ Teudas. Tyotsoom na jom tsꞌaⁿ na tꞌmaⁿ cwiluiiñe, ndoꞌ chaꞌna ñequiee siaⁿnto naⁿnom jlaꞌjomndyena ñꞌeⁿñê. Sa̱a̱ jlaꞌcueeꞌ nnꞌaⁿ jom, ndoꞌ chaꞌtsondye nnꞌaⁿ na jlaꞌjomndye ñꞌeⁿñê tꞌoomꞌndyena. Mana ntycwii cantyja ꞌnaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Jnda̱ teinom na ljoꞌ, xcwe na cwiwiljeiixco ncuee nnꞌaⁿ, mati seisꞌañe Judas tsꞌaⁿ Galileo. Ndoꞌ jndye nnꞌaⁿ jlaꞌjomndyena ñꞌeⁿñê. Sa̱a̱ mati jlaꞌcueeꞌ nnꞌaⁿ jom, ndoꞌ chaꞌtsondye nnꞌaⁿ na tyolaꞌjomndye ñꞌeⁿñê majoꞌti tꞌoomꞌndyena. ");
INSERT INTO amuNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Joꞌ chii matseijndo̱ꞌa nꞌomꞌyoꞌ, caꞌndyeꞌyoꞌ tiꞌmꞌaⁿꞌ. Cajndooꞌ nquieena, ee xeⁿ ñꞌoommeiⁿꞌ ñequio tsꞌiaaⁿmeiⁿꞌ cwilaꞌxmaⁿnaꞌ cweꞌ tsꞌiaaⁿ ꞌnaaⁿ nnꞌaⁿ quia joꞌ nncjaandyue cheⁿnquieenaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Sa̱a̱ xeⁿ cwilaꞌxmaⁿnaꞌ tsꞌiaaⁿ ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom, quia joꞌ tijoom canda̱a̱ na nlatyuiꞌyoꞌ joonaꞌ. Nleitquiooꞌto na cwitsaꞌyoꞌ nacjooꞌ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ndoꞌ jlaꞌjomndye ncꞌiaaꞌ Gamaliel ñꞌoom na tsoom nda̱a̱na. Joꞌ chii tqueeⁿꞌnndaꞌna apóstoles. Cweꞌ tyotjaaꞌna naⁿꞌñeeⁿ. Ndoꞌ ñequio na jndeiꞌnaꞌ tyoluena na tantꞌmo̱o̱ⁿ naⁿꞌñeeⁿ ñꞌoom ñequio xueeꞌ Jesús. Jnda̱ chii jñoomna naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ndoꞌ naⁿꞌñeeⁿ jeꞌ, jluiꞌna quiiꞌntaaⁿ naⁿmaⁿnꞌiaaⁿ ñequio na neiiⁿna na tquiaa Tyꞌo̱o̱tsꞌom na cwilaꞌxmaⁿna na coꞌwiꞌnaꞌ joona ncꞌe na cwitjeiꞌyuuꞌndyena ñꞌoom ñequio xueeꞌ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ndoꞌ ꞌio ndi ꞌio tîcꞌoomeintyjeeꞌna na tyotꞌmo̱o̱ⁿna naquiiꞌ watsꞌom tꞌmaⁿ ndoꞌ mati lꞌaa nnꞌaⁿ. Tyotꞌmo̱o̱ⁿna ndoꞌ tyolaꞌneiⁿna ñꞌoom cantyja ꞌnaaⁿꞌ Jesús na cwiluiiñe Cristo. ");
INSERT INTO amuNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Majoo ncueeꞌñeeⁿ tjawijndyendye nnꞌaⁿ na cwilaꞌyuꞌ. Sa̱a̱ we ndiꞌndyena. Ntꞌomndyena nnꞌaⁿ judíos na cwilaꞌneiⁿ griego ndoꞌ ntꞌom ncꞌiaana cwilaꞌneiⁿ hebreo. Ndoꞌ naⁿꞌñeeⁿ na cwilaꞌneiⁿna griego to̱ꞌna na jlaꞌncjooꞌndyena nacjooꞌ nnꞌaⁿ na cwilayuꞌ na cwilaꞌneiⁿ hebreo. Ee chaꞌtso yolcu na cwilaꞌyuꞌ na jnda̱ tja̱ noom ticwii xuee cwitoꞌñoomna nantquie. Sa̱a̱ joo yolcu na cwilaꞌneiⁿ griego tijndyeti cwitoꞌñoomna chaꞌxjeⁿ cwitoꞌñoom ncꞌiaana na cwilaꞌneiⁿ hebreo. Joꞌ na to̱ꞌna na jlaꞌncjooꞌndyena. ");
INSERT INTO amuNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Joꞌ chii canchooꞌwe apóstoles jlaꞌtjomna chaꞌtso nnꞌaⁿ na cwilaꞌyuꞌ. Jluena nda̱a̱ naⁿꞌñeeⁿ: —Ticatsa̱ꞌntjomnaꞌ na nꞌndya̱a̱yâ na cwiñeꞌquiaayâ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na njndo̱o̱ꞌâ cantyja ꞌnaaⁿꞌ nantquie. ");
INSERT INTO amuNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Joꞌ chii ꞌo nnꞌaaⁿya, catjeiiꞌndyoꞌ ntquieeꞌ tsaⁿsꞌa quiiꞌntaaⁿꞌyoꞌ na waa ñꞌoom ya cantyja ꞌnaaⁿna, na tooꞌ mꞌaaⁿ Espíritu Santo naquiiꞌ nꞌomna, ndoꞌ na jndo̱ꞌ nꞌomna. Joona nntꞌio̱o̱ⁿya tsꞌiaaⁿ na njndooꞌna cantyja ꞌnaaⁿꞌ nantquie na nntoꞌñoom yolcu na jnda̱ tja̱ noom. ");
INSERT INTO amuNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Sa̱a̱ jâ ñecwitco nlana̱a̱ⁿyâ nnom Tyꞌo̱o̱tsꞌom ndoꞌ na nñequiaayâ ñꞌoomꞌm nda̱a̱ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ndoꞌ chaꞌtso nnꞌaⁿ na cwilaꞌyuꞌ jlaꞌjomndyena na ljoꞌ. Joꞌ tjeiiꞌndyena Esteban, tsꞌaⁿ na matseiyuꞌya tsꞌom ndoꞌ tooꞌ naquiiꞌ tsꞌoom mꞌaaⁿ Espíritu Santo. Ndoꞌ mati Felipe, Prócoro, Nicanor, Timón ñequio Parmenas. Mati tjeiiꞌndyena Nicolás, tsꞌaⁿ tsjoom Antioquía. Jom nchii tsꞌaⁿ judío sa̱a̱ jaachꞌee xuee matseijomñê ñꞌoom na cwilaꞌtꞌmaaⁿꞌndye nnꞌaⁿ judíos. ");
INSERT INTO amuNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Jnda̱ na tjeiiꞌndyena naⁿꞌñeeⁿ chii tquiochona joo na mꞌaⁿ apóstoles. Ndoꞌ joona jlaꞌneiⁿna nnom Tyꞌo̱o̱tsꞌom cantyja ꞌnaaⁿ naⁿꞌñeeⁿ. Jnda̱ chii tioona lueena nacjoo naⁿꞌñeeⁿ na cwitoꞌñoom tsꞌiaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ndoꞌ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom jndyeti tjantyꞌeenaꞌ. Ndoꞌ tyꞌewijndyendyeti nnꞌaⁿ na cwilaꞌyuꞌ naquiiꞌ Jerusalén hasta mati jndye ntyee cantyja ꞌnaaⁿ nnꞌaⁿ judíos tyolaꞌyuꞌya cwii nꞌom. ");
INSERT INTO amuNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Esteban tꞌmaⁿ najndeii Tyꞌo̱o̱tsꞌom tyotseixmaaⁿ. Jndye ꞌnaaⁿ sꞌaaⁿ quiiꞌntaaⁿ nnꞌaⁿ ñequio tsꞌiaaⁿ tꞌmaⁿ na xocanda̱a̱ nluii na cweꞌ najndeii nquii tsꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Tyowaa cwii watsꞌom cwentaa nnꞌaⁿ judíos na jndyu tmaaⁿꞌ nnꞌaⁿ mꞌaⁿcandyaaꞌndye. Naⁿꞌñeeⁿ jnaⁿna tsjoom Cirene ñequio tsjoom Alejandría ndoꞌ ndyuaa Cilicia ñequio ndyuaa Asia. Ntꞌomndye naⁿꞌñeeⁿ to̱ꞌna tjawa ñꞌoom na tyolaꞌneiⁿna ñꞌeⁿ Esteban. ");
INSERT INTO amuNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Sa̱a̱ tileicanaⁿndyena na nncwinomꞌna jom ñꞌoom na matseineiiⁿ ee jom matseineiiⁿ ñequio na jndo̱ꞌya tsꞌoom ncꞌe matseixmaaⁿ Espíritu Santo. ");
INSERT INTO amuNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Quia joꞌ cweꞌ ntꞌiu tyotsa̱ꞌntjomna nnꞌaⁿ na calue cantu nacjooꞌ Esteban, na jnda̱ jndyena na tyotseineiiⁿ ñꞌoom tia nacjooꞌ Moisés ndoꞌ nacjooꞌ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Jnda̱ na jlue naⁿꞌñeeⁿ cantu jeeⁿ seijmeiⁿꞌnaꞌ nnꞌaⁿ quiiꞌ tsjoom ñequio nnꞌaⁿ na cwiluiitquiendye ñequio nnꞌaⁿ na cwitꞌmo̱o̱ⁿ ljeii na tqueⁿ Moisés. Ndoꞌ tyꞌena nacjooꞌ Esteban. Tꞌuena jom. Tyꞌeñꞌomna jom jo nda̱a̱ naⁿmaⁿnꞌiaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Ndoꞌ tqueeⁿꞌndyena ntꞌomcheⁿ nnꞌaⁿ na calue cantu nacjoomꞌm. Tyolue naⁿꞌñeeⁿ: —Tsaⁿsꞌamꞌaaⁿꞌ ñequiiꞌcheⁿ matseineiiⁿ ñꞌoom tia nacjooꞌ watsꞌom tꞌmaⁿ na matseixmaⁿnaꞌ cwentaaꞌ Tyꞌo̱o̱tsꞌom ndoꞌ nacjooꞌ ljeii na tqueⁿ Moisés. ");
INSERT INTO amuNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ee jnda̱ jndya̱a̱yâ na tyotsoom na Jesús na jnaⁿ Nazaret nntseityuiiꞌ watsꞌomwaañe ndoꞌ nntseichuiiꞌ costumbre na tquiaa Moisés nda̱a̱ya. ");
INSERT INTO amuNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ndoꞌ chaꞌtso naⁿmaⁿnꞌiaaⁿ na meindyuaandye ntyꞌiaana Esteban. Jliuna seichuiiꞌnaꞌ nnoom, sꞌaanaꞌ chaꞌcwijom nnom ángel. ");
INSERT INTO amuNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Quia joꞌ tyee na cwiluiitquieñe taxꞌeeⁿ nnom Esteban, matsoom: —¿Aa mayuuꞌ na ljoꞌ tsuꞌ? ");
INSERT INTO amuNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Tꞌo̱ Esteban matsoom: —ꞌO ta na cwiluiitquiendyoꞌ ñequio ꞌo nnꞌaⁿya, candyeꞌyoꞌ ñꞌoom na nntsjo̱o̱. Nquii Taya Tyꞌo̱o̱tsꞌom na jeeⁿ tꞌmaⁿ cwiluiiñê, jom seicaꞌmo̱ⁿñê nnom welooya Abraham quia na tyomꞌaaⁿ tsaⁿꞌñeeⁿ ndyuaa Mesopotamia cwii tjo̱o̱cheⁿ na nncꞌoom tsjoom Harán. ");
INSERT INTO amuNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Tsoom nnom: “Caluiꞌ ñjaaⁿñe ndyuaa tsjomꞌ. Caꞌndiiꞌ nnꞌaⁿꞌ, cjaꞌ ndyuaa yuu na mꞌmo̱o̱ⁿya njomꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Quia joꞌ jlueeⁿꞌeⁿ ndyuaa tsjomꞌm, ndyuaa Caldea. Tjaaⁿ ndyuaa Harán, tyomꞌaaⁿñê joꞌ joꞌ. Ndoꞌ jnda̱ na tueꞌ tsotyeeⁿ, jndyoñꞌoom Tyꞌo̱o̱tsꞌom jom ndyuaameiiⁿ yuu na mꞌaⁿꞌyoꞌ jeꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Sa̱a̱ tînquiaa Tyꞌo̱o̱tsꞌom na nnaaⁿꞌaⁿ ndyuaameiiⁿñe meiⁿ cweꞌ yuu na nncwintyjeeⁿꞌeⁿ. Sa̱a̱ tyeⁿ ꞌndii Tyꞌo̱o̱tsꞌom ñꞌoom nnoom na maxjeⁿ nnaaⁿꞌaⁿ ndyuaameiiⁿ. Nncuaanaꞌ cwentaa nnꞌaⁿ na nluiindyena tsjaaⁿ ꞌnaaⁿꞌ jom xeⁿ jnda̱ tueeⁿꞌeⁿ meiiⁿ xjeⁿꞌñeeⁿ tjaaꞌnaⁿ ntseinaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Tso Tyꞌo̱o̱tsꞌom na joo nnꞌaⁿ na nluiindyena tsjaaⁿ ꞌnaaⁿꞌ Abraham cwiicheⁿ ndyuaa na nncꞌomna na nchii ndyuaana. Tyeⁿ nndyeꞌntjomna nda̱a̱ nnꞌaⁿ ndyuaaꞌñeeⁿ ndoꞌ wiꞌ nntjoomna nlꞌa naⁿꞌñeeⁿ cwii ñequiee siaⁿnto ntyu. ");
INSERT INTO amuNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ndoꞌ tso Tyꞌo̱o̱tsꞌom nnoom: “Ja nncuꞌxa̱ⁿ nnꞌaⁿ ndyuaaꞌñeeⁿ yuu na nndyeꞌntjomtyeⁿ nnꞌaⁿ na nluiindyena tsjaaⁿ ꞌnaⁿꞌ na wjaawicantyjooꞌ, jnda̱ chii nluiꞌna joꞌ joꞌ. Tyuaawaañe nncꞌomna nlatꞌmaaⁿꞌndyena ja.” ");
INSERT INTO amuNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Tqueⁿtyeⁿ Tyꞌo̱o̱tsꞌom ñꞌoom nnom Abraham na catsꞌaaⁿ ꞌnaaⁿ tjaaⁿꞌ yuꞌndaa na nluiiñe na tsaⁿsꞌa. Joꞌ chii quia na tuiiñe jnaaⁿ Isaac, sꞌaaⁿ na ljoꞌ juu jnda̱ na jnda̱a̱ꞌ ñeeⁿ xuee na tuiiñe. Majoꞌti sꞌaa Isaac ñequio jnaaⁿ Jacob. Ndoꞌ Jacob ñecwii xjeⁿ sꞌaaⁿ ñequio canchooꞌwe ntseinaaⁿ na yonom, nnꞌaⁿ na cwiluiindye weloo jaa na canchooꞌwe ntmaaⁿꞌ nnꞌaⁿ Israel. ");
INSERT INTO amuNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","’Sa̱a̱ joo ntseinda Jacob, joꞌ welooya na ñetꞌom teiyo, jeeⁿ ta̱a̱ꞌ nꞌomna tyjeena José. Nda̱a̱na jom nda̱a̱ nnꞌaⁿ na tyꞌeñꞌom jom ndyuaa Egipto. Sa̱a̱ Tyꞌo̱o̱tsꞌom tyomꞌaaⁿ ñꞌeⁿñê ndyuaaꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Seicandyaañe jom naquiiꞌ chaꞌtso nawiꞌ na tyotjoom. Tquiaa na jndo̱ꞌ tsꞌoom ndoꞌ sꞌaa na neiiⁿꞌ tsꞌom Faraón jom. Faraónꞌñeeⁿ cwiluiiñê tsaⁿmaⁿtsꞌiaaⁿ tꞌmaⁿ ndyuaa Egipto, ndoꞌ jom tyꞌioom tsꞌiaaⁿ José na catsa̱ꞌntjom tsaⁿꞌñeeⁿ chaꞌwaa ndyuaa Egipto hasta mati catsa̱ꞌntjom naquiiꞌ watsꞌiaaⁿ ꞌnaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","’Xjeⁿꞌñeeⁿ jnaⁿnaꞌ na jndyo cwii jndoꞌ tꞌmaⁿ chaꞌwaa ndyuaa Egipto ñequio ndyuaa Canaán. Tꞌmaⁿ nawiꞌ tyotjoom nnꞌaⁿ. Ndoꞌ welooya taticaliuna ljoꞌ na nlcwaꞌna. ");
INSERT INTO amuNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Sa̱a̱ jnda̱ na jndii Jacob na niom nantquie ndyuaa Egipto, jñoom ntseinaaⁿ welooya najndyee tyꞌena joꞌ joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Jnda̱ chii tyꞌenndaꞌna na jnda̱ we. Joꞌ na secaño̱o̱ⁿ José na tyjeena jom. Ndoꞌ tsaⁿmaⁿtsꞌiaaⁿ tꞌmaⁿꞌñeeⁿ tajnaⁿꞌaⁿ na nnꞌaaⁿꞌ José naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Nda̱nquia seijndaaꞌñe José na quiona ñequio tsotyena Jacob ñequio chaꞌtso nnꞌaⁿ wꞌaana. Joona jnda̱a̱ꞌ ndyeenꞌaaⁿ nchooꞌ qui nchooꞌ ꞌomndyena. ");
INSERT INTO amuNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Quia joꞌ tja Jacob ndyuaa Egipto. Joꞌ joꞌ mꞌaaⁿ ndoꞌ tueeⁿꞌeⁿ ndoꞌ mati joꞌ joꞌ tja̱ ntseinaaⁿ, joo welooya na ñetꞌom teiyo. ");
INSERT INTO amuNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Jnda̱ chii tyꞌeñꞌomlcweꞌ ntseinda Jacob seiꞌtsꞌo ꞌnaaⁿꞌaⁿ tsjoom Siquem ndyuaa yuu na jnaⁿna. Joꞌ joꞌ tjacantꞌiuuꞌñê naquiiꞌ tseiꞌtsuaa na seijnda Abraham ñequio sꞌom xuee nda̱a̱ ntseinda Hamor. ");
INSERT INTO amuNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Tsoti Esteban: —Welooya nnꞌaⁿ Israel na ñetꞌom teiyo, tyomꞌaⁿtina ndyuaa Egipto. Ndoꞌ yocheⁿ na tjatseicanda̱a̱ꞌñenaꞌ ñꞌoom na tso Tyꞌo̱o̱tsꞌom nnom Abraham na nntsꞌaaⁿ, yacheⁿ tjawijndyendyena. ");
INSERT INTO amuNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Jndye nnꞌaⁿ ñetꞌom tsꞌiaaⁿ tꞌmaⁿ ndyuaa Egipto. Ndoꞌ tueeꞌntyjo̱ na tjaquieeꞌ cwii tsꞌaⁿ tsꞌiaaⁿꞌñeeⁿ na ticaljeii cantyja ꞌnaaⁿꞌ tsꞌoo José. ");
INSERT INTO amuNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Cwajndii sꞌaaⁿ. Tcoꞌweeⁿꞌeⁿ welooya. Sa̱ꞌntjoom na caꞌndyetona yoꞌndaa ndana na cwjeto. ");
INSERT INTO amuNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Joo ncueeꞌñeeⁿ tuiiñe Moisés. Tjaweeꞌ tsꞌom Tyꞌo̱o̱tsꞌom yuꞌndaa. Tyomꞌaaⁿñê waaꞌ tsotyeeⁿ chaꞌna ndyee chiꞌ na teixꞌeetina jom. ");
INSERT INTO amuNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Jnda̱ chii ꞌndyena jom na cueeⁿꞌeⁿ sa̱a̱ majuuto yuscu jnda tsaⁿmaⁿtsꞌiaaⁿ tꞌmaⁿꞌñeeⁿ ljeii jom. Sꞌaa chaꞌna jnda jom. ");
INSERT INTO amuNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Joꞌ chii tyotseiꞌnaⁿꞌaⁿ chaꞌtso na jndo̱ꞌ nꞌom nnꞌaⁿ ndyuaa Egipto. Tꞌoom na jndo̱ꞌ tsꞌoom na tyotseineiiⁿ ndoꞌ na tyochꞌeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","’Ndoꞌ Moisés, quia na tueeꞌ chaꞌna wenꞌaaⁿ choomꞌm sꞌaanaꞌ tsꞌoom na ñeꞌcjaacanoomꞌm nnꞌaⁿ tsjaaⁿ na tuiiñê ntseindacantyjo Israel. ");
INSERT INTO amuNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Tjaaⁿ ndoꞌ ntyꞌiaaⁿꞌaⁿ na macoꞌwiꞌ cwii tsꞌaⁿ Egipto cwii tsꞌaⁿ tsjaaⁿ na tuiiñê. Joꞌ chii tjacwañomꞌm tsaⁿꞌñeeⁿ. Tjeiiꞌñê juu nawiꞌ na matjom. Seicueⁿꞌeⁿ tsꞌaⁿ Egipto. ");
INSERT INTO amuNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ee seitioom na nlaꞌno̱ⁿꞌ nnꞌaaⁿꞌaⁿ nnꞌaⁿ Israel na Tyꞌo̱o̱tsꞌom nntseicandyaañe joona ñequio lꞌo̱ jom, sa̱a̱ tîcalaꞌno̱ⁿꞌna. ");
INSERT INTO amuNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ndoꞌ cwiicheⁿ xuee ljeiiⁿ we nnꞌaⁿ Israel na cwilantjaꞌndye. Ndoꞌ na lꞌue tsꞌoom na caljoyaandyena, joꞌ chii tsoom nda̱a̱na: “ꞌO re mannꞌaaⁿndyoꞌ. ¿Chiuu na cwilantjaꞌndyoꞌ?” ");
INSERT INTO amuNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Quia joꞌ juu tsꞌaⁿ na malꞌue tiaꞌ ñꞌeⁿ xꞌiaaꞌ, ntqueeⁿ Moisés. Matsoom nnom: “¿ꞌÑeeⁿ juu tqueⁿ ꞌu na nntsa̱ꞌntjomꞌ jâ, ndoꞌ na nncuꞌxeⁿꞌ jâ? ");
INSERT INTO amuNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Aa ñeꞌcatseicueꞌ ja, chaꞌna seicueꞌ tsꞌaⁿ Egipto wja?” ");
INSERT INTO amuNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Jnda̱ na jndii Moisés ñꞌoomwaaꞌ, jleinoom. Tjaaⁿ ndyuaa Madián. Mana ljooꞌñeyaaⁿ joꞌ joꞌ. Ndoꞌ joꞌ joꞌ tocoom, tuiindye we ntseinaaⁿ naⁿnom. ");
INSERT INTO amuNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","’Quia na jnda̱ teinom wenꞌaaⁿ ntyu na mꞌaaⁿ joꞌ joꞌ seijomnaꞌ na mꞌaaⁿ cwii joo quiiꞌ jnda̱a̱ na nndyooꞌ sjo̱ Sinaí ndoꞌ teitquiooꞌñe cwii ángel nnoom naquiiꞌ ntsaachom na cwico tsaꞌ tsꞌo̱o̱ nꞌioom. ");
INSERT INTO amuNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Tꞌmaⁿ seitsaⁿꞌnaꞌ jom na ntyꞌiaaⁿꞌaⁿ na ljoꞌ. Ndoꞌ seicandyooꞌñê na nntyꞌiaaꞌyaaⁿ ndoꞌ jñeeⁿ na matseineiⁿ Ta Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","Matso: “Ja cwiluiindyo̱ Tyꞌo̱o̱tsꞌom cwentaaꞌ weloꞌ Abraham tsaⁿ na ñetꞌoom teiyoticheⁿ, ñꞌeⁿ Isaac, ñꞌeⁿ Jacob.” Quia na jndii Moisés na ljoꞌ, teiñê na macatyꞌueeⁿ. Meiⁿ tîcꞌoomtꞌmaaⁿꞌñê tsꞌoom na nntyꞌiaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ndoꞌ matso Tyꞌo̱o̱tsꞌom nnoom: “Cwjiꞌ lcomꞌ na ñjomꞌ ee yujoꞌ yuu na meintyjeꞌ matseixmaⁿnaꞌ tyuaa na ljuꞌ ee ñjaaⁿ tyjeꞌcaño̱o̱ⁿya. ");
INSERT INTO amuNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Ja jnda̱ ntyꞌiayaya na cwitaꞌwiꞌ nnꞌaⁿ ndyuaa Egipto nnꞌaⁿya nnꞌaⁿ Israel ndoꞌ jnda̱ jndiiya na cwitcweena. Ndoꞌ jnda̱ jndyocua̱ya na nntseicandyaandyo̱ joona. Joꞌ chii majño̱o̱ⁿya ꞌu na cjaꞌlcweꞌ ndyuaa Egipto.” ");
INSERT INTO amuNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Tsoticheⁿ Esteban: —Moisésꞌñeeⁿ, ñelꞌa nnꞌaⁿ Israel na ticueeꞌ nꞌomna jom. Jluena nnoom: “¿ꞌÑeeⁿ tqueⁿ ꞌu na nntsa̱ꞌntjomꞌ jâ ndoꞌ na nncuꞌxeⁿꞌ jâ?” Sa̱a̱ majuutoom tyꞌiom Tyꞌo̱o̱tsꞌom tsꞌiaaⁿ jom na catsa̱ꞌntjoom joona ndoꞌ cantyja ꞌnaaⁿꞌ na nndyaandyena nawiꞌ na tyomꞌaⁿna. Luaaꞌ sꞌaa Tyꞌo̱o̱tsꞌom xjeⁿ na teitquiooꞌñe ángel nnoom naquiiꞌ tsaꞌ tsꞌo̱o̱ nioom na cwico. ");
INSERT INTO amuNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Majuu Moisésꞌñeeⁿ tjeiiⁿꞌeⁿ welooya nnꞌaⁿ Israel na ñetꞌom ndyuaa Egipto. Jndye ꞌnaaⁿ tꞌmaⁿ tyochꞌeeⁿ ndyuaaꞌñeeⁿ na tjaa ꞌñeeⁿ juu nnda̱a̱ nntsꞌaa na cweꞌ na jndeii nquii. Mati tyochꞌeeⁿ tsꞌiaaⁿ tꞌmaⁿ quia na teiꞌnomna Ndaaluee Wee ndoꞌ quia na tyomꞌaⁿna ndyuaa yuu tjaa nnꞌaⁿ cꞌoom wenꞌaaⁿ ntyu. ");
INSERT INTO amuNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Manqueⁿ na tsoom nda̱a̱ nnꞌaⁿ Israel: “Tyꞌo̱o̱tsꞌom nlqueeⁿ cwii nnꞌaⁿꞌyoꞌ na nñequiaa ñꞌoomꞌm nda̱a̱ꞌyoꞌ chaꞌxjeⁿ na tqueeⁿ ja.” ");
INSERT INTO amuNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Majom na tyocañꞌeeⁿ ñꞌeⁿndyena quia na tyotjomndyena ndyuaa yuu tjaa nnꞌaⁿ cꞌoom. Joꞌ joꞌ seineiⁿ ángel ñꞌeⁿñê sjo̱ Sinaí. Jnda̱ chii jom seineiiⁿ nda̱a̱ welooya nnꞌaⁿ Israel. Jom toꞌñoom ñꞌoom na mañequiaanaꞌ na tseixmaⁿ tsꞌaⁿ na wandoꞌ añmaaⁿꞌ na jndyoteincooꞌ ñꞌoomꞌñeeⁿ nda̱a̱ jaa. ");
INSERT INTO amuNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","’Sa̱a̱ welooya tiñeꞌcalacanda̱na ñꞌoom na tsoom nda̱a̱na. Tiñeꞌcalañꞌoomꞌndyena jom ndoꞌ lꞌana na ñeꞌcꞌoolcweeꞌna ndyuaa Egipto. ");
INSERT INTO amuNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Yocheⁿ na tyomꞌaaⁿ xqueⁿ sjo̱ Sinaí jluena nnom Aarón: “Catsaꞌ ꞌnaⁿ na nlatꞌmaaⁿꞌndyo̱ na nncꞌoojndyeenaꞌ jo nda̱a̱ya na nntsaalcwa̱a̱ꞌa Egipto ee ticaliuuya ljoꞌ tjom Moisés tsꞌaⁿ na tjeiꞌ jaa joꞌ joꞌ.” ");
INSERT INTO amuNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ndoꞌ lꞌana cwii ꞌnaⁿ chaꞌcwijom quiooꞌjndyo chjoo. Ndoꞌ nnom juunaꞌ tyolaꞌcwjeena quiooꞌ na tyolaꞌtꞌmaaⁿꞌndyena na lꞌana xuee. Jeeⁿ neiiⁿna ñequio juunaꞌ, ndoꞌ cweꞌ ꞌnaⁿ na lꞌa nquieena. ");
INSERT INTO amuNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Joꞌ chii ꞌndii Tyꞌo̱o̱tsꞌom joona. ꞌNdiitoom na calatꞌmaaⁿꞌndyetona meiiⁿ cweꞌ cancjuu na mꞌaⁿ tsjo̱ꞌluee. Ee naquiiꞌ libro na teiljeii ñꞌoom ndyuee profetas, matsonaꞌ: ꞌO nnꞌaⁿ Israel, ¿aa no̱o̱ⁿya tyoñequiaꞌyoꞌ quiooꞌ na tyolacwjeꞌyoꞌ wenꞌaaⁿ ntyuꞌñeeⁿ na tyomꞌaⁿꞌyoꞌ ndyuaa yuu tjaa nnꞌaⁿ cꞌoom? ");
INSERT INTO amuNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Nchii joꞌ lꞌaꞌyoꞌ ee ñejleiñꞌomꞌyoꞌ wꞌaaliaa na ndiiꞌ juu na tyolatꞌmaaⁿꞌndyoꞌ na jndyu Moloc. Ndoꞌ ñejleiñꞌomꞌyoꞌ caxjuu cwentaaꞌ juu na tyolatꞌmaaⁿꞌndyoꞌ na jndyu Renfán. Ñequiiꞌcheⁿ ꞌnaⁿ na ñelꞌaꞌ ncjoꞌyoꞌ ñejlatꞌmaaⁿꞌndyoꞌ. Joꞌ chii jeꞌ nncwjiiꞌa ꞌo ndyuaa tsjomꞌyoꞌ, nntsaꞌyoꞌ hasta cwiicheⁿ na ntyjaaꞌ tsjoom Babilonia. ");
INSERT INTO amuNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Tsoti Esteban: —Juu ndyuaa yuu tjaa nnꞌaⁿ cꞌoom, tyoleiñꞌom welooya wꞌaaliaa yuu tyolawena ljo̱ꞌ lcaaꞌ na chuuꞌ ljeii na tqueⁿ Tyꞌo̱o̱tsꞌom na matsa̱ꞌntjomnaꞌ. Wꞌaaliaaꞌñeeⁿ tuiinaꞌ chaꞌxjeⁿ na sa̱ꞌntjom Tyꞌo̱o̱tsꞌom Moisés na catsꞌaaⁿ juunaꞌ chaꞌxjeⁿ na jnda̱ tꞌmo̱o̱ⁿ nnom. ");
INSERT INTO amuNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Juunaꞌ tquioñꞌom ndacantyjo welooya quia na jndyochuu Josué joona ndyuaameiiⁿñe, ndyuaa na seijndaaꞌñe Tyꞌo̱o̱tsꞌom na nndaana. Joꞌ chii tjeiiⁿꞌeⁿ nnꞌaⁿ na ñetꞌom ndyuaameiiⁿñe cha ljooꞌndye welooya juunaꞌ. Ndoꞌ ljooñe tyoleiñꞌomtina wꞌaaliaaꞌñeeⁿ hasta quia na tyomꞌaaⁿ David. ");
INSERT INTO amuNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Tjaweeꞌ tsꞌom Tyꞌo̱o̱tsꞌom ñꞌeⁿ David. Ñeꞌcatsꞌaaⁿ wꞌaa yuu na nncꞌoom Tyꞌo̱o̱tsꞌom na tyotseitꞌmaaⁿꞌñe weloomꞌm Jacob tsaⁿ na ñetꞌoom teiyocheⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Sa̱a̱ jnaaⁿ Salomón juu sꞌaa wꞌaaꞌñeeⁿ cwentaaꞌ Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Sa̱a̱ nquii Tyꞌo̱o̱tsꞌom na mꞌaaⁿ na ndyeticheⁿ, nchii cweꞌ naquiiꞌ lꞌaa na cwilꞌa nnꞌaⁿ macꞌeeⁿ. Ee luaaꞌ tyotso profeta. Seineiⁿ tsaⁿꞌñeeⁿ ñꞌoom na seijno̱o̱ⁿꞌo̱ⁿ tsꞌom. Matsoom: ");
INSERT INTO amuNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Cañoomꞌluee matseixmaⁿnaꞌ ndio ꞌnaⁿya yuu na mawacatya̱ⁿ na matsa̱ꞌntjo̱ⁿya. Ndoꞌ tsjoomnancue matseixmaⁿnaꞌ cweꞌ chaꞌna ꞌnaⁿ yuu na cwiquieꞌ ncꞌa̱. Ncꞌe na ljoꞌ, ¿cwaaⁿ wꞌaa na nlꞌaꞌyoꞌ cwentaya? Ndoꞌ ¿yuu waa cwii joo na ya na nncwajndya̱ya? ");
INSERT INTO amuNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Aa nchii nnco̱ sꞌaa cañoomꞌluee ñꞌeⁿ tsjoomnancue? ");
INSERT INTO amuNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Tsoti Esteban: —ꞌO maxjeⁿ quieꞌ nꞌomꞌyoꞌ. Matseijomnaꞌ ꞌo chaꞌna nnꞌaⁿ na tyoolatꞌmaaⁿꞌndye Tyꞌo̱o̱tsꞌom ee tiñeꞌcandyeꞌyoꞌ meiⁿ tiñeꞌcalacanda̱ꞌyoꞌ. Ñequiiꞌ na cwitsaꞌyoꞌ nacjooꞌ Espíritu Santo. Chaꞌna tyolꞌa weloꞌyoꞌ na ñetꞌom teiyo majoꞌti cwilꞌaꞌ ꞌo. ");
INSERT INTO amuNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Weloꞌyoꞌ na ñetꞌom teiyo, ¿Aa tyomꞌaaⁿ ꞌñeeⁿ na tyoñequiaa ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na tîcataꞌwiꞌna juu? Maxjeⁿ tjaaꞌnaⁿ. Jlaꞌcwjee weloꞌyoꞌ nnꞌaⁿ na tyolaꞌcandii na nndyo nquii Cristo na cwiluiiñe na matyꞌiomyanaꞌ. Ndoꞌ ꞌo jeꞌ jnda̱ tquiaꞌyoꞌ cwenta jom ndoꞌ jnda̱ jlaꞌcueꞌyoꞌ jom. ");
INSERT INTO amuNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Mancjoꞌtoꞌyoꞌ na toꞌñoomꞌyoꞌ ljeii na tqueⁿ Moisés na tquia ángeles. Sa̱a̱ tîcalacanda̱ꞌyoꞌ juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Jnda̱ na jndye naⁿꞌñeeⁿ ñꞌoommeiⁿꞌ jlaꞌjmeiⁿꞌndyena. Tyoteinquiena ndeiꞌnꞌomna na jeeⁿ lioona Esteban. ");
INSERT INTO amuNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Sa̱a̱ jom na tooꞌ naquiiꞌ tsꞌoom mꞌaaⁿ Espíritu Santo, jlunda̱a̱ñê ntyꞌiaaⁿꞌaⁿ cañoomꞌluee. Ntyꞌiaaⁿꞌaⁿ na neiⁿcooꞌ caxuee yuu na mꞌaaⁿ nquii Tyꞌo̱o̱tsꞌom ndoꞌ ntyꞌiaaⁿꞌaⁿ Jesús na meintyjeeꞌ jo ntyjaaꞌ Tyꞌo̱o̱tsꞌom ntyjaya. ");
INSERT INTO amuNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ndoꞌ matsoom: —Cantyꞌiaꞌyoꞌ. Mantyꞌiaya na jnda̱ jnaaⁿ cañoomꞌluee, ndoꞌ nquii Jesús na jnaⁿ joꞌ joꞌ, meintyjeeꞌ ntyjaaꞌ Tyꞌo̱o̱tsꞌom ntyjaya. ");
INSERT INTO amuNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Quia joꞌ jndeii tyolaxuaana na jmeiⁿꞌndyena. Jlacuꞌna luaꞌquina ndoꞌ ñejom tyꞌenomna nacjoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ndoꞌ jndeii tyꞌentquieena jom nnom tsjoom. Jnda̱ chii nnꞌaⁿ na tyolue na waa jnaaⁿꞌaⁿ tjeiiꞌna liaa na teincoo na cweeꞌna. Tsa̱ꞌna joonaꞌ, ndoꞌ cwii tsꞌaⁿ na titquieñe na jndyu Saulo jom sꞌaaⁿ cwenta joonaꞌ. Jnda̱ chii tyotmeiiⁿꞌna ljo̱ꞌ Esteban. ");
INSERT INTO amuNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ndoꞌ yocheⁿ na cwitmeiiⁿꞌna ljo̱ꞌ jom, seineiiⁿ nnom Tyꞌo̱o̱tsꞌom, matsoom: —Ta Jesús, coñomꞌ añmaⁿ ꞌnaⁿya. ");
INSERT INTO amuNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Jnda̱ chii tcoomꞌm xtyeeⁿ. Jndeii seixuaⁿ, matsoom: —Ta, tincwjaaꞌndyuꞌ cwenta jnaaⁿna na cwilaꞌcueeꞌna ja. Jnda̱ tsoom na luaaꞌ mana tueeⁿꞌeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ndoꞌ tyomꞌaaⁿ Saulo joꞌ joꞌ, seijomñê na jlaꞌcueeꞌ nnꞌaⁿ Esteban. Majuu xuee na jlacueeꞌna Esteban jnaⁿnaꞌ cwajndii tyontyjo̱ nnꞌaⁿ Jerusalén tmaaⁿꞌ nnꞌaⁿ na macwjiꞌ Tyꞌo̱o̱tsꞌom cwentaaⁿꞌaⁿ joꞌ joꞌ. Joꞌ chii chaꞌtsondyena tyotꞌoomꞌndyena chaꞌwaa tsꞌo̱ndaa Judea ñequio tsꞌo̱ndaa Samaria. Macanda̱ nquiee apóstoles tîcatꞌoomꞌndyena. ");
INSERT INTO amuNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Ntꞌom naⁿnom na jeeⁿ xcweeꞌ nꞌom ñꞌeⁿ Tyꞌo̱o̱tsꞌom tyꞌecatꞌiuuna Esteban. Jeeⁿ tyotyueena na jnda nquiuna jom. ");
INSERT INTO amuNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ndoꞌ Saulo cwajndii tyocoꞌweeⁿꞌeⁿ tmaaⁿꞌ nnꞌaⁿ na macwjiꞌ Tyꞌo̱o̱tsꞌom cwentaaⁿꞌaⁿ. Tyojaaqueⁿꞌeⁿ meiⁿ quiiꞌ lꞌaa ndoꞌ ñequio na jndeiꞌnaꞌ tyocwjeeⁿꞌeⁿ naⁿnom ndoꞌ naⁿlcu. Tyocjaachom joona. Tyotioom joona wꞌaancjo. ");
INSERT INTO amuNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Sa̱a̱ naⁿꞌñeeⁿ na tꞌoomꞌndye tyomaꞌnomna. Meiⁿyuucheⁿ na tquiena tyolaꞌneiⁿna ñꞌoomꞌ Tyꞌo̱o̱tsꞌom nda̱a̱ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Cwii joona, tsꞌaⁿ na jndyu Felipe, tjacueeⁿ cwii tsjoom tsꞌo̱ndaa Samaria. Tyotseineiiⁿ cantyja ꞌnaaⁿꞌ Cristo nda̱a̱ nnꞌaⁿ tsjoomꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Chaꞌtsondye nnꞌaⁿ jeeⁿ ya tqueⁿna cwenta ñꞌoom na tyotseineiiⁿ ndoꞌ ntyꞌiaana ꞌnaaⁿ tꞌmaⁿ na tyochꞌeeⁿ na xocanda̱a̱ nntsꞌaa na cweꞌ najndeii nquii tsꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Jndye nnꞌaⁿ na tyoleichuu jndyetia nꞌmaaⁿna sꞌaaⁿ. Quia na jluiꞌ jndyetiaꞌñeeⁿ quiiꞌ nꞌomna jndeii jlaꞌxuaanaꞌ. Ndoꞌ jndye nnꞌaⁿ na ntjeiⁿ ncꞌeeꞌ ndoꞌ ntjeiⁿ luee tcoꞌyanaꞌ joona sꞌaa Felipe. ");
INSERT INTO amuNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ncꞌe na ljoꞌ, jndye nnꞌaⁿ tsjoomꞌñeeⁿ tyomꞌaⁿna na jeeⁿ neiiⁿna. ");
INSERT INTO amuNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Jnda̱ jaachꞌee xuee mꞌaaⁿ cwii tsꞌaⁿ tsjoomꞌñeeⁿ na caluaꞌñe na jndyu Simón. Tyonquiuꞌnnꞌaaⁿ nnꞌaⁿ tsꞌo̱ndaa Samaria, na tyotsoom nda̱a̱na na jom jeeⁿ tꞌmaⁿ tseixmaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Chaꞌtsondye nnꞌaⁿ meiiⁿ nnꞌaⁿ na tꞌmaⁿ cwiluiindye meiiⁿ nnꞌaⁿ na cje laxmaⁿ jeeⁿ tyoqueⁿna cwenta ñꞌoom na tyotseineiiⁿ. Tyoluena: —Simónmꞌaaⁿꞌ, juu najndeii na matseixmaⁿ Tyꞌo̱o̱tsꞌom, tꞌmaⁿ matseixmaaⁿ joꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Nnꞌaⁿ tsjoomꞌñeeⁿ tyoqueⁿna cwenta ñꞌoom na tyotseineiiⁿ ee teiyo manquiuꞌnnꞌaaⁿ joona ñequio tsꞌiaaⁿ caluaꞌ na machꞌeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Sa̱a̱ quia na jnda̱ jlaꞌyuꞌna ñꞌoom na tyotseineiⁿ Felipe cantyja na matsa̱ꞌntjom Tyꞌo̱o̱tsꞌom ndoꞌ cantyja ꞌnaaⁿꞌ xueeꞌ Jesucristo, quia joꞌ naⁿnom ndoꞌ naⁿlcu teitsꞌoomndyena. ");
INSERT INTO amuNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ndoꞌ manquiiti Simón seiyoomꞌm ndoꞌ teitsꞌoomñê. Ndoꞌ ñequiiꞌcheⁿ na ñꞌeⁿñꞌeeⁿ ñꞌeⁿ Felipe. Jeeⁿ tyocjaaweeꞌ tsꞌoom ꞌnaaⁿ tꞌmaⁿ na tyochꞌee Felipe na xocanda̱a̱ nntsꞌaa na cweꞌ najndeii nquii tsꞌaⁿ meiⁿ xocjaantyjo̱o̱ꞌ tsꞌom tsꞌaⁿ chiuu tuiiyuu. ");
INSERT INTO amuNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Ndoꞌ Jerusalén mꞌaⁿ apóstoles, jnda̱ na jndyena na mati nnꞌaⁿ tsꞌo̱ndaa Samaria macwilaꞌyuꞌna ñꞌoomꞌ Tyꞌo̱o̱tsꞌom, joꞌ chii jñoomna we xꞌiaana, Pedro ñꞌeⁿ Juan, na cꞌoo naⁿꞌñeeⁿ na mꞌaⁿ nnꞌaⁿ ndyuaa Samaria. ");
INSERT INTO amuNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ndoꞌ jnda̱ na tquie naⁿꞌñeeⁿ joꞌ joꞌ, tyolaꞌneiⁿna nnom Tyꞌo̱o̱tsꞌom. Taⁿna nnoom na quiaaⁿ Espíritu Santo naquiiꞌ nꞌom naⁿꞌñeeⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ee meiⁿcwiindye naⁿꞌñeeⁿ tyootoꞌñoomna Espíritu Santo, macanda̱ na jnda̱ teitsꞌoomndyena ñequio xueeꞌ Ta Jesús. ");
INSERT INTO amuNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Quia joꞌ Pedro ñꞌeⁿ Juan tioona lueena nacjoo naⁿꞌñeeⁿ. Mana toꞌñoomna Espíritu Santo naquiiꞌ nꞌomna. ");
INSERT INTO amuNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Jnda̱ na ntyꞌiaaꞌ Simón na joo nnꞌaⁿ na jñom Tyꞌo̱o̱tsꞌom tioona lueena nacjoo naⁿꞌñeeⁿ, toꞌñoomna Espíritu Santo naquiiꞌ nꞌomna, quia joꞌ seiqueeⁿnaꞌ tsꞌoom na mati jom ñeꞌcatsꞌaaⁿ na ljoꞌ. Joꞌ chii tsoom nda̱a̱na na sꞌom nñequiaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Matsoom: —Quiaꞌyoꞌ na ntseixmaⁿya najndeii na cwilaxmaⁿꞌyoꞌ cha mati ja meiⁿcwiꞌñeeⁿcheⁿ tsꞌaⁿ na nntio̱o̱ lꞌo̱o̱ nacjooꞌ maxjeⁿ nncoꞌñom Espíritu Santo naquiiꞌ tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Sa̱a̱ matso Pedro nnoom: —Sꞌom ꞌnaⁿꞌ catsuunaꞌ ñꞌeⁿndyuꞌ, ꞌu matseiꞌtiuuꞌ na cweꞌ ñequio sꞌom nncoñomꞌ naya na mañequiaa Tyꞌo̱o̱tsꞌom na cwicandaa nnꞌaⁿ na cweꞌyu. ");
INSERT INTO amuNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ꞌU ticatsonaꞌ na nntseijomndyuꞌ tsꞌiaaⁿ ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom na cwilꞌaayâ ee tiyuuꞌ na xcweeꞌ tsꞌomꞌ jo nnoom. ");
INSERT INTO amuNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Calcweꞌ tsꞌomꞌ jnaⁿꞌ luaaꞌ, ndoꞌ catseityꞌoondyuꞌ nnom Tyꞌo̱o̱tsꞌom ntsꞌaacheⁿndyo ndyaꞌ nntseitꞌmaⁿ tsꞌoom ꞌu na luaaꞌ mꞌaaⁿꞌ tsꞌomꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ee mantyꞌiaya juu jnaⁿꞌ matseijomnaꞌ chaꞌcwijom ꞌnaⁿ ja na nncꞌuu tsꞌaⁿ ndoꞌ chaꞌcwijom lꞌuaancjo na chuꞌtyeⁿndyuꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Quia joꞌ tso Simón nda̱a̱na: —Cataⁿꞌyoꞌ nnom Tyꞌo̱o̱tsꞌom na meiⁿcwii ticatjo̱ⁿya chaꞌna cwinduꞌyoꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Pedro ñꞌeⁿ Juan jlaꞌneiⁿna ñꞌoomꞌ Tyꞌo̱o̱tsꞌom ndoꞌ tjeiꞌyuuꞌndyena cantyja ꞌnaaⁿꞌ Jesús. Jnda̱ chii jnaⁿna tsjoomꞌñeeⁿ ndyuaa Samaria na nncꞌoolcweeꞌna Jerusalén. Jndye njoom nchꞌu tyoꞌoowiꞌnomna ndyuaaꞌñeeⁿ. Tyoñequiana ñꞌoom naya nda̱a̱ nnꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ndoꞌ seineiⁿ ángel ꞌnaaⁿꞌ Tyꞌo̱o̱tsꞌom nnom Felipe. Tso: “Cjaꞌ nato Jerusalén na wjaanaꞌ tsjoom Gaza jo ntyja na macaluiꞌ caxjuu tsoomꞌnaaⁿ.” Juu natoꞌñeeⁿ mawinomnaꞌ ndyuaa yuu tjaa nnꞌaⁿ cꞌoom. ");
INSERT INTO amuNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Quia joꞌ teicantyjaaⁿ tjaaⁿ. Ndoꞌ natoꞌñeeⁿ teincwiñê ñꞌeⁿ tsꞌaⁿ na jnaⁿ ndyuaa Etiopía. Tsaⁿꞌñeeⁿ tsaⁿsꞌa eunuco na mandiꞌntjom nnom Candace tsaⁿscu na matsa̱ꞌntjom ndyuaa Etiopía. Tyomꞌaaⁿ tsꞌiaaⁿ na tyotseiweeⁿ sꞌom naquiiꞌ watsꞌiaaⁿ ꞌnaaⁿꞌ tsaⁿscuꞌñeeⁿ. Tjatseitꞌmaaⁿꞌñê Tyꞌo̱o̱tsꞌom Jerusalén. ");
INSERT INTO amuNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ndoꞌ jeꞌ majaalcweeⁿꞌeⁿ. Ñjoom tsꞌom tornom ꞌnaaⁿꞌaⁿ. Matseiꞌnaⁿꞌaⁿ tsom na chuuꞌ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na seiljeii Isaías. ");
INSERT INTO amuNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ndoꞌ tso Espíritu nnom Felipe: —Catseicandyooꞌndyuꞌ nacañoomꞌ tornomwaaꞌ. Catseijomndyuꞌ ñꞌeⁿ tsꞌaⁿ na maleiñꞌoom juunaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Quia joꞌ tjantyjaaꞌ Felipe tsaⁿꞌñeeⁿ. Jñeeⁿ na matseiꞌnaaⁿꞌ tsaⁿꞌñeeⁿ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na seiljeii Isaías. Taxꞌeeñê nnom, matsoom: —¿Aa matseiꞌno̱ⁿꞌ ñꞌoom na matseiꞌnaⁿꞌ? ");
INSERT INTO amuNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Matso tsaⁿꞌñeeⁿ nnoom: —¿Chiuu nntsꞌaayo̱ na nntseiꞌno̱ⁿꞌa ee tjaa ꞌñeeⁿ juu mꞌmo̱ⁿ no̱o̱ⁿ? Ndoꞌ tcaⁿ tsaⁿꞌñeeⁿ na cjawa Felipe tornom ꞌnaaⁿꞌaⁿ na nncwacatyeeⁿ na cañoomꞌm. ");
INSERT INTO amuNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Luaa matso ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na matseiꞌnaaⁿꞌ tsaⁿꞌñeeⁿ: Quia na wjaañꞌoom tsꞌaⁿ catsmaⁿ na nntseicueⁿꞌeⁿ juuyoꞌ meiⁿchjoo ticatseixuaayoꞌ. Mati chaꞌna catsmaⁿ chjoo quia na matyjee tsꞌaⁿ somꞌm ñemaaⁿꞌ ꞌñom, malaaꞌtiꞌ tjaa ljoꞌ tso tsꞌaⁿ na cwiluiiñe catsmaⁿ cwentaaꞌ Tyꞌo̱o̱tsꞌom meiiⁿ na wiꞌ tyotjoom. ");
INSERT INTO amuNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Jlaꞌjnaaⁿꞌ nnꞌaⁿ jom meiⁿ tîcatuꞌxeⁿyana ñꞌoom cantyja ꞌnaaⁿꞌaⁿ. Ndoꞌ ꞌñeeⁿ juu nnda̱a̱ nntseineiⁿ cantyja ꞌnaaⁿ nnꞌaaⁿꞌaⁿ na tjawicantyjooꞌ, maxjeⁿ tjaaꞌnaⁿ ee tyuaaꞌ jlaꞌcueeꞌna jom. ");
INSERT INTO amuNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Quia joꞌ taxꞌee tsꞌaⁿ Etiopía nnom Felipe, matsoom: —Cwii nayaꞌñeeⁿ, catsuꞌyaꞌ no̱o̱ⁿ, tsꞌaⁿ na tyoñequiaa ñꞌoommeiiⁿñe ¿aa matseineiiⁿ cantyja ꞌnaaⁿꞌ nqueⁿ oo aa cantyja ꞌnaaⁿꞌ cwiicheⁿ? ");
INSERT INTO amuNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Quia joꞌ Felipe to̱o̱ⁿꞌo̱ⁿ na tyotseineiiⁿ cantyja ꞌnaaⁿꞌ juu ñꞌoomꞌñeeⁿ na teiljeii naquiiꞌ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom na seiꞌnaaⁿꞌ tsaⁿꞌñeeⁿ. Tyotseineiiⁿ nnom tsaⁿꞌñeeⁿ ñꞌoom naya cantyja ꞌnaaⁿꞌ Jesús. ");
INSERT INTO amuNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ndoꞌ yocheⁿ na cwiꞌoona nato, tquiena cwii joo yuu waa ndaatioo. Quia joꞌ matso tsꞌaⁿ Etiopía nnoom: —Cantyꞌiaꞌ, ñjaaⁿ waa ndaatioo. ¿Aa waa na nntseicuꞌnaꞌ na nnleitsꞌoomndyo̱? ");
INSERT INTO amuNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Quia joꞌ matso Felipe nnoom: —Xeⁿ matseiꞌyuꞌ ñequio na xcweeꞌ tsꞌomꞌ nnda̱a̱ nleitsꞌoomndyuꞌ. Tꞌo̱ tsaⁿꞌñeeⁿ matsoom: —Matseiyuꞌa na Jesucristo cwiluiiñê Jnda Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Quia joꞌ tsꞌaⁿ Etiopía sa̱ꞌntjoom na cjaameintyjeeꞌ tornom. Jnda̱ chii wendyena tquiocuena, tyꞌecuo̱na quiiꞌ ndaatioo, mana seitsꞌoomñe Felipe jom. ");
INSERT INTO amuNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Jnda̱ na jluiꞌna quiiꞌ ndaatioo, nquii Espíritu na cwiluiiñe Tyꞌo̱o̱tsꞌom tjañꞌoom Felipe. Ndoꞌ tsꞌaⁿ Etiopíaꞌñeeⁿ taticantyꞌiaaꞌtyeeⁿ Felipe, sa̱a̱ tjaaⁿ nato na mawjaⁿ ñequio na neiiⁿꞌ tsꞌoom. ");
INSERT INTO amuNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ndoꞌ Felipe jeꞌ, teitquiooꞌñê tsjoom Azoto, ndoꞌ jndye njoom tyomanoom tyoñequiaaⁿ ñꞌoom naya hasta tueeꞌnnaaⁿꞌaⁿ tsjoom Cesarea. ");
INSERT INTO amuNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ndoꞌ Saulo ticandoꞌ nncjaameintyjeeⁿꞌeⁿ na matseicatyꞌueeⁿ nnꞌaⁿ na cwilaꞌyuꞌ ñequio Ta Jesús. Ndicwaⁿ macantyjaaꞌñê na nntseicwjeⁿ joona. Joꞌ chii tjaaⁿ na mꞌaaⁿ tyee na cwiluiitquieñe. ");
INSERT INTO amuNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Tcaaⁿ ljeii nnom juu na nncjaañꞌoom tsjoom Damasco na mꞌaⁿ nnꞌaⁿ judíos lanꞌom ꞌnaaⁿna. Ljeiiꞌñeeⁿ tquiaanaꞌ najneiⁿ na nncjaacwjaaⁿ naⁿnom ndoꞌ naⁿlcu nnꞌaⁿ na mꞌaⁿ natooꞌ Jesús, na nncjaachom joona pra̱so Jerusalén. ");
INSERT INTO amuNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Njoom nato na jnda̱ jaawinoomꞌm tsjoom Damasco ndoꞌ matsꞌia joꞌ tioo cwii chom ndiocheⁿ nacañomꞌm na jnaⁿnaꞌ cañoomꞌluee. ");
INSERT INTO amuNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ndoꞌ tiooñê nomtyuaa ndoꞌ jñeeⁿ na seineiⁿ tsꞌaⁿ. Matso nnoom: —Aa ndiꞌ, Saulo, ¿chiuu na jeeⁿ mantyjo̱ꞌ ja? ");
INSERT INTO amuNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ndoꞌ tꞌo̱o̱ⁿ: —¿ꞌÑeeⁿ ꞌu Ta? Matso nnoom: —Ja Jesús tsꞌaⁿ na mantyjo̱ꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Ndoꞌ Saulo cwiteiñê na macatyꞌueeⁿ. Matsoom: —¿Chiuu lꞌue tsꞌomꞌ Ta na catsꞌaa? Quia joꞌ matso Jesús nnoom: —Quicantyjaꞌ, cjaꞌquieꞌ quiiꞌ tsjoom. Joꞌ joꞌ nntso tsꞌaⁿ njomꞌ ljoꞌ macaⁿnaꞌ na nntsaꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ndoꞌ naⁿnom na cwiꞌoo ñꞌeⁿ Saulo, sꞌaanaꞌ na jeeⁿ tyuena ee jndyena na seineiⁿ tsꞌaⁿ sa̱a̱ titquiooꞌñe. ");
INSERT INTO amuNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Quia joꞌ teicantyja Saulo nomtyuaa. Seinꞌmeiiⁿꞌeⁿ luaꞌnnoom sa̱a̱ tileicantyꞌiaaⁿꞌaⁿ. Joꞌ chii tꞌuena tsꞌo̱o̱ⁿ tyꞌeñꞌomna jom tsjoom Damasco. ");
INSERT INTO amuNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Joꞌ joꞌ tyomꞌaaⁿ cwii ndyee xuee na tileicantyꞌiaaⁿꞌaⁿ, ndoꞌ tîcwaaⁿꞌaⁿ meiⁿ na nncꞌom ndaa tjaaꞌnaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Tsjoomꞌñeeⁿ tyomꞌaaⁿ cwii tsꞌaⁿ na matseiyuꞌ na jndyu Ananías. Tsaⁿꞌñeeⁿ tcoꞌnaꞌ ntyꞌiaaⁿꞌaⁿ Ta Jesús. Seineiⁿ matso: —Ananías. Tꞌo̱o̱ⁿ, matsoom: —Luaa ja Ta. ");
INSERT INTO amuNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Quia joꞌ matso Ta Jesús nnoom: —Quicantyjaꞌ cjaꞌ nataa na jndyunaꞌ na Ndyeyu tja. Waaꞌ Judas calꞌueꞌ tsꞌaⁿ na jndyu Saulo, tsꞌaⁿ na jnaⁿ tsjoom Tarso. Tsaⁿꞌñeeⁿ mamatseineiiⁿ no̱o̱ⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ndoꞌ jnda̱ tcoꞌnaꞌ ntyꞌiaaⁿꞌaⁿ na ꞌu Ananías jnda̱ jndyoꞌquieꞌ na mꞌaaⁿ ndoꞌ jndyoꞌcatiooꞌ lꞌo̱ꞌ nacjoomꞌm cha nnda̱a̱ nntyꞌiaaꞌnnaaⁿꞌaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Jnda̱ na jndii Ananías na luaaꞌ, tsoom: —Jndye ñꞌoom jnda̱ mandiiya, Ta, na cwilaꞌneiⁿ nnꞌaⁿ cantyja ꞌnaaⁿꞌ tsaⁿmꞌaaⁿꞌ cwanti nawiꞌ machꞌeeⁿ nnꞌaⁿ cwentaꞌ na mꞌaⁿ Jerusalén. ");
INSERT INTO amuNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ndoꞌ jeꞌ ñjaaⁿ jnda̱ tyjeeⁿꞌeⁿ ñequio ljeii na tquia ntyee na cwiluiitquiendye na mañequiaanaꞌ najneiⁿ cha na chaꞌtso nnꞌaⁿ na cwilcwiiꞌ xueꞌ nncjaachom joona na chuꞌtyeⁿndyena na nntioom joona wꞌaancjo. ");
INSERT INTO amuNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Sa̱a̱ matso Jesús nnoom: —Cjaꞌ ee jnda̱ tjeiiꞌndyo̱ jom na nntseineiiⁿ cantyja ꞌnaⁿya jo nda̱a̱ nnꞌaⁿ ntꞌomcheⁿ ndyuaa ñequio nnꞌaⁿ na cwitsa̱ꞌntjom joona, ndoꞌ mati nda̱a̱ nnꞌaⁿ Israel. ");
INSERT INTO amuNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ndoꞌ nntsꞌaa na nncjaaljeiiⁿ na maxjeⁿ jndye nawiꞌ macaⁿnaꞌ na nncwinoom cantyja na matseiyoomꞌm ñꞌeⁿndyo̱. ");
INSERT INTO amuNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Quia joꞌ tja Ananías wꞌaa na mꞌaaⁿ Sauloꞌñeeⁿ. Jnda̱ na tjaqueⁿꞌeⁿ, tioom lꞌo̱o̱ⁿ nacjooꞌ tsaⁿꞌñeeⁿ. Matsoom: —ꞌU re nnꞌaⁿya Saulo, nquii Ta Jesús na teitquiooꞌñê njomꞌ nato na jndyoꞌ, jñoom ja na mꞌaaⁿꞌ. Lꞌue tsꞌoom na nntyꞌiaꞌnndaꞌ ndoꞌ na tooꞌ nntseixmaⁿꞌ Espíritu Santo naquiiꞌ tsꞌomꞌ. ");
INSERT INTO amuNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Mañoomꞌ tquiaa chaꞌcwijom luaꞌtsja nꞌom nnom Saulo. Jnda̱a̱ na ntyꞌiaaꞌnnaaⁿꞌaⁿ. Quia joꞌ teicantyjaaⁿ, teitsꞌoomñê. ");
INSERT INTO amuNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Jnda̱ chii tcwaaⁿꞌaⁿ ndoꞌ tquiaanndaꞌnaꞌ najneiⁿ. Ljooꞌñê cwantindyo xuee ñequio nnꞌaⁿ na cwilayuꞌ tsjoom Damasco. ");
INSERT INTO amuNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Mantyja to̱o̱ⁿꞌo̱ⁿ na tyoñequiaaⁿ ñꞌoom quiiꞌ lanꞌom ꞌnaaⁿ nnꞌaⁿ judíos na nquii Jesús cwiluiiñê Jnda Tyꞌo̱o̱tsꞌom. ");
INSERT INTO amuNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ndoꞌ chaꞌtso nnꞌaⁿ na tyondye ñꞌoom na tyoñequiaaⁿ seitsaⁿꞌnaꞌ joona. Tyoluena: —¿Aa nchii tsaⁿmꞌaaⁿꞌ tsꞌaⁿ na tyomaꞌnom Jerusalén na tyocoꞌweeⁿꞌeⁿ nnꞌaⁿ na cwilcwiiꞌ xueeꞌ Jesús? Ndoꞌ ¿aa nchii mati jnda̱ jñoom ñjaaⁿ na nncjaachom nnꞌaⁿ na cwilayuꞌ na chuꞌtyeⁿndye jo nda̱a̱ ntyee na cwiluiitquiendye? ");
INSERT INTO amuNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ndoꞌ Saulo tjanaⁿjndeiityeeⁿ na tyoñequiaaⁿ ñꞌoomꞌ Tyꞌo̱o̱tsꞌom. Tyoꞌmo̱o̱ⁿ na mayuuꞌ na Jesús cwiluiiñê Cristo. Joꞌ na tjatseiñꞌeeⁿꞌñenaꞌ nnꞌaⁿ judíos na mꞌaⁿ Damasco. ");
INSERT INTO amuNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Jnda̱ jaachꞌee xuee na maꞌmo̱ⁿ Saulo ndoꞌ jnda̱ chii tjoomꞌ ñꞌoom tꞌmaⁿ nnꞌaⁿ judíos na nlacueeꞌna jom. ");
INSERT INTO amuNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Sa̱a̱ jñeeⁿ na ljoꞌ. Ndoꞌ naⁿꞌñeeⁿ naxuee ndoꞌ natsjom tyondo̱o̱na jom ndyueelꞌa tatiom nnom tsjoomna na nlacueeꞌna jom. ");
INSERT INTO amuNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Sa̱a̱ nnꞌaⁿ na cwilayuꞌ teijndeiina jom natsjom. Tuo̱o̱ⁿ tsꞌom cwii tsquiee lꞌo̱o̱. Jlacꞌo̱ⁿna jom mantana na waa na ndye ꞌndyoo tatiom nnom tsjoom. Chii tjacueeⁿ cwiicheⁿ na ntyja, mana tjaaⁿ. ");
INSERT INTO amuNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Quia na jnda̱ tueⁿꞌeⁿ Jerusalén ñeꞌcatseijomñê ñꞌeⁿ nnꞌaⁿ na cwilayuꞌ, sa̱a̱ chaꞌtsondye naⁿꞌñeeⁿ nquiaana jom ee tiñeꞌcalayuꞌna na tsꞌaⁿ na matseiyuꞌ jom. ");
INSERT INTO amuNT_vpl VALUES ("AC9_27","074_9_27","A