﻿USE sofia;
DROP TABLE IF EXISTS sofia.amrNT_vpl;
CREATE TABLE amrNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES amrNT_vpl WRITE;
INSERT INTO amrNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesucristo Davidkudaken adhueaʼsiʼpo kenpaʼti Abrahamkudaken adhueaʼsiʼpo o̱ʼu̱yate. In berobaʼte do Mateoa onʼnigmadoyaʼne. Jesucristoen adhueaʼpaneʼdik onʼnigmadoyaʼdene. ");
INSERT INTO amrNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Aʼnennanada Abraham Isaacen huaoj o̱ʼu̱yate. Isaac Jacoben huaoj o̱ʼu̱yate. Jacob Judáen huamaʼbuyereen huaoj o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá Faresen Zaraereen huaoj o̱ʼu̱yate. Tamar kenomeyen huaoj o̱ʼu̱yate. Fares Esromen huaoj o̱ʼu̱yate. Esrom Aramen huaoj o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram Aminadaben huaoj o̱ʼu̱yate. Aminadab Naasónen huaoj o̱ʼu̱yate. Naasón Salmónen huaoj o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón Boozen huaoj o̱ʼu̱yate. Rahab Boozen hua̱ye̱ o̱ʼu̱yate. Booz Obeden huaoj o̱ʼu̱yate. Rut Obeden hua̱ye̱ o̱ʼu̱yate. Obed Isaíen huaoj o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí Huairi Daviden huaoj o̱ʼu̱yate. David Salomónen huaoj o̱ʼu̱yate. Uríasen ayhua Salomónen inag o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón Roboamen huaoj o̱ʼu̱yate. Roboam Abíasen huaoj o̱ʼu̱yate. Abías Asaen huaoj o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa Josafaten huaoj o̱ʼu̱yate. Josafat Joramen huaoj o̱ʼu̱yate. Joram Uzíasen huaoj o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías Jotamen huaoj o̱ʼu̱yate. Jotam Acazen huaoj o̱ʼu̱yate. Acaz Ezequíasen huaoj o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías Manasésen huaoj o̱ʼu̱yate. Manasés Amónen huaoj o̱ʼu̱yate. Amón Josíasen huaoj o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías Jeconíasen huamaʼbuyereen huaoj o̱ʼe̱po kenokaʼ Israel aratbuttaj Babilonia huadaribayo onʼbatohuaʼdeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Nogok Jeconías Salatielen huaoj o̱ʼu̱yate. Salatiel Zorobabelen huaoj o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel Abiuden huaoj o̱ʼu̱yate. Abiud Eliaquimen huaoj o̱ʼu̱yate. Eliaquim Azoren huaoj o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor Sadocen huaoj o̱ʼu̱yate. Sadoc Aquimen huaoj o̱ʼu̱yate. Aquim Eliuden huaoj o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud Eleazaren huaoj o̱ʼu̱yate. Eleazar Matánen huaoj o̱ʼu̱yate. Matán Jacoben huaoj o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob Joséen huaoj o̱ʼu̱yate. José Maríaen hua̱to̱e̱ o̱ʼu̱yate. María Jesúsen hua̱ye̱ o̱ʼu̱yate. Jesústaj konogdikda oʼdikkaʼuy Cristo, Diosa oʼtaʼmonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ken Abraham Davidte catorce Daviden adhueaʼpaneʼ o̱ʼnuyate. Kenpaʼti David Babilonia huadariyo enʼbatohuadeʼte Jeconíaste catorce adhueaʼpaneʼ o̱ʼnuyate. Kenpaʼti Jesús eʼsiʼpoe̱deʼte nog catorce adhueaʼpaneʼ o̱ʼnuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","In konig Jesucristo oʼsiʼpoe̱ʼuyate. María Jesúsen hua̱ye̱ Joséere oʼto̱e̱pakapo. To̱e̱pakhueda̱da huaboaʼda bogdakhueʼda o̱ʼe̱ onʼtinopo̱e̱ʼuy. Diosen Noki̱re̱ga̱ oʼdapokaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","José Maríaen hua̱to̱e̱ huadak huakaʼeri e̱ʼe̱a̱da María bogdakhueʼ o̱ʼe̱nok eʼhuaaʼtaʼ pakhueʼada soatayoʼ hua̱to̱e̱ e̱ʼentaʼ oʼpakuynigʼa. ");
INSERT INTO amrNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Kenpaʼ José eʼnopo̱e̱deʼte oʼyorokpo Dios Huairien huataʼmoneritaj oʼtiahuayʼuy. —‍On José i̱ʼe̱. Daviden adhueaʼsiʼpo i̱ʼe̱. María eʼto̱e̱paktaj meʼpukehueʼ ya̱e̱ʼ. Huasiʼpo oʼto̱e̱a̱ponig Dios Noki̱re̱gen o̱ʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Bokereksiʼpoaʼ oʼsiʼpopakapo. Kentaj iʼdikkaʼapo Jesús. (Jesúsdik Judíoen huaʼate dakhueaʼ eʼkaʼ huamanopoʼyareaʼeri o̱ʼe̱a̱po) konige̱po keʼnen aratbut Israel aratbuttaj dakhueaʼ eʼkikaʼ oʼmanopoʼyareaʼapo. —‍Diosen huataʼmoneria kenda onaʼuyate. Josétaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Dios Huairien huamanbatiaʼpakeria oʼmanbatiaʼpakuynig in ayaʼda o̱ʼu̱y. ");
INSERT INTO amrNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Muneʼyo̱ katenohued e̱ʼe̱a̱da bogdakhueʼ o̱ʼe̱po. Huabokereksiʼpo oʼsiʼpopakapo. Kentaj onʼdikkaʼapo Emanuel. Dios Huairia oʼmanaʼuyate. Emanuel huadik konig Dios oroʼere o̱ʼi̱kaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","José oʼmabodepo Dios Huairien huataʼmoneritaj oʼnigpe̱e̱po hua̱to̱e̱ eʼto̱e̱a̱da ");
INSERT INTO amrNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","eʼsiʼpopakdeʼte batohuedhueʼ o̱ʼu̱yate. Eʼsiʼpopakdeʼte Jesús oʼdikkaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Belén huakkaʼ jakyo Judea huadaribayo Jesús oʼsiʼpoe̱ʼuyate. Kenokaʼ Herodes Roma hua̱e̱ʼeri Judea gobierno huairi o̱ʼu̱y. Kenokaʼ Jerusalén huakkaʼ jakyo sueʼda huabokerek onʼtiakdepo, kenomey diga̱ʼda huanopo̱e̱ʼeria nogbayaʼ niokpo eʼbehuikyon onʼtiakdepo, ");
INSERT INTO amrNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","—‍Judío aratbuten huairi oʼsiʼpopakdemeʼ. ¿Meyon ya̱ʼe̱? Ke̱yon niokpo omeʼ judío Huairi eʼsiʼpopakdeʼ huanopo̱e̱ʼ siokpo oʼtiahuaymeʼpo, judío Huairitaj dakiti Dios aaʼyaʼpo oʼtiakdey. —‍Onʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kenokaʼ Herodes Huairi kenda oʼmatipe̱e̱depo oʼmeʼpukeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ayaʼ sacerdote huairitaj kenpaʼti ayaʼda Apagbaʼ huamanmadikaʼeritaj oʼmakupopakaʼuyate Herodesa. O̱gkupopakdepo, “¿Cristo Diosyaʼ oʼtiakdepo meya̱ʼ yaʼsiʼpoe̱apo?” oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","—‍Judeabayo Belén huakkaʼ jakyo oʼsiʼpoe̱apo. Diosen huamanbatiaʼpakeria kenpaʼ oʼnigmadoyaʼuyate: ");
INSERT INTO amrNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Judea huadaribayoda Belén huakkaʼ jak suhuigda e̱e̱ʼpiʼ huakhuairi Cristo oʼsiʼpoe̱ʼapo. Belén jakyaʼ huamataʼmonanhuaʼ Huairi Cristo o̱ʼo̱ro̱kapo. Keʼna Israel aratbuttaj oʼbatiokikaʼapo. —‍Judío huairia oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kenokaʼ diga̱ʼda huanopo̱e̱ʼerite oʼmataʼmonaʼ Herodesa. “I̱re̱gi̱re̱g yanʼbatotiak.” Herodesa oʼmanaʼuyate. “¿Judío huairien siokpo menok huaboaʼda ya̱ʼo̱ro̱kuy boʼtiahuayne?” Herodesa diga̱ʼda huanopo̱e̱ʼeritaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Oʼnopo̱e̱depo diga̱ʼda huanopo̱e̱ʼerite Belényo oʼmataʼmonaʼpo, —‍A̱yon yanʼhuatiʼ. Huasiʼpotaj dakaʼ yaduk. Kenokaʼ yanʼhuahuaydepo doʼtaj yanʼtiaktiʼ. Enadeʼte do kenpaʼti huahuaʼdik i̱jje̱po kentaj huikudate ijtihuadpo, “ʼUruaʼda huairi i̱ʼe̱ne.” Yonaʼapoy. —‍Herodesa namaʼda oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Ken Herodestaj onʼpe̱e̱depo diga̱ʼda huanopo̱e̱ʼeria oʼnokhuaʼuyate. Ken siokpo niokpo yaʼbehuikyon onʼtiahuayde ken siokpo huakkuruyon oʼhuaʼuy. Oʼhuaʼpo kutayaʼ kente huasiʼpo e̱ʼhua̱e̱ʼte oʼbatik. ");
INSERT INTO amrNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Diga̱ʼda huanopo̱e̱ʼeria siokpo onʼtiahuaypo huakkaʼda onʼdurugpakuy. Judío aratbuten huairisiʼpo kente o̱ʼe̱ onʼnopo̱e̱po. ");
INSERT INTO amrNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Jakyo onʼkuddepo huasiʼpotaj onʼtiahuayʼuy. Huasiʼpo hua̱ye̱ Maríaere onʼtiahuayʼuyate. Konig gobierno huairitaj huikudate onʼhuadikuy huasiʼpo Jesústaj huikudate onʼtihuadpo ʼuruaʼda judío aratbuten gobierno huairi o̱ʼe̱ onʼbatiaʼpakpo. Kenokaʼ cajaʼ oʼnokhuikedepo katetehueʼ huasiʼpotaj oro onʼyokuyate. ʼUruaʼda o̱hue̱y huasihuaj dakaʼda eʼbakpakte ʼuruʼhui̱e̱a̱da oʼhui̱ri̱kikaʼ. Huakkaʼteda e̱e̱ʼtada Jesústaj onʼyokuyate. Nogda konig ʼuruʼhui̱e̱a̱da eʼhui̱ri̱kikaʼ kenpaʼti huakkaʼteda e̱e̱ʼtada onʼyokuyate. Katetehueʼ huasiʼpo huairitaj onʼyokuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nogok onʼyorokdepo “Herodeste onteʼti huahueʼ yaneʼ,” kenda onʼpe̱e̱depo kenomeyenbayo nog dagtekon onʼhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Diga̱ʼda huanopo̱e̱ʼeri enʼhuadeʼte José oʼtaypo oʼyorokpo Diosen huataʼmoneritaj oʼtiahuayʼuy. —‍Herodes Jesússiʼpotaj aʼarakyaʼpo oʼukaponok, yamaboʼ, huasiʼpo hua̱ye̱ere yabatohuaʼpo Egipto aratbutenbayo yamatomonʼ. Ke̱yo̱ yanikatiʼ. Kenok yakumejtiʼ onaʼapone. —‍José eʼyorokyaʼ Diosen huataʼmoneria onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ken José oʼpe̱e̱depo oʼmaboduyate. Sikyo huasiʼpo hua̱ye̱erea oʼtohuaʼbedpo Egiptobayo oʼtohuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Egiptoyo o̱ʼi̱kaʼuyate. Herodes Huairi eʼbueydeʼte o̱ʼi̱kaʼuyate. Konig Oseas Diosen huamanbatiaʼpakeria aʼnenda oaʼuy konigti o̱gkaʼuyate. “Egiptobayaʼ ya̱o̱ro̱k. Doʼhued Huasiʼpotaj yonaʼapoy.” Dios Huairia oaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Diga̱ʼda huanopo̱e̱ʼeria judío huairisiʼpotaj aʼbatiaʼpakyaʼpo tiakhueʼ ya̱ʼneapet. Namaʼda meʼnonaʼuyne. Herodes kenda oʼnokotdepo diga̱ʼda oʼdiaypo, “Ayaʼda huabokereksiʼpo yo̱bed nogbayoktidaere bottaʼ huabayokere enʼta̱e̱tada yanʼbatiarakaʼ. Belén huakkaʼ jakyo kenpaʼti Belén meyo̱hueʼda huasiʼpotaj yanʼbatiarakaʼ.” Oʼmanaʼuyate. Diga̱ʼda huanopo̱e̱ʼeria aʼnenda bottaʼ huabayok Jesúsen siokpo huaboaʼda onʼtiahuayʼuyate. Kenokaʼ Herodestaj onʼbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Konig Jeremías Diosen huamanbatiaʼpakeria oaʼuyate. Kenda Herodesa oʼkaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ramá huakkaʼ jak hua̱e̱ʼeria diga̱ʼda onʼbahuikonhuahuaʼ. Bidteda onʼmapeeonhuahuaʼ. Huasiʼpo onʼmabueynok Raquel huasiʼpotaj onʼbahuikonhuahuaʼapo. Jeremíasa kenda oaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herodes eʼbueydeʼte José eʼyorokyaʼ Diosen huataʼmoneritaj oʼtiahuayʼuy. Egiptobayo o̱ʼe̱po oʼtiahuayʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—‍Keʼna huasiʼpotaj eʼaraktaʼ oʼpakuy oʼbueyde, yaboʼ, Israel aratbutenbayo yakumejtiʼ. Huasiʼpo hua̱ye̱eretaj yabatohuaʼ. —‍Diosen huataʼmoneria Josétaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","José oʼpe̱e̱depo oʼbodpo huasiʼpo hua̱ye̱ere Israel aratbutenbayo oʼbatohuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Herodesensiʼpo Arquelao Judeabayo gobierno huairi o̱ʼe̱. José oʼpe̱e̱depo Judeayo eʼhuaʼtaʼ oʼmeʼpukpo oʼbayorokpo, “Judeayo huahueʼ ya̱e̱ʼ,” oʼpe̱e̱depo Galileabayo oʼhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nazaret huakkaʼ jakyo oʼhuaʼuyate. O̱ʼi̱kaʼuyate. Jesús Nazaret hua̱e̱ʼeri o̱ʼe̱ onʼdikkaʼapo Apagbaʼ huamanbatiaʼpakeria oaʼuyate. Konig Apagbaʼ oaʼuyate aratbut Jesústaj onʼdikkaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nogok Jesús Nazaretyo oʼkerekdepo Juan bautiza huakaʼeria huaboaʼda oʼmanaʼonhuahuaʼuyate. Sueʼda aratbut eʼnahue̱ʼyo̱ Jordánhue̱yon oʼmanaʼonhuahuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","—‍Dakhueaʼ eʼkikaʼ yanʼbatikpo onteʼti Diostaj yanʼnigpe̱i̱kaʼ. Diosen Huairi oʼtiakdeapo Diosensiʼpo moʼe̱a̱pone. —‍Juana aratbut e̱gkupopakyaʼ oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Isaías Diosen huamanbatiaʼpakeria aʼnenda Juantaj oʼtimadoyaʼuyate, Sueʼda aratbut eʼnahue̱ʼyo̱ kentaj moʼpe̱e̱a̱po. ʼUttaʼ enaʼpakte moʼpe̱e̱a̱po. “Huairi eʼtiakdeʼte dakaʼda aeʼyaʼpo ʼurunopoʼda ya̱gʼkikaʼ. Dakhueaʼ eʼkikaʼ yanʼbatikpo onteʼti Diostaj yanʼnigpe̱e̱ʼ. Huairitaj yadeʼ.” ʼUttaʼda oʼmanaʼapo. Kenda Isaíasa oʼtimadoyaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yudtaj camello huahuijtaj eʼkaʼ Juan Bautista oʼotikaʼpo kenpaʼti huasiʼdak makaʼbij o̱ʼta̱e̱ʼuyate. Tiktik oʼbapikaʼuyate. Asi̱gku oʼminikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Juantaj eʼpe̱e̱taʼ onʼpakpo huakkaʼda aratbut Juantaj onʼhuatiakuyate. Huakkaʼ Jerusalén huakkaʼ jakyo hua̱e̱ʼeri kenpaʼti huakkaʼ Judea huadari hua̱e̱ʼeri kenpaʼti Jordánhue̱ idbodte hua̱e̱ʼeria Juantaj onʼhuatiakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","“Dakhueaʼda ijkikaʼmey, bekkahueaʼ Dios.” Enadeʼte Juana bautiza oʼmagkaʼuyate. Jordánhue̱ya̱ʼ bautiza oʼmagkaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Huakkaʼada huamanmadikaʼeri huairi onʼbahuaʼpo fariseo huairi saduceo huairiere onʼbahuaʼuyate. Juantaj bautiza megkeʼpo onʼhuahuaʼuyate. Juana oʼbatiahuaydepo: —‍Konig dakhueʼda bihui oʼmagkikaʼ. Konigti opudomey dakhueaʼda boʼkikaʼpo kenpaʼti opudomey namaʼda moʼnopo̱i̱kaʼpo. Nopoʼkoreahueʼtada bautiza e̱gkadeʼte Diosa dakhueaʼda castiga e̱gkaʼte yoktitikonapoy. Kenda namaʼda moʼnopo̱e̱ne. ");
INSERT INTO amrNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ʼUruaʼda ya̱gʼkikatiʼ. Daknopoʼda ya̱gʼkikaʼpo Diostaj moʼnopoʼkoreaʼuynok ayaʼada tiahuaydik moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","“Abraham oroʼomeyen adhueaʼpaneʼ o̱ʼe̱nok Diostaj meʼpukhueʼdik o̱ʼe̱y.” Nopo̱e̱hueʼ yanikaʼ. Diosa eʼpaknayo in huid oʼbahuednigtaj Abrahamen huayayoaʼ magkaʼdik o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nopoʼkoreahueʼ e̱e̱ʼnayo i̱da Diosa castiga mogkaʼapone. In konig o̱ʼe̱. Konig taʼbayo huada huato̱e̱ʼeri o̱ʼe̱po. Huada ʼuruaʼda onhuadhueʼ o̱ʼeonhuahuikaʼnok dakaʼda oʼtiahuayonhuahuaʼdepo yamiʼa oʼtaʼtegpo taʼakyo oʼmahui̱gikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Dakhueaʼ eʼkikaʼ moʼnopoʼkoreaʼde huamanopo̱e̱a̱ʼ hue̱ʼe̱ya̱ doʼhua bautiza e̱gkaʼtada noga̱nayo Cristoanayo oʼtiakdepo Diosen Noki̱re̱ga̱ taʼakerea bautiza oʼmagkaʼapo. Kennayo huakhuairinanada teynanada e̱ʼe̱a̱da doʼhuataj ehueʼnanada i̱jje̱y. ");
INSERT INTO amrNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Cristo oʼtiakdepo konig aroz huatuga̱ʼeri o̱ʼe̱po aroz oʼtugdepo oktipoaʼ. Ken oktipoaʼdepo jakyo oʼkudapo. Oʼkuda̱ʼdepo huakusiʼhue taʼakyo oʼhui̱gonhuahuikaʼpo okbithueʼ o̱ʼe̱a̱po. Ken huadak huakid konig Cristotaj huaknopo̱e̱ʼeri o̱ʼne. Onʼnigpe̱i̱kaʼ. Huaknopo̱e̱ʼeritaj oʼbakuda̱ʼapo, Diosen jakyo oʼbakuda̱ʼapo. Huakusiʼhue konig aratbut Diostaj nigpe̱e̱hueʼ o̱ʼnikaʼ. Konig castiga eʼmagkaʼ taʼakyo oʼmajenapo. —‍Juana ayaʼtada oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Kenokaʼ Galilea huadaribayaʼ Jordánhue̱yo̱ Juante oʼhuahuaʼuyate Jesúsa. Bautiza megkeʼpo oʼhuahuaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Juan Jesústaj bautiza e̱gkaʼtaʼ pakhueʼ o̱ʼe̱po, —‍Doʼtaj bautiza o̱gkaʼdik o̱ʼe̱ne o̱ʼna. ¿Menaʼpo bautiza megkeʼpo doʼtaj iʼtiak? —‍Juana Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","—‍Ayaʼda Diosa oʼpaknig eʼkaʼtaʼ ijpaknok bautiza megkaʼ. —‍Jesúsa onaʼuyate. —‍Huadak bautiza o̱gkaiʼ. —‍Juana onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Juan bautiza o̱gkaʼdenok Jesús hua̱hue̱ya̱ʼ eʼbehuikdeʼte i̱da kurud konig akbogpe okhuikepo Diosen Noki̱re̱ga̱ dakaʼdamon konig tukkuʼ oʼhuahuarakpo Jesústaj oʼtikot. Jesúsa eʼtiahuayte oʼtikotpo. ");
INSERT INTO amrNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","—‍On doʼhued Huasiʼpo o̱ʼta̱e̱ne. Huadiʼda o̱ʼta̱e̱ne. Ontaj durugda oʼto̱e̱ne. —‍Kurudya̱ʼ Diosa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nogok sueʼda aratbut eʼnahue̱ʼyo̱ Diosen Noki̱re̱ga̱ Jesústaj oʼtohuaʼuyate. Totoʼa Jesústaj aʼdikdikyaʼpo ke̱yo̱ Jesústaj oʼtohuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Jesús cuarenta huameʼnoe cuarenta sikyo bapehueʼ o̱ʼunhuahuikaʼdepo aypotaʼ o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Jesús namaʼda kakeʼpo totoʼa Jesústaj oʼhuahuaʼdepo, —‍On buttida Diosensiʼpo e̱e̱ʼnayo in huidtaj aypo ya̱e̱ʼ yanaʼ. —‍Totoʼa Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","—‍Aypoayoʼda noikahueʼdik o̱ʼne aratbut. Aypo onʼbapepo ayaʼda Apagbaʼ huadikkon nigpe̱i̱kaʼdik o̱ʼne. Apagbaʼ kenpaʼ oaʼ. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Kenokaʼ totoʼ Jesústaj oʼtohuaʼpo Jerusalényo̱ Diosen huakkaʼ jakyo oʼtohuaʼpo Diosen huaboroʼ jak kutayoda jakkutagpiyo oʼtobehuikuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","—‍On buttida Diosen Huasiʼpo e̱e̱ʼnayo barakte yakudaj Apagbaʼ oaʼpo: Kanokbaʼhuadeʼpo eʼkotte Diosa keʼnen huataʼmoneritaj oʼmataʼmonaʼaponok huidbate kothueʼdik i̱ʼe̱a̱pone. Huabaʼa kutate monokbaʼhuada̱pone. Apagbaʼ kenpaʼ oʼmadoyaʼuyate. —‍Totoʼa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","—‍Kenpaʼti “Dios Huairitaj namaʼda kakeʼpo dikdikhueʼ ya̱e̱ʼ.” Apagbaʼte kenpaʼ oʼmadoyaʼuyate. —‍Jesúsa totoʼtaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Onteʼti totoʼa Jesústaj oʼtohuaʼ. Kutayoda oteʼyo oʼtobehuikuyate. Nogyo̱ nogyo̱da ayaʼ ʼuruaʼda huadaribayo kenpaʼti ayaʼda huadaribayo gobierno huairi Jesústaj oʼtiahuayʼeaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","—‍Doʼtaj huikudate beʼtihuadpo “ʼUruaʼda huairi meʼta̱e̱ne,” doʼtaj eaʼnayo ayaʼda iʼtiahuaynig ayaʼda ʼuruaʼda huadaribayo kenpaʼti huadaribayo huairi huaunhuaʼ oʼbayokapone. —‍Totoʼa namaʼda Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","—‍Kejeʼ, yahuatiʼ, totoʼ. “Dios Huairitayoʼda huikudate yanʼtihuadpo kentayoʼda yanʼnigpe̱i̱kaʼ.” Apagbaʼa oaʼ. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ken totoʼa okhuaʼdepo Diosen huataʼmoneria Jesústaj onʼhuatiakdepo aypo onʼyokuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Juan Bautista huabakuda̱ʼ jakyo o̱ʼe̱, Jesúsa oʼtipe̱e̱depo Galilea huadaribayo oʼhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nazaret huakkaʼ jakyo eʼhuaʼada ijhuiti ehueʼ Capernaum huakkaʼ jakyo oʼhuaʼpo Capernaumyo o̱ʼi̱kaʼuyate. Capernaum huaboroʼ e̱ʼpo̱gte o̱ʼe̱. Zabulón huadaribayo kenpaʼti Neftalí huadaribayo huakkaʼ jak Capernaum kenteda o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Capernaumyo o̱ʼi̱kaʼpo konig Isaíaskudaka aʼnenda oʼtimadoyaʼuyatenig, Jesúsa oʼkaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zabulón huadarieri kenpaʼti Neftalí huadari onteteyoʼ e̱ʼpo̱gtoneʼ hua̱e̱ʼeri Jordánhue̱ akodpeneri Galilea hua̱e̱ʼeri Galilea kenteda nog aratbutda judío hua̱e̱ʼeri ehueʼ o̱ʼnika. ");
INSERT INTO amrNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Inomey aratbut Diostaj oknopo̱e̱hueʼ o̱ʼnepo konig sikki̱re̱gyo̱ o̱ʼnikaʼpo huaboaʼnayo Diostaj oʼnoknopo̱e̱depo konig huaboroʼda huakjey huaboaʼda onʼtiahuayde. Kenomeya̱ dakhueaʼda o̱gkikaʼpo kenpaʼda bueydik ya̱ʼneapetnigʼa huaboaʼnayo huakjeytaj onʼtiahuayde. Isaíaskudaka oʼmadoyaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kenokaʼ Jesúsa huaboaʼda oʼmanaʼpo: —‍Diosen Huairi oʼtiakdenok dakhueaʼ bokikaʼnig yanʼnopoʼkoreaʼ Diostaj yanʼnopoʼkoreaʼ. Dios Huairitaj yanoknopo̱e̱ʼ. —‍Jesúsa huakkaʼ aratbuttaj oʼmanaʼikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Nogok Galilea e̱ʼpo̱g aktaʼbogpete Jesúsa oʼhuaʼepo bottaʼ huamaʼbuy oʼtiahuayʼuy. Simóntaj oʼtiahuay. Simón nogdikda oʼdikkaʼ Pedro. Andréstakon oʼtiahuayʼuy. Huakjeneʼeri o̱ʼneʼuy. E̱ʼpo̱gyo̱ oʼnokjenʼe̱po: ");
INSERT INTO amrNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","—‍Doere monhuaʼ. Aratbut Diosensiʼpo kaʼnikeʼpo kanʼmanopoʼkoreʼpo moʼmanmadikikaʼapone. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Onʼpe̱e̱depo huakjeneʼ kenpaʼda onʼmaenonpo Jesúsere onʼhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Adyonda nog bottaʼ huamaʼbuytaj Jesúsa oʼtiahuayʼuy. Jacobo Juanere oʼtiahuayʼuy. Zebedeoen huasiʼpo o̱ʼnuy. Kusiʼpetoneʼyo o̱ʼnepo huaojere huakjeneʼtaj onʼtoʼkaʼpo, “Doere monhuaʼpo doʼtaj meʼnigpe̱i̱kaʼ.” Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Onʼpe̱e̱depo kusiʼpe huaojtere kenpaʼda oʼnenonpo Jesústaj aʼnigpe̱i̱kayaʼpo onʼtahuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ken Galilea huadaribayo nog huakkaʼ jakyo nog huakkaʼ jakyo Jesúsa oʼhuaʼepo judío aratbuten hua̱i̱takeʼ jakyo nogya̱ʼ nogya̱ʼ oʼmanmadikaʼonhuahuaʼpo Diosen Huairi oʼtiakdepo yanʼnopoʼkoreaʼpo yanʼnigpe̱i̱kaʼ Diosensiʼpo moʼe̱a̱pone. Oʼmanmadikaʼonhuahuaʼpo kenpaʼti aratbut nogpaʼ nogpaʼ dakhueʼda enʼto̱e̱te oʼbayareadhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Jesúsa aratbuttaj oʼbayareaʼ bidteda Siria huadaribayo onʼtipe̱e̱depo ayaʼda dakhueʼda aratbut Jesúste onʼbatohuaʼpo nogda nogda dakhueʼ enʼto̱e̱te onʼbatohuaʼuyate. Nog eʼareʼ, nog eʼso̱ʼteyyeʼ, nog ayhueʼ, nog totoʼ eʼnopoʼto̱e̱ʼtaj onʼbatohuaʼuy. Jesúsa oʼbayareadhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Galilea huadaribayaʼ aratbut, Decápolis huakkaʼ jakyaʼ aratbut, Jerusalén huakkaʼ jakyaʼ aratbut, Judea huadaribayaʼ aratbut, kenpaʼti Jordánhue̱ akodpen hua̱e̱ʼeri huakkaʼada Jesúsere onʼhuahuudhuahuikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Huakkaʼ aratbut e̱gkupopakte Jesús oʼbatiahuaypo oteʼyo oʼbehuikpo oʼhuaduy. Keʼnen huamanigpe̱i̱kaʼeri kentaj meyo̱hueʼda o̱gkupopakuy. ");
INSERT INTO amrNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Huaboaʼda oʼmanmadikaʼapo: ");
INSERT INTO amrNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—‍Opudomey huataʼda Diosen kikahueʼdik i̱hue̱y, moʼnopo̱e̱po, “Beʼtihuapok Dios,” boʼtionaʼpakikaʼpo, durugda moʼe̱. Dios opuden Huairi o̱ʼe̱. Diosensiʼpo moʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Opudomey dakhueaʼ eʼkaʼdeʼ namaʼda ijkamey moʼnopo̱i̱kaʼdenok paiʼda moʼe̱nok, Dios opudtaj moʼmanoeynoeya̱ʼapone. Durugdakon moʼi̱kaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Opudomey daknopoʼda huataʼyoʼda pakhueʼ yanikaʼpo Diosen aratbut moʼe̱a̱po kenpaʼti Diosere Diosenbayo hua̱e̱ʼeri moʼe̱a̱po. Durugda moʼi̱kaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Opudomey Diosen eʼmanaʼ ʼurunanada eʼkikaʼtaʼ boʼeretpakikaʼnok. Diosa boʼtihuapokaponok daknopoʼda moʼta̱e̱a̱pone. Durugnada moʼi̱kaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nogomeytaj moʼmatinepahuiʼnok Diosa opudtaj moʼmatinepahuiʼpo. Durugda moʼi̱kaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Diosenyoʼda huapakeri ʼurunanada huanopo̱e̱ʼeriomey Diosere moʼe̱a̱pone. Durugda moʼi̱kaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Opudomey huamanoeynoeyeri doʼhuedsiʼpo moʼe̱ne. Diosa monaʼapone. Durugda moʼi̱kaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Diosen eʼmanaʼ boʼkikaʼnok nogomeya̱ boʼhuadiaypo boʼtierikpo mogkaʼne. Opud Diosen boʼkikaʼpo Diosensiʼpo moʼi̱kaʼapone. Durugda moʼi̱kaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Opud doʼhued huaʼa eʼkikaʼtaʼ boʼpaknok namaʼda boʼtidiʼkene kenpaʼti namaʼda mogkaʼne kenpaʼti dakhueaʼda boʼhuaaʼne. Durugda moʼi̱kaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Aʼnenda opud siʼpopakhued Diosen huamanbatiaʼpakeritaj kenpaʼti onʼmagkuyate. Konig premio Diosa ʼuruaʼda moʼto̱e̱a̱ʼapone. Durugda moʼi̱kaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Sal huadakda o̱ʼe̱po aratbuttehuapaʼ. Konigti doʼhued huanigpe̱i̱kaʼeri konig salonig huadakda o̱ʼnepo aratbuttehuapaʼ huadakda o̱ʼne. Sal paiʼ eʼtitiknayo onteʼti huadakda kahueʼdik o̱ʼe̱a̱po. Sal paiʼ eʼtitiknayo huadaritehuapaʼ huadak ehueʼdik o̱ʼe̱a̱po. Paichi kahueʼdik o̱ʼe̱a̱po. Kenpaʼda enʼdik o̱ʼe̱. Batikhueʼada dakaʼ menʼpe̱e̱ʼ. Batikhueʼada dakaʼ meʼnoknopoenkaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Opudomey konig huakjey moʼe̱ne. Diostaj moʼnigpe̱e̱po huadak boʼkikaʼnok aratbuta tiahuaydik moʼe̱ne. Konigti beʼedpiʼ huakkaʼ jak oteʼyo e̱e̱ʼnayo ayaʼada jaktaj tiahuaydik o̱ʼne. Konigti Diosen boʼkikaʼnok ayaʼ aratbutada tiahuaydik moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Huakjey eʼbakpakdeʼte e̱kti̱o̱ke̱ʼyo̱ jonhuadahueʼ o̱ʼnikaʼ. Ayaʼ onʼkudpo tiahuaydik kaʼneʼpo kutopa kutapen huakjey oʼnonhuadikaʼ. Ayaʼ jakyoda jeyda o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Konigti opud huadak ya̱gʼkikaʼpo konig huakjey ya̱ʼnepo ayaʼada opudtaj tiahuaydik kaʼneʼpo kenpaʼti huadakda Dios o̱ʼe̱a̱ʼ batiaʼpakdik kaʼneʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Moisésen eʼmanaʼ kenpaʼti Diosen huamanbatiaʼpakeritaj pe̱e̱hueʼdik yaneʼ.” Eaʼtaʼ oʼpakpo oʼtiakuy. Kenda namaʼda nopo̱e̱hueʼ yaneʼ. “Moisésen eʼmanaʼ kenpaʼti Diosen huamanbatiaʼpakeritaj pe̱e̱hueʼdik yaneʼ.” Ahueʼ a̱ʼe̱ya̱ʼpo ayaʼtada dakaʼda eʼmanopo̱e̱a̱ʼtaj ijpakpo ijtiakuy. ");
INSERT INTO amrNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kurud huadari e̱e̱ʼte batikhued kenpaʼda Moisésen eʼmanaʼ dikenhueʼ o̱ʼe̱a̱po. Suigpiʼ dikenhueʼdik o̱ʼe̱a̱po. Keneʼhua̱ya̱ʼ huameʼnoe e̱ʼe̱deʼte ayaʼda Moisés eʼmanaʼ kuhuitdik o̱ʼe̱a̱pet. Buttida ijjay. ");
INSERT INTO amrNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Beʼapiʼ Diosen eʼmanaʼtaj kahueʼ e̱e̱ʼnayo kenpaʼti Diosen eʼmanaʼ kahueʼdik yaneʼ eʼmanmadikaʼnayo Dios Huairiensiʼpo ehueʼda o̱ʼneapo. Kenpaʼ Moisésa oʼmanaʼuyate opud boʼkaʼpo kenpaʼti ya̱gʼkikaʼ eʼmanmadikaʼnayo Dios Huairiensiʼpo moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Moisésbaʼ huamanmadikaʼeri kenpaʼti fariseo aratbut eretpakhueʼ e̱ʼe̱a̱da Moisésbaʼtaj namaʼda onʼnigpe̱i̱kaʼnigʼa. Opudomeynayo huadakada yanʼnopo̱e̱po Diostaj dakaʼ ya̱gʼkikaʼ. Huadaknopoʼ ehueʼ e̱e̱ʼnayo Diosen aratbut ehueʼ moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Aratbuttaj arakhueʼ ya̱e̱ʼ. Iʼhuadiaypo eʼaraknayo o̱ʼnakon bueydik i̱ʼe̱ne.” Opuden adhueaʼpaneʼ monaʼuyate. Kenda opud moʼpe̱e̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Kenda huadak e̱e̱ʼpiʼ nogda ijjaʼapoy. Beʼapiʼ nog aratbuttaj eʼhuadiaynayo dakhueʼda oʼkaʼnok gobierno huairite castiga ka̱gkeʼpo tohuaʼdik moʼe̱ne. Nog aratbuttaj oʼbahuadiaypo eʼbatidiʼkeʼnayo dakhueaʼda oaʼnok mabitbitdik moʼe̱ne. Castiga ka̱gkeʼpo gobierno huairi e̱gkupopakyo tohuaʼdik moʼe̱ne. “Huasegda i̱ʼe̱po dakhueaʼ iʼkikaʼne.” Nog aratbuttaj enaʼnayo dakhueaʼda iaʼnok taʼakyo hui̱gdik moʼi̱kaʼapone. Doʼa ijjay. ");
INSERT INTO amrNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Diostaj aʼtionaʼpakyaʼpo iʼhuaʼpo nog aratbuttaj dakhueʼada ijkamey huaboaʼda iʼnopo̱e̱de. Tionaʼpakhueda̱da yahuatiʼ. Kentaj yamanoeynoey. Yamanoeynoeydepo aʼtionaʼpakyaʼpo yahuatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“O̱ʼna dakhueaʼ megkaʼne,” noga̱ enaʼnayo gobierno huairitaj boʼtohuaʼdepo eʼtohuaʼte kentaj yanoeya̱ʼ. Eʼmaʼdehueʼnayo huakupepiʼ yayoktiʼ. Noeyahueʼpiʼ yokhueʼpiʼ e̱e̱ʼnayo gobierno huairitaj boʼtohuaʼapone. Ken gobierno huairi sorotatataj boʼyokapone. Sorotataa huabakuda̱ʼ jakyo boʼkuda̱ʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ke̱yo̱da ijhueʼda o̱ro̱khueʼdik i̱ʼe̱a̱pone. Ayaʼda dehueʼte iʼyokdeʼpo o̱ro̱kdik i̱ʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Nogen bakdejhueʼ yaneʼ. Kenda moʼpe̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kenda buttida eaʼpiʼ beʼapiʼ eʼbokerekboʼnayo konig huanopoyaʼ oʼeretpakpo konigti oʼbakdej. Dakhueaʼda oʼkaʼ. Donayo ijjay. ");
INSERT INTO amrNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Eʼbokerekboʼnayo dakhueaʼda ijkay yanʼnopo̱e̱po kenpaʼda yanʼbatiktiʼ. Batikhueʼda dakhueaʼda eʼkikaʼnayo Diosa castiga mogkaʼpo taʼakyo hui̱gdik moʼi̱kaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Dakhueaʼda huabaʼa ekaʼnayo kenpaʼda yanʼbatiktiʼ, dakhueʼda eʼkikaʼnayo. Batikhueʼda Diosa castiga mogkaʼpo taʼakyo hui̱gdik moʼi̱kaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Beʼapiʼ huabokerek hua̱to̱e̱ e̱ʼennayo ettoneʼtaj e̱ʼendeʼ huanopo̱e̱ʼ berobaʼ yokdik o̱ʼe̱. Opuden adhueaʼpaneʼ kenda monaʼikaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Donayo nogda ijjay. Huabokereken hua̱to̱e̱ bakdejhued e̱e̱ʼtada e̱ʼennayo ettoneʼtaj dakhueʼda o̱gkaʼ. Ken ettoneʼ e̱ʼendeʼtaj eʼto̱e̱ʼnayo konig eʼbakdejonhuahuikaʼ o̱ʼe̱. Kenpaʼti huabokereka nogen hua̱to̱e̱ e̱ʼentaj eʼto̱e̱ʼnayo konig eʼbakdejonhuahuikaʼ o̱ʼe̱. Diostehuapaʼ dakhueaʼda o̱ʼe̱, ijjay. ");
INSERT INTO amrNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ijkaʼapoy. Buttida ijjay. Diosa meknopo̱e̱ne.” Diostaj eʼhuaaʼnayo da ahueʼ ya̱e̱ʼ, kenda yakatiʼ. Kenda opuden adhueaʼpaneʼa̱ onʼmanaʼuyate moʼpe̱e̱deʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Donayo nogda ijjay. “Ijkaʼapoy. Buttida ijjay.” Ahueʼ yanikaʼ. “Ijkaʼapoy,” kenyoʼda yaaʼ. Kurud Diosenbayo o̱ʼe̱. Ke̱ya̱ʼ oʼmataʼmonaʼikaʼ. “Ijkaʼapoy. Buttida ijjay. Kuruda meknopo̱e̱ne da ahueʼ i̱jje̱y.” Ken konig ahueʼ yanikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Dios huadarite oʼibonok, “Ijkaʼapoy, buttida ijjay. Huadaria meknopo̱e̱ne. Da ahueʼ i̱jje̱y.” Ken konig ahueʼ yanikaʼ. Jerusalén Dios Huairien huakkaʼ jak o̱ʼe̱nok, “Ijkaʼapoy, buttida ijjay. Jerusaléna meknopo̱e̱ne. Da ahueʼ i̱jje̱y.” Ken konigtion ahueʼ yanikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Opuda̱da kuhuirihueahueʼdik moʼe̱ne. Diosayoʼda kuhuirihueaʼdik o̱ʼe̱. “Ijkaʼapoy, buttida ijjay. Doʼhued huaku oʼnopo̱e̱. Da ahueʼ i̱jje̱y.” Kention ahueʼ yanikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Kenpaʼda buttida yadaʼ. Menokpiʼ da ahueʼ yaneʼ. Nogi̱ti nogi̱tinada eaʼnayo totoʼa menaʼnok iaʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Huabokerekapiʼ nogtaj dakhueaʼ e̱gkaʼnayo kenpaʼti huairiakon konigti kentaj o̱gkaʼdik o̱ʼe̱. Kenda opud moʼpe̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Nogpaʼda donayo ijjay. Noga̱ ontaj dakhueaʼ e̱gkaʼnayo diayhueʼ ya̱e̱po kentaj o̱gkahueʼ ya̱e̱tiʼ. Noga̱ ontaj noga̱tida e̱gkaʼnayo diayhueʼ ya̱e̱po o̱gkahueʼ ya̱e̱tiʼ. Onteʼti e̱gkaʼnayo onteʼti diayhueʼ ya̱e̱po o̱gkahueʼ ya̱e̱ʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Noga̱ gobierno huairipiʼ “Opiot beyok,” enaʼnayo dakaʼda yayoktiʼ. Kenpaʼti diayhueʼada chompakon yayoktiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","“Doʼhued yudtaj adtemon betatohuaʼ.” Sorotataapiʼ enaʼnayo diayhueʼada adyo̱da yatatohuatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","“Aypo beyok.” Noga̱ enaʼnayo sueʼnopo ehueʼada yabayoktiʼ. Yudtaj bektoyok enaʼnayo daknopoda ya̱e̱po yaktoyoktiʼ, ijjay. ");
INSERT INTO amrNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Huadiʼtaj diʼ yamaikaʼ. Ontaj huatinosikeritaj konigti yanʼhuadiayikatiʼ.” Kenda opuden adhueaʼpaneʼ onʼmanaʼuyatenig moʼpe̱e̱deʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Donayo nogpaʼda ijjay. Matinosikeritaj diʼ yanʼmaikaʼ. Dakhueaʼda huaaʼeritaj Diosa “Kanopoʼkoreʼ,” yanʼtionaʼpakikatiʼ. Huadiayeritaj huadakda yakikatiʼ. Huabatidiʼkeritaj yanʼtionaʼpakikatiʼ. Huamagkeritaj kenpaʼti yanʼtionaʼpakikatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Kenda boʼkikaʼpo konig Apag Dios Kuruderiensiʼpo moʼi̱kaʼapet. Huadak huakaʼeri kenpaʼti dakhueaʼ huakaʼeriere aypo kanʼto̱i̱ke̱ʼpo Diosa niokpoa kataʼteikeʼpo oʼkuyate kenpaʼti ehuiʼ moʼnigtaʼmonaʼikaʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Diʼ aratbuttayoʼda diʼ eʼmaikaʼnayo gana eʼkaʼhuayak baehueʼdik moʼe̱a̱pone. Kenda dakhueaʼ huakaʼeria o̱gkikaʼ. Diʼ aratbuttaj diʼ onʼmaikaʼ. Dakhueaʼ huakeritaj kenpaʼti diʼ maikaʼdik moʼi̱kaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","O̱ʼnen huabettayoʼda ʼuruaʼda e̱ʼhua̱i̱kaʼnayo “Huadakda ijkay,” nopo̱e̱hueʼ yanikaʼ. Dakhueaʼ huakaʼeria kenda o̱gkikaʼ. Dakhueaʼ huakeritaj kenpaʼti diʼda huaaʼdik moʼi̱kaʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Opuden Apag Dios kurudyo̱ ayaʼtada diʼ oʼmaikaʼ kenpaʼti ayaʼtada huadakaʼda oʼmagkikaʼ. Konigti opuden Apag Dios ayaʼtada diʼ yanʼmaikaʼ kenpaʼti ayaʼda huadaknopoʼda ya̱gʼkikatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Aratbuta menʼtiahuayeʼpoyoʼda paiʼda aratbuttaj eʼbayoknayo namaʼda bokaʼne. Ken konig kahueʼ yanikaʼ. Kenda eʼkikaʼnayo Apag Dios kurudyo̱ hua̱e̱ʼeria kenpaʼ eʼkaʼhuayak bayokhueʼdik moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","3","Namaʼda huanopo̱e̱ʼeria huakkaʼ aratbut menʼtiahuayeʼpo paiʼda aratbuttaj onʼbayokikaʼ. Kenpaʼti hua̱i̱takeʼ jakyaʼ huakkaʼ aratbut menʼtiahuayeʼpo paiʼda aratbuttaj onʼbayokikaʼ. Konige̱po huadakda o̱gkaʼ batiaʼpakikaʼdik meʼnepo. Kenpayoʼda onʼpe̱i̱kaʼpo. “Huadak o̱gkaʼ.” Diosa ahueʼ moʼe̱a̱pone. Kenomey namaʼda huanopo̱e̱ʼeria diga̱ʼda aratbuttayoʼda onʼpakikaʼ. Diostanayo pakhueʼ o̱ʼne. Konig kenomey o̱gkikaʼ kikahueʼ yaneʼ. I̱re̱gi̱re̱g yanʼbayokikatiʼ. O̱ʼnen huadiʼa tiahuayhueʼte paiʼda aratbuttaj yanʼbayokikatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","I̱re̱gi̱re̱g aratbuta tiahuayhueʼ eneʼte paiʼda aratbuttaj yanʼbayokikatiʼ. Kenda eʼkikaʼnayo Dios i̱re̱gi̱re̱g eʼbayokikaʼnayo oʼtiahuaypo Diosa nogi̱tida ʼuruda boʼyokapone. ");
INSERT INTO amrNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Do huadakda i̱jje̱y namaʼda huamanopo̱e̱a̱ʼeri hua̱i̱takeʼ jakyo kenpaʼti jak kurute aratbut e̱gkupopakikayaʼ onʼtionaʼpakikaʼ. “Huadakda o̱ʼne.” Aratbuta menhuaikeʼpo onʼtionaʼpakikaʼ. Kenda dakhuapa e̱ʼe̱a̱da onʼtionaʼpakikaʼnigʼa Diosanayo sigpiʼ pe̱e̱hueʼdik moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Opudomeynayo menokapiʼ eʼtionaʼpaktaʼ boʼpakpo o̱ʼnenbayo dubayapiʼ nogtiaʼda Apag Diostaj yanʼtionaʼpakikatiʼ. I̱re̱gi̱re̱g eʼtionaʼpakikaʼte Apag Diosa tiahuaydik moʼe̱ne. Moʼpe̱e̱i̱kaʼapone. Montihuapokikaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","8","Diostaj oknopo̱e̱hueʼ hua̱e̱ʼeria konigdikti onteʼti onteʼti ijhueʼda onʼtionaʼpakonhuaʼnigʼa Diosa moʼpe̱e̱a̱pone namaʼda onʼnopo̱e̱nigʼa. Kenomeytaj Diosa nigpe̱e̱hueʼdik oʼmaikaʼapo. Konigti kikahueʼ yaneʼ. Tionaʼpakhued e̱e̱ʼted kenda iʼpaknig Apag Diosa oʼnopo̱e̱. ");
INSERT INTO amrNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","In konig yanʼtionaʼpakikatiʼ: Oroʼen Apag i̱ʼe̱ne, Apag Dios. Kurudyo̱ i̱ʼi̱kaʼne. Kenpaʼda ʼurunanada i̱ʼi̱kaʼne. O̱ʼnen huadik kenpaʼda huadakda o̱ʼi̱kaʼ. Ayaʼada kaʼdikeʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Huakhuairi i̱ʼe̱nok i̱da ayaʼada ontaj moʼnigpe̱i̱keʼ. Dios Huairi i̱ʼe̱po ayaʼda iʼpakpo iʼmanikaʼ. Kurudyo̱ hua̱e̱ʼeria moʼnigpe̱i̱kaʼpo o̱gkikaʼ konigti i̱yo̱ huadariyo ayaʼada huakaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Inmeʼnoete aypo oroʼtaj aʼnigya̱ya̱ʼpo boʼtihuapok. ");
INSERT INTO amrNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Oroʼtaj dakhueaʼ mogkameʼnigtaj oroa oʼbakkahueay konigti oroʼen dakhueaʼ eʼkikaʼtaj bokkahueaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Dakhueaʼ eʼkaʼ nopo̱e̱hueʼ ka̱i̱keʼpo montihuapok. Namaʼda eʼkaʼtaʼ eʼpaknayo kikahueʼ ka̱e̱ʼpo boʼtihuapok, Apag Dios. Dios Huairinayo ayaʼenda Huakhuairinanada i̱ʼe̱po teynananada i̱ʼe̱po kenpaʼda huadaknananada i̱ʼe̱nok kenda ayaʼada kanʼmanbatiaʼpakikeʼ, ken. Ken konig yanʼtionaʼpakikatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Opudtaj dakhueaʼ mogkameʼnigtaj ekkahueaʼnayo o̱ʼnen Apaga̱ kurudya̱ʼ o̱ʼnen dakhueaʼ eʼkaʼ bokkahueaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Opudomey nogomeytaj okkahueahueʼ e̱e̱ʼnayo Diosa opudtaj okkahueahueʼdik moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Oroʼ huadakda o̱ʼe̱ namaʼda huamanopo̱e̱a̱ʼeri, paiʼda o̱ʼe̱, namaʼda eʼmanopo̱e̱a̱ʼtaʼ onʼpakpo huakok koyoahueʼda o̱gkokparokaʼpo “Huadakda o̱ʼne.” Aratbuta kanʼbatiaʼpakeʼpo aypo bapehueʼ o̱ʼneonhuaʼnigʼa, “Huadakda o̱ʼne.” Diosanayo huaahueʼdik moʼe̱a̱pone. Opudomeynayo Diostaj aypo bapehueʼ moʼunhuaʼpo ken konig kikahueʼ yaneʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Opudnayo eʼtionaʼpakte aypo bapehueʼ e̱ʼunhuaʼnayo ya̱gʼkokkoyoikaʼ kenpaʼti dakaʼ ya̱gʼkuirida̱ʼikaʼ. Kenda ekaʼnayo aratbut boʼtiahuaypo aypo bapehueʼ o̱ʼnunhuaʼnigtaj nokothueʼdik o̱ʼneapo. Opuden Apag Diosayoʼda soatayoʼ boʼtiahuayapone. Boʼtiahuaypo moʼpe̱e̱po huanoeonhuahuikaʼ moʼbayokapone. ");
INSERT INTO amrNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Katepiʼ ʼuru yudtapiʼ huakkaʼnada eʼtamaetaʼ eretpakhueʼ yanikatiʼ. Huakkaʼda mato̱e̱hueʼ yanikatiʼ. Huakkaʼda eʼmato̱e̱ʼnayo indariyo huithuita yaʼbapeapetpiʼ, huakkaʼda yaʼparaʼapetpiʼ, yanʼbereapetpiʼ, ");
INSERT INTO amrNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Dios kuruderienyoʼda yaderetpakpo yanʼnigpe̱i̱kaʼ. Diosa okkahuehueʼdik o̱ʼe̱a̱po. Kenpaʼti Diosen o̱ʼta̱e̱ kateapiʼ bapehueʼdik parahueʼdik okberehueʼdikpiʼ o̱ʼunhuahuikaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Diosen eʼkikaʼnayo Diostaj diʼnanada moʼe̱po Diostaj boʼeretpakikaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","Opudomeyen huakpo hua̱so̱ʼen huakjey e̱ʼdik o̱ʼe̱. Huakpoa katepiʼ boʼtiahuaypopiʼ ontehuapayoʼda eretpakdik moʼenepiʼ, huadaknopoʼda moʼe̱po nogomey paiʼda hua̱e̱ʼeritapiʼ eʼbayoktaʼ boʼeretpakpopiʼ. Katetapiʼ ʼuruda eʼtiahuayada nogomey kanʼtamaeʼpo eʼpaknayo huadaknopoʼda moʼe̱po durugda moʼe̱po huadakda boʼkikaʼne. Konig huakjeyyonig moʼi̱kaʼ. Katetapiʼ boʼtiahuaypo ontehuapayoʼda boʼeretpakpo dakhueʼnopoʼda moʼe̱po durugnopoʼ ehueʼ dakhueʼ boʼkikaʼ. Konig sikki̱re̱gyo̱nig moʼi̱kaʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Diosyoʼda konig huairi o̱ʼe̱. Kentayoʼda nigpe̱i̱kaʼdik moʼe̱ne. Kentayoʼda diʼnanada i̱kaʼdik moʼe̱ne. Huakkaʼda katepiʼ eʼeretpakikaʼnayo nogda huairi moʼta̱e̱. Konige̱po huakkaʼda katepiʼ eretpakhueʼ yanikatiʼ. Diostaj eʼnigpe̱i̱kaʼnayo huakkaʼda katetapiʼ eretpakhueʼdik moʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Aypotaʼ eʼmaiʼtaʼpiʼ yudtataʼ mepuʼkudhuahuahueʼ yanikatiʼ. Diosa oroʼtaj moʼnoeaʼikaʼne kenpaʼti oroʼen aypo oroʼen yudtaj boʼyokikaʼne. Konige̱po Diostaj yanoknopounhuahuikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Bakoy baahueʼtada o̱ʼnen Apag Diosa aypo oʼbayokikaʼ. Bakoytaʼ suigda oʼpak. Opudtanayo Apag Diosa huakkaʼda oʼpak. Konige̱po boʼtihuapokikaʼapone. Aypotaʼ mepuʼkikahueʼ yanikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Huabokerek eʼkerektaʼ eʼpakada huakkaʼ eʼmepuʼkudhuahuada nogi̱ti kerekhueʼdik o̱ʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Menaʼpo yudtataʼ moʼmepuʼkikaʼ? Mepuʼkehueʼ yanikaʼ. Mire̱bayo huakhuen yanʼtiahuayikaʼ. Mire̱ huakhuen baahueʼada o̱ʼe̱. Jo̱da oʼkerek. ");
INSERT INTO amrNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Salomónkudak huairitoneʼ o̱ʼu̱yate. Huakkaʼda oʼto̱e̱ʼuyate. ʼUruda yudtaj oʼmato̱e̱ʼikaʼuyate. ʼUruda oʼotikaʼ. Huakhuennayo nogi̱tinada ʼurunanada Salomónkudak sueʼda ʼuruda oʼotikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Diosa huakunopia okhuenpakaʼ. ʼUruaʼnada eʼkaʼtada i̱dada okhuenkot. Diosa huakunopiada okhuenpakaʼikaʼ kenpaʼti opudtaj huakkaʼda oʼpakpo oʼtihuapokapone yudtaj yokikaʼdik moʼi̱kaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Konige̱po katetapiʼ mepuʼkehueʼ yanikatiʼ. “¿Kate oʼbapeapo?” Nopo̱e̱hueʼ yanikatiʼ. “¿Kate oʼmayapo?” Nopo̱e̱hueʼ yanikatiʼ. “¿Kate ijjotapo?” Nopo̱e̱hueʼ yanikatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Oknopo̱e̱hueʼ hua̱e̱ʼeri huakkaʼda yudtaj kenpaʼti huakkaʼda aypo diga̱ʼda onʼpakikaʼ. Kenokaʼ opud to̱e̱hueʼda moʼe̱nok Apag Diosa oʼnopo̱e̱po boʼtihuapokikaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nogi̱ti nogi̱ti Dios Huairitaj yanʼpakikaʼ. Nogi̱ti nogi̱ti Dios Huairitaj eʼnigpe̱e̱taʼ yanʼpakikaʼ. Ken konig Diostaj eʼpakikaʼnayo Diosa boʼyokikaʼapone. Yudtaj aypo huamaiʼ katepiʼ boʼyokikaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Emeʼte katepiʼ ijjotapo, katepiʼ ijbapeapo katepiʼ yamayapo kenpaʼ nopo̱e̱hueʼ yanikaʼ. Konig oy Diosa boʼtihuapokpo emeʼtepiʼ nogok nogok Diosa dakaʼ boʼtihuapokikaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Dakhueaʼ oʼkaʼ,” Diosa huaahueʼ moʼe̱ʼpo nogomeytaj “Dakhueaʼ oʼkaʼ,” bahuaahueʼ yanikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Konig nogomeytaj boʼhuaaʼikaʼnig konigti Diosa opudtaj boʼhuaaʼapone. Konig nogomeytaj boʼkikaʼnig konigti Diosa mogkikaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","5","Noga̱ sueʼpiʼ dakhueaʼ eʼkaʼtada “dakhueaʼ ikaʼ,” i̱da onahueʼ yanikaʼ. Onaʼtaj dakhueaʼnanada iʼkuyʼetpiʼ. Kenda nopo̱e̱hueʼ moʼe̱ne. In konig o̱ʼe̱ ijbatiaʼpakapoy. Nogen huakpoyo huataʼsujsiʼpo ekpohuedte o̱ʼna iʼtiahuaynigʼa. O̱ʼnen huakpoyoaʼtaj huaboroʼtaʼsuada bekpohuedne. “Huataʼsuj huakpoyo oktokiʼ, egʼ.” Menpaʼ inaʼ. Namaʼda iʼnopo̱e̱po iaʼ. Ken o̱ʼnen huakpoyoaʼtaj huaboroʼtaʼsuada ekpohuedtada tiahuayhueʼ i̱ʼe̱ne. Namaʼda huanopo̱e̱ʼeri i̱ʼe̱ne. Huakkuruda o̱ʼnen huakpoyo huaboroʼtaʼsutaj on huataʼ yakokpotoken. Ken konig dakhueaʼ iʼkaʼuynig yanopoʼkoreaʼpo yabatik. Kenokaʼ iʼnopoʼkoreaʼdepo dakaʼ iʼtiahuaydepo nogen huataʼsujsiʼpokon okpotokdik i̱ʼe̱a̱pone. Noga̱ namaʼda ekaʼnayo dakhueaʼ eʼkaʼ kabatikeʼpo batihuapokdik i̱ʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Huatidiʼkeritaj Diosen huadak huaʼa manmadikahueʼ yanikaʼ. Kentaj eʼmanmadikaʼnayo dakhueaʼ magkaʼdik ya̱ʼneapetpiʼ. Konigti Diostaj pakhueʼ hua̱e̱ʼeritaj Diosen huadak huaʼa manmadikahueʼ yanikaʼ. ʼUrunanada eʼmanmadikaʼnayo opudomeytaj boʼhuadiaypo dakhueaʼda mogkaʼapetpiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Katepiʼ boʼpakpo “Beyok” Diostaj yanʼtionaʼpakikatiʼ. Diosa boʼyokikapone. Diostaj boʼukpo boʼhuahuayapone. Menigokhuikeʼ Diosyo ijkuda̱poy. Yanʼtionaʼpak. Moʼtionaʼpakdepo kuddik moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Konige̱po beyok o̱ʼna eaʼnayo Diosa boʼyokapone. Kenpaʼti eʼuknayo boʼhuahuayapone. Ijkudapoy menigokhuikeʼ enaʼnayo kuddik moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Aypo beyok.” O̱ʼnensiʼpoa enaʼnayo huid yokhueada aypoda yokdik moʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","“Biig beyok.” Enaʼnayo bihui yokhueada, biigda yokdik moʼe̱ne. Kenda huasiʼpo oʼpaknig kenda boʼyokne. ");
INSERT INTO amrNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Opud dakhueʼda e̱e̱ʼpiʼ katepiʼ huadakda moʼbayokikaʼne huasiʼpotaj. Kenpaʼda Diosnayo huadakda oʼkikaʼ. Opud Diostaj eʼtionaʼpakikaʼnayo Diosa huadakda mogkikaʼapone kenpaʼti huadakda huakikaʼ boʼtihuapokikaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Konig nogomeya̱ opudtaj huadakda e̱gkikaʼtaʼ eʼpaknayo huadakda o̱gkikahueʼ e̱e̱ʼpiʼ kenomeytaj huadakda ya̱gʼkikatiʼ. Konig nogomey opudtaj diʼda e̱e̱ʼtaʼ eʼbatipaknayo kenomeytakon diʼnanada yanʼmaikatiʼ. Ken konig Moisésa oʼmanbatiaʼpakonhuahuaʼuyate. Kenpaʼti huamanbatiaʼpakeria ken konigti onʼmanbatiaʼpakonhuahuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Diosyo huahuaʼ suig akbogpe huakud o̱ʼe̱. Diosyo huahuaʼ suigdagda o̱ʼe̱. Diosyo boʼhuaʼpo suigdag huakkaʼ boʼpakpo huaʼdik moʼi̱kaʼpone. Suigdagte huahuaʼ Diostaj moʼnigpe̱i̱kaʼpo Diosere onteʼti moʼnoeonhuahuikaʼapo. Boroʼdagte taʼakyo onʼhuaʼikaʼ. Taʼakyo huahuaʼ dag huaboroʼdag o̱ʼi̱kaʼ. Boroʼdagtaj huakkaʼda eretpakdik o̱ʼnikaʼ. Katepiʼ huakkaʼda eʼtamaetaʼ onʼpakikaʼ. Dakhueaʼda kikaʼdik o̱ʼnikaʼ. Boroʼdagte huakkaʼnada onʼbahuaʼikaʼ. Taʼakyo onʼbahuaʼikaʼ. Taʼakyo mahui̱gdik o̱ʼi̱kaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Diosyo huahuaʼ suigdagda o̱ʼe̱. Dagsiʼpoda o̱ʼe̱. Suigdagteda huakkaʼda katepiʼ to̱e̱hueʼdik moʼi̱kaʼapone. Diosenyoʼda kikaʼdik moʼi̱kaʼpone. Suigdagte boʼhuaʼpo onteʼti Diosere moʼnoeonhuahuikaʼapone. Suigdagtaj sueʼada onʼhuahuaypo onʼhuaʼikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Namaʼda huamanmadikaʼeria opudtaj eʼmanmadikaʼtaʼ onʼpakpo yanʼtiakapet. Keyoj namaʼda monmadikapet. Namaʼda eʼmanopo̱e̱a̱ʼtaʼ onʼpak. Konig oveja i̱jje̱y. Huadakda ijkikay. Buttida ijjay. Namaʼda opudtaj monaʼikaʼapet. Konig apetpet o̱ʼne. Huiyokda o̱ʼne. Dakhueaʼda o̱gkaʼdik moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Huamanmadikaʼeria dakhueaʼda eʼkikaʼnayo namaʼda huamanmadikaʼeri o̱ʼne. Maknokotdik moʼe̱ne. Konig okposidsiʼ ʼuruda huada dapakhueʼdik o̱ʼe̱. Konigti namaʼda huamanmadikaʼeri huadak kikahueʼdik o̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Huamanmadikaʼeri konig hue̱ymey o̱ʼne. Huadak hue̱ymeya̱ kenpaʼti huadak huada oʼto̱i̱kaʼ. Hue̱ymey eʼaya huada kenpaʼti oʼay. Dakhueʼda o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Hue̱ymey huadakda e̱e̱ʼnayo dakhueʼ huada to̱e̱hueʼdik o̱ʼe̱. Hue̱ymey eʼaya huadak huada to̱e̱hueʼdik o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ayaʼda hue̱ymey eʼmadaayikaʼnayo taʼtegdik o̱ʼe̱a̱po. Oʼtaʼtegpo hui̱gdik o̱ʼe̱a̱po taʼakyo. ");
INSERT INTO amrNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Namaʼda huamanmadikaʼeria dakhueʼda o̱gkikaʼ. Huamanmadikaʼeria dakhueʼda eʼkikaʼnayo namaʼda huamanmadikaʼeri o̱ʼne. Maknokotdik moʼe̱ne. Kenomeytaj manigpe̱e̱hueʼ yanetiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Doʼhued huairi ontaj huakkaʼda ijnigpe̱i̱kay, Huairi.” Doʼtaj huakkaʼada oʼnonaʼapet. Sueʼda huakkaʼamon aratbuta huadaknopoʼda kenda oʼnonaʼpo Apag Diostaj moʼnigpe̱i̱kaʼnok kenomeynayo Diosensiʼpo o̱ʼne. “Doʼhued huairi ontaj huakkaʼda ijnigpe̱i̱kay, Huairi.” Huakkaʼada doʼtaj namaʼda oʼnonaʼapet. Apag Diostaj nigpe̱e̱hueʼ o̱ʼnepo dapitaʼ Diosensiʼpo ehueʼda o̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Keneʼhua̱ya̱ʼ huameʼnoete ayaʼada Diostaj onʼtoboapo. “Diosa monaʼnok Diosbaʼ oroʼa oʼmanbatiaʼpakikaʼuy. Diosa monaʼnok aratbuttaj oʼbayareaʼpo totoʼ noki̱re̱g oʼmaoro̱kaʼuy. Diosa monaʼnok konig Diosyoʼda teyda kaʼdik o̱ʼe̱ konigti oroʼ ʼuruaʼda oʼkikaʼuy.” Diostaj onʼtobopo huakkaʼada ya̱ʼnonaʼapet. ");
INSERT INTO amrNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","“Opudtaj o̱ki̱e̱hueʼ i̱jje̱a̱huadikamey. Dakhueaʼda huakaʼeri moʼe̱ne. Kenpaʼda yanhuatiʼ.” Ijmanaʼapoy. ");
INSERT INTO amrNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","25","Ayaʼada doʼhued huaʼataj moʼnigpe̱i̱kaʼpo boʼkikaʼ kenpaʼda bueyhueʼdik moʼi̱kaʼapone. Onteʼti doere moʼnoeonhuahuikaʼapone. Konig huadak huanopo̱e̱ʼeri jak huakaʼeri o̱ʼnepo jak o̱gkaʼ. Oteʼyaʼ dariteytaʼ jak o̱gkaʼ. Adteda ʼiddu o̱gkude̱a̱ʼ. Diga̱ʼda oʼhuiʼ, diga̱ʼda kenpaʼti oʼbapok. Hue̱kurukon oʼtiak. Oteʼyo o̱ʼe̱nok hue̱kurua jak tohuahueʼdik o̱ʼe̱. Bapoka onhue̱ke̱hueʼdik o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ayaʼada doʼhued huaʼataj nigpe̱e̱hueʼ o̱ʼnepo konig namaʼda huakaʼeri o̱ʼne. Namaʼda huakaʼeri konig kuhuadtaʼ jak huakaʼeri o̱ʼne. Adteda ʼiddu kude̱a̱hueʼ o̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Huakkaʼ oʼhuiʼ kenpaʼti diga̱ʼda oʼbapok kenpaʼti hue̱kuru o̱ʼhue̱pokpo jak oʼtohuaʼ. Keʼpoda oʼkaʼ. Namaʼda huakaʼeri ken konig o̱gkikaʼ kenpaʼti doʼed eʼmanmadikaʼte nigpe̱e̱hueʼ o̱ʼnikaʼ. —‍Kenda Jesúsa oʼmanmadikaʼahuaduy. ");
INSERT INTO amrNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesúsa kenda eʼmanmadikadeʼte “Kenpihuay ʼuruaʼda oʼmanmadikaʼ.” Aratbuta onʼbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","“ʼUruaʼda oʼmanmadikaʼnok nigpe̱i̱kaʼdik o̱ʼi̱kaʼapoy. Moisésenbaʼ huamanmadikaʼeria konig huairi manmadikahueʼ o̱ʼnikaʼ.” Aratbuta onʼbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesús oteʼyaʼ oʼhuarakpo huakkaʼada onʼtaʼbahuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Jesústaj huabokereka oʼhuatiakuy, kena keʼpoda eʼso̱ʼset. Konig aʼnenda aratbut gobierno huairitaj o̱gkikaʼuynig keʼna Jesústaj huikudate oʼtihuadpo: —‍O̱ʼna eʼpaknayo beyareaʼ, Huairi. —‍Onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesúsa oʼtibataʼtepo onaʼpo: —‍Eʼyareaʼtaʼ ijpaki. Ijyareapoy. —‍Jesúsa onaʼuy. Enaʼte i̱dada oʼyarudʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","—‍Jesúsa beʼyareaʼne mantiaʼpakhueʼ ya̱e̱ʼ. Sacerdote Diostaj ʼuhua huanigbatiarakerite yahuatiʼ. Aʼyareyaʼpo konig Moisésa oʼmanaʼuyate ken konig yayoktiʼ. Sacerdotea ʼuhua Diostaj kanigarakeʼpo ʼuhuapiʼ yayoktiʼ. Ken konig iʼkaʼpo oʼyaredepo aratbuta moʼtinopo̱e̱a̱pone. —‍Jesúsa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Huakkaʼ jak Capernaumyo Jesús eʼkudondeʼte Roma sorotataj Capitána Jesústaj oʼhuahuaʼuy. Cien sorotataj oʼmataʼmonaʼikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Jesústaj —‍Doʼhued huanabaʼ jakyo onpahued. Hua̱so̱ʼ dakhueʼda o̱ʼe̱po konig ayhueʼda o̱ʼe̱. Paiʼnada oʼnopoʼe̱, Huairi. —‍Capitána diga̱ʼ oʼpakpo onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","—‍Aʼyareayaʼpo ijhuaʼapoy. —‍Jesúsa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","—‍O̱ʼna ʼuruaʼda Huairi i̱ʼe̱. Donayo nog aratbutda i̱jje̱y. Ehueʼda i̱jje̱y. Doʼhued jakyo kudhueʼdik i̱ʼe̱ne, Huairi. Kayareʼ yaaʼ. Eadeʼte oʼyaruda̱po. ");
INSERT INTO amrNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Doʼhued sorotataj huairia menikaʼne kenda ijnigpe̱i̱kay. Kenpaʼti doʼhued sorotatataj ijmanikay doʼtaj menʼnigpe̱i̱kaʼne. “Yahuatiʼ.” Doʼhued sorotatataj enadeʼte onʼhuaʼikaʼ. Nogtaj “Yatiak,” enaʼte onʼtiakikaʼ. Doʼhued huanabaʼtaj katepiʼ “Yakaʼ,” enaʼnayo oʼkikaʼ. —‍Capitána Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Kenda Jesúsa oʼpe̱e̱depo, —‍Kenpihuay, huakkaʼda meknopo̱e̱ne. Israel aratbut Diosen aratbut e̱ʼe̱a̱da sueʼda Diostaj oʼnoknopo̱e̱. ");
INSERT INTO amrNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Huakkaʼda nog aratbutda judío ehueʼ oʼnoknopo̱e̱a̱po. Bidtaʼda onʼtiakapo nogya̱ʼ nogya̱ʼ. Abrahamere Isaacere Jacobere onʼbapeʼpo onʼnoeonhuahuikaʼapo. Diosensiʼpo o̱ʼneapo. ");
INSERT INTO amrNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Huakkaʼada judío aratbuta Diosensiʼpo o̱ʼe̱y namaʼda onʼnopo̱e̱po Diostaj oknopo̱e̱hueʼada onʼnopo̱e̱nok Diosa oʼmaenapo. Sikki̱re̱gyo̱da onʼbahuaʼapo. Paiʼda onʼnopoʼunhuahuikaʼapo. Kenpaʼda onʼhuikonhuahuikaʼapo. —‍Jesúsa huanigpe̱i̱kaʼeritaj oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Onaʼti capitántaj onaʼpo: —‍O̱ʼnen jakyo yahuatiʼ. Konig doʼtaj iknopo̱e̱nig o̱ʼnen huanabaʼ oʼyarudde. —‍Jesúsa onaʼuy. Kenda eaʼte huanabaʼ oʼyarud. ");
INSERT INTO amrNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Pedroen jakyo Jesús oʼhuaʼuy. Pedroen huasuʼ oʼdigpakpo onpahued. Jesús eʼkuddeʼte oʼtiahuayʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Huabaʼtaʼ oʼnejpo oʼyareadʼuy. Ken Pedroen huasuʼ oʼyaruddepo oʼbodpo oʼmanigmanhuada̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nogya̱ʼ nogya̱ʼ huakkaʼ aratbut o̱ʼnepo, dakhueʼda o̱ʼnepo, noga̱ noga̱ nogda nogda dakhueʼ onʼto̱e̱po onʼdigpakpiʼ, ekpobigpiʼ, nogda nogda dakhueʼda o̱ʼneʼuyate. Ken eʼsikdeʼte kenomeyen huabeta Jesúste onʼbatotiakuyate. Jesús nogtati nogtati oʼbatibataʼteʼepo oʼbayareaʼuyate. Nogomey kenpaʼti dakhueʼda e̱ʼneʼte Jesúsa totoʼtaj oʼmakenaʼuyate. Ayaʼ dakhueʼ hua̱e̱ʼeritaj oʼbayareaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","“Oroʼtaj moʼtinepahuiʼpo boʼyareaʼapone.” Isaíasa aʼnennada oaʼuyate. Kenpaʼ Isaíasa Jesústaj oʼtiaʼpakpo oaʼuyate. Kenda Jesúsa oʼkaʼpo oʼbayareaʼuy. Jesúsa huakkaʼtada oʼbayareaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nogok Jesústaj huakkaʼada enʼtikupopakte Jesúsa oʼbatiahuaypo, “E̱ʼpo̱gtoneʼ moʼdayhua,” oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","E̱ʼpo̱g ayhuahued Moisésenbaʼ huamanmadikaʼeria Jesústaj oʼhuatiakuy. Onaʼpo: —‍Meyo̱piʼ iʼhuikaʼapo o̱ʼnen huanigpe̱i̱kaʼeri e̱e̱ʼtaʼ ijpaki. Ontaj eʼtahuikaʼtaʼ ijpaki, Huamanmadikaʼeri. —‍Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","—‍Nubakuhued huakog o̱ʼta̱i̱kaʼ. Bakoyen kenpaʼti huapak o̱ʼta̱i̱kaʼ. Do huabokerek i̱jje̱po Diosyaʼ ijtiakuy. Donayo nog jakyo nog jakyo ijtayʼikay. Doere eʼhuaʼnayo meyo̱kon yatayapet nopo̱e̱hueʼ ya̱e̱ʼ. —‍Huamanmadikaʼeritaj Jesúsa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","—‍Ontaj etahuataʼ ijpaknigʼa huakkuru bueyhued e̱e̱ʼted huaojtoneʼtaj dakaʼ to̱e̱dik i̱jje̱y. —‍Noga̱ huanigpe̱i̱kaʼeria Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","—‍Huabo oknopo̱e̱hueʼ hua̱e̱ʼeria nog oknopo̱e̱hueʼ hua̱e̱ʼeritoneʼtaj dakaʼ kanʼto̱i̱ke̱ʼ kenpaʼti kanʼkubarakkeʼ. Onnayo diga̱ʼda yaeretpakpo betaʼhuaʼ. —‍Jesúsa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jesús huanigpe̱i̱kaʼeriere e̱ʼpo̱g aktegyaʼpo kusiʼpetoneʼyo onʼbahuadpo onʼhuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","E̱ʼpo̱gnopoyo e̱e̱ʼte huaboroʼbapokada oʼbahuatiakuy. Teyaʼda oʼbapoknok huaboroʼda oʼhue̱niri̱ʼtoneʼpo diga̱ʼda oʼhue̱kudpo huataʼkotdikte o̱ʼu̱y. Jesúsnayo oʼtayʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Aʼmaboayaʼpo Jesústaj onʼhuahuaʼ huanigpe̱i̱kaʼeria: —‍Boʼtihuapok, Huairi. Montakotnede. —‍Jesústaj oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","—‍Meʼpukhueʼ yaneʼ. Diosa boʼtihuapokapone. Diosa boʼtiokkikaʼapo dakaʼ yanoknopo̱i̱kaʼ. —‍Jesúsa oʼmanaʼuy. Oʼmabodpo, “Yabatik, bapokhueʼ ya̱e̱ʼ, hue̱niri̱hueʼ ya̱e̱ʼ,” onaʼnok oʼbatikanpo, bapokhueʼ o̱ʼe̱po kenpaʼti hue̱niri̱hueʼ o̱ʼu̱y. ");
INSERT INTO amrNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","“Kenpihuay. I̱ʼna huabokerek ʼuruaʼda oʼkaʼ. Kentaj bapoka oʼnigpe̱e̱ kenpaʼti e̱ʼpo̱ga̱ oʼnigpe̱e̱.” Huanigpe̱i̱kaʼeria onʼbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jesús e̱ʼpo̱g akodpen oʼbeʼtuy. Ken huadari Gadarabayo o̱ʼe̱. Jesústaj bottaʼ huabokerek onʼhuatiakuy. Huakkaʼada totoʼa oʼmanopoʼtounhuahuaʼnok kubarakbayo o̱ʼnikaʼuyate. Soroke̱yo̱ o̱ʼnikaʼuyate. Huiyokda o̱ʼnikaʼuyate. Huiyokda o̱ʼnenok keʼnenbayo aratbut huahueʼdik o̱ʼnikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","—‍¿Menaʼpo oroʼtaj oʼhuatiak, Jesús? Diosen Huasiʼpo i̱ʼe̱ne. Keneʼhua̱ya̱ʼ castiga huameʼnoe ehued oroʼtaj castiga magkahueʼ moeʼ. —‍ʼUttaʼda Jesústaj oʼnonaʼuy totoʼa. ");
INSERT INTO amrNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Kentaʼda meyo̱hueʼda huakkaʼda huakyariʼ onʼbapeʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","—‍Oroʼtaj eʼmaoro̱kaʼnayo huakyarien huanopoʼyo motaʼmonaʼ. —‍Jesústaj diga̱ʼda oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","—‍Yanhuatiʼ, huakyarien huanopoʼyo yanʼbakud. —‍Jesúsa oʼmanaʼnok, totoʼ botbokerektaj onʼmaenonpo huakyarien huanopoʼyo onʼhuaʼpo onʼbakudʼuy. Ken, ayaʼda huakyariʼ huaduk onʼbahuarakpo kubogyo onʼbaajpo e̱ʼpo̱gyo̱ onʼbataʼkoʼtuyate. Totoʼere onʼbataʼkoʼtuy. ");
INSERT INTO amrNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ken huakyariʼ huamato̱e̱ʼeri kenda onʼtiahuaydepo diga̱ʼda onʼmameʼpukonpo kenomeyen huakkaʼ jakyo onʼbaketʼuyate. Onʼtiakdepo kenda huaboaʼda onʼtiahuaynig onʼbatiaʼpakatoʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ayaʼada huakkaʼ jak hua̱e̱ʼeria onʼpe̱e̱depo Jesúste onʼhuahuaʼuy. Jesústaj onʼhuahuaydepo, “Oroʼenbayaʼ yahuadeʼ.” Jesústaj diga̱ʼda oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ken, Jesús kusiʼpeyo oʼhuadpo akodpen oktegdepo huaen jakyokon oʼtiakuy. ");
INSERT INTO amrNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Jesúste aratbuta asukte huabokerektaj oʼnonpahueda̱ʼpo onʼnigtotiakuyate. Keʼna eʼketpak o̱ʼi̱kaʼuy. Jesúsanayo oʼyareapo oʼnoknopo̱e̱po onʼnigtotiakuy. Kenda Jesúsa oʼnopo̱e̱po. —‍Durugda ya̱e̱ʼ. Ayaʼda Diostaj dakhueaʼ iʼkaʼuyatenigʼa doa yokkahueay. —‍Jesúsa eʼketpaktaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","“Inbokerek namaʼda oʼnopo̱e̱po Diostaj dakhueaʼda oʼhuaaʼ.” Sueʼda Moisésenbaʼ huamanmadikaʼeria huanopoyaʼda onʼnopo̱e̱po. ");
INSERT INTO amrNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Kenda huanopoyaʼda onʼnopo̱e̱nig Jesúsa oʼnopo̱e̱po oʼmanaʼpo: —‍Menpaʼ dakhueaʼda onʼtinopo̱e̱. ");
INSERT INTO amrNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Diostaj dakhueaʼ eʼkaʼ huabokerekada okkahueahueʼdik o̱ʼne. Diosayoʼda dakhueaʼ eʼkaʼ okkahueaʼdik o̱ʼe̱. Huabokerekanayo sigpiʼ yareahueʼdik o̱ʼne. Diosayoʼda yareaʼdik o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Do huabokerek i̱jje̱po Diosyaʼ ijtiakuy. Diostaj dakhueaʼ eʼkaʼ bakkahueaʼdik i̱jje̱y opudtaj kenda aʼmanopo̱e̱a̱yaʼpo, —‍Yaboʼ, asuk yato̱e̱po, o̱ʼnen jakyo yahuatiʼ. —‍Huabokerek eʼketpaktaj Jesúsa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Keʼna oʼboddepo jakyo oʼhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Huakkaʼda aratbut o̱gkupopakpo kenda onʼtiahuaypo onʼmameʼpukpo Diosa oʼtihuapoknok Jesús teyda o̱ʼe̱po konig Diosonigti okkahueaʼdik o̱ʼe̱. Yareaʼdik o̱ʼe̱. ʼUruaʼnanada Dios o̱ʼe̱. Onʼhuaaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ken ke̱ya̱ʼ Jesús oʼtiakuy. Do Mateotaj Jesúsa beʼhuahuayʼuyne. Jaksiʼpoyaʼ gobiernoen huakupe ijtabaeʼikaʼuy. —‍Doʼtaj aʼnigpeunhuahuikayaʼpo betaʼhuikaʼ. —‍Menaʼuynok ijbodpo kenere ijhuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ken jakyo Jesúsere Jesúsen huanigpe̱i̱kaʼeriere ijbapeʼpo huakkaʼada gobiernoen huakupe huatabaeʼeri onʼbakudpo oroʼere onʼbapepo kenpaʼti nogomey Moisésenbaʼ dakaʼ pe̱e̱hueʼ hua̱e̱ʼeri onʼbapeʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Kenda fariseo huamanmadikaʼeria onʼtiahuaypo: —‍¿Menaʼpo Jesúsa gobiernoen huakupe huatabaeʼeriere kenpaʼti dakhueaʼ huakaʼeriere yaʼbapeʼ? Dakhueaʼ huakikaʼeriere bapehueʼdik o̱ʼi̱kaʼne. —‍Fariseoa Jesúsen huanigpe̱i̱kaʼeritaj onʼhuaaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesúsa kenda oʼmape̱e̱depo, —‍Aratbut dakda e̱e̱ʼnayo huamadakkaʼeritaj pakhueʼ o̱ʼnikaʼ. Dakhueʼda e̱e̱ʼnayo huamadakkaʼeritaʼ onʼpakikaʼ. Opud fariseo huamanmadikaʼeri huadakda o̱ʼe̱y moʼnopo̱e̱po doʼtaj pakhueʼ moʼe̱ne. Gobiernoen huakupe huatabaeʼeri kenpaʼti dakhueaʼ huakaʼeriere dakhueʼda o̱ʼne onʼnopo̱e̱po doʼte huamanopoʼyareaʼeri i̱jje̱nok onʼpakpo onʼbatiakikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","“Nog aratbuttaj diʼ yanʼmaepo yanʼmatinepahuikaʼ. Kenda huakkaʼda ijpaki. Doʼtaj ʼuhua eʼnigarakikaʼ kennayo sueʼda ijpaki.” Apagbaʼa oaʼ. Kenda dakaʼ yanʼnopo̱i̱kaʼ. Konige̱po “Yanʼnopoʼkoreaʼ, onteʼti Diostaj yanʼnigpe̱i̱kaʼ.” Dakhueaʼ huakaʼeritaj eʼmanaʼtaj ijpakpo ijtiakuy. Huadak huakaʼeritaj “Yanʼnopoʼkoreaʼ,” aʼmanayaʼpo Diosyaʼ tiakhueʼ i̱jju̱y. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Juan Bautistaen huanigpe̱i̱kaʼeria Jesústaj onʼhuatiakpo: —‍Diosa meʼpe̱e̱ʼpo bapehueʼ o̱ʼi̱kay oroʼ. Fariseo huamanmadikaʼeriakon Diosa meʼpe̱e̱ʼpo bapehueʼ o̱ʼnikaʼ. O̱ʼnen huanigpe̱i̱kaʼerinayo kenpaʼda onʼbapikaʼ. ¿Menaʼpo yanʼbapikaʼ? —‍Jesústaj oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","—‍Huabokerek oʼto̱e̱pakpo keʼnen huadiʼa fiestate onʼtiakdepo onʼbapikaʼ. Ken huabokerekere o̱ʼnepo paiʼda ehueʼdik o̱ʼne. Do kenpaʼti doʼhued huanigpe̱i̱kaʼeriere i̱ji̱kaʼnok durugda o̱ʼnikaʼ. Paiʼda ehueʼ o̱ʼnepo onʼbapikaʼ. Nogok doʼtaj moʼbaktohuaʼapone. Kenokaʼ paiʼda o̱ʼneapo. Nogok nogok Dios kamape̱e̱ʼpo bapehueʼ o̱ʼnikaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Huatoneʼok keʼpoda eʼparaʼte akbetyaʼpo huabo huaoktaj okteghueʼ o̱ʼi̱kay oroʼomey judío aratbut. Huaboenpa huatoneʼoktaj ekbetnayo onteʼti keʼpoda oʼparaʼapo kenpaʼti huabo huaok dakhueʼda o̱ʼe̱a̱po. Konigti adhueaʼpaneʼa̱ eʼmanmadikaʼ huatoneʼdik onteʼti nigpe̱e̱hueʼdik yaneʼ. Doʼhued huabodikyoʼda eʼmanmadikaʼ nigpe̱e̱dik yanikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Huatoneʼsiʼdak vino hua̱to̱e̱ʼ ayda kenpaʼti kuruga̱da o̱ʼe̱po konige̱po huabo vino sineʼ hue̱biahued onjoyhueʼdik o̱ʼe̱ne. Huatoneʼsiʼdakyo huabo vino onjoyhueʼdik o̱ʼi̱kaʼne. Huatoneʼsiʼdakyo huabo vino enjoynayo oʼhue̱poagpo huasiʼdak onʼtitagonapo. Vino oʼsurukapo kenpaʼti huasiʼdak keʼpoda oʼsuʼhuitonapo, dakhueʼda o̱ʼe̱a̱po. Huabo vino huabosiʼdakyo onjoydik o̱ʼe̱ne. Huasiʼdak vinoere huadak o̱ʼneapo. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Juan Bautistaen huanigpe̱i̱kaʼeritaj Jesúsa eʼmanaʼte judío huairia oʼhuatiakpo Jesúsen huaʼite huikudate oʼtisakotpo: —‍Doʼhued hua̱yo̱bu huaboaʼda eʼbueytada on ehuaʼnayo tanoyhuada̱ʼdik i̱ʼe̱ne. Bohuaʼ. Yakutibataʼteʼ, eʼkutibataʼteʼte oʼnoyhuadapo. —‍Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Kenda Jesúsa oʼpeeonpo oʼbodpo kenere oʼhuaʼuy. Oroʼ Jesúsen huanigpe̱i̱kaʼeriere Jesúsere oʼhuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Jesús dagte eʼhuaʼte ettoneʼ huataʼpiyen oʼtatiakpo. Mimi batikhueʼ o̱ʼunhuahuikaʼpo doce huabayok o̱ʼunhuahuikaʼpo, “Jesúsen huaok huakubogpitaʼ eʼnejnayo ijyareapoy.” Huanopoa oʼnopo̱e̱po huaok huakubogpitaʼ o̱ʼneʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Eʼnejdeʼte Jesúsa oʼtikorudpo oʼtiahuaypo: —‍Yadurugpak. Doʼtaj oknopo̱e̱nok oʼyareaddene, sion. —‍Jesúsa onaʼuy. Kenda eadeʼte oʼyareadpo huadakda o̱ʼunhuahuikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Aʼkubarakkaʼdeyaʼpo música huakaʼeri onʼtiakdepo huairien jakyo o̱ʼnedepo kenpaʼti huakkaʼada aratbut onʼbahuik. Jesús oʼtiakdepo oʼbatiahuaydepo: ");
INSERT INTO amrNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","—‍Yanʼmaoro̱k. Ettoneʼsiʼpo bueyhueʼada o̱ʼe̱. Oʼtaypo o̱ʼe̱. —‍Jesúsa oʼmanaʼuy. Aratbuta kenda onʼpe̱e̱po Jesústaj onʼtierikuy. ");
INSERT INTO amrNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jesúsa oʼmaoro̱kaʼdepo oʼkudpo ettoneʼsiʼpobuey eʼhuedyo oʼhuahuaʼpo huabaʼtaj oʼto̱e̱a̱toʼnok oʼnoyhuadonpo oʼbodu̱y. ");
INSERT INTO amrNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Jesúsa judío huairien hua̱yo̱busiʼpotaj oʼnoyhuada̱ʼ aratbuta Capernaum ayaʼbayoda onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesús huairien jakyaʼ oʼbakhuaʼdepo eʼpokte bottaʼ ekpobiga̱ onʼtatiakpo: —‍Moʼtinepahuiʼ, Davidkudaken adhueaʼ huayayo. —‍Jesústaj ʼuttaʼda oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jakyo eʼkudondeʼte ekpobiga̱ onʼhuahuaʼnok —‍¿Doʼa okpoyareaʼdik meʼe̱ne menpaʼ moʼnopo̱e̱? —‍Jesúsa oʼmanaʼuy. —‍E̱e̱ʼ, oknopo̱e̱ne, huairi. —‍Oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ekponejdeʼte: —‍Boʼtiahuayapone moknopo̱e̱nok, yanʼtiahuayʼ. —‍Oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Oʼnokpoyarudpo onʼtiahuayonʼuy. —‍Bokpoyareaʼne, beʼtapiʼ batiaʼpakhueʼ yanetiʼ. —‍Huiyokaʼda oʼmanaʼuynigʼa. ");
INSERT INTO amrNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Oʼnoro̱kondepo, Jesúsa bokpoyareaʼne huabada onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Jesúsomey eʼnoro̱kondeʼte sueʼda nogomeya̱ huabokerektaj onʼtotiakuy. Ken huabokerek aʼpakhueʼda o̱ʼi̱kaʼuy, totoʼa oʼnoʼto̱i̱kaʼnok. Jesúste onʼtotiakuy. ");
INSERT INTO amrNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jesúsa totoʼtaj okenonnok aʼpakhueʼda hua̱e̱ʼeria i̱dada oaʼpakonʼuy. —‍Kenpihuay, Israel aratbut ken konig tiahuayhued o̱ʼneahuadikameʼte. —‍Huakkaʼ aratbut e̱gkupopakte onʼbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","—‍Totoʼ huairia oʼteypakaʼnok totoʼtaj oʼmaen Jesúsa. —‍Fariseo huamanmadikaʼerianayo namaʼda onʼhuaaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Kendariyo ayaʼda huakkaʼ jakyo Jesús oʼhuaeʼuy. Nogyo̱ nogyo̱ oʼhuaeʼuy. Judíoen hua̱i̱takeʼ jakyo oʼmanmadikikaʼuy. Dios Huairia meʼnopoʼto̱i̱keʼpo yanʼnopoʼkoreaʼ. Dios Huairitaj yanoknopo̱e̱ʼ yanʼnigpe̱i̱kaʼ. Diosensiʼpo moʼe̱a̱pone. Oʼmanmadikaʼuy. Eʼdigpaktaj kenpaʼti nogpaʼ nogpaʼ dakhueʼ e̱e̱ʼ enʼto̱e̱ʼtada oʼbayareaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Huakkaʼ aratbut e̱gkupopakte oʼbatiahuaypo oʼmatinepahuiʼuy. Kenomey konig oveja ʼuhua o̱ʼnepo konig huamato̱e̱ʼeri to̱e̱hueʼ o̱ʼnikaʼuy. Paiʼda o̱ʼneonhuahuikaʼpo kate kaʼdik nopo̱e̱hueʼ o̱ʼnepo, kenpaʼti Diostaj buttida manmadikahueʼ o̱ʼnenok kenomeytaj Jesúsa oʼmatinepahuiʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","—‍Huakkaʼada Diosensiʼpo e̱e̱ʼtaʼ eʼpakada Dios Huairitaj eknopo̱e̱ʼtaʼ eʼpakada sueʼada huadak huaʼa huamanmadikaʼeri o̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Konige̱po Diosa huadak huaʼa huamanmadikaʼeritaj yamataʼmonaʼ, Diosa aratbuttaj kamanopoʼyareʼpo yamataʼmonaʼ, Diostaj yanʼtionaʼpakikaʼ. —‍Jesúsa oroʼ huanigpe̱i̱kaʼeriomeytaj monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Oroʼtaj doce huanigpe̱i̱kaʼeritaj, “Menhuatiak.” Jesúsa monaʼuyne. Eʼtiakdeʼte, “Dakhueʼ totoʼa huamanopoʼto̱e̱ʼeritaj kanʼmaoro̱keʼpo onʼteypakapone onʼtihuapokapone. Ayaʼda dakhueʼ e̱e̱ʼ kanʼbayarikeʼpo onʼteypakapone onʼtihuapokapone. Bayareaʼdik moʼe̱a̱pone.” Jesúsa monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jesúsen doce huamataʼmonaʼeri o̱ʼnepo: Simón nogdikda Pedro, Pedroen huamaʼbuy Andrés, nog Jacobo huamaʼbuy Juanere Zebedeoensiʼpo, ");
INSERT INTO amrNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","nog Felipe, Bartoloméere, kenpaʼti Tomás do Mateoere huakupe huabaeʼeri i̱ji̱kamey, kenpaʼti Jacobo Alfeoensiʼpo, Lebeo konogdikda oʼdikkaʼuy Tadeo, ");
INSERT INTO amrNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón cananista jonyo huapakeri, kenpaʼti Judas Iscariote. Judas Iscariote Jesústaj kanʼarakeʼpo judío huairitaj bayokdik o̱ʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesúsa oroʼ doce huanigpe̱i̱kaʼeritaj moʼtaʼmonaʼuyne. —‍Judíoenbayoyoʼda yanhuatiʼ. Nog aratbutenbayo huahueʼ yaneʼ. Samaria aratbuten huakkaʼ jakyo kudhueʼ yanetiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Israel aratbut konig oveja Diostaj eʼtiyoyahueʼtaj yanhuatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Dios Huairi o̱ʼe̱de. Yanoknopo̱e̱po yanʼnigpe̱i̱kaʼ. Nogyo̱ nogyo̱ yanhuaʼepo yanʼmanatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Keʼpoda eʼsiʼdakparaʼtada yanʼbayareatiʼ. Dakhueʼda e̱e̱ʼtada yanʼbayareaʼ. Eʼbueytada yanʼmanoyhuada̱ʼ. Totoʼa eʼmanopoʼto̱e̱tada yanʼmaentiʼ. Katetehueʼ Diosa boʼtihuapokaponok katetehueʼ yanʼbatihuapokikaʼ. “Huakupe beyok,” manahueʼ yanikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Yanʼhuaʼpo oro tohuahueʼ yaneʼ. Huakupe tohuahueʼ yaneʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kutama batohuahueʼ yaneʼ. Nogtida huaok yanʼtohuatiʼ. Huabo zapatos tohuahueʼ yaneʼ. Oteypapiʼ tohuahueʼ yaneʼ. Huakkaʼda moʼmanmadikaʼaponok kenpaʼti moʼbatihuapokapone tobapeʼdik moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Huakkaʼ jakyo boʼkudondepo, “¿Beʼa Diostaj boʼpak? ¿Beʼa Diostaj eʼnigpe̱e̱taʼ boʼpak?” Yanʼmanatiʼ. Beʼa Diostaj yaʼpakapet keʼnen jakyo yanikatiʼ. Yanhuaʼapo ke̱yo̱da yanʼtayikatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Jakyo yanʼkudondepo, “Opudtaj Diosa moʼmanopoʼnoeye̱ʼ.” Yanʼmanaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Jak hua̱ta̱e̱ʼeria opudtaj eʼpaknayo kenpaʼti eʼpe̱e̱nayo Diosa kenomeytaj kamanoeye̱ʼ. Jak hua̱ta̱e̱ʼeria opudtaj pakhueʼ e̱e̱ʼnayo yanokhuatiʼ. Diosa jak hua̱ta̱e̱ʼeritaj manoeya̱hueʼ kamaeʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Jak hua̱ta̱e̱ʼeria opudtaj pakhueʼ e̱e̱ʼnayo kenpaʼti eʼpe̱e̱taʼ pakhueʼ e̱e̱ʼnayo ken jakyaʼ huakkaʼ jakyaʼpiʼ yanʼbakhuatiʼ. Yanʼo̱ro̱kdepo Diostaj dakhueaʼda oʼkaʼdey ayaʼada kanʼnopo̱e̱ʼpo soroka eʼitimabette yanʼitihuekeatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ken jaktaj Diosa diga̱ʼnanada castiga oʼmagkaʼapo. Sodoma huakkaʼ jak hua̱e̱ʼeritaj kenpaʼti Gomorra huakkaʼ jak hua̱e̱ʼeritaj sueʼda huakkaʼ castiga oʼmagkaʼuy. —‍Jesúsa oroʼtaj monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","—‍Opudomeytaj onʼtaʼmonaʼne. Aratbut opudtaj dakhueaʼda eʼmagkaʼtaʼ onʼpakapo. Konig ovejasiʼponig dubakuhuaenbanopoyonig moʼe̱a̱po. Huadakaʼda yanʼnopo̱e̱po ya̱gʼkikatiʼ. ʼUrunopoʼda yanikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Opudomey doʼhued huanigpe̱i̱kaʼeritaj huabokereka dakhueaʼ mogkaʼaponok “keyoj” ijjay. Castiga kanʼmagkeʼpo judío huairite boʼtohuaʼapone. Judíoen hua̱i̱takeʼ jakyo moʼbatibitbitapone. ");
INSERT INTO amrNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Doʼtaj moknopo̱e̱nok nog aratbuten gobierno huairite boʼtohuaʼapone. Diostaj kenpaʼti doʼtaj kanʼmanbatiaʼpakeʼpo huairite boʼtohuaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Gobierno huairitaj eʼyokdeʼte “Katiaʼpiʼ huairitaj yanʼbatiaʼpakapo.” Meʼpukehueʼ yaneʼ. Kenokaʼ aʼdik kaʼneʼpo Diosa moʼnopo̱e̱a̱ʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Huairitaj moʼbatiaʼpakpo Apag Diosen Noki̱re̱ga̱ moʼnopo̱e̱a̱ʼaponok moʼbatiaʼpakapone. ");
INSERT INTO amrNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Nogok oknopo̱e̱hueʼ hua̱e̱ʼeria huaknopo̱e̱ʼeri huamaʼbuytaj kanʼbatiarakeʼpo gobierno huairitaj onʼbayokapo. Kenpaʼti huaoa huasiʼpotaj kanʼbatiarakeʼpo gobierno huairitaj onʼbayokapo. Kenpaʼti huasiʼpoa keʼnen huaoj huaknopo̱e̱ʼeritaj kanʼbatiarakeʼpo gobierno huairitaj onʼbayokapo. ");
INSERT INTO amrNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Doʼtaj moknopo̱e̱nok ayaʼada boʼhuadiayapone. Dakhueʼda mogkadhuahuikaʼapone. Opud batikhueʼda eknopounhuahuikaʼnayo onteʼti Diosere moʼnoeonhuahuikaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Huakkaʼ jakyaʼ opudtaj eʼhuadiaynayo eʼbatiarakataʼ eʼtipakte i̱dada yanʼmakmamontiʼ. Nog huakkaʼ jakyo yanʼbakhuatiʼ. Ke̱ya̱ʼ kenpaʼti eʼhuadiaynayo onteʼti i̱da yanʼbakhuatiʼ. Nog judíoen huakkaʼ jakyo nog judíoen huakkaʼ jakyo eʼhuaʼte konigti dakhueʼda mogkaʼapet. Ayaʼda judíoen huakkaʼ jakyo huaehued eneʼted do Diosen Huairi i̱jje̱po onteʼti ijtiakapoy. ");
INSERT INTO amrNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Opud doʼhued huanigpe̱i̱kaʼeri moʼe̱ne. Doʼtaj dakhueaʼda e̱gkaʼnayo opudtakon dakhueaʼda mogkaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Doʼtaj totoʼ huairia eʼtidikeʼnayo opud doʼhued huanigpe̱i̱kaʼeritakon diga̱ʼda dakhueaʼda boʼhuaaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Aratbuttaj meʼpukhueʼ yanikaʼ. Opudtahuanig Diosen huadak huaʼa oʼnonmadikaʼne. Nogok ayaʼada onʼnokotapo. ");
INSERT INTO amrNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Kenda soatayoʼ oʼnonmadikaʼnig nogok ayaʼtada yanʼmanikatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Huabokereka hua̱so̱ʼtayoʼda barakdik o̱ʼne. Huabokereka noki̱re̱gtaj arakhueʼdik o̱ʼne. Huabokerektaj mididhueʼ yanikaʼ. Diosanayo hua̱so̱ʼtaj noki̱re̱geretaj taʼakyo enʼdik o̱ʼe̱. Onteʼti noyhuadhueʼdikda o̱ʼne. Konige̱po Diostayoʼda yanokmeʼpukikatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Bakoysiʼpotaj aratbuta suhuigda onʼpak. Bottaʼ bakoysiʼpote huasigkupesiʼpo bayokdik o̱ʼe̱. Opuden Apag Diosa eʼpaknayo bakoysiʼpo bueydik o̱ʼe̱. Eʼpaknayo bueyhueʼdik o̱ʼe̱. Opuden Apag Diosa bakoysiʼpotaj dakaʼ oʼmato̱i̱kaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Opudtaj kenpaʼti dakaʼ moʼmato̱i̱kaʼne. Opuden huakuhuijtaj moʼdikikaʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Diosa bakoytaj sueʼda oʼpakpo opudtanayo huakkaʼda boʼpakne. Dakaʼ moʼmato̱i̱kaʼne. Konige̱po aratbuttanayo mididhueʼ yanikatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Do Jesucristotaj huaknopo̱e̱ʼeri i̱jje̱y.” Ayaʼada aratbuttaj eʼmanikaʼnayo Dioste kurudyo̱ enʼtiakte, “Doʼhued huaknopo̱e̱ʼeri o̱ʼne.” Doʼhued Apagtaj yonaʼapoy. ");
INSERT INTO amrNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","“Do Jesucristotaj oknopo̱e̱hueʼ hua̱e̱ʼeri i̱jje̱y.” Ayaʼada beʼapiʼ aratbuttaj eʼikaʼnayo, “Kenomey doʼhued huaknopo̱e̱ʼeri ehueʼ o̱ʼne.” Doʼhued Apag Diostaj kurudya̱ʼ yonaʼapoy. ");
INSERT INTO amrNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Doʼa ayaʼda aratbuttaj aʼmanoeya̱yaʼpo Diosyaʼ oʼtiakuy nopo̱e̱hueʼ yaneʼ. Aratbut nog aratbuttaj aʼpoespakanhuayaʼpo Diosyaʼ ijtiakuy. Nogtaj nogtaj onʼbahuadiayikaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","36","Diosyaʼ ijtiakuynok huabet nog onaratbuttaj huabettaj yanʼmahuadiayikaʼapet. Oknopo̱e̱hueʼ hua̱e̱ʼeria huaknopo̱e̱ʼeritaj yanʼmahuadiayikaʼapet. Huasiʼpo huaojtaj yanʼmahuadiayikapet. Kenpaʼti hua̱yo̱bua hua̱ye̱taj yanʼmahuadiayikaʼapet. Kenpaʼti huakabu huasuʼtaj yanʼmahuadiayikaʼapet. ");
INSERT INTO amrNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Beʼapiʼ doʼtaj eʼnigpe̱i̱kaʼtaʼ eʼpaknayo doʼtaj huakkaʼda diʼnanada meʼnikatiʼ. Apagtapiʼ, hua̱ye̱tapiʼ huasiʼpotapiʼ huamaʼbuytapiʼ huakkaʼda diʼ e̱e̱ʼnayo doʼtaj sueʼda diʼ e̱e̱ʼnayo, doʼhued huaknopo̱e̱ʼeri ehueʼdik o̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","“Jesucristoen huaknopo̱e̱ʼeri i̱jje̱y.” Nog aratbuttaj eʼmanaʼnayo opudtaj diga̱ʼ onʼhuadiaypo mogkaʼapet. “Jesúsen huaknopo̱e̱ʼeri i̱jje̱y.” Aratbuttaj manahueʼ e̱e̱ʼnayo doʼtaj huaknopo̱e̱ʼeri ehueʼdik moʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Doʼhued huaknopo̱e̱ʼeri moʼe̱nok diga̱ʼda mogkadhuahuikaʼapone. “Jesúsen huaknopo̱e̱ʼeri ehueʼ i̱jje̱y.” Enaʼnayo ontaj arakhueʼdik moʼe̱a̱pone. Onteʼti Diosere noeonhuahuikahueʼ moʼe̱a̱pone. Doʼhued huaknopo̱e̱ʼeri i̱ʼe̱nok aratbut diga̱ʼda mogkapone. Batikhueʼda “Jesúsen huaknopo̱e̱ʼeri i̱jje̱y.” Iʼmanaʼikaʼnok eʼaraknayo onteʼti Diosere moʼnoeonhuahuikaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ayaʼada opudomeytaj onʼnigpe̱e̱po boʼikaʼne, doʼtakon meʼdepo onʼnigpe̱i̱kaʼ. Kenpaʼti ayaʼada doʼtakon onʼnigpe̱i̱kaʼpo Apag Diostakon onʼpakpo onʼnigpe̱i̱kaʼapo. Keʼna doʼtaj beʼtaʼmonaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Diosen huamanbatiaʼpakeritaj Diosa oʼmataʼmonaʼikaʼ. Diosen huamanbatiaʼpakeri o̱ʼe̱nok kentaj eʼnigpe̱e̱ʼnayo konig huamanbatiaʼpakeritaj huadakhuapa Diosa oʼbayokapo, ontaj konigti huadakhuapa Diosa moʼbayokapone. Diosenbaʼ ʼuruda huanigpe̱i̱kaʼeritaj eʼdeʼnayo konig kentaj huadakhuapa Diosa oʼyokapo konigti ontaj huadakhuapa Diosa boʼyokapone. ");
INSERT INTO amrNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Huakkaʼ huaknopo̱e̱ʼeri o̱ʼne. Diostaj sueʼdamon huaknopo̱e̱ʼeritaj hue̱ʼe̱ypiʼ eʼyoknayo huadakda boʼkaʼnig Diosa okkahuehueʼdik o̱ʼunhuahuikaʼapo. Nogok kurudya̱ʼ huadakhuapa moʼbaeʼapo. —‍Kenda oroʼomey huanigpe̱i̱kaʼeritaj monmadikahuadu̱y Jesúsa. ");
INSERT INTO amrNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesúsa oroʼtaj keʼnen doce huamataʼmonaʼeritaj monmadikaʼdepo oroʼtaj bokhuaʼuy. Meyo̱hueʼda huakkaʼ jakyo Jesús oʼhuaʼuy. Aʼmanmadikayaʼpo oʼhuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juan Bautista huabakuda̱ʼ jakyo o̱ʼe̱po Cristo oʼbayareaʼpo nogda nogda ʼuruda oʼkikaʼ. Juana kenda oʼtipe̱e̱depo bottaʼ keʼnen huanigpe̱i̱kaʼeritaj Jesúste oʼtaʼmonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","—‍Diosa Cristotaj moʼnigtaʼmonaʼapone. Cristo yaʼtiakapet oknopo̱e̱y. “¿O̱ʼna menpaʼ Cristo i̱ʼe̱? ¿Oroʼomey menpaʼ nogtaj nige̱ʼdik o̱ʼe̱?” Jesústaj ya̱ʼnonatiʼ. —‍Juana monaʼne. Jesúsa Juanen huanigpe̱i̱kaʼeritaj oʼpe̱e̱depo, ");
INSERT INTO amrNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","6","—‍Huakpobigtaj ijbakpoyareay. Huaʼehueʼdik e̱e̱ʼtada ijbayareay. Keʼpoda eʼsiʼdakparaʼtaj ijbayareay. Eʼpeokbettaj ijbayareay. Huakudakaʼda eʼbueytada ijmanoyhuada̱y. Doʼtaj eknopo̱e̱ʼnayo Diosere onteʼti moʼnoeonhuahuikaʼapone. Paiʼda aratbuttaj ijmanikay. Doʼtaj oʼnoknopo̱e̱po okbatikhueʼ o̱ʼnenok kenomeytaj ijmadurugpakaʼapoy. Kenda eʼkaʼte onʼtiahuayonhuaʼnig onʼpeeonhuaʼnig Juantaj yanʼhuahuaʼpo yanʼnonatiʼ. —‍Jesúsa Juanen huanigpe̱i̱kaʼeritaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ken Juan Bautistaen huanigpe̱i̱kaʼeri eʼnokhuadeʼte huakkaʼ aratbut e̱gkupopakte Jesúsa Juantaj oʼtiaʼpakpo: —‍Nogbayo sueʼda aratbut eʼnahue̱ʼyo̱ opudomey boʼhuaʼuyne. Huabokerek nogpaʼ nogpaʼ huaaʼeritaj aʼpe̱e̱yaʼpo huahueʼ moʼu̱yne. ");
INSERT INTO amrNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Huabokerek ʼurunada yudtaj eʼotikaʼte kenda aʼtiahuayaʼpo huahueʼ moʼu̱yne. Aratbut ʼuru yudtaj onʼotikaʼpo konig huairien ʼuru jakyoda o̱ʼnikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Diosen huamanbatiaʼpakeritaj aʼtiahuayaʼpo jakbahueʼyo boʼhuaʼuyne. Diosen huamanbatiaʼpakeri huadakda o̱ʼne. Juannayo nogi̱ti hueretnanada Diosen huamanbatiaʼpakeri o̱ʼi̱kaʼnok. Juantaj aʼtiahuayaʼpo boʼhuaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Doʼtaj katiaʼpakeʼpo huakkuruda Diosa Juantaj oʼtaʼmonaʼuyate. Apagbaʼte kenpaʼ oʼtimadoyaʼpo: Ontaj huakkuruda doʼhued huataʼmonaʼeritaj ijtaʼmonaʼapoy. Dakhueaʼ o̱gkikaʼnok ayaʼtada yamanopoʼkoreaʼ. Diosen Huasiʼpotaj yanoknopo̱e̱ʼ. Aratbuttaj oʼmanaʼapo. Apagbaʼte oʼtimadoyaʼuyate. Kenda Diosa Apagbaʼte menaʼuyne doʼtaj. ");
INSERT INTO amrNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Oyedda ayaʼda huabokerek sueʼda huadak o̱ʼnikaʼ. Juannayo huadaknada o̱ʼe̱. Diosa oknopo̱e̱ʼ. Dios Huairitaj huaknopo̱e̱ʼeri huadaknanada o̱ʼneapo. Diosa kenomeytanayo huakkaʼ oʼbaeretpakikaʼapo. Juantanayo sueʼda oʼpakapo. Ijjay. ");
INSERT INTO amrNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","13","Diosen Huairi o̱ʼe̱a̱po Moisésa Apagbaʼte oʼbatiaʼpakuyate. Kenpaʼti Diosen Huairi o̱ʼe̱a̱po Diosen huamanbatiaʼpakeria Apagbaʼte onʼbatiaʼpakuyate. Juan bautista tiakhued e̱e̱ʼted onʼbatiaʼpakuyate. Juan bautista Diosen Huairitaj huaboaʼda eʼbatiaʼpakdeʼte aratbuta Diosen Huairitaj diga̱ʼda onʼpakikaʼ. Diosensiʼpotaj eʼnigpe̱e̱taʼ onʼpak. Nogomeya̱nayo Diosen Huairitaj onʼhuadiaypo Cristoen huaknopo̱e̱ʼeritaj eknopo̱e̱batikaʼtaʼ onʼpakpo, “Yanʼbatik. Dakhueʼ iaʼne.” Huaknopo̱e̱ʼeritaj onʼmanikaʼnigʼa. ");
INSERT INTO amrNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Eknopo̱e̱ʼtaʼ eʼpaknayo Elías Diosen huamanbatiaʼpakeri o̱ʼe̱ Juan. Diosen Huairi oʼtiakde Elías huakkuru o̱ʼe̱a̱po. Apagbaʼa oaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Kenda yonay dakaʼ yanʼpe̱e̱ʼ boʼpeokhuadne. ");
INSERT INTO amrNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","19","Aratbut oy ken konig o̱ʼnikaʼ ijbatiaʼpakapoy. Kenomeytaj beʼapiʼ madurugpakahueʼdik o̱ʼnikaʼ. Katepiʼ nogomey onʼpakpo o̱gkikaʼnig kenomeynayo konigti eʼkaʼtaʼ pakhueʼ o̱ʼne. Kenda Juan Bautista oʼkikaʼnig kenomeynayo pakhueʼ o̱ʼne. Kenpaʼti do huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne konig do ijkikaʼnig kenda kenpaʼti pakhueʼda o̱ʼne. Juan Bautista katepiʼ ʼuruda aypo bapehueʼ o̱ʼi̱kaʼpo kenpaʼti vino mayhueʼ o̱ʼi̱kaʼpo. Kenda Juana oʼkikaʼnok totoʼa Juantaj oʼnopoʼto̱e̱ kenomeya̱ namaʼda onʼbatiaʼpakikaʼnigʼa. Nogok do huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne opudere katepiʼ ʼuruda aypo ijbapikay kenpaʼti do katepiʼ ijmayʼikay. Doʼtakon dakhueaʼda menhuaikaʼne. “Huakkaʼda oʼbapikaʼ kenpaʼti huakkaʼda huamaiʼeri o̱ʼi̱kaʼ. Kenpaʼti Jesúsa dakhueaʼ huakaʼeritaj diʼda oʼmaikaʼ. Kenpaʼti gobierno huakupe huatabaeʼeritaj diʼda oʼmaikaʼ.” Doʼtaj kenpaʼ menhuaaʼikaʼne. Aratbut oy ken konig o̱ʼnikaʼ nogda ijbatiaʼpakapoy. Katepiʼ nogomey onʼpakpo o̱gkaʼ kenomeynayo konigti eʼkaʼtaʼ pakhueʼ o̱ʼnikaʼ. Konig huasiʼpo onʼbatuerikikaʼnig aratbut oy konigti o̱ʼne. Huasiʼpo huakkaʼ jak kurute onʼbahuadpo onʼbatuerikpo nogtaj nogtaj onʼmanaʼpo “Teteʼpuʼte ʼuruaʼda oʼbatadiʼkeay opudnayo oroʼere eʼdurugpaktaʼ pakhueʼ moʼe̱ne, baila e̱e̱ʼtaʼ pakhueʼ moʼe̱ne. Oroʼ eʼbahuiktada opudnayo huikhueʼ moʼe̱ne.” Ken konig huasiʼpoa ondaʼikaʼ. Ken konig aratbut oyda o̱gkikaʼ. Diosa ʼuruaʼda oʼnopo̱i̱kaʼnok Diostaj huanigpe̱i̱kaʼerinayo ʼuruaʼda onʼnopoenkikaʼpo kenomeyoʼda durugda o̱ʼnikaʼ. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Huakkaʼ jakyo nogyo̱ nogyo̱ Jesúsa oʼbayareaʼuy. Aratbut nopoʼkoreahueʼ o̱ʼnenok Diosa keʼpoda oʼmagkaʼapo. Jesúsa huaboaʼda oʼmanbatiaʼpakapo: ");
INSERT INTO amrNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","23","—‍Huakkaʼ jak Corazín hua̱e̱ʼeria paiʼda moʼnopoʼe̱a̱pone. Kenpaʼti huakkaʼ jak Betsaida hua̱e̱ʼeria paiʼda moʼnopoʼe̱a̱pone. Opudomeyen jakyaʼ Diosa teyda oʼkameʼnigʼa ʼuruaʼda oʼkameʼnigʼa oʼbayareameʼnigʼa, opudomeynayo nopoʼkoreahueʼ moʼe̱meʼne. Konig Betsaida huakkaʼ jakyaʼ kenpaʼti Corazínya̱ʼ Diosa ʼuruaʼda oʼkameʼ kenpaʼti teyda oʼkameʼ konigti Tiro nog aratbuten huakkaʼ jakyaʼ Sidón nog aratbuten huakkaʼ jakyaʼkon Diosa ʼuruaʼda ekaʼnayo kenomeya̱ i̱da yanʼmanopoʼkoreaʼaymetnigʼa kenpaʼti kenomey paiʼda o̱ʼneaʼ aratbuttaj moknopo̱e̱po saconig yanʼotayʼmetnigʼa. Nogok kenokaʼ Diosa ayaʼtada aratbuttaj dakhueaʼ huakaʼeritaj castiga oʼmagkaʼpo Tiro hua̱e̱ʼeritaj Sidón hua̱e̱ʼerieretaj sueʼda castiga oʼmagkaʼapo. Opudomeytanayo keʼpoda castiga mogkaʼapone. Opud Capernaum huakkaʼ jakyo hua̱e̱ʼeri “Huadakda o̱ʼe̱y. Kurudyo̱ oʼhuaʼapoy.” Moʼnopo̱e̱nigʼa. Kubarakyoda bohuapone. Sodoma huakkaʼ jak hua̱e̱ʼeria dakhueaʼda o̱gkikuynok Diosa huakkaʼ jak taʼaka o̱ʼmahui̱gʼuyate. Kenomeytaj mahui̱ghued konig opudtaj ijbayarikay konigti Sodomayo eʼbayarikaʼuynayo Diosa taʼakyo mahui̱ghueʼ ya̱ʼe̱a̱yʼuyetnigʼa. ");
INSERT INTO amrNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nogok Diosa castiga e̱gkaʼte opudtaj keʼpoda mogkapet. Sodomataj sueʼdamon castiga oʼmagkaʼapo. —‍Jesúsa oʼbayareaddepo huakkaʼ jakyo hua̱e̱ʼeritaj huiyokada oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","—‍ʼUruaʼda i̱ʼe̱ne, Apag Dios. Kurudyo̱ hua̱e̱ʼeried huairi i̱ʼe̱ne. Kenpaʼti huadariyo hua̱e̱ʼeried huairi i̱ʼe̱ne, Apag Dios. Suhueʼdamon huanopo̱e̱ʼeritaj ʼurunopoʼtada o̱ʼnen huairitaj iʼmaknopo̱e̱a̱ʼne. Huakkaʼ huanopo̱e̱ʼeritaj o̱ʼnen huairitaj huaknopo̱i̱kaʼ menʼtiokhueyne. ");
INSERT INTO amrNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Iʼpaknok huaknopo̱i̱kaʼ menʼtiokhueyne, kenpaʼti iʼpaknok menoknopo̱e̱ne, Apag. —‍Jesúsa Diostaj oʼtionaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","—‍Doʼhued Apaga̱ beʼteypakaʼuyne, meʼmanopo̱e̱a̱ʼuyne. Ayaʼda beyokuyne. Do Diosen Huasiʼpo o̱ʼe̱, Apag Diosayoʼda moknopo̱e̱a̱ʼne. Konig Apag Dios o̱ʼe̱po, konig oʼnopo̱e̱, konig Apag Dios oʼkaʼ doʼhuayoʼda ijnopo̱e̱y kenpaʼti kenomeytaj doʼhua Diosen Huasiʼpoa ijmaknopo̱e̱a̱y. ");
INSERT INTO amrNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Opud dakhueʼda boʼkikameʼte. Diostaj dakhueaʼ huakeri moʼe̱ne. Dakhueaʼ eʼkaʼ aʼnopoʼyareayaʼpo diga̱ʼda namaʼda boʼkikaʼnigʼa. Opudtaj eʼtihuapoktaʼ ijpaki. Doʼtaj meknopo̱e̱nok onʼnopoʼyareaʼapone. Dakhueaʼ eʼkaʼ onʼbatikaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Diosen ijkikay. Doere bokikaʼ. Doʼtaj menʼnigpe̱i̱kaʼpo nogi̱ti nogi̱ti yanʼnoponhuatiʼ. Opudtehuapaʼ ijhueʼda dakaʼda ijnigi̱kay. Opudtaj ijmatinepahuikaʼnok onteʼti dakhueaʼ kikahueʼdik moʼe̱a̱pone. Onaʼti meʼpukehueʼdik moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Doere boʼpakpo Diostaj oʼnigpe̱e̱ne kenpaʼti onʼtihuapoknok doʼhued eʼmanmadikaʼtaj nigpe̱i̱kaʼdik moʼe̱a̱pone. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Nogok judíoen okmapi̱e̱ʼahuaddik huameʼnoete oroʼ Jesústaj huanigpe̱i̱kaʼeri Jesúsere oʼhuaeʼuy. Taʼbayo oʼhuaeʼuy. Oʼkusitokpo o̱gkupayaʼpo oʼbapeʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Fariseo huamanmadikaʼeri huairia oroʼtaj boʼtiahuaypo Jesústaj: —‍Yatiahuayʼ. Kenda judíoen okmapi̱e̱ʼahuaddik e̱e̱ʼte kikahueʼdik o̱ʼe̱nig o̱ʼnen huanigpe̱i̱kaʼeria o̱gkaʼ. Dakhueaʼda o̱gkaʼ. —‍Fariseo Moisésbaʼtaj namaʼda huaknopo̱e̱ʼeria Jesústaj oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","—‍Apagbaʼte Davidtaj eʼbatiaʼpak moʼbaʼtiahuayʼuyate. David kenere hua̱e̱ʼeri o̱gkusitokuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Diosen carpa jakyo onʼkudonʼuyate. Pan Diostaj oʼnighueda̱ʼikaʼ oʼhuedʼuyate. Sacerdote Diostaj ʼuhua huanigbatiarakeriyoʼda ken pan bapeʼdik o̱ʼnikaʼ. David kenere hua̱e̱ʼeri o̱gkusitokpo ken pan oʼdepo onʼpeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Sacerdote Diostaj ʼuhua huanigbatiarakeritaj Moisésenbaʼ oʼbatiaʼpak moʼbaʼtiahuayde. Judíoen okmapi̱e̱ʼahuaddik e̱e̱ʼte sacerdote ʼuhua Diostaj onʼnigbarakikaʼ. Judíoen okmapi̱e̱ʼahuaddik e̱e̱ʼte baahueʼdik o̱ʼe̱. Moisésa oʼmadoyaʼuyate. Opudomeynayo sacerdote dakhueaʼda o̱gkaʼ bahuaahueʼ moʼi̱kaʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Diosen jak huadakda o̱ʼe̱nigʼa do huabokerek i̱jje̱po Diosyaʼ ijtiakuy. Doʼtataj ayaʼada nigpe̱i̱kaʼdik o̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","“ʼUhua eʼnigbatiarakikaʼ sueʼda ijpaki. Aratbuttaj eʼmatinepahuiataj huakkaʼda ijpaki,” Apagbaʼa oaʼ. Kenda eʼnopo̱e̱ʼnayo doʼhued huanigpe̱i̱kaʼeritaj moʼmatinepahuiʼpo dakhueaʼda o̱gkaʼ ahueʼ moʼe̱a̱yet. ");
INSERT INTO amrNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","—‍Do huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne. Judío aratbuten okmapi̱e̱ʼahuaddik huameʼnoete huairi i̱jje̱po katepiʼ ya̱gkaʼ aratbuttaj manaʼdik i̱ji̱kay. —‍Fariseotaj Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Kenda Jesúsa oʼmanaʼdepo oʼhuaʼuy. Judíoen hua̱i̱takeʼ jakyo oʼkudonʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Jakyo huabokerek ebaʼpoʼketpak o̱ʼu̱y. —‍¿Okmapi̱e̱ʼahuaddik huameʼnoete menpaʼ yareaʼdik ya̱ʼe̱? —‍Jesústaj oʼnonaʼpo Jesúsa namaʼdapiʼ kaeʼpo Jesústaj dakhueʼ eʼhuaaʼtaʼ onʼpakpo kenpaʼ Fariseomeya̱ oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","—‍Opuden nogtida oveja e̱ʼta̱e̱a̱da judíoen okmapi̱e̱ʼahuaddik huameʼnoe e̱e̱ʼpiʼ huabid sorokkogyo̱ eʼtakotnayo dapitaʼ i̱da sorokkogyo̱ boʼtotokikaʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Diosa oveja ʼuhuataj sueʼda oʼpak. Aratbuttanayo huakkaʼda oʼpak. Konige̱po judíoen okmapi̱e̱ʼahuaddik huameʼnoete aratbuttaj tihuapokdik i̱jje̱y. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","—‍Yaopiteʼ. —‍Jesúsa onaʼuy. Huabokerek oʼopitedepo oʼbayaruduy. Dakbaʼda nogbapenonigti o̱ʼunʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Fariseo huamanmadikaʼeri oʼnokbahuaʼuy. O̱gkupopakpo ontatayo onʼbatiaʼpakpo, monig Jesústaj oʼarakapo, huaboaʼda onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Fariseo huairi Jesústaj eʼaraktaʼ onʼpaknok kenok Jesús oʼnokotpo ke̱ya̱ʼ oʼbakhuaʼuy. Kenere huakkaʼda onʼhuaʼuy. Ayaʼda dakhueʼ hua̱e̱ʼeritaj oʼbayareaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Jesúsa oʼbayareaʼ nogyo̱ nogyo̱ batiaʼpakhueʼ yaneʼ. Huiyokaʼda oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Kenda Isaíasa Diosen huamanbatiaʼpakeri oʼbatiaʼpakuyatenig Jesúsa ayaʼ oʼkaʼuy. Oaʼpo: ");
INSERT INTO amrNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","In doʼhued huanabaʼ meʼta̱e̱ne. Doʼhued kakikeʼpo ijtaʼmonaʼapoy. Kentaj diʼ i̱jje̱y. Doʼtaj meʼdurugpakaʼapone. Kentaj ijdurugpakapoy. Doʼhued Noki̱re̱ga̱ ijnopoʼto̱e̱a̱poy. Ayaʼtada nog aratbuttakon dakhueaʼ eʼkaʼ manopoʼyarikaʼdik o̱ʼi̱kaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nog aratbuttaj maboyhueʼ o̱ʼi̱kaʼapo. Aratbuttaj ʼuttaʼda okoyhueʼ o̱ʼe̱a̱po. Jak kurutaʼ ʼuttaʼ manaʼpakhueʼ o̱ʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Konig hue̱ʼpi sueʼpiʼ tey e̱ʼe̱o̱k dakaʼ to̱i̱kaʼdik o̱ʼne, konigti aratbut sueʼda oʼnoknopo̱e̱nok dakaʼ oʼmato̱i̱kaʼapo. Konig kerosenbij ayaʼ ekpakada i̱da bakayhueʼdik o̱ʼe̱. Konigti paiʼda aratbuttaj oʼmanopoʼyareaʼapo. Doʼhued huanabaʼa ayaʼ dakhueaʼ huakaʼeritaj castiga oʼmagkaʼdepo kenpaʼda Diosen huadak huaʼa oʼmananhuahuikaʼapo. Keʼnen huaknopo̱e̱ʼeriomeynayo kenere onʼneonhuahuikaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Nogbayo nogbayo hua̱e̱ʼeria kentaj yanoknopo̱i̱kaʼapet. Isaíasa aʼnenda oaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Totoʼ noki̱re̱ga̱ dakhueʼa oʼnopoʼto̱e̱nok huabokerek botpenpenda ekpobig o̱ʼu̱y kenpaʼti aʼpakhueʼdik o̱ʼu̱y. Jesúste onʼtohuaʼuy. Jesúsa oʼyareaʼnok oʼyarud. Huaboaʼda ʼuruaʼda maboʼdik o̱ʼu̱y kenpaʼti huaboaʼda aʼpakdik o̱ʼu̱y. ");
INSERT INTO amrNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","—‍¡Kenpihuay! Diosa huabokerek huairitaj oʼtaʼmonaʼapo. Kentaj onʼmaboikay. ¿Menpaʼ Diosa Jesústaj yaʼtaʼmonaʼuy? ¿Menpaʼ Jesús David Huairien adhueaʼ huayayo ya̱ʼe̱? —‍Huakkaʼ aratbuta o̱gkupopakpo oʼdaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Fariseo huamanmadikaʼeria onʼpe̱e̱depo, —‍Ehueʼ. Diosa taʼmonahueʼ o̱ʼu̱y. Totoʼ huairia oʼteyyaʼnok Jesúsa totoʼ noki̱re̱gtaj maendik o̱ʼe̱. —‍Fariseoa onʼhuaaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Kenda fariseo enʼhuaaʼte Jesúsa oʼnopo̱e̱po, —‍Ondariyoyoʼ hua̱e̱ʼeri gobierno huairi huayahuaya eʼbarakikaʼnayo gobierno huairi to̱e̱hueʼdik o̱ʼneapo. Onyoyoʼ hua̱e̱ʼeri aratbut eʼbatuktuktaʼ onʼpakpo onʼbakkupopak. Eʼbaraknayo ehueʼdikda o̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Konigti totoʼ huairi huayahuaya eʼmagkaʼnayo aʼti ehueʼdik ya̱ʼneapet. ");
INSERT INTO amrNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Totoʼ huairi doʼtaj oʼteyyaʼnok nog totoʼ noki̱re̱gtaj oʼmaenaʼ. Opud fariseo huamanmadikaʼeria namaʼda onʼhuaaʼne. Opuden huanigpe̱i̱kaʼeria totoʼ noki̱re̱gtaj kanʼmaeneʼpo menpaʼ totoʼ huairia yaʼbateypakaʼpo. Ehueʼ. Namaʼda boaʼne. Opuden huanigpe̱i̱kaʼeria monaʼapone ");
INSERT INTO amrNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Diosen Noki̱re̱ga̱ beʼteyyaʼnok totoʼtaj ijmakenikay. Konige̱po do Diosen Huairi oʼtiakde. Diosa oʼtaʼmonaʼuy. Opudere Diosen Huairi o̱ʼe̱de. Kentaj yanoknopo̱e̱ʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Huabokereka huairien eʼtamaikaʼ ekbakaytaʼ eʼpaknayo baʼtinukuʼdik kenpaʼti itakpiʼtinukuʼdik o̱ʼe̱. Huairitaj eʼtinukudeʼ okbakaydik o̱ʼe̱. Donayo teyda i̱jje̱y. Totoʼ huairitaj tinukuʼdik i̱jje̱y. Totoʼ huairien huanabaʼ maendik i̱jje̱y. ");
INSERT INTO amrNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Beʼapiʼ doʼtaj pakhueʼ e̱e̱ʼnayo konig doʼhued takaʼ moʼi̱kaʼne. Beʼapiʼ doere eʼbaktieʼeaʼtaʼ tihuapokhueʼ e̱e̱ʼnayo doʼhued huaknopo̱e̱ʼeritaj onʼbaknopo̱e̱batikaʼpo dakhueaʼ o̱gkaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Aratbut dakhueaʼda ekaʼnayo kenpaʼti Diostaj dakhueaʼda eʼhuaaʼnayo Diosa bakkahueaʼdik o̱ʼe̱. Diosen Noki̱re̱gtanayo dakhueaʼda eʼhuaaʼnayo bakkahueahueʼdik o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Beʼapiʼ doʼtaj dakhueaʼda eʼhuaaʼnayo Diosa bakkahueaʼdik o̱ʼe̱. Beʼapiʼ Diosen Noki̱re̱gtaj dakhueaʼda eʼhuaaʼnayo bakkahueahueʼdik o̱ʼe̱. Menokapiʼ bakkahueahueʼdik o̱ʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Daknopoda hue̱ymey e̱e̱ʼnayo ʼuru huada oʼto̱i̱kaʼ. Hue̱ymeya̱ eʼaynayo huadakon oʼaypo dakhueʼ huada o̱ʼi̱kaʼ. Huadakdada enhuadnayo ʼuruda o̱hue̱y o̱ʼe̱ oʼnopo̱e̱ne. Do kenpaʼti huadakda ijkikaʼnok huadakda o̱ʼe̱. Yanʼnopo̱e̱ʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Konig bihui aʼnenda namaʼda onaʼuyate, opudkon namaʼda huaaʼeri moʼe̱ne. Opud dakhueaʼ hua̱e̱ʼeri moʼe̱po huadak sigpiʼ ahueʼdik moʼi̱kaʼne. Katepiʼ huanopoyaʼda oʼnopo̱e̱po kenda oʼbatiaʼpakikaʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Huabokerek huadaknopoʼda o̱ʼnepo huadakda onʼnopo̱i̱kaʼpo huadakyoʼ onʼbatiaʼpakikaʼ. Huabokerek dakhueʼnopoʼda o̱ʼnepo dakhueʼda onʼnopo̱i̱kaʼpo dakhueayoʼ onʼbatiaʼpakikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Keneʼhua̱ya̱ʼmeʼnoete Diosen castiga huameʼnoete ayaʼda dakhueʼdik o̱daʼikaʼuynigtaj castiga oʼmagkaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Huadakyoʼ huaaʼeritaj “Huadakda moʼe̱ne.” Diosa monaʼapet. Dakhueaʼ huaaʼeritaj “Dakhueʼda moʼe̱ne.” Diosa monaʼapet, ken. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","—‍On Diosyaʼ oʼtiakuyate. Kenda oroʼomeya̱ oknopo̱e̱ʼdik kaʼneʼpo konig Dios teyda oʼkikaʼ konigti yakaʼ, huamanmadikaʼeri. —‍Sueʼda Moisésenbaʼ huamadoyaʼeria kenpaʼti fariseo huamanmadikaʼeria oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","—‍Oy aratbut dakhueaʼda o̱ʼnikaʼ. Diostaj oknopo̱i̱kay o̱danigʼa Diostaj nigpe̱e̱hueʼda o̱ʼne. Konig Dios teyda oʼkikaʼ konigti yakaʼ oʼnonaʼnigʼa kahueʼ i̱jje̱a̱poy. Kenyoʼda konig Jonás Diosen huamanbatiaʼpakeria oʼkuyate sueʼda konigtimon ijkaʼapoy. ");
INSERT INTO amrNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonás bapaʼmeʼnoe bapaʼ sikyo sikidbiʼdapoyo o̱ʼunhuaʼuyate konigti do bapaʼmeʼnoe bapaʼ sikyoere sorokkogyo̱ i̱jje̱a̱poy. ");
INSERT INTO amrNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","42","Aʼnennada huakkaʼ jak Nínive hua̱e̱ʼeritaj Jonás Diosen huaʼa eʼmanadeʼte Nínive aratbut Diostaj onʼnopoʼkoreaʼpo huaboaʼda Diostaj onʼnigpe̱e̱ʼuyate. Oy aratbut doʼtaj moʼpe̱e̱denigʼa nopoʼkoreahueʼ moʼe̱po doʼtaj oknopo̱e̱hueʼ moʼe̱ne. Jonás sueʼda huairi o̱ʼu̱yate. Donayo hueretda huairi i̱jje̱y. Konige̱po keneʼhua̱ya̱ʼmeʼnoete ayaʼda Diostaj eʼnigbakupobote opudomey oy hua̱e̱ʼeri dakhueaʼda o̱gkikaʼuyate. Nínive hua̱e̱ʼeria kenda Diostaj onʼbahuaaʼapo. Aʼnennada huadaribayo ettoneʼa̱ huairi o̱ʼu̱yate. Keʼnenba bidtenada o̱ʼu̱yate. Salomón Israel aratbuten huairi huakkaʼnada oʼnopo̱e̱po ʼuruaʼda oʼbatiaʼpakikaʼnok aʼpe̱e̱yaʼpo ken ettoneʼ keʼnenbayaʼ bidtaʼnada oʼtiakonhuahuaʼuyate. Israel aratbutenbayo oʼtiakonhuahuaʼuyate. Salomónnayo sueʼda ʼuruaʼdamon oʼnopo̱e̱ʼuyate. Donayo ʼuruaʼnanada ijnopo̱e̱po huadakaʼda ijmanmadikikaʼnigʼa oy hua̱e̱ʼeria sueʼada doʼtaj moʼpe̱e̱po oʼnoknopo̱e̱ne. Konige̱po nogok keneʼhua̱ya̱ʼmeʼnoete ayaʼda Diostaj enʼnigbakupoboʼte opudomey doʼtaj oknopo̱e̱hueʼ hua̱e̱ʼeri Diostaj dakhueʼnada o̱ʼne ettoneʼ huairia Diostaj oʼbahuaaʼapo. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","—‍Dakhueʼ totoʼ noki̱re̱g huabokerektaj eʼnopoʼtoeonhuahuaʼdeʼ okhuaʼdepo aratbut ehueʼ e̱e̱ʼyo̱ oʼhuaʼpo meyo̱piʼ hua̱i̱kaʼ eʼuktada huahuayhueʼda o̱ʼe̱po. ");
INSERT INTO amrNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Ke̱yo̱ i̱ji̱kamey aʼkumeyi̱ʼ.” Kenpaʼ noki̱re̱ga̱ oʼnopo̱e̱po, ken huabokerektaj oʼnopoʼto̱i̱kameʼ, kentaj e̱kye̱deʼte Diosapiʼ nopoʼto̱e̱hueʼda daknopoʼda konig jak eʼberokeʼyonig ʼuruaʼda o̱ʼe̱nok ");
INSERT INTO amrNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ken totoʼa oʼhuaʼpo nog siete dakhueʼnanadakon noki̱re̱gtaj oʼbahuahuaydepo oʼbatotiakpo ken ontayoʼ huabokerektaj onʼnopoʼto̱e̱nok. Huakkuruda nogtotoatida oʼnopoʼto̱e̱po sueʼda dakhueʼmon o̱ʼe̱po taʼpotaʼtaj ochoa dakhueaʼnanada totoʼ onʼnopoʼto̱e̱denok huabokerek dakhueaʼnanada o̱ʼe̱ʼuy. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús eʼbatiaʼpakonhuaʼte Jesúsen hua̱ye̱ Jesúsen huamaʼbuyere oʼnokye̱depo onʼboatoʼpo, “Jesústaj eʼbatiaʼpaktaʼ oʼpaki.” Huabokerektaj oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","—‍I̱yo̱ jak kurute o̱ʼnen hua̱ye̱ o̱ʼnen huamaʼbuyere boʼukne. Ontaj eʼbatiaʼpaktaʼ onʼpak. —‍Huabokereka Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","—‍Be doʼhued hua̱ye̱ ya̱ʼe̱t. Be doʼhued huamaʼbuy ya̱ʼnet. —‍Jesúsa oʼmanaʼpo, ");
INSERT INTO amrNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","huanigpe̱i̱kaʼeritaj oʼbaʼtohuaʼeaʼpo: —‍Inomey doʼhued hua̱ye̱ doʼhued huamaʼbuy o̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ayaʼada kenda doʼhued Apag kurudyo̱ hua̱e̱ʼeri oʼpaknok o̱gkikaʼ kenomeyyoʼda doʼhued huamaʼbuy o̱ʼne. Kenomey Diosen o̱gkikaʼ doʼhued huidpo o̱ʼne, kenomey Diosen o̱gkikaʼ doʼhued hua̱ye̱ o̱ʼne. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Kenmeʼnoe Jesús o̱ʼo̱ro̱kpo e̱ʼpo̱gyo̱ oʼhuaʼpo aktaʼbogpete oʼhuadʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Huakkaʼada aratbut Jesústaj onʼtikupopaknok kusiʼpe eʼbetyo oʼhuadatoʼpo. Aratbut kuhuadte o̱gkupopakuy. ");
INSERT INTO amrNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Konig Diosen Huairitaj yanoknopo̱e̱a̱pet aʼmanmadikayaʼpo oʼmanbatiaʼpakonhuaʼpo: —‍Huabakidenaʼeri aʼbakidenayaʼpo oʼhuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nogyon nogyon oʼhuaʼeʼuyate. Oʼhuaʼepo oʼbakideneaʼpo dagte sueʼda oʼkidbakotapo bakoy oʼbatiakpo oʼkidye̱ʼkeaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Huidbate sorok burujte sueʼda oʼkidbakoʼtuyate. Kentaʼ i̱dada oʼkerekuy. Sorok buruj o̱ʼe̱po i̱dada oʼkerekuy. ");
INSERT INTO amrNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ken diga̱ʼ niokpo oʼtaʼtedepo eyyaʼ oʼpakpo suhueʼda huaʼihuit o̱ʼe̱po oʼayʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Nog huakid okpotaʼpidsiʼbayo oʼkidbakoʼtuyate. Huakpi sueʼda oʼbatipakbonigʼa okpotaʼpidsiʼ diga̱ʼ oʼbakerekpo huakpitaj oʼbatibukʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Nog huakid huadak sorokteda oʼkidbakoteaʼuyate. Oʼbatipakbodepo huakkaʼkida̱da o̱gkupahuadʼuyate. Noga̱ huakpia cien huakid o̱gkupa̱e̱po. Noga̱ huakpia sesenta huakid o̱gkupa̱e̱po. Noga̱ treinta huakid o̱gkupa̱e̱ʼuyate, ken. ");
INSERT INTO amrNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Kenda oʼnonaʼdene dakaʼ yanʼpe̱e̱ʼ. Boʼpeokhuadne. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Oroʼ Jesúsen huanigpe̱i̱kaʼeri oʼhuatiakpo: —‍¿Menaʼpo aratbuttaj nopoenkahueʼdik e̱ʼhua̱e̱ʼ jonbatiaʼpak? —‍Jesústaj onaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","—‍Diosen Huakhuairitaj konig aratbuta onʼnigpe̱i̱kaʼapo opudtanayokon konig eʼmanopo̱e̱a̱ʼtaʼ ijpaki. Nogomeytaj eʼmanopo̱e̱a̱ʼtaʼ pakhueʼ i̱jje̱y. ");
INSERT INTO amrNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kenomey sueʼda huakkaʼ onʼnopo̱e̱po eʼnigpe̱i̱kaʼtaʼ onʼpakpo nogda onʼnopo̱e̱a̱po. Nogomey suhuigda onʼnopo̱e̱nigʼa nogda eʼnopo̱e̱taʼ pakhueʼ o̱ʼnenok Diosa oʼbakkahueaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nogomey eʼtiahuayada eʼpe̱e̱a̱da nopoenkahueʼdik e̱ʼhua̱e̱ʼ Diosen huakhuairi konig o̱ʼe̱ ijmanbatiaʼpakpo ijmanmadikikay. ");
INSERT INTO amrNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Isaías Diosen huamanbatiaʼpakeria nopoenkahueʼ hua̱e̱ʼeri konig o̱ʼnikaʼ oʼbatiaʼpakuyate: Opuda̱da moʼpe̱e̱a̱petnigʼa nopo̱gkahueʼ moʼe̱a̱pet. Kenpaʼti boʼtiahuayapetnigʼa nopo̱gkahueʼ moʼe̱a̱pet. ");
INSERT INTO amrNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nopoʼteyda moʼe̱po. Diosendiktaj dakhueaʼda moʼpe̱e̱a̱pet. Konig ekposikonig ya̱ʼnepo hueretda huaʼa tiahuayhueʼdik ya̱ʼneapet. Pe̱e̱hueʼ ya̱ʼneapet. Nopo̱gkahueʼ ya̱ʼneapet. Kenpaʼti aʼnopoʼyareayaʼpo nopoʼkoreahueʼ moʼe̱a̱pet. Kenda Isaíasa oaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Opudnayo doʼhued huanigpe̱i̱kaʼerianayo onʼtiahuayne onʼpe̱e̱ne. Konige̱po durugda moʼi̱kaʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Aʼnenda Diosen huamanbatiaʼpakeria kenpaʼti huadaknopoada aratbut doʼtaj eʼtiahuaytaʼ eʼpakada tiahuayhueʼdik meʼnuyate kenpaʼti doʼhued eʼmanmadikaʼtaj eʼpe̱e̱taʼ eʼpakada pe̱e̱hueʼ o̱ʼnuyate. Buttida ijjay. —‍Jesúsa oroʼtaj monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","—‍Yanʼpe̱e̱ʼ. Huabakidenaʼeri konig o̱ʼe̱ dakaʼ ijbatiaʼpakapoy. ");
INSERT INTO amrNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Huabakidenaʼeria oʼbakidenaʼpo dagte oʼkidbakot. Diosen Huakhuairitaj huadak huaʼa konig huakid o̱ʼe̱. Sueʼada aratbut konig dag o̱ʼne. Teynopoʼda o̱ʼne. Diostaj eʼnigpe̱e̱taʼ pakhueʼ o̱ʼne. Doʼhued eʼmanmadikaʼ eʼpe̱e̱a̱da nopoenkahueʼ o̱ʼne. Totoʼ oʼbahuatiakpo huadak huaʼataj oʼbakkayikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Sueʼda huidbate oʼkidbakot. Sorok burujda o̱ʼe̱. Ken konig aratbut doʼhued eʼmanmadikaʼtaj onʼpe̱e̱po i̱dada oʼnoknopo̱e̱nigʼa durugda onʼpe̱e̱a̱tunigʼa kenpaʼda nigpeonhuahuahueʼ o̱ʼnepo sueʼda oʼnopoenkaʼpo. Sueʼda huameʼnoe oʼnoknopoeonhuaʼ. Nogok Jesúsen eʼmanmadikaʼtaj yoknopo̱e̱y oʼdaʼnok aratbuta onʼbatierikpo diga̱ʼ onʼmagkaʼnok oʼnoknopo̱e̱batikapo. ");
INSERT INTO amrNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","23","Huakid okpotaʼpidsiʼbayo oʼkidbakoʼtuyate. Ken konig aratbut Diosen eʼmanmadikaʼtaj onʼpe̱e̱po onʼpe̱e̱nigʼa nogok nogtaʼ nogtaʼ onʼmameʼpukepo onteʼti sig sig Diostaj oʼnoknopo̱e̱batikapo. Kenpaʼti huakkaʼ eʼmato̱e̱ʼtaʼ onʼpakpo sig sig Diostaj oʼnoknopo̱e̱batikapo. Kenpaʼti hua̱ʼenda eʼdurugpaktaʼ onʼpakikaʼpo onteʼti Diostaj pakhueʼ o̱ʼneapo, nigpe̱e̱hueʼ o̱ʼneapo. Diosen kahueʼdik o̱ʼneapo. Ken huakid huadak sorokyo oʼkidbakoʼtuyate. Ken konig aratbut huadaknopoʼda Diosbaʼtaj onʼpeeonhuahuikaʼpo onʼnigpeeonhuahuikaʼ. Dakaʼ konig ʼurunopoʼda onʼnigpe̱e̱po batikhueʼda huadakda o̱gkikaʼapo. Kenomey Diosensiʼpo o̱ʼne, huakkaʼada onʼnopo̱e̱a̱po. Noga̱ suhuignada onʼnigpe̱i̱kaʼ. Noga̱ huakkaʼmon onʼnigpe̱i̱kaʼ. Noga̱ huakkaʼnanada onʼnigpe̱i̱kaʼ. —‍Jesúsa oroʼ huanigpe̱i̱kaʼeritaj monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Huadak huaʼa konig Dios Huairitaj oʼnoknopo̱e̱a̱ponigtaj onʼnigpe̱e̱a̱ponigtaj ken konig o̱ʼe̱a̱po Jesúsa onteʼti oʼmanbatiaʼpakpo oʼmanmadikaʼpo: —‍Diosen Huakhuairi in konig o̱ʼe̱. Huairien huanabaʼ taʼbayo huadakkidda oʼbatukeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ayaʼada enʼbatayte huairien takaʼ taʼbayo oʼtiakbedpo trigotaj mire̱okda oʼnoktibatukbedʼuyate. Oʼnoktibatukbedpo onʼhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ken trigo huakpi oʼkerekdepo trigokid oʼmagkupapaʼkuyate. Mire̱ trigoere oʼbakerekuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Huanabaʼ mire̱ onʼtiahuaydepo huairite onʼhuaʼpo, “Huadakkidyoʼ oʼbatuʼkemey. ¿Meyo̱ eeʼ mire̱ yaʼbo, huairi?” Oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Takaa o̱gkameʼte.” Huairia onaʼnok, “¿Menpaʼ eʼtaburutaʼ iʼpak?” Huanabaʼa huairitaj oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Kejeʼ, mire̱ moʼburupo trigo huakpitaj tionurudikpiʼ moʼe̱t. Trigoere mire̱ere kenpaʼda ka̱e̱ʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","O̱gkupayeaʼhued e̱e̱ʼted onteteyoʼ kenpaʼda ka̱e̱ʼ. Huakkuru aʼbakpakayaʼpo mire̱ yanʼburupo yanʼkupahuiaʼ, trigokidnayo aypo jakyo ya̱gʼkuda̱tiʼ. Ijmanaʼapoy.” Huairia oaʼuyate. —‍Jesúsa ken konig oʼmanbatiaʼpakpo oʼmanmadikaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Huadak huaʼa konig Dios Huairitaj oʼnoknopo̱e̱a̱ponigtaj onʼnigpe̱e̱a̱ponigtaj ken konig o̱ʼe̱a̱po oʼmanbatiaʼpakpo oʼmanmadikaʼpo: —‍Diosen Huakhuairi konig suhuigkidda mostaza huakid o̱ʼe̱. Huabokerek keʼnen taʼbayo mostaza huakidsiʼpo oʼtukpo. ");
INSERT INTO amrNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Suhuigkida̱da eʼkerekpo hue̱ymeytoneaʼ oʼkerekdepo huaboroʼnanada o̱ʼe̱a̱po. Huaʼopite huakkaʼ bakoya onʼpakkaʼapo. Konigti huakkuruda Dios Huairien huaknopo̱e̱ʼeri sueʼda o̱ʼne. Nogok huakkaʼada Dios Huairitaj oʼnoknopo̱e̱po onʼnigpeonhuahuikaʼpo huakkaʼda o̱ʼneapo. —‍Jesúsa ken konig oʼmanbatiaʼpakpo oʼmanmadikaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Onaʼti aʼmanmadikayaʼpo Jesúsa oʼmanbatiaʼpakpo: —‍Ettoneʼa̱ harinao̱gyo̱ huabiaʼo̱g oʼbuk. ʼUruaʼda oʼti̱o̱gkuayaga̱ʼnok huabada oʼkudapo. Ayaʼda oʼbiaʼapo. Ken konig Diosen Huakhuairitaj huabada yanoknopo̱e̱a̱pet. —‍Jesúsa ken konig oʼmanbatiaʼpakpo oʼmanmadikaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Huakkaʼ aratbut e̱gkupopakte konig Dios Huairitaj yanʼnigpeunhuahuikaʼapet nogda nogda oʼmanbatiaʼpakikaʼpo oʼmanmadikaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Diosen huamanbatiaʼpakeria oaʼuyatenok aratbut e̱gkupopakte Jesúsa ken konig o̱ʼunhuahuikaʼapo oʼmanbatiaʼpakikaʼuy. Huadari eʼkaʼdetada kenda aratbut nopo̱e̱hued o̱ʼnunhuahuikaʼuy, kenda kanʼnopo̱e̱ʼpo, ken konig o̱ʼe̱a̱po ijmanbatiaʼpakpo ijmanmadikaʼapoy. Diosen huamanbatiaʼpakeria aʼnenda oaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Huakkaʼ aratbut e̱gkupopakte Jesúsa oʼbakhuaʼpo jakyo oʼkudonʼuy. Oroʼ keʼnen huanigpe̱i̱kaʼeria oʼhuatiakondepo, —‍Trigo mire̱ere taʼbayo onteteyoʼ oʼbakerek ken konig iʼmanbatiaʼpaknig dakaʼ monaʼ. —‍Oroʼ Jesúsen huanigpe̱i̱kaʼeria onaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","—‍Do huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne. Ken konig ijmanbatiaʼpaknig. Huairien taʼba o̱ʼta̱e̱po huadakkidda eʼbatukeʼ. Ken huairi do i̱jje̱y. ");
INSERT INTO amrNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Huadarite hua̱e̱ʼeri aratbut konig huairien taʼba o̱ʼne. Aratbut doʼtaj moʼnigpe̱i̱kaʼnig konig huadakkidda o̱ʼne. Aratbut totoʼtaj onʼnigpe̱i̱kaʼnig konig mire̱ o̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Takaʼ mire̱ huabakbatukeʼeri konig totoʼ huairida o̱ʼne. Totoʼada namaʼda oʼmanopo̱e̱a̱ʼnok Cristoen huaknopo̱e̱ʼeri o̱ʼe̱y namaʼda yaʼmanopo̱e̱a̱ʼapet. Nogok keneʼhua̱ya̱ʼ huameʼnoete Diosen huataʼmoneri ayaʼtada oʼbakbaeaʼapet ");
INSERT INTO amrNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Konig aratbut tajpo mire̱ onʼbakpakikaʼnig konigti keneʼhua̱ya̱ʼ huameʼnoe e̱e̱ʼte Diosa dakhueaʼ huakkaʼeritaj huehueaʼnanada taʼakyo oʼmahui̱gapo. ");
INSERT INTO amrNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Do Diosen huataʼmoneritaj ijmataʼmonaʼapoy. Ayaʼda dakhueaʼ huakaʼeritaj onʼbakbeʼeaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Dakhueaʼ huakkaʼeritaj taʼakyo onʼmaenaponok onʼbahuikonhuahuikaʼapo paiʼnanada o̱ʼneonhuahuikaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kenokaʼ Diostaj huanigpe̱i̱kaʼeri ʼuruaʼnanada o̱ʼneapo. Konig niokpo eʼtaʼteonig ʼuruaʼnanada o̱ʼneapo. Kenda oʼnonaʼnig dakaʼ yanʼpe̱i̱katiʼ. Boʼpiokhuadne. ");
INSERT INTO amrNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Huadak huaʼa konig Dios Huairitaj oʼnoknopo̱e̱a̱ponigtaj onʼnigpe̱e̱a̱ponigtaj konig e̱ʼdik o̱ʼe̱a̱po ijmanbatiaʼpakapoy. Konig huabokereka nogen taʼbayo huakkaʼte huapaʼda o̱ʼi̱kaʼnig oʼhuahuaypo kenda huakkaʼda oʼpakpo soroka oʼtibukanpo. Ken taʼba huakupete eʼbakeʼnayo kenda oʼhuahuaymeʼnig o̱ʼtaeonhuahuikaʼapo. Konige̱po ken taʼba eʼbaketaʼ huakkaʼ oʼpakpo ayaʼda oʼmato̱e̱ huakupete oʼbahuayaʼpo, ken huakupe oʼto̱e̱depo taʼba huakupete durugteda oʼbakepo. Kenda ʼurunanada oʼhuahuaymeʼnig huaboaʼda o̱ʼtaeonhuahuikaʼapo. Konigti Diosen huakhuairitaj huakkaʼda pakdik o̱ʼnepo kentayoʼda nigpe̱i̱kaʼdik o̱ʼneonhuahuikaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","46","Diosen Huakhuairien eʼmanmadikaʼ onʼnigpeeonhuahuikaʼaponigtaj konig o̱ʼe̱ ijbatiaʼpaki. Konig yudtaj huabahuayaʼeria ʼuruda sakbij oʼukikaʼpo ʼurunanada oʼhuahuaydepo kenda sakbijtaj oʼpakpo ayaʼda oʼmato̱e̱po huakupete oʼbahuayaʼpo sakbij oʼbake. Ken konigti Diosen Huakhuairien eʼmanmadikaʼ huakkaʼnada pakdik o̱ʼneonhuahuikaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Dios Huairien huaknopo̱e̱ʼeri ken konig o̱ʼne. Konig biig huakjenea e̱ʼpo̱gya̱ʼ oʼnoke̱ne. Nogda nogda biig oʼnontotokpo ");
INSERT INTO amrNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","hueda̱ʼda o̱ʼe̱nok kuhuadtaʼ oʼnontotok, oʼnontotokdepo huadak biigyo̱ʼ oʼnoktieʼeaʼ. Nogda biig pehueʼdik e̱ʼhua̱e̱ʼ o̱ʼnen. ");
INSERT INTO amrNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Diosen keneʼhua̱ya̱ʼ huameʼnoete ken konig Diosa aratbuttaj oʼmagkaʼapo. Diostaj hueretda huaknopo̱e̱ʼeritaj Diosen huataʼmoneria onʼbaktieʼeaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Dakhueaʼ huakkaʼeritaj taʼakyo onʼmaenapo. Taʼakyo paiʼda o̱ʼnepo onʼbahuikapo. —‍Jesúsa monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","—‍¿Menpaʼ oʼnonbatiaʼpaknig moʼnopoenkaʼ? —‍Jesúsa oroʼtaj keʼnen huanigpe̱i̱kaʼeritaj monaʼuyne. —‍E̱e̱ʼ, oʼnopoenkay. —‍Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","—‍Opud Moisésenbaʼ huamanmadikaʼeri Moisésenbaʼtaj dakaʼ moʼnopo̱e̱. Kenpaʼti Diosen huamanbatiaʼpakerienbaʼ moʼnopo̱e̱. Oy Diosen Huairitaj ijmanmadikaʼnig opud moknopo̱e̱dene. Huatoneʼbaʼ kenpaʼti doʼhued huaboda eʼmanmadikaʼ manmadikaʼdik moʼe̱ne. Konig jak hua̱ta̱e̱ʼeri ken konig ya̱gʼkikatiʼ. Jak hua̱ta̱e̱ʼeria paiʼda hua̱e̱ʼeritaj onʼbatiahuayikaʼ. Jakyo katepiʼ o̱ʼta̱e̱ huatoneʼpiʼ huabopi oʼbatotiakpo paiʼda hua̱e̱ʼeritaj oʼbayokikaʼ. Opud konigti ya̱gʼkikaʼ. Apagbaʼ huatoneʼbaʼ doʼhued huaboaʼda eʼmanmadikaʼere yanʼmanmadikikatiʼ. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Kenokaʼ Jesúsa ken konig oʼmanmadikandepo oʼbatikuy. Ke̱ya̱ʼ onʼbakhuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Hua̱ʼenbayokon o̱kye̱ʼuy. Judíoen hua̱i̱takeʼ jakyo huaboaʼda oʼmanmadikaʼuy. Aratbut onʼpe̱e̱depo eʼmeʼpukeada oknopo̱e̱hueʼ o̱ʼnepo: —‍¡Kenpihuay! ʼUruaʼda oʼnopo̱e̱. Menpapiʼ huakkaʼda yanopo̱e̱ʼ. Menpapiʼ yabayareaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Huamenhueaʼeriensiʼpo o̱ʼe̱nigʼa. Keʼnen hua̱ye̱ María o̱ʼe̱. Jacobo keʼnen huamaʼbuy o̱ʼe̱, José Simón Judas. ");
INSERT INTO amrNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Jesúsen huidpopiʼ oroʼere o̱ʼnikaʼ, meya̱ʼ huakkaʼ yaʼnopu̱yet. —‍Aratbut Jesúsen huakkaʼ jakyo hua̱e̱ʼeri huayahuaya onʼbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Konige̱po Jesústaj digda onʼhuanopo̱e̱ʼuy. —‍Ayaʼda nogbayo nogbayo hua̱e̱ʼeria Diosen huamanbatiaʼpakeritaj eʼpe̱e̱taʼ onʼpakikaʼ. Kenpaʼti huadakda o̱ʼne. Eʼbahuaaʼtaʼ onʼpakikaʼ. Keʼnenbayo hua̱e̱ʼerinayo eʼpe̱e̱taʼ pakhueʼ o̱ʼnikaʼ kenpaʼti Diosen huamanbatiaʼpakeri huadak o̱ʼne. Eʼbahuaaʼtaʼ pakhueʼ o̱ʼne. —‍Jesúsa keʼnenbayo hua̱e̱ʼeritaj oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ke̱ya̱ʼ aratbut Jesústaj oknopo̱e̱hueʼ o̱ʼnenok sueʼtada oʼbayareaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","12","Galilea huadari gobierno huairi Herodes o̱ʼu̱yate. Herodesen huamaʼbuy Felipeen hua̱to̱e̱ Herodíastaj oʼto̱e̱ʼuyate. —‍Felipeen hua̱to̱e̱ Herodíastaj to̱e̱hueʼdik i̱ʼe̱ne. —‍Juana Herodestaj onaʼikaʼnok Herodes Juantaj oʼtitaʼmonaʼuyate. “Huabakuda̱ʼ jakyo ya̱gʼkuda̱ʼ.” Oʼmanaʼuyate. Herodes Juantaj eʼaraktaʼ oʼpaknigʼa arakhueʼ o̱ʼu̱yate. Aratbuttaj oʼmeʼpukpo Juantaj arakhueʼ o̱ʼu̱yate. Juan Bautista Diosen huamanbatiaʼpakeri o̱ʼe̱. Aratbuta oʼnoknopo̱e̱nok. Herodesen cumpleañote huakkaʼtada oʼbatobapeʼuyate. Ayaʼtada Herodíasen hua̱yo̱bua baileaʼ oʼmanige̱ʼuy. Herodes huakkaʼda oʼdurugpakpo “Ayaʼda katepiʼ on iʼpak menatiʼ kenda oʼyokapone.” Ayaʼda enʼpe̱e̱te hua̱yo̱butaj onaʼuy. Muneʼyo̱a̱ Herodías hua̱ye̱taj oʼhuahuatupo. “¿Kaʼtiaʼ yonaʼapo?” Onatupo. “Juan Bautistaen huaku beyok.” Yanatiʼ. Muneʼyoen hua̱ye̱a̱ onaʼuyate. Herodeste oʼkumej. “Baegte Juan Bautistaen huaku beyok.” Herodestaj onaʼuy. Herodes kenda oʼpe̱e̱depo paiʼda eʼnopoʼe̱a̱da “Ayaʼda katepiʼ on iʼpak menatiʼ kenda ijyokapoy.” Ayaʼada huabokerek onʼpe̱e̱nok sorotatataj “Huabakuda̱ʼ jakyo yanhuatiʼ, Juantaj yanhue̱renokteg. Ya̱gʼkutotiak. Herodíasen hua̱yo̱butaj yanʼyok.” Huairia oʼmanaʼuyate. Sorotataj onʼnigpe̱e̱po huaku onʼtotiakpo Herodesen hua̱yo̱butaj onʼyokuyate. Keʼna hua̱ye̱taj oʼkutohuaʼpo oʼkuyokuyate. Aʼtimon Juan Bautistaen huanigpe̱i̱kaʼeri onʼtiakpo huabuey onʼtohuaʼuy. O̱gkubarakkaʼuyate. O̱gkubarakkaʼdepo Jesústaj onʼhuaʼpo Juantaj onʼhue̱renokteg oʼnonbatiaʼpakatoʼuy. Nogok Jesús ʼuruaʼda oʼkikaʼnok Herodes huairia oʼtipe̱e̱depo: —‍Ken Juan Bautista o̱ʼe̱taj. Huakudakaʼda e̱e̱ʼtada Diosa oʼnoyhuada̱meʼte. Konige̱po ʼuruaʼda oʼkikaʼte. —‍Kenda namaʼda oʼnopo̱e̱po oaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Juan Bautista eʼbueydeʼte Jesúsa oʼpe̱e̱depo ke̱ya̱ʼ oʼbakhuaʼuy. Kusiʼpete oʼhuaʼuy. Kente aratbut ehueʼ e̱ʼnikaʼyo oʼhuaʼuy. Jesús oʼhuaʼde onʼtipe̱e̱po huakkaʼda jakyaʼ oʼnoro̱konpo aktaʼbogpeaʼ onʼtahuaʼeʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Kusiʼpe oʼbetatodepo Jesúsa oʼkutuy. Oʼkutdepo huakkaʼda aratbuttaj oʼbatiahuayʼuy. Oʼmatinepahuiʼpo dakhueʼ e̱ʼneʼtaj oʼbayareaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Huaboaʼ eʼsikonyakte oroʼ Jesúsen huanigpe̱i̱kaʼeria Jesústaj oʼhuahuaʼpo, —‍Oʼsikde. I̱yo̱ aratbut ehueʼ o̱ʼne. Huakkaʼ jakyo aypo kanʼbaeʼpo yamataʼmonaʼ. —‍Oroʼa Jesústaj onaʼuynigʼa. ");
INSERT INTO amrNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","—‍Huahueʼdik o̱ʼne. Opuda̱ aypo yanʼbayok. —‍Jesúsa oroʼtaj monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","—‍Ehueʼ to̱e̱hueʼda o̱ʼe̱y. Huabaniga̱ʼ pan bottaʼ biigyo̱ʼda oʼto̱e̱y. —‍Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—‍I̱yo̱ doʼtaj menigtotiak. —‍Jesúsa monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","“Mire̱bate yanʼbahuad.” Huakkaʼda aratbuttaj Jesúsa oʼmanaʼdepo, huabaniga̱ʼ pan bottaʼ biigere oʼbapadpo kurudyo̱ oʼmabopo Diostaj dakiti oʼtionaʼpakuy. Dakiti oaʼdepo pannopote oʼposakeaʼuy. Oroʼ keʼnen huanigpe̱i̱kaʼeritaj boʼyokeʼuyne. Oroʼ huakkaʼ aratbuttaj oʼbayokeʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ayaʼada onʼbapeʼpo noteyyaʼ o̱gkaʼuy. Onʼtiokayonpo doce kusogyo̱ hueda̱ʼda huataʼsuj onʼdohueaʼuy. Huaboroʼ huaenmo boroʼtaʼsujmonere onʼdohueaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Cinco mil huabokerek onʼbapeʼuy. Ettoneʼ huasiʼpobetaʼ kenpaʼti onʼbapeʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","“Huakkuru kusiʼpete yanʼkudpo yanoktegtiʼ.” Jesúsa oroʼtaj monaʼuyne. Enadeʼte huakkaʼ aratbuttaj jakyoda oʼmataʼmonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Oʼmataʼmonaʼdepo oteʼyo oʼbehuikuyate. Diostaj aʼtionaʼpakyaʼpo oʼbehuikuyate. Osikdenok Jesúsyoʼda o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kenok oroʼ e̱ʼpo̱gnopoyo o̱ʼu̱y. Diga̱ʼda oʼbapokpo kusiʼpete monbosakaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Sikyoedda Jesúsa hua̱hue̱tiudte boʼhuatiakuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Jesús hua̱hue̱tiudte oroʼ oʼtiahuaypo oʼmeʼpukonʼuy. —‍Noki̱re̱g o̱ʼe̱. —‍Oʼmeʼpukonpo oʼokoyʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","—‍Meʼpukhueʼ yaneʼ. Do i̱jje̱y. —‍Jesúsa monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","—‍O̱ʼna e̱e̱ʼnayo doʼtaj yatiak. Menaʼ Huairi. —‍Pedroa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—‍Yatiak. —‍Jesúsa onaʼnok Pedro oʼkotpo Jesústaj hua̱hue̱tiudte oʼhuahuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Hua̱hue̱tiudte oʼhuahuaʼpo eʼhuahuada diga̱ʼda oʼbapok oʼnokotpo oʼmeʼpukonʼuy. Oʼmeʼpukonpo huaboaʼda oʼtaʼkotaypo. —‍Beʼtotok, Huairi, ijtaʼkotdey. —‍Pedroa Jesústaj oʼnokoyʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Jesúsa Pedrotaj oʼbaʼtotokpo, —‍¿Menaʼpo suhuigda meknopo̱e̱ʼ doʼtaj? Hua̱hue̱tiudte iʼhuatiakpo beʼtihuapokapone menaʼpo oknopo̱e̱hueʼ o̱ʼe̱. —‍Onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Jesús Pedroere kusiʼpeyo enʼhuaddeʼte bapoka oʼbatikonʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Oroʼ huikudate oʼhuadpo, —‍Kenpihuay, on buttida i̱ʼe̱ Diosen Huasiʼpo. Kurudya̱ʼ iʼtiakuyate. —‍Oroʼa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","E̱ʼpo̱gtoneʼ oktegdepo Genesaret huadaribayo oʼbetdepo o̱kye̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Enʼkotdeʼte Jesús o̱ʼe̱ aratbuta oʼnoki̱e̱ʼdepo ayaʼtada huabada onʼmanaʼuy. Ayaʼda dakhueʼ e̱ʼhua̱e̱ʼ Jesúste onʼmanpatotiakuy. ");
INSERT INTO amrNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","“O̱ʼnen huaok huakubogpi aʼneya̱ʼpo,” Jesústaj diga̱ʼ oʼnonaʼnok ayaʼada onʼnejdepo Diosa oʼbayareadʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nogok sueʼda judío hua̱e̱ʼeri huairi Jesústaj onʼhuatiakuy. Jerusalén huakkaʼ jakyaʼ onʼhuatiakuy. Jesústaj oʼnonaʼpo: ");
INSERT INTO amrNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—‍Aʼnenda oroʼen adhueaʼpaneʼ huairi huadaknopoʼ oroʼen Diosa moknopo̱e̱po bapehued onʼbaʼkoyoʼikaʼuyate. Menaʼpo kenda o̱ʼnen huanigpe̱i̱kaʼeria nigpe̱e̱hueʼada baʼkoyohueʼada yanʼbapeʼikaʼ. —‍Judío huairia Jesústaj oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","—‍Konig opuden adhueaʼpaneʼ o̱gkikaʼuyate opuda̱kon aʼkikayaʼpo Apag Diostaj nigpe̱e̱hueʼ moʼi̱kaʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","“Opuden huaojtaj hua̱ye̱tere nigpe̱i̱kaʼdik moʼe̱ne kenpaʼti tihuapokikaʼdik moʼe̱ne.” Diosa oaʼuyate. Kenpaʼti “Huaojtaj hua̱ye̱tapiʼ beʼapiʼ dakhueaʼ eʼhuaaʼikaʼnayo bueydik moʼe̱ne.” Diosa oaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","“Huaojtaj hua̱ye̱tere oyda tihuapokhueʼdik o̱ʼnene kenpaʼti bayokonhuahueʼdik o̱ʼnene. Diostaj ayaʼda moʼtamaikaʼnigtaj oʼbayokdeʼuy.” Beʼapiʼ huaojta hua̱ye̱tapiʼ aʼdik o̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ken konig huaojta hua̱ye̱tapiʼ eaʼnayo tihuapokhueʼdik o̱ʼneapo. Opuda̱ moʼmanmadikikaʼne. Konig adhueaʼpaneʼ namaʼda onʼmanmadikikaʼuyatenig opuda̱ namaʼda moʼmanmadikikaʼnok aratbuta Diostaj nigpe̱e̱hueʼdik o̱ʼnikaʼapo. Boʼikaʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Opud namaʼda huanopo̱e̱ʼeri moʼi̱kaʼne. Isaías Diosen huamanbatiaʼpakeria aʼnenda ʼuruaʼda boʼtimadoyaʼuyate opudtaj: ");
INSERT INTO amrNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","In aratbuta Diostaj oʼpaki namaʼda oʼdikaʼnigʼa doʼtaj huanopoyaʼda eretpakhueʼ o̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Namaʼda doʼtaj dakiti moʼtionaʼpakikaʼne. Huabokerekada eʼhuaaʼyoʼda onʼmanmadikikaʼnigʼa. Isaíasa oʼmanigmadoyaʼuyate. —‍Jesúsa judío huairitaj oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","11","—‍I̱yon yanʼbatiak. —‍Jesúsa huakkaʼ aratbuttaj oʼmanaʼdepo, —‍Katepiʼ eʼpeʼpiʼ konig Diostaj dakhueaʼ eʼkaʼ ehueʼdik o̱ʼe̱. Kenda dakhueʼdik eaʼnayo konig da eaʼ Diostaj dakhueaʼ eʼkaʼ e̱ʼdik o̱ʼe̱. In oʼnonaʼnig yanʼpe̱e̱ʼ kenpaʼti yanʼnopoenkaʼ. —‍Jesúsa huakkaʼtada oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kenokaʼ oroʼ Jesúsen huanigpe̱i̱kaʼeria Jesústaj oʼbahuahuaʼpo, —‍Fariseo huamanmadikaʼeri ontaj moʼpe̱e̱po boʼhuadiayne. ¿Menpaʼ iʼnopo̱e̱? —‍Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","—‍Konig huakpi doʼhued Apaga̱ konig batukehueʼda sueʼda huamanmadikaʼeria konigti o̱ʼne. Huakpi doʼhued Apag batukehueʼtaj oʼbauruaʼpo oʼmaenapo. Konigti nogenda huamanmadikaʼeritaj oʼmaenapo. ");
INSERT INTO amrNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Fariseo huamanmadikaʼeritaj mepuʼkehueʼ yaneʼ. Kenomey namaʼda oʼnoknopo̱e̱po namaʼda onʼmanmadikikaʼnigʼa. Konig ekpobigtaj eʼtohuanig o̱ʼne. Kenomey kenpaʼti konig ekpobig o̱ʼne. Fariseo ekpobigyoʼ eʼhuaʼenayo huabidkogyo kotdik ya̱ʼneapet. —‍Jesúsa oroʼtaj monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","—‍Katepiʼ boʼpeʼpo konig Diostaj dakhueaʼ eʼkaʼ ehueʼdik o̱ʼe̱. Iaʼnig. Nopoenkahueʼ o̱ʼe̱nok dakaʼ monaʼ. —‍Pedroa Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","—‍Menpaʼ opud kenpaʼti nopoenkahueʼ moʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Moʼbapeʼpo huaʼaypoyo oʼkudikaʼ. Huaminya̱ʼkon o̱ʼo̱ro̱kikaʼ. Kenda Diostaj dakhueaʼ eʼkaʼ ehueʼdik o̱ʼe̱. Kenpaʼ moʼnopo̱e̱. ");
INSERT INTO amrNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Dakhueʼda eaʼnayo huanopoʼada iʼnopo̱e̱po iaʼ. Diostaj dakhueaʼda i̱ʼe̱ne Diosa oʼnopo̱e̱. ");
INSERT INTO amrNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Aratbut huanopoyaʼda onʼpakpo dakhueaʼda o̱gkikaʼ. Huanopoyaʼ onʼhuadiaypo onʼbarakikaʼ. Huanopoyaʼ onʼeretpakpo nogen hua̱to̱e̱ onʼbakdejikaʼ. Huanopoyaʼ onʼpakpo hua̱to̱e̱ to̱e̱hueʼ hua̱e̱ʼeri onʼbakdejikaʼ. Huanopoyaʼ onʼpakpo onʼbereʼikaʼ. Huanopoyaʼ onʼeretpakpo namaʼda onʼmahui̱a̱ʼikaʼ. Huanopoyaʼ onʼpakpoda onʼmahui̱a̱ʼikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Kenpaʼ o̱gkikaʼpo dakhueʼda o̱ʼne Diosa oʼnopo̱e̱. Baʼkoyohueʼada eʼbapeʼnayo “dakhueaʼ iʼkaʼ,” Diosa manahueʼ o̱ʼe̱. —‍Jesúsa monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ke̱ya̱ʼ Jesús oʼhuaʼpo Tiro huakkaʼ jakyo kenpaʼti Sidón huakkaʼ jak huadaribayo oʼhuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ettoneʼ judío aratbut ehueʼ ke̱yo̱ o̱ʼi̱kaʼ. Cananea hua̱e̱ʼeri o̱ʼu̱y. Jesústaj oʼhuahuaʼpo, —‍Doʼtaj meʼtinepahuiʼpo beʼtihuapok. Doʼhued hua̱yo̱buʼtaj totoʼa oʼnopoʼto̱e̱po dakhueʼnanada o̱ʼe̱, Huairi. On Daviden huayayo i̱ʼe̱ne. —‍Ettoneʼa̱ Jesústaj ʼuttaʼda onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesúsanayo sigpiʼ aʼtokhueʼ o̱ʼu̱y. —‍Ettoneʼtaj yataʼmonaʼ. Konige̱po oroʼtaj botaʼtiakpo ʼuttaʼda oʼokoyʼonyak. —‍Oroʼ huanigpe̱i̱kaʼeria Jesústaj diga̱ʼda onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","—‍Judío aratbuttaj kabatihuapokeʼpo Diosa meʼtaʼmonaʼuyne. Judío aratbut konig oveja eʼtitikononig Diostaj nigpe̱i̱kahueʼ o̱ʼne. Nog aratbuttaj judío ehueʼtaj Diosa taʼmonahueʼ meʼu̱yne. —‍Jesúsa oaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ken ettoneʼnayo Jesústaj oʼhuahuaʼpo huaʼikudate oʼtihuadatoʼpo, —‍Beʼtihuapok, Huairi. —‍Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","—‍Konig huasiʼpoen aypo kuhuataj eʼyok dakhueʼda o̱ʼe̱. Konigti judío aratbuttayoʼda tihuapokdik i̱jje̱y. Nog aratbuttaj tihuapokhueʼdik i̱jje̱y. —‍Jesúsa ettoneʼtaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","—‍Buttida iaʼne. Kuhuanayo huasiʼpoen eʼtaʼsujkahuaʼ onʼbapikaʼ, Huairi. —‍Ettoneʼa̱ Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","—‍Huakkaʼda doʼtaj iknopo̱e̱nok. Kenda onaʼnok oʼtayareaʼne, ettoneʼ. —‍Jesúsa onaʼuy. Kenpaʼ eaʼte ettoneʼen hua̱yo̱bu oʼyarudʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ke̱ya̱ʼ Jesús oʼhuaʼpo Galilea e̱ʼpo̱g aktaʼbogpete oʼhuaʼeʼuy, Nogok oteʼyo oʼbehuikdepo oʼhuaduy. ");
INSERT INTO amrNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kentaj huamojtaʼpo so̱doda, ekpobig, aʼpakhueʼdik aratbut, kenpaʼti huakkaʼ dakhueʼ nogpaʼ nogpaʼ e̱e̱ʼ onʼbatotiakpo Jesústaj huakkaʼda onʼhuatiakuy. Onʼbatotiaknok Jesúsa oʼbayareaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","—‍Kenpihuay. Aʼpakhueʼa aratbuta huaboaʼda onʼaʼpak. Huamojtaʼpo so̱doda huaboaʼda ʼuruda onʼhuaʼe. Huakpobiga̱ huaboaʼda onʼtiahuay. —‍Onʼbatiaʼpakpo, “ʼUruaʼda o̱ʼe̱ Israelen Dios. Dakiti Dios.” Huaboaʼda onʼbatadiʼkeaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Oroʼ huanigpe̱i̱kaʼeritaj boʼkupopakaʼdepo monaʼpo: —‍I̱yo̱da huakkaʼnada boʼkupopakmeʼne. Bapaʼmeʼnoeaʼ o̱ʼnedepo aypobayoʼ kate bapehueʼdikda o̱ʼnenok ijmatinepahuiʼpo bapehued enʼbahuaʼnayo jakyo o̱kye̱hued dagtaʼ a̱ro̱gdik o̱ʼnenok eʼmataʼmonaʼtaʼ pakhueʼ i̱jje̱y. —‍Jesúsa monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","—‍I̱yo̱ aratbut ehueʼ o̱ʼnikaʼ. ¿Meyo̱ aypo oʼeyapet? —‍Oroʼa Jesúsen huanigpe̱i̱kaʼeria Jesústaj oʼnonaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","—‍¿Meniga̱ʼ pan moʼta̱e̱? —‍Jesúsa monaʼuyne oroʼtaj. —‍Siete pan sueʼda biigere moʼta̱e̱ne. —‍Oroʼa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","—‍Barakte yanʼbahuad. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Siete pan sueʼda biigere oʼbapadpo, “Dakiti Dios. Dakaʼ jokaʼne.” Oʼtionaʼpakpo oʼposakeaʼpo oroʼtaj keʼnen huanigpe̱i̱kaʼeritaj boʼyokeʼuyne. Oroʼa huakkaʼda aratbuttaj oʼbayokeʼuy. Ayaʼtada oʼbayokeʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ayaʼada onʼbapeʼuy. Noteymeyaʼda o̱gkaʼuy. Siete kusogyo̱ huaboroʼpe̱gda boroʼtaʼsujmonere onʼdohueaʼuy. Huedmeya̱ʼda onʼdohueaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Cuatro mil huabokerek onʼbapeʼuy. Ettoneʼ huasiʼpoere kenpaʼti o̱ʼnuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Kenokaʼ “Opuden jakyo yanʼhuatiʼ.” Jesúsa huakkaʼda aratbuttaj oʼmanaʼuy. Oʼmanaʼdepo kusiʼpete Magdalabayo oʼhuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Judío aratbut huairia Jesústaj onʼhuatiakuy. Jesúsa namaʼda katepiʼ yakaʼapetpiʼ onʼnopo̱e̱po, “Katepiʼ konig Diosayoʼda kurudya̱ʼ kaʼdik oroʼ tiahuayhueʼ o̱ʼi̱kaʼuynig kakeʼpo.” Judío huairia Jesústaj onʼdikdikpo oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","—‍Baysik kurudbed boʼtiahuaypo “Emeʼte ʼuruʼbada o̱ʼe̱a̱po.” Opuda̱ boaʼikaʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Sikyoedda kurudbed e̱e̱ʼnayo kenpaʼti diga̱ʼda e̱ʼsi̱hui̱ʼ e̱e̱ʼnayo “Dakhueʼbada o̱ʼe̱a̱po.” Opuda̱ boaʼikaʼne. Opud huadakda o̱ʼe̱y huataʼda namaʼda moʼtinopo̱i̱kaʼne. Dakhueʼda moʼe̱ne. Kurud huadakda moʼnopo̱i̱kaʼnigʼa Diosa oʼtaʼmonaʼuy, oknopo̱e̱hueʼ o̱ʼnene. ");
INSERT INTO amrNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","In judío aratbut dakhueʼnada o̱ʼnikaʼ. Diostaj oknopo̱e̱hueʼda o̱ʼnikaʼ. “Katepiʼ kurudyo̱ konig Diosayoʼda kaʼdik oroʼ tiahuayhueʼ o̱ʼi̱kaʼuynig yakaʼ.” Namaʼda oʼnonaʼne. Kenpaʼda konig Jonás oʼnoyhuadu̱yate do konigti ijnoyhuada̱poy, ijjay. —‍Jesúsa oʼmanaʼpo oʼbakhuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Kenokaʼ oroʼ Jesúsen huanigpe̱i̱kaʼeri e̱ʼpo̱g akodpen oktegpo pan okkahuudi̱. ");
INSERT INTO amrNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","—‍E̱ya̱ʼ, judío huairien eʼbiaʼo̱gtaj keyoj ijjay. —‍Jesúsa oroʼtaj monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","—‍Pan okkahuudnok kenda monaʼne. —‍Oroʼa huayahuaya oʼbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Kenda oroʼa oʼbatiaʼpaknig Jesúsa oʼnopo̱e̱po, —‍¿Menpaʼ aypotaʼ moʼmepuke? Doʼhua dakaʼ to̱e̱dik o̱ʼnene. Suhuigda doʼtaj oʼnoknopo̱e̱ne. ");
INSERT INTO amrNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Opuda̱ doʼtaj nopo̱e̱hueʼ o̱ʼnene. Cinco mil huabokerektaj cinco pan ijmanigposakeaʼuy. Ayaʼda noteyaʼ onʼbapemeʼ. Menpaʼ kenda bokkahueʼ. Doce kusogyo̱ huedmeya̱ʼda oʼdohueaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Kenpaʼti cuatro mil aratbuttaj siete pan sueʼda biigere ijmanposakeaʼmey. Noteymeyaʼda onʼbapemeʼ. Siete kusogyo̱ huataʼsuj huedmeya̱ʼda oʼdohueameʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","“E̱ya̱ʼ, judío huairien eʼbiaʼo̱gtaj keyoj.” Huaboaʼda oʼnonaʼdene. Pantaj oʼbatiaʼpak namaʼda moʼnopo̱e̱ne. Judío huairien eʼbiaʼo̱gtaj keyoj oʼnonaʼne kenti. —‍Jesúsa oroʼtaj monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Jesúsa nog konig monbatiaʼpaknig huaboaʼda oʼnokoti. Pan eʼbiaʼo̱gtaj batiaʼpakhueʼ o̱ʼe̱. Judío huairia dakhueʼdiken onʼmanmadikaʼikaʼ. Kenomeytaj keyoj. Kenda Jesúsa oʼbatiaʼpaknig oʼnopoenkaʼuy oroʼa. ");
INSERT INTO amrNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nogok Jesús Cesarea Filipo huadaribayo o̱kye̱depo oroʼ keʼnen huanigpe̱i̱kaʼeritaj monaʼpo: —‍¿Be o̱ʼe̱a̱ʼ doʼtaj aratbuta menhuaaʼikaʼ? —‍Oroʼtaj monaʼuy Jesúsa. ");
INSERT INTO amrNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","—‍Juan Bautista on o̱ʼe̱. Noga̱ boʼhuaaʼikaʼne. On Elías o̱ʼe̱. Noga̱ boʼhuaaʼikaʼne. On Jeremías o̱ʼe̱. Noga̱ boʼhuaaʼikaʼne. Diosen huamanbatiaʼpakeripiʼ o̱ʼe̱. Nogomeya̱ boʼhuaaʼikaʼne. —‍Oroʼa Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","—‍¿Be o̱ʼe̱a̱ʼ doʼtaj opuda̱ onʼhuaaʼikaʼ? —‍Oroʼtaj monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","—‍On Diosen Cristo i̱ʼe̱ne. Diosen Huasiʼpo i̱ʼe̱nok Diosa meʼtaʼmonaʼuyne. —‍Pedroa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","—‍Kenda onaʼne aratbuta onahueʼtada onaʼne. Apag Dios kurudyo̱ hua̱e̱ʼeria menʼnopo̱e̱a̱ʼne, Simón Jonásensiʼpo. Konige̱po durugda i̱ʼi̱kaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","O̱ʼnendik Pedro o̱ʼe̱. Pedro huidtoneʼdik o̱ʼe̱. On konig huakkuruda huaknopo̱e̱ʼeria judíotaj nog aratbuttaere moʼmanbatiaʼpakapone. Ken ayaʼda ijkikaʼnig moʼmanbatiaʼpakikaʼapone. Huakkaʼada doʼtaj oʼnoknopo̱e̱a̱po. Huakkaʼtada Diosa oʼbaktieʼeaʼapo. Kenomeytaj totoʼa kenpaʼda engaña magkahueʼdik o̱ʼe̱a̱po. Doʼhua onaʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","On Pedro moʼmanbatiaʼpaknok aratbut Diosen Huairitaj huaboaʼda onʼnigpe̱e̱a̱po Diosensiʼpo o̱ʼneapo. Katepiʼ aratbut dakhueʼ kahueʼdik e̱ʼhua̱e̱ʼ manmadikikaʼdik i̱ʼe̱a̱pone. Katepiʼ huadakyoʼ kaʼdik e̱ʼhua̱e̱ʼ manmadikikaʼdik i̱ʼe̱a̱pone. —‍Jesúsa Pedrotaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","—‍“Cristo o̱ʼe̱. Diosa oʼtaʼmonaʼuy.” Beʼtapiʼ manahueʼ yaneʼ. —‍Oroʼtaj monaʼuyne Jesúsa. ");
INSERT INTO amrNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","“Jerusalén gobierno huairien huakkaʼ jakyo huaʼdik i̱jje̱y. Ke̱yo̱ judío huairitoneʼ sacerdote huairiere Moisésen eʼmanaʼbaʼ huamanmadikaʼeriere doʼtaj paiʼda meʼnogkaʼapone. Doʼtaj menʼarakapone. Bapaʼmeʼnoe eʼpokdeʼte Diosa meʼnoyhuada̱ʼapone.” Kenokaʼ Jesúsa huaboaʼda kenpaʼ monbatiaʼpakuyne. Oroʼtaj monbatiaʼpakuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","—‍Kenpaʼ ahueʼ ya̱e̱ʼ, Huairi. Dios kenpaʼ pakhueʼ o̱ʼe̱. Konig o̱gkahueʼdik moʼe̱a̱pone. —‍Pedroa adyon oʼtohuaʼdepo Jesústaj onaʼuynigʼa. ");
INSERT INTO amrNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesúsa Pedrotaj oʼtikoretupo, —‍Yahuatiʼ. Konig totoniga̱ onaʼne. Namaʼda menaʼne. Konig huabokerekada namaʼda onʼnopo̱i̱kaʼnig o̱ʼna konigti iʼnopo̱i̱kaʼ. Diosen eʼnopo̱e̱ʼ nopo̱e̱hueʼda i̱ʼe̱ne. —‍Pedrotaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","—‍Bepiʼ doʼtaj eʼnigpe̱i̱kaʼtaʼ eʼpaknayo katepiʼ hua̱ʼenda onʼpakikaʼ onaʼti eretpakhueʼ kaʼnikeʼ. Onaʼti doʼhuedyoʼda kanʼpakikeʼ. Kenpaʼti doʼtaj moknopo̱i̱kaʼpo paiʼda nopoʼe̱dik moʼe̱a̱pet. ");
INSERT INTO amrNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kenpaʼda hua̱ʼenda eʼpaknayo Cristoere kurudyo̱ onteʼti noeonhuahuahueʼ o̱ʼnikaʼapo. Kenomey kenpaʼda hua̱ʼenda pakhueʼ o̱ʼnepo, Diostayoʼda eʼnigpe̱i̱kaʼtaʼ huakkaʼ onʼpakpo onteʼti Diosere kenpaʼda onʼnoeonhuahuikaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ayaʼada oy katetapiʼ huakkaʼtaʼda onʼeretpakpo onʼbaeʼikaʼpo doʼtaj eʼnigpe̱e̱taʼ pakhueʼ o̱ʼnepo kenpaʼda onʼbueyapo. Kurudyo̱ Diosere noeonhuahuikahueʼdik o̱ʼneapo. ");
INSERT INTO amrNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Do huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne. Diosen huataʼmoneriere nogok kurudya̱ʼ ijtiakapoy. Konig Apag Dios ʼuruaʼda o̱ʼe̱ konigti i̱jje̱a̱poy. Konig Apag Dios huairitoneʼ o̱ʼi̱kaʼ konigti i̱ji̱kaʼapoy. Konig dakaʼ onʼnigpe̱i̱kaʼnigtaj huakkaʼ dakhuapa ijbayokapoy. Sueʼda onʼnigpe̱i̱kaʼnigtaj sueʼda ijbayokapoy. ");
INSERT INTO amrNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Sueʼda opud i̱yo̱ doere moʼe̱nig bueyhued e̱e̱ʼte huakkaʼada Dios Huairitaj moknopo̱i̱kaʼnigtaj moʼnigpe̱i̱kaʼnigtaj moʼbatiahuayapet. —‍Jesúsa monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Seis huameʼnoe eʼpokdeʼte Pedrotaj Jacobotaere Jacoboen huamaʼbuy Juantaere oʼbatohuaʼpo huakupa kutayo Jesúsa oʼbatobehuikuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Kenomey onʼtiahuaypo Jesúsen huakok konig niokpo oʼkokeypakuyate. Yudtakon diga̱ʼda oʼtakeregpakatupo konig senogda o̱ʼe̱tuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Moiséskudak Elíaseretaj Jesús enʼbatiaʼpakte Pedromeya̱ onʼbatiahuayʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","—‍Oroʼ i̱yo̱da o̱ʼe̱po huadakda o̱ʼe̱ne. O̱ʼna eʼpaknayo bapaʼ bak oʼkayʼ. Ontehuapaʼ nogtida Moiséstaj nogtida kenpaʼti Elíastaj nogtida oʼkayʼ, Huairi. —‍Pedroa Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedroa kenpaʼ enadeʼte senogada e̱ʼsi̱hui̱a̱ oʼbatibukʼuyate. E̱ʼsi̱hui̱ya̱ʼ onʼpe̱e̱po, —‍In doʼhued Huasiʼpo meʼta̱e̱ne. Huadiʼda meʼta̱e̱ne. Kentaj huakkaʼda ijdurugpakikay. Kentaj yanʼnigpe̱i̱kaʼ. —‍Diosa e̱ʼsi̱hui̱ya̱ʼ oaʼnok onʼpe̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kenda onʼpe̱e̱po konig gobierno huairitaj o̱gkikaʼnig Diostaj okkubukaʼ huakkaʼda onʼmeʼpukpo onʼbahuedonʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ken Jesúsa Pedromeytaj oʼbahuahuaʼpo oʼtibataʼtepo, —‍Yanboʼ. Meʼpukhueʼ yaneʼ. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Onaʼti enʼtiahuayte Jesústayoʼda onʼtiahuayʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Huakupayaʼ onʼhuarakdepo, —‍Do huakudakaʼda eʼbueyada noyhuadhued kenda huakupayo huaboaʼda boʼtiahuaynig batiaʼpakhueʼ yaneʼ. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","—‍“Diosen Cristo tiakhued e̱e̱ʼted Elías huakkuruda tiakdik o̱ʼe̱a̱pet”. ¿Menaʼpo Moisésenbaʼ huamanmadikaʼeria kenda yadikaʼ? —‍Jesústaj oroʼomeya̱ onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","—‍Elíasonigti huakkuruda tiakdik o̱ʼe̱a̱po. Ayaʼtada yaʼmanopoʼyareayaʼpo yaʼtiakapet. Buttida oaʼuynigʼa. ");
INSERT INTO amrNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Elías eʼtiaktada kentaj o̱ki̱e̱hueʼ o̱ʼnuy Apagbaʼ huamanmadikaʼeria. Dakhueaʼ huakaʼeria kentaj dakhueaʼda oʼnogkaʼuy. Onʼpakpo dakhueaʼda oʼnogkaʼuyate. Doʼtaj kenpaʼti dakhueaʼda meʼnogkaʼapone. Paiʼda menʼnopoʼe̱a̱ʼapone. Do huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuy. Buttida ijjay. —‍Jesúsa oroʼomeytaj monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jesúsa Juan Bautistataj oʼhuaaʼ oroʼomeya̱ huaboaʼda oʼnopondeʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Huakupayaʼ eʼhuarakdeʼte huakkaʼda aratbut e̱gkupopakyo oroʼomey e̱kye̱ʼte nogbokerekatida Jesústaj oʼhuahuaʼpo huikudate oʼtihuadatoʼpo, ");
INSERT INTO amrNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—‍Doʼhuedsiʼpotaj yatinepahuiʼ, huairi. Oʼketpakonkikaʼ kenpaʼti paiʼnanada oʼnopoʼi̱kaʼ. Nogok nogok taʼakyo o̱ʼhue̱kikaʼ kenpaʼti hua̱hue̱yo̱ o̱ʼhue̱kikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","O̱ʼnen huanigpe̱i̱kaʼeritaj ijtohuaʼnigʼa yareahueʼdik o̱ʼne. —‍Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","—‍Opudomey judío aratbut eknopo̱e̱ʼtaʼ pakhueʼ moʼe̱ne. Oknopo̱e̱hueʼ hua̱e̱ʼeri moʼe̱po dakhueʼda moʼi̱kaʼne. Dios teyda o̱ʼe̱po bayareaʼdik o̱ʼe̱ oknopo̱e̱hueʼda moʼe̱ne. Ijhueʼtaʼda doʼtaj moknopo̱e̱ne. Huasiʼpotaj yanʼtotiak. —‍Jesúsa monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Totoʼ huasiʼpotaj eʼnopoʼto̱e̱tada Jesúsa huiyokda onaʼpo oʼtaʼmonaʼdenok totoʼ okmonnok huasiʼpo oʼyarudʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Nogok oroʼ Jesúsen huanigpe̱i̱kaʼeriyoʼda o̱ʼe̱po, —‍¿Oroʼnayo totoʼtaj menaʼpo taʼmonahueʼdik o̱ʼe̱? —‍Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","—‍Dios teyda o̱ʼe̱po yareaʼdik o̱ʼe̱. Opudnayo suigda moknopo̱e̱ne. Mostazakid sigkidonig sigda sigda eknopo̱e̱ʼnayo oteʼtaj “yahuaʼ” onaʼdik moʼe̱nok, enaʼte oʼhuaʼapo. Diosnayo ayaʼda kaʼdik o̱ʼe̱ yanoknopo̱e̱ʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Bapehueʼ moʼunhuaʼpo kenpaʼti eʼtionaʼpakonhuaʼnayo in totoʼtaj taʼmonaʼdik moʼe̱ne. —‍Jesúsa monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jesús oroʼ huanigpe̱i̱kaʼeriere Galilea huadaribayo oʼhuaʼudhuapo, “Do huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne. Huabokereka doʼtaj huairitaj menʼyokapone. ");
INSERT INTO amrNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Doʼtaj menʼarakapone. Bapaʼmeʼnoe huakudakaʼda e̱ʼe̱a̱da ijnoyhuada̱poy.” Jesúsa monaʼuyne. Jesús kenda eadeʼte paiʼda oʼmauy. ");
INSERT INTO amrNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Capernaum huakkaʼ jakyo Jesús oroʼere oʼtiakdenok Diosen jak eʼtoʼkaʼ huakupe huabaeʼeria Pedrotaj onʼhuahuaʼpo, —‍¿Huamanmadikaʼeria Diosen jak eʼtoʼkaʼ huakupe menpaʼ yayokikaʼ? —‍Pedrotaj oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—‍E̱e̱ʼ. Oʼyokikay. —‍Pedroa oʼmanaʼuy. Jakyo Pedro eʼkudondeʼte Jesúsa huakkuruda onaʼpo: —‍¿Huadari gobierno huairitaj beʼa huakupe yokdik yanikaʼ? ¿Gobiernoen huadakyereapiʼ esoeriapiʼ yokdik yanikaʼ? —‍Jesúsa Pedrotaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","—‍Esoeriayoʼda huakupe yokdik o̱ʼnikaʼ. —‍Pedroa onaʼuy. —‍Ken gobierno huairitaj huadakyerenayo yokhueʼdik o̱ʼnikaʼ. Konigti do Diosen Huasiʼpo i̱jje̱po Diosen jak eʼtoʼkaʼhuayak huakupe yokhueʼdik i̱jje̱y. ");
INSERT INTO amrNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Aratbut beʼapiʼ huadiayhueʼdik moʼe̱po ijyokapoy. E̱ʼpo̱gyo̱ yahuaʼ. Yanigkaʼetiʼ. Huakkuru biig e̱ʼta̱ka̱ʼ iʼtotokdepo huakittaʼyo huakupe iʼhuahuayapone. Diosen jak eʼtoʼkaʼhuayak huakupe huabaeʼeritaj yayoktiʼ. Onere doerea dakhuapa o̱ʼe̱a̱po. —‍Jesúsa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Kenokaʼ oroʼomey Jesúsen huanigpe̱i̱kaʼeri Jesústaj oʼhuahuaʼpo, —‍¿Diosen Huairitaj nogok eʼnigpe̱e̱deʼte beʼa hueret huairida e̱ʼdik ya̱ʼe̱a̱pet? —‍Oroʼa Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesús kenda oʼpe̱e̱depo, “yatiak huasiʼpo,” onaʼpo nopoyo oʼboaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","—‍Huasiʼpotaj ʼuruaʼda manmadikaʼdik moʼe̱ kenpaʼti huasiʼpo ʼuruaʼda onʼnigpe̱i̱kaʼ. Diostaj nopoʼkoreaʼdik moʼe̱. Konig huasiʼpo ʼuruaʼda onʼnigpe̱i̱kaʼnig yanʼnigpe̱i̱kaʼ. Konig huasiʼpo onʼnigpe̱i̱kaʼ opud nigpe̱e̱hueʼ e̱e̱ʼnayo kenpaʼti nopoʼkoreahueʼ e̱e̱ʼnayo Diosensiʼpo ehueʼdik moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","In isiʼpo huairi i̱jje̱y nopo̱e̱hueʼ o̱ʼi̱kaʼnig ayaʼada konigti yanʼnopo̱i̱kaʼpo Cristoere hueret huairida ya̱ʼneapet. ");
INSERT INTO amrNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Doʼhua ijpaknok ayaʼada konig huasiʼpotaj doʼhued huaknopo̱e̱ʼeritaj eʼtihuapoknayo dakaʼ eʼmato̱e̱ʼnayo doʼtakon oʼdene, doʼtakon mento̱e̱ne. ");
INSERT INTO amrNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Beʼapiʼ doʼhued ʼuru huanigpe̱i̱kaʼeritaj dakhueaʼ eʼbatokaʼnayo keʼponanada castiga Diosa o̱gkadhuahuikaʼapo konige̱po doʼhued ʼuru huanigpe̱i̱kaʼeritaj dakhueaʼ eʼbatokaʼtaʼ eʼpaknayopiʼ dakhueaʼ batokahued beʼapiʼ huidtoneʼ keʼnen hua̱hue̱rentaʼ yanʼtiontidukupo taʼkotdik a̱ʼe̱ya̱ʼpo jod ya̱koyo eʼkotnayo kendanayo konig sueʼda castiga eʼmagkaʼ o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Dakhueaʼnanada o̱ʼe̱po nogtaj nogtaj dakhueaʼ huabatokaʼ o̱ʼnikaʼpo dakhueʼda o̱ʼe̱. Onʼbatokaʼikaʼaponok dakhueaʼ eʼkaʼ huabatokaʼeritaj Diosa diga̱ʼnanada castiga oʼmagkadhuahuikaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","9","Konige̱po huabaʼpiʼ huaʼipiʼ huakpopiʼ dakhueaʼ eʼkaʼ huataʼda eʼtokaʼnayo dakhueaʼnanada o̱ʼe̱nok Diosa castiga oʼmagkaʼpo taʼakyo oʼenapo. Konige̱po huabaapiʼ huaʼiapiʼ huakpoapiʼ dakhueaʼ eʼtokaʼtaʼ eʼpaknayo dakhueʼda o̱ʼe̱po kahueʼdik a̱ʼe̱ya̱ʼpo eʼboktegnayopiʼ huadak ya̱ʼe̱a̱pet, tokahueʼdik a̱ʼe̱ya̱ʼpo ekpokotoknayopiʼ huadak ya̱ʼe̱a̱pet. Ken konig yanʼnopo̱e̱po dakhueaʼ kahueʼ yanikaʼ. Dakhueaʼ ekaʼnayo Diostaj dakhueaʼnanada boʼkaʼnok castiga mogkadhuahuikaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Huaboaʼ huaknopo̱e̱ʼeritaj konig huasiʼpotaj dakhueʼda o̱ʼne matinopo̱e̱hueʼ yanikatiʼ. Diosen huataʼmoneria Diosere o̱ʼnikaʼpo dakaʼ onʼmato̱i̱kaʼ. Huaboaʼ huaknopo̱e̱ʼeritaj dakaʼ onʼmato̱i̱kaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Do Diosen Huasiʼpo i̱jje̱nok Diosa meʼtaʼmonaʼuyne. Aratbut Diostaj nigpe̱e̱hueʼ hua̱e̱ʼeritaj aʼmanopoʼyareayaʼpo ijtiakuy. ");
INSERT INTO amrNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Cien oveja on eʼto̱e̱ʼnayo nogtida eʼtatitikonte nogomey noventa y nuevetaj iʼbakhuaʼapo nogtiaʼda eʼtatitikontaj iʼukapo. ");
INSERT INTO amrNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Iʼhuahuaypo durugnada i̱ʼe̱a̱pone. Nog ovejataj sueʼpiʼ durugda i̱ʼe̱a̱pone ");
INSERT INTO amrNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ayaʼda huaknopo̱e̱ʼeritaj Diosa huadiʼda oʼmaikaʼ. Nogtiapiʼ huadiʼda huaknopo̱e̱ʼeri Diostaj eʼyoyahueʼtaʼ Apag Dios kurudya̱ʼ pakhueʼ o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","O̱ʼnen huaknopo̱e̱ʼeri huamaʼbuy ontaj dakhueaʼ ekaʼnayo kentaj nogtiaʼ yanʼto̱e̱po namaʼda o̱gkaʼne. Yanatiʼ. Keʼna oʼpe̱e̱po eʼnopoʼkoreaʼnayo onteʼti onʼtaj huadiʼda o̱ʼe̱a̱po kenpaʼti Diostaj diʼda o̱ʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ontaj pe̱e̱hueʼda e̱e̱ʼnayo nogtida bottatapiʼ yabatohuaʼ. O̱ʼnen huaknopo̱e̱ʼeri huamaʼbuyte yabatohuaʼ. Kenpaʼ huamaʼbuy ontaj dakhueaʼ megkaʼne kanʼhuaeʼpo yabatohuaʼ. Huamaʼbuyte yabatohuaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Kenda enadeʼte kenomeytakon eʼpe̱e̱taʼ pakhueʼ e̱e̱ʼnayo Diostaj huaknopo̱e̱ʼeri e̱gkupopakikayaʼ dakaʼ yamanaʼ. Keʼna kenpaʼti Diostaj huaknopo̱e̱ʼeritaj manpe̱e̱hueʼda e̱e̱ʼnayo konig oknopo̱e̱hueʼ hua̱e̱ʼeri ka̱e̱ʼ. Konig huakupe huabaeʼeri dakhueʼda ka̱e̱ʼ. Kentaj egʼ huaahueʼ yanikatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Opudere nogtiapiʼ huaknopo̱e̱ʼeri oʼkupopakikaʼ dakhueaʼ ekaʼnayopiʼ dakaʼda yanʼnopo̱e̱po kentaj okkahueaʼdik moʼe̱ne. Ekkahueaʼnayo Diosakon okkahueaʼapo. Okkahueahueʼda e̱ʼnikaʼnayo Diosakon okkahueahueʼdikda o̱ʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Opud bottaʼda konigti boʼpakpo boʼtionaʼpaknok Apag Diosa kurudyo̱ moʼnigkikaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Doʼhued eʼkikaʼtaʼ onʼpakpo bottaʼapiʼ bapaʼapiʼ onʼkupopak. Aʼtionaʼpakyaʼpo onʼkupopakpo kenomeynopoyo i̱jje̱a̱poy. Kenpaʼti ijjay. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ken, Pedroa Jesústaj oʼhuahuaʼpo, —‍¿Doʼhued huamaʼbuy doʼtaj onteʼti onteʼti dakhueaʼ e̱gkaʼnayo menigaʼaʼ okkahueaʼdik i̱jje̱? ¿Menpaʼ sieteaʼaʼ okkahueaʼdik i̱jje̱, Huairi? —‍Pedroa Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","—‍Sieteaʼ okkahueaʼdik ahueʼ i̱jje̱y. Cuatro cientos noventaaʼ okkahueaʼdik moʼe̱ne, ijjay. —‍Jesúsa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","—‍Dios huairitaj eʼnigpe̱i̱kaʼ konig huadari gobierno huairi o̱ʼe̱. “Ayaada doʼtaj dehueʼ e̱e̱ʼnayo yokdik moʼe̱ne.” Kenpaʼ huairia oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kenpaʼ eʼmanadeʼte nogtida huadehueʼeritaj onʼtotiakuy. Huairite onʼtotiakuy. Huakkaʼnanada dehueʼ o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ken huabokerek huadehueʼeri huakupebayoʼ o̱ʼe̱po yokhueʼdik o̱ʼe̱nok. “Ken huanabaʼ huakupete yabahuayatiʼ. Keʼnen hua̱to̱e̱ere huasiʼpoere kenpaʼti ayaʼda oʼtamaenig yabahuayatiʼ. Kenda huakupe dehueʼ baeʼdik i̱jje̱y.” Gobierno huairia oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ken huadehueʼeria oʼpe̱e̱depo huikudate oʼtihuadpo “Doʼtaj menige̱ʼ. Doʼtaj meʼtinepahuiʼpo dakhuapa ijyokapoy, huairi.” Onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Keʼnen huairia oʼtinepahuiʼpo oʼenpo kenpaʼti ayaʼ dehueʼ oʼtitiokahueʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Oʼtitiokahueʼnigʼa ken huadehueʼeri eʼhuaʼte nog huanabaʼtaj oʼdeatoʼpo. Ken huanabaʼ huadehueʼeritaj suhuigda dehueʼ e̱e̱ʼtada hua̱hue̱rentaʼ o̱ʼhue̱rendapikpo “Kenda huakupe eʼdehueʼte beyok.” Huiyokda onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ken huanabaʼ huikudate oʼtihuadpo. “Menige̱ʼ. Meʼtinepahuiʼpo. Aʼti ayaʼ ijyokapoy,” enaʼtada ");
INSERT INTO amrNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","noga̱ eʼnige̱ʼtaʼ pakhueʼ o̱ʼe̱po huabakuda̱ʼ jakyo oʼkuda̱ʼuy. Huakupe yokhued huabakuda̱ʼ jakyo e̱ʼdik o̱ʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kenda nog huanabaʼ oʼkaʼnig onʼtiahuaypo konig eʼtirionig o̱ʼnepo. Gobierno huairitaj onʼhuahuaʼuy. Ayaʼda dakhueaʼ huadehueʼeria oʼkaʼnig oʼnonbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Keʼna dehuemeʼenigtaj yanʼtotiak.” Huairia oʼmanaʼuy. Enʼtotiakdeʼte “Dakhueʼda huanabaʼ i̱ʼe̱ne. Paiʼda onaʼnok o̱ʼna dehueʼ ayaʼ ijtitiokahueʼmey. ");
INSERT INTO amrNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Konig ontaj oʼmatinepahuimeʼne on konigti nogtaj tinepahuiʼdik ya̱i̱kaʼ.” Ken huairia onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ken huairia huakkaʼda oʼhuadiaypo, “Huakupe paga kahued e̱e̱ʼte huabakuda̱ʼ jakyo huamato̱e̱ʼeritaj yanʼyoktiʼ.” Huairia oʼmanaʼuy. —‍Ken konig Jesúsa oʼmanbatiaʼpakpo: ");
INSERT INTO amrNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","—‍Nog aratbuttaj okkahueahueʼ e̱e̱ʼnayo konigti doʼhued Apag Dios opudtaj okkahueahueʼ o̱ʼe̱po castiga oʼmagkaʼapo. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Kenpaʼ Jesúsa oʼmanaʼdepo Galilea huadaribayaʼ oʼbakhuaʼpo Jordánhue̱ akodpen Judeabayo oʼhuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Judeabayo oʼhuaʼepo kentaj huakkaʼ o̱gkupopakpo Jesústaj onʼtaʼhuaʼuy. Ke̱ya̱ʼ huakkaʼtada oʼbayareaʼuy. Dakhueʼtaj oʼbayareaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Kenokaʼ sueʼada fariseo huamanmadikaʼeria Jesústaj onʼhuahuaʼpo Jesúsa namaʼda kaeʼpo onʼpakpo: —‍¿Huabokerek hua̱to̱e̱ katepiʼ dakhueaʼ eʼkaʼte menpaʼ kenpaʼda endik ya̱ʼe̱? —‍Jesústaj oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","—‍“Huakkuruda Diosa huabokerektaj ettoneʼtakon oʼkaʼuyate.” Apagbaʼte kenpaʼ oaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Kenpaʼti oaʼpo: “Konige̱po huabokerek keʼnen huaoj hua̱ye̱eretaj okhuaʼpo ettoneʼtaj aʼto̱e̱pakyaʼpo. Bottaʼ e̱ʼe̱a̱da onʼto̱e̱pakdepo konig nogtida o̱ʼnede.” Apagbaʼte kenpaʼ oaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Konige̱po huabokerek hua̱to̱e̱ere onaʼti bottaʼ ehueʼdik nogtida o̱ʼne. Konige̱po kenda Diosa oʼto̱e̱pakaʼde huabokereka enhueʼdikda o̱ʼne. —‍Jesúsa fariseo huamanmadikaʼeritaj oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","—‍Huabokerek hua̱to̱e̱ʼtaj e̱ʼentaʼ eʼpaknayo e̱ʼen berobaʼ madoyaʼdik o̱ʼe̱. Hua̱to̱e̱ʼtaj iyokdepo ʼendik o̱ʼe̱. ¿Menaʼpo Moisésa kenpaʼ oʼmanaʼuyate? —‍Jesústaj oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","—‍Aratbut Diosen eʼkaʼtaʼ pakhueʼ o̱ʼnepo konige̱po hua̱to̱e̱ enʼdik moʼe̱ne. Moiséskudaka eʼmanaʼtada aʼnenda huakkuruda enhueʼdik o̱ʼnikaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Hua̱to̱e̱ nog huabokerekere bakdejhueʼ e̱e̱ʼnayo ken huabokerek keʼnen huadakda hua̱to̱e̱ e̱ʼenada kenpaʼti nog ettoneʼtaj eʼto̱e̱paknayo Diostaj dakhueaʼda oʼkaʼpo konig nogen hua̱to̱e̱ oʼbakdej. Kenpaʼti nogen hua̱to̱e̱ e̱ʼen berobaʼ eʼyokdeʼtaj on eʼto̱e̱paknayo konig nogen hua̱to̱e̱ eʼbakdeonig o̱ʼe̱. Diostaj dakhueaʼda iʼkaʼ. Doʼhua ijjay. —‍Jesúsa fariseo huamanmadikaʼeritaj oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","—‍Ken konig huabokerek hua̱to̱e̱ʼtaj enhueʼdik e̱e̱ʼnayo to̱e̱pakhueʼdik o̱ʼe̱y. —‍Oroʼ Jesúsen huanigpe̱i̱kaʼeria onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","—‍Sueʼdamona huabokereka to̱e̱pakhueʼdik o̱ʼnikaʼapo. Kenomeytaj Diosa oʼtihuapoknok to̱e̱pakhueʼ o̱ʼnikaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Sueʼda huabokerek dakhueʼ eʼsiʼpoe̱ʼa̱ to̱e̱pakhueʼdik o̱ʼnikaʼ. Nogomeytaj huabokereken ektego̱k to̱e̱pakhueʼdik o̱ʼnikaʼ. Nogomey Diostayoʼda diʼ e̱ʼe̱taʼ onʼpakpo kenpaʼti Diosenyoʼda eʼkaʼtaʼ onʼpakpo to̱e̱pakhueʼ o̱ʼnepo Diosenyoʼda o̱gkikaʼ. Kenda pe̱e̱ʼdik e̱e̱ʼnayo yanʼpe̱e̱ʼ. —‍Jesúsa oroʼtaj monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nogok huasiʼpotaj Jesúste onʼbatohuaʼuy. Jesúsa beʼtatibataʼteʼeʼpo kenpaʼti meʼtationaʼpakeʼpo onʼpakpo onʼbatotiakuy. Oroʼ huanigpe̱i̱kaʼerianayo “Kejeʼ, nigbatohuahueʼ yaneʼ.” Oʼmanaʼuynigʼa. ");
INSERT INTO amrNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","—‍Huasiʼpo doʼte kanʼbatiakeʼ. “Ka̱e̱ya̱ʼ,” manahueʼ yaneʼ. Konige̱po konig inomey ʼurunopoʼda huasiʼpo o̱ʼne konigti aratbut huaknopo̱e̱ʼeri Diosensiʼpo o̱ʼnepo Dios Huairitaj onʼnigpe̱i̱kaʼ. —‍Jesúsa monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Huasiʼpotaj oʼbatibataʼteʼedepo oʼmationaʼpakdepo ke̱ya̱ʼ oʼbakhuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Jesústaj huairia oʼhuatiakdepo: —‍¿Kurudyo̱ Diosere aʼnoeonhuahuikayaʼpo kate huadakda kikaʼdik i̱jje̱, huadakda huamanmadikaʼeri? —‍Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","—‍Kaʼtiaʼpo huadakda i̱ʼe̱ onaʼ. Diosyoʼda huadakda o̱ʼi̱kaʼ. Kurudyo̱ Diosere eʼnoeonhuahuikaʼtaʼ eʼpaknayo Diosen eʼmanaʼ yanigpe̱i̱kaʼ. —‍Jesúsa huairitaj onaʼnok: ");
INSERT INTO amrNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—‍¿Kateaʼ eʼmanaʼ nigpe̱i̱kaʼdik i̱jje̱a̱po? —‍Jesústaj onaʼuy huairia. —‍Aratbuttaj yahuadiaypo arakhueʼ ya̱i̱kaʼ. Nogen hua̱to̱e̱ʼtaj bakdejhueʼ ya̱i̱kaʼ. Nogen bakberehueʼ ya̱i̱kaʼ. Namaʼda bahuaahueʼ ya̱i̱kaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Huaojtaj hua̱ye̱taere dakaʼda yanigpe̱i̱kaʼ, kenpaʼti dakaʼda yamato̱i̱kaʼpo, yabayokikaʼ. Konig huataʼ diʼda i̱ʼi̱kaʼ nog aratbuttakon diʼnanada yamaikaʼ. —‍Jesúsa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","—‍Do huasiʼpoeda̱da ayaʼda ijnigpe̱i̱kaʼuy. ¿Kate nog kaʼdiken i̱jje̱a̱po? —‍Huairia onaʼnok: ");
INSERT INTO amrNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","—‍Ayaʼda kaʼdiken i̱ʼe̱po iʼpakpo huakupete ayaʼda iʼtamaetnig yabahuayaʼ. Ken huakupe yabaedepo paiʼda aratbuttaj yabayokeʼ. Kenda on ekaʼnayo kurudyo̱ Diosere huakkaʼda iʼmatoeunhuahuikaʼapone. Doʼtaj beʼtahuaʼikaʼpo doʼtayoʼda menigpeonhuahuikaʼ. —‍Jesúsa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ken huairi huakkaʼnada oʼtamaenok suhueʼnanada o̱ʼunpo okhuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","—‍Huairi huakkaʼ eʼmato̱e̱ʼtaʼ huaeretpakeri Diostaj oknopo̱e̱hueʼdik o̱ʼneapo Diosensiʼpo ehueʼdikda o̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Konig camello huaboroʼ ʼuhua sakpiʼpe̱yo̱ kudhueʼdik o̱ʼe̱. Konigti huairi huakkaʼda onʼmato̱e̱po Diosensiʼpo ehueʼdikda o̱ʼneapo. —‍Jesúsa oroʼtaj monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kenpaʼ oroʼ oʼpe̱e̱depo, —‍¡Kenpihuay! ¿Beʼa Diosensiʼpo e̱ʼdik ya̱ʼneapo? ¿Beʼa Diosere onteʼti noeonhuahuikaʼdik ya̱ʼneapo? —‍Oroʼa huayahuaya oʼbatiaʼpakuynok. ");
INSERT INTO amrNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesúsa oroʼtaj boʼtiahuaypo: —‍Huabokereka huataʼda nopoʼyareahueʼdik o̱ʼne. O̱ʼnada onʼpakpo noeonhuahuikahueʼdik o̱ʼneapo. Diosayoʼda nopoʼyareaʼdik oʼmae kenpaʼti onteʼti manoeanhuahuikaʼdik oʼmae. Diosayoʼda ayaʼda kaʼdik o̱ʼe̱. —‍Jesúsa monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","—‍Oroʼnayo ayaʼda oʼmato̱i̱kaʼnig oʼmaenonʼuy. Ontaj ataʼhuayaʼpo ayaʼda oʼmaenondemey. ¿Oroʼ kate mato̱e̱ʼdik o̱ʼe̱a̱pet? —‍Pedroa Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","—‍Nogok Diosa konig huaboda ayaʼda onteʼti oʼkaʼapo. Kenokaʼ do huamataʼmonaʼanhuaʼ gobierno huairitoneʼ i̱jje̱po opud doce huanigpe̱i̱kaʼeri Israel tribu aratbuttaj maboroaydik moʼi̱kaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ayaʼada keʼnen jak kenpaʼda o̱ʼnen, huamaʼbuytaj huidpotapiʼ o̱ʼnen, huaojtaj hua̱ye̱tapiʼ o̱ʼnen, hua̱to̱e̱ʼtaj huasiʼpotaj taʼbapiʼ o̱ʼnen. Doʼtayoʼda aʼnigpe̱i̱kayaʼpo o̱ʼnen. Kenomeytaj huakkaʼnada Diosa oʼbayokapo kenpaʼti onteʼti Diosere onʼnoeonhuahuikaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Oy huakkaʼda huairi e̱ʼe̱a̱da nogok huairida ehueʼ o̱ʼneapo. Konig huanabaʼ o̱ʼneapo. Huakkaʼmon konig huairionig ehueʼda o̱ʼnikaʼnig konig huanabaʼda oy o̱ʼnikaʼnig nogoknayo ʼuruaʼda o̱ʼneapo. Konig gobierno huairitoneʼ o̱ʼneapo. —‍Jesúsa monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Dios huairitaj eʼnigpe̱i̱kaʼ konig o̱ʼe̱a̱po onteʼti Jesúsa oʼmanbatiaʼpakpo: —‍Taʼba huairi huaboroʼda taʼba oʼto̱e̱po uva kanʼdakeʼpo sikyoedda taʼba huabaaʼeritaj oʼukuy. ");
INSERT INTO amrNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nogtida denario huakupe ijyokapoy oʼmanaʼdepo keʼnen taʼbayo oʼmataʼmonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tokhuada̱ʼ huadhued e̱e̱ʼted onaʼti huakkaʼ jak eretnopoyo huabokerektaj oʼbahuahuaypo, ");
INSERT INTO amrNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","“Doʼhued taʼbayo yanhuatiʼ. Dakhuapa onʼyokapone.” Oʼmanaʼnok kenomeykon taʼbayon onʼhuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Tokhuad eʼhuadte taʼba huairi onteʼti konigti oʼkaʼuy kenpaʼti tereaʼ eʼhuadte konigti oʼkaʼuy. Onteʼti onteʼti nogbokerek nogbokerek taʼbayo oʼmataʼmonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kenpaʼti baysikdakon jak eretnopoyo oʼhuaʼdepo nogda oʼbahuahuaypo “¿Opud ayaʼ inmeʼnoete menaʼpo baahueʼ moʼe̱?” Huabokerektaj oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Beʼapiʼ oroʼtaj taʼmonahueʼ moʼe̱ne.” Huairitaj oʼnonaʼuy. “Doʼhued taʼbayo yanhuaʼ. Ke̱yo̱ yanʼbaaʼ. Dakhuapa onʼyokapone.” Huairia oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Oʼsikdenok taʼba huairi keʼnen huakupe huato̱e̱ʼeritaj taʼbayo oʼtaʼmonaʼpo, “Huabaaʼeritaj yabatotiak. Huakupe yabayokeʼ. Taʼpotaʼ huahuaʼeritaj huakkuruda yabayokeʼ. Kenomey sikyoedda huakkuru onʼbaaʼ taʼpotaʼ yabayok.” Huairia keʼnen huakupe huato̱e̱ʼeritaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Kenomey bisikda huaboaʼda onʼbaaʼnig enʼtiakdeʼte nogtida denario huakupe oʼbayokeʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nog huakkuruda huabaaʼeria aʼtimon taʼpotaʼ onʼtiakdepo nogi̱timon oroʼtaj boʼyokapone enʼnopo̱e̱ʼtada konigti oʼbayokeʼuy. Kenomeytakon nogtida denario huakupe oʼbayokeʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Huakupe onʼto̱e̱depo huaboaʼda huairitaj dakhueaʼda onʼhuaaʼpo, ");
INSERT INTO amrNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Taʼpotaʼ huakaʼeria sueʼda onʼbaaʼnigʼa oroʼnayo ukkaʼda eʼtaʼteʼte huameʼnoeaʼ oʼbaaʼahuadnigʼa konig kenomeytaj oʼbayok konigti oroʼtaj boʼyokne.” Huairitaj enʼhuaaʼte, ");
INSERT INTO amrNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","nogtitada “Ontaj dakhueaʼ kahueʼ i̱jje̱y. Nogtida denario huakupete ijbaaʼapoy o̱ʼna iaʼne iʼbaaʼne, huadiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","O̱ʼnen huakupe in iʼta̱e̱ne yahuatiʼ. Taʼpotaʼda huabaaʼeritaj konigti doada eʼyoktaʼ ijpaki. ");
INSERT INTO amrNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Doʼhuedda huakupe ijto̱e̱po beʼtapiʼ ijpakpo yokdik i̱jje̱y. Nogtaj ijpakpo huakkaʼda ijbayoki namaʼda oʼhuadiayne, huadiayhueʼ meeʼ.” Huairia onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ken aratbut taʼpotaʼ doʼtaj oʼnoknopo̱e̱a̱po konig huakkuruda huaknopo̱e̱ʼeritaj konigti Diosa oʼbayokapo. Diosa oʼmanoeanhuahuikaʼapo. —‍Jesúsa oʼmanbatiaʼpakpo oʼmanmadikaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesús Jerusalényo̱ oʼhuaʼdepo oroʼ keʼnen doce huataʼmoneritaj Jesúsa boʼtohuaʼuy. Meyo̱hueʼda boʼtohuaʼuy. Oroʼtaj monaʼpo: ");
INSERT INTO amrNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—‍Jerusalényo̱ oʼhuaʼne. Do huabokerek i̱jje̱po Diosyaʼ ijtiakuy. Jerusalényo̱ huabokereka sacerdote huairiomeytaj menʼyokapone. Moisésenbaʼ huamanmadikaʼeritere menʼyokapone. Ken bueydik o̱ʼe̱. Menʼhuaaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nog aratbuttaj judío aratbut ehueʼtaj doʼtaj onʼbayokapo. Nog aratbuta doʼtaj menʼtierikapone. Huiyokda pidetbiʼa menʼbitbitapone. Hue̱ypa Cruzte doʼtaj meʼdarakapone. Bottaʼaʼ eʼtisikdeʼte kubarakyo huakudakaʼda e̱ʼemeʼtada Diosa meʼnoyhuada̱ʼapone. —‍Jesúsa monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Zebedeoensiʼpo Jacobo kenpaʼti Juan o̱ʼnepo hua̱ye̱ere Jesústaj onʼhuahuaʼuy. Konig huairitaj huikudate onʼtihuadikaʼ ettoneʼa̱ Jesústaj huikudate oʼtihuaduy. ");
INSERT INTO amrNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","—‍¿Kate iʼpak? —‍Jesúsa onaʼnok. —‍O̱ʼna huakhuairi e̱ʼe̱deʼte in doʼhued bottaʼsiʼpo onere kaʼnikeʼ kenpaʼti onere huairitoneʼ yanʼmanpa̱i̱kaʼ. —‍Jacoboen Juanenere hua̱ye̱a̱ Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","—‍Kenpaʼ onahueʼ meneʼ. Do paiʼnada ijnopoʼe̱a̱poy. ¿Menpaʼ doere konigti paiʼda nopoʼe̱ʼdik moʼe̱? —‍Jesúsa oʼmanaʼuy. —‍E̱e̱ʼ, onere paiʼnada nopoʼe̱ʼdik o̱ʼe̱y. —‍Jesústaj oʼnonaʼuy Juana Jacoboerea. ");
INSERT INTO amrNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","—‍Buttida ijjay, konig do paiʼda ijnopoʼe̱a̱poy opud konigti paiʼda moʼnopoʼe̱a̱pone. Nogok do huakhuairi i̱jje̱depo ijmanikaʼapoy. Doere huakhuairi kaʼneʼpo doʼhuanayo yahueahueʼdik o̱ʼnene. Kenomey doʼhued Apag Dios aʼnenda oʼbaktieʼeaʼuynigtaj doʼere huairi oʼbayahueaʼapo. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Oroʼa Jesúsen nog diez huataʼmonaʼeria kenda oʼmape̱e̱po Juantaj Jacobotaere oʼmahua̱diayʼuy. Kenomey huakhuairi Jesúsere e̱e̱ʼtaʼ onʼpaknok oroʼa oʼmahua̱diayʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Inte yanʼbatiak Jesúsa oroʼ huanigpe̱i̱kaʼeritaj monaʼdepo: —‍Nog aratbuten gobierno huairitoneʼ kenpaʼda teyda onʼmanaʼikaʼnok kenomeyen aratbut huairitaj nigpe̱i̱kaʼdik o̱ʼnikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Opudnayo ken konig kikahueʼdik moʼe̱ne. Beʼapiʼ huairi e̱e̱ʼtaʼ eʼpaknayo nog aratbuttaj kanʼbatihuapokikeʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kenpaʼti beʼapiʼ doʼere huairi e̱e̱ʼtaʼ eʼpaknayo nog aratbuten huanabaʼ kaʼnikeʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Konig do ijkikaʼnig konigti ya̱gʼkikaʼ. “Konig huanabaʼa mentihuapok.” Aʼikayaʼpo tiakhueʼ i̱jju̱y. Aratbuttaj aʼtihuapokyaʼpo ijtiakuy. Aratbuten dakhueaʼ eʼkaʼtaj aʼbakkahueayaʼpo aʼmanigbueyyaʼpo ijtiakuy. —‍Jesúsa oroʼtaj monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jerusalényo̱ oʼhuaʼpo huakkaʼ jak Jericóyo e̱ʼunhuaʼdeʼ o̱ʼo̱ro̱kdenok huakkaʼada aratbut Jesústaj onʼtahuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Dagope bottaʼ ekpobig onʼhuadpo, “Jesús oʼpokde,” aratbuta enhuaaʼte huakpobiga̱ onʼpe̱e̱po, —‍Oroʼtaj moʼtinepahuiʼpo bokpoyareaʼ Huairi, Daviden adhueaʼ huayayo. —‍Jesústaj oʼnonokuyʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","—‍Yanʼbatikdeʼ. —‍Aratbuta huiyokaʼda enʼmanaʼtada nogi̱ti huakkaʼaʼda oʼnonokuyeʼuy. —‍Oroʼtaj moʼtinepahuiʼpo bokpoyareaʼ Huairi, Davidkudaken adhueaʼ huayayo. —‍ʼUttaʼda oʼnonokuyʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ken, Jesúsa eʼhuaʼada oʼboatoʼpo. Ekpobigtaj oʼmanaʼpo: —‍¿Kate boʼpak? —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","—‍Ekpoyareaʼtaʼ oʼpaki. Oroʼtaj boyareaʼ, Huairi. —‍Jesústaj oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ken, Jesúsa oʼmatinepahuiʼpo eʼmakpoto̱e̱a̱deʼte huaboaʼda onʼtiahuaydepo Jesúsere onʼhuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jerusalén meyo̱hueʼda e̱ʼe̱deʼte Betfagé huakkaʼ jakyo oʼtiakuy. Olivos oteʼ kenteda o̱ʼe̱. Jesús bottaʼ huanigpe̱i̱kaʼeritaj oʼmataʼmonaʼpo: ");
INSERT INTO amrNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","—‍A̱yon Jerusalén dagyon huakkuruyon huakkaʼ jakyo yanhuatiʼ. Ke̱yo̱ burra ʼuhua burrasiʼpoere enukuʼ boʼhuahuayapone. Yanogkujpo doʼtaj menigtotiak. ");
INSERT INTO amrNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","“¿Menaʼpo boʼtohuaʼ?” Beʼapiʼ enaʼnayo “Huairia oʼpaknok oʼkay. Huaboaʼda onteʼti oʼtotiakapoy.” Ya̱ʼnonatiʼ. —‍Jesúsa bottaʼ huanigpe̱i̱kaʼeritaj oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Konig Diosen huamanbatiaʼpakeria oaʼuyatenok Jesúsa burrate kanʼtotiakeʼpo oʼmataʼmonaʼuy. Oʼmadoyaʼpo: ");
INSERT INTO amrNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Jerusalén aratbuttaj yanaʼ: “Yanʼmaboʼ. O̱ʼnen Huairi opudtaj boʼhuatiakne. Konig huanabaʼ huiyokaʼ ahueʼ o̱ʼe̱po burrosiʼpote oʼhuadpo oʼtiakapo. Burra katepiʼ huamabaʼhuiʼeri o̱ʼe̱.” Diosen huamanbatiaʼpakeria kenpaʼ oʼmadoyaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ken Jesúsen huanigpe̱i̱kaʼeria konig Jesúsa oʼmanaʼdenig onʼhuaʼdepo o̱gkaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Burra huasiʼpoere onʼtotiakuy. Huanigpe̱i̱kaʼeriomeyen huaokaʼ burrataʼpite onʼhueda̱ʼdenok Jesúsa burrataʼpite oʼhuaddeʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Jesúsere huakkaʼda aratbut onʼkupopakdepo dagte huakkuruyon huaok dagte onʼbahueda̱ʼpo kente Jesús oʼpokapo onʼnopo̱e̱po huaok onʼbahueda̱ʼuy. Huakkaʼ nogomey o̱hue̱y ʼopi baʼkutaj onʼbaktega̱ʼdepo dagte onʼbahueda̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Huakkurute hua̱e̱ʼeria kenpaʼti huataʼpoeria ayaʼada huaboaʼda ʼuttaʼda onʼdaʼpo: —‍Huairitoneʼ Daviden adhueaʼ huayayo ʼuruaʼnanada o̱ʼi̱kaʼ. Dios Huairia ʼuruaʼda meʼtaʼmonaʼuyate. Dakiti Dios. —‍Aratbuta ʼuttaʼnada oʼnokoyʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jerusalényo̱ Jesúsa eʼkuddeʼte ayaʼ huakkaʼ jakyo hua̱e̱ʼeria diga̱ʼda onʼbatiaʼpakpo: —‍¿Beʼa in ya̱ʼe̱? —‍Huakkaʼada huayahuaya onʼbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","—‍Galilea huadaribayo huakkaʼ jak Nazaret hua̱e̱ʼeri o̱ʼe̱. Jesús o̱ʼe̱. Diosen huamanbatiaʼpakeri o̱ʼe̱. —‍Huakkaʼ aratbut e̱gkupopakyaʼ onʼbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesúsa Diosen jakyo oʼkudondepo ayaʼ ʼuhua huabahuayaʼeritaj oʼmaoro̱kaʼ. Kenpaʼti ayaʼ huabakbaeʼeritaj oʼmaoro̱kaʼuy. Kenpaʼti huakupe huakabiaʼerien kutopa oʼmakmaenaʼuy. Kenpaʼti tukkuʼ ʼuhua huabahuayaʼerien huahuadtaj oʼmakmaenaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Oʼmanaʼpo: —‍Apagbaʼte oʼmadoyaʼuyate. “In doʼhued jak o̱ʼe̱. Aʼtionaʼpakyaʼpo aratbut i̱yo̱da onʼtiakikaʼ. Konig huabereʼerien jakonig opudomeya̱ moʼto̱e̱ne.” Apagbaʼte kenpaʼ oaʼ. —‍Jesúsa huabahuayaʼeritaj oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Diosen jakyo sueʼda huakpobig sueʼda huakketkon Jesústaj onʼhuatiaknok oʼbayareaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Sacerdote huairi kenpaʼti Apagbaʼ huamadoyaʼeri o̱ʼnepo, Jesús eʼbayareaʼte onʼtiahuaydepo, Diosen jakyo huasiʼpo Jesústaj “On ʼuruaʼnanada huairitoneʼ i̱ʼe̱. Daviden adhueaʼ huayayo i̱ʼe̱.” Huasiʼpoa ʼuttaʼda eʼnonaʼte huairi onʼpe̱e̱depo onʼdiaypo: ");
INSERT INTO amrNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","—‍¿Inomey huasiʼpoa boʼhuaaʼnig menpaʼ iʼpe̱e̱? —‍Jesústaj oʼnonaʼuy. —‍E̱e̱ʼ ijpe̱e̱y. Aʼnenda Apagbaʼte David oʼmadoyaʼuyate opuda̱da boʼtiahuayikaʼne. Huasiʼpo yo̱bederea “ʼuruaʼda o̱ʼe̱,” onʼhuaaʼapo Apagbaʼte kenpaʼ oaʼuyate. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Judío huairitaj oʼbakhuaʼdepo huakkaʼ jak Betaniayo oʼhuaʼuy. Ke̱yo̱ oʼtayʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Sikyoedmon onteʼti Jerusalényo̱ Jesús oʼkumejdepo aypotaʼ o̱e̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Hue̱ymey higuera dagte oʼtiahuaypo oʼhuahuaʼuy. Huakutayoʼda o̱ʼe̱nok, —‍Onteʼti dapakhueʼdikda i̱ʼe̱a̱pet. —‍Jesúsa higuerataj onaʼnok i̱dada higuera oʼayonʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Oroʼ oʼtiahuaydepo, —‍Kenpihuay. ¿Menpaʼ i̱dada oʼayon? —‍Oroʼa Jesústaj onaʼnok. ");
INSERT INTO amrNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","—‍Dakaʼ eknopo̱e̱ʼnayo konig higuerataj ijkaʼdey konigti ʼuruaʼda kaʼdik moʼe̱a̱pone opuda̱kon. Nog kenpaʼti dakaʼ moknopo̱e̱po “In oteʼ yatohuaʼ, Dios. E̱ʼpo̱gyo̱ yaen.” Tionaʼpakdik moʼe̱a̱pet. Kenpaʼ eʼtionaʼpakdeʼte Diosa oʼenapo. ");
INSERT INTO amrNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Eknopo̱e̱ʼnayo katepiʼ iʼpakpo iʼtionaʼpaknok Diosa oʼkikaʼapo. —‍Jesúsa oroʼtaj monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Nogok Diosen jakyo Jesúsa oʼkudondepo eʼmanmadikaʼte sacerdote huairi huatoneʼ huairiere Jesústaj onʼhuatiakpo: —‍¿Yabayareadhuatiʼ. Beʼa menaʼuy? —‍Jesústaj oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","—‍Huakkuru doʼtaj meʼnakonen. Opud enaʼnayo keʼna “yabayareaʼ,” menaʼuyne do kenpaʼti oʼnonaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","“Bautiza yamagkikaʼ.” ¿Beʼa Juantaj yanaʼuy, huabokereka Diosapiʼ? —‍Jesúsa oʼmanaʼnok. Ken huairiayoʼ huayahuaya onpayoʼ onʼbatiaʼpakpo: —‍Diosa Juantaj oʼtaʼmonaʼuy. Oroʼa eaʼnayo “¿Kenda Juana doʼtaj beʼtiaʼikuynig menaʼpo oknopo̱e̱hueʼ moʼu̱y?” Oroʼtaj monaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","“Huabokereka Juantaj onaʼuy.” Oroʼa enaʼnayo aratbuta oroʼtaj dakhueʼda mogkaʼapet konige̱po Diosen huamanbatiaʼpakeri Juan o̱ʼe̱ʼuy aratbut oʼnoknopo̱e̱. —‍Judío huairia huayahuaya onʼbatiaʼpakdepo: ");
INSERT INTO amrNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","—‍Beʼa Juantaj yanuye̱t oroʼ nopo̱e̱hueʼ o̱ʼe̱y. —‍Huairia Jesústaj oʼnonaʼuy. —‍“Yabayareaʼ.” Keʼna menaʼuyne do kenpaʼti onahueʼ o̱ʼneapone. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","—‍Huabokerek bottaʼ huasiʼpo oʼto̱e̱ʼuy. Nogtatida huasiʼpotaj “Oy doʼhued uva taʼbayo yahuaʼpo yabaaʼ.” Huaoa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Keʼ baahuey.” Eʼada aʼtimon huadakda oʼnopo̱e̱po aʼbaayaʼpo oʼhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Aʼti huaoj nogsiʼpotaj oʼhuahuaʼ. Konigti onaʼuy. “Oy doʼhued uva taʼbayo yahuaʼpo yabaaʼ.” Huaoa onaʼuynigʼa. “E̱e̱ʼ ijkaʼapoy.” Keʼna huaojtaj onaʼuy. Kenpaʼ enaʼada huahueʼ o̱ʼu̱y. ");
INSERT INTO amrNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","32","¿Menata huasiʼpoa huaoj oʼpaknig yaʼkaʼuy? —‍Jesúsa judío huairitaj oʼmanaʼuy. —‍Huakkuru e̱ʼhuana huasiʼpo konig huaoj oʼpaknig oʼkaʼuy. —‍Huairia Jesústaj oʼnonaʼuy. —‍“Yanʼnopoʼkoreaʼ onteʼti Diosen ya̱gʼkikatiʼ.” Juan Bautista opudtaj monaʼuynigʼa opuda̱ nopoʼkoreahueʼ moʼu̱y. Oknopo̱e̱hueʼda moʼu̱y. Gobierno huakupe huabaeʼeria kenpaʼti huakupete huabakdejeriomeynayo Juana eʼmanmadikaʼte onʼnopoʼkoreaʼpo oʼnoknopo̱e̱ʼuyate. Opud kenomeytaj eʼbatiahuayada eknopo̱e̱ʼtaj nopoʼkoreahueʼ moʼu̱ynok. Konige̱po gobierno huakupe huabaeʼeria kenpaʼti huakupete huabakdejeriere huakkuruda Diosensiʼpo o̱ʼneapo. Opudnayo taʼpote Diosensiʼpo e̱ʼdikpiʼ moet. Buttida ijjay. —‍Jesúsa judío huairitaj oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","—‍In ijmanbatiaʼpakapoy dakaʼ yanʼpe̱e̱tiʼ. Huairien taʼbayo uva huakpi onʼbatukeʼuy. Uva setda huada huakpi onʼbatukeʼuy. Onʼtiokpakaʼuy. Uva huada huasapaʼaʼ sipanaʼ ʼuruda oʼkogkaʼ. Huaʼia aʼsapayaʼpo oʼkogkaʼuy. Taʼba huatiokaʼ kutayoda kutopa oʼkaʼuy. Kenokaʼ uva taʼba hua̱ta̱to̱e̱ʼeritaj taʼba oʼbaktoyokuy. Oʼyokdepo bidteda nogbayo huairi oʼbakhuaʼuyate. Nogbayo ijhueʼda o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kenokaʼ uva huada oʼboyogdenok taʼbayo oʼmataʼmonaʼuyate. Huanabaʼtaj oʼmataʼmonaʼuyate. Sueʼda huada kanʼtotiakeʼpo oʼmataʼmonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Taʼbayo enʼtiakte hua̱ta̱to̱e̱ʼeria huairien huanabaʼtaj onʼmato̱e̱po nogtaʼtida onʼbitbituyate. Nogtaj oʼdarakuy. Nogtaj onʼpaʼeaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Onteʼti nogi̱ti huakkaʼ huanabaʼtaj oʼmataʼmonaʼuy. Huada kanʼtotiakeʼpo oʼmataʼmonaʼuy. Taʼbayo enʼtiakdeʼte hua̱ta̱to̱e̱ʼeria konig huakkurueri huanabaʼtaj onʼmagkaʼuy konigti kenomeytaj onʼbarakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Keneʼhua̱ya̱ʼ huairia huasiʼpo oʼtaʼmonaʼuy. Kentanayo ʼuruaʼda onʼdeapet oʼnopo̱e̱po. ");
INSERT INTO amrNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Huasiʼpokon eʼtaʼmonaʼtada taʼba hua̱ta̱to̱e̱ʼeria huasiʼpotaj onʼtiahuaydepo “Huairi eʼbueydeʼte huasiʼpoa ayaʼ huaojen baeʼdik o̱ʼe̱a̱po. Huairien taʼba oroʼen kenpaʼda moʼta̱e̱ʼpo huasiʼpotaj moʼdarak.” Onpayoʼ onʼbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ken huasiʼpotaj onʼto̱e̱po taʼbayaʼ onʼto̱o̱ro̱kpo, oʼdarakuy, ken. —‍Jesúsa ken konig oʼmanbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","—‍¿Taʼbayo huairi oʼtiakdepo, hua̱ta̱to̱e̱ʼeritaj menpaʼ magkaʼdik ya̱ʼe̱? ¿Menpaʼ moʼnopo̱e̱? —‍Jesúsa judío huairitaj oʼmanaʼnok, ");
INSERT INTO amrNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","—‍Matinepahuihueʼda dakhueaʼ huakaʼeritaj oʼbarakapo. Taʼba nogomey hua̱ta̱to̱e̱ʼeritaj oʼbayokapo. Kenomeya̱nayo i̱da keʼnen uva huada onʼtatotiakapo. —‍Jesústaj oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","—‍In Apagbaʼ boʼtiahuaydeʼuy: Huid jak o̱gkaʼpo jak huakaʼeria Diosen ʼuru huidda e̱ʼhua̱e̱ʼtaj pakhueʼ o̱ʼnepo o̱ʼnenʼuy. Ken huidte Diosnayo oʼpak ken huidte huaboroʼ jakda oʼkaʼapo. Kenda Dios Huairia oʼkaʼapo ʼurudapitaʼ oʼkaʼ, oʼnopo̱e̱y. Apagbaʼte kenda oaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Konige̱po Diosen Huairitaj nogomeya̱ oʼnoknopo̱e̱po ʼuruaʼda onʼnigpe̱i̱kaʼapo. Diosen ʼuruda huasiʼpo o̱ʼneapo. Opudomeytanayo moʼeneapone. ");
INSERT INTO amrNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Konig huidtoneʼtaj oʼtikudeʼpo oʼnokketo̱gkaʼapo ken konig e̱ʼdik o̱ʼneapo. Diosen Huairitaj oknopo̱e̱hueʼ o̱ʼnepo dakhueʼda o̱ʼneapo. Huidtoneʼ kutahueyaʼ eʼtikotnayo konig hua̱o̱ga̱da yaʼmagkaʼapet. Ehueʼda o̱ʼneapo. Konigti nopoʼkoreahueʼ hua̱e̱ʼeritaj Diosa castiga oʼmagkaʼapo. Kenpaʼda ehueʼdikda o̱ʼneapo. —‍Jesúsa judío huairitaj oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Sacerdote huairi fariseo huamanmadikaʼeriere Jesúsen eʼmanbatiaʼpaktaj onʼpe̱e̱depo, Jesúsa oroʼtaj boʼtiaʼpakne onʼnokotuy. Oroʼa huairien taʼba hua̱ta̱to̱e̱ʼeri o̱ʼneaʼ Jesúsa boʼtiaʼpakne judío huairiomeya̱ oʼnokotdepo, ");
INSERT INTO amrNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Jesústaj huabakuda̱ʼ jakyo eʼtohuataʼ onʼpaknigʼa aratbuttaj onʼmakmeʼpukpo tohuahueʼdik o̱ʼnuy. Jesús Diosen huamanbatiaʼpakeri o̱ʼe̱. Aratbuta oʼnoknopo̱e̱nok aratbuttaj onʼmakmeʼpukuy huairia. ");
INSERT INTO amrNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ken onteʼti Jesúsa ken konig oʼmanbatiaʼpakpo, oʼmanmadikaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—‍Dios Huairitaj eʼnigpe̱i̱kaʼ ken konig huairiensiʼpo e̱ʼta̱to̱e̱pak fiesta o̱ʼe̱. Gobierno huairiensiʼpo oʼto̱e̱pakaponok huairia fiesta oʼnigkaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Huakkaʼtada kenokaʼ yanʼtiaktiʼ fiesta aypo monʼbapeʼ ikken oʼmanaʼdemeʼte. Ken aypo eʼmahue̱ydeʼte huanabaʼ oʼmataʼmonaʼuyate. “Kenomeytaj ijmanaʼmey kentaj yanʼbatotiak.” Oʼmanaʼuyatenok. Huanabaʼa “Yanʼtiak.” Enaʼtada tiakhueʼ o̱ʼneʼuyate. Eʼtiaktaʼ pakhueʼ o̱ʼnepo tiakhueʼ o̱ʼneʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nogomeytakon huanabaʼtaj oʼmataʼmonaʼpo, “Kenomeytaj yanʼtiak ijmanaʼdemey. Vaca huasihuada ijbatiarakamey. Vacasiʼpo ijbatiarakamey. Vacaere aypoere oʼhue̱yde. Oyedda eʼto̱e̱pak aypotaj yanʼtiak. Huairia monaʼne.” Yanʼmanatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Onʼhuaʼdepo onʼmanaʼnigʼa. Nigpe̱e̱hueʼ o̱ʼnepo onʼtierikpo ehuaʼtaʼ pakhueʼ o̱ʼneʼuy. Sueʼada eʼpe̱e̱a̱da taʼbayo onʼhuaʼuy. Noga̱ huabahuayaʼ jakyo onʼhuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Nogomey onʼpe̱e̱depo huairien huanabaʼtaj onʼmabitbituy. Dakhueaʼda onʼmagkaʼuy. Nogte onʼbarakuy. ");
INSERT INTO amrNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Huairia kenda oʼmatipe̱e̱depo huakkaʼda oʼbahuadiaypo “Yanhuatiʼ. Kenomey huabarakeritaj yanʼbarak. Kenomeyen huakkaʼ jaktaj yanʼmakhui̱g.” Hua̱ʼen sorotatataj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Kenokaʼ “Eʼto̱e̱pak fiesta ayaʼda oʼkaʼdey ayaʼ aypo eʼmahue̱ydeʼtada kenomey eʼtiaktaʼ pakhueʼ o̱ʼnenok ");
INSERT INTO amrNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","jak nopoyo kente aratbut onʼkupopakikaʼ kente yanhuatiʼ. Ayaʼtada moʼbahuahuayapetnigtaj, ‘Yanʼtiak, eʼto̱e̱pak aypo monʼbapeʼ.’ Yanʼmanatiʼ.” Huairia huanabaʼtaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Huanabaʼ onʼpe̱e̱depo kurute onʼhuaʼuy. Ayaʼda onʼbahuahuaydepo huairien jakyo onʼbatotiakpo aypo aʼbapeyaʼpo onʼbatotiakpo huadakda dakhueʼdaere onʼbatotiaknok jakyo hueda̱ʼda o̱ʼu̱y. ");
INSERT INTO amrNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ayaʼda onʼkuddepo ʼuru eʼto̱e̱pak huaok onʼbaenigʼa nogbokerekatida othueʼ o̱ʼu̱yate. Gobierno huairi oʼkudondepo othueʼ oʼtiahuayʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","“ʼUru eʼto̱e̱pak huaok othueʼ e̱e̱ʼa̱da menpaʼ i̱yo̱da iʼkud, huadiʼ.” Huairia enaʼtada keʼna aʼtokhueʼda o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Huamataʼkoypiʼ huaʼitakpipenkon yanʼtinukuʼ. Sikki̱re̱gyo̱ yanenʼ. Ke̱yo̱ kenpaʼda oʼhuikonhuahuaʼapo kenpaʼti paiʼda oʼnopoʼunhuahuaʼapo.” Huairia huanabaʼtaj oʼmanaʼuyate, ken. ");
INSERT INTO amrNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Doʼhued huasiʼpotaj yanoknoponhuatiʼ.” Diosa huakkaʼtada oʼmanaʼikaʼ. Sueʼada oʼnoknopo̱e̱nok sueʼtada Diosa oʼbaktieʼeaʼapo. Dios Huairitaj eʼnigpe̱i̱kaʼ in konig fiesta o̱ʼe̱. —‍Jesúsa oʼmanbatiaʼpakpo oʼmanmadikaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Kenokaʼ fariseo huamanmadikaʼeria oʼnokhuaʼdepo “Jesúsa namaʼda kaeʼ kentaj kate onaʼdik o̱ʼe̱,” huayahuaya onʼbatiaʼpakuyate. Jesúsa namaʼda eaʼnayo dakhueaʼda oaʼ huaaʼdik o̱ʼe̱a̱pone. Onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Konige̱po Jesúste onʼmataʼmonaʼuyate. Sueʼda fariseomey sueʼda Herodes huamanmadikaʼeria Jesúste onʼhuahuaʼuy. Oʼnonaʼpo: —‍Buttida iaʼikaʼ. Konig aratbut kaʼdik o̱ʼnikaʼ, kenda Diosa oʼpak buttida iʼmanmadikikaʼne. Beʼapiʼ aratbut huairiapiʼ ontaj eʼpe̱e̱tada meʼpukhueʼda i̱ʼe̱po buttida iʼmanmadikikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","¿Menpaʼ Romano gobierno huairitaj huakupe yokikaʼdik o̱ʼe̱? ¿Yokhueʼdikpiʼ o̱ʼe̱, huamanmadikaʼeri? —‍Fariseo huamanmadikaʼeria Herodes huamanmadikaʼeria Jesústaj oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesúsa namaʼda yaaʼapetpiʼ namaʼda kaeʼpo meʼnonaʼne. Jesúsnayo oʼnokotpo, —‍Huadakda i̱jje̱y opuda̱da huataʼda namaʼda moʼtinopo̱i̱kaʼne. ¿Do dakhueaʼ kaeʼpo menaʼpo namaʼda oʼnonaʼ? ");
INSERT INTO amrNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Men huakupe gobierno huairitaj yokdik ya̱ʼi̱kaʼ. Menʼtiahuayʼeaʼ. —‍Jesúsa oʼmanaʼuynok. Ken denario huakupe eʼyokte ");
INSERT INTO amrNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Jesús oʼtiahuaydepo, —‍¿Huakupete beʼed huakok ya̱ʼe̱? ¿Huakupete beʼed huadik eʼmadoyaʼ ya̱ʼe̱? —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—‍Romano gobierno huairien huakok huadikere o̱ʼe̱. —‍Jesústaj oʼnonaʼuy. —‍Gobiernoen e̱ʼhua̱e̱ʼ yanʼyokikatiʼ. Kenpaʼti Diosen e̱ʼhua̱e̱ʼ ya̱gʼkikaʼpo yanʼyokikatiʼ. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kenpaʼ onʼpe̱e̱depo, kenpihuay, ʼuruaʼda oaʼ onʼnopo̱e̱po Jesústaj oʼnokhuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Saduceo huamanmadikaʼeria aratbut kubarakyaʼ onteʼti noyhuadhueʼ o̱ʼneapo onʼbatiaʼpakikaʼuy. Kenmeʼnoete Saduceoa Jesústaj onʼhuahuaʼpo oʼnonaʼpo: ");
INSERT INTO amrNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—‍“Huabokerek eʼto̱e̱pakada huasiʼpo to̱e̱hueda̱da eʼbueynayo keʼnen huamaʼbuy ayhuataj to̱e̱pakdik o̱ʼe̱po huamaʼbuykudaktaj huasiʼpo kanigto̱e̱ʼ.” Moisésa aʼnenda oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ken oroʼere siete huamaʼbuy o̱ʼnuy. Huakkurueria oʼto̱e̱pakdepo nogok okbueyʼuyate. Sigpiʼ huasiʼpo to̱e̱hueʼada okbueyʼuy. Nog huamaʼbuya ekbuey ayhuataj oʼto̱e̱pakuy. ");
INSERT INTO amrNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Konigti huakkuruerien ayhua oʼto̱e̱po huasiʼpo to̱e̱hueʼada okbueyʼuy. Konigti ayaʼada huamaʼbuy o̱gkaʼuy. Ayaʼda huamaʼbuya huakkuruerien ayhuataj onʼto̱e̱pakdepo onʼtimabueyʼuy. Sieteaʼ huamaʼbueya ayhuataj onʼto̱e̱pakdepo onʼmabueyʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Taʼpotaʼ ayhuakon oʼbueyʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","¿Nogok aratbut kubarakyaʼ onteʼti enʼnoyhuaddeʼte keʼna ayhua beʼed hua̱to̱e̱a̱ʼtaj ya̱ʼe̱a̱pet? Ayaʼada huamaʼbuya onʼto̱e̱ʼuy, huamanmadikaʼeri. —‍Saduceoa Jesústaj oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","—‍Opud Apagbaʼ nopo̱e̱hueʼda moʼe̱ne. Kenpaʼti Dios teyda o̱ʼe̱ oknopo̱e̱hueʼda moʼe̱po namaʼda moʼnopo̱i̱kaʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Aratbut onʼbueydepo onteʼti kubarakyaʼ onʼnoyhuaddepo to̱e̱pakhueʼdik o̱ʼneapo kenpaʼti hua̱yo̱bu kato̱e̱pakeʼpo bayokhueʼdik o̱ʼneapo. Aratbut kubarakyaʼ onteʼti onʼnoyhuaddepo konig Diosen huataʼmoneri kurudyo̱ o̱ʼne konigti o̱ʼneapo. Diosen huataʼmoneri to̱e̱pakhueʼ o̱ʼnikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Aratbut kubarakyaʼ onteʼti onʼmanoyhuadapo nopo̱e̱ʼdik moʼe̱ne. Apagbaʼte Diosa kenpaʼ oaʼuyate. Moisésenbaʼte konig boʼtiahuayikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Abrahamen Dios i̱jje̱y. Isaacen Dios i̱jje̱y. Jacoben Dios i̱jje̱y.” Diosa oaʼuyate. Kenpaʼ eaʼte inomey huabokerek aʼnenda onʼbueyonʼuyate. Diosere onʼnoeonhuahuikaʼ. Eʼbueyen Dios ehueʼda o̱ʼe̱. Dios aratbut huanoikaʼerien Dios o̱ʼe̱. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Jesústaj onʼpe̱e̱depo ʼuruaʼnada oaʼ huakkaʼada aratbuta onʼtinopo̱e̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","36","Jesúsa ʼuruaʼda oaʼnok Saduceo aratbut onteʼti onahueʼ o̱ʼnuy Jesústaj. Kenpaʼ fariseo huamanmadikaʼeria onʼnopoendepo o̱gkupopakpo Jesúsa namaʼda yaaʼapetpiʼ ¿kateaʼ onaʼdik o̱ʼe̱a̱po? Onʼnopo̱e̱po, —‍¿Diosen eʼmanaʼ menata hueretda inigpe̱e̱po kikaʼdik ya̱ʼe̱, Huamanmadikaʼeri? —‍Fariseo huamanmadikaʼeria Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","—‍“Dios Huairitaj diʼnanada yanikaʼ. Huanopoʼabetaʼ huakkaʼda yanʼpakpo Diostaj diʼ yanikaʼ. Hua̱so̱ʼa̱betaʼ huakkaʼda yanʼpakpo Diostaj diʼ yanikaʼ. Huanoki̱re̱ga̱betaʼ huakkaʼda yanʼpakpo Diostaj diʼ yanikaʼ. Eʼnopo̱i̱kaʼa yanʼeretpakpo Diostaj diʼ yanikaʼ.” ");
INSERT INTO amrNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Kenda Diosen hueretda eʼmanaʼ iʼnigpe̱i̱kaʼpo kikaʼdik o̱ʼe̱. Huakkuruda kenda eʼmanaʼ o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Diosen taʼpotaʼ eʼmanaʼ konigtimon o̱ʼe̱. “Konig huataʼ diʼda moʼi̱kaʼne konigti nog aratbuttaj diʼda yanʼmaikaʼ.” ");
INSERT INTO amrNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kenda ijjaʼnig Moisésen eʼmanaʼpiʼ konigti ayaʼda o̱ʼe̱. Kenpaʼti Diosen huamanbatiaʼpakeri eʼmanmadikaʼpiʼ konigti ayaʼda o̱ʼe̱. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Fariseo huamanmadikaʼeri Jesústaj e̱gkupopakte, ");
INSERT INTO amrNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—‍¿Cristotaj katiaʼ moʼtinopo̱e̱ʼ? ¿Beʼed adhueaʼ huayayo o̱ʼe̱? —‍Jesúsa oʼmanaʼuy. —‍Daviden adhueaʼ huayayo o̱ʼe̱. —‍Jesústaj oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","—‍Davidtaj Diosen Noki̱re̱ga̱ oʼnopoʼto̱e̱denok, “Cristo doʼhued Huairi meʼta̱e̱ne.” ¿Menaʼpo Davida kenpaʼ yaaʼuyate? ");
INSERT INTO amrNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Doere teyda yamanaʼikaʼ. Ayaʼda o̱ʼnen takaʼ oknopo̱e̱hueʼ hua̱e̱ʼerikon nogokaʼda huaboaʼda ontaj nigpe̱i̱kaʼdik o̱ʼneapo.” Doʼhued Huairi Cristotaj Diosa onaʼuy, aʼnennada Davida oaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“¿Doʼhued Huairi Cristo o̱ʼe̱,” David eaʼnayo Cristo Daviden adhueaʼ huayayo menpaʼ e̱ʼdik ya̱ʼe̱? —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Fariseo onʼpe̱e̱depo konig aʼtokhueʼdikda o̱ʼnepo kate onaʼdik o̱ʼe̱ nopo̱e̱hueʼda o̱ʼnuy. Onaʼti onahueʼ o̱ʼnuy. ");
INSERT INTO amrNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Huakkaʼ aratbut Jesústaj enʼtikupopakte kenpaʼti Jesúsen huanigpe̱i̱kaʼeribetaʼ o̱ʼnenok ayaʼtada Jesúsa oʼmanaʼpo: ");
INSERT INTO amrNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—‍Moisésenbaʼ huamanmadikaʼeri kenpaʼti fariseo huamanmadikaʼeriere Moisésenbaʼ manmadikaʼdik o̱ʼnikaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Konige̱po kenomeytaj yanʼmanigpe̱i̱kaʼ kenpaʼti kenda kaʼdik enaʼte kennayo ya̱gʼkikatiʼ. Konig huamanmadikaʼeria o̱gkikaʼnignayo kikahueʼ yanikatiʼ. Kenda onʼmanikaʼnignayo kikahueʼ o̱ʼnepo dakhueʼda o̱gkikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nogda nogda huakkaʼda ya̱gʼkikaʼ opudtaj monaʼikaʼnigʼa. Ayaʼda menpaʼ kikahueʼdik moʼe̱ne. Huamanmadikaʼerianayo kenda onʼmanaʼikaʼnigʼa katepiʼ sigpiʼ kahueʼdikda o̱ʼnikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Aratbuta menʼtiahuayeʼpo huamanmadikaʼeria ayaʼda o̱gkikaʼ. Aratbuta menʼtiahuayeʼpo Apagbaʼsiʼpo huanoyte onʼbetaʼikaʼ kenpaʼti huaʼopite onʼbetaʼikaʼ. Kenpaʼti aratbuta menʼtiahuayeʼpo huabida̱da o̱gkubogpiokdeaʼikaʼ huaoktaj. ");
INSERT INTO amrNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Fiesta aypo eʼbapeʼnayo huairien huahuadte eʼhuadtaʼ onʼeretpakikaʼ kenpaʼti judíoen hua̱i̱takeʼ jakyo huairien huahuadte eʼhuadtaʼ onʼeretpakikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Huakkaʼ jak eretnopoyo eʼhuaeʼte, “Iʼtiak huairi,” kenpaʼti “Iʼtiak huamanmadikaʼeri,” enaʼtaʼ onʼeretpakikaʼ. Apagbaʼ huamanmadikaʼeri kenpaʼti fariseo huamanmadikaʼeri kenpaʼ eʼpe̱i̱kaʼtaʼ onʼeretpakikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Huamanmadikaʼeri, menonaʼ,” manahueʼ yanikaʼ. Ayaʼda huamaʼbuy moʼmaene kenpaʼti nogtida Huamanmadikaʼeri moʼta̱e̱ne. Cristoyoʼda moʼta̱e̱ne. ");
INSERT INTO amrNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Kenpaʼti in huadariyo nogbokerektaj “pag,” manahueʼ yanikaʼ. Nogtida Pag moʼta̱e̱ne. Kurudyo̱ o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","“Huairi menonaʼ,” manahueʼ yanikaʼ Cristoyoʼda Huairi o̱ʼe̱nok. ");
INSERT INTO amrNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Nogtaj huabatihuapokeʼeri keʼna opuden huairi o̱ʼne. Huabatihuapokeʼeritaj Diosa oʼpak. ");
INSERT INTO amrNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kenomey “huairitoneʼ i̱jje̱y,” huataʼda huatinopo̱e̱ʼeri ehueʼdikda o̱ʼneapo. Kenomey “huairi ehueʼda i̱jje̱y,” huanopo̱e̱ʼeria konig huairi o̱ʼneapo. ");
INSERT INTO amrNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Moisésenbaʼ huamanmadikaʼeri fariseo huamanmadikaʼeriere paiʼda moʼnopoʼe̱a̱pone. Huadakda o̱ʼne, ʼuruda huamanmadikaʼeri o̱ʼne. Aratbuta opudtaj menʼtinopo̱e̱ʼpo kenpaʼda boʼeretpakikaʼne. Namaʼda huanopo̱e̱ʼeri moʼi̱kaʼne. Dakhueaʼda boʼkikaʼnok aratbut Diosensiʼpo e̱e̱ʼtaʼ eʼpakada Diosensiʼpo ehueʼdik o̱ʼneapo. Opudkon Diosensiʼpo ehueʼdik moʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Moisésenbaʼ huamanmadikaʼeri Fariseo huamanmadikaʼeriere opud paiʼda moʼnopoʼe̱a̱pone. Huadakda o̱ʼne. Namaʼda moʼmanopo̱e̱a̱ʼikaʼne. Ayhuataj huakkaʼ huakupe dehueaʼ namaʼda monaʼpo ayhuataj huid jak katepiʼ enʼta̱e̱ʼ moʼbakkayʼikaʼne, nogok aratbut eʼtiahuayte Diostaj ijhueʼnada boʼtionaʼpakikaʼne. Namaʼda boʼkikaʼne. Keʼpoda Diosa castiga mogkaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Moisésenbaʼ huamanmadikaʼeri fariseo huamanmadikaʼeriere paiʼda moʼnopoʼe̱a̱pone. Huadakda o̱ʼne. Namaʼda moʼmanopo̱e̱a̱ʼikaʼne. Namaʼda huakaʼeri moʼe̱ne. Opuden eʼmanmadikaʼtaj nogtiaʼ kanopoʼkoreʼ opudtaj moʼnigpe̱i̱keʼpo nogtaʼtipiʼ boʼukonhuahuaʼpo diga̱ʼda boʼhuaʼudhuahuaʼpo. Huadarite kenpaʼti e̱ʼpo̱gte bidteda boʼhuaʼudhuahuaʼpo. Nogtiada oʼpe̱e̱depo eʼnopoʼkoreaʼdeʼ konig opud dakhueʼda moʼe̱ne keʼnanayo dakhueʼnanada oʼyahueapo. ");
INSERT INTO amrNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Diosen jaka meknopo̱e̱nok katepiʼ Diosenpiʼ ijkikaʼapoy buttida ijjay.” Beʼapiʼ kenpaʼ eaʼada kahueʼdik e̱ʼe̱a̱da oaʼ. “Diosen jak oro huakupea meknopo̱e̱nok katepiʼ ijkikaʼapoy buttida ijjay.” Beʼapiʼ eaʼnayo kenda kaʼdik moʼe̱ne. Opuda̱ namaʼda boaʼikaʼne. Opud huamanmadikaʼeri ekpobiga̱ huabatohuaʼerionig paiʼda moʼnopoʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Namaʼda moʼnopo̱i̱kaʼne. Ekpobigo̱nig moʼe̱ne. Diostaj oknopo̱e̱hueʼ moʼe̱ne. Diosen jak o̱ʼe̱nok oroa e̱ʼti̱hui̱t Diostaj ʼuruda o̱ʼe̱. Diosen jaktanayo Diosa huakaʼ oʼpak. ");
INSERT INTO amrNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Ijkaʼapoy, buttida ijjay. Diosen ʼuhuataj eʼnigbakpaka kutopa meknopo̱e̱ne,” kenda eaʼada kahueʼ moʼi̱kaʼne. “Ijkaʼapoy, buttida ijjay. ʼUhuataj eʼnigbakpaka kutopate ʼuhua oʼhuedpo meknopo̱e̱ne eaʼnayo kaʼdik moʼe̱ne.” Opuda̱ namaʼda boaʼikaʼne ");
INSERT INTO amrNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Konig huakpobigonig Diostaj oknopo̱e̱hueʼ moʼi̱kaʼne. Diosen kutopa o̱ʼe̱nok ʼuhua Diostaj huadak o̱ʼe̱. Kutopatanayo Diosa huakkaʼ oʼpak. ");
INSERT INTO amrNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ijkaʼapoy, kutopa meknopo̱e̱ne buttida ijjay eaʼnayo kutopayoʼda oknopo̱e̱hueʼ moʼe̱ne. Kutopa ʼuhuaerea moknopo̱e̱ne. Kaʼdik moʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Kenpaʼti Diosen jaka meknopo̱e̱nok ijkaʼapoy eaʼnayo kaʼdik moʼe̱ne. Dios jakyo o̱ʼi̱kaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kenpaʼti kenda ijkaʼaponig, kuruda̱piʼ meknopo̱e̱ne buttida ijjay. Kenpaʼ eaʼnayo Diosen huahuada̱ Diosakon moknopo̱e̱nok kenda kaʼdik moʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Opud Moisésenbaʼ huamanmadikaʼeri fariseo huamanmadikaʼeriere Apagbaʼ huakkaʼ moʼnopo̱e̱nigʼa namaʼda moʼnopo̱i̱kaʼpo boʼkikaʼne. Opud paiʼda moʼnopoʼe̱a̱pone. Menta anís cominoere aypo huatokbuk Diostaj sig sig boʼyokikaʼnigʼa Diosen eʼmanmadikaʼ kenda Dios huakkaʼ oʼpak kennayo kahueʼ moʼi̱kaʼne. Opudnayo butukda huadik kikahueʼ moʼe̱ne. Nog aratbuttaj matinepahuihueʼ moʼi̱kaʼne. Kenpaʼti Diostaj oknopo̱e̱hueʼda moʼi̱kaʼne. Ayaʼ Diosen ʼuru eʼmanmadikaʼ kikaʼdik moʼe̱po, nogomeytaj butuk huadikyoʼ kikaʼdik moʼe̱po, ayaʼtada yanʼmatinepahuikaʼpo, kenpaʼti aypo huatokbukkon Diostaj yokdik moʼi̱kaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kenda Diosa pakhueʼ o̱ʼi̱kaʼnig boʼkikaʼne. Kenda Diosa huakkaʼ oʼpak opudnayo kahueʼ moʼi̱kaʼne. Opud konig ekpobiga̱ eʼbatohuaʼnig moʼi̱kaʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Opud huamanmadikaʼeri paiʼda moʼnopoʼe̱a̱pone. Huadakda o̱ʼne, ʼuruda huamanmadikaʼeri o̱ʼne. Aratbuta opudtaj menʼtinopo̱e̱ʼpo kenda boʼeretpakikaʼ. Hua̱so̱ʼtayoʼda boʼkoyoaʼikaʼne. Huanopoʼnayo dakhueʼnopoʼnada moʼi̱kaʼpo huakkaʼtada katetapiʼ boʼeretpakikaʼpo kenpaʼti moʼbakkayʼikaʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fariseo Diostaj konig ekpobigo̱nig moʼi̱kaʼne. Konig vaso huaki̱re̱gpenkon koyodik moʼi̱kaʼne, ken konig eʼnopoʼkoyoaʼ yanikaʼ. Huakkuruda nopoʼkoyoaʼdik moʼe̱ne. Moʼnopoʼkoyoaʼdepo hua̱so̱ʼkon ʼuruda o̱ʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Opud huamanmadikaʼeri paiʼda moʼnopoʼe̱a̱pone. Huadakda o̱ʼne. ʼUruda huamanmadikaʼeri o̱ʼne. Aratbut opudtaj menʼtinopo̱e̱ʼpo kenpaʼda boʼeretpakikaʼne. Konig kubaraktoneʼonig moʼe̱ne. Huid huanokbettaj yereda e̱ʼti̱hui̱tdeʼte ʼuruda e̱ʼe̱a̱da sorokya̱ʼnayo pa̱gda o̱ʼe̱po eʼbueyen huaʼay huakkaʼda o̱ʼnikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ken konig moʼi̱kaʼne. Opuden hua̱so̱ʼ ʼuruda moʼe̱nigʼa dakhueʼnopoʼ moʼi̱kaʼpo kenpaʼda namaʼda moʼnopo̱i̱kaʼpo dakhueaʼda boʼkikaʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Moisésenbaʼ huamanmadikaʼeri fariseoere paiʼnada moʼnopoʼe̱a̱pone. Huadakda o̱ʼne. Aratbuta menʼtinopo̱e̱ʼpo namaʼda moʼnopo̱i̱kaʼpo boʼkikaʼne. Apagbaʼ huamanbatiaʼpakerikudaken kubaraktaʼ konig okkahuehueʼdik huid jaksiʼpo boʼkikaʼnigʼa. Kenpaʼti huadak huakaʼerien kubarak huanokbet ʼuruaʼda botoʼkikaʼnigʼa. ");
INSERT INTO amrNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","“Oroʼen adhueyaʼpaneʼkudaka Diosen huamanbatiaʼpakeritaj onʼbatiarakikaʼuy. Oroʼ kenokaʼ e̱e̱ʼnayo batiarakahueʼ o̱ʼe̱a̱yʼuyyet.” Opuda̱ namaʼda moʼmanaʼikaʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Diosen huamanbatiaʼpakeritaj oroʼen huaoj onʼbatiarakaʼuyate. Opuda̱ huataʼda boʼhuaaʼikaʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kenda opuden huaoj huaboaʼda o̱gkikaʼuyatenig kenpaʼda ya̱gkaʼpo yanʼbatiktiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Opud konig bihui moʼe̱ne. Konig bihuien aratbut moʼe̱ne. Namaʼda huaaʼeri moʼi̱kaʼne. Kenpaʼda moʼbueyapone. Diosa castiga mogkaʼpo kenpaʼda taʼakyo moʼeonhuahuikapone. ");
INSERT INTO amrNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Opudtaj Diosen huamanbatiaʼpakeritaj ijmataʼmonaʼapoy. Diosen huanopo̱e̱ʼeritaj ijmataʼmonaʼapoy. Kenpaʼti huadak huaʼa huamanmadikaʼeritaj ijnigtaʼmonaʼapoy. Dakhueʼda moʼe̱po opuda̱ sueʼda huakkaʼmon moʼbaarakapone. Hue̱ypa cruzte nogtaj moʼbaarakapone. Nogtaj opuden hua̱i̱takeʼ jakyaʼ huiyokbiada moʼmabitbitapone. Nogtaj huakkaʼ jakyo nog huakkaʼ jakyo moʼbahuahuaʼpo dakhueʼada moʼmagkaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Konig opud judío aratbuten adhueaʼpaneʼ huairi dakhueaʼda moʼnigkikaʼuyatenok opudomeya̱kon konigti boʼkikaʼ. Huakkuru moʼdiaypo Abeltaj oʼdarakuyate. Abel ʼuruaʼda Diostaj oʼnigpe̱i̱kaʼuyate. Nogok nogda nogda Diosen huamanbatiaʼpakeritaj onʼhuadiaypo oʼdarakuyate. Taʼpote Zacarías Berequíasensiʼpotaj Diosen jak kurutaʼ oʼdarakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Opuden adhueaʼpaneʼ dakhueaʼda moʼnigkikaʼuynok opudkon dakhueaʼda boʼkikaʼnok Diosa diga̱ʼda castiga mogkaʼapone, buttida ijjay. —‍Jesúsa judío huairitaj i̱ghuaʼnanada oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","—‍Opud Jerusalén huakkaʼ jakyo hua̱e̱ʼeritaj diʼ o̱ʼnikaʼnigʼa. Diosen huamanbatiaʼpakeritaj kenpaʼti Diosen huataʼmonaʼeritaj opuda̱ moʼbatiarakikaʼuyate kenpaʼti aʼarakyaʼpo huida̱ moʼbapaʼeaʼuyate. Konig huatahuaj hua̱ye̱a̱ huasiʼpotaj okajpea oʼbatiokaʼikaʼ konigti menigaaʼ opudomeytaj aʼbatiokayaʼpo eʼkupopakataʼ ijpakikaʼuynigʼa opudnayo konig Diosensiʼpo e̱e̱ʼtaʼ pakhueʼ moʼi̱kaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Opudomeytaj Diosa bokhuaʼnede. Opuden huakkaʼ jaktaj Diosa onteʼti tiokahueʼ moʼe̱a̱po. Jak ehueʼda o̱ʼta̱e̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Onteʼti doʼtaj tiahuayhueʼ o̱ʼneonhuahuaʼapone. Kenokaʼ “Kentaj Diosa oʼtaʼmonaʼuyate ʼurunanada o̱ʼe̱. Kentaj oʼpaki.” Opudomeya̱ eadeʼte onteʼti doʼtaj onʼtiahuayapone, ijjay. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Diosen jakyaʼ Jesúsa o̱ʼo̱ro̱kdepo jak kurute eʼhuaeʼte, “Diosen huakkaʼ jak yatiahuayʼ, ʼuruda o̱ʼe̱.” Oroʼa Jesúsen huanigpe̱i̱kaʼeria Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","—‍In huid jak boʼtiahuaydenigtaj nogok ayaʼda huid onʼsakapo. Huabada sorokte nog aratbuta onʼsakaʼapo. Huid kupahuihuihueʼ o̱ʼe̱a̱po. Diosen jak ehueʼda o̱ʼe̱a̱po. Buttida ijjay. —‍Jesúsa oroʼtaj monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ken Olivos oteʼyo oʼhuaʼdeʼuy Jesús eʼhuadte oroayoʼda kentaj oʼhuahuaʼpo onaʼpo: —‍¿Menokaʼ Diosen huid jak yansakapet? ¿On onteʼti eʼtiak kenpaʼti keneʼhua̱ya̱ʼ huameʼnoe menokaʼ ya̱ʼe̱a̱pet? ¿Oroʼomey aʼnopo̱e̱yaʼpo kate huakkuru oʼtiahuayapet? —‍Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","—‍Keyoj, huakkaʼada opudtaj namaʼda enaʼte pe̱e̱hueʼ yanikatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Huakkaʼada opudtaj boʼhuatiakapone. “Cristo i̱jje̱y.” Namaʼda monaʼapet. Kenomeytaj huakkaʼada namaʼda onʼmanigpe̱e̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nogbayo nogbayo gobierno sorotataj nog gobierno sorotataj onʼbarakonhuaʼ yanʼbatiaʼpakapet. Opudnayo meʼpukhueʼ yaneʼ. Keneʼhua̱ya̱ʼ huameʼnoe tiakhued e̱e̱ʼted. ");
INSERT INTO amrNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nogbayaʼ nogbayaʼ gobierno sorotataj yanʼbarakeonhuahuaʼapet. Diga̱ʼda yanʼbarakeonhuaʼapet. Nogya̱ʼ nogya̱ʼ aratbut aypobayoʼ o̱ʼnepo yanʼmabueyonhuaʼapet, huakkaʼda dakhueʼda yanʼmamaeapet, kenpaʼti nogbayaʼ nogbayaʼ huadari ya̱ʼi̱ye̱ga̱pet. ");
INSERT INTO amrNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Kenpaʼ huaboaʼ dakhueaʼda o̱ʼe̱depo paiʼnanada yanʼnopoʼe̱a̱pet. ");
INSERT INTO amrNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Nogok doʼtaj moknopo̱i̱kaʼnok opudtaj diga̱ʼda mogkaʼapet. Opudtaj boʼarakapet. Nogba nogbayaʼ huabada opud huaknopo̱e̱ʼeritaj boʼhuadiayikaʼapet. ");
INSERT INTO amrNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kenokaʼ huakkaʼada yanoknopo̱e̱batikapet. Nog huaknopo̱e̱ʼeritaj dakhueaʼda yanʼmagkaʼapet yanʼbakude̱a̱ʼapet kenpaʼti huayahuaya yanʼbahuatitotiaʼkeapet. ");
INSERT INTO amrNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Kenpaʼti huakkaʼda huamanbatiaʼpakeri ya̱ʼneapet. Diosen huamanmadikaʼeri i̱jje̱y namaʼda yadaʼapet. Kenpaʼ onʼmonaʼnok huakkaʼada namaʼda yanoknopo̱e̱a̱pet. Onaʼti Diostaj pakhueʼ ya̱ʼneapet. ");
INSERT INTO amrNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Diga̱ʼda dakhueaʼ onʼmagkaʼaponok huaknopo̱e̱ʼeria diʼ onʼmaepo sigda sigda yanʼbatikapet. Onteʼti nog huaknopo̱e̱ʼeritaj huayahuaya suepiʼ diʼ yanʼmaeapet. ");
INSERT INTO amrNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kenomey Diostaj dakaʼda onʼnigpe̱e̱po oʼnoknopoeonhuahuikaʼpo batikhueʼda huayahuaya diʼ onʼmaeʼikaʼnignayo onʼbueydepo batikhueʼda onteʼti Diosere onʼnoeonhuahuikaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Konig ijmanmadikaʼnig, Dios Huairitaj huaknopo̱e̱ʼeri Diosensiʼpo ya̱ʼneapet. Kenda nogbayaʼ nogbayaʼ huabada yanʼmanbatiaʼpakikaʼapet. Ayaʼada yanʼmape̱a̱pet. Ayaʼada enʼmape̱e̱deikaʼte keneʼhua̱ya̱ʼ huameʼnoe ya̱ʼe̱a̱pet. ");
INSERT INTO amrNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Kenda Diostaj konig ta̱hui̱re̱gnanada o̱ʼe̱po Diosen jakyo ya̱ʼe̱a̱pet. Daniela aʼnenda oʼmadoyaʼuyate. Yanʼbonaʼpakpo yanʼnopoenkatiʼ. Kenda Diosen jakyo e̱ʼe̱deʼte yanʼtiahuaydepo ");
INSERT INTO amrNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ayaʼda aratbut Judea huadaribayo o̱ʼnepo oteʼyon i̱da kenʼmamoneʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Huabarakeri i̱dada onʼbatiaknok jak kurute opud e̱e̱ʼnayo jakyo katepiʼ moʼtamae aʼudyaʼpo kudhueʼ yanetiʼ. I̱dada yanʼmamontiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Kenomey taʼbayo o̱ʼnepo jakyo huaoktaj aʼetuyaʼpo kumejhueʼ yaneʼ. I̱dada yanʼmamontiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ettoneʼ bogdakhueʼ ya̱ʼnepo kenpaʼti ettoneʼ yo̱bed yanʼto̱e̱po onʼminognok i̱da monhueʼdik o̱ʼnenok kenomeytaj dakhueʼnanada ya̱ʼe̱a̱pet. Paiʼda yanʼnopoʼe̱a̱pet. ");
INSERT INTO amrNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Yanʼtionaʼpakikatiʼ. Huahuiʼokpiʼ uuʼok e̱e̱ʼtepiʼ monhueʼdikpiʼ a̱ʼe̱ya̱ʼpo, okmapi̱e̱ʼahuaddikte monhueʼdikpiʼ a̱ʼe̱ya̱ʼpo, yanʼtionaʼpakikatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Huakkaʼnada paiʼda yanʼnopoʼeonhuahuaʼapetnok. Keʼponanada ya̱ʼneonhuahuaʼapet. Aʼnenda sueʼda paiʼdamon onʼnopoʼe̱ʼuyate. Kenpaʼti nogok onteʼti sueʼda dakhueʼmon yanʼnopoʼe̱a̱pet. ");
INSERT INTO amrNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ayaʼada mabueyhueʼdik kaʼneʼpo kenpaʼti Diostaj huaknopo̱e̱ʼeri Diosen huabaktieʼeaʼeritaj Diosa oʼmatinepahuiʼpo “sueʼda huameʼnoe aratbut paiʼnananada kanʼnopoʼunhuahuikeʼ.” Diosa yaʼaapet. Konige̱po yanʼtionaʼpakikatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Kenokaʼ paiʼda eʼnopoʼunhuahuadeʼte “Yanʼtiahuayʼ in Cristo o̱ʼe̱.” “Yanʼtiahuayʼ a̱yo̱ Cristo o̱ʼe̱.” Beʼapiʼ enaʼnayo pe̱e̱hueʼ yanetiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Nogok “Cristo i̱jje̱y,” huabokerekapiʼ namaʼda yanʼmanaʼapet. Noga̱ “Diosen huamanbatiaʼpakeri i̱jje̱y,” namaʼda nogok nogok yanʼmanaʼapet. Diosen huabaktieʼeaʼeri namaʼda ka̱gkeʼpo namaʼda yanʼmanaʼapet. Kenpaʼti ʼuruaʼda konig Diosayoʼda kaʼdik o̱ʼe̱nig ya̱gkaʼapet kenpaʼti yanʼbayareaʼapet. ");
INSERT INTO amrNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Namaʼda huaaʼeria namaʼda yanʼbatiaʼpakapet. Namaʼda huaaʼeri tiakhued dakaʼda opudtaj onʼnopo̱e̱a̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Aratbut ehueʼ eʼnahue̱ʼyo̱ Cristo o̱ʼe̱.” Aratbuta eʼnaʼnayo huahueʼ yanetiʼ. “I̱yo̱ Cristo o̱ʼe̱ jakyo.” Beʼapiʼ enaʼnayo pe̱e̱hueʼ yanetiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Konig o̱jbedtoneʼ adteda kurudya̱ʼ eʼeypak oʼhuaikaʼ ayaʼada aratbuta nogbayaʼ nogbayaʼ onokteyoʼ onʼtiahuayikaʼ. Ken konig do onteʼti eʼtiakte aratbut nogbayaʼ nogbayaʼ onokteyoʼ onʼtiahuayapet. Doʼtaj Diosen Huasiʼpo i̱jje̱nok Diosa meʼtaʼmonaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Hua̱so̱ʼ oʼbueypo i̱da pa̱gda o̱ʼe̱. Matuk i̱da onʼbatiakikaʼ. Konigti nogok aratbut dakhueaʼda o̱gkikaʼdeaponok doere Diosen huataʼmoneriere ijhuarakapoy. Dakhueaʼ huakaʼeritaj castiga ijmagkaʼapoy. ");
INSERT INTO amrNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Kenokaʼ paiʼda enʼnopoʼunhuahuadeʼte diga̱ʼ eʼmagkadhuahuaʼ enʼbatikdeʼte niokpoakon sigpiʼ taʼtehueʼdikda ya̱ʼe̱a̱pet konigti puug jeyhueʼda ya̱ʼe̱a̱pet. Kurudya̱ʼ siokpo yakahuaapet. Kurudyo̱ hua̱e̱ʼeri huairinig yanʼkiriga̱ʼapet. ");
INSERT INTO amrNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Kenokaʼ kurudyo̱ do Diosen Huasiʼpotaʼ boʼtiahuayapet, ʼuruaʼnanada e̱e̱ʼte ayaʼada boʼtiahuayapet. Diostaj dakhueʼda o̱gkikaʼpo onʼmanokotdepo onʼmameʼpukpo diga̱ʼda onʼbahuikapo. Do eʼtiakte boʼtiahuayapet. Teynanada i̱jje̱po ʼurunanada i̱jje̱po ijhuarakapoy. ");
INSERT INTO amrNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ʼUttaʼda huatoʼkaʼpuʼ eʼtoʼkaʼte doʼhued huataʼmoneri ijmataʼmonaʼapoy. Nogyon nogyon doʼhued huabaktieʼeaʼeritaj onʼbakupopakaʼapo. Ayaʼbayaʼda onʼbakupopakaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Higuera hue̱ymeytaj ijmanbatiaʼpakapoy. Kenda dakaʼ yanʼnopo̱e̱ʼ. Huaʼopi oʼkutaʼsonpakde oʼbakutapakde huabayok oʼtiakonyak moʼnopo̱i̱kaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kenda kenpaʼ huaboda ijmanay e̱ʼe̱deʼte opud boʼtiahuaydepo kurudya̱ʼ oʼtiakdeapo nopo̱e̱ʼdik moʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ayaʼ opud aratbut bueyhued opuden huakkaʼ jaktaj takaʼ sorotataj keʼpoda mogkaʼapet. ");
INSERT INTO amrNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Doʼhued huaʼa doʼhued eʼmanmadikaʼnayo kenpaʼda o̱ʼunhuahuikaʼapo. Batikhueʼdik o̱ʼe̱a̱po. Huadari batikdik kurud batikdik doʼhued eʼmanaʼnayo batikhueʼdikda o̱ʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ken huameʼnoe oʼtiakapo kente niokpo eʼhuadte ayaʼada beʼapiʼ nopo̱e̱hueʼda o̱ʼne. Diosen huataʼmoneripiʼ kurudya̱ʼ nopo̱e̱hueʼ o̱ʼne. Do, Diosen Huasiʼpo itipiʼ nopo̱e̱hueʼ i̱jje̱y. Apag Diosayoʼda oʼnopo̱e̱. ");
INSERT INTO amrNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Konig aʼnenda Noékudak e̱e̱ʼte aratbut hua̱hue̱ e̱ʼpo̱gtaj onmabohueʼ o̱ʼnuy. Do eʼtiakte konigti o̱ʼe̱a̱po. Aratbut doʼtaj onmaboikahueʼ o̱ʼneapo. ");
INSERT INTO amrNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Aʼnenda Noé eʼnoete hue̱kurutoneʼ tiakhued e̱e̱ʼted aratbut onʼbapeikaʼ, onʼmamayʼikaʼ, onʼto̱e̱pakikaʼ, kenpaʼda o̱gkikaʼuy. Diostaj nopoʼkoreahueʼda Noéomey kusiʼpetoneʼyo e̱gkuddeʼte ");
INSERT INTO amrNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","kenpaʼti hue̱kurutoneʼ oʼtiakapo oknopo̱e̱hueʼ o̱ʼnuy. Eʼtiakte entaʼkotdeʼte huaboaʼda onʼnokotuyate. Kenokaʼ hue̱kurua ayaʼda oʼbatohuaʼuyate. Do eʼtiakte konigti ya̱ʼneapet. ");
INSERT INTO amrNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Do eʼtiakte taʼbayo bottaʼ huabokerek ya̱ʼneapet. Diosen huataʼmoneria nogtatida yanoktohuaʼapet. Nogtaj yaʼnenonapet. ");
INSERT INTO amrNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Bottaʼ ettoneʼa̱ yanʼbataruaʼapet. Diosen huataʼmoneria nogtatida yanʼtohuaʼapet. Nogtaj yaʼnenonapet. ");
INSERT INTO amrNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Kenokaʼ do opuden Huairi oʼtiakdeapo nopo̱e̱hueʼ moʼe̱po, dakaʼ e̱kpo̱e̱ʼ menigi̱katiʼ opuda̱nayo. ");
INSERT INTO amrNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Jak hua̱ta̱e̱ʼeri eʼtayte huabereʼeri aʼbereyaʼpo onʼtiakikaʼ. Ken horate huabereʼeri oʼtiakapo jak hua̱ta̱e̱ʼeri eʼnopo̱e̱ʼnayo tayhueʼ o̱ʼe̱po huabereʼeritaj oʼmabonok berehueʼdik o̱ʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Konigti opud kenpaʼti doʼtaj dakaʼ maboikaʼdik moʼi̱kaʼne. Kenokaʼ Huairi oʼtiakapo nopo̱e̱hueʼ e̱ʼneʼte ijtiakapoy. ");
INSERT INTO amrNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Huaknopo̱e̱ʼeritaj ʼuruaʼnanada huatamato̱e̱ʼeritaʼ Diosa oʼpakikaʼ. ʼUruaʼnanada huatamato̱e̱ʼeria huaknopo̱e̱ʼeritaj dakaʼ onʼmanmadikikaʼ kenpaʼti dakaʼ onʼmato̱i̱kaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Do eʼtiakte huatamato̱e̱ʼeri dakaʼda onʼnigpe̱i̱kaʼpo huadakda eʼmanmadikikaʼnayo kenpaʼti ʼuruda nog huaknopo̱e̱ʼeritaj eʼtihuapokikaʼnayo durugda o̱ʼneapo. ");
INSERT INTO amrNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Dakaʼda Diosen o̱gkikaʼpo ayaʼda Diosen eʼtamaeʼ onʼto̱i̱kaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Doʼhued huairi ijhueʼda ya̱ʼe̱po yatiakapet namaʼda eʼnopo̱e̱ʼnayo kenpaʼti ");
INSERT INTO amrNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Diosen huaknopo̱e̱ʼeritaj eʼmabitbitnayo kenpaʼti sineʼ huakkuda̱ʼeriere eʼbapeʼikaʼnayo kenpaʼti kenomeyere eʼmamayʼikaʼnayo ");
INSERT INTO amrNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","kenokaʼ Huairitaj mabohueʼ eneʼte ijtiakapoy. Kenmeʼnoete nopo̱e̱hueʼ e̱e̱ʼte ijtiakapoy. ");
INSERT INTO amrNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Kenomeytaj diga̱ʼda oʼnogkaʼapone. Namaʼda huaaʼeri dakhueaʼda o̱ʼnenok kenomeyere oʼnogkaʼapone. Ke̱yo̱da aratbut paiʼda onʼnopoʼi̱kaʼ kenpaʼti diga̱ʼda onʼbahuikikaʼ ke̱yo̱ kenomeytaj ijmaenapoy. ");
INSERT INTO amrNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Konig Dios Huairien hueretda huanigpe̱i̱kaʼeri, Dios Huairiensiʼpo o̱ʼnepo dakaʼ e̱kpo̱e̱ʼ onʼnigonhuahuikaʼdepo durugda Diosyo onʼbakudapo. Ken konig o̱ʼe̱ ijmanbatiaʼpakapoy. Konig opud judío aratbut o̱gkikaʼ huabokerek aʼto̱e̱pakyaʼpo sikyo hua̱to̱e̱ aeʼyaʼpo oʼtiakapo. Kentaj aʼdeatuyaʼpo diez muneʼyo̱a̱ sikyo onʼhuahuaʼuy. Huasihuaj huakjeysiʼpo oʼnonto̱e̱ʼe̱po onʼhuahuaʼuy. Muneʼyo̱ konig Jesúsen huaknopo̱e̱ʼeri o̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Huabaniga̱ʼ dakaʼ nopo̱e̱hueʼada o̱ʼnuy. Nog huabaniga̱ʼ dakaʼda onʼnopo̱e̱po huadakda o̱gkikaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Dakaʼ manopo̱e̱ʼ ehueʼada muneʼyo̱ sueʼda huasihuaj oʼnontohuaʼuy. Nog huasihuaj ontohuaehueʼ o̱ʼnuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Nog muneʼyo̱a̱nayo nog huasihuaj oʼnontohuaeʼuyate. Diosen Noki̱re̱ga̱ oʼmanopoʼto̱i̱kaʼnok Diosen ʼuruaʼda o̱gkikaʼpo huabokerektaj ke̱yo̱da onʼnigu̱yate. Huasihuaj konig Diosen Noki̱re̱g o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Huabokerek aʼto̱e̱pakyaʼpo ijhueʼtaʼda oʼtiaknok ayaʼda oʼnokbataiʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ken sikyo nopokaʼ “Ken huabokerek aʼto̱e̱pakyaʼpo oʼtiakde. Kentaj yanʼdej.” ʼUttaʼda ayaʼada onʼpe̱e̱deʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ayaʼada muneʼyo̱ onʼmamaboʼuyate. Huakjeysiʼpotaj aʼbakpakayaʼpo o̱gkaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Dakaʼ manopo̱e̱ʼ ehueʼada hua̱e̱ʼeria muneʼyo̱ nog muneʼyo̱taj onʼmanaʼpo: “Sueʼda huasihuaj beyok. Oroʼen huakjey oʼbakayde.” Onʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Kejeʼ sueʼda moʼta̱e̱ne. Yokhueʼdik o̱ʼnene. Huabahuayaʼerite yanhuaʼ. Ke̱yo̱ ya̱ʼdetuʼ.” Dakaʼda huanopo̱e̱ʼeri muneʼyo̱a̱ onʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Nog huabaniga̱ʼ dakaʼ nopo̱e̱hueʼada hua̱e̱ʼeri muneʼyo̱ huasihuate enhuadeʼte huabokerekakon oʼtiakuy. Keʼna aʼto̱e̱pakyaʼpo oʼtiakuy. Kenere huabaniga̱ʼ muneʼyo̱ Diosen Noki̱re̱ga̱ oʼmanopoʼto̱i̱kaʼnok dakaʼda Diostaj onʼnigpe̱i̱kaʼpo jakyo eʼto̱e̱pak fiestate onʼkuduyate. Onʼkuddepo akbogpe oʼnokhuikuy. ");
INSERT INTO amrNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Aʼtimon huabaniga̱ʼ dakaʼ nopo̱e̱hueʼada hua̱e̱ʼeri muneʼyo̱ onʼtiakuy. “Monigokhuikeʼ, Huairi.” Oʼnonaʼuynigʼa. ");
INSERT INTO amrNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Opudtaj o̱ki̱e̱hueʼ o̱ʼnene. Buttida ijjay.” Huairia oʼmanaʼuy. Ken konig ya̱ʼe̱a̱pet. —‍Jesúsa oʼmanbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","—‍Konige̱po Diosen dakaʼda ya̱gʼkikatiʼ. Batikhueʼda do eʼtiakapote e̱kpo̱e̱ʼ yanikatiʼ. —‍Jesúsa monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","—‍Konig Dios Huairien hueretda huanigpe̱i̱kaʼeri, Dios Huairiensiʼpo o̱ʼnepo kiriga̱yo̱ʼ Diosen o̱gkikaʼ. Konig huairi huanabaʼ oʼmato̱e̱po nogbayo aʼti oʼhuaʼdepo huanabaʼtaj keʼnen huakupe oʼbaktoyokeʼuyate. Gana menʼtakadhuahueʼpo oʼbaktoyokeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Nogtatida huabaniga̱ʼ mil huakupe oktoyokuyate. Nogtaj bottaʼ mil huakupe oktoyokuyate. Nogtaj nogtida mil huakupe oktoyokuyate. Konig gana menʼtakeʼpo huakkaʼ huanopo̱e̱ʼeritaj huakkaʼmon oʼbaktoyokuyate. Sueʼda huanopo̱e̱ʼeritaj huakkahueʼ oʼbaktoyokuyate. Oʼbayokdepo nogbayo oʼbakhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Keʼna huanabaʼ huabaniga̱ʼ mil huakupe oʼedepo nogok nogok oʼbaeʼ kenpaʼti oʼbahuayaʼ. Dakaʼda oʼkikaʼdepo nog huabaniga̱ʼ mil huakupe o̱ʼi̱takaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Konigti oʼkaʼpo noga̱ bottaʼ mil oʼto̱e̱po nog bottaʼ mil huakupe o̱ʼi̱takaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Kennayo nogtida mil oʼedepo sorokyo oʼmaʼi̱re̱ga̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Huairi ijhueʼda o̱ʼe̱depo onteʼti oʼtiakuyate. “Yanʼtiak.” Huakupe huato̱e̱ʼeritaj oʼmanaʼpo enʼtiakte, “Men doʼhued huakupe moʼto̱e̱,” oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Keʼna huabaniga̱ʼ mil huakupe oeʼuy huakkuru oʼhuatiakuy. Huairitaj botbaniga̱ʼ mil huakupekon oʼtabahuaʼuyate. “Huabaniga̱ʼ mil huakupe bekuyne. Nog huabaniga̱ʼ mil i̱ji̱takaʼmey. In botbaniga̱ʼ mil huakupe iʼtamaene, Huairi.” Onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Huadakda huanabaʼ o̱ʼta̱e̱ne o̱ʼna. Dakaʼda iʼkikaʼnok. Batikhueʼda iʼkikaʼ. Sueʼda doʼhued meʼta̱e̱meʼnigʼa dakaʼda iʼkikaʼtenok huakkaʼda doʼhued meʼta̱e̱a̱pone. Doere iʼdurugpakapone.” Huairia onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Noga̱kon huanabaʼ bottaʼ mil huakupe oeʼuyate huairite oʼhuatiakpo “Bottaʼ mil huakupe bektoyokuyne. Nog bottaʼ mil huakupe i̱ji̱takaʼmey. In bottaʼ bottaʼ mil huakupe iʼta̱e̱ne, Huairi.” Keʼna huanabaʼa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Huadakda huanabaʼ meʼta̱e̱ne. Dakaʼda iʼkikate. Sueʼda doʼhued meʼta̱e̱meʼnigʼa dakaʼda iʼkikaʼtenok huakkaʼda doʼhued meʼta̱e̱a̱pone. Doere iʼdurugpakapone.” Huairia onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Keʼna nogtida mil huakupe oeʼuy huairitaj oʼhuatiakdepo “O̱ʼna baʼtey o̱ʼe̱piʼ, ijnopo̱e̱po o̱ʼnen huanabaʼ diga̱ʼda enʼbaaʼtada ayaʼda iʼbakbaeʼikaʼ. Huanabaʼen ehueʼda o̱ʼe̱. Huakid batukehueʼada iʼbakbakayikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Konige̱po ijmeʼpukpo o̱ʼnen huakupe sorokyo ijmaire̱ga̱ʼuy. In o̱ʼnen iʼta̱e̱ne.” Ken huanabaʼa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“On huanabaʼ dakhueʼda i̱ʼe̱ne. Baahueʼ hua̱e̱ʼeri i̱ʼe̱ne. Do baahueʼda oʼbakbaikaʼ kenpaʼti batukhueʼ e̱ʼe̱a̱da huakid oʼbakbaikaʼ iʼnopo̱e̱po ");
INSERT INTO amrNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","konige̱po doʼhued huakupe bancoyo eʼkuda̱meʼnayo do eʼtiakdeʼte doʼhued huakupe nogi̱ti huakupe menʼtahuayetnigʼa.” Huanabaʼtaj huairia onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Nogomey kenteda e̱ʼneʼte “Ken mil huakupe huanabaʼ oʼto̱e̱ yaʼnokkayʼ. Keʼna diez mil oʼto̱e̱nigtaj yanʼyok. ");
INSERT INTO amrNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ayaʼada sueʼda huakkaʼ onʼto̱e̱po dakaʼda eʼto̱i̱kaʼnayo dakaʼda eʼkikaʼnayo kenomeyen huairia oʼpakpo nogi̱ti oʼbayokapo. Nogomey sueʼda onʼto̱e̱po dakaʼda to̱e̱hueʼ e̱e̱ʼnayo dakaʼda kikahueʼ e̱e̱ʼnayo kenpaʼti nogda i̱takahueʼ e̱e̱ʼnayo kenomeyen huairi kenda sueʼda onʼto̱e̱nigtaj oʼbaktiparatapo. ");
INSERT INTO amrNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ken dakhueʼ huanabaʼtaj ke̱yo̱da sikki̱re̱gda o̱ʼi̱kaʼ, ke̱yo̱da kenpaʼda paiʼda onʼnopoʼi̱kaʼ, ke̱yo̱da yaʼnenʼ.” Huairia oʼmanaʼuyate. —‍Jesúsa ken konig oʼmanbatiaʼpakpo oʼmanmadikaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","—‍Diosa doʼtaj meʼtaʼmonaʼuyne. Nogok do onteʼti ijtiakapoy. Onteʼti konig huairitoneʼ ʼuruaʼda i̱jje̱po doere ayaʼda Diosen huataʼmoneriere oʼtiakapoy. Kenokaʼ Dios Huairien ʼuruaʼda huahuadte konig huamataʼmonaʼ huairi ijhuadapoy. ");
INSERT INTO amrNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ayaʼada nogbayo nogbayo hua̱e̱ʼeria doʼtaj menhuatiakapone. Doʼtaj e̱gkupopakte ijbaktieʼeaʼapoy. Konig oveja huato̱e̱ʼeria ovejataj cabra ʼuhua oʼbakupopakaʼikaʼ ken konig ijkaʼapoy. ");
INSERT INTO amrNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Oveja konig Diosen huabaktieʼeaʼeri ʼuruda Diosen huaʼa huanigpe̱e̱ʼeri doʼhued huadaʼkopen ijkupopakaʼapoy. Cabra konig Diosen huabaktieʼeaʼeri ehueʼda namaʼda huakaʼeritaj doʼhued opeʼtopen ijkupopakaʼapoy. ");
INSERT INTO amrNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ijbakupopakaʼdepo doʼhued huadaʼkopen hua̱e̱ʼeritaj “Yanʼtiak. Opudtaj doʼhued Apaga̱ oʼmadurugpakaʼuyate. Huadari kurud Diosa aʼnenda oʼkaʼpo doʼhuedsiʼpo o̱ʼneapo Diosa oʼnopo̱e̱ʼuyate. Oyda Diosensiʼpo moʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Aypotaʼ eʼkusitokte aypo onʼyokuyne. Maymaya̱ʼ eaʼte hue̱ʼe̱y onʼyokuyne. Nogbayo eʼhuaeʼte huatayʼ onʼyokuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Yudtaj to̱e̱hueʼ e̱e̱ʼte onʼyokuyne. Dakhueʼ, e̱e̱ʼte onʼtaʼhuade̱ʼu̱yne. Huabakuda̱ʼ jakyo e̱e̱ʼte doʼtaj onʼtaʼhuade̱ʼu̱yne.” Do Diosen Huairi huadaʼkopen hua̱e̱ʼeritaj ijmanaʼapoy. ");
INSERT INTO amrNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Menok kenpaʼ kahueʼ o̱ʼu̱y ontaj. O̱ʼna aypotaʼ eʼkusitokte aypo yokhueʼ o̱ʼu̱yne. Maymaya̱ʼ eaʼte hue̱ʼe̱y yokhueʼ o̱ʼu̱y. ");
INSERT INTO amrNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","O̱ʼna nogbayo eʼhuaeʼte oroʼen jakyo katayeʼpo kuda̱hueʼ o̱ʼu̱y. Yudtaj to̱e̱hueʼ e̱e̱ʼte menok yokhueʼ o̱ʼu̱yne. ");
INSERT INTO amrNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Dakhueʼ e̱e̱ʼte kenpaʼti huabakuda̱ʼ jakyo e̱e̱ʼte onʼtaj taʼhuade̱hueʼ o̱ʼu̱yne, Huairi.” Huadak huakaʼeria doʼtaj kenpaʼ boaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Kenokaʼ inomey doʼhued huamaʼbuytaj boʼkaʼuyate kenda doʼtaj hueretda boʼkaʼuyne.” Do Diosen Huairia ijmanaʼapoy. ");
INSERT INTO amrNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Aratbut opeʼtopen Diosen huabaktieʼeaʼeri ehueʼ e̱ʼhua̱e̱ʼtaj “Menokbahuaʼ. Opudtaj Diosa diga̱ʼ castiga magkaʼdik moʼe̱a̱pone. Bakpak batikhueʼda e̱ʼi̱kaʼyo yanhuatiʼ. Ken taʼakyo castiga aʼmagkayaʼpo totoʼtaj kenpaʼti totoʼen huataʼmoneritaj Diosa oʼnigkaʼde. ");
INSERT INTO amrNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Aypotaʼ e̱e̱ʼtada yokhueʼ o̱ʼneʼuyne. Maymaya̱ʼ eaʼtada yokhueʼ o̱ʼneʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nogbayo eʼhuaeʼte huatayʼ yokhueʼ o̱ʼneʼuyne. Yudtaj to̱e̱hueʼ e̱e̱ʼte yokhueʼ o̱ʼneʼuyne. Dakhueʼ e̱e̱ʼte kenpaʼti huabakuda̱ʼ jakyo e̱e̱ʼte doʼtaj taʼhuadehueʼ o̱ʼneʼuyne.” Do Diosen Huairia ijmanaʼapoy. ");
INSERT INTO amrNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ehueʼ ontaj eʼkusitokte tiahuayhueʼda maymaya̱ʼ eaʼte tiahuayhueʼda o̱ʼna nogbayo eʼhuaeʼte kenpaʼti yudtaj to̱e̱hueʼ e̱e̱ʼte kenpaʼti dakhueʼda e̱e̱ʼte huabakuda̱ʼ jakyo e̱e̱ʼte tiahuayhueʼ o̱ʼe̱ʼuyne. Konige̱po ontaj tihuapokhueʼ o̱ʼe̱ʼuy, Huairi.” Opeʼtopen huakupopakeria doʼtaj monaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Inomey doʼhued huamaʼbuy doʼhued huaknopo̱e̱ʼeri huairihueʼda kenpaʼti konig paiʼda e̱ʼneʼtada batihuapokhueʼda moʼi̱kaʼuynok konige̱po doʼtada konig tihuapokhueʼ o̱ʼnuyne. Buttida ijjay.” Ijmanaʼapoy. ");
INSERT INTO amrNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Kenomey opeʼtopen huakupoboʼeri Diosen castigayo kenpaʼda oʼnokbahuaʼapo. Kenpaʼda paiʼda onʼnopoʼunhuahuikaʼapo. Diosen ʼuruda huakikaʼeri kenpaʼda Diosere onʼnoeonhuahuikaʼapo. —‍Jesúsa oroʼtaj monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Kenpaʼ ayaʼda Jesúsa oroʼtaj monaʼdepo nogdakon monaʼpo: ");
INSERT INTO amrNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—‍Emeʼtekentaʼ judío huakkurueri isiʼpo mabueyhueʼ e̱e̱ʼ okkahuehueʼ fiesta o̱ʼe̱a̱po, moʼnopo̱e̱ne. Doʼtaj cruzte kanʼarakeʼpo judío huairitaj nogbokerekaʼtida meʼbahuayaʼapone —‍Jesúsa monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Jesúsa kenpaʼ eaʼte sacerdote, Moisésenbaʼ huamanmadikaʼeri, judío huairitoneʼ, Caifás sacerdote huairien jak kurute onʼkupopakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ke̱ya̱ʼ monig Jesústaj i̱re̱gi̱re̱g oʼtotiakapet kenpaʼti monig oʼarakapet onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","—‍Fiesta e̱e̱ʼte arakhueʼdik o̱ʼe̱ne. Kenokaʼ eʼaraknayo aratbut moʼhuadiaypo ʼuttaʼda boyʼdik moʼe̱a̱pone. —‍Judío huairia onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Eʼsiʼdaksetaʼ Simóntaj onʼdikkaʼuyate. Oʼsiʼdakyareʼuyate. Betania huakkaʼ jakyo Simónen jakyo Jesús e̱e̱ʼte ");
INSERT INTO amrNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ettoneʼa̱ Jesústaj oʼhuahuaʼpo huid yerepuʼte ʼuruʼhui̱e̱da huasihuaj huakkaʼteda e̱e̱ʼtada oʼtohuaʼuy. Jesús huabapeʼ kutopate eʼhuadte ʼuruʼhui̱e̱a̱da huasihuaj oʼkutioyʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Sueʼada Jesúsen huanigpe̱i̱kaʼeria eʼkutioy onʼtiahuaydepo onʼhuadiayonpo, —‍Menaʼpo huakkaʼteda e̱e̱ʼtada namaʼda injoy. ");
INSERT INTO amrNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Onjoyhued e̱e̱ʼnayo huakkaʼteda bahuayaʼdik huakupe paiʼda aratbuttaj bayokdik o̱ʼe̱a̱yʼnigʼa. —‍Huanigpe̱i̱kaʼeria nopo̱e̱hueʼ o̱ʼnepo onʼdaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","—‍In ettoneʼtaj namaʼda iʼkaʼne onahueʼ yaneʼ. ʼUruaʼda megkaʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Opudere paiʼda aratbut o̱ʼnikaʼapo. Donayo opudere ehueʼ i̱ji̱kaʼapoy. ");
INSERT INTO amrNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","In huasihuaj beʼtioyne doʼhued hua̱so̱ʼ eʼkubarakkaʼ ikkenda beʼsihuakaʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Do aratbuttaj aʼmanopoʼkoreayaʼpo moʼnigbueyʼuy. Meya̱piʼ ayaʼda huadaribayaʼ kenpaʼ onʼmanbatiaʼpakikaʼapo kenda in ettoneʼ megkaʼnigkon onʼmanbatiaʼpakikaʼapo. Ken ettoneʼtaj okkahuehueʼ o̱ʼnikaʼapo. —‍Jesúsa monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Doce Jesúsen huataʼmoneri o̱ʼnepo nogtida Judas Iscariote e̱ʼe̱a̱da oʼbakhuaʼuy. Judío sacerdote huairitaj aʼbatiaʼpakyaʼpo oʼbahuahuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","—‍¿Jesús opudtaj eʼyoknayo meniga̱ʼ huakupe doʼtaj yokdik o̱ʼne? —‍Judasa sacerdote huairitaj oʼmanaʼuy. Ken Judastaj treinta plata huakupe onʼyokuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Huaboaʼda Jesústaj sacerdote huairitaj monig ijbayokapet Judasa oʼnopo̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ken huameʼnoe judío huakkurueri isiʼpo mabueyhueʼ e̱e̱ʼ okkahuehueʼ fiesta huakkuru huameʼnoe o̱ʼu̱y. Oroʼ Jesústaj oʼhuahuaʼpo, —‍¿Meya̱ʼ fiesta aypo manhuada̱ʼdik o̱ʼe̱a̱po? —‍Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","—‍Jerusalényo̱ yanhuaʼ. Huabokerektaj boʼhuahuayapet, “Aʼti ijbueyapoy. O̱ʼnen jakyo doʼhued huanigpe̱i̱kaʼeriere fiesta aypo oʼbapeʼapoy. Huamanmadikaʼeria oaʼ.” Ken huabokerektaj ya̱ʼnonatiʼ. —‍Jesúsa monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Kenda Jesúsa monaʼnig oroʼa oʼkaʼpo fiesta aypo oʼmanhuada̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Esikdeʼte Jesús doce huanigpe̱i̱kaʼeriere kutopate o̱ʼe̱po ");
INSERT INTO amrNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","oʼbapeʼpo, —‍Judío huairia doʼtaj kadarakeʼpo opud nogtiada doʼtaj moʼbayokapone. Buttida ijjay. —‍Oroʼtaj Jesúsa monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ken huaboaʼda suhueʼnada o̱ʼu̱y oroʼ. Noga̱ noga̱ Jesústaj onaʼpo: —‍Doapiʼ oʼyokapetpiʼ, Huairi. —‍Oroʼa noga̱ noga̱ onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","—‍Keʼna doere aypo huabapeʼte oʼbapeʼdenigʼa keʼnada judío huairitaj meʼbahuayaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Konig Apagbaʼte oaʼikaʼ doʼtaj o̱gkaʼaponiga̱ keʼna meʼbahuayaʼapone. Kentaj keʼponada o̱ʼe̱a̱po. Paiʼnada oʼnopoʼunhuahuikaʼapo. Keʼna aʼnen siʼpoe̱hueʼ e̱ʼu̱ynayo huadakda o̱ʼe̱a̱ynigʼa. —‍Jesúsa oroʼtaj monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","—‍Doʼhuapiʼ oʼbahuayaʼapetpiʼ. —‍Jesústaj Judasa namaʼda onaʼnigʼa keʼna judío huairitaj oʼyokapo. —‍E̱e̱ʼ o̱ʼna oʼbahuayaʼapone. —‍Jesúsa Judastaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Oʼbapeʼpo Jesúsa pan oʼbapadpo, “dakiti Dios” oaʼdepo oʼposakeaʼpo oroʼtaj boʼyokeʼpo, —‍Yanʼbapeʼ. In pan doʼhued hua̱so̱ʼ o̱ʼe̱. —‍Oroʼtaj monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Aʼtimon vino huamaiʼpuʼ oʼto̱e̱po “dakiti Dios” onaʼdepo oroʼtaj boʼyokpo, —‍Opud ayaʼada yanʼmaiʼ ");
INSERT INTO amrNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Doʼhued mimi o̱ʼe̱. Aratbuten dakhueaʼ eʼkaʼ ijbakkahueaʼapoy. Huaboaʼda ijjay. Opudtaj aʼnopo̱e̱a̱yaʼpo ijbueydepo doʼhued mimi oʼhuaʼapo. Aratbuten dakhueaʼ eʼkaʼ akkahueayaʼpo doʼhued mimi oʼmanighuaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Aʼti in vino mayhueʼ i̱ji̱kaʼapoy. Nogok doʼhued Apag Dios Huairitaj ayaʼda huaknopo̱e̱ʼeria huaboaʼda enʼnigpe̱i̱kadeʼte onteʼti vino ijmayapoy. —‍Jesúsa monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Diostaj eʼbatadiʼkeaʼdeʼ huakkaʼ jak Jerusalénya̱ʼ oʼnoro̱kdepo oteʼ Olivosyo sikyo oʼhuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","—‍In sikyo opud ayaʼda doʼtaj oʼnokmabirada̱pone. Doʼtaj oʼnokmamonapone. “Oveja huamato̱e̱ʼeritaj ekarakte oveja oʼnokmamonapo.” Apagbaʼte kenpaʼ oaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Nogok huakudakaʼda e̱ʼe̱a̱da ijnoyhuaddeapoy Galileayo huakkuruda ijhuaʼapoy. Opud taʼpotaʼ boʼtiakapone. —‍Jesúsa oroʼtaj monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","—‍Nogomey bokbiradpo ekmamonpiʼ donayo okbiradhueʼ i̱jje̱a̱poy. —‍Pedroa Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","—‍Oyda in sikyo huatahuaj sipoghued “Jesústaj jo̱ki̱a̱hueʼya i̱jje̱y.” Bapaʼaʼ iaʼapone. Buttida ijjay. —‍Jesúsa Pedrotaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","—‍Ehueʼ onere bueydik e̱e̱ʼpiʼ “Jesústaj jo̱ki̱a̱hueʼya i̱jje̱y,” ahueʼ i̱jje̱a̱poy. —‍Pedroa onaʼuy. Oroʼ Jesúsen huanigpe̱i̱kaʼeria konigti ayaʼada onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ken sikyoda Getsemaní taʼbayo Jesús oroʼ keʼnen huanigpe̱i̱kaʼeriere o̱kye̱ʼuy. —‍Inteda yanʼbahuadtiʼ. A̱yo̱ aʼtionaʼpakyaʼpo ijhuaʼapoy. —‍Jesúsa oroʼtaj monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pedrotaj kenpaʼti Zebedeoen bottaʼ huasiʼpo Juan Jacobotaj oʼbatohuaʼdepo Jesús huaboaʼda suhueʼnanada o̱ʼe̱po kenpaʼti paiʼnanada oʼnopoʼe̱po, ");
INSERT INTO amrNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","—‍Konig ijbueyapopo paiʼnanada ijnopoʼe̱y. I̱yo̱da menʼnige̱ʼ. Doere yanokpoehueʼ. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ken Jesús nogi̱ti adyonda oʼhuaʼdepo okkubukaʼ oʼhuedpo oʼtionaʼpakpo: —‍Do paiʼda nopoʼe̱hueʼ ka̱e̱ʼpo tihuapokdik e̱e̱ʼnayo konig do ijpaknig kahueʼ ya̱e̱ʼ. Konig kenda on iʼpakpo megkaʼ, doʼhued pag. —‍Jesúsa oʼtionaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ken Pedromeytaj oʼbahuahuaʼpo enʼbatayte oʼbahuahuayʼuy. —‍Nogoratipiʼ menaʼpo doere okpoehuehueʼdik moʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Namaʼda kahueʼ a̱ʼe̱ya̱ʼpo yanokpoehueʼ yanʼtionaʼpak. Huadak eʼkikaʼtaʼ boʼeretpaknigʼa kahueʼdik moʼe̱ne. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Onteʼti aʼtionaʼpakyaʼpo adyonda oʼbakhuaʼuy. —‍Doʼhuada paiʼda eʼnopoʼe̱taʼ pakhueʼ i̱jje̱y. Kenpaʼti eʼbueytaʼ pakhueʼ i̱jje̱nok konig kenda on ipaknok bueydik a̱ʼe̱yʼ, doʼhued pag. —‍Jesúsa oʼtionaʼpakondepo ");
INSERT INTO amrNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","onteʼti huanigpe̱i̱kaʼeritaj oʼbahuatiakuy. Entayte oʼbahuahuayatoʼuy. Taytayaʼ ijjay. Huakkaʼ oʼdaʼnok. ");
INSERT INTO amrNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Oʼbakhuaʼdepo bapaʼaʼ oʼtionaʼpakuyate. Konigti oʼtionaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ken oʼtionaʼpakondepo huanigpe̱i̱kaʼeritaj oʼbahuatiakpo, —‍Oyiti̱e̱yo̱ yanʼhuedtiʼ, yanʼtaytiʼ. Oy dakhueaʼ huakaʼeritaj doʼtaj menʼbahuayaʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Yanʼmaboʼ monhuaʼ. Keʼna menʼbahuayaʼdene oʼtiakde. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesúsa kenpaʼ eʼmanaʼted Judas oʼtiakdeʼuy. Jesúsen doce huanigpe̱i̱kaʼeri Judas nogtida o̱ʼu̱y. Judasere huakkaʼda onʼbatiakbedu̱yate. Sorotataen siroenpa noga̱ hue̱ypa onʼtotiakpo onʼbatiakbedu̱yate. Sacerdote huairi judío huairitoneʼa onʼmataʼmonaʼnok onʼbatiakbedu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","—‍Kentaj boʼpaknigtaj ijbuyukapoy yanʼtohuatiʼ. —‍Kenpaʼ Judas huabahuayaʼeri tiakhued o̱ʼe̱po oʼmanaʼuyate. Jesústaj kaʼnoki̱e̱ʼpo kenpaʼ oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ken Judas Jesústaj oʼhuahuatoʼpo, —‍Ijtiaki, Huamanmadikaʼeri, —‍onaʼdepo oʼbuyukuy. ");
INSERT INTO amrNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","—‍¿Katete iʼtiak huadiʼ? —‍Jesúsa onaʼuy. Nogomeya̱ Jesústaj onʼtaʼkoyatoʼ onʼtohuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ken nogtiada huanigpe̱i̱kaʼeria siroenpa oʼto̱e̱po sacerdote huairien huanabaʼtaj oʼpesodokteguy. ");
INSERT INTO amrNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","—‍Siro yakuda̱ʼ. Kenomey kenpaʼti siroa o̱gkaʼpo siroa mabueydik o̱ʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","54","Setenta mil Diosen huataʼmoneri sorotataj menigtaʼmonaʼ, pag. Oyedda doʼhued Apag Diostaj tionaʼpakdik i̱jje̱a̱yetnigʼa, kenda eʼtionaʼpaknayo i̱dada menigtaʼmonayetnigʼa inomey doʼtaj tohuaʼdik o̱ʼne. Apagbaʼte oaʼikaʼnok kenpaʼ tionaʼpakhueʼdik i̱jje̱y. —‍Jesúsa Pedrotaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Kenokaʼ huakkaʼ aratbuttaj: —‍Konig huiyokda huabereʼeritaj aʼtohuayaʼpo moʼbahuahuikaʼ. Konigti doʼtaj onʼhuatiakbedne. Siroenpa moʼto̱e̱po hue̱ypa moʼto̱e̱po doʼtaj onʼhuatiakbedne. ¿Menaʼpo? Diosen jakyo ayaʼda huameʼnoe ijhuadpo ijmanmadikaʼikay. Kenokaʼ doʼtaj tohuahueʼ o̱ʼnikaʼne. ");
INSERT INTO amrNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Konig Diosen huamanbatiaʼpakeria Apagbaʼte mentimadoyaʼuyate. Konigda opud doʼtaj kaʼdik o̱ʼnene. —‍Jesúsa oʼmanaʼuy. Eadeʼte oroʼ Jesúsen huanigpe̱i̱kaʼeria Jesústaj okmamonʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Caifáste onʼtohuaʼuyate. Caifás sacerdote huairitoneʼ o̱ʼi̱kaʼuy. Caifásen jakyo ayaʼ judío huairi onʼkupopakbedu̱y. ");
INSERT INTO amrNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pedronayo adteda Jesústaj oʼtaʼhuaʼuyate. Sacerdote huairien kurute oʼtiakdepo eʼtiokpakaʼyo oʼkudpo sorotataere oʼhuadonhuaʼpo, Jesústaj menpaʼ yanogkaʼapet oʼnopo̱e̱po aʼtiahuayaʼpo oʼhuadonhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Sacerdote huairiere huatoneʼ huairiere kenpaʼti ayaʼda nog judío huairi o̱gkupopakpo, “Jesúsa dakhueaʼda oʼkaʼ.” “Jesúsa namaʼda oaʼ.” Beʼapiʼ kenpaʼ aʼhuaayaʼpo oʼdikuk. Nogpaʼ nogpaʼ namaʼda aʼhuaayaʼpo kenpaʼti onʼdikukpo Jesús kabueyeʼ, eaʼtaʼ oʼderetpakuy. ");
INSERT INTO amrNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Huakkaʼda namaʼda huaaʼeria da onʼhuaaʼnigʼa “Dakhueaʼ oʼkikaʼ, bueydik o̱ʼe̱.” Ahueʼdik o̱ʼnuy. Taʼpote bottaʼ namaʼda huaaʼeria onʼhuaaʼpo, ");
INSERT INTO amrNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","—‍“Diosen huid jaktoneʼtaj sakdik i̱jje̱y. Bapaʼ huameʼnoe onteʼti kaʼdik i̱jje̱y.” Jesúsa oaʼuy. —‍Kenpaʼ namaʼda huaaʼeria onʼhuaaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Kenokaʼ sacerdote huairi oʼbodpo Jesústaj —‍¿O̱ʼna menpaʼ baaʼtokhueʼ i̱ʼe̱? ¿Kenda inomey ontaj boʼhuaaʼne buttida menpaʼ yadaʼ? —‍Sacerdote huairia Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jesúsnayo sohuataʼ aʼtokhueʼda o̱ʼu̱yate. —‍Diosnayo oʼnoeonhuahuikaʼ. Diosa mepe̱i̱kaʼne doʼtaj buttida onaʼdik moʼe̱ne. ¿O̱ʼna menpaʼ Cristo i̱ʼe̱? ¿Menpaʼ Diosen Huasiʼpo i̱ʼe̱? Menaʼ. —‍Sacerdote huairia onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","—‍E̱e̱ʼ, Cristo i̱jje̱y. Diosen Huasiʼpo i̱jje̱y. Doʼtaj Diosa meʼtaʼmonaʼuyne. Kurudyo̱ doʼtaj onʼtiahuayapone. Dios teyda o̱ʼe̱. Keʼnen huadaʼkopen i̱jje̱po kurudya̱ʼ e̱ʼsi̱hui̱ya̱ʼ eʼtiakte onʼtiahuayapone. —‍Jesúsa huairitaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Konig judío aratbuta o̱gkikaʼuyate onʼdiaypo yudtaj onʼhuisikaʼ. Keʼna sacerdote huairi Jesústaj oʼpe̱e̱depo oʼhuadiayonpo yudtaj oʼhuisʼuyate. —‍In huabokereka Dios i̱jje̱y namaʼda oʼnopo̱e̱po dakhueaʼda oaʼ. Nogi̱ti dakhueaʼ huaaʼeritaj eʼpe̱e̱taʼ pakhueʼ o̱ʼe̱y. Diostaj dakhueaʼda oaʼnigtaj opuda̱ moʼpe̱e̱ne. ");
INSERT INTO amrNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Menpaʼ moʼnopo̱e̱? —‍Sacerdote huairia nog judío huairitaj oʼmanaʼuyate. —‍Dakhueaʼda oaʼ. Bueydik ka̱e̱ʼ. —‍Oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Jesúsen huakoktaj onʼtisupueʼuy kenpaʼti Jesústaj onʼtuktukuy kenpaʼti Jesúsen huakoktaj onʼpebasʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","—‍¿Ontaj Diosa eʼtaʼmonuyʼnayo beʼa huaboaʼda betuktuk keʼna yaaʼ? —‍Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Kenokaʼ jak kurute Pedro eʼhuadte muneʼyo̱ huanabaʼa oʼhuahuaʼdepo, —‍Jesús Galileayo hua̱e̱ʼeriere iʼhuaeʼikaʼuyate. —‍Pedrotaj muneʼyo̱a̱ onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ayaʼada enpe̱e̱ʼte, —‍Ehueʼ. Kateaʼ iʼet nopo̱e̱hueʼ i̱jje̱y. —‍Pedroa oaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Eʼtiokpakaʼ akbogpeyo eʼhuadeʼte noga̱ ettoneʼa̱ oʼtiahuaydepo, —‍Jesús Nazareteriere ken kenpaʼti oʼhuaeʼikaʼuyate. —‍Pedrotaj oʼhuaaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","—‍Ehueʼ. Kenbokerektaj jo̱ki̱a̱hueʼya i̱jje̱y. Buttida ijjay Diosapiʼ oʼnopo̱e̱. —‍Onteʼti Pedroa oaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Aʼtimon nogomey meyo̱hueʼda o̱ʼnepo Pedrotaj onʼhuatiakpo, —‍O̱ʼna Jesúsen huanigpe̱i̱kaʼeri i̱ʼe̱po konig Galilea hua̱e̱ʼerien huaʼa iaʼne. —‍Pedrotaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","—‍Kentaj jo̱ki̱a̱hueʼya i̱jje̱y. Buttida ijjay. Buttida ahueʼ e̱e̱ʼnayo dakhueaʼda doʼtaj ka̱gkeʼ. —‍Pedroa oʼmanaʼuyate. Kenpaʼ eaʼte huatahuaa oʼsipogdeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Eʼsipogdeʼte “Oyda in sikyo huatahuaa sipoghued, ‘Jesústaj jo̱ki̱a̱hueʼya i̱jje̱y,’ bapaʼaʼ iaʼapo.” Jesúsa menameʼnig. Pedro huaboaʼda okkahuehueʼda onteʼti oʼnoponpo o̱ʼo̱ro̱kdepo paiʼnanada oʼhuikuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Emedeʼte monig Jesús bueydik o̱ʼe̱a̱po ayaʼ sacerdote huairia ayaʼ judío huatoneʼ huairia onʼbatiaʼpakdepo onʼnopo̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Jesústaj onʼtinukupo onʼtohuaʼpo Poncio Pilato Romano gobierno huairitaj onʼyokuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas huakupete Jesústaj judío huairitaj oʼbahuayameʼte. Jesús bueydik o̱ʼe̱a̱po Judas huaboaʼda oʼnopo̱e̱depo huaboaʼda oʼnopoʼkoreaʼuyate. Treinta plata huakupe sacerdote huairitaj kenpaʼti huatoneʼ huairitaj onteʼti aʼbatahuayaʼpo oʼtohuaʼpo, ");
INSERT INTO amrNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","—‍In huabokerek dakhueaʼ kahueʼ o̱ʼu̱y. Kenpaʼda huadak oʼkikaʼuy. Opuda̱ kanʼarakeʼpo onʼyokmeʼne. Kenpaʼ ijkaʼpo dakhueaʼda ijkaʼmey. —‍Judasa huairitaj oʼmanaʼuyate. —‍Kenda eʼpe̱e̱taʼ pakhueʼ o̱ʼe̱y oroʼnayo. —‍Huairia Judastaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Diosen jakyo Judas plata huakupe barakte oʼendepo o̱ʼo̱ro̱kuyate. Oʼhuaʼdepo eʼbia o̱ʼhue̱renpitinukupo huataʼ oʼoroaʼpo oʼbueyʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Sacerdote huairi huakupe onʼedepo, —‍Huabokerektaj eʼarak huakupe o̱ʼe̱nok Diosen huakupe huanto̱e̱ʼyo̱ in huakupe kuda̱hueʼdik o̱ʼe̱ne. —‍Huairia o̱daʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Nogok huayahuaya onʼbatiaʼpakpo, —‍Mamasot huadari in huakupete monʼbake. Ke̱yo̱da esoeritayoʼda bakubarakkaʼdik o̱ʼnikaʼapo. —‍Huayahuaya onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ken huakupe Jesústaj kanʼarakeʼpo oʼbahuayaʼuynig ken huadari onʼbakeʼuy. Mimi huadari o̱ʼe̱. Aratbuta onʼbatiaʼpakikaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Konig Jeremías Diosen huamanbatiaʼpakeria oaʼuyate. Judío Huairia konigda o̱gkaʼdeʼuy. “Ken treinta plata eʼhuatitotiak huakupe konig Dios Huairia oaʼuynig mamasot huadari yanʼbakeapet.” Jeremías oʼmadoyaʼuyate. Kenda judío huairi o̱gkaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Kenokaʼ Pilato gobierno huairite Jesústaj onʼtohuaʼdepo, —‍¿Judíoen gobierno huairi menpaʼ i̱ʼe̱? —‍Pilatoa onaʼuy Jesústaj. —‍E̱e̱ʼ kenda iaʼ kenda i̱jje̱y. —‍Jesúsa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","—‍Jesús dakhueʼda o̱ʼe̱. Nogda nogda dakhueaʼ oʼkaʼ. —‍Judío huairia Pilatotaj onʼhuaaʼuynigʼa. Jesúsanayo baaʼtokhueʼ o̱ʼu̱y. ");
INSERT INTO amrNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","—‍Ontaj dakhueaʼda boʼhuaaʼne. O̱ʼna soataʼ i̱ʼe̱ne. ¿Menpaʼ iʼpe̱e̱? —‍Pilatoa Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jesúsanayo sigpiʼ aʼtokhueʼ o̱ʼu̱y. Pilato kenpihuay Jesústaj huakkaʼ oknopoenʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ken fiestate gobierno huairia nogtatida huabakuda̱ʼ jakyo hua̱e̱ʼeritaj oʼmaoro̱kaʼikaʼ. Kentaj aratbuta oʼnoktieʼeaʼ gobierno huairia o̱ʼo̱ro̱kaʼikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kenokaʼ Barrabás huabakuda̱ʼ jakyo o̱ʼu̱yate. Dakhueaʼda huakaʼeri o̱ʼe̱ ayaʼada onʼnopo̱e̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Huakkaʼda enʼbakupopakdeʼte, —‍¿Huabakuda̱ʼ jakyaʼ eʼo̱ro̱kataʼ beʼtaj boʼpak Barrabástaj Jesústapiʼ? Jesús opuden Cristo o̱ʼe̱. —‍Pilatoa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Judío huairi Jesústaj digda onʼhuahuaypo menigtotiakne. Pilatoa kenpaʼ oʼnopondepo oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Kenokaʼ Pilato huairi a̱pon huahuadte oʼhuadde “Jesús huadakda o̱ʼe̱. Bueydik o̱ʼe̱. Ahueʼ ya̱e̱ʼ. Eʼbayorokte kentaj paiʼda yoknopoʼunhuahuay.” Pilatotaj behuaatiʼ Pilatoen hua̱to̱e̱a̱ oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","—‍“Barrabástaj ya̱o̱ro̱kaʼ. Jesústaj ya̱ʼdarak.” Pilatotaj ya̱ʼnonaʼ. —‍Sacerdote huairia kenpaʼti huatoneʼ huairia huakkaʼ aratbut e̱gkupopakte onʼeretpakpo onʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","—‍Bottaʼ o̱ʼnenok. ¿Beʼtataj i̱jjo̱ro̱kaʼapo? —‍Pilatoa onteʼti oʼmanaʼuy. —‍Barrabástaj. —‍Oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","—‍¿Jesús opuden Cristotaj monig ijkaʼapo? —‍Pilatoa oʼmanaʼuy. —‍Hue̱ypa cruzte yaarak. —‍Ayaʼada oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","—‍¿Menaʼpo? ¿Kate dakhueaʼ yakaʼ? —‍Pilatoa oʼmanaʼuy. —‍Hue̱ypa cruzte yaarak. —‍Nogi̱ti nogi̱ti ʼuttaʼda oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Doʼtaj pe̱e̱hueʼ o̱ʼnepo kenpaʼti aratbut diga̱ʼda oʼnokoynok. Pilato oʼnopondepo, “Hue̱ʼe̱y yatotiak,” onaʼpo ayaʼada enʼtiahuayte oʼbaʼkoyopo, —‍In huadak huabokerektaj eʼaraktaʼ pakhueʼ i̱jje̱y. Donayo dakhueaʼ kahueʼ i̱jje̱y. Opud boʼpaknok ijjarakapoy. —‍Pilatoa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","—‍Kentaj ya̱ʼdarak namaʼda eaʼnayo oroʼ kenpaʼti oroʼensiʼpo paiʼda oʼnopoʼe̱a̱po. —‍Ayaʼada oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Kenokaʼ Pilato Barrabástaj o̱ʼo̱ro̱kaʼuy. Jesústaj huiyokda huasiʼdakbiʼa enʼbitbitdeʼte Pilatoa sorotataʼtaj oʼbayokuy. Hue̱ypa cruzte kanʼarakeʼpo oʼbayokuy. ");
INSERT INTO amrNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Gobierno huairien huaboroʼ jakyo onʼtohuaʼdepo ayaʼda sorotataj Jesústaj onʼtikupopakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ken Jesúsen huaok oʼnokkirokaʼpo ayagdakon huaok onʼotaʼpo. (Ken konig gobierno huairiayoʼda onʼotikaʼnig.) ");
INSERT INTO amrNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Kenpaʼti eʼpid huakiok o̱gkuottaʼpo kenpaʼti hue̱ypa huadaʼkopen onʼbaʼpada̱ʼuyate. Kenpaʼ oʼnogkaʼdepo huikudate onʼtihuadpo, —‍Iʼtiak judíoen gobierno huairi. —‍Namaʼda sorotataʼa onʼtierikpo oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Kenpaʼti onʼtisupuʼuyate. Hue̱ypa onʼto̱e̱po o̱gkubitbituyate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ken konig onʼtierikdepo okayagda oʼnokirokaʼpo keʼnenokkon onteʼti onʼotaʼdepo hue̱ypa cruzte aʼarakyaʼpo Jesústaj onʼtohuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Jerusalén huakkaʼ jakyaʼ onʼto̱o̱ro̱kdepo Cirene huakkaʼ jak hua̱e̱ʼeri Simóntaj onʼdeʼuyate. Sorotataa oʼnonaʼnok Jesúsen hue̱ypa cruz Simóna oʼtohuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ken Gólgota oteʼ onokye̱ʼuyate. Gólgota aratbutenjate huakuaiʼ oteʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ke̱yo̱ sorotataj Jesústaj vino paiʼ onʼyokuyate. Monigti ya̱ʼe̱tapo suhuigda oʼmaypo nogi̱ti mayhueʼ o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Sorotataj Jesústaj hue̱ypa cruzte onʼbetandepo beʼa keʼnen yudtaj yaʼdeyapet aʼnopo̱e̱yaʼpo huid okmo o̱ʼneneʼuy. Kenda Diosen huamanbatiaʼpakeria oaʼuyatenig kenda o̱gkaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Kenokaʼ Jesúsen hua̱so̱ʼ aʼtiokayaʼpo onʼhuadʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Huaku kutapen hue̱ymeyente “In Jesús o̱ʼe̱. Judío aratbuten gobierno Huairi o̱ʼe̱.” Onʼmadoyaʼuyate. Konige̱po bueydik o̱ʼe̱ onʼnopo̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Kenokaʼ bottaʼ huabereʼeritakon hue̱ypa cruzte onʼmabetaʼuyate. Jesús huadaʼkopen nogtaj opeʼtopen onʼmabetaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Judío aratbut onʼpokpo Jesústaj dakhueaʼda onʼtidiʼkeonhuaʼuy. Kenpaʼti onʼhuadiaypo huakua onʼpekoreʼepo, ");
INSERT INTO amrNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","—‍“Diosen huaboroʼ jak ijsakapoy, bapaʼ huameʼnoe onteʼti ijkaʼapoy.” Iameʼne. O̱ʼna bueyhueʼ a̱ʼe̱ya̱ʼpo huataʼ yatihuapok. O̱ʼna Diosen Huasiʼpo e̱e̱ʼnayo cruzyaʼ yahuarak. —‍Judío aratbuta onʼbapokpo Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Sacerdote huairia Apagbaʼ huamanmadikaʼeria fariseo huamanmadikaʼeria huatoneʼ huairierea kenpaʼti Jesústaj dakhueaʼda oʼnonaʼpo: ");
INSERT INTO amrNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—‍Nogomeytaj oʼbayareaʼikaʼuyatenigʼa huataʼnayo bueyhueʼ a̱ʼe̱ya̱ʼpo tihuapokhueʼdik o̱ʼe̱. Israel aratbuten huairi e̱e̱ʼnayo hue̱ypa cruzyaʼ kahuarakeʼ. Eʼhuaraknayo kentaj oknopo̱i̱kaʼdik o̱ʼe̱a̱poy. ");
INSERT INTO amrNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Diostaj oknopo̱e̱nok kenpaʼti “Diosen Huasiʼpo i̱jje̱y.” Jesúsa oaʼuynok Diosa dakaʼ Jesústaj eʼpaknayo bueyhueʼdik ka̱e̱ʼpo katihuapokeʼ. —‍Judío huairia Jesústaj onʼhuaaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Huabereʼeriere Jesús onteteyoʼ hue̱ypa cruzte onʼbetpo kenpaʼti Jesústaj dakhueaʼda onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tokhuada̱ʼ eʼhuadte huadari huabada oʼsikonʼuy. Sikki̱re̱gda o̱ʼu̱yate. Tereaʼ eʼhuaddeʼte onteʼti oʼtaʼtudu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Kenteda niokpo eʼhuadted, —‍Elí, Elí, ¿lama sabactani? —‍Jesúsa ʼuttaʼda oʼokoyonʼuyate. Ken aratbuten huaʼate: —‍¿Menaʼpo doʼtaj meʼenonne, doʼhued Dios? —‍Jesúsa ʼuttaʼda oʼokoyonʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Sueʼda huakkaʼmona onʼtikupobopo onʼpe̱e̱depo, —‍In huabokerek Elíaskudaktaj oʼnokoy. —‍Onʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nogbokerektida i̱da oʼketpo a̱pon esponja oʼtotiakdepo vino paiʼyo oʼtaʼbutaʼpo hue̱ypate oʼbetaʼpo kenpaʼti huakittaʼte oʼnigokteaʼuyate. Kabuyukeʼpo oʼnigokteaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","—‍Aʼti, Elías aʼtihuapokyaʼpo yatiakapetpiʼ aʼtiahuayaʼpo monʼnige̱. —‍Nogomeya̱ onʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Onteʼti Jesús ʼuttaʼda oʼokoyondepo oʼnotitikonʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Eʼbueyondeʼte Diosen huid jakyo konig tela pe̱gtoneʼ eʼoroyaʼda kutapen nopote oʼhuisonʼuyate. Huadari o̱ʼi̱yi̱gʼuy. Huidtoneʼ oʼsakuy. ");
INSERT INTO amrNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Huakkaʼ kubarak oʼbakhuikeadʼuy. Huakkaʼ Diosen huaknopo̱e̱ʼerikudak onʼmanoyhuadonʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Bapaʼmeʼnoe eʼpokondeʼ Jesús eʼnoyhuaddeʼte huaknopo̱e̱ʼerikudakkon kubarakyaʼ onʼmaoro̱konʼuyate. Diosen huakkaʼ jakyo Jerusalényo̱ onʼkudonʼuyate. Ke̱yo̱da huakkaʼda onʼbatiahuayʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Kentaʼ sorotataj sorotataj capitánere Jesústaj huatiokaʼeri huadari e̱ʼi̱ye̱g kenpaʼti nogpaʼ nogpaʼ e̱e̱ʼte onʼtiahuaydepo huakkaʼda onʼmeʼpukpo, —‍In huabokerek buttida Diosen Huasiʼpo o̱ʼe̱. —‍Onʼbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Kenpaʼti ke̱yo̱da huakkaʼ ettoneʼ onʼnepo bidtaʼda onʼtiahuayanhuaʼuyate. Ettoneʼ Galilea huadaribayaʼ Jesústaj onʼtaʼhuaʼikaʼpo kenpaʼti onʼtihuapokikaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","María Magdalena kenpaʼti María Jacoboen Joséereen hua̱ye̱ kenpaʼti Zebedeoen huasiʼpoed hua̱ye̱ ke̱yo̱da o̱ʼneʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ken eʼsikonyakte José huakkaʼda huamato̱e̱ʼeri huairi oʼtiakuyate. José huakkaʼ jak Arimatea hua̱e̱ʼeri kenpaʼti Jesústaj huanigpe̱i̱kaʼeri o̱ʼe̱po ");
INSERT INTO amrNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Pilatotaj oʼhuahuaʼdepo, “Jesúsenso̱ʼ beyok.” Onaʼnok “Jesúsenso̱ʼ Josétaj yanʼyok.” Pilatoa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","José oʼso̱ʼto̱e̱po yereda telaa oʼso̱ʼti̱hui̱yi̱gdepo ");
INSERT INTO amrNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Joséen huabo sipanaʼkogyo̱ oʼso̱ʼhuedanʼuyate. Ken kubarak akbogpete huaboroʼ huid oʼtinokbetandepo oʼhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Joséen kubarak meyo̱hueʼda María Magdalena nog Maríaere onʼhuadpo onʼtiahuayʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Emeʼte sábadote sacerdote huairi kenpaʼti fariseo huamanmadikaʼeriere Pilatotaj onʼhuahuaʼpo, ");
INSERT INTO amrNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","—‍“Bapaʼ huameʼnoe eʼpokte onteʼti ijnoyhuadapoy.” Keʼna da huaaʼeria bueyhued o̱ʼe̱po oameʼ, okkahuehueʼ o̱ʼe̱y, huairi. ");
INSERT INTO amrNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Keʼnen huanigpe̱i̱kaʼeri yanʼhuahuaʼpo yanʼso̱ʼbereapetdapiʼ “Eʼbueytada Jesús oʼnoyhuadde.” Aratbuttaj yanʼmanaʼapet. Kenpaʼ e̱gkaʼnayo dakhueʼda e̱ʼdik o̱ʼe̱a̱po. Diga̱ʼda aratbut namaʼda yanoknopo̱e̱a̱petpiʼ. Konige̱po bapaʼaʼ huameʼnoeaʼ kubaraktaj dakaʼ yanʼtiokaʼ yamanaʼ. —‍Judío huairia Pilatotaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","—‍Inomey sorotataj yanʼbatohuatiʼ. Dakaʼnada kubaraktaj yanʼtiokaʼ yanʼmanatiʼ. —‍Pilatoa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ken onʼbahuaʼuyate. Kubaraktaj aʼtiokayaʼpo, huaboroʼ huid teyda oʼnokbettinukuʼuyate. Kenpaʼti sorotataj kanʼtiokeʼpo sacerdote huairi kenpaʼti fariseo huamanmadikaʼeriere onʼmaenonpo onʼbakhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Judío aratbuten okmapi̱e̱ʼahuaddik huameʼnoe eʼpokondeʼte domingo emedeʼte María Magdalena nog Maríaere kubarakyo aʼtiahuayaʼpo onʼhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kenokaʼ diga̱ʼda huadari o̱ʼi̱ye̱g. Diosen huataʼmoneri kurudya̱ʼ oʼhuarakonpo kubarakyo oʼhuaʼpo boroʼ huid huanokbet okpokoreaʼdepo huaboroʼ huidte oʼhuaduyate. ");
INSERT INTO amrNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Keʼna jeynada konig o̱jbed. Keʼnen yudtaj keregnanada o̱ʼu̱y. ");
INSERT INTO amrNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Sorotataj onʼtiahuaypo diga̱ʼda onʼmeʼpukuyate. Konig eʼbueyonig onʼbahuedʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ettoneʼtaj: —‍Okmeʼpukhueʼ meneʼ. Jesústaj boʼukne ijnopo̱e̱y kentaj hue̱ypa cruzte oʼdarakmeʼte. ");
INSERT INTO amrNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","I̱yo̱ ehueʼ o̱ʼe̱. Oʼnoyhuadonde. Ken konig monaʼuyne. Yanʼtiak. Kente onʼhueda̱meʼte yanʼtiahuayʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Enʼtiahuaydeʼte i̱da yanhuatiʼ. Jesúsen huaknopo̱e̱ʼeritaj yanʼbahuahuatiʼ, “Huabueyaʼda o̱ʼemeʼnigʼa oʼnoyhuadonde. Huakkuruda Galileayo oʼhuaʼapo opud huahued. Ke̱ya̱ʼ boʼtiahuayapone.” Kenpaʼ huaknopo̱e̱ʼeritaj yanʼmanatiʼ. Kenpaʼda ijjay. —‍Diosen huataʼmoneria ettoneʼtaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ken ettoneʼ kubarakyaʼ i̱dada onʼhuaʼpo onʼdurugpakonpo kenpaʼti onʼmeʼpukudpo onʼbahuaʼuyate. Huaknopo̱e̱ʼeritaj aʼmanaʼtoyaʼpo onʼbaketonhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","I̱da Jesúsa oʼmadejpakuyate. “Ijtiaki.” Oaʼuyate. Ettoneʼ Jesústaj onʼhuahuaʼdepo Jesúsen huaʼitaj diʼda o̱ʼnepo onʼbapaduyate kenpaʼti —‍ʼUruaʼnanada Diosen Huasiʼpo i̱ʼi̱kaʼ. —‍Oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","—‍Meʼpukhueʼ yaneʼ. Doʼhued huamaʼbuyte yanhuaʼ. “Galileayo yanhuatiʼ. Ke̱yo̱da Jesústaj boʼtiahuayapone.” Yanʼmanatiʼ. —‍Jesúsa ettoneʼtaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ettoneʼ enʼhuadeʼte sueʼda sorotataj kubarak huatiokaʼeria Jerusalén huakkaʼ jakyo onʼhuaʼuyate. A̱yo̱da judío sacerdote huairitaj ayaʼda kenda onʼtiahuaydepo onʼmanbatiaʼpakatoʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kate oʼkapoy eʼnopo̱e̱ʼtaʼ onʼpakpo huatoneʼ huairitere onʼbatiaʼpakuyate. Onʼnopo̱e̱depo huakkaʼ huakupe sorotatataj onʼbayokpo, ");
INSERT INTO amrNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","—‍Sikyo eʼtayte Jesúsen huaknopo̱e̱ʼeria onʼtiakpo Jesúsen hua̱so̱ʼ onʼberepo onʼtohuate. Namaʼda yanʼbatiaʼpaktiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Kenda gobierno huairi eʼpe̱e̱nayo oroʼ opudtaj oʼtihuapokpo huairitaj oʼbatiaʼpakapoy. Opudtaj menpaʼ o̱gkahueʼdik moʼe̱a̱pone. —‍Judío huairia sorotataʼtaj onʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ken sorotataj huakupe onʼbaedepo onʼhuaʼuyate. Kenpaʼ huairia onʼmanaʼnig onʼbatiaʼpakonhuaʼuyate. Konige̱po oy kenpaʼti Jesúsenso̱ʼtaj Jesúsen huaknopo̱e̱ʼeria onʼbereʼuyate. Judío namaʼda onʼbatiaʼpakikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ken oteʼ Galileayo Jesúsa oʼdikkameʼ oroʼa Jesúsen once huaknopo̱e̱ʼeri oʼhuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Jesústaj oʼtiahuaydepo “ʼUruaʼda i̱ʼe̱. Diosen Huasiʼpo i̱ʼe̱.” Jesústaj oʼnonaʼuynigʼa nogte Jesústaj oki̱o̱gkahueʼ o̱ʼnuy. ");
INSERT INTO amrNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesúsa oroʼtaj oʼhuatiakdepo, —‍Diosa menaʼnok ayaʼtada kurudyo̱piʼ huadarieretapiʼ mataʼmonaʼdik i̱jje̱y. Ayaʼada doʼtaj nigpe̱e̱dik meʼnikaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Yanhuatiʼ. Ayaʼ aratbuten huadaribayo yanhuatiʼ. Doʼtaj kanoknopo̱e̱ʼpo dakaʼ yanʼmanmadikikatiʼ kenpaʼti Apag Diosa oʼpaknok do ijpaknok Diosen Noki̱re̱g oʼpaknok bautiza yanʼmagkikatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ayaʼda ijmanaʼnig nigpe̱i̱kaʼdik moʼe̱ne yanʼmanikatiʼ. Kenpaʼda opudere ayaʼda huameʼnoe i̱jjeonhuahuikaʼapoy. Keneʼhua̱ya̱ʼ huameʼnoete onteʼti opudere i̱jjeonhuahuikaʼapoy. —‍Jesúsa monaʼuyne, ken.");
INSERT INTO amrNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Jesucristoen huadak huaʼa huaboaʼda onʼnigmadoyaʼne. Jesucristo Diosen Huasiʼpo o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Aʼnennada Isaías Diosen huamanbatiaʼpakeria oʼmadoyaʼuyate: Ontaj oknopo̱e̱ʼdik kaʼneʼpo onte huakkuruda doʼhued huataʼmoneritaj ijtaʼmonaʼapoy sion. Diosa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Sueʼda aratbut eʼnahue̱ʼyo̱ o̱ʼi̱kaʼapo. “Yanʼnopoʼkoreaʼ. Huairi eʼtiakdeʼte dakaʼda aʼeyaʼpo ʼurunopoʼda ya̱gʼkikaʼ. Dakhueaʼ eʼkikaʼ yanʼbatikpo onteʼti Diostaj yanʼnigpe̱i̱kaʼ.” ʼUttaʼda oʼmanaʼapo. Kenda oʼmadoyaʼuyate Isaíasa. Juan Bautistataj oʼtimadoyaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ken sueʼda aratbut eʼnahue̱ʼyo̱ Juana bautiza oʼmagkikaʼpo, “Diosa dakhueaʼ eʼkaʼ kakkahueʼpo yanʼnopoʼkoreaʼ Diostaj bautiza megkeʼ.” Juana aratbuttaj oʼmanikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Juantaj eʼpe̱e̱taʼ onʼpakpo huakkaʼnanada aratbut onʼhuahuaʼuyate. Huakkaʼ Judea huadari hua̱e̱ʼeri huakkaʼ Jerusalényo̱ hua̱e̱ʼeriere Juantaj onʼhuahuaʼuyate. “Dakhueaʼda ijkikamey. Bekkahueaʼ Dios.” Enadeʼte Jordánhue̱ya̱ʼ Juana bautiza oʼmagkaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yudtaj camello huahuijtaj eʼkaʼ Juan Bautista oʼotikaʼpo kenpaʼti huasiʼdak bakaʼbij o̱ʼta̱e̱ʼuyate. Tiktik oʼbapikaʼuyate. Asi̱gku oʼminikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Oʼmanaʼpo: —‍Aʼti Diosen Huairi boʼhuatiakdeapone. Doʼhua eʼmanikadeʼte boʼhuatiakapone. Kennayo huakhuairinanada teynanada e̱ʼe̱a̱da doʼhuataj ehueʼda i̱jje̱y. Huairinanada o̱ʼe̱nok keʼnen huanabaʼ ehueʼdikda i̱jje̱y. ");
INSERT INTO amrNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Hue̱ʼe̱ya̱ opudtaj bautiza oʼnogkaʼne. Keʼnanayo Diosen Noki̱re̱ga̱ bautiza mogkaʼapone. —‍Juan Bautista oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Kenokaʼ Galilea huadaribayaʼ Nazaret huakkaʼ jakyaʼ Jesús oʼtiakuyate, Jordánhue̱ya̱ʼ Juana bautiza o̱gkaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jesús hua̱hue̱ya̱ʼ eʼbehuikdeʼte i̱da kurud konig akbogpe okhuikepo, Diosen Noki̱re̱ga̱ dakaʼdamon konig tukkuʼ oʼhuahuarakpo Jesústaj oʼtikot Jesúsa Diosen Noki̱re̱gtaj eʼtiahuayte oʼtikotpo: ");
INSERT INTO amrNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","—‍On doʼhued huasiʼpo o̱ʼta̱e̱ne. Huadiʼda o̱ʼta̱e̱ne. Ontaj durugda oʼto̱e̱ne. —‍Kurudya̱ʼ Diosa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ken sueʼda aratbut eʼnahue̱ʼyo̱ Dios Noki̱re̱ga̱ Jesústaj oʼtaʼmonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ken, sueʼda aratbut eʼnahue̱ʼyo̱ cuarenta huameʼnoe o̱ʼeonhuaʼpo dubayo hua̱e̱ʼeriere o̱ʼnepo. Totoʼ huairia Jesústaj oʼdikdikuyate dakhueaʼ kakeʼpo. Eʼdikdikdeʼte Diosen huataʼmoneri aypo onʼyokuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ken Herodes huairia Juantaj huabakuda̱ʼ jakyo eʼkuda̱deʼte, Galilea huadariyo Jesús oʼhuaʼuyate. Dios Huairitaj huadak huaʼa huaboaʼda oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","—‍Oyedda Dios huairi oʼtiakdenok, dakhueaʼ bokikaʼnig yanʼnopoʼkoreaʼ, Diosen huamanopoʼyareaʼeritaj yanoknopo̱i̱kaʼ. —‍Jesúsa oʼmanikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jesús huaboroʼ e̱ʼpo̱g Galilea aktaʼbogpete oʼhuaʼepo Simón huamaʼbuy Andréstere oʼbatiahuayʼuyate. Oʼnokjeneʼuyate. Huakjeneʼeri o̱ʼneʼuy. Eʼnokjeneʼte oʼbatiahuayʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","—‍Doere monhuaʼ. Aratbut Diosensiʼpo kaʼnikeʼpo kanʼmanopoʼkoreʼpo moʼmanmadikikaʼapone. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","I̱dada huakjeneʼ kenpaʼda o̱ʼnenanpo Jesúsere onʼhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Adyonda oʼhuaʼedepo Jacobotaj huamaʼbuy Juantere Jesúsa oʼbatiahuayʼuyate. Jacobo huamaʼbuyere Zebedeoen huasiʼpo o̱ʼnuyate. Kusiʼpetoneʼyo o̱ʼnepo huakjeneʼtaj onʼtoʼkaʼpo, ");
INSERT INTO amrNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","“Monhuaʼ, doʼtaj meʼnigpe̱i̱kaʼ.” Jesúsa eʼmanadeʼte huaoj Zebedeo huanabaʼtere oʼnenonpo Jesústaj aʼnigpe̱i̱kayaʼpo onʼtahuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ken Capernaum huakkaʼ jakyo oʼnokye̱ʼuyate. Okmapi̱e̱ʼahuaddik huameʼnoete judío aratbuten hua̱i̱takeʼ jakyo Jesús oʼkuddepo, oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Moisésenbaʼ huamanmadikaʼeri konig huairi dakaʼ manmadikahueʼ o̱ʼnikaʼnigʼa Jesúsnayo konig huairitoneʼ ʼuruaʼnanada oʼmanmadikaʼuyatenok, “kenpihuay” aratbut o̱daʼpo onʼmepukeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Judíoen hua̱i̱takeʼ jakyo dakhueʼ noki̱re̱ga̱ huabokerektaj oʼnopoʼto̱e̱nok ʼuttaʼda onaʼpo: ");
INSERT INTO amrNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—‍Menaʼpo oroʼtaj dakhueaʼ e̱gkaʼtaʼ iʼpak Jesús Nazaret hua̱e̱ʼeri. Menaʼpo oroʼtaj aʼmaenyaʼpo oʼhuatiak. Ontaj o̱ki̱a̱ʼne Diosen huadakda nogsiʼpotida i̱ʼe̱ne. Oʼnopo̱e̱y. —‍Kenbokereka Jesústaj ʼuttaʼda onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","—‍Aʼpakhueʼ ya̱e̱ʼ. Huabokerektaj yako̱ro̱k, noki̱re̱g. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Noki̱re̱ga̱ oʼiriga̱ʼpo oʼsagkiaʼdepo okhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ayaʼada onʼtiahuaypo, —‍Kenpihuay onʼnopo̱e̱po ʼuruaʼnanada oʼmanmadikaʼ. Konig huairitoneʼ i̱ghuaʼda oʼmanaʼnok dakhueʼ noki̱re̱g onʼnigpe̱e̱po oʼnoko̱ro̱k. —‍Huayahuaya onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","I̱dada Galilea huadaribayo nogyo̱ nogyo̱ Jesúsa ʼuruaʼda oʼkikaʼ onʼmanbatiaʼpakikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Ken judíoen hua̱i̱takeʼ jakyaʼ oʼnoro̱kdepo Jesús Simónen Andrésenere jakyo Jacobo Juanere oʼhuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simónen huasuʼ oʼdigpakpo, onpahueduyate. “Simónen huasuʼ oʼdigpak.” Jesústaj oʼnonaʼnok. ");
INSERT INTO amrNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesús Simónen huasuʼtaj oʼhuahuaʼpo, oʼtaʼkuypo oʼboda̱ʼuyate. Eʼdigpak oʼtaʼhuitatoʼpo aypo oʼmanigmanhuada̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Eʼsikdeʼte huakkaʼda dakhueʼ o̱ʼnenok ayaʼtada Jesúste onʼbatohuaʼuy. Nogomeytaj dakhueʼ noki̱re̱ga̱ onʼmanopoʼto̱e̱nok Jesústaj onʼbatohuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Huakkaʼ jakyaʼ ayaʼada akbogpete onʼkupopakuy. ");
INSERT INTO amrNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Huakkaʼtada Jesúsa oʼbayareaʼuy. Huakkaʼ totoʼtaj oʼmakenʼuy. Totoʼ Jesústaj o̱ki̱a̱ʼnok “Diosen Cristo o̱ʼe̱ ahueʼ yaneʼ.” Jesúsa totoʼtaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ken, meahuedda oʼmaboʼuyate. Sueʼda aratbut eʼnahue̱ʼyo̱ Jesús oʼhuaʼuyate. Ke̱ya̱ʼ Diostaj oʼtionaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simónomey onʼtahuaʼpo, ");
INSERT INTO amrNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","onʼhuahuaydepo, —‍Ayaʼada boʼukne. —‍Oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","—‍Nog huakkaʼ jakyo nogyo̱ nogyo̱ huadak huaʼa aʼmanbatiaʼpakyaʼpo ijtiakpo nogyo̱ nogyo̱ monhuaʼ. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Galilea huadaribayo nogyo̱ nogyo̱ oʼhuaʼunhuahuaʼpo judío aratbuten hua̱i̱takeʼ jakyo oʼmanmadikikaʼpo kenpaʼti totoʼ noki̱re̱gtaj oʼmaenikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Huabokerek keʼpoda oʼso̱ʼsetpo, Jesústaj oʼhuatiakuyate. Huikudate oʼtihuadpo, —‍Eʼpaknayo yareaʼdik o̱ʼe̱ne. —‍Jesústaj onaʼnok. ");
INSERT INTO amrNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús oʼtinepahuiudpo, oʼtibataʼtepo, onaʼpo: —‍Eʼyareaʼtaʼ oʼpakne. Oʼyareapone. —‍Onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Enaʼte i̱dada oʼyareadʼuyate. ʼUruda hua̱so̱ʼ o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesúsa oʼtaʼmonaʼpo, ");
INSERT INTO amrNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—‍Keyoj, Jesúsa beʼyareaʼne mantiaʼpakhueʼ ya̱e̱ʼ. Hua̱so̱ʼ eʼyareaʼ kaʼtiahuayeʼpo sacerdotete yahuatiʼ. Aʼyareyaʼpo konig Moisésa oʼmanaʼuyatenig ken konig yayoktiʼ. ʼUhuapiʼ yayoktiʼ. Oʼyarede aratbuta moʼtinopo̱e̱a̱pone. —‍Jesúsa i̱ghuaʼda onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Keʼnanayo oʼhuaʼpo Jesúsa beʼyareaʼne ayaʼtada huaboaʼda oʼmantiaʼpakʼuyate. Konige̱po Jesús huakkaʼ jak eretnopoyo mankudhueʼdik o̱ʼe̱po sueʼda aratbut eʼnahue̱ʼyo̱ o̱ʼi̱kaʼuy. Nogya̱ʼ nogya̱ʼ onʼbahuatiakikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Sueʼda huameʼnoe eʼpokdeʼte Capernaum huakkaʼ jakyo onteʼti Jesús eʼtiakdeʼte “Jesús jakyo o̱ʼe̱.” Huakkaʼ jak hua̱e̱ʼeria onʼtipe̱e̱po, ");
INSERT INTO amrNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","huakkaʼada aratbut onʼkupopakpo, jakyo o̱gkupopakpo kurutekon o̱gkupopakuyate. Akbogpete mente boahueʼ o̱ʼneʼuyate. Apag Diosen huadak huaʼa Jesúsa oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Bottaʼ bottaʼ huabokereka huabokerek eʼketpaktaj oʼnonokbaʼhuadonpo onʼtotiakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Huakkaʼada o̱gkupopaknok, menpaʼ ibodte huatotiakhueʼdik o̱ʼnepo, jak kutayo onʼtobehuikpo jakonpid onʼtiokendepo huabokerek eʼketpak asukte enpahuedte aratbutnopote Jesústaj huakokpen oʼnonhuarakaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesúsa oʼyareaʼapo oʼnoknopo̱e̱nok Jesúsa oʼnopo̱e̱po, —‍Ayaʼ Diostaj dakhueaʼ iʼkikaʼuyatenigʼa yokkahueaʼpo oʼnopoʼtihuekeʼne, sion. —‍Huabokerek eʼketpaktaj Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","7","Kenteyo sueʼda Moisésenbaʼ huamanmadikaʼeri onʼbahuadpo, “Menpaʼ in huabokerek Diostaj dakhueaʼ oaʼ. Beʼa dakhueaʼ eʼkaʼ yaʼnopoʼtihuekeʼ. Diosayoʼda nopoʼtihuekeʼdik o̱ʼe̱.” Kenda huanopoyaʼda onʼnopo̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kenda Moisésenbaʼ huamanmadikaʼeri huanopoyaʼda onʼnopo̱e̱nigtaj Jesúsa oʼnopo̱e̱po, —‍Menaʼpo huanopoyaʼ kenpaʼ doʼtaj onʼtinopo̱e̱. ");
INSERT INTO amrNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Diostaj dakhueaʼ eʼkaʼ huabokereka okkahueahueʼdik o̱ʼe̱. Diosayoʼda okkahueaʼdik o̱ʼe̱. Huabokerekanayo yareahueʼdik o̱ʼe̱po, “Yabod, atisuk yatohuaʼ yahuatiʼ,” onahueʼdik o̱ʼe̱. Diosayoʼda yareaʼdik o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Do huabokerek i̱jje̱po Diosyaʼ ijtiakuy. Diostaj dakhueaʼ eʼkaʼ nopoʼtihuekeʼdik i̱jje̱y opudtaj aʼmanopo̱e̱a̱yaʼpo, eʼketpaktaj ijyareapoy. —‍Jesúsa Moisésenbaʼ huamanmadikaʼeritaj oʼmanaʼpo, ");
INSERT INTO amrNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—‍Yaboʼ, asuk yato̱e̱po, o̱ʼnen jakyo yahuatiʼ onaʼne. —‍Jesúsa eʼketpaktaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ayaʼada enʼtiahuayte oʼbodpo asuk oʼudpo oʼmako̱ro̱konʼuyate. Konige̱po ayaʼada, —‍Kenpihuay, Dios huadakda o̱ʼe̱. ʼUrunanada oʼkaʼ. Ken konig aʼnenda tiahuayhueʼ o̱ʼnikaʼuynig oʼtiahuaydey. —‍Aratbuta onʼtiahuaydepo onʼbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ken onteʼti Jesús oʼhuaʼpo, e̱ʼpo̱g aktaʼbogpete oʼhuaʼuyate. Huakkaʼada aratbut kentaj e̱gkupopakdeʼte oʼmanmadikanhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Oʼpokonpo, Levítaj oʼtiahuayʼuyate. (Leví Mateo bottaʼdik onʼdikkaʼuyate.) Leví Alfeoen huasiʼpo gobiernoen huakupe huatabaeʼ jakyo oʼhuaduyate, —‍Menigpe̱e̱po betaʼhuaʼ. —‍Levítaj onaʼuyatenok Leví oʼbodpo, Jesúsere oʼhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ken Levíen jakyo Jesúsere huakkaʼmon onʼbapeʼpo huakkaʼ gobiernoen huakupe huatabaeʼeri huakkaʼ dakhueaʼ huakaʼerikon onʼbapeʼuyate. Huakkaʼda ken konig Jesústaj onʼtahuaʼikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Dakhueaʼ huakaʼeriere, Jesús oʼbapeʼ Moisésenbaʼ huamanmadikaʼeri fariseoere onʼtiahuaydepo, —‍¿Menaʼpo huakupe huatabaeʼeri dakhueaʼ huakaʼeriere oʼbapeʼpo Jesús? —‍Fariseoa Jesúsen huanigpe̱i̱kaʼeritaj onʼhuaaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Kenda Jesúsa oʼmape̱e̱depo, —‍Aratbut dakda e̱e̱ʼnayo huamadakkaʼeritaj pakhueʼ o̱ʼnikaʼ. Dakhueʼda e̱e̱ʼnayo huamadakkaʼeritaj onʼpakikaʼ. Huadak huakikaʼeritaj “yanʼnopoʼkoreaʼ,” aʼmanayaʼpo tiakhueʼ i̱jje̱ʼuy. “Yanʼnopoʼkoreaʼpo doʼtaj menʼnigpe̱i̱kaʼ.” Dakhueaʼ huakaʼeritaj eʼmanaʼtaʼ ijpakpo ijtiakuy. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nogok Juanen huanigpe̱i̱kaʼeri Dios kamape̱e̱ʼpo aypo bapehueʼ e̱ʼnikaʼte, fariseo aratbutkon Dios kamape̱e̱ʼpo bapehueʼ e̱ʼnikaʼte sueʼda aratbut Jesústaj onʼhuatiakpo, —‍Juanen huanigpe̱i̱kaʼeri fariseokon Dios kamape̱e̱ʼpo bapehueʼ o̱ʼnikaʼ. ¿O̱ʼnen huanigpe̱i̱kaʼerinayo menaʼpo yanʼbapikaʼ? —‍Oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","—‍Huabokerek oʼto̱e̱pakapo, keʼnen huadiʼa fiestate onʼtiakdepo onʼbapikaʼ. Ken huabokerekere e̱ʼneʼte huadiʼa bapikaʼdik o̱ʼnikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Nogok ken huabokerektaj enʼbaktohuadeʼte huadiʼa paiʼda e̱ʼdik o̱ʼnepo Dios kamape̱e̱ʼpo bapehueʼ o̱ʼnikaʼapo. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","—‍Huatoneʼok keʼpoda eʼparaʼte akbetyaʼpo huabo huaoktaj okteghueʼ o̱ʼi̱kaʼne oroʼomey aratbut. Huaboenpa huatoneʼoktaj ekbetnayo onteʼti keʼpoda oʼparaʼapo kenpaʼti huabo huaok dakhueʼda o̱ʼe̱a̱po. Konigti adhueaʼpaneʼa̱ eʼmanmadikaʼ huatoneʼdik onteʼti nigpe̱e̱hueʼdik yaneʼ. Doʼhued huabodikyoʼda eʼmanmadikaʼ nigpe̱e̱dik yanikaʼ. Konigti konig adhueaʼpaneʼ o̱gkikaʼuynig nogi̱ti kikaʼdik manahueʼ i̱jje̱po huabo eʼmanmadikayoʼda onʼmadikaʼikaʼne. ");
INSERT INTO amrNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Huatoneʼsiʼdak vino hua̱to̱e̱ʼ ayda kenpaʼti kuruga̱da o̱ʼe̱po konige̱po huabo vino sineʼ hue̱biahued onjoyhueʼdik o̱ʼe̱ne. Huatoneʼsiʼdakyo huabo vino onjoyhueʼdik o̱ʼi̱kaʼne. Huatoneʼsiʼdakyo huabo vino enjoynayo oʼhue̱poagpo huasiʼdak onʼtitagonapo. Vino oʼsurukapo kenpaʼti huasiʼdak keʼpoda oʼsuʼhuitonapo, dakhueʼda o̱ʼe̱a̱po. Huabo vino huabosiʼdakyo onjoydik o̱ʼe̱ne. Huasiʼdak vinoere huadak o̱ʼe̱a̱po. Konigti adhueaʼpaneʼ o̱gkikaʼnig kahueʼdik yanikaʼ. Doʼhued huabo eʼmanmadikayoʼda yanʼnigpe̱i̱kaʼpo ya̱gʼkikaʼ. Konigti konig adhueaʼpaneʼ o̱gkikaʼuynig nogi̱ti kikaʼdik manahueʼ i̱jje̱po huabo eʼmanmadikayoʼda onʼmadikikaʼne. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Nogok okmapi̱e̱ʼahuaddik huameʼnoete taʼbayo Jesús oʼhuaʼepo huanigpe̱i̱kaʼeriere oʼhuaeʼuyate. Jesúsen huanigpe̱i̱kaʼeria o̱gkusitokpo trigo oʼnogkupayaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","—‍Yatiahuayʼ. ¿Judíoen okmapi̱e̱ʼahuaddik huameʼnoete o̱gkupayahueʼdik o̱ʼe̱nigʼa menaʼpo o̱ʼnen huanigpe̱i̱kaʼeria ya̱gkaʼ? Dakhueaʼda o̱gkaʼ. —‍Fariseoa Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","—‍Aʼnennada David kenere hua̱e̱ʼeri aypotaj o̱ʼnepo o̱gkusitokuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Diosen carpa jakyo onʼkudonpo, Abiatar sacerdote huairi e̱ʼi̱kaʼte Diostaj eʼnighueda̱ʼ pan onʼtabapeduyate. Kenda pan beʼapiʼ bapehueʼdik e̱e̱ʼtada o̱gkaʼuyate. Sacerdoteyoʼda bapeʼdik o̱ʼnuyate. Menpaʼ kenda Apagbaʼte tiahuayhueʼ o̱ʼi̱kaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Huabokerektehuapaʼ okmapi̱e̱ʼahuaddik kaʼnikeʼpo Diosa okmapi̱e̱ʼahuaddik huameʼnoe oʼdikkaʼuyate. Huabokereka katepiʼ nogda nogda kikahueʼdik yanikaʼ aʼmanayaʼpo okmapi̱e̱ʼahuaddik huameʼnoe Diosa dikkahueʼ o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Do huabokerek i̱jje̱po Diosyaʼ ijtiakuy. Okmapi̱e̱ʼahuaddik huameʼnoe Huairi i̱jje̱y. —‍Fariseotaj Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Onteʼti okmapi̱e̱ʼahuaddik huameʼnoete judíoen hua̱i̱takeʼ jakyo Jesúsa oʼkuduyate. Ke̱yo̱ huabokerek ebaʼpoʼketpak o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","“¿Okmapi̱e̱ʼahuaddik huameʼnoete menpaʼ Jesúsa yaʼyareapo?” Fariseo onʼnopo̱e̱po, eʼyareaʼnayo, “Jesúsa dakhueaʼ oʼkaʼ.” Huaaʼdik o̱ʼe̱y onʼnopo̱e̱ʼuyate. Konige̱po fariseo Jesústaj onʼtiahuayaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","—‍Yaboʼ, i̱yo̱ eretnopoyo yaboatoʼ. —‍Jesúsa ebaʼpoʼketpaktaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","—‍¿Okmapi̱e̱ʼahuaddik huameʼnoete menpaʼ huadak kaʼdik ya̱ʼne? ¿Menpaʼ dakhueaʼ kaʼdik ya̱ʼne? ¿Menpaʼ yareaʼdik ya̱ʼne? ¿Menpaʼ arakdik ya̱ʼne? —‍Jesúsa oʼmanaʼnigʼa. Fariseomeya̱ sohuataʼ aʼtokhueʼda oʼnoke̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Eʼnopoenkaʼtaʼ pakhueʼ o̱ʼnenok Jesúsa oʼbahuadiayonpo suhueʼda o̱ʼe̱po nogta nogta oʼbatiahuaypo, —‍Yabateʼ. —‍Jesúsa onaʼuyate. Ken oʼbaʼtepo oʼbaʼyarudʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Fariseomey oʼnoro̱kpo i̱da Herodestaj huapakeriere o̱gkupopakdepo, menpaʼ Jesústaj arakdik o̱ʼe̱, onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Huaboroʼ e̱ʼpo̱g aktaʼbogpeyo Jesús huanigpe̱i̱kaʼeriere onʼhuaʼuyate. Huakkaʼ Galilea huadaribayaʼ hua̱e̱ʼerikon onʼtahuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Judeayaʼ Jerusalénya̱ʼ Idumea huadariyaʼ Jordánhue̱ adpenyaʼ Tiro huakkaʼ jakyaʼ Sidón huakkaʼ jakyaʼ huakkaʼda onʼhuatiakpo, Jesúsa ʼurunanada oʼkikaʼ onʼtipe̱e̱depo, onʼtiakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","10","Huakkaʼtada oʼbayareaduynok ayaʼada dakhueʼ hua̱e̱ʼeria aʼyareyaʼpo kenʼtaj eʼnejtaʼ onʼpakpo diga̱ʼda onʼkupopakpo Jesússo̱ʼtaj sapajdikte eʼnenok, —‍Ibodteda kusiʼpe moʼnigto̱e̱ʼ. —‍Jesúsa huanigpe̱i̱kaʼeritaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kenokaʼ totoʼa huanopoʼto̱e̱ʼeria Jesústaj onʼtiahuaydepo onʼtihue̱kpo, —‍Diosen Huasiʼpo i̱ʼe̱ne. —‍ʼUttaʼda oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","—‍Kejeʼ mati̱o̱ki̱a̱hueʼ yaneʼ. —‍I̱ghuaʼda oʼmanaʼuyate Jesúsa. ");
INSERT INTO amrNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Oteʼyo oʼbehuikuyate. Kenomeytaj eʼbaktieʼeaʼtaʼ oʼpakpo “Yanʼtiak,” oʼmanaʼnok onʼhuatiakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Jesúsere kaʼnikeʼpo huadak huaʼa kanʼmanmadikikeʼpo docetaj oʼbaktieʼeaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","“Do ijpaknok dakhueʼ e̱e̱ʼ bayareaʼdik moʼe̱a̱po kenpaʼti dakhueʼ noki̱re̱gtaj maoro̱kaʼdik moʼe̱a̱pone.” Oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Jesúsen doce huamataʼmoneri o̱ʼnepo: Simón Pedro, ");
INSERT INTO amrNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo, Jacoboen huamaʼbuy Juan Zebedeoen huasiʼpo, kenomeytaj oʼdikkaʼ Boanerges (kurud eaʼensiʼpo), ");
INSERT INTO amrNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés, Felipe, Bartolomé, Mateo, Tomás, Jacobo Alfeoen huasiʼpo, Tadeo, Simón cananista huakupopakeri, ");
INSERT INTO amrNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","kenpaʼti Judas Iscariote Jesúsen huamataʼmoneri o̱ʼnuyate. Judas Iscariote huakupete Jesústaj kanarakeʼpo yaʼbahuatitotiakapet. Nogok huanigpe̱i̱kaʼeri Jesúsere jakyo onʼkuduyate. ");
INSERT INTO amrNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Onteʼti huakkaʼda aratbut o̱gkupopaknok menpaʼ bapehueʼdik o̱ʼneʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","“Oʼsegpakpo oʼkikaʼ.” Aratbuta onʼbatiaʼpaknok Jesúsen huabeta kenda onʼnopo̱e̱depo aʼtohuayaʼpo onʼhuatiakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","—‍Beelzebú totoʼ huairi oʼnopoʼto̱e̱po oʼteyyaʼnok Jesúsa totoʼ noki̱re̱gtaj oʼmakenikaʼ. —‍Moisésenbaʼ huamanmadikaʼeria onʼbatiaʼpakuy. Jerusalénya̱ʼ onʼtiakdeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","“Namaʼda onʼnopo̱e̱nig Moisésenbaʼ huamanmadikaʼeritaj aʼmanopo̱e̱a̱yaʼpo menhuatiakpo menʼpe̱e̱ʼ,” Jesúsa oʼmanaʼdepo konig o̱ʼe̱ oʼmanbatiaʼpakpo: —‍Menpaʼ totoʼa huataʼ totoʼtaj enʼdik ya̱ʼe̱t. Ehueʼ, enhueʼdik o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ondariyoyoʼ hua̱e̱ʼeri gobierno huairi huayahuaya eʼbarakikaʼnayo gobierno huairi to̱e̱hueʼdik o̱ʼneapo. ");
INSERT INTO amrNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kenpaʼti onyoyoʼ hua̱e̱ʼeri eʼbatuktuktaʼ onʼpakpo onʼbakkupopak. Eʼbaraknayo ehueʼdikda o̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Konigti totoʼ huairi huayahuaya eʼmagkaʼnayo aʼti ehueʼdik ya̱ʼneapet. ");
INSERT INTO amrNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Huabokereka huairien eʼtamaikaʼ jekbakaytaʼ eʼpaknayo baʼtinukuʼdik kenpaʼti itakpiʼtinukuʼdik o̱ʼe̱. Huairitaj oʼtinukudepo okbakaydik o̱ʼe̱. Donayo teyda i̱jje̱y. Totoʼ huairitaj tinukuʼdik i̱jje̱y. Totoʼ huairien huanabaʼ maendik i̱jje̱y. ");
INSERT INTO amrNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Aratbut dakhueaʼda ekaʼnayo kenpaʼti Diostaj dakhueaʼda eʼhuaaʼnayo nopoʼtihuekeʼdik o̱ʼe̱ Diosa. ");
INSERT INTO amrNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Diosen Noki̱re̱gtanayo dakhueaʼda eʼhuaaʼnayo Diosa bakkahueahueʼdik o̱ʼe̱. Menokapiʼ bokkahueahueʼ o̱ʼe̱a̱po Diosa. Diosen Noki̱re̱gtaj dakhueaʼda oʼhuaaʼuyate Diosa okkahuehueʼ o̱ʼunhuahuikaʼapo. Buttida ijjay. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","“Dakhueaʼ noki̱re̱ga̱ Jesústaj oʼnopoʼto̱e̱.” Moisésenbaʼ huamanmadikaʼeria namaʼda onʼhuaaʼnok Jesúsa kenpaʼ oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Kenokaʼ hua̱ye̱ Jesúsen huamaʼbuyere onʼhuatiakuynigʼa huakkaʼnada o̱gkupopaknok bidtemon onʼboatoʼpo “boʼhuatiakne. Yanaʼ,” onaʼnok ");
INSERT INTO amrNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","huakkaʼda aratbut onʼtikupohuadpo, —‍O̱ʼnen hua̱ye̱ o̱ʼnen huamaʼbuyere aratbuttiokpeyon moʼnigbone. Onʼtaj boʼukne. —‍Oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","—‍Be doʼhued hua̱ye̱ ya̱ʼe̱t. Doʼhued huamaʼbuy be ya̱ʼnet. —‍Jesúsa oʼmanaʼpo, ");
INSERT INTO amrNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","kenomey enʼtikupohuadtaj oʼtiokpokubereʼpo, —‍Inomey doʼhued hua̱ye̱ doʼhued huamaʼbuy o̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Kenda Dios oʼpaknok ayaʼada o̱gkikaʼpo doʼhued huamaʼbuy doʼhued huaidpo doʼhued hua̱ye̱ o̱ʼne. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Onteʼti huaboaʼda Jesúsa oʼmanmadikaʼpo e̱ʼpo̱g aktaʼbogpete oʼmanmadikaʼuyate. Huakkaʼada aratbut o̱gkupopaknok kusiʼpe eʼbetyo oʼhuadatoʼpo huakkaʼ aratbutnayo aktaʼbogpete o̱gkupopakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Konig Diosen Huairitaj yanoknopo̱e̱a̱pet aʼmanopo̱e̱yaʼpo oʼmanbatiaʼpakonhuaʼpo oʼmanmadikaʼpo nogda nogda oʼmanbatiaʼpakpo oʼmanmadikaʼpo, ");
INSERT INTO amrNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—‍Yanʼpe̱e̱ʼ: Huabakidenaʼeri aʼbakidenayaʼpo oʼhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Nogyon nogyon oʼbakidenaʼpo sueʼda dagte oʼkidbakotapo, bakoy oʼbatiakpo oʼkidye̱ʼkeaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Sorok buruj huidbate sueʼda oʼkidbakotuyate. Kentaʼ i̱dada oʼkerekuy. Sorok buruj o̱ʼe̱po i̱dada oʼkerekuy. ");
INSERT INTO amrNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ken diga̱ʼ oʼtaʼtedepo eyyaʼ oʼpakpo sueʼda huaʼihuit o̱ʼe̱po oʼayʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Nog huakid okpotaʼpidsiʼbayo oʼkidbakoteaʼpo sueʼda oʼbatipakbonigʼa okpotaʼpidsiʼ diga̱ʼ oʼbakerekpo huakpitaj oʼbatibukʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Nog huakid huadak sorokteda oʼkidbakoteaʼuyate. Oʼbatipakbodepo oʼbakerekdepo huakkaʼkida̱da o̱gkupahuadʼuyate. Noga̱ huakpia treinta huakid o̱gkupa̱e̱po noga̱ huakpia sesenta huakid o̱gkupa̱e̱po nogda cien huakid o̱gkupa̱e̱ʼuyate. —‍Jesúsa kenda oʼmanbatiaʼpakdepo, ");
INSERT INTO amrNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","—‍Beʼapiʼ eʼnopo̱e̱ʼtaʼ eʼpaknayo dakaʼ yanʼpe̱e̱ʼ. Boʼpeokhuadne. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Huakkaʼada aratbut enʼbakhuadeʼte Jesúsen huanigpe̱i̱kaʼeri doce huanigpe̱i̱kaʼeriereyoʼda o̱ʼnepo, “Ken huabakidenaʼeri ken konig o̱ʼe̱ huaboaʼda onʼmanbatiaʼpaknigtaj nopo̱gkahueʼ o̱ʼe̱y. Oroʼtaj dakaʼ moʼnopo̱e̱a̱ʼ.” Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","—‍Dios huairitaj konig aratbuta yanʼnigpe̱i̱kaʼapet opudtanayo dakaʼ eʼmanopo̱e̱a̱ʼtaʼ ijpaki. Nogomeytaj eʼmanopo̱e̱a̱ʼtaʼ pakhueʼ i̱jje̱po ken konig o̱ʼe̱ ijmanbatiaʼpakikay. ");
INSERT INTO amrNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Enʼtiahuayada dakaʼ tiahuayhueʼ o̱ʼneapo. Enʼpe̱e̱a̱da nopo̱gkahueʼ o̱ʼneapo. Nopoʼkoreahueʼ kaʼneʼpo Diosa bakkahueahueʼdik kamagkeʼpo Dios Huairi konig o̱ʼe̱ ijmanbatiaʼpakikay. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","—‍Huabakidenaʼeri konig o̱ʼe̱ nopo̱gkahue e̱e̱ʼnayo nogdakon eʼmanbatiaʼpaknayo menpaʼ nopo̱gkaʼdik moʼe̱a̱pet. ");
INSERT INTO amrNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ken huakid huabakidenaʼeri oʼbakideneaʼnig Diosen huadak huaʼa o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Kenda huakid dagte oʼkidbakot konig aratbuta Diosen huadak huaʼa onʼpe̱e̱a̱toʼnigʼa i̱dada totoʼa huahuaʼ huanopoyaʼ Diosen huaʼataj oʼbakkaynok kenpaʼda oʼnoknopo̱e̱batikapo. ");
INSERT INTO amrNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Huakid huidbayo onʼkidbakot konig aratbuta Diosen huadak huaʼataj durugda onʼpe̱e̱a̱toʼnigʼa. ");
INSERT INTO amrNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Konig sigda huaʼihuit huadak huaʼa sigda oʼnoknopo̱e̱depo dakaʼ nigpeonhuahued o̱ʼnepo onʼnigpe̱e̱a̱toʼnigʼa. Nogok Diosen huadak huaʼa huaknopo̱e̱ʼeri o̱ʼnenok aratbut onʼbatieriknok kenpaʼti castiga onʼmagkaʼnok i̱da oʼnoknopo̱e̱batikapo. ");
INSERT INTO amrNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Nog okpotaʼpidsiʼbayo oʼkidbakot. Ken konig aratbuta huadak huaʼa onʼpe̱e̱po onʼpe̱e̱nigʼa. ");
INSERT INTO amrNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Nogok nogtaʼ nogtaʼ onʼmamepukeʼpo kenpaʼti katepiʼ onʼtiahuayikaʼnigtaj nogi̱ti nogi̱ti onʼpakpo huakkaʼ eʼmato̱e̱ʼtaʼ onʼpakpo, huakkaʼ eʼmato̱e̱ʼnayo durugda i̱jje̱a̱poy namaʼda onʼnopo̱e̱nigʼa nogtaʼ nogtaʼ onʼeretpakpo onteʼti Diosen kahueʼ o̱ʼnikaʼapo. Sigda sigda Diostaj oʼnoknopo̱e̱batikapo. ");
INSERT INTO amrNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Huakid huadak sorokyo oʼkidbakot konig aratbut huadaknopoʼda huadak huaʼa dakaʼ onʼnigpeeonhuahuikaʼpo Diosen batikhueʼda huadakda o̱gkadhuahuikaʼpo Diosensiʼpo o̱ʼne. Noga̱ suhuignada onʼnigpe̱i̱kaʼ. Noga̱ huakkaʼmon onʼnigpe̱i̱kaʼ. Noga̱ huakkaʼnanada onʼnigpe̱i̱kaʼapo. —‍Jesúsa huanigpe̱i̱kaʼeritaj oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Nog Jesúsa oʼmanaʼpo: —‍Sikyo jakki̱re̱gya̱ʼ huakjey eʼbakpakte kosoa huakjeyte tiokkubukhueʼdik o̱ʼnikaʼ. Kenpaʼti huataytoyo huakjey huada̱hueʼdik o̱ʼnikaʼ. Kutopate huakjey onʼhuada̱ʼikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ken konig Diostaj eknopo̱e̱ʼ oy konig eʼi̱re̱gi̱re̱g nogok ayaʼada onʼnopo̱e̱a̱po, ayaʼada onʼtiahuayapo. ");
INSERT INTO amrNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Kenda oʼnonaʼne dakaʼ yanʼpe̱e̱ʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Huadak huaʼatayoʼda dakaʼ yanʼnigpe̱i̱kaʼ. Sigda eʼbayoknayo sigda Diosa boʼyokapone. Huakkaʼ eʼbayokikaʼnayo Diosa huakkaʼ boʼyokapone. Konigti Diosen huadak huaʼataj dakaʼ eʼnigpe̱i̱kaʼnayo Diostaj ʼurunanada moknopo̱e̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Sueʼda eʼpe̱e̱nayo sueʼda eknopo̱e̱ʼnayo Diosa kaknopo̱e̱ʼpo boʼtihuapokapone nogi̱ti nogi̱ti Diostaj moknopo̱e̱a̱po. Dakaʼ pe̱e̱hueʼ e̱e̱ʼnayo Diosen huadak huaʼataj oknopo̱e̱hueʼ e̱e̱ʼnayo kenda moʼnopo̱e̱nigtaj Diosa bokkayapone. Onteʼti oknopo̱e̱hueʼdikada moʼe̱a̱pone. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Nogi̱ti Jesúsa oʼmanaʼpo: —‍Dios Huairitaj huaknopo̱e̱ʼeri in konig o̱ʼe̱: Huabokerekpiʼ eʼborute oʼbakidenaʼpo ");
INSERT INTO amrNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ken oʼtaybedpo nogok oʼtaybedpo nogok huakid oʼtibopo oʼkerek. Monig tibodik ya̱ʼe̱t nopo̱e̱hueʼ o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Sorokyo o̱ʼe̱nok oʼtipakbopo oʼkerek. Huabokerek tihuapokhueʼ e̱e̱ʼtada oʼkerek. Huakkuru huakpi, huametpikon oʼkerek konig huakkaʼ huakid oʼmagkupapakpo ");
INSERT INTO amrNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","eʼmaboyogdeʼte a̱gkupaeayaʼpo taʼbayo oʼhuaʼapo oʼboyognok o̱gkupaeyaʼapo. —‍Jesúsa oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Onteʼti Jesúsa oʼmanmadikaʼpo: —‍Dios Huairitaj huaknopo̱e̱ʼeri ken konig o̱ʼneapo ijmanbatiaʼpakapoy. ");
INSERT INTO amrNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Dios Huairitaj huaknopo̱e̱ʼeri konig mostaza huakid o̱ʼne. Mostaza huakid suhuigkidda o̱ʼe̱po taʼbayo onʼtukikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Eʼbatukdeʼte nogok oʼtipakbopo huaboroʼnanada oʼkerekikaʼ. Huaboroʼnanada o̱ʼe̱nok huaʼopite huakkaʼ bakoya onʼpakkaʼikaʼ. Taʼhuiokte i̱kaʼdik o̱ʼne. Ken konig oy sueʼda Dios Huairitaj huaknopo̱e̱ʼeri o̱ʼne. Nogoknayo huakkaʼnanada huaknopo̱e̱ʼeri o̱ʼneapo. —‍Jesúsa oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ken konig Jesúsa oʼmanmadikaʼpo konig Dios Huairitaj yanʼnigpeunhuahuikaʼapet nogda nogda oʼmanbatiaʼpakikaʼpo. Kenigaʼda eanopo̱i̱kapaʼ pe̱e̱ʼdik yanet oʼmanbatiaʼpakikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Huakkaʼ aratbut e̱gkupopakte Dios Huairitaj ken konig o̱ʼe̱a̱po yanʼnigpeunhuahuikaʼapet oʼmanbatiaʼpakikaʼpo keʼnen huanigpe̱i̱kaʼeritanayo dakaʼ oʼmanopo̱e̱a̱ʼikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ken huameʼnoe baysik huanigpe̱i̱kaʼeritaj oʼmanaʼpo: —‍E̱ʼpo̱g monokteg. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ken huakkaʼ aratbut e̱gkupopakyaʼ oʼnokbahuaʼpo kusiʼpetoneʼyo Jesústaj oʼnontohuaʼpo nog kusiʼpetoneʼere onʼhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","E̱ʼpo̱gnopoyo enhuaʼte huaboroʼbapokada oʼbahuatiakuy. Teyaʼda oʼbapoknok huaboroʼda oʼhue̱niri̱ʼtoneʼpo diga̱ʼda oʼhue̱kudpo huataʼkotdikte o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesúsnayo huataʼpakte colchónte oʼtayʼuyate. Onʼmaboaʼpo, —‍Huataʼkotdikte o̱ʼe̱ne, Huamanmadikaʼeri. ¿Menpaʼ mepuʼkehueʼ i̱ʼe̱? —‍Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ken Jesús oʼmabodpo, “Yabatik, bapokhueʼ ya̱e̱ʼ. Hue̱niri̱hueʼ ya̱e̱ʼ.” Jesúsa onaʼnok oʼbatikanpo bapokhueʼ o̱ʼe̱po kenpaʼti hue̱niri̱hueʼ o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","—‍Menaʼpo diga̱ʼ momeʼpuk. Menaʼpo doʼtaj oknopo̱e̱hueʼ moʼe̱. —‍Jesúsa huanigpe̱i̱kaʼeritaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Huakkaʼda onʼmepuʼkepo, —‍¿Kenpihuay, in huabokerek be ya̱ʼe̱? Kentaj bapoka oʼnigpe̱e̱ kenpaʼti e̱ʼpo̱ga̱ oʼnigpe̱e̱. —‍Huanigpe̱i̱kaʼeria huayahuaya onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Ken akodpen Gadara huadaribayo oʼbetatoʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jesús eʼkotdeʼte kubarakbayaʼ nogbokerektida oʼhuatiakuyate. Kentaj dakhueʼda noki̱re̱ga̱ oʼnopoʼtounhuahuikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Kubarakbayo oʼnoikaʼuyate. Kentaj sirobijtoneʼa̱ tinukuhueʼdik o̱ʼnuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Nogok nogok sirobijtoneʼa̱ huabaʼtaʼkoypiʼ kenpaʼti huaʼitakpi onʼtinukuʼeaʼnigʼa teyda o̱ʼe̱po sirobijtoneʼtaj oʼtipukpukikaʼ kenpaʼti oʼbakpukikaʼuyate. Kentaj to̱e̱hueʼdik o̱ʼnuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Huameʼnoe kenpaʼti sikyo oʼhuaʼepo oteʼyo kenpaʼti kubarakyaʼ oʼsagkiaʼikaʼpo huida̱ huataʼ oʼbitakpo oʼayagsikatokaʼpo oʼkikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Jesústaj oʼtiahuaypo huikudate oʼtisakotuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","—‍Ken huabokerektaj yako̱ro̱k, dakhueʼda noki̱re̱g. —‍Jesúsa onaʼnok huabokereka ʼuttaʼda oaʼtokpo: —‍¿Menaʼpo doʼtaj oʼhuatiak, Jesús? Dios kutayo hua̱e̱ʼerien Huasiʼpo i̱ʼe̱ne. Diosa beʼtihuapokeʼ kenpaʼda castiga o̱gkahueʼ meeʼ. —‍Jesústaj ʼuttaʼda onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","—‍¿Katedik i̱ʼe̱? —‍Jesúsa onaʼuy. Huakkaʼda noki̱re̱g o̱ʼnenok, —‍Doʼhued huadik o̱ʼe̱ “Huakkaʼ,” ");
INSERT INTO amrNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","adyonda oroʼtaj taʼmonahueʼ moeʼ. —‍Jesústaj diga̱ʼ oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kente oteʼte huakkaʼda huakyariʼ onʼpeʼnok, ");
INSERT INTO amrNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","—‍Huakyariere a̱ʼe̱ya̱ʼpo yanʼkud, oroʼtaj yamanaʼ. —‍Jesústaj dakhueʼda noki̱re̱ga̱ oʼnonaʼnok, ");
INSERT INTO amrNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","—‍Yanʼkud. —‍Jesúsa eʼmanaʼte noki̱re̱ga̱ huabokerektaj oʼnenonpo dos mil huakyaritaj onʼhuankudonnok ayaʼda huaduk onʼbahuarakpo kubogyo onʼbaajpo e̱ʼpo̱gyo̱ onʼbataʼkoʼtuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Huakyariʼ huamato̱e̱ʼeriomeya̱ kenda onʼtiahuaydepo onʼmepukeʼpo aʼmanbatiaʼpakyaʼpo huakkaʼ jakyo onʼbakeʼtuyate. Taʼbayo kenpaʼti aʼmanbatiaʼpakyaʼpo onʼhuaʼuyate. Kenda Jesúsa oʼkaʼ onʼpe̱e̱depo Jesústaj onʼhuahuaʼpo ");
INSERT INTO amrNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","oʼnokye̱po ken huabokerektaj huakkaʼ dakhueʼda noki̱re̱ga̱ huaboaʼda enʼmaoro̱kondeʼ onʼtiahuayʼuyate. Ken huabokereka dakaʼ eʼhuadpo yudtaj oʼotpo huadakda o̱ʼe̱po huadakda oʼnopo̱e̱po. Kentaj onʼtiahuaydepo onʼmeʼpukuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Aratbut ke̱yo̱ Jesúsere e̱ʼhua̱e̱a̱ onʼtiahuaydepo kenda Jesúsa oʼkaʼde eatiahuayʼa huakkaʼ jakyo hua̱e̱ʼeritaj onʼmanbatiaʼpakpo, Jesúsa dakhueʼda noki̱re̱gtaj oʼmaoro̱kaʼde kenpaʼti huakyariyo enʼhuankudondeʼte huakyariʼ huaduk onʼbahuarakpo e̱ʼpo̱gyo̱ onʼbataʼkotnig onʼmanbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kenda onʼpe̱e̱depo “Oroʼenbayaʼ yahuadeʼ.” Jesústaj diga̱ʼda oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesús kusiʼpetoneʼyo aʼhuayaʼpo eʼhuaddeʼte ken huabokerekyaʼ dakhueʼda noki̱re̱g oko̱ro̱kaʼniga̱ “onere eʼhuaʼtaʼ ijpaki,” Jesústaj onaʼnok, ");
INSERT INTO amrNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","—‍Doere huahueʼ ya̱e̱ʼ. O̱ʼnen jakyo yahuatiʼ. O̱ʼnen huabettaj yamanbatiaʼpak. “Dios Huairi meʼtinepahuiʼpo beʼyareaʼdene.” Dakaʼ yamanbatiaʼpaktiʼ. —‍Jesúsa ken huabokerektaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ken huabokereka aʼmanbatiaʼpakhuayaʼpo oʼhuaʼpo Decápolis huadaribayo huakkaʼ jakyo huaboaʼda oʼmanbatiaʼpakonhuahuaʼpo “Jesúsa dakhueʼda noki̱re̱gtaj mekmaenameʼne, beʼyareameʼne,” oʼmanbatiaʼpakonhuahuaʼuyate. Ayaʼada onʼpe̱e̱depo “Kenpihuay, ʼurunanada Jesús Huairia oʼkameʼte,” onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Onteʼti akodpen kusiʼpetoneʼyo Jesús eʼkumejdeʼte aktaʼbogpete huakkaʼada aratbuta onʼtikupopakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Jairo judíoen hua̱i̱takeʼ jak huairi o̱ʼu̱yate. Jesústaj oʼhuatiakpo oʼtiahuaydepo huaʼite huikudate oʼtisakotpo, ");
INSERT INTO amrNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","—‍Doʼhued huayetsiʼpo huabueydikte meke̱ne. Betayareʼpo kanoeʼpo huabaʼa beʼtatibataʼtepo doere bohuaʼ. —‍Jesústaj diga̱ʼda onaʼuyatenok. ");
INSERT INTO amrNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jairoere Jesús oʼhuaʼuyate. Eʼhuaʼte huakkaʼada onʼtahuaʼpo aratbutpoyaʼ aʼdayaʼpo oʼnogkaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Huakkaʼ aratbut e̱gkupopakyo ettoneʼ o̱ʼe̱po dakhueʼda o̱ʼe̱po doce huabayok oʼtipokde mimi batikhueʼ o̱ʼunhuahuikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nogtaj nogtaj huamadakkaʼeritaj oʼbahuahuaeʼikaʼuynigʼa ayaʼda keʼnen huakupe eʼyoktada yareahueʼ o̱ʼe̱po nogi̱ti nogi̱ti oʼdakhueʼpakikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Jesúsa huakkaʼtada oʼbayareaʼikaʼ aratbuta onʼbatiaʼpaknok oʼpe̱e̱depo Jesústaʼpiyen oʼhuatiakpo e̱gkupopakyo Jesúsen yudtaj oʼnejpo, ");
INSERT INTO amrNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","“Keʼnen yudtaj eʼnejnayo ijyareapoy.” Huanopoʼada oʼnopo̱e̱po, ");
INSERT INTO amrNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","oʼnejpo mimi oʼbatikonpo “ijyarudi” oʼnopo̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Betapiʼ huaboaʼda ijyareadi Jesúsa oʼnopo̱e̱po huakkaʼ aratbutyo huataʼpiyon oʼkorudpo, —‍¿Beʼa meʼnej? —‍Oʼmanaʼnok. ");
INSERT INTO amrNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","—‍Huakkaʼada aratbutpoyaʼ mondaʼene aʼdayaʼpo mogkaʼne. “¿Beʼa meʼnej?” ¿Menaʼpo iaʼ? —‍Jesúsen huanigpe̱i̱kaʼeria oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jesúsanayo beʼa meʼnejne oʼnopo̱e̱po oʼtiokpokubereʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ken Jesúsa beʼyareadne ettoneʼa̱ oʼnopo̱e̱depo diga̱ʼda oʼmeʼpukpo Jesústaj oʼhuahuaʼpo huaʼite huikudate oʼtisakotpo, “oʼnejne i̱dada ijyarudi,” Jesústaj buttida onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","—‍Doʼtaj oknopo̱e̱nok oʼyareaddene. Dakda i̱ʼe̱po dakaʼda yahuatiʼ, sion. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesúsa ettoneʼtaj eʼbatiaʼpakte Jairoen jakyaʼ huabokerekakon o̱kye̱yakpo, —‍O̱ʼnen huayetsiʼpo oʼbueyde. Huamanmadikaʼeritaj totiakhueʼ ya̱e̱ʼ. —‍Jairotaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesúsanayo kenda oʼpe̱e̱po nigpe̱e̱hueʼ o̱ʼe̱po, —‍Meʼpukhueʼ ya̱e̱ʼ. Doʼhua oʼyareaʼapo meknopo̱e̱ʼ. —‍Jesúsa Jairotaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","—‍Pedro Jacobo Juanereyoʼda do Jairoere huaʼdik o̱ʼne. —‍Oʼmanaʼpo oʼhuaʼpo ");
INSERT INTO amrNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","huairien jakyo o̱kye̱yakdepo huakkaʼ aratbuttaj oʼbatiahuayʼuyate. Ettoneʼsiʼpo eʼbueytaʼ diga̱ʼda onʼbahuikpo onʼsagkiaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Oʼkuddepo, —‍Menaʼpo boʼsagkiaʼpo diga̱ʼda moʼbahuik. Ettoneʼsiʼpo bueyhueʼ o̱ʼe̱. Oʼtaypo o̱ʼe̱. —‍Jesúsa oʼmanaʼnok, ");
INSERT INTO amrNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Jesústaj onʼtierikuynigʼa ayaʼtada oʼmaoro̱kaʼdepo ettoneʼsiʼpoen huaoj hua̱ye̱ keʼnen huatahuaʼeretere ettoneʼsiʼpobuey eʼhuedyo oʼbatokudpo, ");
INSERT INTO amrNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","muneʼyoen huabaʼtaʼ oʼbaʼpadpo, —‍“Talita, cumi.” Yaboʼ, muneʼyo̱siʼpo, onaʼne. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","I̱dada muneʼyo̱siʼpo oʼbodpo oʼhuaeʼuyate. Doce huabayok oʼto̱e̱ʼuyate. Diga̱ʼda onʼmepukeʼpo “kenpihuay” o̱daʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","“Ken boʼtiahuaynig betapiʼ manbatiaʼpakhueʼ yaneʼ.” I̱ghuaʼda oʼmanaʼpo, “muneʼyo̱siʼpotaj aypopiʼ yanʼyok,” oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ken, ke̱ya̱ʼ onʼbakhuaʼpo huanigpe̱i̱kaʼeriere Jesús huaenbayokon o̱kye̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Okmapi̱e̱ʼahuaddik huameʼnoe e̱ʼe̱deʼte judíoen hua̱i̱takeʼ jakyo huaboaʼda oʼmanmadikaʼuyate. ʼUruaʼnanada oʼmanmadikaʼnok judío aratbut onʼpe̱e̱depo onʼmepukeʼpo, —‍¡Kenpihuay! ʼUruaʼda oʼnopo̱e̱. Menpapiʼ huakkaʼda yanopo̱e̱ʼ. Meyo̱piʼ huaboaʼda huakkaʼ yanopo̱e̱ʼ. Kaʼbayareʼpo beʼa yateyyaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Huamenhueaʼeri o̱ʼe̱nigʼa, Maríaensiʼpo o̱ʼe̱nigʼa. Jacobo keʼnen huamaʼbuy o̱ʼe̱ José Simón Judas. Jesúsen huidpopiʼ oroʼere o̱ʼnikaʼ. —‍O̱daʼpo onteʼti eʼpe̱e̱taʼ pakhueʼ o̱ʼnepo konig digda onʼhuanopo̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","—‍Nogbayo hua̱e̱ʼeria Diosen huamanbatiaʼpakeritaj eʼpe̱e̱taʼ onʼpakikaʼ. Huadakda o̱ʼne. Eʼbahuaaʼtaʼ onʼpakikaʼ. Keʼnenbayo hua̱e̱ʼerinayo eʼpe̱e̱taʼ pakhueʼ o̱ʼnikaʼ. Huadakda o̱ʼe̱. Eʼbahuaaʼtaʼ pakhueʼ o̱ʼnikaʼ. Konigti keʼnen huabet keʼnen jakyo hua̱e̱ʼerikon eʼpe̱e̱taʼ pakhueʼ o̱ʼnikaʼ. —‍Jesúsa Nazareteritaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ke̱ya̱ʼ Jesústaj eknopo̱e̱ʼtaʼ pakhueʼ o̱ʼnenok konig Dios teyda kaʼdik o̱ʼe̱nig Jesúsa kahueʼdik o̱ʼe̱nigʼa kenyoʼda sueʼda dakhueʼda oʼtibataʼteaʼpo oʼbayareaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Keʼnenbayo hua̱e̱ʼeri eknopo̱e̱ʼtaʼ pakhueʼ o̱ʼnenok Jesúsa kenpihuay oʼnopo̱e̱ʼuyate. Nogok nogda nogda huakkaʼ jakyo meyo̱hueʼda oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","“Menhuatiak.” Jesúsa doce huanigpe̱i̱kaʼeritaj oʼmanaʼdepo nogda nogda bottaʼ nogyo̱ nogyo̱ oʼmataʼmonaʼpo, —‍Doa oʼnonaʼnok dakhueʼda noki̱re̱gtaj maoro̱kaʼdik moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Dagte boʼhuahuudhuahuikaʼpo katepiʼ tohuahueʼ yanikatiʼ. Oteypaj nogtiyoʼda yanʼtohuaʼ. Huenpu aypo huakupepiʼ tohuahueʼ yaneʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Huaʼiot yanʼotpo, nogtida ʼopiot yanʼotpo nogda tohuahueʼ yaneʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Jakyo boʼkuddepo ke̱yo̱yoʼda yanikatiʼ. Huakkaʼ jakyaʼ yanʼhuaʼepo ke̱yo̱ yanʼtayikatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Jak hua̱ta̱e̱ʼeria opudtaj pakhueʼ e̱e̱ʼnayo kenpaʼti eʼpe̱e̱taʼ pakhueʼ e̱e̱ʼnayo ken jakyaʼ huakkaʼ jakyaʼpiʼ yanʼbakhuatiʼ. Yanʼo̱ro̱kdepo Diostaj dakhueaʼda oʼkaʼdey ayaʼada kanʼnopo̱e̱ʼpo soroka eʼitimabette yanʼitihuekeadtiʼ. Kenomeytaj Diosa diga̱ʼnanada castiga oʼmagkaʼapo. Sodoma huakkaʼ jak hua̱e̱ʼeritaj kenpaʼti Gomorra huakkaʼ jak hua̱e̱ʼeritaj sueʼda castiga oʼmagkaʼapo. —‍Jesúsa doce huanigpe̱i̱kaʼeritaj oʼmataʼmonaʼpo oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ken doce huanigpe̱i̱kaʼeria onʼbahuaʼudhuahuikaʼpo nog huakkaʼ jakyo nog huakkaʼ jakyo onʼhuaʼpo huadak huaʼa onʼmanbatiaʼpakpo “yanʼnopoʼkoreaʼ, Dios Huairitaj yanoknopo̱e̱ʼ,” onʼmanaʼpo ");
INSERT INTO amrNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","dakhueʼda noki̱re̱gtaj onʼmaoro̱kaʼpo kenpaʼti dakhueʼtaj huasihuaa onʼbatikubataʼtepo onʼbayareaduyate. ");
INSERT INTO amrNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Jesúsa ʼuruaʼnanada oʼkikaʼnig huabada aratbut onʼbatiaʼpakikaʼnok Herodes huairia oʼtipe̱e̱depo, —‍Ken Juan bautista o̱ʼe̱taj. Huakudakaʼda e̱e̱ʼtada Diosa oʼnoyhuada̱meʼtenok ʼuruaʼda oʼkikaʼte. —‍Herodes namaʼda oʼnopo̱e̱po Jesústaj oʼtiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","—‍Elías Diosen huamanbatiaʼpakerikudak oʼnoyhuadmeʼte Jesús o̱ʼe̱taj. —‍Nogomeya̱ onʼbatiaʼpakuyate. —‍Diosen aʼneneri huamanbatiaʼpakeri Jesús o̱ʼe̱taj. —‍Nogomeya̱ onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herodes kenda oʼpe̱e̱depo, —‍Keʼna Juan o̱ʼe̱taj. Juantaj yanʼhue̱renokteg iʼmanaʼmeynigʼa oʼnoyhuaddepo Jesús o̱ʼe̱taj. —‍Herodesa oaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Herodías oʼpaknok Herodes huairi Juantaj huabakuda̱ʼ jakyo oʼkudameʼte. Herodías Herodesen huamaʼbuy Felipeen hua̱to̱e̱ e̱e̱ʼtada Herodesa oʼkoreameʼtenok. ");
INSERT INTO amrNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","—‍Huamaʼbuyen hua̱to̱e̱ koreahueʼdik i̱ʼe̱ne. —‍Juana onaʼnok ");
INSERT INTO amrNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodíasa Juantaj diga̱ʼ oʼhuadiaypo eʼaraktaʼ oʼpaknigʼa arakhueʼdik o̱ʼe̱meʼte. ");
INSERT INTO amrNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Juan huadakyoʼda oʼkikaʼ kenpaʼti Diosenyoʼda oʼkikaʼ Herodesa oʼnopo̱e̱po Juantaj dakaʼ oʼtiokikameʼnok Herodíasa arakhueʼdik o̱ʼe̱meʼte. Juantaj oʼpe̱e̱po nopoenkahueʼ e̱e̱ʼpiʼ durugda oʼpe̱e̱meʼte. ");
INSERT INTO amrNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herodesen cumpleaños fiestate Juantaj arakdik i̱jje̱y Herodíasnayo oʼnopo̱e̱meʼte. Fiestate Herodesen huairi Galilea huairitaj oʼbatobapemeʼte. ");
INSERT INTO amrNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","23","Herodíasen hua̱yo̱bu oʼbahuakudpo baile eʼnige̱ʼte huairi Herodesere huakkaʼda onʼdurugpakpo, —‍Katepiʼ iʼpaknig menaʼ oʼyokapone. Huakkaʼpiʼ iʼpaknig oʼyokapone. Buttida ijjay. —‍Herodesa Herodíasen hua̱yo̱butaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Hua̱ye̱taj oʼhuahuatupo, —‍¿Katepiʼ onaʼdik i̱jje̱y? —‍Onameʼte. —‍Juan Bautistaen huaku beyok. Yanaʼ. —‍Onameʼte. ");
INSERT INTO amrNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Herodes huairitaj oʼhuahuaʼdepo, —‍Oyedda baegte Juan Bautistaen huaku beyok. —‍Muneʼyo̱a̱ onameʼte. ");
INSERT INTO amrNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herodes kenda oʼpe̱e̱depo paiʼda eknopo̱e̱a̱da “Ayaʼda katepiʼ on iʼpak menatiʼ kenda ijyokapoy. Buttida ijjay.” Oaʼnig. Ayaʼada onʼpe̱e̱nok nogda eaʼtaʼ pakhueʼ o̱ʼe̱po ");
INSERT INTO amrNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","“Huabakuda̱ʼ jakyo yahuatiʼ. Juantaj yahue̱renokteg. Ya̱gkutotiak. Herodíasen hua̱yo̱butaj yayok.” Herodesa sorotatataj onameʼtenok ");
INSERT INTO amrNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","huabakuda̱ʼ jakyo Juantaj o̱ʼhue̱renoktegpo baegte oʼtotiakpo Herodíasen hua̱yo̱butaj oʼyokmeʼnok keʼna hua̱ye̱taj oʼyokmeʼte. ");
INSERT INTO amrNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Kenda Juanen huanigpe̱i̱kaʼeria oʼnoknopo̱e̱depo onʼtiakpo huabuey onʼtohuaʼpo o̱gkubarakkaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Nogok Jesúste doce huamataʼmoneria onʼkoredepo kenda oʼkadhuahuaʼmey Jesústaj oʼnonbatiaʼpakuyate. Ayaʼda oʼmanmadikikaʼmey oʼnonbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Huakkaʼnada onʼbatiakikaʼnok onʼbahuaʼikaʼnok menokapiʼ bapehueʼdikda o̱ʼnepo, —‍Monhuaʼ. Kente aratbut ehueʼ e̱ʼnikaʼyo okmapi̱e̱ʼahuaddik a̱ʼe̱ya̱ʼpo monhuaʼ. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kente aratbut ehueʼ e̱ʼnikaʼyo kusiʼpete Jesús keʼnen doce huamataʼmoneriere onʼbahuaʼuynigʼa. ");
INSERT INTO amrNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Enʼhuaʼte huakkaʼada onʼbatiahuaypo Jesústaj onʼnoki̱e̱ʼpo ayaʼ huakkaʼ jakyaʼ ke̱yo̱ yanʼbetapet onʼnopo̱e̱po onʼbaketonhuaʼpo huakkuruda onʼbakye̱ʼuyatenok. ");
INSERT INTO amrNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jesús oʼkotpo huakkaʼtada oʼbatiahuaypo kenomey konig oveja o̱ʼnepo huabet to̱e̱hueʼonig o̱ʼnenok Jesúsa oʼmatinepahuiʼpo huaboaʼda oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Huaboaʼ eʼsikonyakte Jesústaj onʼhuatiakpo, —‍Oʼsikde. I̱yo̱ aratbut ehueʼ o̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Aypo to̱e̱hueʼ o̱ʼnenok nog jakyo nog jakyo huakkaʼ jakyo meyo̱hueʼda aypo kanʼbaepo yamataʼmonaʼ. —‍Huanigpe̱i̱kaʼeria oʼnonaʼuynigʼa, ");
INSERT INTO amrNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","—‍Opuda̱ aypo yanʼbayok. —‍Jesúsa oʼmanaʼnok, —‍¿Aypo aʼbayokyaʼpo docientos denario huakupea pan kabaeʼpo menpaʼ huaʼdik o̱ʼe̱ oroʼ? —‍Huanigpe̱i̱kaʼeria oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","—‍¿Meniga̱ʼ pan moʼto̱e̱? Yanʼhuaʼpo yanʼtiahuayʼ. —‍Jesúsa oʼmanaʼuyate. Onʼnopo̱e̱depo, —‍Huabaniga̱ʼ pan bottaʼ biigyo̱ʼda oʼto̱e̱y. —‍Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","“Huakupo huakupoaʼ mire̱bate yanʼbahuad.” Jesúsa oʼmanaʼnok ");
INSERT INTO amrNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","cien kenpaʼti cincuenta huakupo huakupoaʼ onʼbahuaduyate. ");
INSERT INTO amrNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ken Jesús huabaʼte cinco pan bottaʼ biigere oʼbapadpo kurudyo̱ oʼmabopo Diostaj dakiti oʼtionaʼpakdepo pannopote oʼposakeaʼpo huanigpe̱i̱kaʼeritaj kanʼbayokeʼpo oʼbayokeʼuyate. Bottaʼ biigkon okpukpukpo ayaʼtada oʼbayokeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ayaʼada onʼbapeʼpo noteyyaʼ o̱gkaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Onʼtiokayonpo doce kusogyo̱ hueda̱ʼda huataʼsuj onʼdohueaʼuyate. Pan biig huaboroʼ huaenmo boroʼtaʼsujmonere onʼtihueda̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Cinco mil huabokerek ken pan onʼbapeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","“Kusiʼpeyo yanʼkudpo Betsaidayo akudpen huakkuru yanoktegtiʼ.” Jesúsa huanigpe̱i̱kaʼeritaj oʼmanaʼdepo huakkaʼ aratbuttaj jakyoda oʼmataʼmonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Oʼmataʼmonaʼdepo Diostaj aʼtionaʼpakyaʼpo Jesús oteʼyo oʼbehuikpo ijhueʼda oʼtionaʼpakʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Eʼsikdeʼte kusiʼpetoneʼ e̱ʼpo̱gnopoyo o̱ʼe̱nigʼa Jesúsyoʼda huadarite o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","E̱ʼpo̱gnopoyo diga̱ʼ oʼbapoknok eʼnokhuayaga̱ʼtada huahueʼ o̱ʼnuyate. Sikyoedda Jesúsa hua̱hue̱tiudte oʼbahuatiakpo meyo̱hueʼda oʼbatipokaynigʼa, ");
INSERT INTO amrNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","hua̱hue̱tiudte eʼhuaeʼtaj huanigpe̱i̱kaʼeria onʼtiahuaypo aratbuten noki̱re̱g o̱ʼe̱ onʼnopo̱e̱po huakkaʼda onʼmeʼpukpo onʼsagkiaʼuyate. —‍Meʼpukhueʼ yaneʼ. Do i̱jje̱y. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Kusiʼpetoneʼyo oʼkudpo huanigpe̱i̱kaʼeriere onʼhuaduyate. Eʼkudte bapoka oʼbatikonʼuy. Huakkaʼnanada onʼmepukeʼpo “kenpihuay” o̱daʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Jesús oʼpaknok Diosa pan oʼbiameʼ nopoenkahued kenpaʼti Jesús Diosen Huasiʼpo o̱ʼe̱ oknopo̱e̱hued o̱ʼnenok diga̱ʼnanada onʼmeʼpukuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","E̱ʼpo̱gtoneʼ oʼnoktegdepo Genesaret huadaribayo onʼbetdepo oʼnokye̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Enʼkotdeʼte Jesús o̱ʼe̱ aratbut oʼnoki̱e̱ʼdepo, ");
INSERT INTO amrNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Jesúste dakhueʼ e̱ʼhua̱e̱ʼ aʼmanpatotiakyaʼpo nogyon nogyon onʼbaketpo huaboaʼda Jesúste asukte onʼmanpatotiakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Meyo̱piʼ Jesús oʼhuaʼepo jak kuruyo huakkaʼ jakyopiʼ dagte dakhueʼ e̱ʼhua̱e̱ʼ onʼmanpahueda̱ʼpo “O̱ʼnen huaok huakubogpi kanʼnejatueʼpo,” Jesústaj diga̱ʼ oʼnonaʼnok ayaʼada onʼnejdepo Diosa oʼbayareadʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nogok Jerusalénya̱ʼ fariseo huairi Moisésenbaʼ huamanmadikaʼeriere onʼtiakdepo Jesústaj onʼhuahuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Konig adhueaʼpaneʼ bapehued onʼbakoyoʼikaʼuyatenig sueʼada Jesúsen huanigpe̱i̱kaʼeria konig kahueʼ o̱ʼnikaʼpo baʼkoyohueʼada onʼbapikaʼnig judío huairia onʼbatiahuaypo “dakhueaʼda o̱gkikaʼ,” onʼhuaaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Konig adhueaʼpaneʼ o̱gkikaʼuyatenig ayaʼ judíomey fariseoere o̱gkikaʼpo aypo bapehued huakkaʼda onʼbaʼkoyoʼikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Kenpaʼti aypo huabaeʼ jakyaʼ onʼtiakpo bapehued onʼbaʼkoyoʼikaʼ. Vasos, platos, ollas, kutopatakon onʼbaʼkoyoaʼikaʼuyate.) ");
INSERT INTO amrNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Konige̱po fariseoa Moisésenbaʼ huamanmadikaʼerierea Jesústaj oʼnonaʼpo: —‍Aʼnenda oroʼen adhueaʼpaneʼ huadaknopoʼda Diosa meknopo̱e̱ʼpo bapehued onʼbaʼkoyoikaʼuyate. Menaʼpo kenda o̱ʼnen huanigpe̱i̱kaʼeria nigpe̱e̱hueʼada baʼkoyohueʼada yanʼbapeʼikaʼ. —‍Oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","—‍Diosen huamanbatiaʼpakeri Isaías opud namaʼda huanopo̱e̱ʼeritaj dakaʼ boʼtimadoyaʼuyate: In aratbuta Diostaj oʼpaki namaʼda oʼdikaʼnigʼa doʼtaj huanopoyaʼda eretpakhueʼ o̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Namaʼda doʼtaj dakiti moʼtionaʼpakikaʼne. Huabokerekada eʼhuaaʼyoʼda onʼmanmadikikaʼnigʼa. Isaíasa oʼmadoyaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kenda opudomey boʼkikaʼpo Diosen eʼmanaʼbaʼ nigpe̱e̱hueʼada konig opuden adhueaʼpaneʼ o̱gkikaʼnig boʼkikaʼpo vasos platos nogtaj nogtaj boʼkoyoaʼikaʼpo nogda nogdakon boʼkikaʼnigʼa. ");
INSERT INTO amrNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Konig opuden adhueaʼpaneʼ onʼpakpo o̱gkikaʼuyatenig aʼkikayaʼpo Diosenbaʼtaj nigpe̱e̱hueʼada boʼkikaʼne. ");
INSERT INTO amrNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","“O̱ʼnen huaojtaj hua̱ye̱tere nigpe̱i̱kaʼdik moʼe̱ne kenpaʼti tihuapokikaʼdik moʼe̱ne. Paiʼda e̱e̱ʼnayo bayokikaʼdik moʼe̱ne,” kenpaʼti “Huaojtaj hua̱ye̱tapiʼ huasiʼpoa dakhueaʼ eʼhuaaʼikaʼnayo bueydik moʼe̱ne.” Moisésa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","“Huaojtehuapaʼ hua̱ye̱eretehuapaʼ ayaʼda Diostaj oʼbayokdeʼpo opudtaj bayokhueʼdik o̱ʼnene.” Kenpaʼ beʼapiʼ huaojtaj hua̱ye̱tere onaʼdik o̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Kenpaʼ enaʼnayo huaojtaj hua̱ye̱tere tihuapokhueʼdik o̱ʼnepo bayokikahueʼdik o̱ʼnepo namaʼda moʼmanmadikikaʼpo ");
INSERT INTO amrNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ken konig adhueaʼpaneʼ o̱gkikaʼnig boʼkikaʼpo Diosen huaʼataj nigpe̱e̱hueʼ moʼi̱kaʼpo, ken konig nogda nogda namaʼda boʼkikaʼnigʼa. —‍Jesúsa judío huairiomeytaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","“I̱yon yanʼbatiak.” Huakkaʼ aratbuttaj Jesúsa oʼmanaʼpo, —‍Doʼtaj menigpe̱e̱po yanʼnopoenkaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Katepiʼ eʼpeʼpiʼ Diostaj dakhueaʼ eʼkaʼ ehueʼdik o̱ʼe̱. Dakhueʼdik eaʼnayo, da eaʼnayopiʼ Diostaj dakhueaʼ eʼkaʼ e̱ʼdik o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Doʼtaj dakaʼ menigpe̱e̱ʼ. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Huakkaʼda aratbut e̱gkupopakyaʼ Jesúsa eʼbakhuadeʼ jakyo eʼkuddeʼte “Katepiʼ boʼpeʼpo konig Diostaj dakhueaʼ eʼkaʼ ehueʼdik o̱ʼe̱. Iaʼnig. Nopoenkahueʼ o̱ʼnepo dakaʼ monaʼ.” Huanigpe̱i̱kaʼeria Jesústaj oʼmonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","19","—‍Menpaʼ opud kenpaʼti nopoenkahueʼ moʼe̱. Katepiʼ moʼbapeʼpo huaʼaypoyo oʼkudikaʼpo huaminyo oʼhuaʼpo huaminya̱ʼ ken o̱ʼo̱ro̱kikaʼ. Huanopoʼyo kudhueada Diostaj dakhueaʼ eʼkaʼ ehueʼdik o̱ʼe̱. —‍Jesúsa oʼmanaʼuyate. Kenda oaʼnok katepiʼ aypo huaenpiʼ bapeʼdik o̱ʼe̱ne. Ayaʼda bapeʼdik o̱ʼe̱ne, huaboaʼda onʼnopo̱e̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","—‍Huanopoyaʼda dakhueaʼda eʼnopo̱e̱ʼnayo dakhueaʼda boʼkaʼapone, dakhueaʼda boaʼapone. Kennayo Diostaj dakhueaʼda o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Huanopoyaʼda onʼpakpo dakhueaʼda onʼnopo̱i̱kaʼpo, huanopoyaʼda onʼeretpakpo nogen hua̱to̱e̱ onʼbakdejpo, nogtaj nogtaj onʼbakdeikaʼpo, onʼhuadiaypo onʼbarakikaʼpo, ");
INSERT INTO amrNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","huanopoyaʼda onʼpakpo onʼbereikaʼpo, huanopoyaʼda nogen enʼtamaetaʼ onʼeretpakpo, huanopoyaʼda dakhueaʼ o̱gkikaʼpo, huanopoyaʼda namaʼda onʼmanikaʼpo, huanopoyaʼda ayaʼda diga̱ʼda onʼeretpakikaʼpo, huanopoyaʼda digda onʼbahuahuayikaʼpo, huanopoyaʼda onʼbahuaeʼikaʼpo, huanopoyaʼda huataʼtada onʼpakikaʼpo huanopoyaʼda konig nopo̱e̱hueʼada o̱gkikaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ken konig huanopoyaʼda aratbut o̱gkikaʼnok Diostaj dakhueaʼda o̱ʼne. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ke̱ya̱ʼ Jesús oʼhuaʼpo Tiro Sidónere huadaribayo oʼhuaʼuyate. Jakyo oʼkudpo i̱re̱gi̱re̱g eʼkudtaʼ eʼpaktada sueʼada onʼtiahuaynok ");
INSERT INTO amrNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ettoneʼsiʼpoen hua̱ye̱ i̱dada oʼnopo̱e̱po Jesúsen huaʼite huikudate oʼtihuadʼuyate. Keʼnen hua̱yo̱butaj totoʼ noki̱re̱ga̱ oʼnopoʼto̱e̱nok dakhueʼda o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ettoneʼ esoeri o̱ʼe̱po sirofenicia hua̱e̱ʼeri o̱ʼu̱y. “Doʼhued hua̱yo̱butaj totoʼ noki̱re̱gtaj yako̱ro̱kaʼ.” Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","—‍Hueretda judío huasiʼpo huakkuruda bapeʼdik o̱ʼnikaʼ. Huasiʼpoen aypo yokhueʼdik kuhuataj. —‍Jesúsa esoeri ettoneʼtaj onaʼnok, ");
INSERT INTO amrNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","—‍E̱e̱ʼ, Huairi. Kuhuanayo kutopatopen huasiʼpoen eʼtaʼsujkahuaʼ onʼbapikaʼ. —‍Ettoneʼa̱ onaʼnok, ");
INSERT INTO amrNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","—‍Huadaknada menaʼnok huaʼdik i̱ʼe̱. Totoʼ noki̱re̱g hua̱yo̱butaj oʼtako̱ro̱konde. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Jakyo oʼkumejdepo hua̱yo̱bu huatayte dak e̱ʼundeʼte oʼhuednig oʼhuahuayʼuyate. Totoʼ noki̱re̱g o̱ʼo̱ro̱kdeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús Tiro huadaribayaʼ oʼhuaʼpo Sidónyo oʼpokpo Decápolis huadaribayo nog jakyo nog jakyo oʼpokpo e̱ʼpo̱g Galileayo oʼtiakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ke̱yo̱ huabokerektaj onʼhuatotiakpo eʼpeokbet kenpaʼti aʼpakhueʼdik e̱ʼhua̱e̱ʼ, “yatibataʼte.” Jesústaj oʼnonaʼnok ");
INSERT INTO amrNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","huakkaʼ aratbutyaʼ oʼbaktohuaʼdepo oʼpeokbaʼkudpo oʼbapitisupupo oʼnoʼdeyaʼpo, ");
INSERT INTO amrNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","kurudyo̱ oʼtiahuaypo, “aaj” oaʼpo, “yapeokbeteʼ,” oaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","I̱dada oʼpeokbeteonpo oʼnoyarudpo huadakda aʼpakdik o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","“Kenda ijkaʼdey nogomeytaj batiaʼpakhueʼ yaneʼ.” Jesúsa oʼmanaʼnigʼa i̱ghuaʼmon eʼmanaʼtada nogi̱ti huakkaʼmon kenda onʼbatiaʼpakonhuaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Kenpaʼti Jesústaj onʼmepukeʼpo, —‍Ayaʼtada ʼuruaʼnanada oʼkikaʼpo eʼpeokbettaj oʼmape̱e̱a̱ʼapo kenpaʼti aʼpakhueʼdik huaboaʼda aʼpakdik o̱ʼne. —‍Aratbuta onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nogok onteʼti huakkaʼnanada e̱gkupopakte kenpaʼti aypopiʼ ehueʼda o̱ʼu̱yate. Jesús kenda oʼnopo̱e̱po huanigpe̱i̱kaʼeritaj oʼmanaʼpo: ");
INSERT INTO amrNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—‍Inomey aratbut bapaʼmeʼnoeaʼ i̱yo̱da doere o̱ʼnedepo aypobayoʼ o̱ʼnenok ijmatinepahuiʼpo. ");
INSERT INTO amrNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Jakyoda mataʼmonahueʼdik i̱jje̱y. Huakkaʼmon bidteda onʼtiakmeʼtenok eʼmataʼmonaʼnayo dagtaʼ a̱ro̱gdik o̱ʼnenok. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","—‍I̱yo̱ aratbut ehueʼ o̱ʼnikaʼ. ¿Meyo̱ aypo oʼeyapet? —‍Jesúsen huanigpe̱i̱kaʼeria oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","—‍¿Meniga̱ʼ pan moʼto̱e̱? —‍Jesúsa oʼmanaʼnok. —‍Siete. —‍Oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","“Barakte yanʼbahuad.” Jesúsa oʼmanaʼuyate. Siete pan oʼbaʼpadpo, “Dakiti Dios, dakaʼ jokaʼne,” oʼtionaʼpakdepo oʼposakeaʼpo huanigpe̱i̱kaʼeritaj oʼbayokeʼuyatenok aratbuttaj onʼbayokeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Sueʼda biigkon onʼto̱e̱nok “Dakiti Dios” onaʼdepo “yanʼbayokeʼ,” oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Noteymeyaʼda ayaʼada onʼbapeʼuyate. Noteymeyaʼda enʼbapepiʼ siete kusogyo̱ huataʼsuj huedmeya̱ʼda onʼdohueaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Konig cuatro mil onʼbapeʼuyate. “Jakyoda yanʼhuatiʼ,” Jesúsa oʼmanaʼdepo, ");
INSERT INTO amrNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","huanigpe̱i̱kaʼeriere kusiʼpetoneʼyo oʼkuddepo Dalmanuta huadariyo oʼhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Aʼti fariseomey Jesústaj onʼhuatiakdepo huaboaʼda onʼbatiaʼpakpo aʼdikdikyaʼpo, “konig Diosayoʼda kaʼdik kurudya̱ʼ katepiʼ oroʼ tiahuayhueʼ o̱ʼi̱kaʼuynig moʼnigkaʼ,” Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Huanopoyaʼda “aaaj” oaʼdepo, —‍“Konig Diosayoʼda kaʼdik kurudya̱ʼ katepiʼ oroʼ tiahuayhueʼ o̱ʼi̱kaʼuynig moʼnigkaʼ.” Namaʼda oʼnonaʼne. Konig monaʼnig opudtehuapaʼ kahueʼ i̱jje̱a̱poy, buttida ijjay. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Jesús oʼbakhuaʼpo kusiʼpetoneʼyo oʼkudpo akodpen oʼhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Kusiʼpete onʼhuaʼpo pan eʼtohuaʼtaʼ oʼnokkahuuduyate. Nogtiyoʼda onʼto̱e̱ʼuyate kusiʼpeyo. ");
INSERT INTO amrNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","—‍E̱ya̱ʼ, fariseoen eʼbiaʼontaj keyoj ijjay. Herodesen eʼbiaʼontaj keyoj ijjay. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","—‍Pan to̱e̱hueʼ o̱ʼe̱nok kenda monaʼne. —‍Jesúsen huanigpe̱i̱kaʼeria huaboaʼda huayahuaya onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","—‍Pan to̱e̱hueʼ o̱ʼe̱y menaʼpo moʼbatiaʼpak. Pantaj mepuʼkehueʼdik moʼi̱kaʼne. Kenda kaʼdik i̱jje̱y nopo̱e̱hued moʼe̱ kenpaʼti nopoenkahued moʼe̱ne. Menpaʼ huanopoyaʼda oknopo̱e̱hueʼdikda moʼi̱kaʼne. ");
INSERT INTO amrNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Huakpoa mokpo̱e̱nigʼa menpaʼ tiahuayhueʼ moʼe̱. Huapeok boʼpeokje̱ne menpaʼ pe̱e̱hueʼ moʼe̱. Pan ijbiaʼmey menpaʼ bokkahueʼde. ");
INSERT INTO amrNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Cinco mil huabokerektaj cinco pan ijbayokemey. ¿Meniga̱ʼ kusogyo̱ huataʼsuj huedmeya̱ʼda yanʼohueameʼ? —‍Jesúsa oʼmanaʼuyate. —‍Doce. —‍Oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—‍Cuatro mil aratbuttaj siete pan ijbayokemey. ¿Menigaʼ kusogyo̱ huedmeya̱ʼda yanʼohueameʼ? —‍Jesúsa oʼmanaʼnok, —‍Siete. —‍Huanigpe̱i̱kaʼeria oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","—‍Menpaʼ kenda nopo̱e̱hued moʼe̱. —‍Onteʼti oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nogok Betsaida huakkaʼ jakyo onʼtiakuyate. Jesúste ekpobigtaj onʼtotiakpo “yakpotibataʼteʼ,” oʼnonaʼuyatenok ");
INSERT INTO amrNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ekpobigtaj oʼtaʼkoypo huakkaʼ jakyaʼ oʼbaktohuaʼpo igkusi̱ʼhue̱a̱ okpotihuekeʼpo oʼtibataʼtepo, —‍¿Menpaʼ sigpiʼ tiahuaydik i̱ʼe̱? —‍Onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ekpobig oʼtiahuayatupo, —‍Huabokerektaj ijtiahuaypo konig o̱hue̱y onʼhuaʼe. —‍Jesústaj onaʼuyatenok, ");
INSERT INTO amrNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","onteʼti Jesúsa okpotibataʼtenok huaboaʼda ʼurunanada ayaʼtada oʼtiahuayʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","—‍O̱ʼnen jakyo yahuatiʼ. Huakkaʼ jakyo huahueʼ ya̱e̱ʼ. Kenda oʼnigkaʼne batiaʼpakhueʼ ya̱e̱ʼ. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Cesarea de Filipo huadaribayo nog jakyo nog jakyo huanigpe̱i̱kaʼeri Jesúsere onʼhuaʼepo dagte, —‍¿Be o̱ʼe̱a̱ʼ doʼtaj aratbuta menhuaaʼikaʼ? —‍Huanigpe̱i̱kaʼeritaj Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","—‍Juan Bautista on o̱ʼe̱. Noga̱ boʼhuaaʼikaʼne. On Elías o̱ʼe̱. Noga̱ boʼhuaaʼikaʼne. Diosen huamanbatiaʼpakeri o̱ʼe̱. Nogomeya̱ boʼhuaaʼikaʼne. —‍Huanigpe̱i̱kaʼeria oʼnonaʼnok, ");
INSERT INTO amrNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","—‍¿Be o̱ʼe̱a̱ʼ doʼtaj opuda̱ onʼhuaaʼikaʼ? —‍Jesúsa oʼmanaʼuyate. —‍On Diosen Cristo i̱ʼe̱ne. Diosen Huasiʼpo i̱ʼe̱nok Diosa meʼtaʼmonaʼuyne. —‍Pedroa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","—‍Kenda onaʼne beʼtapiʼ manahueʼ yaneʼ. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesúsa huaboaʼda oʼmanmadikaʼpo: —‍Do huabokerek i̱jje̱po Diosyaʼ ijtiakuy. Paiʼnanada ijnopoʼe̱a̱poy. Judío huairitoneʼ, sacerdote huairi, kenpaʼti Moisésenbaʼ huamanmadikaʼerierea doʼtaj eknopo̱e̱ʼtaʼ pakhueʼ o̱ʼnepo menʼarakapone. Bapaʼmeʼnoe eʼpokdeʼte Diosa meʼnoyhuada̱ʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","—‍Jesúsa dakaʼ oʼmanaʼuyatenok Pedroa oʼtohuaʼdepo, “kenpaʼ ahueʼ ya̱e̱ʼ, Huairi,” onaʼuynigʼa ");
INSERT INTO amrNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesúsa oʼbatikorudpo keʼnen huanigpe̱i̱kaʼeritaj oʼtiahuaypo Pedrotaj onaʼpo: —‍Konig huabokerekada namaʼda onʼnopo̱i̱kaʼnig o̱ʼna konigti iʼnopo̱i̱kaʼpo Diosen eʼnopo̱e̱ʼ nopo̱e̱hueʼda i̱ʼe̱ne. Konig totonig iaʼne yahuatiʼ. —‍Jesúsa i̱ghuaʼda onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Huanigpe̱i̱kaʼeritaj kenpaʼti huakkaʼda aratbuttaj menhuatiakdeʼ oʼmanaʼdepo huaboaʼda oʼmanmadikaʼpo: —‍Bepiʼ doʼtaj eʼnigpe̱i̱kaʼtaʼ eʼpaknayo katepiʼ hua̱ʼenda onʼpakikaʼ onaʼti eretpakhueʼ kaʼnikeʼ. Onaʼti doʼhuedyoʼda kanʼpakikeʼ. Kenpaʼti doʼtaj moknopo̱i̱kaʼpo paiʼda nopoʼe̱dik moʼe̱a̱pet. ");
INSERT INTO amrNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Kenpaʼda hua̱ʼenda eʼpaknayo Cristoere kurudyo̱ onteʼti nounhuahuahueʼ o̱ʼnikaʼapo. Doʼtaj eʼnigpe̱i̱kaʼtaʼ onʼpakpo huadak huaʼa huakkaʼ onʼpakpo kenpaʼda hua̱ʼenda pakhueʼ o̱ʼnepo onteʼti Diosere kenpaʼda onʼnoeonhuahuikaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ayaʼada oy katetapiʼ huakkaʼtaʼda onʼeretpakpo onʼbaeʼikaʼpo doʼtaj eʼnigpe̱e̱taʼ pakhueʼ o̱ʼnepo kenpaʼda onʼbueyapo. Kurudyo̱ Diosere noeonhuahuikahueʼdik o̱ʼneapo. ");
INSERT INTO amrNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Diosere aʼnoeonhuahuikayaʼpo katepiʼ Diostaj yokhueʼdik moʼe̱po kenpaʼda doʼtaj pe̱e̱ʼdik moʼi̱kaʼne. ");
INSERT INTO amrNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","In aratbut dakhueaʼda o̱gkikaʼpo Diostaj nigpe̱e̱hueʼ o̱ʼnikaʼpo inomey beʼapiʼ doʼtaj eʼnokbiraʼnayo doʼhued eʼmanmadikaʼtaj enʼtobiraʼnayo nogok do huabokerek i̱jje̱po onteʼti ijtiakdepo kenomeytakon ijbakbiraʼapoy. Diosyaʼ kurudya̱ʼ ijhuarakpo Diosa ʼuruaʼnanada megkaʼnok Diosen huataʼmoneriere ʼuruaʼnanada i̱jje̱po ijtiakapoy. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","—‍Huakkaʼnanada Diosen Noki̱re̱g onʼnopoʼto̱e̱po Dios Huairitaj dakaʼ onʼnigpe̱i̱kaʼapo. Kenpaʼ opudomey huakkaʼmon bueyhued moʼe̱po boʼtiahuayapo. Buttida ijjay. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Seis huameʼnoe eʼpokdeʼte Pedrotaj Jacobotaj Juantere oʼbatohuaʼpo huakupa kutayo Jesúsa oʼbatobehuikuyate. Enʼtiahuayte Jesúsen huakok konig niokpo oʼkokeypakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Yudtakon diga̱ʼda oʼtakeregpakatupo konig senogda o̱ʼe̱tuyate. Aratbutnayo konig keregda kahueʼdik o̱ʼnikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Elíastaj Moiséstaj Jesúsere enʼbatiaʼpakte onʼbatiahuayʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","—‍Oroʼ i̱yo̱da o̱ʼe̱po huadakda o̱ʼe̱ne. Bapaʼ bak oʼkayʼ. Ontehuapaʼ nogtida Moiséstaj nogtida Elíastaj nogtida oʼkayʼ, Huairi. —‍Pedroa onaʼpoda onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pedromey diga̱ʼda onʼmepukeʼpo koniga̱ʼ aʼayʼ Pedroa nopo̱e̱hueʼada oaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kenpaʼ enaʼte e̱ʼsi̱hui̱a̱ oʼbatibukʼuyate. E̱ʼsi̱hui̱ya̱ʼ onʼpe̱e̱po: —‍In doʼhued Huasiʼpo meʼta̱e̱ne. Huadiʼda meʼta̱e̱ne. Kentaj yanʼnigpe̱i̱kaʼ. —‍Diosa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Aʼtida enʼtiahuayte Jesústayoʼda onʼtiahuayʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Huakupayaʼ enʼhuarakdeʼte —‍Do huakudakaʼda eʼbueyada noyhuadhued e̱e̱ʼted kenda huakupayo huaboaʼda boʼtiahuaynig batiaʼpakhueʼ yaneʼ. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Konige̱po kenda batiaʼpakhueʼ o̱ʼneʼuynigʼa huayahuayayoʼda kate eʼnoyhuadtaj Jesúsa yaʼbatiaʼpak onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Konige̱po Jesústaj: —‍“Cristo tiakhued e̱e̱ʼted Elías huakkuruda tiakdik ya̱ʼe̱a̱pet.” ¿Menaʼpo Moisés huamanmadikaʼeri kenda yadikaʼ? —‍Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","—‍Elíasonigti huakkuruda tiakdik o̱ʼe̱a̱po. Ayaʼtada aʼmanopoʼyareayaʼpo yatiakapet. Diosen Huasiʼpo paiʼnada yaʼnopoʼe̱a̱pet. Kentaj yanʼtibiraeʼapet. Kenda huaojbaʼte onʼmadoyaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Elíasonigti eʼtiaktada onʼtibiraeʼpo konigti onʼpakpo dakhueaʼ o̱gkameʼte. Konig Apagbaʼa oaʼnig o̱gkameʼte. —‍Jesúsa Pedromeytaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jesúsen huanigpe̱i̱kaʼerite onʼbahuaʼpo o̱kye̱hued e̱e̱ʼted huakkaʼnada eʼkupopakada Moisésenbaʼ huamanmadikaʼeria Jesúsen huanigpe̱i̱kaʼeritaj enʼmaboyte Jesúsomey onʼbatiahuayatoʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Jesústaj onʼtiahuaydepo onʼmepuʼkepo onʼhuaketonyakpo durugteda onʼbaakaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","—‍¿Kateaʼ yanʼbatiaʼpak? —‍Oʼmanaʼnok ");
INSERT INTO amrNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","nogtiada oaʼtokpo, —‍Doʼhued huasiʼpotaj dakhueaʼ totoʼ noki̱re̱ga̱ oʼnopoʼto̱e̱nok aʼpakhueʼdik o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kenpaʼti menokapiʼ eʼnopoʼto̱e̱te oʼketpakonpo barakte o̱ʼhue̱kikaʼpo kutajpoaʼ o̱ʼo̱ro̱kikaʼpo huaʼid oʼidtaʼpeteyeʼpo diga̱ʼda o̱ʼa̱ro̱gnok ontaj oʼtotiakne. “Dakhueʼ noki̱re̱gtaj ya̱ʼnoro̱kaʼ,” o̱ʼnen huanigpe̱i̱kaʼeritaj eʼmanaʼtada o̱ro̱kahueʼ o̱ʼne, Huamanmadikaʼeri. —‍Nogtiada onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","—‍Opudomey judío aratbut doʼtaj eknopo̱e̱ʼtaʼ pakhueʼ moʼe̱ne. Oknopo̱e̱hueʼ hua̱e̱ʼeri moʼe̱ne. Dios teyda o̱ʼe̱po bayareaʼdik o̱ʼe̱ oknopo̱e̱hueʼda moʼe̱ne. Ijhueʼtaʼda doʼtaj moknopo̱e̱ne. Huasiʼpotaj yanʼtotiak. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Huasiʼpotaj onʼtotiaknok dakhueaʼ noki̱re̱ga̱ Jesústaj oʼtiahuaydepo huasiʼpotaj oʼketpakonkaʼnok sorokte o̱ʼhue̱kpo, oʼpokoreʼepo oʼtiokkutajo̱ro̱kuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","—‍¿Menigaʼ huabayokaʼ dakhueaʼ noki̱re̱ga̱ yaʼnopoʼto̱i̱kaʼpo yaʼketpakonkaʼikaʼ? —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","—‍Siʼnog e̱e̱ʼted nogok nogok huakkaʼda dakhueʼ noki̱re̱ga̱ aʼarakyaʼpo taʼakyo hua̱hue̱yo̱piʼ oʼenikaʼ. Kaʼdik e̱e̱ʼnayo oroʼtaj moʼmatinepahuiʼpo boʼtihuapok. —‍Keʼnen paga̱ onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","—‍Doʼtaj eknopo̱e̱ʼnayo ayaʼtada kaʼdik i̱jje̱po yareaʼdik i̱jje̱y. —‍Jesúsa onaʼnok, ");
INSERT INTO amrNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","—‍Yoknopo̱e̱y, nogi̱ti nogi̱ti eknopo̱e̱ʼ beʼtihuapok. —‍ʼUttaʼda onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Huakkaʼ aratbut onʼkupopaknok Jesúsa oʼtiahuaypo, —‍Eʼpeokbet aʼpakhueʼdikere noki̱re̱g ya̱o̱ro̱kpo huasiʼpoyaʼ yakhuatiʼ onteʼti aʼkudyaʼpo tiakhueʼ ya̱e̱ʼ. —‍Jesúsa dakhueʼ noki̱re̱gtaj huiyokda onaʼnok, ");
INSERT INTO amrNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","dakhueʼ noki̱re̱ga̱ oʼsagkiadpo oʼketpako̱gkaʼpo eʼbueyonig o̱ʼo̱ro̱kpo oʼenonʼuyate. Konige̱po “eʼbuey o̱ʼe̱,” huakkaʼmon onʼbatiaʼpakuynigʼa ");
INSERT INTO amrNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Jesúsnayo oʼtaʼkoypo oʼboaʼuyate. Huasiʼpo oʼbodu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Jesús jakyo oʼkuduyate. Huanigpe̱i̱kaʼeriyoʼda kenere o̱ʼnepo, —‍¿Oroʼnayo dakhueʼ noki̱re̱gtaj menaʼpo o̱ro̱kahueʼ o̱ʼe̱? —‍Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","—‍Bapehueʼ moʼunhuaʼpo kenpaʼti moʼtionaʼpakonhuaʼpo dakhueʼ noki̱re̱gtaj taʼmonaʼdik moʼe̱ne. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ke̱ya̱ʼ oʼhuaʼpo Galileayo konig i̱re̱gi̱re̱gteda oʼpokonhuaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Huanigpe̱i̱kaʼeritaj oʼmanmadikaʼpo i̱re̱gi̱re̱gteda oʼhuaʼonhuaʼpo. “Do Huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne. Huabokereka menʼbahuatitotiakapet. Menʼarakapone. Bapaʼmeʼnoe huakudakaʼda e̱ʼe̱a̱da ijnoyhuadapoy.” Jesúsa oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Huanigpe̱i̱kaʼerinayo kenpaʼ nopoenkahueʼ o̱ʼnepo onʼmeʼpakpo “¿monig ya̱ʼe̱?” onahueʼ o̱ʼnuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Capernaumyo onʼtiakdepo jakyoda o̱ʼe̱a̱toʼpo, —‍¿Dagte oʼtiakpo katetaj moʼbatiaʼpak? —‍Jesúsa huanigpe̱i̱kaʼeritaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","“¿Beʼa hueret huairida e̱ʼdik ya̱ʼe̱t?” onʼbatiaʼpakpo aʼtokhueʼ o̱ʼnuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jesús huanigpe̱i̱kaʼeritaj aʼmanmadikayaʼpo oʼhuadpo “yanʼkupopak,” oʼmanaʼpo, —‍Bepiʼ doere huairi e̱e̱ʼtaʼ eʼpaknayo nog aratbuten huanabaʼnig kaʼnikeʼ konig nogtaj kanʼtihuapokikeʼ. —‍Oʼmanaʼpo ");
INSERT INTO amrNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","huasiʼpotaj oʼtaʼkoypo nopoyo oʼtotiakpo huaʼopite oʼdokoʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—‍Do ijpaknok beʼapiʼ in huasiʼpotaj diʼda oʼdepo oʼtihuapokikaʼpo konigda doʼtakon oʼde doʼhued Apagtakon oʼde. Keʼna meʼtaʼmonaʼuyne. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","—‍Nogbokereka o̱ʼnendik oʼdikkaʼpo totoʼtaj oʼmaenikaʼ. Oʼtiahuaypo oroʼere huahueʼ o̱ʼi̱kaʼnok, “Kejeʼ, kahueʼ ya̱e̱ʼ.” Onaʼmey, huamanmadikaʼeri. —‍Juana onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","—‍Kentaj “kahueʼ ya̱e̱ʼ,” onahueʼ yaneʼ. Beʼapiʼ konig tiahuayhued o̱ʼi̱kaʼnig doʼhued huadik oʼdikkaʼpo ekaʼnayo onteʼti doʼtaj dakhueʼ huaahueʼdik o̱ʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ken aratbuta oroʼomeytaj dakhueaʼ e̱gkaʼtaʼ pakhueʼ o̱ʼnepo oroʼomeytaj boʼtihuapokne. ");
INSERT INTO amrNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Cristoen huanigpe̱i̱kaʼeri moʼe̱nok do ijpaknok beʼapiʼ huamaiʼ hue̱ʼe̱y eʼyoknayo dapiʼ Diosa dakhuapa oʼbayokapo. Buttida ijjay. —‍Jesúsa oʼmanaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","—‍Beʼapiʼ doʼhued ʼuru huaknopo̱e̱ʼeritaj dakhueaʼ eʼbatokaʼnayo keʼponanada castiga Diosa o̱gkadhuahuikaʼapo. Konige̱po doʼhued ʼuru huaknopo̱e̱ʼeritaj dakhueaʼ eʼbatokaʼtaʼ eʼpaknayopiʼ dakhueaʼ batokahued huidtoneʼ keʼnen hua̱hue̱rentaʼ yanʼtiontidukupo taʼkotdik a̱ʼe̱ya̱ʼpo jod ya̱koyo eʼkotnayo kenda konig sueʼda castiga eʼmagkaʼ o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","48","Huabaʼpiʼ huaʼipiʼ huakpopiʼ dakhueaʼ eʼkaʼ huataʼda eʼtokaʼnayo dakhueʼnanada o̱ʼe̱nok Diosa castiga oʼmagkaʼpo taʼakyo oʼenapo. Taʼak oʼbakpakonhuahuikaʼapo bakayhueʼ o̱ʼe̱a̱po. Konige̱po huabaapiʼ huaʼiapiʼ huakpoapiʼ dakhueaʼ eʼtokaʼtaʼ eʼpaknayo dakhueʼda o̱ʼe̱po kahueʼdik a̱ʼe̱ya̱ʼpo eʼboktegnayopiʼ huadak ya̱ʼe̱a̱pet, dakhueaʼ kahueʼdik a̱ʼe̱ya̱ʼpo ekpokotoknayopiʼ huadak ya̱ʼe̱a̱pet. Ken konig yanʼnopo̱e̱po dakhueaʼ kahueʼ yanikaʼ. Dakhueaʼ ekaʼnayo Diostaj dakhueaʼ bokaʼnok castiga mogkadhuahuikaʼapone. Taʼakyo moʼbakpakonhuahuikaʼapone. Bakayhueʼdik o̱ʼunhuahuikaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Sal paiʼ e̱ʼe̱a̱da huadakda oʼkikaʼnig konigti paiʼda moʼnopoʼe̱po huadakda moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sal huadakda o̱ʼe̱po oʼkikaʼ. Paiʼ ehueʼ e̱e̱ʼnayo huadak kahueʼdikda enʼdik o̱ʼe̱ne. Konig salonig ya̱ʼnepo huadaknopoʼda huayahuaya diʼ yanʼmaepo yanʼmanoeyikaʼ. —‍Jesúsa huanigpe̱i̱kaʼeritaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ke̱ya̱ʼ Jesúsa oʼbakhuaʼpo Judeayo kenpaʼti Jordán akodpen huadariyo oʼhuaʼuyate. Eʼtiakte onteʼti huakkaʼnanada o̱gkupopakuyate. Konig oʼkikaʼpo oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Jesústaj aʼdikdikyaʼpo sueʼda fariseo onʼhuahuaʼpo, “¿Huabokerek hua̱to̱e̱ʼtaj menpaʼ kenpaʼda endik ya̱ʼe̱?” Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","—‍¿Kate yamanaʼuyate Moisésa? —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","—‍“Hua̱to̱e̱ e̱ʼen berobaʼ madoyaʼdik moʼe̱po hua̱to̱e̱ endik moʼe̱.” Moisésa oʼmanaʼuyate. —‍Oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","—‍Konig nopoteyda moʼi̱kaʼpo Diostaj eʼnigpe̱i̱kaʼtaʼ pakhueʼ moʼi̱kaʼnok Moisésa kenda oʼmadoyaʼuynigʼa. ");
INSERT INTO amrNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Huakkuruteda Diosa ayaʼtada oʼkaʼuypo huabokerek ettoneʼere oʼkaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Konige̱po huabokerek keʼnen huaoj hua̱ye̱eretaj oko̱ro̱kpo ettoneʼtaj aʼto̱e̱pakyaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Bottaʼ e̱ʼe̱a̱da onʼto̱e̱pakdepo konig nogtida o̱ʼnede.” Apagbaʼte kenpaʼ oaʼ. Bottaʼ e̱ʼe̱a̱da nogtida o̱ʼnede. ");
INSERT INTO amrNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kenda Diosa oʼto̱e̱pakaʼdenok huabokereka enhueʼdikda o̱ʼne. —‍Jesúsa fariseomeytaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nogok huanigpe̱i̱kaʼeriere jakyoda o̱ʼnepo, “¿Hua̱to̱e̱ menpaʼ enʼdik o̱ʼe̱?” Jesúsen huanigpe̱i̱kaʼeria oʼnonaʼnok, ");
INSERT INTO amrNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","—‍Beʼapiʼ huabokerek hua̱to̱e̱ʼtaj e̱ʼennayo nogtaj oʼto̱e̱pakpo huakkuru hua̱to̱e̱ʼtaj dakhueaʼda o̱gkaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Kenpaʼti ettoneʼa̱ hua̱to̱e̱ʼtaj e̱ʼennayo nogtaj oʼto̱e̱pakpo dakhueaʼda oʼkaʼ. Diostaj dakhueaʼda oʼkaʼ. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Jesúsa dakaʼ kanʼbakeʼpo huasiʼpo kentaj enʼbatotiaktada keʼnen huanigpe̱i̱kaʼeria “kejeʼ, batotiakhueʼ yaneʼ,” onʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Kenda Jesús oʼtiahuaypo oʼdiayatupo. —‍Huasiʼpo doʼte kanʼbatiakeʼ. “Ka̱e̱ya̱ʼ,” manahueʼ yaneʼ. Konig inomey ʼurunopoʼda huasiʼpo o̱ʼne konigti aratbut huaknopo̱e̱ʼeri Diosensiʼpo o̱ʼnepo Dios Huairitaj onʼnigpe̱i̱kaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Huasiʼpo doʼtaj ʼurunopoʼda menoknopo̱e̱po menʼnigpe̱i̱kaʼne. Konig huasiʼpo Dios Huairitaj dakaʼ oʼnoknopo̱e̱nig konigti opudomey oknopo̱e̱hueʼ e̱e̱ʼnayo Dios Huairiensiʼpo ehueʼdik moʼe̱a̱pone. Buttida ijjay. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Huasiʼpotaj oʼbadokoeʼpo oʼbatibataʼteʼepo Diosa dakaʼ kabakeʼpo oʼmationaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Dagte Jesúsa huaboaʼda oʼhuaʼdepo huabokereka oʼhuaketonyakpo huikudate oʼtihuadpo, —‍¿Kurudyo̱ Diosere aʼnoeonhuahuikayaʼpo kate huadakda kikaʼdik i̱jje̱, huadakda huamanmadikaʼeri? —‍Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","—‍Kaʼtiaʼpo huadakda i̱ʼe̱ne onaʼ. Diosyoʼda huadakda o̱ʼi̱kaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Diosen eʼmanaʼ iʼnopo̱e̱. Nogen hua̱to̱e̱ʼtaj bakdejhueʼ ya̱i̱kaʼ. Aratbuttaj yahuadiaypo arakhueʼ ya̱i̱kaʼ. Nogen bakberehueʼ ya̱i̱kaʼ. Namaʼda bahuaahueʼ ya̱i̱kaʼ. Da ahueʼ ya̱i̱kaʼ. Huaojtaj hua̱ye̱tere dakaʼda yanigpe̱i̱kaʼpo dakaʼ yamato̱i̱kaʼpo yabayokikaʼ. Kenpaʼ Diosa oʼmanaʼuyate iʼnopo̱e̱ne. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","—‍Do huasiʼpoedanda kenda ayaʼda ijnigpe̱i̱kaʼuy, Huamanmadikaʼeri. —‍Huabokereka onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesúsa diʼ o̱ʼe̱po oʼtiahuayatupo, —‍Nogitied kaʼdiken i̱ʼe̱ne. Huakupete ayaʼda iʼtamaetnig yabahuayaʼ. Ken huakupe yabaedepo paiʼda aratbuttaj yabayokeʼ. Kenda on ekaʼnayo kurudyo̱ Diosere huakkaʼda iʼmatounhuahuikaʼapone. Doʼtaj behuatiakpo betaʼhuaʼikaʼ eʼbueypiʼ betaʼhuaʼikaʼ. —‍Jesúsa huairitaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Huairia kenda oʼpe̱e̱po nohueʼ o̱ʼunpo huakkaʼnanada oʼtamaenok suhueʼnanada o̱ʼe̱po okhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Huanigpe̱i̱kaʼeritaj okpokuberudpo, —‍Bepiʼ huairi huakkaʼnada eʼmato̱e̱ʼtaʼ huaeretpakeri Dios Huairitaj oknopo̱e̱hueʼdik o̱ʼneapo, Diosensiʼpo ehueʼdikda o̱ʼne. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Huanigpe̱i̱kaʼeria Jesúsen huaʼataj oʼpe̱e̱po onʼmepukeʼnok onteʼti Jesúsa oʼmanaʼpo: —‍Huakkaʼda eʼmato̱e̱ʼtaʼ huapakeria Dios Huairitaj oknopo̱e̱hueʼdik o̱ʼneapo. Diosensiʼpo ehueʼdikda o̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Konig camello huaboroʼ ʼuhua sakpiʼpe̱yo̱ kudhueʼdik o̱ʼe̱. Konigti huairi huakkaʼda onʼmato̱e̱po Diosensiʼpo ehueʼdikda o̱ʼneapo. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Huanigpe̱i̱kaʼeria kenda onʼpe̱e̱po huakkaʼda onʼmepuʼkepo huayahuaya onʼbatiaʼpakpo: —‍¡Kenpihuay! ¿Beʼa Diosensiʼpo e̱ʼdik ya̱ʼneapo? ¿Beʼa Diosere onteʼti noeonhuahuikaʼdik ya̱ʼneapo? —‍Onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesúsa oʼbatiahuaypo oʼmanaʼpo: —‍Huabokereka huataʼda nopoʼyareahueʼdik o̱ʼne. O̱ʼnada onʼpakpo noeonhuahuikahueʼdik o̱ʼneapo. Diosayoʼda nopoʼyareaʼdik oʼmae kenpaʼti onteʼti manoeanhuahuikaʼdik oʼmae. Diosayoʼda ayaʼda kaʼdik o̱ʼe̱. —‍Oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","—‍Oroʼnayo ayaʼda oʼmato̱i̱kaʼnig oʼmaenonʼuy. Ontaj ataʼhuayaʼpo ayaʼda oʼmaenondemey. —‍Pedroa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","—‍Ayaʼada keʼnen jak kenpaʼda o̱ʼnen, huamaʼbuytaj huidpotapiʼ o̱ʼnen, huaojtaj hua̱ye̱tapiʼ o̱ʼnen, hua̱to̱e̱ʼtaj huasiʼpotaj taʼbapiʼ o̱ʼnen. Huadak huaʼa oʼderetpakpo kenpaʼti doʼtayoʼda aʼnigpe̱i̱kayaʼpo o̱ʼnen. ");
INSERT INTO amrNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","Oʼnennok Diosa oy huakkaʼnanada oʼbayokapo. Jak, huamaʼbuy, huidpo, hua̱ye̱ huasiʼpo, taʼbakon oʼbayokapo. Paiʼda eʼnopoʼe̱bet oʼbayokapo. Nogok Diosere onʼnoeonhuahuikaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Oy huakkaʼda huairi e̱ʼe̱a̱da nogok huairida ehueʼ o̱ʼneapo. Konig huanabaʼ o̱ʼneapo. Huakkaʼmon konig huairionig ehueʼda o̱ʼnikaʼnig konig huanabaʼda oy o̱ʼnikaʼnig. Nogoknayo ʼuruaʼda o̱ʼneapo. Konig huairitoneʼ o̱ʼneapo. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jerusalényo̱ dagte Jesús huanigpe̱i̱kaʼeriere onʼbehuikpo Jesús huakkuruda oʼhuaʼenok huanigpe̱i̱kaʼeri onʼmepukeʼpo nogomey onʼtahuaʼpo onʼmeʼpukuyate. Doce huanigpe̱i̱kaʼeritaj nogyonda oʼbatohuaʼpo konig megkaʼapone oʼmanaʼpo: ");
INSERT INTO amrNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—‍Jerusalényo̱ oʼhuaʼne. Do huabokerek i̱jje̱po Diosyaʼ ijtiakuy. Jerusalényo̱ huabokereka sacerdote huairiomeytaj menʼyokapone. Moisésenbaʼ huamanmadikaʼeritere menʼyokapone. Ken bueydik o̱ʼe̱ menʼhuaaʼapone. Nog aratbuttaj judío ehueʼtaj doʼtaj menyokapone. ");
INSERT INTO amrNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nog aratbuta doʼtaj menʼtierikapone. Huiyokda pidetbiʼa menʼbitbitapone. Mentisupuʼeapone. Meʼdarakapone. Bottaʼaʼ eʼtisikdeʼte kubarakyo huakudakaʼda e̱ʼe̱meʼtada Diosa meʼnoyhuada̱ʼapone. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Zebedeoen huasiʼpo Jacobo Juanere Jesústaj onʼhuahuaʼpo, —‍Kenda onaʼnig oroʼtaj mogkaʼ, huamanmadikaʼeri. —‍Juan Jacoboere oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","—‍¿Kate boʼpak? —‍Jesúsa oʼmanaʼnok. ");
INSERT INTO amrNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","—‍O̱ʼna ʼuruaʼnanada huakhuairi e̱ʼe̱deʼte konig huairi e̱ʼhua̱e̱ʼ onte daʼkopen opeʼtopen bohuada̱ʼ. —‍Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","—‍Kenpaʼ onahueʼ meneʼ. Do paiʼda ijnopoʼe̱a̱poy. ¿Menpaʼ doere konigti paiʼda nopoʼe̱ʼdik moʼe̱? —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","—‍E̱e̱ʼ, onere paiʼda nopoʼe̱ʼdik o̱ʼe̱y. —‍Jesústaj oʼnonaʼuyate. —‍Buttida ijjay, konig paiʼda ijnopoʼe̱a̱poy opud konigti paiʼda nopoʼe̱ʼdik moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Nogok do huakhuairi i̱jje̱depo ijmanaʼikaʼapoy. Doere huakhuairi kaʼneʼpo doʼhuanayo yahueahueʼdik o̱ʼnene. Kenomey doʼhued Apag Dios aʼnennada oʼbaktieʼeaʼuynigtaj doere huairi oʼbayahueaʼapoy. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nog diez huamataʼmoneria kenda onʼmape̱e̱po Jacobotaj Juantere onʼmahuadiayʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","—‍Inte yanʼbatiak —‍Jesúsa oʼmanaʼpo—‍ Nog aratbuten gobierno huairitoneʼ kenpaʼda teyda onʼmanaʼikaʼnok kenomeyen aratbut huairitaj nigpe̱i̱kaʼdik o̱ʼnikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Opudnayo ken konig kikahueʼdik moʼe̱ne. Beʼapiʼ huairi e̱e̱ʼtaʼ eʼpaknayo nog aratbuttaj kanʼbatihuapokikeʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Kenpaʼti beʼapiʼ doere huairi e̱e̱ʼtaʼ eʼpaknayo konig nog aratbuten huanabaʼ kaʼnikeʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Konig do ijkikaʼnig konigti ya̱gʼkikaʼ. “Konig huanabaʼ mentihuapok.” Aʼikayaʼpo tiakhueʼ i̱jju̱y. Aratbuttaj aʼtihuapokyaʼpo ijtiakuy. Aratbuten dakhueaʼ eʼkaʼtaj aʼbakkahueayaʼpo aʼmanigbueyyaʼpo Apag Diosyaʼ ijtiakuy. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ken Jericó huakkaʼ jakyo onʼbatiakuyate. Huakkaʼ jakyaʼ onʼpokondepo Jesús huanigpe̱i̱kaʼeriere huakkaʼnanada aratbutere eʼnoro̱kte Bartimeo ekpobig Timeoen huasiʼpo dagte oʼhuadpo “huakupe beyok,” oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","“Jesús Nazaret hua̱e̱ʼeri oʼpokde,” aratbuta enhuaaʼte oʼpe̱e̱po ʼuttaʼda onaʼpo, —‍Metinepahuiʼ, Jesús Daviden adhueaʼ huasiʼpo. —‍Ekpobiga̱ ʼuttaʼda onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","—‍Yabatikdeʼ. —‍Aratbuta huiyokda eʼnonaʼtada nogi̱ti huakkaʼaʼda oʼnokoyeʼuyate. —‍Metinepahuiʼ, Jesús Daviden adhueaʼ huasiʼpo. —‍ʼUttaʼda onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ken Jesús eʼhuaʼada oʼboatoʼpo, —‍Yanʼtotiak. —‍Jesúsa oʼmanaʼnok onʼhuahuaʼdepo, —‍Yadurugpakpo yabod. Jesúsa “Yatiak” menaʼne. —‍Oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Huaok oʼenpo oʼbodpo Jesústaj oʼhuatiakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","—‍¿Kate iʼpak? —‍Jesúsa onaʼuyate. —‍Ekpoyareaʼtaʼ ijpaki, Huamanmadikaʼeri. —‍Ekpobiga̱ onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","—‍Doʼtaj meknopo̱e̱po yayarudpo yahuatiʼ. —‍Jesúsa onaʼuynok ekpobig huaboaʼda oʼtiahuaypo Jesústaj dagte oʼtahuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jerusalén meyo̱hueʼda e̱ʼe̱deʼte Betfagéte kenpaʼti Betaniate kenpaʼti oteʼ Olivoste o̱ʼnedepo, bottaʼ huanigpe̱i̱kaʼeritaj: ");
INSERT INTO amrNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—‍Butukda yanʼhuatiʼ. Huakkaʼ jakyo yanʼhuatiʼ. Ke̱yo̱ burro ʼuhua enukuʼ boʼhuahuayapone. Ken burrote bepiʼ huadhued o̱ʼne. Yanogkujpo doʼtaj menigtotiak. ");
INSERT INTO amrNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","“¿Manaʼpo boʼtohuaʼ?” Beʼapiʼ enaʼnayo “Huairia oʼpaknok oʼkay. Huaboaʼda onteʼti oʼtotiakapoy.” Yaʼnonatiʼ. —‍Jesúsa bottaʼ huanigpe̱i̱kaʼeritaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ken onʼhuaʼpo dagte akbogpete burro ʼuhua enukuʼ onʼhuahuaypo oʼnogkujuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","E̱gkujte huabokerek kenteda o̱ʼnepo, —‍¿Kate bokaʼ? ¿Menaʼpo burrotaj mogkuj? —‍Onʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Konig Jesúsa oʼmanaʼnig kenda onʼmanaʼnok “tohuaʼdik moʼe̱,” onʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Jesúste burrotaj onʼtohuaʼpo kenomeyen huaokaʼ burrotaʼpite onʼhueda̱ʼnok Jesús oʼhuaduyate. ");
INSERT INTO amrNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Kente Jesús oʼpokapo onʼnopo̱e̱po dagte huakkaʼda kenomeyen yudtaj onʼbahueda̱ʼpo nogomeya̱ o̱hue̱y ʼopi baʼkutaj onʼbaktega̱ʼdepo dagte onʼbahueda̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Huakkurute hua̱e̱ʼeria kenpaʼti huataʼpoeria ayaʼada huaboaʼda ʼuttaʼda onʼdaʼpo: —‍ʼUrunanada Jesús, Diosen huamanopoʼyareaʼeri, monʼdurugpak, huakkaʼ monʼdurugpak. Kentaj Apag Diosa moʼnigtaʼmonaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Oroʼen adhueaʼpaneʼ David huairionig hueretda huakhuairi oʼtiakde, Jesús Huairi oʼtiakde. Dakiti Dios, monʼdurugpak, huakkaʼ monʼdurugpak. —‍Aratbuta ʼuttaʼnanada oʼnokoyʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ken konig Jerusalényo̱ Jesús oʼkudpo kenpaʼti Diosen jakyo oʼkudpo, ayaʼtada dakaʼ oʼtiahuaypo osikdenok Betaniayo doce huamataʼmoneriere oʼhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Emeʼte Betaniayaʼ oʼnoro̱kdepo Jesús aypotaʼ o̱ʼe̱po ");
INSERT INTO amrNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","adteda hue̱ymey higuerataj oʼtiahuaynigʼa huada oʼpakpo oʼhuahuaʼnigʼa huakutayoʼda o̱ʼu̱yate. Huadajok ehued o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Konige̱po higuerataj onaʼpo: —‍Onteʼti dapakhueʼdikda i̱ʼe̱a̱pet. Bepiʼ o̱ʼnenda bapehueʼ ya̱ʼneapet. —‍Jesúsa onaʼuyate. Kenda huanigpe̱i̱kaʼeria onʼpe̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Onteʼti Jerusalényo̱ onʼtiakdepo Jesús Diosen jakyo oʼkuddepo huaboaʼda ʼuhua huabahuayaʼeritaj huabakbaeʼerieretaj oʼmaoro̱kaʼpo huakupe huakabiaʼerien kutopa oʼmakmaenaʼpo tukkuʼ ʼuhua huabahuayaʼerien huahuadtaj oʼmakmaenaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","“Konig dag ekapaʼ Diosen jakyo katepiʼ topokhueʼdik moʼe̱ne.” Jesúsa i̱ghuaʼda oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Oʼmanmadikaʼpo: —‍Doʼhued jak ayaʼ huadarieri aratbuten huationaʼpak jak onʼta̱e̱. Apagbaʼ eʼmanaʼtada konig huabereerien jakonig opudomeya̱ moʼto̱e̱ne. —‍Jesúsa huabahuayaʼeritaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Kenda sacerdote huairi Moisésenbaʼ huamanmadikaʼeriere onʼpe̱e̱po Jesústaj onʼmeʼpukuyate. Jesúsa eʼmanmadikaʼte huakkaʼnanada aratbut onʼpe̱e̱po ʼurunanada o̱ʼe̱ onʼmepukeʼnok huairia Jesústaj onʼmeʼpukpo huaboaʼda eʼaraktaʼ onʼpakpo monig eʼaraktaʼ oʼduknigʼa. ");
INSERT INTO amrNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Esikdeʼte Jesúsa huakkaʼ jakyaʼ o̱ʼo̱ro̱kuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Emeʼte sikyoedda onteʼti onʼhuaʼdepo higuera huaʼihuityaʼ ayaʼda eʼaydeʼ onʼtiahuayʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pedro onteʼti okkahuehueʼ o̱ʼe̱po, —‍Ken higuerataj “onteʼti dapakhueʼdikda” inameʼnig oʼayde, yatiahuayʼ, huamanmadikaʼeri. —‍Onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","—‍Diostaj dakaʼ yanoknopo̱e̱ʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","“In oteʼ yatohuaʼ, Dios. E̱ʼpo̱gyo̱ yaen.” Beʼapiʼ enaʼnayo Diosa yakaʼapet dakaʼ eknopo̱e̱ʼnayo oʼkaʼapo. Konig onaʼnig o̱ʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Eknopo̱e̱ʼnayo ayaʼtada katepiʼ boʼpakpo boʼtionaʼpaknok Diosa boʼyokapone. ");
INSERT INTO amrNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Apag Diostaj yanʼtionaʼpakpo beʼapiʼ ontaj dakhueaʼ e̱gkameʼnayo yakkahueaʼ. O̱ʼnen Apag Dios kurudyo̱ o̱ʼi̱kaʼpo keʼna opudtaj dakhueaʼ eʼkaʼ bokkahueapone kenpaʼti. ");
INSERT INTO amrNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nogtaj okkahueahueʼ e̱e̱ʼnayo o̱ʼnen Apag Diosakon opudtaj okkahueahueʼ moʼe̱a̱pone. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Onteʼti Jerusalényo̱ onʼtiakdepo Jesúsa Diosen jakyo eʼhuaeʼte sacerdote huairi Moisésenbaʼ huamanmadikaʼeri judío huairitoneʼere onʼhuahuaʼdepo, ");
INSERT INTO amrNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","—‍¿Yabayareadhuatiʼ. Beʼa menaʼuy? —‍Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","—‍Huakkuru doʼtaj meʼnakonen. Opud enaʼnayo keʼna “yabayareaʼ,” menaʼuyne do kenpaʼti oʼnonaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","“Bautiza yamagkadhuatiʼ.” ¿Beʼa Juantaj yanaʼuyate, Diosa huabokerekapiʼ? Menaʼtok. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Menpaʼ oʼapo huairia huayahuaya onʼbatiaʼpakpo: —‍“Diosa Juantaj oʼtaʼmonaʼuyate.” Oroʼa enaʼnayo “¿kenda Juana doʼtaj beʼtiaʼpakikuynig menaʼpo oknopo̱e̱hueʼ moʼu̱y?” oroʼtaj monaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","“Huabokereka Juantaj onʼtaʼmonaʼuyate.” Oroʼa enaʼnayo aratbuta oroʼtaj dakhueʼda mogkaʼapet konige̱po Diosen huamanbatiaʼpakeri Juan o̱ʼe̱ʼuy aratbut oʼnoknopo̱e̱nok. —‍Judío huairia huayahuaya onʼbatiaʼpakpo, ");
INSERT INTO amrNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","—‍Beʼa Juantaj yanuyet oroʼ nopo̱e̱hueʼ o̱ʼe̱y. —‍Huairia Jesústaj oʼnonaʼuyate. —‍“Yabayareaʼ.” Keʼna menaʼuyne do kenpaʼti onahueʼ o̱ʼneapone. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesúsa konig o̱ʼe̱ oʼmanbatiaʼpakpo oʼmanmadikaʼpo: —‍Huairien taʼbayo uva huakpi onʼbatukeʼuy. Uva setda huada huakpi onʼbatukeʼuy. Onʼtiokpakaʼuy. Uva huada huasapaʼaʼ sipanaʼ ʼuruda oʼkogkaʼuy. Huaʼia asapaiyaʼpo oʼkogkaʼuy. Taʼba huatiokaʼ kutayoda kutopa oʼkaʼuy. Uva taʼba hua̱ta̱to̱e̱ʼeritaj taʼba oʼbaktoyokdepo bidteda nogbayo huairi oʼbakhuaʼuyate. Nogbayo ijhueʼda o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kenokaʼ uva huada oʼboyogdenok taʼbayo keʼnen huanabaʼ oʼtaʼmonaʼuyate. Sueʼda huada kaʼtotiakeʼpo oʼtaʼmonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Eʼtiakdeʼte taʼba hua̱ta̱to̱e̱ʼeria huairien huanabaʼtaj onʼto̱e̱po onʼbitbitpo uvabayoʼ onʼtaʼmonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Onteʼti huairia nog huanabaʼtaj oʼtaʼmonaʼuyate. Taʼbayo eʼtiakdeʼte onʼpaʼeaʼpo huakutaj onʼbitbitpo onʼtidikeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Huairia nogtakon oʼtaʼmonaʼuyate. Kentaj oʼdarakuyate. Nogok nogomey huakkaʼmontaj oʼmataʼmonaʼuyate. Nogtaj onʼmabitbitpo konogtada onʼbatiarakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Huairien huasiʼpoyoʼda o̱ʼta̱e̱po kentaj diʼnanada o̱ʼi̱kaʼuyate. Taʼpoteda huasiʼpo oʼtaʼmonaʼuyate. Kentanayo ʼuruaʼda yanʼdeapet oʼnopo̱e̱po. ");
INSERT INTO amrNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Taʼba hua̱ta̱to̱e̱ʼerinayo dakhueaʼda onʼnopo̱e̱po, “Huairi eʼbueydeʼte huasiʼpoa ayaʼ huaoen oʼbaeapo. Onʼnopo̱e̱po huairien taʼba oroʼen kenpaʼda moʼta̱e̱ʼpo huasiʼpotaj monʼarak.” Onpayoʼ onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ken huasiʼpotaj onʼto̱e̱po oʼdarakpo taʼbayaʼ hua̱so̱ʼ o̱ʼnenʼuyate. —‍Ken konig Jesúsa oʼmanbatiaʼpakpo oʼmanmadikaʼpo, ");
INSERT INTO amrNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","—‍Huairi oʼtiakdepo hua̱ta̱to̱e̱ʼeritaj menpaʼ yaʼmagkaʼapet moʼnopo̱e̱. Hua̱ta̱to̱e̱ʼeritaj oʼbarakpo taʼba nogomeytaj oʼbayokapo. ");
INSERT INTO amrNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Apagbaʼkon tiahuayhueʼ moʼi̱kaʼ. Huid jak o̱gkaʼpo jak huakaʼeria Diosen ʼuru huidda e̱ʼhua̱e̱ʼtaj pakhueʼ o̱ʼnepo oʼnenʼuy. Ken huidtaʼ Diosnayo oʼpak ken huidte huaboroʼ jakda oʼkaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Kenda Dios Huairia oʼkaʼapo ʼurudapitaʼ oʼkaʼ, oʼnopo̱e̱ne. Apagbaʼte kenda oaʼ. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Judío sacerdote huairi nog judío huairiere Jesústaj onʼpe̱e̱depo oroʼomeytaj boʼtiaʼpakne. Oroʼ konig huairien taʼba hua̱ta̱to̱e̱ʼeri o̱ʼneaʼ boʼtiaʼpakne onʼnokotdepo Jesústaj huabakuda̱ʼ jakyo eʼtohuaʼtaʼ onʼtipaknigʼa aratbuttaj onʼmakmeʼpukpo tohuahueʼ o̱ʼnuyate. Jesús Diosen huamanbatiaʼpakeri o̱ʼe̱. Aratbuta oʼnoknopo̱e̱nok onʼmakmeʼpukpo onʼbakhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Jesúsa namaʼda kaeʼpo dakhueʼda oaʼ aaʼyaʼpo judío huairia Jesúste fariseotaj kenpaʼti Herodesen huapakeritere onʼmataʼmonaʼuyatenok ");
INSERT INTO amrNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","onʼhuatiakpo, —‍Konig aratbuta yanʼpakapet mentiaʼpakapetpiʼ nopo̱e̱hueʼ i̱ʼe̱po buttida iʼmanaʼikaʼ, huamanmadikaʼeri. Ayaʼtada konigti iʼpakikaʼ. Huairi huanabaʼpiʼ konigti iʼpakikaʼ. Diosen eʼkikaʼnig buttida iʼmanmadikikaʼ. ¿Menpaʼ Romano gobierno huairitaj huakupe yokikaʼdik o̱ʼe̱? ¿Yokhueʼdikpiʼ o̱ʼe̱? —‍Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Namaʼda meʼnonaʼne Jesúsa oʼnopo̱e̱po, —‍¿Do dakhueaʼ kaeʼpo menaʼpo namaʼda oʼnonaʼ? Men huakupe, mentiahuayʼeaʼ. —‍Jesúsa oʼmanaʼuynok, ");
INSERT INTO amrNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ken denario huakupe eʼyokte oʼtiahuaypo, —‍¿Huakupete beʼed huakok ya̱ʼe̱? ¿Beʼed huadik eʼmandoyaʼ ya̱ʼe̱? —‍Jesúsa oʼmanaʼuyate. —‍Romano gobierno huairien huakok huadikere o̱ʼe̱. —‍Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","—‍Gobiernoen e̱ʼhua̱e̱ʼ yanʼyokikatiʼ. Kenpaʼti Diosen e̱ʼhua̱e̱ʼ ya̱gʼkikaʼpo yanʼyokikatiʼ. —‍Jesúsa oʼmanaʼuyate. Kenpaʼ onʼpe̱e̱depo, “kenpihuay,” ʼuruaʼda oaʼ onʼnopo̱e̱po. ");
INSERT INTO amrNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Saduceo huamanmadikaʼeri aratbut kubarakyaʼ onteʼti noyhuadhueʼ o̱ʼneapo onʼbatiaʼpakikaʼuy. Saduceomey Jesústaj onʼhuahuaʼpo oʼnonaʼpo: ");
INSERT INTO amrNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—‍“Huabokerek eʼto̱e̱pakada huasiʼpo to̱e̱hueda̱da eʼbueynayo keʼnen huamaʼbuy ayhuataj to̱e̱pakdik o̱ʼe̱po huamaʼbuykudakendik huasiʼpo dikto̱e̱dik o̱ʼe̱.” Moisésa oʼmanigmadoyaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Oroʼere siete huamaʼbuy o̱ʼnuy. Huakkurueria oʼto̱e̱pakdepo nogok sigpiʼ huasiʼpo to̱e̱hueʼada okbueyʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Nog huamaʼbuy ayhuataj oʼto̱e̱pakuy. Keʼnakon huasiʼpo to̱e̱hueʼada oʼbueyʼuy. Noga̱kon konigti oʼkaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ken konig ayaʼada siete huamaʼbuey kentaj onʼto̱e̱pakuy. Huasiʼpo to̱e̱hueʼada onʼtimabueyʼuy. Taʼpotaʼ ayhuakon oʼbueyʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","¿Nogok aratbut kubarakyaʼ onteʼti enʼnoyhuaddeʼte keʼna ayhua beʼed hua̱to̱e̱a̱ʼtaj ya̱ʼe̱a̱pet? Ayaʼada huamaʼbuya onʼto̱e̱ʼuy, huamanmadikaʼeri. —‍Saduceomeya̱ Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","—‍Namaʼda moʼnopo̱i̱kaʼne. Apagbaʼ nopo̱e̱hueʼ moʼe̱ne kenpaʼti Dios teyda o̱ʼe̱ nopo̱e̱hueʼ moʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Aratbutkudak kubarakyaʼ onʼnoyhuaddepo to̱e̱pakhueʼdik o̱ʼneapo kenpaʼti hua̱yo̱bu kato̱e̱pakeʼpo bayokhueʼdik o̱ʼneapo. Konig Diosen huataʼmoneri kurudyo̱ o̱ʼne konigti o̱ʼneapo. Diosen huataʼmoneri to̱e̱pakhueʼ o̱ʼnikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Aratbut eʼbuey onteʼti kubarakyaʼ noyhuadhueʼ ya̱ʼneapet opud namaʼda onʼbatiaʼpakikaʼnigʼa kubarakyaʼ onteʼti onʼnoyhuada̱po nopo̱e̱dik moʼe̱ne. Moisésenbaʼte boʼtiahuaypo kenpaʼ nopo̱e̱dik moʼe̱ne. Kente Moisésenbaʼte hue̱ymey eʼbakpakte Moisésa Diostaj oʼtiahuayʼuy oʼtimadoyaʼuyate. “Abrahamen Dios i̱jje̱y. Isaacen Dios i̱jje̱y. Jacoben Dios i̱jje̱y.” Diosa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Eʼbueyen Dios ehueʼ e̱e̱ʼtada huanoeʼerien Dios o̱ʼi̱kaʼ. Aratbut noyhuadhueʼ o̱ʼneapo opud namaʼda moʼnopo̱i̱kaʼne. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jesús saduceo huairiere enʼbatiaʼpakte Moisésenbaʼ huamanmadikaʼeri oʼbahuatiakpo oʼmape̱e̱po Jesúsa ʼuruda oʼmanaʼ oʼnopo̱e̱depo, —‍Diosen eʼmanaʼ menata hueretda inigpe̱e̱po kikaʼdik ya̱ʼe̱. —‍Jesústaj Moisésenbaʼ huamanmadikaʼeria onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","—‍Huairi oroʼen Dios kenyoʼnanada Dios o̱ʼe̱. Yanʼpe̱e̱ʼ, Israel aratbut. ");
INSERT INTO amrNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Dios Huairitaj diʼnanada yanikaʼ. Huanopoʼabetaʼ huakkaʼda yanʼpakpo Diostaj diʼ yanikaʼ. Hua̱so̱ʼa̱betaʼ huakkaʼda yanʼpakpo Diostaj diʼ yanikaʼ. Huanoki̱re̱ga̱betaʼ huakkaʼda yanʼpakpo Diostaj diʼ yanikaʼ. Eʼnopo̱i̱kaʼa yanʼeretpakpo Diostaj diʼ yanikaʼ. Kenda Diosen eʼmanaʼ menata hueretda inigpe̱e̱po kikaʼdik ya̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Diosen taʼpotaʼ eʼmanaʼ konigtimon o̱ʼe̱. “Konig huataʼ diʼda moʼi̱kaʼne konigti nog aratbuttaj diʼda yanʼmaikaʼ.” Kenda eʼmanaʼ Diosa huakkaʼnanada oʼpakikaʼ nogda sueʼda oʼpakikaʼ. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","—‍ʼUrunanada onaʼne, huamanmadikaʼeri. Buttida onaʼne. Nogtiyoʼda Dios o̱ʼe̱. Nogda ehueʼ o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Dios Huairitaj diʼnanada yanikaʼ. Huanopoʼabetaʼ huakkaʼda yanʼpakpo Diostaj diʼ yanikaʼ. Eʼnopo̱i̱kaʼa yanʼeretpakpo Diostaj diʼ yanikaʼ. Hua̱so̱ʼa̱betaʼ huakkaʼda yanʼpakpo Diostaj diʼ yanikaʼ. Huanoki̱re̱ga̱betaʼ huakkaʼda yanʼpakpo Diostaj diʼ yanikaʼ. Kenpaʼti konig huataʼ diʼda moʼi̱kaʼne konigti nog aratbuttaj diʼda yanʼmaikaʼ. Kenda Diosa huakkaʼnanada oʼpakikaʼ. ʼUhua Diostaj onʼyokikaʼpo Diostaj kutopate onʼmahui̱gikaʼ Diosa sueʼda oʼpak. —‍Moisésenbaʼ huamanmadikaʼeria onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Moisésenbaʼ huamanmadikaʼeria dakaʼ oaʼnig Jesúsa oʼpe̱e̱po, —‍Dios Huairitaj oknopo̱e̱ʼdik i̱ʼe̱ne. Diosensiʼpo e̱ʼdik i̱ʼe̱ne. —‍Jesúsa onaʼuyate. Kenda enadeʼte onteʼti Jesústaj onahueʼ o̱ʼnuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Diosen jakyo Jesúsa oʼmanmadikaʼpo: —‍Cristo Daviden adhueaʼ huayayo o̱ʼe̱. Menaʼpo Moisésenbaʼ huamanmadikaʼeria yadaʼikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Doere teyda yamanikaʼ. Ayaʼda o̱ʼnen takaʼ oknopo̱e̱hueʼ hua̱e̱ʼerikon nogokda huaboaʼda ontaj nigpe̱i̱kaʼdik o̱ʼneapo. Doʼhued huairi Cristotaj Dios Huairia onaʼuy. Aʼnennada Davida Diosen Noki̱re̱g oʼnopoʼto̱e̱po oaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“¿Doʼhued Huairi Cristo o̱ʼe̱,” David eaʼnayo Cristo Daviden adhueaʼ huayayo menpaʼ e̱ʼdik ya̱ʼe̱? —‍Jesúsa oʼmanaʼuyate. Ken huakkaʼada aratbut o̱gkupopakpo durugnanada onʼpe̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesúsa nogi̱ti oʼmanmadikaʼpo: —‍Moisésenbaʼ huamanmadikaʼeritaj keyoj ijjay. Huataʼda onʼeretpakpo namaʼda o̱gkikaʼ dakaʼ yanʼnopo̱i̱kaʼ. Konig huairi kiriga̱yo̱ʼ huabidokda eʼottaʼ onʼpakikaʼpo kenpaʼti huakkaʼ jak eretnopoyo eʼhuaeʼte “Iʼtiak, huairi,” enaʼte eʼpe̱e̱taʼ onʼpakikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Kenpaʼti judíoen hua̱i̱takeʼ jakyo huairied huahuadte eʼhuadtaʼ onʼeretpakikaʼ. Kenpaʼti fiestate konig huairied huahuadte eʼhuadtaʼ onʼeretpakikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Kenpaʼti ayhuaen huakupe jakpiʼ katepiʼ enʼta̱e̱ʼte konig engaña o̱gkaʼpo onʼbakkayikaʼ. Kenda o̱gkikaʼpo onokteteyoʼ Diostaj ijhueʼda onʼtionaʼpakonhuahuikaʼ. Aratbuta menʼtiahuayeʼpo huadakda o̱ʼne menʼtinopo̱e̱ʼpo kiriga̱yo̱ʼ onʼtionaʼpakonhuahuikaʼ. Kenda o̱gkikaʼnok Diosa dakaʼ oʼnopo̱e̱po huakkaʼ castiga oʼmagkaʼapo. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Diosen jakyo huakupe huabaeʼ cajate meyo̱hueʼda Jesúsa oʼhuadpo huakkaʼ aratbut huakupe enʼkuda̱ʼte oʼbatiahuayʼuyate. Huairia huakkaʼda onʼkuda̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Paiʼda ayhua oʼtiakdepo bottaʼ sigkupe oʼbakuda̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","44","Huanigpe̱i̱kaʼeritaj “yanʼtiak” oʼmanaʼpo, —‍In ayhua suhuigda eʼto̱e̱a̱da konig huakkaʼda oʼkuda̱ʼ. Judío huairinayo huakkaʼda eʼtamaetada suigda onʼkuda̱ʼ. Konige̱po ayhua ayaʼda Diostaj oʼyok. Buttida ijjay. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Diosen jakyaʼ Jesúsa eʼo̱ro̱kdeʼte, —‍Diosen jak yatiahuayʼ, huamanmadikaʼeri, ʼurunanada huid, ʼurunanada jak. —‍Nogtida huanigpe̱i̱kaʼeria Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","—‍In Diosen huid jak boʼtiahuaynig nogok ayaʼda huid onʼsakapo. Huabada sorokte nog aratbuta onʼsakaʼapo. Huid kupahuihuihueʼ o̱ʼe̱a̱po. Diosen jak ehueʼda o̱ʼe̱a̱po. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ken Olivos oteʼyo Diosen jakyaʼ butukada onʼhuaʼuyate. Jesús eʼhuadte Pedro Jacobo Juanereyoʼda onʼhuahuaʼpo, ");
INSERT INTO amrNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—‍¿Menokaʼ Diosen huid jak yanʼsakapet? ¿On onteʼti eʼtiak kenpaʼti keneʼhua̱ya̱ʼ huameʼnoe menokaʼ ya̱ʼe̱a̱pet? ¿Oroʼomey aʼnopo̱e̱yaʼpo kate huakkuru oʼtiahuayapet? —‍Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","—‍Keyoj huakkaʼada opudtaj namaʼda enaʼte pe̱e̱hueʼ yanikatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Huakkaʼada opudtaj boʼhuatiakapone. “Cristo i̱jje̱y.” Doʼhued huadik namaʼda monaʼapet. Kenomeytaj huakkaʼada namaʼda onʼmanigpe̱e̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nogbayo nogbayo gobierno sorotataj nog gobierno sorotataj onʼbarakonhuaʼ yanʼbatiaʼpakapet. Opudnayo meʼpukhueʼ yaneʼ. Keneʼhua̱ya̱ʼ huameʼnoe tiakhued e̱e̱ʼted. ");
INSERT INTO amrNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nogbayaʼ nogbayaʼ gobierno sorotataj yanʼbarakonhuahuaʼapet. Diga̱ʼda yanʼbarakonhuahuaʼapet. Nogbayaʼ nogbayaʼ huadari ya̱ʼi̱ye̱gapet. Nogya̱ʼ nogya̱ʼ aratbut aypobayoʼ o̱ʼnepo yanʼmabueyonhuaʼapet. Kenpaʼ huaboaʼda dakhueaʼda o̱ʼe̱depo paiʼnanada yanʼnopoʼe̱a̱pet. ");
INSERT INTO amrNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Huataʼda dakaʼ yanʼnopo̱e̱po doʼtaj batikhueʼda yanoknopo̱i̱kaʼ. Judío huairi e̱gkupopakyo moʼbatohuaʼapone. Judíoen hua̱i̱takeʼ jakyo moʼbitbitapone. Doʼtaj moknopo̱e̱nok doʼhued gobierno huairitaj manbatiaʼpakdik moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Keneʼhua̱ya̱ʼ huameʼnoe ehued e̱e̱ʼted ayaʼda huadaribayo hua̱e̱ʼeritaj eʼnoeanhuahuikaʼ huaʼa huadak huaʼa manbatiaʼpakdik ya̱ʼneapet. ");
INSERT INTO amrNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Gobierno huairitaj eʼyokdeʼte “katiaʼpiʼ huairitaj yanʼbatiaʼpakapo,” meʼpukhueʼ yaneʼ. Kenokaʼ Diosen Noki̱re̱ga̱ moʼnopo̱e̱a̱ʼaponok kenda huairitaj moʼmanaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Nogok oknopo̱e̱hueʼ hua̱e̱ʼeria huaknopo̱e̱ʼeri huamaʼbuytaj kanʼbatiarakeʼpo gobierno huairitaj onʼbayokapo. Kenpaʼti huaoa huasiʼpotaj kanʼbatiarakeʼpo gobierno huairitaj onʼbayokapo. Kenpaʼti huasiʼpoa keʼnen huaoj huaknopo̱e̱ʼeritaj kanʼbatiarakeʼpo gobierno huairitaj onʼbayokapo. ");
INSERT INTO amrNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Doʼtaj moknopo̱i̱kaʼnok nogba nogbayaʼ huabada opudtaj boʼhuadiayikaʼapet. Kenomey batikhueʼada Diostaj dakaʼ onʼnigpe̱i̱kaʼpo Diosere onʼnoeonhuahuikaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Ken dakhueʼda Diostaj konig Diosen jakyo yaʼkudapet. Daniela aʼnenannda oʼmadoyaʼuyatenig Diosen jakyo e̱ʼe̱deʼte boʼtiahuaydepo ayaʼ Judea huadaribayo hua̱e̱ʼeria huakupayo yanʼmamontiʼ. Berobaʼ yanʼbonaʼpakpo yanʼnopoenkatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Huabarakeri i̱dada onʼbatiaknok jak kurute e̱e̱ʼnayo jakyo katepiʼ moʼtamae aʼudyaʼpo kudhueʼ yanetiʼ. I̱dada yanʼmamontiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Taʼbayo e̱ʼneʼnayo yudtaj aʼudyaʼpo jakyo huahueʼ yanetiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Ettoneʼ bogdakhueʼ kenpaʼti ettoneʼ yo̱bed onʼto̱e̱po i̱dada monhueʼdik o̱ʼnepo paiʼda yanʼnopoʼe̱a̱pet. ");
INSERT INTO amrNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Uuʼok e̱e̱ʼte monhueʼdik o̱ʼe̱y Diostaj yanʼtionaʼpakikatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Huakkaʼnanada paiʼnanada yanʼnopoʼeonhuahuaʼapet. Keʼponanada ya̱ʼneonhuahuaʼapet. Huakkuruda Diosa huadari eʼkaʼdeyaʼ sueʼda paiʼdamon onʼnopoʼe̱ʼuyate. Kenpaʼ ehueʼ ya̱ʼneapet. ");
INSERT INTO amrNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ayaʼda mabueyhueʼdik kaʼneʼpo, kenpaʼti Diostaj huaknopo̱e̱ʼeri Diosen huabaktieʼeaʼeritaj oʼmatinepahuiʼpo “sueʼda huameʼnoe aratbut paiʼnananada kanʼnopoʼunhuahuikeʼ.” Diosa yaʼaapet. ");
INSERT INTO amrNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Kenokaʼ “yanʼtiahuayʼ, in Cristo o̱ʼe̱,” “yanʼtiahuayʼ, a̱yo̱ Cristo o̱ʼe̱.” Beʼapiʼ enaʼnayo pe̱e̱hueʼ yanetiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Kenpaʼti “Cristo i̱jje̱y,” huabokerekpiʼ namaʼda yanʼmanaʼapet. “Diosen huamanbatiaʼpakeri i̱jje̱y,” nogok nogok namaʼda yanʼmanaʼapet. Kenpaʼti ʼuruaʼda konig Diosayoʼda kaʼdik o̱ʼe̱nig ya̱gkaʼapet. Kenpaʼti yanʼbayareaʼapet. Diosen huabaktieʼeaʼeri namaʼda ka̱gkeʼpo yanʼeretpakpo namaʼda yanʼmanaʼapet. ");
INSERT INTO amrNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Namaʼda huaaʼeritaj keyoj ijjay. Engaña huaaʼeri tiakhued eneʼted dakaʼ onʼnopo̱e̱a̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Kenpaʼti nogok paiʼda enʼnopoʼe̱batikdeʼte niokpoakon sigpiʼ taʼtehueʼdikda ya̱ʼe̱a̱pet konigti puugkon jeyhueʼda ya̱ʼe̱a̱pet. ");
INSERT INTO amrNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Kurudya̱ʼ siokpo yaʼkahuapet. Kurudyo̱ hua̱e̱ʼeri huairinig yanʼirigaʼapet. ");
INSERT INTO amrNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Do eʼtiakte menʼtiahuayapet. Kurudya̱ʼ e̱ʼsi̱hui̱ya̱ʼ teynanada i̱jje̱po ʼuruaʼnanada i̱jje̱po ijhuarakapoy. ");
INSERT INTO amrNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Doʼhued ángeltaj ijmataʼmonaʼapoy. Nogyon nogyon doʼhued huabaktieʼeaʼeritaj onʼbakupopakaʼapo. Ayaʼbayaʼda ayaʼ kurudbayaʼda onʼbakupopakaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Higuera hue̱ymeytaj ijmanbatiaʼpakapoy. Kenda dakaʼ yanʼnopo̱e̱ʼ. Huaʼopi oʼkutaʼsonpakde oʼbakutapakde huabayok oʼtiakde moʼnopo̱i̱kaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kenda kenpaʼ huaboaʼda ijjaʼnig e̱ʼe̱deʼte boʼtiahuaydepo do Diosen Huairi kurudya̱ʼ oʼtiakdeapo nopo̱e̱ʼdik moʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Opud aratbut ayaʼ bueyhued opuden huakkaʼ jaktaj takaʼ sorotataa keʼpoda mogkaʼapet. ");
INSERT INTO amrNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Doʼhued huaʼa doʼhued eʼmanmadikaʼnayo kenpaʼda o̱ʼunhuahuikaʼapo. Batikhueʼdik o̱ʼe̱a̱po. Huadarinayo batikdik kurudkon batikdik doʼhued eʼmanaʼnayo batikhueʼdikda o̱ʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ken huameʼnoe oʼtiakapo, kente niokpo eʼhuadte oʼtiakapo ayaʼada beʼapiʼ nopo̱e̱hueʼda o̱ʼne. Diosen huataʼmoneripiʼ kurudya̱ʼ nopo̱e̱hueʼ o̱ʼne. Do Diosen huasiʼpo itipiʼ nopo̱e̱hueʼ i̱jje̱y. Apag Diosayoʼda oʼnopo̱e̱. ");
INSERT INTO amrNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Keyoj Diosen dakaʼ ya̱gʼkikatiʼ. Kenokaʼ oʼtiakapo nopo̱e̱hueʼ moʼe̱nok batikhueʼda do eʼtiakapote e̱kpo̱e̱ʼ yanikatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Konig huairi nogbayo aʼti oʼhuaʼdeapopo keʼnenda huanabaʼtaj dakaʼ oʼmanaʼpo, “jak dakaʼ menta̱to̱i̱kaʼ, dakaʼda ya̱gʼkikatiʼ, akbogpe huato̱e̱ʼeri dakaʼ e̱kpo̱e̱ʼ yanikatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Kenokaʼ jak huairi oʼtiakapo nopo̱e̱hueʼ moʼe̱po baysik nopote sikyo meahued sikyoeddapiʼ yatiakapetpiʼ yanʼnopo̱e̱po dakaʼ e̱kpo̱e̱ʼ yanikatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Eʼtaydeʼtepiʼ yatiakapet yanʼnopo̱e̱po dakaʼ e̱kpo̱e̱ʼ yanikatiʼ.” Huairia huanabaʼtaj oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Opudomeytaj ken konigti ayaʼtada ijmanay. Dakaʼ e̱kpo̱e̱ʼ yanikatiʼ ijmanay. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Emeʼtekentaʼ biahueʼ pan huapeʼ fiesta o̱ʼe̱a̱po. Jesústaj monig i̱re̱gi̱re̱g aʼarakyaʼpo huatotiak onʼukpo, ");
INSERT INTO amrNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","—‍Fiesta e̱e̱ʼte arakhueʼdik o̱ʼe̱ne. Kenokaʼ eʼaraknayo aratbut moʼhuadiaypo ʼuttaʼda boyʼdik moʼe̱a̱pone. —‍Huairia onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Eʼsiʼdakset Simóntaj onʼdikkaʼuyate. Oʼsidakyareʼuyate. Betania huakkaʼ jakyo Simónen jakyo Jesús mesate eʼhuadte ettoneʼ oʼkudonpo huid yerepuʼte ʼuruʼhui̱e̱da huasihuaʼa huakkaʼteda e̱e̱ʼtada oʼtotiakpo Jesústaj oʼkutioyʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Sueʼada onʼtiahuaydepo onʼhuadiayonpo, —‍Menaʼpo huakkaʼteda e̱e̱ʼtada namaʼda injoy. ");
INSERT INTO amrNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Paiʼda aratbuttaj kabayokeʼpo onjoyhued e̱e̱ʼted huakkaʼteda bahuayaʼdik o̱ʼe̱a̱yʼnigʼa. —‍Huayahuaya onʼbatiaʼpakpo. —‍Namaʼda iʼkaʼ. —‍Ettoneʼtaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","—‍In ettoneʼtaj namaʼda iʼkaʼne onahueʼ yaneʼ. ʼUruaʼda megkaʼne. ");
INSERT INTO amrNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Opudere paiʼda aratbut o̱ʼnikaʼapo. Menokapiʼ huadakaʼda kikaʼdik moʼe̱a̱pone. Batihuapokikaʼdik moʼi̱kaʼapone. Bayokikaʼdik moʼi̱kaʼapone. Donayo opudere ehueʼ i̱ji̱kaʼapoy. ");
INSERT INTO amrNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","In ettoneʼa̱ ʼuruʼhui̱e̱da huasihuaj eʼto̱e̱a̱da beʼkutioyne. Doʼtaj hua̱so̱ʼ eʼkubarakkaʼ ikkenda beʼsihuakaʼne. ");
INSERT INTO amrNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Doʼhua aratbuttaj aʼmanopoʼkoreayaʼpo moʼnigbueyʼuy. Meya̱piʼ ayaʼda huadaribayaʼ kenpaʼ onʼmanbatiaʼpakikaʼapo kenda in ettoneʼ megkaʼnigkon onʼmanbatiaʼpakikaʼapo. Ken ettoneʼtaj okkahuehueʼ o̱ʼnikaʼapo, buttida ijjay. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Doce Jesúsen huamataʼmoneri o̱ʼnepo nogtiada Judas Iscariotea oʼbakhuaʼuyate. Huakupete Jesústaj huatitotiak judío huairitaj aʼbatiaʼpakyaʼpo oʼbahuahuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Judas Iscariote huakupete Jesústaj eʼhuatitotiaktaʼ oʼpaknok judío huairia kenda onʼnopondepo onʼdurugpakpo, “huakupe boʼyokapone,” oʼnonaʼuyate. Judas kenda oʼpe̱e̱depo huaboaʼda sacerdote huairitaj monig ijbayokapet oʼnopo̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Pan biahueʼ fiesta huakkuru huameʼnoe e̱e̱ʼte kenmeʼnoe oveja ʼuhua Diostaj onʼnigbatiarakikaʼuyate. —‍¿Fiesta aypo aʼbapeyaʼpo meya̱ʼ fiesta aypo manhuada̱ʼdik o̱ʼe̱a̱po? —‍Jesúsen huanigpe̱i̱kaʼeria oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Bottaʼ huanigpe̱i̱kaʼeritaj oʼmanaʼpo: —‍Jerusalényo̱ yanʼhuaʼ. Huabokereka hue̱ʼe̱y kosote eʼtohuaʼte boʼhuahuayapet. Yanʼtahuatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ke̱yo̱da eʼkudte jak hua̱ta̱e̱ʼeritaj “Meya̱ʼ adkorepen pan biahueʼ fiesta aypo doere doʼhued huanigpe̱i̱kaʼeri oʼbapeapoy. Huamanmadikaʼeria oaʼ.” ");
INSERT INTO amrNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ken jak hua̱ta̱e̱ʼeri oʼpe̱e̱depo jak kutayo huaboroʼ ki̱re̱gyo̱ boʼtohuaʼapone. Kutopa huabidda huahuadere boʼhuahuayapone. Ke̱ya̱ʼ fiesta aypo yanʼmanhuada̱ʼ. —‍Jesúsa oʼmanaʼuyatenok. ");
INSERT INTO amrNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Bottaʼa oʼnokhuaʼpo Jerusalényo̱ onʼhuaʼpo kenda Jesúsa oʼmanaʼnig onʼhuahuayʼuyate. Ken jakyo o̱ʼnehuaʼpo fiesta aypo onʼmanhuada̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Eʼsikdeʼte Jesús doce huanigpe̱i̱kaʼeriere ken jakyo oʼnokye̱po ");
INSERT INTO amrNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","kutopate o̱ʼnepo onʼbapepo, —‍Judío huairia doʼtaj kadarakeʼpo opud nogtiada doʼtaj moʼbayokapone. Keʼna oroʼere oʼbapenigʼa. Buttida ijjay. —‍Jesúsa oʼmanaʼnok ");
INSERT INTO amrNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","suhueʼnada o̱ʼnunpo huaboaʼda Jesústaj: —‍Doapiʼ ijbayokapetpiʼ. —‍Noga̱ noga̱ oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","—‍Doceyaʼ nogtiada doere pan oʼoyeʼepo konigti platoʼ oʼoyeʼe. Keʼna meʼbahuayaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Konig Apagbaʼte menʼtimadoyaʼuyatenig doʼtaj mogkaʼapone. Keʼnanayo doʼtaj huairitaj oʼbayokapo kentataj keʼponada o̱ʼe̱a̱po. Paiʼnanada oʼnopoʼunhuahuikaʼapo. Keʼna aʼnen siʼpoe̱hueʼ e̱ʼu̱ynayo huadakda o̱ʼe̱a̱ynigʼa. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ken onʼbapeʼpo Jesúsa pan oʼbapadpo, “dakiti Dios” onaʼdepo oʼposakeaʼpo oʼbayokeʼpo, —‍Yanʼbapeʼ. In pan doʼhued hua̱so̱ʼ o̱ʼe̱. —‍Doce huanigpe̱i̱kaʼeritaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Aʼtimon vino huamaiʼpuʼ oʼto̱e̱po “dakiti Dios” onaʼdepo oʼbayokeʼnok ayaʼada onʼmayʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","—‍In doʼhued mimi o̱ʼe̱. Aratbuten dakhueaʼ eʼkaʼ ijbakkahueaʼapoy, huaboaʼda ijjay. Opudtaj aʼmanopo̱e̱a̱yaʼpo ijbueydepo doʼhued mimi oʼhuaʼapo. Aratbuten dakhueaʼ eʼkaʼ akkahueayaʼpo doʼhued mimi oʼmanighuaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Onaʼti vino mayhueʼ i̱ji̱kaʼapoy. Nogok keneʼhua̱ya̱ʼ doʼhued Apag Dios Huairitaj ayaʼda huaknopo̱e̱ʼeri huaboaʼda Diosyo enʼbahuadeʼte onteʼti vino ijmayapoy. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Diostaj eʼbataʼdikeaʼdeʼ Jerusalénya̱ʼ oʼnoro̱kdepo Olivos oteʼyokon sikyo onʼhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","—‍In sikyo opud ayaʼda doʼtaj oʼnokmabirada̱pone. Doʼtaj oʼnokmamonapone. Apagbaʼte kenpaʼ oaʼnig konig: “Oveja huamato̱e̱ʼeritaj ekarakte oveja oʼnokmamonapo.” ");
INSERT INTO amrNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Nogok huakudakaʼda e̱ʼe̱a̱da ijnoyhuaddepo opudte Galileayo huakkuruda ijhuaʼapoy. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","—‍Nogomeya̱ bokbiradpo ekmamonpiʼ donayo okbiradhueʼ o̱ʼe̱a̱pone. —‍Pedroa Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","—‍Oyda in sikyo huatahuaj bottaʼaʼ sipoghued “Jesústaj jo̱ki̱a̱hueʼya i̱jje̱y.” Bapaʼaʼ iaʼapone. Buttida ijjay. —‍Jesúsa Pedrotaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","—‍Ehueʼ onere bueydik e̱e̱ʼpiʼ “Jesústaj jo̱ki̱a̱hueʼya i̱jje̱y,” ahueʼ i̱jje̱a̱poy. —‍Pedroa i̱ghuaʼ onaʼuyate. Ayaʼada huanigpe̱i̱kaʼeria konigti oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ken sikyoda Getsemaní taʼbayo Jesús huanigpe̱i̱kaʼeriere oʼnokye̱ʼuyate. —‍Inteda yanʼbahuadtiʼ. A̱yo̱ aʼtionaʼpakyaʼpo ijhuaʼapoy. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pedrotaj Jacobotaj Juantere oʼbatohuaʼpo huaboaʼda suhueʼnanada o̱ʼe̱po kenpaʼti paiʼnanada oʼnopoʼe̱po, ");
INSERT INTO amrNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","—‍Konig ijbueyapopo paiʼnanada ijnopoʼe̱y. I̱yo̱da menʼnige̱ʼ, doere yanokpoehueʼ. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nogiti adyonda oʼhuaʼdepo okkubukaʼ oʼhuedpo oʼtionaʼpakpo: ");
INSERT INTO amrNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","—‍Do paiʼda nopoʼe̱hueʼ ka̱e̱ʼpo tihuapokdik e̱e̱ʼnayo konig do ijpaknig kahueʼ ya̱e̱ʼ. Konig kenda on iʼpak megkaʼ, doʼhued pag. —‍Jesúsa oʼtionaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Huanigpe̱i̱kaʼeritaj oʼbahuahuapo enʼbatayte oʼbahuahuayʼuyate. —‍Menpaʼ iʼtay, Simón. Nogoratipiʼ menaʼpo doere okpoehuehueʼdik moʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Dakhueaʼ kahueʼ a̱ʼe̱ya̱ʼpo yanokpoehueʼ yanʼtionaʼpak. Huadak eʼkikaʼtaʼ boʼeretpaknigʼa kahueʼdik moʼe̱ne. —‍Pedrotaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Onteʼti Jesús oʼhuaʼpo konigti huadik Diostaj oʼtionaʼpakpo ");
INSERT INTO amrNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","aʼtimon onteʼti once huanigpe̱i̱kaʼeritaj oʼbahuatiakʼuyate. Enʼtaytetion oʼbahuahuayatoʼuyate. Taytayaʼ huakkaʼ oʼdapo kate aʼtokhueʼdik o̱ʼnuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Onteʼti oʼbakhuaʼpo oʼtionaʼpakdepo bapaʼaʼ oʼbahuatiakdepo, —‍Oyiti̱e̱yo̱ yanʼhuedtiʼ yanʼtaytiʼ. Kenpaʼda yanʼtaydeʼ oyda dakhueaʼ huakaʼeritaj doʼtaj meʼbahuayaʼne. ");
INSERT INTO amrNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Yanʼmaboʼ, monʼhuaʼ. Keʼna meʼbahuayaʼdene oʼtiakde. —‍Jesúsa once huanigpe̱i̱kaʼeritaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","I̱da Jesúsa kenpaʼ eʼmanaʼted Judas o̱kye̱ʼuyate. Jesúsen doce huanigpe̱i̱kaʼeri Judas nogtida o̱ʼu̱y. Judasere huakkaʼda onʼbatiakbedʼuyate. Sorotataʼen siro onʼtotiakpo noga̱ hue̱ypa onʼtotiakpo onʼbatiakbedʼuyate. Sacerdote huairi Moisésenbaʼ huamanmadikaʼeri judío huairitoneʼa onʼmataʼmonaʼnok onʼbatiakbedʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","—‍Kentaj boʼpaknigtaj ijbuyukapoy yanʼtohuatiʼ. —‍Kenpaʼ Judas huabahuayaʼeria tiakhued o̱ʼe̱po oʼmanaʼuyate. Jesústaj kaʼnoki̱e̱ʼpo kenpaʼ oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Judas oʼtiakdepo Jesústaj oʼhuahuatoʼpo, —‍Ijtiaki, Huamanmadikaʼeri. —‍Onaʼdepo oʼbuyukuyatenok ");
INSERT INTO amrNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Jesústaj ontaʼkoyatoʼpo onʼtohuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ken nogtiada huanigpe̱i̱kaʼeri siro oʼto̱e̱po sacerdote huairien huanabaʼtaj oʼpesodoktegʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","—‍Konig dakhueaʼ huabakbereeritaj aʼtohuayaʼpo moʼbahuahuikaʼ konigti doʼtaj onʼhuatiakbedne. Siro moʼto̱e̱po hue̱ypa moʼto̱e̱po doʼtaj onʼhuatiakbedne. ");
INSERT INTO amrNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Diosen jakyo ayaʼ huameʼnoeda ijhuadpo ijmanmadikaʼikay. Kenokaʼ doʼtaj tohuahueʼ o̱ʼnikaʼne. Konig Diosen huamanbatiaʼpakeria Apagbaʼte mentimadoyaʼuyate konigda opuda̱ doʼtaj kaʼdik o̱ʼnene. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kenda eadeʼte Jesúsen huanigpe̱i̱kaʼeri ayaʼada Jesústaj oʼnokmamonʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Huabokerek oʼtahuaʼpo yudtayoʼda nogtida kuperina oʼkudopo oʼtahuaʼnok onʼtaʼkoyatoʼnigʼa ");
INSERT INTO amrNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","kuperina oʼmatienonpo oʼmakmonʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Jesústaj onʼtohuaʼpo sacerdote huairitoneʼte onʼtohuaʼuyate. Nog sacerdote huairi, huairitoneʼ, Moisésenbaʼ huamanmadikaʼeri o̱gkupopakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pedronayo adteda Jesústaj oʼtahuaʼuyate. Sacerdote huairitoneʼen kurute oʼtiakdepo eʼtiokpakaʼyo oʼkudpo policíasere oʼhuadonhuaʼpo taʼak oʼtihuadonhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Sacerdote huairi nog judío huairiere o̱gkupakdepo “Jesúsa dakhueaʼda oʼkaʼuy.” “Jesúsa namaʼda oaʼuy.” Beʼapiʼ kenpaʼ aʼhuaayaʼpo onʼdikuk. Nogpaʼ nogpaʼ namaʼda aʼhuaayaʼpo kenpaʼti onʼdikukpo Jesús kabueyeʼ, eaʼtaʼ oʼderetpakuyate. Onʼdikuknigʼa dikhuahuayhueʼ o̱ʼnuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Huakkaʼada Jesústaj da onʼhuaaʼnigʼa jondikyoʼ huaahueʼ o̱ʼnuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Sueʼada onʼbopo da onʼhuaaʼpo: ");
INSERT INTO amrNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—‍“Diosen huid jaktoneʼtaj sakdik i̱jje̱y. Ken jak huabokereka o̱gkaʼuyatenig. Bapaʼ huameʼnoe onteʼti kaʼdik i̱jje̱y huabokerekapiʼ kahueʼtada.” Oroʼomeya̱ kenda oʼpe̱e̱mey. ");
INSERT INTO amrNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","—‍Noga̱ kenpaʼ oʼdaʼnigʼa ondikyoʼ huaahueʼ o̱ʼnuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kenokaʼ nopoyaʼda sacerdote huairitoneʼ oʼbodpo, —‍¿O̱ʼna menpaʼ baaʼtokhueʼ i̱e̱? ¿Kenda inomeya̱ ontaj bohuaaʼne buttida menpaʼ yadaʼ? —‍Sacerdote huairitoneʼa Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jesúsnayo soataʼ aʼtokhueʼda o̱ʼu̱yate. Sacerdote huairitoneʼ onteʼti onaʼpo: —‍¿O̱ʼna menpaʼ Cristo Diosen Huasiʼpo i̱ʼe̱? —‍Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","—‍E̱e̱ʼ, Cristo i̱jje̱y. Diosen Huasiʼpo i̱jje̱y. Diosa meʼtaʼmonaʼuyne. Dios teynanada o̱ʼi̱kaʼpo kenere eʼhuadte kurudya̱ʼ e̱ʼsi̱hui̱ya̱ʼ eʼtiakte onʼtiahuayapone. —‍Jesúsa sacerdote huairitoneʼtaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","64","Konig judío aratbuta onʼdiaypo o̱gkikaʼnig sacerdote huairi Jesústaj oʼpe̱e̱depo oʼhuadiayonpo yudtaj oʼhuisʼuyate. Noga̱ huairitaj oʼmanaʼpo: —‍Dios i̱jje̱y. Dakhueaʼda oaʼnok nog dakhueaʼ huaaʼeritaj pe̱e̱hueʼdik o̱ʼe̱y. Opuda̱ moʼpe̱e̱de. ¿Menpaʼ moʼnopo̱e̱? —‍Oʼmanaʼnok, —‍Dakhueaʼ oaʼ. Bueydik kaeʼ. —‍Ayaʼada oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Jesúsen huakoktaj onʼtisupuʼeʼuyate. Oʼnokpotidokaʼpo onʼtuktukpo, —‍Yamadikkaʼ. Yanopo̱e̱ʼ beʼa beʼtuktuk. —‍Oʼnonaʼuyate. Policíakon huakoktaʼ onʼtuktukuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ken jak kurute Pedro eʼhuadte sacerdote huairien muneʼyo̱ huanabaʼa oʼtiakpo ");
INSERT INTO amrNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","taʼak eʼtihuadte oʼtiahuaypo, —‍Jesús Nazaret hua̱e̱ʼeriere iʼhuaeʼikaʼuy. —‍Muneʼyo̱a̱ Pedrotaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","—‍Ehueʼ jo̱ki̱a̱hueʼya i̱jje̱y. Kateaʼ iʼet nopo̱e̱hueʼ i̱jje̱y. —‍Pedroa oaʼuyate. Eʼtiokpakaʼ akbogpeyo eʼhuadeʼte huatahuaa oʼsipoguyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Muneʼyo̱ huanabaʼ onteʼti oʼtiahuaypo, —‍In huabokerek Jesúsen huanigpe̱i̱kaʼeri nogtida o̱ʼe̱. —‍Oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","—‍Jesúsen huanigpe̱i̱kaʼeri ehueʼ i̱jje̱y. —‍Pedroa onteʼti oʼmanaʼuyate. Aʼtimon Pedrotaj onteʼti nogomeya̱kon oʼnonaʼpo: —‍O̱ʼna Jesúsen huanigpe̱i̱kaʼeri i̱ʼe̱po Galilea hua̱e̱ʼerien huaʼa iaʼne. —‍Oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","—‍Kentaj jo̱ki̱a̱hueʼya i̱jje̱y. Buttida ijjay. Buttida ahueʼ e̱e̱ʼnayo dakhueaʼda doʼtaj ka̱gkeʼ. —‍Pedroa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kenpaʼ eaʼte huatahuaa onteʼti oʼsipogʼuyate. Eʼsipogdeʼte “Huatahuaa bottaʼaʼ sipoghued e̱e̱ʼted doʼtaj jo̱ki̱a̱hueʼya i̱jje̱y bapaʼaʼ iaʼapo.” Menameʼnig Pedro huaboaʼda onteʼti oʼnoponpo paiʼnanada oʼhuikuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Emedeʼte monig Jesústaj kaʼdik o̱ʼe̱y sacerdote huairi huairitoneʼ Moisésenbaʼ huamanmadikaʼeriere onʼbatiaʼpakdepo Jesústaj onʼtinukupo Romano gobierno huairi Pilatotaj onʼtohuaʼuyate. Onʼyokuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","—‍¿Judíoen gobierno huairi menpaʼ i̱ʼe̱? —‍Jesústaj Pilatoa onaʼuyate. —‍E̱e̱ʼ kenda iaʼ kenda i̱jje̱y. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","—‍Jesús dakhueʼda o̱ʼe̱. Nogda nogda dakhueaʼ oʼkameʼ. Nogda nogda dakhueaʼ oʼkaʼuy. —‍Sacerdote huairia oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","—‍¿Menpaʼ aʼtokhueʼ i̱ʼe̱? Ontaj huakkaʼ dakhueaʼda boʼhuaaʼne. —‍Pilatoa Jesústaj onteʼti onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jesúsanayo sigpiʼ baaʼtokhueʼda oʼmauyatenok Pilato “kenpihuay” Jesústaj oknopo̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ken fiestate Pilatoa nogtatida huabakuda̱ʼ jakyo hua̱e̱ʼeritaj oʼmaoro̱kikaʼ. Kentaj aratbuta oʼbaktieʼeaʼpo o̱ʼo̱ro̱kikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Huabakuda̱ʼ jakyo dakhueaʼ huakaʼeri Barrabásere o̱ʼnepo gobierno huairitaj aʼmaenyaʼpo onʼbarakmeʼte. ");
INSERT INTO amrNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","“Nogok nogok fiestate nogtatida iʼmaoro̱kikaʼnig nogtatida ya̱o̱ro̱kaʼ.” Aratbuta Pilatotaj oʼnonaʼnok, ");
INSERT INTO amrNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","—‍¿Judíoen Huairitaj eʼnigo̱ro̱kaʼtaʼ menpaʼ boʼpak? —‍Pilatoa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Sacerdote huairi Jesústaj digda onʼhuahuaypo menʼnigtotiakne. Pilatoa kenpaʼ oʼnopondepo oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","“Barrabástaj ya̱o̱ro̱kaʼ. Barrabástaj ya̱o̱ro̱kaʼ.” Pilatotaj ya̱ʼnonaʼ. Sacerdote huairia huakkaʼ aratbuttaj diga̱ʼda onʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","—‍¿Judíoen Huairi opudomeya̱ onʼdikkaʼikaʼnigtaj monig ijkaʼapo? —‍Pilatoa onteʼti oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","—‍Hue̱ypa cruzte yaarak. —‍ʼUttaʼnada oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","—‍¿Menaʼpo? ¿Kate dakhueaʼ yakaʼ? —‍Pilatoa oʼmanaʼuyate. —‍Hue̱ypa cruzte yaarak. —‍Nogi̱ti nogi̱ti ʼuttaʼda oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ken aratbuttaj oʼmanigpe̱e̱po oʼpakpo Barrabástaj o̱ʼo̱ro̱kaʼuyate. “Jesústaj huiyokda huasiʼdakbiʼa yanʼbitbit” oʼmanaʼdepo hue̱ypa cruzte kanʼarakeʼpo Pilatoa sorotataʼtaj oʼbayokuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Gobierno huairien huaboroʼ jakyo onʼtohuaʼdepo ayaʼda sorotataj Jesústaj onʼtikupopakuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Jesústaj ayagda huaok onʼotaʼpo (ken konig gobierno huairiayoʼda onʼotikaʼnig) kenpaʼti eʼpid huakiok o̱gkuottaʼpo, ");
INSERT INTO amrNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","—‍Iʼtiak, judío aratbuten gobierno huairi. —‍Sorotataʼa dakhueʼdikda onʼnopo̱e̱po ʼuttaʼnanada oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kenpaʼti hue̱ypa o̱gkubitbitpo onʼtisupuʼepo huikudate onʼtihuaduyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ken konig onʼtierikdepo okayagda oʼnokirokaʼpo keʼnenokkon onteʼti onʼotaʼdepo hue̱ypa cruzte aʼarakyaʼpo Jesústaj onʼtohuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Simón Cirene huakkaʼ jak hua̱e̱ʼeri Alejandroen Rufoenere huaoj taʼbayaʼ oʼtiakpo kenteda oʼpoknok “Jesúsen cruz tohuaʼdik i̱ʼe̱ne,” oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ken Gólgota oteʼte onʼtohuaʼuyate. Gólgota aratbutenate huakuaiʼ oteʼte onʼtohuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ke̱ya̱ʼ sorotataj vino paiʼ onʼyokuyatenigʼa mayhueʼ o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Sorotataʼa Jesústaj cruzte onʼbetandepo beʼati keʼnen yudtaj yaʼdeyapet aʼnopo̱e̱yaʼpo huid okmo o̱ʼneneʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Sikyoedda nuevete cruzte onʼbetaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Huaku kutapen hue̱ymeyen “In judío aratbuten gobierno huairi o̱ʼe̱.” Onʼmadoyaʼuyate. Konige̱po bueydik o̱ʼe̱ onʼnopo̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Bottaʼ huabereʼeritakon hue̱ypa cruzte onʼmabetaʼuyate. Jesús huadaʼkopen noga̱ opeʼtopen onʼmabetuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","“Dakhueaʼ huakaʼeriere yaʼbueyapet.” Ken konig Apagbaʼ oaʼuyatenig Jesús oʼbueyʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Judío aratbuta onʼbapokpo Jesústaj dakhueaʼda onʼtidiʼkeonhuaʼuyate. Kenpaʼti onʼhuadiaypo huakua onʼpekoreʼepo, —‍“Diosen huaboroʼ jak ijsakapoy, bapaʼ huameʼnoe onteʼti ijkaʼapoy.” Iameʼne. ");
INSERT INTO amrNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","O̱ʼna bueyhueʼ a̱ʼe̱ya̱ʼpo huataʼda yatihuapokpo cruzyaʼ yahuarak. —‍Oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ken kenpaʼti sacerdote huairi Moisésenbaʼ huamanmadikaʼeriere huayahuaya dakhueaʼda onʼhuaaʼpo: —‍Nogomeytaj oʼbayareaʼikaʼuyatenigʼa huataʼnayo bueyhueʼ a̱ʼe̱ya̱ʼpo tihuapokhueʼdik o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Cristo judío aratbuten huairi kahuarakeʼ. Kenda eʼtiahuaynayo oknopo̱i̱kaʼdik o̱ʼe̱a̱poy. Huabereeriere Jesús onteteyoʼ hue̱ypa cruzte onʼbetpo kenpaʼti Jesústaj dakhueaʼda onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tokhuad eʼhuadte huadari huabada oʼsikonʼuy. Sikki̱re̱gda o̱ʼu̱yate. Tereaʼ eʼhuaddeʼte onteʼti oʼtaʼtuduyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Kenteda niokpo eʼhuadted, —‍Eloi, Eloi, ¿lama sabactani? —‍Jesúsa ʼuttaʼda oʼokoyonʼuyate. Ken aratbuten huaʼate: “¿Menaʼpo doʼtaj meʼenonne? Doʼhued Dios, doʼhued Dios.” ");
INSERT INTO amrNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Sueʼda huakkaʼmona onʼtikupobopo onʼpe̱e̱depo, —‍In huabokerek Elíaskudaktaj onokoy. —‍Onʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nogtida huabokerek oʼketonhuaʼpo a̱pon esponja vino paiʼyo oʼtaʼbutaʼpo hue̱ypate oʼbetaʼpo kenpaʼti huakittaʼte oʼnigokteaʼuyate. Kabuyukeʼpo oʼnigokteaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ken Jesús ʼuttaʼda oʼokoyondepo oʼnotitikonʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Eʼbueyonte Diosen huid jakyo konig tela pe̱gtoneʼ eʼoroyaʼda kutapen nopote oʼhuisonʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ken sorotataj capitána romanoa Jesúskokpen oʼbopo oʼtiahuaypo konig Jesús oʼokoyonpo oʼbueyonnigtaj oʼtiahuaypo, —‍In huabokerek buttida Diosen Huasiʼpo o̱ʼe̱. —‍Oʼdaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Kenpaʼti ettoneʼ o̱ʼnepo bidtaʼda onʼtiahuayanhuaʼuyate. María Magdalena o̱ʼe̱po kenpaʼti María Jacobo huasueden hua̱ye̱ José Saloméereen hua̱ye̱ o̱ʼnepo. ");
INSERT INTO amrNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Jesús Galileayo e̱e̱ʼte onʼtahuaʼikaʼpo kenpaʼti onʼmanigmanhuada̱ʼikaʼuyate. Kenpaʼti nogomey ettoneʼ huakkaʼmon bidtaʼda onʼtiahuayanhuaʼuyate. Keʼna Jesúsere Jerusalényo̱ onʼhuameʼte. ");
INSERT INTO amrNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ken oʼsikonyakuyate. Emeʼte judíoen okmapi̱e̱ʼahuaddik huameʼnoe o̱ʼe̱a̱ponok ");
INSERT INTO amrNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","José oʼtiakpo meʼpukhueʼ o̱ʼe̱po Pilatotaj oʼhuahuaʼpo “Jesúsenso̱ʼ beyok.” Onaʼuyate. José Arimateayo hua̱e̱ʼeri o̱ʼe̱po kenpaʼti judío huairi huakupopakyo hua̱e̱ʼeri o̱ʼu̱yate. Kenpaʼti Dios Huairitaj dakaʼ oʼnigi̱kaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Josétaj Pilatoa oʼpe̱e̱depo Jesús oʼbueyde oʼmepukeʼpo “¿menpaʼ yaʼbueyonde?” capitántaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","“E̱e̱ʼ, oʼbueyde,” capitána onaʼdenok Jesúsenso̱ʼ Josétaj oʼyokuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ʼUruda tela huakupete oeʼpo oʼso̱ʼhuarakapo oʼso̱ʼtihui̱yi̱gʼuyate. Aʼtimon huabo sipanaʼkogyo̱ oʼso̱ʼhuedanʼuyate. Kenpaʼti kubarak akbogpete huaboroʼ huida̱ oʼtinokbetanʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","María Magdalena Joséen hua̱ye̱ Maríaere ke̱yo̱ oʼso̱ʼhueda̱ʼ onʼtiahuayʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Judío aratbuten okmapi̱e̱ʼahuaddik huameʼnoe epokondeʼte domingo emedeʼte María Magdalena Salomé Maríaere Jacoboen hua̱ye̱ ʼuruʼhui̱e̱da huasihuaj huakupete oʼdepo Jesúsenso̱ʼ aso̱ʼhuekeyaʼpo oʼdeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Domingo emedeʼte kubarakyo onʼtiakdepo, ");
INSERT INTO amrNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","—‍¿Beʼa kubarak huid huanokbet yakpokoreaʼapet? —‍Huayahuaya onʼbatiaʼpakuyatenigʼa ");
INSERT INTO amrNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","onʼtiahuayatoʼpo kubarak huid huanokbet onokbetahueʼ onʼtiahuaypo, ");
INSERT INTO amrNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","kubarakyo onʼkuddepo daʼkopente huaboa bokerek huabid huaok yerenanada eʼottaj onʼtiahuaypo onʼmepukeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Okmeʼpukhueʼ meneʼ. Jesús Nazaret hua̱e̱ʼeri kentaj cruzte oʼdarakmeʼ boʼukne. Oʼnoyhuadde. I̱yo̱ ehueʼ o̱ʼe̱. I̱yo̱ onʼhueda̱meʼte. Ehueʼ o̱ʼe̱. Yanʼtiahuayʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Yanʼhuatiʼ, keʼnen huanigpe̱i̱kaʼeritaj kenpaʼti Pedrotaj yaʼnonaʼ, “Galileayo huakkuru oʼhuaʼapo. A̱yo̱da kentaj boʼtiahuayapone. Kenda ijjay boʼtiahuayapone.” —‍Kenda huabo huabokereka ettoneʼtaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ken ettoneʼ kubarakyaʼ oʼnokmonpo diga̱ʼda onmeʼpukpo beʼtapiʼ onbatiaʼpakhueʼ o̱ʼnuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Domingo sikyoedda Jesúsa oʼnoyhuaddepo huakkuruda María Magdalenataj oʼso̱ʼtiahuayʼeaʼuyate. Aʼnen Jesúsa siete noki̱re̱gtaj okmaenaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","María oʼhuaʼpo Jesúsen huanigpe̱i̱kaʼeritaj oʼhuahuaʼdepo Jesústaj ijtiahuaydey oʼbatiaʼpakuyate. Kenomey suhueʼnanada o̱ʼnepo onʼbahuikpo. ");
INSERT INTO amrNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Jesús onteʼti oʼnoe kenpaʼti María eʼtiahuaydetada oknopo̱e̱hueʼ o̱ʼnuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Nogok bottaʼ Jesúsen huanigpe̱i̱kaʼeri dagte onʼhuaʼuyate. Jesús konig nogkokada o̱ʼe̱po bottaʼtaj oʼbatiahuaydenok ");
INSERT INTO amrNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Jesús o̱ʼe̱ oʼnoki̱e̱ʼdepo nog huanigpe̱i̱kaʼeritaj onʼbahuahuaʼpo “Jesús oʼnoe,” eʼmanaʼtada Jesús oʼnoe nopo̱e̱hueʼda o̱ʼnuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Nogok once huanigpe̱i̱kaʼeri aypo kutopate enʼhuadte Jesús oʼmanokyonʼuyate. “Do eʼnoyhuadte huakkaʼmon doʼtaj mentiahuaydete kenda eʼtiaʼpaktada oʼnoyhuad oknopo̱e̱hueʼ moʼe̱ne. Dakhueʼda moʼe̱ne.” Oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","—‍Ayaʼbayoda ayaʼ aratbutte yanʼhuatiʼ. Huadak huaʼa yanʼmanbatiaʼpakikatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Huaknopo̱e̱ʼeritaj bautiza e̱gkaʼte Diosa oʼmanopoʼyareaʼapo oʼmanoeanhuahuikaʼapo, ayaʼ oknopo̱e̱hueʼ hua̱e̱ʼeritaj Diosa castiga oʼmagkadhuahuikaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Do ijpaknok doʼhued huadik eaʼte huaknopo̱e̱ʼeria totoʼ noki̱re̱gtaj onʼmakmaoro̱kaʼikaʼapo. Nog aratbuten huaʼate onaʼpakapo. ");
INSERT INTO amrNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Bihuitaj onʼpayto̱e̱a̱po. Mabokhueʼdik o̱ʼe̱a̱po. Eʼbueyuruhue̱ eʼmaypiʼ bueyhueʼdik o̱ʼneapo. Dakhueʼ aratbuttaj huabaʼa onʼtibataʼteaponok onʼbayarikaʼapo. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ken Jesúsa kenda eʼmanadeʼte Diosa Jesús Huairitaj oʼbaktobehuikuyate. Diosen huadaʼkopen oʼhuaduyate. ");
INSERT INTO amrNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Huanigpe̱i̱kaʼeria onʼbahuaʼpo nogyo̱ nogyo̱ ayaʼbayoda Jesúsen huadak huaʼa onʼmanbatiaʼpakonhuahuikaʼuyate. Jesús Huairia huakkaʼ oʼbatihuapokikaʼpo Jesúsen huadak huaʼa eʼmanbatiaʼpakte teyda oʼbatihuapoknok onʼbayareaʼpo nogda nogda o̱gkikaʼpo konig Diosyoʼda kaʼdik o̱ʼe̱nig o̱gkikaʼuyate, ken.");
INSERT INTO amrNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Oʼnigmadoyaʼne, huadiʼda Teófilo. Kenda Jesús oʼkadhuahuaʼuyate kenpaʼti oʼmanmadikaʼonhuahuaʼuyate. Ken sueʼda huakkaʼa onʼtiahuayonhuahuaʼuyate. Ken Jesús huaboaʼda oʼkaʼuyate onʼtiahuayʼuyate. Kenpaʼti Diosbaʼ onʼmanmadikaʼuyate. Nogomey onʼpeeonhuahuaʼuypo onʼtimadoyaʼuyate. Ayaʼ kenda Jesús oʼkadhuahuaʼuyate onʼtimadoyaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kenda Jesús oʼkadhuahuaʼuyate kenpaʼti Jesústaj onʼtimadoyaʼuyate aʼnennada huakkuruda ijbaʼtiahuayonhuahuaʼuy. Dakaʼnada yoknopoeonhuahuikay. Konige̱po doʼhuakon Jesústaj dakaʼ eʼtimadoyaʼonhuahuaʼtaʼ ijpaki, Teófilo. ");
INSERT INTO amrNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Kenda Jesústaj iʼnigpe̱e̱demeʼte buttida o̱ʼe̱ kanopo̱e̱ʼpo dakaʼda onʼnigmadoyaʼonhuahuaʼne. ");
INSERT INTO amrNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Aʼnennada Romano gobierno huairi Herodes Judea huadaribayo o̱ʼu̱yate. Kenokaʼ sacerdote o̱ʼe̱po sacerdote Diostaj kenda onʼbaaʼpo ʼuhua onʼnigbatiarakikaʼuyate. Zacaríasa sacerdote o̱ʼu̱yate. Zacaríasere nogomey sacerdote onʼbaaʼikaʼpo onteteyoʼ onʼbaaʼikaʼpo kenomeyendik onʼmadikkaʼuy Abías. Zacaríasen hua̱toeen huadik Elisabet. Elisabeten adhueaʼpaneʼ Aarón o̱ʼu̱yate. Aarón huakkuruda sacerdote huairi o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Zacarías hua̱to̱e̱ Elisabetere Diostehuapaʼ ʼurunopoʼda o̱ʼnikaʼuyate. Ayaʼda Diosen eʼmanaʼ onʼnigpe̱i̱kaʼuyate. Dakhueaʼda o̱gkaʼ beʼapiʼ bahuaahueʼdik o̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Elisabet siʼpopakhueʼdik o̱ʼu̱yate kenpaʼti toneʼnanada o̱ʼnepo huasiʼpo to̱e̱hueʼ o̱ʼnuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nogmeʼnoetida Zacaríasomey konig sacerdote Diosen jakyo baaʼdik o̱ʼneʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Konig sacerdote o̱gkikaʼ huidsiʼpo oʼnendepo onʼtiahuaydepo Zacaríasyoʼda Diosen jakyo kuddik o̱ʼu̱yate. Konig ʼuruʼhui̱e̱a̱da vela aʼbakpakayaʼpo Dios Huairitaj Zacarías kuddik o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ken Zacarías Dios Huairien jakyo o̱ʼe̱po vela ʼuruʼhui̱e̱a̱da oʼbakpakaʼdepo jakkurute huakkaʼda aratbut o̱gkupopakdepo onʼtionaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Kenokaʼ Zacarías Dios Huairien huataʼmoneritaj oʼtiahuayʼuyate. Ken kutopate ʼuruʼhui̱e̱a̱da vela eʼbakpakte huadaʼkopen oʼboʼuyate. Dios huairien huataʼmoneri kente oʼboʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zacarías oʼtiahuaypo huakkaʼ oʼmeʼpuʼkuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","—‍Meʼpukhueʼ ya̱e̱ʼ, Zacarías. Kenda Diostaj iʼtionaʼpakuynok Diosa mepe̱e̱ʼuyate. O̱ʼnen hua̱to̱e̱ Elisabet bokereksiʼpoaʼ oʼsiʼpopakapo kenpaʼti kentaj iʼdikkaʼapone Juan. ");
INSERT INTO amrNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","15","O̱ʼnensiʼpoa Diostaj ʼuruaʼda oʼnigpe̱e̱a̱po konige̱po durugnanada i̱ʼe̱a̱pone. Kenpaʼti eʼsiʼpoe̱ʼte huakkaʼada onʼdurugpakapo. Vino mayhueʼ iʼta̱e̱a̱pone. Kenpaʼti piscoʼpiʼ mayhueʼ iʼta̱e̱a̱pone. Siʼpopakhued e̱e̱ʼted Diosen Noki̱re̱ga̱ oʼnopoʼto̱e̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Huakkaʼtada Israel aratbuttaj Dios Huairitaj huaknopo̱e̱ʼ Juana oʼmanopoʼkoreaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Cristo Huairitaj Juan huakkuruda o̱ʼe̱a̱po. Cristo tiakhued o̱ʼnensiʼpoa Juan huakkuruda o̱ʼe̱a̱po. Elíasen noki̱re̱ga̱ oʼnopoʼto̱e̱po konig Elías teyda o̱ʼu̱yate konigti Juan teyda kaʼdik o̱ʼe̱a̱po. Huaoj huasiʼpotaj onʼbakkahueaʼpo onʼmanoeynoeya̱po. Ken huayahuaya huaoa huasiʼpoa huadiʼda onʼmaeapo. Kenda Juana oʼkaʼapo. Kenpaʼti nigpe̱e̱hueʼ hua̱e̱ʼeritaj oʼmanopoʼkoreaʼapo onteʼti onʼnigpe̱e̱a̱po. ʼUruaʼda onʼnopo̱e̱po huadakda o̱gkaʼapo. Ken Cristo Huairitaj kanoknopo̱e̱ʼpo Juana aratbuttaj ʼuruʼnopoaʼda oʼmagkaʼapo. —‍Diosen huataʼmoneria Zacaríastaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","—‍Kenda onaʼnig buttiaʼ oknopo̱e̱hueʼdik i̱jje̱y. Huatoneʼda i̱jje̱y, doʼhued hua̱to̱e̱kon huatoneʼda o̱ʼe̱. —‍Zacarías Diosen huataʼmoneritaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","—‍Do Gabriel i̱jje̱y. Diosen huanabaʼ i̱jje̱y. Diosa meʼtaʼmonaʼne. Ontaj kanʼbatiaʼpakeʼpo Diosa meʼtaʼmonaʼne. Huadak huaʼa kanʼbatiaʼpakeʼpo Diosa meʼtaʼmonaʼne. ");
INSERT INTO amrNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Kenda onaʼdenigʼa buttiaʼ oknopo̱e̱hueʼ o̱ʼe̱nok aʼpakhueʼdik i̱ʼe̱a̱pone. O̱ʼnensiʼpo eʼsiʼpoe̱deʼte onteʼti aʼpakdik i̱ʼe̱a̱pone. Kenokaʼ Diosa oʼpak kenda yonaʼdey o̱ʼe̱a̱po. —‍Diosen huataʼmoneria onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Kenokaʼ jakkurute aratbut o̱gkupopakpo Zacaríastaj onʼnige̱po ijhueʼda Diosen jakyo o̱ʼe̱nok aratbut onʼmeʼpukeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ken kenokaʼ Zacarías o̱ʼo̱ro̱kdepo aʼpakhueʼdik o̱ʼu̱yate. Diosen jakyo konig eʼyorokyanig Diosa Zacaríastaj oʼtiahuayaʼ kenomey aratbut onʼnokotuyate. Ken Zacarías huabaʼa oʼtohuaʼyadhuaʼuyate. Ken aʼpakhueʼdik o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Ken ken huameʼnoete Diosen jakyaʼ konig sacerdote oʼbaaʼonhuahuaʼpo oʼkuhuitdepo hua̱ʼen jakyokon oʼhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Nogok keʼnen hua̱to̱e̱ Elisabet huaboaʼda bogdakhueʼ o̱ʼu̱yate. Konig oʼi̱re̱gunhuahuaʼpo cinco puug jakkurute o̱ro̱khueʼ o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Dakhueʼda o̱ʼe̱. Siʼpopakhueʼdik o̱ʼe̱.” Ken aratbut huaahueʼ meʼneapone. Dios Huairia meʼtinepahuiʼpo in megkaʼne. Elisabet oʼnopo̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ken Elisabet seis puug bogdakhueʼ e̱ʼe̱deʼte Diosen huataʼmoneri Gabrieltaj Diosa oʼtaʼmonaʼuyate. Nazaret huakkaʼ jakyo Galilea huadaribayo oʼtaʼmonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Muneʼyo̱ Maríataj oʼhuahuaʼuyate. María katenohued o̱ʼu̱yate. Kato̱e̱pakeʼpo Maríaen huaoa oʼyokuy Josétaj. José Davidkudak huairien onaratbutyoʼ konig huayayo o̱ʼu̱yate. María hueretda to̱e̱pakhued Gabriel oʼhuahuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Maríataj oʼhuahuaʼdepo, —‍Ijtiaki, María, Diosa ʼuruaʼda megkaʼne, onere o̱ʼe̱. Nog ettoneʼtaj Dios sueʼda huadak oʼmagkaʼnigʼa ontanayo huadakaʼda megkaʼne. —‍Maríataj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ken, Diosen huataʼmoneritaj oʼtiahuaydepo oʼpe̱e̱depo keʼnen huaʼataj oʼmeʼpukatupo, ¿Menaʼpo ken konig menaʼne? oʼnopo̱e̱po María. ");
INSERT INTO amrNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","—‍Meʼpukhueʼ ya̱e̱ʼ, María. Diosa metinepahuiʼpo ʼuruaʼda megkaʼne. ");
INSERT INTO amrNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Bogdakhueʼ i̱ʼe̱a̱pone. Huabokereksiʼpoaʼ iʼsiʼpopakapone. Iʼdikkaʼapone JESÚS. ");
INSERT INTO amrNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Huairi o̱ʼe̱a̱po. Kentaj huakkaʼda oʼnoknopo̱e̱a̱popo onʼnigpe̱e̱a̱po. Diosen Huasiʼpo onʼdikkaʼapo. Dios Kuruderiensiʼpo onʼdikkaʼapo. Konig Davidkudak huairitoneʼ huakkaʼda aratbuttaj oʼmanaʼikaʼuyate. Konigti Dios Huairi Jesústaj huairitoneʼ oʼyahueaʼapo. Ken ayaʼda Israel aratbuttaj oʼmanaʼonhuahuikaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ken Israel aratbuttaj oʼmanaʼonhuahuikaʼapopo, batikhueʼ o̱ʼeonhuahuikaʼapo. —‍Diosen huataʼmoneri Gabriela Maríataj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","—‍¿Menpaʼ do ijsiʼpopakapo? Huabokerekere huedhued i̱jje̱y. —‍Maríaa Diosen huataʼmoneritaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","—‍Diosen Noki̱re̱g betihuarakapone. Kenpaʼti Dios teynanada o̱ʼe̱po konig e̱ʼsi̱hui̱a̱ betibukapone, ontaj betibukapone. Konige̱po kensiʼpo oʼsiʼpoe̱apo Diosyaʼ oʼtiakapo. Diosenyoʼda oʼkikaʼapo. Diosen Huasiʼpo o̱ʼe̱. Aratbuta onʼbatiaʼpakikaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Kenpaʼti o̱ʼnen huabet Elisabet huabokereksiʼpo oʼsiʼpopakapo. Keʼna huatoneʼnanada o̱ʼe̱nok siʼpopakhueʼdik onʼbatiaʼpakikameʼte. Keʼna seis puug bogdakhueʼ o̱ʼe̱de. ");
INSERT INTO amrNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Diosnayo ayaʼda kaʼdik o̱ʼe̱. —‍Diosen huataʼmoneria onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","—‍Dios Huairien huanabaʼ i̱jje̱y. Ken konig onaʼnig kenda Diosa megkeʼ. —‍María onaʼuyate. Ken konig onaʼdepo Diosen huataʼmoneria okhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Kenokaʼ María atoksikeyaʼpo oʼhuahuaʼuyate. I̱dada oʼhuaʼpo Judea oteʼbayo oʼhuaʼuyate. Oteʼ huakkaʼ jakyo oʼhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Zacaríasen jakyo oʼkudondepo Elisabettaj “Ijtiaki,” onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Kenokaʼ Elisabet Maríataj oʼpe̱e̱depo yo̱beda huakiokoyaʼ oʼtiarudʼuy. Diosen Noki̱re̱ga̱ oʼnopoʼto̱e̱ʼuyate. Elisabettaj oʼnopoʼto̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","—‍Diosa ayaʼ ettoneʼtaj dakaʼ mogkikaʼne. Ontanayo ʼuruaʼda megkaʼne. Kenpaʼti o̱ʼnensiʼpotaj ʼuruaʼda o̱gkaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Beʼa i̱jje̱ do doʼhued Huairied hua̱ye̱a̱ oʼhuatiakne? ¿Menpaʼ Diosa ʼuruaʼda megkaʼ? ");
INSERT INTO amrNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ken huaboaʼda ontaj “Ijtiaki,” eaʼte ijpe̱e̱depo yo̱beda huakiokoyaʼ oʼdurugpakpo beʼtiarudne. ");
INSERT INTO amrNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Dios Huairitaj iknopo̱e̱po durugda i̱ʼe̱ konige̱po kenda Diosa menameʼne kenda megkaʼapone. —‍Ken Elisabeta Maríataj ʼuttaʼda onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Dios Huairi ʼuruaʼda o̱ʼe̱ huanopoyaʼda yoknopo̱e̱y. ");
INSERT INTO amrNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Doʼhued Dios Huairi doʼtaj huanopoʼyareaʼeritaj durugnopoʼda i̱jje̱y. ");
INSERT INTO amrNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Konige̱po doʼtaj beʼtiahuayne. Paiʼda huanabaʼ e̱e̱ʼpiʼ dakaʼ beʼtiahuayne. Kenda nogok nogok aratbuta moʼbatiaʼpakikaʼapone. Diosa ʼuruaʼda megkaʼnig. Kenda moʼbatiaʼpakapone. ");
INSERT INTO amrNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Keʼnendik ʼuruda o̱ʼe̱po ayaʼda kaʼdik o̱ʼe̱po konige̱po ʼuruaʼda doʼtaj megkaʼne. ");
INSERT INTO amrNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Diostaj huakmeʼpukeritaj nogok nogok oʼmatinepahuikaʼpo, Diosa oʼmatinepahuikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Diosa teyda oʼkikaʼ. Namaʼda ʼuruda i̱jje̱y huanopo̱e̱ʼeritaj kenpaʼda oʼmaenapo. ");
INSERT INTO amrNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Huairitoneʼtaj oʼmaenpo paiʼda aratbuttaj huairi oʼbayahueaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ken paiʼda hua̱e̱ʼeritaj huadakda oʼbayokikaʼ. Huakkaʼda huato̱e̱ʼeritaj oʼmataʼmonaʼ. Katepiʼ to̱e̱hueʼda oʼmataʼmonaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Israel aratbut konig Diosen huanabaʼ e̱ʼhua̱e̱ʼtaj Diosa dakaʼ oʼmato̱i̱kaʼpo, okkahuehueʼ oʼmaepo oʼmatinepahuiʼikaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Oroʼen huapaneʼkudakomeytaj kenpaʼti Abrahamkudaktaj kenpaʼti ayaʼda keʼnensiʼpo keʼnen huayayo nogok nogok ayaʼtada “Ijmatinepahuiʼapoy” onaʼuyate Diosa. Kenda oʼkikaʼ. Kenda Maríaa Elisabettaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ken Elisabetere o̱ʼunhuahuaʼuyate. Bapaʼ puug María o̱ʼunhuahuaʼuyate. Bapaʼ puug o̱ʼe̱depo hua̱ʼen jakyo oʼkumeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ken, kenokaʼ Elisabet huasiʼpopak o̱ʼe̱denok huabokereksiʼpo oʼsiʼpopakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Onteteyoʼ huahuaderi kenpaʼti Elisabeten huabet hua̱e̱ʼeri onʼmapeeundepo ken Dios Elisabettaj oʼtinepahuiʼpo yo̱bed oʼyoknok onʼpe̱e̱depo Elisabetere onʼmadurugpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Yo̱bed ocho huameʼnoe e̱e̱ʼte huabokereksiʼpoensiʼdak kaktegeʼpo konig judío aratbut o̱gkikaʼuyate, aktegyaʼpo onʼbatiakuyate. Siʼnontaj huaoendik Zacarías eʼdikkataʼ onʼpakuynigʼa. ");
INSERT INTO amrNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","—‍Ka̱e̱ʼ. Keʼnendik Juan o̱ʼe̱. —‍Keʼnen hua̱ye̱a̱ oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","—‍¿Menapo? O̱ʼnen huabet ken huadik ehueʼ o̱ʼne. —‍Oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","“¿Keʼnendik katedik iʼpak?” Konig Zacarías pe̱e̱hueʼdik o̱ʼe̱nok huabaʼa onʼtohuaʼyaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Kamadoyeʼpo huaen tablataj meʼnigtotiak oʼmanaʼuy. Enʼtotiakdeʼte “Keʼnendik Juan o̱ʼe̱.” Zacaríasa oʼmadoyaʼuyate. Ayaʼda onʼtiahuaydepo kenpihuay onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Juanendik oʼmadoyaʼdepo Zacarías onteʼti huaboaʼda aʼpakdik o̱ʼu̱y. Dios Huairi ʼuruaʼda o̱ʼe̱po teyda oʼkikaʼ Zacaríasa oʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Ayaʼda aratbut ke̱yo̱da meyo̱hueʼda kenpihuay onʼnopo̱e̱ʼuyate. Kenda Zacarías oʼkaʼ kenpaʼti Juantaj huabada onʼbatiaʼpakeʼuy. Judea oteʼyo huabada kenda onʼbatiaʼpakeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ken ayaʼada onʼtipe̱e̱depo kenda onʼtinopoeonhuahuaʼpo nogtaj nogtaj onʼbatiaʼpakonhuaʼpo: —‍Keʼna huasiʼpo Juana Diostaj kate ʼuruaʼda yaʼnigkapet. —‍Diosa ʼuruaʼda o̱gkameʼnok onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Juansiʼpoen huaoj Zacarías o̱ʼe̱po Diosen Noki̱re̱ga̱ oʼnopoʼto̱e̱nok Zacaríasa oʼmanaʼpakpo: ");
INSERT INTO amrNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Dios Huairitaj Israel aratbuta oʼnoknopo̱i̱kaʼ. Dios Huairi ʼuruaʼda o̱ʼe̱. Kanʼbatiaʼpakikeʼpo. Oroʼomey Israel aratbuttaj boʼhuatiakdepo moʼnopoʼyareaʼne. ");
INSERT INTO amrNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Kenpaʼti Diosen huanabaʼ Davidkudak huakkaʼda huayayo oʼmata̱e̱ʼnigʼa nogtida boʼyokdene. Dios Huairia oroʼomeytaj boʼyokdene. Keʼna Davidkudaken adhueaʼ huayayo o̱ʼe̱po teynanada huamanopoʼyareaʼeri o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","75","Oroʼen takaʼtaj akmaenyaʼpo Dios Huairia oʼmataʼmonaʼapo. Oroʼomeytaj huahuadiayeritaj Dios Huairia boʼtiokaʼpo oʼmaenapo. Kenpaʼti oroʼomeyen adhueaʼpaneʼtaj aʼmatinepahuiyaʼpo, “Meʼpukhueʼada o̱ʼna o̱ʼnen huayayoere Diostaj ʼurunopoʼda kanʼnigpe̱i̱keʼpo kenpaʼti Diostayoʼda kanʼnigpe̱i̱keʼpo opudomeyen takaʼtaj boʼtiokaʼapone.” Ken oroʼen huaoj Abrahamtaj kenda Diosa onaʼuyate. Kenda Diosa okkahuehueʼ o̱ʼi̱kaʼ. Ken Diosa oaʼuyate. Kenda aʼnennada Diosen ʼuruaʼda huamanbatiaʼpakeria oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Kenpaʼti, o̱ʼna doʼhuedsiʼpo, Dios Kuruderien huamanbatiaʼpakeri moʼdikkaʼapone konige̱po Cristo Huairia manmadikahued o̱ʼna huaboaʼda iʼmanmadikaʼapo. Konig Cristo Huairi o̱ʼe̱a̱po huakkuruda iʼmanmadikaʼapone. Kenda iʼmanmadikaʼdepo aratbuttaj iʼmanopoʼkoreaʼapone. Cristotaj iʼmaknopo̱e̱a̱ʼapone. ");
INSERT INTO amrNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Aratbut Cristotaj oʼnoknopo̱e̱depo onʼnigpe̱i̱kaʼpo dakhueaʼ eʼkaʼ Diosa oʼbakkahueaʼapo kenpaʼti oʼmanopoʼkoreaʼapo. Iʼmanmadikaʼaponok oʼnoknopo̱e̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ken oroʼen Diosa diʼ moʼe̱po moʼmatinepahuiʼpo konig niokpo oʼtaʼtikaʼnig kutayaʼ Cristo konigti oʼhuarakapo. ");
INSERT INTO amrNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Sikki̱re̱gyo̱ hua̱e̱ʼeritaj keʼna konig huakjey oʼmaeapo. Aratbut eʼbueytaj huameʼpukeritaj konig huakjey oʼmaeapo. Diostaj oʼmaknopo̱e̱a̱ʼapo. ʼUruda huakadhuaʼ monʼmadikaʼapone. Kenda enaʼte onʼnopoʼnoeyapone. Zacaríasa oaʼuyate, ken. ");
INSERT INTO amrNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ken Zacaríasensiʼpo oʼkerekpo kenpaʼti Diostaj dakaʼda oknopo̱e̱po nogi̱ti nogi̱ti oknopo̱e̱po aratbut ehueʼ e̱ʼneʼte o̱ʼeonhuahuikaʼpo Israel aratbuttaj aʼmanbatiaʼpakyaʼpo huahued aratbut ehueʼ e̱ʼneʼte o̱ʼeonhuahuikaʼpo. Nogok Israel aratbuttaj oʼmanbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Kenokaʼ Romano huairitoneʼ o̱ʼi̱kaʼpo keʼnendik Augusto o̱ʼe̱ʼuyate. “Ayaʼ huabokerekdik kanʼmatimadoyeʼ.” Huairia Augustoa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ken konig huabokerekdik onʼmatimadoyaʼuyate, ken konig Romano huairi oʼpaknok huakkuruda ayaʼ huabokerekdiktaj onʼmatimadoyaʼuyate. Kenokaʼ Siria aratbut gobierno huairi Cireniotaj onʼnigpe̱i̱kaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ken ayaʼda aratbut kenomeyen adhueaʼpaneʼen huakkaʼ jakyo huaʼdik o̱ʼnepo huadik gobiernoen berobaʼte aʼtimadoyayaʼpo onʼbahuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Konige̱po Nazaret huakkaʼ jakyaʼ José oʼhuaʼuyate. Nazaret Galilea huadaribayo o̱ʼe̱. Nog huadaribayo oʼhuaʼuyate. Judea huadaribayo José oʼhuaʼuyate. Huakkaʼ jakyo Belényo oʼhuaʼuyate. Belényo Davidkudak oʼsiʼpoe̱ʼuyate. José Davidkudaken adhueaʼ huayayo o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Belényo huadik i̱jje̱y aʼtimadoyayaʼpo oʼhuaʼpo Maríaere onʼhuaʼuyate. Maríaen huaoj Maríataj oʼto̱e̱pakanpo Joséere onʼhuaʼpo María bogdakhueʼ o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ken Belényo o̱ʼnedepo kenokaʼ siʼpopakdik o̱ʼe̱po ");
INSERT INTO amrNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","huakkuru huabokereksiʼpo oʼsiʼpopakuyate. Aratbuten huatay jakyo huakkaʼda o̱ʼnedepo kudhueʼdik o̱ʼnepo vaca ʼuhuaen jakyo oʼsiʼpopakuyate. Konig atisuksiʼpo yo̱bedtaj onʼtidokaʼpo vacaen huabapeʼ aypo cajayo onʼhueda̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Belén huakkaʼ jakyo meyo̱hueʼda oveja huamato̱e̱ʼeri o̱ʼnebedpo kenomeyen oveja onʼmato̱e̱bedpo mire̱ huadaribayo onʼmato̱e̱beduyate. ");
INSERT INTO amrNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","I̱dada Dios Huairien huataʼmoneritaj onʼtiahuayʼuyate. Oveja huamato̱e̱ʼeria onʼtiahuaypo Dios Huairi eynanada nogyen nogyen oʼbatitaʼtenok huakkaʼda onʼmeʼpukeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","—‍Meʼpukhueʼ yaneʼ konige̱po huadak huaʼa oʼnigtotiakne. Ken ayaʼada onʼmape̱e̱depo onʼmadurugpakapo. ");
INSERT INTO amrNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Davidkudaken jakyo oy Diosen Huamanopoʼyareaʼeri oʼmanigsiʼpoe̱de. Keʼna Cristo Huairi o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kanʼnopo̱e̱ʼpo huasiʼpo atisuksiʼpo eʼtidokaʼ vacaen huabapeʼ aypo cajayo eʼhuedte boʼhuahuayapone. —‍Ken Diosen huataʼmoneria oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kenokaʼ ken Diosen huakkuru huataʼmoneri e̱e̱ʼted nog huakkaʼnanada huataʼmoneri kurudya̱ʼ onʼhuahuarakdepo, ");
INSERT INTO amrNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","—‍Dios kutayo o̱ʼi̱kaʼpo ʼuruaʼda o̱ʼe̱po oʼkaʼde, i̱yo̱ huadariyo aratbuttaj Diosa oʼpakpo oʼmanoeya̱ʼ. —‍Diosen huataʼmonaʼeriomeya̱ ʼuruaʼnanada onʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Kurudyo̱ Diosen huataʼmoneriomey enʼbehuikdeʼte, “Belényo monhuaʼ. Kenda Diosa oʼkaʼde Dios Huairia moʼnopo̱e̱a̱ʼdene monʼtiahuay.” Oveja huamato̱e̱ʼeriomeya̱ huayahuaya onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","I̱dada onʼbahuaʼuyate. María Joséere kenpaʼti yo̱bedtaj onʼbahuahuayʼuyate. Yo̱bed vacaen mire̱ huabapeʼ cajaʼpoyo eʼhuedte onʼhuahuayʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Jesús yo̱bedtaj onʼtiahuaydepo kenda Diosen huataʼmoneria huasiʼpotaj oʼhuaaʼnig ayaʼda Josétaj Maríataere oʼnonʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ken, ayaʼda onʼpe̱e̱depo José Maríaere kenpihuay onʼnopo̱e̱ʼuyate. Kenda oveja huamato̱e̱ʼeriomeya̱ eʼbatiaʼpakdeʼte onʼmepukeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Maríanayo kenda oveja huamato̱e̱ʼeriomeya̱ enʼbatiaʼpakdeʼte kenda okkahuehueʼ o̱ʼe̱po oʼnopoeonhuahuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ken oveja huamato̱e̱ʼeriomeynayo o̱gkumeʼuyate. Ovejate o̱gkumeʼuyate. O̱gkumejpo “Diosen huataʼmoneria buttida monaʼnig. Konig monaʼnig Diosa oʼkaʼ, konig oʼpe̱e̱nig konigti oʼtiahuaydey. Dios ʼuruaʼda o̱ʼe̱po huadaknada oʼkikaʼ. Huadakda mogkaʼne. Dakiti Dios.” Ken oveja huamato̱e̱ʼeriomeya̱ onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Ken eʼsiʼpopakte ocho huameʼnoe e̱ʼe̱deʼte huabokereksiʼpoensiʼdak oʼnoktegʼuyate. Oʼnoktegdepo onʼdikkaʼuyate Jesús. Ken huadik Diosen huataʼmoneria aʼnenda oʼdikyokʼuyate. María bogdakhueʼ ehueʼ e̱e̱ʼted oʼdikyokʼuyate. Kenda oʼdikkaʼuyate Jesús. ");
INSERT INTO amrNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Huabokereksiʼpo eʼsiʼpopakdeʼte cuarenta huameʼnoe eʼpokdeʼte keʼnen huaoj hua̱ye̱ere bottaʼ apoyerepiʼ bottaʼ tukkupiʼ eʼnigarak Diostaj yokdik yaneʼ. Kenda judío aratbuttaj Moisésa oʼmanaʼuyate. Kenpaʼti ettoneʼen huakkurueri huabokereksiʼpo eʼsiʼpopakdeʼte “Diosen o̱ʼta̱e̱.” Kenda aratbuta kanʼbatiaʼpakeʼ. Judío aratbuttaj Moisésa oʼmanaʼuyate. Ken Jesús eʼsiʼpoe̱ʼte cuarenta huameʼnoe eʼpokdeʼte José Maríaere Jesústaj onʼtohuaʼuyate. Jerusalényo̱ onʼtohuaʼuyate. Ayaʼ Moisésa oʼmanaʼuyatenig kenda aʼkayaʼpo Jerusalényo̱ onʼtohuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","27","Ken Jerusalényo̱ oʼnokye̱depo Diosen jakyo onʼkudʼuyate. Diosenbaʼ Moisésa oʼnigmadoyaʼuyatenig aʼnigpe̱e̱yaʼpo onʼkudʼuyate. Jesústaj eʼnigkaʼ aʼnigpe̱e̱yaʼpo onʼkudʼuyate. Onʼkuddepo Simeón ke̱yo̱da o̱ʼe̱ʼuyate. Simeón Jerusalén huakkaʼ jakyo hua̱e̱ʼeri o̱ʼu̱y. ʼUrunopoʼda o̱ʼe̱po Diostaj huakkaʼda oʼpakikaʼuyate. Diosen Noki̱re̱ga̱ oʼnopoʼto̱e̱ʼuyate. Cristoa paiʼda Israel aratbuttaj oʼmanopoʼyareaʼapo. Kentaj Simeóna oʼnigunhuahuikaʼpo Cristotaj Dios Huairia oʼtaʼmonaʼapo Cristotaj ijtiahuayapoy, do bueyhued i̱jje̱po ijtiahuayapoy. Ken Diosa Simeóntaj oʼnopo̱e̱a̱ʼuyate. Yo̱bed Jesús huaojere hua̱ye̱ere Diosen jakyo eʼkudte Diosen Noki̱re̱ga̱ Simeóntaj oʼtokudʼuyate ");
INSERT INTO amrNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simeón Jesússiʼpotaj oʼdokopo, ʼuruaʼnada oʼtiaʼpakpo: ");
INSERT INTO amrNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","30","Konig menaʼuyne megkaʼdene. Konig menaʼuyne o̱ʼnen Huamanoeanhuahuikaʼeritaj ijtiahuaydey, Dios Huairi oyda menopoʼnoeyanpo kabueyeʼ meknopo̱e̱ʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Kentaj ayaʼtada Diosa oʼbayokdenok ayaʼada aratbuta tiahuaydik o̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Insiʼpoa konig huakjey o̱ʼe̱po Dios konig o̱ʼe̱nig judío ehueʼ aratbuttaj oʼmaknopo̱e̱a̱ʼapo kenpaʼti Israel aratbut ʼuruda o̱ʼne keʼna ayaʼtada oʼmanopo̱e̱a̱ʼapo. Ken konig Diostaj Simeóna oaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Simeón Jesústaj ʼuruaʼda oʼbatiaʼpaknok Jesúsen huaoj hua̱ye̱ere kenpihuay onʼnopo̱e̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","“Diosa dakaʼ mogkaʼne.” Simeóna oʼmanaʼuyate Maríataj Josétaere. —‍E̱ya̱ʼ Diosa oʼpaknok insiʼpotaj huakkaʼ Israel aratbut oknopo̱e̱hueʼda o̱ʼnepo Diosere ehueʼ o̱ʼneapo nog Israel aratbuta oʼnoknopo̱e̱po Diosere kenpaʼda onʼnoeonhuahuikaʼapo. Diosen huaʼa oaʼikaʼnok kenpaʼti konig Dios oʼpak oʼkikaʼaponok huakkaʼada kentaj dakhueʼada onʼhuaaʼpo onʼhuamahui̱ʼi̱a̱ʼapo. ");
INSERT INTO amrNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Onʼhuamahui̱ʼi̱a̱ʼpo dakhueaʼ huanopoyaʼ onʼnopo̱e̱nig kenda ayaʼada onʼnopo̱e̱a̱po. O̱ʼnakon María paiʼda i̱ʼe̱a̱pone. Konig siro eʼnopoʼhuekonig suhueʼnanada i̱ʼe̱a̱pone. —‍Ken Simeóna Maríataj onaʼuyate. María Jesúsen hua̱ye̱ o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ke̱yo̱da Diosen jakyoda Ana o̱ʼu̱yate. Ana Diosen huaʼa huamanbatiaʼpakeri o̱ʼu̱yate. Ana Fanuelen hua̱yo̱bu kenpaʼti Aser aratbut o̱ʼu̱y. Huatoneʼnanada o̱ʼu̱yate. Konig muneʼyo̱ sueʼda huabayok e̱ʼta̱e̱tada oʼto̱e̱pakuyate. Siete huabayok hua̱to̱e̱ere onʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Kenokaʼ Jesús Diosen jakyo e̱e̱ʼte konig ayhua ochenta y cuatro huabayok o̱ʼeonhuahuikaʼdeʼuy. Diosen jakyo o̱ʼi̱kaʼpo jakyaʼ huahueʼ o̱ʼi̱kaʼuyate. Diostaj oʼnigpe̱i̱kaʼpo nogok nogok Diostaj oʼpakpo bapehueʼda o̱ʼe̱po, Diostayoʼda oʼtionaʼpakahuadikaʼuyate. Kenpaʼti oʼtionaʼpakbedikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Kenokaʼ Simeón enadeʼte Ana Jesústaj oʼhuahuaʼuyate. Anaʼa Diostaj dakiti oaʼdepo ken Jesúsa paiʼda enʼnopoʼe̱te Jerusalén aratbuttaj oʼmadurugpakapo. Kentaj huakkaʼda oʼnonmabonok Anaʼa Jesústaj oʼmanbatiaʼpak ken. ");
INSERT INTO amrNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ken Dios Huairienbaʼ eʼmanaʼte ayaʼda onʼnigpe̱e̱depo José Maríaere Galilea huadaribayo onʼkumeʼuy. Kenomeyen jakyo Nazaretyo onʼkumeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ken Jesússiʼpo oʼkerekpo, oʼteyyepo kenpaʼti Diosen eʼkaʼ konig ʼuruaʼda eʼkaʼ nogi̱ti nogi̱ti oʼnopo̱e̱ʼuyate. Kenpaʼti Diosa dakaʼ oʼto̱i̱kaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Nogbayok nogbayok ayaʼ huabayokda Jerusalényo̱ Jesúsen huaoj hua̱ye̱ere Jerusalényo̱ onʼhuaʼikaʼuyate. Judío huakkurueri isiʼpo mabueyhueʼ e̱e̱ʼ okkahuehueʼ fiestate onʼhuaʼikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Ken Jesús doce huabayok eʼto̱e̱deʼte ayaʼda Jerusalényo̱ onʼhuaʼuyate. María Joséere Jesúsere onʼhuaʼuyate. Konig ken fiestate onʼhuikaʼpo onʼhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ken fiesta eʼpokdeʼte onʼkumejdepo José Jesúsen hua̱ye̱ere nopo̱e̱hueʼ o̱ʼnepo Jesús huahueʼda Jerusalényo̱ o̱ʼe̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Jesús nog aratbutere yatiaket namaʼda onʼnopo̱e̱po nogmeʼnoetida oʼnokhuaʼuyate, huabet eʼta̱hue̱ʼyo̱ kenpaʼti nog aratbutyo Jesústaj onʼukpo ");
INSERT INTO amrNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","huahuayhueʼ o̱ʼnepo Jerusalényo̱ onteʼti onʼkumeʼuyate. Aʼukyaʼpo onʼkumeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ken, bapaʼ huameʼnoe onʼukdepo onʼhuahuayʼuy, Jesús Diosen jakyo o̱ʼe̱po Diosbaʼ huamanmadikaʼeriere oʼhuadpo oʼbatiaʼpakpo kenomeyere oʼbatiaʼpakpo. ");
INSERT INTO amrNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ken ayaʼda Jesústaj onʼpe̱e̱depo ʼuruaʼda oʼbatiaʼpak onʼnopo̱e̱po kenpihuay huakkaʼ Jesús oʼnopo̱e̱ Jesústaj huape̱e̱ʼeria onʼnopo̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Keʼnen hua̱ye̱ Joséere onʼtiahuaydepo onʼmepukeʼuyate. —‍¿Menaʼpo konig i̱ʼe̱ oroʼtaj? Ontaj huakkaʼ oʼmeʼpukeʼpo oʼukne. O̱ʼnen huaoj doere oʼukne. —‍Jesúsen hua̱ye̱a̱ Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","—‍¿Menaʼpo doʼtaj oʼduk? Kenda doʼhued Apag Dios oʼpaknok kaʼdik i̱jje̱y. ¿Menpaʼ kenda nopo̱e̱hueʼ moʼe̱? —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","José hua̱ye̱ere kenda Jesúsa oʼmanaʼ nopounkahueʼ o̱ʼnuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ken Nazaretyo onʼkumejpo onteʼti Josétaj hua̱ye̱taere Jesúsa oʼnigpe̱i̱kaʼuyate. Kenda Jesús oʼkaʼdepo Jerusalényo̱ María okkahuehueʼ o̱ʼe̱po huanopoyaʼ oʼnopoeonhuahuaʼikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ken Jesús oʼkerekpo kenpaʼti nogi̱ti nogi̱ti oʼnopounhuahuaʼuyate. Jesús ʼuruaʼda oʼkikaʼ. Kenda Dios aratbutakon onʼnopo̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Huakkaʼ huabayok eʼpokdeʼte Tiberio Roma hua̱e̱ʼeria gobierno Huairi o̱ʼu̱yate. Keʼna quince huabayok oʼmanaʼdeʼikaʼuyate. Kenokti Poncio Pilato Judeayo gobierno huairi o̱ʼu̱yate. Herodes Galilea huadaribayo Romayo hua̱e̱ʼeria gobierno huairi o̱ʼu̱yate. Kenokaʼti Herodesen huamaʼbuy Felipe Iturea huadaribayo gobierno huairi o̱ʼe̱po kenpaʼti Felipe Traconite huadaribayo huairi o̱ʼu̱yate. Kenokaʼti Lisanias Abilinia huadaribayo gobierno huairi o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Kenokaʼti Anás Caifásere konig huakkuru sacerdote huairi o̱ʼnuyate. Diosen jakyo o̱gkikaʼuyate. Kenokti Diosa Juantaj onaʼpo Diosen huaʼa ijmanbatiaʼpakapoy Diosa Juantaj oʼnopo̱e̱a̱ʼuyate. Juan Zacaríasensiʼpo o̱ʼe̱po aratbut huakkaʼ ehueʼ e̱e̱ʼyo̱ o̱ʼi̱kameʼte. ");
INSERT INTO amrNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jordánhue̱te nogyon nogyon oʼhuaʼepo aratbuttaj oʼmanbatiaʼpakpo, —‍Dios opudomeyen dakhueaʼ eʼkaʼ kabakkahueʼpo yanʼnopoʼkoreaʼpo bautiza ya̱gkaʼ. —‍Aratbuttaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Konig Isaías Diosen huamanbatiaʼpakeri oʼtimadoyaʼuyate. Konigti Juana oʼkaʼuyate. Isaías oʼtimadoyaʼpo, Ke̱yo̱ aratbut ehueʼ e̱ʼi̱kaʼyo huabokerek ʼuttaʼda eʼmanaʼte aʼpe̱e̱yaʼpo aratbut onʼbahuahuaʼapo. “Dios Huairien dag kente huahuaeʼ dakaʼ dag yanʼnigkaʼ. Butukda yanʼnigkaʼ. Konig yanʼmanopoʼkoreaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Huatotaʼpo yanokbuk. Konig oteʼ yanoktibutukaʼ. Sondoda dag e̱ʼe̱o̱k yanoktibutukaʼ. Kente ekkotatukaʼ dag yanʼtinokdejpakaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kenpaʼti konig Dios aratbuttaj oʼmanopoʼyareaʼ ayaʼyaʼda huadariyaʼ ayaʼada aratbut onʼtiahuayapo.” Kenda Isaías oʼmadoyaʼuyate. Aʼnennada oʼmadoyaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ken huakkaʼada Juantaj onʼhuahuaʼuyate. Juantaj bautiza megkeʼpo onʼhuahuaʼuyate. —‍Konig dakhueʼda bihui oʼmagkikaʼ. Konigti opudomey dakhueaʼda boʼkikaʼpo kenpaʼti opudomey namaʼda moʼnopo̱i̱kaʼpo. Nopoʼkoreahueʼtada bautiza e̱gkaʼte Diosa dakhueaʼda castiga e̱gkaʼte yoktitikonapoy. Kenda namaʼda moʼnopo̱e̱ne. ");
INSERT INTO amrNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ʼUruaʼda ya̱gʼkikatiʼ. Daknopoʼda ya̱gʼkikaʼpo Diostaj moʼnopoʼkoreaʼuynok ayaʼada tiahuaydik moʼe̱a̱pone. “Abraham oroʼomeyen adhueaʼpaneʼ o̱ʼe̱po Diostaj meʼpukhueʼdik o̱ʼe̱y.” Nopo̱e̱hueʼ yaneʼ. Diosa eʼpaknayo huid in oʼbahuednigtaj Abrahamen huayayo magkaʼdik o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nopoʼkoreahueʼ e̱e̱ʼnayo i̱da Diosa castiga mogkaʼapone. In konig o̱ʼe̱. Konig taʼbayo huada huato̱e̱ʼeri o̱ʼe̱po. Huada ʼuruaʼda onhuadhueʼ o̱ʼeonhuahuikaʼnok dakaʼda oʼtiahuayonhuahuaʼdepo huateya oʼtaʼtegpo taʼakyo oʼmahui̱gikaʼ. —‍Juana oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","—‍¿Diosa castiga kahueʼ moʼe̱ʼpo oroʼ kate kaʼdik o̱ʼe̱? —‍Juantaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","—‍Bottaʼ opiot e̱ʼta̱e̱ʼnayo kentaj opiotbayoʼ e̱ʼhua̱e̱ʼtaj nogtida yanʼbayokikaʼ. O̱ʼna aypo eʼto̱e̱ʼnayo kentaj aypobayoʼ e̱ʼhua̱e̱ʼtaj yanʼbayokikatiʼ. —‍Juana oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Juana bautiza megkeʼpo sueʼda gobierno huakupe huabaeʼeria Juantaj onʼhuahuaʼdepo engaña eʼkikada huakkaʼda huakupe eʼbakikada, —‍¿Oroʼ kate kaʼdik o̱ʼe̱, huamanmadikaʼeri? —‍Juantaj oʼnonaʼpo, ");
INSERT INTO amrNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","—‍Kenyoʼda ken huakupe Roma gobiernoa oʼmanaʼuynig kenyoʼda yanʼbaeʼ. Nogda baehueʼ yaneʼ. —‍Gobierno huakupe huabaeʼeritaj Juana oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","—‍¿Oroʼ kate kaʼdik o̱ʼe̱? —‍Roma sorotataj Juantaj oʼnonaʼuy. —‍Beʼtapiʼ katepiʼ bakkayhueʼ yanikaʼ. Katepiʼ aʼbakkayyaʼpo huiyokaʼda manahueʼ yanikaʼ. Namaʼda yanʼbahuaaʼpo bakkayhueʼ yaneʼ. Kenpaʼti ken huakupe gobierno boʼyokikaʼne konig sorotatayo e̱e̱ʼte huakupe boʼyokikaʼne. Kenpaʼda dakhuapa meʼte̱ne, nogi̱ti pakhueʼ a̱ʼe̱i̱ʼ yanʼnopo̱i̱kaʼ. —‍Ken Juana sorotatataj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Diosa Cristotaj oʼtaʼmonapo kenda huakkaʼada aratbut onʼnopo̱e̱po Juante o̱gkupopakdepo Cristotaj huakkaʼ oʼnonmabopo, Juantaj Cristo o̱ʼe̱piʼ onʼtinopo̱e̱po. ");
INSERT INTO amrNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","—‍Cristo ehueʼ i̱jje̱y. Donayo hue̱ʼe̱ya̱ bautiza ijmagkikay. Cristonayo oʼtiakde opudomeytaj bautiza oʼmagkaʼapo. Diosen Noki̱re̱ga̱ bautiza oʼmagkaʼapo kenpaʼti taʼak eʼbakpakyaʼ bautiza oʼmagkaʼapo. Keʼna huakhuairi o̱ʼe̱po mataʼmonaʼdik o̱ʼe̱a̱po. Donayo huairi ehueʼda i̱jje̱y. Cristo ʼuruaʼda o̱ʼe̱po Diostaj huadaknada o̱ʼe̱. Donayo suhueʼda huadak i̱jje̱y. ");
INSERT INTO amrNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Cristo oʼtiakdepo konig aroz huatuga̱ʼeri o̱ʼe̱po aroz oʼtugdepo oktipoaʼ. Ken oktipoaʼdepo jakyo oʼkudapo. Oʼkuda̱ʼdepo huakusiʼhue taʼakyo oʼhui̱gonhuahuikaʼpo okbithueʼ o̱ʼe̱a̱po. Ken huadak huakid konig Cristotaj huaknopo̱e̱ʼeri o̱ʼne. Onʼnigpe̱i̱kaʼ. Huaknopo̱e̱ʼeritaj oʼbakuda̱ʼapo, Diosen jakyo oʼbakuda̱ʼapo. Huakusiʼhue konig aratbut Diostaj nigpe̱e̱hueʼ o̱ʼnikaʼ. Konig castiga eʼmagkaʼ taʼakyo oʼmaenapo. —‍Juana ayaʼtada oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ken konig nogda nogda Juana oʼmanaʼonhuahuaʼpo judío aratbuttaj huadak huaʼa oʼmanbatiaʼpakpo Jesucristotaj ken Juana oʼmanbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Herodes Roma hua̱e̱ʼeri gobierno huairi o̱ʼe̱po Galilea huadaribayo gobierno huairi o̱ʼe̱po, “Dakhueaʼ oʼkaʼ.” Juana oʼhuaaʼdeʼuy. Herodes huamaʼbuyen hua̱to̱e̱ oʼto̱e̱po kenpaʼti nogda nogda dakhueaʼ oʼkameʼnok, “Dakhueaʼ oʼkaʼ.” Juana oʼhuaaʼdeʼuy. ");
INSERT INTO amrNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Juana kenpaʼ eʼhuaaʼdeʼte Herodes nigpe̱e̱hueʼ o̱ʼe̱depo nogda dakhueaʼ oʼkaʼpo huabakuda̱ʼ jakyo Juantaj oʼkuda̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Ken ʼikken Juantaj kuda̱hued Juan bautiza oʼmagkaʼpo, huakkaʼda aratbuttaj bautiza oʼmagkaʼdepo Jesústakon bautiza o̱gkaʼuyate. Ken Jesústaj bautiza e̱gkadeʼte Jesúsa Diostaj eʼtionaʼpakdeʼte konig kurudya̱ʼ akbogpe okhuikeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Diosen Noki̱re̱g oʼhuahuarakpo konig tukkuʼ oʼhuarakpo Jesústaj oʼtikotpo, —‍On doʼhued Huasiʼpo o̱ʼta̱e̱ne. Huadiʼda o̱ʼta̱e̱ne. Ontaj durugda oʼto̱e̱ne. —‍Kurudya̱ʼ Diosa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús konig treinta huabayok o̱ʼe̱po huaboaʼda judío aratbuttaj oʼmanmadikaʼonhuahuaʼpo. Joséensiʼpo o̱ʼe̱ aratbut onʼnopo̱i̱kaʼpiʼ. José Elíensiʼpo o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí Matatensiʼpo o̱ʼu̱yate. Matat Levíensiʼpo o̱ʼu̱yate. Leví Melquiensiʼpo o̱ʼu̱yate. Melqui Janaensiʼpo o̱ʼu̱yate. Jana Joséensiʼpo o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José Matatíasensiʼpo o̱ʼu̱yate. Matatías Amósensiʼpo o̱ʼu̱yate. Amós Nahumensiʼpo o̱ʼu̱yate. Nahum Esliensiʼpo o̱ʼu̱yate. Esli Nagaiensiʼpo o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai Maatensiʼpo o̱ʼu̱yate. Maat Matatíasensiʼpo o̱ʼu̱yate. Matatías Semeiensiʼpo o̱ʼu̱yate. Semei Joséensiʼpo o̱ʼu̱yate. José Judáensiʼpo o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá Joanaensiʼpo o̱ʼu̱yate. Joana Resaensiʼpo o̱ʼu̱yate. Resa Zorobabelensiʼpo o̱ʼu̱yate. Zorobabel Salatielensiʼpo o̱ʼu̱yate. Salatiel Neriensiʼpo o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri Melquiensiʼpo o̱ʼu̱yate. Melqui Adiensiʼpo o̱ʼu̱yate. Adi Cosamensiʼpo o̱ʼu̱yate. Cosam Elmodamensiʼpo o̱ʼu̱yate. Elmodam Erensiʼpo o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er Josuéensiʼpo o̱ʼu̱yate. Josué Eliezerensiʼpo o̱ʼu̱yate. Eliezer Jorimensiʼpo o̱ʼu̱yate. Jorim Matatensiʼpo o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat Levíensiʼpo o̱ʼu̱yate. Leví Simeónensiʼpo o̱ʼu̱yate. Simeón Judáensiʼpo o̱ʼu̱yate. Judá Joséensiʼpo o̱ʼu̱yate. José Jonánensiʼpo o̱ʼu̱yate. Jonán Eliaquimensiʼpo o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim Meleaensiʼpo o̱ʼu̱yate. Melea Mainánensiʼpo o̱ʼu̱yate. Mainán Matataensiʼpo o̱ʼu̱yate. Matata Natánensiʼpo o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán Davidensiʼpo o̱ʼu̱yate. David Isaíensiʼpo o̱ʼu̱yate. Isaí Obedensiʼpo o̱ʼu̱yate. Obed Boozensiʼpo o̱ʼu̱yate. Booz Salmónensiʼpo o̱ʼu̱yate. Salmón Naasónensiʼpo o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naasón Aminadabensiʼpo o̱ʼu̱yate. Aminadab Aramensiʼpo o̱ʼu̱yate. Aram Esromensiʼpo o̱ʼu̱yate. Esrom Faresensiʼpo o̱ʼu̱yate. Fares Judáensiʼpo o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá Jacobensiʼpo o̱ʼu̱yate. Jacob Isaacensiʼpo o̱ʼu̱yate. Isaac Abrahamensiʼpo o̱ʼu̱yate. Abraham Taréensiʼpo o̱ʼu̱yate. Taré Nacorensiʼpo o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor Serugensiʼpo o̱ʼu̱yate. Serug Ragauensiʼpo o̱ʼu̱yate. Ragau Pelegensiʼpo o̱ʼu̱yate. Peleg Heberensiʼpo o̱ʼu̱yate. Heber Salaensiʼpo o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala Cainánensiʼpo o̱ʼu̱yate. Cainán Arfaxadensiʼpo o̱ʼu̱yate. Arfaxad Semensiʼpo o̱ʼu̱yate. Sem Noéensiʼpo o̱ʼu̱yate. Noé Lamecensiʼpo o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lemec Matusalénensiʼpo o̱ʼu̱yate. Matusalén Enocensiʼpo o̱ʼu̱yate. Enoc Jaredensiʼpo o̱ʼu̱yate. Jared Mahalaleelensiʼpo o̱ʼu̱yate. Mahalaleel Cainánensiʼpo o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán Enósensiʼpo o̱ʼu̱yate. Enós Setensiʼpo o̱ʼu̱yate. Set Adánensiʼpo o̱ʼu̱yate. Adán Diosensiʼpo o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Diosen Noki̱re̱g oʼnopoʼto̱e̱nok Jesúsa Diostaj oʼnigpe̱i̱kaʼpo Jordánhue̱ya̱ʼ oʼkumeʼuyate. Diosen Noki̱re̱ga̱ aratbut ehueʼ e̱ʼi̱kaʼyo Jesústaj oʼtohuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ke̱yo̱da cuarenta huameʼnoe o̱ʼeonhuahuikaʼpo. Ke̱yo̱da totoʼa Jesústaj oʼdikdikuyate dakhueaʼ kakeʼpo. Cuarenta huameʼnoe bapehueʼ o̱ʼunhuaʼpo kenpaʼti cuarentaaʼ sikyo bapehueʼ o̱ʼeonhuahuaʼdepo kenokaʼ aypotaʼ o̱ʼe̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","—‍On buttida Diosen Huasiʼpo e̱e̱ʼnayo in huidtaj aypo yaean. —‍Jesústaj totoʼa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","—‍Aypoayoʼda noikahueʼdik o̱ʼne aratbut. Aypo onʼbapeʼpo ayaʼda Apagbaʼ huadik nigpe̱i̱kaʼdik o̱ʼne. Apagbaʼa kenpaʼ oaʼ. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kenokaʼ totoʼa oʼtohuaʼpo Jesústaj oʼtohuaʼpo kutayoda oteʼyo oʼtobehuikpo. Ken ijhuiti ehueʼ nogyo̱ nogyo̱da adteda ayaʼ huadaribayo gobierno huairi Jesústaj oʼbatiahuayʼeaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","—‍Ayaʼda ʼuruaʼda huadaribayo kenpaʼti huadariyo huairi hua̱e̱ʼ oʼbayokapone konige̱po doʼhuedda meʼtamaenok. Betapiʼ eʼyoktaʼ ijpakpo yokdik i̱jje̱y. Doʼtaj huikudate eʼtihuadnayo “ʼUruda huairi meʼta̱e̱ne.” Doʼtaj enaʼnayo ayaʼda iʼtiahuaynig oʼbayokapone. —‍Totoʼa Jesústaj namaʼda onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","—‍Bekhuaʼ, totoʼ, konige̱po “Dios Huairitayoʼda huikudate yanighuadpo yanʼnigpe̱e̱ʼ.” Apagbaʼa kenpaʼ oaʼ. —‍Kenpaʼ Jesúsa totoʼtaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Kenokaʼ Jerusalényo̱ Diosen jakyo oʼtohuaʼpo totoʼa oʼtohuaʼpo Diosen huaboroʼ jak jakkutagpiyo oʼtobehuikuyate. —‍On Diosen Huasiʼpo e̱e̱ʼnayo barakte yakudaj. ");
INSERT INTO amrNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","11","Apagbaʼ oaʼpo: Kaʼnonokbaʼhuade̱ʼpo eʼkudajte Diosa keʼnen huataʼmoneritaj oʼmataʼmonaʼaponok huidbate kothueʼdik i̱ʼe̱a̱pone. Huabaʼa kutate monokbaʼhuada̱pone. Apagbaʼ kenpaʼ oʼmadoyaʼuyate. —‍Totoʼa namaʼda onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","—‍“Dios Huairi namaʼda kakeʼpo namaʼda ahueʼ ya̱e̱ʼ.” Apagbaʼ kenpaʼ oʼmadoyaʼuyate. —‍Jesúsa totoʼtaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Jesús namaʼda kakeʼpo totoʼ huairia nogda nogda da onaʼdepo nogda namaʼda huanaʼ nopo̱e̱hueʼ o̱ʼe̱depo oʼbatikpo okhuaʼuyate. Nogokpiʼ da anayaʼpo yakumeapetdapiʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Galilea huadaribayo Jesús oʼkumeʼuyate. Diosen Noki̱re̱ga̱ oʼnopoʼto̱e̱nok Jesús teyda o̱ʼe̱ʼuyate. ʼUruaʼda oʼmanmadikaʼnok Jesústaj onʼbatiaʼpaknok huabada adtaʼda nogya̱ʼ nogya̱ʼ onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Judío aratbuten hua̱i̱takeʼ jakyaʼ oʼmanmadikaʼpo nogda nogda nogyo̱ nogyo̱ judío aratbuten hua̱i̱takeʼ jakyaʼ oʼmanmadikaʼikaʼuyate. “ʼUruaʼda oʼmanmadikaʼ Jesúsa.” Ayaʼada onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ken, Nazaret huakkaʼ jakyo Jesús oʼhuaʼuyate. Ke̱ya̱ʼ Jesús oʼkerekuyate. Okmapi̱e̱ʼahuaddik huameʼnoete judío aratbuten hua̱i̱takeʼ jakyo oʼkudʼuyate. Kenda oʼkikaʼpo oʼkudʼuyate. Oʼkudondepo Apagbaʼ oʼtiahuaypo Apagbaʼ abonaʼpakyaʼpo oʼboʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Apagbaʼ ken Isaías huamanbatiaʼpakeria oʼmanigmadoyaʼuy. Kenda berobaʼ Jesústaj onʼyokuyate. Oʼukpo in oʼhuahuaydepo, oʼmonaʼpakuyate: ");
INSERT INTO amrNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Dios Huairien Noki̱re̱g meʼnopoʼto̱e̱ne konige̱po paiʼda aratbuttaj huadak huaʼa aʼmanbatiaʼpakyaʼpo bektieʼeaʼmeʼne. Paiʼda hua̱e̱ʼeri aratbuttaj kamadurugpakeʼpo Dios Huairia meʼtaʼmonaʼuyne. Huairien huanabaʼ kenpaʼda bahuaʼdik kaʼneʼpo kamaneʼpo Dios Huairia meʼtaʼmonaʼuyne. Ekpobigtaj kabakpoyareʼpo Dios Huairia meʼtaʼmonaʼuyne. Kenomeytaj dakhueaʼda onʼmagkikaʼnok kabaktohueʼpo Dios Huairia meʼtaʼmonaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","In huadak huabayokte Dios Huairia oʼmatinepahuiʼpo kamabatiaʼpakeʼpo Diosa meʼtaʼmonaʼuyne. Ken Jesúsa Isaíasbaʼ oʼmonaʼpakpo oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ken Jesús Apagbaʼ oʼbokhuikdepo judío aratbuten hua̱i̱takeʼ jak huato̱e̱ʼeritaj oʼbaʼyokdepo oʼhuaduyate. Ken ayaʼ aratbut hua̱i̱takeʼ jakyoda o̱ʼnepo Jesústaj onʼtiahuayaʼnok, ");
INSERT INTO amrNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","—‍Ken Apagbaʼ huaboaʼda moʼpe̱e̱dene oy konig Isaías oaʼuyate oy kenda ijkay. Oy ijkaʼnig boʼtiahuayne. —‍Ken Jesúsa huaboaʼda oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jesústaj “kenpihuay,” onʼbatiaʼpakpo “huadakda oaʼ,” “buttida oaʼ,” “ʼuruaʼda huaʼa oʼbatiaʼpak,” ayaʼada onʼbatiaʼpakuyate. —‍In Joséensiʼpo o̱ʼe̱nigʼa. —‍Onʼbatiaʼpakuyate. Nopo̱e̱hueʼ o̱ʼnepo onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","—‍Konig aratbut oaʼikaʼ, “Huamadakkaʼeri i̱ʼe̱po huataʼda yayareaʼ.” Doʼtaj enaʼtaʼ boʼpakne ijnopo̱e̱y, “Konig Capernaum huakkaʼ jakyo oʼbayareameʼte oʼpe̱e̱ i̱yo̱kon o̱ʼnen huadaribayaʼ konigti yakaʼ.” Oʼnonaʼapone. —‍Jesúsa Nazaret aratbuttaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Jesúsa nogi̱ti oʼmanbatiaʼpakpo, —‍Beʼapiʼ Diosen huamanbatiaʼpakeria nogbayo eʼhuaʼnayo Diosen huamanbatiaʼpakeri o̱ʼe̱ aratbuta oʼnoknopo̱e̱a̱po onʼnigpe̱e̱a̱po. Keʼnen huakkaʼ jakyaʼ yakerekyaʼda kentaj Diosen huamanbatiaʼpakeritaj aratbuta pakhueʼ o̱ʼnikaʼapo. Buttida ijjay. ");
INSERT INTO amrNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Aʼnennada Elíaskudak o̱ʼi̱kaʼuyate. Elíaskudak Diosen huamanbatiaʼpakeri o̱ʼu̱yate. Ke̱yo̱ Israel aratbut o̱ʼnikaʼ bapaʼ huabayok nogi̱ti nog seis puug huiʼhueʼ o̱ʼu̱yate. Aypo ehueʼda o̱ʼu̱yate. Israel aratbut aypo to̱e̱hueʼ o̱ʼnuyate. Kenokaʼ huakkaʼada Israel ʼayhua e̱e̱ʼtada ");
INSERT INTO amrNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Israel aratbut ʼayhuataj Elíaskudaktaj nigtaʼmonahueʼ o̱ʼu̱yate. Israel aratbuta oknopo̱e̱hueʼda o̱ʼnenok Israel ʼayhuataj aypo kabayokikeʼpo nigtaʼmonahueʼ o̱ʼu̱yate. Dios nog aratbut ʼayhuataj oʼnigtaʼmonaʼuyate. Ken Sarepta jak ʼayhuataj oʼtaʼmonaʼuyate. Serepta jak meyo̱hueʼda Sidón huakkaʼ jak o̱ʼe̱. Sarepta jak ʼayhua nog aratbutda o̱ʼu̱yate. Nog aratbut ʼayhua aypo kabayokikeʼpo oʼnigtaʼmonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kenpaʼti Israel aratbut huadaribayo hua̱e̱ʼeri Eliseokudak o̱ʼu̱yate. Eliseo Diosen huamanbatiaʼpakeri o̱ʼu̱yate. Kenokaʼ huakkaʼ Israel aratbut keʼpoda onʼmaso̱ʼsetʼuyate. Eʼso̱ʼset Israel aratbuttaj bayareahueʼ oʼmauyate Diosa. Nogtatipiʼ bayareahueʼ Israeltanayo e̱ʼe̱a̱da Naamantayoʼda oʼyareaʼuyate. Naaman nog aratbutda Siria huadaribayo hua̱e̱ʼeri aratbut o̱ʼu̱yate. —‍Jesúsa hua̱ʼenbayaʼda Nazaretyo oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Judío aratbuten hua̱i̱takeʼ jakyaʼ ayaʼada Israel aratbut o̱ʼnepo onʼpe̱e̱depo diga̱ʼda Jesústaj onʼhuadiayʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Onʼbopo huakkaʼ jakyaʼ onʼto̱o̱ro̱kpo Jesústaj onʼto̱o̱ro̱kpo huakupakunojpoyo onʼtohuaʼpo ken huakupate kenomeyen huakkaʼ jak o̱ʼe̱ʼuy. Ken huakupakunojpoyaʼ andayaʼyo onʼtohuaʼuynigʼa. ");
INSERT INTO amrNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Jesúsa huakupakunojpote huakkaʼ aratbut e̱gkupopakte oʼbakpokonpo oʼbakhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ken Capernaum huakkaʼ jakyo Jesúsa oʼhuaʼuyate. Capernaum Galilea huadaribayo o̱ʼe̱. Capernaumyo Jesús o̱ʼe̱po aratbuttaj oʼmanmadikaʼpo judío aratbuten hua̱i̱takeʼ jakyaʼ okmapi̱e̱ʼahuaddik huameʼnoete oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","“Kenpihuay ʼuruaʼda oʼmanmadikaʼ, konig huairitoneʼ oʼmanmadikaʼ.” Aratbuta onʼtinopo̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Hua̱i̱takeʼ jakyo nogbokerektaʼtida dakhueʼ noki̱re̱ga̱ oʼnopoʼto̱e̱nok ʼuttaʼda oʼokoypo, ");
INSERT INTO amrNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—‍Oroʼomeytaj o̱gkahueʼ moeʼ. ¿Menaʼpo oroʼomeytaj o̱gkaʼ, Jesús Nazaret hua̱e̱ʼeri? ¿Oroʼtaj kenpaʼda aʼenya̱ʼpo menpaʼ oʼhuatiak? Ontaj o̱ke̱a̱ʼne. Diosenyoʼda i̱ʼe̱ne. —‍Dakhueʼ noki̱re̱ga̱ ʼuttaʼda oʼokoyʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","—‍Aʼpakhueʼ ya̱e̱ʼ. Huabokerekyaʼ yakhuaʼ, noki̱re̱g. —‍Jesúsa onaʼuyate. Ken huabokerektaj dakhueʼ noki̱re̱ga̱ sorokte oʼenʼuyate. Ayaʼ okpoda sorokte oʼenʼuyate. Oʼendepo oko̱ro̱konʼuyate. Huabokerektaj dakhueaʼ o̱gkadhueʼada dakhueʼ noki̱re̱ga̱ okhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ayaʼada onʼtiahuaypo onʼmepukeʼuyate. Huayahuaya onʼmanbatiaʼpakpo, —‍ʼUruaʼda huadik oaʼ. Konig huairitoneʼ onaʼpo i̱ghuaʼda oʼmanaʼnok nigpe̱e̱dik o̱ʼnepo oʼmako̱ro̱kaʼ, dakhueʼ noki̱re̱g oʼmako̱ro̱kaʼ. —‍Huayahuaya onʼmanbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ken huadaribayo nogyon nogyon Jesústaj onʼmanbatiaʼpakonhuahuikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ken Jesús oʼo̱ro̱konpo judío aratbuten hua̱i̱takeʼ jakyaʼ oʼo̱ro̱kondepo Simónen jakyo oʼkudonʼuyate. Ke̱yo̱ Simónen huasuʼ huakkaʼda oʼdigpaknok, “Oroʼen huasuʼtaj yayareaʼ.” Jesústaj oʼnonaʼnok ");
INSERT INTO amrNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","enpahuedte Jesúsa oʼtiboatoʼpo oʼyareaʼnok keʼna oʼtaʼhuitatoʼdepo i̱da oʼbodpo oʼmanigmanhuada̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nogyo̱ nogyo̱ huakkaʼ aratbut o̱ʼnepo, dakhueʼda o̱ʼnepo, noga̱ noga̱ dakhueʼda o̱ʼnepo, onʼdigpakpiʼ, ekpobigpiʼ, nogda nogda dakhueʼda o̱ʼneʼuyate. Ken eʼsikdeʼte kenomeyen huabeta onʼbatotiakpo Jesúste onʼbatotiakuyate. Jesús nogtati nogtatiaʼ oʼbatibataʼtepo oʼbayareaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nogomey kenpaʼti dakhueʼda e̱ʼneʼte Jesúsa totoʼtaj oʼmakenaʼuyate. Totoʼa oʼmako̱ro̱kpo ʼuttaʼda oʼdokoypo, —‍Diosen Huasiʼpo i̱ʼe̱ne. —‍Totoʼa onʼmanaʼuyate. Jesús Diosen Cristo Diosa oʼtaʼmonaʼdeʼuy totoʼa oʼnoknopo̱e̱nok, —‍Kejeʼ, ahueʼ yaneʼ. —‍Jesúsanayo totoʼtaj oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Eʼmunyakte Jesúsa huakkaʼ jakyaʼ oʼo̱ro̱konpo aratbut ehueʼ e̱e̱ʼyo̱ oʼhuaʼuyate. Aratbuta oʼdukpo Jesústaj onʼhuahuayʼuyate. —‍Oroʼomeytaj okhuahueʼ moeʼ. —‍Jesústaj oʼnonaʼnigʼa, ");
INSERT INTO amrNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","—‍Huadak huaʼa konig aratbut Dios Huairitaj oknopo̱i̱kaʼdik o̱ʼneapo. Ken nog huakkaʼ jakyo nogyo̱ nogyo̱ huadak huaʼa manbatiaʼpakdik ka̱e̱ʼpo konige̱po Diosa meʼtaʼmonaʼuyne. —‍Jesúsa aratbuttaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ken nogda nogda judío aratbuten hua̱i̱takeʼ jakyo Galilea huadaribayo Jesúsa huadak huaʼa oʼmanbatiaʼpakikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nogok Genesaret e̱ʼpo̱g aktaʼbogpete Jesús oʼboʼuyate. Diosen huaʼa aʼpe̱e̱yaʼpo huakkaʼnada aratbut onʼbatiakpo oʼnondaʼepo Diosen huaʼa eʼpe̱e̱taʼ onʼpakpo Jesústaj oʼnondaʼeʼuy. ");
INSERT INTO amrNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Bottaʼ kusiʼpetoneʼ meyo̱hueʼda aktaʼbogpete eʼbette Jesúsa oʼtiahuaypo sigpiʼ huadhueʼ o̱ʼnuy. Huakjeneʼeriomey kusiʼpetaj oʼnokhuaʼdepo huakjeneʼ onʼkoyoaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nogtida kusiʼpetoneʼyo Jesús oʼkudpo oʼboʼuyate, Simónen kusiʼpeyo oʼbopo. —‍Sueʼpiʼ e̱ʼpo̱gnopoʼte beʼtohuatuʼ, Simón. —‍Jesúsa Simóntaj onaʼuyate. Ke̱yo̱ kusiʼpeyo oʼhuaddepo huaboaʼda huakkaʼnada aratbuttaj oʼmanmadikaʼuyate. Kusiʼpeyaʼda oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Oʼmanmadikaʼbatikdepo, —‍E̱ʼpo̱g jodyoda yanhuaʼpo biigtaj yanokjeneʼ. —‍Simóntaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","—‍Ayaʼ sikyoda oroʼomey okjeneʼbednigʼa biig ehueʼda o̱ʼe̱, Huamanmadikaʼeri. O̱ʼna onaʼnok yokjeneʼapoy. —‍Simóna Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ken oʼnokjeneʼdepo huakkaʼnada biig onʼkuda̱ʼdenok enʼtotokte huakjeneʼ huaboaʼda okputukonpo nogyen nogyen okputukonpo. ");
INSERT INTO amrNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Nog huakjeneʼeri nog kusiʼpetaj Simóna huabaʼa baʼbaʼ oʼmanenok. Ken onʼtiakdepo kenomeyen bottaʼ kusiʼpeyo biig onʼbahueda̱ʼpo huakkaʼnada o̱ʼe̱po kusiʼpe oʼtaʼkotayʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Kenda Simón Pedro oʼtiahuaypo Jesúsen huaʼite huikudate oʼtihuadpo, —‍Bekhuaʼ, Huairi, donayo dakhueaʼ huakaʼeri i̱jje̱y. —‍Jesústaj Simóna onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Biig huakkaʼda o̱ʼe̱nok Simón omepukeʼpo kenpaʼti nogomey Simónere huakkaʼda onʼmepukeʼuy. ");
INSERT INTO amrNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Kenpaʼti Jacobo Juanere Zebedeoensiʼpo Simónere huakjeneʼeri o̱ʼnuyate. Kenomeykon onʼmepukeʼuyate. —‍Mepuʼkehueʼ ya̱e̱ʼ. Oy huaboaʼda doʼtaj kanoknopo̱e̱ʼpo aratbuttaj iʼbaeʼapo. —‍Jesúsa Simóntaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ken kusiʼpe onʼbetandepo huakjeneʼeria ayaʼda onʼmaenanpo kenpaʼda onʼmaenanpo Jesústaj aʼnigpe̱i̱kayaʼpo onʼtahuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ke̱yo̱ huakkaʼ jakyo Jesús o̱ʼe̱denok huabokereka oʼhuatiakʼuyate. Keʼna keʼpoda oʼso̱ʼseta̱ʼ Jesústaj oʼtiahuaydepo huikudate oʼhuadpo sorokyo oʼkutaʼboyʼuyate. (Ken konig gobierno huairitaj o̱gkikaʼuyate.) —‍O̱ʼna eʼpaknayo beyareaʼ, Huairi. —‍Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesúsa oʼtibataʼtepo —‍Eʼyareaʼtaʼ ijpaki, “oʼyareayʼ.” —‍Jesúsa onaʼuyate. Enaʼte i̱dada oʼyarudʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","—‍“Jesúsa beʼyareaʼne,” mantiaʼpakhueʼ ya̱e̱ʼ. Sacerdote Diostaj ʼuhua huanigbatiarakerite sacerdotete yahuatiʼ. Iʼyaredene betiahuayyeʼ. Aʼyareyaʼpo konig Moisésa oʼmanaʼuyate konig yayoktiʼ. Sacerdote ʼuhua Diostaj kanigarakeʼpo ʼuhuapiʼ yayoktiʼ. Ken konig iʼkaʼpo iʼyaredepo huadak i̱ʼe̱nok aratbut tiahuaydik o̱ʼneapo. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ʼUruaʼda Jesúsa oʼbayareaʼ huadaknada oʼmanmadikaʼ nogya̱ʼ nogya̱ʼ onʼtipe̱e̱po nogi̱ti nogi̱ti huakkaʼda onʼtipe̱e̱po huakkaʼda aratbut Jesústaj o̱gkupopakpo aʼpe̱e̱yaʼpo kenpaʼti beʼyareʼpo o̱gkupopakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","E̱gkupopaktada Jesúsnayo oʼbakhuaʼikaʼpo ke̱yo̱ aratbut ehueʼ hua̱e̱ʼyo oʼbakhuaʼikaʼuyate. Ke̱yo̱da oʼtionaʼpakonhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nogokaʼ Jesúsa eʼmanmadikaʼte ke̱yo̱ fariseo aratbut onʼbahuadpo fariseo Moisésenbaʼ onʼnigpe̱i̱kaʼuyate. Kenpaʼti Moisésenbaʼ huamanmadikaʼeri onʼbahuadpo Galileayaʼ Judeayaʼ kenpaʼti Jerusalénya̱ʼ onʼhuatiakdeʼuyate. Kabayareʼpo Diosa Jesústaj oʼtihuapokpo ");
INSERT INTO amrNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ken Jesústaj huabokerek asukte enpahuedte onʼnigtotiakpo sueʼada huabokerek onʼnigtotiakuyate. Ken huabokereka asukte eʼketpak onpahuedikaʼuyate. Jakyo eʼkuda̱ʼtaʼ onʼpakpo Jesústaj aʼnighueda̱yaʼpo eʼkuda̱ʼtaʼ onʼpaknigʼa ");
INSERT INTO amrNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","huakkaʼnanada o̱ʼnenok meya̱ʼ kuda̱hueʼ o̱ʼneʼuy. Konige̱po jak kutayo onʼtobehuikpo jakonpid onʼtiokendepo huabokerek asukte enpahuedte oʼnonhuarakaʼpo aratbutnopote Jesústaj huakokpen oʼnonhuarakaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Jesúsanayo oʼyareaʼapo onʼnopo̱e̱ʼuy. Kenda Jesúsa oknokot. Huabokerek eʼketpaktaj, —‍Ayaʼda Diostaj dakhueaʼ iʼkaʼuyatenigʼa doʼa yokkahueay, huabokerek. —‍Jesúsa eʼketpaktaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ken Moisésenbaʼ huamanmadikaʼeri kenpaʼti fariseo aratbut Jesústaj onʼpe̱e̱depo huaboaʼda onʼnopo̱e̱po “Diostaj dakhueaʼ Jesúsa oaʼ. Namaʼda oʼnopo̱e̱po dakhueaʼda Jesúsa oaʼ. Huabokerekanayo okkahueahueʼdik o̱ʼe̱. Diosayoʼda dakhueaʼ eʼkaʼ okkahueaʼdik o̱ʼe̱.” Moisésenbaʼ huamanmadikaʼeri fariseoere huaboaʼda huanopoyaʼda onʼnopo̱e̱po. ");
INSERT INTO amrNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Kenda fariseomey huanopoyaʼda onʼnopo̱e̱nig Jesúsa oʼnopo̱e̱ʼuyate. —‍Menpaʼ ken konig dakhueaʼ onʼtinopo̱e̱. ");
INSERT INTO amrNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Diostaj dakhueaʼ eʼkaʼ huabokereka okkahueahueʼdik o̱ʼe̱. Diosayoʼda dakhueaʼ eʼkaʼ okkahueaʼdik o̱ʼe̱. Huabokerekanayo sigpiʼ yareahueʼdik o̱ʼe̱. Diosayoʼda yareaʼdik o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Do huabokerek i̱jje̱po Diosyaʼ ijtiakuy. Diostaj dakhueaʼ eʼkaʼ bakkahueaʼdik i̱jje̱y opudtaj aʼmanopo̱e̱a̱yaʼpo eʼketpaktaj ijyareapoy. —‍Jesúsa oʼmanaʼpo, —‍Yaboʼ, asuk yaʼudpo, o̱ʼnen jakyo yahuatiʼ. —‍Huabokerek eʼketpaktaj Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Huaboaʼda enaʼte keʼna oʼbodʼuyate. Huamanmadikaʼeri fariseoere enʼtiahuayte oʼbodpo, asuk oʼudpo keʼnen jakyo oʼhuaʼpo Diostaj dakiti oʼtionaʼpakpo Dios ʼuruaʼda megkaʼne oʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ayaʼada onʼtiahuaydepo onʼmepukeʼpo Dios ʼuruaʼda oʼkaʼ onʼbatiaʼpakuyate. Onʼmepuʼkudpo, —‍Oy konig aʼnenda tiahuayhueʼ o̱ʼnikaʼuynig oʼtiahuaydey. Diosa ʼuruaʼda oʼkaʼ oʼtiahuay. —‍Aratbuta onʼtiahuaydepo onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nogokaʼ Jesúsa o̱ʼo̱ro̱kpo Levítaj oʼtiahuayʼuyate. Leví huabokerek o̱ʼe̱po gobiernotaj huakupe oʼtabaeʼikaʼpo gobierno huakupe huatabaeʼ jakyo oʼhuadʼuyate. —‍Diostaj aknopo̱e̱yaʼpo doʼtaj menigpeunhuahuikaʼ. —‍Jesúsa Levítaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ken Leví oʼbodpo ayaʼda kenpaʼda oʼmaenanpo Jesúsere oʼhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nogok Jesústaj huakkaʼda aypo onʼmanigmanhuada̱ʼpo Levíen huanabaʼa onʼnigmanhuada̱ʼuyate. Levíen jakyaʼ onʼnigmanhuada̱ʼuyate. Kutopate Jesúsere Levíere huakkaʼda onʼbahuadpo, gobiernotaj huakupe huatabaeʼeri onʼbahuadpo kenpaʼti nogomey onʼbahuadpo gobierno huakupe huatabaeʼeria engaña o̱gkikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Fariseo aratbut kenpaʼti Moisésenbaʼ huamanmadikaʼeri o̱ʼnepo huaboaʼda onʼbahuaaʼpo Jesúsen huanigpe̱i̱kaʼeritaj onʼbahuaaʼdepo, —‍¿Gobierno huakupe huatabaeʼeriere kenpaʼti dakhueaʼ huakaʼeriere menaʼpo opudomeya̱ moʼbapeʼ? Kenomeyere bapehueʼ yaneʼ. Dakhueaʼda bokaʼne. —‍Onʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","—‍Aratbut huadakda e̱e̱ʼnayo huamadakkaʼeriyo huahueʼ o̱ʼnikaʼ. Dakhueʼda e̱e̱ʼnayo huamadakkaʼeriyo onʼhuaʼikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Konige̱po “Huadak huakaʼeri i̱jje̱y.” Aratbut kenda huataʼ huatinopo̱e̱ʼeritaj “Yanʼnopoʼkoreaʼ. Diostaj yanʼnigpe̱e̱ʼ,” aʼmanayaʼpo Diosyaʼ bahuatiakhueʼ i̱jje̱ʼuy. “Dakhueaʼ huakaʼeri i̱jje̱y.” Aratbut kenda huataʼ huatinopo̱e̱ʼeritaj “Yanʼnopoʼkoreaʼ. Diostaj yanʼnigpe̱e̱ʼ,” aʼmanayaʼpo Diosyaʼ ijbahuatiakuy. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","—‍Juan bautiza huakaʼerien huanigpe̱i̱kaʼeri kenpaʼti fariseoen huanigpe̱i̱kaʼeri Diosa meʼpe̱e̱ʼpo bapehueʼ o̱ʼnunhuaʼpo onʼtionaʼpakikaʼ. ¿Menpaʼ o̱ʼnen huanigpe̱i̱kaʼeriata aypo onʼbapeʼikaʼ? —‍Fariseomey kenpaʼti Moisésenbaʼ huamanmadikaʼeriomeya̱ namaʼda onʼnopo̱e̱po Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","—‍Do konig huabokerek eʼto̱e̱pak konig i̱jje̱nok. Kenokaʼ huabokerek oʼto̱e̱pakapo huakkaʼ huadiʼa aʼdurugpakyaʼpo kenere aʼbapeyaʼpo onʼbahuatiakikaʼ. Kenokaʼ huadiʼ kenere o̱ʼnepo “Bapehueʼ yaʼnunhuaʼ,” manahueʼdik o̱ʼnenigʼa ");
INSERT INTO amrNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","kenokaʼ doʼtaj kadarakeʼpo boktohuaʼdenok huadiʼ aratbuta bapehueʼ o̱ʼnunhuaʼpo onʼtionaʼpakonhuaʼapo. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","—‍Huatoneʼok keʼpoda eʼparaʼte akbetyaʼpo huabo huaoktaj okteghueʼ monikaʼ oroʼomey judío aratbut. Huaboenpa huatoneʼoktaj ekbetnayo onteʼti keʼpoda oʼparaʼapo kenpaʼti huabo huaok dakhueʼda o̱ʼe̱a̱po. Konigti adhueaʼpaneʼa̱ eʼmanmadikaʼ huatoneʼdik onteʼti nigpe̱e̱hueʼdik yaneʼ. Doʼhued huabodikyoʼda eʼmanmadikaʼ nigpe̱e̱dik yanikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Huatoneʼsiʼdak vino hua̱to̱e̱ʼ ayda kenpaʼti kuruga̱da o̱ʼe̱po konige̱po huabo vino sineʼ hue̱biahued onjoyhueʼdik o̱ʼe̱ne. Huatoneʼsiʼdakyo huabo vino onjoyhueʼdik o̱ʼi̱kaʼne. Huatoneʼsiʼdakyo huabo vino enjoynayo oʼhue̱poagpo huasiʼdak onʼtitagonapo. Vino oʼsurukapo kenpaʼti huasiʼdak keʼpoda oʼsuʼhuitonapo, dakhueʼda o̱ʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Huabo vino huabosiʼdakyo onjoydik o̱ʼe̱ne. Konigti adhueaʼpaneʼ o̱gkikaʼ kahueʼdik yanikaʼ. Doʼhued huabo eʼmanmadikayoʼda yanʼnigpe̱i̱kaʼpo, ya̱gʼkikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Beʼapiʼ vinotoneʼ onʼmamayʼikameʼte huabo vino pakhueʼ o̱ʼnepo. “Vinotoneʼyoʼda huadakda o̱ʼe̱.” Oʼdaʼ. Ken konig adhueaʼpaneʼ o̱gkikaʼ beʼapiʼ o̱gkadhuahuikaʼdepo doʼhued huabo eʼmanmadikaʼ eʼkaʼtaʼ pakhueʼ o̱ʼne. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Nogok judío aratbuten okmapi̱e̱ʼahuaddik huameʼnoete Jesús taʼbayo oʼhuaʼepo huanigpe̱i̱kaʼeriere oʼhuaʼeʼuyate. Jesúsen huanigpe̱i̱kaʼeri trigo oʼnogkupayaʼpo huabaʼa onʼtipitaʼpo onʼbapeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ken sueʼda fariseo huamanmadikaʼeri o̱ʼnepo, —‍Kenda Judíoen okmapi̱e̱ʼahuaddik huameʼnoete o̱gkupayahueʼdik o̱ʼe̱nigʼa. ¿Menaʼpo boʼkaʼ? Dakhueaʼda boʼkaʼne. —‍Fariseo huamanmadikaʼeriomey Jesúsen huanigpe̱i̱kaʼeritaj onʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","—‍Apagbaʼte Davidtaj eʼbatiaʼpak moʼbaʼtiahuayʼuyate. David kenere hua̱e̱ʼeri o̱gkusitokuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Diosen carpa jakyo o̱gkudʼuyate. Pan Diostaj onʼnighueda̱ʼikaʼ oʼhuedʼuyate. Sacerdote Diostaj ʼuhua huanigbatiarakeriyoʼda ken pan bapeʼdik o̱ʼnikaʼ. David kenere hua̱e̱ʼeri o̱gkusitokpo ken pan oʼdepo onʼbapeʼuyate. —‍Jesúsa fariseomeytaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Nogdakon Jesúsa oʼmanaʼpo, —‍Do huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne. Judío aratbuten okmapi̱e̱ʼahuaddik huameʼnoete huairi i̱jje̱po katepiʼ ya̱gkaʼ aratbuttaj manaʼdik i̱jje̱y. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Nog okmapi̱e̱ʼahuaddik huameʼnoete judíoen hua̱i̱takeʼ jakyo Jesús oʼkuddepo huaboaʼda oʼmanmadikaʼuyate. Ke̱yo̱ huabokerek huadaʼkopen ebaʼpoʼketpak o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Moisésenbaʼ huamanmadikaʼeri fariseomeyere Jesústaj onʼtiahuayaʼpo okmapi̱e̱ʼahuaddik huameʼnoete menpaʼ oʼyareapopiʼ kenda eʼtiahuaytaʼ onʼpakpo. Okmapi̱e̱ʼahuaddik huameʼnoete eʼyareaʼnayo “Dakhueaʼ oʼkaʼ.” huaaʼdik o̱ʼe̱y onʼnopo̱e̱po. ");
INSERT INTO amrNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kenda fariseomey enʼnopo̱e̱ʼte Jesúsnayo oʼmaknokotuy. Huabokerek ebaʼpoʼketpaktaj —‍Yaboʼ, i̱yo̱ eretnopoyo yaboatoʼ. —‍Jesúsa onaʼuyate. Ken huabokerek oʼbopo eretnopoyo oʼboatoʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","—‍Okmapi̱e̱ʼahuaddik huameʼnoete huadak kaʼdik o̱ʼe̱ne. Dakhueaʼ kahueʼdik o̱ʼe̱ne. Okmapi̱e̱ʼahuaddik huameʼnoete dakhueʼtaj yareaʼdik o̱ʼe̱ne. Barakhueʼdik o̱ʼe̱ne. Menpaʼ kenpaʼ moʼnopo̱e̱ opuda̱. —‍Jesúsa oʼmanaʼnigʼa fariseomey soataʼ aʼtokhueʼda oʼnoke̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Konige̱po Jesús nogta nogta oʼbatiahuaypo, —‍Yabateʼ. —‍Jesúsa huabokerek ebaʼpoʼketpaktaj onaʼuyate. Oʼbaʼtedepo oʼbaʼyarudpo huadakbaʼda o̱ʼeanʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Fariseomeynayo Jesústaj huakkaʼda onʼhuadiaydepo aʼarakyaʼpo monig kaʼdik o̱ʼe̱, onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nog huameʼnoete Jesúsa aʼtionaʼpakyaʼpo oteʼyo oʼbehuikpo ayaʼ sikyoda oʼtionaʼpakbedpo Diostaj oʼtionaʼpakbeduyate. ");
INSERT INTO amrNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Emedeʼte keʼnen huanigpe̱i̱kaʼeritaj oʼmagkupopakaʼdepo doceyoʼda oʼbaktieʼeaʼuyate. Opuda̱ doce doʼhued huamataʼmonaʼeri moʼe̱a̱pone. Jesúsa oʼmadikkaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Simóntaj oktieʼeaʼuyate. Simón konogda oʼdikkaʼuy Pedro. Simónen huamaʼbuy Andréstaj oktieʼeaʼuyate. Jacobotaj Juantaj, Felipetaj, Bartolométaj, ");
INSERT INTO amrNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateotaj, Tomástaj oʼbaktieʼeaʼuyate. Alfeoensiʼpo Jacobo o̱ʼe̱po Jacobotakon oktieʼeaʼuyate. Kenpaʼti Simón Zelote oktieʼeaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Kenpaʼti Jacoboen huamaʼbuy Judastaj oktieʼeaʼuyate, kenpaʼti Judas Iscariotetaj oktieʼeaʼuyate. Keʼna Judas Iscariote Jesústaj judío huairitaj nogok oʼbayokuyate. Kadarakepo oʼbayokuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ken Jesús oteʼyaʼ oʼhuarakpo doce huamataʼmonaʼeriere huatotaʼyo onʼhuarakuyate. Jesúsen huanigpe̱i̱kaʼeri huakkaʼnada o̱ʼnepo kenpaʼti nogomey huakkaʼ onʼbatiakdepo Judea huadariyaʼ Jerusalénya̱ʼ e̱ʼpo̱gya̱ʼ huakkaʼ jak Tiroyaʼ kenpaʼti e̱ʼpo̱gya̱ʼ huakkaʼ jak Sidónyaʼ onʼbatiakdeʼuyate. Jesústaj aʼpe̱e̱yaʼpo onʼbatiakpo Jesúsa beʼyareʼ onʼnopo̱e̱po onʼbatiakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Kenomeytaj totoʼa dakhueaʼ eʼmagkaʼtada Jesúsa oʼbayareaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Jesúsa ayaʼtada oʼbayareaʼikaʼnok ayaʼada aʼyareyaʼpo Jesústaj eʼnejtaʼ onʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ken Jesús huanigpe̱i̱kaʼeritaj oʼbatiahuaypo, oʼmanmadikaʼpo, —‍Opudomey paiʼda moʼe̱po katepiʼ to̱e̱hueʼ moʼe̱. Dios opuden Huairi o̱ʼe̱. Diosa moʼnopoʼto̱e̱nok Diostaj moʼnigpe̱i̱kaʼ. Durugda moʼi̱kaʼne. ");
INSERT INTO amrNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Opudomey aypotaj e̱ʼe̱a̱da durugda moʼi̱kaʼapo dapotey moʼi̱kaʼapone. Opudomey oy suhueʼ moʼe̱depo boʼhuikdepo durugda moʼe̱po boʼerikapone. ");
INSERT INTO amrNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Opudomeytaj onʼhuadiayapo. Doʼtaj boʼpaknok onʼhuadiayapo. Do huabokerek i̱jje̱po Diosyaʼ ijtiakuy. Eʼhuadiaytada durugda moʼi̱kaʼapone. Kenpaʼti doʼtaj boʼpaknok moʼenapone. E̱ʼentada durugda moʼi̱kaʼapone. Kenpaʼti doʼtaj boʼpaknok eʼtidiʼkeʼtada durugda moʼi̱kaʼapone. Kenpaʼti doʼtaj boʼpaknok “dakhueʼda o̱ʼne,” eʼhuaaʼtada durugda moʼi̱kaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nogok ken konig e̱gkaʼtada huakkaʼda yanʼmadurugpaktiʼ. Dios kurudya̱ʼ ʼuruaʼda moʼnigkaʼapone. Kenomey aratbuta opudomeytaj dakhueaʼda mogkaʼapone. Kenomeyen adhueaʼpaneʼ Diosen huamanbatiaʼpakeritaj dakhueaʼda onʼmagkaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Opudomey oy huakkaʼda moʼto̱e̱po moʼdurugpakne. Nogok paiʼda moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Huakkaʼda aypopiʼ moʼto̱e̱po konig oy dapotey e̱ʼi̱kaʼada nogokda paiʼda moʼe̱a̱popo boʼkusitokapone. Oy durugteda eʼerikada paiʼda moʼe̱po boʼhuikapone. ");
INSERT INTO amrNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Huadakda o̱ʼne. Ayaʼada opudtaj moʼtinopo̱e̱po onʼbatiaʼpakikaʼnigʼa nogokda paiʼda moʼnopoʼe̱a̱pone. Konigti aʼnennada da huamanbatiaʼpakeritaj onʼtinopo̱e̱ʼuyate, huadakda o̱ʼne namaʼda onʼtinopo̱e̱ʼuyate. Huadakda o̱ʼne namaʼda onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Doʼtaj onʼpe̱e̱ne opudomeytaj oʼnonaʼne. Opudtaj dig boʼhuahuayikaʼne konig takaʼ o̱ʼnepo dakhueaʼ mogkikaʼne. Kenomeytaj diʼ yanʼmaikaʼpo huadak yanʼmagkikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Opudtehuapaʼ dakhueʼda ka̱e̱ʼ huahuaaʼeritaj Diostaj dakaʼ yamagkaʼ ya̱ʼnonaʼ. “Kenomeytaj Diosa kamanopoʼkoreʼ.” Yanʼtionaʼpaktiʼ. Kenpaʼti kenomeya̱ dakhueʼda mogkaʼne, kenomeytaj yanʼtionaʼpaktiʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Noga̱ opudtaj eʼtuktuknayo diayhueʼada kentaj dakaʼ yanaʼ. Onteʼti eʼbatuktuknayo onteʼti dakaʼ yanaʼ. Noga̱ opiot eʼkaiʼnayo diayhueʼada chompakon yayoktiʼ, ");
INSERT INTO amrNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","“Aypo beyok.” Noga̱ enaʼnayo sueʼnopo ehueʼ ya̱e̱po yabayoktiʼ. Yudtaj bektoyok enaʼnayo daknopoʼda ya̱e̱po yaktoyoktiʼ. Onteʼti “Betahuaʼ,” ahueʼ ya̱e̱ʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Konigti huadakda nogomey opudtaj eʼnigkaʼtaʼ boʼpaknok kenomeytaj konigti huadakda yanʼmanigkikatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Sueʼada opudomeytaj diʼ moʼe̱ne kenomeytayoʼda diʼ e̱e̱ʼnayo kenda sueʼda huadak o̱ʼe̱. Kenda dakhueaʼ huakaʼeria o̱gkikaʼnigtaj. Nogomeya̱ diʼda e̱e̱ʼnayo diʼ onʼmaeʼ. Dihueʼ hua̱e̱ʼeritakon diʼ yanʼmaeʼ. Kenda huadakda o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Sueʼada opudomeytaj huadakda mogkikaʼpo montihuapokikaʼne. Kenomeytayoʼda eʼtihuapoknayo sueʼda huadak o̱ʼe̱. Ken konig dakhueaʼ huakaʼeri o̱gkikaʼ. Nogomey dakhueʼ hua̱e̱ʼeri huadak e̱gkaʼnayo eʼtihuapoknayo kenomeytaj dakhueʼ hua̱e̱ʼeria huadak o̱gkikaʼpo onʼtihuapokikaʼ. Opudomeytaj huadakda kahueʼ hua̱e̱ʼeritaj kenpaʼti tihuapokhueʼ hua̱e̱ʼeritaj huadakda ya̱gʼkikatiʼ. Kenda eʼkikaʼnayo huadaknanada o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kenomeya̱nayo kenpaʼti beʼtahuapone, yanʼnopo̱e̱po kenomeytayoʼda ektoyoknayo sueʼda huadak o̱ʼe̱. Kenda konig dakhueaʼ huakaʼeria o̱gkikaʼ. Nog dakhueaʼ huakaʼeritaj onʼbaktoyokikaʼ. Kenpaʼti beʼtahuapone onʼnopo̱e̱po. Nogomeya̱nayo onteʼti tahuahueʼ meʼta̱e̱a̱pone nopo̱e̱hueʼada opudomeynayo kenomeytaj yanʼbaktoyokikaʼ. Kenda huadaknanada o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Opudtaj huahuadiayeritaj kenpaʼti takaʼtaj diʼ yanʼmaikaʼ. Huadakda yanʼmagkikaʼ. Takaʼtaj huadakda yanʼmagkikaʼ. Kenomeytaj yanʼbaktoyokikaʼ. Kenpaʼti tahuahueʼ meʼta̱e̱a̱pone nopo̱e̱hueʼada yanʼbaktoyokikaʼ. Ken konig eʼkikaʼnayo Dios kurudyo̱ ʼuruaʼda boʼyokapone. Opudomey kenpaʼti Dios Huairi kuruderiensiʼpo moʼe̱a̱pone. Dios kuruderi teynanada o̱ʼe̱. Konige̱po dakiti ahueʼ hua̱e̱ʼeritaj kenpaʼti dakhueaʼ huakaʼeritaj Diosa huadakda oʼmanigkikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Konig opuden Apag Dios oʼmatinepahuikaʼ konigti yanʼmatinepahuikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Nogtaj “Dakhueaʼ oʼkaʼ,” huaahueʼ yanikaʼ. “Dakhueaʼ oʼkaʼ,” huaahueʼ e̱ʼi̱kaʼnayo “Dakhueaʼ oʼkaʼ,” Dios opudtakon huaahueʼ moʼi̱kaʼapone. Kenpaʼti nogomeytaj “Dakhueaʼ oʼkaʼnok mabitbitdik o̱ʼe̱y,” ahueʼ yanikaʼ. Ken konig ahueʼ e̱e̱ʼnayo “Dakhueaʼ oʼkaʼnok mabitbitdik i̱jje̱y.” Diosa opudtakon onahueʼ moʼe̱a̱pone. Nogomeytaj bakkahueaʼnayo Diosa opudtakon bokkahueaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Nogomeytaj yanʼbayoktiʼ, konig enʼpakte huakkaʼ yanʼbayoktiʼ. Huakkaʼ eʼbayoknayo opudtakon huakkaʼnanada Diosa moʼbayokapone. Nogomeytaj sueʼda eʼbayoknayo kenpaʼti Diosa sueʼda boʼyokapone. Nogomeytaj huakkaʼda eʼbayoknayo Diosa opudtakon huakkaʼda moʼbayokapone. —‍Jesúsa kenda oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Konig huamanbatiaʼpakonhuaʼ Jesúsa oʼmanmadikaʼpo, —‍Huabot ekpobiga̱ʼ batohuahueʼdik o̱ʼne. Konige̱po huakogtoneʼyon bakotdik o̱ʼne. Ken konig beʼapiʼ huamanmadikaʼeritaj dakaʼ pe̱e̱hued e̱ʼe̱a̱da Diosenbaʼ dakaʼ kikahued e̱ʼe̱a̱da Diosbaʼ nogtaj manmadikahueʼdik o̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Huamanmadikaʼerien huanigpe̱i̱kaʼerinayo sueʼda onʼnopo̱e̱nigʼa keʼnen huamanmadikaʼerinayo huakkaʼda onʼnopo̱i̱kaʼ. Nogok eʼnigpeeonhuahuadeʼte konigti kenomeyen huamanmadikaʼeri oʼmanmadikaʼikaʼ nogomeytakon manmadikaʼdik o̱ʼneapo. ");
INSERT INTO amrNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Noga̱ suepiʼ dakhueaʼ ekaʼnayo “Dakhueaʼ oʼkaʼ,” i̱da huaahueʼ yaneʼ. Onnayo dakhueaʼnanada iʼkuyʼetpiʼ. Kenda nopo̱e̱hueʼ i̱ʼe̱. In konig o̱ʼe̱ ijbatiaʼpakapoy. Nog aratbuten huakpoyo huataʼsujsiʼpo ekpohuedte o̱ʼna iʼtiahuaynigʼa. O̱ʼnen huakpoyoaʼtaj huaboroʼtaʼsua bekpohuedne. ");
INSERT INTO amrNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","“Huataʼsuj huakpoyo oktokiʼ, egʼ.” Menpaʼ inaʼ. Namaʼda iaʼ. Ken o̱ʼnen huakpoyoaʼtaj huaboroʼtaʼsua bekpohuednigʼa tiahuayhueʼ i̱ʼe̱ne. Namaʼda huanopo̱e̱ʼeri i̱ʼe̱ne. Huakkuruda o̱ʼnen huakpoyaʼ huaboroʼtaʼsutaj on huataʼ yakokpotoken. Ken konig dakhueaʼ iʼkaʼne yanopoʼkoreaʼpo yabatik. Kenokaʼ iʼbatikdeʼpo dakaʼ iʼtiahuaydepo nogen taʼsujkon okpotokdik i̱ʼe̱a̱pone. Noga̱ namaʼda ekaʼnayo dakhueaʼ eʼhuakaʼ kabatikeʼpo tihuapokdik i̱ʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Aratbut konig hue̱ymey o̱ʼne. Huadak hue̱ymey e̱e̱ʼnayo dakhueʼdaaʼ huada dapakhueʼdik o̱ʼe̱. Huadakdayoʼ oʼdapakikaʼ. Kenpaʼti dakhueʼ hue̱ymey o̱ʼe̱po huadak huada dapakhueʼdik o̱ʼe̱. Dakhueʼayoʼ huada oʼdapakikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Hue̱ymeyen huada huadak e̱e̱ʼnayo oʼtiahuaydepo hue̱ymey huadakda o̱ʼe̱ oʼnopo̱e̱ne. Hue̱ymeyen huada dakhueʼ e̱e̱ʼnayo hue̱ymey dakhueʼda o̱ʼe̱ oʼnopo̱e̱ne. ");
INSERT INTO amrNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Konigti bepiʼ huabokerek huadakda e̱e̱ʼnayo huadakyoʼ oaʼikaʼ. Huadaknopoʼda o̱ʼe̱po huadakyoʼ oʼbatiaʼpakikaʼ. Kenpaʼti bepiʼ dakhueʼda o̱ʼe̱po dakhueʼyoʼ oaʼikaʼ. Dakhueʼnopoʼda o̱ʼe̱po dakhueaʼda oʼbatiaʼpakikaʼ. Konig huanopoʼa o̱ʼe̱, konig oʼnopo̱i̱kaʼpo ken konig oʼbatiaʼpakikaʼne. ");
INSERT INTO amrNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Doʼhued Huairi o̱ʼta̱e̱ne. Doʼhued Huairi o̱ʼta̱e̱ne.” Namaʼda doʼtaj oʼnonikaʼne. Doʼtaj nigpe̱e̱hueʼ moʼi̱kaʼne. Kenda oʼnonikaʼne kahueʼ moʼi̱kaʼne. ");
INSERT INTO amrNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","48","Ayaʼda doʼtaj menhuatiakpo doʼtaj menigpe̱i̱kaʼpo doʼhued huaʼa boʼkikaʼ, konig ʼuruaʼda jak huakaʼeri dakaʼ jak oʼkaʼpo dariteyyaʼ oʼkaʼpo ʼiddu boroʼda adteda oʼkudya̱po jak oʼkaʼ. Hue̱kuru oʼtiakdepo jakta oʼpokpo dakaʼ jak oʼkaʼnok tohuahueʼdik o̱ʼe̱. Hue̱kurua tohuahueʼdik o̱ʼe̱. Ken konig doʼtaj huanigpe̱i̱kaʼeri o̱ʼnepo, oknopo̱e̱batikhueʼdik o̱ʼneapo. ");
INSERT INTO amrNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nogomeya̱ doʼtaj namaʼda menpe̱e̱nigʼa kenda ijmanay nigpe̱a̱hueʼ o̱ʼnikaʼpo konig dakhueʼ jak huakaʼeri o̱ʼne. Dakhueʼ jak huakaʼeri kuhuadtaʼ jak oʼkaʼpo, ʼiddu adteda kudya̱hueʼada jak oʼkaʼpo. Nogok hue̱kuru oʼhue̱tiakdepo ken jak o̱ʼhue̱kedepo hue̱kurua jaktaj oʼtohuaʼpo. Ayaʼda oʼtohuaʼ. Dakhueʼ jak huakaʼerien jak ehueʼda o̱ʼta̱e̱. Ken konig doʼtaj nigpe̱e̱hueʼ hua̱e̱ʼeri o̱ʼneapo. Ken konig e̱ʼdik o̱ʼneapo. —‍Kenda Jesúsa oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesúsa huakkaʼda oʼmanmadikandepo oʼbatikdepo huakkaʼ jak Capernaumyo oʼhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Capernaumyo oʼkudondepo Roma gobierno sorotataj capitán o̱ʼe̱ʼuyate. Capitán cien sorotataj oʼmataʼmonaʼikaʼ. Huadiʼda huanabaʼ o̱ʼta̱e̱po kentaj huakkaʼ oʼpakikaʼuyate. Ken huanabaʼ dakhueʼda o̱ʼe̱po ehueʼ hua̱e̱ʼdikte o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Jesúsa oʼbayareaʼdemeʼte oʼtipe̱e̱depo sueʼda judío huairitoneʼtaj oʼmataʼmonaʼpo Jesúste oʼmataʼmonaʼpo. “Doʼhued huanabaʼtaj betayareaʼ.” Jesústaj ya̱ʼnonatiʼ. Oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Jesústaj onhuahuaʼdepo diga̱ʼda onʼpakpo, —‍Roma sorotataj capitána oroʼomey judío aratbutaj huakkaʼda oʼpak. Oroʼomeytaj diʼda o̱ʼe̱. Oroʼen hua̱i̱takeʼ jak oʼkaʼuy. Konige̱po capitánen huanabaʼtaj yayareaʼ. —‍Judío huiritoneʼa̱ i̱ghuaʼda Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ken huairitoneʼere Jesús oʼhuaʼuyate. Capitánte oʼhuaʼpo capitánen jak meyo̱hueʼda enʼtikayopakte capitána huadiʼ aratbuttaj oʼmataʼmonaʼuyate. Jesúste yanhuaʼ oʼmanaʼpo, —‍I̱yo̱ doʼhued jakyo kudhueʼ ka̱e̱ʼ konige̱po o̱ʼna ʼuruaʼda i̱ʼe̱. Huairi i̱ʼe̱ne. Donayo huairi ehueʼda i̱jje̱y. ");
INSERT INTO amrNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Doʼhuada ijpakpo ontaj huahuahueʼ o̱ʼe̱ne. “Kayareʼ,” yaaʼ. Kenda o̱ʼna eaʼte doʼhued huanabaʼ oʼyaruda̱po. ");
INSERT INTO amrNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Doʼhued sorotataj huairia menikaʼne kenda ijnigpe̱i̱kay. Kenpaʼti doʼhued sorotatataj ijmanikay doʼtaj mennigpe̱i̱kaʼne. “Yahuatiʼ,” doʼhued sorotatataj eʼnadeʼte oʼhuaʼikaʼ. Nogtaj “Yatiak,” enaʼte oʼtiakikaʼ. Doʼhued huanabaʼtaj katepiʼ “Yakaʼ,” enaʼnayo oʼkaʼikaʼ. Kenpaʼ Jesústaj ya̱ʼnonatiʼ. —‍Capitána huadiʼtaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Kenda Jesús oʼpe̱e̱depo “Kenpihuay, huakkaʼda capitána meknopo̱e̱ne.” Jesúsa oʼnopo̱e̱po. Huakkaʼ aratbut huatahuaʼeritaj Jesúsa oʼbatiahuayʼepo, —‍Ken capitána huakkaʼda meknopo̱e̱ne. Huakkaʼda Diostaj oknopo̱e̱ʼ. Judío aratbutnayo Diostaj sueʼda oʼnoknopo̱e̱ ijnopo̱e̱y. Diostaj sueʼda oʼnoknopo̱e̱. Buttida ijjay. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Jakyo eʼkumejdeʼte kenomeytaj capitán oʼmataʼmonaʼdenig o̱gkumejdepo capitánen huanabaʼ eʼyaredeʼ huadakda e̱ʼe̱deʼ onʼhuahuayatoʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nogokaʼda Naín huakkaʼ jakyo Jesús oʼhuaʼuyate. Jesús huanigpe̱i̱kaʼeriere kenpaʼti nogomey huakkaʼada onʼhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Huakkaʼ jak hua̱kye̱ʼdikte oʼhuahuaʼdepo huabokudak huaboaʼda eʼbueydeʼte aʼkubarakkayaʼpo o̱hue̱y cajónpote eʼnontohuaʼte Jesúsa oʼtiahuayʼuyate. Ken huabokerekkudak ʼayhuaen nogtida huabosiʼpo o̱ʼta̱i̱kaʼuyate. ʼAyhuaere huakkaʼda aratbut onʼhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jesús Huairia ʼayhuataj oʼtiahuaydepo oʼtinepahuiʼpo, —‍Huikhueʼ ya̱e̱ʼ. —‍Onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ken Jesús oʼhuahuaʼpo o̱hue̱y cajónpotaʼ oʼtibataʼtenok huantohuaʼeriomeya̱ oʼnontoboatoʼuyate. —‍Yanoyhuad, huabo, doʼhua ijjay. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ken huaboa oʼhuadatoʼpo huaboaʼda aratbuttaj oʼmanaʼpakatoʼuyate. Ken huabotaj hua̱ye̱taj oʼyokuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Huakkaʼada aratbut ke̱yo̱ o̱ʼnepo onʼtiahuaypo huakkaʼada onʼmamepuʼkudpo Diosa ʼuruaʼnanada o̱ʼe̱po huadaknanada oʼkikaʼ. Onʼbatiaʼpakpo, —‍Diosen huamanbatiaʼpakeri teyda o̱ʼe̱po orote oʼtiakde. —‍Ondaʼpo, kenpaʼti, —‍Diosa i̱yo̱ keʼnen aratbutte oʼtiakde. Oroʼomeytaj mantihuapokyaʼpone. —‍Ondaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Kenda Jesúsa oʼkaʼdenig onʼbatiaʼpakpo, nogya̱ʼ nogya̱ʼ adtaʼda onʼbatiaʼpakpo, Judea huadaribayo kenpaʼti Judea huadaribayaʼ nogya̱ʼ nogya̱ʼ onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","19","Kenda Jesúsa oʼkaʼdenig Juan Bautistaen huanigpe̱i̱kaʼeria onʼbatiaʼpakdenok kenda Juana oʼtipe̱e̱depo bottaʼ huanigpe̱i̱kaʼeritaj oʼmataʼmonaʼpo, Jesúste oʼmataʼmonaʼpo, “Diosa Cristotaj moʼtaʼmonaʼapone. Cristo oʼtiakapo oknopo̱e̱y. ¿Menpaʼ o̱ʼna Cristoda i̱ʼe̱? ¿Oroʼomey menpaʼ nogtaj nige̱ʼdik o̱ʼe̱?” Jesús Huairitaj ya̱ʼnonatiʼ. Juana oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kenomey Juanen huanigpe̱i̱kaʼeri bottaʼa Jesústaj onʼhuatiakdepo, —‍“¿Menpaʼ o̱ʼna Cristoda i̱ʼe̱? ¿On Cristo ehueʼ e̱e̱ʼnayo menpaʼ nogtaj onʼmabodik o̱ʼe̱a̱po oroʼomeya̱?” Ontaj kenpaʼ kanoneʼpo Juana boʼtaʼmonaʼne. —‍Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Kenokaʼ bottaʼ enʼtiakdeʼte Jesúsa huakkaʼtada oʼbayareaʼpo, dakhueʼtaj oʼbayareaʼpo, paiʼda eʼnopoʼe̱te kenomeytaj oʼbayareaʼuyate. Nogomeytaj totoʼa eʼmanopoʼto̱e̱tada totoʼtaj oʼmaenʼuyate. Kenpaʼti Jesúsa huakkaʼ ekpobigtaj oʼmakpoanʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","23","—‍Ekpobigtaj ijmakpoani, huakkettaj ijhuaʼeadi̱, keʼpoda eʼso̱ʼparaʼtaj ijbayareay, eʼpeokbettaj ijbayareay, huakudakaʼda eʼbueytada ijmanoyhuada̱y. “Doʼtaj eknopo̱e̱ʼnayo Diosere onteʼti moʼnoeonhuahuikaʼapone.” Paiʼda hua̱e̱ʼeriomeytaj ijmanikay. Doʼtaj okbirahueʼ hua̱e̱ʼeriomeytaj ijmadurugpakaʼapoy. Kenda eʼkaʼte onʼtiahuayne onʼpe̱e̱dene Juantaj yanhuahuaʼpo yanʼbatiaʼpaktiʼ. —‍Jesúsa Juanen huanigpe̱i̱kaʼeritaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Ken Juan Bautistaen huanigpe̱i̱kaʼeri eʼnokhuadeʼte huakkaʼ aratbut e̱gkupopakte Jesúsa Juantaj oʼtiaʼpakpo, —‍Nogbayo jakbahueʼyo aratbut ehueʼ e̱ʼi̱kaʼyo opudomey bohuaʼuyne. Huabokerek konig teyda ehueʼ konig dakhueʼ kaʼhuey ahueʼ hua̱e̱ʼeri konig huihuipi eʼbapokte o̱ʼi̱kaʼ kentaj konig aʼtiahuayaʼpo huahueʼ moʼu̱yne ");
INSERT INTO amrNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Huabokerek ʼurunada yudtaj eʼotte aʼtiahuayaʼpo huahueʼ moʼu̱yne. Aratbut ʼuru yudtaj onʼotikaʼpo konig katetapiʼ oʼderetpakikaʼpo huairien ʼuru jakyoda o̱ʼnikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Diosen huamanbatiaʼpakeritaj aʼtiahuayaʼpo jakbahueʼyo bohuaʼuyne. Diosen huamanbatiaʼpakeri huadakda o̱ʼne. Juannayo nogi̱ti hueretnanada Diosen huamanbatiaʼpakeri o̱ʼi̱kaʼnok. Juantaj aʼtiahuayaʼpo bohuaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Doʼtaj katiapakeʼpo huakkuruda Diosa Juantaj oʼtaʼmonaʼuyate. Apagbaʼte kenpaʼ oʼtimadoyaʼpo: Ontaj huakkuruda doʼhued huataʼmonaʼeritaj ijtaʼmonaʼapoy. Dakhueaʼ o̱gkikaʼnok ayaʼtada yamanopoʼkoreaʼ. Diosen Huasiʼpotaj yanoknopo̱e̱ʼ. Aratbuttaj oʼmanaʼapo. Apagbaʼte oʼnigmadoyaʼuyate. Kenda Diosa Apagbaʼte menaʼuyne doʼtaj. ");
INSERT INTO amrNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ayaʼda huabokerek sueʼda huadak o̱ʼnenok Juannayo huadaknada o̱ʼe̱nok Diosa huakkaʼ Juantaj oʼpak. Dios Huairitaj eʼnigpe̱i̱kaʼte Diosen Huasiʼpotaj huaknopo̱e̱ʼeri huadakda o̱ʼneapo. Diosa kenomeytataj huakkaʼnada oʼbaeretpakapo. Juantaj sueʼdamon oʼpakapo. Ijjay. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ayaʼ aratbuttaj kenpaʼti gobiernotaj huakupe huanigbaeʼeritaj Juana bautiza oʼmagkameʼnok kenomeya̱ Jesústaj eʼpe̱e̱deʼte “Diosa huadakda oʼkaʼ.” Onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Moisésenbaʼ huamanmadikaʼerinayo kenpaʼti fariseomeynayo konig huairi o̱ʼnepo Diostaj eʼnopoʼkoreaʼtaʼ pakhueʼ o̱ʼnepo bautiza megkeʼpo Juantaj huahuahueʼ o̱ʼneʼuyate. Juana konige̱po kenomeytaj bautiza magkahueʼ oʼmaeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","34","Jesúsa nogi̱ti oʼmanaʼpo: —‍Aratbut oy ken konig o̱ʼnikaʼ ijbatiaʼpakapoy. Kenomeytaj beʼapiʼ madurugpakahueʼdik o̱ʼne. Katepiʼ nogomey onʼpakpo o̱gkikaʼnig kenomeynayo konigti eʼkaʼtaʼ pakhueʼ o̱ʼne. Kenda Juan Bautista oʼkikaʼnig kenomeynayo pakhueʼ o̱ʼne. Kenpaʼti do huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne konig do ijkikaʼnig kenda kenpaʼti pakhueʼda o̱ʼne. Juan bautista katepiʼ ʼuruaʼda aypo bapehueʼ o̱ʼi̱kaʼpo kenpaʼti vino konig sineʼ paiʼ mayhueʼ o̱ʼi̱kaʼpo. Kenda Juana oʼkikaʼnok totoʼa Juantaj oʼnopoʼto̱e̱ kenomeya̱ namaʼda onʼbatiaʼpakikaʼnigʼa. Nogok do huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne opudere katepiʼ ʼuruda aypo ijbapikay kenpaʼti do katepiʼ ijmayʼikay. Doʼtakon dakhueaʼda menhuaʼpakikaʼne. “Huakkaʼda oʼbapikaʼ kenpaʼti huakkaʼda huamaiʼeri o̱ʼi̱kaʼ. Kenpaʼti Jesúsa dakhueaʼ huakaʼeritaj diʼda oʼmaikaʼ. Kenpaʼti gobierno huakupe huanigbaeʼeritaj diʼda oʼmaikaʼ.” Doʼtaj kenpaʼ menhuaaʼikaʼne. Aratbut oy ken konig o̱ʼnikaʼ nogda ijbatiaʼpakapoy. Katepiʼ nogomey onʼpakpo o̱gkaʼ kenomeynayo konigti eʼkaʼtaʼ pakhueʼ o̱ʼnikaʼ. Konig huasiʼpo onʼbatuerikikaʼnig aratbut oy konigti o̱ʼne. Huasiʼpo huakkaʼ jak kurute onʼbahuadpo onʼbatuerikpo nogtaj nogtaj onʼmanaʼpo, “Teteʼpuʼte ʼuruaʼda oʼbatadiʼkey opudnayo oroʼere eʼdurugpaktaʼ pakhueʼ moʼe̱ne baila e̱e̱ʼtaʼ pakhueʼ moʼe̱ne. Oroʼ eʼbahuiktada opudnayo huikhueʼ moʼe̱ne.” Ken konig huasiʼpoa ondaʼikaʼ. Ken konig aratbut oyda o̱gkikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Diosa ʼuruaʼda oʼnopo̱i̱kaʼnok Diostaj huanigpe̱i̱kaʼerinayo ʼuruaʼda onʼnopoenkikaʼ. Kenomeyyoʼda durugda o̱ʼne. —‍Jesús Huairia oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","“Doʼhued jakyaʼ mobapeʼ.” Nogtiada fariseo aratbut Jesústaj onaʼuyate. Jesús keʼnen jakyo oʼhuaʼpo kutopate oʼhuadpo oʼbapeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ken ettoneʼ o̱ʼe̱po huakkaʼ jakyo hua̱e̱ʼeri o̱ʼe̱po dakhueaʼ huakaʼeri o̱ʼu̱yate. Jesús fariseoen jakyo oʼbapeʼ oʼnopo̱e̱po Jesústaj oʼhuahuaʼpo ʼuruda yereda huidpuʼ ʼuruʼhui̱e̱a̱da huasihuaj oʼtohuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jesústaj huaʼitaʼpote oʼtihuadpo oʼhuikpo diga̱ʼda huakpota̱ʼhue̱a̱ Jesúsen huaʼitaʼ oʼitisurukaʼpo ken oʼikoyopo oʼitidukutpo ettoneʼa̱ huakuhuiʼa oʼitidukutpo huaʼitaʼ oʼibuyukepo, Jesústaj diʼda o̱ʼe̱po oʼibuyukepo kenpaʼti diʼ o̱ʼe̱po huaʼitaʼ ʼuruʼhui̱e̱da huasihuaʼa oʼihuekeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ken fariseo Jesústaj oʼtobapeʼpo kenda ettoneʼ e̱gkadeʼte oʼtiahuaydepo “Diosen huamanbatiaʼpakeri Jesús ehueʼdik o̱ʼe̱, yoknopo̱e̱po Diosen huamanbatiaʼpakeri e̱e̱ʼnayo in ettoneʼ dakhueaʼ huakaʼeri o̱ʼe̱, yaʼnopo̱e̱yet.” Kenda fariseoa huanopoyaʼ namaʼda oʼnopo̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jesúsa kenda joknokotpo, —‍Ontaj eʼbatiaʼpaktaʼ ijpaki, Simón. —‍Jesúsa fariseotaj onaʼuyate. —‍Menaʼ, Huamanmadikaʼeri. —‍Fariseoa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","—‍Huakupe huabaktoyokeritaj bottaʼ huabokereka huakupe dehueaʼ o̱ʼnuyate. Nogtiada quinientos denario huakupe dehueaʼ o̱ʼu̱yate. Noga̱ cincuenta denario huakupe dehueaʼ o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Huakupebayoʼ o̱ʼnepo tahuahueʼdik o̱ʼnenok huakupe huabaktoyokeria huabokerek bottaʼtaj huakupetaj betahuaʼ eʼmanataʼ pakhueʼ o̱ʼe̱po oʼbatiokkahueʼuyate. Oy, ¿menaʼtaj diʼda e̱ʼdik ya̱ʼe̱? —‍Jesúsa fariseotaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","—‍Keʼna huakkaʼda dehueaʼ o̱ʼe̱po kentaj huakkaʼda oʼbatiokkahueʼuyate, keʼna huakkaʼ diʼ o̱ʼe̱, ijnopo̱e̱po. —‍Simóna onaʼuyate. —‍Buttida iaʼne. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ken Jesúsa ettoneʼtaj huatiahuayaʼaʼ, Simóntaj, —‍In ettoneʼtaj yatiahuayʼ. O̱ʼnen jakyo ijkudondey. Huaʼitaʼ aʼikoyoyaʼpo hue̱ʼe̱y yokhueʼ meʼe̱ne. In ettoneʼnayo huakpota̱ʼhue̱a̱ beʼikoyoaʼpo kenpaʼti huakuhuiʼa beʼitidukutne. ");
INSERT INTO amrNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","O̱ʼnanayo buyukhueʼ o̱ʼe̱ne. Ettoneʼa̱nayo huaboaʼda do eʼkudte beʼibuyukene. ");
INSERT INTO amrNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Eʼkudondeʼte huakutaʼ doʼtaj huasihuaj kutioyhueʼ o̱ʼe̱ne. Ettoneʼa̱nayo ʼuruʼhui̱e̱a̱da huasihuaj beʼitioyne. ");
INSERT INTO amrNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ettoneʼ huakkaʼ dakhueaʼ eʼkaʼ Diosa okkahueaʼnok ettoneʼ huakkaʼ diʼ meʼe̱dene. Kentaj Diosa sueʼda okkahueaʼnok sueʼda diʼ meʼe̱ne. —‍Jesúsa Simóntaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ettoneʼtaj, —‍On dakhueaʼ iʼkaʼuyatenig okkahueaʼne. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Nogomeya̱ kutopataʼ onʼbatobapeʼpo huayahuaya onʼbatiaʼpakpo, —‍Ken huabokereka dakhueaʼ eʼkaʼ okkahueaʼde. Konig Diosa okkahueaʼ keʼna dakhueaʼ eʼkaʼtaj okkahueaʼ. ¿Be ya̱ʼe̱? —‍Aypo huatobapeʼeria onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ettoneʼtaj, —‍Doʼtaj oknopo̱e̱nok Diosa ontaj bekkahueaʼpo meʼnopoʼyareaʼne. Daknopoʼda ya̱e̱po yahuatiʼ. —‍Jesúsa ettoneʼtaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nogok nogyo̱ nogyo̱ huakkaʼ jakyo Jesús oʼhuaʼepo huakkaʼ jakyo huadak huaʼa Diosen huairi o̱kye̱yakde Dios huairitaj yanoknopo̱e̱po yanʼnigpe̱i̱kaʼ, oʼmanmadikikaʼuyate. Jesúsen doce huamataʼmonaʼeri kenere onʼhuaʼudhuaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ettoneʼere oʼhuaʼepo totoʼa eʼmanopoʼto̱e̱tada Jesúsa oʼmanopoʼyareameʼte totoʼ oʼmakenmeʼte. Nogomey ettoneʼtaj oʼbayareameʼte. María Magdalena Jesúsere o̱ʼi̱kaʼuyate. Jesúsa Maríataj siete totoʼ okmaenameʼte. ");
INSERT INTO amrNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Juanakon Jesúsere o̱ʼi̱kaʼuyate. Juana Chuzaen hua̱to̱e̱ o̱ʼu̱yate. Chuza Huairi Herodesen jak huato̱e̱ʼeri o̱ʼu̱yate. Kenpaʼti Susana Jesúsere o̱ʼi̱kaʼuyate. Nogomey ettoneʼ sueʼda huakkaʼ Jesúsere o̱ʼnepo Jesúsomey hua̱e̱ʼeritaj katepiʼ onʼpaknok onʼbayokikaʼuyate. Aypopiʼ yudtapiʼ onʼbayokikaʼpo kenpaʼti onʼtihuapokikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Huakkaʼada aratbuta Jesústaj onʼhuahuaʼuyate. Nog jak nog jakyaʼ onʼhuahuaʼpo Jesústaj onʼtikupopaknok huabakidenaʼeri ken konig o̱gkikaʼ Jesúsa oʼmanbatiaʼpakpo oʼmanmadikanhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—‍Aʼbakidenayaʼpo huabakidenaʼeri oʼhuaʼuyate. Oʼhuaʼepo oʼbakidenaʼpo dagte sueʼda oʼkidkahuapo huaʼia oʼbakidtuge̱a̱ʼpo kenpaʼti nogte bakoya oʼkidye̱ʼkuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Huidbate kuhuado̱nokparedte sueʼda oʼkidkahuad. I̱da oʼkereknigʼa. Kuhuado̱nokparedte dariayda o̱ʼe̱nok i̱da oʼayʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Nog huakid okpotaʼpidsiʼbayo oʼkidkahuaʼuyate. Huakpi sueʼda oʼbatipakbonigʼa okpotaʼpidsiʼ diga̱ʼda oʼbakerekpo huakpitaj oʼbatibukʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Nog huakid huadak sorokte oʼkidkahuaʼuyate. Oʼbatipakbodepo huakkaʼda huakid o̱gkupapakuyate. Sueʼda huakpi cien huakid o̱gkupapakpo noga̱ sueʼda huakid o̱gkupapakuyate. —‍Jesúsa kenda eʼmanaʼte, —‍Huadakpeok e̱ʼhua̱e̱a̱ dakaʼ menʼpe̱e̱ʼ. —‍Jesúsa ʼuttaʼda oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","—‍Ken huakidenaʼeri ken konig oʼkaʼ huaboaʼda oroʼtaj onʼbatiaʼpaknig nopoenkahueʼda o̱ʼe̱y. Oroʼtaj dakaʼ moʼnopo̱e̱a̱ʼ. —‍Jesúsen huanigpe̱i̱kaʼeria Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","—‍Opudomey doʼhued huanigpe̱i̱kaʼeri moʼe̱nok konig aratbut Diosen Huakhuairitaj onʼnigpe̱i̱kaʼapo, konig buttida o̱ʼe̱a̱po Diosa opudomeytanayo eʼmanopo̱e̱a̱ʼtaʼ oʼpak. Nogomeytaj doʼhued huanigpe̱i̱kaʼeri ehueʼtaj nogda ken konig o̱ʼe̱ ijmanbatiaʼpakikay. Kenda eʼmape̱e̱a̱da nopoenkahueʼ o̱ʼneapo. —‍Jesúsa huanigpe̱i̱kaʼeritaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","—‍Ken huakidenaʼeri ijmanopo̱e̱a̱ʼapoy. Ken huakid konig Diosen huaʼa o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Dagte sueʼda oʼkidkahuaʼuyate. Ken huakid dagte oʼkidkahuaʼuyate konig sueʼda aratbut Diosen eʼmanmadikaʼtaj onʼpe̱e̱nigʼa i̱da totoʼa oʼhuahuaʼpo huanopoyaʼ Diosen huaʼa oʼbakkaynok onteʼti Diostaj oknopo̱e̱hueʼdik o̱ʼneapo onteʼti nopoʼyareahueʼdikda o̱ʼneapo. ");
INSERT INTO amrNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Huidbate sueʼda oʼkidkahuaʼuyate. Ken konig aratbut Apagbaʼ enʼpe̱e̱a̱tuʼte durugda onʼpe̱e̱a̱tunigʼa konige̱po dakaʼ nigpeonhuahuahueʼ o̱ʼnepo sueʼda onʼnopoenkaʼpo sueʼda huameʼnoe oʼnoknopoeonhuaʼpo totoʼa namaʼda eʼmanadeʼte onteʼti Diostaj nigpe̱e̱hueʼ o̱ʼnepo kenpaʼda okkahueʼdik o̱ʼneapo. ");
INSERT INTO amrNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Huakid okpotaʼpidsiʼbayo oʼkidkahuaʼuyate. Ken konig aratbut Diosen eʼmanmadikaʼtaj onʼpe̱e̱po onʼpe̱e̱nigʼa nogok nogtaʼ nogtaʼ onʼmamepuʼkepo onteʼti sig sig Diostaj oʼnoknopo̱e̱batikapo. Kenpaʼti huakkaʼ eʼta̱ʼmaetaʼ onʼpakpo sig sig Diostaj oʼnoknopo̱e̱batikapo. Kenpaʼti huataʼda eʼdurugpakaʼtaʼ onʼpakikaʼpo onteʼti Diostaj pakhueʼ o̱ʼneapo, nigpe̱e̱hueʼ o̱ʼneapo. Diosen kahueʼ o̱ʼneapo. ");
INSERT INTO amrNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ken huakid huadak sorokyo oʼkidkahuaʼuyate. Ken konig aratbut huadaknopoʼda Diosbaʼtaj onʼpeeonhuahuikaʼpo onʼnigpeeonhuahuikaʼ. Dakaʼ konig ʼurunopoʼda onʼnigpe̱e̱po batikhueʼda huadakda o̱gkikaʼapo. Kenomey Diosensiʼpo o̱ʼne, huakkaʼada onʼnopo̱e̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Sikyo jakki̱re̱gya̱ʼ huakjey eʼbakpakte kosoa tiokkubukhueʼdik o̱ʼnikaʼ. Kenpaʼti huakjey eʼbakpakte huataytoyo huada̱hueʼdik o̱ʼnikaʼ. Kutopate huakjey onʼhuada̱ʼikaʼ. Jakyoda ayaʼada onʼkuddepo tiahuaydik kaʼneʼpo. ");
INSERT INTO amrNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ken konigti Diosen eʼnopo̱e̱ʼ oy konig eʼi̱re̱g e̱e̱ʼtada nogok ayaʼada onʼnopo̱e̱a̱po, ayaʼada onʼtiahuayapo. ");
INSERT INTO amrNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ken, dakaʼ Apagbaʼtaj yanʼpe̱e̱ʼ konige̱po sueʼda eʼpe̱e̱ʼnayo sueʼda eknopo̱e̱ʼnayo Diosa boʼtihuapokapone nogi̱ti nogi̱ti Diostaj moknopo̱e̱a̱po, nogi̱ti nogi̱ti Diostaj moʼnigpe̱e̱a̱po. Dakaʼ pe̱e̱hueʼ e̱e̱ʼnayo Diosbaʼtaj oknopo̱e̱hueʼ e̱e̱ʼnayo kenda moʼnopo̱e̱ Diosa bokkayapone onteʼti oknopo̱e̱hueʼdikada moʼe̱a̱pone. —‍Jesúsa oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Kenokaʼ Jesúsen hua̱ye̱ Jesúsen huamaʼbuyere Jesústaj onhuatiakuynigʼa huakkaʼnanada o̱gkupopaknok kentaj huatiakhueʼdik o̱ʼneʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","—‍O̱ʼnen hua̱ye̱ o̱ʼnen huamaʼbuyere aratbuttiokpeyon moʼnigbone. Ontaj eʼbatiaʼpaktaʼ onʼpak. —‍Noga̱ Jesústaj oʼnonatuʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","—‍Beʼapiʼ Diosen huaʼa onʼpe̱e̱po onʼnigpe̱e̱po konig o̱gkikaʼ keʼna doʼhued hua̱ye̱ o̱ʼne, doʼhued huamaʼbuy o̱ʼne ijnopo̱e̱y. —‍Jesúsa ayaʼ huakupopakeritaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nogok Jesús huanigpe̱i̱kaʼeriere huaboaʼda kusiʼpetoneʼyo onʼbahuadpo, —‍E̱ʼpo̱g monokteg. —‍Jesúsa oʼmanaʼnok huaboaʼda oʼnonhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ken eʼnonoktegte kusiʼpeyaʼ Jesús oʼtayʼuyate. E̱ʼpo̱gnopoyaʼ i̱da huaboroʼbapokada oʼbahuatiakpo. Teyaʼda oʼbapoknok huaboroʼ oʼhue̱niri̱ʼtoneʼpo diga̱ʼda oʼhue̱kudpo oʼtihuedpo huataʼkotdikte o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Jesústaj onʼhuahuaʼpo aʼmaboayaʼpo, —‍Huamanmadikaʼeri, Huamanmadikaʼeri, montakotnede. —‍Jesústaj oʼnonaʼuyate. Ken Jesús oʼmabodpo, “Yabatik, bapokhueʼ ya̱e̱ʼ.” Kenpaʼti, “Yabatik, hue̱niri̱hueʼ ya̱e̱ʼ.” Jesúsa onaʼnok oʼbatikanpo bapokhueʼ o̱ʼu̱yate kenpaʼti hue̱niri̱hueʼ o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","—‍Menaʼpo doʼtaj oknopo̱e̱hueʼ moʼe̱, —‍Jesúsa huanigpe̱i̱kaʼeritaj oʼmanaʼuyate. Kenomeynayo Jesústaj onʼtomeʼpukepo huayahuaya, —‍¿Kenpihuay, be in huabokerek ya̱ʼe̱? Bapokataj onaʼnok oʼnigpe̱e̱ kenpaʼti e̱ʼpo̱gtaj onaʼnok e̱ʼpo̱ga̱kon oʼnigpe̱e̱. ¿Kenpihuay, be ya̱ʼe̱? —‍Huanigpe̱i̱kaʼeria huayahuaya onʼmanbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ken akodpen Gadara huadaribayo onʼtiakpo onʼbeʼtuyate. Gadara eʼdeaʼ akudpen Galilea o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesús eʼkotdeʼte Jesústaj nogbokerekatida huakkaʼ jakyaʼ oʼhuatiakonpo. Ken huabokerektaj huakkaʼ totoʼa onʼnopoʼtounhuahuaʼuyate. Yudtaj othueʼ o̱ʼunhuahuaʼuyate. Jakyo ehueʼ o̱ʼi̱kameʼte. Kubarakbayo o̱ʼunhuahuaʼikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Oʼtiahuaydepo Jesústaj huikudate oʼtisakotuyate. Oʼokoypo, —‍¿Menaʼpo doʼtaj oʼhuatiak, Jesús? Dios kutayo hua̱e̱ʼerien Huasiʼpo i̱ʼe̱. Doʼtaj o̱gkahueʼ meeʼ. Diga̱ʼda onaʼne. —‍Huabokereka ʼuttaʼda Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Kenpaʼ enadeʼte Jesúsa totoʼtaj huamaenaʼdikte o̱ʼu̱yate. Nogok nogok huakkaʼ totoʼa onʼnopoʼto̱i̱kameʼte. Aratbuta kentaj sirobia huabaʼ kenpaʼti huaʼi onʼtinukupo dakaʼ aʼto̱e̱ya̱ʼpo. Onʼtinukunigʼa ken huabokereka oʼtipukpukanikaʼuy. Aratbut ehueʼ e̱ʼi̱kaʼyo totoʼomeya̱ onʼtohuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","—‍¿Katedik i̱ʼe̱? —‍Jesúsa huabokerektaj onaʼnok, —‍Doʼhued huadik “Huakkaʼ” i̱jje̱y. —‍Onaʼuyate. Kenda onaʼnigtaj huakkaʼ totoʼ kentaj onʼnopoʼto̱i̱kaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","—‍Sorokkogyo̱ adyonda dakhueaʼ totoʼomeya̱ paiʼda onʼnopoʼeunhuahuikaʼapo. Ke̱yo̱ oroʼomeytaj mataʼmonahueʼ moeʼ. —‍Totoʼomeya̱ Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kente oteʼte huakkaʼda huakyariʼ onʼpeʼnok, —‍Huakyariere a̱ʼe̱ya̱ʼpo yanʼkud. Monaʼ. —‍Jesústaj diga̱ʼda oʼnonaʼnok, —‍Yanʼkud. —‍Jesúsa totoʼtaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ken totoʼa huabokerektaj oʼnenonpo oʼnokhuaʼpo huakyaritaj onʼhuankudonpo ken huakyariʼ ayaʼda huaduk oʼbahuarakpo kubogyo onʼbaajpo e̱ʼpo̱gyo̱ oʼbataʼkoʼtuyate. Totoʼere onʼbataʼkoʼtuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ken huakyariʼ huato̱e̱ʼeri kenda onʼtiahuaydepo onʼmameʼpukeʼpo kenda aʼmanbatiaʼpakyaʼpo huakkaʼ jakyo onʼbakeʼtuyate. Kenpaʼti taʼbayaʼ aʼmanbatiaʼpakyaʼpo onʼhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kenda onʼpe̱e̱depo monig Jesúsa yakaʼ aʼtiahuayaʼpo huakkaʼ jakyaʼ huakkaʼada onʼmaoro̱kondepo Jesústaj onʼhuahuaʼpo onʼhuatiakdepo ken huabokerektaj huakkaʼ totoʼ huaboaʼda eʼnokbahuaʼdeʼ onʼtiahuaypo, ken huabokereka Jesúsen huaʼite oʼhuadpo, yudtaj oʼotpo, kenpaʼti oyda huadakda o̱ʼe̱. Ken huabokerektaj onʼtiahuaydepo onʼmeʼpukeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Aratbut ke̱yo̱ Jesúsere e̱ʼhua̱e̱a̱ onʼtiahuaydepo kenda Jesúsa oʼkaʼde eatiahuayʼa onʼmanbatiaʼpakpo huakkaʼ jakyo hua̱e̱ʼeritaj onʼmanbatiaʼpakpo, konig kentaj huakkaʼ totoʼa eʼnopoʼtounhuahuikaʼdeʼte Jesúsa oʼyareaʼdenig, onʼmanbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kenda onʼpe̱e̱depo ayaʼ aratbut Gadara huadaribayo hua̱e̱ʼeri ke̱yo̱ o̱gkupopakdepo huakkaʼda onmeʼpukpo, —‍Oroʼedbayaʼ yahuadeʼ. —‍Jesústaj i̱ghuaʼda oʼnonaʼnok. Jesús kusiʼpetoneʼyo oʼhuadpo huahuaʼdikte o̱ʼe̱nigʼa ");
INSERT INTO amrNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","huahued e̱e̱ʼted ken huabokerekyaʼ totoʼa huaboaʼda oʼnokhuaʼde keʼna Jesúsere eʼhuaʼtaʼ oʼpakpo, —‍Onere eʼhuaʼtaʼ ijpaki. —‍Jesústaj onaʼnok. —‍Doere huahueʼ ya̱e̱ʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","O̱ʼnen jakyo yahuatiʼ. A̱yo̱ o̱ʼnenbayaʼ yamanbatiaʼpak. Ayaʼda Diosa menigkaʼdene yamanbatiaʼpakhuatiʼ. —‍Jesúsa ken huabokerektaj onaʼuyate. Kenpaʼ onaʼdepo Jesúsa oʼhuaʼuyate. Ken huabokerek aʼmanbatiaʼpakhuayaʼpo oʼhuaʼpo keʼnen jak hua̱e̱ʼeritaj Jesúsa huakkaʼ totoʼtaj mekmaenameʼne, beʼyareameʼne oʼmanbatiaʼpakhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesús akudpen onteʼti oʼkumejdepo huakkaʼada aratbuta oʼnonmabopo o̱gkupopakpo durugteda huabada onʼdeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Ken huabokerek Jairodik oʼtiakuyate. Jairo judíoen hua̱i̱takeʼ jak huairi o̱ʼu̱yate. Jairo Jesúsen huaʼite huikudate oʼtisakotpo, —‍Nogtida huayetsiʼpo meʼta̱e̱ne. Doce años o̱ʼe̱po keʼpoda o̱ʼe̱po huabueydikte meke̱ne. Betayareaʼ, doʼhued jakyo yahuaʼ. —‍Jesústaj i̱ghuaʼda onaʼuyate. Ken Jesús eʼhuaʼte huakkaʼada aratbut o̱gkupopakpo Jesústaj huakkaʼada aratbutpoyaʼ andayaʼpo oʼnogkaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ettoneʼ o̱ʼe̱po huakkaʼ aratbutere o̱ʼe̱po keʼna dakhueʼda o̱ʼe̱po mimi batikhueʼ o̱ʼunhuahuikaʼpo doce huabayok oʼtipokde batikhueʼda o̱ʼunhuahuikaʼuyate. Nogtaj nogtaj huamadakkaʼeritaj oʼbahuahuaeʼikaʼuyate. Huamadakkaʼeritaj ayaʼda keʼnen huakupe gasta oʼtikaʼonhuahuaʼuyate. Huamadakkaʼeritaj eʼyoktada yareahueʼ o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Jesústaʼpiyen oʼhuatiakpo, yudtaʼjok huakubogpitaʼ oʼnejpo, oʼnejdepo mimi oʼbatikonpo oʼyarudʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","—‍¿Beʼa meʼnej? —‍Jesúsa oaʼuyate. Ehueʼ beʼa nejhueʼ meene, ayaʼada onʼbatiaʼpakpo —‍Huakkaʼada aratbutpoyaʼ ontaj mondaʼene andayaʼpo mogkaʼne. “¿Beʼa meʼnej?” ¿Menaʼpo iaʼ? —‍Pedro nogomeyere Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","—‍Beʼapiʼ meʼnejne ijnopo̱e̱y konige̱po betapiʼ ijyareaʼdey huanopoʼada ijnopo̱e̱y. —‍Jesúsa oʼmanaʼnok. ");
INSERT INTO amrNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Doʼtaj beʼyareadne Jesúsa meʼtinopo̱e̱ne ettoneʼ oʼnokotdepo omeʼpukpo oʼiriga̱ʼpo Jesústaj oʼhuahuaʼpo Jesúsen huaʼite huikudate oʼtisakotuyate. Huakkaʼ aratbuttaj kanʼpe̱e̱ʼpo kenaʼpo Jesústaj ijnej kenpaʼti konig i̱dada beʼyareaddene ettoneʼa̱ oʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","—‍Doʼtaj oknopo̱e̱nok oʼyareaddene. Dakda yahuatiʼ. —‍Jesúsa ettoneʼtaj onaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesúsa ettoneʼtaj eʼbatiaʼpakdeʼte Jairo hua̱i̱takeʼ jak huairien jakyaʼ huabokerekakon o̱kye̱yakpo, —‍O̱ʼnen huayetsiʼpo oʼbueyde. Huamanmadikaʼeritaj totiakhueʼ ya̱e̱ʼ. —‍Jairotaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jesús kenda oʼpe̱e̱po, —‍Meʼpukehueʼ ya̱e̱ʼ. Doʼhua oʼyareaʼapo meknopo̱e̱ʼ. O̱ʼnen hua̱yo̱bu oʼyaruda̱po. —‍Jesúsa Jairotaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jesús jakyo o̱kye̱depo, “Ettoneʼsiʼpoen hua̱ye̱ huaojere Pedroere Jacoboere Juanereyoʼda kuddik o̱ʼne. Nogomeynayo kudhueʼdik moʼe̱ne.” Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Huakkaʼ aratbut onʼkupopakdepo ettoneʼsiʼpo eʼbueytaʼ enʼbahuikte, —‍Huikhueʼ yaneʼ. Muneʼyo̱siʼpo bueyhueʼ o̱ʼe̱. Oʼtaypo o̱ʼe̱. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Jesústaj onʼpe̱e̱po onʼtierikpo ettoneʼsiʼpo kenpaʼda oʼbueydenigʼa oaʼ onʼnopo̱e̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jesúsnayo muneʼyoen huabaʼtaʼ oʼbaʼpadpo, —‍Yaboʼ, muneʼyo̱siʼpo. —‍Jesúsa ʼuttaʼda onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Keʼna oʼnoyhuaddepo i̱da oʼbodʼuyate. —‍Aypo yanʼyok. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","—‍Kenpihuay. —‍Muneʼyoen huaoj hua̱ye̱erea oʼdaʼuyate. —‍Kenda ijkay manbatiaʼpakhueʼ yaneʼ. Betapiʼ manbatiaʼpakhueʼ yaneʼ. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Doce huanigpe̱i̱kaʼeritaj Jesúsa “Intaʼ mogkupopak,” oʼmanaʼpo. Onʼkupopakdepo, “Doa oʼnonaʼnok nogda nogda dakhueʼ totoʼ noki̱re̱gtaj maendik moʼe̱a̱pone kenpaʼti ayaʼ aratbut dakhueʼ e̱e̱ʼ bayareaʼdik moʼe̱a̱pone.” Kenda Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Docetaj Jesúsa oʼmataʼmonaʼpo huadak huaʼa konig aratbut Dios Huairitaj oʼnoknopo̱e̱a̱pone onʼnigpe̱i̱kaʼapone. Kenda doce kanʼmanmadikeʼpo kenpaʼti dakhueʼtaj kanʼbayareʼpo docetaj Jesúsa oʼmataʼmonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","—‍Yanhuahuudhuahuikaʼpo dagte kaʼtepiʼ tohuahueʼ yanikatiʼ. Oteypaj tohuahueʼ yaneʼ. Cuperina yudtaj mantoahueʼ yaneʼ. Huenpu tohuahueʼ yaneʼ. Aypo tohuahueʼ yaneʼ. Huakupe tohuahueʼ yaneʼ. Nogtida ʼopiot yanʼot. Bottaʼ ʼopiot tohuahueʼ yaneʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Huakkaʼ jakyo boʼkuddepo ken jakyo huaboaʼda boʼtayapet ke̱yo̱yoʼda yanikatiʼ. Nogen jakyo huahueʼ yaneʼ. Ken huakkaʼ jakyaʼ enʼbahuadeʼte ke̱yo̱da yanikatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ken huakkaʼ jakyo opudomeytaj eʼpe̱e̱taʼ pakhueʼ e̱ʼneʼte ken huakkaʼ jakyaʼ yanʼbakhuaʼ. Bohuaʼdepo soroka eʼitimabette yanʼitihuekead. Ken huakkaʼ jak hua̱e̱ʼeriomey onʼtiahuaydepo onʼnopo̱e̱a̱po kenda o̱gkaʼde dakhueaʼda Diostaj o̱ʼe̱nok o̱gkaʼ onʼnopo̱e̱a̱po. —‍Jesúsa docetaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ken doce huanigpe̱i̱kaʼeri onʼbahuaʼudhuahuikaʼpo, nog huakkaʼ jakyo nog huakkaʼ jakyo onʼhuaʼpo huadak huaʼa onʼmanbatiaʼpakpo dakhueʼ hua̱e̱ʼeritaj onʼbayareaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herodes Roma hua̱e̱ʼeri gobierno huairi o̱ʼe̱po Jesústaj tiahuayhued o̱ʼe̱po kenda Jesús oʼkikaʼnig oʼtipe̱e̱depo huaboaʼda oʼnopo̱e̱po oʼmepuʼkepo Herodes Juantaj onʼhue̱renoktegʼuy. Juan eʼbueyada oʼnoyhuadmeʼte sueʼada onʼbatiaʼpaknok, Juan o̱ʼe̱ Jesústaj oʼtinopo̱e̱po oʼmepuʼkeʼuy Herodes. ");
INSERT INTO amrNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","“Diosen huamanbatiaʼpakeri Elíaskudak kurudya̱ʼ oʼhuarakdenok kentaj oʼtiahuayikay Jesús o̱ʼe̱taj.” Nogomeya̱ onʼbatiaʼpakpo, “Diosen huamanbatiaʼpakerikudak nogtida oʼnoyhuadmeʼte Jesús o̱ʼe̱taj.” Nogomeya̱ onʼbatiaʼpaknok Herodes oʼmepuʼkepo, ");
INSERT INTO amrNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","—‍Juantaj yanʼhue̱renokteg ijmanaʼmey. Jesústaj eʼmanbatiaʼpak ijpe̱e̱y. Jesús be ya̱ʼe̱. —‍Herodesa oaʼpo. Jesústaj aʼtiahuayaʼpo Herodesa oʼukʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Jesúsen doce huataʼmonaʼeri onʼkumejdepo kenda oʼkaʼmey Jesústaj oʼnonbatiaʼpakuyate. Ken doce huamataʼmonaʼeritaj oʼbatohuaʼuyate. Huakkaʼ jak Betsaidayon onʼbahuaʼpo kente aratbut ehueʼyo onʼbahuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Jesús oʼpokonde onʼtipe̱e̱po huakkaʼ aratbut huakkaʼ jakyaʼ onʼnokotondepo Jesústaj onʼtahuaʼuyate. Jesúsa oʼbaedpo kenpaʼti huadak huaʼa konig aratbut Dios huairitaj oʼnoknopo̱e̱a̱pone moʼnigpe̱e̱a̱pone Jesúsa oʼmanmadikaʼpo kenpaʼti aratbut dakhueʼ e̱ʼneʼte oʼbayareaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Huaboaʼ eʼsikonyakte Jesúsen doce huataʼmonaʼeria Jesústaj onʼhuahuaʼpo —‍I̱yo̱ katepiʼ jak ehueʼ o̱ʼe̱, aratbut ehueʼ o̱ʼne, aypo ehueʼ o̱ʼe̱, konige̱po huakkaʼ aratbut e̱gkupopakte kanʼtayeʼpo kanʼbapeʼpo huakkaʼ jakyo meyo̱hueʼda yamataʼmonaʼ. —‍Jesúsen doce huataʼmonaʼeria Jesústaj oʼnonaʼnigʼa, ");
INSERT INTO amrNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","—‍Opudomeya̱ aypo yanʼbayok. —‍Jesúsa docetaj oʼmanaʼuyate. —‍Ehueʼda to̱e̱hueʼda o̱ʼe̱y. Cinco panes dos biigyoʼda oʼto̱e̱y. Biig aypoere kanokayatueʼpo menpaʼ oroʼtaj eʼtaʼmonaʼtaʼ oʼtipak. —‍Docea Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ken, cinco mil huabokerek o̱ʼneʼuyatepiʼ. —‍Yanʼbahuad. Yanʼmanaʼ. Cincuenta huakupo huakupoaʼ yanʼbahuad yanʼmanaʼ. —‍Jesúsa huanigpe̱i̱kaʼeritaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Kenda onʼmanaʼnok ayaʼda onʼbahuadʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ken, Jesús huabaʼte cinco panes bottaʼ biigere oʼbapadpo kurudyo̱ oʼmabopo Diostaj dakiti oʼtionaʼpakdepo panes oʼposakeaʼpo biigkon okpukpukpo huanigpe̱i̱kaʼeritaj oʼbayokenok huanigpe̱i̱kaʼeriomeya̱ huakkaʼda aratbuttaj onʼbayokeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ayaʼada onʼbapeʼpo dapoteymeya̱ʼ o̱gkaʼuyate. Onʼbapeʼdepo doce kusogyo̱ huataʼsuj hueda̱ʼda onʼdohueaʼ, huaboroʼ huaenmo boroʼtaʼsujmonere onʼtihueda̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nogok nogmeʼnoete aratbut bahueʼyo huanigpe̱i̱kaʼeriereyoʼda Jesúsere o̱ʼnepo Jesúsa oʼtionaʼpakpo, oʼtionaʼpakdepo huanigpe̱i̱kaʼeritaj —‍¿Beʼa i̱jje̱ do? ¿Katiaʼ doʼtaj aratbuta menhuaikaʼ? —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","—‍Juan Bautista keʼna o̱ʼe̱. Sueʼada boʼhuaaʼikaʼne. Noga̱ Elías keʼna o̱ʼe̱. Boʼhuaaʼikaʼne. Nogomeya̱ nogtida Diosen huamanbatiaʼpakerikudak aʼnennada o̱ʼu̱yatenig, oʼnoyhuadde, kena o̱ʼe̱. Boʼhuaaʼikaʼne. —‍Huanigpe̱i̱kaʼeria Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","—‍¿Opuda̱ katedik o̱ʼe̱ doʼtaj onʼtinopo̱e̱? —‍Jesúsa huanigpe̱i̱kaʼeritaj oʼmanaʼnok. —‍Diosen Cristo i̱ʼe̱ne. Diosa kurudya̱ʼ ontaj metaʼmonaʼuyne. —‍Pedroa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","—‍Kenda Pedroa huaboaʼda menaʼnig manahueʼ yaneʼ. —‍Jesúsa i̱ghuaʼda oʼmanaʼuyate. Kenpaʼti ");
INSERT INTO amrNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","—‍Do huabokerek i̱jje̱po Diosyaʼ ijtiakuy. Huakkaʼda paiʼda ijnopoʼe̱a̱poy. Judío huairitoneʼ, sacerdote huairi, kenpaʼti Moisésenbaʼ huamanmadikaʼeriere doʼtaj pakhueʼ o̱ʼnepo menʼarakapone. Bapaʼmeʼnoe eʼpokdeʼte Diosa meʼnoyhuada̱ʼapone. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ayaʼtada oʼmanaʼpo, —‍Beʼapiʼ doʼhued eʼmanmadikaʼ eʼkaʼtaʼ eʼpaknayo katepiʼ hua̱ʼenda onʼpak onaʼti eretpakhueʼ kaʼneʼ. Onaʼti doʼhuedyoʼda kanʼpakikeʼ. Konig cruzte paiʼda ijnopoʼe̱a̱poy konigti kenomeya̱kon paiʼda kanʼnopoʼe̱ʼ. Kenpaʼti doʼtaj doʼhued enʼmanaʼtaj menʼnigpe̱i̱keʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Kenomey kenpaʼda hua̱ʼenda onʼpakpo Cristoere kurudyo̱ onteʼti noeonhuahuikahueʼ o̱ʼneapo. Kenomey kenpaʼda hua̱ʼenda pakhueʼ o̱ʼnepo, Diostayoʼda eʼnigpe̱e̱taʼ huakkaʼ onʼpakpo onteʼti Diosere o̱ʼneonhuahuikaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Beʼapiʼ huabokerek katetapiʼ huakkaʼtaʼda onʼeretpakpo onʼbaeʼikaʼpo doʼtaj eʼnigpe̱e̱taʼ pakhueʼ o̱ʼnepo kenpaʼda onʼbueyapo. Diosyo noeonhuahuahueʼ o̱ʼneapo. Huakkaʼ onʼmato̱e̱po Diosyo huahueʼdik o̱ʼneapo. ");
INSERT INTO amrNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Doʼtaj eʼnokbiraʼnayo kenpaʼti doʼhued eʼmanmadikaʼtaj enʼtobiraʼnayo nogok do ijtiakdepo kenomeytakon ijbakbiraʼapoy. Huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne konig Apag Dios huakhuairionig i̱jje̱po, ʼuruaʼda i̱jje̱po, Diosyaʼ kurudya̱ʼ ijhuarakdepo kenomeytakon ijbakbiraʼapoy. Kenpaʼti ijhuarakdepo konig Diosen huataʼmonerionig ʼuruaʼda i̱jje̱a̱poy. ");
INSERT INTO amrNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Opudomey sueʼda i̱yo̱ moʼe̱nigʼa bueyhued moʼe̱po huakkaʼtada Dios Huairitaj eʼnoknopo̱i̱kaʼte enʼnigpe̱i̱kaʼte moʼbaʼtiahuayapet. Buttida ijjay. —‍Jesúsa ayaʼtada oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Jesúsa kenda eadeʼte ochopiʼ huameʼnoe eʼpokdeʼte Jesús oteʼyo oʼbehuikpo aʼtionaʼpakyaʼpo oʼbehuikpo Pedroere Jacoboere Juanere onʼbehuikʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Jesúsa oʼtionaʼpakdepo Jesúsen huakok kokeyda o̱ʼe̱tuy kenpaʼti yudtaj keregnada o̱ʼe̱tuy kenpaʼti senogda o̱ʼe̱tuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ken kentaʼ Jesústaj bottaʼ huabokereka onʼbopo onʼbatiaʼpakpo adhueaʼpaneʼ Moiséskudak kenpaʼti adhueaʼpaneʼ Elíaskudakere onʼbatiaʼpakpo ");
INSERT INTO amrNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ʼuruaʼda konig jeynanada o̱ʼnepo ken konig Jesús paiʼda oʼnopoʼe̱a̱po Jerusalénya̱ʼ kenpaʼti ken konig oʼbueyapo onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pedromey diga̱ʼda taytayaʼ eʼada tayhueʼ o̱ʼnepo Jesústaj onʼtiahuaypo Jesústaj ʼuruaʼda jeynanada onʼtiahuaypo. Kenpaʼti nog bottaʼ huabokerektaj onʼtiahuaypo Jesúsere e̱ʼneʼte onʼbatiahuayʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Huabokereka Jesústaj eʼnokhuaʼdeʼte —‍Oroʼ i̱yo̱ o̱ʼe̱po huadakda o̱ʼe̱. Bapaʼ bak oʼkaiʼ. Ontehuapaʼ nogtida Moiséstaj nogtida kenpaʼti Elíastaj nogtida bak oʼkaiʼ, Huamanmadikaʼeri. —‍Pedroa Jesústaj onaʼuyate. Pedroa koniga̱ʼ oaʼ nopo̱e̱hueʼada oaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Pedro kenda eadeʼte e̱ʼsi̱hui̱ʼa̱ kenomeytaj oʼbatibukʼuyate, Eʼbatibukte onʼmeʼpukpo. ");
INSERT INTO amrNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","E̱ʼsi̱hui̱ya̱ʼ onʼpe̱e̱po, —‍In doʼhued Huasiʼpo meʼta̱e̱ne. Huadiʼda meʼta̱e̱ne kentaj yanʼpe̱e̱ʼ. Ken e̱ʼsi̱hui̱ya̱ʼ onʼpe̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Kenda Diosa eadeʼte Jesústayoʼda onʼtiahuayʼuyate. Soatayoʼ o̱ʼnepo kenda huaboaʼda onʼtiahuaydenig batiaʼpakhueʼ o̱ʼneonhuahuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Emeʼte oteʼyaʼ Jesúsomey eʼhuarakdeʼte huakkaʼada aratbut Jesústaj onʼhuahuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Huakkaʼada aratbut e̱gkupopakyo nogtiada huabokereka ʼuttaʼda onaʼpo: —‍In doʼhued nogsiʼpotida meʼta̱e̱nig yatiahuayʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Totoʼa oʼnopoʼto̱e̱nok oʼsagkiaʼikaʼ, oʼiriga̱ʼikaʼ, huakittayaʼ kutajpoaʼ o̱ʼo̱ro̱kikaʼpo, kenpaʼti huasiʼpotaj diga̱ʼda o̱gkadhuahuikaʼpo e̱ʼenontaʼ pakhueʼ o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","“Totoʼtaj yantaʼmonaʼ.” O̱ʼnen huanigpe̱i̱kaʼeritaj ijmanaʼdenigʼa okenhueʼdik o̱ʼnemeʼ, Huamanmadikaʼeri. —‍Huabokereka ʼuttaʼda Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","—‍Opudomey aratbut oknopo̱e̱hueʼ hua̱e̱ʼeri moʼe̱po, dakhueaʼda moʼi̱kaʼne. Opudere huakkaʼda huameʼnoe i̱kahueʼdik i̱jje̱a̱poy. Opudomeytaj nogok nogok pe̱e̱hueʼdik i̱jjeonhuahuikaʼapoy. O̱ʼnensiʼpotaj yatotiak. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Huasiʼpoa Jesústaj eʼhuahuadeʼte totoʼa barakte o̱ʼhue̱kanpo oʼiriga̱ʼuyate. Totoʼtaj, —‍Kejeʼ, kenpaʼda yakhuatiʼ. —‍Jesúsa totoʼtaj enadeʼte huasiʼpotaj oʼyareadʼuyate. Huasiʼpo huadakda e̱ʼundeʼte keʼnen huaojtaj oʼyokuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","—‍Kenpihuay ijjay, Dios kutayo huaboroʼda o̱ʼe̱po ʼuruaʼda o̱ʼe̱po konig teyda oʼkikaʼ. —‍Ayaʼada onʼbatiaʼpakʼuyate. Ken ʼuruaʼda Jesúsa oʼkikaʼnok ayaʼada, “Kenpihuay,” enʼbatiaʼpakte huanigpe̱i̱kaʼeritaj, ");
INSERT INTO amrNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—‍Dakaʼ yanʼpe̱e̱ʼ. Okkahuehueʼ yaneʼ. Do huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne. Doʼtaj huairiomeytaj menyokapone. Huairiomeya̱ doʼtaj dakhueaʼda kaʼnogkeʼpo menyokapone. —‍Jesúsa huanigpe̱i̱kaʼeriomeytaj oʼmanaʼnigʼa ");
INSERT INTO amrNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","huanigpe̱i̱kaʼeri nopoenkahueʼ o̱ʼnenok konig Diosa oʼmaki̱re̱ga̱ʼpo manopoenkahueʼ oʼmaeaʼnok. “¿Monig ya̱ʼe̱?” Anaiʼ eʼnopo̱a̱da onmeʼpukpo onahueʼ o̱ʼneʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","“¿Oroʼomeya̱ beʼata hueret huairida e̱ʼdik ya̱ʼe̱a̱po?” Ken huanigpe̱i̱kaʼeria huayahuaya onʼbatiaʼpaknigʼa ");
INSERT INTO amrNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","kenda huanigpe̱i̱kaʼeri huanopoyaʼ onʼnopo̱e̱nig Jesúsa oʼnopo̱e̱. Huasiʼpotaj oʼto̱e̱po oʼboaʼpo ");
INSERT INTO amrNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","oʼmanaʼpo, —‍In huasiʼpo ehueʼ o̱ʼe̱ moknopo̱e̱ne. In huasiʼpotaj beʼapiʼ eeʼnayo do ijpaknok eeʼnayo konigti doʼtaj eʼdik moʼe̱ne kenpaʼti beʼapiʼ doʼtaj oʼdeapet doere doʼhued Apageretaj oʼdeapone. Doʼhued Apaga̱ meʼtaʼmonaʼuyne. Huasiʼpotaj huatihuapokeri konig hueret huairida o̱ʼne Diosnayo oʼnopo̱e̱. —‍Jesúsa huanigpe̱i̱kaʼeritaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","—‍Huabokerektaj eʼtiahuaydeʼte, keʼna o̱ʼnendik oʼdikkaʼpo totoʼtaj oʼmaenikaʼ, “Kejeʼ, kahueʼ ya̱e̱ʼ.” Oroʼa onaʼnok kenbokereka oroʼere huahueʼ o̱ʼi̱kaʼnok. —‍Juana Jesústaj onaʼnigʼa. ");
INSERT INTO amrNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","—‍Ken huabokerektaj “Kahueʼ ya̱e̱ʼ,” onahueʼ yaneʼ. Ken aratbuta oroʼomeytaj dakhueaʼ e̱gkaʼtaʼ pakhueʼ o̱ʼnepo oroʼomeytaj boʼtihuapokne. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Aʼti kurudyo̱ ijhuaʼapoy Jesús oʼnopo̱e̱po “Jerusalényo̱ ijhuaʼapoy,” meʼpukhueʼada ʼuruaʼda oʼnopo̱e̱depo ");
INSERT INTO amrNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","huakkuruda menigtayoʼda oʼmataʼmonaʼuyate. Samaria huadaribayo huakkaʼ jakyo oʼmataʼmonaʼuyate huatay jak kanʼukeʼpo. ");
INSERT INTO amrNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Jesús Jerusalényo̱ oʼhuaʼnok Samaria huakkaʼ jakyo hua̱e̱ʼeria Jesústaj i̱yo̱ yatayaʼ manahueʼ o̱ʼneʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jacobo Juanere Jesúsen huanigpe̱i̱kaʼeri kenda onʼpe̱e̱depo, —‍¿Konig Elíaskudak Diosen huamanbatiaʼpakeria oʼkaʼuyate, kenomeytaj Samariayo hua̱e̱ʼeritaj konigti kanʼmameyye̱ʼpo taʼak kurudya̱ʼ kakoteʼ oroʼomeya̱ enaʼtaʼ menpaʼ on iʼpak, Huairi? —‍Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesúsa oʼbatiahuayatupo Jacobotaj Juaneretaj oʼmanaʼpo, —‍Namaʼda moʼnopo̱e̱ne, ken konig nopo̱e̱hueʼ yaneʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Do huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne. Aratbuttaj aʼbarakyaʼpo tiakhueʼ i̱jje̱ʼuy. Aratbuttaj aʼmanopoʼyareayaʼpo ijtiakuy. —‍Jesúsa oʼmanaʼuyate. Ken nog huakkaʼ jakyokon onhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ken dagte onʼhuaʼpo Jesústaj —‍Meyo̱piʼ iʼhuaikaʼapo o̱ʼnen huanigpe̱i̱kaʼeri e̱e̱ʼtaʼ ijpaki. Etaʼhuaʼikaʼtaʼ ijpaki, Huairi. —‍Huabokereka Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","—‍Nubakuhued huakog o̱ʼta̱i̱kaʼ. Bakoyen kenpaʼti huapak o̱ʼta̱i̱kaʼ. Do huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne. Konige̱po donayo jak to̱e̱hueʼ i̱ji̱kay. Nog jakyo nog jakyo ijtayʼikay. —‍Jesúsa huabokerektaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","—‍Betaʼhuaʼ. —‍Jesúsa nogtaj onaʼnigʼa, —‍Aʼti, huakkuru huaojtoneʼtaj dakaʼ toenʼdik i̱jje̱a̱poy. Kenpaʼti eʼbueydeʼte kubarakkaʼdik i̱jje̱a̱poy. —‍Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","—‍Kejeʼ. Huabot oknopo̱e̱hueʼyaʼ hua̱e̱ʼeria nog oknopo̱e̱hueʼ hua̱e̱ʼeritoneʼtaj dakaʼ kanʼto̱i̱ke̱ʼ kenpaʼti kanʼkubarakkeʼ. Onnayo yahuatiʼ. Huadak huaʼa konig aratbut Dios Huairitaj oknopo̱e̱ʼdik kenpaʼti nigpe̱e̱dik kaʼneʼpo yamanbatiaʼpakikaʼ. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","—‍Huaboaʼda ontaj etaʼhuaʼtaʼ eʼpakada, Huairi huakkuru huabettaj “Ijhuay,” aʼmanaʼtuyaʼpo jakyo eʼhuaʼtutaʼ ijpaki. —‍Noga̱ Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","—‍Aratbut huaboaʼda Diostaj oʼnoknopo̱e̱po onʼnigpe̱e̱po batikhueʼda nigpe̱e̱ʼdik o̱ʼne. Ken konig ʼikken o̱gkikaʼuy onteʼti ken konig nopo̱e̱hueʼdik o̱ʼnikaʼapo. Diostaj oʼnoknopo̱e̱po onʼnigpe̱e̱po eʼbatiknayo konig o̱gkikaʼuy onteʼti eʼnopo̱i̱kaʼnayo nogomey Dios Huairitaj huaknopo̱e̱ʼ kenpaʼti huanigpe̱e̱ʼ tihuapokhueʼdik o̱ʼneapo. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nogok Jesús Huairia oʼbaktieʼeaʼpo nog setenta huanigpe̱i̱kaʼeritaj oʼbaktieʼeaʼpo huakkuru bottaʼ bottaʼtaj oʼmataʼmoneaʼuyate. Nog huakkaʼ jak nog huakkaʼ jakyo oʼmataʼmoneaʼpo aʼti Jesúsakon taʼpotaʼ oʼhuaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","—‍Huakkaʼada Diostaj yanoknopo̱e̱a̱pet yanʼnigpe̱i̱kaʼapet sueʼada huabokereka Dios Huairitaj huamaknopo̱e̱a̱ʼeri o̱ʼne. Dios Huairitaj yanʼtionaʼpakikaʼ. Dios Huairia huamaknopo̱e̱a̱ʼeritaj kamataʼmoneʼ yanʼtionaʼpakikatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Yanhuatiʼ. Opudomey konig ovejasiʼponig moʼe̱nok konig dubakuhuaenbanopoyonig moʼe̱a̱po. Konig dubakuhuaa ovejasiʼpotaj onʼarakikaʼ kenpaʼti aratbuta opudomeytaj konigti mogkaʼapetdapiʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Yudtaj kutamate tohuahueʼ yaneʼ. Huakupe huamanto̱e̱piʼ tohuahueʼ yaneʼ. Nogda huaʼiotpiʼ tohuahueʼ yaneʼ. Aratbuta dagte eʼdejpiʼ batiaʼpakonhueʼ yaneʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Ken jakyo boʼkuddepo huakkuruda “Opudomeytaj Diosa moʼnopoʼyareʼ,” yanʼtionaʼpaktiʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ken jakyaʼ aratbut enʼnopoʼyareaʼtaʼ enʼpaknayo kanʼnopoʼyareʼ. Eʼnopoʼyareataʼ pakhueʼ e̱ʼneʼnayo kenda huaboaʼda yanʼtionaʼpakdeʼpo kejeʼ yanʼmanatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ken jakyo boʼkudapet ke̱yo̱yoʼda yanikatiʼ. Kenda aypo boʼyokapetnig yanʼbapikatiʼ. Kenda hue̱ʼe̱y boʼyokapetnig yanʼmayi̱katiʼ. Nogen eʼbaaʼnayo dakhuapa aypopiʼ bayokikaʼdik moʼi̱kaʼapone. Ken nog jakyo nog jakyo huaʼehueʼ yanikatiʼ. Ken jakyo huakkuru boʼkudapet, ke̱yo̱da yanikatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Huakkaʼ jakyo eʼkuddeʼte aratbuta opudtaj boʼeddepo kenda aypo boʼyokapet, yanʼbapikatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ke̱yo̱ huakkaʼ jakyo eʼkuddeʼte dakhueʼ e̱ʼhua̱e̱ʼtaj yanʼbayareaʼikatiʼ. “Huadak huaʼa konig Dios Huairi meyo̱hueʼda o̱ʼe̱denok opudomeya̱ oy yanoknopo̱e̱ʼ.” Yanʼmanatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kenokaʼ huakkaʼ jakyo eʼkuddeʼte opudomeytaj eeʼtaʼ pakhueʼ e̱e̱ʼnayo yanbakhuatiʼ. Jakyaʼ yanʼbakhuaʼdepo, ");
INSERT INTO amrNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Oroʼomeytaj pakhueʼ moʼe̱nok opudomeyen huakkaʼ jak kurutaʼ sorok oroʼen huaʼitaʼ eʼtibette oroʼa oʼtihuekeay. Huadak huaʼa konig Dios Huairi meyo̱hueʼda o̱ʼe̱denok oyedda yanoknopo̱e̱ʼ.” Yanhuaʼdepo yanʼmanatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nogok dakhueaʼ huakkaʼeri ayaʼtada Diosa keʼpoda castiga oʼmagkaʼapo. Kenokaʼ ken jak hua̱e̱ʼeria opudomeytaj ehueʼ moeʼu̱ynigtaj kenomeytataj keʼponanada castiga oʼmagkaʼapo. Sodomatanayo sueʼda castiga oʼmagkaʼuyate. —‍Jesúsa setenta huaknopo̱e̱ʼeritaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","—‍Huakkaʼ jak Corazín hua̱e̱ʼeria paiʼda moʼnopoʼe̱a̱pone. Kenpaʼti huakkaʼ jak Betsaida hua̱e̱ʼeria paiʼda moʼnopoʼe̱a̱pone. Opudomeyen jakyaʼ Diosa teyda oʼkameʼnigʼa ʼuruaʼda oʼkameʼnigʼa oʼbayareameʼnigʼa, opudomeynayo nopoʼkoreahueʼ moʼe̱meʼne. Konig Betsaida huakkaʼ jakyaʼ kenpaʼti Corazínya̱ʼ Diosa ʼuruaʼda oʼkameʼ kenpaʼti teyda oʼkameʼ konigti Tiro huakkaʼ jakyaʼ Sidón huakkaʼ jakyaʼkon Diosa ʼuruaʼda e̱gkaʼnayo kenomeya̱ i̱da yanʼmanopoʼkoreaʼuyyetnigʼa kenpaʼti paiʼda o̱ʼneaʼ aratbuttaj moknopo̱e̱po saconig yanʼotayʼuyyetnigʼa. ");
INSERT INTO amrNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Nogok kenokaʼ Diosa ayaʼtada aratbuttaj dakhueaʼ huakaʼeritaj castiga oʼmagkaʼpo Tiro hua̱e̱ʼeritaj Sidón hua̱e̱ʼerieretaj sueʼda castiga oʼmagkaʼapo. Opudomeytanayo diga̱ʼda castiga mogkaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Opud Capernaum huakkaʼ jakyo hua̱e̱ʼeri “Huadakda o̱ʼe̱y.” Moʼnopo̱e̱nigʼa, “Kurudyo̱ oʼhuaʼapoy.” Moʼnopo̱e̱nigʼa. Kubarakyoyoʼda boʼhuaʼapone. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","—‍Ayaʼada opudomeytaj eʼnigpe̱e̱ʼnayo doʼtaj onʼnigpe̱e̱a̱po. Ayaʼda opudomeytaj pakhueʼ e̱e̱ʼnayo doʼtaj pakhueʼ o̱ʼne. Kenpaʼti ayaʼda doʼtaj pakhueʼ e̱e̱ʼnayo Diostaj pakhueʼ o̱ʼne. Diosa meʼtaʼmonaʼuyne. —‍Jesúsa setentataj oʼmanaʼdenok setentaakon oʼnokbahuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nogok setenta huanigpe̱i̱kaʼeri onʼkumejdepo durugteda onʼkumejpo, —‍O̱ʼna boʼteypakaʼnok totoʼa oroʼtaj moʼnigpe̱e̱po bokbahuameʼne, Huairi. —‍Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","—‍Diosa totoʼ huairitaj oʼenmeʼ kurudya̱ʼ, ijtiahuaymey. Konig o̱jbed i̱dada kurudya̱ʼ oʼkotonmeʼ. Totoʼ kurudya̱ʼ barakyo okotmeʼte. ");
INSERT INTO amrNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Doʼhua yonaʼnok bihuitaj tugdik kenpaʼti toʼtidtaj tugdik kenpaʼti totoʼtaj gana o̱gkaʼdik moʼe̱po bihuia toʼtidapiʼ totoʼapiʼ opudomeytaj sigpiʼ diga̱ʼ noeyanhueʼdik moʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Kenda huadakda o̱ʼe̱nigʼa totoʼ opudomeytaj moʼnigpe̱e̱meʼtenok durugpakhueʼ yaneʼ. Diosensiʼpo moʼe̱nok kurudya̱ʼ opudendik Diosa eʼtimadoyaʼdeʼ moʼte̱ne Diosere oʼnoeonhuahuikaʼapoy. Kenda yanʼnopo̱e̱po yanʼdurugpak. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Diosen Noki̱re̱ga̱ oʼnopoʼto̱e̱nok Jesúsa oʼdurugpakpo Diostaj, —‍Kurudyo̱ hua̱e̱ʼeri Huairi i̱ʼe̱ne kenpaʼti huadariyo hua̱e̱ʼeri Huairi i̱ʼe̱ne, Apag Dios. Huaboaʼda setentataj iʼbateypakameʼnig kenda suhueʼda huanopo̱e̱ʼeritaj iʼmaʼnopo̱e̱a̱ʼne Apag Dios. Kenda huakkaʼ huanopo̱e̱ʼeritanayo manopo̱e̱a̱hueʼ i̱ʼe̱ne. Kenda iʼpakpo ʼuruaʼda iʼkaʼde. —‍Apag Diostaj Jesúsa oʼtionaʼpakpo, ");
INSERT INTO amrNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","—‍Doʼhued Apaga beʼteypakaʼuyne, meʼnopo̱e̱a̱ʼuyne. Ayaʼda beyokuyne. Do Diosen Huasiʼpo o̱ʼe̱, Apag Diosayoʼda moknopo̱e̱a̱ʼne. Konig Apag Dios o̱ʼe̱po, konig oʼnopo̱e̱, konig Apag Dios oʼkaʼ doʼhuayoʼda ijnopo̱e̱y kenpaʼti kenomeytaj doʼhua Diosen Huasiʼpoa ijmaknopo̱e̱a̱y. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Huanigpe̱i̱kaʼeritaj oʼbatiahuayʼepo, —‍Opudomey doʼhued huanigpe̱i̱kaʼeri moʼe̱po doʼtaj Diosen Huasiʼpotaj onʼtiahuaypo durugda moʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Aʼnenda huakkaʼ Diosen huamanbatiaʼpakeria kenpaʼti huadaribayo huairierea do Diosen Huasiʼpotaj eʼtiahuaytaʼ menʼpakuyatenigʼa tiahuayhueʼ meʼnuyne. Kenpaʼti doʼhued eʼmanmadikaʼ eʼpe̱e̱taʼ onʼpakuyatenigʼa pe̱e̱hueʼ meʼnuyne. —‍Jesúsa huanigpe̱i̱kaʼeritayoʼda oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ken Moisésenbaʼ eʼmanaʼ huamanmadikaʼeri oʼbodpo, Jesústaj oʼhuahuaʼpo Jesúsa namaʼdapiʼ kaeʼpo, —‍¿Diosere aʼnoeonhuahuikayaʼpo kate kaʼdik i̱jje̱? —‍Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","—‍¿Kateaʼ Moisésbaʼ yaʼmadoyaʼuyate? ¿Monig iʼtiahuay? —‍Jesúsa onaʼuyate. Moisésenbaʼ huamanmadikaʼeritaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","—‍Dios Huairitaj diʼ yanikaʼ. Huanopoʼa huakkaʼda yanʼpakpo Diostaj diʼ yanikaʼ. Noki̱re̱ga̱ huakkaʼda yanʼpakpo Diostaj diʼ yanikaʼ. Hua̱so̱ʼa̱ teyda ya̱ʼnepo Diostaj diʼ yanikaʼ. Eʼnopo̱i̱kaʼ ya̱ʼderetpakpo Diostaj diʼ yanikaʼ. Kenpaʼti konig huataʼ diʼ i̱ʼe̱ konigti nog aratbuttaj diʼ yanʼmaikaʼ. —‍Moisésenbaʼ huamanmadikaʼeria Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","—‍Buttida iaʼ. Kenda ekaʼnayo Diosere iʼnoeonhuahuikaʼapone. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Huadakda onaʼ aratbut kanʼnopo̱e̱deʼpo Jesústaj onaʼ, —‍¿Betataj diʼ maeʼdik i̱jje̱? —‍Moisésenbaʼ huamanmadikaʼeria onaʼnok. ");
INSERT INTO amrNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","—‍Nogbokerektida Jericó huakkaʼ jakyo dagte oʼhuaeʼuyate. Judío aratbut o̱ʼe̱po Jerusalénya̱ʼ Jericóyon oʼhuarakpo dagte eʼhuaʼete sueʼda huabereeria onʼhuahuaʼpo, oʼnogkaʼpo, onʼbitbitpo, ayaʼda oʼnokbakayaʼpo yudtakon oʼnokbakayaʼpo dagte ken huabokerektaj oʼnenonpo oʼnokbahuaʼuyate. Keʼna judío huabueyʼdikte dagte onpahueduyate. ");
INSERT INTO amrNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Aʼti judío sacerdote ken dagte oʼhuaʼepo judío huabokerek enpahuedtaj eʼtiahuayada dagte adpenda okpokonʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nog huabokerekkon oʼhuaʼepo keʼna Leví aratbut e̱e̱ʼtada, oʼhuaʼepo kente enpahuedte eʼtiahuayada keʼnakon okpokonʼuyate. Leví aratbut Diosen jakyaʼ onʼbaaʼikaʼuyate. Ken enpahuedte eʼtiahuayada okpokonʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nog huabokereknayo judío ehueʼ Samaria hua̱e̱ʼeri o̱ʼe̱po Samaria hua̱e̱ʼeri judío hua̱e̱ʼeritaj diʼ maehueʼ o̱ʼnikaʼ. Ken Samaria hua̱e̱ʼeri dagte oʼhuaʼepo judío enpahuedte oʼtiahuayatoʼpo oʼtinepahuiʼpo ");
INSERT INTO amrNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","oʼhuahuaʼpo, huaentaj ʼurusihuada vinoere okhuekeʼedepo huakbetakon oʼtinukuʼdepo keʼnen mulayo oʼbehuikaʼpo huatay jakyo oʼtohuaʼdeʼuyate. Ke̱yo̱ dakaʼ oʼto̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Emeʼte ken Samaria hua̱e̱ʼeri ahuaʼdeyapo bottaʼ huakupe kutamayo oʼtokdepo jak huato̱e̱ʼeritaj oʼyokpo “In judío huabokerektaj dakaʼ yato̱e̱ʼ. Nogda huakupe eʼpaknayo aʼti ijkumejdepo oʼyokapone.” Samaria hua̱e̱ʼeria onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ken huabokerektaj huabereeria oʼnogkaʼuyate, bapaʼ huabokereka onʼtiahuayʼuyatenigʼa, ¿Beʼata diʼ o̱ʼu̱yate? —‍Jesúsa Moisésenbaʼ huamanmadikaʼeritaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","—‍Keʼna oʼtinepahuiʼpo okbetbetpo oʼtinukuʼuyate. Keʼna diʼ o̱ʼu̱yate. —‍Ken Moisésenbaʼ huamanmadikaʼeria Jesústaj onaʼnok, —‍Yahuatiʼ. Konigti yakikatiʼ. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesúsa onteʼti oʼhuaʼudhuahuaʼpo huanigpe̱i̱kaʼeriere oʼhuaʼuyate. Huakkaʼ jakyo oʼkuddepo ettoneʼ oʼdikkaʼ Martaa keʼnen jakyo katayeʼpo oʼedʼuyate Jesústaj. ");
INSERT INTO amrNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martaen huamaʼbuy María Jesústaj dakaʼ aʼnigpe̱e̱a̱yaʼpo Jesúsen huaʼitaʼpote oʼhuadʼuy. ");
INSERT INTO amrNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Martanayo huakkaʼ oʼbaaʼpo kenpaʼti huakkaʼda kaʼdik i̱jje̱y oʼnopo̱e̱po oʼmepuʼkepo Jesústaj oʼhuahuaʼpo, —‍Doʼhued huamaʼbuya doʼtaj tihuapokhueʼ meʼe̱ne. Nogtiaʼda ayaʼda ijkay. Doʼhued huamaʼbuya doʼtaj tihuapokdik o̱ʼe̱. Kenpaʼ iʼnopo̱e̱t. “Martataj yatihuapok.” Maríataj yanaʼ, Huairi. —‍Martaa Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","—‍Nogda nogda huakkaʼda iʼkaʼpo iʼmepuʼkeʼnigʼa, Marta. ");
INSERT INTO amrNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Kenyoʼda doʼtaj eʼnigpe̱e̱ʼ huadaknanada o̱ʼe̱. Kenda o̱ʼnen huamaʼbuy María oʼpak. Doʼtaj eʼpe̱e̱taʼ oʼpak. Kenda huadaknada o̱ʼe̱. Beʼapiʼ doʼhueddik okdikkayhueʼdik o̱ʼne. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nogok bebahueyaʼ Jesúsa oʼtionaʼpakonhuaʼdepo oʼbatikdenok, —‍Juan Bautista keʼnen huanigpe̱i̱kaʼeritaj oʼmanmadikaʼpo huationaʼpak oʼmanmadikaʼuyate. Konig Juan oʼmanmadikaʼuyate konigti oroʼomeytaj monʼmadikaʼ, Huairi. —‍Nogtiada Jesúsen huanigpe̱i̱kaʼeria Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","—‍In konig yanʼtionaʼpaktiʼ: Oroʼen Apag i̱ʼe̱ne, Apag Dios. Kurudyo̱ i̱ʼi̱kaʼpo kenpaʼda huadakda i̱ʼi̱kaʼne. O̱ʼnendik kenpaʼda huadakda o̱ʼe̱. Huairi i̱ʼe̱nok i̱da ayaʼada ontaj moʼnigpe̱i̱keʼ. Dios Huairi i̱ʼe̱po ayaʼda iʼpakpo iʼmanikaʼ. Kurudyo̱ hua̱e̱ʼeria moʼnigpe̱i̱kaʼpo o̱gkikaʼ konigti i̱yo̱ huadariyo ayaʼada huakaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Inmeʼnoete aypo oroʼtaj aʼnigya̱ya̱ʼpo boʼtihuapok. ");
INSERT INTO amrNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Oroʼomeyen dakhueaʼ eʼkaʼ bokkahueaʼ kenda oroʼtaj dakhueaʼ mogkameʼnigtaj oroʼakon oʼbakkahueaʼdemey. Ke̱ya̱ʼ dakhueaʼda o̱gkikaʼ ke̱yo̱ toahueʼ moeʼ. Oroʼ namaʼda eʼkaʼtaʼ eʼpaknayo dakhueaʼ kahueʼ o̱e̱i̱ʼ boʼtihuapok, Apag Dios, ken. —‍Jesúsa eʼtionaʼpak oʼmanmadikaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Jesúsa nogi̱ti oʼmanmadikaʼpo, —‍Opudomey nogtipiʼ sikyo nopokaʼ huadiʼen jakyo eʼhuaʼnayopiʼ. “Doʼhued jakyo bidtaʼda doʼhued huadiʼ o̱kye̱denigʼa aypobayoʼ i̱jje̱po aypo yokhueʼdik i̱jje̱po sueʼda aypo beyok.” Keʼna enaʼnayo ");
INSERT INTO amrNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","keʼnen huadiʼ jakyo o̱ʼe̱po, “Aypo beyok. Onnahueʼ meeʼ. Yokhuikdey. Doʼhuedsiʼpoere doere oʼtayʼi. Aypo aʼyokyaʼpo eʼmabotaʼ pakhueʼ i̱jje̱y.” Keʼna yaapetpiʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Oroʼen huadiʼ e̱ʼe̱a̱da sikyo nopokaʼ aypo yokhueʼ meʼe̱ne. “Aypo beyok” oroʼomeya̱ batikonhueʼda onaʼbednok kanʼbatikeʼpo sikyo nopokaʼ aypo boʼyokapone. Katepiʼ aypo oʼpaki boʼyokapone. ");
INSERT INTO amrNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","In oʼnonaʼnig eʼtionaʼpak oʼnonmadikaʼne. Katepiʼ boʼpakpo, “Beyok.” Diostaj yanʼtionaʼpakikaʼ. Diosa boʼyokapone. Katepiʼ boʼpakpo, yanʼtionaʼpakikaʼpo yaduk, batikhueʼda boʼukpo boʼhuahuaypo, moʼto̱e̱a̱pone. Ijtiaki, menigokhuikeʼ konig Diostaj eʼtionaʼpak o̱ʼe̱nok Diosa moʼnigokhuikeʼapone. ");
INSERT INTO amrNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Konig boʼpakpo, “Beyok.” Diostaj eʼtionaʼpaknayo Diosa boʼyokapone. Katepiʼ boʼpakpo boʼtionaʼpakpo eʼuknayo batikhueʼda eʼuknayo boʼhuahuaypo moʼto̱e̱a̱pone. “Ijtiaki, menigokhuikeʼ,” eʼtionaʼpakikaʼnayo Diosa moʼnigokhuikeʼapone. ");
INSERT INTO amrNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Apag Diostaj eʼtionaʼpak in konig o̱ʼe̱. Huasiʼpo katetapiʼ onʼpakpo huaojtaj “beyok” oʼnonaʼikaʼ. Kenda eaʼte boʼyokikaʼapone. “Pan beyok,” huasiʼpoa enaʼnayo huaoa huid yokhueʼ o̱ʼe̱a̱po. Panda beyokapone. “Biig beyok,” huasiʼpoa enaʼnayo huaoa bihui yokhueʼ o̱ʼe̱po biigda beyokapone. ");
INSERT INTO amrNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","“Huatahuaokda beyok,” huasiʼpoa enaʼnayo huaoa toʼtid yokhueʼ o̱ʼe̱po huatahuaokda beyokapone. ");
INSERT INTO amrNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Dakhueaʼ huakaʼeri e̱e̱ʼpiʼ huasiʼpotaj katepiʼ huadaknada moʼbayokikaʼne. Opuden Apag Dios kurudyo̱ o̱ʼi̱kaʼ huadaknada o̱ʼe̱po ʼuruaʼda boʼyokapone. “Diosen Noki̱re̱g beyok.” Eʼtionaʼpaknayo boʼyokapone. —‍Kenda Jesúsa huationaʼpakonhuaʼ oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Nogok huabokerek o̱ʼe̱ʼuyate. Totoʼa oʼnopoʼto̱e̱nok aʼpakhueʼdik o̱ʼu̱yate. Jesúsa totoʼtaj okendenok huaboaʼda oaʼpakonʼuyate. Kenda aratbut onʼtiahuaydepo kenpaʼti onʼpe̱e̱depo, “Kenpihuay,” oʼdaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","—‍Totoʼ huairia Jesústaj oʼteyyaʼnok totoʼtaj oʼmakenikaʼ. —‍Sueʼada oknopo̱e̱hueʼ hua̱e̱ʼeria onʼhuaaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","—‍Diosa ontaj eʼtaʼmonaʼuynayo konig Dios kuruderia teyda oʼkikaʼnig konigti yakaʼ. —‍Nogomeya̱ namaʼda Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Kenda kenomey judío huairia onʼnopo̱e̱nig Jesúsnayo kenda oʼnopo̱e̱po, —‍Huadari gobierno huairi huakkaʼda aratbuttaj huamanaʼikaʼeria huayahuaya eʼmagkikaʼnayo ayaʼda ken aratbuten gobierno huairi ehueʼda o̱ʼneapo. Kenpaʼti huabet huabetere nogtaj nogtaj eʼbatuktuknayo ehueʼda o̱ʼneapo. ");
INSERT INTO amrNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Konigti totoʼ huairiomey e̱gkaʼnayo totoʼ nog totoʼtaj eʼmagkaʼnayo totoʼ huairi ehueʼdik o̱ʼneapo. “Totoʼtaj aʼmakenyaʼpo totoʼ huairia Jesústaj oʼteyyaʼ.” Namaʼda moʼbatiaʼpakne. ");
INSERT INTO amrNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Totoʼtaj kaʼmakeneʼpo totoʼ huairia doʼtaj oʼteyyaʼ opudomey namaʼda moʼtinopo̱e̱nigʼa. Oroʼen huanigpe̱i̱kaʼeritaj totoʼ huairia oʼmanopoʼteypakaʼikaʼ totoʼtaj kamakmaeneʼpo opuda̱ kenpaʼ eaʼnayo “Da boaʼne.” Opudomeyen huanigpe̱i̱kaʼeria monaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Dios teyda o̱ʼe̱po doʼtaj beʼteypakaʼnok totoʼtaj ijmakenikay. Do Diosen Huairi ijtiakdey ayaʼada nopo̱e̱ʼdik o̱ʼneapo kenpaʼti nigpe̱i̱kaʼdik o̱ʼneapo. Opudomeyere i̱jje̱dey. Doʼtaj menoknopo̱i̱kaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Huabokerekpiʼ teyda o̱ʼe̱po konig huairi o̱ʼe̱po huakkaʼ pi̱ya̱ʼ oʼmato̱e̱po keʼnen jak dakaʼ oʼta̱to̱e̱po. Doʼhued jakyo katepiʼ meʼta̱e̱nig dakaʼ ijto̱e̱nok bepiʼ kudhueʼdik o̱ʼe̱a̱po oʼnopo̱e̱nigʼa, ");
INSERT INTO amrNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","noga̱piʼ huamagkaʼeria nogi̱ti teyda o̱ʼe̱po kentaj eʼhuatiaknayo o̱gkaʼpo jokbakayaʼpo pi̱ya̱ʼ kenpaʼti ayaʼda okbatohuaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Beʼapiʼ doʼtaj pakhueʼ e̱e̱ʼnayo konig doʼtaj dakhueʼda moʼe̱ne. Sueʼada doʼtaj onʼpakpo dakaʼ moknopo̱e̱po moʼnigpe̱e̱po huakkaʼtada Diostaj moknopo̱e̱a̱ʼne doʼtaj moʼnigpe̱e̱a̱ʼne. Nogomeynayo doʼtaj batotiakhueʼ o̱ʼnepo huakkaʼtada maknopo̱a̱hueʼ onʼmaeaʼ. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","—‍Dakhueaʼ totoʼ huabokerektaj eʼnopoʼtoeonhuahuaʼdeʼ okhuaʼdepo aratbut ehueʼ e̱e̱ʼyo̱ oʼhuaʼpo meyo̱piʼ hua̱i̱kaʼ eʼuktada huahuayhueʼ o̱ʼe̱po “Ke̱yo̱ i̱ji̱kamey aʼkumeyi̱ʼ.” Ken noki̱re̱ga̱ oʼnopo̱e̱po, ");
INSERT INTO amrNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ken huabokerektaj oʼnopoʼto̱i̱kameʼ, kentaj e̱kye̱deʼte Diosapiʼ nopoʼto̱e̱hueʼtada daknopoʼda konig jak eʼberokeʼyonig ʼuruaʼda o̱ʼe̱nok ");
INSERT INTO amrNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ken totoʼa oʼhuaʼpo nog siete dakhueʼnada noki̱re̱gtaj oʼbahuahuaydepo oʼbatotiakpo dakhueaʼda o̱ʼnepo keʼnanayo sueʼda dakhueʼ o̱ʼe̱po ken ontayoʼ huabokerektaj onʼnopoʼto̱e̱nok. Huakkuruda nogtotoʼtida oʼnopoʼto̱e̱po sueʼda dakhueʼda o̱ʼe̱po taʼpotaʼ ocho dakhueaʼ totoʼ onʼnopoʼto̱e̱depo huabokerek dakhueaʼda o̱ʼe̱a̱po. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesúsa kenda eʼmanadeʼte, —‍Ken ettoneʼ o̱ʼnen hua̱ye̱a̱ ontaj besiʼpopakuypo kenpaʼti ontaj meminoganhuahuaʼuypo durugnada ka̱i̱keʼ. —‍Ettoneʼa̱ aratbut e̱gkupopakyo o̱ʼe̱po ʼuttaʼnada onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","—‍Doʼhued hua̱ye̱nayo sueʼda durugmon o̱ʼe̱nigʼa ayaʼda Diosbaʼtaj onʼpe̱e̱depo onʼnigpe̱e̱po o̱gkikaʼpo kenataʼtaj nogi̱ti durugda o̱ʼnikaʼapo. —‍Jesúsa ettoneʼtaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","32","Huakkaʼananada Jesústaj enʼtikupopakte, —‍Opudomey aratbut oy moʼnoikaʼ. Dakhueaʼda hua̱e̱ʼeri moʼi̱kaʼ. Konig Dios teyda kaʼdik o̱ʼe̱ konig eʼbayareaʼ konigti oroʼtaj mogkeʼ moʼnopo̱e̱nigʼa. Konig Jonás o̱ʼe̱ʼuyate, konigti Diosa doʼtaj meʼe̱a̱ʼapone. Jonás ʼuruaʼda o̱ʼe̱ʼuyatenok Nínive huakkaʼ jak aratbut onʼnigpe̱e̱po Diostaj onʼmanopoʼkoreaʼuyate. Konigti do huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne ʼuruaʼda i̱jje̱a̱ponok aratbuta menʼtiahuaypo oknopo̱e̱ʼdik ya̱ʼneapet, Diosa oʼtaʼmonaʼuy oknopo̱e̱ʼdik ya̱ʼneapet. Aʼnennada huakkaʼ jak Nínive hua̱e̱ʼeritaj Jonás Diosbaʼ eʼmanaʼdeʼte Nínive aratbut Diostaj onʼnopoʼkoreaʼpo huaboaʼda Diostaj onʼnigpe̱e̱ʼuyate. Oy aratbut doʼtaj moʼpe̱e̱denigʼa nopoʼkoreahueʼ o̱ʼnepo doʼtaj oknopo̱e̱hueʼ moʼe̱ne. Jonás sueʼda huairi o̱ʼu̱yate. Donayo huahuak huairi i̱jje̱po, konige̱po keneʼhua̱ya̱ʼmeʼnoete ayaʼda Diostaj onʼnigbakupobopo kenokaʼ opudomey oy hua̱e̱ʼeri aʼneneri Nínive hua̱e̱ʼeriere Diostaj onteteyoʼ boʼtaʼbopo. Opudomey oy hua̱e̱ʼeri dakhueaʼda moʼe̱po doʼtaj eʼtiahuayada eʼpe̱e̱deada nopoʼkorehueʼ moʼu̱yatenok. Nínive hua̱e̱ʼeria kenda Diostaj onʼbahuaaʼapo. Aʼnennada huadaribayo ettoneʼa̱ huairi o̱ʼu̱yate. Keʼnendari adtenada o̱ʼu̱yate. Salomón Israel aratbuten huairi huakkaʼnada oʼnopo̱e̱po ʼuruaʼda oʼbatiaʼpakikaʼnok aʼpe̱e̱yaʼpo ken ettoneʼ keʼnenbayaʼ bidtenada oʼhuaʼonhuahuaʼuyate. Israel aratbutenbayo oʼhuaʼonhuahuaʼuyate. Salomóna sueʼda ʼuruaʼda oʼnopo̱e̱ʼuyate. Donayo ʼuruaʼnanada ijnopo̱e̱po huakkaʼda ijnopo̱e̱nigʼa oy hua̱e̱ʼeria sueʼada doʼtaj moʼpe̱e̱po moknopo̱e̱ne. Konige̱po nogok keneʼhua̱ya̱ʼmeʼnoete ayaʼda Diostaj enʼnigbakupoboʼte opudomey oy hua̱e̱ʼeri dakhueaʼda moʼe̱ doʼtaj nigpe̱e̱hueʼada oknopo̱e̱hueʼ moʼu̱ynok, ettoneʼ huairia Diostaj oʼbahuaaʼapo. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","—‍Huakjey eʼbakpakdeʼte e̱kti̱o̱ke̱ʼyo̱ huada̱hueʼ o̱ʼnikaʼ. Sorokkosotoneʼtoyo huada̱hueʼ o̱ʼnikaʼ. Huakjey eʼbakpakte kutopa kutapen onʼhuada̱ʼikaʼ. Kente jeyda o̱ʼe̱nok ayaʼda onʼkudpo batiahuayaʼdik o̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","35","Aratbuten huakpo konig hua̱so̱ʼen huakjey o̱ʼne. Aratbuten huakpo huadakda e̱e̱ʼnayo hua̱so̱ʼa̱ jeyonigti o̱ʼe̱. Konigti huakjey jeyda e̱e̱ʼte aratbut katepiʼ eʼkaʼ tiahuaydik o̱ʼne. Aratbuten huakpo dakhueʼda e̱e̱ʼnayo dakaʼ tiahuayhueʼdik o̱ʼne. Konig sikki̱re̱gyo̱ hua̱so̱ʼ o̱ʼnepo katepiʼ kahueʼdik o̱ʼne. Konigti aratbuten huanopoʼ o̱ʼe̱ konig huakjey aratbutenso̱ʼyo o̱ʼe̱. Huadaknopoʼda e̱e̱ʼnayo huadakyoʼ onʼnopo̱i̱kaʼ. Konig ʼuruaʼda Diosa oʼnopo̱e̱ kenpaʼti Diosa oʼpak aratbutkon oʼnopo̱e̱ kenpaʼti o̱gkaʼ. Aratbutennopoʼ dakhueʼda e̱e̱ʼnayo katepiʼ dakhueʼ eʼnopo̱e̱ʼnayo aratbuttaj ʼuruda eʼnopo̱e̱ʼ Diosa manopo̱e̱a̱hueʼdik oʼmae. Aratbut dakhueʼnopoʼda e̱e̱ʼnayo konig sikki̱re̱gyo̱ o̱ʼne. Meyon huahueʼdikda o̱ʼne. Konige̱po keyoj, dakyoʼ ya̱gʼkikatiʼ. Huanopoyaʼ huadakyoʼ yanʼnopo̱e̱po, batikhueʼ yaneʼ. Eʼbatiknayo konig sikki̱re̱gyo̱ moʼi̱kaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Huanopoyaʼ huadakda eʼnopo̱e̱ʼnayo Dios konig huakjey keʼnen dag boʼtiahuayaʼne kenpaʼti huadak eʼkaʼ moʼnopo̱e̱a̱ʼne. Sikki̱re̱gyo̱ ehueʼ moʼe̱a̱pone. Konig huakjey oʼbakpakpo ʼuruaʼda oʼtaʼte tiahuaydik moʼe̱po kenpaʼti Diosen eʼkaʼ moʼnopo̱e̱a̱po. —‍Kenda Jesúsa oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesúsa eʼmanmadikaʼdeʼte, “Doere moʼbapeʼ.” Jesústaj fariseoa onaʼuyate. Jesús keʼnen jakyo oʼkuddepo kutopate oʼhuaduyate. ");
INSERT INTO amrNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Judío aratbut bapehued huabaʼ onʼbakoyoʼikaʼ. Jesús baʼkoyohueʼ kutopayo oʼhuadnok fariseoa oʼtiahuaydepo, “Kenpihuay, baʼkoyohueʼada oʼbapeapo,” fariseoa oʼtinopo̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","—‍Opudomey fariseo huairi konig platoʼ taza huabakoyoaʼeri moʼe̱po hua̱so̱ʼensiʼdakyoʼda dakaʼ boʼkoyoaʼikaʼne. Aratbut kanʼtiahuayeʼpo ʼuruaʼda hua̱so̱ʼsiʼdak boʼkoyoaʼnigʼa huanopoʼnayo dakhueʼda moʼe̱ne. Nogen onʼta̱e̱ boʼeretpakpo moʼbakkayʼikaʼne kenpaʼti katepiʼ dakhueaʼ boʼkikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Namaʼda moʼnopo̱i̱kaʼ. Diosa hua̱so̱ʼsiʼdak oʼkaʼuyate. Ken Diosa kenpaʼti hua̱so̱ʼen huanopoʼ oʼkaʼuyate. Kenda nopo̱e̱ʼdik moʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Huanopoyaʼ yanʼmatinepahuiʼpo paiʼda aratbuttaj yanʼbayokikatiʼ kenda eʼkikaʼnayo ayaʼda hua̱so̱ʼen ʼuruda moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Paiʼnada moʼnopoʼe̱a̱pone, opudomey fariseo huairi. Aypo huatokbuk sueʼda Diostaj boʼyokikaʼnigʼa nog aypo huatokbukbaʼa ʼuruda Diostaj sueʼda boʼyokikaʼnigʼa aratbuttanayo huadakda kahueʼ moʼi̱kaʼpo kenpaʼti Diostaj diʼ ehueʼ moʼe̱ne. Aypo huatokbuk Diostaj yokdik moʼe̱po kenpaʼti aratbuttaj huadakda kikaʼdik moʼe̱po kenpaʼti Diostaj diʼ e̱ʼdik moʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Huanopoʼa paiʼnada moʼnopoʼe̱a̱pone, opudomey fariseo huairi. Judíoen hua̱i̱takeʼ jakyo ʼuruda huairien huahuadte ehuadtaʼ boʼeretpakikaʼne. Huakkaʼ jakte eʼhuaʼeʼte “Iʼtiak huairi.” “Iʼtiak huamanmadikaʼeri.” Kenpaʼ enayoʼda eʼpe̱e̱taʼ boʼeretpakikaʼne. ");
INSERT INTO amrNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Opudomey fariseo huairi kenpaʼti Moisésenbaʼ huamanmadikaʼeri paiʼnada moʼnopoʼe̱a̱pone. “Oroʼomey huadakda o̱ʼe̱y.” Namaʼda moʼnopo̱e̱ʼikaʼnigʼa konig ta̱hui̱ri̱gda dakhueʼnada moʼe̱ne. Dakhueʼda e̱ʼneʼtada aratbuta nokothueʼ o̱ʼne. Opud konig kubaraktoneʼonig moʼe̱ne. Kubaraktoneʼtaj aratbut tiahuayhueʼ o̱ʼnepo kente onʼhuaeʼikaʼ. Aratbut sorokyo eʼparaʼ e̱e̱ʼtada tiahuayhueʼda o̱ʼnepo onʼhuaeʼikaʼ. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","—‍Oroʼomeytakon dakhueaʼda oʼhuaaʼne, huamanmadikaʼeri. —‍Moisésenbaʼ huamanmadikaʼeria Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","—‍Paiʼnada moʼnopoʼe̱a̱pone opudomey Moisésenbaʼ huamanmadikaʼeri. Nogda nogda huakkaʼda ya̱gʼkikaʼ, beʼapiʼ kenda kahueʼdik e̱e̱ʼtada opudomey aratbuttaj moʼmanaʼikaʼne. Opudnayo sigpiʼ kenda kahueʼ moʼi̱kaʼne. ");
INSERT INTO amrNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Paiʼnada moʼnopoʼe̱a̱pone opudomey. Opudomeyen adhueaʼpaneʼkudak Diosbaʼ huamanbatiaʼpakeritaj onʼbarakuyate. Eʼbueykudaken kubaraktaʼ huid jaksiʼpo konig okkahuehueʼdik huid jaksiʼpo boʼkikaʼne. ");
INSERT INTO amrNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Diosbaʼ huamanbatiaʼpakeritaj opudomeyen adhueaʼpaneʼa̱ onʼbatiarakaʼuy. Opudomeyen adhueaʼpaneʼ huadakda o̱gkaʼuyate opudomeya̱kon moʼnopo̱e̱po, kubaraktaʼ okkahuehueʼdik huid jaksiʼpo boʼkikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Konige̱po, “Diosbaʼ huamanbatiaʼpakeri ijmataʼmonaʼapoy kenpaʼti huanigpe̱i̱kaʼeri ijmataʼmonaʼapoy. Sueʼtada onʼbarakapo nogomeytaj onhuadiaypo diga̱ʼ onʼmagkaʼapo.” Diosa huakkaʼ oʼnopo̱e̱po kenda oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Konige̱po opudomey aratbut oyda moʼnoenig, opudomeytaj Diosa diga̱ʼ mogkaʼapone. Opudomeyen adhueaʼpaneʼ Diosbaʼ huamanbatiaʼpakeritaj onʼbarakuyate. Diosa huadari eʼkaʼdeʼte huakkuruda Abeltaj oʼarakpo oʼbueyʼuyate. Nogok nogok nogtaj nogtaj onʼbarakpo, taʼpotaʼ Zacaríastaj oʼdarakuyate. Diosen ʼuru jak kurute ʼuhua eʼarakikaʼtaʼ Diostaj eʼnigbakpakikaʼ kutopa o̱ʼe̱. Kutopa Diosen jaknopoyaʼ Zacaríastaj oʼdarakuyate. Diosbaʼ huamanbatiaʼpakeritaj opudomeyen adhueaʼpaneʼ onʼbarakuynok opudomeynayo barakhueʼ e̱ʼu̱ypiʼ Diosa diga̱ʼ mogkaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Opudomey Moisésenbaʼ huamanmadikaʼeri paiʼnada moʼnopoʼe̱a̱pone. Aratbuttaj dakaʼ Diosbaʼ nopo̱e̱a̱hueʼdik moʼe̱ne. Konig Diosensiʼpo e̱e̱ʼ nopo̱e̱hueʼ o̱ʼnepo. Opudomeykon Diosensiʼpo ehueʼ moʼe̱a̱pone kenpaʼti nogomey Diosensiʼpo ehueʼdik o̱ʼneapo oknopo̱e̱hueʼada boʼkaʼpo. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jesúsa kenda eʼmanaʼdeʼte Moisésenbaʼ huamanmadikaʼeriomeya̱ fariseoerea Jesústaj diga̱ʼda onʼhuadiaypo nogpaʼ nogpaʼ kiriga̱yo̱ʼ oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Jesúsa namaʼda kaeʼpopiʼ yaapetpiʼ onʼnopo̱e̱po onʼpe̱e̱nigʼa dakhueaʼ eaʼ eʼpe̱e̱taʼ onʼpaknigʼa. Jesúsa dakhueaʼ oaʼ eʼhuaaʼtaʼ onʼpakpo. ");
INSERT INTO amrNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","2","Jesúsa dakaʼ oʼmanmadikaʼonhuahuaʼpo huakkaʼnanada aratbut o̱gkupopakdepo huakkaʼada aratbut o̱ʼnepo batugon o̱gkaʼuyate. Huakkuruda huanigpe̱i̱kaʼeritaj oʼmanaʼpo: —‍“Oroʼomey huadakda o̱ʼe̱y.” Fariseo huairia ayaʼtada eʼmanopo̱e̱a̱ʼtaʼ onʼpaknigʼa dakhueaʼda o̱ʼne. Konig pan eʼbiaʼo̱gʼ fariseo o̱ʼne. Huakkuruda pan eʼkaʼte eʼbiaʼo̱gʼ tiahuayhued moʼe̱po aʼti eʼbiadeʼte eʼbiaʼo̱gʼ o̱ʼe̱ moʼnopo̱e̱. Huakkuruda fariseo huairi huadakda o̱ʼne namaʼda moʼnopo̱e̱nigʼa nogok kenda o̱gkikaʼ boʼtiahuaydepo dakhueaʼda o̱ʼne nopo̱e̱ʼdik moʼe̱a̱pone. Konige̱po fariseomey huairitaj keyoj, ijjay. ");
INSERT INTO amrNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Katepiʼ konig soatayoʼ sikki̱re̱gya̱ʼ boaʼikaʼnig, kenda boaʼikaʼnig nogok konig huameʼnoete ayaʼada onʼpe̱e̱a̱po. Konigti jakyaʼda nog aratbut ehueʼ e̱e̱ʼya̱ʼ kenpaʼti jakhuiʼkay ekhuikyaʼ utakaʼ boaʼikaʼnig kenda nogok huakkaʼ jak eretnopote jakkutagpite onʼbopo ʼuttaʼda oʼdaʼapo, ayaʼada kanʼpe̱e̱ʼpo oʼdaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","5","Huabokerek hua̱so̱ʼtaj arakdik o̱ʼne. Kenyoʼda aratbutso̱ʼtaj arakdik o̱ʼne. Noki̱re̱gtanayo arakhueʼdik o̱ʼne. Konige̱po aratbuttaj mididhueʼ yanikaʼ. Beʼtaʼtaj okmeʼpukdik moeʼ dakaʼ oʼnonaʼne. Diostayoʼda yanokmeʼpukikaʼ. Diosnayo arakdik o̱ʼe̱ kenpaʼti eʼbueydeʼte noki̱re̱gtaj paiʼda kanʼnopoʼe̱ʼpo taʼakyo enʼdik o̱ʼe̱. Kentaj yanokmeʼpuk, ijjay. Doʼhued huadiʼtaj ijjay. ");
INSERT INTO amrNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Bakoytaʼ aratbut suhuigda onʼpakikaʼ. Cinco bakoy aʼbakayaʼpo bottaʼ sigkupe bayokdik o̱ʼne. Diosnayo bakoytaj oʼpakpo nogtatipiʼ okkahuehueʼ o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Opudomeytaj Diosa huakkaʼda oʼpakpo dakaʼ moʼmato̱i̱kaʼne. Opuden huakuhuijtapiʼ moʼdikikaʼne. Bakoytaj konig sueʼda oʼpak. Diosa sueʼda oʼpak. Opudomeytaj huakkaʼ oʼpaknok meʼpukhueʼ yanikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Jesucristotaj huaknopo̱e̱ʼeri i̱jje̱y.” Ayaʼada aratbuttaj onʼmanaʼaponig do huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne, “Kenomey kenda eʼmanadeʼte doʼhued huaknopo̱e̱ʼeri o̱ʼne.” Diosen huataʼmoneritaj ijmanaʼapoy. ");
INSERT INTO amrNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","“Jesucristotaj oknopo̱e̱hueʼya i̱jje̱y.” Aratbuttaj onʼmanaʼpo “Doʼhued huaknopo̱e̱ʼeri ehueʼ o̱ʼne.” Diosen huataʼmoneritaj ijmanaʼapoy ijjay. ");
INSERT INTO amrNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Do huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne, doʼtaj beʼapiʼ dakhueaʼ eʼhuaaʼnayo Diosa bakkahueaʼdik o̱ʼe̱. Diosen Noki̱re̱gtaj dakhueaʼ eʼhuaaʼnayo Diosa bakkahueahueʼdik o̱ʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Nogok judío hua̱i̱takeʼ jak huairitaj boʼtohuaʼapone. Dakhueaʼ bokaʼne monaʼpo judíoen hua̱i̱takeʼ jakyo boʼtohuaʼapone. Kenpaʼti gobierno huairite boʼtohuaʼapone. “¿Kaʼtiaʼpiʼ huairitaj ijmanbatiaʼpakapo?” Yanʼnopo̱e̱po meʼpukehueʼ yaneʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Huairitaj manbatiaʼpakdik e̱e̱ʼte Apag Diosen Noki̱re̱ga̱ moʼnopo̱e̱a̱ʼaponok ʼuruaʼda batiaʼpakdik moʼe̱a̱po. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","—‍Kenda oroʼen huaojkudak oʼmato̱e̱ʼuyate kenda doʼtaj jonposakeaʼdik o̱ʼe̱nok, doʼtaj yabayoktiʼ. Doʼhued huamaʼbuytaj yanatiʼ, Huamanmadikaʼeri. —‍Huakkaʼ Jesústaj enʼtikupopakyaʼ nogtiada Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","—‍“O̱ʼnen huamaʼbuytaj yabayoktiʼ.” Onahueʼdik i̱jje̱a̱poy. —‍Jesúsa huabokerektaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","—‍¡Keyoj! Huakkaʼnada eʼmato̱e̱ʼtaʼ eretpakhueʼ yanikaʼ. Durugnada a̱ʼe̱ya̱ʼpo huakkaʼda katepiʼ to̱e̱hueʼdik yanikaʼ. Sueʼda e̱ʼta̱e̱piʼ durugda e̱ʼdik moʼe̱ne. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Jesúsa aʼmanmadikayaʼpo oʼmanbatiaʼpakpo, —‍Aʼnenda huabokerek o̱ʼu̱yate. Konig huairi o̱ʼe̱po huakkaʼda oʼmato̱e̱ʼuyate. Keʼnen taʼbatoneʼ huakkaʼda aypo oʼkerekdepo konig aroz huakkaʼda oʼtaboyogʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","“Menpaʼ ijkaʼapo. Doʼhued aroz doʼhued aypo hua̱to̱e̱ʼ jak suhuigda o̱ʼe̱. Aypo huakkaʼda o̱ʼe̱nok meyo̱ kuda̱hueʼdik o̱ʼe̱.” Kenpaʼ huairia oʼnopo̱e̱po. ");
INSERT INTO amrNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ken, “Oy konig ijkaʼapoy ijnopo̱e̱y. Doʼhued aypo hua̱to̱e̱ʼ jaksiʼpo ijjakyogapoy. Nogda huaboroaʼda aypo huamato̱e̱ʼ jak ijkaʼapoy ijjakkaʼdepo ayaʼda aypo arozere ke̱yo̱ ijkuda̱ʼapoy. Ayaʼda katepiʼ ijmato̱e̱nig ijbakuda̱ʼapoy. ");
INSERT INTO amrNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kenokaʼ ijbakuda̱ʼdepo doʼhued huamato̱e̱ʼ jakyo huakkaʼda ijto̱e̱ʼapoy. Huakkaʼda huabayok ijto̱e̱a̱poy. Baahueʼada bapeʼdik i̱jje̱a̱poy. Maiʼdik i̱jje̱a̱poy. Durugda i̱jje̱a̱poy.” Ken huabokerek namaʼda oʼnopo̱e̱nigʼa. ");
INSERT INTO amrNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Namaʼda iʼnopo̱e̱nigʼa. In sikyo iʼbueyapone. Ayaʼ aypopiʼ arozpiʼ nogda nogda huakkaʼda iʼmato̱e̱po huaboroʼ jakyo iʼbakuda̱ʼdepo noga̱ onʼmato̱e̱a̱po. Diosa ken huairitaj onaʼuyate.” ");
INSERT INTO amrNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ken konig o̱ʼe̱po aratbut keʼnen huataʼ huakkaʼda nogi̱ti nogi̱ti onʼmato̱e̱po, huakkaʼda eʼmato̱e̱a̱da Diostehuapaʼnayo paiʼda onʼe̱. —‍Jesúsa oʼmanmadikaʼpo oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Nogok huanigpe̱i̱kaʼeritaj, —‍Aypotaʼ mepuʼkehueʼ yanikaʼ. Kenpaʼti yudtataʼ mepuʼkehueʼ yanikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Diosa teyda o̱ʼe̱po oroʼomeytaj moʼmanoeaʼi̱kaʼne. Oroʼomeytaj aypo yudtakon bayokdik moʼi̱kaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Surujpi̱g konig o̱ʼe̱ yanʼnopo̱e̱po. Batukehueʼ o̱ʼnikaʼ. O̱gkupaeahueʼ o̱ʼnikaʼ. Aypo huamato̱e̱ʼ jak to̱e̱hueʼ o̱ʼnenigʼa Diosayoʼda surujpi̱gtaj aypo oʼbayokikaʼ. Diosa bakoytaj sueʼda oʼpak. Opudomeytanayo Diosa huakkaʼda boʼpakikaʼne. Ayaʼda katepiʼ bayokdik moʼi̱kaʼapone. Mepuʼkehueʼ yanikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Aratbut nogi̱ti huabidda e̱e̱ʼtaʼ onʼpakpo, huakkaʼda eʼmepuʼkeada nogi̱ti huabidda ehueʼdik o̱ʼneapo. ");
INSERT INTO amrNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Kenda moʼmepukepo ehueʼdik moʼe̱a̱pone. Nogtaʼ nogtaʼ katetapiʼ mepuʼkehueʼ yanikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Huakhuen ʼurunada o̱ʼne. Baahueʼada o̱ʼnikaʼ kenpaʼti batiokhuihuihueʼ o̱ʼnikaʼ moʼnopo̱e̱t. Salomónkudak huairitoneʼ o̱ʼu̱yate. Huakkaʼda oʼmato̱e̱ʼuyate. ʼUruda yudtaj oʼmato̱e̱ʼpo oʼutikaʼuyate. Huakhuen ʼurunanada o̱ʼnikaʼ, Salomónnayo sueʼda ʼuruda oʼutikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Diosa huakunopia okhuenpakaʼ. ʼUruaʼda oʼkaʼ. I̱da okhuenkot. I̱da oʼtaset. Diosa huakunopia okhuenpakikaʼ kenpaʼti opudomeytaj huakkaʼda oʼpakpo boʼtihuapokikaʼapone yudtaj moʼmato̱i̱kaʼapone. Sueʼda moknopo̱e̱po nogi̱ti Diostaj dakaʼ yanoknopo̱e̱ʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Katetapiʼ mepuʼkehueʼ yanikaʼ. ¿Kate oʼbapeʼapo? Nopo̱e̱hueʼ yanikaʼ. ¿Kateʼ oʼmamayʼa̱? Nopo̱e̱hueʼ yanikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Oknopo̱e̱hueʼ hua̱e̱ʼeria yudtataʼ kenpaʼti aypotaʼ kenpaʼda onʼeretpakikaʼ. Opudnayo aypopiʼ yudtapiʼ to̱e̱hueʼ moʼe̱nig Apag Diosa kenda oʼnopo̱i̱kaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kenpaʼda Dios Huairitaj yanʼpakikaʼpo yanʼnigpe̱i̱kaʼ. Ken konig Dios Huairitaj eʼpaknayo Diosa boʼyokikaʼapone. Katepiʼ boʼpak yudtapiʼ aypopiʼ Apag Diosa boʼyokikaʼapone. —‍Jesúsa keʼnen huanigpe̱i̱kaʼeritaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","—‍Doʼhued huanigpe̱i̱kaʼeri moʼe̱po sueʼda moʼe̱ne. Meʼpukhueʼ yaneʼ. Opudomeyen Apag Dios oʼpaknok kenokaʼ ayaʼada Diostaj onʼnigpe̱e̱depo opudomeykon Apag Diosere huairida moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Kenda moʼmato̱e̱nig yanʼbahuayaʼ. Yanʼbahuayaʼdepo paiʼda aratbuttaj ken huakupe yanʼbayoketiʼ. Kenda eʼkaʼte Diosa kurudya̱ʼ boʼtiahuayapone. Okkahuehueʼdik o̱ʼe̱a̱po. Kenda boʼkaʼpo kurudyo̱ Diosere huakkaʼda moʼto̱e̱a̱pone. Kenda matoneʼpakhueʼ o̱ʼe̱a̱po. Okkayhueʼdik moʼe̱a̱pone. Huabereeria berehueʼdik o̱ʼneapo. Kenpaʼti kenda kurudya̱ʼ moʼto̱e̱a̱ponig sukkaʼpoapiʼ bapehueʼdik o̱ʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Huakkaʼtada katetapiʼ eʼpaknayo Diostaj sueʼda boʼpakapo. Diostaj moʼnigpe̱e̱po paiʼda aratbuttaj eʼbayokikaʼnayo Diostaj huakkaʼda boʼpakapone. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","—‍Onteʼti indariyo ijtiakapoy. Do huairitaj e̱kpo̱e̱ʼ mennige̱ʼikatiʼ. Konig enʼto̱e̱pak fiestayaʼ huairi e̱kye̱ʼtaj keʼnen huanabaʼa e̱kpo̱e̱ʼ onʼnige̱ʼi̱kaʼ. Ken e̱kye̱ʼte huairitaj i̱da nigokhuikeʼdik o̱ʼneapo. Konigti doʼtaj e̱kpo̱e̱ʼ mennige̱ʼi̱katiʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Konig huairi oʼtiakpo keʼnen huanabaʼa e̱kpo̱e̱ʼ enʼnige̱ʼte oʼbahuahuayatonok durugda o̱ʼneapo. Ken huairi nog yudtaj oʼtiokotdepo yanʼbahuad huanabaʼtaj oʼmanaʼdepo aypo oʼbayokeapo. Huanabaʼtaj oʼbayokeaponok durugda o̱ʼneapo. ");
INSERT INTO amrNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Huairi nopotesikyo oʼtiakapopiʼ sikyoeddapiʼ oʼtiakapopiʼ. Huanabaʼa e̱kpo̱e̱ʼ onʼnige̱ʼpo huairi eʼtiakte durugda o̱ʼneapo. Huanabaʼ durugda o̱ʼneapo. ");
INSERT INTO amrNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Kenpaʼti nogdakon yanʼnopo̱e̱ʼ. Konig huabereeri aʼbereyaʼpo ken horate oʼtiakapo jak hua̱ta̱e̱ʼeria eʼnopo̱e̱ʼnayo tayhueʼ o̱ʼe̱nok huabereeria jakyo kudhueʼdik o̱ʼe̱a̱po. Kenpaʼti berehueʼdik o̱ʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Do kurudya̱ʼ ijtiakaponok e̱kpo̱e̱ʼ mennige̱ʼikatiʼ. Do huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne kenokaʼ huameʼnoe sikyopiʼ oʼtiakapo nopo̱e̱hueʼda eneʼte kenokaʼ ijtiakapoy. —‍Kenda Jesúsa oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","—‍¿Oroʼomeytayoʼda menpaʼ kenda onmadikaʼ, Huairi? ¿Menpaʼ nogomeytakon iʼmanmadikaʼ? —‍Pedroa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","—‍Huanabaʼ huamato̱e̱ʼeri dakaʼ huakikaʼeri kenpaʼti huanabaʼ huamato̱e̱ʼeri ʼuruaʼda huaknopo̱e̱ʼeri konig o̱ʼne ijmanmadikay. Ken huairien jak huanabaʼ huamato̱e̱ʼeritaj “Doʼhued huanabaʼtaj aypo yamabayokikatiʼ. Nogbayo ijhuaʼapoy. Aʼti ijtiakapoy.” Onanpo. ");
INSERT INTO amrNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Huairi oʼtiakdepo konig huiria onanmeʼnig huanabaʼ huamato̱e̱ʼeria dakaʼ aypo eʼbayokikaʼnayo durugda o̱ʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","“Ayaʼda doʼhued ijmato̱e̱nig dakaʼ meʼtamato̱e̱ʼ.” Huairia ken huanabaʼtaj onanpo. Buttida ijjay. ");
INSERT INTO amrNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Doʼhued huairi ijhueʼda ya̱ʼe̱po yatiakapet.” Huanabaʼa eʼnopo̱e̱ʼnayo nog huanabaʼtaj huabokerekere ettoneʼeretaj huaboaʼda oʼmabitbitpo kenpaʼti huaboaʼda huakkaʼ oʼbapudhuaʼpo huakkaʼ oʼmaiʼonhuaʼpo kenpaʼti konig sineʼ oʼsiborudhuaʼpo ");
INSERT INTO amrNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Kenda huanabaʼ huamato̱e̱ʼeria eʼkaʼte kenokaʼ ken huanabaʼ e̱kpo̱e̱ʼ nige̱hueʼ e̱e̱ʼte kenpaʼti kenmeʼnoete oʼtiakapo nopo̱e̱hueʼda e̱e̱ʼte huairi oʼtiakapo. Ken huanabaʼ huamato̱e̱ʼeritaj castiga diga̱ʼda o̱gkaʼapo kenpaʼti oknopo̱e̱hueʼ hua̱e̱ʼeriere kenpaʼda oʼmaenapo. ");
INSERT INTO amrNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Huanabaʼ keʼnen huairi oʼpaknig enʼnopo̱e̱a̱da kahueʼ o̱ʼnepo dakhueʼen o̱gkaʼ kenpaʼti huairi eʼtiakapote e̱kpo̱e̱ʼ nige̱hueʼ o̱ʼnenok kenomeyen huairia huakkaʼda castiga oʼmagkaʼapo. Konigti aratbut kenda ijmanikaʼnig eʼnopo̱e̱a̱da nigpe̱e̱hueʼ o̱ʼnepo kenpaʼti do eʼtiakapote e̱kpo̱e̱ʼ nige̱hueʼ meneʼapetnigtaj Diosa castiga diga̱ʼda yaʼmagkaʼapet. ");
INSERT INTO amrNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Nog huanabaʼa kenda huairi oʼpaknig nopo̱e̱hueʼ o̱ʼnepo kenda huairi pakhueʼtada o̱gkaʼnok huairia sueʼda castiga oʼmagkaʼapo. Dakhueaʼ o̱gkaʼnok sueʼda castiga oʼmagkaʼapo. Konigti aratbut kenda ijpaki nopo̱e̱hueʼada kenda pakhueʼ i̱jje̱ynig e̱gkaʼnayo Diosa sueʼda castiga oʼmagkaʼapo. Diosapiʼ huairiapiʼ aratbuttaj huakkaʼ katepiʼ eʼbayoknayo dakaʼ nigpe̱i̱kaʼdik kaʼneʼ Diosa ʼuruaʼda eʼnopo̱e̱a̱ʼnayo dakaʼ nigpe̱i̱kaʼdik o̱ʼneapo. Diosa huakkaʼ eʼtihuapoknayo nogomeytakon huakkaʼda tihuapokdik o̱ʼneapo. —‍Ken konig Jesúsa oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","—‍In huadariyo aratbut abakpoespakayaʼpo ijtiakuy. Aratbut onʼpoespakpo konig taʼak eʼbakpak o̱ʼe̱. Ken taʼak aʼbakpakayaʼpo ijtiakuy. Ken oyda eʼbakpakte ijjeretpaki. ");
INSERT INTO amrNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Konig bautiza e̱gkaʼte o̱ʼe̱ konigti paiʼda nopo̱e̱ʼdik i̱jje̱a̱poy. Paiʼda ijnopoʼe̱a̱popo ijmeʼpukey. ");
INSERT INTO amrNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Aratbut nog aratbuttaj aʼmanoeyyayaʼpo oʼtiakuy opudomey namaʼda moʼnopo̱e̱ne. Aratbut nog aratbuttaj aʼmanoeyyayaʼpo Diosyaʼ tiakhueʼ i̱jje̱ʼuy. Aratbut nog aratbuttaj aʼpoespakayaʼpo Diosyaʼ ijtiakuy. ");
INSERT INTO amrNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Huaboaʼda nogjakyotida huabet nog huabettaj dakhueaʼ onʼbahuaʼpakapo. Cinco o̱ʼnepo tresa dostaj dakhueaʼ onʼbahuaʼpakapo kenpaʼti dosa trestaj huadak huaʼa onʼbatiaʼpakapo. ");
INSERT INTO amrNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Sueʼda doʼtaj onʼpakapo nogomeya̱nayo doʼtaj pakhueʼ o̱ʼnepo konige̱po oknopo̱e̱hueʼ hua̱e̱ʼeria dakhueaʼ onʼbahuaʼpakapo. Huaoapiʼ doʼtaj oknopo̱e̱hueʼda meʼe̱po huasiʼpotaj huaknopo̱e̱ʼeritaj yaʼhuadiayapet. Muneʼyo̱ huaknopo̱e̱ʼeritaj hua̱ye̱a̱ huadiaydik ya̱ʼe̱a̱pet. Huakabua huasuʼtaj huadiaydik ya̱ʼe̱a̱pet. —‍Jesúsa oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","—‍Opudomey indariyo moʼe̱po kurudyo̱ e̱ʼsi̱hui̱ʼ sika eʼbiaʼte niokpo yakudyon boʼtiahuaypo “Ohuiʼapo,” boaʼikaʼnig aʼti oʼhuiʼapo. ");
INSERT INTO amrNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Kenpaʼti indariyo moʼe̱po toyed eʼbapoknayo “juknanada o̱ʼe̱a̱po,” boaʼikaʼnig i̱da juknanada o̱ʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Opudomey namaʼda huanopo̱e̱ʼeri moʼe̱ne. Kurud boʼtiahuaypo oʼhuiʼapo kenpaʼti juknanada oʼtaʼteapo eʼnopo̱i̱kaʼada i̱nok doʼtanayo Diosen Cristo o̱ʼe̱ oknopo̱e̱hueʼ o̱ʼnene. —‍Jesúsa oʼmanaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","—‍Kenda huadak eʼkaʼ o̱ʼe̱. Kenyoʼda ʼuruda o̱ʼe̱. Opudomeya̱ onda nopo̱e̱ʼdik moʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","“O̱ʼna dakhueaʼ ikaʼne,” noga̱ enaʼnayo gobierno huairitaj boʼtohuaʼdepo eʼtohuaʼte kentaj yanoeya̱ʼ. Eʼmadehueʼnayo huakupepiʼ yayoktiʼ. Noeyahueʼpiʼ yokhueʼpiʼ e̱e̱ʼnayo gobierno huairitaj boʼtohuaʼapone. Ken gobierno huairi sorotatataj boʼyokapone. Sorotataa huabakuda̱ʼ jakyo boʼkuda̱ʼapone. ");
INSERT INTO amrNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ke̱yo̱da ijhueʼda o̱ro̱khueʼdik i̱ʼe̱a̱pone. Ayaʼda dehueʼte iʼyokdeʼpo o̱ro̱kdik i̱ʼe̱a̱pone. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kenokaʼ sueʼada Jesústaj oʼnonbatiaʼpakpo. Sueʼda huabokerek Galilea huadaribayo hua̱e̱ʼeri Diostaj oveja ʼuhua onʼnigbatiarakaʼdepo Pilato gobierno huairien soratataa Galileayo hua̱e̱ʼeri huabokerektaj onʼbatiarakaʼpo ʼuhua mimi huabokereken mimiere jontayoʼ oʼmimihuaʼuyate. Jesústaj oʼnonbatiaʼpakʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","3","—‍Kenomey huabokerek Galileayo hua̱e̱ʼeria dakhueaʼda o̱gkikaʼpo onʼmabueyʼuy. Nogomeynayo sueʼda dakhueaʼ huakaʼeri o̱ʼnepo mabueyhueʼ o̱ʼne. Kenpaʼ nopo̱e̱hueʼ yaneʼ, ijjay. Opudomey ayaʼda nopoʼkoreahueʼ e̱e̱ʼnayo kenpaʼti moʼmabueyapone. ");
INSERT INTO amrNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","5","Kenpaʼti Jerusalén huakkaʼ jakyo huabid jaktoneʼ o̱ʼhue̱kpo oʼmanbetuyate. Dieciocho huabokerektaj oʼmanbetuyate. Kenomey huabokereka onʼmabueyʼuyate dakhueaʼda huakaʼeri o̱ʼnepo konige̱po onʼmabueyʼuyate. Nogomey Jerusalén hua̱e̱ʼeri sueʼda dakhueaʼ huakaʼeri o̱ʼnepo bueyhueʼ o̱ʼneʼuyate. Kenpaʼ nopo̱e̱hueʼ yaneʼ, ijjay. Opudomey nopoʼkoreahueʼ e̱e̱ʼnayo kenpaʼti ayaʼda moʼmabueyapone. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesúsa ken konig o̱ʼe̱ oʼmanbatiaʼpakpo oʼmanmadikaʼpo, —‍Nogtida huabokereka taʼba oʼto̱e̱po menpaʼti higuera huada yanhuadmet oʼnopo̱e̱po taʼbayo oʼhuaʼpo huadataj oʼtiahuaynigʼa onhuadhueʼ o̱ʼe̱nok ");
INSERT INTO amrNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","taʼba huato̱e̱ʼeritaj, “E̱ya̱ʼ bapaʼ huabayok in taʼbayo ijtiakdemeʼnigʼa higuera hue̱ymey huada onhuadhueʼ o̱ʼe̱meʼ. Yataʼteg. In sorok huadak o̱ʼe̱nigʼa namaʼda oʼkerek.” Taʼba huato̱e̱ʼeritaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“In huabayoknayo taʼteghueʼ i̱jje̱a̱poy, hue̱ymeytaʼpo ijtoruapoy kenpaʼti ʼuhua ovejadohuaʼa ijtaʼpotibukapoy. ");
INSERT INTO amrNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nog manhuaʼataʼ yaʼdapakapetpiʼ. Dapakhueʼ e̱e̱ʼnayo ijtaʼtegapoy.” Taʼba huato̱e̱ʼeria onaʼuyate. —‍Ken konig Israel oknopo̱e̱hueʼ hua̱e̱ʼeri o̱ʼne Jesúsa oʼbatiaʼpakpo oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nogok okmapi̱e̱ʼahuaddik huameʼnoete judío aratbut baahueʼdik e̱ʼnikaʼte judióen hua̱i̱takeʼ jakyaʼ Jesúsa oʼmanmadikaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ke̱yo̱ hua̱i̱takeʼ jakyo ettoneʼ o̱ʼe̱po dakhueʼda o̱ʼeonhuahuikaʼuyate. Dieciocho huabayok dakhueʼda o̱ʼeonhuahuikaʼuyate. Dakhueaʼ totoʼa ken ettoneʼtaj o̱gkaʼnok sodoaʼ oʼboikaʼpo butukaʼ bohueʼdik o̱ʼi̱kaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesúsa oʼtiahuaydepo —‍Iʼyaredene, ettoneʼ. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ken Jesúsa oʼtibataʼtenok i̱da ken ettoneʼ butukaʼda oʼbodpo huaboaʼda “Dios ʼurunanada o̱ʼe̱,” kenpaʼti “dakiti Dios” oaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Hua̱i̱takeʼ jak huairianayo oʼhuadiayʼuyate. Judíoen okmapi̱e̱ʼahuaddik huameʼnoete Jesúsa oʼyareaʼdenok oʼhuadiaypo, —‍Seis huameʼnoe baaʼdik moʼe̱ne. Ken seis huameʼnoe eʼyareaʼtaʼ eʼpaknayo yanʼtiaktiʼ. Judíoen okmapi̱e̱ʼahuaddik huameʼnoete beʼyareʼpo tiakhueʼ yanikaʼ. —‍Hua̱i̱takeʼ jak huairia oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","—‍Namaʼda huanopo̱e̱ʼeri moʼe̱ne. Okmapi̱e̱ʼahuaddik huameʼnoete opudomey ayaʼda opudomeyen vacatapiʼ burrotapiʼ hue̱ʼe̱y kanʼmaye̱ʼpo boʼtikujpo hue̱ʼe̱yte boʼtohuaʼikaʼne. ");
INSERT INTO amrNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","In ettoneʼ Abrahamen adhueaʼ huayayo e̱e̱ʼtada totoʼ huairia dakhueaʼ o̱gkadhuahuikaʼnok ettoneʼ dakhueʼda o̱ʼeonhuahuaikaʼpo dieciocho huabayok dakhueʼda o̱ʼeonhuahuikaʼuyate. Okmapi̱e̱ʼahuaddik huameʼnoete eʼyareaʼ huadak o̱ʼe̱. Dapiʼ huadakda o̱ʼe̱ yanʼnopo̱e̱ʼ. —‍Jesús Huairia judióen hua̱i̱takeʼ jak huairitaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesúsa kenda enadeʼte kenomey Jesústaj onʼhuadiayikaʼnigʼa onʼmabiraʼuyate. Nogomeynayo ayaʼada Jesústaj durugda o̱ʼnepo, kenda ʼuruaʼda Jesúsa oʼkikaʼ onʼtiahuaydepo kentaj durugda o̱ʼnuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","—‍Huadak huaʼa konig Dios Huairitaj oʼnoknopo̱e̱a̱ponigtaj onʼnigpe̱e̱a̱ponigtaj ken konig o̱ʼe̱a̱po ijmanbatiaʼpakpo ijmanmadikaʼapoy. ");
INSERT INTO amrNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Konig huabokereka suigkidda mostaza huakid oʼtuk. Kenkida oʼkerekdepo nogok huaboroʼda o̱ʼe̱depo huaʼopite huakkaʼ bakoya oʼpakkaʼ. Konigti huakkuru Dios Huairien huaknopo̱e̱ʼeri sueʼda o̱ʼne. Nogok huakkaʼada Dios Huairitaj oʼnoknopo̱e̱po onʼnigpeonhuahuikaʼpo huakkaʼnada huaknopo̱e̱ʼeri o̱ʼneapo. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","—‍Huadak huaʼa konig Dios Huairitaj oʼnoknopo̱e̱a̱ponigtaj onʼnigpe̱e̱a̱ponigtaj ken konig o̱ʼe̱a̱po ijmanbatiaʼpakpo ijmanmadikaʼapoy. ");
INSERT INTO amrNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Konig sigda pan eʼbiaʼo̱gʼa ettoneʼa̱ huakkaʼ harinao̱gyo̱ oʼtokbuk. Harinao̱gyo̱ eʼbiaʼo̱gʼ oʼtokbukdepo dakaʼ o̱gkuayaga̱ʼ. Huabada oʼkudapo. Ayaʼda oʼbiaʼapo. Eʼbiaʼo̱gʼa oʼbiaʼpo konig Dios Huairien huadak huaʼa onʼmanmadikaʼnok huakkaʼada nogya̱ʼ nogya̱ʼ huabada oʼnoknopo̱e̱a̱po. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jerusalényon Jesúsa oʼhuaʼudhuaʼpo nog huakkaʼ jakyo nog huakkaʼ jakyo oʼpokandepo oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","—‍¿Menpaʼ Diosa sueʼtada yaʼmanopoʼyareaʼapo? —‍Nogtiada Jesústaj onaʼnok, ");
INSERT INTO amrNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—‍Diosyo huahuaʼ konig suigda akbogpe huakud o̱ʼe̱nok huakkaʼ yanʼpakpo yanʼkud. Huakkaʼada e̱gkudtaʼ onʼpakpo onhuahuaʼnigʼa kudhueʼdik o̱ʼneapo Diosenbayo aʼkudyaʼpo konig o̱ʼe̱ ijmanbatiaʼpakapoy. ");
INSERT INTO amrNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Jak huato̱e̱ʼeri huairi nogok eʼmabodeʼte akbogpe jokhuikdepo opudomey dakhueaʼ huakkaʼeri jak kurute moʼe̱po “Moʼnigokhuikeʼ, Huairi.” Monaʼaponigʼa. “Opudomey meyo̱ hua̱e̱ʼeri moʼe̱t. O̱ki̱e̱hueʼya o̱ʼnene.” Huairia oʼmanaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","“Onere oʼbapeʼikay kenpaʼti onere oʼmayʼikay kenpaʼti oroʼomeyen jak kurutaʼ onmadikaʼonhuahuaʼuyne.” Opudomeya̱ huaboaʼda monaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","“Opudomey meyo̱ hua̱e̱ʼeri moʼe̱t oʼnonaʼdene. Doʼtaj meʼnokhuaʼ. Dakhueaʼ huakaʼeri moʼe̱ne.” Huairia monaʼapone. Kenda konigti Diosa monaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Ke̱yon dakhueaʼ huakaʼeria bokbahuaʼdepo paiʼda moʼmanopoʼe̱a̱pet. Kenpaʼda Diosyo huahueʼdik moʼe̱a̱popo. Abraham Isaacere Jacobere Diosen huamanbatiaʼpakeriere Dios Huairiere adyo̱da e̱e̱ʼneʼte moʼbatiahuaydepo. Diga̱ʼda moʼbahuikonhuahuikaʼapo. Paiʼda moʼnopoʼe̱po boʼidokbokeʼapo. ");
INSERT INTO amrNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Kenpaʼti aratbut Dios Huairitaj onʼbatiakapo. Niokpo eʼo̱ro̱kyen onʼtiakapo. Niokpo eʼhuakudyen onʼtiakapo. Toyaʼ kenpaʼti kutayaʼ onʼtiakapo. Nogya̱ʼ nogya̱ʼ Dios huairitaj onʼhuatiakapo. Dios Huairiere konig keʼnensiʼpo onʼbapeʼikaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Huakkaʼada oy konig Diosen aratbut ehueʼda o̱ʼne. Judío aratbut ehueʼda o̱ʼne. Nogok Diosa oʼmatinepahuinok Diosere o̱ʼneapo. Nogomey judío aratbutpiʼ oy Diosen aratbut o̱ʼe̱y onʼnopo̱e̱nigʼa nogok Dostaj oknopo̱e̱hueʼ o̱ʼneaponok Diosa matinepahuihueʼ oʼmaeapo. Diosere ehueʼda o̱ʼneapo. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Kenokaʼ sueʼda fariseo aratbut oʼnokye̱po, —‍I̱ya̱ʼ yabakhuaʼ. Herodes gobierno huairia ontaj eʼaraktaʼ oʼpak. —‍Fariseoa Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","—‍Yanhuatiʼ. “E̱ya̱ʼ, oy emeʼtekon sueʼda huameʼnoe totoʼtaj ijmaenapoy kenpaʼti ijbayareaʼapoy dakhueʼtaj ijbayareaʼapoy. Emeʼte kentaʼ ayaʼda ijkuhuitapoy, oaʼ,” Herodestaj ya̱ʼnonaʼ. Herodes namaʼda huaaʼeri konig engaña huaaʼeri o̱ʼe̱. Fariseomeytaj oʼmanaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ken oy emeʼte admeʼtaʼ nog admeʼtaʼ nog admeʼtaʼ Jerusalényo̱ huaʼdik i̱jje̱y. Jerusalénya̱yo̱ʼ Diosen huamanbatiaʼpakeri bueydik o̱ʼnikaʼ. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","—‍Jerusalényo̱ hua̱e̱ʼeritaj oʼnonaʼne. Diosen huamanbatiaʼpakeritaj moʼmabatiarakikaʼuyate. Kenpaʼti Diosa oʼmataʼmonaʼuyatenigtaj, kenomeytaj huida̱ moʼbapaʼeaʼpo moʼmabatiarakikaʼuyate. Konig huatahuaj hua̱ye̱a̱ huasiʼpotaj okajpea oʼbatiokaʼikaʼ konigti opudomeytaj aʼbatiokayaʼpo eʼkupopakataʼ ijpakuynigʼa, nogok nogok aʼbatiokayaʼpo eʼkupopakataʼ ijpakuynigʼa opudomeynayo pakhueʼda moʼe̱ʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Opudomeyen jakyaʼ Diosa oʼbakhuaʼde. Opudomeytaj tiokahueʼ moʼe̱a̱pone. Tihuapokhueʼ moʼe̱a̱pone. Kenpaʼti nopoʼyareahueʼ moʼe̱a̱pone yanʼnopo̱e̱ʼ. Nogok doʼtaj tiahuayhueʼ o̱ʼneonhuahuikaʼapone. “Dios Huairia in huabokerektaj oʼtaʼmonaʼuyate. Huadakda o̱ʼe̱.” Nogoknanada monaʼdeapone kenda onteʼti doʼtaj boʼtiahuayapone. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Nogok okmapi̱e̱ʼahuaddik huameʼnoete aʼbapeyaʼpo Jesús oʼhuaʼuyate. Fariseo huairien jakyo oʼhuaʼpo, nog fariseo huairi o̱ʼnepo menpaʼ Jesús okmapi̱e̱ʼahuaddik huameʼnoete yaʼyareapetpiʼ onʼnopo̱e̱po Jesústaj dakaʼ onʼtiahuayʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Jesús huakkuruyon huabokerektaj okpo̱e̱po dakhueʼda o̱ʼe̱po huabopij huaʼopiere diga̱ʼda oʼiyokuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","—‍¿Okmapi̱e̱ʼahuaddik huameʼnoete menpaʼ yareaʼdik ya̱ʼe̱? ¿Menpaʼ yareahueʼdikpiʼ ya̱ʼe̱? —‍Jesúsa oʼmanaʼpo, Moisésenbaʼ huamanmadikaʼeritaj kenpaʼti fariseotaj oʼmanaʼnok. ");
INSERT INTO amrNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Huamanmadikaʼeri fariseoere aʼtokhueʼda o̱ʼnenok Jesúsa dakhueʼtaj oʼyareadpo oʼtaʼmonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Onteʼti fariseomeytaj, —‍Opudomey o̱ʼnen burropiʼ vacapiʼ hue̱ʼe̱y huabid sorokkogyo̱ okmapi̱e̱ʼahuaddik huameʼnoete e̱e̱ʼpiʼ eʼtakotnayo dapitaʼ i̱da sorokkogyo̱ boʼtotokatuʼikaʼ. Opudomey kenda dakaʼ moʼnopo̱e̱. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Kenda Jesúsa eadeʼte buttida o̱ʼe̱ onʼnopo̱e̱po nogda aʼtokhueʼ o̱ʼnepo sohuataʼda oʼnoke̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ken fiestayo onʼbatiakpo kutopate onʼbahuadpo kente huairi onʼhuadikaʼ ken huahuadtaj onʼukpo onʼhuaduyate. Jesúsa kenda oʼtiahuaydepo oʼmanmadikaʼpo: ");
INSERT INTO amrNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—‍Eʼto̱e̱pak fiestate yatiaktiʼ enadeʼte onʼhuaʼdepo huairi o̱ʼe̱ aratbuta meʼnoknopo̱e̱ʼpo kente huaboroʼ huairi onʼhuadikaʼ kente huadhueʼ yanikaʼ. Huairien huahuadte eʼhuadnayo nogda huakhuairi oʼtiakatoapopiʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Fiesta huakaʼeria ontaj behuatiakaponepiʼ. “Yakboʼ in huabokerek kente oʼhuadapo,” menaʼapetpiʼ. Ken nogyon kente huanabaʼ onʼhuadikaʼnig kente huaddik i̱ʼe̱a̱po. Iʼbiraʼepo nogtekon iʼhuadapone. ");
INSERT INTO amrNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Eʼto̱e̱pak fiestayo yanhuaʼpo kente huiri ehueʼa onʼhuadikaʼ kente yanhuadatotiʼ. Kente eʼhuadte fiesta huakaʼeria oʼtiakdepo, “Nogyon kente huairi onʼhuadikaʼnig kente yahuad, huadiʼ.” Ontaj onaʼdik moʼe̱a̱pet. Kenokaʼ huadakda i̱ʼe̱po konig huairi i̱ʼe̱ ayaʼada kutopate onʼhuadpo onʼnopo̱e̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","“Huairi i̱jje̱y,” aratbut huataʼda namaʼda eʼtinopo̱e̱ʼnayo “Huairi ehueʼ i̱ʼe̱,” Diosa oʼbatiaʼpakapo. “Huairi ehueʼ i̱jje̱y.” Aratbuta huataʼda eʼtinopo̱e̱ʼnayo “huairi i̱ʼe̱.” Diosa oʼbatiaʼpakapo. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","“Eʼto̱e̱pak fiestate yatiaktiʼ Jesús.” Fariseoa onameʼnigtaj kentaj Jesúsa onaʼpo, —‍Nogok onteʼti fiesta iʼkaʼpo huakkaʼ aypo iʼmanhuada̱ʼpo, huadiʼtaj, huamaʼbuytaj, huaojtaj, hua̱ye̱taj, huairitaj “Yanʼtiaktiʼ, aypo doere monʼbapeʼ.” Kenomeytaj manahueʼ ya̱i̱kaʼ. Kenomeytaj eʼtobapeʼnayo onteʼti kenomeyere iʼbapeʼapetpiʼ kenpaʼti dehuehueʼ moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Fiesta ekaʼnayo huakkaʼ aypo eʼmanhuada̱ʼnayo “Yanʼtiaktiʼ doere aypo monʼbapeʼ.” Paiʼda hua̱e̱ʼeritaj, dakhueʼso̱ʼtaj, huakkettaj, ekpobigtaj yamanaʼikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kenda eʼmanaʼikaʼnayo durugda i̱ʼe̱a̱ponok kenomeya̱ kenpaʼti ontaj tobapehueʼdik moʼe̱a̱pone Diostaj dakaʼ huanigpe̱i̱kaʼeri kurudyo̱ Diosyo enʼhuadeʼte Diosa huadakda moʼnigkaʼapone. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nogtida huabokereka kutopate oʼtohuadpo Jesústaj kenda oʼpe̱e̱depo Jesústaj —‍In huadariyo Dios Huairiere Diosen aratbutere durugteda onʼbapeʼapo. —‍Kenbokereka Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesúsa oʼmanbatiaʼpakpo oʼmanmadikaʼpo, —‍Huairia aʼti huakkaʼtada aypo kanʼmanigmanhuadje̱ʼpo oʼmanaʼapo. Huanabaʼtaj oʼmataʼmonaʼpo, “Huairia beʼtobapeʼpo aʼti aypote yanʼtiaktiʼ.” Yanʼmanaʼ. Huakkaʼtada yanʼmanatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ken aypo eʼmahue̱ydeʼte, onteʼti huanabaʼtaj oʼmataʼmonaʼpo, kenomeytaj ʼikken moʼmanameʼte “Oyda yanʼtiak. Aypo oʼmahue̱yde yanʼtiak.” Yanʼmanatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Kenda eʼpe̱e̱deada “Aypote huahueʼdik i̱jje̱y.” Ayaʼada huaboaʼda konigti onʼmanaʼpo, “Taʼba huakupete ekkaiʼmeʼtenok tiahuayatudik i̱jje̱y. Konige̱po aypote huahueʼdik i̱jje̱y. Huairia doʼtaj huadiayhueʼ ke̱ʼe̱ʼ.” Huakkuruda huanabaʼtaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Noga̱ “Diez toros konig ʼuhua vaca konig tronco huatotokeri huakupete ijbaeʼdey. Menpaʼti huadakda totokdik ya̱ʼe̱taʼpo tiahuaydik i̱jje̱y. Aypote huahueʼdik i̱jje̱y. Huairia doʼtaj huadiayhueʼ ke̱ʼe̱ʼ.” Noga̱ huanabaʼtaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Noga̱ “Ijto̱e̱pakdey. Konige̱po aypote huahueʼdik i̱jje̱y.” Noga̱kon onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Huanabaʼ huairitaj onʼkumejdepo kenda aratbuta onʼmanaʼdenig huairitaj oʼnonaʼtoʼuyate. Kenokaʼ huairi oʼdiayonpo, “Huakkaʼ jak kurute yanhuatiʼ. Ayaʼ jak kurute yanhuaʼetiʼ. I̱yo̱ paiʼda hua̱e̱ʼeritaj yanʼbatotiaktiʼ. Dakhueʼ hua̱so̱ʼ hua̱e̱ʼeritaj yanʼbatotiaktiʼ. Huakkettaj yanʼbatotiaktiʼ. Kenpaʼti huakpobigtaj yanʼbatotiaktiʼ.” Huairia huanabaʼtaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Nogok huanabaʼ onteʼti onʼtiakdepo, “Konig o̱ʼna onameʼnig konigti oʼkay, huairi, huakked huahuad o̱ʼe̱nok nogda tiakdik o̱ʼne.” Huanabaʼa oʼnonaʼnok ");
INSERT INTO amrNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Nogyon nogyon dagtepiʼ hua̱hue̱tepiʼ meyo̱piʼ aratbut e̱ʼneʼte, huairien aypote yanʼtiaktiʼ i̱ghuaʼda yanʼmanatiʼ. Huakkaʼda doʼhued jakyo e̱ʼta̱e̱taʼ ijpaki. ");
INSERT INTO amrNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Konige̱po ayaʼda huakkurueritaj yanʼtiak, doere yanʼbapeʼ ijmanaʼnigʼa ayaʼada doʼere huakkaʼ aypo bapehueʼ o̱ʼneapo.” Huairia huanabaʼtaj oʼmanaʼuyate. —‍Ken konig Dios Huairia oʼkaʼapo Jesúsa oʼmanbatiaʼpakpo oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jesústaj huakkaʼada aratbut onʼtahuaʼenok oʼbatikorudpo, oʼmanaʼpo: ");
INSERT INTO amrNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—‍Beʼapiʼ doʼtaj eʼnigpe̱i̱kaʼtaʼ eʼpaknayo doʼtaj huakkaʼda diʼ e̱ʼdik meʼnikaʼ. Huaojtapiʼ hua̱ye̱tapiʼ hua̱to̱e̱ʼtapiʼ huasiʼpotapiʼ huamaʼbuytapiʼ huidpotapiʼ huataʼdapiʼ sueʼda diʼ yanikaʼ. Doʼtanayo huakkaʼda diʼ e̱ʼdik yanikaʼ. Beapiʼ doʼtaj huakkaʼda diʼ ehueʼ e̱e̱ʼnayo doʼtaj nigpe̱i̱kahueʼdik moʼe̱a̱pone. Doʼhued huanigpe̱i̱kaʼeri ehueʼdik moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Konig hue̱ypa cruzte paiʼda onʼnopoʼe̱po konigti doʼtaj aʼnigpe̱i̱kayaʼpo paiʼda eʼnopoʼe̱taʼ pakhueʼ e̱e̱ʼnayo doʼhued huanigpe̱i̱kaʼeri ehueʼdik moʼe̱a̱pone. Kenpaʼde hua̱ʼenda eʼpaknayo doʼhued huanigpe̱i̱kaʼeri ehueʼdik moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Menpuru doʼhuedda katepiʼ ijeretpakikaʼnig Jesústaj aʼnigpe̱i̱kayaʼpo onteʼti doʼhuedda eretpakhueʼ i̱jje̱a̱po, kenpaʼ huakkuruda dakaʼ yanʼnopo̱e̱po. Kenpaʼda hua̱ʼenda eʼpaknayo doʼhued huanigpe̱i̱kaʼeri ehueʼdik moʼe̱a̱pone. Doʼhued huanigpe̱i̱kaʼeri e̱e̱ʼtaʼ eʼpaknayo huakkuruda monig kaʼdik i̱jje̱ dakaʼ yanʼnopo̱e̱po. Paiʼda ijnopoʼe̱a̱petpiʼ, nogpiʼ ayaʼ ijmato̱e̱nig paiʼda hua̱e̱ʼeritaj bayokdik i̱jje̱a̱petpiʼ, kenpaʼ huakkuruda dakaʼ yanʼnopo̱e̱po. Konig huabokerekpiʼ huaboroʼ jak eʼkaʼtaʼ oʼpakpo huakkuruda menigte e̱ʼdik ya̱ʼe̱t dakaʼ oʼnopo̱e̱po. Sueʼda eʼto̱e̱ʼnayo jak huaboaʼda kahueʼ o̱ʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Dakaʼ nopo̱e̱hueda̱da ekaʼnayo jak ʼiddu oʼkaʼdenigʼa siro jaktaj huakupebayoʼ o̱ʼe̱po dakeahueʼdik o̱ʼe̱nok ayaʼada kentaj onʼtierikapo. ");
INSERT INTO amrNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","“Ken huabokereka huaboroʼ jak eʼkaʼtaʼ oʼpaknigʼa jak dakeahued huakupe oʼdakeaʼpo jaknayo dakeahueʼdik o̱ʼe̱a̱po.” Huayahuaya kenda onʼmanaʼpo onʼtierikapo. ");
INSERT INTO amrNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Konigti gobierno huairipiʼ diez mil sorotataj oʼmato̱e̱po nog gobierno huairipiʼ keʼnen takaʼ veinte mil sorotataj oʼmato̱e̱po onʼtiak. Tiakhueda̱ded gobierno huairi diez mil sorotataj oʼmato̱e̱po dakaʼ nopounhuaʼdik o̱ʼe̱a̱po. “Doʼhued diez mil sorotataj menpaʼ gana kaʼdik ya̱ʼnet.” Nopo̱e̱ʼdik o̱ʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Gana kahueʼdik o̱ʼneapo. Eʼnopo̱e̱ʼnayo sueʼda huabokerektaj takaʼ huairitaj oʼmataʼmonaʼapo. “Eʼmanoeyaʼtaʼ oʼpaki.” Takaʼ huairitaj ya̱ʼnonaʼ. Oʼmanaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ken konig, “Jesústaj aʼnigpe̱i̱kayaʼpo Dios Huairia eʼpaknayo doʼhuedda eretpakhueʼ i̱jje̱po ayaʼda ijmato̱e̱nig kenpaʼda ijmaenapoy.” Kenpaʼ nopo̱e̱hueʼ e̱e̱ʼnayo doʼhued huanigpe̱i̱kaʼeri ehueʼdik moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Sal huadakda o̱ʼe̱po aratbuttehuapaʼ. Konigti doʼhued huanigpe̱i̱kaʼeri konig sal huadakda o̱ʼnepo aratbuttehuapaʼ huadakda o̱ʼne. Sal huadak ehueʼ e̱e̱ʼnayo onteʼti huadak kahueʼdik o̱ʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Sal huadak ehueʼ e̱e̱ʼnayo huadaritehuapaʼ huadak ehueʼdik o̱ʼe̱a̱po. Paichi kahueʼdik o̱ʼe̱a̱po. Kenpaʼda enʼdik o̱ʼe̱. Dakaʼ menʼpe̱e̱ʼ. Dakaʼ meʼnoknopoenkaʼ. —‍Kenda Jesúsa oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Jesústaj aʼpe̱e̱yaʼpo ayaʼada gobierino huakupe huabaeʼeri dakhueaʼ huakaʼeriere Jesústaj onʼhuahuaʼpo. Ken gobierno huakupe huabaeʼeri engaña huakaʼeri o̱ʼnikaʼpo dakhueaʼ huakaʼeriere Jesústaj onʼhuahuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","—‍Dakhueaʼ huakaʼeritaj oʼbaeʼ. In huabokereka dakhueaʼ huakaʼeritaj oʼbaepo oʼbatobapeʼ. —‍Fariseo hua̱e̱ʼeri Moisésenbaʼ huamanmadikaʼerierea Jesústaj dakhueaʼ onʼhuaaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Jesúsa oʼmanbatiaʼpakpo oʼmanmadikaʼpo, ");
INSERT INTO amrNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—‍Cien oveja on eʼto̱e̱ʼnayo nogtida eʼtitikonnayo nogomey noventa y nueve mire̱bate oveja enʼmaeʼte iʼbakhuaʼapo ken nogtida ovejataj iʼukapo. Eʼhuahuaytaʼda iʼpakpo iʼukpo. ");
INSERT INTO amrNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Iʼhuahuaydepo iʼkumeʼpepo durugda i̱ʼe̱a̱pone. Jakyo iʼhuaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Jakyo iʼtiakdepo ayaʼtada huadiʼtaj iʼbakupopakaʼpo, “Doʼhued oveja oʼtitikonmeʼtenig ken ijhuahuaydey. Konige̱po doere moʼdurugpak,” o̱ʼna iʼmanaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Konigti nogtida dakhueaʼ huakaʼeri Diostaj oʼnopoʼkoreaʼdepo onteʼti Diostaj ijnigpe̱e̱a̱poy oʼnopo̱e̱depo kurudyo̱ durugnanada o̱ʼneapo. Nogomey noventa y nuevepiʼ sueʼda huadak o̱ʼnepo Diostaj nopoʼkoreahueʼdik o̱ʼe̱y onʼnopo̱e̱nok kenomeytaj kuruderia durugda mato̱e̱hueʼ o̱ʼneapo. Ijjay. —‍Jesúsa oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","—‍Bepiʼ ettoneʼ diez oro huakupe e̱ʼta̱e̱a̱da nogtida eʼtitikonnayo huakjey oʼbakpakapo kenpaʼti oʼukpo jonberokeapo, jakyo jonberokeapo, jakyo dakaʼ oʼukonhuaʼpo eʼhuahuaytaʼda oʼpakpo oʼukonhuaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ken huakupe oʼhuahuaydepo ettoneʼ huadiʼtaj kenpaʼti nogomey meyo̱hueʼda jakyo hua̱e̱ʼeritaj oʼbakupopakapo, “Ken huakupe beʼtatitikonmeʼnig ijhuahuaydey doere moʼdurugpak.” Ettoneʼa̱ oʼmanaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Konigti nogtida dakhueaʼ huakaʼeri eʼnopoʼkoreaʼnayo kurudyo̱ Diosere Diosen huataʼmoneri durugnada o̱ʼneapo, ijjay. —‍Ken konig Jesúsa oʼmanbatiaʼpakpo oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","—‍Aʼnenda huabokerek o̱ʼu̱yate. Botsiʼpoaʼ huabokerek huasiʼpo oʼto̱e̱po, ");
INSERT INTO amrNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","huasueda̱ huaojtaj, “Konig huaoj eʼbueyte huasiʼpotaj onʼbayokikaʼ oyda ijpaknok o̱ʼna bueyhueda̱ded katepiʼ huakupepiʼ beyok, pag.” Huasueda̱ huaojtaj onaʼuyate. Ken huaoj keʼnen bottaʼsiʼpotaj keʼnen oʼtamaeʼuy oʼbayokeʼ. Huakkaʼda oʼtamaenok oʼbayokeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Sueʼda huameʼnoe eʼpokdeʼte huasueda̱ huasiʼpoa ayaʼda huaboaʼda huaojen oʼto̱e̱depo nog huadaribayo bidteda oʼhuaʼuyate. Ke̱ya̱ʼ dakhueaʼ oʼkadhuahuaʼpo ayaʼda keʼnen huakupe gasta oʼkaʼpo dakhueaʼda oʼkaʼpo gasta oʼkaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Kenokaʼ ayaʼda gasta oʼkaʼdepo huakupebayoʼ o̱ʼe̱depo ken huadaribayo huiʼhueʼda o̱ʼe̱po aypobayoʼ o̱ʼnenok keʼna huaboaʼda oʼkusitokpo. ");
INSERT INTO amrNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Konige̱po ken huadari huato̱e̱ʼeritaj oʼhuahuaʼuyate. Keʼnen aʼtabaayaʼpo oʼhuahuaʼuyate. Ken huadari huato̱e̱ʼeria keʼnen huakyaritaj metamato̱e̱ʼpo oʼtaʼmonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Keʼna diga̱ʼda oʼkusitokpo huakyarien aypo eʼpaktada nog huakyariʼ huato̱e̱ʼeria yokhueʼ o̱ʼnuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Konige̱po huaboaʼda dakaʼ oʼnopo̱e̱po “Doʼhued huaojen jakyo huakkaʼda huanabaʼ e̱ʼe̱a̱da huakkaʼda aypo onʼto̱e̱po ayaʼ bapehueʼdik o̱ʼnikaʼ. Donayo i̱yo̱ aypotaʼ bueydik i̱jje̱a̱poy. ");
INSERT INTO amrNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Doʼhued huaojenbayo ijkumejapoy. ‘Diostaj dakhueaʼda ijkadhuahuaʼmey kenpaʼti ontaj dakhueaʼda ijkaʼmey. ");
INSERT INTO amrNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Onteʼti huasiʼpoaʼ onahueʼ meetiʼ. O̱ʼnen huanabaʼ e̱e̱ʼtaʼ ijpaki, pag.’ Ken doʼhued huaojtaj anayʼ,” oʼnopo̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ken keʼnen huaojen jakyo huaboaʼda onaʼti oʼkumeʼuyate. Ken jakyo iboteda e̱e̱ʼdeʼte kentaj keʼnen huaoa oʼtiahuaydepo oʼtinepahuiʼpo huasiʼpotaj oʼhuaketpo diʼ o̱ʼe̱po oʼdokopo kenpaʼti oʼbuyukuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Huaojtaj “Diostaj dakhueaʼda ijkadhuahuaʼmey. Ontakon dakhueʼda ijkaʼmey. Onteʼti sionaʼ onahueʼdik meetiʼ, pag.” Huasiʼpoa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Huanabaʼtaj “ʼUruda huaot yanʼtotiakpo yanottaʼ. Kenpaʼti huabapiokot yanottaʼ. Huaʼiotkon yanottaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Kenpaʼti ken huabo vaca sihuada e̱ʼhua̱e̱ʼ yanʼtotiakpo yanʼarak. Fiesta mogkaʼ. Huakkaʼ aypo monʼbapeʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Doʼhued huasiʼpoa konig ekbueyonig meʼi̱kaʼnigʼa oy onteʼti oʼnoe. Aʼnen oʼtitikonʼuynig oy huaboaʼda oʼhuahuaydey.” Huaoa huanabaʼtaj oʼmanaʼuynok huaboaʼda fiesta o̱gkaʼdeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Kenokaʼ huatoneʼmaʼbuy taʼbayo o̱ʼe̱po oʼbaaʼpo jakyo oʼtiakdepo música oʼpe̱e̱po kenpaʼti e̱ʼhua̱k oʼpe̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Huaojen huanabaʼtaj “¿Katiaʼpo ya̱gkaʼ?” onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“O̱ʼnen huamaʼbuy oʼtiakdenok kenpaʼti dakda o̱kye̱yaknok o̱ʼnen huaoj huabo vaca e̱ʼhua̱e̱ʼ sihuada huanabaʼtaj yaarak oʼmanaʼ.” Huanabaʼa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Huatoneʼmaʼbuya oʼdiaypo “Jakyo kudhueʼ i̱jje̱a̱poy.” Oaʼ. Keʼnen huaoa oʼhua̱o̱ro̱konpo, “Yakud ijjay,” enaʼtada ");
INSERT INTO amrNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","“Huakkaʼda huabayok o̱ʼnen ijbaaʼonhuahuaʼikaʼnigʼa, ontaj oʼnigpe̱i̱kaʼnigʼa, fiesta doʼhued huadiʼtaj kabatokeʼpo doʼtaj sigpiʼ yokhueʼ o̱ʼi̱kaʼne. Cabrito konig ʼuhua sueʼpiʼ yokhueʼ o̱ʼi̱kaʼne. ");
INSERT INTO amrNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","O̱ʼnensiʼponayo huakkaʼda o̱ʼnen huakupe oʼbaeʼuynig potajtaj oʼbayokuyate. Oy eʼkumejdeʼte huabo vaca e̱ʼhua̱e̱ʼ sihuada i̱ʼnigarakdene.” Huaojtaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Onnayo doereda i̱ʼi̱kaʼne, ayaʼda ijmato̱e̱nig o̱ʼnen kenpaʼti iʼta̱e̱ne. ");
INSERT INTO amrNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Oy durugpakdik o̱ʼe̱ne kenpaʼti fiesta kaʼdik o̱ʼe̱ne konige̱po o̱ʼnen huamaʼbuy konig eʼbueyda o̱ʼemeʼnigʼa oy onteʼti oʼnoe. Konig oʼyoyahueʼuyatenigʼa oy oʼhuahuaydey, sion.” Huaoa onaʼuyate. —‍Kenda Jesúsa oʼmanbatiaʼpakpo ken konig eʼnopoʼkoreaʼnayo dakhueaʼ huakaʼeritaj Apag Diosa oʼmatinepahuiʼpo oʼbakkahueaʼikaʼapo oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Huanigpe̱i̱kaʼeritaj oʼmanbatiaʼpakpo oʼmanmadikaʼpo, —‍Huairi o̱ʼu̱yate. Huakkaʼda oʼtamaenok huatamato̱e̱ʼeria oʼtamato̱e̱po, “O̱ʼnen huatamato̱e̱ʼeri huabokerek o̱ʼnen iʼtamaenig dakaʼ tamato̱e̱hueʼada dakhueaʼ iʼtakikaʼne.” Aratbuta onʼhuaaʼnok, ");
INSERT INTO amrNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","“Yatiak.” Huatamato̱e̱ʼeritaj onaʼuyate. Eʼtiakdeʼte “Doʼhued eʼtamato̱e̱ʼada namaʼda oʼbayokikaʼ. Nogomeya̱ menonaʼne. Onteʼti doʼhued huatamato̱e̱ʼeri ehueʼda i̱ʼe̱a̱pone. Ayaʼda eʼbahuayaʼbaʼ kenpaʼti ayaʼda eʼbaeʼbaʼ menigtotiak.” Huairia huatamato̱e̱ʼeritaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Oy huairia meʼendene keʼnen huatamato̱e̱ʼeri onteʼti ehueʼda i̱jje̱a̱poy. ¿Kate ijkaʼapet? Teyhueʼda i̱jje̱po taʼba kahueʼdik i̱jje̱y. Konig aratbuttaj huakupe beyok eʼmanikaʼtaʼ pakhueʼ i̱jje̱po, ijbiraʼi.” Kenda huairien huatamato̱e̱ʼeria huanopoyaʼda oʼnopo̱e̱po. ");
INSERT INTO amrNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","“Oyda kenda ijkaʼapoy ijnopo̱e̱y. Nogok jak to̱e̱hueʼ e̱ʼe̱deʼte, huakupe to̱e̱hueʼ e̱ʼe̱deʼte, aypobayoʼ e̱ʼe̱deʼte aratbuta kenomeyen jakyo doʼtaj medeapetpiʼ kenda ijkaʼapoy ijnopo̱e̱y.” Kenpaʼ huanopoyaʼda oʼnopo̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Kenomey doʼhued huairitaj dehueaʼ eʼnahue̱ʼtaj kenomeytaj nogti nogtiaʼ menigtotiak onaʼnok. Huakkuru huatiakeritaj “¿Doʼhued huairitaj meniga̱ʼ dehueaʼ i̱ʼe̱?” Huakkuru dehueaʼ hua̱e̱ʼeritaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“Cien kajapotoneʼte huasihuaj dehueaʼ i̱jje̱y.” Huakkuru huabokereka onaʼnok “In o̱ʼnen dehueaʼ e̱ʼhua̱e̱ʼbaʼ iʼte̱ne, i̱da yahuadpo yamadoyaʼ, cincuentayoʼda yamadoyaʼ. Ken onteʼti huairitaj cincuentayoʼda dehueaʼ i̱ʼunapone.” Huairien huatamato̱e̱ʼeria onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Noga̱kon eʼtiakdeʼte “¿O̱ʼna meniga̱ʼ dehueaʼ i̱ʼe̱?” Nogtaj onaʼnok, “Cien huaboroʼ saco trigo dehueaʼ i̱jje̱y.” Noga̱ onaʼuyate. “In o̱ʼnen dehueaʼ e̱ʼhua̱e̱ʼbaʼ iʼte̱ne, kente ochenta huaboroʼ sacoyoʼda yamadoyaʼ. Ken onteʼti huairitaj ochenta huaboroʼ sacoyoʼda dehueaʼ i̱ʼunapone.” Huairien huatamato̱e̱ʼeria onaʼuyate. Kenda konigti nogtaj nogtaj dehueaʼ hua̱e̱ʼeritaj oʼmanaʼuyate. Konige̱po nogok dehueaʼ hua̱e̱ʼeria huairien huatamato̱e̱ʼeritaj yaʼdeapetpiʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Huairien huatamato̱e̱ʼeri ken konig oʼkaʼde huairi oʼnokotdepo, “In dakhueaʼ huatamato̱e̱ʼeria dakhueaʼ beʼtakaʼ aratbuta kentaj nogok mentihuapokeʼpo dakaʼ akayaʼ oʼnopo̱e̱po. In huadariyo Diostaj oknopo̱e̱hueʼ hua̱e̱ʼeri aratbut nogtaj nogtaj ʼuruaʼda akayaʼ onʼnopo̱e̱po, nogok kenpaʼti mentihuapokeʼpo. Diostaj huaknopo̱e̱ʼerinayo sueʼda ʼuruaʼda akayaʼ onʼnopo̱i̱kaʼ, nogok sueʼda mentihuapokedepo.” ");
INSERT INTO amrNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Konige̱po huakupepiʼ nog katepiʼ moʼto̱e̱po namaʼda gasta kaʼdik moʼi̱kaʼpiʼ. Huataʼda boʼpakpo Diostaj nigpe̱e̱hueʼda moʼe̱po gasta kaʼdik moʼi̱kaʼpiʼ. Huataʼda boʼeretpakpo namaʼda baeʼikaʼdik moʼe̱piʼ. Diostaj dakaʼ yanʼnigpe̱e̱po aratbuttaj yanʼtihuapokikatiʼ, yanʼbayokikatiʼ, paiʼda hua̱e̱ʼeritaj yanʼbayokikatiʼ, ijjay. Nogok opudomey eʼbueydeʼte katepiʼ huakupepiʼ to̱e̱hueʼ moʼe̱denok o̱ʼnen huadiʼa Dioserea kurudya̱ʼ moʼbaedapone. ");
INSERT INTO amrNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Nogen sueʼda eʼtamaetaj dakaʼ eʼtamati̱e̱ʼikaʼnayo konigti nogenkon nogi̱tinada dakaʼ moʼtamati̱e̱ʼikaʼapo. Kenpaʼti nogen sueʼda eʼtamaetaj dakaʼ mati̱e̱hueʼ e̱e̱ʼnayo konigti nogen nogi̱tinada dakaʼ tamati̱e̱hueʼdik moʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Huakupe katepiʼ moʼto̱e̱po dakaʼ yanʼnopo̱e̱po yanikatiʼ. Huakupe gana eʼkaʼtaʼ boʼpakpo engaña kaʼdikpiʼ moʼe̱ne. Diosa oʼpaknok huakupe moʼto̱i̱kaʼne. Huakupe dakaʼ to̱e̱hueʼ e̱e̱ʼnayo paiʼda aratbuttaj dakaʼ bayokhueʼ e̱e̱ʼnayo Dios huadaknanada huaunhuahuikaʼ yokhueʼdik moʼe̱a̱pone. Kenpaʼti Diosa ʼuruda huaknopo̱e̱ʼ tihuapokhueʼdik moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nogen dakaʼ tamati̱e̱hueʼ e̱ʼi̱kaʼnayo o̱ʼnenda huatamaeʼ Diosapiʼ bayokhueʼ moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Bottaʼ huairi to̱e̱hueʼdik moʼe̱ne. Diosyoʼda Huairi o̱ʼe̱. Katepiʼ huakkaʼ eʼtamaetaʼ eʼeretpaknayo konig nog huairi huanopoyaʼ to̱e̱ʼdik o̱ʼe̱. Kenpaʼti huakkaʼ huakupe e̱ʼta̱e̱ʼtaʼ eʼeretpaknayo konig nog huairi huanopoyoda to̱e̱ʼdik o̱ʼe̱. Dios Huairitayoʼda nigpe̱e̱dik moʼe̱ne. Diostayoʼda diʼ e̱ʼdik moʼe̱ne. Huakkaʼtaʼda katepiʼ huakupepiʼ eʼeretpaknayo Diostaj pakhueʼdik moʼe̱ne. Diostaj eʼpaknayo huakkaʼda katepiʼ huakupepiʼ pakhueʼdik moʼe̱ne. Diostaj eʼnigpe̱e̱nayo huakkaʼda katepiʼ huakupepiʼ pakhueʼdik moʼe̱ne. —‍Kenda Jesúsa oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fariseoa huakkaʼda huakupetaʼ onʼderetpakikaʼpo Jesústaj onʼpe̱e̱depo Jesústaj onʼtierikpo namaʼda oaʼ onʼhuaaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","—‍Opudomey fariseo “Huadakda o̱ʼne,” nog aratbuttaj moʼmanopo̱e̱a̱ʼikaʼnigʼa Diosanayo opudomeyennopoʼtaj dakhueʼ o̱ʼne moknopo̱e̱ne. Beʼapi engaña o̱gkaʼpo “Huadakda o̱ʼne,” aratbuttaj eʼmanopo̱e̱a̱ʼtaʼ onʼeretpakikaʼ. Diosnayo kenda eʼkaʼ dakhueʼda o̱ʼe̱ oʼnopo̱i̱kaʼ. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","—‍Juan Bautista tiakhued e̱e̱ʼte Moisésbaʼtaj moʼnigpe̱i̱kaʼuyate, kenpaʼti Juan Bautista tiakhued e̱e̱ʼte Diosen huamanbatiaʼpakerien berobaʼ monmadikaʼuyate. Juan Bautista eʼtiakdeʼte huadak huaʼa konig Dios Huairitaj yanoknopo̱e̱ʼ yanʼnigpe̱e̱ʼ kenda onʼmanbatiaʼpakonhuahuaʼpo oy huakkaʼda onʼeretpakpo Dios Huairitaj huaboaʼda onʼnigpe̱e̱depo. ");
INSERT INTO amrNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kurud huadariere i̱da batikhueʼdik o̱ʼneapo konigti Moisésenbaʼ kenpaʼda o̱ʼi̱kaʼapo. Dikenhueʼdik o̱ʼe̱a̱po. Nogtipiʼ huadik dikenhueʼdik o̱ʼe̱a̱po. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","—‍Beʼapiʼ huabokerek hua̱to̱e̱ kenpaʼda e̱ʼennayo kenpaʼti nog ettoneʼtaj eʼto̱e̱paknayo huakkuru hua̱to̱e̱ʼtaj dakhueaʼ oʼkaʼ. Kenpaʼti konig eʼbakdej o̱ʼe̱nok dakhueaʼ oʼkaʼ. Kenpaʼ Diosa oaʼ. Nog huabokereken hua̱to̱e̱ e̱ʼenondeʼte kentaj beʼapiʼ eʼto̱e̱paknayo kenpaʼ dakhueaʼ o̱gkaʼ. Kenpaʼ Diosa oaʼ. —‍Ken Jesúsa oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","—‍Huabokerek huairi o̱ʼu̱yate. Huakkaʼda oʼmato̱e̱ʼuyate. ʼUruda yudtaj huakkaʼteda ekkaiʼ o̱ʼta̱e̱nok oʼotikaʼpo ayaʼ huameʼnoe huakkaʼtada oʼmatobapepo konig fiesta oʼkikaʼpo ʼuruaʼda oʼbapeʼikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Nog huabokerek Lázaro paiʼnanada o̱ʼi̱kaʼpo huasiʼdak huabada oʼbasetikaʼpo huairien akbogpete oʼhuadikaʼpo sorokte oʼhuadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Huairia enʼbapeʼte sueʼda aypotaʼsuj barakte enʼbakotate ken aypotaʼsuj paiʼda Lázaro eʼbapeʼtaʼ oʼpakikaʼuyate. Kenpaʼti Lázarotaj kuhua onʼhuatiakpo huasiʼdak eʼsettaj onʼtiminikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Nogok Lázaro paiʼda hua̱e̱ʼeri oʼbueyʼuyate. Ken Diosen huataʼmoneria Lázarotaj onʼtohuaʼpo kente Abraham e̱ʼhua̱e̱ʼyo̱ onʼtohuaʼuyate. Kente ʼuruda o̱ʼi̱kaʼ. Huairikon eʼbueydeʼte onʼkubarakkaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ke̱yo̱ oknopo̱e̱hueʼ hua̱e̱ʼerikudak noki̱re̱g e̱ʼnikaʼyo ken huairia paiʼda oʼnopoʼe̱po kutayo bidteda Abrahamtaj oʼtiahuaypo Lázarotaj Abrahameretaj oʼbatiahuayʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","“Doʼtaj yatinepahuiʼ, pag Abraham. Doʼte Lázarotaj menigtaʼmonaʼ. Keʼna huabaʼpikunote hue̱ʼe̱yyo̱ yabaʼpisotpo doʼhued huanoʼtaj kanoʼpohueʼpo in taʼakyo paiʼda ijnopoʼe̱y.” Kenpaʼ huairikudaka Abrahamtaj oʼnokoypo onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Okkahuehueʼ ya̱e̱ʼ, sion. On iʼnoepo huakkaʼnanada iʼmato̱e̱ʼikaʼuyate. Huadaknada i̱ʼi̱kaʼuyate, Lázaronayo paiʼnada o̱ʼi̱kaʼuyate. Oy i̱yo̱ doere Lázaro huadakda o̱ʼe̱. Durugda o̱ʼi̱kaʼ. Onnayo paiʼnada iʼnopoʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Kenpaʼti i̱yo̱ konig kubog o̱ʼe̱. Mente huahueʼdik o̱ʼe̱. I̱ya̱ʼ opudomeytaj huahuahueʼdik o̱ʼe̱y. Kenpaʼti i̱yo̱ oroʼomeytaj huatiakhueʼdik moʼe̱ne.” Abraham huairikudaktaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Ken doʼhued huaojen jakyo Lázarotaj yataʼmonaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Doʼhued cinco huamaʼbuytaj yamanaʼtuʼ Lázarotaj yanaʼ. Doʼhued huamaʼbuy i̱yo̱ tiakhueʼ kaʼneʼpo, i̱ya̱ʼ paiʼda onʼnopoʼe̱a̱po. Konig do namaʼda ijkikaʼmey konigti kahueʼ kaʼneʼpo. Lázaroa kamaneʼ, pag Abraham.” Huairia Abrahamtaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“O̱ʼnen huamaʼbuy kenda Moisésa oʼnigmadoyaʼuyate, Moisésenbaʼ onʼbaʼto̱e̱ kenpaʼti Diosen huamanbatiaʼpakerienbaʼ onʼbaʼto̱e̱. Kanʼnigpe̱e̱ʼ.” Abrahama onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Ehueʼ, Moisésenbaʼtaj nigpe̱e̱hueʼ o̱ʼneapo, pag Abraham. Beʼapiʼ kubarakyaʼ oʼnoyhuadpo eʼhuatiakatoʼnayo doʼhued huamaʼbuya yanʼnopoʼkoreaʼapet.” Huairia onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Moisésenbaʼtaj kenpaʼti huamanbatiaʼpakeribaʼtaj eʼnigpe̱e̱taʼ pakhueʼ e̱e̱ʼnayo beʼapiʼ kubarakyaʼ eʼhuatiakatoʼnayo kentaj kenpaʼti nigpe̱e̱hueʼ o̱ʼneapo.” Abrahama onaʼuyate. —‍Kenda Jesúsa oʼmanbatiaʼpakpo oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesúsa huanigpe̱i̱kaʼeritaj, —‍Katetapiʼ eʼtiahuayapiʼ e̱ʼhui̱ri̱kapiʼ eʼpe̱e̱ʼa̱piʼ konige̱po aratbut kiriga̱yo̱ʼ dakhueaʼ eʼkaʼtaʼ oʼbapakaʼikaʼ. Ken o̱ʼna nogtaj dakhueaʼ eʼbatokaʼnayo konige̱po ontaj Diosa keʼpoda castiga megkaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Doʼhued huanigpe̱i̱kaʼeritaj dakhueaʼ eʼbatokaʼtaʼ iʼpakpopiʼ dakhueaʼ batokahued beʼapiʼ huidtoneʼ o̱ʼnen hua̱hue̱rentaʼ yanʼtiontidukupo aʼtaʼkotiaʼpo odda ya̱koyo e̱ʼennayo kenda sueʼda castiga o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Keyoj, opudomey, ayaʼda dakaʼ yanʼnopo̱e̱po yanʼmanikaʼ. Huaknopo̱e̱ʼeri huamaʼbuyapiʼ ontaj dakhueaʼ e̱gkaʼnayo “Dakhueaʼda o̱gkaʼne. Kenpaʼda yabatik.” O̱ʼnen huamaʼbuytaj i̱ghuaʼda yaboroay. Eʼnopoʼkoreaʼnayo o̱ʼnen huamaʼbuytaj yakkahueaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nogmeʼnoetida ontaj dakhueaʼ e̱gkaʼnayo konig sieteaʼpiʼ ontaj dakhueaʼ e̱gkaʼnayo ontaj “Namaʼda ontaj o̱gkaʼne, ijnopoʼkoreay, onteʼti konigti kahueʼ o̱ʼe̱a̱pone,” sieteaʼpiʼ enaʼnayo o̱ʼnen huamaʼbuytaj sieteaʼaʼ yakkahueaʼ. Nogok nogok konigti o̱ʼnen huamaʼbuya enaʼnayo onteʼti yakkahueaʼ. —‍Ken Jesúsa huanigpe̱i̱kaʼeritaj oʼmanmadikaʼpo oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","—‍Ontaj sueʼda oroʼ oknopo̱e̱y, nogi̱ti ontaj huaknopo̱e̱ʼ boʼtihuapok. —‍Huairi Jesústaj doce huamataʼmonaʼeria oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","—‍Mostaza huakid sigda o̱ʼe̱. Doʼtaj sueʼda eknopo̱e̱ʼnayo mostazakid konig suigda eknopo̱e̱ʼ o̱ʼe̱ “In hue̱ymey oʼdikkaʼ sicómoro yauru, e̱ʼpo̱gyo̱ yatohuaʼpo yatuk.” Suigda iknopo̱e̱po enapiʼ Diosa oʼkaʼapo. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","—‍O̱ʼnen huanabaʼ taʼbayaʼ oʼbaaʼpopiʼ campoduyte oveja oʼtiokaʼpopiʼ bisik jakyo eʼtiakdeʼte “Yakud, yabapeʼ.” Ken konig onahueʼ moʼi̱kaʼne. ");
INSERT INTO amrNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","“Menigmanhuada̱ʼ doʼtaj kabapeʼpo kenpaʼti koyaʼ menigtotiak. Do eʼbapeʼdeʼte aʼti yabapedtiʼ kenpaʼti koyaʼ yamayentiʼ.” Ken konig moʼmanaʼikaʼne. ");
INSERT INTO amrNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Huanabaʼ eʼnigpe̱i̱kaʼtada “dakiti” onahueʼ moʼi̱kaʼne. ");
INSERT INTO amrNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Konigti opudomey kenokaʼ ayaʼda Diosa oʼmanaʼuyate bokaʼdepo, “O̱ʼnen huanabaʼ o̱ʼe̱y, ‘Huadakaʼda bokaʼne.’ Kenpaʼti ‘Dakiti’ oroʼtaj onahueʼdik o̱ʼe̱ne. Kenyoʼda kaʼdik o̱ʼe̱po oʼkay.” Diostaj ya̱ʼnonaʼ. —‍Kenda Jesúsa oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jerusalényo̱ Jesús oʼhuaeʼonhuahuaʼpo Samaria huadaribayo Galilea huadaribayo ondariyonyoʼ e̱ʼneʼte oʼhuaʼepo. ");
INSERT INTO amrNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Huakkaʼ jakyo Jesús e̱kye̱deʼte diez huabokerek eʼsiʼdakparaʼa sueʼda bidteda onʼnigbopo, ");
INSERT INTO amrNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","—‍Oroʼomeytaj moʼtinepahuiʼ Jesús Huairi. —‍ʼUttaʼda Jesústaj oʼnonokoyʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesúsa oʼbatiahuaydepo, —‍Yanhuatiʼ. Judío sacerdotetaj yanhuahuatiʼ. Sacerdotea boʼtiahuayeʼ. —‍Jesúsa diez huabokerek eʼsiʼdakparaʼtaj oʼmanaʼuyate. Enʼbahuadeʼte Diosa oʼbayareadʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kenokaʼ nogtiada ijyaredey huaboaʼda oʼnopo̱e̱depo oʼkumejpo, “Diosa ʼuruaʼda oʼkikaʼ. Huadaknanada o̱ʼe̱ Dios. Dakiti Dios.” ʼUttaʼda oʼokoypo, ");
INSERT INTO amrNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jesústaj huikudate oʼtihuadpo “Dakiti Jesús Huairi.” Onaʼuyate. Keʼna Samaria huadaribayo hua̱e̱ʼeri o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","—‍Dieztaj ijbayareaʼnig, ¿Nog nueve meyon ya̱ʼne? ");
INSERT INTO amrNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","In nogbayo hua̱e̱ʼeriyoʼda “dakiti Dios” aaʼyaʼpo oʼkumej. Kaʼtiaʼpo nogda nueve kumejhueʼ ya̱ʼne. —‍Jesúsa oaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","—‍Yaʼupakpo yabodpo yahuatiʼ. Doʼtaj oknopo̱e̱nok konige̱po oʼyareaddene. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","—‍¿Menokaʼ Dios Huairi yatiakapet? —‍Fariseo aratbuta Jesústaj oʼnonaʼnok, —‍Dios Huairitaj huadak huaʼa moknopo̱i̱kaʼnig kenpaʼti moʼnigpe̱i̱kaʼnig tiahuayhueʼdik moʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Oy opudomey sueʼada Dios Huairitaj moknopo̱e̱denok eʼnigpe̱e̱depiʼ “In o̱ʼe̱.” “An o̱ʼe̱.” Beʼapiʼ ahueʼdik o̱ʼneapo. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Keʼnen huanigpe̱i̱kaʼeritaj, —‍Do huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne, nogok doʼtaj eʼtiahuaytaʼ boʼpakaponigʼa. Nogtida huameʼnoeyo̱ʼdapiʼ doʼtaj eʼtiahuaytaʼ boʼpakaponigʼa kenokaʼ doʼtaj tiahuayhueʼdik o̱ʼneapone. Aratbutere ehueʼ i̱jje̱a̱poy. ");
INSERT INTO amrNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","‘A̱yo̱ o̱ʼe̱.’ ‘Ke̱yo̱ o̱ʼe̱.’ Yanʼbatiaʼpakapetnigʼa. Kenomeytaj manpe̱e̱hueʼ yaneʼ. Doʼtaj aʼukyaʼpo huahueʼ yaneʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Nogok do eʼtiakte ayaʼ huadariyaʼ nogdari nogdariyaʼ doʼtaj boʼtiahuayapone. Konig o̱jbed o̱ʼi̱kaʼ kurudya̱ʼ huabada jeyda o̱ʼe̱nok ayaʼ huadariyaʼ doʼtaj tiahuaydik o̱ʼneapo. ");
INSERT INTO amrNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Huakkurunayo paiʼda huakkaʼ ijnopoʼe̱a̱poy. Kenpaʼti huakkaʼ aratbuta oy doʼtaj eknopo̱e̱ʼtaʼ pakhueʼ meʼneapone. ");
INSERT INTO amrNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","27","Do huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne. Nogokaʼ do kurudya̱ʼ eʼtiakte aratbut onʼbapeʼikaʼapo vinopiʼ onʼmamayʼikaʼapo kenpaʼti onʼto̱e̱pakikaʼapo. Konige̱po doʼtaj e̱kpo̱e̱ʼ nige̱hueʼ o̱ʼneapo. Aʼnennada Noékudak e̱e̱ʼte konigti o̱gkikaʼuyate. Diostaj pakhueʼda o̱ʼnepo, onʼbapeʼikaʼpo, onʼmamayʼikaʼpo, onʼto̱e̱pakikaʼpo. Noé huaboroʼ kusiʼpetoneʼyo enʼbakuddeʼte aratbut kenda e̱gkikaʼte hue̱kurua o̱ʼhue̱pokdepo ayaʼda onʼmabueyʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Konigti aʼnennada Lotkudak e̱ʼhua̱e̱ʼokaʼ aratbut Diostaj pakhueʼ o̱ʼnepo onʼbapikaʼpo onʼmamayʼikaʼpo kenpaʼti huakupete onʼbaeʼikaʼpo onʼbahuayaʼikaʼpo, kenpaʼti taʼbayo onʼbatukeʼikaʼpo kenpaʼti jak o̱gkikaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Kenda aratbut o̱gkikaʼuynigʼa Lot Sodoma huakkaʼ jakyaʼ enʼmako̱ro̱kdeʼte Diosa castiga oʼmagkaʼpo konig taʼakoniga̱ kurudya̱ʼ eʼhuiʼa ayaʼtada oʼmahui̱gʼuyate. Kenpaʼti azufre konig huidjeyada kurudya̱ʼ oʼbatikahuapo ayaʼtada oʼbarakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Do huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyate, do onteʼti kurudya̱ʼ eʼtiakte konigti aratbut o̱gkikaʼpo, doʼtaj e̱kpo̱e̱ʼ nige̱hueʼ o̱ʼnikaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Katepiʼ eʼmato̱e̱ʼtaʼ meʼpukehueʼ yanikatiʼ. Do kurudya̱ʼ eʼtiakte jakkurute opud e̱e̱ʼnayo katepiʼ jakyo eʼtamaeʼnayo aʼbaetuyaʼpo jakyo kudhueʼ yanetiʼ. Kenpaʼti do eʼtiakte taʼbayo opud e̱e̱ʼnayo jakyo katepiʼ aʼbaetuyaʼpo huahueʼ yaneʼ. Konige̱po doʼtaj dakaʼ e̱kpo̱e̱ʼ nige̱ʼdik moʼe̱a̱ponok. ");
INSERT INTO amrNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Loten hua̱to̱e̱ʼtaj okkahuehueʼ yaneʼ. Ettoneʼa̱ katepiʼ doʼhued jakyo meʼtamaene oʼnopo̱e̱po ta̱ʼniaʼ oʼmaboʼudpo konige̱po kenteda oʼbueyʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Opudomey kenpaʼda huataʼda boʼpakpo doere kurudyo̱ onteʼti noeonhuahuikahueʼdik moʼe̱a̱pone. Opudomey kenpaʼda huataʼ pakhueʼ moʼi̱kaʼpo Diostaj eʼnigpe̱e̱taʼ huakkaʼ boʼpakikaʼpo onteʼti Diosere moʼnoeonhuahuikaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ken nogok do eʼtiakte sikyopiʼ bottaʼ jo̱gkutopayoyoʼ enʼtayte nogtiada doʼtaj e̱kpo̱e̱ʼ o̱ʼnige̱nok Diosen huataʼmoneria oʼtohuaʼapo. Nogtaj tohuahueʼ o̱ʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Konigti bottaʼ ettoneʼ aros onʼtugpo nogtatida Diosen huataʼmoneria oʼtohuaʼapo nogtaj tohuahueʼ o̱ʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Konigti taʼbayo bottaʼ huabokerek o̱ʼnepo. Diosen huataʼmoneria nogtatida oʼtohuaʼapo nogtaj tohuahueʼ o̱ʼe̱a̱po, ijjay. —‍Ken Jesúsa huanigpe̱i̱kaʼeritaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Huanigpe̱i̱kaʼeri kenda onʼpe̱e̱depo, —‍¿Kenda iaʼnig meya̱ʼ ya̱ʼe̱a̱pet? —‍Huanigpe̱i̱kaʼeria Jesústaj oʼnonaʼuyate. —‍Kente eʼbueyen hua̱so̱ʼ oʼhuednok, kente huakkaʼ matuk onʼtiakapo. Ken konig e̱ʼneʼte dakhueaʼ huakaʼeriʼtaj Diosen huataʼmonaʼeriomeya̱ castiga oʼmagkaʼapo. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Kiriga̱yo̱ʼ yanʼtionaʼpakikaʼpo batikhueʼ yanikaʼ. Jesúsa oʼmanbatiaʼpakpo oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","—‍Aʼnenda huakkaʼ jakyo juez yamanoeya̱ʼ huamanaʼeri o̱ʼe̱po, Diostapiʼ meʼpukhueʼ o̱ʼe̱po kenpaʼti aratbuttaj manpe̱e̱hueʼda o̱ʼi̱kaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ken huakkaʼ jakyo ʼayhuakon o̱ʼe̱po yamanoeya̱ʼ huamanaʼerite oʼhuahuaʼikaʼpo, “Noga̱ dakhueaʼ menogkameʼne mentihuapok, huairi.” ʼAyhua onaʼikaʼpo nogok nogok kiriga̱yo̱ʼ konigti onaʼikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kejeʼ kejeʼ yamanoeya̱ʼ manahueʼ i̱jje̱a̱poy nogok nogok yamanoeya̱ʼ huamanaʼeria eʼnopo̱e̱ʼada nogok “Diostaj okmeʼpukhueʼ i̱jje̱y kenpaʼti aratbuttaj pe̱e̱hueʼ i̱ji̱kay. ");
INSERT INTO amrNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","In ʼayhua kiriga̱ʼda beʼhuatiakikaʼnok kentaj ijtipeunapoy. Onpeunhueʼ e̱e̱ʼnayo doʼtaj kiriga̱yo̱ʼ beʼhuatiakikaʼnok doʼhua huadiaydik i̱jje̱a̱poy.” Huanopoada oʼtinopo̱e̱ʼuy. —‍Kenda kiriga̱yo̱ʼ yanʼtionaʼpakikaʼpo batikhueʼ yanikaʼ, Jesúsa oʼmanbatiaʼpakpo oʼmanmadikaʼuyate: ");
INSERT INTO amrNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Onteʼti Jesús Huairia oʼmanaʼpo, —‍Kenda dakhueʼa yamanoeya̱ʼ huamanaʼeri huanopoyaʼ oʼtinopo̱e̱ʼuyate. Yanʼnopo̱e̱ʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","8","“Beʼtihuapak, Dios.” “Beʼtihuapok, Dios.” “Takaʼ dakhueaʼ megkaʼne, Dios.” Diosen huabaktieʼeaʼeria Diostaj huameʼnoe kenpaʼti sikyo eʼtionaʼpakikaʼte Diosa i̱dada oʼbatihuapokapo, Do huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne. Kurudya̱ʼ ijhuarakapoy. ¿Huabaktieʼeaʼeritaj aʼbatiokayaʼpo eʼtiakdeʼte meniga̱ʼ doʼtaj yanoknopo̱e̱ʼapet? —‍Kenda Jesúsa oʼmanbatiaʼpakpo oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","“Huadakda i̱jje̱y. Huadakda ijkikay.” “Nogomeynayo dakhueʼda o̱ʼnepo dakhueaʼ o̱gkikaʼ.” Sueʼada namaʼda onʼmatinopo̱i̱kaʼnigtaj Jesúsa oʼmanbatiaʼpakpo oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—‍Diosen jakyo aʼtionaʼpakyaʼpo bottaʼ huabokerek onʼhuaʼuyate. Nogtida fariseo hua̱e̱ʼeri o̱ʼe̱po nogda gobiernoen huakupe huatabaeʼeri o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Huakkuru fariseo hua̱e̱ʼeria oʼbopo, oʼtionaʼpakpo, “Konig nog aratbut dakhueaʼ huakaʼeri o̱ʼnikaʼnig konig donayo ehueʼ i̱jje̱y. Huadakda i̱jje̱y, Dios. Konige̱po dakiti ijjay. Huabereeri konig ehueʼ i̱jje̱y. Dakhueaʼ huakaʼeri konig ehueʼ i̱jje̱y. Nogen hua̱to̱e̱ʼtaj huabakdejeri konig ehueʼ i̱jje̱y. Kenpaʼti in gobiernoen huakupe huabaeʼeri konig ehueʼ i̱jje̱y. ");
INSERT INTO amrNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nogsemanatida e̱e̱ʼte Diostaj iknopo̱e̱po bottaʼaʼ huameʼnoete bapehueʼ i̱ji̱kay. Kenpaʼti huakupepiʼ aypopiʼ katepiʼ ijbaeʼdey. Diostaj sueʼda ijyokikay.” Ken fariseo hua̱e̱ʼeria oʼbopo Diostaj oʼtionaʼpakʼuyatenigʼa. ");
INSERT INTO amrNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Gobiernoen huakupe huatabaeʼerinayo Diosen jakte sueʼda bidte oʼbopo dakhueaʼ huakaʼeri i̱jje̱y oʼnopo̱e̱po kurudyo̱ mabohueʼda o̱ʼe̱po oʼtionaʼpakpo, kenpaʼti konig paiʼda o̱ʼe̱po huataʼ oʼka̱gkatuktukpo oʼtionaʼpakpo, “Doʼtaj meʼtinepahuiʼ, dahueaʼ huakaʼeri i̱jje̱y, Dios.” Oʼtionaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Gobiernoen huakupe huatabaeʼeri keʼnen jakyo eʼkumejdeʼte Diosa okkahueaʼdepo huadaknopoʼda o̱ʼeanʼuyate. Fariseo hua̱e̱ʼeritaj okkahueahueʼ o̱ʼu̱yate. “Huadakda i̱jje̱y. Huairi i̱jje̱y.” Ayaʼda kenda huanopo̱e̱ʼeritaj “Doʼtehuapaʼ dakhueʼda moʼe̱ne.” Diosa oʼmanaʼapo. “Huairi ehueʼ i̱jje̱y. Huadakda ehueʼ i̱jje̱y.” Ayaʼda kenda, huanopo̱e̱ʼeritaj “Huadakda moʼe̱ne.” Diosa oʼmanaʼapo. —‍Kenda Jesúsa oʼmanbatiaʼpakpo oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nogok huasiʼpotaj Jesúste onʼbatohuaʼuyate. Jesúsa kabatibaʼtaʼteʼeʼpo onʼbatohuaʼuyate. “Kejeʼ batohuahueʼ yaneʼ.” Huanigpe̱i̱kaʼeria enʼmanaʼtada ");
INSERT INTO amrNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","“Menʼhuatiake,” Jesúsa oʼmanaʼpo, “Huasiʼpo doʼte enʼhuatiakte, ka̱e̱ya̱ʼ manahueʼ yaneʼ. Konige̱po konig inomey ʼurunopoʼda huasiʼpo o̱ʼne konigti aratbut huaknopo̱e̱ʼeri Dios Huairitaj onʼnigpe̱i̱kaʼpo Diosensiʼpo o̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Huasiʼpo doʼtaj ʼurunopoʼda meʼnoknopo̱e̱po menʼnigpe̱i̱kaʼne. Konig huasiʼpo Dios Huairitaj oʼnoknopo̱e̱nig konigti opud oknopo̱e̱hueʼ e̱e̱ʼnayo Dios Huairiensiʼpo ehueʼdik moʼe̱a̱pone. Buttida ijjay.” Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","—‍¿Kurudyo̱ Diosere aʼnoeonhuahuikayaʼpo kate kikaʼdik i̱jje̱, huadak huamanmadikaʼeri? —‍Nogtiaʼda judío huairia Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","—‍Kaʼtiaʼpo huadakda i̱ʼe̱ onaʼ. Diosyoʼda huadakda o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nogen hua̱to̱e̱ʼtaj bakdejhueʼ yaneʼ. Nog aratbuttaj eʼhuadiayte arakhueʼ yanʼmaikaʼ. Nogen bakberehueʼ yanikaʼ. Nog aratbuttaj dakhueaʼda bahuaahueʼ yanikaʼ. Huaojtaj hua̱ye̱taere yanigpe̱i̱kaʼpo dakaʼ yanʼmato̱i̱kaʼpo yanʼbayokikaʼ. Ken Diosen eʼmanaʼ yanopo̱e̱ʼ. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","—‍Do huasiʼpoeda̱da kenda ayaʼda ijnigpe̱i̱kaʼuy. —‍Jesústaj onaʼnok. ");
INSERT INTO amrNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jesúsa oʼpe̱e̱depo, —‍Nogitied kaʼdiken i̱ʼe̱ne. Ayaʼda katepiʼ iʼmato̱e̱nig huakupete yabahuayaʼ. Ken huakupe yabaedepo paiʼda aratbuttaj yabayokeʼ. Kenda on ekaʼnayo kurudyo̱ Diosere huakkaʼda iʼmatoeunhuahuikaʼapone, doʼtaj behuatiakpo doʼtayoʼda menigpeonhuahuikaʼ. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Kenda huairi oʼpe̱e̱depo huakkaʼnanada oʼmato̱e̱po huaboaʼda suhueʼnanada o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Suhueʼnada o̱ʼe̱nok Jesúsa oʼtiahuaydepo, —‍Huairi keʼnenda huakkaʼ eʼmato̱e̱ʼtaʼ eʼeretpaknayo Diostaj oknopo̱e̱hueʼdik o̱ʼneapo Diosensiʼpo ehueʼdikda o̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Konig camello huaboroʼ ʼuhua sakpiʼpe̱yo̱ kudhueʼdik o̱ʼe̱. Konigti huairi huakkaʼda eʼmato̱e̱ʼnayo Diosensiʼpo ehueʼdikda o̱ʼneapo. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","—‍¿Beʼa manopoʼyareaʼdik ya̱ʼne? ¿Beʼa Diosere noeonhuahuikaʼdik ya̱ʼne? —‍Nogomeya̱ Jesústaj onʼpe̱e̱depo oʼnonaʼuynok, ");
INSERT INTO amrNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","—‍Huabokerek huataʼda nopoʼyareahueʼdik o̱ʼne. Huataʼda onʼpakpo noeanhuahuikahueʼdik o̱ʼneapo. Diosayoʼda nopoʼyareaʼdik oʼmae kenpaʼti onteʼti noeanhuahuikaʼdik oʼmae. Diosayoʼda ayaʼda kaʼdik o̱ʼe̱. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","—‍Oroʼomeynayo ayaʼda oʼmato̱e̱i̱kaʼnig oʼmaenonʼuy. Ontaj ataʼhuayaʼpo ayaʼda oʼmaenondemey, huairi. —‍Pedroa Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","—‍Ayaʼda keʼnen jakpiʼ, keʼnen huaojpiʼ, keʼnen hua̱ye̱piʼ, keʼnen huamaʼbuypiʼ, keʼnen huidpopiʼ, keʼnen hua̱to̱e̱piʼ, keʼnen huasiʼpopiʼ Dios Huairitaj aʼnigpe̱e̱yaʼpo eʼmaenonʼnayo indariyo ");
INSERT INTO amrNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","durugda onʼnoeonhuahuikaʼapo huakkaʼda nogda onʼmato̱e̱a̱po kenpaʼti onteʼti Diosere onʼnoeonhuahuikaʼapo. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Doce huamataʼmonaʼeritaj Jesúsa meyo̱hueʼda oʼbatohuaʼdepo, —‍Oy Jerusalényo̱ oʼhuaʼdeapone. Do huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne. Aʼnenda Diosen huamanbatiaʼpakeria doʼtaj kenda menʼtimadoyaʼuyatenig huabokereka doʼtaj meʼnogkaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Nog aratbuttada menyokapone. Doʼtaj nog aratbuta menʼtierikapone, dakhueaʼda menʼtidiʼkeapone, doʼtaj mentisupuʼeapone, ");
INSERT INTO amrNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","pidetbiʼa kenpaʼti menʼbitbitapone, meʼdarakapone, bottaʼaʼ kubarakyo eksikondeʼte kubarakyaʼ Diosa meʼnoyhuada̱ʼapone. —‍Jesúsa doce huanigpe̱i̱kaʼeritaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Doce huanigpe̱i̱kaʼerinayo nopoenkahueʼ o̱ʼnuyate. Kenda Jesúsa eʼmanaʼtada nopoenkahueʼ o̱ʼnepo konig eʼi̱re̱g o̱ʼe̱nok nopoenkahueʼ o̱ʼneʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Huakkaʼ jak Jericóyo Jesúsa eʼtikayopakte dagte huabokerek oʼhuadpo ekpobig o̱ʼe̱po huakupepiʼ aypopiʼ menʼyok oaʼikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Huakkaʼda aratbut onʼpoknok ekpobiga̱ oʼpe̱e̱depo, “¿Katete moʼe̱?” oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","“Jesús Nazareteri oʼpok.” Oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","—‍Metinepahuiʼ, Jesús. Daviden adhueaʼ huayayo i̱ʼe̱ne. —‍Oʼokoyʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","“Yabatik, soataʼ ya̱e̱ʼ.” Huakkuru aratbuta Jesúsere huahuaʼeria eʼnonaʼtada onteʼti onteʼti oʼokoypo, —‍Metinepahuiʼ, Jesús. Daviden adhueaʼ huayayo i̱ʼe̱ne. —‍Oʼokoyʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jesús ehuada oʼboatoʼpo, “Menʼnigtotiak,” huanigpe̱i̱kaʼeritaj oʼmanaʼuyate. Oʼtikayopakonyakdenok, ");
INSERT INTO amrNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—‍¿Katetaj iʼpak? —‍Jesúsa onaʼuyate. —‍Ekpoyareaʼtaʼ ijpaki, huairi. —‍Ekpobiga̱ onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","—‍Yatiahuayʼ. Doʼtaj oknopo̱e̱nok okpoyareaddene. —‍Jesúsa ekpobigtaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Jesúsa kenpaʼ eadeʼte huaboaʼda ekpobig tiahuaydik o̱ʼe̱depo, Jesústaj oʼtahuaʼpo “Dios kurudyo̱ ʼuruda o̱ʼi̱kaʼpo huadaknanada oʼkikaʼ,” oʼbatiaʼpaknok, ayaʼada Jesústaj onʼtahuaʼpo onʼtiahuaypo onʼpe̱e̱po kenpaʼti “Dios kurudyo̱ ʼuruda o̱ʼi̱kaʼpo huadaknanada oʼkikaʼ,” onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ken, Jericó huakkaʼ jakyo Jesús oʼkudonpo oʼhuaeʼpo dagte oʼhuaeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","A̱yo̱ huairi o̱ʼe̱po oʼdikkaʼ Zaqueo. Keʼna gobierno huakupe huabaeʼeri huairi o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jesústaj eʼtiahuaytaʼ eʼpakada huakkaʼada Jesústaj onʼtikupopakikaʼnok keʼna jontojyoʼda o̱ʼe̱po tiahuayhueʼdik o̱ʼe̱po, ");
INSERT INTO amrNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Konige̱po huakkuruyon oʼketonhuaʼpo kente Jesús oʼpokapo oʼnopo̱e̱po hue̱ymeyyo̱ sicómoroyo oʼbehuikatoʼpo Jesústaj aʼtiahuayaʼpo hue̱ymeyyo̱ oʼbehuikatoʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Ken hue̱ymeyte Jesús oʼpokpo kutayo oʼmaboatopo, —‍I̱da yahuarak, Zaqueo. Oy o̱ʼnen jakyo tahuade̱ʼdik i̱jje̱y. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Konige̱po Zaqueo oʼhuarakonpo i̱da oʼhuarakpo durugda oʼto̱e̱po keʼnen jakyo Jesústaj oʼtohuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Huakkaʼda aratbuta Jesústaj Zaqueoere eʼhuaʼte onʼtiahuaydepo, “Dakhueaʼ huakaʼerien jakyo oʼhuaʼdepo ke̱yo̱ oʼtayʼapo,” dakhueaʼ onpapayoʼ onʼhuaaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ken Zaqueo huaʼite oʼbodpo, —‍E̱ya̱ʼ, Huairi, huakkaʼda do ijmato̱e̱nig ijposakapoy paiʼda aratbut hua̱e̱ʼeritaj ijbayokeʼapoy. Paiʼda aratbuttaj huakkaʼda ijbayokeʼapoy. Aratbuttaj engaña eʼmagkikameʼnayo kenomeyen huakupe bottaʼ bottaʼ ijbatahuaʼapoy. —‍Zaqueo Jesús Huairitaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","10","—‍Do huabokerek i̱jje̱po Abrahamen adhueaʼ huayayo judío dakhueaʼ huakkaʼeritaj aʼukyaʼpo aʼbakkahueayaʼpo aʼmanopoʼyareayaʼpo ijtiakpo Abrahamen adhueaʼ huayayo i̱ʼe̱nok, Zaqueo, ontaj o̱ʼnen huabettakon dakhueaʼ oʼbakkahueaʼpo oʼmanopoʼyareaʼne. Diosere moʼnoeonhuahuikaʼapone. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jesús Jerusalényo̱ oʼhuaʼpo meyo̱hueʼda o̱ʼe̱nok aʼti Dios Huairitaj oʼhuahuayapoy aratbut onʼnopo̱e̱nok huakkaʼda eʼpe̱e̱deʼte Jesúsa oʼmanbatiaʼpakpo, ");
INSERT INTO amrNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","—‍ʼUruda huabokerek o̱ʼe̱po, huadakda keʼnen huabet o̱ʼnepo keʼna nogbayo oʼhuaʼuyate. “O̱ʼnenbayo gobierno huairi i̱ʼe̱.” Nogbayo hua̱e̱ʼeri huairi kayahueʼpo oʼhuaʼuyate. Nogok gobierno huairi o̱ʼe̱depo oʼkumejapo. ");
INSERT INTO amrNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Keʼna ʼuruda huabokerek huahued diez huanabaʼtaj oʼmagkupopakaʼdepo nogtitaj nogtitaj nogtida huakupe huakkaʼteda e̱e̱ʼ konig oro huakupetoneʼ oʼbaktoyokeʼuyate. “Ijhueʼda i̱jjeonhuahuikaʼdepo ijtiakapoy. Do a̱yo̱da huakkaʼaʼda e̱ʼunhuahuaʼte in huakupete yudtapiʼ yanʼbaeʼikatiʼ kenpaʼti yanʼbahuayikaʼ huakupe gana ya̱gʼkikatiʼ.” Oʼmanaʼuyate. Diez huanabaʼtaj oʼmanaʼuyate. Kenpaʼ oʼmanaʼdepo nogbayo oʼhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Keʼnenbayo hua̱e̱ʼerinayo ken huairitaj onʼhuadiaypo sueʼtada aratbut onʼmataʼmonaʼpo ʼuruda huabokerektaj taʼpote onʼmataʼmonaʼpo, “In huabokerektaj konig oroʼomeyen huairi e̱ʼta̱e̱taʼ pakhueʼ o̱ʼe̱y.” Nogbayo hua̱e̱ʼeri huairitaj yanʼmanaʼ. Keʼnenbayo hua̱e̱ʼeriomeya̱ onʼmanaʼuyatenigʼa. ");
INSERT INTO amrNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ken nogbayo ʼuruda huabokerek e̱e̱ʼte “Gobierno huairi i̱ʼe̱ne.” Eʼnonadeʼte oʼkumeʼuyate. Keʼnenbayo oʼkumejdepo kenomeytaj huakupe aʼnenda eʼbaktoyoʼkeʼmeʼtaj “yanʼtiak,” oʼmanaʼuyate. Konig keʼnen huakupe yudtaj onʼbaepo kenpaʼti onʼbahuayaʼpo meniga̱ʼ gana ya̱gkaʼmet eʼnopo̱e̱taʼ oʼpakuyate. Nogtiaj nogtiaj meniga̱ʼ gana ya̱gkaʼmet eʼnopo̱e̱ʼtaʼ oʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ken huakkurueria huanabaʼa huairitaj oʼhuahuaʼdepo, “O̱ʼnen huakupe oktoyokuynig nog diez gana ijkaʼdemey, huairi.” Kenda huakkurueri huanabaʼa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Huadakda iʼkameʼte. Huadakda huanabaʼ o̱ʼta̱e̱ne. Konige̱po sueʼda doʼhued eʼnigtoeunhuahuaʼte dakaʼ oʼnigtoeunhuahuameʼnok diez huakkaʼ jaktaj gobierno huairi i̱ʼe̱a̱po.” Huairia onaʼuyate, huakkurueri huanabaʼtaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Nog huanabaʼa huairitaj oʼhuahuaʼdepo, “O̱ʼnen huakupe oktoyokuynig nog cinco huakupe gana ijkaʼdemey, huairi.” Ken huanabaʼa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Cinco huakkaʼ jaktaj gobierno huairi i̱ʼe̱a̱po.” Huairia onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Ken noga̱ huanabaʼ gobierno huairitaj oʼhuahuaʼdepo, “In o̱ʼnen huakupe pañuelote ijtoeunhuahuaʼmey, huairi. ");
INSERT INTO amrNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Huakupe gana ekaʼnayo o̱ʼna bektiparatapetpiʼ ijnopo̱e̱po ijmeʼpukpo. Kenpaʼti ayaʼda o̱ʼnen huanabaʼ gana onʼkaʼ ken ayaʼtada iʼbaktiparatikaʼ. Kenpaʼti taʼba nogomey onʼbatukeʼuyate. Ken katetehueʼ iʼbakbaeʼikaʼne.” Ken huanabaʼa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“On huanabaʼ dakhueaʼda i̱ʼe̱ne. Kenda huaboaʼda onaʼne oʼpe̱e̱dene dakhueʼada i̱ʼe̱ne ijnopo̱e̱y. Doʼhua oʼnoktiparatikaʼne kenpaʼti do batukehueʼda nogen taʼbayaʼ katetehueʼ oʼnokbaeʼikaʼne o̱ʼna eʼnopo̱e̱meʼnayo ");
INSERT INTO amrNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","menaʼpo doʼhued huakupe bancoyo kuda̱hueʼ i̱ʼe̱meʼte. Huakupe bancoyo e̱ʼunhuahuaʼnayo nog huakupe huakkaʼ i̱takdik o̱ʼi̱kayʼnigʼa. Doʼhued huakupe bancoyo aʼnenda eʼkuda̱meʼnayo do eʼtiakte doʼhued huakupe doʼtaj yokdik o̱ʼe̱po kenpaʼti nogiti huakupe doʼtaj yokdik meʼneaynigʼa.” Huairia onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nogomey kentaj meyo̱hueʼda oʼbonigtaj “Ken huakupe oʼtoenig yanoktiparatpo, ken diez oʼto̱e̱nigtaj yanʼyoktiʼ.” Huairia oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Menaʼpo iaʼ, huairi, diez huakupe o̱ʼta̱e̱.” Kenomey huairitaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“Konige̱po ayaʼ hua̱e̱ʼeria huairien sueʼda huakkaʼmon onʼnigto̱e̱po huairitaj dakaʼ eʼnigto̱e̱nayo dakaʼ huairitaj nogda eʼnigi̱takaʼnayo kenomeyen huairia oʼpakpo nogdakon oʼbayokeapo. Nogomey huirien sueʼda onʼnigto̱e̱po huairitaj dakaʼ nigto̱e̱hueʼ e̱e̱ʼnayo kenpaʼti huairitaj nogda nigi̱takahueʼ e̱e̱ʼnayo kenomeyen huairi kenda sueʼda eʼhua̱to̱e̱taj oʼbaktiparatapo. Kenpaʼti konig Diostaj sueʼda huakkaʼmon moknopo̱e̱po, Diostaj ʼuruaʼda eʼnigpe̱e̱ʼnayo nog aratbuttaj huadakda eʼtihuapoknayo nogiti Diostaj moknopo̱e̱a̱po. Sueʼda Diostaj moknopo̱e̱po, Diostaj sueʼda eʼnigpe̱e̱ʼnayo aratbuttaj sueʼda eʼtihuapoknayo kenda moknopo̱e̱nigʼa bokkahueapo, ijjay. ");
INSERT INTO amrNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Inomey aratbut doʼhuedbayo hua̱e̱ʼeri doʼtaj menhuadiaypo do konig kenomeyen gobierno huairitaʼ pakhueʼ o̱ʼnenigʼa, yanʼtotiakpo yanʼdarak. I̱yo̱ doʼhua eʼtiahuayte yanʼdarak.” Huairia keʼnen huanabaʼtaj oʼmanaʼuyate. —‍Kenda Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Kenda eʼmanadeʼte Jerusalényo̱ Jesúsa onteʼti oʼhuaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ken oʼhuaʼpo huakkaʼ jak Betfagé kenpaʼti huakkaʼ jak Betania meyo̱hueʼda e̱e̱ʼte kenpaʼti oteʼ huadik onʼdikkikaʼ Olivos meyo̱hueʼda e̱e̱ʼte bottaʼ huanigpe̱i̱kaʼeritaj oʼmanaʼpo, ");
INSERT INTO amrNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","—‍Ke̱yon huakkaʼ jakyo meyo̱hueʼda e̱e̱ʼte yanhuatiʼ. Boʼkudondeʼpo burro ʼuhua eʼtinukuʼ boʼhuahuayapone. Huabo burrote bepiʼ huadhued o̱ʼne. Yanʼtikujpo yanʼtotiaktiʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","“¿Menaʼpo boʼtikuj?” Beʼapiʼ enaʼnayo, “Huairia oʼpaknok oʼkay.” Ya̱ʼnonaʼtiʼ. —‍Bottaʼ huanigpe̱i̱kaʼeritaj Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ken bottaʼ huanigpe̱i̱kaʼeri onʼhuaʼpo, kenda Jesúsa oʼmanaʼnig konigti onʼhuahuaypo burrotaj onʼhuahuayʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Burrotaj huaboaʼ eʼtikujte burro huato̱e̱ʼeria onʼmanaʼpo, —‍¿Burrotaj menaʼpo boʼtikuj? —‍Onʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","—‍Huairi oʼpaknok oʼkay. —‍Huanigpe̱i̱kaʼeria onʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ken Jesúste onʼtohuaʼpo, e̱kye̱deʼte huanigpe̱i̱kaʼeriomey kenomeyen yudtaʼa burrotaʼpite onʼhueda̱ʼdepo Jesús burrotaʼpite oʼhuaddeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Jesús burrote oʼhuaʼdepo aratbut ke̱yo̱ʼti o̱ʼnepo dagte huakkuruyon huaok onʼbahueda̱ʼpo, kente Jesús oʼpokapo onʼnopo̱e̱po huaok onʼbahueda̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Olivos oteʼyo o̱ʼnepo huaduk onʼtikayoʼpakpo Jerusalén meyo̱hueʼda ke̱yo̱ onʼtibehuikapo. Huakkaʼda huanigpe̱i̱kaʼeriomeya̱ onʼdurugpakpo “ʼUruda Dios o̱ʼe̱.” “Huadakda Diosa oʼkikaʼ. Huakkaʼtada Diosa oʼbayareadde oʼtiahuaymey. ʼUruaʼda Diosa oʼkikaʼ.” ʼUttaʼda oʼnokoyʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","—‍In Gobierno Huairi oʼtiakde Dios Huairia oʼpakpo oʼtaʼmonaʼuyate. Dios Huairia dakaʼ kato̱e̱ʼ. Kurudya̱ʼ kentaj onʼdurugpak. Dios ʼuruda o̱ʼe̱. —‍Huakkaʼda aratbut o̱gkupopakpo oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Huakkaʼda aratbut o̱gkupopakpo huakkaʼda aratbutere sueʼda fariseo ke̱yo̱ʼti o̱ʼnepo, —‍“Soataʼ yaneʼ.” O̱ʼnen huanigpe̱i̱kaʼeritaj yamanaʼ. —‍Fariseo Jesústaj oʼnonaʼuynigʼa. ");
INSERT INTO amrNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","—‍Doʼhued huanigpe̱i̱kaʼeria ʼuttaʼ okoyhueʼ e̱e̱ʼnayo soataʼ e̱ʼneʼnayo huida̱piʼ oʼdokoyapo. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jerusalényo̱ meyo̱hueʼda o̱ʼe̱depo Jerusalén huakkaʼ jaktaj oʼtiahuaypo Jesúsa Jerusalén aratbuttaj oʼmatinepahuiʼpo oʼbatohuikuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Oʼmanaʼpo, —‍Opudomeytaj Diosa kamanopoʼnoeye̱ʼpo kate kaʼdik moʼe̱ oy opudomey eʼmanopoenkaʼtaʼ huakkaʼda onʼtipaknigʼa oy konig eʼi̱re̱g o̱ʼe̱nok suigpiʼ nopoenkahueʼ moʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Dios Huairitaj o̱ki̱e̱hueʼ moʼe̱nok nogok opudomeytaj dakhueʼnanada o̱ʼe̱a̱po. Opudomeytaj takaʼ onʼhuatiakdeapo. Huakkaʼ jak kurute keʼna huakti̱o̱ke̱ʼ huakbirik takaʼa oʼnokbirikpo onʼtiokkudejdeapo nogyen nogyen boʼhuatiakpo boʼbatiarakapone. ");
INSERT INTO amrNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Opudomenen jak sorokte mokmaenaʼapone. Opudomey huakkaʼ jak aratbuttaj boʼbatiarakapone. Ayaʼda jak huidtaj barakte onʼmaenapo. Kenokaʼ Diosen Huasiʼpo aʼmanopoʼnoeyayaʼpo oʼtiakmeʼ opudomey oknopo̱e̱hueʼ moʼe̱meʼnok. —‍Jerusalényo̱ hua̱e̱ʼeriomeytaj Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ken Diosen jakyo Jesús oʼkudonpo huabahuayaʼeriomeytaj huaboaʼda oʼmakmaenaʼpo huabaeʼeriomeytakon oʼmakmaenaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","—‍“In doʼhued jak o̱ʼe̱. Aʼtionaʼpakyaʼpo aratbut i̱yo̱da onʼkudikaʼ. Konig huabereerien jak opudomeya̱ moʼto̱e̱ne.” Apagbaʼa kenpaʼ oaʼ. —‍Jesúsa huabahuayaʼeritaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Diosen jakyo Jesúsa oʼmanmadikaʼikaʼpo ayaʼmeʼnoeda oʼmanmadikaʼikaʼuyate. Sacerdote huairi, Moisésenbaʼ huamanmadikaʼeriere, nog huakkaʼ jak huairiere Jesústaj onʼhuadiaypo eʼaraktaʼ onʼtipakpo monig arakdik o̱ʼe̱a̱po onʼnopo̱e̱po oʼduknigʼa. ");
INSERT INTO amrNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ayaʼada aratbut onʼpeonhuaʼpo Jesústaj onʼpakpo dakaʼ onʼpeonhuahuaʼuyatenok Jesústaj konig arakdik nopoenkahueʼ o̱ʼnuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nogok nog huameʼnoete Diosen jakyo konig Dios aratbuttaj oʼmanopoʼyarikaʼnig kenda Jesúsa eʼmanmadikaʼte Jesústaj sacerdote huairia onʼhuatiakpo, Moisésenbaʼ huamanmadikaʼeria onʼhuatiakpo, huatoneʼ huairierea onʼhuatiakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","—‍“Yamanmadikaʼ. Yabayareaʼ.” ¿Beʼa menuy? —‍Judío huairiomeya̱ Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","4","—‍Huakkuru doʼtaj meʼnakonen. Bautiza yamagkadhuatiʼ. ¿Beʼa Juantaj yanuyate, huabokereka Diosapiʼ? ¿Menpaʼ Juan onda yaʼpakpo bautiza yamagkikaʼuyate? —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Huayahuaya onpayoʼ judío huairiomey onʼbatiaʼpakpo, —‍¿Jesústaj katiaʼ onaʼapet? Diosa Juantaj oʼtaʼmonaʼuyate. Oroʼomeya̱ Jesústaj enaʼnayo “¿Juantaj menaʼpo oknopo̱e̱hueʼ moʼe̱ʼuy? ¿Menaʼpo nigpe̱e̱hueʼ moʼe̱ʼuy?” Jesúsa monaʼapone oroʼomeytaj. ");
INSERT INTO amrNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","“Juantaj Diosa taʼmonahueʼ o̱ʼe̱ʼuy.” Jesústaj enaʼnayo aratbut oroʼomeytaj huida̱ boʼpaʼeaʼapone. Boʼpaʼeaʼpo oroʼomeytaj boʼarakapone. Kenda Juan Diosen huamanbatiaʼpakeri o̱ʼu̱yate. Ayaʼda aratbut oʼnoknopo̱e̱nok. —‍Ken konig judío huairia onʼbatiaʼpakpo konig huayahuaya onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","—‍Bautiza kamagkeʼpo beʼa Juantaj yaʼtaʼmonaʼuyet nopo̱e̱hueʼ o̱ʼe̱y. —‍Jesústaj huairiomeya̱ oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","—‍Do kenpaʼti, “Yamanmadikaʼ. Yabayareaʼ.” Keʼna doʼtaj menaʼuyne, kenda onahueʼ o̱ʼneapone. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Nogok huakkaʼda aratbuttaj Jesúsa onteʼti oʼmanbatiaʼpakpo oʼmanmadikaʼpo, —‍Huabokerek o̱ʼe̱po, taʼba huato̱e̱ʼeri o̱ʼe̱po uva oʼbatukeʼuyate. Kenokaʼ uva taʼba hua̱ta̱to̱e̱ʼeritaj oʼbaktoyokdepo nogbayo adteda oʼbakhuaʼuyate. Nogbayo ijhueʼda o̱ʼe̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nogok uva huada oʼboyogdenok huanabaʼtaj oʼtaʼmonaʼpo taʼbayo oʼtaʼmonaʼpo taʼba menta̱to̱e̱nigtaj, “Sueʼda uva huada boyok.” Yamanaʼ. Ken huanabaʼ oʼhuaʼuyate. Taʼbayo oʼtiakdepo “Sueʼda uva huada boyok,” eʼmanaʼtada hua̱ta̱to̱e̱ʼeria nigpe̱e̱hueʼ o̱ʼnepo huanabaʼtaj onʼtuktukpo uva huada yokhueʼada onʼtaʼmonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ken taʼba huato̱e̱ʼeria nog huanabaʼtakon oʼtaʼmonaʼuyate. Kentakon onʼtidiʼkeʼpo onʼbitbitdepo uva huada yokhueʼada onʼtaʼmonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Taʼba huato̱e̱ʼeria nog huanabaʼ oʼtaʼmonaʼuyate. Taʼba hua̱ta̱to̱e̱ʼeria kentaj dighueaʼ siroa onʼtukaʼpo tabayaʼ onʼenʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Kenokaʼ “¿Kate ijkaʼapo?” Taʼba huato̱e̱ʼeria oʼnopo̱e̱po, “Doʼhued huasiʼpo huadiʼnanada ijtaʼmonaʼapoy. Kentanayopiʼ onʼtiahuaydepo dakhueaʼ onahueʼ ya̱ʼneapetpiʼ.” Oʼnopo̱e̱ʼuyate. Ken huasiʼpotaj oʼtaʼmonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Taʼba hua̱ta̱to̱e̱ʼeria huasiʼpotaj onʼtiahuaydepo huayahuaya onʼbatiaʼpakpo “In taʼba huato̱e̱ʼeriensiʼpo o̱ʼe̱. Keʼnen huaoj eʼbueydeʼte huaojen taʼba keʼnakon oʼto̱e̱a̱po. Huasiʼpotaj monʼarak. Keʼnen huaojen taʼba oroʼomeyen moʼta̱e̱ʼpo moʼdarak.” Kenda taʼba hua̱ta̱to̱e̱ʼeriomeya̱ onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","16","Ken uva taʼbokpeyo onʼtohuaʼdepo onʼdarakuyate. —‍Jesúsa oʼmanaʼpo. —‍Taʼba huato̱e̱ʼeria hua̱ta̱to̱e̱ʼeriomeytaj oʼbahuatiakapo. Hua̱ta̱to̱e̱ʼeritaj oʼbaarakapo. Taʼba nog aratbuttaj oʼbayokapo. —‍Jesúsa oʼmanbatiaʼpakuyate. Kenda huakkaʼda aratbut onʼpe̱e̱depo, —‍Kejeʼ kenda kahueʼdik ka̱e̱ʼ. —‍Oʼdaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jesúsa aratbuttaj oʼbatiahuaypo, —‍Apagbaʼ yanʼnopoenkaʼ. Kenpaʼ Apagbaʼa oaʼ, Huid jak huakaʼeria jak o̱gkaʼpo Diosen ʼuru huid pakhueʼ o̱ʼnuy. Ken hueretda huida̱ Diosen jak jonʼtaʼtihuada̱ʼapo. Nogok huaknopo̱e̱ʼerien Huairi i̱jje̱a̱poy. Konig huid jak huakaʼeriomey o̱gkaʼpo huidtaj pakhueʼda o̱ʼnepo o̱ʼnenʼuyate konigti doʼtaj pakhueʼada o̱ʼnepo kenpaʼti doʼtaj meʼnenapone. ");
INSERT INTO amrNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Konig huidtoneʼtaj oʼtikudeʼpo oʼnokketo̱gkaʼapo konigti Diosen Huairitaj oknopo̱e̱hueʼ o̱ʼnepo dakhueʼda o̱ʼneapo. Huidtoneʼ kutahueyaʼ eʼtikotnayo konig hua̱o̱ga̱da yamagkapet. Ehueʼda o̱ʼneapo. Konigti kenomey Diosen Huasiʼpotaj pakhueʼ o̱ʼnepo nopoʼkoreahueʼ o̱ʼnepo. Diosa castiga oʼmagkaʼapo. Ehueʼda o̱ʼneapo. —‍Kenda Jesúsa oʼmanbatiaʼpakpo oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ken sacerdote huairiomey, Moisésenbaʼ huamanmadikaʼeriere Jesústaj onʼpeeonhuaʼdepo Jesúsa oroʼomeytaj boʼtiaʼpakne, oroʼa konig huairien taʼba hua̱ta̱to̱e̱ʼerionig o̱ʼneaʼ, boʼtiaʼpakne. Judío huairiomeya̱ onʼnokotdepo Jesústaj huabakuda̱ʼ jakyo eʼtohuaʼtaʼ onʼtipaknigʼa aratbuttaj onʼmakmeʼpukpo tohuahueʼdik o̱ʼnuyate. Jesús Diosen huamanbatiaʼpakeri o̱ʼe̱. Aratbuta oʼnoknopo̱e̱nok huairia aratbuttaj onʼmakmeʼpukuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Konige̱po Jesúste namaʼda huaaʼeriomeytaj onʼtitaʼmonaʼpo sacerdote huairia onʼtitaʼmonaʼpo namaʼda huaaʼeritaj konig huadaknoponigda onʼnige̱po Jesústaj onʼpe̱e̱a̱po namaʼda Jesúsa yaaʼapetdapiʼ. Jesúsa namaʼda eaʼnayo gobierno huairite tohuaʼdik ya̱ʼneapet. Jesúsnayo namaʼda ahueʼdik o̱ʼi̱kaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Konige̱po Jesústaj oʼnonaʼpo, —‍Buttida iʼmanikate. Buttida iʼmanmadikaʼikaʼ. Kenda Diosa oʼpak buttida iʼmanmadikaʼikaʼ. Beʼapiʼ aratbut huairipiʼ ontaj eʼpe̱e̱ʼnayo meʼpukhueʼada i̱ʼe̱po buttida iʼmanmadikaʼikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Romano gobierno huairitaj menpaʼ huakupe yokdik o̱ʼe̱? ¿Yokhueʼdikpiʼ o̱ʼe̱, huamanmadikaʼeri? Jesústaj oʼnonaʼuyate. —‍Kenda namaʼda huaaʼeria oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesúsa namaʼda yaʼmanaʼapetpiʼ namaʼda huaaʼeria namaʼda oʼnonaʼdenok Jesús oʼnokotonpo, —‍¿Menaʼpo namaʼda doʼtaj oʼnonaʼ? ");
INSERT INTO amrNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Men huakupe. ¿Beʼed huakok huakupete ya̱ʼe̱? ¿Beʼed huadik huakupete eʼmadoyaʼ ya̱ʼe̱? —‍Oʼmanaʼnok, —‍Romano gobierno huairi o̱ʼe̱. —‍Onteʼti Jesústaj oʼnonaʼnok. ");
INSERT INTO amrNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","—‍Gobierno huairien huakupe huairitaj yanʼyoktiʼ. Kenpaʼti Diostaj yanoknopo̱e̱po yanʼnigpe̱i̱kaʼ. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Aratbuta enʼpe̱e̱a̱ʼte Jesúsa namaʼda ahueʼ o̱ʼneapo onʼnopo̱e̱ʼuy. Jesúsa ʼuruaʼda oaʼikaʼ onʼnopo̱e̱po namaʼda huaaʼeri soataʼ o̱ʼneʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Nogok Jesústaj onʼhuahuaʼpo sueʼada saduceo aratbut onʼhuahuaʼuyate. Aratbut kubarakyaʼ onteʼti noyhuadhueʼ o̱ʼneapo saduceo onʼnopo̱e̱po kenpaʼti onʼbatiaʼpakikaʼpo, ");
INSERT INTO amrNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—‍“Huabokerek hua̱to̱e̱ere e̱ʼe̱a̱da suigpiʼ okhuij ehueʼada eʼbueynayo keʼnen huamaʼbuy ʼayhuataj to̱e̱pakdik o̱ʼneapo. Huakkuru eʼta̱siʼpo̱e̱ʼ kentaj kaʼdikkeʼ huamaʼbuykudakendik ka̱e̱ʼ.” Moisésa aʼnennada oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ken siete huamaʼbuy o̱ʼnuy. Huakkurueria oʼto̱e̱pakdepo nogok okbueyʼuyate. Sigpiʼ okhuij ehueʼada okbueyʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Nog huamaʼbuyakon ʼayhuataj oʼto̱e̱pakpo nogok keʼnakon sigpiʼ okhuij ehueʼada okbueyʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Konoga̱da ʼayhuataj oʼto̱e̱pakpo keʼnakon sigpiʼ okhuij ehueʼada okbueyʼuy. Konigti nog huamaʼbuy o̱gkaʼuyate. Ayaʼda huamaʼbuy seis huamaʼbuy huakkuruerien ʼayhuataj onʼto̱e̱pakdepo sigpiʼ onpapayoʼ okhuijhueʼada onʼbueyʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ken nogok ʼayhuakon onʼtimabueyʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nogok aratbut kubarakyaʼ onteʼti Diosere enʼmanoyhuaddeʼte, ¿Keʼna ʼayhua beʼed hua̱to̱e̱ ya̱ʼe̱a̱po? Ayaʼda siete huamaʼbuy onʼto̱e̱ʼuyate, huamanmadikaʼeri. —‍Saduceoa oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","—‍Oy aratbut indariyaʼ onʼto̱e̱pakikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Kenomeynayo Diostaj daknopoʼda o̱ʼnepo Diostaj oʼnoknopo̱e̱nok nogok onʼmanoyhuaddepo Diosere o̱ʼnedepo onteʼti to̱e̱pakhueʼ o̱ʼneapo. Kenpaʼti hua̱yo̱bu kato̱e̱pakeʼpo bayokhueʼ o̱ʼneapo. ");
INSERT INTO amrNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Onteʼti bueyhueʼdik o̱ʼneapo. Ken konig Diosen huamataʼmoneri kurudyo̱ o̱ʼne konigti o̱ʼneapo. Kubarakyaʼ Diosa oʼmanoyhuada̱ʼnok Diosensiʼpo o̱ʼneapo. ");
INSERT INTO amrNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Aratbut kubarakyaʼ onʼnoyhuada̱po Moisésa oʼmadoyaʼpo Diosbaʼ oʼmadoyaʼpo oʼmanopo̱e̱a̱ʼuyate. Kente Moisésenbaʼte hue̱ymey eʼbakpakte Moisés oʼtimadoyaʼuyate kente Dios Huairi Abrahamen Dios o̱ʼe̱. Dios Huairi Isaacen Dios o̱ʼe̱. Kenpaʼti Dios Huairi Jacoben Dios o̱ʼe̱. Apagbaʼa kenpaʼ oaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Abrahamkudak Isaackudak Jacobkudakere huaknopo̱e̱ʼeri o̱ʼneʼuynok konig noki̱re̱g onʼnoe Diosa oʼmatinopo̱e̱po. Ayaʼda Diostaj huaknopo̱e̱ʼeri enʼbueypiʼ onʼnoe Diosa oʼmatinopo̱e̱po. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","—‍Huadakda iʼmanaʼ, huamanmadikaʼeri. —‍Sueʼda Moisésenbaʼ huamanmadikaʼeria oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Onteʼti Jesústaj onʼmeʼpukpo onahueʼ o̱ʼnuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","—‍“Cristo Davidkudaken adhueaʼ huayayo o̱ʼe̱a̱po.” Menaʼpo kenpaʼ onʼdaʼikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","43","Salmosbaʼ Apagbaʼte Cristotaj oʼbatiaʼpakpo, Cristo doʼhued Huairi meʼta̱e̱ne, Davida oaʼuyate. “Doere teyada kenpaʼda yamanaʼikaʼ. Ayaʼda o̱ʼnen takaʼ konig totoʼ kenpaʼti oknopo̱e̱hueʼ hua̱e̱ʼeri nogokaʼda huaboaʼda ontaj nigpe̱e̱dik o̱ʼneapo.” Cristo doʼhued huairitaj Dios Huairia onaʼuy. Davida Salmosbaʼte oaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","“Doʼhued Huairi meʼta̱e̱ne.” Cristo siʼpopakhued Davida oaʼuyate. Cristo Huairi eʼsiʼpoe̱ʼdete Davidkudaken adhueaʼ huayayo kenpaʼti o̱ʼe̱ʼuy. Kenda dapiʼ moʼnopo̱e̱. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Ayaʼda aratbut Jesústaj onʼpe̱e̱depo, ");
INSERT INTO amrNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—‍Moisésbaʼ huamanmadikaʼeriomey huataʼda onʼeretpakpo namaʼda o̱gkikaʼ dakaʼ yanʼnopo̱i̱kaʼ. Konigti huairi kiriga̱yo̱ʼ huabidokda eʼottaʼ onʼpakikaʼpo, kenpaʼti huakkaʼ jak eretnopoyo e̱ʼhua̱e̱ʼte “Iʼtiak, huairi.” Enaʼte eʼpe̱e̱taʼ onʼpakikaʼ. Kenpaʼti judíoen hua̱i̱takeʼ jakyo huairied huahuadte eʼhuadtaʼ onʼeretpakikaʼ. Kenpaʼti fiestate konig huairied huahuadte eʼhuadtaʼ onʼeretpakikaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Kenpaʼti ʼayhuaen huakupepiʼ jakpiʼ katepiʼ enʼta̱e̱ʼte konig engaña o̱gkaʼpo onʼbakkayikaʼpo. Kenda o̱gkikaʼpo onokteteyoʼ Diostaj ijhueʼda onʼtionaʼpakonhuahuikaʼpo aratbuta menʼtiahuayeʼpo huadakda o̱ʼne menʼtinopo̱e̱ʼpo konige̱po kiriga̱yo̱ʼ onʼtionaʼpakonhuahuikaʼpo. Kenda o̱gkikaʼnok Diosa dakaʼ oʼnopo̱e̱po huakkaʼ castiga oʼmagkaʼapo. Huakkaʼ paiʼda onʼnopoʼe̱a̱po. Konig kenomey namaʼda o̱gkikaʼ konigti kahueʼ yaneʼ. —‍Jesúsa huanigpe̱i̱kaʼeritaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Diosen jakyo o̱ʼnepo, judío huairi huakkaʼda onʼmato̱e̱po Diosen jakyo huakupe cajayo onʼkuda̱ʼpo Jesúsa oʼtiahuayʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Kenpaʼti paiʼda ʼayhua e̱ʼe̱a̱da bottaʼ sigkupe jeyda eʼkuda̱te Jesúsa oʼtiahuaypo, ");
INSERT INTO amrNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","4","—‍In ʼayhua suigda eʼto̱e̱a̱da konig huakkaʼda oʼkuda̱ʼ. Judío huairinayo huakkaʼda e̱ʼta̱e̱tada konig suigda onʼkuda̱ʼ. ʼAyhuanayo sueʼda e̱ʼta̱e̱tada Diostaj dakaʼ oknopo̱e̱po ayaʼda Diostaj oʼyok. Buttida ijjay. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ken Diosen jak ʼuruda o̱ʼe̱. Sueʼda onʼbatiaʼpakpo. ʼUruda huid kenpaʼti Diostaj ʼuruda katepiʼ katetehueʼ onʼyokuyate. Kendakon onʼnigbetuyate. Diosen jak ʼuruda o̱ʼe̱. Kenda onʼtiahuaypo onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—‍Nogok in ʼuruda jak boʼtiahuayikaʼnig ekbirik huid onʼmajenapo. Ayaʼda huid sorokte nog aratbuta onʼbaksakaʼapo. Huid kupahuihueʼda o̱ʼe̱a̱po. Diosen jak ehueʼ o̱ʼe̱a̱po. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","—‍¿Kenda oroʼomeytaj onaʼdene menokaʼ ya̱ʼe̱a̱pet? ¿Oroʼomey aʼnopo̱e̱yaʼpo kate huakkuru tiahuaydik o̱ʼe̱a̱pet? Huamanmadikaʼeri. —‍Jesúsen huanigpe̱i̱kaʼeria Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","—‍Keyoj namaʼda monaʼapey. Opudomeytaj huakkaʼada bohuatiakapone, “Diosa meʼtaʼmonaʼuyneʼ, Cristo i̱jje̱y.” Namaʼda onʼbatiaʼpakapo. “Oy opudtaj ijhuatiakpo, do Cristo i̱jje̱y.” Namaʼda onʼbatiaʼpakapo. Kenomeytaj keyoj kenomeytaj manigpe̱e̱hueʼ yaneʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nogbayo nogbayo gobierno sorotatataj nog gobierno sorotatataj onʼbarakonhuahuaʼ, onʼbatiaʼpakdeapo moʼpe̱e̱deapet, meʼpukehueʼ yaneʼ. Ken huakkuruda gobierno sorotataj barakonhuahuaʼdik o̱ʼneapo. Aʼti nogok Diosen keneʼhua̱ya̱ʼ huameʼnoete do onteʼti ijtiakapoy. —‍Jesúsa huanigpe̱i̱kaʼeriomeytaj oʼmanaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","—‍Huadaribayoeri nog huadaribayoeri sorotataa yanʼbarakapet. Kenpaʼti huadaribayo gobierno sorotataj nog huadaribayo gobierno sorotatataj diga̱ʼda yanʼbarakapet. ");
INSERT INTO amrNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nogya̱ʼ nogya̱ʼ huadaribayaʼ diga̱ʼda ya̱ʼi̱ye̱gapet. Nogya̱ʼ nogya̱ʼ aypo ehueʼda ya̱ʼe̱a̱pet. Aypotaʼ yanʼmabueyonhuaʼapet. Kenpaʼti nogya̱ʼ nogya̱ʼ aratbut dakhueʼda o̱ʼnepo huakkaʼda yanʼmabueyapet. Kurudyo̱ huiyoknanada onʼtiahuaypo diga̱ʼda yanʼmameʼpukapet. Konig tiahuayhueʼya onʼtiahuaypo yanʼmeʼpukapet. ");
INSERT INTO amrNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Kenda kahued e̱e̱ʼted opudomey huaknopo̱e̱ʼeritaj moʼbaeaʼpo moʼbatohuaʼapone. Opudomey huaknopo̱e̱ʼeritaj boʼhuadiayapone. Judío aratbuten hua̱i̱takeʼ jakyo moʼbatohuaʼapone. Opudomeya̱ dakhueaʼda boʼkameʼne, boʼhuadiaypo namaʼda boʼhuaaʼapone. Huabakuda̱ʼ jakyo boʼkuda̱ʼapone. Kenpaʼti doʼtaj moknopo̱e̱nok gobierno huairite moʼbatohuaʼapone, opudomey huaknopo̱e̱ʼeri dakhueaʼ o̱gkameʼ aʼhuaayaʼpo huairite moʼbatohuaʼapone. Gobierno huairite huakkurute moʼnigboaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Do Cristotaj huaknopo̱e̱ʼeri i̱jje̱po Cristoen i̱jje̱y, Diosensiʼpo i̱jje̱y. Dios aratbuttaj oʼmatinepahuiʼpo oʼmanopoʼyareadhuahuikaʼ. Batiaʼpakdik moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Huairite huahuahued “Katiaʼ kentaj yonaʼapet,” nopo̱e̱hueʼ yaneʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Kenok huairitaj huanaʼdikte huadakdik kenpaʼti ʼuru eʼnopo̱e̱ʼ doʼhua onʼnopo̱e̱a̱ʼapone. ʼUrunanada monaʼapet opudomeyen takaʼ oknopo̱e̱hueʼ hua̱e̱ʼeria onteʼti katiaʼpiʼ sigpiʼ opudtaj huaahueʼdik ya̱ʼneapet. ");
INSERT INTO amrNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Opudomeyen huaoapiʼ hua̱ye̱a̱piʼ huamaʼbuyapiʼ huidpoapiʼ kenpaʼti nog huabetapiʼ kenpaʼti huadiʼda aratbutapiʼ dakhueaʼda opudomeytaj mogkaʼapone. Castiga ka̱gkeʼpo gobierno huairitaj boʼyokapone. Opudomeytaj sueʼtada boʼarakapone. ");
INSERT INTO amrNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Doʼtaj oʼnoknopo̱e̱nok doʼhued huadik menʼdikto̱i̱kaʼnok konige̱po ayaʼda aratbuta boʼhuadiayapone. ");
INSERT INTO amrNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Meʼpukehueʼ yaneʼ. Dakaʼ Diosa moʼmato̱e̱i̱kaʼapone. Opudomey kenpaʼda bueyhueʼ moʼe̱a̱pone. Diosere moʼnoeonhuahuikaʼapo. Ayaʼ opudenso̱ʼtaj Diosa dakaʼ moʼmato̱e̱a̱pone. Huakuhuij opuden nogtipiʼ ehueʼ ehueʼdik o̱ʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Dakaʼda doʼtaj eknopoeonhuahuikaʼnayo batikhueʼada eknopoeonhuahuikaʼnayo Diosere moʼnoeonhuahuikaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Jerusalén jakkuru huanig takaʼ sorotataj e̱ʼnedeʼte opudomeya̱ eʼtiahuaydeʼ Jerusalén huakkaʼ jakyo i̱da onʼbarakapo kenpaʼti jak onʼmaenapo. Huakkaʼ jak ehueʼda o̱ʼe̱a̱po, yanʼnopo̱e̱tiʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kenokaʼ ayaʼda aratbut Judea huadaribayo o̱ʼnepo oteʼyon i̱da kanʼmamoneʼpo, ayaʼda Jerusalényo̱ hua̱e̱ʼeri i̱da kaʼnoro̱koneʼpo, kenpaʼti kenokaʼ taʼbayo o̱ʼnepo huakkaʼ jakyo onteʼti kumejhueʼ kaʼneʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Kenokaʼ Dios keʼnen Israel aratbuttaj castiga oʼmagkaʼapo. Kenpaʼ Diosbaʼa oaʼuyate. Kenda Diosa oʼkaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kenokaʼ Diosa keʼpoda castiga yamagkaʼapet. Ettoneʼ bogdakhueʼ ya̱ʼneapet kenpaʼti nog ettoneʼ yo̱bed onʼto̱e̱po yanʼminoga̱ʼdeapet kenpihuay keʼponada ya̱ʼe̱a̱pet. Paiʼnanada onʼnopoʼe̱a̱po. Huadarite in judío aratbuttaj Diosa diga̱ʼnanada castiga oʼmagkaʼapo, paiʼda onʼnopoʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Sorotataa judíotaj yanʼbarakapet huakkaʼ yanʼmabueyapet nogomeytaj noybayo nog gobiernoenbayo nogyon nogyon yanʼbatohuaʼapet. Nog aratbut Jerusalényo̱ ya̱ʼneonhuahuikaʼapet, nog aratbutda huairi Jerusalényo̱ ya̱ʼneonhuahuikaʼapet. Kenokaʼ Diosa oʼpakpo judío onteʼti Jerusalényo̱ ya̱ʼnikaʼapet. Gobierno huairi hua̱ʼenda yanʼto̱e̱a̱pet. —‍Jesúsa oʼmanaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","—‍Diosa castiga oʼmagkaʼapo huanopo̱e̱a̱ʼ niokpo puug siokpo nogpaʼda ya̱ʼneapetnok nogoknanada nogbayaʼ nogbayaʼ aratbuta enʼtiahuayada kate Diosa yakaʼapet yanokkahueapet. Kenpaʼti e̱ʼpo̱ga̱ ʼuttaʼda yaaʼapet kenpaʼti huiyokda e̱ʼpo̱ga̱ diga̱ʼda yaʼbosakapetnok diga̱ʼda yanʼmameʼpukapet. ");
INSERT INTO amrNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ken niokpo siokpoere konig huiyokda o̱ʼi̱ye̱ga̱ponok konige̱po kate Dios yakaʼapet aratbut onʼnopo̱e̱po huakkaʼnanada onʼmeʼpukpo konig onʼmabueynoatuʼapo. ");
INSERT INTO amrNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kenokaʼ do eʼtiakte onʼtiahuayapo. Do huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne kurudya̱ʼ e̱ʼsi̱hui̱ʼya̱ʼ ijhuarakapoy. Teynanada kenpaʼti konig senogda jeynanada ijhuarakapoy. Ken konig doʼtaj boʼtiahuayapone. ");
INSERT INTO amrNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Kenokaʼ huaboaʼda o̱ʼe̱deapo konig kurud e̱ʼi̱ye̱gdeʼte kenokaʼ yanʼdurugpakpo kutayo yanʼmaboʼ. Opudomeytaj Diosa oʼmanopoʼyareaʼdeapo. —‍Kenda Jesúsa oʼmanmadikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Onteʼti Jesúsa oʼmanbatiaʼpakpo oʼmanmadikaʼpo, —‍Higuera hue̱ymey kenpaʼti nog hue̱ymeytapiʼ yanʼtiahuayʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Kenokaʼ huakutaj oʼbakutapakde huabayokok aʼti o̱ʼe̱a̱po, moʼnopo̱e̱. ");
INSERT INTO amrNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Kenda huaboaʼda oʼnonaʼdenig kenda huaboaʼda boʼtiahuaydepo Dios Huairi aʼti oʼtiakapo nopo̱e̱ʼdik moʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Kenda huaboaʼda ijjaʼnig opuden huakkaʼ jaktaj takaʼ sorotataa keʼpoda o̱gkaʼapo. Jak ehueʼ o̱ʼe̱a̱po. Ayaʼ aratbut oyda onʼnoepo bueyhued o̱ʼnepo onʼtiahuayapo. Buttida ijjay. ");
INSERT INTO amrNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kurud ehueʼ o̱ʼe̱a̱po. Kenpaʼti huadari ehueʼ o̱ʼe̱a̱po. Doʼhued buttida huadiknayo batikhueʼdik o̱ʼeonhuahuikaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","35","Keyoj ijjay. Dakaʼ yanʼnopo̱i̱kaʼ. Kenpaʼda huadakda ya̱gʼkikaʼ, huadakda yanʼnopo̱i̱kaʼ. Katepiʼ fiestapiʼ eʼkaʼtaʼ meʼpukehueʼ yanikaʼ. Huakkaʼda eʼmamayʼtaʼ eretpakhueʼ yanikaʼ. Katetapiʼ huakkaʼ mepuʼkehueʼ yanikaʼ. Ken konig namaʼda eʼkikaʼnayo kenokaʼ doʼtaj e̱kpo̱e̱ʼ nige̱hueʼ e̱ʼneʼte do huabokerek i̱jje̱po kurudya̱ʼ i̱da ijhuarakapoy. Castiga aʼmagkayaʼpo ijtiakapoy. Konig trampa i̱dada oʼkotikaʼ konig e̱kpo̱e̱ʼ nige̱hueʼ e̱ʼneʼte i̱dada kurudya̱ʼ ijhuarakapoy. Castiga eʼmagkaʼ ijtiakapoy. Ayaʼtada aratbut nogya̱ʼ nogya̱ʼ nog huadari nog huadariyo ayaʼtada castiga aʼmagkayaʼpo ijbahuatiakapoy. ");
INSERT INTO amrNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Konige̱po doʼtaj eʼtiaktaj e̱kpo̱e̱ʼ menʼnige̱ʼikaʼ. Kenpaʼti kenokaʼ konig kenda huaboaʼda ijjaʼnig konig sorotataj nogbayo sorotatataj onʼbarakikaʼpo kenpaʼti kenokaʼ opudomeytaj diga̱ʼ boʼhuadiaypo keʼpoda mogkaʼapone. Konige̱po opudomeya̱ dakaʼ Diostaj yanoknopo̱i̱kaʼ Diostaj yanʼtionaʼpakikaʼ. Do huabokerek i̱jje̱po, doʼhua eʼtiakte daknopoʼda e̱ʼdik yanikaʼ. —‍Jesúsa oʼmanmadikaʼpo oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ken huameʼnoete Diosen jakyo oʼmanmadikaʼikaʼpo Jesúsa oʼmanmadikaʼikaʼuyate. Sikyo Jerusalénya̱ʼ o̱ʼo̱ro̱kikaʼpo oteʼ Olivoste oʼhuaʼikaʼpo ke̱yo̱ jakyo oʼtayikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Sikyoedda huakkaʼda aratbut Diosen jakyo o̱ʼnehuaʼpo Jesústaj aʼpe̱e̱yaʼpo onʼkudikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Aʼti judíoen fiesta o̱ʼe̱a̱po. Ken fiestate biahueʼ pan onʼbapeʼikaʼ. Eʼbiaʼo̱gʼ okbukhueʼ o̱ʼnepo pan biahueʼ o̱ʼi̱kaʼ. Ken fiesta huakkurueri isiʼpo mabueyhueʼ e̱e̱ʼ okkahuehueʼ fiesta onʼdikkuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Kenokaʼ sacerdote Diosen jakyo huabaaʼeri huairi, Moisésenbaʼ huamanmadikaʼeriere sueʼda ke̱yo̱ti o̱ʼnepo Jesústaj monig arakdik o̱ʼe̱a̱poy. Kenomey onʼnopo̱e̱po Jesústaj eʼtohuaʼte huakkaʼ aratbuta oroʼtaj enʼtiahuayʼnayo aratbuta boʼhuadiayapey onʼnopo̱e̱po onʼmakmeʼpukuy. ");
INSERT INTO amrNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Judas Iscariote Jesúsen doce huamataʼmonaʼeri nogtida o̱ʼu̱yate. Judastaj totoʼ huairia oʼnopoʼto̱e̱denok, ");
INSERT INTO amrNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Sacerdote huairitaj kenpaʼti Diosen jak huato̱e̱ʼeri huairitaj oʼbahuahuaʼpo monig Jesústaj ijbayokapo oʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ken sacerdote huairi Diosen jak huato̱e̱ʼeriere Judastaj onʼpe̱e̱depo durugda o̱ʼnepo, “Huakkaʼda huakupe boʼyokapone.” Judastaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","“Huakkaʼ huakupe onʼyokaponok Jesúste onʼtohuaʼapone.” Judasa oʼmanaʼuyate. “Kente huakkaʼ aratbut ehueʼ e̱ʼneʼyo menpe̱e̱taʼ sacerdotetaj ijbatohuaʼa.” Huaboaʼda Judasa oʼnopo̱e̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Ken huameʼnoe pan eʼbiaʼo̱gʼa okbukhueʼada onʼbapeʼikaʼnig fiesta o̱ʼe̱de. Kenokaʼ ovejasiʼpo onʼdarakikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Pedrotaj Juaneretaj oʼmataʼmonaʼuyate Jesúsa. —‍Yanhuatiʼ. Judío huakkurueri isiʼpo mabueyhueʼ e̱e̱ʼ okkahuehueʼ fiesta aypo yanʼmanhuada̱ʼ. —‍Jesúsa oʼmanaʼnok, ");
INSERT INTO amrNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","—‍¿Meya̱ʼ fiesta aypo oʼmanhuada̱ʼapo? —‍Jesústaj oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","—‍Jerusalényo̱ yanhuaʼ. Huakkaʼ jakyo yanʼkudondepo, huabokerek hue̱ʼe̱y huaegpuʼte hueda̱ʼ eʼtohuaʼte boʼhuahuayapone. Kentaj yanʼtahuatiʼ. Ken jakyo oʼkudapo. Ken jak kurute yanʼhuahuatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","“¿Do huanigpe̱i̱kaʼeriere o̱ʼnen jakyo meya̱ʼ oʼbapeʼapo?” oroʼen huamanmadikaʼeria menaʼne. Ken konig jak hua̱ta̱e̱ʼeritaj ya̱ʼnonatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ken jak hua̱ta̱e̱ʼeri opudomeytaj oʼpe̱e̱depo jak kutayo huaboroʼ ki̱re̱gyo oʼbatohuaʼnok kutopa huabidda huahuadere monʼtiahuayatu. Ke̱ya̱ʼ aypo yanʼmanhuada̱ʼ. —‍Jesúsa Pedrotaj Juaneretaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ken Juan Pedroere oʼnokhuaʼpo, huakkaʼ jak Jerusalényo̱ onʼhuaʼpo kenda Jesúsa oʼmanaʼnig onʼhuahuayʼuyate. Ken jakyo o̱ʼnehuaʼpo fiesta aypo onʼmanhuada̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Kenokaʼ aypo eʼmahue̱ydeʼte kutopate Jesús Jesúsen huamataʼmoneriere onʼhuaddepo, ");
INSERT INTO amrNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","—‍Do bueyhued i̱jje̱po in judío huakkurueri isiʼpo mabueyhueʼ e̱e̱ʼ okkahuehueʼ kaʼneʼpo fiesta opudomeyere eʼtobapeʼtaʼ huakkaʼ ijpaki. ");
INSERT INTO amrNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Onteʼti in fiesta aypo bapehueʼ i̱jjeonhuahuikaʼapopo. Nogok ayaʼda Diosen Huairitaj enʼnigpe̱e̱deʼte kenpaʼti do Diosen Huasiʼpo eʼnigbueyʼuydeʼte doʼtaj okkahuehueʼada aypo moʼbapeʼikaʼapone. Kenokaʼ nogoknanada onteʼti in okkahuehueʼada aypo ijbapeʼapoy. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ken huabaʼte huamaiʼpuʼ oʼto̱e̱po, Diostaj dakiti onaʼdepo, —‍Ayaʼada yanʼmaiʼe̱ʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Konige̱po uva huada hue̱ʼe̱y mayhueʼ i̱jjeonhuahuikaʼapoy. Nogokda Dios Huairitaj ayaʼada enʼnigpe̱e̱deʼte onteʼti ijmayapoy. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Kenpaʼ oaʼdepo pan oʼbapadpo Diostaj dakiti oaʼdepo oʼpoʼsakeaʼpo doce huanigpe̱i̱kaʼeritaj oʼbayokeʼpo, —‍In pan doʼhued hua̱so̱ʼnigti o̱ʼe̱. Ayaʼtada kamannigbueyeʼpo Diosa meʼtaʼmonaʼuyne. In pan yanʼbapeʼ. Do eʼbuey okkahuehueʼ hua̱i̱kaʼ yanʼbapeʼ. —‍Oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ken onʼbapeʼdepo onteʼti huamaiʼpuʼ oʼbayokpo, —‍In vino konig Diosen huaboaʼ huamanopoʼyareaʼ eʼmanaʼ huadik o̱ʼe̱. Buttida o̱ʼe̱ aʼmanopo̱e̱a̱yaʼpo doʼtaj boʼarakapone. Doʼhued mimi oʼmimihuaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Oynayo ken huabokerek oroʼere oʼbapeʼnigʼa konig huadiʼda oʼbapenigʼa doʼtaj takaʼtaj beʼyokapone. ");
INSERT INTO amrNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Do huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne. Ijbueyapoy. Konig Diosa oʼpakpo aʼnennanada oʼnopo̱u̱ya̱tenok, ijbueyapoy. Keʼna takaʼtaj beʼyokapone. Kentaj Diosa diga̱ʼ castiga o̱gkaʼapo. Paiʼnada oʼnopoʼunhuahuikaʼapo. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ken, huaboaʼda onʼbatiaʼpakepo Jesúsen huataʼmonaʼeriomey huayahuaya onʼbatiaʼpakepo, ¿beʼauru Jesústaj takaʼtaj yaʼbayokapo? onʼbatiaʼpakeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kenokaʼ onʼbatiaʼpakpo. ¿Oroʼomey beʼaturu hueretda huairi o̱ʼe̱a̱pet? Huayahuaya huamataʼmonaʼeriomeya̱ onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","—‍Nog aratbuten gobierno huairi teyda onʼmanaʼikaʼ kenpaʼti onʼmataʼmoneaʼikaʼ. “Huadakda o̱gkikaʼ.” Nog aratbuta kenomeyen huairitaj huaaʼdik o̱ʼnikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Opudomeynayo konig nog aratbut gobierno huairi ehueʼdik yaneʼ. Opudomeya̱ hueretda huairi e̱e̱ʼtaʼ eʼpaknayo teyda eʼmataʼmonaʼikaʼtaʼ pakhueʼ yanetiʼ konig huasuedonig yanetiʼ. Kenpaʼti opudomey huairi e̱e̱ʼtaʼ eʼpaknayo konig huanabaʼ yanikatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Keʼna kutopate oʼbapeʼ. Keʼna huairi o̱ʼe̱. Keʼna aypo oʼnigtotiakikaʼnig keʼnataj huanabaʼ o̱ʼe̱. Donayo opudomeyere konig opudomeyen huabatihuapokikaʼeri i̱jje̱y. Ken konig Diosa oʼpak. ");
INSERT INTO amrNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Kenokaʼ judío huairi doʼtaj engaña e̱gkaʼtaʼ onʼeretpakpo namaʼda enaʼtaʼ mentipakikameʼne kenokaʼ doʼere moʼi̱kameʼne. ");
INSERT INTO amrNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Konig doʼhued Apag Diosa hueretda huairitoneʼ meʼe̱a̱ʼu̱yne. Konig ayaʼtada manaʼdik i̱jje̱po kenpaʼti mataʼmonaʼdik ka̱e̱ʼpo huairi meʼe̱a̱ʼu̱yne. Konigti huairi opudomeytakon o̱ʼneaʼne. ");
INSERT INTO amrNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nogok do gobierno huairitoneʼ e̱e̱ʼte doeretaj moʼtobapeʼapone. Kenpaʼti doere moʼmayapone. Dios Huairien huahuad huahuadte boʼhuadapone. Ayaʼda Israel aratbuttaj, doce tribus aratbuttaj konig huamanoeya̱ʼeri huairionigti moʼe̱a̱pone. Kenda katepiʼ Israel aratbut o̱gkikaʼuyate, kenda moʼpe̱e̱deapone. Dakhueaʼ o̱gkaʼnigtaj moʼnopo̱e̱nok Diosa castiga oʼmagkaʼapo. —‍Jesúsa doce huamataʼmonaʼeriomeytaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","—‍Yape̱e̱ʼ Simón, yape̱e̱ʼ Simón. “Beyok Jesúsen huanigpe̱i̱kaʼeri konig trigotaj ektipoapaʼ o̱ʼnen huataʼmonaʼeritaj eʼmagkaʼtaʼ ijpaki. Jesúsen huataʼmonaʼeritaj menpaʼti dakaʼ yanoknopoenhuahuiketapo batikhueʼada eʼnoknopoenhuahuikate namaʼda eʼmagkaʼtaʼ ijbatipaki, Dios.” Totoʼ huairia onaʼuyatenigʼa. ");
INSERT INTO amrNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Donayo ontaj Simón oʼtionaʼpakne. “Simón Diostaj doʼtakon dakaʼ kaknopo̱i̱keʼ batikhueʼada kaknopo̱i̱keʼ kenpaʼti onaʼti doʼtaj eʼnopoʼkoreaʼdeʼte huamaʼbuy huaknopo̱e̱ʼeritaj teyda eknopo̱e̱ʼ kabatihuapokikeʼ.” Kenda oʼtionaʼpakne. —‍Jesúsa Simón Pedrotaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","—‍On huabakuda̱ʼ jakyo e̱gkuda̱ʼnayo kuddiktion i̱jje̱y. Onere aʼbueyyaʼpo huaʼdiktion i̱jje̱y, ijnopo̱e̱y, Huairi. —‍Simón Pedroa Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","—‍Oyedda in sikyo huatahuaj sipoghued “Jesústaj jo̱ki̱a̱hueʼya i̱jje̱y,” bapaʼaʼ iaʼapo, Pedro. —‍Jesúsa Pedrotaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","—‍Aʼnenda opudomeytaj doʼhua onʼmataʼmonaʼuyne. Kutamabayoʼ, huakupebayoʼ nog huaʼiotbayoʼ onʼmataʼmonaʼuyne. Enhuaʼdeʼte konig ayaʼda eʼtamaeʼonig moʼe̱meʼne. —‍Jesúsa oʼmanaʼnok, —‍E̱e̱ʼ, katepiʼ ayaʼda oʼpaknig oʼmato̱e̱ʼuy. —‍Oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","—‍Oynayo huakupe e̱ʼta̱e̱ʼnayo yanʼtohuaʼ. Kutama e̱ʼta̱e̱ʼnayo yanʼtohuaʼ. Sorotataen siro to̱e̱hueʼ e̱e̱ʼnayo huaok yanʼbahuayaʼpo siro yadetiʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Konige̱po “Keʼna dakhueaʼ huakaʼeri o̱ʼe̱. Onʼbatiaʼpakapo.” Apagbaʼa oaʼ. Kenda Apagbaʼa oaʼnig doʼtaj aʼti menʼhuaaʼdeapone ijjay. Ayaʼda Apagbaʼte meʼnigbatiaʼpakuyatenig doʼtaj aʼti meʼnogkaʼapone. Paiʼda ijnopoʼe̱a̱poy. Aʼti ehueʼda i̱jje̱a̱poy. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","—‍In bottaʼ sorotataen siro o̱ʼe̱, Huairi. —‍Oʼnonaʼdenok. —‍Kenyoʼda ka̱e̱ʼ. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ken Jesús huakkaʼ jakyaʼ Jerusalénya̱ʼ oʼo̱ro̱konpo oteʼ Olivosyo oʼhuaʼikaʼpo oteʼ Olivosyon oʼhuaʼbeduyate. Kenere huanigpe̱i̱kaʼeriomeyere onʼhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ke̱yo̱ oʼtionaʼpakikaʼnigyo̱ jo̱kye̱depo, —‍Dakhueaʼ kahueʼ hua̱e̱ʼte yanʼtionaʼpak. Konig Diosa boʼtihuapokeʼpo dakhueaʼ kahueʼ hua̱e̱ʼte yanʼtionaʼpak. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ken Jesús meyo̱hueʼda oʼbakhuatoʼpo aʼtionaʼpakyaʼpo huikudate ohuadpo. ");
INSERT INTO amrNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","—‍“Paiʼda yanopoʼe̱po bueyhueʼdik ya̱e̱ʼti sion.” On eʼpaknayo menaʼ, Dios. Do konig ijpaknig kahueʼ ya̱e̱ʼ. Konig kenda on iʼpak megkaʼ, doʼhued pag. —‍Jesúsa oʼtionapakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ken kurudya̱ʼ Diosen huataʼmoneri oʼhuarakondepo Jesústaj ateypakayaʼpo oʼhuarakondeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Konige̱po cruzte ijbueyapoy diga̱ʼda oʼnopo̱e̱po nogi̱ti huakkaʼaʼda oʼtionaʼpakpo diga̱ʼda oʼukpakpo konig mimi eʼukpakhue̱ huakkaʼ barakte oʼsurukuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Ken oʼtionaʼpakonhuaʼdepo oʼbopo huanigpe̱i̱kaʼeriomeytaj oʼbahuahuaʼpo eʼtayte oʼbahuahuayʼuyate. Sueʼnanada o̱ʼnepo onʼbatayʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","—‍¿Menaʼpo boʼtaiʼ? Yanʼmaboʼ. Yanʼtionaʼpak. Onteʼti dakhueaʼ kahueʼ hua̱e̱ʼte yanʼtionaʼpak. —‍Jesúsa huanigpe̱i̱kaʼeritaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesús huanigpe̱i̱kaʼeritaj eʼmanbatiaʼpakonhuaʼte huakkaʼada onʼhuatiakdeʼuyate. Huakkuru Judasa oʼhuatiakpo. Keʼna Jesúsen doce huanigpe̱i̱kaʼeri nogtiaʼ o̱ʼu̱y. Judas huakkaʼ aratbut oʼbatotiakdepo Jesústaj aʼbuyukyaʼpo oʼhuahuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","—‍Do huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne. Doʼtaj inomey doʼhued takaʼtaj aʼyokyaʼpo doʼtaj oʼbuyukne. —‍Judastaj Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Huakkaʼ aratbut onʼhuatiakdepo Jesústaj onʼtohuaʼapo. Jesúsen huanigpe̱i̱kaʼeria onʼbatiahuayondepo, —‍¿Sorotataen siro menpaʼ oʼmagkaʼapo, Huairi? —‍Huanigpe̱i̱kaʼeriomeya̱ oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Nogtida huanigpe̱i̱kaʼeria sacerdoteen huanabaʼtaj huadaʼkopen huapesod oktegʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","—‍Kejeʼ kennigda yamagkaʼ. —‍Jesúsa oʼmanaʼpo, Ken huanabaʼen huapesod Jesúsa oʼtibataʼtepo oʼyareaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","53","—‍Konig huabereeritaj e̱gkapaʼ siroa hue̱ypaerea onʼhuatotiakbedne. Kaʼtiaʼpo kenpaʼ oʼnogkaʼ. Diosen jakyo opudomeyere nog huameʼnoe nog huameʼnoe nogok nogok i̱ji̱kaʼniga doʼtaj sigpiʼ opuda̱ tohuahueʼda o̱ʼnikameʼne. Oynayo sikyoda totoʼa moʼto̱e̱nok oʼnogkaʼbedne. —‍Sacerdote huairitaj Diosen jak huairitaj huatoneʼ huairitaj Jesúsa oʼmanaʼuyate. Kenomey Jesústaj aʼtohuayaʼpo onʼhuatiakbeduyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ken Jesústaj onʼto̱e̱po onʼtohuaʼbeduyate. Sacerdote huairitoneʼen jakyo onʼtohuaʼbeduyate. Pedroa taʼpote hueytemon oʼtahuaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Sacerdote huairitoneʼen jakyo oʼnokye̱ʼdepo jakkurunopote taʼak onʼbakpakaʼpo taʼakope huabirikaʼ onʼtibahuadpo Pedro ke̱yo̱ti kenomeyere oʼhuaduyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Pedro taʼakopete eʼhuadte huanabaʼ ettoneʼ oʼboatoʼpo Pedrotaj oʼtiahuaypo dakaʼda oʼtiahuaydepo, —‍In huabokerekkon Jesúsere o̱ʼi̱kaʼuyate. —‍Huanabaʼ ettoneʼa̱ oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","—‍Ehueʼ, ettoneʼ. Jesústaj jo̱ki̱a̱hueʼya i̱jje̱y, —‍Pedroa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Aʼtimon noga̱kon Pedrotaj oʼtiahuaydepo, —‍O̱ʼnakon Jesúsen huanigpe̱i̱kaʼeri i̱ʼe̱ne. —‍Onaʼuyate. —‍Ehueʼ, huabokerek, Jesúsen huanigpe̱i̱kaʼeri ehueʼ i̱jje̱y. —‍Pedroa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Aʼti noghoratida noga̱kon oʼmanaʼ, —‍In huabokerek Jesúsere o̱ʼi̱kaʼuyate, buttida ijjay. Konige̱po Galilea huadaribayo hua̱e̱ʼeri o̱ʼe̱. —‍Oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","—‍Ehueʼ, kaʼtiaʼ iaʼ nopo̱e̱hueʼ i̱jje̱y, huabokerek. —‍Pedroa onaʼuyate. Kenokaʼ kenpaʼ Pedroa eaʼte huatahuaa oʼsipogdeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jesúsa Pedrotaj oʼhuakorudpo oʼtiahuaynok, kenda Jesús Huairia onaʼ Pedro okkahuehueʼ o̱ʼe̱po huaboaʼda oʼnopo̱e̱. “Oyedda in sikyo huatahuaj sipoghued ‘Jesústaj jo̱ki̱a̱hueʼya i̱jje̱y,’ bapaʼaʼ iaʼapo, Pedro.” Huairia menameʼnig Pedro okkahuehueʼda huaboaʼda onteʼti oʼnoponʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Jak kuruyo oʼmako̱ro̱kdepo paiʼnada oʼhuikuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Huabokereka Jesústaj onʼto̱e̱po onʼtierikonhuaʼpo onʼbitbitonhuaʼpo ");
INSERT INTO amrNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","huakpotaj tela oʼnokpotidokaʼpo huakoktaʼ onʼpebasbasdepo, “Diosa mennopo̱e̱ʼ, ¿Beʼa ontaj boʼkokbasbas? oroʼtaj monaʼ.” Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ken nogda nogda dakhueaʼda Jesústaj onʼtidiʼkeunhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Emedeʼte judío aratbut huatoneʼ huairi o̱gkupopakpo, sacerdote huairiere o̱gkupopakpo kenpaʼti Moisésenbaʼ huamanmadikaʼeriere o̱gkupopakpo, Jesústaj onʼmanigtotiakdepo, ");
INSERT INTO amrNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—‍¿Menpaʼ Cristo i̱ʼe̱? ¿Menpaʼ Diosa metaʼmonaʼuy? Oroʼomeytaj kenda monaʼ. —‍Judío huairiomey o̱gkupopakpo Jesústaj oʼnonaʼuyate. —‍E̱e̱ʼ, doʼhua eʼmanaʼnayo, Cristo i̱jje̱y doʼhua eʼmanaʼnayo oknopo̱e̱hueʼ moʼe̱a̱pone. Da oaʼ moʼnopo̱e̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","“Do Cristo i̱jje̱y. Diosa meʼtaʼmonaʼuyne. ¿Kenda menpaʼ moʼnopo̱e̱?” Opudomeytaj eʼmanaʼnayo doʼtaj onteʼti aʼtokhueʼ o̱ʼneapone. Kenpaʼti “Yahuaʼ.” Onahueʼdik o̱ʼneapone. ");
INSERT INTO amrNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Do huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne. Aʼti Diosere ijhuadapoy. Dios teyda o̱ʼe̱po ayaʼda kaʼdik o̱ʼe̱nok Dioste huadaʼkopen konig Dios teyda i̱jje̱a̱poy. Ayaʼda kaʼdik i̱jje̱a̱poy. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","—‍¿Menpaʼ o̱ʼna Diosen Huasiʼpoda i̱ʼe̱? —‍Ayaʼada Jesústaj oʼnonaʼuyate. —‍E̱e̱ʼ, Diosen Huasiʼpo i̱jje̱y konig opuda̱da oʼnonaʼne, Diosen Huasiʼpo i̱jje̱y. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","—‍“Diosen Huasiʼpo i̱jje̱y.” Jesúsa oaʼnok oroada oʼpe̱e̱ne. Dakhueaʼda oaʼpo oʼkaʼ, oʼnopo̱e̱ne. Konige̱po castiga o̱gkaʼdik o̱ʼe̱a̱pone. “Jesús dakhueaʼ oaʼuy.” “Dakhueaʼ oʼkaʼuy.” Noga̱ enʼdapiʼ pe̱e̱hueʼdik o̱ʼe̱a̱pone. —‍Huatoneʼ huairiomeya̱ o̱daʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kenokaʼ ayaʼada judío huairi e̱gkupopakte onʼmaboddepo Jesústaj Pilato Romano gobierno huairite onʼtohuaʼuyate. Judío huairinayo Jesústaj arakhueʼdik o̱ʼnenok Romano huairiayoʼda yanʼarak aʼdik o̱ʼnenok. ");
INSERT INTO amrNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","A̱yo̱ Jesústaj Pilatotaj huaboaʼda namaʼda onʼhuaaʼpo, —‍Oroʼomeyen judío aratbuttaj in huabokerek namaʼda oʼmanmadikikaʼuy. Romano gobiernotaj yanʼmagkaʼ namaʼda oʼmanmadikikaʼ oroʼa oʼpe̱e̱ʼuy. Kenpaʼti Romano gobierno huairitaj huakupe bayokhueʼdik yanikaʼ. Namaʼda oʼmanmadikaʼ. Kenpaʼti “Cristo i̱jje̱y,” oaʼ. Cristo konig gobierno huairi huadik o̱ʼe̱. —‍Jesústaj Pilatotaj namaʼda onʼhuaaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","—‍¿Judío aratbuten gobierno huairi menpaʼ i̱ʼe̱? —‍Pilatoa Jesústaj onaʼuyate. —‍E̱e̱ʼ, konig o̱ʼna iaʼnig i̱jje̱y. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","—‍In huabokerek dakhueaʼ kahueʼ o̱ʼi̱kaʼ. Castiga o̱gkahueʼdik i̱jje̱y. —‍Pilatoa sacerdote huairitaj huakkaʼ aratbutomeytaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","—‍Romano gobierno huairi dakhueaʼda o̱ʼne. Yanʼmaen. Ken konig Jesúsa namaʼda oʼmanmadikikaʼ. Judío aratbut ayaʼtada namaʼda oʼmanmadikikaʼpo adyonda Galileayo huakkuruda namaʼda oʼmanmadikikaʼpo nogyo̱ nogyo̱ konigti oʼkikaʼpo taʼpotaʼ i̱yo̱kon konigti oʼkikaʼpo namaʼda oʼmanmadikikaʼ. —‍Kenpaʼ judío huairia i̱ghuaʼda onʼtihuaaʼpo Jesústaj, Pilatotaj namaʼda onʼtihuaaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Jesús Galileayo oʼmanmadikaʼuyate. Pilatoa oʼpe̱e̱depo “¿Galilea hua̱e̱ʼeri menpaʼ Jesús ya̱ʼe̱?” Oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","“E̱e̱ʼ, Galilea huadaribayo hua̱e̱ʼeri Jesús o̱ʼe̱.” Pilatotaj oʼnonaʼdeʼuyate. Kenda Pilato oʼpe̱e̱depo Jesústaj Herodeste oʼtaʼmonaʼpo, Herodes Galilea gobernador o̱ʼe̱nok kenpaʼti kenokaʼ Herodes Jerusalényo̱ o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodes nogok nogok Jesústaj oʼtipeeonhuahuaʼpo konige̱po Jesústaj eʼtiahuaytaʼ oʼpakpo Jesús katepiʼ ʼuruaʼda eʼkaʼ konig eʼbayareaʼte eʼtiahuaytaʼ oʼpakpo konige̱po Jesústaj eʼtiakte oʼtiahuaydepo Herodes huakkaʼ oʼdurugpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Nogi̱ti nogi̱ti enaʼtada Jesúsanayo aʼtokhueʼ o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ke̱yo̱ sacerdote huairi kenpaʼti Moisésenbaʼ huamanmadikaʼeri o̱ʼnepo Jesústaj i̱ghuaʼda onʼhuaaʼnok ");
INSERT INTO amrNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodes sorotataere Jesústaj aʼtierikyaʼpo ʼuruda huaok onʼotaʼpo konig gobiernoen huairien yudtaj onʼotaʼdepo onteʼti Pilatote oʼtaʼmonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Kenmeʼnoete Pilato Herodesere huaboaʼda huayahuaya diʼda onʼmaeʼuyate. Aʼnenda huayahuaya onʼbahuadiayʼikaʼuyate. Huaboaʼda diʼda onʼmaeʼuy. ");
INSERT INTO amrNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Sacerdote huairitaj aratbuten huairitaj kenpaʼti nog aratbuteretaj “Yanʼbatiak, doʼtaj menhuatiak.” Pilatoa oʼmanaʼpo e̱gkupopakdeʼte, ");
INSERT INTO amrNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","—‍In huabokerektaj opudomeya̱ onʼnigtotiakne. “In huabokerek namaʼda oʼmanmadikikaʼ. Romano gobiernotaj yanʼmagkaʼ namaʼda oʼmanmadikikaʼ.” Opudomeya̱ oʼnonaʼnigʼa opudomey onʼtiahuaypo Jesústaj ijbatiaʼpakdepo Jesúsa nogda nogda dakhueaʼ oʼkaʼ boʼhuaaʼnigʼa kenda namaʼda boʼhuaaʼnigʼa Jesúsnayo sigpiʼ dakhueaʼ kahueʼ o̱ʼi̱kaʼte. Ijnopo̱e̱y. ");
INSERT INTO amrNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes kenpaʼti Jesústaj oʼpe̱e̱depo dakhueaʼ kahueʼ o̱ʼi̱kaʼte. Herodesakon oʼnopo̱e̱po oroʼomeytaj onteʼti boʼtokumejne. Yanʼpe̱e̱ʼ. Jesúsa sigpiʼ dakhueaʼ kahueʼ o̱ʼi̱kaʼtenok Jesústaj yadarak. Ahueʼdik i̱jje̱y. ");
INSERT INTO amrNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Castiga yo̱gkaʼdepo yahuatiʼ yonaʼapoy. —‍Pilatoa judío huairiomeytaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Fiestate nogtida huabakuda̱ʼ jakyo hua̱e̱ʼeritaj jakyaʼ o̱ʼo̱ro̱kikaʼ konige̱po Pilato nogtatida o̱ro̱kaʼdik o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Onokteteyoʼ ayaʼada ʼuttaʼda oʼnokoypo, —‍Jesústaj yadarak. Barrabástanayo ya̱o̱ro̱kaʼ. —‍Onokteteyoʼ ayaʼada ʼuttaʼda oʼnokoyʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Jerusalényo̱ Barrabás huakkaʼda aratbut oʼbakupopakaʼdepo gobierno huairitaj aʼmabatiarakayaʼpo eʼbatoahuaʼtaʼ oʼpakuyatenigʼa. Kenpaʼti nogtatida oʼarakuyate. Konige̱po huabakuda̱ʼ jakyo o̱ʼe̱nok. ");
INSERT INTO amrNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Jesústaj Pilatoa eʼo̱ro̱kaʼtaʼ oʼpakpo, “Jesústaj eʼo̱ro̱kaʼtaʼ ijpaki.” Oʼmanaʼnigʼa. ");
INSERT INTO amrNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","—‍Hue̱ypa cruzte yadarak. Hue̱ypa cruzte yadarak. —‍Huakkaʼada judío aratbut eʼkupopakyaʼ ʼuttaʼda oʼnokoypo. Onteʼti onteʼti oʼnokoyʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","—‍I̱ʼna sigpiʼ dakhueaʼ kahueʼ o̱ʼi̱kaʼtenok kejeʼ arakhueʼdik i̱jje̱y. Konige̱po Jesústaj castiga yo̱gkaʼdepo Jesústaj ijjo̱ro̱kapoy. —‍Bapaʼaʼ Pilatoa oʼmanaʼnigʼa. ");
INSERT INTO amrNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","—‍Hue̱ypa cruzte Jesústaj yadarak. Hue̱ypa cruzte yadarak. —‍Huakkaʼada aratbuta o̱gkupopakpo sacerdote huairierea diga̱ʼda oʼnokoypo, nogok Pilato taʼpotaʼtaj eʼnokoyte oʼmanigpe̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","“Kenda onʼpaknok ijkaʼapoy.” Pilatoa oʼnopo̱e̱tupo, oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Pilato huakkaʼ aratbuttaj oʼmanigpe̱e̱po, Barrabástaj o̱ʼo̱ro̱kaʼuyate. Aʼnenda Barrabás huakkaʼ aratbuttaj oʼbakupopakaʼdepo gobierno huairitaj aʼmabatiarakayaʼpo eʼbahuatoahuaʼtaʼ oʼpakuyatenigʼa. Kenpaʼti Barrabása oʼarakuyate. “Barrabástaj ya̱o̱ro̱kaʼ.” Huakkaʼada oʼnokoynok o̱ʼo̱ro̱kaʼuyate. Ken judío aratbuta Jesústaj eʼaraktaʼ oneretpaknok, Jesústaj Pilato Romano sorotatataj kaʼdarakepo oʼbayokuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ken sorotataj Jesústaj onʼtohuaʼdepo Simóntaj onʼdejdepo, Simón Cirene huakkaʼ jak hua̱e̱ʼeri o̱ʼe̱po taʼbayaʼ eʼtiakdeʼte Simóntaj onʼto̱e̱po hue̱ypa cruz katohueʼpo sorotataa oʼnonaʼnok Jesúsen taʼpotaʼ Simóna cruz oʼtohuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Huakkaʼnanada aratbut onʼbatahuaʼpo kenpaʼti huakkaʼda ettoneʼ onʼbatahuaʼpo Jesústaj onʼtinepahuiʼpo diga̱ʼda onʼbahuikonhuaʼpo ʼuttaʼda onʼbahuikonhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jesúsa ettoneʼtaj oʼbatiahuaypo, —‍Dotaʼ huikhueʼ yaneʼ, Jerusalén ettoneʼ, huataʼda yanʼtohuik, opudomeyensiʼpotaʼ yanʼtohuik. ");
INSERT INTO amrNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Konige̱po opudtaʼtaj nogok keʼpoda dakhueaʼnada o̱ʼe̱a̱po. Aratbuta paiʼnanada onʼnopoʼe̱a̱po. “Ettoneʼ siʼpopakhueʼdik o̱ʼnepo durugda o̱ʼneapo, ettoneʼ bogdakhueʼ ehueʼdik o̱ʼnepo durugda o̱ʼneapo, ettoneʼ huasiʼpotaj huauʼte minonhueʼ o̱ʼnepo durugda o̱ʼneapo.” Nogok keʼponada e̱e̱ʼte kenda onʼbatiaʼpakapo. ");
INSERT INTO amrNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Kenokaʼ nogokda aratbut diga̱ʼda paiʼnada onʼnopoʼe̱a̱ponok eʼbueytaʼ onʼpakapo. “Oroʼomeytaj monbet,” huakupataj oʼnonaʼapo. “Pendaka boʼtiyurak,” oʼnonaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Donayo konig o̱hue̱yburanig i̱jje̱po huadakda e̱e̱ʼtada doʼtaj dakhueaʼda meʼnogkaʼne. Opudomeynayo dakhueaʼda moʼe̱po konig o̱hue̱y eʼayʼonig opudomeytaj nogi̱ti keʼpoda dakhueaʼnada onʼmagkaʼapo. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Kenpaʼti nog bottaʼtaj dakhueaʼ huakkaʼeritaj onʼbatohuaʼpo Jesústaere aʼarakyaʼpo onʼbatohuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Oteʼte oʼnokye̱depo Jesústaj hue̱ypa cruzte onʼbetaʼuyate. Kenpaʼti bottaʼ dakhueaʼ huakkaʼeriere hue̱ypa cruzte onʼmabetaʼuyate. Jesúsen huadaʼkopen nogtaj onʼbetaʼpo nogtaj Jesúsen opeʼtopen onʼbetaʼuyate. Oteʼ huadik o̱ʼe̱ La Calavera. ");
INSERT INTO amrNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesústaj enʼbetaʼdete, —‍Dakhueaʼ eʼkaʼ yabakkahueaʼ, Pag. Kenda menogkaʼne nopo̱e̱hueʼ o̱ʼnepo. —‍Jesúsa onaʼuyate. Ken sorotataj Jesúsen yudtaj beʼati yaʼdeyapet aʼnopo̱e̱yaʼpo huid okmo o̱ʼneneʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Huakkaʼda aratbut o̱ʼnepo Jesústaj onʼtiahuayaʼpo judío huairiomeya̱kon Jesústaj onʼtierikpo, —‍Jesús nogomeytaj oʼbatihuapokikameʼte. Ken Diosen Cristo e̱e̱ʼnayo Diosa ektieʼeaʼ e̱e̱ʼnayo huataʼ katihuapokeʼ. —‍Judío huairiomeya̱ Jesústaj dakhueaʼda onʼtierikpo onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sorotataa kenpaʼti Jesústaj onʼtierikpo, Jesústaj onʼhuahuaʼpo, vino paiʼ kamaye̱ʼpo onʼyokuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","—‍On judíoen gobierno Huairi e̱e̱ʼnayo huataʼ yatihuapokpo hue̱ypa cruzyaʼ yahuarak. —‍Sorotataa Jesústaj onʼtierikpo oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Jesúsen huaku kutapen huaensiʼpote bapaʼen huaʼate onʼmadoyaʼuyate, griego huaʼa, latin huaʼa, hebreo huaʼa onʼmadoyaʼpo “In judío aratbuten gobierno Huairi o̱ʼe̱.” Onʼmadoyaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Bottaʼ dakhueaʼ huakaʼeri cruzte onʼbetonhuaʼpo Jesústaj nogtiada oʼtierikpo, —‍O̱ʼna Cristo e̱e̱ʼnayo Diosa eʼtaʼmonaʼuynayo huataʼda cruzyaʼ yahuarak kenpaʼti oroʼomeytaj boʼtihuapokpo bohuarakaʼ. —‍Nogtiada dakhueaʼ huakaʼeria Jesústaj namaʼda onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","—‍Dakhueaʼ iaʼ. Menpaʼ Diostaj okmeʼpakhueʼada iaʼne. Jesús paiʼda oʼnopoʼe̱ konigti paiʼda iʼnopoʼe̱ne castiga ontaj mogkaʼne. ");
INSERT INTO amrNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Oroʼomeynayo dakhueaʼda oʼkikaʼnok oroʼomeytanayo castiga mogkaʼne. Inbokereknayo sigpiʼ dakhueaʼ kahueʼ o̱ʼi̱kaʼ. —‍Noga̱ dakhueaʼ huakaʼeria huakkuru huaaʼeritaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","—‍Nogok Dios Huairi on i̱ʼe̱depo doʼtaj okkahuehueʼ ya̱e̱po doʼtaj metinepahuitiʼ, Jesús. —‍Jesústaj huatodiayeria onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","—‍Oy doere paraísoyo i̱ʼe̱a̱pone. Paraísoyo durugda i̱ʼeonhuahuikaʼapone. Buttida ijjay. —‍Huatodiayeritaj Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Niokpo tokhuada̱ʼ ekpohuadte huadari huabada oʼtaʼsikonʼuyate. Sikki̱re̱gda o̱ʼu̱yate. Huaduknopoyo eʼhuadte onteʼti niokpo oʼtieyhuaduyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Niokpo jey e̱e̱ʼ eʼbatikonte sikki̱re̱gda e̱e̱ʼte Diosen jakyo huahuakda cuperina eretnopoyo eʼoroyaʼda huanopotaʼda oʼhuisonʼuyate. Kenokaʼ, ");
INSERT INTO amrNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","—‍Ontaj Apag Dios doʼhued noki̱re̱g oʼyokne, Pag. —‍Jesúsa ʼuttaʼda onaʼuyate. Kenpaʼ oaʼdepo oʼbueyonʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Capitán sorotataj Romano o̱ʼe̱po sorotataj huairi o̱ʼe̱po kenokaʼ kenda ayaʼda oʼtiahuaydepo, “Apag Dios ʼuruda o̱ʼe̱. Huadaknanada o̱ʼe̱,” oʼbatiaʼpakpo, —‍In huabokerek dakhueaʼ kahueʼ o̱ʼi̱kaʼte, buttida ijjay. —‍Capitán sorotataa oaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ayaʼda aratbut kente o̱ʼnepo onʼtiahuaydepo oʼnokbahuaʼpo suhueʼnanada o̱ʼnepo oʼnokbahuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Nogomeynayo Jesústaj hua̱ki̱e̱ʼeri o̱ʼnepo huahueʼ o̱ʼneʼuyate. Ettoneʼere o̱ʼnepo ettoneʼ Galileayaʼ Jesústaj huatahuaʼeri o̱ʼnepo huahuedda o̱ʼnepo sueʼda bidte onʼkupobopo Jesústaj eʼdarakte onʼbatiahuayaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ken huabokerek o̱ʼe̱po keʼnen huadik o̱ʼe̱ José. José huadakda o̱ʼe̱po Diosenbaʼ dakaʼ oʼnigpe̱i̱kaʼuyate. Judea huadaribayo hua̱e̱ʼeri o̱ʼe̱po huakkaʼ jak Arimateayo oʼsiʼpoe̱po oʼkerekuyate. Keʼna judío huairiere onʼkupopakikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","José Dios Huairitaj eʼmaboʼ oʼnigi̱kuyate. Kenda judío huairiomey Jesústaj oʼnogkaʼdenig kenda pakhueʼ o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ken José Pilatotaj oʼhuahuaʼpo, “Jesúsbuey beyok.” Onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","“E̱e̱ʼ, yatohuatiʼ,” Pilatoa eʼnadeʼte Jesúsbueytaj oʼhuarakaʼdepo oʼbueyto̱e̱po Jesúsbueytaj oʼtihui̱yi̱gpo ʼuruada telaa konig sábana oʼtihui̱yi̱gdepo sipanaʼ huidkogyo̱ huabokogyoda oʼbueyhueda̱ʼuyate. Ken kubarak huabokogda o̱ʼe̱po ke̱yo̱ nogtaj kubarakkahuedda o̱ʼe̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ken huameʼnoe konig eʼmanhuada̱ʼ huameʼnoe o̱ʼe̱nok aʼti huaboaʼda okmapi̱e̱ʼahuaddik huameʼnoe o̱ʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Kenomey ettoneʼ huaboaʼda Jesúsere Galileayaʼ onʼtiakmeʼte kente Jesúsbueyte onʼhuahuaʼpo kubaraktaj onʼtiahuaypo kenpaʼti konig keʼnenbuey eʼhuedte onʼtiahuayonʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ettoneʼ jakyo o̱gkumejdepo ʼuruʼhui̱e̱da hue̱ʼe̱y eʼkaʼdeada okmapi̱e̱ʼahuaddik huameʼnoete kahueʼ o̱ʼnuyate. Konig Moisés eʼmanaʼ oaʼuyatenok kenomey onʼnigpe̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Judío aratbuten okmapi̱e̱ʼahuaddik huameʼnoe eʼpokondeʼte domingo emedeʼte sikyoednada kubarakyo ettoneʼ onʼhuaʼpo ʼuruʼhui̱e̱da hue̱ʼe̱y adikken eʼkaʼdeʼ onʼte̱nok onʼtohuaʼpo, nog ettoneʼere onʼhuahuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ettoneʼ kubarakyo oʼnokye̱depo huaboroʼ huid huanokbet kubaraktaj oʼnonokbetameʼte onokbethueʼkon onʼhuahuayʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Onʼkudondenigʼa Huairi Jesúsbueytaj huahuayhueʼ o̱ʼnuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Kenpihuay, Jesúsbuey huedhueʼ o̱ʼe̱ menpapiʼ ya̱ʼe̱a̱te enʼnopo̱e̱ʼte. I̱da bottaʼ huabokerek onʼtibopo meyo̱hueʼda onʼtibopo yudtaj senogda eʼot o̱ʼnuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Huabokerektaj onʼbatiahuaydepo diga̱ʼda onʼmeʼpukpo sorokyon onʼkuboyonʼuyate. —‍Kubarakyo kente aratbutbueyyoʼda o̱ʼnikaʼnigʼa katiaʼpo huabokerektaj oʼnoedenigʼa boʼuk. ");
INSERT INTO amrNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","7","Jesús i̱yo̱da ehueʼ o̱ʼe̱. Diosa oʼnoyhuadande. Jesús Galileayo o̱ʼe̱po “Do huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne. Doʼtaj dakhueaʼ huakaʼeritaj beyokapone. Dakhueaʼ huakaʼeriomey menʼtohuaʼapone. Hue̱ypa cruzte doʼtaj menʼarakapone. Bapaaʼ huameʼnoe kubarakyo i̱jje̱depo aʼti ijnoyhuadapoy.” Jesúsa monaʼuyne, okkahuehueʼ moʼe̱t. —‍Bottaʼa Diosen huataʼmoneria ettoneʼtaj onʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ken, kenda Jesúsa oʼmanaʼuyate ettoneʼ huaboaʼda onteʼti onʼnopo̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ken kubarakyaʼ onʼkumejdepo ayaʼda onʼtiahuaydepo onʼpe̱e̱denig onʼmanbatiaʼpakuyate. Once huamataʼmonaʼeritaj kenpaʼti ayaʼtada nogomeytaj ayaʼda onʼmanbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","María Magdalena, Juana, María Jacoboen hua̱ye̱, nog ettoneʼere once huamataʼmonaʼeritaj ayaʼda eʼmanbatiaʼpakatoʼtada ");
INSERT INTO amrNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","namaʼda monaʼne once huataʼmonaʼeria onʼnopo̱e̱po butti oʼdaʼ maknopo̱e̱hueʼ o̱ʼneʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pedronayo o̱ʼo̱ro̱kondepo oʼketonhuaʼpo kubarakyo oʼketonhuaʼpo o̱kye̱depo kubarakyo oʼtiahuayatoʼpo ʼuru tela konig sábana adkorepen eʼhued oʼtiahuayondepo onteʼti jakyo oʼhuaʼpo, “Kenpihuay, kate yakaʼ Diosa,” oʼnoponpo oʼhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Kenmeʼnoete bottaʼ Jesúsen huanigpe̱i̱kaʼeri Emaús huakkaʼ jakyo onʼhuaʼpo, Jerusalénya̱ʼ Emaús sueʼda bidte o̱ʼe̱. Once kilómetros o̱ʼu̱y. ");
INSERT INTO amrNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Huahuaʼaʼ onʼbatiaʼpakonhuaʼpo ayaʼda huaboaʼda onʼtiahuaymeʼnig ayaʼda onʼpe̱e̱meʼnig ayaʼda Jesústaj oʼnogkameʼnig ayaʼda onʼbatiaʼpakonhuaʼpo, ");
INSERT INTO amrNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","eʼbatiaʼpakdeʼte Jesúsa oʼbataʼdeaʼpo kenokaʼ kenomeyere onʼhuaʼepo. ");
INSERT INTO amrNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Jesústaj onʼtiahuaynigʼa ken Jesús o̱ʼe̱ nopo̱e̱hueʼ o̱ʼneʼuy. Kenpaʼ Diosa oʼpaknok o̱ki̱e̱hueʼdik o̱ʼneʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Bottaʼ huanigpe̱i̱kaʼeritaj —‍¿Huahuaʼaʼ kateʼtaj moʼbatiaʼpakonyak? ¿Menaʼpo sueʼ moʼe̱? —‍Jesúsa oʼmanaʼnok, ");
INSERT INTO amrNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","—‍Kenda huaboaʼda Jesústaj oʼnogkameʼ Jerusalényo̱ huaboaʼda oʼnogkameʼ ayaʼada aratbut onʼnopo̱e̱. O̱ʼna Jerusalényo̱ i̱ʼi̱kaʼnigʼa menpaʼ onyoʼda nopo̱e̱hueʼ i̱ʼe̱. —‍Nogtiada Jesústaj onaʼuyate. Keʼnen huadik Cleofas o̱ʼu̱y. ");
INSERT INTO amrNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","—‍¿Kate ya̱gkameʼ? —‍Jesúsa oʼmanaʼuyate. —‍Kenda Jesús Nazareteritaj oʼnogkameʼ. Jesús Diosen huamanbatiaʼpakeri o̱ʼe̱po huakkaʼtada oʼbayareaʼuy kenpaʼti i̱ghuaʼda oaʼikaʼuy. Kenda Diosa dakaʼda oʼnopo̱e̱. Konigti ayaʼ aratbutere Jesúsa huadakda oʼkikaʼ onʼnopo̱e̱nigʼa ");
INSERT INTO amrNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","oroʼomeyen sacerdote huairia kenpaʼti judío huairia Romano gobierno huairitaj onʼyokmeʼ. Hue̱ypa cruzte kanʼarakeʼpo onʼyokmeʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Jesúsa Romano gobierno huairitaj yaʼmaenapetpiʼ. Romano sorotatataj yaʼmaenapetpiʼ. Oroʼomeyen Israel aratbuttaj oʼbatihuapokapo oroʼomeya̱ oʼnopo̱e̱nigʼa. Jesús oʼbueymeʼnig bapaʼ huameʼnoe oʼtipokde. ");
INSERT INTO amrNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kenpaʼti oroʼomeyere sueʼda ettoneʼ oroʼtaj onʼmameʼpukeʼpo konige̱po sikyoedda kubarakyo onʼhuaʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Jesúsenbuey huahuayhueʼ o̱ʼnepo onʼkumejdepo “Diosen huataʼmoneritaj oʼtiahuay. Jesús oʼnoe, monaʼne.” Ettoneʼa̱ onʼbatiaʼpak. ");
INSERT INTO amrNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Aʼtimon nogomey oroʼomeyere o̱ʼnikaʼpo onʼhuaʼ, kubarakyo onʼhuaʼ. Konigti ettoneʼa̱ onʼbatiaʼpak onʼhuahuaynigʼa Jesústaj tiahuayhueʼ o̱ʼneate. —‍Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","—‍Nopoenkahueʼda moʼe̱. Ijhueʼtaʼda moknopo̱e̱. Ayaʼda Diosen huamanbatiaʼpakeria eʼmanaʼuytada ijhueʼtaʼda moknopo̱e̱. ");
INSERT INTO amrNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Cristo ʼuruda o̱ʼe̱. ʼUruaʼda oʼkikaʼuy. Ayaʼada onʼbatiaʼpakapo. Huakkuruda Cristo paiʼda nopoʼe̱ʼdik o̱ʼe̱. —‍Jesúsa bottaʼtaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Moisésenbaʼ Cristotaj oʼbatiaʼpak, konig Cristo o̱ʼe̱a̱po kenpaʼti kenda Cristo oʼkaʼapo oʼbatiaʼpakpo kenpaʼti Diosen huamanbatiaʼpakeri Cristotaj oʼbatiaʼpaknok Jesúsa huakkuru Moisésenbaʼ Cristotaj eʼbatiaʼpakte oʼmanopo̱e̱a̱ʼpo. Kenpaʼti Cristotaj eʼbatiaʼpakte Diosen huamanbatiaʼpakeriomey onaʼuyate Jesúsa oʼmanopo̱e̱a̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Emaús huakkaʼ jakyo onhuaʼpo oʼnokye̱depo, Jesús yapokonapetdapiʼ oʼhuaʼnig. ");
INSERT INTO amrNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","—‍Kejeʼ huahueʼ ya̱e̱ʼ. Oroʼen jakyo yaksik. Osikde. Sikki̱re̱ga̱ʼ o̱ʼe̱de. —‍Jesústaj dakaʼda oʼnonaʼpo. Ken Jesús ke̱yo̱ jaksikyaʼpo oʼkoreʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Kutopate bottaʼtaj Jesús onteteyoʼ oʼbataʼhuaddepo pan oʼbapadpo “Dakiti, Dios,” oaʼdepo oʼposakeaʼdepo oʼbayokeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Huaboaʼda Jesústaj oʼnoki̱e̱ʼde. Jesús o̱ʼe̱ onʼnopoendenok onteʼti Jesústaj tiahuayhueʼdik o̱ʼnuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","—‍Dagte eʼtiakte Jesúsere eʼtiakte Jesús Apagbaʼtaj moʼnopoenkaʼdepo oroʼennopoʼ diga̱ʼ oʼnopoʼdurugpak. —‍Huayahuaya onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ken ijhuiti ehueʼ jakyaʼ oʼnoro̱konpo Jerusalényo̱ onʼkumejpo Jerusalényo̱ once huanigpe̱i̱kaʼeri nogomeyere onteteyoʼ onʼbahuahuayatoʼpo, ");
INSERT INTO amrNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","—‍Jesús Huairi oʼnoyhuadate, buttida oʼay. Simónakon Huairitaj oʼtiahuayate. —‍Bottaʼa onʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Konig dagte onʼhuaʼpo Jesúsere onʼbatiaʼpakpo kenpaʼti konig jakyo kutopataʼ pan eʼposakeaʼte Jesústaj huaboaʼda oʼnoki̱e̱ʼpo, kenda onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kenda bottaʼa enʼbatiaʼpakte Jesús huaboaʼda oʼmanokyondepo kenomeyere onteteyoʼ oʼbatobopo, —‍Yanʼmanopoʼnoeyʼ. Mameʼpukhueʼ yaneʼ. —‍Jesúsa oʼbopo oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ken huakkaʼnada onʼmeʼpukpo oʼmididpo noki̱re̱gtaj oʼtiahuay namaʼda onʼnopo̱e̱nok. ");
INSERT INTO amrNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","—‍Meʼpukhueʼ yaneʼ. Do Jesús i̱jje̱y opuden huanopoyaʼ dakaʼ menoknopo̱e̱ʼ. ");
INSERT INTO amrNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Doʼhued huabaʼtaj dakaʼ menʼtiahuayʼ. Doʼhued huaʼitakon menʼtiahuayʼ. Jesúsda do i̱jje̱y. Doʼtaj menʼso̱ʼto̱e̱a̱ʼ. Kenpaʼti doʼtaj menʼtiahuayʼ. Noki̱re̱gnayo huaen huaayʼ to̱e̱hueʼ o̱ʼnikaʼ. Donayo huaen huaayʼ ijto̱e̱y konigda doʼtaj onʼtiahuay. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Kenda Jesúsa oʼmanaʼdepo keʼnen huabaʼ oʼbatiahuayʼeaʼpo keʼnen huaʼi oʼbatiahuayʼeaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Onʼdurugpakpo kenpaʼti onʼmeʼpukeʼpo oknopo̱e̱hued o̱ʼnenok. —‍¿Aypo menpaʼ ya̱ʼe̱? —‍Jesúsa huanigpe̱i̱kaʼeritaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ken biig eʼtiayaʼ onʼyokpo aiʼmoro̱ʼhue̱kon onʼyoknok ");
INSERT INTO amrNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jesús oʼto̱e̱po oʼbapeʼuyate. Huanigpe̱i̱kaʼeriomey Jesústaj eʼbapeʼte onʼtiahuayaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","—‍Eʼmanaʼ berobaʼte Apagbaʼte ayaʼ Moisés doʼtaj beʼtimadoyaʼuyate. Ayaʼda huamanbatiaʼpakeria doʼtaj mentimadoyaʼuyate. David salmos Apagbaʼte doʼtaj beʼtimadoyaʼuyate. Kenda kaʼdik i̱ji̱kaʼpo ijkikaʼuy. Kenda o̱gkaʼdik meʼnepo meʼnogkaʼuyne. Bueyhued opudomeyere i̱ji̱kaʼuy. Kenda menogkaʼapone opudomeytaj dakaʼ oʼnonaʼikaʼuyne. —‍Jesúsa huanigpe̱i̱kaʼeriomeytaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kenokaʼ oʼmanopoenkaʼpo kenda Apagbaʼte Jesústaj onʼtimadoyaʼuyate Jesúsa huanigpe̱i̱kaʼeriomeytaj oʼmanopoenkaʼpo, ");
INSERT INTO amrNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","—‍Apagbaʼte onʼtimadoyaʼpo, Cristo bueydik o̱ʼe̱a̱po. Bapaʼaʼ huameʼnoete noyhuaddik o̱ʼe̱a̱po. Kubarakyaʼ noyhuaddik o̱ʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Huakkuru Jerusalén aratbuttaj huadak huaʼa manbatiaʼpakdik yanikatiʼ. Nogok ayaʼtada aratbuttaj ayaʼ huadaribayo huadak huaʼa manbatiaʼpakonhuahuaʼdik yanikaʼ. Diosa bekkahueʼpo manopoʼkoreaʼdik yaneʼ. Manaʼdik moʼe̱a̱pone. Apagbaʼte kenpaʼ onʼtimadoyaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Opudomey ayaʼda boʼtiahuayikameʼne. Kenda ayaʼtada moʼmanbatiaʼpakapone. ");
INSERT INTO amrNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","E̱ya̱ʼ. Konig Apag Diosa oʼmanaʼuyate, opudomeytaj Diosen Noki̱re̱g doʼhua oʼnigtaʼmonaʼapone. Diosen Noki̱re̱g tiakhued oy Jerusalényo̱ yanʼnigi̱kaʼ. Diosen Nokire̱gtaj yanʼnigi̱katiʼ. Diosen Noki̱re̱ga̱ opudomeytaj eʼnopoʼto̱e̱deʼte konig Diosyaʼ teyda moʼe̱deapet. Dakaʼ manbatiaʼpakikaʼdik moʼi̱kaʼapone. —‍Jesúsa huanigpe̱i̱kaʼeriomeytaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ken Jerusalénya̱ʼ o̱ʼo̱ro̱konpo Betaniayo oʼbatohuaʼpo huanigpe̱i̱kaʼeriomeytaj oʼbatohuaʼuyate. Oʼbaʼtepo, “Doʼhued huanigpe̱i̱kaʼeriomeytaj ʼuruaʼda yamato̱e̱ʼ, Apag Dios.” Oʼtionaʼpakondepo, ");
INSERT INTO amrNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","kurudyo̱ Diosa oʼbaktobehuikuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Jesús huadaknanada o̱ʼe̱. ʼUruaʼda oʼkikaʼ. Diosen Huasiʼpo o̱ʼe̱. Onʼbatiaʼpakdepo durugnanada Jerusalényo̱ onʼkumeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Diosen jakyo o̱ʼnikaʼpo Dios ʼuruaʼda o̱ʼe̱. Dios huadakda o̱ʼe̱. Onʼbatiaʼpakikaʼuyate, ken.");
INSERT INTO amrNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Aʼnennanada huakkuruda katepiʼ ehueʼ o̱ʼu̱yate. Cristo Diosen huaʼa huamanaʼeri o̱ʼi̱kaʼuyate. Cristo Diosda o̱ʼi̱kaʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Aʼnennada huakkuruda katepiʼ ehueʼ o̱ʼu̱yate, Cristo Diosen huaʼa huamanaʼeri o̱ʼi̱kaʼuyate. Diosere o̱ʼi̱kaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Cristoa ayaʼtada oʼtiahuayikaʼnig oʼkaʼuyate. Konig Diosa oʼpaknok ayaʼtada oʼkaʼuyate. Noga̱ sigpiʼ kahueʼ o̱ʼu̱yate. Cristoayoʼda ayaʼtada oʼkaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Cristo Diosen huaʼa oʼnoikaʼpo huamanoeaʼeri o̱ʼi̱kaʼuyate. Cristokon konig Diosen Huakjey o̱ʼe̱. Huakjey oʼtaʼtepo katetapiʼ tiahuaydik o̱ʼe̱ne, katetapiʼ nopo̱e̱ʼdik o̱ʼe̱ne. Konigti Cristo konig Diosen huakjey o̱ʼe̱po Diostaj moknopo̱e̱a̱ʼne kenpaʼti Diosen buttida huaʼataj moknopo̱e̱a̱ʼne. Katepiʼ huadak Diosa oʼpak moʼnopo̱e̱a̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","In huadariyo aratbut Diostaj pakhueʼ o̱ʼnikaʼ. Dakhueaʼ o̱gkikaʼ. Konig sikki̱re̱gyo̱ o̱ʼnepo Diostaj oknopo̱e̱hueʼ o̱ʼnikaʼ kenpaʼti Diostaj pakhueʼ o̱ʼnikaʼ. Cristo Diosen Huakjey in huadari aratbuttaj oʼtaʼtepo Diostaj moknopo̱e̱a̱ʼne. Diosen buttida huaʼataj moknopo̱e̱a̱ʼne. Katepiʼ huadak Diosa oʼpak moʼnopo̱e̱a̱ʼne. Huakkaʼda Cristotaj eknopo̱e̱ʼtaʼ pakhueʼ o̱ʼnepo kenpaʼda e̱ʼentaʼ onʼpaknigʼa enhueʼdik o̱ʼnuyate. Cristo konig Diosen Huakjey ʼuruaʼda oʼbataʼteonhuahuikaʼpo oʼmaknopoeanhuahuikaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Diosa aratbuttaj Juan Bautistataj oʼmataʼmonaʼuyate. Cristotaj kamanbatiaʼpakikeʼpo Juantaj oʼmataʼmonaʼuyate. Aratbuta Cristotaj kanoknopo̱e̱ʼpo Juana Cristotaj oʼmanbatiaʼpakuyate. Diosen Huakjeytaj oʼmanbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Juan Diosen Huakjey ehueʼ o̱ʼu̱yate. Cristonayo Huakjey o̱ʼu̱yate. Cristotaj kamanbatiaʼpakeʼpo Juantaj oʼmataʼmonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ken Juana Cristotaj oʼmanbatiaʼpakonhuahuaʼdepo indariyo hua̱e̱ʼeriomeytaj Diosen Huakjeytaj oʼmanoki̱a̱ʼuyate. Cristo Diosen hueretda Huakjeytaj aʼmaknopo̱e̱a̱yaʼpo oʼbahuatiakdepo, Juana oʼmanbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Cristo ayaʼ huadari oʼkaʼuyate. Huadariyo o̱ʼi̱kaʼnigʼa huadari hua̱e̱ʼeria oknopo̱e̱hueʼ o̱ʼnuyate. Huadari huakaʼeritaj oknopo̱e̱hueʼ o̱ʼnuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Diosyaʼ oʼtiakdepo keʼnen judío aratbutere oʼnoikaʼuynigʼa Jesucristotaj eʼnigpe̱e̱taʼ pakhueʼ o̱ʼnuyate. Aʼnenda Diosa judío aratbuten adhueaʼpaneʼtaj oʼbaktieʼeaʼuyatenigʼa Cristo Diosen huaʼataj eknopo̱e̱ʼtaʼ pakhueʼ o̱ʼnuyate. Judío aratbuta eknopo̱e̱ʼtaʼ pakhueʼ o̱ʼnuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Sueʼada Jesucristotaj eʼnigpe̱i̱kaʼtaʼ onʼpakpo oʼnoknopo̱e̱ʼuyate. Oʼnoknopo̱e̱po Diosen onʼsiʼpoe̱po Diosensiʼpo o̱ʼneʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Kenaʼpo ettoneʼyaʼ onʼsiʼpopakmeʼtenok Diosensiʼpo ehueʼ o̱ʼne. Kenaʼpo ettoneʼpiʼ huabokerekpiʼ eʼsiʼpopaktaʼ onʼpakikaʼnok Diosensiʼpo ehueʼ o̱ʼne. Diosen Cristotaj oʼnoknopo̱e̱po Diosen onʼsiʼpoe̱po Diosensiʼpo o̱ʼnuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ken Diosen huaʼa huamanaʼeri Jesucristo Diosere o̱ʼunhuahuikaʼdepo nogok Diosa oʼpakpo oʼsiʼpoe̱ʼuyate. Oroʼomeyere o̱ʼi̱kaʼuy. Jesucristo kenyoʼda huadaknanada oʼkikaʼuy. Huakkaʼnanada diʼ oʼmaikaʼuy. Huakkaʼnanada oʼmatinepahuikaʼpo buttida oaʼikaʼuy. Diosonig ʼuruaʼnanada oʼkikaʼnok konigti Dios o̱ʼe̱po Diosyaʼ oʼtiakpo Diosen Huasiʼpo o̱ʼe̱ oʼnopo̱e̱ne. ");
INSERT INTO amrNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","—‍Aʼti Cristoa oʼtiakde. Keʼna oroʼen huairi o̱ʼe̱. Do huairi ehueʼ i̱jje̱y. Do siʼpopakhued i̱jje̱po, Jesús Diosere o̱ʼu̱yate. Ikkenda kentaj ijmanbatiaʼpakmey. —‍Juana oʼmanbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Jesucristo huakkaʼda diʼ moʼe̱ne. Oroʼtaj nogda nogda dakaʼ moʼmatinoeaʼne. ");
INSERT INTO amrNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Aʼnennada Diosen huaʼa Moisésa moʼnigmadoyaʼuyate. Jesucristonayo diʼnanada boʼhuatiakpo moʼmatinepahuiʼpo, oroʼomeytaj dakhueaʼ eʼkaʼ aʼmanopoʼyareayaʼpo boʼhuatiakuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Beʼapiʼ aratbuta Diostaj tiahuayhueʼ o̱ʼnikaʼuyate. Cristonayo Diosensiʼpo o̱ʼe̱po diʼ oʼmaunhuahuikaʼpo Diosere o̱ʼunhuahuikaʼpo konig Dios o̱ʼe̱ ʼuruaʼnanada oʼnopo̱e̱po oroʼomeytaj ʼuruaʼnanada moknopo̱e̱a̱ʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Judío aratbut huairi Jerusalén huakkaʼ jakyo o̱ʼnuyate. Juante onʼmataʼmonaʼuyate. Sacerdote Diostaj huanigtionaʼpakeritaj onʼmataʼmonaʼuyate. Kenpaʼti levita aratbuttaj Juante onʼmataʼmonaʼuyate. Onʼhuatiakdepo, —‍Nogbokerektida ijtaʼmonaʼapoy. Cristo ijtaʼmonaʼapoy. Diosa oʼmanaʼuyate. ¿Menpaʼ Cristoda i̱ʼe̱? Kenda monaʼ. —‍Juantaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","—‍Ehueʼ, Cristo ehueʼ i̱jje̱y. Diosa Cristotaj oʼtaʼmonaʼapo. Oroʼtaj kabatihuapokeʼpo oʼtaʼmonaʼapo. —‍Juana buttida oʼmanaʼuy. Dahueʼda oaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","—‍¿Beʼa i̱ʼe̱? ¿Elíaskudak Diosen huamanbatiaʼpakeri menpaʼ i̱ʼe̱? —‍Oʼnonaʼuyate. —‍Elíaskudak ehueʼ i̱jje̱y. —‍Juana oʼmanaʼuyate. —‍¿Diosen huamanbatiaʼpakeritaj oʼmaboy, menpaʼ Diosen huamanbatiaʼpakeri i̱ʼe̱? —‍Oʼnonaʼpo, —‍Ehueʼ i̱jje̱y. —‍Juana oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","—‍Judío huairi oroʼtaj boʼtaʼmonaʼne kenomeytaj batiaʼpakdik o̱ʼe̱nok, “¿Beʼa i̱ʼe̱?” “¿Kenda kamanbatiaʼpakikeʼpo beʼa metaʼmonuy?” —‍Sacerdoteomeya̱ onteʼti Juantaj oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","—‍Aratbut ehueʼ e̱ʼi̱kaʼyo nogtiaʼda ʼuttaʼda ijmanay, Dios Huairi oʼtiakde, yanʼnopoʼkoreaʼ. Keʼna oʼtiakdepo kentaj aʼnigpe̱e̱yaʼpo, yanʼnopoʼkoreaʼ. Aknopo̱e̱yaʼpo yanʼnopoʼkoreaʼ. Ijmanaʼikaʼpo. Konig Isaíaskudak Apag Diosen huaʼa huamanbatiaʼpakeria oaʼuyate. —‍Juana oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Kenomeya̱ Juantaj onʼhuatiakpo, fariseo aratbut huairia onʼtaʼmonaʼuyatenok. ");
INSERT INTO amrNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","—‍¿O̱ʼna Cristo ehueʼ e̱e̱ʼnayo, Elíaskudak ehueʼ e̱e̱ʼnayo, Apag Diosen huaʼa huamanbatiaʼpakeri ehueʼ e̱e̱ʼnayo, menaʼpo bautiza imagkikaʼ? —‍Fariseoa Juantaj oʼnonaʼuyate. (Diosa Juantaj oʼmataʼmonaʼuyate. Kenda fariseo huairiomeya̱ oknopo̱e̱hueʼ o̱ʼnikaʼ.) ");
INSERT INTO amrNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","—‍Do hue̱ʼe̱ya̱ bautiza ijkikay. Nogtida huabokerek opudenbayo o̱ʼe̱de, Cristo o̱ʼe̱de. Kentaj o̱ki̱a̱hueʼ moʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Diosa oʼtaʼmonaʼnok aʼti Cristoa Diosen huaʼa oʼmanmadikaʼapo. Keʼna huadakda o̱ʼe̱nok keʼnen huanabaʼ ehueʼdik i̱jje̱y, ijnopo̱e̱y. —‍Juana oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Juan bautiza oʼkaʼpo, Betábara huakkaʼ jakyo kenpaʼ onʼbatiaʼpakuyate. Betábara jak Jordánhue̱ akodpen o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Emeʼte Jesús Juantaj oʼhuahuaʼnok Jesús eʼtiakte Juana oʼtiahuaydepo, oʼmanaʼpakpo, —‍Ken huabokerek konig Apag Diosen Ovejasiʼponig o̱ʼe̱. Konig aratbuten dakhueaʼ eʼkaʼ kabakkahueʼpo oveja ʼuhuataj onʼnigarakikaʼ konigti aratbuten dakhueaʼ eʼkaʼ aʼbakkahueayaʼpo Jesús konig ovejasiʼpo ʼuhua oʼmanigbueyapo. ");
INSERT INTO amrNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Kentaj ijbatiaʼpakmey, “Jesústaj Diosa oʼtaʼmonaʼnok aʼti Diosen huaʼa oʼmanmadikaʼapo. Oroʼen huairi o̱ʼe̱. Do huairi ehueʼ i̱hue̱y. Do siʼpopakhued e̱e̱ʼte Jesús Diosere o̱ʼu̱yate.” Ijbatiaʼpakmey. ");
INSERT INTO amrNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ikken Jesústaj doʼhua o̱ki̱a̱hued e̱ʼe̱a̱da, Israel aratbuta Cristotaj kanoknopo̱e̱ʼpo hue̱ʼe̱ya̱ bautiza oʼnogkaʼpone. —‍Juana oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","34","Juana kenpaʼti oʼmanaʼpo, —‍Ken huabokerekte Apag Diosen Noki̱re̱g oʼkotpo, o̱ʼi̱kaʼpo, kentaj boʼtiahuayapone. Ken Huabokereka Diosen Noki̱re̱g aratbuttaj oʼmanopoʼto̱e̱a̱po. Diosa menameʼne. Hue̱ʼe̱ya̱ bautiza kamagkeʼpo, Diosa meʼtaʼmonaʼuyne. Ken kurudya̱ʼ Diosen Noki̱re̱g konig tukkuʼ oʼkotpo, Jesúste oʼkotpo, ke̱yo̱ Diosen Noki̱re̱g o̱ʼi̱kaʼ. Kenda ijtiahuaymey. Kenaʼpo “Jesús Diosen Huasiʼpo o̱ʼe̱.” Ijjay. —‍Juana oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Ken onteʼti emeʼte Juanere oroʼ Juanen bottaʼ huanigpe̱i̱kaʼeriere oʼbopo, ");
INSERT INTO amrNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jesús eʼpokte Juana oʼtiahuayʼuy. Jesústaj oʼtiahuaypo, —‍Yanʼtiahuayʼ. Ken huabokerek konig Apag Diosen Ovejasiʼponig o̱ʼe̱. —‍Juana monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Oroʼ Juanen bottaʼ huanigpe̱i̱kaʼeri oʼpe̱e̱dey, Jesústaj oʼtahuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesús boʼhuakorudpo, eʼtaʼtiakte oroʼtaj boʼtiahuaymeʼne. —‍¿Kate boʼpak? —‍Monameʼne. —‍Ontaj eʼnigpe̱i̱kaʼtaʼ oʼpaki. ¿Meyo̱ i̱ʼi̱kaʼ, Huamanmadikaʼeri? —‍Onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","—‍Yanʼtiak. Yanʼtiahuayʼ. —‍Jesúsa monameʼne. Ken oʼhuaʼpo, ke̱yo̱ e̱ʼhua̱i̱kaʼyo oʼtiahuayʼuy. Kenmeʼnoete Jesúsere o̱ʼunhuaʼmey. Baysikmon o̱ʼe̱meʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Doere Andrésere Juantaj oʼnigpe̱e̱ʼuy. Andrés Simón Pedroen huamaʼbuy o̱ʼe̱po Jesústaj oʼtahuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","I̱dada keʼnen huamaʼbuya Simóntaj oʼukpo, oʼhuahuayʼuy. Simóntaj oʼhuahuaydepo onaʼpo, —‍Cristotaj oʼhuahuayi, “Cristotaj ijtaʼmonaʼapoy.” Aʼnenda Diosa oaʼuyatenig. —‍Andrésa onaʼuy—‍. Jesús Diosen Cristo o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Jesúste oʼtotiakuyate. Jesúsa oʼtiahuaypo, —‍Simón i̱ʼe̱, Jonásensiʼpo i̱ʼe̱. O̱ʼnen huadik Cefas o̱ʼe̱a̱po. —‍Onaʼuy. Cefas konigdik Pedro o̱ʼe̱. Cefas huiddik o̱ʼe̱. Ken konig Cefas Jesústaj huaboaʼda oʼnigpe̱i̱kaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Emeʼte Jesús Galilea huadariyo aʼhuayaʼ oʼnopo̱e̱po Felipetaj oʼhuahuayʼuy. Oʼhuahuaydepo, —‍Menigpe̱i̱kaʼpo betaʼhuaikaʼ. —‍Jesúsa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ken Felipe huakkaʼ jak Betsaidayo o̱ʼi̱kaʼuyate. Ke̱yo̱ti Andrésere Pedroere o̱ʼnikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ken Felipe Jesústaj oʼpe̱e̱depo oknopo̱e̱depo Natanaeltaj oʼukdepo oʼhuahuayʼuy. —‍Diosa huabokerek moʼnigtaʼmonaʼapone. Moiséskudak ken huabokerektaj oʼtimadoyaʼuyate. Konigti Apag Diosen huaʼa huamanbatiaʼpakeri onʼtimadoyaʼuyate. Ken huabokerek boʼhuatiakdenok oʼhuahuaydene. Keʼnendik Jesús o̱ʼe̱. Joséensiʼpo o̱ʼe̱. Nazaret huakkaʼ jak hua̱e̱ʼeri o̱ʼe̱. —‍Felipea Natanaeltaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","—‍Nazaret huakkaʼ jakyo huadakda aratbut ehueʼ o̱ʼnikaʼ. —‍Natanaela oaʼuy. —‍Yatiak. Yatiahuayʼ. —‍Felipea onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Natanael eʼtiakdeʼte Jesúsa Natanaeltaj oʼtiahuaypo, —‍Yanʼtiahuayʼ. Keʼna oʼtiakdepo hueretda Israel aratbut o̱ʼe̱. Keʼna ʼurunopoʼda da ahueʼ o̱ʼi̱kaʼ. Buttida oʼikaʼ. —‍Jesúsa oʼhuaaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanael Jesústaj oʼpe̱e̱depo, —‍¿Menpaʼpiʼ doʼtaj o̱ki̱e̱ʼ? —‍Natanaela onaʼuy. —‍Felipea ontaj totiakhued higuera o̱hue̱ytaʼpote onʼtaj ijtiahuayi. —‍Jesúsa Natanaeltaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanaela Jesústaj oʼpe̱e̱depo oknoponpo, —‍Diosen Huasiʼpo i̱ʼe̱. Israel aratbuten Huairi i̱ʼe̱, Huamanmadikaʼeri. —‍Natanaela onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","—‍Kenaʼpo higuera o̱hue̱ytaʼpote on tiakhued e̱e̱ʼte ontaj ijtiahuayi. Kenda onaʼnok doʼtaj oknoponne. Kennayo sigda ijjay. Doʼtaj nogi̱ti meknopo̱e̱ʼpo teynanada ijkaʼapoy. —‍Jesúsa Natanaeltaj onaʼpo, ");
INSERT INTO amrNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","—‍Do Huabokerek i̱jje̱po, Diosyaʼ ijtiakuy, Diosa meʼtaʼmonaʼuyne. Kurud Diosenbayaʼ ekhuikeʼ doʼte Diosen huataʼmoneria mentihuarakatupo menokbehuikonapone, opudomeya̱ boʼtiahuayapone, buttida ijjay. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Oroʼ huanigpe̱i̱kaʼeri Jesúsere Galilea huadaribayo oʼhuaʼuy. Bottaʼaʼ eksik o̱ʼu̱y. “Eʼto̱e̱pak aypo oʼbatobapeapoy, Caná huakkaʼ jakyaʼ oʼbatobapeapoy. O̱ʼnen huanigpe̱i̱kaʼeriere yatiak.” Aypo huairia Jesústaj onaʼnok Jesúsere oʼhuaʼuy. Jesúsen hua̱ye̱kon o̱ʼu̱y. ");
INSERT INTO amrNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Huakkaʼnada o̱ʼnepo eʼto̱e̱pak aypo onʼbapeʼpo ayaʼda vino onʼmaiʼdepo, —‍Vino ehueʼ o̱ʼe̱. —‍Jesúsen hua̱ye̱a̱ onaʼ, Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","—‍¿Menapo doʼtaj onaʼ, nag? Ken konig ʼuruda ijkikaʼapoy, aratbuttaj tihuapokhued i̱jje̱y. —‍Jesúsa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","—‍Katepiʼ Jesúsa ya̱gkaʼ enaʼte ya̱gkaʼ. —‍Ken Jesúsen hua̱ye̱a̱ vino hua̱hue̱tohuaʼeritaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Huaboroʼ huidkoso judío aratbut onʼto̱i̱kaʼpo, hue̱ʼe̱y onjoypo onʼbakoyoʼikaʼ. Kenda ekaʼnayo Diostaj ʼuruʼnopoʼda o̱ʼe̱a̱poy oʼnoknopo̱i̱kaʼuy, ken. Kenteda seis boroʼhuidkoso oʼbahuadʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","—‍Huidkosoyo hue̱ʼe̱y yaʼnonjoiʼ. —‍Jesúsa oʼmanaʼuy. Huakkaʼ hue̱ʼe̱y onʼtoegonpo hueda̱ʼda oʼnonjoyʼuyate. Onʼoydepo, ");
INSERT INTO amrNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","—‍Huidkosoyo sigpiʼ yatoegpo. Aypo huairite yanʼtohuaʼ. —‍Jesúsa oʼmanaʼuyate. Ken onʼtohuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Hue̱ʼe̱y e̱e̱ʼtada huaboaʼda vino o̱ʼeanuy. Aypo huairi oʼmaiʼdepo ʼurunanada vino o̱ʼe̱ oʼnopo̱e̱po ke̱yan onʼtotiak nopo̱e̱hueʼ o̱ʼu̱y. Vino hua̱hue̱tohuaʼeriayoʼda onʼnopo̱e̱ʼuy. —‍Yatiak. —‍Ken huabokerek hua̱to̱e̱pakeritaj onaʼpo, ");
INSERT INTO amrNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","—‍In vino huadaknanada o̱ʼe̱. Ayaʼ huabokerek vino onʼmatomayʼikaʼdepo huakkuru huadak vino onʼbayokikaʼ. Kenokaʼ huakkaʼaʼda onʼmamayʼdepo, sueʼda huadak vino onʼbayokikaʼ. O̱ʼnanayo huakkuru sueʼda huadak vino iʼmatomaydenigʼa, huaboaʼda huadak vino iʼtotiakne. —‍Aypo huairia onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ken Galileadariyo huakkaʼ jak Canáte Jesúsa kenda oʼkaʼuy. Aratbuta Jesústaj oknopo̱e̱ʼdik kaʼneʼpo Diosa Jesúsere o̱ʼe̱po oʼtihuapokpo kenda huakkuru ʼuruaʼda oʼkaʼuy. Vino oʼkaʼuy. Konig Diosyoʼda ʼuruaʼnanada kaʼdik, konig teyda oʼkaʼnok oroʼomey keʼnen huanigpe̱i̱kaʼeri oʼtiahuaypo Jesús Diosen Huasiʼpo o̱ʼe̱ nogi̱ti oknopo̱e̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Nogok Jesús Capernaum huakkaʼ jakyo oʼhuaʼpo, hua̱ye̱ere huamaʼbuyere oroʼomey huanigpe̱i̱kaʼeriere oʼhuaʼuy. Capernaum huakkaʼ jakyo o̱ʼi̱kaʼuy. Sueʼda huameʼnoe o̱ʼu̱y. ");
INSERT INTO amrNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Aʼti judío huakkurueri isiʼpo mabueyhueʼ e̱e̱ʼ okkahuehueʼ fiesta o̱ʼe̱deapo. Jerusalén huakkaʼ jak oteʼyo Jesúsa oʼbehuikuy. Oroʼomey keʼnen huanigpe̱i̱kaʼeriere oʼbehuikuy. ");
INSERT INTO amrNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Diosen jakki̱re̱gyo̱ oʼkudonpo, vaca ʼuhua oveja ʼuhua tukkuʼ ʼuhua huabahuayaʼeritaj oʼbatiahuayatoʼuy. Huakupe huakabiaʼeritakon oʼbatiahuayʼuy. Konig engaña huakaʼeri o̱ʼnepo jakki̱re̱g akbogpete onʼbahuad. ");
INSERT INTO amrNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Eʼbia oʼbatinukupo huiokda huabitbitbia oʼkedpo, Jesúsa Apag Diosen jakyaʼ ayaʼtada oʼmaoro̱kaʼuy. Oveja vacakon oʼmaoro̱kaʼuy. Huakabiaʼerien huakupe onkutaʼtogʼuy. Mesa oʼbakkubukaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","—‍Ayaʼda yanʼtohuaʼ. Doʼhued Apagen jak huationaʼpak jak o̱ʼe̱. Huabahuayaʼ jak ehueʼ o̱ʼe̱. ʼUhuaeretaj huakupeeretaj yanʼbato̱ro̱k. I̱ya̱ʼ bahuayahueʼ yaneʼ. —‍Tukkuʼ huabahuayaʼeritaj oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","“O̱ʼnen jak ijjeretpaki, Dios. O̱ʼnen jaktaj ijpaknok huakkaʼ menhuadiayapone.” Apagbaʼte aʼnennada oʼmadoyaʼuyate. Apagbaʼ oʼtiahuayʼuy oroʼ Jesúsen huanigpe̱i̱kaʼeria huaboaʼda oʼnopoenʼuy. Jesústaj Apagbaʼa oʼtiaʼpakuynok oʼnokotuy. ");
INSERT INTO amrNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","—‍“Huakupete huabahuayaʼeritaj yamaoro̱kaʼ.” Diosa enaʼnayo oroʼomey kanʼtiahuayeʼpo konig Diosyoʼda kaʼdik o̱ʼe̱ konigti yakaʼ. —‍Oknopo̱e̱hueʼ hua̱e̱ʼeri judío huairia Jesústaj namaʼda oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","—‍In jak yanʼsak. Bapaʼ huameʼnoe onteʼti ijkaʼapoy. —‍Oʼmanaʼuy Jesúsa. ");
INSERT INTO amrNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","—‍In jak cuarenta y seis huabayok onʼkadhuahuaʼuy. Bapaʼ huameʼnoe Diosen jak eʼsakte kahueʼdik i̱ʼe̱a̱po. —‍Judío huairia oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Jesúsnayo Diosen huid jaktaj tiaʼpakhueʼ o̱ʼu̱y, Jesúsenso̱ʼtaj oʼtiaʼpakuy, “Doʼtaj menarakapone. Bapaʼmeʼnoe ijnoyhuadapoy.” Oʼtiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Nogok Diosa Jesústaj eʼnoyhuada̱deʼte kenda Jesúsa oʼmanaʼuy onteʼti kenda oʼnopoenʼuy. Kenpaʼti oroʼomey huanigpe̱i̱kaʼeri Diosbaʼ Jesústaj buttida onʼnigmadoyaʼuyate, oknopo̱e̱ʼuy. Jesucristo paiʼda oʼnopoʼe̱a̱po, oʼbueyapo, oʼnoyhuadapo Diosbaʼ buttida oʼbatiaʼpak oknopo̱e̱ʼuy. Kenpaʼti Jesúsa buttida oaʼ oknopo̱e̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Judío huakkurueri isiʼpo mabueyhueʼ e̱e̱ʼ okkahuehueʼ fiesta o̱e̱ʼuy. Jerusalén huakkaʼ jakyo huakkaʼnanada o̱gkupopakpo Jesúskon o̱ʼe̱po, konig Diosyoʼda kaʼdik o̱ʼe̱ konig teyda Jesúsa oʼkaʼuyate. Onʼtiahuaypo, huakkaʼda kentaj oʼnoknopo̱e̱ʼuyate. Jesús Diosen Cristo ya̱ʼe̱tpiʼ oʼnoknopo̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Jesúsnayo ayaʼ aratbuttaj huanopoyaʼda oʼmaki̱e̱ʼpo inomey huaboaʼda moknopo̱e̱ne, sueʼda moknopo̱e̱ne, hueretda huaknopo̱e̱ʼeri ehueʼ o̱ʼne, Jesúsnayo oʼmaki̱e̱ʼuy. “Inomey hueretda huaknopo̱e̱ʼeri ehueʼ o̱ʼne.” Beʼapiʼ ahueʼdik o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Jesúsa ayaʼtada huanopoyaʼda oʼmaki̱e̱ʼ. Kenaʼpo nogomeytaj, “¿Monig ya̱ʼne in aratbut?” Ahueʼdik o̱ʼe̱. Kenaʼpo ayaʼtada aratbut huanopoyaʼda oʼmaki̱e̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Huabokerek o̱ʼu̱yate. Keʼna fariseo Moisésenbaʼ huaknopo̱e̱ʼeri huairi o̱ʼu̱yate. Fariseonayo Diosen huaʼa eʼkikaʼtaʼ onʼpakikaʼpo kenpaʼti adhueaʼpaneʼen huaʼa eʼkikaʼtaʼ onʼeretpakuyatenigʼa Diostaj ʼurunopoʼ nige̱hueʼ o̱ʼnuyate. Ken huabokerek fariseo huairi o̱ʼe̱po keʼnen huadik Nicodemo o̱ʼu̱yate. Nicodemo judío huairi kenpaʼti o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Sikyo Jesúste anʼbatiaʼpakyaʼpo oʼhuatiakbedʼuyate. —‍Huamanmadikaʼeri i̱ʼe̱po, oroʼomeytaj aʼmanmadikayaʼpo Apag Diosyaʼ iʼtiakuy, oroʼ oʼnopo̱e̱y. Kenda konig kahued o̱ʼneonhuahuikaʼuyatenigʼa oyda iʼkikaʼ. Kenaʼpo Apag Dios beʼtihuapoknok ʼuruaʼda iʼkikaʼ, Huamanmadikaʼeri. —‍Nicodemoa Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","—‍Beʼapiʼ onteʼti eʼsiʼpoe̱ʼtaʼ eʼpaknayo Dios Huairitaj oknopo̱e̱ʼdik o̱ʼneapo. Diosensiʼpo e̱ʼdik o̱ʼneapo. Onteʼti siʼpoe̱hueʼ e̱e̱ʼnayo Dios Huairitaj oknopo̱e̱hueʼdik o̱ʼneapo. Diosensiʼpo ehueʼdik o̱ʼneapo. Buttida ijjay. —‍Jesúsa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","—‍¿Monig huabokerek ettoneʼendapoyaʼ siʼpopakdik ya̱ʼe̱t? Huabokerek hua̱yeendapoyo onteʼti kudhueʼdik o̱ʼe̱. Onteʼti siʼpoe̱hueʼdik o̱ʼe̱. —‍Nicodemo nopoenkahueʼ o̱ʼe̱po onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","—‍ʼUrunopoʼ aʼnopoʼto̱e̱yaʼpo, kenpaʼti konig Diosensiʼponig a̱ʼe̱ya̱ʼpo dakhueaʼ eʼkaʼ nopoʼkoreaʼdik moʼe̱po, hue̱ʼe̱ya̱ bautiza o̱gkaʼdik moʼe̱po, kenpaʼti Diosen Noki̱re̱ga̱ nopoʼto̱e̱dik moʼe̱po. Kenaʼpo nopoʼkoreahueʼ e̱e̱ʼnayo hue̱ʼe̱ya̱ bautiza o̱gkahueʼ e̱e̱ʼnayo kenpaʼti Diosen Noki̱re̱g nopoʼto̱e̱hueʼ e̱e̱ʼnayo Diosensiʼpo ehueʼdik moʼe̱a̱po. Buttida ijjay. ");
INSERT INTO amrNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ettoneʼso̱ʼyaʼ onʼsiʼpopakpo, aratbutda o̱ʼne. Diosen Noki̱re̱g oʼmanopoʼto̱e̱po, ʼurunanada onʼnoeonhuahuikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","“Kutayaʼ Diosen Noki̱re̱gya̱ʼ siʼpoe̱ʼdik i̱ʼe̱.” Ijjaʼdenok, meʼpukehueʼ ya̱e̱ʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Bapoka oʼadyak. Iʼpe̱e̱nigʼa, meya̱ʼ yatiak, meyon yahuaʼ nopo̱e̱hueʼ i̱ʼe̱. Ayaʼda Diosen Noki̱re̱gya̱ʼ onʼsiʼpoe̱ konigti o̱ʼne. Onteʼti ʼuruaʼnanada o̱gkikaʼ. Monig Diosa monigkaʼ nopo̱e̱hueʼ i̱ʼe̱. —‍Jesúsa Nicodemotaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","—‍¿Monig Diosen Noki̱re̱gya̱ʼ siʼpoe̱ʼdik ya̱ʼe̱? —‍Nicodemoa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","—‍Israel aratbuten huamanmadikaʼeri i̱ʼe̱. ¿Menaʼpo kenda onaʼdene nopo̱e̱hueʼ i̱ʼe̱? ");
INSERT INTO amrNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Do ijnopo̱e̱po, ijbatiaʼpaki. Ijtiahuaypo, ijbatiaʼpaki. Do ijmanaʼnigʼa, opud judío huairi doʼtaj eknopo̱e̱ʼtaʼ pakhueʼ moʼe̱. Buttida ijjay. ");
INSERT INTO amrNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","I̱yo̱da konig aratbut o̱gkikaʼ doʼa onʼbatiaʼpakdenigʼa oknopo̱e̱hueʼ o̱ʼe̱ne. Konig Diosa moʼnigkikaʼne ontaj eʼbatiaʼpaknayo dapiʼ oknopo̱e̱hueʼdik meʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Diosenbayo kurudyo̱ opud behuikhued moʼe̱ne. Diosere ehueʼ moʼi̱kaʼuyne. Donayo huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne. Diosere i̱ji̱kaʼpo Diostaj dakaʼ ijnopo̱e̱y. Diosyaʼ ijtiakuy. ");
INSERT INTO amrNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Aratbut ehueʼ e̱ʼi̱kaʼyo Moiséskudak siro bihui eʼketkaʼ oʼbetaʼuyate. ʼIddute kutayo oʼbetaʼuyate. Kenomeynayo Diostaj oʼnoknopo̱e̱po, bihuitaj onʼtiahuaynok, Diosa oʼbayareaʼuyate. Konigti doʼtaj o̱gkaʼapo. Doa Huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne, doʼtaj ʼiddute kutayo menʼbetapone. Cruzte menʼbetapone. ");
INSERT INTO amrNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Doʼtaj cruzte eʼbetaʼdemeʼte ayaʼda doʼtaj oʼnoknopo̱e̱po kenpaʼda bueyhueʼ o̱ʼneapo onteʼti Diosere onʼnoeonhuahuikaʼapo. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","—‍Ayaʼ dakhueaʼ huakaʼeritaj Diosa huakkaʼda diʼ oʼmaepo keʼnen nogtiyoʼda huasiʼpo oʼmanigtaʼmonaʼuyatenok, kamanopoʼyareʼpo oʼmanigtaʼmonaʼuyatenok. Ayaʼada Diosen Huasiʼpotaj eʼnoknopo̱e̱ʼnayo kenpaʼda bueyhueʼ o̱ʼnepo, Diosere onʼnoeonhuahuikaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Dakhueaʼda bokikate aratbuttaj kamaneʼpo Diosa keʼnensiʼpotaj taʼmonahueʼ o̱ʼu̱yate. Aratbuttaj kamanopoʼyareʼpo Diosa oʼmanigtaʼmonaʼuynok. ");
INSERT INTO amrNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Beʼapiʼ Diosen Huasiʼpotaj oʼnoknopo̱e̱de, “Dakhueaʼ o̱gkaʼ.” Diosa bahuaahueʼ o̱ʼe̱. Beʼapiʼ Huasiʼpotaj oknopo̱e̱hueʼda menta̱e̱nok, “Dakhueaʼ oʼkaʼ.” Diosa oaʼde kenaʼpo Diosen nogtiyoʼda huasiʼpotaj oknopo̱e̱hueʼ o̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Diosen Huasiʼpo konig Diosen huakjey o̱ʼe̱po Diostaj oʼmaknopo̱e̱a̱ʼ. Indariyo aratbuttaj oʼbahuatiakuynigʼa aratbuta Diostaj eknopo̱e̱ʼtaʼ pakhueʼ o̱ʼnepo dakhueaʼ o̱gkikaʼpo sikki̱re̱gyo̱ e̱ʼi̱kaʼtaʼ oʼderetpakikaʼnok. Konige̱po “Dakhueaʼ o̱gkikaʼ.” Diosa oʼmanaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ayaʼada dakhueaʼ e̱gkaʼte nogomeytaj eʼtiahuayataʼ pakhueʼ o̱ʼne. Kenaʼpo Diosen huakjeytaʼ pakhueʼ o̱ʼne. Doʼtaj nigpe̱e̱hueʼ o̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Hueretda huaknopo̱e̱ʼerinayo Diosen buttida huaʼa o̱gkikaʼpo Diosen huakjeytaj onʼpakpo Diosen Huasiʼpotaj oʼnoknopo̱e̱nok, Diosa oʼbatihuapokdenok ayaʼada tiahuaydik o̱ʼne. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nogok Judea huadariyo Jesús oroʼ keʼnen huanigpe̱i̱kaʼeriere oʼhuaʼuy. Jesús oroʼere o̱ʼi̱kaʼpo, bautiza oʼmagkikaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Enón huakkaʼ jakte kenpaʼti Salim huakkaʼ jak ibodteda Juan kenpaʼti bautiza oʼmagkaʼuyate, ke̱yo̱ huakkaʼ hue̱ʼe̱y o̱ʼe̱nok. Aratbut huakkaʼ enʼtiakte Juana bautiza oʼmagkaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Huabakuda̱ʼ jakyo Juantaj kuda̱hued o̱ʼnenok, bautiza oʼmagkikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","“Beʼaen bautiza eʼmagkaʼ Diostaj ʼurunopoʼ kaʼdik yaʼmae, Jesúsenpiʼ Juanenpiʼ.” Juanen huanigpe̱i̱kaʼeri judío aratbutere onʼbatiaʼpakdepo, ");
INSERT INTO amrNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Juante onʼhuatiakonpo, —‍Jordánhue̱ akodpen Jesús onere o̱ʼi̱kameʼne. Jesústaj ʼuruda iʼmanbatiaʼpakmeʼne. Oy bautiza megkeʼpo ayaʼda Jesústaj onʼhuahuaʼ, huamanmadikaʼeri. —‍Juanen huanigpe̱i̱kaʼeria Juantaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","—‍Beʼ huabokerektapiʼ aratbuttaj eʼmanmadikaʼ Diosa oʼpakpo taʼmonaʼdik o̱ʼe̱ kenpaʼti tihuapokikaʼdik o̱ʼe̱. Jesústaj oʼtaʼmonaʼuyatepo Jesústaj oʼtihuapokikaʼ. Aratbuta Jesústaj onʼhuahuaʼdenok. ");
INSERT INTO amrNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","“Do Cristo ehueʼ e̱e̱ʼtada Cristo tiakhued e̱e̱ʼte Diosa doʼtaj huakkuruda meʼtaʼmonaʼuyne.” Opudtaj oʼnonameʼne. Kenda doʼtaj onʼpe̱e̱meʼne. ");
INSERT INTO amrNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Huabokerek huaboaʼda oʼto̱e̱pakpo hua̱to̱e̱ oʼto̱e̱depo durugda o̱ʼe̱. Noga̱ ken huabokerektaj diʼ o̱ʼe̱po, kenpaʼti durugda o̱ʼe̱. Ken konig do Jesústaj diʼ i̱jje̱po durugda i̱jje̱y. Huakkaʼada Jesústaj onʼpakpo huaboaʼda onʼnigpe̱i̱kaʼ. Kenda duruga̱ʼda ijmati̱pe̱e̱y. ");
INSERT INTO amrNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Jesústanayo huakkaʼada nigpe̱i̱kaʼdik o̱ʼnikaʼapo. Doʼtaj huaboaʼda sueʼda nigpe̱e̱ʼdik moʼe̱a̱pone. —‍Juana oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Keʼna Diosyaʼ oʼtiakmeʼpo Diosen huairitoneʼ o̱ʼe̱. Ayaʼtada mataʼmonaʼikaʼdik o̱ʼe̱. Aratbutnayo indari hua̱e̱ʼeri o̱ʼnenigʼa indaritaj onʼnopo̱e̱po onʼbatiaʼpakikaʼ. Jesúsnayo Diosen Huasiʼpo o̱ʼe̱po Diosyaʼ oʼtiakpo ʼurunopoʼda o̱ʼe̱po ayaʼenda huairi o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Katepiʼ Diosyo oʼbatiahuayonhuahuikaʼnig, katepiʼ oʼmapeeonhuahuikaʼnig, kenda oʼmanbatiaʼpakikaʼnigʼa, suhueʼada Jesústaj oʼnoknopo̱i̱kaʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Kenomey Jesúsen huaʼa oʼnoknopo̱e̱po, Diosa buttida oaʼikaʼ oʼnoknopo̱e̱nok. ");
INSERT INTO amrNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Diosa Jesústaj oʼtaʼmonaʼuyate. Diosa keʼnen noki̱re̱gda oʼyok. Jesústaj oʼyok. Dakhuapa keʼnen noki̱re̱g oʼyoknok. Diosen huaʼa oʼmanaʼikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Apag Huasiʼpotaj diʼ o̱ʼe̱. Ayaʼen huairida ka̱e̱ʼpo oʼtaʼmonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Kenomey Diosen Huasiʼpotaj oʼnoknopo̱e̱po onteʼti Diosere onʼnoeonhuahuikaʼapo. Kenomey Huasiʼpotaj oknopo̱e̱hueʼ o̱ʼnepo onteʼti Diosere noeonhuahuahueʼ o̱ʼneapo. Diosa kenomeytaj castiga oʼmagkadhuahuikaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","2","Ken, Jesústaj huakkaʼada onʼpe̱e̱depo huaboaʼda onʼtahuaʼuyate. Huaboaʼda onʼnigpe̱i̱kaʼuyate. Bautiza eʼmagkadeʼte Jesústaj onʼnigpe̱i̱kaʼuy. Jesúsnayo bautiza kahueʼ e̱ʼe̱a̱da oroʼomeya̱ huanigpe̱i̱kaʼeria bautiza oʼmagkikaʼuy. Juantaj sueʼada oʼnoknopo̱e̱ʼuyate. Kenda fariseo huairia onʼtipe̱e̱demeʼte, Jesúsa oʼmaknokotuy. ");
INSERT INTO amrNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ken oʼmaknokotpo, Judeayaʼ oʼbakhuaʼuy. Galilea huadariyo oʼkumeʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ken Galilea huadariyo oʼhuaʼpo, Samaria huadariyo pokdik o̱ʼu̱y. ");
INSERT INTO amrNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Samaria huadariyo huakkaʼ jak Sicarte oʼtiakuy. Sicar Jacobkudaken taʼbate ibodteda o̱ʼe̱. Taʼba Jacobkudaken huasiʼpo Josékudaktaj oʼyokuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Kenteda Jacobkudaken hue̱ʼe̱y sorokkogya̱ʼ huaʼeg o̱ʼu̱yate. Jesús bidteda oʼhuaʼepo o̱ʼa̱ro̱gpo, oʼhuaduy. Tokhuada̱ʼ eʼhuadte oʼhuaduyate. Hue̱ʼe̱y sorokkogte oʼmanighuadʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Oroʼ Jesúsen huanigpe̱i̱kaʼeri aypo aʼbaetuyaʼpo, huakkaʼ jakyo oʼhuaʼdemey. Samariaeri ettoneʼ hue̱ʼe̱y aʼegatuyaʼpo oʼtiakuyate. —‍Hue̱ʼe̱y beyok. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Judío aratbuta Samaria hua̱e̱ʼeritaj batiaʼpakhueʼ o̱ʼi̱kaʼnigʼa Jesústaj ettoneʼa̱ oʼpe̱e̱depo, —‍O̱ʼna judío aratbut i̱ʼe̱nigʼa, Samaria hua̱e̱ʼeri do i̱jje̱y. ¿Menpaʼ hue̱ʼe̱y beyokaʼ doʼtaj menaʼ? —‍Samaria ettoneʼa̱ Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","—‍Diosa huanounhuahuikaʼ hue̱ʼe̱y eʼyoktaʼ beʼtipakne. “Hue̱ʼe̱y beyok.” Ontaj onaʼnigʼa, “Huanounhuahuikaʼ hue̱ʼe̱y beyok.” Doʼtaj meknopo̱e̱po enaʼnayo huanounhuahuikaʼ hue̱ʼe̱y oʼyokapone. —‍Jesúsa ettoneʼtaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","—‍Huaʼeg to̱e̱hueʼ i̱ʼe̱ne. Sorokkog huabidkogyoda hue̱ʼe̱y o̱ʼe̱. ¿Meya̱ʼ huanoeanhuahuikaʼ hue̱ʼe̱y iʼegapo, huairi? ");
INSERT INTO amrNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Oroʼen adhueaʼpaneʼa̱ Jacobkudak in sorokkog boʼyokuyne. Keʼnada oʼmayikaʼuyatenig. Keʼnen huasiʼpo kenpaʼti onʼmamayʼikaʼuyate. Keʼnen vacakon oʼmamayʼikaʼuyate. Oroʼomeytaj in sorokkog boʼyokonʼuyne. ¿Menpaʼ Jacobkudakitipi sigda huairi o̱e̱ʼuynigʼa, o̱ʼna huahuak huairi i̱ʼe̱? —‍Ettoneʼa̱ onaʼpo, ");
INSERT INTO amrNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","—‍Beʼapiʼ in sorokkog hue̱ʼe̱y oʼmaypo, onteʼti maymaya̱ʼ oʼdaʼikanigʼa, ");
INSERT INTO amrNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ayaʼada doʼtaj moknopo̱e̱po Diosere onʼnoeonhuahuikaʼapo. Konig huanoeanhuahuikaʼ hue̱ʼe̱y oʼyoknok onʼmayʼpo, huanopoyo o̱ʼunhuahuikaʼapo, onteʼti “maymaya̱ ijjay” ahueʼ o̱ʼneonhuahuikaʼapo. Doʼtaj moknopo̱e̱po Diosere onʼnoeonhuahuikaʼapo. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","—‍Ken hue̱ʼe̱y beyok. Onteʼti maymaya̱ ahueʼdik a̱ʼe̱ya̱ʼpo, i̱yo̱ sorokkogyo̱ hue̱ʼe̱y aʼegyaʼpo tiakhueʼdik a̱ʼi̱kayaʼpo o̱ʼnen hue̱ʼe̱y ijmayapoy, huairi. —‍Ettoneʼa̱ onaʼpo, Jesúsen huaʼataj nopoenkahueʼda kenpaʼti Jesús Diosen Huasiʼpo o̱ʼe̱ oknopo̱e̱hued o̱ʼe̱po kenda Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","—‍Yahuatiʼ. O̱ʼnen hua̱to̱e̱ʼtaj yatotiak. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","—‍Hua̱to̱e̱ to̱e̱hueʼ i̱jje̱y. —‍Ettoneʼa̱ onaʼuyate. —‍Hua̱to̱e̱ to̱e̱hueʼ i̱jje̱y. Buttida iaʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Huabaniga̱ʼ iʼta̱e̱ʼuynigʼa. Oyda kentaj eʼdipakada o̱ʼnen hua̱to̱e̱ ehueʼ o̱ʼe̱. Kenda buttida iaʼ. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","—‍Diosen huaʼa huamanbatiaʼpakeri o̱ʼe̱, oʼtinopo̱e̱ne, huairi. ");
INSERT INTO amrNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","In oʼteʼyo “Huaboroʼda i̱ʼe̱, Apag Dios.” Oroʼ onaratbutyoʼ adhueaʼpaneʼkudak Samaria huadari hua̱e̱ʼeriomeya̱ onʼtionaʼpakikaʼuyate. Jerusalén huakkaʼ jakyo “Huaboroʼda i̱ʼe̱, Apag Dios.” Tionaʼpakdik moʼe̱ne. Opuda̱ judío aratbut onʼmanaʼikaʼ. —‍Ettoneʼa̱ onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","—‍Menʼpe̱e̱ʼ, ettoneʼ. Aʼti meyo̱piʼ moʼe̱po Apag Diostaj tionaʼpakdik moʼe̱ne. Apag Diostaj aʼtionaʼpakyaʼpo in oteʼte tiakhueʼdik moʼe̱a̱pone. Kenpaʼti aʼtionaʼpakyaʼpo Jerusalényo̱ huahueʼdik moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Opud Samaria hua̱e̱ʼeria Diostaj nopo̱e̱hueʼda namaʼda moʼtionaʼpaknigʼa, oroʼomeynayo judío aratbut o̱ʼe̱po Diostaj oknopo̱e̱po dakaʼ oʼtionaʼpakikay. Diosen huamanopoʼkoreaʼeri judío aratbut o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","24","Apag Dios noki̱re̱g o̱ʼe̱po buttida oaʼikaʼ. Apag Diosen huaʼa buttida o̱ʼe̱. Oy kenpaʼti nogokkon aratbut huadaknopoʼda Diosen buttida huaʼataj oʼnoknopo̱e̱po Apag Diostaj onʼtionaʼpakapo. Diosen Noki̱re̱ga̱ oʼmanopoʼto̱e̱nok Apag Diostaj onʼtionaʼpakapo. Kenda Apag Diosa oʼpak. —‍Jesúsa ettoneʼtaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","—‍Nogok Diosa Cristotaj oʼtaʼmonaʼapo, yoknopo̱e̱y. Eʼtiakdeʼte ayaʼda oʼmanmadikaʼapo. —‍Ettoneʼa̱ onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","—‍Cristo do i̱jje̱y. Doa onʼbatiaʼpaknig Cristo i̱jje̱y. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jesúsa ettoneʼtaj kenda eʼnadeʼte oroʼomey Jesúsen huanigpe̱i̱kaʼeri Jesúste oʼtiakuy. Jesúsa ettoneʼtaj oʼbatiaʼpaknok oroʼa oʼtiahuaypo oʼmeʼpukeʼuy. (Aʼnennada judío huamanmadikaʼeri ettoneʼtaj batiaʼpakhueʼ o̱ʼnikaʼuy.) “¿Kaʼtiaʼpo ettoneʼtaj inaʼpak?” “¿Kate iʼpakpo iaʼ?” Jesústaj onahueʼ o̱ʼu̱y. ");
INSERT INTO amrNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ettoneʼ sorokkoso oʼhuadanpo okhuaʼuyate. Keʼnen huakkaʼ jakyo Sicar okhuaʼuyate. Huakkaʼ jakyo oʼkudondepo, huakkaʼ jak hua̱e̱ʼeritaj oʼmanaʼpo, ");
INSERT INTO amrNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—‍Sorokkogte huabokereka behuatiakpo doʼtaj ʼuruaʼda menbatiaʼpakne. Nog huadaribayoeri o̱ʼe̱nigʼa ayaʼda nogok nogok ijkikameʼnig kenda menaʼne. Ayaʼda oʼnopo̱e̱po menaʼne. Keʼna Cristo ya̱ʼe̱tpiʼ. —‍Ettoneʼa̱ keʼnen ayaʼ huakkaʼ jak hua̱e̱ʼeritaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ken huakkaʼ jakyaʼ huakkaʼada onʼmaoro̱konpo, Jesústaj onʼhuatiakuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Huakkaʼda aratbut tiakhued e̱ʼneʼte, —‍Yabapeʼ, Huamanmadikaʼeri. —‍Oroʼ keʼnen huanigpe̱i̱kaʼeria onaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","—‍Bapeahueʼ i̱jje̱y. Nogda aypo ijto̱e̱nig opud nopo̱e̱hueʼ moʼe̱ne. —‍Monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","—‍Beʼapiʼ kentaj aypo yanigtotiaketpiʼ, oʼnopo̱e̱po oroʼomey huanigpe̱i̱kaʼeria huayahuaya oʼbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","—‍Diosa doʼtaj meʼtaʼmonaʼuyne. Katepiʼ Dios oʼpak kenda ijkikay. Ayaʼda keʼnen ijkuhuitapoy. Keʼnen ijjeretpakpo ijkikaʼpo, doʼhued aypo konig o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Opudomey aypotaj huakkaʼ moʼnopo̱e̱po, “Aypopiʼ boyoghued e̱e̱ʼte aʼti bottaʼ bottaʼ puug oʼboyogaponok jakyo totiakdik o̱ʼe̱a̱poy.” Moʼbatiaʼpakikaʼnig. Oy konig eʼboyog a̱ʼe̱ya̱ʼpo huakkaʼ aratbut onʼbatiakdenok, yanʼtiahuayʼ. Oy huakkaʼada eʼnopoʼkoreaʼtaʼ onʼpak. Huakkaʼada Diostaj eknopo̱e̱ʼtaʼ onʼpak. ");
INSERT INTO amrNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","37","“Nogtiada oʼbatukeʼ. Noga̱ aypo oʼtotiak.” Ken buttida onʼbatiaʼpakikaʼuy. Konig huabatukeʼeri i̱jje̱po konig huakkuruda Diosen huaʼa dakaʼ ijmanmadikay. Opudomey konig aypo huatotiakeri moʼe̱po doʼhued huaʼa moʼmanmadikikaʼaponok huakkaʼada doʼtaj moʼnigpe̱i̱kaʼapone. Doere Diosere moʼnoeonhuahuikaʼapone. Konig dakhuapa opudomeya̱ doere moʼdurugpakonhuahuikaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nogomeya̱ onʼmanmadikadhuaʼdeʼuy. Aratbut i̱dada oknopo̱e̱hueʼ o̱ʼnuypo kanoknopo̱e̱ʼpo opudomeya̱ kanʼmanmadikeʼpo doʼa onʼtaʼmonaʼuyne. Opudomey huakkuru huamanmadikaʼeriere moʼmanmadikaʼnok moʼmaknopo̱e̱a̱ʼapo. —‍Jesúsa oroʼtaj monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ken jakte huakkaʼ Samaria hua̱e̱ʼeri o̱ʼnikaʼpo, “Ayaʼ nogok nogok ijkikaʼuynigda.” Menaʼne. Ettoneʼa̱ oʼmanbatiaʼpaknok, huakkaʼada Samariayo hua̱e̱ʼeria Jesústaj oʼnoknopo̱e̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Samaria hua̱e̱ʼeri onʼhuatiakde. “Oroʼomeytaj botaʼhuadunhuaʼ.” Jesústaj oʼnonaʼuy. Kente bottaʼ huameʼnoe o̱ʼu̱ynok. ");
INSERT INTO amrNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Jesúsen huaʼataj onʼpe̱e̱po nogi̱ti huakkaʼada oʼnoknopo̱e̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","—‍Ontayoʼda onʼpe̱e̱po oknopo̱e̱hueʼ o̱ʼe̱ʼnigʼa oy Jesústakon onʼpe̱e̱depo oknopo̱e̱y. Jesús Diosen Cristo o̱ʼe̱. Diosa moʼnigtaʼmonaʼuyne. Aratbuten dakhueaʼ eʼkaʼ kabakkahueʼpo, huamanopoʼyareadhuaʼ o̱ʼe̱ monoknopo̱e̱y. —‍Ettoneʼtaj oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Botmeʼnoe Sicar huakkaʼ jakyo o̱ʼe̱depo oroʼomeyere Jesúsa oʼbakhuaʼuy. Galilea huadariyo oʼhuaʼuy. Galilea huadariyo Jesús oʼkerekuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Diosen huaʼa huamanbatiaʼpakerien jak hua̱e̱ʼeriomeynayo Diosen huamanbatiaʼpakeritaj eʼpe̱e̱taʼ pakhueʼ o̱ʼnikaʼ. Jesúsa Galilea hua̱e̱ʼeritaj oʼmanbatiaʼpakuynigʼa. ");
INSERT INTO amrNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Galilea huadari hua̱e̱ʼeri Jerusalényo̱ aypo fiestate o̱ʼnemeʼte. Jerusalényo̱ Jesúsa ʼuruaʼnanada konig Dios ekapaʼ oʼkameʼnok onʼtiahuayʼuyate, Galilea hua̱e̱ʼeria. Jesúsa teynanada oʼkameʼnok Galileayo eʼkumejdeʼte durugteda Jesústaj oʼdeʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ken, Caná huakkaʼ jak Galilea huadariyo ke̱yo̱ hue̱ʼe̱ytaj vino oʼkameʼ onteʼti Jesús oʼtiakuy. Capernaum huakkaʼ jak meyo̱hueʼda o̱ʼe̱po Capernaum gobierno huairiensiʼpo oʼdigpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Judea huadariyaʼ Jesúsa oʼtiakdepo, Galilea huadariyo Jesús o̱ʼi̱kaʼ. Kenda Capernaum huairi oʼtipe̱e̱depo Jesústaj oʼhuahuaʼdepo, “Capernaum huakkaʼ jakyaʼ doʼhuedsiʼpo oʼbueyapo. Bohuaʼ. Betayareaʼ.” Diga̱ʼda onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","—‍Opud Galilea hua̱e̱ʼeri doʼhued huaʼa eknopo̱e̱ʼtaʼ pakhueʼ moʼe̱. ʼUruaʼda ekaʼnayo konig eʼbayareaʼnayo doʼhued huaʼataj yanoknopo̱e̱a̱petpiʼ. —‍Jesúsa Capernaum huairitaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","—‍Bueyhued e̱e̱ʼte doʼhuedsiʼpote bohuaʼ, huairi. —‍Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","—‍Yahuatiʼ. O̱ʼnensiʼpo oʼyarede oʼnoe. —‍Jesúsa onaʼuy. Jesúsen huaʼataj buttida oknoponpo jakyo oʼkumeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Jakyo eʼkumejte dagte keʼnen huanabaʼa onʼhuatiakpo, onʼdejpo, —‍O̱ʼnensiʼpo oʼyarede, oʼnoe. —‍Keʼnen huanabaʼa oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","—‍¿Menokaʼ yaʼyarud? —‍Oʼmanaʼuy. —‍ʼIkken niokpo tokhuad eʼhuadte oʼyaremeʼ. —‍Huanabaʼa oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Kente niokpo eʼhuadte “O̱ʼnensiʼpo oʼyarede oʼnoe.” Jesúsa menameʼne. Huasiʼpoed huaoa oʼnoponpo. Keʼnen huabetomeya Jesús Diosen Huasiʼpo Diosyaʼ oʼtiakuyate, oʼnoknopo̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Judea huadariyaʼ Jesús oʼkumejdepo Galilea huadariyo oʼtiakuy. Galilea huadariyo hue̱ʼe̱ytaj vino oʼkaʼuy. Kenpaʼti gobierno huairiensiʼpo oʼyareaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nogok judío aratbut onteʼti onʼmabapeʼapo, Jerusalénya̱ʼ onʼmabapeʼapo kenpaʼti onʼtionaʼpakapo. Jesús Jerusalén huakkaʼ jakyo onteʼti oʼbehuikonʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalén huakkaʼ jak kurupen huida̱ eʼtiokpakaʼ akbogpe o̱ʼe̱. Akbogpedik oʼdikkaʼuy oveja. Oveja akbogpete ya̱ko o̱ʼe̱. Ya̱kodik oʼdikkaʼ Betesda. Betesda ya̱ko aktaʼbogpete huabaniga̱ʼ baʼak o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Baʼakyo huakkaʼda oʼnonpabahuedikaʼ. Onʼdigpakpo oʼnonpabahuedikaʼ, ekpobig oʼnonpabahuedikaʼ, huakket oʼnonpabahuedikaʼ, eʼhue̱tihuarotaj oʼnonmaboikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Ya̱kote nogok nogok Diosen huataʼmoneri onʼhuarakatuikaʼ. Oʼtiakdepo ya̱kotaj oʼtihuaroaʼuynok. Ya̱ko karogda eʼtihuaroyo beʼapiʼ huakkuruda yakudontaj oʼbayareaʼikaʼuyate. Katepiʼ dakhueʼ e̱ʼneʼte oʼbayareaʼikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Kente treinta y ocho huabayok nogbokerektida dakhueʼ enpahued o̱ʼunhuahuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesús okmapi̱e̱ʼahuaddik huameʼnoete ya̱kote oʼtiakdepo, enpahuedikaʼtaj oʼtiahuaydepo onpahuedunhuahuikaʼ oknopo̱e̱po, —‍¿Eʼyareaʼtaʼ menpaʼ iʼpak? —‍Onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","—‍Ya̱ko eʼtihuarote beʼapiʼ doʼtaj tohuahueʼdik meʼnene. Doʼa dakaʼda ijhuaʼnok, noga̱ huakkuruda oʼkudikaʼ, Huairi. —‍Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","—‍Yaboʼ. Colchón yaʼudpo, yahuaeʼ. —‍Jesúsa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ijhuiti ehueʼ oʼyareadʼuy. Colchón oʼudpo oʼhuaʼudʼuy. Okmapi̱e̱ʼahuaddik huameʼnoete oʼyareaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Okmapi̱e̱ʼahuaddik huameʼnoete sigpiʼ kahueʼdik moʼe̱ne. Judíoen adhueaʼpaneʼ namaʼda onʼmanikaʼuynok, —‍Okmapi̱e̱ʼahuaddik huameʼnoe o̱ʼe̱nok colchón tohuahueʼdik o̱ʼe̱ne. —‍Judío huairia oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","—‍Kenbokereka doʼtaj beʼyareaʼne. “Colchón yaʼudpo yahuaeʼ.” Keʼna menaʼnok ijkay. —‍Judío huairitaj oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","—‍“Yaʼudpo yahuaeʼ.” ¿Beʼa onʼtaj menaʼ? —‍Judío huairia oʼnonaʼuy. Jesúsa dakhueʼda onaʼ onʼnopo̱e̱po oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Jesúsendik nopo̱e̱hued o̱ʼe̱po kenpaʼti keʼna beʼyareadne nopo̱e̱hueʼ o̱ʼu̱y. Kenpaʼti huakkaʼada aratbut o̱ʼnenok Jesúsa okhuaʼnok Jesústaj tiahuayhueʼdik o̱ʼe̱po. ");
INSERT INTO amrNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Nogok Jesúsa Diosen jakyo oʼhuahuayʼuy. Huayareritaj oʼhuahuayʼuy. —‍E̱ya̱ʼ, oʼyaraddene. Dakhueaʼ onteʼti kahueʼ ya̱e̱ʼ. Onteʼti dakhueaʼ ekaʼnayo nogi̱ti dakhueʼda i̱ʼe̱a̱pone. —‍Jesúsa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Kenokaʼ judío huairite oʼhuaʼuyate. “Jesúsa beʼyareadne.” Huabokereka oʼbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Okmapi̱e̱ʼahuaddik huameʼnoete Jesús kenda oʼkaʼnok Judío huairia Jesústaj huaboaʼda diga̱ʼda onʼhuadiaypo dakhueaʼ onʼhuaadhuahuikaʼpo, kenpaʼti eʼaraktaʼ onʼtipakonhuahuikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","—‍Oy kenpaʼti doʼhued Apag Dios oʼkikaʼ doakon ijkikay. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Okmapi̱e̱ʼahuaddik huameʼnoete judío aratbut kahueʼdik yaneʼ, kenda judío huairien adhueaʼpaneʼa̱ onʼmanikaʼuynigʼa. Jesúsa manigpe̱e̱hueʼ o̱ʼe̱po okmapi̱e̱ʼahuaddik huameʼnoete oʼyareaʼpo. Kenpaʼti Dios doʼhued Apag meʼta̱e̱ne, oaʼpo. “Konigti Dios i̱jje̱y.” Jesúsa oaʼnok, judío huairia onʼnopo̱e̱po nogi̱ti diga̱ʼda eʼaraktaʼ oʼderetpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","—‍Do Diosen Huasiʼpo i̱jje̱po doʼhuedda kahueʼdik i̱jje̱y. Katepiʼ Apaga oʼpaknok kenda do Diosen Huasiʼpo i̱jje̱po ijkikay. Konig doʼhued Apag oʼkaʼ konigti ijkay. Buttida ijjay. ");
INSERT INTO amrNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Kenpaʼti Diosen Huasiʼpo i̱jje̱nok doʼtaj diʼ meʼe̱ne. Ayaʼda Diosa oʼkikaʼpo kenda doʼtakon meʼnopo̱e̱a̱ʼne. Huabokerektaj ijyareaʼdey. Nogi̱ti ʼuruaʼda ijkaʼapoy. ¡Kenpihuay! Aʼdik moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Aratbut enʼbueydeʼte onteʼti Diosa manoeaʼdik o̱ʼe̱. Konigti do Diosen Huasiʼpo i̱jje̱po eʼbueytapiʼ eʼmanoeaʼtaʼ ijpakpo ijmanoeaʼapoy. ");
INSERT INTO amrNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","“Dakhueaʼ iʼkaʼ.” Apagayoʼda aratbuttaj ahueʼ o̱ʼe̱. Apaga oʼpaknok, “Dakhueaʼ iʼkaʼ.” Doa Apagen Huasiʼpo i̱jje̱po aʼdik i̱jje̱a̱poy. ");
INSERT INTO amrNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Kenda Apaga oʼpaknok, “Diosen Huasiʼpo huadakda o̱ʼe̱.” Ayaʼada doʼtaj onʼtiaʼpakapone. Konig Apagtaj huadak onʼtiaʼpakpo, konigti doʼtaj huadak onʼtiaʼpakapone. “Huasiʼpo huadakda o̱ʼe̱.” Beʼapiʼ doʼtaj tiaʼpakhueʼ e̱e̱ʼnayo konigti “Apag Dios huadakda o̱ʼe̱,” tiaʼpakhueʼda o̱ʼne. Apaga doʼtaj meʼtaʼmonaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ayaʼada doʼtaj dakaʼ onʼpe̱e̱po kenpaʼti Apaga meʼtaʼmonaʼuyne, oʼnoknopo̱e̱po doere kurudyo̱ onʼnoeonhuahuikaʼapo. “Dakhueaʼ bokaʼne.” Diosa onahueʼ moʼe̱a̱pone. Konig Diostaj enʼnopoʼbueyde onʼnige̱ʼnigʼa Diosa moʼmanoeanhuahuikaʼapone. Buttida ijjay. ");
INSERT INTO amrNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nogok kenpaʼti oyda kenomeya̱ konig Diostaj onʼnopoʼbueydenigʼa Apag Diosen Huasiʼpotaj onʼpe̱e̱a̱po. Onʼnigpe̱e̱po Diosere onʼnoeonhuahuikaʼapo. Buttida ijjay. ");
INSERT INTO amrNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Apag Dios oʼnoeonhuahuikaʼpo onteʼti manoeanhuahuikaʼdik moʼe̱ne. Diosa oʼpaknok do Diosen Huasiʼpo kenpaʼti aratbuttaj onteʼti manoeanhuahuikaʼdik i̱jje̱y. ");
INSERT INTO amrNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Do huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne. Konige̱po, “Dakhueaʼ iʼkaʼne.” Aratbuttaj manaʼdik i̱jje̱y. ");
INSERT INTO amrNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Kenda mepuʼkehueʼ yaneʼ. Kenaʼpo nogok ayaʼ huabueyeri kubarakyaʼ doʼtaj onʼpe̱e̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Onʼmaoro̱konkaʼapo. Huadak huakikaʼeri onteʼti Diosere onʼnoeonhuahuikaʼapo. Dakhueaʼ huakikaʼeri paiʼnanada onʼnopoʼunhuahuikaʼapo. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","—‍Doʼhuada ijnopo̱e̱po kahueʼdik i̱jje̱y. Konigti Apag Diosa menaʼnok ijjay. Buttida ijjaʼikay. Kenaʼpo katepiʼ do ijpakpo kahueʼ i̱ji̱kay. Kenda Apag Dios oʼpaknok ijkikay. Apag Diosa meʼtaʼmonaʼuynok. ");
INSERT INTO amrNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Doʼa Diosen Huasiʼpo i̱jje̱y. Doʼhuayoʼda ijnopo̱e̱po eaʼnayo kenpaʼ ahueʼ i̱jje̱a̱ynigʼa konig buttida doʼhued huaʼa pe̱e̱hueʼdik o̱ʼnene. ");
INSERT INTO amrNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","“Doʼhued Huasiʼpo meʼta̱e̱ne.” Diosa beʼhuaaʼne. Doʼtaj buttida beʼhuaaʼnok doʼtaj pe̱e̱ʼdik o̱ʼnene ijnopo̱e̱y. ");
INSERT INTO amrNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Jesús beʼati ya̱ʼe̱taʼpo.” Juantaj opudomeya̱ moʼtaʼmonameʼ. “Jesús Diosen Huasiʼpo o̱ʼe̱.” Juana buttida doʼtaj beʼhuaameʼne. ");
INSERT INTO amrNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","“Jesús Diosen Huasiʼpo o̱ʼe̱.” Huabokereka eʼhuaaʼte donayo pe̱e̱hueʼdik i̱jje̱y. Opudomeya̱nayo Juantaj nigpe̱e̱dik moʼe̱po doʼtaj oknopo̱e̱ʼdik moʼe̱ne Diosere aʼnoeonhuahuikayaʼpo doʼtaj oknopo̱e̱ʼdik o̱ʼnene. Oʼnonaʼne. ");
INSERT INTO amrNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Juan konig jeyda huakjey ʼuruda oʼtaʼte, Juana ʼuruda oʼmanmadikikameʼpo. Opudomey judío aratbuttaj monʼmadikikameʼne. Opudomey huakjeytaj moʼdurugpakatumeʼne. Juantaj monʼpe̱e̱po moʼdurugpakatumeʼne. ");
INSERT INTO amrNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Dios doʼhued Apag o̱ʼe̱po doʼtaj meʼtaʼmonaʼuyne. Kenda Juana buttida behuaameʼne, opudomeytaj monameʼnok doʼtaj oknopo̱e̱ʼdik moʼe̱nok. Kenpaʼti konige̱po katepiʼ ʼuruaʼda Diosayoʼda kaʼdik o̱ʼe̱, doakon ijkikaʼnok Diosa oʼtaʼmonaʼuy oknopo̱e̱ʼdik moʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Kenpaʼti Apaga Apagbaʼte doʼtaj beʼtiaʼpakuynigʼa opudomey judío huairinayo Diostaj tiahuayhueʼ moʼi̱kaʼpo kenpaʼti nigpe̱e̱hueʼ moʼi̱kaʼpo, ");
INSERT INTO amrNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","keʼnen huaʼa eʼpe̱e̱taʼ pakhueʼ moʼe̱. Diosa oʼtaʼmonaʼuy. Doʼtaj oknopo̱e̱hueʼ moʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Apagbaʼa doʼtaj beʼtiaʼpakne. Opudomeynayo doʼtaj oknopo̱e̱hueʼ moʼe̱ne. Diosyaʼ oʼtiakuy oknopo̱e̱hueʼ moʼe̱po Apagbaʼtayoʼda moʼmonaʼpakikaʼpo, Diosere oʼnoeonhuahuikaʼapoy namaʼda moʼnopo̱e̱ne. Doʼtaj oknopo̱e̱hueʼ moʼe̱nok Diosere noeonhuahuikahueʼ moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ayaʼada doʼtaj oʼnoknopo̱e̱po Diosere onʼnoeonhuahuikaʼapo. Opud judío huairinayo doʼtaj eknopo̱e̱ʼtaʼ pakhueʼ moʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Huadak o̱ʼe̱.” Huabokereka doʼtaj eʼhuaaʼtaʼ pakhueʼ i̱jje̱y. ");
INSERT INTO amrNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Opud judío huairia Diostaj diʼ ehueʼ o̱ʼne doa onʼtinopo̱e̱ne. ");
INSERT INTO amrNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Apag Diosa doʼtaj meʼtaʼmonaʼuyne. Opudomeya̱nayo doʼtaj eʼnigpe̱e̱taʼ pakhueʼ o̱ʼnene. Nog huabokerektaj Diosa taʼmonahueʼ e̱e̱ʼtada opudte eʼbahuatiaknayo kentanayo moʼnigpe̱e̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","“Huadakda moʼe̱ne.” Aratbuta enataʼ eʼpe̱e̱taʼ boʼpakikaʼ. “Huadakda moʼe̱ne.” Diosa enataʼ eʼpe̱e̱taʼ pakhueʼ moʼe̱ne. Kenaʼpo Diosyaʼ oʼtiakuy oknopo̱e̱hueʼdik o̱ʼnene. ");
INSERT INTO amrNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Opudtaj, “dakhueaʼ o̱gkikaʼ.” Apag Diostaj Jesúsa beʼhuaaʼapone. Nopo̱e̱hueʼ yaneʼ. “Opuda̱ dakhueaʼ bokikaʼuynig.” Moisésanayo kenda boʼhuaaʼapone. Moiséstaj namaʼda boaʼikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Moisésa doʼtaj oʼtimadoyaʼuyate. Opuda̱ Moiséstaj hueretda oknopo̱e̱hueʼ moʼe̱po kenaʼpo doʼtaj oknopo̱e̱hueʼ o̱ʼnene. ");
INSERT INTO amrNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Kenda Moiséskudaka oʼmadoyaʼuyate oknopo̱e̱hueʼ e̱e̱ʼnayo, doʼhued huaʼataj kenpaʼti oknopo̱e̱hueʼ moʼe̱a̱pone. —‍Jesúsa judío huairitaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ken, Galilea e̱ʼpo̱g konogda oʼdikkaʼ Tiberias. Nogok Galilea e̱ʼpo̱g Jesús oktegʼuy. Oroʼomeyere okteguy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Jesús eʼhuaʼte huakkaʼada aratbut onʼtahuaʼpo, kenaʼpo konig Diosyoʼda kaʼdik o̱ʼe̱, konigti Jesúsa nogok nogok oʼkaʼpo, dakhueʼ e̱ʼnetaj oʼbayareaʼuy. Konige̱po huakkaʼada onʼtahuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Aʼti huakupayo oʼbehuikuy. Oroʼomey Jesúsen huanigpe̱i̱kaʼeriere moʼbatohuaduyne. ");
INSERT INTO amrNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Aʼti judío huakurueri isiʼpo mabueyhueʼ e̱e̱ʼ okkahuehueʼ aypo fiesta o̱ʼe̱a̱po. Konige̱po huakkaʼda aratbut o̱ʼnuy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Huakkaʼda aratbut o̱gkupopakdepo enʼbatiakte Jesúsa oʼbatiahuayʼuy. Felipetaj —‍¿Huakkaʼda onʼbatiakde kanʼbapeʼpo meya̱ʼ pan oʼbaeyapet? —‍Jesúsa Felipetaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Menpaʼti Felipea oaʼapo eʼnopo̱e̱ʼtaʼ oʼpakpo onaʼuy. Kenda ijkaʼapoy soatayoʼ Jesúsa oʼnopo̱e̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","—‍Pan huabaeʼ doscientos denarios huakupe e̱e̱ʼnayo ayaʼada aratbuta sueʼpiʼ pan bapehueʼdik o̱ʼne. —‍Felipea onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","9","—‍Huabokereksiʼpoa nogmanigtida cebadao̱gʼ pan bottaʼ biigere oʼto̱e̱nigʼa kenniga aratbuta kate bapehueʼdik o̱ʼnenok. —‍Andrésa, Simón Pedroen huamaʼbuy o̱ʼe̱po onaʼuy. Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","—‍“Yanʼbahuad.” Yanʼmanaʼ. —‍Jesúsa oroʼtaj monaʼuyne. Kenteda huakkaʼda mire̱ o̱ʼu̱yate. Ken ayaʼda onʼbahuaduy. Cinco mil huabokerek o̱ʼnuy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesúsa pan oʼto̱e̱po Diostaj dakiti oʼtionaʼpakuy. Oroʼomey keʼnen huanigpe̱i̱kaʼeritaj oʼposakeaʼpo boʼyokeʼpo aratbut enʼbahuadte oroʼomeya̱ oʼbayokeʼuy. Konigti biig oʼmanokpukpukpo boʼyokeʼnok oroʼomeya̱ oʼbayokeʼuy. Noga̱ huakkaʼ enpakok huakkaʼ oʼbayokeʼuy. Dapoteyaʼda onʼbapeʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kenokaʼ ayaʼda dapotey e̱ʼnedeʼte, —‍Pan huaboroʼ huaenmo boroʼtaʼsujmonere bapehueʼ eneʼ yanʼbaeaʼ. Ken sigpiʼ parahueʼdik ka̱e̱ʼpo. —‍Oroʼtaj monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ken oʼbaeaʼuy. Doce kusogyo̱ cebada pan boroʼtaʼsujmon hueda̱ʼhueda̱ʼda oʼkuda̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Kenda konig Diosayoʼda kaʼdik o̱ʼe̱ Jesúsa konigti oʼkaʼnok aratbuta onʼtiahuaypo, —‍Diosen huaʼa huamanbatiaʼpakeri oroʼomeytaj moʼnigtiakapone, Apag Diosbaʼa oaʼ. Kentaj e̱kpo̱e̱ʼ o̱ʼnigunhuahuikaʼuy. Dapiʼ Jesús Diosen huaʼa huamanbatiaʼpakeri o̱ʼe̱. —‍Judío aratbuta onʼbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesústaj monʼtohuaʼ. Oroʼomeyen gobierno huairi ka̱e̱ʼ. Huakkaʼ aratbut e̱gkupopakte huanopoyaʼda onʼnopo̱e̱ʼuy. Jesúsa oʼnokotpo, oʼbakhuaʼpo nogtiaʼda oteʼyo oʼbakbehuikuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Ken osikdenok oroʼ Jesúsen huanigpe̱i̱kaʼeri e̱ʼpo̱gte oʼhuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Kusiʼpeyo oʼbakudpo, Capernaum huakkaʼ jakyo e̱ʼpo̱g oʼnoktegpo ektegte oʼbaksikpo, Jesús tiakhued e̱e̱ʼte ");
INSERT INTO amrNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","diga̱ʼda oʼbapokpo e̱ʼpo̱g huakkaʼda oʼkutaʼhuaropakuy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Bidteda eʼhuadeʼte, e̱ʼpo̱g hua̱hue̱tiudte Jesús oʼhuaeʼpo kusiʼpeyo Jesúsa eʼhuatiakte oroʼ oʼtiahuayʼuy. Jesústaj oʼtiahuaypo oʼmeʼpukonʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","—‍Do i̱hue̱y. Meʼpukhueʼ yaneʼ. —‍Jesúsa monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","“Kusiʼpeyo yakud.” Durugteda onaʼdepo, eʼkuddeʼte ijhuiti ehueʼ akodpen oʼhuaʼdepo onʼbetuy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ken emeʼte akodpen huakkaʼda aratbut o̱ʼnuyate. Kente cinco miltaj oʼbatobapeʼuy. ʼIkken nogkusiʼpetida o̱ʼe̱meʼ. Ken kusiʼpeyo Jesús kudhueʼ o̱ʼemeʼnok Jesúsen huanigpe̱i̱kaʼeriomeynayo onʼbakudpo oʼnokbahuameʼnok onʼbatiahuayaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tiberias huakkaʼ jakyaʼ kusiʼpe oʼbatiakuyate. Huakkaʼda aratbut onʼbatiakuy. Kente Jesús Huairi pantaj dakiti oʼtionaʼpakmeʼ. Pankon onʼbapemeʼ kente ibodteda kusiʼpe oʼbatiakuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Kente Jesústaj huahuayhueʼda keʼnen huanigpe̱i̱kaʼeritaj huahuayhueʼda huakkaʼda aratbut kusiʼpeyo onʼkudonpo Jesústaj oʼdukpo Capernaumyo onʼhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ken akodpen kusiʼpete onʼbetdepo Capernaumyo Jesústaj oʼdukpo, onhuahuaydepo, —‍¿Menokaʼ i̱yo̱da iʼtiak, Huamanmadikaʼeri? —‍Oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","—‍Konig Diosyoʼda teyda kaʼdik o̱ʼe̱, do konigti ijkaʼdemeʼnigʼa kenda doʼtaj oknopo̱e̱hueʼ o̱ʼnene. Pan ijbiameʼnok opudomey dapoteyaʼda moʼbapemeʼpo, kenaʼpo doʼtaj oʼdukne. Aypoyoʼda boʼpakne. Buttida oʼnonaʼne. ");
INSERT INTO amrNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Aypo kenpaʼti katetapiʼ boʼeretpakpiʼ, aʼbaeyaʼpo moʼbaaʼpopiʼ, boʼkikaʼnigʼa aypo kenpaʼti nogda aʼti ehueʼ o̱ʼe̱a̱po. Konige̱po aypoyoʼda kenpaʼti katetapiʼ eretpakhueʼ yaneʼ. Kikahueʼ yaneʼ. Aypoanayo moʼmanoteypakpo sueʼpiʼ moʼnoeaʼne. Doanayo Diosere manoeanhuahuikaʼdik o̱ʼnene. Do huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne. Doʼtaj mederetpakpo meʼnoknopo̱e̱ʼ. Diosa beʼtihuapoknok ijbayareaʼmey kenpaʼti konig Diosyoʼda teyda kaʼdik o̱ʼe̱, konigti ijkamey. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","—‍Diosen eʼkaʼtaʼ oʼpaki. ¿Diosen huaʼa aʼkayaʼpo kate kaʼdik o̱ʼe̱y oroʼ? —‍Jesústaj namaʼda oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","—‍Opudte Diosa meʼtaʼmonaʼuyne. Doʼtaj meʼnoknopo̱e̱ʼ. Kenda Diosa oʼpak. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","—‍Oroʼomeya̱ ontaj meʼnoknopo̱e̱ʼpo konig Diosyoʼda oʼkikaʼ, konigti yakaʼ. Konig Diosa ʼuruaʼnanada oʼkikaʼ o̱ʼna konigti ekaʼnayo oknopo̱e̱a̱poy. Diosyaʼ oʼtiakuyate oknopo̱e̱a̱poy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Aʼnennada oroʼomeyen adhueaʼpaneʼtaj Moisésa oʼbatohuaeʼikaʼuyate. Aratbut ehueʼ e̱ʼhua̱e̱ʼi̱kaʼyo oʼbatohuaʼikaʼuyate. “Maná aypo kurudya̱ʼ oʼbatobapeʼikaʼuyate.” Apagbaʼ oaʼ. —‍Jesústaj oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","33","—‍Aʼnennada kurudya̱ʼ maná aypo Moisésa oʼbayokikaʼuyate namaʼda moʼnopo̱e̱nigʼa Moisésa bayokhueʼ o̱ʼu̱yate. Kurudya̱ʼ Diosa maná aypo oʼbayokonhuahuaʼikaʼuyate. Maná ayponayo manoeanhuahuikahueʼdik o̱ʼe̱. Kurudya̱ʼ doʼhued Apag Dios meʼtaʼmonaʼuyne. Konig aypo huamanoeanhuahuikaʼeri i̱jje̱y. Aratbuttaj aʼmanoeanhuahuikayaʼpo ijtiakuy. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","—‍Kenda aypo boʼyokikaʼne, huairi. —‍Jesústaj nopoenkahueʼ e̱ʼe̱a̱da oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","—‍Konig aypo huamanoeanhuahuikaʼeri i̱jje̱po aratbuttaj manoeanhuahuikaʼdik i̱jje̱y. Ayaʼada onʼnopoʼkorepo doʼtaj moknopo̱e̱po moʼnigpe̱i̱kaʼpo konig noteyda durugnopoʼda o̱ʼneonhuahuikaʼapo. Onʼnopoʼnoeyonhuahuikaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Opudomeynayo doʼtaj pakhueʼ o̱ʼnepo doʼtaj oknopo̱e̱hueʼ o̱ʼnene. Konig huaboaʼda oʼnonaʼpo, doʼtaj eʼtiahuaymeʼpiʼ oknopo̱e̱hueʼ o̱ʼnene. ");
INSERT INTO amrNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Apag Diosa doʼte ayaʼtada moʼtaʼmonaʼne doʼtaj moknopo̱e̱a̱pone kenpaʼti doʼtaj moʼnigpe̱i̱kaʼapone. Kenomeya̱ doʼtaj meʼnoknopo̱e̱nok ijbaeʼapoy, maenhueʼdik i̱jje̱a̱poy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Kenaʼpo kurudya̱ʼ ijtiakuy Diosa meʼtaʼmonaʼuynok. Keʼnen eʼkaʼtaʼ ijpakpo ijtiakuy. Do huataʼda eʼkaʼtaʼ pakhueʼ i̱jje̱po ijtiakuy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Huakkaʼ Diosataj huaknopo̱e̱ʼeri meʼbayokuyne nogtipiʼ titikhueʼ moʼe̱a̱pone. Keneʼhua̱ya̱ʼ huameʼnoete ayaʼtada ijmanoyhuada̱ʼapoy. Kenda oʼpakpo Diosa meʼtaʼmonaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Diosa oʼpakpo kenomey doʼtaj oʼnoknopo̱e̱ne, do Diosen Huasiʼpo o̱ʼe̱ oʼnoknopo̱e̱po kenda moʼbatiaʼpakpo Diosere onʼnoeonhuahuikaʼpo keneʼhua̱ya̱ʼ huameʼnoete onteʼti kenomeytaj ijmanoeaʼapoy. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","“Do konig aypo huamanoeanhuahuikaʼeri i̱jje̱y. Kurudya̱ʼ doʼhued Apag Diosa meʼtaʼmonaʼuyne.” Jesúsa oaʼnok judío huairia Jesústaj onʼhuadiaypo onʼhuamahui̱ʼi̱a̱ʼpo, ");
INSERT INTO amrNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","—‍In huabokerek Jesús o̱ʼe̱. Joséensiʼpo o̱ʼe̱. Keʼnen huaoj keʼnen hua̱ye̱kon o̱ki̱e̱y. “Kurudya̱ʼ Diosa meʼtaʼmonaʼuyne.” ¿Menaʼpo kenpaʼ aʼdik ya̱ʼe̱? —‍Judío huairia onpapayoʼ onʼbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","—‍Onpapayoʼ huaahueʼ meneʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Apag Diosa meʼtaʼmonaʼuyne. Huakkaʼtada Diosa oʼbatihuapokpo, doʼtaj huaknoponhuaʼ oʼbatihuapok. Kenomey huaknopo̱e̱ʼeritaj ijmanoyhuada̱ʼapoy. Keneʼhua̱ya̱ʼ huameʼnoete ijmanoyhuada̱ʼapoy. Diosere onʼnoeonhuahuikaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","“Diosa ayaʼtada oʼmanopo̱e̱a̱ʼapo.” Diosen huaʼa huamanbatiaʼpakeria oʼmadoyaʼuyate. Konige̱po ayaʼada Apagtaj onʼpe̱e̱po oʼnoknopo̱e̱po doʼtakon moʼnigpe̱i̱kaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Apag Diosyaʼ ijtiakuy, doʼayoʼda Apagtaj ijtiahuayikaʼuy. Nogomeynayo Apagtaj tiahuayhueʼ o̱ʼnikameʼte. ");
INSERT INTO amrNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Kenomey doʼtaj oʼnoknopo̱e̱po Diosere onʼnoeonhuahuikaʼapo. Buttida ijjay. ");
INSERT INTO amrNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Do konig aypo huamanoeanhuahuikaʼeri i̱jje̱y. Aratbuttaj ijmanoeanhuahuikaʼapoy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Aratbut ehueʼ e̱ʼi̱kaʼyo opuden adhueaʼpaneʼ o̱ʼneonhuahuikaʼuyate. Diosa maná aypo eʼbayokikaʼtada Diosere noeonhuahuikahueʼ o̱ʼnuyate. Onʼmabueyʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nog aypo o̱ʼe̱. Huamanoeanhuahuikaʼ aypo o̱ʼe̱. Donayo konig huamanoeanhuahuikaʼ ayponig i̱jje̱y. Kurudya̱ʼ ijtiakuypo. Konig huamanoeanhuahuikaʼ aypo enʼbapeʼnayo, bueyhueʼ onʼnoeonhuahuikaʼapo. Kenda huamanoeanhuahuikaʼ ayponig i̱jje̱y. ");
INSERT INTO amrNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Aypo huamanoeanhuahuikaʼ do konig aypo i̱jje̱y. Kurudya̱ʼ Diosenbayaʼ ijtiakuypo, ayaʼada in aypo eʼbapeʼnayo Diosere onʼnoeonhuahuikaʼapo. Ken huamanoeanhuahuikaʼ aypo konig doʼhued hua̱so̱ʼ o̱ʼe̱. Aratbut kanʼnoeonhuahuikeʼpo ijmanigbueyapoy. Doʼtaj oknopo̱e̱ʼdik moʼe̱ne. —‍Oʼmanbatiaʼpakpo kenda Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Huayahuaya judío huairia onʼbatiaʼpakpo, —‍Menpaʼ keʼnen hua̱so̱ʼ peʼdik o̱ʼe̱nok yaaʼ. —‍Onʼbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","—‍Do Huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne doʼhued hua̱so̱ʼ bapehueʼ e̱e̱ʼnayo, doʼhued mimi mayhueʼ e̱e̱ʼnayo onteʼti Diosere noeonhuahuikahueʼ moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Kenomey doʼhued hua̱so̱ʼ onʼbapeʼpo kenpaʼti doʼhued mimi onʼmaiʼpo Diosere onʼnoeonhuahuikaʼapo. Diostehuapaʼ keneʼhua̱ya̱ʼ huameʼnoete kenomeytaj ijmanoeaʼapoy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","56","Kenda oʼnonaʼnig doʼhued hua̱so̱ʼ huamanoeanhuahuikaʼ aypo o̱ʼe̱. Doʼhued mimi buttida huamaiʼ mimi o̱ʼe̱. Ayaʼada doʼhued hua̱so̱ʼ onʼbapeʼpo doʼhued mimi onʼmaiʼpo doyoyoʼ o̱ʼnikaʼ. Do kenpaʼti kenomeyere i̱ji̱kay. ");
INSERT INTO amrNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Doʼhued Paga̱ meʼtaʼmonaʼuyne. Apaga oʼnoeonhuahuikaʼpo doʼtakon meʼnoeanhuahuikaʼne. Ayaʼada konig doʼtaj moʼbapeʼpo doʼtaj moknopo̱e̱po doere onʼnoeonhuahuikaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Do konig aypo huamanoeanhuahuikaʼeri ka̱e̱ʼpo kurudya̱ʼ Diosa meʼtaʼmonaʼuyne. Aʼnennada adhueaʼpaneʼtaj Diosa maná aypo kurudya̱ʼ oʼbayokikaʼuyate. Eʼbapeʼikaʼada nogok onʼmabueyʼuyate. Ayaʼda doʼtaj moknopo̱e̱po konig huamanoeanhuahuikaʼ aypo onʼbapeʼpo Diosere onʼnoeonhuahuikaʼapo. —‍Jesúsa judío huairitaj oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Capernaum huakkaʼ jakyo judío aratbuten hua̱i̱takeʼ jakyo Jesúsa oʼmanmadikaʼpo kenda oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Sueʼda huakkaʼmon Jesúsen huanigpe̱i̱kaeria onʼpeeondepo, —‍Jesúsa oʼmanmadikaʼ kenda kahueʼdik o̱ʼe̱ne. Menpaʼ beʼapi nigpe̱e̱ʼdik ya̱ʼnet. —‍Kenomeya̱ onʼbatiaʼpakʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Keʼnen huanigpe̱i̱kaʼeri kenda onʼbatiaʼpakpo Jesúsa oʼnopo̱e̱po, —‍¿Doʼhued huaʼataj menpaʼ nigpe̱e̱hueʼdik moʼe̱? ");
INSERT INTO amrNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Do Huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne ke̱yo̱ kurudyo̱ i̱ji̱kaʼuy eʼbehuikte opuda̱ onʼtiahuaydepo menpaʼ doʼtaj moknopo̱e̱a̱pet? ");
INSERT INTO amrNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Diosen Noki̱re̱ga̱ oʼmanoeanhuahuikaʼ. Aratbuten hua̱so̱ʼa̱nayo manoeanhuahuikahueʼ o̱ʼe̱. Doʼhued huaʼa ijmanay konig Diosen Noki̱re̱g oʼmanoeanhuahuikaʼapo. Doʼhued huaʼataj moknopo̱i̱kaʼpo moʼnigpe̱i̱kaʼpo Diosere moʼnoeonhuahuikaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Kenda ijjaʼdenigʼa opudomey sueʼada oknopo̱e̱hueʼ o̱ʼnene. —‍Jesúsa oʼmanaʼuy. Ken huakkuruda Jesúsa aʼmanmadikayaʼpo tiakhued o̱ʼe̱poed beʼati doʼtaj oknopo̱e̱hueʼ meʼneapone Jesúsa oʼnopo̱i̱kaʼuyate. Kenpaʼti Judasa kadarakeʼpo beʼtitotiakapone Jesúsa oʼnopo̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","—‍Do Diosen Huasiʼpo i̱jje̱nok Diosa meʼtaʼmonaʼuyne. Doʼtaj kanoknopo̱e̱ʼpo Diosa eʼtihuapokenayo oknopo̱e̱ʼdik moʼe̱ne. Doʼtaj kanoknopo̱e̱ʼpo Diosa tihuapokhueʼ e̱e̱ʼnayo oknopo̱e̱hueʼdik moʼe̱ne. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kenda eʼmanadeʼte huakkaʼada keʼnen huanigpe̱i̱kaʼeriomeya̱ oʼnoknopo̱e̱batikuy. Onteʼti kenere taʼhuaehueʼ o̱ʼneʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","—‍¿Opud kenpaʼti menpaʼ eknopo̱e̱batiktaʼ boʼpak? —‍Jesúsa oroʼ doce huamataʼmonaʼeritaj monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","—‍Ehueʼ, Huairi, o̱ʼna huanoeonhuahuikaʼ huaʼa onaʼikaʼne. ");
INSERT INTO amrNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Cristo i̱ʼe̱po, Diosen Huasiʼpo i̱ʼe̱po ontaj Diosa bektieʼeaʼuyate, Huairi. —‍Simón Pedroa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","—‍Opud, doce huamataʼmonaʼeri ijbaktieʼeaʼuynigʼa, opuda̱ nogtatida totoʼ huairia moʼnopoʼto̱e̱a̱pone. —‍Jesúsa monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Simónensiʼpo Judas Iscariotetaj oʼbatiaʼpakpo kenaʼpo ken doce huanigpe̱i̱kaʼeriyaʼ kadarakeʼpo oʼbatotiakapo Jesúsa oʼnopo̱e̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Nogok Galilea huadaribayo Jesúsa nogi̱ti oʼmanmadikadhuahuikaʼuy. Nogyo̱ nogyo̱ oʼhuaʼepo oʼmanmadikadhuahuikaʼuy. Kenokaʼ Judea huadaribayo nogyo̱ nogyo̱ eʼmanmadikaʼtaʼ pakhueʼ o̱ʼu̱y Jesúsa. Judeayo judío huairia eʼaraktaʼ onʼtipaknok. ");
INSERT INTO amrNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Aʼtimon judíoen baak fiesta o̱ʼe̱a̱po, Jerusalénya̱ʼ o̱ʼe̱a̱po. Siete huameʼnoe fiesta o̱ʼe̱a̱po. Ayaʼda judío huabokerek onʼbahuaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Kenokaʼ Jesúsen huamaʼbuy Jesúste onʼhuatiakdepo, oʼnonaʼpo, —‍I̱yo̱ Galileayo i̱kahueʼ ya̱e̱ʼ, egʼ. Fiestate Judeayo monhuaʼ. Huakkaʼda o̱ʼnen huanigpe̱i̱kaʼeri Judeayo o̱ʼne, kenpaʼti ʼuruaʼda Diosen iʼkikaʼnig kanʼtiahuayeʼpo. Konige̱po Judeayo monhuaʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ontaj huakkaʼada eknopo̱e̱ʼtaʼ eʼpaknayo, ontaj huakkaʼada eʼnigpe̱i̱kaʼtaʼ eʼpaknayo i̱yo̱ sueʼda aratbut eʼnahue̱ʼyo̱ ehueʼdik i̱ʼe̱ne. Ke̱yo̱ huakkaʼda aratbut eʼnahue̱ʼyo̱ huaʼdik i̱ʼe̱ne. Huairi o̱ʼe̱ aratbuta meʼnoknopo̱e̱ʼpo huakkaʼ aratbut e̱gkupopakyaʼ ʼuruaʼnanada yamanigkikaʼ, konig Diosayoʼda kaʼdik o̱ʼe̱ yamanigkikaʼ, yabayareaʼ. —‍Jesúsen huamaʼbuya Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Diosa Jesústaj oʼtaʼmonaʼuyate kenpaʼti Jesús Diosen Huasiʼpo o̱ʼe̱ Jesúsen huamaʼbuy oknopo̱e̱hued e̱ʼe̱a̱da kenpaʼ oʼnonaʼuyate. Jesúsere ehuaʼtaʼ onʼpakpoda kenpaʼ oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","—‍Oy huameʼnoenayo fiesta Jerusalényo̱ huahueʼdik i̱jje̱y. Opudnayo menokapiʼ boʼpakpo huaʼdik moʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Huakkaʼ aratbuta doʼtaj oknopo̱e̱hueʼ o̱ʼne. Konigti oknopo̱e̱hueʼ o̱ʼnene doʼtaj. Konige̱po kenomeya̱ opudtaj huadiayhueʼ moʼe̱ne. “Diostaj dakhueaʼ boʼkikaʼne. Diostaj nigpe̱e̱hueʼ moʼi̱kaʼne.” Kenomey oknopo̱e̱hueʼ hua̱e̱ʼeritaj ijmanikaʼnok konige̱po doʼtaj diga̱ʼda menhuadiayikaʼne. ");
INSERT INTO amrNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Fiestayo yanʼbahuatiʼ. Donayo huahued i̱jje̱y. Oy huahueʼdik i̱jje̱y. —‍Jesúsa huamaʼbuytaj oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Kenda Jesúsa eʼnadeʼte huamaʼbuya oʼnokhuaʼuy. Jesúsnayo Galileayo o̱ʼi̱kaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Jesúsen huamaʼbuy kenpaʼti ayaʼ huabokerekomey fiestate Jerusalényo̱ onʼhuaʼdepo dagte aratbutbahueʼ o̱ʼnenok Jesúskon Jerusalényo̱ oʼhuaʼuy. Aratbut Jesústaj tiahuayhueʼ oʼmaepo Jesús oʼhuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jesús Jerusalényo̱ o̱kye̱hued e̱e̱ʼte judío huairiomeya̱ Jesústaj oʼnonmabopo, —‍¿Kenbokerek meyon ya̱ʼe̱? —‍Judío huairia onʼhuaaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Jesústaj huakkaʼada onʼtiaʼpakpo, “Huadakda o̱ʼe̱.” Huakkaʼada onʼtiaʼpakpo, “Dakhueʼda o̱ʼe̱. Namaʼda oʼmanmadikaʼ. Aratbuttaj engaña oʼmagkaʼ.” Nogomey huakkaʼada onʼtiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Huayahuaya utak utakaʼ onʼbatiaʼpakpo judío huairitaj onʼmeʼpukpo huakkaʼ aratbuttaj ʼuttaʼ batiaʼpakhueʼ o̱ʼnuy. ʼUttaʼ Jesústaj batiaʼpakhueʼ o̱ʼnuy. ");
INSERT INTO amrNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Fiesta bapaʼmeʼnoe o̱gkaʼdepo konig fiesta nopote e̱e̱ʼte Diosen jakyo Jesús oʼhuaʼpo o̱kye̱depo huaboaʼda oʼmanmadikaʼuy. Huakkaʼda aratbut e̱gkupopakdeʼte oʼmanmadikaʼuy. ʼUruaʼnada oʼmanmadikaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Ken judío huairi Jesústaj onʼpe̱e̱depo onʼmepuʼkepo onʼhuadiaypo, —‍Oroʼen escuelayaʼ Diosbaʼ madoyahueʼ o̱ʼi̱kaʼuy Jesús. Kentaj onmadikahueʼ o̱ʼi̱kaʼuy. Konige̱po sigpiʼ nopo̱e̱hueʼ o̱ʼe̱. Buttida oʼnonaʼne. —‍Judío huairia Jesústaj oknopo̱e̱hueʼ o̱ʼnepo huakkaʼ aratbuttaj namaʼda onʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","—‍Doʼhuedda ijpakpo manmadikahueʼ i̱jje̱y. Diosa meʼtaʼmonaʼuyne. Kenda Diosa meʼnopo̱e̱a̱ʼnok ijmanmadikikay. Diosen buttida huaʼa ijmanmadikikay. ");
INSERT INTO amrNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Doʼtaj onʼpe̱e̱po ayaʼada Diostaj eʼnigpe̱i̱kaʼtaʼ onʼpakpo kenda Diosa meʼnopo̱e̱a̱ʼnig ijmanmadikikay dakaʼ kenda onʼnopo̱e̱a̱po. Doʼhuedda ijnopo̱e̱po manmadikahueʼ i̱jje̱y kenomeya̱ kenpaʼti onʼnopo̱e̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Nogomey huakkaʼada onda onʼnopo̱e̱po onʼmanmadikikaʼ. “Keʼna huadakda huamanmadikaʼeri o̱ʼe̱.” “Huadakda o̱ʼe̱.” “Huairi o̱ʼe̱.” Aratbuta eʼhuaaʼte eʼpe̱e̱taʼ onʼpakpo onʼmanmadikikaʼ. Doʼtanayo Diosa meʼtaʼmonaʼuyne. “Huadaknanada o̱ʼe̱ Dios.” “Huaboroʼnanada huairi o̱ʼe̱ Dios.” Opuda̱ eʼhuaaʼte eʼpe̱e̱taʼ ijpakpo buttida huaʼayoʼda ijmanmadikikay. Sigpiʼ da ahueʼ i̱ji̱kay. ");
INSERT INTO amrNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Moisésa Diosen huaʼa oʼmanaʼuyate. Diosen huaʼa buttida o̱ʼe̱. Moisésbaʼ moʼbaʼto̱i̱kaʼne. Kenda eʼnopo̱e̱a̱da ayaʼada nigpe̱e̱hueʼ moʼi̱kaʼne. Moisésbaʼtaj nigpe̱e̱hueʼ moʼi̱kaʼne. ¿Doʼtaj menaʼpo eʼaraktaʼ onʼtipak? —‍Jesúsa judío huairitaj oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","—‍Dakhueʼ noki̱re̱ga̱ meʼnopoʼto̱e̱nok huasegda i̱ʼe̱po iaʼne. Beʼapiʼ ontaj eʼaraktaʼ pakhueʼ o̱ʼne. —‍Aratbuta Jesústaj namaʼda oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","—‍Huabokerek treinta y ocho huabayok dakhueʼda o̱ʼe̱po onpahuedonhuahuikaʼuyate. Okmapi̱e̱ʼahuaddik huameʼnoete ijyareameʼnok huakkaʼ moʼmepuʼkeʼpo doʼtaj onʼhuadiayne. ");
INSERT INTO amrNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Huabokereksiʼpotaj yo̱bedtaj huasiʼdak oktegdik yanikatiʼ, opudomeyen adhueaʼpaneʼa̱ monaʼuyate. Moisésa konigti monaʼuyate. Konige̱po Moiséstaj moʼnigpe̱e̱po huabokereksiʼpotaj ocho huameʼnoe eʼnoedeʼte huasiʼdak boktegikaʼ. Okmapi̱e̱ʼahuaddik huameʼnoe e̱e̱ʼpiʼ boktegikaʼne. ");
INSERT INTO amrNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Okmapi̱e̱ʼahuaddik huameʼnoete kahueʼdik moʼe̱ opudomey moʼmanaʼikaʼnigʼa okmapi̱e̱ʼahuaddik huameʼnoe e̱e̱ʼpiʼ Moiséstaj moʼpe̱e̱po huabokereksiʼpoensiʼdak boktegikaʼne. Huabokerek dakhueʼda o̱ʼe̱po treinta y ocho huabayok enpahuedonhuahuikadeʼte okmapi̱e̱ʼahuaddik huameʼnoete ijyareameʼnok doʼtaj onhuadiaymeʼne. ¿Menaʼpo onhuadiaymeʼ? Namaʼnanada onhuadiaymeʼne. ");
INSERT INTO amrNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Doʼa eʼyareaʼte onʼtiahuaymeʼpo dakhueaʼ oʼkaʼ namaʼda onʼtinopo̱e̱po onʼhuadiaypo doʼtaj eʼaraktaʼ onʼtipakne. Konige̱po Dios ken huabokerektaj oʼmatinepahuiʼpo diʼ o̱ʼe̱nok ijyareaʼmey. Opudomey kenda nokotdik moʼe̱. Okmapi̱e̱ʼahuaddik huameʼnoete eʼbayareaʼ huadakda o̱ʼe̱ yanʼnopo̱e̱ʼ. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","—‍In huabokerektaj judío huairia aʼarakyaʼpo oʼderetpakpo ");
INSERT INTO amrNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","i̱yo̱ Diosen jakyo eʼmanmadikaʼte judío huairinayo tohuahueʼ o̱ʼne. Diosa oʼtaʼmonaʼuy, Diosen Cristo o̱ʼe̱. Dapiʼ judío huairia kenda oknopo̱e̱hueʼ o̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Keʼna Cristo ehueʼ o̱ʼe̱. Konige̱po Jesús Galileayo hua̱e̱ʼeri o̱ʼe̱ oʼnopo̱e̱y. Cristo eʼtiakdeʼte meya̱ʼ yaʼtiaket nopo̱e̱hueʼdik o̱ʼe̱a̱poy. —‍Sueʼda Jerusalényo̱ hua̱e̱ʼeria huaboaʼda namaʼda huayahuaya onʼmanbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Kenda aratbuta namaʼda onʼbatiaʼpakpo Jesúsa oʼnopo̱e̱po huakkaʼ aratbut e̱gkupopakte oʼmanmadikaʼpo ʼuttaʼda oʼmanaʼpo, —‍Doʼtaj o̱ki̱e̱hueʼ o̱ʼnene kenpaʼti ke̱ya̱ʼ oʼtiakuy opudomeya̱ oknopo̱e̱hueʼ o̱ʼnene. Do huataʼda ijpakpo tiakhueʼ i̱jje̱ʼuy. Dios kurudyo̱, hueretda Diosa oʼpakpo meʼtaʼmonaʼuyne. Opudomeynayo hueretda Diostaj oknopo̱e̱hueʼ moʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Hueretda Diosa meʼtaʼmonaʼuynok Diosyaʼ ijtiakuy. Konige̱po Diostaj yoknopo̱i̱kay. Diostaj yo̱ki̱e̱y. Buttida aʼdik i̱jje̱y. —‍Jesúsa ʼuttaʼda oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Jesústaj judío huairia onʼhuadiaypo eʼbakuda̱ʼ jakyo enʼtohuaʼtaʼ enʼtipaktada Diosa Jesústaj oʼtiokaʼnok tohuahueʼdik o̱ʼnuy. Jesús kenok huabuey ehued o̱ʼta̱e̱nok. ");
INSERT INTO amrNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Nogomey huakkaʼ judío aratbut o̱gkupopakpo Jesústaj onʼpe̱e̱po Jesústaj oʼnoknopo̱e̱ʼuy. —‍Kenyoʼda Diosen Cristo ʼuruaʼda kikaʼdik o̱ʼe̱a̱po. In huabokerek kenda oʼkikaʼpo. In huabokereka aratbuttaj oʼbayareaʼ. Dapiʼ Diosen Cristo o̱ʼe̱ Jesús. —‍Aratbuta onʼbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Jesús Diosen Cristo o̱ʼe̱. Aratbuta onʼbatiaʼpakpo fariseo huairi kenpaʼti sacerdote huamationaʼpakikaʼeri huairiomeya̱ onʼtipe̱e̱depo onʼhuadiaypo Jesústaj kanʼtohueʼpo kenomeyen sorotataj onʼmataʼmonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Kenokaʼ huakkaʼ aratbut e̱gkupopakte Jesúsa oʼmanaʼpo, —‍Opudomeyere sueʼda puug i̱jje̱a̱poy. Kenokaʼ Diosyo ijkumejapoy. Diosa meʼtaʼmonaʼuynig ke̱yo̱da ijhuaʼapoy. ");
INSERT INTO amrNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Nogok doʼtaj oʼdukaponigʼa huahuayhueʼdik o̱ʼneapone. Doʼtaj oknopo̱e̱hueʼ o̱ʼnepo konige̱po doʼtaj huatiakhueʼdik o̱ʼneapone. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Judío aratbuta onʼpe̱e̱depo huayahuaya onʼbatiaʼpakpo, —‍¿In huabokerek kaʼtiaʼ yaaʼ? ¿Meyon yahuaʼapet oroʼ huahuayhueʼdik o̱ʼe̱a̱pone? Nog huadaribayo ke̱yo̱ judío aratbut onʼmamonʼuyate nog aratbuttaj kamanmadikeʼpo yahuaʼapetdapiʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","“Doʼtaj oʼdukaponigʼa huahuayhueʼdik o̱ʼneapone.” “Doʼtaj oknopo̱e̱hueʼ o̱ʼneapo konige̱po doʼtaj huatiakhueʼdik o̱ʼneapone.” Jesúsa oʼmanaʼ. ¿Kaʼtiaʼ yaaʼ? —‍Judío aratbut huayahuaya onʼbatiaʼpakpo. ");
INSERT INTO amrNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Fiesta keneʼhua̱ya̱ʼ huameʼnoete ʼuruaʼda o̱gkikaʼuyate. ʼUrumeʼnoe o̱ʼi̱kaʼuyate. Kenmeʼnoete Jesúsa oʼbopo huakkaʼ aratbuttaj ʼuttaʼda oʼmanaʼpo, —‍Beʼapiʼ durugnopoʼ e̱e̱ʼtaʼ eʼpaknayo doʼtaj kanʼnoknopo̱e̱ʼ doʼtaj kanʼnigpe̱e̱ʼ ijmanopoʼdurugpakikaʼapoy. Konigti beʼapiʼ maymaya̱ʼ eaʼnayo hue̱ʼe̱y ijbayoknok onʼdurugpakapo. ");
INSERT INTO amrNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Konig Diosbaʼ oaʼpo, konig huakkaʼ hue̱ʼe̱y onʼmayikaʼpo durugda o̱ʼneonhuahuikaʼpo konigti kenomey doʼtaj beknopo̱e̱po durugnanada onʼnoeonhuahuikaʼapo, Diosere durugteda onʼnoeonhuahuikaʼapo. Nogomeytakon onʼmanoeanhuahuikaʼapo. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesúsen huaknopo̱e̱ʼeritaj Diosen Noki̱re̱ga̱ oʼmanopoʼto̱e̱a̱po. Diosen durugteda o̱gkikaʼapo. Jesúsa kenpaʼ oʼbatiaʼpakuy. Enʼbatiaʼpakte Diosa keʼnen Noki̱re̱g huaknopo̱e̱ʼeritaj manigtaʼmonahued o̱ʼe̱po konige̱po Jesús bueyhued o̱ʼe̱po, kurudyo̱ huahued o̱ʼe̱po, Diosere ehued o̱ʼe̱po. ");
INSERT INTO amrNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Kenda Jesúsa eadeʼte, —‍Kentaj oʼnonmabodhuahuikaʼuy Diosen huamanbatiaʼpakeri Jesús o̱ʼe̱. —‍Huakkaʼada oʼdaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","—‍Diosa oʼtaʼmonaʼuyate. Cristo o̱ʼe̱. —‍Nogomeya̱ oʼdaʼuy. —‍Ehueʼ. Cristo ehueʼ o̱ʼe̱. Galilea hua̱e̱ʼeri o̱ʼe̱. Galileayo hua̱e̱ʼeria Cristo ehueʼdik o̱ʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Cristo David huairien adhueaʼ huayayo o̱ʼe̱a̱po. Belényo oʼsiʼpoe̱ʼapo kenteda David oʼsiʼpoe̱ʼuyate. —‍Nogomeya̱ oʼdaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Huakkaʼada Jesústaj oʼnoknopo̱e̱ʼuy. Nogomeya̱ oknopo̱e̱hueʼ o̱ʼnuy. ");
INSERT INTO amrNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Huakkaʼada kanʼkude̱ʼpo eʼtohuaʼtaʼ eʼpakada tohuahueʼ o̱ʼnuy. ");
INSERT INTO amrNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Fariseo huairitaj kenpaʼti sacerdote huairitaj kenomeyen sorotataa onʼkumeʼuy. Jesústaj totiakhueʼada onʼkumeʼuy. —‍Jesústaj yanʼtotiak. Oʼnonaʼne. ¿Menaʼpo totiakhueʼ moʼe̱? —‍Huairia onʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","—‍In huabokerek ʼuruaʼnanada oʼmanaʼ. Ken konig manahueʼ o̱ʼi̱kaʼuy. ʼUruaʼnanada oʼmanmadikaʼ. —‍Sorotataa onʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","—‍Menpaʼ Jesúsa opudomeytakon engaña mogkaʼde. ");
INSERT INTO amrNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Oroʼomey ayaʼ huairiada oknopo̱e̱hueʼ o̱ʼe̱y. —‍Fariseo huairikon oknopo̱e̱hueʼ o̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Jesúsen huaknopo̱e̱ʼeria Moisésen huaʼataj nopo̱e̱hueʼ o̱ʼne. Diosa castiga kamagkeʼ. —‍Fariseo huairi onʼhuadiaypo sorotataj huairitaj onʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nicodemo fariseo huairi o̱ʼe̱po aʼnenda sikyo Jesústaj aʼbatiaʼpakyaʼpo oʼtaʼhuadbedʼuyate. Nicodemoa nogomey fariseo huairitaj oʼmanaʼpo, ");
INSERT INTO amrNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—‍Betapiʼ, “Dakhueaʼ oʼkaʼ, castiga ka̱gkeʼpo.” Kenpaʼ ahued kenbokerektaj pe̱e̱ʼdik moʼe̱. Katepiʼ dakhueaʼpiʼ oʼkaʼ huakkuruda nopo̱e̱ʼdik moʼe̱. Kenpaʼ Moisésen eʼmanaʼ o̱ʼe̱. Kenda opudomey moʼnopo̱e̱t. —‍Nicodemoa oʼmanaʼuy. Nog fariseo huairitaj oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","—‍Kaʼtiaʼ, o̱ʼnakon Galilea hua̱e̱ʼeri i̱ʼe̱po iaʼ. Apagbaʼ yatiahuayʼ. Galilea hua̱e̱ʼeri Diosen huamanbatiaʼpakeri ehueʼdik o̱ʼe̱a̱po. Cristo Galileayaʼ tiakhueʼdik o̱ʼe̱a̱po. Apagbaʼtaj iʼtiahuaypo kenda nopo̱e̱ʼdik i̱ʼe̱. —‍Judío huairia onʼdiaypo namaʼda oʼnonaʼuy. Nicodemotaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Jak eʼtahua̱e̱ʼyo ayaʼda onʼbahuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Jesúsnayo oteʼ Olivosyo oʼhuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Emeʼte Diosen jakyo oʼkumeʼuy. Huakkaʼda enʼtikupopakte Jesús oʼhuadpo huaboaʼda oʼmanmadikaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Aʼtimon sueʼda Moisésenbaʼ huamanmadikaʼeri sueʼda fariseo huairi hua̱e̱ʼeriere Jesúste onʼhuatiakuy. Ettoneʼtaj onʼhuatotiakpo, ken ettoneʼ nogbokerekereda eʼbakdejte beʼapiʼ huaboaʼda onʼhuahuaydepo aratbutnopoyoda onʼboaʼpo, ");
INSERT INTO amrNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","—‍In ettoneʼ nogbokerekereda eʼbakdejte onʼhuahuayate. ");
INSERT INTO amrNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ettoneʼ nogbokerekereda eʼbakdejnayo kabueyeʼpo huida̱ yanʼbapaʼikaʼ. Moisésbaʼa kenpaʼ monaʼne, huamanmadikaʼeri. ¿Menpaʼ kaʼdik o̱ʼe̱ oroʼ? ¿Menpaʼ iʼnopo̱e̱ o̱ʼna? —‍Moisésbaʼ huamanmadikaʼeri fariseoere Jesústaj namaʼda kaeʼpo oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Kenda namaʼda Jesúsa kaeʼpo namaʼda oʼnonaʼuy. Jesústaj namaʼda enaʼtadapiʼ kaeʼpo oʼnonaʼuy. Kenokaʼ kenda eʼnonaʼte Jesús ʼikutagpite oʼhuadpo soroktaʼ huabaʼpia oʼmadoyaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","“¿Menpaʼ kaʼdik o̱ʼe̱ oroʼ?” “¿Menpaʼ iʼnopo̱e̱?” Onteʼti Jesústaj namaʼda oʼnonaʼpo, —‍Beʼapiʼ dakhueaʼ kahueʼ eʼhua̱ʼi̱kaʼa huakkuru huida̱ kapaʼeʼ. —‍Jesúsa judío huairitaj oʼmanaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Onteʼti ʼikutagpite oʼhuadpo soroktaʼ huabaʼpia oʼmadoyaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ettoneʼ dakhueaʼ oʼkaʼ. Ayaʼada kenda enadeʼ nogtiaʼ nogtiaʼ huaboaʼda oʼnokbahuukaʼpo oroʼomeykon Diostaj dakhueaʼ oʼkaʼuy onʼnoponpo oʼnokhuaʼuy. Huakkuruda huatoneʼa̱ oʼnokbahuaʼpo nogti nogtiaʼ oʼnokbahuukaʼpo ayaʼada oʼnokbahuaʼdenok ettoneʼyoʼda oʼyahueʼuy. Ettoneʼere Jesúsereyoʼda oʼnunʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesúsa oʼbopo onaʼpo, —‍¿Dakhueaʼ oʼkaʼ boʼhuaaʼnig men ya̱ʼne? Sigpiʼ castiga o̱gkay huaahueʼ moʼe̱ne, ettoneʼ. —‍Jesúsa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—‍Ayaʼ menokbahuaʼne. Sigpiʼ castiga o̱gkay huaahueʼ meʼnene, Huairi. —‍Ettoneʼa̱ Jesústaj onaʼuy. —‍Castiga kanogkeʼ dokon huaahueʼdik i̱jje̱y. Yahuatiʼ. Onteʼti dakhueaʼ kahueʼ ya̱e̱ʼ. —‍Jesúsa ettoneʼtaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Diosen jakyo huakkaʼ aratbut o̱gkupopakuy. Onteʼti Jesúsa oʼmanmadikaʼapo, —‍Diostaj huamaknopo̱e̱a̱ʼeri konig Diosen huakjey i̱jje̱y. Konig Diosen huakjey i̱jje̱po aratbuttaj ijmaknopo̱e̱a̱ʼikay. Konig o̱ʼe̱ Dios huanopo̱e̱ʼ ijmaknopo̱e̱a̱ʼikay. Doʼtaj ayaʼada moknopo̱e̱po moʼnigpe̱i̱kaʼpo Diostakon oʼnoknopo̱e̱a̱po. Huadakda o̱gkikaʼpo Diosere onʼnoeonhuahuikaʼapo. Huakjeyyo o̱ʼneonhuahuikaʼapo. Dakhueaʼ kikahueʼda sikki̱re̱gyo̱ ehueʼ o̱ʼneonhuahuikaʼapo. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","—‍Onda iʼnopo̱e̱po huataʼ iʼtiaʼpakne noga̱ konigti kenda iaʼ tiaʼpakhueʼ o̱ʼnenok namaʼdapiʼ iaʼnok ontaj nigpe̱e̱hueʼdik o̱ʼe̱y. —‍Fariseo huairiomeya̱ Jesústaj oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","—‍Do huataʼda ijtiaʼpaknig buttida o̱ʼe̱. Doʼtaj nigpe̱e̱dik moʼe̱ konige̱po Apag Diosere i̱ji̱kaʼuy, Apag Diosyaʼ ijtiakuy ijnopo̱e̱y. Onteʼti Diosyo ijhuaʼapoy ijnopo̱e̱nok konige̱po doʼhued huaʼa buttida o̱ʼe̱ oknopo̱e̱dik moʼe̱ kenpaʼti doʼtaj nigpe̱i̱kaʼdik moʼe̱ne. Opudomeynayo ke̱ya̱ʼ oʼtiakuy nopo̱e̱hueʼ moʼe̱. Ke̱yo̱ oʼhuaʼapo nopo̱e̱hueʼ moʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Konig aratbuta onʼnopo̱i̱kaʼ opuda̱ moʼnopo̱e̱. Diosyaʼ oʼtiakuy nopo̱e̱hueʼ moʼe̱ne. Da oaʼ oʼnoknopo̱i̱kaʼne. “Dakhueaʼ boʼkikaʼpo bueydik moʼe̱ne,” kamanikeʼpo Diosa taʼmonahueʼ meʼu̱yne. ");
INSERT INTO amrNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Aratbut oknopo̱e̱hueʼ e̱ʼneʼnayo nopoʼkoreahueʼ e̱ʼneʼnayopiʼ “Dakhueaʼ boʼkaʼnok Diosa castiga kamagkeʼ.” Aʼdik i̱jje̱a̱poy. Konige̱po nogtiaʼda ahueʼ i̱jje̱y. Apag Dios doere konigti oʼmanaʼikaʼ. Buttida oaʼ ayaʼada nopo̱e̱ʼdik o̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Aʼnennada Diosen huaʼa Moisésa oʼmanigmadoyaʼuyate. Opudomey Moisésbaʼ moʼto̱e̱ne. Huabokerekpiʼ dakhueaʼ ekaʼnayo dakhueaʼ oʼkaʼ bottaʼbokereka konigti eʼhuaaʼnayo buttida onʼhuaaʼ moʼnopo̱e̱po dakhueaʼ huakaʼeritaj castiga o̱gkaʼdik moʼe̱ne. Moisésa oaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ken do konig Diosen huakjey i̱jje̱po Diostaj huamaknopo̱e̱a̱ʼeri i̱jje̱po ijtiakuy. Diosa meʼtaʼmonaʼuyne. Kenda huataʼ ijhuaʼikay. Doʼhued Apaga Diosa konigti beʼhuaaʼikaʼne. Konige̱po buttida oaʼ oknopo̱e̱ʼdik moʼe̱ne. —‍Fariseo huairitaj Jesúsa oʼmanaʼuynigʼa Jesús Diosen Huasiʼpo o̱ʼe̱ oknopo̱e̱hueʼda o̱ʼnuy. ");
INSERT INTO amrNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","—‍Kaʼtiaʼ iaʼ, ¿O̱ʼnen Apag men i̱ta̱e̱? —‍Fariseoa oʼnonaʼuy. —‍Diosen Cristo o̱ʼe̱ oknopo̱e̱hueʼ moʼe̱ne. Aratbuten dakhueaʼ eʼkaʼ huamanopoʼyareaʼeri o̱ʼe̱ nopo̱e̱hueʼ moʼe̱ne. Kenpaʼti Apag Diostaj konigti oknopo̱e̱hueʼ moʼe̱ne. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Diosen jakyo kenteda Diostaj huakupe huanigkuda̱ʼ cajaʼpo oʼhuadikaʼ, ke̱yo̱ Jesúsa kenokaʼ eʼmanmadikaʼte Jesús bueyhueʼ ka̱e̱ʼ Diosa oʼnopo̱e̱nok tohuahueʼdik o̱ʼnuy. ");
INSERT INTO amrNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","—‍Kenpaʼda oʼnokhuaʼapone. Doʼtaj oʼdukaponigʼa oknopo̱e̱hueʼda moʼe̱po kenpaʼda moʼbueyapone. Nopoʼkoreahueʼda dakhueaʼ eʼkaʼ moʼto̱e̱po moʼbueyapone. Ke̱yo̱ ijhuaʼapoy huahueʼdik moʼe̱a̱pone. —‍Judío oknopo̱e̱hueʼ hua̱e̱ʼeritaj Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","—‍“Ke̱yo̱ ijhuaʼapoy huahueʼdik moʼe̱a̱pone.” Jesúsa monaʼne. Menpaʼ huataʼda arakdikpiʼ ya̱ʼe̱po ya̱ʼe̱t. —‍Judíomeya̱ nopo̱e̱hueʼ o̱ʼnepo onʼbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","—‍Huadariyo hua̱e̱ʼeri moʼe̱po konig dakhueaʼ huakaʼeri aratbut moʼe̱po, konig opudda boʼpakpo moʼnopo̱i̱kaʼpo, konigti boʼkikaʼ. Donayo kurudya̱ʼ ijhuarakuy. Apag Diosyaʼ ijtiakuy. Indariyo hua̱i̱kaʼeri ehueʼ i̱jje̱y. ");
INSERT INTO amrNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Diosen Huasiʼpo i̱jje̱nok Diosa meʼtaʼmonaʼuyne. Do Diosen Huasiʼpo e̱e̱ʼtada doʼtaj oknopo̱e̱hueʼ e̱e̱ʼnayo dakhueaʼ eʼkaʼ moʼto̱e̱po kenpaʼda moʼbueyapone. Diosa castiga mogkaʼapone. —‍Jesúsa judío huairitaj oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","—‍¿Beʼa i̱ʼe̱ on? —‍Kenda eʼnopo̱e̱ʼtaʼ pakhueʼ o̱ʼnepo namaʼda oʼnonaʼuy. —‍Kenda huakkuruda oʼnonaʼuyne. Menaʼpo onteʼti enaʼtaʼ boʼpak. ");
INSERT INTO amrNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","“Inomey huairia dakhueʼda o̱gkikaʼ, ontaj oknopo̱e̱hueʼ moʼe̱ne.” Diostaj huaaʼdik e̱ʼe̱a̱da oynayo huaahueʼdik o̱ʼnene. Keʼna meʼtaʼmonaʼuyne buttida oaʼikaʼ. Kenda Diosen ijpe̱e̱po aratbuttaj ijmanikay. —‍Jesúsa oknopo̱e̱hueʼ hua̱e̱ʼeri judío huairitaj oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Jesúsa Apag Diostaj oʼmanmadikikaʼ. Judío huairianayo nopoenkahueʼ o̱ʼnuy. Kenpaʼti Apag Diosa oʼtaʼmonaʼuyate judíomey nopo̱e̱hueʼ o̱ʼnuynok, ");
INSERT INTO amrNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","—‍Cruzte doʼtaj enʼdarakdeʼte Diosa oʼtaʼmonaʼuyate moʼnopo̱e̱a̱pone. Doʼhuedda sigpiʼ kahueʼ i̱ji̱kay. Kenda Diosa meʼnopo̱e̱a̱ʼne kenda ijmanikay. ");
INSERT INTO amrNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Doʼhued Apag Diosa meʼtaʼmonaʼuyne. Nogtiaʼda e̱a̱hueʼ meʼi̱kaʼne. Doere kenpaʼda o̱ʼi̱kaʼ. Kenda Diosa oʼpak ijkikay. —‍Jesúsa Judío huairitaj oʼmanaʼuy. Kenomeya̱ Jesústaj onʼhuadiaypo eʼaraktaʼ onʼtipakuy. ");
INSERT INTO amrNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Kenda Jesúsa eʼmanadeʼte huakkaʼada Jesústaj oʼnoknopo̱e̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","32","—‍Ayaʼada doʼhued huaʼa moʼnigpe̱i̱kaʼpo doʼhued hueretda huanigpe̱i̱kaʼeri moʼe̱ne. Doʼhued huaʼa buttida o̱ʼe̱ moknopo̱e̱po onteʼti totoʼtaj konig huanabaʼ nigpe̱e̱hueʼ moʼi̱kaʼpo onteʼti dakhueaʼ kikahueʼdik moʼe̱a̱pone. —‍Judío huaknopo̱e̱ʼeritaj Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","—‍Oroʼomey Abrahamen adhueaʼ huayayo o̱ʼe̱y. Nog aratbuten huanabaʼ ehueʼda o̱ʼi̱kay. Konig dakhueaʼ huakaʼeri huanabaʼ ehueʼda o̱ʼi̱kay. Onteʼti konig huanabaʼ dakhueaʼ kikahueʼdik o̱ʼe̱a̱poy. Namaʼda oroʼtaj kenpaʼ onaʼne. —‍Jesústaj oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","—‍Ayaʼada dakhueaʼ o̱gkikaʼpo, batikhueʼda dakhueaʼ o̱gkikaʼpo dakhueaʼ huakikaʼeri huanabaʼ o̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Huabokereken huasiʼpo huaojyoda o̱ʼnikaʼapo. Huanabaʼnayo huairiyoda i̱kahueʼ o̱ʼneapo. Nogok meyo̱piʼ kenpaʼda huaʼdik o̱ʼnikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Do Diosen Huasiʼpo i̱jje̱y. Konig totoʼen huanabaʼ dakhueaʼ boʼkikaʼne. Doʼhua dakhueaʼ eʼkaʼ eʼmanopoʼyareaʼnayo Diostaj nigpe̱i̱kaʼdik moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Buttida boaʼne Abrahamen adhueaʼ huayayo moʼe̱ne ijnopo̱e̱y. Abrahamen adhueaʼ huayayo e̱ʼe̱a̱da doʼhued huaʼa pakhueʼ moʼe̱po doʼtaj eʼaraktaʼ onʼtipakne. ");
INSERT INTO amrNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Kurudyo̱ doʼhued Apagere i̱ji̱kaʼuy. Apagtaj ijtiahuayikaʼuy. Ijpe̱i̱kaʼuy. Kenda ijtiahuayikaʼuy ijpe̱i̱kaʼpo opudomeytaj oʼnonaʼne. Doʼtaj nigpe̱e̱hueʼ moʼe̱ne. O̱ʼnen huaojtaj moʼnigpe̱i̱kaʼpo dakhueaʼ boʼkikaʼne. —‍Judíotaj Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","—‍Ehueʼ, dakhueaʼ huakaʼeri ehueʼ o̱ʼe̱y. Huadakda o̱ʼe̱y. Abraham oroʼen huaoj o̱ʼe̱. —‍Jesústaj oʼnonaʼuy. —‍Abraham Diostaj oʼnigpe̱i̱kaʼuyate. Abrahamen hueretda huasiʼpo ehueʼ moʼe̱ne. Abrahamensiʼpo e̱e̱ʼnayo Diostaj moʼnigpe̱i̱kaʼyet. Kenpaʼti Diosen huaʼa boʼpakikaʼyet. ");
INSERT INTO amrNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Diosa meʼtaʼnonaʼuyne. Diosyaʼ ijtiakuy. Buttida huaʼa Diosa meʼnopo̱e̱a̱ʼuyne. Diosen buttida huaʼa eʼnonaʼtada doʼtaj onʼhuadiaypo doʼtaj eʼaraktaʼ onʼtipakne. Ken konig Abrahama kahueʼ o̱ʼu̱y. Abraham Diostaj oknopo̱e̱po Diosen huataʼmoneritaj oʼmanigpe̱i̱kaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Konig opuden huaoj dakhueʼyoʼda oʼkikaʼ opudomeykon dakhueaʼ boʼkikaʼ. —‍Jesúsa judíotaj oʼmanaʼuy. —‍Oroʼ kate bahuetaʼ eʼsiʼpoe̱ʼ ehueʼ o̱ʼe̱y. Abrahamen hueretda adhueaʼ huayayo o̱ʼe̱y. Nogtida Apag Dios oʼte̱ne. Diostaj oʼnigpe̱i̱kay. —‍Judíoa Jesústaj oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","—‍Dios opuden huaoj e̱e̱ʼnayo doʼtaj diʼ moʼe̱a̱ye̱t konige̱po Diosyaʼ ijtiakuy. Doda ijpakpo tiakhueʼ i̱jje̱ʼuy. Diosa oʼpakpo meʼtaʼmonaʼuyne. Opudnayo doʼtaj diʼ ehueʼ o̱ʼnene. ");
INSERT INTO amrNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Dakhueʼda moʼe̱po Diostaj eʼnigpe̱e̱taʼ pakhueʼ moʼe̱ne. Huadak eʼkaʼtaʼ pakhueʼ moʼe̱ne. Konige̱po doʼhued huaʼa eʼpe̱e̱taʼ pakhueʼ moʼe̱ne. Kenpaʼti doʼhued huaʼa eʼnopoenkaʼtaʼ pakhueʼ moʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Katepiʼ opudomeyen huaoj oʼpaknok kenda boʼkikaʼne. Opudomeyen huaoj totoʼ moʼta̱e̱ne. Kentayoʼda moʼnigpe̱i̱kaʼ. Huakkuruda totoʼa oʼbahuadiayikaʼpo huakkaʼtada oʼmanopoʼarakikaʼpo. Diosen buttida huaʼa totoʼa eʼnopo̱e̱ʼtaʼ pakhueʼ o̱ʼi̱kaʼ. Buttida huaʼa nopo̱e̱hueʼ o̱ʼe̱po ahueʼ o̱ʼi̱kaʼ. Da oaʼikaʼ. Da huaaʼeri o̱ʼe̱. Aratbuttaj da huaaʼeri oʼmaeaʼikaʼ. Aratbuttaj engaña huakaʼeri o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Konige̱po o̱ʼnen huaoj totoʼ da huaʼayoʼda eʼpe̱e̱taʼ boʼpakikaʼpo Diosen buttida huaʼa eʼmanaʼte eʼpe̱e̱taʼ pakhueʼ moʼi̱kaʼne. Diosen Huasiʼpo i̱jje̱nok doʼtaj eknopo̱e̱ʼtaʼ pakhueʼ o̱ʼnene. ");
INSERT INTO amrNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Namaʼda oameʼ. Huaahueʼdik o̱ʼnene. Dakhueaʼ oʼkameʼ. Huaahueʼdik o̱ʼnene. Buttida oʼikaʼ. Doʼtaj oknopo̱e̱hueʼ o̱ʼnene. ");
INSERT INTO amrNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Diostaj oknopo̱e̱hueʼ moʼe̱po konige̱po doʼtaj oknopo̱e̱hueʼ o̱ʼnene. Diosen aratbut Diosen huanigpe̱i̱kaʼeriomey Diostaj onʼnigpe̱i̱kaʼ. Opudomeynayo Diosen huanigpe̱i̱kaʼeri ehueʼ moʼe̱ne. Diostaj eʼnigpe̱e̱taʼ pakhueʼ moʼe̱ne. —‍Jesúsa judío aratbuttaj oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","—‍Dapitaʼ dakhueʼnanada i̱ʼe̱ne. Samaria hua̱e̱ʼeri i̱ʼe̱ne. Totoʼa menopoʼto̱e̱ne. Buttida onaʼne. —‍Judío huairia huakkaʼ onʼhuadiaypo Jesústaj onʼtidiʼkepo oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","—‍Doʼtaj totoʼa nopoʼto̱e̱hueʼ meʼe̱ne. Diostaj diʼnanada i̱ji̱kay. Ijnigpe̱i̱kay. Dios huadaknanada o̱ʼi̱kaʼ ijbatiaʼpakikay. Diostaj pakhueʼ moʼe̱po doʼtaj onʼhuadiaypo dakhueaʼda onʼhuaaʼne. ");
INSERT INTO amrNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","“Jesús huadakda o̱ʼe̱.” Menhuaikaʼ. Manahueʼ i̱ji̱kay. Apag Diosnayo doʼtaj buttida beʼtinopo̱e̱po, “Huadakda o̱ʼi̱kaʼ.” Beʼhuaikaʼne. ");
INSERT INTO amrNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Doʼhued huaʼataj ayaʼada oʼnoknopo̱e̱po onʼnigpe̱i̱kaʼpo kenpaʼda bueyhueʼ o̱ʼneapo, Diosere onʼnoeonhuahuikaʼapo. —‍Judío huairitaj Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","—‍Totoʼ oʼnopoʼto̱e̱. Oynayo buttida oʼnopo̱e̱y. Oroʼomeyen adhueaʼpaneʼ Abrahama Diostaj eʼnigpe̱i̱kada oʼbueyʼuyate. Diosen huamanbatiaʼpakeriakon Diostaj e̱ʼnigpe̱i̱kada onʼmabueyʼuyate. “Doʼhued huaʼataj ayaʼada oʼnoknopo̱e̱po onʼnigpe̱i̱kaʼpo kenpaʼda bueyhueʼ o̱ʼneapo.” Namaʼda iaʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Oroʼen huaoj Abraham teyda huairitoneʼ o̱ʼu̱y. Abraham oʼbueyʼuyate. Diosen huamanbatiaʼpakerikon onʼmabueyʼuyate. Menpaʼ Abrahamtaj nogi̱ti hueretda huairitoneʼ o̱ke̱hueʼdik i̱ʼe̱ne. Diosen huamanbatiaʼpakeritaj o̱ʼnayoʼda teyda huairitoneʼ make̱hueʼdik i̱ʼe̱ne. “Huairi i̱jje̱y,” namaʼda iʼnopo̱e̱po, da iaʼ, huairi ehueʼ i̱ʼe̱. —‍Judío huairia oknopo̱e̱hueʼda o̱ʼnepo Jesústaj oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","—‍“Aratbuttaj manoeanhuahuikaʼdik i̱jje̱y.” Doda ijpakpo manahueʼ i̱ji̱kay. “Jesús huadakda o̱ʼe̱,” aratbuta menʼbatiaʼpakeʼpo manahueʼ i̱ji̱kay. Diosa oʼpaknok kenda ijmanikay. “Huairitoneʼ i̱ʼe̱ne. Doʼhued Huasiʼpo i̱ʼe̱ne.” Diosa menaʼikaʼne. “Oroʼen Dios o̱ʼe̱,” namaʼda boaʼikaʼne. ");
INSERT INTO amrNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Diostaj oknopo̱e̱hueʼ moʼe̱ne. “Diostaj yoknopo̱e̱y.” Buttida ijjay. “Diostaj oknopo̱e̱hueʼ i̱jje̱y.” Doa eaʼnayo opud konigti da huaaʼeri i̱jje̱a̱yet. Dapitaʼ Diostaj yoknopo̱e̱po ijnigpe̱i̱kay. ");
INSERT INTO amrNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Doʼtaj oʼtiaʼpakpo Abrahamtaj Diosa onaʼuyate. “O̱ʼnen huayayo huaboroʼ huairitoneʼ o̱ʼe̱a̱po.” Doʼtaj oʼtiaʼpakpo Abrahamtaj onaʼuyate. Diostaj Abraham kenda oknopo̱e̱po do i̱jje̱a̱ponok durugnanada o̱ʼu̱yate. —‍Judío huairitaj Jesúsa oʼnanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","—‍Ehueʼ. Abraham aʼnennanada o̱ʼi̱kaʼuyate. Onnayo huatoneʼ ehueʼ i̱ʼe̱ne. Menpaʼ Abrahamtaj iʼtiahuayʼuy. Ehueʼ. Abrahamtaj tiahuayhueʼ i̱e̱ʼuy. Da iaʼne. —‍Jesústaj oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","—‍Abraham siʼpoe̱hued Diosere i̱ji̱kay. Buttida ijjay. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Onʼpe̱e̱depo Jesústaj kadarakeʼpo huid onʼbaeʼeadpo Jesústaj kanʼpaʼeʼpo huid onʼbaeʼeadnigʼa. Jesúsa oʼmaki̱re̱gpo Diosen jakyaʼ oʼbakhuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Nogok okmapi̱e̱ʼahuaddik huameʼnoete Jesús oʼhuaʼepo Jerusalényo̱ oʼhuaʼepo huabokerek ekpobigtaj oʼtiahuayʼuy. Keʼna ekpobig oʼsiʼpoe̱ʼuy ekpobig o̱ʼe̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","—‍¿Menaʼpo inbokerek ekpobig yasiʼpoe̱ʼuyate? ¿Beʼa dakhueaʼ yakuyet? ¿Huaoapiʼ hua̱ye̱a̱piʼ keʼnadapiʼ dakhueaʼ yakuyetpiʼ huamanmadikaʼeri? —‍Oroʼomey Jesúsen huanigpe̱i̱kaʼeria Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","—‍Ehueʼ, keʼna dakhueaʼ kahueʼ o̱ʼu̱y. Keʼnen huaoa hua̱ye̱erea dakhueaʼ kahueʼ o̱ʼnuyate. Konige̱po dakhueaʼ o̱gkuypo ekpobig ehueʼ o̱ʼe̱. Diosa teyda kikaʼdik ka̱e̱ʼpo bakpoyareaʼdik ka̱e̱ʼpo aratbuta kanʼtiahuayeʼpo kanʼnopo̱e̱ʼpo konige̱po ekpobig oʼsiʼpoe̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Kenda Diosa oʼpak kakikeʼpo kenpaʼti Diostaj kanigpe̱i̱keʼpo Diosa meʼtaʼmonaʼuyne. Konige̱po oyedda Diosen kikaʼdik i̱jje̱y. Sueʼda huameʼnoe meke̱nok oyda Diosen kikaʼdik i̱jje̱y. Aʼti nogok kahueʼdik i̱jje̱a̱poy. Konig sikyonig o̱ʼe̱a̱po kahueʼdik i̱jje̱a̱poy. ");
INSERT INTO amrNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","In huadariyo i̱jje̱depo konig Diosen huakjey i̱jje̱po Diostaj ijmaknopo̱e̱a̱ʼdey, Diosen huaʼa ijmanopo̱e̱a̱ʼdey. —‍Jesúsa oroʼtaj keʼnen huanigpe̱i̱kaʼeritaj monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Kenda oaʼdepo barakte oʼsupupo igkusi̱ʼhue̱ oʼdukutaʼpo soroka ekpobigtaj okpodukutaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","—‍Yahuatiʼ. Siloé ya̱koyo yahuatiʼ. Yakpokoyoaʼ. —‍Ekpobigtaj onaʼuy. (Siloé judíoen huadik eʼdiktaʼmonaʼ o̱ʼe̱.) Ken, oʼhuaʼpo okpokoyodepo okpoyarudʼuy. Oʼtiakpo dakaʼ oʼmaboʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Yareahued ekpobig jak eretnopoyoda oʼhuadikaʼpo “huakupe menʼyok,” oʼmanaʼikaʼuy. Ayaʼada kentaj onʼnoki̱e̱ʼuy. Ekpobig o̱ʼi̱kaʼ ayaʼada onʼtiahuayikaʼuy. —‍Dapiʼ inbokerek oʼhuadpo “huakupe menʼyok,” oʼmanaʼikaʼuynig. —‍Sueʼada oʼdaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","—‍E̱e̱ʼ, keʼna o̱ʼe̱. —‍Nogomeya̱ oʼdaʼuy. —‍Ehueʼ, nogda o̱ʼe̱. Konigti o̱ʼe̱. —‍Nogomeya̱ oʼdaʼuy. —‍Do ekpobig i̱ji̱kaʼuynig i̱jje̱y. —‍Kenbokerek okpoyaredepo oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","—‍¿Monig ikpoyarudmeʼ? ¿Moniga̱ʼ iʼmabodmeʼ? —‍Oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","—‍Jesúsa barakte oʼsupupo oʼdukutaʼpo soroka bekpodukutaʼpo, “Siloé ya̱koyo yahuatiʼ. Yakpokoyoaʼ.” Menaʼne. Ken ijhuaʼdepo yokpokoyodepo huaboaʼda ijmabodi. —‍Oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","—‍¿Men ya̱ʼe̱ kenbokerek? —‍Oʼnonaʼuy. —‍Nopo̱e̱hueʼ i̱jje̱y. —‍Oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Okmapi̱e̱ʼahuaddikte huameʼnoete Jesúsa soroka oʼdukutaʼpo okpoyareadnok kenbokerek ekpoyareadtaj onʼtohuaʼpo judío hua̱i̱takeʼ jak huairitaj onʼtohuaʼpo fariseo huairitaj onʼtohuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","—‍Ekpobig i̱ʼunhuahuikaʼuy. ¿Monig oyda huaboaʼda iʼtiahuay? —‍Fariseo huairia oʼnonaʼuy. —‍Soroka samibia bekpodukutaʼpo yokpokoyopo huaboaʼda ijtiahuayoni. —‍Fariseo huairitaj oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","—‍Okmapi̱e̱ʼahuaddik huameʼnoete aratbut katepiʼ kahueʼdik o̱ʼne. Oʼmanmadikikay. Inbokerek nigpe̱e̱hueʼda o̱ʼe̱po okmapi̱e̱ʼahuaddik huameʼnoete oʼyareaʼnok keʼna Diosen huamanbatiaʼpakeri ehueʼdik o̱ʼe̱, oʼnopo̱e̱y. —‍Sueʼada onʼbatiaʼpakuy. —‍Dakhueaʼ huakaʼeri e̱e̱ʼnayo bayareahueʼdik o̱ʼe̱. Keʼna oʼyareaʼde dakhueaʼ huakaʼeri ehueʼdik o̱ʼe̱, oʼnopo̱e̱y. —‍Noga̱ onʼbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","—‍¿On menpaʼ iʼnopo̱e̱ ken huabokerek huakpo beyareatenigtaj? —‍Huabokerek huakpoyareritaj judío huairia oʼnonaʼuy. —‍Diosen huamanbatiaʼpakeri o̱ʼe̱, oʼnonaʼne. —‍Oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Aʼnenda ekpobig o̱ʼi̱kaʼuy. Oyda okpoyaredepo tiahuaydik o̱ʼe̱. Kenda Judío huairia oknopo̱e̱hueʼdik o̱ʼnepo, “Keʼnen huaoj hua̱ye̱tere yanʼtotiak.” Onʼmanaʼuy. Enʼtiakdeʼte. ");
INSERT INTO amrNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","—‍¿In huabokerek menpaʼ o̱ʼnensiʼpo ya̱ʼe̱? ¿Menpaʼ ekpobig oʼsiʼpoe̱ʼuy, boʼtiaʼpakikaʼ? ¿Menaʼpo oyda tiahuaydik ya̱ʼe̱? —‍Judío huairia keʼnen huaojtaj hua̱ye̱tere onʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","—‍E̱e̱ʼ, keʼna oroʼensiʼpo o̱ʼe̱. Ekpobig oʼsiʼpoe̱ʼuy oʼnopo̱e̱y. ");
INSERT INTO amrNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Menaʼpo oyda tiahuaydik o̱ʼe̱ oroʼnayo nopo̱e̱hueʼ o̱ʼe̱y. Kenpaʼti beʼa yakpoyaret nopo̱e̱hueʼ o̱ʼe̱y. “¿Beʼa bekpoyareaʼ?” Ya̱ʼnonaʼ. Huabokerek o̱ʼe̱. Keʼnada aʼdik o̱ʼe̱. —‍Keʼnen huaoa hua̱ye̱erea onʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Judío huairitaj onʼmakmeʼpukpo huaojerea hua̱ye̱erea kenda namaʼda huairitaj onʼmanaʼuy. “Jesús Diosen Cristo o̱ʼe̱. Diosa oʼtaʼmonaʼuyate.” Beʼapiʼ eaʼnayo Apagbaʼtaj aʼpe̱e̱yaʼpo judíoen hua̱i̱takeʼ jakyo onteʼti kudhueʼdik o̱ʼneapo. Judío huairia onpapayoʼ ondaʼpo. Konige̱po huabokereken huaojere hua̱ye̱ere onʼmeʼpukpo, namaʼda onʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","“Huabokerek o̱ʼe̱. Keʼna aʼdik o̱ʼe̱. Kentaj ya̱ʼnonaʼ.” Judío huairitaj namaʼda onʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","“Keʼna huabokerek ekpobig oʼsiʼpoe̱ʼuy. Kentaj yanʼtotiak.” Judío huairia onʼmanaʼuy. Eʼtiakdeʼte oʼnonaʼpo, —‍Buttida yaaʼ. “Diosa beʼyareaʼne.” Yaaʼ. Jesús dakhueaʼ huakaʼeri o̱ʼe̱, oʼtinopo̱i̱kay. Bayareahueʼdik o̱ʼe̱. Oroʼ oʼnopo̱i̱kay. —‍Judío huairia oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","—‍Dakhueaʼ huakaʼeripiʼ o̱ʼe̱piʼ ʼuruda huakaʼeri o̱ʼe̱piʼ nopo̱e̱hueʼ i̱jje̱y. Nogtida ijnopo̱e̱y. ʼIkken ekpobig i̱jje̱mey. Oynayo ijtiahuay. —‍Oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","—‍¿Ontaj moniga̱ʼ megkaʼ? ¿Monig bekpoyareaʼ? —‍Onteʼti judío huairia oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","—‍Kenda huaboaʼda oʼnonaʼdene. ¿Menaʼpo onteʼti eʼpe̱e̱taʼ boʼpak? ¿Jesúsen huanigpe̱i̱kaʼeri e̱e̱ʼtaʼ menpaʼ boʼpak? —‍Oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","—‍O̱ʼna kentaj huanigpe̱i̱kaʼeri i̱ʼe̱. Oroʼnayo Moisésen huanigpe̱i̱kaʼeri o̱ʼe̱y. ");
INSERT INTO amrNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Moiséstaj Diosa onaʼikaʼuyate oknopo̱i̱kay. In huabokereknayo meya̱ʼ yaʼtiakuyet nopo̱e̱hueʼ o̱ʼe̱y. —‍Fariseo huairiomeya̱ diga̱ʼda onʼhuadiaypo i̱ghuaʼda oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","—‍¡Kenpihuay! Kentaj menaʼpo oknopo̱e̱hueʼ moʼe̱. Ken huabokereka bekpoyareaʼne. Ke̱ya̱ʼ oʼtiakuy nopo̱e̱hueʼ moʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Dakhueaʼ huakaʼeritaj Diosa manigpe̱e̱hueʼ o̱ʼi̱kaʼ. Diostaj huanigpe̱i̱kaʼeritaj Diosa oʼmanigpe̱i̱kaʼ. Katepiʼ onʼpaknok Diosa oʼmanigkikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Aʼnennanadapiʼ huakkuruda ekpobigtaj eʼsiʼpoe̱ʼ okpoyareaʼuy tipe̱e̱hueʼ o̱ʼi̱kay. ");
INSERT INTO amrNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Dapitaʼ Diosyaʼ oʼtiakuyate. Diosyaʼ tiakhueʼ e̱ʼu̱ynayo in huabokereka kenda sigpiʼ kahueʼdik o̱ʼe̱. Bakpoyareahueʼdik o̱ʼe̱. —‍Judío huairitaj oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","—‍Dakhueʼ eʼeretkaʼ iʼsiʼpoe̱ʼuy. Dakhueaʼ iʼkikaʼuy. Oroʼtaj onmandikahueʼdik o̱ʼe̱ne. —‍Judío huairia onʼhuadiaypo oʼnonaʼuy. Judío aratbuten hua̱i̱takeʼ jakyaʼ oʼnenʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Huabokerek ekpoyareʼtaj hua̱i̱takeʼ jakyaʼ oʼnende Jesúsa oʼnopo̱e̱po oʼdeatopo, —‍¿Diosen Huasiʼpo, ken huabokerektaj Diosa oʼtaʼmonaʼuyate menpaʼ oknopo̱e̱ʼ? —‍Jesúsa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","—‍¿Beʼa ya̱ʼe̱, huairi? Eknopo̱e̱ʼtaʼ ijpaki. —‍Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","—‍Kentaj iʼtiahuayne. Diosa meʼtaʼmonaʼuyne. In do i̱jje̱y. Diosen Huasiʼpo i̱jje̱po onaʼne. —‍Jesúsa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Jesús Diosen Huasiʼpo o̱ʼe̱ oknopo̱e̱po huikudate oʼtihuadpo, —‍Diosen huataʼmonaʼeri i̱ʼe̱. Diosen Huasiʼpo i̱ʼe̱. Yoknopo̱e̱y, Huairi. —‍Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","—‍Huakkaʼada konig tiahuayhueʼdik o̱ʼnepo konig ekpobig o̱ʼnepo Diostaj oknopo̱e̱hued o̱ʼnepo doʼtaj oʼnoknopo̱e̱a̱popo Diosere onʼnoeonhuahuikaʼapo. Nogomeya̱ “Ekpobig ehueʼ o̱ʼe̱y. Tiahuaydik o̱ʼe̱y. Diostaj huadakda oknopo̱i̱kay.” Namaʼda onʼbatiaʼpakpo hueretda huaknopo̱e̱ʼeri ehueʼ o̱ʼnepo konig ekpobig o̱ʼnenok Diosa castiga magkaʼdik o̱ʼi̱kaʼapo. Konige̱po Diosa indariyo meʼtaʼmonaʼuyne. —‍Jesúsa oaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ken, sueʼada fariseo huairi kenteda o̱ʼnepo Jesústaj onʼpe̱e̱depo, —‍Dapiʼ oroʼomeynayo Diostaj oknopo̱e̱hueʼ hua̱e̱ʼeri ehueʼ o̱ʼe̱y. Oroʼomey ekpobig ehueʼ o̱ʼe̱y. Diostaj oknopo̱e̱y. —‍Jesústaj oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","—‍“Diostaj oknopo̱e̱hueʼ hua̱e̱ʼeri o̱ʼe̱y,” eaʼnayo o̱ʼnen dakhueaʼ eʼkaʼ Diosa bakkahueaʼdik moʼe̱a̱ynigʼa “Diostaj oknopo̱e̱hueʼ hua̱e̱ʼeri ehueʼ o̱ʼe̱y,” namaʼda boaʼnok Diosa bakkahueahueʼdik moʼe̱ne. —‍Jesúsa fariseo huairitaj oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Diosen huanigpe̱e̱ʼeriomeytaj hueretda huamato̱e̱ʼeri doa i̱ji̱kay. Jesúsa oʼmanbatiaʼpakpo, —‍Buttida ijjay. Ovejataj kabatiokeʼpo oveja huamato̱e̱ʼeria huakpa ekbirikyo oʼbakuda̱ʼikaʼ. Bisik oʼbakuda̱ʼikaʼ. Oʼbakuda̱ʼdepo akbogpe huato̱e̱ʼeria teyaʼda okhuikikaʼ. Oveja huabereeri onʼtiakdepo akbogpeyaʼ kudhueʼdik o̱ʼnikaʼ. Nogyaʼda o̱gkudikaʼ. Huakpakuyaʼ onʼbehuikpo onʼkudikaʼ, ");
INSERT INTO amrNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","3","Hueretda oveja huamato̱e̱ʼeria ovejataj oʼmatiokikaʼpo oʼmato̱i̱kaʼpo sikyoedda ovejataj aʼbaeyaʼpo akbogpete oʼhuahuaʼdepo kentaj akbogpe huato̱e̱ʼeria o̱ki̱e̱ʼpo oʼnigokhuike. Ken hueretda oveja huamato̱e̱ʼeri oʼkudde keʼnen ovejaa onʼnigpe̱e̱. Ayaʼ ovejaen huadik oʼmadikkaʼdepo oʼmaoro̱kaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ayaʼtada oʼmaoro̱kandepo huakkuru oʼmanighuaʼikaʼ. Oveja hueretda huamato̱e̱ʼeritaj onʼpe̱e̱po oʼnoki̱e̱ʼpo konige̱po onʼtahuaʼikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Noga̱da eʼhuatiakte oveja oʼnokmamonapo. Keʼna menʼtahuaʼ enaʼte onʼpe̱e̱po o̱ki̱e̱hueʼ onʼe̱po oʼnokmamonapo. —‍Ken konig oveja huamato̱e̱ʼeritaj Jesúsa oʼmanbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesúsa kenda oʼmanbatiaʼpaknigʼa judío aratbuta eʼpe̱e̱a̱da nopo̱gkahueʼ o̱ʼneʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Onteʼti Jesúsa oʼmanbatiaʼpakpo, —‍Buttida ijjay. Do konig ovejaen akbogpe i̱jje̱y. Do konig oveja ijbatokudi. Ayaʼda huaknopo̱e̱ʼeri doʼtaj oʼnoknopo̱e̱po doere kuddik o̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Huakkaʼada konig huamanbatiaʼpakeri do tiakhued e̱e̱ʼted kenomey konig huabereeri engaña huakaʼeri o̱ʼneʼuyate. Hueretda ovejaa taʼhuahueʼ o̱ʼnikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Do oveja eʼtiokpakaʼ akbogpe konig i̱jje̱y. Ayaʼada doʼtaj oʼnoknopo̱e̱po konig onʼkudpo Diosere onʼnoeonhuahuikaʼapo. Diostaj dakaʼ kanʼnigpe̱i̱keʼpo ijbatihuapokikay. Dakhueaʼ kahueʼ kaʼneʼpo kenomeytaj ijbatiokikaʼapoy. ");
INSERT INTO amrNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Namaʼda huamanmadikaʼeri konig huabereeri o̱ʼne. Onʼberikaʼ. Onʼbarakikaʼ. Onʼbakbasakikaʼ. Donayo ijmanoeanhuahuikay. Hueretda huaknopo̱e̱ʼeritaj ijmanoeanhuahuikay. Huakkaʼda ijmatinepahuiʼpo ʼuruaʼnanada ijmanoeanhuahuikay. ");
INSERT INTO amrNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Do konig oveja huamato̱e̱ʼeri i̱jje̱y. Huadakaʼda huamato̱e̱ʼeri i̱jje̱y. Huanigpe̱i̱kaʼeritaj dakaʼnanada ijmato̱i̱kay. Ovejataj aʼbatiokayaʼpo, ovejataj aʼmanoeanhuahuikayaʼpo ijmanigbueyapoy. ");
INSERT INTO amrNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","13","Sueʼada huakupetaʼ huakkaʼ oʼderetpakpo nogen ovejataj onʼmatamato̱i̱kaʼ. Nubakuhuaa eʼhuatiakte onʼmatiokmonikaʼ. Oveja nogen onʼta̱e̱nok huakupeyoʼda oʼderetpakpo ovejataj pakhueʼ o̱ʼnepo onʼmatiokmonikaʼ. Nubakuhua onʼbahuatiakpo oʼmabokeʼpo oʼmamonaʼikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Doa konig ovejataj dakaʼ huamato̱e̱ʼeri i̱jje̱y. Apag Diosa doʼtaj meki̱e̱ʼne konigti Apag Diostaj doa yo̱ki̱e̱y. Kenpaʼti doʼhued huanigpe̱i̱kaʼeritaj ijmaki̱e̱y konigti doʼhued huanigpe̱i̱kaʼeria doʼtaj meʼnoki̱e̱ʼne. Dakhueaʼ eʼkaʼ aʼmanopoʼyareayaʼpo huanigpe̱i̱kaʼeritaj ijmanigbueyapoy. ");
INSERT INTO amrNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nog huanigpe̱i̱kaʼeritakon ijmato̱e̱i̱kaʼapoy. Judío aratbut ehueʼ o̱ʼne. Nog aratbut o̱ʼne. Ken aratbuttakon manopoʼkoreaʼdik i̱jje̱y. Doʼtaj onʼnigpe̱i̱kaʼapo. Kenomeyere judíomeyere konig nogaratbuttida o̱ʼneapo. Kenpaʼti do kenomeytaj nogtiada huamato̱e̱ʼeri i̱jje̱a̱poy. ");
INSERT INTO amrNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","18","Diostaj ijnigpe̱e̱nok, doʼtaj menʼtohuaʼ doʼtaj menʼarakeʼ ijnopo̱e̱po. Ken ijbueydeapoy onteʼti ijnoyhuada̱poy onteʼti ijnoeapoy. Konige̱po Apag Diosa diʼ meʼe̱ne. Huabokereka doʼtaj eʼaraktaʼ onʼpakpo arakhueʼdik meʼneapone. Konige̱po doada eʼnigbueytaʼ ijpakpo ijnigbueyapoy. Eʼnigbueytaʼ ijpakpo bueydik i̱jje̱a̱poy. Onteʼti eʼnoyhuadtaʼ ijpakpo noyhuaddik i̱jje̱a̱poy. Kenda doʼhued Apag Diosa menaʼuyne. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Judíomeya̱ Jesústaj onʼpe̱e̱depo nogpaʼ nogpaʼ onʼnopo̱e̱po nogpaʼ nogpaʼ onʼbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","—‍Totoʼa oʼnopoʼto̱e̱ʼnok Jesús huasegda o̱ʼe̱ Katiaʼpo kentaj moʼnigpe̱e̱ʼ. —‍Huakkaʼada kenpaʼ onʼbatiaʼpakʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","—‍ʼUruaʼnanada oʼmanbatiaʼpak. Totoʼa nopoʼto̱e̱hueʼ o̱ʼe̱. Totoʼa eʼnopoʼto̱e̱ʼnayo ʼuruda batiaʼpakhueʼ ya̱ʼe̱a̱yet. Kenpaʼti ekpobigtaj okpoyareahueʼdik o̱ʼe̱ totoʼa. —‍Nogomeya̱ onʼbatiaʼpakʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Nogok Jerusalényo̱ Diosen jak onʼtoʼkaʼdepo fiesta okkahuehueʼ hua̱e̱ʼ o̱ʼu̱y. Huahuiʼok o̱ʼu̱y. ");
INSERT INTO amrNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Diosen jak kurute Salomóna dagtaj jakaʼ oʼtikaʼuyate. Ken dagte Jesús eʼhuaʼete ");
INSERT INTO amrNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","judío huairia Jesústaj onʼtikupobopo, —‍¿Meniga̱ʼ puug oroʼomey nigunhuahuaʼdik o̱ʼe̱? Diosa eʼtaʼmonuyʼnayo buttida oyedda monaʼ. Cristo buttida e̱e̱ʼnayo monaʼ. —‍Jesústaj oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","—‍Kenda oʼnonameʼniga̱ doʼtaj oknopo̱e̱hueʼ o̱ʼnene. Opudomeya̱ doʼtaj dakaʼ kanoknopo̱e̱ʼpo konig Diosyoʼda kaʼdik o̱ʼe̱ ijkikamey. Diosa kenda beʼtihuapoknok ʼuruaʼda ijkikamey. Konigda eʼbayareaʼ ijkikamey. Cristo o̱ʼe̱ doʼtaj dakaʼ oknopo̱e̱ʼdik ʼuruaʼda ijkikamey. ");
INSERT INTO amrNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Konig Dios ʼuruaʼnanada oʼkikaʼ konigti ijkikaʼnigʼa opuda̱ doʼtaj oknopo̱e̱hueʼ o̱ʼnikaʼne. Doʼhued oveja huanigpe̱i̱kaʼeri ehueʼ moʼe̱po, doʼtaj eknopo̱e̱ʼtaʼ pakhueʼ o̱ʼnene. ");
INSERT INTO amrNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Doʼhued oveja huanigpe̱i̱kaʼeria doʼtaj menaʼ o̱ki̱a̱ʼpo onʼnigpe̱i̱kaʼ. Doʼhued huanigpe̱i̱kaʼeri doʼa ijmata̱e̱po dakaʼ ijmaki̱kay. Doʼtaj oʼnoknopo̱e̱po onʼnigpe̱i̱kaʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Diosere durugnada ijmanoeanhuahuikaʼapoy. Kenpaʼda bueyhueʼdik o̱ʼneapo. Dakaʼ ijbatiokaʼnok beʼapiʼ sigpiʼ okkayhueʼdik meʼneapone. ");
INSERT INTO amrNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Oveja huanigpe̱i̱kaʼeri meʼbayokuyne. Doʼhued Apag Diosa meʼbayokuyne. Teynanada o̱ʼe̱. Diosyoʼda teynanada o̱ʼe̱. Noga̱piʼ konig teyti ehueʼ o̱ʼnepo okkayhueʼdik o̱ʼnikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Apagere doere nogtida o̱ʼe̱y. —‍Jesúsa huairitaj oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Judío huairia huida̱ Jesústaj aʼpaʼeaʼyaʼpo onʼbaeaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","—‍Opuda̱ onʼtiahuayikaʼne nogda nogda ʼuruaʼnanada ijkikay. Apaga̱ beʼtihuapoknok konig Diosayoʼda kaʼdik o̱ʼe̱ ijkikay. ¿Kateaʼpo menapoata doʼtaj onpaʼeapo? —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","—‍Ehueʼ. Huadakda iʼkikaʼnok paʼeahueʼ o̱ʼe̱a̱poy. Diostaj dakhueaʼnada iaʼnok huida̱ oʼpaʼeaʼapoy. Huabokerek e̱ʼe̱a̱da Dios i̱jje̱y iaʼnok huida̱ oʼpaʼeaʼapoy. —‍Judíoa oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","—‍“Oy opudomey Diostaj huanigpe̱i̱kaʼeri moʼe̱po diosdik moʼto̱e̱ne.” Diosa oʼmanaʼuyate. Kenpaʼ opudomeyen Diosbaʼte oʼmadoyaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Diosbaʼnayo namaʼda ahueʼdik o̱ʼe̱. Kenpaʼda buttida o̱ʼi̱kaʼ. “Oy opudomey Diostaj huanigpe̱i̱kaʼeri moʼe̱po diosdik moʼto̱e̱ne.” Apagbaʼa buttida oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Apagtaj meʼnigpe̱i̱keʼpo Diosa meʼtaʼmonaʼuyne. Dakhueaʼ huakaʼerite meʼtaʼmonaʼuyne. Konige̱po “Diosen Huasiʼpo i̱jje̱y,” aʼdik i̱ji̱kay. Konige̱po “Diostaj dakhueʼda oʼtiaʼpak.” Doʼtaj huaahueʼ ya̱ʼnikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Kenda doʼhued Apaga̱ menikaʼnig ijkikay. Do Diosen kikahueʼ e̱e̱ʼnayo doʼtaj oknopo̱e̱hueʼdik moʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Doʼa Diosen eʼkikaʼtada opudomeya̱ doʼtaj oknopo̱e̱hueʼ e̱e̱ʼpiʼ kenda do ijkikaʼnige̱yo̱ kenda yanoknopo̱e̱ʼ. Diosensiʼpo o̱ʼe̱ nopo̱e̱ʼdik moʼe̱. Konig Diosa oʼnopo̱e̱ konigti ijnopo̱e̱y. Konig do i̱jje̱y konigti Dios o̱ʼe̱. Konig doʼa ijnopo̱e̱y konigti Diosa oʼnopo̱e̱. Kenda nopo̱i̱kaʼdik moʼe̱a̱po. —‍Jesúsa judío huairitaj oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Onteʼti Jesústaj kanʼkude̱ʼpo eʼtohuaʼtaʼ enʼpaktada Jesúsa oʼmakmonʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Onteʼti Jordánhue̱ akodpen Jesúsa oʼhuaʼuy. Kenteda Juana huakkuruda bautiza oʼmagkadhuaʼuyatenig. Kenteda Jesús o̱ʼunhuahuaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Jesúste huakkaʼada onʼhuatiakuy. —‍Konig tiahuayhued o̱ʼi̱kaʼ konig Diosayoʼda kaʼdik o̱ʼe̱ Juananayo kahueʼ o̱ʼu̱y. Ayaʼda inbokerektaj oʼtiaʼpakikaʼuy, buttida oaʼikaʼte. —‍Aratbuta onʼhuaaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ke̱ya̱ʼ Jesústaj huakkaʼada oʼnoknopo̱e̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","3","Lázaro huabokerek o̱ʼu̱y. Jesúsa Lázarotaj diʼda o̱ʼi̱kaʼuy. Betania huakkaʼ jakyo hua̱e̱ʼeri o̱ʼi̱kaʼuy. Betaniayo huidpo Maríaere Martaere o̱ʼnikaʼuy. Lázaro dakhueʼda o̱ʼe̱nok María Martaere Jesúste onʼtaʼmonaʼuy. —‍Lázarotaj diʼda i̱ʼi̱kaʼne. Dakhueʼda o̱ʼe̱, Huairi. Jesústaj yanatiʼ. —‍Oʼnonaʼuy. María Jesús huairien huaʼitaj huasihuaj ʼuruʼhui̱e̱a̱da ʼitioyhued kenpaʼti huakuhuiʼa ʼitidukuthued o̱ʼu̱y. ");
INSERT INTO amrNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesúsa kenda oʼpe̱e̱depo, —‍Dakhueʼda o̱ʼe̱nigʼa kenpaʼda bueyhueʼ o̱ʼe̱a̱po. “Diosa ʼuruaʼda oʼkaʼ. Huadaknanada o̱ʼe̱,” aratbuta kanʼnopo̱e̱ʼpo keʼna dakhueʼ o̱ʼe̱. Kenpaʼti “Diosen Huasiʼpoa huadaknanada oʼkikaʼ. ʼUrunanada o̱ʼe̱.” Aratbuta kanʼhuaeʼpo keʼna dakhueʼda o̱ʼe̱. —‍Jesúsa oʼpe̱e̱depo oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","7","Ken Martataj Martaen huamaʼbuytaj kenpaʼti Lázarotaj diʼda oʼmaepo Jesús ke̱ya̱da nog bottaʼmeʼnoe o̱ʼe̱a̱huadpo Lázaro dakhueʼda o̱ʼe̱ eʼpe̱e̱deada bottaʼ huameʼnoe o̱ʼe̱depo, —‍Judea huadaribayo monhuaʼ. —‍Oroʼ huanigpe̱i̱kaʼeritaj monaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","—‍Huaboaʼda huida̱ onʼtaj eʼpaʼeaʼtaʼ boʼtipakmeʼne judío huairia Judeayaʼ. ¿Ke̱yo̱ menpaʼ onteʼti iʼhuaʼapo, huamanmadikaʼeri? —‍Oroʼ huanigpe̱i̱kaʼeria onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","—‍Huameʼnoe jeyda o̱ʼe̱nok aratbuta katepiʼ kahuaddik o̱ʼnikaʼ. Diostaj nigpe̱i̱kaʼdik o̱ʼne. Nogmeʼnoetida doce horas oʼtaʼtenok kahuaddik o̱ʼnikaʼ. Doʼtaj huaarak huameʼnoe ehued o̱ʼe̱nok doʼtaj arakhueʼdik meʼnene. Nogok ken horate huabuey Diosa baktieʼeaʼuyne ayaʼ Diosen eʼkadeʼte eʼkuhuitdeʼte doʼtaj arakdik meʼneapone. ");
INSERT INTO amrNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Sikyo taʼtehueʼ o̱ʼe̱nok katepiʼ kahueʼdik o̱ʼnikaʼ. —‍Jesúsa monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","—‍Doʼhued huadiʼ Lázaro oʼtaynigʼa, monhuaʼ, ijmaboaʼapoy. —‍Jesúsa monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","—‍Eʼtaynayo oʼyareapo oʼnopo̱e̱y, Huairi. —‍Oroʼ huanigpe̱i̱kaʼeria Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","O̱ʼa̱ro̱gpo oʼtay oroʼomeya̱ oʼnopo̱e̱po Jesústaj oknopo̱e̱gkahueʼ o̱ʼu̱y. Eʼbueytada “Oʼtay,” oaʼpo Jesúsa oʼbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Konige̱po, —‍Lázaro oʼbueymeʼte. ");
INSERT INTO amrNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Opud nogi̱ti doʼtaj menoknopo̱e̱ʼpo Lázarote i̱da ikken huahuahueʼ i̱jje̱mey. Konige̱po durugda i̱jje̱y. Lázarote monhuaʼ. —‍Jesúsa monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","—‍Oroʼomeykon monhuaʼ. Jesúsere aʼbueyyaʼpo monhuaʼ. —‍Oroʼomey huanigpe̱i̱kaʼeritaj Tomása monaʼuyne. Tomás konogda oʼdikkaʼ Gemelo. ");
INSERT INTO amrNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ken Jesúsere oʼhuaʼuy. Betaniayo e̱kye̱deʼte “Bottaʼ bottaʼ huameʼnoe Lázaro kubarakyo oʼhuedde.” Jesústaj oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betaniayo Jerusalén meyo̱hueʼda o̱ʼe̱. Konig dos kilómetros y medio o̱ʼe̱nok ");
INSERT INTO amrNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","María Martaeretaj aʼbataʼhuade̱ya̱ʼpo huakkaʼ judío huairi Betaniayo onʼtiakdepo, Jerusalénya̱ʼ onʼtiakdepo, aʼmanoeynoeya̱ʼpo onʼtiakuyate. Huidpoa oʼbakbueynok eʼmanoeynoeytaʼ onʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Jesús oʼtiakde Marta oʼpeeondepo aʼeyaʼpo o̱ʼo̱ro̱kʼuy. Maríanayo jakyo o̱ro̱khueʼ o̱ʼu̱y. ");
INSERT INTO amrNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","—‍Aʼnen bottaʼ bottaʼ huameʼnoete o̱ʼna i̱yo̱ ehueʼ i̱ʼe̱meʼne. On i̱yo̱ e̱ʼe̱meʼnayo doʼhued huidpo Lázaro bueyhueʼ o̱ʼe̱aymeʼ, Huairi. ");
INSERT INTO amrNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Oy kenpaʼti katepiʼ iʼpakpo Diostaj eʼtionaʼpaknayo beyokapone, ijnopo̱e̱y. —‍Martaa Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","—‍O̱ʼnen huidpo oʼnoyhuadapo. —‍Jesúsa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","—‍Nogok keneʼhua̱ya̱ʼ huameʼnoete ayaʼada onʼnoyhuada̱po. Keʼnakon oʼnoyhuadapo ijnopo̱e̱y. —‍Martaa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","26","—‍Huamanoyhuada̱ʼeri i̱jje̱po aratbut eʼbueyʼuytaj ijmanoyhuada̱ʼapoy. Diosere aratbuttaj durugda ijmanoeanhuahuikaʼapoy. Ayaʼada doʼtaj meʼnoknopo̱e̱po enʼbueynayo onteʼti kurudyo̱ Diosere onʼnoeonhuahuikaʼapo. Durugda onʼnoeonhuahuikaʼapo. Doʼtaj meʼnoknopo̱e̱po onʼnoeonhuahuikaʼapo. Onteʼti bueyhueʼdik o̱ʼneapo. ¿Kenda menpaʼ iʼnopo̱e̱, Marta? —‍Jesúsa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","—‍E̱e̱ʼ, kenda do ijnopo̱e̱y, Huairi. “Aratbuttaj kamanopoʼkoreʼpo Cristotaj ijtaʼmonaʼapoy. Doʼhued Huasiʼpo ijtaʼmonaʼapoy.” Aʼnennada Diosa oʼmanaʼuyate. Diosyaʼ oʼtiakuyate. O̱ʼna Cristo o̱ʼe̱. Diosen Huasiʼpo o̱ʼe̱, ijnopo̱e̱y, Huairi. —‍Martaa Jesústaj onaʼuy, ken. ");
INSERT INTO amrNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Kenda Martaa onaʼdepo huamaʼbuy Maríataj atotiakyaʼpo Maríate oʼhuahuaʼuyate. —‍Huamanmadikaʼeri oʼtiakdepo ontaj katiakeʼ behuaaʼne. —‍Jutakaʼ Martaa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","María oʼpeundepo i̱da oʼbodpo Jesústaj oʼhuahuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Huakkaʼ jakyo Jesús kudhued o̱ʼu̱y. Kenteda Martataj oʼbatiaʼpakpo kenteda o̱ʼe̱po. ");
INSERT INTO amrNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ken María i̱da oʼbodpo i̱da o̱ʼo̱ro̱konpo. Judío huairi onʼbataʼhuadpo, onʼmanoeynoeypo Maríataj onʼtiahuaydepo kubarakyaʼ aʼhuikyaʼpo oʼhuaʼ onʼnopo̱e̱po onʼtaʼhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Jesústaj oʼhuatiakdepo Jesúsen huaʼitaʼpote huikudate oʼtihuadpo. —‍Aʼnen bottaʼ bottaʼ huameʼnoete o̱ʼna i̱yo̱ ehueʼ i̱ʼe̱meʼne on i̱yo̱ e̱ʼe̱meʼnayo doʼhued huidpo Lázaro bueyhueʼ o̱ʼe̱aymeʼ, Huairi. —‍María Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Kenda María onaʼdepo oʼhuik. Lázarotaj oʼhuikuy. Judío huairi kenere onʼhuatiakdepo kenere onʼbahuikpo. Maríaomey enhuikte Jesúsa oʼbatiahuaydepo sueʼe̱a̱da o̱ʼe̱po oʼmepuʼketuʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","—‍¿Lázarotaj meyo̱ ya̱gkubarakkameʼ? —‍Jesúsa oʼmanaʼuy. —‍Yatiak. Yatiahuayʼ, Huairi. —‍María Martaerea oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ken Jesúskon oʼhuikonʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","—‍Dapitaʼ Lázarotaj diʼnanada o̱ʼunhuahuikaʼ. —‍Judíoa onʼhuaaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","—‍Huabokerek ekpobigtaj okpoyareameʼ. ¿Lázarotaj bueyhueʼ ka̱e̱ʼpo menpaʼ Jesúsa yareahueʼdik o̱ʼe̱meʼte? —‍Sueʼada judíoa onʼbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Onteʼti Jesúsa huanopoyaʼda sueʼnanada o̱ʼe̱po kubarakte oʼhuatiakonpo Lázarotaj kubarakyo onʼhueda̱meʼte. Huaboroʼhuida̱da kubarak onʼtinokbetaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","—‍Huaboroʼhuid yanokpokoreaʼ. —‍Jesúsa oʼmanaʼuy. —‍Aʼnenda bottaʼ bottaʼ huameʼnoe oʼbueymeʼpo oyda pa̱gda o̱ʼe̱deta, Huairi. —‍Eʼbueyen huidpoa Martaa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","—‍“Eknopo̱e̱ʼnayo Diosa ʼuruaʼnanada oʼkaʼapo. Dios ʼurunanada o̱ʼe̱ ayaʼada onʼtiahuaypo onʼnopo̱e̱a̱po,” onaʼdene. —‍Jesúsa Martataj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ken huaboroʼhuid eʼtinokbetaʼ oʼnokpokoreaʼuy. Jesúsa kurudyon oʼmabopo, —‍Doʼtaj oʼnigpe̱e̱nok, Apag, dakiti onaʼne. ");
INSERT INTO amrNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","43","Doʼtaj kiriga̱yo̱ʼ menigpe̱e̱ne, ijnopo̱e̱y. Doʼtaj oʼtaʼmonaʼuyne in aratbuta kanoknopo̱e̱ʼpo “dakiti, Apag” onaʼne. —‍Jesúsa oʼtionaʼpakdepo, —‍Ya̱o̱ro̱k, Lázaro. —‍ʼUttaʼda onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Eʼbueymeʼada oʼnoyhuaddepo o̱ʼo̱ro̱kpo huaʼitaj huabaʼtaj huakoktakon huabid telaa eʼtihui̱yi̱g o̱ʼo̱ro̱konʼuy. Ken konig Lázaroa o̱ʼo̱ro̱kuy. —‍Yanʼtikuj, kahuaʼeʼ. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Judíomey Maríataj aʼtaʼhuade̱yaʼpo onʼhuatiakmeʼtenigʼa kenda Jesúsa oʼkaʼ onʼtiahuaydepo huakkaʼada oʼnoknopo̱e̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Sueʼada fariseo huairitaj onʼbahuahuaʼpo, kenda Jesúsa oʼkaʼde fariseo huairiomeytaj onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ken fariseoere sacerdote huairiere nog judío huairiere onʼkupopakdepo, —‍¿Kate oʼkaʼapo? Ken huabokerek konig Diosayoʼda kaʼdik o̱ʼe̱nig oʼkaʼ. Oʼbayareaʼ. Kenpaʼti oʼnoyhuada̱ʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Kentaj batikahueʼ e̱e̱ʼnayo ayaʼada kentaj oʼnoknopo̱e̱a̱po, kentaj ayaʼada onʼnigpe̱i̱kaʼapo. Jesús oroʼen huairi o̱ʼe̱. Aratbuta onʼbatiaʼpakapo Roma huairia kenda onʼtipe̱e̱dete boʼhuadiayapone, sorotataj moʼtitaʼmonaʼapone. Oroʼtaj mogkaʼapone. Kenpaʼti oroʼen Diosen jak onʼsakaʼapo. —‍Judío huairi huayahuaya onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","50","—‍Opudomeya̱ sigpiʼ nopo̱e̱hueʼda moʼe̱ne. Aratbuttaj nogtiada eʼmanigbueynayo oroʼtehuapaʼ huadakda o̱ʼe̱a̱po. Ayaʼda judío aratbut mabueyhueʼ kaʼneʼpo nogtiada manigbueydik o̱ʼe̱a̱po. Kenda nopo̱e̱hueʼ moʼe̱ne. —‍Caifása oʼmanaʼuyate. Caifás kenbayokte huaboroʼ sacerdote huairi o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","52","Caifásada oʼnopo̱e̱po kenda manahueʼ o̱ʼu̱ynigʼa kenbayok sacerdote huairi e̱e̱ʼte Diosa oʼnopo̱e̱a̱ʼnok “Ayaʼtada judío aratbuttaj Jesúsa oʼmanigbueyapo. Kenpaʼti Diosen aratbut, judío aratbut kenpaʼti nog aratbuttaj kamanopoʼkoreʼpo Diostaj konigti kanoknopo̱e̱ʼpo Jesúsa oʼmanigbueyapo.” Kenda sacerdote huairia oʼbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Caifás kenda eʼmanadeʼte “Jesústaj monig oʼarakapo.” Judío huairia huaboaʼda onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Judío huairia eʼaraktaʼ onʼtipaknok ke̱yo̱ huakkaʼ judío aratbut e̱gkupopakyo onteʼti Jesús huahueʼ o̱ʼu̱y. Nogyo̱ oʼhuaʼuy. Efraín huakkaʼ jakyo oʼhuaʼuy. Oroʼ huanigpe̱i̱kaʼeriere oʼhuaʼuy. Efraínyo sueʼda aratbut o̱ʼneʼuy. Kenpaʼti Efraín kurute sueʼada aratbut o̱ʼnuy. Oroʼomeyere o̱ʼi̱kaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Aʼti judío huakkurueri isiʼpo mabueyhueʼ e̱e̱ʼ okkahuehueʼ fiesta o̱ʼe̱a̱po. Nogya̱ʼ nogya̱ʼ nog huakkaʼ jakyaʼ nog huakkaʼ jakyaʼ Jerusalényo̱ huakkaʼda judío aratbut onʼbahuaʼuy. Fiesta ehued onʼbahuaʼuyate. Fiestayaʼ aʼbapeyaʼpo aʼmayaʼpo Diostaj ʼuru ʼuhua e̱ʼhua̱e̱ʼ onʼnigbatiarakuyate ʼurunopoʼda Diostaj aʼnigeyapo. Konige̱po fiesta kahued konig huakkuruda onʼhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Jerusalényo̱ o̱ʼnedepo onʼhuaʼepo Jesústaj oʼnonmabopo. Diosen jakyo o̱ʼnedepo, —‍¿Menpaʼ moʼnopo̱e̱? ¿Menpaʼ Jesús fiestate yatiakapet? ¿Tiakhueʼ ya̱ʼe̱a̱petpiʼ? —‍Judío aratbuta huayahuaya onpayoʼ onʼbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","“Beʼapiʼ Jesústaj eʼtiahuaynayo oroʼtaj monatiʼ.” Sacerdote huairiomey fariseo huairiere onʼmanaʼuyate. Jesústaj huabakuda̱ʼ jakyo kanʼtohueʼpo kenda onʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Aʼtimon seis huameʼnoe eʼpokdeʼte judío aratbuten huakkurueri isiʼpo mabueyhueʼ e̱e̱ʼ okkahuehueʼ fiesta o̱ʼe̱a̱po, Jesús Betania huakkaʼ jakyo oʼtiakuy. Ke̱yo̱ Lázaro o̱ʼi̱kaʼuy. Jesúsa Lázarotaj eʼbueymeʼtada oʼnoyhuada̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Jesústaj ʼuru aypo onʼnigmanhuada̱ʼuy. Martaa aypo oʼmabayokeʼuy. Jesúsere Lázaro oʼbapeʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ken onʼbapeʼdepo ʼuruʼhui̱e̱da huasihuaj María oʼtotiakpo, konig medio litro oʼtotiakpo nardo huasihuaj huakkaʼteda e̱e̱ʼtada oʼtotiakpo Jesústaj huakkaʼ oʼpakpo María Jesúsenʼitaj oʼitioypo oʼihuekedepo, huakuhuiʼakon oʼitidukutʼuy. Jakyaʼ ayaʼada huasihuaj ʼuruʼhui̱e̱ʼtaj onʼhui̱ri̱kuy. ");
INSERT INTO amrNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","5","—‍¿Menaʼpo kenda yakaʼ? ¿Menaʼpo ken ʼurusihua bahuayahueʼ ya̱ʼe̱meʼ? Paiʼda aratbuttaj kanʼyokeʼpo ¿Menaʼpo bahuayahueʼ ya̱ʼu̱y? Huakkaʼteda e̱e̱ʼtada o̱ʼe̱. Konig trescientos denarioshuapa huakupe e̱e̱ʼtada o̱ʼe̱. —‍Judasa oʼmanaʼuy. Judas Simónensiʼpo o̱ʼu̱y. Judas Jesúsen huanigpe̱i̱kaʼeri e̱ʼe̱a̱da Judío huairia kadarakeʼpo Judasa oʼbayokapo. ");
INSERT INTO amrNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Paiʼda aratbuttaj matinepahuihueʼada huabereeri o̱ʼe̱po eʼberetaʼ oʼpakpo kenda oʼmanaʼuy. Huabereeri o̱ʼe̱ kenda oroʼomeya̱ Jesúsen huanigpe̱i̱kaʼeria nopo̱e̱hueʼ o̱ʼu̱y. Judas oroʼen huakupe huamato̱e̱ʼeri o̱ʼi̱kaʼnigʼa oroʼen huakupe oʼberikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","—‍Kejeʼ, dakhueʼ huaahueʼ ya̱e̱ʼ Maríataj. Aʼti oʼbueyapo María oʼnopo̱e̱po ʼuruʼhui̱e̱da huasihuaj meʼnigtoeonhuahuikaʼpo beʼitihuekene. ʼUruso̱ʼda kanʼkubarakkeʼpo meʼso̱ʼtihuekene. ");
INSERT INTO amrNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Paiʼda aratbuttanayo moʼmato̱i̱kaʼapone. Doʼtanayo to̱e̱hueʼ o̱ʼnunhuahuikaʼapone. —‍Jesúsa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jesús Betania huakkaʼ jakyo o̱ʼe̱a̱ʼ, huakkaʼ judío aratbuta onʼtipe̱e̱po Betaniayo Jerusalénya̱ʼ onʼbahuaʼpo. Jesústayoʼda aʼtiahuayaʼpo huahueʼ o̱ʼnuy kenpaʼti Lázarotabetaʼ eʼtiahuaytaʼ onʼpakpo Betaniayo onʼhuaʼuy. Lázarotaj oʼnoyhuada̱meʼte Jesúsa. ");
INSERT INTO amrNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Huakkaʼada judío aratbuta onteʼti judío huairitaj eʼnigpe̱i̱kaʼtaʼ pakhueʼ o̱ʼnepo onʼbakhuaʼpo Jesústaj oʼnoknopo̱e̱ʼuy. Konige̱po judío sacerdote huairi Lázarotakon onʼhuadiaypo “Lázarotaj moʼdarak,” konigti onpapayoʼ onʼnopo̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Judío huakkurueri isiʼpo mabueyhueʼ e̱e̱ʼ okkahuehueʼ fiesta aʼbapeyaʼpo huakkaʼada aratbut Jerusalényo̱ onʼbahuaʼdepo oʼnokye̱depo. Emeʼte “Jerusalényo̱ Jesúsa oʼtiakonyakde,” huakkaʼada onʼtipe̱e̱depo ");
INSERT INTO amrNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","huabotod onʼbaktegandepo Jesúste onʼto̱ro̱konpo onʼnigtohuaʼpo, —‍Oroʼomeytaj kabatiokeʼpo Diosa moʼnigtaʼmonaʼuyate. Dios huairia moʼnigtaʼmonaʼuyate. Huadaknanada o̱ʼe̱. Israel aratbuten gobierno huairitoneʼ o̱ʼe̱. Dakiti Dios. —‍Jesústaj onʼhuahuaʼpo ʼuttaʼnanada onʼdaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesúsa burrotaj oʼhuahuaypo kentaʼpite oʼhuaduy. Jesús siʼpoe̱hued e̱e̱ʼte Apagbaʼte kenpaʼ o̱ʼe̱a̱po oaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Jerusalényo̱ hua̱e̱ʼeria moʼe̱po opuden huairi eʼtiakte meʼpukhueʼdik moʼe̱. Burrote oʼhuadpo opudomeyen huairi oʼtiakapo. Apagbaʼte kenpaʼ oʼmadoyaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Jesús burrote eʼhuaddeʼte kenda Apagbaʼte Jesústaj oʼtiaʼpakuynig oroʼomey Jesúsen huanigpe̱i̱kaʼeria nopoenkahueʼ o̱ʼu̱y. Nogoknayo Jesús kurudyo̱ oʼbehuikdepo kenpaʼti Diosen Noki̱re̱g moʼnopoʼto̱e̱denok kenda Jesústaj Apagbaʼte oʼtimadoyaʼuyate konigti Jesúsa kenda oʼkaʼuynok huaboaʼda oʼnopoenkaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Kenokaʼ Jesúsa Lázarotaj eʼbueytaʼ eʼnoyhuada̱ʼte kenpaʼti “Ya̱o̱ro̱k, Lázaro,” enaʼte huakkaʼada judío aratbuta onʼtiahuayʼuy. ʼUruaʼnanada Jesúsa oʼkaʼnok kenda Jerusalényo̱ diga̱ʼda onʼmanbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Konig Diosayoʼda kaʼdik o̱ʼe̱ Jesúsa oʼkaʼdenok huakkaʼada aratbuta onʼnopo̱e̱depo Jesústaj onʼhuahuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","—‍Paj, kentaj batikahueʼdik o̱ʼe̱y oroʼ. Yanʼtiahuayʼ, ayaʼada kentaj onʼpakpo onʼnigpe̱i̱kaʼ. —‍Fariseo huairia huayahuaya onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Fiestate Jerusalényo̱ huakkaʼda onʼbatiakuyate. Diostaj aʼtionaʼpakyaʼpo onʼbatiakuyate. Judíoere griego huaʼa huaaʼpakeri onʼbatiakuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Felipe Jesúsen huataʼmonaʼeri o̱ʼe̱po Betsaida huakkaʼ jak hua̱e̱ʼeri kenpaʼti Galilea huadarieri o̱ʼe̱nok sueʼda griego huaʼa huaaʼpakeria Felipetaj onʼhuatiakpo, —‍Jesústaj eʼbatiaʼpaktaʼ oʼpaki, huairi. —‍Felipetaj oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Felipe Andréste oʼbakhuaʼpo kenda griego huaʼa huaaʼpakeria oʼnonaʼde Andréstaj onaʼuy. Felipe Andrésere onokteyoʼ Jesúste onʼhuaʼuy. Kenda griegoa oʼnonaʼ Jesústakon oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","—‍Aʼti Diosa oʼtaʼmonaʼuy ayaʼada onʼnopo̱e̱a̱po. Ayaʼtada ijmanigbueyapoy. Ayaʼtada ijmanignoyhuadapoy. Konig Huairitoneʼ Apag Diosere i̱jjeunhuahuikaʼapoy. ");
INSERT INTO amrNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Doʼa ayaʼtada manigbueyhueʼ e̱e̱ʼnayo kenpaʼti kubarakyo kudhueʼ e̱e̱ʼnayo Diosere noeonhuahuikahueʼdik o̱ʼneapo. Ken konig toketkid o̱ʼe̱, ijmanbatiaʼpaki. Toketkid batukehueʼ e̱e̱ʼnayo konig kidpoaghueʼ e̱e̱ʼnayo tipakbohueʼ o̱ʼe̱a̱po, huakkaʼ toket boyoghueʼdik o̱ʼe̱a̱po. Sorokyo ʼuruaʼda eʼbatukeʼnayo nogok huakkaʼ toket oʼboyogapo. Huakkaʼda toket o̱ʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Doʼtaj kenpaʼti Apag Diostaj pakhueʼ o̱ʼnepo ayaʼada hua̱ʼenda onʼeretpakpo, katetapiʼ oʼderetpakpo, aratbuttaj oʼderetpakpo, huabettaj oʼderetpakpo kenpaʼda onʼmabueyapo. Nogomeynayo ayaʼtada huataʼda pakhueʼ o̱ʼnepo, katetaʼpiʼ eretpakhueʼ o̱ʼnepo doʼtayoʼda onʼpakpo doʼtayoʼda onʼnigpe̱i̱kaʼpo Diosere onʼnoeonhuahuikaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Beʼapiʼ doʼtaj eʼnigpe̱i̱kaʼtaʼ eʼpaknayo konig ijkikay konigti kanʼkikeʼ, konig do paiʼda ijnopoʼi̱kay konigti paiʼda kanʼnopoʼi̱keʼ, konig do huataʼda ijpakpo kahueʼ i̱ji̱kay konigti huataʼda kanʼpakpo kahueʼ kaʼnikeʼ kenokaʼ doere doʼhued Apagere kurudyo̱ o̱ʼneonhuahuikaʼapo. Kenomey doʼtaj onʼnigpe̱i̱kaʼ kenomeytaj Diosa oʼbakkahueaʼapo, “Huadakda moʼe̱ne.” Diosa oʼmanaʼapo. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Huakkaʼtada paiʼda ijmanignopoʼe̱a̱poy. Huakkaʼtada ijmanigbueyapoy. Huakkaʼda eʼmeʼpukeada “Bueyhueʼ a̱ʼe̱ya̱ʼpo beʼtiokaʼ, Apag” onahueʼ o̱ʼe̱ne. Aʼmanigbueyyaʼpo kurudya̱ʼ ijtiakuy. ");
INSERT INTO amrNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ontaj ijnigpe̱i̱kaʼpo ijmanigbueynok “Huadaknanada o̱ʼe̱ Dios. Huakkaʼ diʼda oʼmaikaʼ. Huakkaʼ oʼmatinepahuiʼikaʼ.” Ayaʼada aratbuta kenda kanʼbatiaʼpakikeʼpo. Jesúsa kenpaʼ oʼtionaʼpakuy. —‍Doʼtaj meʼnigpe̱i̱kaʼnok “Huadaknanada o̱ʼe̱ Dios.” Ayaʼ aratbutada kanʼnopo̱i̱keʼ nogok onaʼti konigti kanʼnopo̱i̱keʼ. —‍Kurudya̱ʼ Diosa ʼuttaʼda onaʼnok Jesúsa oʼpe̱e̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Huakkaʼada aratbuta o̱gkupobopo onʼpe̱e̱depo, “Kuruda oaʼ,” onʼbatiaʼpakpo. “Diosen huataʼmoneria oʼdaʼ.” Nogomeya̱ onʼbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","—‍Doʼtayoʼda kenda Diosa onahueʼ meʼe̱ne. Opudomey doʼtaj kaʼnoknopo̱e̱ʼpo kenda menaʼne. ");
INSERT INTO amrNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Doʼtaj eknopo̱e̱ʼtaʼ pakhueʼ o̱ʼnepo doʼtaj eʼnigpe̱e̱taʼ pakhueʼ o̱ʼnepo aʼti doʼtaj enʼarakdeʼte “Dakhueaʼnanada boʼkaʼne. Doʼtaj nigpe̱e̱hueʼ moʼe̱ne. Castiga o̱gkaʼdik o̱ʼneapone.” Diosa oʼmanaʼapo. Kenpaʼti totoʼtaj Diosa konigti o̱gkaʼapo onteʼti huairitoneʼ ehueʼ o̱ʼe̱a̱po. Ayaʼtada onteʼti namaʼda manahueʼdik o̱ʼe̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Do cruzte ijbueyapoy. Cruzte ijbueydepo ijnoyhuadapoy. Kurudyo̱ Dioste ijhuaʼapoy. Ayaʼ aratbuta doʼtaj eʼnoknopo̱e̱deʼ Diosensiʼponig o̱ʼneapo. Kurudyo̱ ijbatobehuikapoy. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Cruzte ijbueyapoy Jesúsa dakaʼ oʼmanbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","—‍Oroʼen Apagbaʼ eʼmonaʼpakte oʼpe̱e̱po Dios Cristotaj oʼtaʼmonaʼaponok oroʼtaj boʼtiokadhuahuikaʼapone. Kenpaʼda Cristo bueyhueʼ o̱ʼe̱po oʼnoeonhuahuikaʼapo. Diosa ontaj eʼtaʼmonaʼnayo, “Cruzte ijbueyapoy.” ¿Menaʼpo iaʼ kenpaʼ? Diosa huabokerektaj oʼtaʼmonaʼapo. ¿Beʼa ya̱ʼe̱a̱po? —‍Aratbuta o̱gkupopakpo nogtiada Jesústaj kenpaʼ onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","—‍Sueʼda huameʼnoe opudomeyere i̱jje̱a̱poy. Konig huakjey i̱jje̱po Diostaj kanoknopo̱e̱ʼpo oʼnonmadikaʼne. Konig Diostaj eknopo̱e̱ʼ kenpaʼti eʼnigpe̱e̱ʼ onʼtiahuayaʼne. Sueʼda huameʼnoe opudere i̱jje̱a̱ponok opudere e̱e̱ʼte doʼtaj dakaʼ menʼpe̱e̱ʼ kenpaʼti dakaʼ Diostaj yanoknopo̱e̱ʼ. Doʼtaj dakaʼ nigpe̱e̱hueʼ e̱e̱ʼnayo konig sikki̱re̱gyo̱da moʼe̱a̱pone. Diostaj menpaʼ oknopo̱e̱hueʼdik moʼe̱a̱pone. Diosen dag huahuayhueʼdik moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Do opudomeyere e̱ʼe̱deʼte doʼtaj meʼnoknopo̱e̱ʼ. Diosen aratbut a̱ʼe̱ya̱ʼpo doʼtaj meʼnoknopo̱e̱ʼ. —‍Jesúsa oʼmanaʼuy. Kenda oʼmanaʼdepo Jesús oʼbakhuaʼpo oʼi̱re̱ge̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Konig Diosayoʼda kaʼdik o̱ʼe̱ aratbut kanʼtiahuayeʼpo Jesúsa nogda nogda oʼkikaʼuynigʼa aratbuta enʼtiahuayte oʼbayareaʼuy. Nogtaj oʼnoyhuada̱ʼuynigʼa Jesústaj oknopo̱e̱hueʼ o̱ʼnuyate. Huakkaʼ judío aratbuta oknopo̱e̱hueʼ o̱ʼnuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Konig Diosen huamanigbatiaʼpakeri Isaíasa oaʼuyate, aʼnennanada oaʼuyate konigti o̱gkaʼuy. Jesústaj oknopo̱e̱hueʼ o̱ʼnuy. Isaías oʼmadoyaʼpo, O̱ʼnen huaʼa onʼpe̱i̱kaʼnigʼa konig huabokereknayo kahueʼdik o̱ʼnikaʼ konig teyda iʼkikaʼnig onʼtiahuayikaʼnigʼa oknopo̱e̱hueʼ o̱ʼnikaʼ. O̱ʼnen huaʼa oʼmanaʼnigʼa oknopo̱e̱hueʼ o̱ʼne, Dios Huairi. Isaías aʼnennanada oʼmanigmadoyaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Menaʼpo oknopo̱e̱hueʼdik o̱ʼne onteʼti Isaías oʼmadoyaʼuyate, ");
INSERT INTO amrNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Diostaj pakhueʼ o̱ʼnenok Diosa oʼbakpobiga̱ʼuy. Kenpaʼti nopoenkahueʼ e̱ʼhua̱e̱ʼ oʼmagkaʼnok onteʼti ʼuruda Diosen eʼkaʼ menpaʼ tiahuayhueʼdik ya̱ʼneapet. Diosen huaʼa menpaʼ nopoenkahueʼdik ya̱ʼneapet. Dakhueaʼ eʼkaʼ aʼnopoʼkoreayaʼpo Diostaj menpaʼ nopoʼkoreahueʼdik ya̱ʼneapet. Isaíasa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Jesús paiʼnanada oʼmanignopoʼe̱po oʼmanigbueypo oʼnoyhuadpo Diosyo oʼbehuikpo kenda Diosa Isaíastaj oʼnopo̱e̱a̱ʼuyate. Konige̱po judío aratbuta Jesús, Diosen Huasiʼpotaj eknopo̱e̱ʼtaʼ pakhueʼ ya̱ʼneapet. Kenpaʼti eʼnigpe̱e̱taʼ pakhueʼ ya̱ʼneapet. Isaíasa aʼnennanada oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Huakkaʼamon judío aratbut Jesústaj oʼnoknopo̱e̱ʼuynigʼa sueʼda huakkaʼ huairiakon oʼnoknopo̱e̱ʼuyatenigʼa Jesústaj yoknopo̱e̱y aratbuta kanʼpe̱e̱ʼpo batiaʼpakhueʼda fariseo huairitaj onʼmeʼpukpo batiaʼpakhueʼ o̱ʼneʼuyate. Jesústaj yoknopo̱e̱y aratbuta eaʼpaknayo onteʼti judíoen hua̱i̱takeʼ jakyo kudhueʼdik o̱ʼneapo. Fariseo huairia onʼmanaʼuynok. ");
INSERT INTO amrNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Kenpaʼti “Huadakda i̱ʼe̱ne.” “ʼUruda huairi i̱ʼe̱.” Aratbuta eaʼtada ekpe̱e̱taʼ oʼderetpakpo Diosa kenda eaʼtaʼ ekpe̱e̱taʼ pakhueʼ o̱ʼnepo Jesústaj yoknopo̱e̱y ahueʼ o̱ʼnuy. ");
INSERT INTO amrNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","—‍Apag Diosa oʼtaʼmonaʼuy. Ayaʼada doʼtaj eknopo̱e̱nayo Diostaere oknoponhuaʼdik moʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Kenpaʼti ayaʼada doʼtaj mentiahuaypo Diostakon onʼtiahuay. Keʼna meʼtaʼmonaʼuynigtaj. ");
INSERT INTO amrNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Huadariyo aratbutte ijtiakuy. Konig huakjey Diostaj aʼmaknopo̱e̱a̱yaʼpo ijtiakuy. Doʼtaj huaknopo̱e̱ʼeria Diostakon oʼnoknopo̱e̱a̱po. ʼUruda kikaʼdik o̱ʼneapo. Konig sikki̱re̱gyo̱ ehueʼ o̱ʼnikaʼapo. Dakhueaʼ onteʼti kikahueʼ o̱ʼneapo. ");
INSERT INTO amrNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Sueʼda huakkaʼ doʼhued huaʼataj nigpe̱e̱hueʼ moʼe̱a̱pone. “Dakhueaʼ bokaʼne,” manahueʼdik i̱jje̱a̱poy. “Dakhueaʼ iʼkaʼne,” aʼmanayaʼpo tiakhueʼ i̱jje̱ʼuy. Aratbuttaj aʼmanopoʼkoreayaʼpo ijtiakuy. Aratbuttaj aʼmanoeanhuahuikayaʼpo ijtiakuy. ");
INSERT INTO amrNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Doʼtaj pakhueʼ hua̱e̱ʼeritaj kenpaʼti doʼhued huaʼataj nigpe̱e̱hueʼ hua̱e̱ʼeritaj “Dakhueaʼ boʼkikaʼuyne.” Keneʼhua̱ya̱ʼ huameʼnoete doʼhued huaʼaʼa oʼmanaʼapo. Diosa castiga oʼmagkaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Konig doada ijnopo̱e̱po konig doada ijpakpo manahueʼ i̱ji̱kay. Apag Diosa meʼtaʼmonaʼuyne. Kenda Apaga menaʼuynig ijmanmadikikaʼpo oʼnonaʼne. ");
INSERT INTO amrNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Diosen huaʼa oʼnonaʼikaʼnig keʼna moʼnoeanhuahuikaʼapone. Doʼtaj eknopo̱e̱ʼnayo moʼnoeonhuahuikaʼapone. Apag Diosen huaʼa oʼnonaʼikaʼne. —‍Jesúsa judío aratbuttaj ʼuttaʼda oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Aʼti judío huakkurueri isiʼpo mabueyhueʼ e̱e̱ʼ okkahuehueʼ fiesta o̱gkaʼapo. Fiesta aypo onʼbapeʼapo. Bapehued e̱ʼneʼte, “Indaritaj yokhuaʼapoy. Doʼhued Apagtaj onteʼti ijkumejapoy.” Jesúsa oʼnopo̱e̱ʼuy. Oroʼtaj keʼnen huanigpe̱i̱kaʼeritaj diʼ moʼi̱kaʼpo oynayo huakkaʼnada diʼ moʼe̱po moʼnigbueydeapone. ");
INSERT INTO amrNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","Oroʼomey Jesúsen huanigpe̱i̱kaʼeri Jesúsere judío huakkurueri isiʼpo mabueyhueʼ e̱e̱ʼ okkahuehueʼ fiesta aypo huaboaʼda oʼbapeʼdeapoy. Totoʼa Judas Iscariotetaj engaña o̱gkaʼdepo, oʼnopoʼto̱e̱po Jesústaj judío huairitaj aʼbayoki oʼnopo̱e̱a̱ʼuy totoʼa. Judas Iscariote Simónensiʼpo o̱ʼu̱y. Jesúsere Judas Iscariote oʼbapeʼpo. Kenokaʼ Diosyaʼ ijtiakuy. Diosyo ijhuaʼapoy. Diosen ayaʼda ijtamato̱e̱apoy. Ayaʼada doʼtaj nigpe̱e̱dik o̱ʼneapo. Jesúsa oʼnopo̱e̱ʼuy. Ken Jesús oroʼere oʼbapeʼpo oʼbopo, huaok oʼkirokaʼpo oʼhueda̱ʼpo hua̱so̱ʼtidukuta oʼteyi̱gaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Huaʼikoyoaʼ hue̱ʼe̱y kosoyo onoydepo huaboaʼda oroʼen huaʼi boʼikoyoaʼpo boʼikoyoaʼdepo hua̱so̱ʼtidukuta eʼteyi̱ga̱ʼa̱ boʼitidukutaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Simón Pedrotakon eʼhuatiakte aʼikoyoyaʼpo —‍Huairi i̱ʼe̱ne. Doʼhued huaʼi menpaʼ iʼikoyoaʼapo, doʼhued Huairi. —‍Simón Pedroa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","—‍Kenda ijkay oyda noponkahueʼ i̱ʼe̱nigʼa nogoknayo iʼnopo̱e̱a̱po. —‍Jesúsa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","—‍Kejeʼ. Menokapiʼ doʼhuedʼi ʼikoyoahueʼdik o̱ʼe̱ne. —‍Pedroa onaʼuy. —‍O̱ʼnenʼi ʼikoyoahueʼ e̱e̱ʼnayo doere Apag Diosere ehueʼdik i̱ʼunhuahuikaʼapone. —‍Jesúsa Pedrotaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","—‍Kenda menaʼne. Hua̱so̱ʼ ayaʼda bekoyoʼ. Huaʼi, huabaʼ, huakukon bekoyoʼ, Huairi. —‍Simón Pedroa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","—‍Huaboaʼda e̱ʼo̱o̱ʼdeʼte ayaʼda eʼkoyodeʼ onteʼti koyohueʼdik moʼe̱po. Jakyo eʼtiakdeʼte huaʼiyoʼda sorokda o̱ʼe̱nok huaʼiyoʼda koyoaʼdik moʼe̱ne. Opudomeytaj Diosa moʼbakkahueaʼdepo ʼurunopoʼda moʼe̱nigʼa nogtiada dakhueʼda o̱ʼe̱. —‍Jesúsa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","—‍Nogtiada dakhueʼda o̱ʼe̱. —‍Onaʼuy. Nogtiada dakhueaʼ oʼkaʼapo. Judío huairitaj meʼbahuayaʼapone Jesúsa oʼnopo̱e̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Oroʼen huaʼi boʼikoyoaʼdepo oʼkuhuitdepo Jesús onteʼti huaok oʼotpo oroʼomeyere kutopate oʼhuadʼuy. Oʼhuaddepo, —‍Kenda opudtaj huaboaʼda oʼnogkaʼdepo opudtaj eʼnopoenkaʼtaʼ ijpaki. ");
INSERT INTO amrNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","“Huamanmadikaʼeri” doʼtaj oʼnonikaʼne, kenpaʼti “Huairi” oʼnonikaʼne. Kenda buttida oʼnonikaʼne. Kenda i̱jje̱y. ");
INSERT INTO amrNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ken do opueden Huairi i̱jje̱po opuden Huamanmadikaʼeri i̱jje̱po konig huanabaʼ opuden huaʼitaj onʼikoyoaʼdenok opudomeya̱kon konigti huayahuaya baʼikoyoaʼdik yanikatiʼ. Huayahuaya batihuapokikaʼdik yanikatiʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Opuden huaʼi konig huanabaʼniga̱ onʼikoyoaʼne doʼtaj onʼtiahuaydene. Konig do ijkay konigti ya̱gʼkikaʼ. Konig huanabaʼniga̱ huayahuaya yanʼbatiahuapokikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Opud huanabaʼ e̱ʼe̱a̱da “Huaboroʼ huairi i̱jje̱y.” Nopo̱e̱hueʼ yaneʼ. “Doʼhued huairinayo sueʼda huairi o̱ʼe̱.” Nopo̱e̱hueʼ yaneʼ. Huamataʼmonaʼerinayo huairi o̱ʼne. Huahuaʼerinayo huairionig ehueʼ o̱ʼne. Yanʼnopo̱e̱ʼ. Buttida ijjay. ");
INSERT INTO amrNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Kenda huaboaʼda oʼnonaʼnig opud eʼnopo̱e̱ʼnayo kenpaʼti dakaʼ menigpe̱i̱kaʼnayo durugnanada moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Opudomey doʼtaj moʼpe̱e̱po durugda moʼe̱a̱ponigʼa nogtiada durugda ehueʼdik o̱ʼe̱a̱po. Opudomeytaj oʼnoktieʼeaʼuynigʼa nogtiada dakhueaʼ megkaʼapone. Kentaj Apagbaʼa oʼhuaaʼ. “Keʼna doere oʼbapeʼikaʼ doʼtaj dakhueaʼ megkaʼapone.” Kenpaʼ Apagbaʼa oaʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Dakhueaʼ megkaʼapone. Dakhueaʼ o̱gkahued e̱e̱ʼted oʼnonaʼne. E̱gkadeʼte doʼtaj oʼnoknopoeonhuahuaʼpo batikhueʼ moʼe̱po Diosa oʼtaʼmonaʼuy, kenda kanoknopoeonhuahuikeʼpo konige̱po oyda oʼnonaʼne. Konig huakkuruteda oʼnonaʼne. ");
INSERT INTO amrNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Huadak huaʼa kanʼmanbatiaʼpakeʼpo opudomeytaj onʼtaʼmonaʼne. Nogomeytakon ijmataʼmonaʼapoy. Opudomeya̱ eʼmanmadikaʼte eknopo̱e̱ʼnayo doʼtaj eeʼpaʼti unhuaʼdik o̱ʼneapo. Kenpaʼti Diostaj eeʼpaʼti unhuaʼdik o̱ʼneapo. Diosa meʼtaʼmonaʼuynigtaj. Buttida ijjay. —‍Jesúsa monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jesúsa kenda monaʼdepo huakkaʼda oʼnopomeʼpukatupo, —‍Opuda̱ nogtiada meʼbahuayapone. Judío huairitaj menʼyokapone. Buttida oʼnonaʼne. —‍Jesúsa oroʼ doce huanigpe̱i̱kaʼeriomeytaj dakaʼ monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Betaj Jesúsa yaʼhuaet oroʼ nopo̱e̱hueʼ o̱ʼe̱po huayahuaya oʼbatiahuayeʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jesús diʼnanada meʼe̱ne doʼtaj Jesúsere onokteteyoʼ ijbapeʼnok, ");
INSERT INTO amrNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","doʼtaj Simón Pedroa baʼbaʼ menepo, “¿Beʼtaj yaʼhuaet? Kenda menaʼ.” Simóna menaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ken Jesústaj ijtipebetpo, —‍¿Beʼa ontaj dakhueaʼ mogkaʼapone, Huairi? —‍Jesústaj yonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","—‍Pan hue̱ʼe̱yyo̱ ijtaʼbutapo ijyokapoy. Keʼna dakhueaʼ megkaʼapone. —‍Jesúsa menaʼuyne. Ken pan oʼtaʼbutaʼdepo Judas Iscariotetaj oʼyokuy. Judas Iscariote Simónensiʼpo o̱ʼu̱y. ");
INSERT INTO amrNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Ken Judas pan onbaʼpokdepo oʼbapeʼpo eʼbapeʼdeʼ totoʼa Judastaj oʼnopoʼto̱e̱ʼpo Jesústaj dakhueaʼda ka̱gkeʼpo namaʼda oʼnopo̱e̱a̱ʼuy. Ken Judasa namaʼda oʼnopo̱e̱nig kenda Jesús oʼnopo̱e̱po, —‍Kenda doʼtaj megkaʼaponig i̱da megkatiʼ. —‍Jesúsa Judastaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Oroʼomey kutopate Jesúsere Judasere oʼbapeʼpo kenda Jesúsa Judastaj enaʼte nopo̱gkahueʼ o̱ʼu̱y. ");
INSERT INTO amrNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judas oroʼen huakupe huato̱e̱ʼeri o̱ʼe̱nok, “Fiesta aypo nogi̱ti yabaeʼ.” Jesúsa onaʼ. Sueʼada onʼnopo̱e̱ʼuy. “Paiʼda aratbuttaj huakupe yayoktiʼ.” Onaʼ. Nogte onʼnopo̱e̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas pan oʼbapokdepo oʼbapeʼpo oʼo̱ro̱konpo oʼbakhuaʼbedʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas ehuadeʼte, —‍Huabokerek i̱jje̱nok Diosa meʼtaʼmonaʼuyne, Diostaj dakaʼ ijnigpe̱e̱po oyda huakkaʼda aratbuten dakhueaʼ eʼkaʼtaj ijmanigbueyapoy. Konige̱po huadaknanada ijkaʼdenok huakkaʼada onʼnopo̱e̱po, “Dakiti, Dios,” kenpaʼti “Huadaknanada o̱ʼe̱ Dios,” huakkaʼada onʼbatiaʼpakapo. ");
INSERT INTO amrNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Do Diosen Huasiʼpo Diostaj ijnigpe̱e̱po huakkaʼtada ijmanigbueypo Dios huadaknanada o̱ʼe̱, huakkaʼtada ijmanopo̱e̱a̱y Diosakon huakkaʼtada oʼmanopo̱e̱a̱ʼ. Keʼnen Huasiʼpo huadaknanada oʼkikaʼ, huadaknanada o̱ʼi̱kaʼ, oʼmanopo̱e̱a̱ʼ. I̱da oʼmanopo̱e̱a̱ʼapo. ");
INSERT INTO amrNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Huadiʼnanada onʼta̱e̱ne, doʼhuedsiʼpo. Opudere sueʼda hora i̱jje̱a̱poy. Onteʼti doʼtaj huahuayhueʼ o̱ʼneapone. Eʼukada huahuayhueʼ o̱ʼneapone. Ijhuaʼapoy. “Ke̱yo̱da ijhuaʼapoy tiakhueʼdik moʼe̱ne.” Aʼnen kenda judío huairitaj ijmanaʼmey konigti opudomeytakon oʼnonaʼne. ");
INSERT INTO amrNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Konig huabodikda eʼmanmadikaʼ eʼmanaʼtaʼ ijpaki. Huayahuaya diʼ yanʼmaikaʼ. Konig doʼa diʼ o̱ʼnikaʼne konigti huayahuaya diʼ yanʼmaikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Huayahuaya diʼ eʼmaikaʼnayo Jesúsen huaknopo̱i̱kaʼeri o̱ʼne ayaʼada aratbuta onʼnopo̱e̱a̱po. —‍Jesúsa oroʼomey huanigpe̱i̱kaʼeritaj monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","—‍¿Meyon iʼhuaʼapo, Huairi? —‍Jesústaj Simón Pedroa onaʼuy. —‍Ke̱yo̱ ijhuaʼapoy oyda taʼhuahueʼdik o̱ʼe̱ne. Nogoknayo doʼtaj oʼtahuaʼapone. —‍Jesúsa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","—‍¿Menaʼpo oy taʼhuahueʼdik o̱ʼe̱, Huairi? Ontaj aʼtahuayaʼpo bueydik i̱jje̱y. —‍Pedroa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","—‍Onere eʼbueytaʼ ijpaki iaʼnigʼa. Huatahuaj sipoghued “Jesústaj o̱ki̱a̱ʼhue̱ʼyaj i̱jje̱y.” Bapaʼa iaʼapone. Bapaʼ eadeʼte huaboaʼda huatahuaj oʼsipogapo. Buttida ijjay. —‍Jesúsa Pedrotaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","2","—‍Doʼhued Apagenbayo ijhuaʼapoy. Oʼnokhuaʼapone. Onteʼti opudomeyere ehueʼ i̱ji̱kaʼapoy. Do eʼhuadeʼte mepuʼkehueʼ yanikatiʼ. Mididhueʼ yanikatiʼ. Mepuʼkehueʼ ya̱ʼnepo Diostaj dakaʼ yanoknopo̱i̱kaʼ. Diosa boʼtihuapokapone. Doʼtakon dakaʼ yanoknopo̱i̱katiʼ. Onʼtihuapokapone. Dakaʼ huaknopo̱i̱kaʼ onʼtihuapokikaʼapone. Diosenbayo Diosen jakyo huaboroʼda o̱ʼe̱po ayaʼada huaknopo̱e̱ʼeriomey noeonhuahuikaʼdik o̱ʼneapo. Diosen huakkaʼ jakyo ijhuaʼapoy. Dios e̱ʼi̱kaʼyo kenteda Diosen huakkaʼ jakyo opudomeytaj huakkaʼ jak onʼnigkaʼapone, buttida ijjay. ");
INSERT INTO amrNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Opudomeytaj ayaʼda onʼnigkaʼdepo ayaʼda ijkuhuitdepo opudomeytakon aʼbaeyaʼpo ijkumejapoy. Doere onʼbatohuaʼapone. Doere kaʼnunhuahuikeʼpo onʼbatohuaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kente ijhuaʼapoy moʼnopo̱e̱. Ken dagte ijhuaʼapoy moʼnopo̱e̱. Kenteda i̱ji̱kaʼapoy moʼnopo̱e̱. —‍Oroʼ Jesúsen huanigpe̱i̱kaʼeritaj monaʼuyne Jesúsa. ");
INSERT INTO amrNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","—‍Kenteda iʼhuaʼaponig nopo̱e̱hueʼ o̱ʼe̱y. Ken dag o̱ki̱e̱hueʼ o̱ʼe̱y, Huairi. —‍Tomása Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","—‍Konig buttida huaaʼeri do i̱jje̱po Diosyo huabatohuaʼ dag i̱jje̱y. Doa konig huamanoeanhuahuikaʼeri i̱jje̱po aratbuttaj ijmanoeanhuahuikaʼnok Diosere onʼnoeonhuahuikaʼapo. Konig Apag Diosyo huaodhuaʼ dago̱nig i̱jje̱y. Doʼtayoʼda oʼnoknopo̱e̱nok Apag Diosyo huaʼdik moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Doʼtaj dakaʼ e̱ʼki̱e̱ʼnayo doʼhued Apagtakon moki̱e̱ʼapone. Oyda kenpaʼti nogok moki̱e̱ʼonhuahuikaʼapone. Apag Diostaj moki̱e̱ʼonhuahuikaʼapone. Oyda kenpaʼti nogok Apagtaj boʼtiahuayapone. —‍Jesúsa monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","—‍Apag Diostaj eʼtiahuaytaʼ oʼpaki. Apag Diostaj boʼtiahuayʼeaʼ. Eʼtiahuaynayo durugnanada o̱ʼe̱a̱poy, Huairi. —‍Felipea onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","—‍Ijhueʼnanada opudomeyere i̱jjunhuahuikaʼnigʼa menpaʼ doʼtaj o̱ki̱e̱hued o̱ʼe̱, Felipe. Beʼapiʼ doʼtaj mentiahuaypo, doʼtaj meʼnoki̱e̱ʼpo Apagtakon oʼnoki̱e̱ʼde. “Apagtaj boʼtiahuayʼeaʼ.” ¿Menaʼpo onaʼ? ");
INSERT INTO amrNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Doere Apag Diosere nogtida o̱ʼe̱y. Apag Diosyo i̱ji̱kay. Kenpaʼti Apag Dios doyo o̱ʼi̱kaʼ, dapitaʼ yaknopo̱e̱ʼ. Diosen huaʼayoʼda ijmanikay. Doʼhuada ijnopo̱e̱po ahueʼ i̱ji̱kay. Apag Dios doyo o̱ʼi̱kaʼpo konig Diosa oʼpaknok Apag Diosen ijkikay. ");
INSERT INTO amrNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Do Apag Diosere nogtida o̱ʼe̱y. Apag Diosyo i̱ji̱kay kenpaʼti Apag Dios doyo o̱ʼi̱kaʼ, kenda dakaʼ yanoknopo̱e̱ʼ. Kenda oknopo̱e̱hueʼdik e̱e̱ʼnayo Diosen ijkikaʼnige̱yo̱ doʼtaj yanoknopo̱e̱ʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Diosen ijkikay. Konig Diosayoʼda kaʼdik o̱ʼe̱ konigti ijkikay. Konig aratbut tiahuayhued o̱ʼi̱kaʼuynig kenda ijkikay. Teyda ijkikay. Ayaʼada doʼtaj oʼnoknopo̱e̱po konig ijkikay konigti o̱gkaʼapo. Doʼhued Apag Dioste ijhuaʼaponok huaknopo̱e̱ʼeria nogdakon ʼuruaʼnanada o̱gkaʼapo. Buttida ijjay. ");
INSERT INTO amrNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","14","Kenpaʼti katepiʼ ijpakikaʼnig opudomey konigti yanʼpakpo doʼtaj yanʼtionaʼpakikaʼ, doʼhueddikte yanʼtionaʼpakikaʼ. Ken konig eʼtionaʼpakte “Apag Dios huadakda o̱ʼe̱po ʼuruaʼnanada oʼkikaʼ,” aratbuta kanʼbatiaʼpakeʼpo kenda mentionaʼpakikaʼnig onʼnigkaʼapone. —‍Jesúsa monaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","—‍Doʼtaj diʼ e̱e̱ʼnayo doʼhued huaʼatakon nigpe̱i̱kaʼdik moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Diosen Noki̱re̱ga̱ kabatihuapokikeʼpo. Doʼhued huaʼa huanigpe̱e̱ʼ kabatihuapokikeʼpo Diosen Noki̱re̱g opudomeyere kaʼnikeʼpo kenpaʼti kamanopoʼto̱i̱keʼpo “O̱ʼnen Huatihuapokeri yabayoktiʼ, Apag,” ijnigtionaʼpakapoy. ");
INSERT INTO amrNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Diosen Noki̱re̱ga̱ buttida huaʼa moʼnopo̱e̱a̱ʼapone. Diostaj monoki̱a̱ʼapone. Diostaj oknopo̱e̱hueʼ hua̱e̱ʼeriomey Diosen Noki̱re̱ga̱ nopoʼto̱e̱hueʼdik moʼe̱a̱pone konige̱po Diosen Noki̱re̱gtaj o̱ki̱e̱hueʼ o̱ʼnenok. Diosen Noki̱re̱g opudere o̱ʼi̱kaʼaponok kenpaʼti oʼnopoʼto̱e̱a̱ponok opudomeynayo Diosen Huatihuapokeritaj moki̱e̱ʼapone. ");
INSERT INTO amrNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Opudomeytaj kenpaʼda maenhueʼ i̱jje̱a̱poy. Konig doʼhued ayhuayo ehueʼ moʼe̱a̱pone. Opudte noki̱re̱gada ijtiakapoy. ");
INSERT INTO amrNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Aʼtimon doʼtaj pakhueʼ i̱jje̱y huaaʼeria tiahuayhueʼdik meʼneapone, doere ehueʼdik o̱ʼneapo. Opudomeynayo doʼtaj moknopo̱i̱kaʼpo doere moʼi̱kaʼapone. Konige̱po ijnoeonhuahuikaʼaponok doere moʼnoeonhuahuikaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Aʼti Diosen Noki̱re̱ga̱ eʼnopoʼto̱e̱deʼte doʼhued Apagere o̱ʼi̱kaʼ moʼnopo̱e̱a̱pone. Doʼhued Apag doʼere konig nogtida o̱ʼe̱ moʼnopo̱e̱a̱pone. Kenpaʼti doʼtaj moknopo̱e̱po konig doʼhuedso̱ʼ doere moʼi̱kaʼne kenpaʼti opudere i̱jje̱nok meʼnopoʼto̱i̱kaʼne moʼnopo̱e̱a̱po. ");
INSERT INTO amrNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ayaʼada doʼhued huaʼataj onʼpe̱i̱kaʼpo doʼtaj hueretda diʼ moʼe̱ne. Ayaʼada doʼta diʼ moʼe̱nok doʼhued Apaga̱kon diʼ moʼmaeapone. Doʼhuakon diʼ o̱ʼneapone. Do konig o̱ʼe̱ onʼnopo̱a̱ʼapone. —‍Jesúsa monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","—‍¿Menaʼpo on konig o̱ʼe̱ oroʼomeyyoʼda onʼnopo̱e̱a̱po? ¿Menaʼpo nogomey on konig o̱ʼe̱ nopo̱e̱hueʼ o̱ʼneapo? —‍Nog Judasa Jesústaj onaʼuy. (Judas Iscariotea ahueʼ nog Judasa onaʼuy.) ");
INSERT INTO amrNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","—‍Ayaʼada doʼtaj diʼ o̱ʼnikaʼniga̱ doʼhued huaʼataj onʼnigpe̱i̱kaʼapo. Kenomeytaj doʼhued Apaga diʼ oʼmaikaʼapo. Doʼhued Apag doere kenomeyennopoʼyo o̱ʼi̱kaʼapoy. ");
INSERT INTO amrNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ayaʼada doʼtaj diʼ ehueʼ moʼe̱po doʼhued huaʼataj pe̱e̱hueʼ o̱ʼnikaʼ. Ken huaʼa moʼpe̱e̱denig doʼhuedda ehueʼ o̱ʼe̱nok Apaga meʼtaʼmonaʼuyne keʼnen huaʼa oʼnonaʼikaʼne. Konige̱po ayaʼda oʼnonaʼdeʼuy, ayaʼda oʼnonmadikaʼdeʼuy dakaʼ yanʼnigpe̱i̱kaʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Opudomeyere e̱ʼi̱kadeʼte huakkaʼda oʼnonmadikanhuahuikaʼdenigʼa suhueʼda huadak moʼnopo̱e̱. ");
INSERT INTO amrNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Do Apagyo ijhuaʼdepo do ijpaknok Diosa keʼnen Noki̱re̱g moʼnigtaʼmonaʼapone. Opudtehuapaʼ moʼnigtaʼmonaʼapone. Diosen Noki̱re̱ga̱ doʼhued huaʼataj dakaʼ moʼnopoeanhuaʼapone. Moʼmaboroayonhuaʼapone. Doʼhued huaʼa okkahuehueʼ kaʼnikeʼpo boʼtihuapokikaʼapone. Doʼhued eʼmanmadikaʼ onaʼti moʼnopo̱e̱a̱ʼapone. ");
INSERT INTO amrNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Opudomeytaj onʼnopoʼnoeynoeyonpo oʼnokhuaʼapone. Doʼhuayoʼda onʼmanopoʼnoeyikaʼne. Aratbutnayo konigti manopoʼnoeyahueʼdik moʼi̱kaʼne. Do eʼhuadeʼte mepuʼkehueʼ ya̱ʼnepo mididhueʼ ya̱ʼnikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Doʼhued Apagte kurudyo̱ ijhuaʼapoy. Nogok onteʼti ijtiakapoy. Opudere a̱ʼi̱kayaʼpo ijkumejapoy.” Kenda doʼtaj opuda̱ eʼpe̱e̱te oʼnonaʼdene. Diosnayo nogi̱ti teynanada Huairi o̱ʼe̱. Donayo suhueʼda tey huairi i̱jje̱y. Konige̱po nogi̱ti diʼ meneʼ. Nogi̱ti diʼ e̱ʼe̱deʼte Apagyo oʼhuaʼapo moʼnopo̱e̱po durugnanada moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kenda ijkaʼapoy kahued i̱jje̱nig oʼnonaʼne. Nogok kenda do eʼkadeʼte opudomey oʼtiahuaydepo doʼtaj dakaʼ moknopo̱e̱a̱po, konige̱po kenda kahued i̱jje̱nig oʼnonaʼne. ");
INSERT INTO amrNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Totoʼ huairia boʼhuatiakdeaponok oy nogi̱ti huakkaʼ batiaʼpakhueʼ i̱jje̱a̱poy. Totoʼanayo doʼtaj dakhueaʼ o̱gkahueʼdik e̱e̱ʼtada ");
INSERT INTO amrNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","doda ijpakpo ayaʼtada aʼmanigbueyyaʼpo Apagtaj ijnigpe̱e̱nok medarakapone. Kenda eʼnogkadeʼte Apag Diostaj diʼ o̱ʼi̱kaʼ ayaʼada nopo̱e̱ʼdik o̱ʼneapo. Yanboʼ, monhuaʼ. —‍Jesúsa monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Onteʼti oroʼ keʼnen huanigpe̱i̱kaʼeriomeytaj Jesúsa monbatiaʼpakpo monmadikaʼuy. Jesúsen huaknopo̱e̱ʼeriomey Diosen ʼuruaʼda ka̱gkikeʼpo konig kaʼdik yanikaʼ oroʼtaj monaʼpo, —‍Diosen aratbuta Diosen ʼuruaʼda ka̱gkikeʼpo doayoʼda tihuapokdik o̱ʼnene. Ken Diosen hueretda uva huakpi konig i̱jje̱po kenpaʼti doʼhued aratbut konig uva huaʼopi o̱ʼnepo doʼhued huaʼataj onʼnigpe̱i̱kaʼpo doʼtaj oʼnoknopo̱i̱kaʼapo. Doʼhued Apaga̱ta konig uva huakpi huato̱e̱ʼeri o̱ʼi̱kaʼ. Doʼhued huaknopo̱e̱ʼeritaj dakaʼ oʼmato̱i̱kaʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Uva huakpi huato̱e̱ʼeria huakutataj dakaʼ oʼtiahuayikaʼ. Huakutaa uva huada onhuadhueʼ e̱ʼi̱kaʼnayo ken huakutataj oʼkutege̱po oʼen. Ken huakutataj huada onhuadikaʼnok dakaʼ oʼto̱e̱po huakkaʼda onhuadapo. Ken konigti doʼhued Apaga doʼhued huaknopo̱e̱ʼeritaj dakaʼ oʼbatiahuaypo doʼhued huaʼataj onteʼti pakhueʼ e̱ʼneʼnayo Diosen onteʼti dakaʼ kahueʼ e̱ʼnikaʼnayo oʼmaenapo. Nogomeynayo doʼhued huaʼa onʼnigpe̱i̱kaʼpo, Diosen dakaʼ onʼkikaʼpo, Diosa oʼmanopoʼkoyoikaʼnok dakaʼ oʼmanopoʼto̱i̱kaʼnok nogi̱ti ʼuruaʼda Diosen kikaʼdik o̱ʼneapo. ");
INSERT INTO amrNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Opudomeytaj oʼnonmadikikaʼnok doʼhued huaʼa moʼnigpe̱i̱kaʼdepo ʼurunopoʼda moʼe̱depo Diosen dakaʼ kikaʼdik moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Uva huatiʼoj ontiokteghueʼ e̱e̱ʼnayo huada onhuaddik o̱ʼi̱kaʼapo, enʼtiokteg e̱e̱ʼnayo huada onhuadhueʼdik o̱ʼe̱a̱po. Konigti doʼhued huaʼataj dakaʼ nigpe̱i̱kahueʼ e̱e̱ʼnayo kenpaʼti doʼtaj dakaʼ oknopo̱i̱kahueʼ e̱e̱ʼnayo Diosen ʼuruda kikahueʼdik moʼe̱a̱pone. Konige̱po doʼhued huaʼataj dakaʼ yanʼnigpe̱i̱kaʼ, doʼtaj dakaʼ yanoknopo̱i̱kaʼ, kenda boʼkikaʼnok opudomeyere i̱ji̱kaʼapoy onʼnopoʼto̱i̱kaʼapone. Kenokaʼ Diosen ʼuruaʼnanada kikaʼdik moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Do konig uva huakpi i̱jje̱po opudomey konig uva huantiʼoj moʼe̱ne. Opudomey Diosen ʼuruaʼnanada ka̱gkikeʼpo onʼtihuapokikaʼne. Ayaʼada doʼhued huaʼataj onʼnigpe̱i̱kaʼpo doʼtaj dakaʼ moknopo̱i̱kaʼne kenpaʼti kenomeyere i̱ji̱kaʼpo ijmanopoʼto̱i̱kaʼnok Diosen dakaʼ kikaʼdik o̱ʼneapo. Doʼhua tihuapokhueʼ e̱e̱ʼnayopiʼ doʼhua nopoʼteypakahueʼ e̱e̱ʼnayo dapitaʼ Diosen ʼuruda kikahueʼdik o̱ʼneapo. ");
INSERT INTO amrNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Kenomeya̱ doʼtaj oknopo̱i̱kahueʼ o̱ʼnepo, doʼhued huaʼataj nigpe̱i̱kahueʼ o̱ʼnenok kenomeytaj ijmaenapoy. Castiga ijmagkadhuahuikaʼaponok paiʼnanada onʼnopoʼunhuahuikaʼapo. Kenomey konig uva huantiʼoj huada onhuadhueʼ e̱e̱ʼte huato̱e̱ʼeria oʼkutege̱po, oʼmaenapo, eʼbaaydeʼte taʼakyo oʼmaenpo oʼbakpakaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Doʼtaj moknopo̱i̱kaʼpo, doʼhued huaʼataj moʼnigpe̱i̱kaʼpo katepiʼ boʼpakpo moʼtionaʼpakikaʼnok Diosa moʼnigkaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Doʼtaj dakaʼ eknopo̱i̱kaʼte doʼhued huaʼataj eʼnigpe̱i̱kaʼte ken konig Diosen ʼuruaʼnanada boʼkikaʼnok doʼhued hueretda huanigpe̱i̱kaʼeri moʼe̱nok kenpaʼti aratbut opudomeytaj boʼtiahuaypo “Dios ʼurunanada o̱ʼe̱po huadaknanada oʼkikaʼ,” onʼbatiaʼpakapo. ");
INSERT INTO amrNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","10","Apaga doʼtaj huakkaʼ diʼ meʼi̱kaʼne. Konigti doa diʼ o̱ʼnikaʼne. Doʼtaj oʼnoknopo̱i̱kaʼnok onʼnigpe̱i̱kaʼnok opudomeytaj dakaʼ diʼ o̱ʼnikaʼne. Do konigti Apagtaj ijnigpe̱i̱kaʼnok doʼtaj diʼ meʼi̱kaʼne. ");
INSERT INTO amrNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Kenda oʼnonaʼdenok doʼtaj monigpe̱i̱kaʼpo durugnanada moʼi̱kaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Huayahuaya diʼ yanʼmaikaʼ, huayahuaya huakkaʼ diʼ yanʼmaikaʼ. Konig doʼa huakkaʼ diʼ o̱ʼnikaʼne konigti huayahuaya diʼ yanʼmaikaʼ kenpaʼ doʼhued eʼmanaʼ o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Doʼhued huadiʼtaj huakkaʼnanada diʼ ijmaepo ijmanigbueyapoy. Konig do huakkaʼ diʼ o̱ʼnikaʼne konigti huayahuaya diʼ yanʼmaikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Doʼhued huaʼataj eʼnigpe̱i̱kaʼnayo doʼhued huadiʼ moʼi̱kaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Doʼhued huanabaʼ ehueʼ moʼe̱a̱pone. Doʼhued huadiʼ moʼe̱a̱pone. Kenda keʼnen huairi oʼnopo̱i̱kaʼ huanabaʼnayo nopo̱e̱hueʼ o̱ʼnikaʼ. Doʼhued huadiʼ moʼe̱nok ayaʼda doʼhued Apaga menanhuahuikaʼne kenda opudomeytakon oʼnonanhuahuikaʼne. ");
INSERT INTO amrNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Konig opuden huamanmadikaʼeri huairi hua̱ta̱e̱ʼ doʼtaj oktieʼeahueʼ o̱ʼneʼuyne. Diosen huaʼa ʼurunanada ka̱gkikeʼpo, huadakda ka̱gkikeʼpo huayahuaya diʼ kanʼmaikeʼpo kenpaʼti huakkaʼtada Diosen huadak huaʼa kanʼmanmadikanhuahuikeʼpo huakkaʼtada kanʼmanopoʼkoreʼpo opudomeytaj onʼbaktieʼeaʼuyne. Aratbut Diostaj kanoknopounhuahuikeʼpo oʼnokbatieʼeaʼuynok. Ken konig boʼkikaʼpo konig do ijpaki moʼtionaʼpakikaʼnok Apaga moʼnigpe̱i̱kaʼapone boʼtihuapokikaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Konige̱po huayahuaya diʼ yanʼmaikaʼ onteʼti oʼnonaʼne, ken. —‍Jesúsa oroʼ huanigpe̱i̱kaʼeriomeytaj monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","—‍Doʼtaj moknopo̱e̱nok doʼhued huanigpe̱i̱kaʼeri moʼe̱nok oknopo̱e̱hueʼ hua̱e̱ʼeriomeya̱ moʼhuadiayapone meʼpukehueʼ yaneʼ. Doʼtaj huakkuruda menhuadiayʼuyne kenda okkahuehueʼ yanikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Konig dakhueaʼ huakaʼeriomey onʼnopo̱e̱po o̱gkikaʼ opudomey nopo̱e̱hueʼ moʼe̱po kikahueʼ moʼe̱nok dakhueʼda eʼnopo̱e̱ʼnayopiʼ eʼkikaʼnayopiʼ dakhueaʼ huakaʼeria diʼ maeʼdik moʼe̱ne. Opudomeytanayo Diosa boktieʼeaʼuyne. Dakhueaʼ eʼkaʼtaj moʼnopoʼyareaʼdenok dakhueaʼ huakikaʼeriomeya̱ boʼhuadiayne. Oyda Diosen ʼuruaʼnanada boʼkikaʼnok boʼhuadiayne. ");
INSERT INTO amrNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Huanabaʼ huataʼ huairionig yahueʼeahueʼdik o̱ʼe̱. Oʼnonaʼnig okkahuehueʼ yanikaʼ. Oknopo̱e̱hueʼ hua̱e̱ʼeria doʼtaj onʼhuadiaypo dakhueaʼ meʼnogkaʼapone. Opudomeytakon boʼhuadiaypo dakhueaʼ mogkaʼapone. Doʼtaj nigpe̱e̱hueʼ meʼnikameʼnigʼa opudomeytakon nigpe̱e̱hueʼdik moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Cristo i̱jje̱nok moknopo̱e̱po moʼmanbatiaʼpaknok oknopo̱e̱hueʼ hua̱e̱ʼeriomeya̱ boʼhuadiaypo dakhueaʼ mogkaʼapone. Doʼhued Apaga meʼtaʼmonaʼuynigtaj o̱ki̱a̱hueʼ o̱ʼnepo boʼhuadiayapone. ");
INSERT INTO amrNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Do tiakhueʼ e̱e̱ʼuynayo doʼtaj oknopo̱e̱hueʼ hua̱e̱ʼeria dakhueaʼ meʼnogkameʼne huaahueʼdik o̱ʼnene. Do ijtiakdeʼuypo ijmanmadikaʼdeʼuypo dakhueaʼ meʼnogkameʼne huaaʼdik o̱ʼnene. ");
INSERT INTO amrNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Do Apag Diosere nogtida o̱ʼe̱nok beʼapiʼ doʼtaj onʼhuadiaypo konigti Apagtakon onʼhuadiay. ");
INSERT INTO amrNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Konig Diosayoʼda kaʼdik o̱ʼe̱ doʼhua kahueʼ e̱e̱ʼuynayo oknopo̱e̱hueʼ hua̱e̱ʼeria dakhueaʼ meʼnogkameʼne huaahueʼdik o̱ʼnene. Konig Diosayoʼda kaʼdik o̱ʼe̱ doʼhua ijkaʼdeʼuynok oknopo̱e̱hueʼ hua̱e̱ʼeria kenda eʼkaʼte mentiahuaydepo menhuadiaypo Apagtakon onʼhuadiay. ");
INSERT INTO amrNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Kenda o̱gkaʼapo adhueaʼpaneʼa̱ huamanbatiaʼpakeria oʼmadoyaʼuyate konigti o̱gkaʼ. “Dakhueaʼ kahueʼda e̱e̱ʼtada menhuadiayapone.” Apagbaʼa oaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Oknopo̱e̱hueʼ hua̱e̱ʼeriomeya̱ opudomeytaj eʼhuadiayte mepuʼkehueʼ ya̱ʼnepo Apag Dios oʼpaknok Diosen Noki̱re̱g onʼnigtaʼmonaʼapone. Diosen Noki̱re̱g buttida doʼtaj moknopo̱e̱a̱ʼapone. Opudomeya̱ huadak huaʼa kanʼbatiaʼpakikeʼpo Diosen Noki̱re̱ga̱ boʼtihuapokikaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Huakkurunada doere moʼi̱kaʼuyne. Ayaʼda ijkikamey boʼtiahuayikameʼne. Ayaʼda ijmanmadikaʼuynig moʼpe̱i̱kaʼuypo doʼhued huaʼa moʼbatiaʼpakikaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","4","Doʼhued huanigpe̱i̱kaʼeri moʼe̱nok judío huairiomeya̱ dakhueʼnanada mogkaʼapone. Opudtaj diga̱ʼ boʼhuadiaypo judíoen hua̱i̱takeʼ jakyaʼ mokenapone. Kenpaʼda moʼenapone. Nogokkon boʼarakapone. Diostaj oknopo̱e̱hueʼ o̱ʼnikaʼpo, doʼtakon oknopo̱e̱hueʼ o̱ʼnikaʼpo, onʼarakpo Diostaj dakaʼ oʼnigpe̱e̱y namaʼda onʼnopo̱e̱a̱po. Kenpaʼ huaboaʼda oʼnonaʼpo e̱gkadeʼte meʼpukehueʼ kaʼneʼpo kenpaʼti dakaʼ moknopo̱e̱po oknopo̱e̱batikhueʼ kaʼneʼpo kenpaʼ oʼnonaʼne. Kenokaʼ opudtaj eʼhuadiayte diga̱ʼ e̱gkaʼte kenda oʼnonaʼnig moʼnoponapet. Aʼnenda opudere i̱ji̱kameʼpo kenda onahueʼ o̱ʼnikaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","6","Oynayo doʼtaj meʼtaʼmonaʼuynigte ijhuahuaʼdeapoy. Doʼhued Apag Diostaj ijhuahuaʼdeapoy. Kenda moʼpe̱e̱depo suhueʼ e̱ʼe̱a̱da ¿Meyon iʼhuaʼapo? onahueʼ o̱ʼnene. ");
INSERT INTO amrNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Opudomeytaj huadaknanada aʼkikayaʼpo e̱ʼe̱a̱da kenpaʼti aʼtihuapokikayaʼpo e̱ʼe̱a̱da doʼhued huaojtaj ijhuaʼapoy. Do huahueʼ e̱e̱ʼnayo kabatihuapokeʼpo Diosen Noki̱re̱gtaj mataʼmonahueʼ o̱ʼneaynigʼa. Apagtaj ijhuaʼapopo Diosen Noki̱re̱g opudomeytaj onʼnigtaʼmonaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","11","Diosen Noki̱re̱g onʼnigtaʼmonapone. Opudomeytaj oʼtiakpo oʼmanopoʼto̱e̱a̱po. ʼUruaʼnanada boʼkikaʼnok dakhueaʼ huakaʼeriomey boʼtiahuaydepo dakhueaʼ huakkaʼeri o̱ʼe̱y onʼnopo̱a̱po. Kenpaʼti huadak huaʼa moʼmanikaʼnigʼa onʼpe̱e̱denigʼa doʼtaj oknopo̱e̱hueʼ o̱ʼnepo dakhueaʼ huakkaʼeri o̱ʼe̱y onʼnopo̱e̱a̱po. Diosen Noki̱re̱ga̱ oʼmanopo̱e̱a̱ʼapo. Kenpaʼti do Apagyo eʼhuadeʼte Diosen ʼuruaʼnanada oʼkikaʼuy dakhueaʼ huakaʼeriomeya̱ onʼnopo̱e̱a̱po. Diosen Noki̱re̱ga̱ oʼmanopo̱e̱a̱ʼapo. Diosyo do eʼhuadeʼte onteʼti tiahuayhueʼ o̱ʼneapone. Totoʼ huairi dakhueaʼ huakaʼeretaj namaʼda onʼnigpe̱e̱po doʼtaj medarakapone. Dakhueaʼ oʼnogkaʼdeʼuynok Diosa castiga oʼmagkaʼapo. Diosen Noki̱re̱ga̱ kenda oʼmanopo̱e̱a̱ʼapo. Konige̱po totoʼ dakhueaʼ oʼkaʼ Diosa oaʼdepo castiga o̱gkaʼapo, kenda onʼnopo̱e̱a̱po. Ken konig Diosen Noki̱re̱ga̱ oʼkaʼapo. Buttida ijjay. ");
INSERT INTO amrNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Nogi̱ti huakkaʼ huadak huaʼa opudomeytaj eʼmanmadikaʼtaʼ ijpaknigʼa oynayo nogi̱ti manmadikahueʼdik o̱ʼnene konige̱po oy nogi̱ti menpaʼ nopo̱e̱gkahueʼdikda moʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Diosen Noki̱re̱ga̱ opudomeytaj boʼhuatiakapone. Diosen Noki̱re̱g buttida huaaʼeri o̱ʼi̱kaʼ. Eʼhuatiakdeʼte doʼtaj huanopo̱e̱ʼ doʼhued huaʼa buttida monmadikikaʼapone. O̱ʼnenda oʼnopo̱e̱po onahueʼ moʼe̱a̱pone. Kenda Diosa oaʼ monaʼapone. Kenda o̱ʼe̱a̱ponig oʼmanopo̱e̱a̱ʼapo. ");
INSERT INTO amrNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Doʼhued huadak huaʼa opudomeytaj moʼnopo̱e̱a̱ʼaponok do huadakda i̱ji̱kaʼnig huadakda ijkikaʼnig Diosen Noki̱re̱ga̱ oʼmanopo̱e̱a̱ʼapo. ");
INSERT INTO amrNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ayaʼda Apaga oʼnopo̱e̱ doʼhuakon ijnopo̱e̱y. Ayaʼda Apaga oʼto̱i̱kaʼnig doʼhuakon ijto̱i̱kay. Ayaʼda Apaga oʼkikaʼnig doʼhuakon ijkikay. Konige̱po Diosen Noki̱re̱ga̱ doʼhued eʼnopo̱e̱ʼ moʼnopo̱e̱a̱ʼapone. Dios konig o̱ʼe̱ moʼnopo̱e̱a̱ʼapone. —‍Jesúsa oroʼtaj monaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","—‍Apag Diosyo ijhuaʼaponok aʼtimon doʼtaj onteʼti tiahuayhueʼ o̱ʼneapone. Nogokda onteʼti onʼtiahuayapone. —‍Jesúsa monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","—‍¿Katiaʼ yaaʼ. Beʼa moʼnopoenkaʼ? “Aʼtimon doʼtaj onteʼti tiahuayhueʼ o̱ʼneapone. Nogokda aʼtimon onteʼti onʼtiahuayapone, Apag Diosyo ijhuaʼaponok.” Oroʼtaj kenpaʼ monaʼne. ");
INSERT INTO amrNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","“Aʼtimon doʼtaj tiahuayhueʼ o̱ʼneapone,” monaʼne kenda nopo̱gkahueʼ o̱ʼe̱y. —‍Jesúsen huanigpe̱i̱kaʼeria suhueʼada huayahuaya onʼbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Kenda oroʼ huayahuaya oʼbatiaʼpakʼuynig Jesúsa moknopo̱e̱po monaʼpo, —‍Aʼtimon doʼtaj onteʼti tiahuayhueʼ o̱ʼneapone. Nogokda aʼtimon onteʼti onʼtiahuayapone. Oʼnonaʼdene. ¿Katiaʼ yaaʼ? ¿Beʼa moʼnopoenkaʼ? Kenda eʼnopo̱e̱ʼtaʼ boʼpakpo huayahuaya moʼbatiaʼpaknigʼa. ");
INSERT INTO amrNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Do eʼbueydeʼte suhueʼnada moʼe̱a̱pone. Paiʼnada moʼbahuikapone. Oknopo̱e̱hueʼ hua̱e̱ʼerinayo durugda o̱ʼneapo. Paiʼnanada e̱ʼe̱a̱da onteʼti durugnanada moʼe̱a̱pone. Eʼnoyhuaddeʼte doʼtaj onʼtiahuaypo durugnanada moʼe̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ettoneʼ onʼsiʼpopakpo paiʼnanada onʼnopoʼe̱nigʼa onʼsiʼpopakdepo paiʼnanada eʼnopoʼendeʼ oʼnokkahueʼapo. Yo̱bed onʼto̱e̱depo onʼdurugpak. ");
INSERT INTO amrNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ken konig moʼe̱ne. Aʼti ijbueyapoy moʼnopo̱e̱depo paiʼnanada moʼe̱a̱ponigʼa onteʼti ijnoyhuaddepo doʼtaj boʼtiahuayapopo durugnanada moʼe̱a̱pone. Durugnopoʼda moʼe̱a̱pone. Beʼapiʼ durugnopoʼ e̱ʼi̱kaʼ batikahueʼdik moʼe̱a̱pone. Buttida ijjay. —‍Jesúsa monaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","—‍Nogok Diosen Noki̱re̱ga̱ moʼnopoʼto̱e̱denok doʼhued huaʼa ʼurunanada moʼnopo̱e̱a̱po. Oʼnonaʼnig, ¿katiaʼ iaʼ? doʼtaj onahueʼdik o̱ʼneapone kenokaʼ. Doʼhued huanigpe̱i̱kaʼeri moʼe̱po doʼtaj moknopo̱e̱po katepiʼ boʼpakpo Apagtaj eʼtionaʼpakdeʼte boʼyokikaʼapone. Buttida ijjay. ");
INSERT INTO amrNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Doʼhueddiktaj dakaʼ yanoknopo̱e̱po, konig do ijpaknig Apagtaj tionaʼpakhued moʼe̱depo, doʼhueddiktaj dakaʼ yanoknopo̱e̱po konig ijpaknok Diostaj yanʼtionaʼpakikatiʼ. Diosa moʼpe̱i̱kaʼpo moʼnigkaʼapone. Durugnanada kaʼnikeʼpo Diosa moʼpe̱i̱kaʼpo mogkaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Aʼnen konig o̱ʼe̱ oʼnonbatiaʼpakpo oʼnonmadikikameʼne. Aʼtinayo onteʼti ken konig onmadikahueʼ o̱ʼneaponigʼa Apagtaj dakaʼda oʼnoknopo̱e̱a̱ʼapone. ");
INSERT INTO amrNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nogok doʼhueddik dakaʼ moknopo̱e̱po do konig ijpaknok Apagtaj moʼtionaʼpakikaʼapo. Donayo Apagtaj nigtionaʼpakhueʼdik i̱ji̱kaʼapoy. ");
INSERT INTO amrNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Apag Diosada diʼ moʼe̱po. Doʼtaj diʼ o̱ʼnenok doʼtaj oʼnoknopo̱e̱nok Apag Diosyaʼ oʼtiakuy oʼnoknopo̱e̱nok Apaga̱da diʼ moʼe̱po moʼpe̱i̱kaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Apagere i̱ji̱kaʼuy. Apag Diosyaʼ ijjo̱ro̱kpo aratbutte ijtiakuy. Aratbutere ijmaunhuahuikaʼdepo onteʼti aratbutyaʼ ijbakhuaʼapoy. Apagte ijhuaʼapoy. —‍Jesúsa monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","—‍Oynayo dakaʼda onaʼne. Nopoenkaʼdik o̱ʼe̱y. Aʼnen konig o̱ʼe̱ onʼbatiaʼpakikameʼnig noponkahueʼdik o̱ʼi̱kaʼuy oroʼ. Oynayo konig o̱ʼe̱ onbatiaʼpakhueʼ o̱ʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ayaʼda oʼnopo̱e̱ oroʼomey oynayo oʼnopo̱e̱y. Huanopoyaʼda kateapiʼ oʼnopo̱i̱kay soatayoʼ oʼnopo̱i̱kaʼnig ayaʼda kenda iʼnopo̱i̱kaʼnok Diosyaʼ oʼtiakuyate oʼnopo̱e̱y. —‍Oroʼomey Jesúsen huanigpe̱i̱kaʼeria onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","—‍Menpaʼ oy doʼtaj hueretda yoknopo̱e̱ eaʼada ");
INSERT INTO amrNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","oyda nogyon nogyon oʼnokbahuaʼapone. Ayaʼada oʼnokbahuaʼapone. Opudomeyen jakyoda oʼnokbahuaʼapone. Nogtiaʼda oʼnenonaponigʼa nogtiaʼda ehueʼ i̱jje̱y doʼhued Apagere i̱jje̱a̱poy. ");
INSERT INTO amrNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Kenda oʼnonaʼdenok Diostaj ʼurunopoʼda moʼi̱kaʼapone kenpaʼti Diostaj moʼnopoʼnoeyapone. Oknopo̱e̱hueʼ hua̱e̱ʼeriomeya̱ boʼhuadiaypo dakhueaʼ mogkaʼaponigʼa yanʼnopoʼteypakpo doʼtaj dakaʼ yanoknopo̱i̱kaʼ. Doa totoʼ huairitaj kenpaʼti oknopo̱e̱hueʼ hua̱e̱ʼeritaj nigpe̱e̱hueʼ i̱ji̱kaʼuy. Totoʼtaj huayakhueʼ huakaʼeri i̱jje̱y. —‍Jesúsa oroʼ huanigpe̱i̱kaʼeritaj monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Oroʼomeytaj Jesúsa kenda monaʼdepo kurudyo̱ oʼmabopo Apag Diostaj oʼtionaʼpakpo, —‍O̱ʼnensiʼpo i̱jje̱po, Apag. Oy o̱ʼnensiʼpoa kamanigbueyeʼpo, kamanignoyhuadeʼpo, kurudyo̱ onere kabehuikeʼpo, onere teyda kamanikeʼpo kenpaʼti “huadakda oʼkaʼ,” ayaʼada kanʼbatiaʼpakikeʼ. Kenda do eʼkadeʼte “Dios ʼuruaʼnanada oʼkikaʼ,” ayaʼada kanʼbatiaʼpakikeʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","O̱ʼna oʼpakpo ayaʼtada meʼbayokne. Diosere kamanoeanhuahuikeʼpo. Teyaʼda megkaʼnok ayaʼtada manaʼdik i̱jje̱nok konige̱po ayaʼada aratbut nigpe̱i̱kaʼdik moʼi̱kaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Hueretda Dios i̱ʼi̱kaʼ, ayaʼen huairida i̱ʼi̱kaʼne, ayaʼtada diʼ iʼmaikaʼne, buttida iʼikaʼne, ayaʼada ontaj dakaʼ moknopo̱e̱po, do Jesucristotakon moknopo̱e̱po oroʼere durugda moʼnoeonhuahuikaʼapone. Doʼtaj meʼtaʼmonaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","In huadariyo aratbutere i̱jjunhuahuikaʼdepo o̱ʼnen huaʼa ijkadhuahuikaʼdepo ontaj ijnigpeunhuahuikaʼdepo ayaʼda iʼpaknig kenda ijkuhuitdenok konige̱po “Apag Dios huadaknanada o̱ʼe̱. ʼUruaʼnanada oʼkikaʼ,” aratbuta onʼbatiaʼpakapo. ");
INSERT INTO amrNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Oyedda o̱ʼnenbayo onte beʼtobehuik. Onere meto̱i̱kaʼ. Durugtenanada meto̱i̱kaʼ. Konig aʼnennanada onere i̱ji̱kaʼpo teynanada ijmanikaʼnig onteʼti konigti megkaʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Huakkaʼ huadariyo hua̱e̱ʼeri meʼnigbaktieʼeaʼuyne, Pag. O̱ʼnen o̱ʼnenok “doʼhued huadak huaʼa dakaʼ yamanmadikikatiʼ,” onaʼuyne. O̱ʼnen huadak huaʼa ijmanmadikadhuahuaʼdey, ontaj ijmaknopo̱e̱a̱ʼdenok o̱ʼnen huadak huaʼa onʼnigpe̱e̱de. ");
INSERT INTO amrNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ayaʼda ijkikaʼnig, beʼtihuapokikaʼnok ijkikay kenpaʼti beʼteypakikaʼnok ʼuruaʼnanada ijkikay. O̱ʼnen huadak huaʼa meʼnopo̱e̱a̱ʼikaʼnok. Kenda doʼhued huaknopo̱e̱ʼeriomeya̱ onʼnopo̱e̱de. ");
INSERT INTO amrNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","O̱ʼnen huaktieʼeaʼeriomeytaj o̱ʼnen huadak huaʼa doʼhua ijmananhuahuikaʼdenok onʼpakpo onʼnigpe̱i̱kaʼde. Meʼtaʼmonaʼuyne kenpaʼti Diosyaʼ oʼtiakuy onʼnopo̱e̱. ");
INSERT INTO amrNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Doʼhued huaknopo̱e̱ʼeritaj ijmationaʼpakpo, nog aratbuttaj mationaʼpakhueʼ i̱jje̱po. O̱ʼnendation o̱ʼnenok dakaʼ yamato̱i̱kaʼ ");
INSERT INTO amrNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","O̱ʼnen huaknopo̱e̱ʼeri doʼtaj meʼbayokuyne. Doʼhued onmaenig oʼnenkon iʼtamaikaʼne. O̱ʼnen dakaʼ moʼnigpe̱i̱kaʼnok o̱ʼnen ʼuruaʼda o̱gkikaʼnok huadakda o̱ʼe̱ kenpaʼti Diosen Huasiʼpo o̱ʼe̱ aratbuta onʼnopo̱e̱po ‘Dakiti Dios’ onʼbatiaʼpakikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","In huadariyo noikahueʼ i̱jje̱a̱popo o̱ʼnen huaknopo̱e̱ʼeritaj ijbakhuaʼapopo onte ijbaktiakapoy. O̱ʼnen indariyo o̱ʼnikaʼponok huadaknanada i̱ʼi̱kaʼpo teynanada i̱ʼi̱kaʼpo o̱ʼnen huaknopo̱e̱ʼeritaj dakaʼ yabatihuapokikaʼ. Dakaʼ ka̱gkikeʼpo yabatihuapokikaʼ. Dakhueaʼ kahueʼ kaʼnikeʼpo yabatiokikaʼ. O̱ʼnen huaknopo̱e̱ʼeri dakaʼ kanoknopo̱i̱keʼpo yabatihuapokikaʼ. Kenpaʼti huayahuaya diʼ kanʼmaikeʼpo yabatihuapokikaʼ, Pag. Oroʼ onpapayoʼ ondikyoʼ oʼpakikay kenomeykon konigti kanʼpakeʼpo yabatihuapokikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Indariyo o̱ʼnen huanigpe̱i̱kaʼeriere i̱ji̱kaʼpo doʼtaj teyda oʼyoknok o̱ʼnen huabaktieʼeaʼeritaj huadakyoʼ ka̱gkikeʼpo ijbatihuapokikaʼpo, ijbatiokikaʼpo, dakaʼ ijmato̱i̱kaʼuy. Okbatikhueʼda ayaʼada dakaʼ oʼnoknopo̱i̱kaʼdepo nogtiaʼda oknopo̱e̱batikdepo kenpaʼda oʼbueyapo. Diosyo huahueʼdik o̱ʼe̱a̱po. Kenda Apagbaʼa oaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Oy onte ijbakbehuikapoy. O̱ʼnen huabaktieʼeaʼeri huakkaʼ kanʼdurugpakeʼpo konig do ontaj ijnigpe̱i̱kaʼpo durugnanada i̱ji̱kay kenomey konigti durugnanada kaʼnikeʼpo konige̱po ontaj dakaʼ ijtionaʼpakonhuaʼpo, onte huahued ijtionaʼpakonhuay. ");
INSERT INTO amrNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","O̱ʼnen huaʼa ijmanmadikadhuahuikaʼuy. O̱ʼnen huaʼa huakkaʼ onʼpakpo onʼnigpe̱i̱kaʼpo, konig oknopo̱e̱hueʼ hua̱e̱ʼeriomey o̱gkikaʼnig onteʼti kahueʼ o̱ʼnikaʼpo kenpaʼti doʼhua konig oknopo̱e̱hueʼ hua̱e̱ʼeri o̱gkikaʼnig kahueʼ i̱ji̱kay. Do konig ijkikay konigti o̱ʼnen huaknopo̱i̱kaʼeria o̱gkikaʼnok konige̱po oknopo̱e̱hueʼ hua̱e̱ʼeria diga̱ʼ onʼbahuadiaypo. ");
INSERT INTO amrNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","O̱ʼnen huabaktieʼeaʼeritaj ijmato̱i̱kaʼpo in huadariyo dakhueaʼ huakkaʼeriomeyere o̱ʼnikaʼ. Oknopo̱e̱hueʼ hua̱e̱ʼeriyaʼ yamakto̱ro̱k tionaʼpakhueʼ i̱jje̱nok totoʼ engaña huakaʼeritaj yabatiokikaʼ. Totoʼ engaña kahueʼdik kamaeʼpo, ijtionaʼpaki. ");
INSERT INTO amrNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Konig oknopo̱e̱hueʼ hua̱e̱ʼeriomey o̱gkikaʼnig konigti kahueʼ i̱ji̱kay. O̱ʼnen huaknopo̱e̱ʼeriomey kenpaʼti dakhueaʼ kikahueʼ o̱ʼnikaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","O̱ʼnen huaʼa buttida o̱ʼi̱kaʼ. Buttida huaʼa onʼpe̱e̱nok ʼurunopoaʼda yamagkikaʼ. O̱ʼnen buttida huaʼa kanʼnigpe̱i̱keʼpo yabatihuapokikaʼ. Ontayoʼda kanʼpakikeʼpo yabatihuapokikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Oknopo̱e̱hueʼ hua̱e̱ʼeriomeyte meʼtaʼmonaʼuyne. Konig doʼtaj meʼtaʼmonaʼuyne konigti o̱ʼnen huabaktieʼeaʼeritaj oknopo̱e̱hueʼ hua̱e̱ʼeriomeyte ijmataʼmonaʼdey. ");
INSERT INTO amrNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","O̱ʼnen buttida huaʼayoʼda kanʼnigpe̱i̱keʼpo, do konig huakkurueria o̱ʼnen huaʼayoʼda ijnigpe̱i̱kay. ");
INSERT INTO amrNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Inomey o̱ʼnen huabaktieʼeaʼeriomey doʼhued huadak huaʼa oʼnonbatiaʼpakonhuahuikaʼapone. Nogok nogok doʼtaj huakkaʼananada moknopo̱e̱a̱pone. Huakkaʼananada doʼtaj moʼnigpe̱i̱kaʼapone. Kenomeytakon ijmationaʼpaki. ");
INSERT INTO amrNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Doʼhuednopoʼyo i̱ʼi̱kaʼne. On konig iʼpakikaʼ konigti do ijpakikay. On konig diʼ iʼmaikaʼ konigti do diʼ ijmaikay, onpapayoʼ o̱ʼi̱kaʼne. Konigti ayaʼada oroʼen huaknopo̱e̱ʼeri oroʼomeytaj konigti kanoknopo̱i̱keʼpo, konig oroʼ diʼ oʼmaikay konigti diʼ kanʼmaikeʼpo, konig oroʼ konigti oʼpakikay kenomeya̱kon konigti kanʼpakikeʼpo ijmationaʼpaki, Pag. Ken, ayaʼada kenomeytaj onʼbatiahuaydepo onʼpe̱e̱depo doʼtaj Apag Diosa oʼtaʼmonaʼuy nopo̱e̱ʼdik ya̱ʼneapet. ");
INSERT INTO amrNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","23","Doʼhuednopoʼyo i̱ʼi̱kaʼne, meʼnopoʼto̱i̱kaʼne. Konig nogtida o̱ʼe̱ne. Konigyoʼ oʼpakikaʼne. Konigyoʼ oʼnopo̱i̱kaʼne. Oroʼ konig nogtida kanʼpakikeʼpo, oroʼ konig diʼ kanʼmaikeʼpo, oroʼ konig nogtida kaʼnikeʼpo ijmanopoʼto̱i̱kay. Ontaj konigti kanoknopo̱i̱keʼpo, konigti kanʼnigpe̱i̱keʼpo doʼtaj meʼtaʼmonaʼuyne, doʼtaj diʼ meʼi̱kaʼne, konigti huaknopo̱e̱ʼeritaj diʼ moʼi̱kaʼne, ayaʼ aratbuta nopo̱e̱ʼdik ya̱ʼneapetpiʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ayaʼ doʼhued huaknopo̱e̱ʼ doʼtaj meʼbayokuyne, huakkurunada diʼ o̱ʼe̱nok doere kaʼnikeʼpo on huakkuruda iʼpaknok doʼhua onere huaboroʼ huairi i̱ji̱kaʼpo, onere ʼurunanada i̱ji̱kaʼpo, onere teynanada i̱ji̱kaʼnok tiahuaydik meʼnikeʼpo, Pag. ");
INSERT INTO amrNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ayaʼ oknopo̱e̱hueʼ hua̱e̱ʼeriomey ontaj o̱ki̱e̱hueʼ moʼe̱nigʼa doʼhuanayo ontaj o̱ki̱e̱ʼne kenpaʼti doʼtaj oʼtaʼmonaʼuy doʼhued huanigpe̱i̱kaʼeria moknopo̱e̱ne, Pag. Kenpaʼda huadaknanada i̱ʼi̱kaʼne, Pag. ");
INSERT INTO amrNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","O̱ʼna konig o̱ʼe̱, doʼhued huanigpe̱i̱kaʼeritaj ijmanopo̱e̱a̱ʼdemey. Kenpaʼti nogi̱ti nogi̱ti ijmanopo̱e̱a̱ʼapoy. Doʼtaj huakkaʼ diʼda o̱ʼi̱kaʼne. Kenomeykon konigti huakkaʼ diʼ kanʼmaikeʼ kenpaʼti doʼhua kamanopoʼto̱i̱keʼpo nogi̱ti nogi̱ti ijmanopo̱e̱a̱ʼapoy, Pag. —‍Jesúsa Apagtaj oʼtionaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesús kenda oʼtionaʼpakdepo oʼhuaʼuy. Oroʼ keʼnen huanigpe̱i̱kaʼeriere oʼhuaʼuy. Oʼhuaʼpo Cedrón huatotaʼpote oʼpokonpo taʼbayo oʼkudonʼuy. Jesús huanigpe̱i̱kaʼeriere onʼkudonʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas judío huairitaj Jesústaj namaʼda oʼbayokapopo, ken taʼbayo o̱ʼe̱taj oʼnopo̱e̱ʼuy. Nogok nogok oroʼ huanigpe̱i̱kaʼeriere Jesúsa ke̱yo̱ oʼkupopakikaʼuypo kenaʼpo Jesús ke̱yo̱ o̱ʼe̱taj oʼnopo̱e̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ken taʼbayo Judas oʼhuaʼpo, huakkaʼ sorotataj oʼbatohuaʼpo, Diosen jak huato̱e̱ʼeri sorotatatakon oʼbatohuaʼuyate. Diosen jak huato̱e̱ʼeri sorotatatakon fariseo huairia sacerdote huairierea onʼmataʼmonaʼuyate. Siro kenpaʼti hue̱ypa onʼtohuaʼpo. Sikyo o̱ʼe̱nok huakjey onʼtohuaʼbedʼuyate. Taʼbayo Jesúste onʼhuatiakbedʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Oʼnokye̱depo Jesúsa ayaʼda kenda meʼnogkaʼapone eʼnopo̱e̱ʼada oʼmadejpo, —‍¿Beʼtaj boʼuk? —‍Jesús oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","—‍Jesús Nazareteritaj oʼuki. —‍Oʼnonaʼuy. —‍In do i̱jje̱y. —‍Jesúsa oʼmanaʼuy. Judas judío huairitaj Jesústaj namaʼda oʼbayokpo sorotataere onʼtoboʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","“In do i̱jje̱y.” Jesúsa eʼmanaʼte onʼmididonpo onʼtaʼnionpo onʼhue̱konʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","—‍¿Beʼtaj boʼuk? —‍Onteʼti oʼmanaʼuy. —‍Jesús Nazareteritaj oʼuki. —‍Oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","—‍In do i̱jje̱y. Huaboaʼda oʼnonaʼdene. Doʼtaj eʼuknayo inomey doʼhued huanigpe̱i̱kaʼeritaj magkahueʼ ya̱ʼnepo kentaj batohuahueʼ yaneʼ. —‍Jesúsa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Kenda huaboaʼda oaʼmeʼnig magkahueʼ kaʼneʼpo kenda oʼmanaʼ. “Kenomeytaj Diosa doʼtaj beyokuyne nogtipiʼ ehueʼ okbatikhueʼ o̱ʼneapone.” Huaboaʼda Jesúsa monameʼne. ");
INSERT INTO amrNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Kenokaʼ Simón Pedroa siroa e̱ʼta̱e̱ʼ oʼedpo oʼbapadenpo sacerdoteen huanabaʼtaj huapesod huadaʼkopen oʼpesodokhueʼuy. Keʼnendik Malco o̱ʼu̱y. ");
INSERT INTO amrNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","—‍Kejeʼ, kahueʼ ya̱e̱ʼ. Siro huato̱e̱ʼyo yakuda̱ʼ. Kenda Apag Diosa oʼpaknok paiʼnanada nopoʼe̱dik i̱jje̱a̱poy. —‍Jesúsa Pedrotaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ken huakkaʼ sorotataj sorotataj huairiere, Diosen jak huato̱e̱ʼeria sorotataj Jesústaj onʼtaʼkuypo, huabaʼ onʼbaʼtinukuʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Huakkuruda Anástaj onʼhuatohuaʼuy. Anás Caifásen huahue̱yhue̱y o̱ʼe̱nok, onʼhuatohuaʼpo, Caifás kenbayokte sacerdote huairi o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ayaʼ judío aratbut mabueyhueʼ kaʼneʼpo nogtiada eʼmanigbueynayo oroʼtaj huadakda o̱ʼe̱a̱po. Kenpaʼ Caifás judío huairitaj oʼbatiaʼpakmeʼte. ");
INSERT INTO amrNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simón Pedro doere Jesústaj oʼtahuaʼuy. Sacerdote huairi doʼtaj huadak meki̱e̱ʼnok sacerdote huairien jak eʼtiokpakaʼyo Jesúsere ijkudonʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Eʼtiokpakaʼ kurute akbogpete Pedro oʼboatoʼnok, do muneʼyo̱taj akbogpe huato̱e̱ʼeritaj ijhuahuaʼpo, “Yakuda̱ʼ,” yonaʼpo Pedrotaj ijtokudonʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","—‍¿Ken huabokereken huanigpe̱i̱kaʼeri o̱ʼna menpaʼ i̱ʼe̱? —‍Muneʼyo̱ akbogpe hua̱ta̱e̱ʼeria Pedrotaj onaʼuy. —‍Do ehueʼ i̱jje̱y. —‍Pedroa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Jujuʼ o̱ʼe̱nok, huanabaʼere Diosen jak huato̱e̱ʼeriere taʼak o̱gkaʼuy. Aso̱ʼukkayaʼpo onʼtimaboʼuy. Pedrokon kenomeyere aso̱ʼukkayaʼpo taʼakte oʼboʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","“¿O̱ʼnen huanigpe̱i̱kaʼeri menigaʼ iʼta̱e̱? ¿Kate iʼmanmadikikaʼ?” Sacerdote huairia Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","—‍Ayaʼ aratbuta menʼpe̱e̱po ijmanmadikanhuahuaʼmey. Judíoen hua̱i̱takeʼ jakyo ijmanmadikikaʼmey. Kenpaʼti Diosen jakyo ijmanmadikikaʼmey. Judío o̱gkupopakikaʼ ke̱ya̱ʼti ijmanmadikikaʼmey. I̱re̱gi̱re̱g manmadikahueʼ i̱ji̱kaʼmey. ");
INSERT INTO amrNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","“¿Kate iʼmanmadikikaʼ?” ¿Menaʼpo doʼtaj onaʼ? Ayaʼada doʼtaj menʼpe̱e̱i̱kaʼne, “¿Jesúsa kateaʼ monmadikameʼ?” Kenomeytaj yamanaʼ. Kenda ijmanaʼmey kenomeya̱ onʼnopo̱e̱. —‍Jesúsa sacerdote huairitaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Kenda eaʼte nogtida Diosen jak huato̱e̱ʼeria sorotataj Jesústaj huabaʼa oʼpebaspo, —‍Sacerdote huairitaj dakhueaʼ iaʼ. —‍Jesústaj kameʼpukoneʼpo onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","—‍Namaʼda onahueʼ i̱jje̱ynigʼa, namaʼda doa enaʼnayo kenda namaʼda iaʼne menaʼ. Huadakda doa yonaʼnigʼa menaʼpo oʼpebas. —‍Jesús onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Caifás sacerdote huairite Anása oʼtaʼmonaʼuy. Onʼtinukupo oʼtaʼmonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Kenokaʼ Pedro taʼakte aso̱ʼukkayaʼpo eʼbote, —‍¿Jesúsen huanigpe̱i̱kaʼeri menpaʼ i̱ʼe̱? —‍Oʼnonaʼuy. —‍Ehueʼ, Jesúsen huanigpe̱i̱kaʼeri ehueʼ i̱jje̱y. —‍Pedroa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ken, nogtida sacerdote huairien huanabaʼ o̱ʼe̱po. Keʼnen huabettaj Pedroa oʼpesodʼoktegnig. Keʼnakon Pedrotaj onaʼpo, —‍¿Jesúsere taʼbayo onʼtaj oʼtiahuaynig menpaʼ i̱ʼe̱? —‍Onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","—‍Ehueʼ. —‍Onteʼti Pedroa onaʼuy. Kenpaʼ eadeʼte huatahuaja oʼsipogʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Caifásen jakyaʼ Jesústaj onʼtohuaʼpo, Roma huairien jakyo onʼtohuaʼ. Judío huairi eʼaraktaʼ oʼderetpakpo onʼtohuaʼuy. Sikyoednada o̱ʼu̱y. Roma huairien jakyo judío aratbut kudhueʼdik o̱ʼneʼuy. Judío aratbut nog aratbuten jakyo kudhueʼdik o̱ʼneʼuynok, judío huakkurueri isiʼpo mabueyhueʼ o̱ʼnuy okkahuehueʼ fiesta aypo eʼbapeʼtaʼ onʼpakpo, Roma huairien jakyo kudhueʼdik o̱ʼne, eʼkudnayo, judío huakkurueri isiʼpo mabueyhueʼ o̱ʼnuy fiesta aypo bapehueʼdik o̱ʼneʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Jakyo kudhueʼdik o̱ʼneʼnok jak kurute Pilato oʼmahua̱o̱ro̱konpo, —‍¿In huabokerek kate dakhueaʼ yakaʼ? ¿Katiaʼ boʼhuaaʼ? —‍Pilatoa judío huairitaj oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","—‍Dakhueaʼ huakaʼeri o̱ʼe̱nok onte oʼtotiaki. Dakhueaʼ kahueʼ e̱e̱ʼnayo ontaj yokhueʼ o̱ʼe̱a̱ynigʼa. —‍Judío huairia oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","—‍Yanʼtohuaʼ. Konig opuden adhueaʼpaneʼ onʼmanaʼuyate castiga ya̱gʼkatiʼ. —‍Pilatoa oʼmanaʼuy. —‍Dakhueaʼ huakaʼeritaj oroʼnayo arakhueʼdik o̱ʼe̱y. Opuda̱ Roma jak hua̱e̱ʼeria dakhueaʼ huakaʼeritaj cruzte arakdik moʼe̱ne. —‍Judío huairia oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","“Cruz hue̱ypate nog aratbut meʼdarakapone.” Jesúsa oameʼnig. Konige̱po “Cruzte kabueyeʼpo,” Judío huairia oʼderetpakpo kenpayoʼ Pilatotaj oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Roma huairien jakyo Pilato oʼkudonpo onteʼti. Jesústaj oʼtokudpo onaʼpo, —‍¿Judío aratbuten gobierno huairi menpaʼ i̱ʼe̱? —‍Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","—‍¿Menpaʼ onda iʼnopo̱e̱po doʼtaj menaʼ? ¿Menpaʼ nogomey kenpaʼ monaʼnok menaʼ? —‍Jesúsa Pilatotaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","—‍Ehueʼ, kenda eʼnopo̱e̱ʼtaʼ pakhueʼ i̱jje̱po judío aratbut ehueʼ i̱jje̱y. O̱ʼnen aratbuta sacerdote huairierea doʼtaj mennigtotiakne. ¿Kate iʼkameʼ? —‍Pilatoa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","—‍In huadariyo aratbuten gobierno huairi ehueʼ i̱jje̱y. In huadariyo gobierno huairi doa e̱e̱ʼnayo judío huairia doʼtaj enʼtohuaʼte doʼhued huanigpe̱i̱kaʼeria doʼtaj menʼtiokaʼpo yanʼmagkaymet. In huadariyo gobierno huairi ehueʼ i̱jje̱y. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","—‍¿Huairi i̱ʼe̱ on? —‍Ken Pilatoa onaʼuyate. —‍E̱e̱ʼ, doa huairi i̱jje̱y. Kenda iaʼne. Huaknopo̱e̱ʼerien huairi a̱ʼe̱ya̱ʼpo kurudya̱ʼ ijhuarakpo isiʼpoe̱ʼuypo. Konig Dios o̱ʼe̱ aratbuttaj buttida aʼmanopo̱e̱a̱yaʼpo Diosyaʼ ijhuarakʼuy. Diostaj buttida huaʼa ayaʼada eʼpe̱e̱taʼ onʼpakpo doʼtaj onʼnigpe̱i̱kaʼ. Nogomey buttida huaʼa pakhueʼ o̱ʼnepo doʼtaj pe̱e̱hueʼ meʼnikaʼne. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","—‍¿Kate buttida huaʼa ya̱ʼe̱? —‍Pilatoa onaʼuyate. Kenda eaʼte judío aratbuttaj oʼmahua̱o̱ro̱konpo, —‍Jesúsa katepiʼ dakhueaʼ kahueʼda o̱ʼi̱kameʼte, yoknopo̱e̱y. ");
INSERT INTO amrNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ken konig opuda̱ boʼkikaʼ judío huakkurueri isiʼpo mabueyhueʼ o̱ʼnuy okkahuehueʼ fiestate opud boʼpaknok nogtida huabakuda̱ʼ jakyaʼ oʼnigo̱ro̱kaʼikaʼne. ¿Judíoen huairi hua̱e̱ʼ menpaʼ eʼnigo̱ro̱kaʼtaʼ boʼpak? —‍Pilatoa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","—‍Ehueʼ, kentaj pakhueʼ o̱ʼe̱y. Barrabástaj moʼnigo̱ro̱kaʼ. —‍Ayada oʼnokoyʼuy. Barrabás huabereʼeri o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Kenokaʼ “Jesústaj yanʼtohuaʼ, yanʼbitbittiʼ.” Oʼmanaʼpo Pilatoa sorotatataj oʼmataʼmonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Sorotataj onʼbitbitdepo eʼpidonbij onʼkuokkaʼpo Jesústaj onʼkuotaʼuyate. Okayagda huaok onʼotaʼuy. Okayag huaok gobierno huairiayoʼda onʼotikaʼ konig. ");
INSERT INTO amrNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Onʼhuahuaʼpo, —‍¡Yanoeunhuahuikatiʼ, judío gobierno huairi! —‍Sorotataa onʼtierikpo oʼnonaʼpo, huabaʼa onʼpebasʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Onteʼti Pilato oʼmahua̱o̱ro̱konpo, —‍E̱ya̱ʼ, opudte Jesústaj ijto̱ro̱kdey. Dakhueaʼ sigpiʼ kahueʼ o̱ʼi̱kaʼ, yanʼnopo̱e̱ʼ. —‍Judío aratbuttaj oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ken, eʼpidonbij huakuok oʼkuotdepo okayag oʼotdepo, Jesúsa o̱ʼo̱ro̱kʼuy. —‍¡In huabokerek o̱ʼe̱! Yanʼtiahuayʼ. —‍Pilatoa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Sacerdote huairiere Diosen jak huato̱e̱ʼeri Jesústaj onʼtiahuaydepo, oʼdokoypo, —‍Hue̱ypa cruzte yadarak. Hue̱ypa cruzte yadarak. —‍ʼUttaʼda oʼdokoyʼuy. —‍Opuda̱ yanʼpakpo yanʼtohuaʼ. Hue̱ypa cruzte yanʼpakpo yadarak. Keʼna dakhueaʼ sigpiʼ kahueʼ o̱ʼi̱kaʼ ijnopo̱e̱y. —‍Pilatoa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","—‍Oroʼen huadik eʼmanaʼ oʼto̱e̱y. Keʼna bueydik o̱ʼe̱, oaʼ. “Diosen Huasiʼpo i̱jje̱y.” Oaʼnok bueydik o̱ʼe̱. —‍Judío huairia oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Kenpaʼ oʼpe̱e̱depo Pilato nogi̱ti oʼmididpo ");
INSERT INTO amrNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","onteʼti gobierno huairien jakyo oʼkudonpo, —‍¿Meyo̱ hua̱e̱ʼeri i̱ʼe̱? ¿Beʼa i̱ʼe̱? —‍Jesústaj enaʼtada Jesúsa aʼtokhueʼda o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","—‍¿Menapaʼ doʼtaj aʼtokhueʼ o̱ke̱? Do gobierno huairi i̱jje̱po, ontaj o̱ro̱kaʼdik meʼe̱ne. Kenpaʼti hue̱ypa cruzte arakdik meʼe̱ne. ¿Menpaʼ iʼnopo̱e̱? —‍Pilatoa Jesústaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","—‍Diosa oʼpaknok gobierno huairi i̱ʼe̱po doʼtaj hue̱ypa cruzte arakdik o̱ʼe̱ne. Judío huabokereka onʼtaj boʼyokne kenaʼtaj dakhueaʼda meʼnogkaʼne. O̱ʼnanayo suhueʼda dakhueaʼ o̱gkaʼne. —‍Jesúsa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Kenda Pilato oʼpe̱e̱depo eʼo̱ro̱kaʼtaʼ oʼpakpo, monig o̱ro̱kaʼdik i̱jje̱y oʼnopo̱e̱po oʼukʼuynigʼa, judíoa oʼdokoypo, —‍Kentaj o̱ro̱kahueʼ ya̱e̱ʼ, kentaj eʼo̱ro̱kanayo Roma gobierno huantopa huairia ontaj onteʼti pakhueʼ o̱ʼe̱po oʼenapo. César o̱ʼnen huantopa o̱ʼe̱nok. Beʼapiʼ “Do huairi i̱jje̱y,” huataʼda eʼhuaaʼnayo Césaren takaʼ o̱ʼe̱nok arakdik o̱ʼe̱. —‍Judío huairia ʼuttaʼda oʼdokoyʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Kenda Pilato oʼpe̱e̱depo Jesústaj oʼto̱ro̱konpo huantopa huahuadte oʼhuadatoʼuy. Kenda judíoen huaʼa oʼdikkaʼ Gabata. Huidʼaytate o̱ʼu̱y. ");
INSERT INTO amrNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Aʼti tokhuada̱ʼ oʼhuadapo kenpaʼti emeʼte judíoen okmapi̱e̱ʼahuaddik huameʼnoe o̱ʼe̱a̱ponok, —‍In o̱ʼnen huairi moʼta̱e̱ne. —‍Pilatoa judío huairitaj oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","—‍Yaarak. Yaarak. O̱hue̱yen cruzte yabetaʼ. —‍Judío huairia oʼdokoyʼuy. —‍¿Opuden huairitaj menpaʼ o̱hue̱yen cruzte doa eʼbetaʼtaʼ boʼpak? —‍Pilatoa oʼmanaʼuy. —‍Roma huantopa César kenyoʼda mota̱e̱ne. —‍Sacerdote huairiomeya̱ oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Kenokaʼ Pilato kenomeytaj oʼmanigpe̱e̱po o̱hue̱yen cruzte kanʼarakeʼpo oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ken Jesústaj onʼtohuaʼuy. Keʼnen hue̱ypa cruz Jesús oʼtohuaʼuy. Oteʼ huadik Huakuaiʼte oʼtohuaʼuy. Ken oteʼ judíoen huadik o̱ʼe̱ Gólgota. ");
INSERT INTO amrNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Kente e̱kye̱deʼte Roma sorotataj hue̱ypa cruzte siropia onʼti̱o̱gkoʼeaʼpo onʼbetaʼuy. Kenpaʼti nog bottaʼ huabokerektaj hue̱ypa cruzte onʼmabetaʼpo, nogkoreʼ nogkoreʼpen onʼmabetaʼuy. Jesústaj nopoyo cruzte onʼbetaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","“Jesús Nazareteri judíoen gobierno huairi o̱ʼe̱.” Huaente yanʼmadoyaʼpo, cruz kutapen yanʼbetaʼ, Pilatoa oʼmanaʼnok onʼmadoyaʼpo onʼbetaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Huakkaʼada judíoa eʼmadoyaʼ onʼtiahuayʼuy. Ken hue̱ypa cruzte enʼbettaʼte huakkaʼ jak Jerusalén ʼibodteda o̱ʼe̱nok, kenaʼpo huakkaʼada judíoa eʼmadoyaʼ onʼtiahuayʼuy. Judíoen huaʼate onʼmadoyaʼpo, Roma hua̱e̱ʼerien huaʼate onʼmadoyaʼpo, kenpaʼti griego huaʼate onʼmadoyaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","—‍“Judíoen huairi o̱ʼe̱,” madoyahueʼ ya̱e̱ʼ. “Judíoen huairi i̱jje̱y,” in huabokerek oameʼte. Kenpaʼ yamadoyaʼ. —‍Judío sacerdote huairia Pilatotaj oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","—‍Kejeʼ, kenda ijmadoyay kenpaʼda ijmadoyaʼdey. —‍Pilatoa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Sorotataj Jesústaj onʼbetaʼdepo bottaʼ bottaʼa keʼnen yudtaj nogti nogti onʼdeʼeʼuy. Kenpaʼti keʼnen huaok tiokhuihuihueʼ nogtida huaok o̱ʼe̱nok, ");
INSERT INTO amrNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","—‍Huishueʼ moʼne. Beʼa eʼdik aʼnopo̱e̱yaʼpo huid okmo moʼnenʼe̱. —‍Onpapayoʼ sorotataj oʼdadpo, ken konig Apagbaʼte oaʼuyate, “Doʼhued yudtaj nogti nogti yanʼdeʼeapet. Doʼhued huaoktaj beʼa yaʼeyapet aʼnopo̱e̱yaʼpo huid okmo yaʼnenʼe̱a̱pet.” Kenda Apagbaʼ oaʼuyatenig kenda o̱gkaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Onteyoʼ Jesúsen cruzte o̱ʼnepo, Jesúsen hua̱ye̱, huamaʼbuyere o̱ʼnepo, kenpaʼti María, Cleofasen hua̱to̱e̱ o̱ʼe̱po kenpaʼti María Magdalena o̱ʼe̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesúsen hua̱ye̱ doere oʼbonok Jesúsa boʼtiahuaypo, —‍In o̱ʼnen huasiʼpo iʼta̱e̱ne ettoneʼ. —‍Hua̱ye̱taj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","—‍In o̱ʼnen hua̱ye̱ iʼta̱e̱ne. —‍Do Juantaj menaʼuyne. Kenokaʼ Jesúsen hua̱ye̱taj doʼhued jakyo ijtohuaʼuy, doʼhued jakyo ijto̱i̱kaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Kenda Jesúsa oaʼdepo, ayaʼda Diosen huaʼa ijkuhuitdey Jesúsa oʼnopo̱e̱po, —‍Maymaya̱ ijjay. —‍Jesúsa oaʼuy. Kenda Apagbaʼa oʼbatiaʼpakuynig Jesúsa oaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Kosoyo vino paiʼ hueda̱ʼda onhuadʼuy. A̱pon esponja oʼnigoyeʼepo, hue̱ypate onʼbetaʼpo huakittaʼte oʼnigokteaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Vino paiʼ oʼmaiʼdepo, —‍Ayaʼda Diosa oʼpaknig ijkaʼdepo ijkuhuiti. —‍Jesúsa oaʼdepo, oʼkutaʼboypo oʼbueyʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Emeʼte okmapi̱e̱ʼahuaddik o̱ʼe̱a̱po kenpaʼti judío huakkurueri isiʼpo mabueyhueʼ o̱ʼnuy okkahuehueʼ fiesta o̱ʼe̱a̱po, Diostaj ʼurumeʼnoe o̱ʼe̱a̱ponok kenaʼpo hue̱ypa cruzte hua̱so̱ʼ e̱a̱hueʼdik o̱ʼnepo “Hue̱ypa cruzte huabeterien huabopi yanʼmabopiokketekpo yanʼbahuarakaʼ kenpaʼti yanʼbatohuaʼ.” Judío huairia Pilatotaj oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Oʼnonaʼnok sorotataj onʼhuaʼpo huakkuru huabokerektaj huabopi oʼnokketekpo, nogtakon Jesúsere cruzte eʼbetaʼtaj huabopi oʼnokketekʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ken onʼbakketekdepo Jesústekon onʼhuahuaʼpo eʼbueyondeʼ onʼtiahuayatoʼpo keʼnen huabopi okketekhueʼ o̱ʼneʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Okketekhueʼada sorotataj nogtiada keʼnen siro huiʼdaka Jesústaj onʼpidtukaʼuy. Enpidtukaʼte i̱da mimi hue̱ʼe̱yere oʼmimihuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Do Juan ayaʼtada ijtiahuayʼuy, buttida ijjay, ijnopo̱e̱y. Opudomey dakaʼ Jesústaj oknopo̱e̱ʼdik moʼi̱kaʼaponok buttida ijtimadoyay. ");
INSERT INTO amrNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","“Keʼnen huaʼay nogayʼtipiʼ okketekhueʼ o̱ʼneapo.” Apagbaʼa oaʼuyatenok Jesúsen huabopi okketekhueʼ o̱ʼnuy. ");
INSERT INTO amrNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","“Kentaj onʼpidtukapo kenda onʼtiahuayapo.” Nogya̱ʼ Apagbaʼte onʼtimadoyaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Jesústaj enpidtukaʼdeʼte, —‍Hua̱so̱ʼ kakubarakkeʼpo beyok. —‍Pilatotaj José Arimatea huakkaʼ jakyo hua̱e̱ʼeria onaʼuy. José Jesústaj huaknopo̱e̱ʼeri o̱ʼe̱po judío huairitaj oʼmididpo soatayoʼ Jesústaj huaknopo̱e̱ʼeri o̱ʼu̱yate. —‍Yatohuaʼ. —‍Pilatoa onaʼuynok cruzte oʼhuaʼpo, hua̱so̱ʼ oʼhuarakaʼpo oʼtohuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nicodemo kenpaʼti oʼhuaʼuy. Keʼna aʼnenda sikyo Jesústaj aʼbatiaʼpakyaʼpo oʼhuahuaʼuyate. Ken mirraere áloesere oʼtohuaʼpo, mirra kenpaʼti áloes konig ʼuruʼhui̱e̱da e̱ʼe̱o̱k treinta kilos oʼtohuaʼpo, ");
INSERT INTO amrNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Joséere Nicodemoere Jesúsenso̱ʼ onʼtohuaʼpo konig mirra áloesere ʼuruʼhui̱e̱da yudtaʼbia onʼtihui̱yi̱gonpo. Ken konig judíoa onʼbakubarakkikaʼnig konigti Jesústaj onʼkubarakkaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Kenteda Jesústaj yaarakteda taʼba o̱ʼu̱y. Kenteda taʼbayo huaboda kubarak hua̱e̱ʼ eʼkogkaʼ o̱ʼe̱po ke̱yo̱ sigpiʼ bakubarakkahued e̱e̱ʼyo̱. ");
INSERT INTO amrNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Jesústaj onʼkubarakkaʼuy. Kenaʼpo emeʼte judíoen okmapi̱e̱ʼahuaddik huameʼnoe o̱ʼe̱a̱po kenpaʼti kubarak eʼkogkaʼ ʼibodteda o̱ʼe̱nok kenteda Jesústaj onʼkubarakkaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Domingote eʼmeunyakte sikki̱re̱genteda kubarak eʼkogkaʼyo María Magdalena oʼhuaʼpo, huakogyo̱ huakhuida̱ eʼtinokbetaʼmeʼyo ekpokoreaʼ oʼtiahuayʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Oʼtiahuaydepo oʼketonyakpo Simón Pedrotaj doeretaj boʼhuatiakuyne. —‍Kubarak huakogya̱ʼ Huairitaj onʼtohuaʼte. Ke̱yo̱ onʼhueda̱ʼtaj nopo̱e̱hueʼ o̱ʼe̱y. —‍María monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","4","Pedroere doere oʼhuaʼpo kubarakyo oʼhuaʼpo oroʼ bottaʼ oʼketpo donayo i̱da ijketpo huakkuruda kubarakyo i̱jji̱a̱toʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Yonoktoatoʼpo ijtiahuayʼuy. Yudtaʼbijyoʼda eʼhued ijtiahuaypo Jesúsbueytaj tiahuayhueʼ i̱jje̱po kudhueʼ i̱jju̱y. ");
INSERT INTO amrNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Taʼpotaʼ Simón Pedro oʼtiakatopo kubarakkogyo oʼkudonpo yudtaʼbijyoʼda eʼbahued oʼtiahuaypo ");
INSERT INTO amrNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","yudtaʼbia onʼkutihui̱yi̱gʼuynig huataʼ oʼhuedʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Doa huakkuru e̱ʼe̱a̱toada taʼpote ijkudonpo ijtiahuaypo kenpaʼti yoknopo̱e̱ʼuy. Jesús onteʼti oʼnoyhuadde yoknopo̱e̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Eʼbueyada onteʼti noyhuaddik o̱ʼe̱a̱po konig Apagbaʼ oaʼ oroʼ nopo̱e̱hued o̱ʼe̱ʼuynigʼa huaboaʼda oknopo̱e̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Oʼtiahuaydepo oroʼen jakyo oʼhuaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Kubarakkogte kurute María onteʼti oʼtiakdepo oʼbopo oʼhuikuyate. Oʼhuikpo kubarak eʼkogkaʼyo oʼkubuypo oʼnoktoatoʼpo oʼtiahuayʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Bottaʼ Diosen huataʼmoneritaj oʼtiahuayʼuyate. Yereda onʼotpo kente Jesúsbuey oʼhuedmeʼte onʼhuad. Nogtida huakupen oʼhuadʼuy. Nogtida huaʼipen oʼhuadʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","—‍¿Menaʼpo iʼhuik, ettoneʼ? —‍Oʼnonaʼuy. —‍Doʼhued Huairitaj onʼtohuaʼtenok ijjay. Ke̱yon onʼhueda̱ʼ nopo̱e̱hueʼ i̱jje̱y. —‍María oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Kenda oʼmanaʼdepo oʼbatipekorudpo Jesús eʼbote oʼtiahuayʼuynigʼa, Jesús o̱ʼe̱ o̱ki̱e̱hueʼ o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","—‍¿Menaʼpo iʼhuik, ettoneʼ? ¿Beʼtaj iʼuk? —‍Jesúsa onaʼuyate. —‍O̱ʼna eʼtohuaʼnayo ke̱yo̱ ijhueda̱y menaʼ. Doʼhua ijtohuaʼapoy. —‍María onaʼuyate. Taʼba huato̱e̱ʼeri keʼna o̱ʼe̱ namaʼda oʼnopo̱e̱po kenda Jesústaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","—‍¡María! —‍Jesúsa onaʼuyate. Kentaj oʼtikorudpo, o̱ki̱e̱ʼdepo, —‍Huamanmadikaʼeri. —‍María onaʼpo oʼdokoatoʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","—‍Doʼtaj so̱ʼto̱e̱a̱hueʼ meeʼ. Apag Diosyo behuikhued i̱jje̱y. Doʼhued huamaʼbuyte yahuatiʼ. “Doʼhued Apag Dioste kenpaʼti opuden Dioste ijbehuikapoy,” oaʼ, yamanaʼ. —‍Jesúsa Maríataj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ken María Magdalena oroʼ huanigpe̱i̱kaʼeriomeytaj boʼhuatiakdepo, “Huairitaj ijtiahuay.” Oroʼtaj monaʼpo kenda Jesúsa Maríataj enʼbatiaʼpak María monbatiaʼpakuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Kenda huameʼnoe, domingo sikyo oroʼ huanigpe̱i̱kaʼeri jakyoda oʼkupopakpo judío huairitaj oʼmididpo akbogpe oʼyahuekaʼpo. Jesús ihuiti ehueʼ oroʼ eʼkupopaknopoyo oʼbopo, —‍Meʼpukhueʼ yaneʼ. —‍Jesúsa monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Kenda eadeʼte keʼnen huabaʼ eʼbati̱o̱gkoaʼ boʼtiahuayʼeaʼuyne. Keʼnen huapid eʼpidtukaʼ boʼtiahuayʼeaʼuyne. Huairitaj oʼtiahuaypo oʼnoki̱a̱ʼdepo oʼdurugpakuy. ");
INSERT INTO amrNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","—‍Yanʼnopoʼnoeyʼ meʼpukhueʼ yaneʼ. Konig doʼhued Apag doʼtaj meʼtaʼmonaʼuyne, ayaʼtada huadak huaʼa kamaneʼpo ijmataʼmonaʼapoy. —‍Onteʼti monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kenpaʼ oaʼpo oroʼtaj boʼtipoapo, —‍Diosen Noki̱re̱ga̱ moʼnopoʼto̱e̱ʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Opuda̱ nogen dakhueaʼ eʼkaʼ eʼbakkahueaʼnayo Diosakon kenomeyen dakhueaʼ eʼkaʼ oʼbakkahueaʼdeapo. Nogen dakhueaʼ eʼkaʼ opudomeya̱ okkahueahueʼ e̱e̱ʼnayo Diosakon okkahueahueʼ oʼmaeapo. —‍Jesúsa monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tomás, nogtiada doce huanigpe̱i̱kaʼeri o̱ʼe̱po, nogdikda Gemelo. Jesús huakkuruda oroʼere eʼbote Tomás ehueʼ o̱ʼu̱y. ");
INSERT INTO amrNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","—‍Jesús Huairitaj oʼtiahuay. —‍Nog huanigpe̱i̱kaʼeria Tomástaj oʼnonaʼuy. —‍Huabaʼtaʼ siropi onʼbati̱o̱gkoameʼte tiahuayhueʼ e̱e̱ʼnayo kenpaʼti siropia eʼti̱o̱gkoaʼe̱yo̱ doʼhued huabaʼpiʼ kudhueʼ e̱e̱ʼnayo kenpaʼti doʼhued huabaʼ keʼnen huapidte eʼpidtukaʼyo bakudhueʼ e̱e̱ʼnayo Huairi oʼnoyhuadmeʼte oknopo̱e̱hueʼdik i̱jje̱a̱poy. —‍Tomása oroʼtaj monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ocho huameʼnoe eʼpokdeʼte oroʼ huanigpe̱i̱kaʼeri onteʼti jakyo eʼkupopakte Tomásere o̱ʼe̱po akbogpe okyahueʼkaʼnigʼa Jesúsa oʼkudonpo oroʼ nopoyo oʼboatoʼuy. —‍Meʼpukhueʼ yaneʼ, yanʼmanopoʼnoeyʼ. —‍Monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","—‍Intaʼ menej. Doʼhued huabaʼ yatiahuayʼ. Huapidyo mebakud. Oknopo̱e̱hueʼ e̱e̱ʼ yabatikpo doʼtaj meknopo̱e̱ʼ. —‍Tomástaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","—‍Doʼhued Huairi o̱ʼta̱e̱ne. Doʼhued Dios o̱ʼta̱e̱ne. —‍Tomása onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","—‍Doʼtaj beʼtiahuaypo kenaʼpo doʼtaj meknopo̱e̱ne. Do Diosen Huasiʼpo o̱ʼe̱ meknopo̱e̱ne. Nogomeya̱ doʼtaj tiahuayhueʼ e̱ʼe̱a̱da meʼnoknopo̱e̱po durugda o̱ʼneapo. —‍Jesúsa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesúsa huakkaʼda oʼbayareaʼuy. Kenpaʼti konig Diosayoʼda kaʼdik o̱ʼe̱nig Jesúsa oroʼere huakkaʼ oʼkikaʼuy. In berobaʼte ayaʼ madoyahueʼ i̱jje̱y. In berobaʼte suhueʼda ijmadoyay. ");
INSERT INTO amrNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","In ijmadoyaʼnok Jesús Diosen Huasiʼpo o̱ʼe̱ kenpaʼti Cristo o̱ʼe̱po Diosyaʼ oʼtiakʼuyate oknopo̱e̱ʼdik moʼe̱ne. Ayaʼada kenda oʼnoknopo̱e̱po onteʼti Diosere onʼnoeunhuahuikaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Nogok onteʼti Jesúsa hua̱so̱ʼda oroʼ huanigpe̱i̱kaʼeritaj boʼtiahuayʼeaʼuyne. E̱ʼpo̱g Tiberiaste Jesúsa hua̱so̱ʼda oroʼ huanigpe̱i̱kaʼeritaj boʼtiahuayʼeaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simón Pedroere Tomásere, Natanaelere, doere, doʼen huamaʼbuyere, kenpaʼti bottaʼ nog huanigpe̱i̱kaʼeriere onteteyoʼ o̱ʼu̱y. (Tomás konogda oʼdikkaʼ Gemelo.) (Natanael Caná Galileaeri o̱ʼu̱y.) (Doere doʼen huamaʼbuyere Zebedeoen huasiʼpo o̱ʼe̱y.) Oroʼ onteteyoʼ o̱ʼu̱y. ");
INSERT INTO amrNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","—‍Biig yo̱gkaʼapoy. —‍Simón Pedroa monaʼuyne. —‍Oroʼtion oʼhuaʼapoy. —‍Onaʼuy. Ken, oʼhuaʼpo kusiʼpeyo oʼkudpo, e̱ʼpo̱g nopote okenʼe̱bedpo sigpiʼ biig ontotokhueʼda o̱ʼe̱bedʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Huaboaʼda eʼmeunyakte aktaʼbogpete Jesústaj eʼhuahuayada Jesús o̱ʼe̱ o̱ki̱e̱hueʼ o̱ʼu̱y. ");
INSERT INTO amrNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","—‍¿Menpaʼ biig boʼkuda̱ʼ, huadiʼ? —‍Jesúsa monaʼnok —‍Kuda̱hueʼ o̱ʼe̱y. —‍Onaʼuy oroʼa. ");
INSERT INTO amrNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","—‍Nogkorepen huadaʼkopen yanoken, huakkaʼda montotokapone. —‍Jesúsa monaʼuyne. Ke̱yon okenpo, huakkaʼda biig oʼkudpo ontotokhueʼdik o̱ʼe̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","—‍¡Huairi o̱ʼe̱! —‍Doʼa Pedrotaj yonaʼuynok othueʼ o̱ʼe̱po biig okenepo, ken Huairi o̱ʼe̱, Simón Pedro oʼpeeonpo oʼotonpo hua̱hue̱yo̱ oaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Oroʼ kusiʼpete oʼhuaʼuy. Aktaʼbogpeyo oʼhuaʼuy. Huakeneʼyo̱ biig hueda̱ʼda onʼtotokʼuy. Aktaʼbogpe meyo̱hueʼda o̱ʼu̱y. ");
INSERT INTO amrNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Oʼbetanpo taʼak oʼtiahuaypo, biigere panere taʼakte eʼtiayaʼ oroʼ oʼtiahuayatoʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","—‍Suhueʼda biig huaboaʼda huakeneʼyo̱ montotoknig yanʼtotiak. —‍Jesúsa monaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simón Pedro kusiʼpeyo oʼhuaʼpo aktaʼbogpete huakeneʼ onʼtotokʼuyate. Hueda̱ʼda onʼtotokpo ciento cincuenta y tres boroʼbiig e̱ʼe̱a̱da huakkaʼda e̱ʼe̱a̱da huakeneʼ onokpukonhueʼ o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","—‍Yanʼtiak. Yanʼbapeʼ. —‍Jesúsa monaʼuyne. Huairi o̱ʼe̱ eʼnopo̱a̱da. “¿Beʼa i̱ʼe̱?” Anayʼ eʼnopo̱a̱da oroʼ oʼmeʼpukpo ahueʼ o̱ʼu̱y. ");
INSERT INTO amrNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ken Jesúsa taʼakyo oʼtiakpo pan oʼetupo boʼyokeʼuyne. Kenpaʼti biig oʼetupo, boʼyokeʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jesúsa oʼnoyhuaddepo oroʼ huanigpe̱i̱kaʼeritaj kenokaʼ bapaʼaʼ bohuahuayʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ken onʼbapuddepo, —‍¿Menpaʼ inomeya̱ doʼtaj sueʼda diʼ meʼnene. Menpaʼ o̱ʼnanayo doʼtaj nogi̱ti huakaʼda diʼ o̱ʼe̱ne, Simón, Jonásensiʼpo? —‍Jesúsa onaʼuy. —‍E̱e̱ʼ, Huairi. Onʼtaj diʼda i̱jje̱y, kenda iʼnopo̱e̱ne. —‍Simóna onaʼnok, —‍Doʼhued huanigpe̱i̱kaʼeri konig oveja o̱ʼnenok dakaʼ yabatiokikaʼ. —‍Jesúsa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","—‍¿Menpaʼ doʼtaj diʼda o̱ʼe̱, Simón Jonásensiʼpo? —‍Onteʼti Jesúsa onaʼuy. —‍E̱e̱ʼ, Huairi. Ontaj diʼda i̱jje̱y. Kenda iʼnopo̱e̱ne. —‍Simóna onaʼnok, —‍Doʼhued huanigpe̱i̱kaʼeri dakaʼ yamato̱i̱kaʼ. —‍Jesúsa Pedrotaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","—‍¿Menpaʼ diʼ o̱ʼe̱, Simón, Jonásensiʼpo? —‍Bapaʼaʼ Jesúsa onaʼuy. “¿Menpaʼ diʼ o̱ʼe̱?” Bapaʼaʼ Jesúsa jenak Pedro huaboaʼda suhueʼ o̱ʼunpo, —‍On ayaʼda iʼnopo̱e̱, Huairi. Onʼtaj diʼda o̱ʼe̱ne iʼnopo̱e̱. —‍Simóna onaʼuy. —‍Doʼhued huanigpe̱i̱kaʼeritaj dakaʼ yamato̱i̱kaʼ. ");
INSERT INTO amrNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Huabo i̱ʼe̱po konig iʼpakpo iʼotikaʼuy, meyo̱piʼ ehuaʼtaʼ iʼpakpo iʼhuaeʼikaʼuy. Nogok toneʼda e̱ʼe̱deʼte huabaʼ boʼosaddaapo noga̱ moʼtinukuʼapet. Ke̱yo̱ ehuaʼtaʼ pakhueʼ e̱e̱ʼtada boʼtohuaʼapet. Buttida ijjay. —‍Jesúsa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ken konig oʼbueyapo. Jesúsa moʼnopoenkaʼuy. Kenpaʼti Pedro oʼbueydepo Dios ʼuruda o̱ʼe̱ oʼmanopo̱e̱a̱ʼapo. Jesúsa oʼbatiaʼpakʼuy. Kenpaʼti onaʼpo, —‍Doʼtaj menigpe̱i̱kaʼ. —‍Jesúsa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Jesúsa doʼtaj diʼnanada meʼi̱kaʼuyne. Aʼnen Jesúsere oʼbapeʼpo Jesústaj ijtipebetpo, “¿Beʼa ontaj judío huairitaj yaʼbayokapet, Huairi?” Doʼhua yonaʼmey. Ken oʼhuaʼdepo doʼtaj Pedro oʼkorepo huataʼpipen beʼtiahuayʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pedroa beʼtiahuaydepo, —‍¿Juanataj monig bueydik ya̱ʼe̱, Huairi? —‍Pedroa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","—‍Doʼa kurudyo̱ ijhuaʼapoy. Doʼhua eʼpaknayo doʼhua nogoknanada onteʼti eʼtiakdeʼte Juan bueyhued eʼnoeʼnayo meʼpukehueʼada doʼtaj menigpe̱i̱kaʼ. —‍Jesúsa Pedrotaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Juan bueyhueʼ o̱ʼe̱a̱po. Nog huanigpe̱i̱kaʼeria namaʼda onʼbatiaʼpakuy, “Juan bueyhueʼ o̱ʼe̱a̱po.” Jesúsa ahueʼ o̱ʼu̱ynigʼa, “Doʼa eʼpaknayo kurudya̱ʼ onteʼti eʼtiakdeʼte Juan bueyhued eʼnoeʼnayo meʼpukehueʼ ya̱e̱ʼ.” Kenpaʼ Jesúsa Pedrotaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Doa Juan ayaʼda ijtiahuayikaʼpo, ijpe̱i̱kaʼpo kenpaʼti ijnopo̱e̱po onʼnigmadoyaʼne. Buttida ijmadoyay, buttida oʼnopo̱e̱y. ");
INSERT INTO amrNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jesúsa huakkaʼda nogda nogda oʼkaʼuyate. Kenpaʼti huakkaʼda oʼmanmadikikaʼuyate. Kenda ayaʼda eʼmadoyadhuahuikaʼnayo in huadari ayaʼ berobaʼ dakhuapa to̱e̱hueʼdik o̱ʼe̱, ijnopo̱e̱y, ken.");
INSERT INTO amrNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","Huadiʼda Teófilo, do Lucas aʼnenda oʼnigmadoyaʼuyne. Kenda Jesúsa oʼkadhuahuikaʼuynig oʼmanmadikadhuahuikaʼuynig ayaʼda oʼnigmadoyaʼuyne. Kenpaʼti kurudyo̱ huahued e̱e̱ʼted keʼnen huamataʼmoneri eʼbaktieʼeaʼuydeʼte Diosen Noki̱re̱gere oʼmanaʼuyate, kenpaʼti kenmeʼnoeteda kurudyo̱ oʼhuaʼuyate, oʼnigmadoyaʼuyne. ");
INSERT INTO amrNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Jesús oʼbueydepo nogok nogok once huamataʼmoneritaj Jesúsa oʼbatiahuayʼeaʼuyate. Cuarenta huameʼnoe eʼpokte nogok nogok oʼbatiahuayʼeaʼpo kenomeytaj “doada i̱jje̱y” oʼmanaʼnok dakaʼ oʼmanopo̱e̱a̱ʼpo kenpaʼti Dios Huairitaj yanʼnigpe̱i̱kaʼ kenpaʼti Diosensiʼpo moʼe̱a̱pone. Jesúsa oʼmanbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Kenokaʼ Jesúsen once huamataʼmoneri Jesúsere o̱ʼnepo, nogi̱ti Jesúsa oʼmanaʼpo, —‍Jerusalénya̱ʼ huahueʼ yaneʼtiʼ. I̱yo̱ yanʼnige̱ʼ. Diosen Noki̱re̱g ijtaʼmonapoy. —‍Diosa ennak. ");
INSERT INTO amrNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Juana hue̱ʼe̱ya̱ bautiza oʼkikaʼuynigʼa aʼti Diosen Noki̱re̱ga̱ bautiza mogkaʼpo opudtaj oʼmanopoʼto̱e̱a̱po. Jesúsa keʼnen once huamataʼmoneritaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Onteʼti Jesúsere o̱ʼnepo, —‍¿Menpaʼ Romano gobierno huairitaj iʼmaenapo? ¿Menpaʼ oy onteʼti judío gobierno huairi to̱e̱dik o̱ʼe̱a̱pet, Huairi? —‍Jesústaj oʼnonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","—‍Diosayoʼda kurudyo̱ ayaʼda kaʼdik o̱ʼe̱. Kenokaʼ oʼpakpo, oʼkaʼapo. Opudtaj kenmeʼnoe nopo̱e̱a̱hueʼdik o̱ʼe̱ Diosa. ");
INSERT INTO amrNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Diosen Noki̱re̱g opudtaj oʼhuatiakpo opudtaj moʼnopoʼto̱e̱a̱pone boʼteypakaʼapone. Opudtaj ʼuruaʼda montihuapokikaʼapone. Diosen huakaʼ montihuapokikaʼapone. Jerusalén huakkaʼ jak hua̱e̱ʼeritaj konig ijkikameʼnig konig ijbueymeʼnig ijnoyhuadmeʼnig manbatiaʼpakikaʼdik moʼi̱kaʼapone. Judeabayo konigti batiaʼpakdik moʼi̱kaʼapone. Kenpaʼti Samariabayo konigti batiaʼpakdik moʼi̱kaʼapone. Kenpaʼti huehueaʼda ayaʼbayoda ayaʼ aratbuttaj konigti manaʼdik moʼi̱kaʼapone. —‍Jesúsa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Kenda eadeʼte huanigpe̱i̱kaʼeria enʼtiahuayate Diosa kurudyo̱ Jesústaj oʼtobehuikuyate. E̱ʼsi̱hui̱ʼyo̱ eʼkudonte onteʼti Jesústaj tiahuayhueʼdik o̱ʼneʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Kurudyo̱ eʼbehuikdeʼte Jesúsen huanigpe̱i̱kaʼeri kurudyo̱ enʼtiahuayate i̱da onteteyoʼ bottaʼ huabokerek onʼbataʼboatoʼpo yudtaj keregda onʼotuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","—‍¿Menaʼpo kurud boʼtiahuayaʼ? Jesús kurudyo̱ oʼbehuikonde, opud e̱ʼe̱ya̱ʼ Jesús eʼbehuikte, boʼtiahuaynig konigti yaʼhuarakapet, Galilea huadarieri. —‍Diosen huataʼmoneria onʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Oteʼ Olivosyaʼ onʼbahuaʼuy. Jerusalényo̱ meyo̱hueʼda onʼbahuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Huakkaʼ jak Jerusalényo̱ onʼtiakdepo jak ayta kutayo kente onʼtaiʼikaʼ onʼbehuikuy. Huakkaʼda o̱ʼnepo, Pedro, Jacobo, Juan, Andrés, Felipe, Tomás, Bartolomé, Mateo, Jacobo, Simón cananista kenpaʼti Judas o̱ʼnepo. Jacobo Alfeoensiʼpo o̱ʼu̱yate. Judas Jacoboen huamaʼbuy o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ayaʼada onʼpakpo kiriga̱yo̱ʼ Diostaj onʼtionaʼpakikaʼ. Sueʼda ettoneʼbetaʼ onʼtionaʼpakonhuaʼuyate. María, Jesúsen inag kenpaʼti Jesúsen huamaʼbuy, o̱ʼnuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Kenokaʼ onʼtionaʼpakonhuaʼpo huamaʼbuynopoyo Pedro oʼboʼuyate. Jesúsen huanigpe̱i̱kaʼeri huamaʼbuy o̱ʼu̱yate. Ciento veinte huamaʼbuy enʼkupopakte: ");
INSERT INTO amrNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—‍Aʼnenda David Apagbaʼte oaʼpo kenda Judas oʼkameʼnig oaʼuyate. Konig Jesústaj takaʼtaj yanʼyokapet Davidtaj Diosen Noki̱re̱ga̱ oʼnopoʼto̱e̱nok, David oaʼuy. Buttida Apagbaʼte oʼuyate konigti o̱ʼe̱meʼte. ");
INSERT INTO amrNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Judas oroʼere o̱ʼi̱kaʼpo, oroʼere oʼkikameʼnigʼa ");
INSERT INTO amrNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","dakhueaʼ eʼkaʼ huakupe o̱ʼe̱nok Sacerdote huairitaj oʼbatahuameʼte huadarisiʼpo onʼbakemeʼte. Huakupen oʼnennok oʼdapopotagonpo huamin ayaʼda o̱ʼo̱ro̱konʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","I̱da ayaʼ Jerusalén hua̱e̱ʼeria onʼtipeenʼuyate. Ken huadarisiʼpotaj Acéldama onʼdikkameʼte. Kendik Acéldama mimidari o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ken konig Davida Judastaj Salmosbaʼte oʼtimadoyaʼuyate: Konig jak ekhuaʼnig i̱kahueʼ o̱ʼe̱a̱po. Kenpaʼti: Nogbokerekda keʼna eʼkikaʼ kakeʼ. David eʼbatadiʼkeaʼbaʼte oʼtimadoyaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Oy Judas ehueʼda o̱ʼe̱nok noga̱ oroʼere “Jesús oʼnoyhuadmeʼte,” manbatiaʼpakikaʼdik ya̱ʼe̱a̱pet. Nogtatida eʼdik o̱ʼe̱y. Keʼna oroʼere kenpaʼti Jesúsere o̱ʼi̱kaʼuy. Jesústaj Juan bautiza e̱gkaʼte o̱ʼi̱kaʼuy, kenpaʼti Jesúsa eʼmanmadikaʼte o̱ʼi̱kaʼuy kenpaʼti Jesús eʼnoyhuaddeʼte oroʼere o̱ʼi̱kaʼ. Nogtatida eʼdik o̱ʼe̱y. —‍Pedroa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Bottaʼtaj eretnopoyo onʼtotiakuyate José Matíaseretaj. Josétaj bottaʼdik oʼdikkaʼuy Barsabás Justo. ");
INSERT INTO amrNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Inpaʼ onʼtionaʼpakpo: —‍On ayaʼen huanopoʼda iʼmaknokotikaʼne, Huairi. Judas dakhueaʼ oʼkaʼpo nogyoda huaʼdik o̱ʼe̱po oʼhuameʼ. ¿Beʼa keʼna e̱e̱ʼpaʼti ya̱ʼe̱a̱po? Bottaʼ huabokerek i̱yo̱ o̱ʼne. ¿Beʼtataj iʼpak? ¿Beʼtataj iʼeapo? —‍Onʼtionaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Konig huanopo̱e̱ʼ huid okmo onʼenʼuyate. Oʼnendepo onʼtiahuaypo, Matías oroʼere Jesústaj huadak huaʼa oʼmanbatiaʼpakapo, onʼnopo̱e̱ʼuy. Jesúsen huamataʼmoneri Matíasere doce onteʼti o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Pentecostés fiesta kenokaʼ oʼmeʼdeʼuy. Jesús eʼbueyte cincuenta huameʼnoe oʼpokondepo, Jesúsen huanigpe̱i̱kaʼeri e̱gkupopakte ");
INSERT INTO amrNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","i̱da konig huaboroʼ bapoka eapaʼ eʼadyakte onʼpe̱e̱ʼuy. Kurudya̱ʼ eʼadyakte onʼpe̱e̱po, ayaʼada ken jakyo onʼbahuadpo onʼpe̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Kenokaʼ konig taʼak eʼbakpakonig ayaʼtada oʼbakutikotepo, oʼpijboepo. ");
INSERT INTO amrNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Huabada Diosen Noki̱re̱ga̱ oʼmanopoʼto̱e̱po, nogen nogen aratbuten huaʼa nopo̱e̱hueʼ e̱ʼi̱kada huaboaʼda onʼbaaʼpakuyate. Konig Diosen Noki̱re̱ga̱ oʼmanopo̱e̱a̱ʼuyate nogen nogen aratbuten huaʼate onʼbaaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ken fiestate Jerusalényo̱ huakkaʼda judío aratbut o̱ʼnuyate. Diosen eʼkaʼtaʼ onʼpakpo nog jak nog jakyaʼ nogbayaʼ nogbayaʼ onʼbatiakeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Kenda eʼbapokpaʼ ʼuttaʼda oʼadyaknigtaj huakkaʼada onʼpe̱e̱depo onʼkupopakonpo, nogen nogen huaʼa enʼbaaʼpakte ayaʼda nogda nogda keʼnenda huaʼa onʼmape̱e̱po diga̱ʼda onʼmamepukeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Onʼmamepuʼkepo, huayahuaya onʼbatiaʼpakpo: —‍¿Oroʼtaj monaʼnig menpaʼ Galilea hua̱e̱ʼeri ayaʼda ya̱ʼne? ");
INSERT INTO amrNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Oroʼen huaʼate menpapiʼ ya̱ʼnanopo̱e̱? ");
INSERT INTO amrNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Partia huadarieri o̱ʼe̱y. Media huadarieri o̱ʼe̱y. Elam aratbut o̱ʼe̱y. Mesopotamia huadarieri o̱ʼe̱y. Judea hua̱e̱ʼeri, Capadocia hua̱e̱ʼeri, Ponto hua̱e̱ʼeri, Asia hua̱e̱ʼeri, ");
INSERT INTO amrNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia kenpaʼti Panfilia hua̱e̱ʼeri, Egipto hua̱e̱ʼeri, Africabayo idbodte Cirene hua̱e̱ʼeri, kenpaʼti esoeri Roma hua̱e̱ʼeri o̱ʼe̱y. Esoeri Romayaʼ judío aratbut o̱ʼnepo kenpaʼti nog aratbut e̱ʼe̱a̱da judío aratbut Diostaj onʼkikaʼnig konigti onʼkikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Kenpaʼti Creta hua̱e̱ʼeri, Arabia hua̱e̱ʼeri o̱ʼe̱y. Konig huaboroʼda Dios o̱ʼe̱. Konig huakkaʼda oʼkaʼ Dios eʼbatiaʼpakte oroʼen huaʼate onaʼnok oʼpe̱e̱y. —‍Huayahuaya onʼbatiaʼpakeʼuy. ");
INSERT INTO amrNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ayaʼada diga̱ʼda onʼmamepukeʼpo huayahuaya onʼbatiaʼpakpo: —‍¿In kate ya̱ʼe̱t? —‍Onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Nogomey onʼtierikpo, —‍Oʼnokkuda̱ʼpo, ondaʼ. —‍Onʼmanaʼnigʼa ken. ");
INSERT INTO amrNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Kenokaʼ Pedro nog once Jesúsen huamataʼmoneriere oʼbopo ʼuttaʼda oʼmanaʼpo: —‍Dakaʼ doʼtaj menʼpe̱e̱ʼ, Judea huadarieri kenpaʼti Jerusalén huakkaʼ jak hua̱e̱ʼeri. ");
INSERT INTO amrNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Inomey oʼnokkuda̱ʼ namaʼda moʼnopo̱e̱ne. Okkuda̱hueʼ o̱ʼne. Sikyoedda o̱ʼe̱. Oroʼ sikyoedda okkuda̱hueʼ o̱ʼi̱kaʼne. ");
INSERT INTO amrNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Opudomey oʼmape̱e̱denig kenpaʼti oroʼtaj oʼbatiahuaydenig aʼnenda Diosenbaʼ huamanbatiaʼpakeri Joela oaʼuyate: ");
INSERT INTO amrNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Nogok Diosen keneʼhua̱ya̱ʼ huameʼnoete doʼhued Noki̱re̱g huakkaʼ aratbuttaj ijbayoʼkeapoy. Opuden huasiʼpo, huabokerekere ettoneʼere Diosen huaʼa onʼmanmadikikaʼapo. Huaboaʼ eʼbayorokte Diostaj onʼtiahuayapo. Huatoneʼtaj eʼbayorokte ijmanopo̱e̱a̱ʼapoy. ");
INSERT INTO amrNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Kenokaʼ doʼhued huakikaʼeri huabokerekere ettoneʼeretaj doʼhued Noki̱re̱g ijbayoʼkeapoy. Doʼhued Noki̱re̱ga̱ oʼmanopoʼto̱e̱nok doʼhuedyoʼda onʼmanikaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Kurudyo̱ konig tiahuayhued moeonhuahuikaʼuy ijkaʼapoy. Huadariyo nogda nogda ijkaʼaponok aratbut onʼtiahuaypo teyda Dios o̱ʼe̱ nopo̱e̱ʼdik o̱ʼneapo. Konig eʼbarak mimi onʼtiahuayapo. Konig huakkaʼ jak eʼmey onʼtiahuayapo. E̱ʼsi̱hui̱ʼtoneʼ onʼtiahuayapo. ");
INSERT INTO amrNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Nogok Cristo oroʼen Huairi tiakhued e̱e̱ʼted huakkaʼ onʼmeʼpukapo. Niokpo yataʼsikonapet. Taʼtehueʼ ya̱ʼe̱a̱pet. Puug konig mimi bedda o̱ʼe̱a̱po. Cristo Huairi eʼtiakte Dios huaboroʼda o̱ʼe̱ yanʼnopo̱e̱a̱pet. ʼUruaʼnanada huameʼnoe ya̱ʼe̱a̱pet. ");
INSERT INTO amrNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Doʼtaj meknopo̱e̱po, “Betiokaʼ, meʼnopoʼyareaʼ, doʼtaj meʼnoeanhuahuikaʼ, Huairi.” Ayaʼada kenda menaʼnok kennayo bueyhueʼ o̱ʼneonhuahuikaʼapo. Kenda Joela Diosenbaʼ huamanaʼeri oʼmadoyaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Onteʼti menʼpe̱e̱ʼ. Opuda̱ Israel aratbut doʼtaj menʼpe̱e̱ʼ. Jesús Nazaret huakkaʼ jak hua̱e̱ʼeri o̱ʼe̱meʼte. Konig huabokerekada kahueʼdik e̱e̱ʼtada ʼuruda Jesúsa oʼkikameʼte. Konig kahued o̱ʼneonhuahuikaʼuy Jesúsanayo Diosa oʼtiahuapokpo oʼkameʼte. Opuda̱da moʼnopo̱e̱ne Jesúsa oʼkaʼuynig. ");
INSERT INTO amrNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Jesústaj boʼtohuaʼpo cruzte kadarakeʼpo dakhueaʼ huakaʼeritaj boʼyokmeʼnigʼa. Kenda o̱gkaʼapo Diosa aʼnennanada oʼnopo̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Huabueytaj eʼto̱e̱o̱nig e̱e̱ʼtada Diosnayo teynananada o̱ʼe̱po oʼnoyhuada̱meʼte. Jesústaj huabueyada ka̱e̱ʼpo kenpaʼda to̱e̱hueʼdik o̱ʼe̱meʼ. ");
INSERT INTO amrNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Kenpaʼti aʼnenda Jesústaj Davida in konig oʼtiaʼpakpo: Doʼhued Huairi Dios ontaj ijtiahuayikay. Doʼere o̱ʼi̱kaʼne. Doʼtaj oʼtihuapokikaʼnok meʼpukhueʼ i̱ji̱kay. ");
INSERT INTO amrNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kenaʼpo huakkaʼda ijdurugpakpo, kentaj durugda ijbatadiʼkikay. Konige̱po kenpaʼti eʼbueydeʼte kubarakyaʼ onteʼti ijnoyhuada̱poy dakaʼ yoknopo̱e̱y. ");
INSERT INTO amrNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Konige̱po on Dios doʼtaj kenpaʼda huabueyaʼda ka̱e̱ʼpo enhueʼ o̱ʼe̱a̱pone. Ke̱yo̱ eʼbuey noki̱re̱g o̱ʼnikaʼ doʼtaj enhueʼ o̱ʼe̱a̱pone. Kenpaʼti doʼtaj o̱ʼnen huadiʼtaj so̱ʼparahueʼdik o̱ʼi̱a̱ʼapone. ");
INSERT INTO amrNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","O̱ʼnen kakadhuahuikeʼpo iʼpakpo aʼnoeanhuahuikayaʼpo doʼtaj oʼnopo̱e̱a̱ʼnede. Kenpaʼti doere i̱ʼi̱kaʼpo doʼtaj huakkaʼ oʼdurugpakaʼikaʼapone. Kenda Davida aʼnennada Jesústaj oʼtiaʼpakpo, oʼmadoyaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Oroʼen adhueaʼpaneʼkudak David aʼnenda eʼbueyte onʼkubarakkaʼuyate. Oy huameʼnoete kubarak oʼtiahuayʼikay oroʼ. Buttida ijjay, egomey. ");
INSERT INTO amrNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","31","David Diosen huamanbatiaʼpakeri o̱ʼe̱po kenpaʼti “O̱ʼnen adhueaʼ huayayo nogok Cristo o̱ʼe̱a̱po. Cristo Israel Huairi o̱ʼe̱a̱po.” Diosa buttida onaʼuyate. David kenda oʼnopo̱e̱ʼuyate. Konige̱po kenda Diosa oʼkaʼapo oʼnopo̱e̱po, oʼbatiaʼpakuyate. Cristo eʼbueydeʼte Diosa kenpaʼda enhueʼ o̱ʼe̱a̱po, kenpaʼti so̱ʼparahueʼ o̱ʼe̱a̱po. Kenpaʼ David oʼbatiaʼpakuyatenig konigda o̱ʼe̱meʼ. ");
INSERT INTO amrNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","David Jesústaj oʼbatiaʼpakuyate. Diosa Jesústaj ayaʼada oʼtiahuaymey oʼnoyhuada̱meʼte, kenda oroʼ opudtaj huaaʼdik o̱ʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Kurudyo̱ Jesúsere aʼhuadikayaʼpo Diosa Jesústaj oʼbehuikameʼte. Kente e̱e̱ʼte ayaʼada Jesústaj nigpe̱i̱kaʼdik o̱ʼneapo. Jesústaj Diosen Noki̱re̱g oʼyokuyate. Konig Diosa oaʼuyatenigda. Kenda huaboaʼda opuda̱ boʼtiahuaynig kenpaʼti moʼpe̱e̱nig. Diosen Noki̱re̱ga̱ oʼkaʼ. Jesúsa Diosen Noki̱re̱g moʼnigtaʼmonaʼdene. ");
INSERT INTO amrNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","David huataʼ tiaʼpakhueʼ o̱ʼe̱po kurudyo̱ huahueʼ o̱ʼu̱yate. Jesús Diosyo oʼhuaʼapo Davida oaʼuyate. “Diosen huadaʼkopen yahuad, Huairi. Takaʼtaj gana yo̱gkaʼdeaponok. Nogok ayaʼda o̱ʼnen takaa moʼnigpe̱i̱kaʼapone.” Doʼhued Huairitaj Diosa oaʼuy. Davida oaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Opud Israelen adhueaʼ huayayo Jesústaj hue̱ypa cruzte moʼbetaʼpo boʼarakmeʼnigʼa Diosanayo Huairikon Cristotaj oʼyahueameʼte. Kenda dakaʼ yanʼnopo̱i̱katiʼ. —‍Pedroa ʼuttaʼda oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Pedrotaj Israelen adhueaʼ huayayoa onʼmape̱e̱depo, kenda namaʼda oʼkamey onʼnopo̱e̱depo, paiʼda onʼmanopoʼu̱y. Paiʼnanada o̱ʼnepo, —‍¿Kate kikaʼdik o̱ʼe̱, egʼ? —‍Jesúsen doce huamataʼmoneritaj Pedrotakon onʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","—‍Diostaj yanʼnopoʼkoreaʼ. Diostaj huaboaʼda yanʼnigpe̱i̱kaʼ. Jesucristoa oʼpaknok bautiza ya̱gʼkatiʼ. Jesústaj moknopo̱e̱nok Diosa o̱ʼnen dakhueaʼ eʼkaʼ moʼnopoʼtihuekeʼapone, bokkahueaʼapone. Kenpaʼti Diosen Noki̱re̱ga̱ moʼnopoʼto̱e̱a̱pone. ");
INSERT INTO amrNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Doʼhued Noki̱re̱g ijbayokapoy Diosa oaʼuyatepo opudtaj boʼyokapone, opuden huasiʼpotaj, kenpaʼti bidteda hua̱e̱ʼeritaʼ kenpaʼti nogbayo nogbayo hua̱e̱ʼeritaʼ Diosa oʼpakpo, keʼnen Noki̱re̱g oʼbayokeʼapo. —‍Pedroa oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kenda oʼmanaʼdepo nogi̱ti nogdakon oʼmanaʼpo oʼmaboroaypo: —‍In aratbut oyda o̱ʼnikaʼnigʼa oknopo̱e̱hueʼ hua̱e̱ʼeri o̱ʼnepo dakhueaʼ o̱gkikaʼ. Opudnayo konigti kikahueʼada yanʼnopoʼkoreaʼ. —‍Pedroa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ken, huakkaʼda Pedrotaj onʼpe̱e̱depo, oʼnoknopo̱e̱po, bautiza o̱gkaʼuyate. Kenmeʼnoeda tres mil Jesústaj huaboaʼda oʼnoknopo̱e̱po, Jesúsa huataʼmoneriere onʼnigpe̱i̱kaʼuyate. Diostaj onʼnigpe̱i̱kaʼpo onʼbatadiʼkikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Jesúsen doce huamataʼmoneria onʼmanmadikikaʼnok kenomey oʼnoknopo̱e̱depo ayaʼda huameʼnoeda dakaʼ onʼmape̱i̱kaʼuyate. Ayaʼda ontatayoʼ onʼbapikaʼuyate. Jesús eʼbueyʼuy okkahuehueʼ o̱ʼnepo, onʼbapikaʼuyate. Kenpaʼti Diostaj ontatayoʼ onʼtionaʼpakikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Jesúsen doce huamataʼmoneria kenda tiahuayhued o̱ʼneonhuahuikaʼ onʼkikaʼpo, Diosa oʼbatihuapoknok huakkaʼtada onʼbayareaʼikaʼ. Ayaʼ aratbutada onʼmamepuʼkeonhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ayaʼda kenomey Jesucristotaj oʼnoknopo̱e̱po, onteteyoʼ o̱ʼnikaʼpo, huayahuaya onʼbatihuapokikaʼuyate. Kenomey katepiʼ onʼto̱e̱po nogtaj nogtaj onʼbayokikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Kenomey katepiʼ onʼto̱e̱po, taʼba jakpiʼ nogda nogda onʼbahuayʼeaʼuyate. Paiʼda aratbuttaj huakupe onʼbayokeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ayaʼda huameʼnoe Diosen jakyo onʼkupopakikaʼuyate. Kenomeyen jakyaʼ huayahuaya onʼbatobapikaʼpo, durugda onʼbapeʼpo huanopoʼada huadak oʼnoknopo̱e̱po onʼbapikaʼpo, ");
INSERT INTO amrNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Diostaj durugda o̱ʼnepo, dakiti oʼnonaʼikaʼuyate. Jesústaj huanigpe̱i̱kaʼeria huadak o̱ʼne. Ayaʼada huakkaʼ jak hua̱e̱ʼeria onʼbahuaaʼikaʼuyate. Ayaʼmeʼnoe Diosa oʼbatihuapokikaʼnok Jesucristotaj nogomeya̱ huaboaʼda oʼnoknopo̱e̱po, huanigpe̱i̱kaʼeriere oʼnoknopo̱e̱ʼi̱kaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Nogok tereaʼ eʼhuadte Pedroere Juanere Diosen jakyo onʼhuaʼuyate. Kente niokpo eʼhuadte aratbut onʼtionaʼpakikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Diosen jak kurute huabokerek eʼketpak o̱ʼi̱kaʼpo, kenda eʼsiʼpoe̱ʼ eʼketpak o̱ʼi̱kaʼuyate. Diosen akbogpete ayaʼmeʼnoeda eʼketpaktaj onʼtotiakikaʼuyate. Ken akbogpeta oʼdikkaʼikaʼ “ʼUruda.” Aratbut Diosen jakyo enʼkuddeʼte “Huakupe beyok,” kaeʼpo onʼtotiakikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Diosen jakyo huakuddikte eneʼte Pedro Juaneretaj, “Huakupe menʼyok,” oʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pedro Juanere eʼketpaktaj onʼtiahuaypo, —‍Oroʼtaj boʼtiahuaiʼ. —‍Oʼnonaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Kenda eaʼte oʼbatiahuaypo, oʼmanige̱ʼuy. Huakupepiʼ menʼyokapone oʼnopo̱e̱po. ");
INSERT INTO amrNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","—‍Huakupebayoʼ i̱jje̱y oropiʼ to̱e̱hueʼ i̱jje̱y kenda kaʼdik o̱ʼe̱po oʼkaʼapoy. Jesucristo Nazaret hua̱e̱ʼeria oʼpaknok yaupakonpo yaboʼ, yahuaeʼ. —‍Pedroa eʼketpaktaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Huadaʼkopen oʼtaʼkoypo oʼboaʼ. Eʼbodeʼte huaʼi huabopiere oʼyareudpo, oʼteypakanʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Kenokaʼ oʼkudajpo, oʼboatoʼpo oʼhuaʼe. Diosen jakyo Juan Pedroere oʼkudpo. Oʼhuaʼepo, oʼkudajpo, “Dakiti, Dios, huadakda megkaʼne,” onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Oʼhuaʼepo Diostaj dakiti eaʼte ayaʼada onʼtiahuayʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Kentaj onʼnoki̱e̱ʼpo. ʼUruda akbogpete “Huakupe beyok” oʼmanaʼikaʼnok, kentaj onʼnoki̱e̱ʼpo onʼmepuʼkepo, “Kenpihuay Diosa ʼuruaʼda oʼkaʼ,” o̱daʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Diosen jak kurute oʼdikkaʼuyate Salomón. Kente Juantaj Pedrotaere eʼdakkaʼa oʼbataʼbodhuaʼpo ekhuaʼtaʼ pakhueʼ oʼmaeʼuy. Ayaʼ aratbuta eʼdakkaʼtaj onʼtipe̱e̱po onʼmepuʼkepo onʼbaketonyakpo Diosen jak kurute onʼkupopakuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Huakkaʼda kenomeytaj enʼkupopakte Pedroa oʼbatiahuaydepo, oʼmanmadikaʼpo: —‍¿Menaʼpo eʼyareaʼtaj moʼmamepuʼke? ¿Menapo oroʼtaj boʼtiahuayaʼ? Oroʼtaj teyda o̱ʼnepo onʼyareaʼ namaʼda moʼnopo̱e̱ne. Oroʼ huadakda o̱ʼnepo eʼketpaktaj onʼyareaʼ namaʼda moʼnopo̱e̱ne, Israel aratbut. ");
INSERT INTO amrNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Oroʼen Diostaj Abraham oʼnigpe̱i̱kaʼuyate. Isaac Jacobere onʼnigpe̱i̱kaʼuyate. Ken Diosa keʼnensiʼpotaj ʼuruaʼnanada oʼkaʼpo Jesústaj huaboroʼ huairia oʼyahueameʼte. Opudanayo kadarakeʼpo Pilatotaj boʼyokmeʼte. Pilato eʼo̱ro̱kaʼtaʼ eʼpaktada oʼpudomeya̱ “Kejeʼ” monameʼne. ");
INSERT INTO amrNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jesús Diosenyoʼda, oʼpakpo, ʼuruaʼda Diosenyoʼda oʼkadhuahuikameʼte. Kenpaʼda huadaknanada o̱ʼi̱kameʼte. “Jesústaj pakhueʼ o̱ʼe̱y. Dakhueaʼ huakkaʼeritaj ya̱o̱ro̱kaʼ.” Opudomey Pilatotaj monameʼne. ");
INSERT INTO amrNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ken konig Diosen huamanoeanhuahuikaʼeritaj opuda̱ boʼarakmeʼnigʼa. Huabueyada e̱e̱ʼtada Diosa oʼnoyhuada̱meʼte oroʼada oʼtiahuaymeʼpo oay. ");
INSERT INTO amrNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Opuda̱ eʼketpaktaj boʼtiahuayikameʼne dakaʼ moki̱e̱ʼikaʼne. Jesústaj oroʼ oknopo̱e̱nok oʼyareadde. Kenda boʼtiahuayne. ");
INSERT INTO amrNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Opuden huairiereada Jesústaj nopo̱e̱hueʼ moʼe̱po namaʼda boʼarakmeʼne, ijnopo̱e̱y egomey. ");
INSERT INTO amrNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Cristo paiʼda nopoʼe̱dik o̱ʼe̱a̱po Diosen huamanbatiaʼpakeria oʼdaʼuyatenig kenda Diosa o̱gkameʼ. Jesús paiʼda oʼnopoʼe̱po oʼbueymeʼ. ");
INSERT INTO amrNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Dakhueaʼ eʼkaʼ yanʼbatik yanʼnopoʼkoreaʼ Diostaj yanoknopo̱e̱ʼ. Eʼnopoʼkoreaʼnayo Diosa dakhueaʼ eʼkaʼ oʼnopoʼtihuekeʼapo kenpaʼti Diosa moʼmanopoʼdurugpakaʼapone. Kenpaʼti moʼmanopoʼteypakaʼapone. ");
INSERT INTO amrNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Kenpaʼti Dios onteʼti opudte Jesústaj moʼnigtaʼmonaʼapone. Keʼna Cristo o̱ʼe̱po opuded huairi o̱ʼe̱. ");
INSERT INTO amrNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Oy Jesús kurudyo̱ e̱ʼdik o̱ʼi̱kaʼ. Nogok Diosa ayaʼda huaboaʼda eʼkadeʼte onteʼti Jesús oʼtiakapo. Kenda Diosa oaʼuy. Keʼnen huadak huamanbatiaʼpakeria kenpaʼ oʼdaʼuyate: ");
INSERT INTO amrNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","“Dios Huairia huamanbatiaʼpakeritaj oʼtaʼmonaʼapo. Opudtaj moʼnigtaʼmonaʼapone. Keʼna onaratbutyoʼ judío o̱ʼe̱a̱po. Konigti doʼtaj meʼnigtaʼmonaʼuyne opudtaj moʼnigtaʼmonaʼapone. Ayaʼda moʼnikaʼapetnig yanʼnigpe̱i̱katiʼ. ");
INSERT INTO amrNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ayaʼada Diosbaʼ huamanbatiaʼpakeritaj pe̱e̱hueʼ e̱e̱ʼnayo Diosa kenpaʼda oʼmaenapo. Diosen aratbut ehueʼdik o̱ʼneapo.” Kenpaʼ oaʼuyate Moisésa. ");
INSERT INTO amrNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Kenpaʼ oy oroʼ oʼbatiahuayde ayaʼda Diosenbaʼ huamanbatiaʼpakeri onʼbatiaʼpakuyate. Samuela Diosen huamanbatiaʼpakeria huakkuruda kenpaʼ oaʼuyate. Kenpaʼti nogok nogok nogda nogda Diosenbaʼ huamanbatiaʼpakeri kenpaʼ onʼdaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Opudomey Diosen huamanbatiaʼpakerien adhueaʼ huayayo moʼe̱po ayaʼ aratbuttaj huadaknada moʼmanigkaʼapone. Kenda Diosen huamanbatiaʼpakeriomeya̱ oʼmanbatiaʼpakuyate. “O̱ʼnen adhueaʼ huayayoa ayaʼ aratbuttaj ʼuruaʼnanada yaʼmanigkaʼapet.” Diosa Abrahamtaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Kenaʼpo Diosa Huasiʼpo oʼnoyhuada̱ʼdepo opudtakon dakaʼ ka̱gkikeʼpo oʼtaʼmonaʼuyate. Opuda̱ ayaʼada dakhueaʼ eʼkaʼ kanʼmanopoʼkoreʼpo moʼnigtaʼmonaʼuyate. —‍Pedroa kenda oʼmananhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pedro Juanere huakkaʼ aratbut eʼmananhuaʼte judío sacerdotea onʼhuatiakuyate. Sacerdote Diosen jak huato̱e̱ʼeri sorotataj huairi onʼhuatiakuyate. Saduceoa aratbut onʼbueypo noyhuadhueʼdik o̱ʼne onʼbatiaʼpakikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Pedro Juanere aratbuttaj onʼmanmadikaʼnok kenpaʼti Jesús eʼbueyada oʼnoyhuadmeʼtenok aratbut eʼbueyada noyhuaddik o̱ʼneapo. Kenpaʼ onʼmanmadikaʼnok Saduceomeya̱ onʼbahuadiayʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Onʼmahuadiaypo Juantaj Pedrotaere onʼbatohuaʼpo, oʼsikaponok sorotataen huabakuda̱ʼ jakyo onʼbakuda̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Huakkaʼada Pedrotaj Juantaere onʼmape̱e̱depo Huairi Jesústaj oʼnoknopo̱e̱ʼuy. Kenokaʼ cinco mil huabokerek Jesústaj oʼnoknopo̱e̱ʼuy. Kenokaʼ cinco mil huabokerek Jesústaj oʼnoknopo̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Emedeʼte judío aratbuten huairi o̱gkupopakpo, huatoneʼ huairi, Apagbaʼ huamadoyaʼeriere Jerusalényo̱ o̱gkupopakuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Kenpaʼti sacerdote huairi Anás o̱ʼu̱yate. Kenpaʼti Anás Caifás huabetere, Juan, kenpaʼti Alejandroere o̱gkupopakuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","“Pedrotaj Juantaere yanʼtotiak. Nopote yanʼmaboaʼ.” Onʼmanaʼuyate. Onʼmaboadepo, —‍¿Monig bayareaʼdik moʼe̱? ¿Beʼed huaʼate bokaʼ? Yadaʼ. —‍Onʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","12","—‍Huabokerek eʼketpaktaj huadakda oʼkaʼmey. ¿Beʼa yaʼyareameʼ? ¿Beʼed huaʼate oʼkay? Kenda eʼnopo̱e̱taʼ eʼpaknayo dakaʼ yanʼpe̱e̱ʼ. Yanʼnopo̱e̱ʼ. Ayaʼ Israel aratbut kanoknopo̱e̱ʼ. Jesús Nazareteri oʼpaknok oʼyarudmeʼ kenbokerek eʼyaredeʼ huadakso̱ʼda i̱yo̱da oʼbo. Keʼna eʼketpak o̱ʼi̱kaʼuyate. Jesucristotaj hue̱ypa cruzte opuda̱ boʼarakmeʼne. Diosa eʼbueydeʼte oʼnoyhuada̱meʼte. Jesús konig jak huakaʼ huid o̱ʼe̱. Huidte jak onhuad. Opud Jesústaj nigpe̱e̱hueʼ moʼi̱kameʼpo jak huakaʼ huid moʼenmeʼte. Jesúste ayaʼ jakda oʼbahuaʼ. Aratbutanayo oroen dakhueaʼ eʼkaʼ nopoʼtihuekehueʼdik moʼi̱kaʼne. Aratbutanayo onteʼti Diosere noeanhuahuikahueʼdik moʼi̱kaʼne. Jesucristoayoʼda nopoʼtihuekeʼdik moʼe̱ne. Jesucristoayoʼda onteʼti Diosere noeanhuahuikaʼdik moʼe̱ne. Huakkaʼ jak huairitaj kenpaʼti huatoneʼ huairitaj ijjay. —‍Diosen Noki̱re̱ga̱ Pedrotaj oʼnopo̱e̱a̱ʼnok Pedroa oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pedro Juanere meʼpukhueʼ o̱ʼnepo ʼuruaʼda onʼmanaʼnok huakkaʼ huairi onʼpe̱e̱po, onʼbatiahuaypo, “Kenpihuay, ¿Menpapiʼ ʼuruaʼda yanahuaʼ? Berobaʼ nopo̱e̱hueʼ kenpaʼti huairi konig ehueʼ o̱ʼne.” Oʼnopo̱e̱po, Jesúsere o̱ʼnikaʼuy onʼnoki̱e̱ʼuy. ");
INSERT INTO amrNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Kenpaʼti eʼketpak onʼyaremeʼte kenteda Pedro Juanere oʼbataʼbonok, onʼtiahuaypo, “dakhueaʼ o̱gkameʼte,” ahueʼdik o̱ʼnuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Pedrotaj Juantaere onʼmaoro̱kandepo huairi huaboaʼda huayahuaya onʼbatiaʼpakpo, ");
INSERT INTO amrNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","—‍Inomey huabokerektaj kate kaʼdik o̱ʼe̱ oroʼ. Konig tiahuayhued o̱ʼneonhuahuikaʼ o̱gkaʼdemeʼte ayaʼda Jerusalén hua̱e̱ʼeri onʼnopo̱e̱. Kahueʼ o̱ʼnemeʼ, ahueʼdik o̱ʼe̱y oroʼ. ");
INSERT INTO amrNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kenda eʼketpaktaj onkaʼdemeʼte huabada nogtaj nogtaj batiaʼpakhueʼdik kaʼneʼ i̱ghuaʼda manaʼdik moʼne. “Jesucristotaj batiaʼpakhueʼ yaneʼ.” Juantaj Pedrotaere moʼnonaʼnok. —‍Huairia huayahuaya onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Onteʼti Pedrotaj Juantaere enʼbatotiakdeʼte, “Jesústaj batiaʼpakhueʼ yaneʼ. Kenpaʼti Jesúsen huaʼa manmadikahueʼ yaneʼ.” Onʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","—‍¿Kate yaʼpak Diosa? ¿Beʼtaj nigpe̱e̱ʼdik opudtaj Diostapiʼ? ¿Menpaʼ moʼnopo̱e̱ opud? ");
INSERT INTO amrNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kenda oʼtiahuayikamey. Kenda oroʼ oʼpe̱i̱kamey manikaʼdik o̱ʼe̱y. —‍Pedro Juanerea huairitaj onʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Onteʼti yanʼbatik i̱ghuaʼda huairia onʼmanaʼdepo, Juantaj Pedrotaere onʼmaoro̱kaʼuyate. Aratbuttaj onʼmakmeʼpukpo mabitbithueʼada onʼmaoro̱kaʼuyate. Eʼketpaktaj oʼyareaʼnok “Dios huadakda o̱ʼe̱.” Ayaʼada aratbuta onaʼnok. ");
INSERT INTO amrNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ken eʼketpaktaj Diosa oʼyareameʼ cuarenta huabayok yareahued oʼnoeonhuahuikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kenokaʼ Pedrotaj Juantaere eʼnoro̱kaʼdete Pedro Juanere Jesúsen huanigpe̱i̱kaʼeritaj onʼbahuahuaʼuyate. Sacerdoteere huatoneʼ huairiere ayaʼ onʼmanaʼnig onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Ayaʼada huanigpe̱i̱kaʼeria onʼpe̱e̱depo, onteteyoʼ Diostaj onʼtionaʼpakpo: —‍Dios Huairi i̱ʼe̱ne. Kurud iʼkaʼuy. Oteʼ huadari iʼkaʼuy. Hua̱hue̱ huaboroʼ e̱ʼpo̱g iʼkaʼuy. Kenpaʼti ayaʼda kurudyo̱ hua̱e̱ʼeri iʼkaʼuy. Ayaʼda oteʼyo hua̱e̱ʼeri ayaʼda huadariyo, hua̱hue̱yo̱, e̱ʼpo̱gyo̱ hua̱e̱ʼeri iʼkaʼuyate. Oroʼen Huairi Dios ayaʼda ikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","O̱ʼnenbaʼte Davida o̱ʼnen huanabaʼa oaʼuy. O̱ʼnen Noki̱re̱g, Dios Noki̱re̱g Davidtaj oʼnopo̱e̱a̱ʼnok, oʼmadoyaʼuyate: ¿Nog aratbut menaʼpo Diostaj yanʼhuadiayikaʼpo yanʼmaboyikaʼ. Menaʼpo Israel aratbut namaʼda huadik yanʼnopo̱i̱kaʼ? ");
INSERT INTO amrNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Nogbayaʼ nogbayaʼ huairi onʼtiakpo onʼkupopakpo, nogda nogda jak huairiere onʼkupopakpo, Dios Huairitaj kenpaʼti Diosen Cristotaj dakhueaʼda eʼmagkaʼtaʼ onʼeretpakpo. Kenda Davida oʼmadoyaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","In huakkaʼ jakyo konig Davida oaʼuyatenigda Jesucristotaj aʼmagkayaʼpo o̱gkupopakmeʼ. O̱ʼnen huadakda huasiʼpo Jesús, kentaj Cristo iʼyahueaʼpo iʼtaʼmonaʼuyate. Herodes Huairi, Poncio Pilato Huairiere, nog aratbut, Israel aratbut Jesústaj aʼarakyaʼpo o̱gkupopakmeʼ. ");
INSERT INTO amrNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Kenda o̱gkameʼnig kenda o̱gkaʼapo aʼnenda iʼnopo̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Oy huiyokda orotaj monaʼdene, yamape̱e̱ʼ, Dios Huairi. Oroʼ o̱ʼnen huanabaʼtaj boʼtihuapok, moʼnopoʼteypakaʼ, o̱ʼnen huadak huaʼa meʼpukhueʼada oʼmanaʼapoy. ");
INSERT INTO amrNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Jesús o̱ʼnen Huasiʼpoa ʼuruaʼda kabayereʼ, nogda nogda ʼuruaʼda kakeʼpo aratbut onʼtiahuaypo teyda o̱ʼe̱ Dios oʼnoknopo̱e̱a̱po, oroʼen Huairi Dios. —‍Huanigpe̱i̱kaʼeria onʼtionaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Enʼtionaʼpakdeʼte ken jakyo e̱gkupopakte o̱ʼi̱yi̱gʼuy. Ayaʼtada Diosen Noki̱re̱ga̱ oʼmanopoʼto̱e̱ʼuyate. Ayaʼada meʼpukhueʼ o̱ʼnepo Diosen huadak huaʼa onʼmanikaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ayaʼda Jesústaj huaknopo̱e̱ʼeri konig katepiʼ nogtiada aratbut konigti onʼpakikaʼuy, konigti onʼnopo̱i̱kaʼuy, konigti o̱gkikaʼuy. “In doʼhued meʼta̱e̱ne.” Ahueʼ o̱ʼnepo katepiʼ enta̱e̱ʼ ayedda onʼta̱i̱kaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jesúsen huataʼmoneria meʼpukhueʼada Huairi Jesús eʼbueyada oʼnoyhuadmeʼte onʼbatiaʼpakikaʼuyate. Diosa oʼbatihuapoknok nogi̱ti oʼnoknopo̱e̱po huayahuaya nogi̱tinada diʼ onʼmaikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Paiʼda huaknopo̱e̱ʼeri ehueʼ o̱ʼnuy taʼba huato̱e̱ʼeria onʼbahuayaʼpo noga̱ jak onʼbahuayaʼpo huakupe onʼtotiakpo ");
INSERT INTO amrNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Jesúsen doce huamataʼmoneritaj huakupe onʼbayoknok huakupe onʼbaedepo paiʼda hua̱e̱ʼeritaj onʼbayokeʼikaʼuynok nogtiapiʼ paiʼda ehueʼ o̱ʼnikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kenpaʼ José oʼkaʼuyate. Josétaj nogdikkon oʼdikkaʼ Bernabé. (Bernabé eʼbatihuapok huadik o̱ʼe̱.) José levita aratbut o̱ʼu̱y. Chipre hua̱gkutaʼmejyo hua̱e̱ʼeri o̱ʼu̱y. ");
INSERT INTO amrNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Taʼba oʼbahuayaʼuy. Jesúsen doce huamataʼmoneritaj huakupe oʼtohuaʼpo, oʼbayokuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Nog huabokereknayo o̱ʼu̱yate. Keʼnendik Ananías o̱ʼu̱y. Keʼnen hua̱to̱e̱ oʼta̱u̱yate huadik Safira. Hua̱to̱e̱ere taʼba onʼbahuayaʼpo, ");
INSERT INTO amrNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","hua̱to̱e̱ereada onʼnopo̱e̱po sueʼda huakupe nogte oʼi̱re̱gapo oʼtiokhueypo “In ayaʼ huakupe o̱ʼe̱,” da oaʼpo Jesúsen doce huamataʼmoneritaj oʼbayokuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","—‍¿Totoʼtaj menaʼpo iʼnigpe̱e̱po Diosen Noki̱re̱gtaj da inaʼne? Taʼba eʼbahuayaʼ huakupe iʼposakaʼpo iʼi̱re̱gapo iʼtiokhueyne. ");
INSERT INTO amrNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Bahuayahued o̱ʼnen taʼba iʼta̱i̱kameʼ. Eʼbahuayaʼde huakupe o̱ʼnen o̱ʼe̱. ¿Menaʼpo kenpaʼ namaʼda iʼnopo̱e̱? “Ken ayaʼda huakupe ijyoki,” namaʼda iaʼ. Huabokerektaj da onahueʼ i̱ʼe̱ne. Diostaj da inaʼne, Ananías. —‍Pedroa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananías Pedrotaj kenda oʼpeeondepo oʼbueyonpo o̱ʼhue̱ʼkuy. Ayaʼada kenda huaboaʼda onʼnokotdepo huakkaʼda onʼmameʼpukeʼuy. ");
INSERT INTO amrNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ken huabo onʼhuatiakpo asuk oʼnogkutaʼdokaʼpo, onʼtohuaʼpo, onʼkubarakkaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Bapaʼ hora eʼpokdeʼte keʼnen hua̱to̱e̱ oʼkudonʼuy. Hua̱to̱e̱ bekbueydene nopo̱e̱hueʼ o̱ʼe̱po oʼkudonʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","—‍¿Taʼbataj meniga̱ʼ huakupete moʼbahuayaʼ? ¿O̱ʼnen hua̱to̱e̱ oaʼde menpaʼ kennigaʼteda huakupete moʼbahuayaʼ? —‍Pedroa onaʼnok, —‍E̱e̱ʼ, konig doʼhued hua̱to̱e̱ menetnig kenda oroʼtaj boʼyokne. —‍Ettoneʼa̱ onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","—‍Hua̱to̱e̱ere Diosen Noki̱re̱gtaj da menaʼpo onpapayoʼ moʼnopo̱e̱po, monaʼ. Yape̱e̱ʼ. Kenomey o̱ʼnen hua̱to̱e̱ʼtaj onʼkubarakkadpo akbogpete oʼnokye̱ʼdepo ontakon onʼtohuaʼapo. —‍Pedroa onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","I̱da ettoneʼ Pedroen huaʼite oʼbueyonpo o̱ʼhue̱ʼkuy. Huabo onʼkudpo eʼbueytaj onʼtiahuaypo, onʼbueytohuaʼpo, hua̱to̱e̱ere ontatayoʼ onʼkubarakkaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Kenda ayaʼ Jesústaj huaknopo̱e̱ʼeria onʼpe̱e̱depo, huakkaʼ onʼmididuyate. Ayaʼada aratbut onʼpe̱e̱depo, huakkaʼda onʼmameʼpukuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ken Jesúsen huataʼmoneritaj Diosa oʼtihuapokpo oʼbateypakaʼnok ʼuruaʼda o̱gkikaʼuyate. Konig tiahuayhued o̱ʼneonhuahuikaʼuyate o̱gkikaʼuyate. Kenpaʼti dakhueʼtaj onʼbayareaʼikaʼuyate. Ayaʼ huaknopo̱e̱ʼeri Diosen jak kurute Salomónte o̱gkupopakikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Nogomeynayo oknopo̱e̱hueʼ hua̱e̱ʼeria onʼmeʼpukpo huaknopo̱e̱ʼeriere kupopakhueʼ e̱ʼe̱a̱da Jesúsen huanigpe̱i̱kaʼeri huadakda o̱ʼne onʼnopo̱i̱kaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Huakkaʼ huabokerek huakkaʼ ettoneʼere Jesús Huairitaj huaboaʼda oʼnoknopo̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ken, ʼuruaʼda Jesúsen huataʼmoneria o̱gkikaʼnok dagte eʼdigpak eʼketpak nogda nogda onʼbatohuaʼpo, asukte onʼbahueda̱ʼuy. Pedro huapokdikte keʼnen huanoki̱re̱ga̱ eʼtipokte yanʼyareapet. ");
INSERT INTO amrNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Huakkaʼ jakyaʼ Jerusalén huakkaʼ jak ibodte Jerusalényo̱ onʼbatiakpo, nogda nogda huakkaʼ jakyaʼ onʼbatiakpo, aratbut eʼdigpaktaj onʼtotiakpo, aratbut totoʼa huamanopoʼto̱e̱ʼeritaj onʼtotiakuyate. Diosa ayaʼtada onʼbayareaʼuyate. Kenpaʼti totoʼtaj onʼmaenʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Kenokaʼ sacerdote huairi kenpaʼti saduceo huaknopo̱e̱ʼeri ayaʼada digda onʼbahuahuaypo, Jesúsen doce huamataʼmoneritaj digda onʼbahuahuaypo, ");
INSERT INTO amrNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","huabakuda̱ʼ jakyo onʼbakuda̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Sikyonayo Diosen huamataʼmoneria huabakuda̱ʼ akbogpe okhuikepo oʼmaoro̱kaʼpo Jesúsen huamataʼmoneritaj oʼmaoro̱kaʼpo. ");
INSERT INTO amrNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—‍Yanʼhuatiʼ. Diosen jakyo yanʼhuatiʼ. A̱yo̱da yanʼbopo, huaboda huadikkon huanoeanhuahuikaʼ yanʼmanmadikikaʼ. —‍Diosen huataʼmoneria oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Onʼpe̱e̱depo Diosen jakyo onʼkudpo, sikyoedda emeʼte onʼkudpo, huaboaʼda onʼmanmadikaʼuyate. E̱gkupopakyaʼ onʼmanmadikaʼuyate. Nog jakyo kenteda huairi o̱gkupopakikaʼ nogomeyere sacerdote huairi onʼtiakdepo, ayaʼda Israel huairitaj kenpaʼti Israel huatoneʼ huairitaj o̱gkupopakdepo, huabakuda̱ʼ jakyaʼ Jesúsen huamataʼmoneritaj kanʼbatotiakeʼpo onʼmataʼmonaʼuynigʼa, ");
INSERT INTO amrNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","sorotataj onhuaʼnigʼa, Jesúsen huamataʼmoneri huabakuda̱ʼ jakyo bahuahuayhueʼ o̱ʼnedepo, onʼtiakuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","—‍Huabakuda̱ʼ jakyo oʼtiakdepo huaki̱re̱gya̱ʼ eʼtiokkasaʼ e̱ʼi̱kaʼ. Jak huato̱e̱ʼeria sorotataj onʼtibopo, akbogpe onʼtiokaʼ. Akbogpe ekhuikeʼte ehueʼ o̱ʼne jakyo. Jesúsen huamataʼmoneri ehueʼda o̱ʼne. —‍Sorotataj onʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Diosen jak sorotataj huairi kenpaʼti sacerdote huairi sorotatataj onʼpe̱e̱depo, “monig ya̱ʼe̱a̱pet” onʼbatiaʼpakuy. ");
INSERT INTO amrNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Kenda enʼbatiaʼpakte nogtida huabokerek oʼtiakatoʼpo, —‍Kenomeytaj huabakuda̱ʼ jakyo moʼbakuda̱meʼne Diosen jakyo onʼbopo, onteʼti aratbuttaj onʼmanmadikaʼ. —‍Ken huabokereka oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Sorotataj huairi kenda oʼpe̱e̱depo keʼnen sorotataj oʼbatohuaʼ. Jesúsen huamataʼmoneritaj oʼbatotiakuyate. Dakaʼda onʼbatotiakpo dakhueʼda e̱gkaʼnayo aratbut huida̱ menpaʼjiput, onʼnopo̱e̱po. ");
INSERT INTO amrNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Israel huairi e̱gkupopakyo onʼbahuatotiakpo, eretnopoyo onʼmaboaʼuyate. Sacerdote huairi oʼmanaʼnok: ");
INSERT INTO amrNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—‍Jesúsen huaʼa manmadikahueʼ yaneʼ. I̱ghuaʼda oameʼnigʼa nigpe̱e̱hueʼ moʼe̱po, huabada Jerusalén hua̱e̱ʼeritaj moʼmanmadikaʼdemeʼne kenpaʼti oroʼtaj Jesústaj boʼarakmeʼ moʼbatiaʼpakmeʼ. —‍Sacerdote huairia onʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","—‍Diostayoʼda nigpe̱i̱kaʼdik o̱ʼe̱y oroʼ. Huabokereka nogda edaʼ manigpe̱e̱hueʼdik o̱ʼe̱y. ");
INSERT INTO amrNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Opuda̱ Jesústaj hue̱ypa cruzte moʼbetaʼpo boʼarakmeʼnigʼa, oroʼen huapaneʼkudaken Diosa eʼbueytada oʼnoyhuada̱meʼte. ");
INSERT INTO amrNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Kenpaʼti Diosa kurudyo̱ oʼtobehuikpo huadaʼkopen oʼhuadameʼte. Jesústaj huaboroʼ huairi oʼyahueameʼte. Jesús huaboroʼ huairi o̱ʼe̱nok ayaʼada kentayoʼda nigpe̱i̱kaʼdik o̱ʼne. Jesúsa Diosere onteteyoʼ huamanopoʼyareaʼeri o̱ʼe̱po huabokereken dakhueaʼ eʼkaʼ nopoʼtihuekeʼdik o̱ʼi̱kaʼapo. Konige̱po Israel aratbut dakhueaʼ eʼkaʼ nopoʼkoreaʼdik ya̱ʼnepo kenpaʼti Diosa nopoʼtihuekeʼdik yaʼmaeapet. ");
INSERT INTO amrNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ayaʼda Jesúsa eʼkaʼte oʼtiahuayikamey. Buttida oʼay Diosen Noki̱re̱ga̱ kenpaʼti Jesústaj buttida oʼhuaaʼ. Keʼna Jesústaj onʼnigpe̱i̱kaʼ Diosa keʼnen Noki̱re̱g oʼbayokeʼ. —‍Nog Jesúsen huamataʼmoneri Pedroerea onʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Huakkaʼ huairi onʼkupopakpo Pedromeytaj onʼpe̱e̱depo, huakkaʼda onʼhuadiaypo, eʼbaraktaʼ onʼpaknigʼa. ");
INSERT INTO amrNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Nogtida fariseo huairi nog huairiomeyere o̱ʼu̱y. Keʼnen huadik o̱ʼu̱y Gamaliel. Gamaliel Moisés eʼmanaʼbaʼ huamanmadikaʼeri o̱ʼu̱yate. Ken huadakda o̱ʼe̱ ayaʼada aratbut onʼtinopo̱e̱ʼuy. Keʼna oʼbodpo jak kurute Jesúsen huamataʼmoneritaj oʼmaoro̱kaʼuyate. Judío huairitaj oʼmanaʼpo: ");
INSERT INTO amrNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","—‍Dakaʼ yanʼnopo̱e̱po, Jesúsen huamataʼmoneritaj kate oʼnogkaʼapet, Israel aratbut, oʼnonaʼne. ");
INSERT INTO amrNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Aʼnenda Teudas o̱ʼe̱po “Huaboroʼ huairi i̱jje̱y,” namaʼda oʼmanaʼnok huakkaʼada kentaj onʼnigpe̱i̱kameʼ. Cuatrocientosa onʼnigpe̱i̱kameʼnigʼa nogok Teudastaj oʼdarakdemeʼnok ayaʼda keʼnen huanigpe̱i̱kaʼeri onʼbahuameʼte. Kenpaʼda onʼbatikuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Nogok gobierno huairi aratbuttaj eʼmadikaʼte Judas Galileayo hua̱e̱ʼeri o̱ʼu̱yate. Huakkaʼada onʼnigpe̱i̱kaʼ kenpaʼti Judastaj oʼdarakdenok ayaʼ keʼnen huanigpe̱i̱kaʼeri onʼbahuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Kenaʼpo in huabokerektaj magkahueʼ yaneʼ. Yanʼmaoro̱kaʼ. Huabokerekada onʼpakpo e̱gkaʼnayo ehueʼdik o̱ʼneapo. Batikdik o̱ʼneapo. ");
INSERT INTO amrNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Diosen enʼmanaʼnayo mabatikahueʼdik moʼe̱ne. Kenpaʼti opudomeya̱ Diostaj dakhueʼda mogkaʼapet. —‍Gamaliela judío huairitaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Kentaj dakaʼda onʼnigpe̱e̱depo jakyo onteʼti Jesúsen doce huamataʼmoneritaj onʼbatokuddepo, onʼmabitbitdepo, onaʼti Jesúsa oʼkikaʼnig tiaʼpakhueʼ yaneʼ i̱ghuaʼda onʼmanaʼdepo, onʼmaoro̱kaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Jesúsen doce huataʼmoneri judío huairi e̱gkupopakyaʼ durugteda onʼbakhuaʼpo “oroʼ Jesústaj oʼhuaaʼnok huairia moʼbitbitne Diosa oʼpaknok.” Durugda onʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Diosen jakyo aratbuten jakyokon Jesucristotaj onʼbatiaʼpakonhuahuikaʼpo, onʼmanmadikaʼonhuahuikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Kenokaʼ Jesústaj huaknopo̱e̱ʼeri oʼnitakpo griego huaknopo̱e̱ʼeria hebreo huaknopo̱e̱ʼeritaj onʼbahuaaʼpo “Aypo eʼbayokete oroʼomeyen ayhua sueʼda aypo onʼbaeʼikaʼ hebreo ayhuanayo huakkaʼda onʼbaeʼikaʼ,” griego huaknopo̱e̱ʼeria onʼbahuaaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kenaʼpo doce Jesúsen huataʼmoneria ayaʼ huaknopo̱e̱ʼeritaj onʼkupopakaʼpo, —‍Apagbaʼ oroʼ manmadikikaʼdik o̱ʼe̱po aypo ayhuataj kiriga̱yo̱ʼ bayokikahueʼdik o̱ʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Siete huamaʼbuy huaknopo̱e̱ʼeritaj yanʼbaktieʼeaʼ. Kenomey huadak huakaʼeri o̱ʼne ayaʼada onʼmatinopo̱e̱ kenpaʼti kenomeytaj Diosen Noki̱re̱ga̱ ʼuruaʼda oʼmanopoʼto̱i̱kaʼ kenpaʼti kenomey huadakda Diosen huaʼa onʼnopo̱e̱, kenomeytaj yanʼbaktieʼeaʼ ayhuataj aypo kanʼbayokikeʼpo. ");
INSERT INTO amrNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ayhua aypo kanʼbayokikeʼpo, opuda̱ sietetaj eʼbaktieʼeaʼnayo oroataj Diostaj oʼtionaʼpakikaʼapoy kenpaʼti Diosbaʼ oʼmanmadikikaʼapoy. —‍Jesúsen huamataʼmoneria onʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Kenda Jesúsen huamataʼmoneria onʼmanaʼnok ayaʼda onʼpakpo Estebantaj onʼdepo, Esteban Diosen Noki̱re̱g huakkaʼda oʼnopoʼto̱e̱ʼuy kenpaʼti Diostaj huakkaʼda oknopo̱e̱ʼuyate. Kenpaʼti Felipetaj onʼdeʼuyate. Prócorotaj Nicanortaj, Timóntaj, Parmenastaj Nicolástaj onʼbaeʼuyate. Nicolás nogbayaʼ Antioquíayaʼ oʼtiakuyate. Aʼnenda judíoen eʼmanmadikaʼ oʼnigpe̱i̱kaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Aʼti Jesúsen huamataʼmoneriyo onʼbatotiaknok, onʼbakutibataʼtepo dakaʼ Diosa kabatihuapokeʼpo onʼtionaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Nogi̱ti huakkaʼda Jesús Huairitaj onʼmanmadikaʼuyate. Huaknopo̱e̱ʼeri Jerusalényo̱ huakkaʼda onʼnitakuyate. Huakkaʼda sacerdote kenpaʼti Jesústaj oʼnoknopo̱e̱po, onʼnigpe̱i̱kaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Konig Diosayoʼda kaʼdik kakeʼpo Diosa Estebantaj ʼuruaʼda oʼnopoʼto̱e̱po oʼteypakaʼnok Esteban teyda oʼkikaʼuyate. Kenda aratbut tiahuayhued onʼneonhuahuikaʼ oʼkikaʼuyate. Aratbut enʼtiahuayte oʼbayarikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Esteban namaʼda iʼmanmadikikaʼne sueʼada huabokerek onʼboypo oʼnonaʼuy. Judíoen hua̱i̱takeʼ jakyaʼ, oʼdikkaʼuy Esclavos Libertadosyo onʼbahuatiakdepo, Cirenebayo hua̱e̱ʼeri Alejandríabayo hua̱e̱ʼeri Ciliciabayo hua̱e̱ʼeri kenpaʼti Asiabayo hua̱e̱ʼeri Estebantaj onʼboyʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Diosen Noki̱re̱ga̱ Estebantaj oʼnopoʼto̱e̱nok huakkaʼda oʼnopo̱e̱ʼpo ʼuruaʼda oʼmanbatiaʼpaknok nogbayo hua̱e̱ʼeria onteʼti katiaʼ onahueʼdik o̱ʼne. ");
INSERT INTO amrNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Konige̱po da huaaʼeretaj da kadepo huakupe onʼbayokpo, “Moiséskudaktaj dakhueʼda oʼbatiaʼpak Estebana. Diostaj dakhueʼada oʼhuaaʼmeʼ. Oʼpe̱e̱mey.” Kenpaʼ yanhuaaʼ da huaaʼeritaj judío esoeria onʼmanaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ken konig namaʼda Estebantaj da huaaʼeria onʼmahui̱a̱ʼnok, huabada Estebantaj onʼhuadiaypo judío huatoneʼere Diosbaʼ huamanmadikaʼeriere onʼhuadiaypo, Estebantaj onʼhuahuaʼpo, onʼto̱e̱po, judío huairi e̱gkupopakyo onʼtohuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Estebantaj da kanʼhuaaʼeʼpo da huaaʼeritaj onʼbatotiak. Namaʼda onʼmanaʼpo: —‍Esteban Diosen jaktaj dakhueʼda oʼhuaaʼikaʼ. Diosbaʼ Moiséskudak eʼmadoyaʼtaj dakhueʼda oʼhuaaʼikaʼ. ");
INSERT INTO amrNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Diosen jak oʼsakapo Jesús Nazareteria. Keʼna eaʼte oʼpe̱e̱mey. Kenpaʼti konig Moisésa oʼmanmadikadhuahuikaʼuynig oroʼ oʼkikaʼnig kenda Jesúsa kenpaʼda oʼmaenapo. Moisésen eʼmanmadikaʼ oʼenapo. Kenpaʼ Esteban eʼbatiaʼpakte oroʼ oʼpe̱e̱mey. —‍Da huaaʼeria onʼhuaaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ayaʼda huairi e̱gkupopakyaʼ Estebantaj onʼtiahuaypo, Diosen huataʼmonerienkokonig onʼtiahuayʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","—‍¿Buttida menpaʼ yadaʼ? —‍Sacerdote huairia Estebantaj onaʼuynok, ");
INSERT INTO amrNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","—‍Menʼpe̱e̱ʼ, egʼ, menʼpe̱e̱ʼ, huairitoneʼ. Oroʼen Dios teyda oʼkikaʼ. Diosa oroʼen onaratbutyoʼ adhueaʼpaneʼkudak Abrahamtaj oʼbatiaʼpakuyate. Abraham Haránbayo huahued Mesopotamiabayo e̱ʼi̱kaʼte Diosa Abrahamtaj oʼbatiaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","“O̱ʼnen huadaribayaʼ o̱ʼnen huabetyaʼ yabakhuaʼ nogbayo yahuatiʼ ijtohuaʼapopo huadari oʼtiahuayaʼapone.” Diosa Abrahamtaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ken, Caldea aratbutenbayaʼ Abrahamomey onʼbakhuaʼuy. Harán huakkaʼ jakyo Abraham o̱ʼi̱kaʼuyate. Nogok keʼnen apag eʼbueydeʼte inbayo oroʼ o̱ʼi̱kay Diosa Abrahamtaj oʼtotiakuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","I̱yo̱ konig keʼnen huadari ka̱ta̱e̱ʼpo yokhued o̱ʼu̱y Diosa. Taʼbasiʼpopiʼ yokhued o̱ʼe̱po, “Huadari ka̱ta̱e̱ʼpo ijyokapoy. On eʼbueyte o̱ʼnen huasiʼpotaj o̱ʼnen huayayotaj huayayoen huayayotaj huadari ijyokapoy.” Diosa eaʼte Abraham keʼnen huasiʼpo to̱e̱hued o̱ʼe̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","“O̱ʼnen adhueaʼ huayayo nogaratbutenbayo onʼmaeonhuahuikaʼapo. Nogaratbuta dakhueʼda onʼmagkadhuahuikaʼapet. Nog aratbuten huanabaʼ ya̱ʼneapet.” Dios Abrahamtaj onaʼuyate. Cuatrocientos huabayok dakhueʼda onʼmagkadhuahuikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","“Kenomeytakon castiga ijmagkaʼapoy. Castiga e̱gkadeʼte onteʼti onʼmaoro̱kaʼapo. I̱yo̱ onʼbatiakdepo doʼhued o̱gkikaʼapo.” Diosa Abrahamtaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Kenda onaʼnig eknopo̱e̱ʼnayo huabokereksiʼdaktaj yabaktegaʼikaʼ. Abrahamtaj onaʼuynok Abrahamensiʼpotaj Isaac eʼsiʼpoe̱ʼde ocho huameʼnoe e̱e̱ʼte osiʼdakoktegʼuyate. Isaac kenpaʼti keʼnensiʼpo Jacobtaj osiʼdakoktegʼuyate. Jacoben doce huasiʼpotaj oʼbasiʼdakoktega̱ʼuyate, Kenomey oroʼen Israel aratbut adhueaʼpaneʼ o̱ʼnuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Kenomey Jacobensiʼpo oroʼen adhueaʼpaneʼ o̱ʼnepo kenomeyen huamaʼbuy huasuedtaj onʼhuadiayʼuyate. Josétaj onʼhuadiaypo Egiptobayo kanʼtohueʼpo huabahuayaeritaj huakupete onʼbayokuyate. A̱yo̱ huanabaʼ e̱e̱ʼte huadakda Diosa Joséere o̱ʼi̱kaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","José paiʼda eʼnopoʼe̱te Diosa oʼtihuapokpo o̱ʼo̱ro̱kaʼuyate. Diosa dakaʼ oʼtihuapokikaʼnok kenpaʼti ʼuruda oʼnopo̱e̱a̱ʼnok Faraón Egipto huairia Josétaj oʼpakpo Egiptobayo huairi oʼyahueaʼuy. Kenpaʼti keʼnen jak huairi oʼyahueaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Nogoknada Egiptobayoere Canaánbayoere taʼba tibohueʼ o̱ʼe̱nok aypobayoʼ o̱ʼnepo huabada diga̱ʼda onʼkusitokuyate. Oroʼen adhueaʼpaneʼkon aypobayoʼ o̱ʼnedepo. ");
INSERT INTO amrNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Egiptoyo aypo onʼmato̱e̱ Jacob oʼpe̱e̱depo oroʼen adhueaʼpaneʼ o̱ʼe̱po huasiʼpotaj oʼmataʼmonaʼuyate. Ken huakkuruda aypote onʼhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Nogok onteʼti aypote Egiptoyo onʼhuaʼuyate. José huamaʼbuytaj oʼmaki̱e̱ʼpo, “Do opuden huamaʼbuy i̱jje̱y.” Oʼmanaʼuyate. Kenokaʼ Faraón Egipto huairi Joséen onaratbutyoʼ huaboaʼda oʼmaki̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Jacob keʼnen apagtaj kenpaʼti ayaʼda keʼnen onaratbutyoʼ, “Yanʼtiak,” Joséa oʼmanaʼuy. Keʼnen onaratbutyoʼ setenta y cinco aratbut o̱ʼnuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ken Egiptoyo Jacobomey onʼhuaʼuyate. Ke̱yo̱ keʼnaere keʼnensiʼpoere onʼmatoneʼpakdepo onʼmabueyʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Nogoknanada eʼbueyen huaaytaj adtenanada onʼtotiakonhuahuaʼdepo Siquemyo̱ onʼbaaybukuyate. Ken kubarakkog aʼnennada Abrahama Hamorensiʼpotaj huakupete oʼbakeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Huakkaʼ huabayok o̱ʼneonhuahuikaʼpo Jacobkudaken aratbut huakkaʼda oʼnitakpo, huakkaʼnada o̱ʼneʼuyate. Eʼnitakdeʼte Abrahamtaj Diosa onaʼuyatenigda aʼti oʼkaʼapo. ");
INSERT INTO amrNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Kenokaʼ nog huabokerek Egipto huairi o̱ʼe̱ʼuyate. Huaboaʼda huairi o̱ʼe̱po Josékudak ʼuruda oʼkikaʼuyate nopo̱e̱hueʼ o̱ʼu̱y. ");
INSERT INTO amrNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Oroʼen onaratbutkudaktaj namaʼ oʼmagkaʼpo, dakhueʼda oʼmagkaʼdepo, kenomeyen huabokereksiʼpo yo̱bed kabueyeʼpo enʼdik moʼe̱ne. Ken konig oʼmanaʼuyate. Dakhueaʼda oʼmagkaʼuyate huabo huairia. ");
INSERT INTO amrNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Kenokaʼ Moisés oʼsiʼpoe̱ʼuyate. ʼUrusiʼpoda Diosa oʼtiahuayʼuyate. Apagere inagere huasiʼpo onʼto̱i̱kaʼpo, bapaʼ puug onʼto̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Kenokaʼ enʼdik e̱e̱ʼte onʼeandepo Faraón huairien hua̱yo̱bua oʼhuahuaydepo, oʼtohuaʼpo keʼnen jakyo oʼtoeonhuahuikaʼuyate. Konig keʼnen huasiʼponig oʼtoeonhuahuikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ayaʼ Egipto aratbuten eʼnopo̱e̱ʼ Moiséstaj onʼmanmadikaʼuyate. Moisés ʼuruaʼda oʼmanbatiaʼpakikaʼpo kenpaʼti ʼuruaʼda oʼkikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Moisés cuarenta huabayok oʼto̱e̱depo keʼnen onaratbutyoʼ Israel aratbuttaj eʼbatiahuaytaʼ oʼpakpo, oʼbahuahuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Egiptoeri huabokereka Israel huabokerektaj dakhueaʼ e̱gkaʼte Moisésa oʼtiahuaypo Egiptoeritaj oʼtihuapokpo oʼarakuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Egiptobayaʼ kaʼbatohueʼpo Diosa oʼtaʼmonaʼuy. Doʼhued onaratbutyoʼ yanʼnopo̱e̱a̱pet. Moisésa namaʼda oʼnopo̱e̱nigʼa keʼnen onaratbutyoʼ nopo̱e̱hueʼ o̱ʼnuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Emeʼte bottaʼ keʼnen onaratbutyoʼ oʼtiahuaypo, enʼbatuktukte oʼbatiahuayʼuy. Moisésa eʼmanoeyaʼtaʼ oʼpakpo, “Opud huamaʼbuy moʼe̱ne, moʼbatuktukapete,” oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Keʼna nog huabokerektaj dakhueaʼda o̱gkaʼpo Moiséstakon ondajpo, “¿Oroʼen huairi kenpaʼti oroʼen huamanoeya̱ʼeri e̱e̱ʼtaj beʼa menaʼuy bokapeteaʼ huamananhuaʼ? ");
INSERT INTO amrNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Konig ʼikken Egiptoeritaj iʼarakmeʼte doʼtakon eʼaraktaʼ iʼpak?” Moiséstaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Kenda Moisés oʼpe̱e̱depo, nogbayo oʼhuaʼuyate. Nog aratbutenbayo Madiánbayo esoeri o̱ʼeonhuahuikaʼuyate. Ke̱ya̱ʼ botsiʼpoaʼ oʼsiʼpopakuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Nogoknanada cuarenta huabayok eʼpokdeʼte aratbut ehueʼ e̱ʼi̱kaʼyo Moisés o̱ʼeonhuahuikaʼdepo oteʼ Sinaí ʼibodte Moisés Diosen huataʼmoneritaj oʼtiahuayʼuyate. Mahua̱i̱ʼhuia oʼbakpakuyate. Mahua̱i̱ʼhui eʼbakpakyo Diosen huataʼmoneritaj oʼtiahuayʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moisés oʼtiahuaypo, oʼmepukeʼuy. ʼUruda aʼtiahuayaʼpo adte oʼhuahuaʼpo Huairi Diostaj oʼpe̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Dios i̱jje̱y. O̱ʼnen adhueaʼpaneʼen Dios i̱jje̱y. Abrahamkudak doʼtaj menigpe̱i̱kaʼuyne Isaackudak Jacobkudakere menʼnigpe̱i̱kaʼuyne.” Diosa oaʼnok Moisés oʼmeʼpukonpo huakpisiʼpotaj tiahuayhueʼdik o̱ʼu̱yate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“I̱yo̱da do Dios i̱jje̱y. In doʼeddari o̱ʼe̱nok o̱ʼnen huaʼiot yakirokaʼ. ");
INSERT INTO amrNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Doʼhued aratbut Egiptoyo o̱ʼnepo, huadigda dakhueaʼ onʼmagkaʼnok Egipto aratbuta onʼmagkaʼnok eʼbahuikonhuahuaʼte ijmape̱e̱y. Aʼbaktohuaʼyaʼpo ijhuaraki. Yatiakpo Egiptobayo oʼtaʼmonapone.” Dios Huairia Moiséstaj onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Moiséstaʼ pakhueʼ o̱ʼnepo “¿Oroʼen huairi kenpaʼti oroʼen huamanoeya̱ʼeri e̱e̱ʼtaj beʼa menaʼuy bokapeteaʼ huamananhuaʼ?” Onaʼuyate. Moisés kenomeyen huairi hua̱e̱ʼ Diosanayo oʼtaʼmonaʼuy. Moisésa kaʼbakbatohueʼpo oʼtaʼmonaʼuy. Diosen huataʼmoneria huakpisiʼpo eʼbakpakyaʼ oʼtaʼmonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Egiptoyo kenpaʼti e̱ʼpo̱gte oʼdikkikaʼ e̱ʼpo̱g huabed konig Diosyoʼda kaʼdik o̱ʼe̱nig konig tiahuayhued o̱ʼneonhuahuikaʼnig Moisésa oʼkikaʼuyate. Oʼkikaʼdepo Egiptoyaʼ oroʼen aratbut oʼbakbatohuaʼuyate. Aratbut ehueʼ e̱ʼi̱kaʼyo cuarenta huabayok oʼmatounhuahuikaʼuyate. Ke̱ya̱ʼkon konig Diosyoʼda kaʼdik o̱ʼe̱nig oʼkikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Konig Diosa beʼtaʼmonaʼuyne konigti opud e̱ʼhua̱i̱kayaʼ nogtatida Diosa oʼtaʼmonaʼapo. Kentaj yanʼnigpe̱i̱katiʼ.” Kenda Moisésa Israel aratbuttaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Aratbut ehueʼ e̱ʼi̱kaʼyo Israel aratbutere Moisés o̱ʼi̱kaʼuyate. Oteʼ Sinaíte Diosen huataʼmoneria kentaj oʼbatiaʼpakonhuahuaʼnig, kenda Moisésa oʼnigpe̱e̱depo oroʼen adhueaʼpaneʼtakon oʼmanaʼuyate. Diosen huanounhuahuikaʼ huaʼa oroʼen adhueaʼpaneʼtaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Oroʼen adhueaʼpaneʼkudaknayo Moiséstaj eʼnigpe̱e̱taʼ pakhueʼ e̱ʼneʼtada Egiptoyo eʼkumejtaʼ onʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Moisés oteʼte o̱ʼunhuahuikaʼnok Moisésen huamaʼbuy Aaróntaj oʼnonaʼpo: “Moisés meyon ya̱ʼe̱ nopo̱e̱hueʼ o̱ʼe̱y oroʼ. Moisésa moʼbatotiakmeʼne Egiptobayaʼ. Oroʼtaj siro eʼketkaʼ dios monigkaʼ, huakkuru oroʼtaj boʼtohueʼpo.” Aaróntaj oʼnonaʼuy oroʼen adhueaʼpaneʼ. ");
INSERT INTO amrNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kenokaʼ oro vacapaʼ diostaj eʼketkaʼ o̱gkaʼuyate. O̱gkaʼdepo kenomeyen ʼuhua konig oveja onʼnigbatiarakaʼpo oro eʼketkaʼ vacataj onʼbayokuyate. ʼUruda oʼkay namaʼda onʼnopo̱e̱po onʼdurugpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Siokpo oroʼen dios moʼta̱e̱ʼ onʼdaʼnok kenpaʼti siokpotaj oʼderetpaknok Diosa oʼbakhuaʼuyate. Diosen huamanbatiaʼpakeria oʼmadoyaʼuyatenig boʼtiahuayikaʼ: Aʼnenda aratbut ehueʼ e̱ʼi̱kaʼyo bohuaʼepo, cuarenta huabayok moʼunhuahuikaʼuy. Huakkaʼ ʼuhua moʼbatiarakaʼpo moʼbakpakikaʼuynigʼa. ¿Beʼtaj monigkiket? Kenda doʼtaj kahueʼ moʼi̱kaʼne. ");
INSERT INTO amrNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Konig nog aratbuten eʼketkaʼ dios bokaʼuyate. Keʼnendik Moloc. Kentaj aʼtionaʼpakikayaʼpo bokaʼuyate. Kenpaʼti nog siokpo eʼketkaʼ dios bokaʼuyate. Keʼnendik Renfán. Kentaj aʼtionaʼpakikayaʼpo bokaʼuyate. Eʼketkaʼ dios Molocen jaksiʼpoyo opuda̱ boʼtohuaʼikaʼuynigʼa. Kenpaʼti siokpo eʼketkaʼ dios Renfántaj opuda̱ boʼtohuaʼikaʼuynigʼa. Oroʼen dios i̱ʼe̱ne oʼeretpaki monaʼikaʼpo kenaʼpo Diostaj kurudyo̱ nigpe̱e̱hueʼda namaʼda boʼkikaʼuyate. Konige̱po opuden jakyaʼ Babilonia huakkaʼ jakyo adteda opudtaj ijmataʼmonaʼapoy. Opudtaj Babiloniayo onʼbatohuaʼapo. Opud Israel aratbuttaj Apagbaʼ huamanbatiaʼpakeria kenpaʼ oʼmadoyaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Aratbut ehueʼ e̱ʼi̱kaʼyo oroʼen adhueaʼpaneʼ o̱ʼneonhuahuikaʼpo huasiʼdak jak Diostaj onʼnigto̱e̱ʼikaʼuyate. Diosa huidte oʼmanigmadoyaʼuyate. Jakyo ken huid onʼtounhuahuikaʼuyate. Konig Diosa oʼnopo̱e̱a̱ʼuynig Moisésa jak oʼkaʼuyate. Huasiʼdak jakyaʼ sacerdote Diostaj onʼtionaʼpakikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Nogok Moisés eʼbueydeʼte adhueaʼpaneʼen huabatohuaʼ huairi Josué o̱ʼu̱yate. Diosen huasiʼdak jak onʼtohuaʼpo, kenda huadari Diosa oʼbayoknok onʼbahuaʼuyate. Diosa nog aratbutaj Israel aratbut ehueʼtaj oʼmaenʼuyate. Indariyaʼ onʼhuaʼpo huasiʼdak jak onʼtohuaeʼikaʼuyate. Nogok nogok onʼtoeonhuahuaʼuyate. David huairi hua̱e̱o̱k huasidak jak onʼto̱e̱ʼikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","David Diostaj oʼnigpe̱i̱kaʼnok Davidtaj oʼpakuy Diosa. Huaboroʼ jak Diostaj eʼnigkataʼ oʼpakuy. David Jacoben Diostaj eʼnigkataʼ eʼpakada, ");
INSERT INTO amrNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","kahueʼ o̱ʼu̱yate. Davidensiʼpoa Salomón Diosen jak oʼkaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Dios Huairi kurudyo̱ hua̱e̱ʼeri huabokerekada huaboroʼ jak eʼkaʼyo, i̱kahueʼ o̱ʼi̱kaʼ. Kenpaʼ Diosbaʼ huamanbatiaʼpakeria oʼmadoyaʼuyate: ");
INSERT INTO amrNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Kurudyo̱ huairien huahuadte ijhuadikay. Huadariyo doʼhued huaʼibo o̱ʼe̱. Jak doʼtaj nigkahueʼdik moʼe̱ne. Jakyo tayhueʼ i̱ji̱kay. ");
INSERT INTO amrNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ayaʼda ijkaʼuynig. ¿Menpaʼ moʼnopo̱e̱? Kenpaʼ oaʼuyate. Diosbaʼte oʼmadoyaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Diosen eʼkaʼtaʼ pakhueʼ moʼi̱kaʼ opudomey. Konig aratbut Diostaj oknopo̱e̱hueʼda o̱ʼnikaʼ konig opuden huanopoʼ moʼi̱kaʼne. Diosenbaʼtaj pe̱e̱hueʼdik moʼi̱kaʼne. Diosen Noki̱re̱gtaj eʼpe̱e̱taʼ pakhueʼ moʼi̱kaʼne. Konig opuden adhueaʼpaneʼ o̱ʼnuyate konigti opuda̱ moʼi̱kaʼne. ");
INSERT INTO amrNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Opuden adhueaʼpaneʼ ayaʼtada Diosenbaʼ huamanbatiaʼpakeritaj dakhueaʼda onʼmagkikaʼuyate. “Diosen ʼurunanada oʼtiakde,” enʼmanaʼtada huamanbatiaʼpakeritaj onʼbarakikaʼuyate. Oykon Diosen ʼurunanada huairi eʼtiakdetada boʼkupopakpo da boʼhuaaʼpo boʼtitohuaʼpo boʼarakmeʼne opuda̱. ");
INSERT INTO amrNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Diosen huataʼmoneria Diosbaʼ moʼbaʼyokuyatenigʼa Diosenbaʼ opuda̱ moʼbaeʼdeʼuynigʼa nigpe̱e̱hueʼ moʼi̱kaʼne. —‍Estebana judío huairiomeytaj oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Kenomey judío huairi Estebantaj onʼpe̱e̱depo huakkaʼnada onʼhuadiaypo Estebantaj diga̱ʼda onʼhuadiayʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Estebannayo Diosen Noki̱re̱g oʼnopoʼto̱e̱nok kurudyo̱ oʼtiahuaypo Dios ʼurueyda oʼtiahuaypo Jesús Diosere onteteyoʼ eʼbote oʼtiahuayʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","—‍Menʼpe̱e̱ʼ, kurud ekhuikeʼ o̱ʼe̱. Ken Huabokerek Diosa oʼtaʼmonaʼuyate, Diosen Huasiʼpo o̱ʼe̱po Diosere eʼbote ijtiahuay. —‍Estebana oʼmanaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","ʼUttaʼda onʼbasagkeaʼudpo onʼpeokbaʼtepo, onʼhuakupopakonpo, ");
INSERT INTO amrNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","huakkaʼ jakyaʼ Estebantaj onʼto̱o̱ro̱kdepo, onʼpaʼeaʼuyate. Huida̱ huapaʼeaʼeria huaok Saulotaj meʼta̱to̱e̱po onʼbayokaʼuyate. Saulo toneʼbokerek o̱ʼu̱y. ");
INSERT INTO amrNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Enʼpaʼeaʼte Estebana oʼtionaʼpakpo: —‍Doʼhued noki̱re̱gtaj beeʼ, Huairi Jesús. —‍Onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Oʼikudataʼtepo, —‍I̱ne dakhueaʼ meʼnogkaʼnigtaj yabakkahueaʼ, Huairi. —‍ʼUttaʼda oʼtionaʼpakdepo oʼbueyonʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulokon kanʼarakeʼ oʼnopo̱e̱ʼuyate. Kenmeʼnoeteda huaboaʼda Jesúsen huanigpe̱i̱kaʼeritaj diga̱ʼda onʼmagkadhuahuaʼuyate Jerusalényo̱. Huanigpe̱i̱kaʼeri nogyon nogyon onʼmamonʼuyate. Judea huadaribayo kenpaʼti Samaria huadaribayo onʼmamonʼuyate. Jesúsen doce huamataʼmoneriyoʼda mamonhueʼ o̱ʼneʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Diostaj huapakeria Estebantaj onʼkubarakkaʼuyate. Huakkaʼda onʼbahuikpo onʼkubarakkaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Jesúsen huanigpe̱i̱kaʼeritaj dakhueaʼda oʼmagkaʼpo Sauloa, nog jakyo nog jakyo oʼkudpo, huabokerek ettoneʼere huanigpe̱i̱kaʼeritaj oʼbatohuaʼikaʼuyate. Huabakuda̱ʼ jakyo oʼbakuda̱ʼikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Jerusalénya̱ʼ onʼbakmonpo, nogyon nogyon onʼbahuaʼpo, Jesucristoen huadak huaʼa onʼmanbatiaʼpakonhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Samaria huakkaʼ jakyo Felipe oʼhuaʼuyate. Konig Cristo oʼkaʼonhuahuaʼuyate kenda oʼmanbatiaʼpakpo, ");
INSERT INTO amrNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","aratbut o̱gkupopakpo dakaʼda onʼmapeeonhuaʼuyate. Konig aratbut tiahuayhued o̱ʼneonhuahuikaʼ Felipe oʼkaʼnok onʼtiahuayʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Huakkaʼtada totoʼa aratbuttaj eʼmanopoʼto̱e̱tada Felipe totoʼtaj oʼmaoro̱kaʼpo oʼmanopoʼyareaʼnok ʼuttaʼda onʼbaokoyonpo onʼmamonʼuyate. Eʼketpaktaj kenpaʼti huakkettaj oʼbayareaʼonhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ke̱ya̱ʼ huakkaʼ jakyo huakkaʼda onʼdurugpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kenda huakkaʼ jakte huabokerek o̱ʼu̱yate. Oʼdikkaʼ Simón. Aʼnenda tidig oʼkikaʼnok ayaʼada onʼtomepukeʼikaʼuyate Samaria hua̱e̱ʼeri. “Huairi i̱jje̱y,” namaʼda oaʼnok, ");
INSERT INTO amrNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ayaʼada huanabaʼ huairierea onʼpe̱e̱po, —‍Kenbokerek konigti Dios, teyda o̱ʼe̱. —‍Ayaʼada onʼbatiaʼpakikaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Simón tidig o̱gkikaʼpo namaʼda oʼmanopo̱e̱a̱ʼnok kentaj onʼnigpeunhuahuikaʼuynigʼa. ");
INSERT INTO amrNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ayaʼda Dios Huairitaj eʼpe̱e̱deʼte kenpaʼti Jesucristoen huadak huaʼa Felipe eʼmanbatiaʼpakte aratbut oʼnoknopo̱e̱depo huabokerekere ettoneʼere bautiza o̱gkaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simón kenpaʼti oknopo̱e̱ʼuyate. Simóntaj bautiza e̱gkadeʼte Felipeere oʼhuaeʼikaʼuy. Konig kahued o̱ʼeonhuahuikaʼuyate Felipe eʼkikaʼte oʼtihuaypo, oʼmepukeʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Samaria hua̱e̱ʼeri Diosen huadak huaʼa eʼnigpe̱e̱deʼte Jerusalényo̱ Jesúsen doce huamataʼmoneri onʼmati̱pe̱e̱depo Pedrotaj Juantaere Samariayo onʼmataʼmonaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Samaria huakkaʼ jakyo Samariaeri huanigpe̱i̱kaʼeritaj onʼmationaʼpakpo “Diosen Noki̱re̱ga̱ yamanopoʼto̱e̱ʼ.” Onʼmationaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Kenomeytaj Diosen Noki̱re̱ga̱ nopoʼto̱e̱hued bautiza o̱gkaʼdeʼuyatenigʼa. ");
INSERT INTO amrNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ken onʼtionaʼpakdepo Pedro Juanere onʼbatibataʼtepo Samariaeritaj Diosen Noki̱re̱ga̱ oʼmanopoʼto̱e̱ʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","19","Jesúsen doce huamataʼmoneria eʼtibaʼtaʼtete Diosen Noki̱re̱ga̱ eʼmanopoʼto̱e̱te, Simóna kenda oʼtiahuaydepo, —‍Doa eʼtibaʼtaʼte betapiʼ Diosen Noki̱re̱ga̱ huamanopoʼtoeanhuaʼ kenda doʼtaj eʼyoknayo huakupe onʼyokapone. —‍Simóna oʼmanaʼnok. ");
INSERT INTO amrNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","—‍Namaʼda iʼnopo̱e̱nig o̱ʼnen huakupeere onʼere ehueʼdikda i̱ʼe̱ne. Diosen Noki̱re̱g huakupete yokdik meʼe̱ne namaʼda iʼnopo̱e̱. ");
INSERT INTO amrNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Diostehuapaʼ oʼnennopoʼ dakhueʼda i̱ʼe̱po oroʼere in oʼkikay kikahueʼdik i̱ʼe̱ne. ");
INSERT INTO amrNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Dakhueaʼ eʼkaʼ yanopoʼkoreaʼ, Diostaj dakaʼ yationaʼpak, “Doʼhuednopoa dakhueaʼda ijnopo̱i̱kay. Menopoʼtihuekeʼ. Bekkahueaʼ.” Yationaʼpaktiʼ. ");
INSERT INTO amrNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Konig hua̱hui̱ʼ paiʼonignanada i̱ʼe̱ne. Dakhueaʼ iʼkikaʼpo batikhueʼdik i̱ʼe̱ne. Ijnopo̱e̱y. —‍Pedroa onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","—‍Dakhueʼ Diosa megkaʼapone oʼnonaʼne. Diosa kenda kahueʼ ka̱e̱ʼpo. Diostaj meʼtionaʼpak. —‍Simóna onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ken, Juan Pedroere konig Jesucristo oʼkikuyatenig onʼmanbatiaʼpakonhuaʼdepo kenpaʼti Diosbaʼ onʼmananhuaʼdepo Jerusalényo̱ huaboaʼda onʼhuaʼuy. Onʼhuaʼpo nog huakkaʼ jakyo nog huakkaʼ jakyo Samariabayo onʼmata̱ʼunhuaʼpo kenda Jesucristoa oʼkaʼonhuaʼuyatenig onʼmanbatiaʼpakonhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Nogok Felipetaj Diosen huataʼmoneria onaʼpo, —‍Yabodpo Gaza huakkaʼ jakyon yahuatiʼ. Jerusalénya̱ʼ Gaza huakkaʼ jak dagte yahuatiʼ. —‍Diosen huataʼmoneria onaʼuy. Ken dagte sueʼda aratbut eʼnahue̱ʼyo̱. ");
INSERT INTO amrNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ken Felipe oʼbodpo oʼhuaʼ. Ken dagte oʼhuaʼ Etiopía huadari hua̱e̱ʼeri huabokerek o̱deʼuy. Keʼna bakdejhueʼdik o̱ʼu̱y. Keʼna Etiopía ettoneʼ huairien huakupe huato̱e̱ʼeri o̱ʼu̱yate. Diostaj aʼtionaʼpakyaʼpo Jerusalényo̱ oʼhuaʼudhuahuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Oʼkumejdepo dagte ʼuru carro caballoa huatohuaʼte oʼhuadpo Isaíasa oʼmadoyaʼuyatenig Diosbaʼ oʼbonaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","—‍ʼUru carro caballoa huatohuaʼte yahuahuaʼ. Carrote yahuaʼ. —‍Diosen Noki̱re̱ga̱ Felipetaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ken Etiopíataj oʼhuaketdepo Isaíasbaʼ eʼbonaʼpakte Felipea oʼpe̱e̱depo, —‍Berobaʼ iʼtiahuaynig menpaʼ iʼnopoenkaʼ. —‍Felipea onaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","—‍Ehueʼ, noponkahueʼ i̱jje̱y. Doʼtaj konig o̱ʼe̱ onahueʼ e̱e̱ʼnayo nopoenkahueʼdik i̱jje̱y. Doere carroyo yahuad. —‍Felipetaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","In Diosbaʼte oʼbonaʼpakpo, Konig ovejataj aʼarakyaʼpo onʼtohuaʼikaʼ konigti kentaj aʼarakyaʼpo yanʼtohuaʼapet. Konig oveja eʼkupieʼte sagkiahueʼ o̱ʼe̱. In huabokerek konigti oveja konig soataʼda ya̱ʼe̱a̱pet. ");
INSERT INTO amrNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Keʼna dakhueaʼ kahueʼ e̱e̱ʼpiʼ kentaj yanʼtierekapet yanʼtisupuʼeapet kenpaʼti yanarakapet. Kentaj huakkaʼananada oʼnoknopo̱e̱a̱po, beʼa sigpiʼ yaʼnopo̱e̱a̱pet. Kentaj yanʼarakapet. Kenda Diosbaʼ oʼbonaʼpakuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","—‍¿Betaj oʼtiaʼpakuyate Isaías Diosen huamanbatiaʼpakeria? ¿Huataʼdapiʼ yaʼtiaʼpakuyet? ¿Nogtadapiʼ yaaʼuyetpiʼ? —‍Kenpaʼ Etiopía huairia Felipetaj onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Kenda Diosbaʼte huaboaʼda eʼbonapakdeʼte Felipea oʼnopo̱e̱a̱ʼpo kenda Jesúsa oʼkikaʼuynig dakaʼ onmadikaʼpo ");
INSERT INTO amrNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","dagte onʼhuaʼpo maya̱kote onʼe̱depo, —‍In hue̱ʼe̱y o̱ʼe̱. ¿Doʼtaj bautiza o̱gkahueʼdik o̱ʼe̱? —‍Etiopía huakupe huairia onaʼuy Felipetaj. ");
INSERT INTO amrNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","—‍Jesucristotaj dakaʼ eknopo̱e̱ʼnayo bautiza o̱gkaʼdik o̱ʼe̱ne. —‍Felipea onaʼnok, —‍Jesucristo Diosen Huasiʼpo o̱ʼe̱, yoknopo̱e̱y. —‍Huairia onaʼuy. ");
INSERT INTO amrNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Carrotaj yabatikaʼ. Huairia onaʼpo, maya̱koyo Felipeere huairiere onʼkotpo. Felipea huairitaj bautiza o̱gkaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Ken enʼbehuikdeʼte Diosen Noki̱re̱ga̱ Felipetaj oʼtohuaʼuyate. Diosen Noki̱re̱g oʼtohuaʼnok huairi Felipetaj onteʼti tiahuayhueʼda o̱ʼe̱ʼuy. Durugnada oʼhuaʼuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Huakkaʼ jakyo Azoto Felipetaj oʼenuyate. Felipe nogyo̱ nogyo̱ huakkaʼ jakyo oʼhuaʼepo kenda Jesucristo oʼkikuyate kenda huadak huaʼa oʼmanmadikaʼuyate. Cesarea huakkaʼ jak dagte oʼhuaʼdepo nog jakyo nog jakyo huadak huaʼa oʼmanmadikanhuaʼuyate. Nogok Cesarea huakkaʼ jakyo oʼtiakuyate. ");
INSERT INTO amrNT_vpl VALUES ("AC9