﻿USE sofia;
DROP TABLE IF EXISTS sofia.amp_vpl;
CREATE TABLE amp_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES amp_vpl WRITE;
INSERT INTO amp_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ndarm Jisas Kraisrhu nkifraroh yufayem. Jisasr Defit frikef yuhat niamor, tfit Defitrn Abrahamrhu frika yuhat niamor. ");
INSERT INTO amp_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahamrn nasakmorr Aisakr. Tfit Aisakr nasakmorr Jekofr. Jekofr nasakmorm Judari rorhu wom nmemrom. ");
INSERT INTO amp_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judar nasakmorf Peres Serarof. Rofhu mmemt Tamat. Tfit Peresrn nasakmorr Hesronr. Yo Hesronrn nasakmorr Ramr. ");
INSERT INTO amp_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Yo Ramrn nasakmorr Aminadafr. Aminadafrn nasakmorr Nasonr. Yo Nasonrn nasakmorr Salmonr. ");
INSERT INTO amp_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmonr nasakmorr Boasr. Rorhu mmemt Rahaft. Boasrn nasakmorr Obetr. Rorhu mmemt Rutt. Tfit Obetrn nasakmorr Jesir. ");
INSERT INTO amp_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesirn nasakmorr King Defitr. Yo Defitrn nasakmorr Solomonr. Solomonrhu mmemtn Uriarhu mett rhumot. ");
INSERT INTO amp_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomonr nasakmorr Rehoboamr. Rehoboamrn nasakmorr Abiyar. Yo Abiyarn nasakmorr Asar. ");
INSERT INTO amp_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asarn nasakmorr Jehosafatr. Tfit Jehosafatrn nasakmorr Jehoramr. Jehoramrn nasakmorr Usiar. ");
INSERT INTO amp_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiar nasakmorr Jotamr. Jotamr nasakmorr Ahasr. Yo Ahasrn nasakmorr Hesekiar. ");
INSERT INTO amp_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekiar nasakmorr Manaser. Yo Manaser nasakmorr Emonr. Emonrn nasakmorr Josaiar. ");
INSERT INTO amp_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaiar nasakmorr Jehoiakinri rorhu nmemrom. Nd yihar Isrerm Babilonko kalabus yi tohmom. ");
INSERT INTO amp_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Isrerm Babilonko kalabus bi htanyetmn Jehoiakinr nasakmorr Sealtierr. Yo Sealtierrn nasakmorr Serubaberr. ");
INSERT INTO amp_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubaberrn nasakmorr Abiutr. Abiutrn nasakmorr Eliakimr. Eliakimrn nasakmorr Asorr. ");
INSERT INTO amp_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asorrn nasakmorr Sadokr. Yo Sadokrn nasakmorr Akimr. Akimrn nasakmorr Eliutr. ");
INSERT INTO amp_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliutrn nasakmorr Eleasarr. Eleasarrn nasakmorr Matanr. Matanrn nasakmorr Jekofr. ");
INSERT INTO amp_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekofr nasakmorr Josefr. Josefr tohhato Mariat fakmor. Mariat rotn hiyaumotr Jisasr. Jisasr tor nd yimam yutiwa Kraiser. Tor nd yimar Bro Nkifrar bi kfo htamor turhu met yindariroh minrfa htiyakyukr. ");
INSERT INTO amp_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nd na kfo hawihne nkifraroh yufam Abrahamrpno ritohakmom bi 14-pela nkifram tohmom Defitrpno mthomna tmbhomohat. Tfit Defitrpno thomnakni Babilonko kalabus yinyeftpno mthomna tmbhomohat, tfit wom 14-pela nkifram tohmom. Tfit ndha thomnakni nd hbhakyuk Kraisrpno mthomna tmbhomohat wom 14-pela nkifram tohmom. ");
INSERT INTO amp_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jisasrhu niayuk yuhathu kfo nuhas mrokfot inji korht. Rorhu mmem Mariat, bi kfo nanf hanymomt Josefrpno. Be yuhre nakfo nanf hanyetfn tfit htimomt Mariat yon fanett rhumot. Nd yon fant Bro Nkifrarhu Yafothat kfomott Mariat yon fanett rhumot. ");
INSERT INTO amp_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Mariathu kfo nanf yima Josefr dborioh yimarn, nd Mariat yon fanet rhumohat ror nhai marimor, “Rikfo akforuhant.” Nhai. Rorhu dukeft duka memor, “Rikfo akfo yiruhant yak yimtnaruhant. Be nann nhowi fnahhato frtrohruhant.” ");
INSERT INTO amp_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Josefrhu yima yuhur inji rhu hanyetrn Bro Nkifrarhu mounmotr twenano niahato kfo memorr, “Josef, Defitrhu tangishofe, mirahn Mariathu yakneft wom bok dukefm ayaka. Wawanyn, nd Mariathu yon fant Bro Nkifrarhu Yafothat kfomott yon fanett korht. ");
INSERT INTO amp_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nd rot hiyauruha yonrhu yufat wayutatwanr Jisasr. Rorn nrfa rafakrahrm tuhan yindarirm Bro Nkifrar finji naneft. Ndnettn nd Jisas yufat wahmbritwanr.” ");
INSERT INTO amp_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nd nefm namohat bi Bror profetmpno kfo htamo mrokfo yuhatn inji rhu hikmom. Profetr inji kfo memor, ");
INSERT INTO amp_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Wom mett tafi ram duhatt yon fanett rhuruhatn wom yon yindarir hiyaurahtrn yufat yutarahmr Emanuerr.” Nd yufathu yimbu yuhat inji, “Bro Nkifrar nompno tohwor.” ");
INSERT INTO amp_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Be Josefr sinyamohat nd Brorhu mounmotr kfoyuk mrokfo yuhatn yak hikhato Mariat fakmiyakmort. ");
INSERT INTO amp_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","To nhai rpat rpa rika bukt hwe inji narmof. Be inji nndo tohhany tohhany Mariat hiyaumotr yon yindarir. Yonr nurnimotr Josefr yufat futamor Jisasr. ");
INSERT INTO amp_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Mariat Jisasr hiyaumohat Judia distrikkorhof taun Betlehemtn hiyaumotr, nd yihar Herotr king tohmor. Jisasr bi nurniyetrn gunym hti hik bohikmoa yimam marr yuwa muhwako toh tanyhato Jerusalemr mfnahhato ");
INSERT INTO amp_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","mttiwon hambro memom, “Nd nurmo nfri yonr, Judaroh kingr, fitha inji yorhwar? Nom marr yuwa muhwako tohrohat nd rorhu gunyr hti tanyhato nienom, famunom, ‘Htiruhanomrn bangu miyuknahato kfo yindhorrahnomr.’” ");
INSERT INTO amp_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","King Herotri Jerusalemthu met yindari bugam nd mrokfot wanymohat rroh yima yuhum nhai rhu marnyarmomm. Be mrokfo kfo duham rhumom. ");
INSERT INTO amp_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Be Herotr naku nhafohmorm prisroh bro yimami boririfhuthu tisam. Nia rifiny bugamotm ttiwon memorm, “Nd yimare, Bro Nkifrar kfo hta memo, rorn yiruharn nd turhu met yindarim minrfa htiyakrahrm, tone fitoh kmitn nia minurruhar?” ");
INSERT INTO amp_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tfit rom kfo memomr, “Judiakorhof taun Betlehemtn. Profetr wandfamo mrokfot inji kfomot: ");
INSERT INTO amp_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Judako yorhwa kmi Betleheme, ni nhai be Judako yorhwa yufet yufet kmiroh mongpako rhutakahn. Nhai mif. Ni yufet kmiye. Ninhu yonrn nanhu ttha kmi Isrerm tohukatohrahrm.’” ");
INSERT INTO amp_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Be Herotr nd mrokfot wanyhato gunym hti hik bohiket yimam nhofijo kfakmormn ttiwon hik bohikhato memorm, “Nikone fitoh yiharn nd gunyr mfnahmor?” ");
INSERT INTO amp_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Rom yihato kfo hik bohik nuhas marnyamotmr be kfo memorm, “Betlehemko waikahkomn frhik hanykahkomn bi mhtitawokomr, wania wakfo nuhaskahtkma na yihato bangu myuknahato kfo yindhorruhanr.” ");
INSERT INTO amp_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Be rom nd kingr kfoyuk mrokfot wany sanyhato yimom. Yihato buha yihotohatn nd rom barkof marr yuwa muhwako htimo gunyr htiyaknimomr. Be nd gunyr tohakmotr rom be nd gunyr fau hik hanymom. Yi yihato tu nd yonr rhumo kunyshu mingiahuspno mhir nniotamor. ");
INSERT INTO amp_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Rom nd gunyr htihato yima yuhum masat masat yindhormomm. ");
INSERT INTO amp_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Be rom kunys rim fnahnimohat rim htimomf Maria nmehf rpat rhu hasetfn. Nd yonr rim htimomrn bangu yuknahato kfo yindhormomr. Kfo yindhornihato nd rom hanymo gorm yo hta yifetyuk sanda mkum yo dborioh mtha yarfonet mrpam hemomr. ");
INSERT INTO amp_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Be tfit yifungnano hweneftpno twenano Bro Nkifrar kfo memorm, “Mirahko Herotrhu kmifa yuhat tfit anjunom. Wom yuhat wahta hhriftwako.” Be rom yimohat manoh yuhat yimomn turoh kmiko yimom. ");
INSERT INTO amp_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nd marr yuwa muhkorhof yimam bi yiyetmn tfit Brorhu mounmotr niamorn Josefr twenano kfo ptha hany memorr, “Yo ni met nmehf wayaknikahnfn Ijifko wakrmenyitwako. Niko Ijift yi toh thombat nanhu tngtn watoh garitwa. Na bi kfiwa ee tfit wanietwako. Herotr kangr, ‘Yihato yonr was hehur thuruhanr.’” ");
INSERT INTO amp_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Be Josefr wasinyamorn yon tuhan nmehf yaknihato yifungnano fakrmenimom Ijifkorn. ");
INSERT INTO amp_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Josefrom Ijift tohetmn Herotrhu noh mrokfot wanyakmomt. Nd neft rhu hikmot profetmpno Bror pthamo yuhatn. Kfo memor, “Nanhu yonr Ijift tohetrn tfit kfafrhotanr Ijift htanyhato nierahr.” ");
INSERT INTO amp_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herotr garitihato memor, “Nane ndu yimame yuwi kfo nheh tanymoma.” Be ndnatn rorhu yima yuhur namburhato wom yimam kfo tkrurafmotrm yimom taun Betlehemtn. Yihato tauntpno rhu hanyuk kmim yi habrihato tafi hus gunyjim duhat yon yindariyenm tadborha bugamomm. Herotr nd gunym hti hiket yimam ttiwon memohat, “Nikone fitoh yiharn nd gunyr mfnahmor,” to ror be yuwi ttiwon rhtimorm. Memor, “Awany hik marnyakahann bt nd yihar nur hanyuk yon yindariyenm tadborharuhanm.” ");
INSERT INTO amp_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Nd neft namohat bi Bro Nkifrar profet Jeremaiarhu tngtn kfo htamo yuhatn be inji rhu hik twanhomot. Memor, ");
INSERT INTO amp_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Bro nur kimrm korhmm Ramakor. Resert tuthu yonm noh wita nmbuhatpno nurwot. Rot nhai wofnkaht womm yihato rothu yima yuhur yak marnya bomarnyaneft.” ");
INSERT INTO amp_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Herotr nohmotr tfit Brorhu mounmotr Ijifko yimorn twenano Josefr kfo hany memorr, ");
INSERT INTO amp_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Wasinyakahnn yon tuhan nmehf yaknihato tfit wanjuko kantri Isrerkorn. Nda yonr waskfot kfomo yimam bi nohmom.” ");
INSERT INTO amp_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Be Josefr sinyahato yon tuhan nmehf yaknihato tfit yimom kantri Isrerkorn. ");
INSERT INTO amp_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","To tfit wom mrokfot wanymor. Arkelausrn yifem Herotrhu tkitthu yakhato Judiaroh king toh mrokfot, ndt wanyhato duka yanho hanymor ndkor yinyeft. To nhai, Bro Nkifrar twenano yimorn kfomotrr Josefr distrik Galilikor yimom. ");
INSERT INTO amp_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Yimomn wom taunt kutewumt Nasaret, ndha mtohmom. Nd neft namohat to bi profetm pthamo mrokfo yuhatn inji rhu hikmot. Memom, “Yutarahmr Nasaret thofenr.” ");
INSERT INTO amp_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nd yiham Jon Baftaisr Judiathu nungur tik furat toh habrihato met yindarim kfo memourm, ");
INSERT INTO amp_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Hefenrhu kingdomkfot bi brbohwot. Ndnettn tamoh tamoh nefenm mong troh bugakfot.” ");
INSERT INTO amp_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Nd yima Jonr niahato Bro Nkifrarhu mrokfothu kfo pthaneft to bi Aisaiarn bi kfongotmort rorhu nia mrokfot. Aisaiar kfo memour, “Wom yimar nungur tik furatn tohhato kfo mirahrko, ‘Bro Nungothetrhu niayuk yuhat wayak marnyak hanyhekomr.’” ");
INSERT INTO amp_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nd yihart Jonr kamer tmb hingrnayet hmbreshat hmbremour yo yemro thaye nyuh dbkafmour yo rit papkumi winepam, ndm yehato tohmour. ");
INSERT INTO amp_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","6","Jerusalem thofm yo Judiakorhofm yo brbo tek Jodent toh habrimoam, nd nd yimam Jonrpno yihato nd rroh fasoh fasoh nefm kfo nriyafnimoamm tek Jodentn baftaisimmourm. ");
INSERT INTO amp_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Bok Farisimi Sadyusim niamoum baftaisneft Jonrpno. Jonr inji htihato kfo memourm, “Arom nandomrhu yon kunyso, Bro Nkifrar yimam yak tutfa thombat, finji yak hhrifniruhako? ");
INSERT INTO amp_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nikmoh nefm, tohefm amfrfnah marnyakahtm riruh aruhyukm htiruhamn duka mirahm, ndm bi mong trohmomm fasoh fasoh nefm. Bi mar nukat tohwom. ");
INSERT INTO amp_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","To mirahko, ‘Ka nom Abrahamrhu yon kunysn ka yak trohnirahrnom.’ Nhai. Ndt rot niko mirahko bro yima yuhum ahtanomt. Wawanyko. Na kfiwanko, Bro Nkifrar akfor, nda tahim yak krekutrfotrm, Abrahamrhu yonm rhurfom. ");
INSERT INTO amp_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Hudarim bi mispimn bi frhamsisetm korhm. Fitoh mim nhai hifa yukha hir marnyakahm, nd hudariye yohakhany yohakhany, kahrpatn dbuhaf hanyrahm. ");
INSERT INTO amp_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Na bupaye baftaisimwohat niko hatohyuk fasoh fasoh nefm bi mfafhonimokomm, ndnetann baftaisimwanko. Nanhu mongko nia hnewa yimarn, tu bro bbukeft hatohwor. Na nhai ror kanjo bbukeft hatohkaha. Na nhai rorhu senderm yakitohak hekfot. Rorn tu Bro Nkifrarhu Yafothati kahtpno baftaisimrahrko. ");
INSERT INTO amp_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ror wit yukharoh tawokakhato wutuyakyuk safort kakitohwor. Wutuyakhato yeyukrpam tuha misuhruham, yak rmonruharm wit kunysn htarahrm. Nd krtikt nndo misuhyukt yak rmonruhartn tu tiha yiha nanyjar hatohwa kahtn kandhirahrt.” ");
INSERT INTO amp_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Be tor nd yiharn Jisasr Galilit htanyhato tek Jodenkor yimor. Memor, “Jon Baftaisrpno aikahann rorhu tire baftaisafrahra.” ");
INSERT INTO amp_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Be wom Jonr inji htiyakhato memor, “Akfo rafoyanr.” Ndnetrn kfo memorr, “Ni tamohmpno nanpno nie? Na ninnpno yirfota ninn baftaisafrfona.” ");
INSERT INTO amp_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Tfit Jisasr kfo wok memorr, “Inji akfo wokwohna. Na nd kfiwa mrokfo yuhatn wayak hikn. Inji narahno be nd Bro Nkifrar duka htayuk dukef yuhatn mikmbrerahno.” Be ndnatn Jonr fak hikmor Jisasr kfoyuk mrokfotn. ");
INSERT INTO amp_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jisasr baftaisneftpno wuyak muhakmorn tfit mfrsohneftpno yura mountko htimortko rim rhu mrhumot. Yiro moun rifhu yuhatn wuhtiyakmort Bro Nkifrarhu Yafothat ganyom mmkrs kanjo yak nhombranehato fawihnamot. Be nd ganyom mmkrs yawihnehato be yimarn mifakmort. ");
INSERT INTO amp_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Tfit yura mountko wom tngt wanymort. “Asor tu nanhu marbit yorhwa yonr yo na tu hifa hti yindhorwa yonr.” ");
INSERT INTO amp_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Be Jisasr ndhart htanymort. Bi Bro Nkifrarhu Yafothat thu nhombrayetrn, to be nd Yafothatn yak hatoh hanymottr, yimor nungur tik furatn. Bro Nkifrar duka memor, “Jisasr nd tkitt tohhato tndhr yihato rorhu yima yuhur tadborhawonrahrr.” ");
INSERT INTO amp_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","40 yiham toh furamor. Nhai nuwa yarmor. Tu wuroh yiharn bi yatinoh namborhohetrn, ");
INSERT INTO amp_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","nd yima yuhum tadborhiwa tndhr mfnahhato kfo memorr, “Ni Bro Nkifrarhu yonn rhu thombat, ndar tahim wakfokahtnm, bretpam kekutrahm.” ");
INSERT INTO amp_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Tfit Jisasr kfo wok memorr, “Bro Nkifrarhu gonborngt kfo kangt, ‘Nhai wom yimar bretparpat yehato tohwonkahr. Nhai. Bro Nkifrar kfoyuk mrokfo bugam yehato tohwor.’” ");
INSERT INTO amp_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Inji nna pthanihato tfit nd tndhr yaknimorr, hanymorr Jerusalemko yorhwa temperrhu mingiahurhu bikatitn. Yura mhatohmorrn, kfo memorr, ");
INSERT INTO amp_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Ni Bro Nkifrarhu yonn rhu thombat, watuhatoknikahnn, bbinysoft wamitohwonn. Bro gonborngt kfo kangt, ‘Bro Nkifrarhu mounmotm kforuhatrm, wuyakitohak hanyrahmn. Rroh tirmn mirhuniruhann, nhai tahimpno mitawokruhatnm ninhu wuram.’” ");
INSERT INTO amp_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jisasr tfit kfo wok memorr, “Bro gonborngt kfo kangt, ‘Mirahn Bror ninhu Bro Nkifrar frnhombrakahann afo htiruha finji hingrnaruhar.’” ");
INSERT INTO amp_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Inji kfomotrr, tfit yaknimorr hamuhmorr yura kminysofmn. Yura mhatohhato fak nuhasmorr ndar bbinysofthu bro yufa nanyjaret kmi kmim. ");
INSERT INTO amp_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Kfo memorr, “Kanga akfoyann, nanhu yufat kfo nakuhato kfo tatorahn, be ninn nda bbinysof bugat hiruha.” ");
INSERT INTO amp_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jisasr sinyahato kfo wok memorr, “Wuri wai! Bro gonborngt kfo kangt, ‘Bro Nkifrarparhu yufat kfo nakuhato kfo bruttnakfot. Rorpar kfo bruttnahato hikkfot.’” ");
INSERT INTO amp_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Be nd tndhr htanymorr Jisasr. Tndhr htanymohat Jisasr bi yati noh namborhoh bugamor. Tfit mounmotm yihato romn toh dbu hmbreyaknimotmr bmteft tfit fakmor. ");
INSERT INTO amp_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jonrhu kalabus hta mrokfot Jisasr wanyhato be tfit Galiliko yimor. ");
INSERT INTO amp_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Taun Nasaret htanyhato taun Kaperneamtn yi mtohmor. Kaperneamt korht Galili bari thmbtn, Sebulun Naftaliroh frikef yuhafhu bbinysoftn. ");
INSERT INTO amp_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nd neft Jisasr namohat, bi Bro Nkifrar profet Aisaiarhu tngt kfo htamo yuhatn fak hikmort. ");
INSERT INTO amp_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Aisaiar kfo memor, “Met yindarim Sebulunrhu tkitm tohyukm yo Naftalirhu tkitm tohyukm, marombko yita yihota yuhat yorhwa tkitm yo tek Joden mkuko yorhwa tkitm, ndm Galili distrikkorhofem. Nd distrikt yima tangirohet. ");
INSERT INTO amp_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nd met yindarim, be tu bro kspt yiro tohwam, be htirahmt bro nukeft. Nd met yindarim yifungt rhu hasoyukm nukeft yakrahtm.” ");
INSERT INTO amp_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nd yiharn Jisasr turhu mrokfot rikfo pthakmort. Kfo memour, “Hefenrhu kingdomkfot bi brbohwot. Ndnettn tamoh tamoh nefenm mong troh bugakfot.” ");
INSERT INTO amp_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jisasr Galili bari thmbt yau hanyhato Saimon Andru najohf rugit yak yif hasetfn htimorf. Saimonr kto Pita yufat futamomr. Rof nd hingrneft hingrnahato maru kakmouf. ");
INSERT INTO amp_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jisasr rof htihato kfo memorf, “Nann wania wahikfn. Nann wahikkahtfn yimaroh yakneft yak nuhasruhanfn.” ");
INSERT INTO amp_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Be rof inji wanyhato nd rugi wuskar myak htanihato mhikakni twanhomofr. ");
INSERT INTO amp_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Saimon Andru najohf yaknihato yimom. Yau hanyhato tfit buha Sebedirhu yon Jems Jon najohf mhtimorf. Rom tum nitohfit turoh mmbrt tohhato rugim fak nahu dbofta hasomom. Nd Sebedirhu yonf mhtihato kfo naku kangrf, “Wania wahikfna.” ");
INSERT INTO amp_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Be nd yon najohf inji wanymohat be mhikakni twanhomofr. Yifem Sebedir, ror htanymofr mmbrtn. ");
INSERT INTO amp_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jisasr distrikt Galilit frhtfas bugamort. Turoh rhu rifinyuk rmonm yihato met yindarim mrokfom hemourm. Hefenrhu kingdomkfothu mrokfomn kfo nuhas bonuhasmourm. Yo met yindarim hatohyuk wonk wonk dbohnefm fak thu bugamorm. ");
INSERT INTO amp_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Rorhu ndkorhof yi nmbuhat Siria profinshu met yindarim wany hanyhato hne hna bugamomm womhtet womhtet dbohnefmpno kkor hasetm yo kmi yarh fknayetm yo yimam noh mumeft yakhato tir wuram mengongaknihato bruktpno bruktpno tohakniyetm yo tir noh wura nohetm, ndhtet ndhtet dbohnetm hne hna bugamotmm Jisasr fak marnya hanymorm. ");
INSERT INTO amp_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Nhai be kuken yima rifhur Jisasr hikrmomr. Kmim sinya buga hanymom. Galilikorhofm, distrik Dekapoliskorhofm, Jerusalem, Judia yo tek Joden mkuko tohyukm sinya bugahato hik hanymomr. ");
INSERT INTO amp_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jisasr yonmari yima rifhur htiyakhato yura kminysofko muhmor. Ndha mrhu hasetrn turhu disaiperm mrifiny hmbremomr. ");
INSERT INTO amp_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jisasr turhu disaiperm yak nhafohmormn kfo memorm, ");
INSERT INTO amp_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Fitoh yimam duka kangm, ‘Nom ndhtet ufaso ruhet yimapanom, Bro Nkifrar hti duka twanhorahrnom,’ ndhtet duket yimam ayindhortwam. Bro Nkifrarhu kingdomkfot tohrahm. ");
INSERT INTO amp_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Fitoh yimaroh yima yuhum nur dungunangu hasiwum, ayindhortwam. Bro Nkifrar yak marnyarahrm rroh yima yuhum. ");
INSERT INTO amp_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Fitoh yimaroh rhuneft dborioh yima yuhumpno rhuhato ptha marnya bomarnyewum, ayindhortwam. Tkit tkitm romn Bro Nkifrar hirahr. ");
INSERT INTO amp_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Fitoh yimam, be nd dborioh nefroh hikneft rroh dukefm korhm, ayindhortwam. Tor Bro Nkifrar, rorn yak hta bohtarahrm. ");
INSERT INTO amp_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Fitoh yimam wom yimam hti yuhuwafwomm, ayindhortwam. Tawo Bro Nkifrar hti yuhuwafrahrm. ");
INSERT INTO amp_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Fitoh yimam, rroh yima yuhum wutham ruhetm, ayindhortwam. Bro Nkifrar htirahmr. ");
INSERT INTO amp_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Wom yimam nnayurwatm o tamoh nefm niwatm, niko womko hifa yima yuhum hanyhato nd rroh nefm kfo marnya bomarnyahato tamoh tamoh nefm kak nohahukkomm, niko ndhtet yimako yindhorkfot. Bro Nkifrarhu yonko rhurahko. ");
INSERT INTO amp_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Fitoh yimam, toh marnyahato dborioh nefm hikwatm, wom yimam be krhopam he furewumm, nd yimam ayindhortwam. Bro Nkifrarhu kingdomkfot tohrahm. ");
INSERT INTO amp_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Na hikwatko, yimam htihato kfo yukioh boyukiohhato krhopam kahukwomko, yindhorkfot. ");
INSERT INTO amp_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nikmoh yufathu wuskam tamoh tamohm bi hefenr rhu garitmko. Nd nefm niko yekwam, bi nikmoh nyingako toh hnamo profetm to inji nahnamoumm.” ");
INSERT INTO amp_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jisasr tfit wompam kfo memor, “Nikom nda bbinysofthu youpayeko. To nd you gb ye juha youpam finji naruhamn tfit you gb yeruham? Ndhtet youpam bi be, bi fasohem. Be inji bbinysoft truf thuhato yimamn yihom yahotni myahotnineftpno bbpa furam rhunikfot. ");
INSERT INTO amp_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Niko bbinysofthu nukefthu hayukeko. To wahtiko. Wom taunt ndu yura kmi bikatit urhuyukt nhai yimam hti hambrokfot. ");
INSERT INTO amp_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","To womt wawanyko. Nhai wom yimam lamt hta funakhato tfit rikat o bro baket yakhato lamthu funeft hta tasifkahmt. Nhai. Lamt hta funak thombat yura hegirwatmt nd kunys rhuyuk yimam nukeft kekwotm. ");
INSERT INTO amp_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ndnatn inji nd niko yakitohyuk kshr yak nuka marnyakfot. Yimam nd niko nayuk nefm htiruhamn Bro Yifemrko kfo yindhorrahmr.” ");
INSERT INTO amp_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Tfit Jisasr kfo memorm, “Niko na mirahko ka Bro Nkifrarhu boririfhuti profetm ptha htayuk mrokforoh yak thuneftn niamoya. Nhai. Nanpno nd rom bi pthayuk mrokfefm mfrfnahne hneruhatm htirahkomm. ");
INSERT INTO amp_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Na kfo mifwanko, mirahko nd boririfhuthu hik yuharoh wom kfo nuhas mrokfefenm o thfa mntwathu kfo tebos o kfo kars nmbuham ka bi riyak htafrahm. Nhai. Afo nd boririfhut kfoyuk mrokfom afo mfrfnah bugarahm. Bi mfrfnah buganime, ee mounti bbinysoft mibatiniruhatf, boririfhut riyak htafraht. ");
INSERT INTO amp_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ndnettn nd boririfhut yorhwa tefi tefi kfo nuhas mrokfom, kfo tebos mrokfom, kfo kars mrokfom fitoh yimar riyak htafhato wommpno mrhuhato kfo famurm, ‘Ndhtet tefi tefi yirmoh nmbuhenm hik bugak duha,’ yimar inji nayukr, hefenrhu kingdomkfot nia thombat, rorhu yufat nhai mfro mfrfnahruhatt. To fitoh yimar nd boririfhuthu mrokfom hikhato wommpno kfo nuhas bonuhasworm, ndhtet yimar hefenrhu kingdomkfot nia thombat, rorhu yufat mfro mfrfnahraht. ");
INSERT INTO amp_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Na kfo mifwanko, nikmoh toh nmbuham nhai Bro Nkifrarhu dukef yuhat hikrfoko, yo nikmoh dborioh nefm nhai be tu mfrfnah marnyakahm, bi ndu boririfhuthu tisami Farisim namoa kanjo inji nahikwoko. Be nhai hefenrhu kingdomkfot yiruhatrko. Tu be nhai mif.” ");
INSERT INTO amp_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jisasr kfo memorm, “Nikmoh nkifram kfo hawihnamo yirmoht bi wany hnamokomt. Inji kfomot, ‘Mirahn wanambur sinyahato yima awas furaya. Yima was furarahn kot tohrahn.’ ");
INSERT INTO amp_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","To nann wom kfot kfiwanko, wom yimar turhu yimatrpno nna huttf, nd yimar kot tohrahr. Ufaso faso kfo rindho borindhirr womr, be nd yimar bro kaunser yimampno kot tohkfot. Yo wom yimar tonehato womr kfo famurr, ‘Ar mmo dangnhar,’ inji kfoyuk yimar kaht riyahr. ");
INSERT INTO amp_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Ndnettn yemrom yaknihato kangn, Bro Nkifrar atarioh mthayanr, nd yemro tarioh mthayuk tkittn wom dukefr niern, nd dukefr kfo famurn, ‘Ni nd yimar inji inji namonr.’ Nd dukefr niern, to be nd tarioh yemrom afo miyak htanyhato afo nd yimarpno yihato mrokfom nakfo gbhu nakfo dbruf nuhasnihato ee tfit yihato Bro Nkifrar tarioh mthakfot. ");
INSERT INTO amp_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Womr kangr, ‘Akotimann,’ mrokfot yudbat yak nohkfot. Awi kanga hatohrahn, nd yimar jasrhu tirt htaruhatrn tfit rorn polisroh tirm htarahrn. Tfit polism kalabus htarahmn. ");
INSERT INTO amp_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kalabus yinyeft to be kalabus tohruhann bi nd kotkfot kfoyuk maruhat bi wiknent ee btn fnahnerahn.” ");
INSERT INTO amp_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jisasr tfit wom mrokfot kfomor. Kfo memor, “Bro Nkifrarhu nkifra yirmoht inji kfomot, ‘Yimam mirahm womroh metm arim fnahnom.’ ");
INSERT INTO amp_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","To nann wom kfot kfiwanko, wom yimar wom mett hti yuhurhato be yima yuhurpar sinyerr, to be bi yima yuhurn nd mett ners. ");
INSERT INTO amp_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Tirmifkorhof nyingarn wom nefm htihato fasoh nefm nenm, be nd nyingar yak rurhakhato be rpa nyingarparpno rhu marnyakfot. Hus nyinga bugaf rpat rhuneft, wom nyingarn fasoh nefm hanyruhatrn rorn yak hatohaforuhatrn hel riyahn. ");
INSERT INTO amp_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Tir miftn fasoh fasoh nefm newut, nd tirt tmbho thuhato be rpa tirrpatpno rhu marnyakfot. Hus tir bugaf rpat rhuneft, wom tirtn fasoh nefm naruhatt rotn yak hatohaforuhattn hel riyahn.” ");
INSERT INTO amp_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Jisasr tfit wom mrokfot kfomor. Kfo memor, “Bro Nkifrarhu nkifra yirmoht inji kfomot, ‘Wom yimar kangr, rorhu mett ayak tuhafoyant, afo tuhan yak tuhafoyuk gontwat yakhato nd gontwat hingrnanihato ee mett yak tuhafokfot.’ ");
INSERT INTO amp_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","To tfit nann wom kfot kfiwanko, wom yimar turhu mett, ijoh yuhat yi juha, be yak tuhafo furahato mett toh fura hasohato tfit wom yimar yakneft, nd rot yakyuk barkof yindarirn fasoh nmbuhat rihiyafmort. Rorn yak thu furafmotrt rot toh fura hasohato tfit nfri yimar yakneft, nd nfri yindarir ijoh yuhatuher. Yo nd mett, ror yakyukt, ijoh yuhathu metet.” ");
INSERT INTO amp_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Tfit Jisasr wom mrokfot kfo memor, “Nikmoh nkifram kfo hawihnamo yirmoht bi wany hnamokomt. Kfo hna memoum, ‘Bi wom mrokfot Bro Nkifrarhu yufat futent, mirahn tfit mrokfot akfo kekutant. Bro Nkifrar kukatoh hasiwur. Tu bi kfoyuk mrokfo yuhatn hikkfot.’ ");
INSERT INTO amp_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","To tfit nann wom kfot kfiwanko, mirahko tamohmpno Bro Nkifrarhu yufat auyutanomtko. Tu be nhai mif. Mirahko hefenr auyutakahnomn wom mrokfot ayak dbkafnomt. Hefenr ndr ror Bro Nkifrarhu tohukatohyuk tkitet. ");
INSERT INTO amp_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Yo mirahko bbinysoft ayutakahnomn wom mrokfot ayak dbkafnomt. Bbinysoft rot Bro Nkifrarhu wuraf wayahotwa tkitet. Yo mirahko Jerusalemr yutahato wom mrokfot ayak dbkafnomt. Jerusalemr tu bro Kingrhu tauner. ");
INSERT INTO amp_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Yo mirahko tukmoh mfham yutahato wom mrokfot ayak dbkafnomt. Nhai nd mfhathu tmars wom tamohm wunahato tmars ganyomtahato tfit wom yiha tfit krtatakfot. ");
INSERT INTO amp_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Tamoh mrokfom kforahko, bi kfo yakio mrokfot kfiko to be injirpa, o bi kfo rafo mrokfot kfiko to be injirpa. Ndwom ndwom mrokfom pthiwam, ndm tndh Satanr mhfnahnewurm.” ");
INSERT INTO amp_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jisasr wom mrokfot kfo memorm, “Bro Nkifrarhu nkifra yirmoht inji kfomot, ‘Womr nyingar frdbfern, tawo rorhu nyingar frdbfakfot. Bsor frwokrn, tawo bsor frwokkfot.’ ");
INSERT INTO amp_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","To tfit nann wom kfot kfiwanko, mirahko tawo tawo annayurnom. Yimar wom tamoh nefm nerko, mirahko tawo finji ananomr. Wom yimar tonehato yengongfako ftatrn, tfit kekuthato mano korhof yengongfat yak htahekfot. ");
INSERT INTO amp_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","O wom yimar ni womnhu siothat htihato kangr kothato ayakant, to be siothat yakhato rpat wom sakethatpno htahutahato hekfot. ");
INSERT INTO amp_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Wom yimar kfo tkrurworn rorhu kpthu rpa kilomita hanyheneft, tfit ninn hus kilomita hanyhekfot. ");
INSERT INTO amp_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Yo wom yimar niahato kfo ttiwonworn tamohroh hanyeft, yakhato wahiyafokfot. O wom yimar niahato kfo ttiwonworn tamohroh be yifrar yakitohtaneft, mirahn awany marsisayanr.” ");
INSERT INTO amp_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jisasr tfit wom mrokfot kfo memor, “Bro Nkifrarhu nkifra yirmoht inji kfomot, ‘Tukmoh yimatm yak marnyakfot. Niko yak bebwa yimamn yak bebkfot.’ ");
INSERT INTO amp_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","To tfit nann wom kfot kfiwanko, yimam faso faso kak beb bobebwomko, tfit nikomn nd yimam yak marnya bomarnyahato Bro Nkifrarpno wakfo bruttnatwakomm. ");
INSERT INTO amp_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Inji narahko, hefenr yorhwa Yifemrhu yonko rhurahko. Nd Yifemrhu marrpar kekworm fasoh net yimami dborioh nayet yimam. Yo ror yahuka buriohrpar wihhato kekworm dborioh yimami fasoh net yimam. ");
INSERT INTO amp_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nd nikompno nayak marnyewa yimarpampno hifa hifa nayak marnyarahko, to mirahko ka Bro Nkifrar htihato ttharahrnom. Nhai. To nd gafmanrhu takis marut yekwa yimam, rom ndhtet yima yak marnyaneft rom kakitohwomt. ");
INSERT INTO amp_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Tukmoh najomromrpam o nmemromrpampno nakfo yongm boyongm marnyarahko, to mirahko ka Bro Nkifrar htihato tu yindhorrahrnom. Nhai. Nd nakfo yongmnefm rom to nd Bro Nkifrar hik duha yimam newumm. ");
INSERT INTO amp_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Nikmoh toh nmbuham, tu Bro Yifemrko tohwa kanjo be yak teh marnyahato toh marnya bomarnyakfot.” ");
INSERT INTO amp_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jisasr wom mrokfot kfo memor, “Niko wadukaf hanyswako. Mirahko tamoh tamoh dborioh nmbuham be yima nyingahato anakahtnomm yimam afo ahtimnom. Inji narahko, to mirahko ka hefenr yorhwa Bro Nkifrar inji htihato ka tawo tamohm hirahrnom. Nhai. ");
INSERT INTO amp_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","3","Ni womn kangn wuskapa duha yimam tamohm ahiyanm, mirahn fumrr yakitohyuk yimar tohakhato fumrr nriyaf hanyhato yimam tamohm ahi hanyanm. Be yau tebfi hanyhato nhofijo rihti ahtihato wahtanyhekfot. Yimaroh nyingahato womm tamohm hanyeft, ndt be yuwi kangn, womm inji htihato kfo mirahm, ‘Ndr tu yima hayet yimayer.’ Na kfiwanko, bi ndar yima mif thetmn bi inji kfo yindhorwomn to mirahn ka Bro Nkifrar tfit kfo yindhorrahra. Nhai. ");
INSERT INTO amp_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Nd ni nayuk nefm be inji yimam hti duha. Hingrna kafrohkfot. Bro Nkifrarpar htirahr. Rorpar htihato rorn tawo ttharahrn.” ");
INSERT INTO amp_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jisasr wom mrokfot kfo memor, “Kangko, Bro Nkifrar akfo bruttnanome, mirahko nd mikfo nhehta mkfo nhehtayet yimam niwa yuhat ahiknom. Rom inji newum. Kfo bruttnaneft rroh yima yuhum be myindhornitmm Judaroh rhu rifinyuk rmonm o yihota nadbgm tohhato kfo bruttnaneft. Kangm, ‘Tafont tohhato kfo bruttnakahtnom yimam htirahmnom.’ Na kfiwanko, inji niwa yimam to bi yimamn htihato kfo yindhorwomm. Bro Nkifrar nhai tfit kfo yindhor inji naruhatrm. ");
INSERT INTO amp_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kangko, Bro Nkifrarpno akfo bruttnanome, tukmoh kunyko yihato rumko fknenihato rumthu yifhatikt frkihnihato nikmoh Bro Yifemrko kfo bruttnakfot. Bro Yifemrpar htirahr. Ndnettn tamoh nefm yiro kamonghato nayukm rorn htihato ttha hanyrahrko. ");
INSERT INTO amp_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Yo kfo bruttnaneft be mirahko Bro Nkifrar hik duha yimam kanjo akfo bruttna yukenom. Rom inji kfo bruttna yuke thombat duka kangm, ‘Kfo bruttna yukekahtnom nmoh nkifram wanyrahmnom.’ ");
INSERT INTO amp_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Niko mirahko rom niwa yuhatn ahiknom. Tamohm yibonhato be yima yuhurparn duka htaneft, Bro Nkifrar bi htitworm. ");
INSERT INTO amp_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kfo bruttnaneft inji kfo bruttnakfot: ‘O hefenr tohwa nmoh Bro Yifeme, ninhu hnaru yufat nhai yuta rrha borrhakfot. ");
INSERT INTO amp_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nom kangnom, ninhu kingdomkfot aniehnat. Nom ninhu duka yima yuhur ahiktwanom, hefenr tohwam hikwa kanjo. ");
INSERT INTO amp_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Hrek yihar yeyuk yeshrim wahanynom. ");
INSERT INTO amp_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nom nayuk fasoh fasoh nefenm wayafhonm, nom womroh nefm yafuhiwa kanjo. ");
INSERT INTO amp_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tndh Satanr nia toh nhehaknewurnom, mirahn ahti marsisayanm. Nhai. Waminrfa htiyaktwannom.’ ");
INSERT INTO amp_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Wawanyko. Womm wom fasoh fasoh netmko, rom nayuk nefm duka mumafahukomm, tawo nikmoh Bro Yifemr, hefenr tohwar, mumafhirahrko niko nayuk tamoh tamoh nefenm. ");
INSERT INTO amp_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nhai duka mumafherfokomm rom nayuk nefm, to tawo niko nayuk tamoh tamoh nefenm nhai duka mumafohiruhatrko nikmoh Bro Yifemr.” ");
INSERT INTO amp_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jisasr kfo memor, “Nuwa kurhato rhurahko, mirahko mikfo nhehta mkfo nhehtayuk yimam niwa kanjo tafontn nyingatikm wuyak kihhato arhunom. Yuwi inji anakahtnom hti nhta mirahmnom, ‘Nuwa kurhato yorhwamn nyingatikm wuyekwomm.’ Inji na duha. Na kfo mifwanko, niko hingrna kafrohyuk hingrnefm tafontn htahato yimam htihato ptha srhhirahmko, to be. Bro Nkifrar nhai tfit ttharuhatrko. ");
INSERT INTO amp_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Nuwa kurhato rhurahkome, nikmoh nyingatikm yuk marnya yo tmarim komim marnyahato rhukfot. ");
INSERT INTO amp_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Nyingatikm yifatoh marnyarahmko, yimam nhai hti nhtaruhatmko. Nikmoh Bro Yifemr, rorrpar niko hingrna kafrohyuk hingrnefm htirahr. Rorn ttha hanyrahrm niko hingrna kafrohwa hingrnefm.” ");
INSERT INTO amp_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Jisasr wom mrokfot kfo memor, “Niko mirahko ndar bbinysoftn niko wuss tamoht yak yakhato masat aharhunom. Ndar bbinysoftn wuss tamoht masat harhuneft, dmthu ruheht korht. Womm binef wingrtn kawutm. Yo rikoh yimaroht korht. ");
INSERT INTO amp_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Be ndnettn ndar bbinysofthu wuskar tamohr masat harhu duha. Yura hefenrpar wuthu tibmon bugakfot. Hefenko nhai dmt kabofringkahtm. Nhai binef wingrt yekahtm. Yo nhai rikoh yimam yak tmbranihato yakkahmm. ");
INSERT INTO amp_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nikmoh yima yuhum be nd wuskam yorhwa kmitn yirahm.” ");
INSERT INTO amp_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Jisasr kfo memor, “Nyingaf thatipthu kshef. Ninhu nyingaf dboriohf rhuneft thatipt yak nukaf hanyrahft. ");
INSERT INTO amp_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Nyinga bebetn rhurahn, yak tato botatohato hingrna fura bofurarahn tamoh tamoh nefm. Nd nukeft ni yakitohyukt bi nohraht, be bro yifungt tohrahn.” ");
INSERT INTO amp_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Jisasr kfo memor, “Nhai wom yimar hus tohak yimafhu slef yimar tohkfot. Ka womr yindhorrforrn, womr hhrekrforr. Womrhu mrokfom wany yakiorforn womrhu mrokfom nhai wany yakiorfotrm. Niko nhai rpatn Bro Nkifrarhu dukefti maru dukeft rpat yakitohkfot.” ");
INSERT INTO amp_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ndnatn kfo kanganko, mirahko tukmoh rhu toh nmbuhat htihato duka kinyaki bokinyakihato akfo amanyom, ‘Nome, tamohm yehato rhuruhanom, o tamohm hmbre wondhruhanom?’ Nikmoh dukefm tukmoh toh nmbuham dukewukome, to mirahko be yeshrirpam adukanom. Yo thatipt dukewuko, mirahko hmbresharpam adukanom. Nhai. ");
INSERT INTO amp_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nungam htitwokomm. Rom nhai wom yewuri fant nuhtakahm. Rom nhai wom wuss wushato yeshrt o tamoht yak tibmonkahm. Rom be inji rhu furewatm tu hefenr tohwa Bro Yifemrn kahukrm yeshrt. Niko finji dukewako? Ka be nd nunga furenrpam hti dukewur? Nhai yimako tur yak yeny nhombrayukko dukakahrko? ");
INSERT INTO amp_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Yimar be turhu rhu marnya nmbuhatn duka hasonefte ka nd dukeftn nd yimarhu bbinysofthu tohyuk yiham tfit yak nhirta hanyrfomt? Nhai ndar bbinysofthu wom yimar noheft yironak hanyhato afo kfo marifort, ‘Awi ar noheft. Na wofnkaha bmbri nohneft. Na kanga afo atoh buhtaka. Tafi ndar bbinysoft toh buhtarroya.’ ");
INSERT INTO amp_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Mirahko tukmoh toh nmbuhat htihato akfo amanyom, ‘Nome tamoh hmbresham hmbriruhanom?’ Htitwoko yifako sinyewa plauam nhai tumn hmbreyuk hmbresham hingrnakahmm. ");
INSERT INTO amp_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","To na, na kfiwanko, bingot Solomonr tu dborioh dborioh wondht wondhmour. To rorhu wondht nhai be mfro yifa tohrmot. Plauamn tot tu wondht harhuwomt. ");
INSERT INTO amp_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Wur rhu htfaswa kipr furat, yihof yimam pukakhato kaht kandhi thuruhat, ndhtet kipr furat to Bro Nkifrar kfiwatr tfa htahato fnhu nmboretwot. Ndnettn yimako, Bro Nkifrarhu dukefr rim tohni buga duha yitako, to mirahko duka kinyakinom. Bro Nkifrar hirahrko wondhyuk wuskam. ");
INSERT INTO amp_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ndnatn mirahko tukmoh toh nmbuhat htihato akfo amanyom, ‘Nome tamohm yehato tohruhanom? Hmbreshame tamoh hmbresham hmbriruhanom?’ ");
INSERT INTO amp_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Nd yeshri hmbresha dukefrn rhu hasoneft, ndt Bro Nkifrar hik duha yimaroh dukefer. Niko be ndhtet dukefrn rhu haso duha. Nikmoh Bro Yifemrko bi htitwor niko nd ndm yibonwohat. ");
INSERT INTO amp_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Tamoh tamohm kangko ayaknom, afo Bro Nkifrarhu kingdomkfoti ror tohwa toheft toh hikkfot, ee kto nd niko dukayuk tamoh tamoh dukefm hirahrko. ");
INSERT INTO amp_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ndnettn niko mirahko yihofrhof yeyuk yeshrim o tamohm dukahato aduka kinyaki hasonom. Yihofrhof krhopam, rom yihofrhofem. Mirahko yihofrhof krhopam tfit ayakkahnom hrefrhof krhopampno ahtanomm.” ");
INSERT INTO amp_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jisasr kfo memor, “Mirahn womroh nefm htihato ayak nhtakahann akfo ameya, ‘Nd nd yimam ndhtet ndhtet yimayem.’ Bro Nkifrar inji yak nhtarahrn, yima inji nayetn. ");
INSERT INTO amp_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Womroh nefm o tohefm htihato kfo nhtarahnm o yak nhtarahnm, tawo Bro Nkifrar kfo nhtarahrn o yak nhtarahrn. Womm finji finji kahuknm, tawo inji hirahmn. Womm he hmarsirahnm, tawo Bro Nkifrarko he hmarsirahrn. ");
INSERT INTO amp_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Tamohmpno womroh nyingam rhuyuk krpum yamuka, ayak thuhiyanm? Ka nhai hti dukakahnt tunhu nyingatikt hta rafiwa dohta mkut? ");
INSERT INTO amp_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nd dohta mkut ninhu nyingatikt yuhre yak thu duha, to tfit tamohmpno yamuka, ‘Yinowe, kanga ninhu nyingar yorhwa krpur ayak thuhanr.’ ");
INSERT INTO amp_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Be tunhu nefm kak wuna bowunewun. Afo tunhu dohta mkut riyak htafhato ee btn rhuhato ninhu yinowemrhu nyingar rhuyuk krpur hti marnyahato yak thurahnr. ");
INSERT INTO amp_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Mirahn bi Bro Nkifrarhu yufatpno htafet shrm yakhato tfit yaumn wahiyafoya. Wahiyaforahnm, to kanga kekuthato tfit wasrahmn. Yo mirahn dborioh dborioh tngany mohm yakhato fohmn wahiyafoya. Wahiyaforahnm, to kanga tfit wuraye yahot tmbho botmbhorahmm.” ");
INSERT INTO amp_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jisasr kfo memor, “Bro Nkifrarpno kfo bruttnahato kfo ttiwonrahko, hirahrko. Yak hambro hanyrahko, mhtirahko. Mkrohnarahko, yifhatikt tfanyrahrt. ");
INSERT INTO amp_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Froh froh yimam yihato mkfo bruttna kfo ttiwonrahm, ee hirahrm. Yimam yak hambrorahm, ee mhtirahm. Yo yimam mkrohnarahm, ee kekuthato htiruharmn yifhatikt yak tfanyakrahrm. ");
INSERT INTO amp_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Wom yonr nuwat tndaurfohat, ka yifemr tahis yakhato tahis wathu nhehaforforr? Nhai inji narfotr. ");
INSERT INTO amp_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","O yonr yirar tndaurfohat, ka yifemr nandomt yakhato nandomtn wathu nhehaforforr? Nhai inji narfotr. ");
INSERT INTO amp_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Niko, fasoh fasoh net yimako, yinem yonm tamohm kfo tndauneft yakhato kahukwokomm. Nd yuhatn to nikmoh tu Bro Yifemrko he mifrahrko niko tamohm dukahato kfo bruttnaneft. ");
INSERT INTO amp_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Kangko, womm ayak marnyamnome, barkofpam afo niko sinyahato womm yak marnyakfot. Ndhtet neft Mosesrhu boririfhut yo profetroh mrokfom kak hikwot.” ");
INSERT INTO amp_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Jisasr wom mrokfot kfo memor, “Habhi yihotar yiyet yihotarhu riwita yuhat habhiyet. Nd yuhatn riwitakfot. Helko yiyet yihotarhu riwita yuhat bro mifet. Hmbrohnat yorhwatt, bok yimam be nd yuhatn tone dukekwom. ");
INSERT INTO amp_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Mtoh nkifraniyuk kmit yiyet yihotathu riwita yuhat habhitn hti mumiwumt. Rpa rpa yimarpam htitamtn nd yuhat riwitewum.” ");
INSERT INTO amp_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jisasr tfit wom mrofkot kfo memor, “Yo! Niko giaman profetm hti dukak hanykfot. Nd giaman profetm yimampno yihato yima yuhum mtadborha nhehwomm. Rom pthayuk tok profet mrokfom mirahko ka kto tfit yafothetm korhm. Nhai. Be niko mfrnhehwom. Rom niewohat briahako sifsifroh that kasinyewum. Yiro yima rifhum yifako tohwa yauroh nefm tohwomm. ");
INSERT INTO amp_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Wom yimar kangn, ahtiyanr ndr tamohtet yimayer, htikfot rorhu nayuk nefmn. Wain yukham nhai hig toftn hirkahtm yimam yakkahmm. Nhai. Yo fik yukham nhaf, nhai mitaku tamentn hirkahtm yakkahmm. Nhai. ");
INSERT INTO amp_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nd yuhatn htirahnm, dborioh nnariyet nnar siham nhai nnarikahm. Fasoh nnariyet nnar siham rroh yukham nnariwom. ");
INSERT INTO amp_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Dborioh nnar siham nhai fasoh nnariyet nnariham hirkahm. Yo fasoh nnariyet nnar siham nhai ye marnyet nnariham hirkahm. ");
INSERT INTO amp_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Fasoh nnariyet nnariham hiret nnari siham yoh thuhato kaht kandhi thuwomm. ");
INSERT INTO amp_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ndnettn nd giaman profetroh nefm, nd nnar siham ye nhombra ttiwonwa kanjo rroh nefmn yak nhombra hti nhombrakfot. ");
INSERT INTO amp_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","To mirahko duka amanyom, ka met yindarim nanhu yufat yutahato kfo yamukam, ‘Bro Nungothet Jisase, Bro Nungothet Jisase,’ ka inji naku kfet yimamn yirahm hefenrhu kingdomkfot. Nhai. Fitoh metm o yindarim nanhu Yifemrhu dukefrko hikmr, tom nd yimarpamn yi tohrahm. ");
INSERT INTO amp_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Bro kotkfot yakitohruha yihart bok yimam kot tohhato kfo mirahma, ‘Bro Nungothet Jisase, Bro Nungothet Jisase, nom ninhu yufat kfo yutahato Bro Nkifrarhu mrokfom ptha nuhasmounom. Yo kmi yarh fknayet yimam ninhu yufat yuta nawohhato kmi yarhm fnahnimoum. Yo mirakerkfom hingrnamoahat to be ninhu yufat yuta nawohhato bok mirakerkfom hingrnamounomm.’ ");
INSERT INTO amp_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nd yiha inji kfoyuk yimam kfo miruhanm, ‘Na nhai tawisaf-wonkahanko. Wur fasoh fasoh nefm yakitohet yimako, wuri waiko.’” ");
INSERT INTO amp_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jisasr wom mrokfot kfo memor, “Ndar na kfo pthiwa mrokfom, yimam wany yakiohato yak hikwam, tu dborioh duka tungunet yimam kuny rahu pokm simene simenim dbkaf hmbrita kanjo inji kitt rom mrokfom wany yakiohato hikwa nmbuhat. ");
INSERT INTO amp_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kto buriohr wih wihhato hnutn nd kunyr hnu hmbrenihato kto tfit wifort tonehato nd kunyr mnhombraneft nhai nd kunyr wohsiskfot. Bi rahu pokm bro bro tahimpno simenim hmbriyetm, to finji kunyrhu wohsiskfot. Ndnettn ndar na kfo pthiwa mrokfom, yimam wany yakiohato yak hikwam, tu dborioh duka tungunetem. ");
INSERT INTO amp_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Yimam na kfo pthiwa mrokfom nhai wany yakiohato hik duha yitam, ndm mumetm kanjo kuny singoneft be inji yura nungurn singiwumm. ");
INSERT INTO amp_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kto buriohr wih wihhato hnutn hnu hmbrenihato kto tfit wifort tonehato nd kunyr mnhombraneft nhai nd kunyr toh bmtakfot. Nndo fnykt teh tour fnah yohnitt. Nhai be tu yifo suht suhkahr.” ");
INSERT INTO amp_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jisasr nd mrokfom kfo ptha buganihato nd rifinyuk yimam nd ror pthayuk mrokfom wanyhato yak nhtamohat be tuha mrokfo ptha duha rhumom. ");
INSERT INTO amp_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Mrokfom kfo ptha nuhas bonuhasmohat, nhai be Judaroh boririfhuthu tisam kfo ptha nuhaswa kanjo kfo ptha nuhasrmorm. Nhai. Mrokfom kfo ptha nuhasmohat bro duka tungunet yimam kanjo kfo ptha hik bohikmorm. Ndnettn yimam rorhu mrokfom wanymohat nhai marimom, “Kfo ptha inji narahnom.” Nhai. Be tuha mrokfo ptha duha rhumom. ");
INSERT INTO amp_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jisasr yura kminysoft wuhtanyhato yawihnamohat, yonmari yima rifhur fak hik hawihnamomr. ");
INSERT INTO amp_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Wom lepra dbohneft yaket yimar Jisasrpno bangu mtabokmehato kfo naku memorr, “Broye, ndar na hatohwa dbohneft yak thurahnt, to be thu troh tanyrahta.” ");
INSERT INTO amp_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jisasr inji wanyhato nd leprayet yimarn tirt rihtahato kfo memor, “Uwa, na yibonwa.” Inji kfoni hanyhato nd dbohneft kfo memort, “Wathu trohnr.” Inji kfomotr, nd dbohneft yudbat thu trohmotr. ");
INSERT INTO amp_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Thu troh tanymottr Jisasr kfo memorr, “Ni nda dbohneft thu troh tanyhat, mirahn tfit womm akfo nuhasanm. Mosesrhu boririfhut yak hikkfot. Yimam lepra dbohneft yaketm marnyanimoahat inji namoum. Nd hun gifam prisrpno myak nuhasnimoamn, tarioh mthamoum. Nd tarioh mtha yiharn prism ndt htihato kfo memoum, ‘Nd yimarhu dbohneft bi thu troh tanymotr.’ Ni nd yuhat yak hikkfot.” ");
INSERT INTO amp_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jisasr taun Kaperneamt yimor. Nd taunt tohetrn Romroh 100 soldiaroh keptenr yihato Jisasrpno be nnhuhato mkfo memor, ");
INSERT INTO amp_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Nungothet Jisase, nanhu hingrna yimar dbohna bebhato kunys hwitr. Bi minysaf hmbreyetrn nhai sinyahato rhukfot. Thatipt ke shuwotr. Ndnatn be hwe hasiwur.” ");
INSERT INTO amp_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Inji kfo pthamotr Jisasr kfo memorr, “Nhai mrokfom. Yirhoyann dbohneft yak thuhiruhanr.” ");
INSERT INTO amp_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Nd soldiaroh keptenr tfit kfo memorr, “Bro yimaye, mirahn nanhu kunys anea. Na nhai dborioh yimayann nanhu kunys nieruha. Be inji nndo tohhato be wakfokahtn, nanhu hingrna yimar marnyanirahr. ");
INSERT INTO amp_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Na to wom bro tohak ofisar tohekwatr na rorhu yinhitn watohwa. Tfit nann wom tohak yimaya tohwa. Nann kakitohwanm tfit wom ami rifhur. Nd ami rifhur nann yakitohhato wom soldiar kfo kanga, nd soldiar anjur, nd soldiar kitr. Kfo kanga, nd soldiar aniar, nd soldiar niewur. Nanhu hingrna yimar kfiwanr, tamohroh hingrnaneft, nd hingrneft hingrnewurt.” ");
INSERT INTO amp_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jisasr nd yimarhu mrokfefm wanyhato tuha mrokfo duhatr rhumor. Tfit kekutnihato nd ror hik hanymo yimam kfo memorm, “Barenko, nd yimar nndo wom kmi thofer. Nd mrokfot kfiwatr, nanhu yima yuhur duka kanga, Isrerkort nhai wom yimar htikahanr o wanykahanr kfo mekahra, ‘Be inji nndo tohhato wakfokahtn dbohnet yimar marnyanirahr.’ Nhai. Nhai ndhtet duket yimar htikaha. ");
INSERT INTO amp_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Kfiwanko, boknambok kantriroh yimam mano mano sinyarahm. Marr yuwa muhwa kantriroh yimam sinyarahm, yo marr yohnita kantriroh yimam sinyarahm. Sinyaruhamn, Abraham, Aisak, Jekofrompno rpat rhu yerahmt nd hefenrhu kingdomkfot htaruha yemro burwat. ");
INSERT INTO amp_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","To nd barkof Bro Nkifrar bi kfo hta memo, ‘Ndar yimamn nanhu kingdomkfot rhurahm,’ to nd bi kfo htayuk yimamn tfit toh kekuthato yak thu wurasohrahr. Nhai rorhu yufat rhuruhatm. Yak tuhafruhatrm bro kspitat tohrahm. Bro kspitat tohhato tau nknekrahm.” ");
INSERT INTO amp_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Be nd 100 soldiaroh tohak keptenr, Jisasr kfo memorr, “Wanju kunyko. Wanjukahnn htirahnr ninhu hingrna yimarhu dbohneft ninhu dukef yuhat rhu hikraht.” Be nd hingrna yimarhu dbohneft, be yudbat teh tmbhakmot. ");
INSERT INTO amp_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Be tfit yihato Pitarhu kunysn mfnahmor. Mfnahhato fknenimor. Fknenihato rim htimort Pitarhu matohemt kkah dbohnett hwemot. ");
INSERT INTO amp_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Be rotpno yihom rhuhato tirt fakitohmort. Be inji yakitohmotrt nd dbohneft thu troh tanymott. Be nd mett yudbat marnyani hanyhato sinyamotn yeshrim hta mskahemotm. ");
INSERT INTO amp_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Krifta hanymot, bok yimam hany hanymomm kmi yarh fknayet yimam. Hne hnamoatmm Jisasr mrokfot tumourt nd metm o yindarim hatohmoa kmi yarhm fnahni hanymoum. Yo nd dbohna mifetm, rom nhaf yak marnyaf hanymoatrm marnyani hanymoum. ");
INSERT INTO amp_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Jisasr nd namo neft, to profet Aisaiar kfongotmo mrokfotn ror namo neft fak hikmot. Bingot profet Aisaiar kfo memor, “Turn nmoh dbohnefm yak thumormn nndo tumorm.” ");
INSERT INTO amp_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jisasr yonmari yima rifhur toh dbu hmbremoatmr kekutnihato turhu disaiperm kfo memorm, “Tek bari mkuko ainyom.” ");
INSERT INTO amp_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nd yima rifinyrn tohmor nkifra boririfhuthu tisar. Yauyaknihato Jisasr rim kfo memorr, “Tisa, ni kmi kmi yi htfas thombat na hikhne hakuruhann.” ");
INSERT INTO amp_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jisasr kfo memor, “Kmbru fkohm, rom hwe skitetem, rom bbmuhmn tohwom. Nungam, rom miyuhtamn o wusmn hwitm. Nikmoh Bro Najomrpar be tu nhai ror wom hwe rhu mskayuk tkitt.” ");
INSERT INTO amp_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Tfit wom disaiperr sinyahato kfo memorr, “Bro Nungothete, nanhu yifemr yinohtr, afo rorhu yopt yiruha.” ");
INSERT INTO amp_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Inji kfomotr, Jisasr kfo memorr, “Noheh yimam, rom tum anayop hanym. Ni wania wahikna.” ");
INSERT INTO amp_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jisasr bot mikmbremor. Turhu disaiperm htiyaf hanyhato rom rpat mikmbremom. ");
INSERT INTO amp_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Mikmbrehato rihir hanymom. Buha bari dany yuhatn rim hir hanyhato Jisasr hwemor. Hweyetrn, bro wifort sinyamot. Wifort sinyahato tek barit fifrtuhato yonmari burifhum sinyamom. Burifhum sinyahato rom yimo bot burifhut bi tas finjaknimott. ");
INSERT INTO amp_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Be yudbat Jisasr frthamomr. Frtha hanyhato kfo hany memomr, “Broye, nome href finji newanom? Nom href yohnitnom!” ");
INSERT INTO amp_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jisasr sinyahato kfo memorm, “Niko ndar wiforti burifhut kakrmitko? To nikmoh dukefme fitha yitam? Ka nhai mikahko, ‘Tor ror rpat nienom, nhai yakrmiruhatnom?’ Nikmoh dukefm ka nhai be mfro nann niakahmko?” Be inji kfoni hanyhato nd wiforti burifhut sinya hasomof, ror mrokfot tumort be wufakmof. Wifort tone tmbhomot, tekt be minoh hmbremot. ");
INSERT INTO amp_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nd bot rhuyukm inji htihato tuha mrokfo duhatm rhumom. Memom, “Ndarr tamohtet yimarn wiforti burifhut wany yakiohato minoh hmbrif?” ");
INSERT INTO amp_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Jisasr Galili mkuko yi tohwa Gadararoh bbinysofko rim dbkafmor. Ndharn kmi yarh fknayet hus yimaf yihato Jisasr mfnahmofr. Nd hus yimaf be yima gum htamoa tahi bakuny mkumn toh htfasmouf. Kmi yarhm tuhagrhamoatmf mfro namburmoatf yimam nhai nd yimaf tohmoa yihota yuhat yirmoam. ");
INSERT INTO amp_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Nd yimaf hatohwa kmi yarhm Jisasr mhtihato kfo tau naku memom, “Bro Nkifrarhu Yone, nome finji newannom? Nmoh huhra krt kanjo frhabtothato krhopa yak yihar tor yuhre riyorhwor. Bi frohm memomn, ‘Asha wanietwa?’” ");
INSERT INTO amp_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Fohm rom wuri kkof ke wussohmoum. ");
INSERT INTO amp_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Nd yimaf hatohwa kmi yarhm Jisasr kfo naku ttiwon memomr, “Jisase, ni kangn ayak tuhafoyanm, wayak hatohafokahtnnom ndar yimaf htany thombat ndur tohwa foh rifhumn tfit fknihato tohrahnom.” ");
INSERT INTO amp_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jisasr nd kmi yarhm kfo memorm, “Wafnahniko.” Be inji kfo tkrurmotrm, rom nd hus yimaf thu troh tanyhato tfit fohmn fknenimom. Be fohmn fknenihato thu hafunanimotmm, nd fohm kmi kihahir yuhat mitarhotnihato tek baritn mitayif wurasoh bugamom. ");
INSERT INTO amp_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nd fohm hatohmoa yimam inji htihato fakrmemom. Yakrmenihato taunko yimom. Yihato taunthu yimam kfo nuhas bugamomm rom htimo nefm. Yo nd kmi yarh fknayet yimarhu mrokfom kfo hik bugamofm. ");
INSERT INTO amp_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Be nd taunthu yimam Jisasrpno yihato kfo tkrurmomr nd taunthu htanyhato tfit womha yinyeft. ");
INSERT INTO amp_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Be Jisasr bot mikmbrenihato tek barit tfit hir hayuknihato yimor Kaperneamko. Tot tur tohmoa taunt. ");
INSERT INTO amp_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Yo wom yimam wom tir wura nohet yimar kroketr hnamomr. Jisasr nd yimar hnayuk yimaroh yima yuhum htimorm. Rroh dukefm Jisasrpar yimom nd yimarhu minysafefthu marnyanineft. Rroh yima yuhum inji htihato nd minysafet yimar kfo memorr, “Ar yone, mirahn adukaya. Ninhu fasoh fasoh nefm bi fak tuhahuyann.” ");
INSERT INTO amp_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nkifra boririfhuthu tisam Jisasr kfomo mrokfot wanyhato tum rinahti nahtihato nakfo ptha memom, “Nd yimare, kangr Bro Nkifrarhu tkitt ayaka.” ");
INSERT INTO amp_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Nd yimaroh yima yuhum inji dukamohat Jisasr bi htimorm. Htihato kfo memorm, “Tamohmpno nd fasoh dukefm yekwako? ");
INSERT INTO amp_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Kangko finji akfoyane? Kangko akfo amiyanr, ‘Ninhu fasoh fasoh nefm bi fak tuhahuyann?’ O kangko akfo amiya, ‘Wasinya wayauyakni?’ ");
INSERT INTO amp_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Na, Bro Najoma, yimaroh fasoh fasoh nefroh yak thu yafothat Bro Nkifrar bi hemora. Afo asomif wom neft yak nuhasrhotanko, duka mirahko nd yimar bro yufeter.” Inji kfoni hanyhato nd tir wura minysafetr kfo memorr, “Na kfiwann, wasinyakahnn krokt wayaknikahnt tunhu kunyko wain.” ");
INSERT INTO amp_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Be nd yimar wasinyahato kunyko yimor. ");
INSERT INTO amp_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tuhan yindarim inji htihato yakrme yima yuhum niahato Bro Nkifrar kfo yindhormomr yimam ndhtet hingrna yafotham yahuka nmbuhat. ");
INSERT INTO amp_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jisasr yau hanyhato Matyur takis marut tuyuk kunyent rhu hasetrn yihom htimorr. Yihom htihato kfo memorr, “Wania wahikna.” Be Matyur sinyahato fak hikakni twanhomorr. ");
INSERT INTO amp_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jisasri turhu disaiperm yihato Matyurhu kunysn nuwa famom. Nd Matyurhu kunys nuwa yamohat wom bok takis marut yakyuk yimam yo wom fasoh nefm nayet yimam yihato rpat nuwa famom. ");
INSERT INTO amp_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farisim inji htihato rorhu disaipermpno yihato kfo memomm, “Tamohmpno nd takis yekwa yimami nd ufasoh nefm nayet yimam rpat rhuhato nuwa ye mskewar?” ");
INSERT INTO amp_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jisasr wanyhato kfo memorm, “Yima furam nhai be yi furakahm hunkotharpno. Nhai. Dbohnet yimarpam kitwom hunkotharpno. ");
INSERT INTO amp_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Afo tfit Bro Nkifrarhu rfa borngtn afo wamhti dukaktwako. Bro Nkifrarhu rfa borngt kfo yamuka, ‘Na nhai hti wofnkahanko nd niko tarioh mtha fura bofurewohat. Yima yuhuwafwa nmbuhatn hti wofnwanko.’ Nd mrokfot finji kfiwat? Na nhai dborioh yimaroh dukeftn niarmoya. Nhai. Na fasoh fasoh nefm nayet yimaroh dukeftn niamoya. Memoya, fasoh fasoh nefm nayet yimampno yirhoyann, kforhotanm, nd rroh fasoh nefm thu trohrahmm.” ");
INSERT INTO amp_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nd yiha Jon Baftaisrhu uhik ahik htfasyuk yimam Jisasrpno yihato mkfo memomr, “Nomi Farisim nuwa kurhato rhu hakutahat, to tamohmpno ninhu disaiperm nhai inji na hakukahm?” ");
INSERT INTO amp_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jisasr kfo memorm, “Wom yimar wom mett yakrahr, rorhu yimatm nhai bi hanurkahmr ror afo rompno yuhre rhu mska inji na thombat. Nhai. Kto yak hambrafruhamr, ee bt rorhu yimatm nuwa kurhato rhurahm. ");
INSERT INTO amp_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nhai yimam bingotrhof hmbresham muhetm rhuneft tfit nfri rmontha nmbrm yakhato nahukahmm. Yatk hmbreshathu muht tfit nfri rmonthaye nahuneft nfri rmontha nmbrtn teh hma bugarfott yatk hmbreshat. ");
INSERT INTO amp_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Yo nhai yimam nfri wain bupam yakhato yatk meme tha kpmn tas hmbrikahmm. Nfri wain bupam yakhato yatk meme tha kpmn tas hmbreneft nd nfri wain bupam rikur prhoruhamn nd yatk meme tha kpt frtfohhato wain bupam mitoh bugarahm. Ndnettn nfri wain bupam tu nfri meme tha kpe tas hmbrihato be nhai kpm yoh tfoh inji nakfot.” ");
INSERT INTO amp_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jisasr yuhre Jonrhu disaipermpno ptha hanyetrn, wom ofisar yauyak-nimorn Jisasrpno mtabokmehato kfo memorr, “Nanhu yont asomif bi fnoht. To ninn wai tir wahtakahtnt yafothat tfit mthu nawohrahtt.” ");
INSERT INTO amp_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Be Jisasr sinyamorn nd ofisar mhikaknimorr. Yo rorhu disaiperm rpat hik hanymomr. ");
INSERT INTO amp_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Jisasrom yihotat yau hanyetmn wom mett Jisasrhu mongko yauyak-nimotn ror hmbremo sakethathu psifm tire mtayoutimotm. Nd mett dbotteft 12-pela gunyjimm hatohmoutt. ");
INSERT INTO amp_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Rot nd hmbreshathu psifko tire wutayoutimohat, rothu dukeft duka memot, “Be tirrpaye rorhu hmbreshat wutayoutiruhant, nd na hatoh hnewa dbotteft teh tmbhakraht.” ");
INSERT INTO amp_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Rot inji dukahato mtayoutimohat, Jisasr kekutnihato wahtimort. Wahtihato kfo memort, “Ar yone, ninhu dukeft duka famu, ‘Be tirrpaye rorhu hmbreshat mtayouti thoft, nd dbotteft teh tmbhakraht.’ Ni nd dukeftpno tayoutiwontna ninhu dbotteft teh tmbhekwot.” Be inji kfomotrt, nd dbotteft yudbat teh tmbhakmot. ");
INSERT INTO amp_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Be Jisasr yimorn nd ofisarhu kunys mfnahmor. Mfnahhato mhtiyaknitworm yimam nur windohmpno mayi nmbuham mayi hanyhato ptha hofhta inji namoum. Jisasr inji mwanyhato ");
INSERT INTO amp_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","memorm, “Niko wafnahniko. Ndar yont nhai nohrfot, tot be hwitt!” Inji kfomotr memom ka be kfo ddiwur. Ndnatn rom tfit haningemomr. ");
INSERT INTO amp_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Nd nur kunys rhuyuk yimam yak tuhafhato fnah buganimotm, Jisasr nd yon gus rhumo tkitt rim tohhato tirt wafakmort, be nd yont tfit mfenyjwomot. ");
INSERT INTO amp_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nd ofisarhu yont kasinyamo yuhathu mrokfot nhai wom warhu hasormot. Nd distrikt nd mrokfot thu yufur buganimott. ");
INSERT INTO amp_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jisasr ndhar htanyhato tfit yimor. Yau hanyetrn hus nyinga kunyjetf yau hikaknihato naku kangfr, “Defit frikefthu yon Jisase, wayuhuwafnno.” ");
INSERT INTO amp_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jisasr kunys rim fnahniyetrn nd nyinga kunyjet yima husf yau hikaknihato rim htimofr. Rim htihato ttiwon memorf, “Nifnhu dukefm finji dukewafn? Ka duka kangfn, ‘Rorpno yihato rorhu tire kaktitrno nnoh nyingam kukatohwononm.’ Ka inji dukewufn?” Nd yimaf kfo memofr, “Uwa, Broye, no inji dukewuno.” ");
INSERT INTO amp_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Be nd yimafhu nyingam tir htahato kfo memorf, “To be nifnhu dukef yuhatn nifnhu nyingam frdborhewum.” ");
INSERT INTO amp_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Be nyingam tfit myoh dborhahato fukatohmofm. Jisasr kfo hta mrokfom kfo memorf, “Nifn ndar nyingam tfit yukatohwa yuhat mirahfn wom yimampno aptha nuhas mif mifnonm.” ");
INSERT INTO amp_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","To nhai, nd yimaf yimohat, nhai hikrmoft nd mrokfot. Tfit yimofn kfo ntramotft distrik bugathu tuhant yindars wany bugamomt. ");
INSERT INTO amp_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nd yimaf fnahni hanyetfn wom tng mmk yimar, kmi yarh fknayetr, hnamomr. ");
INSERT INTO amp_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Jisasrpno hnamotmr fak thumorr kmi yarhr. Yak thumotrr pthamor. Tuhan yindars bok dukefm yakhato kfo memom, “Bingot nmoh kantri Isrert nhai ndhtet nefm rhurmotm htirmomm.” ");
INSERT INTO amp_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Tfit Farisim sinyahato kfo memom, “Nd ror kmi yarhm yak thuwohat, nndo tndhrhu bbukeftpno kak thuworm.” ");
INSERT INTO amp_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jisasr kmi kmi, taun taun yi htfashato turoh rifinyuk rmonmn yi rhunhohato mrokfom hemorm. Hefenrhu kingdomkfothu mrokfomn kfo nuhasmourm, yo tuhan yindarim tamohtet tamohtet dbohnefm rroh thatipm rhumoam, kak marnyamourm. ");
INSERT INTO amp_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nd rifinymo tuhan yindarim htimorm tohukatoh duha sifsifm kanjo. Rroh rhu nmbuhat be tu ufasoh rhu beb mifmom. Htihato yuhuwafmorm. ");
INSERT INTO amp_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ndnatn turhu disaiperm kfo memorm, “Mswirthu yewurit bi kak yibonwot. To tmift nhai bok yimam nd yewuriroh yakyukm. ");
INSERT INTO amp_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ndnatn tu mswir tikatrpno wakfo bruttnakahtko yimam tkruraforuhatrm yihato yewurit yak wurirahmt.” ");
INSERT INTO amp_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jisasr turhu disaiperm kfakhato niamotm, hemorm dbohnet yimami kmi yarh fknayet yimaroh yak marnyayuk yafothar. ");
INSERT INTO amp_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jisasr yakmo barkof 12-pela aposerroh yufam inji: barkof yimarhu yufat Saimonr (wom yufat Pitar), yo rorhu nmem Andrur. Yo Sebedirhu yon najohf Jemsri nmem Jonr. ");
INSERT INTO amp_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Yo Filifr, yo Bartolomyur, yo Tomasr, yo takis marut yak htfasmoa yima Matyur. Yo Alfiusrhu yon Jemsr, yo Tadiusr. ");
INSERT INTO amp_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Yo Selot patikfot tohmoa yima Saimonr, ee wurohr Judas Iskariotr, Jisasr hndhnamo yimar. ");
INSERT INTO amp_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jisasr turhu 12-pela aposerm hingrnefm kfo tkrurafmohat, kfo tebos botebos nuhasmorm. Asom ror hemo kfo tebos mrokfom: Kfo memorm, “Niko hingrnafat yaknitahat, mirahko yima tangimpno ainyo yo mirahko Samariaroh taunm ainyom. Nhai. ");
INSERT INTO amp_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Isrerroh sifsifmpno waiswako. Rroh sifsifm bi frfnah wurasohmom. Rom duka duka waiswako. ");
INSERT INTO amp_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Waikahkomm wakfo wamitwakomm, ‘Hefenrhu kingdomkfot bi brbohwot.’ ");
INSERT INTO amp_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Waikah-komm dbohnet yimam wayak marnyatwakomm, noheh yimam wakasinyatwakomm, lepra dbohnefetm wayak wus bowustwakomm, kmi yarhm hatohet yimam kmi yarhm wayak thutwakomm. Nd yima yak marnyayuk yafothar be he furiwanko, ndnatn niko yimam tamoh nefm finji naneft mirahko tfit maruha ayaknomm. ");
INSERT INTO amp_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mirahko gor silva kapa marut ahiyau hiyaunom. ");
INSERT INTO amp_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Yo mirahko gegb yohm afotaknom o wom hmbre wuskenm be ayakitoh furakninomm o su wuram ayakitohakninomm o kio musm. Nhai. Nd niko yiyuk kmiroh yimamn niko tamoh tamohm hti dukakfot. ");
INSERT INTO amp_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Wom kmit o taun kitwoko, afo ttiwon hikkfot. Fitoh yimar kak miyekworko, nd yimarpno toh tanyhato yikfot. ");
INSERT INTO amp_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Fitoh kunys kitko, rim tohhato nd kuny shofm kfo yindhor mekfot, ‘Bro Nkifrar ayak marnya bomarnyatwarko.’ ");
INSERT INTO amp_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nd rim kfo yindhorakniyuk mrokfot nd kuny shofm wanyhato yindhorhato kak miyekwomko, nd niko rim kfo yindhorakni mrokfot hingrnaruhatn nd kunyshu yimam Bro Nkifrar yak marnyarahrm. Nhai yak miyakkahmko, kfo tany mekfot, ‘Bro Nkifraye, mirahn nd kuny shofm ayak marnyanm.’ ");
INSERT INTO amp_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","O wom kmit o taunt yihato nhai kunym yakmiyakhato niko hanyuk mrokfom nhai yindhorkahm wanyneft, nd kmit htanykfot fus wuram tuha nd kmitn frdbofta tanyhato htanykfot. ");
INSERT INTO amp_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Na kfo mifwanko, Bro Nkifrar kfomo kotkfot rhuruha yihart, nd taunt mirahko ka tu kuken krhopam yakrahm. Sodom Gomoraf yakruha krhopam be inji yakrahf. To rom be tu bro krhopa mifm yakrahm.” ");
INSERT INTO amp_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Jisasr kfo memorm, “Wawanyko, niko bi sisifm kanjo bi yifako tohwa namburet yauroh rifiny buhar kitwoko. Ndnettn niko dukefmpno waiswako. Nandomm kanjo duka hik marnya bomarnyahato tamoh tamoh nefm nakfot. Yo nunga mahum kanjo kmi thofmpno brbo yihato nayak marnyahato tamoh tamoh nefm nakfot. ");
INSERT INTO amp_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Niko tuko duka marnyaf hanykfot. Turoh kaunsermpno mkotimhato tu Judaroh rhu rifinyuk rmonmn hanyhato wife thu smbho bosmbhorahmko. ");
INSERT INTO amp_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nanhu mrokforoh yimaroh ptha nuhas hanyeftn yakruhamko gafmanmi kingroh tirmn htarahmko. Nd yuhatn nanhu mrokfot nd kot swirtn ptharuhatkomt nd bro yimami yo yima tangim wanyrahmt. ");
INSERT INTO amp_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Bi kot hanitmko, mirahko duka yakrmihato akfo amanyom, ‘Amai, nome finji ptharuhanom?’ Mirahko inji aduka yanhonom. Kot swirt, Bro Yifemrhu Yafothatn mrokfo rifhur hi hanyruhatrko, mrokfom be tumn mfrfnah hanyrahm. ");
INSERT INTO amp_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Najohfi yagnm tum nahndhna-rahm. Womr sinyahato womr hndhnaruhatrr wasrahmr. Nitohfim nhaf to inji. Yifemr sinyahato yinemr hndhnaruhatrr wasrahmr. Yinemrom nhai yifammampno nayak marnya-ruhatm. Yinemrom sinyahato yifammam hndhnaruhatmm wasrahmm. ");
INSERT INTO amp_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Yimako na hikrahko, riruh aruhyukm nhai hifa nyingar hta hakuruhatmko. Be hti sr thurahmko. Fitoh yimar inji htihato nhai riyoh brurhakhato myafhonirfora, nd yimar Bro Nkifrar yakrahrr. ");
INSERT INTO amp_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Wom taunt yihato nanhu mrokfom kfo ptha hanyhato nd taunthu yimam faso kak bebwomko, yakrman-yihato wom nndoh tauntn yikfot. Na kfiwanko, mirahko ka bi Isrerthu taunm mrokfot yak buganiyetmn nikmoh Bro Najemr ka nierahr. Nhai. ");
INSERT INTO amp_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Wom yonr, wandfa kunys yuhre tohetr, ror tisimyuk tisarhu yinhit tohwor. Yo wom hingrna yimar turhu tohak yimarhu yinhit tohwor. ");
INSERT INTO amp_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nd skurr tohet yonr kangr tukanhu tisar kanjo atoha, to nhai mrokfom. Yo hingrna yimar kangr tukanhu tohak yimar kanjo tohak yimaya atoha, to nhai mrokfom. Na nikmoh tohak yimaya Belsebur yufat hmbremoma. Kfo memom, ‘Belseburer.’ To niko to ndhtet yarhroh yufa bebm hmbrirahmko.” ");
INSERT INTO amp_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Yimam faso faso kak bebwomko, mirahko ayakrmanyom. Arihat kon kafroh hasiwa nefm kto Bro Nkifrar tafont htaruhatrm yimam htirahmm. ");
INSERT INTO amp_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nd na nikompno rhuhato nikomrpakompno kfo nuhaswa mrokfom mirahko turpakomn awany hmbritanomm. Yima yima wakfo nuhas buga hanyswakomm. Wakfo nuhas bugakahtkomm wany bugarahm. ");
INSERT INTO amp_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mirahko ndar yima mif thetm ayanhonomm. Rom thatiprpat waswatmt nohwot. Yafothathu wasneft rom nhai waskfot. To rom finji yafothat waskfot? Tu duka yanhoyuk yimar, Bro Nkifrarpar duka yanhokfot. Ror yafothati thatipt rpat hus bugaf yekwarf kahtn tutrf. ");
INSERT INTO amp_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Niko htitwokomm ndar nunga pirayenm yafuna htfaswam. Niko kangko ka Bro Nkifrar ka nhai htihato yakitohkahrm? Nhai. Nd nunga pirayenm rorhu tirtn korhm. Rorhu tirmn rhuyuk nungenm nhai nohkfot. Niko yimako to inji nd nungenm kanjo rorhu tirmn korhwoko. ");
INSERT INTO amp_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Yo womt, nikmoh tmariroh tmarifenm Bro Nkifrar bi htitahato thomna buga htatewurm. ");
INSERT INTO amp_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ndnettn niko be yakrme furawahko. Bro Nkifrar htihato kakitohworko nd nunga pirayenm yakitohwa kanjo.” ");
INSERT INTO amp_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Jisasr kfo memor, “Fitoh yimar na hikhato womm kfo nuhas kangrm, ‘Na Jisasr hiket yimaya,’ na kfiwanko, inji kfo nriyafet yimar kto nanhu Yifemrpno kfo miruha, ‘Ndar yimar na hikwa yimayer.’ ");
INSERT INTO amp_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","To fitoh yimar wommpno rhuhato na mong trohrahra, tawo na hefenr yorhwa Yifemrhu nyingahato mong trohruhanr. ");
INSERT INTO amp_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Na niamohat mirahko duka amanyom ka bi gbhur hnamorr. Nhai. Na nhai gbhurn hnarmoya. Nann yahrt hnamoya. ");
INSERT INTO amp_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Na ndar bbinysoft niahato yimam hikwotma, arihat htirahko, yinemr sinyahato yifemr yiho hathurahrr. Yo yinemt sinyahato mmemt yiho hathurahtt. Yimborem tuhant sinyahato yimboremt yiho hathurahtt. ");
INSERT INTO amp_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tum yima ripha tehfim tum yiho nahathurahm. ");
INSERT INTO amp_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Yimar turhu yifammafn bro dukefr yihato tfit na be inji psirnano kakitohwora, nd yimar nhai nanhu yimatr tohruhatr. Yo fitoh yimar turhu yinemri yinemtn rorhu bro dukefr yorhwarn na be psirnano kakitohwora, nd yimar nhai nanhu yimatr tohruhatr. ");
INSERT INTO amp_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Yo yimar nhai rorhu bgre mis titahato yau hik hnekahra, nd yimar nhai nanhu yimatr tohruhatr. ");
INSERT INTO amp_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Fitoh yimar ndar bbinysofthu toh marnya nmbuharpat dukahato ndrpat fakitohr, kto nd toh marnya nmbuhat tfit hti hambrafrahrt. To fitoh yimar na dukahato ndar bbinysofthu toh marnya nmbuhat nhai dukarfort, nd yimar arihat yo kto niayuk yiham, rorhu toheft be toh marnya hany swanho hanyrahr. ");
INSERT INTO amp_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Niko nanhu disaiperko, frohr kunyko tamoh nakuyekworko, nd yimar nann nakuyekwor. Yo frohr na kunyko nakuyekwora, nd yimar na kfo tkrurafyuk Bro Yifemrn nakuyekwor. ");
INSERT INTO amp_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Wom yimar wom profetr htihato kfo kangr, ‘Nd yimar profet hingrneft tohwa yimayer. Kunyko nakuya-kruhanr.’ Inji dukahato nakuyekrr, nd yimar Bro Nkifrar profetm ttha hany shombat, rom yakyuk tamohm ror rpat yakrahmm. Yo wom yimar wom Bro Nkifrar hiket yimar htihato kangr, ‘Nd yimar Bro Nkifrar hikwor. Kunyko nakuyakruhanr.’ Inji dukahato nakuyekrr, nd yimar Bro Nkifrar rorhu hiket yimam ttha hany shombat, rom yakyuk tamohm ror rpat yakrahmm. ");
INSERT INTO amp_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Yo na kfo mifwanko, fitoh yimar ndar nanhu yufapa duha disaiperm htihato kfo famur, ‘Ndm Jisasrhu disaiper yimayem.’ Inji htihato be gonng bupa furam hiyefirm, nd yimar tawo Bro Nkifrar ttharahrr.” ");
INSERT INTO amp_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jisasr turhu 12-pela disaiperm mrokfom he buganihato nd tkitt tfit htanyhato yimor. Nd Galili rhuyuk taunm yi htfashato Bro Nkifrarhu mrokfot kfo nuhas bonuhasmorm. ");
INSERT INTO amp_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Kraisr hingrnamoa hingrnefroh mrokfom Jon Baftaisr kalabus tohetrn wanyakmor. Wanyakhato tu Jonrhu wom disaiperm kfo tkrur memorm, ");
INSERT INTO amp_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","“Brorpno waiko. Waikahkomn wattiwon wamitwako, ‘Ka nd Bro Nkifrar kfo memo, “Wom yimar nierahr.” Ka mif ninn kfomor o ka womr nierahr?’” Be nd ttiwon nmbuhat yaknihato Jisasr mkfo ttiwonmomr. ");
INSERT INTO amp_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jisasr wanyhato kfo memorm, “Waikahkomn, Jonr wakfo nuhas bugatwakomr nd niko wanuka mrokfom yo htita nefm. ");
INSERT INTO amp_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nyinga kunyjetm tfit yukatohwa yuhat yo wura minysafetm marnyanita yuhat yo lepra yaketm marnyanita yuhat yo yimbhindang kihmniyetm marnyanita yuhat yo noheh yimam tfit sinyewa yuhat yo nd knbokroh rirhutayuk yimenm Bro Nkifrarhu gutnius mrokfot wanuka yuhat. Nd ndm wakfo nuhas bonuhastwakomr. ");
INSERT INTO amp_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Yo wakfo wamitwakomr, yimam na niwa nefm htihato rpa dukefrpar rhuhato duka kangm, ‘Nd ror niwa nefm tu yafothet nefm newur.’ Ndhtet dukefm duket yimam Bro Nkifrar toh hongmb hmbrerahrm.” ");
INSERT INTO amp_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Be nd yimam yimom. Yimotm, rroh mongkorn Jonrhu mrokfom yakhato kfo pthamorm. Kfo memorm, “Niko nungur tik furat yihato Jonr htimohate tamoh dukefmn memoko, ai ahtinomr? Ka memoko, nd wifort yihomakni myaknita yuworhur, ai ahtinom? ");
INSERT INTO amp_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","O be nd bro marufa kfet hifa hifa wondh wuska hmbreyet yimar memoko, ai ahtinom? Nd hifa hifa wondh wuskam hmbreyet yimar, kingroh kuny kmifam tohwa yimayer. ");
INSERT INTO amp_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","To nikome to tamohroh htit yimoko? Profetrhu htit yimoko? Akfoyanko, ror hingrnewa profet hingrneft nndo kitt. ");
INSERT INTO amp_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","To nd Bro Nkifrarhu rfa borngt kfiwut, ‘Ninhu yi mrokfefthu kfo nuhas hanyuk yimar bi kfo tkruraf hanyrhotanr bi rorn tohak hanyhato mrokfot bi kfo hanyrahrt. Rorn bi tohak hanyhato yihotar bi yau mngon hanyrahrr.’ Nd mrokfot kfomo yimar, to Jonr. ");
INSERT INTO amp_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ndnettn na kfiwanko, Jon Baftaisrhu yufat be tu broye. Nhai wom yima mif thetr Jonrhu yufat kanjo ndar bbinysoft tohrmor. To tfit kfiwanko, fitoh yimarn tu hefenrhu kingdomkfot ftohr, tor nd yimarn tu bro yufa mift yakrahr. ");
INSERT INTO amp_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","13","Jon Baftaisr tafi mfnah duha, Mosesri profetm hefenrhu kingdo-mkfothu mrokfot ptha nuhas hnamomm. Ptha nuhas hnamomn Jon Baftaisr mfnahmor. Jon Baftaisr mfnahhato yihotar fau mngon hanymorr. Tfit nd yiharn namburet yimam rim toh rafakmomt hefenrhu kingdomkfothu nia yuhat. ");
INSERT INTO amp_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nd nkifra mrokfot bi nkifra profetm kfo memo Iraijar tfit nierahr, nd mrokfot to Jonrn kfomot. Jonrn bi nia twanhomor. To kangko, nd mrokfot awany yakionomt, nhai mrokfom. ");
INSERT INTO amp_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Yimbhindangeteko, ndar na kfiwa mrokfot wanykfot. ");
INSERT INTO amp_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Ar yiharhof yimam niwa nefme tamohm akfo nhombrayanm? Akfoya yon mumenm niwa nefm newum. Maket swirm o wumt swirm yonm htitwokomm. Wom yonm mano rirhuhato womm rikfiwumm, ");
INSERT INTO amp_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nom tuhan yindariroh niyak tatrut yiha wumtwa musikkfot wumtnomt, niko nhai grharfoko. Nur windohm mayi nmbuhampno rpat windohnomm, niko nhai nurrfoko.’ Inji yon mumenm kanjo nnakfo nnakfiwum. ");
INSERT INTO amp_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jon Baftaisr nia tohmohat, nhai nuwa yehato kfo bruttnarmoar. Nuwa kurhato Bro Nkifrarpar kfo bruttnamour. Yo nhai spaket drinkfot yarmoar. Yimam inji htihato kfo memoum, ‘Kmi yarhm fknayetrn nuwa kurhato kfo bruttnewur.’ Inji kfomomr. ");
INSERT INTO amp_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tfit ar yihat na nikmoh tu Bro Najema niamohat, bupa nuwa yewota, tfit yimam ndt htihato tfit kfo kangm, ‘Wahtiko nd yimar nuwa yemungrofoter yo spaket drinkfot masat hmbritarn spakwor. Yo takis yekwa yimami fasoh nefm niwa yimampno nabnot habriwur.’ Inji inji kfiwuma. Bro Nkifrarhu duka tungunefrn tamoh tamoh nefm mhfnahnewatrm, nd tkittn yimam htihato kfo kangm yafotheter nd rorhu dukefr.” ");
INSERT INTO amp_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Boknambok taunm Jisasr bok mirakerkfom fak nuhas hnamourm. Rom inji htimoahat nhai yima yuhum yak kekutrmoam. Ndnatn nd taunroh yimam Jisasr kfo huttmorm. ");
INSERT INTO amp_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Kfo memor, “O ar Korasin thofenko, finji rhu bebhirhokma? Yo niko Betsaida thofenko, niko inji buga. Finji rhu bebhirhokma? Bro yuhuwaf nmbuhat korhtko. Bi wom yimar Tairti Saidont aikahrn mirakerkfot ahingrnart, na nikompno mirakerkfot hingrnamo kanjo, na kanga ka Tair thofmi Saidon thofm tum nayuk fasoh fasoh nefm hti bebhato bi bek tham tabhutanihato yuhun brasingm rhuhato yima yuhum bi yak kekutrmomm. ");
INSERT INTO amp_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ndnatn na kfiwanko, kto bro kotkfot tohruha yihart, Tair thofmi Saidon thofmne bro yuhuwafeft htarahr. Nikome be inji. ");
INSERT INTO amp_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Yo niko Kaperneam thofko, kangko, ‘Ka yura mount muhrahnom?’ Nhai. Niko nndo helko riyahkonwe. Wom yimar na nikompno mirakerkfot hingrnamo kanjo Sodomt mirakerkfot ahingrnart, na kanga ka Sodomt nhai batirfott. Nhai. Rhurfot. ");
INSERT INTO amp_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ndnatn na kfiwanko, kto bro kotkfot tohruha yihart, Sodomtn tu bro yuhuwafeft htarahr. Nikome be inji.” ");
INSERT INTO amp_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jisasr inji pthanihato Bro Nkifrarpno kfo bruttna memor, “Dajaye, ni nda mounti bbinysoft buriwa Nkifraye. Ni tu hifa dborioh nefm namo. Ni namo nefm hifa nhai nd bro duka tungunet yimampno narmotnm htirmomm. Nhai. Yon mumenmpno namotnm romn htimomm ni namo nefm. Ndnatn na kfo yindhorwann. ");
INSERT INTO amp_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","To Bro Nkifraye, nd nefm ni inji namohat ni tunhu duka yima yuhur inji namo.” ");
INSERT INTO amp_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Nanhu Yifemr bi nanhu tirmn tamoh tamohm bi hta bugamorm. To nhai wom yimar nd Bro Yifemrhu Yonr hti mikahr, ‘Arr ka Bro Yifemrhu Yoner.’ Nhai. Tu Bro Yifemrpar tawisafworr. Yo nhai wom yimar nd Yonrhu Yifemr hti mikahr, ‘Ndr ka rorhu Yifemer.’ Nhai. Tu Yinem yonrpar turhu Yifemr tawisafworr. Yo fitoh yimam bi tu Yinemrn bi kfo nuhas famurm, ‘Ndr nanhu Yifemer,’ tom nd yimarpam tawisafwomr nd Yonrhu Yifemr. ");
INSERT INTO amp_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Niko yimako bro krhopam tita hasohato bi minysaf bugiwako, nanpno wania bugakahkomn rhu witarahko. ");
INSERT INTO amp_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Na wayakko. Na yakkahkomn nann nikmoh doh mfhar atohhiyanko. Nann doh mfhar tohhato yak nuhasaf hanyruhanko. Nann htiyaf hanykfot. Tamoh tamoh nefm na noh hmbre yima yuhurpno niwanm. Nanpno yihato nann doh mfhar tohruhanr, niko nhai wom tamoh dukefm yakruhatko. Nhai. ");
INSERT INTO amp_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Na doh mfhar tohneft dohr be yi furarahr. Nhai wom tamohmpno mrhutaruhatr.” ");
INSERT INTO amp_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Wom yiha, Judam rhu krnamoa bro Sabat yihar, Jisasr wit swirm htamo yuhamn fau hanymor. Rorhu disaiperm yatinoh hanyhato nd wit swirroh wit dmm yak tmbhakni hanymoamm fi hanymoumm. ");
INSERT INTO amp_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Farisim inji htihato Jisasr kfo memomr, “Tamohmpno inji nem? Bro Nkifrarhu thfa mntwat inji kfiwut, rhu krna Sabat yiha nhai ndpa ndpam tmbhakkfot.” ");
INSERT INTO amp_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jisasr inji wanyhato kfo memorm, “Nikone Defitri wom yimam yatinoht rhu hasohato nkifra temperr rim htayet nuwa rikat rim yakhato yamo nmbuhathu tndhte, ka htitkomt o nhai? ");
INSERT INTO amp_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Defitr to Bro Nkifrarhu temperr fknenihato nuwa rikat bi Bro Nkifrarhu yufatpno rim htayukt rimakmortn, briahako turhu yaunho habriyuk yimampno rim htahato famomt. Nuwa rikat bi Nkifrarhu yufatpno rim htayukt nhai be wom yima furam ye wonakrmomt. Tu prisrpam fiyakmomt. ");
INSERT INTO amp_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Yo niko ka htitkomt prism Sabat yiha boririfhut hikhato Bro Nkifrarhu temperr yihato tu prisroh hingrnefm hingrniwa yuhat? Nd Sabat yiha nd prism yi hingrnawohat, to finji niwam? Mrokfetm rhuwom? Nhai. ");
INSERT INTO amp_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Na kfiwanko, nd niko kfiwa Bro Nkifrarhu temperrhu nkifra hingrneft ndt be yura kak wunanimoumt. To kfiwanko, tor wom yimar, tu Bro Nkifrarhu temperrhu hingrneft yakitohwa yimar, tor tukompno brbo tohwor. ");
INSERT INTO amp_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Bro Nkifrarhu rfa borngt wom mrokfot korht. Nd mrokfot kfo kangt, ‘Na nhai hti wofnkahanko nd niko tarioh mtha fura bofurewohat. Yima yuhuwafwa nmbuhatn hti wofnwanko.’ Nd mrokfothu yimbu yuhat ayakkomt, to nhai fasoh nefm naduhat yimampno ndhtet mrokfom turmotkomm. ");
INSERT INTO amp_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Wawanyko, na nikmoh Bro Najomann nd rhu krna yihar kakitohwanr. Nd yihar kanga finji anaya, nhai tfit wom yima furar kfo htakfot.” Ndnatn nd Jisasrom namo neft nhai fasoh neft narmom. ");
INSERT INTO amp_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jisasr nd kmit htanyhato tfit Judam rhu rifinyhato kfo bruttnamoa rmontn fknenimor. ");
INSERT INTO amp_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","To nd kunysn wom tir gram tip behohet yimar rhumor. Ndhtet dbohnet yimam Jisasr fak marnyamourm. Ndnettn wom yimam rhuhato memom, “Afo was tiwonrahnomr. Sabat yiha yak marnyarahrr o nhai.” Nd dukeftpno kfo ttiwon memomr, “Ka Sabat yiha yimam yak marnyanefte ka hifan o nhai?” ");
INSERT INTO amp_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jisasr inji wanyhato kfo memorm, “Ni wom yima sifsifetnn ninhu wom sifsifr nd rhu krna Sabat yiha muht yohnerfohat, ka be afo hti marsisa htarfonr? Nhai. Miyakrfonr. ");
INSERT INTO amp_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Yimar tamoh foh yaurn be nyingarpaye hti marsisa hasokfot, yimayer. Nhai wom kfo rafo mrokfot rhukaht yimam Sabat yiha yak marnyaneft.” ");
INSERT INTO amp_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Inji kfonihato nd tir gram tip behohet yimar kfo memorr, “Tir gram tipt wathu susnant.” Thu susnamotrt marnyanimotr. ");
INSERT INTO amp_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Be nd kunys rhuyuk Farisim inji wahti tanymohat nhai wom warhurmom. Be fnahni twanhomom. Fnahnihato Jisasrhu wasyuk mrokfot rim haruhaknimom. ");
INSERT INTO amp_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jisasrhu was mrokfot Farisim yiro yiro kfo habofknetamohat Jisasr bi htimorm. Jisasr inji htihato nd kmit htanyhato yimor. Ror yimohat bok met yindarim ror yimo yuhat hikaknimomr. Nd yimam dbohnet bugamn rroh dbohnefm fak thu bugamorm. ");
INSERT INTO amp_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Dbohnefm yak thu buganimormn kfo memorm, “Na dbohnefm yak thuhat, mirahko wommpno akfo srhnom.” ");
INSERT INTO amp_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Nd mrokfeft Jisasr kfomohat Bro Nkifrar profet Aisaiarpno kfomo mrokfotn rhu hikmot. Kfo memor, ");
INSERT INTO amp_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ndarr nanhu hingrna yimayer. Na tuka kfo htamoyanr. Rorn hti yindhorhato nanhu yima yuhur rorpno korhr. Nanhu Yafothar thu nawohruhattr, kmi kmim tohwa yima tangim kfo nuhas hany mirahrm, ‘Bro Nkifrar bi kak yibonworko.’ ");
INSERT INTO amp_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ror nia thoft nhai yimampno nakfo hamuhruhatr, nhai thfa yaginyaruhatr. Nhai kmimn o yihotamn yihom het grhak mhet grhakruhatr. ");
INSERT INTO amp_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Yimam be suhr suhr yitam nhai be nyingarpaye yukatoh hasoruhatrm. Nhai. Rorn yak kasinyaruharmn tpi hirahrm. ");
INSERT INTO amp_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Yima tangiroh dukefm rorrpar yihato rorrpar yukatoh gari haso hakurahm rroh rhu nmbuhathu yak marnyaneft.” ");
INSERT INTO amp_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nd yiha wom yarhr fknayet yimar Jisasrpno hnamomr. Nd yimar tngt foukihmotr yo nyingam kunyjmomr. Jisasrpno hnamotmr, Jisasr yak marnyamotrr nd yimar tfit fukatohmor yo pthamor. ");
INSERT INTO amp_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Yimam inji htihato tuha mrokfo duhatm rhumom. Tum nattiwon nattiwonmoum, “Ndar yimare kane, nd Defit frikefthu Yoner?” ");
INSERT INTO amp_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Farisim inji wanyhato kfo memom, “Nd yimar yarhroh bro tohak Belseburrhu bbukeftpno kak thuworm kmi yarhm.” ");
INSERT INTO amp_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jisasr bi htimorm rom inji dukamohat. Htihato kfo memorm, “Rpa kantrikfot tohyuk yimam buha nayak mkuhato rim toh mtohhato nnaknineft, be nd kantrikfot yohniraht. Nhai wom yimam tohruhatmt. Yo rpa taunt o rpa kunys tohyuk yimam nhaf inji. Tum nayak mkuhato nnayurneft, be nhai wom yimar tohruhatr. Be tum naye dborha nohhato yima duha tkitm rhurahm. ");
INSERT INTO amp_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Tndh yarh Satanr, nhaf to inji buga. Nd tndh yarhr sinyahato wom yarhm yak thuneft, be nhai wom yarhm tohruhatm. ");
INSERT INTO amp_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Nikmoh wom yimam Bro Nkifrarhu yufatpno kmi yarhm yak thu thoft, nhai kfo mekahkomm, ‘Tndhrhu yufatpno kmi yarhm kak thuwomm.’ Nhai. To tamohmpno na Bro Nkifrarhu yufatpno kmi yarhm yak thuwohat, kfo yamukako, ‘Tndhrhu yufatpno kmi yarhm kak thuworm?’ Nikmoh yimatm kfo mirahmko, ‘Kfo furewuko.’ ");
INSERT INTO amp_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Htikfot. Bro Nkifrarhu bbukeftpno kmi yarhm kak thuwanm, waduka wamitwako, Bro Nkifrarhu kingdomkfot bi asot nompno. ");
INSERT INTO amp_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Nhai wom yimar wom nanyjar nngrajohet yimarhu kunys fknenihato yimar rhu hany rorhu kunys rhuyuk wuskam myaknihekfot. Afo nd kuny sikatr tir wuram kisahato ee btn rorhu kunyshu rhuyuk wuskam yaknikfot. ");
INSERT INTO amp_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Yimar be buha tohhato nanhu tamoh tamoh nefm be nyingarpaye kukatohworm, nd yimar nhai nann tohnho yibonkahr. Womrn tohnho yibonwor. Yimar nhai nann hingrnanhokahr yimaroh yakhato Bro Nkifrarpno hanyneft, tor nd yimarn mis yakhato tabohikworm. ");
INSERT INTO amp_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kfo mifwanko. Bro Nkifrar duka mmorahrm yimam nayuk fasoh fasoh nefm yo tamoh mrokfo bebm tnge pthayukm. To fitoh yimar na Bro Nkifrarhu Yafothathu bbukeftpno hingrneta kfo famur, ‘Fasoh tndhrhu bbukeftpno hingrnewur,’ nd yimar nhai tfit kfo gbhuruhatrt, be Bro Nkifrar nhai duka mmoruhatrm nd yimar kfoyuk tngt. Nhai. ");
INSERT INTO amp_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Fitoh yimar na Bro Najema hingrnayuk hingrneft htihato kangr, ‘Nd yimar nhai fipet hingrneft hingrnakahr,’ inji kfoyuk yimar Bro Nkifrarpno tfit kfo gbhukfot. Ndnatn nhai be kfongt duka hanyruhatrt ror pthayuk tngt. Nhai. Duka mmorahrt. To fitoh yimar na Bro Nkifrarhu Yafothathu bbukeftpno hingrneta kfo famur, ‘Fasoh tndhrhu bbukeftpno hingrnewur,’ nd yimar nhai tfit kfo gbuhruhatrt, be Bro Nkifrar nhai duka mmoruhatrt nd yimar kfoyuk tngt. Duka hatohrahrt.” ");
INSERT INTO amp_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Hifa sinya warho marnyet mis hifa yukham hirwomt. Fasoh sinya warho marnya duha mis fasoh yukha behohm hirwomt. Yimam yukhamn hti nhtewum. Yukham hifayem, kangm ee nd mis tu hifa dborioh miyet. Yukham fasohem, kangm o nd mis fasoh nnariyet miyet. ");
INSERT INTO amp_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Arom ruhetmo, yima yuhur rhuyuk tamoh tamoh mrokfo rifhur tfit tngtn ptha nriyafwotm. Ndnettn niko, fasoh yima yuhetko, nhai tu hifa dborioh mrokfom mfrfnahkahmko. ");
INSERT INTO amp_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Yimar, tu hifa dborioh yima rifuhetr, tu hifa mrokfo rifhur, tu hifa dborioh nefm mfrfnahnewumr. Fasoh yima yuhetr fasoh fasoh nefm mfrfnahnewumr. ");
INSERT INTO amp_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","To kfiwanko, nd bro kotkfot yakitohruha yiha, nd yiha nd yimam tubatu fura bofuriwa mrokfom kfo ptha hik bugarahmm. ");
INSERT INTO amp_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tuko bi kfoyuk mrokfomn Bro Nkifrar tfit yakruharn yak nhta hti kotha inji naruharmn, kfo mirahr, ‘Ni kfomo mrokfot krhonitatt, ni mrokfete. Ni womn kfoyuk mrokfot nhai krhonikaht. Ndnettn ni nhai mrokfo duhate.’” ");
INSERT INTO amp_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Boririfhu mrokfothu wom tisam yo Farisim yihato Jisasrpno mkfo memom, “Jisase, wom bro mirakerkfot wanakahtn nom htiruhanomn mirahnom, ‘Awi tu yafotheter.’” ");
INSERT INTO amp_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jisasr inji wanyhato kfo memor, “Ar yihofrhof fasoh net yimam Bro Nkifrar yafhohato to be kfo kangm, ‘Mirakerkfot htihato ee bt kfo mirahnom tu Bro Nkifrarhu bbukeftpno hingrnewur.’ Inji kfiwotma to na finji kanjohot mirakerkfot hingrnarhota ndtn htiruham? Kangm, ‘Mirakerkfot ahtinom,’ profet Jonar hingrnamo mirakerkforpat hingrnarhota ndt htirahm. ");
INSERT INTO amp_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Jonar husfirpa marmi husfirpa yifungm bro kmi tndh yirarhu yatitn rhumor. Bro Najomr to inji narahr. Ndar bbinysofthu rifhutn yohniruharn, husfirpa marmi husfirpa yifungm tohrahr. ");
INSERT INTO amp_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Bro Nkifrar kot yakitohruha yiha Ninifa thofmn mtohruhamn kfo nriyafhirahmm niko ariharhof yimako niwa nefm. Rom bi fasoh nefm mong trohmomm Jonar Ninifat yihato Bro Nkifrarhu mrokfot kfo pthamo yiha. To kfiwanko, tor wom yimar, tu bro mrokfo ptha rifhur harhuwa yimar, tor tukompno brbo tohwor. ");
INSERT INTO amp_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Kto kot tohruha yiharn sautko tohyuk kwint sinyaruhatn tfit rotn tohhato ariharhof yimaroh fasoh nefm kfo nriyafhirahtm. Nd kwint tu bbinysofthu wuroh krayeft tohhato wanymot Solomonrhu hifa hifa riduka aduka yima yuhum. Wanyhato memot, ‘Afo yirhoyann htiruha rorhu duka yima yuhur.’ To kfiwanko, Solomonrhu riduka aduka yima yuhur nhai be mfro rim dukata mdukatarmor. To tor wom yimar asor brbo tohwor. Rorhu dukefrn tu bro mifer. Riduka adukefr tu bro mifer.” ");
INSERT INTO amp_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Kmi yarhr wom yimarn hatoh haso kto wom yiha yak tuhafo thombat afo nd yarhr kitwor bupa duha tkittn. Yihato rhuyuk nfri tkitt hambro htfaswor. Frhambro hany frhambro hany nhai wom tkitt yakrfor, ");
INSERT INTO amp_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","tfit kfo kangr, ‘Nhai nanhu tohyuk tkitm. Tfit tuka toh tanymo yimarn yiruha.’ Yitarn mhtitworr nd yimarhu yima yuhur yak marnya bomarnyahato Bro Nkifrarhu Yafothat rhu duha brioh wutharn, ");
INSERT INTO amp_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","to be tfit yitarn wom 7-pelakfot miyekworm. Nd 7-pelakfot tu bro bro nefm hatonitm. Rompno mnathu hmbrenihato nd yimar rompno fknitmr. Rompno fknihato be nd yimar nhai ror tohmoa kanjo be wumtnano yikahr. Nhai. Tu nefm newur. Ndar yihofrhof fasoh net yimam, to be inji tu nefm na hakurahm.” ");
INSERT INTO amp_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jisasr yuhre ptha hanyetrn turhu mmemti nmem najohfit yi mfnahmom. Mfnahhato memom, “Jisasrpno naptharahnom.” Jisasr ror yiro kunys ruhetrn briahako tohmom. ");
INSERT INTO amp_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Wom yimar fknenihato Jisasr kfo memorr, “Ninhu mmemti nmem najohfit tom niem wom mrokfomn.” ");
INSERT INTO amp_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jisasr wanyhato kfo memorm, “Frohmn nanhu mmemroyem? Frohmn nanhu nmemroyem?” ");
INSERT INTO amp_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Jisasr turhu disaiperm riyak nuhas hanyhato kfo memor, “Asom, ar yimamn tom nanhu mmemt yo nmemrom. ");
INSERT INTO amp_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Yimam hefenr rhuwa nanhu Yifemrhu dukefr dukahato yak hikwam, tom nanhu mmemrom, mndaremrom, nmemrom.” ");
INSERT INTO amp_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nd yiharn Jisasr kunys htanyhato tek bari thmbt mirhumor. ");
INSERT INTO amp_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tek bari thmbt miruhetrn bok met yindars rifinyaknimom. Rifinyakni rifinyaknimotm Jisasr inji hti batihato sinyanimorn tek barit hiryuk mmbrtn mirhumor. Rom met yindars bari thmbt ritohmom. ");
INSERT INTO amp_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Bok mrokfom mmbrt rirhuhato rikfohemoahat, mrokfom be yura fafunamourm. Womt kfo memorm, “Wom yimar mswirt hingrnahato wit tpim yaknihato thu brur htfasmorm. ");
INSERT INTO amp_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Yihota tafont misuhyukm nungam yihato tout buganimomm. ");
INSERT INTO amp_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Wom tpim misuh hanymoum tahi siket tkitmn. Bbpam be htfapamn nd yewuri tpim yudbat dborhahato sinyamom. ");
INSERT INTO amp_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Tfit marr tahato tahi sikthu kkah nadbofnefrpno nd yewuri fanroh nembfam fftahato nohmom. ");
INSERT INTO amp_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Womm hig suhmpno misuh hanyukm rpat hig tofmpno sinyahato kihawot hmbriyafmomm. ");
INSERT INTO amp_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Nd tu hifa dborioh bbinysoft misuh hanyukm, romn tu hifa sinya marnyamomn yukha hir trukmom, wom dmm 100 hirmoum, wom dmm 60 hirmoum, wom dmm 30 hirmoum. ");
INSERT INTO amp_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yimar yimbhindangett, ndar na kfiwa mrokfot wanykfot.” ");
INSERT INTO amp_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Turhu disaiperm niahato ttiwon memomr, “Tamohmpno ni mrokfom yimam yahukohat be yura yafuni-wanm?” ");
INSERT INTO amp_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jisasr kfo memorm, “Wanukko, yafuna mrokforoh yakyuk dukefr bi nikomn hemor. Hefenrhu kingdomkfothu kafrohet mrokfom be kfo nhombra kanjo ptharahm o mrokfom be yura yafunarahm, nikomn dukefm bi yakrahkomm. Nikomn dukefm bi hemor. Womm nhai. ");
INSERT INTO amp_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Frohr nda yura yafunewa kafrohet mrokfom wanyhato yima yuhum fekr, nd yimar Bro Nkifrar tfit wom dukefm hirahrr. Frohr nd yura yafunayuk mrokfom nhai wom dukefenr yakrfor, nd yimarhu duka yima yuhur yak thurahrr. ");
INSERT INTO amp_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nd yimam rom nyingam kukatohwomm, to nhai tamohm htikahm. Yo yimbhindangetem, to mrokfom nhai wany hik marnyakahm. Nhai. Ndnetann kanga mrokfom tamoh tamohmn akfo nhombrakahta yima yuhum nhai yakruhatm. ");
INSERT INTO amp_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nd yimam dukefm yak duha yita nmbuhat to be Aisaiar kfomo mrokfo yuhatn kak hikwom. Aisaiar kfo memor, ‘Mrokfom, wanyrahko, wanyrahko, wanyrahko, to nhai wom dukefm yakruhatko. Nyingam yukatoh hakurahko, to nhai wom tamohm htiruhatko. ");
INSERT INTO amp_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","To tamohmpno kfo pthayuk mrokfom nhai wanyhato wom dukefm yakruhatko? Yo yukatohyuk nyingam nhai htiruhatko wom tamohm? Ndt nhai be sfno. Yimaroh yima yuhum nhai wom dborioh dukef duhatem. Wanyuk yimbhindangm bi be, bi kihmnimomm, yo yukatohyuk nyingam bi kunyj kihmomm. Nyingam akunyj duha yimm awi htirfom, yo yimbhindangm akihmni duha yimm awi wanyrfomn yima yuhum yakhato tfit nanpno niarfotm, yak marnyarfoyanm.’ ");
INSERT INTO amp_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","To niko wayindhortwako. Nikmoh nyingam htitwomm tamoh tamohm, yo yimbhindangm mrokfom wanukmm. ");
INSERT INTO amp_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Na kfo mifwanko, bingot boknambok profetmi Bro Nkifrar hiket yimam nd niko htita shrm memoum, ‘Ahtinom,’ to nhai. Nhai nd shrm htirmoamm. Yo nd niko arihat wanuka mrokfeft memoum, ‘Awanynom’, to nhai. Nhai nd mrokfot wanyrmoamt.” ");
INSERT INTO amp_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Jisasr kfo memorm, “Nd yewuri tpiroh kfo nhombra mrokfothu yimbu yuhat inji korht. ");
INSERT INTO amp_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Nd yewuri tpim yihota yau yuhatn misuhwam, ndm kfo nhombramoya yimam hefenrhu kingdomkfothu mrokfot wanyhato yima yuhum yak duha yihato tfit Tndhr niahato nd rroh yima yuhumn Bro Nkifrar htayuk mrokfot yak thuwa yuhat. ");
INSERT INTO amp_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Yo nd tahi sikroh yewuri tpim misuhhato dborha dimanditam, ndm kfo nhombramoya yimar afo barkofpam hifa yindhor nmbuhatpno yudbat Bro Nkifrarhu mrokfot mhik tefi yaknihato ");
INSERT INTO amp_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","tfit tamoh krhopam kekwomr, to be tfit wuyekwor. Wuyakhato bmbri kafho thuwort Bro Nkifrarhu mrokfot. ");
INSERT INTO amp_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Yo nd yewuri tpim hig suhmn misuhwam, ndm kfomot, yimar afo Bro Nkifrarhu mrokfot kekwort. Mrokfot yekwartn, tfit turhu toh nmbuhat, yo maru dukefrn, nd nd dukefm rim suhnitr, bibe. Nd mrokfot yiro mifrfnahnitt. Nhai sinyahato yukha hirkaht. ");
INSERT INTO amp_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Nd yewuri tpim tu dborioh bbinysoft sinyahato hirwam, ndt kfomot yimam mrokfot wanyhato wany duka tungunewamn, wom dmm hirwom 100, wom dmm hirwom 60, wom dmm hirwom 30.” ");
INSERT INTO amp_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jisasr tfit wom kfo nhombra mrokfot kfo memorm, “Hefenrhu kingdomkfot kangme yimar mswirt dborioh wit yukt frtrufmor. ");
INSERT INTO amp_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tfit yifungnano kmi thofm hweyetmn nd yimarhu yahr kmim yauyaknihato fasoh kipr bebroh tfam frtruf wuna fnahmomm nd dborioh witroh tpim frtrufmo tkitt. ");
INSERT INTO amp_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Wit gadent warho bugani ka yukha hirruha asha hti hanymomm nd fasoh fasoh kipr bebt rpat sinyamom. ");
INSERT INTO amp_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Be nd mswir tikatrhu hingrna yimam inji htihato mswir tikatrpno yihato kfo memomr, ‘Bro yimaye, nom memonom, ka witroh tpirpam frtrufmo. Tone nd nd kipr bebt rpat sinyewate fitoh yuhat niamot?’ ");
INSERT INTO amp_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Kfo memorm, ‘Yahr kmim ndhtet neft namom. Romn nd fasoh kipr bebthu tpim tfit frtruf wunamomm.’ Tfit nd hingrna yimam kfo ttiwon memomr, ‘Ni finji dukewa? Nd kipr bebt ka dbifr thurfonomt?’ ");
INSERT INTO amp_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Kfo memorm, ‘Woye, nheno! Mirahko ka kiprrpam dbifrwonom. Yewuri fanm bi hir yibon hanyetm rpat dbifr thurahkomm. ");
INSERT INTO amp_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Be inji rpat afo asinya hanym. Bi nd witroh yak yihayere, ee btn nd witroh yakyuk yimam kforhotanm kiprt dbundoruhamtn marrpno kaunyohato tfit manyruhammn manyet manyetmn hanyhato hta funarahmm. Kto nd witrpat yakhato htarahmt yeshrt htewa kunysn.’” ");
INSERT INTO amp_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jisasr tfit wom kfo nhombra mrokfot kfo memorm, “Hefenrhu kingdomkfot kangme tefi mastet tpiyenrn yimar yaknihato turhu mswirtn nuhterr. ");
INSERT INTO amp_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mastet tpiyenr kangme sayor tpiyener. Nd mastet tpiyenr frdborhahato yonmari bufum korhm. Kto nungam tkit tkiroht ndha niahato wuswomt.” ");
INSERT INTO amp_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Tfit wom kfo nhombra mrokfot kfo memorm, “Hefenrhu kingdomkfote kangme mettn bretpa hingrnayuk plauapami yispam rpat yaktk botk hmbrihato, kto tfit nd bretpat kur fannahato bropat rhuraht.” ");
INSERT INTO amp_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jisasrhu mrokfom kfo pthamoam nhai be kfo ptha mifrmoarm. Nhai. Be kfo nhombramourm. ");
INSERT INTO amp_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ror inji be kfo nhombra kanjo mrokfom kfo pthamoahat, to bingot profetr kfomo mrokfo yuhat hik twanhomot. Profetr bingot kfo memor, “Mrokfot kfo ptha thombat, be inji yura yafuna hakuruhanm mrokfom. Nd kfo yafuna mrokfom yimam nhai wany hnarmoam.” ");
INSERT INTO amp_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jisasr met yindarim htanymormn kunys fknenimor. Turhu disaiperm yihato ttiwonmomr, “Mswirt sinyayuk kipr bebthu mrokfo yimbu yuhate finji yorhwat? Afo wakfo hikkahtnt awanynom.” ");
INSERT INTO amp_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jisasr kfo memorm, “Hifa wit yukham frtrufwa yimar, ndr, Bro Nkifrarhu Yoner. ");
INSERT INTO amp_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Mswirt, nda bbinysofet. Hifa wit yukham, ndm, Bro Nkifrarhu kingdomkfot tohwa met yindariyem. Kipr bebt, ndm, Tndhrhu met yindariyem. ");
INSERT INTO amp_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Nd kipr bebt yak trufwa yimar, ndr Tndher. Yewurit yak wuriruha yihar, ndr ndar bbinysoft bnkaruha yihayer. Mswirthu hingrna yimam, ndm, mounmotem. ");
INSERT INTO amp_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Yimam fasoh kipr bebt yak nhafohhato kaht kandhi thuwa kanjo, inji narahm nda bbinysofthu wuroh kur tupoh yihar. ");
INSERT INTO amp_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Bro Nkifrar kfo tkrurruhatrm turhu mounmotm, romn yihato yak thurahmm nd fasoh fasoh nefm nayet yimam, yo yimam yak kasuhwa fasoh fasoh nefm. Nhai Bro Nkifrarhu kingdomkfot tohruhatm. ");
INSERT INTO amp_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Yakruhamm kaht turahmm. Kaht tohhato tau nknekrahm. ");
INSERT INTO amp_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nd yihart, dborioh yimam Bro Yifemrhu kingdomkfot tohhato rroh funeft hatoh thombat mirahm nndo marr tewur. Yimbhindangeteko, ndar na kfiwa mrokfot wanykfot.” ");
INSERT INTO amp_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jisasr wompam kfo memor, “Hefenrhu kingdomkfot kangme maru kptn wom yimar mswirtn tou yop kafrohmort. Kto wom yimar mswirt hingrna hanyhato tou yifkasakmort. Rorn nd maru kpt htihato tfit yak wuna marnyahato tou turna marnyamortn yimor. Nd maru kpthu dukefrpno ruhetrn rorhu tamoh tamoht yakmortn yimampno maruhampno yak tuknahato nd wuskaroh marut yakyukt nd maru kpt rhuyuk bbinysoft wiknamor. Be nd bbinysoft wiknamohat nd maru kpt nd bbinysoft ruhettn be ror fakmort.” ");
INSERT INTO amp_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Jisasr tfit wom kfot kfo memor, “Hefenrhu kingdomkfot kangme wunif wiknayuk yimar yi htfaswarn dborioh dborioh wunifm hambro htfaswor. ");
INSERT INTO amp_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Nd wunif wiknayuk yimar dborioh wunifr mhtineft, be mhti tanyhato nd wunifrhu dukefrn tfit yihato rorhu wuss tamoht maruhampno yak tuknahato nd wuskaroh marut yakyukt hanitartn nd dborioh wunifr wiknewurr.” ");
INSERT INTO amp_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jisasr wom kfo nhombra mrokfot kfomor. “Hefenrhu kingdomkfot kangme rugitn yimam tekt yak yiftm womhtet womhtet yirat mnaimt. ");
INSERT INTO amp_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Rugit bi furkihte, gmnt teh hawitewumt. Gmnt teh hawitahato kak dbothewumm. Dborioh dboriohrpam yakhato rikamn kmbritmm. Nd fasoh fasoht tubatutmt. ");
INSERT INTO amp_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ndar bbinysofthu wuroh yihar to be inji rhuraht. Mounmotm yawihneruhamn nd fasoh fasoh nefm nayet yimam yak thurahmm. Dborioh dborioh nefm nayet yimarpam rhurahm. ");
INSERT INTO amp_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Nd fasoh fasoh nefm nayet yimam yakruhamm kahtn turahmm. Kaht tohhato tau nknekrahm.” ");
INSERT INTO amp_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jisasr disaiperm kfo ttiwon memorm, “Nd kfo nhombriwa mrokforoh yimbu yuhame kekwokomm?” Kfo memomr, “Uwa, kekwonomm.” ");
INSERT INTO amp_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","To be Jisasr tfit kfo memorm, “To be ndnettn boririfhut yakitohwa tisar, ror bi hefenrhu kingdomkfothu kfo nuhas mrokfot bi wany hikhato bi yaketrn, kangme wom bro kunyrhu kuny sikater. Bi wom bro kunyrhu kuny sikatrn turhu kunyrhu rumr rhuyuk dborioh dborioh wuskar kak hfhan bugewurr. Yatket nfriyet kak hfhan bugewurr.” ");
INSERT INTO amp_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jisasr nd kfo nhombra mrokfom kfo nhombra tanyhato nd kmit htanyhato ");
INSERT INTO amp_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","yimor turhu kmitn. Turhu kmitn mfnahhato Judaroh rhu rifinyuk rmontn fknemor. Fknenihato Bro Nkifrarhu mrokfefm kfo nuhas bonuhasmorm. Nd kunys rhuyuk met yindarim rorhu mrokfefm wanyhato tuha mrokfo duhatm rhumom. Wanyhato kfo memom, “Nd yimare ndhtet dukefme fitha yakmorm? Yo nd ror hingrnewa mirakerkfome tamohtet tongr thu kihwatrr mirakerkfom hingrniwarm? ");
INSERT INTO amp_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nd yimar to wom kamdarhu yoner. Mariat tot rorhu mmemt. Jemsr, Josefr, Saimonr, Judasr, tom rorhu nmemrom. Asha frohm rorhu mmom? ");
INSERT INTO amp_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Rorhu mndaremrom to asom asha nompno tohwom. To nd yimare fitha nd bbukeft yakhato ndhtet nefm niwarm?” ");
INSERT INTO amp_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ndhtet dukefmpno nhai marimom, “Jisasr rihtirahnomr.” Nhai. Mong troh bugamomr. Jisasr inji htihato kfo memorm, “Bro Nkifrarhu profetrhu yufat bi kmi kmim rhu htfaswot. Turhu kmiti turhu kuny shofm, rompno nhai yufapa duhater.” ");
INSERT INTO amp_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Turhu kmit nhai wany yakiormomm rorhu mrokfom. Ndnetrn nhai bok mirakerkfom turhu kmit hingrnarmotr htirmomm. ");
INSERT INTO amp_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nd yihart Galilikorhof gafanar, rorhu yufat Herotr, wanymor Jisasr namoa nefm. ");
INSERT INTO amp_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Wanyhato rorhu hingrnayuk yimam kfo memorm, “Ndr Jon Baftais mifer. Na wasmohat, to bi tor, bi tfit sinyamor. Nd mirakerkfothu hingrnayuk bbukeft rorn sinyanihato hnamort.” ");
INSERT INTO amp_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","To bingot Herotr wom nmem Filifrhu tuhan Herodias yak hutfamohat, Jonrn kfo memorr, “Ndhtet neft nhai tu dborioh neft narmo. Nkifra thfa mntwat kfo kangt, ‘Mirahn womrhu mett ayak hutfayanr.’” Inji kfomotrr, wom yimam kfo tkrurafmotrm Jon Baftaisr fakmomr. Yakhato kalabus htamomr. ");
INSERT INTO amp_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Bi nd yiha Herotr bi memor Jonr bi awasanr. Kmi thofmn mfakrmiyakmor. Kmi thofm Jonr htimoumr profetr kanjo, ndnettn mfakrmiyakmorm. ");
INSERT INTO amp_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Herotrhu bet dekfotn bro yemro burwat htamort. Htamotrt Herodiashu yon mett fnahnihato grhamot. Herotr rothu grheft htihato hti yindhormort. ");
INSERT INTO amp_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Hti yindhorhato kfo memort, “Na kfo mif mifwann, ni tamohm kfo ttiwonrahna na be he mifruhann.” ");
INSERT INTO amp_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Be mmemt kfo kangtt, “Jon Baftaisrhu mfhathu yakneft wakfotwa.” Be inji wanyhato yimotn Herotrpno rim kfo memot, “Na kanga asomif Jon Baftaisrhu mfhat watmbhaknekahnt plettn wakmbrehiyafona.” ");
INSERT INTO amp_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","10","Be Herotr inji wanyhato be tuha mrokfo duhatr rhumor. Bi bro mrokfot kfo memort, “Tamoh tamohm ttiwonwona na nhai kfo wokrhotann hanyeft. Be he mif mifruhann.” Bi inji kfetrn to be rot Jonrhu mfhathu tmbhakhato hiyafneft kfomohat, nhai tfit wom kfo wokrmort. Ror nd yontpno napthamohat nd rhuyuk bro yimam bi wanymomr ror nd pthamohat. To be ndnetrn yimar kfo tkrur twanhomorr kalabus yihato soldiaroh yi mkfohato Jonrhu mfhathu tmbhaknaneft. ");
INSERT INTO amp_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Mfhat tmbhohato plettn kmbriyaknehato nd met tmahtn mhemom. Nd met tmaht nd yima mfhat yaknihato mmemtn rim hemot. ");
INSERT INTO amp_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tu Jonrhu disaiperm kalabus yimomn rorhu tfmbt rimakmomtn hany fopmomt. Yop tanyhato Jisasr yi mkfo nuhasmomr. ");
INSERT INTO amp_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jisasr Jon Baftaisrhu mfha tmbho yuhat wanyhato be mmbrt yaknimorn wom turpat tkittn yimor. Turpatm turhu disaiperrpampno yimom. To nhai. Met yindarim rorhu yi nmbuhat wanymomn turoh taunm htanyhato fau hambro hik hanymomr. ");
INSERT INTO amp_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jisasrom mtadbkafmomn nd yonmari yima rifhur mhtihato yuhuwafmorm. Mhti yuhuwafhato rroh dbohnefm fak thuhemorm. ");
INSERT INTO amp_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Jisasrhu disaiperm marr htiyaf hanyhato Jisasr mkfo memomr, “Marr bi yohnitr, ndart yima toh duha wom tkit furayet. Ndar rifinywa yimam wakfo tkrurafkahtnm anatubatunikahmn tumn yeshrim awikna htfaskahmn aye bmtam.” ");
INSERT INTO amp_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jisasr tfit kfo memorm, “Tamohmpno kfo tkruraforuhanomm? To nikomn yeshri wahekomm.” ");
INSERT INTO amp_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Tfit kfo memomr, “Nom tirfa bret nuwami hus yiraf, injirpa harhuwonom.” ");
INSERT INTO amp_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Kfo memorm, “Wahnakomm nd bretpami yiraf.” ");
INSERT INTO amp_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Jisasr nd rifinymo tuhant yindars kfo memorm, “Ndha kipr suhtn warhu hanyko.” Jisasr nd tirfa bret nuwami hus yiraf yakmorn, yura mountko yukatohhato kfo bruttnamor. Kfo bruttnanihato turhu disaiperm yak tifak hany hiyaf hanyhato kfo memorm, “Wahe nhombra htfas hanykomm.” ");
INSERT INTO amp_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nd he hanymo yeshrt nd yonmari yima rifhur yi hanysi yi hanysi nhai ye bugarmomm. Be nd yesmbhomo yeshrt tfit fak nhafohmomt. Yak nhafohhato hmbremohat, 12-pela kpm hmbremom. ");
INSERT INTO amp_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Nd bret nuwa yamo yimam, 5,000 yimam famomm. Nd thomnafat yindarirparohet. Metmi yonm nhai thomnarmomm. ");
INSERT INTO amp_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Be Jisasr yudbat turhu disaiperm kfo tkrur memorm, “Niko bi mmbrt wayaknikahkomn tek bari mkuko wahir hayukni hanyko. Na afo met yindarim yak kafho tanyruha.” ");
INSERT INTO amp_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Met yindarim yak kafho bugamormn, bi yi bugeme ee turpar kminysoft muhmor kfo bruttnaneft. Marr yohnimohat ror turpar yura kminysoft wutohmor. ");
INSERT INTO amp_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Nd mmbrt yiyukm bi wuringot rim hiretmn, wifortpno bro sikfot sinyahato sikfot yakmottt mmbrt memom nndo forpukhat tohwot. ");
INSERT INTO amp_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Tu wuroh ksfutn Jisasr yimor. Yura tektn fau hanymor. ");
INSERT INTO amp_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nd mmbrt rhuyuk yimam htiyakmomr yura tekt yau hnamotr tuha yafotha duhatm rhumom. Memom, ka tek yarhr niewur. Yakrmiyakhato tuha fengr fengrt tohmot. ");
INSERT INTO amp_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jisasr htihato kfo memorm, “Watoh bmtako. Naya. Ayakrmiwahko.” ");
INSERT INTO amp_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pitar Jisasrhu tngt wany nhtahato kfo memor, “Bro Nungothete, ni mifn rhu thombat, wakfokahtna na tekt yau hnehato ninpno nieruha.” ");
INSERT INTO amp_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jisasr kfo memor, “Wania.” Pitar sinyahato tekt mitohnihato memor, “Tek yuhat yau hanyhato Jisasrpno ka yiruha.” ");
INSERT INTO amp_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","To nhai, rorhu nyingam bro wifort hti yakrmihato bi yohni hany sitamor. Ndnetrn naku tti memor, “Bro Nungothete, wayakna.” ");
INSERT INTO amp_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yudbat Jisasr tir tuhato fakmorr. Jisasr kfo memorr, “Na kfo yamuhat wania, kane fak sminena? Kane nhai duka marifo, ‘Ror kfitr kita, tekt yau hanitohat nhai yohnitwota.’” ");
INSERT INTO amp_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Be inji kfonihato mmbrt mikmbremof. Mmbrt mikmbremof nd wifort tone tmbhomot. ");
INSERT INTO amp_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Yimam nd bot rhuyukm Jisasrpno rim tabokme rmonhato kfo memomr, “Ni tu Bro Nkifrarhu Yone.” ");
INSERT INTO amp_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Tek barit hir hayuknimomn Genesaret mkuko rim dbkafmom. ");
INSERT INTO amp_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nd Genesarethu yimam Jisasr nhai hti mmormomr. Htihato memom, to tawom Jisaser. Htihato mrokfot yudbat frhtfasmott nd brbo rhuyuk kmim. Jisasrhu yi mrokfot brborhof kmim wanyhato nd dbohnet dbohnet yimam hany bugamomm. ");
INSERT INTO amp_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Yihato dbohnetm kfo ttiwonmomr ror hmbreyuk hmbreshathu psifkorn be tayouti hanyhato dbohnefroh thu troh tany hanyneft. Be nd yuhat dbohnet yimam hikhato dbohnefm thu troh tany hanymomm. ");
INSERT INTO amp_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Wom Farisimi boririfhuthu tisam Jerusalemt htanyhato yimom Jisasrpno. Yihato kfo memomr, ");
INSERT INTO amp_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Tamohmpno ninhu disaiperm nhai hik duha yikahmt nmoh nkifram hayuk boririfhut? Nuwa ye shombat nhai tirm kifsafhato nuwa yekahm.” ");
INSERT INTO amp_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jisasr wanyaf hanyhato kfo memorm, “To tamohmpno tukmoh nkifram kfo yirmoh nuhasmo yirmoht hikwakomn Bro Nkifrar kfoyuk boririfhut nhai hik duha yikahkomt? ");
INSERT INTO amp_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Bro Nkifrar kfo memor, ‘Ni yifammafhu yinhitn rhuhato rofhu mrokfomn hikkfot,’ yo ‘Yimar turhu yifammaf kfo twewurf, nd yimar was hehur thukfot.’ ");
INSERT INTO amp_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Tfit nikomn kfo kangko, ‘Wom yimar turhu yifammafpno wuskam kfo nuhastahihato tfit yifammaf kfo famurf, “Nifn kfo nuhasheyuk wuskam bi Bro Nkifrar htahemoya,” ");
INSERT INTO amp_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","to be nd yimar mirahr tfit yifammaf adukakahann ayak marnyayanf.’ Tukmoh nkifram kfo htanihemo mrokfom yak hikwakomn Bro Nkifrarhu boririfhut nhai yak hik marnyakahkomt. Faso tfit kfo kekutwokomt. ");
INSERT INTO amp_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Niko mikfo nhehta mkfo nhehtayet yimayeko! Bingot profet Aisaiar to nikmoh nef mifmn kfomor, ror dkfo memohat, ");
INSERT INTO amp_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Nd yimam be yura tngrpaye kfo yuta yindhorwoma. Yiro yima yuhum nhai nanhu dukefmpno rhukahm. Nndo wom dukefmpno korhm. ");
INSERT INTO amp_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Be nd yima mifm bingot htamo boririfhut kfo nuhas htfaswamn kfo kangm, “Bro Nkifrarhu boririfuhet.” Ndnettn rom lotuta lotuyeft yafotha duhatet.’” ");
INSERT INTO amp_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Tfit Jisasr nd met yindarim nakuyakhato kfo memorm, “Nanhu mrokfefm wawany hik marnyatwa-komm. ");
INSERT INTO amp_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Tamoh tamoh mur yemrom o hnaru yemrom tng yuhat yiyafoyukm, nhai ndmn Bro Nkifrar htihato kfo mikahr, ‘Ni bi fasoh yimaye.’ Nhai. Nd yiro yima yuhurio sinyahato newa fasoh nefm, ndmn Bro Nkifrar htihato kfo kangr, ‘Ni bi fasoh yimaye.’” ");
INSERT INTO amp_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Kto disaiperm yihato Jisasr kfo memomr, “Farisim ni kfoyuk mrokfot wanyhato yima yuhum yikwohate wanukwonm?” ");
INSERT INTO amp_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Tfit Jisasrn kfo memor, “Nanhu Yifemr, hefenr tohwar, mswirthu yewurit turhu tire nuhta duhatt, be yuht yimbonetm teh dbifrak hanyrahrm. ");
INSERT INTO amp_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mirahko to niko Farisiroh mrofkom wanyhato bok dukefm ayaknom. Nd yimam tum nyinga kunyjmn kangm womm ayak hta bohtanom. Nyinga kunyjf nhai tuf nyinga kunyjf yihotat nayak nuhaskfot. Mirahf ka tu yihotat nayak nuhaswono rpat dmehetf muht yohnirahf.” ");
INSERT INTO amp_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pitar kfo memorr, “Tfit afo nd ni kfi mrokfothu yimbu yuhat wakfo hikkahtnt awanynom.” ");
INSERT INTO amp_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jisasr kfo memor, “Nikome ka yuhre mmoyeko? ");
INSERT INTO amp_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Wawanyko! Nd yiyafoyuk yeshrt nhai yima yuhurn yikahm. Nhai. Nd yiyefiwa yeshrim nyungram yuhat yitamn ript yihom yorhwom. Ript yihom rhuhato kto tfit rikunys kitm. ");
INSERT INTO amp_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nd yiro yima yuhurio sinyahato newa fasoh nefm, ndmn Bro Nkifrar htihato kfo kangr, ‘Fasoh yimayer.’ ");
INSERT INTO amp_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nd na kfiwa yima yuhur sinyewa fasoh nefm, ndm inji korhm: nd fasoh fasoh dukefr, yimar nambur sinyahato womr was furaneft, womrhu mettpno rim fnahneft, yaum kanjo met yindarim niwa nefm, rikohneft, wom mrokfom be turoh yima yuhurn wakfo fura bofurakneft, womm faso faso harhu htfasneft. ");
INSERT INTO amp_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Tom nd nd nefmn yiro yima yuhurnio sinyewamn Bro Nkifrar htihato kfo kangr, ‘Fasoh yimayer.’ Nd nuwa yenyihato tir kifsa duha rhuneft nhai Bro Nkifrar htihato kfo mikahr, ‘Fasoh yimayer.’” ");
INSERT INTO amp_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Be Jisasr nd kmit htanyhato tfit kmi Tair yo Saidon inji yimor. ");
INSERT INTO amp_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nd ror yimoko wom Kenan efkott yihato kfo naku memot, “Bro Nungothete, Defit frikefthu yone! Wayuhuwafna. Fasoh yafotha bebm nanhu yont dbohneft kahukmt.” ");
INSERT INTO amp_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jisasr be wanymortn nhai wom mrokfom kfo ptharmort. Tfit turhu disaiperm yihato kfo memomr, “Nd mett be mfro naku hik hnewutnom. Wakfafkahtnt wuri ais.” ");
INSERT INTO amp_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jisasr kfo memorm, “Bro Nkifrar na kfo tkrurafmohat, Isrerrparoh dukeftn kfo tkrurafmora. Rom bi sifsifm kanjo frfnah wurasohmom. Rroh yak nhafoht niamoya.” ");
INSERT INTO amp_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Jisasr kfo pthamo mrokfot rot wanymott. To nhai. Rot mfrfnahnehato Jisasrhu nyingatikko bangum myuknamotmn nyingatikt bbinysoft yohnehato kfo memotr, “Bro Nungothete, wahti dukana.” ");
INSERT INTO amp_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jisasr kfo memort, “Yonroh hayuk yeshrt nhai bi yakhato yaumn afo wahta hekahmn.” ");
INSERT INTO amp_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Tfitn nd mettn kfo memot, “Bro yimaye, ndt rot hifat kfiwun. To nhai. Nd yauyenm, tebor yinhit toh hanyukm, rom to nd yonm ye bruraf hanitam ke tuthatak hanitm.” ");
INSERT INTO amp_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Nd mett kfoyuk mrokfot kfo yakio memort, “Bar mete, na hingrnewa hingrneft, ni nhai hus dukeffpno rhuhato na niahato kfo ttiwonkahna. Ninhu dukeft nann bro dukeft htewun. Ndnettn ninhu yon metthu dbohneft bi be.” Be nd yiha rothu yon metthu dbohneft teh tmbhakmot. ");
INSERT INTO amp_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Be Jisasr ndhar htanymortn Galili thmb yuhat yimor. Yihato wom kmi yorgr muhhato mrhumor. ");
INSERT INTO amp_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kmi yorgr muh mruhetrn yima rifhur yi rifiny hmbremomr. Dbohnet dbohnet yimam hany hanymom. Womm rikiyem, womm nyinga kunyjetm, tir wura bebetm, womm tng mmkm, ndhtet ndhtet dohnefetm yo womhtet womhtet dbohnefetm rpat hanymomm. Hanymommn Jisasrhu wurampno rim hta rmonmomm. Jisasr htihato fak marnya hanymorm. ");
INSERT INTO amp_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Nd tng mmkm tfit pthamom, yo tir wura bebetm marnyamom, yo rikiyem tfit faumom, yo nyinga kunyjetm tfit fukatohmom. Nd rifinyuk yimam inji htihato tuha yafotha duhatm rhumom. Yafotha duhatm rhuhato Isrerroh Nkifrar kfo grhamomr. ");
INSERT INTO amp_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jisasr turhu disaiperm nakuyakhato kfo kangrm, “Nda yima rifhur yuhuwafwanm. Bi husfirpa marm nanpno tohromn bi yeshriyen duhatem. Nhai wofnkaha be yeshriyen yi tany duha sfno yatinohtn turoh kmiko yinyeft. Yatinoh hanyruhamn buha yihotamn mnoh minysafnirahm.” ");
INSERT INTO amp_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Tfit turhu disaiperm kfo memomr, “Ndashart nom yima toh duha tkitt tohwonom. To href fitha bok bretpam yekwanomn ndar yonmari yima rifhur yahukanomm?” ");
INSERT INTO amp_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jisasr tfit ttiwon memorm, “Nikome finji finji bretpam harhuwako?” Kfo memomr, “7-pela bretpami rpen rpen yirenm.” ");
INSERT INTO amp_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Be nd yima rifhur Jisasr kfomotrm tuha bbinysoftn sibosi rmonmom. ");
INSERT INTO amp_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Jisasr nd 7-pela bretpami rpen rpen yirenm yakmormn Bro Nkifrarko kfo bruttnanihato bretpam fak tif botifmorm yo yirenm fak mku bomkumorm. Tfit turhu disaiperm hemotr romn yaknihato nd met yindars hi hanymomm. ");
INSERT INTO amp_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nd yima rifhur fe furkih bugamom. Nd rom yesmbhoyuk yeshrim Jisasrhu disaiperm tfit yak nhafohhato hmbremohat 7-pela kpm hmbremom. ");
INSERT INTO amp_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Nd yeshrim yamo yimaroh thomnafat, 4,000. Ndt yindarirparoh thomnafayet, metmi yonm nhai thomnarmomm. ");
INSERT INTO amp_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jisasr nd yima rifhur kfo tkrurafhato yimotm, ror mmbrtn mikmbrenihato Magadan distrikko yimor. ");
INSERT INTO amp_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisimi Sadyusim yihato Jisasrpno yuwi mkfo memomr, “Jisase, mirakerkfot wahingrnakahtnt afo ahtinom. Nom htiruhanomn mirahnom, tu Bro Nkifrarhu bbukeftpno hingrnewur.” ");
INSERT INTO amp_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Jisasr kfo memorm, “Krif yiham marr miwondh marnyanitr, kfo kangko, yin yifungr tohwor. ");
INSERT INTO amp_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Dbha yiham mkinykr fnahwot, kfo kangko, hrek toh nyukuhwot. Yihathu rhu yuharpat hti nhtewakomn kfiwuko, to na ndar yiham tohhato niwa nefm nhai htihato yak nhtakahkomm. ");
INSERT INTO amp_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ariharhof yimam, be tu fasohem, nhai Bro Nkifrarhu yima yuhurn rhukahm. Rroh dukefm be kangm, nd Bro Nkifrar kfo tkrurafoyuk yimar mirakerkfot hingrnakahtr ndt htihato duka mirahnom, tor nd yimar. To nhai wom mirakerkfot htiruhatm. Nhai. Jonarpno rhumo kanjohot neft hti nhtarahm.” Be inji kfo tanyhato htanymorm. ");
INSERT INTO amp_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Jisasri disaiperm tek barit hir hayuknihato mkuko rim dbkafmom. To rom yimohat, disaiperm nhaf nhai dukarmom bretparoh hanyneft. ");
INSERT INTO amp_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yimomn Jisasr kfo memorm, “Niko Farisimi Sadyusiroh yispam hti marnyaf hanykfot.” ");
INSERT INTO amp_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Tfit tum rinakfo nakfo memom, “Ka nom bretpam yakna duha yitnom, ndnetrn nd mrokfot kfiwurnom.” ");
INSERT INTO amp_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jisasr bi wanymorm rom inji kfomoahat. Wanyaf hanyhato kfo memorm, “Barenko, tamohmpno kfo yamukako nhai bretpa duhatenom. Nane kak sminewukma tefi yeshriyenroh yak yurhtahato nd yimam hanyeft? ");
INSERT INTO amp_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Niko na hingrnewa hingrneft ka nhai tafi htikahkomt? Ka nhai htirmoko 5-pela bretparpam yak yurhtahato 5,000 yimampno yak nhtahato hemohat? Yo tfit yesmbhehm thomnayet kpmn niko hmbremohat? ");
INSERT INTO amp_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Yo womt ka nhai dukakahkomt 7-pela bretparpam yak yurhtahato 4,000 yimampno yak nhtahato hemohat? Yo nd yesmbhehm thomnet kpmn hmbremohat, nd ndm ka nhai htirmokomm? ");
INSERT INTO amp_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Famuko ka tu bret mifm kfiwurnome? Nhai bret mifmn kforfoyanko. Farisimi Sadyusiroh yisparoh kfo duka mrokfotn kfiyanko. Famuya yo hti marnyaf hanykfot rroh yispam.” ");
INSERT INTO amp_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Bi inji kfiwurme, ee dukefm yakhato kfo memom, “Nhai tu bretpa hingrnayuk yispa mifmn kforfornom. Farisimi Sadyusim hatone htfaswa mrokfothu kfo duka mrokfotn kfo famurnom, ‘Yo! Niko, tom ndhtet ndhtet yimam niewum niko dukefmpno rhukfot.’” ");
INSERT INTO amp_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jisasr Sisaria Filipaiko yihato ndharn disaiperm kfo ttiwon memorm, “Kmi thofm na Bro Najomanhu mrokfot wanukohat, kangm frohane?” ");
INSERT INTO amp_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Kfo memomr, “Womm kangm Jon Baftaise. Womm kangm Iraijaye. Womm kangm Jeremaiaye o nkifra thof profete.” ");
INSERT INTO amp_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Inji kfomotm, tfit ttiwon memorm, “To niko tuko finji dukewokma?” ");
INSERT INTO amp_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Saimon Pitar kfo memor, “Ni, bbinysof thofroh minrfa htiyakyuk yima Kraise. Ni, tu toh nkifraniruha Nkifrarhu Yone.” ");
INSERT INTO amp_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Jisasr kfo memorr, “Jonrhu yon Saimone, wayindhortwa. Nd mrokfot ni kfit, nhai ndar bbinysofthu wom yimar kfo merforn inji wakfotwa. Nhai. Nanhu Yifemr, hefenr tohwar, rorn dukefm yahutrn inji kfi. ");
INSERT INTO amp_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Pita, kfiwann, ni tahiye. Nd tahisn nanhu sioskfot kasinyaruhant. Nd tahisn sioskfot hatohruhatt, noheft nhai niahato yak kasuhruhattt. ");
INSERT INTO amp_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Hefenrhu kingdomkfothu kijibont hiruhann ninn yakitohrahnt. Ndar bbinysofthu tamoh tamoh nefm ni kfo raforahnm, tawo hefenrko Bro Nkifrar nd nefm kfo raforahrm. Ndar bbinysofthu tamoh tamoh nefm ni kfo yakiorahnm, tawo hefenrko Bro Nkifrar nd nefm kfo yakiorahrm.” ");
INSERT INTO amp_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Be Jisasr inji pthahato kfo memorm, “Yo! Mirahko mif mif womm akfo amanyomm, ‘Rorn Bro Nkifrar kfo tkrurafmor nmoh minrfa htiyakyuk yima Kraisr.’” ");
INSERT INTO amp_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nd yiha Jisasr disaiperm rikfo nuhasak memorm, “Nanhu nmbuhat akfo nuhasanko. Nanhu mrokfot inji korhwot. Na Jerusalemko yi shoft, na Judaroh bro yimamn, prisroh bro yimamn, boririfhuthu tisamn, nd nd yimaroh tirmn hirruha. Nohrhoyann tfit husfirpehyuk marrn tfit sinyaruha. Na nhai tfit finji kfo finji kforhota. Na be yi nohnefrpat.” ");
INSERT INTO amp_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pitar inji wanyhato Jisasr yaknihato nndo rim hatohhato kfo hutt memorr, “Bro Nungothete, nhai mif. Na nhai wofnkaha ndhtet mrokfom wanyneft.” ");
INSERT INTO amp_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Tfit Jisasr kekutnihato kfo memorr, “Satane, wuri wain. Ni nanhu yihotat toh rafiwun. Ni nhai Bro Nkifrarhu yima yuhur hikkahn. Nndo yima mifroh dukefm hikwo.” ");
INSERT INTO amp_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Be inji kfonihato kfo memorm, “Wom yimar kangr, na ahik hneya, mirahr tur amdukak hanya. Nd dukefr mong trohhato rorhu bgre mis titahato na hikkfot. ");
INSERT INTO amp_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Yimar turhu toh marnya nmbuharpat mdukak hanitr, nd toh nmbuhat ror mdukak hanitat nhai tfit wom htiruhatrt. Yimar na dukahato nhai turhu toh marnya nmbuharpat dukarfort, kto tfit htirahrt rorhu toh marnya nmbuhat. ");
INSERT INTO amp_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Wom yimar ndar bbinysofthu tamoh tamohrpar yakhato kto toh nkifrayuk toh nmbuhat nhai dukarfort, to nd ariha yekwa marut, wuskat, tamoh tamoht kto to finji hifa toh nkifra nmbuhat hiruhamr? Hifa toh nkifra nmbuhat kangr tfit ayakant, to tfit fitoh yuhatn yakruhart? ");
INSERT INTO amp_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Bro Najomr, turhu Yifemrhu bro bbukeftpno yawihnerahr turhu mounmotmpno. Nd yiha met yindarim turoh tohefm, o nefm, o hingrnefm, nd ndm htiyak hanyhato ttha hanyrahrm. ");
INSERT INTO amp_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Na kfo mifwanko, ndasha tohwa womm tafi afo noh duhatmn Bro Najomr king kanjo nia thoft htiyakrahmr.” ");
INSERT INTO amp_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Kto 6-pela yiham yinyimotm Jisasr Pitari Jemsre yo Jemsrhu nmem Jonr, nd husfirpa yimam yaknihato turpatm muhmom tu mfro wayakmo kminysoftn. ");
INSERT INTO amp_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Turpatm rhu hasohato asha htiyaf hanymomr fnhuyaknimor. Nyingatikt funamohat memom nndoh marrhu nukeftn kambohritnewut, yo yimar hmbremo hmbresham rpat fnhu bugaknihato memom nndo bruwohmr katiwur. ");
INSERT INTO amp_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ee tfit htimomf Moses Iraijarof Jisasrpno mtohhato pthaknimohat. ");
INSERT INTO amp_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pitar inji htihato Jisasr kfo memorr, “Bro yimaye, nmoh asha tohneft hifa. Finji dukiwa? Ka husfirpa kunyenm yimanom nhombrahato singoruha. Ninhu womt, Mosesrhu womt yo Iraijarhu womt.” ");
INSERT INTO amp_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pitar inji ptha hanymor wom gribfat yawihnehato kasi hmbremotm. Nd gribfat fnhu bugamot. Yiro nd gribfatn wom tngt niamot. Nd tngt kfo memot, “Ndarr nanhu Yoner. Be tu marbitn htewanr. Hifa hti yindhorwanr. Ror pthayuk mrokfom wany yakiokfot.” ");
INSERT INTO amp_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Disaiperm Bro Nkifrarhu tngt wanyhato tuha mfham danyr frtnehmomm. Yimam wutthakhato tuha suhhato nyingatikm bbinysofko yohnemomm. ");
INSERT INTO amp_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jisasr rompno brbo yiyaknihato kfo memorm, “Wasinyako. Ayakrmiwahko.” ");
INSERT INTO amp_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nyingatikm kekuthato yura wufukatohmom. Nhai wom frohm htirmom. Nhai. Jisasrpar htimom. ");
INSERT INTO amp_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Be nd kminysofr wuhtanyhato tfit mibrnyimom. Buha yihotatn kfo memorm, “Niko nd yura kminysoft htitawoneft bi mirahko womm akfo nuhasnom. Kto na Bro Najoma bi nohnihato tfit sinyeya, ee btn wakfo nuhastwakomm.” ");
INSERT INTO amp_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tfit disaiperm kfo ttiwon memomr, “Tamohmpno nkifra boririfhuthu tisam kfo yamukam, ‘Afo Iraijarn bi nia gungonrahr. Tfit kto Bro Nkifrar kfo tkrurafrahr nmoh minrfa htiyakyuk yima Kraisr.’” ");
INSERT INTO amp_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jisasr wanyhato kfo memorm, “Ndt tu kfo mif kfoyet. To nkifra kfot kfo memot, afo Iraijar bi nieruharn rorn nd tamoh tamohm bi yak hta bohtarahrm. ");
INSERT INTO amp_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","To tfit kfiwanko, Iraijar to bi niamor. Yimam nhai hti nhtarmomr. Bi niamotr yimam turoh dukefm hikhato faso faso fak bebmomr. Bro Najomr to inji narahmr.” ");
INSERT INTO amp_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jisasr inji kfomotr, disaiperm yima yuhum yakhato kfo memom, “Jon Baftaisrn kfiwur.” ");
INSERT INTO amp_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jisasri nd husfirpa disaiperm tfit yimomn nd rom kmi tpit wahtanymo yimampno minahtimom. Ndharn wom yimar yihato Jisasrpno bangum rim yuknahato ");
INSERT INTO amp_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","kfo memor, “Bro Nungothete, nanhu yonr wayuhu-wafhina. Fasoh noh mmrifeft yekwattr faso korhr. Wom yiham noh mmrifak-hato kahmn kitr tekmpno brbo toh hasonefm tekm kitr. ");
INSERT INTO amp_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ninhu disai-permpno kfo famuya, ‘Wayak thukomr yarhr.’ To nhai, fak thu titawomr.” ");
INSERT INTO amp_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jisasr nd mrokfot wanyhato kfo memorm, “Arom Bro Nkifrarhu dukefm rhu duha met yindariyenko, nikmoh dukefmi nikmoh nefm nhai be tu yi marnyakahm. Finji tfit nikompno tohrhoya? Finji tfit nikmoh krhopam titahirhoyanko? Wahnakomr nd yonr.” ");
INSERT INTO amp_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jisasr kfo namburhato kfo hutt hikafmotrr nd yarhr htanymorr nd yonr. Be nd yonrhu noh mmrifeft htanymotr. ");
INSERT INTO amp_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Kto disaiperm turpam Jisasrpno mnahtihato kfo ttiwon memomr, “Tamohmpno nd yarhr to nom yak thu duha yirfonomr?” ");
INSERT INTO amp_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Jisasr kfo memorm, “Nd yonr hatohyuk yarhr yak thukfot kfihat, nikmoh dukefm aduka mif mif ameko, ‘Bro Nkifrar kak thu mifworr nda yonr hatohwa yarhr.’ Dukefm inji yi mifhato akfoko, nd yarhr yak thurfokomr. Na kfo mifwanko, ndhtet dukefm be tu tefi dukefenr sayor tpiyenr kanjo rhuhato kfo mirahn, ‘Ndar kminysofe wasinyani nndo warim tohn.’ Htirahn nd kminysofr nndo rim tohrahr. Nhai wom tamohm duka nhiruhatn finjina finjina nefm.” ");
INSERT INTO amp_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Be nd kmit htanyhato Galiliko yimom. Nd kmit mfnahhato turhu disaiperm kfo memorm, “Ndar bbinysofthu yimam Bro Najomr yak hndhnarahmr yimampno. Hndhnaru-hatmr ");
INSERT INTO amp_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","yimam wasrahmr. Nohruharn husfirpehyuk marrn tfit sinyarahr.” Disaiperm inji wanyhato yima yuhum foh dbhurmomm. ");
INSERT INTO amp_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jisasri disaiperm bi Kaperneamt yihom fnahetmn, Bro Nkifrarhu temperrhu takis marut yak hnayuk yimam niamomn, Pitar mkfo ttiwon memomr, “Nikmoh tisare temperr hta hakuta takis maruhame hta hakutr?” ");
INSERT INTO amp_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pitar kfo memor, “Uwa, hta hakutr.” Pitar inji kfo tanyhato kuny yuhat rim fknenimor. Pitar tafi wom mrokfot kfo duha be tu Jisasrn sinyahato kfo ttiwon memor, “Saimon, ni finji dukewa? Ndar bbinysofthu kingm nd takis marut yak htfas thofte froh frohmpno yekwamt? Turoh kantri thofmpno o wom kantri thofmpno?” ");
INSERT INTO amp_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pitar kfo memorr, “Wom kantri thofmpno takis marut kekwom.” Jisasr tfit kfo memorr. “Wom nndoh kantrikfot niayuk yimampno takis marut yekwamn, ndnettn nhai turoh kantrithu yimam takis marut hekfot. ");
INSERT INTO amp_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Bariko wanjukahnn wathuthu htfasn. Barkof yirar furyakyukr, tngt wayak bhnakahnr, htirahnt maruhat tngt yiro rhuraht. Nd tngt rhuyuk maruhat, ninhu takis wiknayukti nanhu takis wiknayukt rhuraht. Wayaknikahnt ndtn nnoh yufat wahtatwa. Nd yimam htiruhamn rroh yima yuhum nhai faso yak bebruhatmno.” ");
INSERT INTO amp_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nd yiha disaiperm yihato kfo ttiwon memomr, “Hefenrhu kingdomkfot mfrpskena thombate, froh mifrn bro yufat yakhato mtohakruhart nd hefenrhu kingdomkfot?” ");
INSERT INTO amp_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jisasr wom habhi yonenr kfakhato rroh buha rim tohmotr, ");
INSERT INTO amp_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","kfo memorm, “Na kfo mifwanko, nikmoh nefm, tohefm tfit ndar yon kukenenrhu dukefmi tohefm yakhato rhukfot. Inji tohrahko, hefenrhu kingdomkfot fknirahko. ");
INSERT INTO amp_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Yimar turhu toh nmbuham o dukefm tfit yohnihato nda yonenr kanjo rhurahr, nd yimar hefenrhu kingdomkfot ror bro yufat yakhato tohrahr. ");
INSERT INTO amp_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Fitoh yimar na hikhato na hikwa wom met yindarim yakhato kak marnyewurm, nda yonenr yakhato yak marnyiwa kanjo, nd yimar nann yakhato kak marnyewur.” ");
INSERT INTO amp_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Wom yimar ndar na hikwa yonenm frnhehektrm fasoh nefm fsuhm, nd frnhehakyuk yimar bro tahis yakhato mohtpitn tmbrekhato tek dany yuhat yafhohato miptkokfot. Tohruharn fasoh yihotat hanyrahrm. ");
INSERT INTO amp_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Yima yuhum sinyarahmko fasoh nefroh naneft. Be wom yimarn niahato mkfo kangrn, ‘Ndur yuhat warine o ndur shrt warimakn.’ Nd yak tkruryuk yimar dukaf hanykfot. Bro Nkifrar be yak tutfarahrr. ");
INSERT INTO amp_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Tirt fasoh nefm hanittn, nd tirt tmbho thukfot. Rpa tirrpatpno rhuhato toh marnyarahnt ninhu toh nmbuhat. Hus tir bugaf rpat rhurahf, rofn yakruhafn kaht turahfn. Nd kaht nhai wom yiha minoh hmbreni hanykaht. Yo wurat inji newut, nhaf puk thuhato rpa wurarpatpno rhuhato toh marnyarahn. Hus wura bugaf rhurahf, rofn kaht hanyrahfn. Nd kaht nhai wom yiha minoh hmbreni hanykaht. ");
INSERT INTO amp_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Yo nyingarn fasoh nefm hanitrn fasoh nefm ne, nd nyingar yak rurha thuhato be rpa nyingarparpno rhuhato ninhu toheft toh marnyani-rahnt. Hus nyinga bugaf rpat rhuneft wom nyingarn fasoh nefm hanyruhatrn rorn hel rhuyuk kaht hanyrahrn. ");
INSERT INTO amp_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Niko dukefmpno rhukfot. Mirahko ka nd yonm ka be yima fura-yeme. Nhai. Yura hefenrko rroh mounmotm brbo Bro Nkifrarpno yorhwamn kfo nuhaswomr yimam tamoh fasoh nefm finjina finjina thombat.” ");
INSERT INTO amp_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Wom 100 sifsifet yimar wan handretyukr hti hambrorfohat ka nhai nd wan handretyukr yak hambrorfotrr? Na kanga ka nhai mumafrfotrr. Ndwom 99 kforpat kipr yeyuk tkitt afo yak htanyrformn afo nd wan handretyukr afo yau hambro htfasrforr. ");
INSERT INTO amp_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Na kfo mifwanko. Ndwom frfnahni duha 99 kfothu yindhoreft rot be inji yindhornirfort. To nd wan handretyukr hambro hanyhato tfit yakrfohat, rorhu yindhoreft mirahko ka be tu kukent rhurfotr. Be tu mfro yima yuhur yindhor mifrforr. ");
INSERT INTO amp_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","To inji kanjo nikmoh Yifemr, hefenr tohwar, nhai wofnkahr ndar yonm rpat rhuhato tfit womr frfnahnineft.” ");
INSERT INTO amp_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ninhu wom Kristen yimatr wom fasoh neft nern, nd fasoh neft nayuk yimarpno yikfot. Yihato nifn turpatfn rhuhato kfo nuhas nriyafhekfot ror nayuk neft. Kfo nuhas nriyafhe-ruhatnr nd ror nayuk nefm yafhorahrm. Yafhoruharm tfit nayak marnyahato rpat toh marnyarahfn. ");
INSERT INTO amp_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Turpatfn rhuhato ror nayuk nefm kfo nriyaftnm, tfit kfo namhir, to be tfit yihato nd yimar nayuk nefm htiyet yimar o yimaf yakhato rompno yihato kfo nuhas hik bohikhekfot ror nayuk nefm. ");
INSERT INTO amp_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nd yimampno yihato nhai afo tfit kfo namhitr, tfit sioshu tuhan yindarspno nd mrokfot htakfot. Wuroht sioshu tuhan yindarimpno nhombrati be tu kfo namhi mifwor, to be nd yimar yak thuhato mong trohkfot. Rorhu neft bi nhai wom Kristenroh neft hikkahr, bi kspitat tohyuk yimaroh nefti takis marut yak htfaswa yimaroh neft hikwor. ");
INSERT INTO amp_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Na tu kfo mifwanko, ndar bbinysofthu tamoh tamoh nefm niko kfo raforahkomm, tawo hefenrko Bro Nkifrar nd nefm kfo raforahrm. Ndar bbinysofthu tamoh tamoh nefm niko kfo yakiorahkomm, tawo hefenrko Bro Nkifrar nd nefm kfo yakiorahrm. ");
INSERT INTO amp_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Tfit womt kfiwanko. Nifn hus yimafn, ndar bbinysoft tohhato wom tamoh dukefr rpa yima yuhur rhuhato kfo bruttnarahfn, htirahfn, nanhu Yifemr hefenr yorhwar htiruharn nifnhu kfo bruttnayuk mrokfo yuhatn hikrahr. ");
INSERT INTO amp_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mrokfot bi ruhetet. Husf o husfirpa yimam rpat rhu rifinyhato tamoh dukefm kfo bruttnarahma, na toya brbo rhuhato wany yakitohruhanm.” ");
INSERT INTO amp_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","To nd yiha Pitar niahato Jisasr mttiwon memorr, “Bro Nungothete, ninhu wom disaiperr nanpno wom fasoh fasoh nefm nahna nahnewura, ka 7-pela yiharpam yafhohiruhanr ror nayuk nefm?” ");
INSERT INTO amp_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Tfit Jisasr kfo memorr, “Nhai kfo mekoha 7-pela yiharpam. Nhai. Kfo kanga 77 yiham womr nayuk nefm yafhohekfot. ");
INSERT INTO amp_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Wawanyko. Hefenrhu king-domkfote kangme wom kingrn kangr turhu ofisam yak hanyuk marufam, ndmn ofisampno kingr rhuhato nayak marnya inji newum. ");
INSERT INTO amp_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Nd hingrneftn bi ruhetrn, 10 milion kina yak dinaumo wom ofisar hanymomr. ");
INSERT INTO amp_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Nd yimar nhai wom marufam nd ror yak dinaumo rrfathu htayuk marufam. Kingr be inji htitihato kfomorm rorhu hingrna yimam nd yimari rorhu yon tuhanm, yo wuska kunyr, nd ndm yakhato wom yimampno yak htahato nd yimami wuskaroh marut tfit yakhato nd ror yak dinaumo marufaroh rrfatn htakfot. ");
INSERT INTO amp_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nd kingr inji kfomotr nd ofisar wanyhato kingrhu wurampno brbo tabokmemor. Tabokmehato kingr mkfo memorr, ‘Wayuhuwafna. Afo yiham wahikahtna nd dinaukfot yak marnyaruhant.’ ");
INSERT INTO amp_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nd kingr yuhuwafhato kfo memorr, ‘Nhai mrokfom. Yuhuwafwann. Yuhuwafhato nd ni yakmo marufam mirahn tfit wom adukayanm. Na nhai wom dukarhotanm. Ni be wai warhu mmotwa.’ ");
INSERT INTO amp_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Be inji kfafmotrr nd ofisar fnahnimor. Fnahnihato rim htimor rorpno rpat hingrnamoa wom ofisar. Rim yakitohhato thu yebitt boyebitthato kfo memorr, ‘Nanhu 10 kinakfot ni yak dinaumot asomif wayakkahnt wahina.’ ");
INSERT INTO amp_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Be nd marufa yakmo yimar inji wanyhato womrhu wurampno tabokmehato mkfo nur memorr, ‘Wayuhuwafna. Afo yiham wahikahtna nd 10 kinakfot tfit hambrakhato hiruhann.’ ");
INSERT INTO amp_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","To nhai. Womr inji mkfakmohat, womr nhai yuhuwafhato kfo marimorr, ‘Nhai mrokfom. Kto bi hambreknt nd marufat ee btn wahitwona.’ Be yakmorrn kalabus htamorr. Memor, ‘Kalabus toh gnngiruharn hirahra nd 10 kinakfot.’ ");
INSERT INTO amp_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nd ofisar namo neft wom rpat hingrnayukm inji htihato memom, ‘Ndt nhai dborioh neft nakahr.’ Be rom tfit kingrpno yihato kfo nuhasmomr nd ofisar namo neft. ");
INSERT INTO amp_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kingr nd yimar tfit nakuyakhato kfo memorr, ‘Ni be tu fasoh ofisaye. Garkofpam niamo maruharoh mrokfotpno mkfo nurmotna yuhuwafhato nhai dukarmoyant nanhu yonmar maruhat ni yak dinaumot. ");
INSERT INTO amp_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Na hifa yuhuwaf marnyamoyann. To tamohmpno niko tuko rpat hingrniwako ninpno yak dinaumohat nhai tfit yuhuwafrmonr?’ ");
INSERT INTO amp_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kingr namburhato tawo nd yimar yakmorrn tfit kalabus htamorr. Memor, ‘Kalabus toh gnngiruharn tawo nanhu marufat tfit hirahra.’” ");
INSERT INTO amp_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jisasr nd kingri rorhu ofisampno namo neft kfonihato kfo memor, “To be rom namo kanjo, wom Kristen yimar o mett ni womnpno nayuk nefm nhai yafhorfonm, tawo nanhu Yifemr hefenr tohwarko rpahtet neft narahrn.” ");
INSERT INTO amp_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jisasr nd mrokfom kfonihato nd distrik Galilit htanymortn tfit tek Jodent hayuknimort. Hayuknihato tfit distrik Judiat yimor. ");
INSERT INTO amp_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ndko yimohat nhaf yonmari yima rifhur hikmotmr, ndharn rroh dbohnefet yimam fak marnya hanyhemorm. ");
INSERT INTO amp_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ndko tohetrn ndkorhof Farisim yuwi yihato ttiwon rhti memomr, “Nmoh boririfhut finji kfiwat, yimar be turhu duka fijo metthu yak tuhafoneft? Hifan o nhai?” ");
INSERT INTO amp_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jisasr kfo memor, “Niko Bro Nkifrarhu rfa borngt kfiwa mrokfom ka nhai htikahkomm? Nd mrokfot inji kfiwut, ‘Bingot Bro Nkifrar ndar bbinysoft hingrnahato yimam hingrnamohat mete yindariye hingrnamor.’ ");
INSERT INTO amp_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Yo wom mrokfot inji kfiwut, ‘Ndnettn yindarir turhu yifammam htanyhato turhu yak tuhantpno frtkafhato be rpa raftn dbkaf hmbrittf.’ ");
INSERT INTO amp_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Bi rpa raftn tou dbkaf hmbrihato tohkfot. Ndnettn Bro Nkifrarn yak nmbtekyukm nhai tfit yima mifmn yak tndohkfot.” ");
INSERT INTO amp_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Farisim wanyhato kfo memomr, “To tamohmpno Mosesrhu boririfhut kfo memot, ‘Afo tuhan yak tuhafoyuk kfo yakio gontwat wandfanihato ee mett yak tuhafokfot?’” ");
INSERT INTO amp_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jisasr kfo memorm, “Nd niko wanukwa boririfhut mirahko ka bingot nda bbinysoft trhanimohat ka nd boririfhut ka bi inji rhumot. Nhai. Tukmoh Bro Nkifrarhu mrokfo wany juha nmbuhatn Mosesr nd boririfhut htamort. ");
INSERT INTO amp_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Na kfiwanko, wom yimar turhu yak tuhant nhai rine wunerfott be fak thu furefirtn tfit wom nfri mett fekr, nd nfri mett nhai turhu tuhan mift rhukaht. Be inji ijoh metet.” ");
INSERT INTO amp_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Disaiperm nd mrokfot inji wanyhato Jisasr kfo memomr, “To ni kangn, mirahr wom yimar turhu yak tuhant be yak thu furayant. To be ndhtet neft ka nom hhrekwonom tuhan yakneft.” ");
INSERT INTO amp_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Tfit Jisasr kfo memor, “Hifa kfiwuko. To mirahko ka yima bugam tuhan yak duha toh furarahm. Nhai. Wom womrpam Bro Nkifrar yak htetm, ndmn tuhan yak duha rhurahm. ");
INSERT INTO amp_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Wawanyko. Nhai rpahtet ruhet yimam rhukahm. Womm frfuha yaktetem be inji sfno tuhan yak duha toh furewum. Womm bi mmemroh yatim rhuhato frfuha duhatm korhm. Womm hefenrhu kingdomkfothu kasinya yuhat dukahato nhai tuhan yakkahm. To nd tuhan yak duha mrokfot yimam kangm yakhato ahiknomt, yakhato hikkfot.” ");
INSERT INTO amp_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nd yiha wom yimam Jisasrpno yonenm hnehato memom, “Jisasr tir htahato kfo bruttnarahrm.” Disaiperm inji htihato tfit kfo huttaknimomm nd yon hnayuk yimam. ");
INSERT INTO amp_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jisasr inji htihato kfo memorm, “Yonenm wahti marsisafokahtkomm nanpno aniam. Mirahko akfo rafonomm. Yimam yon mumenm kanjo yorhwam hefenrhu kingdomkfot rhurahm.” ");
INSERT INTO amp_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Inji kfonihato nd yonenm yak nhafohmormn tir htahato kfo bruttnamorm. Inji na tanyhato ndhart htanymortn yimor. ");
INSERT INTO amp_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Wom yimar Jisasrpno yau yaknihato mkfo ttiwon memor, “Tisa, nane fitohtet fitohtet dborioh nefm narhoyann Bro Nkifrarpno toh nkifranirhoya?” ");
INSERT INTO amp_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jisasr wanyhato kfo memor, “Tamohmpno tfit nann nd dborioh nefroh na yuham kfo ttiwonwa? Bro Nkifrarpar dborioher. Tu kangn Bro Nkifrarpno amtoh nkifraniya, rorhu boririfhu mrokfom hikkfot.” ");
INSERT INTO amp_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Yimar kfo memor, “To fitoh fitoh boririfhu mrokforoh hikkfot ni kfiwa?” Jisasr kfo memor, “Mirahn wanambur sinyahato yima awas furaya, mirahn ramet tuhantpno arim fnaha, mirahn arikoha, mirahn wom yimar wom mrokfom akfo wokanr, ");
INSERT INTO amp_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","yifammaroh mrokfom wany yakiohato rroh yinhitn rhukfot, tunn yak marnyewa kanjo inji womm yak marnyakfot.” ");
INSERT INTO amp_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Jisasr inji kfonimotr tfit nd damiag yimar sinyahato kfo memor, “Jisase, nd ni kfiwa boririfhu mrokfo bugam na hik bugewanm. To tamohm kangn wahikn?” ");
INSERT INTO amp_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jisasr kfo memorr, “Kangn dborioh yimaya aruhane, inji nakfot: Nd ni harhuwa wuss yak htatahato wommn wiknakfot. Nd wusspno yakyuk marut yakhato tfit nd wuskapa duha yimamn nd marut hekfot. Inji narahn, hefenrko mfro wuss harhu-rahn. Inji nanihato tfit na nia hikkfot.” ");
INSERT INTO amp_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nd yima damiagr wuss mfro haruhetrn nd mrokfot wanymohat yima yuhur nhai marnyahato yirmor. ");
INSERT INTO amp_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jisasr kekutnihato turhu disaiperm yukatohhato kfo memor, “Wahtiko, yimam wuss mfro haruhetm be tu mduka nhiyekwom hefenrhu kingdomkfothu fknenineft. ");
INSERT INTO amp_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Tfit mkfekwa. Womhtet mong wakuyet fohr kutewumr kamerr. Nd kamerr fknanyirfort nahuyuk nirthu muht. To yimar wuss mfro haruhetr, Bro Nkifrarhu kingdomkfothu fknenineft mduka nhiyakrfor.” ");
INSERT INTO amp_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Tfit tu Jisasrhu disaiperm inji wanymohat tfit mifoh rihanimom. Miyoh rihanihato kfo memom, “Barenko, nom kangnom ka ndhtet maru kunyet yimamn hifa rhu nmbuhat miyakrahm. To nhai. Ndhtet yimam mthu nhiyakrahm Bro Nkifrarhu kingdomkfothu fknenineft. To nome ndhtet yima furapanom, to nome finji Bro Nkifrarpno yihato mtoh nkifraniruhanom?” ");
INSERT INTO amp_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jisasr yukatohmormn kfo memorm, “Niko yimakomn tamoh tamoh nefroh finjina finjinaneft mduka nhiyekwoko. Tu Bro Nkifrar nhai duka nhiyakkfot wom tamoh nefroh finji naneft.” ");
INSERT INTO amp_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Pitarn sinyahato kfo memorr, “Wahti. Nom ninhu hikneftn nmoh tamoh tamohm mong trohhato ni mhikaknamonom. To Bro Nkifrar tamohm hiruharnom?” ");
INSERT INTO amp_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jisasr sinyahato kfo memorm, “Na kfo mifwanko, tfit nfri bbinysoft mfrfnahnehato Bro Najomr king yufat yaknihato kingrhu gajis yakhato rhu thombat, nd yiha niko nanhu disaiperko 12-pela gajim rhuhato Isrerroh 12-pela frikeft yakitohrahkomt. ");
INSERT INTO amp_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Yimam nann dukahato rroh kunym, yon tuhanm, yifa mndarm, mswirm htanymm, tfit Bro Nkifrar wom 100 kfot thu hutahi hanyhato Bro Nkifrarpno toh nkifranirahm. ");
INSERT INTO amp_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Arihart nyingako tohekwa yimam, kto tfit mongko yihom fnahnirahm. Nd mongko tohyukmn tfit nyingako mfnahnirahm.” ");
INSERT INTO amp_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Mongko tohyuk yimam mfrfnahnehato tfit nyingako mtoh yuhathu mrokfo yuhat tfit Jisasrn wain swirt hingrnayuk yimamn kfo nhombramort. Kfo memor, “Hefenrhu kingdomkfot inji korht. Wom yiha wain swiret yimar dbha ksfut yimorn yimam fak habrimor wain swirthu hingrnayukm. Yimam yak habrimorn, ");
INSERT INTO amp_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","kfo memorm, ‘Rpa rpa yiham wan kina wan kina wikna hanyruhanko.’ Nd yimam kfo fakiomomt nd marufat. Be inji nnakfonihato nd barkof yakmo yimam yimom wain swirthu hingrnat. ");
INSERT INTO amp_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Yo tfit 9 kilok dbha nd bro yimar mhtimorm wom yimam rifinyuk maket tkittn toh fura hasomom. ");
INSERT INTO amp_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Mhtihato kfo memorm, ‘Nanhu wain swirt wai wahingrnakahtko tukanhu hti fijo wiknaruhanko.’ ");
INSERT INTO amp_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Be nd yimam inji kfomotrm yimom wain swirthu hingrnat. Kto tfit dany marrn womm yakhato hingrneft fak htamorm. Yo tfit 3 kilok tfit womm yakhato hingrneft fak htamorm. ");
INSERT INTO amp_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Yo tfit tu wuroh 5 kilok krif marrn yimorn wom yimam rifinyuk maket tkittn toh hasetmn mhtihato kfo memorm, ‘Nikome ndar yonmari marre be inji hingrna duha rhu furewukomr?’ ");
INSERT INTO amp_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Nd yimam tfit kfo memomr, ‘To frohmn hingrnefm harifotmnom hingrnarfonom?’ Inji kfomotm kfo memorm, ‘To ndhtet neft nanhu wain swirtn wai wahingrnako.’ ");
INSERT INTO amp_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Bi tu wuroh krif miftn wain swir tikatr kfomorr hingrnefroh tohukatohr. Kfo memorr, ‘Hingrna yimam wanakuyakkahnm rom hingrnehat maruham wahiyaf hanyswanm. Maruham hiruhanme wuroh nia hingrnayuk yimamn warihe gungonaktwa. Hihany hihany, ee nd barkof mhingrnaknayukm wurohm wahitwanm.’ ");
INSERT INTO amp_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nd yimam tu wuroh krif 5 kilok nia hingrnakniyukm niamotm tohukatohr wan kina wan kina hiyaf hanymorm. ");
INSERT INTO amp_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nd bi barkof mhingrnakniyuk yimam rom yimom. Rom yimomn memom, ‘Ka nomn bro marufam yakrahnom,’ to nhai. Rom to be inji buga wan kina wan kina fak hanymom. ");
INSERT INTO amp_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Be nd rom yakyuk maruham htihato wain swir tikatr kfo hutt memomr, ");
INSERT INTO amp_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Nd yimam tu wuroh niahato wan auakforpat hingrnayukm tfit nom yakyuk marufat kanjo fekm. Nom famunom ka nom bi dbha ksfut ritohakhato yonmari marr hatoh krifafyuknomn yura yakruhanomn rom yiro wayakrahm.’ ");
INSERT INTO amp_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Wain swir tikatr nd hutt mrokfot wanyhato rroh wom hingrna yimar kfo memorr, ‘Bare, na nhai kfo nheh marifoya be wan kinakforpat yakrahn. Nd niko yakhani wan kinakfot to bi tukomn kfo fakiomokomt nd wan kinakfothu yakneft. Na nd kfo yakio mrokfot hikhato inji wikniyanko. ");
INSERT INTO amp_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nhai tfit finji kforuhatn. Ninhu marufam wayaknikahnmn wanju. Nd na niko yahu maruham na tukanhu htihato yak nhta nmbuhatn inji fahuyanko. ");
INSERT INTO amp_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Na nhai tukanhu maruhampno wom yimar kfo htakfot. Na kanga finji finji anayanm, to ni womn tamohmpno tfit kfo yuhuwehwa?’” ");
INSERT INTO amp_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jisasr kfo memor, “To inji rhuraht. Yimam mongko tohyukm tfit mfnahnirahm. Yimam nyingako tohyukm tfit mongko yihom fnahnirahm.” ");
INSERT INTO amp_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jerusalemko yinyeftpno buha yihotatn Jisasr turhu disaiperm yakhato turpathato kfo memorm, ");
INSERT INTO amp_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Wawanyko, nom Jerusalemko yitohat, na Bro Najoma hrek kita prisroh bro yimami nkifra boririfhuthu tisaroh tirmn. Kmim rompno nakfo habofkniruhamn, ");
INSERT INTO amp_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","yima tangimpno htarhotma, rom sinyahato kfo hutatpno kfo hutatpno yenyohrahma. Tfit wife wife yenyoh gurahma. Wife yenyoh guhato tfit yura bgre misn kihegirrhotma nohruha. Nohrhoyann tfit husfirpehyuk marrpno tfit sinyaruha.” ");
INSERT INTO amp_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sebedirhu mett yon husf yaknihato Jisasrpno mtabokmehato kfo memotr, “Tisa, nanhu mrokfot kforfohat, wanyrfont?” ");
INSERT INTO amp_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jisasr sinyahato kfo memort, “To wakfo ptha.” Kfo memot, “Na kanga, ni kingn toh thoft nanhu yon husfn mano mano arhutwaf. Womr wayak htatwanr tirmifkor yo womrne kindonko. Rofn ninpno mano mano rhuhato bro yufat yakhato ninhu hingrneft yakitohnhorahfn.” ");
INSERT INTO amp_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jisasr sinyahato kfo memor, “Nifn nhai duka hik marnyahato ttiwonkahfna. Nd na yeruha krhoparoh kaft ka yenyho twanho mifrahfna?” Kfo memofr, “Uwa, no yenyhorahnonn.” ");
INSERT INTO amp_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jisasr kfo memorf, “Na yeruha krhoparoh kaft rot nifn yerahfnt. Tmift nann nifnhu rhuyuk tkitroh yak htaneftn, na nhai bi nanhu fijo kfo mekfot ni ndko rhurahn. Yo ni ndko. Nhai. Tu Bro Nkifrarhu duka fijo fak hta nhombra htatamorm tkitm. Kto turhu hti fijo tkitm yak hta nhombra hi hanyrahrm.” ");
INSERT INTO amp_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Jon Jems najohf inji ttiwonmotfr tfit wom 10-pela disaiperm kfo hutt memomf, “Tamohmpno ndhtet ttiwon nmbuhat ttiwonwafnr?” ");
INSERT INTO amp_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Jisasr rpat naku nhafoh bugamormn kfo memorm, “Niko bi htiyeteko, kingm yima tangim yakitohwohat. Yimam be nd tohak yimarhu yinhitn tohwom. Nhai womr finji tfit kfo pthakfot. Yimam be rorhu tngrpat hikkfot. ");
INSERT INTO amp_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Niko mirahko nd neft ahiknom. Yimar kangr, tohukatohr atoha, nd yimar afo nikmoh hingrnanho yimar tohkfot. ");
INSERT INTO amp_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","O kangr, tohak yimaya atoha, afo toh tario yimar tohkfot. ");
INSERT INTO amp_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","To Bro Najomr niamohat, nhai turhu rhu nmbuhat dukahato ndar bbinysoft niarmort. Nhai. Nikmoh rhu beb nmbuhat duka tanyhato niamort ndar bbinysoft. Rorn ndar bbinysof thofroh fasoh fasoh nefm suh nanyorrahrm.” ");
INSERT INTO amp_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jisasri turhu disaiperm kmi Jerikot htanyhato yimohat, yonmari yima rifhur hik hanymomm. ");
INSERT INTO amp_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Buha yihotatn hus nyinga kunyjf yihota thmbko rhu hasohato wanyak hanymof Jisasr yimohat. Wanyak hanyhato kfo nakuyafmof, “Woi! Bro Nungothete, Defit frikefthu Yone, wayuhuwafnno.” ");
INSERT INTO amp_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Inji kfo nakumotf wom yimam kfo thfamomf. Rof nhai wany yakiormof. Tfit wompam masat kfo nakuyafo memof, “Woi! Bro Nungothete, Defit frikefthu Yone, wayuhuwafnno.” ");
INSERT INTO amp_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Be Jisasr nd yimafhu naku tngt wanyhato be mtohmor. Mtohhato kfo memorf, “Bar yimafn, tamohm nakutafna?” ");
INSERT INTO amp_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nd nyinga kunyjf kfo memof, “Broye, kangno nyingam wayak marnyakahtnm ayukatohno.” ");
INSERT INTO amp_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Inji kfomotf Jisasr yuhuwafhato nyingamn tirm htamotrf nyingam be wuthamomf. Nyingam wuthanimotmf be tfit Jisasr mhikakni twanhomof. ");
INSERT INTO amp_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jisasri turhu disaiperm yimomn brbo Jerusalemtpno yorhwa Olifet kmi yihofr yorhwa kmi Betfaget mfnahmom. Ndha mhtahato hus disaiperf kfo tkrur memorf, ");
INSERT INTO amp_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Watohak hanykahfnn ndar rihtita kmit mfnahrahfn yudbat htirahfnt wom donkit natifett rhuraht rpat yon donkirpno. Nd donkif wayak nyusakaknetwafn. ");
INSERT INTO amp_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Yekwatfnf yimam kfo ttiwonwomfn, wakfo wamitwafnm, ‘Bro Nungothetr hingrnefetrn kfefitrno be yifrar kakni yahukanonr tfit yudbat yarim htanyrahf.’” ");
INSERT INTO amp_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ndhtet tng mrokfom inji rhumohat, to be bingot profetr kfomo tng yuhatn nd mrokfom rhu hik mifmom. ");
INSERT INTO amp_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Bro Nkifrar kfo memorr Aisaiar, “Taun Saion wakfo wamitwant, ‘Wahtiyakko, nikmoh kingr bi ndr bi niewar. Yufapa duha yima furam kanjo yura donkir rhuhato niewur. Yuhre warho hanyet donkirn rhu hnehato niewur.’” ");
INSERT INTO amp_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Be nd hus disaiperf yimofn hingrna hikmof Jisasr kfomo yuhatn. ");
INSERT INTO amp_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Nd donki husf nyusakaknihato hanyhemofr. Rim htahato tufhu rmontham yakmofmn yima rhuyuk tkitt rmonthaye yak hta marnyahato Jisasr mrhuhato yimor. ");
INSERT INTO amp_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ror yimohat yonmar yima rifhur ror htiyak hanyhato turoh rmontham yakmomm, rorhu yiyuk yuhatn hta nyingtakmomm. Womm miyuhtam yak wokakhato ror yiyuk yihotatn htakmomm. ");
INSERT INTO amp_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Jisasrhu nyingako tohakmo yimam yo mongko tohyuk yimam, romn kfo naku ptha hany memoum, “Wayindhorakkomr Defit frikefthu Yonr. Bro Nkifrar ayak marnyatwarr Brorhu yufatpno niayuk yimar. Bro Nkifrarhu yufat yura yura kfo yindhor boyindhorkfot.” ");
INSERT INTO amp_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jisasr kmi Jerusalemt yimohat, kmi thofm tfit tum nattiwon hany memom, “Ndar yimar nieware froher?” ");
INSERT INTO amp_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nd Jisasrpno yau hanymo yimamn kfo nuhas memomm, “Ndarr Jisaser. Galiliko yorhwa taun Nasaretkorhof profetr niewur.” ");
INSERT INTO amp_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jisasr Jerusalemt rim fnahnihato rim htimorm Bro Nkifrarhu temperrn maket htamoum yimam. Rim htihato maket htamoa yimami yeshrim wiknamoa yimam hik tubatumorm. Hik tubatumormn maruha niak tuknamoa teborm yo nunga ganyom mmkrm htamoa gajim nembos tubatu hikafmorm. ");
INSERT INTO amp_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Yak thunihato kfo memorm, “Bro Nkifrarhu rfa borngt kfo kangt, ‘Nanhu temperr nanhu kfo bruttnayuk kunys rhuraht.’ Tfit nikomn kangko rikoh yimaroh yi kafrohyuk tkitt arhut.” ");
INSERT INTO amp_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jisasr yiro temperr tohetrn nyinga kunyjetm yo wura bebet yimam yimom. Yimotm Jisasr fak marnyamorm. ");
INSERT INTO amp_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Jisasr nd mirakerkfot hingrnamohat yo yonkmim yiro rmon kmifar tohhato kfo yindhor grha memohat, “Defit frikefthu Yonr wakfo hagrhakomr.” Nd kfo yindhor mrokfom prisroh bro yimami boririfhuthu tisam htihato wanymohat rroh yima yuhum nhai marnyarmomm. ");
INSERT INTO amp_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Yima yuhum faso rikihato Jisasr kfo ttiwon memomr, “Nd yonkmim kfo yindhor grhahato kfiwa mrokfom ni wanuknm?” Jisasr kfo memorm, “Uwa, rom wanukanm. Tone, ka nhai wom mrokfot htikahkomt? Rfa borngt kfo kangt, ‘Ninhu yufathu yuta hagrhaneft yonmpno bi inji rinakmotn tu be ninhu yufatn yonm kfo yuta grha hanitm.’” ");
INSERT INTO amp_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Be tfit nd taunt htanyhato tfit kmi Betanit yihato nd yifungr ndha toh nfhamor. ");
INSERT INTO amp_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Dbha ksfut Jisasr memor, tfit taun Jerusalemko aiya, buha myatinohmor. ");
INSERT INTO amp_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Yihota yifembtn tohmot fik tihat. Nd fik tihat nhai yukha hirrmoat. Be twa bomrpam rhumomt. Be inji htitihato nd fik tihat kfo memort, “Ni ndar fik tihaye, mirahn tfit yukha hir mifa. Be tu nhai mif.” Be nd fik tihat inji kfomotrt, be yudbat nohhato twam furfmomt. ");
INSERT INTO amp_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Turhu disaiperm inji htihato be tuha mrokfo duhatm rhuhato kfo memom, “Bar yimako, finji netrt nd mis yudbat nohakni twanhit?” ");
INSERT INTO amp_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Tfit Jisasrn sinyahato kfo memorm, “Na kfo mifwanko, nikmoh yima yuhum be tu rpa yima yuhur rhuhato kfo mirahko, ‘Nom asomif kfiwohat Bro Nkifrar wanukwarn asomif nd mis nohwot.’ Inji dukahato kforahko, to inji htirahko na asomif fik tihat ne kanjo. To mirahko ka be ndrpatn. Nhai. Ndar kminysoft kfo mirahkomt, ‘Asomif nom kfiwunom marombtn wamitoh witani,’ to be htirahkomt nd kminysoft marombt mitoh witaniraht niko kforuha kanjo. ");
INSERT INTO amp_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Nikmoh yima yuhum rpa dukefrpar rhuhato tamohm kfo bruttna kfo mirahko, ‘Nom asomif kfiwohat Bro Nkifrar wanukwarn nd nom kfo bruttnewa shrm htitnomm.’ Inji dukahato kfo bruttnarahko, to be hti mifrahko.” ");
INSERT INTO amp_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jisasr Bro Nkifrarhu rmon kmifarn fknenimorn met yindarim kfo ptha nuhasmorm. Kfo nuhas hanyetrn prisroh bro yimam yo Judaroh bro yimam yimomn kfo ttiwon memomr, “Frohmn ndhtet bbuka rifhur hemomn? Frohmn bbuka rifhur hehato kfo memomn inji wanatwa?” ");
INSERT INTO amp_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","25","Tfit Jisasr sinyahato kfo memor, “Na to tawo tfit ttiwonwanko. Tone Jonr yimam baftaisimmoahate tu Bro Nkifrarn kfomotrr ndhtet hingrneft hingrnamourt o be yima mifm kfomotmr yimam baftaisimmourm? Nd ttiwon nmbuhat kanga wakfo nuhaskahtkma tawo kfo nuhasruhanko na hingrnewa hingrnefthu bbukeft yakmo yuhat.” Rom inji wanyhato tfit tum nnakfo memom, “Nom sinyahato kfo mirahnomr, ‘Bro Nkifrarn kfomotrr hingrnamour,’ to tfit mirahr, ‘To tamohmpno wany yakio duha yirmokomr?’ ");
INSERT INTO amp_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Jonr pthamoa mrokfom profetm kanjo pthamoatrm yimam wanymoumm, tfit nom kfo mirahnom, ‘Yimaroh kfotpno kfo pthamour,’ to be yimam sinyahato tat nohrahmnom.” ");
INSERT INTO amp_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Be myak nhtaktiyaktihato be kfo memomr, “Nom nhai tawisafkahnom.” Rom inji kfomotm tfit Jisasr kfo memorm, “Na to inji. Na nhai kfo nuhaswotanko na hingrnewa hingrnefthu bbukeft yakmo yuhat.” ");
INSERT INTO amp_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jisasr tfit nd prisroh bro yimami Judaroh bro yimam kfo ttiwon memorm, “Tone finji dukewako? Wom yimar hus yonetr tohmor. Wom yiha turhu nkati yonrpno yihato kfo memor, ‘Hrek waikahnn wain mswirt wahingrnatwa.’ ");
INSERT INTO amp_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Tfit yinemr afo kfo kur nheh memorr, ‘Na wofnkaha.’ Yinemr afo inji kfo kur tefinimorn tfit kto sinyanihato yimor. ");
INSERT INTO amp_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Bro yonr kfo ttiwontinihato tfit yimor habhirpno. Yihato rpahtet mrokfot kfomorr. Kfomotrr yinemr kfo fakio nheh memor, ‘Uwa, yiruha.’ yakio nhehafhato nhai yirmor.” ");
INSERT INTO amp_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Jisasr inji kfohato ttiwon memorm, “Nd hus yonfe frohrn yifemrhu mrokfot wany yakiomort?” Rom kfo memom, “Nkatirn yifemrhu mrokfot wany yakiomort.” Rom inji kfomotmr tfit Jisasr kfo memorm, “Na kfo mifwanko, takis marut yekwa yimami yo ijoh tonita metm, romn tohekwomt Bro Nkifrarhu kingdomkfot. ");
INSERT INTO amp_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ndt to nhai be sfno. Nikmoh yihar Jonr tohhato dborioh yihotar fak nuhas hnamorko. To nikomn nhai wany yakiohato yak hikrmokomt. Takis maruha yakyuk yimami ijoh tonayet metm, romn wany yakiohato hikmomt. To niko tfit inji htiyaf hanymohat, to nhai nikmoh fasoh fasoh nefm mong trohhato Jonrhu mrokfom hikrmokomm.” ");
INSERT INTO amp_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jisasr tfit wom kfo nhombra mrokfot yakhato kfo memorm, “Wawanyko. Wom yimar wain swirt htamor. Wain tofm nuhtanihato gnat gna habrimort. Gnanihato muhr toumorr wain yukharoh yahot kembiftyukr. Ndt inji hingrnanihato tfit nd wain swirthu rhu yukatohyuk kumba kunyr hingrnamorr. Be inji hingrna tanymortn wom yimam yakhato nd mswirthu tohukatohhato yukharoh nayak nhta yuham nayak dbkafhato ror be wom kmimn toh habrimor. ");
INSERT INTO amp_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kto nd wain swirt yukha hirmott yukha yak yiharn nd tu wain swir tikatr turhu hingrna yimam kfo tkrurafmorm, nd wain swirt yakitoh hasoyuk yimampno. Kfo tkruraf memorm, ‘Waikahkomn nanhu yufathu htahayuk yukham wamiyakhikma.’ ");
INSERT INTO amp_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Be nd yimam yimohat be mifahotakmom. Nd mswirt tohukatoh hasoyuk yimam sinyamomn womr tabotmomr, womr tabotmotmr nohmomr, womrne tahiya tahiye febhohmomr. ");
INSERT INTO amp_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Yo tfit kto wom yiha tfit wom yimam kfo tkrurafmor. Nd yiharne tu bokm. Yimom, nhaf be mifahotakmom rpahtet neft namomm. ");
INSERT INTO amp_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Wuroh turhu garbn yon mifr. Duka memor, ‘Tukanhu garbn yon mifr yiruhatre wany yakiorahmr.’ ");
INSERT INTO amp_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Be nd yonr tkrurafmotrr yimor. Yimorn wain swirt tohyuk yimam htiyakhato tum rinnakfo nakfo memom, ‘Ndarr turhu yonr nier. Yifemr nohnineft to nd yonrn tkitt yakhato ndar wain swirt rorn yakrahrt. Finji dukewako? Awaskahnomr be nd wain swirt be nmoht rhuraht.’ ");
INSERT INTO amp_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Be mrokfot yak dbkafnihato turhu wain swirt toh hasetrn toh rafaknihato fakmomr. Yakhato tirtir yaknimomr nndo rim htahato wasmomr.” ");
INSERT INTO amp_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jisasr inji kfo pthanihato kfo memorm, “Niko to finji dukewako? To nd wain swir tikatr nia thofte, to finji naruharm?” ");
INSERT INTO amp_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Kfo memomr, “Nd yima bebm faso faso tabot nohrahrm. Tabot nohhato nd wain swirt yakruhartn tfit womm hehato romn yakitohruhamtn wain yukha yak yihar yakruhammn nd wain yukham yak nhtaruhammn turhum hirahmr.” ");
INSERT INTO amp_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jisasr wanyhato kfo memorm, “Wom mrokfot Bro Nkifrarhu rfa borngt yorhwat htitwokomt? Nd mrokfot kfo kangt, ‘Nd rahur, kamda yimam hti kurhato yak thumor, be bi tfit nd rahurn bi dany rahur tohwor. Tu Brorn inji hingrna hta bohtamotrt nom be inji htihato mrokfo duha korhwonom.’ ");
INSERT INTO amp_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ndnettn kfo dukiwanko. Bro Nkifrarhu kingdomkfot niko yakitohwat, yak tuhakruhartn tfit frohm nd kingdomkfothu nefm mhfnahnewum, rom tfit wahirahr. ");
INSERT INTO amp_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Yimam nd dany rahurpno rim frrbigneft o rahus suhnehato frkarnyaneft to be nhai wom rhukfot o nfrikfot.” ");
INSERT INTO amp_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Nd nd mrokfom pthamotrm nd prisroh bro yimam yo nd Farisim Jisasrpno toh pthamoam, wanyhato kfo memom, “Nd kfo nhombra kfot nomn niewut.” ");
INSERT INTO amp_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ndnetmn nambur sinyahato memom, “Ka bi kak twanhiwunomr.” To nhai, kmi thofm mhti fakrmiyakmom. Kmi thofm Jisasr kfo pthamoa mrokfom profetm kfo pthamoa kanjo pthamoatrm rom wany yindhorhato hikmomm. Nd rorhu mrokfom hiket yimam ruhetmn prisroh bro yimaroh namburpam yo Farisroh namburpam romn mhti yakrmiyakhato nhai tafont htarmoamm. Duka memoum, “Finji rinakrahnom, rom sinyaruhamn tabot nohrahmnom.” ");
INSERT INTO amp_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jisasr tfit wom kfo nhombra mrokfot yakhato kfo memorm, ");
INSERT INTO amp_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Hefenrhu kingdomkfot kangme wom kingrhu yonr tuhan yekwarn yifem kingr bro yemro burwat htewartn kmi kmi nakutrm. ");
INSERT INTO amp_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nd yemro burwat yak htatahato bi kfo duka mrokfot bi yak hanyetm, mrokfot frhtfasmot yimaroh yakyukt. Tu kingr kfo tkrurmotrm turhu hingrna yimam yimom yimaroh yak htfass. To nhai, yimam nhai sinyarmom. ");
INSERT INTO amp_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Yo tfit wom hingrna yimam yakhato kfo tkrur memorm, ‘Na mrokfo hta htfasmo yimam wayak htfaskomm. Wakfo wamitwakomm, na bi yemro burwat htatahato bi kfo nakuta. Nanhu bulmakau yiramm warhet warhet yemrot bi washato nde yemro burwat htiwant. Aniekahmn arhu ayamt.’ ");
INSERT INTO amp_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Kingrhu hingrna yimam yi kfomomm, nd yimam nhai wanyrmomm. Rom mrokfom wany sany hanyhato rpen rpen natubatumom. Womr ror turhu mswir yuhatn myak tehni hanyswa, womr ror turhu hingrnefmn waiswa. ");
INSERT INTO amp_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","To tfit wommn nd kingrhu hingrna yimam yak tkaftamomm tat beb bobebmotmm nohmom. ");
INSERT INTO amp_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kingr inji wany namburhato turhu soldiam kfo tkrurmotrm rom yihato nd yimam was witahato rroh kmit tandhi wusmomt. ");
INSERT INTO amp_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Be kingr turhu hingrna yimam kfo memorm, ‘Yemro burwat bi htayett korhwot. Tmift nd kfo hanyuk yimamn nhai tu dborioh yimamn niakahmn yekahmt. ");
INSERT INTO amp_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ndnettn wai htfastwakomm yihota nadbgm. Yihota nadbgm tohhato yimam htiyekwoko, wakfakne hnetwakomm ndar yemro burwathu yanyeft.’ ");
INSERT INTO amp_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Be inji kfafmotrm yimom. Yi htfashato nd yihotam toh hasoyukm yak bugahato hanymomm. Dborioh yimam, fasoh yimam fak fura bofurani bugamomm. Nd yemro burwat htayuk kunyr be tng mnderpat tohmor. ");
INSERT INTO amp_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Tuhant yindars rhu hasetmn kingr rroh htit yimor. Yimorn wom yimar htimorr nhai tu nd tuhan yak yiharhu wondhyuk wondh tham hmbrermor. ");
INSERT INTO amp_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Kingr inji htihato kfo ttiwon memorr, ‘Barene, tamohmpno nhai tu dborioh hmbresham hmbrenehato niarfo?’ Be nd yimar tuha mrokfo duhatr tohmor. ");
INSERT INTO amp_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Be kingr toh kekutnihato turhu hingrna yimam kfo memorm, ‘Nd yimar wayak tumakkahkomr briahako watuhafokomr. Briyahako kspitat tohrahr. Nd kspitat tohwa yimam tau nknekwom.’” ");
INSERT INTO amp_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Nd kfo nhombra mrokfothu yimbu yuhat Jisasr kfo ptha memor, “Bok yimampno nakukfot kitt, to tfit rpen rpenrpam kekwor.” ");
INSERT INTO amp_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","16","Be nd Jisasr kfoyuk mrokfot Farisim wanymohat yima yuhum nhai marnyarmomm. Be yihato tfit tu Farisiroh disaipermi Herotrhu politiker patikfot tohyuk yimam mkfo tkruraf memomm, “Nikomn waikahkomn rorhu mrokfo ptha swirmn rhunhohato yuwi ttiwon rhtikfot. Finji finji kfiwur, nd tkittn yakhato kotimrahnomr bro yimampno.” Be inji kfafmotmm yimom. Yihato yuwi kfo memomr, “Tisaye, ni pthewa mrokfom nom hifa wanuknomm. Mrokfom hifa hifa kfo hik bohik marnyewanmn Bro Nkifrar hikwa nefm kfo hik nuhas marnyewunm tuhan yindarim. Mrokfom kfo pthiwohat nhai hti mekahn ndr yufet yimayer o ndr yufa duha yimayer. Nhai. Mrokfom kfo pthaneft be kfo pthewunm. Nhai yimar o yufam htihato kfo pthakahnm.” ");
INSERT INTO amp_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Inji kfonihato wom ttiwon nmbuhat yuwi ttiwon rhtimomr, “To ni finji dukewa? Nome ka Sisarhu takis htahenefte ka htarfonome nhai?” ");
INSERT INTO amp_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jisasr rom yuwi inji ttiwon rhtimohat bi htimorm rroh fasoh yima yuhum. Htihato kfo memorm, “Niko mikfo nhehta mkfo nhehtayet yimayeko! Tamohmpno inji ttiwon rhtitakma? ");
INSERT INTO amp_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Wom takis wiknayuk tahifat wayak nuhaskoma.” Yakhato fak nuhasmomr. ");
INSERT INTO amp_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Nd tahifat yakhato kfo memorm, “To nda tahifat yorhwa nyingatikte frohroh nyingatikti yufat yorhwat?” ");
INSERT INTO amp_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Kfo memomr, “Sisarhu nyingatikt korhwott.” Tfit kfo memorm, “Sisarhu nyingatikt korhwott to be tfit Sisarn hekfot. Bro Nkifrarhum nhaf inji. Tu Bro Nkifrarn hekfot.” ");
INSERT INTO amp_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Inji kfo wokafmotrm be mrokfo duhatm yimom. ");
INSERT INTO amp_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Farisim yimotm tfit Sadyusim yimom. Nd Sadyusiroh dukeft duka memoum, “Noh hanita yimam nhai tfit sinyaruhatm.” Rroh dukeft inji rhumout. Nd duketpno Sadyusim Jisasrpno yihato mkfo memomr, ");
INSERT INTO amp_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Tisaye, Mosesrhu boririfhut kfo kangt, wom yimar tuhan yakhato nhai wom yonm kasinya htanirfor, nd rorhu tuhan dhirt tfit wom nmemrn najom dhirt yakhato rorpno yonm nasakhato tfit najomrhu tkitm romn tohkfot. ");
INSERT INTO amp_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Wom yima najohfitpno to inji rhumot. Nd yima najohfit 7-pelakfot tohmom. Barkof bro najomr tuhan fakmor. Ror tuhan yakmohat nhai yonm nasak htanihato nohrmor. Be nohmotr tuhan dhirt tohmott tfit rorhu wayakrn fakmort tuhan dhirt. ");
INSERT INTO amp_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Rorpno nhaf nhai wom yonm nasak htanihato nohrmor. Tfit rorhu mongko nuryukrn tfit fakmort nd tuhan dhirt. Ror yakhato be rpahtet neft. Be inji nahany nahanysn 7-pela yima najohfit rhunhombra bugamotm. ");
INSERT INTO amp_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Wuroh 7-yukrpnone nohmot. ");
INSERT INTO amp_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nd 7-pela yima najohfit rpa metrpat rim rhuta mrhutamotm. Kto nd najohfit sinya thoft nd mette fitoh yimarpno tohruhat?” Inji ttiwon rhtimomr. ");
INSERT INTO amp_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jisasr wanyhato kfo memorm, “Bro Nkifrarhu mrokfom yo rorhu bbukeftpno nd noheh yimam sinya thoft ka mumiwuko. ");
INSERT INTO amp_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Wawanyko, nd bi noh hanita yimam kto tfit sinya thoft nhai tfit tuhan yakruhatm. Nhai. Be inji sfno hefenrhu mounmotm kanjo tohrahm. ");
INSERT INTO amp_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nd yimaroh nohhato sinya yuhat Mosesrhu tndht duka hanykfot. Wom yiha Bro Nkifrar yihato Mosesr kfo memorr, ");
INSERT INTO amp_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nane Abraham, Aisak, Jekofroh Nkifraya.’ Bro Nkifrar yima nfri yafothet yimaroh Nkifrayer. Nhai noheh yimaroh Nkifrar rhukahr.” ");
INSERT INTO amp_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Yimam nd ror pthayuk mrokfom wanyhato mrokfo duhatm rhumom. ");
INSERT INTO amp_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Sadyusim kfoyuk tngm Jisasr kfo wokmohat Farisim wanymom. Farisim wanyhato yimom Jisasrpno. ");
INSERT INTO amp_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Farisim yimomn rroh womr, nkifra boririfhuthu tisar, rorn Jisasr yuwi ttiwon rhti memorr, ");
INSERT INTO amp_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Tisa, ndar nom wanuka boririfhum, fitoh boririfhutn tu nyingako mtohak mifwat?” ");
INSERT INTO amp_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jisasr wanyhato kfo memorr, “‘Bror ninhu Nkifrayer, ndnatn ninhu yuhuwaf marbi bugam, ninhu yafothat, yo ninhu yima yuhu bugam be rorparn htakfot.’ ");
INSERT INTO amp_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Nd boririfhutn tu bro mifet. Rotn mtohak mifwot. ");
INSERT INTO amp_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Yo tfit rotpno myak tkafekwat inji kfiwut: ‘Tunn yak marnyewa kanjo inji womm yak marnyakfot.’ ");
INSERT INTO amp_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Nd hus boririfhu nmbuhafn tof tu mnako yorhwa boririfhuf. Mosesrhu boririfhuti profetroh mrokfom, nd hus boririfhufn mttaf tanymom.” ");
INSERT INTO amp_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisim yuhre rifiny hasetmn Jisasr yihato kfo ttiwon memorm, ");
INSERT INTO amp_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Niko finji dukewakomr nd yimaroh minrfa htiyakyuk yima Kraisr? Fitoh frikef yuhathu yimayer?” Kfo memomr, “Defitrhu frikef yuhathu yimayer.” ");
INSERT INTO amp_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Tfit kfo memorm, “Niko tu kfo mif kfot kfo thoft, to tamohmpno bingot Defitr tohmohat Bro Nkifrarhu Yafothat yihato Defitr yima yuhu hemotrr nd yima Kraisr Defitr futa memorr, ‘Bro Nungothetr’? Defitr kfo memor, ");
INSERT INTO amp_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Bro Yawer kfo memorr nanhu Bro Nungothetr, “Nanhu bro bbukeft yorhwa tirmifko wamrhun. Wamrhukahtn nd ni namburwa yahr kmim afo ninhu tirtn htahato ninhu mofsinhitn yak htaruhanm.” ’ ");
INSERT INTO amp_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","To nd yima Kraisr bi Defitr kfo yuta hna memoa, ‘Nanhu Bro Nungothetr,’ to tfit Defitrhu frikef yuhat nierahr?” ");
INSERT INTO amp_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Be inji yak nnariyafomotrm nhai tfit marimom, “Tfit wom kfo ttiwon mrokfot kfo ttiwonrahnomr Jisasr.” ");
INSERT INTO amp_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Farisimpno nd kfo ttiwon nmbuhat kfo ttiwonnimormn tfit kekutnimorn turhu disaipermi tuhan yindarim mrokfom hi hanyhato kfo memorm, ");
INSERT INTO amp_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Boririfhuthu tisami Farisim rom hifa boririfhu mrokfom kfo nuhaswomko Mosesr namoa kanjo. ");
INSERT INTO amp_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ndnettn nd rom kfo nuhasyuk boririfhu mrokfom niko wanyhato hikkfot. Tmift, rom niwa nefmn niko htihato hik duha. Rom inji newum: Yimaroh mrokfo hanyeft, rom mrokfom kahukmm. To tfit tum nd mrokforoh hikneftn nhai hikkahmm. Ndnettn rom nayuk nefm niko hik duha. ");
INSERT INTO amp_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Rom yimam boririfhu mrokfom kfo nuhaswohat, nhai be Bro Nkifrarhu boririfhurpat kfokahmm. Tfit romn turoh fijo wom wom kfo yirmoh mrokfom yakhato tfit hta hutewumm. Btn yimam hikneft htanhitm hik buganeft. Inji htitahat nhai hti yuhuwaf mikahm. ‘Be kfongot rimak myakhato htewatnom yimam htanhitwom hikneft. Womm ayak thunomm.’ Nhai. Nhai inji nakahm. ");
INSERT INTO amp_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Rom niwa nefm kangm yimako htiruhakomn kfo yindhorrahkomm. Kfo bruttna yiham htirahkomm nhai Baiber fesm ruhet tefi kpenm mfhatn kiskaf hmbrihato nyimbikko rhuruhatm. Nhai. Bro kpenm mfhatn kiskaf hmbrerahmm. Yo saketha psifm hatohet mtin tfuhet saketham nhai kkopen mtin tfuhet mtin tfuhet saketham hmbreruhatm. Nhai. Tu yuke yuke mtin tfuhet saketham hmbrirahm. Kangm yimako htiruhakomn kfo yindhorrahkomm. ");
INSERT INTO amp_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Fitoh rhu rifinyhato kfo bruttnayuk rmonm rom nhai mongkorn o kimbko rim rhukfot. Tu be nhai mif. Rom tu be nyingako mruhakkfot. Bro yemro ye burwa tkitm nhaf inji. Rom inji yimaroh nyingako mruhakkfot. ");
INSERT INTO amp_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Yo tamoh maket swirm rom yau hanyneft kangm, ‘Yimam be tisa yufatpno ayuta hambonna yindhor amemnom, “Hifa dbha Rabai.” ’ ");
INSERT INTO amp_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Nhai yimam nikomn kfo yuta mekfote, ‘Rabai.’ Niko najohfi yagnr tohwoko. Tor womr, rorrpar nmoh Tisayer. ");
INSERT INTO amp_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ndar bbinysoft, niko nhai wom yimar yuta mekfot, ‘Yifemr.’ Tor womr, rorrpar nikmoh Yifemer. Tor yura hefenrn tohwor. ");
INSERT INTO amp_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Yo niko nhai yimam niko kfo yuta mekfote, ‘Tohak Yimam.’ Nhai. Nhai nikomn inji yutakfot. Nikmohr rpa tohak yimayer. Rorn Bro Nkifrar kfo htamorr ndar bbinysof thofroh minrfa htiyakneft. ");
INSERT INTO amp_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Kangn, ‘Bro yimaya atoha,’ afo yimaroh hingrna yima furar kanjo rhukfot. ");
INSERT INTO amp_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Yimar kangr, ‘Tamoh nefm nann bmbri nyingako mtohnihato nann tamoh tamoh nefm atohakkahtanm yimam kfo yindhorrahma,’ nd yimar kto Bro Nkifrar yak dbhurakruharr yiro wahtarahrr. Yimar turhu yufat yiro wahtahato yimam nhai kmi kmim yindhorkahmr, nd yimar Bro Nkifrar tfit yura wuhtarahrr.” ");
INSERT INTO amp_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","“Niko boririfhuthu tisako yo niko Farisiko, niko mikfo nhehta mkfo nhehtayet yimayeko! Wadukaf hanyswako! To nikomn hefenrhu kingdomkfothu rim fkneni yuhat toh rafiwukomt. To tuko nhai rim fnahnikahko, tfit wommn kangm arim fnahninom tfit kiyak rafiwukomm. Ndnettn Bro Nkifrar be yak bebrahrko.” ");
INSERT INTO amp_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Niko boririfhuthu tisako yo niko Farisiko, niko mikfo nhehta mkfo nhehtayet yimayeko! Wadukaf hanyswako! Niko inji newuko. Niko tukmoh hingrnefthu yaunhoyuk disaiperm kangko ayaknom, yonmari tkit tkitm frnahik bugewukomm, yo marombt frhtfas bugewukomt. To nd yimar yakneft to tfit niko hel yuhat tohhato niwa fasoh fasoh nefmn tfit kak nuhaswokomr. Yak nuhaswatkomr rorn be tu mfro mfro fasoh nefm kitr. ");
INSERT INTO amp_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Nyinga kunyjko kangko tfit womm yihotat ayak nuhasnomm, niko duka marnyaf hanykfot! Womm kfo kangkomm, ‘Fitoh yimar Bro Nkifrarhu temperr myutak hanyhato wom mrokfom fak dbkafrmn, to nhai hik duha yirform ror kfoyuk mrokfom, ndt nhai mrokfo duhatet. To nd temperr rim htayuk gorkfotn myutak hanyhato wom mrokfom fak dbkafrm, nd mrokfomn ror hikkfot. Bro Nkifrar kukatoh hasiwur.’ ");
INSERT INTO amp_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ar mmo hari kpt! Nd niko kfiwa tngt be tu nyinga kunyjkomn kfo ptha mumiwuko. Tamohtn tu yafothetet, gorkfotn o nd gorkfot yorhwa temperr? Nd temperr Bro Nkifraruher. Ndnettn nd temperr rim htayuk gorkfot rpat tu Bro Nkifraruhet. ");
INSERT INTO amp_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Yo kfo kangko, ‘Altar myutak hanyhato wom mrokfom fak dbkafrmn, to nhai hik duha yirform ror kfoyuk mrokfom, ndt nhai mrokfo duhatet. Nd yura altarn htayuk yemromn myutak hanyhato wom mrokfom fak dbkafrm, nd mrokfomn ror hikkfot. Bro Nkifrar kukatoh hasiwur.’ ");
INSERT INTO amp_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Niko be tu nyinga kunyjeko! Tamohtn tu yafothetet, nd yemrot o nd yemrot htewa altar? Nd altar Bro Nkifraruhet. Ndnettn nd altarn htayuk yemrot rpat tu Bro Nkifraruhet. ");
INSERT INTO amp_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Na kfo mifwanko, yimar altar myutak hanyhato wom mrokfot fak dbkafrt, to nd altar rhuyuk shrkarpno bi rpat mrokfot fak dbkafrt. ");
INSERT INTO amp_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Yo Bro Nkifrarhu temperr bi yutahato wom mrokfot fak dbkafrt, to nd temperr thu nawohwa Nkifrarpno bi mrokfot kak dbkafwort. ");
INSERT INTO amp_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Yo yimar mrokfom kfo ptha hanyhato hefenr yutahato wom mrokfot fak dbkafrt, nd mrokfot to bi kak dbkafwort. To nd ror yutewa hefenr to fitharet? Ndr to bi Bro Nkifrar yorhwa gajir bi kutewur. Ndnettn hefenr yutahato mrokfot yak dbkafwohat Bro Nkifrarpno rpat yutahato mrokfot kak dbkafwort. ");
INSERT INTO amp_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Niko boririfhuthu tisako yo niko Farisiko, niko mikfo nhehta mkfo nhehtayet yimayeko! Wadukaf hanyswako! Tamoh tamoh wuritwenm, youpenm, wajipenm yakneft nhai Bro Nkifrar yak brur wunanikahkomr. Nhai. Bro Nkifrar hifa kesmbho wunewukomr. Ndm rom tu hifa dborioh nefm newuko. To tfit tu boririfhut kfiwa tu bro mrokfothu hik yuhat tfit kak frikatitkomt. Niko yimaroh mrokfom rhuhato yakitoh hanyeft, nhai wany hik bohik marnyahato yak hta bohta marnya hikkahkomm. Yo womm nhai yuhuwafkahkomm. Yo nhai Bro Nkifrarhu dukefrn rhu marnyakahko. Ndm hikhato yakitoh marnyahato tfit wom wom kfo yirmoh mrokfoyenm rpat hikkfot. ");
INSERT INTO amp_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Niko be tu nyinga kunyj mifkomn kangko, ‘Womm yihotat ayak nuhasnomm.’ Niko inji newa yuhat kangko womroh yemro bruyoh roht mitayifwa krkonenrpamn ahtihanyom, to tukmoh yemro roht mitayifyuk yonmari kamerr nhai htikahkomr. ");
INSERT INTO amp_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Niko boririfhuthu tisako yo niko Farisiko, niko mikfo nhehta mkfo nhehtayet yimayeko! Wadukaf hanyswako! Kaf pletm briahako kifsewa kanjo inji briahakorrpa kifsewuko. Nikmoh yima rifhumio rikohefti fasoh fasoh nefm furkihwomko. Tukmoh toh nmbuharpat dukahato bi marut wuss tamoh tamoht yak yakhato bi tohwokomt. ");
INSERT INTO amp_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Arom nyinga kunyjet Farisi kpt, afo kaf pletroh yirokko kifsanihato ee briahakort htirahnt fnhuraht rpatn. ");
INSERT INTO amp_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Niko boririfhuthu tisako yo niko Farisiko, niko mikfo nhehta mkfo nhehtayet yimayeko! Wadukaf hanyswako! Niko yima yopm kanjo yura briahakorrpa ganyom penpaye yimam penimwa kanjo inji briahakorrpa penimwoko, tfit yiro yoptwe yima gur kfe bdgnihato yima tpi trukti yima gu burioht furkihwot. ");
INSERT INTO amp_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Niko to inji korhko. Ptha wiyauyau marnyewatko yimam hti kangm ka hifa dborioh yimayem, yiro yima rifhumio yimaroh kfo nheh bonhehneft furkihwotko yo fasoh fasoh nefm furkihwomko. ");
INSERT INTO amp_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Niko boririfhuthu tisako yo niko Farisiko, niko mikfo nhehta mkfo nhehtayet yimayeko! Wadukaf hanyswako! Bingot noh hanymo profetroh yopm yo Brorhu dukefm yakitohmoa dborioh yimaroh yopm, ndm niko yak marnya bomarnyahato wondh marnya bomarnyewukomm. ");
INSERT INTO amp_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Yo kfo kangko, ‘Nom nd nkifram tohmo yiham bi atohnom, nhai rom namo kanjo profetm wasrmonomm.’ ");
INSERT INTO amp_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","To niko inji kfiwohat to bi tukomn tafon htewuko. To nikmohmn ndhtet neft namomt. To niko froheko? To rom frohem? ");
INSERT INTO amp_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","To nhai mrokfom. Kangko nfripa tokrpa ayanom, nhai mrokfom. Nkifram yohmo nakur tfit nikomn wayak truftwakomr. ");
INSERT INTO amp_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Niko nandomrhu nandom yoneko. Niko finji yamukako tfit ayakrmanyom, bi kah thmbt bi tohetko? ");
INSERT INTO amp_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Ndnettn kfiwanko, profetm, yo dborioh dukefet yimam, yo tisam kfo tkruraforhotanm nierahm nikompno. Nieruhatm womm wasrahkomm, yo womm yura bgre mimn kim hegirrahkomm, yo womm nikmoh rhu rifinyuk rmonmn wife yenyoh guhato hik tubatuyafrahkomm. ");
INSERT INTO amp_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ndnatn niko nd profetm was hnamo yuhatn krhopam yak hanyrahko. Bingot nikmoh nkifram was hnamo profetm, barkofr dborioh yima Aberr wasmom. Ror wasnihato ee wom womt be yimaroh tirmn hirmom. Wurohenr Berekiarhu yon Sekaraiar yiro temperrn tarioh mthamoa tkitt toh hasetrn rim wasakmomr. ");
INSERT INTO amp_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Na kfo mifwanko, niko bi tukmoh nkiframn katirnamomko. Nhai toh marnyaruhatko. Rroh krhopam tfit nikomn yak hanyrahkomm.” ");
INSERT INTO amp_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Jisasr tfit kfo memor, “O Jerusalem! Jerusalem! Kfo tkrurafoyuk profetm ninn was hakutwanm, yo womm tahiye tahiye yebhoh noh hakutwanm. Bok yiham memoa nanhu mofsinhitn ahta akafrohneyann mmem kris yonm yak kafrohwa kanjo, to nhai. Nhai kfo yakiormona. ");
INSERT INTO amp_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Be wahti hanyswa, ninhu temperr nhai yima duhatr rhurahr. ");
INSERT INTO amp_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ariham nhai wom tfit htirhotna. Bi tunn kfo kangn, ‘O Bro Nkifraye, Brorhu yufatpno niayuk yimar wayak marnya bomarnyatwanr.’ Bi tunn inji kfiwune ee tfit htiyakrahna.” ");
INSERT INTO amp_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jisasr Bro Nkifrarhu rmon kmifar htanyhato yuhre wufau hanymor, asha disaiperm. Jisasr mhtihato rmon kmifar tohyuk kunyroh ruheft hti natthato kfo pthamoumr. ");
INSERT INTO amp_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jisasr wanyhato kfo memorm, “Na kfo mifwanko, ndar niko htita kunym nhai inji rhuruhatm. Yimam niahato kafring witarahmm.” ");
INSERT INTO amp_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jisasr yura Olifet kmit muhhato mrhumor. Ndha rhu hasetrn turhu disaiperm niahato turpam ttiwon memomr, “Nd rmon kmifarhu kunyroh kafring yuhate fitoh yihar rhuruhatt htiruhanomt? Ninhu nia yihar yo ndar bbinysofthu bati yihar finji finji htihato yak dukaruhamnom nd yiharhu brboh yihar?” ");
INSERT INTO amp_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","5","Jisasr kfo memorm, “You niko! Wanyrahko yimam yi htfasruhamn bok yimam kfo nheh bonheh htfasrahmm. Nanhu yufat yutahato kfo mirahmm, ‘Na bi asoya niko gari hasomo minrfa htiyakyuk yima Kraisa.’ Niko inji wanukko, mirahko yudbat wany yakiohato amhikakninomm. ");
INSERT INTO amp_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nna yureft mano mano wanyrahkomt yo fitha fitha rhuyuk nna yurefthu mrokfom wanyakrahkomt. Inji wanuknom, bi mirahko bok dukefm ayaknom. Ndhtet nefm rom nierahm. To mirahko ka bi nd nefmpno bi brbohwor yihar. Nhai. ");
INSERT INTO amp_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Htirahko yo wanyrahko wom kantrikfot sinyaruhatn wom kantrikfotpno nnarahf. Wom kingr sinyaruharn wom kingrpno nnarahf. Wom kmim yatinoh wormr tohrahrm. Wom kmim bro nunes toniraht. ");
INSERT INTO amp_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nd nefm yironarahkomm yon fanet mett barkof riyak yironekwa kanjo. ");
INSERT INTO amp_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Nd yiha htirahko, wom yimam hti namburruhamn yakrahmko. Yakhato was hakurahmko. Niko nanhu mrokfot hiketko be tu hti dbnot thu hakurahmko. ");
INSERT INTO amp_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nd yiha bok yimam Bro Nkifrarhu yihotat myafhonirahmt. Myafhonihato tum nahndhna nahndhnahato nahti dbnot nahti dbnotrahm. ");
INSERT INTO amp_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Yo nd yiha nhaf bok profet giamanm mfnahhato bok yimam frnheh bonhehrahmm. ");
INSERT INTO amp_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Fasoh fasoh nefrpamn kmi kmim brotaniruhatm yima nayak marnyaneft nhai wom rhuruhatt. ");
INSERT INTO amp_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Fitoh yimar toh bmtahany toh bmtahany bbinysofthu bati yihar mfnahr, nd yimar Bro Nkifrar yakrahrr. ");
INSERT INTO amp_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Kingdomkfothu gutnius mrokfot bi ndar bbinysofthu kmi kmim bi frhtfas bugetm ee btn bbinysofthu bati yihar nierahr.” ");
INSERT INTO amp_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Jisasr kfo memorm, “Wahtitwako, profet Danierr kfomo yak batiyuk shr bebr htirahkomr Bro Nkifrarhu temperrn mtohrahr.” (Yimar Danierr kfoyuk mrokfom htiyukr hti hik marnya hanyhato mrokfo yimbu yuham yakkfot.) ");
INSERT INTO amp_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Nd yiha Judia distriktpno brbo toh hanyuk yimam yura kminysofko yakrmanyikfot. ");
INSERT INTO amp_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Yimar bi kunyshu wom yura ken tikrko wurhu mska hasir, mirahr tfit yiro mmem kunyko ayohnikahann wuskam amiyaka. ");
INSERT INTO amp_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Yimar bi mswirko yirn ndko tohwor, mirahr tfit kmiko aikahann turhu yuke hmbreshat afo tfit ai ayaka. ");
INSERT INTO amp_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Metm yon fanetm yo tefi yon hamboriyetm finji yakrmiruham nd bro krhopam yakakna thombat? Romn tu bro yuhuwafeft korht. ");
INSERT INTO amp_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Bro Nkifrar kfo bruttnahato mirahr nd bro krhopam bro gonng wormrn o Sabat yiharn arhukahtm yimam nd yiharn ayakrmem. ");
INSERT INTO amp_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Nd neft nia thombat mirahko ka tefi tefi kurhefm rhurahm. Ndar bbinysoft trhanimohat nhai ndhtet krhopam rhurmom. Yo ndar toh hniwa yiham nhai ndhtet kurhefm htikahnom. Yo kto nhai ndhtet kurhefm wompam rhuruhatm. Be tu bro bro krhopam tohrahm. ");
INSERT INTO amp_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nd kurheft rhuhany Bro Nkifrar nhai bmbri yak nohrfort, be yima bugam nd kurheftn batirahm. To nhaft Bro Nkifrar tfit dukarahr tur bi kfo htayuk yimam. Romn dukahato nd krhoparoh tohyuk yiham tfit yak kkopenrahrm. ");
INSERT INTO amp_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Nd yiha wom yimam kfo mirahmko, ‘Barenko, nd Bro Nkifrar kfo htamo minrfa htiyakyuk yima Kraisr bi asor, asha.’ Womm kfo mirahm, ‘Usor, usha.’ Inji wanyrahko, mirahko awany yakionomm. ");
INSERT INTO amp_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Womrne inji narahr. Mirakerkfot hingrnaruharn kfo mirahr, ‘Na asoya niko toh gari hasiwa minrfa htiyakyuk yima Kraisa,’ o kfo mirahr, ‘Na profeta.’ Inji kfohato wonk wonk mirakerkfot hingrnarahm. Yuwi mirahm, ‘Tu Bro Nkifrar kfo htayuk met yindarim frnhehakhato ahikmnom.’ ");
INSERT INTO amp_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Wawanyko, kfo duka mrokfom bi kfo duka htiwanko. ");
INSERT INTO amp_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ndnettn yimam kfo kangmko, ‘Wusor bi wesan tik furatn’. Wany yakiohato yi juha. O kfo kangmko, ‘Asor ndar kunysn.’ Wany yakio duha. ");
INSERT INTO amp_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Htitwokomr toh fnhur yohni thombat. Fnhu trfefm yambohritna thombat nhai rpa tkitt htikahmr. Kmi kmim hti bugewumr. Bro Najomr nia thombat to inji kanjo wur fitoh ritoh atoh kmi kmim htiyakrahmr. ");
INSERT INTO amp_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Foh gum kfe bdgwa tkitmn kungorohm yi rifinywom.” ");
INSERT INTO amp_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Nd bro kurheft rhuniruhatt ee htirahko marr rim noh kfirahr, nhai wom taruhatr. Yamt nhaf inji. Rothu nukeft rim fnahniraht, nhai wom taruhatt. Gunym rom nhai mount rhuruhatm. Rom be wuyohninehato misuhrahm. Mount thu habokknamo yifonm mirahm nndo ginunes kekwotm. ");
INSERT INTO amp_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ndtpno ee btn Bro Najomr htiyakrahmr gribpamn hawihnerahmr. Kmi kmim htiyakhato yonmari nurm nurrahm. Ror yawihna thombat turhu bbuka rifhur yo ror hatoh hneruha nukeft mirahm nndo marrn yifa toh hnewur. Inji htiyakrahmr. ");
INSERT INTO amp_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ror yawihna thombat fumrr tohrahr. Nd fumrr mounmotroh kasinyayukr tohrahr. Nd fumrrpno mounmotm sinyaniruhamn Bro Nkifrar htayuk yimam yak nhafoh htfasrahmm.” ");
INSERT INTO amp_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Jisas kfo memorm, “Kutr htitwonomr, huktewur kfo kangnom yinr tohrahr. ");
INSERT INTO amp_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","To be inji hti nhtakrahkomr Bro Najomrhu nia yihar. Bi nd nd nefm htitwoko, wakfo wamitwako, Bro Najomrhu nia yihar bi brbohwor. Yifhatikt bi tohwor. ");
INSERT INTO amp_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","To nd nefm rhu thoft to mirahko arihat tohwa yimam bi nohetmn nd neft rhuraht. Nhai. Arihat tohwa yimam yuhre tohetmn nd neft htirahmt. ");
INSERT INTO amp_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Nd neft rhuneft htirahko mounti bbinysoft mibatinirahf. Nanhu mrokforpat nhai mibatiniruhatt.” ");
INSERT INTO amp_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Jisasr kfo memorm, “Nd na kfiwa nefroh rhuyuk yihar nhai wom yimar tawisafkahr. Mounmotmi Bro Najomr rom nhaf nhai tawisafkahm. Tu Bro Yifemrpar tawisafwort. ");
INSERT INTO amp_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noarhu tndht wanukwokomt. Nd yiharhof yimam namo kanjo Bro Najomr yawihna thombat inji na mmo bammo hasorahm yimam. ");
INSERT INTO amp_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","39","Noarhu yiha to inji namom yimam. Rom to be nuwa ye mmo bammohaso, yo tuhan yak, nd nefrpam be na hasomomn, nhai wom tamoh dukefm rhurmomm. Be inji foh nungam kanjo mmo hasetmn Noa riphar sift fknemom. Bi yiro sift tohetmn bro hnut niamot. Nd hnutpno nd wom womt hnutn fak bati witamotm. Bro Najomr yawihna thombat to inji fasoh fasoh nefmpno na mmo bammo hasetmn nierahr. ");
INSERT INTO amp_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Hus yimaf mswirt toh hasorahf, Bro Nkifrar womr yakruharn womr rhurahr. ");
INSERT INTO amp_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Hus metf bretpa hingrnayuk plauapam hingrna hasorahf, Bro Nkifrar womt yakruharn womt rhuraht. ");
INSERT INTO amp_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ndnettn niko yimbhindangm be tohetoh hasokfot. Nhai tawisafruhatko Brorhu nia yihar. ");
INSERT INTO amp_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Wawanyswako! Wom kunys rikoh yimam kangm ania arikohnomt, bi nd tu kuny sikatr bi fekrt nd rikoh yimaroh nia mrokfot, be nhai ror mhwe gushunikfot. Rorhu yimbhindangm be tohetoh hasorahm. ");
INSERT INTO amp_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Ndnettn nikmoh yimbhindangm be tohetoh hasokfot. Bro Najomr rhu mmo hasetkomn be yak fohtasakrahkomr.” ");
INSERT INTO amp_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Fitoh yimar hingrna marnyewur, tor nd yimarn turhu tu bro tohukatohr wom tkitm yinyeft, kak htewurr wom hingrna yimaroh tohukatohneft yo kfo nuhasworr hingrna yimaroh yeshr heyuk yiharoh yeshr hanyeft. ");
INSERT INTO amp_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nd tu bro tohukatohr kfoyuk hingrneft hingrna hik marnya hasirt, nd yimar yindhorkfot. ");
INSERT INTO amp_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Na kfo mifwanko, bro tohukatohr nd yimarn htarahr rorhu tamoh tamohroh tohukatohyuk yimar. ");
INSERT INTO amp_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","To nd yimar hingrnahany hingrna hanyhato bi bok yiham toh garitihato nd kfo hta tanyuk hingrneft faso faso rihingrna behohaknihato, ");
INSERT INTO amp_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","nd hingrna yimam faso faso ritat bebakhato ror be nuwa bupa ye mmoyet yimarpampno toh hasir, ");
INSERT INTO amp_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","inji na mmo hasetrn, nd tohukatohr nia mihti thoft, ");
INSERT INTO amp_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","be nhai wom tohruhatrt nd hingrneft. Be tmbho tekrruharr rpapa rpapa htarahrr. Rpapa rpapa htahato tu rpahtet mikfo nhehta mkfo nhehtayet yimampno htarahrr. Ndha tohhato tau nknekrahr.” ");
INSERT INTO amp_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Jisasr tfit kfo memorm, “Hefenrhu kingdomkfot, akfo nhombranomt wom 10-pela met tmahmpno. Wom yima sawohfhu nayak yihar nd 10-pela met tmahm lamm yaknimomn yimom metthu kunys. Memom, ‘Yindarir yifung niahato kangr mett amiyak htiyakane rpat yirahnom.’ Ndnetmn lamm yaknihato yimom. ");
INSERT INTO amp_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Nd 10-pela met tmahm yimohat inji namom, 5-pela metm dborioh dukef duhatm yimom. Wom 5-pelakfotn dborioh dukefetm yimom. ");
INSERT INTO amp_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Nd duka tunga duhat met tmahm yimohat tu lamroh rhuyuk kerosinpam hmbre furkihhato yimom. Nhai wom kerosinpam be yakitoh furakrmomm. ");
INSERT INTO amp_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Nd wom dborioh dukefet 5-pelakfot inji namom, tu lamroh rhuyuk kerosinpam hmbre furkihmommn tfit wompam be botormn hmbre yaknihato fakitoh furakmomm. ");
INSERT INTO amp_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Rom metthu kunys yi rhu gariti garitihato nyingam krkotakmotmm hwemom. ");
INSERT INTO amp_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Bi yifung danysn wom yimarhu naku tngt wanymomt. Nd yimar naku memor, ‘Wasinyako. Niko gari hasoyuk yimar tor bi niewur. Wasinyakahkomn watoh htiyaktwakomr.’ ");
INSERT INTO amp_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nd 10-pela met tmahm rpat sinya bugahato lamm fak nmbritafmomm. ");
INSERT INTO amp_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Yo nd duka tunguna duha met tmahm wasinyahato fak nmbritmomm rroh lamm. To nhai. Rroh lamm bi yifungr toh nfhetmn sfnoh kerosinpa duhatmn nukefm bi yohni hanymom. Inji htihato wom dborioh dukefet metmpno yihato kfo ttiwon memomm, ‘Nome wom kerosinpenme bahukkmnom? Nmoh lamme bi minoh witanitm.’ ");
INSERT INTO amp_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Nd duka tungunayet metm kfo wok memomm, ‘Nome finji kanjohtet kerosinpamn btn niyahukanom? Nhai bro kerosinpam bt nayahukanom. Niko tuko wawiknak htfasko.’ ");
INSERT INTO amp_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Be inji kfafmotmm, nd dborioh dukef duhat 5-pela met tmahm yimom kerosinpa wikna htfass. Ndko yiyetmn nd rom gari hasoyuk yimar mfnahmor. Mfnahmotr nd ror gari hasomo metm be nd rofhu marit patikfot rhuyuk kunyr rpat yihato fknemom. Fkne bugamotm kuny kiyakt frkihmomt. ");
INSERT INTO amp_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Kto nd kerosinpa hambro htfasyuk metm mfnahmom. Mfnahhato kfo nakuyakni memom, ‘Bro yimaye, bro yimaye, yifhatikt watfanyaknnom.’ ");
INSERT INTO amp_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Tfit ror kfo wok memorm, ‘Na kfo mifwanko, na nhai tawisafkahanko.’” ");
INSERT INTO amp_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Ndnettn Jisasr kfo memor, “Nikmoh yimbhindangm be tohetoh hasokfot. Niko nhai tawisafruhatkomt Bro Najomrhu nia yihari yo auakfot.” ");
INSERT INTO amp_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Jisasr tfit wom kfo nhombra mrokfot kfo memor, “Hefenrhu kingdomkfot mirahme wom bisnis hingrnayuk yimarn wom kmiroh yinyeftpno rorhu marut turhu hingrna yimampno htanyhemotrm romn nd maruham yakhato wom hingrnefm htamomm. ");
INSERT INTO amp_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Womr htanyhemorr 5,000 kinakfot, womr 2,000 kinakfot, womr 1,000 kinakfot. Maruham yimaroh tirm htany hanymohat, yimaroh hingrna dukefm htiyak hanyhato maruham hi hanymorm. Ror maruham htanyhihato yimor. ");
INSERT INTO amp_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nd maruha yakitohyuk yimam maruham yakmomm wom hingrnefm htamomm. Nd 5,000 kinakfot yakitohyuk yimar, rorhu 5,000 kinakfot wom hingrneft htamohat tfit wom 5,000 kinakfot fakmor. ");
INSERT INTO amp_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nd 2,000 kinakfot yakitohmo yimar nhaf inji. Rorhu wom hingrneft htamohat, nhaf wom 2,000 kinakfot fakmor. ");
INSERT INTO amp_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Nd 1,000 kinakfot yakmo yimarne nhai wom hingrneft htarmorm nd ror yakmo 1,000 kinakfot. Nd 1,000 kinakfot yakmohat, be yakmortn bbinysoft tou yop kafrohmort. ");
INSERT INTO amp_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Be nd maruha tikatr toh htfasmorn tfit niamor. Niahato nd maruha htanymo yimampno rhuhato kfo nuhas bonuhasmomr maruham hingrnamo yuham. ");
INSERT INTO amp_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nd 5,000 kinakfot yakitohyuk yimar kfo memor, ‘Bro yimaye, ni htanymo 5,000 kinakfot wom hingrnefm hingrnamohat, tfit wom 5,000 kinakfot fakhemoyann. Asom nd maruham.’ ");
INSERT INTO amp_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Bro yimar inji htihato kfo yindhor memorr, ‘O, ni tu hifa hingrna marnyet dborioh yimaye. Tamoh tefi marufenm ninhu tire yakitohhato hingrnaneft marufat hifa buriwut. Ndnettn nanhu tamohm ninn yakitoh hakurahnm. Wania. Na rhuruha yindhor nmbuhat ni warhunhotwona.’ ");
INSERT INTO amp_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Yo tfit nd 2,000 kinakfot yakitohet yimar yimor. Ror nhaf yihato rim kfo memor, ‘O Bro yimaye, nd ni hemo 2,000 kinakfot wom hingrnefm hingrnamohat, tfit wom 2,000 kinakfot fakhemoyann. Asom nd marufam.’ ");
INSERT INTO amp_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Bro yimar inji htihato kfo yindhor memorr, ‘O, ni tu hifa hingrna marnyet dborioh yimaye. Tamoh tefi marufenm ninhu tire yakitohhato hingrnaneft marufat hifa buriwut. Ndnettn nanhu tamohm ninn yakitoh hakurahnm. Wania. Na rhuruha yindhor nmbuhat ni warhunhotwona.’ ");
INSERT INTO amp_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Yo tfit nd 1,000 kinakfot yakyukr yimor. Ror yihato rim kfo memorr, ‘Bro yimaye, htimoya ni yima kfo huttete. Womm nuhtayuk mswir yeshrim ninn yihato kekwonm. Yo womm nuhtayuk yewurim ninn yihato fotwonm. ");
INSERT INTO amp_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Ndnetann na nd yakrme nmbuhatpno nd ni htanyheyuk 1,000 kinakfot be yakmoyantn bbinysoftn tou kafrohtahemoyann. Asot nd 1,000 kinakfot.’ ");
INSERT INTO amp_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Nd rorhu bro yimar sinyahato kfo memorr, ‘Ni tu fasohtet hhreket hingrna yimaye. Na niwa nmbuham ni bi tunn bi inji htimohat, ");
INSERT INTO amp_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","to tamohmpno na nd htanyheyuk maruhat benktn hta duha yirmotnt, benkt rhuhato wom nfri maruham benktn tfit hta hutarmotmt yakrmoyant? ");
INSERT INTO amp_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Na kfiwa nd 1,000 kinakfot wayakkahkomt tfit wariheko nd 10,000 kinakfot yakitohwa yimarn. ");
INSERT INTO amp_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Mrokfot inji korht. Yimar tamohm kakitohworm, nd yimar tfit womm hta hutahiruhanr. Yimar nhai wom tamohm yakitohkahr, nd ror yakitohyuk tefi shrenm, to be tfit yak hutfak twanhoruhanr. ");
INSERT INTO amp_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Nd hingrna yima bebr wayakkahkomr wari tuhafokomr yiro kspita yuhatn. Nd tkittn tohruharn tau nknekrahr.’” ");
INSERT INTO amp_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jisasr tfit wompam kfo memor, “Bro Najomr king kanjo turhu mounmotmpno tfit nia thombat, bro bbukayet kingm yorhwa gajirn mirhurahr. ");
INSERT INTO amp_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Mirhuruhatr kmi kmiroh yimat rorhu nyingako yi rifiny bugaraht. Mrifiny bugaruhatm yak nhtarahrm sifsifroh tohukatohr sifsifmi memem yak nhtewa kanjo. ");
INSERT INTO amp_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Sifsifm tirmifko htarahrm yo memem kindonko htarahrm. ");
INSERT INTO amp_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Yak nhtanihato nd tirmifko tohyuk tuhan yindarim kfo mirahrm, ‘Niko nhai mrokfom, nanhu Yifemrko bi fak marnya bomarnya htamort nikmoh rhu nmbuhat. Be wania furako. Waniakahkomn Yifemr kfo htayuk kingdomkfot nikomn tohrahkomt. Ndar bbinysoft trhamo yiha bi nikmoh yufampno kfo htamort. ");
INSERT INTO amp_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nhai be sfno kfo hta nuhas furakahanko. Na yatinohmohat yeshrim hemokma. Nyungram knamohat bupam hemokma. Yo nikmoh kmit niamohat nikmoh kunym fakmokma. ");
INSERT INTO amp_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Hmbresha duhata rhumohat niko hti dukahato hemokma. Dbohneft yakmohat niko hti dukamokma. Kalabus tohmohat niahato fau hafotmokma.’ ");
INSERT INTO amp_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","To tfit Bro Nkifrarhu mrokfot wany yakiohato yak hiket tuhan yindarim kfo mirahmr, ‘Bro nungothete, fitoh yiha yatinohmotn yeshrim hemonomn? O nyungram knamotn bupam hemonomn? ");
INSERT INTO amp_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Yo to ni fitoh yiha nmoh kmit niamotn nmoh kunym fakmonomn? O hmbresha duhatn rhumotn hemonomn? ");
INSERT INTO amp_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Fitoh yiha kalabus tohmotn fau hafotmonomn o dbohnamotn rhu yukatohmonomn?’ ");
INSERT INTO amp_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Tfit kingr kfo mirahrm, ‘Na kfo mifwanko, tamoh tamoh dborioh nefm nd yufapa duha yimampno nahnamoam, ndm nanpno nahnamokomm. Nd yufapa duha yimam nanhu nmemen mifm kanjo tohmoum. Ndnettn rompno nahnamoa nefm to nann fak nuhas hnamoko.’ ");
INSERT INTO amp_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Tirmifko tohyukm inji kfoniruharmn, yo tfit kekutnihato kindonko tohyuk tuhan yindarim kfo mirahrm, ‘Niko Bro Nkifrarhu namburpam hajohwa yimako niko wafnahniko. Bro Nkifrarhu namburpam bi niko hajohwom. Ndnatn ndar tkitt wahtanykahkomt wafnahniko. Ahtiwahanko. Wafnahnikahkomn Bro Nkifrar kfo htamo kahtn waiko. Nd kaht Satanri rorhu hingrneft hingrnayuk mounmotroh yufampno kfo htamo kahtn waiko. Nd kaht nhai wom yiha minoh hmbreni hanykaht. Be inji kur hasiwut. ");
INSERT INTO amp_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ndt nhai be sfno inji kfokaha. Na yatinohmohat nhai nuwa yeshrim harimokma. Na nyungram knamohat nhai bupam harimokma. ");
INSERT INTO amp_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Na nikmoh kmit niamohat, nhai nikmoh kunym yakmiyakrmokma. Yo wuskapa duhata rhumohat nhai marimoko, hti dukahato rmontha wuskam ahenomr. O dbohnefeta o kalabus tohmohat nhai marimoko, ayau hafotnomr.’ ");
INSERT INTO amp_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Rom tfit kfo wok mirahmr, ‘Bro nungothete, nd ni kfi mrokfom fitha rhu yatinohmon o nyungram knamotn nhai hti dukarmonomn? O nmoh kmit niamotn hti marsisamonomn, o wuska duha rhumotn nhai rmontha wuskam harimonomn, o dbohnayetn o kalabus tohmotn nhai yau hafotrmonomn?’ ");
INSERT INTO amp_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ror tfit kfo mirahrm, ‘Kfo mifwanko, nd yufapa duha yimampno nhai wom dborioh nmbuham yak nuhasrmokomm, to nhai romrpamn nd beb nmbuhat yak nuhasrmoko, nann fak nuhasmoko.’ ");
INSERT INTO amp_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nd net yimam be bro krhopa yakyuk tkit bebt yirahm. Nd krhopa yakyuk tkitt rom yi shombat, nhai tfit fnahniruhatm, be nd tkittn toh nkifranirahm. Nd tuhan yindarim Bro Nkifrarhu mrokfom wany yakiowetm, romn tu dborioh rhu nmbuhat yakhato be nd dborioh rhu nmbuhat toh nkifranirahm.” ");
INSERT INTO amp_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jisasr nd mrokfom kfo ptha nuhas bonuhasnimormn tfit kekutnihato turhu disaiperm kfo memorm, ");
INSERT INTO amp_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Yuwonano Pasofa burwat riruhakrahnomt. Nd yiharn Bro Najomr hndhna nhehakhato yakruhamrn yura bgre misn kihegirrahmr.” ");
INSERT INTO amp_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nd yiha prisroh bro yimam, yo Judaroh bro yimam prisroh bro tohak yima Kaiafasrhu kmifarpar yi rifiny bugamom. ");
INSERT INTO amp_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Yi rifinyhato Jisasrhu hndhna nhehakhato was yuhathu mrokfot nafak dbkafmomt. ");
INSERT INTO amp_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ptha hanyhato kfo memom, “Nd bro Pasofa burwa yihar mirahnom awasnomr, to be you muht kanjo watanhehakrahnom. Bi kmi kmi nia rifinyetmn to be romn wahiyafrahnom.” ");
INSERT INTO amp_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jisasr Jerusalemt toh tanyhato Betaniko yimor. Yihato Saimonrhu kunys yi tohmor. Saimonr bingot lepra dbohneft yakmotrn to bi frtrufnimot. ");
INSERT INTO amp_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Nd Saimonrhu kunysn nuwa ye hasetrn Betani efkott tu dborioh mtha yahrnyet wel botort hanymot. Yimotn nd bro maruhaye wiknamo welpaye Jisasrhu mfhat fuk wunamotr. ");
INSERT INTO amp_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nd Betani efkott Jisasr inji namottr, disaiperm htihato tum nakfo nakfo memom, “Nd mett tamohmpno welpam be wurasoh furetm? ");
INSERT INTO amp_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nd wel botort yimam bro maruhaye wiknarfotmt nd maruham yakhato tfit maruha duha yimamn nd marufam yirfom.” ");
INSERT INTO amp_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jisasr bi wanymorm rom inji kfo pthamoahat. Inji wanyhato kfo memorm, “Inji akfowahkomt. Rot tu dborioh neft nita. ");
INSERT INTO amp_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Nd wuska duha yimam, rom yiha yiha nikompno toh hasiwum. Na, na nhai wom tohnho-rhotanko. ");
INSERT INTO amp_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nd mett ka tamohr bi kfo memort, ‘Welpam bi wayuk wunafokahtnr yopt yirahr.’ ");
INSERT INTO amp_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Na kfo mifwanko gutnius mrokfot kfo ptha habrineft, ndar mett nefineft nhaf kmi kmi kfo ptha duka htfasrahmt.” ");
INSERT INTO amp_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nd yiha 12-pela disaiperroh wom disaiperr kutewumr Judas Iskeriotr frtrohmorm wom disaiperm. Frtroh tanyhato yimor prisroh bro yimampno. ");
INSERT INTO amp_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Yihato kfo ttiwon memorm, “Na yihato Jisasr mhndhnakhe thombat na finji ttharhokma?” Inji kfo ttiwonmotr 30 mani silvakfot hemomr. ");
INSERT INTO amp_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Judasr marufat myaknihato be yimor Jisasrhu hndhnakt. Yihato yima yuhur fak nhtamourr Jisasrhu hndhna yuham. ");
INSERT INTO amp_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Yispa hta duha bretpam yeyuk yiharoh barkof yiharn disaiperm Jisasr kfo ttiwon memomr, “Nd Pasofa burwat rhu thombat, nome yeshrim fitha hta mskaruhatnom ni rhuhato ye jukaruhant?” ");
INSERT INTO amp_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Inji kfo ttiwonmotm, Jisasr kfo memorm, “Nd taunt tohwa yimarpno waikahkomn wakfo wamitwakomr, ‘Tisare kfo famure, “Na nhai wom rhurhota. Yihar brbohwatr, kanga nani nanhu disaipermpno ninhu kunysn rhuhato Pasofakfot ayanomt.” ’ Inji wakfotwakomr.” ");
INSERT INTO amp_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Be disaiperm Jisasr kfomo yuhatn fak hikmomn Pasofakfot ror kfomo tkittn hta mskamomt. ");
INSERT INTO amp_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Yifungnano Jisasr turhu 12-pela disaipermpno rhuhato nd Pasofakfot rpat rhuhato rpat famomt. ");
INSERT INTO amp_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ye hanyhato Jisasr kfo memorm, “Na kfo mifwanko, niko ndar disaiperkmoh womrn hndhnarahra.” ");
INSERT INTO amp_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Be inji kfomotr disaiperroh yima yuhum foh tmbhonimomm. Rpa rpa sinyahato kfo ttiwon memoumr, “Ni kfihat frohmn inji naruhamn? Ka nann?” Tfit womr sinyahato kfo memor, “Ka nann?” Womr, “Ka nann?” Womr, “Ka nann?” ");
INSERT INTO amp_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jisasr kfo memorm, “Tor nikmoh womr. Yimar na yawo rohnges tir htanuhir, rorn hndhnarahra. ");
INSERT INTO amp_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Bro Najomr kangr anoha, ndt mrokfo duhatet. Rorhu noh nmbuhathu mrokfot bi nkiframpno kfo tndh hnettn nhai finji kforuhatt. Tmift nd Bro Najomrhu yak hndhnayuk yimarne kanga fitoh yuhat yiruhar? Mmemt hiyau duha rhurmotr.” ");
INSERT INTO amp_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nd Jisasr hndhnayuk yima Judasr sinyahato kfo memor, “Tisa ka nann kfiwun?” Tfit Jisasr rirhuhato kfo memorr, “To bi tunn kfo nriyafwo.” ");
INSERT INTO amp_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nuwa ye hasohato Jisasr bretpat yakmortn Bro Nkifrar wukfo yindhornimorrn yak tif nhombrahato disaiperm he nhombrahi hanymorm. Kfo memorm, “Nd bretpam wayak wayakomm. Ndm nanhu nmpayem.” ");
INSERT INTO amp_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Wain bu kaft yakmortn nhaf Bro Nkifrarpno kfo yindhornihato kfo memor, “Niko bugako nda wain bu kaft wayak wayakomt. ");
INSERT INTO amp_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ndm nanhu kkupayem. Yimaroh fasoh fasoh nefroh yak thuyuk nfri yihotar bi tfit yimayanhu kkupaye kak dbkafwanr. ");
INSERT INTO amp_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Na bi kfo mifwanko, na nhai tfit wom wain bupam yerhota. Tukanhu Yifemrhu kingdomkforpatn tohhato ee btn nfri wain bupam nikompno yerahnom.” ");
INSERT INTO amp_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Be wuroht, windoht windoh trufnihato be tfit Olifet kmi yorgko yimom. ");
INSERT INTO amp_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Olifet yorgr mfnahhato disaiperm Jisasr kfo memorm, “Bro Nkifrarhu rfa borngt kfo kangt, ‘Tohukatohr wasaknirhotanr sifsifm natubaturahm.’ Nd mrokfot bi ruhettn niko bugako hrek yifungr na finji naknewuma, kakrme trohwokma. ");
INSERT INTO amp_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Tfit sinyaruha. Sinyahato na bi Galiliko tohak hanyruha.” ");
INSERT INTO amp_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pitar wasinyahato kfo memor, “Ndar wommn wakfo. Romn buha msuhtahato mhik htafrahmn. Na nhai mhik htafrhotann.” ");
INSERT INTO amp_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Tfit Jisasr kfo memorr, “Na kfo mifwann, hrek yifungnano krirhu naku tngt tafi wany juha, husfirpa kfo namhit kfo namhi kangnm, ‘Na nhai tawisafkahanr Jisasr.’” ");
INSERT INTO amp_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pitar sinyahato kfo memor, “Be tu nhai mif. Na kanga, ninpno anoha, to nhai tfit kafrohrhotant ninhu yufat.” Pitar kfomo yuharpat wom wom disaiperm rpa yuharpat kfo ptha hikmom. ");
INSERT INTO amp_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jisasri disaiperm afo Olifet kmit tohetmn yimom wom tkitt kutewumt Getsemani. Ndha Getsemanit mfnahhato Jisasr kfo memorm, “Asha afo warhu hasoko. Na afo Bro Nkifrar rim kfo bruttnefiwa.” ");
INSERT INTO amp_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Pitari Sebedirhu hus yonf yaknimorn yimom. Nd yiharn Jisasrhu yima yuhur nhai rimarnyakrmorr. Yima yuhur be nur dungunangu yima yuhurpno rhumour. ");
INSERT INTO amp_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Be yima yuhur yak nhombratihato kfo memorm, “Yima yuhur be nd nur dungunangu yima yuhur mtakihwotra kanga be amyakniya. Asha warhu hasoko. Mirahko ahwanyom.” ");
INSERT INTO amp_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ror wunye kkofmorn msuhhato nyingatikt bbinysoftn yohnihato kfo bruttana memor, “O Dajaye, ndar bbinysofthu yimaroh fasoh nefm na be hta krhorhotma nann nohruhanm. Bi brbohwatt kanga akfoyann. Nd krho mis na yakruhat kangn ayak tuhant, be hifa, na yindhorwa. E nhai, kangn ayakrt, be nhai mrokfom, yakruhant. Na be ninn yukatohruha. Kangn, finji anaya, nhai mrokfom.” ");
INSERT INTO amp_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Inji kfo bruttna tanymorn tfit yimor nd husfirpa yimam rhu hasomo tkittn. Yihato yihom htimorm hwi hasetmn. Rim tohhato kfo memorr Pitar, “Niko tamohmpno hwitako? Nhai rpa auakfot afo ruhakkfot? ");
INSERT INTO amp_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Niko sinya rhuhato kfo bruttna hasokfot. Tamoh tamoh nefm nianeft, fitoh yuhatn tohruhakomn yahot-ruhakomm? Yima yuhur sinyarahr finji na finji naneft, to thatipt, fitha bbukeft yakruhat?” ");
INSERT INTO amp_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Be inji yihom kfo tanymorn tfit wom yis yimorn tur kfo bruttnamo mrokfom wompam kfo bruttnamor. Kfo bruttna memor, “O Dajaye, nd krho mis na yakruhat kangn ayakrt, be nhai mrokfom, ayaktwoyant. Na be ninn yukatohruha. Kangn, finji anaya, nhai mrokfom.” ");
INSERT INTO amp_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tfit wompam nhaf niahato yihom htimorm nyinga krkotakhato hwe hasetmn. ");
INSERT INTO amp_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Be inji yihom hti tanyhato tfit wom yis yimorn tur kfo bruttnamo mrokfom wompam kfo bruttnamor. ");
INSERT INTO amp_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Wurohpam mkfo bruttna tanymorn tfit yimorn hwe hasetm yihom htiyaknihato kfo memorm, “Barenko, nikome asoko yuhre hwe tokr hasiwuko? Be tmift nd hwe tokr hasoneft. Wawanyko. Yihar bi asor. Bi na Bro Najomanhu fasoh fasoh net yimaroh tirroh yi yihayer bi. ");
INSERT INTO amp_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Wasi-nyakahtko riyahnom. Wahtiko, nanhu mhndhnakyuk yimar tor bi niewur.” ");
INSERT INTO amp_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jisasr yuhre ptha haso hanymor, rorhu yakyuk yimam mhatohmomt bainati mhrs. Tu Jisasrhu disaiper Judasrn hatohakmorm. Prisroh bro yimami Judaroh bro yimam, kfo tkrurmotmm Judasr hasinyamorm. ");
INSERT INTO amp_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Nd Jisasr hndhnakyuk yimarn bi kfo hta bohta memorm, “Wahtiyafo hanyswokma. Na yauyaknihato fitoh yimar mkihendhoraknitwa, wamitwako, tor nd yima Jisasr. Ee inji bi htitwokma, nd yimarn yauyaknihato yakkfot.” ");
INSERT INTO amp_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Be nd Jisasr rhumo tkitt mfnahmohat, Judasr yauyaknimorn Jisasr rim kihendhoraknihato kfo kangrr, “Hifa yifunger, Tisa.” ");
INSERT INTO amp_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Inji rim kihendhoraknimotrr Jisasr sinyahato kfo memorr, “Yinowe, ni tamoh dukefm nia thombat, mirahn tfit wom akuknaya. Wadimanditwa.” Be yimam yauyaknihato tirtir fakmomr. ");
INSERT INTO amp_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Rom fak hanymomr, Jisasrpno toh hasoyuk disaiperr mhti namburnihato bainat watuhakmortn ka prisroh bro tohak yimarhu hingrna yimar bainate yimbhindangt frbubafmotrr misuhmot. ");
INSERT INTO amp_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Tfit Jisasr kfo memorr, “Bainat tfit wathuntwe. Yimam bainatpno nambur tonehato nniwam, tfit tu bainatn tmbhiwutm. ");
INSERT INTO amp_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Tamohmpno ni tfit namburwa? Kangn na ka yifem duhata? Nanhu Yifemr naku kforuha, yudbat 12-pela mounmot rifhum mitoh dbu rafo hmbrerahma. ");
INSERT INTO amp_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","To na nhai inji nakfot. Inji naruha, to be nd Bro Nkifrarhu rfa borngt kfomo nefm, nanpno rhuyukm, be nhai mfnahruhatm.” ");
INSERT INTO amp_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Jisasr yakaknimo yimam, Jisasr sinyahato kfo memorm, “Barenko, nane raskor yimam kanjo bainat, mhrs hasinyahato nia kekwokma? Na yiha yiha Bro Nkifrarhu temperr yorhwa kmifat tohhato met yindarim mrokfom hemoahat nhai niko inji yihato hfnahaknirmokma. ");
INSERT INTO amp_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","To nhai mrokfom. Ndar niko niwa nmbuhat nhai finji kforuhatnom. Bi profetmn mrokfot bi kfo hnettn to be bi rhu hikwot bi.” Disaiperm htimom bi Jisasr kak hasiwumre, rom fakrme troh tanymomr. ");
INSERT INTO amp_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nd Jisasr yakniyuk yimam hanymomrn tu nd prisroh bro tohak yima Kaiafasrhu kunysn hanymomr. Nd kunysn Judaroh bro yimam yo nkifra boririfhuthu tisam bi rifiny hasomom. ");
INSERT INTO amp_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pitar, ror be nhowi mongkongotn fau ss hik hanymourm. Bi prisroh bro tohak yimarhu kuny kmifarn bi hanitwomre, ror be nhowi yimorn Bro Nkifrarhu temperr tohukatohyuk yimampno mrhuhato memor, “Htiruha finji naruhamr.” ");
INSERT INTO amp_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Jisasrhu kotkfot yakitohyuk bro prism yo Judaroh kaunserm fak hambromoum yimam. Memoum, “Wom yimam ayakkahnomn romn wom kfo wok mrokfom htaruhatmm Jisasr wasrahnomr.” ");
INSERT INTO amp_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","To bok yimam yihato memoum, “Wom kfo wok mrokfom ahtanom,” to nhai. Rroh mrokfom be inji ptha mmbrafi-nymoumm. Nhai wom mrokfot krhonirmoat. Tu wurohnano wom hus yimaf sinyahato kfo memof, ");
INSERT INTO amp_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“To ndar yimarn kfo memor, ‘Bro Nkifrarhu temperr yak tasohrhoyanrn tfit husfirpa yiharpa tfit kasinyaruhanr.’” ");
INSERT INTO amp_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Jisasr nd yimam pthamoa mrokfom wanymoahat nhai kfo wokrmorm. Ndnettn prisroh bro tohak yimar sinyahato Jisasr kfo ttiwon memorr, “Tamohmpno ndar rom kfiwa mrokfefm be rhuhato wanukanm? Waptha!” ");
INSERT INTO amp_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Jisasr nhai ptharmor. Tfit wompam kfo ttiwonmorr, “Bro Nkifrarhu yufatpno na kfiwann, asomif Bro Nkifrarhu yufat wayutant. Ni bbinysof thofroh minrfa htiyakyuk yima Kraisn rhu thombat wakfo nuhas mifnnom. Ni Bro Nkifrarhu Yonen o nhai?” ");
INSERT INTO amp_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jisasr tohhato kfo memor, “Na to tawom nda. Tfit kfiwanko. Kto tfit htirahkoma na, Bro Najoma, tfit bro hta nngrajohet Nkifrarhu tirmifko rhuhato gribpamn hawihnerahmr.” ");
INSERT INTO amp_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jisasr inji kfomotr prisroh bro tohak yimar inji wanyhato rorhu yarim ruhakyuk hmbreshat teh dborfamort. Teh dborfahato kfo memor, “Wanukomr ror dkfi mrokfot. Ndhtet kfet yimar kangr, ‘Bro Nkifrar kanjo aruha.’ To be nhai tfit wom yimam yakhato ror nayuk nefm nia ptharuhatm. Ror pthiwa mrokfom to bi asomif wom mrokfom bi wanunomr. ");
INSERT INTO amp_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","To finji dukewako? Ndar yimare finji naruhanomr?” Tfit nd kot tohyuk yimam kfo memom, “Nd yimar bi mrokfeter anohtwar.” ");
INSERT INTO amp_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Be inji kfonihato tuha kuninfar bokuninfar thumomr. Tirm yak yifi-kathato tat beb bobebmomr. Wommn tire frsrfa bosrfamomr. ");
INSERT INTO amp_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Frsrfa hanyhato kfo ttiwon memoumr, “Ni, Kraise, nd ni frsrfiwa yimame frohem?” ");
INSERT INTO amp_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pitar kuny kmifarn kah haunyo hasetrn wom hingrnayuk mett mhtimotr. Mhtihato kfo memotr, “Ni to aso womenn Galili thof Jisasrpno tohnho htfasmoa.” ");
INSERT INTO amp_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Pitar sinyahato kfo namhi memor, “Bare, nann yari yutewun. Na nhai tawisafkahanr.” ");
INSERT INTO amp_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Pitar inji kfoni hanyhato kmifathu getkfotn yihom tohmor. Toh hasetrn tfit wom hingrna mett htihato nd getpno toh nafifmoa yimam kfo memotm, “Nd yimar tor womr Nasaret thof Jisasrpno toh htfasmoar.” ");
INSERT INTO amp_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pitar tfit wompam kfo namhi memor, “Na kfo mif mifwanko, na nhai tu tawisaf mifkahanr nd niko kfiwa yimar.” ");
INSERT INTO amp_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ndt inji kfo namhi nhehafafomort. Tfit toh hasetrn, wom brbo tohyukm yi kfo memomr, “Ni aso rroh womenn. Mrokfo kfo pthefm to wany nhta twanhiwunomn.” ");
INSERT INTO amp_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Tfit Pitar sinyahato kfo memor, “Na kfo mif mifwanko, na nhai tu tawisaf mifkahanr nd niko kfiwa yimar. Na kfo furewane Bro Nkifrar yak tutfarahra.” Inji kfo hanymor, krir nakumor. ");
INSERT INTO amp_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Krirhu naku tngtpno Pitarhu yimbhindangm ndnatn tuppomomr. Tuppohato yima yuhur tfit niamotrr tfit dukamort Jisasr kfomo mrokfot. Kfo memor, “Hrek yifungnano krirhu naku tngt tafi wany juha, husfirpa kfo namhit kfo namhi kangnm, ‘Na nhai tawisafka-hanr Jisasr.’” Nd mrokfot dukakhato briahako fnahnihato nhai nur ttifarmor. ");
INSERT INTO amp_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Dbha ksfutn prisroh bro yimami Judaroh bro yimam rhuhato Jisasrhu was yuhat naptha nhtamom. ");
INSERT INTO amp_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Mrokfot nayak nhtamomtn mti baklain tofe kimomr. Kiyakhato hanymomr Judiaroh gafanar kutewumr Pailatr, rorpno hanymomr. ");
INSERT INTO amp_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nd Jisasr hndhnayuk yima Judasr wanymor yimam kfo memomr, “Jisasr nhai rhuruhatr. Wasrahmr.” Judasr inji tfit wanymohat yima yuhur foh tmbhonimorr. Be tfit yudbat nd ror yakmo 30 silva marum hanyhato prisroh bro yimami Judaroh bro yimam tfit mhemor. Mhehato kfo memorm, ");
INSERT INTO amp_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“Nd yimar na be hndhna furahato nikmoh tirmn bi hta furamo-tanr be was furarahkomr. Ror nhai wom tamoh nefm narmor.” Inji kfomotr kfo memomr, “Nom nhai wom finji kforuhatnom. Ninuhem krhopam. Ni tu wayak nhta.” ");
INSERT INTO amp_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Be Judasr inji kfomotmr yima yuhur krhohato nd 30 silva maruham yakhato Bro Nkifrarhu temperrn rithu brur tanyhato fnahnihato yura mis muhhato tur tuhatokhato teh yifuhmor mtitofe. ");
INSERT INTO amp_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Be nd maru kpt, Judasr thu brur tanymot, prisroh bro yimam fakmomt. Rom yakhato kfo memom, “Ndar maruham yimar yak hndhnamo maruhayem. Nhai Brorhu temperrhu maruhampno rpat htaruhatnomm.” ");
INSERT INTO amp_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Be nd maruham rhumotm mrokfo napthahato nd maruhaye wiknamomt wom tkit nmbuhat. Roh hingrnamoa yimarhu tkitt wiknahato to be nd tkit nmbuhat yima kopmoumt. Wuri wuri niayuk yimam nohneft ndha hanyhato kopmoumm. ");
INSERT INTO amp_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Jisasr yak hndhnamo maruhaye nd bbinysoft wiknamotmt, ndnettn nd tkitt futamomt, “Yimakkut.” Arihat to be nd yufarpat kuta hanitmt. ");
INSERT INTO amp_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","10","Rom inji namohat to be profet Jeremaiar kfomo yuhatn rhu hikmot. Jeremaiar kfo memor, “Bror kfo memora, ‘Isrerm 30 silva marufenrpaye kfomom, yimarhu wiknaneft. Nd yimar wiknamo 30 silva marufenm yakmomn nde tfit kekutnihato wiknamomt roh hingrnayuk yimarhu tkitt.’” ");
INSERT INTO amp_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jisasr Judiaroh gafana yima Pailatrpno mtohmotr Pailatr kfo ttiwon memorr, “Nine Judaroh kinge?” Jisasr memor, “Uwa. Mrokfot to bi kfo twanhiwunt.” ");
INSERT INTO amp_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Prisroh bro yimami Judaroh bro yimam kfo wok fura bofuramohat Jisasr nhai ptharmor. ");
INSERT INTO amp_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pailatr inji htihato Jisasr kfo memorr, “Bare, ni wanuknm nd yimam ninhu yufatpno mhfnahniwa mrokfom?” ");
INSERT INTO amp_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Jisasr nhai wom mrokfom ptharmor. Pailatr inji htitihato duka nhi memor, “Arr tamohtet yimarn nhai kfo wokkahrm?” ");
INSERT INTO amp_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pasofa burwa yiharn kalabus tohyuk wom yimar Judiaroh gafanar kak thu hnamourr. Tu kmi thofmn fitoh yimar yibonwom yak tuhafoneft, yufat yutamoatm, nd yimar kak thumour. ");
INSERT INTO amp_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nd yihar fasoh fasoh nefm nayet yimar kalabus tohmor. Nd yimarhu yufat Jisas Barabasr. ");
INSERT INTO amp_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Nd Pasofakfot yi rifinyuk yimam yi rifiny bugamotm Pailatr wom kfo ttiwon mrokfot htamort. “Ar kmiko! Fitoh yima tungunar yangako ndar Pasofa yihar yak hfhanaforhoya? Jisas Barabasr o Jisasr, yimam kfo yamuka nd Kraisr?” ");
INSERT INTO amp_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Jisasr be kfo wok furahato kalabus htamomr. Ndnettn Pailatr ndhtet kfo ttiwon mrokfot htamort. ");
INSERT INTO amp_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Yo Pailatr kotkfot rhuyuk gajis rhu hasetrn Pailatrhu mett wom mrokfot kfaf memot, “Mrokfo duha dborioh yimar finjina finjina duha. Yifung nd yimarn hwe tweh hanyhato yima yuhur mfro kurhira.” ");
INSERT INTO amp_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Prisroh bro yimami Judaroh bro yimam kmi thofm kfaf hany memoumm, “Wakfo naku wameko, ‘Pailatr Barabasr ayak hfhanafokahrn Jisasr awasr.’” ");
INSERT INTO amp_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Tfit Pailatr kfo ttiwon memorm, “Froh mifr yamukako ayak hfhanafoya?” Tuhant yindars sinyahato kfo naku memom, “Barabasr.” ");
INSERT INTO amp_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pailatr ttiwon memorm, “To Jisasr, yimam kfo yamuka nd Kraisr, nd yimare finji narhoyanr?” Kfo memomr, “Bgre misn wakihegirkomr.” ");
INSERT INTO amp_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pailatr kfo memor, “To tamohmpno? Finji namotr inji narhoyanr?” Tfit mrhuni mrhuni memom, “Bgre misn wakihegirkomr.” ");
INSERT INTO amp_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailatr inji htitihato duka memor, “Na tamoh mrokfom kfoneft be nhai wanukotma.” Be ndnatn bupam yakmorn turoh nyingampno tirm kifsamormn kfo memor, “Ndar yimar noh thombat, na mrokfo duhata rhuruha. Niko tukomn mrokfetko rhurahko.” ");
INSERT INTO amp_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Pailatr inji kfomotr tuhant yindars sinyahato kfo naku memom, “Nhai mrokfom nd yimarhu krhopam nompno rhuhany tfit nmoh yonmpno nd krhopam yakneft.” ");
INSERT INTO amp_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Be Pailatr yakmorr Barabasr, fak hfhana-fomorr. Ror yak hfhanafohemormn tfit Jisasr yakhato soldiaroh tirm htamorr. Memor, “Romn wife wife tabotakhato bgre misn kihegirrahmr.” ");
INSERT INTO amp_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Soldiam Jisasr yaknimomrn hanymomr mrokfo yakitohyuk tkitrn. Nd tkitr hanyhato soldia bugam yi rifiny bugamom. ");
INSERT INTO amp_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Ror hatohmo hmbresham fak rhoh bugamomrn tfit kku kkorpa kanjo fnhuyet rmonthar thu kasimomr. ");
INSERT INTO amp_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Yo soldiam huhra mtitoft yakmomtn kingroh mfham hatohwa yabisoht kanjo yakkemomtn mfhatn wathu hamsismomr. Yo kingm yakitohwa mis nhaf wom miyef mifr yakhemotmr ndr fakitohmorr tirmifkorn. Yo rorhu nyingako bangu myuknamoamn yon mumenm kanjo wukfo tfar botfar memoumr, “Woi, Judaroh kingr.” ");
INSERT INTO amp_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Inji kfo tfar botfarmoamr yo kuninfar thumoumr. Yo tirt yakitohyuk mis dhemot, ndt tfit yak hutfakmoamr mfhapako warbigmoumr. ");
INSERT INTO amp_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Kfo tfar botfar thunimomrn yo tfit nd kku kkorpa kanjo fnhuyet rmonthar yakta thumomrn tfit turhu hmbresha mifm hmbremomr. Hmbrenimomrn hanymomr bgre mis tuhegiryuk tkittn. ");
INSERT INTO amp_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Kmi rim fnahnitn soldiam htiyakmomr Sairini thofr. Rorhu yufat Saimonr. Ror yakmomn nd Jisasr tita hanymo bgre mis rorn tfit wathu titafmom. Rorn titanhota hanymorr. ");
INSERT INTO amp_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Be yimomn, mfnahmom wom kmit kutewumt Golgotat. (Kfe sfiohniyet yima mfham kanjo nd tkitt rhumoatt futamoumt yima mfha tpit.) ");
INSERT INTO amp_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Fasoh huthayet wain bupam hnehato hemotmr, huthamotm nhai yarmorm. ");
INSERT INTO amp_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Soldiam Jisasr yura bgre misn kihegirnihato yo tfit rorhu hmbresham yakhato pirai satumomm. ");
INSERT INTO amp_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Pirai satunihato rhu yukatohmoumr. ");
INSERT INTO amp_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Yura mfhatpnonko mimkutn wom mrokfot wandfamomt. Nd mrokfot rom wandfakhato htamot kfo memot, “Ndarr Judaroh King Jisaser.” ");
INSERT INTO amp_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Jisasr tuhegirmo tkittn hus rikoh yimaf mano mano tuhegirmomf. Womr tirmifko hirmor, womr kindonko hirmor. ");
INSERT INTO amp_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Jisasr hegirmo bgre mis tu yihota yuhat tohettn rim fnahni mfnahniyuk yimam rim grha wase bowasenihato yihom kfo tfarnyi mkfo tfarnyamoumr. ");
INSERT INTO amp_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Kfo memoumr, “Ni kfo mayete, ‘Bro Nkifrarhu temperr yak tasohhato tfit husfirpa yiharpa tfit kasinyahato hingrnaruhanr.’ Ni inji kfet yimaye. To ni tu Bro Nkifrarhu Yon mifn rhu thombat, to btn wamifnahnekahtn ahtinomn.” ");
INSERT INTO amp_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nd prisroh bro yimam yo nkifra boririfhuthu tisam yo Judaroh bro yimam, rom rpat inji kfo tfar memomr, ");
INSERT INTO amp_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ndar yimar ror toh hingrna hnamohat bok met yindarim rorn fak marnya hnamorm. Asomift to nhai tur mifnahnekahtr htikahnomr. Ror to Isrerroh kinger. To amifnahnekahtr nom htiruhanomn duka mirahnom tu nmoh nrfa htiyakyuk yimayer. ");
INSERT INTO amp_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Bro Nkifrar hikwarn kfo kangr, ‘Na Bro Nkifrarhu Yona.’ To bt Bro Nkifrarhu yima yuhur rorpno rhu thombat, to Bro Nkifrar wom nefm anakahtrr nd bgre mis htanyhato amifnahnekahtr ahtinomr.” ");
INSERT INTO amp_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Nd mano mano hirmo yimaf rof nhaf kfo tfar botfar thumofr. ");
INSERT INTO amp_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Dany marrn marrhu nukeft be rim nohnimot. Kantri bugat be yambontift rhumom. Wuroh 3 kilok krif marr tfit niamor. ");
INSERT INTO amp_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tri kilok kanjo marr toh hanymor Jisasr tau nakuyafmor, “Eli, Eli, lema sabaktani?” Nd mrokfothu mrokfo yimbu yuhat inji kfiwut, “Nkifraye, Nkifraye, tamohmpno bi frtrohwona?” ");
INSERT INTO amp_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Inji kfo nakumotr brbo tohyuk yimam wanyaf hanyhato kfo memom, “Nd yimar Iraijar nakutr.” ");
INSERT INTO amp_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Yudbat womr toni hanyhato spans yakmorn wainpamn tayifakhato miyeftn htahato memom, Jisasr hikahtnom bupam ndtn tmasakrahr. ");
INSERT INTO amp_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Tfit womm kfo memom, “Awi bi mirahn ndm ahiyanr. Afo htiyaf hanyrahnom, Iraijar naku kfihat Iraijar finji naruharr?” ");
INSERT INTO amp_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Be wuroht tau nakuyafmorn be mfaknimor. ");
INSERT INTO amp_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Yimar myakni hanymo fijo nd bro rmonthar temperrhu tu Nngrajoh Hnaru Gnanhehr gna rafomor be buha mifn rmonthar yoh nmbrmorn mano mano rim rhu mrhumor. Yurak wuyoh nmbrakmorn miyoh nmbr witanihato mano mano rim hir mhirmor. Yo nunes rpat tonehato nd tkitkitroh yonmari yonmari tahim foh dbtoha wumtmom. ");
INSERT INTO amp_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Nd yima gum htamoa tahi muhm nd yiha foh bbomom. Yoh bbomotm bok yimam Bro Nkifrar hikhato noh hanymom nd yiha tfit sinya hanyhato ");
INSERT INTO amp_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","yopm htany hanymommn Jisasr sinyanimo mongkorn Bro Nkifrarhu taun Jerusalemko yihato wufau faumotm bok yimam htimoumm. ");
INSERT INTO amp_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Jisasr toh yukatohmoa keptenri soldiam nd nunesi tamoh tamoh nefm mfnahmom htihato nhai yimam rhurmom. Tuha mrokfo duhatm rhuhato kfo memom, “To finji tfit kforuhanom? Ndar yimar tu Bro Nkifrarhu Yon mifer.” ");
INSERT INTO amp_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","56","Yo tom wom metm be inji wuri kkof tohhato hti hasomoum. Taun Makdala efkot Mariati, Jemsri Josefrofhu mmem Mariat yo Sebedirhu mett, nd nd metm hti hasomoum. Nd metmn Jisasr Galilit tohmohat romn uhik ahik htfasmoamrn tamoh tamohm romn hiyaf hanymoumr. ");
INSERT INTO amp_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Krifnano taun Arimateathu wom maru kunyet yimar yimor. Rorhu yufat Josefr. Ror to Jisasrhu disaiperr tohmor. ");
INSERT INTO amp_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ror yimorn Pailatr mkfo ttiwonmorr Jisasrhu thatipthu yaknineft. Mkfo ttiwonmotr, Pailatr kfomotr soldiar ror tohukatohmotrr fakmort Jisasrhu thatipt. ");
INSERT INTO amp_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josefr thatipt rim htahato nfri ganyom rmonthaye rir borirmorr. ");
INSERT INTO amp_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Rir borirnihato turhu nfri tahi muh mift hanyhato rihtamorr. Nd tahi muht bi tu Josefrn yimam kfomotrm hingrnamomt. Thatipt rihtamortn tfit bro tahis yakhato tahi muhthu yifhatikt hta titto tanymortn yimor. ");
INSERT INTO amp_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Makdala efkot Mariati wom Mariat brbo yimar rihtamo tahi muhthu nyingatikko rhuhato hti hasomof yimar rihtamohat. ");
INSERT INTO amp_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Tfit hwe nfha ndwom marrn, ndr tu Sabat yiharn, prisroh bro yimami Farisim yimom Pailatrhu htit. ");
INSERT INTO amp_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Yihato kfo memomr, “Bro yimaye, nom dukewunomt wom mrokfot nd brurmahr yuhre yima nfrir tohhato kfomot. Kfo memor, ‘Na husfirpa marm rhunihato tfit sinyaruha.’ ");
INSERT INTO amp_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Soldiam yihato husfirpa marm toh yukatohkfot. Ka turhu disaiperm yaknihato nndo htaruhamtn tfit kfo nheh mirahm, bi sinyani yifir. Nd nohro yimarn bi wom kfo fura nheh mrokfom kfomorm, yo tfit romn tfit wom kfo fura nmbuhat htarahmt, ndtn be tu krhonano yiraht.” ");
INSERT INTO amp_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pailatr inji wanyhato kfo memorm, “Soldiam wayaknikahkomn yopt romn atoh yukatohtwamt. Nd tahi muht hta tasifyuk tahis wom makkfot htakfot. Yimam nd tahis yak tuhafhato yimar rimak rikohneft nd makkfotn hti nhtarahko.” ");
INSERT INTO amp_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Be inji wany hik marnya tanyhato yimom. Yihato nd tahi muht tahiye frkih marnyamomtn makkfot htamomtn yopthu toh yukatohyuk soldiam htamomm. ");
INSERT INTO amp_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Sabat yihar rhunimomrn tfit wom nfri wikrhu barkof yiharn marr yuhre mwondh hanymor, Makdala efkot Mariati wom Mariat yimof yopthu htit. ");
INSERT INTO amp_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Nd metf yi hanymof, yudbat nunes tonemot. Nd nunespno Brorhu mounmotr hefenko wutoh tanyhato nd tahi muht frtasifmo tahis rihtafmortn yura tahis mrhumor. ");
INSERT INTO amp_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nd mounmotrhu nyingatikt hatohmo nukeft yifatohmohat memom nndo binasohtn kak dbratwom, ror hmbremo hmbreshamn memom nndo yindeng nyisofr fnhutwor. ");
INSERT INTO amp_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Soldiam inji wahtimohat nhai yimam rhurmom. Yafotham frbrirakhato tuha wawutthamohat memom nndo ginunes kekwotm. Yimam noheh yimam kanjo rhumom. ");
INSERT INTO amp_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nd yopthu htit yiyuk metf, mounmotr kfo memorf, “Nifn mirahfn ayakrmanyo. Na htitanfn nifn nd bgre mis kihegirmo yima Jisasrhu hti hambrot niefn. ");
INSERT INTO amp_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Mirahfn ka wom asor. Nhai. Be bi sinyanir tur kfomo kanjo. Afo wania wahtifnt ror htamo tkitt. ");
INSERT INTO amp_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Wahti tanykahfnt, tfit bmbri waikahfnn rorhu disaiperm wakfo hany wamitwafnm bi sinyern be bi tfit Galiliko tohak hanitr. Ndko ai ahtitwamr. Inji wakfo nuhastwafnm nanhu kfo nuhas mrokfot.” ");
INSERT INTO amp_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Be nd yimar htamo tahi muht yakrmenano htanymoftn yimof. Wom yima yuhur fakrmemof, tfit wom yima yuhur be yindhorhato tonemof disaiperroh kfo nuhass. ");
INSERT INTO amp_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Tone hanyhato buha Jisasrpno mnafurhato kfo memorf, “Hifa dbhayer.” Be rof inji wanyhato yauyaknimofn, rorhu wuram rimakitohhato kfo hbraumofr. ");
INSERT INTO amp_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jisasr kfo memorf, “To nifn mirahfn ayakrmanyo. Waikahfnn, nanhu nmemrom wakfokahtfnm Galiliko aiswam. Ndko na htirahma.” ");
INSERT INTO amp_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nd met husf yuhre yihotat yau hanyetfn yima yopt toh yukatohmo wom soldiam taunko bi rim fnahnihato prisroh bro yimam kfo nuhas bonuhasmomm rom htimo nefm. ");
INSERT INTO amp_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Kfo nuhasmotmm prisroh bro yimam yihato Judaroh bro yimampno rpat rifinyhato wom yima yuhum naptha nafak nhtamom. Naptha nayak nhtahato wom bro marufat yakhato nd yima gur htamo tkitt toh yukatohmo soldiam hehato ");
INSERT INTO amp_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","kfo memomm, “Nd yima Jisasr sinyanimo yuhat yimam kfo ttiwon hnewum, wakfo wami-twakomm, ‘Nom hweyetnomn turhu disaiperm yifung yihato rim fak rikohmt rorhu thatipt.’ ");
INSERT INTO amp_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Tfit Pailatr nd mrokfot wanyhato finji kfiwur, nom tunomn yihato mrokfot yak marnya bomarnyaruhanomtn niko be mrokfo duhatko rhurahko.” ");
INSERT INTO amp_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Be nd soldiam nd maruham yaknihato nd bro yimam kfomo mrokfo yuhat fak hikmom. To be arihat to be nd mrokforpat Judam kfo ptha hanitm. ");
INSERT INTO amp_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jisasrhu 11-pela disaiperm be Galiliko yihato mifnahmom nd Jisasr kfo htafmo kmi yihofrn. ");
INSERT INTO amp_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ndha Jisasrpno mnahtimohat kfo hbraumomr. Womm nhai kfo hbraurmomr, hus dukefetm rhumom. ");
INSERT INTO amp_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jisasr nd yimampno brbo rim tohhato kfo memorm, “Ndar mounti bbinysoft yorhwa tamoh tamohm Bro Nkifrar bi nanhu tirtn htamorm. Bi nann kakitohwanm. ");
INSERT INTO amp_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ndnettn kanganko, kmiyakmim wayau fnahkahkomn nanhu disaiperm wayak hta fnahtwako. Yak hta hanyhato Bro Yifemri yinem Jisasr ee Bro Nkifrarhu Yafotharoh yufampno baftaisim tany hanykfot. ");
INSERT INTO amp_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Yo nd na niko kfo nuhas bonuhasyuk mrokfom waptha nuhas bugatwakomm. Wawanyko, na toya, tohnho hakuruhanko yiha yiham. Be inji tohnhohany tohnhohany tu wuroh yiharne be.” ");
INSERT INTO amp_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Asom Bro Nkifrarhu yon Jisas Kraisrhu barkof gutnius mrokfefm. ");
INSERT INTO amp_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Bi profet Aisaiarn bi barkof mrokfot kfo memor, “Ninhu yi mrokfefthu kfo nuhas hanyuk yimar bi kfo tkruraf hanyrhotanr bi rorn tohak hanyhato mrokfot bi kfo hanyrahrt. Rorn bi tohak hanyhato yihotar bi yau mngon hanyrahrr.” ");
INSERT INTO amp_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Wom yimar nungur tik furatn tohhato kfo mirahrko, ‘Bro Nungothetrhu nia yuhat wayak marnyak hanyhekomr.’” ");
INSERT INTO amp_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Nd kfo htamo mrokfot Jonrn kfomot. Jonrn nd nungur tkit furat toh habrihato met yindarim kfo memourm, “Nikmoh fasoh fasoh nefm mong trohkahkomm baftaiskfot. Baftaiskahtko Bro Nkifrar yak thuhirahrko nikmoh fasoh fasoh nefm.” ");
INSERT INTO amp_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Jerusalem thofm yo Judia-korhofm Jonrpno yihato nd rroh fasoh fasoh nefm kfo nriyafnimoamm tek Jodentn baftaisimmourm. ");
INSERT INTO amp_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nd yihart Jonr kamer tmb hingrnayet hmbreshat hmbremour yo let bando thaye nyuh dbkafmour yo rit papkumi winepam, ndm yehato tohmour. ");
INSERT INTO amp_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ndha ror tohhato kfo memor, “Nanhu mongko nia hnewa yimarn, tu bro bbukeft hatohwor. Na nhai ror kanjo bbukeft hatohkaha. Na, na be yima furaya rorhu senderfhu ki jbkafyuk mtinf kak nyusakahukanr. ");
INSERT INTO amp_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Na tek bupa furaye baftaisimwanko. Kto ror niko yimako baftaisim thombat Bro Nkifrarhu Yafothaye baftaisimrahrko.” ");
INSERT INTO amp_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Be tor nd yiharn Jisasr Galilikorhof kmi Nasaret htanyhato niamor. Niamotr Jonr tek Jodentn baftaisim-morr. ");
INSERT INTO amp_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Jisasr baftaisneftpno wuyak muhakmorn tfit mfrsohneftpno yura mountko htimortko rim rhu mrhumot. Yiro moun rifhu yuhatn wuhtiyak-mort Bro Nkifrarhu Yafothat ganyom mmkrs kanjo yak nhombranehato fawihnamot. Be nd ganyom mmkrs yawihnamotn yimar mirhumot. ");
INSERT INTO amp_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Tfit yura mountko wom tngt wanymort. Nd tngt kfo hany memot, “Ni nanhu yone. Nanhu marbit korhwot ninn. Hifa hti yindhorwann.” ");
INSERT INTO amp_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Be yudbatn Bro Nkifrarhu Yafothat niahato yak hatoh hanymottr yimor nungur tik furatn. ");
INSERT INTO amp_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Jisasr 40 yiham nd tkitt tohhato Satanr niahato kfo nheh bonhehmourr. Jisasr ndha tohmohat graf fohmpno tohmour. Mounmotmn yihato romn toh dbu hmbre yaknimotmr bbukeft tfit fakmor. ");
INSERT INTO amp_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Jonr bi kalabus yiyetrn to be Jisasrn Galiliko yihato Bro Nkifrarhu gutnius mrokfefm ptha habrimourm. ");
INSERT INTO amp_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Kfo memour, “Asor bi tu yiha mifr. Bro Nkifrarhu kingdomkfot bi brbohwot. Nikmoh fasoh fasoh nefm wamong trohkahkomm Bro Nkifrarhu gutnius mrokfotn wawany yakiokomm.” ");
INSERT INTO amp_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Jisasr Galili bari thmbt yau hanyhato Saimon Andru najohf rugit yak yif hasetfn htimorf. Rof nd hingrneft hingrnahato maru kakmouf. ");
INSERT INTO amp_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jisasr rof htihato kfo memorf, “Nann wania wahikfn. Nann wahikkahtfn yimaroh yakneft yak nuhasruhanfn.” ");
INSERT INTO amp_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Be rof inji wanyhato nd rugi wuskar myak htanihato mhikakni twanhomofr. ");
INSERT INTO amp_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Saimon Andru najohf yaknimorn tfit mbrnyi tefihato mhtimorf Sebedirhu yon Jems Jonrof. Rof nhaf mmbrtn tohhato rugim fak nahu dbofta hasomof. ");
INSERT INTO amp_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Be rof mhtihato kfo memorf, “Nann wania wahikfn.” Be yifem Sebediri wom hingrna yimam mmbrtn htanymofmn Jisasr mhikakni twanhomof. ");
INSERT INTO amp_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jisasr nd tur yak hanymo hik tamnou yimampno yimomn Kaperneamt mifnahmom. Ndha Kaperneamt tohetmn rhu krna Sabat yihar rhumomr. Nd yiharn Jisasr ndharhof rhu rifinyuk rmonrn yihato Bro Nkifrarhu mrokfom rikfo nuhas bonuhasakmorm. ");
INSERT INTO amp_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Jisasr mrokfom pthamohat nhai nd nkifra boririfhu tisam kanjo ptharmotr wanyrmomr. Nhai. Tu hifa ptha yembindtmotrm, yimam nd ror pthayuk mrokfom wanyhato bok dukefm yakhato duka memom, “Barenko, ndar yimar pthiwa mrokfom hifa ptha yembindt marnyewurm.” ");
INSERT INTO amp_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Nd rhu rifinyuk rmonrn rhumor kmi yarh fknayet yimar. Jisasr kfo nuhas hanyetrn nd yimar sinyahato tau nakuyafhato kfo hutt memor, ");
INSERT INTO amp_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Nasaret thof Jisase! Ni asha niaronn, nome finji naruhannom? Nmoh yak batit niaro? Hti nhtiwann ni Bro Nkifrar yak htamo yimaye.” ");
INSERT INTO amp_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jisasr sinyahato nd kmi yarhr kfo hutt memorr, “Ni nd kmi yarhe, tmifn tngt wayoukihkahnt, nd yimar wathu troh tanynr.” ");
INSERT INTO amp_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nd kmi yarhr inji wany hambtunihato tau tneh fnahmorn nd yimar thu troh tanymorr. ");
INSERT INTO amp_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nd yimam inji htihato be tuha mifoh rihanimom. Tuha tum rinakfo nakfo memom, “Bar yimako, ndart be tu wom nfrineft htitwonom. Nd yimar pthe mrokfote tamoh bbukettn nd kmi yarhr wany hambu tanyhato nd yimar thu troh tanyrr?” ");
INSERT INTO amp_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Be nd yima rifhur nd neft htihato Galili kmi bugat nakfo nuhashi hanymom. ");
INSERT INTO amp_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Be nd rhu rifinyuk rmont htanyhato tfit yimom Saimon Andrurofhu kunysn. Jems Jonrof rpatn nd Saimonrofhu kunysn fknenimof. ");
INSERT INTO amp_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimonrhu matohemt kkah dbohneft yakmottt hwemot. Jisasr fknenimohat kfo memomr, “Tot rot inji dbohnewut.” ");
INSERT INTO amp_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Be Jisasr wanyhato rotpno yihom tohhato tirtn wayakmortn teh kasinyamort. Be inji teh kasinyamotrt nd dbohneft thu troh tanymott. Be nd mett yudbat marnyani hanyhato sinyamotn yeshrim hta mskahemotm. ");
INSERT INTO amp_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Krifnano marr bi yohniyetrn, bok dbohnet dbohnetm, kmi yarh fknayetm hne hnamomm. ");
INSERT INTO amp_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nd kmithu met yindari bugat niahato nd ror rhumo kuny yifhatiktn nia rifiny yukatohmomr. ");
INSERT INTO amp_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jisasr fnahnehato bok met yindariroh wonk wonk dbohnefm fak marnya hanymorm. Yo nd kmi yarh fknayetm fak thu hanymorm. Kmi yarhm Jisasr hti hikhato duka memom, “Ndarr tu Bro Nkifrarhu Yoner.” Be ndnatn Jisasr kfo gadiyaf hanymoatrm, nhai tfit pthani hanyrmoam. ");
INSERT INTO amp_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Tu dbha ksfutn Jisasr fnahnihato nndo yima toh duha tkittn yihato kfo bruttnamor. ");
INSERT INTO amp_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saimonri wom yarmotemrom htiyafo hanyhato hik hanymomr. ");
INSERT INTO amp_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Yau hikaknihato mhtimomr. Mhtihato kfo memomr, “Met yindarim hambriwumn.” ");
INSERT INTO amp_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jisasr wanyhato kfo memorm, “Be tmifnom tfit wom nndoh kmimn ainyom. Yiruhanomn na wom mrokfom kfo ptha nuhasruhanm. Na to nd mrokfom ptha habrineftn niamoya.” ");
INSERT INTO amp_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Be Jisasr Galilithu kmi kmim yi htfasmorn Judaroh rhu rifinyuk rmonm yihato mrokfom ptha nuhas habri yo nd kmi yarh fknayet yimam yak marnya, inji na htfasmor. ");
INSERT INTO amp_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Wom lepra dbohneft yaket yimar Jisasrpno bangu mtabokmehato kfo naku memorr, “Jisase, ndar na hatohwa dbohneft ninhu tnge kforahn, nd dbohneft thu troh tanyrahta.” ");
INSERT INTO amp_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Inji kfomotr, Jisasr yuhuwafhato nd leprayet yimarn tirt rihtahato kfo memor, “Nhai mrokfefm, yak thuruhant.” Inji kfoni hanyhato nd dbohneft kfo memort, “Wathu trohnr.” ");
INSERT INTO amp_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Be inji kfomotr, nd dbohneft yudbat thu trohmotr. ");
INSERT INTO amp_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Thu troh tanymottr Jisasr wom kfo duka mrokfot kfo memorr, ");
INSERT INTO amp_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ni nda dbohneft thu troh tanyhat, mirahn tfit womm akfo nuhasanm. Mosesrhu boririfhut yak hikkfot. Yimam lepra dbohneft yaketm marnyanimoahat inji namoum. Nd hun gifam prisrpno myak nuhasnimoamn, tarioh mthamoum. Nd tarioh mtha yiharn prism ndt htihato kfo memoum, ‘Nd yimarhu dbohneft bi thu troh tanymotr.’ Ni nd yuhat yak hikkfot.” ");
INSERT INTO amp_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Inji kfo tungunafmotrr yimor. Yihato kfo nriyafmort. Bok tng rihar rhu fnahmott, bok yimam wanyhato niamom. Be ndnatn Jisasr nhai tfit yiro kmim yihato met yindarimpno naffrmoar. Be inji yima toh duha toh htfasmour. Inji toh htfasmoatr yimam be niahato htimoumr. ");
INSERT INTO amp_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Dfik marm yinyimotm tfit Kaperneamko yimor. Ndko yihato wom kunys rhuhato pthamoatr met yindarim rhu wany yakitohmoumr. ");
INSERT INTO amp_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Nd kunyr rifinyaknimohat memom nndo tpmhur tohwor. Kuny yifhatik yuhat finji wom finji yimam yihom fnahni mfnahnikfot. Ror Jisasr nd kunysn rhuhato Bro Nkifrarhu mrokfom kfo ptha nuhasmourm. ");
INSERT INTO amp_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nd kunysn ptha hasetrn wom minysafet yimar husfihus yimam hnamomr. ");
INSERT INTO amp_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kunyr be tng mnderpat tohmotr, nhai wom yihotoham nd yimarhu hanyukm. Be inji htitihato yura kuny mingiahus yak tmbrafmomt to be nd yuhatn nd minysafet yimar fafho thumomr. ");
INSERT INTO amp_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nd yimar hany rim htamohat rroh dukefm duka memom, “Jisasr yima yak marnyeter. Nda minysafet yimar ror kforahr be marnyanirahr. Nhai tfit nd minysaf rifhut rhuruhattr.” Be Jisasr rroh yima yuhum inji htihato kfo memorr nd yimar, “Bar yinowe, ninhu fasoh nefm bi fak tuhahuyann.” ");
INSERT INTO amp_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Nkifra boririfhuthu tisam Jisasr pthamo tngt wanyhato tum rinahti nahtihato kfo memom, ");
INSERT INTO amp_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Tamohmpno ndhtet mrokfot kfiwar? Kangr Bro Nkifrarhu tkitt ayaka. Nhai wom yima furarn yimaroh fasoh nefm yak thukfot. Bro Nkifrarpar yimaroh fasoh nefm kak thuworm.” ");
INSERT INTO amp_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Nd yimaroh yima yuhum inji dukamohat Jisasr bi htimorm. Htihato kfo memorm, “Tamohmpno inji riduka adukiwako? ");
INSERT INTO amp_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kangko finji akfoyane? Kangko akfo amiyanr, ‘Ninhu fasoh fasoh nefm bi fak tuhahuyann?’ O kangko akfo amiya, ‘Wasinyakahnn krokt wayaknikahnt wayauyakni?’ ");
INSERT INTO amp_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Na, Bro Najoma, yimaroh fasoh fasoh nefroh yak thu yafothat Bro Nkifrar bi hemora. Afo asomif wom neft yak nuhasrhotanko, duka mirahko nd yimar bro yufeter.” Inji kfoni hanyhato nd tir wura minysafetr kfo memorr, ");
INSERT INTO amp_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Na kfiwann, wasinyakahnn krokt wayaknikahnt tunhu kunyko wain.” ");
INSERT INTO amp_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Be inji kfomotrr, tuha nd yima rifinyrhu nyingahato wasinyamorn, nd tur hwemo krokt yakmortn, be yimor kunyko. Be nd toh rifiny hasoyuk yimam htihato be tuha mrokfo duha tohmom. Tuha Bro Nkifrarhu yufat kfo yindhorhato kfo memom, “Nom hrekrpa ndhtet neft htitawonom.” ");
INSERT INTO amp_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jisasr tfit bari thmbko yimotr bok met yindarim rifinymotm Bro Nkifrarhu mrokfom hemorm. ");
INSERT INTO amp_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Mrokfom ptha tanyhato yimor. Yau hanyhato Alfiusrhu yon Lifair yihom htimorr takis marut tuyuk kunyent rhu hasetrn. Yihom htihato kfo memorr, “Wania wahikna.” Be Lifair sinyahato fak hikakni twanhomorr. ");
INSERT INTO amp_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jisasri disaiperm Lifairhu kunys yi nuwa yamohat bok takis marut yakyuk yimam yo fasoh nefm nayet yimam rpat yihato nuwa famom. Ndhtet ndhtet yimaroh Jisasrpno rpat yi htfasneft bi riruhakmot. Nhai be nd yiharpar hikrmomr. ");
INSERT INTO amp_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Farisiroh boririfhuthu tisam htihato rorhu disaipermpno yihato kfo memomm, “Tamohmpno nd takis yekwa yimami nd ufasoh nefm nayet yimampno rpat rhuhato nuwa ye mskewar?” ");
INSERT INTO amp_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jisasr wanyhato kfo memorm, “Yima furam nhai be yi furakahm hunkotharpno. Nhai. Dbohnet yimarpam kitwom hunkotharpno. Na nhai dborioh yimaroh dukeftn niarmoya. Nhai. Na fasoh fasoh nefm nayet yimaroh dukeftn niamoya. Memoya, fasoh fasoh nefm nayet yimampno yirhoyann, kforuhotanm, nd rroh fasoh nefm yafhorahmm.” ");
INSERT INTO amp_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Jon Baftaisrhu uhik ahik htfasyuk yimami Farisim nuwa kurhato Bro Nkifrarpar rroh yima yuhum htamom. Nd Jon Baftaisrhu yimami Farisim inji namotm wom yimam htihato Jisasrpno niahato kfo memomr, “Jonrhu uhik ahik htfasyuk yimami Farisiroh uhik ahik htfasyukm nuwa kurhato tohwam. To tamohmpno ninhu disaiperm nd rom hingrnewa yuhat yak hik duha yitam?” ");
INSERT INTO amp_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jisasr kfo memorm, “Wom yimar kangr tuhan ayaka, ka nd rorhu tuhan yak yihar ka rorhu yimatm marifom afo nuwa kurhato afo brioh tohrahnom? Ka inji narfom? Nhai. Nhai rompno yuhre tohetrn ndhtet neft narfotm. ");
INSERT INTO amp_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","To tfit kto yak hambrafruhamr, ee bt rorhu yimatm nuwa kurhato rhurahm. ");
INSERT INTO amp_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nhai yimam bingotrhof hmbresham muhetm rhuneft tfit nfri rmontha nmbrm yakhato nahukahmm. Yatk hmbreshathu muht tfit nfri rmonthaye nahuneft nfri rmontha nmbrtn teh hma bugarfott yatk hmbreshat. ");
INSERT INTO amp_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Yo nhai yimam nfri wain bupam yakhato yatk meme tha kpmn tas hmbrikahmm. Nfri wain bupam yakhato yatk meme tha kpmn tas hmbreneft nd nfri wain bupam rikur prhoruhamn nd yatk meme tha kpt frtfohhato wain bupam mitoh bugarahm. Ndnettn nfri wain bupam tu nfri meme tha kpe tas hmbrihato be nhai kpm yoh tfoh inji naruhatm.” ");
INSERT INTO amp_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Wom rhu krna Sabat yihar Jisasr wit swirthu wit suhmn fau nanyor hanymor. Turhu disaiperm rpat yau hanyetmn to nd wit shuroh wit dmm tmbhakmomn fi hanymom. ");
INSERT INTO amp_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Farisim htihato Jisasr kfo memomr, “Tamohmpno inji nem? Bro Nkifrarhu thfa mntwat inji kfiwut, rhu krna Sabat yiha nhai ndpan ndpam tmbhakkfot.” ");
INSERT INTO amp_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jisasr inji wanyhato kfo memorm, “Nikone Defitri wom yimam yatinoht rhu hasohato nkifra rmont rim htayet nuwa rikat rim yakhato yamo nmbuhathu tndhte, ka htitkomt o nhai? ");
INSERT INTO amp_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Abaiatar Bro Nkifrarhu temperthu tohak yimar tohmo yiha, Defitr yatinoht rhu hasohato Bro Nkifrarhu temperr fknenihato nuwa rikat bi Bro Nkifrarhu yufatpno rim htayukt rimakmortn, briahako turhu yaunho habriyuk yimampno rim htahato famomt. Nuwa rikat bi Nkifrarhu yufatpno rim htayukt nhai be wom yima furam ye wonakrmomt. Tu prisrpam fiyakmomt. ");
INSERT INTO amp_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Bro Nkifrar Sabat yihar htamohat yimaroh rhu krnayuk yihar htamorr. Nhai be marimor, boririfuhett rhuhato nd boririfhutn yimam yak hta bohtahato muh wohne tuhnirahm. ");
INSERT INTO amp_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Wawanyko, na Bro Najomann nd rhu krna yihar kakitohwanr. Nd yihar kanga finji anaya, nhai tfit wom yima furar kfo htakfot.” Ndnatn nd Jisasrom namo neft nhai fasoh neft narmom. ");
INSERT INTO amp_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Wom yihar Jisasr Judaroh rhu rifinyuk rmont fknenihato rim htimorr wom tir gram tip minysafet yimar. ");
INSERT INTO amp_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Wom Farisim memom, “Jisasr nayuk tamoh nefm na thombat afo hti hikrahnomr. Hti hikhato kfo hndhnarahnomr.” Ndnetmn rhuhato memom, “Afo htirahnom dbohnet yimam rhu krna Sabat yiha yak marnyarahrme nhai.” ");
INSERT INTO amp_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Nd tir gram tip minysafetr Jisasr kfo memor, “Buha yima rifiny buharn wasinya watohetohn.” ");
INSERT INTO amp_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Be nd yimar sinya tohmotr, Jisasr kfo ttiwon memorm, “Niko finji dukiwako? Rhu krna Sabat yiha yimaroh yak marnyakfote, Bro Nkifrarhu boririfhut finji kfiwat? Rhu krna Sabat yihare hifa nefm nakfot o fasoh nefm nakfot? Yimam yak marnyakfot o yimam waskfot?” Inji kfomotrm nhai wom mrokfot kformom. ");
INSERT INTO amp_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nd yima rifinyr yukatohhato nyingatikt nndo yopaye nrhamomr. Duka memor, “Nda yimam nhai wom duka yuhuwaf yima yuhum rhukahm nda yimar htitahat.” Be inji htitihato wom yuhuwaf yima yuhur niahato nd yimar kfo memorr, “Tir gram tipt wathu susnant.” Be nd yimar tir gram tipt thu susnamort. Thu susnahato marnyanimotr. ");
INSERT INTO amp_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Be nd kunys rhuyuk Farisim inji wahti tanymohat nhai wom warhurmom. Be fnahni twanhomom. Fnahnimomn Herotr hikwa yimampno yihato wajis harhumom. Memom, “Jisasr wasrahnom.” ");
INSERT INTO amp_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jisasri turhu disaiperm ndhart htanymomtn tfit yimom Galili tek bariko. Yonmari yima rifhur Jisasr htiyafo hanyhato mfau hikaknimomr. ");
INSERT INTO amp_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Kmi kmirhof yimam fau hik hanymomr. Galili thofm, Judia thofm, Jerusalem thofm Idumea thofm, Jodenthu mano mkuko tohyukm, yo Tair thofm, Saidon thofm. Nd nd kmim nia bugamom Jisasr namo nefm wanyhato. Duka memom, “Nom tu nomn yihato hti hikrahnom.” ");
INSERT INTO amp_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jisasr nd bro yima rifhur htihato turhu disaiperm kfo memorm, “Mmbrt bi brbo ania hnetwat. Nda yonmari yima rifhur yakaknerhotma finji yirhoya?” ");
INSERT INTO amp_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Bok yimam yak marnyamotrm btn wom womt nd dbohnetm furyakni furyakni memom, “Brbo yihato Jisasr myak tiwonruhatnom dbohnefm marnyanirahm.” ");
INSERT INTO amp_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Nd kmi yarhetm o tek yarh fknayet yimam Jisasr htimoahat be taunihany taunihany fnahnimoum. Mrokforpat tu tany memoum, “Ni tu Bro Nkifrarhu Yone.” ");
INSERT INTO amp_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Tu Jisasr kfo memourm, “Mirahko nanhu yufat yima rifiny buharn ayutanomt.” ");
INSERT INTO amp_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Jisasr yura kminysofko muhmorn naku yakmorm nd tur yak yibonmo yimam. Nakumotrm yimom. ");
INSERT INTO amp_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Yimotm 12-pelakfot fakmor rorhu sioskfothu kasinya htfasyuk aposerm. Duka memor, “Nann tohnhorahma. Tkrurafrhotanm yiruhamn Bro Nkifrarhu mrokfot romn ptha nuhas habrirahmm kmi kmim.” ");
INSERT INTO amp_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Yo memor, “Kmi yarh tek yarhroh yak thuyuk yafothat heruhanm.” ");
INSERT INTO amp_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nd ror yakmo 12-pela yimam: Saimonr (tfit rorn wom yufat hmbremorr Pitar), ");
INSERT INTO amp_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","yo Sebedirhu yon Jemsr yo nmem Jonr. Wom yufat tfit tu Jisasrn futamorf Boanesis. Yufathu yimbu yuhat, “Tohrhu Yonf.” ");
INSERT INTO amp_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Yo Andrur, Filifr, Bartolomyur, ee Matyuri Tomasr. Yo womm Alfiusrhu yon Jemsri Tadiusr yo Selot patikfot tohmoa yima Saimonr, ");
INSERT INTO amp_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","yo wurohr Judas Iskariotr. Tor nd Judas Iskariotrn Jisasr hndhnamorr. ");
INSERT INTO amp_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Jisasr kunys fknenimor tfit bok met yindarim kunys yakaknimotmt nhai nuwa yarmom rorhu disaipermpno. ");
INSERT INTO amp_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Be turhu mmemti nmemrom inji wanyhato memom. “Bi bok yimam yak hamumaknitatmr bi ka mfhat mmrifwotr.” Ndnatn memom, “Arim htiyaknomr.” ");
INSERT INTO amp_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Nd Bro Nkifra boririfhuthu tisam Jerusalemko wutoh tanyhato niamom. Niahato Jisasr kfo wok memomr, “Jisasr tndh Belsebur tohworr. Jisasr nd neft nihat yarhroh bro tohak Belseburrhu bbukeftpno kak thuworm kmi yarhm.” ");
INSERT INTO amp_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jisasr inji wanyhato nakuyakmorm. Nakuyakhato kfo nhombra memorm, “Tndh yarh Satanr sinyahato wom yarhm yak thuneft, be nhai wom yarhm tohruhatm. ");
INSERT INTO amp_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Rpa kantrikfot tohyuk yimam buha nayak mkuhato rim toh mtohhato nnakni-neft, be nd kantrikfot yohniraht. Nhai wom yimam tohruhatmt. ");
INSERT INTO amp_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Yo rpa kunys tohyuk yimam nhaf inji. Tum nayak mkuhato nnayurneft, be nhai wom yimar tohruhatr. Be tum naye dborha nohhato yima duha tkitm rhurahm. ");
INSERT INTO amp_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Satanr nhaf to inji buga. Satanr sinyahato wom yarhm yak thuneft, be nhai wom yarhm tohruhatm. Bi be. ");
INSERT INTO amp_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Nhai wom yimar wom nanyjar nngrajohet yimarhu kunys fknenihato yimar rhuhany rorhu kunys rhuyuk wuskam myaknihekfot. Afo nd kuny sikatr tir wuram kisahato ee btn rorhu kunyshu rhuyuk wuskam yaknikfot. ");
INSERT INTO amp_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Kfo mifwanko. Bro Nkifrar duka mmorahrm yimam nayuk fasoh fasoh nefm yo tamoh mrokfo bebm tnge pthayukm. ");
INSERT INTO amp_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","To fitoh yimar na Bro Nkifrarhu Yafothathu bbukeftpno hingrneta kfo famur, ‘Fasoh tndhrhu bbukeftpno hingrnewur,’ nd yimar nhai tfit kfo gbuhruhatrt, be Bro Nkifrar nhai duka mmoruhatrm nd yimar kfoyuk tngt. Nhai. Duka hatohrahrt.” Jisasr inji kfo nuhas bonuhasmorm. ");
INSERT INTO amp_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Tumn Jisasr kfo memomr, “Fasoh tndhr korhworr,” ndnetrn nd mrokfot kfo nuhasmorm. ");
INSERT INTO amp_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nd yihar Jisasrhu mmemti nmem najohfit niamomn, Jisasr ror yiro kunys ruhetrn briahako tohhato kfo memom, “Jisasr afo afnahnar.” ");
INSERT INTO amp_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ror bok met yindarim rhu dbu hmbremomr. Kfo memomr, “Ninhu mmemti nmem najohfit tom niem. Niemn, kangm ahtinomn.” ");
INSERT INTO amp_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jisasr wanyhato kfo memorm, “Frohmn nanhu mmemroyem? Frohmn nanhu nmemroyem?” ");
INSERT INTO amp_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nd ror rhu dbu habriyuk yimam yukatohhato kfo memor, “Asom ar yorhwam tom nanhu mmemromi nanhu nmemrom. ");
INSERT INTO amp_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Yimam Bro Nkifrarhu dukefr dukahato yak hikwam, tom nanhu mmemrom, mndaremrom, nmemrom.” ");
INSERT INTO amp_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Jisasr tfit Galili bari thmbt yihato met yindarim yak nhafohhato mrokfom kfo nuhas bonuhasmorm. Bok yima rifhur rifinymotr be Jisasr htitihato tek barit hiryuk mmbrtn mirhuhato to be met yindarim bari thmbtn rhuhato wany yakitohmoumr ror nd mmbrtn rhuhato pthamoahat. ");
INSERT INTO amp_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Boknambok mrokfom be kfo nhombramourm. Kfo memorm, ");
INSERT INTO amp_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Wawanyko. Wom yimar mswirt hingrnahato wit tpim yaknihato thu brur htfasmorm. ");
INSERT INTO amp_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Yihota tafont misuhyukm nungam yihato tout buganimomm. ");
INSERT INTO amp_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Wom tpim misuh hanymoum tahi siket tkitmn. Bbpam be htfapamn nd yewuri tpim yudbat dborhahato sinyamom. ");
INSERT INTO amp_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Tfit marr tahato tahi sikthu kkah nadbofnefrpno nd yewuri fanroh nembfam fftahato nohmom. ");
INSERT INTO amp_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Womm hig suhmpno misuh hanyukm rpat hig tofmpno sinyahato kihawot hmbriyafmotmm nhai yukha hirrmom. ");
INSERT INTO amp_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Nd tu hifa dborioh bbinysoft misuh hany-yukm romn tu hifa sinya marnya-momn yukha hir trukmom, womm 30 dmetm, womm 60 dmetm, womm 100 dmetm.” ");
INSERT INTO amp_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Kfo memorm, “Yimbhindangeteko, ndar na kfiwa mrokfot wanykfot.” ");
INSERT INTO amp_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kto Jisasr turpar rhu hasetrn turhu disaipermi wom yimam rorpno tohmoam niahato nd ror pthamoa kfo nhombramoa mrokforoh mrokfo yimbu yuham ttiwon hikmomr. ");
INSERT INTO amp_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Kfo memorm, “Wanukko, yafuna mrokforoh yakyuk dukefr bi nikomn hemor. Bro Nkifrarhu kingdomkfothu kafrohet mrokfom be kfo nhombra kanjo ptharahm o mrokfom be yura yafunarahm, nikomn dukefm bi yakrahkomm. Nd Bro Nkifrarhu yinhit toh duha yima furam be kfo nhombra mrokforpam wanukm. ");
INSERT INTO amp_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ndnettn nyingam yukatoh hakurahm, to nhai wom tamohm htiruhatm. Yo mrokfom, wanyrahm, wanyrahm, wanyrahm, to nhai wom dukefm yakruhatm. Nhai. Tumn htihato mrokfefm wany tungnemn, ee ka ndnatn yima yuhum yak krekutruhamm Bro Nkifrar rroh fasoh nefm yak thuhirahrm.” ");
INSERT INTO amp_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jisasr kfo memorm, “Ka nd kfo nhombra mrokfothu yimbu yuhat ka nhai yakkahkomt? Kane finji kforhota nd kfo nhombra mrokforoh yimbu yuham yakruhakomm? ");
INSERT INTO amp_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Nd yewuri tpiroh yimbu yuhat inji korht: nd yewuri tpi truf hanymo yimar, Bro Nkifrarhu mrokfom hta hanymor. ");
INSERT INTO amp_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Nd yewuri tpim yihotat misuhhato nungam nia yamom, ndm yimam Bro Nkifrarhu mrokfom yakhato tfit Satanr niahato yimaroh yima yuhum rhuyuk hifa dborioh mrokfom nia yak thuwa nmbuhat kfo nhombramoya. ");
INSERT INTO amp_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Yo nd tahi sikm misuhhato sinya duha yewuri tpim, ndm kfo nhombramoya yimam afo barkofpam hifa yindhor nmbuhatpno yudbat Bro Nkifrarhu mrokfot mhik tefi yaknitmt, ");
INSERT INTO amp_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","tfit tamoh krhopam kekwomm, to be bmbri thu trohwomt Bro Nkifrarhu mrokfot. ");
INSERT INTO amp_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Yo nd yewuri tpim hig suhmn misuhwam, ndm kfomot, yimam afo Bro Nkifrarhu mrokfot kekwomt. ");
INSERT INTO amp_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Mrokfot yekwamn, tfit ndar bbinysofthu dukefm kak wunefiwumt Bro Nkifrarhu mrokfeft. Womm tum hatohyuk krho nmbu-hampno duka krho hasiwum. Womm maruharoh dukefrpampno korh hasiwum. Womm hifa rhu nmbuharhu yaknefrpatn duka hasiwum. Nd nd dukefmn thu nhombranitatmm, Bro Nkifrarhu mrokfeft myafho thunitmt. ");
INSERT INTO amp_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Wom yimarpam nd yewuri tpim hifa bbinysoft misuhhato yukha hirmo kanjo rom mrokfefm yak marnyewamm yima yuhum htewamm yukha hirwom, womm 30 dmetm, womm 60 dmetm, womm 100 dmetm.” ");
INSERT INTO amp_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jisasr tfit wom ttiwon mrokfot htamort. Kfo ttiwon memorm, “Niko lamm hta thombat ka yiro rohmn kafknitkomm? O womnam yiro hwe tik rfashitn hta hamongwokomm? Ka nhai. Lamm buha dany yuhamn htewukomm. ");
INSERT INTO amp_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Nd kfo nhombra mrokfothu yimbu yuhat inji kfiwut. Bro Nkifrar, rorhu kfo kafrohet mrokfeft kto be tafontn yak htarahrt. Nd tamoh tamohm Bro Nkifrar yak wuna bowuna hasiwam, kto be tafontn yak htaruhatrm yimam htirahmm. ");
INSERT INTO amp_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Yimbhindangeteko, ndar na kfiwa mrokfot wanykfot. ");
INSERT INTO amp_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Niko wanyuk mrokfefm wany hik marnyakfot. Womm finji finji kahuknm, tawo inji hirahmn. Womm he hmarsirahnm, tawo Bro Nkifrarko he hmarsirahrn. ");
INSERT INTO amp_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Frohr mrokfom wanyhato yima yuhurn hmbri hterm, nd yimar Bro Nkifrar tfit thu hmbrihirahrr. Nd yimar mrokfom wanyhato nhai yima yuhur htarform, nd tefi dukefenr rorhu yima yuhur rhuyukr tfit tu Bro Nkifrarn yak thurahrr.” ");
INSERT INTO amp_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yo tfit wom mrokfot kfo memor, “Bro Nkifrarhu kingdomkfot inji korht: Wom yimar yewuri tpim trufworm. ");
INSERT INTO amp_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nd yewuri tpi trufyuk yimar, ror nd yifung marm hwita fijo rom nd yewuri tpim be turoh fijo dborhanihato sinyewum. Nhai tawisafkahr rom sinyewa nmbuhat. ");
INSERT INTO amp_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Be nd tu bbinysoftn thu warhewattm yukha hirwom. Sinyewohat afo dborhanitamn ee tuwa rfetm rhunihato ee tfa totwamn yukhetm korhm. ");
INSERT INTO amp_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Yukha hirnihato bi yak yibon yihayer, ee kekworm.” ");
INSERT INTO amp_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jisasr tfit wom kfo nhombra mrokfot kfo memorm, “Bro Nkifrarhu kingdomkfot finji akfo nhombrayant? Tamohmn akfo nhombraya? ");
INSERT INTO amp_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Bro Nkifrarhu kingdomkfot kangme tefi mastet tpiyenrn yimar yaknihato turhu mswirtn nuhterr. Mastet tpiyenr kangme sayor tpiroh tefi tpiyener. ");
INSERT INTO amp_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Nd mastet tpiyenr frdborhahato yonmari bufum korhm. Kto tkit tkitroh nungam ndha niahato wuswom.” ");
INSERT INTO amp_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Jisasr bok mrokfefm Bro Nkifrarhum miyukhamn, mimn, tamohmn kfo nhombramourm. Memour, “Akfo nhombrakahta yimam wany duka tungunarahm.” ");
INSERT INTO amp_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nhai be tu mrokfo yimbu yuham kfo hik nuhasrmoarm met yindarim. Nhai. Be kfo nhombra mrokfomn rim kfota mkfotamourm. Turhu disaipermpno ee tu mrokfo mna yuham kfo nuhasmourm. ");
INSERT INTO amp_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nd yiharhu tu wuroh krifn Jisasr turhu disaiperm kfo memorm, “Barenko, na kanga tek barit ahir tmbhonikahnomn, mkuko ainyom.” ");
INSERT INTO amp_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Be nd mmbrt, bi nd tur rhumot, mikmbremomn hahir hayukmomr. Nd yonmari yima rifhur tuha htanyhato yimom. Wom mmbrm rom rpat hir hayukmom. ");
INSERT INTO amp_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Hir hanymomn buha dany yuhatn bro wifort sinyamot. Nd wifort sinyahato bi fak mndhu hanymotm. Bi bus tas finjo hanymott mmbrt. ");
INSERT INTO amp_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jisasr mmbrthu yifhikorn yak tuhtanimorn hwemor. Nd wifortpno yihom yak thohato kfo memomr, “O Tisaye, wasinya. Nom bi wifort kak mndhutwotnom. Nine ka nhai yanhokahn?” ");
INSERT INTO amp_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jisasr wasinyahato nd wifort be tnge kfo memort, “Be tmifn, wateh tmbho.” Be inji kfomotr nd wifort teh tmbhohato tek barit nhai wom natonrmot. ");
INSERT INTO amp_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jisasr nd turhu disaiperm kfo memorm, “Tamohmpno yakrmitako? Nhai duka mekahko, ‘Rorpno kitwonom. Aduka yanhowahnom?’” ");
INSERT INTO amp_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Rom inji wany yanhohato kfo memom, “Ndarr tamohtet yimarn wiforti burifhut wany yakiohato minoh hmbrif?” ");
INSERT INTO amp_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Hir hanymomn manoh mkuko rim dbkafmom. Gerasaroh tohyuk mkukorn rim dbkafmom. ");
INSERT INTO amp_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Rim dbkafnihato Jisasr yuhre witani hanymor asha wom kmi yarh fknayet yimar yima yopko toh tany niamorn Jisasr mhtimor. ");
INSERT INTO amp_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Nd kmi yarh fknayet yimar be inji yima gum htamoa tahi bakuny mkumn hweta htfasmour. Yimam nhombratitamoum yakitohtaneft o sene kibokisaneft. ");
INSERT INTO amp_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Bok yiham hankafe, yo sene, tir wuram kisi, tu be nhai mif. Kimoumr, tfit tur wabbuka sinyahato frdbombhonimourm. Nhai rorhu yimaroh yakkfot. ");
INSERT INTO amp_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Yifung marm to be yima gum htamoa tahi bakuny mkumn yo yura kmi yihofmn toh hasomour. Btn tur mumakhato tau hifa bohifamour yo tahim yakhato nde tur puk finy bofinymour. ");
INSERT INTO amp_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Yau hnehato bi wuri tohhato Jisasr htimorr. Htihato be toniyakni twanhomorn Jisasrhu wurampno msuhmor. ");
INSERT INTO amp_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Msuhhato mtau ssiyakni memor, “Jisase, tu yura myorhekwa Bro Nkifrarhu yone, ni finji newuna? Bro Nkifrarhu yufatpno mirahn krho nmbuhat ahiyanr.” ");
INSERT INTO amp_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Jisasr bi kfo twanhomor nd yimar thu hammomoa kmi yarhrhu htanyeft nd yimar. Ndnetrn nd mrokfot kfomort. ");
INSERT INTO amp_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Jisasr kfo memorr, “Ninhu yufat wayutant.” Nd yarhr kfo memor, “Nom rifuhetnom tohwonomr ndar yimar. Ndnatn nanhu yufat, Rifuhetr.” ");
INSERT INTO amp_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Nd yarh fknayet yimar mkfo ttiwon rafak hany memourr, “Mirahn ayak tuhafkahtanm nndo wom wuri tkittn ain.” ");
INSERT INTO amp_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Wom kmi yorgenrn foh rifhum ke wussohmoum. ");
INSERT INTO amp_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Nd kmi yarhm Jisasr naku memomr, “Wakfo tkrurafkahtnnom nd fohmn tfit fknirahnom.” ");
INSERT INTO amp_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Be Jisasr kfomotr nd yimar hatohmo kmi yarhm thu troh tanymomrn tfit fohmn fknenimom. Be fohmn fknenihato thu hafunanimotmm, nd fohm kmi kihahir yuhat mitarhotnihato tek baritn mitayif wurasoh bugamom. Nd mitayifmo fohm 2,000 fohm mitayifmom. ");
INSERT INTO amp_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nd fohm hatohmo yimam inji htihato be tonayefrpar yakhato taunthu yimam kfo nuhas bonuhashato kmi kmi kfo nuhas fnahmomm rom htimo nefm. Bok yimam inji wanyhato memom, “Ai ahtinom nd neft.” ");
INSERT INTO amp_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Jisasrpno nd yimar kmi yarh htanyetr htimomr rmonthat tabhutahato tu hifa yima yuhu dukefrpno rhu hasetrn. Rom be inji mhtihato be duka yanuhefrpno tohmom. ");
INSERT INTO amp_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Jisasr nd kmi yarh fknayet yimar yak marnyamohat tuha tohyuk yimam hti hikmomr. Romn nd niayuk yimam kfo nuhas bonuhas hikmomm kmi yarhm nd yimar thu troh tanyhato tfit fohm fknihato tek mitayif wurasohmohat. ");
INSERT INTO amp_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Kmi thofm nd neft htihato Jisasr kfo memomr, “Ni be tmifn ndar kmit wahtanykahnt, wain.” ");
INSERT INTO amp_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jisasr tfit mmbrtn mikmbrehato memor, aiya. Nd Jisasr kmi yarh yak thumo yimar tfit Jisasrpno yihato kfo memorr, “Na kanga ahik hneyann.” ");
INSERT INTO amp_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jisasr wanyhato kfo rafo tany memorr, “Tuha kmitn warhu hasokahnn tunhu yimatm wakfo nuhastwanm ni Bror yuhuwafhato yak marnya bomarnyamo yuhat.” ");
INSERT INTO amp_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Be nd yimar inji wany yakiohato nd distrikthu 10-pela kmim yi habrimorn kfo nuhas bonuhasmorm Jisasr yak marnyamo nmbuhat. Bok met yindarim ror Jisasr yak marnyamo yuhat wanyhato be tu bok dukefm fakmom. ");
INSERT INTO amp_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jisasr tfit mmbrtn mikmbrenihato barit hir hayuknihato tfit mano mkuko yimor. Rim dbkaf hanymor yonmari yima rifhur nia rifiny hmbriyaknamomr. Be Jisasr tuha bari thmbtn tohmor. ");
INSERT INTO amp_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Judaroh rhu rifinyuk rmonthu wom tohukatoh yimar, rorhu yufat Jairusr, niamor. Niamorn Jisasr mhtihato rorhu wurampno mtabokmemor. ");
INSERT INTO amp_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Mtabokmehato kfo memor, “Nanhu yont noh wururifhut kekwott. Wania tir wahtakahtnt marnyaniraht.” ");
INSERT INTO amp_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Be Jisasr wanyhato hik hanymorr. Rof yimohat bok met yindari rifhur hik hanymomrn be nahuta yaborr hanymom. ");
INSERT INTO amp_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nd yima rifiny buharn wom dbottet mett rpat fau hanymom. Nd dbotteft 12-pela gunyjimm hatohmott. ");
INSERT INTO amp_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Yonmari marut be nd rothu dbottefthu htiyuk hunkotharoh wiknaneftpno tubatu witamott. Memout, “Ka hunkothamn htihato nd dbotteft yak raforahma,” to nhai, nd dbotteft nhai teh tmbhakrmoat. ");
INSERT INTO amp_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Nd mett Jisasr hingrnamoa bbukeft bi wanyettn to be Jisasrhu mongko yauyaknimotn Jisasrhu sakethat mtayoutimott. ");
INSERT INTO amp_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Rothu dukeft duka memot, “Rorhu hmbreshat be mtayoutiruha be nd dbotteft teh tmbhakraht.” Ndhtet dukeftpno mtayoutimotr. ");
INSERT INTO amp_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Be nd dukeftpno mtayoutimohat be yudbat nd dbotteft teh tmbhakmott. Tut yironamot nd dbotteft teh tmbhakmohat. ");
INSERT INTO amp_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nd mett inji namohat tu Jisasr tfit yironamor rorhu yima yak marnyayuk yafothar nd mett yak marnyamohat. Yironafhato tfit kekutnihato nd yima rifhur ttiwon memorm, “Frohr nanhu hmbreshat tayoutirt?” ");
INSERT INTO amp_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Turhu disaiperm kfo memomr, “Wahti bok met yindarim tip tip newamn mtayoutini hanitmn. Tfit tamohmpno kfo yamuka frohr mtayoutira?” ");
INSERT INTO amp_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Jisasr nd met yindarim hti nhombra memor, “Afo htiyanko frohrn tayoutira.” ");
INSERT INTO amp_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Be nd dbottet mett bi Jisasr inji kukatoh habriwore, rot tfit duka fanhomot. Duka memot, “To finji wom finji kafrohruhoya? Bi htitawora.” Be yudbat Jisasrpno rim tabokmehato kfo nuhas bugamotr rothu yak marnyamo yuhat. ");
INSERT INTO amp_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ptha nuhasmottr Jisasr kfo memort, “O ar yone, nd ninhu dbotteft, nd hatoh hnamot, duka famu, ‘Ror rimaktirhota, be nd dbotteft teh tmbhakraht.’ Ndnettn ninhu dukef yuhatn nd dbotteft teh tmbhektn. Be hifa yindhor yima yuhurpno waikahnn, watohtwa. Ninhu krho nmbuhat bi fak tuhant.” ");
INSERT INTO amp_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jisasr ptha hasetrn Jairusrhu kunyshom toni hnehato Jairusr yihom kfo kangmr, “Mirahn Bror ahany furayanr kunykort. Ninhu yont bi mfaknit.” ");
INSERT INTO amp_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jisasr rom pthayuk mrokfom wany marsisahato Jairusr kfo memorr, “Ni mirahn awany yanhoya. Ninhu bro dukefr be duka mekfot, ‘Nanhu yont tfit myenyjworaht.’” ");
INSERT INTO amp_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Be nd met yindari rifhur ndhar kfo rafo tanymorm rorhu hikneft. Pitari Jemsre Jonr, Jemsrhu habhir, romrpam husfirparpat kfaknimor. ");
INSERT INTO amp_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nd Jairusrhu kunys mwanyaknimomt yimam nur hasomohat. ");
INSERT INTO amp_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Jisasr kunys fknenihato rim kfo memorm, “Tamohmpno nurwako? Nd yont nhai nohrfot, be hwitwot!” ");
INSERT INTO amp_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Jisasr inji kfomotr haningemomr. Nd nur kunys rhuyuk yimam yak tuhafhato fnah buganimotm, nd yonthu yifammafi turhu husfirpa disaiperm yaknitarm yimom nd yont rhumo rumtn. ");
INSERT INTO amp_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Rim fnahnihato nd yonthu tirenr wayekwart kfo kangrt, “Talita kumi.” (Nd mrokfothu yimbu yuhat, “Metene, na kfiwann wasinya.”) ");
INSERT INTO amp_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","43","Be nd metent inji kfomotrt yudbat wasinyamotn ufaufaumot. Yonthu yifammaf inji htihato be tuha yafotha duhatf tohmof. Jisasr kfo memorf, “You! Mirahfn akfo nuhas mif mifnomm nda nifnhu yont myenyjwi yuhat.” Nd yonenthu gunyjimm 12-pelakfot. Inji kfonihato kfo memorm, “Nuwa wayak wahefnt.” ");
INSERT INTO amp_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jisasr nd ror tohmo tkitt htanyhato tfit yimor turhu kmitn. Turhu disaiperm rpat yimom. ");
INSERT INTO amp_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Turhu kmitn yihato rhu krna Sabat yiharn yimor Judaroh rhu rifinyuk rmontn. Yihato Bro Nkifrarhu mrokfefm kfo nuhas bonuhasmorm. Bok met yindarim rorhu mrokfefm wanyhato tuha mrokfo duhatn rhumom. Duka memom, “Nd yimare fitha nd bbukeft yakhato ndhtet nefm niwarm? Yo ndhtet dukefme fitha yakmorm? Nd ror hingrnewa mirakerkfome tamohtet tongr thu kihwatrr mhingrniwarm? ");
INSERT INTO amp_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nd yimar to wom kamdarhu yoner. Nd yimar to Mariathu yoner. Jemsr, Josefr, Judasr, Saimonr, tom rorhu nmemrom. Rorhu mndaremrom asom asha korhm.” Ndhtet dukefmpno nhai marimom, “Jisasr rihtirahnomr.” Nhai. Mong troh bugamomr. ");
INSERT INTO amp_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jisasr inji wanyhato kfo memorm, “Bro Nkifrarhu profetrhu yufat bi kmi kmim rhu htfaswot. Turhu kmiti turhu yorgre turhu kuny shofm, rompno nhai yufapa duhater.” ");
INSERT INTO amp_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Be nd dukeftpno nhai turhu kmit tamohtet mirakerkfom hingrnarmotr htirmomm. Be inji rpa rpa dbohnet yimarpam tirt htahato fak marnyanimorm. ");
INSERT INTO amp_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Duka memor, “Tamohmpno nd yimam nhai wany yakiokahmm nanhu mrokfom?” Inji dukahato yimorn Bro Nkifrarhu mrokfom ptha nuhas habrimor. ");
INSERT INTO amp_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Jisasr turhu disaiperm yak nhafohmormn tfit hus hus fak nhtamorm. Hus hus yak nhtamormn tek yarh kmi yarh yak thuyuk yafothar hiyaf hanymorm. Nd yafothar henyihato kfo tkruraf memorm, ");
INSERT INTO amp_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","“Niko yinyeft kio musrpam yakitohakkfot. Mirahko nuwa nakupam, hmbre wus yohm, maruham, nd ndm ayakitohaknom. Be inji sfno yikfot. ");
INSERT INTO amp_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Su wuraroh hmbrenineft rot nhai mrokfom. Hus yagr thafhu hmbrenineftne nhai. ");
INSERT INTO amp_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Yihato wom kmit fak miyekmko, kunys fahumko, be nd kunyrpat toh tanyhato tfit sinyani yikfot. ");
INSERT INTO amp_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","O wom kmit o taunt yihato nhai kunym yakmiyakhato niko hanyuk mrokfom nhai yindhorkahm wanyneft, nd kmit htanyhato fus wuram tuha nd kmitn frdbofta tanyhato htanykfot. Inji naruhatko, ndt htiruhamn, mirahm, ‘O nom yakmiyak duha yitnomm inji nem.’” ");
INSERT INTO amp_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Be nd Jisasrhu disaiperm yimomn Bro Nkifrarhu mrokfot kfo nuhashato kfo memomm, “Nikmoh fasoh nefm mong trohkfot.” ");
INSERT INTO amp_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nd kmiroh bok kmi yarh fknayet yimam fak marnya bomarnyamomm. Yo nd wom dbohnet yimam, be nd kahpaye htamoatrm marnyanimoum. ");
INSERT INTO amp_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nd Jisasr namoa nefm nhai wom rpa kmirpat wanyrmomt. Bi kmim rhu fnahmott king Herotr wanymort. Womm Jisasr namoa nefm wanyhato duka memoum, “Ka Jon Baftaisr minohakhato tfit sinyamorn ndhtet nefm newurm.” ");
INSERT INTO amp_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Womm duka memoum, “Ka Iraijayer.” Yo womm duka memoum, “Ka bingot tohmo wom profeter.” Be turoh yima yuhumn inji inji fak nhtamoum. ");
INSERT INTO amp_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","King Herotr Jisasr namoa nefm wanyhato kfo memor, “Nd yimare, Jon Baftaiser. Nd yimar to bi na mfhat tmbhomohat, to bi tor, bi tfit sinyamor.” ");
INSERT INTO amp_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","To bingot Herotr wom nmem Filifrhu tuhan Herodias yak hutfakmohat, Jonrn kfo memorr, “Ndhtet neft nhai tu dborioh neft narmo. Nkifra thfa mntwat kfo kangt, ‘Mirahn womrhu mett ayak hutfayanr.’” Inji kfomotrr, wom yimam kfo tkrurafmotrm Jon Baftaisr fakmomr. Yakhato kalabus htamomr. ");
INSERT INTO amp_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodias Jonrhu mrokfot wanyhato wanyhato namburmot. Namburhato memout, “Jonr awasanr.” To nhai, ");
INSERT INTO amp_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herotr Jonrhu wasneft mfanuhakmour. Duka memour, “Jonr tu dborioh yimayer, Bro Nkifrarko kukatohworr.” Ndnetrn Jonrhu toh nmbuham Herotrhu mofsinhitn tohmour. Jonrhu pthayuk tamoh tamoh mrokfefm Herotr nhai hamuh tfafrmoarm. Nhai. Be rorhu yima yuhur mrokfefm wanyhato krhomourr. To nd yima yuhur krhomoahat nhai marimoar, “Jonrhu mrokfefm nhai tfit wanyrhotanm.” Nhai. Jonr pthayuk tamoh tamoh mrokfefm wany yakitohmourm. ");
INSERT INTO amp_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Bok yihotam Herodias nhombrati hnamotn ee wanymot Herotrhu betdekfothu bro yemro burwathu hta yuhat. Rot nd mrokfot wanyhato kfo memot, “Hifa, ka na nd yiharn fura mrom yakruha.” Betde yiharn bro yemro burwat htamortn bok yimam nakumorm. Nd turpno gafman hingrneft hingrnanhoyukm, yo nd turhu amikofthu bro yimam, yo Galilikorhof bro yimam naku bugamorm. ");
INSERT INTO amp_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nia rifinymotm Herodiashu yon mett fnahnihato nd bro yufet yimam rhumo tkittn yi grhamot. Nd rhuyuk bro yimam htihato masat yindhormom. King Herotr htihato kfo memort, “Nom hifa hti yindhorwonomn. Kangn tamoh ayaka, wakfokahtn yakhiruhann. ");
INSERT INTO amp_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Na kfo mif mifwann, tamohm ttiwonrahna be he mifruhann. Kangn, na tohukatohwa yima rifhur niyak nhtahato kangn, wom rifuhetr atohukatoha, na nhai mrokfom. Na to finji kforuhoya?” ");
INSERT INTO amp_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Be nd met tmaht yitatn mmemt rim ttiwonwott. Kangtt, “Na Herotr inji inji ttiwonra. Ndnatn kanga attiwonanne ni finji dukewa? Tamohmn akfoya?” Mmemt kfo kangtt, “Jon Baftaisrhu mfhathu yakneft wakfotwa.” ");
INSERT INTO amp_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Be inji wanyhato yimotn kingrpno rim kfo memot, “Na kanga asomif mif Jon Baftaisrhu mfhat watmbhakkahnr wom plettn wakmbrehiyafona.” ");
INSERT INTO amp_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Be wom kingr wanyhato be tuha mrokfo duhatr rhumor. Bi bro mrokfot kfo memort, “Tamoh tamohm ttiwonwona na nhai kfo wokrhotann hanyeft. Be he mif mifruhann.” Bi inji kfetrn to be rot Jonrhu mfhathu tmbhakhato hiyafneft kfomohat nhai tfit wom kfo wokrmort. Ror nd yontpno napthamohat nd rhuyuk bro yimam bi wanymomr ror nd pthamohat. To be ndnatn nhai tfit ror wom kfo wokkfot. ");
INSERT INTO amp_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Be yudbat kingr wom soldiar kfo tkrurafmotrr yimor Jonrhu mfhathu tmbhakt. kalabusm tohmoa kunys yimorn Jonrhu mfhat yihom tmbhakmorr. ");
INSERT INTO amp_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Mfhat tmbhohato plettn kmbriyaknehato nd met tmahtn mhemor. Nd met tmaht nd yima mfhat yaknihato mmemtn rim hemot. ");
INSERT INTO amp_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jonrhu uhik ahik htfasmoa yimam rorhu mfhathu pukni mrokfeft wanyhato kalabus kunysn yimomn rorhu tfmbt rimakmomtn hany fopmomt. ");
INSERT INTO amp_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Nd rorhu sioskfothu kasinya htfasyuk aposerm tfit Jisasrpno niahato mkfo nuhas bonuhasmomr rom namo nefm yo rom ptha htfasmo mrokfefm. ");
INSERT INTO amp_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Bok yimam yi rifiny hatohmoatmm nhai nuwa ya inji narmom. Be ndnatn Jisasr kfo memorm, “Na kamuka wom turpat tkittn aikahnomn rhu wita inji narahko.” ");
INSERT INTO amp_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Be mmbrt yaknimomn turpatm wom turpat tkittn yimom. ");
INSERT INTO amp_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Bok yimam tohhato hti hikaf hanymomm rom hir hanymohat. Hti hikaf hany memom, “Tom bi ndko kitwom mhtirahnomm.” Be tonayef-rpar yakhato be nd ror yiyuk tkittn mtoh hasomom. ");
INSERT INTO amp_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Jisasrom mtadbkafmomn nd yonmari yima rifhur mhtihato yuhuwafmorm. Mhti yuhuwafhato duka memor, “Ar yimam sifsifm yima tohukatoh duha kanjo be inji hutraf tto habrisewum.” Be nd yima rifhur yak nhafohtamorm mrokfom hemorm. ");
INSERT INTO amp_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Jisasrhu disaiperm marr htiyaf hanyhato Jisasr mkfo memomr, “Marr bi yohnitr, ndart yima toh duha wom tkit furayet. ");
INSERT INTO amp_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ndar rifinywa yimam wakfo tkrurafkahtnm anatubatunikahmn tumn yeshrim awikna htfaskahmn aye bmtam.” ");
INSERT INTO amp_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jisasr tfit kfo memorm, “To nikomn yeshri wahekomm.” Tfit rom kfo memomr, “Kangne 200 kinakfot yaknihato bretpam awikna hanyomm?” ");
INSERT INTO amp_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jisasr tfit ttiwon memorm, “Niko finji bret nuwam harhuwako? Afo wahti nhtakomm.” Rom yihato hti nhtamommn kfo memomr, “Nom tirfa bret nuwami hus yiraf, injirpa harhuwonom.” ");
INSERT INTO amp_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Kfo memorm, “Nd yima bugam briaha hifa kipr suhtn hofhet hofhet arhu nhombratwam.” ");
INSERT INTO amp_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Be rom hofhet hofhet rhu hanymom, wom hofhetr 100 yimam yo tfit wom hofhetr 50 yimam. Be inji inji rhu hanymom. ");
INSERT INTO amp_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Be nd tirfa bret nuwami hus yiraf yaknimormn yura mount wuyukatohhato kfo bruttnamor. Kfo bruttnanihato turhu disaiperm yak tifakhany hiyaf hanyhato kfo memorm, “Wahe nhombra htfas hanykomm.” Yo nd hus yiraf be nd rpahtet neft namorf. ");
INSERT INTO amp_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nd he hanymo yeshrt nd yonmari yima rifhur yihany yi hanymomn, yatim furkihmomm. ");
INSERT INTO amp_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Yatim furkihmotmm, be nd yesmbhehm yak nhafohhato tfit 12-pela kpmn hmbre nhafohmomm. ");
INSERT INTO amp_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Nd bret nuwa yamo yimam, 5,000 yimam famomm. Nd thomnafat yindarirparohet. ");
INSERT INTO amp_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Be Jisasr yudbat turhu disaiperm kfo tkrur memorm, “Niko bi mmbrt wayaknikahkomn Betsaidako wahir hayukni hanyko. Na afo met yindarim yak kafho tanyruha.” ");
INSERT INTO amp_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Be inji kfafhato turpar kminysoft muhmor kfo bruttnaneft. ");
INSERT INTO amp_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kriftamott nd mmbrt hir hanyukm tek bari dany yuhatn hirmom. Jisasr turpetr yura kminysofko tohmor. ");
INSERT INTO amp_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Hir hanyetm htimorm wifortn frmmomoattm yanygoneft fanygo titamoum. Nhombrati nhombrati tu wuroh ksfutn Jisasr yura tek bupamn mitohhato fau hanymor. Duka memor “Yau hagrotniruhanm.” ");
INSERT INTO amp_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nd mmbrt rhuyuk yimam Jisasr yura tek bupamn yau hnamotr htiyakhato duka memom, “Ndarr ka tek yarhr niewur.” Be yakrmiyakhato tuha fengr fengrt tohmot. ");
INSERT INTO amp_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Nd yimam tuha nhai wom yafothetm rhurmom. Jisasr htihato kfo memorm, “Watoh bmtako. Naya. Ayakrmiwahko.” ");
INSERT INTO amp_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Be inji kfonihato rroh mmbrt mikmbrehato buwiform teh tmbhakmom. Nd mmbrt rhuyukm ndt htihato be tuha mifoh rihanimom. Nhai womr ptharmor. ");
INSERT INTO amp_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ndt to nhai be sfno. Nd yimam Jisasr bret nuwam yak yurhmo yuhat rom nhai hti marimom, “Jisasr tu Bro Nkifrarhu bbukeft yorhwattr kak yuhrworm yeshrim.” Nhai ndhtet dukefr rhurmorm. Ndnettn nd yimam Jisasr yura tek bupamn yau hnetr htiyakmohat yafotha duhatm rhumom. ");
INSERT INTO amp_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Tek barit hir hayuknimomn Genesaret mkuko rim dbkafhato mmbrt ttafmomt. ");
INSERT INTO amp_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Mmbrt ttaftany rim suhnimohat nd Genesarethu yimam Jisasr nhai hti mmormomr. Htihato memom, to tawom Jisaser. ");
INSERT INTO amp_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Be nd yimam inji hti nhta tanymomr nd brbo rhuyuk kmim ptha nuhas hanymomm Jisasrhu nia nmbuhat. Be nd brborhof kmim wanyhato nd dbohnet dbohnet yimam kroket kroketm hany hanymomm. ");
INSERT INTO amp_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Nd Jisasr yimoa kmim o fitoh fitoh tkitm, dbohnet yimam be hnamoamm bro rifiny swirm htatahato Jisas kfo ttiwonmoumr rorhu hmbresha psifrpatn dbohnet yimam tayoutihato marnyanineft. To nd dbohnet yimam inji namoahat yudbat marnyanimoum. ");
INSERT INTO amp_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Wom Farisimi wom boririfhuthu tisam Jerusalemt bi htanyhato yi rifinymom Jisasrpno. ");
INSERT INTO amp_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Yihato htimom Jisasrhu disaiperm nuwa yamohat nhai tir kifsanihato nuwa yarmom. ");
INSERT INTO amp_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farisimi Juda bugam nkifra mrokfot yakitohetmn, nhai tir kifsarfom, to be nhai nuwa yakfot. ");
INSERT INTO amp_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","O maket yihato nhai mhta yukrfom, to be nhai nuwa yakfot. Boknabok nefm hikmoum. Yeshri hta mskamoahat roh, plet, tamoh tamohm afo kifsanihato ee hta mskamoum. ");
INSERT INTO amp_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ndnettn nd Farisimi boririfhuthu tisam Jisasr kfo memomr, “Tamohmpno ninhu disaiperm nhai hik duha yitamt nkifra yirmoht? Tfit nkifra yirmoht riyak htefiwamt be ke fura bofurewum. Nhai tirm kifsafhato nuwa yekahm.” ");
INSERT INTO amp_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jisasr wanyhato kfo memorm, “Niko mikfo nhehta mkfo nhehtayet yimayeko! Bingot profet Aisaiar nikomn kfomor. Mrokfom wandfa memor, ‘Nd yimam be yura tngrpaye kfo yuta yindhorwoma. Yiro yima yuhum nhai nanhu dukefmpno rhukahm. Nndo wom dukefmpno korhm. ");
INSERT INTO amp_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Be nd yima mifm bingot htamo boririfhut kfo nuhas htfaswamn kfo kangm, “Bro Nkifrarhu boririfuhet.” Ndnettn rom lotuta lotuyeft yafotha duhatet.’” ");
INSERT INTO amp_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Jisasr nd profet Aisaiar kfongotmo mrokfot kfo nuhasnihato kfo memorm, “Niko ka bi tu Bro Nkifra mifrhu yirmoht bi mong trohwakomtn, bi nd yima mifroh boririfhu mrokfo furamn hikwoko. ");
INSERT INTO amp_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Tukmoh nkifram kfo htanihemo mrokfom yak hikwakomn Bro Nkifrarhu boririfhut nhai yak hik marnyakahkomt. Faso tfit kfo kekutwokomt. ");
INSERT INTO amp_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Mosesrn yirmoh mrokfot kfo memor, ‘Ni yifammafhu yinhitn rhuhato rofhu mrokfomn hikkfot,’ yo ‘Yimar turhu yifammaf kfo twewurf, nd yimar was hehur thukfot.’ ");
INSERT INTO amp_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Tfit nikomn kfo yirmoh kangko, ‘Wom yimar turhu yifammafpno wuskam kfo nuhastahihato tfit yifammaf kfo famurf, “Nifn kfo nuhasheyuk wuskam bi Bro Nkifrar htahemoya,” ");
INSERT INTO amp_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","to be nd yimar mirahr tfit yifammaf adukakahann ayak marnyayanf.’ Niko inji kfo yirmohwoko. ");
INSERT INTO amp_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ndnettn tukmoh nkifram kfo htanihemo yirmoh mrokfom yak hikwakomn Bro Nkifrarhu boririfhut nhai yak hik marnyakahkomt. Faso tfit kfo kekutwokomt. Tfit wom rpahtet fasoh fasoh nefmn kak hikwoko.” ");
INSERT INTO amp_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Tfit Jisasr nd met yindarim nakuyakhato kfo memorm, “Nanhu mrokfefm wawany hik marnyatwa-komm. ");
INSERT INTO amp_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Tamoh tamoh mur yemrom o hnaru yemrom tng yuhat yiyafoyukm, nhai ndmn Bro Nkifrar htihato kfo mikahr, ‘Ni bi fasoh yimaye.’ Nhai. Nd yiro yima yuhurio sinyahato newa fasoh nefm, ndmn Bro Nkifrar htihato kfo kangr, ‘Ni bi fasoh yimaye.’” ");
INSERT INTO amp_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Be Jisas inji ptha tanyhato kunyko rim fnahnimor. Rim fnahnimotr tfit turhu disaiperm kfo memomr, “Tfit afo nd ni kfi mrokfothu yimbu yuhat wakfo hikkahtnt awanynom.” ");
INSERT INTO amp_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jisasr memorm, “Nikome ka nhai yima yuhu duhateko? Yima yuhetko arhuko, to yakrfokomm na pthayuk mrokfefm. Wawanyko! Nd tng yuhat yiyafoyuk yeshrt o wom tamohm, nhai ndmn Bro Nkifrar htihato kfo mikahr, ‘Ni bi fasoh yimaye.’ Nhai. ");
INSERT INTO amp_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Nd yiyafoyuk yeshrt nhai yima yuhurn yikahm. Nhai. Nd yiyefiwa yeshrim nyunguram yuhat yitamn ript yihom yorhwom. Ript yihom rhuhato kto tfit rikunys kitm.” Jisasr duka memor, “Tamoh tamoh yeshrim ye fura bofurayukem.” Ndnatn inji kfomorm. ");
INSERT INTO amp_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Tfit kfo memorm, “Nd yiro yima yuhurio sinyahato newa nefmn, ndmn Bro Nkifrar htihato kfo kangr, ‘Fasoh yimayer.’ ");
INSERT INTO amp_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Nd na kfiwa yima yuhur sinyewa fasoh nefm, ndm inji korhm: nd fasoh fasoh dukefr, yaum kanjo met yindarim niwa nefm, rikohneft, yimar nambur sinyahato womr was furaneft, womrhu mettpno rim fnahneft, ");
INSERT INTO amp_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","yimarhu yima yuhur kangr tamoh tamoh wuskam, maruham nanrpayanuhem, nhai womm henyeft, nd nd fasoh nefm yima yuhur sinyewamn ni womn yak bebneft womr, kfo nhebehneft, tuhagrhahato yimtna duha na fura bofuriwa nefm, womrhu dborioh wuskam o mett o tamoht htihato tfit ni womn duka bebneft womr, ‘O tamohmpno ror yekrt nd banuhah mett o shrt. Nann yakrfoyant.’ Ndhtet dukefm o womm faso faso harhu htfasneft, o yufa yurak htaneft, o duka marnya duha naknita nefm. ");
INSERT INTO amp_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Tom nd nd nefmn yiro yima yuhurnio sinyewamn Bro Nkifrar htihato kfo kangr, ‘Fasoh yimayer.’” ");
INSERT INTO amp_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Be Jisasr nd kmit htanyhato tfit Tairko yimor. Yimorn wom kunys fknenihato ndha rhu kfafrohmor. Duka memor, “Rhu kafrohrhota nd kmithu yimam nhai htirhotma.” To nhai, bi yimam yak switafetrn to be nhai tfit wom kafrohkfot. ");
INSERT INTO amp_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Wom mett, rothu yont kmi yarhr fknemort. Jisasrhu nia nmbuhat wanyhato be ror rhumo kunysn yimotn Jisasrhu wurampno msuhmot. ");
INSERT INTO amp_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nd mett, rot rmon mrokfo wany juha kantri Siria efkott. Rothu profins Fonisia. Rot yimotn Jisasr mnaku ttiwonmotr rothu yon mett fknemo kmi yarhrhu yak thuneft. ");
INSERT INTO amp_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Jisasr wom kfo nhombra mrofkot kfo memort, “Yonroh hayuk yeshrt nhai bi yakhato yaumn afo wahta hekahmn. Nhai. Afo tu yima yonmn barkofpam kahuknom.” ");
INSERT INTO amp_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Tfitn nd mettn kfo memotr, “Bro yimaye, ndt rot hifat kfiwun. To nhai, nd yauyenm, tebor yinhit toh hanyukm, rom to nd yonm ye bruraf hanitam ke tuthatak hanitm.” ");
INSERT INTO amp_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jisasr rot pthamo mrokfot wanyhato kfo memort, “Ni inji kfitn, wanju kunyko. Nd kmi yarhr bi thu troh tanyrt ninhu yont.” ");
INSERT INTO amp_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Be rot kunyko yihato mhtimott yont bi kmi yarhr thu troh tanyhato tiktn hwe hasettn. ");
INSERT INTO amp_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jisasr tfit Tairt htanyhato yimor Saidonko. Saidonko tohni tfit yimorwe distrik Dekapolisko. Dekapoliskorn hingrna hanyhato Galili barit mfnahmor. ");
INSERT INTO amp_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Galilit bi mfnahetrn wom yimar hnamomr. Nd yimarhu yimbhindangm kihmnimomr yo pthanefm nhai ptha marnyarmoar. Nd yimar hnehato Jisasr ttiwonmomr nd yimarhu tir htaneft. ");
INSERT INTO amp_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Be Jisasr nd yimar yaknimorr, nd yima rifhur htanyhato turpatf wom tkitt yimof. Turpathato Jisasr tirpinyafe nd yimarhu yimbhindangf htamorf. Tfit kuninfar yakhato tortn htamort. ");
INSERT INTO amp_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ee, Jisasr yura mounko wuyukatohhato yawitakiyafmorn ptha memor, “Efata,” (nmoh mrokfotn, “Atuppomn.”) ");
INSERT INTO amp_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Inji kfomotr nd yimarhu yimbhindangm tuppomomr. Tuppohato mrokfom riptha marnyakmorm. ");
INSERT INTO amp_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jisasr nd yimar yak marnyanihato kfo rafo mrokfot kfo memorm, “Nd nda yimar yak marnya yuhat, mirahko wom yimam akfo nuhas mif mifnomm. Be inji turpatkmoh yima yuhumn arhutwat.” To nhai, nd kfo rafo mrokfot nhai yak hikrmomt. Tfit romn mrokfot yaknihato kuny kuny kfo habrimoumt. ");
INSERT INTO amp_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Be nd kmi kmirhof yimam Jisasr namo neft wanyhato duka memom, “Barenko! Ndu yima Jisasre be tu nhai hingrna happukkahr. Ror newa nefm be tu yafothetm korhm. Ror kfiwur, yimbhindang kihmniyet yimam mrokfom wanukm. Yo ror kfiwur, tng mmkm pthewum.” ");
INSERT INTO amp_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Wom yiha nhaf yonmari yima rifhur rifinymomr. Nhaf nd rifinymo yima rifhur be inji yeshri duhatm tohmom. Be Jisasr htitihato turhu disaiperm nakuyakhato kfo memorm, ");
INSERT INTO amp_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nda yima rifhur yuhuwafwanm. Bi husfirpa marm nanpno tohromn bi yeshriyen duhatem. ");
INSERT INTO amp_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Yatinoht tohetmn kfo miruhanm, tukmoh kunyko wanjuko, inji kfafhato yirahm, to be buha yihotatn yatinoh mmrifakruhamn suhrahm. Womm nhai be brboha toh tanyhato niarmom. Wuri wuri tkitrohm womm nia hnamom.” ");
INSERT INTO amp_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Tfit turhu disaiperm kfo memomr, “Ndashart nom yima toh duha tkitt tohwonom. To href fitha bok bretpam yekwanomn ndar yonmari yima rifhur yahukanomm?” ");
INSERT INTO amp_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jisasr tfit ttiwon memorm, “Nikome finji finji bretpam harhuwako?” Kfo memomr, “7-pela kfoyet.” ");
INSERT INTO amp_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Be nd yima rifhur Jisasr kfomotrm tuha bbinysoftn sibosi rmonmom. Jisasr nd 7-pela bretpam yakmormn Bro Nkifrarko kfo bruttnanihato bretpam fak tif botifmorm. Tfit turhu disaiperm hemotr romn yaknihato nd met yindars hi hanymomm. ");
INSERT INTO amp_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","You tfit wom yirayenm yakhato nhaf Bro Nkifrarko kfo bruttnanihato turhu disaipermn yak mkuyakhany, yak mkuyakhany, hiyaf hanymoatrm, tfit romn he nhombra hanymoumm met yindarim. ");
INSERT INTO amp_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nd yima rifhur fe furkih bugamom. Nd rom yesmbhoyuk yeshrim Jisasrhu disaiperm tfit yak nhafohhato hmbremohat 7-pela kpm hmbremom. ");
INSERT INTO amp_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Nd yeshrim yamo yimaroh thomnafat, 4,000. Ndt yindarirparoh thomnafayet. ");
INSERT INTO amp_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Be Jisasr nd yima rifhur kfo tkruraf tanyhato turhu disaipermpno mmbrtn mikmbrenihato Dalmanutako yimom. ");
INSERT INTO amp_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farisim yihato Jisasrpno yuwi mkfo memomr, “Jisase, mirakerkfot wahingrnakahtnt afo ahtinom. Nom htiruhanomn mirahnom, tu Bro Nkifrarhu bbukeftpno hingrnewur.” ");
INSERT INTO amp_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Inji kfomotmr Jisasrhu yima yuhur krhohato tuha yawita kiyafhato kfo memor, “Tamohmpno ariharhof yimam yamukoma bro mirakerfot wayak nuhaskahtnnom ahtinom? Na tu be kfo mifwanko. Na nhai tfit ariharhof yimam tfit wom neft yak nuhasrhotanm. Be tu nhai mif.” ");
INSERT INTO amp_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Be Jisasr tfit mmbrtn mikmbrenihato tfit mkuko hir hayuknimor. ");
INSERT INTO amp_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Jisasrhu disaiperm yimohat nhai dukarmom bretparoh yaknineft. Rpa bretparpat faknimom. ");
INSERT INTO amp_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yimomn Jisasr kfo memorm, “Niko Farisimi Herotroh yispam hti marnyaf hanykfot.” ");
INSERT INTO amp_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Tfit tum rinakfo nakfo memom, “Ka nom bretpam yakna duha yitnom, ndnetrn nd mrokfot kfiwurnom.” ");
INSERT INTO amp_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jisasr bi wanyhato kfo memorm, “Tamohmpno tuko tfit rinakfo nakfo yamukako, ‘Nom bretpa duhatenom?’ Niko ka nhai yima yuhu duhateko? Nhai yima dukefm rhukahmko? Yima yuhum ka bi kspitapamn toh tittewumko? ");
INSERT INTO amp_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nyingetko arhuko to htirfoko? Yimbhindangetko arhuko to wanyrfoko? Ka nhai. Ka bi nhai wom duka hanykahko ");
INSERT INTO amp_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","na tirfa bretpam 5,000 yimam yak dbifhato hany nhombra-mohat? Finji finji kpm nd yesmbhehm yak hutuhahato hmbremoko?” Kfo memomr, “12-pela kpm.” ");
INSERT INTO amp_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Tfit kfo memorm, “Yo tfit na nd wom yiha 4,000 yimam 7-pela bretpam yak dbifhemohat, finji finji kpm hmbremoko nd 7-pela bretpam ye furkihhato yesmbhomom?” Kfo memomr, “7-pelakfot.” ");
INSERT INTO amp_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Tfit kfo memorm, “Na nd nefm namohat, ka nhai htihato duka hanykahko?” ");
INSERT INTO amp_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nd Jisasrom hir hanymomn Betsaidat rim fnahmom. Nd kmi thofm Jisasr htiyakhato wom nyinga kunyjet yimar hnamomr. Hnehato Jisasr mttiwonmomr nd nyinga kunyjet yimarhu tir htaneft. ");
INSERT INTO amp_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Be Jisasr wanyhato nd yimarhu tirt yakitohaknihato nd kmit fnahnimoftn briahako fnahnimof. Briyahako rim htahato Jisasr nd yimarhu nyingam kuninfarmorr. Kuninfarnihato tirm htahato ttiwon memorr, “Bi kukatoh wuthewun?” ");
INSERT INTO amp_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nd yimar nyingam myukatohhato yimam tamohm htimorm wufau faumom. Kfo memor, “Htitanm yimam mim kanjo kau hanitm.” ");
INSERT INTO amp_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Tfit Jisasr wompam tir htamotrr ee ndnatpno nyinga rurham mfrfnahnamotmr hti wutha bugamorm yimam, mim, tamoh tamohm. ");
INSERT INTO amp_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nyingam yak marnyanimorr kfo memorr, “Ni mirahn tfit yiro kmiko arim fnahniya. Ninhu kunyko wanju.” ");
INSERT INTO amp_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jisasri turhu disaipermpno Galilikort htanymomtn yimom tfit Sisaria Filipaikorhof kmimn. Yihotatn turhu disaiperm ttiwon memorm, “Nane, met yindarim finji dukewuma?” ");
INSERT INTO amp_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Kfo memomr, “Womm kangm Jon Baftaise. Womm kangm Iraijaye. Womm kangm wom nkifra thof profete.” ");
INSERT INTO amp_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Inji kfomotm, tfit ttiwon memorm, “To niko tuko finji yute-wukma?” Pitar kfo memor, “Ni kangnomn nmoh hbhayeme, Bro Nkifrar kfo tkrurafmorn nmoh minrfa htiyakyuke.” ");
INSERT INTO amp_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Be Jisasr inji wanyhato kfo memorm, “Yo mirahko mif mif womm akfo nuhasnomm. Mirahko akfo amanyomm, ror ndhtet yimayer.” ");
INSERT INTO amp_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nd yiha Jisasr disaiperm rikfo nuhasak memorm, “Na, Bro Najema boknabok krhopam yakruha. Na Judaroh bro yimamn, prisroh bro yimamn, boririfhuthu tisamn, nd nd yimaroh tirmn hirruha. Nohruhoyann tfit husfirpehyuk marrn tfit sinyaruha. Na nhai tfit finji kfo finji kforhota. Na be yi nohnefrpat.” ");
INSERT INTO amp_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Inji kfo ptha srh nuhasnimormn tfit Pitarn Jisasr yaknihato nndo rim hatohhato kfo rafo mrokfot kfo memorr, “Ndhtet mrokfot kfo ptha duha.” ");
INSERT INTO amp_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Tfit Jisasr kekutnihato turhu disaipermpno yukatoh hanyhato Pitar kfo memorr, “Satane, wuri wain. Ni nhai Bro Nkifrarhu yima yuhur hikkahn. Nhai. Be nndo yima mifroh dukefm hikwo.” ");
INSERT INTO amp_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Be met yindarimi turhu disaiperm rpat nakuyakmorm. Nakuyakhato niamotm kfo memorm, “Wom yimar kangr, na ahik hneya, mirahr tur amdukak hanya. Nd dukefr mong trohhato rorhu bgre mis titahato na hikkfot. ");
INSERT INTO amp_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Yimar turhu toh marnya nmbuharpat mdukak hanitr, nd toh nmbuhat ror mdukak hanitat nhai tfit wom htiruhatrt. Yimar nani nanhu gutniuskfot dukahato nhai turhu toh marnya nmbuharpat dukarfort, kto tfit htirahrt rorhu toh marnya nmbuhat. ");
INSERT INTO amp_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Wom yimar ndar bbinysofthu tamoh tamohrpar yakhato kto toh nkifrayuk toh nmbuhat nhai dukarfort, to nd ariha yekwa marut, wuskat, tamoh tamoht kto to finji hifa toh nkifra nmbuhat hiruhamr? ");
INSERT INTO amp_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Hifa toh nkifra nmbuhat kangr tfit ayakant, to tfit fitoh yuhatn yakruhart? ");
INSERT INTO amp_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ariharhof yimam Bro Nkifrar mong trohhato fasoh fasoh nefm newum. Frohr yak rihtefiwura yo nanhu mrokfeft yak rihtefiwurt, be nd yimar tawo na Bro Najema yak rihtafruhanr. Nani tu dborioh mounmotmpno nia thombat Bro Yifemrhu nukeftpno yawihnehato yak rihtafruhanr.” ");
INSERT INTO amp_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","“Na kfo mif mifwanko, ndasha tohwa womm tafi afo noh duhatmn Bro Nkifrarhu bro nanyjaret kingdomkfot htirahmt.” ");
INSERT INTO amp_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Kto 6-pela yiham yinyimotm Jisasr Pita Jems Jonrom yaknihato turpatm muhmom tu mfro wayakmo kminysoftn. Turpatm rhu hasohato asha htiyaf hanymomr fnhuyaknimor. Memom nndo yindeng nyisofr fnhutwor. ");
INSERT INTO amp_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Yimar hmbremo hmbresham rpat fnhu bugaknihato memom nndo bruwohmr katiwur. Nhai ndar bbinysofthu wom yimar inji rhu wonakrmor. ");
INSERT INTO amp_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ee tfit htimomf Iraija Mosesrof Jisasrpno mtohhato pthamohat. ");
INSERT INTO amp_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pitar inji htihato Jisasr kfo memorr, “Tisaye, nmoh asha tohneft hifa. Ka husfirpa kunyenm yimanom nhombrahato singorahnom. Ninhu womt, Mosesrhu womt, yo Iraijarhu womt.” ");
INSERT INTO amp_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pitar nd mrokfot kfo pthamohat be yakrmehato be tu furamort nd mrokfot. ");
INSERT INTO amp_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Be tfit wom gribfat niamotn yawihnehato kasi hmbremotm. Yiro nd gribfatn wom tngt niamot. Nd tngt kfo memot, “Ndarr nanhu Yoner. Be tu marbitn htewanr. Ror pthayuk mrokfom wany yakiokfot.” ");
INSERT INTO amp_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Yudbat yukatoh habri memom ahtinom nd mrokfo pthayuk yimar, to nhai, nhai wom yimar htirmom. Tu nd Jisasrpar htimom. ");
INSERT INTO amp_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Be nd kminysofr wuhtanyhato tfit mibrnyimom. Buha yihotatn kfo memorm, “Niko nd yura kminysoft htitawoneft bi mirahko womm akfo nuhasnom. Kto na Bro Najoma bi nohnihato bi tfit sinyeya, ee btn wakfo nuhastwakomm.” ");
INSERT INTO amp_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Be rom nd Jisasr kfo pthamo mrokfot wanymohat, tfit tum nakfo ptha memoum, “Nd ror kfi yamuhat nohnihato tfit sinyanefte tamoht kfir?” ");
INSERT INTO amp_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Tfit kfo ttiwon memomr, “Tamohmpno nkifra boririfhuthu tisam kfo yamukam, ‘Afo Iraijarn bi nia gungonrahr. Tfit kto Bro Nkifrar kfo tkrurafrahr nmoh minrfa htiyakyuk yima Kraisr.’” ");
INSERT INTO amp_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Jisasr wanyhato kfo memorm, “Ndt tu kfo mif kfoyet. To nkifra kfot kfo memot, afo Iraijar bi nieruharn rorn nd tamoh tamohm bi yak hta bohtarahrm. Tu mrokfot kfiwut. To tfit kfiwanko, Iraijar to bi niamor. Bi niamotr yimam turoh dukefm hikhato faso faso fak bebmomr. Wawanyko, Bro Nkifrarhu rfa borngt kfo yamukahat, ‘Bro Najomr bro krhopam yakruharn yimam kfo behohrahmr.’ Ndt tu kfot kfiwut.” ");
INSERT INTO amp_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Mibrnyimomn tfit wom disaiper-mpno minahtimohat mihtiyaknimomm wom yimampno rifiny hasomom. Bro Nkifrarhu boririfhuthu tisampno nakfo hamuh nakfo hamuh hasomom. ");
INSERT INTO amp_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Be nd rifiny hasomo yonmari yima rifhur Jisasr hti fohtasakhato tfit rorpno mkfo yindhoraknihato mrifin-yaknitm. ");
INSERT INTO amp_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Rorhu disaiperm Jisasr ttiwon memorm, “Nikome tamoh mrokfefmn nnakfo hamuh hasiko?” ");
INSERT INTO amp_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Tfit nd yima rifhurhu wom yimar sinyahato kfo memorr, “Broye, nanhu yonr kmi yarhr mrokfo ptha yafothar yakmotrr ndnettn ninpno hniyanr. ");
INSERT INTO amp_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nd kmi yarhr tattuh thombat, yima yonr suhwor. Suhhato tir wuram noh minysafaknihato bisom youkukakni brukt yima yonr hatoh thombat kangm nndo foher. Ninhu disaipermpno kfo famuya, ‘Wayak thukomr yarhr.’ To nhai, fak thu titawomr.” ");
INSERT INTO amp_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jisasr nd mrokfot wanyhato kfo memorm, “Arom Bro Nkifrarhu dukefm rhu duha met yindariyenko, finji tfit nikompno tohrhoya? Finji tfit nikmoh krhopam titahirhoyanko? Wahnakomr nd yonr.” ");
INSERT INTO amp_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Be nd yonr yaknimomr Jisasrpno hanymomr. Nd yonr tohmo kmi yarhr Jisasr htihato ka nd yonr bbinysoftn wathu tmbhomotrr be tuha bruktpno bruktpno tohaknihato tir wuram tubatu yaknimomr. Tuha memom nndo yejefenrn nmbukaswor. ");
INSERT INTO amp_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jisasr nd yonrhu yifemr ttiwon memorr, “Nda yonre fitoh yiha fakmotr nd mumeft?” Yifemr kfo memor, “O yuhre habhiyenrn nd mumeft rifakakmotr. ");
INSERT INTO amp_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Rhu hasiwarn nd yarhr thu mumaknitatrr kahmn kitr. Womnam tekm mitayifwor. Nd yarhr kangr, inji anakahtanr anohr. Ndnettn kanga attiwonann, ka yuhuwafhato yak thurfonr nd ror hatohwa yarhr?” ");
INSERT INTO amp_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jisasr kfo memorr, “Rot ndt nhai mrokfom. Tu yimann hus yima yuhufn rhurahn be nhai yak marnyahirhotanr. Rpa yima yuhurpar rhuhato duka mirahn, ‘Href mif mif Jisasr kak marnyahukra.’ Inji dukarahn marnyahirahrn.” ");
INSERT INTO amp_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nd yonrhu yifemr warhuhato kfo nur memor, “Uwa, uwa na nd yima yuhur kfo kangr, ‘Href mif mif kak marnyahukra.’ To tfit wom yima yuhur nhai be inji masat dukakahanr. Ndhtet dukeff yorhwotfa ndnatn kanga ndhtet midukata mdukataneft wayak thunt. Be nd yonrhu marnya dukefrpar wayakhtana.” ");
INSERT INTO amp_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jisasr met yindari rifhur brbo toniyaknimotm Jisasr nd yimbhindang tng kihmniyet kmi yarhr kfo nambur hik memorr, “Asomif wathu troh tanynr. Wathu troh tanykahnr mirahn tfit amfkneyanr.” ");
INSERT INTO amp_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Be inji kfo nambur hikafmotrr, be nd kmi yarhr tau fnahhato thu troh tanymorr. Thu troh tanymotrr nd yonenr suhhato yebittaknimomr. Memom ka dangnhatn tmbho thum. Yimam htihato memom ka bi fnohr. ");
INSERT INTO amp_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Tfit tu Jisasrn nd yonrhu tirt wayakhato wateh kasinyakmorr. ");
INSERT INTO amp_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Kto Jisasr kunyko yihato turpatm turhu disaipermpno rhuhato kfo ttiwon memomr, “Tamohmpno nd yarhr to nom yak thu duha yirfonomr?” ");
INSERT INTO amp_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jisasr kfo memorm, “Nhai wom tamoh nefm nahato kmi yarhm yak thukfot. Bro Nkifrarhu kfo bruttna-nefrpat. Bro Nkifrarpno kfo bruttnarahko kmi yarhm yak thurahko.” ");
INSERT INTO amp_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Be nd kmit htanyhato buha Galili yuhat yimom. Jisasr nhai marimor, wom yimar kfo nuhasruhanr rorhu yi yuhat. ");
INSERT INTO amp_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Turhu disaiperm kfo kars bokars, kfo nuhas bonuhas, kfo hta bohta inji nayetrn nhai marimor womm kfo nuhasruha yi yuhat. Turhu disaiperm kfo memorm, “Ndar bbinysofthu yimam Bro Najomr yak hndhnarahmr yimampno. Hndhna-ruhatmr yimam wasrahmr. Nohruharn husfirpehyuk marrn tfit sinyarahr.” ");
INSERT INTO amp_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Jisasr inji kfomotr, nhai rom nd mrokfothu yimbu yuhat yakrmomt. Rom tfit fanhomom nd mrokfothu tfit ttiwon hikneft. ");
INSERT INTO amp_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Jisasri turhu disaiperm yimomn Kaperneamt mfnahmom. Ndha mfnahhato wom kunys fknenihato Jisasr ttiwon memorm, “Niko yihotohat yau hnehate tamoh mrokfom rinnakfo nakfo hneko?” ");
INSERT INTO amp_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Nd yimam yihotoha yuhat niamohat tohakyuk yimarhu nmbuhat nna kfo hamuh nna kfo hamuh hnamom. Womr watohhato memour, “Nann broruhanko.” Tfit womrn, “We, we nann broruhanko.” Tfit womr watohhato memourr, “We, rorn.” Tfit womr watohhato kfo memour, “We, we ror nhai, ndarrn brorahrnom.” Inji inji nna kfo hnamomn Jisasr ttiwonmohat to be nhai womr ptharmor. ");
INSERT INTO amp_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jisasr warhumorn nd turhu 12-pela disaiperm kfakmorm. Kfakhato kfo memorm, “Wom yimar kangr, ‘Nyingako atohane,’ nd yimar wom yimaroh mongko tohtahato be rroh hingrnanho yimapar tohkfot.” ");
INSERT INTO amp_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Wom habhi yonenr yakmorrn rroh buha htatahato tire yakitoh hanymorrn kfo memorm, ");
INSERT INTO amp_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Fitoh yimar na hikhato na hikwa wom met yindarim yakhato kak marnyewurm, nda yonenr yakhato yak marnyiwa kanjo, nd yimar nann yakhato kak marnyewur. Na Bro Nkifrar kfo tkrurafmotra, niamoya. Ndnatn frohr na kak miyekwor, nd yimar Bro Nkifrar kak miyekwor.” ");
INSERT INTO amp_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jonr kfo memorr, “Tisaye, wom yimar htimonomr ninhu yufat yuta nawohhato kmi yarhm yak thumoatrm kfo rafomonomr. Nd yimar nhai nom ni hik habriwa kanjo nd yimar inji hiknho habrikahrn. Ndnatn nd yimar ninhu yufat yuta nawohhato yarh fknayet yimam yak marnyamoahat, nom nhai yindhorrmonom.” ");
INSERT INTO amp_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jisasr wanyhato kfo memorm, “Mirahko akfo rafonomr. Yimar nanhu yufatpno wom mirakerkfot hingrnewur, nhai be yudbat fasoh mrokfom kforhotra. ");
INSERT INTO amp_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Yimar nompno nhai nahti dbnotkahr, nd yimar nmoh yimater. ");
INSERT INTO amp_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Wom yimar niko htiyakhato kfo kangr, ‘Ndurm Kraisr hikwa yimayem, bu pikt ahiyanm,’ na kfo mifwanko, nd yimar tawo Bro Nkifrar yak marnyarahrr.” ");
INSERT INTO amp_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Wom yimar ndar na hikwa yonenm frnhehektrm fasoh nefm fsuhm, nd frnhehakyuk yimar bro tahis yakhato mohtpitn tmbrekhato tek dany yuhat yafhohato miptkokfot. Tohruharn fasoh yihotat hanyrahrm. ");
INSERT INTO amp_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Tirtn fasoh fasoh nefm hanittn, nd tirt tmbho thukfot. Tmbho thuhato be rpa tirrpatpno rhu marnyaruhann toh nkifranirahn. Hus tir bugaf rpat rhurahf, rofn yakruhafn kaht turahfn. Nd kaht nhai wom yiha minoh hmbreni hanykaht. ");
INSERT INTO amp_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Yo wurat inji newut, nhaf puk thuhato rpa wurarpatpno rhuhato toh marnyarahn. Hus wura bugaf rhurahf, rofn kaht hanyrahfn. Nd kaht nhai wom yiha minoh hmbreni hanykaht. ");
INSERT INTO amp_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","O nyingarn fasoh nefm htihato fasoh nefm ner, be nd nyingar yak rurha thuhato be rpa nyingarparpno rhuhato toh nkifranirahn Bro Nkifrarhu kingdomkfotn. Hus nyinga bugaf rpat rhuneft wom nyingarn fasoh nefm hanyruhatrn rorn hel rhuyuk kaht hanyrahrn. ");
INSERT INTO amp_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ndhart nd yimam rurhahato tabotkurwa yejefm nhai nohkahm. Yo kaht nhai wom yiham minoh hmbreni hanykaht. ");
INSERT INTO amp_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Rho mengongm nhai sfno yak susnakfot. Kahtpno sunfahato ee yoh nfewatm kak susnewum. ");
INSERT INTO amp_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","To wom mrokfot tfit kfiwa. Youpam tamoh tamoh roh nrhayukem. Nd youpam nhai wom you gb ye juha, to tfit finji kanjo naruhatnm tfit you gb yeruham? Youpam yakhato tamoh tamohm nrhafhato htarahnm be nhai finji naruhatm. Be rhu marnyarahm. Youpam yemrom o tamohm yak marnyewa kanjo niko wommpno nayak marnyahato rpat tohkfot.” ");
INSERT INTO amp_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jisasr nd kmit htanyhato tek Jodent hayuknimortn tfit Judia profins yimor. Ndko yimohat nhaf yonmari yima rifhur rifiny hmbriyaknamomr. Rifiny hmbriyak-namotmr nhaf tur na hnamoa kanjo Bro Nkifrarhu mrokfom yakhato kfo ptha nuhas bonuhasmorm. ");
INSERT INTO amp_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ndko tohetrn ndkorhof Farisim yuwi yihato ttiwon rhti memomr, “Nmoh boririfhut finji kfiwat tuhan yak tuhafoneft? Ka hifane nhai?” ");
INSERT INTO amp_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jisasr wanyhato tfit kfo ttiwon memorm, “To Mosesrhu boririfhut finji kfomot tuhan yak tuhafoneft?” ");
INSERT INTO amp_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Tfit Farisim kfo memom, “Mosesrhu boririfhut, nom yak hikwat, kfo kangt, yimar tuhan yak tuhafoneft nhai mrokfom. Afo tuhan yak tuhafoyuk kfo yakio gontwat wandfanihato ee mett yak tuhafokfot.” ");
INSERT INTO amp_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jisasr kfo memorm, “Rot ndt hifa kfiwukomt. To nd niko wanukwa boririfhut nhai be sfno inji riruhakrmot. Tukmoh Bro Nkifrarhu mrokforoh wany juhaneftpno nd mrokfot inji htamort. ");
INSERT INTO amp_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","rfa borngt inji kfiwut, ‘Bingot Bro Nkifrar ndar bbinysoft hingrnahato yimam hingrnamohat mete yindariye hingrnamor.’ ");
INSERT INTO amp_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Yo wom mrokfot inji kfiwut, ‘Ndnettn yindarir turhu yifammam htanyhato turhu yak tuhantpno frtkafhato ");
INSERT INTO amp_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","mettn bi tot rorhu tirboh raft.’ Bi rpa raftn tou dbkaf hmbrihato tohkfot. ");
INSERT INTO amp_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ndnettn Bro Nkifrarn yak nmbtekyukm nhai tfit yima mifmn yak tndohkfot.” ");
INSERT INTO amp_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kunyko fknenihato tfit turhu disaipermpno nd Farisimpno napthamo mrokfot tfit wompam ttiwon hikmomr. ");
INSERT INTO amp_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Kfo memorm, “Wom yimar turhu yak tuhant yak tuhafohato wom mett fekr, nd nfri mett be ijoh yuhathu metet. Nhai turhu tuhan mif rhukaht. ");
INSERT INTO amp_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Mett nhaf inji buga. Mett tuthu yak ramr htanyhato wom nfri yimarpno rim suhnineft, nd yimar be ijoh yuhathu yimayer. Nhai tuthu ramem mifr rhukahr.” ");
INSERT INTO amp_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Wom yimam Jisasrpno yonenm hnehato memom, “Jisasr tir htahato kfo bruttnarahrm.” Disaiperm inji htihato tfit kfo huttaknimomm nd yon hnayuk yimam. ");
INSERT INTO amp_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jisasr inji htihato kfo hutt memorm, “Yonenm wahti marsisafokahtkomm nanpno aniam. Mirahko akfo rafonomm. Yimam yon mumenm kanjo yorhwam Bro Nkifrarhu kingdomkfot rhurahm. ");
INSERT INTO amp_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","To afo wawanyko. Yimam nhai yon mumenm kanjo be Bro Nkifrarparhu kingdomkfot rhukahm be nhai yiruhatm Bro Nkifrarhu kingdomkfot.” ");
INSERT INTO amp_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Be nd toni hnamo yonenm yak nhafohmormn Bro Nkifrar kfo bruttnahato fak wus bowusmorm. ");
INSERT INTO amp_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jisasr sinyani yi hanyetrn wom yimar toni yaknehato Jisasrpno bangu myuknahato ttiwon memor, “Hifa tisaye, nane finji naruhoyann Bro Nkifrarpno toh nkifraniruhoya?” ");
INSERT INTO amp_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Nd Judaroh bro yimar hifa tisa yufat Jisasr yutamotrr Jisasr wanyhato kfo memorr, “Tamohmpno kfo yamukona, hifa tisa? Nhai wom hifa yimar tohkahr. Bro Nkifrarpar dborioher. ");
INSERT INTO amp_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nkifra thfa mntwat ni bi wanyete. Kfo kangt, ‘Mirahn wanambur sinyahato yima awas furaya, mirahn ramet tuhantpno arim fnaha, mirahn arikoha, mirahn wom yimar wom mrokfom akfo wokanr, mirahn womm amkfo yuhur nheh bonhehkahanm maruham o tamohm amiyakhiyanm, yifammaroh mrokfo wany yakiohato rroh yinhitn rhukfot.’” ");
INSERT INTO amp_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Jisasr inji kfonimotr tfit nd yimar sinyahato kfo memor, “Tisaye, na yuhre yonenann nd thfa mntwam rihikakmoyanm. Nhai riyak htaforroyanm.” ");
INSERT INTO amp_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jisasr nd yimar hti yuhuwafhato kfo memorr, “Rot hifa nkifra thfa mntwat kakitohwont. Tmift wom nefrpat nhai nakahnt. Nd ni harhuwa wuss yak htatahato wommn wiknakfot. Nd wusspno yakyuk marut yakhato tfit nd wuskapa duha yimamn nd marut hekfot. Inji narahn, hefenrko mfro wuss harhurahn. Inji nanihato tfit na nia hikkfot.” ");
INSERT INTO amp_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jisasr inji kfomotrr nd yimarhu nyingatikt faso yimotr. Boknabok wusketrn nd mrokfot wanymohat yima yuhur nhai marnyahato yirmor. ");
INSERT INTO amp_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jisasr kekutnihato turhu disaiperm yukatohhato kfo memor, “Wahtiko, yimam boknambok wusketm be tu mduka nhiyekwom Bro Nkifrarhu kingdomkfothu fknenineft.” ");
INSERT INTO amp_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Turhu disaiperm wanyhato be tuha mrokfo duhatm rhumom. Tfit Jisasr kfo memorm, “Arenko, yimar kangr Bro Nkifrarhu kingdomkfot afkneniya, mirahr ka be yak dbhofnaniruha. Nhai. Muh wohne fnahrahr. ");
INSERT INTO amp_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Womhtet mong wakuyet fohr kutewumr kamerr. Nd kamerr fknanyirfort nahuyuk nirthu muht. To yimar wuss mfro haruhetr, Bro Nkifrarhu kingdomkfothu fknenineft mduka nhiyakrfor.” ");
INSERT INTO amp_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tfit tu Jisasrhu disaiperm inji wanymohat tfit mifoh rihanimom. Miyoh rihanihato kfo memom, “Barenko, nom kangnom ka ndhtet maru kunyet yimamn hifa rhu nmbuhat miyakrahm. To nhai. Ndhtet yimam mthu nhiyakrahm Bro Nkifrarhu kingdomkfothu fknenineft. To nome ndhtet yima furapanom, to nome finji Bro Nkifrarpno yihato mtoh nkifraniruhanom?” ");
INSERT INTO amp_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jisasr yukatohmormn kfo memorm, “Niko yimakomn tamoh tamoh nefroh finjina finjinaneft mduka nhiyekwoko. Tu Bro Nkifrar nhai duka nhiyakkfot wom tamoh nefroh finjina finjinaneft.” ");
INSERT INTO amp_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pitarn sinyahato kfo memorr, “Wahtinnom. Nom ninhu hikneftn nmoh tamoh tamohm mong trohhato ni mhikaknamonom.” ");
INSERT INTO amp_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Tfit Jisasrn sinyahato Pitar kfo memorr, “Na kfo mif mifwanko, yimam nani gutnius mrokfot dukahato rroh kunym, yon tuhanm, yifa mndarm tamoh tamohm htanymm, ");
INSERT INTO amp_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","tfit Bro Nkifrar wom 100 kfot thu hutahi hanyrahrm. Tfit htirahmm bok yifa mndaretm, kuny rmonetm, tamoh tamohetm rhurahm. Nhai yak mmbra finyruhatm. Yo rom nda bbinysoft toh thombat bok yimam yihato yak bebrahmm. Kto Bro Najomrhu yawihnayuk yiharn tfit Bro Nkifrarpno toh nkifranirahm. ");
INSERT INTO amp_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Arihart nyingako tohekwa yimam, kto tfit mongko yihom fnahnirahm. Nd mongko tohyukmn tfit nyingako mfnahnirahm.” ");
INSERT INTO amp_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jisasri turhu disaiperm memom, “Jerusalemko yirahnom.” Jisasr tohakmotr yo nd rorpno yauyuk yimam mongt tohmom. Turhu disaiperm inji htihato bok dukefm fakmom. Memom, “Ka Jerusalem thofm yak bebrahmr.” Wom yima furam nhaf inji htihato fanhomom. Jisasr turhu disaiperm yakhato turpathato kfo memorm, ");
INSERT INTO amp_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Wawanyko, nom Jerusalemko yitahat, na Bro Najoma hrek kita prisroh bro yimami nkifra boririfhuthu tisaroh tirmn. Kmim rompno nakfo habofkniruhamn, yima tangimpno htarhotma, ");
INSERT INTO amp_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","rom sinyahato kuninfar wuna kfo hutatpno kfo hutatpno yenyohrahma. Tfit wife wife yenyoh gurahma. Wife yenyoh guhato tfit yura bgre misn kihegir-rhotma nohruha. Nohruhoyann tfit husfirpehyuk marrpno tfit sinyaruha.” ");
INSERT INTO amp_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sebedirhu yon husf, Jemsri Jonr, nd hus yonf Jisasrpno yihato mkfo memofr, “Tisa, no kangno, nnoh wom dukeft bi akfo nuhas htatanonn.” ");
INSERT INTO amp_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jisasr sinyahato kfo memorf, “Tamoh mrokfot yamukafn, akfo nuhasnonr?” ");
INSERT INTO amp_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Nd yon najohf sinyahato kfo memofr, “No kangno, ni kingn toh thoft no najo wayak htatwanno. Womr tirmifko wayak htatwanr, womrne kindonko.” ");
INSERT INTO amp_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jisasr sinyahato kfo memorf, “Nifn nhai duka hik marnyahato ttiwonkahfna. Nd na yeruha krhoparoh kaft ka yenyho twanho mifrahfna? Yo na baftaisruha krhopa yakyuk baftaiskfot nifn yakrahfnt?” ");
INSERT INTO amp_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Kfo memofr, “Uwano.” Jisasr kfo memorf, “Na yeruha kaft rot nifn yerahfnt. Yo na yakruha baftaiskfot nifn rot yakrahfn. ");
INSERT INTO amp_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Tmift nanhu kindonko yo tirmifko rhuyuk tkitt yak htaneftn, na nhai bi nanhu fijo kfo mekfot ni ndko rhurahn, yo ni ndko. Nhai. Tu Bro Nkifrarhu duka fijo fak hta nhombra htatamorm tkitm. Kto turhu hti fijo tkitm yak hta nhombra hi hanyrahrm.” ");
INSERT INTO amp_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jon Jems najohf inji ttiwonmotfr tfit wom 10-pela disaiperm kfo hutt memomf, “Tamohmpno ndhtet ttiwon nmbuhat ttiwonwafnr?” ");
INSERT INTO amp_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jisasr rpat naku nhafoh bugamormn kfo memorm, “Niko bi htiyeteko, kingm yima tangim yakitohwohat. Yimam be nd tohak yimarhu yinhitn tohwom. Nhai womr finji tfit kfo pthakfot. Yimam be rorhu tngrpat hikkfot. ");
INSERT INTO amp_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Niko mirahko nd neft ahiknom. Yimar kangr, ‘Tohukatohr atoha,’ nd yimar afo nikmoh hingrnanho yimar tohkfot. ");
INSERT INTO amp_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","O kangr, tohak yimaya atoha, afo toh tario yimar tohkfot. ");
INSERT INTO amp_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","To na, Bro Najoma niamohat, nhai nanhu rhu nmbuhat dukahato ndar bbinysoft niarmoyant. Nhai. Nikmoh rhu beb nmbuhat duka tanyhato niamoyant ndar bbinysoft. Nann ndar bbinysof thofroh fasoh fasoh nefm suh nanyorruhanm.” ");
INSERT INTO amp_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yi yimomn Jerikot mfnahmom. Mfnahhato yonmari yima rifinyrpno rpatn yuhre fau htany hanymomt kmi Jerikot. Nd kmitn wom nyinga kunyjet yimar yihota yifembtn rhu hasomor. Nd yimar Timeusrhu yon Bartimeusr. Nd yimar yihotam rhuhato yihotat yau naffyuk yimam maruha tndaumourm. ");
INSERT INTO amp_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","yihota yuhat rhuhato wanyak hanymorm yimam ptha hofhta hnamohat. Kfo memom, “Nasaret thof Jisasr niewur.” Ror inji wanyhato kfo nakuyafo memor, “Defitrhu tangishof Jisase, wayuhuwafna!” ");
INSERT INTO amp_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Inji kfo nakumotr wom yimam kfo thfamomr. Ror nhai wany yakiohato naku tmbhormor. Tfit wompam masat kfo nakuyafo memor, “Defitrhu tangishofe, wayuhuwafna!” ");
INSERT INTO amp_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Be Jisasr nd yimarhu naku tngt wanyhato be mtohmor. Mtohhato kfo memorm, “Nd na nakuta yimar wahnakomr.” Yimam yihato rim kfo memomr, “Mirahn adukaya. Wasinya. Jisasr ninn nakutr.” ");
INSERT INTO amp_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Be yudbat sinyanihato nd ror hmbremoa sakethat wathu hrur tanymortn Jisasrpno yimor. ");
INSERT INTO amp_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jisasr htiyak hanyhato kfo memorr, “Wurene tamohmn nakuna?” Nd nyinga kunyjetr kfo memor, “Tisaye, kanga nyingam wayak marnyakahtna ayukatoha.” ");
INSERT INTO amp_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jisasr kfo memorr, “Nanhu nia mrokfot ni wanuhat ninhu bro dukeft nann htahato nakuna. Ndnettn wanju. Mirahn adukaya. Ninhu nyingam marnya-rahmn.” Be nd yimarhu nyingam nhai wom kuknarmomr. Yudbat fukatoh dbtakumorm. Nd nyingam marnyamotmr Jisasr fau hikakni twanhomor. ");
INSERT INTO amp_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jisasri turhu disaiperm yimomn brbo Jerusalemtpno yorhwa Olifet kmi yihofr yorhwa kmi Betfageti Betanit mfnahmom. Ndha mhtahato hus disaiperf kfo tkrur memorf, ");
INSERT INTO amp_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“Ndar rihtita kmit warine hanyfn. Warine hanykahfnn htirahfnr natifatayet donkiyenr. Nd donkiyenr nhai yimam tafi rhuhato hatone-rmomr. Nd donkiyenr wayak nyusakaknetwafn. ");
INSERT INTO amp_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Yekwatfnr yimam ttiwon kangmfn, ‘Tamohmpno yaknitafnr?’ wakfo wamitwafnm, ‘Bro Nungothetr hingrnefetrn kfefitrno be yifrar kakni yahukanonr tfit yudbat yarim htanyrahr.’” ");
INSERT INTO amp_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Be rof yimofn mhtimofr donkiyenr kuny yifhatikthu yirawih mispno natifa htatayetrn. Be rof inji mhtihato nyusakaknamofr. ");
INSERT INTO amp_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Yimam inji htiyafo hanyhato ttiwon memomf, “Barefn, tamohmpno nd donkiyenr yaknitafnr?” ");
INSERT INTO amp_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Kfo memofm, “Bro Yimar kfo tkrurefitrno kakniyahuknonr.” Be inji wanyhato kfo memomf, “Wayaknihefnr.” ");
INSERT INTO amp_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Be nd donkir nyusakaknihato hanyhemofr. Jisasrpno mhtahato tufhu rmontham yakmofmn donkirhu mongtn rhuyuk tkitt htamofm. Htanihato Jisasr mrhuhato yimor. ");
INSERT INTO amp_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ror yimohat yonmari yima rifhur ror htiyak hanyhato turoh rmontham yakmomm, rorhu yiyuk yuhatn hta nyingtak-momm. Womm miyuhtam yak wokakhato ror yiyuk yihotatn htakmomm. ");
INSERT INTO amp_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Jisasrhu nyingako tohakmo yimam yo mongko tohyuk yimam, romn kfo naku ptha hany memoum, “Wayindhorakkomr. Bro Nkifrar ayak marnyatwarr Brorhu yufatpno niayuk yimar. ");
INSERT INTO amp_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Bro Nkifraye, nda nmoh bapem Defitrhu frika yuhat niayuk yimar king toh thoft wayak marnyatwanr. O tu tunga Nkifraye.” ");
INSERT INTO amp_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Be Jisasr kmi Jerusalemr mfnahhato Bro Nkifrarhu temperr rim fnahnihato temperrhu kuny rifhut rhuyuk tamoh tamohm hti htfas bugamorm. Marr bi miyak yifho buga hanyetrn be tfit fnahnimorn turhu 12-pela disaiperm yaknimorn Betaniko yimom. ");
INSERT INTO amp_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Betaniko mhwi tanyhato ndwom dbha memom tfit anianom Jisasr buha myatinohmor. ");
INSERT INTO amp_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Nndo kkof tohhato fik tihat htimort twettn. Ror memor, “Ka yukha hirwot.” Brbo yihato fukatoh hambro titamort nhai wom yukhayenm hirrmomt. Yuhtam be sfno twabomrpam bommomt. Tu fik wormr atohr awi yukham hirrmom. ");
INSERT INTO amp_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Be nd fik tihathu yukham hti hambrotihato nd fik tihat kfo memort, “Mirahn tfit yukha hirkahann yimam yukham ayak ayema.” Jisasr inji kfomohat turhu disaiperm wanymomr. ");
INSERT INTO amp_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Jisasr Jerusalem rim fnahnihato rim htimorm Bro Nkifrarhu temperrn maket htamoum yimam. Rim htihato maket htamoa yimami yeshrim wiknamoa yimam hik tubatumorm. Hik tubatumormn maruha niyak tuknamoa teborm yo nunga ganyom mmkrm htamoa gajim nembos tubatu hikafmorm. ");
INSERT INTO amp_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Nd yiha yimaroh wiknayuk tamoh tamohroh temperrhu hiyau hafknenineft kfo rafomort. ");
INSERT INTO amp_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Yak thunihato kfo memorm, “Bro Nkifrarhu rfa borngt kfo kangt, ‘Nanhu temperr nanhu kfo bruttnayuk kunys rhuraht.’ Tfit nikomn kangko rikoh yimaroh yi kafrohyuk tkitt arhut.” ");
INSERT INTO amp_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ror kfo pthamoa mrokfom met yindarim wanymohat mfha tha duhatm rhumom. Ror pthayuk mrokfom wany fanhomomm. Ndnettn prisroh bro yimami nkifra boririfhuthu tisam inji wanyhato kfo memom, “Be wom yuhamn kfo nhehakhato wasrahnomr.” ");
INSERT INTO amp_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Be krifnano Jisasri turhu disaiperm Jerusalemt htanyhato yimom. ");
INSERT INTO amp_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Hwe nfha ndwom dbha Jisasri turhu disaiperm tfit yi hanyhato htimomt nd Jisasr kfo nambur mrokfot kfonimo fik tihat bi twa yuruf hasettn. Memom nndo tohrn yitattrt fokrta hmbrit. ");
INSERT INTO amp_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pitar nd mis htihato tfit dukamor Jisasr kfo memohat, “Nda mis miraht tfi yukha hirhato yimam yukham tmbra ayama.” Pitar nd mrokfot dukahato kfo memor, “Tisa, nohok nda mis kfo nambur mero, anohtwat. To wahti bi fokrtewut!” ");
INSERT INTO amp_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jisasr wanyhato kfo memor, “Nikmoh bro dukefm Bro Nkifrarpar htakfot. ");
INSERT INTO amp_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Na kfo mifwanko, nikmoh yima yuhum be tu rpa yima yuhur rhuhato ndar kminysoft kfo mirahkomt, ‘Asomif nom kfiwunom marombtn wamitoh witani,’ to be htirahkomt nd kminysoft marombtn mitoh witaniraht. ");
INSERT INTO amp_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Nikmoh yima yuhum rpa dukefrpar rhuhato tamohm kfo bruttna kfo mirahko, ‘Nom asomif kfiwohat Bro Nkifrar wanukwarn nd nom kfo bruttnewa shrm htitnomm.’ Inji dukahato kfo bruttnarahko, to be hti mifrahko. ");
INSERT INTO amp_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","26","Kangn, ‘Akfo bruttnaya,’ womm nayuk nefm afo mong trohkfot. Womroh nefm mong trohrahnm, tawo ninhu Yifemr hefenr tohwar mong trohhirahrn ninhu nefm.” ");
INSERT INTO amp_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Jisasri turhu disaiperm tfit yimom Jerusalemt. Yihato Bro Nkifrarhu temper kmifarn fknenimorn fau htfasmor. Yau htfas hanyetrn prisroh bro yimam yo boririfhuthu tisam yo Judaroh wom bro yimam fau yukato-haknimomr. ");
INSERT INTO amp_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Brbo yihato kfo ttiwon memomr, “Frohmn ndhtet bbuka rifhur hemomn? Frohmn bbuka rifhur hehato kfo memomn inji wanatwa?” ");
INSERT INTO amp_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Tfit Jisasr sinyahato kfo memor, “Na to tawo tfit ttiwonwanko. Tone Jonr yimam baftaisimmoahate tu Bro Nkifrarn kfomotrr ndhtet hingrneft hingrnamourt o be yima mifm kfomotmr yimam baftaisimmourm? Nd ttiwon nmbuhat kanga wakfo nuhaskahtkma tawo kfo nuhasruhanko na hingrnewa hingrnefthu bbukeft yakmo yuhat.” ");
INSERT INTO amp_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Rom inji wanyhato tfit tum nnakfo memom, “Nom sinyahato kfo mirahnomr, ‘Bro Nkifrarn kfomotrr hingrnamour,’ to tfit mirahrnom, ‘To tamohmpno wany yakio duha yirmokomr?’ ");
INSERT INTO amp_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","To Jonrhu mrokfom bi profetm kanjo pthahato yimam bi wany hatohetmn, tfit nom kfo mirahnom, ‘Yimaroh kfotpno kfo pthamour,’ to be yimam sinyahato tat nohrahmnom.” ");
INSERT INTO amp_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Be myak nhtaktihato be kfo memomr, “Nom nhai tawisafkahnom.” Rom inji kfomotm tfit Jisasr kfo memorm, “Na to inji. Na nhai kfo nuhaswotanko na hingrnewa hingrnefthu bbukeft yakmo yuhat.” ");
INSERT INTO amp_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jisasr bro yimampno wom kfo nhombra mrokfot yakhato kfo memorm, “Wom yimar wain swirt htamor. Wain tofm nuhtanihato gnat gna habrimort. Gnanihato muhr toumorr wain yukharoh yahot kembiftyukr. Ndt inji hingrnanihato tfit nd wain swirthu rhu yukatohyuk kumba kunyr hingrnamorr. Be inji hingrna tanymortn wom yimam yakhato nd mswirthu tohukatohhato yukharoh nayak nhta yuham nayak dbkafhato ror be wom kmimn toh habrimor. ");
INSERT INTO amp_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Kto nd wain swirt yukha hirmott yukha yak yiharn nd tu wain swir tikatr turhu hingrna yimar kfo tkrurafmorr, nd wain swirt yakitoh hasoyuk yimampno. Kfo tkruraf memorr, ‘Waikahnn nanhu yufathu htahayuk yukham wamiyakhina.’ ");
INSERT INTO amp_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Yihato nd mswirt tohukatoh hasoyuk yimam sinyamomn tabotafmotmr be sfnopa tfit yimor. ");
INSERT INTO amp_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Be nd wain swir tikatr htiyaktihato tfit wom yimar kfo tkrurafmor. Nd yimar nhaf be rpahtet neft namomr. Mfhapako frddbithato faso faso kfo yimtna boyimtna tuhafmotmr be yimtneftpno yimor. ");
INSERT INTO amp_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Tfit womr kfo tkrurafmor. Ndrne be wasmomr. Be wom wom yimam yimoahat be mifahotakmoum. Nd mswirt tohukatoh hasoyuk yimam sinyamoamn womm tabotmoumm, womm wasmoumm. ");
INSERT INTO amp_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Wuroh turhu garbn yon mifr. Nd yonr be marbit htamourr. Duka memor, ‘Tukanhu garbn yon mifr yiruhatre wany yakiorahmr.’ ");
INSERT INTO amp_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Be nd yonr tkrurafmotrr yimor. Yimotr wain swirt tohyuk yimam htiyakhato tum rinnakfo nakfo memom, ‘Ndarr turhu yonr nier. Yifemr nohnineft to nd yonrn tkitt yakhato ndar wain swirt rorn yakrahrt. Finji dukewako? Awaskahnomr be nd wain swirt be nmoht rhuraht.’ ");
INSERT INTO amp_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","To be mrokfot nayak dbkafnihato turhu wain swirt toh hasetrn wasakhato briahako rim tuhafo tanymomr.” ");
INSERT INTO amp_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jisasr inji kfo pthanihato kfo memorm, “Niko to finji dukewako? To nd wain swir tikatr, turhu yonrhu was mrokfot wanynefte to finji naruharm? Na kfiwanko wain swir tikatr nieruharn nd yimam was hehur thuruharm tfit wom nndoh tkitthu yimam yakhato yak htarahrm nd mswirtn. ");
INSERT INTO amp_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Wom mrokfot Bro Nkifrarhu rfa borngt yorhwat htitwokomt? Nd mrokfot kfo kangt, ‘Nd rahur, kamda yimam hti kurhato yak thumor, be bi tfit nd rahurn bi dany rahur tohwor. ");
INSERT INTO amp_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Tu Brorn inji hingrna hta bohtamotrt nom be inji htihato mrokfo duha korhwonom.’” ");
INSERT INTO amp_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Nd nd mrokfom pthamotrm bro yimam wanyhato kfo memom, “Nd kfo nhombra kfot nomn niewut.” Jisasr pthamo mrokfom rom wanymohat yima yuhumio bi nambur kih bugamomm. Memom, “Ka bi kak twanhiwunomr.” To nhai, yimam htihato afo fakrmemom yakneft. Duka memoum, “Finji rinakrahnom, rom sinyaruhamn tabot nohrahmnom.” Inji dukahato fafho thu tanymomr. ");
INSERT INTO amp_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Judaroh bro yimam sinyahato Farisimi Herotrhu politiker patikfot tohyuk yimam yakhato kfo memomm, “Nikmoh womm aikahkomn rorhu mrokfo ptha swirmn rhunhohato yuwi ttiwon rhtikfot. Finji finji kfiwur, nd tkittn yakhato kotimrahnomr bro yimampno.” ");
INSERT INTO amp_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Be inji kfafmotmm yimom. Yihato yuwi ttiwon rhti memomr, “Tisaye, ni pthewa mrokfom nom hifa wanuknomm. Mrokfom hifa hifa kfo hik bohik marnyewanmn Bro Nkifrar hikwa nefm kfo hik nuhas marnyewunm tuhan yindarim. Mrokfom kfo pthiwohat nhai hti mekahn ndr yufet yimayer o ndr yufa duha yimayer. Nhai. Mrokfom kfo pthaneft be kfo pthewunm. Nhai yimar o yufam htihato kfo pthakahnm.” Inji kfonihato wom ttiwon nmbuhat yuwi ttiwon rhtimomr, “Nome ka Sisarhu takis htahenefte ka htarfonome nhai?” ");
INSERT INTO amp_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Rom yuwi inji ttiwon rhtimohat Jisasr bi htimorm rroh dukefm. Htihato kfo memorm, “Tamohmpno inji ttiwon rhtitakma? Afo wom tahifat wayak nuhaskoma.” ");
INSERT INTO amp_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Inji kfomotrm wom tahifat hemomr. Nd tahifat yakhato kfo memorm, “To nda tahifat yorhwa nyingatikte frohroh nyingatikti yufat yorhwaf?” Kfo memomr, “Sisarhu nyingatikt korhwott.” ");
INSERT INTO amp_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Tfit kfo memorm, “Sisarhu nyingatikt korhwott to be tfit Sisarn hekfot. Bro Nkifrarhum nhaf inji. Tu Bro Nkifrarn hekfot.” Inji kfo wokafmotrm be tuha mrokfo duhatm tohmom. ");
INSERT INTO amp_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Farisim yimotm tfit Sadyusim yimom. Nd Sadyusiroh dukeft duka memoum, “Noh hanita yimam nhai tfit sinyaruhatm.” Rroh dukeft inji rhumout. Nd dukeftpno Sadyusim Jisasrpno yihato mkfo memomr, ");
INSERT INTO amp_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Tisaye, Mosesrhu boririfhut kfo kangt, wom yimar tuhan yakhato nhai wom yonm kasinya htanirfor, nd rorhu tuhan dhirt tfit wom nmemrn najom dhirt yakhato rorpno yonm nasakhato tfit najomrhu tkitm romn tohkfot. ");
INSERT INTO amp_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Wom yima najohfitpno to inji rhumot. Nd yima najohfit 7-pelakfot tohmom. Barkof bro najomr tuhan fakmor. Ror tuhan yakmohat nhai yonm nasak htanihato nohrmor. ");
INSERT INTO amp_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Be nohmotr tuhan dhirt tohmott tfit rorhu wayakrn fakmort tuhan dhirt. Rorpno nhaf nhai wom yonm nasak htanihato nohrmor. Tfit rorhu mongko nuryukrn tfit fakmort nd tuhan dhirt. Ror yakhato be rpahtet neft. ");
INSERT INTO amp_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Be inji nahany nahanysn 7-pela yima najohfit rhu nhombra bugamotm. Wuroh 7-yukrpnone nohmot. Nhai wom yufat kasinya-hermotm nd yima najohfi bugat. ");
INSERT INTO amp_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Nd 7-pela yima najohfit rpa metrpat rim rhuta mrhutamotm. Kto nd najohfit sinya thoft nd mette fitoh yimarpno tohruhat?” Inji ttiwon rhtimomr. ");
INSERT INTO amp_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jisasr wanyhato kfo memorm, “Bro Nkifrarhu mrokfom yo rorhu bbukeftpno nd noheh yimam sinya thoft ka mumiwuko. ");
INSERT INTO amp_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Wawanyko, nd bi noh hanita yimam kto tfit sinya thoft nhai tfit tuhan yakruhatm. Nhai. Be inji sfno hefenrhu mounmotm kanjo tohrahm. ");
INSERT INTO amp_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nd yimaroh nohhato sinya yuhat Mosesrhu tndht duka hanykfot. Wom yiha Mosesr Bro Nkifrar kahm kanjo mi bufupatn funamotr hti hanymorr. Bro Nkifrar Mosesr kfo memorr, ‘Nane Abraham, Aisak, Jekofroh Nkifraya.’ ");
INSERT INTO amp_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Bro Nkifrar yima nfri yafothet yimaroh Nkifrayer. Nhai noheh yimaroh Nkifrar rhukahr. Nikmoh kfoyuk mrokfom kfo mumiwuko.” ");
INSERT INTO amp_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jisasri Sadyusim mrokfom nakfo nakfomoahat wom nkifra boririfhuthu tisar rhuhato wany yakitoh hasomourm. Sadyusim Jisasr kfo ttiwonmoatmr tfit Jisasr kfo nuhas marnyamourm. Ror inji wany hasohato ttiwon memorr, “Ndar nom wanuka boririfhum, fitoh boririfhutn nyingako tohekwat?” ");
INSERT INTO amp_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jisasr wanyhato kfo memorr, “Nd nyinga tohekwa boririfhut inji kfiwut: ‘Niko Isrerko wawany marnyako, Bro Nkifrarpar nmoh Nkifrar rhukfot. ");
INSERT INTO amp_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Bror ninhu Nkifrayer, ndnatn ninhu yuhuwaf marbi bugam, ninhu yafothat, yo ninhu yima yuhu bugam be rorparn htakfot.’ ");
INSERT INTO amp_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Yo ndwom boririfhutne: ‘Tunn yak marnyewa kanjo inji womm yak marnyakfot.’ Nd hus boririfhufn tu bro boririfhu mifef.” ");
INSERT INTO amp_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Be nd nkifrar boririfhuthu tisar inji wanyhato kfo memor, “Bro yimaye, ni tu tpiyet mrokfot kfiwun. Brorpar tor tu Nkifrar, nhai tfit womm. ");
INSERT INTO amp_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nom be rorparn nmoh yuhuwaf marbi bugam, yima yuhum, bbukefm rorparn htakfot. Yo tunn yak marnyewa kanjo inji womm yak marnyakfot. Nd hus boririfhuf tu fipetef. Rofn tohakhato tarioh mthaneft be yak tariokfot.” ");
INSERT INTO amp_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jisas nd yimar kfomo mrokfot wanymohat, tu hifa duka tungunet yimam pthiwa kanjo inji wanymor. Wanyhato kfo memorr, “Ni bi brbohwo Bro Nkifrarhu kingdomkfot rhuneft.” Judaroh bro yimam wanyhato fakrmemom tfit wom ttiwon nmbuham ttiwonneft. ");
INSERT INTO amp_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jisasr Bro Nkifrarhu temper kmifar tohhato tuhant yindars Bro Nkifrarhu mrokfom kfo nuhas hanyhato kfo ttiwon memorm, “Tamohmpno boririfhuthu tisam kfo yamukam, ‘Yimaroh minrfa htiyakyuk yima Kraisr, Defitrhu frikef yuhathu yimayer?’ ");
INSERT INTO amp_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Bingot Bro Nkifrarhu Yafothatn Defitr yima yuhur hemotrr kfo memor, ‘Bror kfo memorr nanhu Bro Nungothet Kraisr, “Nanhu bro bbukeft yorhwa tirmifko wamrhun. Wamrhukahtn nd ni namburwa yahr kmim afo ninhu tirtn htahato ninhu mofsinhitn yak htaruhanm.” ’ ");
INSERT INTO amp_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","To nd yima Kraisr bi Defitr kfo yuta hna memoa, ‘Nanhu Bro Nungothetr,’ to tfit Defitrhu frikef yuhat nierahr?” Bro met yindar rifhur rhuhato wanymohat nd Jisasr pthayuk mrokfom yindhormoum. ");
INSERT INTO amp_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jisasr kfo nuhas memorm, “You, niko! Boririfhuthu tisam yukatoh hik marnyaf hanykfot. Turoh yuke yuke saketham hmbrehato maket swirm yau hanyneft kangm, ‘Yimam be ayindhor amemnom, “Hifa dbha Rabai.” ’ ");
INSERT INTO amp_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Fitoh rhu rifinyhato kfo bruttnayuk rmonm rom nhai mongkorn o kimbohnko rim rhukfot. Tu be nhai mif. Rom tu be nyingako mruhakkfot. Bro yemro ye burwa tkittn nhaf inji. Rom inji yimaroh nyingako mrhu gngonakkfot. ");
INSERT INTO amp_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Met dhirrpampno yitamn mkfo nheh bonhehaknihato wuskenm kak rhoptakni yahukmm. Bro Nkifrarhu kfo bruttnaneft htirahnm. Nhai be yudbat kfo tmbhoniruhatm. Yuwi kangm, ‘Akfo bruttna yukekahtnom yimam inji htiruhamnom mirahm, “Hifa yimayem.” ’ Kto Bro Nkifrar kotkfot yakitoh thoft nd yimamn be tu bro krhopam yakrahm.” ");
INSERT INTO amp_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jisasr nd Bro Nkifrar maruha mhtanihemoa tkitt rhu hasohato htiyafo hanymourm yimam maruha mhtanimoahat. Nd bro maruhetm bro maruham htanimoum. ");
INSERT INTO amp_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Rroh mongkorn wom met dhirpat niamot. Rothu ramemr nohmotr rot turpatt tohmout. Rot nhai tamoh wuskam o tamohm. Rot yimotn wuroh tuthu yohript rhuyuk wuroh fsohot marufenf yakmotfn Bro Nkifrar maruha htahemoa tkittn nd marufenf htanihemotr. ");
INSERT INTO amp_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jisasr inji htihato turhu disaiperm nakuyakhato kfo memorm, “Na kfo mifwanko, yimam nd htahani hany marufam nd metrpat hte marufenfn be tu bro marufaf htes. ");
INSERT INTO amp_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Wom womm htahani marufam, rom maruhetmn yak nhtemmn wom fam Bro Nkifrarn hnahehato htahumr. Nd metpatn be tu nhai wom maruhenm kunykort. Tu wuroh yohript rhuyuk wuroh rpa toeakfot Bro Nkifrarn htahut. Rot nhai wom yeshri wiknayuk maruham wom rhukahmt.” ");
INSERT INTO amp_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jisasr temper kmifar htanyhato turhu disaiper-mpno fau hanymom. Yau hanyhato wom disaiperr kfo memorr, “Tisa, wahtinr ndar temperrhu dborioh tahim yo temper kmifar tohyuk dborioh dborioh kunym.” ");
INSERT INTO amp_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jisasr wanyhato kfo memorr, “Bare, ndar ni htita kunym nhai inji rhuruhatm. Yimam niahato kafring witarahmm.” ");
INSERT INTO amp_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jisasr yura Olifet kmit muhhato mrhumorn rihtimorr temperr. Ndha rhu hasetrn Pita Jems Jon Andrurom turpam niahato ");
INSERT INTO amp_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","ttiwon memomr, “Nd ni kfi mrokfot fitoh yihar rhuruhatt htiruhanomt? Tamoh neftn yak dukaruhattnom mirahnom nd yihar bi brbohwor?” ");
INSERT INTO amp_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","6","Jisasr kfo memorm, “You niko! Wanyrahko yimam yi htfasruhamn bok yimam kfo nheh bonheh htfasrahmm. Nanhu yufat yutahato kfo mirahmm, ‘Na bi asoya niko gari hasomo yimaya.’ Inji wanukko mirahko yudbat wany yakiohato amhikakninomm. ");
INSERT INTO amp_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nna yureft mano mano wanyrah-komt yo fitha fitha rhuyuk nna yurefthu mrokfom wanyakrahkomt. Inji wanuknom, bi mirahko bok dukefm ayaknom. Ndhtet nefm rom nierahm. To mirahko ka bi nd nefmpno bi brbohwor yihar. Nhai. ");
INSERT INTO amp_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Htirahko yo wanyrahko wom kantrikfot sinyaruhatn wom kantrikfotpno nnarahf. Wom kingr sinyaruharn wom kingrpno nnarahf. Wom kmim yatinoh wormr tohrahrm. Wom kmim bro nunes toniraht. Nd nefm yironarah-komm yon fanet mett barkof riyak yironekwa kanjo. ");
INSERT INTO amp_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Niko tuko duka marnyaf hanykfot. Tukmoh kaunsermpno mkotimruhatmko Judaroh rhu rifinyuk rmonmn hanyhato tabotrahmko. Nanhu mrokforoh yimaroh ptha nuhas hanyeftn gafmanm, kingm, nd nd yimaroh tirmn htarahmko. Nd tkittn nanhu mrokfot nd bro yimam kfo nuhasrahkomm. ");
INSERT INTO amp_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nd gutnius mrokfot afo yuht kantri bugat afo wany bugarahmt. Bi wany bugemt, ee btn nd yihar nierahr. ");
INSERT INTO amp_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Fitha kot swirm hanitwomko mirahko yakrmihato akfo amanyom, ‘Amai, na finji kforuhoya?’ Mirahn inji aduka yanhoya. Bro Nkifrarhu Yafothar mrokfo ptha dukefr hirahrn. ");
INSERT INTO amp_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Najohfi yagnm tum nahndhnarahm. Womr sinyahato womr hndhnaruhatrr wasrahmr. Nitohfim nhaf to inji. Yifemr sinyahato yinemr hndhnaruhatrr wasrahmr. Yinemrom nhai yifa-mmampno nayak marnyaruhatm. Yinemrom sinyahato yifammam hndhnaruhatmm wasrahmm. ");
INSERT INTO amp_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nann hikruhatko yimam nhai hifa nyingar hta hakuruhatmko. Be faso hti sr thurahmko. Fitoh yimar toh bmtahany toh bmtahany bbinysofthu bati yihar mfnahr, nd yimar Bro Nkifrar yakrahrr.” ");
INSERT INTO amp_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Jisasr kfo memorm, “Wahtiyaf hanyswako. Bro Nkifrarhu temperrhu kforafet kforafet tkitm bi wom hhrek shrr bi rim yorhtrm nd temperrhu Tahi Yarhr bbnarofakhato fnahnir, to be Judia profins tohyuk yimam mirahm wom atoh hasonom, yura kminysofko ayakrmanyitwam. (Yimar mrokfom htiyukr hti hik marnya hanyhato mrokfo yimbu yuham yakkfot.) ");
INSERT INTO amp_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Yimar bi kunyshu wom yura ken tikrko wurhu mska hasir, mirahr tfit yiro mmem kunyko ayohnikahann wuskam arimaka. ");
INSERT INTO amp_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Yimar bi mswirko yirn ndko tohwor, mirahr tfit kmiko aikahann turhu yuke hmbreshat afo tfit ai ayaka. ");
INSERT INTO amp_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Metm yon fanetm yo tefi yon hamboriyetm finji yakrmiruham nd bro krhopam yakakna thombat? Romn tu bro yuhuwafeft korht. ");
INSERT INTO amp_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Bro Nkifrar kfo bruttnahato mirahr nd bro krhopam bro gonng wormrn arhukahtm yimam nd yiharn ayakrmem. ");
INSERT INTO amp_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Nd neft nia thombat mirahko ka tefi tefi kurhefm rhurahm. Ndar bbinysoft trhanimohat nhai ndhtet krhopam rhurmom. Yo ndar toh hniwa yiham nhai ndhtet kurhefm htikahnom. Yo kto nhai ndhtet kurhefm wompam rhuruhatm. Be tu bro bro krhopam tohrahm. ");
INSERT INTO amp_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nd kurheft rhu hany Bro Nkifrar nhai bmbri yak nohrfort, be yima bugam nd kurheft ye wus batirahtm. To nhaft Bro Nkifrar tfit dukarahr tur bi kfo htayuk yimam. Romn dukahato nd krhoparoh tohyuk yiham tfit yak kkopenrahrm. ");
INSERT INTO amp_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Nd yiha wom yimam kfo mirahmko, ‘Barenko, nd Bro Nkifrar kfo htamo minrfa htiyakyuk yima Kraisr bi asor, asha.’ Womm kfo mirahm, ‘Usor, usha.’ Inji wanyrahko, mirahko awany yakionomm. ");
INSERT INTO amp_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Womrne inji narahr. Mirakerkfot hingrnaruharn kfo mirahr, ‘Na asoya niko toh gari hasiwa minrfa htiyakyuk yima Kraisa,’ o kfo mirahr, ‘Na profeta.’ Inji kfohato wonk wonk mirakerkfot hingrnarahm. Yuwi mirahm, ‘Tu Bro Nkifrar kfo htayuk met yindarim frnhehakhato ahikmnom.’ ");
INSERT INTO amp_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ndnettn duka marnyaf hanykfot. Kfo duka mrokfom bi kfo duka htiwanko.” ");
INSERT INTO amp_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Nd bro kurheft rhuniruhatt ee htirahko marr rim noh kfirahr, nhai wom taruhatr. Yamt nhaf inji. Rothu nukeft rim fnahniraht, nhai wom taruhatt. ");
INSERT INTO amp_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Gunym rom nhai mount rhuruhatm. Rom be wuyohninehato misuhrahm. Mount thu habokknamo yifonm mirahm nndo ginunes kekwotm. ");
INSERT INTO amp_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ndtpno ee btn Bro Najomr htiyakrahmr gribpamn hawihnerahmr. Ror yawihna thombat turhu bbuka rifhur yo ror hatoh hneruha nukeft mirahm nndo marrn yifa tohhnewur. Inji htiyakrahmr. ");
INSERT INTO amp_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ror yawihna thombat mounmotmn kfo tkrurafhwatr romn tur bi kfo htayuk yima bugam yak nhafoh htfasrahmm.” ");
INSERT INTO amp_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Jisasr kfo memorm, “Kutr htitwonomr, twam huktewum kfo kangnom kut yinr tohrahr. ");
INSERT INTO amp_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","To be inji hti nhtakrahkomr Bro Najomrhu nia yihar. Bi nd nd nefm htitwoko, wakfo wamitwako, Bro Najomrhu nia yihar bi brbohwor. Yifhatikt bi tohwor. ");
INSERT INTO amp_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","To nd nefm rhu thoft to mirahko arihat tohwa wom yimam bi nohetmn nd neft rhuraht. Nhai. Arihat wom tohwa yimam yuhre tohetmn nd neft htirahmt. ");
INSERT INTO amp_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Nd neft rhuneft htirahko mounti bbinysoft mibatinirahf. Nanhu mrokforpat nhai mibatiniruhatt.” ");
INSERT INTO amp_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Jisasr kfo memorm, “Nd na kfiwa nefroh rhuyuk yihar nhai wom yimar tawisafkahr. Mounmotmi Bro Najomr rom nhaf nhai tawisafkahm. Tu Bro Yifemrpar tawisafwort. ");
INSERT INTO amp_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Niko nhai tawisafkahko nd nefthu rhuyuk yihar. Ndnettn niko be duka marnyahato hti yukatoh hasokfot. ");
INSERT INTO amp_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Nd neft wom yimar kunys htanyhato warkmit yita kanjo inji rhuraht. Kuny sikatr kunys htanyneft hingrna yimam rpa rpa hingrnefm kak htanyworm, kuny yifhatikthu tohyukr kfiwurr kunyshu yukatoh marnya hasoneft. ");
INSERT INTO amp_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ndnettn niko be yimbhindangm tohetohaf hanykfot. Nd kuny sikatr ka krifn o yifung o ka dbha ksfut nierahr. ");
INSERT INTO amp_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Miruhatr tfit yudbat ania, mirahn hwe haseta amihtira. ");
INSERT INTO amp_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ndar na kfiwa mrokfom yuht met yindari bugam kfiwa. Niko buga difronhato hti yukatoh hasokfot.” ");
INSERT INTO amp_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Yispa hta duha bretparoh ye yiharhu barkof yihar, kutewumr Pasofa burwa yihar, nd yihar bi brbohnetrn prisroh bro yimami nkifra boririfhu tisam tum rhu rifiny-hato Jisasrhu hndhna nhehakhato was yuhathu mrokfot nafak dbkafmomt. ");
INSERT INTO amp_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Kfo memom, “Nd bro Pasofa burwa yihar mirahnom awasnomr, to be you muht kanjo watanhehakrahnom. Bi kmi kmi nia rifinyetmn to be romn wahiyafrahnom.” ");
INSERT INTO amp_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jisasr Jerusalemt toh tanyhato Betaniko yimor. Yihato Saimonrhu kunys yi tohmor. Saimonr bingot lepra dbohneft yakmotrn to bi frtrufnimot. Nd Saimonrhu kunysn nuwa ye hasetrn wom mett be tu dborioh mtha yahrnyet wel botort hnamot. Nd wel botort frtfnamottn nd bro maruhaye wiknamo welpaye Jisasrhu mfhat fuk wunamotr. ");
INSERT INTO amp_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nd mett Jisasr welpa wunamo yuhat yimam htihato tum nnakfo memom, “Tamohmpno nd mett welpam be wurasoh furetm? ");
INSERT INTO amp_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nd wel botort yimam 300 silva maruhaye wiknarfotmt nd maruham yakrfonomm herfonom nd maruhapa duha yimam.” Inji kfo huttmomt. ");
INSERT INTO amp_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jisasr memorm, “Inji akfowahkomt. Rot tu dborioh neft nita. ");
INSERT INTO amp_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Nd niko kfiwa maruha duha yimam, rom nhai fitha yiruhatm. Kangko, fitoh yiha ahti dukanomm, nhai mrokfom. Na, na nhai wom tohnhorhotanko. ");
INSERT INTO amp_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Nd mett ka tamohr bi kfo memort, ‘Yima gur welpam wunefiwa kanjo welpam bi wayuk wunafokahtnr yopt yirahr.’ ");
INSERT INTO amp_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Na kfo mifwanko gutnius mrokfot kfo ptha habrineft, ndar mett nefineft nhaf kmi kmi kfo ptha duka htfasrahmt.” ");
INSERT INTO amp_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nd yiha 12-pela disaiperroh wom disaiperr kutewumr Judas Iskeriotr prisroh bro yimampno yimor. Yihato kfo memorm, “Inji inji hndhnaruhanr.” ");
INSERT INTO amp_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nd bro prism wanyhato yindhormom. Yindhorhato kfo memomr, “Maruha hirahnomn.” Judasr wanyhato yima yuhur fak nhtamourr Jisasrhu hndhna yuham. ");
INSERT INTO amp_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Be rhumomn nd yispa hta duha bretpam yeyuk yiharoh barkof yihar niamor. Nd yispa hta duha bretpam yamoa barkof yiharn Pasofa sifsifr washato ndr tarioh mthamoum. Nd yihar disaiperm Jisasr mkfo ttiwon memomr, “Nd Pasofa burwat rhu thombat, nome yeshrim fitha hta mskaruhatnom ni rhuhato ye jukaruhant?” ");
INSERT INTO amp_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Jisasr turhu hus disaiperf kfo memorf, “Waikahfnn tauntn wom yimar burioh roht titetrpno mnafuryakrahko. To be mirahfn finji ainyo. Rorn wayau hikaknitwafn. ");
INSERT INTO amp_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ror fitoh kunys kitwor, nifn nd kunys yikfot. Fknenihato nd kuny sikatr wakfo wamitwafnr, ‘Tisar kfo famur, “Waikahfnn nd kuny shofr ayak nuhastwarfn nani nanhu disaipermpno Pasofa burwa yeyuk tkitt.” ’ ");
INSERT INTO amp_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Inji wakfo ttiwonkahtfn yurakorhof rumt yak nuhasrahrfn. Nd rumtn mhtirahfnm tebor gaji nd ndm. Ndharn wahta mskatwafn. Nom nierahnom.” ");
INSERT INTO amp_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Be rof yimofn nd Jisasr kfomo yimar kmi yifhatiktn toh hasetr mhtimofr. Ror yimo kunys yimof. Nd nd nefm be Jisasr kfomo tng yuhatn hti bugamofm. Be ndharn rhuhato hta mskamofm nd bro yiha yeyuk yeshrim. ");
INSERT INTO amp_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Yifungnano Jisasri turhu disaiperm mfnah bugamotm nd hus yimaf hta mska hasomo yeshrim rhuhato famomm. ");
INSERT INTO amp_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ye hanyhato Jisasr kfo memorm, “Na kfo mifwanko, nikmoh womrn hndhnarhotra wasrahma. Tor asha kenuhiwurnom na hndhnaruhar.” ");
INSERT INTO amp_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Be inji kfomotr disaiperroh yima yuhum foh tmbhonimomm. Rpa rpa sinyahato kfo ttiwon memoumr, “Ni kfihat frohmn inji naruhamn? Ka nann?” Tfit womr sinyahato kfo memor, “Ka nann?” Womr, “Ka nann?” Womr, “Ka nann?” ");
INSERT INTO amp_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jisasr kfo memorm, “Tor womr korhnuhiwurnom. Nd yimar bretpat yaknhohato wain bupayet dis tayifaknuhir, tor nd yimarn hndhnarahra. ");
INSERT INTO amp_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Bro Najomr kangr anoha, ndt mrokfo duhatet. Rorhu noh nmbuhathu mrokfot bi nkiframpno kfo tndh hnettn nhai finji kforuhatt. Tmift nd Bro Najomrhu yak hndhna hanyuk yimarne kanga fitoh yuhat yiruhar? Mmemt hiyau duha rhurmotr.” ");
INSERT INTO amp_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nuwa ye hasohato Jisasr bretpat yakmortn Bro Nkifrar wukfo yindhornimorrn yak tif nhombrahato disaiperm he nhombrahi hanymorm. Kfo memorm, “Nd bretpam wayak wayakomm. Ndm nanhu nmpayem.” ");
INSERT INTO amp_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Wain bu kaft yakmort nhaf Bro Nkifrarpno kfo yindhornihato tengot nhombra he bugamotrm famomm. ");
INSERT INTO amp_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kfo memorm, “Ndar wain bu kaft tfit niko yekwat nd nfri yihotar hingrnaruha hingrnefet. Kto na nohhato nanhu kkut yohni thombat nd kkupamn nd nfri hingrneft be yak dbkafrahtt. Be tawo nd nfri hingrneft wahiktwako. ");
INSERT INTO amp_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Na kfo mifwanko, na nhai tfit wom wain bupam yerhota. Bro Nkifrarhu kingdomkforpatn tohhato ee btn nfri wain bupam tfit yeruha.” ");
INSERT INTO amp_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Be wuroht, windoht windoh trufnihato be tfit Olifet kmi yorgko yimom. ");
INSERT INTO amp_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Olifet yorgr mfnahhato disaiperm Jisasr kfo memorm, “Bro Nkifrarhu rfa borngt kfo kangt, ‘Tohukatohr wasaknirhotanr sifsifm natubaturahm.’ Nd mrokfot bi ruhettn niko bugako na finji naknewuma, kakrme trohwokma. ");
INSERT INTO amp_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Tfit sinyaruha. Sinyahato na bi Galiliko tohak hanyruha.” ");
INSERT INTO amp_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pitar wasinyahato memor, “Ndar wommn wakfo. Romn buha msuhtahato mhik htafrahmn. Na nhai mhik htafrhotann.” ");
INSERT INTO amp_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Tfit Jisasr memorr, “Na kfo mifwann, hrek yifungnano krirhu husyuk naku tngt tafi wany juha, husfirpa kfo namhit kfo namhi kangnm, ‘Na nhai tawisafkahanr Jisasr.’” ");
INSERT INTO amp_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Pitar sinyahato kfo memor, “Be tu nhai mif. Na kanga, ninpno anoha, to nhai tfit kafrohrhotant ninhu yufat.” Pitar kfomo yuharpat wom wom disaiperm rpa yuharpat kfo ptha hikmom. ");
INSERT INTO amp_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jisasri disaiperm afo Olifet kmit tohetmn yimom wom tkitt kutewumt gaden Getsemani. Ndha Getsemanit mfnahhato Jisasr kfo memorm, “Asha afo warhu hasoko. Na afo Bro Nkifrar rim kfo bruttnefiwa.” ");
INSERT INTO amp_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Pita Jems Jonrompno yimom. Yihato Jisasrhu yima yuhurio nhai marnyarmorr. Yima yuhur be nur dungunangu yima yuhurpno rhumour. ");
INSERT INTO amp_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Be yima yuhur yak nhombratihato kfo memorm, “Yima yuhur be nd nur dungunangu yima yuhur mtakihwotra kanga be amyakniya. Asha warhu hasoko. Mirahko ahwanyom.” ");
INSERT INTO amp_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Wunye kkofmorn bbinysoft msuhhato kfo bruttnamor. Memor, “Akfo bruttnakahta nd krho mis nhai yakrhotta.” ");
INSERT INTO amp_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Kfo bruttna hanyhato kfo memor, “O Dajaye, ndar bbinysofthu yimaroh fasoh nefm na be hta krhorhotma nann nohruhanm. Bi brbohwatt kanga akfoyann. Nd krho mis na yakruhat kangn ayak tuhant, be hifa, na yindhorwa. E nhai, kangn ayakrt, be nhai mrokfom, yakruhant. Na be ninn yukatohruha. Kangn, finji anaya, nhai mrokfom.” ");
INSERT INTO amp_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Inji kfo bruttna tanymorn tfit yimor nd husfirpa yimam rhu hasomo tkittn. Yihato yihom htimorm hwi hasetmn. Rim tohhato kfo memorr Pitar, “Saimone, nine aso hwitn? Nhai rpa auakfot afo ruhakkfot? ");
INSERT INTO amp_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Niko sinya rhuhato kfo bruttna hasokfot. Hwe rhu fura hasorahko, to be tamoh nefm mfrnhehrahmko to be suhrahko. Yima yuhur sinyarahr finji na finji naneft, to thatipt, fitha bbukeft yakruhat?” ");
INSERT INTO amp_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Be inji yihom kfo tanymorn tfit yimorn tur kfo bruttnamo mrokfom wompam kfo bruttnamor. ");
INSERT INTO amp_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tfit wompam nhaf niahato yihom htimorm nyinga krkotakhato hwe hasetmn. Yihom htihato tfit yihom frthumorm. Yihom frthumotrm mfhtas sinyahato nhai hifa yima yuhum yakrmom pthayukm. ");
INSERT INTO amp_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ror inji yihom hti tanyhato tfit yimor. Yimorn tfit niahato rpahtet neft yihom htihato kfo memorm, “Barenko, nikome asoko yuhre hwe tokr hasiwuko? Be tmift nd hwe tokr hasoneft. Wawanyko. Yihar bi asor. Bi na Bro Najomanhu fasoh fasoh net yimaroh tirroh yi yihayer bi. ");
INSERT INTO amp_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Wasinyakahtko riyahnom. Wahtiko, nanhu mhndhnakyuk yimar tor bi niewur.” ");
INSERT INTO amp_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jisasr yuhre ptha haso hanymor, rorhu yakyuk yimam mhatohmomt bainati mhrs. Tu Jisasrhu disaiper Judasrn hatohakmorm. Prisroh bro yimami nkifra boririfhuthu tisame Judaroh bro yimam, kfo tkrurmotmm Judasr hasinyamorm. ");
INSERT INTO amp_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Nd Jisasr hndhnakyuk yimarn bi kfo hta bohta memorm, “Wahtiyafo hanyswokma. Na yauyaknihato fitoh yimar mkihendhoraknitwa, wamitwako, tor nd yima Jisasr. Ee inji bi htitwokma, nd yimarn yauyaknihato yakkfot. Yakhato be yima tire hanyruhakomrn bro yimampno hanykfot.” ");
INSERT INTO amp_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Be nd Jisasr rhumo tkitt mfnah-mohat, Judasr yauyaknimorn Jisasr rim kihendhoraknihato kfo kangrr, “Tisa.” ");
INSERT INTO amp_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Be yimam yauyaknihato tirtir fakmomr. ");
INSERT INTO amp_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Rom fak hanymomr, Jisasrpno toh hasoyuk disaiperr mhti nambur-nihato bainat watuhakmortn ka prisroh bro tohak yimarhu hingrna yimar bainate yimbhindangt frbubafmotrr misuhmot. ");
INSERT INTO amp_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jisasr sinyahato kfo memorm, “Barenko, nane raskor yimam kanjo bainat, mhrs hasinyahato nia kekwokma? ");
INSERT INTO amp_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Na yiha yiha Bro Nkifrarhu temperr yorhwa kmifat tohhato met yindarim mrokfom hemoahat nhai niko inji yihato hfnahaknirmokma. To nhai mrokfom. Ndar niko niwa nmbuhat nhai finji kforuhatnom. Bi profetmn mrokfot bi kfo hnettn to be bi rhu hikwot bi.” ");
INSERT INTO amp_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nd turhu disaiperm htimom bi Jisasr kak hasiwumre, rom fakrme troh tanymomr. ");
INSERT INTO amp_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Wom yima damiagenr ganyom hmbresha wondhetr Jisasrn hik hanymor memom, ka yakrahnom, ");
INSERT INTO amp_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","to nhai, yakrmiyakhato hmbreshat thu brhoh tanyhato sfno bmbombrohr fakrme fnahmor. ");
INSERT INTO amp_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nd Jisasr yakniyuk yimam hanymomrn tu nd prisroh bro tohak yimarhu kunysn hanymomr. Nd kunysn prisroh bro yimam yo Judaroh bro yimam yo nkifra boririfhuthu tisam rifinymom. ");
INSERT INTO amp_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pitar, ror be nhowi mongkongotn fau ss hik hanymourm. Bi prisroh bro tohak yimarhu kuny kmifarn bi hanitwomre, ror be nhowi yimorn Bro Nkifrarhu temperr tohukatohyuk yimampno brbo kahtpno haunyomour. ");
INSERT INTO amp_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Jisasrhu kotkfot yakitohyuk bro prism yo Judaroh kaunserm fak hambromoum yimam. Memoum, “Wom yimam ayakkahnomn romn wom kfo wok mrokfom htaruhatmm Jisasr wasrahnomr,” to nhai, wany sitamomm. Rroh mrokfom nndo nndo pthamomm. ");
INSERT INTO amp_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Yimam be yuwi furahato pthamoa mrokfom, womroh mrokfom nndo yimoum, womrohm nndo. ");
INSERT INTO amp_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Wommn kfo wok fura memom, ");
INSERT INTO amp_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“O nomn wanymonom kfo memor, ‘Bro Nkifrarhu temperr yak tasohruhoyanrn tfit husfirpa yiharpa tfit kasinyaruhanr. Kasinya thoft nhai yima tire hingrnaruhatr.’” ");
INSERT INTO amp_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","To nhai, nd nd mrokfom rom pthayukm nhai be rpa mrokfo yuhat ptha hikrmomm. Womm nndo ptha-moum, womm, rom nndo pthamoum. ");
INSERT INTO amp_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Jisasr nd yimam pthamoa mrokfom wanymoahat nhai kfo wokrmorm. Ndnettn prisroh bro tohak yimar sinyahato Jisasr kfo ttiwon memorr, “Tamohmpno ndar rom kfiwa mrokfefm be rhuhato wanukanm? Waptha!” ");
INSERT INTO amp_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Jisasr nhai ptharmor. Tfit wompam kfo ttiwonmorr, “Ni asone nda bbinysofthu yimaroh minrfa htiyakyuk yima Kraisn Bro Nkifrar nd kfo tkrurafmor? Ni nd Tunga Nkifrarhu Yon mife?” ");
INSERT INTO amp_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jisasr wasinyahato kfo memor, “Na to tawom nda. Htirahkoma na, Bro Najoma, tfit bro hta nngrajohet Nkifrarhu tirmifko rhuhato gribpamn hawihnerahmr.” ");
INSERT INTO amp_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jisasr inji kfomotr prisroh bro tohak yimar inji wanyhato rorhu yarim ruhakyuk hmbreshat teh dborfamort. Teh dborfahato kfo memor, “Mirahko tfit wom yimam anakukahnomn nda yimarhu nefm ania apthanom. ");
INSERT INTO amp_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Bi wanukomr kfo yamuhat, ‘Na Bro Nkifraya.’ To finji dukewako? Ndar yimare finji naruhanomr?” Tfit nd kot tohyuk yimam kfo memom, “Nd yimar bi mrokfeter anohtwar.” ");
INSERT INTO amp_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Be inji kfonihato tuha kuninfar bokuninfar thumomr. Nyingatikt rmonthaye kitasiftahato tire frsrfa bosrfamoumr. Frsrfa hanyhato kfo ttiwon memoumr, “Nd ni frsrfiwa yimame frohem?” ");
INSERT INTO amp_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pitar kuny kmifarn kah haunyo hasetrn bro prisrhu wom hingrnayuk mett mhtimotr. ");
INSERT INTO amp_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Mhtihato kfo memotr, “Ni to aso womenn Nasaret thof Jisasrpno tohnho htfasmoa.” ");
INSERT INTO amp_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Pitar sinyahato kfo namhi memor, “Bare, nann yari yutewun. Na nhai tawisafkahanr.” Pitar inji kfoni hanyhato kmifathu getkfotn yihom tohmor. Ndha yihom toh hanymor krir nakumor. ");
INSERT INTO amp_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Toh hasetrn tfit nd bro prisrpno hingrnamoa mett ndha yihom htimotr. Yihom htihato nd brbo toh nafif htfasmo yimam kfo memotm, “Asor womenr Jisasrpno nd toh htfasmoar.” ");
INSERT INTO amp_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Pitar tfit wompam kfo namhimor. Kfo namhimotr nd toh nafif htfasmo yimam toh hanyhato kfo memomr, “Bare, ni aso rroh womenn. Ni Galili thofe.” ");
INSERT INTO amp_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pitar tfit wasinyahato kfo memor, “Na tu be kfo mif mifwanko, na nhai mif tawisafkahanr nd niko kfiwa yimar. Na kfo furewane Bro Nkifrar yak tutfarahra.” ");
INSERT INTO amp_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Inji kfo hanymore, ee tfit wompam krir nakumor. Krirhu naku tngtpno Pitarhu yimbhindangm ndnatn tuppomomr. Tuppohato yima yuhur tfit niamotrr tfit dukamort Jisasr kfomo mrokfot. Kfo memor, “Hrek yifungnano krirhu husyuk naku tngt tafi wany juha, husfirpa kfo namhit kfo namhi kangnm, ‘Na nhai tawisafkahanr Jisasr.’” Nd mrokfot dukakhato tuha rim nur kaugomor. ");
INSERT INTO amp_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Dbha ksfutn prisroh bro yimami Judaroh bro yimam, yo nkifrar boririfhuthu tisam, yo wom kaunser bugam rhu rifinyhato Jisasrhu kotim yuhat napthamom. Napthahato memom, “Pailatrhu tirtn htarahnomr.” Mrokfot nayak nhtamomtn mti baklain tofe kimomr. Kiyakhato Pailatrpno hanymomr. ");
INSERT INTO amp_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pailatrpno mtohmotr kfo ttiwon memorr, “Nine Judaroh kinge?” Jisasr memor, “Uwa. Mrokfot to bi kfo twanhiwunt.” ");
INSERT INTO amp_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Prisroh bro yimam ritohhato wom kfo wok mrokfom tumomm. ");
INSERT INTO amp_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pailatr kfo memorr, “Bare, ni wanuknm nd yimam ninhu yufatpno mhfnahniwa mrokfom? Tamohmpno ndar kfo wok bowokwa mrokfom tawo kfo wok duha yitanm?” ");
INSERT INTO amp_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Jisasr nhai wom mrokfom ptharmor. Pailatr inji htitihato duka nhi memor, “Arr tamohtet yimarn nhai kfo wokkahrm?” ");
INSERT INTO amp_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pasofa burwa yiharn kalabus tohyuk wom yimar Judiaroh gafanar kak thu hnamourr. Tu kmi thofmn fitoh yimar yibonwom yak tuhafoneft, yufat yutamoatm, nd yimar kak thumour. ");
INSERT INTO amp_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nd kalabus htamo yimam gafmanrpno wom yahrt rhumott wom yimam nambur tonehato yima wasmom. To nd yimam kalabus htamomm. Nd yimaroh wom yimarhu yufat Barabasr. ");
INSERT INTO amp_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nd Pasofakfot yi rifinyuk yimam yi rifiny bugahato Pailatr kfo memomr, “Ni tu Pasofa yiha na hakuta kanjo hrek inji wana.” ");
INSERT INTO amp_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pailatr mtohnihato ttiwon memorm, “To finji dukewako? Nda Judaroh kingr kangko ayak tuhafoya?” ");
INSERT INTO amp_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Jisasr be prisroh bro yimam kfo wok furahato kalabus htamomr. Ndnettn Pailatr ndhtet kfo ttiwon mrokfot htamort. ");
INSERT INTO amp_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Prisroh bro yimam bi kmi thofm kfaf hany memoumm, “Wakfo naku wameko, ‘Pailatr Barabasr ayak hfhanafor.’” Be nd bro prisroh kfomo yuhat kfo hikmom. ");
INSERT INTO amp_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pailatr wanyhato ttiwon memorm, “To nd niko kfo yamuka Judaroh kingr, nd yimare finji naruhoyanr?” ");
INSERT INTO amp_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nd yima rifhur tohmor wanfak wanfak memom, “Bgre misn wakihegirkomr.” ");
INSERT INTO amp_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pailatr memor, “To tamohmpno? Finji namotr inji naruhoyanr?” Tfit mrhuni mrhuni memom, “Bgre misn wakihegirkomr.” ");
INSERT INTO amp_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Be Pailatr memor, “Rroh yima yuhum ayak marnyayanm.” Ndnatn Barabasr yak tuhafmorrn tfit Jisasr yakhato soldiaroh tirm htamorr. Memor, “Romn wife wife tabotakhato bgre misn kihegirrahmr.” ");
INSERT INTO amp_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Soldiam Jisasr yaknimomrn hanymomr mrokfo yakitohyuk tkitrn. Nd tkitr hanyhato soldia bugam yi rifiny bugamom. ");
INSERT INTO amp_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ror hatohmo hmbresham fak rhoh bugamomrn tfit kku kkorpa kanjo fnhuyet rmonthar thu kasimomr. Yo soldiam huhra mtitoft yakmomtn kingroh mfham hatohwa yabisoht kanjo yakkemomtn mfhatn wathu hamsismomr. ");
INSERT INTO amp_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Yo yon mumenm kanjo wukfo tfar botfar memoumr, “Woi, Judaroh kingr.” ");
INSERT INTO amp_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Inji kfo tfar botfarmoamr yo kuninfar thumoumr. Yo tirt yakitohyuk mis dhemot, ndt tfit yak hutfakmoamr mfhapako warbigmoumr. ");
INSERT INTO amp_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nd kfo tfar botfar tonemomrn yo tfit nd kku kkorpa kanjo fnhuyet rmonthar yakta thumomrn tfit turhu hmbresha mifm hmbremomr. Hmbrenimomrn hanymomr bgre mis tuhegiryuk tkittn. ");
INSERT INTO amp_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kmi rim fnahnitm htiyakmomr wom yimar. Nd yimarhu yufat Saimonr, Sairini thofr. Aleksanda Rufusrofhu yifemer. Nd yima Saimonr memor, “Taunko aiya.” Soldiam ror yakmomn nd Jisasr tita hanymo bgre mis rorn tfit wathu titafmom. Rorn tita hanymort. ");
INSERT INTO amp_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Jisasr soldiam yakni hanymohat hanymomr wom tkitt kutewumt Golgota. (Kfe sfiohniyet yima mfham kanjo nd tkitt rhumoatt futamoumt yima mfha tpit.) ");
INSERT INTO amp_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Memom wom marasinm wainpampno bi rpat yak tahmor hmbriyetm Jisasr ahikahtnomr yeruharn nd frtekr botkermo tkitm frifrarahmr. To nhai. Kfo kurmor. Nhai yak yarmorm. ");
INSERT INTO amp_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Soldiam Jisasr yura bgre misn kihegirnihato yo tfit rorhu hmbresham yakhato pirai satumomm. ");
INSERT INTO amp_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Dbha 9 kilok tuhegirmomr. ");
INSERT INTO amp_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Wom mrokfo nmbuhat plan mkutn wandfakmomtn yura mfhatpno frdbkafmomtko. Nd mrokfot rom wandfakhato htamot kfo memot, “Judaroh Kingr.” ");
INSERT INTO amp_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Jisasr tuhegirmo tkittn hus rikoh yimaf mano mano tuhegirmomf. Womr tirmifko hirmor, womr kindonko hirmor. ");
INSERT INTO amp_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Jisasr hegirmo bgre mis tu yihota yuhat tohettn rim fnahni mfnahniyuk yimam rim grha wase bowasenihato yihom kfo tfarnyi mkfo tfarnyamoumr. Kfo memoumr, “Ni kfo mayete, ‘Bro Nkifrarhu temperr yak tasohhato tfit husfirpa yiharpa tfit kasinyahato hingrnaruhant.’ Ni inji kfet yimaye. ");
INSERT INTO amp_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","To btn wamifnahnekahtn ahtinomn.” ");
INSERT INTO amp_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Nd prisroh bro yimam yo nkifra boririfhuthu tisam, rom rpat inji kfo tfar memomr, “Ndar yimar ror toh hingrna hnamohat bok met yindarim rorn fak marnya hnamorm. Asomift to nhai tur mifnahnekahtr htikahnomr. ");
INSERT INTO amp_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nd Isrerroh kingrn Bro Nkifrar kfo tkruraf thombat nda bbinysofthu yimaroh nrfa htiyakneft, afo tur amifnahnekahtr ahtinomr. Htiruhanomn duka mirahnom tu nmoh nrfa htiyakyuk yimayer.” Nd mano mano hirmo yimaf rof nhaf kfo tfar mrokfom kfomofr. ");
INSERT INTO amp_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Dany marrn marrhu nukeft be rim nohnimot. Kantri bugat be yambontift rhumom. Wuroh 3 kilok krif marr tfit niamor. ");
INSERT INTO amp_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tri kilok kanjo marr toh hanymor Jisasr tau nakuyafmor, “Eli, Eli, lema sabaktani?” Nd mrokfothu mrokfo yimbu yuhat inji kfiwut, “Nkifraye, Nkifraye, tamohmpno bi frtrohwona?” ");
INSERT INTO amp_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Inji kfo nakumotr brbo tohyuk yimam wanyaf hanyhato kfo memom, “Nd yimar Iraijar nakutr.” ");
INSERT INTO amp_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Wom yimar toni hanyhato spans yakmorn wainpamn tayifakhato miyeftn htahato memor, Jisasr hikahta bupam ndtn tmasakrahr. Bupam hehato kfo memor, “Afo htiyaf hanyrahnom, Iraijar naku kfihat Iraijar finji naruharr?” ");
INSERT INTO amp_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Be wuroht tau nakuyafmorn be mfaknimor. ");
INSERT INTO amp_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Yimar myakni hanymo fijo nd bro rmonthar temperrhu tu Nngrajoh Hnaru Gnanhehr gna rafomor be buha mifn rmonthar yoh nmbrmorn mano mano rim rhu mrhumor. Yurak wuyoh nmbrakmorn miyoh nmbr witanihato mano mano rim hir mhirmor. ");
INSERT INTO amp_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jisasrpno brbo tohmo amiroh keptenr Jisas nohmo yuhat htihato tuha mfha tha duhatr rhumor. Memor, “Dajohmn! To finji tfit kforuhanom? Ndar yimar tu Bro Nkifrarhu Yon mifer.” ");
INSERT INTO amp_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Tom wom metm be inji wuri kkof tohhato hti hasomoum. Taun Makdala efkot Mariat, Jemsri Josefrofhu mmem Mariat yo Saromet, nd nd metm hti hasomoum. ");
INSERT INTO amp_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Nd yute metmn Jisasr Galilit tohmohat romn uhik ahik htfasmoamrn tamoh tamohm romn hiyaf hanymoumr. Yo wom metm rpatn Jisasr Jerusalemko yimohat hik hanymomr. ");
INSERT INTO amp_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Judaroh taun Arimateathu wom yimar tohmour. Rorhu yufat Josefr. Juda kaunserkfot rorn nd kaunserkfot hingrna tohnhomourm. Bok met yindarim rorhu nefm hifa hti wofnmoumm. Rorhu dukeft duka memour, “Bro Nkifrarhu kingdomkfot afo nanhu nyingaye afo htiruha!” Nd dukeftpno tohmour. Nd Fraide yihar, bi tu Judaroh bro rhu krna Sabat yihar bi rhu yibon hanymomr. Sarere yihar nd rhu krna yihar rhumoumr. Ndnetrn krifnano Jisasr bi nohetrn nhai wofnrmor Jisasrhu tfkhat wom rhukfot. Pailatrpno yimorn mtohhato ttiwonmor Jisasrhu thatipthu yakni yopneft. Nhai yakrmi hanyhato yi mttiwonrmorr. ");
INSERT INTO amp_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailatr Jisasrhu noh mrokfot wanyhato tuha mrokfo duhatr rhumor. Be yudbat turhu keptenr nakumorr. Memor, “Afo tu keptenrpno wany marnyaruha Jisasrhu noh mrokfot.” ");
INSERT INTO amp_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pailatr keptenrpno wany sungunahato ee Josefr kfo fakiowafmorr Jisasrhu thatipthu yaknineft. ");
INSERT INTO amp_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josefr Pailatrhu tngt wany marnya tanyhato yimorn nfri ganyom rmonthar wiknakmor. Nd nfri rmonthar yak nyingt htatahato Jisasr bgre miyetr wuyak kasuhakmorrn ganyom rmontharn wahtahato rir hmbremorr. Rir hmbreyaknihato hanymorr. Hanyhato tahi muhtn rihtamorr. Nd tahi muhtn htamorrn tahis yakhato tahishu muht hta tittafmort. ");
INSERT INTO amp_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Makdala efkot Mariati Josefrhu mmem Mariat tohhato hti hikmom Jisasrhu thatipt htamo tkitt. ");
INSERT INTO amp_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Nd rhu krna Sabat yihar rhuni bugahato Makdala efkot Mariat yo Jems Saromerofhu mmem Mariat welpam wiknakhato memof, “Hanyhato Jisasrhu thatipt gbrorna wunarahnonr.” ");
INSERT INTO amp_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sande yiha bi dbha ksfutn sinyanihato yimom nd Jisasr rihtamo tahi muht. ");
INSERT INTO amp_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Yau hanyhato tfit tuf rinnakfo nakfo hany memouf, “Nd tahi muht frtasif tanymo tahise frohmn yak rihtaf nuhafruhamno?” ");
INSERT INTO amp_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Inji nnakfonihato asha mtohhato htimoft nd yonmari tahis muht frkih tanymot nhai wom rhurmot. ");
INSERT INTO amp_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Be sfnohtn be yauyaknihato fau fknenimof. Yiro rim tohhato asha htimofr wom yima damiagr yok thar hmbreyetr tirmifko rhu hasomor. Be tuha mrokfo duha tohmof. ");
INSERT INTO amp_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nd yima damiagr kfo memorf, “Mirahfn afohtasno. Nifn ka nd bgre mis kihegirmo Nasaret thof Jisasrhu yau hafott niefn. Nd yimar bi sinyani yifir. Ndart ror yarim htamo tkitt, bi sfnoh tkit furayet. ");
INSERT INTO amp_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Waikahfnn turpno yau htfasmoa yimam yo Pitar wakfo wamitwafnm, Jisasr bi sinyanihato bi Galiliko mtoh gari hanitrm. Tur kfomo yuhatn Galiliko ndko amhtitwamr.” ");
INSERT INTO amp_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nd yima damiagr pthamohat, be bro yakrme rifhurpno tohhato wanymoufr. Be nd yakrme rifhurpno fnahnihato yimof. Yimohat nhai wom yimar kfo marimofr, “No inji htitawono.” ");
INSERT INTO amp_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jisasr Sande yihar dbha ksfut sinyamor. Sinyanimohat barkoft Makdala efkot Mariatpno myak nriyafnimotr htiyafmotr. Nd met Mariatn Jisasr yima nfrir tohmohat 7-pela kmi yarhm fak thumort. ");
INSERT INTO amp_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mariatn hti switafhato rotn yihato Jisasrpno yau htfasmoa yimam nur dungunangu hasetmn mkfo nuhasmotm. ");
INSERT INTO amp_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Kfo memotm, “Jisasr bi sinyer. Na bi tuka htiyefiyanr.” Nd nur dungunangu hasoyuk yimam nhai wany yakiormomt. Rom memom, ka yuwi furewut. ");
INSERT INTO amp_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kto Jisasrhu wom hus disaiperf tuha taunt sinya tanyhato yimof. Buha yihotatn Jisasr htiyafmofr. Rorhu ruheft nndo tfit htimofr. ");
INSERT INTO amp_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Be rof inji htiyafhato womm yi kfo pthamofm. Womm rof kfoyuk mrokfom wanymohat nhai wany yakiormomf. Memom, ka kfo furewuf. ");
INSERT INTO amp_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kto wuroht tu Jisasrhu 11-pela disaiperm nuwa ye hasetmn mifnahmotr htimomr. Yihato kfo huttmorm. Ror htiyafomoa yimam kfomoahat nhai wany yakiormoam. Memom, ka be kfo furewum. Ndnatn kfo huttmorm. ");
INSERT INTO amp_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Kfo memorm, “Nikomn ndar bbinysofthu kmi kmim nanhu mrokfot wakfo nuhashi habri bugatwakomm. ");
INSERT INTO amp_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Waptha habrikahkomn fitoh yimam wany yakiohato baftais kak hanitm, nd yimam Bro Nkifrarhu tirtn rhurahm. Yimam nhai wany yakiokahm nd yimam be bro kotkfot tohrahm. ");
INSERT INTO amp_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nanhu mrokfom wany yakio hanyruha yimam wom bbukeft Bro Nkifrar hi hanyrahrm. Nanhu yufatpno yarhm yak thurahmm. Yo wom nndoh yarmumam be ptha furakni hakurahmm. ");
INSERT INTO amp_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Yima waset nandom nehum tire yak hakurahmm. Foret yeshrim yerahmm be nhai finji naruhatm. Be fipa duhatm rhu hakurahm. Dbohnet yimam rom tir htarahmm be marnyani hakurahm. Nd nd nefm yimam htiruhamn mirahm, tu Bro Nkifrarhu bbukeftpno hingrnewum.” ");
INSERT INTO amp_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Bro Nungothet Jisasr nd mrokfom kfo buganihato be Bro Nkifrar yakhato hamuhmorr hefenko. Hamuhmorrn turhu bro bbukeft yorhwa tirmifko fak htamorr. ");
INSERT INTO amp_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Be Jisasrhu disaiperm kmi kmim yi htfashato Jisasrhu mrokfom kfo ptha habrimomm. Bro Nungothetr tohnho-moatrm rom pthamoa mrokfem fipetm rhumoum. Wom wom mirakerkfom rpat hingrna htfasmoum. Ndnatn rom pthayuk mrokfom wany yakiomoumm. ");
INSERT INTO amp_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","O Tiofilus, Jisasrpno rhu hawihnamo nefm bok yimam htimomm. Rom htihato pthamomm. Pthamotmm wom yimam rompno wanyak hanyhato wandfa hanymomm nd Jisasrhu tndh mrokfom. ");
INSERT INTO amp_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ndnatn na to inji kanga ni Tiofilusnpno awandfakahann, akfo nuhas hik bohik marnyann nd Jisasrhu tndht rhumo nefm. Nd mrokfom kanga akfo nuhasann. Bi tuka nd tu hti hiket yimampno rhuhato wany hik marnyamoyanmn ndnatn kanga awandfa nuhasann. ");
INSERT INTO amp_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Tamoh mrokfom ni bingot wanyafmom, nda na wandfayuk mrokfefm htiruhann, mirahn, “Dajohmn, nd na wanyafmo mrokfot tu mrokfot wanyafma.” ");
INSERT INTO amp_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Herotr, Judiaroh kingr tohmo yiharn wom yimar tohmor. Rorhu yufat Sekaraiar. Rorn bro Nkifrarhu temperrhu hingrnefm kakitohmourm. Nd temperr tohyuk yimar kutamoumr prisr. Sekaraiar Abiya kuny shofer. Bingot rorhu nkifra Abiyar nd pris hingrneft mfakitoh fnahmort. Sekariar Abiya kuny shofer. Rorhu metthu yufat Elisabet. Rot nhaf inji buga. Rothu nkifram nd pris hingrneft mfakitoh fnahmomt. Rot Eron frikef yuhatn niamot. ");
INSERT INTO amp_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sawoh sawohfhu toh nmbuhat hifa tohmoatf, Bro Nkifrar hifa hti yindhormorf. Boririfhu mrokfom rof hifa kak hik marnya-moufm. ");
INSERT INTO amp_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Nd sawohf tohmoahat be inji yon duhatf tohmouf. Mett nhai yon hiyaurmoat. Sawoh sawohf bi tabo buga hanymof. ");
INSERT INTO amp_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Wom yiha Abiya frikeft tum rhuhato memom, “Wom yimar ayak htanom temperrhu fknihato tarioh mtha inji nayukr.” Ndnatn yimaroh yufa yak nuhasyuk neft namom. Nd neft nahato nd neftn Sekaraiarhu yufat fak nuhasmotm Bro Nkifrarhu temperr yihato tarioh mthayukr. Bingot bi ndhtet neft na hnamoum. To be nd nef yuhatn fak hikmom. Bok yimam nd temperr hingrnamoum. Wommn womhtet hingrnefm hingrnamoum. Tfit wommn womhtet hingrnefm hingrnamoum. ");
INSERT INTO amp_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","To be Sekaraiar temperr fknenihato nd miroh fipam tarioh mthamohat bok met yindarim briahako rhuhato Nkifrarpnonko kfo bruttnamoum. ");
INSERT INTO amp_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Nd tarioh mthayuk tkitt toh hasetrn Bro Nkifrarhu mounmotr niamorn, nd tarioh mthayuk tkitt tirmifko mitohmor. ");
INSERT INTO amp_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Be wom Sekaraiar inji htihato yafotha duhatr rhumor. ");
INSERT INTO amp_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Nd mounmotr sinyahato kfo memor, “Sekaraia, ni mirahn aduka yanhoya. Ni kfo bruttnamohat bi wanymoyann. Nd ninhu met Elisabett, be yonr hiyauhirahtn. Yon yindarir hiyauhiruhattn, yo yufat wayutatwanr Jonr. Bro Nkifrar rorn bro yufat htarahr. ");
INSERT INTO amp_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ni inji htiruhann, ninhu yima yuhur be yifa marnya-ruharn, yindhorrahrn. Bok met yindarim ror htihato be yindhorrahm. ");
INSERT INTO amp_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Rorn Bro Nkifrar bro yufat hirahrr. Nhai wain bupami yima thu hamumet bupam yeruhatr. Yuhre mmemthu yatit ruhetrn, bi nd Bro Nkifrarhu Yafothat thu nawohrahtr. ");
INSERT INTO amp_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Rorn nd Isrer yon kunys tfit yakruharm, tfit turoh Nkifra Yawerpno yak htarahrm. ");
INSERT INTO amp_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Rorn nd Iraijar hatohmo yafothat mthu nhombraraht. Ror bi Brorhu nyinga yuhat bi tohak hanyruhatr, nitohfi nitohfim tfit niak marnya hakurahm. Yifemrom yak marnya hakurahmm yinemrom. Rorn nd hanyjbornetroh yima yuhum tfit yak marnyarahrm hifa duka hik marnyetrohm kanjo. Bi rorn met yindariroh yima yuhum bi yak marnya haso hanyruhatrm, ee btn Bror nierahr.” ");
INSERT INTO amp_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Sekaraiar sinyahato mounmotr kfo memorr, “Nd ni kfiwa mrokfot mduka nhiyaktitwant. Sawoh sawohno ndu bi tabou bugayetno, finji wom finji rhuruhano? Wom nefm yak nuhasrahnno, ee duka mirahno awi ndu mrokfot tu kfomif kfot kfomor.” ");
INSERT INTO amp_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Tawo mounmotr kfo memor, “Na Gabriera. Na Bro Nkifrarpno brbo tohwa. Rorn kfo tkrurefitra, niya ninhu kfot. Tu hifa dborioh kfo nuhas mrokfot hnahuyann. ");
INSERT INTO amp_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Wawanyn, na kfoyuk mrokfom nhai wany yakiorfonm. Ndnatn be tng mmkn rhurahn. Be nhai ptharuhatn. Nd na kfoyuk yonr bi fnurnire, ee btn tng pthetn rhurahn.” ");
INSERT INTO amp_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nd briahako rhu hasoyuk yimam gariti garitihato duka memoum, “Barenko bingot yiyuk yimare to tamohmn riyak hatohwar?” ");
INSERT INTO amp_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Ktopa kto be tng mmkr fnahnayetrn, hti yak hanymomr. Nhai ptharmor. Be inji tng mmkr fnahnehato be tirrpaye fak nuhasmourm tamoh tamohm. Be yimam inji htiyakhato duka memom, “Ka hwe twehnano Bro Nkifrar hti hanirr. Ndnatn ka mrokfo yafothar fekrr.” ");
INSERT INTO amp_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Rorhu nd temperrhu hingrna yiham hingrna hanymorn, hingrna tmbhonihato be tfit turhu kmiko yimor. ");
INSERT INTO amp_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kto rorhu met Elisabett yon fanett rhumot. Tut inji htihato afo tir yuhut yamm kamongmot. Kfo memot, ");
INSERT INTO amp_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Nanhu yon hiyau duhathu yimtna nmbuhat Bror hifa wahtihato yuhuwafmora.” ");
INSERT INTO amp_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabetthu yon fanet rhu nmbuhat mounmotr kfo nuhasnimortn, dfik yamm tohnihato 6-yuk yamtpno Bro Nkifrar tfit mounmot Gabrierr kfo tkrurafmorr Galiliko yorhwa taun Nasarethu yinyeft. ");
INSERT INTO amp_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nd taunt yorhwa wom met tmahthu yufatpno yimor. Nd met tmaht bi Defit frikef yuhat niayuk yima Josefrpno kfo nanf hanymomt. Nd met tmahthu yufat Mariat. ");
INSERT INTO amp_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nd mounmotr rotpno yihato mkfo yindhoraknihato kfo memort, “O bar mete, nine to? O hifa mete, Brorko hifa hti yindhorworn.” ");
INSERT INTO amp_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mounmotr inji mkfo yindhoraknimotr, tfit Mariat duka kinyaknihato memot, “Nane finji kfiwura? Hrekrpa ndhtet kfo yindhor mrokfot wanuka.” ");
INSERT INTO amp_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Tfit mounmotrn kfo memort, “Maria, ni mirahn finji ariduka adukaya. Bro Nkifrar ninn hifa hti yindhorwor. ");
INSERT INTO amp_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Wanukn, yon fanetn rhuruhann, yonr hiyaurahn. Nd yonrhu yufat wayutatwanr Jisasr. ");
INSERT INTO amp_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nd yonr sinya thombat be tu bro yufet yonr tohrahr. Yimam yuta hakurahmr ‘Tu yura myorhekwa Nkifrarhu Yonr.’ Turhu nkidom Defitr hatohmo bro yufat kindo tfit nd yonr Bro Nkifrar nd bro yufat hirahr. ");
INSERT INTO amp_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nd Jekof frikeft yutiwa Isrerm, rorn tohukatohrahrm. Rorn toh yukatoh hanyrahrm yiha yiham.” ");
INSERT INTO amp_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mariat inji wanyaf hanyhato kfo memot, “Na ndhtet ram duhat meta, to finji kanjone yon faneta rhurhoya?” ");
INSERT INTO amp_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Tfit mounmotr kfo memort, “Bro Nkifrarhu Yafothar mithu nawohruharn, tu myorhekwarhu bbukeftpno toh hnkokn hmbriruharn, nd yonr thu hmbrirahrr. Bro Nkifrar thu hmbri-ruhatrr, to be ndnatn nd yonr yutarahmr Bro Nkifrarhu Yonr. ");
INSERT INTO amp_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Wawanyn, ninhu tangiyem Elisabett nhai yon hiyaurmoat, futamoumt nmbit. Arihat ar bi tabou bugayett, to nhai, to bi tfit yon fanetet. Bi 6-pela yamm yimom. ");
INSERT INTO amp_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Nhai wom tamoh nefthu finji naneft Bro Nkifrar mduka nhiyakkfot.” ");
INSERT INTO amp_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mariat inji wanyhato tawo kfo memotr, “Wawanyn, na Brorhu hingrnefroh hingrnayuk meta. Kangr nd ror kfiwa tng yuhatn finji anaya, na nhai mrokfom.” Be Mariat inji kfomott, nd mounmotr htanymortn yimor. ");
INSERT INTO amp_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mariat mounmotr htiyafohato kto rorhu mongkorn rot bmbri Judako yimot. Kminysofm muh wohne fnahhato mifnahmot nd Sekaraia sawohf rhumo kmitn. ");
INSERT INTO amp_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Mifnahhato yimot Sekaraia sawohf rhumo kunysn. Kunys fkneni-hato Elisabett rhu hasettn rim kfo yindhoraknimott. ");
INSERT INTO amp_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Rim kfo yindhoraknimott, nd Elisabetthu yatit rhuyuk yonr ka nd yindhor mrokfot rim pthaknimott, ror riyindhorhato ridbuhatokmor yiro yatitn. Bro Nkifrarhu Yafothar yawihnamorn, Elisabettn mithu nawohmor. ");
INSERT INTO amp_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Mithu nhombramotrt, yimat bro yindhor yima yuhur yakhato Mariat masat kfo ptha memott, “Metroh mkukort be ni Mariann Bro Nkifrar yak marnya bomarnyarahr. Yo nd yatit rhuyuk yonr, ror inji buga yak marnyarahrr. Rpat nimehetfn yak marnyarahrfn. ");
INSERT INTO amp_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Na ndhtet met furapaya, to tamohmpno ar Brorhu mmemt tfit nanpno wanies? ");
INSERT INTO amp_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Wawanyn, Maria, na ninhu yarim kfo yindhorakna tngt wanyhato nanhu yatit rhuyuk yonr, ror nd kfo yindhor tngt wanyhato ror rpat riyindhorhato yiro yatitn ridbuhatok yindhorrio.” ");
INSERT INTO amp_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Elisabett sinyahato Mariat kfo memott, “Maria, Bror mikfo tanyuk mrokfom ni hifa wany yakiowonm. Ndnatn yak marnya bomarnyarahrn.” ");
INSERT INTO amp_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mariat wanyhato kfo memot, “Nanhu yima yuhur Brorparnko yindhorwor. ");
INSERT INTO amp_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Nanhu yima yuhur na minrfa htiyekwa Nkifrarpar yindhorwor. ");
INSERT INTO amp_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Na rorhu hingrnefm hingrniwa met furapaya. Nhai marimor met furayet. Nhai. Nanhu rhu nmbuhat htihato hti yuhuwafmora. Arihami kto bok met yindarim na nda Bro Nkifrar yak marnyewa nmbuhat htiruhamn, kfo yindhorrahmt nanhu yufat. ");
INSERT INTO amp_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Bro bbuka nanyjaret Nkifrar be tu hifa fak htamora. Ndnatn nanhu yima yuhurio rorhu yufat be inji tahirhut rhuraht. ");
INSERT INTO amp_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Arihat tohwa yimami kto tohruha yimam be rorparhu duka yanhowefrpar tohhato rorhu yinhit tohruhamn, rorhu yuhuwafneft be romn rhuraht. ");
INSERT INTO amp_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nd yimam turoh yufam yura yura htamoam, rorhu bbuka nanyjaret tirm thu yukehato bi fak thumorm. ");
INSERT INTO amp_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nd king yufam tohet yimam bi wuyak thurakmotrm, tfit nd yufapa duha yimam bi mfrfnahnimom. ");
INSERT INTO amp_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Yatinohetmn nd hifa hifa shrm bi thu rmonhemor, tfit nd bok wusketm brioh hti marsisafomorm. Nhai wom tamohm hiyafhato yakitohakrmom. ");
INSERT INTO amp_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","To be ndnettn nd kfo tahi mrokfot bi ruhettn niamor. Niahato turhu hingrna yimam, kutewumm Isrerm, yuhuwafmorm. ");
INSERT INTO amp_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Bi bingot Bro Nkifrar Abrahamrpno rikfak memor, ‘Rorhu mongko sinyahato toh hanyuk yimam yiha yiham yuhuwaf hakuruhanm.’” ");
INSERT INTO amp_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariat husfirpa yamm Elisabettpno toh tanyhato tfit tuthu kmiko yimot. ");
INSERT INTO amp_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabetthu yon fant hatoh hanymott, yon hiyau yiharn yon yindarir hiyaumot. ");
INSERT INTO amp_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Rothu yifa mndarm inji htihato kfo yindhorhato kfo memom, “Bro Nkifrar hifa hti yuhuwafmort.” ");
INSERT INTO amp_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Nd yonr mharhuhato namba 8 dei kfotn yonrhu tha puk thut niamom. Tha puk thunihato yufat memom, “Yifem Sekaraiarhu yufatn tfit hmbrenomr.” ");
INSERT INTO amp_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Tfit tu yonrhu mmemtn warhuhato kfo memot, “Mirahko wom yufat ayutanomr. Jon yufatn wayutatwakomr.” ");
INSERT INTO amp_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Tfit rom kfo memomt, “Nd ni kfiwa Jon yufat nhai ninhu tangim yuta hnarmomt nd yufat.” ");
INSERT INTO amp_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Be inji nna kfonihato memom, “Ka tu yon yifemrn yonrhu yufat yuta nuhasrahrnom.” Ror tng mmkrn btn tire yak nuhashato memoumr, “Yon yufat wayuta nuhasnnom.” ");
INSERT INTO amp_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sekariar memorm, “Slet mkut wahne hikma.” Slet mkut hnamotmt, Jon yufat wandfa nuhasmorm. Wom yimam inji htihato memom, “Mamai! Ndart tu be womhtet neft hrekrpa htitwonom.” ");
INSERT INTO amp_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Yufat wandfani hanyhato ee tort rigrhakhato Bro Nkifrar rikfo ptha yindhor boyindhorakmor. ");
INSERT INTO amp_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Sekaraiarhu kmi thofm nd ror namo neft wahtiyafo-mohat nhai wom yafothetm rhurmom. Nd Sekaraiarpno rhumo nefthu mrokfot nhai brbo wom warhu hasormot. Judiakorhof kminysofm rhuyuk kmi bugam wany bugamomt. ");
INSERT INTO amp_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nd yonrhu mrokfom wany hanyuk yimam wanyhato bok dukefm yakmoamn, duka memoum, “Nd yonre warhoni thofte nko finji kanjohot yimar tohruhar?” Rorhu sinya nmbuhat be Bro Nkifrarhu tirmn fak hta bohtamomr. Ndnatn inji duka nhtamom. ");
INSERT INTO amp_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Be tfit nd yonrhu yifem Sekaraiar Bro Nkifrarhu Yafothar mithu nawohmotrr, Bro Nkifrarhu mrokfom pthamorm. Kfo ptha memorm, ");
INSERT INTO amp_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“O Tunga Nkifrar, arnat bi turhu yon kunys yukatohwarn, be arihatn tfit yak marnyarahrnom. ");
INSERT INTO amp_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Turhu hingrna yima Defitrhu frikef yuhathu yimar bi yak htarorn, nom be rorn minrfa htiyakrahrnom. ");
INSERT INTO amp_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Bingot bi turhu dborioh profetmpno pthamo yuhatn yak hikhato kfo tkrurafmotrr, niamor. ");
INSERT INTO amp_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Bi rompno bi kfo hta memor, ‘Nanhu yon kunys yahr kmiroh buha yorhwamn, be hti srhasiwumm. Yirhoyann, miyak htiyakruhanm.’ ");
INSERT INTO amp_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Bingot tohmo nmoh nkifram ror yuhuwafmormn, fakmorm. Bingot ror kfo tahimo mrokfot yuhre duka hanitrt. ");
INSERT INTO amp_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Bi bingot tunmoh nkifra Abrahamrpno kfo tahimo yuhatn hikwarn, kangr, ‘Aminrfa htiyakkahanm, tfit tukianhu hingrneft yak htaruhanm. ");
INSERT INTO amp_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Tukianhu hingrneft tohruhamn be nhai wom yakrmiruhatm. ");
INSERT INTO amp_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Be yiha yiham nanhu yufa yuhat tohruhamn toh marnya bomarnyarahm.’ ");
INSERT INTO amp_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ni nda yonn, kto yutarahmn yura myorhekwa Nkifrarhu profetn. Ninn Brorhu nyinga yuhat tohak hanyruhann, rorhu nia yuhat bi ninn yak hta bohta hanyrahnt. ");
INSERT INTO amp_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Bi ninn yiruhann, kfo mirahnm, ‘Bro Nkifrar nikmoh fasoh fasoh nefm yak thuhiruharko toh marnyarahko.’ ");
INSERT INTO amp_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Tunmoh Nkifrarhu yuhuwaf nmbuhatn bro nukafat hirahrnom. ");
INSERT INTO amp_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Nd yiro kspitat rirhuyukmio yo nd bro yihotar yauwam, rom nd nukafat nieruhatn, nukeft hirahtm. Nmoh yau nmbuham rorn yak htaf hanyruhatrnom, be hifa nd hifa noh hmbre yima yuhurn yaurahnom.” ");
INSERT INTO amp_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nd yonr warho hanymor, rorhu dukefm rpat yimarpno warho hikmom. Be nd yonr nd yima toh duha bbinysoft toh hanyhato be Isrerko tohyuk yima bugam hti hik bugamomr rorhu nd dborioh dukefr yo rorhu toh nmbuhat. ");
INSERT INTO amp_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nd yihamn bro toh yukatoh Sisa Ogastasr wom mrokfot hta htfasmort. Kfo memor, “Arihat inji narahnom. Romroh gafmanrhu yinhit tohyuk yimam yufam yak bugarahnomm.” ");
INSERT INTO amp_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","To be tot nd yiharn Romroh gafmanrhu yinhit tohyuk yimam yufa rihtakmom. Nd yihart Sairiniasrn Siriaroh gafmanroh mfhako rhuyuk yimar tohmor. ");
INSERT INTO amp_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ndnatn nd wom wom kmim toh hanyuk yimam tfit turoh kmi mnako yi hanymomn, yufam hta hanymom yufa htayuk bro gonborngtn. ");
INSERT INTO amp_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josefr Defit frikef yuhat niayetrn, ndnatn Galilikorhof kmi Nasaret tohetrn to be nd kmit htanymortn, tfit yimor Judiako yorhwa kmi Betlehemtn. Nd kmi Betlehemt Josefrhu nkifra Defitrhu kmitn, ndnettn to be turhu nkifra kmi mnako yimor yufa htat. ");
INSERT INTO amp_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Mariat Josefrpno yuhre kfo nanf hanyettn yon fanett rhumot. Yimohat yon fanett rpat yimof. ");
INSERT INTO amp_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Yihato bi Betlehemt mfnahetfn, Mariat fak yironamot. ");
INSERT INTO amp_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Yak yirona-hato yon yindarir hiyaumot. Nd nurmo yonr tor rot hiyaumo barkof yonr. Hiyauwakhato rmon thaye yak rir borirakhato bulmakaum yeshrim yamoa mmbrtn wakmbremotr. Yiro bro kuny yirukkort yimam rhu furkihettn, to be fohroh yeshri hwe rhu nuwa yemskamoako nurmor, to be nd bulmakaum yeshrim yamoa mmbrtn wakmbremotr. ");
INSERT INTO amp_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nd kmitn sifsifm hatoh yukatohmoa yimam wom tkittn yifung sifsifm hatoh yukatoh hasetmn, Brorhu mounmotr mifnahmorm. ");
INSERT INTO amp_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nd mounmotr mifnahhato Brorhu bro nukeft, nd mounmotr hatohmohat memom nndo bruwohmrn katiwur. Nd sifsifroh hatoh yukatohyuk yimam nukeftn yakmottm, memom, “Ayakrmanyom.” ");
INSERT INTO amp_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Tfit mounmotr inji htihato kfo memorm, “Inji ayanhowahko. Na tu hifa dborioh mrokfeft hniya. Nd mrokfot bok met yindarim wanyshoft, wany yindhorrahmt. ");
INSERT INTO amp_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Wawanyko, hrekn nikmoh hbhakyuk yonr wom mett hiyausr Defitrhu kmitn. Ndr Bro Kraiser. ");
INSERT INTO amp_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Wahti hanyswako rmonthaye rir borirakhato bulmakauroh yeshri yeyuk mmbrtn htayeter. Htitawokomre, wamitwako, ‘To tawomr asor nd nom wanu kfo nuhas mrokfothu yonr.’” ");
INSERT INTO amp_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Inji yuhre nd rpa mounmotrpno naptha hasoyetmn, asha tfit wom yonmari mounmot rifhur yura moun yuhat fawihnamom. Yawihnehato nd wom mounmotrpno naptha hasomo tkitt mirifiny hmbri yaknamom. Mirifinyaknehato miptha yindhorakna memom, ");
INSERT INTO amp_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“O yura hefenrhu tunga Nkifraye, nda bbinysofthu yimam ni hti yindhorwam wayak marnyakahtnm, yima yuhum noh hmbrerahmm.” ");
INSERT INTO amp_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nd mounmot rifhur inji naptha tanyhato tfit wayakhato yura hefenko muhmom. Nd sifsifroh tohukatohm htiyafomomm, bi kitwome, ee rom tfit tum rinakfo nakfo memom, “Barenko, Betlehemko aikahnomn, htirahnom nd Bror kfi yonr.” ");
INSERT INTO amp_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Be inji napthanihato bmbri Betlehemko yimomn, hambro hanyhato mhtimomf Josef Maria sawohf yo nd yonr bulmakauroh yeshri yeyuk tkitt wahtetrn. ");
INSERT INTO amp_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nd yonr mhtihato mkfo memom, “O, nom nda yonrhu nur nmbuhat Bro Nkifrarhu mounmotm niaromn, kfo meromnom nd yonr bi fnurr. Nom rroh tngt wany sanyhato nienom nda yonrhu htit.” ");
INSERT INTO amp_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Bok yimam nd sifsifroh tohukatohm inji kfomotm, riduka adukamom. ");
INSERT INTO amp_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mariat nd wanymo mrokfefm wanymotmn, be yima yuhurn wany hmbritamotm. Be memot, “Be afo htiyafo hanyrahnom.” ");
INSERT INTO amp_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Be nd sifsifroh tohukatohm inji hti tanyhato be tfit yindhorefrparpno yimom turohko. Nd rom htihato wanymo mrokfom turoh nyingaye hti yimbu hikmomn, be nhai wom mrokfom ptharmom. Be yindhorefrparpno yimom. ");
INSERT INTO amp_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Kto 8-pela marm rhunimomn, yonrhu that puk thunihato ee yufat nd yiharn futamomr Jisasr. Nd Jisas yufat bi mounmotrn Mariatpno niamohat yonrhu yufat bi mikfo nuhas tany memort, “Jisas yufat wayutatwanr.” ");
INSERT INTO amp_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Josef sawohf, Mosesrhu thfa mntwathu mrokfom yak hiketfn, nd yonr nurnimohat afo yuk trufnimofn, ee tfit kto Jerusalemko hanymofr nd nfri yonr Bro Nkifrarhu henyeft. ");
INSERT INTO amp_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Bi Bro Nkifrarhu thfa mntwatn bi kfo memot, “Barkof nkati yonr nuryukr, nanhu yufatn rhukfot.” To be ndnettn hanymofr Jerusalemkorn, rorhu hekfotn. ");
INSERT INTO amp_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Kandhi mthaneft nhaf inji buga, bi thfa mntwatn mrokfot bi ruhettn, memof, “Hus ganyom mmkrf o nda mtimohet rgumif kandhi mtharahnonrko.” Nd nd hingrneftn nd yonr hanymofr. ");
INSERT INTO amp_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Rom riphar yimom, nd yihart Jerusalemt tohmour wom yimar. Nd yimarhu yufat Simionr. Nd yimar be tu hifa dborioh yimar tohmour. Bro Nkifrarhu thfa mntwat kfoyuk mrokfom kak hik bugamourm. Ror tohmoahat gari haso memour, “Nko fitoh yiha nd Isrerroh minrfa htiyakyuk yimar nieruhar?” Bro Nkifrarhu Yafothat toh natwihmoutr Simionr. ");
INSERT INTO amp_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Nd Yafothatn bi kfo memotr, “Ni afo tafi noh duhatnn, htirahnr nd Bror kfomo yimaroh minfra htiyakyukr nia thombat.” ");
INSERT INTO amp_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","To Josef Mariarof Mosesrhu thfa mntwat yakitohetfn, nd yon Jisasr bi Bro Nkifrarhu temperrn hany hanymofr, Bro Nkifrarhu henyeftn. Josef riphar bi yau hanyetmn Simionr Bro Nkifrar thu yuhurmorr rmonko yinyeft. ");
INSERT INTO amp_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simionr be yihato temperr rim fnahnihato nd riphar rhu hasetmn, rim htimorm. Rim htihato nd yon Jisasr fakmorr. Yakitoh hanyhato Bro Nkifrarpno wukfo yindhor memor, ");
INSERT INTO amp_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“O, Broye, nd ni nanpno kfomo mrokfot asor nd yonr bi tukanhu nyingaye bi htitanr. Be na arihat nohneft nhai mrokfom. ");
INSERT INTO amp_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Na bi tukanhu nyingaye bi htitant ni minrfa htiyakruha nmbuhat. ");
INSERT INTO amp_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Kto nda bbinysof thofm hti bugarahmt. ");
INSERT INTO amp_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Bro Nkifrar Isrerm minrfa htiyakruha nmbuhat, nd ror hnaruha nukeftn, nd wom tangishofm htiruhamn, nd nukeftn yak dukarahtm. Ndnatn tfit ninhu yon kunys, rorn nd nukeft hneruhatrt, rom bro nukeft yakruhattm, ndnatn bro yindhoreft yakrahmt.” ");
INSERT INTO amp_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jisasrhu yifammaf inji wanyhato rof tfit duka nhtahato kfo memof, “Nda Simionr kfiwa mrokfothu mna yuhate, nko finji rhuruhat?” Tfit rof sawo inji fak nhtamouft. ");
INSERT INTO amp_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Be Simionr Nkifrarhu yufatpno yak wus bowusnimormn, Mariat kfo memort, “Wawanyn, Bro Nkifrar ror htafmor nmoh minrfa htiyakyukr. Bok Isrerm rorhu mrokfefm hanyjbornahato suhrahm. Womm nd rorhu mrokfom yak hikyukm, rom tfit yak kasinyaf hanyrahrm. Nd yima yuhu behohetm o dborioh yima yuhetm ndnatn hti nhtahato mirahmnom, ‘O arr ndhtet yimayer.’ ");
INSERT INTO amp_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ndnatn bok yimaroh yima yuhum yak duka tungarahrm. Yak duka tungaruhatrm, tafont rhurahm. Nd ni hiyauyuk yonr bok krho nmbuham yakruhatr, ni nd yonrhu hiyau mmemn htiruhann, krhorahn. Mirahme, ‘Kfraye waswomr yima yuhur.’” ");
INSERT INTO amp_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Ndharn wom profet mett tohmout. Rothu yufat Anat. Rothu yifemr Fanyuerr. Nd yima Fanyuerr Asa frikef yuhat niamor. Rot tmaht tohmohat ram fakmot. Ram yakmotn, nhai toh buhtarmor ramemr. Be 7-pela gunyjimrpam tohhato nohmor. ");
INSERT INTO amp_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ramemr noh htanimotrt, to be dhirt tohmout. Rothu gunyjimm bi 84-kfot rhumom. Nd metthu toh nmbuhat tohmoahat, nhai Bro Nkifrarhu temperr thu trohrmoatr. Yifung marm be Bro Nkifrarhu temperrn rhuhato nuwa kurhato kfo bruttna hasomout. ");
INSERT INTO amp_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Maria Josefrof nd yonrhu nmbuhatn Simionrpno naptha hasetmn, Anat nd temperr ruhettn, niahato Bro Nkifrar mkfo yindhormotr. Kfo yindhornihato nd yonrhu mrokfot kfo nuhas hi hanymotm yimam. Kfo hi hany memoutm, “Niko Bro Nkifrarn gari haso memoa Jerusalemrhu minrfa htiyakyuk yimar ahnarr, to bi tor, bi niamor.” Inji kfo nuhas hi hanymoutm. ");
INSERT INTO amp_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Josef sawohf nd thfa mntwat kfoyuk tamoh tamoh hingrnefenm hingrna truf bugamofmn, tfit yimof Galilikorhof kmi Nasaretko. ");
INSERT INTO amp_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nasaretn tohhato yima yonr warhonimor. Yima yonr warho hanymo fijo, yima dukefm rpat yimarhu warheftpno fak hikmom. Yo yonrhu toh nmbuham Bro Nkifrar toh natwihmotrr, be hifa hifa toh marnyamor. ");
INSERT INTO amp_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Pasofa burwat Jerusalemrn rifinyhato htamoumt. Jisasrhu yifammaf rpa rpa gunyjimm Jerusalemko yihato hti rhunhomoufm. ");
INSERT INTO amp_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Josef Maria sawohf nd Pasofa yiham nhai rhurmoaf, yiha yiha yimouf. Wom Pasofa yiharn Jisasr bi 12-pela gunyjimetrn, hik hanymorf. ");
INSERT INTO amp_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","45","Jerusalemko yimomn, nd Pasofakfothu rhuyuk yiham rhunimomn, be tfit Josef sawohf memof tufhuko ainyo. To be rof sinyani yimof. Rof sinyanimohat, memof yinem yonr ka bi wommpno nyinga yuhat tohak hanitr. To nhai, ror Bro Nkifrarhu temperr rhu hasetrn, yifamma sawohf htanymofr. Rof yimofn, nd Nasaretko yiyuk yimampno myau hikaknihato memoufm, “Nnoh yonre htitawokomr o nhai?” Tfit womm mhtimoufm kfo ttiwon memoufm, “Nnoh yon htitawokomr, o nhai?” Ttiwonhanysi, ttiwonhanysi, be tfit mkekutakhato tfit Jerusalemko yimof, rpa marr hambrotihato. ");
INSERT INTO amp_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Jerusalemko yihato ndha tfit wom marr hambromofr. Hambrohany tfit husfirpehyuk marrpnone rim htimofr Bro Nkifrarhu temperrn thfa mntwathu tisampno rhu hasetrn. Rom nd tisam mrokfom ptha boririfhumoahat, ror rhuhato wany yakitohmourm. Wany yakitohhato wom mrokfom ttiwon inji namourm. ");
INSERT INTO amp_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nd rhu rifinyuk yimampno ror nd kfo ttiwonmoa mrokfom yo pthamoa mrokfom wanymoamrn, duka memoum, “Barenko, ndar yonr be tu bro yimar kanjo tu bro dukayet yoner.” ");
INSERT INTO amp_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Yifammaf tisampno rhu hasetrn, rim hti fohtasmofr. Rim hti fohtashato mmemt memotr, “Bare, tamohmpno ndhtet neft namo? Ni hambro htfashato nnoh yima yuhum dungunanguwomno. Kangno, ‘Nko fitoko yir?’ Tkit tkitm wusono wusono rim hambrak mhambrakrouno.” ");
INSERT INTO amp_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Tfit yinem Jisasr warhuhato memorf, “Tamohmpno rim hambrak mhambrakrofna? Nhai duka mekahfn, ‘Yifemrhu kunys korhr?’” ");
INSERT INTO amp_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Yinemr inji kfomohat yifammaf nhai yakrmoft yinemr pthamo mrokfothu yimbu yuhat. ");
INSERT INTO amp_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Be rim hti yakmofrn, rpat tfit yimom Nasaretko. Yiha yiha yifammafhu kfoyuk mrokfom kak hikmourm. Mmemt nd mrokfom Jisasr pthamom nhai mong trohrmotm. Nd mrokfom rothu yima yuhurn wany hmbritamotm. ");
INSERT INTO amp_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jisasr bronihato ror yakmo dukefm tu hifa dukefm fakmor. Rorhu toh nmbuham Bro Nkifrari yo bok yimam nda bbinysofthum, hifa hti yindhormomr. ");
INSERT INTO amp_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Jon baftaisr Bro Nkifrarhu mrokfom yakhato pthamoa yihart, nd yihar Taiberius Sisar, Romroh gafmanr tohmour. Toh yukatoh hanymorn, namba fiftinyuk gunyjimrpno Pontius Pailatr, Judiaroh gafanar tohmor. Herotrn Galilikort, rorhu najom Filifrn Ituriakorti Trakonitiskort, Lisaniasrne Abilenekort. ");
INSERT INTO amp_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Yo Anas Kaiafasrofne prisroh nyingako tohyuk yimaf tohmouf. Tot nd yiharn Sekaraiarhu yon Jonr yima toh duha tkitt tohhato Bro Nkifrarhu mrokfo rifhur mithu nawohmohat. ");
INSERT INTO amp_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Nd mrokfo rifhur mithu nawohmottr, tfit rorn nd mrokfot yaknihato tek Jodenthu mkuyef mkuyeffhu kmi kmim yi habrimoarn, met yindarim kfo memourm, “Nikmoh fasoh fasoh nefm mong wahikahkomm, baftaiskfot. Baftaiskahtko, Bro Nkifrar yak thu-hirahrko nikmoh fasoh fasoh nefm.” ");
INSERT INTO amp_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Jonr mrokfom pthamoahat bingot profet Aisaiar pthamoa mrokfom kanjo inji pthamour. Aisaiar memour, “Wom yimar nungur tik furatn tohhato kfo mirahrko, ‘Bro Nungothetrhu niayuk yuhat wayak marnyak hanyhekomr.’ ");
INSERT INTO amp_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nd mi bunduha niyet tkitm Bro Nkifrar yak marnyarahrm. Nd muh wohneni hanyet kminysofm ror nhaf tou gifa marnya hanyrahrm. Nd tirngnha htani hanyet yihotam rorn touwak hanyruharn be yihotam yak teh marnyarahm. Tamoh tahi siket tkitm ror yak marnyarahrm. Yak marnyahato yihotam be wutham rhurahm. ");
INSERT INTO amp_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ndhtet ndhtet tkitm yak marnya bomarnyahato ee nd yimaroh minrfa htiyakyukr Bro Nkifrar kfo tkruraforuhatrr, htiyakrah-komr.” ");
INSERT INTO amp_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Bok met yindarim Jonr baftaisafo hanyhato kfaf hany memourm, “Arom nandomrhu yon kunyso, Bro Nkifrar yimam yak tutfa thombat, finji yak hhrifniruhako? ");
INSERT INTO amp_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nikmoh nefm, tohefm amfrfnah marnyakahtm riruh aruhyukm htiruhamn duka mirahm, ndm bi mong trohmomm fasoh fasoh nefm. Bi mar nukat tohwom. To mirahko, ‘Ka nom Abrahamrhu yon kunysn ka yak trohnirahrnom.’ Nhai. Ndt rot niko mirahko bro yima yuhum ahtanomt. Wawanyko. Na kfiwanko, Bro Nkifrar akfor, nda tahim yak krekutrfotrm, Abrahamrhu yonm rhurfom. ");
INSERT INTO amp_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Hudarim bi mispimn bi frhamsisetm korhm. Fitoh mim nhai hifa yukha hir marnyakahm, nd hudariye yohakhany yohakhany, kahrpatn dbuhaf hanyrahm.” ");
INSERT INTO amp_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Jonr inji kfomotrm, tfit romn ttiwon memomr, “Tone nome finji naruhanom?” ");
INSERT INTO amp_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Kfo memorm, “Yimar hus hmbreshetre, wom that yakhato wom hmbresha duhatrn hekfot. Yo yimar yeshretr, be nd rpahtet neft nakfot.” ");
INSERT INTO amp_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Takis marum yakmoa yimam nhaf baftais yakneft niahato ttiwon memomr, “Nome finji naruhanom?” ");
INSERT INTO amp_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Kfo memorm, “Niko maruha yakneft mirahko wom maruham be tunmoh duka fijo ayak furanomm. Nd gafmanr kfo htayuk maruharpam yakkfot.” ");
INSERT INTO amp_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Yo wom soldiam nd baftaiskfot nia yak hanyukm nhaf ttiwon memomr, “Nome nhafne finji naruhanom?” Kfo memorm, “Mirahko yimam kfo yakrmehato marum ayak hanynomm, o yimam kotim furahato maruham ayak hanynomm. Tuko hingrnayuk maruharpam yakkfot.” ");
INSERT INTO amp_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Bok met yindarim rroh hbhakyuk yima Kraisr gari hasetmn, tfit Jonr inji kfomohat, to be rroh dukeft duka memom, “Ka asor nd nom gari hasiwa yimar.” ");
INSERT INTO amp_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jonr memorm, “Na be nda bupa furaye baftaiswanko. Tor nanhu mong yuhat niewa yimarn, tor tu yimar. Na nhai ror kanjo bbukeft hatohkaha. Na, na be yima furaya rorhu senderfhu ki jbkafyuk mtinf kak nyusakahukanr. Rorn Bro Nkifrarhu Yafothati kahe baftaisimrahrko. ");
INSERT INTO amp_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ror witthu hoftha kr nd ndroh thu krhayuk safort tirtn kakitohwort. Tu hifa witham yak nhafohruharm, turhu naku dany kunysn htarahrm. Nd hoftha kr tikmn tu yiha yiha nanyjar hatohet kahtn kandhi thurahrm.” ");
INSERT INTO amp_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jonr mrokfom pthamohat nhai be nd mrokforpam kformor. Hifa hifa dborioh mrokfom kfo yingmarimorm. ");
INSERT INTO amp_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","20","Jonr pthamo mrokfom rom hifa pthamorm tfit turn nd Judaroh gafmanr kutewumr Herotr, ror nahnamo fasoh fasoh nefmi yo najom tuhan Herodias yakmo yuhat, nd ndmpno Jonr kfo nyingo fnahmotrr, be wom Herotr namburhato Jonr yakhato kalabusn htamorr. Herotr nd Jonr kalabus htamo yuhatpno tot tu wom bro fasoh neft ror namot. ");
INSERT INTO amp_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Yima bugam baftaishany baftaishany, ee Jisasr baftaismor. Ror baftaisnihato kfo bruttna hanymor, ee yura mountko htimortko yoh tnehmohat. ");
INSERT INTO amp_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Mount yoh tnehhato nd yoh tnehmo yuhatn wuhtiyakmort Bro Nkifrarhu Yafothat ganyom mmkrs kanjo yak nhombranehato fawihnamot. Be nd ganyom mmkrs yawihnamotn yimar mirhumot. Tfit yura mountko wom tngt wanymort. Nd tngt kfo hany memot, “Ni nanhu yone. Nanhu marbit korhwot ninn. Hifa hti yindhorwann.” ");
INSERT INTO amp_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jisas Bro Nkifrarhu hingrneft rihingrnakmohat bi 30 gunyjimetrn, Bro Nkifrarhu hingrneft rihingrnakmort. Nd yonr niamo yuhat myak hikakmohat wom yimam duka memom, “Ka Josefrn yifemmorr nd yon Jisasr.” Asot nd duge katfonyuk yifemrhu nkifra yuhat inji: Josefrhu yifemr Helir. ");
INSERT INTO amp_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Helirhu yifemr Matatr. Matatrhu yifemr Lifair. Lifairhu yifemr Melkir. Melkirhu yifemr Janair. Janairhu yifemr Josefr. ");
INSERT INTO amp_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Tfit Josefrhu yifemr Matatiasr. Matatiasrhu yifemr Amosr. Amosrhu yifemr Nahumr. Nahumrhu yifemr Eslir. Eslirhu yifemr Nagair. ");
INSERT INTO amp_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagairhu yifemr Meatr. Meatrhu yifemr Matatias. Matatiasrhu yifemr Semenr. Semenrhu yifemr Josekr. Josekrhu yifemr Jodar. ");
INSERT INTO amp_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Jodarhu yifemr Joananr. Joananrhu yifemr Resar. Resarhu yifemr Serubaberr. Serubaberrhu yifemr Sealtierr. Sealtierrhu yifemr Nerir. ");
INSERT INTO amp_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerirhu yifemr Melkir. Melkirhu yifemr Adir. Adirhu yifemr Kosamr. Kosamrhu yifemr Elmadamr. Elmadamrhu yifemr Err. ");
INSERT INTO amp_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Errhu yifemr Josuar. Josuarhu yifemr Elieser. Elieserhu yifemr Jorimr. Jorimrhu yifemr Matatr. Matatrhu yifemr Lifair. ");
INSERT INTO amp_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lifairhu yifemr Simeonr. Simeonrhu yifemr Judar. Judarhu yifemr Josefr. Josefrhu yifemr Jonamr. Jonamrhu yifemr Eliakimr. ");
INSERT INTO amp_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliakimrhu yifemr Melear. Melearhu yifemr Menar. Menarhu yifemr Matatar. Matatarhu yifemr Netanr. Netanrhu yifemr Defitr. ");
INSERT INTO amp_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Defitrhu yifemr Jesir. Jesirhu yifemr Obetr. Obetrhu yifemr Boasr. Boasrhu yifemr Salmonr. Salmonrhu yifemr Nasonr. ");
INSERT INTO amp_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasonrhu yifemr Aminadafr. Aminadafrhu yifemr Atminr. Atminrhu yifemr Arnir. Arnirhu yifemr Hesronr. Hesronrhu yifemr Peresr. Peresrhu yifemr Judar. ");
INSERT INTO amp_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judarhu yifemr Jekofr. Jekofrhu yifemr Aisakr. Aisakrhu yifemr Abrahamr. Abrahamrhu yifemr Terar. Terarhu yifemr Nahorr. ");
INSERT INTO amp_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahorrhu yifemr Serukr. Serukrhu yifemr Reur. Reurhu yifemr Pelekr. Pelekrhu yifemr Eber. Eberrhu yifemr Selar. ");
INSERT INTO amp_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Selarhu yifemr Kenanr. Kenanrhu yifemr Apaksatr. Apaksatrhu yifemr Semr. Semrhu yifemr Noar. Noarhu yifemr Lamekr. ");
INSERT INTO amp_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamekrhu yifemr Metuselar. Metuselarhu yifemr Enokr. Enokrhu yifemr Jaretr. Jaretrhu yifemr Mahalalerr. Mahalalerrhu yifemr Kenanr. ");
INSERT INTO amp_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenanrhu yifemr Inosr. Inosrhu yifemr Setr. Setrhu yifemr Adamr. Adamrhu yifemr Bro Nkifrar. Tom inji Jisasrhu nkifraroh yufam. ");
INSERT INTO amp_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jisasr tek Jodent htanymohat, bi Bro Nkifrarhu Yafothat thu nhombrayetrn, to be nd Yafothatn yak hatoh hanymottr, yimor yima toh duha tkit furatn. ");
INSERT INTO amp_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Jisasr 40 yiham nd tkitt tohhato Satanr niahato kfo nhebehmourr. Nd ror tohmo yiham nhai nuwa yarmor. ");
INSERT INTO amp_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Tu wuroh yiharn bi yatinoh namborhohetrn, nd Satanr tfit mfnahhato kfo memorr, “Ni Bro Nkifrarhu yonn rhu thombat, ndar tahis wakfokahtnt, bret nuwat kekutraht.” ");
INSERT INTO amp_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Tfit Jisasr kfo memorr, “Bro NKifrarhu gonborngt kfo kangt, ‘Nhai wom yimar nuwarpat yehato toh wonakrmor.’” ");
INSERT INTO amp_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Inji kfomotrr, tfit yaknimorr hamuhmorr yura kminysofmn. Yura mhatohhato fak nuhasmorr ndar bbinysofthu kmi kmim. ");
INSERT INTO amp_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Kfo memorr, “Nda bbinysoft nann tohukatohwant. Fitoh yimar he yibonkfot kfiwa, nd yimarn kahuka. ");
INSERT INTO amp_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ndnatn kanga akfoyann, ni hikrahna, be ninn nda bbinysoft tohukatohrahnt.” ");
INSERT INTO amp_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jisasr sinyahato kfo wok memorr, “Bro gonborngt kfo kangt, ‘Bro Nkifrarpar hikkfot. Rorrpar tor tu Nkifra mifr. Rorrparhu hingrneft yakitohkfot.’” ");
INSERT INTO amp_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Inji nna pthanihato tfit nd Satanr yaknimorr, hanymorr Jerusalemko yorhwa temperrhu mingiahurhu bikatitn. Yura mhatohmorrn, kfo memorr, “Ni Bro Nkifrarhu yonn rhu thombat, watuhatoknikahnn, bbinysoft wamitohwonn. ");
INSERT INTO amp_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Bro gonborngt kfo kangt, ‘Ni tuhatokni thombat Bro Nkifrarhu mounmotm kforuhatrm, wuyakitohak hanyrahmn. ");
INSERT INTO amp_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Rroh tirmn mirhuniruhann, nhai tahimpno mita wokruhatnm ninhu wuram.’” ");
INSERT INTO amp_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jisasr tfit kfo wok memorr, “Bro gonborngt kfo kangt, ‘Mirahn Bro Nkifrar be yuwi awastiwonanr.’” ");
INSERT INTO amp_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Be nd Satanr womhtet womhtet nefm nhombra nhombratihato be afo htanymorr. ");
INSERT INTO amp_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Be Jisasr tfit yimor Galiliko. Bro Nkifrarhu Yafothathu bbukeft be hatoh twanho hanymort. Jisasrhu mrokfot Galilikorhof kmi kmim ptha habrimotrm, yimam wany bugamomt. ");
INSERT INTO amp_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Judaroh rhu rifinyuk rmontn yihato mrokfom pthamoatrm, bok met yindarim ror pthayuk mrokfom wany yindhormoumm. ");
INSERT INTO amp_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jisasr tur toh warhomo kmi Nasarethu rifinyuk rmont rhu krna Sabat yihar fknenimohat yiha yiha fkneni hakumoa yuhatn hikmorn fknenimor. Fknenimorn, Bro Nkifrarhu mrokfom ptha yibonetrn, be yau yaknihato rim tohmor mrokfo pthayuk tkittn. ");
INSERT INTO amp_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Rim tohmotr, profet Aisaiar wandfamo mrokfom hemomr. Mrokfefm yakrir hmbreyetmn, to be yak nyimbusakak hanyhato wom mrokfom mihtimorm. Nd mrokfom inji kfomom: ");
INSERT INTO amp_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Nann Bro Nkifrar bi fak htamora wuska duha yimami maruha duha yimaroh hifa dborioh mrokfothu kfo nuhasneft. Ndnatn Bro Nkifrarhu Yafothat nann thu nawohmot. Bi kfo memora, ‘Waikahnn, mrokfot waptha wamitwa, “Niko kalabus tohyukko tmifko wafnahniko. Niko nyinga kunyjetko tfit wayukatohko. Niko yimam yak bebhato yima yuhenm gumuha muhthunitwako, yima yuhum amirhutwamko.” ");
INSERT INTO amp_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Yo Bror kfo tkruraf memora, “Wakfo nuhas wamitwanm, asor bi rroh yak marnya yihar bi.” ’” ");
INSERT INTO amp_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jisasr nd gonborngthu mrokfom ptha buganimormn, tfit yakrirakmortn, tu kunys tohyuk yimarn rihihato warhumor. Btn nd kunys rhuyuk yimaroh nyingam be rorparn kukatohmoum. ");
INSERT INTO amp_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jisasr rhuhato nd kunys rhuyuk yimam kfo memorm, “Nda niko wanu mrokfot to bi asot bi arihatn nd neft htitwokom bi mfrfnah hanitt.” ");
INSERT INTO amp_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Jisasr inji kfomotr, nd yimam wanyhato duka memom, “Ndar yimarhu mrokfom hifa hifa ptha hik bohik marnyewurm mrokfom. Ka nhai Josefrhu yonr rhukahr?” ");
INSERT INTO amp_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jisasr memorm, “Na kfo mifwanko, mirahkma, ‘Ni doktaye ninhu dbohneft tunn wayak thunt. Ni Kaperneamt tohhato namo nefm kanjo nda tunhu kmi mnat tohwohat inji wana.’” ");
INSERT INTO amp_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Kfo memorm, “Na kfo mifwanko, nhai wom profetr turhu kmi mna thofm yak miyakhato ror pthayuk mrokfom wany yakio wonakrmomr. Nhai. ");
INSERT INTO amp_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Iraijarhu tndht wadukakomt. Iraijar tohmo yiha Isrerko husfirpa gunyjimmi 6-pela yamm bro yinr tohmor. Bro yinr tohmotr, yewurit noh witamot. Noh witamott, yatinoht tohmoum. ");
INSERT INTO amp_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Nd yiharn bok met dhirm Isrerko yatinoht tohhato nakumoum, ‘Iraijaye, wania, wahti dukannom, nom yorhwa krho nmbuhat.’ To nhai, Bro Nkifrar nhai marimorr, ‘Rompno waiswa.’ Nhai. Tfit nndoh wom Saidonkorhof kmi Sarefathu met dhirtpno yak hatohafo-motrr, rotpno yihato htimort rothu krhopam. ");
INSERT INTO amp_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Yo womt dukakfot. Siriakorhof yima Nemanrhu hun mimbrt yak marnyamo nmbuhat, ndt nhaf inji rhumot. Iraisar profet hingrneft tohmohat nd tuha Isrerthu hun mimbretm nhai marimor, ‘Yak marnyaruhanm.’ Nhai. Tfit nndo wom kmi Siriakorhof yima Nemanrn Iraijar yimorn, fak marnyamorr.” ");
INSERT INTO amp_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nd kunys rhuyuk yimam Jisasr pthamo mrokfom wanyhato namburmom. ");
INSERT INTO amp_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Namburhato Jisasr yaknihato nd taun Nasaret tahiye gna habriyettn, to be briahako fak hfnahnimomr. Briahako hfnahnihato nd taun Nasarett yura wom kmi mfhat ruhettn, to be Jisasr yaknimomr, kmi yengongko mihatohhato memom, “Atashotafkahtnomr, amisuhr.” ");
INSERT INTO amp_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","To nhai, nd yimaroh rifiny buharn yau inyar fnahhato yimor. ");
INSERT INTO amp_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jisasr yimorn, tfit Galiliko yorhwa kmi Kaperneamtn tfi mifnahmor. Ndha mifnahhato ndkorhof rhu rifinyuk rmontn rhu krna Sabat yiham fknemoarn, Bro Nkifrarhu mrokfom kfo nuhas bonuhasmourm. ");
INSERT INTO amp_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Jisasr pthamoa mrokfom tu hifa ptha yembindtmoatrm, yimam nd ror pthayuk mrokfom wanyhato bok dukefm yakhato duka memom, “Barenko, ndar yimar pthiwa mrokfom hifa ptha yembindt marnyewurm.” ");
INSERT INTO amp_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nd Judaroh rhu rifinyuk rmontn rhumor kmi yarh fknayet yimar. Nd yimar sinyahato tau nakuyafhato kfo hutt memor, ");
INSERT INTO amp_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Nasaret thof Jisase! Ni asha niaronn, nome finji naruhannom? Nmoh yak batit niaro? Hti nhtiwann ni Bro Nkifrar yak htamo yimaye.” ");
INSERT INTO amp_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jisasr sinyahato nd kmi yarhr kfo hutt memorr, “Ni nd kmi yarhe, tmifn tngt wayoukihkahnt, nd yimar wathu troh tanynr.” Be thu troh tanymotrr, nd yimar suh hasomor. ");
INSERT INTO amp_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Yimam nd Jisasr namo neft htihato wutthamom. Memom, “Bar yimako, nd yimar pthe mrokfote tamoh bbukettn nd kmi yarhr wanyhato nd yimar thu troh tanyrr?” ");
INSERT INTO amp_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Be nd Jisasr nayuk nefm yimam htihato kmi kmi nnakfo nuhashi hanymom. ");
INSERT INTO amp_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jisasr Judaroh rhu rifinyuk rmont htanyhato tfit yimor Saimonrhu kunysn. Saimonrhu matohemt kkah dbohnettn, nd kunys rhumot. Jisasr nd kunys yimotr, kfo memomr, “Nd mett wayak marnyant.” ");
INSERT INTO amp_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jisasr nd mett hwemo tiktpno rim tohhato nd metthu dbohneft htihato kfo nambur-motr, nd dbohneft thu troh tanymott. Be nd mett yudbat marnyani hanyhato yeshrim hta mskahemotm. ");
INSERT INTO amp_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Marr bi yohni hanyetrn, fitoh yimaroh yimatm womhtet womhtet dbohnefm yak hanyetm hne hna hanymomm Jisasrpno. Jisasrpno hnamoatmm, tir htaf hanymoatrm, marnyani hanymoum. ");
INSERT INTO amp_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nd kmi yarhm fknayetm marnyani hanymoum. Nd yimam fknemoa kmi yarhm tau yakhany, tau yakhany, thu troh tany hanymoumm. Thu troh tanymoahat kfo tany hany memoum, “Ni tu Bro Nkifrarhu yone!” Nd kmi yarhm bi hti nhta memom, “Ndr yimaroh hbhakyuk yima Kraiser.” Ndnatn Jisasr inji wanyhato nd kmi yarhm kfo gadiyaf hanymoatrm, nhai tfit pthani hanyrmoam. ");
INSERT INTO amp_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Tfit dbha ksfutn nd kmit htanymortn, yimor wom yima toh duha tkittn. Yimotr, yimam hambro hambro be wuroh natn mhtimomrn, kfo memomr, “Tamohmpno htanywannom? Nom wofnkahnom ninhu nmoh htanyneft.” ");
INSERT INTO amp_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Jisasr inji wanyhato kfo memorm, “Nann Bro Nkifrarhu kingdomkfothu gutnius mrokfot kmi kmim yi htfashato kfo nuhas htfaskfot. Nd hingrnefthu hingrna neftn Bro Nkifrar kfo tkrurafmora.” ");
INSERT INTO amp_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","To be ndnettn Jisasr nhai tuharpa ptha hasormoar. Judiaroh kmi kmiroh rhu rifinyuk rmonm yihato Bro Nkifrarhu mrokfot ptha htfasmoatrt, wanymoumt. ");
INSERT INTO amp_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Wom yihar Jisasr Genesaret bari thmbt tohhato Bro Nkifrarhu mrokfefm ptha hasomotr, bok yimam brbo brbo hany yukukaknihato memoum, “Awanynom ror pthiwa mrokfom.” ");
INSERT INTO amp_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jisasr tohhato htimorf wom hus mmbrf yura nungutn teh hatonatamomfn, yimam nd mmbr tikatm rugim, ndm thu kibofsamoum. ");
INSERT INTO amp_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jisasr nd mmbrf htihato wom mmbrt mikmbremor. Nd ror mikmbremot Saimonrhut mikmbremor. Mikmbrehato Saimonr memorr, “Watakiowafokahnn, mmbrt wuri kkof arim hirt.” Be nd mmbrt wuri kkof rim hahirmottr, Jisasr nd mmbrtn rhuhato Bro Nkifrarhu mrokfefm kfo ptha nuhasmourm nd yima rifhur. ");
INSERT INTO amp_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Ptha buganimorn, Jisasr kfo memorr Saimonr, “Wayangonikahnn, mmbrt tek dany yuhat arim hirkahtt, nini ninpno yira yak htfasyuk yimako rugim wayafhokahkomn, yiram watuhaktwako.” ");
INSERT INTO amp_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Saimonr watohhato kfo memorr, “Bro yimaye, hrek yifungr nhombra nhombra nfha titawonom, nhai wom yirenr yakrfonom. Nhai mrokfom, ninhu tngtpno tfit afo rugim yafho thuwonrahnomm.” ");
INSERT INTO amp_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Rugim yafho thuhato tfit memom, “Wayaknomm,” rugim be tu yoh tmbrakfot inji namom. Yirat nhai be ffhirmhato yakrmom. ");
INSERT INTO amp_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Be wayak nhombratihato tfit nd wom mmbrt hiryukm tire hungasakhato memomm, “Waniako.” Be niamotm, rpat nd hus mmbrfn mano mano tohhato wateh sohakmomm nd yira rugim. Btn nd rugiroh yiram yakhany, yakhany, nd hus mmbrf be yoh yifkfot inji namof. ");
INSERT INTO amp_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimon Pitar inji htihato Jisasrhu wurampno yihom suhhato kfo memorr, “O Broye! Be tmifn wahtanykahna, wanju. Na fasoh nef nayet yimaya.” ");
INSERT INTO amp_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Rori nd mmbrf rhuyuk yimam nd yonmari yirat htihato memom, “Barenko! Nome ndar yirate finji yurhtes?” ");
INSERT INTO amp_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Saimonrhu yarmotemrof Sebedirhu yonf, Jems Jonrof, rof to inji nhaf nd yirat htihato mrokfo kfo duhatf rhumof. Jisasr Saimonr kfo memorr, “Ayanhowahn. Kto ni to inji nd yiram yek kanjo yimam inji yakrahnm.” ");
INSERT INTO amp_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Be nd mmbrf rim tatrnahato nd tamoh tamoh wuskar htanymomrn, Jisasr tfit mhikakni twanhomom. ");
INSERT INTO amp_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jisasr wom kmit tohetrn, wom lepra dbohneft yaket yimar niahato Jisasrhu wurampno msuhhato mkfo memorr, “Broye, ndar na hatohwa dbohneft yak thurahnt, to be thu troh tanyrahta.” ");
INSERT INTO amp_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jisasr inji wanyhato nd leprayet yimarn tirt rihtahato kfo memor, “Uwa, na yibonwa.” Inji kfoni hanyhato nd dbohneft kfo memort, “Wathu trohnr.” Inji kfomotr, nd dbohneft yudbat thu trohmotr. ");
INSERT INTO amp_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Thu troh tanymottr, Jisasr nnhuhato kfo memorr, “Ni nda dbohneft thu troh tanyhat, mirahn tfit womm akfo nuhasanm. Mosesrhu boririfhut yak hikkfot. Yimam lepra dbohneft yaketm marnyanimoahat inji namoum. Nd hun gifam prisrpno myak nuhasnimoamn, tarioh mthamoum. Nd tarioh mtha yiharn prism ndt htihato kfo memoum, ‘Nd yimarhu dbohneft bi thu troh tanymotr.’ Ni nd yuhat yak hikkfot.” ");
INSERT INTO amp_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","To nhai, nd Jisasr hingrnamo hingrnefthu mrokfot nhai tfit wom kafrohrmot. Bok tng rihar rhu fnahmott, bok yimam wanyhato niamom, memom, “Yiruhanomn, ror pthayuk mrokfefm wanyhato dbohnefm yak thurahrnom.” ");
INSERT INTO amp_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","To nhai, yima duha tkitt yimoarn, kfo bruttnamour. ");
INSERT INTO amp_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Wom yiha Jisasr wom kunysn rhumor. Nd kunys rhumotr, yimam nd kunysn rifinymotm, Bro Nkifrarhu mrokfom kfo nuhas bonuhasmorm. Nd yima rifiny buharn wom Farisimi boririfhuthu tisam rpat nia rifinymom. Bok kmi kmim rhuyuk Farisimi boririfhuthu tisam niamom, womm Galilikorhofm, womm Judiakorhofm, yo womm Jerusalemkorhofm. Nd yihart yimaroh yak marnyayuk bbukeft Jisasr thu nhombramotr. ");
INSERT INTO amp_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Wom yimar tir wura behohetr to bi wom yimamn kroketr hne hnamomr. Nd yimarhu wuram bi noh minysaf bugamomr. Memom, “Hiyau hafkne-nikahnomr, Jisasrpno brbo rim htarahnomr.” ");
INSERT INTO amp_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","To nhai, hanyuk yihotat bok yimam rifinyhato toh dbu hmbriyafmotmt, be nhombratihato tfit yura kuny mingiahuko yak tmbrafomomt, nd yimar yura mingiahu yuhat hamuhmomrn, yura mingiahu yuhatn yuht kroketr mano mano mtitofm ttafhato thu nyusakaf hanymomrn, tfit yiro kuny yurukko tohyukmn yakmomrn, Jisasrpno rim htamomr. ");
INSERT INTO amp_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Nd yimar hany rim htamohat rroh dukefm duka memom, “Jisasr yima yak marnyetr. Nda minysafet yimar ror kforahr be marnyanirahr. Nhai tfit nd minysaf rifhut rhuruhattr.” Be Jisasr rroh yima yuhum inji htihato kfo memorr nd yimar, “Yinowe, ninhu fasoh nefm bi fak tuhahuyann.” ");
INSERT INTO amp_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nkifra boririfhuthu tisami Farisim Jisasr pthamo tngt wanyhato tum rinahti nahtihato kfo memom, “Nd yimare, kangr Bro Nkifrarhu tkitt ayaka. Nhai wom yima furarn yimaroh fasoh nefm yak thukfot. Bro Nkifrarpar yimaroh fasoh nefm kak thuworm.” ");
INSERT INTO amp_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Nd yimaroh yima yuhum inji dukamohat Jisasr bi htimorm. Htihato kfo memorm, “Tamohmpno inji riduka adukiwako? ");
INSERT INTO amp_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Kangko finji akfoyane? Kangko akfo amiyanr, ‘Ninhu fasoh fasoh nefm bi fak tuhahuyann?’ O kangko akfo amiya, ‘Wasinya wayauyakni?’ ");
INSERT INTO amp_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Na, Bro Najoma, yimaroh fasoh fasoh nefroh yak thu yafothat Bro Nkifrar bi hemora. Afo asomif wom neft yak nuhasrhotanko, duka mirahko nd yimar bro yufeter.” Inji kfoni hanyhato nd tir wura minysafetr kfo memorr, “Na kfiwann, wasinyakahnn krokt wayaknikahnt tunhu kunyko wain.” ");
INSERT INTO amp_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Be inji kfomotrr, tuha nd yima rifinyrhu nyingahato wasinya-morn, nd tur hwemo krokt yakmortn, be Bro Nkifrarhu yindhorefrparpno yimor kunyko. ");
INSERT INTO amp_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Nd yima rifhur nd kunys tohmor, Jisasr namo neft htihato be tuha tir pinyafm youtahato tohmom. Kfo memom, “Hrek be tu womhtet neft htitawonom.” Inji dukahato tuha Bro Nkifrar kfo yindhor boyindhormomr. ");
INSERT INTO amp_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nd neft htinimomt, tfit kto Jisasr fnahnihato takis maruharoh yakyuk yimar turhu takis marut tuyuk kunyent rhu hasetrn yihom htimorr. Nd yimarhu yufat Lifair. Ror yihom htihato kfo memorr, “Wania wahikna.” ");
INSERT INTO amp_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lifair wanyhato be nd tamoh tamoh wuskam htanymormn, hikakni twanhomorr. ");
INSERT INTO amp_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Kto Lifair turhu kunysn yemro burwat yak htatamortn, Jisasr naku yakmorr. Jisasr yihato nd yemro burwat rhu famoft. Nd wom wom yimam yo tu nd rpahtet hingrnafat tohyukm rpat fenyhomomf nd yemro burwat. ");
INSERT INTO amp_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Farisimi boririfhuthu tisam htihato Jisasrhu disaiperm kfo nambur memomm, “Tamohmpno nd takis yekwa yimami nd ufasoh nefm nayet yimam rpat rhuhato nuwa ye mskewako?” ");
INSERT INTO amp_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jisasr inji wanyhato kfo memorm, “Yima furam nhai be yi furakahm hunkotharpno. Nhai. Dbohnet yimarpam kitwom hunkotharpno. ");
INSERT INTO amp_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Na nhai dborioh yimaroh dukeftn niarmoya. Nhai. Na fasoh fasoh nefm nayet yimaroh dukeftn niamoya. Memoya, fasoh fasoh nefm nayet yimampno yirhoyann, kforhotanm, nd rroh fasoh nefm yafhorahmm.” ");
INSERT INTO amp_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Wom yimam Jisasr kfo memomr, “Jon Baftaisrhu uhik ahik htfasyuk yimam Bro Nkifrarhu kfo bruttna yihar brio nuwa kurhato kfo bruttnewum. Yo Farisiroh uhik ahik htfasyuk yimam, rom nhaf inji na bugewum. To ninhu disaipermne tamohmpno nuwa ye hanitam nd kfo bruttna yihar?” ");
INSERT INTO amp_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jisasr kfo memorm, “Wom yimar wom mett yakrahr, rorhu yimatm nhai bi nuwa ye kafhokahmr ror afo rompno yuhre rhu mska inji na thombat. Nhai. ");
INSERT INTO amp_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","To tfit kto yak hambrafruhamr, ee bt rorhu yimatm nuwa kurhato rhurahm. ");
INSERT INTO amp_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Nhai wom yimam muhet yatk hmbreshat tfit wom nfri hmbresharhu mkum yakhato nahu hmbrikahmt. Nhai. Nd yatk hmbreshat tfit wom nfri hmbresharhu puk mku yak hanyhato yakhato nahu hmbrirahnt, nd yatk hmbreshat nhai hifa htiruhatnt. Faso hti bebrahnt. Yo nhaf nd dborioh nfri hmbreshar nd puk tmbho botmbho neftpno muh bomuh tiketr rhurahr. Nhai hifa hti yindhorruhatnr. ");
INSERT INTO amp_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Yo nhai yimam nfri wain bupam yakhato yatk meme tha kpmn tas hmbrikahmm. Nfri wain bupam yakhato yatk meme tha kpmn tas hmbreneft nd nfri wain bupam rikur prhoruhamn nd yatk meme tha kpt frtfohhato wain bupam mitoh bugarahm. ");
INSERT INTO amp_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ndnettn nfri wain bupam tu nfri meme tha kpe tas hmbrihato be nhai kpm yoh tfoh inji nakfot. ");
INSERT INTO amp_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Yo yimar yatk wain bupa fut wofnetr nhai tfit wofnkahr nfri wain bupa futneft. Yatk wain bupa fut wofnetr kangr, ‘Yatk wain bupam hifa.’” ");
INSERT INTO amp_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Wom rhu krna Sabat yihar Jisasri turhu disaipermpno wit swirr yihato yau nanyor hanyhato nd wit shuroh wit dmm yak tmbhak hanymoamm, tire tire yak rir tfka botfkamoamm, krm misuhmoatm, ki hanymoumm. ");
INSERT INTO amp_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Farisim inji htihato kfo memom, “Tamohmpno inji neko? Bro Nkifrarhu thfa mntwat inji kfiwut, rhu krna Sabat yiha nhai ndpa ndpam yak tmbhakkfot.” ");
INSERT INTO amp_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jisasr inji wanyhato kfo memorm, “Nikone Defitri wom yimam yatinoht rhu hasohato nkifra temperr rim htayet nuwa rikat rim yakhato yamo nmbuhathu tndhte, ka htitkomt o nhai? ");
INSERT INTO amp_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Defitr to Bro Nkifrarhu temperr fknenihato nuwa rikat bi Bro Nkifrarhu yufatpno rim htayukt rimakmortn, briahako turhu yaunho habriyuk yimampno rim htahato famomt. Nuwa rikat bi Nkifrarhu yufatpno rim htayukt nhai be wom yima furam ye wonakrmomt. Tu prisrpam fiyakmomt. ");
INSERT INTO amp_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Wawanyko, na nikmoh Bro Najomann nd rhu krna yihar kakitohwanr. Nd yihar kanga finji anaya, nhai tfit wom yima furar kfo htakfot.” Ndnatn nd Jisasrom namo neft nhai fasoh neft narmom. ");
INSERT INTO amp_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Tfit wom rhu krna Sabat yiharn Jisasr Judaroh wom rhu rifinyuk rmont yihato Bro Nkifrarhu mrokfom ptha nuhasmorm. Nd rifinymo kunysn wom tir gram tip behohetr rhumor. Mano tir mifkorhof tir gram tipt yak wok tkittn mnoh minysafakmotr. Tir pinyafm kfe mngomotmr, be nhai thu susnarmoarm, be inji hoketm rhumoum. ");
INSERT INTO amp_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Rom nd Farisimi boririfhuthu tisam, rom bi niamom. Niamomn, nd yima rifinyrn bi mfknemomn, tohhato memoum, “Jisasr nayuk tamoh nefm na thombat afo hti hikrahnomr. Hti hikhato kfo hndhnarahnomr.” Ndnetmn rhuhato memom, “Afo htirahnom dbohnet yimam rhu krna Sabat yiha yak marnyarahrme nhai.” ");
INSERT INTO amp_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Nd yimaroh yima yuhum inji dukamohat, Jisasr bi htingotmorm. Htihato nd tir gram tip behohetr kfo memorr, “Buha yima rifiny buharn wasinya watohetohn.” ");
INSERT INTO amp_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Be nd yimar sinya tohmotr, Jisasr kfo ttiwon memorm, “Niko finji dukiwako? Rhu krna Sabat yiha yimaroh yak marnyanefte, Bro Nkifrarhu boririfhut finji kfiwat? Rhu krna Sabat yihare hifa nefm nakfot o fasoh nefm nakfot? Yimam yak marnyakfot o yimam waskfot?” ");
INSERT INTO amp_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nd rifinymo yimam yukatoh nhombra buganimormn, nd yimar kfo memorr, “Tirt wathu susnant.” Be nd yimar tirt thu susnamort. Tirt thu susnahato marnyanimotr. ");
INSERT INTO amp_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Inji htihato masat namburhato tum rinakfo nakfo memom, “Nda yimare finji naruhanomr?” ");
INSERT INTO amp_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Kto wom yifungr Jisasr kfo bruttna nfhamor yura kminysoftn. ");
INSERT INTO amp_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kfo bruttna nfhahato dbharn nd rorhu disaiperm naku yakmorm. Naku yakhato niamotm, 12-pela kforpat fakmor. Yakhato kfo memorm, “Niko bi nanhu sioskfothu kasinya htfas-yukeko, bi nanhu aposereko.” ");
INSERT INTO amp_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Rroh womr Saimonr, (kto tu Jisasrn nfri Pita yufat hmbremorr), yo womr Saimonrhu nmem Andrur ");
INSERT INTO amp_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","yo womm Jemsr, Jonr, Filifr, Bartolomyur, Matyur, Tomasr, yo Alfiusrhu yon Jemsr, yo Saimonr, wom yufat Selotr, ");
INSERT INTO amp_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","yo womr Jemsrhu yon Judasr, yo wurohr Judas Iskariotr. Tor nd Judas Iskariotrn hndhnamorr Jisasr. ");
INSERT INTO amp_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jisasr yimam yaknimorn, tfit rpat fawihnamom. Yawihnehato tuha kmi kurhtn tfit nd wom yak troh tanymo yimampno tfit afo mirifinymom. Rifiny hasetmn bok yimam nd Judia-korhofm, Jerusalemkorhofm, Saidonti Tairkorhof tek afsor thmbm toh hanyukm, rpat met yindariyett nia mirifinyaknamom. ");
INSERT INTO amp_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Memom, “Ai arifinykahnomn, Jisasrhu mrokfefm wanyhato yo nmoh tamoh tamoh dbohnefenm yak thu hirahrnom.” Ndhtet dukefetmn yimom. Nd kmi yarh fknayetm, rom yudbat marnyani hanymoum. ");
INSERT INTO amp_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Nd yima yak marnyayuk yafothat tu Jisasrn hatohmourt. Ndnettn yimam ndt htihato memom, “Amyaktikahtnomr, rorhu yafothatn nieruhatn, yak marnyarahtnom.” ");
INSERT INTO amp_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jisasr turhu disaiperm yukatoh hanyhato kfo memor, “Niko fitoh yimako tamoh tamohm yak nafwako, toh beb nmbuhat yi tohwako Bro Nkifrar hti hasiwurt niko tohwa toh nmbuhat. Rorhu kingdomkfot tohwoko. ");
INSERT INTO amp_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Niko fitoh yimako arihat yatinoht tohwako Bro Nkifrar hti hasiwurt niko tohwa toh nmbuhat, kto ye furkihrahko. Niko yimako nur hasiwako, Bro Nkifrar hti hasiwurt niko tohwa toh nmbuhat, kto tfit ningirahko. ");
INSERT INTO amp_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Kto tfit htirahmko Bro Najoma hikruhatko, hti sr thurahmko, kfo yiritirahmko, kfo tfar-rahmko, kfo mirahmko, ‘Ar nthonroh yonm.’ Inji inji kforahmko. To niko mirahko inji wanyhato tfit anambur kekutnom. Niko be yindhorkfot. Bro Nkifrar hti hasiwurt niko tohwa toh nmbuhat. ");
INSERT INTO amp_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nd neft nhai be nikomrpakompno rhuruhatt. Nhai. Nd neft bingot bi profetmpno riruhakmot. Kto nikmoh hifa rhu nmbuhat Bro Nkifrar hirahrkonko yura hefenrn. ");
INSERT INTO amp_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","To niko boknabok maruhetko tfit kfiwa. Wayeye! Hifa dborioh rhu nmbuhat bi arihatn htitwokomt. ");
INSERT INTO amp_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Niko arihat ye furkihwako, duka yanuhaf hanykfot. Kto be yatinoht tfit tohrahko. Niko frohko arihat ninge yifa marnya bomarnyawako afo inji wanako. Kto tfit bu nyingam yoh dbottrahmko. ");
INSERT INTO amp_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Yo womt duka yanuhaf hanykfot bingotrhof kfo hnu bohnuyet profetm namoa nefm. Rom namoa neft yimam hti-moammn, memoum ka tu neftn newum. Ndnatn kfo yindhor furamoumm. Ndnatn niko yimam kfo yindhor-womkone, mirahko ka dborioh yimanomn kfo yindhorwomnom.” ");
INSERT INTO amp_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Niko frohko nanhu mrokfot wanukako kfiwanko. Wom yimar huttworn, ni tawo hifa yima yuhur hmbrekfot nd yimar. Yimar hti srthuworn, ni tawo yak marnya bomarnyakfot nd yimar. ");
INSERT INTO amp_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ni kfo beb bobebyuk yimar tfit ninn hifa kfo yima boyima marnyakfot. Nd yimam niko fasoh fasoh nefm nayukm niko tawo Bro Nkifrarpno kfo bruttna mekfot, ‘Nd na fasoh nefm newa yimam wayak marnyanm.’ Inji kfokfot. ");
INSERT INTO amp_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Wom yimar nambur hnehato yengongfat frtatrn, tfit manoko mkukorhoft yak hta hekfot. O sakethat fak hrurekrn, to mirahn yirok hmbreyuk honathat ahakkrant. Rpat yak hrurak-hato hiyafkfot. ");
INSERT INTO amp_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","O wom yimar tamoh tamohm tndauworn, yakhato hekfot. O wom yimar tamohm fahunr, ni tfit me juha, ‘O na nd yiha nd yimar fahuyanr nd shrm. Tawo ahira.’ Inji kfo duha. ");
INSERT INTO amp_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kangn, womm ayak marnyamane, barkofpam afo ninn sinyahato womr yak marnyakfot. ");
INSERT INTO amp_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Tawo tawo hifa yima yuhum nahmbritarpako niyak marnyiwakomn, to tfit tamohmpno yamukako, ‘Bro Nkifrar akfo yindhorrnom?’ Nhai. Nd niyak marnya nmbuham nd fasoh nefm nayet yimam, rom nhaf newumm. ");
INSERT INTO amp_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Yo nd nikompno niyak marnyiwarpam yamukako, ‘Tawo ayak marnyanom.’ Tamohmpno yamukako, ‘Bro Nkifrar akfo yindhorrnom?’ Fasoh nefm net yimam nd nefm rom nhaf newum. ");
INSERT INTO amp_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Wom maruham hiyafhato dbima tndauneft, ndt nhai tu dborioh neft. To inji naruhakomn, frohm hti yindhorruhamko? Nd fasoh nefm net yimam inji newum. Yimam tamohm hiyafhato tfit kto kangm, ‘Nom niko yahuhat nd shrm tawo wahekmnom ndm.’ ");
INSERT INTO amp_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Nikompno nakfo huttyuk yimam hifa yima yuhur htakfot. Hifa hifa yak marnya bomarnyakfot. Womm tamohm fahukomm, tfit kfo me juha, ‘Na ni yahuhat nd shrm tawo wahina.’ Nd na kfiwa tu hifa dborioh nef yuhat yak hikrahko. Kto be Bro Nkifrar hirahrko hifa rhu nmbuhat. Tu yura myorhekwa Nkifrarhu yonko rhurahko. To mirahko ka Bro Nkifrar nhai yuhuwafkahrm nd kfo yindhor duhatm yo nd fasoh nefetm. Nhai. Ror yuhuwafworm. ");
INSERT INTO amp_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nikmoh Bro Yifemr yima yuhuwafwa kanjo inji wayuhuwafkomm womm.” ");
INSERT INTO amp_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jisasr tfit wom mrokfot kfo memor, “Mirahko womroh nefm hti nhta yak nhtahato rroh nefm frhik bohikhenomm. Inji narahko, tngo Bro Nkifrar inji narahrko. Mirahko womm nayuk nefm htihato ayuta amenomm, ndr nder, o ndr nd nayet yimayer. Inji narahko, tngo Bro Nkifrar inji narahrko. Mirahko wom womroh nefm ayakitoh hanynomm. Yafhorahkomm, tngo Bro Nkifrar niko nayuk nefm yafhorahrm. ");
INSERT INTO amp_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Womm tamoh tamoh hirahkomm, tngo Bro Nkifrar mikahtr tawo ahiyanko htirahko wuss tamoht mano mano nieraht. Yimam mfro mfro thu brurrahkomm, tngo to inji Bro Nkifrar mfro mfro thu brurrahrko.” ");
INSERT INTO amp_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Inji kfonihato wom mrokfot kfo nhombra memor, “Wom yimar nyinga kunyjetr nhai tfit yihato wom nyinga kunyjetr yak nuhas hanykfot yiyuk yuhat. Inji naneft ka be hus bugaf yau mmo hanyhato bandrongfa muhmn myahot bani rpat dmetf yohnirahf. ");
INSERT INTO amp_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Nhai wom yonr yuhre wandfa kunys toh hanyetr rorhu dukefm bmbri wandfafarhum kanjo rhukahmr. Nhai. Ror nd yonr afo skur hany bi skur bugahato fekrt safekfot, ee btn rorhu safekfot tisarhut kanjo korht. ");
INSERT INTO amp_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","42","Tamohmpno ni womnhu nyingatikt thu kasi rafoyuk yonmari doh mkut yaktafo duha tfit yamuka womrhu nyingam rhuyuk krpum ayak thuhiyanr? Be tunhu nefm kak wuna bowunewun. Afo ninhu nyingatikt thu rafoyuk doh mkut yak rihtafhato ee yukatoh marnya hanyruhann, btn womrhu nyingam rhuyuk krpum yak thuhirahnr.” ");
INSERT INTO amp_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Hifa sinya warho marnyet mis nhai tfit fasoh yukha behohm hirkahmt. Fasoh sinya warho marnya duha mis nhaf inji buga, nhai tfit hifa yukham hirkahmt. ");
INSERT INTO amp_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Yimam yukhamn hti nhtewum. Yukham hifayem kangm ee nd mis tu hifa dborioh miyet. Yukham fasohem, kangm o nd mis fasohet. Yimam fik yukha yakneft nhai yiro higef bufuyet tkitrohm yakkahm. Yo wain mtithu yukha yakneft nhaf nhai nd higef bufuyet tkitrohm yakkahm. ");
INSERT INTO amp_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Yimar, tu hifa dborioh yima rifuhetr, tu hifa mrokfo rifhur, tu hifa dborioh nefm mfrfnahnewumr. Fasoh yima yuhetr fasoh fasoh nefm mfrfnahnewumr. Yima yuhur rhuyuk tamoh tamoh mrokfo rifhur tfit tngtn ptha nriyafwotm.” ");
INSERT INTO amp_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Tamohmpno naku kfo yamukako Broye! Broye! Na inji nakutahat to btn wakhikkomt nanhu mrokfot. To tamohmpno yak hik duha yitakomt. ");
INSERT INTO amp_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Fitoh yimar nanhu mrokfom wanyhato yak hikwa nmbuhat, afo kfo nhombraruhanko. ");
INSERT INTO amp_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nd nanhu mrokfom wany yakiowet yimar, tu hifa duka tungunet yimam kanjo rorhu kuny hingrneft, muhm tou hauhnihato yiro tahi siktpno rahu pokm simene simenim hmbriyafhato be nd simen tahimn hatohkfot rahum. Nhai ninor ba inji nakfot. Hnut wuhnu sinyaneft nhai nd kunyr tadboutakhato suhkfot. Bi nd yonmari simen tahi sikt hatohet kunyr to finji kanjo suhkfot. ");
INSERT INTO amp_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Tfit nd wom yimar, nanhu mrokfom wanyhato yak hik duhatr, nd yimar akfonom yima dukef duhat yimam kanjo rorhu kunys be inji yak brurtahato, hnut nianeft nhai nd kunys toh bmtakfot. Be yudbat hnu buyeft yihom tadboutaknehato tadbombra tubatunikfot.” ");
INSERT INTO amp_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jisasr ndharhof met yindarim mrokfom kfo ptha dbruf tany buga hehato tfit yimor Kaperneamko. ");
INSERT INTO amp_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ndharhof amiroh keptenrhu hingrna yimar dbohneft yakhato be tu bi brboht rhumot nohneft. Nd amiroh keptenr be tu marbitn htamourr nd rorhu hingrna yimar. ");
INSERT INTO amp_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ndnatn Jisasrhu nia mrokfot wanyhato wom Judaroh bro yufet yimam kutewumm “eldam,” rom tkrurafmor Jisasrhu mihtiyakhato rorhu hingrna yimarhu yak marnyaneft. ");
INSERT INTO amp_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","5","Nd yimam yimomn, Jisasr mkfo naku memomr, “Nd yimar tu dborioh yimayer. Nom Judanom hifa kak marnyewurnom. Rorn nd nmoh rhu rifinyuk rmont hingrnamort. Ndnatn waniakahnn, rorhu hingrna yimar wayak marnyatwanr.” ");
INSERT INTO amp_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Be yihom kfakmotmr yimor. Jisasr bi brbo toh hanyetrn, nd amiroh keptenr turhu wom yimatm tkruraf memorm, “Wakfo rafotwakomr, mirahr nanhu kunys aneya. Na nhai dborioh yimayann nanhu kunys nieruhar. ");
INSERT INTO amp_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Yo nhaf na rorpno yinyeft na nhai tu hifa dborioh yimayann yirhoya brbo rorpno. Be inji nndo tohhato be akfokahtr, nanhu hingrna yimar marnyanirahr. ");
INSERT INTO amp_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nanhu toh nmbuhat to inji buga. Na to wom bro yufetrhu yinhitn tohwa. Rorn tamoh tamoh hingrnefm kahukra. Soldiam nanhu yinhit tohwom fitoh yimar kfo kanganr, ‘Wania,’ nd yimar niewur. Kfo kanganr, ‘Wanju,’ nd yimar kitr. O nanhu hingrna yimar tamoh hingrnefm kfiwanr, nd hingrnefm hingrnewurm. Ndnatn na kanga be inji nndo tohhato akfokahtr, nanhu hingrna yimar marnyanirahr.” ");
INSERT INTO amp_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jisasr nd yimarhu mrokfefm wanyhato tuha mrokfo duhatr rhumor. Tfit kekutnihato nd ror hik hanymo yimam kfo memorm, “Barenko, nd yimar nndo wom kmi thofer. Rorhu nkifrar nndohr. Nd mrokfot kfiwatr, nanhu yima yuhur duka kanga, Isrerkort nhai wom yimar htikahanr o wanykahanr kfo mekahra, ‘Be inji nndo tohhato wakfokahtn dbohnet yimar marnyanirahr.’ Nhai. Nhai ndhtet duket yimar htikaha.” ");
INSERT INTO amp_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Be nd yimam nd amiroh keptenr kfo tkrurafmom tfit kunyko yihato mhtimomr nd keptenrhu hingrna yimar bi marnyaniyetrn. ");
INSERT INTO amp_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Tfit hwe nfha nd wom yiharn wom kmit kutewumt Naint ndko yimor. Nhaf nd rorhu disaipermi nd wom womt rpat yimom. ");
INSERT INTO amp_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Yimomn, yuhre memom, “Ka kmi yifhatikt yau hafknenirahnomt”, asha htiyak hanymomm yima gur hanur hnamohat. Nd nohmo yimar wom met dhirthu rpa mif yonr nohemort. Be nd met dhirthu yonr nohmotr, nd kmithu met yindarim hanynhohato memom, “Yopnhorahnomt.” ");
INSERT INTO amp_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Bror nd met dhirt htihato yuhuwafmort. Hti yuhuwafhato kfo memort, “Inji anurwahn.” ");
INSERT INTO amp_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Inji kfonitart, yau yaknihato nd yima gu krokt rim tayoutitrt. Be tfit nd yima gu krokt tita hanyukm afo yihom tohtewum. Yihom toh tewatm, Jisasr kfo kangr, “Na kfiwann nda yima damiage wasinya.” ");
INSERT INTO amp_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Inji kfomotr, be nd bi nohet yima damiagr myenyjwohato mrokfo pthamor. Be Jisasr yaknimorrn, nd yonr mmemtpno rim kfo memor, “Asor bi tfit ninhu yonr.” ");
INSERT INTO amp_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Be yimam nd noheh yimar yak kasinyamo yuhat htihato nhai yima yuhetm rhurmom. Bro yanuheft fakmotm. Yanuheft yakmottm, tfit Bro Nkifrar naku kfo yindhormomko. Kfo memom, “Bro profetr bi niaror. Bro Nkifrar turhu yon kunys miyak htiyakneft bi niaror.” ");
INSERT INTO amp_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Be nd Jisasr noheh yimar yak kasinyamo yuhathu mrokfot nhai wom brbo warhu hasormot. Ur Juda tkit tkitm ur fitoh fitoh tkitm, wany bugamomt Jisasrhu noheh yimarhu kasinya nmbuhat. ");
INSERT INTO amp_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jonrhu uhik ahik htfasyukm nd Jisasr namo neft wanyhato Jonr kfo nuhas bonuhasmomr. ");
INSERT INTO amp_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Jonr wanyhato turhu uhik ahik htfasyuk hus yimaf naku yakhato kfaf memorf, “Brorpno waifn. Waikahfnn, wattiwon wamitwafnr, ‘Ni aso nd nom toh gari hasiwa yima o tor yuhre niewur?’” ");
INSERT INTO amp_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Be nd hus yimaf yimofn, Jisasrpno mfnahhato mkfo memofr, “Jonr famurno, ‘Wattiwon wamitwafnre, “Ni aso nd nom gari hasiwa yima o tor yuhre niewur?” ’” ");
INSERT INTO amp_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nd yihart rof mifnahmohat bok met yindarim womhtet dbohnefetm Jisasr fak marnya hasomor. Bok yimam kmi yarh fknayetm fak marnyamourm, yo nyinga kunyjetm fak marnyamourm. ");
INSERT INTO amp_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","To be ndnettn rof mikfo ttiwonmohat tfit kfaf memorf, “Tfit waikahfnn, Jonr wakfo nuhastwafnr nd nifn hrek htitawo nefm yo wanuka mrokfom. Wakfo nuhastwafnr nd nyinga kunyjetm marnyani yuhat yo wura bebetm marnyani yuhat nd mimbr yaketm marnyani yuhat yo yimbhindang kihmniyetm marnyani yuhat, noheh yimam myenyjwo yuhat yo nd fasoh knbokroh rirhuyuk yimam Bro Nkifrarhu tu mrokfo mifm wanuka yuhat. Nd ndm wakfo nuhas bonuhastwafnr. ");
INSERT INTO amp_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Yo wakfo wamitwafnr, yimam Bro Nkifrar hik hanyhato tfit na niwa nefm mhti yakhato nhai suhkahm, nd yimam ayindhortwam.” ");
INSERT INTO amp_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Be nd yimaf yimof. Yimotf, rofhu mongkorn met yindarim Jonrhu hingrnafathu mrokfom kfo ttiwonmorm. Kfo memorm, “Niko Jonrhu htit yimohat yima toh duha tkitt, tamohm memoko ai ahtinom? Ka memoko yimar mrokfom rim kfota mkfotetr ai ahtinom? ");
INSERT INTO amp_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","O be nd hifa hifa wondh wuska hmbreyet yimar memoko ai ahtinom? Nd yimam hifa hifa wondh wuskam hmbreyetm, ndhtet yimam kingroh kuny kmifam tohwa yimayem. ");
INSERT INTO amp_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","To nikome tamohroh htit yimoko? Profetrhu htit yimoko? Akfoyanko. Ror tu profeter. Bingotroh profetroh hingrneft nhai rorhu hingrneft kanjo rhukaht. Nhai. ");
INSERT INTO amp_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Tor nd yima Jonrn Bro Nkifrarhu rfa borngt kfo memot, ‘Wawanyko Bro Nkifrarhu mrokfefthu kfo nuhas hanyuk yimar tohak hanyrahrko. Rorn yihotar mngon hanyrahrr.’ ");
INSERT INTO amp_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Na kfiwanko, Jonrhu yufat be tu broyet, nhai wom yimar Jonrhu yufat kanjo rhukaht. To tfit kfiwanko, fitoh yimarn tu Bro Nkifrarhu kingdomkfotn ftohr, tor nd yimarn tu bro yufa mift yakrahr.” ");
INSERT INTO amp_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Nd met yindarimi takis marut yakyuk yimam bi Jonrpno baftais yaketmn tfit Jisasr nd mrokfom kfo pthamohat rom sinyahato kfo memom, “Bro Nkifrarhu mrokfot tu fipayetet.” ");
INSERT INTO amp_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","To tfit Farisimi boririfhuthu tisamn nhai wany yindhorrmomt. Hany jbornamomt Jonr pthamo mrokfot yo nhai wofnrmom Jonrhu rroh baftaisneft. ");
INSERT INTO amp_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jisasr tfit pthahato kfo memor, “Ar yiharhof yimam tamoh shrmn akfo nhombrayanm? Finji kanjo yorhwam? ");
INSERT INTO amp_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Yon mumenm maket swirm o wumt swirm rhuhato nnakfo nnakfiwa kanjo nnakfiwuko. Womm rirhuhato womm rikfo mirahmm, ‘Nom tuhan yindarif niyak tatrutwa yiha wumtwa musikkfot wumtnomt, niko nhai grharfoko. Nur windohm mayi nmbuhampno rpat windohnomm, niko nhai nurrfoko.’ Inji yon mumenm kanjo nnakfo nnakfiwuko. ");
INSERT INTO amp_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Jon baftaisr niamohat, ror nhai nuwa ya bupa yarmor. Ndtn niko hti kfo memoko, ‘O Jonr fasoh kmi yarhm fknemomr. Nhai nuwa bupa yekahr.’ Inji kfomokomr. ");
INSERT INTO amp_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Tfit ar yihat na nikmoh tu Bro Najema niamohat, bupa nuwa yewota, tfit ndt htihato tfit kfo kangko, ‘Wahtiko nd yimar nuwa yemungrofoter yo spaket drinkfot masat hmbritarn spakwor. Yo takis yekwa yimami fasoh nefm niwa yimampno nabnot habriwor.’ Inji inji kfiwukma. ");
INSERT INTO amp_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Bro Nkifrarhu duka tungunefrn tamoh tamoh nefm mhfnahnewatrm, nd tkittn yimam htihato kfo kangm yafotheter nd rorhu dukefr.” ");
INSERT INTO amp_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisir yihato Jisasr kfo memorr, “Krif waniakahnn nanhu kunysn nuwa yerahno.” To be Jisasr nd Farisirhu kunys yihato nuwa famor. ");
INSERT INTO amp_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","To nd kmitn wom fasoh nefm nayet mett tohmout. Ndha tohettn, wanymot Jisasr nd Farisirhu kunyshu nia nuwa ye nmbuhat. Rot inji wanyhato fakmot tahiye hingrnayet wel knt. Yakhato yimot nd Jisasr rhumo kunysn. ");
INSERT INTO amp_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Rot nd mett yimotn, Jisasrpno mtohmot. Mtohhato nurmout. Nurhato nd rothu nur nyingaroh bupam yima Jisasrhu wuramn mitohmoum. Mitohmotm, tfit yimathu tmarifaye trk domtmoutm. Inji na hanymotn, yimarhu wurat rithu kiyakmotrn, frhaddohato nd rot hanymo welpaye wuram fuk wunamotr. ");
INSERT INTO amp_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nd Jisasr naku yakmo Farisir inji htihato be yima yuhurn duka memor, “Ndar yimar tu profet mifr arhur, to bi hti nhtarfort nd mett ror tir htewat. Ndt nhai tu dborioh mett tir htakahtr, fasoh fasoh nefm nayet metet.” ");
INSERT INTO amp_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jisasr inji wanyhato kfo memorr, “Saimon, na wom mrokfeft ninpno afo kforhota wawanyswa.” Saimon memor, “Yinowe injuwe, waptha.” ");
INSERT INTO amp_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jisasr kfo memorr, “Wom hus yimaf wom yimarpno maruha fakmof. Memof, ‘Kto tfit maruhetenone hirahnomn.’ Wom yimarn 100 kinakfot fakmor. Womrn 10 kinakfot fakmor. ");
INSERT INTO amp_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Be tfit kto nhai womr niahato nd rof yaknimo maruham tfit hermofr. Be nd maru tikat yimar garitihato nhai tfit marimor, ‘Tfit wompam naku tndau hatohruha.’ Be duka mumafmorf. To ni Saimonn waduka nd hus yimaf. Frohrn yirforn nd yimar namo dborioh neft kfo yindorrforr? Nd bro marufa yakmorn o habhi marufa yakmo yimarn?” ");
INSERT INTO amp_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimonr memor, “Na kanga nd bro marufa yakmo yimarn yihato kfo yindhorrforr.” Jisasr memorr, “Uwa hifa kfiwun.” ");
INSERT INTO amp_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jisasr kekutnihato mett htihato Saimonr kfo memorr, “Htitwont ndar mett? Na ninhu kunys niehat, nhai bupam yakrfonn, wuram yuk kifsarfona. Nhai. Wahti ndar mettn, niesn rothu nur bu nyingaye fuk kifsetm nanhu wuram, yo rothu tmarshu tmarifaye trk domttm. ");
INSERT INTO amp_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Yo na ninhu kunys nia yarim rhuhat ni nhai rithu kiyakhato frhaddorfona. Nhai. Ndar mett niahato nanhu wuram yakhato frhadditm. ");
INSERT INTO amp_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ni nhai welpaye yukrfont nanhu mfhat. Ndar mettn niahato nanhu wuram welpaye fuk wunita. ");
INSERT INTO amp_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Ndnatn na kifwann, nd mett namo boknabok fasoh fasoh nefm bi fak thu ahuyant bi. Ndnatn na masat yuhu mongisa. Nd yimar habhi nefenm yak thu hayetr, be inji tefinano yuhu mongiwora.” ");
INSERT INTO amp_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Be nd mett Jisasr kfo memort, “Ninhu fasoh fasoh nefm bi fak tuhahuyann.” ");
INSERT INTO amp_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Be nd rpa tebort rhu hasoyuk yimam tum rinakfo nakfo memom, “Ndre tamohtet yimarn, yimaroh fasoh fasoh nefm yak tuhahukarm?” ");
INSERT INTO amp_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Nd mett Jisasr kfo memort, “Ni Bro Nkifrar yak hikwa nmbuhatn fak marnyern. Hifa yindhor yima yuhurpno wanju.” ");
INSERT INTO amp_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Kto tfit nd wom yiharn Jisasr sinyanihato yi htfasmor kmi kmi. Yi habrihato kfo nuhas bonuhas habrimorm Bro Nkifrarhu kingdomkfot. Nd 12-pela yimam rorpno yau habrimoam rpat yimom. ");
INSERT INTO amp_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Yo nd metm bi barkof Jisasr tohhato rroh dbohnefmi rroh kmi yarhm yak thu hemom, rom rpat Jisasr hik hanymom. Nd metmpno yimo wom metthu yufat, Mariat, Makdala efkfott. Nd mett rot tohmohat 7-pela kmi yarhm fknemotmt, Jisasr fak thumorm. ");
INSERT INTO amp_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yo Herotrhu kuny kmifat tohukatohyuk yima Susarhu met Joanati Susanat yo wom metm rpat hik hanymomr. Nd metmn hik hanyhato tamoh tamohm romn hti duka hanymoumm. Yeshri nd ndm rroh maruhaye wiknahato he bmta hanymoumm. Yo hweyuk tkitm nhaf romn wiknamoatm hwemoum. ");
INSERT INTO amp_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Wom yiha kmi kmirhof yimam mano mano rifiny hmbri yaknamomr Jisasr. Rifiny hmbri yak namotmr, wom kfo nhombra mrokfot kfomorm. Memorm, ");
INSERT INTO amp_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Wom yimar mswirt hingrnahato wit tpim yaknihato thu brur htfasmorm. Wom tpim yihota yau yuhat misuhmom. Kto yimam wiyau yauhato yahot turnamotmm, nungam niahato tout buganimomm. ");
INSERT INTO amp_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Wom tpim misuh hanymoum tahi siket tkitmn. Kto dborhanihato memom ka nembfa thuhato sinyarahnom, to nhai, bbinysoft yiro bupa duhattn, be fftahato nohmom. ");
INSERT INTO amp_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Womm hig suhmpno misuh hanyyukm rpat hig tofmpno sinyahato kihawot hmbriyaf-momm. ");
INSERT INTO amp_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Wom tpim tu hifa dborioh bbinysoft misuh hanyukm, romn tu hifa sinya marnyahato 100 dmet 100 dmet hir hanymom rpa rpa yewuri fanm.” Nd kfo nhombra mrokfot kfonihato kfo memorm, “Yimbhin-dangeteko, ndar na kfiwa mrokfot wanykfot.” ");
INSERT INTO amp_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nd kfo nhombra mrokfom turhu disaiperm wanyhato ttiwon memomr, “Nd kfo nhombra mrokforoh yimbu yuhame finji yorhwam?” ");
INSERT INTO amp_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jisasr kfo memorm, “Wanukko, yafuna mrokforoh yakyuk dukefr bi nikomn hemor. Bro Nkifrarhu kingdomkfothu kafrohet mrokfom be kfo nhombra kanjo ptharahm o mrokfom be yura yafunarahm, nikomn dukefm bi yakrahkomm. Wom yimam be kfo nhombra mrokforpam wanukm. Ndnettn tamohroh htineft nhai hti hikruhatmm. Mrokfo wanyneft rot nhaf inji wanyeft rot wanyrahm, tawo mrokfo yimbu yuhamn nhai wany hik marnyaruhatmm.” ");
INSERT INTO amp_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Jisasr kfo memorm, “Nd kfo nhombramo mrokfo yimbu yuhat inji korht: Nd yewuri tpim, Bro Nkifrarhu mrokfot kfo nhombramoya. ");
INSERT INTO amp_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Nd na kfo nhombra memo yewuri tpim yima yau yuhat misuh hanyukm, nungam niahato toutnimom, ndm Satanr nunga hafise niahato yimaroh yima yuhum rhuyuk hifa dborioh mrokfom nia yak thuwa nmbuhat kfo nhombramoya. Satanr kangr Bro Nkifrar hikruhamn, hbhakrahrm. Ndnetrn kak thuworm tu hifa dborioh mrokfom. ");
INSERT INTO amp_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Yo nd tahi sikm misuhhato sinya duha yewuri tpim, ndm kfo nhombramoya yimar Bro Nkifrarhu mrokfot yakitoh bmta duha yita nmbuhatn. Yimam afo barkofpam hifa yindhor nmbuhatpno Bro Nkifrarhu mrokfot mhik tefi yaknitmt, tfit tamoh nefm rinhebeh-efiwumm, to be ndha msuhhato myafho thunitmt dborioh mrokfot. ");
INSERT INTO amp_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Yo nd yewuri tpim hig suhmn misuhwam, ndm kfo nhombramoya yimam Bro Nkifrarhu mrokfom wanyhato tfit myafho tuhefiwa nmbuhamn. Yimam mrokfom wanukamn, tfit ndar bbinysofthu dukefm kak wunefiwumt Bro Nkifrarhu mrokfeft. Womm tum hatohyuk krho nmbuhamn, ndmn be duka kinyaki hasiwum. Womm maruharoh dukefrpampno korh hasiwum. Womm hifa rhu nmbuharhu yaknefrpatn duka hasiwum. Nd nd dukefmn thu nhombranitatmm, Bro Nkifrarhu mrokfeft myafho thunitmt. ");
INSERT INTO amp_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Nd hifa bbinysoft misuhhato sinya marnyamo yewuri tpim, kfo nhombramoya nd yimam mrokfom wany yakiohato yakitoh dbkafwa yimamn. Nd yimam tu hifa yima yuhet yimamn, rroh wiyauyau nmbuham hifa kau marnyewum.” ");
INSERT INTO amp_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Nhai wom yimar lamt yakhato yiro rohtn kafko hmbriyafkahrt o nhai wom yimar lamt yakhato yiro tik rfashitn hta hamongafkahrt. Nhai. Be inji dany yuhat htewatrt, rorhu kunys yarim fkninayuk yimam lamthu nukeft htitwomt. ");
INSERT INTO amp_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Nd kfo nhombra mrokfothu yimbu yuhat inji kfiwut. Bro Nkifrar, rorhu kfo kafrohet mrokfeft kto be tafontn yak htarahrt. Nd tamoh tamohm Bro Nkifrar yak wuna bowuna hasiwam, kto be tafontn yak htaruhatrm yimam htirahmm. ");
INSERT INTO amp_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ndnettn wany marnyakfot. Frohr mrokfom wanyhato yima yuhurn hmbri hterm, nd yimar Bro Nkifrar tfit thu hmbrihirahrr. Nd yimar mrokfom wanyhato nhai yima yuhur htarform, nd tefi dukefenr rorhu yima yuhur rhuyukr tfit tu Bro Nkifrarn yak thurahrr.” ");
INSERT INTO amp_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nd yiha Jisasrhu mmemti nmem najohfit niahato memom, “Jisasr ania ahtinom.” Niamomn, to be bok met yindarim rifinymotm nhai brbo yirmom Jisasrpno. ");
INSERT INTO amp_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Wom yimar yihato Jisasr kfo memorr, “Ninhu mmemti nmem najohfit tom niem. Niemn, kangm ahtinomn.” ");
INSERT INTO amp_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jisasr inji wanyhato kfo memor, “Fitoh yimam Bro Nkifrarhu mrokfefm wanyhato yak hikwam, nd yimam nanhu mmemroyem yo nanhu nmemroyem.” ");
INSERT INTO amp_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Wom yiha Jisasri turhu disaipermpno mmbrtn mirhuhato Jisasr kfo memorm, “Barenko, na kanga tek barit ahir tmbhonikahnomn, mkuko ainyom.” Be inji kfohato yimom. ");
INSERT INTO amp_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Tek yuhat hir hanyhato Jisasr hwemor. Ror hweyetrn, bro wifort sinyahato fryif hany titamotm. ");
INSERT INTO amp_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Be nd disaiperm yihato Jisasr naku thuhato kfo memomr, “Broye, Broye nom bi wifort fryif boyifwotnom!” Be ror sinyahato nd wiforti nd bu rifhum sinyamom kfomotr, minoh hmbremom. ");
INSERT INTO amp_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nd wiforti bu rifhum yak nohnihato kfo memorm, “Tamohmpno yakrmitako? Nhai duka mekahko, ‘Rorpno kitwonom. Aduka yanho-wahnom?’” Rom inji wany yanhohato kfo memom, “Arre tamohtet yimarn be tnge pthitr wiforti bu rifhu sinyayukm wany yakiohato minoh hmbrenim?” ");
INSERT INTO amp_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Be rom hir hany hir hanymomn, Gerasat rifnahmom. ");
INSERT INTO amp_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Nd kmit rifnahhato nd kmithu wom kmi yarh thu hamumet yimar niamor. Nd kmi yarhr thu hammomoatrr, to be sfnoh bubombrohr tohmour. Ror tohmoahat nhai yima kunym tohrmoar, be inji nd yima gum htamoa tahi bakuny mkumn toh htfasmour. ");
INSERT INTO amp_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Be nd yimar Jisasr htiyakhato rorhu wurampno rim suhhato mtau ssiyakni memor, “Jisas yura myorhekwa Nkifrarhu Yone, ni finji newona? Mirahn krho nmbuhat ahiyanr.” ");
INSERT INTO amp_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Jisasr bi kfo twanhomor nd yimar thu hammomoa kmi yarhrhu htanyeft nd yimar. Yiha yiha nd kmi yarhr tuhagrha mmomour nd yimar. Tuhagrhamoatrr, yimam to be rorn dukahato kukatoh hasomoum. Womnam sene ttaftamoumr, womnam tasomukr hanyhato kimoumr. To nhai, frtebikrnihato yimour. Womnam nd kmi yarhrn tuhafunanimoarr hanymourr wuri yima toh duha tkitmn. ");
INSERT INTO amp_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jisas kfo memorr, “Ninhu yufat wayutant.” Nd yimar bok kmi yarh rifhur fknemotmr to be kfo memor, “Rifuhetenom.” ");
INSERT INTO amp_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Nd yimar fknehato tohmo kmi yarhm Jisasr kfo nakuhato kfo memoum, “Nom nhai wofnkahnom kmi yarhm mihmbrita muhrhu yinyeft. Nd muhr yiruhanomn, to finji tfit nieruhanom? Mirahn ndko akfo tkrurafanm. ");
INSERT INTO amp_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Wahti, wusomio kmi yorgenrn foh rifhum. Be wakfafkahtnnom, nd fohmn fkneni hanyrahnom.” ");
INSERT INTO amp_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Be Jisasr kfomotr nd kmi yarhm nd yimar thu troh tanyhato fohmn fkneni hanymom. Be fohmn fknenihato thu hafunanimotmm, nd fohm kmi kihahir yuhat mitarhotnihato tek baritn mitayif wurasoh bugamom. ");
INSERT INTO amp_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Nd fohm hatohmo yimam inji htihato be tonayefrpar yakhato taunthu yimam kfo nuhas bonuhashato kmi kmi kfo nuhas fnahmomm rom htimo nefm. ");
INSERT INTO amp_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Kmi kmim wanyhato yi hanyhato memom ahtinom. Rom yimomn, nd yimar kmi yarh htanyetr htimomr rmonthat tabhutahato tu hifa yima yuhu dukefrpno Jisasrhu wurampno rhu hasetrn. Rom be inji mhtihato be duka yanuhefrpno tohmom. ");
INSERT INTO amp_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Jisasr nd kmi yarh fknayet yimar yak marnyamohat tuha tohyuk yimam hti hikmomr romn tfit kfo nuhas bonuhas hikmomm nd niamo yimam. ");
INSERT INTO amp_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Be nd Gerasa thofm Jisasr namo nefm hti yakrmihato kfo memomr, “Ni be tmifn ndar kmit wahtanykahnt, wainy.” Be Jisasr mmbrtn mikmbrenihato tfit yimor. ");
INSERT INTO amp_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Nd Jisasr kmi yarh yak thumo yimar tfit Jisasrpno yihato kfo ttiwon memorr, “Ahikann?” To nhai, Jisasr wanyhato kfo rafo tany memorr, ");
INSERT INTO amp_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Tuha kmitn warhu hasokahnn kmi thofm wakfo nuhas bonuhastwanm ni Bro Nkifrar yak marnyamo nmbuhat.” Be nd yimar wany yakiohato tuha turhu kmitn rhu hasohato turhu kmi thofm kfo nuhas bonuhasmorm Jisasr yak marnyamo nmbuhat. ");
INSERT INTO amp_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jisasr tfit manoh tek barithu kmi mkuko hir hayuknimohat nd tek bari mkukorhof yimam bi rhu gari hasetmn, to be Jisasr hti yakmohat be tir tir fakmomr. ");
INSERT INTO amp_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Be yuhre mtoh tefi hanymor, wom yimar kutewumr Jairusr niamor. Nd yima Jairusr Judaroh rhu rifinyuk rmont tohukatohmour. Ror niahato Jisasrhu wurampno msuhhato mkfo memor, “Jisase, wania. Ainyo nanhu kunyko.” ");
INSERT INTO amp_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Ror inji mkfomohat, rorhu 12 gunyjimet yont noh wururifhut yakmott inji mkfomor. Ror nhai bok yonm. Rorhut nd yon metrpat. Jisasr yimohat be bok met yindari rifhur hik hanymomrn be nahuta yaborr hanymom. ");
INSERT INTO amp_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nd yima rifiny buharn wom dbottet mett fau hanymot. Nd dbotteft 12-pela gunyjimm hatohmott. Bro hunkothampno yimout, to nhai yak marnyarmoamt. Be rroh wiknaneftpno yonmari marut tamoh tamoh shrt tubatu witamott. ");
INSERT INTO amp_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Be Jisasrhu mongko yauyaknimotn, ror hmbreyuk hmbreshathu psift mfak tiwonafmot. Be inji namott, yudbat nd dbotteft teh tmbhakmott. ");
INSERT INTO amp_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jisasr yironafhato ttiwon memor, “Na frohr tayoutitawora?” Pitar memorr, “Ka yimam yau hanyhato mtayoutinimn.” ");
INSERT INTO amp_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Jisasr memor, “Tu yima mifr tayoutira. Na tuka yironefiya yima yak marnyayuk yafothat yimar yak marnyehat.” ");
INSERT INTO amp_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Tu nd mett duka memot, “To finji wom finji kafrohrhoya? Bi htitawora.” Be tuha mrokfo duha Jisasrhu wurampno rim suhmot. Rim suhhato tuha yima rifiny buharn kfo ptha nuhas bonuhas nriyafmotm nd rot Jisasr rim tayoutihato rothu dbotteft teh tmbhakmo yuhat. ");
INSERT INTO amp_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jisasr kfo memort, “O ar yone, nd ninhu dbotteft, nd hatoh hnamot, duka famu, ‘Ror rimaktirhota, be nd dbotteft teh tmbhakraht.’ Ndnettn ninhu dukef yuhatn nd dbotteft teh tmbhektn. Be hifa yindhor yima yuhurpno waikahnn, watohtwa.” ");
INSERT INTO amp_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jisasr yuhre nd mettpno nakfo nuhas hasiwume, asha nd Jairusrhu kuny shofr toni hnehato Jairusr yihom kfo kangrr, “Mirahn Bror ahany furayanr kunykort. Ninhu yont bi mfaknit.” ");
INSERT INTO amp_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Jisasr nd mrokfot wanyhato, Jairusr kfo kangrr, “Ni bi mirahn ariduka yanuhaka. Ninhu bro dukeft waduka wame, ‘Nanhu yont tfit myenyjworaht.’ Be nd dukefrpat arhukahtn, be tfit marnyaniraht.” ");
INSERT INTO amp_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Jisasr yimorn, Jairusrhu kunys mfnahhato fknenimohat nd wom womt kfo rafo tanymorm kunyrhu fknenineft. Pita, Jon, Jemsromrpampno, nd nohyuk yonthu yifammampno rhumomt nd yima gus rhumo rumt. ");
INSERT INTO amp_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Yimam nd yima gus hanurmoatm Jisasr kfo memorm, “Anurwahko. Nd yont nhai nohrfot, be hwitwot!” ");
INSERT INTO amp_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Jisasr inji kfomotr, nd met yindarim haningemomr. Rroh dukeft duka memom, “Bi nohett to finji wom finji sinyaruhat?” Ndnatn haningemomr. ");
INSERT INTO amp_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Jisasr nd yonthu tirt yakitohhato yufat yutahato kfo naku memor, “Ar yone wasinya.” ");
INSERT INTO amp_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Inji kfo nakumotr nd yonthu yafothat tfit mthu nawohhato sinyamot. Nd yont tfit myenyjwomott, kfo memorm, “Yeshrim wayak wahefnt.” ");
INSERT INTO amp_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Yonthu yifammaf inji htihato be tuha yafotha duhatf tohmof. Jisasr kfo memorf, “You! Mirahfn akfo nuhas mif mifnomm nda nifnhu yont myenyjwi yuhat.” ");
INSERT INTO amp_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jisasr turhu disaiperm kfakhato niamotm, tek yarh kmi yarh yak thuyuk yafothar hiyaf hanymorm. ");
INSERT INTO amp_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nd yafothar henyihato kfo memorm, “Wanjukahkomn, yimam wakfo wamitwakomm, ‘Bro Nkifrarhu kingdomkfotn tfit ndar bbinysoft rhuraht.’ Nd mrokfot kfo nuhas hi hanyhato yo tamoh dbohnet yimam htitwokomm, wayak marnya hanyswakomm.” ");
INSERT INTO amp_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Rom sinyani yimohat memorm, “Yinyeft mirahko kio musm, hmbre wus yohm, nuwa nakupam, maruham, hmbresham ayakitohaknom. Be inji sfno yikfot. ");
INSERT INTO amp_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Yihato wom kmit yak miyakhato, kunys fahumko, be nd kunyrpat toh tanyhato tfit sinyani yikfot. ");
INSERT INTO amp_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","O wom kmit o taunt yihato nhai kunym yak miyakhato niko hanyuk mrokfom nhai yindhorkahm wanyneft, nd kmit htanyhato fus wuram tuha nd kmitn frdbofta tanyhato htanykfot. Inji naruhatko, ndt htiruhamn, mirahm, ‘O nom yak miyak duha yitnomm inji nem.’” ");
INSERT INTO amp_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Be inji kfo hta bohtafmotrm, yimom. Kmi kmi yihato Bro Nkifrarhu mrokfeft kfo nuhas hanyhato dbohnet yimam, kmi yarh fknayetm fak marnya habrimomm. ");
INSERT INTO amp_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Galilikorhof kmim tohukatohmoa yima Herotr Jisasr namo nefm wany-hato bok dukefm fakmor. Womm yihato kfo memomr, “Nohmo Jon Baftaisr tfit mfnahmor.” ");
INSERT INTO amp_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Womm yihato kfo memomr, “Ka Iraijayer.” Tfit womm yihato kfo memomr, “Ka bingot nkiframpno nohyuk profetr sinyamor.” ");
INSERT INTO amp_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Inji mikfota mkfotamoatm, Herotr kfo memor, “Niko kfiwa Jonr to bi mfhat puk tmbhomoyanr. To nd yimar frohrn ndhtet ndhtet nefm newatrm mrokfefm wanukanomr. Afo yi htiruhanr.” ");
INSERT INTO amp_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nd Jisasrhu yon kunyshu kasinya htfasyuk aposerm yi habrimomn, tfit niahato Jisasrpno mptha nuhas bonuhasmomr rom nahabrimo nefm. Be tfit romrpam Jisasr yaknimorn tfit wom kmit yimom. Nd rom yimo kmithu yufat Betsaidat. ");
INSERT INTO amp_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Met yindarim wanymom Jisasrhu Betsaidathu yi nmbuhat. Wanyhato fau hik hanymomr. Jisasr hti yakhato memor, “O hifa nieko.” Yo Bro Nkifrarhu kingdom-kfothu mrokfot yakhato kfo nuhas bonuhasmorm. Ndm kfo nuhasni, yo nd yi hanyuk dbohnet yimam, dbohnefm fak thu hany hemorm. ");
INSERT INTO amp_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Tu krifnanorn, disaiperm niahato Jisasr mkfo memomr, “Nom kangnom nd met yindarim be tmifm wakfo tkrurafkahtnm, natubatunim. Natubatunikahmn, hweyuk tkitm hambrokahmn, nuwa yemska rhurahm. To asha yorhwamn, fitoh yimam nuwami hweyuk tkitm yahukamm? Asha yima duha tkitt korhnom.” ");
INSERT INTO amp_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jisasr inji wanyhato kfo memorm, “To nikomn wahekomm yeshrim.” Tfit rom memom, “To nom href fitha yeshrim yakhato yahukanomm? Nome tirfa bret nuwami hus yiraf, injirpa kakitohwonom. E, be kangn maruhaye yeshrt wiknahato ndar yonmari yima rifhur ahenomm?” ");
INSERT INTO amp_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Nd yihar 5,000 yimam rifinymom. Jisasr turhu disaiperm kfo memorm, “Nd yimam wakfokahtkomm fifti fifti inji arhu nhombra hanym. Wom tkittn wom fiftikfot rhukfot, tfit wom tkittn wom fiftikfot rhukfot. To be inji rhu nhombra hanykfot.” ");
INSERT INTO amp_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Nd Jisasr kfomo yuhatn fak hta nhombramomm. ");
INSERT INTO amp_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Rhu nhombramotm, Jisasr nd tirfa bret nuwami hus yiraf yakmorn, yura mountko yukatohhato kfo bruttnamor. Kfo bruttnanihato turhu disaiperm yak tifakhany hiyaf hanyhato kfo memorm, “Wahe nhombra htfas hanykomm.” ");
INSERT INTO amp_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nd he hanymo yeshrt nd yonmari yima rifhur yihany yi hanymomn, yatim furkihmomm. Yatim furkihmotmm, be nd yesmbhehm yak nhafohhato tfit 12-pela kpmn hmbre nhafohmomm. ");
INSERT INTO amp_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Wom yiha Jisasr turpar Bro Nkifrarpno kfo bruttnamohat turhu disaiperm rom tom rhumom. Ruhetmn, kfo ttiwon memorm, “Nane, met yindarim finji dukewuma?” ");
INSERT INTO amp_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Kfo memomr, “Womm kangmn Jon Baftaise. Womm kangmn Iraijaye. Womm kangmn wom nkifra profetr tfit sinyamor.” ");
INSERT INTO amp_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Inji kfomotm, tfit ttiwon memorm, “To niko tuko finji yutewukma?” Pitar kfo memor, “Ni kangnomn nmoh hbhayeme, Bro Nkifrar kfo tkrurafmorn nmoh minrfa htiyakyukn.” ");
INSERT INTO amp_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pitar inji kfomotr, Jisasr kfo nnhu memorm, “You! Mirahko wom yimampno nd ni kfi mrokfot akfo nuhas mifnomm. Be nikomrpakompno nd mrokfot ayohnes.” ");
INSERT INTO amp_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Kfo memorm, “Na, Bro Najema, boknabok krhopam yakruha. Na Judaroh bro yimamn, prisroh bro yimamn, boririfhuthu tisamn, nd nd yimaroh tirmn hirruha. Nohrhoyann tfit husfirpehyuk marrn tfit sinyaruha. Na nhai tfit finji kfo finji kforhota. Na be yi nohnefrpat.” ");
INSERT INTO amp_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ndm kfonihato kfo memorm, “Wom yimar kangr, nann ahika, nd yimar mirahr tamoh tamoh nefm turhu duka fijo anaya. Ror be na yakitoh dbkafhato nd mano mano niayuk krho nmbuham rpa rpa yihar titahato toh bmtakfot. ");
INSERT INTO amp_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Fitoh yimar turhu toh nmbuharpat dukahato nhai wofnkahr na hikhato krhopa yakneft, kto nd yimar be nhai hifa rhu nmbuhat yakruhatr. Fitoh yimar na dukahato bro krhopam yakhato ftohr, kto nd yimar hifa rhu nmbuhat yakrahr. ");
INSERT INTO amp_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Wom yimar ndar bbinysofthu tamoh tamohrpar yakhato kto toh nkifrayuk toh nmbuhat nhai dukarfort, to nd ariha yekwa marut, wuskat, tamoh tamoht kto to finji hifa toh nkifra nmbuhat hiruhamr? ");
INSERT INTO amp_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Frohr yak rihtefiwura yo nanhu mrokfeft yak rihtefiwurt, be nd yimar tawo na Bro Najema yak rihtafruhanr. Na nia thombat nani Bro Yifemre tu dborioh mounmotm, nmoh nukeftpno yawih-nehato yak rihtafruhanr. ");
INSERT INTO amp_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Kfo mifwanko, nikmoh womm tafi noh duhatmn, htirahmt Bro Nkifrarhu kingdomkfot rhu thombat.” ");
INSERT INTO amp_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nd ror kfomo mrokfom kto 8-pela marm tohnihato ee Pitari Jonre yo Jemsr nd husfirpa yimam yaknihato kminysofko kfo bruttnat muhmom. ");
INSERT INTO amp_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Muhhato Jisasr kfo bruttna hanymor, yimarhu nyingatikt fnhuyaknihato memom nndo yindeng nyisofr fnhutwor. Yimar hmbremo hmbresham rpat fnhu bugaknihato memom nndo bruwohmr katiwur. ");
INSERT INTO amp_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Nd fnhuyeftpno asha Moses Iraijarof niahato Jisasrpno mitohhato napthamom. ");
INSERT INTO amp_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Kfo nuhas bonuhas memofr, “Ni Jerusalemrn nohrahn. Bro Nkifrar bingot kfo htamo mrokfot ndha Jerusalemrn rhuraht.” ");
INSERT INTO amp_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pitari nd wom yimaf nyingam krkotakmotmm, memom, “Ahwinom.” To nhai, be nd Jisasr hatohmo funefti nd mitoh hmbremo yimaf htihato nhai marimom hwirahnom. ");
INSERT INTO amp_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nd yimaf Jisasrpno mitohmof, memof, ka Jisasr htanyhato ainyo. Pitar memorr, “Broye, nmoh asha tohneft hifa. Ka husfirpa kunyenm yimanom nhombra-hato singorahnom. Ninhu womt, Mosesrhu womt, yo Iraijarhu womt.” (Pitar inji kfomohat nhai tu hifa yima dukefrpno ptharmor. Be tngrpatn furamott nd mrokfot.) ");
INSERT INTO amp_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Inji ptha hanyetrn, yudbat gribt wuyohninamotn thu kasi hmbriyafmotm. Gribt thu kasi hmbriyafmottm, disaiperm fakrmemom. ");
INSERT INTO amp_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Nd gribpamn wom tngt wanymomt, kfo memot, “Nd yonr nanhu yoner. Nanhu yufatn tohwor. Ror pthayuk mrokfom wawany yakiotwakomm.” ");
INSERT INTO amp_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nd tngt inji pthanimott, kto htimomr Jisasr turpar toh hasomor. Be rom inji htihato nhai tfit wommpno yihato kfo nuhasrmomm nd rom htimo nefm. ");
INSERT INTO amp_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Tfit nd wom yiharn Jisasrom yura kminysoft wuhtanyhato yohnemom. Rom yohnemohat yonmari yima rifhur Jisasrpno mnafuryakmom buha yihotatn. ");
INSERT INTO amp_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nd Jisasrpno mnafuryakmo yimaroh womr sinyahato Jisasr naku kfo memorr, “Broye, na kanga nanhu yonr wania wahtihina. Na nhai bok yonm. Nanhu yonr ndarrpar. ");
INSERT INTO amp_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Mumoyeft kekwotr. Nd yarhr fkniyaknehato mmo rifhut yakakne thombat, yima yonr masat tau naku bonaku yaknitr. Tau naku yaknihato suhwor. Suhhato yebittaknihato tir wuram tubatuhato brukt brukt hatoh thombat kangm nndo foher. Nd mumeft hatoh hasiwartn, tfit thu troh tany shombat, be yimar kak tehtewur. ");
INSERT INTO amp_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ninhu disaipermpno kfo famuyanm, ‘Wayak thukomr yarhr.’ To nhai, fak thu titawomr.” ");
INSERT INTO amp_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jisasr nd mrokfot wanyhato kfo memorm, “Ye, aromenkono! Niko be tu nhai Bro Nkifrarpno nikmoh dukefm htakahkomm. Ar nohof nikompno ritohakhato nikmoh krhopam titahnamoyanm? Wahnanr nd ninhu yonr.” ");
INSERT INTO amp_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nd yimarhu yonr yuhre yau hnetrn, ka nd yarhrn thu mumak-nimotrr, nd yonenr suhhato yebittak-nimor. Jisasr inji htihato nd yarhr kfo nambur hikafmotrr nd yonr thu troh tanymorr. Thu troh tanymotrr, Jisas nd yonr yak marnyakhato tfit tu yifemrn hemor. ");
INSERT INTO amp_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Met yindarim nd Jisasr nd mumet yonr yak marnyamo nmbuhat htiyafhato tu be mrokfo duhatm tohmom. Nd yimam Jisasr namo nefm htihato duka mmo hasetmn, Jisasr turhu disaiperm ");
INSERT INTO amp_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","kfo memorm, “Na kfoyuk mrokfot duka hanykfot. Ndar bbinysofthu yimam Bro Najomr yak hndhnarahmr yimampno.” ");
INSERT INTO amp_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Jisasr inji kfomohat disaiperm nhai nd mrokfothu yimbu yuhat yakrmomt. Nd mrokfothu yimbu yuhat Bro Nkifrar rompno kafrohmort. Ndnettn rom nhai tawisafrmomt. Rom fanho-mom Jisasrhu tfit ttiwon hikneft. ");
INSERT INTO amp_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Wom yiha Jisasrhu disaiperm tum rhuhato rinnakfo nakfomoum. Womr warhuhato memour, “Nann broruhanko.” Tfit womrn, “We, we nann broruhanko.” Tfit womr warhuhato memourr, “We, rorn.” Tfit womr warhuhato kfo memour, “We, we ror nhai, ndarrn brorahrnom.” Inji inji rinnakfo nakfomoum. ");
INSERT INTO amp_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jisasr bi htimorm rom inji rinnakfo nakfomoahat. Inji htihato wom yonenr yaknehato yarim hatohmorr. ");
INSERT INTO amp_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Yarim hatohhato kfo memorm, “Fitoh yimar na hikhato na hikwa wom met yindarim yakhato kak marnyewurm, nda yonenr yakhato yak marnyiwa kanjo, nd yimar nann yakhato kak marnyewur. Na Bro Nkifrar kfo tkrurafmotra, niamoya. Ndnatn frohr na kak miyekwor, nd yimar Bro Nkifrar kak miyekwor. Fitoh yimar turhu yufat nhai yura htakahrt, nd yimarn bro yufat yakrahr.” ");
INSERT INTO amp_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jonr kfo memor, “Bro yimaye, wom yimar htimonomr ninhu yufat yuta nawohhato kmi yarhm yak thumoatrm kfo rafomonomr. Nd yimar nhai nom ni hik habriwa kanjo nd yimar inji hiknho habrikahrn. Ndnatn nd yimar ninhu yufat yuta nawohhato yarh fknayet yimam yak marnyamoahat, nom nhai yindhor-rmonom.” ");
INSERT INTO amp_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jisasr inji wanyhato kfo memorm, “Mirahko akfo rafonomr. Yimar nikompno nhai nahti dbnotkahr, nd yimar nikmoh yimater.” ");
INSERT INTO amp_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Jisasrhu hefenrhu muh yihar bi brbohrn ndnatn Jisasr memor, “Jerusalemko yiruha.” ");
INSERT INTO amp_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Inji dukahato wom yimam bi kfaf hanymotrm, bi mrokfot hany hanymomt. Nd yimam yimomn, Samariaroh kmitn yi memom, “Jisasr nierahr. Tkitt rorhu nia mhwenayukt wayak htata hitwakomr.” ");
INSERT INTO amp_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Samaria thofmpno mpthamotm, Samaria thofm wanyhato kfo memom, “Nomi Judam nhai niyak marnyakahnom.” Ndnatn Samaria thofm nhai yak htata hermomr rorhu hweyuk tkitt. ");
INSERT INTO amp_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Jisasrhu hus disaiper Jonri Pitar nd rom kfo rafomo mrokfot wanyhato kfo memofr, “Bro yimaye, no kangno akfokahtnom, kaht yura hefen yuhat yawihnekahtn, akandhitm ndar kmi thofm.” ");
INSERT INTO amp_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Inji kfomotf, Jisasr kfo memorf, “Nifn inji kfo duha. Na Bro Najema nhai be yimaroh yafotharoh fasoh yak bebt niarmoya. Yafotharoh yak marnyat niamoya.” ");
INSERT INTO amp_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Be inji kfonihato tfit wom kmit yimom. ");
INSERT INTO amp_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yau hanyetmn, Jisasr wom yimar kfo memorr, “Ni fitoh fitoh tkitm yiyukm na hik htfasruhann.” ");
INSERT INTO amp_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jisasr inji wanyhato kfo memor, “Yifakor tohwa yaum tahi muhm hwitm, yo yafuna nungam wusm hwitm. Na Bro Najomrpaya nhai nanhu wom hweyuk tkitt.” ");
INSERT INTO amp_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jisasr kekutnihato wom yimar kfo memorr, “Ni wania nann wahikn.” Nd yimar memor, “Nanhu yifemr yinohtr, afo rorhu yopt yiruha.” ");
INSERT INTO amp_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Inji kfomotr, Jisasr kfo memorr, “Noheh yimam, rom tum anayopm. Ni wania nann wahikkahnn, Bro Nkifrarhu kingdom-kfothu kfo nuhas mrokfot wania wakfo nuhas habriswanm kmi kmim.” ");
INSERT INTO amp_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Tfit wom yimar ritohhato kfo memor, “Bro yimaye, na hik yibonwann. To kanga ka kfo yakiorfotn, afo yirfoyann, nanhu yimatm kfo wobuh tanyrfoyanm.” ");
INSERT INTO amp_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jisasr memorr, “Yimar Bro Nkifrarhu kingdomkfot toh yibonetr, nhai tfit mongkorhof tamoh tamoh nefm hti thu tany hanykfot o tfit dukakfot.” ");
INSERT INTO amp_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nd ror hik yibonmo yimampno napthanihato ee tfit Bror wom 72 yimam fakmor. Yakhato hus hus fak nhtamorm. Yak nhtahato hus hus nd ror yibonyuk kmim yi hanymomm. ");
INSERT INTO amp_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Kfo memorm, “Boknabok rais suhm bi huktewamn, nhai bok yimam nd rais yukharoh yakyukm. Ndnatn nd mswir tikatr wakfo bruttnakahtko, wom yimam thu yuhurruhatrm, yi yakhirahmr nd rorhu rais swirthu rais hukham. ");
INSERT INTO amp_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nhai mrokfom, wanjuko! Yima dukefmpno waiswako. Sifsifm yifakorhof namburet yauroh rifiny buhar yita kanjo inji nd namburet yauroh rifiny buhar kitwoko. ");
INSERT INTO amp_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Mirahko maru gegb yohenm, hmbre wus yohm o wom hona wuram ayakitohaknom. Be inji sfno yima furako yikfot. Mirahko wom yimampno aptha yifahta hanynomm. ");
INSERT INTO amp_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Wom kmithu wom kunys kitwoko, barkofpam afo nd kuny shofm rim kfo yindhoraknikfot. Kfo yindhoraknihato kfo mekfot, ‘Bro Nkifrar nda kuny shofko ayak marnyarko!’ ");
INSERT INTO amp_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Inji rim kfo yindhorak-niruhatko, hifa yima yuhet yimar nd kunys rhuneft, nd niko rim kfo yindhorak niyuk tngt to be nd yimarn riyaht. Nhai ndhtet yima yuhet yimar rhukahr, to be tfit tukompno nieraht nd niko tuyuk kfo yindhor tngt. ");
INSERT INTO amp_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Wom kmit yifiko, mirahko kuny kuny awita fnahnom. Bi rpa kunys fekko, be nd kunyrpat tohhato tamoh tamoh yeshrim kahukmko, be yakhato yakfot. Niko Bro Nkifrarhu mrokfeft kfo nuhas habriwohat tawo ndmn yak yakfot. ");
INSERT INTO amp_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Wom kmit yikomn, kunymn fak htemko, hifa, nhai mrokfom. Tamoh yeshrim nd kuny shofm hayukm, yak yakfot. ");
INSERT INTO amp_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Tamoh tamoh dbohnefm nd kmi thofm korhwomm, yak marnyakfot. Kfo nuhas mekfot, ‘Bro Nkifrarhu kingdomkfot bi brbo hnewutko.’ ");
INSERT INTO amp_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Wom kmit yikomn, nhai nd kmi thofm kunym yakrfomko, yihotat rim tohhato kfo mekfot, ");
INSERT INTO amp_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ndar nikmoh kmithu bdrt nmoh wuram yarim yenym, tukmoh kmitn tfit kahot trk tanywonomm. To niko dukaf hanykfot. Bro Nkifrarhu kingdomkfot bi brbohwot. Rorhu yinhitn ndar bbinysoft tfit rhuraht. Ndnettn dukaf hanykfot.’ ");
INSERT INTO amp_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Na kfo mifwanko, ndar kmit yakruha krho nmbuhat mirahko ka kuken krho nmbuhat yakraht. Sodomt yakmo krho nmbuhat be inji habhi krho nmbuhat fakmom. Tawo ndar kmitn be tu bro krho nmbuha mift yakrahm.” ");
INSERT INTO amp_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“O ar Korasin thofenko, finji rhu bebhirhokma? Yo niko Betsaida thofenko, niko inji buga. Finji rhu bebhirhokma? Bro yuhuwaf nmbuhat korhtko. Bi wom yimar Tairti Saidont aikahrn mirakerkfot ahingrnart, na nikompno mirakerkfot hingrnamo kanjo, na kanga ka Tair thofmi Saidon thofm tum nayuk fasoh fasoh nefm hti bebhato bi bek tham nyuhunihato yuhun brasingt rhuhato yima yuhum bi yak kekutrmomm. ");
INSERT INTO amp_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Kto ndar bbinysoft tohwa yimam newa nefm yak nhtaruha yiha, nd yiha nikmoh krho nmbuhat nhai Tairti Saidonthut kanjo yakruhattko. Nhai. Niko yakruha krho nmbuhat be tu bro krho nmbuha mift yakrahtko. ");
INSERT INTO amp_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Yo niko Kaperneam thofko, kangko, ‘Ka yura mountko riyahnom?’ Nhai. Niko nndo helko riyahkonwe.” ");
INSERT INTO amp_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Turhu disaiperm kfo memorm, “Niko pthayuk mrokfom yimam wanukwomme, nd yimam nanhu mrokfom wanukwom. Nikmoh pthayuk mrokfom nhai wanykahmme, nd yimam nann mong trohwom. Yimar na mong trohyukr, na kfo tkrurafyuk yimar mong trohwor.” ");
INSERT INTO amp_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nd 72 yimam yimom tfit bro yindhor nmbuhatpno tfit niamom. Niahato Jisasrpno mkfo memom, “Broye, nom ninhu yufat yuta nawoh-hato tek yarh kmi yarhm wany yakiomomm nmoh tngm.” ");
INSERT INTO amp_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jisasr wanyhato kfo memorm, “Na htimoyanr Satanr toh fnhur kanjo wufohninamor. ");
INSERT INTO amp_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Wawanyko. Bro bbukeft bi he-moyanko. Nd bbinysofthu karoh-tknami yima waset nandomenm yahotrahkomm. Satanrhu nanyjar rifhut yiho hathurahkomt. Be nhai wom tamohm finji naruhatmko. ");
INSERT INTO amp_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Inji bi htimokomn, to mirahko akfo amanyom, ‘Kmi yarhmi tek yarhm nmoh tngm fak hikm.’ Mirahko inji akfo yindhornom. Be Bro Nkifrar nikmoh yufam wandfamo nmbuhatn wakfo yindhortwako.” ");
INSERT INTO amp_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Jisasr nd 72 yimaroh mrokfom kfo yakio hanyetrn, Bro Nkifrarhu Yafothat bro yindhor nmbuhat hemotr. Nd Yafothathu yindhor nmbuhatpno Jisasr kfo memor, “Dajaye, ni nda mounti bbinysoft buriwa Nkifraye. Ni tu hifa dborioh neft namo. Nd nefm hifa nd bro duka tungunet yimampno yak kafrohmonmn, tfit habhi yonenmpno fak nriyafmonm. Ndnatn na kfo yindhorwann.” ");
INSERT INTO amp_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Nanhu Yifemr nanhu tirmn tamoh tamohm hta bugamorm. Nhai wom yimam nd rorhu Yonr hti nhtakahmr. Tu Yifem-rpar hti nhtewurr. Yo nhai wom yimam nd rorhu Yifemr hti nhtakahmr. Tu Yinemrpar hti nhtewurr. Yimam tu Yinem yonrn sinyahato turhu Yifemr yak nuhaswatrm, ndnatn hti nhtewumr rorhu Yifemr.” ");
INSERT INTO amp_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Turhu disaiperrpampno rhu hasetrn, nhowi kfo memorm, “Yimam nd niko htiyuk tamoh tamohm bi htiyetmn, ayindhortwam. ");
INSERT INTO amp_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Na kfo mifwanko, boknabok profetmi kingm nd niko htita shrm memoum, ‘Ahtinom,’ to nhai. Nhai nd shrm htirmoamm. Yo nd niko arihat wanuka mrokfeft memoum, ‘Awanynom’, to nhai. Nhai nd mrokfot wanyrmoamt.” ");
INSERT INTO amp_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nkifra boririfhuthu tisar memor, “Jisasr afo attiwon wona.” Inji duketrn, ttiwon memorr, “Broye, na finji narhoyann, toh nkifrarhoya?” ");
INSERT INTO amp_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jisasr wanyhato ttiwon memorr, “To boririfhut finji kfiwat? To ni wanyshoft finji wanukwanm boririfhu mrokfom?” ");
INSERT INTO amp_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Tfit rorn kfo memor, “‘Bror ninhu Nkifrayer, ndnatn ninhu yuhuwaf marbi bugam, ninhu yafothat, yo ninhu yima yuhu bugam be rorparn htakfot.’ yo, ‘Tunn yak marnyewa kanjo inji womm yak marnyakfot.’” ");
INSERT INTO amp_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jisasr inji wanyhato kfo memorr, “Nd ni pthi mrokfom be tu kfo mifn. Inji nahato toh nkifrarahn.” ");
INSERT INTO amp_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nd yimar memor, “Be tukanhu yufat ayak marnyaya.” Ndnatn inji ttiwonmorr Jisasr. Ttiwon memorr, “To nanhu yimatr froher?” ");
INSERT INTO amp_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jisasr wom tndh mrokfot kfo nuhas memorr, “Wom yimar Jerusalemt htanyhato memor, ‘Aiya Jerikoko.’ Yihotat yau hanyetrn, rikoh yimam toh rafakmomrn, tat noh bonohhato wuskam fak rhoptakni buga hemomr. Ror be tu gur yihotatn hwemor. ");
INSERT INTO amp_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Be ror yihotat hwe hasetrn, wom prisr yau hnehato nd yimar yihom htihato manoh yuhat fau hhrifakmor. ");
INSERT INTO amp_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Be nd prisr inji yihom hti marsisanehato yimor. Rorhu mongkorn Lifai frikefthu wom yimar niamor. Ror nhaf inji. Ror be nd yimar yihom htihato fau hhrifakmor. ");
INSERT INTO amp_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Tfit rorhu mongkorn Samaria thofr niamor. Rorne nd yimar yihom hti yuhuwafmorr. ");
INSERT INTO amp_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Yihom hti yuhuwafhato brbo nd yimarpno yihato nd yimarhu fhu yuruft wain bupami welpaye kifsamorrn, tawonmorr. Tawonnihato, you, yura nd ror yiyuk donkitn htahato hanymorr yimam yihom hwina mhwenewa kunysn. ");
INSERT INTO amp_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ndha hwe nfhahato nd wom dbharn nd kunys tohukatohyuk yimar hus kinakfot hehato kfo memorr, ‘Ndar yimar ninhu tirmn htanywanr. Ninn hatoh hasokahnr, tamoh tamohm yaknaftr fahunr, kto na nia thombat maruha hiruhann.’” ");
INSERT INTO amp_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nd yimarhu mrokfot kfonihato kfo ttiwon memorr, “Nd yihotat hwe hasoyuk yimar frohr rorhu yimat mifrn tohmor?” ");
INSERT INTO amp_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Nd yimar kfo memor, “Yimar nd wom yihotat noh hasomo yimar yuhuwafhato yak marnyamo yimar.” Jisasr kfo memorr, “Ni waikahnn, nd yimar namo kanjo inji wanatwa.” ");
INSERT INTO amp_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Yau hanymomn, buha wom kmitn Jisasr ndha riwitamor. Wom mett, rothu yufat Matat, rotn yaknimotr, hanymotr rothu kunysn. ");
INSERT INTO amp_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Nd Matathu kunysn mrokfom pthamoatr, Matathu nmem Mariat Jisasrhu wurampno rhuhato wany yakitohmoutr Jisasr pthamoahat. ");
INSERT INTO amp_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Rot, Matat turpett yeshrim hta mskamout. Ndnatn Jisasrpno yimotn, kfo memotr, “Broye, nanhu nmemt httanysa turpata yeshrim hta mskiwa. Nhai duka mekahn turpatt hta mskewut? Wakfafkahtnt, ania ahingrnanhota.” ");
INSERT INTO amp_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Inji mkfomott, Jisasr memort, “Mataye, ni bok dukefm yekwatmn, ninhu yima yuhur kangm bi kminysofem. ");
INSERT INTO amp_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ndhtet bok dukefm arhum. Rpa dborioh dukefrpar wayakn. Mariat ndhtet dborioh dukefrpar kangt ayaka. Nhai tfit womm kfo rafokfot. Nhai.” ");
INSERT INTO amp_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Wom yiha Jisasr wom tkitt yihato kfo bruttna hasomor. Kfo bruttnani bugamotr, turhu disaiperr kfo memorr, “Yinowe, kfo nuhasrfonnom ni kfo bruttnewa kfo bruttneft? Bingot Jonr tohmohat rorhu disaiperm kfo nuhas bonuhasmourm ror kfo bruttnamoa kfo bruttneft. Kfo memourm, ‘Inji inji wakfo bruttnako.’ Nom to inji wakfo bruttna nuhasnnom.” ");
INSERT INTO amp_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jisasr inji wanyhato kfo memorm, “Kfo bruttnaneft inji kfo bruttnakfot: ‘O nmoh Bro Yifeme. Ninhu yufat tu hnaru yufayet. Nhai yimam yuta rrha borrhakfot. Nom kangnom ninhu kingdomkfot aniehnat. ");
INSERT INTO amp_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Nmoh yihof href ye hasoyuk yeshrs wahe hasotwannom. ");
INSERT INTO amp_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nom niwa fasoh fasoh nefm wayafhonm, nom womrohm yafuhiwa kanjo. Nom niwa kanjo nmoh fasoh nefm waduka mumafonm. Mirahn waduka thu waduka thu hatohanm. Satanr nia toh nhehaknewurnom, mirahn ahti marsisayanm.’” ");
INSERT INTO amp_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Nd kfo bruttna mrokfefm inji kfo nuhasnihato wom kfo nhombra mrokfot yakhato kfo memorm, “Niko nda na ttiwonwa yimako, nikmoh yimatm kunym bi darmbnihato bi hweyetm tfit ni womn yifung dany yihato ninhu yimatr mfrthohato mkfo merfohat, ");
INSERT INTO amp_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","‘Bare, na niya bretpa tndausn nanhu wom nanyma kmi thofr nanhu kunys nietr, na nhai wom yeshrim rorhu hayukm. Ndnatn nia ninpno. Famuya husfirpa bretpam hiyafrahna.’ ");
INSERT INTO amp_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Inji mttiwonrfotn tfit ninhu yimatr yiro kunys rirhuhato kfo merfohat, ‘Tamohmpno ndar yonmari yifung danys bi kunym darmb kihnihato bi yon tuhanmpno hwe guna tuhetnom myak thewarnom? Frohm hrek sinyahato hiyefiwamr?’ Kto ni tuha afo toh kinyakihato tfit ror wany batihato sinyani, yak hiyaforfohat, niko ka finji dukewako? ");
INSERT INTO amp_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Tamoh dukeftpno sinyahato yak hiyaforforr ror mttiwonyukr? Ka be rorhu yimatrn yak hiyaforforr? Na kfiwanko, nhai be rorhu yimatrn yak hiyafrforr. Nhai. Turhu toh kinyakihato wattiwonthu wattiwonthu hatohtn yak hiyafrforr. ");
INSERT INTO amp_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ndnatn na kfiwanko, tamohm yak yibonrahko, Bro Nkifrar kfo tatokfot. Kfo tatorahko ee hirahrko. Yimam yak hambrohany yak hambro hanyrahm ee mhtirahm. Yimam brbo yihato mkfo tndaurahm ee htiruharmn yakhato hiyafrahrm. ");
INSERT INTO amp_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Yimam yihato mkfo tatewumr ee kahukrm tamoh tamohm. Yimam hambro hanitwom ee mhtitwom. Yimam brbo yihato mkfo tndauwom ee htitwarm yakhato hiyefiwurm. ");
INSERT INTO amp_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Niko wom yiha ka bi htimoko wom yimar turhu yonr yirar mtndaumotr tfit nandomr yakhato ndr wathu nhehafmorr? Nhai. Nhai wom yimar turhu yonr inji narmorr. ");
INSERT INTO amp_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","O wom yonr yifemrpno yihato ginafm mtndauneft ka yifemr pkinaft yakhato ndt wathu nhehefiwurr? Ka nhai htirmokomr wom yimar yinem yonr inji narmorr. ");
INSERT INTO amp_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Niko nda bbinysofthu fasoh net yimakmoh yonm hifa yak marnya bomarnyewa kanjo inji yura mounthu yifemr mfro kak marnyewurko. Turhu Yafothathu hanyeft nakutwokomr, nhai wany marsisakahrko. Nhai. Kahukworko.” ");
INSERT INTO amp_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Wom yimar yima mrokfo yafothar tukihwa kmi yarhr fknemotrr nd yimar be mrokfo ptha duha be inji tng mmkr rhumour. Jisasr yihato nd yimar fknenimo yarhr fak thumorr. Yak thumotrr, yima yuhur niamotrr mrokfo pthamor. Bok yimam Jisasr namo neft htihato be tuha mrokfo duhatm rhumom. Memom, “Bar yimako, Jisasr be tu tamohtet bbukeftpno kfitr, nd yimar tfit bi pthiwar?” ");
INSERT INTO amp_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Womm wanyhato kfo memom, “Nd yimar yarhroh bro tohak Belseburrhu bbukeftpno kak thuworm kmi yarhm.” ");
INSERT INTO amp_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Tfit wommn duka memom, “Mirahnomr yura waukfokahtn, wom neft ayawihnekahtt mirahnom awi tu Bro Nkifrarhu Yafothatpno hingrnewur.” ");
INSERT INTO amp_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Jisasr bi htimorm rom inji duka-mohat. Htihato kfo memorm, “Rpa kantrikfot tohyuk yimam buha nayak mkuhato rimtoh mtohhato nnaknineft, be nd kantrikfot yohniraht. Nhai wom yimam tohruhatmt. Yo rpa kunys tohyuk yimam nhaf inji. Tum nayak mkuhato nnayurneft, be nhai wom yimar tohruhatr. Be tum naye dborha nohhato yima duha tkitm rhurahm. ");
INSERT INTO amp_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Satanr nhaf to inji buga. Na Satanrhu bbukeftpno nd rorhu tuhagrhayuk kmi yarhm yak thuneft, be nhai tfit Satanr toh bmtakfot. To fitom rorhu wom thu hamuhyukm? Bi be. Tuko kfo yamukatko Tndhrhu bbukeftpno kak thuwanm yarhm. Ndnatn inji kfiwanko. ");
INSERT INTO amp_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nikmoh wom yimam Bro Nkifrarhu yufatpno kmi yarhm yak thu thoft nhai kfo mekahkomm, ‘Tndhrhu yufatpno kmi yarhm kak thuwomm.’ Nhai. To tamohmpno na Bro Nkifrarhu yufatpno kmi yarhm yak thuwohat, kfo yamukako, ‘Tndhrhu yufatpno kmi yarhm kak thuworm?’ Nikmoh yimatm kfo mirahmko, ‘Kfo furewuko.’ ");
INSERT INTO amp_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Htikfot. Bro Nkifrarhu bbukeftpno kmi yarhm kak thuwanme kfo mekfot, ‘Nom bi Bro Nkifrarn kakitohwornom. Bi rorhu kingdomkfot korhnom.’ ");
INSERT INTO amp_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Wom namburet yimar turhu kuny kmifar kfra inyarut yakhato rhu hasiwur, rorhu kmifar hifa rhu marnyewur. ");
INSERT INTO amp_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Tfit womr tu masat nambur nanyjaretr inji htihato kfo mirahr, ‘Barenko, rorrpar nambureter. Na afo nhombrawonanr.’ Tfit rorn hafnahaknitrr, womrhu kfra inyaruti rorhu tamoh tamoht mtuhafnitatrt, womrn myak rhoptekwort. Myak rhoptakhato wommpno nayak nhtewumm nd wuss. ");
INSERT INTO amp_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Yimar be buha tohhato nanhu tamoh tamoh nefm be nyingarpaye kukatohworm nd yimar nhai nann tohnho yibonkahr. Womrn tohnho yibonwor. Na wom tamohm yuhre yak nhafoh hanyhato womr tohhato be nyingarpaye yukatohhato nhai yak nhafohnhokahra, tor ndhtet yimarn tohhato krmah hikworm na yuhre yak nhafoh hanyuk shrm.” ");
INSERT INTO amp_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Wom yimar nd kmi yarhr thu troh tanyshombat afo kitwor rhuyuk tkitroh hambrot. Hambro habri hambro habri, nhai wom rhuyuk tkitt htirfort, tfit mkekutakhato kitwor tur toh tanyuk tkittn. ");
INSERT INTO amp_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Yitarn htitwor tkitt be wuthat, nhai wom wusswenm. ");
INSERT INTO amp_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Be nd kmi yarhr inji mhti tanysihato tfit wuyekwor. Wuyakhato tfit kitwor womroh yakt. Yitarn 7-pelakfot myekwor. Tom nd 7-pelakfotn tu bro nefm aruhwom. Rompno niahato be nd kunyr kakaknitmr. Yakaknitmr be kspita bugewur. Yimar tefi nefenm afo na hasoyukr tfit nd 7-pela kmi yarhm yak hatoh hanitatmr tu bro nefm newur.” ");
INSERT INTO amp_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jisasr nd mrokfot pthamohat bro rifiny buharn tohhato nd mrokfot pthamort. Nd ror pthamo mrokfot ptha buganimotrt, wom mett nd yima rifiny buharn wasinyahato Jisasr kfo memotr, “Jisase, ninhu hiyau mmemt ninhu hingrneft hti thoft ka be tu bro yindhoreftpno korht.” ");
INSERT INTO amp_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jisasr wanyhato kfo memort, “Uwa, to yimam Bro Nkifrarhu mrokfom wanyhato yak hikwam, tom romn yindhorwom.” ");
INSERT INTO amp_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Yimam rifinyaknamotm Jisasr kfo memor, “Ndar yiharhof yimako be tu fasoh yimayeko. Kfo kangkma, ‘Wom neft wanakahtn, afo htirahnom.’ Inji kfiwotkma to na fitoh neft hingrnarhota ndtn htiruhako? Profet Jonar pthamo mrokfef yuharpatn ptharhota ndtn wany duka tungarahko. ");
INSERT INTO amp_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Bingot Jonar taun Ninifat inji namor. Bro Nkifrar bi kfomor taun Ninifathu yak batineft. Jonar yihato Bro Nkifrar nd kmithu yak bati nmbuhat kfo nuhasmotrm, nd kmi bugathu yima bugaroh fasoh nefm mong trohmomm. Nd Jonar pthamo yuhatn na Bro Najema inji ptha hikrhota mhti dukarahko. ");
INSERT INTO amp_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Kto yimaroh yak nhta yiharn sautko tohyuk kwint sinyaruhatn tfit rotn tohhato nikmoh fasoh nefm kfo nriyafhirahtm. Rot kwint tu bbinysofthu wuroh krayeft tohhato wanymot Solomonrhu hifa hifa hingrna dukefm. Wanyhato memot, ‘Afo yirhoyann htiruha ror hingrnewa hingrneft.’ To nhai. Nda ariharhof hingrnayet yimar to broyer. Solomonr nhai. Nhai htihato tukmoh fasoh nefm mong trohrmokomm. ");
INSERT INTO amp_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Bro Nkifrar yimam yak nhtaruha yiharn nikmoh fasoh nefm Ninifa thofmn mtohruhamn kfo nriyaf-hirahmko. Jonar Ninifat yihato Bro Nkifrarhu mrokfot kfo pthamohat Ninifa thofm Bro Nkifrarhu mrokfom wany yakrmihato mong trohmomm rroh fasoh fasoh nefm. Rot nd bingotrhof mrokfom Ninifa thofm wany yakrmihato rroh fasoh nefm mong trohmot, nd mrokfot be inji. Ariharhof mrokfot rot tu bro tpiyet mrokfoyet.” ");
INSERT INTO amp_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Nhai wom yimar lamt hta funakhato tfit rikat o wom bro baket yakhato lam funeft hta tasifafkahrt. Nhai. Lamt dany yuha tafontn htewatrt yimam witaniyukm htitwomt. ");
INSERT INTO amp_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Yimar tu hifa dborioh yima dukefetr, nd dborioh dukefm kshm kanjo yak nuka hanitatmr, hifa dborioh dborioh nefm newurm. Yimar nd hifa yima rifhur bi fnahniyetr to be nyinga kunyjetm kanjo yak tato botatohato na fura bofurewurm tamoh tamoh nefm. ");
INSERT INTO amp_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ndnatn be tu duka marnyaf hanykfot. Mirahko nd yiro yima rifhur rirhuyuk ksh nukefr atatpohnomr. ");
INSERT INTO amp_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ninhu yima rifhur be hifa dborioh yima rifhurpno rhu marnyarahr, nd dborioh yima rifhurn lamr kanjo yak nuka hanyruhatrn, yau marnyarahn.” ");
INSERT INTO amp_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jisasr nd mrokfot pthanimotr, wom Farisir niahato Jisasr mkfo memorr, “Jisase, wania nanhu kunys nuwa yerahno.” Be Jisasr wanyhato yimor rorhu kunysn. Yihato nuwa yeyuk tkitt rim rhumor. Rim rhumotr, yeshrim yakhato be fe furakni twanhomorm. Nhai yukhato tir kifsa inji nahato nuwa yi yaknirmor. ");
INSERT INTO amp_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nd Farisir inji htihato duka memor, “Tamohmpno Jisasr nhai yuk duha be bmbri nuwa yi yaknir?” ");
INSERT INTO amp_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Jisasr kfo memorr, “Niko Farisiko kaf pletm briahako yuk kifsewa kanjo be inji briahakorrpa yuk kifsahato kak marnya bomarnyewuko. Nikmoh yima rifhumio rikohnefmi wom wom fasoh nefm furkihwomko. Tukmoh toh nmbuharpat dukahato bi marut wuss tamoh tamoht yak yakhato bi tohwokomt. ");
INSERT INTO amp_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Yon mumenm kanjo ptha mumiwuko. Bro Nkifrar nhai briahako nayuk nefrpam htikahr. Nhai. Yiro yima rifhurio wagrha sinyahato nayuk dborioh nefm ndm rpat htitworm. ");
INSERT INTO amp_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Wom yima bebr o met bebt wuskapa duhattn hti yuhuwafhato hirahnt, ee btn Bro Nkifrar hti yindhorrahrn. ");
INSERT INTO amp_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Tamoh tamoh wuritwenm, youpenm, wajipenm yakneft nhai Bro Nkifrar yak brur wunanikahkomr. Nhai. Bro Nkifrar hifa mhtahukkomr. Ndm rom tu hifa dborioh nefm newuko. To nhai. Tu bro neft myak htanitwokomt. Nhai Bro Nkifrarpno rpat niyakitohhato rpat tohkahko. Yo nhai wom dborioh nefm nakahko. Ndnettn wadukaf hanyswako! Bro Nkifrar be yak bebrahrko. ");
INSERT INTO amp_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Judaroh rhu rifinyuk rmonm rhuneft be kangko bro yufet yimam mruhekwa barkof gajim arhukahtnom yimam htirahmnom. Yo tamoh maket swirm kangko yimam be nomn akfo yindhor boyindhorm. Ndnettn wadukaf hanyswako! Bro Nkifrar be yak bebrahrko. ");
INSERT INTO amp_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Aromenkono! Yima yopt htitwokomt? Yura bbrmontn hifa hti fughewukomt. Hti fughahato yura wiyauyauwoko. Nd bbrmonthu yirokn torwe yima gur bi kfe bdgniyetr korhr. Yimako to inji rhu nhombrewuko nd yima yopt kanjo. Yimam htitamko kangm ka hifa dborioh yimayem. To nhai. Nikmoh yima rifhum fasoh nefm furkihwom. Ndnettn wadukaf hanyswako! Bro Nkifrar be yak bebrahrko.” ");
INSERT INTO amp_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Wom boririfhuthu tisar sinyahato Jisasr kfo memorr, “Tamohmpno nd mrokfot nom rpat yekwatnom? Nom nhai ndhtet nefm nakahnom.” ");
INSERT INTO amp_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jisasr nd boririfhuthu tisam memorm, “Niko to inji buga. Nikmoh neft to inji newuko. Nhai be hifa hifa mrokfefm yakhato kfo hta bohta marnyakahkomm yimam. Nhai. Niko htewa boririfhum be tu kminysofm kanjo tohwamn yimam mnhiyekwom hikneft. ");
INSERT INTO amp_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Niko dukaf hanykfot! Nikmoh nkifram inji na hnamom. Profetmpno nhai hifa nyingar htarmoamm. Yimoamn, faso faso was beb bobeb thumoumm. Tfit niko yonkomn arihat yitakomn nd profetroh yopm yak marnya bomarnyewakommn wondh-wokomm. ");
INSERT INTO amp_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Be tu yuwi furewuko. Nd profetm arihat atohkahmn mrokfom aptham, to nhai wany yakiorfotkomm. Tukmoh nkifram namo kanjo nhaf inji wasrfokomm. ");
INSERT INTO amp_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Bro Nkifrar tu hifa dukefetrn kfo kangr, ‘Profetmi aposerm rompno kfo tkrurafrhotanm, nhaf be yimamn hirrahm.’ ");
INSERT INTO amp_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ndnatn ariharhof yimam nd profetm was hnamo yuhatn krhopam yak hanyrahm. ");
INSERT INTO amp_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Bingot nikmoh nkifram was hnamo profetm, barkofr Aberr wasmom. Ror wasnihato ee wom womt be yimaroh tirmn hirmom. Wurohenr Sekaraiar yiro temperrn, tarioh mthamoa tkitt toh hasetrn rim wasakmomr. Ndnatn niko bi tukmoh nkiframn katirnamomko. Nhai toh marnyaruhatko, rroh krhopam tfit nikomn yak hanyrahkomm. ");
INSERT INTO amp_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Niko dukaf hanykfot! Niko kfiwa boririfhut nhai tu yak hik marnyakahkomt. Bok nefmn frhammo bohamumiwatkomm yimam rom buha mmo bomumiwum. Tu nd Bro Nkifrar hayuk boririfhutn akfo hta marnyakomm yimam, awi, rom hik marnyarfomt.” ");
INSERT INTO amp_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jisasr nd kunys htanyhato tfit fnahnimor. Farisimi nd boririfhuthu tisam, duka memom, “Barenko, nom nd yimarn kangr amfrfnahniya. Niko finji dukewako? Nd yimar ayak thunomr.” Ndnetmn yuwi ttiwon tebfi botebfi htfasmoumr. ");
INSERT INTO amp_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Nd yimaroh dukeft duka memom, “Yuwi inji ttiwon rhti tebfi hanyruhanomr, bi finji kfiwur, ee nd wukier nd yiha tathurrahrr.” ");
INSERT INTO amp_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Bok yimam rifinynimotm, nhai wom tefi rrfenr htikfot. Rim toh mtohneft to be yimamn muhkfot. Nd yihar Jisasr wom mrokfom kfomorm. Barkofpam afo turhu disaipermn kfo memor, “Niko mirahko ahiknom nd Farisiroh nefm. Kfo fura bofurarahmko. ");
INSERT INTO amp_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Nd kfo fura bofura mrokfom yiro yima yuhur kafroh hasiwam, Bro Nkifrar tafont htarahrm. Tamoh tamoh mrokfom kon kafroh hasiwam kto tfit Bro Nkifrarn nd kon kafrohet mrokfom tafontn htarahrm. ");
INSERT INTO amp_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Ndnatn nd niko yifung kfoyuk mrokfom Bro Nkifrarn tfit mar tafontn htaruhatrm tfit wanyrahmm. Yiro rumtn turpethato kfo kafrohyuk mrokfom tfit kto yima rifiny buharn Bro Nkifrar ptha nriyafruhatrm wanyrahmm.” ");
INSERT INTO amp_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Barenko niko, nanhu yimatkomn, kfiwanko. Ndar nom hatohwa thatipt waswa yimam ayakrme furawahkomm. Thatipt wasniruhamt nhai tfit wom finji naruhatm. ");
INSERT INTO amp_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Rot yakrmanyefte, Bro Nkifrarpar yakrmekfot. Ror yimam yak nohnihato tfit kangr kaht aim, kaht kitwom. Uwa! Rorpar yakrmekfot. ");
INSERT INTO amp_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Yimam kipr nungam wikna thoft tefi hus toyarpaye wiknewumm tirfa nungam. Nikmoh nyingaye hti thoft kangko, ‘Ndm tefi nunga pirayenem.’ Bro Nkifrar nhai inji hti sminakahrm. Rorhu tirmn korhm. Niko yimako to inji nd nungenm kanjo rorhu tirmn korhwoko. ");
INSERT INTO amp_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Niko yimako be ayakrme furawahko. Bro Nkifrar hti dukewurko. Yimaroh tmariroh tmarifam ror thomna bugewurm. Nhai womfenr rim tohtakahr.” ");
INSERT INTO amp_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Kfiwanko, fitoh yimar na hikhato yimampno kfo habri kangr, ‘Na bi Jisasr kak hikwa,’ na kfiwanko, kto nd yimar tawo na Bro Najoma mounmotroh nyingahato kfo miruha, ‘Ndar yimar nanhu nanyma yimayer.’ ");
INSERT INTO amp_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Frohrn na hikhato wom yimampno kfo habri kangr, ‘Na nhai Jisasr hikkaha,’ kfiwanko, nda bbinysoft batiruha yihar tawo na Bro Najema mounmotm kfo miruhanm, ‘Nd yimar nhai nanhu nanyma yimar rhukahr.’ ");
INSERT INTO amp_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Fitoh yimar na Bro Najema hingrnayuk hingrneft htihato kangr, ‘Nd yimar nhai fipet hingrneft hingrnakahr,’ inji kfoyuk yimar Bro Nkifrarpno tfit kfo gbuhkfot. Ndnatn nhai be kfongot duka hanyruhatrt ror pthayuk tngt. Nhai. Duka mmorahrt. To fitoh yimar na Bro Nkifrarhu Yafothathu bbukeftpno hingrneta kfo famur, ‘Fasoh tndhrhu bbukeftpno hingrnewur,’ nd yimar nhai tfit kfo gbuhruhatrt, be Bro Nkifrar nhai duka mmoruhatrt nd yimar kfoyuk tngt. ");
INSERT INTO amp_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Yimam na Bro Najema hikwamn kangm, ‘Judaroh rhu rifinyuk rmonkorhof bro tohukatohmi mejistretm, rompno ahanykahnommn htirahnom toh bmtarahm pthaneft?’ Inji duka-hato hanitwomko. Na kfiwanko, mirahko duka amanyom, ‘Na hrek finji kfiwoya ttiwon thoft.’ ");
INSERT INTO amp_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Mrokfo pthayuk tkittn Bro Nkifrarhu Yafothatn mrokfo ptha rifhur hirahrko.” ");
INSERT INTO amp_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nd Jisas pthamoa yima rifinyrn wom yimar sinyahato Jisasr kfo memorr, “Tisaye, nnoh yifemr bi nohmor. Nanhu najemr wakfokahtnr nnoh yifemrhu wuskam ror harhuwam ayak nhtakahrm nanhum bi ahira.” ");
INSERT INTO amp_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jisasr wanyhato kfo memorr, “Bare, frohm kfo yamum, na womann yak nhtahato yak nhombra hirhoyanfn?” ");
INSERT INTO amp_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Inji kfonihato kfo memorm, “Yo niko, wuskam hti wuttha duha. Womr bok wusketr htiruhann mirahn, ‘Na kanga inji bok wusketa aruha ndu yimar kindo.’ Mirahn wuskam adukaya. Tunhu tohneftn dukakfot. Yimar wusketr nhai nd wuskamn rorhu yafothat thu bmta hatohruhattr toh hatohruhar. Nhai.” ");
INSERT INTO amp_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Inji kfonihato wom maru kunyet yimarhu kfo nhombra mrokfot yak-hato kfo memorm, “Wom bro maru kunyet yimar mswirt htamortn nd mswirthu yeshrt hifa sinyahato hirmot. ");
INSERT INTO amp_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nd maru kunyet yimar nd yeshrt htimortn duka memor, ‘To ndar yeshrt yakrhoyante, to fitoh bro kunymn yak htarhoyant? Nhai wom bro kunym nd yeshrthu htayukm.’ ");
INSERT INTO amp_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Be inji mduka nhtahato duka memor, ‘Nhai mrokfom. Nd habhi kunypam tfit yak tmbrarhoyanm tfit bro bro kunyrpam hingrnaruha. Bro kunym hingrnanirhoyann btn nd mswirthu yeshrt yak thoft yo wom wuskam be nd bro kunyrpamn hta tibmonruhant. ");
INSERT INTO amp_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Btn nd yeshrt nd tamoh tamoht bro kunyrpamn hta tibmonrhoyanm be nhai mrokfom. Nhai wom tamohm tfit wom dukarhota. Tkitt to bi fekant. Bok gunyjimm be nd yeshr kunym dukahato tohruha. Be ye mmo rhu mmo nefrpat dukaruha.’ ");
INSERT INTO amp_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Tfit Bro Nkifrarn kfo memorr, ‘Bare ni faso kfo hamumiwun. Ni asomif nohneft. To frohmn yakruhamm nd ni hta tibmonyuk wuskam?’ ");
INSERT INTO amp_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Nd kfo nhombra mrokfot kanjo bok yimam inji newum. Asha bbinysoftn wuss yak yakhato hifa rhu nmbuhat kekwom. Nhai yima yafothat mrhuyuk tkitt dukahato yak hta bohta marnyakahm.” ");
INSERT INTO amp_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Jisasr nd mrokfot kfonihato kfo memorm, “Nd dukeftpno kfo kanganko, mirahko tukmoh toh nmbuhat htihato akfo amanyom, ‘Nome tamohm yehato tohruhanom? Hmbreshame tamoh hmbresham hmbriruhanom?’ Ndhtet dukefm yak duha. ");
INSERT INTO amp_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Bro dukeft dukakfot tukmoh yafothathu tohyuk tkittn. Mirahko thatipt tohyuk tkitrpat adukanom. ");
INSERT INTO amp_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nunga kusm htitwokomm. Rom nhai wom yewuri fant nuhtakahm. Rom nhai wom kunys singohato yeshrt o tamoht hta tibmonkahm. Rom be inji rhu furewatm tu Bro Nkifrarn kahukrm yeshrt. Niko finji dukewako? Ka be nd nunga furenrpam hti dukewur? Nhai yimako tur yak yeny nhombrayukko dukakahr? ");
INSERT INTO amp_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nhai ndar bbinysofthu wom yimar noheft yironak hanyhato afo kfo marifort, ‘Awi ar noheft. Na wofnkaha bmbri nohneft. Na kanga afo atohaka. Tafi toh buhtarroya ndar bbinysoft.’ ");
INSERT INTO amp_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ndnatpno to tamohmpno wom tamoh tamohm dukewakomm? ");
INSERT INTO amp_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Htitwoko plauam sinya thoft nhai tum mtinm mtinhato tum rmontham nahukahm. Kfiwanko, bingot Solomonr wondhmohat nhai nd plauathu wondht kanjo rorhu wondht rhurmot. ");
INSERT INTO amp_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Htitwokomm plaua tfam Bro Nkifrarn htamorm nd wondht. Nd plaua tfam rhu thoft nhai rhu buhtakahm. Href rhuhato tfit nohof hafit tmbhohato tuhefiwumm kahtn. Ndhtet mifan furenm Bro Nkifrar nhai hti marsisakahrm. Nhai. Rroh wondht kahukrm. To ndar yimanom kangko, ‘Bro Nkifrar nd plauam kanjo nhai wondht heruhatrnom?’ Bar met yindariko, Bro Nkifrar ka be psirnano kakitohwokomr? ");
INSERT INTO amp_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ndnatn yeshrt be mfro adukawahkomt. ");
INSERT INTO amp_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Yimam Bro Nkifrarhu mrokfeft yak hik duham, nd yimam be yeshrimi tamoh tamoh dukefm, be nd dukefmn korh hasiwum. Niko be ndhtet dukefmn duka haso duha. Bro Nkifrar bi htitworm niko dukiwa dukefm. ");
INSERT INTO amp_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Afo nikmoh bro dukefm afo Bro Nkifrarn yak htakfot. Rorhu yinhit rhuhato tamoh tamohm nakurahkomr be hirahrko.” ");
INSERT INTO amp_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Sifsifenko, aduka yanhowahko. Nikmoh Yifemr, yura hefenr yorhwarko, bi duka hta memor, ‘Ndar bbinysoft nanhu yinhit rhu thoft, nikomn tohukatohnhorahkma.’ ");
INSERT INTO amp_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Niko harhuyuk tamoh tamoh wuskenm yimam awiknakahtmm, tfit nd wuskaye yakyuk maruham tfit hekfot wuskapa duha yimamn. Hiyafruhakomm niko tu burifhut kanjo tone haset maru yihotat htiyakrahkomt. Htiyakhato yura hefenrn nikmoh hifa dborioh wuss rhuraht. Yura hefenrn tamoh tamohm yak htarahkomm, be nhai hti hambroruhatkomm. Nhai wom rikoh yimam yak rikohhiruhatmko. Yo bfongt o dmt nhai yeruhattm. ");
INSERT INTO amp_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Hifa hifa dborioh wuss yura yak htakahkomm be nikmoh dukefm be nd wuss rhuyuk tkitt duka duka rhurahm.” ");
INSERT INTO amp_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Yo niko! Hti yukatoh hasokfot! Hmbresham nyuh dbkaf marnyahato lamm hta funahato hti yukatoh difron hasokfot! ");
INSERT INTO amp_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Hingrna yimam turoh tohukatohr kuny grhat yihato rhu yukatoh hasiwa kanjo inji warhu yukatoh hasotwakomr. Hti haso, bi kuny kimbko bi myak nmbarwor, ‘O bi tor,’ yudbat toni yaknihato yifhatikt rim yak tfanyakkfot. ");
INSERT INTO amp_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Yimam rorhu nia yihar mhtitaworm rhu gari hasimrn, nhai hwerfom, nd yimam yindhorkfot. Na kfiwanko nd tohukatohr niaruharn hmbresham nyuh dbkaf marnyahato nd ror rhu gari hasoyuk yimam turn yak hta-ruharm yeshrim yak nhtahirahrm. ");
INSERT INTO amp_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Yifung danys o dbha ksfut barkof krimpno niahato mhtitaworm rhu gari hasimr, nd rhu gari hasoyuk yimam, rroh yima yuhum yindhorkfot.” ");
INSERT INTO amp_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ndt inji kfonimortn tfit womtne kfo memor, “Wom kunys rikoh yimam kangm ania arikohnomt, bi nd tu kuny sikatr bi fekrt nd rikoh yimaroh nia mrokfot, be nhai ror mhwe gushu-nikfot. Rorhu yimbhindangm be tohetoh hasorahm. ");
INSERT INTO amp_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ndnettn nikmoh yimbhindangm be tohetoh hasokfot. Bro Najomr rhu mmo hasetkomn be yak fohtasakrahkomr.” ");
INSERT INTO amp_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pitar tohhato kfo memor, “Bro Najeme, nd ni kfo pthiwa kfo nhombra mrokfefte nom rpanom kfo nhombra nuhaswone ndar tohwa met yindar bugam rpatn?” ");
INSERT INTO amp_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Bro Najemr sinya-hato tfit kfo memor, “Fitoh yimar hingrna marnyewur, tor nd yimarn turhu tu bro tohukatohr wom tkitm yinyeft, kak htewurr wom hingrna yimaroh tohukatohneft yo kfo nuhasworr hingrna yimaroh yeshr heyuk yiharoh yeshr hanyeft. ");
INSERT INTO amp_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nd tu bro tohukatohr kfoyuk hingrneft hingrna hik marnya hasirt, nd yimar yindhorkfot. ");
INSERT INTO amp_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Na kfo mifwanko, bro tohukatohr nd yimarn htarahr rorhu tamoh tamohroh tohukatohyuk yimar. ");
INSERT INTO amp_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","46","To nd yimar hingrna hany hingrna hanyhato bi bok yiham toh garitihato nd kfo hta tanyuk hingrneft faso faso rihingrna behohaknihato nd hingrna yimam faso faso ritat bebakhato ror be nuwa bupa ye mmo nefrpat duka hasir, inji na mmo hasetrn, nd tohukatohr nia mihti thoft, be nhai wom tohruhatrt nd hingrneft. Be nia yak tuhafrahrr. Yak tuhafhato tu rpahtet net yimampno tohrahr. ");
INSERT INTO amp_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Nd hingrna yimar, turhu bro tohukatohr kfo tanyuk mrokfo yuhat nhai hingrna hik marnyarfort, be nhai htiruhatrr. Mfro namburrahrr. ");
INSERT INTO amp_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Yo wom hingrnamo yimar turhu bro tohukatohr nhai wom hingrna mrokfefm kfo tanyhariforr hingrna mmo hasetrn, be nhai mfro namburruhatrr. Ndnatn yimar Bro Nkifrarhu mrokfot mwany warho fnahetr, nd Bro Nkifrarhu mrokfo pthaneft mna yuham tou hikak bugakfot. To yimar Bro Nkifrarhu mrokfot mwany warho fnah duhatr, rorn be yura ptha mmbrafinyineft, nhai mrokfom.” ");
INSERT INTO amp_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Na nia bbinysofthu kahthu mihtanyneftn. Kanga bmbri mihtanyant. ");
INSERT INTO amp_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Barkoft kanga krhopam ayaka. Tfit na tuka nd krhoparoh yak nmbuhat riduka thoft yima yuhur nhai marnya-kahr. Ndnatn kanga yudbat ayaka. ");
INSERT INTO amp_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Na niamohat ka kangko yimaroh nnayur nmbuharoh yak tkafhato yak nohneft niar. Nhai. Na niamota htihato nnakfoni nnanyihato nafrtndohmom. ");
INSERT INTO amp_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Arihat be afo wahtiyaf hanyswako. Tirfa yimam rpa kunys tohyukm htirahkomm tfit nafrtndohrahm. Wom husfirpat rom inji tohrahm wom husf rof inji. ");
INSERT INTO amp_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Nafrtndohruhamn, yifemr toni-ruharn yinemrpno tuf tawo tawo nnarahf. Mmemt sinyaruhatn yinemt-pno tuf tawo tawo nnarahf. Met yimborehfim nhaf inji buga tum tawo tawo nna hakurahm.” ");
INSERT INTO amp_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Wom mrokfot kfomorm nd tohmo met yindarim. Kfo memorm, “Dbha yiham marr nhai mwondh fnah marnyakahr kfo kangko, ‘O hrek yihat ka toh nyukuhwot.’ Be nhai kfo fura-kahko. Nd yihar nhai toh marnyakaht. Toh nyukuhwot. ");
INSERT INTO amp_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Htitwoko marr hifa mwondh marnya fnahwor, kfo kangko, ‘O href hifa yihar tohwor.’ ");
INSERT INTO amp_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ar mmo hari kpt! Yihathu rhu yuharpat hti nhtewakomn to nhai hti nhtakahkma nanhu nianeft.” ");
INSERT INTO amp_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Yau foh mmom kanjo tamoh tamoh nefm yudbat naknitwokomm. Nhai yak hti nhtahato hifa hifa nefrpam nakahko. ");
INSERT INTO amp_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Womrpno kot kitwofn, yudbat yihotatn bmbritn ni tufn nakfo nohkfot nd kot mrokfot. Kot yiruhafnn, womr kotimruhatrn kalabus yirahn. ");
INSERT INTO amp_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","To kalabus yinyeft to nhai bmbri fnahneruhatn. Kot kfoyuk wuroh wiknayuk wuroh marufat bi wiknanint ee btn fnahnerahn.” ");
INSERT INTO amp_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nd yihart ndha tohmo wom yimam tohhato Jisasr wom mrokfot kfo nuhas memomr, “Jisase, Galili thofm Bro Nkifrarko tarioh mthamoatm Pailatr htihato wom yimam yak tkrurafmotr rom yihato nd yimam tarioh mtha hasoyukm wasmomm.” ");
INSERT INTO amp_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jisasr wanyhato kfo memorm, “Nd Pailatr yimam yak tkrurhato wasmo yimarpam htihato ptha duha. Niko ka duka kangko rroh toh nmbuharpam fasohmn ndnettn Bro Nkifrar Pailatrn mrhuhato inji namorm? Nhai. Ndt fasoh dukeft kekwoko. ");
INSERT INTO amp_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Yima bugam, yonent burent, fasoh nefrpam thu nhombra buganimomm. Ndhtet yimam Bro Nkifrar yak batirahrm. Ndnettn nd fasoh nefm mong troh bugakfot. Nhai womenr rim tohtakfot. ");
INSERT INTO amp_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Yo nd Siloamthu 18-pela yimam kunys suhakhato tatmom, to ka kangko ka Jerusalemt tohwa yimam ka nd Siloamthu kunys tatmo yimarparoh toh nmbuham be tu fasoh mifmn kunys tatmotm? Nhai. ");
INSERT INTO amp_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Na kfiwanko be tu nhai. Niko to inji buga. Rpa-hteteko. Niko buga nikmoh fasoh nefm mong trohkfot.” ");
INSERT INTO amp_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Fasoh nefm mong troh duha yimarhu wom kfo nhombra mrokfot kfo memor, “Wom yimar turhu mswirt nuhtamort fik fant. Kto yimorn memor, ‘Afo htiruha bi hirwote nhai.’ Yimorn htimort nd fikt nhai yukha hirrmot. ");
INSERT INTO amp_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ndnettn nd mswirt tohukatohyuk yimar kfo memorr, ‘Wawanyn. Bi husfirpa gunyjimm nia hatohmoyann htimoyant ndar mis nhai yukha hirwonrmot. Hifa hifa bbhat be ndar misn kak furewut. Wayoh hehur thutwant.’ ");
INSERT INTO amp_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Tfit nd mswirt tohukatohyuk yimar inji wanyhato kfo memor, ‘Bro yimaye, kanga afo wurohpenm wom gunyjimr afo tohwonrfot. Tfit afo mishu tpiko bbpam tou yibufr boyibufrrhoyanmn bulmakauroh rim yakhato afo mishu tpiko tou yeny boyenywonraht. ");
INSERT INTO amp_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Inji natiwonhato nhai hirkaht ee btn yoh thuraht. Hirwote be tohraht.’” ");
INSERT INTO amp_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Wom rhu krna Sabat yiharn wom rhu rifinyuk rmontn Jisasr yihato Bro Nkifrarhu mrokfom kfo pthamorm met yindarim. ");
INSERT INTO amp_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nd kunysn rhumot wom mett wom yarhr fknenimotrt, nd yarhrn kak dbohnamourt. Dbohneft nhai yihom tohaf hanyrmoat. 18-pela gunyjimm nd dbohneft hatohmott. Mungranjbimpno inji dbohnamout. Nhai toh susna rhu susna inji narmoat. Benji waswoktahato rhumout. ");
INSERT INTO amp_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jisasr nd mett htihato nakuyakmort. Nakuyakhato kfo memort, “Bar mete, nd dbohnef bebt asomif thu trohwotn.” ");
INSERT INTO amp_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Inji kfoni hanyhato tirt htamort. Tirt htamorte be yudbat nd dbohneft thu troh tanymott. Nd rhu waswok hasoyuk mett be tfit rhu susnamot. Rhu susnahato Bro Nkifrarko kfo yindhor boyindhormotr. ");
INSERT INTO amp_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Tfit nd rhu rifinyuk rmonthu bro yimar namburmor. Memor, “Tamohmpno rhu krna yihar dbohnet yimam yak marnyewarm Jisasr?” Ndnetrn namburmor. Tuhant yindars kfo memorm, “Hingrnayuk yiham 6-pela kfoyet. Dbohnefetko, nd hingrna yihamn niahato yimam htirahmko. Rhu krna yiha dbohnefm hna duha.” ");
INSERT INTO amp_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jisasr wanyhato kfo memorr, “Ar brumharpam pthayet kpt! Ka niko rhu krna yiham nhai nikmoh bulmakaum bupa yat hanykahkomm? ");
INSERT INTO amp_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ndar na yak marnye mett yima Abrahamrhu yonet. Satanr 18-pela gunyjimm yimatn hatohmotr. Nd rot hatohyuk yarhr na rhu krna yihar yak thuneft fasoh neft neya?” ");
INSERT INTO amp_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Be inji kfomotr nd ror kfomo yimam tfit yimtnamom. Jisasr nayuk nefm nd met yindarim htihato kfo yindhormom. ");
INSERT INTO amp_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jisasr tfit ttiwon memorm, “Bro Nkifrarhu kingdomkfot finji akfo nhombrayant? Tamohmn akfo nhombraya? ");
INSERT INTO amp_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Bro Nkifrarhu kingdomkfot kangme tefi mastet tpiyenrn yimar yaknihato turhu mswirtn nuhterr. Nd mastet tpiyenr frdborhahato yonmari bufum korhm. Kto nungam tkit tkiroht ndha niahato wuswomt.” ");
INSERT INTO amp_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Nd rpa mrokfot tfit wom kfo memorm, “Bro Nkifrarhu kingdomkfot finji akfo nhombrayant? ");
INSERT INTO amp_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Bro Nkifrarhu kingdomkfot broni thoft 3-pela bek plauaroh plauapam tefi yispen mifm rihtafhato kur yikopwa kanjo inji broniraht.” ");
INSERT INTO amp_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jisasr Jerusalemko yinyeftpno bok kmim toh fnahhato Bro Nkifrarhu mrokfot kfo nuhas fnahmorm. ");
INSERT INTO amp_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Wom kmithu wom yimar Jisasr yihato ttiwon memorr, “Jisase, nda bbinysofthu wuroh bati yihare, rpa rpa yimarpam yakrahr?” Jisasr wanyhato kfo memorm, ");
INSERT INTO amp_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","25","“Na kfiwanko, yihota rim fnahni yuhate kukentamot. Ndnatn bi arihatn bbukahato bi rim fnahnikfot. Kto tu kuny sikatr nd kuny yifhatikt frkihaf thombat be finji fkneniruhako? Bok yimam briahako tohhato kfo mirahm, ‘Wayak tfanyakna.’ Kfo mirahrr, ‘Ni fitha thofe? Na nhai wom tkit ninhu nyingatikt htirmoyann.’ ");
INSERT INTO amp_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Tfit romn kfo mirahmr, ‘Nom to ninpno rpat nuwa famonom. Yo nmoh kmiroh bro yihotamn Bro Nkifrarhu mrokfefm kfo nuhas bonuhasmonnom.’ ");
INSERT INTO amp_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Tfit rorn kfo mirahrm, ‘Na nhai wom tkitt htirmoyanko. Ka fitha thofeko? Wur fasoh yima bebko. Wuri waikma.’ ");
INSERT INTO amp_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Htirahko Abraham, Aisak Jekofromi yo wom profetm, romrpam Bro Nkifrarhu kingdomkfot rhuruhatm htirahkomm. Niko wuri briahako tohhato tau nknekrahko. ");
INSERT INTO amp_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Nd bbinysof bugathu yimam yiruhamn Bro Nkifrarhu kingdomkfot mrhuhato nd bro yemro burwat yerahmt. ");
INSERT INTO amp_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ndar yihar yimam mongko niayukm mfrfnahnirahm. Yimam nyingako tohakyukm tfit mongko yihom frfnahnirahm.” ");
INSERT INTO amp_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Inji yuhre ptha haso hanyetrn wom Farisim niahato mkfo memom, “Ndashart be tmifn wahtanykahntn wom tkitm wain. Herotr kangr awasann.” ");
INSERT INTO amp_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Inji mkfomotmr, Jisasr tfit kfo memorm, “Nd rim kfota mkfotahato kfo nheh bonhehet yimar wamitwakomr, ‘Href yuwonanohmbam afo nd yarh fknayet yimami dbohnet yimam htiruha. Ka yuwonanohmbamn nd hingrnefenm hingrna bugaruhanm.’ ");
INSERT INTO amp_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Afo bi mirahm, ‘Nd profetr awas-nomr.’ Bingot Jerusalemko profetm wasmoum. Ndnettn na yirhwota Jerusalemtn wasrahma.” ");
INSERT INTO amp_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Jisasr tfit kfo memor, “O Jerusalem! Jerusalem! Kfo tkrurafoyuk profetm ninn was hakutwanm, yo womm tahiye tahiye yebhoh noh hakutwanm. Bok yiham memoua nanhu mofsinhitn ahta akafrohneyann mmem kris yonm yak kafrohwa kanjo, to nhai. Nhai wofnrmouna. ");
INSERT INTO amp_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Be wahti hanyswa, ninhu temperr brio yima duhatr rhurahr. Ariham nhai wom tfit htirhotna. Bi tunn kfo kangn, ‘O Bro Nkifraye, Brorhu yufatpno niayuk yimar wayak marnya bomarnyatwanr.’ Bi tunn inji kfiwune ee tfit htiyakrahna.” ");
INSERT INTO amp_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Wom rhu krna Sabat yihar Jisasr nuwa yat yimor Farisiroh bro yimarhu kunys. Nd Farisiroh nyingam be Jisasrn yimoum. Memoum, “Afo htirahnom ndar rhu krna yihar nhaf tamoh nefm naruhar.” ");
INSERT INTO amp_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Wom yubtet yimar niamorn Jisasrpno mtohmor. ");
INSERT INTO amp_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jisasr nd yimar htihato tfit ttiwonmorm Farisimi boririfhuthu tisam, “Niko finji dukiwako? Boririfhut finji kfiwat? Rhu krna yiha dbohnet yimam yak marnyarfohate ka hifa?” ");
INSERT INTO amp_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Jisasr inji kfo ttiwonmohat nhai wom Farisir ptharmor. Be Jisasr nd yubtet yimar yakmorr nd yubteft yak marnyafmotrr tfit yimor. ");
INSERT INTO amp_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nd yubtet yimar yak marnyafohato tfit toh kekutnimorn Farisim kfo ttiwon memorm, “Nd rhu krna yiharn nikmoh yonm o bulmakaum yau hanyhato tekmn yohnifohat ka nhai bmbri yuk hambrakrfotkomm? O be hti marsisa merfoko, ‘Rhu krna yihayer, to finji yukhato yakruhanomm?’” ");
INSERT INTO amp_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nd Farisim nd ttiwonkfot ttiwonmotrm be tuha mrokfo duhatm tohmom. ");
INSERT INTO amp_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jisasr tohhato hti hasomourm nd nuwa yat niayuk yimam. Yihato mruhaknimoahat be memoum, “Barkof mruhakyuk gajimn amrhunom.” Inji hti hasohato mrokfot be yura fafunamort. ");
INSERT INTO amp_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Kfo memor, “Wom yimar turhu tuhan yak yihar yemro burwat htahato kfo kangrn, ‘Ni wanietwa nanhu tuhan yak yihar. Nd yiha bro yemro burwat htaruha. Wania wayenyhotwannom.’ Inji kfitrn yifi, ni frohann yihato yudbat tu nyingako amruhakniya. Nd nyingako htayuk gajim miruhatn bro yufetmn ahta hanyom. ");
INSERT INTO amp_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Bi mruhetnn kto tu nd burwat htayuk yimar yauyaknehato kfo mirahrn, ‘Na nhai merfoya ninn yudbat nyingako mrhurahn. Na famuya ndu bro yufetr rhurahrt nd tkitt. Ndar tkitt wahtanyns. Ni mongko warhutwa.’ Be bro yimtneft yakrahtn, tfit sinyani mongko yihom rhuneft. ");
INSERT INTO amp_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ndnettn tuhan yak tatrut yihar yemro burwat htahato nakumn, frohann bi yihato nyingako amruhakniya. Yinyeft afo yihato afo mtohkfot womroh mongkorn. Bi nd tu burwat htayuk yimarn yihom htihato kfo kangrn, ‘Asha wamrhun,’ ee nd tur kfoyuk tkittn mrhuneft hifa. Nd burwat rhuyuk met yindarim hti yindhorrahmn. ");
INSERT INTO amp_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ndt tu bro mrokfot. Yimar kangr, ‘Tamoh nefm nann bmbri nyingako mtohnihato nann tamoh tamoh nefm atohakkahtanm yimam kfo yindhorrahma,’ nd yimar kto Bro Nkifrar yak dbhurakruharr yiro wahtarahrr. Yimar turhu yufat yiro wahtahato yimam nhai kmi kmim yindhorkahmr, nd yimar Bro Nkifrar tfit yura wuhtarahrr.” ");
INSERT INTO amp_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jisasr nd nuwam nakuyakmo Farisir kfo memorr, “Kangn yenyhoyuk yimam ayaka, frohann akfo amiya be yimatrpami tunhu kmithu bro maruyet yimarpam anaku tutuhaya. Rom kfakrahn, to be ni hayuk yeshrt bi turoh tire tawo hirahmn. Frohann nd yihotat ahika. ");
INSERT INTO amp_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ninhu nuwa nngrit, tamoh tamoh yeshrt yaneft fasoh yima bebpam, yimam nd wura bebetm, nyinga kunyjetm, ndmn nakuyakkfot. ");
INSERT INTO amp_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Rom nakurahn duka kinyaknirahm, to finji yeshrim yakruhanomn tngo nakuruhanomm. Ndhtet yima bebm Bro Nkifrar kukatohworm. Rom nakurahn tawo Bro Nkifrar wany yakiohato nohnita yimam sinyaruha yiha tawo Bro Nkifrar htiruharn yak marnya bomarnyarahrn.” ");
INSERT INTO amp_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nd rpat nuwa ye hasoyukroh womr nd Jisasr kfomo mrokfot wanyhato Jisasr kfomorr, memorr, “Yimar Bro Nkifrarhu kingdomkfotn tohhato nuwa yanyeft ka nd yimar yindhorkfot.” ");
INSERT INTO amp_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jisasr wanyhato kfo memorr, “Wom yimar bro yemro burwat hta yibonetrn kmi kmiroh yimam kfo duka hanymorm nd yemro burwathu nianeft. ");
INSERT INTO amp_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nd yemro burwat yak htatamortn tu ye yiharn nd tu yemro burwat htayuk yimar kfo tkrurmorr turhu hingrna yimar. Memorr, ‘Waikahnn nd na kfo hanymo yimam wakfo wamitwanm, “Hrek korht nd yemro burwathu ye yihar. Wania hnetwako.” ’ ");
INSERT INTO amp_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nd hingrna yimar inji wany sanyhato yimor. Yihato kfo hanymoatrm nhai rroh womr kfo yibonrmor. Womr yi kfomorr, kfo memor, ‘Na wom bbinysof nmbuhat wikneyantn afo ndthu htit yiruha. Ndnatn na nhai nierhota.’ ");
INSERT INTO amp_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Womr yi ttiwonmorr, kfo memor, ‘Na hingrna-yuk 10-pela nfri bulmakaum wiknaroyann afo hanyrhoyanmn htiruha rroh hingrneft.’ ");
INSERT INTO amp_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Tfit womr yi ttiwonmor, kfo memor, ‘O na hrek tuhan yekann nhai niewota.’ ");
INSERT INTO amp_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Be inji kfo kur bugamotm be tfit yimor. Yihato turhu bro yimar mkfo memorr, ‘Nd ni kfomo yimam yi ttiwontanm nianeft, nhai womr kfo yibonrfor nianeft. Ndnatn tfit nia.’ Be nd bro yimar inji wanyhato namburmor. Namburhato tfit turhu hingrna yimar kfo memorr, ‘Tfit wai habrikahnn fasoh yima bebm wayak habrin. Wuskapa duha yimam, yimam nyinga kunyjetm, wura bebetm, tir bebetm, ndhtet ndhtet yimam wayak habrin. Wayak habrikahnmn nanhu kunys aniam.’ ");
INSERT INTO amp_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Nd bro yimar kfomo yuhatn yak hikhato nd yimam ror kfoyukm yak habrihato mkfo memorr, ‘Nd ni kfoyuk yimam bi fak habriyanm. Nd yimarpampno kunys tafi furkihkaht. Tom yuhre wom rrfam korh furewum.’ ");
INSERT INTO amp_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Be nd bro yimar tfit kfo memor, ‘Na wofnkaha wom rrfam rhu furaneft. Kanga kunys afurkiht. Tfit waikahnn nd bro yihota naff yuham yo mswirroh gna nanyor yuhamn tohwa yimam ndm wakfak habri hanynm. Rompno kunys furkihraht. ");
INSERT INTO amp_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Na kfiwann, na nd barkof kfo titamo yimam be nhai nd na htayuk yemro burwat nia yeruhatm.’” ");
INSERT INTO amp_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Jisasr bok yimam yau hik hanymotmr kekutnihato kfo memorm, ");
INSERT INTO amp_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Yimar nanpno niahato kangr, nanhu disaiper yimaya aruha, nd yimar turhu yifa mndarm, turhu yon tuhanm yo turhu yima yuhurhu dukefm be mondt hta duha. Nann afo mondt htakfot. Yifammam, yon tuhanm be inji rom dukani hanykfot. ");
INSERT INTO amp_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Yo yimar kangr, nanhu disaiper yimaya aruha, nd yimar nhai yakrme-kfot krhoparoh titaneft. Na krhopam yakmo kanjo nd yimar krhopam yakkfot. Nhai yakrmekfot. ");
INSERT INTO amp_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Wom yimar kunys hingrnaneft, nhai be yudbat sinyanihato singaknikahrt. Barkofpam afo yorhwarn kunyshu hingrna yuham afo dukahato kak nhtewur. Kunys hingrna thoft finji finji hingrnarhoyant? Finji finji marum htaruha nd kunyshu hingrna wuskaroh wiknaneft? Nd ndm afo rhuhato kak nhtewurm. ");
INSERT INTO amp_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Be asomif waduka sinyahato singa furaknineft htirahnr rahurpam kasinyahato mtuhafnirahrt. Womm htihato haningerahmr nd yimar. ");
INSERT INTO amp_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Kfo dadidoh mirahmr, ‘Kiwayeye! Kunyr kasinya hasomorr memor, “Ka hingrna bugaruhanr.” ’ ");
INSERT INTO amp_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ten tausen amiyet kantrikfot merfotm wom twenti tausen amiyet kantrikfot ai hfnahnomm nhai be bmbri wahta brurakhato yiyaknikahm. Barkofpam afo nd ten tausen amiyet kantrikfot afo tum yak nhtahato hti nhtewum. Tum yak nhombra hifa hifa ee kitm nnat. Nhai, tum hti nhombra-titme, ");
INSERT INTO amp_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","be wom kantrikfot wuri afo tohetmn bmbri wom yimam yitamn kfo rafiwumm. ");
INSERT INTO amp_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","To be nd rpahtet yuhatn wom yimarhu dukefr nhai nanhu dukefrn rhu bronikahrr nhai nanhu disaiperr tohruhatr.” ");
INSERT INTO amp_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Youpam tamoh tamoh roh nrhayukem. Nd youpam nhai wom you gb ye juha, to tfit finji kanjo naruhatnm tfit you gb yeruham? Bi be, bi fasohem. ");
INSERT INTO amp_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ndhtet youpam be nhai tfit mswirmn trufkfot. Nhai tfit bulmakau rispno tatkbotk hmbrihato mswirm truf habrikfot. Fasohmn tubatuyefiwum. Yimbhindangeteko, ndar na kfiwa mrokfot wanykfot.” ");
INSERT INTO amp_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Jisasr takis marut yak htfasyuk yimami fasoh fasoh nefm nayet yimampno brbo yimom mrokfo wanyneft, ");
INSERT INTO amp_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Farisimi Bro Nkifrarhu boririfhuthu tisam htihato kfo hutt memom, “Nd yima Jisasr fasoh yima bebmpno rpat nabnothato nuwa kawum.” ");
INSERT INTO amp_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Inji kfomotm Jisasr wanyhato kfo memor, ");
INSERT INTO amp_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Bro Nkifrarhu yindhorneft inji. Wom yimar 100 sifsifetr rhuhato nd wan handretyukr hti hambrorfohat ka be mumafrforr? Na kanga ka nhai mumafrfotrr. Ndwom 99 kforpat kipr yeyuk tkitt htanyrform afo nd wan handretyukr afo yau hambrak habrirforr. Bi mhambrekrre ee yima yuhur mirhurforr. ");
INSERT INTO amp_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Yima yuhur mirhuhato be yindhorefrparpno tita hatoh hanyrforr kmiko. ");
INSERT INTO amp_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Kmifat mhtahato kfo merform, ‘Na hti hambromoa sifsifr bi tfit hambrekanr, wayindhornhokma.’ To inji narfor. ");
INSERT INTO amp_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Na kfiwanko nd kfo nhombrakfot kfiwa 99 yimam, bi dboriohrhut rhuhato nhai tfit rroh yima yuhum wom yak kekutkfot. Nd yimam nhai be mfro dukakahrm. Bro Nkifrarhu tu bro dukeft kitt ndwom rpa yimar bi fasoh nefm yihato tfit mtoh kekuthato niamor. Nd yimarn Bro Nkifrar be tu mfro yindhorworr.” ");
INSERT INTO amp_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Wom mett ten kina yak brurfam yakitohhato wom fat hti hambroneft. Htirahnt lam hta funanihato kunyshu wuss hfhan bugarahtt nd rpa marufathu hambroneftn. ");
INSERT INTO amp_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Hambro hany hambro hany, bi fektt, htirahnt tuthu yimatm nakuyak bugaruhatm, kfo mirahtm, ‘Wayindhornhokma. Na hambromoa marufat bi fekant.’ ");
INSERT INTO amp_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","To nd mrokfot kanjo Bro Nkifrar yindhor-worr wom yimar fasoh nefm tohhato tfit nd fasoh nefm mong trohneft.” ");
INSERT INTO amp_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Tfit wom kfo nhombra mrokfot kfo memor, “Wom yimarhu yon husf tohmouf. ");
INSERT INTO amp_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Wom nmemr yihato yifemr mkfo memorr, ‘Dajaya, nani nanhu najomr, nmoh wuskam bi wayak nhtahikahtnno nanhum kanga bi ayakanm.’ Be yifemr wany yakio-hato fak nhtahemorf. ");
INSERT INTO amp_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Be wom nmemrhu wuskam yakhato tuha kmi thofmpno maruhampno nayak tuknaknihato maruharpam myaknihato nhai wom warhu hasormor. Nndo wom wuri kmimn yihato turhu nd fasoh fasoh nefmpno nd ror hanyuk maruhenm tubatu wita bugamorm. ");
INSERT INTO amp_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Tubatu witahato kto nd ror tohyuk kmit bro yatinoh wormr tohmor. Be nd yihar nd yimar memor, ‘Be na nohruha yeshrimn. To fitha marufam yakrhoyanm yeshriyenm wiknarhoya? Na hnayuk marufenm to bi tubatu bugamoyanm.’ ");
INSERT INTO amp_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Be mdukatihato wom yimarpno yihato wom hingrneft fakmor. Fohm tohukatoh inji nahemourr. ");
INSERT INTO amp_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Nd fohm tohukatohhato memour, ‘Nd fohroh heyuk binharoh bin krm ndm ayeya.’ Nhai wom yimarn wom tu yeshriyen mifm hermoarr. ");
INSERT INTO amp_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Be toh nhombra hanysihato tfit tur dukamor, ‘Nanhu yifemrhu hingrna yimam nhai be inji yatinoh dbfakahm. Na asha tohwoyann masat yatinoh dbfiwa. Tamohmpno asha na yatinoh dbfa hasiwoya? ");
INSERT INTO amp_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Tfit tukanhuko yiruha. Yirhoyann tukanhu yifemr mkfo yongmaknihato mkfo miruhanr, “Dajaya, Bro Nkifrari ni be tu fasoh neft namoyanfn. Nhai tu hifa dborioh neft narmoyanfn. ");
INSERT INTO amp_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Na tu be bi fasoh yon beba. Na nhai tu dborioh yonann kfo mirhona, ‘Nanhu yoner.’ Nhai. Na ninhu hingrna yima furaya arhutwaya.” ’ ");
INSERT INTO amp_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Be nd dukeft yakmorn sinyamor. Sinyanihato yimor turhu yifemrpno. Yi yimorn kmit mfnahmor. Yuhre wuri yau hanyetrn yifemr htiyakmorr. Htiyakhato tfit yifemrhu yima yuhur yinem yonr inji tfit htiyakmohat nhai bmtarmorr. Be yinem yonrpno toni-yaknihato rim kihato hanurmorr. ");
INSERT INTO amp_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Yinem yonr sinyahato yifemr kfo memorr, ‘Dajaya, Bro Nkifrari ni be tu fasoh neft namoyanfn. Na nhai tu dborioh yonann kfo miruha, “Nanhu yoner.” Nhai.’ ");
INSERT INTO amp_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","To Yifemr nd yonr kfomo tngt wany marsisahato turhu hingrna yimam kfo memorm, ‘Nanhu wondht wayaknekahkomn wawondh-komr. Tor yuke hmbreshar, yo tirpinyaft hatohyuk ringr yo su wuram. Nd ndm wayaknekahkomn wawondhkomr. ");
INSERT INTO amp_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Yo tor bulmakau yogr. Ndr wawaskahkomrn roh tfnhato rpat rhu rifinyhato yerahnom. Nuwa yetahato btn ptha yindhor boyindhorrahnom. ");
INSERT INTO amp_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Nanhu yonr bi nohniyetrn bi tfit bi tor bi nier. Bi wom kmimn nkiranimor. To nhai, bi asor bi nier.’ Ndnatn nd bro yemro burwat hta yehato grha yindhormom. ");
INSERT INTO amp_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Bro najomr mswirko toh tanyhato mwanyaknimor. ‘Arme tamohtpno grha yindhorwam?’ ");
INSERT INTO amp_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Wom hingrna yimar nakuyakhato ttiwonmorr, ‘Ndm tamohmn grha yindhorwam?’ ");
INSERT INTO amp_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Kfo kangrr, ‘Ninhu nmemr href tfit mfnahtr, yifemr ror htiyakhato rorhu yindhor nmbuhatn bulmakaur washato ndr yehato grha yindhorwom.’ ");
INSERT INTO amp_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Be najomr inji wanymohat nhai ror yihato grha yindhornho inji narmorm. Nambur yima yuhetrn be rhumor. Yifemr hti hasotihato yimorn yinemr mkfo memorr, ‘Tamohmpno ni nia duha yita?’ ");
INSERT INTO amp_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Yinemr sinyahato yifemr kfo memorr, ‘Wawanyn! Na bok gunyjimm hingrna yima furam kanjo ninhu hingrneft fakitoh hnahemoyann. Nhai ninhu wom tngt hanjbornarmoyant. Nhai. Hingrna marnya hnamoya. Ni nhai ndt htihato wom fohenr washato marimor, “Asor fohr. Ndr watasokahnn ninhu yimatm nakukahnm warhu wayako.” Be tu nhai mif inji narmo. ");
INSERT INTO amp_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nd kmi kmi yaum kanjo tahuta htfaset yonrn ninhu fohr wasahuknr. Nhai mrokfom.’ ");
INSERT INTO amp_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Yifemr tfit sinyahato yinemr kfo memorr, ‘Ni toh hnamohat nanpno brbo toh hnamo. To mirahn ka nanhu tamoh tamohm ka womrohem. Nhai. Ninuhem. ");
INSERT INTO amp_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ndnettn ninhu nmemr bi nohetr bi tor bi sinyer. Bi wom tkitm bi nkiraniyetr bi tor bi nier. Ndnettn ni niahato nom rpat rhuhato yindhorkfot.’” ");
INSERT INTO amp_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jisasr turhu disaiperm wom mrokfot yakhato kfo ptha nuhas memorm, “Wom yimar nhai be kukenhato harhurmoar yeshri wuska maru kunym. Nd yeshri wuska maru kunym wom yimar yakmorn rorn nd rorhu tamoh tamoht tohukatoh hemourr. Wom yiha wom yimam nd yimarpno yihato mkfo memomr, ‘Nd ninhu wuskam tohukatohwa yimar wom wuskam he fura bofura hanitrm yimam, womnam turn kak nfhotiyaf hanitr wom wuskam.’ ");
INSERT INTO amp_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nd yimar inji wanyhato nakuyakmorr nd wuska tohukatohmoa yimar. Nakuyakhato niamotr ttiwon memorr, ‘Na nd wanymo mrokfot ka tu mrokfot wanymoya? Nd wuskaroh yak nfhoti nmbuhat yo yak he furafhany nmbuhat? Inji wanymoyann ni be nhai wom tohukatohruhatnm nanhu tamoh tamohm. Be yak tuhaforuhann. Wuroht afo waikahnn tamoh tamohm yak hta kars bokars tanykahnm yirahn. Ni nd namo neft gontwatn wahta buga tanykahnm yirahn.’ ");
INSERT INTO amp_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Be nd tohukatohr yimorn kfo memor, ‘Na nd yimar yak tuhaf thombat be finji narhoya kmiko rhu fura thombat? Na nhai wofnkaha sfno marufapa duha rhuhato womm rim tndauneft. Nhai. Be tu bro yimtnaneft yakrahta na inji naneft. Yo nhaft na tu be narho bnhaya. Womm kfo mirahma, “Wania nmoh mswirthu bbpam watou kekuthennom,” na nhai hingrnarhota.’ ");
INSERT INTO amp_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Duka hanysihato kfo memor, ‘Nhai mrokfom. Tot wom dukeft. Inji naruha, be yimam nanhu neft hti yindhorhato kfakrahma yimarhu hingrneft yak tuhaf thombat.’ ");
INSERT INTO amp_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Be nd dukefetrn naku yak hanymorm yimam nd wuskam tamoh tamohm afo yak furani hanymom. Barkof yimar niamotr ttiwon memorr, ‘Nine tamoht yakmo?’ ");
INSERT INTO amp_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Nd yimar memor, ‘Na 100 dram welkfot fakmoya.’ Kfo memorr, ‘Nd ni be afo yak furanimo wel dramthu kfo nuhas gontwat mirahn akfo amiya 100 dram welkfot, be wawandfatwa 50 dram welkforpat.’ ");
INSERT INTO amp_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Tfit womr niamotr ttiwonmorr, ‘Ni tamoh tamohm afo yak furanimo?’ Memor, ‘Nane 100 wit bekm afo fak furanimoya.’ Tohukatohr memorr, ‘Asot ni yak furanimo wit bekroh kfo nuhas gontwat Nd gontwatn wawandfa wamitwa, “Na 80 bek witkforpat fakmoya.” Mirahn awandfaya 100 wit bekm.’ ");
INSERT INTO amp_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Wandfa buganimotmm nd tohukatohr nd gontwam nd yimarpno hanyhato yimar htihato kfo yindhor memorr, ‘Be tu hifa yima dukefrpno hingrnamo. Duka tunga yima yuhurpno inji hingrnamo. Nhai mrokfom.’ Nd yimar be inji kfo yindhormorr tohukatohr. Wahtiko. Ndar bbinysofthu yimam bi tum hti dukamomt dborioh rhu nmbuhathu yakyuk yihota yuhat. Niko nukeft tohwa yimako rpahtet neft wanatwako. Waduka marnyatwakomt dborioh ruheft yakyuk yihota yuhat.” ");
INSERT INTO amp_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Jisasr tfit nd mrokfot kfo hik buga memor, “Niko nd bbinysofthu tamoh tamoh wuskam yakneft wom yimam nd wuskam kkopentiwam hti dukahato hekfot. Hirahkomm kfo yindhorrahmko. Inji narahko nd nikmoh noh yihar Bro Nkifrar yakmiyakruharkomn hendhorrahrko. ");
INSERT INTO amp_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Frohr tefi wuskenm yahutkomr fakitoh marnyerm, bro wuskam ror yakitohneft yakitoh marnyarahrm. Nhai yakitoh marnyarform tefi shrm nd yimar nhai yakitoh marnyaruhatr bro shrm. ");
INSERT INTO amp_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nda bbinysofthu tamoh tamoh wuskam nhai yakitoh marnya-rfokomm, to tfit frohm hefenr yorhwa wuskam hiruhatmko yakitoh-ruhakomm? ");
INSERT INTO amp_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Womroh tamoh tamoh wuskam nhai hti duka marnyaf hanyhekahkomm, to tfit frohm tawo ninhu yufathu wuskam yakhiruhamn? ");
INSERT INTO amp_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Nhai wom yimar najomrofhu yinhitn rhurfotr. Nhai. Womrpar yuhurrfour, womr yati yejborharforr. Womrhu mrokforpam wany yakiorfour, womrhum nhai. Niko nhai Bro Nkifrarhu dukefti maruharoh dukeft rpat yakitohkfot.” ");
INSERT INTO amp_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisim rom be maru hingrneftn rroh dukefm frtkafmoum. Ndnetmn Jisasr inji kfomohat nd yimam yurak krtit karikomomr. ");
INSERT INTO amp_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jisasr sinyahato kfo memorm, “Niko newa nefm yimam htitamko kfo kangm, ‘Ka hifa dborioh nefm newuko.’ Nheno. Bro Nkifrarhu nyingaye htitworko nikmoh fasoh nefm yirok yima toh rawofm yorhwam. Nikmoh yima rifhumio Bro Nkifrar faso hti bebworm. Tngtn be yuwi furewut. Yimam kfo yamukam, ‘Ndm hifa nefem,’ Bro Nkifrar htihato kfo kangr, ‘Ndm fasoh nefem.’ ");
INSERT INTO amp_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Bingotrhof nkifra boririfhut, Mosesr yakmot, yo profetm kfo pthamoa mrokfom, afo nd mrokfomn yimam yak hik hna yak hik hnamommn wuroht Jon Baftaisrpnone be mfafho-nimomt. Jon Baftaisrn hnamort Bro Nkifrarhu kingdomkfothu mrokfot. Be nd mrokfotn bi bronittm kmi kmim. Bronitatt kmi kmiroh yimam nd kingdomkfothu yinyeftn yima yuhum bi mfro sinyewum. ");
INSERT INTO amp_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","To wom mrokfot. Ndar mounti bbinysoft rof rim batinirahf. Nhai Bro Nkifrarhu wom tefi tefi mrokfo nmbuhat be inji naruhatt.” ");
INSERT INTO amp_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Tuhan yak thu nmbuhat ndt Jisasr kfo memor, “Fitoh yimar turhu yak tuhant yak tuhafhato tfit wom nfri mett fekr, nd nfri mett be ijoh yuhathu metet. Yo wom yimar yak tuhafet mett tfit womrn fekrt, ndt to ijoh yuhathu metet.” ");
INSERT INTO amp_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jisasr tfit wom mrokfot riyakhato kfo ptha memor, “Wom yiha wom maru kunyet yimar tohmor. Rorhu wondh tha, yeshri, tamoh tamoht be bro bro maru kfetrpam fakmour. ");
INSERT INTO amp_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","Yo tor tohmor wom yima bebr. Rorhu yufat Lasarusr. Nd maru kunyet yimarhu kuny yifhatikt ndha rhutamour. Duka memour, ‘Nd maru kunyet yimar ye bruraf hanyuk dborioh dborioh yeshrthu krpupenm tebor rfashit misuhyukm nann ye tuthatak hanyruhanm.’ Inji dukahato rim rhuta hasomour. Lasarusenr nd yonmari, yonmari fhutpno kku bebt harhutamoahat memoum, ‘Nndo yau kuteter.’ Nd fhu tikroh kku bunyangrt tonemoatt tfit yaum yimoamn tepen dbrorhamoumr. ");
INSERT INTO amp_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Lasarusenr tohhany toh hanymorne nohmor. Nohmotr rorhu yafothat mounmotm yaknimomt, Abrahamrpno brbo mhtanymomt yura hefenrn. Tfit rorhu mongkorn nd maru kunyet yimar nohmotr fopmomr. ");
INSERT INTO amp_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nd maru kunyet yimar nohnihato rorhu yafothat Maringour yimot. Maringour yihato be mitasismor kahtn. Memor, ‘Kekutak auhtiya,’ Abrahamr yurak wuhtimorr. Abrahamrhu kkrekorn Lasarusr rhumor. ");
INSERT INTO amp_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nd maru kunyet yimar nd kah nyunguramt tohhato naku tuhaf memor, ‘Daja Abrahame, wayuhuwafkahna Lasarusr wakfokahtnr bupenm tirpinyafe tayifaknekahrn nanhu tort bupaye ahta gonngafort. Na tu be bro kaht tohwa.’ ");
INSERT INTO amp_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Abrahamr kekutak wahtihato kfo memorr, ‘Wawanyn bar yone, ni yima nfri tohmohat ninhu hifa yihar tohmour, Lasarusr nd yihat fasoh tkit bebt warhutamor. Tfit arihat ror bi hifa tkitt yorhwarn ni bi tfit fasoh tkitt korhn. ");
INSERT INTO amp_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","To ror nakutatnr finji nieruhar? Nhai yihotam. Niko watohngotwoko nom ako yura yuwa tohngotwonom. Nikomi nom buha Bro Nkifrar frtmbhafmort yihotat.’ ");
INSERT INTO amp_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Be wom maru kunyet yimar inji wanysihato kfo memor, ‘Dajaya, be ndnatn tfit wom mrokfot kfiwann. Kangane, Lasarusre wakfo tkrurafkahtnr nanhu yifemroh kunyko air. ");
INSERT INTO amp_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Nanhu nmemrom tom 5-pelakfot tohwom. Aikahrn akfotwarm, rroh tohneft mirahm na tohmo toheft atoh hiknom. Rroh tohneft hifa hifa atohtwam. Na finji wofnkaha na tohwa tkitt rom niahato kaht yihom tohneft.’ ");
INSERT INTO amp_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abrahamr kfo memorr, ‘Lasarusr nhai tfit yihato kfokfot ninhu nmemrom. Tom Mosesrhu boririfhum yo profetroh mrokfom, rom nd mrokfom htihato kfoyuk yuhatn toh hikkfot.’ ");
INSERT INTO amp_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Tfit nd maru kunyet yimar kfo wok memorr, ‘Daja Abrahame, nd nkifra mrokfom be nhai wany yakio-ruhatmm. Womr nohhato tfit sinyahato ptharahrm ee btn wany yakiorahmr.’ ");
INSERT INTO amp_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Tfit Abrahamr memor, ‘Nhai Mosesrhu boririfhum o profetm pthayuk mrokfom nhai wany yakiokahmm. To nhai tfit womr nohhato tfit sinyahto pthahekfot mrokfot. Ror nohhato tfit sinya pthayuk mrokfom be nhai wany yakioruhatmm.’” ");
INSERT INTO amp_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jisasr turhu disaiperm kfo memorm, “Yima yuhum sinyarahmko fasoh nefroh naneft. Be wom yimarn niahato mkfo kangrn, ‘Ndur yuhat warine o ndur shrt warimakn.’ Nd yak tkruryuk yimar dukaf hanykfot. Bro Nkifrar be yak tutfarahrr. ");
INSERT INTO amp_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Wom yimar ndar na hikwa yonenm frnhehektrm fasoh nefm fsuhm, nd frnhehakyuk yimar bro tahis yakhato mohtpitn tmbrekhato tek dany yuhat yafhohato miptkokfot. Tohruharn fasoh yihotat hanyrahrm. ");
INSERT INTO amp_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Wom Kristen yimar niahato ni wom Kristenn fasoh nefm nern, ni be tohhato kfo mekfot, ‘Wurena mirahn inji anaya.’ Inji kfitn nd yimar tohhato kfo kangr, ‘O, wurene na be tu fasoh neft neyann. Nhai tu dborioh neft narfoyann.’ Bi inji kfiwurn, to be mirahn nd ror nayuk neft tfit wom adukayant. Be duka mumafokfot. ");
INSERT INTO amp_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","O 7-pela taimkfot fak nhehrn o finji nern o tamoh nefm nahato tfit 7-pela taim niahato nnakfo nuhashato nnakfo gbhufnm, to mirahn tfit adukayanm ror nayuk nefm. Be duka mumafokfot.” ");
INSERT INTO amp_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Jisasrhu disaiperm Jisasr kfo memomr, “Wathu bmtatwannom. Be Bro Nkifrarhu dukefrpam arhu-twamnom nmoh yima yuhum.” ");
INSERT INTO amp_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jisasr wanyhato kfo memorm, “Bro Nkifrarhu dukefenr be ndar sayor tpiyenr kanjo rhuhato kfo mirahn, ‘Ndar miye wayoh tundonikahnn tfit wusha tektn wamitohkahnn wasinya.’ Inji kforahn be htirahnt nd mis ninhu tng yuhatn hikraht.” ");
INSERT INTO amp_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Nd mrokfot inji kfonihato tfit wom mrokfot kfo memorm, “Niko hingrna yimetko rhurfohat ka tfit nikomn hta mska garirfokomm? Na kanga ka nhai. ");
INSERT INTO amp_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Hingrna yimamn mihingrnakhato tfit mhta romn yeshrim hta mskaherfotmko niko be yenyefrpat yarfoko. Nikmoh hta mskafhehato kto wuroh mongko rrohm. ");
INSERT INTO amp_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","To ka finji dukewako? Nd hingrna yimam niko tohukatohkmoh mrokfom hingrna yimam hikneft ka kfo yindhorrfokomm? Na kanga ka nhai. ");
INSERT INTO amp_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","To be rpahtet neft niko Bro Nkifrar kfoyuk hingrneft hingrna buga hanyeft. Be kfo mekfot, ‘Nom hingrna fura yimayenom. Ni kfoyuk hingrneft bi hingrnamonomt.’” ");
INSERT INTO amp_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Jerusalemko yimoa yihotat buha Galili Sameriafhu kmi nanyor yuhatn yihotat ruhettn nd nanyor yuhatn faumoumt. Jisasr nd yihotatn yimor. ");
INSERT INTO amp_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Yi yihato be yuhre kmit mifau fnah hanymort, ka nd 10-pela lepra dbohnet yimam Jisasrhu nia mrokfot wanyhato fau tebfi hnamom. Yau hnehato Jisasr htiyakmomr. ");
INSERT INTO amp_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Be wuri yau hnehato Jisasrhu yufat naku hnehato kfo memom, “Bro yima Jisase! Wahti yuhuwafnnom.” ");
INSERT INTO amp_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jisasr nd yimam htihato kfo memorm, “Temperr tohyuk prismpno waikahkomn romn hti kotharahmko nikmoh dbohnefm.” Inji kfafmotrm yimom. Buha yihotatn nd lepra dbohneft thu truf tanymotm. ");
INSERT INTO amp_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Be nd yimam lepra dbohneft thu truf tanymohat nhai marimom, “Jisasr tfit miyak nuhasrahnomr tham.” Nhai. Rpa Sameria thofrpar lepra dbohneft thu truf tanymohat Bro Nkifrarhu bro yindhoreft yakmottr be yindhoref-rparpno tfit yihato ");
INSERT INTO amp_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Jisasrhu wuram-pno msuhmor. Msuhhato mkfo yindhor boyindhormorr. ");
INSERT INTO amp_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jisasr nd rpa yimarpar htiyakhato kfo memor, “Na famuya ka 10-pela yima bugako dbohneft thu truf tanysisko. Ndwom 9-pelakfot to fitom? ");
INSERT INTO amp_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Tamohmpno ndar womha kmi thofrpar tfit niahato Bro Nkifrar mkfo yindhorwarr?” ");
INSERT INTO amp_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Be nd yimar Jisasr yak kasinyahato kfo memorr, “Nhai mrokfom, wanju. Ni ndar dbohneft thu truf tanyhato tunn duka famu, ‘Na hrek Jisasrpno yitahat ndar dbohneft kak thuwort.’ Inji dukahato niesn Bro nkifrar bi fak marnyern.” ");
INSERT INTO amp_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Wom Farisim yihato Jisasr mttiwon memomr, “Fitoh yiha Bro Nkifrarhu kingdomkfot htiruhanomt?” Jisasr kfo memorm, “Bro Nkifrarhu kingdomkfot nhai be tamohtet neftn nyingaye htiyuket. Nhai. ");
INSERT INTO amp_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Nhai turn kingr tohruhatr kfo miruham, ‘Asor nmoh kingr. Asor asha bi tohukatohwor nomn.’ O nhai miruhatm, ‘Bi wusor wusharhof yimamn tohukatohwor.’ Nhai inji htihato kforuhatm. Niko ttiwon ttiwoneft Bro Nkifrar nhai wom fitha king tohkahr. Tor bi nikmoh yima yuhumn Bro Nkifrarhu kingdomkfot tohhato kak hta bohtewurko.” ");
INSERT INTO amp_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Jisasr kekutnihato turhu disaiperm kfo memorm, “Niko kto Bro Najomr hti hambraf thoft to inji kfo mirahko, ‘To finji tfit htiyakruhanomr yawihna thombat?’ To nhai. Nhai htiyakruhatkomr. ");
INSERT INTO amp_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Mirahko yimam kfoyuk mrokfom awany yakionom. Yimam kangmko, ‘O nd nom gari hasomo Jisasr tor bi ndha nd kmit mifnahr, o tor bi nd kmitn, o wusor ndur kmitn.’ Mirahko wany yakionihato amenyom, ‘E, uwa, afo nd kmit yihato htirahnomr. Bi nia mifr.’ ");
INSERT INTO amp_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Htitwokomr toh fnhur yohni thombat. Fnhu trfefm yambohritna thombat nhai rpa tkitt htikahmr. Kmi kmim hti bugewumr. Na Bro Najoma tfit yawihna thombat to inji kmi kmim htiyakrahma. ");
INSERT INTO amp_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Nhai be bmbri, afo barkofpam na Bro Najoma afo tukanhu kmi thofmn wom wom krhopam hihato hanyjbor-narahmm na kfoyuk mrokfom. Nhai wany yakiorhotma. ");
INSERT INTO amp_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Noarhu tndht wanukwokomt. Nd yiharhof yimam namo kanjo Bro Najomr yawihna thombat inji na mmo bammo hasorahm yimam. ");
INSERT INTO amp_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Noarhu yiha to inji namom yimam. Rom to be nuwa ye mmo bammo haso, yo tuhan yak, nd nefrpam be na hasomommn, nhai wom tamoh dukefm rhurmomm. Be inji foh nungam kanjo mmo hasetm Noa riphar sift fknemom. Bi yiro sift tohetmn bro hnut niamot. Nd wom womt nd bro hnutn noh ptko witamom. ");
INSERT INTO amp_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Lotrhu tndht nhaft to inji. Lotrhu yiha tohmo yimam nhaf to be nd turoh nuwa ye mmoneft yo wommpno wuskam yak tuknanefm, yo mswir hingrna, kuny hingrna, nd nd nefm duka hasomomn nhai wom dukefm dukarmom. ");
INSERT INTO amp_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Lotr nd kmi Sodomt htanymort, bi be kah rifhumi kah rifuhet tahim mountko wuyohninamohat nd kmi Sodomthu met yindari bugam nhai rhurmom. Be tuha kmi Sodomtn mikur batinihato be tounpam rhumom. ");
INSERT INTO amp_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Na yawihna yihar to be nd rpahtet neft rhuraht. ");
INSERT INTO amp_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","To inji mmo bommo hasorahm. Yimar briahako toh mmo hasohato mirahr ka kunyko toneni wuskam ayaka. Nhai. Yimar mswir toh hasoyukr to inji narahr. Mirahr, ‘Tfit kunyko toni hany wuskam yakruha.’ To nhai. ");
INSERT INTO amp_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Niko waduka hiktwakomt nd Lotrhu mett yakmo neft. ");
INSERT INTO amp_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Fitoh yimar turhu yima yuhurhu dukefm mondt htewurm kto nd yimarhu yafothat fasoh tkitt yiraht. Fitoh yimar Bro Nkifrarhu dukefm mondt htewurm nd yimarhu yafothat kto rhu marnyaraht. ");
INSERT INTO amp_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Na kfiwanko, mikohta, ‘Na Bro Najoma yifung aneya,’ be htirahko hus sawohf tikt hwi hasetf, Bro Nkifrar rofhu womr o womt yaknirahr. Mett faknir, yindarir tuha sfnoh tikt frhambro hasorahr. Yindarir faknir, mett tuha sfnoh tikt frhambro hasoraht. ");
INSERT INTO amp_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Hus metf bretpa hingrnayuk plaua-pam hingrna hasorahf, Bro Nkifrar womt yakruharn womt rhuraht. ");
INSERT INTO amp_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Hus yimaf mswirt toh hasorahf, Bro Nkifrar womr yakruharn womr rhurahr.” ");
INSERT INTO amp_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jisasr inji kfo nuhas buganimotrm tur hik htfasmoa yimar sinyahato ttiwon memorr, “Bro Yimaye, nd nefm ni kfiwam fitha rhuruhatm htiruhanomm?” Jisasr kfo memorr, “Foh gum kfe bdgwa tkitmn kungorohm yi rifinywom.” ");
INSERT INTO amp_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jisasr kfomorm yiha yiha Bro Nkifrarpno kfo bruttna hatohneft. Ndnetrn memor, “Wom kfo nhombra mrokfot akfokahta yima yuhum yakrahm. Yakruhamn nhai ffhirmtaruhatm kfo bruttnaneft.” ");
INSERT INTO amp_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Nd kfo nhombra mrokfot kfo memor, “Wom bro tauntn wom jasr tohmour. Nd jasr nhai Bror duka yanhafo hanyrmoar. Yo yimam tamoh mrokfetm nianeft nhai yudbat wanyhermoarm. Nhai marimoar, ‘Afo rhuhato wany yakitohhiruhanm.’ ");
INSERT INTO amp_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Wom met dhirt yiha yiha niamoatn nd jasrpno mkfo hatoh memoutr, ‘Nane, yiha yiha yimam niewamn tone dbombho hatohwoma. Na kanga kotkahnomn kotkfotn frhikakrahtt rom niwa nefthu yimbu yuhat.’ ");
INSERT INTO amp_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Jasr nd mrokfom wanymohat afo be wany marsisafmort. Nhai marimor, ‘Wanyhiruhant mrokfot.’ Tfit kto dukamor, ‘Na Bro Nkifrar nhai duka yanho hanykohanr. Yo yimaroh mrokfom hnayukm nhai wany yakitohhekohanm. ");
INSERT INTO amp_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Nd mett nia mptha hatohwat afo wanyafhiruhant rothu mrokfot afo. Hhrekwa be nd rpa mrokfotn mptha hatohneft.’” ");
INSERT INTO amp_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jisasr memor, “To tfit afo wawanyko. Nd jasr namoneft rot inji namor. ");
INSERT INTO amp_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","To finji dukewa Bro Nkifrar? Bro Nkifrar nd turhu yonm yifung marm yiha yiha mnaku hatohneft ka nd jas bebr namo kanjo be wany marsisa hatohrform? Bro Nkifrar nhai inji wany mariffi hasokfot turhu yonroh naku tngm. ");
INSERT INTO amp_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","To kanga Bro Najomrhu yawihnaruha yiha krhopam rhu thombat, nd yiha Bro Nkifrar kfo bruttna hasetm, ka toh bmtaruhamn Bro Nkifrar kfo bruttna yakitoh hanyrahme, ka nd krhopampno Bro Nkifrar myafho thunirahmr?” ");
INSERT INTO amp_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Wom yimam kangm, “Nom tu dborioh yimayenom. Nom nhai ndur ndar yimam kanjo fasoh fasoh nefm nakahnom.” Ndhtet kfoyet yimam Jisasr wom kfo nhombra mrokfot kfo memor, ");
INSERT INTO amp_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Wom hus yimaf memof, ‘Akfo bruttnano.’ Womr Farisir, womr takis marut yakmoa yimar. ");
INSERT INTO amp_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Bro Nkifrarhu temperr yimofn wom Farisir turpar rim tohhato kfo bruttna memor, ‘Bro Nkifraye wahtina. Na nhai ndu ndar yimam newa nefm kanjo na fasoh nefm nakaha. Rom be tu fasoh nefm newum. Rikohwom, kfo nhehwom, ramet tuhanmpno kitwom.’ Tfit takis marut yakyuk yimarn tfit rikfo memor, ‘Na nhai nd takis marut yekwa yimar newa nefm kanjo fasoh nefm nakaha. ");
INSERT INTO amp_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Rpa rpa wikm hus marf nuwa kurhato be kfo bruttna-nefrpat korhwa. Tamoh tamohm rpa wikr yakyukm, 10-pela rmonetm htewoyanm tenyuk rmonett Bro Nkifrarhu yufatn htafahuka.’ Nd Farisir inji inji kfo bruttanamor. ");
INSERT INTO amp_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ror kfo bruttnanimotr tfit ndwom takis marut yakmoa yimarne ror be nndo tohhato nhai mfhat yura kasinyahato kfo bruttnarmor. Tur duka memor, ‘Na nhai dborioh yimayann yura yukatoh yindhorhato kfo bruttnarhoya.’ Ndnetrn be tariobttahato turhu mondt fur hanyhato kfo bruttna memor, ‘O Bro Nkifraye, na be tu fasoh yimaya. Wahti yuhuwafna.’ Takis marut yakmoa yimar ror be injirpa kfo bruttnamor.” ");
INSERT INTO amp_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jisasr nd hus yimafhu mrokfom kfo pthanihato kfo memor, “Na kfiwanko, nd takis marut yakmoa yimar turhu kunyko yimohat rorpamifr hifa yufayetr tohmor. Ndt wawanykomt. Yimar kangr, ‘Tamoh nefm nann bmbri nyingako mtohnihato nann tamoh tamoh nefm atohakahtanm yimam kfo yindhorrahma,’ nd yimar kto Bro Nkifrar yak dbhurakruharr yiro wahtarahrr. Yimar turhu yufat yiro wahtahato yimam nhai kmi kmim yindhorkahmr, nd yimar Bro Nkifrar tfit yura wuhtarahrr.” ");
INSERT INTO amp_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Wom yimam Jisasrpno yonenm hnehato memom, “Jisasr tir htahato kfo bruttnarahrm.” Disaiperm inji htihato tfit kfo huttaknimomm nd yon hnayuk yimam. ");
INSERT INTO amp_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Jisasr wanyaf hanyhato kfo memorm, “Yonenm wahti marsisafokahtkomm nanpno aniam. Mirahko akfo rafonomm. Yimam yon mumenm kanjo yorhwam Bro Nkifrarhu kingdomkfot rhurahm. ");
INSERT INTO amp_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","To afo wawanyko. Yimam nhai yon mumenm kanjo Bro Nkifrarhu kingdom-kfot rhukahm be nhai yiruhatm Bro Nkifrarhu kingdomkfot.” Yonroh mrokfot rot inji kfomort. ");
INSERT INTO amp_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Wom yiha Judaroh bro yimar Jisasrpno yimorn mttiwon memorr, “Hifa tisaye, nane finji narhoyann Bro Nkifrarpno toh nkifranirhoya?” ");
INSERT INTO amp_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Nd Judaroh bro yimar hifa tisa yufat Jisasr yutamotrr Jisasr wanyhato kfo memorr, “Tamohmpno kfo yamukona, hifa tisa? Nhai wom hifa yimar tohkahr. Bro Nkifrarpar dborioher. ");
INSERT INTO amp_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nkifra thfa mntwat ni bi wanyete. Kfo kangt, ‘Mirahn ramet tuhantpno arim fnaha, mirahn wanambur sinyahato yima awas furaya, mirahn arikoha, mirahn wom yimar wom mrokfom akfo wokanr, yifammaroh mrokfo wany yakiohato rroh yinhitn rhukfot.’” ");
INSERT INTO amp_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Inji kfo htamotrr tfit nd Judaroh bro yimar sinyahato kfo memor, “Jisase, na yuhre yonenann nd thfa mntwat kfoyuk mrokfom bi rihikakmoyanm. Nhai riyak htaformo-yanm.” ");
INSERT INTO amp_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nd yimar inji kfomotr tfit Jisasr kfo memorr, “Rot hifa nkifra thfa mntwathu mrokfom kakitohwont. Tmift wom nefrpat nhai nakahnt. Nd ni harhuwa wuss yak htatahato wommn wiknakfot. Nd wusspno yakyuk marut yakhato tfit nd wuskapa duha yimamn nd marut hekfot. Inji narahn, hefenrko mfro wuss harhu-rahn. Inji nanihato tfit na nia hikkfot.” ");
INSERT INTO amp_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nd Judaroh bro yimar boknabok wusketrn nd mrokfot wanymohat yima yuhur nhai marnyahato yirmor. ");
INSERT INTO amp_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Nd yimar inji duka kinyakimohat Jisasr bi htimorr. Htihato kfo memor, “Wahtiko, yimam boknambok wusketm be tu mduka nhiyekwom Bro Nkifrarhu kingdomkfothu fknenineft. ");
INSERT INTO amp_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Womhtet mong wakuyet fohr kutewumr kamerr. Nd kamerr fkna-nyirfort nahuyuk nirthu muht. To yimar wuss mfro haruhetr, Bro Nkifrarhu kingdomkfothu fknanyineft mduka nhiyakrfor.” ");
INSERT INTO amp_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Nd yimam, Jisasr pthayuk mrokfom wany yakitoh-moam, inji wanyhato tfit kfo memom, “Barenko, nom kangnom ka ndhtet maru kunyet yimamn hifa rhu nmbuhat miyakrahm. To nhai. Ndhtet yimam mthu nhiyakrahm Bro Nkifrarhu kingdomkfothu fknenineft. To nome ndhtet yima furapanom, to nome finji Bro Nkifrarpno yihato mtoh nkifra-niruhanom?” ");
INSERT INTO amp_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jisasr kfo memorm, “Niko yimakomn tamoh tamoh nefroh finjinaneft mduka nhiyekwoko. Tu Bro Nkifrar nhai duka nhikfot wom tamoh nefroh finji naneft.” ");
INSERT INTO amp_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Tfit Pitar mtohnihato kfo memor, “Wahtinnom. Nom ninhu hikneft nmoh tamoh tamohm mong trohhato ni mhikaknamonom.” ");
INSERT INTO amp_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jisasr memor, “Na kfo mif mifwanko, yimam Bro Nkifrarhu kingdomkfot rhuneft dukahato rroh kunym, yon tuhanm, yifa mndarm htanymm, ");
INSERT INTO amp_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","nd yimam ndar bbinysoft toh thombat Bro Nkifrar wuskam hta hmbrirahrm. Bro Najomrhu niayuk yiharn Bro Nkifrarpno toh nkifranirahm.” ");
INSERT INTO amp_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jisasr turhu 12-pela disaiperm yakhato turpathato kfo memorm, “Niko bi wawanyko. Nom Jerusalemko yitohat niko mirahko ka nhai wom nefm rhuruhatm. Nhai. Na Bro Najoma ndko nohruha. Bingot bi profetmn Bro Najomrhu noh yuhat kfo httamotmt ndnettn fipett rhuraht. ");
INSERT INTO amp_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Turhu kmi thofmn hndhnaruhatmr wom yima tangimn kuninfar wuna kfo hutatpno kfo hutatpno yenyohrahmr. Tfit wifm miyaknihato nde nde ye gurahmr. ");
INSERT INTO amp_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Nohhato hus marf rhunihato husfirpehyukrpno tfit sinyarahr.” ");
INSERT INTO amp_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Jisasr nd mrokfot inji kfomohat turhu disaiperm fak mmomomt ror inji kfomohat. Nhai yakrmomt ror kfomo mrokfothu yimbu yuhat. Rom memom ka frohmn kfiwur? ");
INSERT INTO amp_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jisasr nd Jerusalemko yiyet yihotat yi yimorn Jerikot mfnahmor. Nd kmit wom nyinga kunyjet yimar yihota yifembtn rhumoarn yihotat yihom yauni myauniyukm maruham tndaumourm. ");
INSERT INTO amp_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Jisasrpno yau hanyhato ptha kimr hofhta hnamo yimaroh ptha kimr hofhta tngm wanyak hanyhato ttiwonmor, “Ndm tamohtpno ptha kimr hnewam?” ");
INSERT INTO amp_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Kfo memomr, “Nasaret thof Jisasrpno ptha kimr hnewum.” ");
INSERT INTO amp_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nd nyinga kunyjet yimar inji wanyhato naku memor, “Defitrhu tangishof Jisase, wayuhuwafna!” ");
INSERT INTO amp_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Inji kfo nakumotr nyingako tohak hanymo yimam kfo thfamomr. Ror, nd nyinga kunyjetr, nhai rroh mrokfom wany yakiohato naku tmbhormor. Tfit wompam mfro memor, “Defitrhu tangishofe, wayuhuwafna!” ");
INSERT INTO amp_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Jisasr be wanyhato mtohmor. Mtohhato kfo memor, “Wahnakomr nd na nakuta yimar.” Hnamotmr Jisasr ttiwonmorr, ");
INSERT INTO amp_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Wurene, tamohmn nakuna?” Nd nyinga kunyjet yimar kfo memor, “Broye, kanga nyingam wayak marnyakahtna ayukatoha.” ");
INSERT INTO amp_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Inji kfomotr Jisasr memorr, “Wayukatohn. Nanhu nia mrokfot ni wanuhat ninhu bro dukeft nann htahato nakuna. Ndnettn ninhu nyingam marnyarahmn.” ");
INSERT INTO amp_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Be nd yimarhu nyingam nhai wom kuknarmomr. Yudbat fukatoh dbtaku-morm. Nd nyingam marnyamotmr yindhoreftpno Jisasr fau hikakni twanhomor. Yimam ndt htihato rom Bro Nkifrar kfo yindhormomr. ");
INSERT INTO amp_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jisasr yau hanyhato Jerikot mfnahmor. ");
INSERT INTO amp_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Nd kmitn tohmor takis yakyuk yimaroh bro yimar. Rorhu yufat Sakiusr. Nd yimar be tu masat marut harhumor. ");
INSERT INTO amp_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Jisasr nd kmi Jeriko taun yihotat yau hanyetrn nd yima Sakiusr memour, “Afo htiyafoya Jisasrhu ruheft.” Nd dukefetrn memour, “Ahtiyanr,” to nhai, kkopenparn nhai htirmoarr. Bok yimam toh dbu hmbrimoatmr nhimour htineft. ");
INSERT INTO amp_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ndnetrn nyinga yuhako bi tonemorn mis muhmor. Memor, “Mis muhhato be Jisasr yau hna thoft htiruhanr.” ");
INSERT INTO amp_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Be Sakiusr, ror mis muhhato fukatoh hasomor. Jisasr nd yima rifhurpno nia niamomn nd Sakiusr rhumo tkittn Jisasr mtohhato wuhtimorr Sakiusr. Wuhtihato kfo memor, “Sakius, yudbat wamifnahna. Na href ninhu kunys niewa.” ");
INSERT INTO amp_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Sakiusr yudbat wayoh tfha thumorn Jisasr mikfo yindhoraknehato kunyko hanymorr. ");
INSERT INTO amp_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Jisasr nd Sakiusrhu kunys yimotr womm tum rinakfo nakfo memom, “Jisasr tamohmpno nd fasoh net yimarhu kunys yitar?” ");
INSERT INTO amp_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Sakius Jisasrof kunys rhuhato wom Sakiusr wasinyahato kfo memor, “Nanhu Broye afo wawanyn. Na arihat yakyuk wuskam yak nhta hakuruhanm. Yak nhtahato wom wuskam nd sfnoh wuska duhat yimamn he hakuruha. Wom yimaroh wuskam o tamohm yuwi kfo nhehhato yak hanymom be tfit husfihus has hi hanyruhanm.” ");
INSERT INTO amp_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jisasr memorr, “Nda yimar Abrahamrhu wany yakioneft kanjo inji netrn, Bro Nkifrar fak miyekrm nda kuny shofm. ");
INSERT INTO amp_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Bro Najomr niamohat bi nd nkiranimo yimaroh yak hambrakneftn niamor.” ");
INSERT INTO amp_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jisasr pthamohat yimam wany yakitohmoum. Bi brbo brbo Jerusa-lemrpno toh hanyetmn Jisasrpno yiyuk yimam be duka memoum, “Nom href finji htitwanom Bro Nkifrarhu kingdomkfot?” Ndnetrn wom kfo nhombra mrokfot kfomort. ");
INSERT INTO amp_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kfo memor, “Wom bro yimar tohmor. Memor, ‘Wom kmit yirhoyann king yufat hiyafrhotma tfit tukanhuko nierhoyann tohukatohruhant.’ ");
INSERT INTO amp_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Yi yibonneftpno afo turhu 10-pela hingrna yimam nakuyakmormn 20 kina 20 kina htany hany hemorm. Memorm, ‘Nd 20 kinakfot rpa rpa yimako yakitohhato nd 20 kinakfot wom yihotamn htahato yak huta maruhat yakkfot. Mirahko arhu furat. Na tfit nierhoyann htiruha.’ ");
INSERT INTO amp_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Be inji yak hta tany hehato yimor. Rorhu mongkorn wom yimam tohmom. Memom, ‘Wom kmi thofm mkfo mirahnomm, “Mirahko king yufat ahenomr. Nom nhai wofnkahnomr ror nmoh king tohneft.” ’ ");
INSERT INTO amp_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","To nhai, nd yimar king yufat miyakmorn tfit niamor. Niahato nd maruham htany hemo yimam nakumorm. ");
INSERT INTO amp_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Barkof yimar niamorn mkfo memorr, ‘Bro yimaye, ni nd htanymo 20 kinakfothu yak huta maruhat asot 200 kinakfoyet.’ ");
INSERT INTO amp_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Nd bro yimar inji htihato kfo memorr, ‘Ni tu hifa hingrna yimaye, hingrna marnyamo. Ndnatn 10-pela taunkfot ninn toh-yukatohrahnm.’ ");
INSERT INTO amp_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Yo tfit wom hingrna yimar niamor. Ror niahato mkfo memor, ‘Bro yimaye, nd ni htanyhemo 20 kinakfothu 100 kinakfot asot.’ ");
INSERT INTO amp_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Kingr inji htihato kfo memorr, ‘Ni tirfa kmim watoh yukatohtwa.’ ");
INSERT INTO amp_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Tfit wom hingrna yimar niamorn mkfo memor, ‘Bro yimaye, ni htanyhemo 20 kinakfot asot, tfit hnahukann. Be hopttn rmontha nmbuhaye kitawonmoyanmn htatamoyanm. ");
INSERT INTO amp_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Namburet yimann fakrmemoya memoya, “Tubaturuhanm niahato kforahna.” Htitwann womm htatayuk wuskam ni be myaknitwonm. Womm nuhtayuk yewurim ni be tunhu fijo myakni furewunm. Nd nefm bi htiyetann fakrmemoyann.’ ");
INSERT INTO amp_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Kingr kfo memorr, ‘Ni tu be fasoh hingrna yimaye. Ni to inji hti nhombramohat ");
INSERT INTO amp_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","to mermo, “Be benktn ahtakahtant nd 20 kinakfot,” tfit tuka mfnahhato yak huta maru-hampno yakrfoyanm.’ ");
INSERT INTO amp_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nd toh rifinymo yimam kfo memorm, ‘Nd 20 kinakfot wayak hutfakkahkomr, nd 200 kinayet yimarn wariheko.’ ");
INSERT INTO amp_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Kfo memom, ‘To bro yimaye, nd ni kfiwa yimar, ror bi 200 kinayeter. Tamohmpno tfit yamuka wom fam wahekomr?’ ");
INSERT INTO amp_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nd bro yimar inji wanyhato kfo memor, ‘Wawanyko. Yimar wom wuskam o tamohm kakitohwor, nd yimar tfit wom nfri wuskam hehutaruhanr. Yimar be tu sfnoh mifr korhr, nd yimar nhai hehutarhotanr. Nd ror yakitohyuk wuskenm tfit yakhutfakruhanr. ");
INSERT INTO amp_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Nd yimam na tone hikhato kfo memo, “Nom wofnkahnom ror king tohneft,” nd yimam na kfiwa asha wahnekah-komm nanhu nyingahato watmb-hokomm.’” ");
INSERT INTO amp_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Jisasr nd kfo nhombra mrokfot kfo ptha buganihato be tfit Jerusalemko yimor. Turn nyinga yuhat. ");
INSERT INTO amp_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Yihato Olifet kmi yihofr yorhwa kmi Betfageti Betanit mfnahmom. Ndha mhtahato hus disaiperf kfo tkrur memorf, ");
INSERT INTO amp_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Ndu riyorhwa kmitio wai hanykahfn htirahfnr wom donkiyenr mispno natifatayetr. Nd donkiyenr nhai yimam tafi rhuhato hatonermomr. Nd donkiyenr wayak nyusakaknetwafn. ");
INSERT INTO amp_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Yekwatfnr yimam ttiwon kangmfn, ‘Tamohmpno yaknitafnr?’ wakfo wamitwafnm, ‘Bro Nungothetr hingrnefetrn kfefitrno kakni yahukanonr.’” ");
INSERT INTO amp_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","34","Be nd hus yimaf yimof. Yihato be nd Jisasr kfomo mrokfom hti nhombra bugamofm. Donkiyenr htimofr mispno natifatayetrn. Memof, “Anyusakak hanynonr,” donki tikatm ttiwon memomf, “Tamohmpno nd donkiyenr thu nyusakaknitafnr?” Memofm, “Bror kfefitrno kakni yahukanonr.” ");
INSERT INTO amp_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Be nd donkir nyusakaknihato hanyhemofr. Jisasrpno mhtahato tufhu rmontham yakmofmn donkirhu mongtn rhuyuk tkitt htamofm. Htani-hato fak tkaftamofr Jisasr mrhumor. ");
INSERT INTO amp_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Be mrhuhato yimor. Yimam Jisasr htiyakhato yuke hmbresham yakmoamn ror yiyuk yihotatn htak hanymoatm be nd hmbreshamn yura fau fnahmor. ");
INSERT INTO amp_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Be yimorn bi brbo toh hanymor Jerusalemtpno Olifet kmi yuhat yau htafmort Jerusalem yuhat riwitamor. Nd Jerusalem yuhatn turhu disaiperm wakfo yindhorak kimrmom. Tum be hti hnamo mirakerm dukahato kfo yindhor memom, ");
INSERT INTO amp_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“Bro Nkifrar ayak marnyatwarr ndar kingr Brorhu yufatpno yitar. Bro Nkifrarhu yufat yura yura amhtamift. Nom ndar bbinysofthu met yindarinom rorn yima yuhum yak marnyaruhatrm yima yuhum mirhurahmnom.” ");
INSERT INTO amp_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Jisasrhu disaiperm inji kfo hnamoatm wom Farisim nd rifinymo yimam tohhato kfo memomr, “Tisa, nd ninhu disaiperm wakfonm inji akfo yindhorwahm. Be tmifm akfo ptha tmbhakm.” ");
INSERT INTO amp_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Jisasr memorm nd Farisim, “Tamohmpno yamukako aptha tmbhom? Tahimn tngetm rhuruhamn Bro Nkifrar kfo yindhorrahmr.” ");
INSERT INTO amp_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Jisasr Jerusalemrpno brbo mtoh htihato hanurmorr kmir. ");
INSERT INTO amp_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Nur hanyhato kfo memor, “Jerusalem thofko, hifa rhu marnya nmbuhat bi rhu hnamoko, tukomn kfo kurmoko nd hifa rhu nmbuhathu rhuneft. Arihat nhai. Hifa rhu marnya nmbuhathu yak yuhat bi rinnfakmot. Nhai tfit hifa rhuruhatko. ");
INSERT INTO amp_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","44","Yahr kmim nieruhamn ye batirahmko. Nd Jerusalemr gna habrimo tahi gnam, yahr kmim nianeft nhai happukruhatm nd kmi gnat mtohnihato kmit mitoh-nineft. Rom yahr yinyeft bbpam yakhato tou yeny hamuhhato nd yuhatn mitohnihato kmit wifor hmbrenihato kmi Jerusalem thofm ye bati witarahmm. Jerusalem thofm Bro Nkifrar mong htamo yuhatn ye bati witarahmm.” ");
INSERT INTO amp_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jisasr yimorn Bro Nkifrarhu temperr gna habrimo gnathu yifhatikt rim fnahnimor. Rim fnahnihato rim htimorm wom yimam nungam, sisifm, bulmakaum, nd ndm maketmoumm yiro Bro Nkifrarhu temperrn. Jisasr rim htihato hik tubatuhato nd maket htayuk tikm nembos tubatumorm. ");
INSERT INTO amp_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Yak thunihato kfo memorm, “Bro Nkifrarhu rfa borngt kfo kangt, ‘Nanhu temperr nanhu kfo bruttnayuk kunyr rhurahr.’ Tfit nikomn kangko rikoh yimaroh yi kafrohyuk kunyr arhur.” ");
INSERT INTO amp_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Yiha yiha Jisasr nd temperrn met yindarim kfo nuhas bonuhasmourm mrokfom. Prisroh bro yimam yo boririfhuthu tisam yo Judaroh bro yimam Jisasr hingrnamoa hingrneft htihato rpat rhuhato memom, “Wom yiha yuwi kfo nhehakhato was-rahnomr.” ");
INSERT INTO amp_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Inji dukahato memoum, “Kfo nhehakhato awasnomr,” to nhai, met yindarim, rom nhai rroh yima yuhurn rhurmom. Rom Jisasr pthamoa mrokfom wany wofnhato yiha yiha yihato wany yakitohmoumr ror pthamoahat. ");
INSERT INTO amp_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Wom yiha rmon kmifarn met yindarim rifinymotm Jisasr Bro Nkifrarhu gutnius mrokfot kfo ptha nuhasmorm. Kfo nuhas hasetrn pris hingrneft tohyuk yimaroh bro yimam yo boririfhuthu tisam yo wom bro yimam fau yukatohaknimomr. ");
INSERT INTO amp_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Brbo yihato Jisasr mkfo ttiwon memomr, “Frohmn ndhtet bbuka rifhur hemomn? Frohmn bbuka rifhur hehato kfo memomn inji wanatwa?” ");
INSERT INTO amp_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Tfit Jisasr sinyahato kfo memorm, “To tawo wakfo nuhaskoma. ");
INSERT INTO amp_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Jonr yimam baftaisimmoahate tu Bro Nkifrarn kfomotrr ndhtet hingrneft hingrnamourt o be yima mifm kfomotmr yimam baftaisimmourm?” ");
INSERT INTO amp_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Rom inji wanyhato tfit tum nnakfo memom, “Nom sinyahato kfo mirahnomr, ‘Bro Nkifrarn kfomotrr hingrnamour,’ to tfit mirahr, ‘To tamohmpno wany yakio duha yirmokomr?’ ");
INSERT INTO amp_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Jonr pthamoa mrokfom profetm kanjo pthamoatrm yimam wanymoumm, tfit nom kfo mirahnom, ‘Yimaroh kfotpno kfo pthamour,’ to be yimam tahiye tahiye yenyoh-rahmnom.” ");
INSERT INTO amp_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Be myak nhtaktiyakhato be kfo memomr, “Nom nhai tawisaf-kahnom.” ");
INSERT INTO amp_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Rom inji kfomotm tfit Jisasr kfo memorm, “Na to inji. Na nhai kfo nuhaswotanko na hingrnewa hingrnefthu bbukeft yakmo yuhat.” ");
INSERT INTO amp_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jisasr tfit wom kfo nhombra mrokfot yakhato nd met yindarim kfo memorm, “Wom yimar wain swirt htamor. Nd wain swirt be htahato tfit womroh tirmn htanyhato ror yimor wom kmitn. Wom kmit yihato ndha tohngotmor. ");
INSERT INTO amp_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Kto nd wain swirt yukha hirmott yukha yak yiharn nd tu wain swir tikatr turhu hingrna yimar kfo tkrurafmorr nd wain swirt yakitoh hasoyuk yimampno. Kfo tkruraf memorr, ‘Waikahnn nanhu yufathu htahayuk yukham wamiyakhina.’ Nd yimar inji kfo tkrurafmotrr yimor. Yihato nd mswirt tohukatoh hasoyuk yimam tabotafmotmr be sfnopa tfit yimor. ");
INSERT INTO amp_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nd wain swir tikatr htiyaktihato tfit wom yimar kfo tkrurafmor. Yihato nd wain swir yakitohyuk yimam fasoh fasoh kfo huta bohutahato tabotafmotmr be sfnopa tfit yimor. ");
INSERT INTO amp_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Tfit womr kfo tkrurafmor. Ror nhaf inji buga. Tat beb bobeb thuhakhato memomr, ‘Wuri wain.’ ");
INSERT INTO amp_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Be nd wuroh yimar inji nafmotmr memor, ‘Be tfit finji narhoya? To frohmn tfit yiruham?’ Be dukatihato memor, ‘Nhai mrokfom, tukanhu mondtpno mfurwa yonrn yirahr. Ror yiruhatr afo htiruha wany yakiorahmre nhai?’ ");
INSERT INTO amp_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Be nd yonr tkrurafmotrr yimor. Yimorn wain swirt tohyuk yimam htiyakhato tum rinnakfo nakfo memom, ‘Ndarr turhu yonr nier. Yifemr nohnineft to nd yonrn tkitt yakhato ndar wain swirt rorn yakrahrt. Finji dukewako? Awaskahnomr be nd wain swirt be nmoht rhuraht.’ ");
INSERT INTO amp_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Be mrokfot yak dbkafnihato turhu wain swirt toh hasetrn toh rafaknihato fakmomr. Yakhato tirtir yaknimomr nndo rim htahato wasmomr.” Jisasr inji kfo pthanihato kfo memorm, “Niko to finji dukewako? To nd wain swir tikatr, turhu yonrhu was mrokfot wanynefte to finji naruharm? ");
INSERT INTO amp_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Na kfiwanko wain swir tikatr nieruharn nd yimam was hehur thuruharm tfit wom nndoh tkitthu yimam yakhato yak htarahrm nd swirtn.” Inji kfomotr nd yimam wanyhato kfo memom, “O, mirahr inji anaya.” ");
INSERT INTO amp_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jisasr yukatohmormn kfo memorm, “To tamoh dukeftpno Bro Nkifrarhu rfa borngtn kfo memom, ‘Nd rahur, kamda yimam hti kurhato yak thumor, be bi tfit nd rahurn bi dany rahur tohwor.’ ");
INSERT INTO amp_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Yimam nd dany rahurpno rim frrbigneft o rahus suhnehato frkar-nyaneft to be nhai wom rhukfot o nfrikfot.” ");
INSERT INTO amp_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Nd nd mrokfom pthamotrm nd prisroh bro yimam yo nd boririfhuthu tisam Jisasrpno toh pthamoam, wanyhato kfo memom, “Nd kfo nhombra kfot nomn niewut.” Jisasr pthamo mrokfom rom wanymohat yima yuhumio bi nambur kih bugamomm. Memom, “Ka bi kak twanhiwunomr.” To nhai, yimam htihato afo fakrmemom yakneft. ");
INSERT INTO amp_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Be nd yima yuhurpno yimom. Yihato tfit wom yimam mkfo tkruraf memomm, “Nikomn waikahkomn rorhu mrokfo ptha swirmn yuwi rhu tebfi botebfi htfaskfot. Yuwi inji rhu tebfi hanyhato yuwi ttiwon rhtikfot. Finji finji kfiwur nd tkittn yakhato kotimrahnomr bro yimampno. Bro lokfot afo htirahtr.” ");
INSERT INTO amp_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Be inji kfafmotmm yimom. Yihato fau hik htfasmoumr. Yau hik htfas hanyhato wom tkitt mrhumotr be rom ndha mrhumom. Yuwi rhu tebfi hanyhato ttiwon rhti memomr, “Tisaye, ni pthewa mrokfom nom hifa wanuk-nomm. Mrokfom hifa hifa kfo hik bohik marnyewanmn Bro Nkifrar hikwa nefm kfo hik nuhas marnyewunm tuhan yindarim. Mrokfom kfo pthi-wohat nhai hti mekahn ndr yufet yimayer o ndr yufa duha yimayer. Nhai. Mrokfom kfo pthaneft be kfo pthewunm. Nhai yimar o yufam htihato kfo pthakahnm.” ");
INSERT INTO amp_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Inji kfonihato wom ttiwon nmbuhat yuwi ttiwon rhtimomr, “Nome ka Sisarhu takis htahenefte ka htarfonome nhai?” ");
INSERT INTO amp_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jisasr rom yuwi inji ttiwon rhtimohat bi fakmorm rroh yima yuhum. ");
INSERT INTO amp_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Jisasr sinyahato kfo memorm, “Wom tahifat wayak nuhaskoma.” Yakhato fak nuhasmomr. Tfit ttiwonmorm, “To nd tahifat yorhwa nyingatikte frohroh nyingatikti yufat yorhwaf?” Kfo memomr, “Sisarhu nyingatikt korhwott.” ");
INSERT INTO amp_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Tfit kfo memorm, “Sisarhu nyingatikt korhwott to be tfit Sisarn hekfot. Bro Nkifrarhum nhaf inji. Tu Bro Nkifrarn hekfot.” ");
INSERT INTO amp_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Rom memom, “Inji attiwonkahtnomr finji kfiwure yakrahnomr.” To nhai, inji kfo wokafmotrm be tuha mrokfo duhatm tohmom. ");
INSERT INTO amp_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Farisim yimotm tfit Sadyusim yimom. Nd Sadyusiroh dukeft duka memoum, “Noh hanita yimam nhai tfit sinyaruhatm.” Rroh dukeft inji rhumout. Nd duketpno Sadyusim Jisasrpno yihato mkfo memomr, ");
INSERT INTO amp_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Tisaye, Mosesrhu boririfhut kfo kangt, wom yimar tuhan yakhato nhai wom yonm kasinya htanirfor, nd rorhu tuhan dhirt tfit wom nmemrn najom dhirt yakhato rorpno yonm nasakhato tfit najomrhu tkitm romn tohkfot. ");
INSERT INTO amp_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Wom yima najohfitpno to inji rhumot. Nd yima najohfit 7-pela kfot tohmom. Barkof bro najomr tuhan fakmor. Ror tuhan yakmohat nhai yonm nasak htanihato nohrmor. ");
INSERT INTO amp_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","Be nohmotr tuhan dhirt tohmott tfit rorhu wayakrn fakmort tuhan dhirt. Rorpno nhaf to be rpahtet neft. Nhaf nhai wom yonm nasak htanihato nohrmor. Tfit rorhu wayakr fakmort nd tuhan dhirt. Ror yakhato be rpahtet neft. Be inji nahany nahanysn 7-pela yima najohfit rhu nhombra bugamotm. ");
INSERT INTO amp_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Wuroh 7-yukrpnone nohmot. Nhai wom yufat kasinyahermotm. ");
INSERT INTO amp_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Nd 7-pela yima najohfit rpa metrpat rim rhuta mrhutamotm. Kto nd najohfit sinya thoft nd mette fitoh yimarpno tohruhat?” Inji ttiwon rhtimomr. ");
INSERT INTO amp_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Nd Sadyusim inji kfo pthamotm Jisasr memorm, “Ariharhof yimam nhai rhu furakahm. Tuhanet tuhanet bugam korhm. Metm ramet bugam korhm. ");
INSERT INTO amp_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Kto tfit Bro Nkifrar kasinya thombat noheh yimam nhai tfit sawohet sawohet toh hanyruhatm. Nd tuhan yakneft arihat ndhtet neft korhwot. Kto nhai. ");
INSERT INTO amp_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Kto ndar thatipt minoh nhehafhato Bro Nkifrar tfit afo thu kasinya thoft be rorhu yonm tohrahm. Be mounmotroh ruheft kanjo rhurahm. Nhai tfit nohruhatm. ");
INSERT INTO amp_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Nd thu kasinyaneft Mosesrhu tndht duka hanykfot. Wom yiha Mosesr Bro Nkifrar kahm kanjo mi bufupatn funamotr hti hanymorr. Mosesr kfo nuhas hany memor, ‘Yawer, Abraham, Aisak, Jekofroh Nkifrayer.’ Nhai kfo marimor, ‘Yawer Abraham, Aisak, Jekofrom kfo tatomo Nkifrayer.’ Nhai. Nd mrokfot htihato kfo kangnom, yimam nohnitam nhai noh mifkahm. Thatiprpat nohruhatn tfit sinyaraht. ");
INSERT INTO amp_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Bro Nkifrarhu nyingaye htitworm yimam nohwam nhai noh mifkahm. Thatiprpat nohwatn mrokfo rifhur korhr. Ndnettn Bro Nkifrar yima nfri yafothet yimaroh Nkifrayer. Nhai noheh yimaroh Nkifrar rhukahr.” ");
INSERT INTO amp_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Bro Nkifrarhu boririfhuthu tisam inji wanyhato kfo memom, “Ni kfiwa mrokfot tu kfo mifwo. Nhai yuwi furakahn.” Be inji yak wokmotrm, ");
INSERT INTO amp_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","be ndnat fakrmemom tfit wom ttiwonnefm ttiwonneft. ");
INSERT INTO amp_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jisasr wom ttiwonkfot ttiwon-morm, memorm, “To tamohmpno kfo yamukam, ‘Yimaroh minrfa htiyakyuk yima Kraisr, Defitrhu frikef yuhathu yimayer?’ ");
INSERT INTO amp_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","To windohmo windoh gonborngtn Defitr kfo memor, ‘Bro Yawer kfo memorr nanhu Bro Nungothetr, “Nanhu bro bbukeft yorhwa tirmifko wamrhun. ");
INSERT INTO amp_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Wamrhukahtn nd ni namburwa yahr kmim afo ninhu tirtn htahato ninhu mofsinhitn yak htaruhanm.” ’ ");
INSERT INTO amp_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","To nd yima Kraisr bi Defitr kfo yuta hna memoa, ‘Nanhu Bro Nungothetr,’ to tfit Defitrhu frikef yuhat nierahr?” ");
INSERT INTO amp_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Yimam toh wany yakitoh hany-mom turhu disaiperm kfo memorm, ");
INSERT INTO amp_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“You, niko! Boririfhuthu tisam nia kusmm frsrfarahmko. Turoh yuke yuke yok tham hmbrehato maket swirm rhuyuk yimam yihotam toh hasoyuk yimam kangm, ‘Be nom-rpanom akfo yindhorm.’ Nhai be nyingarpaye htikfot. Fitoh rhu rifiny-hato kfo bruttnayuk rmonm rom nhai mongkorn o kimbohn rhukfot. Tu be nhai mif. Rom tu be nyingako mruhakkfot. Bro yemro ye burwa tkittn nhaf inji. Rom inji yimaroh nyingako mrhu gngonkfot. ");
INSERT INTO amp_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Met dhirpampno yitamn mkfo nheh bonhehhato wuskenm kak rhoptakni yahukmm. Bro Nkifrarhu kfo bruttna-neft htirahnm. Nhai be yudbat kfo tmbhonikahm. Afo kfiwum kfiwum kfiwum wurohna wurohnamne ptha tmbhekwom. Kangm, ‘Yimam htiru-hamnom mirahm, “Hifa yimayem.” ’ Kto Bro Nkifrar finji naneft nd yimamn be tu bro krhopam yakrahm.” ");
INSERT INTO amp_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jisasr yukatoh hasohato htiyakmorm maruha maruhet yimam yi hanymomn Bro Nkifrar maruha htahemoa tkittn marufam mhtanihemoumr. ");
INSERT INTO amp_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Rroh mongkorn wom met dhirpat niamot. Rothu ramemr nohmotr rot turpatt tohmout. Rot nhai tamoh wuskam o tamohm. Rot yimotn wuroh tuthu yohript rhuyuk wuroh fsohot marufenf yakmotfn Bro Nkifrar maruha htahemoa tkittn nd marufenf htanihemotr. ");
INSERT INTO amp_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jisasr nd mett htanimo marufaf htihato kfo memor, “Na kfo mifwanko, yimam nd htani hany marufam nd metrpat hte marufenfn be tu bro marufaf htes. ");
INSERT INTO amp_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Wom womm htahani marufam, rom maruhetm yak nhtemmn wom fam Bro Nkifrarn hnahehato htahumr. Nd metpatn be tu nhai wom maruhenm. Tu wuroh yohript rhuyuk fsohot marufenf Bro Nkifrarn htahut. Rot nhai wom yeshri wiknayuk maruham wom rhukahmt.” ");
INSERT INTO amp_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Jisasrhu wom disaiperm nd Bro Nkifrarhu temperrhu wondhet tahi gnam yo wom wondh wuskam yimam hi hanyhato temperr wondh nhtamom, nd ndm Jisasrhu wom disaiperm htihato kfo ptha srhmoum. Jisasr wanyhato kfo ptha memorm, ");
INSERT INTO amp_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ndar niko htita wondhet tahi gnat to mirahko ka rhuraht. Wom yiha yimam niahato kafring witarahmm.” ");
INSERT INTO amp_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Jisasr inji kfomotr turhu disaiperm tfit ttiwon memomr, “Tisaye, nd ni kfi mrokfot fitoh yihar rhuruhatt hti-ruhanomt? Tamoh neftn yak duka-ruhattnom mirahnom nd yihar bi brbohwor?” ");
INSERT INTO amp_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jisasr memor, “You niko! Bok yimam niahato mkfo nheh bonhehrahmko. Nanhu yufat yutahato kfo mirahmko, ‘Bbinysofthu bati yihar bi asor bi. Na bi asoya niko gari hasomo yimaya.’ Niko inji wanukko, mirahko yudbat wany yakiohato amhikakninomm. ");
INSERT INTO amp_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Mrokfom wanukwoko kamukm, ‘Bi ndha nnayureft korht,’ mirahko ayakrme difronnom. Ndhtet nefm rom nierahm. To mirahko ka bi nd nefmpno bi brbohwor yihar. Nhai.” ");
INSERT INTO amp_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Wom mrokfom kfo ptha memor, “Htirahko yo wanyrahko wom kantri-kfot sinyaruhatn wom kantrikfotpno nnarahf. Wom kingr sinyaruharn wom kingrpno nnarahf. ");
INSERT INTO amp_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Yo htirahko yonmari yonmari nunem tonirahm. Wom tkitm wanyrahko kfo mirahm nd kmit o kantrikfot yeshri duhatm tohwom. Wom kmimn o kantrikfotn kfo mirahm bro dbohneft korht. Yura mountko htirahko nndo nndo rhuraht. Nhai ndar rot yorhwa kanjo hti-ruhatkomt. Yimako nhai bmtaruhatko. Yonmari yonmari yima brom, nanyjaret yimam tfit mikukentarahm. ");
INSERT INTO amp_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Nd yutahnenefm mongko rhurahm. Barkoft afo Bro Nkifrar hikwa yimako yak tkaftaruhamko faso faso yak beb bobebrahmko. Judaroh rhu rifinyuk rmontn hanyruhamko nkifra boririfhut ttiwon hebosuknarahmko. Inji nahato nhai kfo marnyarfoko, kalabus htarahmko. Yo womt, nanhu mrokfot ptharahkomt be kantrikfothu bro yimampno kotim hakuruhatmko kot toh hakurahko. ");
INSERT INTO amp_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nd tkittn nanhu mrokfot nd bro yimam kfo nuhasrahkomm. ");
INSERT INTO amp_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mirahko aduka yanhokahnomn akfo amenyom, ‘Amai, na finji kforhoya?’ Inji duka duha. ");
INSERT INTO amp_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Mrokfo rifhur nann thu hmbriruhann. Nd kotimyuk yimam nd heyuk mrokfo rifhur kfo hirahnm, be nhai wom finji ptharuhatm. ");
INSERT INTO amp_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Tukmoh garbn yifa mndarm tangiyemrom, nhai miruhatm, ‘Arm nmoh yinemroyem o tangiyemroyem.’ Nhai. Tumn hndhnaruhatmko wasrahmko. ");
INSERT INTO amp_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nann hikruhatko yimam be hti sr thurahmko. Nhai hifa nyingar hta hakuruhatmko. ");
INSERT INTO amp_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Nd nd nefm nhombrarahm. To mirahko ka nikmoh womr finji narahr. Nhai. Toh marnyarahko. Nhai wom tmarifenr yoh rashato misuhruhatr. ");
INSERT INTO amp_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nd yiha toh bmtekomn fakitoh bmtekoma, be Bro Nkifrar yakrahrko.” ");
INSERT INTO amp_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Be afo wahtiyafo hanyswako. Bi htitwoko yahr kmim niahato Jerusalemr bi wohn hmbrimr, ee wakfo wamitwako, ‘Be ndar kmit be batiraht.’ ");
INSERT INTO amp_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Nd yiha bi inji htitwokomt, brbo Judia distrikt toh hanyuk yimam yura kminysofko ayakrmanyitwam. Yo yiro kmi Jerusalemt tohyuk yimam afnahkahmn ayakrmanyitwam. Kmi Jerusalemthu briahako tohyukm mirahm tfit kmiko arim fnaninom. ");
INSERT INTO amp_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Nd yiha wukierhu tathur yihayer. Nd nakur yihna yihnamomrn inyar tathurhato wukierhu fkni yihayer. Bro Nkifrarhu mrokfot bro rfa borngtn kfomot, be fipett rhuraht. ");
INSERT INTO amp_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Metm yon fanetm yo tefi yon hamboriyetm finji yakrmiruham nd bro krhopam yakakna thombat? Romn tu bro yuhuwafeft korht. Be nd yiha Bro Nkifrarhu namburpam mirahr, finji anayanm yimam, be finji naruham? Be htirahko yahr kmim nieruhamn was frekonirahmm. ");
INSERT INTO amp_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Wom tangishofm be yakni hanyhato kalabusn htarahmm. Be wom kmimn niahato rroh wuram yahotrahmt Jerusalem bbinysoft. Be rom nd bbinysoft romn yakitoh hanimtn kto bi Bro Nkifrar kfiwur yak tuhafonefte ee btn thu troh tanyrahmt.” ");
INSERT INTO amp_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Jisasr tfit wom mrokfot kfo memorm, “Nd wonk wonk nefm rhuruha yihar be htirahkomm yamt, marr, gunym be nndo htirahkomm. Nndo rhuruhatm mano bro marombt wanyrahmt kur thbi thombat. Bbinysofthu yimam inji wanyshoft nhai bmtaruhatm. Mirahm nndo tamohmn wuttho yibuknewum? ");
INSERT INTO amp_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Ndar mounti bbinysoft rhuruha neftn met yindarim htiruhamn nyingam mmrifrahmm. Mount thu habokknamo yifonm mirahm nndo ginunes kekwotm. ");
INSERT INTO amp_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ndtpno ee btn Bro Najomr htiyakrahmr gribpamn hawihnerahmr. Ror yawihna thombat turhu bbuka rifhur yo ror hatoh hneruha nukeft mirahm nndo marrn yifa toh hnewur. Inji htiyakrahmr. ");
INSERT INTO amp_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Bi barkof nefm htitwokomm mekfot bi brbohwot Brorhu yimaroh miyak htiyak yihar. Yimbhindangm bi tohetohaf hanykfot.” ");
INSERT INTO amp_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jisasr hnu wormrhu kfo nhombra mrokfot kfomorm, memorm, “Kutr htitwonomr, ");
INSERT INTO amp_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","twam huktewum kfo kangnom kut yinr tohrahr. ");
INSERT INTO amp_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Be tfit rpahtet dukeft dukakfot. Bi nd na kfiwa nefm mountn o bbinysoftn htitwonomm, kfo mekfot, yimam Bro Nkifrarhu kingdomkfot rhuneft bi brbohwot. ");
INSERT INTO amp_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","To nd nefm rhu thoft to mirahko arihat tohwa yimam bi nohetmn nd neft rhuraht. Nhai. Arihat tohwa yimam yuhre tohetmn nd neft htirahmt. ");
INSERT INTO amp_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Nd neft rhuneft htirahko mounti bbinysoft mibatinirahf. Nanhu mrokforpat nhai mibatiniruhatt.” ");
INSERT INTO amp_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Tfit Jisasr memorm, “Niko yimbhindangm tohetohaf hanykfot. Mirahko bia bupam yewa yimam kanjo ye mmokahnomn fohm kanjo yatiyefm dukahato mfhat bbinysoftn tariobttakfot. Ndrpat duka hasoruha-komn Brorhu nia yihar be sinya fohtasrahko. ");
INSERT INTO amp_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Wukier kanjo fohm nakur ye mmo hany ye mmo hanyhato wuroh inyar yihom tathurafhato wukier yohnita kanjo be inji sinya fohtashato yiro wukiern fkne bugarahko ndar bbinysofthu yima bugako. ");
INSERT INTO amp_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Yiha yiha yimbhindangm tohetohaf hanyhato be kfo bruttnanefrpat yakitohkfot. Yiha yiha kfo bruttnakfot. Kfo bruttnahato toh bmtaruhakomn Bro Najomr kotkfot yakitoh thoft be mrokfo duhatko rhurahko.” ");
INSERT INTO amp_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Mar yiham Jisasr Bro Nkifrarhu temperr yimoarn met yindarim kfo nuhas bonuhasmourm Bro Nkifrarhu mrokfot. Yifung yiham yura Olifet kminysofthu kunys muhmoarn hwemour. ");
INSERT INTO amp_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Met yindari bugam turoh kmim hwe tanymoamn dbha Bro Nkifrarhu temperr yimoamn Jisasr pthayuk mrokfom wany yakitohmoumm. ");
INSERT INTO amp_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yispa hta duha bretparoh ye yihar, kutewumr Pasofa burwat, nd yihar bi yibon hanymor. ");
INSERT INTO amp_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Prisroh bro yimam yo nkifra boririfhuthu tisam kmi thofm yakrmihato memom, “Jisasr be was kafrohrahnomr.” ");
INSERT INTO amp_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Tu Jisasrhu disaiper Judas Iskariotrn Satanr fknemorr. ");
INSERT INTO amp_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Satanr fknemotrr yimor prisroh bro yimami temperr tohukatohyuk hingrna yimampno. Yihato memorm, “Inji inji hndhnaruhanr.” ");
INSERT INTO amp_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","6","Inji kfomotr maru gondt hemomr. Hemotmr Judasr yihato dukamor hndhnayuk yuham. ");
INSERT INTO amp_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Be rhumomn nd yispa hta duha bretpam yeyuk yiharoh barkof yihar niamor. Nd yispa hta duha bretpam yamoa barkof yiharn Pasofa sifsifr washato ndr tarioh mthamoum. ");
INSERT INTO amp_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Pita Jonrof Jisasr kfo tkruraf memorf, “Nifn bi wai hanykahfn ndar bro yihar rhuyuk yiha yeyuk yeshrim wamhta mska hanyswafnm.” ");
INSERT INTO amp_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Tfit rof ttiwon memofr, “Nd Pasofa burwat rhu thombat, nome yeshrim fitha hta mskaruhatnom ni rhuhato ye juka-ruhant?” ");
INSERT INTO amp_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Inji ttiwonmotfr kfo memorf, “Waikahfnn kmi yifhatiktn wom yimar burioh roht titetrpno mnafurrahko. To be mirahfn finji ainyo. Rorn wayau hikaknitwafn. Ror fitoh kunys kitwor, nifn nd kunys yikfot. ");
INSERT INTO amp_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Fknenihato nd kuny sikatr wakfo wamitwafnr, ‘Tisar kfo famur, “Waikahfnn nd kuny shofr ayak nuhastwarfn nani nanhu disaipermpno Pasofa burwa yeyuk tkitt.” ’ ");
INSERT INTO amp_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Inji wakfo ttiwonkahtfn yurakorhof rumt yak nuhasrahrfn. Nd rumtn mhtirahfnm tebor gaj nd ndm. Ndharn wahta mskatwafn. Nom nierahnom.” ");
INSERT INTO amp_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Be rof yimofn nd Jisasr kfomo yimar kmi yifhatiktn mhtimofr. Ror yimo kunys yimof. Nd nd nefm be Jisasr kfomo tng yuhatn hti bugamofm. Be ndharn rhuhato hta mskamofm nd bro yiha yeyuk yeshrim. ");
INSERT INTO amp_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Pasofa burwa ye yiharn Jisasri aposerm yihato rpa tebort rpat mrhumom. ");
INSERT INTO amp_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Mrhu bugamotm Jisasr memorm, “Na wofn mifwa nda wuroh bro yihar nikompno rhuhato wuroh yeshrim yehato krhopam yakneft. ");
INSERT INTO amp_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Wuroht yenyhokahanko kto be nhai. Afo toh hanyrhoyann htiruha bi Bro Nkifrar king tohneft bi rorn king tohhato rorhu kingdomkfot toh-yukatohwort ee btn Pasofa burwa mift rpatn yerahnom.” ");
INSERT INTO amp_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Jisasr inji kfonihato bu kaft yakmortn Bro Nkifrarko wukfo yindhornihato kfo memor, “Nda wain bu kaft wayakkahkomtn wanahe habriko. ");
INSERT INTO amp_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Na kfo mifwanko, na nhai tfit wom wain bupam yerhota. Bro Nkifrarhu kingdomkforpatn tohhato ee btn nfri wain bupam tfit yeruha.” ");
INSERT INTO amp_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tfit bretpat yakmortn nhaf Bro Nkifrar wukfo yindhornimorr yak tif botifhato he nhombramorm tifen tifen. He nhombranihato kfo memorm, “Nd bret tifm wayakkomm. Ndm nanhu nmpayem. Nanhu thatipt niko duka-hato Bro Nkifrarn heshombat inji yoh nembosingoraht. Yekahkomm duka hanyrahkma.” ");
INSERT INTO amp_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Nd nuwa yesrufnihato tfit nfri wain bupa tas hmbrihato barkof namo kanjo inji namor. Nanihato kfo memor, “Ndar wain bu kaft tfit niko yekwat nd nfri dfa tik yuhar hingrnaruha hingrnefet. Kto na nohhato nanhu kkut yohni thombat nd kkupamn nd nfri hingrneft be yak dbkafrahtt. Be tawo nd nfri hingrneft wahiktwako. ");
INSERT INTO amp_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Wawanyko. Wom yimar tor nhowi nompno kawor. Rorn hndhnarahra. ");
INSERT INTO amp_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Bro Nkifrar kfomo yuhatn Bro Najomr kangr, inji nadborneft nhai mrokfom. To be Bro Nkifrar tutfarahrr nd hndhnayuk yimar.” ");
INSERT INTO amp_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Tu Jisasrhu disaiperm inji wanyhato tum rinahti nahtihato nattiwon nattiwonmom, “Barenko niko wakfoko, frohrn kfiwar? Frohm inji naruhamr?” ");
INSERT INTO amp_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Jisasrhu disaiperm tum rinakfo nakfomoum bro yufathu yakneft. Womr sinyahato memour, “Nann bro yufat hatohruha.” Tfit womrn, “Weye, nann hatohruhant.” Tfit womr memour, “We, rorn.” Inji rinatu natumoum. ");
INSERT INTO amp_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jisasr wanyafhato kfo memor, “Niko ndar rinatu natutako afo wawanyko. Wom wom yima tangi furaroh kingm nhai tohukatoh marnyakahm. Rroh womr king tohneft, nhai ror wom yima furarhu mrokfeft o dukeft wanyhato hikkfot. Rorpar finji finji kfiwur o dukewur, kmi thofm be rorhu dukef yuhat hikkfot. Nhai finji kfokfot. Ror tur inji nahato kfo kangr, ‘O na tu hifa kinga.’ Tot inji korhwot wom yima tangiroh hingrneft. ");
INSERT INTO amp_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Niko nd yuhat hik duha. Bro yonr tfit nmemenr kanjo rhukfot. Bro yimar tfit afo hingrna yima furam kanjo rhukfot. ");
INSERT INTO amp_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","To afo wawanyko wom mrokfot. Frohrn broyer? Nd be gajis kmit rhu hasohato be wommn mthuhona hasiwa yimar o nd yemro yak habriwa yimar? Finji dukewako? Frohrn broyer? To na nhai inji nakaha. Na nikmoh buha tohnuhiwa yimaya, na be nikmoh hingrnanhoyuk hingrna yimaya. ");
INSERT INTO amp_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Tamoh nefm memoum, ‘Ayak kasuh inji nanomr,’ niko nia tohnho-moukma. ");
INSERT INTO amp_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Na nd Bro Nkifrar nd hemo tohukatohyuk gajim, niko wom gajim yak rhurahkomm. ");
INSERT INTO amp_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Na kinga toh thoft nanhu nuwa yayuk tebortn niko nanpno rpat rhuhato rpat nuwa yerahnom. Na yakruha gajis niko to inji buga wom gajim rhuhato nikomn wom 12-pela tangim tohukatohrah-komm.” ");
INSERT INTO amp_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jisasr sinyahato Saimonr kfo memorr, “Saimon, Saimon! Wawanyn. Satanr niahato ninhu yima yuhur wastiwonrahrn. Tu Bro Nkifrarhu dukefrparpno rhurahrne nhai? Bro Nkifrar bi kfo fakiowafmorr ninhu nia wastiwonneft. ");
INSERT INTO amp_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","To ni Saimone mirahn duka yanhoya. Na kfo tatiwanr Bro Nkifrarko. Ni buha wom nefmn misuh thombat nhai be wundiat suhniruhatn tfit mkekutrahn. Tfit bi mkekutekn tfit yihato wom yimatm kfo bmta mrokfom wahitwanm.” ");
INSERT INTO amp_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pitar tfit sinyahato Jisasr memorr, “Broye, na yibonwa ninpno kalabus yinyeft yo ni nohneft na yibonwa ninpno rpat nohneft.” ");
INSERT INTO amp_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Tfit Jisasr sinyahato kfo memorr, “Pita afo wawanyn. Hrek yifungt yimam ttiwonrahmn ninhu nanpno rpat tohneft afo kfo namhirahn. Kfo namhitwonm kangnm, ‘Na nhai nd yimar tawisafkahanr.’ Inji kfo namhihany, kfo namhi hanyruhann husfirpehyuk kfo namhi tngtpno wanyrahnr krir nakurahr.” ");
INSERT INTO amp_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jisasr kfo memorm, “Wom yiha niko nanhu hingrnefthu hingrnat yimohat kfo rafomoyanko su wuram hmbreni duha yo nhai kpm o maruhenm yakitohakkfot. To nd yihart be inji sfno tirrpat yimohat wom shrm faknafmokone nhai?” Kfo memomr, “Nhai. Nhai wom shrm yaknafrmonom.” ");
INSERT INTO amp_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Inji kfomotm tfit Jisasr kfo memorm, “Tfit arihat yinyeft nhai sfno yaukfot. Arihat maruhete maruham yaknikfot, kpete kpt yaknikfot. Bainat duhayeko yimakmoh saket tham maruhampno yak tuknahato nd maruhaye bainat wiknaknikfot. ");
INSERT INTO amp_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ndt nhai be kfo furakaha. Bi Bro Nkifrarhu rfa borngthu mrokfotn na kfo memota, ‘Nd yimar htimomr fasoh nefm nayet yimam kanjo. Nhai hifa nyingar htarmoamr.’ Nd mrokfot bi kfo htamot bi tot bi mfrfnah hanitt.” ");
INSERT INTO amp_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Tfit turhu disaiperm kfo memomr, “Wahti. Asof bainat husf.” Jisasr memor, “Nhai mrokfom, tmift.” ");
INSERT INTO amp_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Be inji naptha hasomomn nhaf turhu neft. Turhu disaiperm yaknihato muhmom Olifet kmitnko. ");
INSERT INTO amp_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Muhhato mfnahmom. Mfnahhato turhu disaiperm kfo memorm, “Niko kfo bruttnaneft yakitoh kihtakfot. Inji narahko be nhai suhruhatko Satanr nia nhehneft.” ");
INSERT INTO amp_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Be inji kfo tanymormn yimor. Be wunye kkofmorn mtabokmehato kfo bruttnamor. Kfo bruttna memor, ");
INSERT INTO amp_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“O Dajaye, ndar bbinysofthu yimaroh fasoh nefm na be hta krhorhotma nann nohruhanm. Bi brbohwatt kanga akfoyann. Nd krho mis na yakruhat kangn ayak tuhant, be hifa, na yindhorwa. E nhai, kangn ayakrt, be nhai mrokfom, yakruhant. Na be ninn yukatohruha. Kangn, finji anaya, nhai mrokfom.” ");
INSERT INTO amp_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Be wom mounmotr yawihnehato mithu bmtamorr. ");
INSERT INTO amp_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jisasrhu yima yuhur nhai marnyarmorr. Ndhtet ndhtet dukefmpno yima yuhurio rikrho hmbritamorrne be. Nd yima yuhurpno kfo bruttnamor. Kfo bruttnahato yikiatpno yikiatpno tohmor. Nd yikiat tfit kkut kanjo rhuhato bbinysoftn mitohmom. ");
INSERT INTO amp_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Be injirpa kfo bruttna tanyhato tfit yihato yihom htimorm turhu disaiperm hwe hasetmn. Rom to inji nhaf krho yima yuhumpno hwemom. ");
INSERT INTO amp_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Yihom tohhato naku thomorm, “Barenko, nikone be hwitwoko? Sinya rhuhato kfo bruttnanefte nhai? Inji be hweta hasoneft to be tamoh wifor yiham be suhaknirahko.” ");
INSERT INTO amp_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yuhre inji ptha hasomor, asha Judasr mhatone fnahmorm Jisasrhu yakyuk yimam. Nd Judasr mirahko ka wom nndoh yimar. Nhai. Ror tu Jisasrhu disaiperr, rorn nd Jisasr yakyuk yimam hatohakmorm. Judasr yau yaknihato mkihendhoraknimorr Jisasr. Judasr mkihendhoraknimohat nhai be sfno. Bi tum rpat rhuhato memom, “Bi Judasr mkihendhor tebfiyaknitrr ee ndnatn yudbat wayur sinyahato yakaknikfot yimar.” Bi inji kfo htamomt mrokfot. ");
INSERT INTO amp_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Be Judasr mkihendhoraknimotrr Jisasr memorr, “Judas kangn, ‘Yuwi inji amki yindhor tebfiyaknikahtanr yudbat yimam mrhunehato yakrahmr.’ Ndhtet dukefetnn inji naknewuna?” ");
INSERT INTO amp_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Turhu disaiperm inji htiyaf hanyhato ttiwonmomr, “Broye, nome finji naruhanom? Ndar nom hnayuk bainate nd ni yakaknayuk yimam tawo hik tubatuyafrahnomm?” ");
INSERT INTO amp_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Be inji yuhre nnakfo ptha hanymom Jisasr fakakni twanhomomr. Be wom disaiperr inji htihato sinyamorn prisroh bro tohak yimarhu hingrna yimar bainate tirmifkorhof yimbhindangt frbubafmotrr misuhmot. ");
INSERT INTO amp_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Be Jisasr nd yimarhu yimbhindangt inji htihato turhu disaiperm fak dbohfamorm. Be nd yimbhindang duha yimar Jisasr rim tohnihato tir htamort nd yimbhindangt tfit nathu nanyjhomot. ");
INSERT INTO amp_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jisasr tohhato prisroh bro yimam, Bro Nkifrarhu temperr tohukatohyuk yimam yo wom bro yimam tohhato kfo memorm, “Barenko, nane raskor yimam kanjo bainat, mhrs hasinyahato nia kekwokma? ");
INSERT INTO amp_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Na yiha yiha Bro Nkifrarhu temperr yorhwa kmifat tohhato met yindarim mrokfom hemoahat nhai niko inji yihato hfnahaknirmokma. Hrefn nd Satanr thu rifhutrko nieko.” ");
INSERT INTO amp_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jisasr pthanimotr fakmomr. Yakhato be hanymomr. Hany hanymoumr Pitar, ror be nhowi mongkongotn fau ss hik hanymourm. Jisasr hanyhato hanymomr prisroh bro tohak yimarhu kunysn. ");
INSERT INTO amp_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nd prisroh bro tohak yimarhu kmifarn kaht yimam tenghato haunyo hasomom. Pitar nhowi yimorn rompno mruhaknimor. ");
INSERT INTO amp_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Kaht haunyo hanyetrn kahthu nukeftpno nd bro yimarhu wom hingrnayuk mett htimotr. Hti hasohato kfo memot, “Barenko, asor wom yimar Jisasrpno nd wiyauyau htfasmoar.” ");
INSERT INTO amp_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pitar kfo namhi memor, “Bare, nann yari yutewun. Na nhai tawisafkahanr.” ");
INSERT INTO amp_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Kto tfit womr yihato mhtimorr. Mhtihato kfo memorr, “Bare, ni aso womenn Jisasrpno wiyauyau htfasmoa.” Tfit wompam kfo namhi memor, “Bare, na nhai tawisafkahanr.” ");
INSERT INTO amp_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Kto rhungotafhato wom yimar tu mfro kfo memor, “Na kfo mif mifwa ndar yimar rpat tohhato rpat ufaufaumoum. Ndar yimar Galili thofer.” ");
INSERT INTO amp_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pitar wompam kfo namhi memor, “Bare, nd ni pthiwa mrokfot na nhai tawisafkahant.” Inji ptha hanymor asha krir nakumohat. ");
INSERT INTO amp_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jisasr kekutnihato fukatohmorr Pitar. Pitar ndnatn dukamor Bror kfo memohat, “Hrek yifungnano krirhu naku tngt tafi wany juha, husfirpa kfo namhit kfo namhi kangnm, ‘Na nhai tawisafkahanr Jisasr.’” ");
INSERT INTO amp_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Nd mrokfot dukakhato briahako fnahnihato nhai nur ttifarmor. ");
INSERT INTO amp_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Jisasr toh hti yukatohaf hanymoa yimam kfo tfar botfar kfo yukioh boyukioh thuhato ritatakmomr. ");
INSERT INTO amp_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nyingatikt kitasiftahato tatmoumr. Tat hanyhato kfo memoumr, “Wakfo ni frohm tatwamn. Wayutanm ni tatwa yimaroh yufam.” ");
INSERT INTO amp_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Be womhtet womhtet fasoh fasohtet mrokfom rorpar yi bugamom. Be inji na nfhamomr yonmari yifungr. ");
INSERT INTO amp_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Dbharn bro yimam, prisroh bro yimam, boririfhuthu tisam rifiny bugamom. Rifiny bugamotm Judaroh mrokfo wanyuk kaunsermpno yimom. Jisasr hanymomr rroh mrokfo wanyuk bro yimampno. ");
INSERT INTO amp_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Mhtatahato ttiwonmomr, “Ni ndar yimann Bro Nkifrar kfomor yimaroh minrfa htiyakneft?” Jisasr sinyahato kfo memorm, “To na kfo miruhanko, na nd yimaya be nhai wany yakioruhatko. ");
INSERT INTO amp_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Yo wom ttiwonkfom kfo ttiwon-ruhanko be nhai ptharuhatko. ");
INSERT INTO amp_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Wom mrokforpat akfoyanko. Ndar yiham be Bro Najomrn Tu Nngrajohet Nkifrarhu tirmifko be tohnirahr.” ");
INSERT INTO amp_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Inji kfomotr tfit kaunser bugam sinyahato ttiwonmomr, “Ni inji kfiwohat ka Bro Nkifrarhu Yonn inji kfiwun?” Kfo memorm, “To finji tfit kfo nuhasrhoyanko? To bi kfo twanhiwuko. Bro Nkifrarhu Yonr to naya.” ");
INSERT INTO amp_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Be wany hikmomn kfo memom, “Bi wany hik twanhinomr. Be nd mrokforpat memonom awany hikkahnomn nd tkittn yakrahnomr. To nhai tfit womm yakruhatnom rorhu toh nmbuhathu kfo hikyukm.” ");
INSERT INTO amp_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Juda kaunserkfothu kaunser yimam sinyahato Jisasr yaknimomr hanymomr Pailatrpno. ");
INSERT INTO amp_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Pailatrpno mhatohmomrn Pailatr kfo memomr, “Nda yima Jisasr buha nia mtohwarn kmi thofm faso kfo hta kangrm, ‘Mirahko nda kmithu bro yima Sisar takis ahenomr. Nanrpaya Bro Nkifrar kfomo yimaroh minrfa htiyakyuk kinga.’” ");
INSERT INTO amp_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pailatr sinyahato Jisasr kfo ttiwonmorr, “Nine Judaroh kinge?” Jisasr memor, “Uwa. Mrokfot to bi kfo twanhiwunt.” ");
INSERT INTO amp_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Pailatr kekutnihato nd Jisasr kotimmo yimam kfo memorm, “Nd yimar nhai wom fasoh neft narmor. Nhai kfo mirhotanko, ‘Wayaknikomr.’” ");
INSERT INTO amp_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pailatrpno mpthayuk yimam kfo memom, “Ndr kfo furewur. Mirahn awany yakiowanr. Rorn tfit buha mitohwarn nda Judathu kmi kmiroh yimam faso faso kfo hta bohta hnewurm. Bi Galiliko bi inji rihingrnakmorn to bi tfit bi asor Judako niewur.” ");
INSERT INTO amp_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailatr inji wanyhato ttiwonmorm, “Ndar yimare fitha thofer? Galili thofere fitha thofer?” ");
INSERT INTO amp_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Jisasrhu toh yuhat Pailatr frhikakhato kfo memor, “Nd yimar Herotr tohukatohwa Galili profins tohwa yimayer.” To be inji mhti hikakhato Pailatr kfomotr Jisasr hanymomr Herotrpno. To nd yihart bi Pasofa burwathu rhu yiharn Herotr Jerusalemko bi tohetrn to be ndko hanymomr. ");
INSERT INTO amp_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herotr htiyakhato memor, “O hifa hnekomr. Nd ror hingrnewa hingrneft afo hingrnaruhatrt htirahnomt. Be wanys wanuknom ror hingrnewa bbukeft.” ");
INSERT INTO amp_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Herotr sinyahato Jisasr ttiwon nhta bonhtamourr. Jisasr nhai ptharmor. ");
INSERT INTO amp_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Prisroh bro yimami boririfhuthu tisamm mtohnihato mfro mfro nd kotkfot kfo nnuhaknimomt. ");
INSERT INTO amp_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","To be Herotri turhu soldiakfom faso faso kfo kuken bokuken kfo tfar botfar thumomr. Inji nanihato tu hifa dborioh rmonthar yakhato nd rmon-thaye tu Judaroh rmontha nyuh yuhatn nyuhafmomr. Nyuhafhato kfo memomr, “Tfit Pailatrpno wain.” Be inji kfafmotmr tfit yimor. ");
INSERT INTO amp_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Be Jisasrhu kotkfot rpat rpat wany hnamoftn be nd hus yimaf rinfak marnyakmof. Barkofpam afo nna hutt nna inji namouf. ");
INSERT INTO amp_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pailatr Jisasr htiyakhato nakumorm prisroh bro yimam yo kmithu bro yimam yo nd yima fura bofurat nakuyak bugamorm. ");
INSERT INTO amp_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Nia mrifiny bugamotm kfo memorm, “Niko nda yimar tfit hnekomrn kfo kamukko, ‘Ndar yimarn kmi thofm faso faso kfo hta kangrm, “Mirahko Sisar maruham ahenom. Asoya na kinga.” ’ Inji kfiwatko na duka mumiwa. Nda yimar nhai niko kfiwa fasoh nefm narmor.” ");
INSERT INTO amp_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Pailatr kfo memorm, “Barkofpam Herotrpno kotkfot hanikomr. Herotr wanurm ndar yimarhu mrokfom nhai kfo marifor, ‘Nd yimar fasoh nefm ner.’ Wanyhato tfit nanpno nianeft kfefitrr nanpno nier. Ndar yimare be wakfo furakhato was furarahnomr? ");
INSERT INTO amp_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Ndhtet neft be soldiam kforhota romn tat noh bonohafhato fnahnirahr.” ");
INSERT INTO amp_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Nd tohyuk met yindariroh tng rihar wanfak nfakmom. “Wawaskomr! Wawaskomr! Rorn wawaskahtko tawo Barabasr afnahnahernom.” ");
INSERT INTO amp_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Nd yima Barabasr kalabusmo nmbuhat to nnakfo hamuh nnakfo hamuhhato wom yimar wasmorr. Nd nmbuhampno kalabus htamomr. ");
INSERT INTO amp_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Tfit wompam Pailatr kfo memorm, “Jisasr fnahni kitwor. Nhai yorhwatr.” Be inji kfo hanymor. ");
INSERT INTO amp_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Be watabrurhakmorm. Waniak waniakhato kfo memom, “Bgre misn wakihegirkomr! Bgre misn wakihegirkomr!” Nd yimaroh tngm be nndo grmim yakitohmoamn memoum, “Be yudbat atayifuhakninomr.” ");
INSERT INTO amp_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Tfit husfirpehyuk ttiwonkfot kfomorm. Kfo memorm, “Nda yimar nhai wom fasoh nefm narmor. Be kotim furahato was furarahnomr? Nhai ror wom tng bebt htakahr. Ndnetrn be tabotneft tabotrahmr. Tabothato fnahnerahr.” ");
INSERT INTO amp_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","To nhai, rorhu mrokfot yiro yimot. Fitha ttifarmotm btn finji yima mrokfom wanykfot. Rom be Jisasrhu noh mrokfot ritohakmohat to be nd tkitrpat tohmom. ");
INSERT INTO amp_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Be Pailatr wany batihato be memor, “Jisasr nohrahr.” ");
INSERT INTO amp_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Be nd Romroh gafman yimam yakhato kalabus htamo yima Barabasr rorn fnahnimotr tfit Jisasrn tkitt yakhato be soldiaroh tirmn yimor. ");
INSERT INTO amp_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Be soldiam yakmomr hanymomr. Kmi rim fnahnitn htiyakmomr wom yimar. Nd yimarhu yufat Saimonr, Sairini thofr. Ror yakmomn nd Jisasr tita hanymo mnohyuk bgre mis rorn tfit wathu titafmom. Rorn titanhota hanymorr. ");
INSERT INTO amp_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Bok met yindarim fau hik hanymomr. Met kmimn nurefr hatoh hanymomr. ");
INSERT INTO amp_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Nurefr hatoh hany-motmr Jisasr kekutnihato kfo memorm, “Jerusalem efkotko, anur hik hnewohkma. Be inji wahti marsisako. Niko nurneft tuko dukahato nurkfot. Yoneneteko yonm yakhato bi hanur hanykfot. ");
INSERT INTO amp_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Nhai be sfno inji kfokaha. Kto wom yiha bro kurheft nia thoft metm yon hiyau duham, rom hifa, nhai be mfro duka kinyakiruhatm. Yon kkukenetm be tu mfro duka kinyakirahm. ");
INSERT INTO amp_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Womm nd kurheft htihato kmbru fkohm kanjo tatti bottirahm. Kminysofm kfo mirahmm, ‘Nda kminysofe wawuyoh nafurnekahnn wamithu kasikahtnnom anohnom.’ Wom womt kfo mirahm, ‘Nda kminysofe watoh rafonnom. Nom wofnkahnom krhopam yakneft.’ Inji narahm. ");
INSERT INTO amp_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Yimar dborioh neft nayet yimar faso faso kak bebwomr yimam nfri nyume kah tengwa kanjo. Tfit kto nd fasoh nayetm tawo yak bebrahmm yimam inji ffnyume kah tengwa kanjo.” ");
INSERT INTO amp_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Jisasr yak htamomrn you tfit soldiam yihato fakmomf wom hus yimaf kalabus kunys tohetfn. Nd yimaf rikoh yo fasoh fasoh nefm namoatf fak htamomf kalabus kunysn. Yakhato memom, “Jisasr nohruha yiha rof rpat nohrahf.” ");
INSERT INTO amp_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Be nd husfirpa yima bugam hanymomm yima mfha tpitn. (Kfe sfiohniyet yima mfham kanjo nd tkitt rhumoatt futamoumt yima mfha tpit.) Ndha nd husfirpa yimam bgre mimn nire tir wuram frdbkafhato yuht bgre miyetm kasinyamomm. Nd fasoh nefm nayetf mano mano tohmof. Womr tirmifko, womr kindonko. ");
INSERT INTO amp_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jisasr yura bgre misn hegir hanyhato Bro Nkifrar wukfo memorr, “Bro Yifeme, ndar na nda yimamwe newa nefm mirahn ni htihato anambur inji naya. Nhai yima dukefrpno inji nakahm. Rom newa nefm waduka mumafotwanm. Mirahn adukayanm.” Yo nd Jisasrhu hmbre-sham yak taborhotamom soldiam tahiham tubatu hanymomn htimom, frohrn tahis hifa fturt, nd yimar fakmorm. ");
INSERT INTO amp_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Yima rifinyroh nyingahato Judaroh tangi tangiroh bro yimam mtohnimoamn wukfo ddo memoumr, “Ndar yimar ror toh hingrna hnamohat bok met yindarim rorn fak marnya hnamorm. Nd yimarn Bro Nkifrar kfo tkruraf thombat nda bbinysofthu yimaroh nrfa htiyakneft, afo tur amifnahnekahtr ahtinomr.” ");
INSERT INTO amp_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Soldiam rom nhaf niahato nd fipa ye juha faso wain bupam hnehato mthu nhehmomr. ");
INSERT INTO amp_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Mthu nhehtahato wukfo memomr, “Ni Judaroh kingn rhu thombat asomif tu wamifnahnekahtn ahtinomn.” ");
INSERT INTO amp_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Wom mrokfo nmbuhat plan mkutn wandfakmomtn yura mfhatpno frdbkafmomt. Nd mrokfot rom wandfamot kfo memot, “Judaroh kingr.” ");
INSERT INTO amp_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Tfit nd rorpno kasinyamo yima husfn womr rirhuhato kfo ddo hany memorr, “Ni yimaroh nrfa htiyakyuke? Ndhtet yima rhu thoft btn ninn wamifnahnikahnn no ninn nyusakak-rahnno.” ");
INSERT INTO amp_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Inji kfo ddo hanymotr tfit manoko hiryukrn kfo memorr, “Bare inji akfowahn. Nom rpahtet krhopam kekwonom. Bro Nkifrar ka nhai yakrmikahnr? ");
INSERT INTO amp_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","No yekwa krho nmbuhat nhai be sfno no tunnoh nefmpno krhopam kekwono. Ror nhai. Ror be sfno nd krhopam kak furewur.” ");
INSERT INTO amp_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Inji kfonihato Jisasr kfo memorr, “Jisase, ni kto kingn toh thombat na wadukatwona. Mirahn ammoniyanr. Nanhu rhu nmbuhat wayak htatwona.” ");
INSERT INTO amp_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jisasr memorr, “Na kfo mifwann, hrek na yita kmi paradais ni rpat yi myorhwono.” ");
INSERT INTO amp_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Jisasr afo yura hirmour yura bgre misn. Dany marrn marrhu nukeft be rim nohnimot. Kantri bugat be yambontift rhumom. Wuroh 3 kilok krif marr tfit niamor. ");
INSERT INTO amp_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","46","Be inji yarmbon tiftn rhu hanymotn marr tri kilok yihom toh hanymor Jisasr mfaknimor. Wuroh myakni yibonruha turhu yifem Bro Nkifrarko naku tau ttinimorr, “Bro Yifeme, na bi toya bi niewa wamiyakna.” Nd Bro Nkifrarhu temperrhu tu Nngrajoh Hnaru Gnanhehr gna rafomoa rmonthat yimar mfakni hanymor, nd rmonthat rpat buha foh tnehmot. Buha yoh tnehhato nmbuhaf mano mano rim rhu mrhumof. ");
INSERT INTO amp_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Amiroh keptenr inji htimohat mfhat danyr foh tnehmotr. Bro Nkifrar kfo yindhorhato kfo memor, “Dajohmn! Nda yimar be tu nhai wom tamoh nefmpno nohrfor. Dborioh yimar be noh furer.” ");
INSERT INTO amp_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Nd met yindarim toh hti hasomom rom nhaf inji hti tanyhato natubatunimohat bro dungunangu yima yuhumpno yi hanymom. Masat yuhuwafmomr Jisasr. ");
INSERT INTO amp_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Jisasrhu yimatm yo ndwom met kmit Jisasr Galilit hik htfasmoam rom be inji nndoh tohmoamn htimoumm Jisasr tamoh tamoh nefm namoahat. ");
INSERT INTO amp_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Judaroh taun Arimateathu wom yimar tohmour. Rorhu yufat Josefr. Ror be dborioh yimar, ror nhai wom tamoh tamoh nefm. Juda kaunserkfot rorn nd kaunserkfot hingrna tohnho-mourm. ");
INSERT INTO amp_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Rom wom kaunser ptha-moahat Jisasrhu finji naneft ror nhai rhunhohato ptha nuhaknirmoarm. Rorhu dukeft duka memour, “Bro Nkifrarhu kingdomkfot afo nanhu nyingaye afo htiruha!” ");
INSERT INTO amp_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Jisasrhu thatipt yakhato yopafneft rorn Pailatrpno yimorn Pailatr mkfo memorr, “Nann Jisasrhu thatipt yaknirhoyantn yopruhant.” Mkfomotr Pailatr memorr, “Nhai mrokfom, ninn wayoptwanr.” ");
INSERT INTO amp_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Be inji kfafmotrr yimorn Jisasr yura bgre misn hiretrn yuht bgre miyetr fak kasuhakmorr. Yak kasuhhato yimar yak tundakmorr nndo rim htamorr. Rim htahato ganyom rmonthaye rir hmbremorr. Rir hmbrenihato hanymorr. Hanyhato wom tahi muhtn rihtamorr. Nd Jisasr htamo tahi muht be tu nfri mift htamorr. Tafi wom yima gu hta duha tahi muht htamorr. ");
INSERT INTO amp_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Jisasr muht rihtamohat Fraide rihtamorr. Nd Fraide yihar bi tu Judaroh rhu krna Sabat yihar bi rhu yibon hanymomr. Sarere yihar nd rhu krna yihar rhumoumr. ");
INSERT INTO amp_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Nd Jisasr Galiliko htiyaknamo metm rpat Josefrpno yimomn hti hikmom Jisasr rihtamo tahi muht. ");
INSERT INTO amp_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Hti hik tanyhato tfit turohko yihato Jisasrhu thatipt gbrornayuk welpam yi fak mska inji namom. Memom, “Ka yirahnom thatipthu gbrornaneft,” to nhai, rhu krna yiharn nhai yirmom. ");
INSERT INTO amp_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sande yiha bi dbha ksfutn met kmim Jisasrhu thatipthu gbrorna wunayukm sinyani yimom. Nd rom yak mska htatamo welpam yaknihato yimom. ");
INSERT INTO amp_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Yihato nd Jisasr rihtamo tahi muht frkihafmo tahis mtohhato mhti hambraknimomt. Nhai wom rhurmot. “Barenko, to fitot tahis? Frohm yak tuhefimt?” ");
INSERT INTO amp_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Be mhti hambrohato fknenimom yiro tahi muhtn. Fknenihato asha tfit yima gu tfkhat rim hti hambriwumt. ");
INSERT INTO amp_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Be tuha mrokfo duhatm tohmoum. “Barenko, barenko, ndu yimare tamohr yaknirorr?” Be tuha inji yuhre kfo ptha haso hanymom asha hus yimaf ganyom hmbreshetf mtohmof. Hmbresham wafnhumohat memom nndo binasoht yak dbratwatm fnhutwot. ");
INSERT INTO amp_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Be tfit fanhomom nd yimaf htihato. Nhai marimo kukatohwonomf. Yanho rifuhetmn nyingatikm nndo bbinysoftn wafukatohmom. Nd mtohyuk yima husf kfo memofm, “Barenko, nikone mumiwuko? Tamohmpno tfit yamukako, ‘Yopko anianom?’ ");
INSERT INTO amp_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nd noheh yimar bi tfit sinyani yifir. Niko ka nhai duka hanykahko ror Galilit hingrnanehato kfomoa mrokfom. ");
INSERT INTO amp_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Kfo hna memour, ‘Bro Najomr fasoh nefm nayet yimamn tat noh bonohakruhamr yura bgre misn mnohrahr. Nohhato hus marf rhunihato husfirpehrpno tfit sinyarahr.’ Nd mrokfom nhai wany hnarmokomm?” ");
INSERT INTO amp_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Be inji kfomotfm tfit dukakmomm Jisasr pthayuk mrokfom. ");
INSERT INTO amp_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Be tfit yimom. Yihato nd Jisasr hik habrimoa 11-pela yimam yo wom met yindarim kfo nuhas hanymomm. ");
INSERT INTO amp_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Makdala efkot Mariat, Joanat, Jemsrhu mmem Mariat yo wom wom metm rompno tohyukm, romn yi hti tanyhato kfo nuhas bonuhasmomm nd Jisasrhu disaiperm. ");
INSERT INTO amp_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Nd Jisasrhu disaiperm met kmim inji kfo nuhasmohat nhai wany yakiormomm. Memom, “Ka be kfo ddiwum.” ");
INSERT INTO amp_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Pitar sinyahato memor “Na tukann afo yi hti tungunaruha.” Inji kfo tanyhato toniyefrpar fakmor. Yimorn tahi muht mtohmorn yewirnahato rihtimor yima gurr htamo tkitt. Nhai wom tamohm rihtirmor. Sfnoh, rmontharpam rim htimor. Inji htimohat tuha mfhat hifa mmbrahato mrokfo ptha duha kekutni tfit yimor. Yihota yuhat be duka hany memour, “Ndu yimare sinyani mifr o yimam yekmr nndo htemr?” Boknabok dukefm fakmoumr. ");
INSERT INTO amp_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Nd yiha Jisasrhu hus disaiperf Jerusalemt sinya tanyhato memof, “Emeusko anyo.” Jerusalemti nd kmi Emeus 11-pela kilomita yaukfot. ");
INSERT INTO amp_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Nd hus yimaf yihotat yau hanyhato nd Jerusalemtpno rhumo nefmn ndm tuf naptha srh hanymof yau hanyhato. ");
INSERT INTO amp_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Inji naptha hanymof Jisasr ror yimorn rpat mnathu kmbrenihato rpat fau hanymom. ");
INSERT INTO amp_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Rof nd hus yimaf nhai hti nhtahato marimorf, “Arr Jisaser.” Rof memouf, “Ka wom yima furar kaunho hnewurno.” ");
INSERT INTO amp_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yau hanyhato buharn ttiwon memorf, “Nifne tamohmn naptha hanitafn?” Inji ttiwonmotrf rof tfit mtohhato yima yuhum nhai marnyarmomf. ");
INSERT INTO amp_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Nd yau hanymo yimafhu yufam womr Kliopasr. Rorn kfo memor, “Jerusalemr kmi kmiroh yimam nia tohwom. Ka ninrpa mifn nhai wanykahnm nda Jerusalemt yorhwa nefm?” ");
INSERT INTO amp_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Inji kfomotr tfit Jisasr ttiwonmorf, “Tamoh nefm Jerusalemt yorhwam?” Kfo memofr, “Nasaret thof Jisasrpno rhumo nefm kfiwuno. Nd yimar profetr tohmor. Nd yimar Bro Nkifrar yo yima mifm rorhu hingrnefm yo mrokfom htimomr be tu yafothet hingrneft hingrnamour. ");
INSERT INTO amp_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Tunmoh prismi tunmoh bro yimamn Romroh tirmn htahato bgre misn hegirmotmr nohmor. ");
INSERT INTO amp_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nmoh dukefm duka memounom, nd yima Jisasrn Bro Nkifrar tkrurafmor Isrerroh minrfa htiyakneft. To wom mrokfot wawanyns. Nd yimar wasni rhuro yiham bi asor href korhwonomr husfirpehyuk yihar. ");
INSERT INTO amp_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nompno tohyuk wom metmn dbha yopko mhti tanyhato nia pthitm nom be sinya fohtasnom. ");
INSERT INTO amp_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Rom yihat nhai htirfomr Jisasrhu thatipt. Tfit kmifako niahato mkfo famum, ‘Mounmotrpam htitawonom.’ Romn kfo nuhas famumnom, ‘Jisasr bi sinyani yifir.’ ");
INSERT INTO amp_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nompno tohyuk womm nhaf nd met kmim kfoyuk mrokfom wany sanyhato rom tumn yihato famum turoh nyingaye, ‘Amhti yimbu tanynom.’ Yihato rom nhaf sfnoh tkitt mhtitawom.” ");
INSERT INTO amp_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Nd hus yimafhu mrokfom kfo ptha buganimotfm Jisasr kfo memorf, “Nifne ka nhai yima yuhu duhatefn yon mumenm kanjo mumiwuko? Bingot profetm pthayuk mrokfom ayakitohkomm, nhai ndhtet bok dukefm yakrfotko. Href inji htitawohat to be nikmoh dukefm yirfom nd profetm pthayuk mrokfomn. ");
INSERT INTO amp_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Bro Nkifrar kfo memor, ‘Nd yimarn nieruharn nda bbinysofthu yimam minrfa htiyakrahrm.’ Nd mrokfot Bro Nkifrar kfoyukt ka nhai wanyrmokomt? Nd yimar niahato yimaroh minrfa htiyakneft afo yahrt tohhato kku yaknihato ee tfit kto nd yahrt tohyuk yimar Bro Nkifrarpno bro yufat yakkfot.” ");
INSERT INTO amp_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Inji kfonihato tfit Kraisrpno rhuyuk nefm Mosesri profetme wom womm bi kfomom, ndm rom mkfo htfasakhato kfo hik bohik nuhasmorf. ");
INSERT INTO amp_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Be inji nakfo ptha hany be rof yimo kmit mfnahmom. Ror Jisasr memor, “Yau fnahruha.” ");
INSERT INTO amp_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Tfit ndwom yimafn memofr, “Marr bi yohnitr, asha nonpno wahwe.” Be inji kfomotf be rofpno rhumor. ");
INSERT INTO amp_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nuwa yenyeftpno tebort mrhumomn bretpat yakhato Bro Nkifrar wukfo bruttnanihato yaktifmortn hemorf. ");
INSERT INTO amp_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Inji namotr ee ndnatn hti dukamofr. To be rpa htit nhai tfit wom htirmofr. Yudbat be tuha mifrtnehnimor. ");
INSERT INTO amp_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Hti hambrafhato tfit tuf nna ptha memof, “Barenko, Bro Nkifrarhu mrokfot ptha nuhas hanyetrn yima yuhum sinyem.” ");
INSERT INTO amp_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Be inji nakfo ptha hasohato tfit yudbat sinyanihato Jerusalemko tfit yimof. Tfit yihato Jerusalemrn Jisasrhu 11-pela disaiperm mhtiyaknimofm wommpno rhu hasomom. ");
INSERT INTO amp_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Romn kfak memomf, “Barefn, Bror sinya mifmor. Saimonr bi hti mifmorr.” ");
INSERT INTO amp_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Tfit rof sinyahato tawo rof htiyuk nefm kfo srh nuhas bonuhasmofm. Kfo memofm, “Ror pthanihat nhai merfono, ‘Arr Jisaser.’ Nhai. Bretpat yaktifhato hanyeftpno ndnat hti dukenonr.” ");
INSERT INTO amp_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Disaiperm inji naptha hasetmn Jisasr yihato mfnahmorm. Mfnahhato kfo memorm, “Yima yuhum ami-rhumko.” ");
INSERT INTO amp_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Rom Jisasr htihato memom, “Ka nthoner.” Memom, “Amyakrmiyakninom.” ");
INSERT INTO amp_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Kfo memorm, “Ayakrmiwahko. Nikmoh yima yuhum tamohmpno boknabok dukefm yekwako? ");
INSERT INTO amp_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Naya. Wahti-komm nanhu tir wuram. Nanhu thatipt wahti kothakomt. Nthonm nhai nann kanjo tha tpitiketm rhukahm.” ");
INSERT INTO amp_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Inji kfonihato tir wuram fak nuhasmorm. ");
INSERT INTO amp_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Rom inji htihato yindhorwom. Tfit wom yima yuhumn duka memom, “Nom mirahnom ka Jisas mifr sinyer. Rorhu yafothatn nia mkfo nhehrahtnom.” Tfit ttiwonmorm, “Niko tom wom yeshrim?” ");
INSERT INTO amp_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Tandhiyet yiraparpat rhumott ndt yakhato hemomr. ");
INSERT INTO amp_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ror nd yirapat yakhato rroh nyingahato famort. ");
INSERT INTO amp_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Yenyihato kfo memorm, “Na nikompno toh hnamohat bi kfo memoyanko, ‘Bingot Mosesrhu boririfhut yo profetroh mrokfomn yo windohmn hta hnamom nhai be hta fura hnarmomm. Nd mrokfom fipetm rhukfot.’” ");
INSERT INTO amp_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Rroh yima yuhum fak wutha inji namorm memor, “Yak wuthakahtanm rfa borngt rhuyuk mrokfom dukarahmm.” ");
INSERT INTO amp_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Kfo memorm, “Bro Nkifrarhu rfa borngt kfo kangt, ‘Yimaroh minrfa htiyakyuk yimar, Bro Nkifrar kfo tkrurafyukr, afo bro yahrt tohhato nohkfot. Nohhato tfit hus marf tohnihato husfirpehyukrpno sinyakfot. ");
INSERT INTO amp_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kto ndar bbinysofthu yimaroh mrokforoh kfo nuhas htfasneft rorhu yufatpno kfo nuhas htfashato yimaroh fasoh nefm mong trohkfot. Inji narahm Bro Nkifrar yak thurahrm ndar bbinysof thofroh fasoh nefm. Nd hingrneft tuha Jerusalemtn rihingrnakhato hingrna hanykfot.’ ");
INSERT INTO amp_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Niko ndar Jerusalemt rhuro nefm kfo ptha srh htfaskfot kmi kmim. ");
INSERT INTO amp_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Wanukko, Bro Nkifrar kfomor turhu Yafothathu niko hanyeft. Ndnettn bi brbohwa nd Bro Nkifrarhu Yafothathu niko hanyeft. Tuha Jerusalemtn nd Yafothat rhu garikfot.” ");
INSERT INTO amp_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Jisasr turhu disaiperm yaknihato rpat yimomn Betanitn tirm hamuhhato Bro Nkifrar kfo memorr, “O Bro Nkifraye, ndar disaiperm wayak marnya bomarnyatwanm.” ");
INSERT INTO amp_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Inji kfo ptha hanymor be wafakmorn yura hefenr muhmor. ");
INSERT INTO amp_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Kfo tato tanyhato be yindhorefrparpno tfit Jerusalemko yimom. ");
INSERT INTO amp_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Yihato Bro Nkifrarhu temperr rhuhato yiha yiha kfo yindhormoumr. ");
INSERT INTO amp_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Mrokfor bingot bi rhu gungonmor. Mrokfor bi ruhetrn ee kto nda mounti bbinysoft trhamof. Mrokfor bi Bro Nkifrarpno rhumorn, to nd Mrokfor Bro Nkifrar kanjo rhumor. ");
INSERT INTO amp_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Bingot Mrokfor to bi Bro Nkifrarpno rirhungotakmor. ");
INSERT INTO amp_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Mrokfor kfomor, nd tamoh tamohr Bro Nkifrar hingrnamorr. Mrokfor akfo duha yir, nhai wom tamohr Bro Nkifrar hingrnarmorr. Nhai. Mrokfor bi ruhetrn nd Mrokfor kfomor tamoh tamohr Bro Nkifrar hingrnamorr. ");
INSERT INTO amp_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Mrokfor yimaroh ruhefr tohefr kakitohworr. Yakitohhato nukeftpno yimaroh wiyauyau nmbuhat kak hta bohtewurm. ");
INSERT INTO amp_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nd nukeft yifung tahasiwut, to nhai tfit yifungpamn yakaknihato nd nukeft yifungpamn yak tasifkfot. ");
INSERT INTO amp_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","To tor wom yimar niamor, rorhu yufat Jonr. Bro Nkifrar kfomotr niamor. ");
INSERT INTO amp_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ror be nukeft hatohyuk yimarhu mrokfothu kfo nuhasneft niamor. Niahato tuhan yindarim kfo nuhasmotrm be nd mrokfot yakhato hikmomt. ");
INSERT INTO amp_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","To mirahko ka Jonrn nd nukeft hatohyuk yimayer. Nhai. Jonr to be nd nukeft hatohyuk yimarhu mrokfothu kfo ptha nuhasneftn niamor. ");
INSERT INTO amp_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tu yima bugaroh hayuk nukef mift hatohyuk yimar bi niamor ndar bbinysoft. ");
INSERT INTO amp_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Nd yimar to bi ndar bbinysoft tohmor. Bingot ror kfomotr ndar bbinysofti mount trhamof. To nda bbinysoft tohwa met yindarim nhai hti nhtarmomr. ");
INSERT INTO amp_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Turhu kantri mifko yimor. To nd turhu kantriko tohwa kmi Judam nhai kfakrmomr. ");
INSERT INTO amp_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Wom womrpamn hti nhtahato kfakmomr. Kfakhato rroh yima yuhum rorn htamom. Ndnettn romn yakhato htamorm Bro Nkifrarhu yonm. ");
INSERT INTO amp_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nhai be yifammaroh kkupam yak nhombrewa yuhatn Bro Nkifrar nd yuhatn yifemrmorm. Nhai. Rroh yima yuhum Kraisrn htamomm. Bro Nkifrar ndt htihato to be rorn yifemmorm. ");
INSERT INTO amp_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nd Mrokfor tfit yima yonr kanjo yak dborhanehato nia mitohmor nmoh buha. Bi htimonomt rorhu bro yufati rorhu bbukeft. Nd Yonrpar Bro Yifemrhu yoner. Bro Nkifrarhu tu yuhuwafefti yafothet nef mift tu bro mifwotr. ");
INSERT INTO amp_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jonr rorhu nia mrokfot kfo pthahato kfo nakuyaf memor, “To nda yimarn na kfo hna memoya, ‘Tor nanhu mongko nierahr wom yimar, ror bi Bro Nkifrarpno rpat ritohngotakmor. Ndnettn rorn buriwura.’” ");
INSERT INTO amp_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Nd yimar, yima yuhuwafeftn tu bromotr. Nd rorhu yima yuhuwafeftn, yima yimanom yihof href kak marnya hasiwurnom. ");
INSERT INTO amp_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Rot boririfhut Bro Nkifrar hemornom Mosesrhu tirtn. To tfit Jisas Kraisrpno, htitnom Bro Nkifrarhu tu yuhuwafefti tu yafothet nef mift. ");
INSERT INTO amp_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nhai nom nda bbinysofthu yimanom Bro Nkifrar bi hti nkrirmonomr, be tu nhai mif. Nd tu Bro Nkifrarhu Yonr, ror tu Bro Nkifrarn, tu Yifemrpno toh tany nietrn, rorpno Bro Nkifrarhu ruheft htimonomt. ");
INSERT INTO amp_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Judaroh bro yima boyimat kfo tkrurafmomm prismi yo Lifaim. Taun Jerusalemt htanyhato yimomn Jonr kfo ttiwon memomr, “Nine frohe?” ");
INSERT INTO amp_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Be Jonr nhai marimor finji kforuhar. Toh bugamotm kfohe memorm, “Na mirahko na ka nd rom kfiwa Kraisa.” ");
INSERT INTO amp_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Tfit ttiwon hasuknakni memomr, “To nine frohe? Ka Iraijaye?” Tfit Jonr kfo memorm, “Nhai.” “E, frohe, ka nd Mosesr kfomo profetr nom gari hasiwar, ka nd profete?” Tfit ror kfo memor, “Nhai.” ");
INSERT INTO amp_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Tfit wompam kfo memomr, “Ni to frohe? Nom kangnom ni wakfo nuhas marnyafkahtnnom, nom awany marnya tanykahnomn, ee bt yiruhanomn, nom kfo tkrurafyuk bro yimam kfo marnya bomarnyarahnomm.” ");
INSERT INTO amp_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Inji kfomotm profet Aisaiar kfomo mrokfot yakhato kfo ptha hik memorm, “Na nd nungur tik furat kfo nakuta yimaya: ‘Bro Nungothetrhu niayuk yihotat bi wayak marnya bomarnya hasohekomr.’” ");
INSERT INTO amp_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Farisimn nd yimam kfo tkrurmotmm niamomn, ");
INSERT INTO amp_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Jonr kfo ttiwon memomr, “To ni Kraisn rhu duha yi shoft, o Iraijan rhu duha yi shoft, o nd profetn rhu duha yi shoft, to tamohmpno yimam baftaiswanm?” ");
INSERT INTO amp_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jonr tfit rroh mrokfot kfo wok memorm, “Na be bupa fura baftaisim-wanm yimam, to tor wom yimar tor nikompno tohwor. Niko nhai tawisaf-kahkomr. ");
INSERT INTO amp_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Nd yimar nanhu mongko niewur. Na, na be yima furaya rorhu senderfhu ki jbkafyuk mtinf kak nyusakahukanr.” ");
INSERT INTO amp_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Jonr nd mrokfot pthamohat tek Joden mkukor yorhwa kmi Betanit nd mrokfot pthamort. Nd tkittn Jonr yimam baftaisimmourm. ");
INSERT INTO amp_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Tfit hwe fnah ndwom marrn Jonr htiyakmorr Jisasr. Htiyakhato kfo memor, “Wahtiko. Ndr Bro Nkifrarhu sifsif yoner. Rorn bbinysoft tohwa tuhan yindari bugaroh fasoh fasoh nefm yak thuhirahrm. ");
INSERT INTO amp_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","To nda yimarn na kfo hna memoya, ‘Tor nanhu mongko nierahr wom yimar, ror bi Bro Nkifrarpno rpat ritohngotakmor. Ndnettn rorn buriwura.’ ");
INSERT INTO amp_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Na nhai tawisafrmoyanr. Na tamohr kfo marimora, tor nd yimarn Kraiser? Nhai. Na, na be yimaroh tekthu baftaisimhato Isrermpno nd yimarhu myak nriyafyuka. Nd nayukann niamoya.” ");
INSERT INTO amp_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Tfit Jonr kfo ptha memor, “Na nd yimarhu baftaisimneftpno htimoyant Bro Nkifrarhu Yafothat yura hefenr wutoh tanyhato ganyom mmkrs kanjo yak nhombranehato fawihnamot. Be nd ganyom mmkrs yawihnehato be yimarn mifakmort. ");
INSERT INTO amp_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Na to tamohr kfo marimora, tor nd yimarn Kraiser? Nhai. Na tuhan yindariroh baftaisim-nefthu kfo tkrurafyuk yimarn bi kfo memora, ‘Yimam baftaisim hanyhato wahti hanyswa fitoh yimar htitn Bro Nkifrarhu Yafothat yawihnehato mithu nawohwotr, tor nd yimarn Bro Nkifrarhu Yafothaye tfit baftaisimrahrm tuhan yindarim.’ ");
INSERT INTO amp_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Na tukianhu nyingaye htimoyanrn kfiwanko, nd yimar tu Bro Nkifrarhu Yoner.” ");
INSERT INTO amp_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Hwe nfha ndwom marrn Jonr tfit turhu uhik ahik htfasyuk hus yimafpno tek Jodent toh hasomom. ");
INSERT INTO amp_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Jonr htiyaf hanymorr Jisasr fau hanymotr, nd turhu uhik ahik htfasyuk yimaf kfo memorf, “Htifnr. Bro Nkifrarhu sifsif yoner.” ");
INSERT INTO amp_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Be nd yima husf inji wanyhato be Jisasr mfau hikakni twanhomof. ");
INSERT INTO amp_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jisasr kekutakhato htimorf yau hik hanymotfr, kfo ttiwon memorf, “Nifne tamohmn hambro hnewafn?” Tfit rof ttiwon memofr, “Rabai, ni fitoh kunys tohwa?” Nd Rabai mrokfothu yimbu yuhat inji kfiwut, Tisa. ");
INSERT INTO amp_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Be Jisasr kfo memorf, “Wania. Wahtifn.” Marr bi 4 kilok tohmor. Be rof yimofn nd ror tohmoa kunys htihato nd krifr be rorhu kunysn rhu krif bugamofr. ");
INSERT INTO amp_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Nd Jisasr yau hikaknimo yima husf, to Andrur tor womr. Andrur, Saimon Pitarhu najomr. ");
INSERT INTO amp_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andrur Jisasr htanyhato barkofpam afo turhu najom Saimonr yau hambra-khato kfo memorr, “Nd profetm kfomoa yima Mesaiar bi htitawo-nomr.” Nd Mesaia yufathu yimbu yuhat, Bro Nkifrar yak htiwa yima nrfa hbhakyuk yima Kraisr. ");
INSERT INTO amp_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Be turhu najom Saimonr mkfakhato Jisasrpno hanymorr. Jisasr htiyakhato kfo memor, “Ni Jonrhu yinem Saimone. Kto yimam yutarahmn Sifas.” Grik yarmumatn nd Sifas yufat kutewumt Pita. To tfit nd Sifas yufat yo Pita yufat, nd yufafhu yimbu yuhat, tahis. ");
INSERT INTO amp_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Tfit ndwom marrn Jisasr memor Galiliko aiya, Filifr yihom htimorr. Yihom htihato kfo memorr, “Wania, wahikna.” ");
INSERT INTO amp_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filifr taun Betsaida thofr. Nd kmi Betsaidat Andru Pitarof tohmoa kmiyet. ");
INSERT INTO amp_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Tfit Filifr yau hanyhato Natanierr mhtimorr. Mhtihato kfo memorr, “Bare, nom wanymoa tndh kfothu yimar, nd Mosesrhu boririfhu gonborngm kfo tndhmoar, yo nd profetroh gonborngm kfo tndhmoa yimar, tor bi htimonomr. Nd yimar, Nasaret thof Jisasr, Josefrhu yinemr.” ");
INSERT INTO amp_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Tfit Natanierr sinyahato kfo ttiwon memorr, “Nasaret to tefi kmiyenet. To nhai ndhtet tefi kmiyentn ndhtet bro yufet yimar mfnahkfot.” Tfit wom Filifr kfo memorr, “To tu waniekahnn afo wahtitwa.” ");
INSERT INTO amp_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Jisasr Natanierr htiyak hanyhato kfo memorr, “Asor tu Isrer thofen mifr. Ror nhai wom kfo nhehefen nmbuham rhukahmr.” ");
INSERT INTO amp_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanierr inji wanyhato tfit Jisasr kfo ttiwon memorr, “Nane fitoh yiha htihato inji kfiwa?” Tfit Jisasr kfo memorr, “Ni afo tafi Filifr mnakuyak duha, na bi htitawoyann fik tihathu tpitn rhu hasetnn.” ");
INSERT INTO amp_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natanierr nd mrokfot wanyhato kfo memor, “Tisa, ni Bro Nkifrarhu Yone, Isrerroh Kinge.” ");
INSERT INTO amp_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jisasr kfo memorr, “Kfo yamukann ndu fik tihathu tpit rhu hasetnn bi htitawoyann. Ka ni ndt wanyhato ninhu dukefr sinyahato famuna, ni Bro Nkifrarhu Yone. Kfiwann, ndt rot be inji htitwont. Kto bro bro nefm yak nuhasrhotann htirahnm.” ");
INSERT INTO amp_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Tfit wom kfot Jisasr kfo memor, “Na kfo mifwanko, kto htirahkomt mount frtnehhato rim rhu mrhuruhatt mounmotm mano hefenko muh tfit Bro Najomanpno nia, yo tfit hefenko muh, tfit Bro Najomanpno nia inji naruhatm htirahkomm.” ");
INSERT INTO amp_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Filif Natanierrof Jisasr yakmohat tfit wom hus marf rhunihato ee Galili profinsko yorhwa taun Kanatn wom yimar tuhan fakmor. Nd yima sawohf nayak tatrutmo yihart Jisasrhu mmemt rot yihato rhunhomotm. ");
INSERT INTO amp_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yo Jisasri rorhu disaiperm rom to inji buga nakumotmm yimomt nd yima sawohf nayak tatruthato htamo yemro burwat. ");
INSERT INTO amp_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Nd yima sawohf nayakyuk yiha yayuk wain bus yihany yi hanymomtn be fe bugamomm. Jisasrhu mmemt inji hti tanyhato Jisasrpno yimotn mkfo memotr, “Nd yima sawohfhu nayakyuk yiha yayuk wainkfot bi yihna yi hnarommn, be bi fe bugaromm.” ");
INSERT INTO amp_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Inji mkfomottr tfit Jisasr kfo wok memort, “Mamai, to nanpno mkfiwann to na finji narhoya? Na nhai bi arihatn na tamoh nefm bi finji narhota. Nanhu mirakerroh hingrna yihar tor afo riyorhwor.” ");
INSERT INTO amp_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Be wom mmemt inji kfomotrt, yimotn hingrna yimam kfo ptha memotm, “Ror finji kfiwurko, to be ror kfo pthayuk tng yuhatn hikkfot.” ");
INSERT INTO amp_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Nd kunys rhumoum 6-pela bro bu rohm. Nd bro bu rohm 100 lita bupam tas hmbremoumm. Nd bu rohroh bupam tu Judam nkifra yuk truf o tir kifsa inji nayukmn kakitohmoumm. ");
INSERT INTO amp_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Nd bu rohm brioh bupa duhatmn Jisasr kfo memor, “Bupam watas hmbrekomm.” Be nd bu rohm tas furkih hany bugamomm. ");
INSERT INTO amp_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Be tas hmbreni bugamotmm Jisasr kfo memorm, “Nd asomif tas hmbrehani bupamn wahanyhekomr nd burwat mtohekwa yimar.” Be inji kfomotr wompam hanyhemomr. ");
INSERT INTO amp_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Nd bupa mifm bi wain bupam kekutmom. Nd bupam hanyhemotmr nd burwat tohakyuk yimar fesiwonmorm. Ror be yesiwonhato nhai tawisafrmor nd wain bupam niayuk yuhat. Nd bupam yakyuk hingrna yimarpam tawisafmom nd bupam niayuk yuhat. Nd burwat toh yukatohyuk yimar tfit nakuyakmorr nd tuhan yakyuk yimar. ");
INSERT INTO amp_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Nakuyakhato kfo memorr, “Bare, dodh yima bugam inji newum, nd tu marukfet dborioh wain bupam hihany hi hanynitamm, bi fe furkihme ee tfit wom wain bupa furam yakhato kahukmm. To ni nhai inji nakahn. Nhai. Ninhu tu marukfet dborioh wain bupam afo yak htatamonmn tfit asomif fak htenm.” ");
INSERT INTO amp_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Tot barkof mirakerkfot Jisasr rihingrna gngonakmot. Galili profinsko yorhwa taun Kanat tohhato nd miraker-kfot hingrnamort. Nd mirakerkfot hingrnamot, ror yakitohwa yufati bbukefthu yak nuhasyuk neft fak nuhasmor. Nd nefmn disaiperm htihato to be rroh dukefm Jisasrn htamom. ");
INSERT INTO amp_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Be Jisasri turhu mmemt, yo nmemrom, ee turhu disaiperm nd taun Kanat htanyhato tfit Kaperneamko yohnehato ndha tohmom wom yiham. ");
INSERT INTO amp_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Judaroh wom bro yihar kutewumr Pasofa Burwat bi brboh hnamot. Nd yihar bi brboh hanyetrn ndnettn Jisasr yimor Jerusalemkor. ");
INSERT INTO amp_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Jerusalemt yimorn Bro Nkifrarhu temperr gna habrimo gnathu yifhatikt rim fnahnimor. Rim fnahnihato rim htimorm yimam tarioh mthayuk bulmakaum, sifsifm, ganyom mmkrm maketim hasomomm. Tfit manoko maruha yak tuknayukm rhuhato maruham nayak tukna-moum. ");
INSERT INTO amp_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ndhtet ndhtet hingrnefm hingrnamoatm Jisasr rim htihato wom mtitof nmbuham yakmorn wift kanjo hingrnahato nd wiftpno yimam hik nembos tubatumorm. Nd rom maketim haso hanyuk bulmakau sifsifm, rpat fak tubatumorm. Yimam maruha yak tukna hasoyukm, ndm nhaf maruham frbrur bobrur fnahhato teborm yakhato fak kekut fnahmorm. ");
INSERT INTO amp_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Be nd nungam maketmoa yimam kfo hutt memorm, “Be na kfiwa asomif nungam tamohm wayakni hany wafnahniko! Ndarte ka nikmoh ndhtet ndhtet hingrnefroh hingrnayuk kunyet? Nhai nanhu Yifemrhu kunys rhukaht? Tamohmpno ndar temperr tfit maket swirt nhombriwat?” ");
INSERT INTO amp_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ror namo neft turhu disaiperm htihato tfit dukamomt Bro Nkifrarhu rfa borngtn Defitr kfomo mrokfot. Nd mrokfot inji kfo memot, “Nanhu bro yima yuhur ninhu temperrn bro dukefr korhwor. Ndnetann kanga nd temperr be inji arhu marnya hasor.” ");
INSERT INTO amp_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Judaroh bro yimam nd Jisasr namo nmbuhat htihato kfo ttiwon memomr, “Bare, frohm kfo memomn ndhtet neft wanatwa? To bt asomif wom mirakerkfot wahingrnakahtnt ndt htihato nom kfo mirahnom, ‘Awi, nd yimar Bro Nkifrar kfo tkrurafmorr. Tempert maket htayuk yimam ror nia yak thuneft, nhai mrokfom.’” ");
INSERT INTO amp_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Inji kfomotm tfit Jisasr kfo wok memorm, “Nda tempert wayak tasohkomt. Watasohkahtkomt tfit nann husfirpa yiharpa kasinyaruhant.” ");
INSERT INTO amp_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Be nd yimam Jisasrhu kfomo mrokfot wanyhato kfo memom, “Bar yimako, nda temperr hingrnamohat 46 gunyjim bugam hingrnamomt. Tfit ka ninn be husfirpa yiharpa bmbri kasinyahato hingrnarahnt?” ");
INSERT INTO amp_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","To nd ror kfomo tempert nhai tu temper mift kformor. Turhu thatipt kfomor. ");
INSERT INTO amp_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ndnettn kto Jisasr nohhato husfirpa yiham yopt rhuhato tfit sinyamohat, disaiperm tfit dukamomt ror kfoyuk mrokfot. Nd mrokfot dukahato memom, “Bro Nkifrarhu rfa borngt rhuyuk mrokfom yo ror kfoyuk mrokfom fipet mrokfoyem.” ");
INSERT INTO amp_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Jisasr afo nd Pasofa burwa yihar Jerusalemr tohhato bok mirakerkfot hingrnamoam bok met yindarim htimoumm. Htihato ndnetmn rroh dukefm rorn htamoum. ");
INSERT INTO amp_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","25","To Jisasr yimaroh yima yuhu mifm bi htitworm. Nhai wom yimar tfit rorpno yihato kfo nuhaskfot. Ndnettn inji htimohat, duka memor, “Rroh yima yuhum nann be inji hta tefinitammn tfit kto mong trohrahma.” ");
INSERT INTO amp_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Wom yimar, rorhu yufat Nikodemusr, nd yimar Farisiroh hingrneft yakitoh yo Judaroh bro yimar toh inji namour. ");
INSERT INTO amp_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nd yimar turpathato Jisasrpno yifung yimorn mkfo memorr, “Tisaye, nom wom Judanom htitwonomn ni Bro Nkifrar kfo tkrurafoyuk tisaye. Bro Nkifrarhu Yafothat mthu nawoh duha yimar nhai ndar ni hingrnewa kanjohot mirakerkfot hingrnakfot.” ");
INSERT INTO amp_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ror inji kfomotr tfit Jisasr kfo memorr, “Na kfo mifwann, yimar nhai miyak dborharfor nfri yonm kanjo, nd yimar nhai htiruhatrt Bro Nkifrarhu kingdomkfot.” ");
INSERT INTO amp_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Tfit Nikodemusr ttiwonmorr Jisasr, “To yimar bi tabou hanyetr, to finji tfit mmemt fkniruhatr mmemt wompam hiyauruhatr?” ");
INSERT INTO amp_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Inji kfomotr Jisasr tfit kfo memorr, “Na kfo mifwann, yimar nhai bupami Bro Nkifrarhu Yafothat yak kekuthato nfri yimar frdborharfor nd yimar nhai fkniruhatrt Bro Nkifrarhu kingdomkfot. ");
INSERT INTO amp_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Yima sawohfn kasinyewar, yima mif thetr kak nhombrewur. To tfit Bro Nkifrarhu Yafothatn htewutr yafothar. ");
INSERT INTO amp_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Mirahn bok dukefm ayaka nd na kfo yamukohat, ‘Nfri yonm kanjo miyak dborhakfot.’ ");
INSERT INTO amp_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Wifort wifor thombat, rot be tuthu yiyeft kitt. Ni be mirefrpat wanukantn, nhai htikahnt rot sinya tanywa tkitt yo rot yita tkitt. Bro Nkifrarhu Yafothat yimam yak kekuthato nfri yimam frdborha thombat, to inji htirahnm. Nhai htiruhatnt Yafothathu hingrna yuhat.” ");
INSERT INTO amp_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Tfit Nikodemusr ttiwonmorr Jisasr, “To nd Yafothathu hingrnaneft finji kanjo rhuruhat?” ");
INSERT INTO amp_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Tfit Jisasr kfo memorr, “Bare, ni to Isrerroh tisaye. Tamohmpno ni tawisaf duha yita? ");
INSERT INTO amp_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Na kfo mifwann, nom kfo pthiwohat, nom bi tunom tawisafhato, yo nom tunmoh nyingaye hti hik bohiket nefmn nom kfo ptha nuhas-wonomko. Nhai be kfo furakahnom. To niko, nom kfo pthiwa mrokfot yekwakomt mongko htewukomt. ");
INSERT INTO amp_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nda bbinysofthu wuskam, na kfiwanko, nhai wany yakiokahkma. To na tfit yura hefenkorhof wuskam wukfo ptha thombat, to niko finji kanjo wany yakioruhakma? ");
INSERT INTO amp_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nhai nda bbinysofthu yimar yura hefenr muhrmor. Nhai. Bro Najomrpar yura hefenr bi muhmor. Tur yura hefenr wuhtanyhato fawihnamor. ");
INSERT INTO amp_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Bingotn Mosesr nungur tik furatn snekbras tuhegirmo kanjo, Bro Najomr tuhegirrahmr. ");
INSERT INTO amp_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Nd yuhatn, fitoh fitoh yimam rroh bro dukefm Bro Najomrn htemm, be inji toh nkifranirahm. ");
INSERT INTO amp_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Bro Nkifrar ndar bbinysof thofm be tu mfro marbit hta mifmorm. Ndnetrn nd rorhu rpa yon mifr tuhemorm. Memor, ‘Inji anakahta, fitoh yimam rorn rroh dukefm htemm, be nhai nohruhatm. Nhai. Be inji tahi nrwim kanjo toh nkifranirahm.’ ");
INSERT INTO amp_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Bro Nkifrar nhai turhu Yonr ndar bbinysofthu met yindariroh nefroh kothu yakitoh hanyeftn kfo tkruraf-rmorr. Nhai. Rroh nrfa hbhakneftn kfo tkrurafmorr. ");
INSERT INTO amp_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Fitoh met yindarim rroh bro dukefm nd Yonrn htewumm, nhai mrokfo duhatem. To nd Bro Nkifrarhu rpa Yon mifrparn nhai rroh bro dukefm htakahmm, nd yimam bi mrokfetm korhm. ");
INSERT INTO amp_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","To nd rom kotkfot tohruha nmbuhat nhai be sfno. Nda bbinysofthu yak nukayuk kshr bi niamor. To nhai nd met yindarim htihato nd ksh nukefrn yarim tohkahm. Be nd turoh fasoh fasoh nefmpno yesiswamn nndo kspitat rim tohwom. ");
INSERT INTO amp_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Met yindarim fasoh fasoh nefm niwam be tu hti nambur mifwomt nukeft. Nhai wofnkahm nd rroh fasoh fasoh nefm nukeft yakhato tafont rhukfot. Ndnetmn nhai nukeftpno yarim tohkahm. ");
INSERT INTO amp_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","To yimam tu dborioh nefm niwam nukeftpno yarim tohwom. Nukeftpno yarim tohwatm, yimam htihato kfo kangm, ‘Rom niwa nefm tu Bro Nkifrarhu dukef yuhat hikwom.’” ");
INSERT INTO amp_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nikodemusrpno nakfo ptha buganihato kto tfit Jisasri turhu disaiperm Jerusalemr htanyhato tfit tuha Judia profinsn toh htfasmom. Ndha toh htfashato ndharhof met yindarim baftaisimmorm. ");
INSERT INTO amp_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jonr nhaf kmi Ainonthu met yindarim baftaiskfot hemorm. Nd kmit brbo Salimtpno korht, ndombhart bok bu yinham ruhetmn bok met yindarim yihato baftaiskfot yi fakmoum. ");
INSERT INTO amp_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Nd yihart Herotr tafi Jonr yakhato kalabus hta duhatrn hingrna htfasmor. ");
INSERT INTO amp_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Jonrhu uhik ahik htfasyuk yimami wom Judar, turoh nkifra yuk truf yuhatpno rinahtakhato nnakfo huttmom. ");
INSERT INTO amp_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ndnatn wom Jonrhu uhik ahik htfasyuk yimam yimomn Jonr mkfo memomr, “Tisa, nd yimar ninpno rpat Joden mkukor tohhato kfo memo, ‘Nd yimar Bro Nkifrarhu Yoner,’ to nd yimarn bi bok met yindarim baftais yahukatrm bi rorparpno yimam kitm.” ");
INSERT INTO amp_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jonr nd mrokfot wanynihato kfo memor, “Yura hefenr wuyorhwa Bro Nkifrar rpa rpa hingrnefm kahukrm rpa rpa yimam. ");
INSERT INTO amp_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nikom bi tukmoh yimbhindange wanymokomt na nd kfo pthamo mrokfot. Memoyanko, ‘Na htiruhakomn mirahko ka asor nd yimar met yindariroh minrfa hbhakyuk yimar Bro Nkifrar kfo tkrurafmor. Na nhai. Na be rorhu nyingako tohak hanyuk yimaya.’ ");
INSERT INTO amp_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Yimar turhu kfo nanf tuhant yakyukr, ror tor. Yinowemr ror be tohhato wanukr mett yindarirhu yufat yuta thombat. Mett bi yindarirhu yufat kutewutr yinowemr be bro yindhoreft kekwotr. Ndtn tot nanhu tu bro yindhor nmbuhat yorhwat. ");
INSERT INTO amp_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Na kanga rorhu yufatn abrot, nanhu yufat ayohnes. ");
INSERT INTO amp_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Nd yimar ror yura hefenr wutoh tanyhato yawihnamoyer. Yawihnehato rorn yura buriwurm tamoh tamohm. Na, na be ndar bbinysof thofena, ndar bbinysofthu tamoh tamoh nefmn na pthiwa. ");
INSERT INTO amp_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ror, ror tu hefenr toh tanyetrn turhu nyingaye hti hik tanyuk nefm yo wany sanyuk mrokfom, nd ndmn pthiwur. To nd ror kfo pthiwa mrokfom nhai bok yimam wuyakkahmm. Dfik yimenrpam wany yakiowomm. ");
INSERT INTO amp_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Met yindarim nd rorhu mrokfot wany yakiohato yak hikwam, nd yimam rroh dukefm kangm Bro Nkifrarhu mrokfot tu fipayett. ");
INSERT INTO amp_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Nd yimar Bro Nkifrar kfo tkrurafetrn ndnatn tu Bro Nkifrarhu mrokfo yuhamn ptha hikwor. Ror mrokfom inji ptha hik bohikwohat to tu Bro Nkifrarhu Yafothar thu dbothat bugayetrn inji ptha hik bohikworm. ");
INSERT INTO amp_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Nd yimar ror tu Bro Yifemrhu Yinemrn tu marbit htewurr. Ndnetrn tamoh tamohm rorhu tirtn htamotrm rorn bi kakitohworm. ");
INSERT INTO amp_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ndnettn fitoh yimam o metm Bro Nkifrarhu Yonrn rroh bro dukefm htemm, nd yimam be inji toh nkifranirahm. Nhai inji narfom, be nhai toh nkifraniruhatm. Bro Nkifrarhu namburpam romn yirahm.” ");
INSERT INTO amp_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Farisim wanymomt Jisasr baftaisimmoa yimaroh thomnafat muhmot, Jonrhut yohnemot. Nd Jisasr baftaisimmoa yimam Jisasrn uhik ahik htfasmoamrn rorhu mrokfom wany yakitohmoumm. ");
INSERT INTO amp_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Nd Jisasrhu yimaroh baftaisimneft nhai tu Jisasrn baftaisimrmoarm. Nhai. Rorhu disaipermn baftaisimmoumm. ");
INSERT INTO amp_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jisasr tur hti nhtahato kfo memor, “Kmim bi nanrpaya bi hikwatm tom Farisim bi htihato kfo pthewum.” Be ndnatn nd Judia profins htanyhato tfit Galili profinsko yimor. ");
INSERT INTO amp_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Judia profins toh tanyhato Galili profinsko yinyeft, Samaria profins yuhat yiyetet yihotat. Ndnetrn Samaria yuhat yimor. ");
INSERT INTO amp_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Yimorn Samaria yorhwa taun Sikart mfnahmor. Nd taun Sikart korht brbo Jekofr yinem Josefr kfo nuhasmo tkit nmbuhatpno. ");
INSERT INTO amp_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Bingot Jekofr toumo bujr nd tkitt rhumor. Jisasr myau minysafmorn nd bujrpno mrhumor. Marr bi dany marr kanjo toh hanymor. ");
INSERT INTO amp_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Jisasrhu disaiperm ndha mhtanimomrn taunko yeshri wiknat yimom. Ror turpatr nd bujr rhu hasetrn Samaria efkott yimot bupa tasis. Jisasr nd mett htihato kfo memort, “Bupam wahina.” ");
INSERT INTO amp_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nd Samaria efkott inji wanyaf hanyhato kfo memotr, “Bare, ni finji kfiwa? Ni Judaye na Samaria efkota. To tamohmpno na nndo Samaria efkota kfo yamukona, ‘Bupam wahina?’” Judami Samariam nhai rpat rhuhato yemska inji narmoam. Ndnettn inji kfomotr. ");
INSERT INTO amp_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Inji kfomottr tfit Jisasr kfo memort, “Bro Nkifrar yahuka tamoh tamohm ni bi wahti hik bohiknm yo na bupa tndauwa yimaya bi wahti nhtana, to tfit ninn toh kekuthato womhtet bupam kfo tndaurfona. Inji tndaurfotna womhtet bupam herfoyann. Nd womhtet bupam yanyeft yimam toh nkifranitm.” ");
INSERT INTO amp_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Jisasr inji kfomotrt, tfit mett kfo memot, “Bro yimaye, to ni bupa yakyuk baket duhate. Bujrhu bupam watohngotwom. To fitha yakhirhoyanm nd ni kfiwa bupam? ");
INSERT INTO amp_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nmoh nkifra Jekofr ndar bujr tou htanihemornom. Bujr mfro yohnemotr bupa tashato rorhu yon tuhanm, sifsif bulmakaum, bupa tashemoahat be baketrpaye bupa tasakhemourm. Ndnettn nhai wom fitoh yuhamn bupa tasruhatnom. Ka ni kangn, wom yuhatn bupam yakruha?” ");
INSERT INTO amp_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Nd Samaria efkott inji kfomottr tfit Jisasr kfo memort, “Fitoh met yindarim nda bujrhu bupam tas yewam, nyunguramm tfit knarahmm. ");
INSERT INTO amp_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","To fitoh yimar nd na heruha bupam fawor, be nhai tfit wom nyunguram knaruhatr. Nd na hayuk bupam yiyafhato mirhurahm, nd bupam tfit yinha kanjo mfrfnah hasohato nd bupamn yakitohruhatmt rorhu toh nmbuhat, be inji toh nkifranirahr.” ");
INSERT INTO amp_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Jisasr inji kfomotr tfit rot kfo memot, “Bro yimaye, nd ni kfi bupam wahina. Nd bupa yekahann, nhai tfit nyunguram knakhato tfit bupa tasis nierhota.” ");
INSERT INTO amp_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Inji kfomott tfit Jisasr kfo memort, “Afo ninhu ramemr wamkfaknr.” ");
INSERT INTO amp_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Tfit rot memotr, “Na nhai ram duhata.” Tfit Jisasr kfo memort, “Nd ni kfo yamukohat nhai ram duhate, ndt tu kfot kfiwun, ");
INSERT INTO amp_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","yimam bi yakhna yakhnamonmn bi tirfa yima rhuhnamo. Nd 6-yukr to bi tor womr. To mirahn ka ndr nanhu tu ramem mifer. Nhai. Ni kfi mrokfot tu kfot kfina.” ");
INSERT INTO amp_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Jisasr inji kfomotrt kfo memotr, “Bro yimaye, bi wany nhtewann ni ka profete. ");
INSERT INTO amp_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nom Samarianmoh nkifram Bro Nkifrar bro lotum yakitohmoahat nda kminysofr mrifinyhato lotu hakumoum. Tfit arihatn niko Judako kangko, ‘Be Jerusalemrpar yihato walotuko.’” ");
INSERT INTO amp_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Mett inji kfomott tfit Jisasr kfo memort, “Bar mete, na kfiwa mrokfom wawany yakionm. Tor wom yihar riyorhwor. Nd yihar nhai ndar kminysofrn yuwa muhhato Bro Yifemr loturuhatkomr o Jerusalemr yihato loturuhatkomr. ");
INSERT INTO amp_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Niko Samariako Bro Nkifrar lotutwohat niko be nmbuha nmbuha mrokfom wanyhato lotutwoko. Nhai tawisaf marnyahato lotukahko. Nom tu Judanom Bro Nkifrar lotut-wohat nhai be lotu furakahnomr. Nmoh nkifra tndh mrokfot kfo nuhas-wotnom Bro Nkifrar yimam nrfa htiyakyuk yuhat. Nom nd tndh mrokfot bi nkiframn yo profetmn ptha hnamotmt nom wanyhato ndnettn nom Judanom tawisaf marnyahato Bro Nkifrar lotutwonomr. ");
INSERT INTO amp_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","To kfiwanko, yihar niayukr to bi asor bi niaror. Yimam Bro Yifemr kangm alotunom, nhai tfit kminysofm o Jerusalemr dukahato loturuhatm. Nhai. Bro Nkifrarhu Yafothat thu nawohruhattm tu Bro Nkifrar dukewa dukef yuhatn kanjo loturahmr. Ndhtet yimam Bro Yifemr hifa hti yindhor-wor. ");
INSERT INTO amp_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Mounti bbinysoft Bro Nkifrar thu yurhato kukatohwor. Ndnettn yimam kangm Bro Nkifrar alotunom, turhu Yafothat thu nawohkahttm tur dukewa dukef yuhatn kanjo lotukfot.” ");
INSERT INTO amp_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Jisasr inji kfomotr tfit nd Samaria efkott kfo memot, “Na tawisafwa, Bro Nkifrar kfo htamo yima nrfa hbhak-yuk yima Kraisr nierahr. Ror niere, rorn kfo nuhas bonuhas bugarahrnom tamoh tamoh mrokfom.” ");
INSERT INTO amp_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Rot inji kfomott tfit Jisasr kfo memort, “Na to nda. Na ndann kfo pthanuhiwann.” ");
INSERT INTO amp_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Rof inji nakfo ptha haso hanymo fijo disaiperm mfnahmom. Be yihom hti fohtasmomr nd Samaria efkottpno nakfo ptha hasetfn. Rom inji yihom htimohat be gonng yagonngt toh natohmom. Nhai womr marimor, “Ttiwon miruhanr, ‘Tamohmpno nd mettpno napthiwan? Yo tamoht kangn ayaka?’” Nhai womr inji kfo ttiwonrmorr. ");
INSERT INTO amp_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Be nd mett bu baket wuskam wahtanymotmn taunko tfit yimot. Yihato kmi thofm mkfo memotm, ");
INSERT INTO amp_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Bar yimako, waniakah-komn wahtikomr wom yimar. Na nahnayuk tamoh tamoh nefm kfo hik bohik bugerm. Ka tor nd yima Kraisr Bro Nkifrar kfomor.” ");
INSERT INTO amp_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Be inji mkfomottm taunthu tuhant yindars sinyahato yi htimomr Jisasr. ");
INSERT INTO amp_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Nd yiharpno disaiperm Jisasr kfo memomr, “Tisaye, ni nuwa afo waya.” ");
INSERT INTO amp_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Rom inji kfomotmr tfit Jisasr kfo memorm, “Nanhu yayuk yeshrim niko nhai tawisafkahkomm.” ");
INSERT INTO amp_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Disaiperm tum rinahti rinahtihato kfo memom, “Ka nom taunko tohetnomn wom yimam yeshrim hnahumr.” ");
INSERT INTO amp_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jisasr inji wanyaf hanyhato kfo memorm, “Nanhu yeshrim akfo nuhasanko. Nd na tkrurafmo yimarhu dukef yuhatn na be hikhato nd ror kfoyuk hingrnafat afo na hingrna bugakfot. Tot nanhu tu yeshrt. ");
INSERT INTO amp_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Wom mrokfot kfo kangko, ‘Kto husfihusyuk yamtpno ka mswirroh yeshrt bi yeshriyettn yakrahm.’ To tfit kfiwanko, mswir mswirroh yewurit afo wayukatohkomt bi finji yorhwam? Bi yak yibon nefrpayet bi. ");
INSERT INTO amp_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Nd yimar mswirroh yewurithu yak nhafoh htfasyukr dborioh marufat bi yekwarn, nd mswir mswirroh mtoh nkifraniyuk yewurit kak htfaswort. Ndnettn nd yimar yewuri nuhtayukr yo yewuri yak nhafoh htfasyukr rpat yindhorrahf. ");
INSERT INTO amp_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","38","Bi womm nuhta htamo yewuriroh yakneft kfo tkrur-afomoyanko. Bi wommn yikiat hta-motmt, niko be rroh yikiat htayuk yewuritn yihato fakmoko. Ndnettn nd mrokfot niko kfiwat, tu kfot kfiwuko. Womr yewuri fan nuhta hanyuker, tfit womrn mongko tohhato nd bi yak yibon hanyet yewuriroh yak nhafoh hnayuk yimayer.” ");
INSERT INTO amp_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Nd Samaria efkott taun yihato mkfo memohat, “Na nahnayuk tamoh tamoh nefm kfo hik bohik bugerm.” Inji mkfomohat, boknambok Samaria thofm wanyhato rroh bro dukefm Jisasr htamom. ");
INSERT INTO amp_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Jisasr nd mettpno napthamo bujrpno rhu hasetrn Samaria thofm yihato mkfo ttiwon-momr rompno afo toh tanyneft. Inji mkfomotmr afo hus marf tohnho tanymorm. ");
INSERT INTO amp_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Nd ror tohmo yihaf tohhato kfo pthayuk mrokfom hifa wanymomm. Ndnetmn bok met yindarim wany yakiohato hikmomt rorhu mrokfot. ");
INSERT INTO amp_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Nd Jisasrhu mrokfom wany yakiohato hikmo yimam yihato nd mett mkfo memomt, “Ni mirahn ka nd ni kfoyuk mrokfo-rpatpno riwanyakhato ka nmoh bro dukefm rorn htewunom. Nhai. Nom tunmoh nyingaye yo yimbhindange hifa wanukwanomn ndnatn kangnom ror tu ndar bbinysofthu met yindari-roh nrfa htiyakyuk yimayer.” ");
INSERT INTO amp_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Jisasr hus marf Samariat toh tanyhato tfit Galili profinsko yimorko. ");
INSERT INTO amp_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Bingot tu Jisasr bi kfo memor, “Bro Nkifrarhu profetrhu yufat bi kmi kmim rhu htfaswot. Turhu kmiti turhu kuny shofm, rompno nhai yufapa duhater.” ");
INSERT INTO amp_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Jisasr Galili profins yimohat, yindhorakmomr. Nd Jerusalemr rhumo bro Pasofa burwa yihar rom tum yimomn nd Jisasr hingrnamo mirakerkfom turoh nyingaye htimomm. Ndnatn tfit Jisasr Galiliko yimohat yindhormomt rorhu yi nmbuhat. ");
INSERT INTO amp_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jisasr Galili profins yihany yi hanyhato bupa mifm tfit wain bupam yak kekutmo kmi Kanat mfnahmor. Nd yihar kingrhu ofisarhu yonr taun Kaperneamko dbohnetr rhumor. ");
INSERT INTO amp_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nd ofisar wany memohat Jisasr bi Judiako htanyhato Galiliko nier, nd ofisar yimorn Jisasr mkfo ttiwonmorr Kaperneamko yihato rorhu yonrhu yak marnyaneft. Rorhu yonr bi nohyuk tkitt rhumor. ");
INSERT INTO amp_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Inji kfo pthamotrr tfit Jisasr kfo memorr, “Niko mirakerkfom hti duha, nhai nann nikmoh bro dukefm htakahkma.” ");
INSERT INTO amp_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Kingrhu ofisar kfo memorr, “Broye, bmbri wania. Nanhu yonr nohhirahra.” ");
INSERT INTO amp_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jisasr nd ofisarhu mrokfot wanyhato kfo kangrr, “Wanju, ninhu yonr nhai nohruhatr.” Be wom ofisar nd Jisasr kfoyuk tngt wany yakiohato yimor. ");
INSERT INTO amp_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nd ofisar yihotat yi hanyhato tafi taun Kaperneamt mfnah duha turhu hingrna yimam toni hnehato yihotatn mkfohiyak memomr, “O, ninhu yonr tor yima nfriyer. Nhai nohrror.” ");
INSERT INTO amp_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Rom inji mkfohiyakmotmr tfit ror ttiwon kangrm, “To fitoh yiharn nd dbohneft thu trohrotr?” Tfit rom kfo memomr, “Yihofnano 1-kilok krif marr dbohneft thu troh tanyrotr.” ");
INSERT INTO amp_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Be yifemr inji wanymohat tfit duka memor, “Dajohmn, na Jisasr to ndhtet yiharn kfo mariora, ‘Ninhu yonr nhai nohruhatr.’” Be nd ofisar ndt htihato rori yo nd rorhu rpa kuny shofm Jisasrn rroh bro dukefm rihtakmom. ");
INSERT INTO amp_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Tot ndt husyuk mirakerkfot Jisasr Judiat toh tany tfit Galiliko yihato hingrnamot. ");
INSERT INTO amp_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Tfit kto Judaroh wom bro lotu yiharhu yemro burwat Jerusalemr htamotmt, Jisasr Jerusalemko yimor. ");
INSERT INTO amp_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Nd Jerusalemrhu wom bro kmi yifhatikt kutewumt Sifsifroh Yifhatikt, to brbo nd kmi yifhatiktpno hingrna-momr wom bro yuk bfar. Hibru yarmumat kutewumr Betesda. Nd yuk bfarhu manoh manoh thmbmn yimaroh rhu mskayuk tirfa kuny nafom hingrna habrimomm. ");
INSERT INTO amp_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Nd kuny nafomn rhu hasomoum dbohna yimam, nyinga kunyjetm, wura bebetm, yo wura noh minysafetm. ");
INSERT INTO amp_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ndha nd tkittn rhumor wom dbohnet yimar. Nd yimar 38 gunyjimm rorhu dbohneft hatohmort. ");
INSERT INTO amp_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jisasr yau hanyhato nd yimar hwe kkor hasetr mhtimorr. Nd dbohneft htimorr bi rihatohngotakmor. Inji htihato kfo ttiwon memorr, “Nine tu waduka. Kangn nd dbohneft athu trohta?” ");
INSERT INTO amp_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Jisasr inji kfomotrr tfit nd dbohna yimar kfo kangr, “Bro yimaye, nda tek bupam hamuh dbrufwohat to fitoh yimarn yaknihato wahtewotra bt nd dbohneft thu trohkahta? Buparoh hamuh wohnepam htihato kanga tukann yudbat aikahann amitohniya, wommn bi dimandinihato mitohnitatm dbohnefm thu trohwomm.” ");
INSERT INTO amp_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Inji kfomotr Jisasr kfo memorr, “Wasinya! Wasinyakahnn yitwat wayakkahnt wayauwakni.” ");
INSERT INTO amp_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Be yudbat nd yimar marnyanimor, nndo memom ka kparn watuyekwor. Be nd tur hwe hasoyuk yitwat miyak riraknihato fauyaknimor. Sabat yiharn ndhtet neft rhumot. ");
INSERT INTO amp_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ndnettn Judaroh bro yimam inji htiyakmohat kfo memomr, “Bare, tamohmpno nda bro Sabat yiharn nd yitwat yihom hauyak mhauyekwant? Boririfhut kfo kangt, ‘Mirahn Sabat yiharn yitwat yihom hauyak mhauyakant.’” ");
INSERT INTO amp_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Tfit ror sinyahato kfo memor, “Nd na yak marnyafoyuk yimar kfo famura, ‘Wasinyakahnn yitwat wayaknikahnt wayauwakni.’” ");
INSERT INTO amp_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Tfit kfo ttiwon memomr, “To frohrn kfo yamurn, ‘Yitwat wayaknikahnt wayauwakni?’” ");
INSERT INTO amp_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","To nd wura noh minysafet yimar nhai hti hik marnyaf-rmorr nd ror yak marnya tanyuk yimar. Yonmar yima rifinyrn Jisasr nd yimar yak marnya tanymohat to be nd yima rifiny buharn tayinyarnihato frtkunimor. ");
INSERT INTO amp_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kto Jisasr Bro Nkifrarhu temper kmifar rim fnahnihato nd yimar yiro temper kmifar toh hasetrn rim htimorr. Rim htihato kfo memorr, “Wahti. Ni bi tu yimaye. Nd ni hatohmo yonmari dbohneft be bi thu troh tanymotn. Arihat mirahn tfit wom tamoh nefm arim naya. Tfit finji rim narahn, to be nd yiha be tu bro krhopam yakrahn.” ");
INSERT INTO amp_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Be nd yimar ror yak marnyamo yimar hti hikhato Judaroh bro yimampno yihato kfo nuhas memorm, “Nd na yak marnyamo yimare, Jisaser.” ");
INSERT INTO amp_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Be nd Judaroh bro yimam inji wany hikak marnyahato Jisasr rihti dbnotakhato riptha namburak memom, “To nd yima Jisasre frohm kfo memomr, Sabat yiha ndhtet hingrnefm wah-ingrnatwa?” ");
INSERT INTO amp_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jisasr nd rroh kfo hutt mrokfom wanyhato kfo memorm, “Nanhu Yifemr nhai rhu witakahr hingrnaneft. Na to nd yuhatn na nhai rhu witakfot hingrnaneft.” ");
INSERT INTO amp_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Be nd ror kfomo tngrpno Judaroh bro yimaroh yima yuhum kahm kindo wakur sinyahato kfo memom, “Nome ndar yimar finji anakahtnomr anohr. Sabat yiham nhai mikahr nd yihar be wom tamoh nefm finji na duha. Yo nhai be nd nefrpat nakahr, Bro Nkifrar kangrr rorhu Yifemer. Kangr Bro Yifemr kanjo aruha, nd dukeftn nd nefm newurm.” ");
INSERT INTO amp_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Jisasr nd Judaroh bro yimam kfomo mrokfot wanyhato tfit ror kfo memorm, “Na kfo mifwanko, Yonr turhu Yifemrhu hingrnefm hingrnewur. Nhai be turhu yima yuhurn o dukefrn tamoh hingrnefm hingrnakahrm. Nhai. Ror turhu Yifemr hingrnayuk hingrnef yuham hti hikakhato hingrna hik hanitr. ");
INSERT INTO amp_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nd Yonr be Yifemrhu mondt yihom furwarn nd ror niwa nefm yak nuhaswatrr newurm. To mirahko ka be nd nefrpam htirahnom. Nhai. Tu bro bro nefm yak nuhasruhatrr tfit rorn nd nefm nikompno naruhatrm nikom tfit hti kshrfahato kfo mirahko, ‘Mamai! Ndart tamohtet nefet?’ Mfham danyr yohtnehrahm. ");
INSERT INTO amp_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ndt nhai be kfo nhehkfoyet. Bro Yifemr noheh yimam yak kasinyahato yima tkonham kafkni yahuka kanjo, to be nd yuhatn yinem Yonr turhu hti fijo yimam tkonham kafkni yahukrm. ");
INSERT INTO amp_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Yo nhai tfit Bro Yifemrn kotkfot yakitohruhatrt. Nhai. Nd hingrneft bi Yonrhu tirtn htamort. ");
INSERT INTO amp_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","To be ndnatn nda bbinysofthu yimam be yinem Yonrhu yufat yuta hagrharahm Bro Yifemrhu yufat wuyuta hagrha hakutwa kanjo. Fitoh yimam nhai yinem Yonrhu yufat yuta hagrhakahm, nd yimam nhai nd yonr kfo tkruryuk Yifemr kfo hagrhakahm. ");
INSERT INTO amp_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Na kfo mifwanko, fitoh yimam na kfo tkrurafyuk Yifemrn rroh dukefm rhuhato nanhu mrokfom hikwom, toh nkifranirahm. Nhai nd kotkfot tohruhatm. Be mrokfo duhatm rhurahm. Nd hel yita yihotat bi htanyhato Bro Nkifrar htayuk dfa tikr bi rim tohnihato hefenrhu yihotat kau hanitwom. ");
INSERT INTO amp_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Na kfo mifwanko, yihar niayukr to bi asor bi niaror. Nd hel yi hanita met yindarim yinem Yonrhu tngt wanyrahm. Wanyakhato Bro Nkifrarhu yihotat toh hanyrahm. ");
INSERT INTO amp_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Yimaroh rhu tohefr tu Yifemrn kakitohworr. Nhai wom yima furam yakitohkahmr. Yifemr yakitoh hasohato tfit tu Yinemrhu tirtn yimaroh rhu tohefr fak htamorr. ");
INSERT INTO amp_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Yo kotkfothu yakitohneft bi tu Yinemr, nmoh Bro Najomr, turhu tirtn fak htamort. ");
INSERT INTO amp_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mirahko nd na kfiwa mrokfompno mfha tha duhatnom arhunom. Yihat nieraht, noheh yima bugam yopm toh hanyukm tfit Yonrhu naku tngt wanyhato ");
INSERT INTO amp_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","tfit sinya hanyrahm. Fitoh yimam toh marnyem nd yimam tfit sinya thombat, be mrokfo duhatm rhuruhamn dborioh rhu nmbuhat yakhato toh nkifranirahm. Fitoh yimam fasoh nefm nayetem, nd yimam sinya thombat, be kotkfot tohniruhamn rroh toh nmbuhat, fasoh toh nmbuhat yakrahm.” ");
INSERT INTO amp_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Jisasr tfit kfo memorm, “Na nhai wom hingrneft be nanhu yima yuhurpar wakfakhato hingrnakfot. Nhai. Na tukianhu Yifemr kfo htafmo mrokfo yuhatn hikwoyann met yindarim nayuk tamoh tamoh nefm htihato kak hta bohtahukanm. Ndnatn na yimaroh nefm yak hta bohtiwohat na tuka kfo tkrurafmo Bro Yifemrhu mrokfo yuham hikhato kak hta bohta marnyahukanm. Nhai nndo mando riyohne ayohnekaha. ");
INSERT INTO amp_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Be na tukiann, na tukanhu toheft aptha srhant, be nhai nanhu mrokfom wany fugharfotkomm. Nhai. ");
INSERT INTO amp_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","To tor womr riyorhwor. Rorn nanhu yufat kfo ptha yimbu hikwort. ");
INSERT INTO amp_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","34","Yo Jon Baftaisr tu nanhu rhu toh nmbuhat kfo ptha yimbu hikmort. Ndnettn nikmoh wom yimam Jon Baftaisrpno yihato rorhu kfoyuk mrokfom wanyakmomm. Nanhu dukeft duka kanga, nd mwanyakyuk mrokfom hikrahkomm, Bro Nkifrar nrfa htiyakrahrko. To na nhai duka mekoha, ‘Tfit wom yimarn buha tohhato nanhu rhu toh nmbuhat rorn yimampno kfo ptharuhatrt yimam wanyhato hikrahma.’ Nhai. ");
INSERT INTO amp_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jonr kshr kindo niahato fakitohmorr. Ror nd yakitohmo kshrhu nukeftpno afo myindhor tefinimoko. ");
INSERT INTO amp_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Yima Jonr niahato kfo pthamo mrokfom rom tu nanhu rhu toh nmbuhathu mrokfom kfo pthamor. To nd Yifemr na hemo hingrnefm na hingrniwam, tom nd hingrnefmn yimam kak nuhaswomm na Bro Yifemr kfo tkrurafmo yuhathu tu hingrnefm. Nd hingrnefmn yimam htihato kfo kangm, tom tu Bro Yifemrhu hingrnefm. ");
INSERT INTO amp_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Na Yifemr tkrurafmotra nda bbinysoft niamoya. Turn nanhu rhu toh nmbuhat kfo ptha nuhasmor. To rorhu tngt nhai nikmoh yimbhindange wanyrmokomt yo nhai rorhu nyingatikt nikmoh nyingaye htirmokomt. Nhai. ");
INSERT INTO amp_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Na nd Bro Yifemr kfo tkruryuk yimaya, to na nhai hikkahkma, ndnettn nhai rorhu mrokfom yakitohkahkomm. ");
INSERT INTO amp_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Nikmoh dukeft duka kangko, ‘Bro Nkifrarhu mrokfomn tu toh nkifraniyuk dborioh rhu nmbuhat yak htarahmnom.’ Ndnettn nd mrokfom htitakomn kak nhta bonhtewukomm. To nd mrokfom to nann kfo hik bohikwom. ");
INSERT INTO amp_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","To niko nhai wany yakiohato na hikkahko. Ahikko to hifa rhu nmbuhat herfoyanko. ");
INSERT INTO amp_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Na nhai mikaha, mrokfom apthakahta yimam wany kafhurrahma. Nhai. ");
INSERT INTO amp_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Na hti hasiwanko nikmoh yuhuwaf marbim nhai Bro Nkifrar rhukahm. Nhai. ");
INSERT INTO amp_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Na niamohat, tu Bro Nkifrar tkrurafmotra fawihnamoya. To niko nhai marimoko, nd na kfoyuk mrokfot wuthu kmbriyakhato ayak hiknomt. Nhai. Be wom yima furar be turhu fijo niahato mrokfo kfo pthaneft niko be yudbat myoh brurnihato bmbri hikaknitkomt. ");
INSERT INTO amp_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Niko ndhtet met yindariko be tu nhai mif yak hikruhatkomt nanhu mrokfot, nhai mif. To nikmoh bro dukefm be kangko, ‘Be tunom nayuta yindhorhato bro yufat ayak hasonom.’ Nhai wofnkahko Bro Nkifrarpar yahuka bro yufat. ");
INSERT INTO amp_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","To niko mirahko ka nann kotimruhanko Bro Nkifrarhu nyinga-tikhato. Nhai. Nd niko kotimyuk yimar tor riyorhwor. Mosesrn kotimrahrko. Niko kangko, ‘Nda Mosesrhu mrokfotn hifa tkitt htarahtnom.’ To nd mrokfotn tfit toh kekuthato kotimrahtko. ");
INSERT INTO amp_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nd Mosesr wandfamo mrokfom to nanhu rhu toh nmbuhat wandfa hikmor. Ndnettn kanga niko Mosesrhu mrokfot yakhato ahikko, nann hikrfoko. To nhai. ");
INSERT INTO amp_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Na bi htitanko nd Mosesr wandfayuk mrokfot nhai yak hik marnyakahkomt. Ndnatn to nanhu mrokfot nhai yak hikruhatkomt.” ");
INSERT INTO amp_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Tfit kto Jisasr tfit mmbrt yaknihato tek Galili barithu mkuko yimor. Nd tek barithu wom yufat kutewumt Taiberias. ");
INSERT INTO amp_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Boknabok met yindarim Jisasr hingrnamoa mirakerkfom htimoumm. Yimam tamohtet tamohtet dbohnefm hatohetm ror kfomour marnyanimoum. Ndnetmn yonmari rifuhetr yihom hikak mhikakmoumr. ");
INSERT INTO amp_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ndnetrn wom kmir muhhato turhu disaipermpno afo rhumom. ");
INSERT INTO amp_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Jisasr inji namohat nd Judaroh bro rhu krna yihar, kutewumr Pasofa burwar, nd yihar bi brboh hanyetrn turhu disaipermpno rhumor. ");
INSERT INTO amp_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jisasr memor, “Ayukatohafoya,” asha htiyakmorm yonmari rifuhetr. Be ror nd yonmari met yindari rifhur htiyakhato tfit Filifr ttiwon rhti memor, “Nda yonmari rifinyr niwarne, to yeshrim fitha wiknahato yahukanomm?” ");
INSERT INTO amp_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Nd ttiwon mrokfot Jisasr kfomot, be yuwi Filifrhu yima yuhurhu was tiwonneftn inji ttiwon rhtimor. Tu Jisasr ror tor rhumor rorhu yima yuhur nd yimaroh finji nayukr. ");
INSERT INTO amp_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Jisasr inji kfomotrr tfit wom Filifr kfo memorr, “Mirahnom 200 kina yak nhafohkahnomn 200 kinakfet bretpam ayaknom nda yonmari rifhur href finji yak nhtahukam?” ");
INSERT INTO amp_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Tfit tu Jisasrhu disaiper Andrur, Saimon Pitarhu habhir, ror warhuhato kfo memor, ");
INSERT INTO amp_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Asor wom yima damiagr kakitohwor bari plauapaye tonet 5-pela bretpami hus yira bjhenf. To kangnome nda yonmari yima rifinyre ka hifa kak nhombra twanhiwum nd 5-pela bretpenmi hus yira bjhenf?” ");
INSERT INTO amp_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jisasr sinyahato disaiperm kfo memorm, “Nd yimam wakfokahtkomm afo ndha nd kipr suhtn asibosi rmon hanym.” Be kfomotmm tuha kipr suhtn sibosi rmonmom. Nd yindarim nd rifinymom, 5,000 yindarim rifinymom. ");
INSERT INTO amp_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Be nd tuhan yindars sibosi rmonmotm Jisasr nd bret nuwat yakmortn Bro Nkifrar wukfo yindho-rakhato yak tif botif rmonmortn fak nhtahemorm. Yimam be turoh yak fijo fakmom. Yo nd yira bjhenf yak nhtahemohat, nhaf rpahtet neft namor. ");
INSERT INTO amp_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ye furkihmotm Jisasr turhu disaiperm kfo memorm, “Waikahkomn nd rroh yesmbhehm wayak nhafohkomm, rhu gbitnarahm.” ");
INSERT INTO amp_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Be nd turhu disaiperm sinyahato nd 5-pela bretparoh yesmbho hta hanyuk bretpam fak nhafoh bugamomm. Yak nhafohhato kpm hmbremohat 12-pela kpm hmbremomm nd yesmbhehm. ");
INSERT INTO amp_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Met yindarim nd Jisasr namo mirakerkfot htihato be tfit tum rinakfo nakfo memom, “Dajohmn, nd Bro Nkifrarhu rfa borngt kfo hnamo profetr ka asor bi niamor.” ");
INSERT INTO amp_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Nd rom nakfo pthamohat, Jisasr bi wanymormn ror duka memor, “Arm bi inji rinakfo pthekwamn tir tir yak rim htahato kfo mirahma, ‘Rorn nmoh kingr tohrahr.’” Jisasr nd dukefr yakmotrr nd tkitt htanymortn tfit turpetr yura kminysofko muhmor. ");
INSERT INTO amp_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Krifn disaiperm tfit tek bariko yimomwe. ");
INSERT INTO amp_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Yimomn mmbrt yaknihato memom, “Tek barit hir hayuknihato tfit Kaperneamko riyahnom.” Yifungta hanymot nhai bi Jisasr mifnahrmorm. ");
INSERT INTO amp_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Hir hanyetmn bro wifort sinyahato sikfot rpat sinyamot. ");
INSERT INTO amp_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nd wifortpno rihirhany rihirhany, ka bi 5 o 6 kilomita kanjo bi rihir hanyetmn ee Jisasr htiyak hanymomr yura tek yuhat yau hnehato brbo mmbrtpno fau yaknimor. Rom inji htiyakhato fakrmemom. ");
INSERT INTO amp_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Be bmbri tu Jisasr kfo kangrm, “Mirahko ayakrmenom. Na Jisasa niewa.” ");
INSERT INTO amp_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Be inji kfomotrm disaiperroh yima yuhum mirhuhato rroh mmbrtn tfit fak kmbremomr. Mikmbremotr be yudbat nd mmbrt rim fnahmot rom yiyuk tkittn. ");
INSERT INTO amp_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","23","To nd Jisasr kfo bruttnahato yeshrim yak nhtahemo tkitt toh hasomo yimam, tfit ndwom dbha marrn barit hirmo mmbrm htihato kfo memom, “To nom yihof Jisasr yeshrim herohat afo rpa mmbrrpat htironom. To nd mmbrt to bi disaiperrpam krif fakniromt. Jisasr nhai hikrrorm.” To ndha hirmo mmbrm Taiberiuskorhof mmbrm hirmoum. ");
INSERT INTO amp_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","To Jisasri rorhu disaiperm hti hambromohat, be tfit nd Taiberiasroh mmbrmn myaknihato Kaperneamko hir hikmomm. ");
INSERT INTO amp_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Kaperneamko rim htanihato Jisasr hambro hanyhato mhtimomr. Mhtihato kfo ttiwon memomr, “Tisaye, to nine asombha niarohate fitoh yiharn niaro?” ");
INSERT INTO amp_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Be rom inji ttiwon-motmr tfit Jisasr kfo memorm, “Na kfo mifwanko, niko na hambro hnewohat nhai be na nahniwa mirakerm htihato kfo mikahkma, ‘Dajohmn! Tu Bro Nkifrarhu Yon mifer.’ Nhai. Be nd bretpam yak yurhhato ye furkihmo yuhat htimokomn ndtpno tfit kak hambro htfaswokma. ");
INSERT INTO amp_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mirahko be yatiyeft yakyuk yeshrtn adukanom. Yiro yafothat yakyuk yeshrt dukakfot. Nd yafothathu yeshrt ye hmbrihato toh nkifranirahko. Nd yeshrt na Bro Najoma hiruhanko. Bi Bro Yifemr nd hingrneft bi fak htamora.” ");
INSERT INTO amp_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Jisasr inji kfomotrm tfit rom ttiwon memomr, “To nom finji nahato nd Bro Nkifrar kfoyuk hingrnefm yak hikruhanomm?” ");
INSERT INTO amp_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Rom inji kfomotmr tfit Jisasr kfo memorm, “Bro Nkifrarhu hingrnefthu hingrneft inji korht: Nikmoh bro dukefm nd tu Bro Nkifrar kfo tkrurafomo yimarn rhukfot.” ");
INSERT INTO amp_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Rom nd mrokfot wanyhato tfit Jisasr ttiwon memomr, “To ni finji kanjohtet mirakerkfot hingrnaruhatnt nom htiruhanomn kfo miruhanom, ‘Dajohmn! Tu Bro Nkifrarhu Yon mifer.’ To ni tamohtet hingrneft hingrnaruha? ");
INSERT INTO amp_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Nmoh nkifram nungur tik furat, kutewumt deset, nd tkitt hwe toh hnehato manakfot yakmohat, to rfa borngt kfo kangt, ‘Yura hefen yuhat yawihnayuk bretpam ndm hemotrm famom.’” ");
INSERT INTO amp_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Be rom inji kfomotmr tfit Jisasr kfo memorm, “Na kfo mifwanko, Mosesr nhai yura hefen yuhat yawihnayuk bretpam yakhato hermorko. Nhai. Nanhu Yifemrn kahukrko tu yura hefenkorhof bretpa mif mift. ");
INSERT INTO amp_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Nd bretpat Bro Nkifrar heyukt yura hefen yuhat wutoh tanyuket. Nd bretpat yayuk tuhant yindars be toh nkifranirahm.” ");
INSERT INTO amp_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Jisasr inji kfomotr tfit rom kfo memom, “Bro yimaye, nom kangnom, nd bretparpam yiha yiha wahi hanyswannom.” ");
INSERT INTO amp_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Rom inji kfomotm tfit Jisasr kfo memorm, “Na to nd toh nkifraniyuk yafothat heyuk bretpaya. Yimam nanpno nierahm be nhai tfit yatinohruhatm. Yo nann rroh bro dukefm rhurahm, be nhai tfit bupa knaruhatm.” ");
INSERT INTO amp_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Jisasr inji kfonihato tfit kfo memorm, “Mrokfot to bi kfiyanko. Niko na nahnayuk nefm ar bi htiyetko, to nhai nann nikmoh bro dukefm rhuhato hikkahkma. ");
INSERT INTO amp_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Yimam Bro Yifemr bi nann fahur nanpno nia tohrahm. Nhai kfo krmah o yak thu inji narhotanm. ");
INSERT INTO amp_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","To na hefenr wuhtanyhato yawihnamohat, nhai be tukianhu dukefthu hikneftn yawihna-armoya. Nhai. Memoya, ‘Bro Yifemrhu dukef yuhatn na be hikhato nd ror kfoyuk hingrnafat hingrnaruha.’ ");
INSERT INTO amp_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Na Bro Yifemr kfo tkrurafetann fitoh met yindarim bi tu Bro Yifemr nanhu tirtn bi hterm na nhai womr yak troh tanykfot wuroh ndar bbinysofthu bati yihar. Nhai. Nanhu tirt bi htetm yahot tathakni bugaruhanm. ");
INSERT INTO amp_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nanhu Yifemrhu yima yuhur inji duka kangr, nd dodh met yindari bugam Yonr yukatohhato ror yak hikwam, rom tu dborioh toh nmbuhat yakhato be toh nkifranikfot. Na tukann wuroh yihar nann yahot tathakniruhanm.” ");
INSERT INTO amp_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jisasr kfo memotr, “Na yura hefen yuhat yawihnayuk bretpaya,” nd mrokfotpno Judam wanyhato rroh yima yuhum nhai marnyarmomm. Kfo hutt memom, ");
INSERT INTO amp_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","“Nd yimar nom tawi-safwonomr. Josefrhu yinem Jisaser. Rorhu yifammaf nom tawisafwonomf. To tfit tamohmpno kfo yamukar, ‘Na hefen yuhat fawihnamoya?’” ");
INSERT INTO amp_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jisasr kfo memorm, “Be tmifko tukmoh rim pthata mpthataneft. ");
INSERT INTO amp_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Na tu Bro Yifemr kfo tkrurafmotra fawihnamoya. Nhai wom yimar be turparhu duka fijo wayibon sinyahato nanpno niakfot. Tu Bro Yifemrn nd yimar thu yuhurworre ee btn nanpno niakfot. Kto wuroh yihar nd yimar yahot tathakniruhanr. ");
INSERT INTO amp_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Profetm wandfamo mrokfot kfo memom, ‘Tu Bro Nkifrarn mrokfom hirahrm.’ Yimam nd ror hayuk mrokfom wanyhato dukefm yekwam nanpno niewum. ");
INSERT INTO amp_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nhai wom yimar Bro Yifemr htirmorr. Nhai. Nd tu Bro Nkifrarpno toh tany niayuk yimarparn Bro Yifemr htimorr. ");
INSERT INTO amp_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Na kfo mifwanko, yimar rorhu bro dukefm nann rhuhato nanhu mrokfom wany yakiohato yak hikwar, tor nd yimarpar dborioh toh nmbuhat yakhato toh nkifranirahr. ");
INSERT INTO amp_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Na nd toh nkifraniyuk yafothat heyuk bretpaya. ");
INSERT INTO amp_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nd nikmoh nkifram nd nungur tik furat yutewa deset, ndko hwe sohhnahato manat yi hnamo yimam be bi noh witamom. ");
INSERT INTO amp_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nd bretpat yura hefen yuhat yawihnayukt ndt womhtet bretpayet. Yimam nd bretpat yanyeft to be nhai tfit nohruhatm. ");
INSERT INTO amp_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Na to nd yura hefen yuhat yawihnamo toh nkifraniyuk yafothat heyuk bretpaya. Yima nd bretpat yak ye hmbrirahn to be toh nkifranirahn. Nd bretpat na yakhiruhat to tukanhu yima nmpayem. Ndar bbinysofthu met yindariroh rhu nmbuhat dukahato suh nanyorruha.” ");
INSERT INTO amp_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jisasr inji kfomotr, Judam wanyhato tum rinakfo nakfo memom, “Bar yimako, tone nda yimare finji turhu nmhapam yakhato hiruhatrnom yeruhanomm?” ");
INSERT INTO amp_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Rom inji kfomotm tfit Jisasr kfo memorm, “Na kfo mifwanko, nhai Bro Najomanhu nmhapami yo nanhu kkupam yak yarfokomm be nhai dborioh rhu nmbuhat yakruhatko. ");
INSERT INTO amp_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Yimar o mett nanhu nmhapami kkupam kekwomm nd yimam be toh nkifranitm. Kto wuroh yihar yahot tathakniruhanm. ");
INSERT INTO amp_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nanhu nmhapam tom tu yeyuk yemrot yo kkupam tom tu yeyuk bupam, ndnetann inji kfiwanko. ");
INSERT INTO amp_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Yimar nanhu nmpami nanhu kkupam yewar, bi ke hmbriye-kwora. Ror bi nann thu nhombrewur yo na bi rorn thu nhombrewa. ");
INSERT INTO amp_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Na tu toh nkifraniyuk yafothat heyuk Yifemr kfo tkrurafmotra fawihnamoya. Na to nd Bro Yifemr nanhu rhu toh nmbuhat yakitohwatrt tohwa. Nanhu toh nmbuhat inji ruhettn, ndnettn yimar nanhu nmpam yaneft to be rorhu rhu toh nmbuhat yakitohrhotant tohrahr. ");
INSERT INTO amp_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Tot tu bretpa mift yura hefen yuhat yawihnamot. To mirahko ka nikmoh nkifram yamo kanjohot bretpayet. Nhai. Rom yamo bretpat nhai ndt yehato toh nkifranirmom. To nd ariharhof bretpat yimam yakhato yanyeft be inji toh nkifranirahm.” ");
INSERT INTO amp_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jisasr Kaperneam taunthu rhu rifinyuk Judaroh rmont rhuhato nd mrokfom kfo ptha nuhasmorm. ");
INSERT INTO amp_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Bok disaiperm Jisasr kfoyuk mrokfom mwany frnatahato kfo memom, “Jisasr mrokfom inji kfo pthaneft to frohm wanyhato hikruham?” ");
INSERT INTO amp_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jisasr bi htimorm rom inji kfo pthamoahat. Inji htihato kfo ttiwon memorm, “Ka nd na kfoyuk mrokfot wanyhato mfrnahirtewuko? ");
INSERT INTO amp_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","To kto Bro Najomr mikahtr, nd tur toh tanymo kmikor muhwa, to niko htiyaf hany thombat to finji? ");
INSERT INTO amp_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Bro Nkifrarhu Yafothatn kahuktnom tu toh nkifraniyuk yafothat, nhai yima mifmn. Nd na kfoyuk mrokfot, ndt tu yafothet mrokfoyet. Nd mrokfotn kahuktm yimam toh nkifraniyuk yafothat. ");
INSERT INTO amp_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","To tom nikmoh womm nhai wany yakiokahmt nda na pthiwa mrokfot.” Bingotn Jisasr bi htimorm fitoh yimamn nhai wany yakioruhatmr. Yo bi htimorr fitoh yimar hndhnarahrr. ");
INSERT INTO amp_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ndnatn Jisasr wom mrokfot kfo memorm, “Yimam nhai wany yakiokahm. Nd yuhatn niko bi kfo kanganko, nhai wom yimar be turparhu duka fijo wayibon sinyahato nanpno niakfot. Tu Bro Yifemrn nd yimar thu yuhurworre ee btn nanpno niakfot.” ");
INSERT INTO amp_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Be nd yiharpno Jisasr nd mrokfot inji kfomotrt bok disaiperm frtrohmomr. Nhai tfit uhik ahikrmoamr. ");
INSERT INTO amp_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Be Jisasr inji htiyaf hanyhato nd turhu 12-pela disaiperm ttiwon memorm, “To nikone, rpat htany bugarahkma?” ");
INSERT INTO amp_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Tfit Saimon Pitar warhuhato kfo memorr, “Broye, nom ni htanyruhanomn to wom frohrpno rim tohruhanom? To ninrpanhu mrokforpat harhuwott tu toh marnya hatohyuk yuhat. ");
INSERT INTO amp_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nom ninn nmoh yima yuhum htahato duka kangnom, ni tu Bro Nkifrar yak htamo yimaye.” ");
INSERT INTO amp_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ror inji kfomotrr tfit Jisasr kfo memorm, “Rot nann niko 12-pela disaiperko fakmoyanko. To ror tor nikmoh womr. Rorn Satanrhu hingrneft hingrnayuk yimayer.” ");
INSERT INTO amp_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Nd ror kfomo yimar to Saimon Iskariotrhu yinem Judasrn kfomor. Nd Judasr to nd 12-yuk wom disaiper yimayer. To rorn kto frfnahnihato tfit Jisasr hndhnamotrr yahr kmim yihato wasmomr. ");
INSERT INTO amp_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Jisasr nd mirakerm Galili thofm yak nuhasnimohat, afo tuha Galili distriktn afo fau habrimor. Judiako bi yinyeft nhai. Judiakorhof bro tohak yimam bi rorhu wasnefthu wajis bi haruhetmn to be Jisasr nhai bi marimor, “Judiako bi yiruha.” ");
INSERT INTO amp_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Judaroh briaha kuny nafo mkuroh rhuhato ye burwa yiham bi brbo rhu hnetmn, ");
INSERT INTO amp_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jisasrhu wom habhim kfo memomr, “Nom kangnom ni nda kmit wahtanykahnn tu Judiako waiswa. Tu Judiako waikahnn nd ni hingrniwa womhtet womhtet miraker hingrnefm wahingrnakahtnm tunhu disaiperm afo htirahmm nd hingrnefm. ");
INSERT INTO amp_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Wom yimar kangr, ror niwa nefm yimam ahtimm, ror nhai be hingrna kafroh-kahrm. To ni kangn, mirakerm ahingrnayanm, tafontn met yindariroh nyingatikhato wahingrnakahtnm ahtimm.” ");
INSERT INTO amp_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","To tu Jisasrhu habhim nhai rroh bro dukefm Jisasrn rhurmom. ");
INSERT INTO amp_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Be rom inji kfomotmr, tfit Jisasr kfo memorm, “Nanhu tu yi yihar tafi afo bi niakahr. Niko fitoh yuha fitoh yuha yinyefm niko tuko yakitohwakommn yiham, niko tuko yi furaknitko. ");
INSERT INTO amp_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Niko nda bbinysof thofm nhai be mfro hti srkahmko. Na be rroh gobenann be fndr htitwoma. Kangm, ‘Tamohmpno kfo ptha nriyafwarm nom niwa fasoh fasoh nefm?’ ");
INSERT INTO amp_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Nd niko Jerusalemr yihato Judaroh kuny nafo mkuroh rhuhato lotuneft yi shombat, na nhai hik hanyrhotanko. Nanhu yi yihar nhai bi niakahr. Tuko waiswako.” ");
INSERT INTO amp_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Inji kfaf nuhasafhato ror tuha Galilitn toh gari hasomorm. ");
INSERT INTO amp_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ror wom habhim afo htiya-fmormn bi kitwome, ee ror kto mongkor yimor. Nhai yimam htiyafrmomr ror sinyanimohat. ");
INSERT INTO amp_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Nd Judaroh kuny nafo mkuroh lotu yiharn Judaroh bro yimam Jisasr yukatoh hasotihato kfo ttiwon hambro memoum, “Bar yimako, nd yima Jisasre to fitor? Nhai niarfor?” ");
INSERT INTO amp_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Tuha met yindars be nhowi brumhamn nakfo nuhas nakfo nuhas memoum, “Ndr tu dborioh yimayer.” Tfit wommn kfo memoum, “Nheno, ndr yima frnhehet yimayer.” ");
INSERT INTO amp_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Met yindarim Jisasrhu mrokfom kfo pthamoahat, Judaroh bro tohak yimam yanhohato, nhai be masat tafontn kfo ptha nriyaf inji narmoam. ");
INSERT INTO amp_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Nd Judam turoh bro yiham rhu haso hanymom Jisasr yiro Bro Nkifrarhu temper kmifar rim fknenihato met yindarim mrokfom hemourm. ");
INSERT INTO amp_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Judaroh bro tohak yimam Jisasr kfomo mrokfom wanymohat tuha mrokfo duha rhumomn tfit afo Jisasr yukatohhato hifa mmbra memom, “Ndhtet skurr yi juha yimar to finji kanjo ndhtet duka tungunefm yekwarm?” ");
INSERT INTO amp_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jisasr tawo kfo memorm, “Nda mrokfom, na nd kfiwam, niko mirahko ka be tukanhu yima yuhuruhem. Nhai. Nd na kfo tkrurafyuk Bro Nkifrarhu mrokfom kfo ptha nuhaswanko. ");
INSERT INTO amp_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Wom yimar kangr, ‘Be tu Bro Nkifrarhu dukef yuhat ahik mifa,’ nd yimarn yakrahrt nda na kfo pthiwa mrokfothu mna yuhat. Rorn yak nhtarahrt nda na kfiwa mrokfot tu Bro Nkifrarhu mrokfot kfiwan o tukanhu dukefrn niewatm pthiwanm. ");
INSERT INTO amp_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Yimar be turhu yima yuhurn mrokfom wakfo pthakneft, nd yimar kangr be yuwi yimam akfo kafhurma. To yimar nd tur kfo tkrurafyuk yimarhu yufat kfo kafhurwort, nd yimar tu dborioh yimayer. Nhai yimam frnhehkahrm. ");
INSERT INTO amp_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Bingot Mosesr hemo boririfhu mrokfom, to nhai nikmoh wom rpar myakni marnyakahrt nd boririfhu mrokfot. To tamohmpno tfit nann kfo yamukako, ‘Ror nhai hikkahr nkifra boririfhut.’ Nd nambur yima yuhumpno nanhu waskfot kfiwuko?” ");
INSERT INTO amp_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ror inji kfomotr, tfit met yindarim sinyahato kfo memomr, “To frohm waskfot kfiwamn? Nine ka womhtet kmi yarhr mthu nawohtrn inji kfo mumiwun.” ");
INSERT INTO amp_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Rom inji kfomotm tfit Jisasr kfo memorm, “Na Sabat yiha wom mirakerkfot hingrnamotant, niko to htihato tuha yafotha duhatko rhumoko. ");
INSERT INTO amp_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","To niko Mosesrhu nkifra boririfhu mrokfot nkifra tha pukneft yak hikwakomn womnam Sabat yihamn yonroh tham puk-wokomm. Nd tha pukneft nhai be Mosesrn buha wahtakrmort nd hingrneft. Nhai. Bingot bi nikmoh nkiframpno rihingrnakmomt nd hingrneft. ");
INSERT INTO amp_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nikmoh nkifra tha puk yuhat Mosesr kfomot nhai yafhokah-komt. Yonr nurnineft 8-yuk marrn tha pukwokomm. To Sabat yiharn nd yonrhu tha puk yihar rhuneft nhai mekahko, ‘Afo Sabat yihar rhunihato tfit ndwom yiha tha pukrahnomr.’ Nhai inji nakahko. Nd Sabat yiharn tha pukwokomr. To tfit tamohmpno na Sabat yiha wom yimar yak marnya-motanr niko kfo namburwako? ");
INSERT INTO amp_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mirahko be nyingaye htiyuk tamoh tamoh nefm htihato bmbri mrokfom tubatu furakninomm. Afo hti nhta yak nhta marnyahato ee btn mrokfom tukfot.” ");
INSERT INTO amp_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jerusalemrhu wom met yindarim nd Jisasr pthamo mrokfom wanyhato kfo memom, “Ka nda yimarn Judaroh bro tohak yimam kangm awasnom? ");
INSERT INTO amp_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","To nd yimar to asor nda yonmari yima rifiny buhar pthiwohat, to nhai wom rpa yimar kfo wokkahrr. Nhai. Ka ror pthiwohat, ka rorhu mrokfom wany nhtiwamn ka duka kangm asor met yindariroh minrfa htiyakyuk yimar Bro Nkifrar htangotmor. Ka inji dukewamn nhai kfo wokkahmr?” ");
INSERT INTO amp_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","To tfit wommn kfo memom, “Nd niko kfiwa tngr hifa. Tmift nd niayuk yima Kraisr nhai wom yimar tawisafruhatrt rorhu trha yuhat. To nda nom kfo pthiwa yimar ror nom tawisafwonomt rorhu nia yuhat.” ");
INSERT INTO amp_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jisasr Bro Nkifrarhu temper kmifar tohhato met yindarim kfo yahrnya memorm, “Niko ka duka kangko ka tawisafwokma yo nanhu trha yuhat ka tawisafwokomt? Nanhu nia nmbuhat, nhai na be tukanhu fijo niarmoya. Tu Yifem mifr kfo tkrurmotra niamoya. Niko nhai tawisafkahkomr. ");
INSERT INTO amp_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Na, na tawisafwanr. Na rorpno toh tanymoya. Rorn kfo tkrurmotra niamoya.” ");
INSERT INTO amp_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Inji kfomotr rom wanyhato memom, “Ayaknomr.” To nhai. Tafi rorhu yak yihar bi niarmor, to be nhai wom yimar bi yakaknirmorr. Nhai. ");
INSERT INTO amp_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Bok met yindarim rroh bro dukefm Jisasrn yihato kfo memom, “Ka asor nd yimar met yindariroh minrfa hbhakyuk yimar Bro Nkifrar kfo tkrurafmor. Ka rorn nd Kraisr hingrnayuk mirakerkfom mfro hingrnewur.” ");
INSERT INTO amp_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Yimam nd Jisasrhu hingrnefroh mrokfom nhowi nakfo nuhas nakfo nuhasmoatm, Farisim wanymom. Wanyhato memom, “Jisasr myakhato kalabus htarahnomr.” Ndnettn romi prisroh bro yimam yihato Bro Nkifrarhu temperrhu tohukatohyuk polism kfo tkrurafmotm rom yimom. ");
INSERT INTO amp_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jisasr kfo memor, “Na be inji dfik yiham tohnho tanyrhoyanko tfit yiruha tukia kfo tkrurafyuk Yifemrhu kmiko. ");
INSERT INTO amp_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","To nd yiha yak hambro hasorahkma, to nhai htirhotkma. Nd na yiruha kmit niko nhai yiruhatkomt.” ");
INSERT INTO amp_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Be Judam inji wanyhato tum rinakfo nakfo memom, “Bar yimako, fitohko yiruhatr nom hti hambro hasoruhanom? Ka ndu nmoh wom yimatm kantri Grikko tohyukmpno yihato ndkorhof yimam mrokfom hirahr? ");
INSERT INTO amp_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Yo kfo kangrnom, ‘Yak hambro yak hambrorahkma, to nhai htirhotkma.’ Yo tfit wom kfot kfo kangrnom, ‘Na yiruha kmit niko nhai yiruhatkomt.’ Tone finji dukahato inji kfiwarnom?” ");
INSERT INTO amp_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Nd lotu burwa yiharoh wuroh tikofhna yihar ndr tu bro yihar rhumoumr. To nd wuroh bro yihar rhumorn Jisasr wasinyahato kfo yahrnya memor, “Ni fitoh yima nyunguram knewun, nanpno waniekahtn, bupam hiruhann. ");
INSERT INTO amp_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Mrokfot Bro Nkifrarhu rfa borngt yorhwat to inji kfo kangt, yimar nanhu mrokfom wany yakiohato hikwar, rorhuko tu yafothet bu yinhar bupam be mfrfnah hasorahm.” ");
INSERT INTO amp_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Nd Jisasr kfomot, ndt yimam rorhu mrokfom wany yakiohato yakruha Bro Nkifrarhu Yafothat, ndtn kfomor. Nd yiham Jisasr tafi nohhato sinya duhatrn ndnettn Bro Nkifrarhu Yafothat nhai bi yimam hermorm. ");
INSERT INTO amp_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Wom met yindarim Jisasr kfoyuk mrokfom wany nhtahato kfo memom, “Dajohmn, ka asor nd profetr Bro Nkifrar kfo tkrurkfot kfomor.” ");
INSERT INTO amp_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Womm warhuhato kfo memom, “To tawom ndr. To nd yimar Bro Nkifrar kfo memo, yimaroh minrfa htiyakyuk yima Kraisr nierahr.” Tfit womm warhuhato kfo memom, “Nheno. Ror arhur to nhai Galili yuhat niarmotr. ");
INSERT INTO amp_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Bro Nkifrarhu rfa borngt bi kfo hta memot, ‘Kraisr nianeft tu Defit frikef yuhatn nieruharn Defitrhu taun Betlehemtn minurrahr.’” ");
INSERT INTO amp_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Be ndtpno rinakfo nakfakhato nafak mkumom. ");
INSERT INTO amp_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Womm wasinya fnahhato memom, Jisasr ayaknom, to nhai, nhai womr tir htarmorr. ");
INSERT INTO amp_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Nd temperr tohukatohyuk polism tfit yimotm prisroh bro yimami Farisim kfo ttiwonak memomm, “To tamohmpno nhai yakna duha yirfokomr nd yimar?” ");
INSERT INTO amp_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Inji kfo ttiwonakmotmm tfit kfo memomm, “Nhai wom yimar ror pthiwa kanjohot mrokfom kfo pthakahrm. Nhai.” ");
INSERT INTO amp_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Tfit Farisim kfo wok memomm, “Ka kfo nheh bonhehmorko? ");
INSERT INTO amp_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","To htitkmnom nom Farisinomi Judaroh bro tohak yimam wany yakiowonomr nd yimar? Nhai mif. ");
INSERT INTO amp_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Yimam rorhu mrokfom wany yakiohato hikwam, nd yimam boririfhut yakitoh duhatm, romn wany yakiowomr. Bi Bro Nkifrar yak tutfakfot kfomorm nd yimam.” ");
INSERT INTO amp_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","To Farisiroh womr, rorhu yufat Nikodemusr, ror bingot bi Jisasrpno yihato napthetfn, ndnat womm pthamohat tfit ttiwon memorm, ");
INSERT INTO amp_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Nmoh nkifra boririfhut nhai inji kfokaht, wom yimar tafi rorhu mrokfom wany hik marnya duha, be bmbri finji naknikfot.” ");
INSERT INTO amp_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ror inji kfomotrm tfit rom kfo memomr, “Bare, nine rorhu kmi Galili thofe? To wahtint Bro Nkifrarhu rfa borngt yorhwa mrokfot. Mrokfot nhai kfo mekaht wom profetr Galili profinsn nierahr. Nhai.” ");
INSERT INTO amp_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Nd nia rifiny hanyuk yimam bi turoh kuny kmifako yi hanymom. ");
INSERT INTO amp_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","To Jisasrpar afo tuha rhu hasohato tfit yura Olifet kmit muhmor. ");
INSERT INTO amp_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Tfit bi dbha ksfut yohnemorn Bro Nkifrarhu temper kmifar yimor. Met yindarim yimomn rhu hasetrn rifiny hmbremomr. Be Jisasr warhuhato mrokfom hemorm. ");
INSERT INTO amp_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Met yindarim mrokfom he hasetrn wom boririfhuthu tisami yo Farisim wom ramet mett wom yima furar yimoatt rom htihato yaknimomtn nd met yindar rifinyrpno mhatohmomt. ");
INSERT INTO amp_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Mhatohhato Jisasr mkfo memomr, “Tisaye, nda mett wom yimarpno fasoh neft na hasettn hti nriyafaknimomt. ");
INSERT INTO amp_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mosesr yakitohyuk boririfhut inji kfo kangt, wom mett ndhtet nefet nem be tahiye tahiye frdbofna nohkfot. To nom inji na thombat ni finji kforuha?” ");
INSERT INTO amp_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Nd rom kfo ttiwonmo mrokfot be yuwi memom, “Inji akfo ttiwon rhtikahnomr finji kfiwure, nd ror kfoyuk mrokfot nom tohhato yakrahnomr.” Rom inji kfo ttiwonmohat, Jisasr nhai mfhat kasinyarmort. Ror bbinysoft tario-bttahato bbinysoft tir pinyafe wandfa-mour. ");
INSERT INTO amp_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Masat masat ttiwon hasuknamoatmr Jisasr wasinyahato kfo memorm, “To niko ndar tohwako nhai womr wom fasoh neft narmor ee rorn ndar mett barkof tahis atutwart.” ");
INSERT INTO amp_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ror inji kfonimormn tfit nyingatikt bbinysoft tariobttahato tir pinyafe wandfamour. ");
INSERT INTO amp_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Be rom nd mrokfot wanymomn be mrokfo kfo duha mrokfo kfo duha fnahni hanymom. Nd bro yima boyimat tohak gngonmotm, ee bt wom womt rifiny hanyukm mongtn fnah yakitohmom. Jisasr turpar tariobt hasetr htanymomr. Mettne rorhu nyingatikko tohmout. ");
INSERT INTO amp_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Be Jisasr mfhat kasinyahato nd mett kfo ttiwon memort, “Ndasha tohhasi yimame bi fitoh yuhat yitam? To nine frohm tohhato ni nayuk nefm kfo pthiwamm?” ");
INSERT INTO amp_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Be inji kfomotrt tfit kfo memotr, “Bro yimaye, to nhai womr.” Tfit Jisasr kfo memort, “Na nhai finji kforhotann. Wain. Waikahnn mirahn tfit wom fasoh neft anaya.” ");
INSERT INTO amp_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jisasr tfit kfo memorm, “Nann nukeft hatohhato nda bbinysoft kak nukewant. Fitoh yimam nanhu mrokfot wanyhato hikma, rroh nda bbinysofthu toh yuham yi marnyarahm. Nhai yifungt yau mmo bommiwa kanjo yau mmo bammoruhatm.” ");
INSERT INTO amp_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Wom Farisim nd mrokfot wanyhato Jisasr kfo memomr, “Ni be tunhu hingrnefroh mrokfomi yo tamoh tamoh nefroh mrokforpamn kfo ptha srhwon. Ndnatn met yindarim nhai nd ni pthayuk mrokfom wany fugha-ruhatmm.” ");
INSERT INTO amp_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Rom inji kfomotm tfit Jisasr kfo memorm, “To hifa inji kfo kangko, na be tukianhu tamoh nefroh mrokforpamn ptha srhwa. Na, na sinya tanyuk kmir na tuka tawi-safwanr yo na yiruha yuhat na tuka tawisafwant. Ndnettn nanhu toheft kfo ptha yimbu hikwant. To niko nhai tawisafkahkomt nanhu kmit yo nhai tawisafkahkomt na yiruha yuhat. Ndnettn nanhu toheft niko nhai hti hikkfot. ");
INSERT INTO amp_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Niko kak nhtewukma ndar bbinysofthu yimam yak nhtewa kanjo. Na, na nhai inji wom yimarhu nefm htihato kfo pthakaha. ");
INSERT INTO amp_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","To na kanga wom yimarhu nefm htihato akfo pthaya, nhai turpeta kfo pthakaha. Nhai. Nd na kfo tkrurafmo Yifemrpno tohhato nonn kfo pthewuno. Ndnettn nd na pthayuk mrokfom met yindarim wanyneft rom wany yakiorahma. ");
INSERT INTO amp_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Mosesrhu boririfhuthu mrokfot inji kfo kangt, ‘Wom hus yimaf kfo srhyuk mrokfom be rpa yuhat mrokfom kfo hikfm, be nd mrokfot tu kfo mif kfoyet.’ ");
INSERT INTO amp_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Na tukianhu hingrnefroh mrokfo yuham kfo ptha srhwam, na tkrurafoyuk Yifemr to be na kfiwa yuhatn kfo hikworm.” ");
INSERT INTO amp_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Be Farisim inji wanyhato ttiwon memomr, “To nd ni kfiwa yifemre fitha yorhwar?” Tfit Jisasr kfo memorm, “Na nhai tawisafkahkma, nhai nanhu Yifemr niko tawisafkfot. Na tawisafrahko, nanhu Yifemr tawisafrahkomr.” ");
INSERT INTO amp_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ror nd mrokfom met yindarim kfo hemohat temper kmifarn brbo ofa maruham htamoa tkittpno mrokfom hemorm. Tafi rorhu yak yihar bi niarmor, ndnetmn nhai yimam sinyarmom rorhu yakneft. ");
INSERT INTO amp_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Met yindarim Jisasr wompam tfit kfo memorm, “Na frtrohruhanko. To niko yak hambro hasorahkma. Niko tukmoh fasoh fasoh nefm nahaso nahasoruhakomn nohrahko. Nd na yiruha kmit nikom nhai yiruhatkomt.” ");
INSERT INTO amp_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Judaroh bro yimam nd Jisasr kfomo mrokfot wanyhato tum rinakfo nakfo memom, “Bar yimako, to tamohmpno kfo yamukarnom, ‘Niko nhai yiruhatkomr nd na yiyuk kmir?’ Nd mrokfote finji dukahato inji kfirt? Ka turn yak nadborrahr?” ");
INSERT INTO amp_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Rom inji kfomotm tfit Jisasr kfo memorm, “Niko ndar bbinysoft watohyukeko. Na yura hefenr wutohyuka. To na mirahko ka nda bbinysof thofa. Nhai. ");
INSERT INTO amp_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Na kfo famuyanko, niko tukmoh fasoh fasoh nefm na hasoruhakomn nohrahko. Niko nhai kfo miruhatkoma, ‘Tor Bro Nkifrarhu kfo tkrurafyuk yimar.’ Ndnettn na kfiwanko, niko tukmoh fasoh fasoh nefm na haso-ruhakomn nohrahko.” ");
INSERT INTO amp_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Kfo ttiwon memomr, “Bare, nine frohe?” Tfit Jisasr kfo memorm, “Na bi asonhof rikfo nuhasakmoyanko. ");
INSERT INTO amp_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Na nd niko niwa nefmpno bok mrokfom kforfoyanko yo jasm kanjo rhuhato nikmoh nefm yak nhta-herfoyanko. Tmift na nhai be nanhu dukefrn na tamoh tamoh mrokfom kfo pthakfot. Na, na be nd na kfo tkrurafyuk Yifem mifrhu tng yuhatn hikhato ndar bbinysofthu yimam mrokfom kahukanm.” ");
INSERT INTO amp_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","To rom wanymohat nhai duka marimom, “Jisasr ka Bro Yifemrn kfiwurnom.” ");
INSERT INTO amp_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ndnatn Jisasr kfo memorm, “Na Bro Nkifrarhu kfo tkrurafmohat, kto niko na Bro Najoma yura bgre mishu wuhta yiharn, nd yiha nyingam yoh dborhahato hti dukarahko. Yo hti hikrahko, na nhai wom neft be tukanhu dukefrn hingrnakaha. Na Yifemr kfo htiwa yuhatn hingrna hikwa. ");
INSERT INTO amp_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Na kfo tkrurafyuk Yifemr toh tkafwora, nhai frtrohhato turpetrpaya yak mmbrafinykaha. Nhai. Na niwa nefm tur hti yindhorwa nefm na hikwa, ndnatn nhai frtrohkahra.” ");
INSERT INTO amp_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Bok met yindarim nd Jisasr kfo pthamo mrokfot wanymohat rroh bro dukefm rorn htamom. ");
INSERT INTO amp_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Be nd Judam, Jisasrhu mrokfom wany yakiowetm, kfo memorm, “Niko nanhu mrokfot yakitoh kihrahkomt, be nanhu disaiper mifko rhurahko. ");
INSERT INTO amp_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Nanhu disaiper mifko rhuhato nd tu yafothet mrokfot mhti hikakruha-komtn be nd mrokfotn nd niko kihmbre htatewa fasoh fasoh nefm yafhohato frfnahrahko.” ");
INSERT INTO amp_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Be rom nd mrokfot wanyhato kfo memom, “Nom Abrahamrhu frikef yuhathu yonenom. Nom nhai wom yimarhu yinhitn hingrna hafknekahnom. To tamoh dukeftpno kfo yangannom, ‘Tfit frfnahrahko?’” ");
INSERT INTO amp_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jisasr kfo memorm, “Na kfo mifwanko nda yima yimat fasoh nefm niwam, rom be turoh fasoh nefmn kihmbre htatewumm. ");
INSERT INTO amp_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Wom slefr wom ripharpno tohwohat, nhai be rompno rim tohnihato rorhu yufat rompno rhukaht. Nhai. Be hingrnefroh hingrna hanyeftn tohekworm. Tu nasak yonrpar yifammaroh yufampno korhr. ");
INSERT INTO amp_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ndnettn bi Yinem Yonrn nd fasoh fasoh nefm mtitikt kanjo kihmbritayukm bi frtmbho tebikr trufekrko, to be niko nhai wom fasoh nefm kihmbrekahmko. ");
INSERT INTO amp_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Rot to niko Abrahamrhu frikef yuhayet. To tmift nanhu mrokfot nhai rhukahtko. To ndnetkomn nanhu wasneft waji yaukma. ");
INSERT INTO amp_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Na kfo pthiwa mrokfot na tukianhu Yifemr kfo hta bohtayuk mrokfo yuhamn kfo ptha hikwa. Niko rot tukmoh yifemr kfo nuhasyuk mrokfo yuhamn hikwoko.” ");
INSERT INTO amp_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Judam nd Jisasr kfo pthayuk mrokfot wanyhato tfit kfo memomr, “Abrahamr to nmoh nkifrayer.” Tfit Jisasr kfo memorm, “Niko tu Abrahamrhu frikef yuhathuko arhuko, to be nd ror namo nef yuham yak hikrfoko. ");
INSERT INTO amp_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Na kfo pthiwa mrokfom, na tu Bro Nkifrarhu tu mrokfo mifm kfo pthiwa. To tfit kangko awasnomr. To ndt nhai tu Abrahamrhu neft hikkahko. ");
INSERT INTO amp_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Nd niko niwa nefm, ndm niko tukmoh yifemrhu yuhamn kak hikwoko.” Tfit rom kfo memomr, “Nmoh mmemrom nhai ijoh tonehato hiyaurmomnom. Nhai. Nmoh yifemr, to Bro Nkifrarpar.” ");
INSERT INTO amp_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Rom inji kfomotm, tfit Jisasr kfo memorm, “To na to froha? Na to rorpno wusinya tanyhato niayuka asha tfit nia tohwa. Niko tu Bro Nkifrarhu mifko arhuko, to na yakrfokma nikompno tohrfoya. Nanhu nia nmbuhat, nhai na be tukanhu fijo niarmoya. Tu Yifemr kfo tkrurmotra niamoya. ");
INSERT INTO amp_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","To tamohmpno na pthayuk mrokfo yuham wany hik duha yitakomm? Ndt nhai be sfno. Nanhu mrokfom nhai wanyruhatkomm. ");
INSERT INTO amp_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Niko tukmoh yifem Satanrhu yonkomn kangko tukmoh yifemrhu dukef yuhatn ahiknom. Bingot to frohmn yima wasmoam? To ror yima wasmoarn nhai tu mrokfot yakitoh-rmoar. Yo yima kfo nhehneft to frohm yifemmoamt? To rorn yifemmourt. Ror nd neft bi mhatoh fnahmort. ");
INSERT INTO amp_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nd na kfiwa mrokfot tu yafothet mrokfot kfiwanko, to niko Satanrhu yonkomn nhai wany yakiokahkma. ");
INSERT INTO amp_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ka na fasoh nefm nayet yimayann nhai wany yakiokahkma? To niko inji duka thoft, to bt wakfo nuhaskma na niwa fasoh fasoh nefm. To na tu yafothet mrokfot ptha thoft, to tamohmpno na pthayuk mrokfom wany yakio duha yitakomm? ");
INSERT INTO amp_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Bro Nkifrarhu yonm Bro Nkifrarhu mrokfom wanukwomm. Niko nhai ka tu Bro Nkifrarhu yonko rhukahko, ndnetkomn nhai rorhu mrokfom wanykahkomm.” ");
INSERT INTO amp_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Tfit Judam sinyahato Jisasr kfo memomr, “Nome ka kfo mifwonom nom kfo yamukahat ni Samaria thofnn kmi yarhr thu hamumiwurn?” ");
INSERT INTO amp_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Rom inji kfomotm tfit Jisasr kfo memorm, “Na nhai wom kmi yarhr thu hammokahra. Na tukianhu Yifemrhu yufatn wuyuta grhiwota, to tfit nikomn nanhu yufat yiro wahtewukomt. ");
INSERT INTO amp_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Na nhai be tukianhu yufatn yura yura htakaha. Tor wom yimar, rorn nanhu yufat yura wuhtarahra, ror jaser. ");
INSERT INTO amp_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Na kfo mifwanko, wom yimar nanhu mrokfot wanyhato yak hikrahrt, nd yimar nhai nohruhatr. Be tu nhai mif.” ");
INSERT INTO amp_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Tfit inji kfomotr Judam kfo memomr, “To nom bi wany nhte-wunomn ni ufasohtet kmi yarhr thu hamumiwatrn bi kfo mmo bamumiwun. To Abrahamr Bro Nkifrarhu mrokfom hiketr to nohmor, yo profetm Bro Nkifrarhu hayuk mrokfom kfo pthamoam to nohmom. To tamohmpno tfit nom kfo yangannom, ‘Wom yimar nanhu mrokfot yak hik marnyarahrt, nhai nohruhatr?’ ");
INSERT INTO amp_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Bar yimako, ka tu inji kfiwohat ka kangn nanrpaya tu bro yufeta. Ka nohmo nmoh nkifra Abrahamri profetme ka nhai yima furayem?” ");
INSERT INTO amp_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Tfit Jisasr kfo memorm, “Na be tukianhu yufat yura wuhtayant, nanhu yufat fipa duhatt rhurfot. Tu hifa nanhu Yifemr, nikmoh Bro Nkifrar, rorn nanhu yufat wuhtamort. ");
INSERT INTO amp_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","To niko rorhu ruheft nhai htirmokomr. Na awi htiyeta rorhu ruheft. To na tfit kfo miruha, nhai htirfoyanr, to be niko kanjo kfo brurmaha rhurfoya. Na bi rorhu ruhefm hti hiketann to be ndnatn rorhu mrokfom kak hik marnyewanm. ");
INSERT INTO amp_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","To nikmoh nkifra Abrahamr dukamohat nanhu nia yiharhu htineft, ror yindhormor. To na niahato turhu nyingaye htimohat, yima yuhur mirhumorr.” ");
INSERT INTO amp_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Judam nd mrokfot wanyhato Jisasr kfo memomr, “Bare, ni tafi 50 gunyjim duhaye, to finji kanjo htiyafmonr Abrahamr?” ");
INSERT INTO amp_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Tfit Jisasr kfo memorm, “Na kfo mifwanko, Abrahamr tafi mmemt hiyau duharn, na bi inji rhumoya.” ");
INSERT INTO amp_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Rom inji wanyhato tahim yakmomn memom, tahiye frdbofna nohnomr. To nhai, Jisasr nhofijo temper kmifar htanymorrn fnahnimor. ");
INSERT INTO amp_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Wom yiha Jisasr wiyauyau hanymorn nyinga kunyjet yimar mhtimorr. Mmemt ror hiyaumohat bi inji nyinga kunyjetrn hiyaumotr. ");
INSERT INTO amp_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jisasrhu disaiperm nd nyinga kunyjetr htihato ttiwon memomr, “Tisaye, frohmn fasoh fasoh nefm namotm nyinga kunyjetr mmemt hiyaumotr? Nd tu yimarn fasoh fasoh nefm namotr o yifammafn fasoh fasoh nefm namotf nyinga kunyjetr rhumor?” ");
INSERT INTO amp_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Tfit Jisasr kfo memorm, “Nhai ndar yimar wom fasoh neft narmor yo nhai rorhu yifammaf wom fasoh neft narmof. Nhai. Nd yimar inji rhumohat Bro Nkifrar memor, ‘Nanhu hingrneft rorpno tafont mhfnahrhotant met yindarim htirahmt.’ ");
INSERT INTO amp_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Na Bro Nkifrar tkrurafmotra fawihnamoya. Nda mar nukar yorhwa fijo nom Bro Nkifrarhu hingrneft hingrnakfot. Kto tfit mirkahtt yifung tiwa, yimam nhai wom tamoh hingrnefm hingrnaruhatmm. Nhai. ");
INSERT INTO amp_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Na afo nda bbinysoft tohhato nann nukeft bbinysoft kahukant.” ");
INSERT INTO amp_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jisasr inji kfonimorn bbinysoftn wabruktumor. Wabruktuhato nd brukpami bdrpam rpat yaktk botkak-mormn nd nyinga kunyjet yimarhu nyingamn rifak yenymor. ");
INSERT INTO amp_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Riyak yenyafhato kfo tkruraf memorr, “Siloam bujr warim yuk trufafont nd bdr yenys.” (Nd yufa Siloamthu yimbu yuhat inji korht: Kfo tkrurafkfot). Be nd nyinga kunyjr yimorn fuk truf thumorm nd nyingaf thu yenymo bdrpam. Rim yuk truf tanyhato tfit kmifako yimohat nyingam bi yukatohetm kmifako yimor. ");
INSERT INTO amp_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Nd nyinga yukatohetrhu kmi thofmi yo ror barkof afo nyinga kunyjetr rhuhato buha yihota yuham rhu hasohato met yindarim maruha wuskam tndaumoam, htimomrn tum rinakfo nakfo memom, “Barenko, nd yimare ka ndu yihotam rhu hasohato maruha wuskam tndaumoa yimayer?” ");
INSERT INTO amp_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Womm kfo memoum, “Uwa to tawomer.” Tfit wommn kfo memoum, “Nhai. Arr womer. Rpahtet ruhetfn inji hti mumiwunomr.” Tfit turn kfo memourm, “Nhai womm, to tawom naya.” ");
INSERT INTO amp_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Tfit rom ttiwon memomr, “To nyingam finji netnm yukatohwanm?” ");
INSERT INTO amp_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Tfit ror kfo memorm, “Nd rom yutiwa yima Jisasr, rorn brukpami bdrpam rpat yak yeny boyenyakhato nanhu nyingam nde yak yenyafhato kfo tkrur famura, ‘Siloam bujr waikahnn nyingatikt wayuk truftwant.’ Inji kfefitra na yihato tek bujr nyingatikt yuk trufhat, be nyingam rifukatoh-ekanm.” ");
INSERT INTO amp_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Tfit rom ttiwon memomr, “To nd yimare fitha inji yorhwar?” Tfit ror kfo memorm, “To na nhai tawisafkaha.” ");
INSERT INTO amp_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Be nd yimar yaknimomrn Farisimpno hanymomr. ");
INSERT INTO amp_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jisasr nd yimarhu nyingam brukpami bdrpam rpat yak yenyakhato nyingam htahato nyinga yukatohmohat, nd hingrneft Sabat yihar hingrnamort. ");
INSERT INTO amp_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Farisim-pno hanymotmr tfit romn wompam ttiwonmomr rorhu nyingam frdbtakmo yuhat. Tfit ror kfo memorm, “Rorn brukpami bdrpam rpat yak yenyakhato nyingam htitra tfit bujko yihato nd yak yenyafyuk bdrpam yuk truftanm nyingam frdbtakma.” ");
INSERT INTO amp_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Be wom Farisim inji wanyhato kfo memom, “Nd yimar Sabat yiharhu boririfhut nhai yak hikkahrt. To mirahko ka Bro Nkifrar kfo tkrurafmotrr niamor. Nhai.” Tfit wommn kfo memom, “Yimar, ndhtet mirakerkfom nayetr, to finji kanjo ufasoh nefm hingrna-rform?” Rom tum inji rinakfakhato nafak mkumom. Womm Jisasrpno tohmom, womm rom tum inji tohmom. ");
INSERT INTO amp_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Farisim tfit wompam ttiwon memomr, “Ninhu nyingam yak marnye yimare, ni finji dukiwanr?” Ror tfit kfo memor, “Nd yimar, ror profeter.” ");
INSERT INTO amp_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Nd Judaroh bro yimam nhai marimom, nd yimar tu nyinga kunyjetr rhumotr nyingam marnyamomr. Nhai. Memom, fura kfoyet. Ndnetmn tfit nd yimarhu yifammaf nakuyakmomf. ");
INSERT INTO amp_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Be rof niamotf ttiwon memomf, “Nifn wakfofn. Ndarre nifnhu yoner? Mmemt hiyaumohate ka bi inji nyinga kunyjetr hiyaumotr? To finji netr rorhu nyingam bi yukatohwarm?” ");
INSERT INTO amp_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Be nd yonrhu yifamma sawohf kfo memof, “Nda yonr nnoher. Ror nurmohat nyinga kunyjetr nurmotr htimononr. ");
INSERT INTO amp_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","To nda rorhu nyingam frtrhahato yukatohwa yuhat nhai tawisafkahno, yo yimam rorhu nyingam yak marnyayukm no nhai tawisafkahnonm. Turn wattiwonkahtko kfo ptha nuhasrahrko. Bi bro damiager turn ptharahr.” ");
INSERT INTO amp_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Nd yonrhu yifamma sawohf bi Judaroh bro yimaroh yima yuhum bi tawisafetfn to mrokfom kfo pthamohat tfit kfo memof, “Tu yonrn kfo ptharahr.” Bi Judaroh bro yimam kfo hta memom, “Frohr kfo kangr, Jisasr tor nd yimar ndar bbinysof thofroh nrfa htiyakyukr. Inji kfoyuk yimar nhai nom Judanmoh lotukfot rhunho hakuruhatrnom.” ");
INSERT INTO amp_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Yifamma sawohf bi nd mrokfot bi wanyetfn to be tu yonr kfomof mrokfo kfo pthaneft. ");
INSERT INTO amp_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Tfit wompam nakumomr nd bi marnyaniyet nyinga kunyjr. Tfit wompam yimotr kfo memomr, “Ni Bro Nkifrarhu nyingampno wakfo miftwannom ni asomif tfit kfo pthiwohat. Ni nd barkof kfi yimar nom tawisafwonomr tu fasoh fasoh nefm nayet yimayer.” ");
INSERT INTO amp_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Inji kfomotm, tfit kfo memorm, “Yo ka, ndhtet ufasoh nefm nayeter? Ndm na nhai tawisafkaha. Na tawisafwat akfo nuhasanko. Bingot na nyinga kunyjeta rhu hnamoya, tfit ariha na bi kukatohwa.” ");
INSERT INTO amp_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Tfit rom ttiwon memomr, “To ror finji namorn? Finji namotrn ninhu nyingam yukatohwamn?” ");
INSERT INTO amp_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Tfit kfo memorm, “To bi kfo nuhasanko. Kfo nuhastanko nhai wanyrfoko. To tamohmpno kfo yamukako, ‘Wompam awany hatohnom?’ E, kangkone, ‘Rorhu disaiperko arhunom?’” ");
INSERT INTO amp_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Farisim inji wanyhato kfo memomr, “Arom rhupete, tfit nomn yari yutewun. To tunn rorhu disaipere. Nom nndoh Mosesrhu disaiperenom. ");
INSERT INTO amp_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nom wany hnamo mrokfot Moses-rpar Bro Nkifrar pthamorr. To nd yimare fitoh yuhat niamotr nom nhai tawisafkahnomr? Nom mmiwunomt rorhu nia yuhat.” ");
INSERT INTO amp_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Be nd yimar kfo wok memorm, “Nd niko kfiwa mrokfot be tu nndohtet hnomha mrokfot kfiwuko. Nd yimar nanhu nyingam yak marnyamor mumiwukomt rorhu nia yuhat. ");
INSERT INTO amp_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nom womt htitnom Bro Nkifrar nhai wanyhekahrm fasoh fasoh nefm nayet yimaroh mrokfom. Yimar Bro Nkifrarhu yima yuhur rhuhato rorhu dukefrn hikwar, tor nd yimar tamoh mrokfom Bro Nkifrarpno kfo pthaneft wanukrr. ");
INSERT INTO amp_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Bingot mifn nmoh nkifram toh hnamompno nhai wom tndhkfot wanyrmonomt, kfo marimom wom yimar mmemt nyinga kunyjetr hiyaumottr, kto tfit wom yimarn wom hingrnefm hingrnamotrr nyingam frtrhahato fukatohmor. Nhai. ");
INSERT INTO amp_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","To Bro Nkifrar akfo tkruraf duha yirr nd yimar to nhai wom tamoh nefm narfotrm.” ");
INSERT INTO amp_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Farisim nd mrokfot wanyhato kfo memomr, “Ni wanurtamohat fasoh fasoh nefm bi rpat mihasuhmonm. To tfit frohm yamuka akfo tebosa?” Be inji kfohato nd rifiny kunyr toh hasetr fak tuhafmomr. ");
INSERT INTO amp_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Judaroh bro tohak yimam nd yimar yiro rifinyuk kunyr ruhetr yak tuhafmotmr Jisasr inji wanyhato fak hambro hanymorr. Yak hambro hanyhato mhtimorrn ttiwon memorr, “Ni Bro Najomrhu dukefrpno korhn o nhai?” ");
INSERT INTO amp_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Tfit nd yimar kfo memor, “Bro yimaye, nd ni kfiwa Bro Najomr to froher? Wakfo nuhaskahtna nanhu dukefr be rorpno htaruhanr.” ");
INSERT INTO amp_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Tfit Jisasr kfo memorr, “To bi htitwonr. To nd ninpno pthiwa yimayer.” ");
INSERT INTO amp_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Tfit nd yimar kfo memor, “Broye, nanhu dukefr ninpno htewanr bi.” Be inji kfonihato Jisasrhu wurampno mtabokmehato mfhat wasimort. ");
INSERT INTO amp_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jisasr kfo memor, “Na nda bbinysoft niamohat nda yimam niwa fasoh fasoh nefroh tafonthu yak htaneftn niamoya. Ndnettn met yindarim, nyinga kunyjetm yorhwam, tfit yukatohhato nann hikrahm. Tfit nd nyingetm, rom tfit nyinga kunyjetm rhuhato yau mmo bammorahm.” ");
INSERT INTO amp_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Wom Farisim Jisasrpno tohetmn Jisasr nd mrokfot tumohat kfo ttiwon memomr, “Nome ka rpat nyinga kunyjetenom?” ");
INSERT INTO amp_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Tfit Jisasr kfo memorm, “Niko nyinga kunyjetko warhuko, to nhai wom tamoh mrokfoyetko rhurfoko. Nhai. To tfit tukomn kfo kangko, ‘Nom hifa dborioh nyingetenom.’ Ndnatn niko nayuk fasoh nefm tom afo korhmko.” ");
INSERT INTO amp_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jisasr tfit wompam kfo memor, “Na kfo mifwanko, yimar nhai nd sifsifm yorhwa gnathu yifhatik yuhat rim fnahnikahr, be turn buha gnat muhnihato miftohnir, ndhtet yimar rikoh yimayer. ");
INSERT INTO amp_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Yimar tu yifhatik yuhat rim fnahnitar, ndr tu sifsifroh tohukatoher. ");
INSERT INTO amp_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Nd sifsifroh gnat tohukatohwa tohukatohr yifhatikt yak tfanyekwatrr rim fnahnitr. Sifsifroh yufam yutahato nakuneft rorhu tngtn wany tonitatm kak hfhanwatrm fnahnitm. ");
INSERT INTO amp_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Sifsifm rim hfnahni thombat turn hatohekworm. Sifsifm bi rorhu tngt wany nhtetmn be rorn kak hikwom. ");
INSERT INTO amp_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Rom nhai wom yima furam hik furakfot. Nhai. To wom yima furar nakuneft wany kakrmitmr. To rom nhai wom yima furaroh tngm wany tonekfot.” ");
INSERT INTO amp_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jisasr nd kfo nhombra mrokfot kfo pthamohat rom fak mmotamomt, nhai yakrmomt. ");
INSERT INTO amp_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ndnatn Jisasr kfo memorm, “Na kfo mifwanko, nanrpaya nd sifisifroh rim fnahni yuhathu yifhatika. ");
INSERT INTO amp_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Ndwom womt nanhu nyinga yuhat tohak hanyukm, rom rikoh yimayem, wuska teh hbotfayet yimayem. To ndnatn sifsifm nhai rroh tngm wany tone-rmoamm. ");
INSERT INTO amp_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Na, na tu yihota rim fnahni yuhaya. Yimar nanpno nierahr, Bro Nkifrarhu tirmn rhurahr. Nhai wom tamohm finjina finjinaruhatmr. Yarim fnahna rim fnahnihato ye wussoh htfas hakurahr. ");
INSERT INTO amp_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Rikoh yimar nianeft ror nhai wom tamoh dukefrpno niakahr. Nhai. Ror be nd sifsifroh yak rikohhato was yenyeftn niewur. To na niamohat, nhai nd dukefr niarmoya. Na yimaroh toh marnyaneft dukahato niamoya. Yimam nanpno tohhato be nhai tfit wom tamohm yak hambroruhatm o dukaruhatm. ");
INSERT INTO amp_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Na, na sifsifroh dborioh tohukatoha. Dborioh tohuka-tohr inji niewur, ror turn rorhu sifsifroh tamoh nefm mfha htewurm. ");
INSERT INTO amp_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Yimar be maru dukefrn hingrna-neft, nhai sifsif tikat mifr tohukatohwa kanjo sifsifm tohukatohkahrm. Nhai. Yifako tohwa yaum htiyakneft sifsifm yakrme htanyrahrm. Yakrme htany-ruhatrm yifakorhof yaum niahato sifsifm ye jborfahato rpa rpa hik tubaturahmm. ");
INSERT INTO amp_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Nd yimar inji nayukr rorhu dukefr be maru hingrna dukefrparn korhrr. Rorhu bro yima yuhur nhai sifsifmn rhukahr. ");
INSERT INTO amp_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Na tukia sifsifroh tu dborioh tohukatoha. Nanhu Yifemr na tawisafwora. Ror na inji tawisafwa kanjo na inji tawisafwanm nanhu sifsifm. Yo na Yifemr tawisafwa kanjo nanhu sifsifm inji tawisafwoma. Na sifsifm dukahato kanga anoha, nhai mrokfom. ");
INSERT INTO amp_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Tom nanhu wom sifsifm. Nhai bi ndarwom sifsifmpno bi tohkahm. Ndmn kanga aiyakkahanmn wom sifsifmpno rpat htahato nanhu tngt bi wany nhtarahmt. Rpat wom sifsifmpno htahato rpa tohukatohrpaya yakitohruhanm. ");
INSERT INTO amp_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Na, na be wofnwa mfha htahato tfit sinyaneft. Ndtpno nanhu Yifemr yindhor mifwora. ");
INSERT INTO amp_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nhai wom yimarn nanhu yak nadborhato nohkfot. Nhai. Na be tukianhu fijo mfha htaruha. Na tukianhu Yifemr bi inji kfo htamora. Ndnatn kanga, mfha htahato tfit sinyaya, be inji naruha.” ");
INSERT INTO amp_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Judam nd mrokfot wanyhato tfit nafak mkumom. ");
INSERT INTO amp_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Bok yimam kfo memom, “Kmi yarhr thu hamumiwatrr inji kfo mumiwur. Tamohmpno rorhu mrokfom wany yakitohwakomr?” ");
INSERT INTO amp_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Tfit womm kfo memom, “Ndm to mirahko ka kmi yarh thu hamumet yimaroh mrokfoyem. Nhai. Kmi yarhm athu hammomr nd nyinga kunyjet yimar yak marnyarforr?” ");
INSERT INTO amp_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Bro frfon wormr tohmo yiharn Judam bro tofs Jerusalemko faki-tohmom. Nd tofs rom rhumot bingot Bro Nkifrarhu temperr Judam hingrnamohat nd yiha Bro Nkifrarhu tirtn nd temperr htamomr. To nd yihar tfit Judam rhuhato rhu duka hanymoum. ");
INSERT INTO amp_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jisasr temper kmifar yihato Solomon yufet kuny mkur yihom fauyak mfauyakmour. ");
INSERT INTO amp_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Yihom yauyak myauyak hasetrn Judam rifiny hmbriyaknihato kfo ttiwon memomr, “Nome ar nohof rigariyakronomn ninhu toh yuhati ninhu nia yuhathu kfo nuhasneft. Fitoh yiha kfo nuhas-ruhannom? Ka ni ndar yimann Bro Nkifrar kfo htamor yimaroh nrfa htiyakyukr?” ");
INSERT INTO amp_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","26","Jisasr tfit rroh mrokfot kfo wok memorm, “Na to bi kfo nuhas hnamoyanko, to niko nhai wany yakiokahkma. Nanhu Yifemrhu yufat-pno hingrnefm hingrnewohat niko nhai ndmn mhti nhtak mikahko ndr ndhtet yimayer. Niko to nanhu sifsifkomn btn wany yakiokahkma, niko wom nndoh yima furayeko. ");
INSERT INTO amp_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nanhu sifsifm awi nanhu mrokfom wany yakiowoma. Na tawisafwoyanmn nanhu mrokfom hikwomm. ");
INSERT INTO amp_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","30","Toh nkifraniyuk yafothat yahukotanm nhai finjinaruhatm. Bi tu nngrajohet Yifemr bi nanhu tirtn htayet yimam nhai wom yimar tfit nia yakruhatrm. Nani nanhu Yifemr nhai wom nndoh nndoh. Nnoh ruheft rpat. Ndnatn Yifemrhu tirtn bi ruhetmn nhai wom yimar niahato yakkfot.” ");
INSERT INTO amp_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Judam nd mrokfot mwanyhato tfit tahim yakmomn memom, tahiye frdbofna nohrahnomr. ");
INSERT INTO amp_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Tfit Jisasr kfo memorm, “Na fak nuhasmoyanko nanhu Yifemrhu bok dborioh dborioh hingrnefm. To fitohtn niko hti namburhato yangako afrdbofnanomr?” ");
INSERT INTO amp_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Judam sinyahato tfit kfo memomr, “Nom nhai nd ninhu dborioh hingrnefm htihato tahiye frdbofnakfot kfokahnom. Nhai. Tunn kfo yamukatn, ‘Bro Nkifrarhu tkitt ayakant.’ Tot nd yuhatn kangnom, tahiye afrdbofna nohnomn. To ni be yima furann kangn, ‘Tfit Bro Nkifrar kanjo aruha.’” ");
INSERT INTO amp_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jisasr inji wanyhato kfo memorm, “Niko htiyeteko. Niko yakitohwa Bro Nkifrarhu yirmoht inji kfo kangt, ‘Na inji kfo memoyanko, “Niko Bro Nkifrar kanjo korhko.” ’ ");
INSERT INTO amp_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Mrokfom, Bro Nkifrarhu rfa borngt yorhwam, nhai kfonihato tfit kfo kekutkahrm. Nhai. Bingotn bi Bro Nkifrar yimam mrokfom hemoahat inji kfo memourm, ‘Niko Bro Nkifrar kanjo korhko.’ To mrokfom, Bro Nkifrarhu rfa borngt yorhwam, nhai kfonihato tfit kfo kekutkahrm. Nhai. ");
INSERT INTO amp_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Na tu Yifemr bi kfo htahato kfo tkrurafmotra nda bbinysoft fawihnamoya. To ndnetann na tfit kfo yamukahat, ‘Na Bro Nkifrarhu Yinema,’ to tamohmpno wany namburhato kfo yamukokma, Bro Nkifrarhu tkitt kangr ayaka? ");
INSERT INTO amp_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Na ndar tukianhu Yifemrhu hingrnefm nhai hingrnakahanme, ee btn nanhu mrokfom wany yakio duha. ");
INSERT INTO amp_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","To na, na hingrnewanm rorhu hingrnefm. Na Yifemr thu hamuhmora na tawo thu hamuhmoyanr. To nd na pthayuk mrokfomn nhai wany yakiokahkomme, tfit na hingrnayuk hingrnefmn ndm wamhti dukakko. Wamhti dukakkahkomn waduka wameko, ‘Rof nito rofhu toh nmbuhat nhai nndo nndo.’” ");
INSERT INTO amp_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Inji kfomotr tfit memom ayaknomr to nhai, ror yak hhrifnimormn yimor. ");
INSERT INTO amp_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Be Jisasr tfit yimorn tek Jodent yau hayuknimortn rim fnahmor bingot Jonr yimam baftaisimmoa tkittn. ");
INSERT INTO amp_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ndha tohetrn bok met yindarim ror mhtimomrn kfo memom, “Rot Jonr hingrnamoa hingrneft nhai wom mirakerkfom hingrnarmoar. To Jonr ndar yimarhu mrokfom kfo pthamoahat, be tu fipet mrokfom kfo pthamourm.” ");
INSERT INTO amp_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Jisasr ndha tohmohat bok met yindarim rroh bro dukefm htamoumr. ");
INSERT INTO amp_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Wom yimarhu yufat Lasarusr. Nd yimarhu kmit Betanit. Turhu kmit tohhato dbohneft rifakakmotr. Nd kmi Betanitn tohmouf Martati tuthu nmem Mariat. ");
INSERT INTO amp_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","To nd met Mariatn Jisasrhu wuram sanda welpaye yuk wunahato tfit tuthu yuke tmarifaye wuram trk domtmotr. Nd dbohnamo yima Lasarusr to nd Marta Maria met najohfhu mndaremer. ");
INSERT INTO amp_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Nd met najohf Jisasrpno mrokfot htafhato kfo memof, “Broye, nd yimar ninpno nabnot hakutar dbohnewur.” ");
INSERT INTO amp_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jisasr nd mrokfot wanyakhato kfo memor, “Nd dbohneft nhai Lasarusr wundiat minohnihato mifnahniruhatr. Nhai. Nd dbohneft tuhan yindariroh Bro Nkifrarhu bbukeft htihato Bro Yifemr bro yufat hayuket. Yo nd yuhatn Bro Najomr bro yufat yakrahr.” ");
INSERT INTO amp_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jisasr Marta Maria najohfi rofhu mndarem Lasarusr be tu marbit htamourm. ");
INSERT INTO amp_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Lasarusrhu dbohna mrokfot wanyakmohat nhai bi marimor, “Bmbri yirhoyann rorhu dbohneft htihiruhanr.” Nhai. Afo wom hus yihaf toh tanymor nd ror tohmo kmit. ");
INSERT INTO amp_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Nd hus yihaf toh tanyhato Jisasr disaiperm kfo memorm, “Tmifnom ashart ahtanykahnomt tfit ainyom Judia profinsko.” ");
INSERT INTO amp_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Jisasr kfo yibonmotr Judiako yinyeftpno disaiperm kfo memomr, “Tisaye, ni dukewun ayuwonanoh nmbuhat Judam tahiye tahiye frdbofna noh hany sitamohat, tamohmpno yamuka tfit Judiako ainyom?” ");
INSERT INTO amp_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Tfit Jisasr kfo wok memorm, “Marr yuwa muhhato yohni thombat ka nhai 12-pela auakfot mar nukeft rhukaht? Yimam ndar bbiny-softhu mar nukeftpno yauwamn nhai suhkahm. ");
INSERT INTO amp_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Yimam yifung yauhato suhwam, yifung nkrt yak tato hanyhato mimpno mfrgughato suhwom.” ");
INSERT INTO amp_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jisasr inji kfonihato tfit kfo memorm, “Nmoh yimatem Lasarusr be hwitr. Na yi shombat yak thakruhanr.” ");
INSERT INTO amp_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Jisasrhu disaiperm nd mrokfot wanyhato kfo memomr, “Broye, be hwe mif thombat, rorhu dbohneft htanyrahtr.” ");
INSERT INTO amp_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Disaiperm nhai marimom Jisasr kfiwohat Lasarusr bi nohetrn hwekfot kfiwurr. Rom memom, “Ka be hwe mifneft kfiwur.” ");
INSERT INTO amp_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ndnettn Jisasr kfo nuhas marnya memorm, “Lasarusr bi noh mifmor. ");
INSERT INTO amp_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Na hifa nhai bi marimoya bi yirhoyann Lasarusr htiruha. Nhai. Niko mdukakmoya. Memoya, ‘Rpat yiruhanomn rom turoh nyingaye htiruhamn rroh bro dukefm htarahma.’ Yo be waniako yi htirahnomr.” ");
INSERT INTO amp_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Jisasr pthanimotr you Tomasr, rorhu wom yufat Didimusr, wom disaiperm kfo memorm, “Wasinyako. Aikahnom rorpno rpat nohrahnom.” ");
INSERT INTO amp_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Jisasr kmi Betanit mfnahmohat Lasarusr bi tahi muht rim htafhato bi husfihus marm bi tohetm mfnahmor. ");
INSERT INTO amp_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Nd kmi Betaniti Jerusalemr nhai wuri wuri rhukahf. Wom kmit toh tany tfit manoh wom kmit yinyeft be 3 kilomitakforpat yauniyetet. ");
INSERT INTO amp_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Brbo brbo ruhetfn ndnettn tum Judam yimat yimat toht yima nur bb kunys yi tohnhohato Marta Mariarof bmtamof rom htihato. ");
INSERT INTO amp_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nd nur kunys rhu hasetmn Martat Jisasrhu yi mrokfot wanymohat be wasinya fnah twanhomotn Mariat kunys rhu htanymottn fnahnihato Jisasr yi rim htimot. ");
INSERT INTO amp_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Jisasr rim htihato Martat kfo memotr, “Broye, ni asha atohkahnn nanhu mndaremr nhai inji nohrmotr. ");
INSERT INTO amp_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","To nanhu yima yuhur duka kanga asomift ni Bro Nkifrarpno tamohm wukfo bruttnarahnr, wany yakiohato wahirahrn.” ");
INSERT INTO amp_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Inji kfomott Jisasr kfo memort, “Ninhu mndaremr tfit sinyarahr.” ");
INSERT INTO amp_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Jisasr inji kfomotrt tfit kfo memotr, “Uwa, nanhu yima yuhur duka kangr wuroh ndar bbinysofthu bati yihar sinyarahr.” ");
INSERT INTO amp_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jisasr kfo memort, “Na ndar yimaya na noheh yima kasinyayet yimaya. Na yimam kasinyahato toh nkifraniyuk yafotham yahukotanm toh nkifranitm. Yimam na htihato rroh bro dukefm nann htem, htirahnm nd yimam ar bi nohetm tfit sinyahato toh nkifranirahm. ");
INSERT INTO amp_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Yo yimam yima nfrim tohhato na htihato rroh bro dukefm nann htem, nd yimam nhai nohruhatm. Nhai. Rom be inji toh nkifranirahm.” Jisasr nd mrokfot pthanihato Martat wattiwon memort, “Ni nd na kfiwa mrokfot wanukohat wany yakio kangn tu kfot kfiwa?” ");
INSERT INTO amp_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Tfit Martat kfo fakio memot, “Uwa nanhu Bror, na ni kfiwa mrokfom wanyhato htitann ni tu Bro Nkifrarhu Yone. Ni nda yimann Bro Nkifrar kfomor nda bbinysofthu tuhan yindariroh minrfa htiyakneft.” ");
INSERT INTO amp_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Martat Jisasrpno inji ptha tanyhato tuthu nmem Mariat rim htiyakmott. Rim htiyakhato nhowi yimbhindangm kfohe memott, “Tisar tor bi nier. Ni kfefirn.” ");
INSERT INTO amp_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mariat be inji wanyhato yudbat memot Jisasr yi htiruha. ");
INSERT INTO amp_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jisasr tafi kmit rim fnahrmor. Martat rim htimo tkittn yuhre rhu hasomor. ");
INSERT INTO amp_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Mariatpno yima nur bb kunys rhu hasomo Judam Mariat fnahnimott rom htiyaf hanyhato memom ka yima gur rhuyuk tkitt kangt, yikahann yihom nur tanyruha, ndnetmn mhikaknimomt. ");
INSERT INTO amp_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mariat yimotn yihom fnahmot Jisasr rhu hasomo tkittn. Rim fnahhato Jisasrhu wurampno brbo rim tabokmehato kfo memotr, “Broye, ni asha atohkahnn nanhu mndaremr nhai inji nohrmotr.” ");
INSERT INTO amp_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jisasr htimort Mariat nurmoatt yo nd rotpno yiyuk Judam rpat nurmoatm tfit Jisasr rom htihato rorhu yima yuhur tfit wamortakihato memor anura. ");
INSERT INTO amp_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Yima gur htamo tkitt kfo ttiwon memorm, “Fitha htamokomr?” Kfo memomr, “Broye, afo wania wahti.” ");
INSERT INTO amp_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Be Jisasr nurmor. ");
INSERT INTO amp_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Judam inji htihato kfo memom, “Wahtiko rorhu yima yuhur nd yimar korhr.” ");
INSERT INTO amp_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Tfit womm rirhuhato kfo memom, “Nda yimar to nyinga kunyjm fak marnyamorm. To tamohmpno nhai kformotr ndar yimar nhai nohrmotr?” ");
INSERT INTO amp_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jisasrhu yima yuhur nhai marnyarmorr. Be nd nur rifhurpno yimor yima gur htamo tkitt. Kmi yihofr hingrna htamo tahi muht ndtn htahato tfit wom tahis yakhato muht frtittafmomt. ");
INSERT INTO amp_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jisasr kfo memorm, “Nd yopthu tahis wayaktakomt.” Inji kfomotr Martat, nd nohmo yimarhu mndaremt, kfo memotr, “Broye, nd yimar bi husfihus marm bi ruhetrn tahis yaktewohat yima gu mthefr fnahwor.” ");
INSERT INTO amp_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jisasr rothu mrokfom wanyaf hanyhato kfo memort, “Na bi kfiyann, ninhu yima yuhur duka kangr kasinya mifwor, nd dukefr kakitohwo htitwont Bro Nkifrarhu bro bbukeft.” ");
INSERT INTO amp_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Be nd muht frtittafmo tahis faktamomt. Yaktamotmt Jisasr yura hefenr wuyukatohhato kfo bruttna memor, “Bro Yifeme, na kfo yindhorwann. Na kfo bruttnaneft wany yakiohnewuna. ");
INSERT INTO amp_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yiha yiham na ninpno kfo bruttna hna thombat wany yakiohnewuna. Na ndar tohwa yimam dukahato inji kfiwa, htiruhamn duka mirahm tu Bro Nkifrarn kfo tkrurafmotrr niamor.” ");
INSERT INTO amp_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Jisasr inji kfonihato yufat yutahato mfro rinakumor, “Lasaruse, wari-sinyana.” ");
INSERT INTO amp_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Be Lasarusr sinyahato yarim fnahna twanhomor. Rorhu tir wurami nyingatikt nohet yimam rir borirmoa rmonthaye kitf botfmomr. Be yuht rmontha kitf kihetr fnahnamor. Jisasr kfo memorm, “Nd rmontham kitf botfetm wayak nyusakafokahtkomr ayir.” ");
INSERT INTO amp_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Nd tuhant yindars Lasarusrhu nur kunys niahato Mariat rhunhoyukm, Jisasr Lasarusr kasinyamo yuhat htihato nd yiha hti memom, tu Bro Nkifrar kfo tkruraf mifmorr. ");
INSERT INTO amp_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Tfit wommn Farisimpno tfit yihato mkfo nuhas bonuhasmomm Jisasr nayuk nefm. ");
INSERT INTO amp_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Be ndnatn Farisimi prisroh tohak yimam Judaroh kaunserm yakhato kfo ttiwon memomm, “Nd yimar bok mirakerkfom hingrnewur. Niko finji dukewako, finji ananomr? ");
INSERT INTO amp_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nom be inji rihti marsisakrahnomr kmikmi rorrpar hikrahm. Bi kmikmi rorn mhikaknitm htirahko tfit Romrhu bro yufet yimam mrokfo napthakhato nieruhamn Bro Nkifrarhu temperr riyohniyakrahr ee yuht kantrikfot bha wohnirahmt.” ");
INSERT INTO amp_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Nd bro yimam rhumom tor wom yimar rhunhomorm. Rorhu yufat Kaiafasr. Rorn nd gunyjimr htamomr rroh bro tohak prisr. Ror wasinyahato kfo memorm, “Niko ka be tu nhai yima dukefm! ");
INSERT INTO amp_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Kangko yuht kantri bugat abha wohni duha rhumot, to be rpa yimarpar Judanmoh tkitt yakhato nohneft hifa. Nd dukefrpar hikkfot. Mirahko tfit wom dukefr ayaknom.” ");
INSERT INTO amp_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kaiafasr kfomo mrokfot nhai be turhu yima yuhurn ptharmor. Nhai. Ror nd gunyjimr prisroh tohakr tohetrn kfo htata mrokfeft kfo memor, Jisasr Judaroh tkitt yakhato nohrahr. ");
INSERT INTO amp_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","To mirahko ka Jisasr Judarpam dukahato nohmor. Nhai. Bro Nkifrarhu yonm wur fitoh fitoh tkitm riruh aruh hanyukroh yak nhafohhato rpa yimarhu yon kunys kanjo yak htaneft dukahato nohmor. ");
INSERT INTO amp_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Tor nd yiharn Judaroh bro yimam Jisasrhu was yuham ripthakmomm. ");
INSERT INTO amp_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Jisasrhu was mrokfot bi yiro yiro nakfo hafkniyettn Jisasr nhai Judaroh nyingahato yau nriyafrmoar. Ror mrokfot wany nkriyaf tanyhato nd kmit htanymortn yimor wom nungur tik furat yorhwa kmi Efraimtn. Ndha turhu disaipermpno tohmom. ");
INSERT INTO amp_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Nd kmit tohetmn Judaroh bro Pasofa burwa yihar rhumomr. Wuri wuri toh hanyuk yimam bi Jerusalem-rpar bi yi rifiny hanyhato rroh tamoh tamoh fasoh nefm bi yi hanyhato bi fak wus bowus hanymoumm. ");
INSERT INTO amp_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Jerusalemr yi rifinyhato tfit Jisasr fukatoh hambromoum. Yukatoh hambrohato tfit tum Bro Nkifra rmonrhu temper kmifar tohhato nakfo ttiwon nakfo ttiwon memoum, “Niko finji dukewako? Rore ka niahato rhunhorahrnom ndar nom yorhwa bro yihar o ka nhai?” ");
INSERT INTO amp_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Prisroh mtohak yimami Farisim bro mrokfot kfo memom, “Fitoh yimam Jisasr fitha htitwomr mrokfot bmbri nompno aniekahtt yakrahnomr.” ");
INSERT INTO amp_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Afo yuhre 6-pela yiham Pasofa burwathu rhuyuk yiham afo ruhetmn Jisasr Betaniko yimor. Nd kmi Betanit, Jisasr kasinyamo yima Lasarusrhu kmiyet. ");
INSERT INTO amp_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Betani thofm Jisasr htiyakhato you yeshrt yakhato Jisasrpno yimam rpat rhuhato nuwa famom. Martatn nd htamo yeshrt fak nhta nhombrahemotm. Yimam Jisasrpno rhuhato yeshri yamom, Lasarusr tor rhuhato fenyhomorm. ");
INSERT INTO amp_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mariat nd bro marukfoyet sanda knt yakhato Jisasrhu wuram fuk wunamotr. Yuk wunanihato tfit tuthu yuke tmarifaye trk domtmotr. Nd sanda knt yuk wunamohat mtha yarfon gbefr yuht kunys thu kasi bugamort. ");
INSERT INTO amp_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Mariat nd hingrneft Jisasr hingrnamottr tfit Jisasrhu wom disaiperr tu nd Jisasr hndhnaruha yima Judas Iskariotr, rorn kfo memor, ");
INSERT INTO amp_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Bar yimako, tamohmpno nd met Mariat yonmar bro marukfet sanda knt be wawurasohtt. Marifotnom, nd sanda knt 300 kinakfoye yimam wiknarfotmt tfit nd maruham yakhato wuskapa duha yimamn nd maruham hi hanyrfonom.” ");
INSERT INTO amp_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judasr nd mrokfot pthamohat nhai wuska duha yimaroh he mifneft dukahato kfo ptharmor. Turhu rikohneft kfo rhtimor. To rroh maru kpt to frohm yakitohhato yak nfhotimoamm? To ror. To rorn yakitohhato tfit rorn kak rikohmourm. ");
INSERT INTO amp_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Jisasr Judasr pthamo mrokfot wanyhato kfo memor, “Inji akfowah-komt. Aruhess nd sanda knt. Aharhu-kahttt afo nanhu nohhato yop yihar afo nierahr. ");
INSERT INTO amp_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Nd wuska duha yimam, rom yiha yiha nikompno toh hasiwum. Na, na nhai wom tohnhorhotanko.” ");
INSERT INTO amp_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Bok Judam wanymom Jisasrhu Betanithu toh nmbuhat, ndnetmn memom Betaniko yihato Jisasr htirahnom. To nhai be Jisasrhu htinefrpat marimom yirahnom. Nhai. Jisasr Lasarusr kasinyamo mrokfot bi wanyetmn, be memom Jisasr yi htihato Lasarusr htirahnom, ndnetmn yimom. ");
INSERT INTO amp_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ndnetmn prisroh bro yimam bi kfo habofkni htamom Jisas Lasarusrofhu rpat wasneft. ");
INSERT INTO amp_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Nhai be sfno nd Lasarusrhu wasneft kfo ptha kasinya-rmomt. Rroh dukeft duka memom, “Ni Lasarusnn, Jisasr kasinyamotrn Judam ndt wahtiyafhato prisroh bro yimaroh tngm bi yakhato yiho tuhaf tanywamm bi Jisasrn hikwom.” Nd dukefmpno memom, “Lasarusr awasnom.” ");
INSERT INTO amp_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Jisasr Betaniko Lasarusrhu kunys nuwa ye tanyhato nd wom marrn memor, “Yiruha Jerusalemko.” Bok met yindarim Jerusalemr turoh Pasofa burwat rifinymom. Wanymom Jisasrhu Jerusalemkorhof yi nmbuhat. ");
INSERT INTO amp_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Rom inji wanyhato yomkpo kanjohot twa gham yakmomn yihotoha yuhat toh gariyakmomr. Toh garihato yimotr rom grha hayuyak hanyhato kura het grhahato kfo hany memoum, “Wa! Wa! Wa! Tunga Nkifrara wayak marnyatwanr ndar Isrerroh kingr Brorhu yufatpno niewar.” ");
INSERT INTO amp_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jisasr yimohat donkir mrhumotr nd donkirn hiyau hanymorr. Ror donkir rhuhato yimohat to gonborngt kfoyuk mrokfot rhu hikmot. Nd mrokfot gonborngtn profet Sekaraiar kfo memor, ");
INSERT INTO amp_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Niko Saion thofko, mirahko ayakrmenom. Wahtiko nikmoh kingr bi donkiyenrn myorhtr hnewurr.” ");
INSERT INTO amp_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Jisasr donkir hanymohat Jerusalemko rorhu disaiperm nhai yima yuhu yakrmomt mrokfothu yimbu yuhat. Kto Jisasr nohhato sinyani bi bro yufat yaketrn nd mrokfothu yimbu yuhat fak dukamomt. Nd rom Jisasr kfo yindhorakhato namo neft gonborngt kfo hik twanhomott. ");
INSERT INTO amp_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Lasarusr yopt husfihus yiham rhuhato tfit Jisasr kasinyamohat bok tuhan yindarim Jisasrpno tohhato htimomr Jisasr Lasarusr nakuhato sinyamohat. Romn tfit wommpno yi rhuhato Jisasr namo neft naptha nuhas hi hanymom. ");
INSERT INTO amp_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Womm wanyhato ndnetmn Jisasr yihota yuhat toh gari hasomomr. ");
INSERT INTO amp_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Farisim inji htiyafo hanyhato tum rinakfo nakfo memom, “Niko htitko? Yimam bi rorrpar bi hikwom. Nom kangnom, akfo rafonomm, be nhai. Tuhan yindarim ror hingrnamo mirakerkfot naptha nuhas hihany, naptha nuhas hi hanitamn bi rorrpar kak hikwom.” ");
INSERT INTO amp_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Nd Pasofa burwa yiharhu lotuneft Judam niamohat wom Grik thofm rpat hik hnamomm Jerusalemko. ");
INSERT INTO amp_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Nd Grik thofm niahato afo Filifrpno yimom. Nd yima Filifr Galili profinsko kmi Betsaida thofer. Rorpno niahato mttiwon memomr, “Broye, nom kangnom, Jisasr ahtinom.” ");
INSERT INTO amp_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Yo be Filifr wany sanyhato Andrurpno mnahtiyaknihato Jisasr mkfo memofr, “Ni Grik thofm kangm, ahtinomn.” ");
INSERT INTO amp_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jisasr tfit kfo wok memorm, “Bro Najomrhu bro yufathu yak yihar bi brbohwor. ");
INSERT INTO amp_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Na kfo mifwanko, wit tpit nhai bbinysoft misuhhato nohrfot, to be inji rpa tpirpat rhuraht. Misuhtn fnoht, tfit frdborhahato sinyaruhatn dmet dmet hirrahmt. ");
INSERT INTO amp_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Yimar be turhu toh marnya nmbuhat mfro dukewur, kto nd toh marnya nmbuhat tfit hti hambrafrahrt. To fitoh yimar nda bbinysofthu toh marnya nmbuhat mong trohhato tfit nhai mfro dukakahrt, rorhu toh marnya nmbuhat toh nkifrarahr. ");
INSERT INTO amp_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Fitoh yimar nanhu yinhit tohwor, nd yimar na hikhnahato nanpno rpat tohkfot. Yimar nanhu yinhit tohrahr, nd yimar nanhu Yifemrn bro yufat hirahrr.” ");
INSERT INTO amp_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Jisasr tfit kfo memor, “Nanhu yima yuhur krhohato bok dukefm kekma. To finji kforhoya? Ka kfo miruha, ‘Bro Yifeme, na wofnkaha nd krhoparoh yakneft?’ Ka inji kforuha? Nhai. Na kanga finji anaya na nhai inji kfo rafokfot. Na to nd krhoparoh yakneftn niamoya. ");
INSERT INTO amp_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Bro Yifeme, ninhu yufat abrotwat.” Jisasr inji pthanimotr wom tngt yura hefen yuhat niamot. Nd tngt kfo memot, “Nanhu bro yufat bi fak nuhas hnamoyanm. Tfit wompam yak nuhasruhanm.” ");
INSERT INTO amp_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Jisasrpno brbo tohmo tuhan yindarim nd mrokfo kfo tngt wanyhato kfo memom, “Ka toher.” Womm memom, “We, ka mounmotr pthiwur.” ");
INSERT INTO amp_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Jisasr rroh mrokfom wanyafo hanyhato tfit kfo memorm, “Nda niko wanu tngt nhai nann dukahato nd tng yawihnarfot. Nhai. Niko dukahato nd tngt fawihnes. ");
INSERT INTO amp_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ar yiharn Bro Nkifrar nda bbinysofthu tuhan yindariroh nefm yak nhtarahrm. Yo nda bbinysofthu tndhr yak wahtarahrr. ");
INSERT INTO amp_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Na ndar bbinysoft tohhato bgre miyeta kasinya thombat tot nd yiharn nda bbinysofthu tuhan yindarim rpat nanpno yarim tohrahm.” ");
INSERT INTO amp_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jisasr nd mrokfot pthamohat turhu noh yuhathu mrokfo yuhatn kfo ptha nuhasmorm. ");
INSERT INTO amp_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Yo tfit nd rorhu mrokfom wany yakitohmo tuhan yindarim ttiwon memomr, “Bro Nkifrarhu boririfhut kfo kangt, ‘Nd yimar Bro Nkifrar tkrurafohato yimam minrfa htiyakruhar toh nkifrarahr.’ To ni tamohmpno inji kfo yamuka Bro Najomr bgre miyetr tuhegirrahmr? Nd yimare froher?” ");
INSERT INTO amp_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jisasr tfit kfo memorm, “Tor afo nukefenr. Nd nukefenrpno afo wawi-yauyauko. Nd wuroh nukefenr wuteh pskuyakrahr to be finji yihotat htihato yauruhako? Yimam nd yifungt wuyau-yauhato yak tato botatiwam nhai yihotat htikahmt. ");
INSERT INTO amp_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Niko wuroh nukefenr yorhwa fijo nd nukefenr yak hikhato nd nukefenrhu yonko rhurahko.” Jisasr met yindarimpno naptha buganihato be htanymorm. Htanymohat be yihato rhu kafrohmor. ");
INSERT INTO amp_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jisasr ar yonmari mirakerkfom hingrnamoahat nhai rroh yima yuhum sinyahato rroh bro dukefm rorn htarmoam. ");
INSERT INTO amp_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Rom inji namohat profet Aisaiar kfoyuk mrokfot fak hikmom. Profet Aisaiar to kfo memor, “Broye, nom pthiwa mrokfom frohm wanukamnom? Yo frohm nd ni hingrnewa bro hingrnefm htihato rroh yima yuhum sinyewamm?” ");
INSERT INTO amp_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Be nhai Jisasr nayuk nefm htihato yima yuhum sinyarmomm. Nhai be sfno Jisasrhu mrokfom hik duha yirmomm, tot tfit wom mrokfot profet Aisaiar kfo memor, ");
INSERT INTO amp_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Bro Nkifrar nyingam takunyj-motrm nhai yukatohruhatm, yo duka yima yuhum takih-motrm nhai tamoh mrokfom tfit dukakfot. Nyingetm rhuhato wom nefm htiruhamn, yo yima dukefetm rhuruhamn mrokfo mna yuham yakruhammn, yima yuhum yak kekuthato tfit nanpno yarim tohruhamn yak marnyaruhanm.” ");
INSERT INTO amp_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaiar nd mrokfot pthamohat Jisasrhu bro nanyjar bbukeft htihato inji kfomor. ");
INSERT INTO amp_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Jisasr mrokfom kfomoahat Judaroh bro yimam bokm wany yakiomoum. Tmift tafonthu yak nriyafneftne nhai. Farisim yakrme-moamn nhai yak nriyafrmoam. Memoum, “Farisim htirahmnom be nhai Judaroh rhu rifinyuk rmonm kfakruhatmnom.” ");
INSERT INTO amp_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Rroh dukeft be duka memoum, “Be yima mifmn akfo yindhor boyindhormnom.” Nhai marimoam, “Bro Nkifrarn akfo yindhorrnom.” ");
INSERT INTO amp_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jisasr buha yima rifiny swirtn nnhuhato kfo ptha memorm, “Fitoh yimam na wany yakiohato hikwom, to mirahko ka nanrpayann hikwom. Nhai. Na tkrurafoyuk Bro Yifemrpno rpat hikwomno. ");
INSERT INTO amp_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Yo frohroh nyingam nann kukatohwom nhai nanrpaya yukatohkahm. Nhai. Na kfo tkrurafyuk Bro Yifemrpno rpat kukatohwomno. ");
INSERT INTO amp_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ndar bbinysoft yiro kspitat rhumohat nann niahato kshr mifakitoh nuka-moyanr. Ndnettn yimam na hikwom nhai yifung kspt tohhato yak tato botatoruhatm. ");
INSERT INTO amp_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Yimam nanhu mrokfom hik duha yitam na nhai htihato tfit rroh nefm yak nhtahekahanm jasm kanjo. Na nhai ndhtet neft niarmoya. Na niamohat yimaroh minrfa htiyakneft niamoya. ");
INSERT INTO amp_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","To yimam na mong trohhato nanhu mrokfom yak duha yitam, tot rroh nefroh yak nhtayuk jaskfot. Nd na pthayuk mrokfotn jaskfot kanjo tu wuroh ndar bbinysofthu bati yihar yak nhtarahtm rroh nefm. ");
INSERT INTO amp_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nd na kfiwa mrokfom mirahko ka be nanhu yima yuhurhu mrokfom pthiwa. Nhai. Bro Yifemrhu yima yuhurhu mrokfom pthiwa. Na to rorn tkrurafomotra niamoya. Ror kfo hta bohtafoyuk mrokfomn na kfo pthiwa. Ndnettn nd na pthayuk mrokfotn jaskfot kanjo yak nhtarahtm rroh nefm. ");
INSERT INTO amp_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Bro Yifemrhu mrokfot tu hifa rhu nkifrani nmbuhat mhfnahnewutt, ndnatn nd na pthiwa mrokfot tu Bro Yifemr kfoyuk tng yuhatn kfo ptha hikwa.” ");
INSERT INTO amp_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pasofa burwathu rhuyuk yihar yibonmo marrn Jisasr rhuhato duka hik duka hikhato kfo memor, “Hrek marr yorhwanomn nohok nd Pasofat riruhakrahnomt. Be nda marrn asor nanhu wuroh yihar rhuyukr. Nohokn nanhu nohhato nda bbinysofthu htanyhato tfit tukanhu Yifemrhu yi yihar.” Jisasr nhai duka mmormoarm turhu disaiperm. Rorhu yima yuhur be romn rhumour. Noh-nefrpatpno mfafhonimorm. ");
INSERT INTO amp_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Nd wuroh marr rhumo krifn Jisasri disaiperm rpat rhuhato nuwa famom. Nd yiharn Saimon Iskeriotrhu yon Judasr, bi Satanr fasoh yima yuhu bebr htamorr Jisasrhu yahr kmimpno hndhnaneft. ");
INSERT INTO amp_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jisasr bi tur fak nhombramort Bro Yifemrhu bro bbukeft bi fakmort yo bi hti hikmort ror niamohat Bro Nkifrarpno wutoh tanyhato niamor tfit nohnineft tfit sinyanihato Bro Yifemrpno yirahr. Ndm bi tur hti hik bohik bugamormn, ");
INSERT INTO amp_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","be Jisasr wasinya fnahhato nuwa yeyuk tebort htanyhato turhu yuke hmbreshar yak hrur thumorr tfit trkthar yakmorn ndar nyuhmor. ");
INSERT INTO amp_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Bro dis yakmorn bupam tas hmbremort. Tas hmbrenihato nd bupaye turhu disaiperroh wuram yukaf hanyhato tfit nd ror nyuhmo trkthaye trkaf hanymourm. ");
INSERT INTO amp_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Yo be yima yimaroh wuram yukaf hany yukaf hanymorn memor, “Saimon Pitarhu wuram ayukanr,” Pitar sinyahato kfo memorr, “Broye, nine nanhu wuram kangn ayuka?” ");
INSERT INTO amp_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Tfit Jisasr Pitar wahtiyak hti hamuhhato kfo memorr, “Ni nhai tawisafkahnt nda na hingrniwa hingrneft. Kto tawisafrahnt.” ");
INSERT INTO amp_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pitar kfo memorr, “Mirahn nanhu wuram ayukanr. Mirah mifn.” Jisasr inji wanyhato tfit kfo memorr, “Nhai ninhu wuram yukrfoyann, nhai nanhu disaipern rhuruhatn.” ");
INSERT INTO amp_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Saimon Pitar Jisasr pthamo mrokfot wanyhato tfit kfo memorr, “Broye, kangn ayukanr, to btn mirahn wurarpam ayukanr. Tirfi mfhat rpatn wayuktwona.” ");
INSERT INTO amp_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jisasr tfit kfo wok memorr, “Yimam bi yuht yimam yuketm nhai tfit wompam yukkfot. Bdr wurarpam yukkfot. Bi wurarpam fukme, yuht yimam fnhu bugewum. Nikmoh thatipm fnhu bugewumko. To nhai be niko buga kfokaha. Nhai.” ");
INSERT INTO amp_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jisasr inji kfomohat bi htimor turhu wom disaiperrn yahr kmiroh tirm htarahrr. Ndnetrn kfo memor, “Nhai niko buga kfokaha.” ");
INSERT INTO amp_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Jisasr disaiperroh wuram yuk buganimormn tfit tur hmbremoa yuke hmbreshar hmbrenihato rim rhumor tur rhu tanymo tkittn. Rim rhuhato ttiwon memorm, “Niko tawisafwoko nd na nefinefthu yimbu yuhat? ");
INSERT INTO amp_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Niko kutewukma Tisaya yo womnam kutewukma Bror. Rot hifa inji kutewukma. ");
INSERT INTO amp_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Na nikmoh Tisaya yo na nikmoh Broya nikmoh wuram fukanko. To niko, nd na yak nuhasefi yuhatn niko tuko wuram nayukkfot. ");
INSERT INTO amp_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Na bi fak nuhasanko to be nd yuhatn wahiktwako. ");
INSERT INTO amp_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Wawanyko, na kfo mifwanko, hingrna yimar be turhu tohak yimarhu yinhit tohwor. Yo mrokfot hanyuk yimar nhaf kfo tkrurafyuk yimarhu yinhit tohwor. ");
INSERT INTO amp_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Bi fekkomt nd na yak nuhasefinefthu yimbu yuhat. Nd yuhatn hingrna hikrahko tfit tuko rhu nmbuhat hifa yiruhatt tfit yindhorrahko. ");
INSERT INTO amp_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Na nhai nikom buga kfokaha. Na tawisafwanm tukanhu yufatpno bi kfo htatayukm. Yo tuka bi htitant nd Bro Nkifrarhu gonborngt bingot htamot tu yimbuyefett rhuraht. Nd mrokfot kfo kangt, ‘Yimar, nanpno nuwa yenyho-yukrn, bi toh kekuthato nanhu wasyuk wajis hatonemort.’ ");
INSERT INTO amp_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Tafi nd neft mfrpskena duha bi kfo nuhaswanko. Kto nd neft mfrpskena thombat tfit nikmoh yima yuhum nanrpaya htahato kfo mirahko na to nda, tu Bro Nkifrar kfo tkrurafyuka. ");
INSERT INTO amp_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Na kfo mifwanko, frohr na tkrurafoyuk hingrna yimar yakmiyakhato fak marnya bomarnyerr, nd yimar nann yakmiyakhato kak marnya bomarnyewur. Yo nd yimar na yakmiyakyukr, nhai be nann yakmiyakkahr. Nhai. Nd na tkrurafoyuk Bro Yifemrn kakmiyekwor.” ");
INSERT INTO amp_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jisasr nd mrokfom kfonihato tfit yima yuhur rimortakihato kfo memorm, “Na kfo mifwanko, nikmoh womrn hndhnarhotra wasrahma.” ");
INSERT INTO amp_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Jisasr inji kfomotr disaiperm tfit tum rinahti nahtihato nattiwon memom, “Nd ror kfi mrokfote frohr kfir?” ");
INSERT INTO amp_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Wom disaiperr Jisasr mfro yuhu mongimoar, ror nuwa yeyuk tebort rhumohat be Jisasrpno brbo rhumor. ");
INSERT INTO amp_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Saimon Pitar nyingaye rikfo memorr, “Wattiwonnr, frohr kfir.” ");
INSERT INTO amp_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Be nd disaiperr brbo rhu kekutni hanyhato ttiwon memorr, “Broye, ni kfi yimare frohr kfi?” ");
INSERT INTO amp_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jisasr tfit kfo memorm, “Frohr bretpat yekantn nnari disn bretpat tayifakhato fahuya, tor nd yimarn hndhnarhotra wasrahma.” Inji kfonihato bret nuwat yakhato watayifakhato rihemor Saimon Iskariotrhu yon Judasrn. ");
INSERT INTO amp_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judasr nd bret nuwat yakhato famort. Fenyi hanymort Satanr fkne twanhomorr. Jisasr kfo memor, “Judase, kangn finji anaya, to be asomif fura mrom wayakn. Mirahn wom kukna hatoha.” ");
INSERT INTO amp_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Nd yima bugam nuwa yeyuk teborthu mku mku rhu wohnmom, nhai yakrmomt nd Jisasr kfomo mrokfothu yimbu yuhat. ");
INSERT INTO amp_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Judasrn maru gegb yoht haruhetrn, Jisasr inji kfo pthamohat disaiperm duka memom, “Ka Pasofa burwat rhuruha bro yiharhu yeyuk yeshri wiknaneft kfirr. O ka wuskapa duha yimaroh hayuk wuskaroh wikna hanyeftn kfirr.” ");
INSERT INTO amp_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Be nd nnaripam tayifaket bret tifenr Judasr yak yenyimorr fnahnimor. Yihat bi wufak bugamot. ");
INSERT INTO amp_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Nd yima Judasr fnahnimotr Jisasr kfo memor, “Be bi asor bi Bro Najomanhu bro yufathu yak yihar. Na nohruha noh nmbuhatn Bro Nkifrar bro yufat yakrahr. ");
INSERT INTO amp_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nanhu nohneftpno Bro Nkifrar bro yufat yakruha yuhatn tawo Bro Nkifrar sinyahato be yudbat bro yufat hirahra. ");
INSERT INTO amp_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","O arenko, bi brbohwor nikmoh htanyuk yihar. Hti hasiwokma tfit hti hambraforahkma. Judam rpahtet mrokfot kfo nuhas-moyanm yo tfit nikompno rpahtet mrokfot pthiwa. Na yiruha yihotar nikom nhai yau hikruhatkomr. ");
INSERT INTO amp_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Bi wom nfri boririfhu mrokfot kfo nuhas tanywanko. Niko rpa rpa yimako wommpno nayak marnyahato rpat tohkfot. Niko nanhu tirtn rhu bugamoko. Tawo niko wommpno nayak marnyahato rpat tohkfot. ");
INSERT INTO amp_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Niko wommpno nayak marnyahato tohrahko, wom riruh aruhyukm htiruhamn kfo mirahm, ‘Ndm tu Jisasrhu disaiper mifem.’” ");
INSERT INTO amp_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Saimon Pitar warhuhato Jisasr kfo ttiwon memorr, “Broye, ni fitoko yiruha?” Jisasr kfo memorr, “Na yita yuhat ni nhai hik hnewotna. Kto mongkorne ee btn nierahn.” ");
INSERT INTO amp_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Tfit Pitar warhuhato kfo ttiwon memorr, “Broye, to tamohmpno nhai hik hnewotann? Na kanga, nann hikhato nann ninhu nohyuk tkitt yakruhant.” ");
INSERT INTO amp_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jisasr inji wanyhato tfit kfo ttiwon memorr, “Tu kfo mif mifwona? Na kfo mif mifwann, krirhu naku tngt tafi wany juha, husfirpa kfo namhit kfo namhi kangnm, ‘Na nhai tawisafkahanr Jisasr.’” ");
INSERT INTO amp_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jisasr tfit kfo memorm, “Niko nda mrokfot wanuk-wohat mirahko bok dukefm ayakkah-nomn yima yuhum akrhomnom. Nikmoh dukefm be Bro Nkifrar duka yo na duka, be nd dukefrparpno rhukfot. ");
INSERT INTO amp_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nanhu Yifemrhu kmir yonmari yonmari kuny rmonr korhr. Ndnatn na yi shombat nikmoh kunyroh bi yak hta hanyneftn bi yi hanyruha. Be kuny rmon duha arhut na nhai inji kfo tany hanyrfotanko. ");
INSERT INTO amp_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Na yi shombat kuny rmonm yak marnya hta tanyrhoyanmn tfit niahato miyak htiyakhato be rpat yihato rpat nanpno rpat tohrahnom. ");
INSERT INTO amp_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Na yita kmikorhof yi yuhat niko bi htiyeteko.” ");
INSERT INTO amp_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tomasr inji wanyhato ttiwon memorr, “Broye, ni kfiwa yihota yuhat nome nhai tawisafkahnomt. Tone fitoh yuhatn nieruhanom?” ");
INSERT INTO amp_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Tfit Jisasr kfo memorr, “Yimam kangm Bro Nkifrarpno ainom, nann yihotaya, yo nann Bro Nkifrar fak nhombranamor, yo nann toh nkifrayuk yafothat yimam kahukanm. Nhai wom fitoh yuhamn yimam Bro Nkifrarpno yikfot. Tu be nhai mif. Nanrpayanpno niakfot. ");
INSERT INTO amp_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Bi ahti tawisafkma, nanhu Yifemr hti tawisafrfokomr. Ariham bi hti hik bohikwakomrn bi tawisaf-wokomr.” ");
INSERT INTO amp_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filifr wom ttiwon mrokfot wakfo memor, “Broye, nom kamuknom, Bro Yifemr wayak nuhaskahtnom nmoh yima yuhum mirhurahmnom.” ");
INSERT INTO amp_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jisasr tfit memor, “Filif, ni tamohmpno kfo yamuka, ‘Bro Yifemr wayak nuhasnnom?’ Ar yonmar yiham nikompno toh hnamohate ka nhai hti tawisafrmokma? Yimam na htitwom, to Bro Yifemr htitwom. To tamohmpno tfit kfo yamuka, ‘Bro Yifemr wayak nuhasnnom?’ ");
INSERT INTO amp_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ni ka nhai duka mikahn na Yifemr thu hamuhmoya yo Yifemr na thu hamuhmora? Nani nanhu Yifemrpno nnoh toh nmbuhat nhai nndo nndo. Mrokfom na niko kfohemoam nhai be nanhu tngtn ptha hnarmottm wany hnarmokomm. Nhai. Bro Yifemr nann mrhuhato mrokfom ptha hnehato mirakerkfom hingrna hnamor. ");
INSERT INTO amp_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Na ptha yamu-kohat na Yifemr thu hamuhmoya yo Yifemr thu hamuhmora, nd mrokfot na kfiwat wawany yakiotwakomt. To nd na pthayuk mrokfomn nhai wany yakiokahkomme, tfit na hingrna hnamo mirakerkfomn dukakhato wahiktwokma. ");
INSERT INTO amp_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Na kfo mifwanko, frohm rroh bro dukefm nann htewuma, nd na niwa nefm nd yimam narahmm. Uwa, ndt nhai be kfo furakfot kfokaha. Na Bro Yifemrpno yi tohruha. Ndnettn rom naruha nefm tu bro nefm narahm. ");
INSERT INTO amp_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Tamoh tamohm nanhu yufatpno kfo ttiwonrahko, hiruhanko. Nd yuhatn Bro Yifemr bro yufat yakrahr. ");
INSERT INTO amp_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ndt to bi kfiwant tamoh tamohm nanhu yufatpno kfo ttiwonrahkoma, hiruhanko.” ");
INSERT INTO amp_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Jisasr tfit kfo memorm, “Nikmoh yima yuhum nanpno korhme, na pthayuk mrokfom yak hik marnya bomarnyarahkomm. ");
INSERT INTO amp_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Na yi shombat nanhu Yifemr kforhotanr nikmoh toh tamnouhato thu bmtayukr kforuhatrr yawihnehato be nikompno toh nkifranirahr. ");
INSERT INTO amp_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Nd toh tamnouyukr nieruhar to Yafothar nieruharn toh tamnourahrko. Nd Yafotharn yimam kak nuhas bonuhasworm Bro Nkifrarhu tu yafothet nef mifm. Ndar bbinysof thofm nhai hti tawisafkahmr, ndnettn nhai rom yakkfot. To niko awi nd Yafothar nikompno yorhwarn hti tawisafwokomr. Kto nd Yafothar mithu nawohrahrko. ");
INSERT INTO amp_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Na yi shombat nhai mong trohnihato yon kutenm kanjo yak mmbrafiny hasoruhatko. Nhai. Tfit niahato mihtiruhanko. ");
INSERT INTO amp_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ndar bbinysof thofm wurohpam hti hasiwuma hti hambrafrahma. To niko awi hti hanyrahkoma. Na nohhato tfit sinyaruha. Niko to inji nohhato tfit sinyarahko. ");
INSERT INTO amp_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Na nohhato tfit sinyarhota, nd yiharn hti dukarahko nani nanhu Yifemrpno nnoh toh nmbuhat nhai nndo nndo yo nikomi na nmoh toh nmbuhat nhai nndo nndo. ");
INSERT INTO amp_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Yimam nanhu boririfhu mrokfom yakhato kak hik marnyewumm, rroh yima yuhum nanpno korhm. Yo nd yimam nanhu dukefr yorhwam nanhu Yifemr hifa yima yuhur hmbritrm, yo na hifa yima yuhur hmbrihato rompno mfnahhato yak nriyafruhanm.” ");
INSERT INTO amp_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jisasr inji kfomotr tfit Judasr, nhai tu Judas Iskeriotr, wom nndoh Judasr kfo ttiwon memorr, “Broye, tamohmpno nomrpanompno yak nriyafhato ndar bbinysof thofmpno nhai yak nriyafruhatn?” ");
INSERT INTO amp_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jisasr kfo memorr, “Yimam rroh yima yuhum nanpno korhm, nd yimam na kfo nuhasyuk mrokfom hikrahmm. Mrokfom hikruhatmm nanhu Yifemr hifa yima yuhur hmbrihato to be nani nanhu Yifemr rompno yihato tohnhorahnonm. ");
INSERT INTO amp_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Yimam nhai tu rroh yima yuhum nanpno rhukahm, nd yimam nhai nanhu mrokfom hik marnyakahmm. Nda niko wanuka mrokfom nhai be na tukanhu dukefrhu mrokfom ptha nuhaskahanko. Nhai. Na kfo tkrurafyuk Yifemrhu mrokfom kfo ptha nuhaswanko. ");
INSERT INTO amp_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Na nikompno afo tohwa fijo nda mrokfom bi kfo ptha nuhas tanywanko. ");
INSERT INTO amp_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nikmoh toh tamnouyuk Yafothar, Bro Nkifrarhu Yafothar nierahr. Nanhu yufatpno Bro Yifemr tkrurafruhatrr nierahr. Rorn nikmoh dukefm yak hta bohtaruhatrm na ptha nuhas bonuhas hnamo mrokfom dukarahkomm. ");
INSERT INTO amp_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Na bi htanywanko. Niko rhu haso thombat mirahko tamoh tamoh dukefmpno arhunom. Tamoh tamoh dukefm yafhohato be warhu furatwako. Nanrpaya ndhtet yindhor yima yuhur kahukwanko, nhai ndar bbinysof thofr ndhtet yima yuhur herfotrko. ");
INSERT INTO amp_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Bi wanukma kfo yamuhat yirhoyann tfit nieruha. Nanhu Yifemr yura mtohekwor, na be rorhu yinhitn ritohtewa. Ndnettn nikmoh yima yuhum nann korhm, be nanhu yinyeft be hti yindhorrahko. ");
INSERT INTO amp_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nd neft tafi mfrpskina duhattn bi kfo nuhastewanko. Tfit kto nd neft mfrpskinaneft tukmoh nyingaye htiruhakomn na kfoyuk mrokfom wany yakiorahkomm. ");
INSERT INTO amp_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Nhai tfit wom ptha hatohwota. Nda bbinysofthu tndhr bi tor bi niewur. To ror nhai nanhu toh nmbuhat yak hta bohtakahra. Nhai. Bro Yifemrhu dukef yuhat hikwa. ");
INSERT INTO amp_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Tmift kanga na tukanhu Yifemrhu dukeft rhuhato rorhu mrokfom hikwa yuhat afo ndar bbinysofthu met yindarim afo yak nuhaskahtanm ahtim. Be tmifko wasinyakahtko ainyom.” ");
INSERT INTO amp_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Jisasr tfit wom mrokfot kfo memorm, “Na tu wain tof mifa. Nanhu Yifemr wain swir tikater. ");
INSERT INTO amp_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Na nd wain tofanhu yuhtam yukha hir duha yitam wain tof tikatr puk thuworm. Nd yukha hiret yuhtarpam be frtept wusworm yukha hir marnyaneft yihato. ");
INSERT INTO amp_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Niko bi nd na pthaheyuk mrokfotn bi fak wus bowus marnyamottko be bi yukha hir yibonwoko. ");
INSERT INTO amp_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ndnettn nanpno niko frtkafhato na nikompno frtkafruha. Nhai wom wain tofthu yuhtam mmem toftpno nadodru duhatm yukha hir furakahm. Nhai. To inji kanjo niko nanpno frtkaf duha yirahko be nhai yukha hirruhatko. Nanpno frtkafrahko ee btn yukha hirrahko. ");
INSERT INTO amp_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Na tu wain tofthu mmem tofa. Niko wain tofthu yuhtayeko. Yimam nanpno frtkafhato na rompno frtkafneft nd yimam yukha hirneft yuhtam be yihohathuwom. Nhai hir ffhirmkahm. Na duha nhai wom finji naruhatko. ");
INSERT INTO amp_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nanpno frtkaf duha yita yimam kak thuwomm yuhtam puk thuhato fftewa kanjo. Kto nd ffyuhtam yak nhafohhato kandhi thuwomm. ");
INSERT INTO amp_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Niko nanpno frtkafhato nanhu mrokfot yakhato yakitohrahkomt, nhai mrokfom, tamoh tamohm ttiwonneft, to be tukmoh duka fijo kfo ttiwon-ruhatkomr hirahrko. ");
INSERT INTO amp_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Niko nanhu disaiper mifko rhurahko tu mfro mfro hir nattrahko. Ndtpno nanhu Yifemr tfit bro yufat yakrahr. ");
INSERT INTO amp_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Na be Bro Yifemrhu yima yuhurn korhwa. Nd yuhatn tawo nanhu yima yuhur nikomn niamor. Yiha yiha niko be nanhu duka yima yuhurn rhukfot. ");
INSERT INTO amp_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Na Bro Nkifrarhu boririfhu mrokfom hikhato rorhu yima yuhur rhumo kanjo niko na hayuk boririfhu mrokfom wany yakiohato hikrahkomm, nanhu yima yuhurn rhurahko. ");
INSERT INTO amp_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Na inji kfiwohat nanhu dukeft duka kanga, nanhu yindhor rifhur nikomn arhukahrn be nd bro yindhor yima yuhurparn arhurko. ");
INSERT INTO amp_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Na wom mrokfot kfiwanko: Niko tuko niyak marnya niyak marnyakfot na niko dukahato nikmoh rhu nmbuhat yak marnyamo kanjo. ");
INSERT INTO amp_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kfiwanko, Kfiwanko, wom yimar yimat tohtn yimatm dukahato fnohr, tot tu yimat toheft. ");
INSERT INTO amp_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Nanhu kfoyuk mrokfo yuhat hikrahko, nanhu yimatko rhurahko. ");
INSERT INTO amp_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Na nhai wom kfo mekaha, ‘Arm hingrna yimayem.’ Nhai. Hingrna yimam nhai turoh tohak yimam hingrnewa hingrna yuham tawisafkahm. To na Bro Yifemrpno yakmo mrokfom bi ptha dbruf nuhasmoyanko. Ndnetann kfo kanganko, niko nanhu yimateko. ");
INSERT INTO amp_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Na nhai nikomn yakrmokma nikompno tohneftn. Nhai. Nann fakmoyanko. Nann yakhato hingrneft hemoyanko. Memoya nd hingrneft wayakni waikahkomn niko hingrnayuk hingrneft fipett rhuhato yukhett rhuraht. Tu rhu nkifraniyet yukham hirrahm. Ndnettn nanhu yufatpno Bro Nkifrar wom shrm ttiwonrahkomr be hirahrko. ");
INSERT INTO amp_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ndnettn boririfhu mrokfot kahukwanko. Nikmoh womm marbit htakfot.” ");
INSERT INTO amp_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Jisasr tfit wom mrokfot kfo memorm, “Nda bbinysofthu yimam hti dbnotwomkone, mirahko ayak mmonom. Nhai be ar nohofrpa nikomrpakompno inji nakahm. Nhai. Nanpno to inji namom. ");
INSERT INTO amp_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Be nda bbinysoft tohwa yimaroh ruheft arhuko, yakmiyakhato hifa yima yuhur hmbrerfomko. To nhai. Ndar bbinysofthu yimampno toh hasetkomn yakmotanko rom tfit kfo kangm, ‘Tamohmpno frtrohwamnom?’ Ndnetmn namburhato hti dbnotwomko. ");
INSERT INTO amp_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Waduka hik marnya hanyswako na kfoyuk mrokfot. Wom hingrna yimar turhu tohak yimarhu yinhit tohwor. Ndnettn rom ahti dbnotma, niko to inji hti dbnotrahmko. Nanhu mrokfom ayak hikmm, to inji nikmoh mrokfom hikrahmm. ");
INSERT INTO amp_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","To nhai. Rom nhai tawisafkahmr na kfo tkrurafoyuk Bro Yifemr. Ndnetmn niko bi nanpno yarim fnahnehato tohwatko be hti srthurahmko. ");
INSERT INTO amp_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Na nia duha yihato Bro Nkifrarhu mrokfom aptha nuhas duha yiyanm be nd rom nayuk fasoh nefm be nhai mrokfo duhatm rhurfom. To nhai. Arihat bi mrokfot wanyetmn to be nhai nd rroh fasoh nefroh kamongyuk tkitm. ");
INSERT INTO amp_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Fitoh yimam na hti dbnotwoma, to nanhu Yifemrn hti dbnotwom. ");
INSERT INTO amp_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Be na niahato rompno tohhato nd yimam hingrnawon duha bro bro nefm ahingrna duha yiyanm, be rom nayuk fasoh fasoh nefm mrokfo duhatm rhurfom. To nhai, na nayuk miraker-kfom bi turoh nyingaye htimommn tfit hti dbnotwomno nanhu Yifemrpno. ");
INSERT INTO amp_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Nd rom nayuk nefm to bi turoh boririfhut kfomo mrokfo yuhatn bi kak hikwom. Nd mrokfote inji kfiwut: ‘Be hti dbnot furamoma.’ ");
INSERT INTO amp_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Nikmoh toh tamnouyuk Yafothar Bro Yifemrpno tohwor. Nd Yafothar tu Bro Yifemrpno tohhato tawisafwort tu Bro Yifemrhu rhu toheft. Bro Yifemrhu rhu toheft tawisafhato yimam kak nuhas bonuhasworm Bro Yifemrhu tu yafothet nef mifm. Na yihato tkrurafrhotanr nierahr nikompno. Nd Yafothar nieruharn nanhu nefm yo hingrneft ptha srh nuhasrahrko. ");
INSERT INTO amp_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Yo to niko inji buga waptha srh nuhas-twakomm nanhu hingrneft. Na rihingrnakmohat niko tohnhohato htimokomt nanhu hingrneft. Ndnettn ptha srh nuhaskfot yimam.” ");
INSERT INTO amp_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Na nhai wofnkaha niko Bro Nkifrarhu mrokfot miyafhonineft. Ndnatn nd mrokfot kfiyanko. ");
INSERT INTO amp_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Judaroh rhu rifinyuk rmonm kfo yiritikfot kforahmko. Yo wom yiham was beb bobebrahmko. Rom inji na thombat mirahm, ‘Nom Bro Nkifrarhu dborioh nefm newunom.’ ");
INSERT INTO amp_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Nd yimam niko ufasoh nefm naruham nhai Bro Nkifrar tawisafkahmr yo na nda tohwohat nhai hti dukakahma. Nhai. Ndnettn nd fasoh nefm narahmko. ");
INSERT INTO amp_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Bi kfo nuhasanko nd yimam naruha ufasoh nefm. Kto ndhtet nefm htitnomm tfit wadukatwakomt ndar na kfo nuhaswa mrokfot.” Jisasr kfo memorm, “Na nikompno tohmohat nhai nd nd mrokfom kfo nuhasrmoyanko. Bi tukanhu Yifemrpno yiyuk yiham bi abrboh hnam, ee btn kfo nuhasmoyanko. To nhai. Yiham afo wuri ruhetmn ndnettn nhai kfo nuhasrmoyanko. ");
INSERT INTO amp_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","To be bi kita tukanhu Yifemrpno. Tur kfo tkruraf-motra niamoya. Ndnetann bi tfit kita turpno. To niko nhai kfo ttiwon mikahkma, ‘Nine fitohko yita?’ ");
INSERT INTO amp_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Na bi inji kfiwota nikmoh yima yuhum bi rinur finywom. ");
INSERT INTO amp_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Na kfo mifwanko, nane sinya troh tanyruhanko. Hifa inji sinya trohruhanko. Na sinya troh tany shombat, Bro Yifemrpno muhruha. Rorpno yirhoyann tfit nd toh tamnouyuk Yafothar kfo tkruraforhotanr thu hamuhrahrko. ");
INSERT INTO amp_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nd Yafothar nieruharn nda bbinysofthu tuhan yindarim yak nuhasrahrm fasoh fasoh nefm niewa yihotam, yo yimaroh toh marnyahato yima yuhum wutham rhuneft, yo ariham finji finji toh marnyahato Bro Nkifrarhu kotkfot mrokfo duhatm rhurahm. Nd ndm Yafotharn yak hta bohta nuhasrahrm. ");
INSERT INTO amp_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","To frohmn fasoh fasoh niwa yihotam hikwam? To nd na hik duha yita yimam, romn nd yihotam hikwom. ");
INSERT INTO amp_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","To frohmn Bro Nkifrar hti wuthewar? Nhai wom frohm hti wuthakahr. Ndnettn nann nohhato Yifemrpno yihato nhai wom htirhotkma. ");
INSERT INTO amp_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","To frohmn Bro Nkifrarpno mrokfetm rhuruham? Nda bbinysoft thu yurmo tndhr, rorn bi Bro Nkifrarpno mrokfeter. Ndnettn yimam nd tndhr hikwam to rom inji buga Bro Nkifrarpno mrokfetem. ");
INSERT INTO amp_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Rom tom nanhu yima yuhur yorhwa bok mrokfom. Htitanko nhai yimbhindangm tohetohkahmko nanhu mrokforoh yakneft. Ndnatn nhai ptha dbruf nuhas bugewotanko. ");
INSERT INTO amp_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Kto Bro Nkifrarhu yafothet mrokfot mhfnahwa Yafothar yak nuhas bonuhasrahrko Bro Nkifrarhu tu yafothet nef mifm. Nd Yafothar nieruharn nikmoh yima yuhum yak hta bohtaruhatrko nd yiharn yak dukarahko nd na pthayuk mrokfom. Nd Yafothar pthayuk mrokfom nhai be turhu fijo ptha fura bofuraruhatr. Nhai. Mrokfom na kfo nuhasyukrpam ptha nuhashirahrko. Yo ktopakto rhu hanyruha tamoh tamoh nefm yak nuhasrahrko. ");
INSERT INTO amp_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Na harhuyuk mrokfo rifhur rorn yakruharr pthahirahrko. Ror nayuk tamoh nefm nann bro yufat yakruha. ");
INSERT INTO amp_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Bro Yifemr harhuwa tamoh tamoht nanuhet. Ndnettn kanganko, nanhu mrokfo rifhur rorn yakruharr kfo nuhasrahrko.” ");
INSERT INTO amp_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Jisasr tfit kfo memor, “Bi brbohwot nanhu yinyeft. Afo hti hambrafrahkma, ee tfit toh hany tefihato tfit htiyakrahkma.” ");
INSERT INTO amp_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Jisasr inji kfomotr wom disaiperm wanyaf hanyhato tum rinahti nahtihato kfo memom, “Ror kfi mrokfothu yimbu yuhat finji yorhwat? Kfo famur, ‘Toh tefi hasiwakomn hti hambraforahkma yo tfit toh tefinihato tfit htiyakrahkma.’ Yo womt kfo famur, ‘Ndnettn nann nohhato Yifemrpno yihato nhai wom htirhotkma.’” ");
INSERT INTO amp_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Yo kfo memom, “To nd wom mrokfot kfo famur, ‘toh tefinihato,’ nd mrokfo nmbuhat afo myak mmotewunomt nd mrokfo nmbuhathu yimbu yuhat.” ");
INSERT INTO amp_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jisasr bi htimorm rom ror pthayuk mrokfot myak mmotamohat. Jisasr inji htihato kfo ttiwon memorm, “Nikome nd na kfo yamu, ‘Toh tefi hasiwakomn hti hambraforahkma, yo tfit toh tefinihato tfit htiyakrahkma,’ ndtn kak mmotewuko? ");
INSERT INTO amp_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Wawanyko! Na kfo mifwanko, niko nur dungunangurahko. Ndar bbinysofthu tuhant yindars rom nhai inji naruhatm. Rom be yindhorhato rhurahm. To nhai mrokfom. Niko warhu dungunangu-twako. Kto tfit niko rhu yindhorrahko. ");
INSERT INTO amp_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Wom kfo nhombra mrokfot akfoyant. Wom mett yon yak yibonraht rhu kurhiwatn bro krhopam kekwot yon yak yihar. Krhopam yak hanitatn bi yonr fnurnir, bi be. Nd yonrn tfit bro yindhor nmbuhat hnewurt, nd rot hatoh hasoyuk krhopam nhai wom dukakahtm. ");
INSERT INTO amp_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Niko inji narahko. Nikmoh yima yuhum krho hasoruhamn kto na nikompno nahtiruha yiharn tfit nd krho yima yuhum yohniruhamn tfit bro yindhor nmbuhat yakrahko. Niko yakruha yindhoreft nhai yimam yak nohruhatmt. ");
INSERT INTO amp_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Nd yihar mfrpskina thombat niko nhai nanpno wom tamoh kfo ttiwonruhatko. Na kfo mifwanko, tamoh tamohm nanhu yufatpno Bro Yifemr kfo ttiwonrahkomr, be yakhato wahirahrko. ");
INSERT INTO amp_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Niko toh hnamo yiham niko nhai inji nawon-rmoko. Afo ariham wanhombrawon-twako. Afo Bro Yifemr nanhu yufatpno wom shrm wakfo ttiwon wontwakomr. Inji ttiwonhato fekkomm, htirahko tfit bro yindhoreftpno rhurahko.” ");
INSERT INTO amp_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Jisasr tfit kfo memorm, “Ariharhof mrokfom kfo nhombra mrokfompno ptha nuhas hnaroyanko. Kto nhai kfo nhombra mrokfompno kforhotanko. Tamoh tamoh rim kfota mkfota mrokfom Yifemrhum be kfo hik bohik nuhasruhanko. ");
INSERT INTO amp_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Kto nd yihar be nanhu yufatpno tamoh tamohm Yifemr kfo ttiwonrahkomr. Nhai nann tfit nikmoh mrokfom Yifemrpno kfo ptharhotanm. ");
INSERT INTO amp_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Bro Yifemr hti wofnworko. Nhai be sfno inji hti wofnrfotrko. Na hti yindhorhato niko na htimohat, duka memoko, ‘Ndarr Bro Nkifrarpno niamo yimayer.’ Ndnettn Bro Yifemr hti wofnworko. ");
INSERT INTO amp_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Na afo Bro Yifemrpno wutohmoa. Tfit Yifemr wuhtanyhato ndar bbinysoft fawihnamoya. Tohmoyann be bi tfit kanga ndar bbinysoft htanyhato tfit Yifemrpno aiya.” ");
INSERT INTO amp_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Tu Jisasrhu disaiperm inji wanyhato kfo memom, “Nd mrokfom asomif ni pthem, nhai be kfo nhombra mrokfom kanjo ptharfonm. Ptha hik mifnm. ");
INSERT INTO amp_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nom bi hti hik bugewunomn tamoh tamoh mrokfom yimam duka kkopenhato hus yima yuhetem, ni bi htitnm. Nhai afo mekahn, ‘Afo turoh tnge kfo ttiwonrahma.’ Ndnatn nom inji htitanomn kangnom, a to Bro Yifemrpno toh tanyhato niayetrn tamoh tamoh dukefm bi htitrm.” ");
INSERT INTO amp_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Rom inji kfomotm tfit Jisasr kfo memorm, “Bi duka ppohato bi hti duka tungunewukma? ");
INSERT INTO amp_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Wawanyko! Na kfo hnamohat to be bi yihayer. Rpen rpen hik tubatuyafruhamko na turpetena tuhaf tanyrahko. To mirahko ka nhai nanhu wom frohr. Nhai. Tor nanhu Yifemr. ");
INSERT INTO amp_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nanhu dukeft kanga nanpno wafrtkafkahkomn be rhu mmorahko. Ndnetann nd mrokfom kfo pthiyanm. Niko nda bbinysoft toh thoft, to ka mirahko ka be toh yindh-orrahnom. Nhai. Krhopam yakrahko. To mirahko riyakrmiyakhato arisuhak-nom. Toh bmtakfot. Bi nann ndar bbinysofthu bbukeft mano mano fahot tkafmoyant.” ");
INSERT INTO amp_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jisasr turhu disaipermpno mrokfo kfo pthahe buganimormn yura hefenr wuyukatohhato kfo bruttna memor, “Bro Yifeme, be bi asor bi yihar. Ninhu Yonr bro yufati bro nanyjar bbuka rifhur wahenr. Wahekahtnr tawo ror hingrnayuk hingrneftn ni tfit bro yufat yakrahn. ");
INSERT INTO amp_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","To bi rorhu tirtn ninhu hingrneft htamont. Rorn tuhan yindariroh bro tohak yimar fak htamo. Ni hayuk yimam rorn toh nkifraniyuk yafothar kahukrm. ");
INSERT INTO amp_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Yimam ni htihato duka kangm, ninrpa tu Bro Nkifraye, yo Jisas Kraisr tu Bro Nkifrar kfo tkrurafmo yimayer, inji duket yimam toh nkifranirahm. ");
INSERT INTO amp_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nd ni hayuk hingrneft bi hingrna bugamoyant. Inji nahato ninhu bro yufati bro nanyjar bbuka rifhur bi nd bbinysof thofm bi fak nuhas bonuhas bugamoyanm. ");
INSERT INTO amp_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Bro Yifeme, nda bbinysoft tafi dborha duha na ninpno tohmohat afo bro yufeta tohmoya. Na kanga arihat nd bro yufat tfit wahe-kahtna ninpno tohruha. ");
INSERT INTO amp_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Nda bbinysofthu tuhan yindarim, nanhu yufatpno kfo htahemom, bi ptha nuhasmoyanm ninhu yufati ninhu toh yuhat yo ninhu dukefr. Ni tunhu yufatpno rhuyukm, to bi nann hemo. Hifa fak hik marnyamomt ninhu mrokfot. ");
INSERT INTO amp_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Arihat bi tawisafwom, ndar nanhu tirt yorhwa tamoh tamohm ninn hemoyem. ");
INSERT INTO amp_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nd ni hayuk mrokfo bugam kfo ptha nuhas bugamoyanm. Nd mrokfom yak duka tungunamotmm na ninpno toh tany nia yuhat bi wany hikmomtn rroh bro dukeft duka kangm, ni mifnn kfo tkrurafmotna niamoya. ");
INSERT INTO amp_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Na rroh dukefrpno kfo bruttniwa nhai nda bbinysofthu yima bugam dukahato kfo bruttnakaha. Nhai. Nd ni tu hayukm kfo bruttniwa. Nd yimam to tunhu yufatpno korhm. ");
INSERT INTO amp_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Na yakitohwa tuhan yindar bugam ninuhem. Yo ni yakitohwam to nanuhem. Rompno na bro yufat kekwa. ");
INSERT INTO amp_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Na nieruha, na nhai nda bbinysoft wom toh hatohrhota. Na nia thombat rom nda tuha bbinysoft toh hasorahm. Rom asha tuha bbinysoft toh haso thombat ni tu yura myorhekwa Bro Yifeme, bi ninhu bro bbuka nanyjaret tirtn htewanm, wayukatohaf hanyswanm, nd yimam ni tunn hemona. Ninhu tirtn rhu haso thombat nayakitohkahmn rpat atohtwam no rpat tohmo kanjo. ");
INSERT INTO amp_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Na rompno toh hnamohat ni hemo bro bbuka nanyjaret yafotharpno toh hongmb hnamotanm toh marnya hnamom. Nhai womr frtrohrmornom. Nd frtrohmo yimar, ror bi hukrn, rorpar frtrohmohat be yihato nohmor. To Bro Nkifrarhu rfa borngt bi nd mrokfot ruhettn, to be nd neft rhu twanhomot. ");
INSERT INTO amp_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Na bi nia yibonwoyann nda bbinysoft afo tohetann nd mrokfom kfo pthiwanm. Kanga tuka hatohwa yindhoreft kanjo rom inji bro yindho-reftpno atohm. ");
INSERT INTO amp_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Ninhu mrokfot bi kfo pthahe-moyanm. Kfo pthahemotanm nhai ndar bbinysof thofroh dukefm hikkahm. Nhai. Ni dukiwa dukefr, na dhikwar, ndr kanjo inji hikwatm, ndnettn nda bbinysof thofm hti srthuwomm. ");
INSERT INTO amp_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Na nhai kfo mikahann, wayaktwanm. Nhai. Be kfo bruttna kanga ninhu mofsinhit watabohifat hmbrikahtnm Tndhr nhai finji naruhatrm. ");
INSERT INTO amp_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Rom nhai ndar bbinysof thofroh dukefm hikkahm. Nhai. Ni dukiwa dukefr na dhikwar, ndr kanjo inji hikwom. ");
INSERT INTO amp_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ninhu mrokfot tu fipet mifet. Ndnatn kanga, nd mrokfot nd yimaroh yima yuhum ahingrnakahtn ayak wus bowuskahttm be ninpno rim tohni bugarahm. ");
INSERT INTO amp_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Na ni tkrurafmotna nda bbinysoft niamoya. Nd yuhatn nd yimam tkrurafrhotanm kmi kmim rhu fnahrahm. ");
INSERT INTO amp_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Rom dukahato na bi ninhu tirtn rhuhato ninhu dukef yuhatn hikwa. Tawo rom na hikwa kanjo ninhu tirtn htahato ninhu dukef yuhat hikrahm. ");
INSERT INTO amp_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Na nhai nanhu disaiperpam dukahato kfo bruttnakaha. Nhai. Rom pthayuk mrokfom wanyhato na hikruha yimam rpat duka nhafoh bugahato kfo bruttniwa. ");
INSERT INTO amp_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Na kanga no nito tohwa kanjo rom inji rpat nafrtkafhato rpat atohm. Yo rom nonpno afrtkafkahtm nda bbinysofthu tuhan yindarim htiruhamn nanhu nia nmbuhat duka mirahm tu Bro Nkifra tkrurafmotna niamoya. ");
INSERT INTO amp_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Nd ni nanpno hayuk bro yufat bi hemoyanm. Nd bro yufatpno rpa yima yuhur rhurahm no rpa yima yuhur yorhwa kanjo. ");
INSERT INTO amp_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Na kanga na romn thu hamuhkfot, yo ni tfit nann thu hamuhkfot, inji inji anakahnomn rom be rpa yima yuhur rhurahm. Tfit ndar bbinysof thofm inji htiruhamn nanhu nia yuhat duka mirahma, Bro Nkifrar tkrurafmo yimayer. Yo duka mirahm, nanhu disaiperm ni Bro Nkifra mondt htewunm na ni Bro Nkifra mondt htamo kanjo. ");
INSERT INTO amp_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Bro Yifeme, nd ni hemo yimam na kanga na tohruha kmit rom rpat atohtwanom. Na kanga nd na hatohruha bro nukefti bro yufat afo ahtitwamt. Nda bbinysoft tafi dborha duhattn na hti wofnhato hemona nd nukefti bro yufat. ");
INSERT INTO amp_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Tu dborioh nefm yakitohet Yifeme, nda bbinysoft tohwa tuhan yindarim nhai tawisafkahmn. Nanrpaya tawisafwann. Ndar nanpno tohwa yimam, rom tawisafwomt nanhu nia nmbuhat. Kangm, Bro Nkifrar kfo tkrurafmo yimayer. ");
INSERT INTO amp_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Bi fak nuhasmoyanm ninhu yufati ninhu toheft yo ninhu dukefr. Tfit wom yiha wom yiham yak nuhas hanyruhanm. Inji narhotanm, ni Bro Nkifra na marbit htewa kanjo rom tfit nd neft yakhato womm marbit htarahmm. Yo na inji htirhoyann thu hamuhruhanm.” ");
INSERT INTO amp_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jisasr Bro Nkifrarpno kfo bruttna buganihato turhu disaiperm myaknihato tek Kidront hayuknihato mkuko yimom. Nd tek mkuko rhuyuk olif suhtn yi rhumom. ");
INSERT INTO amp_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Nd olif suhtn bok yiham Jisasr turhu disaiperm yaknimoarm ndha yi rhu rifinymoum. To Jisasr hndhnayuk yima Judasr ror bi htimort nd tkitt. ");
INSERT INTO amp_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ndnettn Judasr to be nd yuhatn hanymorm Romroh soldiami polism. Polism prisroh bro yimami Farisim kfo tkrurafmomm. Yahrt tohyuk kfra inyarut yo kshm rpat fakitohakmomm. ");
INSERT INTO amp_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jisasr nd yimam htiyak-mohat nhai yak mmormort rroh yi nmbuhat. Ror bi tawisafmorm rorhu yakyuk krhopa bugam. Bi tawisafetrn kfo ttiwon memorm, “Nikome frohm hambriwako?” ");
INSERT INTO amp_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Kfo memomr, “Nom Nasaret thof Jisasr kak hambro hnewunom.” Jisasr sinyahato kfo memorm, “Na to asoya.” Nd Jisasr hndhnayuk yima Judasr, ror rpat nd yahr kmimpno rpat tohmoum. ");
INSERT INTO amp_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Jisasr kfo memotr, “Na asoya,” nd yimam tfit mongthur mongthur yihato tuha dangn yukha dangn yukham tmbho thumom. ");
INSERT INTO amp_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Tfit wompam Jisasr kfo ttiwon memorm, “Niko frohr hambriwako?” Kfo memom, “Nasaret thof Jisasr hambriwunom.” ");
INSERT INTO amp_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jisasr kfo memorm, “To bi kfiyanko, na asoya. Na hambro hne thombat to bt ndar na hik htfaswam afo aim.” ");
INSERT INTO amp_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ror nd yima yuhur inji mfnahhato inji kfo pthamohat, to bingot mrokfot bi kfo memor, “Nd yimam ni hayukm nhai rroh womr yakrmotmr frtrohrmornom.” Nd mrokfot bi inji ruhettn to be ka yimamn fak htamotmr inji kfomor. ");
INSERT INTO amp_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Saimon Pitar ror bainat fakitohakmor. Nd bainat kimt teh tundakhato prisroh bro tohak prisrhu hingrna yimarhu tirmif yimbhindangt frbubafmotrt misuhmot. Nd yimarhu yufat Malkusr. ");
INSERT INTO amp_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Pitar inji namotr tfit Jisasr kfo memorr, “Bainat tfit wathuntwe. Ni finji dukewuna, ka kangn, nd krho nmbuhat bi Bro Yifemr dkfoyukt ayak duha yirte? Nd dukeftpno inji newun?” ");
INSERT INTO amp_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Nd Jisasrhu yakt yimo yimam Jisasr tir tir yakmomr mtitofe kiboki-momr. ");
INSERT INTO amp_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Kibokiyakhato afo Anasrpno hanymomr. Anasr Kaiafasrhu matoh-emer. Kaiafasrn prisroh bro tohak yimarhu hingrneft fakitohmort nd gunyjimr. ");
INSERT INTO amp_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","To nd Kaiafasrn bro tohak prisr tohhato Judaroh bro yimam bi kfo memorm, “Rpa yimarpar Juda buga-nmoh tkitt yakhato suh nanyorneft hifa.” ");
INSERT INTO amp_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Jisasr hanymohat Saimon Pitari wom disaiperr hik hanymofr. Nd wom disaiperr bro tohak prisr bi tawisaf-morr. Ndnetrn ror rim fnahnimor nd bro tohak prisrhu kuny kmifako Jisasr hafknemohat. ");
INSERT INTO amp_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pitar ror kmifa rim fnahnitn mtoh hasomor. Tfit ndwom disaiperr Pitar hti hambrohato tfit nd kmifa rim fnahnit tohukatohmoa mett kfo ttiwonhato Pitar fknenimor. ");
INSERT INTO amp_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Nd mett inji htiyaf hanyhato Pitar kfo ttiwon memotr, “Ka ni aso nd yimarhu wom disaipern?” Pitar kfo memor, “Nhai na. Na wom yimaya.” ");
INSERT INTO amp_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Yifung-nano bro frfoneft yakmottm nd bro tohak prisrhu kuny kmifar yukatohaf hanyuk yimami polism kaht tenghato haunyomoum. Pitar ror nd yimampno rpat tohhato kaht haunyomoum. ");
INSERT INTO amp_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Prisroh bro tohak prisr sinyahato kfo ttiwonmorr disaiperroh nmbuhat yo tu Jisasr mrokfom kfo pthamoa yuham. Ndm kfo ttiwon hik bohik-mourr. ");
INSERT INTO amp_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jisasr sinyahato kfo memorr, “Na mrokfom kfo pthamoahat nhai wom kafroh tkitt tuhan yindarim yak nhafohhato kfo ptharmoayanm. Briyaha tafontn Judam rifiny hakuta rmonmn yo Bro Nkifrarhu temperr rifinymoatm mrokfom hemoanm. ");
INSERT INTO amp_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ndnettn to tamohmpno na ttiwonwa? Na pthamo mrokfom wanymo yimamn wakfo ttiwonn. Rom tawisafwomm na pthamoa mrokfom.” ");
INSERT INTO amp_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Jisasr inji kfo pthamotr brbo tohyuk polismanr sinyahato Jisasr nyingatikt frsrfamorr. Frsrfahato kfo memorr, “Tot inji tohak prisr kfoyuk mrokforoh kfo wokneft?” ");
INSERT INTO amp_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Tfit Jisasr kfo memor, “To na finji kfiya? Faso kfiya? Faso kfo thombat to wakfo nuhasna na kfoyuk tng bebt. To na dborioh mrokfot ptha thoft to tamohmpno nyingatikpako be frsrfa furena?” ");
INSERT INTO amp_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","To be yuht baklain kiyetr Anasr yakmorr Jisasr tfit Kaiafasrhu tirtn htamorr. ");
INSERT INTO amp_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Saimon Pitar afo kahtpno tohhato haunyomour. Kaht haunyo hasetrn wom yimam rorpno tohmom kfo ttiwon memomr, “Ka ni aso nd yimarhu wom disaipern?” Pitar nhaf kfo memor, “Nhai na. Na wom yimaya.” ");
INSERT INTO amp_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Tfit nd bro tohak prisrhu wom hingrna yimar tohhato Pitar kfo ttiwon memorr, “Ka ni ndar yimann mswirt yihof htiroya?” Ror nd Pitar yimbhindangt frbbomo yimarhu yimater. Ror tohhato htimorr Pitar sinyahato nd prisrhu hingrna yimarhu yimbhindangt frbbomohat ndnetrn inji kfo ttiwonmor. ");
INSERT INTO amp_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Inji ttiwonmotrr tfit wompam Pitar kfo namhi memor, “Nhai.” Pitar inji kfo namhi hanymor krir nakumor. ");
INSERT INTO amp_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Be Jisasr prisroh tohak yima Kaiafasrhu kmifat ruhetrn tfit Judaroh bro yufet yufet yimam yaknimomr Judiaroh gafanarhu kunyko tfit hanymomr. Yihat bi nitre dbtaku hanyettn Judam nhai rpat hafknermomr gafanarhu kmifat hanymohat. Be inji briahako mtohmom. Turoh nkifra tndht yakitohetmn rom Pasofa burwa tofi yihar bi brboh hanyetr rom nhai tfit tamoh tamoh nefm yihato turoh rhu nmbuhat yak beb hanykfot. Be rhu marnya bomarnyahato Pasofakfot htayuk yemro burwat rom yakfot. Nd dukefetmn nhai fknermom Jisasr gafanar rhuyuk kmir hanymohat. ");
INSERT INTO amp_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Pailatr fnahnihato nd briahako tohyukm kfo ttiwon memorm, “Tamoh tofirpno nda yimar yamukako kot atohr?” ");
INSERT INTO amp_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Kfo memomr, “Ror ufasoh nefm ana duha yir nhai ninpno hnarfotnomr.” ");
INSERT INTO amp_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pailatr kfo memorm, “To be ndhtet neft tuko wayaknikahkomr tukmoh boririfhu yuhat wahikko. Yimar finji finji nayetr finji niwakomr nd yuhatn wahiktwako.” Tfit Judam sinyahato kfo memom, “Romroh gafmanr kfo rafo memor, nom Judanom nhai wom tofiyet yimar nmoh tire bgre misn kihegir nohkfot. Be tu nhai mif.” ");
INSERT INTO amp_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","To nd nd nefm Jisasrpno rhumom, to bi tur kfomoa kanjo nd yuhatn to be rhu hik twanho mifmom. Bi kfo memor, “Na ndar bbinysoft tohhato bgre miyeta kasinyarahma.” ");
INSERT INTO amp_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pailatr tfit turhu kmifar rim fnahnihato Jisasr nakumorr. Jisasr yi rim tohmotr kfo ttiwon memorr, “Nine Judaroh kinge?” ");
INSERT INTO amp_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Pailatr inji ttiwonmotrr tfit Jisasr ttiwon memorr, “Ni inji kfo ttiwonwohate tunhu dukefrn inji ttiwonwona o womm nanhu toh yuhat kfo nuhasmotmn inji kfo ttiwonwona?” ");
INSERT INTO amp_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Tfit Pailatr kfo memorr, “Tamohmpno ndhtet ttiwon nmbuhat nanhu yima yuhurn wadukakhato ttiwonrfoyann? To na Judayann inji ttiwonrfoyann. Ni tunhu kmi thofmi tunhu prisroh bro yimamn nanhu tirt htaromn. To tamoh neft namotn asha hnaromn?” ");
INSERT INTO amp_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Tfit Jisasr kfo memor, “Nanhu kingdomkfot nhai ndar bbinysofthu kingdomkfot rhukaht. Nanhu kingdomkfot be ndar bbinysofthut arhut, nanhu hingrna yimam sinya-rromn toh raforrotma nhai yimam yakhato Judaroh bro yimaroh tirtn htarrotma. Nhai. Nanhu kingdomkfot nndoh womharhoftn ndnetmn Judaroh bro yimaroh tirt htaroma.” ");
INSERT INTO amp_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Jisasr kingdomkfot kfomoatr tfit Pailatr kfo memorr, “Ni ka kinge, ndnetnn kfo kangn, ‘Nanhu kingdomkfot nhai ndar bbinysofthut rhukaht.’” Jisasr kfo memorr, “Uwa, na to finji kforhoya? Mrokfot to bi tot bi tunn kfiwunt. Na mmemt hiyauhato ndar bbinysoft niamohat, to yimaroh king tohhato Bro Nkifrarhu tu mrokfo yimbu yuha mifthu kfo ptha nuhasyuka niamoya. Yimam Bro Nkifrarhu mrokfo mift yakitohwam, nd yimam nanhu mrokfot wanukwomt.” ");
INSERT INTO amp_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pailatr tfit kfo ttiwon memorr, “To nd ni kfiwa kfo mif mif mrokfot to tamoh mrokfoyet?” Pailatr Jisasrpno ptha tanyhato fnahnimorn Judam rim kfo memorm, “Nd yimar htitita nhai wom tamoh neft narmor. ");
INSERT INTO amp_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","To niko bi hti hnayeteko, ndhtet bro Pasofa rhuyuk yihamn kalabus tohwa yimaroh womr fnah-newur. Niko tukomn kangko frohr afnahnar, tukomn yufat wayuta-twakomt. Kangko ndar Judaroh kingr afnahr?” ");
INSERT INTO amp_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Tng rihar wayur sinyahato kfo memom, “Nhai, nhai rorn. Barabasrn afnahr.” Nd yima Barabasrn kalabus htamohat, rorn rikohnefti yima tatneft damiagt hatonemourm. Nd nefm inji namoatr kalabus htamomr. ");
INSERT INTO amp_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Rom inji waniak waniak-motm Pailatr wanysi wanysi-hato soldiam kfomotrm soldiam wifkfot yakhato Jisasr nd wife wife smbho bosmbhaknimomr. ");
INSERT INTO amp_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Tfit huhra mtitoft yakmomtn kingroh mfham hatohwa kraunkfot kanjo yakke yakmomtn yuht huhra rmonett mfhatn wathu hamsismomr. Yo kku kkorpa kanjo fnhuyet yuke hmbreshar yakmomn hmbremomr. ");
INSERT INTO amp_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Inji natamomrn bt tom yuwi kfo nhehakni memoum, “Asor nd rom kfiwa Judaroh kingr.” Inji kfo nhehaknihato tire srfamoumr. ");
INSERT INTO amp_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pailatr tfit wompam fnahnihato briahako tohmo tuhan yindarim rim kfo memorm, “Wawanyko. Nd yimar tfit kforhota nikompno tfit hnerahmr. Ndtn niko hti kshrfaruhakomn duka mirahko ror nhai wom krhopam htikahrr.” ");
INSERT INTO amp_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Be Jisasr yarim fnahnamor. Nd mfhat wathu hamsismo huhra mtitofti nd hmbremo kku kkorpa kanjo fnhuyet hmbreshar, ndm rpat yarim hatohmorm. Yarim hatohmotrm Pailatr kfo memorm, “Wahtiko. Asor nd yimar.” ");
INSERT INTO amp_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Yarim hatohmotr prisroh bro prismi Bro Nkifrarhu temperr tohukatohwa polism wayur sinyahato kfo memom, “Wahegirkomr, wakihegirkomr. Bgre misn wathu hegirkomr” Pailatr rom pthamo mrokfot wanyhato kfo memor, “To ndhtet neft tuko wayaknikahkomr tukomn wakihegirkomr. Nane htitita nhai wom nefm narmotr btn nann finji narhoyanr.” ");
INSERT INTO amp_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Tfit nd Judaroh bro yimam kfo memomr, “Nmoh nkifra thfa mntwat mkfo fnahmot, kfo kangt, wom yimar kfo kangr, ‘Na Bro Nkifrarhu yona,’ nd yimar bi mrokfeter anohtwar.” ");
INSERT INTO amp_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Pailatr nd mrokfot wanyhato yima yuhur mfro fanhomorr. ");
INSERT INTO amp_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Pailatr tfit gafanarhu kmifako yimorn tfit Jisasr rim ttiwon memorr, “Ni fitoh kmi thofe?” Jisasr asor. Nhai wom mrokfom kfo ptharmor. Be wany marsisamorr. ");
INSERT INTO amp_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Jisasr Pailatrhu kfo ttiwon mrokfot nhai kfo yakiormotrr kfo memorr, “Ni nhai kfo yakiokahna. Wawanyn. Nanrpaya kforuha ni nhai bgre mis tuhegirruhatmn. Yo nanrpaya kforuha bgre misn tuhegirrahmn. Ndm ni ka nhai tawisafkahnm?” ");
INSERT INTO amp_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jisasr kfo memorr, “Yura bro kmi hefenr tohwa Bro Nkifrar nd ni hatohwa bro yufat hemotrn nanhu mrokfot ninn kakitohwont. Na yiro ritohtayuka na nhai finji kforhota. Ndt mrokfo duhatet. To tmift nd yimar na hndhnayukr, mirahn ka tu dborioh neft namor. Ni nayuk nefmi ror nanpno namo neft yak htineft, ninhu nefm be inji yura kitm, nd ror na hndhnamo yuhat ndt tu krhonano kitt, rothu krhopam broyem.” ");
INSERT INTO amp_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Jisasr pthamo mrokfot Pailatr wanyaf hanyhato memour, “Fitoh yuhamn ayak hfhanafoyanr,” to nhai, Judaroh bro yimam wayohrfat wayohrfathato kfo memom, “Nd yimar be inji yafhorahnr, ndt ni nhai tu Sisarhu yimatn rhukahn. Rorhu yimatn arhun to nhai inji narfotn. Yimar kfo kangr, ‘Na kinga,’ nd yimar kangr, ‘Sisar riyak htafhato tfit nann kinga atoha.’” ");
INSERT INTO amp_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Be Pailatr nd mrokfot wanyhato Jisasr fak hfhanmorr. Yak hfhanhato Pailatr ror jasr yorhwa gajis rim rhumor. (Nd Pailatr jasrhu gajis rim rhumo tkitt Hibru yarmumat kutamoumt Gabata.) Nd rhu yefinyuk tkitr tahirpaye thu trku htfas bugamomr. ");
INSERT INTO amp_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Nd yihar Judaroh Pasofa burwa yeyuk yeshriroh yak hta mska yibon yihar rhumom. Mar bi dany marrn Pailatr kfo memorm, “Judako wahtikomr nikmoh kingr.” ");
INSERT INTO amp_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Judam wayur sinyahato kfo memom, “Wuri air! Wuri air! Yura bgre misn wakihegirkomr!” Pailatr ttiwon memorm, “To kangko nikmoh kingr yura bgre misn akihegirre?” Prisroh bro yimam kfo memom, “Nom nhai wom kingm. Sisarpar nom tawisafwonom. Nom rorrparhu yinhitn korhnom.” ");
INSERT INTO amp_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pailatr be Jisasr yakhato kfo memorm, “Asor Jisasr. Bi tukmoh tirmn htewanr. Tukomn wakihegirtwakomr.” Inji kfonihato soldiaroh tirm htamorr. ");
INSERT INTO amp_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Be Jisasr fakni hanymomr. Rorhu tuhegiryuk bgre mis tur tita hatohta hanymort. Kmi taunt htanymortn wom kmi mfhat kutewumt yima Mfha Tpit, ndha hanymort. (Hibrukfot futamoumt Golgotat.) ");
INSERT INTO amp_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ndha bgre misn tir wuram nire frdbkafhato yuht bgre miyetr kasinyahato tou fopmomr. Wom hus yimaf yakmomf bgre miyetf mano mano tohmof. Womr tirmifko, yo womr kindonko. Jisasr buha tohmor. ");
INSERT INTO amp_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pailatr kfomotrm wom mrokfot mimkutn wandfakmomtn Jisasrhu bgre misn yura mfhako frdbkafakmomt. Nd mrokfot rom wandfakhato htamot kfo memot, “NASARET THOF JISASR, JUDAROH KINGR.” ");
INSERT INTO amp_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Pailatr memorm, “Nd mrokfom Hibrukfotn, Romkfotn, yo Grikkfotn inji wawandfa hanyswakomm mimkutn.” Jisasr hegirmo tkitt brbo tauntpno hegiretrn bok Judam rim fnahni mfnahnimoamn nd rom wandfamo mrokfom rim htini mhtinimoumm. ");
INSERT INTO amp_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Prisroh bro yimam nd mrokfot htimohat Pailatr mkfo memomr, “Awandfawahn, ‘Judaroh Kingr.’ Wawandfa wame, ‘Nd yimar kfo memor, “Na Judaroh kinga.” ’” ");
INSERT INTO amp_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Tfit Pailatr kfo memorm, “Mrokfot bi inji wandfiyant to be inji arhut.” ");
INSERT INTO amp_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Soldiam Jisasr yuht bgre miyetr tou yopnihato nd ror hatohmo hmbre wuskar husfihus yimam nhombrahato fak nhta nhombramomm. Nd yiro rim ruhakmoa yuke hmbresharpar fak trohmomr. Nd hmbreshar nhai be nmbuha nmbuha rmontham yakhato nahurmomr. Nhai. Be yuht thar hmbremourr. ");
INSERT INTO amp_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Be inji htitihato soldiam kfo memom, “Be inji yuhtr arhukahtr pirai saturahnomr. Frohr winr rorn yakrahrr.” Rom namo neft nkifra rfa borngt kfomo mrokfo yuhatn fak hikmot. Nd nkifra rfa borngt rhumo mrokfot kfo memot, “Na hatohmo hmbresham yak nhtahato fak nhombrani-momm. Yiro rim ruhakyuk yuke hmbresharne pirai satuhato yimam fakmomr.” Soldiam to nd nkifra rfa borngt rhuyuk mrokfo yuhatn fak hik mifmom. ");
INSERT INTO amp_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jisasr tuhegirmo bgre mispitn tohmo met kmime, tu Jisasrhu mmemt yo rothu nmemt, yo Klopasrhu met Mariat ee Makdala efkot Mariat. Nd husfihus metm Jisasr thu hegirmo mispit tohmom. ");
INSERT INTO amp_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jisasr memor wahtiyafoya htimort turhu mmemt. Yo nd tu Jisasr yuhu mongimoa disaiperr htimorr rorhu mmemtpno brbo tohmor. Inji htihato mmemt wakfo memort, “Nd ninpno brbo tohwa yimar bi ninhu yoner.” ");
INSERT INTO amp_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Tfit kekutnihato nd disaiperr wakfo memorr, “Rot bi ninhu mmemet.” Be nd yiha nd disaiperr Mariat kfaknimortn be rorpno ritohakhato rorn rifakitoh-akmort. ");
INSERT INTO amp_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Jisasr ndar bbinysoft niahato hingrna hnayuk hingrnefm mdukakhato duka hna duka hnamormn duka memor, “Nd na niahato hingrnayuk hingrnefm bi hingrna buga twanho-moyanm. Bi be nanhu hingrnefm.” Inji kfonihato kfo memor, “Bupa knewa.” To nd ror kfomo mrokfot nhai be kfo furarmort. Bi nkiframpno kfo htamo mrokfot to be tfit kfo hik mifmort. ");
INSERT INTO amp_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Wain buroht rohett tohmot. Wom spans yakmomn nd wain rohtn thu yifakhato hisop yuhtarn kiyakhato Jisasr wuhemotm tmasakmorm spans ruhetmn. ");
INSERT INTO amp_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jisasr nd wain bupam yenyi hanymorn wuroht kfoni memor, “Be bibe.” Be inji kfonihato mfhat yohnemotrn mfaknimor. ");
INSERT INTO amp_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nd yimam kihegirmohat Fraide yihar kihegirmomm. To nd Fraide yihar tor Judaroh Pasofa Sabat yiha rhuyuk yeshriroh yak mska yihar. Nd Sabat yiha Judaroh tu bro yihayer, rom nd yihar nhai rom wom tamoh nefm nakfot o hingrnefm hingrnakfot. Turoh nkifra yirmoht mdukakhato duka memom nhai ndar hirwa yimam tfit Sabat yiha hirkfot. Ndnetmn Judaroh bro yimam Pailatrpno yihato kfo ptha memomr, “Nd kihegiret yimam wuram frwokruhatmm nohrahm. Nohruhatm yak thurahmm. Nhai tfit nmoh bro Sabat yihar nd yimam tfit yura bgre mimn hirruhatm.” ");
INSERT INTO amp_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Be nd kfotpno soldiam yimomn barkof yimarhu wuraf fryifikatmomf. Rorhuf fryifikatni yo tfit yimomn womrhuf yi fryifikatmomf. ");
INSERT INTO amp_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Yo tfit yimomn memom Jisasrhu wuraf afryifikatnomf to nhai, htimomr bi nohetrn to be nhai fryifikatrmomr rorhu wuraf. ");
INSERT INTO amp_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Be wom soldiar kfrat yakhato Jisasrhu mano kkreko wuwashato htimor kkupami bupam rpat yudbat fnahmom. ");
INSERT INTO amp_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Wom yimar ndar nefm turhu nyingaye htihato kfo ptha srhwor, rorhu mrokfom kfo mif mifworm. Ror tur htitr nd ror kfoyuk mrokfo kfo mif mifworm, ndnettn niko nd ror kfoyuk mrokfom wany yakiokfot. ");
INSERT INTO amp_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Jisasrhu wuraf fryifikat duha yimohat to rfa borngt yorhwa mrokfo yuhatn hikmot. Nd mrokfot inji korhwot: “Nhai rorhu wom tpit fryifikatruhatmr.” ");
INSERT INTO amp_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Yo wom mrokfot kfo kangt, “Tum wasyuk yimarn tfit yukatohrahm.” ");
INSERT INTO amp_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Arimatea taunthu yima Josefr yimorn Pailatr mttiwon memorr, “Na kanga Jisasrhu thatipt yakniruhant?” Pailatr kfo memorr, “Hifa, nhai mrokfom, wayaknitwant.” Be Josefr nd mrokfot wanyhato Jisasrhu thatipt mfakmort. Nd yima Josefr to Jisasrhu wom disaiperer. To Jisasr hikmoahat nhai Judaroh bro yimampno yak nriyafrmoar. Nhai. Be inji kafrohnano hikmourr. ");
INSERT INTO amp_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Josefr nd Jisasrhu thatipt yakmohat Nikodemusr faknhomorr. Nd yima Nikodemusr, to rorn wom yiha yifung yimorn Jisasrpno mfnahmor. Nd yima Nikodemusr Josefr yaknhot yimohat ror dborioh mtha yarfonet paurakfot hanymor. Hushtet mtha yarfonet mifhu mtha yarfonet paurakfot hanymor. Ror hanymo paurakfothu krhopam 30kg kurhet paurakfot hanymor. ");
INSERT INTO amp_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Josef Nikodemusrof yihato thatipt wuyak thurakmoft tu Judam noheh yimam hingrnamoa hingrnef yuhat hikmof. Nd Nikodemusr hanyuk dborioh mthet paurakfot yakmofn yuke yuke rmontha nmbr nmbuham truf wuna hmbre buganimofmn, ee nd paurayet rmontha nmbr mkuye ki tawonmofr yagr nmbuhar. ");
INSERT INTO amp_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Nd Jisasr soldiam yakhato bgre mis tuhegirmo tkittpno rhumor wom bro mswirr. Nd mswirrn rhumor wom nfri tahi muhr. Nd tahi muhr nhai wom yimam bi htarmomr. ");
INSERT INTO amp_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Nd yihar Judaroh Sabat yiharhu rhuyuk yeshriroh yak mska yiharn, to be Jisasrhu thatipt yaknimoftn nd tuha brbo mswirr rhuyuk tahi muhtn rim htanymoft. ");
INSERT INTO amp_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Sande yiha dbha ksfu mif Makdala efkot Mariat sinyahato yimot Jisasrhu tahi muhthu htit. Yimotn htimott nd tahi muht frtittomo tahis nhai wom rhurmot. ");
INSERT INTO amp_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Mariat be inji mhti tanyhato be tfit mkekutnihato tonayefrpar yimotn mtone fnahmot Saimon Pitari Jisasr mfro yuhu mongimoa disaiperrpno. Rof htiyakhato ttiwon memoft, “Nine?” Mariat kfo memot, “Brorhu thatipt be bi fakniromr. Yaknihato ka fitha htaromr?” ");
INSERT INTO amp_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pitarof be inji wany sanyhato rof yimof tahi muhthu htit. ");
INSERT INTO amp_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Rpat afo tone hanymof, tfit buha wom disaiperrn tone dimandihato tone troh tanymorr wom Pitar. Rorn bi tone dimandinihato yima gur htamo tahi muht mfnah gungonmor. ");
INSERT INTO amp_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Tahi muh yifhatikt mtohhato wayirnamorn rihtimor nd yima gur tawonmo yuke rmontha nmbrrpam. Nhai yiro fknenirmor. ");
INSERT INTO amp_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Kto Pitar mongko mtone fnahmor. Ror mtone fnah thuhato be fau hafkneni twanhomor. Yau hafknenihato rim htimorm nd yimarhu yagr nmbuhat tawonmo rmontha nmbr manys. ");
INSERT INTO amp_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Yo wom rmontha nmbuhar tng tpithu teh dbkafyukr mfhatpno mthu kiyakhato mfhatpno rpat kitawonmor, ndr ror be turpatr yak marnya bomarnyahato mfha mthutamoko rhumor. ");
INSERT INTO amp_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Tfit ndwom disaiperr bi barkof mtone fnahmor, ror fknenihato rim htimorm nd yima gur ki tawonmo wuskam. Htihato memor, “Dajohmn, yimar bi sinyani twanhir.” ");
INSERT INTO amp_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(To nd Kraisrhu nohhato tfit sinya mrokfothu mna yuhat nhai bi yakrmoft. Nd Bro Nkifrarhu rfa borngt yorhwa mrokfot afo yuhre fak mmotamoft.) ");
INSERT INTO amp_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Nd disaiperf mhti hambro tanyhato be tfit yimof kmifako. ");
INSERT INTO amp_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Makdala efkot Mariat yima gur htamo tahi muhtpno brbo tohhato nurmout. Nur hanyhato wasifamotn memot, “Yiro tahi muh yuhat arihti-yafoya.” ");
INSERT INTO amp_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Asha rihtimotf hus moun-motf ganyom hmbresha hmbreyetf rhumof yima gur htamo tkittn. Womr mfha mthutamoko rhumor. Womrne wurasifko rhumor. ");
INSERT INTO amp_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Nd mounmotf ttiwon memoft, “Bar mete, nine tamohmpno inji nurwa?” Kfo memotf, “Nanhu Brorhu thatipt ka yimam yaknihato nndo htaromt. Ndt hti hambrohato nurwa.” ");
INSERT INTO amp_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Mariat inji kfoni hanyhato memot, kekutniya, htimotr Jisasr. Rot Jisasr htimohat nhai duka marimot, “Arr Jisaser.” ");
INSERT INTO amp_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Tfit tu Jisasrn kfo ttiwon memort, “Bar mete, ni frohmn nur hambriwa?” Jisasr Mariat ttiwonmohat rot duka memot, “Ka nd Jisasr htamo tkitthu mswir tikatr kfo ttiwonwora.” Ndnettn kfo memotr, “Yinowe, nanhu Bror ni yaknihato nndo hta thombat, wakfo nuhasafkahtna tfit yihomakruhanr.” ");
INSERT INTO amp_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jisasr tfit tuthu yufat naku memort, “Maria.” Mariat kekutnihato Hibru mrokfotn wukfo memotr, “Rabonai!” Nd mrokfothu yimbu yuhate, “Tisa.” ");
INSERT INTO amp_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jisasr kfo memort, “Mirahn bi ayaktiyanr. Na tafito afo Bro Yifemrpno muhrmoya. Be waikahnn nanhu nmemrom wakfo wamitwanm, na tfit yura muhhato na yifemwa Yifemr yo niko yifemwa Yifemrpno tfit yiruha yo na kfo bruttnewa Bro Nkifrar yo niko kfo bruttnewa Bro Nkifrarpno tfit yiruha.” ");
INSERT INTO amp_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Be Mariat yihato kfo memotm, “Na bi Bro Nungothetr htitawoyanr.” Yo Jisasr kfo pthayuk mrokfom kfo nuhasmotm. ");
INSERT INTO amp_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Sande krif yifung disaiperm Judaroh bro yimam yakrmihato kuny kiyake yiro kunys rhu hasetmn Jisasr buha mitohmor. Mitohhato kfo memorm, “Yima yuhum amirhumko.” ");
INSERT INTO amp_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Inji kfonimorn tirfhu fhuf yo kkreko kfraye wasmo fhut fak nuhasmorm. Disaiperm turoh Bror htihato yima yuhum tfit yindhormomm. ");
INSERT INTO amp_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jisasr tfit wompam kfo memorm, “Yima yuhum amirhumko. Na Bro Nkifrar tkrurafomora. To tawo niko, tfit nann kfo tkrurwanko.” ");
INSERT INTO amp_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Inji kfonihato fahsha wunamorm. Yahsha wunanihato kfo memorm, “Bro Nkifrarhu Yafothat athu hamuhtko. ");
INSERT INTO amp_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Womm nayuk fasoh fasoh nefm yafhorahkomm, tawo Bro Nkifrar yafhorahrm. Womm nayuk fasoh fasoh nefm nhai yafhokahkomm, tawo Bro Nkifrar nhai yafhoruhatrm.” ");
INSERT INTO amp_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Nd yiha Jisasr turhu disaipermpno mfnahmohat rroh womr nhai rhu-nhormorm. Nd yimar, Tomasr. Rorhu wom yufat Didimusr. ");
INSERT INTO amp_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Nd yima Tomasr wom disaiperm kfo memomr, “Nom Jisasr bi htitawonomr.” Tomasr wanyhato kfo memorm, “Na nhai bmbri wany yakiowotanko. Na kanga afo tukanhu nyingaye tirroh fhum yo kkrekorhof fhut htihato tukanhu tirpinyafe yaktiwone, ee btn wany yakioruhanko.” ");
INSERT INTO amp_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Tfit 7-pela yiham rhunihato nd disaiperm tfit yimomn kunys frkihnihato yiro rhumom. Nd yiha Tomasr rhunhomorm. Yiro kunys rhu hasetmn Jisasr buha mitohmor. Mitohhato kfo memorm, “Yima yuhum amirhumko.” ");
INSERT INTO amp_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Jisasr Tomasr htihato kfo memorr, “Tomas, ninhu tirpinyaft asha yarim htakahnt tirf wahti kothanf. Yo tirt wafrhtfasnekahnt mano kkreko wahtant. Mirahn hus yima yuhufpno atoha. Rpa dukefrparpno tohkfot.” ");
INSERT INTO amp_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomasr turhu nyingaye Jisasr htihato kfo memorr, “Ni nanhu Bro Nungothete. Ni nanhu Bro Nkifraye.” ");
INSERT INTO amp_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Tfit Jisasr kfo memorr, “Hifa ni tunhu nyingaye htihato kangn na Bro Nkifraya. Yimam na tafi hti duha be mrokforpat wanyhato rroh yima yuhum nanpno htewumm, nd yimam rroh rhu nmbuhat hifa yi marnyaraht.” ");
INSERT INTO amp_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jisasr bok mirakerm hingrna-moatrm turhu disaiperm htimoumm. To na nhai nd miraker bugam hta bugarmoyanm ndar na wandfayuk gonborngt. ");
INSERT INTO amp_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","To nd dfik mirakerroh mrokfo nmbuham na htayukm, ndm be nikmoh hti, yo wany yimbuyukmn htamoyanm. Memoya ndm htiruhamn Jisasrhu mrokfom yakhato hikrahmm. Nd yima Jisasr tor nd Yonr yimaroh minrfa htiyakyukr Bro Nkifrar kfo tkrurafmor. Rorhu mrokfom wany yakiorahkomm, be toh nkifranirahko. ");
INSERT INTO amp_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tfit wom yiha Galili baritn Jisasr tfit wompam turhu disaipermpno rim fnahmor. Nd Galili barithu wom yufat Taiberias. ");
INSERT INTO amp_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Jisasr disaipermpno mfnahmohat inji mfnahmorm. Wom yiha, Saimon Pitar, Tomasr (rorhu wom yufat Didimusr), yo Galili profinshu kmi Kana thof Natanierr, yo Sebedirhu yon najohf, yo wom disaiper husf rpat toh hasomom. ");
INSERT INTO amp_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Saimon Pitar sinyahato womm kfo tany memorm, “Nane barit rugi htat kitwa.” Womm sinyahato kfo memomr, “Nom to kamuknom ahiknomn.” Be inji kfomotm rpa mmbrrpat mikmbrenihato yimom. Nd yifungr rugim htati htati nhai wom yirenr yakrmom. ");
INSERT INTO amp_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Marr mwondh fnah hanymor Jisasr tek bari thmbtn mitohmor. Disaiperm nhai duka marimom nd yimar Jisaser. ");
INSERT INTO amp_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Jisasr mitohhato rittiwon memorm, “Wurenko, yiram fekko?” Rom kfo memomr, “Nheno.” ");
INSERT INTO amp_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Rom inji kfo namhimotm tfit Jisasr kfo memorm, “Rugit wayakkahkomt mano tirmifko watukahtkomt bok yiram tuhakraht.” Jisasr kfomo yuhatn tirmifko rugit tuhato memom tfit wateh sohaknomt, nhai watehakkfot. Yirat nhai be kukenhato tuhakrmot. Ndnettn watehakneft nhombratimoum. ");
INSERT INTO amp_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Nd disaiperr Jisasr mfro yuhu mongimoar sinyahato Pitar kfo memorr, “Nd yimar Broyer.” Kfo memotr Broyer, Saimon Pitar inji wanyhato turhu yak hrur thumo yuke hmbreshar tfit yakmorn ndr nyuhmor. Nyuhnihato tekt fuknimorn rifune hanymor thmbko. ");
INSERT INTO amp_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Wom disaiperm rom bot rhuhato yira rugit riteh hanymomt. Nhai be wuri danyko rihirrmom, be brbo thmbtpno hirmom. Boti mano bari thmbt be 100 mitakforpat. ");
INSERT INTO amp_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Rom rim dbkafnihato mhtimom kaht yo yirar kahtn kurmour yo wom bretpam htatamorm. ");
INSERT INTO amp_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jisasr kfo memorm, “Nd niko yek yiram womm wahnako.” ");
INSERT INTO amp_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Jisasr inji kfomotr, Saimon Pitar tfit mmbrt mitohnihato rugit ritehakhato teh hawitamort nungurn. Nd rugit tuhakmo yiram 153 yiram tuhakmot. Be tu bro yirarpam tuhakmot. To nhai frtmbrarmomt rugit. ");
INSERT INTO amp_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jisasr kfo memorm, “Waniakahkomn afo nuwa wayako.” Disaiperm bi hti nhta yo wany nhtahato duka memom, “Arr Bror nier.” Ndnatn yakrmenano nhai womr duka marimor, “Kfo ttiwon miruhanr, ‘Nine frohe?’ Nhai.” ");
INSERT INTO amp_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jisasr kahtpno yauyaknihato bretpat yakhato hemorm yo yirar nhaf yakhato hemorm. ");
INSERT INTO amp_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jisasr nohhato tfit sinyamohat nd yiha husfirpehyuk htit htimomr turhu disaipermpno mfnahmor. ");
INSERT INTO amp_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Jisasri turhu disaiperm nuwa yenyimomn Jisasr sinyahato Saimon Pitar kfo ttiwon memorr, “Saimon, Jonrhu yone, wur arm rroh dukefr nanpno korhr. To ninn ka marbit htewuna?” Pitar sinyahato kfo memorr, “Broye, nanhu yima yuhur htitnr, nanhu yima yuhur nhai wom frohmpno rhukahr. Nhai. Nanhu yima yuhur ninrpanpno korhr.” Be Jisasr inji wanyhato kfo memorr, “Nanhu sifsifenm wayukatohaf hanyhitwona.” ");
INSERT INTO amp_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Tfit wompam Jisasr ttiwon memorr, “Jonrhu yon Saimone, ninhu dukefr ka nanrpa mifanpno hta mifwonr?” Saimon Pitar kfo memor, “Uwa, uwa Broye, nanhu yima yuhur ninrpanpno korhr.” Tfit Jisasr kfo memorr, “Nanhu sifsifm wayukatohafo hanyhitwona.” ");
INSERT INTO amp_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jisasr tfit husfirpeh ttiwonneft ttiwon memorr, “Jonrhu yon Saimone, ninhu dukefr ka nanrpa mifanpno korh mifwor?” Saimon Pitar Jisasr husfirpeh ttiwonneft ttiwonmotr duka krhohato memor, “Arr be masat ttiwon hasukna hatohwora. To finji wom finji kforhoya?” Kfo memorr, “Broye, tamoh tamoh nefm htitnm. Nanhu dukefr ninrpanpno korh mifwor.” Jisasr kfo memorr, “Nanhu sifsifm wayukatohaf hanyhitwona. ");
INSERT INTO amp_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Na kfo mifwann, ninhu damiag tohtpno tunn hmbreshat hmbrehato tunhu tire foh thaye dbkafnihato fitoh fitoh tkitm tunn ufau fau htfasmoun. Tfit kto tabou buganihato tirm mano mano tuhayitruhatnm wommn tirm kijbkafakniruhamn wom tkitt hanyrahmn. Nd tkitt nhai be tunhu duka fijo yiruhatn.” ");
INSERT INTO amp_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jisasr nd mrokfom inji kfomohat to Pitar nohruha noh yuhatn Bro Nkifrar bro yufat yakrahr, nd yuhatn Jisasr kfo mrokfom inji kfomorm. Jisasr nd mrokfot kfo pthanihato Pitar kto tfit kfo memorr, “Wania wahikna.” ");
INSERT INTO amp_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Pitar kekutakhato yihom hti-yakmorr Jisasr mfro yuhu mongimoa disaiperr mongko fau hik hnamorf ror Jisasrpno. To Jerusalemr Jisasrpno wuroh nuwa yamohat to nd yimarn Jisasrpno brbo rhu kekutni hanyhato ttiwon memorr, “Broye, frohrn ni hndhnaruharn?” ");
INSERT INTO amp_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pitar kekutnihato Jisasr rikfo memorr, “Broye, ndar nnoh mongko niewa yimare finji finji rorhu rhu nmbuhat yiruhat?” ");
INSERT INTO amp_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jisasr kfo memorr, “Na tuka kanga afo yima nfrir atohkahrn nanhu nia yihar atoh gari hasorr, to nhai mrokfom. To ni womn tamohmpno kfo pthiwa? Be tunn wania wahikna.” ");
INSERT INTO amp_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Kto wom Kristenm Jisasr kfomo mrokfot yak kekutnihato nnakfo hihany memom, “O, kfo memor nd disaiperr nhai nohruhatr.” To Jisasr nhai kfo marimor, “Nhai nohruhatr.” Nhai. Ror be kfo memor, “Na duka kanga afo yima nfrir atohkahrn nanhu nia yihar atoh gari hasora, to nhai mrokfom. To ni womn tamohmpno kfo pthiwa?” ");
INSERT INTO amp_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","To nd kfiwa disaiperrn wandfa-morm nda mrokfom. Nom htitnom nd ror kfoyuk mrokfom tu kfo mif mif kfoyem. ");
INSERT INTO amp_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Jisasr namo nefm mirahko ka rpa nefm namor. Tu boknabok nefm namor. Be amikahmn nd nef bugaroh mrokfom gonborngmn awandfa bugam, kane finji htarfom gonborngm. Ka nda yuht bbinysoft gonborngroh htayuk tkitm kkopen-tarfom. ");
INSERT INTO amp_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","O Tiofiluse, na Luka bi na barkof wandfamo gonborngtn bi wandfa bugamoyanm Jisasr ndar bbinysoft tohhato namoa nefm yo ror hingrnamoa hingrnefm. ");
INSERT INTO amp_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Ror ndar bbinysoft tohhato rinakmo nefm yo ptha nuhasmo mrokfefm wandfa buganimoyann tu wuroh mrokfomn ror nohhato tfit hefenr muhmo yuharoh mrokfom htamoyanm. Tu wuroh sinyanineftpno Bro Nkifrarhu Yafothat thu kasinyamottr tur aposer hingrneft yak htamo yimaroh hingrna yuham kfo hta bohta tanymorm. ");
INSERT INTO amp_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Barkofpam afo krhopam yakhato nohmor. Kto tfit sinyahato yima nfrir tohmor. Yima nfrir tohhato ufaufaumor. Ufaufau-moatr turhu aposerm tafontn nahtihato napthamoum. Ndhtet nefm namoatr htihato duka memom, “Asor sinyern tohwor.” Foti yiham tohmor. Tohhato yimam Bro Nkifrarhu kingdomkfot kfo nuhas bonuhasmourm. ");
INSERT INTO amp_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Wom yiha turhu aposerm yak nhafohhato kfo memorm, “Na bi yifiya niko mirahko bi kmi Jerusalemt ahtanynomt. Nann kfo memoyanko, tu Bro Nkifrarhu Yafothat afo hirahrko. Hiyafruhatrko ee btn waiswako. ");
INSERT INTO amp_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jonr ndar tek furaroh bupaye, baftaisimworm. Bro Nkifrar ror dfik yiham turhu Yafothaye baftaisimrahrko.” ");
INSERT INTO amp_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Aposerm Jisasrpno narhu rifinymohat aposerm sinyahato Jisasr wom ttiwon mrokfot kfo ttiwon memomr, “Bro Yimaye, ka asor ndar yiharn Isrerm thu bmtaruhatnm bbukeft yakhato tum king yakhato tum ritohakrahm?” ");
INSERT INTO amp_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Tfit Jisasr sinyahato kfo memorm, “Nd niko ttiwon mrokfot, nhai be nikmoh fijo bi wakfakkfot. Tu Bro Nkifrarn be afo htiyafo hanykfot. Turhu fijo dukaruharn hirahrko. ");
INSERT INTO amp_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Niko inji adukawahko, niko tu Bro Nkifrarhu Yafothat mithu nawoh-ruhattko mrokfo ptha bbuka rifhur yakrahkomr. Nd bbukeft yakniruhakomn, Jerusalem, Judia, Samaria, yo ndar bbinysofthu kmi kmim nanhu mrokfot ptha htfas buga habrirahkomt.” ");
INSERT INTO amp_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Wuroh wuroh mrokfom kfo ptha nuhas tany bugamormn, be Bro Nkifrar yaknimorr hamuhmorr. Aposerm tohhato htiyafo hanymomr ror hir hamuhmo yuhat. Wuroh gribpam fknenimotr be hti hambrafmomr. ");
INSERT INTO amp_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Yuhre inji yukatoh hasetmn asha wom ganyom rmontha hmbreyet yimaf rom toh hasomo tkitt mitohmof. ");
INSERT INTO amp_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Mitohhato kfo memofm, “Galili thofko tamohmpno be mfro yukatoh-wako? Nd niko htiyefi yimar, kto tfit inji wuhtiyakrahkomr.” ");
INSERT INTO amp_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Aposerm Jisasr mtoh kafhomo kmithu yufat, Olifet kmit. Ndha toh hasohato tfit Jerusalemko wohnemom. Olifet kmiti Jerusalemt nhai wuri wuri rhukahf. Be wan kilomitakforpat yaunihato wom kmit mifnahkfot. ");
INSERT INTO amp_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Aposerm Jerusalemt mifnahhato tum toh tanymo kunyshu wom yura rhuyuk tikrpar mrhu rifiny bugamom. Nd rifinymo yimaroh yufame Pitar, Jonr, Jemsr, Andrur, Filifr, Tomasr, Bartolomyur, Matyur, Alfiusrhu yon Jemsr, Selot grufkfothu yima Saimonr yo Jemsrhu yon Judasr. ");
INSERT INTO amp_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Nd nd yimami ee Jisasrhu mmem Mariati wom metme Jisasrhu nmemrom, inji inji yi rhu rifinyhato rroh yima yuhum rpa yima yuhurpar rhuhato kfo bruttna hasomoum. ");
INSERT INTO amp_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Inji kfo bruttnamoatm bok yimam rifinynhomoumm. Wom yiha 120 yimam rifinymotm Pitar tohhato wom mrokfot kfo memorm, ");
INSERT INTO amp_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","“Barenko, Judasr afo nompno rpat tohhato rpat hingrnamounom. Bingot Bro Nkifrar Defitrn mthu nawohhato wom mrokfot Defitr pthamort. Nd mrokfot Bro Nkifrarhu rfa borngtn korht. Tu fipet mrokfot pthamort. Bi Judasrn nd kfomo mrokfot rhumot. Rorn yahr kmim hasinyahato Jisasr fakmomr. ");
INSERT INTO amp_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Judasr Jisasr hndhnahato yakmo maruham bbinysoftn wiknamor nd maruham. Kto tfit tur wiknamo bbinysoftn yatit mifrtfohhato danyrn frtnehhato wirto grmt yuhtt fnahmotr. ");
INSERT INTO amp_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Kto Jerusalem thofm Judasrhu misuhhato yatit mifrtfohhato wirteft fnahmo nmbuhat wanyhato nd ror mifrtfohmo tkitt futamoumt Akeldamat. Akeldama yufathu yumbu yuhate, yima kkut.” ");
INSERT INTO amp_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pitar Judasrhu rrfathu yakyuk yimarhu mrokfot kfo memor, “Windoh gonborngtn kfomot, ‘Rorhu kunys be inji yima toh duha arhunitwat.’ Tfit nd windoh gonborngthu wom tkittn kfo memot, ‘Ror yakitohnamoa hingrneft tfit wommn yakkfot.’ ");
INSERT INTO amp_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Ndnettn rorhu rrfathu yakyuk yimar yak htakfot. ");
INSERT INTO amp_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Yimar yak htaneft htikfot, Jisasr Jonr baftaisim-moahat, Jisasr ndar bbinysoft niahato hingrnefm rihingrnakhato kto nohnihato muhmo yiha rpat nompno rpat tohhato hti bugerm nd nefm, tor nd yimarn yak htakfot. Yak htahato rorn Jisasrhu sinyamo mrokfo yuham pthanho htfasrahrnom.” ");
INSERT INTO amp_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Pitar inji ptha buganimotr hus yimaf fak htamom. Barkofr Josefr, wom yufat Barsabas Jastusr yo wom yimarne Matiasr. ");
INSERT INTO amp_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Nd yimaf yak htatahato Bro Nkifrarpno kfo bruttna-mom. Kfo bruttna memom, “Broye, yima yimaroh yima yuhum ninn htitwonm. Ndar nom yek yimaf ninn htihato wayak nuhasnnom. ");
INSERT INTO amp_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Fitohrn ni yibonwa Judasrhu tkitthu yakyukr, ni tunn wayak nuhasnnom. Judasr nohhato nd aposer hingrneft bi htanymortn bi yimor Maringour.” ");
INSERT INTO amp_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Inji kfonihato yo yufayet tahiham tuhato kfo nhta memom frohrn nd hingrneft yakruhart. Be Matiasrn Judasrhu tkitt yakhato aposer hingrneft tohyuk wom 11-pelakfotpno rihingrnakmor. ");
INSERT INTO amp_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Judaroh wom bro yihar kutewumr Pentikos. Nd Pentikos yiharoh riruhakyuk barkof marrn Jisasr hiket yimam rpa bro kunyrpar yihato rifiny bugamom. ");
INSERT INTO amp_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Rifinyhato rhu haso hanymom asha yura moun yuhatn wuwanyakmom wifort kanjo wumir nadidar sinyamohat. Nd nadidareft yimotn nd rom rhu hasomo kuny yuhtt nadidaraknimot. ");
INSERT INTO amp_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Asha tfit htiyaf hanymom kah funefm yima toren kanjo rhu hanyhato yimaroh mfhamn mitoh nhombra hanymom. ");
INSERT INTO amp_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Nd kunyr rifinymo yimam Bro Nkifrarhu Yafothat thu kasinya hanymottm kmi kmiroh yarmumat ptha bugamomt. ");
INSERT INTO amp_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Nd yihar, Judaroh bro yiharn, Juda yimam boririfhut yak hiketm wuri wuri kmim toh hanyukm yimomn Jerusalemrpar rifinymom. Nd kmi kmi tohyuk Judam nhai rpa yarmumat pthetrpam rifinyrmom. Nhai. Nndoh nndoh yarmumat pthetm rifinymom. ");
INSERT INTO amp_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Nd nadidareft wanyhato memom, “Afo ai ahtinom.” Yimomn asha be mwany fhtas hanymom nd yiro kunyr rifinymo yimam nndo nndo yarmu-mamn pthamoumm. Womr yi mtoh-hato memour, “Awanya,” turhu yarmumatn pthamoatmt mrokfot wanymourt. Womr nhaf inji. Memour, “Amtoh awanya,” turhu yarmumatn mrokfom wanymourm. ");
INSERT INTO amp_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Be nd Judam inji mwany hanyhato tum rinahti nahtihato nnakfo memom, “Barenko, ndarm nndo Galili thofem. ");
INSERT INTO amp_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","To tamohmpno kmi kminom pthiwa yarmumatn mrokfom pthiwatmm wanukwanomm? ");
INSERT INTO amp_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nom asha Jeru-salemt nia rifinywanom kmi kminom rifinywonom. Nom Partianom Midia-nom, Elamnom, Mesopotemia distrik thofnom, yo nom Kapadosia, Pontus, Esia, nd nd distrik thofnom. ");
INSERT INTO amp_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Yo Frigia Pamfilia distrik tohyuknom, kantri Ijift tohyuknom, Libia thofnom brbo taun Sairinitpno tohwanom yo kantri Rom thofnom be yifra yaus niayuknom. ");
INSERT INTO amp_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Yo nom Judanom yo wom kmi thofm turoh nefm htany-hato nom Judanmoh nefm yak hiketm, Krit thofnom yo Arebia distrik thofnom. Nom nd nd kmi thofnom, to tamohm-pno kmi kminmoh yarmumamn Bro Nkifrar bbuka nanyjarefmpno niwa nefm pthiwatmn wanukanomm?” ");
INSERT INTO amp_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Be nd Judam inji htihato be tuha mrokfo duhatm tohmom. “Nome ndarte tamoh neft yorhwat.” Tum inji rinakfo nakfomom. ");
INSERT INTO amp_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Womm kfo memom, “Nd yimam niko mirahko nko tamohrn fknitrm kmi kmiroh yarmumam pthewum. Ndm nndo bupa ye mumimn ptha mmo bomumiwum.” Inji kfo huta bohutamomm. ");
INSERT INTO amp_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Pitari wom 11-pela aposerm rpat sinya tohmomn Pitar kfo memor, “Niko Judako yo niko wom womko niahato nompno Jerusalemt nia rifinywako asomif yorhneft nann ptha ntreyafrhotant afo wawanyswako. ");
INSERT INTO amp_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Asomif yorhneft htitawokomn womm kfo famumnom, ‘Bupa yawomn kfo ptha mmo bomumiwum.’ ");
INSERT INTO amp_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Wahtiko marr yuhre asomif mfnahwor. Yuhre 9 kilokkfoyet. Ndhtet yihar nom nhai bmbri bupa nuwa mye fnahkahnom. Nd niko asomif htitawo neft to mirahko profet Joerr ndt ka nhai kfo pthamort. Nhai. Profet Joerr ndt bi pthangotmort. ");
INSERT INTO amp_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Kfo memor, ‘Bro Nkifrar kfo famur, “Kraisr toh hanyruha yiham nanhu Yafothat tkrurafrhotant met yindar bugam Yafothat mithu nawohhato thu dbothatruhattm tamoh tamoh nefm kto rhuyukm bi romn kfo ptharuhatmm wanyrahmm yimam. Metenm yindariyenm rom ptharahm. Damiagm rom yimam hwe tweh hanita kanjo rom hti hanyruhamn ptharahm. Bro yimam bi kunyrpam ruhetm rom nhaf tweht htihato ptharahm. ");
INSERT INTO amp_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Nanhu hingrnefm yakitohwa tuhan yindars rom nhaf kfo ptha bugarahm. ");
INSERT INTO amp_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mounti bbinysoft nndo rhuruhatf htirahmf. Kah hipefr thu sinya thombat mirahm ka kku rmontharn faknattmf. ");
INSERT INTO amp_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Mount mirahm ayukatohnomt htirahmr marr yarmbon tiftarahr. Yamt htirahmt mirahm nndo kku baritn hirwot. Ndhtet ndhtet nefm rhuniruhatm bt Bror nierahr. ");
INSERT INTO amp_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nd yihar yimam Bro Nkifrar nakurahm hbhakneft yudbat yakrahrm.” ’ Tom bingot pthamo mrokfom. ");
INSERT INTO amp_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Niko Isrerko na kforuha mrokfom wany marnyaf hanyswakomm. Nasaret thof Jisasrhu mrokfom ptharuha. Nd yimar miraker hingrnayuk bbukefti dbohnet yimaroh bbukeft hehato kfo tkrurafmorr. Ror nd bbukeftpno ndar bbinysoft bok nefm namotrm htimokomm. ");
INSERT INTO amp_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Nd yimar niamohat nikmoh tirmn htamorr. Bi turhu dukeftpno inji htamorr. Rorhu dukeft duka memor, ‘Rompno toh hasoruharn fasoh nefm nayet yimamn htaruhatmr nohrahr.’ To bi htamokomr. ");
INSERT INTO amp_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Htamohat nhai wundiat nohnirmor. Nhai. Tfit tu Bro Nkifrarn kasinyamotrr tfit sinyamor. Bro Nkifrar nhai wofnrmor nd noh yafotharn Jisasr yaktakfot. Yudbat fak thumort nd noh yafothat. Nd nohyuk tkitt nhai Jisasr yak tkafkfot. ");
INSERT INTO amp_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Defitr Jisasr nohhato sinyaneft kfo htamort, memor, ‘Na htitanr Bror be nanpno brbo mfrtkafwor. Ndnatn nhai nanhu yima yuhur be bmbri woh dbuknaknikfot. ");
INSERT INTO amp_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ndnatn nanhu yima yuhur marnyewarn windoh ptha yindhorwa. Bro Nkifrar kfomo rhu marnya yihar, ndr rhu gari hasiwa. ");
INSERT INTO amp_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Bro Nkifraye na nhai kfo miruhatn bi nohniyet yimaroh kmitn atohtwar. Nhai. Ni bi tunn kfo htayet yimar nhai kfo miruhatn yoptn amibdgnir. ");
INSERT INTO amp_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Wom nfri tohefthu toh yuhat to bi fak nuhasmona. Nd nfri toheft na tohneft, be tunn toh tkafrhotna na be yindhorhato tohruha.’” ");
INSERT INTO amp_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pitar wom mrokfot yakhato kfo memor, “Barenko, nmoh nkifra Defitrhu mrokfot ptharhotant wawanyswakomt. Nd Defitr pthamo mrokfot nhai turn yirmot. Defitr ror bi nohngotmotr fopmomr. Rorhu yopt tot yuhre rhu hanitt. ");
INSERT INTO amp_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Defitr profet hingrneft tohetrn Bro Nkifrar bi kfo hta memorr, ‘Ni yakitohwa king hingrneft kto tunhu frika yuhathu yonrn nd hingrneft yakitohrahrt.’ ");
INSERT INTO amp_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Nd Defitr kfo memo nhai nohniyet yimam yita tkitt yiho tohruhatr, yo nhai mikfe bdgniruhatr, nd hus mrokfo nmbuhaf nhai tur kformor. Nhai. Bro Nkifrarhu dukefm yakhato kfomor. Bbinysof thofroh minrfa htiyakyuk yimarn kfo pthamor. Nd yimarn nohruharn tfit sinyarahr. ");
INSERT INTO amp_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Nd yima Jisasr yopt bi ruhetr Bro Nkifrarn kasinyamotrr tfit yafothetr rhumor. Nd yimar sinyamohat nom hti bugamonomr. Nom tunomn htihato rorhu sinya yuhathu mrokfomn pthewunom. ");
INSERT INTO amp_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Jisasr bi sinyanihato hefenko muhmor. Tu Bro Nkifrarhu bro bbukeft yorhwa tirmifko mrhumor. Mrhuhato Bro Nkifrarhu Yafothat fakmort. Yakhato hrek nd Yafothat nom buganom yahutrnom nd Yafothatn thu nhombrettnom pthewunom. ");
INSERT INTO amp_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Defitr nhai Jisasr muhmo kanjo muhrmor. Nhai. Ror tor be kfo memor, ‘Yawern nanhu Bror kfo memorr, “Nanhu bro bbukeft yorhwa tirmifko wamrhun. ");
INSERT INTO amp_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Wamrhukahtn nd ni hti dbnotmoa yimam afo ninhu mofsinhitn yak htahiruhann.” ’ ");
INSERT INTO amp_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ndnettn niko Isrerko dukakfot. Nd niko wasmo yima Jisasrn bi Bro Nkifrar fak htamorr nmoh Nungothetr. Rorn nrfa htiyakrahrm kmi kmim.” ");
INSERT INTO amp_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nd mrokfom Pitar sinyahato pthamom, bok met yindarim kfram kanjo wasmomm. Sinyahato mkfo memom, “Nd mrokfom nndo kfraye fwitmm nmoh yima yuhum. Finji naruhanom?” ");
INSERT INTO amp_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pitar kfo memorm, “Nhai finji. Nikmoh yima yuhum yorhwa fasoh fasoh nefm mong trohkfot. Mong trohhato Jisas Kraisrhu yufatpno baftaiskfot. Inji narahko, nikmoh fasoh fasoh nefm Bro Nkifrar nhai wom dukaruhatrm. Duka mumafhato turhu Yafothat hirahrko. ");
INSERT INTO amp_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Bi tu Bro Nkifrar kfo hta memor, ‘Na kfak hanyruha yimam tukanhu Yafothat hi hanyruhanm.’ Nhai be nikomrpakom. Nikmoh yonm hi hany bugarahrm. Wuri toh hanyukm he buga hanyrahrm.” ");
INSERT INTO amp_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Pitar nhai be nd mrokforpam ptharmor. Bok kfo yanho mrokfom kfo memorm, “Yo niko dukahato tohkfot. Fasoh fasoh nefm nayet yimampno kanga rpat faso yak bebrahrko.” ");
INSERT INTO amp_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pitar kfo pthamo mrokfom nhai hanyjbornarmomm. Hifa wany yakiohato baftaismom. Nd yiha wom nfri 3,000 yimam Jisasr hiket yimampno mnathu hmbrehato be yonmari rifuhetr rhumor. ");
INSERT INTO amp_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nd nfri yimam nia hanyukm tu aposermpno afo rpat tohhato afo kak nuhas bonuhasmoumm Jisasrhu hik yuham, Kristen yimaroh tohefm, tamoh komunion yaknefm, kfo bruttnanefm, hti hik bohikmoum afo. ");
INSERT INTO amp_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Bok mirakerkfom Bro Nkifrar aposermn mithu nawohhato namoatmm bok met yindarim yafotha duhatm rhumoum. ");
INSERT INTO amp_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Nd tuhant yindars Jisasrhu mrokfom yi wany yakiomoam nhai nndoh nndoh yima yuhetm rhurmom. Rroh yima yuhum be rpa yima yuhurpa mifr rhumor. Tamoh tamoht tum be rim nahiyak mnahiyakmom. ");
INSERT INTO amp_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Yimam bbinysofetm wom yimam yihato wiknamoahat nd bbinysofetmn yakyuk marut yakmoamtn tfit yimam wuska duhatm o marufapa duhatmn tfit nd marut thu brurhemoum. ");
INSERT INTO amp_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Yiha yiha Bro Nkifrarhu temperr yi rifinyneft rom rpat yihato rifinymoum. Nuwa yanyeft nhaf, wom yiha womrhu kunys famoamn tfit wom yiha womrhu kunys yi famoum. Tum rpat ptha yindhorhato niyak marnyahato rpat nuwa famoum. ");
INSERT INTO amp_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Rpa yima yuhurn rhu yindhormoatm womm inji htihato kfo yindhormoumm. Yiha yiha bok met yindarim Bror yak miyak hanymoatrm nd Kristen yimam nhai wom kuken rifhur rhurmor. ");
INSERT INTO amp_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Wom yiha Pita Jonrof memof, “Bro Nkifrarhu temperr yihato kfo bruttnarahno.” Krifmar tri kilok kfo bruttnetmn to be krif yimof. ");
INSERT INTO amp_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Yihato yuhre mtoh hanymof asha htiyak hanymofm wom yimam rikiye yimar hnamomr. Nd Pitarof yimo rmonthu yifhatikthu yufat futamoumt “dborioh yifhatikt.” Nd rikiyer nd yifhatiktn mhtamomr. Ndha rhumoarn yimam rmont fkneniyukm maruha tndau yakitoh hanymour. Nd yima rikiyemohat mmemt bi inji ruhetr hiyaumotr. ");
INSERT INTO amp_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Pita Jonrof fau fkneni hanymof tndaumorf. ");
INSERT INTO amp_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Tndaumotr rof rim tohmof. Pitar memorr, “Wayuka-tohnno.” ");
INSERT INTO amp_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Inji kfomotrr ror Pitarof yukatohhato memor, “Ka wuska kahukfa.” ");
INSERT INTO amp_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pitar kfo memorr, “Na nhai ninhu hayuk maruham. Ndar na uhiyau ahiyauwamn hiruhann. Na kfiwa Nasaret thof Jisas Kraisrhu yufatn wasinya wayauyakni.” ");
INSERT INTO amp_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pitar inji kfonihato tirmifkorhof tirt yakhato wateh kasinyakmorr. Be nd hokmo wuram susnanimomr. ");
INSERT INTO amp_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Susnanimotmr tuha yura msuh tanyhato mitohmorn tuha rim fau nfak mfau nfakmor. Pitarof rmont fknenimohat ror rpat fknenihato ror yauhany tuhatokhany yauhany tuhatokhany inji nahanyhato Bro Nkifrar kfo yindhor hanymour. ");
INSERT INTO amp_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","10","Nd rmont rhuyuk yimam tuhatok hnehato Bro Nkifrar kfo yindhor hanymoatr memoum ka froher. Kto hti hik marnyamomrn kfo memom, “Nd yimar dborioh yifhatikt rhuhato maruha tndaumoa yimayer.” Be tuha nd rmont rhuyuk yimam inji htihato mrokfo duhatm rhumom. ");
INSERT INTO amp_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Solomonrhu rmonthu rhu nafifyuk tkittn rhu hasetfn ror niahato mkinyafinyaknihato ki yindhormorf. Ndha mtohmotr yimam toneyaknihato mtoh htimoumr. Inji htihato mrokfo duhatm rhumom. ");
INSERT INTO amp_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Nd yimar mtoh-hato yukatohmoa yimam Pitar sinyahato kfo memorm, “Niko ndar Isrer thofko tamohmpno ndar rikiye yimar marnye nmbuhat htihato duka kinyakiwakomn tfit nonn yukatoh-wako? Niko to mirahko nko ka nnoh bbukeftpno nnoh dborioh nefmn Bro Nkifrar htihato no kfitno ndar yimar marnyer. Nhai nonn. Afo apthakahta wawanyswako. Jisasr fak marnyerr. ");
INSERT INTO amp_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abraham, Aisak, Jekofroh Bro Nkifrar, nmoh nkifraroh Bro Nkifrayer. Nd Nkifrarn turhu hingrna yima Jisasr tu bro yufat hemor. Tor, nd yimarn niko hndhnamoko. Pailatr yafho yibonkfot kfomohat niko nhai kfo yakiormoko. ");
INSERT INTO amp_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Nd yimar be tu Bro Nkifrarhu yinhit tohmour. Tu hifa yufayet yimar tohmour. Nd dborioh yimar Pailatr yafho hermorko. To nhai. Nd fasoh yima wasetrn kfomotko fafuhafhemorko. ");
INSERT INTO amp_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Tu hifa dborioh rhu nmbuhat hnayuk yimar nikomn wasmokomr. Wasmohat nhai Maringour mitohnirmor. Nd yimar nohmorn tfit sinyamor. Ror sinyamohat nnoh nyingam htimomr wiyau yaumohat. No htihato kfo nuhaswononko. ");
INSERT INTO amp_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ndar yimar marnyehat rorhu bbukeftpno marnyanir. Nnoh dukefm rorpar htanyonm. Inji dukahato kfo pthino nikmoh nyingahato ndar yimar marnyer. ");
INSERT INTO amp_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Rot nd nikomi nikmoh bro yimam namo neft Jisasr nhai be yima dukeftpno narmokomr. ");
INSERT INTO amp_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Bi tu Bro Nkifrarn profetm mthu nawohhato kfo pthamohat rorhu noh nmbuhat to be fak hik twanhomot. ");
INSERT INTO amp_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ndnettn nd niko hatohwa fasoh fasoh dukefm mong troh bugahato Jisasrpar tfit nikmoh dukefm htakfot. Inji narahko, Bro Nkifrar htiruharko nikmoh yima yuhum rhuyuk fasoh fasoh nefenm yak wus bowus thu bugarahrm. ");
INSERT INTO amp_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Yima yuhum wutham rhurahmko Bror tfit nfri bbukeft hirahrko. Rhu marnya hasetkomn nd niko nia yakyuk yimar nierahr. Bro Nkifrar fak htamorr nd yimar. Rorhu yufat Jisasr. ");
INSERT INTO amp_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Afo yura hefenrn korhwor. Profetm kfomo yuhatn bi tamoh tamohroh yak wus bowus yihayere ee btn yawihnerahr. ");
INSERT INTO amp_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Bingot to Mosesr kfo memor, ‘Bro Nkifrar na kanjohot Juda frikefthu profetr yak htarahrr. Ror tamoh tamoh mrokfom kfiwurko niko wanyhato hikkfot. ");
INSERT INTO amp_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Rorhu mrokfom wany yakio duha yimam be Bro Nkifrar yak tutfa wurasohruhatrm noh witarahm. Nhai tfit Isrermpno fkniyakruhatm.’ ");
INSERT INTO amp_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Profet Samuerr rorhu mongko tohhnamo profetm pthahnamoa mrokfom ndar yiha rhuro nefmn pthahnamoum. ");
INSERT INTO amp_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Niko to nd profetroh yon kunyet. Nikmoh nkiframpno Bro Nkifrar kfo htatamo mrokfot to kangko frohmn nd neft rhuraht? To nikomn. Bro Nkifrar Abrahamr kfo memorr, ‘Ninhu frikefthu wom yonr tohruharn rorn bbinysof thof bugam tu hifa rhu nmbuhat hirahrm.’ ");
INSERT INTO amp_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Nd dukeftpno niko dukahato rorhu hingrna yimar nia nohhato tfit kasinyamorr. Bro Nkifrar duka memor, ‘Yak marnya bomarnyarhotanm fasoh fasoh nefm mong trohrahmm.’ Ndnetrn inji inji hingrna hta bohtamor.” ");
INSERT INTO amp_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita Jonrof yuhre nd rifinymo yimam mrokfom kfo ptha nuhas haso hanymofm asha prismi Sadyusim yo rmont tohukatohyuk yimaroh bro yimar rmont yau fknenihato rim tohmom. ");
INSERT INTO amp_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Nd yimaroh dukeft duka memom, “Nd yimaf nhai wom tamoh mrokfom kfokahfm. Noheh yimaroh tfit sinya yuhatn kfo nuhaswofm. Kfo kangfm, ‘Jisasr nohhato tfit sinyamo kanjo inji narahm yimam noh neft.’” Nd dukefm yakmotmm namburmom. Memom, “Tamohmpno inji kfiwafm?” ");
INSERT INTO amp_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Be ndnatn tir tir fakmomf. Marr bi yohniyetrn to be afo rumgatn afo fak htatamomf. ");
INSERT INTO amp_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Nd Pitarof pthamo mrokfom bi 5,000 yimam wany yakiohato hiketmn rof fakmomf. ");
INSERT INTO amp_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Hwe nfha dbha Juda kaunserroh bro yimam, yo prisroh bro yimam, ee boririfhuthu tisam niyak nhafohhato Jerusalemrpar rifinyhato napthamom. ");
INSERT INTO amp_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Nd yihart Anasrn Judaroh bro tohak prisr tohmor. Rori rorhu tangimi Kaiafasr, Jonr yo Aleksanderom, rompno rpat rifinymom. ");
INSERT INTO amp_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Rroh nyingampno myak htatahato kfo ttiwonmomm, “Nifn nd yimar yak marnyewohate tamoh bbukeftpno yak marnyewafnr yimar? Frohroh yufat yutahato kasinyewafnr nd yimar?” ");
INSERT INTO amp_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","9","Pitar bi Bro Nkifrarhu Yafothat bi mthu nawohetrn kfo memorm, “Niko nda Juda kaunserroh bro yimakomi yo niko nda prisroh bro yimako, kangko nd rikiyer marnyamo yuhat attiwon hiknom? ");
INSERT INTO amp_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Nda rikiyer marnyamohat nhai finji nahato marnyarmor. Nd niko Isrer thof bugako kihegir nohhato tfit sinyamo Nasaret thof yima Jisasrhu bbukeft kfomot nd yimar marnyanimor. ");
INSERT INTO amp_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Bro Nkifrarhu rfa borngtn kfo memom, ‘Nd kunyshu dany rahur htayuk yimam hti hhrekhato yak tuhafmor, bi tfit dany rahur tohwor. Nd dany rahurn kunyr hatohworr.’ ");
INSERT INTO amp_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Nhai wom fitoh yimarn nom bi yitohwa tkit bebt yakruhatrnom. Jisasrpar yakrahrnom. Rorrpar Bro Nkifrar fak htamor nmoh yakyukr.” ");
INSERT INTO amp_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pita Jonrof toh pthamohat nhai yakrmehato mrokfom ptharmofm. Juda kaunserthu bro yimam htihato tuha mrokfo duhatm rhumom. Duka nhta memoum “Ndar yima furayef. Fitha yakmofr ndhtet mrokfo rifhur? Ndar yimaf ka Jisasrpno toh habrihato nd mrokfo rifhur fakmofr.” Inji dukamom. ");
INSERT INTO amp_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Nd marnyanimo rikiyer Pita Jonrofpno tohmotr be nhai wom mrokfom ptharmom. ");
INSERT INTO amp_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Be ndnatn afo kfo memomf, “Wafnahnifn.” Fnahnimotf tum bro yimarpam rhuhato mrokfom nafak nhtamomm. ");
INSERT INTO amp_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Womm sinyahato kfo memom, “Barenko, niko finji dukewako? Nd yimaf naro neft bi Jerusalem thofm bi hti bugaromt. Nhai kfo miruhatnom, ‘Nd yimar finji yak marnyarfofr.’ ");
INSERT INTO amp_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Kfo raforahnomf Jisasrhu yufat yutahato yimam yak kasinyaneft.” ");
INSERT INTO amp_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Nd mrokforpat yak dbkafmomn tfit nakuyakmomf. Nakuyakhato kfo memomf, “Arihat nifn mirahfn tfit Jisasrhu yufat yuta nawohhato yimam ayak kasinyanonm. Arihat Jisasr yufat wayafho thu-twafnt.” ");
INSERT INTO amp_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pita Jonrof inji wanyhato kfo ttiwonmofm, “Niko to finji dukewako? Fitoh yuhat no hikneft Bro Nkifrar htihato yindhorrfor? Niko kfi tngtn o Jisasr kfoyuk tngtn? ");
INSERT INTO amp_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","No nhai niko kfoyuk tng yuhatn hikruhatno. No htimo nefm no wanymo mrokfom afo tunonn kmi kmi kfo nuhas bugarah-nonm.” ");
INSERT INTO amp_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","22","Nd rof yak marnyamo rikiyer bi bro yimar, bi 40 gunyjimetr. Kmi thofm nd rikiyer yak marnyamo neft bi hti yindhorhato Bro Nkifrarpar yindhormom. Be ndnatn kaunserm htitihato be kfo yanho mrokfot kfo memomf, “Jisasrhu yufat yuta nawohhato dbohnet yimam yak marnyarahfnm, be yakrahnomfn.” ");
INSERT INTO amp_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pita Jonrof kaunserm kfo tkrur memomf, “Tufnhuko waiswafn.” Be tufhuko yihato tufhu yimatm kfo nuhas bonuhasmofm rof kot tohhato bro prismi kaunserroh bro yimam kfo pthamo mrokfom. ");
INSERT INTO amp_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Kfo srh nuhas buganimofmn tfit tum rpat rhu rifiny-hato Bro Nkifrarpno kfo bruttnamom. Kfo bruttnahato kfo memomr, “Broye, ninn hingrnamonm bbinysoft, mount yo marombt ee nd husfirpa tkitm yorhwa shrm. ");
INSERT INTO amp_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Bingot tunhu Yafo-thatn nmoh nkifrar ninhu hingrnafat tohmoa yima Defitr wom mrokfot kfo nuhasmotnr tfit ror kfo memor, ‘Tamohmpno tuhan yindars be mfro namburwam? Tamohmpno nd wajis be harhu fura bofuriwamt? ");
INSERT INTO amp_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Wuri kmirhof kingm wajis bi harhuwom. Kmi kmirhof bro yimam bi rpat rhuhato mrokfom nayak dbkafwomm Bro Nkifrari nmoh nrfa htiyakyuk yimarhu nambur tonineft.’ ");
INSERT INTO amp_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ndar kmit to nd neft bi korht. Herotr, Pontius Pailatr, yo wom yima tangim yo tu Isrerm bi rpat nathu hmbritamn kangm ninhu kfo htamo hingrna yima Jisasr awasnomr. ");
INSERT INTO amp_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","To ninhu bbukeftpno bingot kfo hta mrokfot to tot inji ruhaknitatn be was mifrahmr. ");
INSERT INTO amp_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Bro Nkifraye, nd yimam kfo kakrmitwomnom. Nom nhai wofnkahnom yakrmanyeft. Ni tunn wathu bmtatwannom ninhu mrokfothu pthaneft. ");
INSERT INTO amp_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Dbohnet yimam wayak marnya bomarnyatwanm. Ninhu hingrna yima Jisasrhu yufatpno mirakerkfom wanakahtn yimam htirahm.” ");
INSERT INTO amp_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Inji kfo bruttna hanymom, nd rom rhumo kunys memom nndo nunes kekwott. Bro Nkifrarhu Yafothat thu nhombra bugamottm rom tohhato pthamohat mrokfom nhai yakrmehato ptharmomm mrokfom. ");
INSERT INTO amp_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Jisasr hikmo yimam nhai womr wom nndoh yima yuhetr rhurmor. Yima bugam be rpa yima yuhurpar rhumom. Rom yakitohyuk tamoh tamohm nhai womr marimorr, “Nanhu tamoh tamohm turpetanuhem.” Nhai. Tamoh tamohm be inji rpat yakitoh-hato rpat nayaktirmoumm. ");
INSERT INTO amp_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Aposerm Jisasrhu nohhato sinya yuhathu mrokfom kfo pthamoahat Bro Nkifrarhu Yafothathu bbukeftpno pthamoatmm mrokfom tuhan yindars rhuhato wany marnyamoumm. Bro Nkifrar tohnhomoarmn fak marnya-mourm. ");
INSERT INTO amp_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Yak marnyamoatrm nhai rroh womr yeshrim o tamohm sfno tohrmoar. Yimam bbinysofetm, kunyetm womm hemoatm wiknahemoumm. ");
INSERT INTO amp_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Nd yuham yakyuk marut hnamoamt tfit aposermn mhemoum. Aposermn yakhato romn yak nhtahato frohm tamohmn kaknafwom nd marut romn kak nhtahemoum. ");
INSERT INTO amp_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ndha tohmour wom yimar. Rorhu yufat Josefr. Aposermn tfit wom yufat futamomr Barnabasr. Nd Barnabas yufathu yimbu yuhate, “Yima kfo bmta marnyetr.” Barnabasr, Saiprus tohmoa Lifai tangishofer. ");
INSERT INTO amp_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Nd yimarhu bbinysoft yimam wiknamohat marut yakmot aposerroh tirmn mhtamorm. ");
INSERT INTO amp_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Yo tof wom yima sawohf tohmouf. Ramemrhu yufat Ananaiasr. Tuhanemthu yufatne Sapairat. ");
INSERT INTO amp_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Wom yiha Ananaiasrhu bbinysoft womm yihato wiknamomt. Nd bbinysofthu marut yakmortn nhai marimor, “Be hopttn aposerm hne-hiruha.” Nhai. Nd marut yakmortn womm yak hamong tanyhato wom farpam hanyhato aposerm mhemor. Ananaiasr inji namohat turhu tuhanemt htimotr. To nhai kfo marimotr, “Mirahn inji anaya.” ");
INSERT INTO amp_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Aposermpno mhtamotrm Pitar htihato kfo memorr, “Ananaias, tamohmpno Satanr fasoh yima yuhur yahutrn wom maruham yak hamong tanynmn wom farpam hnehato Bro Nkifrarhu Yafothat nd farpam mfrnhehwanr? ");
INSERT INTO amp_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Nd bbinysoft yima tafi wikna duha rhumohat nhai wom frohroht rhurmot. Ni tunhut rhumot. Tfit yimam wiknahato marut yakrohat nhaf tunrpann hmbreront. Tamohr inji namotrn inji naro? Nhai yimanomn kfo namhi nhehkahn. Bro Nkifrar kfo namhi nhehwo.” ");
INSERT INTO amp_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Pitar inji kfo hanymor Ananaiasr nndo dangn yukhat tmbho thumom. Be tuha gur. Kmi thofm Ananaiasrhu noh mrokfot wany hanyhato mfha tha duhatm rhumom. ");
INSERT INTO amp_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Be nd yima Ananaiasr bi gurn, damiagt rmonthaye rim yakrirakmomrn hany fopmomr. ");
INSERT INTO amp_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Husfirpa auakfot bi yiyettn asha tuhanemt. Rot memot ramemr yuhre yima nfriyer. ");
INSERT INTO amp_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Rim tohmott Pitar ttiwonmort. “Nifn sawo bbinysofthu maruhame be dfik fenrpam fakmofn?” Sapairat sinyahato memot, “Uwa, to be nd hne dfik fenrpam.” ");
INSERT INTO amp_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pitar sinyahato kfo memort, “Bare, tamohm-pno nifn sawo memofn, ‘Bro Nkifrar afo mkfo namhi nhehwonrahnonr.’ Wahti ninhu ramemr myop tanyuk yimam bi tom bi nd kuny yifhatiktn tohwom. Ninhu tha tipt yoprahmt.” ");
INSERT INTO amp_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Pitar inji kfo hanymor Sapairat memom nndo dangnhatn tmbho tuhefim. Be tuha gus Pitarhu wurampno suhmot. Be nd damiagt bi mtoh gari hanyukt yaknimomtn ramemr yopmo tkittn rpat fopmomf. ");
INSERT INTO amp_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Bro Nkifrar hiket yimam yo ndwom yima fura bofurat nd yima sawohfhu noh mrokfot wanyhato fanho bugamom. ");
INSERT INTO amp_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Boknambok nefm aposerm namoatmm tuhan yindars htihato mfham danyrn foh tnehmoumm. Jisasr hiket yimam Solomonrhu rmonthu rhu nafifyuk tkitt rhuhato Bro Nkifrar kfo bruttnamoum. ");
INSERT INTO amp_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Barkofpam nhai wom yima furam rhunhohato kfo bruttnanhormomm. Duka yanhoneftpno be tngrpaye kfo yindhormoumm. ");
INSERT INTO amp_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Kto memom nndo tek bu yenyfahtn tehbubekm. Boknambok yimam Jisasrhu mrokfot hikmom. ");
INSERT INTO amp_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Aposerm hingrnamoa nefm bi kmi kmim wanyetmn rroh dbohnet yimam yaknimoamm Pitar yauhnamoa yihotamn mkahahwetamoumm. Duka memoum, “Pitar yauhnehato rorhu yafothat yak hnkoknruhattm tamoh dbohnefm thu trohrahm.” ");
INSERT INTO amp_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Jerusalem taunpno toh hanyuk kmiroh dbohnet yimam, yo kmi yarhm fknayet yimam yaknimoamm aposermpno hanymoumm. Hanymoatmm dbohnefm o kmi yarhm thu troh tany hany-moumm. ");
INSERT INTO amp_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Bro tohak prisri rorhu yarmotem Sadyusim, rom nd aposerm hingrnamo nefm htihato yuhuwehmoum. ");
INSERT INTO amp_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Namburhato be nd yimam yak-momm kalabus htamomm. ");
INSERT INTO amp_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Aposerm bi kalabus kunys tohetmn yifungnano Bro Nkifrarhu mounmotr yihato tfanyakmorm. Tfanyakhato kfo memorm, ");
INSERT INTO amp_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Waikahkomn rmont rim tohhato tuhan yindars wakfo nuhas-twakomm ndar nfri yuhathu tohneft.” ");
INSERT INTO amp_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Be nd aposerm inji wanyhato dbha rmont yimomn tuhan yindars kfo ptha nuhasmomm nd nfri yuhathu toh hikneft. Bro tohak prisri rorhu yarmotem Sadyusim nhai tawisafrmom aposerm fnahnimohat. Rom memom ka tom. Ndnetmn naku nhafohmomm kaunsermi yo Isrerroh bro yimam. ");
INSERT INTO amp_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Yi nhafoh bugamotm aposerroh yakyuk polism kalabus yimom. Yimomn be yihom tone hambromom brioh tkittn. ");
INSERT INTO amp_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Nd polism tfit yihato mkfo memom, “Barenko, nom yifi-nomn kalabus darmb kihett yo gatyuk yimam mano mano ftohm. Nom tfanynihato rim fnahni famunom ka tome yaknirahnomm. To nhai, be brioh tkitt rim htitawonom. Nhai htirfonomm.” ");
INSERT INTO amp_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Rmont tohukatohmoa yimaroh bro keptenri bro prism inji wanyhato duka memom, “Tone nd yimame fitoh yuhatn yimom? Nome nko finji wany-ruhanom?” ");
INSERT INTO amp_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Wom yimarn yihato kfo memorm, “Barenko nd niko hambriwa yimam wusom bi rmontn tohhato Bro Nkifrarhu mrokfom tuhan yindarim kfo ptha nuhaswomm.” ");
INSERT INTO amp_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Be nd bro prism inji wanyhato nd keptenri polism kfo tkrurafmotmm yihato nd aposerm fakmom. Myak-mohat nhai finji narmomm. Kmi thofm hti yakrmihato memom, “Tahiye tahiye tabotrahmnom.” Ndnatn nhai finji narmomm. ");
INSERT INTO amp_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Polism yihato aposerm yak-mommn kaunsermpno hanymomm. Kot tohhato prisroh bro tohak yimar sinyahato aposerm kfo memorm, ");
INSERT INTO amp_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Nikome wanymoko nom kfo rafo mrokfot kfomohat. Kfo memonomko, ‘Mirahko Jisasr kfo htaniyuk mrokfom tfit niko yaknihato Jerusalem thofm akfo nuhas htfasnomm.’ Inji kfomo-nomko. To nhai. Niko nhai wany yakiormoko. Yi pthamotko Jerusa-lemtpno brbo rhuyuk kmim bi wany bugarom. Tfit nomn kfo kangko, ‘Romn nd yimar fwitmr.’” ");
INSERT INTO amp_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pitari wom aposerm sinyahato kfo memom, “Nom nhai wom yima furaroh kfoyuk tngmn hikkfot. Tu Bro Nkifrar kfoyuk tngrpatn nom hikkfot. ");
INSERT INTO amp_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Niko to bi yura bgre misn Jisasr tuhegirmotkomr yura bgre misn mfaknimor. Hifa nmoh nkifram yakitohmoa Nkifrarn Yafothat thu hmbremotrr tfit mfenyjwomor. ");
INSERT INTO amp_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Bro Nkifrarn Yafothat thu hmbreyaknihato yura hefenrn hamuhhato turhu tirmifko htamorr. Htamotrr nmoh nrfa htiyakyukr tohwor. Rorn nom Isrernom dfa tikr hta tehakmornom. Nd fasoh fasoh nefroh mong trohhato yak thunefm rorn fak nuhasmornom. ");
INSERT INTO amp_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Bro Nkifrar hingrnamo hingrneft bi tunmoh nyingaye be hti hikhato kfo nuhas hanitnomm yimam. Bro Nkifrarhu Yafothatn kak nuhas marnyewutm nom kfo mmoni hanita mrokfom. Yimam Bro Nkifrarhu mrokfom hikwam Yafothar hi hanitrm.” ");
INSERT INTO amp_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Kaunserm nd Pitar pthamo mrokfom wanyhato yima yuhum nhai marnyarmomm. Yima yuhum namburhato memom, “Aposerm awasnom.” ");
INSERT INTO amp_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Hifa wom kaunserr tohhato wom kaunserm memorm, “Aposerm afo afnahnim.” Nd kaun-serrhu yufat Gamalier. Farisi hingrneft rorn kakitohmourt. Nkifra boririfhut to ndhtet yimamn fakitohmoumt. Rorhu nefm tu dboriohmn wom rirhu arhuyuk yimam kfo yindhormoumr. ");
INSERT INTO amp_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Aposerm fnahnimotm Gamalierr wom kaunserm kfo memorm, “Niko, Isrerko, kangko, ‘Tamoh nefm ananomm ndur aposerenm?’ Afo duka marnyaf hanyhato btn tamoh nefm nakfot. ");
INSERT INTO amp_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Niko Teudasrhu gnngr yakitoh hanykfot. Ror inji namor. Kmi thofm kfo brur bobrurmotrm kmi kmi nafakmomn memom wom hingrneft hingrnarahnom. Ndnetmn 400 yimam nayakhato Teudasrn nyingako tohmor. To nhai. Nd Teudasr yimam wasmotmr, nd hingrneft mfak htanimomt. ");
INSERT INTO amp_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Yo tfit Galili thof Judasrn wom neft namor. Bro sensispno yimam yak nhafohmorn memor, ‘Nd yima wohnr-pno yihato gafman yimampno nnarahnom.’ Nd kmim nayak haso-momn Judasr mteh yifhumor bi be, nd yimam natubatumom. ");
INSERT INTO amp_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Na nd nefm bi hti hnayetann ndnetann kfo rafiwanko aposerroh wasneft. Rom tamoh hingrnefm hingrnewum be nyingarpaye yukatohaf hanykfot. Rroh fijo hingrnewum, nhai toh bmtaruhatm. ");
INSERT INTO amp_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Bro Nkifrar yima yuhum yahutrm nd hingrneft kasinyemt, nhai nikomn tfit buha mtohhato kfo rafokfot. Inji naneft be yuwi kangko, ‘Bro Nkifrar yak batirnome.’” Gamalier bi inji kfiwure, be wom kaunserm nhai wom ptharmom. Be ror kfoyuk yuhatn hikmom. ");
INSERT INTO amp_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Be inji nakfo nohmomn tfit aposerm nakuyak-mom. Nakuyakhato rim fnahnimom. Rim fnahnimotm be wife frtmbho botmbhomomm. Inji frtmbhonihato bro kfo rafo mrokfom hemomm. Kfo memomm, “Arihat be tfit mirahko Jisasrhu mrokfot met yindarim akfo nuhas habrinomm. Be tmifko.” Inji kfonihato memomm, “Wafnahniko.” ");
INSERT INTO amp_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Be fnahnimom. Fnahnimohat nhai wommpno yihato rim kfo nur marimom, “O nom nd yimam ftatmnom.” Nhai. Rom to be yindhor yima yuhurpno yihato kfo memom, “Nhai mrokfom. Nom Jisasrhu mrokfom kmi thofm kfo ptha nuhaswatnom tatwomnom, nhai mrokfom.” ");
INSERT INTO amp_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Nd Jisasrhu hingrneft nhai yafhormomt. Yiha yiha rmont yihato Bro Nkifrarhu mrokfom met yindarim kfo ptha nuhasmoumm. Met yindarim kfo nuhas marnya memoumm, “Bro Nkifrar kfo hnamoa yimar tor nd yima Jisasrn kfo hnamour yimaroh minrfa htiyakyukr.” ");
INSERT INTO amp_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Barkof yimam Jisasr hikmoam nhai bokm rhurmom. Kto hingrna hanyspno rifinysamom. Rifinysahato tfit tuhan dhirroh maruha yak nhta marnya he duha nmbuhatpno wom Judam, Grik yarmumat pthetm, duka marimoum, “Barenko, ndar aposerm yekwa marut nmoh tuhan dhirpam nhai hekahmm. Be Aram kfetroh tuhan dhirrpam kahukm.” ");
INSERT INTO amp_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Be 12-pela aposerm wanyhato naku nhafoh bugamomm Jisasr hiket yimam. Nakuyak bugahato kfo memomm, “Nhai wofnkahnom Bro Nkifrarhu hingrneft yakitohhany yo tfit tuhan dhirroh maruham yakitohekfot. Ka hus hingrnef bugaf yakitohneft ka Bro Nkifrarhu hingrneft miyafho thuniraht. ");
INSERT INTO amp_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ndnatn nom kangnom 7-pela yimam wayakko. Wayakkahtko romn nd hingrneft yakitohrahm. Tuko hti hanyhato fitoh yimar Bro Nkifrarhu Yafothat yorhwattr rorhu dukefr riduka adukewurm tamoh tamohm, ndhtet yimam yakhato nd hingrneft yak htarahnomr. Nome nhai nd hingrneft yakitohkfot. ");
INSERT INTO amp_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nmoh hingrneft to be kfo bruttnaneft yo Bro Nkifrarhu mrokfot kfo nuhas to be nd hingrneft nom tohkfot.” ");
INSERT INTO amp_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Nd rom pthamo yima yuhur met yindars ufakmomr. Me-momm, “Nd niko kfiwa yima yuhur hifa pthiwuko.” Ndnetmn Stifenr, tu Bro Nkifrarpno frtkafhato Bro Nkifrarhu Yafothat ruhetr, yo Filifr, Prokorusr, Nikanorr, Timonr, Parme-nasr ee Nikolasr, nd nd yimam fakmom. Nikolasr ror nndo yima tangiroh kmi Antiok thofr. Bro Nkifrarhu rmon mrokfeft riwanyak-hato Bro Nkifrar hikmor. Tfit kto Jisasrhu mrokfeft hikmoatr ndnatn ror rpat fakmomr. ");
INSERT INTO amp_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Aposermpno hanymotmm romn tir htahato kfo bruttnamomm. ");
INSERT INTO amp_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Be nd Bro Nkifrarhu mrokfot mfaknimomt kmi kmim ptha fnahmotmt bok met yindarim wany wofnmomt Jisasrhu mrokfot. Tuha Jerusalemt ndnatn bok Kristenett rhumot. Yo nd Bro Nkifrarhu temperr tohukatohyuk yima prism, Bro Nkifrarhu mrokfot wanyhato rroh bokm Jisasr hikmom. ");
INSERT INTO amp_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Bro Nkifrar hifa hifa yak marnya bomarnyamorr Stifenr. Yak marnya bomarnyahato bro hingrna bbuka yafothar thu hmbremotrr wonk wonk nefm namourm. Met yindarim ror namoa nefm htihato yafotha duhatm rhumoum. ");
INSERT INTO amp_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","To tfit wom kmi thofm sinyahato Stifenr pthayuk mrokfom kfo hanyjbornamomm. Nhai fitoh kmim inji narmom. Judaroh wom rhu rifinyuk rmonr kutamoumr Frimanroh rmonr rifinymoa yimamn kfo hanyj-bornamomr Stifenr. Nd yimam Areksendria thofmi Sairini thofm yo Siristia thofmi Esia thofm rpat nathu hmbrihato Stifenr pthayuk mrokfom kfo hanyjbornamomm. ");
INSERT INTO amp_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Memom, “Ka nomn sinyahato tamoh mrokfom kfo nohafrahnomr Stifenr.” To nhai. Bro Nkifrarhu Yafothar dborioh dukefm hemotrr nhai romrpam ptha nohrmomr. ");
INSERT INTO amp_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ptha nohafmotrm ndnetmn wom yimampno yihato mkfo memomm, “Wakfo wamitwako, ‘Stifenr wanymonomr Mosesri Bro Nkifrar faso faso kfomorf.’” ");
INSERT INTO amp_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Rom nd mrokfot yaknihato mhta wokmotm kmi thofm, tohak yimam, boririfhuthu tisam sinyanihato Stifenr fakmomr. Yakhato kaunsermpno kot hanymomr. ");
INSERT INTO amp_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Stifenr bi mrhumotr ee mrokfot hta wokyuk yimam mongko yimom. Mtohmomn mkfo memom, “Nd yimar yiha yiha Bro Nkifrarhu temperr faso faso kfo bebworr yo Mosesrhu boririfhut ndt nhaf faso kfo bebwort. ");
INSERT INTO amp_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nd yima Stifenrparn nhaf kfo memor, ‘Nasaret thof Jisasrn nd nkifra rmont yak tebosohrahrt. Nkifra boririfhut nhaf inji. Yatkt yak tuhaf-ruhartn tfit nfrit yak htarahr.’” ");
INSERT INTO amp_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Nd kot swirt tohyuk yimam Stifenrhu nyingatikt wahtimohat memom nndo mounmotrhu nyingatikt fnhutwotr. ");
INSERT INTO amp_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Bro tohak prisr kfo ttiwonmorr Stifenr, “Stifen, ni wakfo ptha marnya. Nd rom kfo pthiwa mrokfome ka tu wany mifmomn pthewum?” ");
INSERT INTO amp_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stifenr wasinyahato kfo memor, “Yinouroko, nann afo pthakahta wawanyswako. Nmoh nkifra Abrahamr tafi Mesopotemiat htanyhato Haranko yi duhatrn yura mounthu tu bro bbukayet Bro Nkifrarpno nahtimofn nakfo pthamof. ");
INSERT INTO amp_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Nd yiha Bro Nkifrar kfo memorr, ‘Ndar tunhu kmit, ninhu yifammam, ndm wahtanyswanm. Wahtanykahnm waiswa na kfo nuhasaforuha tkittn.’ ");
INSERT INTO amp_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","To be nd yiharn Abrahamr Kaldiaroh kmit htanymortn yimor Bro Nkifrar kfomo kmi Haranko. Be Haranko tohetrn yifemr nohtanimotrr Bro Nkifrar yak hatohhnamorrn tfit ndar nom Isrer-nom arihat tohwa bbinysoftn fak htamotrr tohmor. ");
INSERT INTO amp_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Bro Nkifrar ndar bbinysoft yak htamohat nhai kfo nuhas marimorr, ‘Ndar bbinysoft ninuhet.’ Nhai. Be kfo memorr, ‘Ni ndar bbinysoft toh hanyruhann nohnirahn kto tfit ninhu yon frikar ndar bbinysoft yakrahm.’ Bro Nkifrari Abrahamr nd tkitt nakfo nuhasmohat Abrahamr to mirahko ka yonetrn inji nakfo nuhasf. Nhai. Abrahamrhu mett nmbit tohmout. ");
INSERT INTO amp_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Bro Nkifrar kfo memorr, ‘Ninhu yon frikar sinya thoft 400 gunyjimm afo womroh yinhit tohhato afo wommn hingrna hafknirahm. Wom kmimn yejimmoh thurahmm nd yiham. ");
INSERT INTO amp_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Inji nahany inji nahanyruhamm to tfit kto rom yak beb hasoyuk kmim nann krhopam hirhotanm ndt htihato yafuhafrahmm. Yafuhafruhatmm tfit ndar ni kfo nuhaswa tkitt nieruhamn na kfo tatorahma.’ ");
INSERT INTO amp_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Bro Nkifra Abrahamrof mrokfom nayak dbkafni-mohat Bro Nkifrar sinyahato Abrahamr kfomorr tha puk thuneft. Memorr, ‘No mrokfom nayak dbkafhat, ni tha puk thuwa tkitt hti hanyruhann mdukak hanyrahn nani ni mrokfot nayak dbkafhat.’ Kto rorhu barkof yon Aisakr nurnimohat trku rijohit rhunihato 8-yuk marrpno tha puk thumorr. Tfit Aisakr bronihato tuhant yakni ror nasakmo yon Jekofr nhaf nd rpa yuhat hikhato tha puk thumorr. Tfit Jekofr nasakmo 12-pela yonm, nmoh nkifram, nd nkifra neft hikhato tha pukthu bugamorm. ");
INSERT INTO amp_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Nd 12-pela nkifram rroh womr Josefr. Nd yima Josefr rorhu wom najomrom nhai dborioh neft narmomr. Faso riduka bebakhato wom kmimpno nahehato wiknanimomr. Ijifmn wiknani hanymomr. Josefr Ijift yi tohmohat Bro Nkifrar nhai mong trohrmorr. Tamoh tamohm Bro Nkifrarhu tirmn rhumor. ");
INSERT INTO amp_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Bro Nkifrarhu tirmn ruhetrn ror yakmoa krhopam Bro Nkifrarn fak marnya hnamourr. Ror yihato Ijifthu kingrpno yi mtohhato pthamohat Bro Nkifrar tu dborioh dukefm hemotrr mrokfom hifa ptha marnyamorm. Ijifthu kingr wany yindhorhato be tfit rorn Ijifthu praiministar htamor. Kingrhu kuny kmifar rorpar tohukatohmour. ");
INSERT INTO amp_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Josefr bi nd nd hingrnefm yakhato tohetrn bro yatinoh wormr Ijifti Kenant tohmor. Nd hus kantrif tohyuk yimam rim ta ttiyak mta ttiyakmoum yeshri yakneft. Nmoh nkifram rom inji buga. Bi yeshrimn foh tebehmom. ");
INSERT INTO amp_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Kto wanyakmom memom Ijifko harhuwom wit. Jekofr wanyhato nmoh nkifram barkof yiha kfo tkrurafmotrm yimom wit wiknat. ");
INSERT INTO amp_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Barkof yiha miyakyukm mye buga tanymomm, yo tfit yimom. Nd yispno Josefr kfo nuhas memorm, ‘Na hti mmorahkma. Na nikmoh wuroh nmemen Josefa.’ Bi inji kfo nuhas-worme, kingr ndnatn hti duka tungunamorm, ‘E na kanga ka wom yima furayem. Arm Josefrhu najom-royem.’ ");
INSERT INTO amp_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Josefr sinyahato ttiwon-morm, ‘Nmoh yifem Jekofre tor yuhre?’ Memomr, ‘Tor.’ ‘O wamhtiyakkomr.’ Be wom najomrom inji wanyhato yimom yifemrhu yakt. Rorhu mhtiyak-neftpno rorhu yorgtohthu rhu hasoyuk wuroh 75 yimam mhtiyakhato rpat yimom Ijifko. ");
INSERT INTO amp_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Be Jekofr Ijiftn yi tohhato ndharn nohmor. Nmoh nkifram nhaf ndharparn noh wita bugamom. ");
INSERT INTO amp_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Be noh bugamotm tpi tikrpam yaknimommn hanymom Sekemko. Ndko hanyhato Abrahamr Hamorhu yonmpno wiknamo bbinysofthu tahi muhmn hany htamomm. ");
INSERT INTO amp_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Nd rom noh htaniyuk yon rifhur nhai kuken rifhur sinyarmor. Bi Bro Nkifrar Abrahamrpno kfomorr Isrerm Ijift yi tohyuk yiham. Bi yonmari rifuhetrn to be Ijift htanyuk yiham bi brbohmom. ");
INSERT INTO amp_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nd yiharn nd nfri kingr nhai tawisafrmor Josefr Ijift yima nfrir tohhato namoa dborioh dborioh nefm. ");
INSERT INTO amp_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Be nd Josefrhu kmi thofm Ijift noh htanimom nhai yak marnyar-moarm. Isrerm gumuha muht muh thunimoum. Kingr htimorm Isrerm nhai sinya ffhirmrmom. Ndnatn kfo memor, ‘Arihat Isrerroh yon yindarim akisupaf hanyswamm.’ Be Isrerm nasak hanymoa yon yindarim yihom kisupaf hanymoumm. ");
INSERT INTO amp_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Wom yiha wom mett wom yonr hiyaumot. Nd yonrhu yufat futamotr Mosesr. Bro Nkifrar nd yonr hifa hti yindhormorr. Nd yonr tu dborioh yonrn nhai kisupafrmotr. Ndnatpno fak hamong-motr husfirpa yamt. ");
INSERT INTO amp_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Kto tfit yak-nimotr briahako htamotr. Briyahako htamottr kingrhu yont htihato fakmotr. Yakhato be rotn duge warhomotr. ");
INSERT INTO amp_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Be toh warhonimorn Ijifroh hingr-nefm, hingrna dukefm, tamoh tamoh nefm fak buga bugamorm. Yak bugamormn rorn tohmor tu bro ptha nanyjaret yimar. ");
INSERT INTO amp_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Tohhany toh hanymorn bi 40 gunyjimetrn yima yuhur sinyamorr turhu kmi Isrer thofroh yau hafott yinyeft. ");
INSERT INTO amp_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","To be yimorn turhu nyingaye htimor wom Ijifr sinyahato wom Isrerr tmbho botmbhafmotrr wasuh bebmor. Mosesr ndt mhti namburnihato tawo wom Ijifr tmbho botmbhomotrr be tuha gur rhumor. ");
INSERT INTO amp_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mosesr memor, ‘Inji nakahta Isrerm hti dukarahma. Duka mirahm, “Ka nd yimarn yak hakrmenirahrnom.” ’ To rom nhai hti dukarmoumr. ");
INSERT INTO amp_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Tfit wom yiha nhaf tu Isrerf tuf tawo tawo nna hasetfn memor, ‘Kfo dbohfarhoyanfn afo htiruha hti nhtarahfan o nhai.’ Nna hanyetfn yak dbkafaknihato kfo memorf, ‘Barefn, tamohmpno tufn tfit tawo tawo nnewafn?’ ");
INSERT INTO amp_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Tu rinam-burakyukrn Mosesrhu tirm frtfafhato kfo memorr, ‘Nine frohm kfo memomn turoh nefmpno ni buha mitohhato wakfo dbohfatwanm? ");
INSERT INTO amp_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Bi nohok womr yewofnronn tfit kangn wompam?’ ");
INSERT INTO amp_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mosesr inji wanyhato fakrmenimor. Yakrmenihato yimor Midianko. Ndko yi tohhato mett yakhato hus yonf nasakmor. ");
INSERT INTO amp_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Be ndko bok gunyjimm tohmor. Tohhany 40-yukrpno Sainaitn yima toh duha nungu furatn toh hasetrn mounmotr yimorn mifnahmorr. To nd mounmotr kah funefm kanjo mi bufupamn funa nuhasmorr. ");
INSERT INTO amp_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mosesr nd kah funefm htihato memor, ‘Ka tu kah funef mifet.’ Memor, ‘Yauyaknihato brbo yi htiruhant.’ Yuhre fauyakni hanymor asha Brorhu tngt kfo memor, ");
INSERT INTO amp_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Na ninhu nkifra Abraham Aisak Jekofrom kfo bruttnamoa Bro Nkifraya.’ Be Mosesr Bro Nkifrarhu tngt wanyhato yimar wutthamohat memom nndo ginunes kekwotr. Kaht htihato nyingam mmrtamotmr nhai htirmort. ");
INSERT INTO amp_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Bror kfo memorr, ‘Nd ni hmbrita hona wuram wayak thunm. Nd tkitt na Broya wiyauyauwa tkitet. ");
INSERT INTO amp_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Nanhu yon kunys Ijift tohwom. Ijifm yak bebwatmm na yuwa naku nurwohat rom kangm ka nhai htihato wanykahrnom. Na wanyhato htitanm. Na nd nmbuham htihato ninpno nia ninhu kfotn. Ninn na be kfo tkrurwa Isrerroh mihtiyakneft.’ ");
INSERT INTO amp_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Isrerm sinyahato afo Mosesr kfo memomr, ‘Nine frohm kfo memomn turoh nefmpno ni buha mitohhato wakfo dbohfatwanm?’ Afo frtfafmomr kto nd rom frtfafmo yimarn Bro Nkifrar kfo tkrurafmotrr fak hakrminamorm. Tur kah funefm kanjo htimo moun-motrn bro bbuka nanyja rifhur hemotrr hakrminamorm. ");
INSERT INTO amp_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mosesr Ijift tohetrn wonk wonk mirakerkfot hingrna tanyhato fak hakrminamorm. Rom Retsit yo yima toh duha tkitt yau fnahmohat to be mirakerkfot kfomot 40 gunyjimm nd yonmari yihotar fau sufnahmomr. ");
INSERT INTO amp_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Nd yima Mosesrparn Isrerm kfo memorm, ‘Na hingrnewa hingrneft kanjohot yimar kto wom yiha tukmoh frikeft toh hamuhyuk yimarn Bro Nkifrar nd profet hingrneftn yak htarahrr.’ ");
INSERT INTO amp_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Nmoh nkifram yima toh duha tkitt yi tohmohat to nd yima Mosesrn tohnhomorm. Rorn Sainait muhhato rhu nkifraniyuk mrokfot mounmotr hemotrr hemornom. ");
INSERT INTO amp_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Mosesr nd mrokfot yaknihato Isrerm kfomourm nhai wany yakior-moamr. Ijifkorhof dukefr rhumoatrm ndnatn hanyjbornamoumm Mosesr kfoyuk mrokfom. ");
INSERT INTO amp_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Mosesr Sainait muhhato wutoh hatohmohat, Isrerm Aronrpno yihato kfo memomr, ‘Nmoh hatohakmoa yima Mosesr nhai ka tfit nieruhatr. Nom bi duka mumiwunom yiyuk yihotam. Nom kangnom wom yifonm wahingrnakahtn nd yifonmn yihotat toh tamnou hanyrahmnom.’ ");
INSERT INTO amp_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Be nd dukeftpno bulmakaur hingrna nhombramomr. Hingrna nhombranihato bulmakaur washato tarioh skurn mthanihato nd yemrot yehato grha yindhormomr nd nfri bulmakau yifonr tum hingrnayukr. ");
INSERT INTO amp_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Be inji rinakmotm to be Bro Nkifrar mong trohmorm. Mong trohmotrm tfit mount rhuyuk mar yam guny ndmn kfo tatomoum tamoh tamoh nefm. Profetm kfomo mrokfot to be kfo twanhomom. Kfo memom, ‘Niko Isrerko, niko yima toh duha wesan furat 40 gunyjimm hwe toh fnahmo yiha bulmakaum washato tarioh mthamoahat nhai nann tarioh mtharmoako. ");
INSERT INTO amp_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Nd niko hiyau habrimo ser tha rmont ndt nndo tahi Molekr tohyuk ser tha rmonti yo gunyr kanjo hingrna nhombret tahi Refanr hatoh habrimouko. Ndm nndo tukmoh kfo tatoyuk tahi yifonm hingrnamoko. Tuko inji newatko nhai asha tohruhatko wuri Babilonko htaruhanko.’ ");
INSERT INTO amp_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Nmoh nkifram yima toh duha tkitt toh fnahmohat Bro Nkifrar mithu nawohyuk ser kuny rmont kakitoh-moum. Nd ser kuny rmont hingrna-mohat tu Bro Nkifrar Mosesrpno kfo nuhasmo yuhatn hingrna nhombra-momt. ");
INSERT INTO amp_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Kto nd nmoh nkifraroh yon frikeftn nd ser kuny rmont Josuarpno yaknimomtn hanymomt wom kantriroh bbinysoftn. Nd kantrikfothu yimam Bro Nkifrar yak tuhafmormn nd ser kuny rmont tfit ndha mkasinyamomt. Be nd rmont tohettn ee Defitr king tohmor. ");
INSERT INTO amp_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Defitrn Bro Nkifrar hifa kak marnyamour. Jekof frikefthu Bro Nkifrarhu nfri rmonthu kasinya nmbuhat Defitrn Bro Nkifrar kfo naku ttiwonmorr. ");
INSERT INTO amp_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Kto Solomonrn nd nfri rmont kasinyamort. ");
INSERT INTO amp_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Nd nfri rmont to be hingrna furamomt. Nd yurak myorhekwa Bro Nkifrar yimamif hingrnayet rmonm tohetrn to btne tohrmort? Nhai. Profetm to kfomomt mrokfot, ");
INSERT INTO amp_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Brorhu mrokfot kfo kangr, ‘Hefenr nanhu sia kinger. Bbinysoft nanhu wuraf wayahotwa tkitet. Ndnettn to tfit fitoh tkittn yamukako nanhu rhu witayuk tkitt ahingrna hanyomr tfit? To fitoh tkittn nanhu rhu witayuk tkitt rhuruhat? ");
INSERT INTO amp_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Nd nd shrm nann hingrna hta bohtamo shrkayem.’” ");
INSERT INTO amp_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stifenr nd kaunserm kfo memorm, “Niko ndar Judaroh kaunserko niko be tu mfro tahisamomko nikmoh yima yuhum. Yimbhindangm kihmnimom. Nhai Bro Nkifrarhu mrokforoh wany-kfot. Bro Nkifrarhu Yafothat kfoyuk mrokfom be tu frtfa thuwokomm tukmoh nkifram nahnamo kanjo. ");
INSERT INTO amp_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Nhai wom profetr nikmoh nkifram hifa yak marnyarmomr. Bro Nkifrarhu hifa yufayet yimarhu mrokfot me-moum akfo nuhasnomko rom riyak-moamm was beb bobeb thumoumm. Nd hifa yufayet yimar to bi niamotr nikomn hndhnamotkomr wasmomr. ");
INSERT INTO amp_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ar mounmotmpno boririfhut yakyuk kmiko to nhai nd boririfhut hikrmokomt.” ");
INSERT INTO amp_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Stifenr pthamo mrokfom kaun-serm wanyhato nhai yindhorrmom. Nyingatikm memom nndo krpaye srfemm. ");
INSERT INTO amp_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Stifenr Bro Nkifrarhu Yafothat tohmoutr. Memor, yura auhtiya, htimorr Bro Nkifrarhu wondht hatohmohat memom nndo marrn yifa tohwor. Bro Nkifrarhu tirmifkorn htimorr Jisasr. ");
INSERT INTO amp_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Stifenr inji htihato kfo memorm, “Wawanyko, na bi htitwant hefenrhu rim fnahni yuhat. Tu rim fnahni yuhatn htitawanr Bro Najomr tohwor Bro Nkifrarhu tirmifkorn.” ");
INSERT INTO amp_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Stifenr inji ptha hanymor kimr wunahato yimbhindangm takihmomm. Nhai wofnrmom ror pthayuk mrokforoh wanykfot. Be yudbat rpat wayur sinyamomm toneyaknihato tir tir fakmomr. ");
INSERT INTO amp_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Yakhato fakni hanymomr. Taunt yau troh tanyhato wuri nndo rim htahato tahim yakhato tahiye tahiye febhohmomr. Nd mrokfot wakfo wokakyuk yimaroh yuke hmbresham yakhato wom yima damiagr, rorhu yufat Sorr, rorhu wurampno wahtamomm. ");
INSERT INTO amp_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Tahiye yenyohafmotmr Jisasr nakumorr, “Nungothet Jisase, nanhu yafothar wayaknr.” ");
INSERT INTO amp_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Wura yihom tabokme-hato kfo memor, “Broye, rom na ndar tat bebwohat mirahn finji anayanm.” Be inji kfonihato mfaknimor. Sorrn kfo yakio mrokfot hemorm Stifenrhu tat nohneft. ");
INSERT INTO amp_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Nd yima Stifenr tat nohmo yiharn Jerusalemthu Kristenm yak beb bobebafmotmm fakrme tubatumom. Womm tuha Judiakorhof kmimn fakrmenimom womm Sameria-korhof kmimn. Aposerrpamn tuha Jerusalemt toh hasomom. ");
INSERT INTO amp_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Bro Nkifrarhu mrokfot hiket yimam Stifen-rhu thatipt hanurmomtn fop hmbre-momt. ");
INSERT INTO amp_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Jisasr hiket yimam turoh kunym ruhetmn Sorr hik hawitahato myakmoarm kalabus htamourm. Memour, “Inji anakahann yak bati bugayanm Jisasr hiket yimam.” ");
INSERT INTO amp_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Nd yakrmenimo met yindarimn gutniuskfot romn kmi kmim hanymomt. ");
INSERT INTO amp_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filifr yakrmenimohat Samariako yorhwa taunt yimor. Rorn Kraisrhu kfo nuhas mrokfom kfo nuhasmorm. ");
INSERT INTO amp_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Filifr mrokfom pthamoahat kmi thofm rom rhu marnyahato wany yakitohmoum ror pthayuk mrokfom. Wonk wonk mirakerm namoatr rom rhu marnyahato htimoumr. ");
INSERT INTO amp_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Tek yarh fknayetm rom yarhm yak thumoatrm tau tanyhato fnahnimoum. Wura bebetm, rikiyem ror kfo bruttnamour marnyanimoum. ");
INSERT INTO amp_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kmi thofm Filifr namo nefm htihato bro yindhoreft fakmotm. ");
INSERT INTO amp_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Nd kmitn wom yimar tohmour rorhu yufat Saimonr. Nd yimar duka memor, “Na bro yufayet yimaya.” Nd yimar metroh thu bbrakyuk hingrnefm yo kiret nyinga hingrnefm yakitohhato wonk wonk nefm namoatrm Sameria thofm htihato duka memoum, “Barenko, nd yimare finji hingrniwar?” ");
INSERT INTO amp_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Sameriat tohyuk yima fura bofurat, kukent, burent, fitoh fitoh yimat, be rorrparn bro dukeft htamoum. Rroh dukeft duka memom, “Nd nmoh nkifraroh bro bbukeft, tot nd yima Saimonrn.” ");
INSERT INTO amp_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Wonk wonk nefm nahatohmotr Sameria thofroh dukefm rorrpar htamoumm. ");
INSERT INTO amp_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","To tfit Filifr yihato yimam Bro Nkifrarhu kingdomkfoti Jisas Kraisrhu yufat kfo pthamor Sameria thofm wany yakiomomt. Filifr nd ror pthayuk mrokfom wany yakiomo met yindarim baftaisimmorm. ");
INSERT INTO amp_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Nd yima Saimonr, ror Filifr pthayuk mrokfom wany yakiomotr Filifr baftaisimmorr. Saimonr baftais yakni-hato Filifrpno rpat tohhato Filifr wonk wonk nefm namotr Saimonr htihato tfit mifoh rihamor. ");
INSERT INTO amp_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Jerusalemt toh hasomo aposerm wanyak memom, “O, Sameria thofm Bro Nkifrarhu mrokfot wanyhato kak hikwomt.” Be inji wanyakhato Pita Jonrof kfo tkrur memomf, “Wamhti marnya tanyfnm.” ");
INSERT INTO amp_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","16","Be rof tufn mhti tungunahato htimofm Bro Jisasrhu yufarpatpno baftaiskfot yakmomn nhai Bro Nkifrarhu Yafothat yakrmom. Inji mhtitihato yo rofn Bro Nkifrarpno kfo tatomofm Bro Nkifrarhu Yafothathu yakneft. ");
INSERT INTO amp_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Kfo tatonihato tir htamotfm Yafotha fakmom. ");
INSERT INTO amp_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Saimonr inji htihato maruham yaknihato mkfo memorf, ");
INSERT INTO amp_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Nd nifn yakitohwa bbukeft kanga awiknayanfn. Na nd bbukeft yakitohhato na fitoh yimam tir htahato kfo tatoruha Yafothathu yakneft yudbat yakrahm.” ");
INSERT INTO amp_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Inji mkfomotr Pitar kfo memorr, “Bro Nkifrar he furiwa nefm wiknakfot kfiwatn, tunhu maruhampno hel yirahn. ");
INSERT INTO amp_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ninhu dukefr nndo korhr, nhai Bro Nkifrarhu dukefr hikkahr. Ndnatn nhai nom hingrnewa hingrneft tohnhoruhatnnom. ");
INSERT INTO amp_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ninhu ndhtet fasoh dukefr wayafho thunr. Wayafho thukahtnr Bror kfo bruttnahato nd ni yakitohwa dukefr ror nhai wom dukaruhatrr. ");
INSERT INTO amp_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Htitann ninhu dukefr Bro Nkifrar he furiwa nefm htihato be mfro mfrhutewur. Nd dukefr yorhwatrn be tu fasoh neft newun.” ");
INSERT INTO amp_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Inji kfomotfr Saimonr kfo memorf, “Bro Nkifrarpno wakfo bruttnakahtfna yuhuwafrhora nd nifn kfi nefm nhai yakrhotma.” ");
INSERT INTO amp_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Be Pita Jonrof Bro Nkifrar yak nuhashato kfohemoa mrokfom kfo nuhas tanymofm be rof tfit Jerusalemko yimof. Yinyeftpno yihotathu kmim Sameriathum Bro Nkifrarhu mrokfom kfo nuhas hanymofm. ");
INSERT INTO amp_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Filifr wom mounmotr yihato kfo memorr, “Wasinyakahnn sautko yorhwa yihotat waiswa. Nd yihotat Jerusalemt mkiomotn yimot Gasako, yima toh duha tkitko nd yihotat korhwot.” ");
INSERT INTO amp_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Be Filifr sinyahato nd mounmotr kfoyuk yihotarn yimor. Yau hanyhato wom Itiopiathu yimar-pno yihom nafurmof. Nd yimar frfuha duhatr. Frfuhaf faktamomr. Itiopiathu kwin met Kandasithu maruham rorn kakitohmourm. Jerusalemko Bro Nkifrarpno kfo tato tanyhato ");
INSERT INTO amp_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","memor, “Tfit kmiko aiya.” Turhu karis toni hanyhato profet Aisaiarhu mrokfot htihato ptha hanymour. ");
INSERT INTO amp_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Bro Nkifrarhu Yafothat yihato Filifr kfo memotr, “Nd yimarhu karispno brbo waikahnn ror ptha hanyuk mrokfom wawany yakitoh hanyswanr.” ");
INSERT INTO amp_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filifr tonenihato karispno brbo yau hanyhato wanymorr nd yimar profet Aisaiarhu mrokfot htihato ptha hanymour. Filifr sinyahato kfo ttiwonmorr, “Nd ni htihato kfo pthiwa mrokforoh yimbu yuhame ka kekwonm o ka nhai?” ");
INSERT INTO amp_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Nd yimar sinyahato kfo memor, “Nanrpaya htineft to finji mrokfo mnam yakkfot. Wom yimam akfo nuhasma, awi yakrfoyanm.” Inji kfonihato kfo memorr, “Yuwa muhn karisn.” Be Filifr muhmor karisn. ");
INSERT INTO amp_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Nd yimar karis rhuhnehato htihnamo mrokfom kfo memom, “Sifsifr nhombrarahr. Yimam was thombat nhai tauruhatr. Yimam yakhato tmbm yoh thombat nhai yififaruhatr. To inji na nhombrarahr. ");
INSERT INTO amp_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Womrparoh tng rihar grmim kanjo tayifuhafrahmr. Nhai be ptha hik marnyahato nohyuk tkitt htaruhatmr. Ror bi nohruhatr to frohmn rorhu yimatm arihat tohruhamn kfo nuhasruhamm ror yak bebmo nmbuhat?” ");
INSERT INTO amp_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Nd yimar nd mrokfo nmbuhat hti buganihato kfo ttiwonmorr Filifr, “Filif, ttiwonwann, profet Aisaiare frohm dukahato nd mrokfot inji kfomort, turn o wommn?” ");
INSERT INTO amp_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filifr sinyahato kfo nuhas bugamorr ror hti hnamo mrokforoh mna yuhat. Kfo nuhasnihato ee Jisasrhu mrokfom kfo ptha nuhasmorr. ");
INSERT INTO amp_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Yi yimofn wom tekt htihato nd Itiopia thofr kfo memor, “Asot tekt. Na ndar tektn baftaisnirfoya? Ka wom fasoh nefm yorhwatma nhai baftaiskfot?” Filifr inji wanyhato kangrr, “Yinowa, na nhai mrokfom ninhu baftaisimneft. Tunhu yima yuhur wayibon sinyewur Jisasr hikneft, to na nhai tfit kfo rafokfot.” Itiopia thofr wanyhato memor, “Jisas Kraisr Bro Nkifrarhu Yon mifer.” ");
INSERT INTO amp_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Inji kfomotr karis mtohmot. Be Filifr mitohnihato nd Itiopia thofr tekt hanyhato baftaisimmorr. ");
INSERT INTO amp_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Baftaisimnimorrn yuhre mtohna hnamof, be yudbat Bro Nkifrarhu Yafothatn Filifr thu hafunanimotr. Be wom Itiopia thofr brioh tkitt hti hambro hasohato be yindhorefrparpno yimor yihotar. ");
INSERT INTO amp_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filifr Bro Nkifrarhu Yafothat thu hafunanimottr Asdot mifnahmor. Be ndharhof kmim Jisasrhu mrokfom kfo ptha nuhas habrimorm. Inji yi hanyhato Sisariat mifnahmor. ");
INSERT INTO amp_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Sorr nhai ttifarmor Jisasrhu disaiperroh yak bebneft. Ror hatoh hnamo neft to be fakitoh hany swanhomort. ");
INSERT INTO amp_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Wom yiha prisroh bro tohak yimarpno yimorn mkfo memorr, “Nanhu bro kfo nuhas mrokfot wawandfakkahnt Damaskus yorhwa Judaroh bro rifiny rmonm bi wahe nhombratwanm. Gontwaroh mrokfom wakfo wamitwa, ‘Fitoh yimar o mett, Jisasr hikwam, nd yimam, Sorr yak-ruharm Jerusalemt kalabus hany htarahrm.’ Nd mrokfot wakfotwanm.” ");
INSERT INTO amp_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Nd mrokfot bi ruhettn wom yiha Sorr Jerusalemt toh tanyhato Damaskusko yimor. Yimorn brbo Damaskuspno toh hanymor asha nukeft wuhtiyakmort. Memom ka nndo bro ksh nmbuhatn yura mountko wuhatohhato wayak nukewumt. ");
INSERT INTO amp_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Nd nukeft masat funa rramott yima Sorr yura hos ruhetrn memor auhtiya nyingam mmrifakhato bbinysoft misuhmor. Be tuha nyinga kunyjetr rhumor. Tfit yura hefenko wom tngt kfo memot, “Sor, Sor, na tamoh dukeftpno yak bebwona?” ");
INSERT INTO amp_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sorr wanyaf hanyhato kfo memor, “Broye ni frohe?” Yura hefenko wukfomo yimar kfo memor, “Na Jisasa. Ni nd niwa nefm Kristenmpno nhai romn yak bebkahn. Nann kak bebwo. ");
INSERT INTO amp_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Asomif wasinyanikahnn Damaskusko wanju. Tor nd kmit korhr wom yimar. Rorn wom mrokfom kfohirahrn.” ");
INSERT INTO amp_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Nd Sorrpno yiyuk yimam nd neft htihato be tuha yafotha duhatm tohmom. Nd Sorrpno pthamo yimar nhai nyingatikm htirmomr. Be tngrpat wanymoum. ");
INSERT INTO amp_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Be Sorr wasinyahato memor ayukatoha fitohat yukatohrmor? Be yimamn tirtir yakitohaknihato Damaskusko yimom. ");
INSERT INTO amp_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Husfirpa marm nyingam nhai yukatohrmor yo nhai bupa nuwa yarmor. ");
INSERT INTO amp_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Nd kmi Damaskusn Jisasrhu disaiper tohmour. Rorhu yufat Ananaias. Ananaiasr Bror yimorn minakumorr. Yimam hwe tweh hanita kanjo inji minakumorr. Ananaiasr wanyaf hanyhato kfo kangr, “Broye na asoya.” ");
INSERT INTO amp_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Bror kfo memorr, “Judasrhu kunyko waiswa. Rorhu kunyko yita yihotarhur yufat ‘Dborioh Yihotar,’ nd yihotarpar waikahnn Judasrhu kuny shofm wattiwon wamitwanm, ‘Tasis thof Sorre tor?’ Ror tor nd kunysn kfo bruttna hasiwur. ");
INSERT INTO amp_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Yak nuhasruhatmn htirahnr nyinga kunyjeter. Nd yima Sorr ror nhaf hwe twehnano bi Ananaiasr htiyak hanymorr. Yi hanyhato tirm hta hanymotrr nyingam fukatoh hanymorm.” ");
INSERT INTO amp_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananaiasr wanyhato kfo memor, “Broye, Jerusalemt ni hikwa yimam yak bebhnewa yimar bok yimam nd yimarn kutewum. Kangm ror kak bebhnewurm. ");
INSERT INTO amp_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Bro prism kfo yakiomotmr Damaskushu yimaroh yakneft ndnetrn bi ako niewur.” ");
INSERT INTO amp_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ananaiasr inji kfomotr tfit Bror kfo memorr, “Wanju nd yima Sorrpno. Nanhu hingrneft rorn hingrnarahrt. Rorn yima tangim yo kingm yo tu Isrerm yihato kfo nuhas hirahrm. Kfo nuhasruhatrm na mhti dukakrahma. ");
INSERT INTO amp_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ror nd hingrneft tohhato yakruha krhopam na tukann kfo nuhasruhanr.” ");
INSERT INTO amp_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananaiasr inji wanyhato yimor nd Sorr rhumo kunys. Yihato tir rim htamorrn kfo memorr, “Yinowe, Jisasr kfo tkrurefitra niya ninpno. Ni ako Damaskusko niahato yihotat htimo yimar, to nd Jisasr htimo. Ninhu nyingaroh yak marnyaneftn kfo tkrurefira yo womt duka kangr Bro Nkifrarhu Yafothat nd yimar amthu nawohtwatr. Ndnetrn kfo tkrurefitra niya.” ");
INSERT INTO amp_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ananaiasr inji kfonimotr be nd Sorrhu nyingam hta tasifmo shrm yira nfm kanjo yohrofnihato misuhmom. Be nyingam tfit fukatoh wuthamorm. Yukatoh wuthahato baftais fakmor. ");
INSERT INTO amp_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Kto Sorr nuwa ye bmta marnya-hato tu yima rifhur tfit niamorr. Nd kmit afo dfik yiham Jisasrhu disai-permpno tohmor. ");
INSERT INTO amp_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Nd ror tohmo yihamn Judam rifinymoa rmonm yihato Jisasrhu yufat rikfo nuhasak memourm, “Jisasr tu Bro Nkifrarhu yon mifer.” ");
INSERT INTO amp_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Sorr pthayuk mrokfom yimam wanyhato kfo memom, “Barenko, nd yimar tamoh yakt asha niaror? Jerusalem tohyuk Jisasr hikwa yimam to nd yimarn kak bebhnewurm. Tfit bi asha niahato asha tohyukm kangr ayakni hanyanm kalabus.” ");
INSERT INTO amp_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Damaskus tohyuk Judam inji kfo hanymoumr ror nhai wanyhato kfo marimor, “Dajohmn, bi inji kfiwuma, be tmifa pthaneft.” Nhai. Bro Nkifrar bro nanyjar rifhur hemotrr kfo nuhas bonuhas memorm, “Jisasr tor tu yimar Bro Nkifrar kfo tkrurmor bbinysof thofroh minrfa htiyakyuk yimar.” Judam inji kfo nuhasmotrm be nhai wom ptharmom. ");
INSERT INTO amp_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Tohhany toh hanyhato wom yiha tu Judam rhu rifinyhato Sorrhu was mrokfot nafak dbkafmomt. ");
INSERT INTO amp_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Sorr ror bi wanymor rorhu was mrokfot. Judam yifung marm taun yifhatiktn toh hajoh haso memoum, “Kmi yifhatiktn toh tatakhato wasrah-nomr.” ");
INSERT INTO amp_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","To nhai, Jisasr hikwa yimamn yaknimomr yura kmi gnat mhatohhato kpetr yafho tuhafmotmr misuhnihato fakrmenimor. ");
INSERT INTO amp_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sorr yakrmenimohat Jerusalemko yimor. Yihato memor, “Jisasrhu disaipermpno atohaka,” to nhai, rom hti fakrmemomr. Sorr Jisasr rihikakmohat wanyhato memom, “Ka kfo nhehwornom.” Ndnetmn afo fakrmemomr. ");
INSERT INTO amp_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Barnabasrn yihato Sorr yaknihato aposermpno hanymorr. Hanyhato aposerm kfo nuhas memorm, “Sorr Damaskus yihotoha yuhatn bi Bror htihato mrokfom hemotrr ror asha Jerusalemt namoa nefm bi fafho thumorm. Ror nd fasoh nefm yafho thunihato Damaskus tohmohat nhai yakrmermor pthaneft. Jisasrhu mrokfot kfo nuhas tanymorm.” ");
INSERT INTO amp_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Kfo nuhasmotrm be rpat Jerusalemt tohhato rpat ufaufaumoum Jisasrhu mrokfom ptha htfasmoahat. Ror nhai yakrmermor mrokfo pthaneft. ");
INSERT INTO amp_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Grik yarmumat pthet Judampno nakfo hamuh nakfo hamuhmotm memoum, “Awasnomr.” ");
INSERT INTO amp_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Rorpno wiyauyau htfasmoa yimam wanyhato Sisariat mihtafmotmr Tarsusko yimor. ");
INSERT INTO amp_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Be nd yiharn Judia, Galili, Samariaroh siosm rhu marnymom. Turoh tamoh tamoh dukefm minoh hmbre buga-moatmm Brorhu Yafothat tfit fak hta bohtamoutm rroh toh nmbuham. Yak hta bohtamoatrm bok yimam Jisasrhu mrokfot hikaknimomt. ");
INSERT INTO amp_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pitar Samariat tohmohat kmi kmim nhombra bugamorm. Wom yiha Lidat yimorn ndha tohyuk Jisasr hikwa yimampno memor, “Ai atoha.” ");
INSERT INTO amp_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Nd kmit yihato wom noh minysafet yimar mihtimorr. Rorhu yufat Ainiasr. Nd yimar bingot noh minysafeft yakmottr 8-pela gunyjimm be inji kunyrpat rhumour. ");
INSERT INTO amp_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pitar mtohni-hato yufat nakumorr, “Ainias wasinya. Jisas Kraisr hrek kak kasinyewurn. Wasinyakahnn hwe wuskam wayaknm.” Inji mkfomotrr to be yudbat wayur sinya twanhomor. ");
INSERT INTO amp_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Taun Lidati Saronfhu tuhan yindars inji htihato rom hatohmo fasoh fasoh nefm kfo dbruf bugahato Brorhu mrokfom hikmom. ");
INSERT INTO amp_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Taun Jopatn wom mett tohmout. Jisasrhu mrokfom hikhato dborioh nefm namout. Yimam tamoh tamohm kaknafmoum rothumn yakhato hemoutm. Nd metthu yufat Tabitat. Grik mrokfotn futamoumt Dorkas. ");
INSERT INTO amp_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Wom yihar bro dbohneft yakmott nohmot. Nohmott yak marnyamomtn wondht wondhakhato wom yura rhuyuk buha tikrn mhtamomt. ");
INSERT INTO amp_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jopati Lidat nhai wuri wuri rhurmoaf, be brbo. Jisasr hiket yimam Pitarhu Lidathu yi nmbuhat wanyhato wom hus yimaf kfo tkrurafmomf. Memomf, “Waikahfnn Pitar wamihtiyakfnr. Mirahr tfit wom awi kanga hatoha. Bmbri anietwar.” ");
INSERT INTO amp_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Nd hus yimaf yi mkfomofr nhai wom kuknarmor. Rpat mnahtiyakhato yimom. Pitar Lidat mfnahmotr nd yima gus rhumo kunyshu wom buha tikr hamuhmomr. Rom nd met dhir bodhirm rpat Pitarpno mtohhato nd nohmo mett yima nfrit tohhato nahumo wuskam nur hanyhato kak nuhasmoumr. ");
INSERT INTO amp_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Nd rifinymo met yindars Pitar yak tuhaf bugamormn turpar nd mettpno rim bangu yuknahato Bro Nkifrar wunakuhato nd yima gushu yufat nakumor, “Tabita wasinya.” Tabitathu nyingam mfrdborhahato mfukatoh fnahmotm. Pitar rihtihato wasinyamot. Wasinyahato rhumot. ");
INSERT INTO amp_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pitar yauyaknihato tirt fakmort. Yakhato teh kasinyamort. Tohmott Pitar rim tohnihato Bro Nkifrar yakitohet met yindarmi tuhan dhirm nakuyakmorm. Nakuyakhato mtoh-motm kfo memorm, “Tabitat asot bi tfit mfanyjwit.” ");
INSERT INTO amp_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Nhaf Pitar nd mett kasinyamo yuhat nhai brbo tohrmot mrokfot. Jopa thofm bokm inji wany-hato Bro Jisasr rifak hikakmom. ");
INSERT INTO amp_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pitar Jopat bok yiham Saimonrpno tohmor. Nd yima Saimonr bulmakau tha hingrneft tohmour. ");
INSERT INTO amp_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Wom yimar taun Sisariat tohmor, rorhu yufat Korniliusr. Italit tohyuk 600 soldiam rorn Rom-korhof 100 soldiam tohukatohmorm. ");
INSERT INTO amp_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Rori rorhu kunys rpat tohmoa yimam Bro Nkifrar yakrmehato rorhu tamoh tamoh mrokfom o tamoh tamoh nefm fak hik marnyamoumm. Kfo bruttnaneft nhai yafho thurmort. Yima bebpa met bebpam tamoh tamoh kak nafthumoum, rorhum yakhato hemourm. ");
INSERT INTO amp_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Wom yiha 3 kilok krif marrn Korniliusr be rhu hasohato mounmotr be tafontn twe kanjo htiyak hanymorr. Nd mounmotr niaknehato yufat nakumorr, “Korniliuse.” ");
INSERT INTO amp_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Korniliusr be yakrmehato be yeny-jworfnano kfo fakio memor, “Broye, tamohet?” Tfit mounmotr kfo memorr, “Ninhu kfo bruttnanefti dborioh nefm Bro Nkifrarn htihato dukewurm. ");
INSERT INTO amp_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Href-nano wakfokahtnm wom yimam Jopako anjukahmn amkfaktwamr wom yimar, rorhu yufat Saimon Pitar. ");
INSERT INTO amp_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Nd yimar tohwor nd foh bulmakau thaye wonk wonk wuskam hingrniwa yimarhu kunysn, rorhu yufat Saimonr, bro maromb thmbko watohwor.” Be nd mounmotr inji kfo tanyhato yimor. ");
INSERT INTO amp_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Korniliusr mounmotr htiyafhato nakuyakmorf turhu hingrna yimafi wom soldiar. Nd soldiar tu Korniliusrhu brbo tohyuk hingrna yimar. Rorn Bro Nkifrarhu mrokfeft kakitohmour. ");
INSERT INTO amp_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Nd yimam niamotm ror htiyuk nefm kfo nuhas buganihato ee kfo tkrurafmotrm Jopako yimom. ");
INSERT INTO amp_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Nd Saimon Pitar miyakmo yimam buha mihwemom. Tfit nd wom yiha tfit sinyani yimom. Rom brbo Jopatpno bi toh hanyetmn Pitar ror sinyanimor turhu kunyshu wom ken tikr muhhato memor, “Kfo bruttnaruha.” Marr bi dany yuhat toh hanyetrn. ");
INSERT INTO amp_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Pitar yatinohhato memor, “Nuwa yeruha.” Yuhre yeshrim hta mska hanyetmn ka Pitar hwe tweh hanita kanjo rmonthar htiyak hanymorr fawihna hanymor. ");
INSERT INTO amp_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Yura mountko rim hir mhirhato nd rmontharhu manoh manoh psifm memom, “Nndo yimamn ka psifm mano mano yakitohhato yafuhaf hanitatmr kawihnewur.” ");
INSERT INTO amp_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Nd rmonthar wonk wonk yeshrim hawihnamor. Rhumom bukorm, nungam, yo nd wonk wonk yemrom. ");
INSERT INTO amp_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Pitar nd rmonthar hawihnamo yeshrim hti hanyetrn naku tngt niamot, “Pita, wasinyakahnn nda yemrom wawasak waya.” ");
INSERT INTO amp_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Tfit Pitar kfo wok memorr, “Broye, ka nhai mif inji narhota! Bingot nom tohhnamohat nhai ye hnarmoyanm. Mur yemroyem.” ");
INSERT INTO amp_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Tfit kfo memorr, “Tamohtet yemrom arihat Bro Nkifrar kangrn wayanm mirahn akfo kuranm.” ");
INSERT INTO amp_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Tfit wompam be nd rpahtet tngt kfomorr. Wurohpam kfonihato tfit nd rmonthat mount rim fnahnimot. ");
INSERT INTO amp_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Be Pitar nd neft htiyafhato duka nhta bonhtamour, “Tamoh neft na htitawoya?” Inji duka hasetrn nd Korniliusr kfo tkrurafmo yimam Pitar tohmoa kunys kfo ttiwonhnamoum. Kfo ttiwonhna be nd tu Pitar tohyuk kuny yifhatikt mtohmom. ");
INSERT INTO amp_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Mtohhato naku ttiwon memom, “Barenko, Saimon Pitar tor? Asha tohwor?” ");
INSERT INTO amp_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pitar turhu tweht duka hasetrn Bro Nkifrarhu Yafothar kfo memorr, “Saimon, husfirpa yimam naku hambrohnewumn. ");
INSERT INTO amp_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Wasinya wahiknm. Nanhu tngtpno nd yimam hambrahnewumn. Mirahn aduka kinyaki bokinyaki hanya. Be wai furatwa.” ");
INSERT INTO amp_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Be Pitar mibrnyimorn memorm, “Barenko, na asoya. Tamoh yakt nieko?” ");
INSERT INTO amp_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Tfit kfo memomr, “Nom 100 amiroh tohak yima Korniliusr kfo tkrurafmotrnom niamonom. Nd yima Korniliusr Bro Nkifrar yakrmihato ror nhai wom fasoh nefm nakahr. Judam hifa hti yindhorwomt rorhu toh nmbuhat. Bro Nkifrarhu mounmotr rorpno yimorn kfo memorr, ‘Pitar mrokfeter. Afo nd mrokfom ninpno nia rhuhato ptharfotrm wanyherfonr.’ Mounmotr inji kfomotrr to be tfit nomn kfo tkrur memor, ‘Pitar wamhtiyakkomr.’ Ndnatn nom niamonom ninhu htiyaktn.” ");
INSERT INTO amp_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Pitar nd rorhu htiyakyuk yimam kunyko hafknihato nd yifungr rorpno hwe nfhamomn dbha tfit tum toh tanymoko yimom. Pitar rpatn yimom. Jopat tohyuk Jisasr hiket yimam Pitar hik tamnou hanymomr. ");
INSERT INTO amp_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Be nd yimam yau hanymomn buha mihwemom. Nd wom marrn taun Sisariat mfnahmom. Ror Korniliusr bi turhu yimatm yo turhu froh frohm bi yak nhafohmormn be rhu gari hasomom. ");
INSERT INTO amp_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Pitar kmit mfnahhato memor, yau fkneni hanyruha, ka Korniliusr rorhu wurampno mtabokmehato mfhat wasifamort. ");
INSERT INTO amp_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pitar inji htihato wateh kasinyakmorrn kfo memorr, “Wasinya. Na yima furapaya.” ");
INSERT INTO amp_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pitar Korniliusrpno ptha hanymorn kuny yuhat yau fknenimorn rim htimorm boknambok met yindars rhu rifiny hasomom. ");
INSERT INTO amp_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Inji rim htihato kfo memorm, “Niko tuko tawisafwoko, nom Juda-nomi niko yima tangiko nhai rpat tohhato tamoh tamoh nefm nakfot o rhu nafif inji nakfot, tu be nhai mif. Nd bro mrokfot inji rhuhnamotn tfit ar yuwonano Bro Nkifrar kfo nuhas memora, ‘Mirahn wom yimar akfo beb amiyanr, “Tamohmpno yima tangimpno rhu duha yitako?” ’ ");
INSERT INTO amp_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Tfit niko kfafmohat nanhu nianeft nhai tfi wom kfo kurrmoya, be nia twanhomoya. Ndtn kanga attiwonanko, ‘Tamohmn kfafmokma?’” ");
INSERT INTO amp_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Pitar inji ttiwonmotrm Korniliusr kfo nuhas memorr, “Bi husfirpa marm rhuronomm, husfihusyuk marrpno johrafont 3 kilok marr toh hanyetrn na Bro Nkifrarpno kfo ptha bruttna hasetann nanhu nyingatikko wom mounmotr mtohmor. Rorhu nukeft memom nndo marrn tewur. ");
INSERT INTO amp_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Mtoh-hato kfo ptha hany memor, ‘Korniliuse, ni nd kfo bruttnewohat Bro Nkifrar bi wany hasiwurn yo met bebpa yindari bebpam wuska yahukwohat ndm Bro Nkifrar htitworm. ");
INSERT INTO amp_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ndnettn wom yimam wakfo tkrurafkahtn Jopako aikahmn Saimon Pitar amyakm. Nd yimar wom yufa wasariyem Saimonrhu kunys tohwor. Nd yufa wasariyem Saimonr bulmakau tha hingrneft tohwarn bro maromb thmbko tohwor.’ ");
INSERT INTO amp_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Bro Nkifrar inji kfomotra to be yimam kfo tkrurafmota mikfakmomn. To be hifa ni bi aso nie. To be nom bi aso buganom nia rifiny bugenom. Hrek Bro Nkifrar kukatohwornom ni yakmo mrokfom kfo ptha nuhaswohat.” Korniliusr inji kfo pthamor. ");
INSERT INTO amp_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pitar inji wanyhato kfo memor, “Dajohmn! Na to bi hti yimbutwa Bro Nkifrar nhai yimam yakitohwa yufam o rom yakitohyuk tamoh tamohm htihato yakitohkahrm. Nhai. ");
INSERT INTO amp_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Fitoh fitoh kmim ror yakrmihato dborioh dborioh nefrpam niwam, tom nd yimamn Bro Nkifrar hti dukahato kak-miyekworm. ");
INSERT INTO amp_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Niko tawisafwokomt Bro Nkifrarhu gbhu yuhathu mrokfot nom Isrernompno niamot. Yima bugaroh Bro Nungothet Jisas Kraisr nd gbhu yuhathu mrokfotn mkfo nuhasmornom. ");
INSERT INTO amp_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","38","Niko tawisaf-woko Nasaret thof Jisasrhu wiyauyau nmbuhat. Jonr Jisasr baftaisim-nimotrr tfit Bro Nkifrarhu bbukayet Yafothar yaknihato fau habrimor distrik Galilit. Distrik Galilit yau habri bugamortn tfit kantri Judiathu kmi kmim inji buga. Yi htfasetrn Satanr yakitohmoa yima bugam fak marnya htfasmorm. ");
INSERT INTO amp_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ror kantri Isrerti Jerusalemt namo nefm yo ror yura bgre mis mnohmo yuhat hti hikhato mrokfot kfo pthayuk yimayenom. ");
INSERT INTO amp_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Tfit husfirpehyuk yiharn Bro Nkifrar kasinyamohat mfenyjwomotr htimonomr. ");
INSERT INTO amp_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ror sinyamohat nhai yuht Juda thof bugam htirmomr. Nom Bro Nkifrar kfo htayuk yimarpanom htimonomr. Nomrpanom ror sinyamohat nuwa fenyhomonomr. ");
INSERT INTO amp_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Rorn kfo htany memornom, ‘Bbinysof thofm wakfohi hany wamitwakomm, “Nd yimarpar Bro Nkifrar yak htamotrr noheh yimam yo ar yuhre tohwa yimaroh kotkfot yakitohrahrm.” ’ ");
INSERT INTO amp_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Profetm mrokfom kfo pthamoahat kfo memom, ‘Rorhu dukefrpno rhuruhatko be rorhu yufat yutahato nikmoh fasoh nefm yak thuhirahrko.’” ");
INSERT INTO amp_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pitar yuhre ptha hanymor, Brorhu Yafothar yawihnamorn thu nawohak-nimorm. ");
INSERT INTO amp_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Thu nawohaknimotrm wonk wonk yarmumam pthaknihato Bro Nkifrarhu yufat yura yura kfo nafhurmomt. Juda thofm Pitar hikhna-mom nd neft htimohat yima yuhum kkopentamomm. Kfo memom, “Dajohmn, yima tangim Bro Nkifrarhu Yafothar bi kekwomr.” ");
INSERT INTO amp_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Pitar ptha sinyahato kfo memor, “Rom bi nom yak hakumoa Yafothar bi kak twanhi-wumr. To nhai tfit wom frohr kfo raforuhatrm baftais yakneft.” ");
INSERT INTO amp_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Pitar kfo memorm, “Niko Jisas Kraisrhu yufatpno baftaiskfot.” Inji ptha buga-nimotr tfit kfo memomr, “Afo asha nom-pno wom yiham watohnhotwannom.” ");
INSERT INTO amp_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Judaroh aposermi Jisasr hiket yimam wanyakmom kfo memom, “Yima tangim bi arihat gutnius mrokfeft wanyhato hikwomt.” ");
INSERT INTO amp_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Bi nd mrokfot wany htatetmn tfit Pitar Jerusalemt yimohat nkifra tha puk thuneft yakitohet yimam Jisasr hikwam Pitar htihato namburmomr. ");
INSERT INTO amp_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Kfo memomr, “Nine tamoh dukeftpno nome yima tangiroh kunym yihato nuwa yenyhomonm?” ");
INSERT INTO amp_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pitar inji wanyhato ror namo nefm kfo nuhas bonuhasmorm. ");
INSERT INTO amp_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Kfo memorm, “Na Jopat tohmoya. Ndha tohhato wom yiha kfo bruttna hasohato wom shrt hwe tweh hanita kanjo yura moun yuhat htiyak hanymoyant. Memom ka bro rmontharn yimam manoh manoh psifm yakitohhato kafuhefiwumr. ");
INSERT INTO amp_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Inji htiyak hanyhato memoya, ‘Afo hti hik marnyaruha.’ Yukatohak hany asha wonk wonk tirf graf foh nungat yo nd wonk wonk bukor yemrot inji hti hanymoya. ");
INSERT INTO amp_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Inji hti hanyetann barkof tngt wanymoya. ‘Pita, nd yemrom watufnahkahnm waya.’ ");
INSERT INTO amp_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Na inji wanyhato kfo memoya, ‘Broye, ka nhai mif inji narhota! Bingot nom tohhnamohat nhai ye hnarmoyanm. Mur yemroyem.’ ");
INSERT INTO amp_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Inji kfomoya tfit wom tngt kfo memor, ‘Tamohtet yemrom arihat Bro Nkifrar famurn wayanm mirahn akfo amiya hnaruyem.’ ");
INSERT INTO amp_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Tfit wompam be nd rpahtet tngt kfomora. Wurohpam kfo-nihato tfit nd rmonthat rim fnahnimot. ");
INSERT INTO amp_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Inji htini hanyhato asha nanhu htiyakyuk husfirpa yimam mfnahmom na tohmo kunysn. Sisariako toh tany niamom nanhu htiyakt. ");
INSERT INTO amp_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Bro Nkifra-rhu Yafothatn kfo memota, ‘Mirahn aduka kinyaki hanya hik hanyneft. Wahik hanyswanm.’ Inji kfomotta ndar Jisasr hiket 6-pela yimampno rpat yimonomn Korniliusrhu kunys mfnahmonom. ");
INSERT INTO amp_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Mfnahmotnom kfo memornom, ‘Bro Nkifrarhu mounmotr kfo memora, “Wom yimam wakfo tkrurafkahtn Jopako aikahmn Saimonr amihtiyaktwam. Rorhu wom yufat Pitar. ");
INSERT INTO amp_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Nd yima Pitar nieruharn niko riphari ninhu hingrna yimam, wom mrokfom kfo hirahrko. Ror kfoyuk mrokfom wanyhato hikruhakomn Bro Nkifrar yakmiyakrahrko. Nhai finji naruhatrko niko fasoh nefm niwohat.” ’ ");
INSERT INTO amp_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Nd yimarhu mrokfom inji kfo ptha buganimotrm ee memoya, ‘Nanhu mrokfom kfo ptharuhanm,’ yuhre ripthak hanymoya Bro Nkifrarhu Yafothat mithu nawohmotm. Nom Bro Nkifrarhu Yafothat barkof mithu nawahmo kanjo rom inji mithu nawohmotm. ");
INSERT INTO amp_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Na inji htihato tfit dukamoya Bro Jisasr kfomo mrokfot. Kfo memor, ‘Jonr tek bupa furaye baftaisimmorm met yindarim. Tfit nikomn Bro Nkifrarhu Yafothaye baftaisimrahrko.’ ");
INSERT INTO amp_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Bingot nom Bro Jisas Kraisrhu mrokfom wany yakiohato Bro Nkifrarhu Yafothat yakmot, kangr, nd rpahtet Yafothat ahiyanm, na nhai tfit buha mtohhato Bro Nkifrar kfo rafokfot.” ");
INSERT INTO amp_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Pitar bi inji kfiwure, be nd nambur hasomo yimam nhai tfit wom nam-burrmom. Tfit Bro Nkifrar kfo yindhor-hato kfo memom, “Be, arihat bi htitwonom Bro Nkifrar wom wom kmim bi kukatohworm. Yima yuhu yak kekuthato toh nkifrayuk yihotat bi kak nukak kahukrm. Arihat bi yihotetem.” ");
INSERT INTO amp_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Stifenr wasmo yiharn Jisasr hiket yimam fakrme tubatunimom. Wom Fonesia distrikko fakrmenimom. Womm ailan Saiprusko. Womm Antiokko. Nd nd kmimn yakrmenihato Jisasrhu mrokfot ndko kfo ptha htfasmomt. To nhaf nhai be yima fura bofurampno ptharmoamt. Nhai. Tu Judarpampno pthamoumt nd Jisasrhu mrokfot. ");
INSERT INTO amp_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Rom tom rroh womm Saiprusi Sairinikor thofm. Romn nd Bro Jisasrhu mrokfot Antiokt hanyhato Antiokt tohyuk Grikm romn kfo ptha nuhasmomm. ");
INSERT INTO amp_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Bro Nkifrarhu bbukeft-pno pthamotm bok met yindarim wanyhato rroh fasoh fasoh yima yuhum yafho thuhato Jisasr rihikakmom. ");
INSERT INTO amp_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Jerusalemr tohyuk Jisasrhu yon kunys inji wanyakhato Barnabasr kfo tkrurafmotm Antiokko yimor. ");
INSERT INTO amp_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Yihato mhti yindhormorm rroh rhu nmbuhat Bro Nkifrar yak marnyamotrt. Mhtihato Jisasrhu yiha yiha yakitoh kihhato yafuhafo duha nmbuham, ndm rorn kfo habokknamorm. ");
INSERT INTO amp_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabasr nd kmi Antiokt tohmohat tu hifa dborioh yimar tohmor. Bro Nkifrar kakitoh kihmourr. Yo Bro Nkifrarhu Yafothat rhumoattr mrokfom kfo pthamoahat yimam wany yindhorni wany yindhorni Jisasr hikmoum. Nd Jisasr hiket yimam tfit nfri nfri yimampno thu hmbrimohat be tu bro rifuhetr rhumor. ");
INSERT INTO amp_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Barnabasr bok yimam htihato tfit Sorrhu hambrot yimor Tasisko. ");
INSERT INTO amp_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Yihato mhtiyakmorr. Mhtiyakhato rpat Antiokko tfit yihato Antiokt tohyuk Jisasr hikwa yimampno rpa gunyjimr tohnhohato Jisasrhu hik yuham, ndm kfo nuhas bonuhasmoufm. Tot nd yiharn nd Jisasr hikmo yimam rifutakmomm Kristenm. ");
INSERT INTO amp_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Nd yiharn Jerusalemr tohyuk wom profetm Antiokko yimom. ");
INSERT INTO amp_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Rroh womr, Agabusr, Bro Nkifrarhu Yafothat mthu nawohmottr kfo memor, “Nda Rom thofm tohukatohwa bbinysof bugat bro yatinoh wormr tohrahr.” Nd ror kfomo mrokfot fipet mrokfot kfomor. Kto Sisa Klaudiasr king tohmo yiharn nd yatinoh wormr tohmor. ");
INSERT INTO amp_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Nd yatinoh wormrhu mrokfot wanyhato Antiokt tohmo Kristenm Judat tohyuk Kristenm dukamom wom maruharoh yak nhafohhato htaf hanyeft. Yima yima turoh marut hti nhombrahato hta nhafohhemomm. Womm bok maruhetm bro maruham hta hanyhemomm. Womm nd dfik maruhetm dfikm hta hanyhemomm. ");
INSERT INTO amp_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Hta nhombra buganihato Barnabas Sorrof hemotm rofn hanyhato Jerusalemt tohyuk sioshu bro yimaroh tirmn mhtamofm. ");
INSERT INTO amp_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Nd yiharn sioshu wom yimam king Herotr kfomotr riwas beb bobe