﻿USE sofia;
DROP TABLE IF EXISTS sofia.amo_vpl;
CREATE TABLE amo_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES amo_vpl WRITE;
INSERT INTO amo_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Inyerte tisa kuwunun Yisa Kristi, usaun in Dauda, usaun Ibrahim. ");
INSERT INTO amo_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ibrahim wadi uchifin Ishaku, a Ishaku uchifi Yakubu, a Yakubu uchifin Yahuda nin nuanamẹ. ");
INSERT INTO amo_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","uchifin Parez nin Zaraha unuzun kumantin Tamar, Parez uchifin Hasruna, Hasruna uchifin Arama. ");
INSERT INTO amo_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arama wa maru Aminadaba ku, Aminadaba mara Nahashuna ku, Nahashuna mara. ");
INSERT INTO amo_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmuna ku, Saalmuna mara Bu'az ku unuzu kumantin Rahab, Bu'az mara Ubida ku, unuzu kumantin Ruth, Ubida mara Jesẹ ku. ");
INSERT INTO amo_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesẹ wadi uchif ngoh Dauda, Dauda mara Solomon ku, unuzun kitin wanin Uriya. ");
INSERT INTO amo_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon wadi uchifin Rehoboam, Rehoboam mara Abija ku, Abija mara Asa ku. ");
INSERT INTO amo_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa mara Jehoshapat, Jehoshapat mara Joram ku, Joram wa maru Uzaya ku. ");
INSERT INTO amo_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzaya mara Jotham ku, Jotham wa di uchifin Ahaz, Ahaz mara Hizikiya ku. ");
INSERT INTO amo_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hizikiya mara Manasa ku, Manasa mara Amon ku, Amon mara Josaya ku. ");
INSERT INTO amo_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaya mara Jikoniya ku nin nuanẹ kubin kifuzun nonon Israila udumun u Babila. ");
INSERT INTO amo_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Kimalin kifuzu udu u Babilẹ, Jikoniya mara Shealtiel ku, Shealtiel mara Zarubabel ku. ");
INSERT INTO amo_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zarubabel mara Abiud ku, Abiud mara ilayikum ku, Ilayakum mara Azor ku. ");
INSERT INTO amo_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor mara Zadok ku, Zadok wadi uchifin Achim, Achim wadi uchifin Eliud. ");
INSERT INTO amo_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud wadi uchifin Ileza, Ileza mara Mattana ku, Mattana mara Yakub ku. ");
INSERT INTO amo_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakub mara Yusufu ku, ulessin Maremu ulenge na awa maru Yisa ku unuzu kitene, ulenge na idin yicighe Kristi. ");
INSERT INTO amo_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Vat naji aji uyiru kitin Ibrahim udak kubin Dauda aji likure nin na nassari, uyiru kubin Dauda udu kubi ko na iwa yiru nani udu u Babila aji likure nin na nassari. ");
INSERT INTO amo_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kumanti Yisa Kristi wadi nafo nengenari. Unene Maremu wa yiinnin aba su ilugma nin Yusufu, a na isa su ilugma ba iseghe nin liburin in Fip Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ulesse Yusufu wadi unan fiu Kutellẹ, na awa di nin su a nighe ncin nan nya nanit ba. Bara nani awa di nin su asughe likire. ");
INSERT INTO amo_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Na awa di kpilizu ni leli imone, unan kadura Kutellẹ da kitime nan nya namoro, aworo, YUsufu, uusaun Dauda, na uwa lanza fiu in woru uyiru Maremu ku a so uwanife ba, bara fisudu fo na fidi nanya liburi me unuzu kitin Ruhu ulauwari. ");
INSERT INTO amo_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ama maru gono, uma yichu lisame Yisa, bara amma tuchu anit me nanya nalapi mine.” ");
INSERT INTO amo_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Vat nilele wase bara inan kulo imon ile na Cikilari wa belli nnu nanan liru nin nu me, a woro. ");
INSERT INTO amo_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Yenen kubura ma ti liburi kumaru gono, ima yicu lisame immanuel, uninare Kutellẹ ligowe nan ghirik.” ");
INSERT INTO amo_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yusufu fita nanyan moro me asu nafo na unan kaduran Cikilare na bellinghe, ayira Maremmu ku aso uwanime. ");
INSERT INTO amo_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Nanya nani iwa so lisosin nless nin wanii, na izuro ba udu kubi kongo na awa maru. A na lisan gone Yisa. ");
INSERT INTO amo_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","kubẹ na iwa maru Yisa ku in Baitalami un Yahudiya nayiri tigoh in Hiridus, amon anitt anan yiru yenju niyini kusari kitene nin Urushalima da ida woro, ");
INSERT INTO amo_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Adin weri ulenge na ina marughe ugoh na Yahudawe? Tina yene fiyini mere kusari kitene unnare ti da tida zazinghe.” ");
INSERT INTO amo_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Na ugoh Hiridus in lanza nani, ayi me nin na nitin Urushalima fita vat. ");
INSERT INTO amo_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Hiridus pitirino a didya na Priest nin na nan ninyerte nanit vat kiti kirum, anin tirino nani, “Nweri ima Kristi ku?” ");
INSERT INTO amo_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","I woro ghe nenge, “In Baitalamin Yahudiya, bara imon ile na nyan lirun nuu Kutullẹ na nyertin nari ine, ");
INSERT INTO amo_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","'A fe, ubaitalami, in myin Yahudiya, na fere ubene nan nya na nan bun Yahudiya, nani nan nya fere unan tigo ba nuzukuulenge na ama su libya nanit nig Israila.'” ");
INSERT INTO amo_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Hiridus tunna ayicila anan yiru vat likire a tirino nani in dert kubi kongo na fiyine na nuzu. ");
INSERT INTO amo_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","A to nani udu ubaitalahmi, a woro, “Can idi piziru ubeleng gono seng. Asa i se ghe, dan ida belli, bara meng wang nan do in di zazinghe.” ");
INSERT INTO amo_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Na i lanza ugowe ku, i kiffo libau i nya, fiyine na ini yene kusari kitene tunna ncin nbun mine fidi duru fiyisina kiti kirum dert kiti kanga na gọnọ diku. ");
INSERT INTO amo_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Na iyene fiyinie, isu ayi abo nin liburi libo kang. ");
INSERT INTO amo_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Itunna ipira nan nya kilare iyene gone nin nene Maryamue. Itumuno izazin ghe. Itunna i puzuno tika mine i nakpaghe imon ile na i ming mun, izinariya, lubban a kwul. ");
INSERT INTO amo_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Na ise uwannu nataf kiti Kutellẹ nan nya namorona iwa kpilin kitin Hiridus ba, ifita i yira nlong libau ugang ukpillu kipin mine. ");
INSERT INTO amo_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Na inung nna nya, Gono kadura Kutellẹ tun na a da kitin Yusufu nan nya namoro, a woroghe, “Fita uyiru gono, kinesse nin nene urum udu uMasar, udi so kikane se kubi kongo na mbellin fi uliru bara na Hiridus ma pizuru gone a molu kining.” ");
INSERT INTO amo_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","A tunna nin kitik ka ne afita a yauna ggono kinesse nin nene inya mun ucindu umasar. ");
INSERT INTO amo_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Awa di so kikane udi duru kubin nkul in Hiridus, ulire nan kulo na cikilare wa bellin kitin nnan liru nin nuu Kutellẹ, “Unuzun nan nyan Masar nna yicila usaun ning ku.” ");
INSERT INTO amo_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Na Hiridus iyene anitt ayinjing ane nrusuzo ghe, ayi nana ghe kang, ato idi molusu nnono ni lirine vat na niwadi in Baitalahmi, udu ligan nminne vat, ucizunu na kus aba utolu kadas nalenge na idurun ba, nafo kubatino kube na awa lanza Ubeleng nan nyan tinu na nit ajinjin ghe. ");
INSERT INTO amo_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ulirue u ni wa kulo vilengwe na iwa bellin kitin Irimiya unan liru nin nuuKutellẹ. ");
INSERT INTO amo_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“I wa lanza liwani nan nyan rama, kuculu nin tiyom a liburi lisirne, Rahilla di kuculu nnono me.” ");
INSERT INTO amo_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Na Hiridus nku gono kadura Kutellẹ da kitin Yusufu nan nya namoro in masar. ");
INSERT INTO amo_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Aworo, Fita, yauna gono kinesse nin nene, udo nan nyan nmin Israila.” ");
INSERT INTO amo_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Yusufue fita, a yauna gone nin nene, ada nan nya nmin Israila. ");
INSERT INTO amo_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Na alanza Arkila usari di tigon yahudiya kudarun ncife, Hiridus, fiu kiffo ghe na ado ba, vat nin woru Kutellẹ nwununghe kutuf nan nya namoro, ana lassina udu nmin ngalili. ");
INSERT INTO amo_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Amini ana wa dak ada da so nkan kipin na idin yiccu kinin unazarati, inan kulo uliru na iwa bellin tinu na nan nliru nnu Kutellẹ ima yiccu ghe kunan Nazarat. ");
INSERT INTO amo_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Na yiri ane Yohanna unan Shitizinu nanit nmyen wa dak adin bellu nliru ntucu nan nya ntene in Yahudiya a woro, ");
INSERT INTO amo_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Sunan alapi, bara kipin tigo Kutellẹ nda duru.” ");
INSERT INTO amo_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Bara amere ulele ulenge na iwa bellin ubelen me nnu Ishaya unan liru nin nuu Kutellẹ, a woro, “Liwui umong din yiccu nan nya ntene, 'Kelen libau ncikilari, kelen ulin mine nan-ghe.'” ");
INSERT INTO amo_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Imon kidowo in Yohanna wa di kukpa kuron komiari a likpa na liwa terin kutino me. Imonli me wa di acin ni titong. ");
INSERT INTO amo_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Anan Urushalima, nin Yahudiya a vat nigbiri nkilinu kurawan urdun wa nuzu idọ kitime. ");
INSERT INTO amo_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Awa shintu nani nan nyan nmyen kurawan urdun, a icin bele alapi mine. ");
INSERT INTO amo_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Kube na awa yene liigo na Farisawa nin na Saddukiyawa ucinfak kitime a shintu nani nmyen, a woro nani, “Anung kumat niyii timung, gharin wunung minu atuf ina ni din cum kiti tinana nayi na ti din ciinu? ");
INSERT INTO amo_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nutunong kumat ko na ku batiina usunuu na lapi. ");
INSERT INTO amo_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ana iwa kpiliza i woro nan nya mine, 'Tidi nin Ibrahim ucif bit.' Bara ndin belu minu Kutellẹ wasa ana Ibrahim ku nnan nono ko kiti na tala alele. ");
INSERT INTO amo_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Nene imali ciu gidowo litino naca. Vat kuca kongo na ku mara kumat kucine ba ima kowu kunin iti kunin nan nya nla. ");
INSERT INTO amo_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Meng din shintu minu nmyen i sun alapi mine. Ame ulenge na adin cinu kidun nighe a di nin likara a katini, na meng wang batin in yaun akpatak me ba. Ame ma shintu minuu nin Ruhu Ulau a ula. ");
INSERT INTO amo_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ku puruk me di nacara me, ama shintulu a nutun alkama nan nya kusheri lan, ama nin ciu alkame nan nya filai. Nani ama nin juju kusheri nin la ule na uma so ubico ba.” ");
INSERT INTO amo_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yisa tunna a fita a da kurawan urdun unuzun in Galili kitin Yohanna ada shintin ghe nmyen. ");
INSERT INTO amo_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ame Yohanna ta usu nworo a nantinghe, a woro, “Meng din piziru fe shintini nmyen, fe uni nna da kiti nigha?” ");
INSERT INTO amo_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Yisa kpana a woro ghe, “Yinna nani nene, bara udi gegeme kiti bite tikulo katwa kacine vat.” Yohanna yinnin ghe mun. ");
INSERT INTO amo_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kimal nshintin ghe kule, Yisa nuzu nan nyan nmyene mas, na nin molu kubi ba, i punghe kitene kani. A yene Uruhu Kutellẹ utolu kadas nafo kuwullung udak kitime. ");
INSERT INTO amo_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Itunna liwui nuzu kitene Kutellẹ liworo, “Ggono nsu kibinai Nighari kane. Ndin lanzu mmang me kang.” ");
INSERT INTO amo_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","kubi kongo na Uruhu wa yiru Yisa ku udu na kusho bara Shintang di dumun nghe. ");
INSERT INTO amo_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Na a su ukotu nayi, a yiri akut anas, nin limot a kut anas, Kukpong da ghe. ");
INSERT INTO amo_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Shintang da woro ghe, “Andi fe gono Kutellẹ ri kpilia atala alele a sofi imonli.” ");
INSERT INTO amo_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yisa kawaghe a woro, “Ina nyertin, 'Na nin nemaliari cas unit ma ti ulai mun ba, sei nin liru ule na unuzu nnu Kutellẹ.'” ");
INSERT INTO amo_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Shintang kuru a yiraghhe a piramuun nan nya kipin kilau a ghantinghe fitulleri kuti nlira, ");
INSERT INTO amo_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","a woro, “Andi fe gono Kutellẹ, yinna udiu kutyin bara ina nyertin abati nono kadura me, isu-uchafe, 'Tutung ima kpafi nin na chara mine,' bara 'Uwa riu kubunu fe kitene kutala.'” ");
INSERT INTO amo_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yisa woroghe, “Ina nyertin 'Tutung na uwa dumun Kutellẹ fe ba.'” ");
INSERT INTO amo_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Shintanghe kuru a yira ghe a domun likup lizallang a durso ghe nipinpin nan nimong igegeme in yeh vat. ");
INSERT INTO amo_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","A woroghe, “Illenge imone mba niyi ining vat, uwa tumun uzazini.” ");
INSERT INTO amo_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Kikanere Yisa nin woroghe, “Nyaa kikane Shintang! Bara ina nyertin 'Kutellẹ fere chas uma zazinghe, usu ghe liru.'” ");
INSERT INTO amo_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Kikanere Shintanghe nyaa a chibhe, nono katwa me tunna idasu ghe katwa. ");
INSERT INTO amo_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Na Yisa nlanza ikifo Yohanna ku, a tunna a kpilla udu Ugalili. ");
INSERT INTO amo_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","A cino Unazaret a di son in Kaparnaum, susut nin kurawan Ngalili, kagbiri nan Zabulun nin Naphtali. ");
INSERT INTO amo_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ilenge imone wa tinani inan kulo imon irika na Ishaya unan liru nin nu Kutelle wa belin, ");
INSERT INTO amo_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“ Nyin Nzabulun nin Naptalin, udu kusari kurawa, nbun Urdun, Galilli un nawurmi! ");
INSERT INTO amo_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Anit alenge na iwa sosin nanya sirti nyene nkanang midya, nin nalenge na iwa sosin kiti nkul nin kuyoli nkule, nkanang wa do kiti minee.” ");
INSERT INTO amo_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Kubi konere Yisa tunna-nbelle ani, “Sunan matiza mananzang, tigo-kitene kanae nda susut.” ");
INSERT INTO amo_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Kube na a wadin cin ngau kurawan ngalili, a yene awaba linuana, Simon na iwa yicu nghe Bitrus, nin Andrawus gnana me, idin dwang, bara na inung anan kifi zu nibo. ");
INSERT INTO amo_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yisa woro nani, “Dofinon ni, mba kpiliu minu iso ana kifizu nanit.” ");
INSERT INTO amo_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Itunna isuna ndwan-ghe idofinghe. ");
INSERT INTO amo_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Na Yiysa nleu ubun nin cinne, a yene amon-a waba linuana, Yakub usaun NZebadi nin Yohanna gwana me. Nan nya nimon cin kitenen myeene ligowe nan chif mine, nke nimon ndwanghe. A yicila nani, ");
INSERT INTO amo_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ituunna isuna imon ncin kitene nmee nin chif mine idofin nghe. ");
INSERT INTO amo_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yisa tunna ngalu nan nya Ngalili, ndursuzu nan nya natii nlira mine, abelle na ni uliru tigo kite nee kane, ninshizinu na nan tikonu ngangang nan nya nanite. ");
INSERT INTO amo_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Uliru kitenee me mala kiti nyanyan Insiriya, anitee da nin lee na iwa-di nin tikonu kiti mee ngangang nan na lee na agbergenu nkifo nani. Yisa shino nin nghinu. ");
INSERT INTO amo_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Ligozin nanit Ngalili, Udakafolis, nin Urushalima, Uyahudiya, nin kapinaum Urdun. ");
INSERT INTO amo_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Na Yesu wa yene ligozin nanite, a ghana kitene likupi na a so kutyen, nono katwaa me da kitime. ");
INSERT INTO amo_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","A puno uunuu atunna ndursuzu nanii a woro, ");
INSERT INTO amo_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Anan maoriari alenge na iidi likimon nruhu, kipin tigo Kutellẹ kin minere. ");
INSERT INTO amo_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Anan maoriari alenge na idi tiyom. ");
INSERT INTO amo_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Anan mmariari anan lazun nkune-kune, bara ima su ugadun nyii. ");
INSERT INTO amo_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Anan mmariari alenge na idi kukpon nin kotuzu nayi nsu katwa kacine, ima ti nani ishito. ");
INSERT INTO amo_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Anan mmariari alenge na idin nin kune-kune, inung wang mase nkune-kune. ");
INSERT INTO amo_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Anan mmariari alenge na idinin nibinayi ni lau, inughere ma yenu Kutelle. ");
INSERT INTO amo_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Anan mmariari anan gafizu lissosin limang, ima yiccu nani nono Kutelle. ");
INSERT INTO amo_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Anan mmariari alenge na idi tizu nani nanya niu bara katwa kacine, tigo kilari Kutelle maso tin mine. ");
INSERT INTO amo_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Anan mmariari anunghe na idin tizu minu tinanayi nin niu, sa idin bellu imon inanzang natimine bara lissaning. ");
INSERT INTO amo_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Sun ayiabo kan nin lanzun mang, bara na uduk mine udindyawari kitene kani. Nanere wang anit wa tizu nono katwa alenge na ina yarin minu uniu. ");
INSERT INTO amo_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Anunghre nto nyii ulele, asa nto nta rututu, miba ti inyizari miti mamas? Na midu nin katwa kacine tutung ba, asa igutuna minin ipatila nin nabunu. ");
INSERT INTO amo_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Anughere nkanang nyii. Kipin kanga naki tardin kitene likup na ki nyeshin ba. ");
INSERT INTO amo_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Nanere wang na anit wasa ita ula npitilla iwufu unin nanya kukuzung ba, sedei itarda unin kitin banju npitilla, unan niza anan kilare nkanang. ");
INSERT INTO amo_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Sunan nkanang mine baltu nbun nanit vat, nani mati kogha yene adu mine, inan su liru Ncifn mine na adi kitene kani. ");
INSERT INTO amo_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Na iwa yenje nafo nna dak nda musuzu uduka sa katwa nadura Kutelle ba. Na nna ndak nda musuzu ba, kuluzun tininari. ");
INSERT INTO amo_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kidegenari ndin bellu minu, uyii nin kitene kani ba malu, ama na ligbula sa fiyerte nanya nduka ma malu ba, se ikuluna imon ilenge na ina yerti nanya vat. ");
INSERT INTO amo_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Bara nani, vat ulenge na apuro uduka cingilin nanya tiduka, anin dursuzo among isu nani, aba so unit ubene nanya kilari tigo Kutelle. Vat ulenge na adi dortu, akuru adursuzo tinin ima yiccughe unit udya kilari tigo Kutelle. ");
INSERT INTO amo_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ndin bellu minu, asa na katwa kacine mine katin kan nanan dursuzu nan na Farisawa ba, na iba piru nanya tigo Kutelle ba. ");
INSERT INTO amo_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Inan lanza uliru ulenge na iwa bellu anan burne, 'yenje iwa molu unit,' nin woru, 'ulenge na amolo unit apira nanya licin nshara.' ");
INSERT INTO amo_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Meng ule din bellu minu, unit ulenge na ata tinanayi nin gwana, ama piru licin nshara. Ame ulenge na aworo ngwana, 'Fe ulalaghari!' Ama piru nacara tigo. Ulenge wang na woro 'fe di hem!' Ama piru nanya kuwu nla. ");
INSERT INTO amo_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Bara nani asa uma du nni nimon nfillufe nbun Kutelle, unin lizino nin kon kulapi kurika na kudi kitik fe nin gwana, ");
INSERT INTO amo_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","suna imon fillu fe nanuwa nakpa ba. Tu kpilla udi kyele kulape nin gwanafine, unin kpillin uda nakpa imon nfillu fe kiti Kutelle. ");
INSERT INTO amo_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Yinna mas ikyele uliru nati mine nin lenge na adi cinu udu nin fi ngan Go a idutu libau ucin du kuti nsharawe, bara awa do ninfi kiti nnan su nshara, ame unan sharawe di nakpafi naccara kudugari, anin di pirinfi nanyya kutii licin. ");
INSERT INTO amo_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Kidegenari ndin bellu fi na uma nuzu nanya licin lole ba, se ubya vat nikurfung ilenge na idi dortufi. ");
INSERT INTO amo_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Ina lanza ulire na iwa woro, 'Yenje iwa nozo nin nawanin ndas.' ");
INSERT INTO amo_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ama meng woro minu, vat ulenge na ayene uwani, ata kuna niyizi me nanya kibinai, amala usu linoni ningheri une. ");
INSERT INTO amo_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Andi liyizi ncara ulimefe din tizufi usu kulapi, kawurno linining ufillin. Bara uma katin fi nin caut nbara umong ugap kidowofe nana, nnun woru kidowofe vat piru nanya nla. ");
INSERT INTO amo_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Andi ucara ulime fe matifi kulapi, werne unin ufillin. Bara uma katinfi nin caut umong ugap kidowofe nana, nnin woru kidowofe vat piru nanya nla. ");
INSERT INTO amo_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Iwa woro tutung, 'Vat nlenge na ako uwani, na anighe iyerte nmalu nilugma.' ");
INSERT INTO amo_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Meng ule din bellu minu, vat na ako uwani me, andi na kitene kulapin nozu nin nalilime ba, ataghe unan nozu nin nnalilimeari une. Vat tutung ulenge na ayauna uwani ule na ina ninghe iyerte nmalu nilugma, adi kulapin nozu nin nawanin bidibidi. ");
INSERT INTO amo_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Tutung, ina lanza iwa bellu anit nayiri nburne, 'Yenje iwa su isilin kinu, ama sun imon ile na isulo mung kitin Cikilari.' ");
INSERT INTO amo_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Meng ule din bellu minu, na iwa su isilin ba, sa nin kitene kani, bara na kutet tigo Kutelleri; ");
INSERT INTO amo_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Sa nin kutyin, bara kiti na kiti liyisin nabunu Kutelleri, sa nin Urushalima, bara na kipin Ngo Udyawari. ");
INSERT INTO amo_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Na uwa sillo nin litife ba, bara na uwasa ukpilla titife tita tibo sa tisirne ba. ");
INSERT INTO amo_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Na 'kidegen mine so kidegen,' kinu mine so kinu.' Vat nimon ilenge na ikatin ilele, inuzu kitin Shetanari. ");
INSERT INTO amo_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Ina lanza iwa woro, 'Liyizi yita nnu liyizi, a liyini nnu liyini.' ");
INSERT INTO amo_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ama Meng nworo minu, yinnan, icuce minu, Vat ulenge na aparshin kuwan ncara ulime, kpilaghe kucara ugule tutung. ");
INSERT INTO amo_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Andi umong bolo kultukfe, anin din pizuru udu ninfi kityii shara, sughe amuunu ugudunfe ku wang. ");
INSERT INTO amo_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Andi umong tafi udi kaghe ncin fimel firum, can ninghe timel tiba. ");
INSERT INTO amo_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Vat ulenge na atirinfi naghe, tutung yenje uwa nari ubalu nnit ule na adi nin su nbalu nimon kitife. ");
INSERT INTO amo_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Inan lanza iwa woro, 'Ta usu ndofin kupofe unari unan nivirafe. ");
INSERT INTO amo_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Meng woro minu, 'ta usu nnan nivira fe, usu anan tizufi nanya nniu nlira, ");
INSERT INTO amo_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","bara inan so nono Ncifi mine ulenge na adi kitine kani. Ame din tizu uwui tutuzo kuneen nnan magunta nin nit ulau, asa a toltuno uwuru me tutung vat, kuneen nnan sali kulapi nin nan kulapi. ");
INSERT INTO amo_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Fewang ti usu nalenge na idi nin sufere cas, uyapin udukari umase? Na anan sesu ngandu dinsu nani wang ba? ");
INSERT INTO amo_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Andi udin su ilip nan linuwna nmang, nyaghari udin ukatina among? Na alumai wang din su nani ba? ");
INSERT INTO amo_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Bara nani sun lidu lidert, nafo na Ucif mine kitene kane di dert. ");
INSERT INTO amo_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yiran seng bara iwa su katwa kacine mine bara uyenju niyizi nanit asirne, iwa su nani na ima se uduk kitin Ciff mine na adi kitene kani ba. ");
INSERT INTO amo_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Asa ima fillu unit imon, na iwa fo kulantun nbun mine nafo na anan liya kiti din suzu nanya tibau a nilarin lira ba, bara inan se liru nanit asirne. Kidegen ndin bellu minu, imal seru uduk mine. ");
INSERT INTO amo_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ama andi uma fillu, na uwa yinni ucara ugule fe yinnin imon irika na udin sue ba, ");
INSERT INTO amo_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Asa uta nani, ufillu fe mayitu nanyan nyeshinu, Ucif fe tutung na adin yenju nanya liyeshighe manifi uduk. ");
INSERT INTO amo_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Tutung andi ima ti nlira, na iwa su nafo anan liya kiti ba, bara inung dinin su iyisizin nanya nati nlira nin ngau libau, anit nan yenje nani. Kidegen ndin bellu minu, inung mal seru uduk mine. ");
INSERT INTO amo_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Anung andi ima ti nlira, piran nanya npiit natii mine. Tursun nibulung mine, inin ti nlira udu kitin Cif mine ulenge na adin yenju nanya liyeshin. Ame tutung Ucif mine na adin yenju nya liyeshine ma timinu uduk. ");
INSERT INTO amo_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Tutung andi ima ti nlira, na iwa lawan kpilzu nliru urume tibatiba nafo alumai ba, bara inung din yenju nafo ngbardang liru minere mati ilanza nani. ");
INSERT INTO amo_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Bara nani yenjen iwa yita nafo inughe, bara Ucif mine yiru vat nimon irika na idi nin suwe a na isa tiringhe ba. ");
INSERT INTO amo_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Bara nani, tan nlira nafo nenge: 'Ucif bit nanya kitene kani, kusu lissafe. ");
INSERT INTO amo_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Na tigofe dak, na isu imon nayife nyii nafo na idin sue kitene kani. ");
INSERT INTO amo_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nanari kitimone imonli liyirin. ");
INSERT INTO amo_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kala nari tire bite, nafo na arike wang din kalzu na lenge na tidin dortu nani tire. ");
INSERT INTO amo_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tutun na uwa do ninghirik kitin maluzu ba, ama bolo nari ncara shintan: bara kipin tigowe kinfere, likara nin gongon uyaunu nene udu saligan. Usonani.' ");
INSERT INTO amo_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Bara asa idin kalzu anit alapi mine, ucif mine kitene kani wang ma kalu amin alape. ");
INSERT INTO amo_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ama andi na anung din kalzu alapi na lenge na idin su minu ba, nanere wang na ucif mine ma kalzu amin alape ba. ");
INSERT INTO amo_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Nanere tutung andi ima su ukotu nayi, na iwa timoro nafo anan tiyom ba, nafo na anan liya kiti dinsu inan ta anit yinno inung din su ukotu nayi. Kidegen ndin bellu minu inung nmal se uduk mine. ");
INSERT INTO amo_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ama anung andi imasu ukotu nayi, ikusu timuro mine lau itiza nnuf. ");
INSERT INTO amo_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Bara anit wa yinnin idin kotu nayi. Ame Ucif mine na adin yenju usanme ma nimunu uduk. ");
INSERT INTO amo_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Na iwa ceo atimine utamani nanya nle uyie ba, kiti kanga na kijiji nin binju din li, nin kiti kanga na akiri din kuluzu i tuzuzu. ");
INSERT INTO amo_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Na ceun ati mine utamani kitine kani, kiti ka na kijiji nin biju wasa inaza ba, kiti kanga na akiri wasa ipuro ituzuzu ba. ");
INSERT INTO amo_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Kiti kanga na utamani fe duku, kikanere wang kibinayi fe ma yitu ku. ");
INSERT INTO amo_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Liyizi, linere upitila kidowo. Bara nani, asa liyizife di licine, kidowo fe vat mayitu lau. ");
INSERT INTO amo_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ama asa na liyizi dilicine ba, kidowofe vat mayitu nin dinong. Asa kidowo fe sali nin kanan, gbardang nsirte kati likara nbellu! ");
INSERT INTO amo_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Na unit urum wasa asu katwa kiti nacikilari aba ba, nbara anari umon, ati usu nmon, asa na ata nani ba, aba ni litime kan kiti nmon anin dira usu katwa kacine kitin mong. Na iwasa isu Kutelle liccin nin tamani kubi kurume ba. ");
INSERT INTO amo_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Bara nani nbelin minu, na iwa ciso ucara litawa nbelen kpilizu nliru nbelen natime inyaghari ti ba li sa tiba sonu, sa nidowo bite inyaghari tiba shonu. Na ulai katin imoli ba, nakidowo katin imon shonu ba? ");
INSERT INTO amo_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ton iyizi iyene anyin kitene kani! Na idi su tibila sa upitiru kusana iciso lilai ba, Ucif mine na adi kitene kane din nizu nani imonli. Na anung katin nani nin gongon kan ba? ");
INSERT INTO amo_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Uyeme unitari nanya mine bara tiyom nimon nyii ulele wasa akpina ngbardang nayiri nlai me? ");
INSERT INTO amo_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Nyaghari nta idi tiyom nbelen nimon kidowo, kpilzan uliru nanya nibinayi mine iyene amamu naneen, imus tikunang nanin; na adin su katwa ba, ana adin sho imon kidowo ba. ");
INSERT INTO amo_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Na nbellin minu tutung, Solomon litime vat nin gongong me, na awa ashon imon kidowo na iwa katin amamu nin caut ba. ");
INSERT INTO amo_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Andi Kutelle din su amamu nanya naneen kuyok kucine nani, arika na asa atuto kitimone, ula kurtuno uleo anin nin kui, ama so sa uni miinu imon nshonu kidowa? Anung anan kibinayi kikaf? ");
INSERT INTO amo_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Bara nani na iwa su tiyom iworo, 'Inyaghari tiba li'? Sa iworo, 'iyagahri tiba sonu'? Sa tutung iyaghari tiba shonu kidowo'? ");
INSERT INTO amo_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Imon ilele vat alumai din cisu nibinayi mine npizuru ninin, Ucif mine tutung kitene kani yiru idi nin su ninin vat. ");
INSERT INTO amo_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ama cizinan upiziru tigo nin katwa kacine me, vat ngisin nimon ilele ima kpin minu ku. ");
INSERT INTO amo_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Bara nani na iwa su tiyom nbellen nkui ba, bara na ukui ba su tiyom litime. Kolome liri di nin niume. ");
INSERT INTO amo_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Na uwa sharanta ba, iba sharanta fi. ");
INSERT INTO amo_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nin sharaa ule na usuu, iba suu fi. Tutung kuyangi koo na uguro mung, iba guru fi mung. ");
INSERT INTO amo_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","In yan ghari taa uyene kamong na ka di liyizin gbana fine, na uyene ku kunti kuca nya liyizi fe ba? ");
INSERT INTO amo_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","In yiziyari uba bellu gbana fine, 'Nan kala kamong nya liyizi fe,' a fee nin kukunti kuca nya liyizife? ");
INSERT INTO amo_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Anun anan kinuu! Kalan ku kunti ku ce nya niyizi mine, iba nin yenu kanang kamong ne nya niyizin gbana mine. ");
INSERT INTO amo_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Na uwa ni nanau imon ilau ba, tutung na uwa tuu imon i cine nbun ninau ba, mboti iba patilu inin gitiring ikifizing fi. ");
INSERT INTO amo_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Tirino, Iba nifi piziran umase. Reu kibulung ghe iba punfi mung. ");
INSERT INTO amo_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ko uyeme utirinu unit din sessu, unan pizu re din sessu, unan fo nibulung ghe iba puun ghe mu. ");
INSERT INTO amo_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Sa ghari nya mine na usa ne nwatiring ghe kugirin borodi ayira litala a nakpa ghe? ");
INSERT INTO amo_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Sa awa tiring ghe fiboo, a nakpo ghe fiyii? ");
INSERT INTO amo_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Bar nani andi anun anan nibinei ni nanzang yiru unin nono mine imon icine, inyizyari ucif mine na adi kitene kani yiru uni nimon ki ne udu kiti na le na itirng ghe? ");
INSERT INTO amo_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Bara nani vat ni le imon na udinin su anit suu fi, fe wan suu nani mung, uduka re une nin anabawa. ");
INSERT INTO amo_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Pira nya kibulun kishuute, libau di pash na li din wunu anit udu ukul, anit gbardang din cinu nyan nye. ");
INSERT INTO amo_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kibulung ghe di shuut, tutung libau we wan di shut na li din wunu anit udu ulai, anit cing lin aghari din se lining. ");
INSERT INTO amo_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Sung seng nin nan kadura kinuu, ale na idin dasu minu nin nakpa nakam, nya mine ninyinyowari. ");
INSERT INTO amo_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Nya kumat mine iba yinnu nani, sa anit din kolu ulemu na ca kumart kushari, sa idin kolu kumal kupul kumart? ");
INSERT INTO amo_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nanere, vat kuca kucine din macu kumat ku cine, kuca ku nanzang, maca kumal kunanzang. ");
INSERT INTO amo_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Na kuca kucine din macu kuman kunan zang ba, sa kuca kunanzang ko na kudin macu nono nicine ba. ");
INSERT INTO amo_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Vat ku ca koo naku mara nono ni cine ba asa ikiwe kuning itoo nyan la. ");
INSERT INTO amo_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Bari nani kiti kumat mine re uba yinnu nani. ");
INSERT INTO amo_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Na vat ghari na adin yicci, 'Cikilari, Cikilari,' b apiru nya kilari Kutelle ba, sei ule cas na adin suu unufin Cif nighe na adi. ");
INSERT INTO amo_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Anit gbardang ba belli nloli lirre, 'Cikilari, Cikilari, na tiwa suu anabci nin lisafe ba, nin lisafe tinutuzuno agber genu, nin lisafe ti suu imon zikikya?' ");
INSERT INTO amo_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Mba nin bellu nani kanang, 'Nan ina yiru minu ba! Nyan ku poo nin, anun anan kataa kananzang!' ");
INSERT INTO amo_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Bar nani, vat nle na alanza tigbulang ni ghe asuu kataa mung ma soo nofo unit ujingjing une na ake kilari me kitene kuparang. ");
INSERT INTO amo_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Na ijuu uwuru, mmen ncung daa, ufunu udya wufu ufo kilare, vat nane na ki deu ba, bara na iwa ke kining kitene kuparang ");
INSERT INTO amo_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Vat ule na alanza tigbulan nin amini nari usuu kataa mung ba masinu unit ulanlang une na akee kilari kitene licin cing. ");
INSERT INTO amo_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Uuwuree juu, mmeng cung daa, ufunu daa ureu kilare ki deu. Udeu we wa di gbardang. ");
INSERT INTO amo_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Uda duru kubi koo na Yesu wa malu ubelu na gbulan alele, ligozin na nite, umamaki kifo anii nin dursusu me. ");
INSERT INTO amo_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Bar na awa dursuzo nani nofo ule na adi nin na kara, na nofo anan ni nyert mine ba. ");
INSERT INTO amo_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Na Yisa nto; o kitene likup, ligozi gbardang dofine. ");
INSERT INTO amo_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Umon, ame ukuturu da kitime, atumuno mbun me, aworo, “Cikilari andi uyinna, uwasa utayi nso lau.” ");
INSERT INTO amo_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Yisa nakpa ucara me a dudoghe aworo, “Meng yinna. Ta lau.” Na nin nmolu kubi ba atinna a weseghe ata lau nin tikuturu me. ");
INSERT INTO amo_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yisa woroghe, “Yene yenje uwa bellin umon imomon, can libaufe, udurso litife kitin pirist nin nni nimon ule na udukan Musa na bellin, bara uni ngodiya kitime. ");
INSERT INTO amo_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Na Yisa npira nanyan Kaparnahum, nkon kusoja kudia nroma, da kitime ada tiringhe, ");
INSERT INTO amo_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","aworoghe, “Cikilari, kucin nighe non nanya kilari nin nkonun nriu nagbergenu, adi nanyan nlanzu npazaza kang.” ");
INSERT INTO amo_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yisa bellinghe, “Meng ba dak nda shin ninghe.” ");
INSERT INTO amo_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ame udia nasoja kawaghe aworo, “Cikilari, na meng mabtin fe da piru nanya kilari nig ba, bara nani belle ligbulang cas kucineghe ba shinu. ");
INSERT INTO amo_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Bara meng wang unitari ulle na nsosin kuteet likara, nmini dinin na soja alle na idi kadas nigh, assa nworo nlenge, 'Can,' ame nsa anya, nin kiti nmong tutun nworoghe, 'Da,' ame asa ada, nin kucin nigh, 'Su nenenghe,' asa asu inin.” ");
INSERT INTO amo_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Na Yisa nlanza nani, asu umamaki anin belle alenge na idi ligowe nanghe, “Kidegen ndin bellu munu, nin nanyan Iseraila, na nse umon na adinin nimus nle uyinnu sa uyene gbardang nani ba. ");
INSERT INTO amo_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ndin bellu minu, anit gbardang ba dak unuzu gabar nin yamma, iba da so ili kutebul nin Ibrahim, isheku a yakubu nanya kilari tigo kitene kani. ");
INSERT INTO amo_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Bara inug, nono tigowe iba turnu nani nanya nsirti midiya, kiti kanga na kuculu ba yitu ku nin nyaku nayini.” ");
INSERT INTO amo_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Yisa belle udia nasoja, “Can! Nafo na uyinna uba di so nani, iba sufi.” Kucin me tunna ku shine ndedei kube. ");
INSERT INTO amo_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Kubi na Yisa wa piru kilarin Bitrus, ayene kumara Bitrus kuwane, annon nin nkonu. ");
INSERT INTO amo_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Yisa dudo ucarame, atinna ashino. Na afita asughe uhidima. ");
INSERT INTO amo_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Na kuleleng nda, anite da nin nale na agbergenu na rizu nani kitin Yisa anutuzuno agbergenue nin ligbulang nliru, ashino nin na nan tikonu vat. ");
INSERT INTO amo_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nanere iwa kullu ule imon na iwan mo bellu kiti nnan liru nin nnu Kutelle Ishaya, nworu, “Ame litime na yaun tikonu bite nin ticuta.” ");
INSERT INTO amo_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Nene na Yesu nyene ligozi nkilinghe, ana uduka isun koni kusari kurawan Galili. ");
INSERT INTO amo_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nani umong unan ninyerte da kitime aworo, “Unan durrsuzu meng ba dofinfi vat kika na uba du.” ");
INSERT INTO amo_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yesu woroghe, “Ninyanyawa dinin ti mine, anyin yita nin tido mine, amma na gono nnit dinin kiti ka na aba nonku litime ku ba.” ");
INSERT INTO amo_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Umong nanya nono katuwa me bellinghe, “Cikilari, yinna menku ntu ndo ndi kasu ucif nighe.” ");
INSERT INTO amo_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Bara nani Yisa woroghe, “Dofini anan nkul kasu atimine anar nkul.” ");
INSERT INTO amo_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Na Yesu npira uzirgi, nono katuwa me dofinghhe udu nanye. ");
INSERT INTO amo_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Itunna, kikane kuwut nin funu nuzu kitene kurawan fibarakh nmyin tursu uzirge, ame Yisa yita nmoro. ");
INSERT INTO amo_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Inun nono katuwa da kitime ida fiyaghe, iworo, “Su utucu bite Cikilari; arike ba kuzu!” ");
INSERT INTO amo_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu woro nani, “Inyari nta idin lanzu fiu, idinin nyinu sa uyenu cingligha?” Afita akpada ufune nin kurawe. Kite tinna ki so tik. Inug anite su umamaki iworo, “Imusi nyapin unitari, ulle ufunu nin kurawa din dortu uliru me?” ");
INSERT INTO amo_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Anite su umamaki, inin woro, “Uyapin unitari ulele har tifinu nin kuli din latizighe?” ");
INSERT INTO amo_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Na Yesu nda nkon kusari nmyin Garasinawa, anit anwaba alle na agbergenu din cinnu ninghinu zuroghe, asa i wa nuzu nanya nisek idin nin magunta, na umon unan cin wansa akata libau lole ba. ");
INSERT INTO amo_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Itunna isu kuculu iworo, “Iyaghari tidumun na tiba su ninfi, gono Kutelle? fe nda kikanere unan tanari tinoo kamin kube na ina jeowa?” ");
INSERT INTO amo_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nene Ligo naladii wandi kikane kileo, na iwa di pit kitimine ba. ");
INSERT INTO amo_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Inug agbergenue foghe acara iworo, “Assa unutuno nari, ta nari tipiru ligo naledu ane.” ");
INSERT INTO amo_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu belle nani “Can!” Inug agbergenue nuzu idi piru nanya naladue, itunna vat ligowe putu likup udu nanya kurawa inane nanya nmyen. ");
INSERT INTO amo_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Inug anite alle na idin ndortu nalade ico udu nanya kipin, idi bellin vat nimone, umunu imon na ise alle na agbergenue din cinu ninghinu. ");
INSERT INTO amo_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Itunna vat kagbire nuzu udii zuru nan Yisa. Na iyene ghe, ifoghe acara asun kagbir mine. ");
INSERT INTO amo_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu pira nanya nzirgi, akafina udu nanya kanme kagbire. ");
INSERT INTO amo_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Itunna ida nin nimon alle na adinin nkonu nriu nfunu, anon kitene kuppe. Uyenun nyinu mine sa uyenu, Yesu woro nnan konu nriu nfune, “Gono, su liburi libo, alapi fe iwese.” ");
INSERT INTO amo_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Itunna amon anan ninyerte iworo nanya natimine, “Ulle unite unan nanzu kitiari.” ");
INSERT INTO amo_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu yinno ugbilizu mine aworo, “Iyari nta idin gbilizu imon inanza nanya nibinai mine? ");
INSERT INTO amo_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Bara iyeme ari kalin nin sheu nbellu, 'Iwese alapi fe sa iworo fita ucinu'? ");
INSERT INTO amo_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Bara nani inan yirino nworu usaun nnit dinin likara nyi a wese alapi,...” a woro nnan konu nrui nfunue, “Fita, yauna kupefe, udo kilarife.” ");
INSERT INTO amo_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Nin nani unite fita anya udu kilari me. ");
INSERT INTO amo_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Na ligosi nyene nani, Iwasu umamaki izazina Kutelle, ulle na adin nizu imus nlo likare kiti nanit. ");
INSERT INTO amo_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Na Yesu nkata likane, ayene unit unan lisa Matta, ule na awa sosin kitin nsesu ngandu. A bellinghe, “Dofini.” Ame fita atunna a dofinghe. ");
INSERT INTO amo_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Na Yesu nso ali imoli nanya kilari, itunaa anan sesungandu nin nanit anan kulapi dasa ida li imonli nin Yesu a nono katuwa me. ");
INSERT INTO amo_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Na afarisayawa nyenenani, iworo nnono katuwa me, “iyari nta unadursuzu mine din li imomli na nan sesu ngandu nin nanit anan nalapi?” ");
INSERT INTO amo_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Na Yesu nlanza nani, aworo anit alle na idinmun nakara nidowa, na idin piziru ukan ba, cas anitalle na idimun tikonu idinin su nkan, ");
INSERT INTO amo_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","anug iwasaqaq inya idi yinin imon na idin su, “meng din nin nsu nadalci na uhadaya ba, bara nna dak na nyicila anit alau ba, ituba ba, anan kulapi.” ");
INSERT INTO amo_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Inug nono katuwa Yohanna da kiti me iworo, iyaghari nta arik nan na farisawa asa ti tere tinu, na inu nono katuwafe din tecu tinu ba.” ");
INSERT INTO amo_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yisa belle nani, “Inug alle na ido kiti nilumga wasa isu liburi lisire a kwanyana tiyome yita nanghinua? bara ayiri din cinu na iba da yaunu kwanyana tiyome kitimine, iba teru tinu. ");
INSERT INTO amo_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Na umon nwasa atafa kuzeni kupese nin ku kuse ba, bara kupori kupese bati kulutuke jarta, tutun uba yitu kang. ");
INSERT INTO amo_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Nanere anti nwasa ita nmyin narau lisu ikuse ba, iwa su nani, lisue ba wutu, nmyen naraue gutun, lisuwe ba malu kitii, bara nani ibati nmyen narau mipese lisu lipese vat mine baso.” ");
INSERT INTO amo_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Kubi na Yesu wadi nbellu nile imone kitimine atunno umong unit udia ada atumuno kitime. A woro, “ ushono nighe nene akuu, bara nani da uda tarda ghe acarafe aba fitu.” ");
INSERT INTO amo_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Nin nani Yesu fitah adofighe, nanere inun nono katuwa me. ");
INSERT INTO amo_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Itunna umon uwani adi nin gu5tuzunu nmie kang akus likure nin na ba, ada mamalin Yesuada dudo kubaga kulutuk me. ");
INSERT INTO amo_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Bara awa bellin litime,” asa ndudo kulutik me cas meng ba shinu.” ");
INSERT INTO amo_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Bara nani Yesu gitirno ayeneghe aworo, “ ushono ning ta ayi akone, uyinnu fe sa uyenu nshono nin fi, uwane tinna ashino deddei. ");
INSERT INTO amo_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Na Yesu nda kilari nnit udia, ada se anan nalantu di naru, a ligozi yita. In ghejilu kang. ");
INSERT INTO amo_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ame woroghe, “Canfi na kubure nkuwariba, adin nmoroare, bara nani inug sisaghe nin sughe ubaha. ");
INSERT INTO amo_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Na iceou ligoze ndas, a pira nanya kutee, akifoghe ncara kubure fita. ");
INSERT INTO amo_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Unin ulirue tunna umala kiti, nyanya kipi kane. ");
INSERT INTO amo_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Na Yesu wa kata unzu kikane, adu an waba dofinghe, itunna ntutuzu idi nsu “ lanza nkunekune bite usau Dauda.” ");
INSERT INTO amo_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Kubi na Yesu ndah nanya kilare, inung aduanne da kitime, Yesu belle nani” anung nyinna nwasa nsu ille imone,” Inung woroghe, “eh Chikilari.” ");
INSERT INTO amo_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Nin nnani Yisa dudo iyizi mine, aworo, “Uso nani kitimine, nafo uyinnu mine sa uyenu.” ");
INSERT INTO amo_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nanere iyizu mine wa pun. Yesu kpada nani kang aworo, “Yenen na umon wa yinin kitene nile imone ba.” ");
INSERT INTO amo_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Var nin nani adu ani nuzu itunna nbellu nlirie vat kaghir kane. ");
INSERT INTO amo_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Na anit an waba ane wa nya, itunna idamun nin nmong uturi na agbergenu na pirughe iida mu nghe kitin Yesu. ");
INSERT INTO amo_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kubi na inutuno agbergenue, uturi une lirina, ligozi su umamaki iworo, “Ille imone na tisa yene inin in Israila ba.” ");
INSERT INTO amo_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Bara nani inung a farisawa woro, “Adin nutuzunu agbergenue nin ndia nagbergenere.” ");
INSERT INTO amo_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yisa nya udu vat nighiir nan nitari: aleo ubun dursuzu nanya nati nlira, adi nbelle uliru nlai un tigo, ashino nin vat tikonu nan nale na idi acine ba. ");
INSERT INTO amo_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Na ayene ligozi nanit, alanza nkune kune mine, bara iwa su udamuwa, nibinai wulu nani bara wnadi nafo akam sa unan libia. ");
INSERT INTO amo_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","A belle nono katuwa me “Unin ugirbe karin inun anan karin ba. ");
INSERT INTO amo_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Bara nani, deddei sun nlira kiti Ncikilari ngirbe, anan kpina nan girbe nanya kunene.” ");
INSERT INTO amo_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu yicila nono katwa me inung likure nan nawaba ligowe a na nani tigo kitene tiruhu tinanzang, i nutuzung nani ndas, ikuru ishizin nin vat tikonu a nsalin cine nidowo vat. ");
INSERT INTO amo_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nene tisan nono katwa we inung likure nan nawabe wadi ne. Unan cizune, Simon (urika na awa yicughe Bitrus), a Adrawus gwane; Yakub usaun Zabadin, nin Yuhana gwane; ");
INSERT INTO amo_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filibus, nin Batalomi; Yakub usaun Alpensus, nin Tadawus; ");
INSERT INTO amo_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon unan pizuru tigo nati, nin Yahuda Iskaroti, ulenge na ama lewughe. ");
INSERT INTO amo_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ale likure nan nawabe Yesu wa tuu nani. a wunno nani atuf aworo, “Na iwa do kika alumai duku ba, tutung yenjen iwa piru kan kagbirin Samariya. ");
INSERT INTO amo_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Nana na can kilarin nakam nwulun Israila. ");
INSERT INTO amo_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Tutung asa inya, belen nani uliru Kutelle iworo, “udak kipin tigo Kutelle nda duru.' ");
INSERT INTO amo_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Shizinon nin nanan tikonu, fyan anan kul, wesen anan tikutulu, tutung nutuzunon agbergenu. Inan filin munari, anung wang filizinang. ");
INSERT INTO amo_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Na iwa yiru fizinariya, azurfa sa fi jangaci tika mine ba. ");
INSERT INTO amo_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Yenjen iwa yaun nkan cin bara ucin mine, sa altuk aba, sa akpata, sa ucan ncin, bara unan katwa ma diru imonli me ba. ");
INSERT INTO amo_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Vat kagbiri sa atii alenge na ipira, pizira ulenge na ado Kutelle nanye, isoku udu lilongo na ima nyiu. ");
INSERT INTO amo_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Asa idin piru nanya kilare, lisonnani. ");
INSERT INTO amo_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Iwa kawu minu mang na ayi asheu mine so nanghinu, anna ikawa minu mang ba na ayi asheu mine kpilin kiti mine. ");
INSERT INTO amo_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Inung tutung alenge na Isere minu ba, a na ilanza uliru mine ba, iwa nya yiu kilari kane sa kani kagbire, kotinon lidau nabunu mine. ");
INSERT INTO amo_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kidegen ndin bellu minu, anan Sodom nin Gomora ma katinu nin lanzu mang lirin shara nin kani kabgwere. ");
INSERT INTO amo_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Yenen, nto minu ndas nafo akam nanya niyiyo, bara nani, yitan jijin nafo iyii ikuru iyita sa unanzu nimon nafo awulung. ");
INSERT INTO amo_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","punon iyizi anit mung! Iba du ninghinu ubun nago, tutun nanya natii nlira mine iba kpizu minu. ");
INSERT INTO amo_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Iba kuru ida ninghinu ubun na gomna nan nago bara meng, uma so nafo ushaida nanya nalumai. ");
INSERT INTO amo_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Iwa do ninghinu kiti mine, yenje iwa fo kidowo kitene nimon ilenge na ima bellu, bara imon ilenge na ima bellu ima niminu nanyan koni kube. ");
INSERT INTO amo_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Bara na anughere ma su ulire ba, Uruhu Kutelle nanya minere ma liru. ");
INSERT INTO amo_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Gwana ma lewu gwana idi molu, Ucif tutung gonome. Nono mafitu mayardang nin nacif mine inin tizu nani idi molsu nani. ");
INSERT INTO amo_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Anit vat ba nari minu bara lissaning. Ama vat nlenge na atere kibinayi udu liganye, ama se utucu. ");
INSERT INTO amo_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Iwa kara minu nka kagbiri, con udu kan, bara kidegenere idin bellu minu, na ima nuzu vat uduru nigbirin Israila ba, gonon Nit ma dak. ");
INSERT INTO amo_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Na gono unan masu wasa akata unan dursuzu me ba, sa kucin yita nbun Cikilari me. ");
INSERT INTO amo_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ubatina ame unan mase so nafo unan dursuzu me, nanere kucin nafo Cikilari me, iwa yicila Cikilare Belzubal, ma ngbardang nanzu nale na idi nanya kilari me ma yitu nyizari! ");
INSERT INTO amo_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Bara nani, na iwa lanza fiu mine ba, bara na imomong duku na itursun, ilenge na ima punu ba, a na imong duku ilenge na iyeshin ile na ima yinnu nin ning ba. ");
INSERT INTO amo_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ilenge imon na Nbellin minu nanya nsirti, bellen ining nin wui, tutung ile imon na ilanza baat nin natuf mine, ghanan kitene kilari ibellin ku. ");
INSERT INTO amo_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Na iwa lanza fiu nle na ama molu ka kidowe ba, ama na awasa amolo ulai ba. Na lanzan fiu nlenge na awasa amolo vat ka kidowe nin laiye nla saligan. ");
INSERT INTO amo_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Na niwulun niba idin lesu ni nin nin nikurfu baat ba? Vat nin nani, karum wasa ka deu kutyin sa uyirun Cif mine ba. ");
INSERT INTO amo_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Titi litife wang ayiru timashi nari. ");
INSERT INTO amo_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Na iwa lanza fiu ba, ikatin niwulung nane nin gongon. ");
INSERT INTO amo_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Bara nani, vat nlenge na a yinna nin mi nanya nanit, Meng wang ma yinnu ninghe nbun Ncif ning, ulenge na adi kitene kani. ");
INSERT INTO amo_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ame tutung ulenge na anari nbun nanit, meng wang mmanari ghe nbun Ncif ning, ulenge na adi kitene kani. ");
INSERT INTO amo_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Yejen iwa kpilza nna dak nin lissosin limang nyie. Na nna dak nin lissosin limang ba, nna dak nin kusangaliari. ");
INSERT INTO amo_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Bara nna dak nda dunjo unit nin cifme, a ushono nin name, a uwul nin nanlesme. ");
INSERT INTO amo_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Anan nivira nin nit ba yitu anan nanya kilari me. ");
INSERT INTO amo_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ame ulenge na adi nin su cif sa uname nbun ning na abati unan dortu ninghe ba. Tututng ame ulenge na adi nin su nshonome sa usaunme nbun ninghe, na abatin unan dortu ning ba. ");
INSERT INTO amo_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ame ulenge na ayauna kucan kotinu me adofini ba, na abatin unan dortu ninghe ba. ");
INSERT INTO amo_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ame ulenge na ase ulai me ba diru unin. Ame tutung na adira ulai me bara meng, ama se unin. ");
INSERT INTO amo_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ulenge na asere minu, asere mengku, ame tutung na aserai, asere ulenge na atoyi. ");
INSERT INTO amo_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ame ulenge na asere unan liru nin nu Kutelle ama seru ulada nna liru nin nu Kutelle. Tutung ame ulenge na asere unit ulau bara adi unit ulau, ama seru ulada nnit ulau. ");
INSERT INTO amo_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Vat nlenge na ana umong nanya nabebene alele, ka kop nmyen micancam asono, bara ame unan kadura Kutelleri, kidegen nbellin minu na ama diru ulada me ba.” ");
INSERT INTO amo_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Na Yesu wa malu uni nnono katwa me likure nan wabe kadura, a nya kikane cundu nanya Nigbiri udu ndursuzu nani tipinpin. ");
INSERT INTO amo_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Na Yuhana nlaza kilari licin, kata ka na Kristi dumun, a to nono katwa me kadura inung naba. ");
INSERT INTO amo_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","aworo nani, can idi woroghe, “Fere ule na udin cinu udake, sa tiso nca nmong?” ");
INSERT INTO amo_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesu kawa aworo nani, “Can idi belin Yuhana ku imon ilenge na ilanza iyene. ");
INSERT INTO amo_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Adu din sesu uyenju kiti, anan sali nabunu din cin, akutulu se ushinu, a turi din lanzu tutung, abi din fituzu nin lai, idin bellu anan sali nimon uliru ulau. ");
INSERT INTO amo_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Unan mariari ule na ase imon ntirzu liti ning ba.” ");
INSERT INTO amo_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Na ale anite nya libau mine, Yesu cizina ubelu ligonzine uliru litin Yuhana, “Inyaghari i do nyenje nanya kusho- ufunu nzunu nkpe myena? ");
INSERT INTO amo_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ani inyaghari inuzu ndin yenje ndas- unit na ashono imon tigowa? Nanere, ale na idin sho imon tigo sosin nilari Tigo. ");
INSERT INTO amo_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Sa nyaghari ido idi yene ndase- unan liru nin nu Kutelle? Eh nbelin minu tutun, ukatin unan liru nin nu Kutelle. ");
INSERT INTO amo_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ulengenere ame ule na iwa yertin litime, 'yenjen nma tu unan kadura ning nbun timuro mine, ulenge na ama ke udina ning nbun mine.' ");
INSERT INTO amo_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Nbelin minu kidegene, vat nale na kumat nwani, na warum duku na akatin Yuhana unan shintu nanit nyen ba. Vat nani unit ubene kilari tigo kitene kani katinghe. ");
INSERT INTO amo_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Unuzu nayirin Yuhana unan shintu nanit nmyen udak nene, kilari tigo kitene kani nneu nin fizu nayi, tutun anit anan fizu naye na bolu nin likara. ");
INSERT INTO amo_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Bara vat anan liru nin nu Kutelle nin duka wa tizu amoro alau udakin Yuhana. ");
INSERT INTO amo_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Andi tutung iyina userun nin, ulele amere Iliya, urika na awadi unan dak. ");
INSERT INTO amo_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ame ulenge na adinin natuf nlanzu, na alanza. ");
INSERT INTO amo_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Inyaghari nma batu ko kuje mun? Imasin nonoari navu nkasa, alenge nasa iso iyica atimine. ");
INSERT INTO amo_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Inin woro, 'tidin wulsu fi fishira na udin yizunu ba. Tiyita tiyom ana ugila ba.' ");
INSERT INTO amo_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Bara Yuhana wadak, na awadi nli nimonli a aso nmyen narau ba iworo, 'adi nin kugbergenu.' ");
INSERT INTO amo_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Gono Kutelle wa dak, nli nimonli nin so nmyen narau iworu, 'Yeneng unan su kileu kikan, nin shituzu nso, udondong nanan sesun gandu nan nanan kulapi!' Ama njijing nse ubunku bara kata me.” ");
INSERT INTO amo_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yesu cizina ukpaduzu nigbiri nirika asuzu imon izikiki ku, bara iwa nari uni nati. ");
INSERT INTO amo_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ukaito fe Corazin! Ukaitofe Betsaida! Nfo katwa kadidya kane na nnasu kiti mine, nwansu Ntyra nin Sidon, iwa ni ati nworsu, icino alapi mine nanyan najasi nimon nin tong. ");
INSERT INTO amo_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Bara nani, uma katinu anan Sidon ku nin Tire liri nshara Kutelle. ");
INSERT INTO amo_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Anung u Kaparnahum, idin yenju ima ghatinu minu udu kitene kane? Na nanere ba, ima tultun minu udu ukul sa ligan. Bara andi Nsodom iwa su nita nididya nanga na ina su anung ku, uwa dutuku udak kitimone. ");
INSERT INTO amo_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Uma yitu sheu ni nmyin Nsodom lirin shara nbun mine. ");
INSERT INTO amo_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kubi kone, Yesu woro, “ndi rufi, Ucif, Cikilari unan kitene kani nin kutyin, bara una nyeshe ilenge imone kiti na jijin nin nanan yiru, tutung umini na pun kiti nalenge na iyiru ba, nafo ninono ni bebene. ");
INSERT INTO amo_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Aee Ucif, nanere una tifi mang nyenjufe. ");
INSERT INTO amo_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Vat nimon inani ununzu Ncif ning. Tutung na umong yiru Usaune ba se Ucife, ana umong yiru Ucife ba se Usaune, tutung nin lenge na Usaune nyina aduroghe ame. ");
INSERT INTO amo_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Dan kiti ning, vat anung ale na imin kutura kugetek, meng ma nimu ushinu. ");
INSERT INTO amo_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yaunang Kugbetu ning kiti mine imasu uyinnu kiti ning, bara ndi sheu nin kibinayi kimang, imanin se ushunu tilai mine. ");
INSERT INTO amo_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Bara kugbetu ning sheu a kutura ning di getek ba.” ");
INSERT INTO amo_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kubi kone na Yesu wa din cin nanya kunen nilarum liri na Sabbat. Kukpon da nono kadura me itunnan pucu nillarume nle. ");
INSERT INTO amo_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","A farisawa yene nani, iworo Yesu ku, “Yene nono katafe din su nimon ile na icaun isu liri na Sabar ba.” ");
INSERT INTO amo_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu woro nani, “Ikuna belu iyerti ile na iwa yertin nimon ile na Dauda wasu a, na kukpon wa daghe, nin nale na awa di naghinua? ");
INSERT INTO amo_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Na awa piru nanya kilari Kutelle, aleu imonli nanan katwa kilari Kutelle, ile na iserin nworu ali ba, nan nale na awadi nanghinu, ule na uduka wa nazaghe nin le, nin nalenge na iwa di ninghe wang, uduka wa naza nani nin le, Uduke wa yinnin a Priesta ku nin le nmang? ");
INSERT INTO amo_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Tutung na isa yene nanya neyert, au liri na Sabat a Priest din nanzu Asabate ana asa usonani kulapi ba? ");
INSERT INTO amo_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Bara nani meng belin minu, umong ulenge na na akatin kutii Kutelle di kikane. ");
INSERT INTO amo_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ndafo iyiru ilenge imone, 'Meng din pizuri nkunekune nayiari ana ma nakpizu nakpizu ba.' Na iwa ni anan sali kulapi kulapi ba. ");
INSERT INTO amo_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Nanere gononit ame Cikilari liri na Sabatari.” ");
INSERT INTO amo_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu suna kite udu nany kutii nlira mine. ");
INSERT INTO amo_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Kitene, umong uni wadduku, nin cara na una koto. A Farisawa tirino Yesu ku, i woro, “ Ucaun i shin nin mong liri na Sabata?” Bara inan se kulapi kiti me. ");
INSERT INTO amo_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu bele nani, ghari nanya mine, awadi nin kukam kurum, tutung kukam kone nnin deu nanya kuwu kucamcam liri na Sabat, na ama kifu kunin anutun ba? ");
INSERT INTO amo_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Bara nani, na unit katin kukam nin tigo kiti Kutelle ba! Nanere nta, ucaun isu imon icine liri n Sabat.” ");
INSERT INTO amo_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Yesu woro nnite, “Nakpa ucarafe,” unite nakpa ucare, utunna ushino, uso ucine nafo uleli ucare. ");
INSERT INTO amo_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","A Farisawa nuzu udas, itunna pizuru nimon ile na iba kifughe mun. Iwadin pizuru libau longo na iba ti imolughe. ");
INSERT INTO amo_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Na Yesu nyino nani, a wonno kidowo kusari kurum, anit gbardang dofinghe, a shizuno nani nin tikonu mine. ");
INSERT INTO amo_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Awunno nani atuf na iwa belin umong ba. ");
INSERT INTO amo_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Unan so kidegen, ilemon na iwa belin nnuun Ishaya unan liru nin nu Kutelle, nbellu, ");
INSERT INTO amo_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Yene, kucin ning urika na nna fere; kinayi ning, urika na kibanayi ning din lanzu nmang me. Nma ti uruhu ning nanya me, ame manin bellu ushara kiti nanan salin bi. ");
INSERT INTO amo_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Na ama fo kidowo ba, sa agilu nin liwui kang; na umong tutung ma lanzu liwui me libau libene ba. ");
INSERT INTO amo_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Na awasa apuro kugosin ndiru likara ba; kinni ncin tutung na ama molu ba, se anin nutuno ushara unnasara. ");
INSERT INTO amo_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Alumai tutung mase likara nanya lissame.” ");
INSERT INTO amo_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Kube itunna ida nin mon unit kitin Yesu unan niduu nin nituri, agbergenu wadi nanya me. Ashino ninghe, unit unan niture nin niduwe yinno ulira akuru atunna nyenju kiti. ");
INSERT INTO amo_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","vat ligozin nanit wa yatinju inin woro, “Sa ulelere ma yitu usaun Daude?” ");
INSERT INTO amo_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Na Farisawa nlaza uliru nimon izikiki ilele, iworo, “Na unit ulele din nutuzunu agbergenu ba se nin yinnun Belzubab, usaun ngo nagbergenu.” ");
INSERT INTO amo_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu wa yiru nin kpilizu mine aworo nani, “Vat tigo tongo na tidi nin nivira nin litime wulu, tutung kokame kagbiri sa kilari kanga na adi nivira nin liteme ma yisunu ba. ");
INSERT INTO amo_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Adi shitan din nutuzunu shitan ku, to adi nivira nin liteme. iyizari kipin tigo me ba yissunu? ");
INSERT INTO amo_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Adi tutung ndin nutuzunu agbergenu nin yinnun Belzubal, nin yinnun ghari anan dortu mine din nutuzunu nani? Bara nani, ima sominu anan mawucu-wucu. ");
INSERT INTO amo_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Adin tutun ndin nutuzunu nagbergenu nin Ruhu Kutelleri, to kipin tigo Kutelle nda nanya mine. ");
INSERT INTO amo_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Tutung iyizari unit ba piru kilari nnan nagang asu likiri nomon irika na adumun sa ucizunun teru nan nagaghe? Aning su likiri nimon nnite kilari me. ");
INSERT INTO amo_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ulenge na adi nin miba adi nivira nin mi, ulenge tutung na adin piture nin mi ba, unan musuzuri. ");
INSERT INTO amo_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Bara nani ndin bellu minu vat nalapi nin nanzu lissa iba kusu anit mun, ama unanzu lissan Ruhu na iba kusu ba. ");
INSERT INTO amo_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Tutung vat nlenge na abele nlon ligulang kitenen Nsaun nit, ilele ima kusughe mun. Ama vat nlenge naa abele uliru nivira nin Ruhu ulau, na iba kusu alele ba, na nle uyii ba, ana nyii ulenge na udin cinu wang ba. ");
INSERT INTO amo_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Sa ukyele kuca gegeme a iburi me yita gegeme, sa kyele kuce nanzang a iburi kuni yita nanzang. ");
INSERT INTO amo_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Anung nono nabuni, tunda na idi nin likara lifacak, iba bellu imon icine nyizari? Bara unuzu nanya adadu liburari asa unu lira. ");
INSERT INTO amo_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Unit ulau unuzu filai kibinayi me asa anutuno imon icine, unit unan likara lifacak tutung unuzu filai kibinayi me asa anutuno ileli imon na idi facak. ");
INSERT INTO amo_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ndin bellu minu tutung, lirin shara, anit mani litul vat nliru unanzang ule na ina bellu. ");
INSERT INTO amo_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Bara nanya nliru minere ima se ucinu, nanya nliru minere tutung ibase uteru. ");
INSERT INTO amo_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Among anan niyerti nin na Farisawa kawa Yesu ku iworo, “Unan dursuzu, tidi ninsu tuyene kulap unuzu kitife.” ");
INSERT INTO amo_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesu kawa aworo nani, “Aji likara linanzang nin nanan funu din pizuru kulap. Ama na nkon kulap duku na iba ninani ba se kun Yunana unan liru nin nu Kutelle. ");
INSERT INTO amo_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Bara Yunana wati ayiri atat nin nitik nitat nanya liburi fibo, nanere wang Usaun nnit bati ayiri atat nin nitik nitat kibinayi nyii. ");
INSERT INTO amo_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Anitin Ninivi ma yissunu kitin shara ninko kuji nanite, iba ti uteru nani. Bara iwa sun alapi mine nin lirun kpaduzun Yunana, manin yenen, umong nbun nin Yunana di kikane. ");
INSERT INTO amo_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ushono ngo kusarin nlime ma fitu liri nshara nin nanit nko kuje ati itere nani. Awa dak unuzu ligan nyii anan da lanza ubelen njijin Solomon, manin yeneng, umong nbun Solomon di kikane. ");
INSERT INTO amo_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Asa uruhu unanzanghe nnuzu nanya nnit, asa ukatiza nitin salin nmyen npiziru shinu, adi na ase ba. ");
INSERT INTO amo_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Asa aworo, 'nma kpilu kilari ning na nna nuzu ku.' Adi a kpilla, ase kilari kane ikuzu kinin inin ceu kinin lau. ");
INSERT INTO amo_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Amanin kpillu adi yiru ligowe ninghe nton tiruhu tinanzang tining kuzor na ti katinghe nin magunta, iba nin dak vat inin daso kikane. Ngisin lissosin nlele unite makatinu lin burne nin nanzang. Nanere bayitu nin ko kuje.” ");
INSERT INTO amo_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Na Yesu wa dutu nliru nin ligozine, uname nin nuwname tunna iyisina ndas, iwa di npizuru nwo ilirin ninghe. ");
INSERT INTO amo_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Umong woroghe, “Yene, unafe nin nuwnafine yissin ndas, idin pizuru nwo ilirin ninfi.” ");
INSERT INTO amo_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu kawa aworo nani ulenge na abellinghe, “Ghari unanin? Ayagha tutung nuwna nin?” ");
INSERT INTO amo_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Atunna a nakpa ucara me udu kitin nono katwa me aworo, “Yene, kikane unaning nin nuwna ning! ");
INSERT INTO amo_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Bara vat nlenge na adin su imon kibinai Ncif ulenge na adi kitene kani, uleli unitere gwana ning kilime, nin kishono, a unaning.” ");
INSERT INTO amo_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Lilonne Yesu wa nuzu nanya kilari ado adi so nbiu kurawa. ");
INSERT INTO amo_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ligozi nanit gbardang da pitirino kitime, afita a pira nanya njirigi mmeyen a so ku; vat ligozie yissina licicin nbiyu kurawe. ");
INSERT INTO amo_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yesue bele nani iuliru bardang nin tinan tigoldo. A woro, “Yenen unan tibila wa nuzu tibila. ");
INSERT INTO amo_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Da na a bilisa, imon imus disso likot libau, anyin tolo da ida leo inin. ");
INSERT INTO amo_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Imon disso nanya napparang, kika na ise mmin ku gbardang ba. Na nin molu kubi ba inuzu, bara na mmine wadi pit ba. ");
INSERT INTO amo_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Da na uwui nghana, ilo bara na iwa dinin tiling ba, itunna ikoto. ");
INSERT INTO amo_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Imon imus disso nan nya nimart. Aca imarte kunjo i parda ining. ");
INSERT INTO amo_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Imong imus disso mmin micine itaa iyip. Imong nkoli akalt akalt imong akut kutocin, a imong atat. ");
INSERT INTO amo_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ame ule na adi nin na tuf na a lanza. ");
INSERT INTO amo_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nono katwawe da ida woro Yesu ku, “Iyanghari nda usu anite uliru nin tinan tigoldo?” ");
INSERT INTO amo_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu kawa a woro nani, “Anung ina ni minu uyinnu nworu iyinin imon izikiki kipin tigo kitene kani, amma kiti mine na ina nani ba. ");
INSERT INTO amo_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Bara kiti lenge na adimun, amere ima kpinghe ku, tutung ama nin yitu mun gbardang. Amma ame ulenge na a salin mu, kitime ima seru i cingilinghe na adi mune. ");
INSERT INTO amo_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Bara nani ndin su uliru nan ghinu nin tinan tigoldo, vat nin yenju mine, na idin yenju gegeme ba, vat nin lanzu mine, na idin lanzu gegeme ba, ana idin yinnuzu ba. ");
INSERT INTO amo_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Kiti mine anabcin Ishaya na kulo, ale na ana woro, 'Nanyan lanzu, ima lanzu, amma nanyan ko lome libo na ima yinnu ba. Nanyan yenju ima yenu, ama nanyan ko lome libo na ima se uyinnu ba. ");
INSERT INTO amo_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Bara nibinai nanit alele na ti gotek, atuf mine ani nati getek nlanzue, iyizi mine ina tursu inin, Nsa nani ba se uyinnu nin niyizi mine, lanza nin na tuf mine se uyinnu ni nibinai minee, inin se utpillu tutung, meng ma ni nani ushinu.' ");
INSERT INTO amo_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Amma imong koliari iyizi mine; idin yenju nin natuf mine, adin lanzu. ");
INSERT INTO amo_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kidegenere ndin belu minu, a anbawa gbardang nin na nan katwa kacine npizira iyene imon ile na idin yenju, amma na ina yene a, na yita nin su ilanza imon ile na ina lanza, amma na ina lanza ba. ");
INSERT INTO amo_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","To lanzan tinan tigoldo nnan tibuk. ");
INSERT INTO amo_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Asa umong nlanza uliru kipin tigowe ana a yinno ba, ame kugbergenuere nda kuda bolo imon ile na ina bilisu nanya me. Amere ulenge na iwa bilsu ghe libo. ");
INSERT INTO amo_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ame ulenge na iwa bilisu ghe napzmbara amere ulenge na awa seru uliru nin liburi libo dedei. ");
INSERT INTO amo_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Vat nani na adi nin tiling tin liti me ba, amma awa yissin gangang nin kabiri bat. na uniu nin gbagba wa dak bara uliru ntucue, awa diu dedei. ");
INSERT INTO amo_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ame ulenge na iwa bili ghe nanya nimart, amere ulenge na awa lanza ulirue, amma adadu in yii nin karusuzo nimon in yii, ma pardu ulirue, ama so sa kumat. ");
INSERT INTO amo_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ame ulenge na iwa bili ghemmin micine, amere ulenge na alanza ulirue amimin yinno unin, anere ulenge na a macca nono a pitirino ni nin bara kidegene; imon nkoli akalt akalt, imong akut akut kutocin, a imong akut atat.” ");
INSERT INTO amo_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu kuru a belle nani umon uliru nin tinan tigoldo. Aworo, “Kipin tigo Kutelle masin nafo unit ule na abilisa imus kine kunen me. ");
INSERT INTO amo_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Nin kitik na anit ndo nmoro, udon nivira me da ada bilisa kunya nileli imusse nanya kunene, anya udughe. ");
INSERT INTO amo_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Na i nuzu i kuno ita iyip, inin kunyawe wang nutuno ati. ");
INSERT INTO amo_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nono katwa nnan kunene da ida woroghe, 'Cikilari, na imus in alkamari uwa bilisu kunen fe ba? Iyiziari nta amamu ketilin ku?' ");
INSERT INTO amo_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","A woro nani, 'Unan nivirari nasu nani.' Nono katwa wwe worooghhe nenge, 'Udi nin su ti do tidi dussu anina?' ");
INSERT INTO amo_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Unan kunene woro, 'Nanere ba, iwa na do ndussu na manue, ima dussu alkame ligowe nin na mamue. ");
INSERT INTO amo_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Na vat mine kunjo ligowe uduru kubin pitiru kiti. Kubi npitiru kiti mma woru anan pitiroe, “Tun kalizan amamue itecu agum agum, idi juju, amma pitirinon alkane udu filai nighe.”'” ");
INSERT INTO amo_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu kuru ana nanii umoon uliru nin tinan tigoldoe. A woro, “Kipin tigo Kutelle masin nafo fimus kuca kukuu na unit in yira a bila nan nya kunenme. ");
INSERT INTO amo_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Fimus fonee finare fi bene nanya nimu vat. Amma uwa bilu fining fi kuno, ku katin vat naca nanya kunene asa kuta kuca kudya, asa anyin kitene kani da ida kye tido mine tilanghe.” ");
INSERT INTO amo_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu kuru a belle nani nton tinan tigoldo aworo, “Kipin tigo Kutelle masin nafo uyist ule na uwani nwa yiru a munu nanya nbulung ayangi atat asa mite hogogo mi ghana.” ");
INSERT INTO amo_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Vat ni lenge imone Yesu wa belu ligozi nanite nin tinan tigoldo. Andi na nin tinan tigoldo ba na awa belin nani imon ba. ");
INSERT INTO amo_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Uwa so nani bara vat nimon ile na iwa belin kiti nanan liru nin nuu Kutelle nan so kidegen, na iwa woro, “Mma punu unu ning nin tinan tigoldo. Mma bellu imon ile na inyeshin uworsu kubi ncizunu nkye in yii.” ");
INSERT INTO amo_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yessu suna ligozi nanite a pira nan nya kilari. Nono katwa me da kiti me iworo, “Durso nari tinan tigoldo kunyua kunene.” ");
INSERT INTO amo_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu kawa a woro, “Ame ulenge na a bilisa inus in alkama Usaun Nnitari. ");
INSERT INTO amo_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kunene uyii ulelere; a imus in alkama inughere nono kipin tigowe. Amamue annare nono nnan katwa kananzanghari, ");
INSERT INTO amo_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","a unan nivire na ana bilisu inin kugbergenuari upitiru kiti unare imalin in yii, a anan pitiru kiti unare imalin in yii, a anan pitiru kiti inughere nono kadura Kutelle. ");
INSERT INTO amo_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Nafo na iwa pitirin amamue ijuju nanyan nla, nanere una so kubi nimalin in yii. ");
INSERT INTO amo_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Usaun Nit ma tu nono katwa me, ima du idi pitirin imon vat na idi tizzu anit utazuna, nin na lenge na ina su nitwa ni nanzang. ");
INSERT INTO amo_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ima ta nani nan nya nla ugbagbai, kikanga na kuculu ma yitu ku nin nyaku nayini. ");
INSERT INTO amo_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Inung anan katwa kacine ma nin waltu nanya kipin tigo Ncif mine. Ame ulenge na adi nin natuf na alanza. ");
INSERT INTO amo_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Kipin tigo Kutelle masin nafo utamani na unyeshin nanya kunen. Unit wase unin a nyeshe unin. Nanya liburi libo me anya, adi lewu vat nimon ile na adi mun, a sere kunen kone. ");
INSERT INTO amo_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Tutung kipin tigo Kutelle masin nafo unit na adi kupatiki adin piziru filu'ulu'u icine kujama me. ");
INSERT INTO amo_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Na ase filu'ulu'u fi gegeme fin nikurfun idya, awa nya adi lewu nimon me vat a sere finin. ");
INSERT INTO amo_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Tutung kipin tigo Kutelle masin ukuma na iwa bworin nanya kurawa, a kifizo inawa mmyen ngangang ");
INSERT INTO amo_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Na uwa kulo, unan kifizu nibowe wunno unin likot udu ubiwu kurawe. ima nin so iferu inawa icine iti nanya nakuzung, amma imon i nanzaghhe ima fillu ining. ");
INSERT INTO amo_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nanere uma yitu nin nayiri nimalin inyii. Nono kadura Kutelle ma dak ida feru anan katwa kananzaghe nanya na nan katwa kacine. ");
INSERT INTO amo_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ima nin tu nani nanya nla unoiwu ugbagbai, kikanga na kuculu ima yitu ku nin nya ku nayini. ");
INSERT INTO amo_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Iyinno ile imone vatta?” Nono katwa we woro ghe, “Tiyinno.” ");
INSERT INTO amo_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yesu tunna aworo nani, “Nanere vatt nnan ninyerte na alawa gono katwa kipin tigo Kutelle a massin nafo unit ulenge na adi nin kilari, na a kaliza imon ikisse nin nipesse nan nya filai me.” ");
INSERT INTO amo_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Kube da na Yesu nmala tinan tigoldo tone, anya asuna kiti kane. ");
INSERT INTO amo_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Yesu nya a pira nanya mmin me a tunna ndursuzu nanite nanya kutyi nlira, na ilanza fiu kifo nani i woro, “Unit ulele nse ule uyirue nin nimon izikiki ilele nweri? ");
INSERT INTO amo_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Na unit ulele usaun nnan kye nibulung unereba? Na unamere Maryamu ba? Na nwana nilime mere an Yakubu, Yusufu, Simon a Yahuda ba? ");
INSERT INTO amo_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Na nwana nishono mere vat di ligowe nan ghiruk kakane ba? Ani unit ulele nase ile imone vat nweri?” ");
INSERT INTO amo_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Iwa lanza ayi ninghe. Amma Yesu woro nani, “Na annabi diu diru ngongong ba se mmyin me nin na nan ngame.” ");
INSERT INTO amo_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","A na awa tizzu imon izikiki gbardang kikane ba bara udiru in yinnu mine. ");
INSERT INTO amo_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nanya kubi kone, Firauna lanza ubeleng Yesu. ");
INSERT INTO amo_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Aworo nono katwa kilari me, “Ulele Yohanna unan shintuzunu nanit mmyena; ana fita nanya na nan kule. Unnare nta adi nin na kara nsu nna nitwawe.” ");
INSERT INTO amo_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Hiridus wa kifo Yohanna ku, a tere gbe, a ceo ghe nanya kilari licin bara Herodiya, uwani ngwana me Filibus. ");
INSERT INTO amo_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Bara Yohanna wa belinghe, “Na uma caunu ba uyiru ghenafo uwani fe.” ");
INSERT INTO amo_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hiridus wa molu ghe, ama awa lanza fiu nanit bara iwa yirughe nafo unan liru nin nuu Kutelle. ");
INSERT INTO amo_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Na lirin marun Hiridus wa kuru likeo lida, ushonon Herodiya su avu kiyitik nanit a puo Hiridus ku ayi. ");
INSERT INTO amo_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ame wang poa ghe ayi, a ceo ghe uliru nin nisilin nworu vat nimon ile na atiringhe ama nighe. ");
INSERT INTO amo_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Na unene ndi kyeghe ulirue, a woro, “Nai kikane, kukurum, litin Yohanna unan shintu nanit mmyen.” ");
INSERT INTO amo_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ugowe ayi ine wa fita kan nin tirinu me, amma bara isiling me, tutung bara alenge na iwa di lni nimonle vat ninghe, ato idi so nani. ");
INSERT INTO amo_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","A to idi werin litin Yohanna nanya kilari licine. ");
INSERT INTO amo_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Itunna ida nnun lite nanya kukurum ina kubure ina kubure ado adi ni uanme. ");
INSERT INTO amo_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Nono katwa me tunna ida, iyira libie, idi kassu linin. Kimal nani, ido idi bellin Yesu ku. ");
INSERT INTO amo_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Na Yesu nlanza nani, ama suna kitene nanya nzirgin mmyen ado nkankiti likot. Na ligozi nanite nlanza nani, i nuccu nipiin pin mine nin nabunu i dofinghe. ");
INSERT INTO amo_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu yunna ada ubun mine a yene ligozi nanit. Alanza nkune kunemine a shizino nin na nan tikonu mine. ");
INSERT INTO amo_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Na kuleleng nta, nono katwa we da kitime i woro, “Kiti kane di nin nanit ba, tutun kuleleng nta. Suna anite inya, inan se iducu nanya nigbiri idi sesu atimine imonliku.” ");
INSERT INTO amo_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","amma Yesu woro nani, “Na ucaun inya ba. Anung nan nani imonmong ili.” ");
INSERT INTO amo_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","I woroghe nenge, “Kikane tidi nin fungal utaunari cas nin nibo iba.” ");
INSERT INTO amo_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu woro nani, “Dan nani inin.” ");
INSERT INTO amo_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Yesu woro ligozi nanite isozo nkpi kutyene. A yauna ufungal utaume nin nibo ibe, a yene kitene Kutelle, ata nkoli ku apuco unin anin na nono katwa we unin, nono katwa we ani wani ligozi nanite unin. ");
INSERT INTO amo_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Iwa li vat ishitizo. Inani wa pitiru ngissin nimon ile na iwa nazu nfungale nin nibowe-akuzun likure tinap gbem gbem. ");
INSERT INTO amo_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Alenge na iwa li wa di nafo nanilime amui ataun, kimal na wani nin nono. ");
INSERT INTO amo_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ata nono katwa we ipira nanya nzirga mmyen i kafina uleli uwul kurawe, ame nin man ti ligozi nanit inya. ");
INSERT INTO amo_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kimal na ata anitee inya, aghana kitene likup ussan me adi ti nlira. Na kulelen nta kang, awa lawa kitene ussan me. ");
INSERT INTO amo_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Amma kubi uzirgi mmyene wa yita kiyitik kurawe, iwa nin pya kang nin lin nin zirge bara fibark mmyene nin furu na uwa kurtuzun nani. ");
INSERT INTO amo_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nin nikoro inas nin kiyitik Yesu da kitimine, awa din cin kitene mmyene. ");
INSERT INTO amo_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Na nono katwa we in yene ghe adin cinu kitene mmyene, ilanza fiu i woro, “Ilele mmolyari,” Itunna in tizun tet bara fiu. ");
INSERT INTO amo_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Yesu tunna a lirina nan ghinu a woro, “Tan ayi akone! Menghari! Na iwa lanza fiu ba.” ");
INSERT INTO amo_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Bitrus kawa ghe aworo, “Cikilar, andi fere, ta meng ku ndak kitife nin cin kitene mmyene.” ");
INSERT INTO amo_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu woroghe, “Da.” Bitrus tunna anuzu nanya nzirge acina kitene mmyene ucin du kitin Yesu. ");
INSERT INTO amo_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Amma na Bitrus in yene ufunu, fiu kifoghe. Na a cizina upicu nan nya mmynenen a ta kuculu a woro, “Cikilari, tucui.” ");
INSERT INTO amo_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Yesu tanna anakpa ucara me mas, a kifo Bitrus ku, a woroghe neng, “Fe unan yinnu sa uyenu bat. Iyaghari nta umini a jirjir?” ");
INSERT INTO amo_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Na Yesu nin Bitrus npira uzirge, ufunue yissina. ");
INSERT INTO amo_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Nono katwa we nanyan zirgin mmyene su Yesu ku usujada, iworo, “Kidegenere fe usaun Kutelleari.” ");
INSERT INTO amo_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Na ikaffina uleli uwul kurawe, i tolon Janisarata. ");
INSERT INTO amo_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Na anit kiti kane in yinno Yesu ku, isa kadura udu nigbiri nanga na kilin nani, idi pilu anan ti kunu vat ida mun kiti me. ");
INSERT INTO amo_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","I foghe acara nworu na ise idu do kulada kulutuk me cas, vat ngbardang nanit alenge na iwa dudo kunin wa se ushinu. ");
INSERT INTO amo_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Among a Farisawa nin na nan ninyerte ds kitin Yesu in Urushalima. I woro, ");
INSERT INTO amo_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Iyaghari nta nono katwa fe din nanzu utandu na kune? Bara na idin kuzu acara mine ba andi ima li imonli.” ");
INSERT INTO amo_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu kawa a woro nani, “Anung wang-iyanghari ntaa idin patulu uduka Kutelle bara utanda mine? ");
INSERT INTO amo_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Bara Kutelle na woro, 'Ta ucife nin na fine ku gongong,' tutung, 'Ame ulenge na ashu uliru unanzang liti ncife sa nna me, Kidegene aba ku.' ");
INSERT INTO amo_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Amma anung ani na woro, 'Vat nlenge na a woro ncif me sa uname, “Vat ubuunu ulenge, na una seru kiti ning nene ufilluari udu kiti Kutelle,”' ");
INSERT INTO amo_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","na unit une caun ati ucife gongong ba. Nanya nloli libowe unanza uliru Kutelle bara utanda mine. ");
INSERT INTO amo_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Anun an rusuzu nati, gegememiari Ishaya na liru nin nuu Kutelle nati mine na awa woro, ");
INSERT INTO amo_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","'Anit alele din tizui gongong nin nakpa tinuu minere, amma nibinai mine di pit nin mi. ");
INSERT INTO amo_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Idin su usujada lemmari, amma idin dursuzu adadu nduka nanittari. ");
INSERT INTO amo_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Atunna ayicila ligozi nanite udak kitime a woro nani, “Lanzang iyinin- ");
INSERT INTO amo_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Na imon mong diku na asa ipira unuu din nanza unit ba. Amma imong ilenge na inuzu nnuu nnit nnare din nanzu unit.” ");
INSERT INTO amo_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nono katwa we dak ida woro Yesu ku, “Uyiru nworu Afarisawa nin nana ayi na ini lanza uliru une?” ");
INSERT INTO amo_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu wa kwan a woro, “Vat kuca kongo na Ucif nighari nbila ba iba dusulu kunin. ");
INSERT INTO amo_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Sunan nani usan min, anan durusuzu nanitari liboo amma aduu. Asa unit uduu nwanno uduu Liboo vat mine ma di diu nanya kuu.” ");
INSERT INTO amo_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Bitrus kawa aworo Yesu ku, “Durso nari tinan tigoldo tone.” ");
INSERT INTO amo_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu woro, “Anung wang duusa uyirue? ");
INSERT INTO amo_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Na uyene nworu vat nimon ile na ipira nanya nnu maadi katu udu nanya kiti npunju ba? ");
INSERT INTO amo_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Amma imon ile na inuzu nnuu ida unuzu kibinaiyari innare imon ile na idin nanzu unit. ");
INSERT INTO amo_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Bara unuzu nanya kibinaiyari ukpilizu unanzang din nucu ku, umolsu nanit, upiziru nawani, kaput ndinong, likiri, ushaida kinnu, nin tizogo. ");
INSERT INTO amo_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ile imonere din nanzu unit. Amma uli nimonli sa utusu nacara din nanzu unit ba.” ");
INSERT INTO amo_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu nya kikane ado kusarin Taya nin Sida. ");
INSERT INTO amo_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Umong uwani na Kananiyawa nuzu kusari kone. A ta ntet a woro, “Lanza nkunekune nighe, Cikilari, usaun Dauda; ushono nin din sonu ngbada bara kugbergenu.” ");
INSERT INTO amo_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Amma na Yesu nworo iyang ba. Nono katwa me da ida foghe acara, i woroghe, “Woroghe anyaa bara adin gbejullu kang kidung bite.” ");
INSERT INTO amo_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Amma Yesu kawa nani aworo, “Na ina tuuyi kitin mon ba se kiti nakam uwulusu nnonon Israila.” ");
INSERT INTO amo_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Amma ada ubun me a tumuno, aworo, “Cikilari, buuni.” ");
INSERT INTO amo_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Akawa aworo, “Na ucaun i yiru imonli nnono ini nono ninau ba.” ");
INSERT INTO amo_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","A woro, “Nanere, Cikilari, amma nono ninuawe asa ileo ibure na asa disso kitene kutebul ncikilari mine.” ");
INSERT INTO amo_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yesu kawa aworoghe, “Uwani, uyinna sa uyenu udyawari, na isu fi nafo nafe di nin suu we.” Ushonoe uni wa tannun ashino kubi kone. ");
INSERT INTO amo_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu uni wasun kiti kane anya udu kupo kurawan Galili. Amini wa ghana likup adi so ku. ");
INSERT INTO amo_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ligozi nanit gbardang daa kitime. Iwa dak nan ghinu anan kentu, aduu, aturi nin na nan salin nabunu, nan na mong gbardang na iwa di nin tikonu. Ina ni wa ceo nani nabunun Yesu amini wa shin nin ghinu vat. ");
INSERT INTO amo_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ligozi nanite ani fiu wa kifo nani na iwa yene unan sali nabunu nshino, unan kentu din cin, uturi din liru a uduuin yenju kiti. Iwa zazin Kutellen Israila. ");
INSERT INTO amo_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Yesu wa yicila nono katwa me kiti me aworo, “Nlanza nkunekune lipitin nanite, idi ligowe nan mi ayiri atat na idi nin nimonmon na ima li ba. Na idi nin su nworo nani inyaa sa uli nimon ba, Iwa dissu liboo bara kukpong.” ");
INSERT INTO amo_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nono katwa we woro ghe, “Tima se ufungal gbardang nweri kikanee na anit diku ba ubatin ligozin nanit alengen vat?” ");
INSERT INTO amo_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu woro nani, “Ufungal umashiniari idi mun?” Iworo, “Kuzor nin nibo ibebene cin.” ");
INSERT INTO amo_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Yesu woro ligozin isozo kutyin. ");
INSERT INTO amo_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","A yauna ufungal kuzor nin nibowe, na ataa nliraa, apuco ufungalle ana nono katwa we. Nono katwa we naa ligozi nanite. ");
INSERT INTO amo_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Anite vat leo ishitizo. Ipitirino agissin niburi nimonle na ileo, ikulo akuzun kuzor. ");
INSERT INTO amo_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Alenge na iwa li wadi amui anas banin nawani nin nono. ");
INSERT INTO amo_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Yesu woro ligozi nanite inyaa, ame doo adi piru nanya nzirgi mmyen anyaa udu kusari Magadan. ");
INSERT INTO amo_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","A Farisiyawa nan na Sadukiyawa daa kitime idin tirughe in an dumunghe a duro nani kulap nnuzu kitene kani. ");
INSERT INTO amo_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Bara nani a kawa a woro nani, “Na kuleleng ntaa, uworo, 'Kefe mayitu ugang, bara awuten nshaa.' ");
INSERT INTO amo_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Nin kuyi dindin uworo, 'Kite ma cauna kang kitimone, bara na awuten nshaa.' I yiru ubelu nalu ile ketene kane, bara na iwasa iyino ubelu kulap kube ba. ");
INSERT INTO amo_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kuji kunanzan kun zino din pizirun uyine nkon kulap ba banin kun Yunana.” Yesu nin nyaa a suna nane. ");
INSERT INTO amo_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nono katwa me kafina udu uleli ugau kurawe, Ishawa uyirun mborodi. ");
INSERT INTO amo_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu woro nani, “Sunseng nin na Farisiyawa nan na Sandukiyawa.” ");
INSERT INTO amo_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nono katwa nighe kpiliza nibinai mene i woro, bara na ti yira uberadi ba.” ");
INSERT INTO amo_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Yesu wa yeru nani a woro, “Anung ana yenu sa uyenu ucin, iyanin ta idin Kpiilizu nati mene au na iyira uborodiari ba? ");
INSERT INTO amo_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Na isa lizino sa itoo iyizi na gi nborodi ataun na anit amoi ataun wa li ba, a kagisine amashinara i wa piriru? ");
INSERT INTO amo_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Sa agir kuzure na anit amoi anas wa li, akuzeng amashinari walawa? ");
INSERT INTO amo_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Iyarin nta na iyino au inwadin beleminu ubelen mborodiari ba? Sun seng nin na Farisiyawa nan na Sadukiyawa.” ");
INSERT INTO amo_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Inin yino na awadin belenani uboleng inyeast mborodiari ba, bara u madursuzu na Farisiyawa nin na Sadukiyawa. ");
INSERT INTO amo_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nene na Yesu waa dak nlong likotin Kasiriya nFilipi, atiro nono katwa me, aworo, “Nyari anit din yicu Gonon nit?” ");
INSERT INTO amo_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","I woro, “Anung woro Yohanna unan shitu; among, Ilaisha; among woro, Irimiya, among woro unang liru nin nuu Kutelleari.” ");
INSERT INTO amo_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","A woro nani, “Bara nani anung din su meng ghari?” ");
INSERT INTO amo_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Na akawa, Simon Bitrus woro, “Fere Kristi, Gono Kutelle unang nlai.” ");
INSERT INTO amo_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yesu kawa a woroghe, “Fe unang mariari, Simon usaun nYunana, nmii nin kidow was a durofi ilele ba, Ucif nighe na adi kitene kauri amere ndurofi. ");
INSERT INTO amo_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nkuru mbelenfi fere Bitrus kitene litala lole mma kye kutii nlira. Ni bulun kuwunun nkull wasa ni wantina ba. ");
INSERT INTO amo_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mba nifi mabudi kilari tigo kitene kani. Vat nimon ile na itere nyii imateru kitene kane, vat nimon iile na ibuku nyii iba bunku kitene kani.” ");
INSERT INTO amo_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Yesu benle nono katwa me nin likara au na iwa belin umong amere Kristi ba. ");
INSERT INTO amo_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nnuzu kubi kone Yesu woro nono katwa me a ma nyiu adoo Urushalima, ama niu kang nacaran nakunen ntardun nacara kutii nlira, nin nadidya kutii nlira, aa amon ninyert, Ima molughe, ama nin fitu liri lin tate. ");
INSERT INTO amo_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Bitrus yicilaghe likoot akpadaghe, abenle, “Cikilari ulele di piit nin fi; na ulele nwa sefi ba.” ");
INSERT INTO amo_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesu gifirino aworo Bitrus ku, “Kpilla kimal nin shetan! Fe litalan ntirzuwari kiti ni, na myen fe duku nin nimon Kutelle ba, bara imon na nit.” ");
INSERT INTO amo_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Yesu tunna a belle nono katwa me, “Vat urika na adinin su adofini, se ata umusu litime, ayauna kucan kotinu me, anin dofini. ");
INSERT INTO amo_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Bara vat urika na adinin su aceu ulai me ama diru uni, vat tutung ulenge na a adira ulai me bara meng ama se uning. ");
INSERT INTO amo_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Iyaghari ba kpinu unit ku, awa se vat nye anin dira ulai me? Iyaghari unit ba su kusere nlai me muna? ");
INSERT INTO amo_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Bara Gonon Nnit ba dak nan nya ngongon ncif me nan nono kadura me. Ama nin nni koghaku nafo nile imon na anasu. ");
INSERT INTO amo_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Kidegen meng bellin munu, among duku nan nya mine allenge na iyisin kikane, na iba dudu ukul ba, iba yenu Gono Nnit ncinu nanya tigo me.” ");
INSERT INTO amo_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ayiri kutocin wa kata, Yisa yira Bitrus ku nin Yakubu a Yuhanna gwana me, ada ninghinu kitene likup lizalang inung litiime. ");
INSERT INTO amo_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Atunna asaka ukama nbun mine. Umuro me balta naffo uwui, kulutuk me ta kanag nafo nkanag. ");
INSERT INTO amo_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Na nin nanzu kubi ba Musa nin Iliya nuzu ilira nan ghe. ");
INSERT INTO amo_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Bitrus kawa aworo Yisa ku, “Cikilari, ucaun na arike di kikane. Andi uyinna, meng ba ke adanga atat kurum kunfe, kurum kun Musa, a kurum kun Iliya.” ");
INSERT INTO amo_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Kubi ko na awa di nlirua na nin nanzu kubi ba kuwut nuzu ku kanag da ta nani ushin, na nin molu kubi ba liwui nuzu nan nya kuwut, aworo, “Kanere Gono kin nayi nighe, ulle na ndin nlatizu nmang me lanzan ghe.” ");
INSERT INTO amo_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Na nono katuwa me nlanza nani, ideo nin timuro mine kutyin, iwa di nlanzu fiu. ");
INSERT INTO amo_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ame Yisa da ada duduzo nani a woro, “Fitan yenje iwa lanza fiu.” ");
INSERT INTO amo_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Inug yene kitene kani, na iyene umon ba, Yisa ari cas wa duku. ");
INSERT INTO amo_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Na iwa kpilin unuzu kitene likupe, Yiisa kpada nani aworo, “Na iwa bellin alle amore kitin nmon ba, udu kubi ko na Usaun Nnit ba fitu nan nya nkul.” ");
INSERT INTO amo_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Nono katuwa me tiringhe iworo, “Iyaghari wati anan ninyerte wa woro Iliya ma burnu adak?” ");
INSERT INTO amo_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yisa kauwa a woro nani, “Iliya badak ada kurtunu imon vat.” ");
INSERT INTO amo_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nene meng bellin minu, Iliya namalu udak, na iyininghe ba. Nin nani, iwa a sughe vat nimon ille na idinin suwe. Nanya libau lirume, Gono Nnit ba niu nacara mine.” ");
INSERT INTO amo_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Inug nono katuwa me, yinno adin nliru nanghinu kitene Yuhanna unan Baptismari. ");
INSERT INTO amo_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Na ikpilla kiti ligozine, umon unit da kitime, ada tumuno nbun me, anin woro, ");
INSERT INTO amo_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Cikilari, lanza nkune kune ngono nighe, bara adinin nkonu matirizi, adin nniu mun kang, kubi-kubi asa adiso nlah sa nmyen. ");
INSERT INTO amo_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Meng da ninghe kitin nono katuwa fe, na iyinno ushinu ninghe ba.” ");
INSERT INTO amo_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yisa kauwa a woro, “Anan salin nyinnu nin kuji kunanzang, udu kome kubiari mba so nanghinua? Udu kome kubiari mba nonku kibinai ninghinua? Dan ninghe kiti nig kika.” ");
INSERT INTO amo_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Yisa kpada ghe, Kugbergenue nuzu nan nya me, kwanyane shino nkone kube. ");
INSERT INTO amo_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Nani nono katuwa da kiti Yisa kusari kurum i woro, “Iyaghari ntah na arik nyinnno nutunghe ba?” ");
INSERT INTO amo_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yisa belle nani, “Bara ncingilin nyinnu sa uyenu mine. Kidegen ndin bellu minu, asa idinin yinnu sa uyenu cing nafo fiyip fikan Imustard, uwasa ubelle likup lole, 'kalla litiife kikane udo kanie,' aba du nin litime, na imomon ba yitu munu nin nijasi nsu ba. ");
INSERT INTO amo_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Vat nani imus nale agbergenu wasa inuzu nani cas ba, se ligowe nin lira a ukifu nnu.” ");
INSERT INTO amo_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Kube na iwa sosin Galili, Yisa belle nono katuwa me, “Iba ni gono nnit nacara nanit. ");
INSERT INTO amo_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Inug ba molughe, nan nya liri lintat aba fitu.” Ayi nana nono katuwa me nani yototo. ");
INSERT INTO amo_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Na ida Ukafarnahum, annit alenge na iwadi imal sesu kagisin fishekel nafo ugandu, da kitii Bitrus a woroghe, “Na unan yirru mine din nizu kagisin nishekel ngandu ba?” ");
INSERT INTO amo_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","A woroghe, “Nanere.” Da na Bitrus npira nan nya kilari, Yisa cizina uliru ninghe aworo, “Iyaghari udin kpilize, Simon? Ago inyi, kitinghari idin sesu ugandu kuwa? Kiti nanit minere sa kiti namara?” ");
INSERT INTO amo_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Na Bitrus nworo, “Kiti namarari,” Yisa bellinghe, “Ikala anit mine nbiuze. ");
INSERT INTO amo_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Na tiwa ti nani anan sesu ngandu isu kulapi ba, cang kulli kudia, to liwita fe nanye, uwunun fibo fo na fi burno udake. Asa upuno unu finin uba se fishekel ku, yira finin udi ni anan sesun unani ni unfe.” ");
INSERT INTO amo_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nanya kubi kurume nono katwa me da kitin Yisa iworo ghe, “Ghari udiawe nanya kipin tigo Kutellẹ?” ");
INSERT INTO amo_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Yisa yicila gono kibene adak kitime, ayisa ghe kiyitik mine, ");
INSERT INTO amo_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","anin woro, “Kidegene ndin belle munu se anung nsuna alapi mine iso nafo nono nibebene, anung ghe nan nya nkolome libau na iwasa ise upiru kipin tigo Kutellẹ ba. ");
INSERT INTO amo_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Bara nani vat ulle na a toltuno litime nafo gono, kibene kane unit une amere udiawe nan nya kipin tigo Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nin ullenge na asere nkang gono kibene nan nya lisa nighe, asere mereku. ");
INSERT INTO amo_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Vat nle na ata warum nan nya nibebene nane na iyinna nin mi, ita kulapi, uba katinghe iyaun litala lidia iterighe nto, inin turunghe nan nya kuli kudia kiti kicacam. ");
INSERT INTO amo_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kash udu uyi bara kubin ntirzuari! bara uso doleari kubi kone ba dak bara ame! ");
INSERT INTO amo_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Assa ucara sa kubunu fe, bba tifi utiro, werne unin ufilig pit kitife, uba katinfi usee ulai nin kagiisin kidowo, ninworu itufi nan nya nla so ligan uyiita nin ncara sa abunu fe vat. ");
INSERT INTO amo_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Assa iyizife bba tiifi utiro, herina linin ufilin kitife, uba katinfi use ulaii nin liyizi lirum, nin woru itufi nan nya nla sa ligun nin niiyizi fe ib. ");
INSERT INTO amo_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Yenjen na iwa yassu warum nan nya kitene kane nono kadura Kutellẹ mine ko kome kubi idi nyenju nmoru ncif nighe ulle na adi kitene kani. ");
INSERT INTO amo_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Bara gono nnit na dak ada tucu nalenge na ina wulu. ");
INSERT INTO amo_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Iyaghari idi nkpilize? Asa umon unit dinin nakam akalt likure, kurum nanye nwulu, na aba cinu akalt likure udiru kuurume kitene kikup adi piziru kone na kuna wulu ba? ");
INSERT INTO amo_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Andi ase kunin, kidegen ndi nbellu munu, liburi libo me kitene kukam kurume bba katinu nin gbardang kitene nakam akalt likure udiru kurum na kuna wulu ba. ");
INSERT INTO amo_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Nan nya nanere, na usun Ncif mine allenge nadi kutenit kane warum nan nya nibebene nai nanna ba. ");
INSERT INTO amo_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Asa gwana fine ntafi kulapi, durso ghe utanu me, anung ligan mine, cas, asa a lanza fi, utuucu gwana fine. ");
INSERT INTO amo_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Andi na a lanzafi ba, yira nuwa na fine unit kiti nwanana urum sa anwaba ido kitime bara iyizi nawaba sa awaatat sa ko lome lugbulang base uyisinu. ");
INSERT INTO amo_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Asa anari ulanza nanan dortu Yisa, awa nari ulanzu nanan dortu Yisa, na ame so kitife nnafo kulumai sa unan sesen ngandu. ");
INSERT INTO amo_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Kidegene re ndin bellu minu, vat nile imon na itere nan nya nnye, iba teru kitene kane, nin vat nile imon na ibunku nnye nanere iba bunku kitene kane. ");
INSERT INTO amo_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ukpiine ku ndi bellu munu asa an wada nwa yinin nin nimon ule na iba tirrinu menku nan nya nnyi ucif nighe ulle na adi kitene kane bba su nani mun. ");
INSERT INTO amo_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Bara kiti ka na awaba sa an watat nzuro nan nya lisa nigh, ndi nanghinu.” ");
INSERT INTO amo_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nin nani Bitrus da ada belle Yisa ku, “Cikilari, udu timashinari gwana nighba sui kulapi meng shawa muna? udu so kuzora?” ");
INSERT INTO amo_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yisa bellinghe, “Nna meng na bellinfi udu kuzor ba, uduru akalt kuzorii sau kuzor. ");
INSERT INTO amo_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Bara nani, kipin tigo Kutellẹ di nafo umon ugo, na awa dinin su asu kibatiza nan nacin me. ");
INSERT INTO amo_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Kubi ka na awa acizina kibatize, ida nin nkon kucin me ulle na ame din dortughe titalent amui likure. ");
INSERT INTO amo_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Bara na awa idinin libau nbiuwe ba, Cikilari me na uduka idi lewuughe nin nwane a none umunu vat nile iimon na adumun, ida biyaghe. ");
INSERT INTO amo_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ame kucine dio kutyin, atumuno nbuun me aworo, 'Ccikilari, tursui limuri meng ba biyufi imonẹ vat.' ");
INSERT INTO amo_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Nin nani, Cikilari kucine, atinna alanza nkunekune me, bunkun ghe, shawan nin nre me. ");
INSERT INTO amo_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ame kucin kone nuzu ase umon udone licin me ulle na ame din dortu ghe idinari likalt akifo ghe kusholshok, a woroghe, 'Blayi imon ile na ndi ndortu fi.' ");
INSERT INTO amo_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ame udone licinne dio kutyin, adi fo ghe nacara aworo, 'Ta ayi ashau nin mi nba biufi.' ");
INSERT INTO amo_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ame kucin nburne nari, nin nani, ayiraghe atoghe licin, udu kubi ko na aba biughe ule imon na adin dortu ghe. ");
INSERT INTO amo_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Kubii na adone licin nyene ile imon na asu, ayi mine nana. Ida idi belle Cikilari mine vat nile imon na asu. ");
INSERT INTO amo_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Cikilari kucin kone yicila ghe, a bellinghe, 'Fe vat bara uwa sui kuculu. ");
INSERT INTO amo_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Na fe nwasa ulanza nkunekune ndofine kucine ba? Nafo na meng na lanza nkunekune fe?' ");
INSERT INTO amo_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Cikilarri me wa nanna ayi ninghe, a nakpa ghe nacara nanan nfo nanit udu kubi ko na aba biu imon ile na idi ndortu ghe. ");
INSERT INTO amo_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Nanere wang ucif nighe kitene kani, ba su anunku, asa na anug ba shawa nin nalapi nuana nan nya nibinai mine ba. ");
INSERT INTO amo_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Na ida kubi na yisa mmala tigbulange, a sunna Ugalili, ada nan nya ligan Yahudiya ukafinu kurawa urdu. ");
INSERT INTO amo_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Ligozi gbardang dofinghe, a shizino nin ghinu kikane. ");
INSERT INTO amo_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Afarisiyawa da kitime, idumunzun ghe, nbellinghe, “Uduka nyinna nworo unit ko uwani me nan nya nimon ille na uwane tawa?” ");
INSERT INTO amo_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yisa kauwa a woro, “Na anun wa yene ubellu ninyyerte ba, nworu ame ulle na awa ke nani nin gankilime nin uwani? ");
INSERT INTO amo_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Akuru a woro, 'Bara nanere unit ba cinnu ucif me nin nna me a munu nin nwani me, anwabe ba da so finawa firuma? ");
INSERT INTO amo_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Nin ndu mbun na awabari ba, finawa firuum bara nani, imon ule na Kutellẹ munu, na umon wa kosu ba.” ");
INSERT INTO amo_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Inugh woroghe, “Ani iyari ntta Musa wa bellin nari tiniza awani bite inyerte nworu ilugma bite nmala anin ko ghe?” ");
INSERT INTO amo_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","A belle nani, “Bara ngbas niibinai minere Musa wa sun muunu iko awani mine, nin nburne na nanere wandi ba. ");
INSERT INTO amo_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Meng bellin munu, vat ulle na ko uwani me andi na kulapi nzina ba amini ndi yira uumon, asu kulapin nzina, unit ule na adi yira uwani ule na ina ko ghe asu uzina.” ");
INSERT INTO amo_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Nono kadura belle Yisa ku, “Andi nanere ubellen ngankilime nin nwani, na ucaun isu ilugma ba.” ");
INSERT INTO amo_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yisa woro nani, “Na koghari ba yinnu ninle uduursuze ba, se allenge cas na ina yinin nani iseru unin. ");
INSERT INTO amo_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Bara amon duku iwa machu nani sa tinanilime mine. Amon tutun annitari wa gbaru nani. Amon asa inughere ta atimine ku bara kipin tigo Kutellẹ. Ame ulle na adini su seru ulle udursuze, na a seru unin.” ");
INSERT INTO amo_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Iwa da nin nono nibebene kitime anan tarda nani acara me na ti mine ati nlira, nono katwa me kpada nani. ");
INSERT INTO amo_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yisa woro, “Sunan nono nibebene, na iwa wantin nani udak kiti nighe ba, kipin tigo Kutellẹ di kin nimuwsu minere.” ");
INSERT INTO amo_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","A tarda nani acara me, a tunna anya kitene. ");
INSERT INTO amo_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Umon unit da kitin Yisa a woro, “Unan dursuzu kiti, iyapin imon iciniari mma su nnan se ulai un sali ligangha?” ");
INSERT INTO amo_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yisa woroghe, “In yaghari nta uminin ntirini ubelen nimon igegeme? Unit urumari cas di gegeme, nan nya nani andi udi nin su use ulai nsali ligang, dorto uuduke.” ");
INSERT INTO amo_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Unite woroghe, “Uyeme uduka?” Yisa woro, “Yenje nwa mollu unit yenje uwa nozo nin na wani, namon yenje uwa su likiri, yenje uwa su kinu, ");
INSERT INTO amo_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","gyantina ucif fe nin nafi ne unin ti usu nnan kupo fe nafo litife.” ");
INSERT INTO amo_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kwanyane woroghe, “Ilenge imone vat nna su. Iyaghari kuru iduyi?” ");
INSERT INTO amo_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yisa woroghe, “Andi udi nin su use ukulu, can, lewe imon ilenge na udimun, uni nikimon, uma se imon nacara kitene. Kani unin dak, udofi ni.” ");
INSERT INTO amo_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Na kwanyane nlanza imon ilenge na Yisa nbelle, anya nin tinana nayi, bara awa di nin nimon nacara gbardang. ");
INSERT INTO amo_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Yisa woro nnono katwa me, “Mbellin minu kidegene, udin konu unan nimon nacara ghana kitene kani. ");
INSERT INTO amo_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nkuru nbellin minu, nworu uman nimon nacara piru kipin tigo Kutellẹ, ukatin nin shew kurakomi piru ligalon nalira.” ");
INSERT INTO amo_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Na nono katwa me nlanza nani, umamaki kifo nani kang i woro, “Ani ghari wasa ase utucue?” ");
INSERT INTO amo_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yisa yene nani aworo, “Kiti na nanit udin konu, kiti Kutellẹ vat nimon in suari.” ");
INSERT INTO amo_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Biturus ttunna akpana a woroghe, “Yene, tina sun imon vat ti dofin fi. Ani iyaghari arik ba se?” ");
INSERT INTO amo_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yisa woro nani, “Mbbellin minu kidegene, anughe na ina dofini, nan nmaru upese na gono Kutellẹ ma so kutet tigo me, anung wang ma so na tet likure nin na ba, isu ushara nnonon Israila likure nin naba. ");
INSERT INTO amo_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Vat nlenge na a suna nilari, nuana nilime, nuana nishono, ucif, una, nono sa kumen bara lisanin, ama seru mmari akalt likure a ulai un sa ligang. ");
INSERT INTO amo_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Nan nya nnani gbardang na idi anan cizunu nene mada so anan kidung, a gbardang na idi anan kidung maso anan bun. ");
INSERT INTO amo_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Kinin kipin tigo Kutellẹ masin unan kunen, ulenge na anuzu nin kwui dinding adi piziru anan katwa kunen me. ");
INSERT INTO amo_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Na immala tijuana katwa we ko uyeme unit liyirinn me fisulai, a ta nani kunene. ");
INSERT INTO amo_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","A kuru nuzu tutung kubi ni koro itat a yene among anan katwa yissing nkasua sa katwa. ");
INSERT INTO amo_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","A do kiti mine a woro, 'Anan wang, can kunene, imon ilenge nan yene idi dort mma ni minu, inughe tunna inya udu katwa we. ");
INSERT INTO amo_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Akuru a nuzu kubi nikoro kutocin nin nikoro kuti tutung, asa nan ghinu nane wang. ");
INSERT INTO amo_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Tutun akuru anuzu kubi nikoro likure nin firum ase amon yissinn sa katwa. A woro nani, 'Iyaghari nta iyissin kikane uworu kwui dinding sa katwa' ");
INSERT INTO amo_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","I woroghe, 'Na umong in yira nari katwa ba.' A woro nani, 'Anun, wang, can nan nya kunene.' ");
INSERT INTO amo_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Na kuleleng nda unan kunene woro nnan yenju katwa we, 'Yicila anan katwa we uni nani uduk mine, cizinu kitin nnan dak kidunghe umalzin nin nan burnun dake.' ");
INSERT INTO amo_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Anan katwa we na ini yira nin nikoro likure nin firum da, ko uyeme mine sere fisule. ");
INSERT INTO amo_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Na anan burnun cizunu katwa we nda, i cisso inung ma seru gbarandan, inung wang ko uyema sere fisuule. ");
INSERT INTO amo_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Na isese uduk mine, igbondulo kitene nnan kunene. ");
INSERT INTO amo_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","I woro, 'Anan katwa kidughe nta fikoro firumari cas katwawe, nani umini nna nane irume nan ghirik, arike nna ti juju nidowe bite nan nya liyirin nin gbagbai nwui.' ");
INSERT INTO amo_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Unnare unan kunene kpana a woro nmong mine, 'Udondong, N nta minu kulapi ba. Naa tini su nan ghinu nan nya fisule ba? ");
INSERT INTO amo_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Seren imon ilenge na nnare di inmine inyai ulanzun mmmang nighari nni anan yiru kidunghe irume nan ghinu. ");
INSERT INTO amo_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Na meng di nin likara nworu nsu imong ilenge na idi nin sue nin tamani nighe ba? Sa iyizi fe tifi uti lalapi bara na men di gegeme? ");
INSERT INTO amo_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Bara nani anan kidung bada so anan cizunu, anan cizunu so anan.” ");
INSERT INTO amo_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Kubi na Yisa wa cinu ucindu Urshalima, awa yiru nono katwa me likure nin nan wabe ninghe, libau we a woro nani, ");
INSERT INTO amo_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Yenen ti din cinu udu Urshalima, ima nakpi usaun nnit nacara ndidya nin nan ninyerte kutin nlira. Ima sughe ushara nkul ");
INSERT INTO amo_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ima nakpi ghe nacara na awurmi bara inan sughe liyakiti ishuru ghe, inin kotun ghe kitene kuca. Nan nya liyiri lin tatte ima fiughe.” ");
INSERT INTO amo_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Una nnonnon |Zabede da kitin Yisa ligowe nin na saun ne. A tumuno nbunme aniin tiringhe imongmon. ");
INSERT INTO amo_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yisa woro ghe, “Iyaghari udi nin su we?” A woro ghe, “Yinna nono nighe nibe se uso, unit urum ncara ulime fe, a unan be ncara ugul fe, nan nya kipin tigo fe.” ");
INSERT INTO amo_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yisa kpana a woro, “Na uyiru imon ilenge na udin tirue ba. Anung wa sa isone nan nya kakkuk kanga na meng din cinu usonue?” Inung woro ghe, “Ti wa sa ti (sono).” ");
INSERT INTO amo_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","A woro nani, “Kakkuk nin uma sonu. Amma ubelleng nso ncara ulime sa ncara ugule ning na unanghari na ma noi ba, uunna lenge na ucif nigghari nshirya.” ");
INSERT INTO amo_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Na kagisin nono katwa likure nlanza, ayi nana nani kang nin nuana ni be. ");
INSERT INTO amo_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Yisa yicila nani kitime a woro, “Iyiru ago nnawurmi din dursuani tigo, adidya mine tutung durso nani akara. ");
INSERT INTO amo_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Amma na uma yitu nani nan nya mine ba. Uma na so ulenge na adi nin su ayita udya nan nya mine uma so ghe gbas aso kucin mine. ");
INSERT INTO amo_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","A ulenge na adi nin su ayita unan bun mine uma so ghe gbas a so kucin mine. ");
INSERT INTO amo_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","|N|afo na asaun nnitt na dak isu ghe licin ba, nani ame su nari licin, anin kuru ani ulai me imon kusere nanit gbardang.” ");
INSERT INTO amo_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Na iwa nuzu nan nyan Jericho, ligozi nanit gbardang dofinghe. ");
INSERT INTO amo_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ise aduu aba sosin kupo libau. Na i lanza Yisa din cinu ukatu, ita ntet i woro, “Cikilari, usaun Dauda, lanza nkune kune bite.” ");
INSERT INTO amo_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Amma ligozie Kpada nani, i woro nnani i min tik. Nani ina kpina ughantinu tiwui mine i woro, “Cikilarri, usaun Dauda lanza nkune kune bit.” ");
INSERT INTO amo_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Yisa tunna ayisina ayicila nani a woro, “Iyaghari idin pizuru nsu minu?” ");
INSERT INTO amo_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","I woro ghe, “Cikilari, iyizi bite pun.” ");
INSERT INTO amo_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yisa tunna, nkune kune kifo ghe nin ghinu, a dudo iyizii mine. Dedei ise uyenu kiti i dofin ghe. ");
INSERT INTO amo_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Na Yisa nin nono katwa me nda duru susut nin urshalima ida U Baitfayi, kusari likup Nzaitan, Yisa tunna a to nono katwa me naba, ");
INSERT INTO amo_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","a belle nani, “Can nan nya kagbiri nbune, ima yenu kajaki terin ku, nin gono kajake ku. bunkun ninin ida nei ni ning. ");
INSERT INTO amo_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Andi umong matirinu ubeleng nining, ima woru, 'Cikilari di nin su nining,' unit une na turun munu nin nining. ");
INSERT INTO amo_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Imone wa so nani inan kulo uliru ulenge na iwa bellin kkiti nnan liru nin nuu Kutelle nworo, ");
INSERT INTO amo_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Bellen ushonon Sihiyona, yene, Ugo fee din cinu udak kitife, Nin toltunu liti kitene kajaki, Kitene kalpadari, gono kajaki.” ");
INSERT INTO amo_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nono katwa me tunna ido idi su nafo ubellu me. ");
INSERT INTO amo_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","I da nin kayake nin ka gonoe, i tarsa imon nidowo mine kitene, Yisa nin so kitene. ");
INSERT INTO amo_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ngbardangg nanite nonkuzo imon mine libauwe, among tutuung kezze tilang nace inonkuzo libauwe. ");
INSERT INTO amo_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ligozin nanite na iwa din nbun in Yisa nin na lenge na iwadi dortughe, jartiza kang, i woro. (Hossana) Liru udu kiti Nsaun Dauda! Unan mmariari ame ulenge na adin cinu nanya lissan Cikilari. Hosanna udya!” ");
INSERT INTO amo_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","nKubi kongo na Yesu wa piru Urushalima, vat kipine wayissin dang, “Ghari ulele?” ");
INSERT INTO amo_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ligozin nanite kawa, “Yesuari ulele, unan liru nin nuu Kutelle, na ana nuzun Galili.” ");
INSERT INTO amo_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Na Yesu npira ukaikali Kutelle, akoo ale na idin sessu ilesse nya kaikale atunna awufuzu atebur na nan kpillizu nikkurfung ghe nan niti lisosin na nan lessu na tattabara. ");
INSERT INTO amo_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Aworo nani, “Ina nyertin, 'Kilari nighe iba yicu kinin kilarin nlira,' inani kpilaa kinin ki so lii na kir.” ");
INSERT INTO amo_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Aduuwe nanan kentu daa kitime nyan haikali, a shino nin ghinu. ");
INSERT INTO amo_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Na udya na priest nin na nan nyerte inyene imon izikiki na a suu, na ilanza nono din teit nyan haikali idin belu, “Huzana kitin gonon Dauda,” nibinei mine nana. ");
INSERT INTO amo_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","I woroghe, “Ulanza ile imon na anile alele din bele?” Yesu woro nani, “Ee! Na anun sa karanta baa, 'Na iyiru liruu din nucu tinuu nnono nibebene nin ninese baa'?” ");
INSERT INTO amo_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yesu suun nani anuzu kipine adoo Ubetani adi moru ku. ");
INSERT INTO amo_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Nin kui ding-ding ghe na akpilla nya kipine, awadin lanzu kukpon. ");
INSERT INTO amo_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Libau we ayene ku ca kupal, adoo kiti kunin, na ase imonku ba sei afa, awore kuce, “Sali gang na iwa se kumat kiti fe ba.” Kitene kuca kupule tunna ku koto. ");
INSERT INTO amo_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Na nono katwa we inyene nani, imone taani zikiki i woro, “Inyizyarin ntaa kuca kupul koni mba tunna ko koto kite?” ");
INSERT INTO amo_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu kawa aworo nani, “Kidegen inbelin minu, i wa dinin kidegen na ikosu nibinei ba, naiba suu ile imon na ina su ku ca kupule kune cas ba, iba bellu likup lole caccana udyun nyan mmen, tutung uba soo nanin. ");
INSERT INTO amo_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Asa iyinna vat nile imon na itirina nya nlira iba seru.” ");
INSERT INTO amo_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Na Yesu ndaa nyan haikali, udya na priest nin nakune na nite daa kitime, a ayitan ndursuzu aworo, “Na yapi akarari udin su ile imone? tutung ghari nafi lolikare?” ");
INSERT INTO amo_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu kawa aworo ani, “Meng wang ba tirin mi nu utirinu urum, anun wa belli meng wang ba bellu minu sa likara nghari ndin suu ile imon. ");
INSERT INTO amo_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ubaptisman Yohanna-uwa nuzun weari, unuzu kitene sa nanit?” Igbondilo na timine, iworo, “Tiwa woro, 'Unuzu kitene,' aba woro ari, 'Inyan ghari wa ti na iyinna nin ghe ba?' ");
INSERT INTO amo_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Tiwa woro unuzu nati, 'Tilanza fiu ligozin,' bara na vat iwa yene Yohanna kufo unan kadura.” ");
INSERT INTO amo_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ikawa Yesu ku iworo, “Na tiyiru ba.” Ame wang woro ani na meng ba bellu minu sa nya na kara nghari meng din su ile imone ba. ");
INSERT INTO amo_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Iyanghari ukpilzu mine? Unit nin nasaun a ba, adoo kiti kin funu aworo, 'Usaun can kuneng kitimone udu su kataa.' ");
INSERT INTO amo_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Usaun kawa aworo, 'Nan ba duba,' na akpilza kibinei me anyaa udu kunene. ");
INSERT INTO amo_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Unite doo kitin saun unbee abellin ghe fo unan infune. Ule usaune kawa ghe aworo, 'Mba du, Cikilari,' na adoo ba. ");
INSERT INTO amo_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nya na saun abe uyemeari wa poo ucif me liburi?” I woro, “Unan finu.” Yesu woro nani, “Kidegennari in belin minu, anan sessun gandu nin nakilaki ba yarin minu npiru kilari Kutelle. ");
INSERT INTO amo_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Yohanna wa dak kitimine nin libau lilau, na iyinna nin ghe ba, anan sessun gandu nin na kilaki yinna nin ghe, anun tutung, na iyene ileli imone, na iba cino alapi mine idan se kubi iyinna ninghe ba. ");
INSERT INTO amo_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Lanzan nton tinan tigoldo, umong unit wa duku, unite nin kuneng gbardang, a bilsa a ca ku anin kee udanga ku, awuzu kuu kaciso ku anin kee kutii ncaa ku, anaa kibala kunin, anin nyaa udu mmon mmin. ");
INSERT INTO amo_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Na kubi kusane ndaa susut, atoo aciin me kiti na nan kataa we inighe kumat na ce. ");
INSERT INTO amo_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Anan kataa kunene kifo aciin me, ifo warun, imolo umong nannyee inin kunene kifo aciin me, ifo warun imolo umong nannyee inin tasa umong nin na tala. ");
INSERT INTO amo_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Tutung unan kunene too among aciin me, ngardang mine kata anan finue, anan kataa kunene suu nin ghinu fo anan finue. ");
INSERT INTO amo_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Nkatu nani, unan kunene too usaun me kitime, aworo, 'Iba ghantinu usauni ghe gongong.” ");
INSERT INTO amo_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Na anan kataa we nyene usaune, I woro nati mine, 'Usau nare ulele. Dan timolu ghe ti li ugadu me.' ");
INSERT INTO amo_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Inutung ghe nya kunene, inin imolo ghe. ");
INSERT INTO amo_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Neenee kubi koo na unan kunene nwadak, nyan gharai aba suu nin na nan kataa kunene?” ");
INSERT INTO amo_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Anite woroghe, “Aba molu anan kataa ananzang anee nya libau nsalin kune kune, anin ni kibala kunene kiti nameng, anit ale na iba biu ikurfung kubi ko na imon kunene nyini.” ");
INSERT INTO amo_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu woro ani, “Na ikaranta nyan litape ba, 'Litala lo na anan makeke na nari linnare nda soo liti ne. Ilele unuzu kitin Cikilari, tutung udi zikiki bite?' ");
INSERT INTO amo_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Bara nani nbelin minu, iba seru kutii tigoo Kutelle kitimine ini mmin moo na ini maa kazuzu minin kolu kumati te. ");
INSERT INTO amo_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Vat nle na deo kitene litala lole aba putuzu agir-agir. Ulenge na litale ndeo litime liba jazilinghe. ");
INSERT INTO amo_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Na udya na priestoci nin na Farisawa nlanza too tinan tigoldue iyinno adi nliru natimine re. ");
INSERT INTO amo_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ko kobe kubi ko na asa imala ukifu ghe, asa ilanza fiu ligozin na nite bara na anit gbardang nyira ghe ame unan nliru nin nuu Kutelleari. ");
INSERT INTO amo_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu kawa anin lira nani nin tinan kuguldo tutung, abenle, ");
INSERT INTO amo_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Kilari tigo Kutelle masin umon unit na awa su usaune ubuki ni lumga. ");
INSERT INTO amo_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","A too a cin me idi yicila ale na a wa duru nani ilumge idak, na ida ba. ");
INSERT INTO amo_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","tutung a too among a cin, abenle nani, 'Benlang ale na ina duru nani ilumge, “Yenen, mmalu kanju imonle. Ina nan niyin nighe i malu basu, vat nimong nmalu zuru. Dan kiti nilumge.”' ");
INSERT INTO amo_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Bara nani na anit an nda ba. Among kpila udu anenmene kagisine kpila udu kitin lesu nin sesu mene. ");
INSERT INTO amo_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Amen ta acin me imancing, inin molo nani. ");
INSERT INTO amo_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Bara nani ugowe nana ayi. A too anang likum me idi mulsu nani, inin juju kagbire. ");
INSERT INTO amo_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Anin woro na cin me, 'Ilumge din cinu, uzuru tutung ale na ina belin nani na ida ba. ");
INSERT INTO amo_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Bara nani can kitene tibau idi beleng vat ule na iyeneghe adok kitin nilumge.' ");
INSERT INTO amo_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","A cine do kitenen libauwe idi yicila va nle na iyeneghe, anit a acine nin na le na idi acine ba, bara nani kutii nilumge wa kula gbem nin nanit. ");
INSERT INTO amo_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Bara nani na ugowe nda aba da yenu ale na ida kutii nilumge, a yene umun ule na awa shon kultuk nilumghe ba. ");
INSERT INTO amo_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ugowe woroghe, 'Udundun, utiza iyiziyari upira kikane sa kulutuk nilumge?' unite yisina nin kutike. ");
INSERT INTO amo_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ugowe nin woro na cin me, 'Teren unit ulele nacara nin nabunu i tuughe ndas nanyan nsirti, kika na ama gilu nin talu nayini.' ");
INSERT INTO amo_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Bara na anit gbardang na iwa yicila nani ma cunghari ina fere.” ");
INSERT INTO amo_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","A Farasiyawa non do idi mune atee ikye inda na ima kifu Yesu nanyan nliru me. ");
INSERT INTO amo_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Inin too ghe nono katwa mene, ligowe nan na Hirudiyawa. I woro Yesu ku, “Kumalami, ti yiru fe unan kidegenari unin din dursuzu tibau Kutelle nanya kidegene, tutung na umong ma wantinfi ubenlu kibinai fe ba, na udin feru anit ba. ");
INSERT INTO amo_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Bara nani benle nari iyanghari udin kpilizu? Ukari i ugandu kitin Kaisar ra sa babu?” ");
INSERT INTO amo_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Bara nani Yesu yino nibinai ni nanzan mene anin woro, “Iyarin ta idin dumuzuni, anu anan kinuu? ");
INSERT INTO amo_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Duruni fikurfunghe.” Inin da nin fikurfunghe kiti me. ");
INSERT INTO amo_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Yesu woro nani, “Kuyelin ghari nin lisa di kiteme fikurfunghe?” ");
INSERT INTO amo_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Iworoghe, “Kaisar.” Yesu nin woro nani, “Bara nani nang kaisar ku imon ile na idi Kaisar, in Kutelle tutung imon ile na idi in Kutelle.” ");
INSERT INTO amo_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Na ilanza nani, ikifo ti nuu mene. Inin sunghe iya. ");
INSERT INTO amo_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Liri lole amon a Sandukiyawa da kitime, ale na ina woro na ufitun kul duku ba. I tiringhe, ");
INSERT INTO amo_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","i woro, “Kumalami, Musa naworo, 'Unit wa ku na amara go ba, gwane yira uwane a se nono ku bara gwane.' ");
INSERT INTO amo_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Linwana kuzir wa duku, unan burne ku na asu ilumge, na ase nono ba. A suna gwane uwane. ");
INSERT INTO amo_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Unan mbe ta nafo ame, nanere unan tat udu unang zure. ");
INSERT INTO amo_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kimal mine vat, uwane da kuu. ");
INSERT INTO amo_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Nene lirin fitun nyii, uwanin ghari ba yitu nanya mene? Bara na vat mene wa yininghe nafo uwani.” ");
INSERT INTO amo_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Bara nani Yesu kawa a woro nani, “I tana bara na iyiru uliru Kutelle sa likara me ba. ");
INSERT INTO amo_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Bara na nin fitu nanan kull, na ilumga ma yitu ba a na ima nizu ilumga ba. Nnu nani, ima yiti nafo anan kadura Kutelle kitene kane. ");
INSERT INTO amo_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Bara ubelen nfitu nanan kull, na isa yene nanya niyerte ile imon na i wa beleng minu nuzu Kutelle, ");
INSERT INTO amo_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","'Mere Kutellen Ibrahim, Kutellen Ishaku, nin Kutellen Yakub'? Kutelle na Kutelle na beari ba, bara na Kutelle nanang nlai yari.” ");
INSERT INTO amo_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Na ligozin na nite nlanza nani, ikifo tinuu nin ma dursuzu dursuzu me. ");
INSERT INTO amo_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Bara na a Farisiyawan nlanza au Yesu ntursu ti nuu na Sandukiyawa, i pitirino ati mene kiti kirum. ");
INSERT INTO amo_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Umon nanya mene, ulauya, tiringhe a dumunghe- ");
INSERT INTO amo_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Kumallami, lome liduari lidya nanya na du fe?” ");
INSERT INTO amo_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu woroghe, “'U ma ti usu ncif Kutelle nin kibinaife, nin kidowe fe vat nin kibinai fe.' ");
INSERT INTO amo_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Uleleunare udyawe nin unburne. ");
INSERT INTO amo_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Un be masin ulele-'Uma ti usun nang kupoo fe nafo litife.' ");
INSERT INTO amo_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kitene na le adu abere uduke sosin ku nin liru nin nuu Kutelle.” ");
INSERT INTO amo_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Nene na a Farisiyawa wadu kiti kirum, Yesu tirino nani. ");
INSERT INTO amo_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","A woro, “Iyanghari idin kpilizu nin Kristi? Gonon ghari ame?” I woroghe, “Gonon Dauda.” ");
INSERT INTO amo_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesu woro nani, “iyarin nta Dauda nanyan Ruhu din yecughe ucef, a benle, ");
INSERT INTO amo_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","'Ucef uworon ncef nin, “Suu ncara uleme ning, saide nta anan nari fe imon patilu na bunu fe.'” ");
INSERT INTO amo_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Andi Dauda din yicu Kristi ku 'Ucif', a ta iyiziari a so Gonon Dauda?” ");
INSERT INTO amo_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Na umong ula kawughe imon ba, na umong kuru a tiringhe imomon tutung ba uworu lire. ");
INSERT INTO amo_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nin nani, Yesu su uliru ligozi, nin nono katwa mye. ");
INSERT INTO amo_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","A woro, “Anan ninyerte nin na Farisiyawa, asa iso kiti lisosin Musa. ");
INSERT INTO amo_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Bara nani, vat nile imon na ibellin munu isu, suun inin kin yenje, na iwa su adu mine ba. Bara inung di nbellu, na idin su inin ba. ");
INSERT INTO amo_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Nanere, asa itere kutura ku getek, kun nijasin inyaunu, inin tarda anit nabandang, inung atimine na iba dudu nin ticin bara iyaun ba. ");
INSERT INTO amo_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Vat nadu mine idin su, anit nan yenje nani, asa ikye ilaya gba gbardang, inin ta alutuk ajangaran. ");
INSERT INTO amo_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Idinin su niti lisosin tigo kiti nbuki, nin kiti lisosin nago nanya kutyi nlirag, ");
INSERT INTO amo_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","nin nilip tikune nanya nkasu, anit yicu nani 'Unan yiru'. ");
INSERT INTO amo_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Bara anung na iwa yicu munu 'Unan yiru', bara idinin nnan yiru warumari, vat mine linuanari. ");
INSERT INTO amo_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Na iwa yicu unit nanya inyi Ucif mine ba, bara tidi nin Ncif warum, amere ule na adi nanya kitene kani. ");
INSERT INTO amo_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Sa iyicu munu 'Unan dursuzu', bara idinin nnan dursuzu warum, ame Kristi. ");
INSERT INTO amo_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ame ulenge na adi udia nanya mine, na aso unan su munu katwa. ");
INSERT INTO amo_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Vat nlenge na aghantina liti mye, iba toltunghe, nin vat nlenge na a toltuno liti mye iba ghantinghe. ");
INSERT INTO amo_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Kash anughe, anan ninyerte nin na Farisiyawa, anan rusuzu nati, anung ntursu kipin tigo Kutelle kiti nanit, na anung ati mine npira ba, a na iyinna ale na idinin su pire, ipuru ba. ");
INSERT INTO amo_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Kash anung, anan ninyerte nin na Farisiyawa, anan rusuzu nati, idin bolusu nalari nawani ale na ales mine na kuzu, inani din dursuzu ati mine kiti nlirag mijangarang bara nani iba seru uca nkul udia. ");
INSERT INTO amo_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Kash anung, anan ninyerte nin nafarisiyawa, bara asa idoo kurawa nin kutyin, npiziru anan dortu Kutelle, iwa se, asa ukuru itaghe aso gono nlahira nafo na anung atimine di. ");
INSERT INTO amo_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Kash anung anan ninyerte nin na Farisiyawa, anung na ina woro, 'Vat nlenge na asillo nin kutyi nlirag, na imomo nari ba, vat nlenge na a sillo nin nazurfa kutyi nlirag, isillin ntere ghe.' ");
INSERT INTO amo_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Fe uduu ulalang, iyaghari katin, azurfe sa kutyi nlirag na kuna kussu fi azurfe? ");
INSERT INTO amo_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nin nworu, vat nlenge na asillo nin bagadi na imomonari ba, bara vat nlenge na asillo nin nfillu na udi kitene, isillin in tereghe. ");
INSERT INTO amo_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Anung anit aduu, Iyaghari katin, ufille sa ubagadi na nnere na kussu ufille? ");
INSERT INTO amo_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Bara nani, vat nlenge na asillp nin nbagadi, asillo nin vat nimon ile na idi kitene nbagade. ");
INSERT INTO amo_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ame ule na asillo nin kutyi nlirag, asillo nin kunin nin nlenge na asosin nanya kunin. ");
INSERT INTO amo_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ame ulle na asillo nin kitene kani, asillo nin kutet tigo Kutelle ninghe ule na asoson kitene. ");
INSERT INTO amo_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Kash anung anan ninyerte nin na Farisiyawa, anan rusuzu nati, idin nizu uzakka vat nimon kunen, ina suna litino nimone, kidegen usu gegeme, uyitu dert, ile imonere caun isu, na iwa fillin inin ba. ");
INSERT INTO amo_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Anung aduu, fe ulenge na asa ifillo kajiji kacing, ina milla kulonkomi. ");
INSERT INTO amo_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Kash anung anan ninyerte nin na Farisiyawa, a sa ukusu mamal kakuk nin kishik, ina suuna nanye nin ndinon. ");
INSERT INTO amo_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Anung Afarisiyawa aduu, burno ukussu nanya kakupe nin kishik, bara uddase nan da yita lau tutun. ");
INSERT INTO amo_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Kash anung anan ninyerte nin na Farisiyawa, anan rusuzu nati, anung di nafo nisek nibo pert, alenge ndase idin yenju gegeme, nanye kullun nin nakuu na nan kuzu, nan nimon nsalin nlau. ");
INSERT INTO amo_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nin nanere, asa anung ndase inuzu anit alau, udu nanye ikullun nin rusuzu nati nin kulapi. ");
INSERT INTO amo_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Kash anung anan ninyerte nin nafarisiyawa, bara din nkye nissek na nan nliru nin nnu Kutelle, nin su nissek na nan fiu Kutelle kuyok. ");
INSERT INTO amo_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Anung sa iworo, 'Nda tiwa duku nayiri nacif bite, na tiwa munnu nanghinu nanya ngutunu nmyi, na nan nliru nin nnu Kutelle ba.' ");
INSERT INTO amo_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Bara nani, anung nsheida atimine, nworu anughere nono nalenge na iwa mollu anan nliru nin nnu Kutelle. ");
INSERT INTO amo_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Anung tutun ba kullunu kagisin kulapi nacif mine. ");
INSERT INTO amo_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Anung iyii abuni, inung isudun niyii, iba ti iyiziyari isortu kiti nwucu kidegen nin kilari nlah? ");
INSERT INTO amo_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Bara nani, yenen ntoo munu anan nliru nin nnu kutelle, anit ajinjin, nin na nan ninyerte, among nanya mine iba mollu nani, ibana nani kutca, amon nanya mine iba kpizu nani nanya kutyi nlirag, ukoo nani kagbir udu kagbir. ");
INSERT INTO amo_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Kiti minere alakin nmyi nanan fiu kutelle, mongo na iwa gutun inye, uyiru nmyi Habila unan fiu Kutelle, udu nmyi zakariya usaun Barikiya ulenge na iwa mollughe, kiyitik, kiti nlirag nin nbagadi. ");
INSERT INTO amo_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Kidegen Meng nbellin munu, vat nile imone base kuji kone. ");
INSERT INTO amo_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Urushelima, Urushelima, fe ulenge na udin mollusu anan nliru nin nnu Kutelle, idin filisu na ina tuu nani kiti mine, iyanghari uworsu ndinin su npitirin nono fe, kiti kirum, nafo kukuru na asa pitirino nono mye, nagilit mye, bara nani, inani nari! ");
INSERT INTO amo_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Yenen nilari mine ba lawu ni lem sa anit. ");
INSERT INTO amo_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Bara Meng nbellin munu, na iba kuru iyenei ba nene udu ubun, se iworo, 'Unan nmariari ule na aba dak nanya lisa Ncikilarie.'” ");
INSERT INTO amo_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu nuzu nanya kutii nlira a tunna ncin me; non katwa me da kitime ida dursoghe makeke kutii nlira. ");
INSERT INTO amo_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","A kpana aworo nani, na anung din yenju ile imone vat ba? “Idin bellu minu kidegen, na litala lirum duku longo na ima sunu kitene ilong sa ukpiliwu ba.” ");
INSERT INTO amo_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Na aso likup in Zaitun, non katwa me da kitime likot iworo. “Belle nari, ile imone mayitu nishiyari? Iyaghari ma dursu udakfe nin nimalin inyii? ");
INSERT INTO amo_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu kpana aworo nani. “Yenjen umon wa rusuzu minu. ");
INSERT INTO amo_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Bara anit gbardang ma dak nin lissa ning; ima woru 'myari Kristi', tutung ima rusuzu anit gbardang. ");
INSERT INTO amo_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ima lanzu ubeleng likum nin liru likum; yenjen ayi mine wa fita, bara ilenge imone ma dak gbas a na imaline nsa da ba. ");
INSERT INTO amo_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Bara nmon min ma fitu nivira nin mon min, tigo kitene ntong tigo. Ima su akpon nin hirtizu nmyen niti niti. ");
INSERT INTO amo_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Vat ninlenge imone ma yitu ucizunu nniuwari. ");
INSERT INTO amo_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Tutung ima nin nakpu minu nacara na lenge na ima timinu ineo, imolsu minu. Uyii vat ma nari minu bara blissa ning. ");
INSERT INTO amo_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Anit gbardang ma tirzu inin lessu ati. ");
INSERT INTO amo_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Anan bellu liru nin nuu Kutelle kinu ma fitu gbardang, iba wultunu anit gbardang. ");
INSERT INTO amo_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Bara na likara linanzang bati gbardang usu nanit ma ti camcam. ");
INSERT INTO amo_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Vat ulenge na a tere kibinayi nanya neu udu imalne, amere ma se utucu. ");
INSERT INTO amo_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ule uliru umang nbelleng kipin tigo Kutelle ima su unin nyii vat unan so kutuf kunba timin timin vat; imaline ma nin dak. ");
INSERT INTO amo_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Nene asa iyene adadu an fiu, alenge na Daniel unan liru nin nuu Kutelle wa bellin, yissin nanya kiti kilau, (na unan bellu niyerte yinnin). ");
INSERT INTO amo_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","na alenge na idi in Yahudiya cum udu akup. ");
INSERT INTO amo_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","na ame ulenge na kitene kutii kitene nwa tolu adi yiru imonmong nan nya kilare ba. ");
INSERT INTO amo_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ame ulenge na adi kunen na awa kpilin kilari ada yiru ugudun ba. ");
INSERT INTO amo_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ushe nawani alenge na ima yitu nin naburi, nin nalenge na ima yitunmazunun nono kubi kone! ");
INSERT INTO amo_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Sun nlira na ucum mine waso nin kubi likus sa liri na Sabbat ba. ");
INSERT INTO amo_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Bara uniu ma yitu kang, umusun lenge na isa su unin ba tun ucizunu inyii udak kitimone, ana imakuru isu umusun nnin ba. ");
INSERT INTO amo_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Sasa na ima canu ayiri ane ba, na unit wase utucu ba; bara alenge na ina fere, inani ma canu ayiri ane. ");
INSERT INTO amo_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Asa umong woro minu, yeneng Kristi ule; sa a “Kristi uni” na iwa yinin ba. ");
INSERT INTO amo_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Anan kinuu nKristi nin nanan liru nin nuu Kutelle kinuu ma dak isu imon fiu izikiki gbardang, iwultun anit libau, umunu wang alenge na imal ferui nani. ");
INSERT INTO amo_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Yenen nbellin minu a kubi dutu sa udak ");
INSERT INTO amo_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Bara nani, iwa bellin minu, “yenen, Kristi di nanya kusho,” na iwa nuzu udue ba, iwan woro minu, adi nanya kutii limot, na iwa yinin ba. ");
INSERT INTO amo_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Nafo na umalzinu kiti asa unya kusari kitene udu kadas, nanere wang udak in Saun in Nit ma yitu. ");
INSERT INTO amo_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Kikanga na libi nonku kikanere agbulluk ma pitirnu ku. ");
INSERT INTO amo_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Kimal na leli ayiri nniuwe uwui ma siriu, na upui mani nkanang me ba, iyini ma dissu unuzu kitene kane, akara kitene kani ma zullunu kidowo. ");
INSERT INTO amo_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Udursu kulap ndak in Saun in Nit ma nuzu kanang kitene kani, vat tilem inyii ma su tiyom. Ima yenu Usaun Nnit din cinu nanya nawut kitene kani nin likara a ngogong midya. ");
INSERT INTO amo_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ama nin tu nono kadura me nin liwui kulangtung kanan, inung manin pitirunghe anit alau me na sari anas vat kiti kirum, unuzu nlo ligang kitene kani udu loli liganghe. ");
INSERT INTO amo_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Sen uyinu nimoimon kiti kuca kupau. Asa ulang in nutuno tifa tipese, yinnon kussik nda susut. ");
INSERT INTO amo_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Nanere wang, asa iyene ile imone, yinnon nworu a daduru, adi susut nin kibulunghe. ");
INSERT INTO amo_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Kidegennere nbellin minu, na ko kuje ma katu ba, se ilenge imone nse ukulu vat. ");
INSERT INTO amo_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kitene kani nin kadas ma katu, a na uliru ning ma katu ba. ");
INSERT INTO amo_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Ubellen nwui une nin kube na umong yiru ba, umunun inung nono kadura kitene kane, sa Usaunne, Uciffere cas yiru. ");
INSERT INTO amo_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Nafo na ayirin Nuhu wadi, nanere ma yitu udak Nsaun Nnit. ");
INSERT INTO amo_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Nafo aleli ayirin kulu nmyen inye wa dutu sa udak iwa din li iso, ipilla awani a iniza a shono mine nilugma udi duru lire na Nuhu wa piru uzirge, ");
INSERT INTO amo_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","na iwa yiru imoimon ba nmyene da kulo uye umila nani, nanere ma yitu udak Nsaun Nnit. ");
INSERT INTO amo_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ima se anit naba kunen; ima yiru unit urum, i sun urum. ");
INSERT INTO amo_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Awani aba mayitu tiyazun; ima yiru urum, isun urum. ");
INSERT INTO amo_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Nanya nani sun lisosin nca, bara na iyiru liri longo na cikilari mine ma dak ba. ");
INSERT INTO amo_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Yinnon ulele, Cikilari nwa yiru kubi kongo na ukiri din cinu, ama su uca na ama yinnu i puro kilae ipira ba. ");
INSERT INTO amo_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Nanere anung wang imasu uca bara Usaun Nnit ma dak kubi kongo na ima yiru ba. ");
INSERT INTO amo_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Ani ghari kucin kone kujijing, na kuyina cikilari me tighe in yenju ngame, anan niza nani imonli mine nanya kubi dert? ");
INSERT INTO amo_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Unan nmari ari kucin kone, ulenge na cikilari me ma dak ada seghe nsu nani. ");
INSERT INTO amo_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Nbellin minu kidegene cikilari une ma tardughe kitene nvat nimon ilenge na a dimun. ");
INSERT INTO amo_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Andi kucin kunanzang nworo nanya kibinei me. Cikilari nigye ndandauna; ");
INSERT INTO amo_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","anin cizin ufo nadon licinme, anin li aso nin nanan so nadadu, ");
INSERT INTO amo_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Cikilari kucin kone ma dak liri longo na kucin kone nceo kibinei ku ba, ");
INSERT INTO amo_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Cikilari me ma kifigye a fogye anin ceo gye urume nan nanan rusuzu nati, kikanga na kuculu mayiti ku nin nyakku nayini. ");
INSERT INTO amo_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Kipin tigo Kutelle masin nafo abura kulidi alenge na iwa yiru ti pitilla i nya udun di zuru nin kwanyana nkifu kudan. ");
INSERT INTO amo_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","An wa taun nanya mine wa di alalang, an wa taun yita jijing. ");
INSERT INTO amo_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Kube na abura alalangye wa yiru tipitilla mine na iwa yaun nmon nuf ugang ba; ");
INSERT INTO amo_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Inung abura ajijingye wa min amon abo nnuf ugang. ");
INSERT INTO amo_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Nene na kwanyana kifu kudangye wa molu kubi, vat mine gbishizino i tunna nmoro. ");
INSERT INTO amo_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nanya kiitik kitik, ilanza ntet, yeneng, kwanyana nkifu kudangye! Nuzun udas idi zuro nangye.' ");
INSERT INTO amo_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Abura ane tunna ifita vat i ngaatizina tila tipilla mine. ");
INSERT INTO amo_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Alalangye woro na jijijngye, fulonnari nnuf mine bara tipitila bite din cinu ubicu.' ");
INSERT INTO amo_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Inung ajijigye kawa nani i woro, Tidin yenju na mima batiinu nari ligowe na ghinu ba, nbara na can kiti nanan lessu idi seru min mine. ");
INSERT INTO amo_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Na inuzu ucin dun di serue, kwanyanan kifu kudane da, inung alenge na iwa di nin nimon mine vat pira kitin teru nilugme nan gye, ");
INSERT INTO amo_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","kimal nane inung aleli abura da iworo, Cikilari, Cikilari, puno nari kibulung.' ");
INSERT INTO amo_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Akpana a woro, 'kidegenere ndin bellu minu, na nyiru minu ba. ");
INSERT INTO amo_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Sun uca bara na i yiru lirei sa kubi nsame ba. ");
INSERT INTO amo_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Umasin nafo kube na unit din cinu ucindu imon nmin; ayicila a cinme a kosso nani imon nacara me. ");
INSERT INTO amo_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Umong anagye ti talents ti taun, umong anagye iba, umong tutung anagye tirum, kogha aw nigye cot nin likara m, anin nya udun cinme. ");
INSERT INTO amo_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Na nin molu kubi ba, unan nitaune nya, adi kpliza acara mun, ase imon itaun kitene. ");
INSERT INTO amo_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Nanere wang ame ulenge na awa seru iba wase imon iba kitene. ");
INSERT INTO amo_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ame ulenge na awa seru firume wa nyagye, adi wuzu kuwu nanya kutii, a nyeshe ikurfun ncikilari me ku. ");
INSERT INTO amo_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Na kubi nkata gbardang cikilari na cin ane kpilla, ada batiza ikurfun me nan ghinu. ");
INSERT INTO amo_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Kucin kongo na kuwa seru itaun da ada kurtuno imon itaun kitene; a woro, cikilari, uwa nii ti talents ti taun. Yene, nna se ukpinu nimon itaun kitene. ");
INSERT INTO amo_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Cikilari me worogye, gaja kang nin katwa, kucin kugegeme nin lidu licine! Usu lidu licine nanya nimon cing. Meng ma tifin yenju nimon gbardang. Pira nanya liburi libo ncikilarife. ");
INSERT INTO amo_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Kucin kongo na kuwa seru iba da ada woro. 'Cikilari, uwa nii iba. Yene, nse ukpinu nton ti talents tiba kitene! ");
INSERT INTO amo_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Cikilari me worogye, 'gaja kang ni katwa, kucin kugegeme nin lidu licine! Usu lidu licine nanya nimon cing. Meng ma tifi uyenje imon gbardang. Pira nanya liburi libo Ncikilari fe. ");
INSERT INTO amo_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Kunin kucing kongo na kuwa seru firum da ada woro. 'Cikilari. Men yiru fe unit ulenge na idin kpilizu fi ba: udin pitiru kiti kanga na ubilisa ku ba, udin bassu kiti kanga na ukpewu ku ba. ");
INSERT INTO amo_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Meng wa lanza fiu, nmini wa do ndi nyeshe fi talent fe nanya kutyen. Yene, kutura fe kongo. ");
INSERT INTO amo_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Cikilari me kawa aworogye, fe kucin nla liburi ni kugballa, fe yiru ndin pitiru bkiti kanga na nna bilissu ku ba nbassa ki kanga na nna npui ku ba. ");
INSERT INTO amo_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Uwanani ukpilizu nacara nin nikurfu, kubin sa nigye nwa seru ikurfun nigye nin nmyen kitene. ");
INSERT INTO amo_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Bara nani seren fi talente kitime ini ulenge na adi nin ti talents kulidei. ");
INSERT INTO amo_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Vat nle na adi ni nimon, ima kpingye ku gbardan. Ame ulenge na adu mun ba, ilenge na adumune wang ima seru. ");
INSERT INTO amo_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Gbudulnong inin tecu kucin kuhem kone i filing nanya nsirti mi bibit, kikanga na ama su kuculu nin nyakku nayini ku. ");
INSERT INTO amo_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Kubi kongo na Usaun Nnit ma sa nanya ngongong ligowe nin nono kadura me, ama so kutet ngongong tigo me. ");
INSERT INTO amo_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ima nin pitirunu anit timyin timyin vat nbun me, ama nin wucu anite ngangaang, nafo na unan libya asa akoso akam nanya niyiin. ");
INSERT INTO amo_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ama ciu akame ncara ulime me, a niyine ncara ugule. ");
INSERT INTO amo_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ame Ugowe mani nin woru na lenge na idin cara ulime me, Daan, anung anan mmari Ncifning, leon ugadu kipin tigo kanga na iwa kyeminu mun, nworu kubi ntunun nyii. ");
INSERT INTO amo_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Bara na nwadi nin kukpon, inayi imonli; Nwadi nin kotu nayi inayi nmyen nsonu; Nwadi limari ipiri kutii; ");
INSERT INTO amo_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Nwadi fisere, ishoni imon; Nwadi nin konu ida lissai; in yita licin ida kitinigye. ");
INSERT INTO amo_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Inung anan katwa kacine ma kawu i woro, 'Cikilari, ninshiyari tiwa yenefi nin kukpong tinafi imolin? Sa nin kotu nayi tinafi nmyen? ");
INSERT INTO amo_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Sa inweri tina yenefi limara, tinafi kutii? Sa fisere tishonfi imon? ");
INSERT INTO amo_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Sa nishirari tina yenefi nin konu, sa licin tida kitife? ");
INSERT INTO amo_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ame Ugawe ma kawu aworo nani. Kidegenere idin bellu minu, imon irika na ina su unit urum nanya na bebene linuananing, myeri ina sui. ");
INSERT INTO amo_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ama woru alenge na idin cara ugule me, cancanan kuponing, anung anan tin nnu, pira nanya nla sa ligan ulenge na ina kye unin bara shintan ku nin nanan kadura me, ");
INSERT INTO amo_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","bara na nwadi nin kukpon na inayi imonli ba; Nwadi nin kotu nayi na inayi nmyen ba. ");
INSERT INTO amo_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nwadi limari na ipiri kutii ba; fisere na ishoni imon ba; nin konu a kutii licin, na ida lissai ba. ");
INSERT INTO amo_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Inung wang ma kawu iworo, 'Cikilari, tiwa yenefi nweri nin kukpon, sa nin kotu nayi, sa limara, sa fisere, sa nin konu, sa kutii licin na tisufi imonmong ba?' ");
INSERT INTO amo_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ame manin kawu nani awor, 'kidegen idin bellu minu, bara na ina su ko unit urum nanya nabebene alele imon irum nanya ni lenge imone ba, myeri na ina sui ba'. ");
INSERT INTO amo_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Inung alele ima nyiu udu piru nanya nniu unsa lingang a inung anan katwa kacine udu nanya nlai unsa ligang” ");
INSERT INTO amo_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Kube na Yesu wa malu ubellu nliru une vat, a woro nono katwa me. ");
INSERT INTO amo_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“iyiru upaska nlawa ayiri abari cas, ima nakpu Usau Nnit ikotinghe kitene kuca.” ");
INSERT INTO amo_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ugo na Priest nin nakune nbun nanite wa da pitirin kiti kirum kudaru Ngo na Prieste, ulenge na iwa yirughe nin lissa Kefas. ");
INSERT INTO amo_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ligowe ipizira tibau nworu ikifo Yeso ku imolughe likire. ");
INSERT INTO amo_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Iwa din bellu, “ Na kubin idi paska, bara iwa fya anite ayi.” ");
INSERT INTO amo_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Kube na Yesu wa di in Baitanya ngan Simon ukutulu, ");
INSERT INTO amo_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","na awa sossin kiti nli nimonli, umong uwani da kitime nin libo nnuf kunya kumang min nikurf gbardang, a kpilya minin litime. ");
INSERT INTO amo_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Na nono katwa me in yene nani, ayi nana nani i woro, “Nyaghari finu nka kimole? ");
INSERT INTO amo_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Iwa lewu mini nin nikurfu gbardaang ikoso nikimon.” ");
INSERT INTO amo_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu nin yiru nane, a woro iyaghri nta idin bukuru nwani ulele kibinayi? Bara asuyi katwa kacine. ");
INSERT INTO amo_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Idi ligowe nan nikimone ko kome kubi, na meng ma yitu nan ghinu ko kome kubi ba. ");
INSERT INTO amo_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ule ukpilyu nnufe kidowe na asuyi, asu nani a kelei bara ukassu nigha. ");
INSERT INTO amo_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nbelin minu kidegen, kiti kanga na ima su ulenge uwaze ku nanya lenge uyeh vat, imon ilenge na uwani ulele nsu ima bellu unin inan lizino nighe. ");
INSERT INTO amo_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Umong nanya likure, ulenge na iwa yicughe Yahuda Iskaroti, ado kitin Ngo na Priest ");
INSERT INTO amo_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","aworo, “Imashinari ima ni meng nakpa minu ame?” Ibataghe azurfa akut atat. ");
INSERT INTO amo_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Atunna ipizuru ndina ule na ama nakpu nani ame. ");
INSERT INTO amo_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Lirin ncizunu nli fungal nsalin muccu, nono katwa me da kitime iworoge, “Weri udi nin su tidi kyele bara uli npaske?” ");
INSERT INTO amo_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Aworo, “Can kitin mon unit nanya kipine iworoghe, 'Cikilari nworo, “kubi nighe nda duru. Meng ba su upaska ngafere ligowe nin nono katwa nighe” ");
INSERT INTO amo_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nono katwawe su nafo ubellu me, I kyele imonli Npaske. ");
INSERT INTO amo_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Na kubi kuleleng nta, aso ama li ligowe nin nono katwa me likure. ");
INSERT INTO amo_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Idi nanya kilewe, aworo, “Ndin bellu minu kidegen umon nanya mine ma lewui.” ");
INSERT INTO amo_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ita aburi asirne kang, kogha nanya mine tiringhe, sameri Cikilari?” ");
INSERT INTO amo_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Akawa aworo, “ulenge na adin sho ncara kishik kirume nin mi amere ma lewui. ");
INSERT INTO amo_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Usaun Nnit ma nyiu nafo na ina yerti litime. Kash nnit ulenge na ama liwu Usaun Nnit! Uma katinu unit une nin caut na iwa na marughe ba.” ");
INSERT INTO amo_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yahuda ulenge na amere ma lewughe woro, “Sa menghari unan dursusu niyerti?” Aworoghe, ubelle nin litife.” ");
INSERT INTO amo_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Na iwa di kilewe, Yesu yauna ufungal, ata nlira ku, a pucco unin. Ana nono katwa me unin aworo, “Seren, leon. Kidowo nighari.” ");
INSERT INTO amo_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ayauna kakkuke ata nlira ku, a nakpa nani aworo, “Sonon, vat mine. ");
INSERT INTO amo_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Mone nmii nalikawali nigharibmongo na ina gutun bara gbardang na se ukusu nalapi. ");
INSERT INTO amo_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ndin bellu minu, na nma kuru nsono nmyen kumat kuce ba, se loli lire na nma sonu minin mipesse nan ghinu nanya kipin tigo Ncif ning.” ");
INSERT INTO amo_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Na ita avu nimalin, inuzu inya ucindu likup in zaitun. ");
INSERT INTO amo_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Yesu woro nani, “kyitik kane vat mine ma tiru bara meng, bara ina nyerti,'nma kpui unan libyawe ligo nakame ma malu kiti.' ");
INSERT INTO amo_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Vat nani asa ifyyi, nma nyiu ubun mine udu nanyan Galili.” ");
INSERT INTO amo_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Bitrus woroghe, “ Andi vat min ba diu bara fewe, na meng wasa nma tiro nsunfi ba.” ");
INSERT INTO amo_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu woroghe, meng din bellufi kidegen, nin kyitik kane kukulok mayitu kusa kolsino ba, uba woru na uyiri ba so titat.” ");
INSERT INTO amo_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Bitrus woroghe, Andi ma mma ku ninfi gbas, na nma narifi ba.” Ngisin nono katwa me vat belle nanare wang. ");
INSERT INTO amo_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesu tunna a nya ligowe nanghinu udu nkan kiti na idin yiccu kinin Ugetsemani a woro nono katwa me, “Son kikane meng do kikani ndi ti nlira.” ");
INSERT INTO amo_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","A yira Bitrus ku nin na saun Zabeden ligowe nanghe atunna a cizina usirzu nayi, ayime nana. ");
INSERT INTO amo_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","A tunna a woro nani, “Liburi nin siro bibit, nafo nku. Son kikane i yenje kiti nan mi.” ");
INSERT INTO amo_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","A cancana udu ubun bat, a deo nin nalung ata nlira, a woro, “Ucif ning, andi uwasa uso nani, na kakukkane kata kiti nighe. “ Vat nani, na ubellu nighe ba, ubellu fere.” ");
INSERT INTO amo_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ada kiti nnono katwa me ada se nani nmoro, a woro, a woro Bitrus ku, “inyaghar, na uwasa uyenje kiti nin mi kutanki kurumba? ");
INSERT INTO amo_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Yenjen kiti isu nlira bara iwa piru nanyan dumuzunu. Uruhe yinna, kidowere dinin likara ba.” ");
INSERT INTO amo_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ado tutung unba adi ti nlira, aworo, “Ucif ning, andi na uwasa ukata nani ba se nsono uning, na ubellu fere so.” ");
INSERT INTO amo_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ada tutung ada se nani idin moro, bara iyizi mine wa ti getek nin moro kang. ");
INSERT INTO amo_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Akuru a nya tutung, adi ti nlira uti un tat a belle uliru urume. ");
INSERT INTO amo_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Yesu da kitin nono katwa me aworo nani, “Idu nmoro nin shinua? Yeneng, kubi mal da duru, imal lewu Usaun nnit nacara nannan nalapi. ");
INSERT INTO amo_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Fitan nari ti nya. Yenen ulenge na aba lewiye nda duru.” ");
INSERT INTO amo_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","A dutun nlirue, Yahuda, umong nanya mine likure da. Ligozin gbardang wa di ligowe ninghe unuzu kiti ngo na priest nan nakune nanite. Ida nin na sangali nan tica. ");
INSERT INTO amo_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Nene unit ulenge na amere ma lewu Yeseku wa tinani udursu, aworo, “Ulenge na in nyukkunghe, amere kiffonghe.” ");
INSERT INTO amo_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ata mas ada kitin Yesu aworo, Ndin lissufi una dursuzu ninyerte! A nyukunghe. ");
INSERT INTO amo_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu woroghe, “Udondong su imong irika na uda nsue.” Inughe tunna ida, i kiffo Yesu ku, i nya ninghe. ");
INSERT INTO amo_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Umong nanya nalenge na iwa di ligowe nan Yesu tunna a nakpa ucara me, a shuku kusangali, a kowo kucin Ngo na Priest, a weringhe kutuf. ");
INSERT INTO amo_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesu tunna aworoghe, kpilla ushon kusangali fe kuparinme, bara vat nalenge na idin molsu nin na sangali iba molsu nani nin na sangali. ");
INSERT INTO amo_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Udin yenju na meng wasa in yicila Ucif ning, a toyi nin nono kadura me a lenge na ima katunu amui akut atat nin kutocin ba? ");
INSERT INTO amo_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ani iba ti iyizari uliru Kutelle kulo, nworu unan so nani gbas?” ");
INSERT INTO amo_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Kubi kone, Yesu woro ligo nanite, “I da nin na sangiali nan tica ida kifoi nafo ukirya? Ndin sozu ndursuzo anit nanya kutii nlira kolome liri, ana i kiffoi ba. ");
INSERT INTO amo_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Vat ilenge imone so nani iyerte nanan liru nin nu Kutelle nan kulo.” Nono katwa me tunna isunghe ico. ");
INSERT INTO amo_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Alenge na i kiffo Yesue ku nya nighe udumun kiti Kefas ugo na Priest kikanga na anan niyerte nin nakune wa pitin ku ligowe. ");
INSERT INTO amo_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Bitirusa cas wa dortughe kidun piit udu kudaru nwuccu nliru ndya kutii nlirie. A wa piru nanya a so ligowe nin nan ca ayene inyaghari iba su ninghe. ");
INSERT INTO amo_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Nene udya kutii nlirie nin nanan kpilzu me vat pizira uliru bellu litime na ise Yesu ku nin kulapi, bara inan se finu nliru imolughe. ");
INSERT INTO amo_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Na iwa se uliru ba, vat nin nan liru kinuwe na iwa da ida su. kimal nani among naba da ");
INSERT INTO amo_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","I woro, “Unit ulele wor, meng wasa npuco kutii nlira Kutelle nkpila nke kunin nanya nayiri atat.” ");
INSERT INTO amo_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Udya kutii nlire fita ayisina, aworoghe, “na udin liru ule na uma kpanu ba? Inyaghari ilele idin bellu litife?” ");
INSERT INTO amo_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","A Yesu yita nin kutike. Udya kilari nlira woroghe, “Ndifi kucukusu nin Kutellen lai, belle nari sa fere Kriste, Gono Kutelle.” ");
INSERT INTO amo_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu kawaghe, “Ubelle nani litife. Meng bellinfi nene, udu ubun uma yenu Usaun nnit sossin ncara ulime un likara, adin cinu kitene nawut kitene kani.” ");
INSERT INTO amo_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Udya kilari nlire marya kulutuk me aworo, “A zogo Kutelle. Iyaghari nta tutung ti kuru ti du nin su nmon uliru? Yeneng nene anung lanza tizogoe. ");
INSERT INTO amo_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Iyaghari idin kpilizue?” Ikawaghe i woro, “Abatina ukul.” ");
INSERT INTO amo_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Itufuzunghe ataf nmoro, ikuru iruzoghe, ifoghe tutung nin nacara mine, ");
INSERT INTO amo_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","I woro, “Sunari anabci fe Kristi. Ame ghari ulenge na a riofi?” ");
INSERT INTO amo_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Kubi kone, Bitrus wa sossin ndas nbun kutii nwuccu nlirue, nkan kabura kucin da kitime a woro. “Fewang di ligowe nin Yesu Ngalili.” ");
INSERT INTO amo_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ata amusu kun nbun mine vat, aworo, “Na meng yiru imon ilenge na udin liru kitene ba.” ");
INSERT INTO amo_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Na anuzu udu kibulung, nkon kubura kucin ugan tutung yeneghe a woro alenge na iwa di kitene, “Unit ulele wang wa di ligowe nin Yesu Nnazaret.” ");
INSERT INTO amo_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Akuru ata amusu ku tutun nin nisiling, “Na in yiru unite ba.” ");
INSERT INTO amo_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Nin kubiri bat, alenge na iwa yissin kitene da ida woro Bitrus ku, “Kidegenere, fe wang umong nanya minere, bara lilemfe ndursofi.” ");
INSERT INTO amo_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Atunna a cizina izogo nin nisiling, “Na in yiru unitte ba.” Na nin dandaunu ba, kukulok kolsuno. ");
INSERT INTO amo_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Bitrus lizino ulire na Yesu nin bellinghe. “Kukulok mayitu kusa kolsuno ba, uma ti umusun yiru nin titat.” A nuzu ado udas adi gilu kang. ");
INSERT INTO amo_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nene na kitin shanta, vat na didya na priest iyawa nin na kukune na nite kpiliza umolun Yesu ku. ");
INSERT INTO amo_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Itere ghe inyaa mung idi nakpa ghe na caran Bilatus, ugumna. ");
INSERT INTO amo_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ku bi kongo Yahuda, ulenge na awa leu ghe nyene isuu Yesu ku ushara nkul, a deo kutin akurtuno ikurfunghe akut atat na iwa bya ghe na cara na priest didya nin na kune, ");
INSERT INTO amo_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","A woro, “Nati kulapi nlewe unan myii milau, min nan sali kulap.” Amma inun woro, “Ilele nsoo nyan kiti bit? Ulele ulawa ufin.” ");
INSERT INTO amo_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Atoo ikurfunghe nya kuti nlira, atunna anuza anyaa adi bana litime. ");
INSERT INTO amo_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Adya kutii nlire yira ikurfunghe inin woro, “Na ucaun i taa ile ikurfunghe nanya filaiye ba bara na ikurfung myii yari.” ");
INSERT INTO amo_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","I kpiliza ulire ligowe idi seru kunen nin nikurfunghe ki ka na ima kasu amaraku. ");
INSERT INTO amo_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Bara nani kunen kune idin yucu kunin, “Kunen nmyii” udak kitimone. ");
INSERT INTO amo_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Nani imon ile na Irimiya na beleng i kulo, na awa woro, “I yira ikurfunghe akut atat, uparashi ule na iwa ti liti me nnuzu na nit me Israila, ");
INSERT INTO amo_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ining na kiti kunenen, nafo na Cikilare na duru nani.” ");
INSERT INTO amo_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Nene Yesu yisina nbun ngumna, ugumne nin tiringhe, “Fere ugo na Yahudawe?” Yesu kawaghe, “ubelle nani.” ");
INSERT INTO amo_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Bara nani na i wa din pizirughe nin kulapi, na akawa nani imon ba. ");
INSERT INTO amo_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Bilatus nin woroghe, “Uku lanza imon ile na idin belu litii fe?” ");
INSERT INTO amo_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Bara nan na a kawa ligbulang lirumba, bara nani ugumne kifo unuu me. ");
INSERT INTO amo_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kubin buki mene ugadwari ugummne suun nkon kucin ko na anite fere. ");
INSERT INTO amo_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Nkuni kube i wadi nin kon kucim kugbas lisa me Barabas. ");
INSERT INTO amo_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Na izuru vat kiti kirum, Bilatus woro nani, “Ghari idi nin su insun minu ame? Barabas sa Yesu ule idin yicu KKristi?” ");
INSERT INTO amo_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Bara na ayiri i wa nakpaghe bara nshinari. ");
INSERT INTO amo_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Na a wa sosin kutet nwucun nliru uwani me tooghe nin kadura a woro, na uwati imon nin kadura a woro, “Na uwati imon nin nit une ba. Bara na inneu kitimone nanya namoro bara ame.” ");
INSERT INTO amo_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","A didya kutiii nlira nang na kukune ntardu nacara kutii nlira risa ligosin na nite i woro, idi nin su Barabas, imolu Yesu ku. ");
INSERT INTO amo_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ugumne tirino nani, “Ghari nan wabe idi nin su in cin minu ame?” I woro, “Barabas.” ");
INSERT INTO amo_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Bilatus woro nani, “I yari mma ti nin Yesu ule na idin yicughe Kristi?” Vat mene kawa i woro, “Kotin ghe kitene kucan nkull.” ");
INSERT INTO amo_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Anin woro na nin, “Bara iyang, kulapin nyanghari ataa?” Bara nani ighantina ti uwi mene kang, “Katin ghe ku can nkull.” ");
INSERT INTO amo_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Bara na Bilatus nyene na a wa sa a wantina nani ba, banin nani ayene i cizina ufeuj nibinai, i yira myein, akusu acara me mbun ligozin na nite, a woro, “Na myein nin duku nin nang sali kulapi ulele. Yeneng ati mene imon ile na ima tighe.” ");
INSERT INTO amo_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Anite vat woro, “Na nmyii me so natii bite udu nono bite.” ");
INSERT INTO amo_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Anin suna nani Barabas ku, aning nakpa nani Yesu ku idi kotinghe kucan nkull. ");
INSERT INTO amo_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","A sojan gumne yira Yesu ku udu nanya kitin yisizunu kutiin nwucun nliru idi pitirin a soje vat. ");
INSERT INTO amo_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","I kalaghe imon kidowome vat itaghe imoon licin kidowe. ");
INSERT INTO amo_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Inin kyele kitik tigoo namart itaghe liti, i taghe uca ncara uleme me inin tumunu nbun me idighe liyom, idin belu, “Ulai dandaun Ugo na Yahudawa!” ");
INSERT INTO amo_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","I tufuzunghe ataf, i bolo ucan na cara me i kpizoghe mun kitene liti. ");
INSERT INTO amo_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Na imala usughe liyarne, i kala imonne na itaghe kidowe, ishonghe inme, ini nya ninghe cindi kutinu kucan kull. ");
INSERT INTO amo_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Na inuzu udas, I se umong unit kunang sirmi lisa me simon, uli na iwa boroghe iyizi a nya nanghinu bara anan yauna kucan nkull me. ");
INSERT INTO amo_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Idaa kankiti na idin yicu Ugolgota, kite na idin sumun, “Kiti na kankang nati.” ");
INSERT INTO amo_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Inaghe nmyein me gbalala a sono. Na a buti minin, na a yino usone ba. ");
INSERT INTO amo_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Na ikofinghe ikoso imoon kito wome nin kuriya. ");
INSERT INTO amo_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Inin suu idin yenju ghe. ");
INSERT INTO amo_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","|Kitene litime i Yertine lo ligbulanghe na li woro, “Yesuari, ulele ugo na Yahudawa.” ");
INSERT INTO amo_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","A kiri aba wa di ninghe kitene kuce, warum ncara ulime, warum ncara ugule. ");
INSERT INTO amo_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ale na idin katizu zugizoghe, idin zinlu ati mene ");
INSERT INTO amo_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","inin din belu, “Fe ule na uwadin woru uturiin atat! Tucu litife andi fe Gono Kutelleari, tolo kitene ku can nkull kone!” ");
INSERT INTO amo_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Nanere adidya kutiin nlire wadin sisughe ligowe nanang niyerte nin nakukunen ntardu nacara kutii nlira, nin wor, ");
INSERT INTO amo_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ana tucu among, na a wasa atucu litime ba. Amere Ugoon Israila. Na atolu kitine kucan nkulle, ti ma nin yinun ninghe. ");
INSERT INTO amo_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ana yinin min Kutelle. Na Kutelle tucughe nene a wadi nin suwe, bara ana woro, 'Meng Gono Kutelleari.'” ");
INSERT INTO amo_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","A kire na i wa kutin nani ligowe taghe liyarin lirume. ");
INSERT INTO amo_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Nene ucizinu kubi kun tocin insirti talo nmgeine vat udu kubi kun zakure. ");
INSERT INTO amo_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Udu kubi kun zakure, Yesu taa intet nin liwui kang a woro, “Eli, Eli, lama sabachthani?” na idin nufi, “Kutelle nin, Kutelle nin, iyarin taa usuni?” ");
INSERT INTO amo_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Na ale na iwa yisin kupoowe nlanza nani, i woro, “Adin yicu Iliya ku.” ");
INSERT INTO amo_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Kitene umong ta ucum a di yiru usoso, a lumu unin nin myein mi gbalala, ataa nca ujangaran a nakpaghe a sono. ");
INSERT INTO amo_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Kagisin mene woro, “Sunanghe tiyene sa Iliya ba dak ada tucughe.” ");
INSERT INTO amo_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesu nin ghantina liwui nin teet anin suna nfep me a kuu. ");
INSERT INTO amo_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Bara nani azanin kesu kiti kilau kutii nlire marta tiba unuzu kitene udak kadase. Kutine nin zuluno kang, apara martiza. ");
INSERT INTO amo_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ni sek wa pozun, abe na nit alau ale na iwa nun fitiza. ");
INSERT INTO amo_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","I nuzu nanya niseke na ame nfita, a pira kipin kilau, a duro anit gbardan litime. ");
INSERT INTO amo_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nene na asoje nyene nani nan nale na iwadin yenjun Yesu ku yene uzulunu kutine nin nimonile na isee feu da nani kang inin woro, “Kidegene Gono Kutelleari kane wadi.” ");
INSERT INTO amo_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","A wani gbardan na iwa dufin Yesu ku unuzun Galili inan di kye ghe waduku idin yenju vat iyisina piit. ");
INSERT INTO amo_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Nanya mene Maryamu Magdaliya, Maryamu unang Yakub, nin Yusufu ning naa nnonon zibide. ");
INSERT INTO amo_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Na kulelen nda, umong unan nikurfung kunan Arimatiya, lisane Yusufu, ule na awadi gono kaduran Yesu. ");
INSERT INTO amo_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ada see Bilatus ku atiringhe kidowon Yesu. Bilatuse woro nani i ninghe. ");
INSERT INTO amo_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Yusufu yira kidowe, a gbincilo nanya mayapi ma boo, ");
INSERT INTO amo_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","a nunku nanya kisek kipese kanga na awa wuzu nanya natala. Anin tarda llitala kibulun kiseke anin nya. ");
INSERT INTO amo_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maryamu Magadaliya nin leli Maryamu wa di kikane, i sosin idin Yenju kideke. ");
INSERT INTO amo_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nin kurtunun koiye, lo na liwa kafin, lirin shiri, a didya kultiin nlira nin na Farisiyawa wa pitirin nan Bilatus. ");
INSERT INTO amo_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","I woro, “Cikilari, ti lizino na unang kinu kane wadi nin nlai a wa woro, 'Mbaya nayiri atat nma fitu tutung.' ");
INSERT INTO amo_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Bara nani ta anit idi yenje kiseke udu liri lin tatte. Bara nono katwa me wada tuughe i belle anit au, 'Afita nanya kiseke.' Kinu kin mbe wa kata kin burne.” ");
INSERT INTO amo_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Bilatus woro nani, “Yiran unan ncaa. Can idi kiliin kitene vat.” ");
INSERT INTO amo_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Bara nani i do idi kilin Kiseke vat, itursu litale inin ceu anan ncauleku. ");
INSERT INTO amo_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nene na Asabat wa cinu ukatu, a icina upiru liri lin finnun nsati, Maremu Magdalin nin leli Mareme da ida yene kiseke. ");
INSERT INTO amo_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Itunna iyene ina su uzulunu kutyin kang, bara kunan kadura Kutelle wa tolu unuzu kitene kani, ada turno litale, anin so kitene linin. ");
INSERT INTO amo_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Uyenju me wadi nafo umalizunu nwuru, a imon me wa pugun nafo aduga. ");
INSERT INTO amo_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Anan cawe nketuzu ninfiu inin so nafo abi. ");
INSERT INTO amo_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Unan kadura Kutelle lira nin nawane, aworo nani, “Yenje iwa lanza fiu, bara nyiru idin pizuru Yesue ku, urika na iwa kotinghe. ");
INSERT INTO amo_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Na adi kikane ba, amal fitu, nafo na awa belin minu. Dan ida yene kiti kanga na Cikilare wa non ku. ");
INSERT INTO amo_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Can mas idi bellin nono katwa me, 'Afita nanya nanan kul. Yenen amini nbun mine udu Ugalili.' Ima yenughe kikane, yenen, nbelin minu.” ");
INSERT INTO amo_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Awane tunna inya kiti kisseke nin fiu nin nayiabo kan, nin cum ndi bellin nono katwa me. ");
INSERT INTO amo_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Yesu tunna azuro nan ghinu aworo, “Ishawan.” Awane da, ikpa abunu me, inin sughe usujaida. ");
INSERT INTO amo_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yesu nin woro nani, “Yenje iwa lanza fiu. Can idi bellin nuana inya udu Ugalili. Kikane, ima yenii.” ");
INSERT INTO amo_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Na awane wadi ncin, vat nanan cawe pira nanya kipine idi bellin Ugo na Prieste vat nimon ilenge ifara. ");
INSERT INTO amo_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Na a Prieste wa zuro nin nakune isu ulire nan ghinu, ina anan tecu natine ikurufun gbardang. ");
INSERT INTO amo_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Inin woro nani, “Belle among non katwan 'Yesu' na dak nin kitik ida tuzu kidowo me a arik yita nmoro.' ");
INSERT INTO amo_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Asa uliru ulele nduru kitin gumna, tima sonu litime na ama su minu imonimon ba.” ");
INSERT INTO amo_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Asoje sere ikurfughe, itunna isu nafo na ibelle nani isu. Uliru ulele mala kiti nanya na Yahudawa, uleo ubun tutung udak ko kube. ");
INSERT INTO amo_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ama inung nono katwa likure nin warum nya udu Ugalili, udu likup longo na Yesu wa woro nani ido. ");
INSERT INTO amo_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Na iyeneghe, isughe usujada, among yitan shaka me. ");
INSERT INTO amo_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu da kiti mine, alira nan ghinu aworo, “Likara vat kitene kani nin lin kutyin, inani nacara ning. ");
INSERT INTO amo_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Bara nani, can nanya nipinpin nyii idi su uwazi ise nono katwa. Ishintu nani nmyen nanya lissa Ncif, nin Saun, a Uruhu ulau. ");
INSERT INTO amo_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Dursuzon nani idofin vat nimon ile na nna bellu minu. Tutung yenen, Ndi ligowe nanghinu kolome liri, udu ligan nyii.” ");
INSERT INTO amo_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ulele unighere ucizunun nliru umang un Yisa Kriti, Gono Kutellẹ. Nane nafo na ina nyer ");
INSERT INTO amo_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","tu nan nya niyerten Ishaya Gono kadura, ''Yene, Meng ma tu nin nan kadura nbunfe urika na aba wesufi libau. ");
INSERT INTO amo_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Liwuin nmong na adi yichu nan kusho, kelen libau NCikilare, tan udina me yita dert.'' ");
INSERT INTO amo_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Na Yuhana wa dak, awadi nshintu nanit mmyen nan nya ntene a yita kagbaran nbeleng chinu lidu linazang nin sen kusu nalapi. ");
INSERT INTO amo_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Kipin Yahudiya vat nan nanitin Urshalima nuzu udu kiti me. Vat mine ishitino nani mmyen nacharame nya kurawan Yahudiya, arika na iwa bellu alapi mine. ");
INSERT INTO amo_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yuhana wa su kuyok nin kukpan nsup kuronkomi, a kutino me wa terin nin belt kukpa, imoli me wa di aching nin titong kusho. ");
INSERT INTO amo_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Asu uwazi aworo, ''Umong din chinu kimal nin urika na akatini nin likara, na nbatin nwo in tumuno nbunku tii na kpatak me ba. ");
INSERT INTO amo_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Meng din shintu minu mmyen kurawa, ame basu minu ushitoe nin nfip Kutellẹ.'' ");
INSERT INTO amo_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Imone daso nayiri anẹ na Yisa wa dak unuzun Nazaret kusarin Galili, Yuhana da shintighe nan nya mmyen kurawan Urdun. ");
INSERT INTO amo_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Kube na Yisa nuzu nan nya mmyene, a to iyizi ayene kitene kani npuno, Nfip Kutellẹ tollo udak kitime nafo kuwullung. ");
INSERT INTO amo_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Liwui tutung kuru linuzu nan nya kitene kane, ''fe'ari Gono kin nayi ning. Indi nin liburi libo ninfi kang.'' ");
INSERT INTO amo_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nfip Kutellẹ tunna uyaunghe dedei udumun nan nya kusho. ");
INSERT INTO amo_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Aso nan nya kushoe ayiri akut anas, shaitan sughe ugwaji. Awa so ligowe nan ninawan tene, anan kadura Kutellẹ sughe katwa nimon irika na awadi nin suwe. ");
INSERT INTO amo_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kimalun kifun Yuhana, Yisa da Ugalili ada jarta uliru umang Kutellẹ, ");
INSERT INTO amo_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","anin di du, '' kubẹ nkulo, kuti tigo Kutellẹ nda susut. Sunan alapi iseru uliru umang.'' ");
INSERT INTO amo_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Achina ukatu nbii kurawan Galili, a to iyizi ayene simon ku nin Andirawus gwanan Simon nawa din kifizu nibo nin nitaru me nan nya kurawe, bara na katwa mine wadi ndwanghari. ");
INSERT INTO amo_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yisa woro nani, dofnani, nba kpiliu minu iso anan ndwang nanit asurne.'' ");
INSERT INTO amo_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Itunna ita mas iderne imon nkifizu nibowe idofin ghe. ");
INSERT INTO amo_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Kube na Yisa wa chachan ubun, båt, ayene Yakubu ku usaun Zebeden nin Yuhana gwaname; iwadi nan nya zirgin mmyen iyita nkye nimon nkifizu nibon. ");
INSERT INTO amo_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ayichila nani dedei, inuzu ichino uchif mine Zabadee nan nya zirgi ligowe nin nachin katwawe na iwa yiru nani, idofinghe. ");
INSERT INTO amo_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Nin piru mine nan nya Kafarnahum, deidai liri na Sabbath a pira nan nya kutin lira a tunnan dursuzu nanite. ");
INSERT INTO amo_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Umamaki kifo nani nin dursuzu me, bara na awa dursuzo nani nafo ule na adin nin tigoh a na nafo adidya niyerte ba. ");
INSERT INTO amo_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ki kane nan nya kutin lire, umong unit wa duku nin ruhu unanzang. A ta intet. ");
INSERT INTO amo_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Iyanghari nmyen feku nan ghirik, Yisa kunan Nazaret? Udå uda molu nariya? In yiru fe ghari. Fe unit ulauwari unuzu Kutellẹ!” ");
INSERT INTO amo_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Yisa kpada agbergenue a woro nani, “Tan tik nuzun nan nya kidowo me!” ");
INSERT INTO amo_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Na uruhu unanzaghe iyaughe ukpeo kutein, uruhu jarta nin liwui kang unin nuzu nan nya me. ");
INSERT INTO amo_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Anite vat umamaki kifonani, itunan tiru nanit mine, “iyaghari ilele? Udursuzu upese nin tigoh! Adin kpadizu tiruhu ti nanzang wang, inani din dortu uliru me.” ");
INSERT INTO amo_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Na nin molu kubi ba ubeleng me mala kiti udu nan nya vat nigbiri nkilinun Galili. ");
INSERT INTO amo_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Dedei na iwa nuzu isuna kuti kudya nlire, i nya idi piru ngan Simon nin Andrawus, ligowe nin Yakubu a Yuhana. ");
INSERT INTO amo_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Nene ise unan wanin Simone non nin konu kidowo. Ittunna i belle Yisa ku ubelleng me mas. ");
INSERT INTO amo_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","A tunna ado a kifoghe nchara, a fyaghe kiti linoninghe; ukone tunna uchinghe, a tunna nsunani likanju. ");
INSERT INTO amo_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Nin kubi kuleleng, na uwui ndeo, ida nin nanan tikonu vat kitime nin na lenge na idi nin na gbergenu. ");
INSERT INTO amo_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kipine vat da zuro ligowe kibulunghe. ");
INSERT INTO amo_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","A shino nin nanan tikonu ngangang gbardang, anutuzuno agbergenu tutung gbardang. Na awa yinin agbergenue su uliru ba bara na iyirughe uworsu. ");
INSERT INTO amo_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","A mu ufitu nin kwi dinding a kiti dutu yilili a gya udu kan kiti usanme rututu, adi su nlira ku. ");
INSERT INTO amo_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon nin nalenge na iwadi ligowe tunnan pizuru kitika na aduku. ");
INSERT INTO amo_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Na iseghe, iworoghe nenge, “Vat nanit din pizuru uyenu fe.” ");
INSERT INTO amo_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","A woro ne, “channari tido nkan kiti ugang, tinuzu udu nan nya nigbiri nkilinu kipine, nnan disu uwazi kusari kone wang. Imon ilenge na ina nutuniari une nda su.” ");
INSERT INTO amo_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Apicha niti niti vat nan nyan Galili, asu uwazi nan nya nati nlira mine a nutuzuno agbergenu. ");
INSERT INTO amo_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","42 Nkon kukutule da kitime; adin foghe nachara a tumuno nin nalun. Aworoghe nenge, “ Andi uba yinnu, uwasa ushino nin mi lau.” ");
INSERT INTO amo_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yisa do susut nin kune-kune a nakpa uchara adudoghe, adi sughe, “iyinna. Talau.” ");
INSERT INTO amo_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tikutule tunna ti chinghe dedei, a shino lau. ");
INSERT INTO amo_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yisa kpadaghe nin likara anin nutughe mass a gya. ");
INSERT INTO amo_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","A woroghe “yenje uwa bellin umong unit, can udi durso litife kitin Priest ngma, udi ni mong ilenge a Musa na woro inuzu bara ukusu litife, inan so usheda kiti mine.” ");
INSERT INTO amo_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ana nuzu a tunnan bellu kogha ku. Unite malakiti nin lirue kang, imone ta na Yisa nse upiru nan nya kipine tap ba; adi so nan nya ntene anite nin tunnan duzu kitime unuchu niti-niti ngagang. ");
INSERT INTO amo_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Kimal nayiri båt Yisa wa kpilin Ukafarnahum, na nin molu kubiba ulire ta bú Yisa di nan nya kilark. ");
INSERT INTO amo_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Na nin dandaunu ba, anit pitirino gbardang kite Yisa wa duku Lisosine wa di gbardang kilare kulo. Na kiti liyisin wa duku ba, ko kupo kibilun wang. Yisa belle nani uliru Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Among anit nanas da nin nan riu nfunu kitin Yisa nya kilarie. Inung nanase wa yaughe kupe linoni me. ");
INSERT INTO amo_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Na iwa se uduru nin nite kitin Yisa ba, bara ngbardang ligozi nanit. Itunna ighana fitulleri kutiye ikulu indert kiti liyissin me. Itotino unan riun nfunne ligolong filullerue ubun in Yisa. ");
INSERT INTO amo_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Na Yisa yene uni nibinayi mine, aworo unan riu nfune, “Gononing nkusu alapife.” ");
INSERT INTO amo_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Among anit anan dursuzu lidu na Yahudawa wa sosin kite. Ichizina upilizu nan nya nibanayi mine. ");
INSERT INTO amo_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Unit ulele din yenju ame ghari? Ule ulire tizogo Kutellẹri nin fo figiri! Kutellẹri cas wasa akusu alapi.'' ");
INSERT INTO amo_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yisa tunna ayinno imon ile na iwa din kpiluzue nibinayi mine, a woro nani, ''inyaghari nta idin kpiluzu nile imone nibinayi mine? ");
INSERT INTO amo_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Uyeme ma katini nin nworo, 'Nkusu alapi fe' sa 'Nworo fita yira imon linoni fe ugya'? ");
INSERT INTO amo_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Bara inan yinno Gono Nnit di nin likara in yii a kala alapi, ''abelle unan konu nfunue. ");
INSERT INTO amo_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Nworo fi, fitå, yauna kupe fe, ukifo libau udu kilari fe.” ");
INSERT INTO amo_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","A fita deidei a yauna kupewe, anuzu nan nya kilare nbun na nite vat. Na iyene nani vat mine umamaki kifonani isu liru Kutellẹ, iworo, “nworu natidi na tisa yene imus nile imone ba.” ");
INSERT INTO amo_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Akuru a nuzu udu ubiu kurawa vat ligozin nanite da kiti me, a tunna in dursuzu nani. ");
INSERT INTO amo_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Na awa chinu ukatu ayene Levi ku usaun Alfiyus, na awa sosin kitin sesun gandu aworoghe, “Dofini” A fita a dofinghe. ");
INSERT INTO amo_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Kube na Yisa wa din linimoli nan nya kilarin Levi, anan wewun gandu nan nanan nalapi gbardang wa sosin ligowe nin Yisa a nono katwa me in linimoli, anite na iwa di dortu ghe wa di gbardang. ");
INSERT INTO amo_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Kube na anan niyerte, ale na idi a Farisawa iyene Yisa ku sosin nlinimoli ligowe nan nanan sesun gandu a anan nalapi, iworo, “Iyanghari ta a din li nimonli ligowe nan nanan sesun gandu a anan nalapi?” ");
INSERT INTO amo_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Na Yisa lanza nani a woro nani. “ Anit ale na idi acine na idin pizuru kabere ba; ale na idi nin tikonari cas di nin sun kabere. Na Nna dak Nda yichila anit alauwa ba, bara anan nalapiri Nna dak.” ");
INSERT INTO amo_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nonon massu katwa Yuhana nin na Farisawa wa din kotu nayi. Idå ida woroghe, bara iyanghari ntå nonon massu katwa in Yuhana nin nonon massu katwa na Farisawe dinsu ukotu nayi, na ninfi nono katwe nsue ba?” ");
INSERT INTO amo_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yisa woro ani, ''Anwapardu wasa isu ukotu nayi a kwanyana tiyome dutu ku ligowe nan ghinue? Kwanyana tiyome nwa dutu ku nan ghinu na iwasa isu ukotu nayi ba. ");
INSERT INTO amo_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ayiri ba dak na iba da yiru kwanyana tiyome kiyitek nayiri anere iba nin zu ukotu nayi. ");
INSERT INTO amo_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Na unit wasa a vå kupari kupese kitene kulutuk kukuse ba, kupese ba ti kukuse jarta jazi jazi. ");
INSERT INTO amo_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Na umong wasa ata nmyen narau mipese lissu kuse ba, awa su nani lissuwe ba tutu nmyen narauwe malu kiti nin lissuwe vat. Bara nani, ta nmyen narau mipese nan nya lissu lipese.'' ");
INSERT INTO amo_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Liri Nasabbath Yisa pira nan nya kunen nilarum, nonon massu katwa me tunna ncin pucu nati nilarume icin leo. ");
INSERT INTO amo_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","A Farisawa woroghe, '' Yene, inyagharin ta idin su imon ile na icau isu liri Nasabbath ba?'' ");
INSERT INTO amo_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","A woro nani, ''Na anung na gbin nan nya niyerte ba, imon ile na Dauda nin nanit me wasu na kukpon wa nani ba? ");
INSERT INTO amo_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Na awa piru nan nya kilari Kutellẹ kubi kongo na Abiyatha wadi UPriest udya, aleo ufungal ulau ule na uduka nworo na umong wasa aleo se a Priest cas; akuru ana ale na iwadi ligowe nin ghe?'' ");
INSERT INTO amo_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yisa woro, ''Iwake Asabbath bara unitari, a na unit bara Asabbath ba.'' ");
INSERT INTO amo_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Bara Gonon Nit Chikilarairi wang un na Sabbath. ");
INSERT INTO amo_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Yisa kuru a pira nan nya kuti Nlira kudya, umon unan kotun ncara yita nan nye. ");
INSERT INTO amo_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Idinaghe iyizi iyene sa aba shinu ninghe liri na Sabbath. Iwadin pizuru finu nliru fo na iba seghe nin tånu. ");
INSERT INTO amo_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yisa woro unan kotun chare, ''Fita u yisin kitik mine,'' ");
INSERT INTO amo_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","A nin woro nanite, ''uchau nworu isu katwa ma gegeme liri na Sabbathe sa kananzang; isun ulaiya sa imolu?'' Itunna iso tik. ");
INSERT INTO amo_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","A gitirno ayenje nani vat nin tinanayi, bari ngbas nibinayi mine, aworon nnite, “Nakpa uchara fe.” A nakpa unin Yisa tunna akurtuno uni uchine. ");
INSERT INTO amo_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","A Farisawa nuzu deidei isu uzuru nan na Horidiyawa, i tere tinu mine urum, inan se libau nmolughe. ");
INSERT INTO amo_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Yisa tunna a gya nin nono katwa me udu kurawa. Ligozin nanit gbardang dofino unuzun nan nya Galili nin Yahudiya, ");
INSERT INTO amo_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","nin nuzun nan nya Urushalima, Idumiya udu duru nbun urdun udu kusarin Tayar nin Sidon. Ligozin nanit lanza vat imon ile na awa din sue, itunna ida kitime. ");
INSERT INTO amo_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","A woro nanan katwa me iceo uzirgin nmyene susut, bara ligozi nanite wa pardizughe kang, bari gbardang mine, iwa masin nafo ima turunghe. ");
INSERT INTO amo_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ashino nin nanit kang, gbardang nale na iwa di nin tikonu ngangang wa din shò nati nwo ise ududughe. ");
INSERT INTO amo_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Kubi ko na anan na gbergenu wa yeneghe, nò kutein nbun me nin kuchulu, iworo, “Fe Gono Kutellẹri.” ");
INSERT INTO amo_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","A kpada ani kang nin likara yeje iwa tinani anit yinighe. ");
INSERT INTO amo_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","A ghana kitene likup, anin yichila ale na adin nin suwe itunna ida kitime. ");
INSERT INTO amo_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","A fere likure nin nan waba (ale na awa ninani lisa, nono kadura), bara inan so nin ghe ligowe anan tuzo nani udun di sun wazi, ");
INSERT INTO amo_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","inan se likaran nnutuzunu na gbergenu. ");
INSERT INTO amo_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","A fere likure nin nan waba: Simon anaghe lisa Bitrus; ");
INSERT INTO amo_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakubu usaun Zabedi, nin Yuhana gwanan Yakubu (alenge na awa ni nani lisa Boanerges, watu nonon ntutuzu); ");
INSERT INTO amo_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","nin Anderawus, Filibus, Bartalamawus, Matiyu, Toma, Yakub usaun Alfiyus, Taddawus, Simon Zelotu, ");
INSERT INTO amo_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","nin Yahuda Iskariyoti ule na aba lewughe. ");
INSERT INTO amo_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","A tunna a gya udu kilari, ligozin nanite zuro gbardang tutung na ise kubi nli nimonli wang ba. ");
INSERT INTO amo_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Na anan game nlanza ubelenghe, inuzu udun di yichulughe, iworo kibinaye nwulu. ");
INSERT INTO amo_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Anan niyerte na iwa dak unuzun Urshalime woro, “ Adumun nagbergenu unuzun Beelzub,” tutung “nan nya likara ndya nagbergenuari adin nutunuzunu agbergene mun.” ");
INSERT INTO amo_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yisa yicila nani udak kitime a belle nani uliru nin tinan tigoldo, “ Iyiziari Shetan ba nutunu Shetan ku? ");
INSERT INTO amo_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Kipin tigoh nwa gatizin kiwasa kiyisina ba. ");
INSERT INTO amo_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","I wa din woro kilari ngatizinawang, na kiwasa kiyisina ba. ");
INSERT INTO amo_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Andi Shetan nfita akoso litime, na awasa a se likara inyisinu ba, tutung imalin mere ine. ");
INSERT INTO amo_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Na umon wasa apira kilarin nan likara a tuzu imonme sa uworo atu atere unan likare ba. Anin se likara likiri nimone nya kilare. ");
INSERT INTO amo_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Kidegenghari ndin belu minu, vat nalapi nanit asurne iwasa ikusu anin, umunu ngbasin nazu lisa Kutellẹ na anit din su; ");
INSERT INTO amo_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Vat nlenge na alawan gbas nnanzu lisa Kutellẹ nin Fip me na iwasa i kusu koni kulape ba, uleli unite sosin nan nya ndere kulapi sa ligang.” ");
INSERT INTO amo_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yisa wa belin ulire nani bara na iwa din du au “Adinin funu unanzang.” ");
INSERT INTO amo_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Uname nin nuana me da kitime ida yisina ndas. I tó iyicilaghe. ");
INSERT INTO amo_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ligozin sosino ikilighe, i lirina ninghe, “Naffine nin nuanafe yisin ndas, ayedi nani iyinin kiti ka na uduku.” ");
INSERT INTO amo_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","A kpana aworo nani, “A yaghari a nanighe nan nuananighe?” ");
INSERT INTO amo_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","A yenje anite na isosin na iwa kilinghe, a woro, “yenen alele re an nanigh nan nuana nighe!” ");
INSERT INTO amo_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Vat nlenge na adin su imon kibinayj Kutellẹ, unitere gwananing kilime, a gwananing kishono, amere tutung unaning.” ");
INSERT INTO amo_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Tutung acizina udursuzu nani nbiu kuli. igozi nanit gbardang kilinghe, apira nan nya zirgin nmyen acha-chana udu nan nya kule, aso nan nye. Vat ligonzighe wa di mbiu kule. ");
INSERT INTO amo_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","A dursuzo nani imon gbardang nin tinan tigoldo, nan nya dursuzoe, a woro nani: ");
INSERT INTO amo_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","Lanzan unan tibila wa nusu udu tibila. ");
INSERT INTO amo_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Adi tibile, imong imus disso libau, aying da zoto ining. ");
INSERT INTO amo_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Imong imus disso kupanbaran, bara usalin nmyin, imuse nuzu deidei, bara na nmyine wa di tendeleng. ");
INSERT INTO amo_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kube na uwui wa ghana, bara na nmyine wadi tendeleng kutyiene pya itunna ikoto. ");
INSERT INTO amo_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Imon imus disso nan nya nimart. Na imarte kuno itunna iparda ining na ita iyip ba. ");
INSERT INTO amo_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Imon iyip disso kutyen kucine ikunjo ini yatina ita kpasharak. ining macha ita iyoli, imon akut atat, imon akut kutocin, imon akalt-akalt ikata intibile.” ");
INSERT INTO amo_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Aworo “ Ulenge na adinin natuf in lanze na alanza.” ");
INSERT INTO amo_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kube na Yisa wa di usamme, ale na iwa di susut ligowe nighe nin nono katwa me likure nin nan waba itiringhe tigoldo tone. ");
INSERT INTO amo_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","A woro nani, “Anunghere ina ni minu uyiru nimon ilenvge na iyeshin kipin tigo Kutellẹ. Inung ale na idin das ko iyeme imon mine se nin tinnan tigoldo, ");
INSERT INTO amo_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Bara uyenje, eh ba yenju, vat nani iba yenu ba, bara ulanzu, eh ba lanzu, vat nani na iba yinnu ba, bara iwa kpilin kiti Kutellẹ akusu nani.” ");
INSERT INTO amo_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Aworo, “Na anung nyinno ko kugolde ba? Ibati iyiziari iyinin kagisin tigolde? ");
INSERT INTO amo_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Unan tibile wa bilsu uliru Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Imus ilenge na iwa dissu libau, inughere alenge na iwa lanza uliru Kutellẹ itunna isere deidei, asa Shetan nnin da nin kujijing me abolo ulire nan nya nibinayi mine. ");
INSERT INTO amo_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Inughere ilenge na iwa dissu kitene kupanbara, inughe wa lanza uliru Kutellẹ asa itunna isere unin deidei nin nayi-abo; ");
INSERT INTO amo_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Na iwa di nin tiling liyisin nin nakara ba, asa itere ayi nin kabiri båt; na licin nin niu nda bara ulire itunna isarta ideo. ");
INSERT INTO amo_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Imong ilenge na iwa bilsu nan nya nimart. Inneghare wa lanza ulire. ");
INSERT INTO amo_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","nin nanere adadun inyi, nin tok kagisin nimon in yï, nin lanzu mmang parda ulire, itunna iso hem. ");
INSERT INTO amo_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ilenge na iwa bilsu kutein kucine, inneghare ilenge na iwa lanza uliru Kutellẹ isere nin liwui lirum imaca gbardang, imong akut atat, imong akut kutocin imon akalt akalt ikata intibile. ");
INSERT INTO amo_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yisa woro nani, “uwa ti ula inpitilla asa ucheu unin nan nya kukuzughare sa nan nya lii. komi? Asa utarda unin in tadangha. ");
INSERT INTO amo_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Na imoimon yeshin ilenge na iwaghya idira upune ba, sa imoimon nan nya sirti na iba diru unutune ikanang ba. ");
INSERT INTO amo_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ulenge na adinin natuf nlanze, na alanza. ");
INSERT INTO amo_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Aworo nani, “Dinan atuf nimon ile na idin lanzu, kuyangi ko na uguro mun, kunnare iba guru fi mun ukuru use gbardang wang. ");
INSERT INTO amo_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Bara vat nle na adinin nimon iba kpinghe ku, ulenge na asalimun, kitime ima seru ilenge na adimun wang.” ");
INSERT INTO amo_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yisa woro, “Kipin Tigö Kutellẹ masin fo unitari na awa bilsu imus kutein. ");
INSERT INTO amo_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Asa a nö nmoro afita kitik nin liring, imuse nuzu ikuno ame löng, na asa yiro nin tikunnanghe ba. ");
INSERT INTO amo_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kutyiene asa kunutno imus nin litime ita ticilak, itunna nabaga, inin kunjo ida nutuno ati inin ta iyip. ");
INSERT INTO amo_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Kubi ko na ilewe inyini, ata mass ayira kuwatan a basa bara na kubin basu. “ ");
INSERT INTO amo_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Aworo, “iyapin imonari iba batu kipin tigoh Kutellẹ mun nin, tutung tiyapin tigoldori iba batizu mun? ");
INSERT INTO amo_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Timasin fo fiyip kukù, na iwa bilsu fi katin ko fiyapin fiyip nin cingiling na asa ibila kuttyien. ");
INSERT INTO amo_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Vat iwa bilu fining nani fi nuzu, asa fi kuno, fita kucha ku dyå fi kata acha vat nan nya kunene. Asa kuta tilang jakaka kang na agyin kitene kani wang asa ida ke tido mine nan nya nshine.” ");
INSERT INTO amo_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Nin tinan tigoldo gbardang nafo tone a bele nani uliru Kutellẹ, udu ligang longo na yiru ulanze. ");
INSERT INTO amo_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nin nani na awa sunani uliru sa tinang tigoldo ba. Nin nani ame ligowe nin nono katwa mere cas asa apuno nani ncasarak nlire. ");
INSERT INTO amo_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Lilole nin kuleleng aworo nani, channari ti kafi uleli uwule.” ");
INSERT INTO amo_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Itunna igya isuna ligozinghe. Nono katwa me gya ligowe naghe nan nya zirgin nmyen, bara asosin nan nya ligowe nanghinu. Ntong tizirgin nmyen wang ligowe waduku. ");
INSERT INTO amo_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Fiyilili nin funu udya tunna ufita nan nya kurawẹ, tikara nmyen tunnan pichu nan nya zirge utunna ulentina ukulu nin nmyen. ");
INSERT INTO amo_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ame Yisa wana din nmoro nan nya kadasi nzirge. Itunna ifyghe inin din sughe nenge, “Unan dursuzu nanit, tiba ku nan nya zirgi ulele afe nmora?” ");
INSERT INTO amo_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Na azinto, a kpada ufune, anin woro kurawe, ta shew, yisina tik.” Ufune tunna u kete, kurawe tunna kusina dang. ");
INSERT INTO amo_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Aworo nani nenge, “Bara iyaghari tå inani lanza fiu? Na iduu nin yinnu sa uyenu mine.” ");
INSERT INTO amo_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Fiu fidya wa kifo nani iworo nati mine, “imusin yapin unitari ulele di, na ufunu nin kurawa wang din dortu uliru me?” ");
INSERT INTO amo_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Idå ida kafina ule uwul kule, udu kon kusari nmyin nanit in Garasina. ");
INSERT INTO amo_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Nin nuzun Yisa nan nya zirgin nmyene, umong unit nin ruhu unangzang zuro ninnghe. Unite wa nuzu nan nya nisek. ");
INSERT INTO amo_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Unite wa sosin nan nya nisek. na umong wa duku ule na awasa a kifoghe ba, ma ining woro iterughe nin nyang. ");
INSERT INTO amo_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Iwa sö ntechughe ayiri gbardang nin ni nyang nan tiseleng nabunu me. Vat nani asa a tacha inyanghe umunu tiselenghe ku. Na umong wa dutu ku nin likara nworu aterughe ba. ");
INSERT INTO amo_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ko kame kitik nin lirin nan nya nisek nin nakup, asa tiza ntèt ayilizuno abasa kidowo me nin natala apapat. ");
INSERT INTO amo_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Kube na awa tü iyizi ayene Yisa ku pït, atuna gya nin cum adi zuro nighe a tumuno nin nalun nbun me. ");
INSERT INTO amo_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ajarta nin liwui lidya, “Iyanghari nba su ninfi, Yisa, Gono Kutellẹ Kudindya? Umunu nin Kutellẹ yenje uwa tï nneo.” ");
INSERT INTO amo_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Bara na Yisa wa din bellughe “Nuzu nya kidowon nnit ulele, fë uruhu unanzang” ");
INSERT INTO amo_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","A tiringhe, “Lisafe nghari?” Aworoghe “Lisaninghe libutari bara na ti karin.” ");
INSERT INTO amo_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Aso nfoghe nachara aworoghe na awa nutun nani nkoni kusari nyë ba. ");
INSERT INTO amo_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kikane kitene nakupe, ligö nalede wadi kileo ku. ");
INSERT INTO amo_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ifoghe achara iworoghe, “Turno nari nan nya ligö nalede tipiru nan nya mine.” ");
INSERT INTO amo_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ayina nani mun idi piru. Tiruhu tinanzaghe tunna tinuzu tipira ligö naledẹ, itunna ilala rididi udi piru nan nya kurawa. Ngbardang ligö naledẹ wa duru amui aba na nmyenẹ wa gya nin naning. ");
INSERT INTO amo_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Anan su ncha naledẹ gya nin cum uduṣnan nya kipin idi belli imon ile na ise nani, anit tunna inuzu gbardang udun ndi yenu nbelenghe. ");
INSERT INTO amo_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ida kitin Yisa, ida yene unite na awa di nan nya tishot nagbergenue sosin, a nin kirin a litulme kite. Fiu kifo kogha ku. ");
INSERT INTO amo_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ale na iwa yene imon ile na isü unit une na awadi nin na gbergenue imon ile na inung yene ikuru ibelle nani ubelle nalede ane. ");
INSERT INTO amo_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Anit ane na iwa dak kitin Yisa idin sughe kucukusu anuzu kagbiri mine. ");
INSERT INTO amo_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Unite na awa di neo nin na gbergenue da kitin Yisa kube na awa ciju upiru nan nya zirgin nmyen uchin nyiu. Unite tiringhe sa aba yinnu igya ligowe ninghe. ");
INSERT INTO amo_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yisa wantighe ugyu ligowe nan ghinu, aworoghe, “Chang kilari kiti nanit fe, udi belli nani imon ile na Kutellẹ nṣufi, nin kune-kune na asufi.” ");
INSERT INTO amo_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Unite tunna a gya adi malu kiti nin bellenghe vat nan nya Dikapolis imon ile na Yisa sughe mun. Vat mine tunna ita kpak. ");
INSERT INTO amo_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Kube na Yisa nkafina kurawe nan nya zirgin mmyene udu uleli uwule, ligozin nanit pitirno kupome, ame yisina ingau kurawe. ");
INSERT INTO amo_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Umon nan nya nadi dya kutin lira unan lisan Jairus, na awa yene Yisa ku, adeo nabunume. ");
INSERT INTO amo_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","A tunna nfoghe nachara kang, aworoghe, “ Kashono ni kabene din cinu ku. kusari ntafi da uda tardaghe uchara fe anan shinu ata ulai.” ");
INSERT INTO amo_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yisa gya ligo nin ghe ligozin nanit gbardang wufughe, i pardizaghe chot-chot. ");
INSERT INTO amo_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Umon uwani wa duku na awa din neu nin yenu naffa akus likure nin naba. ");
INSERT INTO amo_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Awa niu kang nachara nanan tikankan. Awultino nachara me vat. Na ashino ba, ukone na yitan kpizinu. ");
INSERT INTO amo_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Alanza ubelleg Yisa. A tunna a kyio kimal me achina nan nya ligozine adudo kubaga kulutuk me. ");
INSERT INTO amo_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Aworo na kibinayi me, “Inwa dudo kubaga kulutuk me chas, nba shinu.” ");
INSERT INTO amo_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Na a dudoghe uyenu nafa me tunna uyisina, a tunna alanza ashino nan nya in niu me. ");
INSERT INTO amo_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Yisa lanza deidei kidowo me likaran nuzu, a girtino nan nya ligozin nanite a tirino, “ghari dudo kultuk ning?” ");
INSERT INTO amo_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nono katwa me woroghe, “fen yene ligozin lole na ikilin fi unin woro gharin dudoiya? ");
INSERT INTO amo_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yisa gitirno yenju kiti anan yene sa ghari dudoghe. ");
INSERT INTO amo_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Uwani une nin yiru nimon ile na iseghe atunna ada nin fiu nin ketuzu kidowo a deu nbun Yisa a bellinghe kidegeghe vat. ");
INSERT INTO amo_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Aworoghe ''ushononinghe, uyinnu sa uyenufe nnafi ushinu. Chang nan nya nayi ashewu uso uchine, fang sa ukonu'' ");
INSERT INTO amo_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","A aduntun nliru nin wane, anit di dak unuzu kilarin nanbun kutin lirẹ, idin sughe, “ushonofe nku. Iyaghari nni nnan dursuzu nanite ijasi? ");
INSERT INTO amo_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Na alanza imon ile na idin belle, Yisa woro nnan nbun kuti nlire,”na uwa lanza fiu ba. Yinin fi cas.” ");
INSERT INTO amo_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Na awa yinnin umon nan nya nanite dofinghe ba, ma Bitrus nin Yakubu, a Yuhana gwanan Yakubu. ");
INSERT INTO amo_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ipira nan nya kilarin nnan bun kuti nlire. Yisa yene ubunkurunu kiti, anite nin di kuculu nin kalzun ntẹt. ");
INSERT INTO amo_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Na apira kilare, aworo nani, ''iyaghari nta ibukuro kiti nene, nin kuculu? Kabure nku ba, adin nmorori.'' ");
INSERT INTO amo_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Isisaghe tak, atunna anutuno nani vat ndas. Atunna ayira uchife nin nnan gone nan nalenge na iwa di ligowe, ipira nan nya kutiyẹ na gono wa nonku. ");
INSERT INTO amo_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","A kifo gonẹ inchara, a woroghe ''Talitha koumi,'' unnare, kabura, nworofi fita.'' ");
INSERT INTO amo_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","kabure fita deidei a tunnan chin (akus kanin likure nin nabari wadi). Anite vat umamaki kifonani. ");
INSERT INTO amo_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","A kpada nani nin likara yenje umon wa yinin imon ile na asu. A woro nani nanghe imonli ali. ");
INSERT INTO amo_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yisa nuzu kikane ada kipin me, nono katwa me dofinghe. ");
INSERT INTO amo_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Na liri na Sabbath nda, adursuzo nani nan nya kutin nlira. Indya nanit ale na iwa lanzaghe fiu kifo nani. Iworo, ''Nweri ana se ule udursuze ku?'' Uyapin uyirari ulele na Kutellẹ na nighe? ''Kayapin katwa fiu wari kane adin su nin nachara me?'' ");
INSERT INTO amo_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Na unan kisẹ kanere ulele, usaun Maremu, gwanan Yakubu nin Joses, a Yahuda nin Simon ba?'' ");
INSERT INTO amo_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yisa woro nani, ''Na unan liru nin nu Kutellẹ din diru ngogong ba, se nan nya kagbiri me nin likura me, a nan nya gamẹ,'' ");
INSERT INTO amo_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Na awa yinin usu kang katwa kadya nan nya kipinme ba, ma anan tikonu batari awa tarda nani achara ishino chas. ");
INSERT INTO amo_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Usalin yinnu sa uyenu minere na Yisa ku umamaki. A pira nan nya nigbiri mine adursuzo nani. ");
INSERT INTO amo_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","A yichila nono katwa me likure nin nan waba, a tonani inung nababa, a nani likara kitene tiruhohi tinanzang, ");
INSERT INTO amo_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","a ta nani ligan na iwa yiru imomon ba se ucan ncin. Na iwa yiru imonli sa nka likura, sa ikurfung najip mine ba, ");
INSERT INTO amo_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ima shonu akpatak nabunu mine, ba nin nalutuk aba. ");
INSERT INTO amo_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","A woro nani ''Asa ipira kilari, iso ku udu lirin gyu mine. ");
INSERT INTO amo_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Andi nkan kiti nnari useru munu, sa inari ulanzu munu, asa iba gyu kitẹ, ikotino lidau nabunu mine kitẹ, unan so imon bellu nati mine,'' Ndin belu minu kidegen, Usodom nin Gomora ma katunu nin lanzu nmang liri nshara nin kagbiri kane. ");
INSERT INTO amo_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Inuzu idin bellu anit icin alapi mine. ");
INSERT INTO amo_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Inutuzuno agbergenu gbardang, itinto anan tikonu, ishizuno nin ghinu gbardang. ");
INSERT INTO amo_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ugoh Hirdus lanza nani, bara na lisan Yisa wa nuzu kanang. Among yitang du au Yuhana unan sun Mbaptismari ina fyaghe nan nya kisek, bara nanere nta wang adin suzu matiza likara.'' ");
INSERT INTO amo_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Among mine woro, ''Iliyari di'.'' Among tutung woro au ''Unang kadura Nnu Kutellẹ ari, nafo umong nan nya kaduran nnu Kutellẹ na awadi nanan burnu.'' ");
INSERT INTO amo_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Na Hiridus nlanza nani aworo ''Yuhana na nwan kalaghe liti inan fyaghe.'' ");
INSERT INTO amo_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ame Hiriduse litime, wa ti ikifo Yuhana ku a tereghe nan nya kilari lichin, bara Hiriduya uwanni gwaname Filibus na awa nutu asu ilugma mun. ");
INSERT INTO amo_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Bara na Yuhane wa bellin Hiridus ku, ''Na uchau nan nya duka uyaun uwannin gwanafine usu ilugma mun ba.'' ");
INSERT INTO amo_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ame Hiriduya ta tinanayi kitenen lirun Yuhana, atunna a pizira umolughe. Ama na ase libau ba, ");
INSERT INTO amo_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","bara na Hiridus wa din lanzu fiun Yuhanẹ, bara ayiru Yuhana unan lanzun fiu Kutellẹri nin chin ukanang, unere ta Hiriduse gyesheghe bara imoi imon wa seghe. Kube na awa lanza uwazin Yuhana, asa fyaghe kibinayi, vat nanẹ, ata ayi abọ nin lanzun nlirun Yuhana. ");
INSERT INTO amo_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Na lirin nda na Hiriduya nsẹ kubi kongo na aba su imon kibinayi me, abata gai lirin kulu nayiri kumantin, Hiridus asu likanju limang bara Agoh nyi, Agoh likum nan nadidyan Galili, bara liburi libọ lirin maru me. ");
INSERT INTO amo_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Ushonon Hiriduya da ada su avu nbun mine, ata Hiridus ku nin namara me lanza nmang. Ugoh tunna aworo kuburẹ, ''vat nimon ilenge na udinin suwẹ, tirini nma nifi ining'' ");
INSERT INTO amo_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","A siloghe aworo, vat nimon ile na utirini, nba nifi, adi ma yitu udu kiyitik nayi tigo ning.'' ");
INSERT INTO amo_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","A nuzu udas adi woro nname, ''Iyaghari imba tiringhe?'' Unẹ woroghe ''Litin Yuhana unan sun baptisma.'' ");
INSERT INTO amo_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","A kpila mass udu nan nya kudarẹ kitin gohwe a woroghe, Ndinin su uni nene litin Yuhana unan sun baptisma nan nya kishik.'' ");
INSERT INTO amo_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Imone tunna ita Ugohwẹ yototo, ama bara isilingme nin namara a didyawe, na ayinno unari nimone na kuburen tirino ba. ");
INSERT INTO amo_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ugohwẹ tunna a tọ nkong kusoja nan nya nanan cha nin liru likara a dọ adi kala litin Yuhana a dak mun. Unan chawẹ do adi werin litin Yuhana nan nya kilari lichine. ");
INSERT INTO amo_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","A da nin litẹ na kishik ada na kubure, ame kubure na unamẹ. ");
INSERT INTO amo_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Nin lanzu nani, anan katwa me da ida yauna libẹ idi kasu. ");
INSERT INTO amo_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Anan kadurẹ pitiruno atimine kitin Yisa, ibelinghe vat nimon ile na isu nin nilẹ. ");
INSERT INTO amo_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Aworo ani dan vat min tido likot kiti ka na anit diku ba ida shin baat. ''Bara na among wadi idasu igyiza, na ise kubin shinu sa kun linimonli ba. ");
INSERT INTO amo_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Itunna igya nan nya zirgin nmyen udu kan kiti tik ussanminu. ");
INSERT INTO amo_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ama anite yene nani kubin gyiwẹ iyinno. Itunna iwufuani ligowe nin nabunu unuzu nigbiri-nigbiri, idi yarin nani udi durẹ. ");
INSERT INTO amo_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Kube na iduru ugauwe, Yisa yene ligozin, alanza inkune kune mine, bara na iwa masin fo ligọ nakam sa unan dortu nighinu. A tunna dursuzu nani nimon gbardang. ");
INSERT INTO amo_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Kiti tunna kita yilili, nono katwa me woroghe, ''kikane kiti kikoneri, tutung kitin mal cizunu usiru. ");
INSERT INTO amo_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Turno nani idọ na kipin nin nigin gbiri inan disesu umonli usammin.'' ");
INSERT INTO amo_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yisa kpana a woroani, ''Anung na nani imonlẹ ili.''I woroghe, ''Ti wasa tidi seru imonli nakalt aba ibatina naniẹ?'' ");
INSERT INTO amo_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Aworo nani, ''Idin nin nimalak imashina? Chan idi gbin.”''Kube na igbinọ, iworo, imalak itaun nin nibọ iba.'' ");
INSERT INTO amo_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","A ta anitẹ vat iso abut-abut kitenen kpi ushifi. ");
INSERT INTO amo_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Na isọ abute; among akalt akalt, among akut a taun-taun. ");
INSERT INTO amo_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","A yauna imalak itaune nin ninbo ibẹ a ghatina kitene kani, a ta nmari ku, anin na nono katwa me ikoso ligozin nanitẹ. ");
INSERT INTO amo_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","I leo imonli ine vat mine kogha shitu gbem icinọ kagisighe. ");
INSERT INTO amo_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","I pitiro kagisighe ita nakuzung likure nin naba. ");
INSERT INTO amo_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","A rika na iwa li imonlẹ, nalililme amui ataunari wadi. ");
INSERT INTO amo_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","A tunna ata anan katwa ipira uzirgi igya nbunme udu uleli uwule, udun Betaseda, ame na lawa kidung nfizu ligonzi nanite igya. ");
INSERT INTO amo_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Na iwa malu kiti, a tunna a ghana likup nwo adi ti nlira. ");
INSERT INTO amo_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","kulele da uzirge nin diyita kitik kulẹ, ame nin di yita usame ndase. ");
INSERT INTO amo_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ayene ani idin notuzu kiyitik kulẹ, bara na ufunu wadin yauzunu nani. Kitike wa di kimal fulu kiti kube wa di nafo ikoro inas, awa din chinu kitenen nmgyene uchin du kiti mine, ata nafo aba katuani. ");
INSERT INTO amo_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Na iyene nchin kitenen kurawe, itunnan su au nmọleri i ta ntẹt, ");
INSERT INTO amo_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","bara na iwa iyeneghe, fiu kifo nani kang. Ame tunna ata deidei alirina nan ghinu aworo, ''Tan ayi akone! Mẹri di! Na iwa lanza fiu ba.'' ");
INSERT INTO amo_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","A pira nan nya zirge ligowe nan ghinu, ufune tunna uyisina dang, vat mine umamaki kifo nani ninghe. ");
INSERT INTO amo_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Bara na iwa yinin ubeleng nakalang nimonli ine ba, nibinayi wa di deidei nyinne ba. ");
INSERT INTO amo_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Kube nawa kafin kurawe, ida tolo kagbirin Janisarata inin tere uzurge nmyene kikane. ");
INSERT INTO amo_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Na itolo nan nya zirgi nmyene, anite tunna iba yinnọ Yisa ku deidei. ");
INSERT INTO amo_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","A nite tunna ipira udu nan nya kipinẹ vat idin nuchu nin nanan tikonu kitene nawaga mine, idasa mung kitime, ligan kiti ka na iwa lanza anuzu cin due. ");
INSERT INTO amo_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Vat kiti ka na awa piru ku nin gin gbiri, sa kagbiri, sa kipin, asa ida chiso anan tikonu nan nya niti tikasau, inin sughe kuchu kusu ayinin nani idi dudo (kubaga) kulutuk chass. Vat ligan nalenge na iwa dudo, iwa se ushinu. ");
INSERT INTO amo_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","A farisawa so kiti kirum ligowe na Yisa, nan nadidye nyiru niyerte na iwa dak unuzun Urushalima. ");
INSERT INTO amo_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ba iyene among nan nya nono katwa me ili nimonli nin dinong nachara mine, wati na iwa kusu achara ba. ");
INSERT INTO amo_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(Bara na inung a Farisawa nan na Yahudawa vat, na idin li imonli ba se ikusu achara lau; na idin su avu nin kani kite ba, bara iwa seru nani kiti nakune minerẹ. ");
INSERT INTO amo_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Andi a Farisawa nsa unuzun kasau, na asa ileo imonli ba se isulsuna. Tutung ti duka di nani ku gbardang to na idin dorte nin likara, nafo ukuzu tikop, ameleng, asu-nishik, umunu kitin lisosin linimolẹ wang.) ");
INSERT INTO amo_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","A Farisawa nan nadidyan yiru niyertẹ tirino Yisa ku, ''Iyaghari ta na nono katwa fe din dortu ugadu nakune ba, bara na idin li nimonli mine sa ukusu nachara? ");
INSERT INTO amo_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","A woro nani, ''Ishaya unan liru nin nu Kutellẹ wa yertin gai kitene kinu ndortu liru Kutellẹ na idin su, 'Anit alele din sue liru nin na kpa tinu minere, a nibinayi mine yita piit ninmi. ");
INSERT INTO amo_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","U dortu mine kuholari su unin, idin dursuzu tiduka nanitari, na un Kutellẹ ba. ");
INSERT INTO amo_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ina filin uduka Kutellẹ i nanin na kifo adadun ngadu nanit asirne.'' ");
INSERT INTO amo_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","A woro, i lanza nmang infillu duka Kutellẹ inan yinnọ udortu gadu! ");
INSERT INTO amo_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Unnare Musa wa woro, na uchif fe nin nafighe ngogong, tutung urika na adin su uliru unanzang ayasa uchif nin nna, aba ku gbas.' ");
INSERT INTO amo_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Anughe kuru iworo, ''Asa unit belle uchif me sa aname, vat ubunu urika na usere kiti nin kobaghari,'' (wati nworu, 'imon nni Kutlellẹri) - ");
INSERT INTO amo_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","na asa iyinna asu uchifi me sa uname katwa ba. ");
INSERT INTO amo_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Idin tizu uduka Kutellẹ shogo-shogo bara udortu timin ti duka idimun. Nan nimon gbardan irika na idin sue.'' ");
INSERT INTO amo_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ayichila ligozin nanite aworo ani, ''Lanzanni, vat mine, ikuru iyinin. ");
INSERT INTO amo_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Na imon nnuzun dasari irika na idin pichu nan nya kidowong nit din nanzughe ba. Imon irika na idin nuchu nan nya nutere din nanzughe. ");
INSERT INTO amo_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Vat urika na adinin natuf nlanzun liru na alanza.'' ");
INSERT INTO amo_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nene kube na Yisa wa chin ligozin nanite a pira kilari, anan katwa me tiringhe tigoldo tone. Yisa woro, ");
INSERT INTO amo_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","''Anung wang dunani sa uyinnue? Na anung yene nwo vat nimon ile na ipira unit unuzun ndas na inare din nanzughe ba, ");
INSERT INTO amo_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","bara na iwaya ipira nan nya kibinayi ba, asa ipira nan nya liburu me, idi tolu itunna idi nuzu kitin tin das (npunju).'' ");
INSERT INTO amo_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","A woro, “Imon irika na idin nuchu daga nanya nit usurneri din nanzughe. ");
INSERT INTO amo_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Bara nan nya kibinayin nit usurneri, makpilizu-kpilizun magunta din nuchu ku, unozu nin nin nawani sa nalililme, likiri, umolsu nanit, ");
INSERT INTO amo_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","unozu nin wani nilugma sa gakilime nilugma, kunannizi, umagunta, usali kidegen, usu nlazun mang, tinanayi nin linbu nmong, ufiu liti, tilalang. ");
INSERT INTO amo_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Vat nimon magunta ilele din nuchu nan nya liburin nitari, inare din nanzu unit. ");
INSERT INTO amo_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","A fita kikane a gya udu kusarin Sur nin Sidon. A pira nkan kilari bara na awa dinin su umun yinin aduka ba, bara nani na awa yenshin ba. ");
INSERT INTO amo_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Na nin dandaunu umong uwani na kashune wadi nin nagbergenu uwani une lanza ubeleng Yisa adah ada deu na bunun me. ");
INSERT INTO amo_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Uwani une ushono hẹllen iyawa ri unuzu surofinikiya, a fuu ye acara anutun agbergene nanyan shune me. ");
INSERT INTO amo_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Iwa kifo munu idomun kiti nagoh, na iwah fya ayi mine kifene nile imon na iba bellu ba. Ka na iba bellu nkoni kube amon nanyan nkoni kube, ille imon na iba bellu ima nie munu; na nughere masu ulire ba, nfip Kutellẹari. Gwana banii gwana me imollu, uchif nin gono me. Nono ba fiu nibineyi nachif mine bara imolsu nanin. Anit vat ba naari munu bara lissanni. Amma ule na a ba tere, kibinai me aba se ulai. ");
INSERT INTO amo_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","A woro, “Bara na ubenle nani, can fi. Ku gbergene in nuzu nanyan nshono fe.” ");
INSERT INTO amo_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Uwane kpilla Kilari adi se gone nọn kitenen nkomi, kugbergene nuzu. ");
INSERT INTO amo_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Tutung anuzu kusarin Tyre, akatan Sida udak kurawan Galili, vat udu Kusarin Dikafoli. ");
INSERT INTO amo_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","I daghe nin mon unan nituri, unan sali nbellun liru gegeme, ifoghe acara a tarda kuture acara ulau me. ");
INSERT INTO amo_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","A nuzu ninghe nanya ligozin nanite udu kusari kurum a dudo atufe nin ticin me, atufuno attaf, a dudo lilem me. ");
INSERT INTO amo_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","A ghantina izi kitene kani, aceu kibinai a woronghe, “ifafattha,” nworo, “puno” ");
INSERT INTO amo_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Na nin dodonu ba atufemme puno alanza, ikala ile imong na kese lilem me atuna nliru gegeme. ");
INSERT INTO amo_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","A wuno nani atuf na iwa belin umonba. Illeu ubun mbellu nimong na a kpada nani na iwa belin ba. ");
INSERT INTO amo_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","I su umamaki kang, nin nille imong na iyene, ibelle, “ A su kanta gegeme. Atah kuturi alanza unan saling bellu nliru lirina.” ");
INSERT INTO amo_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nanya nayiri ane, ligozin na nit gbardan, wa duku na iwa di nin nimonli ba. Yisa yicila nono kata me a woro nani, ");
INSERT INTO amo_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“In lanza nkunekune ligozine, bara na idi nin mi ayiri a tat sa imongli. ");
INSERT INTO amo_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Inwa ti nani igya sa ulli ni mongli ima kuzu izintizo indina. Among mine na nucu niti nipït.” ");
INSERT INTO amo_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nono katame kawaghe, “Tima se akallang in burodi nweri ti ni anit alele nin kiti kane sa anit?” ");
INSERT INTO amo_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","A tirino nani, “Akalang nburodi amashin nari i dumun?” I woroghe, “Kuzor.” ");
INSERT INTO amo_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","A ta ligozin na nite i sozọ kutin a sere a kallang kuzore. Na ata inlira, a pucu akallanghe ana nono kata me i koso ligozin nanite. ");
INSERT INTO amo_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Iwa din nin nagir niboa, tutun na atta nlira ku, akuru ana nono katame i koso. ");
INSERT INTO amo_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ileu ishito. I pitiro ingisin nimonlẹ, i kullo akuzun kuzur. ");
INSERT INTO amo_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Anite waduru amui anass kikane. Yisa nin cino nani i gya. ");
INSERT INTO amo_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Na apira nanya zigin myen nin nono kata me, i gya udu kusarin Dalmanutha. ");
INSERT INTO amo_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Afarasiyawa nuzu ida ida cizina mayardan nanye. I pizira kulap kiti me inuzu kitene kani, inan dumunghe. ");
INSERT INTO amo_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","A Kpilliza nanya kibinayi me nanya nfip mi lau a woro, “I yarin ta ko kuje din piziru kulap? Kidegen in bellin minu, kuji kone mase kon kulap ba.” ");
INSERT INTO amo_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","A suna nani, a kuru a pira nan nya zirgin myen, udu uleli uwul kullẹ. ");
INSERT INTO amo_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Nono katwa me kuru I shawa uyirun borodi. Na iwa myen uborodi na uwa kata urum nangyen jirige ba. ");
INSERT INTO amo_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","A wuno nani atuf a woro, “Punon iyizi iyenje kiti bara iwa ming kuse na Farisawa nin wala mi kusen Hiridus.” ");
INSERT INTO amo_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Nono kata me kpilza nati mine, “Bara na ti di nin u'nburodi ba.” ");
INSERT INTO amo_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yisa wa yiru illeli imone, anin woro nani, “In yarin ta idin kpilizu nbelleng diru nburodi? Idu sa uyinne? Na isa yino ba? Nibinayi mine nta ni lalangha? ");
INSERT INTO amo_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Idi nin nizi, na idin yenju ba? Idinin natuf na idin lanzu ba? na i lizino ba? ");
INSERT INTO amo_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nan nwa kosu anit amoiyi ataun akallang nborodi a taun a ngisin na kuzun acecek amashin nari iwa pitiru an borode?” I woro ghe, “Likure nin na ba.” ");
INSERT INTO amo_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Tutung na nwa kosu anit amoiyi anas akallang nburodi kuzor, akuzun acecek amashinari kagisin nburodi wa lawa?” I woro ghe, “Kuzor.” ");
INSERT INTO amo_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","A woro nani, “Idu sa uyinuawa?” ");
INSERT INTO amo_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","I da Ubaitsaida. A nite ki kane daghe ning mong udü i fo Yisa ku acara a dudo ghe. ");
INSERT INTO amo_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yisa kifo udüwe ncara, a nuzu ninghe nanya kagbire. Na atanghe ataf nizi a tarda ghe acara, a tiringhe, “Udin yenju nimomongha?” ");
INSERT INTO amo_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","A yene kitene, anin woro, “In yene anit nafo aca ale na adin gallu.” ");
INSERT INTO amo_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Akuru a tarda acara me nizi nnite, unite puno iyizi me, uyenju me kpilla lau, ayenje imong vat kanang. ");
INSERT INTO amo_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yisa taghe agya udu killari me, anin woro, “Na uwa piru nanya kagbiri ba.” ");
INSERT INTO amo_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yisa nuzu nin nono kata me udu nanya kagbirin Siseriya Filipi. Na iwa din cinu libauwe atirino nono katame, “Anit din du menghari?” ");
INSERT INTO amo_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","I kawaghe I woro, “Among dindu Yohanna unang sulsuzunu ulau. Among dü 'Iliya,' among tutun din su umong nanya nanang nliru nin nnu Kutellẹ.'” ");
INSERT INTO amo_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","A tirino nani, “Anung din su meng ghari?” Bitrus bellinghe, “Fere Kristi.” ");
INSERT INTO amo_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Yisa wunno nani atuf na iwa belling umong ubelleng me ba. ");
INSERT INTO amo_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","A cizina udursuzu nani gono in nit ma niu nan nya nimon gbardang, a kune nan na Priestoci nan nanang niyerte ba narighe, I ma molughe, Kimal nayiri atat afita nanya kisek. ");
INSERT INTO amo_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","A benlle ulle ulire kanang. Bitrus yiraghe udu kasari kurum anin ghanan wunughe kutuf. ");
INSERT INTO amo_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Yisa gitirino a yene nono katame anin tunna a kpada Bitrus ku anin woroghe, “Kpilla kimal nin Shaitan! Na udin kpilzu imong Kutellẹ ba, ma ubelleng nimung na nit cas.” ");
INSERT INTO amo_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Anin yicila ligozin na nite nan nono kata me a woro “ Asa umong di nin su a dorti, na anari liti me, a yira kuchan nkulme adofini. ");
INSERT INTO amo_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Bara ullenge na adinin su a se ullai sa ligan amaku, tutung ulenge na a dira ulai me bara meng nin liru nlai a ma se ulai. ");
INSERT INTO amo_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Iyaghari imong icine unit ma se use nimong inyï ullele vat, anin dira ulai me? ");
INSERT INTO amo_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Iyanghari unit ma serzu nin nlai me? ");
INSERT INTO amo_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Vat ulenge na adin lanzu nci nin nin nliru ning nangya nko kuji ku zenzen nin kulapi, gono nit ma lanzu ncinme asa ada nan nya tigo ncif me nin nono kadura Kutellẹ.” ");
INSERT INTO amo_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yisa wora ani nani “na nbellin minu kidegen, among mine kikane na iyisin na iba ku ba sai iyene udak tigoh Kutellẹ nin likara mẹ. ");
INSERT INTO amo_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Na ayiri kutoci wa kata yisa gya nin Butrus, Yakubu a Yohanna, ighana kitine lukup nin natimine. kidowo me kpillia ki ta ugang mbun mine. ");
INSERT INTO amo_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Kultuk me kpilia, kubọ pau har ma na iwase ise unan tizu npozu nalutuk nye nani ba. ");
INSERT INTO amo_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Iliya nin musa tinna inuzu mbun mine, itunna in liru nin yisa. ");
INSERT INTO amo_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Bitrus kauwa aworo Yisa ku, Cikilari a unan yiru, uchaunari na tidi kikane, Na ti kẹ adanga atat ti kẹ feku kurum, kurum bara Musa a kurum kun Iliya”. ");
INSERT INTO amo_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Na Bitrus wadi asa mala imon ille na adi belle ba, fiu kiffo nono katuwa yisa vat. ");
INSERT INTO amo_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kuwut tolo kuda ta nani ushin, liwui tunna linuzu nan nya kuwute aworo “Gono kane kin kinnayi nighari lanzan ghe”. ");
INSERT INTO amo_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Na nin dandaunu ba igitirno na ikuru iyeni umong nanghinu ba, ma yisa ri chas. ");
INSERT INTO amo_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Na iwa din tolu kitene kupare. A wunno nani atuf na iwa bellin umon imonille na iyeni ba. Sai Usaun nnit nfita nanya na nan nkul. ");
INSERT INTO amo_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Iso nin nlire tik nanya nibinai mine ikwiliza nan nya natimine iyaghari ba yitu ufitu nanya na nan nkiu une. ");
INSERT INTO amo_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Itiringhe “iyarin ntah anan niyerte wa woro Iliya ri batu adak?” ");
INSERT INTO amo_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Aworo nani nanere Iliya na burun dak, anan kele imon vat. Iyari ntah iina nyertin gonon nit ba nieu nanya nmon gwardang anit tutun banin narrighe? ");
INSERT INTO amo_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Meng woro munu Illiya nadak inani wa sughe ille imon na wa dinin su we nafo na ina nyertu na bellin kitene me.” ");
INSERT INTO amo_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Na igbilla kikaa na ingisin nono katuwe, duku, iyene anit gwardang kiilino nani ida se anan nyerte din nani matiru liru. ");
INSERT INTO amo_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Na iyenne yisa ku vat nnanite isu umamaki itinna iputu nin nchum ida kitime ida lisoghe na inya nin dak. ");
INSERT INTO amo_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Atiro nani nono katuwa memanyardang nnyaghari idun sua nanghinu? ");
INSERT INTO amo_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Umon nanya ligoze kawaghe “unan yiru nndamun nin gono nighe adumun nagbergenu alle na sa iwantighe uliru gegeme. ");
INSERT INTO amo_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Idin tizughe nafo abakuu assa itaghe atiza yeryer, adeo kutin, anutuzuno kapunjet nnuu me adinga unyakuayini me. anin ta cakatak. nmini uwan tiirin nono katuwa fe inunta agbergene, ina ni na iyinno ba.” ");
INSERT INTO amo_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","A kawa nani “Anun kujji nsalin yinnu sa uyenu udu kome kibiari meng ba tizu ayi ashau ninghinu? Dan ninghe kitinighe.” ");
INSERT INTO amo_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","idamun gone kitime na agbergenu iyene yisa ku, gone tunna ntizu yer yer dedei gone deo kutin apunjet tunna nnucughe nnu. ");
INSERT INTO amo_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Yisa tiirino uchifun gona “ninshiyari ile imone na so nene?” uchife woroghhe “tun tinono mi. ");
INSERT INTO amo_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Kon kubi asaataghe nanya nlah sa nanya nmyen, akuru amassa ummolughe. Andi uwa uta nimomon lanza nkunekane bite ubunari.” ");
INSERT INTO amo_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yisa woroghe “Andi uba yinnua? Ko iyapin imon insuari kitin nle na ayinna nin kibinai me.” ");
INSERT INTO amo_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Na nin nmolu kubi ba ucifin gone ghantina liwui kuchullu aworo “Inyinna! Buni nanya ninsalin nyinnu nighe. ");
INSERT INTO amo_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Na yisa nyyenie ligozi nanite uchindak kitimine a kpada kugbergenue aworoghe, “Fee kugbergenue a nsalin bellu nin salin nlannzu nliru ntafi nuzu nanya me, Na uwu kuru upirughe nanya me ba.” ");
INSERT INTO amo_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Kugbergenue ta ntet anyunguruno gone kang annin anuzu, gone wan ti fo ulle na aku gwardang nanit woro aku.” ");
INSERT INTO amo_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Yisa akifo ghe ncara a fiyaghe gonne fitah ayisina. ");
INSERT INTO amo_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","na yisa da pira kilari nono kaluwa me duku itiirino gheekusari kurum “iyaghari ntah na arike nyino unutunu kugbergenu ba?” ");
INSERT INTO amo_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","A woro nani, “imuse nile imone din nuchu hem nani ba sai nin liirang ");
INSERT INTO amo_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Inuzu kakane ikata ngalillee, na yisa wa dinun su umon yinin kiti kkanga na iduku ba. ");
INSERT INTO amo_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Bara awa din dursu nono katuwa me. A woro nani, ibanie gonnon nnit nachara nanit, inughe ba mollughe kubi ko na im ologhe, asa nayiru atat nkata aba fitu tutun.” ");
INSERT INTO amo_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Na iwa yinin uliru me ba, ilanza fieu nworu itiiringhe. ");
INSERT INTO amo_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Idah kafarnahum kubi ko na awandi nanya kilari atirino nono katuwa me. “Uyapin uliruri ini yita nsue libau we?” ");
INSERT INTO amo_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Nin nani itunna imino tuk ini yita manyardang nati mine libau we nnanya woru ghari baso udia nanya mine. ");
INSERT INTO amo_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Aso ayichila lukure nin nanwaba. Aworo nanni, “Vat ulle nge na adinin su aso bun aso unan kidun akuru aso kuchin mine vat.” ");
INSERT INTO amo_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","A yira Kagono kabene achiau ketik mine, a kuru a yira ka gone nin na chara me aworo nani. ");
INSERT INTO amo_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Vat ule nge na a serre gono kibbene kane nanya lisanig, uso miyari aserei ule na aserre me nku na mere ku chas ba ninle nge na ana tuuyi.” ");
INSERT INTO amo_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Yohana bellinghe “unan yiru tiiyene umon din nutuzunu nagbergenu nanya lisafe ti nani wantinghe bara na adin dortu bitari ba.” ");
INSERT INTO amo_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Bara nani yisa woro “na iwa wantin ghe ba na umon duku ulle na awnya asu katuwa kadia nanya lissa nigh anin kuru akpilla abelle imon inanzan kitene lissa nighe. ");
INSERT INTO amo_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Vat ulle na adin nivira nanghirk ba, ame umbitari. ");
INSERT INTO amo_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ullenge na ana manu kakuk nsonu nmyen bara anun anit nighari kidegen indin bellu munu aba se imon wesu tinonto ");
INSERT INTO amo_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Vat ule na atah umon nanya nibebene nane na inah nibinai mine kitinighe idiou. Uba kaitiniuh ghe yaun litala lidia aterughe nto itughe nanyakulli kudia. ");
INSERT INTO amo_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Assa ucharafe ba tifi utirro, werne unin uba katinifi nwoni use ulai Kutellẹ ninchara urum nin nworu upiru nlaah nin nacara aba nsali nbichu. ");
INSERT INTO amo_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Kiti kanga na ajiji naburu mine ba bijuba, a ulamine ba bichu ba. ");
INSERT INTO amo_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Andi kubunu fe batifi utirru werne kuninn ukatinfi use ulai sa ligan nin kubunu kurum nin woro upiru nanya laah nin na bunufe abaa ");
INSERT INTO amo_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","i use ulai nanya kufee tigo Kutellẹ nin lisa lirum da iworo upiru nanya kilari laa nin niyizi ibah. ");
INSERT INTO amo_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Kiti kanga na ishun ba kuzu ba. Tutun ula ba bichu ba. ");
INSERT INTO amo_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Vat nanite nani ninla nafo nto iba kelu Nto chaun. ");
INSERT INTO amo_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Asa nto ndira mmamas me fe ba kellu minin miti mamas Iziyari? yita mamas nafo nto nanya mine, iso mang nan nati ");
INSERT INTO amo_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yisa chinno kiti kane uchindu kusarin Yahudiya nin mbun kurawa Judan ligozi nanite kuru idah kitine. Awandi ndurzuzu nani tutun nafo na amene nsuze. ");
INSERT INTO amo_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","A farisiyawa dā kitime ida malaghe inin tiiringhe, “ Uchau chikilari ko uwani me?” ");
INSERT INTO amo_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","A kaw, “Inyaghrri Musa na woro minu isu?” ");
INSERT INTO amo_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Inug woro “Musa wa yinin gankilime a su iyerte nsunun wani anin koghe anya.” ");
INSERT INTO amo_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Yisa woro nani ulele vat bara kugwas minere wati ana minu ule uduke. ");
INSERT INTO amo_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","“Nburnu makekewe Kutellẹ wa ke gankilime nin wani. ");
INSERT INTO amo_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Bara nanere gankilime ba sunu uchifeme nin namẹ atafin nin wani me. ");
INSERT INTO amo_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Inun nabẹ ibaso kidowa kirum. Bara nani inug nabe baso kidowo kirum na niba ba. ");
INSERT INTO amo_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Bara nani imon ile na Kutellẹ ntere na umon uwa bunku ba.” ");
INSERT INTO amo_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Kubi ko na iwadi nanya kilari nono katuwa me tiringhe imon ine. ");
INSERT INTO amo_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","A woro nani vat ule na akọ uwani me adiyiru umon uwani uso adin su nzina nin uwani upese. ");
INSERT INTO amo_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Assa uwani nchino ulese adi su ilugma nin kan gankilime aso adin sun zina” ");
INSERT INTO amo_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Anit dā nin ni nono ni bebene kitime anan duduzo nani, Nono katuwa me kpada nani. ");
INSERT INTO amo_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Na Yisa yene nani, ayi nanaghe, aworo nani “sunan nono nibebene idak kitinig na iwa wanttin nani ba, kutï tigoh kitene di kun musu nalelere. ");
INSERT INTO amo_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Kidegene indin bellu munu vat ulle na ayinna nin kutï tigoh Kutellẹ nafo ni nono nibebene ba na abase upiru kutï tigowe ba.” ");
INSERT INTO amo_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Atunna ayira ni nono nibebene nin nachara me atarda acara ata nani immari. ");
INSERT INTO amo_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Na a cizina uchinme umon daghe nin chum a da tumuno nin nalung a tirrighe “unan yiru ugegeme iyapin imonari mmasu nnanseh ulai sa ligang?” ");
INSERT INTO amo_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yisa woroghe “iyarintah uyicilai unit ugegeme? na umon duku unit ugegeme ba andina Kutellẹ chas ba. ");
INSERT INTO amo_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Fe yiru uduka: na uwa mollu unit ba, na uwa su uzina ba uwa su likiri ba, uwa su kinu'u ba, uwa bollusu imon na nit ba. Tutun Tumuzuno Uchifi fe nin Nafine.” ");
INSERT INTO amo_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Unite woro, ''Unanyiru, elle imone vat nwa dortu a nduttu kwanyana.” ");
INSERT INTO amo_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yisa yeneghe nin kibinai nsu aworoghe vat imon irumari lawafi “can udi lewu vat nimon na udumu udi kosu anan diru nimon, ubase kiti lisosiin kitenne kani. unin da dofini.” ");
INSERT INTO amo_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Nin lanzun nlirun ne kidowo taghe yototo ayime nanakang atinna a gya bara adinin nimon nachara gbardong. ");
INSERT INTO amo_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yisa gitirino anin woro nono katuwa me “ubayitu nin nijasi unan nimon nachara se upiru Kilari tigoh Kutellẹ!” ");
INSERT INTO amo_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nono katuwa me nidowo mine wati cancam nin tigbulang me Yisa tutun kuru a belle nani nono nig ubayitu nin nijasi unan nimon nacara piru kilari tigoh Kutellẹ! ");
INSERT INTO amo_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Ubayitu shiyau wang kurakomi se upiru ligalang nalura nun woru unan nimon nacara piru kilari i tigoh Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","I wa su umamaki kang ibelle atimine ani ghari ba se utucue? ");
INSERT INTO amo_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yisa yene nani anin woro “kiti nanit udumun nijasi ana kiti Kutellẹ ba kiti Kutellẹ imon vat nsuari. ");
INSERT INTO amo_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Bitrus cizina uliru ninghe “nanere arik na sun imon vat tinani na ndofifin” ");
INSERT INTO amo_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yisa woro nani kidegene nbelun munu na umon duku ulle na a cino kilari sa nuawana ni limi sa nishono sa unna sa uchif sa nono sa anen bara meng nin lirun lai so, ");
INSERT INTO amo_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ulle na aba serru uwesu tinonto akalt likure kiteni nakalt likure nanyan nyulele, use nilari nwanna nilime nin nishono a una nin uchif nan Nanen nin niu nyi incindak ulai sa ligang. ");
INSERT INTO amo_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Bara nani gwardang ana idi bun iba kpulu kidung anan kidung kpillun ubun. ");
INSERT INTO amo_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Iwadin cinnu libau lo na li ghana udu Urushalima yisa wa din ncin mbun mine. nono katuwa me lanza umamaki allenge na iwadin kidung mine lanza fiu, Yisa yira likure nin nawabe kusari kurum tutung, imon ille na iba seghe na nin dandauna ba. ");
INSERT INTO amo_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Yenen, tidin cinnu udu Urushelima ibadi ni gonon in Nit nachara nadidya kutyï Kutellẹ nin na nan nnsu niyerte. ");
INSERT INTO amo_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Iba su ghe ushara un kul iba nakpughhe kiti na lumai. Iba sughe liyong itufuzunghe ataf ikpizi ghe inin mollughe. Nanya nayiri atat aba fitu. ");
INSERT INTO amo_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Yakub nin Yohanna nonon Zabadi dah kitime iworo “unan yiru nimon tidininsu usu nari vat ile imon na tiba tirrinfi.” ");
INSERT INTO amo_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","A woro nani, “iyaghari idununsu meng su minu?” ");
INSERT INTO amo_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Inung belle “yinna nari tiso ninfi nanya ngongon fe. Warum nchara ulime umon nchara ugul. “ ");
INSERT INTO amo_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ame yisa kawa nani “Na anughe yiru imon ille na idin pizuru ba, iwasa isono nmyin libbo lo na meng ba sonah? Sa iwasa ita ayi akone nin musun mmen mọ na iba nshintini kuwa? ");
INSERT INTO amo_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","I woroghe nenge tiwasa tisu, Yisa belle nani nmyen libo mo na meng ba sonu iwasa isona. Ushintinu ulle na ima sue anunọg wangp ima su minu mun. ");
INSERT INTO amo_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Bara nani ulle na aba so nchara ulime sa nchara ugule nighe na unanighari ba, udi un nalle na ina mekeni mun” ");
INSERT INTO amo_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Na kagisin likure nlatiza nani ayi cizina unanizu nani nin Yakub a Yohanna. ");
INSERT INTO amo_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Yisa yichilla ani a woro nani, “Iyiru alle na idi agoh na wurumi, anan kuteet likara asa ita isu kitene mine. ");
INSERT INTO amo_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Na uwa uso nani nanya mine ba vat ulle na atah ayi nworu aba so udya nanya mine na aso gono katuwa mine. ");
INSERT INTO amo_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Vat ulle na adi nin nayin woro aba so unan bun mine na ayita kucin mine. ");
INSERT INTO amo_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Na gonon in Nit nadak asu tigoh ba, awa dak nafo kucin, anan da serze ulai me bara anit. ");
INSERT INTO amo_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Vat mine gbardang. I dah u Jeriko. Na a ichino u Jeriko ligowa nan nono katame nan ligozi nanit. Umon wa duku iwa yicighe Bartimaus (a wadi usaun Timaus) uduuwari asa aso nbun ndina likura. ");
INSERT INTO amo_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Na alanza yisa din cinnu ukatu ndine atunna ntutuzu aworo “Yisa usaun Dauda lanza nkunekune nigh” ");
INSERT INTO amo_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Anit gwardang Kpada ghe ati tik, ame na ghantina liwuye, “Yisa usaun Dauda, lanza nkunekune nighe!” ");
INSERT INTO amo_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yisa Jombilino a woro iyichila ghe inun yichila uduwe iworoghe “terre kibinnai, ufita, a din yichufi.” ");
INSERT INTO amo_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","A tunna a fillo kultuk me kusari ata katari udu kitin Yisa. ");
INSERT INTO amo_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Yisa kawa aworoghe “udumusu ntifi iyaghari?” Uduwe woroghe “ unanyiru aye die nse uyenu kiti. ");
INSERT INTO amo_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yisa woroghe “cang uyinnu sa uyenufe nshino ninfi” atunna ase uyenu kiti adofino Yisa ku, ncine ndine. ");
INSERT INTO amo_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Kubi ko na iwa daku Urushalima, iwa dak susut nin Batipagi nin Baitanya kiti kupara Zaitun. Yisa tọ nono katuwa me ");
INSERT INTO amo_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","a woro nani, “can kagbiri ka na kadi likot bite adi ipira, ima yenu ka gono kajaki ka na umon nsa ghanaku ba, bunkun kanin idani. ");
INSERT INTO amo_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Asa umon tirin minu, 'iyaghari indin sue?' i woro ghe 'Chikilari ba su imomonmu, nanin dondonu ba ima kpillu mu.'” ");
INSERT INTO amo_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","I gya idise gono kajaki terrin kibulun Ndas fwang. Ibunku kanin. ");
INSERT INTO amo_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Anit ba-at wa yisin kiteh i woro nani, “iyagharinta idin bunku ngono kajaki kane?” ");
INSERT INTO amo_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Vat mine i belle nanin uliru ule na Yisa wa belling Anite tuna isuna nani in gya. ");
INSERT INTO amo_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nono kata me nabe da nin ka gono kajaki kitin Yisa i kalza alutuk mine i tarda kitenne Yisa nin ghanaku. ");
INSERT INTO amo_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Anit gwardang nonkizo alutuk mine ndinnẹ, amon nonkuzo affah na iwadi kezu kusho. ");
INSERT INTO amo_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Alle na iwa diw mbun me nin nale na iwa din dortighe ighantina tiwui mine Hossana! Imari kitin inle na ada nanya lissan Cikilari. ");
INSERT INTO amo_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Unan mariari tigoh to na tidin cinu tin bit Dauda! Hossana uzazunu kitene kani!” ");
INSERT INTO amo_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yisa gya udu nanyan Urushalima, adi piru kusari kutin nlira, a gitirno a yenje imon vat. Nin kuleleng shew, anin nuzu udu Baitanya ligowe ni likure nin nawaba. ");
INSERT INTO amo_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Lirin nkurtunin nkuiye, na iwa sa unuzun in Baitanya, ku kpong daghe. ");
INSERT INTO amo_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","A tọ iyizi adi yene kucha kupul nin tifa gbik, atinna ado adi yene sa a base kumat kucheku. Na'ada kiti kunin aseh ma affari cas, bara na kubi na pullere wa diba. ");
INSERT INTO amo_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","A lirina nin kunin, “na umon ba akuru alli kumat fe ba.” Nono katame lanza ilemon na a belle. ");
INSERT INTO amo_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Idah Urushalima, anin pira kusari kutin nliran atinna nko nanan lesu nin nanan sessu nanya kutïn nlirẹ atinna nkpilluzu matebul in serzu nikurfug nan niti lisosin nanan lesu na wullug. ");
INSERT INTO amo_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Na awa yinin umon yira imomon nanya kutï nlire bara a di lewu ba. ");
INSERT INTO amo_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","A dursuzo nani aworo “ikuna nyertina, na kilari nighe maso kin lira bara nipinpin nyii vat ba? Nkani nso munu kuta na kiri.” ");
INSERT INTO amo_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Adidya kuti nlira nan nanan ninyerte lanza ilemon na abelle, itunna npiziru nworu imolughe. Iwa din lanzu fiu bara vat ligozin nanite wa suu umamaki nin dursuzume. ");
INSERT INTO amo_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Vat kuleleng nin du kulelen asa inuzu nanya kagbire. ");
INSERT INTO amo_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Na iwa din cin nin kuididing, iyene kudya kupule nkoto umunu tilighe ku. ");
INSERT INTO amo_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Bitrus lizino aworo, “unan yiru, yenne! ku pulle na uwati kunim unu nakoto” ");
INSERT INTO amo_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yisa kawa nani “Yitan nin yinnu sa uyenu kiti Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Kidegene ndin bellu minu, vat ulle na a woro 'kupara kone, Kutellẹ kalafi adi tu nanya kuli kudya,' assa udinin yinnu sa uyenu nanya kibinai fe imon ille na ubelle ima so, ileli imonere Kutellẹ masu. ");
INSERT INTO amo_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Bara nani mbellin munu, vat imon ille na itirino nanyan nlira, yinna kibinai fe usere ima so infe. ");
INSERT INTO amo_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Uwa uyisin nlira, ukifofi ushawa nin nimon inanzang ille na idi kibinaife nin mong, nanere ucif fe na adi kitene kane ma mashawu ni na lappi fe wang. ");
INSERT INTO amo_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","“Assa na anu nshawa utazunu ulle na amonng din suzu minu ba, nanere wang ucif mine na adi kitenekane ma shawu nin mine utazune ba.” ");
INSERT INTO amo_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","I kuru ida Urushalima. Kube na yisa wa di ncin nanya kutï nlira, Adidya kutï nlire nin nanan niyerti, nan na kune alle na inatarda nanin achara da kitime. ");
INSERT INTO amo_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","I woroghe, “nin yinnu nghari udi nsuu nile imone? sa ghari yininfi uda su inin?” ");
INSERT INTO amo_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yisa woro nani, “mma su minu utirinu urum. Bellen ni, meng wang ma belling muni sa nin yinnu inghari ndin su ile imone. ");
INSERT INTO amo_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ushintizunu Yuhana uwa nuzu kitene Kaneara sa kiti na nitari? Kawanni.” ");
INSERT INTO amo_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ikpiliza nati mine na iyina ba iworo, “Tiwa woro, 'au unuzu kitene kani ari' amma woru 'bara iyagharin ta na ina yining ninghe ba?' ");
INSERT INTO amo_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Assa ti woro, una nuzu kiti 'na nitari,...' Iwa din lanzu fiu nanite, bara vat min wa yinning Yohanna unan liru nin nu Kutellẹari. ");
INSERT INTO amo_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Itinna ikawa Yisa ku inin woro, “na ti yiru ba.” Yisa tinna a belle nani, “meng wang na nma bellu minu ba sa nin yinnu nghari ndinsu ille imone.” ");
INSERT INTO amo_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yisa ciziina udursuzu nani nin tinan tigoldo. A woro, “Umong unit wa billisu kunen akese kunin, a kuru a wuzu kuwu in pulu immen kumat nacha Ake-e kifi kizalang kinan cha, Abala Among kunen Anin suu uchin. ");
INSERT INTO amo_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Na kubi nda, Afo-o gono katah me udu kiti nate na abala nanin kunene idi nighe kumat nacha kunene. ");
INSERT INTO amo_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Itinna ikifheghe, Ifhoghe inin koghe anya nin na chara akone. ");
INSERT INTO amo_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Akuru atọ nani nkang gono katah me, i lanzaghe ukul liti inin sughe imon inanzang. ");
INSERT INTO amo_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Akuru atoo nani nkang gono, kahh gone imolo kinin. Isuu among guardang nani nafo na iwa suu alele, iifho among nin molsu namong. ");
INSERT INTO amo_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Adumun nimong ulenge na ama tü ghe, kinnayi me. Amere wadi unan ninalighe na awa tuu ghe udu kifimine, aworo, “imma seru gono nighe gegeme.” ");
INSERT INTO amo_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Anan kibala kunene belle nati mine, ulelere kuwane, dan, timolughe, kunene so-o kunbit. ");
INSERT INTO amo_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","I kiffoghe, imologhe iyiraghe ifillo ndas kunene. ");
INSERT INTO amo_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Bara ilemone, unan kunen kone ba ti iyizari? Ama dak ada molusu alle na ana ninaning kunene, anin yiru kunene ani among. ");
INSERT INTO amo_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ikkuna cheu iyizi ni iyert inne? “Litala loe aa anan makyekye na nari lining inlo indaso lifala likii kutiye. ");
INSERT INTO amo_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ile mone kafa-a nchikilara ri ini dinin mamalci niyizi bite.” ");
INSERT INTO amo_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Pizira ukifu Yisa ku, bara nani ilanza fiw ligozin nanite, iyinno bara inughere awa suu toni tinan tigolde. Itina i sunghe ikifo libo min. ");
INSERT INTO amo_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Inin tọ among a Farisiyawa nan na Hirudiyawa udu kitime, inan taghe a tana uliru. ");
INSERT INTO amo_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Na ida, iworoghe, “Unan dursuzu, tiyirufii unan kidegen ghari, na udin feruanitba. Kidegen ri udin dursuzu libo Kutellẹ. Udut an yinna ini siza ku ugaudua sa babu? ti niza sa babu?” ");
INSERT INTO amo_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yisa uni wa yining kirusuzu nati mene abele nani, “Yaghari unta idiu dumuzini? dan nani fikurfung nyene finin.” ");
INSERT INTO amo_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ida na ise ku firung. a woro nanin, “ulele umuro nin niyerti nghari?” Iworo, “unkaisarari.” ");
INSERT INTO amo_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Yisa woro naning, “ nan kaisar ku ile imon na idi nkaisar tutung ini Kutellẹ ille imon na idi in Kutellẹ.” I lanza umamakime. ");
INSERT INTO amo_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Tutung a a Sandukiyawa da kitime, inug alle na idin du na ufitu nanan nkul duku ba, Itirighe, iworo, ");
INSERT INTO amo_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“unan dursuzu, Musa wayertin nari mun, 'gwanan mon nwa ku a suna uwanime, sa gono, unite yira uwani gwana, a mara gwane gono.' ");
INSERT INTO amo_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Amon wa duku inun kuzor linuawana unan burnu mine yira uwani a kü sa gono. Unan dortine yira uwane akuru akü sa gono. ");
INSERT INTO amo_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Unan tatte nanere. ");
INSERT INTO amo_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ame unan zorre da kü sa gone, umalzine vat uwa ne wang kü. Lirinfitin yï, iwa fita tutun. ");
INSERT INTO amo_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Uwani nghari ma yitu? bara inug vat mine kuzore wasu ilugma ninghe.” ");
INSERT INTO amo_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yisa woro, “Na imon ilenge na ita idin tazuna ile ba, bara na anunghe yiru uliru Kutellẹ sa likara me ba? ");
INSERT INTO amo_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Iwa fita liri Fitin ye na iba su ilugma ba a na iba ni ilugma ba, imaso nafo nono kadura Kutellẹ kitene kani. ");
INSERT INTO amo_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ubellen nanan kul na iwa fiya nani, na ina cisu iyizi niyerten Musa ba, inbeleng kukot, na Kutellẹ wa lirin ninghe, a woroghe 'Menghere Kutellẹn Ibrahim, Kutellẹ Ishaku nin Kutellẹ Yakub'? ");
INSERT INTO amo_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Na ame Kutellẹ nanan kula-ari ba, kun nan laiyari. Anughe din ntazunu kang.” ");
INSERT INTO amo_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Umong nanya nanan niyerte da ada lanza nliru min; ayene Yisa nkawa nanin gegeme, atiringhe, “uyeme uduka kufelteari ucine vat?” ");
INSERT INTO amo_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yisa kawa, “ucine nanye vat unere, 'Lanzang, Ana Isrela, Cikilari Kutellẹ bite, Cikilare uwarumari. ");
INSERT INTO amo_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ubati usü Kutellẹ nin kibinai fe vat, nin kidowo fe vat, nin kpiluzu fe vat, umunu likarafe vat.' ");
INSERT INTO amo_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Unba me unere, uma yinnu nin nan lisosin kupofe nafo litife.' Na umon uduuka udia duku ukatiin ulele ba.” ");
INSERT INTO amo_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Anan ninyerte woro, “uchaun na, unan dursuzu! Ubelle kidegen Kutellẹ kurumari, Tutung na nkon Kutellẹ duku ba, amere chas. ");
INSERT INTO amo_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Uma yinnin ninghe vat nin kibinai fe vat nin yirrufe, vat nin kodowo fe, vat nin likara fe, ukuru uyinnin nin nan lisosin kupofe nafo nafo litife, ukatin unakpizu nimon jujuzu mine inbon Kutellẹ nin chant kang.” ");
INSERT INTO amo_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Na Yisa wa yene akawa gegeme, a woroghe, “Na udi piit nin kilari tigo Kutellẹ ba.” Nani na uman kuru amalla utiringhe nimomon tutung ba. ");
INSERT INTO amo_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yisa wa din dursuzu nani nanya kutee nlira a tardda nani a woro, “Uduziyari anan ninyerte na woro unan tuchu usaun Dauda? ");
INSERT INTO amo_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Dauda litime, nanya infin Kutellẹn, wa woro 'Cikilare wa woro in Cikilari nin, so nchara ulime nin, udu kubi ko na uba patilu anan Nivirafe.' ");
INSERT INTO amo_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dauda nin litime wa yicilla unan tuchẹ 'Chikilari' Iyiziyari ama so usaun Dauda?” Ligozi nanite lanza ghe nin nibineyi nibọ. ");
INSERT INTO amo_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Nanyan ndursuzu me Yisa woro, “Sug seng nin nanan ninyerte, alege na idinin sun sho nalituk adidya nin woru isu nanin ilip ugang nanyan nkasau, ");
INSERT INTO amo_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","nin natet lisosin adidya nanya kuteen nliran nin niti nididya kiti tibuki. ");
INSERT INTO amo_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Idin bolsu nilari na wani alle na ales mine na kuzzu, Asa itiza nlira mi jangaram anit nan yenje nani bara nani iba seru uneu udiya.” ");
INSERT INTO amo_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yisa do adi so-o likot adiin yenjuu kitin tusu nikurfun nanya kuttii nlira; awa din yenju nanite na iwa din ntusu nikurfung nanya kitin tussu ni kurfung. Ndiya nanan nimon na chara wadin tussu ninime gwargwardang. ");
INSERT INTO amo_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Umon uwani ukimon unan dirum nles, da ada to-o anini abaku. ");
INSERT INTO amo_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yisa yichilla nono kattah me ligowe aworo nani, “Kidegen nbellin munu, uwani ulele kikimon unan diru nles ile mon na ato-o ikafin in nanan tusse vat. ");
INSERT INTO amo_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Vat mine i nyofizo nanya nse miner. Amme ule uwae unan dirin nles wani vat ilemon na adamu.” ");
INSERT INTO amo_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Na Yisa wa cinu unuzu nanya kutein nlira, warum nanya nnono kattah me woroghe, “unan dursuzu, yene atala alele nin makyekye nmanaki!” ");
INSERT INTO amo_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","A woroghe, “Uyene makyekye madidia maane? Na nlon litala ba lawu kitene Non ba vat iba turzunu anin.” ");
INSERT INTO amo_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Adi so kitene litalan zaitun likot kutii nlira, Bitrus, Yakubu, Yohanna, ligowe nin Andrawus tiringhe likot, ");
INSERT INTO amo_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Belle nari ninshiyari iba suu ile mone? Yaghari madura nari nworo vat nile imone nan naduru udaka?” ");
INSERT INTO amo_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yisa tunna nbellu nani, “Yenjeng umon wa wultung munu. ");
INSERT INTO amo_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Anit gwardang ba dak nanya ni, 'Mere Ame,' tutung ibati anit gbardang wulu. ");
INSERT INTO amo_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Assa ilanza ubellen nakum kitene nakum, na iwa fya nibinai mine ba; ima suu ille imone, vat nani ligaghe nsa daba. ");
INSERT INTO amo_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nkang kipin ba firunu nkang, Tigoh ba nari tigoh. Iba se uzunu niti niti gwardang iba su akpong. Ile imon inanzaghe uchizinari. ");
INSERT INTO amo_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Song cha. Ima du nin ghinu kiti nago, iba fo minu nanya natii nlira. Iba yisinu nbun na go nafo imon nyenu kitimine. ");
INSERT INTO amo_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Bara nani ima burnu ubelu nlirun nlai udu kifi nanit vat. ");
INSERT INTO amo_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Iwa kifo munu idomun kiti nagoh, na iwah fya ayi mine kifene nile imon na iba bellu ba. Ka na iba bellu nkoni kube amon nanyan nkoni kube, ille imon na iba bellu ima nie munu; na nughere masu ulire ba, nfip Kutellẹari. ");
INSERT INTO amo_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Gwana banii gwana me imollu, uchif nin gono me. Nono ba fiu nibineyi nachif mine bara imolsu nanin. ");
INSERT INTO amo_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Anit vat ba naari munu bara lissanni. Amma ule na a ba tere, kibinai me aba se ulai. ");
INSERT INTO amo_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Asa uyene umon izemzem yissin kiti kah na idin woro iyisin ku ba, (na unan yenju niyert yining), na allenge na idin Yahudiya na icumm udu apara, ");
INSERT INTO amo_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ulle na adi kutii kitene na awa toluba, sa ada yiru imomon nanye imomon nanya, ");
INSERT INTO amo_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ulle na adi kunnen nawa dak nyiru ugudum me ba. ");
INSERT INTO amo_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Kash imon nkunne kuneri na lenge na imayitu nin nono nibebene nin nalenge na idumun nonon nmazinu na yiri ane! ");
INSERT INTO amo_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Sun nlira na ile imone nwada kubi likus ba. ");
INSERT INTO amo_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Unieu udya ba yitu, i masu ilemon na anitin sa yenne ba, nworu na Kutellẹ wa kye uyẹh, udak nene, na isa su nani ba, å na iba kuru isu nani ba ");
INSERT INTO amo_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","In sasana Cikilare na can ayire ba, na iwa se unan lai ba, bara alle na ina fere, unin nare nati i werne ayire. ");
INSERT INTO amo_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Tutun asa umon mbellin minu, 'Yenen, Kristi ulle!' Sa, 'Yenen, aminii!' na iwa yinin ba. ");
INSERT INTO amo_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Bara an Kristi kinu nin na nan nliru nin nu Kutellẹ kinu ma nuzu ima dursuzu imon yenju nin ni mon nmamaki, inan wultuno anit Kutellẹ wang adin uso nani. ");
INSERT INTO amo_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Song ncha. Nna me bellum minu vat nille mone a na kube nsa da ba.” ");
INSERT INTO amo_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Assa ayiri nneu ane nkata, uwui ba siriu, na upui mani nkanang me ba, ");
INSERT INTO amo_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","iyin kitene kani ba dissu akara allenge na adinitene nani ma zulunu. ");
INSERT INTO amo_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ma imanin yenu gono nnit in nuzu nanya nawut nin likara lidyah nin gongong. ");
INSERT INTO amo_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","A banin tu nono kadura Kutellẹ amma piturnu allenge na ana fere nanin nnuzu tikot tinas uyiru na pori nyi udu napori kitene kani. ");
INSERT INTO amo_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yiran uyiru nimon kiti kucha kupul. Assa iyene tilanghe ncizina utilu naffa appese yinnong kusike nda susut. ");
INSERT INTO amo_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Nanere tutung iyinigh ille mone ncizina, yinnon ada susut kibuluu'. ");
INSERT INTO amo_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Kidegen, mbellin minu, imon illele ma kulu vat ma kuji kone nin kata. ");
INSERT INTO amo_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kitene nin yii ma katu, na uliru nin ma katuba. ");
INSERT INTO amo_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Ubelleng liri lole nin kubi kone na umong yiru ba, na nono kadure kitene kane, sa gono me yiru ba, uchifere chas. ");
INSERT INTO amo_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Song nin yiru! Yenjeng, bara iyiru sa kome kubiari ba. ");
INSERT INTO amo_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Umasin nafo unit ulle na assu uchin: acinno kilari me na chara nacin me, koyeme nin kata-a me. Anin belle unan ca kibulughe yenje uwasu mmoro. ");
INSERT INTO amo_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Bara nani sun ucha! Bara na iyiru kubi ko na Cikilare ma dak ba, sa nin dew nwui, sa nin kitik, sa nin kolusunu kukulok, sa nin kui dindin. ");
INSERT INTO amo_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Awa da minu, na awa adah da se minu mmoro ba. ");
INSERT INTO amo_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ille mon nan din bellu minu, ndin bellu anit vat, yenjen kitii!” ");
INSERT INTO amo_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Uwa lawa ayiri abba isu ubukin Paska nin bukin Burodin salin yist. Adidya kutin nlira nin nanan ninyerte wa din kpilizu libau longo na iba kifi Yisa ku i molughe likire. ");
INSERT INTO amo_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","I woro nenge, “Na wa ti wa kifoghe kitin buké ba, bara nnun wa fita nan nya nanite.” ");
INSERT INTO amo_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Kube na Yisa wa di in Baithanya nan nya kilarin Simon ukuturu a sosino nli nimonli, umong uwani da nin libon nnuf mongo na idin yicu minin, “Narda” min nikurfung kang a puno minin a kalaghe liti. ");
INSERT INTO amo_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Among wa duku nanya mine na iwa lanza ayi. I lira nati mine iworo, “Bara iyanghari idin nanzun nnuf mone? ");
INSERT INTO amo_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nnuf kunya kumang mone batin nworu ileu minin nnu ni dinari akalt atat ini nikimon.” I tunan ngbandulu litin nwani une. ");
INSERT INTO amo_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yisa woro nani, “Bara iyanghari idin ngbondulu litime? A suyi imon icine. ");
INSERT INTO amo_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","I sosin nan nikimon ko kishi, iwasa i su nani imon icine vat kubi kongo na nibinai mine yinna, meng tutun anung di nan mi ko kishi ba. ");
INSERT INTO amo_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","A su imon ilenge na a wa sa a su: A kelei yari bara liyirin nkul ning. ");
INSERT INTO amo_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Kidegen ari mbellin minu, vat kiti kanga na iba belu uliru Kutellẹ ku nanya nyih ulele, imon ilele na uwani ulele su imamang belu uliru mẹ nanyan yï ulele.” ");
INSERT INTO amo_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Yahuda Iskarioti warum nayan nono katwu me likure nin nan wabe do kiti na didya kutin nlira anan lewe Yisa ku nachara mine. ");
INSERT INTO amo_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Na adidya kutin nlire nlanza nani, ulire bina nani itunna ita likawali ima nighe ikurfung. A cizina upiziru libau longe na ama kifughe a lew nani. ");
INSERT INTO amo_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Liyirin cizinun mbukin Paskan mburodin nsalin yist na iwa malu ubọ kukam nlira, nono katwa me tiringhe, “Ti ba du weri ti di kele fi kiti kanga na uma li imonli ku?” ");
INSERT INTO amo_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","A to an waba nan nyan nono katwa me aworo nani, “Can nan nya kipine ima zuru nin mong na a torin lidulin mmyen i dofinghe. ");
INSERT INTO amo_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Kilari kanga na a pira ku i wufunghe udu nanyeh, i balle unan kilare, 'Chikilarin nworo, Kuti limara nighe din we ari na nma li imonli ku ligowe nin nono katwa nin?”' ");
INSERT INTO amo_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ama dursu minu kong kuti ketene ku pash kongo na ikele kunin gegeme, i kele nari imonle nanye. ");
INSERT INTO amo_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Nono katwa we gya udu nanya kipene idi se imone di dirt nafo na a belle, itunna i kelle uciwu nimonlin mbukin Paske. ");
INSERT INTO amo_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Na kuleleng nta a da ligowe nin likure nin nan wabbe. ");
INSERT INTO amo_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Na ikilino kutebule nli niimonle Yisa woro, “Kidegen mbelin minu, unit urum nan nya mine na adin nli nimonli ligowe ninme a ma lewi. ");
INSERT INTO amo_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Vat mine ayih tunna a nana nani kang, i tirighe na lalarum, “Sa me ari?” ");
INSERT INTO amo_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yisa kawa a woro nani, “Umong ari nan nya likure nin nan wabbe ulenge na a shono uchara me nanya kishik nimonle ligowe nin mi. ");
INSERT INTO amo_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Gono in nit ma katu nafo na ina nyertin kitene liti me, kash in lenge na ima ni Gonon nit nachara me! Ukatin nin chaut iworo na iwa na marughe ba.” ");
INSERT INTO amo_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Na iwa di kileo we, Yisa yauna uburodi, a ta mmari, ku a nyemile unin. A niza nani a woro, “Leon. Kidowo ning ari kane.” ");
INSERT INTO amo_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","A yauna kakkuke, a tan nlira a nakpa nani vat mine sono nan nya kakkuke. ");
INSERT INTO amo_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","A woro nani, “Min nare ingmyi likawali, mongo na ina gutun bara a nit gbardang. ");
INSERT INTO amo_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Kidegen ari mbelin minu, na nma kuru nsono mmyen kumat kucha kongone ba, sei liyiri longo na nma sonu minin mi Pesse nan nya kilari tigo Kutellẹ.” ");
INSERT INTO amo_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Na i mala uti nasem, itunna i gya udu kuparan Zaitun. ");
INSERT INTO amo_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Yisa woro nani, “Vat nghinu ima diu bara meng nafo na ina nyerting, nma kpiu unan, 'libya nakame, Akame ma malu kiti.' ");
INSERT INTO amo_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Asa ifyayi, ima gyiu nbun mine udu Ugalili.” ");
INSERT INTO amo_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Bitrus woroghe, “Andi anite vat ma diu, na meng ma diu ba.” ");
INSERT INTO amo_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yisa woroghe, “Kidegen nbellin fi nin kitic kane, kafin kukulok kolsin tiba fye ba nari titat.” ");
INSERT INTO amo_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Bitrus woro, “Asa uso nma ku ninfi na nma narifi ba.” Vat nin yinna nin liru urume. ");
INSERT INTO amo_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ida kiti kanga na idin yicu kinin Jethsaimani, Yisa woro nono katame, “Song kikane ndo ndi ti nlira.” ");
INSERT INTO amo_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","A yono Bitrus ku nin Yuhana a Yakubu igya ligowe, a cizina uniu ichang nin kpilizu nan nya kibineyi me. ");
INSERT INTO amo_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","A woro nani, '' Ulai nin dinin tiyom kang, udu ukul wang. Yisinan kikane isu ucha.'' ");
INSERT INTO amo_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Yisa chillina udu ubun, a deu kutin anin tah nlira, asa uma chaunu ukalai kokube. ");
INSERT INTO amo_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","A woro, “Abba, Uchif, imon vat nsuari kitife. Kalai kakkuk kane litinin, na nafo ubellu nin ba na unfe so.” ");
INSERT INTO amo_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Akpilla adase nanin nmoro, anin belle Bitrus ku, “Simon, idin nmora-a? Na iwasa ita kubi kurum nyenju kiti ba? ");
INSERT INTO amo_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Yenjeng kiti isu nlira bara iwa piru nanya ndumuzunu. Nfip Kutellẹ nyinna kidowe ka nari.” ");
INSERT INTO amo_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","A kuru agya udun nti nlire, a kuru abelle tigulan tirume. ");
INSERT INTO amo_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ada senanin nmoro tutung, bara nmoro wa di nizi mine ichang na iyinno imong ille na ima bellinghhe ba. ");
INSERT INTO amo_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ada untat ada woro nani, “Idu nmoro nin shinuare? Batan nani! Kube nda. Yenen! Ima nakpu gonon nnit nan nya nachara nanan kulapi. ");
INSERT INTO amo_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Fitang ti gya. Yenen, ullenge na ama kifi anakpa ndaduru. ");
INSERT INTO amo_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ayita nlire na idondonoba, Yahuda uwa rum nanya likure nin nan awabe, da nin ligozin nanit gbardang nin titang nan tiyop unuzu kiti nan kubi nlira, anan niyert nan nakune. ");
INSERT INTO amo_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ulle na ama lewughe, namo unanin kulap, a belle, vat ulle na ngbindiringhe amere. Kifonghe anan techu natino nya ninghe. ");
INSERT INTO amo_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Na Yahuda nda, atinna ada kitin Yisa, a woro, “Rabbi!” Anin gbindiringhe. ");
INSERT INTO amo_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Inin Kifoghe inyamu. ");
INSERT INTO amo_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Umong nanya mine nutuno litang lidya a kala kutuf nnan kata ndya kutin nlire. ");
INSERT INTO amo_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Yisa woro nanin, “Ida nafo ima kifu ukiri nin titang nan tiyop ida kifoiya?” ");
INSERT INTO amo_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Na nwadi nan ghinu kolome liri, ndursuzu minu nanya kutin nlira, na ikifei ba. Idin su ile imone bara inyerti nan kullo. ");
INSERT INTO amo_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Vat nalle na iwa di nan Yisa wa chom isunghe. ");
INSERT INTO amo_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Nkong Kwanyana dofinghe, na awa kiring nin gudun ubo; ikifoghe ");
INSERT INTO amo_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","a suna ugudume kitene aco fisere. ");
INSERT INTO amo_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ido nin Yisa ubon ndya kutyi nlira. Adidya kutyi nlira, Akune, nan nanan ninyerti vat da zuro nanghe. ");
INSERT INTO amo_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Bitrus tinna adofighe na susut ba, udu duru kiti kutyi ndya nwucu nlire. A so ligowe nan nanan nca, na iwa din lanzu nla. ");
INSERT INTO amo_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Udya na didya nin na nan kpilizu me wa din npizuru libo longo na ima se Yisa ku nin Kulapi imolughe. Na ise ba. ");
INSERT INTO amo_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ngbardang na mon mine dasa nin liru kinu na uliru mine nse upiru ba. ");
INSERT INTO amo_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Among fita iyisina isu uliru unkinu litime; i woro, ");
INSERT INTO amo_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Tina lanzaghe aworo, 'Nma turnu kutyi nlira ko na ina kye nin na chara, nan nya nayiri atat mma kye nkong kongo na ina kye nin na chara ba.'” ");
INSERT INTO amo_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Inug wang na uliru mine wase upiru ba. ");
INSERT INTO amo_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Udya na didya kutyi nlire fita ayisina kitik mine atirino Yisa ku, “Na udi nin tardu ba? Uyapin ulirari ullele na anit din bellu litife?” ");
INSERT INTO amo_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Vat nin nani amino tik na atardaba. Udya na didyawe kuru atiringhe a woro, “Fere Kristi, usaun Kutellẹ mmarẹ?” ");
INSERT INTO amo_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yisa woro, “Mere ame. Usaun nnit ullenge na ima yenughe a sosin nchara ulime tigo adin cinu nin nawut kitene kani.” ");
INSERT INTO amo_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Udya na didya kutyi nlire jarya kulutuk me a woro, “Tidu nin sun mon ukpinu lirikwa? ");
INSERT INTO amo_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Anung nlanza tizogo Kutellẹ. Yaghari ukpilliu mine?” Vat mine yinna nworo abatina asso nca nkul. ");
INSERT INTO amo_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Among cizina utufuzinghe nataf i tursuzughe umuro, ikpizoghe i bellinghe, “Su nari uanabci!” Ana ncha ngo Yonghe ikpizoghe. ");
INSERT INTO amo_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Bitrus da yita kadas kutyin nwucu nlira, nkon kubura nanya nanan katah ndya kutyi nlire da seghe. ");
INSERT INTO amo_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ayene Bitrus ku din nlanzu nla atinna abelle, fewang una yita nin kunan Nazaret, Yisa.” ");
INSERT INTO amo_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Abelle “Kinuwari, na nyinno ile imon na udin nbelle ba.” An gya kiti nanite adi piru kudaru nwucu nliru. Ku kulloke kolsuno. ");
INSERT INTO amo_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Kubure kuru ayeneghe atinna nbellu na lenge na iyissin kite, “Unit ullele umong nan nya minere!” ");
INSERT INTO amo_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Akuru anari tutung. Nanin dandaunu ba, allenge na iwa yissin kitene tunna nbellun Bitrus ku, “Kidegenere udi nanya mine, bara fewang kunan Galiliari.” ");
INSERT INTO amo_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Atunna a cizina tizogo nin nisiling, “Na in yiru unit ullele na idin liru litime ba.” ");
INSERT INTO amo_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Kukuloke tunna ku kolsuno un ba. Kitenere Bitrus tunna a lizino nin lire na Yisa wa bellinghe: “Kamin kukullok kolsin tiba Uba nari sau titat.” Na alizino nani kidowo me kughe, apuro kuchulu. ");
INSERT INTO amo_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nin shantu kiti nin kui dinding, adidya kutin nlira, nan nalcu kuna, nan nanan niyert a-a vat an lisosin tere tinu, itere Yisa inya ninghe idi nakpa Bilatus ku. ");
INSERT INTO amo_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Bilatus tinighe, “Fere ugo na Yahudawe?” a kawaghe, “U belle nane re.” ");
INSERT INTO amo_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","A didya kutin nlire dunjo tinu gbardang kitenne Yisa. ");
INSERT INTO amo_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Bilatus kuru atiringhe, “Na ukawa ba? Lanza tipinpin tongo na idin bellu litife? ");
INSERT INTO amo_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Na Yisa nkuru akawa Bilatus ku Ulliru ba, imone na Bilatus ku umamaki. ");
INSERT INTO amo_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Kubi idi Bilatus asa bunku nani kucin kurum, urika na inin tiringhe. ");
INSERT INTO amo_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Nan nya nanan licinne among waduku anan firu nnun, nan nya nanan nfiru nune lisa nmong wa di Barabas. ");
INSERT INTO amo_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ligozin nanite da kitin Bilatus i woroghe a sü nani imonghe na amene nsue. ");
INSERT INTO amo_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Bilatus kawa nanin a woro, “I dinin nsu nsun minu ugoh na Yahudawa?” ");
INSERT INTO amo_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Awa yinin bara ivirari nta adidya kutin nlira da nin Yisa kitime. ");
INSERT INTO amo_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Adidya kutin nlira tula ligozin nanite Ighantin tiwui ibellinghe idinin su ibunku nanin Barabasari ku. ");
INSERT INTO amo_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Bilatus kawa nanin tutung aworo, “Nene yaghari nba ti nin goh na Yahudawe?” ");
INSERT INTO amo_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ikuru ighantina tiwui, “Kotinghe kitene kucha!” ");
INSERT INTO amo_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Bilatus woro nani, “Iyapin imon inanzanghari atah?” Ikuru ighantina tiwuiye, “Kotinghe.” ");
INSERT INTO amo_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Bilatus wa yita nin su a nonko anite nibineyi, a bunku nani Barabas ku. Na a kpizo Yisa ku anin nakpa nanin ame idi kotinghe. ");
INSERT INTO amo_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Anan techu natino pira ninghe nanya kutii lipitin, inin yicilla lipitin nan techu natino. ");
INSERT INTO amo_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ishono Yisa ku kultuk kudya, i peu imart itaghe liti. ");
INSERT INTO amo_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ichizina ulisuzughe, “i lisofi ugo na Yahudawa!” ");
INSERT INTO amo_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","I kpeghe liti nin likpu, i titizinghe ataf. Izazinghe, itumuzunghe. ");
INSERT INTO amo_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Na iwa malu usughe liyong, ikalaghe kultuk kudyawẹ, ikpilla i shonghe kunme. I gya ninghe uchin din kotinghe. ");
INSERT INTO amo_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ita umong unan katu ayauna kucha nkotunẹ gbas, ulenge na awa nuzu kagin gbiri, lisame Simion kunan Kirawani (uchiffin Alexander nin Rufus). ");
INSERT INTO amo_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Anan techu natino da nin Yisa nkankiti na idin sumun u Golgotha (kikanga na idin yicu skull). ");
INSERT INTO amo_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Iketilne nmyen inabi nin myrrd inaghe anari usonẹ. ");
INSERT INTO amo_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ikotinghe kucha inin koso imon me isu maferu feru natimine kitene nimon me iyinin kome kusareri kogha mase. ");
INSERT INTO amo_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Kubi nikoro itat nin kulelenghari iwa kotinghe. ");
INSERT INTO amo_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","I yertine kulap I tafaghe kuchẹ un bellu kulapi me, “UGOH NA YAHUDAWA.” ");
INSERT INTO amo_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Iwa kotinghe ligo nin nakiri a waba, uwarum nchara ulime, uwwarum nchara ugule. ");
INSERT INTO amo_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ulire na iwa su nanya niyertẹ kullo ulenge na iwa bellinng (Imunughe ligowe na nan kulapi). ");
INSERT INTO amo_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Alle na iwa din katizu libauwe zoguzoghe, izullu atimine mine idin du “Aha” fe ulle na uba turnu Kutin nlira ukuru ukẹ kunin nanya nayiri attat, ");
INSERT INTO amo_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","bollo litife utolu kitene kuche!” ");
INSERT INTO amo_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Nanere wang adidya kutin lira wa dighe liyong ligowe nan nanan niyerte iworo, “Ana tuchu among amini ndari utuchu litime. ");
INSERT INTO amo_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Na Kristi, ugoh Isaraila tollu kitene kuchan kotine, tinan yene tiyinna.” Allenge na iwa kotin nani ligowe billighe uliru unanzang. ");
INSERT INTO amo_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Kubi kun tochin, kiti tinna kisirou vat udu ikoro in tir. ");
INSERT INTO amo_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nin fikoro fin tire Yisa tina ghatina liwui, “Eloi, Eloi, Lama Sabatani?” Ulle na ukpliwe nworo, “Kutellẹ nin, Kutellẹ nin, inyagharin ta usuni?” ");
INSERT INTO amo_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Among na iwa yisin kupowe lanza inin woro, “Lanzang adi yichu Iliya ku.” ");
INSERT INTO amo_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Umong tah uchum adi shintin usoso nmyen mi gbalala, ata likpu, anakpaghe asono. Unite woro, “Nati yene sa Iliya ba da toltinghe.” ");
INSERT INTO amo_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Yisa ghatina liwui ata kuchulu atinna aku. ");
INSERT INTO amo_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Kuzeni kongo na kuwa kese kiti kilau kutï nlire tinna kujarta tiba unuzu kitene unuzu kitene uda dak kadas. ");
INSERT INTO amo_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Na unan chawe na awa yising in yenju Yisakun yene aku nani, aworo, “Kidegen unit ulele gono Kutellẹri.” ");
INSERT INTO amo_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Among awani wang wa yisin npït idin yenjẹ. Nanya mine Maremu Magadaline, Maremu (unan Yakubu ubene nin Yoses), a Solomi. ");
INSERT INTO amo_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Kube na awadi in Galili iwa dofinghe isuzughe katah. Among awani gbardang wa da ninghe Urushalima. ");
INSERT INTO amo_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Na kuleleng nta, bara lire wadi lirin kye kitiari, wati liri kafin lin na Sabat, ");
INSERT INTO amo_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Yusufu kunan Armatiya da kite, awa di umong udyawa nanya nanan kutï nlira, ulle na awadin cha ntollu kilari tigoh Kutelle. A tah ayi akone ado adi tiring kidowo Yisa kitin Bilatus. ");
INSERT INTO amo_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Bilatus lanza umamaki nworu Yisa mal ku; ayichila unan chawe atiringhe sa Yisa mal ku. ");
INSERT INTO amo_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Na awa lanza kitin na chawa Yisa nmal bku, a na Yusufu ku kidowe. ");
INSERT INTO amo_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yusufe wadi amal seru kumalti. A toltighe kitene kuchẹ a techeghe nya kumaltẹ, adi nonkoghe nanya na tala. Ma anin yillino kutala a tursu kibullung kiseke mun. ");
INSERT INTO amo_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maremu Magdaline nin Maremu unan Yoses yene ki kanga na ikasa Yisa kuku. ");
INSERT INTO amo_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Na liri na Sabbat wa kata, Maremu Magdalin nin Maremu unan Yakubu, a Salomi, sere imong kugya kumang, inan da ida tintilo kidowo Yisa bara ukasu. ");
INSERT INTO amo_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Nin kwui didin lirin in cizinu nayiri kuzor, iwa dak kiseke kubin nuzun wui. ");
INSERT INTO amo_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Iwa din bellu natimine, “ghari ma turnu nari litala kibulun kiseke?” ");
INSERT INTO amo_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Na iwa ghantin iyizi kitene kani, iyene umong in mal turnu kutale, kongo na kuwadi gbardang kang. ");
INSERT INTO amo_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ipira iyene in koon kwanyana nin nimon ibọ, asosin kusarin cara ulime, isu umamaki. ");
INSERT INTO amo_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Aworo nani “Na iwa lanza fiu ba. Idin pizuru Yisa ku, unit in Nazaret ullenge na iwa banaghe kitene kucha, a fita! Adi kikane ba. Gbinon iyene, kite kanga na iwa ceoghe ku. ");
INSERT INTO amo_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Nene can idi bellin nono katuwa me nin Bitrus, adin cinu nbun mine udu u Galili. Kikane iba yenugheku, nafo na awa bellin minu.” ");
INSERT INTO amo_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Inuzu kiseke nin chum; iwadin ketuzu nin mamaki, na iwa bellin imon imoimon ba, bara iwadin lanzu fiu. ");
INSERT INTO amo_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Nin kwui didin liyirin cizunu nayiri kuzor, na awadi amal fitu, awa cizin udursuzu litime kitin Maremu Magdalin, ullenge na awa nutun agbergenu kuzor nanya me. ");
INSERT INTO amo_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","A gya adi bellin allenge na iwa di ninghe, kubi ko na iwa di tiyom nin kuculu. ");
INSERT INTO amo_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Ilanza adinin lai, nin wo amal fitu kiti me, na inungh wa yinin ba. ");
INSERT INTO amo_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Kimal nille imone vat, adurso liti me kiti nan waba nin kang kidowo ugang, kubi ko na iwa cinu unuzu udu in kang kagbiri. ");
INSERT INTO amo_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ido idi bellin kagisin nono kadurẹ, na inugh yinna nin nimone na ibelle ba. ");
INSERT INTO amo_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Nin kidughe, Yisa durso litime kiti nanit likure nin nit urum, na iwa din linimonli kutebul, a gbada nani bara usalin yinnu mine, nin gangang nibinai mine, bara na iwa yinni nin na lenge na iwa di imal yennughe kubi ko na awadi amal fitu nanya nanan kul. ");
INSERT INTO amo_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Aworo nani. “Can nanya inyï vat. ");
INSERT INTO amo_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ullenge na ayinna, isulsunghe lau amere mase utucu, ame ullenge na ayinna ba, iba sughe ushara. ");
INSERT INTO amo_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Alle alappe ma dofinu allenge na iyinna. Nanya Lisa nighe iba nutuzunu agbergenu. Ima liru nin telem tipese. ");
INSERT INTO amo_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Iba yauzunu iyï nin nacara mine, iwa sono imoimon timung na iba tinani imon ba. Ima tarduzu anan tikonu acara ishizin nin ghenu.” ");
INSERT INTO amo_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Kimalin malun lire na Cikilare wa sunani, iwa tunung iyiraghe udu kitene kani, adi so ncara ulime Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nono katuwa me gya idi bellu uliru Kutelẹ nanya kowe. Cikilare wadi katuwa nan ghinu, adi teru limurin lirẹ nin nimon mamaki nalap na awa dofin nani. ");
INSERT INTO amo_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Anit gbardang wa mala unyertinu nadu adu na ana malu kulu nanya bit. ");
INSERT INTO amo_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Alenge na iwa di iyizin yenju ucizunun burne ida so acin ligbulang, ida so acin ligbulang, ida belle arike ku. ");
INSERT INTO amo_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nani, udu menku gigime wang nin feru nimoon dert oworu uburnu-nnan nyertine inin dert-udak kitin Theofilus unit ugigime. ");
INSERT INTO amo_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ndi nin su iyinin incasarak nimoon ile na ina masu minu. ");
INSERT INTO amo_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Nanya nayirin Hiridus, ugon Yahudiya, umong unit wa duku ku priest lisa me Zakariya, unuzun likuran Abijah. Uwani me wa di unuzu anashonon Haruna, lisa me Alisabatu. ");
INSERT INTO amo_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Vat mine iwa cinu dert mbun Kutelle, icing lau sa utanu vat nanya nadu na Kutelle wa di nin su we. ");
INSERT INTO amo_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Na iwa di nin nonol ba, bara na Alisabatu wa di uwanin sali kumat, vat mun wa di imalu ti akune. ");
INSERT INTO amo_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Lon liyiri Zakariya wa di kiti katwa me kan ti priest mbun Kutelle. ");
INSERT INTO amo_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","A priest nanya nadu ale na imenen sue ifere Zakariya ku a piro nanya kutiin nlira Kutelle a juju uhadaya. ");
INSERT INTO amo_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ligoo na nite vat wa sosin ndas iyitan nlira kube na iwa jujun hadaye. ");
INSERT INTO amo_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Gono kadura Kutelle tunna a nusno mbun me, a yisina likoot ncara ulime kupo napik njujuzun hadaya. ");
INSERT INTO amo_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakariya ta zabat kube na awa yeneghe; bara na fiu wa kifoghe kang. ");
INSERT INTO amo_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Gono kadura Kutelle woroghe, “Na uwa lanza fiu ba, Zakariya, bara ina lanza nlira fe. Uwane fe, Alisabatu, ama maru fi gono, uma ni lisa me Yohanna. ");
INSERT INTO amo_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ima se mmang nin kibinai ki mang bara ame, anit gbardang ma lanzu mang nin maru me. ");
INSERT INTO amo_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ame ma yitu unit u dya kiti Kutelle. Na a ma sonu nmyen nanab sa ntoro ba, Ima kulu ngeh nin Ruhu Ulau a dutu nanya liburin nna me. ");
INSERT INTO amo_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","A ma ti non Israila grardang i kpilin udak kitin Cikilari Kutelle mine. ");
INSERT INTO amo_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","A ma katu mbun me nanyan ruhu nin likaran Iliya. A ma kpiliu nibinai na cif udu kitin nono, a ti anan dortun liru i cunu nanyan yiru nin libau licine. Ama su nani anan ta anit isoo kiti kirum nanya lisosin ncaa ndak Ncikilari.” ");
INSERT INTO amo_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zakariya woron gono kadura kutelle, “Nmati iyiziari nyimin kubin dak ni le imone? Bara na meng kukune ari, uwani ning tutung mali ti kuwali.” ");
INSERT INTO amo_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Gono kadura Kutelle kpana a woro, “Meere Jibrailu, in yisin mbun Kutelle. I wa tuyi nda bellin fi nda nifi uliru umang ulele. ");
INSERT INTO amo_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Yene, uma ti uturo na u ma liru ba se kubi ko na uliru ulele ma kulu, bara unari uyinnu nin tigbulang too ne, ton go na ti ma kulu nanya kubi ku dert.” ");
INSERT INTO amo_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nanya nani, anite wa din ncaan Zakariya iyitan Kpilizue iyang ari ta a mini dandauna tituut nanya kutiin nlire nani. ");
INSERT INTO amo_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kube na awa nuzu udas, na ayinno uliru nan ngyinu ba, itunna yinno a di yene amoro Kutelle nanya kutiin nlire. A bela nani nin nacara, nna yinno uliru nin nuu ba. ");
INSERT INTO amo_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Na ayiri katwa me nkulo, a yanya udu kilari. ");
INSERT INTO amo_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Na ayirin nda, uwani me Alisabatu ta liburi. A nyeshe litime tipui titaun, adin su, ");
INSERT INTO amo_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Ile imone Kutelle ari suui mun. Adin yenjii, aba kalui imon ncing nanya na nit.” ");
INSERT INTO amo_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nene nanya mpuin toocin nin ti liburin Alisabatu, itoo gono kadura Kutelle Jibrailu udu nanya nkang kagbirin Galili, lisa kanin Nazarat, ");
INSERT INTO amo_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","kitin nkong kubura na awa su likawali nin mong unit lisa me Yusufu. A wa di likura nan Dauda, lisa kubure wa di Maryamu. ");
INSERT INTO amo_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gono kaddura Kutelle da kiti me, a woro, “Nliso fi, udi gongong kang! Kutelle di ligowe ninfi!” ");
INSERT INTO amo_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","A tunna ata kpak nin tigbulang to ne, anin kpiliza sa imus ni yapin ilipp ari ine di. ");
INSERT INTO amo_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Gono kadure woroghe, “Na uwa lanza fiu ba, Maryamu, fee nse ngongong kiti Kutelle. ");
INSERT INTO amo_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","See, u ma ti liburi u maru gono, u ma ninghe lisa Yesu. ");
INSERT INTO amo_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","A ma yitu udya, i ma yicu lisa me Gonon Ngo Udya kitene kani. Kutelle Ucif ma nighe kutett tigo ncif me, Dauda. ");
INSERT INTO amo_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","A ma su tigo kitene nakuran Yakubu udu sa ligang, na kutii tigo me ma yitu nin nimalin ba.” ");
INSERT INTO amo_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Maryamu woron gono kadure, “Iyiziari ile imone ma ti, meng tutung du kabura?” ");
INSERT INTO amo_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Gono kadura woro nghe, “Uruhu Ulau ma dak Kiti fe nin likara Ndya kitene kani ma kirinfi. Bara nani, unit ulau une na uma maru i ma yicu lisa me Gono Kutelle. ");
INSERT INTO amo_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Yene, Alisabatu likura fe wang di nin fisud (liburi) nanya tiwali me. A di nanyan piu untoocin nin libure, vat nin yicue na iwa yicu nghe uwanin diru kumat. ");
INSERT INTO amo_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Na imon katin likara Kutelle ba.” ");
INSERT INTO amo_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Maryamu woro, “Usoo nani, meng kucin Ncikilari ari.” Na ile imone so dert nafo na ubelle. ");
INSERT INTO amo_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nanya nayiri ane Maryamu tunna a fita dedeiughanu udu kipin, udu kang kagbiri nayan Yahudiya. ");
INSERT INTO amo_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","A pira nanya kilarin Zakariya a liso Alisabatu ku. ");
INSERT INTO amo_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Kube na Alisabatu wa lanza ilippin Maryamu, gono nanya liburi me tunna ki metiline, Alisabatu tunna a kulo nin Ruhu Ulau. ");
INSERT INTO amo_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","A tunna a lirina a ghantina liwui kang a woro, “Fe unan mmari ari nanya nawani, fisudu nanya liburi fe wang di nin mmari. ");
INSERT INTO amo_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Iyizi ari nta unan Cikilari ning na dak kiti ning? ");
INSERT INTO amo_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kubi kongo na liwui nilip fe wa diu natuf ning, gono nanya liburi ning tunna a zulluno bara ayi aboo. ");
INSERT INTO amo_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ame ulenge na ayinna a di nin mmari, bara na uliru ulenge na ina belin litime unuzu kitin Cikilare ma kuluu.” ");
INSERT INTO amo_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maryamu woro, “Ulai ning di liru Kutelle, ");
INSERT INTO amo_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Uruhu ning di nayi abo nin Kutelle unan tucu ning. ");
INSERT INTO amo_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Bara na ana ghantin kuchin me kikimon. Nin nene udu ubun ji ma yicui unan mmari. ");
INSERT INTO amo_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Bara na Ame Udya na su imoon ididya bara meng, tutung lisa me di lau. ");
INSERT INTO amo_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nkune-kune me di kitene kuji udu kuji na nit alenge na idin lanzu fiu me. ");
INSERT INTO amo_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ana su imon likara nin cara me; ana malu kiti nin na lenge na idin ghantizunu ati mine. ");
INSERT INTO amo_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ana toltizin ago ketene natet tigo mine, anin ghantina kimon. ");
INSERT INTO amo_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ana niza anan kukpong imonli icine, anin kko anan nimon naacara sa imong nacara mine. ");
INSERT INTO amo_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ana bun kucin me Israila, anan lizino nin ");
INSERT INTO amo_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ibrahim nin likura me sa ligang, nafo na awa ti likawali kiti nan kaa bit a masu.” ");
INSERT INTO amo_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maremu wa so nin Alisabatu tipui titat, anan kpilla udu kilari me. ");
INSERT INTO amo_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Na kubin Alisabatu wa duru kongo na ama maru gono me a tunna a mara gono. ");
INSERT INTO amo_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","A doon lisosinn me nan likura me lanza ubeleng inkune-kune mongo na Kutelle su Maremu ku, inung wang su ayi abo ligowe ninghe. ");
INSERT INTO amo_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ituna, na ayiri linuanu me in kulo ayiri kulir, idaa nda kalu kucuru ngone, iwa din nworu inighe lisan Zakariya, nafo lisan incifme. ");
INSERT INTO amo_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Unan gone kpana a woro, “Babu, ima yicu lisame Yohanna ari.” ");
INSERT INTO amo_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Anite woroghe, “Na umong duku nanya likura mine na idin yicughe nin lisa lole ba.” ");
INSERT INTO amo_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Itunna i kpiliya ucifin ngone ulire nin nacara inan yinno lisa longo na ibaa yicu gone mun. ");
INSERT INTO amo_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","A joorino nin cara inighe imon nanyert, a tuna a nyertine, “Lisa me Yohanna ari.” Vat mine umamaki kifo ani. ");
INSERT INTO amo_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Na nin nanzu kubi ba unuume tunna upuuno kidowo lileme buntu, a tuma nliru, nin su liru Kutelle. ");
INSERT INTO amo_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Fiu tunna fi kifo alenge vat na iwa di ligowe kite itunnan belu nimon ilenge na isu vat nanya kipin natala ucin du Uyahidiya. ");
INSERT INTO amo_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Vat na lenge na iwa lanza ubeleng nimon ilele itunan kpilizue nanya nibinai mine iworo nenghe, “Ani nene, gono kane ma yitu Iyiziari?” Bara na iwa yinin ucaran Ncikilari di ligowe ninghe. ");
INSERT INTO amo_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ucif me Zakariya wa kulun nin Ruhu Ulau, a tunan belu nimon ilenge na ima su mbun, ");
INSERT INTO amo_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Liru udu kitin Cikilari, Kutellen Israila, bara na ana dak kiti bit a puuno lbaun nutunu nanitme licin. ");
INSERT INTO amo_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ana ni nari unan likaran tucu nanya likura kucinme Dauda, ");
INSERT INTO amo_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nafo na Kutelle wa belin tinuu nnono ni lau kadura me uworu. ");
INSERT INTO amo_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","A na ti nari likawalin tucu nacara na nan nivira bit, nin nacara na lenge na inari arik. ");
INSERT INTO amo_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ana su nani anan durso nkune-kune udu nan kaa bite, anan nin likawale me, ");
INSERT INTO amo_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","loli likawale isilinari na awa belin udu kitin kaa bit Ibrahim. ");
INSERT INTO amo_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","A wa su isilin anan nutun nari nanya nacara na nan nikira bit anan ta nari ti sughe katwa sa fiu, ");
INSERT INTO amo_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","nanyan nlau ni su nimon icine mbun me udu ligan nayiri bit. ");
INSERT INTO amo_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","A fee, gonon ning, ima yicufi unan liru nin nuu Kutelle Ugo Udya, bara na uma diu mbun Incikilari ukelee anit bara udak me, ");
INSERT INTO amo_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","unan buuno anit iyinin use ntucu nshawa nin nalapi mine. ");
INSERT INTO amo_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kutelle bite ma shawa nin nalapi bite bara nkune-nkune migbardan me, kitenen mon kune-kune, unan tucu ulenge na adi nafo uzun nwui, ma dak unuzu kitene kani a da bun mari. ");
INSERT INTO amo_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","A ma ni nkanang kiti nalenge na isosin nanyan nsirti nin kuyelin nkul. Ama dortu nin nabunu bite nanya libau lisosin limanng.” ");
INSERT INTO amo_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Gone tunna ki kuno, ada nin likara kidowo nin ruhu. A wa di so nanya kusho ku kau udu kobi kongo na a wa cizin upicu nanya na nitin Isaraila. ");
INSERT INTO amo_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nene nanya nayiri a ne, kaisar Agustus yita tigo a nutuno uduka nworuu i nyertu tisa na nit vat na idi nanyan mmyin nRoma. ");
INSERT INTO amo_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ulelere kibatiza nfari na iwasu kubi na kiriniyas wandi ugumuna nSiriya. ");
INSERT INTO amo_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ko gha nya udu kagbir mye idi nyertu ghe bara kibatiza. ");
INSERT INTO amo_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yusufu fita anuzu kipin Nazarat nanya Ngalili, acina udu Uyahudiya, kipin Baitalami, kanga na iyuru kinin kipin Dauda, bara ame wandi kuwunu unuzu likuran Dauda. ");
INSERT INTO amo_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","A doo kikane idi nyertin ghe nin Maryamu, ule na awa di kubura nilugma mye, iyita ncaa ngono. ");
INSERT INTO amo_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nene uduru kubi na iwadi kikane, kubi nmaru ngono da ghe. ");
INSERT INTO amo_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Amara gono, kin pari mye, a tursu ghe nin kupori, a cio ghe kiti nlii nimonli nakam. Bara na kutyi wa duku ba, kilari namara. ");
INSERT INTO amo_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kusari kone, anan liwalli ninab wa duku, alenge na iwa sosin nfong iwadi ncaa ligozi nakam nin kiitik. ");
INSERT INTO amo_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kpak unan kadura Ncikilari nuzu kiti mine, ngongong Kutelle din nbaltu kiyitik mine, fiu da noni. ");
INSERT INTO amo_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Unan kadura Kutelle woro nani, “Na iwa lanza fiu ba bara nba bellin munu uliru ucine, ulenge na uba dak nin lanzu nmang kang kiti nanit vat. ");
INSERT INTO amo_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kitimone imarra munu unan tucu, nanya kagbir Dauda! Amere Kristi Cikilari! ");
INSERT INTO amo_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Alamere ale na iba ni munu, iba se gone ikiroghe nin kuzeni anong kiti nlii nimonli nin kuzeni anong kiti nlii nimonli nakam.” ");
INSERT INTO amo_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Kpak nin unan kadura Kutelle a soja kiteni kani gbardang wan duku nsu liru kutelle idin su, ");
INSERT INTO amo_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ngongon udu kiti Kutelle kitene kani, lisosin lishau ba yitu inyi nanya nanit nin nalenge na ayi mye npoon ninghinu.” ");
INSERT INTO amo_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Uso na unan kadura Kutelle nnnya kiti mine, anan liwali nine woro natimine, “Cannari nene udu Baitalami tiyene imon ile na idi ilenge na Cikilari nta tiyino inin.” ");
INSERT INTO amo_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ido kikane dedei ise Maryamu ku nin Yusufu, iyene gono nonn kiti nlii nimonli nakame. ");
INSERT INTO amo_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Na iyene nani, ita anit yinno imon ile na ibelle nani kitene ngono kane. ");
INSERT INTO amo_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Vat nalenge na iwa lanza ikifo tinnu, bara ile imon na ubelle nani kiti na nan liwali ninah. ");
INSERT INTO amo_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ame Maryamu tinna nkilizu kitene vat nile imon na lanza acio inin nanya kibinai mye. ");
INSERT INTO amo_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Anan liwali nineh kpilla, idin nzazinu nin liru Kutelle, bara imon ile vat na ilanza, iyene idi nafo na ina belin nani. ");
INSERT INTO amo_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Na ayiri kuliri nkulo, kubi nkalu kucuru ngone ndah, inaghe lisa Yesu, Lisa na unan kadura Kutelle wa mallu unighe, kamin nuzu nanya libure. ");
INSERT INTO amo_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Na ayiri linanu mye nmala, bara uduka Musa, Yusufu nin Maryamu damun kagone nanya kutyi nliran nurushelima, inakpa ghe kitin Cikilari. ");
INSERT INTO amo_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Nafo na inyerte di nanya duka Cikilari, “Ko kame gono nfari kilime iba yicu ghe ulau Ncikilari.” ");
INSERT INTO amo_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Tutun iwa dak ida ni uhudaya bara uleli ubelle nanya nduka Ncikilari, “awullung abba sa atanta bara.” ");
INSERT INTO amo_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Au umong unit nanya Urushelima lisa mye Simeon, unit une ullau wari unan ni litii, awadi ncaa nle na aaba da bunu Isiraila ku, Uruhu ulau wa di litimye. ");
INSERT INTO amo_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Awa se uleli uyinno kiti nruhu ulau, na uwa woroghe, na ame ba kuu ba, sei ayene Cikilari Kristi. ");
INSERT INTO amo_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nlon liri ada kutyi nlira, Uruhu ulau wari wa dofin ninghe. Kubi na Ucife nin nne wa dinin gone Yesu, ida sughe ile imon na uduka anbelle isu. ");
INSERT INTO amo_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ame Simeon ne sereghe nin nacara mye, asu liru Kutelle anin woro, ");
INSERT INTO amo_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Nene na kucin fe nya sheu, Cikilari, bara uliru ligbulang fe. ");
INSERT INTO amo_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Bara iyizi nighe nyene utucu fe, ");
INSERT INTO amo_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Ulenge na uwa keele nanya nyenju nanit vat. ");
INSERT INTO amo_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ame ba so nkanan bara upunu kidegen kiti nalumai, aba so ngongon nanit mye Isiraila.” ");
INSERT INTO amo_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ucif nin nnah nngone kiffo tinu kitene nile imon na idin kitin gone. ");
INSERT INTO amo_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeon ta nani nmari, abelle Maryamu ku unene, “Lanzai gegeme gono kane ba so libau ndiu nin nfitu nanit gbardang nan Isiraila nin nalama alenge na idin bellu kitene mye. ");
INSERT INTO amo_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Tutun Kusangali ba wariu kidowo fe, bara ukpilizu nibinai gbardang bba nuzu fong.” ");
INSERT INTO amo_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Umong uwani unan nliru nin nnu Kutelle, lisa mye Anna ame wang wa duku, ame ushonon Fanuwel unuzu likuran Ashar, awa dinin mye nin nlesi akus kuzor cas, ");
INSERT INTO amo_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","a so nanya likulok uduru akus akut kulir nin na nas. Na a suna u picu kutiin nlira ba kitik nin liring, a suzu ukotu nayi nin lira. ");
INSERT INTO amo_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Nkoni kube ada kiti mine a cizina ugodiya kiti Kutelle, asu uliru kitene ngone kiti nko gha, alenge na idin ncaa ntucu Urushelima. ");
INSERT INTO amo_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Kubi na imala vat nile imon na iwa dinin su nsuwe bara uduka Ncikilari, ikpilla udu Ugalili, udu kagbir mine Unanzaret. ");
INSERT INTO amo_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Kinin gone kunno ata likara, njinjin kpina ku nsheu Kutelle so liti mye. ");
INSERT INTO amo_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ucife nin nnere asa ido Urushelima ko lome likus bara ubukin (keterewa). ");
INSERT INTO amo_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Kubi na awa duru akus likure inung tutun nya kubi nalada a kubi nbuki. ");
INSERT INTO amo_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Na iso, ayiri nbuke vat malla, izina ukpilizinu kilari, ame gone Yesu lawa kidung, nanyan Urushelima, na inung Ucife nin nnene wa yiru ba. ");
INSERT INTO amo_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Inung dinsu nworu adi nanya ligo nanit, na iwa di nanghinu, isu ucin liri lirum, inin cizina upiziru ghe nanya likura nan nadondon. ");
INSERT INTO amo_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Na iseghe ba, inung kpilla udu Urushelimma, itunna npiziru ghe kikane. ");
INSERT INTO amo_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Iduru ayiri ataat iseghe nanya kutyi nliran, asosin kiyitik na nan nyiru, inlanzu nani nin ntinu nani. ");
INSERT INTO amo_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Vat nalenge na iwa lanza ghe iwa kiffo tinu, bbara uyiru nin nkawu mye. ");
INSERT INTO amo_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Kubi na iyene ghe ikiffo tinu unna mye woro, “Gono, iyaghari nta usu nari nani? Lanza Cife nin mye tidin piziru fi kkang.” ");
INSERT INTO amo_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","A woro nani, “Iyaghari nta idin pizirie? na anug yiru ba uso yi gbasari nso kilari Kutelle?” ");
INSERT INTO amo_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Bara na inung nyinno ile imon na tigbulang mye din bellu ba. ");
INSERT INTO amo_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","A kpilla kilare nanghinu udu Unazareet adorto uliru mine, unna mye cio vat nimon ine nanya kibinai mye. ");
INSERT INTO amo_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu leo ubun nkunju nin njinjin a njangaram, ase uyinnu Kutelle nan nanit. ");
INSERT INTO amo_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Nanya likus likure nin natowun kube na ugo Tiberius Kaisar, ame Bilatus Ba-bunti wa di ugomna Nyahudiya, Hiridus wadi unan bunu gwamnna in Galili, gwana me Filibus wadi unan bunu kipin ituriya nin Tarakunitis, Lisaniyas wadi unan bunu gwamna Abiliya, ");
INSERT INTO amo_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","nin kubi na Annas wadi kumalami kudya nin Kayafas, uliru Kutelle da kitin Yohanna, usaun Zakariya, nanya kusho. ");
INSERT INTO amo_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","A wa cinu akeu nigberi naa na ni wadi ngau kurawa urdun, a wadin wazin shintinu nmyen nin foo na acara udu uwesu kulapi. ");
INSERT INTO amo_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nafo na inna yertin nanya kufa ligbulang Ishaya unan liru nin nuu Kutelle, “Li wai nmong din yicu nanya kusho, 'Kelen libau Kutelle, kelen tikoot mene ti so dert. ");
INSERT INTO amo_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Vat awu ima kulu anin, vat atala nin naparan ima toltinu ana nin vat, tibau ti ginlang ima nakpu tinin, tibau ti nanzan ima kelu tinin lau. ");
INSERT INTO amo_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Vat anit ma yenu utucu Kutelle.'” ");
INSERT INTO amo_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yohanna woro ligozin na nite ale na iwa ccinu uda kiti me ada shintu nani nanya mmyen, “Anung kuewunu fiyii timung, nghani na kpada minu icun kiti finana nayi to na tidin cinu? ");
INSERT INTO amo_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Nutunon nono nanga na nibatina ufubu, na iwa cizin ugbondilu nanya mine ba, “Tidin Ibrahim ucif bite,' bara na ina belen munu au Kutelle wa sa a nutuno Ibrahim ku nono tutung unuzu natala alele. ");
INSERT INTO amo_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Nene imalu tii kidowo tilin kuce bara nani vat kuca ko na kunutuno kumat kucine ba wase ikowo kunin i ta ulaku.” ");
INSERT INTO amo_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Amon nanya ligozie teringhe imoro, “Iyanghari ti ma nin ti.” ");
INSERT INTO amo_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","A kawa a woro nnani, “Umong wa di nin nalutuk aba, ana ule na a salimung, ule na asi nin nimonli a su nani.” ");
INSERT INTO amo_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Among anan sessun gandu da ida shintin nani nmyen, i woroghe, “'Unan yiru, inghanghri ti ma ti?” ");
INSERT INTO amo_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","A woro nani, “Na ima seru ikurfung ikata ile imong na ina beling minu. ");
INSERT INTO amo_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Among a soja da tiringhe, i woro, “Arike fa? Tiba tizighari?” Aworo nani, “Na iwa seru ikurfun kifin mmong nin likara ba. Na iwa vura umong ba teren kibinai nin imung na idin bizu minu.” ");
INSERT INTO amo_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nene na anite wa din ncaa ndak Yesu, kogha wadin kpilzule sa Yohanna re Kristi. ");
INSERT INTO amo_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Yohanna kawa a woro nani vat, “Bara meng idin shintu munu nanya myen, umong din cinu ulenge na akafini nin likara, na meng bafin inbunku tii nakpatak mye ba, ama shintu munu nanya Ruhu Ulau nin laa. ");
INSERT INTO amo_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kupark mye di nanya nacara mye na ama kyeliu uaalkama a gutun insoronghe ayiru iyole atii filai ama juju insoronghe nin la ule na iwa se ibico ba.” ");
INSERT INTO amo_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Nin mong ugbaru udia tutung, abele anite ulilrun nlai. ");
INSERT INTO amo_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Yohanna kpada Hiridus ku kitin yerun nwaii mbene mye Hirudiya, nin vat nadu ananzang Hiridus na ana su. ");
INSERT INTO amo_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Bara nan Hiridus kuru a ti nlong lidu tinanzang a mati i tursu Yohanna ilu nanya kilari lican. ");
INSERT INTO amo_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Nene kubi da, na Yohanna wa shintu anit vat nanya nmyen, a shintino Yesu ku wang na awa din nlira kitene kani puno. ");
INSERT INTO amo_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Uruhu Kutelle tulu kitene mye nafo kuwulung, liwui nuzu kitene kani, “Fere gono nayi ning udin puzi ayi.” ");
INSERT INTO amo_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu liti mye, kube na awa cizin udursuzue awa di nin nallus akut atat. Awa di usaun Yusufu, usaun Heli, ");
INSERT INTO amo_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","usaun Mathat, usaun Nlawi, usaun Melchi, usaun Jannai, usaun Yusufu, ");
INSERT INTO amo_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","usaun Matatiyas, usaun Amos, usaun Nnahum, usaun Hasli, usaun Nayjaya, ");
INSERT INTO amo_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","usaun Maatha, usaun Mattathiya, usaun Shimi, usaun Yuseka, nin saun Joda, ");
INSERT INTO amo_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","usaun Yohanna, usaun Risa, usaun Zurbabila, usaun Shaaltiya, usaun Niri, ");
INSERT INTO amo_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","usaun Malki, usaun Addi, usaun Kusana, usaun Almodama, Usaun Iri, ");
INSERT INTO amo_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","usaun Yosi, usaun Aliazara, usaun Yorina, usaun Mattahata, usaun Lami, ");
INSERT INTO amo_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","usaun Simion, usaun Yahuda, usaun Yusufu, usaun Yonana, usaun Aliyakima, ");
INSERT INTO amo_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","usaun Malaya, usaun Mainana, usaun Mattahata, usaun Nattana, Usaun Dawuda, ");
INSERT INTO amo_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Usaun Yassa, usaun Obida, usaun Buaza, Usaun Salmona, usaun Nahashuma, ");
INSERT INTO amo_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","usaun Aminasaba, usaun Arana, usaun Hasruna, usaun Harisa, usaun Peres, usaun Yahuda, ");
INSERT INTO amo_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Usaun Yakubu, Usaun Ishaku, Usaun Ibrahim, usaun Taraha, Usaun Nahura ");
INSERT INTO amo_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","usaun SAruja, usaun Rauwa, usaun Palaju, usaun Aberu, usaun Shalahu, ");
INSERT INTO amo_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Usaun kinana, usaun Arfakshada, usaun Samana, usaun Nuhu, usaun Lamaka, ");
INSERT INTO amo_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","usaun Matushalaha, usaun Anuhu, usaun Jarada, usaun Mahalailu, usaun Kanana, ");
INSERT INTO amo_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Usaun Anosha, usaun Shittu, usaun Adamu, Gono Kutelle. ");
INSERT INTO amo_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Nani Yesu, na iwa kullo ghe nin Uruhu Ulau, akpilla unuzu kurawan Yahudiya, Uruhu nya ninghe udu nanya kusho ");
INSERT INTO amo_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","nanya nayiri akut anas shetan. Wa di dumunghe kikane, nanya na leli ayire, na awa lii imon ba, udu nimalin nkoni kubi alanza kukpon. ");
INSERT INTO amo_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Shetan ghe woroghe, “Andi fe gono Kutelle ari taah atala ale aso uborodi.” ");
INSERT INTO amo_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu kauwa ghe ina nyertin, “Na unit ba so ninlai bara uborodi cas ba.” ");
INSERT INTO amo_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Nin nani shetan dofino nunghe udu kiti kizalan, adi durso ghe vat kipin tigo nanya inye na nin kubi ba. ");
INSERT INTO amo_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Shetan ghe woro ghe, “Meng ba nifi likara asu tigo nanya kipin tigone nin ngongon vat, meng wan su nsu nani bara ina nii nsu tigowe kitene, tutun nwansa nnah ko ghaku ulenge na ndinin nsuwe. ");
INSERT INTO amo_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Bara nani asa uba tumunu nbun nighe unii ngongon, vat nilele ba so infe.” ");
INSERT INTO amo_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Bara nani Yesu kauwa a wono ghe, “Udi nanya ninyerte uba tumuzunu Cikilari Kutelle fe amere cas uba nighe ngongon.” ");
INSERT INTO amo_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Udu nbune shetan dofino nin Yesu udu Urushelima adi cio ghe kiiti kizalang kuttyi nliran a woro ghe, “Andi fe gono Kutelle ari nyinna kikane. ");
INSERT INTO amo_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Bara inyerte na bellin abati nono kadura mye iminfi, ikese fi. ");
INSERT INTO amo_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Inung ba ghantinfi nin nacara mine, bara uwa tiro kitene litala.” ");
INSERT INTO amo_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yesu kauwa a woroghe. “Ina bellin na uwa dumun Cikilari Kutelle fe ba. ");
INSERT INTO amo_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Kubi na shetan nmala udumuzunu Yesu ku, a nya a sunghe udu nkon kubi. ");
INSERT INTO amo_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nani Yesu kpilla udu Ugalili nin likara Uruhu, uliru kitene mye malla kiti vat nkilinu ligan nmyino. ");
INSERT INTO amo_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","A dursuzo nani nanya kutyi nliran ko gha wa sughe liru. ");
INSERT INTO amo_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nlon liri adah Unazaret, kagbir kanga na ana kunjoku, nafo ile imon na amene nsuzuwe, a pira kutyi nliran liri nasabar, a fita ayisa a karanta inyerte. ");
INSERT INTO amo_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Kufah nnan nliru nin nuu |Kutelle Ishaya ri iwa nighe a puno kufe, asa kiti kaa na inyerte ule duku, ");
INSERT INTO amo_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Uruhu Kutelle di nin mye, Bara unashipai nbellu uliru ucine kiti nakimon. Ana tuuyi nbellin ibunku alenge na idi licin, nin npunu niyisi nale na idi aduu, ");
INSERT INTO amo_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Nin nbellu likus nse nyinnu Ncikilari.” ");
INSERT INTO amo_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Na atursu kuffe, akpilla mun ana unan kutuwa kutyi nlirane, atina aso, iyizi na nite vat nanya kutyi nliran kpilla kitimye. ");
INSERT INTO amo_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","A cizina uliru nanghinu, “Kitimone nkullo nanya nlanzu mine.” ");
INSERT INTO amo_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ko gha wanso iyizi inba nanya nimon vat na awa bellin nanuu itunna ikiffo tinu, bara tigbulang timang na ti di nnucu nnu mye. I wa din du “Kaane gonon Yusufu ari, sa na nani ba?” ");
INSERT INTO amo_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Yesu woro nani, “Kiden nari iba belle to tinan kugoldo, kabere shinno nin litife, vat nile imon na tina lanza au una su Ukafarnahum su inin kikane kagbirfe.” ");
INSERT INTO amo_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ame tutun woro, “Kidegenari ndi nbellu munu, na iwasa iyina nin nan nliru nin nnu Kutelle kipin mye ba. ");
INSERT INTO amo_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Kidegen meng di nbellu munu, awani alenge na ales mine wa kuzu wa diku gbardang kubon Iiya, kubi na kitene kani wa tursu, sa uwuru udu akus atat nin tipwui kutocin kubi na kukpon wandi vat kipine. ");
INSERT INTO amo_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Bara nani na iwa tuu Iliya ku kiti nmong nanya mine ba, bara cas udu kiti nmong uwani na ules mye na kuu, kupo kipin Sidon. ");
INSERT INTO amo_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Tutun akuturu wa duku gbardang kubin Alisha unan nliru nin nuu Kutelle, bara nani na iwa shinn nin nmong ba se Naaman kunan Suriya.” ");
INSERT INTO amo_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Vat nanite nanya kutyi nliran lanza ileli imone ayi mine nana. ");
INSERT INTO amo_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Inung fita inutunghe nanya kagbire nin likara, inya ninghe udu kitene likup longo na iwa ke kagbir mine ku, bara itununghe udak kutyin. ");
INSERT INTO amo_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ame tunna anya dert kiyitik mine libau mye. ");
INSERT INTO amo_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","A tolo udu Ukafarnahum kagbir nanya ngalili, namon asabar awandi ndursuzu nanit nanya kutyin nliran. ");
INSERT INTO amo_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Inung wa kiffo tinu nin ndursuzu mye, bara awa liru nin likarra. ");
INSERT INTO amo_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nene nanya kutyin nliran umong wa duku ulenge na awa dinin Nruhu nagbergenu, asu kuculu komg, ");
INSERT INTO amo_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","Iyaghari arike basu ninfi Yesu kunan Nazarat? Udah kikane uda molu nari? Meng yiru sa fe ghari, fere Ulau un Kutelle!” ");
INSERT INTO amo_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Yesu kpada agbergenu a woro, “Taan tik inuzu nanya mine!” Kubi na agbergenu liinghe kutyen kiyitik mine, anuzu nanya mye sa uworu ataghe ukul. ");
INSERT INTO amo_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Vat nanite kiffo tinu, itunna nliru nanya nati mine, i woro, “Imusin ntime tigbulan ghari tine? A kpada agbergenu ananzang nin likara inanai inuzu wa?” ");
INSERT INTO amo_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Uliru we kitene mye tunna umala kiti nanyan nkilinu kipine. ");
INSERT INTO amo_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Na Yesu nsuna kutyin nlira, apira kilari Simon, nene unan nwani simo ne awadi nniu nin nkonu, inung foghe acara nmemuku mye. ");
INSERT INTO amo_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Bara nani a fita ayisina kitime akpada ukone, atinna ashino, deddei atina a fita acizina asu nani katuwa. ");
INSERT INTO amo_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kubi ndiu nwui, anite da nin na nan tikonu gbardang kitin Yesu, Ame tarda nani acara itino itinna ishino. ");
INSERT INTO amo_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Agbergenu nuzu kiti nani gbardang, nin kuculu i woro, “Fe gono Kutelle Yesu kpada agbergenu a wantina nani uliru. Bara iwa yinin au ame Kristi ari. ");
INSERT INTO amo_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Nin nshantu kiti ada, anya udu kiti kah na unit duku ba, ligozi nanit wadi npiziru ghe ida kiti kah na aduku, isu inda na iba wantinghe asun nani. ");
INSERT INTO amo_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Baara nani, aworo nani, “Usoyi gbasari tutun nbellin ulinu ucine kitene kipin tigo Kutelle nanya nigbir gbardang, bara nanere iwa tuuyi kikane.” ");
INSERT INTO amo_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Nin nani atina aleo ubun nbellu nliru nlai nanya natyi nlira, nin vatt ligan Yahudiya. ");
INSERT INTO amo_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nene icizina, ligozi nanit wa kilinghe idin lanzu nliru Kutelle, ame wa yisin ngau kurawa. ");
INSERT INTO amo_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ayene tizirgin nmyin tiba yisin ngau kurawa. Anan nduwane wandi imal nuzu nanya tizirge, idin kussu tikuma. ");
INSERT INTO amo_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu wa piru nanya njirgin Simon a woroghe a cancanah udu ubune, a so nanya nzirge anin durssozo annite. ");
INSERT INTO amo_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Na amala udursuzu nanite, a woro Simon ku, “Ayiru uzirge a domun kiti chonchome bara nduwaned.” ");
INSERT INTO amo_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Bitrus kpana a woro, “Cikilari, timorin katuwa, nati kifo imon ba, bara ligbulan fe, mba tuu tikume ku.” ");
INSERT INTO amo_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Na ita nani ikifo iboo gbardang, tukume putuzo. ");
INSERT INTO amo_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Iyicila adon mine nin nacara na idi nton tizirgi ida bun nani, idah ida kullo tizirge icizina wulu nanya nmyen. ");
INSERT INTO amo_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Na Bitrus nyene nani adio nabunu Yesu anin din sughe, “Cacanah kupo nighe, bara na meng unan kulapari, Cikilari.” ");
INSERT INTO amo_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Imone wa tighe Zikiki, ligowe nan nale na awadi nanghinu nin kifu nibowe ulenge na iwa yiru. ");
INSERT INTO amo_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ulele wa munun Yakubu nin Yohanna asaun Zabadi, alenge na iwadi ligowe nin Bitrus. Yesu woro Simon, “Ku na uwa lanza fiu ba, bara nenen udu ubun uba kifizu annit.” ");
INSERT INTO amo_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kubi ko na inutuno tizirgi mine ndas, isuna imone vat idofin ghe. ");
INSERT INTO amo_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Uwadi nani kubi, na awadi nanya nkan kupin nigbire, umong unit wa duku nin tikuturu. Na ayene Yesu ku, adio nbun mye adin nfoghe nacara aworo, “Cikilari assa uyinna uwasa ushino nin mye.” ");
INSERT INTO amo_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu nakpa ucara mye adudo ghe, a woroghe, “Meng nyinna. Shino.” Kitene tikuture tina tishino. ");
INSERT INTO amo_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","A kpada ghe yenju awa bwllin umon, a woroghe, “Caanfi, udurso litife kiti npirist, caan udi ni uhadaya nwesu fe bara ubellun Musa, bara ushaida kiti mine.” ");
INSERT INTO amo_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Uliru litime mala kiti piit, Ligozi nanit gbardang dah kitime nwonu ilanza ghe, ndursuzu nani nan nshizinu nin tikonu mine. ");
INSERT INTO amo_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Bara nani asuna nani apira nanya kusho usame, bara anan tah nliran. ");
INSERT INTO amo_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Iwa duku nlon liri na awadi ndursuzu nanit, a Farisiyawa na nan wucu kidegen wa duku, alle na iwa nucu niti ngangan nanya nmyin Ngalili a Uyahudiya nin kakpiri Urushalima. Agang Kutelle wadi litime nworo a shhizin nin nanit. ");
INSERT INTO amo_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nene amon annit da, nin nmong unan nkonu npenu nfunu, ipizira libau longo na iba dak ninghe kitin Yesu. ");
INSERT INTO amo_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Na iwa se libau nworu Idamun ninghe ubun mye ba, bara ukullu kiti, ighana kitene fitulleri kutyie itoltunnghe kiyitik nanit nbun Yesu. ");
INSERT INTO amo_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Na awa yene uyinnu mine sa uyenu a woro, “Ikusu alapi fe.” ");
INSERT INTO amo_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Anan ninyerte nan na Farisawa icizina utiru iworo, “Ghari ule na adin tizogo? ghari nwasa awesu kulapi, nbanin Kutelle?” ");
INSERT INTO amo_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu wa yinin ukpilizu nibinai mine, a kauwa a woro nani, “Iyaghari ntah idi kpilizuwe nanya nibinai mine? ");
INSERT INTO amo_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Uyemeri dinin dedei nbellu, 'Iwese alapi fe sa fita ucinu?” ");
INSERT INTO amo_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Bara inan yinno gonon nnit dinin likara nanya inyulele akusu kulapi, nworo fi, 'Fita uyiru kuppe, fe unya udu kilari.'” ");
INSERT INTO amo_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Na nin mollu kubi ba nbun mine a fita a yauna kuppe mye na wa nnonku akpilla kilari mye adin nzazinu Kutelle. ");
INSERT INTO amo_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ko gha imone wa tighe zikiki izazina lisa Kutelle, fiu da nani iworo, “Tiyene imon ipese kitimone.” ");
INSERT INTO amo_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Na ile imone nkatah, Yesu nuzu kikane adi yene umon unan sesun ngandu lissa mye lawi, asosin kudanga nsesun ngandu mye, a woroghe, “Dofini.” ");
INSERT INTO amo_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Lawi suna vat imon ile na awa dumun adofinghe. ");
INSERT INTO amo_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lawi yicila ubuki udiya kilari mye bara Yesu, anan sesun ngandu gbardang wa dak ku, among annit wa sosin nanghe idin leo ligowe kutebule. ");
INSERT INTO amo_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Afarisiyawa nin nan ninyerte wadi ngondilu nbun nan nan kadura mye, iworo, “Iyaghari ntah idin lii nin nso na nan sesun ngandu ligowe na nan kulapi?” ");
INSERT INTO amo_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu kauwa nani, annit alenge na idi acine, na idinin su nnan nizu nkan ba, anan tikonuari cas dinin su nnan nkan. ");
INSERT INTO amo_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Na ina dakk nyicila annit alau ba, ayicila anan kulapi ituba.” ");
INSERT INTO amo_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Inug bellinghe, “Nono kadura Yohanna asa itere tinu nin nliran, nono kadura na Farisiyawa asa isu nani inung nono kadura fe din nlii isono.” ");
INSERT INTO amo_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu woro nani, “Umon wasa aterunu kwanya tiyime yita nanghinu?” ");
INSERT INTO amo_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Bara ayiri ba dak na iba da yiru kwanya tiyome, nanya naleli ayirere iba teru tinu.” ");
INSERT INTO amo_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu tutunn lira nanghinu nin tinan tigoldo, na umon wasa ayira kupari kupese avah kukuse mun ba, asa asu nani, aba jariu kuzeni kupese, kuzeni kupese wasa ado dert nin kukuse ba. ");
INSERT INTO amo_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Tutun na umon wasa ayira nmyen narua ata lisu likuse ba asa asu nani, nmyen narau mipese ba tutu nin lisuwe, nmyen narauwe mala kiti, linin lisuwe putto. ");
INSERT INTO amo_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Bara nmyen narau mipese, ibati minin nanya lisu lipese lilau. ");
INSERT INTO amo_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Na umon, asa asono nmyen narau mikuse, adin piziru mipese, bara aba woru, 'Mikuse katin.'” ");
INSERT INTO amo_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Na iwa di lirin Nassabath na Yesu wadin cin nanya kunen ni leu acurmye wadin nkulu nati ni leu, ipara na cara mene ituna nlee. ");
INSERT INTO amo_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Amon nanya na Farisiyawa woro, “Inyari ita idin nsu nilemong le na i caun isu liri na Sabbth ba?” ");
INSERT INTO amo_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Yesu kauwa nani a woro, “Na anung na karanta imung ile na Dauda wasu kube na wa lazan kukpong, ligowe nan nanit na iwa di nanghe? ");
INSERT INTO amo_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Awa piru kilari Kutelle, ayira uburodi ule na iwa ceu a leu umon nanya ukuru ama alenge na imadi ligo we nan ghe un na priestari cas ile.” ");
INSERT INTO amo_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Anin woro nani, “Gono nit Ucifari un na Sabath.” ");
INSERT INTO amo_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Uda among Asabar na awa piru nanya kutii nlira adin dursuzu anite kikane umong unit wa diku nin ku girin cara. ");
INSERT INTO amo_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Anan niyert nang na Farisiyawa wadin yenju susut sa a ba shinu nin mung unan konu lirin na Sabath, inan se imong ile na inna Vuruzughe mung. ");
INSERT INTO amo_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Bara nani ayino ile imung na idin kpilizue nibinai myene a woron nle na ucara di kuger, “Fita, uyisin kitill nanite.” Unite fita a yisina kitene. ");
INSERT INTO amo_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Yesu woro nani, natirin minu, ucaun isu imong icine liri na Sabatha sa isu inanzang i tucu ulai ya sa inanza unin?” ");
INSERT INTO amo_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","A yenje nani vat anin woro anite, “Nakpa ucara fe.” Ata nani ucara mye kpilaku. ");
INSERT INTO amo_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Bara nani ayi mine nana ilira nanya natimine, kitene nile imon na ibasu Yesu ku. ");
INSERT INTO amo_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Uso nani, nanya nayiri ane a ghana kitene liikup asu nliran, a leo ubun nin kiitike vat nlira kiti Kutelle. ");
INSERT INTO amo_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kubi na kiti nshanta, ayicila nono katuwa mye, a fere annit likure alenge tutung na iwa ni nani lissa “anan kadura.” ");
INSERT INTO amo_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Tisa nanan kadura mye inughe Simon (ulenge na iwa nighe lisa Bitrus) nin gwana mye Andrawus, Yakubu, Yohanna, Filibus, Bartamalawus, ");
INSERT INTO amo_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matta, Tomas, Yakubu usaun Alfa, Simon, ulenge na idin yicughe Zaloti, ");
INSERT INTO amo_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yahuda usaun Yakubu, nin Yahuda Iskariyoti ulenge na aba lewughe. ");
INSERT INTO amo_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Kube Yesu tolo kitene likupe nan ghinu ida yisina kiti kitendelen, ligozi na nan katuwa mye gbardang wa duku, nin ligozi nani gbardang na inuzu Nyahudiya nin Urushelima, nin nbui kurawa Sidoniya a Utaya. ");
INSERT INTO amo_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Iwa daka ida lanza ghe, ukuru ise ushinu nin tikonu mine, anit alenge na iwadi nniu nin nruhu unanzang iwa shinn. ");
INSERT INTO amo_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ko gha nanya ligoze wa dinin su a dudo ghe bara likara nshishinu vat. ");
INSERT INTO amo_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ame yene anan katuwa mye a woro, “Anung anan nmariari ulenge na idi akimon, bara anughere anan kipin tigo Kutelle. ");
INSERT INTO amo_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Anan nmariari unughe na idi lanzu kukpon nene, bara anug ba shittu, anan nmariari anughe na idi kuculu, bara iba su tisina. ");
INSERT INTO amo_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Anan nmariari anughe asa anit nnari munu, kubi na ikoso ligo nan ghinu, isu munu nshina, inani nanza munu lisa nworo anug umuguari, bara upiziru lisa ngono nnit. ");
INSERT INTO amo_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Suun liburi libo liyiri lole, inyizin bara ulanzu nmang, bara fe base uduk udia nanya kitene kani bara acif mine nanere iwa su anan kadura Kutelle. ");
INSERT INTO amo_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Kash anung anang nimon nacara, barra imal seru uduk mine. ");
INSERT INTO amo_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Kash anung alenge na ishitin nene, bara kukpon ba da munu nin ndu nbun, kash anung na idi tisina. nene, iba su tiyom nin kuculu nin ndu nbun. ");
INSERT INTO amo_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Kash anung alenge na anit di nliru gegeme kitene mine, bara acif wa su anan nliru kinu nin nnu Kutelle nanere. ");
INSERT INTO amo_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Bara nani meng di belle munu na idin lanzu, taan usu na nan nivira nanghinu, isu imon icine kiti nalenge na inari munu. ");
INSERT INTO amo_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Taan aleenge na itamunu unnu nmari, suun alenge na idin tumunu ineo nliran. ");
INSERT INTO amo_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ame ulenge na areoufi kuwwau kpiliya ghe kunbe, asa umon bollo ugudum fe munu ghe kulutuk fe ku tutun. ");
INSERT INTO amo_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Na vat nlenge na atirin fi, asa umon nbollo imomon na idi infe, na uwa tiringhe anifi ba. ");
INSERT INTO amo_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ile imon na fe idinin su anit sufi fe wang su nani. ");
INSERT INTO amo_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Asa fe din su usu nalenge na idinin su fere cas, iyaghari uduk fe? Vat inung anan kulapi dinin nsu nalenge na idinin su mine. ");
INSERT INTO amo_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Asa udin suu imon icine kiti nale na idin su fi imon icine, iyaghari uduk fe? Nanere wang anan kulapi din su we. ");
INSERT INTO amo_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Asa udin yenju iba biufi, iyaghari uduk fe? Inung anan kulapi din nizu ure kiti nalenge na idin yenju iba kpillu ini nani tutun. ");
INSERT INTO amo_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Taa usu nnan nivira nin fi, usu ghe gegeme. Niza nani ure na iwa ceo kibinai nworu uba seru ba, uuduk fe ba yitu gbardang, uba so gono nnan kitene kani. Bara ame liti mye din su gegeme kiti nale na idinsu ugodiya ba. ");
INSERT INTO amo_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Lanza nkune kune, nafo Ucif fe na adin lanzu nkunekune. ");
INSERT INTO amo_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Na uwa ti umon aso unan kulapi ba, bara fe wang iwa su fi nani. Na uwa mollu umon ba. Fewang na iba mollu fi ba, shawa nin kulapi namong, fewang iba shawu nin kunfe. ");
INSERT INTO amo_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Niza anit fewang iba niiti, uni udia na iba zinlinu ukuru ituku bara kuyanga kongo na uguro uman mun, kunere iba guni fe ku mun.” ");
INSERT INTO amo_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Akuru a belle nani tinan tigoldo. “Unan uduu waansa adursu umon unit uduu libauwa? Asa asu nani vat mine ba diu nanya kuwu, su nani ba? ");
INSERT INTO amo_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Unan nmasu nyinnu nimon wasa akata unan dursuzu mye ba, bara kogha kubi ko na amala umase, aba so nafo unan dursuzu mye. ");
INSERT INTO amo_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ani iyaghari nta udin yenju limoo nanya niyizin gwana fine, na idin yenju kukunti na ku di niyizifi ba? ");
INSERT INTO amo_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Iyizirari uba bellu gwana fine, 'Gwana nan nkala limoo longo na lidi nanya niyizi,' fe litife na uyene kukunti na ku di nanya niyizife? Fe unan rusuzu liti! Burno ukala kukunti nanya niyisife, nin nani unin yene gegeme limoo longo na lidi niyizin gwana fine. ");
INSERT INTO amo_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Bara na kon kutca kucine wansa anaa kumat kunanzang ba, sa kutca kunanzan nii kumat kucine ba. ");
INSERT INTO amo_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Bara ko kuyemu kutca idin kunin bara kumat mere. Bara na anit wasa ikala kupu kidowo fimart ba, nanere iwasa ikala inabi nanya fimart kusho. ");
INSERT INTO amo_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Unit ucine nanya nile imon na adin cisu kibinai mye, asa abelle imon ile na idi icine, unan magunta nutuno imon inanzang ile na idi kibinai mye nin nnu mye. ");
INSERT INTO amo_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Iyaghari nta idin yicie, 'Cikilari, Cikilari,' nin nani na idin dortu imon ile na nbellen munu ba? ");
INSERT INTO amo_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Vat ulenge na ada kiti nighe, a lanza tigbulang adofino tinin a di nafo. ");
INSERT INTO amo_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Adi nafo unit ule na akee kilari amini nwuzu kiteen anin tuno kutyi ata atata ku. Kubi na uwuru nda kang nmyen nda kilari kane wasa kizillino ba, bara kidinin litino licine. ");
INSERT INTO amo_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Bara nani, ulenge na a lanza tigbulang ninghe na adofino tinin ba, aba so nafo unite ulenge na kidiin sa litino licine, aswu uwuru ntolo, nmyen ndofino kilari kane, deddei ki diu, na udiu wa ba caunuu ba.” ");
INSERT INTO amo_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Kubi na Yesu nmala ubellu nimon natuf nanite, a pira Ukafarnahum. ");
INSERT INTO amo_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Kucin nmong unit udia, na awadi nin nkanu acina ukuu, Cikilari wa di nin su mye. ");
INSERT INTO amo_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Bara na alanza ubellen Yesu, unit udia une to akukune na Yahudawa idi yicila ghe adak ada tucu kucin kone bara awa kuu. ");
INSERT INTO amo_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Kubi na ida kupoo Yesu inung tiringhe iworo, “Ucaun isughe nani, ");
INSERT INTO amo_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Bara adinin su nanit bite, amere na ke nari kutyin nliran kone.” ");
INSERT INTO amo_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Bara nani Yesu leo ubun nanghinu kubi na awadii piit nin kilare unit udia une to adondon mye iworoghe, “Cikilara na uwa ti litife kudira ba, na meng batin uda piru nanya kilari nig ba. ");
INSERT INTO amo_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Bara nanere na nyene liti nighe nbatin ndak kitife ba, belle ligbulang kucin nighe ba shinu. ");
INSERT INTO amo_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Bara meng wang unitari na idinin tigo, ndinin nasojja, asa nworo ulle, 'Cang,' asa anya andi nworo umong, 'Da,' asa ada, ame kucin nighe su nenge asa asu.” ");
INSERT INTO amo_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Kubi na Yesu nlanza nani akiffo unu, a gitirino kiti ligozi na idin dortu ghe, “Meng bellin munu, vat nanyan Israila na nse umon nin nimusin nle uyinu sa uyenu ba.” ");
INSERT INTO amo_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Inung alenge na to nani, kpilla udu kilari idi se kucine nshino. ");
INSERT INTO amo_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nin nkon kubi, uso na Yesu wadi ncinu udu kipin na idin yicu unayin, adon katwa mye wadin ncinu nanghe, ligowe nin ligozi nanit gbardang. ");
INSERT INTO amo_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Na ada kupo kipine kidia we, iwa min umong unit na akuu, amere gone cas kitin nene, ame wand ules mye na kuu, ligozi gbardang nanya kipine wa di nanghe. ");
INSERT INTO amo_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Na ayeneghe, Cikilari lanza nkunekune mye kang, “Na uwa sillu ba.” ");
INSERT INTO amo_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","A da ubun mine adudo akwatu libe, itunna iyisina a woro, “Kwanya, nbellin fe, fita.” ");
INSERT INTO amo_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Atina a fita a so acizina uliru, Yesu yiraghe ana unene. ");
INSERT INTO amo_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Feu tina fi da nani vat. Itina nzazinu Kutelle iworo, “Unan nliru nin nnu Kutelle udia nnuzu nanya bite” nin “Kutelle din yenju anit mye.” ");
INSERT INTO amo_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Uleli uliru kitene Yesu malla kiti nanya vat Yahudiya nin nigbir kupowe. ");
INSERT INTO amo_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Adon katuwa Yohanna bellinghe vat nile imone. ");
INSERT INTO amo_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Yohanna yicila adon katuwa mye an waba, a ti nani udu kiti Cikilari i woro, “Fere unan dak ule, sa umon ghari ule na tiba so nca mye?” ");
INSERT INTO amo_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Kubi na ida kupon Yesu, anite woro, “Yohanna unan shintizinu nanit nmyen nto nari kilifi ti woro fi, 'Fere unan Dak Ule, sa umon duku na tibo soon nca mye?'” ");
INSERT INTO amo_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Nkoni kube anit gbardang wa shinn nin tikonu mine nin nniu na nan nruhu unanzang, ata anit gbardang aduu yenje kiti. ");
INSERT INTO amo_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yesu kauwa a woro nani, “Asa ikpilla, bellen Yohanna ku ile imon na iyene inani lanza. Anit aduu di nyenju kiti, a gurgu din cinu, akuturu din nshizhinu, aturi din lanzu, idin fizu anan kul udu ulai, akimon din lanzu uliru nlai. ");
INSERT INTO amo_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Unit ulenge na asuna uyinnu nin bara imon ile na ndi su ba, ame unan nmariari.” ");
INSERT INTO amo_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Kubi na anan kaduran Yohanna nkpilla, Yesu cizina ubellu ligoze nanite kitene Yohanna, “Iyaghari iwa do nanya kusho ndi yene amon ale na ufunu din pilluwa? ");
INSERT INTO amo_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Bara nani iyaghari iwa nuzu ndi yene, unit unan kuyok kucine? Yene anit alenge na idinsu kuyok kucine inani sosin nanya nlanzun mang, idi kilari tigo wari. ");
INSERT INTO amo_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Bara nani Iyaghari i wa nuzu udas idi yene, una nliru nin nnu Kutelle? Nanere, mong bellin munu, ame katin unan nliru nin nnu Kutelle. ");
INSERT INTO amo_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Amore ulenge na ina nyertin litime, 'Yene meng nto unan kadura nighe nbun fe, ulenge na aba kelu libau kamin fe.' ");
INSERT INTO amo_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Meng nbellin munu nanya nale na awani na macu nani, na umon katin Yohanna ku ba, nin nani tigo Kutelle akatinghe.” ");
INSERT INTO amo_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Kubi na vat nanite nlanza nani, umunu anan sesun ngandu, itambata Kutelle unit ulau wari, iwadi nanya nalenge na iwae ushintinu Yohanna. ");
INSERT INTO amo_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Bara nani, Afarisiyawa nin na nan nyiru nanyan nduka na Yahudawa, alenge na awa shintin nani, iwa nari njinjin Kutelle bara atimine. ");
INSERT INTO amo_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Nin nyanghari mba gwadu anit nko kuje muna? Idi nafo iyaghari? ");
INSERT INTO amo_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Idi nafo nono na idi navu nanya nkassa, alenge na isa iso iyica atimine iwroro, 'Tidin npee nishirau bara anughe, na anug nsu ikarma ba, tisu tiyom ana anung nsu kuculu ba.' ");
INSERT INTO amo_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Bara na Yohanna wa dak na asu kilecu sa usonu ba, anung woro, 'Ame kugbergenu ri.' ");
INSERT INTO amo_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Gono nnit daa adin nlii, aso anug woro, 'Yene, ame unan kileou nin nso udondon na nan sesun ngandu nin nanan kulapi!' ");
INSERT INTO amo_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Bara nani njinjin nsu utucu nvat nnono mye.” ");
INSERT INTO amo_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Nene nkon ku Farisiyawa waddi likura au Yesu lii imonli ninghe. Bara kubi na Yesu npira kilari ku Yahudawe, ikilino kutebul isu kileou. ");
INSERT INTO amo_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Nani umon uwani wa duku nanya kagbire unan kulapi, ayinno nworu Yesu din nli nimon li kilari Kufarisiyawa, ada nin nmon nnut albasta. ");
INSERT INTO amo_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","A da yisina nbun mye, kupo na bunu mye a gilla. Imizine tantizo nabune, atina nweze nin titi liti mye, ngbindirizinu nabunu, nlolizu nanin nin nufe. ");
INSERT INTO amo_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Kube na Afarisiyawe alenge na iyicila Yesu ku, Iyene nani a kpiliza nanya kibinai mye aworo, “Ndah unit ule unan nliru nin nnu Kutelleri, awa yinnu imusi nwani ule na adin duduzughe ame unan kulapiari.” ");
INSERT INTO amo_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Yesu kauwa a woroghe, “Simon, ndinin nimon ile na mba bellinfi.” A woro, “Belle unan yiru!” ");
INSERT INTO amo_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesu woroghe, “Amon wa duku an waba iwa seru ure kiti nnan nizu nre, warum wa sere tidinari akat ataun, ulele tidinari akut ataun. ");
INSERT INTO amo_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Na iwa dinin nikurfin nbiuwe ba, a woro nani na iwa biya ba. Bara uyemeari nanya mine ba katinu nin su mye?” ");
INSERT INTO amo_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon kauwa ghe aworo, “Ndi yenju ulenge na adin dortu ghe ikurfun idia.” Yesu woroghe, “Fe uwusu kidegen dert.” ");
INSERT INTO amo_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Yesu gitirno kiti nwane a woro Simon ku, “uyene uwani ule npira kilari fe, na unayi nmyen nkusu nabunu, ame nin nmizin a kikkai abunu, amini nwese nin titi mye. ");
INSERT INTO amo_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Na fe ngbindiri ba, amere, unuzu kube na ndah nanye, na asuna ugbindiri zinu nabunu nigbe ba. ");
INSERT INTO amo_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Na uwolo abunu nighe nin nuf ba ame nwolo abunu nighe nin nnuf. ");
INSERT INTO amo_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Bara ile imon na asu, nworo fi ame ulenge na adinin nalapi inani nyapa ghe, ata usu gbardang, bara ulenge na iyapa ghe cinglin, ame nta usu cingling.” ");
INSERT INTO amo_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Atuna aworoghe, “Iyapa alapi fe.” ");
INSERT INTO amo_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Alenge na idi kileowe ligowe woro nati mine, “Ghari ule na awasa ayapa kulapi?” ");
INSERT INTO amo_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Nani Yesu woro nwani une, “Uyinnu fe sa uyene nsu utucufe caan sheuwu.” ");
INSERT INTO amo_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Uso na nin dandaunu ba, Yesu cizina ucin nanya nigbir ngangan na nitari, nbellu nliru ucine, kitene kipin tigo Kutelle, inung likure nya nanghe. ");
INSERT INTO amo_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Among awani alenga na iwa kalla nani Uruhu unanzan nan tikonu. Inughere, Maryamu ule na idin yicughe Magdaliya, Kitime iwa kalla ghe agbergenu kuzor. ");
INSERT INTO amo_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yuwana uwanin Kuza, unan katuwa Hirdus, Suzana, nan namon awani gbardang, alenge na iwa buun nani nin nimon nacara mine. ");
INSERT INTO amo_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nene na ligozi nanit gbardang nzura ligowe, umunu anit ale na iwa cinu udak kiti mye unuzu nigbir gbardang, asu uliru nanghinu nin tinan tigoldo. ");
INSERT INTO amo_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Unan tibila ndo nbilisu nimus, na adi tibile imon imusu disso, libau, ipatila inin nin nabunu anyin kitene kani da pilla inin. ");
INSERT INTO amo_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Imon imus disso kiti ikoto, bara na idinin nmyin ba. ");
INSERT INTO amo_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Har nene imon imus disso kiti nimart, na imarte nkuno ligowe nin nimuse, imarte buco imuse. ");
INSERT INTO amo_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Bara nani imon imus disso kutyin kucine inin na iyoli na iwa duru akat kazakure.” Kube na Yesu nbelle nani, ayicila nani, “Vat nlonge na adinin natuf na alanza.” ");
INSERT INTO amo_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Inung nono kadura mye tiringhe iyaghari tinan tigoldo mye di nbellu. ");
INSERT INTO amo_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yesu woro nani, “Ina ni munu kubi iyinin imon linyeshin kitene kipin tigo Kutelle, bara kagisine iba bellu nani nin tinan tigoldo, 'iba yenju na iba yene gegeme ba, iba lanzu, na iba yinnu ba.' ");
INSERT INTO amo_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Nene tinan tigoldo tinere, imuse uliru Kutelle ri. ");
INSERT INTO amo_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Imus ile na idisso libou, innere anit alenge na ilanza ligbulang nliru, shetan uni nda ada bollo ligbulang nliru nanya nibinai bara iwa yinin ise utucu. ");
INSERT INTO amo_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Inin ile na idisso kiti natala anitari alenge na ilanza ligbulang nliruwe, inani sere nin liburi liboo na iyisin nin likara ba, inung sa iyinna bara kubi baat, kubi na igwada nani asa idio. ");
INSERT INTO amo_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Imus ile na idisso kiti nimart inughere anit alenge na ilanza ligbulang nliru, inani nsuna linin inani nda parda nani nin nbellen nikurfung nin nlanzu nmang nlai, na isa ina imus ile na idisso kutyin kucine. ");
INSERT INTO amo_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Inughere anit ale idinin kibinai kilau ninn nan nbellu kidegen, na imala ulanzu nlire, imino unin nin likara, isu kumat nin likara. ");
INSERT INTO amo_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Nene, na umon duku ule na aba ti ulah npitila awufu nin kishik, sa a ceo nanya lii nkoni, se dei atarda unin kutet, vat nlenge na apira ama yenu nkananghe. ");
INSERT INTO amo_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Na imomon nyeshin, ilenge na una sali sa uyinnu ba, a na imomon nyeshin ile na iba yinnu idak nanya nkanang. ");
INSERT INTO amo_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Suun seng nanya nlanzu, vat nlenge na adumun, amere iba kpinghe ku, ame ule na asali mun, iba seru ile na adin kpilizu a adumun.” ");
INSERT INTO amo_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Kubi na unan Yesu nin nuane wa kiti mye, iwase uduru kupo mye ba, bara gbardang nanit. ");
INSERT INTO amo_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ibellin ghe, “Unafe nin nuanafine yisin ndas, idinin su iyene fi.” ");
INSERT INTO amo_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesu kauwa aworo nani, “Una nighe nin nwana nighe, inunghere alenge na idin nwana nighe, inughere alenge na idin lanzu uliru Kutelle idorto unin.” ");
INSERT INTO amo_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nene uso nlon liyiri, Yesu nin nono kadura mye ipira nanya nzirgin nmyen, a woro, “Nati kafin udu uleli uwul kulle.” Itunna ndinna ikafinar. ");
INSERT INTO amo_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Na idinna ukafine, Yesu tina nmoro fiyilili nfunu fita kang nanya kulle, uzirge kullo nin nmyen itunna ipira nanya tikanci. ");
INSERT INTO amo_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Nono katuwa mye di fiyaghe, iworo, “Cikilari, Cikilari, nmyen ba millu nari!” A fita akpada ufune nin mye ne, fiyilili yisina kite so dang. ");
INSERT INTO amo_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Uyinnu mine, sa uyene de atirino nono katuwa mye nanya fiu nin kiti tinu itirino atimine, ghari ule adi kpadizu ufunu nin nmyen, inani din dortu ghe?” ");
INSERT INTO amo_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ikafina udu kipin Ngarisinawa, na ki nleli uwul Ngalili. ");
INSERT INTO amo_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Kubi na Yesu yisina nbiu kurawa, a zuro nin nmong unan nilaza nanya kipine, nin dandaunu na adin nsho. Imon a sosin kilari ba, asosin nissek. ");
INSERT INTO amo_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Na ayene Yesu ku, usu agilla adio nabunu mye, atah ntet kang, “Iyaghari udin piziru kiti nighe Yesu gono Kutelle? Inan kitene, ndin nfofi nacara yenje uwa fuuni ba.” ");
INSERT INTO amo_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Yesu atta uruhu unazan ghe a nuzu nanya nnite, nkon kubi gbardang asa imone yiraghe. Inani sa itaghe inyang naccara nin nabunu, iceoghe unan ncaa, asa atasa inya ghe agbergenu wunnu ghe udi niti ninanzang. ");
INSERT INTO amo_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesu tiringhe, “Lisafe ghari?” A kawoghe, “Libutari,” Bara agbergenu gbardang di nanya mye. ");
INSERT INTO amo_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ifoo Yesu ku acara kang, na awa mollu nani ba. ");
INSERT INTO amo_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ligo naladu wa di kileo kusari, agbbergenu foo Yesu ku acara, asun nani, ipiru nanya naladu, Yesu yinna nani. ");
INSERT INTO amo_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Na agbergenu nnuzu nanya nnite, idi piru nanya naladue, itunna iputu nin ncum idi diu kule ituna iwulu. ");
INSERT INTO amo_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Na anan libiya nalade nyene ile na isu, ido nanya kipine nin ncum, idi bellin kagbire nin nanya kipine. ");
INSERT INTO amo_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Anite nuzu idi kiti Yesu, ise unite ule na agbergenu nnuzu kiti mye, sosin nabunun Yesu, nin nimon kidowa nin kibinai dert, ilanza fiu. ");
INSERT INTO amo_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Alenge na iyene nani ibelle anite inda na agbergenu nnuzu, unite uni nshino. ");
INSERT INTO amo_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Vat nanite kipin Ngarisinawa woro Yesu ku asun nani, bara anite apira uzirgi nmyen a nya. ");
INSERT INTO amo_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Unite ulenge na agbergenu nnuzu kiti mye, foo Yesu ku acara adofinghe. Yesu kpiliya ghe aworo, ");
INSERT INTO amo_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Kpilla kilari, ubellin ile imon na Kutelle nsu fi, unite kpilla abelle nanya kipine vat nile imon na Yesu nsu ghe. ");
INSERT INTO amo_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Na Yesu nkpilla, ligozi nanite ta ghe mahabi, bara vat mine di ncaa mye. ");
INSERT INTO amo_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Umon unit lisa mye Jairus, udia kutyi nlirag ada dio nabunu Yesu nfo ghe nacara adak kilari mye, ");
INSERT INTO amo_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","bara gono kishono mye kirum, unan nakus likure, anon fawal, na Yesu wa cinu uduwe, ligozi keseghe. ");
INSERT INTO amo_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Umong uwani wa duku, ulenge na awadi nanya nmyi, akus likare, na ase unan nshinu ninghe ba. ");
INSERT INTO amo_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ada mamal mye, adodo imon mye likot nanya kube nmyi mye yisina. ");
INSERT INTO amo_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","“Ghari ndudui?” Yesu tirino, vat mine ta amusuku, Bitrus woro, “Cikilari, anite di gbardang ina ni din parduzu fi.” ");
INSERT INTO amo_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yesu woro, “Umong ndudui, yinno likara nnuzu kiti nighe.” ");
INSERT INTO amo_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Uwani nin nyene, na awanya anya likire ba, ada nin ketizu adeo nabunu mye. Nbun nanite vat, abelle ile imon na ita amini ndudoghe, nin inda na atunna ashino. ");
INSERT INTO amo_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Atunna aworo, “Ushono, nigh uyinu sa uyenu fe nshino ninfi. Can sheu.” ");
INSERT INTO amo_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Kube na Yesu wadi nliru, umon da kiti mye unuzu kilarin Jairus udia kutyi nliran, “Ushono fe, nkuu. Yenje uwa damu unan dursuzu ninyerte. ");
INSERT INTO amo_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Nin lanzu nani, Yesu woro, “Jairus ku, yenje uwa lanza fiu, yinna ushono fe ba shinu.” ");
INSERT INTO amo_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Kubi na aduru kilarin Jairus, na ayinna umon pira ninghe ba, se Bitrus nin Yohanna a Yakubu, a ucif nin nnan ngone. ");
INSERT INTO amo_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Vzat ninite yita kuculu nin tiyom, “Cinnon kuculu Yesu woro na akuu wari ba, adi nmorari.” ");
INSERT INTO amo_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Isisaghe, bara inug yiru a kuu, wari. ");
INSERT INTO amo_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Akiffo ghee ncara a woro, “Gono nig fita.” ");
INSERT INTO amo_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ulai mye kpila, nanya mye, kubi atuna afita, Yesu woro nani inighe imomon alii. ");
INSERT INTO amo_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Anit mye kiffo tinu, yesu woro nani na iwa bellin umon imon ile na idi ba. ");
INSERT INTO amo_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ayicila nono katwa mye likure nin wabe, ana nani likara kitene nagbergenu nin shizhinu nin tikonu. ");
INSERT INTO amo_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ato nani, idi bellin uliru kiti kipin tigo mye, nin shizinu nanan tikonu. ");
INSERT INTO amo_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","A woro nani na iwa yiru imon bara ucine ba, sa uca, imon inyi, imonlii, ukurfung, sa alutuk abba. ");
INSERT INTO amo_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Vat kilari ka na ipira soo kinin, udu liyiri lo na iba cinu kipine. ");
INSERT INTO amo_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Inung alle na inari munu, asa iba nuzu nanya kipin, kotinon lidau we nabune mine, liba so ushaida nati mine.” ");
INSERT INTO amo_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Itunna iwatuna, ipira nigbire itina nbellin nliru umang, nin shizinu nanit niti niti. ");
INSERT INTO amo_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Hirdus ugo na alanza ile imon na idinsu, au Yohanna unan shintu nanit infita. ");
INSERT INTO amo_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Kiti namong idin su Iliya nsah, among woro umon unan nburnari, in fita nanya na nan nlai. ");
INSERT INTO amo_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Hiridus woro, “Ina malu ukalu liti Yohanna, ani ghari ndi nlanzu kiti mee nene.” Hiridus do npiziru ayene Yesu ku. ");
INSERT INTO amo_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Alenge na iwa tuu nani issah, ibellinghe vat nile imon na isu, anya nanghinu ligowe nanghe, udu kipin Batsaida. ");
INSERT INTO amo_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Inung ligoze lanza nani Idofinghe, atah nani mahadi, abelle nani ubellen kipin tigo na idinin su inshinue. ");
INSERT INTO amo_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nin ndu kulelen, inung likure nin wabe, woroghee suuna ligoze idoo nigbir nkilinue, idi piziru kiti linanin nin nimonli, bara kikane na tidi ku kushori. ");
INSERT INTO amo_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Aworo nani, “Nan nani imonli ili.” Inug woro, “na tidi nin nimomon na ikatin nfungul utaun nin niboo ibba ba, sse tido tidi seru nani imonli bara ligozi vat. ");
INSERT INTO amo_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Iwadi annit amui alaun. A woro nono kadura mye, “Taan nani iso acuri akut ataun taun. ");
INSERT INTO amo_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Isu nani anite so vat kutyin. ");
INSERT INTO amo_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","A yauna ufungul utaune nin niboo ibe, ato iyiizi kitene atah nmari ku, a pucu agir anaa nono katuwa mye, inin koso nani. ");
INSERT INTO amo_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Inung vat leo ishito, kagisin nbubun nimole nazza, ipitirno ita nakuzun likure nin nabba. ");
INSERT INTO amo_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Idoo nkon kubi adin nti nliran usame, nono katuwa mye nanghe anin tirino nani, “Ligozi din su meng ghari?” ");
INSERT INTO amo_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ikauwa ghe iworo, “Yohanna unan shintu nmyen (Baptisma) amon woro Iliya, amon woro nkon kunan nburnuari in fita.” ");
INSERT INTO amo_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Anin woro nani, “Anung dinsu meng ghari?” Bitrus kauwa aworo kristi unuzu Kutelle.” ");
INSERT INTO amo_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","A wunno nani atuf, Yesu woro nani na iwa bellin umon ba. ");
INSERT INTO amo_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Nworu gono nnit ba niu nin nimon gbardang, iba nari ghe, akune nin uso napirist a anan ninyerte, iba mollughe ayiri atat a ba fitu nin lai. ");
INSERT INTO amo_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","A woro nani vat, “Asa ule na adinin nsu adak kiti nigh, aba nari liti mye, aba diru, ule na anari litime bara meng aba se utucu. ");
INSERT INTO amo_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ulenge na idinin su a tucu liti mye, aba diru, ule na anari litime bara meng aba se utucu. ");
INSERT INTO amo_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Iyaghari ncaute unit se imon inye vat, anin dira ulai mye? ");
INSERT INTO amo_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Vat nle na adi nlanzu ncin nigh nin ligbulang nigh, gono nnit ba lanzu ncin mye nwui une na aba dak nanya ngongon Ncif mye nin nono kadura Kutelle. ");
INSERT INTO amo_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nworo munu kidegenere indi bellu munu, among yisin kikane, na ukul ba dudu nani ba, se idoo kipin tigo Kutelle.” ");
INSERT INTO amo_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Na ayiri kulir nkata na Yesu nbelle nani tigbulang tone, ayira Bitrus, Yohanna, a Yakubu, ighana kitene kupara ati nlirag. ");
INSERT INTO amo_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Na adi nliraghe, umuro mye saka, imon mye tunna ipo pau nwaltu. ");
INSERT INTO amo_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Itunna ise amon naba ida idin nliru nanghe, ashe Musa nin Iliya. ");
INSERT INTO amo_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ale na iwa yenje nani gongon, idin nliru kitene nnyiu mye, ule na iba kullu nanya Urushelima. ");
INSERT INTO amo_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Kubi, Bitrus nan nale na iwa di nanghe nmoro wadi nani kang, na izinto, iyene ngongon mye nin nale iwa yisin nanghe. ");
INSERT INTO amo_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Uso nani, na inya ligowe nan Yesu, Bitrus woroghe, “Cikilari ucaun na tidi kikane, tiba ke adanga atat, ti ke kurum kun Iliya.” Na ayinno ile imon na adin belle ba. ");
INSERT INTO amo_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Kube na adin belle nleli imone, kuwut tolo ku tursu nani, fiu da nani, na kuwute nkilino nani. ");
INSERT INTO amo_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Liwui nuzu nanya kuwute liworo, “Gono nighari kane na ina fere lanzan ghe.” ");
INSERT INTO amo_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Na imala ulanzu liwuiye, Yesu yita usame, inung so tik, nanya nayiri ane na iwa bellin umong ba, ile imon na iyene. ");
INSERT INTO amo_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Ukurtunu nkuiye, na isa unuzu kupara, ligozi nanit da zuro nanghe. ");
INSERT INTO amo_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Umon nanya ligozi gilla a woro, “Unan yiru ndin fofi nacara yene usaun nighe, amere gono nighe cas. ");
INSERT INTO amo_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yene Uruhu sa uyaunghe, amalzino, aketize, anutuzuno kupunget nnuwe, na asa usunghe ba, se ushalaghe. ");
INSERT INTO amo_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Asa nfo nono katwa fa acara, nshin ninghe na isa iyinno ba.” ");
INSERT INTO amo_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu kauwa a woro, “Anung anan salin nyinnu nin kuji kugbas, udu kishiyari nba yinu uso nanghinu danin nsaun fe kikane.” ");
INSERT INTO amo_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Na gone din cinu uduwe agbergenu yaunghe ilina kutyin atunna nketizu. Yesu kpada Uruhu unanzang, ashino nin gone, anin nakpa ucife. ");
INSERT INTO amo_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Vat mine yene nziziki ngbardang Kutelle, na vat mine nkiffo tunu nile imon asu, ani woro nono katuwa mye, ");
INSERT INTO amo_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Na to tigbulanghe do piit nnit nacara nanit.” ");
INSERT INTO amo_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Na inin wa yinin ule idiru ba, Bara na uwa nyeshin kiti mine na iyinno liti nlire ba. Vat nani nlanza fiu nworu itiringhe uliru une. ");
INSERT INTO amo_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Manyardang fita nanya mine, nbelleng nworu ghari ba so udiya mine. ");
INSERT INTO amo_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu nin yiru nkpilizu nibinai mine, a yicila kagone kabene a yisa likot me, ");
INSERT INTO amo_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Anin woro nani, ulenge na asere gono kane, asere menku. Ulenge na asere menku, asere ulenge na ana tuuyi, ulenge na aceo liti me nafo gono kibene amere ba so udya nanya mine. ");
INSERT INTO amo_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohanna kauwa, “Cikilari tiyene umong nutuzunu nagbergenu nin lisafe, tinanin wantinghe, bara na adi ndortu nari ba.” ");
INSERT INTO amo_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Na iwa wantinghe ba, “Ubellun Yesu, vat nlenge na adi nivira nan ghinu ba unminere.” ");
INSERT INTO amo_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Na ayiri nyiu me nda susut aceo umuro me udu Urushelima. ");
INSERT INTO amo_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ato anan kadura nbun me, inya ipira kagbir Nsamariya, ikeleghe imone. ");
INSERT INTO amo_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Anite kikane wa tighe mahabi ba, bara amal ciu umuro me udu Urushelima. ");
INSERT INTO amo_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Na nono katuwa me, Yakubu nin Yohanna inyene nani, iworo, “Cikilari titi ulah tolu umolu nani?” ");
INSERT INTO amo_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","A gitirino a kpada nani. ");
INSERT INTO amo_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Itunna inya udu nkan kagbir. ");
INSERT INTO amo_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Na idin cine libau we, umon woroghe, “Meng ba dofin fi udu kika na uba duu.” ");
INSERT INTO amo_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu kauwa a woroghe, “Ninyan yau dinin tiyyi, Anyin yita nin nado, meng gono nnit dinin kiti nciu liti ba. ");
INSERT INTO amo_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Anin woro nmong, “Dofini.” Ame woroghe, “Cikilari ucizine na ndo ndi kassu ucif nigh.” ");
INSERT INTO amo_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ame atimine anan nkul, fe can udi belle piit nin npash uliru kipin tigo Kutelle.” ");
INSERT INTO amo_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Umong ugang woroghe, “Meng ba dofinfi Cikilari, na ntuu ndi bellin anan kilari nighe meng nya.” ");
INSERT INTO amo_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesu kauwa a woroghe, “Na umong duku alenge na ata ucara me nkeke nikawa, asa a gitirno, na abase upiri kipin tigo Kutelle ba.” ");
INSERT INTO amo_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nene, nkon kubi Cikilari fere annit akut kuzor, ato nani nababa ido ubun mye nigbire nin niti nanga na amye dinin su nduwe. ");
INSERT INTO amo_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","A woro nani, “Ugirbe karin, anan katuwa yita cing. Bara nani nta munu sun nlirang, Cikilaringirbi nan kpina anan ngirbe ku. ");
INSERT INTO amo_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Caan munu ntomunu nafo akam nanya ninyonyo, ");
INSERT INTO amo_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Na iwa yaun nkka nikurfun ba, sa nkkan ncin ba, sa akwatak, na iwa su ilip libau ba. ");
INSERT INTO amo_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nanya vat kilari ka na ipira, nin cizine woro, 'Nsheu so nanya kilari kane.' ");
INSERT INTO amo_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Asa unan kibinai kisheu duku, nsheu mine ba so nanghe, andi na aduku ba, nshew mine ba kpilu kiti mine. ");
INSERT INTO amo_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Soon nanya kilari kani, ilii iso ile imon na ina mune, bara unan kauwa nbatina aseru uduk mine na iwa dortu niliri ba. ");
INSERT INTO amo_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Vat kagbir ka na ipira, asa isere munu leo vat nile imon na inna munu, ");
INSERT INTO amo_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","shinon nin na tikonu, iworo nani, 'kipin tigo Kutelle di susut nanghinu. ");
INSERT INTO amo_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Bara vat nanya kagbir ka na ipira asa na isere munu ba, nuzun nanya tibau mine iworo, ");
INSERT INTO amo_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","'Vat lidau kagbir mine na litafina nabunu bite, ti wese kiti mine, bara yinnon kipin tigo Kutelle nda susut nanghinu.' ");
INSERT INTO amo_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Meng nworo munu, uwui nwucu kidegen, nbati ayi asheu nin Sodom nanin kipin kane. ");
INSERT INTO amo_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Kash Korasinu! Kash Batsaida! Dafo umon izikiki ile na ina su kiti mine nda innere inasu ntaya nin Sidon iwa su udiu kutyin, iwa shonu imon tiyom iso nanya ntong. ");
INSERT INTO amo_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Bara nbati ayi asheu nin ntaya nin Sidon au na anug ba. ");
INSERT INTO amo_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Anung anan Kafarnahum idin kpilizu iba ghantin munu kitene kane? Nani ba iba da nin ghinu udu kuwu nlah sa ligan. ");
INSERT INTO amo_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ule na alanza munu, alanza menku, ule na anari munu anari menku, anari ule na ana tiiyi. ");
INSERT INTO amo_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Anit akut kuzor ane saa nin liburi libo, agbergenu nna nari atimine nanya lisafe. ");
INSERT INTO amo_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesu woro nani, “Nwandi nyenju sheitan wa diu kitene kani nafo ummali nu kiti. ");
INSERT INTO amo_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Yenen, ina na munu likara, ipatilu iyii nan ninang, nan vat nakarra na nan nivira mine, na imomon ba lanzu munu ukul ba. ");
INSERT INTO amo_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Vat nani na iwa su, liburi liboo bara nani cas ba, nworu tiruhu nna atimine kiti mine ba, suun liburi libo inyertinee ti sa mine kitene kani.” ");
INSERT INTO amo_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nanya kubi kurum, asu liburu libo nanya Nruhu Ulau, “Nzazin fi Ucif nigh, Cikilarikitene nin kutyin bara unyeshe ile imone kiti ni najinjin anan yiru, umini npuno kiti nalenge na ina dursuzo nani ba, ni nono nibebene, nanere Ucif nigh, ucaun nanya nyenu fe.” ");
INSERT INTO amo_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Vat nimon Ucif nighe na niy, na umon yiru gone ba, Ucife, na umon yiru Ucife ba se gone, vat nle na gone nyinna aba dursu ghe liti mye.” ");
INSERT INTO amo_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Na agitirno kiti nono katuwa mye a woro kusari, “Anan nmariari alenge na idin yenju ile imon na anug nyene. ");
INSERT INTO amo_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Meng woro munu gbardang na nan nliru nin nnu Kutelle nan nago din piziru iyene ile imon na anung na yene na iyene inin ba, Ukuru ilanza ile imon na anung na lanza, na ilanza ba.” ");
INSERT INTO amo_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nani umon unan ndursuzu nduka na Yahuduwa, dumunghe a woro, “Unan nyiru iyaghari nba su inan se ulai sa ligan?” ");
INSERT INTO amo_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu woroghe, “Iyaghari di nanya ninyerte nduke?” ");
INSERT INTO amo_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Akawa awooro, “Ubati usu Ncikilari Kutelle fe, nin vat nlaife inin vat likara fen nin kibinai fe, nin ndindin lisosin kupofe nafo liti fe.” ");
INSERT INTO amo_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesu kawa a woroghe, “Ubelle dert, su nani unan so.” ");
INSERT INTO amo_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ame unan yiru ninyerte dinin su a durso liti mye, a woro Yesu ku, “Ghari udondon kupo nighe?” ");
INSERT INTO amo_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Nkawe Yesu woroghe, “Umon unit wa nuzu Nurushelima udu Ujariko apira nacara nakiri, ifoghe icinghe fal. ");
INSERT INTO amo_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nanya kube umon upirist dofino libau we, n ayene a raffa likot akata nkon kusari. ");
INSERT INTO amo_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nani tutung nkon kuliviyawa da kitene ayene ghe, akuru ayira nkon kusari akata. ");
INSERT INTO amo_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Nkon ku Samariyawa di ncin mye ada kiti nkunekune mye. ");
INSERT INTO amo_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ada kupo mye atece ghe annute, atintio ghe nnufu ku, a tarda ghe kitene kajaki mye, ada ninghe kilari namara, amin ghe gegeme. ");
INSERT INTO amo_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Ukurtunu nkuiye, ayira isule iba anah unan kitene aworoghe, 'Mini ame gegeme, ndo ndak, vat nile imon na Uwutuno mba biufi.' ");
INSERT INTO amo_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Uyemeri nanya na watat ale udin yenju adi udondon lisosin kiti nle na awa piru a cara nakire?” ");
INSERT INTO amo_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Unan yure woro, “Ulange na awa lanza ukunekune.” Yesu woroghe, “Can udi su nani.” ");
INSERT INTO amo_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Nene ikiffo ucin, ipira nkan kagbir umon uwani lisa mye Marta taa ghe mahabi, ada ninghe kilari mye. ");
INSERT INTO amo_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ayita nin gwana kishono lisa mye Maryamu, aso nabunu Ncikilari adin nlanzu nliru mye. ");
INSERT INTO amo_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ame Marta yita nijasi likanju nimoli ado aworo Yesu ku, “Cikilari na fe nyene gwana ninghe ncini likanje usanin ba? Bara nani belinghe ada buuni.” ");
INSERT INTO amo_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ame Cikilari kawa a woro ghe, “Marta, Marta, fe ndama nin nimon gbardang. ");
INSERT INTO amo_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Imon irumari cas icine. Maryamu nfere imon icine ile na umon ba bollu kiti mye ba.” ");
INSERT INTO amo_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Na amala nliran nkan kiti, umon nanya nono kadura mye woro, “Cikilari, dursuzo nari usunn nliran nafo na Yohanna wa dursuzo nono kadura mye.” ");
INSERT INTO amo_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Yesu woro nani, “Kubi na iba su nliran woron, 'Ucif na lisafe so lau. Na kipin tigo fe dak. ");
INSERT INTO amo_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Na nari imonli nkolome liyiri. ");
INSERT INTO amo_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Shawa nin nalapi bite, nafo na arike din shawuzu nin nalenge na isu nari alapi. Na uwa do ninghirik kiti ndumuzunu ba.'” ");
INSERT INTO amo_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesu woro nani, “ghari nanya mine dimun ndondon, amin ndo kiti mye nin kiyitik, a bellinghe, 'Udon nigh nei ure nakalan nfon gol atat, ");
INSERT INTO amo_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","umong udon nigh worin ndak unuzu ncin, na ndinin nile imon na nba nighe ba.' ");
INSERT INTO amo_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ame ulele nanye ba kawughe, na uwa damei ba, nmal tursu kibulung, meng nan nono nmall noo, nwasu nfita nnafi ufungul ba. ");
INSERT INTO amo_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Meng nbellin munu, ko na aba fitu a nighe ufungule ba bara fe udon mere, bara uciu kibinai fe nin salin nlanzu ncing, aba fitu anifi ile imon na udinin su we gbardang. ");
INSERT INTO amo_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Meng tutun nbellin munu, tirinon iba nii munu, piziran iba se, reyon kibulu aba punu, munu mun. ");
INSERT INTO amo_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Bara vat nle na atirino aba seru, unan piziru ba se unan nrizu kibulun iba punghe mun. ");
INSERT INTO amo_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ghari nanya mine ulenge na adi ikifi gono mye ntiringhe ufungul aba nighe litala, sa fibo anaghe fiyii ya? ");
INSERT INTO amo_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Sa atirin likpai, ana naghe finagha? ");
INSERT INTO amo_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Bara nani anung na idi anan maggunta, iyiruufilizinu nimmon icine kiti nono mine, iyaghari ngbardang na ucif mine kitene kani ba nii Uruhu Ulau nale na itiringhe?” ");
INSERT INTO amo_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Nin kidughee, Yesu wa di nutuzunu nagbergenu, nan naturi, uso kubi nna agbergenu wa nuzu, unit uture lirina, ligozi nanit kiffo tinu! ");
INSERT INTO amo_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Among nanya nanite woro, “Nin Bazelbula, ugo nagbergenu adin nutuzunu agbergenu.” ");
INSERT INTO amo_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Among dumunghe idin piziru nalama unuzu kitene kani. ");
INSERT INTO amo_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yesu yinno ukpilizu mine, a woro nani, “Vat tigo tongo na tidi nivira nati mine ti ba so hem, Kilari ka na kidi nivira nati mine kiba di. ");
INSERT INTO amo_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Asa Sheitan di nivira nin liti mye Iyiziyari tigo mye ba yisina? Bara anung nworo ndin nutuzunu agbergenu nin Balzebul. ");
INSERT INTO amo_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Andi ndin nutuzunu agbergenu nin Balzebul, nin iyanghari anan dortu din nutuzunu muna? Bara nani inung ba so munu anan sharaa. ");
INSERT INTO amo_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Ama asa ndin nutuzunu agbergenu nin liyicin Kutelle, kipin tigo Kutelle nda kiti mine. ");
INSERT INTO amo_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Kubi na unan likara, kullun nin na soja idin ncaa kilari mye, imon mye ba so cai, ");
INSERT INTO amo_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","bara kubi ba unan likara nsu inasara a bollo imon likum kit nnite, aba pitirinu imon nacara nnit une. ");
INSERT INTO amo_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ulenge na adi nin mye ba, adi nivira nin mye ame ulenge na apitirno nin mye ba ashagilina. ");
INSERT INTO amo_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Kubi kongo na uruhu inanzang nnuzu kiti nnit, asa akatiza kiti nmyen, adin piziru nshinu, asa na ase ba, a woro, 'Nba kpillu kilari kanga na nna nuzu ku.' ");
INSERT INTO amo_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Na akpilla, aba se kilari ikuzu kinin inin ceo kinin gegeme. ");
INSERT INTO amo_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Aba nuzu adi yiru nton tiruhu kuzor, tongo nati katinghe nin magunta, vat mine ba dak ida so kikane, imali lisosin nnit une ba katinu uburne nin nanzang. ");
INSERT INTO amo_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Uso kubi na abelle ileli Imone vat, umon uwani ghantina liwui mye nbun ligozi nanit, a woro, “Nmarari liburi longo na lina marufi, nin nayazin ale na una mazin ku.” ");
INSERT INTO amo_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Bara nani ame woro, “Anan nmariari alenge na idin lanzu tugbulan Kutelle, inani myin tinin.” ");
INSERT INTO amo_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Na ligozi din pitiru anit gbardang, acizina ubellu, ko kuje, kuji magunta ri, idin piziru alama, na amon duku alenge na iba nii nani ba, se an Yunana. ");
INSERT INTO amo_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Nafo na Yunana wa da so alama udu uniniva, nanere tutun gono nnit, ba so alama kiti nko kuje. ");
INSERT INTO amo_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Uwani ngo Kusari nkudu ba fitu liyiri nwucu kidegen nin nanilime nko kuje ati nani iso anan nca nkul, bara awa duk unuzu nimalin kutyin ada lanza uyiru Solomon, ayene ulenge na akatin Solomon ku kikane. ");
INSERT INTO amo_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Nanilime Nninniva ba yisinu liri wucu kidegen, nin nanit kuji kone, iba ti nani iso anan ncaa nkul, bara iwa diu kutyin nin wazi yunana, yene umon duku, akatin Yunana ku adi kikane. ");
INSERT INTO amo_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Na umong duku ulenge na aba ti ulah npitila a nyeshe unin ba, sa kadas kukuzun, se kitene kiti ncise bara alenge na iba piru iyene nkanang. ");
INSERT INTO amo_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Iyizife nnert upitila kiddowo fe ba kullu nin kanag, andi iyizi caun ba, to kidowo fe ba kulu nin Sirti. ");
INSERT INTO amo_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Bara nani su seng, nkanang nanya fe na nsirtiyari ba. ");
INSERT INTO amo_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Asa nanere, kidowo fe kulun nin nkanang, na nkan kiti di nsirti ba, vat kidowo fe ba so nafo uputila a udin kassu, aba tifi nkanang.” ");
INSERT INTO amo_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Kubi na amala utiru, ku Farisiyawa bellinghe au idi lii imonli kilari mye, Yesu do adi lii imonle. ");
INSERT INTO amo_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Kunin Kufarisiya su amamaki nworu atina nlw sa ukusu nacara. ");
INSERT INTO amo_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ame Cikilari woroghe, “Anung a Farisiyawa, asa ikusu mamal nkop nin kishik, nanya mine kulun nin ucuci a magunta. ");
INSERT INTO amo_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Anung anan sali nati! Na ulenge na ana ke udase, amere na ke nanye ba? ");
INSERT INTO amo_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","na anan sali nimon ile imon na idi nanye, vat nimone bati lau. ");
INSERT INTO amo_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Bara nani, kash, anung Afarisiyawa bara idin nizu uzakka nimon kunen vat, inani nsuna imon icine nin su Kutelle. Uso lellei tisu gegeme nin nsu, na tiwa dira usu kagisin nimon ba tutun. ");
INSERT INTO amo_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Kash anung Afarisiyawa, idinin su lisosin nbun, nanya nkasssa we. ");
INSERT INTO amo_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Kash udu kiti mine, idi nafo nissek nanga na idin yenju ba anit sa ipalila sa uyiru mine.” ");
INSERT INTO amo_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Umong unan yiru nanya nduka Nayahudawa kauwa aworoghe, “Unan yira ile imon na ubelle tigozori kiti bite.” ");
INSERT INTO amo_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu woroghe, “Kash anung anan nyiru nduka! Bara asa anung na anit kutura gbardang kun nijasin in yauna, anung ba dudu kutura kone nin tiyicin mine ba. ");
INSERT INTO amo_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Kash udu kiti mine, anun din ke niti nlizinu nin na nan nliru nin nnu Kutelle, alenge na acif mine wa mollusu nani. ");
INSERT INTO amo_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Bara anung iyizi inbari, iyinna nin katuwa nacif mine, bara inughere wa molusu anan nliru nin nuu Kutelle, ina ke nisek mine, inan lizino mung. ");
INSERT INTO amo_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Bara nanere tutun uyiru Kutelle a woro, 'Nba tuu nani, anan nliru nin nuu Kutelle, nin na nan kadura, ibati nani ineo, imolsu amon mine.' ");
INSERT INTO amo_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ko kuje, inughere ba yaunu uhaki nmyi nanan nliru nin nnuu Kutelle mongo na iwa gutun, tun uburnu inye, ");
INSERT INTO amo_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Unuzu nmyi Habila udu Zakariya ule iwa mulu kiyitik nbagadi nin kilari nliran, nanere nworo munu ko kuje ba yaunuu uhakke. ");
INSERT INTO amo_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Kash anung anan nyiru nduka na Yahudawa, bara ina yaun imon npunu nyiru, na anung ati mine npira ba, inani nwantina anan pire.” ");
INSERT INTO amo_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Kubi na Yesu nsuna kikane, anan ninyerte nan na Farisiyawa ighana ghe, isu amusunanghe kitene nimon gbardang, ");
INSERT INTO amo_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Nkukari nwori ikiffo ghe nanya tigbulang mye. ");
INSERT INTO amo_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nanya nkoni kube, na gbardang limui nanit wa zuro ligowe, gbardang ipalila ati mine, acizina ubellu nono katuwa mye, “Yinnon ubellen nyist na Farisiyawa, unere magunta. ");
INSERT INTO amo_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Bara na imomon duku ilenge na inyeshin, ile na iba punu ba, sa itursun ile na iba yinnu ba. ");
INSERT INTO amo_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Bara vat nile imon na ubelle nsirti, iba lanzu nanya nkanang, ile imon na ubelle nanya kutyi, iba beellu kitene kilari. ");
INSERT INTO amo_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Meng bellin munu adondon nigh, yenje iwa lanz fiu nle na aba molu kidowo, nin nani na idumun nimomon ile na iwasa isu tutun ba. ");
INSERT INTO amo_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nba wunun munu atuff kitene nlenge na iba lanzu fiu mye, lanzan fiu nlenge na awa mdu adinin likara nworu atu kidowo nanya nlah. Nanere nbellin munu lanzan fiu mye. ");
INSERT INTO amo_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","A na ninari nitaun asa ilewe ikubu iba ba? Vat nani na nkan duku asa ishawa mun ba, nyenjie Kutelle. ");
INSERT INTO amo_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Vat titi litife ina batiza tinin. Na uwa lanza fiiu ba. Udunin ndaraja ukatin ninari gbardang. ");
INSERT INTO amo_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Meng bellin munu, vat nle na ayinni nbun nanit, meng ba yinin ghe nbun nanan kadura Kutelle. ");
INSERT INTO amo_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Bara ame ule na ata amusu nigh nbun nanit, meng bati amusu nigh nbun nanan kadura Kutelle. ");
INSERT INTO amo_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Vat nlenge na abelle tigbulang niviran kitenen ngono Kutelle iba shawu, ame ulenge na asu tizogo nin nivira kitene Nruhu, na iba shawu mun ba. ");
INSERT INTO amo_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Kubi ko na idanin ghinu kiti wucu kidgen, anan tigo, nin na nan nakara, na iwa dama ba, kitene nile imon na iba bellu ubun munu, sa ile imon na iba bellu. ");
INSERT INTO amo_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Bara uruhu ulau ba dursu munu, nanya nkoni kube ile imon na iba bellu. ");
INSERT INTO amo_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Umon nanya ligoze woroghe, “Unan yiru belle gwana nighe ti kosu ugadu. ");
INSERT INTO amo_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu woroghe, “Unit, ghari ntayi unan wucu kidge sa unan yisinu kiyitik mine?” ");
INSERT INTO amo_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ame woro nani, “Sun seng i kala ati mine kiti ngbardang nimon nacara mye ba.” ");
INSERT INTO amo_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Yesu belle nani tinan tigold, aworo, “Kunen nmong wa ni kumat kang, ");
INSERT INTO amo_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","a kpiliza liti mye aworo, 'Iyaghari nba su, na ndumun kiti kanga na nba ciu ileo nighe ku ba?' ");
INSERT INTO amo_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ame woro, 'Nene nbasu. Nba turzunu illai ile nkee ididia, nceu vat nile imon na ndumun. ");
INSERT INTO amo_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nnin bellin kidowo nighe, “ kidowo, ning uceo illyou in nakus gbardang. Shinno, uso ulii, uso nin, lanzu nmang.”' ");
INSERT INTO amo_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Kutelle worroghe, 'Fe unit ulalang nin kiyitik kane nba seru ulaife, ile imone na uceu iba lawu inghari?' ");
INSERT INTO amo_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Nanere umon ba yitu, ulenge na a ceo imon, a na ayita nin nimon kiti Kutelle ba.” ");
INSERT INTO amo_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesu woro non Katuwa mye, “Bara nani meng nbelling munu, yenje iwa dama nin nlai-sa imon nli, sa imon nshonu kidowo mine. ");
INSERT INTO amo_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Bara ulai katin imon nlii, kidowo tutun katin imon nshonu. ");
INSERT INTO amo_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Yenjen agoron, na idin su tibli sa ugirbi ba. Na idinin kiti kaciso sa filai ba, Kutelle din nli ninghinu. Na anun katin anyine ba! ");
INSERT INTO amo_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Nin ghari nanya minne nwasa akpina ngbardanag nayiri mye? ");
INSERT INTO amo_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Andi na iwasu isu ile imon icinghe ba, iyari inta idama nin kagisine? ");
INSERT INTO amo_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Yenjen amamu kusho inda na idin kunju. Na idin su katuwa sa fiyari. Nin nani meng nbelling munu ko Solomon nin ngongon mye wa shon imon nafo umong mine ba. ");
INSERT INTO amo_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Andi Kutelle din tizu ukpi kusho kuyok, uleng na idiku kitimone, udu nkui ina to nani nlah, iyaghari bati na aba su anunku kuyok ba, anan cing nyinnu sa uyenu! ");
INSERT INTO amo_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Na iwa dama kitene nimonli sa ile imon na iba sonu, na iwa so nin damuwa ba. ");
INSERT INTO amo_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Bara vat nigbir inye din piziru, ile imone, ame Ucif mine yiru au idinin su nile imone. ");
INSERT INTO amo_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Piziran kipin tigo mye, kagisin nimone iba kpin munu ku. ");
INSERT INTO amo_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Na iwa lanza fiu, bara na idi kago kabene ba, bara ucif mine din lanzu nmang ani munu kipin tigowe. ");
INSERT INTO amo_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Lessen ile imon na idumun Inii anan diru, keen tikka to nati ba jarzu ba, ceon imus kitene kani kika ukiri duku, sa kiyoro ba. ");
INSERT INTO amo_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Kiti kanga na Imus fe duku, kinere kibinaife ba yitu ku. ");
INSERT INTO amo_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Tern alutuk ajangarang mine gangang, na tipilila mine yita nkasu, ");
INSERT INTO amo_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","soon nafo annit alenge na idin ncaa Nchikilari mine, ule na aba sa unuzu kitin buki nilugma, asa ada ariyo kibulun ima punghe mun dedei. ");
INSERT INTO amo_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Kucin kone unan nmariari ale na Cikilare mine ba dase nani ncaa, kidegen nworo munu, aba bunku kulutuk ku kujangarang mye, ati nani iso, a ni nani imonli. ");
INSERT INTO amo_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Cikilari une nwandak nin lijii kiyitik, sa udu shantu kiti idi se nani idin ncaa, acin ane anan nmariari. ");
INSERT INTO amo_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Udu Ubune yinno, asa Cikilari Kilare yiru kubi ko na akiri ba dak, na aba yinnu ipuru ghe kilari ba. ");
INSERT INTO amo_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Soon nin yiru, na iyiru kubi ko na gono nnite ba dak ba.” ");
INSERT INTO amo_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Bitrus woroghe “Cikilari, udin bellu to tinan tigoldo bara arika, sa anite vat?” ");
INSERT INTO amo_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Cikilare woro, “Ghara unan nginu sa uyenu, ujinjin ule na Cikilare ba nighe acin mye, ani nani imonli kube dedei ya? ");
INSERT INTO amo_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Unan nmariari kucin kone, ule na Cikilare ba da seghe nsu nile imon na ataghe in suwe? ");
INSERT INTO amo_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Kidegene nworo munu, aba nighe imon mye vat. ");
INSERT INTO amo_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Kucin kone nwa woro kibnei, 'Cikilari ndandauna sa udak,' acizina ufo nacin mye nilime nan nishono, atunna ncii nin nso atah hem, ");
INSERT INTO amo_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","cikilari kucin kone ba dak liri lo na adin ncawe ba, sa kubi ko na ayiru ba, aba kezughe agir, a ceoghe kiti na na salin yinnu. ");
INSERT INTO amo_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Kucin kone nin tanni npilizu ncikilare, nin salin nke ncin nye sa asu nafo na Cikilare na bellin, iba foghe nin likuntung. ");
INSERT INTO amo_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ame ule na ayiru ba, idinsu ile imon na ibatin ikpizighe, iba kutughe baat bara utanni mye, vat ile na inaghe gbadang, iba piziru gbardan kiti mye, ule na iyinna ninghe, iba tirinu gbardang kiti mye. ");
INSERT INTO amo_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Nnna dak nda tii ulah inye, nda usu nigheri iwadi ita ula ku. ");
INSERT INTO amo_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Meng dinin nshintinu ule na nba shintinu munu mun, ndi shotu iwadi imala! ");
INSERT INTO amo_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Idin kpilizu nafo nna dak, nda ni munu nshau inye? Nani ba, nna dak nda wuso munuari. ");
INSERT INTO amo_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Nene nbellin munu nanya kilari awatua ba yitu ku, anit na tatt ba su ivira nin na nanit natat. ");
INSERT INTO amo_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Iba kosu kidowo, ucif nivira nin nsaune, usaune nivira nin ncif; unna nivira nin nshono, ushon nivira nin nnah; nan nles nivira nin nwul, uwul nivira nin nan nles.” ");
INSERT INTO amo_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu wadi nbellu ligoze, tutun, “Asa iyene awut kusari kitene, asa woro, 'Na nin dandaunu,' ba uwauri ba juuy nanere udi. ");
INSERT INTO amo_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Asa iyene ufunu nuzu kadas, asa iworo, 'Kiti ba yitu puu kang,' nanere ba yitu. ");
INSERT INTO amo_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Anun anan rusuzu natiminne, iyiru ubellu nimon inyi nin kitene, ani iyaghari nta na iyiru ubellu kube ko na tidi nanye ba? ");
INSERT INTO amo_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Iyaghari ntah na idin wucu kidegen nati mine ba? ");
INSERT INTO amo_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Asa uda nin nan nivira kitingo kubi na idi libau udowe keelin uliru baba iwa do idi teru munu kilari tigo. ");
INSERT INTO amo_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Meng bellin munu, na uba nuzu nacara mine ba, se una nari fikubu na udumun vat.” ");
INSERT INTO amo_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Kubi kone among anit bellinghe kitene na Galiliyawa, alenge na Bilatus wa munu nmyi mine, kitin ngutunu nmyi. ");
INSERT INTO amo_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesu kauwa aworo nani, “Ulin kpilizu nafo a Galitiyawa ale katin kagizine nin kulapi, nara idin niu nlo libau we? ");
INSERT INTO amo_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Na nani ba, meng nbelling munu, asa na anung su udiu kutyin ba vat mine iba nanu nloli libauwe lineme. ");
INSERT INTO amo_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Sa anit likure nin kulir nanyan Nsiliyom, ale na kisoro wa diu ki molo nani, idin kpilizu nafo inung wa din kulapi ikatina vat nanit Urshalima? ");
INSERT INTO amo_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Na nani ba, meng bellin munu, asa na anung su udiu katyin ba vat mine ba nanu tutun.” ");
INSERT INTO amo_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Yesu belle nani tinan tigoldo, “Umang wa bilisu kupau nanya kunen me, ada pizira kumate na ase ba. ");
INSERT INTO amo_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Unite belle unan ncaa kunene, 'Yene akus atatari ale asa nda nnan da se kumat kutca kone, na nse imonku ba, werne kunin, bara iyang ku wa nanza kunene?' ");
INSERT INTO amo_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Unan ncaa kunene kauwa aworo, 'Suna kunin nlo likuse, mang ba wuzu kuwu, in tighe utanki. ");
INSERT INTO amo_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Asa natah kumat likus ndake, ucaun, asa na ana ba, uwerne kunin!'” ");
INSERT INTO amo_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nene Yesu wadin ndursuzuwe nanya kutyin nlirag namon Asabbath, ");
INSERT INTO amo_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","umon uwani wa duku kikane, wenge na adimun nakus likure nin kulir, uruhu unazang, nkuzu kidowo wa seghe, aso kangarang awasa ayisina dert ba. ");
INSERT INTO amo_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Kubi na Yesu nyene ghe, ayicila ghe aworo, “Shino nin nkuzu kidowo fe.” ");
INSERT INTO amo_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","A tarda ucara me kitene me, dedei ayisina dert, azazina Kutelle. ");
INSERT INTO amo_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Inung ago nanya kutyin nlirag, lanza ayi, bara Yesu nnaghe ushinu liyiru nasabar. Ago we kauwa, iworo ligoze, “Ayiri kutocin duku alonge na iwasa isu katuwa, dan lelan shin ninghinu a na liyiri Nasabbath ba.” ");
INSERT INTO amo_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Cikilari kauwa aworo nani, “Anan rusuzu nati, na anug sa itere nijaki sa innah kite mine, idi ni nani nmyen liri Nasabbath ba? ");
INSERT INTO amo_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Bara tutun ule ushono Ibrahim, ulenge na Sheitan ntereghe akus likure nin kulir, itereghe na iwasa ibunku ghe liyiri Nasabbath ba?” ");
INSERT INTO amo_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Na abelle ile imone, vat nale na idi nivira nanghe lanza incing, vat ligoze wadi su liburi liboo, kitene nimon ididia na asu. ");
INSERT INTO amo_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ame Yesu woro nani, “Kipin tigoo Kutelle di nafo iyaghari? Nin nyaghari nba gwadu kinin muna? ");
INSERT INTO amo_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kidi nafo fimus kuku, fongo na unit nyawna amin nfilo nanya kunen me, in foni nkuno fiso kutca kudia, anyin kusho ani nda kee addo mine tilanghe.” ");
INSERT INTO amo_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Tutun aworo, “Min nyanghari nba gwadu kipin tigoo Kutelle muna? ");
INSERT INTO amo_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kidi nafo uyist na uwani nyauna, amunu nin nayanga atat an nbulun, udu kubi na umuzo.” ");
INSERT INTO amo_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu wa do lizzi nanya kipin nin nigbir libau udu Urshulima a dursuzo nani. ");
INSERT INTO amo_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Umong woroghe, “Cikilari, anan nse ntucu ba karnu ba?” A belle nani, ");
INSERT INTO amo_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Suun nnono inan pira kibulun kishuut, bara anit gbardang ba piziru, na iba se upiruwe ba. ");
INSERT INTO amo_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Kubi na unan kilari nnuzu, amin ntursu kibulun, anung ba yisinu ndas inin riyuu kibulun woro, 'Cikilari, Cikilari, tiba piru.' Ame ba kauwu aworo munu, 'Na meng yiru munu, sa inuzu nwere.' ");
INSERT INTO amo_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Aning ba woru, 'Tina tii tisono nbun fe, udursuzu tibau bite.' ");
INSERT INTO amo_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ame ba kauwa nani, 'Meng bellin minu, na meng yiru kika na inuzu ku ba. Cacanan kupo nighe, anan magunta.' ");
INSERT INTO amo_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Kubi ba dak na iba su kuculu nin yaru nayini, kubi na iyene Ibrahim, Ishaku, Yakubu, nin vat na nan nliru nin nnu Kutelle, nanya kipin tigo me, - anung inutun munu ndas. ");
INSERT INTO amo_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Iba da duru unuzu nasari annass inyi, inani nshino idin nlii nimonli kutebul kipin tigoo Kutelle. ");
INSERT INTO amo_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Yinon nani, unan ncizinu ba so unan kidung, unan kidung da so unan ncizinu.” ");
INSERT INTO amo_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Kubi baat, amon Afarsayawa da kiti me iworo, “Caan suuna kikane bara Hirudus dinin su amollufi.” ");
INSERT INTO amo_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesu woro “Caan idi bellin kinyinyo kane, 'Ndin kaluzu nagbergenu nshizhino nin tikonu, kitimone nin nkui, a liyiri lin tat, nba malu katuwa nighe.' ");
INSERT INTO amo_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Nanya nko yang, usoyi doli, ntunun kitimone nin nkui, nin liyiri ndortine, na iyinna imolu unan nliru nin nnu Kutelle ndas nin Urshulima ba. ");
INSERT INTO amo_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Urshulima, Urshulima, te na udin molusu anan nliru nin nnu Kutelle ufiliso alenge na ina tu nani kitife. Ndinin su npitirin nono fe, nafo kukuru na asa a pitirino nono me nanya nagilit nafe nyinna nani ba. ");
INSERT INTO amo_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Yene nfillo kilari fe, meng bellin fi, na iba kuru uyenei ba, se ubelle, 'Unan nmariarife ulenge na uba dak nanya lisan Cikilare.'” ");
INSERT INTO amo_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Uso liyiri namong Asabbath, kube ado nanya kilari nmon udia Nafarsayawa alii imonlii, iwadi ncara me chochot. ");
INSERT INTO amo_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Kikane nbun me, umon wa duku awa dinin nkonu nmyi adin nniyu mun kang. ");
INSERT INTO amo_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu tirino anan nyiru nduka nanya Nayahudawa, nin na Farsayawa, “Iyinna ishin nin nit liyiri Nasabbath, sa babu?” ");
INSERT INTO amo_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Inung so tiik. Ame Yesu minghe a fiyaghe, a woro caang. ");
INSERT INTO amo_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ame woro nani, “Ghari nanya mine ule na adinin gono sa finna na adio nanya nrijiya nwui Nasabbath na aba du dedei adi natun ba?” ");
INSERT INTO amo_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Na inung wa yinin ukauwu ghe nite imone ba. ");
INSERT INTO amo_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Kubi na Yesu wa yene alenge na ina yicila nani asa ifere niti lisosin ngongong, abelle tinan tigoldo aworo nani, ");
INSERT INTO amo_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Kubi na iyicilati uduu kiti nbuki nilugma, nauwa so kiti nse ngongon ba, bara sa umon duku na ina yicila ghe na akatinti nin ngongong. ");
INSERT INTO amo_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Asa unite nin fe vat ndah, iba woru fi, 'Naci unit ule kitife,' nin ncing uba kpulu idi so kiti kibene. ");
INSERT INTO amo_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Asa iyicilafi cang idi so kiti kibene, kube na ulle na ana cila yicilafi ndaa, aba bellin fe, 'Udon nigh dah kiti kidya.' Uba se ngongon kiti nale vat na isosin nan fi. ");
INSERT INTO amo_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Bara vat nlenge na atoltuno liti me iba ghantingh, ame ulenge na aghantina liti me iba toltunghe.” ");
INSERT INTO amo_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesu tutun woro nnit une na ana yicila ghe, “Kubi na ushiniya ubuki sa imonli, na uwa yicila adondon fe, likura fe, sa anan nimon nacara kupo fe, inung ba kuru iyicila fi, ikpilin in nifi na ubase uduk ba. ");
INSERT INTO amo_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Asa ubasu ubuki yicila akimon, agurgu aturri nin naduu ana salin nyenju kiti, ");
INSERT INTO amo_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","uba se nmari, bara na iwasa ikpilla inafi ba, bara uba se uduk liyirin nfitu nanit alau.” ");
INSERT INTO amo_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Umong na asosin kutebule nin Yesu, lanza ile imone, aworo ghe, “Unan nmariari ulenge na aba su kileo nanya kipin tigoo Kutelle!” ");
INSERT INTO amo_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ame Yesu woro ghe, “Umon unit wa dinin nbuki udia, ayicila anit gbardang. ");
INSERT INTO amo_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Na imonli nyini, ayicila anan katuwa kilari me, ato nani ido idi yicila alenge na ana bellin nani, 'Idak, bara ko yang inyini.' ");
INSERT INTO amo_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Inug vat nafo itere tinu cizina udasu nin kucikusu, unan nburne woro ghe, 'Meng na seru kunen, nba du ndi yene. Na nbase udake ba.' ");
INSERT INTO amo_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Umong tutun woro, 'Meng na seru inna ibaba ukashi utaun, ndin cinu udu idi gwada inin. Na meng base udake ba.' ");
INSERT INTO amo_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Umon unit woro ghe, 'Meng nasu ilugma ipese, bara nani na nbase udake ba.' ");
INSERT INTO amo_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Unan katuwa kilare kpilla ada belle Cikilare ile imone. Ale Cikilare kilare nana nayi, abelle unan katuwa my, 'Caan nanya kagbire dedei nan tibau udanin, nakimon, agurgu, a aduu nan naturi.' ");
INSERT INTO amo_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Unan katuwa woro, 'Cikilari, ile imon na ubelle nsu inin, har nene kiti duku, sa unit. ");
INSERT INTO amo_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Cikilare belle unan katuwa me, 'Nuzu udo tibau tididia ukpeshilu nani idak, bara kilari nighe nan kullo. ");
INSERT INTO amo_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Bara meng nbellin munu, na umon nanya nalele na iwa burun uyicilu nani dudu imonli nighe ba.'” ");
INSERT INTO amo_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Nene ligozin na nit wa din cin nin ghe, a girtino a woro nani, ");
INSERT INTO amo_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","wase umong ndaa kiti ning na anari ucef mge, unna nye, uwani nye, nwana nye, ni lime nan nishono - ee, umunu ulai me - na a batina usu gono katwa nin ba. ");
INSERT INTO amo_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","vat inle na a yira kuca nkul nye a dufini ba na awa sa asu gono katwa nin ba. ");
INSERT INTO amo_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Bara ghari nanya mine, ule na a dinin su a kee kilari na aba so a batiza imon ile na aba mulun kewe ayinin sa a nin nimong ile na ama ke kelare mun udu umale anin cizin ba? ");
INSERT INTO amo_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ana nani ba, a wa cizin lituine na a mala ba, vat nle na a yene a ba sisughe, ");
INSERT INTO amo_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","a beling ule unite na cizin ukee kilari na amala ba. ");
INSERT INTO amo_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Sa uyapin agomari, na ama du likum nin mung ugo, na aba so a seru ashawara sa ama yinnu likume nin na nit amoi likure wase uleli ugowe nda nin na nit amoi akutaba? ");
INSERT INTO amo_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Andi na nani ba, aleli anang likume nwadi piit, a taa umong adi foo acara bara iso mang. ");
INSERT INTO amo_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Bara nanere, vat nanya mine andi na usuna ile imong na udumung ba na uwa sa usoo unam masun iyinu ning ba. ");
INSERT INTO amo_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Nto caun, bara na misali mamas, mi ba kuru me lawa ntwe tutungha? ");
INSERT INTO amo_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Na mima yitu nin katwa tutung ba, I ma gutunu mining. Ule na adi nin na tuf na a lanza, na a lanza. ");
INSERT INTO amo_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Vat nanang sesun gandu nan gisin nanan kulapi wa dasu kitin yesu idin lanzughe. ");
INSERT INTO amo_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Afarsayawa nan nanang niyerte wa din gbulu idin belu natimene, “unit ulele din sesu aman kulapi amini din nlii nanghenu.” ");
INSERT INTO amo_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesu benle nani tinankuguldo, ");
INSERT INTO amo_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ghari nanya mine, a wadi nin nakam akut likure ada dira kurum naye na aba sunu akut kutir nin kutir a doo mpiziru kurume nanya kushue se ase kuninba? ");
INSERT INTO amo_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","A wanin se kuning, na ama ti kunin nabandang a su ayi aboo ba. ");
INSERT INTO amo_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","A wa saa kilari, a yicila adondong nan nanan kupoo mye, abelin nani, “Bunoni liburu liboo, bara nan nse Kukam nighe na kuna wulu.” ");
INSERT INTO amo_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Nbelin munu au nanere, liburi liboo ba yitu kitene kani bara unan kulapi warum ule na a suna kulapi mye, akatin anit akut kutir nin kutir ale na idi nanya kulapi mene. ");
INSERT INTO amo_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Sa u yeme uwaniari na adi nin nikubu likure, firum wa wulughe, na aba ti ula limoo a kuu kutyye a piziru sey a see fi nin ba? ");
INSERT INTO amo_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","A wa see, a yicila adondong nin naman kupoo mye a benle nani “buno ni liburi liboo bara nam see fikubunighe na fina wulu.” ");
INSERT INTO amo_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Nanere, mbelen minu, liburi liboo ba yitu nbun nnono kadura Kutelle uwarum nwa sun kulapi mye.” ");
INSERT INTO amo_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu moro, “Umong unit wadi nin nano niba, ubene nanya myene woron ncife, ");
INSERT INTO amo_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","'Ucif, nai unang ugadue,' a koso nani utamani mye vat. ");
INSERT INTO amo_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ma itaa ayiri ba, ubene fita udun kan kipen piit, adi wultun vat imong ile na iwa nighe nan nadondong a hem. ");
INSERT INTO amo_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Na amala uwultune vat, kukpong kudindya deu nanyan mgene, anin cizina upiziru nimonli. ");
INSERT INTO amo_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ado adi piziru katwa kitin kon kunang myenne, a naghe katwa libya na ledu. ");
INSERT INTO amo_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Aso nin nayiaboo adin lii nimonli naledu bara na umong naghe imonli ba. ");
INSERT INTO amo_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Bara nani na kibinaiye nsa kidomomye, aworo, 'Acin ncef nighe amashinnari din lii imonli igutuzuna, mmile da sosin kikane kukpon ba moliia! ");
INSERT INTO amo_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mba sunu kikane ndo kitin ncif ning, nning belinghe, “Ucif, nta kulapi nnang kitene, nin kiti fe. ");
INSERT INTO amo_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Na mbatin iyicilai usaun fe ba; tai nafo nkong kucin fe.”' ");
INSERT INTO amo_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Usaun ubene nya udu kitin ncife, na awa doo piit, ucife yeneghe, anin lanzan nkunekune me, a taa ucum, adi gbindiringhe a luluu kukpan nuu me. ");
INSERT INTO amo_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Usaune woroghe, 'Ucif, nta kulapi kitene kani nin bun fe. Na mbatin i yicilai usaun fe ba.' ");
INSERT INTO amo_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ucife woro na cinme, 'Daan nin nimoon icine, i shoonghe, i tighe ficancan, nin na kpatok nabunu me. ");
INSERT INTO amo_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Daan ning fina fi gbondilong ida boo fining. Na ti li tisu liburi liboo. ");
INSERT INTO amo_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Bara na usaunighe wa ku aminim nta luai. A wa wulu aminin saa.' Inin cizina liburi liboo. ");
INSERT INTO amo_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Usaun ukune wa di di kunen. Na a da susut kilare, alanza tigangang nan na lantung nin nyizinu. ");
INSERT INTO amo_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ayicila nkan kucin a tirino iyanghari nse kilare? ");
INSERT INTO amo_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Kucine woroghe, 'gwana fe nsa ucif fe uni boo fina fidya, bara na asaa ucine.' ");
INSERT INTO amo_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ayi nana usaun ukune, a nari upiru kilare ucife nuzu, ada fooghe acara. ");
INSERT INTO amo_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Bara nani usaun ukune kpana a woron ncife, 'Yene, mbgardang nakus ale na nta nin fi, na insa nanza fi kibinai ba, na usa nayi kagono kayin nboo nan na du nighe ba. ");
INSERT INTO amo_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","bara na usaun fe nsaa, ule na ana di molu imon lisosin nan nawani ahem, umini nabooghe fina fidya.' ");
INSERT INTO amo_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ucife woroghe, 'usaun ning, udi ligowe nin me vat ni mon ile na idi inan in fere. ");
INSERT INTO amo_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Bara nani ucaun ti su ayiaboo ti nyizin, bara na gwana fe wa ku, amini nta ulai nene: awa wulu aminin nsa.” ");
INSERT INTO amo_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu kuru a woro nono katwa me, “Umong unan nikurfung wadi nin nang tamani me, ida belinghe unang yeujun ntamanie din nanzu unis. ");
INSERT INTO amo_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Unan nikurfughe yicila ghe aworoghe, 'I yanghari ndin lanze litife? Daa uda nyii kibatiza nimon ile na nwa nili uyenje bana na fe unit ucineari ba.' ");
INSERT INTO amo_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Unan yenjughe ntamane woro letime, 'I yanghari mbati nin litining, I yanghari mba ti, bara na cikilari nighe ma kalu katwa kane nacara nighe? Na indi nin likava mawuzu wuzu ba, tutung indi lanzu incin kufili. ");
INSERT INTO amo_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","In yiru imon ile na mba ti, bara na lwa kala katwa kane nacara nighe, anit ma sesui ngamine.' ");
INSERT INTO amo_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Unan yeujun ntamane yicila vat nale na cikilare din durtu nami tire, anin tirino unan burne, 'Imashinari cikilare din durtu fi?' ");
INSERT INTO amo_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","A woro, 'A mudu akut likure nnuf kuca.' Anin waroghe 'Soo mas, kibatiza fe kaa, u nyertin akut ataun.' ");
INSERT INTO amo_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Unang yeuju ntamane woro mmong, 'I mashinari idin durtufi?' A woro, 'A mudu akut likure nialkama.' A woroghe 'Kibatiza fe kanga yertina akut likure sa aba.' ");
INSERT INTO amo_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Unan nikurfughe taghe njah bara na awa su katwa me caut ba, bara na nono nyii ulele di nin nibinai nsu nimon icine bara anit mime ba na nafo nonon nkananghe di. ");
INSERT INTO amo_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","In belin fi, pizira adondong bara litife nin nimon nyii, bara I wa nyaa ima pirizin fi nanya nilari mi ne. ");
INSERT INTO amo_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ule na adi nin yinnu-sa-uyenu nanya nimon baat ade nin yinnu-sa-uyenu nanya ni dya, ule na adi nin salin yinnu-sa-uyenu nanya ni baat na ama yitu nin yinnu-sa-uyenu nanya nimon idya ba. ");
INSERT INTO amo_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Bara nani, andi na udi nin yinna-sa-uyenu nimoon inyii ba, ghari ba yinnu ninfi nin nimoon kidegene? ");
INSERT INTO amo_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Nanere, andi na udi nin yinnu-sa-uyenu kitene kuturan mong ba, ghari ma nifi ile na idi infe? ");
INSERT INTO amo_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Na kucin wasaa amyino an cin nilara naba kubi kurume ba, sa a ma nari umong ati usun mmong, sa a su umong katwa amari usun mmong, na u wasa usu Kutelle licin nin tamani kubi kurume ba.” ");
INSERT INTO amo_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Afarsayawe na i wadi anam su nikurfunghari, I lanza ule ulire vat, itunna nsisu ghe. ");
INSERT INTO amo_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","A woro nani, “Idin suzu kidegen mine niyizi nanitari, bara nani Kutelle yiru nibinai mine. Ileli imon na idin ruu ining idi zemzem nizi Kutelle. ");
INSERT INTO amo_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Uduka nin nanan liru nin nuu Kutelle wa di, Yohana nin daa. Unuzun koni kubi udu sa ligang, uliru Kutelle idim belun nin, vat nanit din shoo ati nanya ti bau ti bau. ");
INSERT INTO amo_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Bara nani ukatin nin sauki nworu kitene kani nin kadas kata nin waru fiyert firum nanyan nliru me ikala sa uti kinuu. ");
INSERT INTO amo_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Vatin nlenge na akoo uwani me ayira umong adin nozu nin na wani ahem, nanere uwani ule na akoo ules me aminin di yira umong adin nozu nin les uhem. ");
INSERT INTO amo_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Umong unan nikurfung wa duku na iwa shonghe imoon icine anin din lanzun mmang vat liri nanya ntamani udya. ");
INSERT INTO amo_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Umong unan kufilli nunnu kibulung me nin nanut kidowo me. ");
INSERT INTO amo_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","A wadin su a li mbubun nimon li na idin disu kuteen, banin nani, ninau nin din lelu anut kidowo me. ");
INSERT INTO amo_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Usuo inlong liyiri unam kufille kuu anan kadura Kutelle da yiraghe udu abunu Ibrahim. Unam nikurfughe wang kuu ikasaghe. ");
INSERT INTO amo_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Nanyan nla, adin niu, a fiya iyisi me ayene Ibrahim ku piit nin Liazaru figiri me. ");
INSERT INTO amo_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","A fiya liwai me aworo, 'Ibrahim ucif lanza nkune-kune ning utuu Liazaru ku, a diti liyicin me nanyan myen adak ada tii limila cancam, indin niu namyan nla ulele.' ");
INSERT INTO amo_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Bara nani Ibrahim woro, 'Gono kubin laife uwa seru imon icine nlaife, Liazaru sere imon inanzang. Bara nani itaghe insheu kibinai kikane, fe tutung uniu. ");
INSERT INTO amo_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Banin nani kuwu kudya nkese nari bara na alenge na ima kafinu udu kiti fe na iwasa i kafina ba, a na umong wasa a kafina udak kiti bite ba. ");
INSERT INTO amo_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Unan nikurfughe woro, 'Ndin foo fi nacara, Ibrahim ucif. U tuughe udun ngan cif nighe. ");
INSERT INTO amo_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Bara na idi nin nwana inung nataun bara anan wunno nani atuf, bara iwa dak imus kitin niu kaane tutung.' ");
INSERT INTO amo_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Bara nani Ibrahim woro, 'Idi nin Musa nan nanan liru nin nuu Kutelle; na ilanza nani.' ");
INSERT INTO amo_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Unan nikurfunghe kpana aworo, 'na nanere ba, Ibrahim ucif, bara nani iwase umong ulenge na aba du kitimene nanya nabi, I ma kpiliu nibinai mine.' ");
INSERT INTO amo_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Bara nani Ibrahim woroghe, 'Andi na ima lanzu Musa ku nan nanan liru nin nuu Kutelle ba, na ima lanzu umong tutung ba sa afita nanya nani.'” ");
INSERT INTO amo_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu woro nono katwa me, “Nanere imong duku na I ma ti nari ti te kulapi, bara nani kash inle na imong ine madak nacaramye! ");
INSERT INTO amo_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Uma yitughe barabara I terughe kuyazan n nto I tuu ghe nanya kuli kudya, nuuru ati umong nanya nabebene alele atiro. ");
INSERT INTO amo_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Yenjen ati mime, gwana fe nwa ti kulapi, kpadanghe, a wa yenin, I shawa nin kulapi me. ");
INSERT INTO amo_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","A wa tifi kulapi kuzur nanya liyirine, akuru a da kitife kuzure, abelin 'men intafi kulapi,' doleari u shawa nin kulapi kune. ");
INSERT INTO amo_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Nono katwan Yesu wa woro ucef kinari mene, “kpina nari uyenu sa uyenu ku.” ");
INSERT INTO amo_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Cikilare woro, “I wadinin yinu sauyenu nafo fiyip nikan, I ba benlu kuca koone, 'Fita kikane udi soo nanya kuli,' kuma lanzu a nunko lifi. ");
INSERT INTO amo_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Bara nani ghari nanya mine, na adi nin kucin katwa kunen sa adi libya nakam, na asaa unuzu kunen ubelinghe, 'abelinghe da nenenene ama soo kilai'? ");
INSERT INTO amo_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Na ama belinghe, 'Kankai imemon nli, anin teru katino me a suyi katwa mmalu kilai. Fe nin le infe'? ");
INSERT INTO amo_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Na a benle kucine nja ba, bara na asuu lmonile na itaghe ku, a suwa? ");
INSERT INTO amo_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Nanere anun wang, I wa su vat nimong ile na ita munu nsue, I ma benlu, 'Na arik a cin a cuneari ba. Fi suu imon i le na itanarin suere cas.” ");
INSERT INTO amo_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Na I wa din libau udu urshalima, a wa din cin magazangazam nsamariyo nin Galili. ");
INSERT INTO amo_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Na awa piru inkan kagbiri, kikane azuru nin namong anit akuturu. I yisina piit nin ghe. ");
INSERT INTO amo_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","I ghantina ti wuyi me, I din belu, “Yesu, Kumalami, lanza nkunekume bit.” ");
INSERT INTO amo_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Na ayene nani, a woro nani, “Can idi duro a timune kitin nadidya kutii nlira.” Na i doo, ise ushinu. ");
INSERT INTO amo_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Na warum nanya mene yene ashino a kpiliya kidowo a ghartina liwui adin vuu Kutelle. ");
INSERT INTO amo_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ada tumuno nabun Yesu, adin godighe ame wadi ku Samariya wari. ");
INSERT INTO amo_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Yesu kawa, a woro, “Na anun likurera wa shin baa? Ingisin mzakure dey? ");
INSERT INTO amo_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Na amon duku na iba kpinlu I ruu Kutella ba, maa koo kumarare?” ");
INSERT INTO amo_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","A woro ghe, “Fita ughaa, uyinun sali yenu fe nshino nin fi.” ");
INSERT INTO amo_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Na afarsayawe ntiringhe ubelem nsa kitari tigoo Kutelle, Yesu kawa nani a woro, “Kilari togoo Kutelle na imun ncamari ba. ");
INSERT INTO amo_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Sa ima woro, 'Yene kikaa!' sa, 'Yene kikan ni!', bara na kilari tigoo Kutelle di nanya mene.” ");
INSERT INTO amo_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Yesu woro nanang katwa me, “Ayiri din cinu na I ba yitu nin su nyenu nlon lirin ngono nit, na ima yenu ba. ");
INSERT INTO amo_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","I ma benlu minu, 'Yeneng, kekanii!' Yeneng kikaa!' na iwa doo nyenjwe ba, sa I durtu nani, ");
INSERT INTO amo_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","nafo na nicananghe nwa nuzu na wite awa manliin, asa mi nuzun ko kuwut udu kitin kune, nanere Gono nnit ba yitu nanya liri me. ");
INSERT INTO amo_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Bara na ama niyu nimon gbardan nin burne i nin narighe nko kuje. ");
INSERT INTO amo_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nafo na uwa di nanyo nayirin Nuhu, nanere tutung ima ti nanya nayirin Gono nnit. ");
INSERT INTO amo_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","I wadin nle, iyitan nso, I suzu ilugma I niza ashono mene nilugma, udu liri lo na Nuhu wa pirum njirgi - men nwure daa mida mulso nani vat. ");
INSERT INTO amo_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Namere nafo na udi nanya nayirin Lot, I wadin nli iyitan nso, I sese, I lese I bilsa, I key ni lari. ");
INSERT INTO amo_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Bara nami nanya liri longo na Lot in nuzu nanyan Sodom, atantani nla wa din nnuzu kitine kani uda leo nani vat. ");
INSERT INTO amo_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Nanere u ma so liri longo na Gono nnit ba dak. ");
INSERT INTO amo_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Nanyan lolire, na I wa yinin ule na adi kitene kutii tolu adi yiru kutura me nanya kilare. Na iwa yinin ule na adi kunen saa kilari ba. ");
INSERT INTO amo_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lizinon nin wanin Lot. ");
INSERT INTO amo_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Vat nle na a din piziru ulai me ama diru unin, bara nani elu na anari ulai me aba se unin. ");
INSERT INTO amo_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nbelim minu, nanya kitik kane ida se an waba non kitene nkomi urume. I ba yiru umong, isuun umong. ");
INSERT INTO amo_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Awani naba ba yitu tiyazung, I ba yiru warum isuun warum. ");
INSERT INTO amo_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Anit naba ma yitu kuneen, I ba yiru umong isuun umong.” ");
INSERT INTO amo_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","I tiringhe, “Nweri cikilari?” Anin woro nani, kika na libi nonku agbulluk ma kilinu kitee. ");
INSERT INTO amo_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","A benle nani tinan tigoldo intizu nlira, na nibinai mene nwati seeng ba, ");
INSERT INTO amo_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","a benle, “umong unan wucun nliru wadin kan kagbiri, unam wucun nliru une wadi nin fiu Kutelle ba, tutng na adin yenju unit nin titti litiba. ");
INSERT INTO amo_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Umon uwani wa duku na ules me wa ku nanya kagbiri kane, asu ada kitime kolome liyiri, abenle, 'Buuni anan nayi asirne mpardai.' ");
INSERT INTO amo_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Kubi kata piit na adinin su a buunghe ba, na I dandauna ba a woro liti me, 'Bara na indin lanzu fui Kutelle sa unit ba, ");
INSERT INTO amo_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","vat nani uwanin salin nles ulele din fizwi kibinai, nma buunghe nwusughe kedegene, bara a wa tii kudirya nin dasu me vat liri.'” ");
INSERT INTO amo_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Cikilare nin woro, “Lanzan imon ile na unan wucun nlire mbele. ");
INSERT INTO amo_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nene na Kutelle ba bulu ale na ana fere nami na idin ku culu uwui nin kitik udu kiti me ba? Na aba ti ayiasheu nin yenuba? ");
INSERT INTO amo_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mbeling minu au aba saru nani dedai sa unanzu kubi. Bara nani Gono nit wadak uyi ulele aba se anan yenu-sa-uyenu kuwa?” ");
INSERT INTO amo_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","A kuru abenle tiwankari tone nale na inun din yenju ati mene anit alau wari. Inani din narsi amon anit, ");
INSERT INTO amo_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“An waba wa doo nanya kutii nlira iba ti nlira - warum wadi Kufarsayawa nin nanbe unan sesun gandu. ");
INSERT INTO amo_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Kufarsayawe yisina a taa imusin immong inlire nin liti me, 'Kutelle ngode fi bara na meng masin nafo among anit ale na akiriyari. anan salin nlau, anan nuzu nin naulani a buu, sa nafo ule unan sesun ngandue ba. ");
INSERT INTO amo_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","In din su ukotu nayi tiba nanya na yiri kuzoor, in din nizu uzakka vat ni mon ile na in dumun.' ");
INSERT INTO amo_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Bara nani ame unan sesun ngandue yisina piit, na awa sa a fya iyizi me ayene kitene kanin ba, bara nani a reo figiri me, a woro, 'Kutelle, lanza in kune-kune ning, unam kulapi.' ");
INSERT INTO amo_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Nbelin minu, unit une wa nyaa udu kilari lau, na nafo unan mba me ba, bara na vat ule na a ghantina liti me, iba tultinghe, ule na a tiltino liti me ima ghantinghe.” ");
INSERT INTO amo_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","A nite wa din dasughe nin nono nibebene, anan dudo nani, nono katwa me yene, ikpada nani. ");
INSERT INTO amo_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yesu yicila nani udak kitime, aworo, 'Sunam nono nibebene dak kitining, na iwa wantin nani ba, bara na kilari tigoo Kutelle kin nimus nalelere. ");
INSERT INTO amo_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Kidegene indin belu minu, vat inle na ama seru kilari tigoo Kutelle nafo nono naneba to na ama piru ba.” ");
INSERT INTO amo_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Umong unan tigoo tiringhe, aworo, “Ku mallami kucine, iyanghari ma ti inse upirun nlai sa ligang?” ");
INSERT INTO amo_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu woroghe, “Iyangharin ta udin yicwi ucine? Na umong ucine duku ba, ma se Kutelle cas. ");
INSERT INTO amo_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","U yiru uduka - na uma piziru awani ahemba, na uma molu umong ba, na uma su likiri ba, na uma ti kinu litin mong ba, na tikune kitin cife nin nafene.” ");
INSERT INTO amo_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Unam tigoo we woro, “Vat ile imoone ina malu su an duttu gono kibene.” ");
INSERT INTO amo_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Na Yesu nlanza nai, a woroghe, “Imun irumari duu fi. Can udi lewu imoon ile na udumun vat ukosu anan sali mun, udak uda dofini, uma nin se kiti lisosin kitene kani.” ");
INSERT INTO amo_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Na unan nimoon nacare nlanzanani ayi me nana kang, bara na awa di nin nimoon nacara kang. ");
INSERT INTO amo_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu na ayeneghe, ayin nanghe anin woro, “Uma yity nin nijasi kang unan nimoon nacara piru kilari tigoo Kutelle! ");
INSERT INTO amo_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Uma katinu nin sheu Kuronkomi piru nanga ligalong nalura nworu unan nimoon nacara piru kilari tigoo Kutelle.” ");
INSERT INTO amo_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ale na iwa din lanzwe woro, “To ghari ba se utuce?” ");
INSERT INTO amo_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu kawa aworo, “Imun ile na idin yenju na iwasa itaa ki ti nanit ba iwa sa itaa kiti Kutelle.” ");
INSERT INTO amo_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Bitrus woro, “Arikin suna vat imon ile na tidi mun ti nani ndofin fi.” ");
INSERT INTO amo_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu nin woro nani, “Kidegene, mbelin minu na umong duku na a cino kinari, sa uwanime sa qwana me, sa una nin cif, sa nono, bara kilari tigoo Kutelle, ");
INSERT INTO amo_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ule na aba se mgbardang nanya nyi ulele ba, nin nyi ule na udin cinu ulai nsali ligang.” ");
INSERT INTO amo_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Na awa pitirin likure nin naba udu kiti me, a woro nani, “Yenen, ti ma nyiu udu Urshalima, vat nin nimon ile na ina yertin inuzu nanan liru nnuu Kutelle litin Gono nit ima kulu. ");
INSERT INTO amo_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Bara ima nakpughe nacara na wurmi, ima yasughe, ima tighe a lanza incing, inin tufuzunghe ataf. ");
INSERT INTO amo_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","I wa malu ukpizughe, ima mulughe liri lin tat aba fitu tutung.” ");
INSERT INTO amo_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Na iyinno vat ni le imone ba, too ti gbulanghe wa nyeshin nani, na iyinno imon ile na a wa belin nani ba. ");
INSERT INTO amo_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","I daa nkang kubi, na Yesu ndaa susut nin Jeriko, umong uduu wa sosin kupoo libau in piziru i filizinghe ikurfung, ");
INSERT INTO amo_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","na a lanza ligozi nanit din cinu, a tirino iyanghari nse? ");
INSERT INTO amo_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","I belinghe Yesu kunan Nazarat ari din cinu ukatu. ");
INSERT INTO amo_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Bara nan uduuwe fya liwui me, a woro, “Yesu, Gonon Dauda, lanza nkune-kune ning.” ");
INSERT INTO amo_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","A lenge na Iwa din cin nbune kpada uduuwe I woroghe a ti tik. Ana kpina liwuiye ku, “Gonon Dauda, lanza nkune-kune ning.” ");
INSERT INTO amo_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu yisina daang anin benle nin likara au I dak nin nite kiti me. Na uduuwe nda susut, Yesu tiringhe, ");
INSERT INTO amo_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“I yanghari udinin suu insufi?” A woro, “Cikilari, in di nin suu in yene kiti.” ");
INSERT INTO amo_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu woroghe, “Puno iyizi fe, uyinnu-sa uyenu fe nshino nin fi.” ");
INSERT INTO amo_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kiteene iyizi me puuno kidowo, a nin dofinghe, nruu Kutelle. Na iyene nani, anite vat ruu Kutelle. ");
INSERT INTO amo_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu pera a wa nin din cinu nanyan Jeriko. ");
INSERT INTO amo_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Umong unit wa duku lisa me Zakka. A mere udiya nanang sesun gandu a wa di nin nikurfung kang. ");
INSERT INTO amo_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","A wade nin su ayene sa ghari Yesu, bara ligozi nanit na ayinno ba, bara na a wadi kaff. ");
INSERT INTO amo_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","A kata mbun na nite nin cum adi ghana kuca kuppul anan yeneghe, bara na Yesu wa cinu ukatun loli libau we. ");
INSERT INTO amo_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Na Yesu ndaa kitene, a fya iyizi a woroghe, “Zakke, tolo mas, bara kitomone nmadu ngafe.” ");
INSERT INTO amo_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","A taa mas, a tolo anin sereghe nin nayi aboo. ");
INSERT INTO amo_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Na anit vat nyene nani, I tunnan ngbondilu, I din duu, “A doo kilarin nlenge na adi nim kulapi.” ");
INSERT INTO amo_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakka yisina a woron Cikilare, “Yene, Cikilare, kuger intamani nighe in ma ni anan diru na kara, sa ina seru umong imong imon in ma kpillu inighe tinas na ina seru.” ");
INSERT INTO amo_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Yesu woroghe, “Kitimone utucun daa kilari kane, bara na ane wang donon Ibrahim mari. ");
INSERT INTO amo_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Bara na Gono nit na dak ada piziru a tucu anit alenge na I wulu.” ");
INSERT INTO amo_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Na I lanza ile imone, a leo ubun ntirwe a benle nani nin nanan tigoldon, barana a wa dak susut nin Urshalima, inung nin ceo nibinae sa kilari tigoo Kutelle ba sa ku bere. ");
INSERT INTO amo_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","A woro nani, “Umong unit wa su ucin udu kipin ki piit anan di seru kilari tigoo me anin nya usa. ");
INSERT INTO amo_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","A yicila acin me likure, a naa nani amoi likure, a woro nani, 'Can kpilizan a cara mun udu kubin sa nighe.' ");
INSERT INTO amo_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Bara nani anan kipen me nari ame I too among a didya udu kiti me, I belinghe, 'Na ti ma yinnu unit ulele su tigo nati bite na.' ");
INSERT INTO amo_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Uso kubi ko na a saa, unuzun seru kilari tigo we, a woro I yicila acin me vat na awa ninani ikurfunghe bara a yinin imashinari I see kitine nikurfunghe bara ukpilizu nacara. ");
INSERT INTO amo_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Unan burne da ubun me, a woro, 'Cikilari, ikurfungfe mmara amoi likure tutung.' ");
INSERT INTO amo_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Cikilare woroghe, injaa, 'Gajiya nin katwa, kucin kucine. Bara na una su uyinu-sa-uyenu nanya nimon icing, uba se kutet likara nigberi likure.' ");
INSERT INTO amo_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Unan mba me da, a woro, 'Ikurfung fe, Cikilari, na maru amoi ataun.' ");
INSERT INTO amo_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Cikilare woroghe, 'Yenje nigbiri nitaun.' ");
INSERT INTO amo_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Umong kuru adaa a woro, 'Cikilari, ikurfung fe ile na in wa ceo inin gegeme nany nimoon, ");
INSERT INTO amo_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","bara na imwa lanza fiu fe, bara na fe dinin kibinai kinanzang. Asu uyira kikanga na uceo ku ba, ukowo ile imon na una bilisu ba.' ");
INSERT INTO amo_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Cikilare woroghe, 'Bara ti gbulang imliru fe nma wucufi mun, fe kucin kibinai ki sirne. Uyiru meng unan kibinai kisine ari, in din pilu imon ile na in ceo ba, nin kezu ni mon ile na mbilsa ba. ");
INSERT INTO amo_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Iyarin taa na una ceo ikurfung ninghe kikaa na idin cisu ku ba, bara inwa sa imba di seru inin nin nimon kitene?' ");
INSERT INTO amo_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Cikilare woro nalenge na iyisin kupoo we, 'Seren ikurfung, ile na idi kiti me ini ule na di nin likure.' ");
INSERT INTO amo_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","I woroghe, 'Cikilari, a di nin namoi likure.' ");
INSERT INTO amo_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","'Inbeling minu, vat ule na adi mun Iba kpinghe ku, bara nani ule na asalin mun, I lele na adimun wang ima bulu. ");
INSERT INTO amo_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Bara nani ale na ina nari na iwa din nin su meng su tigoo kitene mine ba, daan nin ghinu ida molsu nani mbun nighe.'” ");
INSERT INTO amo_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Na a benle nani ile imoone, a tuna ncin me, cindu Urshalima. ");
INSERT INTO amo_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Uso na ada kupoon Baitfaji nin Bethany, litala loo na idin yicu Uzaitun, a too nono katwa me naba, ");
INSERT INTO amo_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","a woro nani, “Can nanya kagbirin mbune I wadin pire, Ima yenu kagono kajaki kanga na isa ghana ku ba, bunkun kanin ida niyi. ");
INSERT INTO amo_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Wase umong ntirin minu, 'I yarin taa idin bunku kanin?' I belinghe, 'Cikilari di nin su kanin.'” ");
INSERT INTO amo_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ale na I wa tuu nani doo idi se kijakye nafo na Yesu mbele nani. ");
INSERT INTO amo_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Na I wadin bukwe, unan kanin woro nani, “I warin ta I din burku kijakye?” ");
INSERT INTO amo_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","I woro, “Cikilare de nin nsukanim.” ");
INSERT INTO amo_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","I da nin kanin kitin Yesu, I tiza alituk mene kitene kaning, min tarda Yesu ku kitene kaning. ");
INSERT INTO amo_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Na aghana, I tiza alituk mene kitene libauwe. ");
INSERT INTO amo_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Na a wa dak susut kikaa na litalan Zaitun ntula ku, vat nono katwa me cizina ulanzun mang I kifo uruu Kutelle nin ti wui ti kang nin nitwa ni didya naa na iyenje, ");
INSERT INTO amo_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","I din belu, “Ubab mariari ugo ule na adaa nanya lisan Cif! Ayiasheu nanya kitene kani, nin ruu kitene ki piit!” ");
INSERT INTO amo_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Among afarsayawa na i wadi nanya ligozene woroghe, “Ku mallami kpada nono katwa fe.” ");
INSERT INTO amo_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesu kawa a woro nani, “Inbelen minu, alele nwa ti tik, atala alele ba kawu.” ");
INSERT INTO amo_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Na Yesu nda kupoo kagbire, a tultino nmizin bara kagbire, ");
INSERT INTO amo_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","a benle, “Mkuru fo iyiru nanya liri lole, anun wang, imon ile na ida minu nin nayi aboo! Bara nani iyeshe imon nizi mine. ");
INSERT INTO amo_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Bara ayire ma dak nati mine, na anan sali nsu mine ma kye udanga I kilin vat nasare iparda minu. ");
INSERT INTO amo_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","I ma kezu minu utulu kutiin nin nono minue, na ima sunu nlon litala kitene nlon ba, bara na amun wa yinnin ba na Kutelle wa ceu ayi nworu atucu minu.” ");
INSERT INTO amo_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu pira nanya kutii nlira a cizina ukuu nale na iwa din lesu nimoon, ");
INSERT INTO amo_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","a din belu nani, “Ina yertin, 'Kilari ninghe ba so kilarin nlira,' bara nani anung ani nkpiliya kinin kiso kuwu na kiri.” ");
INSERT INTO amo_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Bara nani Yesu wadin dursuzu nanit nanya kutii nlira, anan yenji kutii nlire nin nanan niyert umunu adidya na nite vat wadi sin su imolughe, ");
INSERT INTO amo_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","bara nani na I see libau nsunani ba, nara na anite vat wadin lanzughe. ");
INSERT INTO amo_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","I wa diku nlon liri, na YEsu wadin dursuzu na nite nanya kutii nlira nin belu nani utiru Kutelle, adidya kutii nlire nang nanan niyerte daa kiti me nan na kukune ntardu nacara alau. ");
INSERT INTO amo_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","I benle ulire, I woroghe, “Benle nari nin liyapin licarari udin su ka katwa we? Sa ghari ule na anafi lo likare?” ");
INSERT INTO amo_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","A kpana a woro nani, “Meng wang ba tirin minu imemong. ");
INSERT INTO amo_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Belenni ubelen inshintun Yohana, Uwa nuzu kiti Kutelle aria. Sa kiti na nit?” ");
INSERT INTO amo_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","I kpilza nati mene, I benle, “Ti wa woro, 'kitene kani,' a ba benlu, 'too iyarin taa na iyina yina nin ghe ba?' ");
INSERT INTO amo_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Tutung ti ma belin 'unuzu na nitari,' anite vat ma fil su nari nin natala bara na iyire Yohana wadi unam liru nin nuu Kutelleari.” ");
INSERT INTO amo_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","I kawa au na iyiru kite na a nuzuku ba. ");
INSERT INTO amo_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Yesu woro nani, “Na meng ma belin minu nin liyapin likarari in din su ale adodwe. ");
INSERT INTO amo_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","A taa anite ntun tiwankare, “Umung wa bilisu kunem, anaa among ukewe, anya udu nkankipin a di dandaun ku. ");
INSERT INTO amo_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Na kubi da atoo kucin me udu kitin nanan kye kunene, au inighe kumat kuce, bara nani anan kye kunene fooghe, inin kooghe nin na cara akone. ");
INSERT INTO amo_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","A kuru a too nkun kucin me ikuru I fooghe, I naghe incin, inin kooghe nin na cara akone. ");
INSERT INTO amo_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","A kuru a too unan tat ikuru I lanzaghe ukul, inin fillinghe indas. ");
INSERT INTO amo_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Bara nani Cikilari kunene woro, 'I yanghari mba ti? Na ntoo gononsunighe. Mbuti ima yenu ngongonme.' ");
INSERT INTO amo_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Bara nani naiyeneghe ncinu, I munu ati I woro, 'Ulelere unan nlin gadu kunen kune, dan ti molughe, ugadwe nan soo unbit.' ");
INSERT INTO amo_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","I fillinghe mamal kunene, inin mologhe. Iyari unan kunene ma tii nani? ");
INSERT INTO amo_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ama dak ada mulsu nani, anin ni amon kunene.” Na I lanza, I woro, “Kutelle sauke.” ");
INSERT INTO amo_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Bara nani Yesu yene nani, anin woro, “Iyari ile I yerte din belu? 'Litala loo na anan kye kilare nari, linnere nda so lin tune kilare'? ");
INSERT INTO amo_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Vat nle na a deu kitene litala lile ama putuzu agerager. Bara nani bat ne na litale ndeu liti me lima yarughe.” ");
INSERT INTO amo_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Bara nani anan niyerte nin na didya kutii nlire wa piziru I kifoghe nanya kuni kube, bara na I yino a wasu too tiwankare nati menere. Bara nani I wa lanza feu nanite. ");
INSERT INTO amo_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","I yenjeghe mseen, I too anan gbizinu kipin ita nafo anit alau, inan se ufanu nliru me, bara inan kifoghe inakpa anan natet tigoo ngumna. ");
INSERT INTO amo_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","I tirighe, I benle, “Unan dursusu, ti yiru udin dursuzu ubele dert, na umon din rusuzu fiba, bara nani udin dursuzu kedegene udu libau Kutelle. ");
INSERT INTO amo_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Udukari kiti bite ti ni Kaisar ku uganu bite sa babu?” ");
INSERT INTO amo_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Bara nani Yesu yinno kujinjin mene, a woro nani, ");
INSERT INTO amo_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Dursuni fikubu, kuyeli nghari, nin lisa du kitene fin nin?” I woro “Un Kaisar.” ");
INSERT INTO amo_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","A woro nani, “Naan Kaisar ku imun ile na idi un Kaisar, nin Kutelle imun ile na idi in Kutelle.” ");
INSERT INTO amo_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Anan miyerte nan nadidya kutii nlire na iwa yinin unari ni mon ile na awa belen nbun nanite ba. I lanza umamaki nkawu me na ibenle uliru ba. ");
INSERT INTO amo_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Na amon Asandukiyawa nda kiti me, ale na I wa woro na ufitun yii duku ba, ");
INSERT INTO amo_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","I tiringhe, I benle, “Ku mallami, Musa wa yertin nari a woro, gwana nmung wa kuu nin ulani, na I mara ba, unite yira uwanin gwana me, a maraghe gono ku. ");
INSERT INTO amo_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Nwana wa duku imun kuzur, unan burne yira urani, a kuu na imaraba, ");
INSERT INTO amo_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","unan mba me wang nanere. ");
INSERT INTO amo_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Unan tate udu unan zurre nanere na imara ba, ");
INSERT INTO amo_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","na ikala ayeri uwane kuu wang. ");
INSERT INTO amo_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Lirin fitun yii ama yitu uwani ngha nany mene? Bara na ma suzu ilugma min wane?” ");
INSERT INTO amo_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu woro nani, “Nono inyii ulele din suzu ilugma, I niza awani. ");
INSERT INTO amo_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Bara nani ale na idumna nani ise iduru useru nanan fitu unuzum kul inin piru ulai sa ligang na idin suzu ilugma sa i nakpa uwani ba. ");
INSERT INTO amo_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Na I ba kuru I kuu tutung ba, bara na isoo nafo nono kadura Kutelle, inun nso nono Kutelle. ");
INSERT INTO amo_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Bara nani iba feu abe, Musa wang I wa durughe, mbeleng kitene na a wadi kusho kikaa na awa yicila Ucef Kutellen Ibrahim, Kutellen Ishaku, nin Kutellen Yakub. ");
INSERT INTO amo_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Nene na ame Kutelle nanan nkulari ba ama kun nanan nlaiyari, bara na vat di nin nlai udu kiti me.” ");
INSERT INTO amo_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Among anan niyerte kpana iworo “Ku mallami ukpana caut.” ");
INSERT INTO amo_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Bara nani ikuru I tiringhe imemon turtung ba. ");
INSERT INTO amo_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesu woro nani, “I yizieri I din belu au Kristi gono Daudari? ");
INSERT INTO amo_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Bara na Dauda litime wa belen nanya niyert in Zabura, Ucife wa woro Ucif nighe, 'Soo incara ulime ning, ");
INSERT INTO amo_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","sai dai nta anan narife kitin cisu na bunu fe.' ");
INSERT INTO amo_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Nanere Dauda yicila Kristiku 'Ucif' a suu usaun Dauda nene?” ");
INSERT INTO amo_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Natuf nanit vat a woro nono kadura me, ");
INSERT INTO amo_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Sun insen nin nanang niyert, ale na idinin su I cinu nanya nalutuk ajajangaran, nin su nilip icine nanya tikasau, nin niti lisosin nididya nanya natii nlira, nin niti nididya niti tibuki. ");
INSERT INTO amo_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ikuru idin nanzu ninari nawani ale na ales mene nakuzu, nin nlira mijakaka kirusuzo. Alele maseru ukul udindya.” ");
INSERT INTO amo_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu fiya iyizi ayene kitene kani anin yene anan nikurfunghe din nizun usadaka mine nanya kukuzenghe. ");
INSERT INTO amo_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","A yene umon uwani na ulese wa ku adin ti nikubu iba nanya kukuzunghe. ");
INSERT INTO amo_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Anin woro, “Kidegene mbelen minu, ule uwanin derun lese inta vat a kata anit ane. ");
INSERT INTO amo_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Vat mene wani nanya nigbardan ile na idimun. Bara nani ule uwanin salin lese, wani nanya likimun me, vat nikurfun mere a wanutun. ");
INSERT INTO amo_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nafo na amon waliru kutii nlira, nafo na ma kye nin natala acine nin sadaka, a woro, ");
INSERT INTO amo_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Bara ile imune na idin yenju, ayiri ba dak na ima sunu nlon litala kitene nlong na ima sali sa uturne ba.” ");
INSERT INTO amo_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Bara nani itiringhe, I woro, “Kumallami, nin shiyari ile imone ba ti?” ");
INSERT INTO amo_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesu kawa, “Yenjen umon wada rusuzu minu Bara anit gbardan ba dak nin lisa ning, I din belu, 'Mere ame,' 'Kuben ndaa susut.' Na i wa dufin nani ba. ");
INSERT INTO amo_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","I wa lanza ubelen likum nin fizu nayi, na I wa lanza fiu ba, bara na ile imone ma dak nin burne, nara nani na liganghe nsa da ba.” ");
INSERT INTO amo_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Akuru a woro nani, “Nmgiin ma su likum nin umong nmgiin, kipin tigoo nin kan kipin tigoo. ");
INSERT INTO amo_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kutyene ma zullunu kang, nin nite gbardan kukpan ma yitu nin nijase tekanu tididya. Adadu fiyu ma yitu nin nalap adidya kitene kani. ");
INSERT INTO amo_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Bara nani makin ile imoone vat, ima ti minu acara iti minu ayiasirne, ima du nin ghinu nanya ni larin nlira nin nilari licin, I ma du nin ghinu ubun tigoo nin nbun na gumna bara lisa ning. ");
INSERT INTO amo_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Uba soo kube na iba belu imoon icine ile na Kutelle nsuu minu. ");
INSERT INTO amo_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Bara nani keleng nibinai mine na ima kesuzu ati mine udu kuni kube ba. ");
INSERT INTO amo_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Bara na nba ni minu tigbulan nin kujinjin, na vat anan nari mine wasa ita mayardan ku sa I kpiliya umon uleru ba. ");
INSERT INTO amo_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Bara nani acef, nwana, adondon nin nakura ma nakpu minu, ima ti among mine ikuzu. ");
INSERT INTO amo_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ima nari minu bara lisa ning. ");
INSERT INTO amo_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Bara nani na liti titi mine lirum ma wulu ba. ");
INSERT INTO amo_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Nenyan nteru nibinai mine I ba se imon kitene tilai mine. ");
INSERT INTO amo_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","I wa yene ikilino Urshalima nin nasoja, yinnong unanzwe nda susut. ");
INSERT INTO amo_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Na ale na idin Yahudiya cum udu kitene natala, ale na idi nanya kipine kitik nuzu, na I wa yining a le na idi tikauye piru ba. ");
INSERT INTO amo_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Bara na ale ayire an tunjuari, bara vat ni lee imon na ma yertin kulo. ");
INSERT INTO amo_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Kash nawani ale na idin nin naburi kumat nin nalee na idin mazinu nono nanya na yiri ane! Bara na ijasi idya ma yitu nmgine, niin tinana nayi udu anite. ");
INSERT INTO amo_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Imanin mulsu nani nin kusangali ima soo alin nanyan nmgene vat, awurmi ma patilu Urshalima udu kubin kulu na wurmi. ");
INSERT INTO amo_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Kulap ma yitun nwui, nanyan mpoi, nin nanya niyinin, nin kitene nyii, nin puyu nati nmgen, nany nlazu fiyu ngurzunu na rawa adidya nin fune. ");
INSERT INTO amo_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Anit ma kuzu ifiliza bara fuyu inca nimon ile na idin cinu kitene nyii. Bara na likara kitene kani ma zulunu. ");
INSERT INTO amo_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","I ba nin yenu Gono nnit din cinu nanya na wut nin likara nin zazu udya. ");
INSERT INTO amo_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Bara nani ile imoone nwa cizin, fitan iyisin, inin ghantin ati mine, bara na utucu mine nda duru susut.” ");
INSERT INTO amo_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yesu benle nani tiwankari, “Yenen kuca kupul nin nace vat, ");
INSERT INTO amo_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","I wa yene kuca kupul ngutuna afa apese din tilu I yino bara ate mine au kubi kusik nda susut. ");
INSERT INTO amo_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Nanere, I wa yene ile imoone din dasu, yinong au kipin tigoo Kutelle nda susut. ");
INSERT INTO amo_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Kidegene, mbelinminu, na ko kuje a katu ba, se imoon ilelee nkulo vat. ");
INSERT INTO amo_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kitene kane nin nmgen ma katu vat, bara nani na ligbulan lirum nanya nlirunighe ma katu ba. ");
INSERT INTO amo_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Bara nani, dinjan atuf nati mine, bara na nibinai mine wati getek nin na dadu ananzang, inyeu mso na dadu ahem, nin kpilizun nliru nyii, bara na lere wada muu minu, ");
INSERT INTO amo_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","nafo libarda, bara na lima dak liti na nit vat nanan nlai na idi nanya inyii ulele. ");
INSERT INTO amo_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Bara nani, Punon iyizi vat kubi idin tizun nlira bara inan se agan kang inan cuo ile imoone na ima dak, inin yisin mbun Gono nit.” ");
INSERT INTO amo_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Kubi ko na awadin dusuzu nanya kutii nlira nin kitwik a nuzu udas, anin moro kiten nlon litala na idin yicu litalan Zaitun. ");
INSERT INTO amo_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Anite vat da nin koi dindin inan lanzaghe nanya kutii nlira. ");
INSERT INTO amo_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nene ubukin burodin salin nimon infizwe da susut, ule na idin yecu kata natibite. ");
INSERT INTO amo_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Adidya kutiin nliara nan nanang niyert soo ikpilza na ima kifu Yesu ku imulughe, bara na iwadin nlanzu fiu na nite. ");
INSERT INTO amo_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Shetan pira nanya Yahuda Iskariyot, owarum nanya likure nin naba me. ");
INSERT INTO amo_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Yahuda du idi kpilza nang na didya kutii nlira nang nanan niyert na ma nakpu Yesu ku nacara mene. ");
INSERT INTO amo_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","I lanzan nmang, inin yina imanighe ikurfung. ");
INSERT INTO amo_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ayina, a nin din piziru nimon baat na ama tii ananakpaghe anit wa yinin. ");
INSERT INTO amo_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Lirin nborodi sa imon fitize da, na uso doleari inakpa kukam nhadaya. ");
INSERT INTO amo_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Yesu too Bitrus nin Yohana ku, a benle “Can idi kanja nari imonlin kalu nati bite, bara tinan lau ining.” ");
INSERT INTO amo_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","I tiringhe, “Inweri udin nin sun woro ti di su lakanjwe ku?” ");
INSERT INTO amo_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Akawa nani, “I wa piru nanya kipine, umon na a yauna ka suu nmyen ma zuru minu, dufinonghe udu kilari kaa na apira nanye. ");
INSERT INTO amo_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","I benle Cikilari kilare, 'Kumallami benle nari, “Kutii na mare dinweri, inweri nba lii imonlin kahu nate nwere nin nono katwa ninghe?”' ");
INSERT INTO amo_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","A ma duru minu kuti ko na I malu kyelu kudya. Kun kitene, kanjan imonle kikane.” ");
INSERT INTO amo_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","I do, I di se vat nmoonghe na abenle nani. Inin kele kiti keleuwa. ");
INSERT INTO amo_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Na kube ndaa, a so nan nono katwa me. ");
INSERT INTO amo_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","A nin woro nani, “Indi nin su nwadi inmalu nlii imonlui ilele nanghinu uworu min niyu. ");
INSERT INTO amo_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Bara nan belin minu, na inma kuru nli nan ghinu tutun ba, saidai ikulu nanya kilari tigoo Kutelle.” ");
INSERT INTO amo_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Yesu nin yira ukoop, na ata ugodiya, a woro, “Seren I kosu nati mine. ");
INSERT INTO amo_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Bara nan mbelin minu, na mba kuru nsumo ko kumati kuce kune tutun ba, se kipin tigoo Kutelle ndaa.” ");
INSERT INTO amo_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","A nin yira uborodi, na ana ugodiya ku, afucu unin, anin naa nani, abenle, “Kidowa nunghere kane kaa na nna ni bara anung. Sun nene I lizizin nin me.” ");
INSERT INTO amo_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","A kuru ayira ukoope nafo na ani taa na imala kileuwe, abenle, “Ule ukoope likamali nirghari lipese nanga nmii ning, mo na wa gutun bara anung. ");
INSERT INTO amo_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Bara nani yenjen. Ule na alewei adi logowe nin me keetebur kone. ");
INSERT INTO amo_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Bara na Gono nit ma nyeu nafo na ina belin. Bara nani kash nleli unite na amere ina lewughe nacara me!” ");
INSERT INTO amo_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","I nin cizina utiru nati mene, nghari nanga mene ma su lidungu lone. ");
INSERT INTO amo_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kubung nin fita nanya mene mpeziru ghani ba so udiya nanya mene. ");
INSERT INTO amo_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","A woro nani, “Ago na wurme dinin nan cinilare mene, ale na itti nin natek licara udin yicu nani anan tigoo in ruu. ");
INSERT INTO amo_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Bara nani na uma so nani nin ghinu ba, nmaimako nani, na ule na amere udiyawe nanya mine kpilin aso nafo kagono kabene. Na ule na amene idin cisughe iyizi kpilin aso kulin mene. ");
INSERT INTO amo_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ghari udiyewe, ule na a sosin kitene kutebure sa ule na asu kucin? Na ule na asosin kitene kutibure re ba? Nin nani ndi nanya mene nafo kucin. ");
INSERT INTO amo_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Bara nani anughere na I wadi nin me nanya ndumunu ning. ");
INSERT INTO amo_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Mnani minu kipin tigoo, nafo na ucenighe na mo nyii kipin tigowe, ");
INSERT INTO amo_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","I nan leu iso kutabur nighe nanya kipin tigoo nighe. Inin so kutet in wucu tilem likure nin tiban Israila. ");
INSERT INTO amo_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Simon, Simon, yino, Shetan di nin su akifo fi, anan cecile fi nafo ualkama. ");
INSERT INTO amo_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Bara nani meng mma tifi nlira, bara uyenu nsalin yenu wa dire. Uwadi umalu gitirinu kimal tutung, ta nwana fine likara.” ");
INSERT INTO amo_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Bitrus woroghe, “Ucef, mang ba du ningfi kilari licin nin nkule.” ");
INSERT INTO amo_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu kawaghe, “Inbelinfi, Bitrus, na ku kuluke ma culsinu ti tat ba, uma benlu na uyiri ba.” ");
INSERT INTO amo_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Yesu woro nani, “Na awa tuminu sa lijip, nkatizu ni moon, sa akpatak, I wa dira imemoona?” Inin kawa, “Na ti wan dira ba.” ");
INSERT INTO amo_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Anin woro nani, “Bara nani nene, ule na adinin lijip, na a kala linin, tutung nin nkaa ntizu nimoon. Ule na a sali nin kusangali na a leueu kulutukme adi seru kurum. ");
INSERT INTO amo_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Bara nan beleng minu, I mon ile na ina yertin litinighe ima kulu gbas, 'I yeneghe nafo unan salin duka.' Bara nani ile iman na iwa beling litinighe din kulusu.” ");
INSERT INTO amo_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Inin woro, “Ucef, yene! Asangali aba ale.” Anin woro nani, “A batina.” ");
INSERT INTO amo_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Na ileu imari, Yesu nga, nafo na amene udi litalan Nzaitu, nono katwa mge nin dofinghe. ");
INSERT INTO amo_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Ma iduru, aworo nani, “taan nlira iwa piru nanyan njaraba.” ");
INSERT INTO amo_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","A cacana kupuu mene nafo utuu litala, anin tumuro nin nalung ataa nlira. ");
INSERT INTO amo_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","A benle, “Ucef, wase y yina, kala ukoop ulele litining, min nani na uwa dofin kibinai ning ba, na kin fere so.” ");
INSERT INTO amo_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Unan kadura Kutelle nin daa unuzu kitene kani, a taaghe likara. ");
INSERT INTO amo_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Na awaadin niyu, a kpina nlire ku, tinuntu me tantizo kang nafo nmyii na ngutuna kuteen. ");
INSERT INTO amo_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Na afita unuzun nlire, adaa kitin nono katura me, ada se nani idin moro bara nibinai nisirne mene, ");
INSERT INTO amo_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","anin tirino nani, “Inyarin taa idin moro? Fitan iti nlira, bara I wa piru ticankira.” ");
INSERT INTO amo_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Na awa din nlire, iyene, ligozin na nite ndaa, ligowe nin Yahuda, uwarum nanya likure nin nabe, a dewu nbune. Ada kupoon Yesu anan taghe usumba, ");
INSERT INTO amo_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","bara nani Yesu woroghe, “Yahuda uma lewu Gano nit nin sumbaa?” ");
INSERT INTO amo_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Na ale na I wa killinghe nyene nani, I woro, “Cikilari, ti kewu umong nin kusangalia?” ");
INSERT INTO amo_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Umong nanya mene kewe kucin ndiya nang yenju kutii nlere, kutuf, ncara ulime a nin werne kunin. ");
INSERT INTO amo_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Yesu woro, “Naneli mbatina,” a nin dudo kutufe, ku shino. ");
INSERT INTO amo_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Yesu woro udiya nnan yenju kutii nlire, anan ncaa kutiin nlire, nin nadidiya ntardu nacara kutii nlira na iwa dak kiti me nin mayardam, “Idaa nafo anang kifun kiria nin nasangali nan tiyupa? ");
INSERT INTO amo_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Na uwadi nan ghinu nanya kutii nlire vat lire, na umong myene nakpa ucara liti nighe ba bara nenere kubi myene, nin likara nsirti.” ");
INSERT INTO amo_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Na I kifoghe, I yaa nin ghe, I duu ninghe kilari ndya kutii nlire. Bara nani Bitrus difino nani piit. ");
INSERT INTO amo_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Na I suso ula nanya kudarwe inin so ligowe idin lanzwe, Bitrus soo nanya myene. ");
INSERT INTO amo_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nkan kabera kucin yeneghe a sosin nkanang nlee, ayene iyizemye anin woro, “Ule unite nyita ligowe nanghe.” ");
INSERT INTO amo_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Bara nani Bitrus ta mayardan ku, aworo, “Uwani nan yirughe ba.” ");
INSERT INTO amo_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Na idandouna ba, umong kuru ada yeneghe, a woro, “Fe wang di nan ghinu.” Bara nani Bitrus woro, “Unit, na meyari ba.” ");
INSERT INTO amo_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Na ita kubiri kubi umong unit kuru ada woro, “Kedegene unit ulelen yita nin ghe, bara ane kunan Galiliari.” ");
INSERT INTO amo_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Bara nani Bitrus woro, “Unit nang yiru imon ile na udin belu ba.” Na aduu inlire kukulok kolsuno. ");
INSERT INTO amo_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Na a kpilia umuro me, Cikilare yene Bitrus ku, Bitrus nin lizino imon ile na Cikilare nni belinghe, na aworoghe, “Na kukulok ma kulsinu titat ba uma woro na uyirwui ba.” ");
INSERT INTO amo_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Na a nuzu udas, Bitrus gila kang. ");
INSERT INTO amo_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Anite na iwa din caan Yesu su ghe liyong inin fooghe. ");
INSERT INTO amo_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Na ituswughe iyizi, itininghe i woro, “Su anabci, ghari ulenge na areofi?” ");
INSERT INTO amo_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","I bele imon gbardang litin Yesu, izoguzo ghe. ");
INSERT INTO amo_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Na kitin shanta, a kukune na nite da pitiruno ligowe. Umunu adidya na priest nin na nan ni nyerte. I pira nin ghe kudaru nwuchun liru, ");
INSERT INTO amo_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","iworo, “Andi fere Kriste, belle nari.” Ama a woro nana, “Asa nbelling minu, na ima yinnu ba, ");
INSERT INTO amo_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","asa meng tirin minu, na ima kawu ba. ");
INSERT INTO amo_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ama ucizunu nene udu ubun, Gono nit ma so ncara uline unlikara Kutelle.” ");
INSERT INTO amo_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Vat mine woro, “Ani fera Gono Kutelle?” Yesu woro nani, “Anughere nworo mere.” ");
INSERT INTO amo_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","I woro, “Iyaghari nta tidu nin su nnan ba? Bara arik nin nati bite nlanza nnu me.” ");
INSERT INTO amo_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Vat lipitin mine fita, ida nin Yesu nbun Bilatus. ");
INSERT INTO amo_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","I tunna nvuruzughe nliru, I woro, “Ti se unit ulele adin nanzu nmyin bite, a wantina anit uni in Kaisar ku ugandu, a din belu ame litine Kristiari, Ugo.” ");
INSERT INTO amo_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Bilatus tiringhe, a woro, “Fere Ugo na Yahudawa?” Yesu kawa ghe a woro, “Fere nbelle nani.” ");
INSERT INTO amo_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Bilatus woro na didya na prieste nin lipitin nanit. “Na nse unit ulele nin taanu ba.” ");
INSERT INTO amo_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Amma ileo ubun nin sho nati, i woro, “Adin rusuzu anit, adin dursuzu anit nan nyan Yahudiya vat, ucizunun Galili uda duru kikane.” ");
INSERT INTO amo_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Na Bilatus nlanza nani, a tirino sa unite kunan Galiliari. ");
INSERT INTO amo_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Na ayinno adi nmyin tigon Hirudus ari, a turung Yesu ku udu kitin Hirudus, ama litine wang wadin Urshalima nayiri ane. ");
INSERT INTO amo_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Na Hirudus in yene Yesu ku, ayi poo ghe, bara na dandauna nin su nworu a yeneghe. Ana lanza ubeleng me amini din piziru ayeneghe asu imon izikiki. ");
INSERT INTO amo_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Hirudus tirino Yesu ku uliru gbardang, amma na Yesu nkawa ghe imon ba. ");
INSERT INTO amo_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Adidya na priest nin na nan ninyerte fita, nin tinana nayi nvuruzughe nliru. ");
INSERT INTO amo_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Hirudus nin nasoja me zognzo ghe, I kuru isu ghe liyong, inin shonghe imon icine, inin kurtuno Yesu ku udu kitin Bilatus. ");
INSERT INTO amo_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Hirudus nin Bilatus waso adondon nati lilone (amma iwa tu iyita anan nivira nati). ");
INSERT INTO amo_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Bilatus tunna ayicila udya na priest, nin nagoo a ligozi nanite kiti kirum, ");
INSERT INTO amo_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","a woro nani, “Ida nayi unit ulele nafo unit ulenge na adin cinu nin nait nanzang, yeneng, meng, nbun minere ntiroghe uliru, na nse ghe nin kulapi kitene nile imon na idi uvuruzughe mun ba. ");
INSERT INTO amo_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Baba, sa ame Hirudus wang, a kurtunghe udak kiti bite, yenen, na asu imong imon ilenge na iduru nworu aku ba. ");
INSERT INTO amo_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Bara nani mma tighe aneo, nsunghe.” ");
INSERT INTO amo_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Amma uwa so Bilatus ju gbas a nutun a Yahudawe ku kucin kurum kilari licin kubin idi. ");
INSERT INTO amo_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Vat mine jartiza kang, I woro, “Caan nin nit ulele, I nutun nari Barabas ku!” ");
INSERT INTO amo_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas unitari wadi ulenge na iwa ceo ghe licin kitene kulapi nsali dortu nliru tigo kipine nin katwa likiri. ");
INSERT INTO amo_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Bilatus kuru asu nani uliru tutung, nin su nworu a sun Yesu ku. ");
INSERT INTO amo_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ijaritiza I woro, “Na ikotinghe kuca, na ikotinghe kuca.” ");
INSERT INTO amo_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","A woro nani tutung untat, “Iyanghari, kuyapin kulapiari unit ulele nati? Na meng see ghe nin kulapi kongo na batin ushara nkul liti me ba. Bara nani, asa nkpizoghe mma sunghe.” ");
INSERT INTO amo_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Amma ileo ubun njartiza kang, npiru nworu ikotinghe kucha. Tiwui mine ta Bilatus yinna. ");
INSERT INTO amo_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Bilatus yinna nani nin kuculu mine. ");
INSERT INTO amo_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","A nutuno ulenge na inung tirino nworu inutun ule na ina ceo kilari licin kitene in fizu nay nanit a umolsu nanit. Amma ana nani Yesu ku nafo usu nibinai mine. ");
INSERT INTO amo_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Na inya ninghe, ikifo umong Simon unit Nkirawani, awa nuzun nan nya ntene, itina ghe kuca ndi kotunue, a dortu Yesu ku. ");
INSERT INTO amo_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Ligozi nanit gbardang, nin nawani ale na iwa di tiyomme wa din dortu ghe. ");
INSERT INTO amo_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","A gbitirno kiti mine, Yesu woro, “Nishonon Urshalima, na iwa gilu meng ku ba, ama gilan atimine nin nono mine. ");
INSERT INTO amo_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Amma yenen, ayire din cinu na ima woru, 'Anan koliari awani are, nin naburi ale na ina maru ba, nin na yazin ale na amazina ba.' ");
INSERT INTO amo_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ima cizunu ubelu na kup, 'Dio nati bite,' a apara, 'Kiro nari.' ");
INSERT INTO amo_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Iwa su ile imone a kuce dutu kushiti, Iyaghari ma se ku wa malu kotu?” ");
INSERT INTO amo_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Iwa yiru among anit naba anan likara linanzang idi molu ligowe ninghe. ");
INSERT INTO amo_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Na iwa dak kiti kanga na idin yicu akankan nati, kitenere iwa kotunghe kucaa ligowe nin nanan likara linanzang, unit urum ncara uline a unan be ncara ngule me. ");
INSERT INTO amo_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Yesu woro, “Ucif, wesse nani alapi mine, bara na iyiru imon ile na idin sue ba.” I tunna idinja timo, I koso imon me. ");
INSERT INTO amo_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Anite yissina in yenju ghe a imung ago mina yita nsughe liyong, idin su, “Ana tucu among. Na atuca litine, andi amere Kristi Kutelle, unan feruwe.” ");
INSERT INTO amo_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Inung anan likum wang sughe liyong, ida kupo me, ina ghe nmyen migbalala, ");
INSERT INTO amo_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","idin belu, “Andi fere uga na Yahudawe, tucu litife.” ");
INSERT INTO amo_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","I wa su imong inyerte ibana kitene litine, “ULELERE UGO NA YAHUDAWA.” ");
INSERT INTO amo_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Unit urum nan nya na nan likara linanzanghe na iwa kotunghe kuce, belinghe lifai, a woro, “Na fere Kristeba? Tucu litife umunu arik ku.” ");
INSERT INTO amo_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ame unan be kawa, a kwada ghe a woro, “Na udin lanzu fiu Kutelle ba, bara na ushara fe di urume nin ghe? ");
INSERT INTO amo_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Kiti bite udi dert, arik din seru nduk katwa bitari. Na unit ulele na su imonmong inanzang ba.” ");
INSERT INTO amo_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","A kpinaku, a woro, “Yesu, lizino nin mi asa upira kipin tigo fe.” ");
INSERT INTO amo_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesu woroghe, “Kidegenere nbelin fi, uma yitu nin mi kipin tigo nighe.” ");
INSERT INTO amo_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Kube da susut nin nikoro kutocin, nsirti tursu kutyine vat uduru ikoro kutir ");
INSERT INTO amo_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","na nkanang nwii nmala. Kusakala kutyi nlira jarta kyitik kitene utolu kadas. ");
INSERT INTO amo_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Yesu jarta nin liwui kang ayila, a woro “Ucif, nan nya nacara fere nnakpa ulai ning.” Na a belle nani, aku. ");
INSERT INTO amo_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Na udya na nan likum akalt likure in yene imon ile isu, azazina Kutelle, a woro, “Kidegenere, ulele unan katwa kacineari nadi.” ");
INSERT INTO amo_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Na vat ligozie na iwa dak ida ti iyizi nba nimon ile na isu yene imon ile na ise, ikpilla idin fo igiri. ");
INSERT INTO amo_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Vat na nan yiru me, nin na wani ale na ina dofin ghe unuzun Galili, yissina pit, idin yenju ni leli imone. ");
INSERT INTO amo_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Umong unit wa diku unan lissan Yusufu, nan nya na nan kpiluzu, unit ugegeme nin katwa kacine ");
INSERT INTO amo_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","(na awa yinin nin kpiluzue nin lidu longo na isu ba), unit in Arimathiya, nkan kipin na Yahudawa, ulenge na awa di nca kipin tigoo Kutelle. ");
INSERT INTO amo_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Unit une do kitin Bilatus, tirino kidowon Yesu. ");
INSERT INTO amo_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","A toltuno kinin, a jinkpilo nin malti ulau, adi nonko nan nya kissek na ina sarsu nan nya kutala, kikanga na isa nonko umong ku ba. ");
INSERT INTO amo_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Uwui nshiriari wadi, Assabath wa dak susut npiru. ");
INSERT INTO amo_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Awane na iwa dak nanghe unuzun Galili, dofino kidung, iyene kissekke iyene imusun nonkue kidowe non. ");
INSERT INTO amo_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","I kpilla, ida shirya nnuf kunya min tintu. Lirin Nasabbath ishino nafo ubellin duke. ");
INSERT INTO amo_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Lirilin lizunu nayiri kuzor nin kwui dinding, ida kiti kissekke, ida nin nuffe na ishirya. ");
INSERT INTO amo_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ise iturno litala ntursu kissekke. ");
INSERT INTO amo_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","I pira nan nya, ama na iyene kidowo Ncikilari Yesu ba. ");
INSERT INTO amo_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ita buu nan nya nkpilizu mine kitene ni leli imone, I tunna, anit naba yissina kupo mine nin nimon ibo in baltu. ");
INSERT INTO amo_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Na awane tiu nkifo nani I tunnu ati mine kutyin, I woro na wane, “Iyiziari idin piziru nnan lai nan nya na nan kue? ");
INSERT INTO amo_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Na adi kikane ba, ama a fila! Lizinon ulirue na awa belu minu adutun Galili, ");
INSERT INTO amo_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","asa a woro Gono nnit uma nakpu ghe nacara na nan nalapi gbas inan kotunghe kucar lirin lin tatte a fita tutung.” ");
INSERT INTO amo_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Awane lizino iliru me, ");
INSERT INTO amo_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ikpilla unuzu kissekke I belle ngissin kuzakure ubeleng ni leli imone vat umunu ngissin nanite. ");
INSERT INTO amo_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Maryamu Magdaliya, Yuwana, nin Maryamu unan Yakubu, a ngissin na wane na iwa di ligowe di belin nono katwawe ile imone. ");
INSERT INTO amo_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ka kadura so nono katwa we nafo uliru uhem, na iyinna nin liru na wane ba. ");
INSERT INTO amo_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Vat nani Bitrus fita, nin cum a do kiti kissekke, a tumuno adin yenju nan nye, ayene kumalti kubowe non likot. Bitrus nya ado ngame, adin kpilizu kitene nimon ile na ise. ");
INSERT INTO amo_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Anit naba nan nya mine wa din cin libo ucin du kagbiri Imwasu. Kanga na npite wa durun timel akut kutocin unuzun Urshalima. ");
INSERT INTO amo_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","I wa din belu nbeleng nimon ile na ina se. ");
INSERT INTO amo_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","I wa din lirue icin cine a iyita ntiru nati mine ligowe Yesu da duru nani a tunna ncine nanghinu. ");
INSERT INTO amo_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Amma iyizi mine wa turdun na iyininghe ba. ");
INSERT INTO amo_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Yesu woro nani, “Iyaghari idin belue nabe icin cina?” Iyissina kitene nin tecu timuro. ");
INSERT INTO amo_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Unit urum mine, unan lissan, Kilyobas, kawa ghe, “Fere cas in Urshalima ulenge na nyiru imon ilenge na ina se nayiri alele ba?” ");
INSERT INTO amo_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesu woro nani, “Iyeme imon?” Ikawa ghe, “Imon nbeleng Yesu Nnazareth, na awa di unan liru nin nuu Kutelle, awa di nin likara katwa a uliru nbun Kutelle a anit. ");
INSERT INTO amo_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Na udya na prieste nin na go na iwa nakpa ghe aso nca nkul I kotunghe kuca aku. ");
INSERT INTO amo_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ti wa cisso ayi nworu amere ma tucu anan Israila. Nanere, kinal ni lele vat, kitimone lin tat na ile imone na se. ");
INSERT INTO amo_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nani tutung, among awani nan nya bite nna nari tissina, ini do kissekke nin kwui dinding. ");
INSERT INTO amo_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Na iyene kidowo me ba, inani kpilla, ina ni nworo inin ta amoron wui nono kadura Kutelle nworo nani adi nin lai. ");
INSERT INTO amo_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Among anit na idi ligowe nan ghiruk ndo kiti kissekke, ina nin se kinin nafo ubellu na wane. Amma na iyene ghe ba.” ");
INSERT INTO amo_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Yesu woro nani, “Anung na nilime ni lalang idi shankalong in yinnu nin vat nimon unan liru nin nuu Kutelle na bellin! ");
INSERT INTO amo_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Udi gbas nworu Kristi nco nan nya nile imone, a piru nan nyan ngongong me?” ");
INSERT INTO amo_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ucizunu kitin Musa udu anan liru nin nuu Kutelle vat, Yesu wa belin nani imon ile na idi litine nan nya nliru ntucue. ");
INSERT INTO amo_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Na ida susut nin kagbire, na iwa cinu ucin due, Yesu ta nofo ama katu ulsun. ");
INSERT INTO amo_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","I masa ghe nworu, “Aso nanghinu, bara kuleleng wadi ku mal dak, kiti cizna usirui.” Yesu pira a so nan ghinu. ");
INSERT INTO amo_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Iwa se nani, na awa so nanghinu ima li imonli, ayauna ufungale, ata nkoli ku, a pucco unin, a na nani unin. ");
INSERT INTO amo_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Iyizi mine tunna ipuno, inin yininghe, atunna a wulu niyizi mine. ");
INSERT INTO amo_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Itunna nbelu nati mine, “Na nibinai bite npya nan nya bite ba, kube na tini cina ninghe libowe, na ani bele nari uliru ntueue?” ");
INSERT INTO amo_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Iwa tunun ifita nan nya kube, I kpilla udu Urshalima. Idi se kuzakure nzuro ligowe, nan na lenge na Iwa di nanghinu, ");
INSERT INTO amo_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","I woro, “Kidigenere, Cikilare na fita, amini na durso litina kitin Simon.” ");
INSERT INTO amo_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Inung tunna I belle imon ile na ise libowe, nin nimusun dursue na ani pucco nani ufungule. ");
INSERT INTO amo_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Na iwadi nbelu nileli imone, Yesu da ada yissina kyitik mine, a woro nani, “Lissosin limang sa nanghinu.” ");
INSERT INTO amo_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Iwa ketize fiu kifo nani, iyenje nafo inung yene mmoli. ");
INSERT INTO amo_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Yesu woro nani, “Iyaghari nta nibinai mine nfita? Iyaghari nta matiru tiru din fitiyu nibinai mine? ");
INSERT INTO amo_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Yeneng acara nighe nin nabune, mere nin liti nighe. Dudoi uyene. Bara na mmoli di nin kidowo nin naku ba, nafo na iyene men dimun.” ");
INSERT INTO amo_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Na awa belin nani, a durso nani acara me nin nabunue. ");
INSERT INTO amo_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","A I dutu nan nyan salin yinnu a liburi libo, a ukpiliza, Yesu woro nani, “I di nin nimonmong nlia?” ");
INSERT INTO amo_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Inaghe kugir fibo nwui. ");
INSERT INTO amo_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yesu sere fining, a leo finin nbun mine. ");
INSERT INTO amo_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","A woro nani, “Kube na nwa di nanghinu, nwa woro minu nenge vat nimon ile na ina nyertin liti nighe nan nya ndukan Musa nin na nan liru nin nuu Kutelle a Uzabura vat ma kulu gbas.” ");
INSERT INTO amo_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","A tunna apuno nibinai mine, inan yinno ulirun ntucue. ");
INSERT INTO amo_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","A woro nani, “Tutung ina nyertin nworo Kriste ba niu, anin fita tutung nan nyan ku lirin lin tat. ");
INSERT INTO amo_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Uwazi nsunu nalapi nin shawu nin kulapi isu unin nan nya ligang in yie vat, icizin in Urshalima. ");
INSERT INTO amo_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Anung iyizi nbari ni lenge imone. ");
INSERT INTO amo_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Yeneng, mma tu nin ciu nnuu ncifnighe nati mine. Amma cican nan nya kipine, sei ikulo minu nin likara unuzu kitine kani.” ");
INSERT INTO amo_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yesu tunna na nuzu nan ghinu udu susut nin Baithanya. A ghantina acara me, ata nani nkoli. ");
INSERT INTO amo_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Uwa se nani, kube na awa di nan nya nti nani nkolie, asuna nani iyira ghe ughanu udu kitene Kutella. ");
INSERT INTO amo_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Isu ghe usajada, inin kpilla udu Urshalima nin nabari abo kang. ");
INSERT INTO amo_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Iwa so nan nya kutyi nlira ko lome liyiri, idin tizzu Kutelle nkoli. ");
INSERT INTO amo_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Uworsu ucizine Ligbulang wadiku, Ligbulanghe wadi nin Kutelle, a Ligbulanghe Kutelleri. ");
INSERT INTO amo_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ulengene, Ligbulanhe, wadi nin Kutelle uworsu ucizine. ");
INSERT INTO amo_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Imon vat iwa kye unuzu mere, nin dirume na imon irum duku ilenge na ina kye sa ame ba. ");
INSERT INTO amo_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Nanya mere ulai di, uleli ulaiye tutun unere nkanang nanit asuren vat. ");
INSERT INTO amo_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nkanaghe na nuzu kanang nanya nsirti, a na nsirte na kata likara mining ba. ");
INSERT INTO amo_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Umong unit wa duku na iwa tughe unuzu kiti Kutelle, na lissame wadi Yuhana. ");
INSERT INTO amo_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Awa dak nafo unan lin musu niyizi nba nbellen nkananghe, bara vat nan yinna nnuzu me. ");
INSERT INTO amo_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Na Yuhanere wadi nkanaghe ba, awa dak anan belle ubelle kanaghere. ");
INSERT INTO amo_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Mininghere nkanang kidegen mongo na miwa cinu ucin dak nanya in yii mi durso ko uyeme unit. ");
INSERT INTO amo_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Awadi nanya inyee, unin uyee iwa kye unuzu mere, ana uyee wa yinin ninghe ba. ");
INSERT INTO amo_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Awadak kiti nanit me, na anit me wa sereghe ba. ");
INSERT INTO amo_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Nani, ngbardang na lenge na iwa serughe, alenge na iwa yining nin lissa me, kitimine awa yining nani iso nono Kutelle. ");
INSERT INTO amo_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Alenge na iwa macu nani, na kumat nmii ba, na nin su kidowo ba, a na nin su nnit ba, iwa macu nani nane nin su Kutelleri. ");
INSERT INTO amo_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Nene, Ligbulanghe wa so kidowo, liso nanya bite. Tina yene ngongon me, nafo ngongon lenge na ana nuzu kitin Ncif, awa kulun cek nin bollu Kutelle a kidegen me. ");
INSERT INTO amo_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yuhana wa su uliru litime a ghatina liwui kang aworo, “Amere ulenge na nwa woro, 'Ulenge na adin cinu kidun nighe, kamin meng, ame cikilari nighari. ");
INSERT INTO amo_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Bara unuzun kulnu me, vat tina seru ubolu kitine nbollu Kutelle. ");
INSERT INTO amo_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Bara iwa ni uduke kitin Musa, ubolu nin kidegen wa dak unuzu kitin Yesu Kristi. ");
INSERT INTO amo_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Na umon na yene Kutelle nkon kubi ba. Ame unit urumari cas, ame litime Kutelle, ulenge na adi figirin Ncife, amere nati iyininghe. ");
INSERT INTO amo_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ushadan Yuhanari ulele, kube na a Yahudawa wa tuu nin na Priest nin na Leviyawa id tiringhe, “ Fe ghari?” ");
INSERT INTO amo_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ayinna na asu mayardang ba, akawa nani “na mere Kristi ba.” ");
INSERT INTO amo_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","I tiringhe, “ Anife ghari? Fe Iliya?” Aworo, “ Na meng amere ba” Iworo, fe unan liru nin nuu Kutelle?” Akawa naworo “Nanere ba.” ");
INSERT INTO amo_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Itunna iworoghe, “feghari, bara tinan belle alenge na i to nari? Uma woro nari fe ghari? ");
INSERT INTO amo_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Aworo, 'Mere liwui longo na lidi kuculu nanya ntene: kyelen ucin mine nanya cikilari dert,' Nafo ubellu Ishaya unan liru nin nu Kutelle.” ");
INSERT INTO amo_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nene among duku na a Farisawa wa tu nani. I tiringhe, inin woroghe, ");
INSERT INTO amo_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“ Iyaghari ta udin shintizunu anit nmyen andi na fe Kristi, sa Iliya, sa unan liru nin nu Kutelle ba?” ");
INSERT INTO amo_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yuhana kawa nani aworo, “Meng din shintizunu nani nmyen. Vat nin nani, nanya mine umong yissin ku ulenge na anung yirughe ba. ");
INSERT INTO amo_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Amere ulenge na ama dak kidung nighe. Na meng batin nbunku ti na kpatak me ba.” ");
INSERT INTO amo_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Iwa su ilenge imone in Baitanya nleli uwulun urdun, kikanga na Yuhana wa din shintu nanite ku nmyen. ");
INSERT INTO amo_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ukurtunun nkwuiye Yuhana yene Yesu ku ucin dak kitime aworo, “Yeneng, Kukam Kutelle kongo na kuma yiru kulapin nyee! ");
INSERT INTO amo_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Amere ulenge na nna bellin minu, 'ulenge na adin cinu kidung nighe katin meng ku, bara awa yita ku ameng dutu.' ");
INSERT INTO amo_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Na meng yininghe ba, una so nani inan dursoghe kitin nonon Israila unnare meng na dak ndin shintu anit nmyen.” ");
INSERT INTO amo_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yuhane wa ti ushaida, “Nwa yene uruhu din tolsu unuzu kitene kani nafo kuwulung, uda lwa kiteneme. ");
INSERT INTO amo_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Na nwa yiningghe ba, ame ulenge na ana tuyi nshintu anite nmyene na woroi, 'kitenen nlenge na uma yenu uruhu ntolo uso litime, amere ulenge na ama shintu anit nanyan Ruhu ulau.' ");
INSERT INTO amo_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Meng yene, nkuru nna ushaida ulengene Usaun Kutelleari.” ");
INSERT INTO amo_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Tutung, ukurtunun kwui, na Yuhana wa yisin ligowe nin nanan katwa me naba, ");
INSERT INTO amo_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","iyene Yesu ku adin cin, Yuhana woro, Yenen, uleliye Kuzara Kutelleari!” ");
INSERT INTO amo_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Anan katwa we naba wa lanza Yuhana ku din bellu nani, idofino Yesu ku. ");
INSERT INTO amo_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu tunna a gitirno ayene idin dortughe a woro nani, “iyaghari idin nin suwe?” I kawaghe, “Rabbi (Unnare 'unan dursuzu niyerte), ussosin nweri?” ");
INSERT INTO amo_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Aworo nani, “dan ida yene.” ida ida yene kite na assosin ku; iso ligowe nanghe lilone, bara kubi nikoro kulidi wa malu uti. ");
INSERT INTO amo_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Unwasamme nanya nan wabe na iwa lanza Yuhane din liru a tunna a dofino Yesu ku, Andirawusari wadi, gwanan Simon Bitrus. ");
INSERT INTO amo_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","A wa tu ase gwana me Simon aworoghe. “Tisse unan tuce” (Na ukpiliuwere 'Kristi'). ");
INSERT INTO amo_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ada nighe kitin Yesu, Yesu yenjenghe, aworo, “fe Simon, usaun Yuhana. Ima yiccu fi Kefas” (ukpiliuwe unnere 'Bitrus). ");
INSERT INTO amo_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ukurtunun kuiye, Yesu wa di nin su ado Ugalili, ase Filibus ku a woroghe, “Dofini.” ");
INSERT INTO amo_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filibus wa nuzu Nbaitsada, kipin Andirawus nin Bitrus. ");
INSERT INTO amo_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filibus se Nataniyel ku aworoghe, “ Ulenge na Musa nanya nduka nin nanan liru nin nu Kutelle na yertu ubellen me tiseghe, Yesu, Usaun Yusufu kunan Nazaret.” ");
INSERT INTO amo_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nataniyel woroghe, “Imonmong icine wasa inuzu Nnazareta?” Filibus woroghe, “da uda yene.” ");
INSERT INTO amo_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu yene Nataniyel ku din cinu udak kitime a lirina litime, “Yeneng, kunan Israila kidegen, ulenge na adinin kinu ba!” ");
INSERT INTO amo_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniyel woroghe, fe ta inyizari uyinni?” Yesu kawaghe aworo, kube na inin sossino litino kuca napau a Filibus dutu sa uyicilu fi, Nni yenefi.” ");
INSERT INTO amo_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Nataniyel kawa, “Rabbi, fe Usaun Kutelleari! Fere Ugo nan Israila!” ");
INSERT INTO amo_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesu kawaghe a woro, Bara na nworo fi. 'Nni yene fi litino kuca napau,' fe uni in yinna? Uma yenu imon nzikpu kibinai ididya na ikatin ilengene.” ");
INSERT INTO amo_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Yisa woro, “Ndin bellu minu kidegen, Ima yennu kitene kani npuno, nono kadura Kutelle din ghanju itoluso kitene Nsaun Nnit.” ");
INSERT INTO amo_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Kimal nayiri atat, uteru nilumgma wadi in Kan'ana un Galili, unan Yesu wa yita ku. ");
INSERT INTO amo_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ame Yesu wang iwa nighe uyicilue, nin na nan katwa me, udu kiti nilugme. ");
INSERT INTO amo_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Na nmyen narauwe ndari, unan Yesu woroghe, “Na idi nin myen narau ba.” ");
INSERT INTO amo_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesu kawaghe “ Uwani, inyaghari nmyen nin ku? Na kubi nighe nsa da ba.” ");
INSERT INTO amo_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Unene woro nono katwa, “Vat nimon ilenge na abelin minu isu, sun inin.” ");
INSERT INTO amo_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Asul natala kutocin wa duku alenge na ko kome din li ayangi likalt udu akalt aba na Ayahudawa wa suzu katwa mun kuubi ntanda nwesuzu. ");
INSERT INTO amo_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu woro nani, “Kulson asulun nmyene nin nmyen.” I tunna i kulso anin gbem gbem. ");
INSERT INTO amo_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","A woro anan katwa we “tyan, iyaun idi ni cin buke.” Nanaere iwasu, itya idi nighe. ");
INSERT INTO amo_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Cin buke ciro nmyene ase miso nmyen narau, na ame yinno kikanga na minuzu ku ba (acinne na iwa tya nmyene wa yiru). Cin buke tunna ayicila kwanyane. ");
INSERT INTO amo_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","aworoghe, “kagha asa atu anutuno nmyen narau micine ana anite, iwa shito anin nutuno mi nangzaghe. Fe uni nna nyeshe micine udak ko kube.” ");
INSERT INTO amo_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ileli imon izikike in Kan'ana un Galili wa di ncizunuari nanya nimon izikiki ilenge na Yesu na suzu, awa durso Ngongong me, anan katwa me ani wa yining ningghe. ");
INSERT INTO amo_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Kimal nani, Yesu wa do Kafarnhum, ame unene, nuawne, nin nanan katwa me, kikane iwa di so ku nanya nayiri bat. ");
INSERT INTO amo_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Kubi in paska na Yahudawa wa dak susut, Yesu uni wa do Urshalima. ");
INSERT INTO amo_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Amini wa dase anit din lessu nina, akam, nan nawulun nanya kutii nlire. Anan kusere ni kurfun wa duku wang. ");
INSERT INTO amo_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Amini wa piu lishon a ko nani vat unuzu udas nanya kutii nlire, umunu akame nan nine. A gutuna anan kusere nikurfughe. Ikurfughe nan na tebule a turzuno kutyen. ");
INSERT INTO amo_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Aworo anan lessu na bilane, “kalan ilenge imone kikane. Na iwa ceo kilari Ncif nin kiti kujauna ba.” ");
INSERT INTO amo_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Anan katwa me lizino ina yertin, “Ufo liti ngafe ma wulttunui.” ");
INSERT INTO amo_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ayahudawa tardaghe, i woro, “Alama ayapinari uma dursu nari bara na udin su ilenge imone?” ");
INSERT INTO amo_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Yesu kawa aworo, “Musuzun kutii nlira kone, nanya nayri atat nma fiwu kunin.” ");
INSERT INTO amo_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ayahudawa woro, “Ina ti akus akut anasari ninkutocin nkye kutii nlira kone, fe uni ma kye kunin nanya nayiri atata?” ");
INSERT INTO amo_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Nani ame wadin bellu nin kutii nlira litimere. ");
INSERT INTO amo_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Bara nin bun iwa fyaghe nanya nanan kule, anan katwa me lizino iwa bellin nani, i yinna nin liru Kutelle a unin ulire na Yesu wa bellin. ");
INSERT INTO amo_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Nayire na awadin Urshalima kubin paska, nayirin idi, gbardang wa yinnin nin lissame, na iwa yenje imon izikiki ilenge na awa su. ");
INSERT INTO amo_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Vat nin nani, na Yesu wa yinnin ni ghinu ba, bara na ayiru anit asurne vat. ");
INSERT INTO amo_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Na ame dinin su imong bellinghe imonmon litin nnit usurne ba. Ame litime yiru imong ilenge na idi nnit usurne. ");
INSERT INTO amo_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Nkon ku Farisawa wa duku lissame Nikodimus, awa di nin tigo nanya kudaru na Yahudawa. ");
INSERT INTO amo_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Unit une wa dak kitin Yesu nin kitik a woroghe, “Rabbi, tiyiru fe unan dursuzu nanitari unuzu kiti Kutelle, bara na umong wasa asu ukama nilenge imone na udin suze se dei Kutelle di ninghe.” ");
INSERT INTO amo_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesu kawaghe aworo, “kidegenere andi na imara unit tutung ba, na awasa ayene kipin tigo Kutelle ba.” ");
INSERT INTO amo_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimu woroghe, “Ima kuru imaru unit inyizari na amal ti kukune? Na awasa apira liburi nna me imaraghe unba ba, awasa ayinnua?” ");
INSERT INTO amo_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu kawa, aworo, “Kidegenere ndin bellu minu, andi na imara unit nanya nmyen nin Ruhu ba, na awasa apira nanya kipin tigo Kutelle ba.” ");
INSERT INTO amo_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Imong ilenge na ina maru nanya kidowo, kidowari, a ilenge na ina maru nanya Ruhu, uruhuari. ");
INSERT INTO amo_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Na iwase uzikpu bara na nbellin minu, 'uso gbas ikuru imacu minu tutung.' ");
INSERT INTO amo_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ufunu din ko udu kusari ko na unya udue. Asa ilanza uduwe, nani na iyiru kiti kanga na unuzu ku sa kiti kanga na udin cinu udue ba. Nanere wang unit ulenge na imaraghe nanyan Ruhu” ");
INSERT INTO amo_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodimu kawa, aworo, “Inyizari imon ilele ma yitu nani?” ");
INSERT INTO amo_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yesu kawaghe, aworo, “Fe unan dursuzu nanan Israila, vat nani, na uyinno ilenge imone ba? ");
INSERT INTO amo_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Kidegenere, tidin belu ilenge imon nati yiru, ti din belu ilenge na tiyene, vat nani na anughe nsere uliru bite ba. ");
INSERT INTO amo_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Asa nbelin minu ubelen nimon nle uye a na anung yinna mun ba, ima yinnu inyizari nwa bellin ubelen nimon kitene kutelle? ");
INSERT INTO amo_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Na umong nsa ghana kitene kani ba, se dei ulenge na ana tolu unzu kitene kani. ");
INSERT INTO amo_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Nafo na Musa wa ghantin fiyii nanya ntene, nanere wang uso gbas i ghantin Usaun Nnit kitene. ");
INSERT INTO amo_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Bara vat na lenge na iyinna ninghe nan se ulai unsali ligang. ");
INSERT INTO amo_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Bara Kutelle nati usu inyii ulele, amini na ni gono kinin kirum cas, vat nlenge na ayinna ninghe, na ama nanu ba, ama se ulai un saligang. ");
INSERT INTO amo_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Na Kutelle natu Gono me nanya nyie ada molu uyie ba, nani uyie nan se utucu unuzume. ");
INSERT INTO amo_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ulenge na ayinna ninghe na ima molughe ba. Ulenge na ayinna ninghe ba imal ciughe nca nkul bara na ayinna nin lissan Gono Kutelle ba. ");
INSERT INTO amo_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ILenge imonere finu nsharawe, nworu nkanang na dak nanya inyii, anit ani nadi nin su nnsirti a na nkannanghe ba bara na adadumine an sirtiari. ");
INSERT INTO amo_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Bara vat nlenge na adin su adadu nsirti din su ivira tutung na ama dak kiti nkanangghe ba bara katwa me wa nuzu kanang. ");
INSERT INTO amo_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Vat nani, ulenge na adin su kidegen ma dak kitin kanang adadu me nan yita fang nyenju tutung inin damun ubun Kutelle unuzu nyinnu nin Kutelle.” ");
INSERT INTO amo_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Kimal nani, Yesu nin nono katwa me wa nya udu nmyin Yahudiya. Awa di dandaun kikane ligowe nanghinu acin shinto anit nmyen. ");
INSERT INTO amo_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Yuhana tutung wadi nshitu nanite in Ayinon kupo in Salim bara nmyen wadiku gbardang. Anit wa dasu kitime a shinto nani nmyen, ");
INSERT INTO amo_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Na iwa di isa tursu Yuhana ku kilari licine ba. ");
INSERT INTO amo_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Mayardang fita kiyetik nnono katwa in Yuhana nin nkon ku Yahudawaaa in belen nwesu ulau. ");
INSERT INTO amo_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","I do kiti in Yuhana i woroghe, “Unan dursuzu niyerte, ulenge na ani yita ninfi nleli ugau kurawan urdunghe, ame ulenge na uni su uliru kitene me, yene adin shintu anit nmyen, tutung vat din cinu kiti me.” ");
INSERT INTO amo_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yuhana kawa nani, “Na unit wasa a sere imonmong ba, andi na inaghe unuzu kiti Kutelle ba. ");
INSERT INTO amo_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Anung nin nati mine wasa ileoyi unanba, nlire na belle. 'Na meghari Kriste ba' nna woro, 'ina tuyi nbun mere.' ");
INSERT INTO amo_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ulenge na adinin wani upese, unan kifu kudanari. Nengene udo tiyom, ulenge na ayisina alanza, asa asu liburi libo kang bara liwui kwanyane. Nengene liburi libo nin nkulo. ");
INSERT INTO amo_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Uma so gbas ame kpizinku, meng cazin. ");
INSERT INTO amo_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ulenge na ana dak unuzu kitene, di kinen vat. Ulenge na ana nuzu kutyin kunan kutyinari akuru adin belu nimon kutyin. Ulenge na ana nuzu kitene kani di kitenen koyan. ");
INSERT INTO amo_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Adin su uliru nimon ilenge na ana yene akuru alanza, nani na umon wasa asere uliru me ba. ");
INSERT INTO amo_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ulenge na asere uliru me ayinna Kutelle kidegenare. ");
INSERT INTO amo_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ame ulenge na Kutelle na tughe din bellu uliru Kutelle. Bara na adin guccu uruhu me anin na unin ba. ");
INSERT INTO amo_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ucife dinin su Nsaune, amini nani imon vat nacara me. ");
INSERT INTO amo_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ulenge na ayinna nin Saune di nin lai nsali ligang, ame ulenge na ayinna nin Saune ba, ama yenu ulai ba, nani tinana nayi Kutelle sossin litime. ");
INSERT INTO amo_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Na Yesu wa yinin a Farisawa nmal lanzu ame din sesu nnono katwa gbardan a ashinto nani nmyen, ikata nin Yuhana, ");
INSERT INTO amo_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(kona ame Yesu nin litimaere wa shintu anite nmyene ba, non katwa mere wa suzu), ");
INSERT INTO amo_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","awa sun u Yahudiya a nya udu u Galili. ");
INSERT INTO amo_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Uni wasoghe gbas akata nanya in Samariya. ");
INSERT INTO amo_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Amini wa dak nkan kipin in Samariye, idin yiccu kinin Sacer, susut nin kunen kongo na Yakub wani usaune Yusufu. ");
INSERT INTO amo_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Kuwu nmyen Yakubu wadi kite, Yesu wa dira nin cin me a so kupo kuwe. Uwui wadi umal dak ati. ");
INSERT INTO amo_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Umong uwanin Samariya da nda tiwu nmyen, Yesu woroghe, “Filli nmyen nsono.” ");
INSERT INTO amo_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Bara nono katwa me wa do nseru nimoli nanya kipin. ");
INSERT INTO amo_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Uwana Samariya tunna aworoghe, “Inyizari nta fe Kuyahudawa, udin tiru menku, uwani Nasamariyawa nmyen sonu?” Bara na Ayahudawa din su ligo nan Nasamariyawa ba. ");
INSERT INTO amo_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Yesu kwaghe aworo, “Ndaeo uyiru Kutelle nin lenge na aworofi filli nmyen nsonu fe wa tiringhe anifi nmyen nlai.” ");
INSERT INTO amo_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Uwane kawaghe, “Cikilari, na udinin guga ntiweba, a kuwu nmyene kongo cancom, fe ma se nmyen nlaiye nweri? ");
INSERT INTO amo_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Fe katin Ucif bite ku Yakube, na ana ni nari kuwe ame wang na soku umunu nono nin nina me?” ");
INSERT INTO amo_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu kawaghe aworo, “vat nnit ulenge na asono mongo nmyene ama kuru a lanza ukotu nayi tutung, ");
INSERT INTO amo_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","nani vat ulenge na asono nmyen mongo na meng manighe na aba kuru alanza ukotu nayi tutung ba. Nworu nani, nmyene na meng ma nanighe maso nanya mye figunanag nmyen na mima ghanju udu ulai sa ligan. ");
INSERT INTO amo_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Uwani une woroghe, “Cikilari, nai nmyen mono bara nwa kuru nlaza ukotu nayi nda tutung nda tiya nmyen.” ");
INSERT INTO amo_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu woroghe, “Can udi yicila ulesfe isa kikane ligowe.” ");
INSERT INTO amo_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Uwane kawa aworghe, “Na ndinin les ba,”Yesu kawaghe, “Ubele dert, 'na ndi nin les ba,' ");
INSERT INTO amo_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","bara umal ti ales ataun, a ame ulenge na udi ninghe nene na ulesfere ba! Nanya nle ulire na ubelle kidegenere!” ");
INSERT INTO amo_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Uwane woroghe, “Cikilari, in yinno fe unan liru nin nu Kutelle ari. ");
INSERT INTO amo_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","A Cifbit na suzu usujada likup longone, anung ani din su Urushalimari kiti kanga na ki do tissu usujada ku.” ");
INSERT INTO amo_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yisa kawaghe, “Uwani, yinna nin mi, kubi din cinnu kongo na ima su Ucif usujada na likup longone ba sa in Urshalima ba. ");
INSERT INTO amo_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Anughe din su ulenge na iyirughe ba usajada. Arik din su ulenge na tiyirughari usujada, bara utucu nnuzu kiti na Yahudawari. ");
INSERT INTO amo_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Vat nani, kubi din cinnu, kuda nene wang, na anan sujada kidegene ma zazinu Ucife nanya Nruhu nin kidegen, bara Ucif di piziru nimus nanit anere isughe usujada. ");
INSERT INTO amo_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Kutelle Uruhuari, inung anit alenge na idin sughe usujada ma sughe nanya Ruhu nin kidegen.” ");
INSERT INTO amo_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Uwane woroghe, “Meng yiru unan tuccu din cinu” (ulenge na idin yicughe Kristi). Asa a da, ama punu nari imone vat.” ");
INSERT INTO amo_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu woroghe, “Menghe, na ndin lire, mere ame” ");
INSERT INTO amo_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Nkoni kubere nono katwa me kpilla. I yita nkpilu nibinayi mine inyizari adin liru nin wani, vat nani na umong nworoghe inyaghari udin pizure? Sa, “In yaghari nta udin liru ninghe?” ");
INSERT INTO amo_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Uwane tunna a suna lidul nmyene, a kpilla ucin du na kipine, a woro nanite, ");
INSERT INTO amo_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Dan, ida yene unit ulenge na a belli vat nimon ilenge na nna mosu. Na amere ma yitu Kriste ba, sa amere?” ");
INSERT INTO amo_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Inuzu nanya kipine, ida kitime. ");
INSERT INTO amo_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Nanya kube, nono katwa me sughe cikusu, I woro “Unan dursuzu niyerti, leo imonmon.” ");
INSERT INTO amo_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ana woro nani, “Ndi nin nimonli na nmal lii ilenge na anung yiru mun ba.” ");
INSERT INTO amo_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Nono katwawe tunna tiru nati mine, “Sa umong da naghe imon nliari?” ");
INSERT INTO amo_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Yesu woro nani, “Imonli nighe innare nsu katwa ilenge na ana tuyi, in malu kanin tutun. ");
INSERT INTO amo_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Na idin su, 'Ngisin tipui tinas cas ugirbi nin dak ba?' Meng ndin bellu minu, fyan iyizi iyene anene, amal yini adin ca ngirbi! ");
INSERT INTO amo_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ame ulenge na adin su ugirbe adin sesu ulada, akuru a pitiro ileo nlai nsa ligang, bara ame ulenge na adin su tibila nin nan girbe na su liburi libo ligowe. ");
INSERT INTO amo_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nanere ubellu une di kidegen, umong din bilsu, a umong su ugirbi. ");
INSERT INTO amo_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Nto minu idi su ugirbi katwa ka na ina su ba. Amonghari nasu katwawe, anung atimine ani npira nanya katwa mine.” ");
INSERT INTO amo_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Gbardang na Samariyawa nanya kipin kane yina ninghe bara uliru nwane, ame ulenge na awa woro, “A belli vat nimon ilenge na nna malusue.” ");
INSERT INTO amo_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kube na a Samariyawe wa dak kitime, iwa sughe kucukusu aso nan ghinu, amini wa ti ayiri aba ku. ");
INSERT INTO amo_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Among gbardang yina bara uliru me. ");
INSERT INTO amo_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Inin belle uwane, tiyina na bara ulirufe cas ba, bara arik nlaza nin nati bite, nene ti yinno ulengenere unan tucu inyee.” ");
INSERT INTO amo_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Kimal nayiri abane, awa sun kikane ucin u G alili. ");
INSERT INTO amo_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Bara ame Yesu litime wa bellin na unan liru nin nu Kutelle di gogon nanya kagbiri me ba. ");
INSERT INTO amo_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Na awa piru u Galili, anan Galile sereghe. Bara iwa yene umone na asu vat in Urshalima kitin buke, inung wang wa do kitin buke. ");
INSERT INTO amo_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Tutung amini wa dak u Kan'ana in Galili, ki kanga na awa kpilya nmyen miso nmyen narauwe. Umong Ugo udya ulenge na usaune wadi nin konu nanya in Kafarnahum. ");
INSERT INTO amo_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Na awa lanza Yesu nmal sunnu u Yahudiya a kpila u Galili, ado kiti Yesu a sughe kucukusu a doffinghe ada shin nin saune, na awa cinu uku. ");
INSERT INTO amo_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Yesu tuna aworoghe, “ Anung anit andi na iyene adu azikiki ba, na ima yinnu ba.” ");
INSERT INTO amo_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ugo une woroghe, “Cikalari dacari a gono nighe dutu sa uku.” ");
INSERT INTO amo_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesu woroghe nenge, “Cang. Usaun fe shino.” Unite yina nin lirue na Yesu nbelleghe, atunna a nyaghe. ");
INSERT INTO amo_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Kube na awadin tole, acinme zuroghe, ibellighe usaune shino. ");
INSERT INTO amo_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","A tunna a tirino nani kube na acizina ushine. I kawaghe. Nleng nin nikoro kuzorari ukone na sughe. ");
INSERT INTO amo_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Uciffe tunna ayinno nin kono kubere Yesu na woroghe, “Usaunfe nshino.” Ame litime nin kilari me vat yinna. ");
INSERT INTO amo_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Imon izikiki in bari ine na Yesu wasu tun na ana sun u Yahudiya udu u Galili. ");
INSERT INTO amo_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kimal ni leli imone, u idi na Yahudawa adi. Yesu nya udu Urshalima. ");
INSERT INTO amo_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","In Urshalime, kupo kibulun na kam, kuli wadiku, kongo na iwa yiccu nin lilem na Yahudawa Baitseda. Kudi nin nitin tolsu nitaun. ");
INSERT INTO amo_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Anan tikonu gbardang wa non nbiu kule, aduu, anan kentu, anan nabunu ayerere na kotuzo. Iwa din ca nbukunun nmyen ne. ");
INSERT INTO amo_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Bara gono kadura Kutelle nkon kubi asa atolo ada a bukurno nmyene, vat nlenge na a yarna upiru nya kule ama se ushinu nanya nkonu me ko uyapinari di. ");
INSERT INTO amo_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Umongunit wa duku ulenge na awa dandaun kitene akus akut atat nin kulir. ");
INSERT INTO amo_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Na Yesu in yeneghe anon kitene, na ayinno nwo unite dandauna linonighe kitene, aworoghe, “Udi nin su ushina?” ");
INSERT INTO amo_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Unan kone woroghe, “Cikilari, na ndi nin mong ba, urika na kubi kongo na ibunkurno nmyene a shintini nanya kule. Asa nmala nin kayiri baat, umong asa a yarni upire,” ");
INSERT INTO amo_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesu woroghe, “Fita uyisin, yauna kupefe, ucinu.” ");
INSERT INTO amo_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Unite tunna ase ushinu mas, ayana ukomime, a tunna ncin. Lilone wadi Asabath tari. ");
INSERT INTO amo_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Adidya na Yahudawa woro nnite na i shino nighe, “Uwui Nasabath tari na iyinin fi uyaun kupye fe ba.” ");
INSERT INTO amo_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Akawa nani, aworo, “Ulenge na a shino ninmi, aworoi, yauna kupye fe unya.” ");
INSERT INTO amo_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","I tiringhe, “Ghari unite na aworofi, 'yauna kupye fe unya?'” ");
INSERT INTO amo_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ame ulenge na iwa shinighe na awa yiru saghari ba, bara Yesu wadi amal nyiu, bara anit wa kilinghe kitene. ");
INSERT INTO amo_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Kimal nani, Yesu wa seghe kutii nlira aworoghe, “Yene, nene ushino! Na uwa kuru uti kulapi ba, bara imonimong nanzang na i katin ilengene wasefi.” ");
INSERT INTO amo_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Unite nya adi belli adidya na Yahudawa Yesari nshino ninghe. ");
INSERT INTO amo_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Bara ilenge imone adidya na Yahudawwe wati Yesu ku aneo, bara na awa su ilenge imone liri na Sabbat. ");
INSERT INTO amo_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesu woro nani, “Ucif nin di katwa nene wang, meng ndi katwa.” ");
INSERT INTO amo_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Bara nani a Yahudawa wa pizuru tibau vat nworu imolughe, na bara ananza Asabbat cas ba, bara akuru adi yicu Kutelle Ucifme. Ayira litime urum nin Kutelle. ");
INSERT INTO amo_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Yesu kawa nani aworo, “Kidegenere na gono wasa asu imonimong litime ba, se ilenge na ayene Ucife din suzu, gono asa su inmusu nileli imone wang. ");
INSERT INTO amo_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Bara Ucife dinin sun Saune, tutung amini din dursuzughe imon ilenge na ame din suzu, ama kuru adursoghe imon ididya ilenge na i katting ilengene bara anung nan se uzikpu. ");
INSERT INTO amo_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Nafo na Ucife na fiza anan kul, aniza nani ulai, nanere wang Usaune ma kuru aniza alenge na ame nfere ulaiye tutung. ");
INSERT INTO amo_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nafo na Ucife din su umong ushara ba, ana nani usaune ushara vat. ");
INSERT INTO amo_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Bara vat nan zazina Usaune nafo na idin zazunu Ucife. Ulenge na adin zazunu Usaune ba, na adin zazunu Ucife na atughe ba. ");
INSERT INTO amo_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Kidegenere, ulenge na alanza uliru nighe, aminin yinna nin lenge na ana tuuyi adi nin lai sa ligang ana ama so nca nkulba. Ana kafina ukul udu nanya nlai. ");
INSERT INTO amo_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Kidegenere ndin bellu minu, kubi din cinnu nene wang kuda, na anan kul ma lanzu liwui ning, Usaun Kutelle, inung alenge na ilanza ma ti ulai. ");
INSERT INTO amo_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Nafo na Ucife di nin lai unlitime, nanere wang ana ni Usaune ayita nin lai unlitime. ");
INSERT INTO amo_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ucife uni nani Usaune likara nsu nshara bara na ame Usaun nnitari. ");
INSERT INTO amo_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Na iwa se uzikpu nanya nilenge imone ba, bara kubi din cinu kongo vat na lenge na idi nisek ba lanzu liwui me, ");
INSERT INTO amo_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","tutung ima nuzu udas: alenge na inasu imon icine ima fitu iti ulai, a inung alenge na ina su imon inanzang, ima fitu ufitun shara. ");
INSERT INTO amo_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Bara litinin nwasa nsu imon ba, nafo na ndin lanzu, nanere ndin su ushara, tutung ushara ning ucinari, bara na ndi su un kibinai ning ba, se kin lenge na ana tuuyi. ");
INSERT INTO amo_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Andi nma su uliru litining usaning, na uliru nighe ma yitu kidegen ba. ");
INSERT INTO amo_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Umong duku na adin su uliru litinighe, tutung meng yiru ulire na adin bellu litinighe kidegenari. ");
INSERT INTO amo_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ina tuu kitin Yuhana, amini na su uliru un kidegen. ");
INSERT INTO amo_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Vat nani, uliru ulenge na ina seru na kitin nnitari ba. Nbelle ile imone inan se utucu. ");
INSERT INTO amo_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yuhana wadi ulari na uwadin lii uta kiti kanang, anung ani wadi nin su i yita nin liburi libo nin kubiri kongo na idin yenje. ");
INSERT INTO amo_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Vat nani ushada ulenge na ndimung, ukatin un Yuhana, bara katwa kane Ucife na nii nmalu, katwa ka na ndin su, nna ushaida litining nwo Ucifari na tuyi. ");
INSERT INTO amo_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ucife, ulenge na ana tuyi litime ana ni ushada litining. Na isa lanza liwuime ba, sa iyene ukama me ba. ");
INSERT INTO amo_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Na uliru me du nanya mine ba, bara na ina yinin nin lenge na ana tuyi ba. ");
INSERT INTO amo_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Idin pizuru uliru ulau nanya niyerte, idin yenju nafo nanya ninnere ima se ulai, unin uliru ulau urum unere nani ushada litining, ");
INSERT INTO amo_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ana anung dinin su idak kiti nin inan se ulai ba. ");
INSERT INTO amo_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Na ndin sesu uzazinu kiti nanit ba. ");
INSERT INTO amo_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Bara inyiru na idi nin su Kutelle nanya nibinayi mine ba. ");
INSERT INTO amo_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nna dak nanya lissa Ncif ninghari, inani na ina seri ba. Andi umong ma dak nanya lissa me ima serughe. ");
INSERT INTO amo_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ima ti inyizari iyining, anung alenge na idin piziru uzazinu nati mine, a na idin sesu uzazinu ulenge na udi kiti Kutelle kurum cas ba? ");
INSERT INTO amo_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Na iwa yenje nafo meng litinighe, nma ti ukara mine kitin Cife ba. Umong duku ulenge na adin tizu ukara mine, Musari une ulenge na anung ceo ayi ku. ");
INSERT INTO amo_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nda ina yinin nin Musa, iwa yinnu nin mi bara ana su iyerte liti nighe. ");
INSERT INTO amo_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Andi na iyinna nin niyerti me ba, ima ti inyizazari iyinin nin liru ning? ");
INSERT INTO amo_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Kimal nile imone, Yesu uni wa nya udu uleli uwul kurawa Ngalili, na ikuru idin yiccu kunin kurawa Tibariya. ");
INSERT INTO amo_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Ligozin nanit gbardang wa din dortughe, bara iwa yenje imon ile na awa suzu anan tikonu. ");
INSERT INTO amo_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu wa ghana kitene likup asoku ligowe nin nono katwa me. ");
INSERT INTO amo_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","(Kubin paska, u idi na Yahudawa wa dak susut.) ");
INSERT INTO amo_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Na Yesu wa yene ligozin nanit gbardang din cinu udak kitime, a woro Filibus ku, “Tima seru imonli nweri alele nan leo?” ");
INSERT INTO amo_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Yesu wa belli nani anan dumuna Filibus ku, bara ame wa yiru imon ile na ama su.) ");
INSERT INTO amo_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filibus kawa ghe aworo, “ufungal nisulai akalt aba ma batunu nwo kogha mine bat wang ba.” ");
INSERT INTO amo_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Umong nanya nono katwa we, Andrawus, gwanan Simon, woro Yesu ku. ");
INSERT INTO amo_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“nkan gono di kikane nin fugal utaun, a ibo iba, ilele mati inyaghari nanya nanit gbardang nene?” ");
INSERT INTO amo_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu woro,”Tan anite iso kutyen.”(ukpi ushifi wadi kitene gbardang) Anite so kutyen, ngbardang mine wa durun amui ataun. ");
INSERT INTO amo_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Yesu yauna uffugale, na ata nlira, a koso alenge na iwa sosin. Akuru akoso ibowe nanere, kogha se cot liburi me. ");
INSERT INTO amo_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Na anite wa shito, aworo nono katwa me, “pitirnon ngisi nagire na alawa, bara imoimong wa nana.” ");
INSERT INTO amo_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","I pitirno vat, ikulo akuzun likure nin nagisin nfungal utaunne, ngisin nagir na lenge na ileo. ");
INSERT INTO amo_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Na anite in yene imon ilenge na asu, i woro, “kidegenere, ulengenere unan liru nin nu Kutelle ulenge na ama dak nanya inyi.” ");
INSERT INTO amo_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Na Yesu wa yinin idi nin su ikufoghe nin likara iterughe tigo, anuzu nanya mine likire aghana likup usanme. ");
INSERT INTO amo_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Na kulele nta, nono katwa me tolo udu kurawa. ");
INSERT INTO amo_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ipira nanya nzirgin nmyen, itunna ncin nya kurawe cindu Ukafarnahum. (kiti wadi kimal siru na Yesu wadi asa da kitimine ba.) ");
INSERT INTO amo_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Koni kube, ufunu likara wadi, nmyen kurawe tunna nfituzu nin likara. ");
INSERT INTO amo_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","N a isu ucin nafo timel titat sa tinas, idi yene Yesu ku din cin kitenen nmyene ucin dak kitimine nanya nzirge fiu kifo nani. ");
INSERT INTO amo_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Atunna aworo nani, “Menghari! Na iwa lanza fiu ba.” ");
INSERT INTO amo_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Itunna iyinna a pira uzirge, na nin molu kubi ba iduru kiti kanga na idin cinu udue. ");
INSERT INTO amo_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ukurtunun kwuiye, ligozin nanit na iwa yissin nleli kurawe yene na umong uzirgi duku ba, urum unere cas, ulele tutung na Yesu wa piru ku nin nono katwa me ba, nono katwawere cas wa nya usanminu. ");
INSERT INTO amo_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Nton tizirgi da unuzun Tibariya susut nin kiti kanga na ini leo imonleku, kimalin tin liran Ncikilare. ");
INSERT INTO amo_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Na ligozine wa yinni nwo, Yesu sa nono katwa me na iwa di kite ba, inung atimine pira nanya tizirge i nya udu u Kafarnahum udun pizirun Yesu ku. ");
INSERT INTO amo_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Na iseghe ileli uwul kurawe, I woroghe nenge, “Unan dursuzu niyerte, nin kome kubiari uda kikane?” ");
INSERT INTO amo_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu kawa nani aworo, “kidegenere ipizarai, na bara iyene imon izikiki ba, bara ina lii ufungal ishito. ");
INSERT INTO amo_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Sunan katwa nimoli ile na ima nanu, sun katwa nimonli ilenge na ima daudaunu udu ulai un sa ligan ulenge na usaun Nnit ma ni minu, bara Kutelle Ucif na malu uti ushaida me litime. ");
INSERT INTO amo_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Itunna i woroghe, “inyaghari tibasu tinan su nitwa Kutelle?” ");
INSERT INTO amo_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu kawa a woro nani, katwa Kutelle kanin nere: Iyinin ni lenge na ame na tughe.” ");
INSERT INTO amo_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","I tunna i woroghe, “Uyapin ushaidari uma ti, arik nan yene, ti yinna nin fi?” Inyaghari umati? ");
INSERT INTO amo_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Acif bit wa lizu umanna nanya ntene, nafo na ina yertin, “Awa ni nani ufungal un nuzu kitene kani ili.” ");
INSERT INTO amo_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yesu tunna a kawa nani, “Kidegenere, na Musari wa niminu ufungal un nuzu kitene Kutelle ba, Ucif nigha ulenge na adin nizu minu ufungal kidegen un nuzu kitene Kutelle. ");
INSERT INTO amo_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Bara ufungal Kutelle unin nare ulenge na udin tolusu unucu kitene Kutelle uniz uyi ulai.” ");
INSERT INTO amo_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","I woroghe nenge, “ Cikilari, niza nari ufungal une ko kome kubi.” ");
INSERT INTO amo_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu woro nani, “Menghari ufungal un laiye, ulenge na ada kitining na aba lanzu kukpong ba. Ulenge na ayinna nin mi, aba lanzu ukotu nayi ba. ");
INSERT INTO amo_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nani, nbelin minu nenge, imal yeni, vat nani na iyinna ba. ");
INSERT INTO amo_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Vat nalenge na Ucife nayi, ima dak kitininghe, ame ulenge na ada kitinighe, na nwasa nkoghe ba. ");
INSERT INTO amo_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Bara meng na dak unuzu kitene Kutelle, na nda su imon litinin ba, se nsu imon ilenge na ana tuyi nsu. ");
INSERT INTO amo_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ilengenere imon ile na ana tuyi mun, nworu nenge vat nalenge na ana ni, na iwa wultun unit urum ku ba, na ida fya nani vat liri nimalin. ");
INSERT INTO amo_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Bara kadura Ncifere kane, vat nlenge na ayene usaune, amini yinna ninghe, ama se ulai un sa ligan; Meng tutung ma fyughe liri nimalin. ");
INSERT INTO amo_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Adidya na Yahudawa tunna icizina ugbondulu kitene me bara na ani woro, “Menghere ufungal ulenge na una nuzu kitene Kutelle.” ");
INSERT INTO amo_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","I woro, “Na ulengenere Yesu Usaun Yusufu ba, na ucife nin nene arika na tiyiru nani ba? Inyizari aworo, 'Nna dak unuzu kitene Kutelle'?” ");
INSERT INTO amo_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Yesu kawa a woro nani, “Sunan ugbondulu nanya nati mine. ");
INSERT INTO amo_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Na umong unit wasa a da kiti ning ba se Ucife ulenge na ana tuyi nwunghe, Meng tutung ma fyughe liri nimali. ");
INSERT INTO amo_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Imone di nya niyerte nanan liru nin nu Kutelle, 'Vat mine Kutelle ma dursuzu nani' Vat nlenge na a lanza amini massa kiti Ncife ma dak kitining. ");
INSERT INTO amo_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Na iworo umong name yenu Ucife ba, se ame ulenge na ana nuzu kiti Kutelle, amere na yene ucife. ");
INSERT INTO amo_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Kidegenere, ame ulenge na ayinna adi nin lai nsali ligan. ");
INSERT INTO amo_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Menghari ufugal nlai. ");
INSERT INTO amo_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Acif mine wa li ufungal nanya ntene inani wa kuzu. ");
INSERT INTO amo_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ulengenere ufungal ulenge na una dak unuzu kitene Kutelle, bara unit uleng na leo nanya nin na awa kuba. ");
INSERT INTO amo_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Menghari ufungal un lai ulenge na una tolu unuzu kitene Kutelle. Asa umong nleo nanya nfungal ulele, ama ti ulai un sa ligang. Ufungal ulenge na mma ni kidowo nighari bara ulai in yii.” ");
INSERT INTO amo_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","A Yahudawa lanza ayi nanya mine itunna icizina umusu, idi du, “inyizari unit ulele ma ninari inawa me tili?” ");
INSERT INTO amo_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yesu tunna a woro nani, “Kidegenere, se ileo inawa Nsaun Nnit, isono nmyi me, andi na nani ba na ima yitu nin lai nati mine ba. ");
INSERT INTO amo_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Vat nlenge na aleo inawa ning, asono nmyi ning adi nin lai un sa ligan, meng tutung ma fiwughe liri nimalin. ");
INSERT INTO amo_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Inawa ning innare imonli kidegen, nmyi ning minnare nmyen kidegen ");
INSERT INTO amo_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ulenge na aleo inawa ning, asono nmyi nin, ama so nanya ning, a meng nanya me. ");
INSERT INTO amo_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nafo na Ucif un lai na tuyi, tutung nafo na meng di bara Ucif, nanere nanere ulenge na aleyi, nanere wang ama ti ulai bara meng. ");
INSERT INTO amo_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ulelere ufungal ulenge na una tolu unuzu kitene Kutelle, na imusun nilenge na acifi mine wa li ikuzu ba. Ame ulenge na aleo ufungal ulele mati ulai sa ligang.” ");
INSERT INTO amo_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu wa belli ule ulire nanya kutyi nlira, kube na awa din dursuzu nanit in Kafarnahum. ");
INSERT INTO amo_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Gbardang nanyan nono katwa me na iwa lanza nani, i woro, “ Ulenge udursuzu kite dinin nijasi kang; ghari ma yinnu mu?” ");
INSERT INTO amo_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu, bara awa yinnin nanya me nono katwa me din gbondilu lire, aworo nani, “ule ulire mati minu idiuwa? ");
INSERT INTO amo_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Uma nin yittu inyiziari asa iyene Usaun Nnit din ghanu ukpillu kiti kanga na awa yita ku? ");
INSERT INTO amo_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Uruhu unere din nizu ulai. Kidowo din kpizunu imonimon ba. Ulire nan su minu, Uruhari, tutung ulaiyari. ");
INSERT INTO amo_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Vat nani among mine duku na isa yinna ba.” Bara Yesu wa yiru tun nin cizine alenga na iyinna ba, a ayiro tutung ulenge na ama lewughe. ");
INSERT INTO amo_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Aworo nani, “Bara nanere nta nbellin minu, na umong wasa ada kitining ba andi na Ucif nyininghe mun ba.” ");
INSERT INTO amo_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Kimal nani, gbardang nono katwa me kpilla, na i kuru i cina ninghe ba. ");
INSERT INTO amo_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Yesu woro nono katwa me likure nin nan wabe, “Anung wang di ninsu i nyawa?” ");
INSERT INTO amo_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Bitrus kawaghe aworo, “Cikilari, kitin ghari tiba du? Fere dinin liru lai saligaghe, ");
INSERT INTO amo_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","arik ani na yining, tinani na dak tiyinno fere unit ulau Kutelle.” ");
INSERT INTO amo_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu woro nani, “Na mere na fere minu likure ba, umong mine uni di kugbergenu ba?” ");
INSERT INTO amo_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Awa di nliru litin Yahuda, Usaun Simon Iskaroti, bara amere wadi, umong nanya likure na ama lewughe. ");
INSERT INTO amo_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Kimal ni lenge imone Yesu uni wa wasu ucin udu u Galili, na awa di ninsu a dofin nanya Yahudiya, bara a Yahudawa wa din pizuru nwo imolughe. ");
INSERT INTO amo_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Kubin idi na Yahudawa, u idi na danga wa dak susut. ");
INSERT INTO amo_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Nuana me woroghe, “suna kikane udo u Yahudiya, bara nono katwafe nan yene katwa kanga na udin sue. ");
INSERT INTO amo_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Na umong din su imonmong liyeshin ba, andi ame litime di nin su iyinin ghe. Andi udi su ile imone, durso litife nanya nyie” ");
INSERT INTO amo_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Bara inung nauna me wang wa yinin nighe ba. ");
INSERT INTO amo_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Yesu uni wa belin nani, “ Na kubi ninghe nsa da ba, anung dinin kubi ko kishi. ");
INSERT INTO amo_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Na uyie was unari minu ba, ama unari meng ku bara nna ni ushaida liti nnin kitene lidu linanzang nnin. ");
INSERT INTO amo_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Anung can kitin ide; na meng ba du kiti idi ulele ba, bara na kubi nighe nsa kulo ba.” ");
INSERT INTO amo_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","KImal nbellu nani nleli ulirue, amini wa so in Galili. ");
INSERT INTO amo_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Vat nani na nuane nya udu kitin ide, ame tutung nya na nin yiru nanit ba, likire. ");
INSERT INTO amo_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","A Yahudawa wa pizurughe kitin ide, i woro. “Adin nwe?” ");
INSERT INTO amo_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Anit wa su uliru litime kan. Among woro. “Unit ucinari ame” Among woro “Nanere ba, adin wultunu nanitari.” ");
INSERT INTO amo_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Vat nani na umong wa su uliru litime kanang ba, bara fiu na Yahudawa. ");
INSERT INTO amo_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Na u idi wa dak susut nmalu, Yesu do nanya kutii nlira adin dursuzu nanit ku. ");
INSERT INTO amo_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","A Yahudawa wa su umamaki i woro, “Ita iyizari unit ulele di nin yiru kang? Na asa do kutii ndursuzu, idursuzoghe ba.” ");
INSERT INTO amo_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesu kawa nani aworo, “Imon ile na ndin dursuzue na inaghari ba, in lenge na a toyiari. ");
INSERT INTO amo_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Andi umong dinin su asu imon kibinai nnit une, ama yinnu ubellen nlenge udursuzue, sa una dak unuzu kiti Kutelle, sa ndin su uliru bara lit ningahri. ");
INSERT INTO amo_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ulenge na adin su uliru bara litime adin pizuru ngongon litime, ame ulenge na adin pizuru ngongong nlenge na ana tughe, unit une unan kidegenari, ana udiru katwa kacine dinghe ba. ");
INSERT INTO amo_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Na Musari wa nimu uduke ba. Vat nani na umong mine din dortu uduke ba. Iyaghari nta idi nin su imoli?” ");
INSERT INTO amo_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ligozin kawaghe, “Udi nin kugbergenu. Ghari dinin su amolufi?” ");
INSERT INTO amo_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesu kawa nani a woro, “Nna su nkan katwa vat mine ani na lanza nzikiki kanin. ");
INSERT INTO amo_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musa na niminu ukalzu nacuru (Na una nuzu kitin Musere ba, kiti na Cif nburnuari), inani asa kala unit kucuru liri na Sabbat. ");
INSERT INTO amo_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Asa ikala unit kucuru liri na Sabbat bara iwa patilin udukan Musa, iyaghari nta idin lanzu ayi ninmi kitene nwo nshino nin nit liri na Sabbat? ");
INSERT INTO amo_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Na iwa su ushara bara u yenju nmuro ba, sun usharawe nin fiu Kutelle.” ");
INSERT INTO amo_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Among mine anan Urshalima woro, “Na amere ulengene na idin pizuru imolu ba? ");
INSERT INTO amo_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Yeneng, adin liru kanang, ana iworoge iyang ba. Na umaso nafo adidya bite yiru amere Kriste, na nanere ba? ");
INSERT INTO amo_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Arik yiru kikanga na unit ulele na nuzu ku, asa Kristi nda, na imong ma yinnu kikanga na ana nuzu ba.” ");
INSERT INTO amo_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesu uni wa ghatin liwui kan nanya kutii nlira, ndursuzu kiti a woro, “Anung vat yirue, iyuro kikanga nan nna nuzu ku; na nna dak bara litinin ba, ame ulenge na ana tuyi unan kidegenari, ulenge na iyirughe ba. ");
INSERT INTO amo_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Meng yirughe, bara nna dak unuzu kiti mere, amere na tuyi. ");
INSERT INTO amo_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Icizina nworu i kifoghe, na umong nkifoghe ba bara na kubi me wadi kusa da ba. ");
INSERT INTO amo_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Nani, among gbardang nanya ligozin wa yinin nighe. I woro “Asa Kristte nda, ama su imon izikiki ikata ilenge na unit ulele nsuwa?” ");
INSERT INTO amo_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Afarisawa lanza ligozin nanite din belu ulenge ulirue litin Yesu, adidya na Yahudawe nin na Farisawa to a dugari idi kifoghe. ");
INSERT INTO amo_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Yesu tunna a woro, “Ndu nin kubiri bat in yita ligowe nan ghinu, Nma nin du kitin lenge na ana tuyi. ");
INSERT INTO amo_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ima pizirui na ima yeni ba, kiti kanga na nma du, na yinnu idak bak.” ");
INSERT INTO amo_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ayahudawa tunna nbelu nati mine, “Unit ulengene madu weri ki kanga na arik ma yinnu upizirughe ba? Sa ama du kiti na Helenawari, alenge na isosin buu adi dursuzo nani ti Helenawa? ");
INSERT INTO amo_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Uyapin uliruiari ulele na a belle, 'ima piziri, ana ima yeni ba; kiti kanga na nma du, na anung ma yinnu udake ba.'?” ");
INSERT INTO amo_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Nengene liri nimalin idi udya, Yesu wa fita asu uliru nin liwui kang, aworo,”Andi umong dinin kotu nayi na adak kitining ada sono. ");
INSERT INTO amo_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ulenge na ayinna nin mi nafo na uliru Kutelle na belli, unuzu nanya me, igawan nmyen nlai ma cun ku.” ");
INSERT INTO amo_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Nani awa su uleli ulire litin Ruhu, ulenge na ale na iyinna ninghe ma seru; na iwadi isa na uruhe ba, bara na iwa di isa ta Yesu ku gongong ba. ");
INSERT INTO amo_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Among ligozin, na iwa lanza uleli ulirre, iworo, “Kidegene ulengene unan liru nin nu Kutelleari.” ");
INSERT INTO amo_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Among woro, “Ulengenere Kristi.” Among tutung woro, “Iyangha, Kristi ma dak unuzun Galiliaria? ");
INSERT INTO amo_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Na uliru Kutelle na woro Kristi ma dak unuzu fimusun Dauda in Baitalami, ka gbiri kanga na Dauda wa duku?” ");
INSERT INTO amo_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Usalin yinnu nin nati fita nanya ligozighe bara ame. ");
INSERT INTO amo_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Among mine wa dinin su ikifoghe, a nan umong mine tardaghe ucara ba (na umong mine kifoghe ba.) ");
INSERT INTO amo_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Adugare tunna i kpilla kiti na didya na Yahudawa nan na Farisawe, inung woro nani, “Iyaghari nta na ida ningheba?” ");
INSERT INTO amo_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Adugare kawa nani, iworo, “Na umong nsa su uliru nafo ulengene ba.” ");
INSERT INTO amo_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Afarisawa kawa nani, iworo “Anung wang iwultun minua? ");
INSERT INTO amo_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Umong nanya na Gowe sa Afarisawa nyinna ninghe? ");
INSERT INTO amo_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Linin ligozin longo na liyiru uduke ba, ita nani unuu.” ");
INSERT INTO amo_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodimo woro nani, (Umong na awa mang dak kitin Yesu, ame wang ku Farisawari), ");
INSERT INTO amo_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Uduka bite din suzu unit ushara a udutu sa ulanzu kitime iyinnin imong ilenge na adin sua?” ");
INSERT INTO amo_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","I kawage i woro, “Fe wang kunan Galiliaria? Piziran iyene na umong unan liru nin nuu Kutelle ma dak unuzun Galili ba.” ");
INSERT INTO amo_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Kogha mine nya udu kilari me. ");
INSERT INTO amo_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yesu wa ghana likup in Zaitun. ");
INSERT INTO amo_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Nin kwui dindin akuru ada nanya kutii nlira, anite vat da kitime; a tunna aso a dursuzo anite. ");
INSERT INTO amo_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Anan niyerte nin na Farisawa da nin mong uwani na iwa kifoghe nanya kulapi nfunu nin mong, iceoghe kitikmine. ");
INSERT INTO amo_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Inin woro Yesu ku. “Unan Dursuzu, uwani ulele, ikifogheari nanya kulapin nfunu, ima niyitan nsure. ");
INSERT INTO amo_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Nene nanya duke, Musa na woro nari asa ti filiso imus nnit une; fe nworo iyaghari kiteneme?” ");
INSERT INTO amo_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Iwa belli nani inan kifoghe nin tikanci. Yesu tunna a tumuno a su inyerte kutyen nin licin me. ");
INSERT INTO amo_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Na iwa li ubu nin tirighe, a fita a yissina a woro nani, “Ame ulenge na addi nin kulapi ba nanya mine, na amere cizin ufilughe nin litale.” ");
INSERT INTO amo_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Akurru atumuno tutung niyerte nin licin me kutyen. ");
INSERT INTO amo_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Na inung lanza nani, itunna nyizu na lalarum, ucizunu nin kune udak unan ni maline. Ida malizina isuna Yesu ku nin usanme nin wani une na awa di kityek mine. ");
INSERT INTO amo_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Yesu fita aworo nwane, “Uwani, inung anan kifufe nde? Na umong mine nmolofi ba?” ");
INSERT INTO amo_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","A wor, “Ko unit urum, Cikilari.” Yesu woro, “Na meng wang nse fi nin kulapi ba, Canfi, ucizunu nene udu nbun, na uwa kuru uti kulapi ba.” ");
INSERT INTO amo_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu kuru asu uliru nin nanite aworo, “Menghari nkanang in yi; ulenge na a dofini na ama cinu nanya nsirti ba nani ama se nkanang nlai.” ");
INSERT INTO amo_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","A Farisawa woroghe, “Una ushaida litife; na ushaida fe kidegeneri ba.” ");
INSERT INTO amo_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu kawa aworo nani, Andi ma nna ushaida litining, ushaida ning kidegenari. Meng yiru kikanga na nna nuzu ku, in yiru kikanga na ndin cinu udue, na anung dinin yiru kiti ka na inan nuzuku ba, sa kika na ndin cinu udue. ");
INSERT INTO amo_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Anung din su ushara un yenju nyizi, meng din su umong ushara ba. ");
INSERT INTO amo_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Vat nani asa nsu ushara, ushara nighe kidegenari bara na ndi usanning ba ndi nin Cif ulenge na ana tuyi. ");
INSERT INTO amo_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Nanere nanya nduka mine ina yertin au ushaida nanit anwaba kidegenere. ");
INSERT INTO amo_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Menghari ame ulenge na ndin shaida litining, a ame Ucife na ana tuyi din nin ushaida litining.” ");
INSERT INTO amo_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","I woroghe, “Uciffe din weri?” Yesu kawa nani, “Na iyiru menku sa Ucif nin ba; idafo ina yiri, iwa yiru Ucif nighe wang.” ");
INSERT INTO amo_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Awa belin uliru une susut nin kiti in nyeshizu nikurfu ayita ndursuzu nin kiti nanya kutii nlira, ana umong nkifoghe ba, bara na kubi me wa di kusa daba. ");
INSERT INTO amo_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Akuru a woro nani, “Mma su ucin, ima piziri, inin kuzu nanya nalapi mine. Kiti kanga na nma du, na iwa sa idaku ba.” ");
INSERT INTO amo_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","A Yahudaw woro, “Ama molu litime, ame ulenge na aworo, 'kiti kanga na ndin cinu udue, anung wasa ida ba?” ");
INSERT INTO amo_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu woro nani, 'Anung anan kadassari; Meng unan kitenari, Anung anan yi ulelere, Na meng unan le uyere ba. ");
INSERT INTO amo_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Bara nani, nworo minu, ima kuzu nanya nalapi mine. Andi na iyinna mere AME ba, ima kuzu nanya nalapi mine.” ");
INSERT INTO amo_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Iworoghe nenge, “Feghari?” Yesu woro nani, “uliru urika na nna bellin minu nin cizine. ");
INSERT INTO amo_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ndi nin nimon gbardang na nma su uliru ku, nkuru nsu ushara ku kitene mine. Vat nani, ulenge na ana tuyi di kidegen; a imon ilenge na nna lanza kitime, imonere ndin bellu uyie. ");
INSERT INTO amo_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Na iwa yinin nworu adin liru nanghinu liti Ncif ba. ");
INSERT INTO amo_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Yesu woro, “Asa i ghantina Usaun Nnit kitene kani, Ima nin yinnu MERE, ima yinnu tutung na ndi su imoimong in litining ba. Nafo na Ucif na duzsuzoi, ndin belu ilenge imone. ");
INSERT INTO amo_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ulenge na ana tuyi di ligowe nin mi, ana ama suni ussaning ba, bara ndin su imon ilenge na idin puzughe liburi.” ");
INSERT INTO amo_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Kube na Yesu wa din bellu nleli ulirue, gbardang nanit wa yinnin nighe. ");
INSERT INTO amo_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesu wa woro na Yahudawa alenge na iwa yinnin nighe, “Asa ileo ubun nanya nliru nighe, kidegenere anung nono katwa nighari; ");
INSERT INTO amo_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ima nin yinnu kidegene, kidegenere ma bunku minu utucu.” ");
INSERT INTO amo_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","I kawa ghe, Arik kuwunun Ibrahimari na tisa su licin nacara nmong ba; inyizari uma woru, 'Ima se ubuntu iso fong?” ");
INSERT INTO amo_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesu kawa nani, “Kidegenere ndin bellu minu, vat nlenge na ata kulapi, ame kucin kulapiari. ");
INSERT INTO amo_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Na kucin din so kilari cikilari me udu ukul ba, usaun ncikilarere din so udu uku me. ");
INSERT INTO amo_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Andi usaune ma bunku minu, nanere wang ima se ubuntu. ");
INSERT INTO amo_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nyiru anung kuwunun Ibrahimari; idin pizuru umoli, bara na uliru ninghe se kitin so nanya mine ba. ");
INSERT INTO amo_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nbele imon ilenge in yene nin Cifning, anung ani din su imon ilenge na ina lanza kitin Cif mine.” ");
INSERT INTO amo_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","I kawa iworo, “Ucif bit Ibrahimari.” Yesu woro nani, Ndafo anung nonon Ibrahimari, iwa su katwan Ibrahime. ");
INSERT INTO amo_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Vat nani, inani pizira imoli, unit ulenge na a belin minu kidegen kanga na a lanza kiti kutelle. Na Ibrahim nasu ilenge imone ba. ");
INSERT INTO amo_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Idin su nitwa ncif minere.” I woroghe, “Na iwa maru nari nanya nfunu ba; tidi nin Cif urum, Kutelle.” ");
INSERT INTO amo_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Yesu woro nani, “Andi Kutelle Ucif minere, iwa yitu nin su ninghe, bara meng na nuzu kiti Kutellari nda; na nna dak bara litining ba, amere na tuyi. ");
INSERT INTO amo_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Iyaghari nta na i yinno uliru nighe ba? Bara na idi nin su ilanza uliru nighere ba. ");
INSERT INTO amo_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Anung nonon cif minere, shaitan, inani din pizuru isu ntok imusun min cif mie. Ame unan molusu nanitari nworu ucizunue ana adi nin yissunu kitene kidegen ba, bara na kidegen di nanya me ba. Asa a belle kinu, asa asu dert nin yitu mere, bara ame unan kinuwari a Ucif kinu. ");
INSERT INTO amo_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Vat nani, bara na ndin belu kidegene, na anunghe in yinna ning me ba. ");
INSERT INTO amo_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ghari nanya mine nseyi nin kulapi? Andi ndin bellu kidegen, iyaghari nta na iyinna nin mi ba? ");
INSERT INTO amo_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ame ulenge na adi un Kutelle din lanzu uliru Kutelle; na anung din lanzu unin ba, bara anung anit Kutelleari ba.” ");
INSERT INTO amo_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","A Yahudawa kawa i woroghe, “Tina belin kidegene au fe kunan Samariyaridi, tutung udi nin na gbergenu? ");
INSERT INTO amo_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesu kawa a woro, “Na meng di nin ku gbergenu ba; ama meng din ti Ucif ning gongong, anung ani na ita yi gongon ba. ");
INSERT INTO amo_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Na meng din pizuru ngongon lit ning ba, unit urumari din pizuru akuru asu ushara. ");
INSERT INTO amo_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Kidegenere ndin bellu minu, asa umong lanza uliru nighe, asu katwa mun, na ama yenu ukul ba.” ");
INSERT INTO amo_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","A Yahudawa woroghe, “Nene tiyinno udinin kugbergenu. Ibrahim nin na anabawa na kuzu; fe unin woro, 'Asa umon lanza uliru nighe na aba yenu ukul ba.' ");
INSERT INTO amo_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Na Fe katin Ucif bite Ibrahime, na ana kuba, sa ukatinghe? A a anabawa wang na kuzu, Fe yira litife iyaghari?” ");
INSERT INTO amo_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu kawa nani, aworo, “Asa nta liti ninghe ngongong, ngongong nighe di imon ba; Ucif nighari ulenge na ama ti ngongong- ame ulenge na anung woro Kutelle minere. ");
INSERT INTO amo_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Anung pa na iyirughe ba, ame meng yirughe. Andi nma belle na nyirughe nma so nafo anughe, unan kinu. Vat nani, nyirughe, nmini din dortu uliru me. ");
INSERT INTO amo_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ucif mine Ibrahim wasu liburi libo ninyenu nwui nighe; awa yene unin, ayi poghe.” ");
INSERT INTO amo_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","A Yahudawa woroghe, “Na usa duru akus akut ataun ba, ama fe uni na yene Ibrahim kua? ");
INSERT INTO amo_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesu woro nani, “kidegenere ndin bellu minu, a idutu sa umaru Ibarahim ku, MENG wa yita ku.” ");
INSERT INTO amo_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","I tunna i pila atala ima filusughe mun, Yesu tunna a nyeshe litime a nuzu nanya kutii nlire a nya. ");
INSERT INTO amo_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Na Yesu wa cinu ukatu, a yene umong nin niduu tun umaru me. ");
INSERT INTO amo_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Nono katwa me tiringhe, “Unan dursuzu, ghari nati kulapi, amere sa anan maru me, inyaghari nta ina marughe udu.” ");
INSERT INTO amo_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu kawa aworo, “Na amere sa anan marume na ti kulapi ba, ama bara inan durso katwa Kutelle litime. ");
INSERT INTO amo_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Tima su katwa nlenge na ana tuyi a kiti dutu kanang. Kitik din cinu na umong wasa asu katwa ba. ");
INSERT INTO amo_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Asa ndu nanya nyie, mere nkanang in yie.” ");
INSERT INTO amo_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Kimal nbelun liru une, a tufuno ataf kutyen, a lumu tiwin nin natafe, a lolo iyizi nnite nin tiwine. ");
INSERT INTO amo_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","A woroghe, “Cang udi kusu kulin Siluwam (Ukpiluwe unnare 'Ulau')” Unite nya adi kusu, a kpila adin yenju. ");
INSERT INTO amo_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Anan kupo nnite nin nalenge na i yirughe uworsu nafo unan likura iidin du, “Na unit ulele na adin sozu kikane asuzu likura ba?” ");
INSERT INTO amo_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Among woro “Ameredi.” Among woro na amere ba, ama adi nafo ulele.” Ama ame wadi bellu mere di.” ");
INSERT INTO amo_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","I woroghe nenge, “Inyizari iyizi fe puno.” ");
INSERT INTO amo_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","A kawa, awor, “Unite na idin yiccughe Yesu nni lumu tiwin amini loloo niyizi ninghe, aminin woro, 'Can Usiluwam udi kusu.' Mminin nin do ndi kusu, mminin tunna yenju kiti.” ");
INSERT INTO amo_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","I woroghe nenge, “Adinwe?” Akawa, “Na meng yiru ba.” ");
INSERT INTO amo_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","I nani wa yiru unite na awa di nin niduwe idomu kiti na Farisawa. ");
INSERT INTO amo_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Liri na Sabbatari wadi na Yesu wa lumun tiwine a punghe iyize mun. ");
INSERT INTO amo_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","A Farisawe kuru itiringhe inyizari ase uyenu kiti. A woro nani, “Ani ta tiwin niyizi ninghe, Mminin kussu, nene ndin yenju kiti.” ");
INSERT INTO amo_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Among Afarisawa woro, “Na unit ulele na nuzu kiti Kutellari ba, bara na adin dortu Asabbat ba.” Among woro. “Ima ti inyizari unit ule na adi nin kulapi su nmusu nilenge imone?” Nwase usalin munu nati kitik mine. ");
INSERT INTO amo_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","I kuru itirino uduwe tutung. Inyaghari ubelle litime bara a punfi iyizi?” Uduwe woro, “Ame u annabiari.” ");
INSERT INTO amo_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Na Yahudawa wa yinin ni liru liti nnite nworu awa di udu aminin se uyenju kiti se na iwa yicila acif nnite na ana se uyenju kit. ");
INSERT INTO amo_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Itirino acif nnite i woro, “Usaun mire ulele na ina woro iwa marughe uduwa? Ani inyizari nene adin yenju kiti? ");
INSERT INTO amo_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Acif me kawa nani, “Arik yiru usaun bitari ulele, tutung iwa marughe udu. ");
INSERT INTO amo_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Ita inyizari adin yenju kiti nene na arik yiru ba, saghari npunghe iyize, na arik yiruba. Tinonghe. Amal waurnu. Awasa asu uliru nin liti me.” ");
INSERT INTO amo_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Acife wasu uleli ulire bara na iwa din lanzu fiu na Yahudawa. Bara a Ayahudawe wa di imal yinnun nworu asa umong nyinna Yesu Kristari, ima nutunghe nanya kutii nlira. ");
INSERT INTO amo_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Bara nanere wati, acif me wa woro, “Ame nwasirna, Tirinonghe.” ");
INSERT INTO amo_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Unba tutung iyicila unite na awadi uduwe Iworoghe, “Na Kutelle ngongong. Tiyiru unit ulele unan kulaperi.” ");
INSERT INTO amo_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Unit une kawa nani, “Sa adi unan kulapi na nyiru ba. Imong irumari cas nyiru: Nwa yita udu nene ndin yenju.” ");
INSERT INTO amo_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","I tunna i woroghe, “Inyaghari atafi? Apuno iyizi fe nyizari?” ");
INSERT INTO amo_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","A kawa, “Mmal bellin minu, inani nari ulanzue! Inyaghari nta idin su ikuru nlanza tutung? Anung wang dinin su ikuru iso nono katwa mere?” ");
INSERT INTO amo_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Izogoghe i woro “Fere gono katwa me, arik nono katwa in Musari. ");
INSERT INTO amo_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Arik yiru Kutelle wa su uliru nin Musa, ama unit ulele na tiyiru sa ana nuzun nweri ba.” ");
INSERT INTO amo_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Unite kawa aworo nani, “Inyaghari, ilele imong izikikikari, au na anung yiru sa ana nuzun nweri ba, vat nin nani aminin puno iyizi nin. ");
INSERT INTO amo_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tiyiru nworu na Kutelle din lanzu anan nalapi ba, ama andi vat nnit ule na adi lanzu uliru Kutelle amin din su imon nsu me, Kutelle din lanzughe. ");
INSERT INTO amo_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Uworu ucizinun nyie, na ina so ilanza umong puno iyizi nnit ulenge na ina marughe udu ba. ");
INSERT INTO amo_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Andi na unit ulele na nuzu kiti Kutelleri ba, na awa yinnu usu nimonmong b.” ");
INSERT INTO amo_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","I kawaghe i woro, “Ina marufi vat nanya nalapi, nene umini din dursuzu narie?” Inani wa tunnun i koghe nanya kutii nlire. ");
INSERT INTO amo_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu uni wa lanza inutunghe kutii nlire, amini wa seghe aworo, “Uyinna nin Saun Nnita?” ");
INSERT INTO amo_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","A kawa aworo, “Ame ghari, Cikilari, nnan yinna ninghe? ");
INSERT INTO amo_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu woroghe, “Uyeneghe, ame ulenge na adin lirue nin fi amere.” ");
INSERT INTO amo_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Unite woro, Cikilari, meng yinna.”A tunna a zazinghe. ");
INSERT INTO amo_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Yesu woro, “Bara ushara wari nna dak nanya nyi ulele, bara anan salin yenju nan se uyenju, anan yenje tutung nan ta aduu.” ");
INSERT INTO amo_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Among A Farisawe na iwa di ligowe nanghe lanza ileli imone i tiringhe, “Arik wang aduwarie?” ");
INSERT INTO amo_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesu woro nani, “Ndafo idi aduu, na iwa yitu nin nalapi ba. Vat nani, nene inin woro, 'Tidin yenju,' bara nani, alapi mine nlawa nanghinu. ");
INSERT INTO amo_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“Kidegenere, Nbelin minu, ulenge na apira nanya nshing ligo nakame na libo kibulun ba, asa a kala udanga a pira, unit une ukiriari nin nan bolsu nimon. ");
INSERT INTO amo_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ule na a pira kibulun amere unan libya nakame. ");
INSERT INTO amo_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ame unan ca ma punghe kibulun. Akame ma lanzu liwui me, ama yicu akame nin tissa mine a nutun nani udu udas. ");
INSERT INTO amo_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Asa anutuno akame ndas vat, ama cinu nbun mine, akame dortoghe, bara na i yiru liwui me. ");
INSERT INTO amo_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Na ima dofunu kumara ba, iba na cumghari bara na iyiru liwui kumara ba.” ");
INSERT INTO amo_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu wa belin nani to tinan tigolde, na iwa yinnin sa inyaghari adin bellu ba. ");
INSERT INTO amo_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Yesu kuru aworo nani, “Kidegenere, nbelin minu, menghari kibulun nakame. ");
INSERT INTO amo_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Vat na lenge na ina dak ameng dutu udak, akiriari nin na nan bolusu nimon, na akame ma lanzu nani ba. ");
INSERT INTO amo_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Menghari kibulunghe. Asa ko uyeme unit npira unuzu ning, ama se utucu; ama pira anuzu ama se kiti kileo. ");
INSERT INTO amo_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Na ukiri din dak ba se asu likiri, amolu, anin nanza. Meng na dak ina se ulai ise unin gbardang kang. ");
INSERT INTO amo_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Menghari unan libya ugegeme. Unan libya ugegeme asa ana ulai me bara akame. ");
INSERT INTO amo_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ame unan libya nduk, na unan nakam ba, na amere unan nakame ba, awa yene kinyinyo ucin dak ama sunu akame a cum awulu. Kiyinyo ma yiru a wulttun ani. ");
INSERT INTO amo_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ama cum asun akame na ama rissu anin ba, bara na ame unan katwa ndukkari. ");
INSERT INTO amo_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Menghari unan libya ugegeme, in yiru ananing, ananighe yiruoi. ");
INSERT INTO amo_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Ucife yirui, Meng wang yiro Ucife, Meng nani ulai ning bara akame. ");
INSERT INTO amo_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ndi nin na mong akama alenge na adi an longo ligowe ba. Anin wang, nma dak mun gbas, ima lanzu liwui nighe iso ligo lirum unan libyawe wasamme. ");
INSERT INTO amo_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Bara nanere nta Ucif di nin su ning, nna ni ulai ning nnan sere unin tutung. ");
INSERT INTO amo_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Na umong ma seru unin kiti nin ba, Menghari na ceo unin usan ning. Ndi nin likara nciu nnin, in yita nin likara in yirun nin. Nna seru ulenge uduke kitin Ncif ningari.” ");
INSERT INTO amo_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Iwa se ukosu nibinayi nanya na Yahudawa bara ubellu nliru une. ");
INSERT INTO amo_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Among mine gbardang woro, “Adi nin kugbergenu ayita nin nilaza. Iyaghari nta idin lanzughe?” ");
INSERT INTO amo_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Among mine woro, “Na ule ulire un nan nilazari ba. Kugbergenu wasa ku puno iyizi nduwa?” ");
INSERT INTO amo_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Kubi nbukin wessu da in Urshalima. ");
INSERT INTO amo_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Kubi linna wadi, Yesu yita ncin nanya kutii nlira kitin shizunun Solomon. ");
INSERT INTO amo_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","A Yahudawa kilighe, iworoghe, “Udiduru kome kubiari uma sunu nari nanya nkpilzu? Andi fere Kriste nuzu fang ubelin nari.” ");
INSERT INTO amo_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesu kawa nani, Nna bellin minu na iyinna ba. Nitwa nanga na nsu nanya lissan Ncif ning, ilele nna ushaida litininghe. ");
INSERT INTO amo_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Vat nani na iyinna ba bara na anung akam nighari ba. ");
INSERT INTO amo_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Akam nin din lanzu liwui ning; in yiru nani, inung din dortui. ");
INSERT INTO amo_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ndin nizu nani ulai un saligann; na ima so inana ba, ana umong ma bolu nani nacara ning ba. ");
INSERT INTO amo_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ucif nighe, na ana nii inung, akatin koghaku vat nin likara, na umong wasa a bolo nani nacara Ncif ba. ");
INSERT INTO amo_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Meng nin Cif ninghe, unit urumere.” ");
INSERT INTO amo_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","A Yahudaw kuru iyauna atala iba filusughe. ");
INSERT INTO amo_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Yesu kawa aworo nani, “Ndurso minu imon igegeme gbardang Nnuzu kitin Cif. Nanya niyeme imonari iba filusui mung?” ");
INSERT INTO amo_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","A Yahudawe kawaghe iworo, na tiba filusu fi kitenen kan katwa ka gegeme ba, tiba filusufi kitenen nanzu lissa Kutelle na udinsu, bara fewe, unitari, umini din pilu litife nafo Kutelle.” ");
INSERT INTO amo_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu kawa nani aworo, “Na udi nanya niyertin nduka mine ba, 'Nworo, “anung atenlleari”' ");
INSERT INTO amo_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Asa ayicila nani atenle, kiti na lenge na uliru Kutelle na dak kiti mine (ana uliru Kutelle iwasa ikoso uni ba), ");
INSERT INTO amo_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","idin bellu nile na Ucif na kussu ato nanya nyii, 'Udin nanzu lissa Kutelle,' bara na nworo, Meng Usaun Kutelleari'? ");
INSERT INTO amo_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Andi na ndin su nitwa Ncif ninghari ba, na iwa yinnin nin i ba. ");
INSERT INTO amo_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Vat nani, ndi su nining, andi ma na iyinna nin mi ba, yinna nin nitwawe bara inan yiro iyinno Ucife nanya nmi ameng nanya Ncif.” ");
INSERT INTO amo_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ikuru imala ukifun Yesu ku tutung, a nyaghe sa upiru nacara mine. ");
INSERT INTO amo_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesu wa nya tutung udi kaffinu kurawan Urdun kiti kanga na Yuhana wa shintu anit ku nmyen nin cizunue; awdi so kikane. ");
INSERT INTO amo_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Anit gbardang wa dak kitin Yesu. Iso nbellu, “Na Yohana wa durso nkan katwa in yenu ba, vat nimon ilenge na Yuhana wa bellu litin Nnit ulele kidegenere.” ");
INSERT INTO amo_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Kitene nane, anit gbardang wa yinnin nin Yesu. ");
INSERT INTO amo_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Umong unit unan lissan Laazaru wadi nin konu. Ame unit Nbaitanyari, kagbirin Maryamu nin gwane Marta. ");
INSERT INTO amo_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maryamu une na awa tintilo nnuf kunya kumang nabunun Cikilare awese abune nin titime, gwanemere wadi Laazaru unan kone. ");
INSERT INTO amo_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Nuane nishono to kitin Yesu iworoghe, “Cikilari, yene ame ulenge na udi nin suwe dinin konu.” ");
INSERT INTO amo_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Na Yesu nlanza, a woro, “Na ule ukone unkulari ba, umana so un gongong Kutelleari, bara usaun Kutelle nan se ngongong kitenen nin.” ");
INSERT INTO amo_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu wayita nin sun Marta nin gwane kishono a Lazaru. ");
INSERT INTO amo_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Na awa lanza Lanzaru di nin konu, Yesu kpina ayiri aba kiti kanga na awa yita ku. ");
INSERT INTO amo_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Kimal nani, aworo nono katwawe “Cannari tido u Yahudiya tutung.” ");
INSERT INTO amo_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Nono katwawe woroghe, “Rabi, na udandauna ba, na a Yahudawa nyita nin su iffillusu fi, umini di nin su ukpili kite tutungha?” ");
INSERT INTO amo_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu kwana, a woro, “Na abiri kubi likureari di nanya liyirin ba? Asa umong din cin nin liring, na ama tiru ba, bara na adin yenju kiti kanang nin liring. ");
INSERT INTO amo_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Nanya nani, as adin cin nin kitik, aba tiru bara na nkanang di ninghe ba.” ");
INSERT INTO amo_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu wa bellin uleli ulire, kimal nleli ulire, aworo nani, “Udondong bite Laazaru ndo nmoro, mma du nnan di fyaghe nmore.” ");
INSERT INTO amo_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Nono katwawe tunna iworoghe, “Cikilari, andi nmoroari adi mum, ama fitu.' ");
INSERT INTO amo_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu wasu uliru nbellen nkul Laazaruari, inung wa su adin liru nmoro nshinuari. ");
INSERT INTO amo_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Yesu nin belle nani kanang, “Laazaru nku. ");
INSERT INTO amo_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nlanza nmang bara anughe, na nni yita kite ba anung nan yinna. Cannari tido kitime.” ");
INSERT INTO amo_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tuma, ulenge na iwa yiccughe fibari, woro nadon katwa me, “Na arik wang do ligowe tinan ku ligowe nan Yesu.” ");
INSERT INTO amo_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Na Yesu nda, ada se Laazaru nmal ti ayiri anas kisekk. ");
INSERT INTO amo_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ubaitanya wadi susut nin Urshalima, npit mine nafo timel tiba. ");
INSERT INTO amo_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","A Yahudawa gbardang wa dak kitin Marta nin Maryamu, ida lissu nani nin kul ngwana mine. ");
INSERT INTO amo_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Marta tunna na a lanza Yesu din cinu, anuzu adi zuro ninghe, Maryamu lawa kilare. ");
INSERT INTO amo_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Marta tunna aworo Yesu ku, “Cikilari, ndfo uwa duku, na gwana nighe wa kuba. ");
INSERT INTO amo_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Nene wang, ko iyapin imonari utirino Kutelle, ama nifi inin.” ");
INSERT INTO amo_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu woronenge, “Gwanafine ma fitu tutung.” ");
INSERT INTO amo_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Marta woroghe nenge, “In yiru ama fitu tutung kubi nfiyu na nan kul, liri nimalin.” ");
INSERT INTO amo_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesu woroghe, “Menghari ufyu na nan kul, Myeri ulai; ulenge na ayinna nin mi, ko aku, ama ti ulai; ");
INSERT INTO amo_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ame ulenge na adi nin lai, aminin yinna nin mi na ama kuba. Uyinna nin le ulire?” ");
INSERT INTO amo_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Aworoghe nenge, “Nanere, Cikilari, in yinna fere Kristi, Usaun Kutelle, ulenge na adin cinu ucin da nanya nyi.” ");
INSERT INTO amo_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Na a belle nani, a nya adi yiccila Maryamu gwane likot. Aworo, “ Unan dursuzu niyerte di kikane, adin yiccufi.” ");
INSERT INTO amo_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Na Maryamu nlaza nani, afita mas ado kitin Yesu. ");
INSERT INTO amo_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Kube na Yesu wadi asa pira nanya kagbire ba awa dutu kite na Marta nni zuro ninghe. ");
INSERT INTO amo_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","A Yahudawa alenge na iwa dak lippe, wadi ligowe nin Maryamu nanya kilare, na iwa yeneghe afita mas anuzu udas, idofinghe, iwa yenje nafo anuzu ucindu kisseskkere adi gilu ku. ");
INSERT INTO amo_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maryamu tunna na ada kiti kanga na Yesu yissin ku a yeneghe, adio kutyen nbun me a woroghe, “Cikilari ndafo una yita kikane, na gwana ninghe wa ku ba.” ");
INSERT INTO amo_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Na Yesu in yeneghe kuculu, a a Yahudawe na ida ligowe ninghe wang di kuculu, ata liduru nanya nruhu, ayi me fita kang; ");
INSERT INTO amo_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","a woro, “Ina nonkoghe nweri?” Iworoghe, “Cikilari da uda yene.” ");
INSERT INTO amo_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Yesu gila. ");
INSERT INTO amo_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","A Yahudawa woro,”Yenen ngbardang nsuwe na adi Laazaru ku mun!” ");
INSERT INTO amo_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Among mine woro, “Na unit ulelere, ulenge na awa pun iyizi nnit ule na awa di udu ba, na ana wanti ulele ukule ba?” ");
INSERT INTO amo_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesu nin lidurun nanya kibinayi me, do kiti kisekkee. Kisekke kutiyari, kutala wa yerdin nnuwe. ");
INSERT INTO amo_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu woro, “Kalan litale.” Marta, gwanan Laazaru unan kule, woro Yesu ku, “Nene aduru ayiri anas kidowe nmal di cizunu ubiju.” ");
INSERT INTO amo_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu woroghe, “Na nbelinfi nenge, andi uyinna, uma yenu ngongong Kutelle ba?” ");
INSERT INTO amo_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Itunna ikala kutale. Yesu ghatina iyizi me kitene kani aworo, “Ucif ning, ndin zazunfi bara na udin lanzui. ");
INSERT INTO amo_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Meng yiru ko kuyeme kubi udin lanzui, bara kukirinanite na ikilini unnare nta nbelle nani, inan yinna fere na tui.” ");
INSERT INTO amo_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Kimal nbellu nani, ata ntet nin liwui kang, “Laazaru nuzu udas.” ");
INSERT INTO amo_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Unan kule nuzu udas, anin tecin abunu nin nacara nin nimon nkassu libi, umuro me wa tecin nin nimon nkassu libi. Yesu woro nani, “Buncughe isughe a nya.” ");
INSERT INTO amo_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","A Yahudawa gbaedang na iwa dak kitin Maryamu yene imong ilenge na Yesu nsu, i yinna ninghe; ");
INSERT INTO amo_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","among mine nya ido kiti na Farisawa idi bellin nani imon ile na Yesu nsu. ");
INSERT INTO amo_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ugo na Priest nan na Yahudawa pitirino kudaru mine kiti kirum, iworo,”Inyaghari tiba ti? Unit ulele din su imon izikiki gbardang. ");
INSERT INTO amo_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Asa tisughe aleo ubun nengene, vat ma yinnu ninghe, a Rumawa ma dak ida bollu kiti bite nin min bite.” ");
INSERT INTO amo_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Vat nani, umong unit nanya mine lissa me Kefas, amere wadi ugo na Priest likus lole, woro nani, “Na iyiru ko imong ba. ");
INSERT INTO amo_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Na idin yenju ucaun kitiu mine unit urum ku bara anit va, nnun woro anit vat nana.” ");
INSERT INTO amo_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Awa bellin uleli ulire na un litime ba, bara awa di upriest udya likusse. Awa su annabci, Yesu maku bara anit; ");
INSERT INTO amo_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","na bara nmyen cas ba, Yesu nan pitiruno kiti kirum nono Kutelle alenge na ishogilin nkowe. ");
INSERT INTO amo_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ucizunu lilone, udu ubun, iwa kpiliza tibau nworu imolughe. ");
INSERT INTO amo_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Na Yesu wa kuru a gala nanya na Yahudawa fang ba, awa nya a suna kikane ado nmon min nkan kagbiri idin yicu Ifiraimu nkon kusho. Kikanere awa so ku nan nono katwa me. ");
INSERT INTO amo_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Upaska na Yahudawa wa dak susut, gbardang na mong ani wa nuzu nanya nmine udu Urshalima inan di wesse ati mine a upaska dutu. ");
INSERT INTO amo_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Iwa din pizurun Yesu ku, ilira nan nati mine nanya kutii nlira, “Iyaghari idin kpiluze? Na aba dak kitin ide ba?” ");
INSERT INTO amo_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ugo na priest nan na Farisawa wani uduka andi umong yiru kikanga na Yesu duku, na abelin inan kifoghe ");
INSERT INTO amo_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Upaska dutu nin nayiri kutocin, Yesu da Ubaitanya, kikanga na Laazaru wa duku, ulenge na awa fyaghe nkul. ");
INSERT INTO amo_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","I kanjaghe imori kikane, Martari wadi nkosue, Laazaru wadi nanya nale na iwa sosin kutebul nin Yesu. ");
INSERT INTO amo_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Maryamu yauna libon nuf nin kunya kumang na idin yicu minin nard, a titilo nabunun Yesu, a wesse abune nin titi me; kunya nnufe mala kiti vat nanya kilare. ");
INSERT INTO amo_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Umong nanyan nono katwa me, ule na idin yicu Yahuda Iskaroti, ulenge na amere ma lewu Yesu ku, woro. ");
INSERT INTO amo_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Inyaghari nwantina ulewu nnuf mone nanya nidinari akalt atat ikossu anan diru?” ");
INSERT INTO amo_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Awa belli nani na bara adin lanzu nkunekune nanan diruere ba, ama bara na ame ukiriari: amere wadi unan mizunu nka nikurfunghe anan se ayira litime imong nanya ");
INSERT INTO amo_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesu woro, “Sunnaghe ali ubun nimon ile na adi mun bara lirin nkasunigha adinsue. ");
INSERT INTO amo_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Idi ligowe nin na nan dirre ko kome kub, na ima yitu ligowe nan mi ko kome kubi ba.” ");
INSERT INTO amo_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","A Yahudawa gbardang lanza Yesu di kikane, ida, na bara Yesu cas ba, ama inan se iyene Laazaru ku, ulenge na Yesu wa fyaghe nanya nkul. ");
INSERT INTO amo_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ama adidya na nan dursuzu kite munu tinuu imolu Laazaru ku; ");
INSERT INTO amo_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","bara amere a Yahudawa gbardang wa sun nani iyinna nin Yesu. ");
INSERT INTO amo_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Ukurtunun nkuiye anit gbardang da kitin buke. Na ilanza Yesu din cinu udak Urshalima. ");
INSERT INTO amo_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ibalsa incem inuzu udundi zuru ninghe, itiza ntet, iworo, “Hossana! Unan mariari ulenge na ada nanya lissa NCikilari, Ugo in Israila.” ");
INSERT INTO amo_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu se kajaki kabene a ghanaku nafo na iwa yertin. ");
INSERT INTO amo_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Na uwa lanza fiu ba, fe ushonon Sihiyona; yenen Ugo mine din cinu, assosin kitene kajaki kabene.” ");
INSERT INTO amo_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Na nono katwa me wa yinin ileli imone nin cizune ba; ama na iwa ti Yesu ku gongong, ilizino nworu ina nyertin ileli imone litime inung ani nsughe inin. ");
INSERT INTO amo_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Nene ligozin nanite na iwa di nin Yesu kube na awa yicila Laazaru ku a fyaghe nanya kissek, inung wa belu among. ");
INSERT INTO amo_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Bara nanere wati ligozin loli wa nuzu lidi zuro ninghe bara na iwa lanza asu ileli imone. ");
INSERT INTO amo_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","A farisawa woro nati mine, “Yenen, iwasa ita imonmong ba; uyii vat din dortughe.” ");
INSERT INTO amo_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Among a Helenawa wa di nanya na lenge na iwa do nsujada kitin nbuke. ");
INSERT INTO amo_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Inughe do kitin Filibus, ulenge na awa nuzu Nbaitanya Ngalili, itiringhe, iworo, “Cikilari tidi ninsu tiyene Yesu ku.” ");
INSERT INTO amo_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Yesu do adi bellin Andirawus ku, Andirawus nin Filibus do idi belin Yesu ku. ");
INSERT INTO amo_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Yesu kawa nani, aworo, “Kube nda nworu iti Usaun Nnit gongong. ");
INSERT INTO amo_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Kidegenere ndin bellu minu, se fimus ficikapa ndeo kutyin fiku, andi na nani ba, fiba lawu finin firume; ama andi fiku, fima nin maru imong iyip gbardang. ");
INSERT INTO amo_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ame ulenge na adi nin su nlai me ama diru unin; ame ulenge na anari ulai me nanya nle uye ma ciu unin ucin du ulai nsa ligan. ");
INSERT INTO amo_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Andi umong din sui katwa, na a dortui; kiti kanga na nduku, kikanere kucin ning ma yitu ku wang, andi umong din sui katwa, Uci ning ma ni unit une tikunang. ");
INSERT INTO amo_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ayi ning nana nene; Iyaghari mma bellu? 'Ucif sui utucu nanya kubi kone?' Bara ile imonere nda ko kube. ");
INSERT INTO amo_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ucif, ta lissafe gonggong,” Liwui nuzu kitene kani liworo, “Nna ti lining gongong, nma kur nti lining gongon tutung.” ");
INSERT INTO amo_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ligozin nanite na iwa yissin kitene wa lanza i woro Kutelle tuto. Among woro, “Gono kadura Kutelleari nlirina ninghe.” ");
INSERT INTO amo_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Yesu kawa a woro, “Na liwui lole nda bara Menghari ba, ama bara anughere. ");
INSERT INTO amo_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nenere idin shara in yii ulele; Nene ima ko unan tigo nyii ulele. ");
INSERT INTO amo_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","A Meng, asa ifyi nanya kutyin, nma wunnu anit vat udak kitining.” ");
INSERT INTO amo_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Awa bellin nani adurso imus nkul ule na uma seghe. ");
INSERT INTO amo_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ligozin kawaghe, iworo, “Tina lanza nanya nduka Kristi maso sa ligang. Iyiziari uworo, 'Ima fyu Usaun Nnit kitene gbas? Ghari Usaun Nnit une?” ");
INSERT INTO amo_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesu woro nani, “Nkanang du kiti mine nin kubi bat. Sun ucin a nkanang dutu kiti mine, ana nsirti nsa da duru minu ba. Ulenge na adin cinu nanya nsirti na ayiru kiti kanga na adin cinu udue ba. ");
INSERT INTO amo_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Yinnan a idutu nin kananghe, inan so nonon kanang.” ");
INSERT INTO amo_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Vat nin nimon izikiki gbardang na Yesu wa su nbun mine, vat nin nani na iyinna ninghe ba. ");
INSERT INTO amo_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Bara ulirun Ishaya unan liru nin nuu Kutelle nan kulo, ule na awa woro: “Cikilari, ghari nyinna nin liru bite? Ucara Ncikilari ndurso liti kiti ghari? ");
INSERT INTO amo_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Bara ilenge imone na iwa yinnin ba, Ishaya wa kuru a belle. ");
INSERT INTO amo_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Ana ti idu niyizi mine, amini na kuru ata nibinai mine getek; andi na nani ba, ima yenju nin niyizi mine, ikuru iyinnin nin nibinayi mine, inin kpilin, Meng nin shin ninghinu.” ");
INSERT INTO amo_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ishaya wa belin ileli imone bara na awa yene ngongong Yesu asu uliru litime. ");
INSERT INTO amo_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Vat nin nani, among gbardang wang nanya na didyawe wa yinin nin Yesu; ana bara a Farisawa na iwa yinin ba bara iwa kala nani nanya kutii nlira. ");
INSERT INTO amo_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Iwa di nin su nzazinu nanit ukatina nani uzazinu Kutelle. ");
INSERT INTO amo_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesu ghatina liwui kang aworo, “Ulenge na ayinna nin mi, na Menghari a yinna mun cas ba ama umunu ulenge na ana tuyi na wang, ");
INSERT INTO amo_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ulenge na ayenei, ayene ulenge na ana tuyi. ");
INSERT INTO amo_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Meng na dak nafo nkanang nanya nyii ulele bara vat nnit ule na ayinna nin mi ama lawu nanya nsirti ba. ");
INSERT INTO amo_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Asa umong lanza uliru nighe na asu katwa mun ba, na nma sughe ushara ba; bara na nna dak nsun yii ushara ba, nna dak ntucu uyere. ");
INSERT INTO amo_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ulenge na anari menku, amini nari userun nliru nighe di nin lenge na adin sughe ushara; ulirere na ndin bellu ma sughe ushara liri nimalin. ");
INSERT INTO amo_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Na ndin liru litining ba. Nna din su un Cifning nin na ana tuyi, ulenge na ana nii likara nliru ule na nma bellu nin liru ule na nma su. ");
INSERT INTO amo_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Meng yiru uduka me ulai sa liganghari; bara imon ine na nna belli nafo na ame Ucif na belli inin, nanere nna bellin nani.” ");
INSERT INTO amo_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Nene a u idin paska dutu sa udak, Yesu wa yiru kubi me nmal dak nworu ama nyiu nle uyee udu kitin Cife, na ata usu nanit me na idi nanya nle uyee, a durso nani usu un sa ligang. ");
INSERT INTO amo_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Shinta wadi amal ti ukpiliu unanzang kibinayin Yahuda Iskarioti usaun Simon, a lewu Yesu ku. ");
INSERT INTO amo_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu wa yiru nworu Ucife nna imon vat nacara me, ame na dak unuzu kiti Kutelle, ama kpillu tutung udu kiti Kutelle. ");
INSERT INTO amo_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","A fita kishik nimonli ashuku kulutuk me. A yauna kupari a tere kutino me. ");
INSERT INTO amo_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","A ta nmyen kishik atunna nkuzu nabunu nnono katwa me acin weze nin kupori na a tere kutinoe. ");
INSERT INTO amo_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","A da kitin Simon Bitrus, Simon woroghe, “Cikilari, uma kusu abunu nigha?” ");
INSERT INTO amo_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Yesu kawa a woroghe, “Imong ile na ndin sue na uma yinnu nene ba, ama nin kubi bat uma yinnu.” ");
INSERT INTO amo_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Bitrus woroghe, “Na uba kusu abunu ning ba.” Yesu kawaghe, aworo, “ Asa na nkusu fi abunu ba, na nmyenfe duku nin mi ba.” ");
INSERT INTO amo_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simon Bitrus woroghe, “Cikilari na uwa kusu abunu nighere cas ba, munu acara nighe nin lite wang.” ");
INSERT INTO amo_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesu woroghe, “Ulenge na ana malu sulusunu na adu nin woru asulsun tutung ba se akusu abunu, ame unit ulauwari vat; idi lau, ana vat mine ba.” ");
INSERT INTO amo_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Bara Yesu wa yiru ghari ba lewu ghe; unare ta a woro, “Na vat minere di lau ba.” ");
INSERT INTO amo_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Na Yesu nmala ukuzu nani nabune, a yauna kulutuk me a shono a so tutung, a woro nani, “Iyiru imong ile na nsu minnue? ");
INSERT INTO amo_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Idin yiccui 'unan dursuzu niyerti' sa 'Cikilari' idin bellu dert, nanere ndi. ");
INSERT INTO amo_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Andi meng Cikilari nin nan dursuzu niyerti, nkusu abunu mine, anung wang ma kuzu an nati mine. ");
INSERT INTO amo_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Bara nsun minu, imon yenju anung wang man suzu nafo na meng su minu. ");
INSERT INTO amo_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Kidegenere, nbelin minu, na kucin katin Cikilari me ba; ana ule na ina tuughe katin ulenge na ana tuughe ba. ");
INSERT INTO amo_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Andi iyiru ile imone, anan mariari anung andi idin su inin. ");
INSERT INTO amo_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Na Ndin liru nati mine vat ba, bara meng yiru alenge na meng na fere-Nbelle nani uliru ulauwe nan kulo: 'Ulenge na adin li ufaungal ning din pulii atirfong.' ");
INSERT INTO amo_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ndin belu minu ilele nene a na Isa se kidowoba bara asa ida se, Ima yinnu MERE. ");
INSERT INTO amo_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Kidegenere, ndin belu minu, ulenge na a serei nsere ulenge na nto, a ulenge na a serei nsere ulenge na anatuyi.” ");
INSERT INTO amo_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Na Yesu nbelle nani, Uruhu me wa neo kang, akpina ubellun lirue a woro, “Kidegenere Nbelin minu umon mine ma lewi.” ");
INSERT INTO amo_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nono katwa we tunna nyenju nati mine, idin kpilizu ghari adin liru litime. ");
INSERT INTO amo_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Umong nanyan nono katwa me wadi kilewe ninghe, awa yerdin figirin Yesu, ule na Yesu wadi nin sume. ");
INSERT INTO amo_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Bitrus taghe gbiton nin lit a woro. “Belle nari ghari udin liru litime.” ");
INSERT INTO amo_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kani gono katwawe na awa yerdin figirin Yesu woroghe, “Cikilari gharidi?” ");
INSERT INTO amo_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu kwana, aworo, “Amere ulenge na ama shintinu kagir nfungal nmyene ninghe.” Na a shintino ufungal nmyene, a na Yahuda ku, Usaun Simon Iskaroti. ");
INSERT INTO amo_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Kimal nli nimole, Shintan piraghe, Yesu woroghe, “Imong ile na udin cinu usue, su inin mas.” ");
INSERT INTO amo_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Na umong kiti kutebul kilewe wa yiru imon ile na ita Yesu uni nbelinghe ileli imone ba. ");
INSERT INTO amo_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Among kpiliza, nmoti bara na amere miin nka nikurfunghe. Yesu uni woroghe, “Sere imon ile na tidi nin suwe in idi,” sa ani anan diru imonimong. ");
INSERT INTO amo_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Kimal nseru fungali Yahuda, anuzu udas mas; kiti wadi kimal sirui. ");
INSERT INTO amo_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Na Yahuda nnya, Yesu woro, “Nene Usaun nnit nta gongong, Kutelle nta gongong ninghe. ");
INSERT INTO amo_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Kutelle mati ghe gongong nanya me, ama tighe gongong mas. ");
INSERT INTO amo_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nono nibebene ndu ligowe nanghinu nin nayiri bat. Ima piziri, nafo na nna belli a Yahudawaa, 'kiti kanga na ndin cinu udue, Iwasa ida ba.' Nene ndin bellu anung kuwang. ");
INSERT INTO amo_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Ndin ni uduka upesse, nworu iyita nin su nati, nafo na meng nati usu mine nanere anung wang tan usu nati. ");
INSERT INTO amo_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Bara nanere anit vat ma yinnu anung nono katwa nighari, asa iyita nin su nati mine.” ");
INSERT INTO amo_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Bitrus woroghe, “Cikilari, uma du weri?” Yesu kwana, “kiti kanga na ndin cinu udue, uwasa uyinno udofini nene ba, nlonliri uma dofini.” ");
INSERT INTO amo_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Bitrus woroghe, “Cikilari, inyaghari mati na nma dofinfi nene ba? Nma ni ulai nin bara fewe.” ");
INSERT INTO amo_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesu kwana, aworo, “Uma ni ulaife bara mengha? Kidegenere, nbelin fi, uma na uyirui ba so titat a kukulok dutu sa ukolsunu.” ");
INSERT INTO amo_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Na iwa yinin ayi mine nana ba. Yinnan nin Kutelle; yinna nin mi wang. ");
INSERT INTO amo_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ngan Cifining niti lissosin duku gbardang; ndafo na nani ba, nwa bellin minu, nma du ndi kyele minu kiti. ");
INSERT INTO amo_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Asa ndo ndi kyele minu kiti, nma kuru nsa nda yiru minu nin litining bara kiti kanga na meng duku, anung wang nan so ku. ");
INSERT INTO amo_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kiti ka na ndin cinu udue, iyiru libauwe.” ");
INSERT INTO amo_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tuma woro Yesu ku, “Cikilari, nati yiru kikangga na udin cinu udue ba, iyizari tima yyinnu libauwe?” ");
INSERT INTO amo_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu woroghe, “Menghari libauwe, kidegene nin lai; na umong wasa ada kitin Cifeba, se adofino kiti ning. ");
INSERT INTO amo_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Andi iyinni, ima yinnu Ucif ninghe wang; ucizunu nene udu ubun, iyininghe, iyeneghe tutung.” ");
INSERT INTO amo_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filibus woro Yesu ku, “Cikilari durso nari Ucife, ulele ma batinu nari.” ");
INSERT INTO amo_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu woroghe, “Ndandauna kiti mine kan nani, umini du sa uyinniya Filibus? Vat nlenge na ayenei, ayene ucife; iyizari uma woru, durso nari Ucife? ");
INSERT INTO amo_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Na uynna nworu ndi nanya Ncife, a Ucif nanya nighe ba? Ulire na ndin su na unliti nighari ba; nani, Ucifere na adi nanya nighere dinsu katwa me. ");
INSERT INTO amo_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Yinna nin mi, nworu ndi nanya Ncife, a Ucife nanya ning; andi na nani ba, yinna ni mi bara nitwa nighe. ");
INSERT INTO amo_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Kidegenere, ndin belu minu, ulenge na ayinna nin mi, nitwawe na ndin su, ame ma su ni ning wang, ame masu ni didya bara na meng din cinu ucindu kitin Cife. ");
INSERT INTO amo_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Vat nimon ile na itirino nanya lissaning, Meng masu ining bara Ucife nan se ngongong nanya Nsaune. ");
INSERT INTO amo_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Asa utirino imonmong nanya lissaning, mma su. ");
INSERT INTO amo_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Andi udi nin su ning uma dortu uduka ning. ");
INSERT INTO amo_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Meng masu Ucife kucukusu, ame ma nimu umong unan bunu bara anan so nan ghinu udu sa ligang. ");
INSERT INTO amo_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Uruhu kidege. Na uyii wasa usereghe ba bara na udin yenjughe ba ana uyirughe ba. Anung, iyirughe, bara a sosin nanghinu tutun ama yitu nanya mine. ");
INSERT INTO amo_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Na nma sun minu usanminu ba; nma kpillu kiti mine. ");
INSERT INTO amo_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Nin kubiri bat, uyee ba kuru uyene ba, ama anung ma yenjui. Meng ma yittu nin lai, anung ma ti ulai. ");
INSERT INTO amo_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Lilone ima yinnu nworu ndi nanya Ncifning, anung yitta nanya nighe, ameng yitta nanya mine. ");
INSERT INTO amo_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ulenge na adi nin duka nighe amini din dortu unin, amere ule na adi nin sunighe; ame ulenge na adi nin sunig, Ucif ning mati usume, Meng mati usu me ndurso liti ning kiti me.” ");
INSERT INTO amo_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yahuda (na Iskaroti ba) woro Yesu ku, “Cikilari, iyaghari mati udurso litife kiti bit ana kitin yii ba?” ");
INSERT INTO amo_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu kawa aworoghe, “Andi umong di nin suu nighe ama dortu uliru nighe. Ucif nighe ma yitu nin suu me, arik tina dak kitime ti da so ligowe nanghe. ");
INSERT INTO amo_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ulenge na adi nin suu nighe ba, na adin dortu uliru nighe ba. Ulire na ilanza na unaghari ba un Cifere na anan tuyi. ");
INSERT INTO amo_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Ndin bellu minu ule ulire, a ndutu nanginu. ");
INSERT INTO amo_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Vat nani, unan bune, Uruhu ulauwe, ulenge na ucife matuu nin lissa nighe, ma dursuzu minu imon vat, imon ile na nna belu minu. ");
INSERT INTO amo_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Lissosin lishau nsun minu mun, Nna minu lissosin lisheu ning. Na ndin nizu nafo na uyii din nizu ba. Na iwa yinin ayi mine nana ba, a na iwa yinni ilanza fiu ba. ");
INSERT INTO amo_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ina lanza, nna bellin minu, 'Nma su ucin, nma kpilu kiti mine tutung.' Andi idi nin sunighe, iba su liburi libo bara ndin cinu ucin du kitin Ncif. Bara Ucife karin akatini. ");
INSERT INTO amo_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Nene nna bellin minu a idutu sa uti, asa imone nin ta ima yinnu. ");
INSERT INTO amo_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Na nma su uliru nanghinu gbardang ba, bara ugo nyii ulele din cinu. Na adi nin likara kitene ning ba, ");
INSERT INTO amo_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Uyii nan yinno Meng di nin suu Ncife. Ndin su imon ile na Ucife asa atayi nsu, nafo na ana nei uduke. Fitan, dan ti sun kiti kane.” ");
INSERT INTO amo_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Menghari na kuca napau kidegene, Ucif ninghari unan bilisue. ");
INSERT INTO amo_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Adin kaluzu kidowo nighe ko uyeme ulang ule na udin macu ba, adin kaulu vat nlang ule na udin macu unan kpina umacu. ");
INSERT INTO amo_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Anung di lau uworsu bara ulirue na nna belin minu. ");
INSERT INTO amo_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Son nanya ning, meng so nanya mine. Nafo na ulang wasa usu kumat usamme ba se udofin kuce, nanere anung wang, se iso nanya ning. ");
INSERT INTO amo_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Menghari litinoe; anunghari tilanghe. Ule na adi nin mi ameng ninghe, ame uleli unite masu kumat gbardang, andi na nin mi ba iwasa isu imon ba. ");
INSERT INTO amo_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Andi na unit nso nin mi ba, ima fillinghe a koto nafo ulang; anit ma pitiru tilanghe iti nla, tima juju kidowo. ");
INSERT INTO amo_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Asa iso nan mi, tutung asa uliru nighe nso nanya mine, tirinon imon ile na idi nin sue, ima su minu ining. ");
INSERT INTO amo_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nin nanere idin ti Ucif gongong, inan macca nono gbardang ikuru iso nono katwa. ");
INSERT INTO amo_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nafo na Ucife dinin suninghe, Meng wang di nini sumine; Son nanya nsu ninghe. ");
INSERT INTO amo_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Asa Idorto uduka nighe, ima so nanya nsuu nighe nafo na meng na dortu uduka Ncif nighe nmini naso nanya nsu me. ");
INSERT INTO amo_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nbelin minu ile imone liburi libo ning nan yita nan ghinu, lin min liburi libowe nan se ukulu. ");
INSERT INTO amo_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Uduka nighari ulele, iti usuu nati nafo na meng nati usuu mine. ");
INSERT INTO amo_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Na umong dinin suu ule na ukatin ulele ba, na ama ni ulai me bara adondong me. ");
INSERT INTO amo_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Anung adondong nighari adi idi su imon ile na nbellin minu. ");
INSERT INTO amo_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Na uma kuru nyiccila minu acin ba, bara na kucin asa yiro imon ile na Cikilari din su ba. Ncila minu adondong, vat nimon ile na nna lanza kitin Cifning, nna belin minu. ");
INSERT INTO amo_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Na anunghari na fere yiba, menghari nafere minu nmini na ni minu katwaa inan do idi macu nono, tutung nono mine so. Uso nane bara vat nimon ile na ima tirinu Ucif nanya lissaning, ama ni minu inin. ");
INSERT INTO amo_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ilenge imone ndin bellu minu inan su usuu nati mine. ");
INSERT INTO amo_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Asa uyii nnari anung, yinnon nworu una cizin unari menku. ");
INSERT INTO amo_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","In dafo anung anan yieari, uye wa yitu nin suu mine nafo anit me; bara anung anan yiere ba tutung Meng na fere minu unuzu nanya yie, bara ile imone uyie ma nari anung. ");
INSERT INTO amo_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Lizinon ulirue na nna belin minu, 'Na kucin katin Cikilari me ba.' Andi ina ti meng ku uniu, anung wang ima ti minu uniu, andi ina lanza uliru nighe, ima lanzu umine wang. ");
INSERT INTO amo_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ima su minu ile imone vat bara lissanighari, bara na iyiru ulenge na ana tuyi ba. ");
INSERT INTO amo_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ndafo na nna dak nda su nani uliru ba, na iwa di nin nalapi; ama nene na idi nin surtu ba bara kulapi mine. ");
INSERT INTO amo_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ulenge na a narii anari Ucif nighe wang. ");
INSERT INTO amo_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ndafo nna su nitwa nanya mine nanga na umong nsa su ba, na iwa di nin kulapi ba, ama nene ina yene, ikuru inarii umunu Ucifnighe ku. ");
INSERT INTO amo_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ile imone din tizu nani bara uliru nan kulo na udi nanya niyerte nduka mine, 'Inari mengku sa finu.' ");
INSERT INTO amo_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Asa unan bunue nda, ulenge na nma tu minu mum unuzu kiti Ncife, unnare, Uruhu kidegen, ulenge na una nuzu kitin Ncife, uma ti ushaida kitene nighe. ");
INSERT INTO amo_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Anung wang dinti nshaida bara idi ligowe nan mi unuzun cizunue. ");
INSERT INTO amo_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Nbelin minu ile imone bara iwa ti minu itiro. ");
INSERT INTO amo_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ima nutuzun minu nanya nilari nlira; kube din cinu kongo na alenge na ima molusu minu ma cissu idi su Kutelle katwa kacine. ");
INSERT INTO amo_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ima su ileli imone bara na isa yinno Ucife sa menku ba. ");
INSERT INTO amo_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Ndin belu minu ile imone bara asa kube nda na ima se, ima lizinu inin nin woru iyiziari nna belin minu. Na nna belinminu ubellenghe nin cizunue ba bara nwa di ligowe na ghinu. ");
INSERT INTO amo_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Nene nba du kiti nlenge na ana tuyi; vat nani, na umong mine ntirini ba. 'Udin cinu udu weri'? ");
INSERT INTO amo_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Bara na nna bellin minu ile imone, liburi lisirne nmal kulu nibinayi mine. ");
INSERT INTO amo_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Vat nani, nbeling minu kidegene; uma caunu minu meng nya; bara asa na nya ba, na unan bunue ma dak kitimine ba; ama nwan nya nma tughe kiti mine. ");
INSERT INTO amo_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Asa ada, unan bunue ma kpashulu uye nbeleng kulapi, nbeleng katwa kacine, nin beleng nshara. ");
INSERT INTO amo_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Nbeleng kulapi bara na ina yinnin nimi ba, ");
INSERT INTO amo_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","nbeleng katwa kacine. Ndin cinu ucin du kitin Cif, na ima kuru iyene tutung ba. ");
INSERT INTO amo_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","a ubeleng nshara, ina malu usu ugo nyii ulele ushara. ");
INSERT INTO amo_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ndin nin nimon gbardang na nma belin minu, na ima yinnu inin nene ba. ");
INSERT INTO amo_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Vat nani, asa ame Uruhu kidegene nda, ama dofunu ninghinu nanya kidegene vat; bara na ama su uliru unlitime ba, ama vat nimon ile na alanza, nanere ama belu, amaa nin pun minu imon ile na idin cinu. ");
INSERT INTO amo_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ama tii gongong, ama yiru imon ning a pun minu inin. ");
INSERT INTO amo_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Vat ligang nimon ile na Uci dumun. inaghari, unnare nbelle, Uruhu ma yiru imon ning ada pun minu inin. ");
INSERT INTO amo_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Nin kubiri bat, ima kuru iyene ba; nin kubiri bat tutung, ima kuru iyenei.” ");
INSERT INTO amo_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Among nono katwa me woro nadon mine, “Uyapin uliruari ulele na aworo nari, 'nin kubiri bat, na ima kuru iyenei ba; aminin woro tutung nin kubiri bat tutung, ima yenei,' tutung, 'Bara nma du kitin Ncifa?' ");
INSERT INTO amo_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Inin woro, “Iyaghari ilele a belle, 'Kubi cingiling'? Na tiyino iyaghari adin belu ba.” ");
INSERT INTO amo_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu yene idin shotu itiringhe, ame woro nani, “Idin tiru atimine ubelen nileli imone, nworu 'Nin kubi bat, na ima kuru iyenei ba; kimal kubi bat tutung, ima yenei'? ");
INSERT INTO amo_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Kidegenere, ndin belu minu, ima su kuculu nin lidurun, ama uye masu liburi libo, anung masu liburi lisirne, ama liburi lisirne mine ma kpinlu ayi aboo. ");
INSERT INTO amo_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Uwani asa asu liburi lisirne andi adi nin konu liburi kumat bara kubin nlolu me nda; ama asa amara gone, asa a lizino uniu me ba bara ayi aboo nworu imara gono nanya in yii. ");
INSERT INTO amo_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nanere anung wang, idi nin naburi asirne nene, ama meng ma kuru inyene minu tutung, ima ti ayi abo. ");
INSERT INTO amo_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Liri lole, ima sui umon utirinu ba, kidegenere, Ndin belu minu, asa itirino imonmong kitin Cif, ama ni minu inin nanya lissa ning. ");
INSERT INTO amo_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Udu da duru nene na isa tirrino imonimon nya lissa ning ba; tirinon, tutung ima seru, liburi libo mine manin kulu. ");
INSERT INTO amo_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Nsu minu ule ulire nin tinan tigoldo, ama kubi din cinu na nma kuru nsu minu uliru nin tinan tigoldo ba, ama nma na su minu kanang nbeleng Ncife. ");
INSERT INTO amo_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nloli lire, ima tirini nya lissa ning, a na nworo minu nba ti nlira kiti Ncif bara anung ba; ");
INSERT INTO amo_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ame Ucife di nin sumine, bara na anung di nin su nin, inani nyinna nin mi bara na nna dak unuzu kiti Ncife. ");
INSERT INTO amo_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nna dak unuzu kiti Ncif, nmini na dak nanya yii ulele tutung, Nma sunu uyei nma kpilu ndo kiti Ncife.” ");
INSERT INTO amo_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Nono katwa me woro, “Yene nene udin liru kanang; na udin liru nin tinan tigoldo ba. ");
INSERT INTO amo_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nene ti yinno uyiru imon vat, ana udin pizuru umong tirifi umong uliru ba. Bara nani ti yinna una dak unuzu kiti Kutelle. ");
INSERT INTO amo_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesu kawa nani aworo, “Nene iyinna?” ");
INSERT INTO amo_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Yenen kubi din cinu, nanere, nene kumal dak, na ima malu kiti, kogha mine udu kiti me, ima nin sunui Ussanii. Vat nani na nma yitu ussanin, bara Ucif ma yittu nin mi. ");
INSERT INTO amo_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nsu minu ulenge ulire bara nme inan se lissosin lisheu. Nanya nyie idi nin tinanayi, ama sen likara nibinayi, Meng na li likara nyie.” ");
INSERT INTO amo_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Meng Yesu nbelle ilenge imone, a ghantina iyizi me kitene Kutelle aworo, “Ucif, kube nda; ta Usaunfe gongong- ");
INSERT INTO amo_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","nafo na una nighe tigo kitene nanan tilai vat, bara anan na alenge na una nige ulai nsa ligang. ");
INSERT INTO amo_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ulai un saligaghere ulele: inan yininfi, fere cas Kutelle kidegen, a ame ulenge na una tuu, Yesu Kristi. ");
INSERT INTO amo_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Meng ntafi gongong in yie, na nna kulo katwa ka na unani nsu. ");
INSERT INTO amo_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Nene, Ucif, tye ngogong umunu litife wang nin nimus ngongon mongo na nwa dimun ninfi a uyie dutu sa ukye. ");
INSERT INTO amo_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Nna durso lissafe kiti nanit alenge na una ni nanyan yii. Inung anit fere, umini na ni inung, inani din dortu ulirufe. ");
INSERT INTO amo_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Nene inung yiru vat nimon ile na una nii, inan nuzu kitifere, ");
INSERT INTO amo_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","uliru fe na una nii, nna ni nani uliru une. Ina seru tining, inani na yinin kidegenere nna dak unuzu kitife, inani na yinin fere na tuyi. ");
INSERT INTO amo_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Ndi nani nlira, na ndi su uyii nlira ba, ama inung alenge na unayi, inung anit fere. ");
INSERT INTO amo_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Vat nimon ilenge na idi inang, in fere, imongfe inanghari. Meng ta gongon nanya ni ning. ");
INSERT INTO amo_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Na meng du nanya nyie ba, ama inung anit ane di nanya nyie. Meng din cinu udak kitife. Ucif ulau mino nani nanya lissafe inung alenge na una nii, inan so unit urum, nafo na arik di urume. ");
INSERT INTO amo_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Kube na nwa di nan ghinu, nwa ceo nani nanya lissa fe alenge na uwa nii; nwa kesse nani, na unit urum na wolu ba, se ame gonon nnanu, bara ulirufe nan se ukulu. ");
INSERT INTO amo_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Nene ndincinu udak kitife; ama ndin bellu ile imone nanya nyi, bara ayiabo mine nan se ukulu nati mine. ");
INSERT INTO amo_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nna ninani ulirufe, uyi na nari inung, bara na inung anan yieri ba, nafo na meng kunan yiere ba. ");
INSERT INTO amo_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Na ndi nlira ukala nani nanya inyieba ama u kesse nani nin nanan naburi asirne. ");
INSERT INTO amo_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Na inung anan yiere ba, nafo na meng kunan yieri ba. ");
INSERT INTO amo_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Kusu wesse nani nin kidegen, ulirufe kidegenghari. ");
INSERT INTO amo_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Una tuyi nanya nyii, meng uni na tuu nani nanya yie. ");
INSERT INTO amo_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Bara inung, meng na wesse litinighe, inung atimine wang nan se uwessu nanya kidegene. ");
INSERT INTO amo_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Na bara alele cas ndin su nlira ba, umunu alenge vat na ima yinnu unuzun liru mine. ");
INSERT INTO amo_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Bara inan so arume vat, nafo nafe Ucif, udi nanya ning, a meng yita nanyafe. Ndin lira inung wang yita nanya bite uyie nan yinna fere na tuyi. ");
INSERT INTO amo_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ngongonghe na una nii, nna nii nani unin, inung wang nan yita urum, nafo na arike di arum- ");
INSERT INTO amo_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Meng nanya mine, a fe nanya ning, inan se ukulu nanyan warume; bara uyie nan yinno fere na tuyi, umini dinin su mine nafo na udinin su ninghe. ");
INSERT INTO amo_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ucif, aleli na una nii wang. Ndin piziru inung yita nan mi kiti kanga na nduku, inan yene ngongong nighe, mongo na uwa nii: bara udi nin su nighe a i ditu sa ucizinun kye in yii. ");
INSERT INTO amo_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ucif katwa kacine, na uyii yirufi ba, ama meng yirufi, inung alele yiru fere na tuyi. ");
INSERT INTO amo_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nna durso nani lissafe, tutung nba ti nani iyinin bara usuwe na udi mun nan yita nati mine, meng wang nan yita nanya mine.” ");
INSERT INTO amo_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Na Yesu uleli ulire, a nuzu a nya nin nono katwa me a kafin kurawan kidiron, kikanga na awa piru nkon kunen ku, ame nin nono katwa me. ");
INSERT INTO amo_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Nene Yahuda, ulenge na awa cinu ulewughe, ame wang wa yiru kitene, bara Yesu wa duzo kiti kane ko kome kubi nin nono katwa me. ");
INSERT INTO amo_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Yahuda, na amal se ligozi na soja nin nadidya kiti ndya na Priest a Afarisawa, da kitime nin tila, tico a imon likum. ");
INSERT INTO amo_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu, ule na awa yiru nin vat nimon na idi sesughe, kata udu ubun a tirino nani, “Idin piziru ghari ku?” ");
INSERT INTO amo_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","I kawaghe i woro “Yesu Nnazaret.” Yesu woro nani, “Mere ame.” Yahuda, ule na awa lewu ghe, awa yissing ligowe nin na soje. ");
INSERT INTO amo_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Na aworo nani, “Mere” ikpilla nin kidung i deu kutyen. ");
INSERT INTO amo_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","A tirino nani tutung, “idin piziru ghari ku?” I kuru i woro, “Yesu Nnazaret.” ");
INSERT INTO amo_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu kawa nani, “Nworo minu mere ame; andi meri idin piziri, sunan alele i nya ucin mene.” ");
INSERT INTO amo_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Uwa so nani uliru nan kulo na awa woro, “Nalenge na una nii, na nna wultun unit urum ba.” ");
INSERT INTO amo_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Bitrus, ule na awa min kussangali, a shuku kunin a kowo kucin ndya na Priest kutuf ncara uleme me. Lissa kucine wadi Malkusari. ");
INSERT INTO amo_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesu woro Bitrus ku, “kurtuno kusangale nanya kuparin me. Kakuke na Ucif nani nan nwa sono kani ba?” ");
INSERT INTO amo_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ligozin na soje, a adidya mine, nin na didya na Yahudawa tunna ikifo Yesu ku i tereghe. ");
INSERT INTO amo_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Itu ido ninghe kitin Annas, bara ame wadi kumaran Kefas, ulenge na awa di udya na Prieste nloli likusse. ");
INSERT INTO amo_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Nene Kefasari ulenge na awa ni a Yahudawa ukpilizu nworu ucaun unit urum ku bara anite. ");
INSERT INTO amo_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Bitrus dofino Yesu ku, nanere wang nkang gono katwa we. Ame kani gono katwa we, udya na Priest wa yirughe, amini wa piru kuti nshara ndya na Prieste nin Yesu; ");
INSERT INTO amo_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Bitrus wa yissin kibulun ndas. Ame kani gono katwa we, na udya na Prieste wa yirughe tunna anuzu udas adi lirin nin kucin kuwani na kuwadi nca kibulunghe a pirna Bitrus ku nanye. ");
INSERT INTO amo_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Kucin kuwane na awa din nca kibulughe woro Bitrus ku. “Nafe umonghari nanyan nono katwa nnit ulelere ba?” A woro “Na meri ba.” ");
INSERT INTO amo_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Inung acine nin na dugari wa yissin kitene; iwa susso ula nin ticini bara tituwui wadi, inani wa di lanzu nla, Bitrus wadi ligowe nan ghinu, awa yissin nlanzun nla. ");
INSERT INTO amo_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Udya na Priest uni wa tirin Yesu ku ubellen nono katwa me nin dursuzu kiti me. ");
INSERT INTO amo_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesu kawa ghe aworo, “Nna suzu uliru kiti nanit kanang; Nna suzu uliru nanya niti nlira nin niti nilau, kikanga na a Yahudawa na da zurso ku vat. na nna bellu umon uliru likire ba. ");
INSERT INTO amo_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Inyaghari nta umini ntirini? Tirino alenge na ina lanzan imon ile na nna bellu. Anit alele yiru imon ilenge na nna bellu.” ");
INSERT INTO amo_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Na Yesu belle nani, umong nanya na dugari wa yissin kupo Yesu a tunna a rioghe nin cara me a woro. “Nanere uma kpanu udya na Prieste?” ");
INSERT INTO amo_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesu kawaghe aworo, “Andi nbelle imonimong nanzang, durson ni utanu nighe, vat nani andi nkawa gegeme, inyaghari nta umini reoyi?” ");
INSERT INTO amo_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Annas uni wa teccu Yesu ku a turunghe kitin Kefas udya na Priest. ");
INSERT INTO amo_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon Bitrus wa yissin nlazun nla. Anite woroghe, “Nafe wang umong nanyan nono katwa mere ba?” A nari ulire a woro, “Na meng di nan ghinu ba.” ");
INSERT INTO amo_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Umong nanya nacin Ndya na Priest na awadi fimus nin lenge na Bitrus wa kalaghe kutufe, wa woro, “Na meng niyenefi kunene ninghe ba?” ");
INSERT INTO amo_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Bitrus kuru anari ulire, kukulok tunna ku kolsuno mas. ");
INSERT INTO amo_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Iwa nya nin Yesu kitin Kefas udu kuti nshara. Nin kwui dindinghari wadi, na inung ati mine wa piru kuti nsharawe ba, bara iwa ti atimine ndinong, inan se ulin paska. ");
INSERT INTO amo_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Bilatus nuzu ado kiti mine, a woro, “kuyapin kulaperi idamun liti nnit ulele?” ");
INSERT INTO amo_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","I kawaghe i woro, “Ndafo na unit ulele unan katwa kananzanghari ba, na tiwa damun kitife ba.” ");
INSERT INTO amo_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Bilatus woro nani, “Yiranghe i nyamun idi sughe usharawe ussanmin dert ni duka mine.” A Yahudawe woroghe, “Na udi dert arik molu unit ba.” ");
INSERT INTO amo_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Iwa belin nani uliru Yesu na se ukulu, ulire na awa belin wa durso imusin yapin ukulari ama su. ");
INSERT INTO amo_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Bilatus kuru a pira kutin sharawe a yicila Yesu ku; a woroghe, “fere ugo na Yahudawe?” ");
INSERT INTO amo_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu kawa, aworoghe, “udin tiru bara litifere sa amonghari nbelin fi utirini?” ");
INSERT INTO amo_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Bilatus kawa, “Na meng Kuyahudawari ba, sa uyene ndi? Anan minfere nin dya na Priest nnakpa fi nacara ning; iyaghari unati?” ");
INSERT INTO amo_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesu kawa, aworo, “Tigo ning na tin nle uyiere ba. Nda Tigo ning tin nle uyiere, anan katwa ning wa su likum bara iwa nakpayi nacara na Yahudawa, anan Tigo ning na tina dak unuzun le uyieri ba.” ");
INSERT INTO amo_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Bilatus woroghe, “Ani fe ugowarie?” Yesu kawa ghe, “fere woro meng ugowari, bara nanere ina marui, bara nanere nna dak nanya in yie bara nnan na ushaida kidegene. Vat nlenge na ame un kidegenari din lanzu liwui ning.” ");
INSERT INTO amo_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Bitrus woroghe, “Iyaghari kidege?” Na a belle nani, akuru anuzu tutung ado kiti na Yahudawe a woro nani, “Na nse unit ulele nin kulapi ba. ");
INSERT INTO amo_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Idi nin tanda nworu nma sun minu kucin kurum nin kubin paska. Nene idi nin su nsun minu ugo na Yahudawe?” ");
INSERT INTO amo_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","I kuru ijarta nin tiwui kang I woro, “Na unit ulele ba, ama Barabbas.” Barabbas wa di ukiri udyawari. ");
INSERT INTO amo_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Bilatus yira Yesu ku adi kpizughe. ");
INSERT INTO amo_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","A soja pio imart i kyeghe litappa mun. I shono linin litin Yesu inin shonghe inin diuu. ");
INSERT INTO amo_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","I da kitime I woro, “Idin lissufi, ugo na Yahudawa!” Inin fighe nin nacara mine. ");
INSERT INTO amo_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Bilatus kuru anuzu a woro anite, “Yeneng, ndin cinu unutunu minu unite ndas inan nyinno nan seghe nin kulapi ba.” ");
INSERT INTO amo_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yesu tunna a nuzu; awadi nin tilapa nimart litime a imon iduwe kidowo me. Bilatus woro nani, “ Yeneng unite ule!” ");
INSERT INTO amo_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Na udya na Priest nin na soja nyene Yesu ku. I ta ntet iworo “Na ikottunghe kuca, na ikottunghe kuca!” Bilatus woro nani, “yiranghe ussaminu idi kotinghe kuce, bara na meng seghe nin kulapi ba.” ");
INSERT INTO amo_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","A Yahudawa kawa Bilatus ku iworoghe, “Tidi nin duka, tutung bara ubellu leli uduke, ucaun aku, bara na ata litime aso Usaun Kutelle.” ");
INSERT INTO amo_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Na Bilatus nlaza uleli ulire, fiu kpina jukifughe kang, ");
INSERT INTO amo_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","akuru apira kudarun sharawe tutung a woro Yesu ku, “Una dak unuzun nweri?” Na Yesu kawaghe ba. ");
INSERT INTO amo_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Bilatus kuru a woroghe, “Na uma lirunu nin ba? Na uyiru ndi ni likara nsunfi u nya nkuru nyita nin likara nti ikottun fi kuca ba?” ");
INSERT INTO amo_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesu kawaghe a woro na uwasa uyita nin likara litinin ba, andi na inafi unuzu kitene kani ba. Ulenge na a nakpafi meng ku katin nin kulapi.” ");
INSERT INTO amo_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Nin leli ukpinue, Bilatus wa pizuru nworu a sughe, ama a Yahudawa jartiza kang iworo, “Asa usuna unit ulele, nafe udondong Nkaisarari ba: Vat nlenge na ana litime tigo, adin nliru ule na Kaisar din lanzu nman nin ba.” ");
INSERT INTO amo_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Na Bilatus nlaza uleli ulire, anutuno Yesu ku ndas, aso kutet nshara kiti kanga na idin yiccu upaviment, nin ti Ibranaci lisse Gabbata. ");
INSERT INTO amo_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Liri nshirin Npaskari wadi, kusari nikoro kutocin. Biltus woro a Yahudawe, “Yeneng ugo mine ule!” ");
INSERT INTO amo_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ijarta kang i woro, Can ninghe, can ninghe; kottunoghe kuca!” Bilatus woro nani, “Meng kottin ugo mine?” Udya na Priest kawwa, “Na tidi nin mong ugo ba se Kaisar.” ");
INSERT INTO amo_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Bilatus kurtuno nani Yesu ku, idin ikottunghe kucan. ");
INSERT INTO amo_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","I yira Yesue ku, a nuzu udas, a yauna kuca ndi kottunu me usanme, ucindu kite na idin yiccu kin ku kankan liti. kanga na idin yiccu nin ti Yahudawa Golgota. ");
INSERT INTO amo_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","I kottuno Yesu ku kuca kikane, ligowe ninghe among naba, kolome likt me unit urum, a Yesu kitik mine. ");
INSERT INTO amo_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Bilatus yertine nkon kulap ndursu a bana kitene kuce. Iwa su iyerte nenge: YESU NNAZARET, UGO NA YAHUDAWA. ");
INSERT INTO amo_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Gbardang na Yahudawa wa bellu iyete ine, bara kite na iwa kottun Yesu ku kuce wa di susut nin kipine. Iwa su iyerte nin ti Yahudanci, ti Romawa a ti Helenawa. ");
INSERT INTO amo_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Udya na Priest na Yahudawe woro Bilatus ku, “Na uwa yertin 'ugo na Yahudawa ba' mbara uworo, ame na woro, 'Meng ugo na Yahudawari.'” ");
INSERT INTO amo_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Bilatus kawaghe a woro, “Imong ile na nyerti, nmal yerunari une.” ");
INSERT INTO amo_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Na a soja nkottuno Yesue ku, i yauna ugudun me i kosso uni niti ninas, ko kome kusoja nin kusari kitime; nanere wang kultukke. Kulutukke wadi nin tutun ku ba, iwa ke kunin sundulunghari. ");
INSERT INTO amo_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","I woro nati mine, “Na tiwa marya kunin ba, nbaa ira ti dinja timoku tiyene sa kuma so kunghari.” Uwaso nani uliru Kutelle na iwa bellin nenge nan kulo, “Iwa kossu tigudun nin nati mine, imon nin tutung i dinja timo ku.” ");
INSERT INTO amo_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Asoje wassu ileli imone. Unan Yesu, gwana nne, Maryamu uwanin Kilopas, a Maryamu Magdaliya- awanin alele wa yissin susut nin kuca nkottunun Yesu. ");
INSERT INTO amo_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Na Yesu yene unene nin gono katwa me na wadi nin sume yissin susut kupo me, a woro nna me, “uwani, yene, gonofe kanga!” ");
INSERT INTO amo_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","A woro gono katwa we, “Yene, unafe ule!” Nanya kubi konere nono katwa we wa yirughe ucin du mun ngame. ");
INSERT INTO amo_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Kimal nani nin yirun Yesu, nworu imon vat nmala, anan ta uliru Kutelle nan so kidegen, a woro, “Ayin kotoi.” ");
INSERT INTO amo_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","KItene lissu nmyen mi gbalala wa duku, I buro lissut likpu jangarang i shono nanya nmyen mi gbalale, i taghe nnuu. ");
INSERT INTO amo_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Na Yesu nciro nmyen mi gbalale, a woro “Imone nmala.” A tumu litime, a suna nfip me. ");
INSERT INTO amo_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Kubi nshiriari wadi, bara iwa sun nidowo kitene naca nkottunu liri na Sabbat (bara liri na Sabbat liri lidya wari), a Yahudawa tirino Bilatus ku nworu a yinnin nani idi pucu abunu na lenge na ibana nani naca, inan toltino nidowo mine kutyin. ");
INSERT INTO amo_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","A soja da ida puco abunu na le na ikotuno nani kuca ligowe nin Yesu. ");
INSERT INTO amo_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Na ida kitin Yesu, Ise amal ku, na i puco abunu me ba. ");
INSERT INTO amo_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Vat nani, nkon kusoja buro lipala me nin liyop, nmii nin myen nuzu kitene dedei. ");
INSERT INTO amo_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ulenge na ana yene ilenge imone, nati iyizi nba, iyizi nba me kidegenere. Ayiru nworu ulire na ana belli kidegenere, bara anung wang nan yinna. ");
INSERT INTO amo_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ilenge imone na se, bara uliru Kutelle nan kulo, “Na ina puru liku me ko lirum ba.” ");
INSERT INTO amo_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Tutung umong uliru Kutelle wa belli “Ima yenjughe ame ulenge na iwa burughe.” ");
INSERT INTO amo_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Kimal ni leli imone, Yusufun Armatiya, ame wang wa di gono katwan Yesu, ama nanya liyeshinbar fiu na Yahudawa, awa tirin Bilatus ku anan se ayira kidowon Yesu. Bilatus wa yinninghe mu. Yusufe da ada yira kidowo me. ");
INSERT INTO amo_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodimo wang wa dak, ame ulenge na awa tu ada kitin Yesu nin kitik. A wa munu nnuf Myrth nin aloes adamun, ngetek mini wa durun ngetek nimon ngucu kiti akalt likure. ");
INSERT INTO amo_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Inani wa yaun kidowon Yesu i tere nin kusu kuba kubo a nnuf kunya kumang, nafo utanda na Yahudawa andi ima kasu libi. ");
INSERT INTO amo_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Kitene na iwa kottunghe kuce kunen wa duku; nanya kunene kissek waduku kipesse kanga na iwa di isa kassa unit ku ba. ");
INSERT INTO amo_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Bara lirin shiriari wa di a Yahudawa, tutung kiti kisseske wa di susut, inani wa nonko Yesu ku nanya kini. ");
INSERT INTO amo_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Nin kwui dindin nwui un cizinu nayiri kuzor, a kiti dutu kalum kalum, Maryamu Magdalin da kiti kissekke; ayenne iyilino litala nnu kissekke. ");
INSERT INTO amo_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","A co ada kitin Simon Bitrus nin kanin gono katwawe na Yesu wa di nin suwe, a woro nani nenge, “Ina da yiru Cikilare ku nanya kissekke i nya mun, na tiyiru sa ina di nonkoghe nweri ba.” ");
INSERT INTO amo_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Bitrus nin kani gono katwawe nuzu udas, ido kiti kissekke. ");
INSERT INTO amo_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","I tunna ncum ligowe, kani gono katwawe katiza Bitrus ku nin cum a yaringhe ndi duru kiti kissekke. ");
INSERT INTO amo_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","A tumuno a gbino nanye; a yene ugudun ubome non kitene, ama na awdi asa pira nanye ba. ");
INSERT INTO amo_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simon Bitrus da kidun me a pira nanya kissekke. A yene ugudun ubowe non nanye, ");
INSERT INTO amo_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","nin nimon ile na iwa di litime, na iwa non kiti kirume nin nileli imone ba, inin wa jinkpilin ussanme ugan. ");
INSERT INTO amo_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ame kani gono katwa we wang pira, ule na awa tu a duru kiti kissekke; ayene ayinna. ");
INSERT INTO amo_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Uduru koni kube na iwa yiru uliru Kutelle nworu, gbas Yesu ma fitu nanya nanan kul. ");
INSERT INTO amo_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Nono katwa tutung nya ucin du nilari mine. ");
INSERT INTO amo_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Maryamu wa yissin ndas kisseske kuculu, na awa di kucule, a tumuno a gbino nanya kissekke. ");
INSERT INTO amo_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","A yene anan Kadura naba sossin nin nimon ibo, umong kusari lite a umong kusari nabune, kiti kanga na kidowon Yesu wa non ku. ");
INSERT INTO amo_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","I woroghe, “Uwani, iyaghari nta udi kuculu?” A woro nani, bara ina yiru Cikilari ning a nan yiru kiti ka na ina ceoghe ku ba.” ");
INSERT INTO amo_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Na a belle nani, a gitirno ayene Yesu ku yissin kitene, ama na ame wa yinnin nworu Yesuere ba. ");
INSERT INTO amo_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesu woroghe, “Uwani iyaghari udi kuculu mun? Udin pizuru ghari ku? Awa kpiliza nafo unan kye kunenari, a woroghe, “Cikilari andi ukalaghe kite, belli kika na uceoghe ku, Meng ma di yirughe in nya mun.” ");
INSERT INTO amo_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesu woroghe, “Maryamu” A kpila kidowo me a woroghe nin ti Yahudanci, “Rabboni” Unare, “Unan dursuzu niyerti.” ");
INSERT INTO amo_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesu woroghe, “Na uwa dudai ba, bara na nsa ghana udu kiti Ncif ba; ama can kitin nnuwna nighe u woro nani, nma ghanu udu kitin Ncif ning nin Cif mine, Kutelle ning nin Kutelle mine. ");
INSERT INTO amo_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Maryamu Magdalin uni wa da bellin nono katwa we, a woro, “Inyene Cikilare” amini nbelleghe ile imone. ");
INSERT INTO amo_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Na kulelen nta nwui une, lirin ncizunu nayiri kuzor a nibulun tursuzuno vat, kiti kanga na nono katwa we wa sossin ku bara fiu na Yahudawa, Yesu da ada yissina kitik mine a woro nani, “Sen lissosin lisheu.” ");
INSERT INTO amo_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Na a belle nani, a durso nani ucara me nin likot me. Na nono katwa we yene Cikilare, ayi poa nani. ");
INSERT INTO amo_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu kuru a woro nani, “Na lissosin lisheu yita nanghinu. Nafo na Ucife na tuyi, nanere meng to minu.” ");
INSERT INTO amo_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Na Yesu belle nani, a pene nani a woro nani, “Seren uruhu ulau. ");
INSERT INTO amo_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Alenge na ishawa nin kulapi mine, ishawari une; alenge na anung ceo alapi mine, alapi ane nsowa une.” ");
INSERT INTO amo_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tuma umong nanya likure, ulenge na idin yiccughe fibari, na awa di ligowe nanghinu kubin dakin Yesu ba. ");
INSERT INTO amo_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ngisin nono katwa we d woroghe, “tiyene Cikilare.”A woro nani, “Andi na meng yene nacara me kitin kottunu nikuse nceo licin ning ku, ikuru ceo ucara ning likot me ba, na meng ma yinnu ba.” ");
INSERT INTO amo_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Kimal nayiri kulir, nono katwa me wadi kutii, a Tuma yita ligowe nanghinu. Yesu da pira a kibulune tursuno, a yissina kiyitik mine, a woro, “Na lissosin lisheu yita nanghinu.” ");
INSERT INTO amo_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","A woro Toma ku, “Nakpa licinfe ududo kikane, yene ucara nin tutung; nakpa ucarafe, dudo likot nighe; na uwa yita nin salin yinnu sa uyenu ba, yinna.” ");
INSERT INTO amo_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toma kpana a worogeh, “Cikilari ning ni Kutelle ning.” ");
INSERT INTO amo_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yesu woroghe, “Bara na uyenei, umini in yinna. Anan mariari ale na i yene ba, inani nyinna.” ");
INSERT INTO amo_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Nene Yesu wa su imon izikiki gbardang nbun nnono katwa me. Imon izikiki gbardang, ilenge na iwa yertin nanya kubaga nliru ba; ");
INSERT INTO amo_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Ilengene na ina yertin bara anung nan yinna Yesu amere Kristi, Usaun Kutelle, bara asa iyinna, nmoti ise ulai nanya lissame. ");
INSERT INTO amo_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Kimal ni leli imone tutung, Yesu durso liti me kitin nono katwa me kurawan Tibariya; nanere awa durso litime. ");
INSERT INTO amo_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Bitrus wadi ligowe nin Toma ulenge na iwa din yicighe fibari, nin Nataniyel un Kan ana nya Galili, nonon Zabadin nin nan nono katwa Yesu niba ugan. ");
INSERT INTO amo_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Bitrus woro nani, “Meng ma du nkifuzu nibo.” I woroghe nenge, “Arik wang ma du nanfi.” I do idi piru uzirgin nmyen, kiti shanta na ikifo imonba. ");
INSERT INTO amo_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Na kitin shanta, Yesu yissina ngau kurawe, na inung nono katwa we wa yiru Yesuari ba. ");
INSERT INTO amo_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesu tunna a woro nani, “Uzaman, idi nin nimoimon in nlya?' I kawaghe, “Tidimun ba.” ");
INSERT INTO amo_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","A woro nani, “Ton imon in kifizu nibo mine ncara ulime nzirge, ima se imon.” Itunna ito imon nkifizu nibowe, na iwa yinin unutune ba bara ngbardang nibowe na iwa kifo. ");
INSERT INTO amo_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Gono katwa kanga na Yesu wa di nin suwe woro Bitrus ku, “Cikilareari” Na Bitrus nlanza Cikilareari, a kiro kidowo me nin gudun (bara na awa min imon icine kidowo me ba), amini wa tunnun a nyina nanya kurawe. ");
INSERT INTO amo_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ngisin nono katwa we da nanya nzirgin nmyene, (bara na iwa di piit nin gau kurawe ba, nafo abunu akut likure udi duru kutyen), inani wa di nwunu nimon kifizu nibo mine gbem nin nibo. ");
INSERT INTO amo_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Na iwa nuzu udu kutyen, iyene acalang nla kitene nin nibo a ufungal ku, kitene. ");
INSERT INTO amo_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu woro nani, “Daan nin nimon ibo na iworin kifu.” ");
INSERT INTO amo_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Bitrus do adi wunun imon nkifizu nibowe udu kutyen, gbem nin nibo inin akalt likure nin natat. Vat nin gbardang ni ninig, na imon kifuzue wa marta ba. ");
INSERT INTO amo_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu woro nani, “Daan ida li tyara” Na umong nanya nono katwa we wa se kibinayi ntiringhe, “feghari ba? Inung wa yiru Cikilareari ");
INSERT INTO amo_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesu da ada yirra ufunga a nakpa nani uni, umunu ibowe ku. ");
INSERT INTO amo_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Uleli uzurue utattari wadi na Yesu wa durso litime kitin nono katwa we kimal nfitu me nanyan kul. ");
INSERT INTO amo_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Na ileo tyara, Yesu woro Simon Bitrus ku, “Simon usaun Yuhana, udi nin sunighe kang ukati ulele?” Bitrus woroghe, “Nanere, Cikilari; uyiru ndi nin sufe.” Yesu woroghe, “Sulibya na kam ninghe.” ");
INSERT INTO amo_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Akuru a bellinghe unba, “Simon, usaun Yuhana, udi nin sughe?” Bitrus woroghe, “Nanere Cikilari, fewe yiru ndi nin sufe.” Yesu woroghe, Su libya na kam ning.” ");
INSERT INTO amo_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","A bellinghe tutung untat, “Simon usaun Yuhana, udi nin Su nighe?” Ayin Bitrus nana bara na Yesu ntiringhe untat,”Udi nin Su nighe?” A woro ghe nenge, “Cikilari, uyiru imon vat, uyiru kap ndi nin sufe.” Yesu woroghe, “Su libya na kam nighe.” ");
INSERT INTO amo_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Kidegenere, Ndin belu f, kube na uwa di gono, asa ushono imon udo kiti kanga na udi nin sun due; asa ukuno uta kukune, uma nakpu acarafe, umong shonfi imon a yaunfi adomun kiti kanga na udi nin sun due ba.” ");
INSERT INTO amo_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesu wa bellin nani, anan ta iyinno imus nkul ulenge na Bitrus masu, ati Kutelle gongong. Na amala ubellu nani, a woro Bitrus ku, “Dofini.” ");
INSERT INTO amo_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Bitrus gitirno, a yene gono katwa kanga na Yesu dinin sume din dortu nani- ulenge na awa sossin figirin Yesu kubin lii nimonli a woro, a woro, “Ghari unite na ama lewufi?” ");
INSERT INTO amo_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Bitrus yene ghe a woro Yesu ku, “Iyaghari unit ulele masu?” ");
INSERT INTO amo_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu woroghe, “Andi nfere acica uduru usa nighe, iyaghari nmyenfeku? Dofini.” ");
INSERT INTO amo_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Uliru une mala kiti nanya linuana vat, au na kani gono katwa we ba ku ba. A nani, na Yesu wa woro Bitrus a na kani gono katwa we ba ku ba, ame dei wa woro “Andi nfere a cica uduru usa nighe iyaghari nmyenfeku?” ");
INSERT INTO amo_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Amere gono katwa kanga na ana ni ushaida ni lenge imone, ulenge na ana nyertin ilenge imone, tiyiru tutung ushaida me kidegenere. ");
INSERT INTO amo_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Imonimong duku tutung gbardang na Yesu na su. Inda nafo ina yertu ining vat, nyinan nworu unin uyie litime na uwa se kitin ciwu nafa niyerte ile na iwa su ba. ");
INSERT INTO amo_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Kutankardan nburne kurka nan wan jertin fimu, Theophilus, inbellen katuawa karka na Yesu wa su akuru a dursuzo, ");
INSERT INTO amo_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","har kubi ko na iwa yirgye udumu kitene kane. Ulele wa di bayan urka na nono kaduro me nsere timap tirka na iba durtu na cara Ufunu Ulau nono kadura karka na fere. ");
INSERT INTO amo_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Arka na awa durso litime nin lai bayaqn nipama iniu me. Ata ayiri akut anas ndursuzuani me, tutung incin nbeliani nbelen kilari tigo Kutelle. ");
INSERT INTO amo_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Kubi kona awa ligowe nanghinu, anin woro nanin “na wa cin nanya Urshalime ba. Bar nanin son ca, na alkawali Imba ulena ana su minu mu na mani Ufunu Ulau kutelle nama su, na ina malin lanzu kitiningya. ");
INSERT INTO amo_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Yohanna wa su ubaptizima nin mmen, nin kidun ninnayiru baat Kutelle ma suminu ubastizima nin Funu ulau.” ");
INSERT INTO amo_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Kubi ko na iwa zuro kiti kirum, i tiringye, ''Cikilari, kome kubiari uba kurtunu Kilari Ugo Kutenlle?'' ");
INSERT INTO amo_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","A woroani, ''na ummunere iyini kubi nin kubiri kurka na Ucif kele bari likarame. ");
INSERT INTO amo_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Daana abenle uliru une, amini wa fita cindu kitene kane, awut kitene kane wantina nanin iyenju Yesu ku, udu wulu nizi mine. ");
INSERT INTO amo_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Dana anan nono katua wa din yenju udume kitene kane. Nya kube Among anit awa ba tin yisina kupopo mine nin na littuk aboo. Iwadi anan kadura Kutelleari. ");
INSERT INTO amo_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Umong worum nin woro, “Anuyge anan Galili bar yangyari indin yenju kitene kane na iwa isin idin yenju kitene kane ba! Nlon liri Yesu ulele ulena Kutelle yira gye ama dak ule uye tutun. Abakpilu nannya ulele na iyenegye adin cinu udu kitene kane.” ");
INSERT INTO amo_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Da na nono kadura Kutenlle kpila, nonon bazu inliru kutenlle kpinlla u-Urshalima unzu Kupara Olives urka na uwa susut un-Urshalimae. ");
INSERT INTO amo_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Da na isa, ighana ipira kuti kitene, kika iwa sosinku. Isan nnono kadure tone: Bitrus, Yohanna, Yakub, Andarawus, Filibos, Toma, Batamawus, Matta, Yakub usaun Haffa, Simon ku-zelot, and Yahuda usaun Yakub. ");
INSERT INTO amo_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Vat mine wa muna ati nafo warum inlira mu cancom. Nannya mine awani wa duku, Marayamu unan Isa nan nuane. ");
INSERT INTO amo_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nan nayirane Bulus nin fita nan nuana me anan yinnu sauye. Kubi kind anan dortu Yesu wadi anit likalt nin Na kuta bah kitene. Amino wa woro, ");
INSERT INTO amo_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Linuana nin ton tipinpin wadi kitenen Yahuda tona ugo Dauda wa yerti, uworsu. To ti pipingye Na dak kidegenghe, barna Ufunu Ulauwe Na belin Dauda ku a yertin. ");
INSERT INTO amo_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Aworo nanin awadi gono kata Kutelle nafo arik, amino durso anan ni vira Yesu inanin wakifo imologhe.” ");
INSERT INTO amo_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Nene unit une nase ukubu kitenen su ni vira ine Nin Nile ikube awa seru kunen. Amino wa diu kutin kika ne liburi me tutoo tijiye gonna ti nuzu udas timalakiti. ");
INSERT INTO amo_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Vat anit na idin nanya Urshalima lanza yeri segye, inanin na yicila lisa kitene imin mmi nin tilem na aramik bar kitenere umon na kukuo. ");
INSERT INTO amo_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ame Bitrus nin kuro woro, “In na yene ilemon na ina se Yahudaku idi nafo na Maizaburana belin ari, “na kilarime ku vat, na iwa cin umon kilari meba.”' iminin yene tuo tipipinnye na Dauda na nyertin tidi kitene Yahudere: 'Na umon yiru kutet me.'” ");
INSERT INTO amo_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Bara nanin ukamata ti fere ulena ama yiru kitu me (kutet Yahuda) ukamata unite di nan arik kubi kon Cikilari bite Yesu wa fere nari. ");
INSERT INTO amo_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Indian with tun kubi kana ame Yohana wa ti Yesu ku ubaptisema had udak kubi kana iwa hirigye Yesu ku kitene Kane. Unit ulena tima feru the AMA yitu ulena Ana yene Yesu ku kin nzime ayita nin lai nin kidun kulme. ");
INSERT INTO amo_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Barà nanin nono katua me nin gonna nin tisa anit a tiba. Umon lisame wadi Yusuf Barsabas, ulena Lisa me wadi tutun Justus. Unan ba wadi Matthias. ");
INSERT INTO amo_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Itaa nlira iworo, “Fe Cikilari, yiru nibinei nanit vat, durso nari nanya nawaba alele na ufere ");
INSERT INTO amo_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ayiru kiti nanyan nkaa katawe na Yahuda nacin ana ti kulapi amini naduo kika na kiduogye.” ");
INSERT INTO amo_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Inanin wa su mafeferu, Mathias leu ma feruferu amini wasuo urum nanya nanan kata Yesua. ");
INSERT INTO amo_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Nanaya wui une a Yahudawa wadin ubuki kusana (Upentakos) mine, anan yinu sauyenu wadi kitikirum nanya Urshalima. ");
INSERT INTO amo_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Nin kubi kwak ilanza ufunu likara inin lanza liwui unuzu kitene kana. Anit vat kikane na iwa sosin ku ilenza ukara liwuiye. ");
INSERT INTO amo_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Kikanere ntutun inin yene Ufunu Ulau kitene aniti mine nafo ula. Tilem ule so kitenen kogye, umon nanya mine nuzu ada kitenen litin nanan yinnu sanu. ");
INSERT INTO amo_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Vat mine kulo nin Funu Ulau, inin tinna bellu tipipin bgarden, nafo na Ufunu Ulau wa dursuzo nanin. ");
INSERT INTO amo_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Kubi kone, among Ayahudawa wa sosin nanya Urshalima iniydge wadi anan fiwu Kutelleri na iwa dak nitiniti gbardan. ");
INSERT INTO amo_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Dana ilanza liwui umosin ufun, anite tinna ipitiruno kidowo kiti kirum kikana anan yinnu sauyenu wadiku. lipitirin nanite wa su umamak bara kogha nanya na nananyinu sauyenu wadin belu tipipin mine. ");
INSERT INTO amo_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ilanza umamaki i woro nin na timine, ''Na vat alele na idin lire ina nuzu kusarin Galiliari iyiziari yinno to ti lembite? ");
INSERT INTO amo_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Vat bite tidin lanzu nanin liru nin ti pipinbite na ina maru nari mun, ");
INSERT INTO amo_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","among bite na nuzu kusarin Patia nin Midia au Elam, among nanya bite nuzukusarin Umesopotamia, Uyahudia, Cappadocia, Pentus nin Uasia. ");
INSERT INTO amo_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Kikane among anit wa nuzu kusarin Firizia nin Panfilia, Umasar nin kusarin kagbirin libia idadas nin kagbirin Cirian. Kikane among bite amara Urshalima unuzun Roma. ");
INSERT INTO amo_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Umunu nin na Yahudawe, au a Yahudawa na ina yinin nin nilemong na arik a Yahudawe yinamung. Among bite nuzu kusarin Island na Krete nin kusarin ka gbirin Arabia. Bari yan-aarin ta ale anite din belu tipipin bite kitene nilemong na Kutelle nasua? ");
INSERT INTO amo_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Anite wa lanza umamaki na iwa yininin yari neba itin na tiru natimine “Ile imone yaria?” ");
INSERT INTO amo_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Among many mine imagining wish nanin lninworo, “Ale white din lirunafo isono intoro moninmolo naninkan!” ");
INSERT INTO amo_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Bitrus fita alirina kan aworo anan lipitin; nanite, “Anin anan Yahudia nin nalenaisosin in Urshalima, ma Latiszannin vat mine, ima benlinminu ilemong idin yenju. ");
INSERT INTO amo_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Among nanya mine din du untoro molo nari nanere ba ai nene kubi karfe tarari nin kudin, anit alele sonon utoro nin kokubi nin lolire ba! ");
INSERT INTO amo_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Bara nanin elemon na iyene kiti bite ina malin yertinu ku annabi Joel na belin uworu. ");
INSERT INTO amo_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Kubi nayiru nimalin gye, Ima niUfunu Ulau kiti nanite vat, ason nin na shono mine ma belu anite kadura ningye, Inani anyana mine uyejun, akune inma ninanin amoron yenju kiti. ");
INSERT INTO amo_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Kubi nayira ne ima ni Ufunu Ulau kiti nono nin, inan bele anit tipipin nin. ");
INSERT INTO amo_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Imati imong idiya ti kitene kani, nin kutin idurso minu imong icine naimase. Kikane kutin, mmi nin ula nin cin vat niti. ");
INSERT INTO amo_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Kite kane ma ti uwui uti bibit kiti na nit nin pui uti ushine nafo kiti mine. Umong ine mati ma innin dak ida, Men Kutelle manin dak ida su mawusuwusu. kitin konyge. ");
INSERT INTO amo_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Iminin ma tucu anit alena idin yici in bin nanin.'” ");
INSERT INTO amo_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Bitrus tin alau ubin in lire,”Nuana nin a Iraila latizani! Kubi kona Yesu nazaret wa di nan yginu Kutelle na dura minu amere na tuu gye a su matiza ma zikiki mane maana maanaduro amere KutelleAnin natimene yiru nin limo umongye kidene. ");
INSERT INTO amo_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Nin nanin iyiru, anin gyere na nakwa Yesu ku kiti nanan ni vira me. Nin nanin Kutelle na malin yinu mu, amini yiru nin nimone. Inin taa anit alena iyiru nin udoka Kutelle ba anan molo Yesu ku. Inani wa kotin gye akusa kite kuca. ");
INSERT INTO amo_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Amini na kuu, Kutelle na feagye tutun, bara nanin ukul wagya kifo gye kutinba. Kutelle nati Yesu afita tutun. ");
INSERT INTO amo_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Tuntuni ugo Dauda na yertin kitenen Missiah aworo,”In yiru fewe ku Kutelle, uma lanzi kokome kubi, idi kusa nin mina ima lanzu infiu na le na iin su ivira nin mi ba. ");
INSERT INTO amo_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Bara nanin kibinai nin ma ti pau, konin kul nin, inyiru uma buni. ");
INSERT INTO amo_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Uma cini kikana anan kule diku ba. Na uma kuru cin kidawo nin bijuba, bara idi ni fi nin dortu fi nin su ubiyanya' ");
INSERT INTO amo_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Una malin benle tibou tona ima dfunu ina taa ulai tutun. Umati kibinai nin ti paubara udi nin me sa ligan. ");
INSERT INTO amo_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Nuana, nwasa nlira nanghinu sa fiu kitenen kaa bite Dauda: awa ku ikuru ikasaghe, kissek me di nanghirik udak kitimone. ");
INSERT INTO amo_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Bara nani, awadi gono katwa Kutelleri ayiro nwo Kutelle wasughe issilin, nworu ama ceo umong nanya fisudu me kitenen kutet tigo. ");
INSERT INTO amo_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Awa yene ile imone, alira nbellen fitun Kristi nanya nkul, 'Na iwa shawa ninghe nanya kisseke ba, ana na kidowo me wa yene ubiju ba.' ");
INSERT INTO amo_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Nin kidun ame Yesu na kuu. Kutelle na fegye tutu. Vat arik anan dortu gyer, tiru mung bara tina yeneyge. ");
INSERT INTO amo_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Kutelle na Yesu kutet kudiya amini na ce gye incara ulime me asu ti goo nin Cife. Amini na niri Ufunu Ulau unere taa idin yenju nin lan ze. ");
INSERT INTO amo_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tiyiru kap Dauda wadin liru litimere b, bara ame Dauda na duo kitene ba nafo Yesu, nin nanin wang. Dauda litime na be3ling uliru kitene Yesu amere Missiah. Cikilari Kutelle na bwabelin Cikilari nin Missia, su tigo in cara ulime nin ");
INSERT INTO amo_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Ma inin kata likara nanan ni vira nin.” ");
INSERT INTO amo_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Bitrus nin mala uliru me aworo,”idinin suo iyini vat a Israila Kutelle nati Yesu ku asuo Cikilari nin Missiah, Yesu unere ulena iwa kotinyge ti kusa kitene kuca inin mologye. ");
INSERT INTO amo_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Dana anite lanza elemon na Bitruse nin nanan kadura benle, iyino ita kulapi, inin woro nanin iyeri tima ti nene? ");
INSERT INTO amo_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Bitrus nin kwana nani, vat mine icin kulapi min, Andi iyinna nin yise tima su minu ubaptizma. Kutelle ma ma yashu nin kulapi mine, ani niminu Ufunu Ulau Me. ");
INSERT INTO amo_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Kutelle na malin su likawali amanimunu har nin nono mine nin na nela iyina nin Yesu nin nalena idi pii kusari kikane. Cikilari bite Kutelle mani Ufunu Ulau nin na lena a yicila gye uniti me. ");
INSERT INTO amo_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Bitrus wa liru kang kiti mine, Anin woro nanin “Tirinon Kutelle anan shawa yapeminu bara awan nimunu kikanci nafo ale anite na inanari Yesu ku. ");
INSERT INTO amo_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Anite na iwa yinin sa yenu nin liru Bitrus iwa ti ubaptisma. Anan yinu sa uyenu kpina kan har timui ti tat, 3000 unwui une. ");
INSERT INTO amo_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Eliu ubun nanya indurtu nilemon na iwa dueso nani. Iwa din ga uzursuzu kookome kubi inin namong anan yinu sauyenu kikane ici liu emonli ligowe nin nin ti lira ligowe kiti kirem kolome liri. ");
INSERT INTO amo_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Vat anite na iwa din nanya Ushalima ifio kifo nanin nin kata ka zikiki na almajaraye wadin sua nin lisa yesu. ");
INSERT INTO amo_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Vat na rika na iwa yinin warsu ko nyan ligowe. Inin leu ubun kosusu nin ligawe. ");
INSERT INTO amo_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Unuzu kubikubi kogha lese anen me adasamu kiti nanan katawe. Nin nimong ile na kogha nadimun ");
INSERT INTO amo_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ko kishi iwa din zursusu kiti lira kikaneIwa li umonli ligowe ni picu nilari nilari. kubi kona isu nanin ni binai mine taah pau lanza man ini niza ilemong na kogha diman lgowe. ");
INSERT INTO amo_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Dana su nani, ie ubung zazunu Kutell. Nin nanin vat anit Urshalima nananin ubagirma kubikona imong ine wa linbub ghe anan biye kwina kang kolome liri bara use utucu kusari kulapi mine. ");
INSERT INTO amo_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","In lon liri Bitrus nin Yohana wa cinu udu kiti lira kubin nlir, kubi nikoro ku tiri. ");
INSERT INTO amo_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Umon unit wa duku urika na iwa marigye sa ucin tun umari m, ko lome liri asa iyirogye i ceinge kibulun nlira kika na idin yicu kibulun kicaut bar ana dinga usu likura na rika na ida kuti lire. ");
INSERT INTO amo_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Dana a yene an Bitrus nin Yohana cin piru kutin lira asu anin kuculu usadak. ");
INSERT INTO amo_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Dana Bitrus nin Yohana yene gye iworo gye “yene nari” ");
INSERT INTO amo_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Nin nani ayene nanin nizimine, awadin su ini gye i kubu, ");
INSERT INTO amo_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Nin nani Bitrus woro nin gye, ti dini ni kubu ba bara nanin tima nifi ilemong na timu, nanya lisa Yesu in Nazareth shino. fita ucinu”! ");
INSERT INTO amo_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Nin nanin Bitrus nin kifo unite nin cara ulime anin bungye anan fita, kubi kone, abunu inuteta likara ");
INSERT INTO amo_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Anin nyina atina cin! Anin pira nanya kuti lira ligowe nan Bitrus nin Yohana, cin nin kentu nin su Kutelle ku liru. ");
INSERT INTO amo_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Vat anit nanya kuti lirayene itina su liru Kutelle. ");
INSERT INTO amo_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Iwa yinin amere unit ulena asa sua kibulun kilau kane kutin lira, asa cin tiro ikubu! Nin nanin anit vat kikane laza umamaki nin limon na iseghe. ");
INSERT INTO amo_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Dana a mbun Bitrus nin Yohana ku anite co udu kibulun kona iwa din yicu Solomon's porrch. ");
INSERT INTO amo_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Dana Bitrus nyene, nanin a woro nanite “Anun anit Isriala bari yarri idun mamaki? Bara yan angari idina arikiku iyiza nafo arikere ti ta ashino nin likara bit, amini din cingye? ");
INSERT INTO amo_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Tima bilin minu ilemong na ita a nanin, Akune bit umunu Abraham k, Ishaku nin Yakub, wa su liru Kutelle ku. Nene Kutelle na antin Yesu ku kan Adide mine na danin Yesu ku kititn igoveno Pilate, asoje nan su gye ti kanchi. Ani gere na nari Yesu ku mbun Pilate k, nin kidun na Pilate ani cina ucin Yesu ku, ");
INSERT INTO amo_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Vat ninani ame Yesu wa di Kutelle Misaiah nanan Israila. Unan sali kulap, inanin watirin unan molsu nanit icinge imemoku me! ");
INSERT INTO amo_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Kutelle na yinin ani na molu Yesu ku Ame na anani anite ulai sa ligan. Bara nain Kutelle nfegye ata gye ulai tutun. Tina yene Yesu ku nin lai inuzu na yiri gbar dan na awa tighe nin lai tutun. ");
INSERT INTO amo_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Nene barna ule unite yina nin Yesu unere ta ataa likara tutun amini wa gya acina in bunmi ne vat. ");
INSERT INTO amo_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Nene, nuanani kagbiri karu, in yiru anin nanan nadide mine na malu Yesu ku nin tanni, amere wa di Misiah. ");
INSERT INTO amo_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Vat nin nani, Kutelle wa belin tutuni ubelen nari Yesu nin molugye. Kutelle wa belin a Annabawe i yertin ilemon na anite ma su Misiah ku. Inani wa yertin ame Missiah ulena Kutelle ma tuu gye ma sonu tikanci anin kuu. ");
INSERT INTO amo_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Bara nanin suna umon inazan ini tirin Kutelle ku abun minu isu isu ilemona na ima ti gye alanza mang, bara anan naminu utucu ayepe kulapi mine, kikane ama nin timinu likara. ");
INSERT INTO amo_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","An di isu nani, kubi mayitu na imanin yinnu Cikilari Kutelle din buzunu minu. Nlon liri tutun ima tuugye nanna iye ame Misisia, ulena anan niminu. Ame unit ule Yesu. ");
INSERT INTO amo_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Yesu ma soo kitene kane udu kubi kna Kutelle ma ti ilemon na ana kelle iti ipes, Kubin worsu Kutelle na tii nani, amini na fere ku ananbi kulau abenlin anite. ");
INSERT INTO amo_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Nafo annabi Musa na belin imon kitene Missiah: “Cikilari Kutelle fe ama tuu ku ananbi nafo mmen nanya mine. Ima lanzu ilemon na ama benlinminu. ");
INSERT INTO amo_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Alena inari ulazu ku annabi kone inin durtu gye na ima suo nono Kutelle ba, Kutelle ma molu nanin ");
INSERT INTO amo_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Bitrus nin leu ubun,”Vat a aannabawa wa belin ilemon na ima se kitimone. A annabawa ane umunu Samuilanin vat na lena ina dak nin kidun iwa belin kitene nile imongye ma yitu nanin. ");
INSERT INTO amo_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Kubi ko na Kutelle na su ualkawali amma su achif bit mmari, amini na su alkawali ama su anigye ma imari. Amini wa benlin Abraham kitene kite Missiah,”In ma ti anit vat nanya iye bara ilemong na anit mine ma su,” ");
INSERT INTO amo_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Bitrus nin malzinu,”Bar nanin Kutelle na tu Yesu ku nanya iye anan su kata Missiah, Awa tuu nin funu a Isriala i su minu ");
INSERT INTO amo_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Nin nanin among aprist wa dik nanye kutii lirama. Among anan yenju kutilira, au among a Saducee mine da kitin Bitrus nin Yohana kubi inin na biye iwa din liru kiti na nite. ");
INSERT INTO amo_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Inung ani wa lanza ayi kan bara ana kadura yesu wadin liru kitenen Yes. Elemon na iwadin belu nanite Kutelle na fea Yesu unuzu kiti nanan kul amin natigye ulai tutun nikidun na iwa molugye. ");
INSERT INTO amo_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Bara nanin anit ane tinna ikifu Bitrus ku nin Yohana inin taa nanin kuti licin. Ayahudawa anan anan kataa kuti mawucuwucu ini son ca ukun isuu nanin matirutiru bara kulelen wadi kumali dak. ");
INSERT INTO amo_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Nin nanin wang, among anit gbardan na ilanza uliru Bitrus itin yinna nin Yesu. Anan alena yinna nin Yesu iwa duru anit timui titawn 5000 ");
INSERT INTO amo_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ukurtunun kuinye ku prist kudewe yicila adide na prist nin na don kate mine pitirno ati mine kiti kirum kuti ma wucuwucu mine nanya Urshalima. ");
INSERT INTO amo_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anas nkong ku prrist kudya na awa di, awa di kitene. Kitewan Kayifas ku Prist kud, Yohana nin Alexzanda, nin namong na iwadi linwana nin na prist adia. ");
INSERT INTO amo_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Inin taa anan sun ca we inutun Bitrus nin Yohana udu kuti, inin tirino Bitrus nin Yohana, “Ari naminu lo lgangye idin su kataa kane?” ");
INSERT INTO amo_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Dana Ufunu Ulau na Bitrus ku likara kibinai anin woro nanin,”Nin nwuananin aIsraela na min nari, nin vat mine akune latiszanin! ");
INSERT INTO amo_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Kitimone idin tiru nari kitene nimon icine natisu kitin nut une awany acina ba, inanin tirino iyizari ashino. Bara nanin nan belin minu nii vat a Israela elemone. ");
INSERT INTO amo_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ai nanya lisa Yesu in Nazarerh unit ule na shi mu, har amini wangye ayisina ibung nine, Ai anugyere na kotun Yesu ku tikuse kitene kuca inanin na molugye. Vat ninanin Kutelle na fegye amini dinin lai tutun. ");
INSERT INTO amo_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu Kriste Nazereth amere litefe idin belu kitene me.''Litala lona anan ma kekewere na nari liso litala licine makekewere,” ");
INSERT INTO amo_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Amere ces ma su nari utucu, Kutelle na ni nari umong nanya ba ulena ama su nari utucu bite kiti nalapi ba!” ");
INSERT INTO amo_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Adide naYahudawe yene usalin feu kiti nan Bitrus nin Yohana. inin yene anit awa be na ina duo kiti madursuzu ba, bar nanin iwa lanza umama ki nin yginu kan. kikane inin yinno anitane nadi ligowe nin Yesu. ");
INSERT INTO amo_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Inanin wayene unit ulena iwa shin nin gye di ligowe nin Bitrus nin Yohana iwa dira imong kulap mine. ");
INSERT INTO amo_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ayahudawe woro nono caa kuti mawusuwusu mine inutun anBitrus nin Yohana nin lena ishinyge udas kutiye kikana idin zursuzuzu. Nin kidun na isu nani, adidewe lirina nin na timine kitene Bitrus nin Yohana. ");
INSERT INTO amo_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Inin woro,''No imong duku na ima ti nari fuo ale anit awa be ba! ko gha na asosin nanya Urshalima yiru nin nielemong na isu idi zikiki kan, bara nanin na tiwanya ti benlle anit elemone taa ba. ");
INSERT INTO amo_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Bara nani, natima cinu anit lanza ilemong na idin dursuzu anit kitene Yesu lii ubung ba, bara nanin tima benlu nanin tima bkwiuzu nanin andi ilau ubun i durzusu anit kite lisa ilena ina ti nanin likara shinu init ulele. ");
INSERT INTO amo_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Nin nanin a dide na Yahudawe imini wa woro anan suncaa kiti wucuwucu anit awa bia nanya kiti tutu. Nin kidun dana anan ugade su nanin inin benle nanin na iwa seke ulirinu kitene Yesu kiti kogya ba. ");
INSERT INTO amo_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Nin nanin wan Bitrus nin Yohana woro,”Udi gegeme kiti Kutelle ti dofin minu sa ti dofun Kutelle?” Tima cin minu iyene ilemon na idi gegeme. ");
INSERT INTO amo_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Arik kusari bit tiwangya dofun minu ba. Natima cinu ubelu nanit kitene lisa Yesu ba nin nilemong nasu natina yene nin nilemon latisza ilemong na ana dura.” ");
INSERT INTO amo_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Dana iadide na Yahudawa tutun benle an Bitrus ku nnin Yohana na iwa dira lazun lirumine b, inin yinna na ima kpizu nanin b, bara vat anit Urshalima wa di zazinun Kutelle ku bara imerika na iwa su kiti nuti ulena awangya cina ba ");
INSERT INTO amo_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Unite wa kalin akus akut ana. Na awa yinin ucin ba tun kubi maru me. ");
INSERT INTO amo_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Nin kidun Bitrus nin Yohana cino kuti mawucuwucu na Yahudawe, inin gya udu ki namong anan yinu sa uyenu inin bele nanin elemon na aPrist nin dide na Yahudawa benle nanin. ");
INSERT INTO amo_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Dana yinu sa uyenu lanza nanin. inin yina vat mine itin kitikru nin ta lira ligowe,”Uci, fere na kea kitene kane nin kutin nin kurawa nin nimong vat nenya mine. ");
INSERT INTO amo_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ufunu Ulau nin taa acif bit, Ogo Dauda ulena ana sufi kata, amini na yertin ti pipintone. Bar yari anit nanya iye lanza ayi nin nanan katafe, nin na nit Isreala isu kata kananzan kiti Kutelle? ");
INSERT INTO amo_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ugo iye munu ati ifuo anan wucuwucu Kutelle, nin na go munu ati mine inin su mavira nin Kutelle nin le na una fere a suo Missiah. ");
INSERT INTO amo_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ai kidenere umunu Heridus nin Bilatus ligowe nin na mong na idi a Yahudawaba nin na nit Israela na iwadak kagbiri kane na ina su ivira nin Yesu. Ulena ana yinin asua Missiah. ");
INSERT INTO amo_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Inanin yinin ilemone se bara ina malin yinu uworsu ima sieh.” ");
INSERT INTO amo_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","To nene Uci, lanza ulemong na idin belu ima su nrin tikaci nari, buno nari arik alena ti ma su kata Yesu udu kitin kogya! ");
INSERT INTO amo_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Suu kata nin likara fe usu kata kadiye ishizunu, nin nimong izikiki nanya lisa Yesu kucin fe. ");
INSERT INTO amo_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Dana anan yinu sauyenu mala utin lirakitene naiwadiku zunluno kidayo kan. Ufunu Ulau we nanin likara lirinu sa ulazun fiu, nin nanere iwann su. ");
INSERT INTO amo_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Imgbardan na rike na ti yinna nin Yesu tiwa yining nin elemong na ina durso nari elemon na idinsue. Na warum mine nworo imong ile na adimung in mere. Bara nanin idinnin kosuzu imong mine ilemon na idimung. ");
INSERT INTO amo_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Nin nanin likara nono kadura belle imon irika na iyine inbellen fitun Cikilari Yesu nkkune kune uduia yita nati mine va. ");
INSERT INTO amo_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Among nanye nanan yinu sa yenu na dizimun nimon nin na nen lese imongye. inanin wa dasu nin ikubu na neene kiti nono katawe. ");
INSERT INTO amo_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Nono katawe wa nin nii ikubuwe kitin nanayinu sauyenu lena adimung ba. Bara nanin vat ananyinu sa uyenu se ilemong na idinin suwe inan se ulinbung. ");
INSERT INTO amo_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Umong unit wa diku lisame Yusufu, unzu likuran lawi. ulena awa nuzu kusarin Island in Saiporos. Iwa din yici gye Barnabas umaana lise au, nin ti Yahudaci, unan tii kibinai na mong tii likara kang. ");
INSERT INTO amo_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Amini wa lewu kunenme amini wa danii nono katawe inan naa ananyinu sauyenu. ");
INSERT INTO amo_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Nanin umong wadiku unan yinusa uyenu lisame wadi Hananiya nin wani me Sarfatu. Amini wa lewu kunen me. ");
INSERT INTO amo_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Amini wa ceu imong ikubu ilena alewe kunen gye. anin daa nmin kagisingyekiti nono kadura. Uwani me wang wayinin asuu nanin, ");
INSERT INTO amo_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Bitrus nin woro gye. “Hananiya bara yangyari shetan pira kibinai fee uminin taa Ufunu Ulau kulapi. bari yangya ri taa uminin su imong ine? Uceu imong ikubu kitife kitene ni lemon na ulewe kunen fie na una nari ikube vat baa. ");
INSERT INTO amo_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Kubi na iwadi isa lewe kunene ba, kunfere wadi ba? Na una lewe, na ikube wadi nacara fere ba? Ani bara yangyari taa uma su imong inazan ilele? Aina arikari urusuzo nari ba, Kutelle ri udi cinu urusuzu gye. ");
INSERT INTO amo_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Dana Hananiya lanza timape atin na adeu kutin akuu camcam. Vat alena ilanza ilemong na ise Hananiya ku tin ilanza fiu kang. ");
INSERT INTO amo_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Uzaman tina idaa iyira libe idikasa. ");
INSERT INTO amo_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Kubi nikoro itat ame uwani me pira, na awa yiru ilemong na ise ba. ");
INSERT INTO amo_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Bitrus nin nuna gye ikubu ilena ulesume damun anin tiringye.”Benli, ligang nikubere ina lewu kunengye? Aminin wa belin nenere ilemong na tina lewu kunengye. ");
INSERT INTO amo_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Bara nanin Bitrus nin woro gye,”vat mine suu imong inanzan! Anin na bea, yinna irusuzu Ufunu Ulau Cikilari! Lanza! ulanza ucin nazamang alena inuzu kasu cikilari fea? idin das kibulun gye, ima yiru fii udu das tutun. ");
INSERT INTO amo_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Nanin molu kubi ba Sarfatu tin na adiu kutin libe na bunu Bitrus. Angyene pira yene gye adio libe tutun iyira libea itin idi kasu kupopo kisek lese. ");
INSERT INTO amo_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Vat anin yinu sauyenu nanya Urshalima laza fiu kang, bara nilemong na Kutelle su Hananiya nin Sarfatu ku. kogya na lanza ile imongye lazan fiu kang. ");
INSERT INTO amo_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Kutelle suu kata ka zikiki nanya na cara nono kadura me ninin anit yino kidere ilemon na iwa din dursuzu anit. Vat ananyinu sa uyenu tinna tina zursuzu kolome liri nanya kuti lira kika na idin yici nin lisa Solomo perch. ");
INSERT INTO amo_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Vat anite alena iyina nin Yesu ba lanza ifeu anan yinusauyene. Bara nanin anit alele leu ubun lanzu fiu nananyinu sauyenu. ");
INSERT INTO amo_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Among anit nin awni tin na iyina nin Cikilari Yesu, inin munu atii nin nananyinusauyenu. ");
INSERT INTO amo_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Bara nanin taa, anite tinna dasu nin na tikunu kitene libau danna inin nonkuzo nanin kupia nin nanin andi kuyulin Bitrus na dudo nanin inan shino ti konumine. ");
INSERT INTO amo_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Anit gbardan nuzu ni gbirin Urshalima daa kiti nono kata. Inanin wadasu nin nanan tikonu kiti minenin nalena ufunu na gwerganu kifo nanin. Kutelle mini wa shin nanin tikonu mine. ");
INSERT INTO amo_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Aprist adidewe vat nin nale na iwadi ligowe nin na Sandikiwa iwa di ligo mine inin lanza ayi nin nono katawe. ");
INSERT INTO amo_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Bara nanin inin taa anan sun caa kiti lira ikifo nono kataa we inanin watii nanin nanya kuti licin. ");
INSERT INTO amo_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Nin kitik anan kadura Kutelle daa atina apuno kiti licin atina anutuno nono Kutelle nutuno nanin das! nin nanin unan kadura Kutelle woro ");
INSERT INTO amo_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","nono kadure, “can udu kiti lira ibeling anite kadura tucu lai usalin ligang. ");
INSERT INTO amo_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Nin lanzu nanin itinna ipira nanya kutin lirainin tin na dursuzu anit kitenen Yeesu tutun. Nin nanin ku Prist kudiawe nin na lena iwa di ligowe ipitrino a Yahudawe. Ligowe nin na dide na Israila. Nin kidun na ipitirino ligowe, inin tuo apolise kuti licingye inan nutuno nono kadure. ");
INSERT INTO amo_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","A me ulena awa di unan kutii licin gye yene nono kata we dikub. Nin nanin intin ikwilla udu kiti na didemine ulire. ");
INSERT INTO amo_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Ti yene kuti licin wa kunlun kan anan sungadi wa yisin kitiy. Vat nin nanin dana tipira ti kifo anit ane tinanin se kutiye mmpono tinanin dira nanin kuti licin gye. ");
INSERT INTO amo_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Dana ude na kaptin kutii lira nin na Prist lanza nani, inanin wa nibinai mine tin na ni bunkurno, ilanza umamaki iyizari imon ne mati nanin. ");
INSERT INTO amo_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Umong nin da ada belle nanin “latizani! ai nene anit ane na ina ti nanin kutii licingye inanin yisin nanya Kutin lira inanin din dursuzu anite. ");
INSERT INTO amo_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Nanin ukaptin bkuti lira nuzu aduo kutin lira nin nanan kataa me, ina wa danin nono ktawe kutii ma wucuwucu mine. Nanin ma, na iwasu nanin ti kanci b. bara iwa laza fiu anite ma molu nanin nin na tala. ");
INSERT INTO amo_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nin kidun ukaptin nin nanan kataa me daa nin nono katawe kuti mawucuwucu, inanin wa tii nanin iyisin mmbung nanite nanya kutii licin gye nin nanin ku Prist kudewe tirino nanin ");
INSERT INTO amo_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Anin woro nanin,”Ti belin minu na iwa su madursuzu nin lisa Yesu b. inanin nari ulanzun liru bit, inanin dursuzo anite vat nanye Urshalima kitene me. Nin linbung, inanin duro anit nafo arikari dinin kulapi inkulme! ");
INSERT INTO amo_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Bara nanin Bitrus, lirina mmemoku nono katawe woro,”Tima lanzu uliru ule na Kutell benle nari ti su, na ilemon na anit benle nari ti su ba! ");
INSERT INTO amo_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ai anigyere na molu Yesu ku nin kotigye nakusa kitene kuca koneVat nanin Kutelle kona acif bit na rugye na fea gye amini idinin lai tutun nin kidun na ana kuu. ");
INSERT INTO amo_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Kutelle na antin Yesu ku nin bun nin kogy. Ana tiigye asu nari utucu nin su umulkibit. Amini na tii nanar ti cin kulapi. Bara anin shawa nin kulapi bit ");
INSERT INTO amo_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Tidin belu anit kitene ni lemong gyere na ina se Yesu ku. Ufunu Ulau ulena Kutelle na ninar, yinna ule ulire kiden ahri. ");
INSERT INTO amo_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Dana anan ma wucuwucu lanza nanin, inanin wa lanza ayii kan nin gyinu, inanin wa cinu umolu nanin ");
INSERT INTO amo_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Bara umong unit wa diku lisa me Gamaliyal. Ame ma wa di owa rum nanya na Farisawa. Ana dursuzo anit ma dudu na Yahudawe, vat a Yahudawe din lanzu infiu m, anin fitananya kuti mawucuwucu aworo, inutun nono kaduro inutun nanin udas nin kubi baat. ");
INSERT INTO amo_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Nin kidung, itina inutuno nono kadura udas, amini wa beling usaran anan mawucuwuce,”Nuana nin Israila na ti su uhankali nin nilemon na tima su anite alele, ");
INSERT INTO amo_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nin nakus kidung, umong lisame wa di Tidawus awa su kulapi. Amini wa beling anit ame unit ucinari, anin akut ku tocun dofingye. Inanin wa molugy, vat anit alena iwa din dortugye tin mala kiti. bara nanin na iwa yinin isu ilemon ana yinin amsu ba. ");
INSERT INTO amo_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Nin kidung nani, kubi kone na iwa nyerti tisa nanit na ima su, umong lisa me Yahuda, kusaring ka gbirin Galili ta kulapi amini wa tii anit idofingye. Bara nanin iwa molugye vat anit alena iwadin dortugye mala kiti kap udu nitiniti. ");
INSERT INTO amo_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Nene in beling minu: Na lanza anite le ukule ba! Cinon nanin! Inbenle nanin bara, andi imong ilena idinsusu inuzu kitin nitar, umong ma tii nanin icin, Inanin ima diu. ");
INSERT INTO amo_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Andi Kutelleri taa nanin isu ile imone, na iwagya iwatina nanin use ba, bara nanin ima na se idin suugaba nin Kutele ri! Among nanya wucuwucu yina nin liri Gamalial. ");
INSERT INTO amo_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Inani wa yiccila nono kadure nanya, ikpizo nanin. Anan mawucuwucu nin kpada nani na iwa dursuzo anit kitenen Yesu tutun ba inin cino nani. ");
INSERT INTO amo_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Nono kadure cino kiti ma wucuze, nin liburi libo kan, bara i wa yiru Kutelle angtina nanin kan nin ni nanite icin bara udortu Yesu ");
INSERT INTO amo_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kolome liri nin kidun nono kadura pira kutin lira nin ni lari nanit inanin wa libun indursuzu nanite ai Yesu unaere Christe. ");
INSERT INTO amo_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Nanya kubi, anit gbarda wa yininsa uyenu. Alena na Ayahudaweri ba tin na kugbunlu nin na lena ina mari nanin Israila. Bara na awani alena alesu mine nakuu imonle wadaci kitimine kole me liri. ");
INSERT INTO amo_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Nin nani, nin kidung nono kadure lanza ilemong na iwadin bele, inanin wa pitirin anite vat kitikirum nanya Urshalima “na tima su gigime ba andi ti cino kata dursuzu nin nunu Uliru Kutelle ti nin kifo ukosuzu ni monli kiti nanit. ");
INSERT INTO amo_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Bara nanin linuana na tifere anit kuzor anan Ufunu Ulau, anan nibinai ni lau nin nanan yinu kang. Ninnanin, ti dursu nanin usu kata kane. ");
INSERT INTO amo_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Bara arik ma su anfani ni kubi kone ti liiubung usun lira nin dursuzu anit uliru kitene Yesu. ");
INSERT INTO amo_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ilemong na anan nono kadure benle annyinusa uyenu yina mung. Bara nanin itin na ifere Istifanus ku unit ulena anayinannin Kutelle kan, ulena Ufunu Ulau di nanya kang. inani wa fere Philibus nin Porokorus nin Nikolas, Timon nin Pamilas nin Nikolas. Ulena iwadi ka gbirin Antiok. Nikolas wa yinin nin na dini na Yahudawa kafin anin yinin nin Yesu. ");
INSERT INTO amo_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ananyinu sa uyenu tin na inutun anit kuzor taa nanin lira nin taa nanin tarda acara mine kite na timine kogya anan su kata kane. ");
INSERT INTO amo_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Bara nani ananyinu sauyenu tin na ilau ubun dursuzu nanit uliru Kutelle. Ingbardan nana yinu sa uyenu nanya Urshalima kpina ka. Nanya mine among aYahudawe a Prist yina nin liru itin yina nin Yesu. ");
INSERT INTO amo_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Kutelle wa ni Istifanus ku likara anan su kata ka zikiki nanya nanite anna nuna iliru kitene Yesu. ");
INSERT INTO amo_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","nin nanin wan among wa yinin nin Istifanu ku ba. Iwa di lipin na Yahudawari iwa di ligowe nin na iwa yicu nanin Freed man kitin lira nin tutu anit unuzu kusari Siriya nin Alazandara nin kusari Silisiya au Asiya inin tin na su magazan nin Istiufanus ku. ");
INSERT INTO amo_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Vat nin nanin na iwa yinin usu unasara ningye b, bara Ufunu Ulau Kutelle di nin gye amini wa yinin uliru kan. ");
INSERT INTO amo_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Inanin wa tinin ise among anit nayiru usun Istifanus ku kinu, anit ane nin woro,”tilaza adin belu uliru unaza kite ne Musa nin Kutelle” ");
INSERT INTO amo_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Inin taa a Yahudawe ayi mine nanakan kitin Istifanu, umunu a kune nin anan dursuzu adu mine. Inanin tin na ikifo Istifanus ku itin ida ningye kiti mawucuwucu na Yahudawa. ");
INSERT INTO amo_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Inani tutun daa nin namon anit ini taa Istifanus ku kinu. Ale anite nin woro,”Ka gwane din belu imong inanzan kitene kutin kulau kunlira bit nin kitene adu Musa na ana seru kiti Kutelle. ");
INSERT INTO amo_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ilemong na tidin bele unare ti lanza gye adin duu ule Yesu na ana nuzu kusarin Nazareth ama turnu kutii lira kone amini daa nin adu alena tiyirumu alena anit kune bit na durariba. ");
INSERT INTO amo_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Vat anit nanya kutii mawucuwucu yene Istifanus ku inin yene umurome na fo umuro ngono kadura Kutelle. ");
INSERT INTO amo_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Nin nanin ku prist kudawe tirino Istifanu ku,”ilemone na ant alele din belu kite fe kiden are? ");
INSERT INTO amo_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Istifanus nin kawa, “Nua nanin a Yahudawa nin na didawe, lanzannin! Kutelle kudewe na tidin ruugye, wa zuru nin cifi bite Ibrahim na wa dutu nanya kusarin Mesopotamia, kafin adak kusarin ka gwirin Haran. ");
INSERT INTO amo_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Kutelle nin woeo gye, cino mmin mone na uduku nan na iyayife, duku, udu mmin mona ima dursu fi. ");
INSERT INTO amo_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Amini Abrahem tina acino mmim mone, na Chaldia, amini wa dak Uharan anin soo kikane. Nin kidung ucif me kuu, Kutelle nin belingye anuzu mmimn mone na sosinku. ");
INSERT INTO amo_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Kubi kone Kutelle wadi asa naa Abraham mmin lisosin me ba. Vat nin nanin Kutelle su gye likawali ama nigye mming mona amasoku nin nisudu me, sa ligan. Nin nanin ma Abraham kubu kone awa dinin nin gono kana ama su ugadu me ba. ");
INSERT INTO amo_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nin bung Kutelle belle Abraham, 'Isudu fe masuo kipin limara. ima suo kikane udu akus akalin anas, lisosin mine kikane lin ma yitu licin ari. ");
INSERT INTO amo_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Men ba nani ulada umugunta mine na itaa nono nin son, mba nin nutun min, nin kidun isudu fe madak ida usujaida lidurun nan mmin mone. ");
INSERT INTO amo_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Kutelle nin dokace Abraham, asu nono ni lime memboo ukaciya, nanin anit ma yinu inin nono Kutelle ari, Nin mbung ame Abraham se gono lisame Ishaku, kube na Ishaku wa tii ayira kulir, 8days Abraham su gye uboukaciya nin mbung ame Ishaku mara gono me lisame Yakubu, Yakubu yita ucif nono likure, alena aYahudawe din yici nanin akune na cif bit. ");
INSERT INTO amo_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Iyiru gono ki kune Yakube laza ayi bara ucifime wa yiru Yusufuku ataa gye kinnayi me. Inanin wa lewu gye nacara nanan kasau, inanin wa yiru gye udu Umasar, kikane amini suo unan licin. Vat nanin Kutelle mini na bung Yusufu ku. ");
INSERT INTO amo_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Amini wasugye ukariya kikana anit wani uwahala. Amini wa nigye uhikima kan, amini watii Firaun, ogo Masar, asu umong icine kitenen Yusufu. Nin nanin Firauna nin nin yira gye asu umulki nanya Masar nin yenju kuturan Firauna. ");
INSERT INTO amo_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Dana Yusufu wadin su kata kane, iduru kon kubi na umonli wasali nanya mmin Masar nin Kaana, Anit wa di tikanci kan. Kubi kone Yakubu nin nonome na iwa dinin ni mmonli ba ");
INSERT INTO amo_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Dana Yakubu lanza imonli lesu din Masar, amini wa tuu nuono me udu Umasarinan di seru imonli li, inanin wa duo idi seru imonli kitin Yusufu, inanin wa yinin Yusufu ku b, inanin wa kpilin kilari. ");
INSERT INTO amo_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Kubi kona nuona Yusufu duo iseri ni monli unbe kikanere, anin benle nanin ame ari. Nin nanere Firauna nin yino an Yusufu a Yahudaweri, nin anit ale na idaa unuzu Kaana nuona mere. ");
INSERT INTO amo_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Nanin nin kidun na Yusufu tuo nuona me kilari, inin benle ucif mine Yakubu Yusuf dinin us me nin iyalime idak Umasar ida suo k. Kubi kone Yakube nin nono me wadi akut kuzor nin kutochin ");
INSERT INTO amo_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Dana Yakubu lanza nani, ame nin lilari me yga udu Umasar. Nin kidun Yakube kuu kikane, nin na mong akune bit, nin nono me kuu kikane ");
INSERT INTO amo_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Inanin wa yiru abi niwo mine idamu kutin bit kikane ikasa nanin kikana ucif bit Abraham naseru nanya kagbirin Shechem. ");
INSERT INTO amo_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Akune bite taa gbardan kubi kona Kutelle wa dinin su utucu mine kiti na Msrawe, nafo na ana su Abraham ku ualkawali. ");
INSERT INTO amo_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Umong ugo da a suumulki Umasar, na ame yiru Yusufu ku ba na amere wabun nanin kubikona awadi mulkeba, ");
INSERT INTO amo_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ugo ne rusuzonanin kurun asu uzalamci kit na kune bite ana nin uwahalakang. Amini wa tii nanin itusu nono nibebene mine idas ni lari mine inan kuzu. ");
INSERT INTO amo_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Kubi konere iwa maru Musa k, Kutelle, nin yene gye gono ki gigimeri kan. Nin nanin acif me nashe gye nanya kilai nanya tipui ti tat ");
INSERT INTO amo_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Inanin wa ce ghe idas kilare, bara ushonon Ifirauna nan nin seghe ibiu kigawa, amini wa minghe nafo gono mere. ");
INSERT INTO amo_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Iwa dursuza Muse ku vat ukoyo na ani Masarawe yiru mu, amini wa gunjo asu imong ezikiki kan ");
INSERT INTO amo_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","In lonliri kubi kona Musa wa di akus akut kutochin, amini yina kibinai me ama di lisu anit me, a Israila ");
INSERT INTO amo_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Amini wa yene ku Masarawa di fuo ku Israila. Bara nanin amini wa tinin adi buno ku Israila, atina amolo ku Masarawe. ");
INSERT INTO amo_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Muse wa suso ku Israila maynnu Kutelle na tuu ghe ada bolu nanin nanya lichin Masaraware. Bara nani ne inin wa yinin ba. ");
INSERT INTO amo_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Nin kuiy, Muse yene ku Israila din fuo atimine. Amini wa cina ukosu nani, Anit, anin na biye li nwana a Israila! Bara yanghari idin fuo ani mine? ");
INSERT INTO amo_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ame ulena awa lanza gwana me ukule turno Museku kusari ani benle ''aa ghari taa fi kulauya kiti bit! ");
INSERT INTO amo_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Udinin suu umoli nafo na una molu ku Masarawe ilenghe? ");
INSERT INTO amo_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Dana Musa lanza nanin atin na achino u Masarawe acoo udu mmin Midiniawa. Amini wa ti akus kikane. amini wa suu ilima kikan iwane mara ghe nono niba. ");
INSERT INTO amo_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","lon lir akus akuta nas nin kidun, Kutelle seeghe nanya gono kadura me udu kiti Musa. Ani see Musa ku nanya galtun kushoo kona kuwandin jujuki dawo nanya kushoo kukau ku popo likup. ");
INSERT INTO amo_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Dana Musa yene nanin asu umamaki, bara ula wadin lii kushe amana kushoo juju kidawo ba, dana ada kupopo kushoo anan yen, amini wa tini alanaza liwui Kutelle yichu ghe, ");
INSERT INTO amo_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","'Men Kutelleri ulena akunefe na zazu. Men Kutelle Abraham, Ishaku, nin Yakubu na ina zazu. Musa lanza fiu kan atina ketuzu. Alanza fiu yeju kushoo tutun. ");
INSERT INTO amo_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Nanin Kutelle woroghe akala akwatak me auro sa udin daukaki. Bara kika na uduku kiti kilauwari kinaniari. ");
INSERT INTO amo_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Imali yenu elemon na ann Masarawa di ni anit nin ti kanci. Ilanza aniti nin kubi kona idin ghilu. men daa ida bolu nanin nachara na Marawa. Nene fita, bara idin chinu utufi nanya Masar, ");
INSERT INTO amo_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Musa amere wa bung nono Israila, ulena iwa narighe, inin woro, aa ahri na tifi un kulau kitibit! Musare Kutelle na tuu ghe asu umulki mine ani bolu nanin nanyaa lichin amere ule na gono kadura gye kushe walin ghe suu imene. ");
INSERT INTO amo_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Musa amere wa nutun akunebite in Masar. aamini wa wasu imong eziki gbardan, nanya Masar bara ana dura Kutelle wa di nin ghe, kurawa kku shine nin akus akuta nas anit Israila nadi nanya kushoo. ");
INSERT INTO amo_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ule Musare na awa benli anit Israila, 'Ktelle maa dani nin mong nanya na nit mine asuo kuannabit nafo men. ");
INSERT INTO amo_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ule unitere Musa na awadi nanya na Israila na awadi nanghinu nannya kushoo; amere gono kadure Kutelle wadi nin ghe likup Sinai. Amere Musa na Kutelle na nighetidokoki bite, amere ulena abelin akune bite tipipin tona unan kadure wa belin. Amere ulena ana seru tipipin Kutelle udu kiti bite dana tidin belu nari tusu lisosin linsali ligan udu kusari bit. ");
INSERT INTO amo_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Vat nin nani akune bite wa nari lanzu Muse k, inani wa nari asuo nani udia mine, inani wa dinin suu i kpilin udu Masarawa. ");
INSERT INTO amo_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Bara nani inani wa beli yayame Haruna, 'kele nari kudodo kono kuma suo nari kutelle ayiru nari udu Umasar. Bara ame Muse na tiyiru yeri se ghe ba. ");
INSERT INTO amo_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Inani wa kee kutelle kaluka. inani wa nakpiza tihadayu mine mbung kaluke inan zazin kudode, inani wa suu afu nin niwawa bara ilemong na inin kele. ");
INSERT INTO amo_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Bara nani Kutelle tina chino ukelu nani. Amini chino nani isuu uwui, upoi nin niyin, kitene kitene kane usujaida. ulele di daidai nin tipipi too umong ku uan liru nuu Kutelle n yertin: Kutelle na belin, Anun anit Israila, kubi kona na iwa libun molsu ina nin nakpizu tihadaya mine nanya akus akut anas na iwadi nanya kushoo, inani wa nakpiza meghari ku tihadaye? ");
INSERT INTO amo_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Bada nanin iwayiru kudaga udu niniti kona kuwa di nin aloli kutelle Molech inani wa suu ghe usujaida. Inan tutun iwa yiru usufa fiyin ulena iwa yichu ghe Rephan. alelere akunki alena iwa kiye inani wa suu manin usujaida na menba. bara nani ima tii ida yiru nilari pii udu kankagbiri dana kadi pii dana ka ta Ubabila. ");
INSERT INTO amo_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Kube na achif biteiwa di nanya kushoo, inani wa suu Kutelle ku usujaida nanya kudaga nafo awadi nanghinu. Inani wa kiye kudaga nafo na Kutelle na belin Muse ku. kuwa di nafo kona Muse wa yene kitene likupe. ");
INSERT INTO amo_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Udak kidun, ukon kunebit ayira kutent kone kubi kona Joshua wa dak nin ghinu nanya mminghe. Kubi konere iwa bolu mmin mone, kubi kona Kutelle wa nutun anite alena iwa di nanya mminmone, att nain inuzu. Bara nani Israila kifo mmin moneiman taa min mine, Kudanaghe wadi nanya mine ni duu ayiri ugo Dauda. ");
INSERT INTO amo_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Duda taa ayi Kutelle man amini wa tirin Kutelle ku sa akeeghe kilari kika na ame nin vat anit Israila ima suu ghe sujaida. ");
INSERT INTO amo_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Bara nani Kutelle nin woro Dauda ku uson fere Sulaimanu ma keyi kilari kika na anit ma suu usujaida. ");
INSERT INTO amo_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","''Bara nani, iyiru kitele katin likara koyan. Na awngya asuo kilari kana ani kiye ba. nafo na Ishaya una liru nuu Kutelle wa nyertin: ");
INSERT INTO amo_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Kutelle woro ''kitene ukursiyi nighari, kutin tutun kiti patilu nin ghari musu kiyapin kilari imaa keyi mugha? Men litini ina kie imong vat kitene nin kutin. ");
INSERT INTO amo_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Bara anun anit ari iwaya kelai kilari kana men wanya isuu nanya kinin ba? ");
INSERT INTO amo_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Anun anit atimine di gagan kitime! idi nafo akune minere! iani naru Ufunu lauwe, nafo na ini suu! ");
INSERT INTO amo_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","akune mine watii anan liru nuu Kutelle ti kanchi kan. Inani wa molu alena iwa beli ubelen dakin Kristi, amere ma chas ana nonko kibinai Kutelle man. Kristi une na malin dak! Amere ule na na ina kpilin nanan ni vira meinani na yisi imolughe! ");
INSERT INTO amo_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Anughere anite na ina seru tidokoki Kutelle. Too tidokore Kutelle nani gono kadura me ani acif bite, vat nanma na ina durtu ti dokokeba. ");
INSERT INTO amo_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Kube na anan ma wucuwucu na Yahudawe nin saure lanza vat elemon na Istifanus benle, inani wa lanza ayii ka. Inani wa din talu na yini mine bara ilemong na Istifanu benle nanin! ");
INSERT INTO amo_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","bara nani Ufunu ulau tin nonko kibinai Istifanus. Amini tii iyizime kitene kane atina ayene ikanan laa Kutelle. Amini wa yene Yesu ku yisin mbung chara ulime Kutelle. ");
INSERT INTO amo_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","''Yene,''aworo'' iyene kutenle puno, imini yene gono nit yisin kusari chara ulime Kutelle ");
INSERT INTO amo_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Dana anan ma wucuwucu na Yahudawe nin usaura mine lanza. inani watii inteed kan. Inani wa tursu atuf mine ninna chara bara na iwa lanza ghe ba, sa umolukubi itinna imuna tii kiti me. ");
INSERT INTO amo_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Inani iwa wunun gh udu udas kagbire Urshalima tina tauzu ghe nin na tala. Anit alena iwa suu kinu kitene me itina kala alituk mine ichau kupopo ko kunyana lisamw Shawulu amini wa suu uhaa nalituk ke. ");
INSERT INTO amo_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Dana ilau ubun tauzu ghe nin natale, Stifanus taa nlira,''Ucikilari nin Yesu sere ifip nighe! ");
INSERT INTO amo_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Nin nani Stifanus tin na adeu kitin ani jartin, Cikilari, na uwa kifo nani kulapi kona ba! Nin kidun na benle nani, atina kuu. ");
INSERT INTO amo_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Bulus wayiru akuru ayinna nin molughe. Bara nani itunna ighanan tizung nono Kutelleuniu uniu udya lilole in Urushalima; tutungg vat nanan biye malakiti ukilunu nasarin Urdun nin Samariya, bannin nono katwa we. ");
INSERT INTO amo_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Anan lanzu fiu Kutelle yauna libin Istifanus idi kasu nin kucculu kang atiyom. ");
INSERT INTO amo_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ama Shawulu wa lanza kilarin in lira Kutelle ukule kang; awa piccu nilari nilari in nutuzunun nalilime nin nawani, anin tiza nani nilari licin. ");
INSERT INTO amo_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Anan yinu sa uyene na iwadi nanya Urshalima tinna choo udu nigbri-nigbri, inani wa lii ubun suu uwa-aze Yesu. ");
INSERT INTO amo_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Umong nanya nanan yinu sa uyenu ulena lisame wadi Philibus achino Urshalima udu u Samariya. kine atina belu nanitau Yesu amere Kristi. ");
INSERT INTO amo_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Anit gbardan kikane lanza Philibus liru nin yeneghe adisu kata kazikiki. Bara nani inin vat dandana kupopo kiti liru me. ");
INSERT INTO amo_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Nafo umisali, Philibus umurcha ufunu unanzan unuzu das kiti nanit gbardan, inani wa nuzu nin kuchulu tutun anit gbardan na iwa dinin agurgu na bunu ba. ");
INSERT INTO amo_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","bara nani anit gbardan ka gbri kane lanza liburi liboo. ");
INSERT INTO amo_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kikane umong unit wadiku kagbri kane lisame wadi Simon. Ame wadin suzu nikulma uworsu. awa niza anit umamaki nin kat nikulma me nanya Samariya ''Simon udia une!'' ");
INSERT INTO amo_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Vat anit kikane, vat anit ahem nin na chine ilatisza ghe. Inani wa beling, '' Ule unite likara lidiya kutelleri.'' ");
INSERT INTO amo_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Inani wali ubung latiszighe chaut, bara uworsu awa ninani umamki nin kata nikulma me. ");
INSERT INTO amo_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Bara nani iwa yinin ni Philibus ku nin liru umang une kitene Kutelle na ana durso liti me ogo, nin kitene Yesu Kristi. Nanilime nin nawane alena yinna nin Yesu esuu nani nubaptizima. ");
INSERT INTO amo_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simong litime yina nin liru Philibus amini wa sughe ubaptizima. Amini wa tini durtu philibus ku, amini walii ubung lazu umamaki nin kata kazikiki kana Philibus wa din sue, imong ine wa durso ulirin Philibus kidegenari. ");
INSERT INTO amo_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Dana nono katwa nanya Urshalima lanza ani gbardan vat Samariyan yina nin liru Kutelle, inanio wa tuu an Bitrus ku nin Yohana kika ne. ");
INSERT INTO amo_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Dana Bitrus ni Yohana da nanya Samariya, inani wa tin nlira kiti na lena iyina sa uyenu ina sere Ifip Milau. ");
INSERT INTO amo_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Bara Ifip Milau wadi misa tolo atimine ba. Iwa suu nani ubaptizimari ma chas nanya lisa Ucif Yesu. ");
INSERT INTO amo_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Nin nani Bitrus nin Yohana tarda achara mine kite mine ana sere Ifip Milau. ");
INSERT INTO amo_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simon nin yene inaa anit Ifip Milau bara utardu nachara nono katwa kitene mine. Bara nani amini wa ni nono katwa we ikurfun, ");
INSERT INTO amo_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","anin bele,''taani menma suu elemong na anin di suu, bara kogha na itaaghe achari nin ama seru Ifip Milau.'' ");
INSERT INTO amo_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Bara nani Bitrus nin benlin ghe,''Fia nin nikubu fia nanah, bara udinin suu use ufilu Kutelle nin nikuba! ");
INSERT INTO amo_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Uwangya usu katwa nan arik ba nanya suu nilemone, bara kibinai fia diligowe nin Kutelle ba! ");
INSERT INTO amo_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Bara nani chino kibinai kinanzan kane, uni roko ame Ucif, andi ama yinu, ashawa nin kulapi kunanzan kona udinsue nan kibinai! ");
INSERT INTO amo_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","kpila uchin libau linazan lone bara yene udin kiyashi bi, bara fea we ubawa ri katwa ka nanza kane. ");
INSERT INTO amo_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simon ghe nin kwan, tai nlira kiti Chikilari bara asuu elemon na u bele! ");
INSERT INTO amo_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Nin kidun Bitrus nin Yohana belle anit kikane elemong na idini suwe kitene Chikilari Yesu nin dursu nani usakkwe Chife ina tina ikpila udu Ushalima. Kitene libauwe, itina dursuzu anite uliru uchine kitene Yesu nanya Samariya. ");
INSERT INTO amo_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Umong uwui unan kadura ulena Kutelle yuoghe kiti Philbus ''Fita uyisin nin duo kusari kudu unuzu Urshalima udu kagbirin Gaza.'' Liboiwe wadi kusari kushori. ");
INSERT INTO amo_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Bara nani Pilibus fita agya udu liboiwe. Liboi lolere amini wa zuro nin umon unit mmin Etopia. Awadi unit udeawari ame awa di udia vat na sarauniya Etopia. Nanya lilemme anit wadi yicu ku sarauniya Kandence. Ele unite wadin cinu udu Urshalima usu ususaida, ");
INSERT INTO amo_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","amini wacinu u kpili kilari awa sosin kitene kuchariot me. Amini wadi chin, amini wadi belu ni nyerta kutakarda unan lirin nuu Kutelle. ");
INSERT INTO amo_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ufunu ulau Kutelle woro Philibus ku, ''Can cana uzuro nin imon ngju.” ");
INSERT INTO amo_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filibus tunna a lalla i chum udu kiti me, a lanza nge adin nbellu ni nyerte nan liru nin nu Kutelle Ishaya, aworo,”uyinno ma nyertu mane? ");
INSERT INTO amo_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Unit Habasha woro, men mmatizari inyinin andi na umon belli ba!” Unitte woro Filibus, ngna uda so likot nighe.” ");
INSERT INTO amo_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Uliru Kutelle na uittin Habsha wa di nbellu ni nyerte imoe ile awwo cino nafo ku kam uchindu kiti bo, nafo kukam na kumiin tikk na charan lenghe na ma bo nanere na puno unume ba. ");
INSERT INTO amo_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Nyanya ntolti litime itunna ibolo nghe ushara. Nga ri mabello imommon inanzang litime, inani wan yiru ulaime. ");
INSERT INTO amo_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Unan salin masu tirunu Filibus ku, aworo, “ndin rizufi nacara, unan liru nin nu Kutelle din liru kitene ghari? Litimere sa kitene nmonghari? ");
INSERT INTO amo_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filibus tunna a cizina uliru, a cizina kutakarda kulau ng Ishaya atunna nnbellu ghe kitene Yesu. ");
INSERT INTO amo_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Kubi ko na iwa din ci libo ido kankitin mmyen unan salin macu wuro, “Yene, mmein mongo kikane; Iyanghari ma wantinura nyanyan mmein ishinti ni nyanya mmeine?” ");
INSERT INTO amo_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filibus woronghe, uwan yinin nin kibinayi fe vat, iwanya ishintifi nan nyan mmeine.” ");
INSERT INTO amo_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Unittin Habasha woroghe, yisina nin nimon an-njue. Itunna itolo na-bee ipira nan nya mmeine, a shintinghe ku. ");
INSERT INTO amo_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Kubi ko na inuzu nan nya mmeine, Uruhu Kutelle tunna a yira Filibus ku. Unit Habasha tunna a nya nin liburi libo. ");
INSERT INTO amo_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filibus tunna ayene Uruhu ulau yaughe udumu kaghirin Azotus. Akata a cin belle uliru umang itin Yesu, nighiri-nighiri. a do Ukaisariya. ");
INSERT INTO amo_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Vat nani Shawulu leo ubun inziu nanan dortu Kutelle. Amini wa do kiti ndia kutii nlira n-urushalima. ");
INSERT INTO amo_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","Aworoghe inghe ma-nyertu- nyertu ma na a ba dumu kitii na didia natii inlira n-Damaskos. Ma nyerte wa nighe aghang ale na aba kivinu uzaman nan na wani ale na idin dortu libau Ise, akuru a cisoni natii nacin n-Urshalime, bari adi-dia na nan wucu kideinne ba funuani. ");
INSERT INTO amo_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ku bi ko na Shawulu nan nan cinme wa din cinu udu Udamaskos, na nin daudaunu ba, umon kanang tua unuzu kitene kani mu kilinghe. ");
INSERT INTO amo_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Atunna a deou kutin, a lanza liwui nuzu kitene kani, liworoghe, “Shawulu, Shawulu, bari yanghari udin ni nantiting uwuya?” ");
INSERT INTO amo_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Shawulu tiringhe, “Cikilari, fe ghari?” A kawaghe aworo, “Mere Yesu, ullenge na udin yooghe. ");
INSERT INTO amo_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Vat nani fita upiru nanya kagbiri! Umon nanya kagbire ba bellinfi ilemo na umasu.” ");
INSERT INTO amo_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Alenghe na iwa di nin Shawule lanza fiu, na iyinno ubellu nimomon ba. ");
INSERT INTO amo_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Shawule fita kutene, da na apuno iyizzime, na ayinno uyenju nimomom. A nit arka na iwa di ninghe, kifoghe nchara udumu na kipin Damaskos. ");
INSERT INTO amo_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Shawulu ta ayiri a tat, na nin yenju kitiba, ana awa lii sa asono imomon ba. ");
INSERT INTO amo_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Ndamaskos, umong waduku ulenge na iwa yicighe Hananiya unan dortu Yesu. Cikilari Yesu ta Hananiya nanyan namoro-yenju, a aworoghe, “Hananiya!” Ame kpana aworo “Cikilari, nding latizu.” ");
INSERT INTO amo_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Cikilari Yesu woroghe, “cang umong ulayi na idin yicu ning 'udert' ule na udo nghan Yahuda. Utirin lisan mong unit na idin yicighe Shawulu kunan kagbirin Tarsus, nene adin foyi nachara. ");
INSERT INTO amo_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Shawulu wadi amal yenu nanya namoron yenju kiti, umon unit na idin yicughe Hananiya pira kilari kirika na awa duku atardaghe achara bara anan yenje kiti tutung.” ");
INSERT INTO amo_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Hananiya kpana aworo, “Cikilari, anit gbardang nabelli ubelleng nnit ulele! A su imon inanza gbardang kitene na rika na iyinna nifin Urshalima. ");
INSERT INTO amo_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ame na malu seru niyert kiti na didyawe, ulenge na una nighe likara akifizo arikana iyina nifi kikane Damaskos.” ");
INSERT INTO amo_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Vat nani Chikilare woroghe, su immon irika nan belling fi usu, “Can kitin Shawulu!, bara nan nfereghe a suyi katua litinighe nin arika na isali aYahudawa anan na goomine nan nIsrailawe. ");
INSERT INTO amo_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Memma litinighe ba belling nghe, aba niu kan kiti nanit bari ubellinani uliru litinighe.” ");
INSERT INTO amo_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Hananiya nya a pira kilari kirka na Shawulu diku. Da na ayene Shuwulueku, a tardaghe achara litime, anin woroghe,”Gwana Shawulu, C; hikilari Yesu ntoyi kitife. Amere wa dak kitife kubi ko na uwa di libau udu uDamaskos. Amere na tuyi kitife bara unan kuru use uyenju kiti, tutung uRuhu ulau bara yiru likara litife.” ");
INSERT INTO amo_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Nanin dandaunu ba, imonimon nafo imart nibo deu niyizin Shawulu, anin tunnan yenju tutung. Anin fita itaghe ushintunu nmyen milau. ");
INSERT INTO amo_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Kimal nlii nimonlin Shawulu, ase likara kidowo tutung. Shawulu so nin namong anan dortun Yesu nayiri gbardang. ");
INSERT INTO amo_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Na nin dandaunu ba, atunnan bellun belle Yesu nanya nati nlira mine in wo amere gono Kutelle. ");
INSERT INTO amo_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Vat nalenge na iwa lanzaghe puzuno tunu inin din bellu, “Na ulelere din nanzu narika na iwadin Urushalima anan yiccu kitenen lissa lole ba? Tutung ada kiti kane anan tere nani a yauna udumun kitin Priest.” ");
INSERT INTO amo_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ama Bulus wase likara asu uwazi abellu a Yahudawa na idin Damaskus au Yesu amere Kristi. ");
INSERT INTO amo_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Na ayira gbardang in kata, A Yahudawa kyele atimine nwo imollughe. ");
INSERT INTO amo_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ama Shawulu wa lanza ile imon na idinin su isughe. Iwaso ncca kibulughe kiti nin lirin inan mologhe. ");
INSERT INTO amo_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ama nono katwa me yaughe inin toltinghe ligitiri, iwa ghatinghe nin kukuzughari. ");
INSERT INTO amo_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Na anin da u'Urushalima, Shawulu mala udofinun nono katwa, ama vat inghune wadin lanzu fiume, na iwa yinnin ame wang gono katwari ba. ");
INSERT INTO amo_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ama Barnabas yaunghe adamun ubun nana liru Kutelle. Anin belle nani tana na Shawulu wa yene Cikilare libau tutung Cikilare wa liru ninghe, tutung tana na Shawulu wasu uwa'zi lissan Yesu sa fiu in Damaskus. ");
INSERT INTO amo_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Awa zuru nanghinu kube na iwa din piccu nin niccu nanyan Urushalima. Alira sa fiu nanya lissan Cikilari Yesu. ");
INSERT INTO amo_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Tutung asuzu mayardang nin na Yahudawan Girisiya; ama iwa dinga ubingan molughe. ");
INSERT INTO amo_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Na linuanan yinno nin nilemone, ida ninghe u Siseriya inin toghe udun Tarsus. ");
INSERT INTO amo_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Tutung, nilarin lira vat nanya Urdun, Ugalili, nin Samariya se lissosin liman tutung iwa kunjo; tutung ucin nanyan fiun Cikilari nin nanya mang Ruhu ulau, kilarin lire kunjo nin nanit. ");
INSERT INTO amo_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Nene imoimon wa yita, na Bitrus wa galu vat nitinit, ada tolo kiti nanan bi ale na iwa di kagbirin Leyida. ");
INSERT INTO amo_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Kikane awase umong unit ku lissame Aines, urika na awa li akus kulir kitenen komime, bara awadi nin konun ku kidowo. ");
INSERT INTO amo_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Bitrus woroghe, “Aines, Yesu Kristin shino nin fi. Fita ukyele ukomife.” Atunna afita ayissina. ");
INSERT INTO amo_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Bara nani, vat nalenge na iwa sossin in Leyida nin Sharon yene unite ikpilla atimine kitin Cikilari. ");
INSERT INTO amo_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Nene in kan gono katwa waduku n nanyan Joppa lissame Tabitha, urika na ukpiluwe di “Dokas.” Ule uwane wa kulung nin katwa kacine anin katwan kunekune ka na adin su anan likimon. ");
INSERT INTO amo_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Nanya nayiri ane, ukonu kwaghe anin ku; na ikussughe, inin nokoghe kuti kitene. ");
INSERT INTO amo_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Uleyida wadi kupon Joppa, tutung nono katwawe wa lanza Bitrus di kikane, ito anit aba kitime, ipotoghe acara, “Dacari kiti bite sa umolu kubi.” ");
INSERT INTO amo_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Fita adofino nani. Na ada duru, idoninghe kutii kitene. Tutung vat nawani ale na alesmine nakuzu yissina kupo me kuculu, inin dindursuzughe altuk nin nazeni alenge na Dokas wa tuju nani kubi na awadi nanghinu. ");
INSERT INTO amo_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Bitrus nutuno nani vat nanya kutiiye, atumo atanlira; anin gitirno ayene kidowe, abelle “Tabita, fita.” Apuno iyizi me, na ayene Bitrus ku, afita aso. ");
INSERT INTO amo_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Bitrus nin nakpaghe ucarame afeghe; na ayicilla ananbiye nin nawani alenge na ales mine na kuzu, ananani ame nin laime kiti mine. ");
INSERT INTO amo_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Kogha tunna nin yiru nile imone vat nanya Joppa, gbardang nanit tutung yinna nin Cikilare. ");
INSERT INTO amo_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Bitrus tunna ata ayiri nin mong unit, lissame Simon, ku Tanna. ");
INSERT INTO amo_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Nene umong unit waduku nanya kagbirin Siseriya, nin lissan Konoliyus, kusoja kudyawa ligonzin na Italiya. ");
INSERT INTO amo_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Awadi unit in biya kang, urika na nawadin dortu Kutelle nin kilari me vat; awa nizu anit na Yahudawa ikubu gbardang anin suzu inlira kiti Kutelle kolome liri. ");
INSERT INTO amo_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Kubi nikoro kutir nin wui, ayene kanang nanya namoro alau gono kadura Kutelle din cinu udak kitime. Gono kadure woroghe, “Konoloyus!” ");
INSERT INTO amo_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Konoliyus yenje gono kadure fiu daghe aworo, “Inyaghari unit udya?” Gono kadure woroghe, “Nlirafe nin nimon ile na udin filluzunu akimon mun nghana kite nafo unizun lizzinu inbun Kutelle. ");
INSERT INTO amo_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Nene to anit udu kagbirin Joppa idak nin nit lissame Simon, urika na idin kitin yiccughe tutung Bitrus. ");
INSERT INTO amo_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Nin Kutana lissame Simon, urika na kilari me din biu kurawa.” ");
INSERT INTO amo_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Na gono kadura Kutellen mala uliru ninghe, Koloniyus yiccila acin awaba kilarime, nin kusojako na kuwadi su Kutelle usujada nanya nasoja na iwa dighe katwa. ");
INSERT INTO amo_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Konoliyus belle nani vat nimon ilen na isu anin tonani udu u Joppa. ");
INSERT INTO amo_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Nin liri liba nin kubi nikoro kutocin, na iwadi nanya ncin mine inin da kupo kippin, Bitrus ghana kulari kitene ati nlira. ");
INSERT INTO amo_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Kupkon da anin yita ninsu li nimonmon, na anite wadi likanju nimoli, ayene amoro alau, ");
INSERT INTO amo_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","anin yene kitenen puno kidowo nin nimonmon nafo kukuzunntolsu, imone gbardang nafo kukuzu ucin tolu kutiin, iwa tolti kunin nin nasari anasme. ");
INSERT INTO amo_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Nanya kunin vat ninawan tene nabunu anas nin nimon ile na idin kurtu kutiin, a ayiin kitene kani. ");
INSERT INTO amo_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Liwui tunna li lirina ninghe: “Fita Bitrus, ubo uli.” ");
INSERT INTO amo_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Bitrus woro, “Na nanera ba, Cikilari; nan sa leu imon na idi nanzang sa dinon ba.” ");
INSERT INTO amo_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ama liwuiye daa kitime umba: “Ile imon na Kutelle nwesse yenju uwa woro idinin dinong.” ");
INSERT INTO amo_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Na ayine ile imone so titat kiteene itunna ighantina kugbetue udu kitene kani. ");
INSERT INTO amo_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Nene na Bitrus nyene amoron nwui anin din kpilizu nyanghar adi, awa ba na Kaniliyos ntoo nani ida yisina kibulung ghe, na itirino kilari kaa na aduku. ");
INSERT INTO amo_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Inin yicila itirino sa Siman, ulenge na idin yicu ghe Bitrus, sosin kikane. ");
INSERT INTO amo_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Na Bitrus se wa din kpilzu kitene na moron wui ye, Uruhu belin ghe, “Yene, anit atat nalime din piziru fi. ");
INSERT INTO amo_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Fitaa utolu unin nyaa ligowe nan ghinu, na uwann nari unyiu ligowe nan ghinu, na uwan nari unyiu ligowe nan ghinu ba, bara nan too nani.” ");
INSERT INTO amo_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Nani Bitrus se tolo kadase ade see anit aworo ani, “Mere ule na idin pizirughe. Inyangharin ndaa ninghinu?” ");
INSERT INTO amo_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","I woro, “Unan buun ligozin nasoja likoolt nin lisa Kaniliyos, unit ulau nin lee na adin su Kutelle usujada, unitari ule na vat nmin na Yahudawa din liru litime, Kutelle wa tuu gono kadura me kilau ucindu kilari me, adan lanza kadura nnuzu kitife.” ");
INSERT INTO amo_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Bitrus se yicala ani ipiru nin nati isoo ligowe nan ghe. Ukurtunun kui ye afita anyaa ligowe nin ghe, nin nan nuwuna nnuzun Jopa na iwufu ghe. ");
INSERT INTO amo_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Nin Shantung kui me idaa Usizeriya. Kaniliyos wa din ncaa mine, awa dak ligowe nin likura a adindong asusut me. ");
INSERT INTO amo_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Kubi koo na Bitrus se npira, Kaniliyos tumuno na bunu fe atighe gongong. ");
INSERT INTO amo_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Ama Bitrus se fya ghe aworo, “Yisina; Meng wang litine unitari.” ");
INSERT INTO amo_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Kubi koo na Bitrus wa din liru ninghe, a pira nanya a ssee anit gbardang sosin ligowe. ");
INSERT INTO amo_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Aworo ani, “Anun atimine yiru na ucaun Kuyahudawa munu liti nin, sa a doo kitin mong nnuzu mmong mmin. Ama Kutelle na dursoi na nwa yicila umong unit ananni sa unan dinong. ");
INSERT INTO amo_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Un naren taa ndaa ba manyardang, na uwa tuu ndak. Bara nani ntirin fi uminin too ndak.” ");
INSERT INTO amo_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kaniliyos woro, “Ayiri anas na ana kata kubi fo kone, Nwa din nlira kubi likure sa irum nya kilari ning; nnin yene, unit yisin nbun ning nin nimon iboo pas. ");
INSERT INTO amo_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Aworo, 'Kaniliyos, Kutelle nlanza nlira fe, ile imon na udin filzinu ni kimon ntaa Kutelle koni nlizino ning fi. ");
INSERT INTO amo_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Too umong udu Ujopa, iyicila fi umong unit unan lisa Simon, ule wang na idin yicighe Bitrus, kupopo ngau kuli.' ");
INSERT INTO amo_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Kube ntunna ntoo iyicila fi. Ucaun na udaa. Nene na vat bite di kikane nbun Kutelle, ti lanza vat nile imon na Cikilari na dursufi ubelin.” ");
INSERT INTO amo_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Bitrus puu no unuu me aworo, “Kidegene, Nyinno na Kutelle din feru ba. ");
INSERT INTO amo_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Nnani, nyan vat nmin Kutelle din sesu vat na nit ale na idin suu ghe usujada nin adadu alau. ");
INSERT INTO amo_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Iyiru kadura kaa na ana tuu udu kiti nat Nisraila, kubi koo na awa belin uliru umang nyan Yesu Kristi, ulenge amere Cikilarin vat- ");
INSERT INTO amo_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","anun atimine yiru ile imon na ina su, ile na iwa se vat nyan Judiya, ucizinue Ngaliliya, nkatun Baptisma Nyuhana na awa belin; ");
INSERT INTO amo_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Imone kitenen Yesu Nnazaret, na Kutelle wa kusu ghe nin Ruhu Ulau nin na gang. Anyaa atinnang su kataa kacine nin shizinu na le na ibilis wa nodin nani, Kutelle wa di ligowe nin ghe. ");
INSERT INTO amo_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Arik anan niyizi ibaari nvat nimon ile na anan nmin na Yahudawa nin Urushalima-Yesu ulele na iwa molu ghe, ibana ghe kitene ku ca. ");
INSERT INTO amo_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Unit ulele Kutelle fya ghe nya liri lin tat anakpa ghe anun nan yinin ghe, ");
INSERT INTO amo_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","na nvat nanitere ba, ama udu nanit ashaida alenge na Kutelle wa fere nani nworsu-arik atibite, ale natiwa li tisono nan ghe kimal nfitu me nkul. ");
INSERT INTO amo_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Awa ti nari, tisu uwaazi kiti nanit, ti kunu ti bellin nani ulelere, Kutelle na fere, usughe ushara kiti na nan lai, nin na nan nkul. ");
INSERT INTO amo_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Viti mere vat, na anabawa wani ushaida, bara kogha na ayinna ninghe anan sere usurtu nanya kulapi unuzu lissa me.” ");
INSERT INTO amo_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","A bitrus dutu nbellu nile imone Uruhu Ulau tolo kitene nati nalenge vat na iwa di nlanzu, uliru me. ");
INSERT INTO amo_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Anit alenge na inung wandi nanya na nan kalizu nacunu-vat nalenge na iwa dak ligowe nan Bitrus fiu kiffo nani bara ufillu Nruhu Ulau we wa tolu wang kitene na wurumi. ");
INSERT INTO amo_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Bara iwa lanza Awurumi ane dinsu uliru nin ton tilem ugang izazina Kutelle. Bitrus kauwa a woro, ");
INSERT INTO amo_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Umong wasa anaza nin mmyen nworu na iwa shintin anit alelena isere Uruhu Ulau we umunu arike ku wangha?” ");
INSERT INTO amo_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Atunna ataa ishinto nani mmyen nanya lissan Yesu Kristi. Ifoghe acara aso ligowe nanghinu uduru among ayiri gbardang. ");
INSERT INTO amo_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Nen, niono kadura, nan nuana, alenge na iwa di nanyan Yahudiya lanza alumai tutun nsere uliru Kutelle. ");
INSERT INTO amo_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Kubi na Bitrus ndaa Urushalima, inung alenge na idi anan kallu kucuru sughe kayasu; ");
INSERT INTO amo_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Iworo “Fe dinsu ligo nin na nan salin kalizu kucuru, umini din su kileo nanghinu!” ");
INSERT INTO amo_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ame Bitrus cizina ubellu nani nimon inda na idi, a woro. ");
INSERT INTO amo_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Meng wadi nlirang nanya kagbiri Njoppa, nta amoro nwui nbellen kukuzun na kuwa tollu, nafo kupee kupash, itoltuna unuzu kitene kani, nin nasari anas, ku da tolo kiti nighe. ");
INSERT INTO amo_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","nceo iyizi nighe ku, nkpiliza kitene, nyene inawa nabunu anas kutyin, inawa ididia kusho, in wunnu naburi, nan nanyin kitene kani. ");
INSERT INTO amo_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Nnin lanzu liwui li woroiyi “ Fita Bitrus, mollo ulii!” ");
INSERT INTO amo_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Meng woro na nanere ba, Cikilari, bara na imomon nsalin lau sa indinong nsa pira unnu ninghe ba.” ");
INSERT INTO amo_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ama liwuiye kawa tutun unuzu kitene kane, “Ile imon na Kutelle nbelle idi lau, nafe nwa yiccila inin indinong ba. ");
INSERT INTO amo_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ile imone wasu nani udu titat, nin nani vat nimone iwa kpilin mun udu kitene kane tutung. ");
INSERT INTO amo_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Na nin molu kubi ba, kikane among anit natat, wa yisssin nbun kilare na nwa duku, itoo nani unuzun Kaisariya udak kiti ninghe. ");
INSERT INTO amo_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Uruhu tayi nnya nanghinu, na nwa su maferuferu kiti mine ba. Nuana nane kutoci ne nya nanmi, udu nanya kilari nniti une. ");
INSERT INTO amo_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","A belle nari yanda na ayene anan kadura Kutelle nanya kilari me, inin woro “Too anit udu Ujoppa idanin Bitrus ulenge na idin yiccughe Simon. ");
INSERT INTO amo_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ame ma liru nanghinu nbellen kadura kanga na ubase utucufe nin vat kilari fe.” ");
INSERT INTO amo_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Na ncizina uliru nanghinu, Uruhu ulau tolo kitene mine nafo na uwa tolu nghireke nin cizinue. ");
INSERT INTO amo_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Meng lizuno nin lirun Cikilari, na awa woro, “Yuhana ame wa shintizin anit nin nmyen; ama anung ima shintizunu minu nanya Ruhu ulau.” ");
INSERT INTO amo_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Andi Kutelle wa ni nani ufillu nafo na ana ninari kube nati wa yinnin nin Cikilari Yesu Kristi, menghari wadi nworu in yissin gambalang nin Kutelle?” ");
INSERT INTO amo_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Na ilanza ile imone, na itardaghe uliru ba, iwana zazin Kutelleri, iworo, “Kutelle nani Awurmi likara nsunu naliapi wang.” ");
INSERT INTO amo_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Bara nani anan yinnue na iwa sono uniu ulenge na uwa cizin kubin Istifanus wati nani imala kiti vat unuzun Urushalima-alenge na inya ido pit udi duru Ufinikiya. Iwa bellu ubeleng nlirun Yesu kiti na Yahudawari cas, ana umon tutung ba. ");
INSERT INTO amo_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ama among anit, unuzun Saipirus nin Serene, wadak Antakiya ida su a Hilinawa nin wazin Ciklari Yesu. ");
INSERT INTO amo_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Tutung ucaran Cikilari wayita ligowe nanghinu; anit gbardang gitirno iyinna idofino Cikilare ku. ");
INSERT INTO amo_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ubelleng mine da duru atuf nanan kilarin lira in Urushalima; inani wa tuu Barnabas ku udu Antakiya. ");
INSERT INTO amo_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Na awa dak ada yene ufillu Kutelle, ayi poaghe; anin na nani likara nibinayi nworu iso ligowe nanyan Cikilare nin nibinayi mine vat. ");
INSERT INTO amo_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bara awadi unit ugegeme nin Ruhu ulau a uyinnu sa uyenu ni Yesu, iwase ukpinu nanit gbardang kitin Cikilare. ");
INSERT INTO amo_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Barnabas tunna anuzu udun Tarsus adi pizuru Shawulu ku. ");
INSERT INTO amo_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Na awa seghe, amini wa dak ninghe Antakiya. Uni waso nafo nenge, nanya likus iwa sozo ligowe kilari nlira idursuzo anit gbardang. Iwa cizin uyicu nnono kadure anan dortu Kutelle in Antakiyari. ");
INSERT INTO amo_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Nanya nayiri ane among a Anabawa wa dak Antakiya unuzun Urushalima. ");
INSERT INTO amo_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Umong mine unan lissan Agabus, fita ayissina a durso nnuzun Ruhu a woro kukpong kudya ma malu uyii ulele vat. Ile imone wase nayirin Kiladiyus. ");
INSERT INTO amo_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Bara nani, nono Katwawe tunna iworo ituu nin bunu udu kiti linuana in Yahudiya, nafo na kogha ma yinnu. ");
INSERT INTO amo_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Iwa su nani; itoo nin nikurfung kiti na kukune nacaran Barnabas nin Shawulu. ");
INSERT INTO amo_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Nene nkoni kube Hirudus ugowe taa acara kitene namon ale na iwa di anang kilarin nlira anan wulakauta nani. ");
INSERT INTO amo_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","A wa molu Yakubu ku gbanan Yohana nin kusangali. ");
INSERT INTO amo_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Na ayene imone ntaa Ayahudawe mang, anyaa cindu kitin Bitrus ku tutung, kone wadi kubin nborodin salin yeast. ");
INSERT INTO amo_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Na akifoghe, ataghe nanya kilari licin, na anang ncaa anit likure nin kutocin din ucaa me. A wadi nin su ada ninghe nanya nanit iwa malu ubukin Paska. ");
INSERT INTO amo_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Bara nani iwa ceu Bitrus ku nanya kutii licin, bara nani iwa tizughe nlira nanya kutii nlira midya udu kiti Kutelle. ");
INSERT INTO amo_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Udu ukurtunun nkuiye na ima nutunghe ninkutike Bitrus wadin moro kiitik nanang ncaa me naba. Itereghe nin ninyeng iba anan caa kibulunghe nyenju kilari licine. ");
INSERT INTO amo_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Gono kadura Kutelle daa kiti me, nkanang nin daa nanya kutiiye, akpeu Bitrus ku likot afyaghe anin woro, ““Fita mass.” Iyenghe nin deu nacara me. ");
INSERT INTO amo_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Gono kadura Kutelle woroghe, “Shoono imoon fe nin nakpatak fe.” Bitrus ta nafo na ibelinghe ba. Gono kadura Kutelle woroghe, “Shoono kulutuk ku dya fe udofini.” ");
INSERT INTO amo_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Bara nani Bitrus dofino gono kadura Kutelle udu udas. Na awa yiru imon ile na gono kadura Kutelle ntaaghe wa di kidegenere ba, a wadin su sa adi namoron wuiyari. ");
INSERT INTO amo_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Na ikata kibulun kin funu nin kin ba, idaa kibulun nikora kaa na kipira nanya kagbirel kibulunghe puuno usamme, inuzu inyaa udu libau, gono kadura Kutelle nyaa a sunghe kikane. ");
INSERT INTO amo_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Na Bitrus nzinto, a woro, “Nene nyino Kutelle ntuu gono kadure me ada tu cui nanya nacaran Hirudus, nin kpilizu unanzang na Yahudawa.” ");
INSERT INTO amo_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Na ayinno nani, adaa ngan Maryamu unan Yohana ule na lisa lin ba me wa di Markus; anang yinu nin Kutelle gbardang wadi ku idin nlira. ");
INSERT INTO amo_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Na a reu kibulunghe, nkung kubura kucin lisa me Rhoda da amada kpanghe. ");
INSERT INTO amo_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Na ayinno liwuin Bitrus, bara liburi liboo na ayino upunu kibulunghe ba; akpila nin cum udu nanya kutiiya; a benle nani au Bitrus yisin kibulung. ");
INSERT INTO amo_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","I woroghe, “Kibinai fe nwuluara so.” Ame dirtino nduu nanere, I woro “unang kadura mine.” ");
INSERT INTO amo_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Bara nani Bulus leu ubun nfoo kibulunghe, na inin da punoo kibulunghe, itene amere umamaki kifo nani. ");
INSERT INTO amo_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Bitrus lirina nin nacara me au iti tik, anin belle nani inda na Kutelle nnutunghe nanya kilari licin, a woro, “Benleng ile imoone kitin Yakubu nin kagisin linwana.” Anin nyaa udu nkon kusari. ");
INSERT INTO amo_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Na kitin shanta, manyardan madya wa fita nanya nanang ncaa kilari licine sa iyanghari nse Bitrus ku. ");
INSERT INTO amo_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Na Hirudus npiziraghe na ayeneghe ba, a tiro anang ncaa we aworo na imolu nani. Anin nyaa unuzu Yahudiya udu Ukasariya adi soo kikane. ");
INSERT INTO amo_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Hirudus wa nana ayi nin nanitin Taya nin Sidon. I doo kiti me ligowe iresa Blastus, unan buunung ngowe, a buun nani, I pizira lisosin limang bara na imonli mine wa nucu ngangowere. ");
INSERT INTO amo_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Nlong liri Hirudus shono Imoon tigowe ada soo kitene kutet tigowe, anin benle nani uliru. ");
INSERT INTO amo_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Anite taa ntet I woro, “Lole liwui Kutelleari na lin nitari ba.” ");
INSERT INTO amo_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Kitene gono kadura Kutelle penghe bara na a wa zazin Kutelle ba; ishung wa lighe a kuu. ");
INSERT INTO amo_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Uliru Kutelle kuno kang unin maka kiti. ");
INSERT INTO amo_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Na Barnabas nin shawulu nsaa unuzun Urshalima, naimala kadura mine; I yira Yohana ku ule na lisa limba me wadi Markus. ");
INSERT INTO amo_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Nene nanya ligozi na kagbirin Antakiya, anan liru nin nnu Kutelle nin nanan dursuzu yita ku. Tisa mine wa di Barnaba, Simeon (na iwa yicughe Niger), Lukiyus unitin Karita, Manain (unan liwalin gwanan Hiridus kukune me), nin Shawulu. ");
INSERT INTO amo_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Kube na ndin zazinu Kutelle nin sun kotu nayi, Uruhu Ulau woro, “Feren ni Barnabas ku nin Shawulu, isu katwa kanga na nna yicila nani bara kanin.” ");
INSERT INTO amo_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Na ligozen mmala ukotu nayi nin lira, i wunno nani likoot inin tarrda nani acara. ");
INSERT INTO amo_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ame Barnabas nin Shawulu suu ubiyayya nin Ruhu Ulau itunna i nyi udu kusarin kilikiya; unuzu kikane idi tunun udu nlong lidan nanya kurawan kubrus. ");
INSERT INTO amo_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Kubi na iwa di nanya kagbir salamis, ibelle uliru Kutelle nanya kutyi nlirag, na Yahudawa, inung tutun yita nan Yohanna Markus nafo unan buunu mine. ");
INSERT INTO amo_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Kubi na inya udu vat lidan kiyitik nmyen, udu Bafusa, idi se umong unan nizu tikanlang, ku Yahudawa, unan su kinu nin nnu Kutelle, ulenge na lisa me Bar Yesu. ");
INSERT INTO amo_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Unan nizu tikankane munu liti min mukadas, Sargis, nin Bulus unit ujinjin, unit une wasu manyardang nin Barnabas a Bulus, bara adinin su alanzauliru Kutelle. ");
INSERT INTO amo_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ame Alima unan “nizu tikankang” (nanere lisa me di) asu ivira nanghinu, asa likum nworu a kpiliya Sarijiyus ku nanya nyinnu sa uyenu me. ");
INSERT INTO amo_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ame Shawulu, ulenge na idin yicu Bulus, awa kullun nin Ruhu Ulau a borioghe iyizi ");
INSERT INTO amo_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","anin woro, “Fe gono shaitan, ukulun nin kinu a karusuzo, nin magunta, fe unan nivira nin vat ko iiyeme imon icine, na uba sunu ukpilizu nimon idert in Cikilari ba sa iba sunu? ");
INSERT INTO amo_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Nene yene ucara Cikilari di kitene fe, uba da lawu uduu. na iba yenu uwui ba nin kubi baat.” Dedei luwutun nin nsirti, a cizina kiti, intiri nanut ikifo ghe ucara. ");
INSERT INTO amo_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Kubi na ame Sarjisu nyene ile imon na idi, ame yinna, bara awa kifo unuu nin ndursuzu kitene Cikilari. ");
INSERT INTO amo_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Nene Bulus nan nadondon me, kaffina unuzu Bafus udu Perga nanya Pamfiliya, ame Yohanna suuna nai a kpila Urushelima. ");
INSERT INTO amo_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Bulus nan nadondon me, cinna unuzu Bafos udak Antakiya Nbisidiya. Kikane inya udu kutyi nlirag liyiri nassabar idi soo kikane. ");
INSERT INTO amo_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Kubi na ibelle inyerte nduka, nin na nan nliru nin nnu Kutelle, udia kutyi nlirag too nani nin kadura a woro, “Linuana, andi idinin nkan kadura, kan kpinu nagang kiti nanite kikane, bellen kanin.” ");
INSERT INTO amo_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Bara Bulus fita ayisina a zillino liti me, a woro, “Annit Israila nin nalenge na idin zazinu Kutelle, lanzan. ");
INSERT INTO amo_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Kutelle nanit ale Israila wa feer acif bite ata nani anit gbardang, kubi na iwa so nmyin masar, nin nacara nakara awa nutun nani kitee. ");
INSERT INTO amo_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Udu akus akut anas, ayita nanghinu nanya kusho. ");
INSERT INTO amo_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kubi na awa mallu nin nipin kuzor, nanyan nmyin kaana, anaa anit bite nmyin mine miso nani ugadu. ");
INSERT INTO amo_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Vat nile imone iwasu inin ukatu nakus akalt anas nin nakut ataun, kubi nile imone vat, Kutelle na nani unan wucu kidegen udu Samaila unan nliru nin nnu Kutelle. ");
INSERT INTO amo_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Mammal nilele, anite tirino ini nani ugo, Kutelle na nani Saul ku usaun kish, unit unuzu likuran Banyami, bara kubi nakus akut annas. ");
INSERT INTO amo_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Na kutelle nkalaghe nanya nanan tigo, a yauna Dauda ku aso nani ugo, uwaso kitene Dauda kutelle wa woro, 'Nnase Dauda usaun Jesse aso unit nayi nighe; aba su vat nile imon na ndinin su we.' ");
INSERT INTO amo_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Unuzu kuwunu nnit ule Kutelle ba da ni nonon Israila ku unan tucu, Yesu nafo na anusu alikawali nsu we. ");
INSERT INTO amo_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Uleli imone wa cizin kube, kamin Yesu dak, Yohanna wa cizin ubellun nshimtinnu ndiu kutyin, udu kiti nanit Israila vat. ");
INSERT INTO amo_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Na Yohanna wadi malizunu katuwa me, aworo, 'Anung din su meng ghari? Na mere ba, ama lanzan, umong din cinu udak kidung nighe, akwatak nabunu me na meng batin nbunku ba.' ");
INSERT INTO amo_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Linuana, nono nanya kuwunu Ibrahim, nin nanya mine na idin dortu Kutelle, kiti bitere, kadura nbellen nnan tucu iwa tuu nari mun. ");
INSERT INTO amo_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Bara inughe na iwa sosin nanyan Urushelima nan nago mine, na iwa yinin ghe ba, sa iyinin tiwui nanan nliru nnu Kutelle na isa ibelle ko ayeme assabar, ina ni na Kullo ubellu we, kadure nti Yesu unan kul. ");
INSERT INTO amo_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Vat nani na iwase imomon icaut kiti me nworu akuu ba, itirino Bilatus ku nworu amollu ghe. ");
INSERT INTO amo_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Kubi na imala vat nile imon na ina nyertu liti me itoltunghe kitene kutca, inonko ghe nanya kissek. ");
INSERT INTO amo_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Amma Kutelle wa fya ghe nanya na nan kul. ");
INSERT INTO amo_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Anit gbardang wa yenje ghe nanya nayiri gbardang na lenge na i di ligowe nan ghe na i wa nuzun Galile ne indu Urushelima. Anit alelere iyizi naba me kiti nanite. ");
INSERT INTO amo_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Bara nani ti da minu nin liru unang imbeleng nciu nnuu ulenge na iwa su an kaa bite unin uworsu: ");
INSERT INTO amo_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Kutelle na ceo nari uciu nlirne, arik nono mine, nworu Kutelle wa fya Yesu ku kisssek. ");
INSERT INTO amo_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ununu kidegen nworu ana fya ghe nanya na nan kul bara kidowo me wa yene ubiju, amini wa su uliru nenge, 'Mma nifi nkoli milau in nanda milau.' ");
INSERT INTO amo_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Unnare nati ana kuru abelle nan nya namong avu tutung: 'Na una yinnu unit ulau fe a yene ubiju ba.' ");
INSERT INTO amo_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Bara na kimal na Dauda wa su Kutelle katwa kubi kiyi mine gegeme kanin aku. iwa aoroghe nin na cif me, amini wa biju, ");
INSERT INTO amo_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","amma ame ulenge na Kutelle wa fya Kissek na awa yene ubiju ba. ");
INSERT INTO amo_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Linuana na iyinnin ilele, unuzu nlele ina sun nari unuu nbeleng nkussu nalapi. ");
INSERT INTO amo_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Bara ame vat ule na ayinni ma se usurtu nan nye vat ule na ti tisse usurtu mun ba. ");
INSERT INTO amo_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Bara ceon nibinai kiti kirum bara imon ile na a annabawa na belin kitene i wa minu ba. ");
INSERT INTO amo_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Yeneng, anung anan nanzu nimon nafi fiu kifo minu inana. Bara meng din su katwa nayiri mine, Katwaa kango na ima yinnu mun ba andi ma umong ma belin minu ubeleng kanin.'” ");
INSERT INTO amo_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Na Bulus nin Barnabas nnyaa, anite fo nani acara nworu ikuru ida belu nani uliru urum une Asabar ncin dak. ");
INSERT INTO amo_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Na uzuru kilari nlire nmala, Ayahudawa gbardang nin namon anan salin dortu Kutelle dofino Bulus ku nin Barnabas, alenge na iwa su nani uliru i woro nani ili ubun nin cin nan nya nbolu Kutelle. ");
INSERT INTO amo_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Assabar nda duru anan kagbiri vat da zuro inan lanza uliru Ncikilari. ");
INSERT INTO amo_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Na Ayahudawa in yene ligozi nanite, ikulo nin shina isu uliru uganbalang nin nilenge na Bulus nbelle izoguzo ghe. ");
INSERT INTO amo_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Amma Bulus nin Barnabas su uliru nin nayi akone i woro, “Uso gbas i cizin ubelu anughe ku uliru Kutelle. Na iyene nworu anung nfillo unin ina nin yira ati mine na ucaun ise ulai nsa ligan ba, yeneng, tima kpillu kiti na wurmi. ");
INSERT INTO amo_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Bara nanere Cikilari na bellin nari, aworo, 'Nna ceo minu nafo nkanan ucin du kiti na wurmi, nworo adak nin adak nin tucu nan nyan vat niti nan nya in yii vat'” ");
INSERT INTO amo_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Na Awurme nlanza nani, ilanza mmang kang izazina lissa Ncikilari. Ngbardang nalenge na ina fere nani bara ulai nsa ligang wa yinnin. ");
INSERT INTO amo_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Uliru Kutelle wa malu kiti vat nan nya nmine. ");
INSERT INTO amo_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Amma Ayahudawa su ubeleng nawani anan ni nati alenge na idi nin nimon icine. Ileli imon ta nworu ipiziru umonlun Bulus ku nin Barnabas iko nani inutuno nani unuzu kipin mine. ");
INSERT INTO amo_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Amma Bulus nin Barnabas kotuno lidau nabunu mine liso nati mine. Inya ucindu kipin Ikoniya. ");
INSERT INTO amo_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Nono kadura wa kulo nin nayi abo a Uruhu Ulau. ");
INSERT INTO amo_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Nyan min Iconiun Paul nin Barnabas iwa piro kutii lira na Yawudawa, i belle tipipin Yise nin likara me. amini wa ti, a yahudawa nin na Greek i yinna nin tipipin Yesu. ");
INSERT INTO amo_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Vat nin nanin among a Yhudawe wa yinin ba, inin belle anan salin yinu Kutelle ba inari, ita nibinai nanan salinyinu Kutelle nan. ");
INSERT INTO amo_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Nin nan Paul nin Barnabas i ya don-don kite ne kan imini wa lira tipipin Kutelle sa fiu, amini wa ninani kaduran bolu Kutelle kana ti kamata ti se ba ");
INSERT INTO amo_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Vat nin nanin anite i wawuchu kidaw, among ima dofunu among nin belle indofunu nono kata Y bellin esu. ");
INSERT INTO amo_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Nin nanin anan salin yiri Kutelle, nin na yahudawa, i wa tinin risu na dida mine, inan taasu an Paul nin Barnabas, ");
INSERT INTO amo_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Dana ulire daa kutuf nan Bulus nin barnabas imini iwa chun ka gbire udu nmin Kagbiri Liconia, Listra nin Derba a usauran niti naana nidi pit ba. ");
INSERT INTO amo_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","kikanare tutung an Paul nin barnabas iwa tinin bellu nani nin dursuzu ani tipipin Kutelle, ");
INSERT INTO amo_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Nan Listra umong unit wa diku salikara nabunu. Kubi kona uname wa marighe, na a sa tabina u sun chinba. ");
INSERT INTO amo_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Unit une wa lanza paul ku inliru, dana paul yeneghe, paul yinno, yinnume sau yenume matighe ashin. ");
INSERT INTO amo_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Amini wa belinghe nin liwui kan “fita nin nabunufe, “Ninnanin unite ghina nin nabunume atinan chinu. ");
INSERT INTO amo_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Dana anite yene ile imon na Bulus in su, ittunna ighantinna tiwui mine in belu nin tilem Nikoniyum “atelle abebene danari nafo anit.” ");
INSERT INTO amo_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Inin naa an paul nin Barnabas tisa, barnabase inaghe lisa “zeus”ame paul iyichilaghe nin lisa“harmas”bar ame wadi unanliru udiawe. ");
INSERT INTO amo_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Kutin prist zeus wadik kibulun kagbiri, ame nin anite, itina i nuzu kap udas nin nin Ninamine a tifulawaamomoagigimeichizina unakwizu usakirfais. ");
INSERT INTO amo_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Tutun Paul nin Barnabas lanza nanin inuzu nin kibinain kibibit nin jartina ");
INSERT INTO amo_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","inin woro anite bar yanghari imasu ilaimone? bar nanin na iwa molu inamine ba, arikima anitari nafo anighe, tida mini nin liru uma, tidimun su ichin imon inazan ine idak kiti Kutelle un nan la, amare ulena anake kitene nin kutin ah kuli kubgardan ");
INSERT INTO amo_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Nayirin burne, vat mine alenge na idi Ayahudawa ba wadin dortu namong atelle na iwa dinin suwe. Kutelle wa yinnin idortu nani bara na iwa yirughe ba. ");
INSERT INTO amo_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Ama awa durso nari nworu adin sunari katwa kacine. Amere asa ata uwuru ju, akuru ata imuse kunjo. Asa aamere tutung nafi imoli, ukuru akulo nibinayi mine nin nayi abo. ");
INSERT INTO amo_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Anite wa lanza imon ilenge na Paul nbelle, vat nin nani iwa yita nin su inakpiza ina ididya ine isu Paul nin Barnabas ku usujada. Ama udu nimalighe, anite kpiliza na isu ba. ");
INSERT INTO amo_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","among a Ayahudawa, da unuzu Antiyok nin Ikoniyum, iwa dak ida risa anite gbardang nin nanan Listira inin nworu ilemon na Paul din bellu mimnu kinuwaridi. Anite na iyinna nin lire na Yahudawe tunna ilanza ayi nin Paul. Ita a Yahudawa tinnan filisu pau, inin kuru wunughe udu das kagbir, kikane iwa chiso aku ");
INSERT INTO amo_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Among na iwa yinni nin liru Kutelle Listira wa tinin iyisina ku popo Paul, kikane na awanonku kutinghe. Paul tunna azinto. Anin fita nya nin nanan yinnun nin liru Yesu inin pira ka gbire. ");
INSERT INTO amo_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Iwa so ita ayiri kikane ka, ile ubun bellu tipipin Yes, aniti gbardan wa yinin nin tipipinghe, nin kidu Paul nin Barnabas ita ubellen kwilu. inin kuru ida u Listira. inani wa kuru ikata udu Ikoniyum ini kuru ikata udu ka gbiri Antiyok nanya Pisidiya ");
INSERT INTO amo_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Vat kika na ipira iyatinin nizu linana likara nayi, na iwa lanza fiu ba, imini wa balin nanin yinu mine nin salin yenu itere kibinai mine nan ny, bar nanin nan nya tikanchi tona tinare matinari tipiru kitekanekilari Kutelle ");
INSERT INTO amo_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Paul nin Barnabas wa fere adidya nanya ligozin nanite. Nin tin bellen gniu nan nya nite Paul nin Barnabas inanin wa pitirin anite, i ta ayiri nan ghinu i nin ta ilira nin kifin unusauli ninmunli nin nanin Paul nin Barnabas ininnakwa nanin kiti Kutelle udia urkana iwa yinin ninghe ama bunu nanin, ");
INSERT INTO amo_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Unuzu kidun, an Paul nin Barnabas, wa kata udu pisidiya inin da Upampiliya. ");
INSERT INTO amo_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Nanya kusa kone, inin lirina tipipin Kutelle nan ghe ka gbiri Perga innin kata udu Attalia. ");
INSERT INTO amo_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Kikanner, iwa nin pira ujirgi mmen intina i kwiila udu Antakiya, nanghe kagbiri in Siriya. Kagbiri kanere iwa fere Paul nin Barnabas do nnan niti idi su uwaze ku, tutung niti nanga anan yinnu nin Yesu wasu nlira Kutelle bun Paul nin Barnabas nanya katwawe na ina malu nene. ");
INSERT INTO amo_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Kubikono iwadak nanya Antiyok inin yichila anan yinnu sa uyenu kitikirum, inin belle elemon na Kutelle nasu nin punu kibulun udu iktinanan salin yinu Kutelle ini selibou lirika longo na lima du nin ghinu kitene nin yinnu yesu ");
INSERT INTO amo_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Nin nanin Paul nin Barnabas wa dodon nin nono kata Kutelle ");
INSERT INTO amo_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Among Ayahudawa nuzu kusari Urdun nin da kagbiri Antiyok. Inin tina dursusu na lumai na iyina nin yesu kikane inin woro “ulena ina bogye ba na ama piru kitenekane kana, nafo tipipin musa ");
INSERT INTO amo_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Kube na Buluse nin Barnabas wasu maqyerdan nan ghinu, anan yinnusauyenu nan nya Anticok intin na iwor, Bulu, Barnabas nan na mong ido u Urshalima kiti nannan kadura Yisa nin nin nakune i yene utirunun. ");
INSERT INTO amo_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ninkidu, Bulus nin Barnaabas ah among anan yinnu sa usalin yenu wa tunanin nuzu nan nya Antio, inanin wa chinu ikata kusarin Ponenisiya nin Samariya. In chin mine kap iwa yisisin niti niti, inanin wabelin anan yine sa usalin yenu nin woro alumai yinna nin Yis. dana ilanza ulur, vat anan yinu Yisa niti niti nibinai mine wâ kulo nin liburi libo Kan. ");
INSERT INTO amo_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Dana, Bulus nin Barnabas nin na mong duru nan nya Urshalima, nono kata yesu wa seru nanin nin kibinai kibuo nin na kune ah among anan yinnu lipitin kikane. Nin nanin Bulus nin Barnabas belle kadura nilemong na Kutelle na su nin ghinu nan nya na Alumai. ");
INSERT INTO amo_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Tutun amon Ayahudawe na iyinna nin Yesu, inin idi nan nya na Farisawa imini wa fita nan nya nanan yinnu Yesu ì wor, “inin Alumai mase ulaiba sai isu nanin ubuo na churu inin dofuno tibau Musa tona Kutellẹ na nighe.” ");
INSERT INTO amo_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Uliru une wa ti anan kadura nin na kune isọ ktikirum isu uliru kitene. ");
INSERT INTO amo_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Nin kidun ile kubi nin lire kan, Biturus nin fita alirina nin ghinu, aworo, “Linuana anan yinnu sa uyenu, iyiru kap Kutellẹ na fere menku nan nya nanan kadur, inan do di bellin Alumai ule ulir, nin nanin tutun inin ma lanza uliru ukunekune ulena Kutellẹ na sunanin mu inin ma nan yina ninghe. ");
INSERT INTO amo_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Kutellẹ yiru ni binai bite kap. Ana dura menku nin namong, anasaru anan salin yinnu Kutellẹ(Alumai) iyita anitime nin ninanin Ufunu ulau Kutellẹ, nafo arike na ana sunari. ");
INSERT INTO amo_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Kutellẹ na wusu nari ba, anatinanin chaut naghe barna ina yinin nin Yesa. Nanere ana su arikimu ukafara ma. ");
INSERT INTO amo_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Bar yari tima ti Alumai alena yinna nin Yisa sau yenu idofin ti bau na Yahudawe nafo udokan Musa? Usu nanin masin fo ti toro nanin kutura ku getek nabandan min, bar yari timatinanin iyiru kutura ko na ankakani bit ina yinin uyiraba ninna anrik ba titinanin yiru! Bar nanin inje iwa ti Kutellẹ ayi me nana kitene nile umone. ");
INSERT INTO amo_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Tiyiru Kutellẹ na bolunari arik a Yahudawe unuzu tilapi bit bar ilemon na Yesu na su nari. Kutellẹ na bolu arik aYahudawe amini na bolu Alumai alena iyinnu Ningo biteYesu.'' ");
INSERT INTO amo_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Anite vat kitene tatik kubi kona Bitrus wa mala uliru me. Inin kuru ilanza Barnabas nin Bulus, inina nabe kuru belin nanin Kutellẹ. nasu uanfani nin ghinu inani nasu imon idide nan nya na Alumai, imonpuzunu tunu wa nuna Kutellẹ na seru alena Ayahudawe ba. ");
INSERT INTO amo_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Dana Barnabas nin Bulus wamali uliru min, Yakub, udemine atinna alirina nin nnan yinu sa uyenu nan nya Urshalima a woro,”Linuana anan yinusau yenu lanza ilemon na ma belumu. ");
INSERT INTO amo_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Ame Simon ghe malu benlu Kutellẹ namalin ti Alumai mmari nin kidun Ame Kutellẹ nasu nanin anan fere anit ale na imasọ kitime. ");
INSERT INTO amo_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Tipiping to na Kutellẹ na belling uworu, tipipin tona anan yenju-nbun na wa nyerti, tina yinin mu. ");
INSERT INTO amo_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Nin nuzu manin dak ida fere ugoh kilarin Dauda. ima yitu nafo ulena kekilare tutun, na kina nana. ");
INSERT INTO amo_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ima sunanin bar anite vat nan yinno men Ugo kutellẹ ari. Nanin ma so umunu na lena iyiri ba, anit alengena inna yichila nanin i dak kitinin inasonanin dana ina malin punu ununuin ibelle to tipipinghe. ");
INSERT INTO amo_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Inati anitininn iyinnin ile imone tuntuni. ");
INSERT INTO amo_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ame Yakubu tinna aleu ubun liru. Anin woro, “Ninnanin idin yeju na ti chin udamu na lena ichino tilapi mine chindak kiti Kutell, na tiwa woro nanin idofun ti yejee bit nin ti aladubit. ");
INSERT INTO amo_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Natina nyerti tinyerta udu kitimine, ti wo nanin ichin imong inas elena idin suzu: na iwa li inawa hadaya, nin piziru nawani nani, na iwa li inawa ilenghena imalina ut, ikuru ichin ulin mmi ninawa. ");
INSERT INTO amo_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Nan nya ni gbiri gbardan kubi kona kunakata anit na belu ti yejee Musa tona ana nyertin, ti yejee na wantin usu nimon ile. Koyeme uwui na sabbath (uwuizshinu) ase gurtina nan nya, kuti inlira na Yahuduwa. Bar andi alena Ayahudawa ba yinnu nin ti yejee tone, iwangye ise nanin kuti mazurso bit”. ");
INSERT INTO amo_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Anan kadura nin na kun, ninmunu nanan yinu sau yenu yina nin tipipin Yakub. Inanin wa fere among nang nya min, inan tọ nanin nin Bulus ah Barnaba, udu Antiok iti anan yinnu sau yenu kikane i yinin iyari adide mine Urshalim i yinamu. Inanin wa fere Yahuda ku ulena iwa yichighe Barsaba nin Sil. Inin ma wadi adidawari nan nya Urshalima. ");
INSERT INTO amo_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Inanin wa nyatu ti nyerta inin belle Yahuda nin Sila i yiru idini anan yinu sau yene in Antiok.” Arik anan kadura Yesu nin na kune nin nanan yinu sau yenu itọ nari nin nilip kitimine nin nyartinu udu kitimine anin alena idi Alumai anin na iyina sau yenu anin na isosin nan nya Antiok nin uyenkin Siria in Cilicia. ");
INSERT INTO amo_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Anit na belin nari among nanuzu kusari bit ida kitimin, na arikari wa tu nanin kitimine ba. Tiina lanza i taminu nan nya tikanchi kibinai mine nin beli minu imon elena ima rkichinu kibanai. ");
INSERT INTO amo_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Nin nuzu nani, tiwa zuru kikane kitikiru, tinanin na fere among anit tinanin na bellin nanin idak kitimin, inin nin Barnabas ah Bulu, alena tidin kauna mine kan. ");
INSERT INTO amo_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Anit ahwabane nati ulai mine tikanchi bar kata Chikilari bit Yes. ");
INSERT INTO amo_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Tinanin kuru ti tọ Yabuda nin Sila udu kitimine. mma bellinminu elemon na ti su nyerte kitene. ");
INSERT INTO amo_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Tiyene uta chau kitin Funu ulau nin narik na chau i dofin tibau tidoka na Yahudawab. ninnanin tina dumun su i dofin tọ tidoke. ");
INSERT INTO amo_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Chinon uli nimonli elengena ina chil kukot. Naiwa li mmi ninawaba, nin li ninawa elengena imalina utua. Nin tutun ichin u piziru nawani na don mine. Andi i chino usu nileli imon, ima suzu ilemon na chau. imansokalau. ");
INSERT INTO amo_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Anit awa nas na iwaferewe inuzu kusarin Urshalima inanin wa dak u Antiok. Dana anan yinu sau yenu iwa dikitikirum ma inin na nanin ma nyerte. ");
INSERT INTO amo_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Dana anan yinu sau yenu garta unyertine iwa lanza mang nin liuru in, bar ulire wa tinanin likara kibinai. ");
INSERT INTO amo_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Inin wadi anan yenjun bun, Yahuda nin Sila lira kan inin ta ananyinu sauyenu likara kibinai kikane, nin bunu nanin iyinin nan nya Chikilari Yesu. ");
INSERT INTO amo_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Nin nuzu nanin Yahuda nin Sila ilekubi kikane ini. fita ta ubelen kwillu udu Urshalim, anan yinu sauyenu nan nya Antiok ta nanin ilira uduru kalau inin nya. ");
INSERT INTO amo_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ama Sila yinna alawa kikane. ");
INSERT INTO amo_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ama Bulus nin Barnabas ile ubun lisosin nan nya Antiok. Kube dana iwadi kikan, inin nin namon itin dursuzu anite nin su nanin uwa, ázi kitene tipipin Isá. ");
INSERT INTO amo_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Nin nuzu kon kubi Bulus nin woro Barnabas ku,'' nati do kokame ni gbiri ni gbiri ti di lisu linana anan yinu sauyenu kikana tinamaldursuza tipipin Isa Ugo. Nin su nanin tima nin yinnu u chinmine yinnu nin salin yenu mine kitin Isa Ugo. ");
INSERT INTO amo_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas yina nin liru Bulus anin woro uchau ti yiru Yohana ku ulena idin yichighe Markus ti gyah nin ghe tutun. ");
INSERT INTO amo_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ame Bulus belle Barnabas ku na uchau tiyiru Markus kuba, barna Markus wa chinnari kusarin Panphili, amini wa nari ulinbun kata nan ghinu. ");
INSERT INTO amo_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Bulus nin Barnabas wa yinin natimine kitenen lira uneba, bar nanin itina wusọ chingh. Barnabas yira Markus ku ligowe nin gh. Inin pira ujirgin mmen i gyah udu Cipros. ");
INSERT INTO amo_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Ame Bulus fere Sil, ulena na worin dak unuzu Antio, anan su kata nin ghe. Ananyinnu sauyenu kikane itananin inlira nun woro Kutellẹ bun Bulus ku nin Sila. inin inin nabe tinna inuzu kusarin Antiock. ");
INSERT INTO amo_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Bulus tina allebun chin nin Sila vat Siria nin niti Cilicia. Nan nya niti niti iya buzun Anayinu sauyenu Yesu Chikilari nikibinai kirum. ");
INSERT INTO amo_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Bulus nin sila yah udu nigbiri Deber nin Listria inanin wa gwin anan yinu sauyenu kikane. Umong unan yinnu sausalin yenu lisa me wadi Timintawus awa din nan nya Listra. Uname wadi kuYahudawari yinnu sauyenu, ninnanin uchifme wadi ku Helinawari. ");
INSERT INTO amo_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Anan yinnu sauyenu nan nya Listra nin Iconium ibelle imong chine kite nen Timintawus, ");
INSERT INTO amo_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ame Bulus ita nin su uworu ayiru Timintawus ku nin ghe, anin pira niti niti, ma nin su Timintawus ukachiy. Awa su nanin bar a Yahudawa na iwa di niti niti inan sere Timintawus, bar iwa yiru uchif me ku Heliniyawari na awa sughe ukaciya ba. ");
INSERT INTO amo_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Nin nanin ame Timintawus nin Bulus ah Sila, inanin wa chinu nigbiri nigbiri. Ko kame ka gbiri na iwa piru iwa belin anan yinu sauyenu tidokoki to na anan kadura nin na kune na yinin mu nan nya Urshalima. ");
INSERT INTO amo_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Inanin wa bun anan yinnu sauyenu nan nya ni gbiri isu uyinu nin Chikilari Yesu, nin nanin kolome liri anit wa ti anan yinnu sauyenu ");
INSERT INTO amo_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Bulus nin nanan chinme wa kata udu ka gbiri Pirigia nin Galantia, bar na Ufunu Ulau wa naza nanin nin lirunu nan nya ka gbiri Asia. ");
INSERT INTO amo_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Inanin wadak ligan kusarin Mysia, nin nanin iwa dinin su ido kusarin arewa nan nya kagbiri Bitania, kika ne tutun Ufunu Ulau Isa wantina nanin udu kika ne. ");
INSERT INTO amo_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ninnanin itinna gnah udu kusarin Misia nin dak kusarin Troa, ka gbiri ka na ka di kusa nin kurawa ku diya ");
INSERT INTO amo_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ninkitik kane Bulus wa ti amoron yenju kiti amini wa yene umong unit kusarin Macidonia. Amini wa din yinchin Bulus anin woro,”da kiti bite uda bun nari! Masidoniah”. ");
INSERT INTO amo_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Dana awa yene ammoro yenju kiti titinna ti fita ti gna udu Masidonia, bar tiwa yinnin Kutellẹ. ari yichila nari tidi belin tipipin ti pese chine kikane. ");
INSERT INTO amo_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Inani wa chin kusarin troas ipira ujigirgin mmen, ikata udu Samothra, lirin linbe iduru kagbiri Neapolis. ");
INSERT INTO amo_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","kikane tichino Neapolis tinin da Philipia. Ka gbiri wa dinin apani kan nan nya Masodonia, kika na a Romawa diku. Tiwa ti ayiri kan nan nya Philipi. ");
INSERT INTO amo_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Inwui na sabbath tinuzu udas ka gbiri ti do kusarin kuraw. Lanza umon unit woro Ayahudawa ase pitrno kidawo kikane itan lira. Dana tidur, ti yene amon awani pitirno kidawo anan talira, ti tinna ti so nan ghinu, tinin belle nanin ulirun Yesu. ");
INSERT INTO amo_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Umon uwani wadiku lisa me Lidiy, awada nan nya na wanane na iwa din latiszu Bulus ku. ka gbiri wani une wadi Thiatira, awa din lesu na lutuk, nin zazunu Kutellẹ. Kutellẹ wa tighe a lanza uliru ulena Bulus wa di nbel, amini wa yinin m. ");
INSERT INTO amo_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Dana Bulus nin Sila isu Lidia ubaptisma, nin nale na iwasosin gam, amini wabellin nar, “adi yerda men dinin unan fiwu Ketellẹ ari, piran ganin iso ku.” dana abelle nari nanin ti tinna tisọ ingame. ");
INSERT INTO amo_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Inlon liri, dana ti wa chini uduk kika na anit sa pitirno kidawo isun lir, timini wa zuro nin kabura ulena awa di ubaiwa. Awadinin ifunu unanzan agergenu ulena uwa din nizighe likara yenjun bunkiti nanit. Anit wa biza ikubu kitin na lena iwadi adide kubur, nin belin nanin ilemon naima senanin. ");
INSERT INTO amo_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ko kubure wadin dọrtu Bulus nin nanan chin me, achin jertiza,”ale anite din durtu Kutellẹ kona akatin usaura natellẹ nin likara! Idin dursuminu tibau tona Kutellẹ ma bolu minu. ");
INSERT INTO amo_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Kubure wa liubun dọrtunanin nayiri gbardan, Udak ligaghe Bulus ayime nana ka, antina akwila yene kubure anin woro u funu unanzaghe ulena wadi nan nya kubure. Anin belle, Nan nya lisan Isa Christi nuzu udas uchin kuburakone! Sa umọlu kubi ufunu unanzaghe tin na achino kubure. ");
INSERT INTO amo_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Adide kubura kone yeni na adunan sesu nanin nikububa bar na awangha a su tiyenju bun kiti nanite ba, bar nanin nibinai mine nana. Itinna ikifo bulus nin Sila inin yira nani udu kitik nanit nbun nanan nago ka gbiri. ");
INSERT INTO amo_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Adide kubura kone da nin gninu ubun nago kagbiri inin woro nanin, “Anit alele a Yahudawari, idin fizu nibinai nanite nan nya ka gbiri bit kan. ");
INSERT INTO amo_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Idin dursuzu nari tidoka tona arik a Roman yirmuba! ");
INSERT INTO amo_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Anit gwar dofuno alena iwa kifo an Barnabas nin Sila nin liru kinu, itina fonanin. Ago na Romawa ta a sojoje ijera alituk nan Bulus nin Sila inin kwizo nani nin tishon. ");
INSERT INTO amo_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Nin nanin asojoje tinna ikwizo Bulus nin Sila nanza kan nin tishon. Dana imala kwizu nanin yira nanin shintino nan nya kuti lichin. Inin woro unan yenju kuti lichinghe ati iyizi me kan kiti mine bar iya nuzu udas. ");
INSERT INTO amo_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Dana unan lura kuti lichinghe lanza nanin atinna atere Bulus nin Sila anin shintino nanin kuti lichin kun nan nya. Kikane, ata nanin iso kutin inin nakwa abunu mine. anin tere abunu mine nin gna likara kitik nacha, bar bulus nin sila wa ghe ichanchana nin na bunumine ba. ");
INSERT INTO amo_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ghen kitik, Bulus nin Sila iwa tinin nin zazunu Kutellẹ nin su navu. Amon anan kuti lichinghe wa tinin lanzu nanin. ");
INSERT INTO amo_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","kwak kutin tinnan zunu ka. Bar uzunu kuti, kuti lichinghe tina kupuno kidawo nghan na bunu nanan lichighe tin na ibuntu. ");
INSERT INTO amo_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Unan kata kuti lichinghe yene kuti lichin puno kidawo bar uzunu kiti. Awa yenefo anan lichin nuzu ichuo kap. nin yenu nanin a tinna anutuno litan achina molu litime, bar awa yinin ago ka gbiri ma chinghe blin lai ba andi anan lichinghe nuzu ichuo. ");
INSERT INTO amo_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Bulus yene unan kata kuti lichin ghe a tin na a kalan teat ajartina nin ghe,”Na uwa molu litife ba ");
INSERT INTO amo_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Unan kata kuti lichin jartina ninmon ida nighe ufitinla mas anan yene alenghe na udu nan nay kuti lichin. Nin ketizu kidawa nin fiu, amini wa diu inbun Bulus nin Sila. ");
INSERT INTO amo_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Anin nutuno Bulus nin Sila udas kuti lichin anin tirino nanin:”Ulai mine dondon, yari men basu inan sẹ ubale?” ");
INSERT INTO amo_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Inin kwanghe, “Yino nin Isa unan Ugo, fe nin kilari kap ma sẹ ubolu. ");
INSERT INTO amo_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Kikane Bulus nin Sila belinghe nghari Isa kitime nin ko ngha kilarime kap. ");
INSERT INTO amo_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Kikanere unan kata kuti licbinghe kusu nanin niti shaltizumine, nin kani kitik nin kitikke. Kikanere Bulus nin Sila sughe ubaptiszima ame nin kilarime. ");
INSERT INTO amo_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Kikanere unan kata lichinghe yira Bulus nin Sila udu nan nya game anin nananin imonli ili. Ame nin kilarime wa laza liburi libo kan bar inin yinna sauyenu nin Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Nin shantu kitin kuwi, adide benle among asojoji ido kiti kuti lichinghe ibelin unan kata kuti lichin,”Achin awaba lichi ighe nene!” ");
INSERT INTO amo_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Dana unankata lichin lanza nani, atinna abele bulus ku,”Adideh ka gbiri worai nchin minu ighah. CBar nanin anin nabe chinon kuti lichinghe nene inin gah nan nya kibinai kibo!” ");
INSERT INTO amo_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ame bulus nin belle unan kata kuti lichingh, “Adide kagbiri woro anit i kwizu nari ibun nanit, ninnanin arikima Aromawere, inanin na ti nari kuti lichi. Nene idinun su inutun nari sa ubenlu nanit ka gbiri! Na arik yin ba! Sai tiyene ago ka gbiri da ida nutuno nari ninlitimine nan nya kuti lichinghe.” ");
INSERT INTO amo_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Nin nanin asojoji tinna idi bellin ago kagbiri ilemon na Bulus belle. Dana ago kagbiri lanza an Bulu nin Sila Aromawari itinna lanza fi, bar iwa ti imon inanzan. ");
INSERT INTO amo_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Nin nanin ago kagbiri tinna ida woro Bulus nin Sila igaparta nanin ilemon na isu nanin. Ago ka gbiri nutuno nanin nan nya kuti lichin ini belle nanin ichin anin ka gbiri. ");
INSERT INTO amo_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Dana Bulus nin Sila chino kutin lich, itinna pira igan Lidiay. Kikane ise ghe ame nin amon anan yinu sauyenu. Ma inin na anan yinu sauyenu likara kibinai nin yinnu nin Is, kikanere anan kadura chino ka gbiri Philipia. ");
INSERT INTO amo_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Inanin wachinu nigbiri nigbir Amphipos nin Apollolonia ma inin da kagbiri Thessalonika. Kikane wadi kiti zursuzu na Yahudawa ");
INSERT INTO amo_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","In wui na sabbath Bulus pira kitin zursu nafo usum. Tisati tat awa pichu ko ayeme asabbath. Amini wa dursuzo anite tipipinlitafe woro Isa amere mazamu Christi. ");
INSERT INTO amo_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Amini wa nuna nanin nuzu litafe. anan yenjun bun na nyerti kiden ame Misiah maku akura fita nin lai tutun. Amini wabelin” Ule unite amere Isa ah Christi. Anaku amini na fita tutun, nanare anan yenjun bun nabelin”. ");
INSERT INTO amo_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Among a Yahudawa kikane yinna nin nilemon na Bulus belle inin chizina zurzu nin Bulus nin Sila. Kikane ma amon wadiku na Yahudawari ba nin umong uwani unan dortu Kutellẹ amini tutun wa yinin nin liru kitenen Isa, inanin wa chizina uzursu nin Bulus nin Sila. ");
INSERT INTO amo_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Amon adida na Yahudawe ayimine wa nana nin nanite bar na iwa yinin sauyenu nin lirulena Bulus durso nanin. Bar nanin i do idi yichila anit gbarda ini rususzo anit idofin nanin. Nin nanin inin, adide na Yahudawe nin pitirno anit gbardan inin ta jartizu. Ayahudawa ane tinna ido igan Jason kikana an Bulus nin Sila wasosinku. Iwa dinin su inutun Bulus nin Sila udas kitinanite. ");
INSERT INTO amo_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Imini wa se an Bulus nin Sila wadi nan nya kilare b, inanin wa se Jason ma inin kifo gh. Ma inin wunughe nin among anan yinnusauyenu kiti nago ka gbiri. Inin belle” Anit alena idin fizi nibinai iyẹ ida kikanema tutyun. ");
INSERT INTO amo_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ame Jason yira nanin achau in game. Na idimun su kaisar ba. Inanin belle umong unit diku lisame Isa amere ugo kiden. ");
INSERT INTO amo_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Dana lipitin nanite da kitikirum nin nago ka gbiri nibinai mine nana kan. ");
INSERT INTO amo_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ago ka gbiri ta Jason na ikubu inin belle nanin ima ni nanin ikubua andi Bulus nin Sila fia nibinai nanite tutunba. Nin nanin ago ka gbiri in belle Jason nin nannan yinnu sauyenu nyha. ");
INSERT INTO amo_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Nin kitik kan, anan yinnu sauyenu tinna inutuno Bulus nin sila nan nya Thesalika udu ka gbiri Berea. Dana Bulus nin Sila wa duru kikane, itinna i pira kitin zursuzu na Yahudawa. ");
INSERT INTO amo_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ayahudawan Thasalonika wa xinin su lazin liru Kutellẹ nafo Ayahudawan Berea ba, inanin wa lanza gigime uliru kitenen Isa. Kolome liri iwa gartu tipipin nin litimine iyinin kidegen liru ulena Bulus wa bellin kitenen Isa. ");
INSERT INTO amo_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Bar udursuzu Bulus Ayahudawa gbardan yinna nin Isa, nin na mong awani alena Ayahudawaba nin nanilime alena Ayahudawariba wa yinin nin gye. ");
INSERT INTO amo_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Nanin tutun Ayahudawa nan nya thasalonika lanza Bulus din durzsuzu uliru Kutellẹ kitenen Isa. Inanin wa do Uberea inin woro nin nanit alena idi kikane ibelle imong ilena imati ilanza ayi nin Bulus. ");
INSERT INTO amo_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Among anan yinnu sauyenu yira Bulus ku udukuasri lkurawa kuda inan nya udu kan ka gbiri. Sila nin Timintawus wa soh nan nya Berea. ");
INSERT INTO amo_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Dana Bulus nin nanan yinnu sauyenu iwa duru ugefe kuraw, itinna pira ujirgin mmen kata udu kagbiri Antakia. Bulus ninworo nin nale ne dã ninṣhe.”Belle Sila ninTimintawus idak kitinin in Atantakia.” Anite ne chino Antakia ma inin kwila udu Berea. ");
INSERT INTO amo_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Nan nya Athens Bulus soncha Sila nin Timotawus idak. Nan nya nani, achina a kilino ka gbiri. Amini wa lanza mmang kibinaime ba bar ka gbiri wadini chil(idol) ");
INSERT INTO amo_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Amini wa duo kitin zursu na Yahudawa anin lirina kitenen Isa nin na Yahudawa, ah tutun a Greek alena na sere ilemon na a Yahuda yinna mu. Amini wa nuzu udas atinna kolome liri anin lira kiti nanite alena awa zuro nan ghinu kikane. ");
INSERT INTO amo_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Bulus zuro nin among anan dursuzu inanin wa dinin so iliru kitene nilemong na anit yinnamu. anite wa din yichi Among Epicorion, among iyichananin Stoiks. Inanin wa belin Bulus ku ilemong na inin yinnam, inin tiringhe iyeri ame yinnamu. Among woro nin natimine “nafo adinbellu kutellẹ kona tiyirimuba”. Inin woro bar na Bulus wa dinbelu nanin Isa naku amini nafita adimun ilai tutun. ");
INSERT INTO amo_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Among tinna iyiraghe kiti kana kana adide ka gbiri din zursuzu. Dana iduru kikane inin woro nin Bulus, “Benle nari, iyapin imong ipese udin dursuzu anite? ");
INSERT INTO amo_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Idin dursuzu imong ilengena tiyirimung b, bar nani iyadi nari tiyinin iyapimonari ine. ");
INSERT INTO amo_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Anitin Athans nin nalena idi kusari kone ne isosinku, idinin so ilaza uliru upese. ");
INSERT INTO amo_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Nin nani Bulus tina ayisina mbun mine anin woro.”Anit Athaan, yene anughe idinin nadini kan. ");
INSERT INTO amo_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Mbele nanin bar, dana indinchinu mmini yene mmong ilengebna idin zazunu, mmini yene kon kubagadi nin lisa kona idin yichu kunin: KUTELLẸ KONA TIYIRUMU BA. Nene mma belin minu Kutellẹ kona idin zazunu na iyirughe ba. ");
INSERT INTO amo_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Amere Kutelle ulena anake uyi nin nimog vat nan ny. Amere min koyang nan nya kitene nin kutin, na adin sozu kudaga kona inake nin na charaba. ");
INSERT INTO amo_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Na adimin so nimong na ina ke bar ameba Amre nani nari ulai nin ununfash, Amini na ni nanin mmong ilena idimung su. ");
INSERT INTO amo_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Kubin hizine, Kutellẹ nake unit nin wanim, nan nya minere ama maru anit nan nya iye na isozun ko kame kagbiri. Amini ana ti anit niti kubi ");
INSERT INTO amo_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ana dimun su anit yinin anit dinin sume. Bar inan piziraghe inin saghe. Kutellẹ dinin su ti pizirughevat nin nani adi ku popo nan arik. ");
INSERT INTO amo_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Bar Kutellẹre ta tidimi la, tidin chinu ti diku, nafo na umong belle nan nya min, 'bar arik nono mere. ");
INSERT INTO amo_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Barnanin arik nono Kutellẹ ari, na tiwa yene nafo Kutellẹ masin ugold ko usilva ko kutala, kona anit nake. ");
INSERT INTO amo_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Kubi kona anit yiru ilemong na Kutellẹ dinin su mine i su, kubin sirti na ana fuor nanin ba. Bar nanin nene Kutellee na woro anite vat ichin matiza manazan. ");
INSERT INTO amo_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Amini na belin nari umong uwui din chinu na ama da su kogha ku kiwucho kidegen nin niti ulena ana fere, amini nafe unit une nuzun kisek ukul ");
INSERT INTO amo_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Dana anit ilanza Bulus uworo unite fita nuzu kisek dana ana ku, amon mine tin na isisila ghe. Amon nin belinghe adak ilonliri tutun. ");
INSERT INTO amo_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Dana ibelle nanin Bulus tinna ahgha. ");
INSERT INTO amo_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Vatninnanin among dofuno Buluse ku inin yinna nin liru kitenen Isa. Nan nya nanit alena yinna nin Isa umong wa diku lisame Dionysius. Tutun umong uwani wadiku lisame Damaris nin na mong nan ghinu na iwa yinin sauyenu. ");
INSERT INTO amo_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Nin kidu, Bulus chino ka gbiri Athens amini wa gya udu kagbiri Korint. ");
INSERT INTO amo_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Kikane a zuro nin ku Bayahudi ulena lisame wadi Akila nin wanime Briskila itabotak konkubi ninkidun unuzu ka gbiri Roma nan nya Italiya. Ichin Roma bar ugo klidius, wabalin Ayahudawa vat chin Roma. ");
INSERT INTO amo_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Akila nin Briskila iwadin sesu nikubu libau kia adanga. Ame Bulus wa yiru kia nadanga, ninnanin atinna asọ nan ghinu nin su kata ligowe. ");
INSERT INTO amo_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ko ayeme asabbath, Bulus asa do kintin zursu na Yahudawe, amini asa lira nin na Yahudawa ah alena a Yahudawariba. Amini wa dursuzo nanin kitenen Isa. ");
INSERT INTO amo_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sila nin Timontawus dã unuzu kusarin Makidonia. Dana iduru kikane, Bulus tinna achino kata makeke ku danga. Amini wa yiru kubime chin dursuzu a Yahudawa tipipin kitenen Isa. Amini wa belin nanin ai Isa amere Christi. ");
INSERT INTO amo_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Kikane a Yahudawa tinna inari Bulus ku inin tinna na belu imong inanzan kiteneme. Ninnanin atin na azalina lidau nalutik me bar Kutellẹ lanza man ninghinu ba, anin woro nanin,”Andi Kutellẹ ma sumunu uhor, a ma su bar anughere, na bar men ba! Nuzu nene udunbun Inma di belu kiti na Lena a Yahudawari ba! ");
INSERT INTO amo_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Bar nanin Bulus tinna achino kitin zursu na Yahudawa anin duo kilari kana kiwa di kupopo, anin dursuzo kikane. Titus Justus, unan kilare a wadi ku Yahudawa ba amini wadi unan durtu Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Nin kidun, ude kiti n zursuzu na Yahudawa, iwadin yichighe Krispus, nin vat kilarime wa yinin nin Is. anit gbardan nan nya korintian alena lanza Bulus ku iwa kuru yinna nin Isa inanin wa su nanin ubaptiszima. ");
INSERT INTO amo_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Nan nya kitik Ugo Isa nuna Bulus ku nmoro yenji kiti bun anin woroghe,”Na uwa lanza fiu nanit alena idinin sufeba, nin nin nanin na uwa ti tik belu kitenenin ba, ");
INSERT INTO amo_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Bar na inma bunfi na umon ma lanzifi ukule kikane ba. leubun bellu nani kiteni, bar anit di gbardan kagbiri kane naidi anit ni ghari.” ");
INSERT INTO amo_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Nin nanin Blua sọ ata likus kagizi, dursuzu nanin uliru Kutellẹ kitenen Isa. ");
INSERT INTO amo_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Dana Galio so kugovuno Roma kusarin Achai, Adide na Yahudawe nin tinna ikifo Bulus ku. Iyira ghe ido kiti govuno nin liru kinu kitene me, ");
INSERT INTO amo_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Inin wor, “Ule unite din dursu anit izazin Kutellẹ nan nya tibau tona arik a Yahudawa yirimun ba. ");
INSERT INTO amo_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Dana Bulus wa china ulirinu, Gollio nin woro a Yahudawa,”Andi unit ulele puro ma dortu bit a Romaw, da iwa lanzu ilemon na idin belli. ");
INSERT INTO amo_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Nin nanin, idin belu kitene tisa nin madortu mine a nin Yahudawa, bar anin atimine iwangha bele imon kitene ni lemone. Bar nanin na men masu uwuchu kiden kitene nile mone ba! ");
INSERT INTO amo_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Dana Gallio belle nanin, amini wa belin a sojoji inutun a dide na Yahudawa nuzu kitin wuchu kiden. ");
INSERT INTO amo_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ninnanin ani tinna ikifo ude na Yahudawa, Sosthennes. inanin wa foghe ibun kitet wusu kiden. Vat nanin Gallio wa su imong kitene ba. ");
INSERT INTO amo_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Bulus nin tah ayiri nin nana yinu sauyenu nan nya Korinth. amini wa piru kabarak mmen nin Briskila ah Akila inin kata udu u Siria. Amini wa buo titime bar isilin ile na awa su. ");
INSERT INTO amo_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Inanin wa duru kagbiri. Efasu, Briskila nin Akila tinna isuo kikane. Bulus litime pira kitin zursuzu na Yahudawa anin belle a Yahudawa uliru kitenen Isa. ");
INSERT INTO amo_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Inani wa belinghe a ti ayiri, amini wa nari. ");
INSERT INTO amo_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Amini wa bellinanin mma dak in lonliri adi Kutellẹ yinna indak. Ninanin amini wa piru ka barak mmen anin gya udu Efasus. ");
INSERT INTO amo_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Dana kabarak mmen da ka gbiri. Kaiseri, Bulutina atolo. Amini wa piro udu Urshalima anin liso anan yinusauyenu kikane. Ninnanin atinna gya udu ka gbiri Antiok kusarin Siria. ");
INSERT INTO amo_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Bulus leu kubi nin anan yinusauyenu kikane. Ninnanin atinna achino u Antiok anin pira ningbiri nigbiri gwardan kusarin Galantia nin Firigia. Amini wa risu anan yinusauyenu i yini kan nan nya liri Kutenlẹ kitenen Isa. ");
INSERT INTO amo_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Dana Bulus wa diichin nan aya Firisia, ku Yahudawa lisame wadi Afolos ada Efisus. Awa nuzu kusarin ka gbiri Alexzadria amini wa yiru litafi kan. ");
INSERT INTO amo_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Among anan yinnusauyenu durso Apolos ku tibou tona Isa dininsu ait s, amini wadurso imongne kiti nanit. Ninnani, awadi dursuzu imong kap ba kitenen Isa. Bar ame yiru ubaptizzima Yohanari chas. ");
INSERT INTO amo_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Apolos duo kitin zursuzu na Yahudawa, amini wa belin anite kikane kitene nimong ilena amena yini. Dana Briskila nin Akila lanza udursuzu me, itinna iyiraghe udu gamine inan dursuzoghe kan kitenen Isa. ");
INSERT INTO amo_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Dana Apolos yinna ama ghiu udu kusarin Aciya, anan bi nanya Efisus woroghe uma chaunu asu nanin. Inanin wa nyerti udu kiti nanan bin Aciya inin woro seren Apolos ku nin kibinai kirum. Nin duru kikane, amini wa bun alenge na Kutellẹ wa lanza nkune-kune iyinin nin Yesu. ");
INSERT INTO amo_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Apolos wadi liru nin likara nan nadidya na Yahudawa vat nin nalena iwa din lanzughe. Nanyan bellu niyerte ilauwe, awa yinini udursu nani Yesure umasiye. ");
INSERT INTO amo_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Na Apolos wadi korint, Bulus cino Firiziya nin Galantiya anin kata udu u Asia, amini wa kwilin udu Efisus. Anin zuro nin namong i woroghe inin ma anan yinusauyenuri. ");
INSERT INTO amo_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Atirino nani, “Inaseru Ufunu Ulau kubi kona ina yinin nin liru Kutellẹ? Inanin wa kwanghe iworo natina seru ba. Na tina lanza Ufunu Ulau ba” ");
INSERT INTO amo_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Bulus tirino, “ Na iwa shintin minu ushitunu ulauwe, iyaghari iwa yinin?” Inanin wa belinghe,”Tina yinin nin ilemon na Yohana unan su baptiszima na dursuzo” ");
INSERT INTO amo_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Bulus woro(belle), “Yohana na sulsun(baptizpsima) anit alena ina chinu matiza ma nanzan. Amini wa belin anite i yinin nin lena ama dak amini na malin da ninkidun uleli unite amare wa di Yesu.” ");
INSERT INTO amo_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Na anit ane lanza, inani wa su nanin ushitunu nmyen nanya lissan Cikilari Yesu. ");
INSERT INTO amo_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Na isunani, Bulus tarda acarame kitene nati mine, likara Nruhu Ulau tolo nati mine. Uruhu Ulau nanani likara liru nin ton tilem to na inayiruba, inani tutung wa bellu kadura kanga na Uruhu Ulauwe wa belle nanin. ");
INSERT INTO amo_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Iwadi anit likure nin nan waba na Bulus wa shintin nani nmyen (Ubaptisima) isere Uruhu Ulau. ");
INSERT INTO amo_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Tipui titat wa kata, Bulus pira kitin zursu na Yahudawa nanya Afisus ko ayame Asabbat a dursuzo nani nin risu nani kitenen Yesu nin yizari Kutellẹ ma dursu litime amere Ugo. ");
INSERT INTO amo_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Na among a Yahudawa wa yinin nin kadure ba, na iwa di ninsu ilanza tutung ba. Inani wa yitan gwondulu nbellu nimong inanzan kitene nimon ile na Bulus wadi dursuzu nani. Bara nanin Bulus cino nanin ayira anan bi ninghe idi zuro kitin zursun Tiranus. ");
INSERT INTO amo_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Bulus tah akus aba ndursuzu nanite kikane. Nanya nani, ngbardang na Yahudawa ni nalege na iwadi a Yahudawaba, arika na iwa sosin nanya kusarin Asiya inin lanza kadura kitenen Cikilari Yesu. ");
INSERT INTO amo_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Kutellẹ tutung wa ni Bulus ku likara su nimong izikiki. ");
INSERT INTO amo_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Alena iwa dinin tikonu na ise udak kitin Bulus ba, vat kupori ko na Bulus ndudo, asa iyira idi tarda kitenen nan konu, iba shinu uruhu unanzanghe sun nani. ");
INSERT INTO amo_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Kikane tutung among a Yahudawa wadi diku na iwacinu nigbiri nigbiri, inanin wa ko tiruhu tinanzanghe nanya nani nite. Among a Yahudawa wa belu tiruhu tinanzanghe nuzun nanya nanite inin din bellu, “Indin bellu minu nuzun nanya likaran Cikilari Yesu, ulena Bulus na dursuzo nari kiteneme!” ");
INSERT INTO amo_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Iwadi anit kuzora katwa kane. Asaun nmong unitari lissame wadi Sikava, ku Yahudawa, ulena awadin yiccu litime udya na prist. ");
INSERT INTO amo_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Nlonliri ileo ubun kata kane, uruhu unanzanghe nari unuzu kitin nute. Uruhu unanzan woro nanin,”In yiru Yesu ku, nyiro Bulus ku, tutun na umong nani likara ida ti imong imong ba!” ");
INSERT INTO amo_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Nin belu nanin, kwak unit ulena awa dinin uruhu unazanghe tinna ayina adeu kitenen na saun Sikeve. Amini wa fọ nanin kap a lanza nanin ukule. Anin wa jarza nani imon. Ilanza fiu itina inuzu kilare icoo. ");
INSERT INTO amo_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Kap nanit alena iwa sosin nan nya Ephisus, vat a Yahudawa nin nalena a Yahudawa iwa lanza ulemone. Imini wa tinna ilaza fiu bar unit ulena ufunu unanzan wa di nan nya me awa dinin likara kan. nin kubi kurume, iwa zazin lisa Ugo Isa. ");
INSERT INTO amo_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Nan nya kubi kone, among anan yinnusauyenu iwa latisze, anan yinusauyenu gbardan benle ilemong inanzan na idin suzu. ");
INSERT INTO amo_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Among anite na iwa di anidibere tina inutuzuno umon kata mine itinna i juju kika na koghe mayen. Dana anit munu ikurfun ilena imong zuzu nikulume ikurfun duru amui akuta atau. ");
INSERT INTO amo_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Nan nya nanin, anit gbardan lanza tipipin kitenen Ugo Isa inanin wa yininsauyenu. ");
INSERT INTO amo_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Unuzu kidun Bulus mala katame nan nya ifisus, Ufunu Ulau yira ghe ayinin udu Urshalima, tutun nin funu a pira kusarin Macidonia nin Achaia anan yene anan yinusauyenu. Bulus woro, “Nin kidun andin duo Urshalima, ma kuru iduo Uroma tutun” ");
INSERT INTO amo_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Amini watu iyichila awa bã anan bungh, Timontawus nin Erastus, udu Macidonia. Tutun Bulus ninsọ nan nya ka gbir, Efisus kusarin Asia. ");
INSERT INTO amo_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Nin deadai kidun nanin, anit nan nya Efisus chizina ubunkurnu kiti kan bar Isa nin madursuzu kitene me. ");
INSERT INTO amo_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Kikane umong unit wa diku nin lisa Damarius. Awake kuguinki nin lisa Diana. Damarius wadin sesu ikurfun kiti nanit ka nin kani kata makeke ku guinki asa nin lewe manin. ");
INSERT INTO amo_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Darius nin yichila adonkata makeke na guinke. Anin woro nanin,”Anit, iyiru kata kanere tidin sesu ikurfun bit ka. ");
INSERT INTO amo_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Iyiru Bulus ulena asosin nan nya Efisu ana dursuzo anit gbarde na iwa seru ma guinkibit ba mana tinake. Nene ma anit gbardan unuzu kusari ni gbiri nan nya kusari bit na idu sesu nimong ilena tike ba. Bulus na bellin anite atellẹ alena ti din zazunu ah atellẹ riba nin nanin na tiwa zazu anin ba. ");
INSERT INTO amo_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Andi anit lazaghe imati anit malesu lesu bite yisin. Anite mayenu na idinini su idak kiti bite ba tutun nin dak kuti Diana inan su uzazunume. Anite mayenu Diana di udiah ba. Tutun vat anit kusarin Asia nin uyeh kap ma chinu uzazughe. ");
INSERT INTO amo_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Vat anite kikane tinna ilaza ayi nin Bulus dana ilaza ilemong na Damarius belle. Inani wa tinin jarttiz, “Diana kutellẹ bite Efisu di gbardan” ");
INSERT INTO amo_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Anite kan nan nya kagbiri ilaza ayi nin Bulus ini tinna jarttizu. Among anit kifọ Gaius nin aAristachus, inin na bąh jnuzu Macidonia iwa di ana chin nin Bulus. Ninnanin anite kap tinna chium, nin wunu nani udu kikana anan ka gbiri asa isu avuku(theater) ");
INSERT INTO amo_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Bulu wadinin su adue nan nya kiti navuh anan lirina nin nanite, vat nin nanin anan yinusauyenu tinna iwantinghe udu kikane. ");
INSERT INTO amo_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Among ago kagbiri na iwa di adondon Bulus ilanza ilemon na idin chi. Inanin wa tu umong kitin Bulus na wa dak nan nya kiti kuti navuaba. ");
INSERT INTO amo_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Lipitin nanite nan nya kuti na vua ilebun jarttizu. Among wadin jarttizu ni momong dabam among tutun jarttizu dabam. Tutun among nan nya mine wa yinin umon elena iwa din jarttizumuba. ");
INSERT INTO amo_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Umong kuYahudawa lisa me wadi Alezanda. Among a Yahudawa turughe udu bun nanite inin tahghe alirin. Alezanda tinna ah antina ucharame anan tah nanin ichin ujattuzu. Aaadinin su a bellin nanin a Yahudawari ba nati macharantki(troble) ");
INSERT INTO amo_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Tutun among alena iwadi a Yahudawariba iyino Alezanda ku Yahudawari inin yinno a Yahudawa din zazunu Diana kutella ba.” ");
INSERT INTO amo_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Nin nanin umong ugo ka gbiria ta lipitnpin nanit chin ujarttizu. Anin belle nanin, “Linananin anan min, koghe yiru nan nya yiulele kutellẹ bite Diana na diu unuzu kitene! ");
INSERT INTO amo_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Koghe yirumu kap, na umong batin aworo ilemonghe kiden ari ba. Bar nanin na kgha ti tik nene. Naiwa su imomong inazan ba. ");
INSERT INTO amo_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Na iwa danin awa ba ane kikane ba, bar na isu imomong inazan ba. Na idua nan nya na danga bit inin yira imong unuzu kikane, tutun na ilirina imommo inanzan kitene kutellẹbit. ");
INSERT INTO amo_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Bari nanin, andi Damariu nin na nan katame dininsu i ni kogha ku kulapi su imong nanza, na su libau lichine. kika kitin wuchu kidenghe iwawngha idu, kikane anan wuchu kiden duku na ugamnati na fere nanin. Iwangha kifo koghaku idoamu kikane. ");
INSERT INTO amo_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Tutun andi idinin su tirinu imomong, iwangha itirino ago mine inan yene ilemong na imasu kitene andi izuro kitikirum. ");
INSERT INTO amo_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Uzuru ulene uchauba ba! Yiran ubukurnu kiti kane libau lichine bar arik dinisu ti lanza ayi igomnati ba. Adi ago tiri ni majarttizu man, men waghe ikwana nanin gigime ba.” ");
INSERT INTO amo_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Nanere ugo ka gbiri wa belin lipitirunu anite. Amini wa belin kogha ku a kwilin kilarime, inanin wa kwilizin nilarimine. ");
INSERT INTO amo_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Nin kidun anit Efisus chino bukurnu kit, Bulus yichila anan yinusauyenu kiti kirum. Amini wa belin nanin iliubun yinnu nin Ugo Isa. Nin deadai nin kidu, anin bele nanin “sai ilonliri” atinna gya udu kusarin Masadonia. ");
INSERT INTO amo_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Nin kidun amini wa duru kikane, amini wa belin nanin iliubun yinnu nin Ugo Is. Nin nanin atinna a gya udu Ugreece. ");
INSERT INTO amo_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Amini wa ti tipui ti tat nan nya Greece. Nin nanin awa tina akwila udu Siria in kabarak mmen, bar awa lanza a Yahudawa wa chinu umalughe nin chinghe na awa din suo, nin nanin amini wa tinin achina kuntin, amini wa tini a kata tutun udu Macidonia. ");
INSERT INTO amo_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Anit alena wa chinu ninghe udu nan nya Urshalima iwadi Sopater, gonon Pirrus, unuzu ka gbirin Berea; Aristarkus nin Sekundus, ulena awa nuzu ka gbiri Thasalonika; Gaius, ulena awa nuzu kusarin ka gbiri Derbe; Timuntawus, ulena awa nuzu kusarin Galantia; nin Tychikus ah Trophimus, alena ina nuzu kusari Asia. ");
INSERT INTO amo_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Anit kuzuor ane tinna igha ubun nin Bulus nin mi, Luka, nin ujirgi mme unuzu Macedonia, Imini wa dua ka gbirin Troas inanin wadinin su arik nabâ kikane. ");
INSERT INTO amo_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Tutun Bulus nin mi ti china kutin udi pit kusarin ka gbiri Philipia. Nin kidun a Yahudawa imonli isalinyist. timini wa piru ujirgi mmen ulena aachinu udu kusarin ka gbirin Troas. Tiduru Utroas nin kidun nayiri ataung tinin zuru nin na mong na iwa nin bun bit. Vat bite ti tinna ti ta ayiri kuzor. ");
INSERT INTO amo_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Inwuin giga nin kulelen arik nin nanan yinnusauyenu ti zuro kiti kirum tinin liu umonli jibi Ugo tinin liu kiti kirum. Bulus nin lirina nin nananyinnusauyenu udu nan nya kitik, bar awa chini ugyiu udu Troas nin kui. ");
INSERT INTO amo_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Iwa molu inmai tipitinla kuti kitene kan kikana tiwa zuro. ");
INSERT INTO amo_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Kan gono kibene lisame wadi Eutykus kikane. Awa sosin kibulun kibene kitene kuti kun tat kilare. Dana Bulus le kubi liru ka, Eutykus. mmoro yiragh. Ninmal, amini wa lanza moro kan. Amini wa tina adeu nuzu kitene kibulin kibene udun kutin. Among anan yinnusauyenu tinna iyirageh. Inanin tutun waseghe libiaaku. ");
INSERT INTO amo_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Bulus nin tinna atolo tutun. Amini wa nakwa kidawo me kitenen gone anin gwaindirghe nin na charame. Amini wabelin anit alena wasisin kupopome, ''Inje iwa gilu; adu nin lai tutun! ");
INSERT INTO amo_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Bulus, nin na mong, itinna i gnaanaa kitene tutun inin leu inin su ubikin ubulu Ugo. Ninnuzukidun nanin kiti shata uwui nuzu udas a Bulus liru nin nanan yinnusauyenu. Ninanin anin tina gya. ");
INSERT INTO amo_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Among anit nin yira gone udu kilari, nin kibinai kibo bar awa dinin lai tutun. ");
INSERT INTO amo_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Tinanin tiwa piru ujirgin mmen. Tutun Bulus wa nari udoffunu nari jirgin mmen tinan dua nan nya Troas, bar na awa dinin su ado dadai kutin kusarin kagbiri Assos. Among bite tinna tipira ujirgin mmen tinin gya udu Assos. ");
INSERT INTO amo_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Timinin tiwa zuro nin Bulus nan nya Assos. Amini wa piru ujirge nan nin narik tinanin tiwa kata gbiri Miletus. ");
INSERT INTO amo_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Nin liri kidun ti duru Mtylene, tinin fita unuzu kikane tinin duru kupopo kitin kios. Nin liri kidun tutun ti fita udu Samos. Nin kui tifita tutun ti chino Samos tinin kata udu ka gbiri Miletus. ");
INSERT INTO amo_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Miletus wadi kadas nin ka gbiri Efisus. Bulus wadinin su a yisin kusarin Efisus ba bar awa dinin su a li kubi nan nya Asia ba. Andi uchinghe ma chonghe, adinin su a duru Urshalima inwui bukin faska, kubi bukin faske wadi kusa. ");
INSERT INTO amo_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Na ujirgi mmen duru u Miletus, Bulus nin tuo unan kadura udu Efisus ibelin a kune na nan yinnusauyenu kikane idak ida lirin ninghe ");
INSERT INTO amo_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Dana akune da kitime, Bulus nin woro nanin, “Unuzu wui ifunu na inwa dak kikane nan nya Asia kafin ichin minu iyiru kap lisosin ni kubi na iwasuo nan ghinu. ");
INSERT INTO amo_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Iyiru su kata ka na nasu Ugo Isa nin toltunọ kibinai nin kutin nin kon kubi na asan gila. Iyiru inda na tikanchi nin na Yahudawa na ina yininba na iwa chini lanzi ukule. ");
INSERT INTO amo_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Iyiru tutun, dana ina dursuzo mini ka dura Kutellẹ, na ina chin minu nanin sa imong elena ima bunminu ba. Nin yiruminere ina dursuzo mini kadura Kutellẹ kubikona kogha wa diku, nin tutun iwa pichu ni larimine in dursuzo mini kikane. ");
INSERT INTO amo_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ina su ma dursuze kiti na Yahudawa nin na lena a Yahudawari ba, belin mini ichinvat libau linazan nin nibinai tinanzan inin yinin nin Isa Ugo bite.” ");
INSERT INTO amo_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Nin nene na indi nchinu udu Urshalima, bar Ufunu Ulau na durai madu kikane sa u lau, imma du sa ula. Na iyiru yari ma sai kikaneba. ");
INSERT INTO amo_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Tutun inyiru nan nya kokame ka gbiri kana inna piru, Ufunu Ulau wa benli nan nya Urshalima anit mati kuti lichin unanimously mati tikianchi. ");
INSERT INTO amo_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Tutun nanin nama lanzu fiu ba ko anitma ma moli, andi ifinu ima malu kata kana ana yichilai insu. Ana yichilai bellin anit kadura kachine na Kutellẹ na su nari ubolu. ");
INSERT INTO amo_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Ina dursuzo mini kadura Kutellẹ na ana dura litime amere Ugo. Tutun nene inyiru kitimonere anin anan yinnusauyenu ima yeni uyenu ligan. ");
INSERT INTO amo_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Bara indininsu vat alengena ina lanzai udursuzu na iwa kusu sa iyinu nin Isa, nan ima yitu kulapi nin ba, ");
INSERT INTO amo_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","bar ina belin munu umong ilena Kutellẹ na su arikimun. ");
INSERT INTO amo_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Anin adidẹ uchau ili ubun yinnu nin dortu kadura Kutellẹl. Uchau tutun i bun vat alena ina yinninsauyenu, bar anighere Ufunu Ulau nnaniminu yenje nanin. Yenjen litimine nin lipitin na nanan yinusauyenu nafo kunan sukiwọ na asa yenje akam me. Kutellẹ na seru nanin nin mmi michinen saume kitene kuchat. ");
INSERT INTO amo_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Iyiru kan nin kidun andi chinminu, among anit ma dãk nan nya mine ida duro mini kinu ima lanzu anan yinnusauyenu ukule kan. Imayitu nafo ka kayim kana kasa ka mọlọ akam. ");
INSERT INTO amo_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Among ma nan nya lipitin nadidwe kikane ma rusuzu among anan yinnusauyenu nin dursuzu nanin imong inazang. Ima dursuzu minu kadura kana mati among anit yinin mu inan dofuno nanin. ");
INSERT INTO amo_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Bara nanin yenjen kiti kan, na iwa chin yinnu nin kadura kidegen kitenen Isa Ugo bit! Lizinon nin wui nin kitik akusa tat ina durso mini kadura imini wunun minu atuf kan nin mizin isuamichi kiti Ugo bit ");
INSERT INTO amo_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Nene na ima chin minu inta minu inlira (tirino) Kutellẹ yeje minu nin chiminu yinnin nin kadura bolu kana ana sunarimu. Andi iliu ubun nin yinnu kadura kana ina belinmin, imati akara Kutellẹ ma niminu imong chine sa ligang ilena ana silo amani alena di kitime. ");
INSERT INTO amo_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Men ma litinin, na dininsu nikurfun ko alituk achine kitin mong ba. ");
INSERT INTO amo_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Anin atimine yiru kap asan su kata nin nacharanin ina se ikubu nin ilemong men ni na adodon ni dinin suwe ");
INSERT INTO amo_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Nan nya nimong nan su kap, ina nunaminu uchau tisu kata kan tinan se ikubu kan tinan niza alena kajire mala nanin inin dinin suwe. Ikuru lizino ame Isa litime na woro, 'ucharan nizu katin ucharan sesu nin kibinai kipou.” ");
INSERT INTO amo_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Dana Bulus mmala ulire, amini wa tumun nin vat na kune inin ta ilira. ");
INSERT INTO amo_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Vat mine iwa gilu kan, inin gwidirno Bulus ku nin muju tinu me. (kiss) ");
INSERT INTO amo_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Na iwa lanza magba bar na awa woro imasaku yenighe ba tutun. Ina nin wadi kaghe kitin jirgin mmen. (Inanin wa gya ligowe vat ninghe tikin jirgi). ");
INSERT INTO amo_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Nin nizu kidin tinanin wa belin akune sai lonliri unuzu Efisu, tina nin wa piru ujirgi mmen tinin china kitenen mmen udu utudun Cos, kikanere ujirge wayisin nin kitik. uwui unbe tina tipira nan nya jirgi mmen nuzu kusarin Cos tidua utudun Rhodes, kikane tutun ujirge mmen yisina. Uwui kidun dana tiwa piru kipin Patara, kikanere ujirgin mmen yisina. ");
INSERT INTO amo_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","kusarin Patara tinanin wa chin ujirgin mmen, umong unit bele nari kikane umong ujirgin mmen ma katu udu kusarin Phonenica. tinanin wa chin kikane ti piru ujirge mmen ");
INSERT INTO amo_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Tiwa chinu nan nya kurawa kudia ma tinin yene utudun Cyprus. Tiwa kata kusari inyamma tudun tinin leu ubun ichin ti duru kusarin Phoenicia, nin kusari Siria nan nya kipin Tyre. Ujirge mmen ma tiayiri kikane bar anan kata jirgin mmen wa dinin kutura kona ima toltunu ");
INSERT INTO amo_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Umong bele nari kikane ananyinusauyenu sosun nan nya Tyre, nin nanin tisuo nan ghinu tita ayiri kuzor. Bar Ufunu Ulau Kutellẹ na ti nanin yinno anit ma ti Bulus ku tikanchi nan nya Urshalima, inanin wa belin Bulus ku na awa duo kikaneba. ");
INSERT INTO amo_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Tutun dana kubin ta ujirgin mmen ma ghiu, tinna ti su makemake tinan leu ubun chin bit udu Urshalima. Dana ti chino u Tyre, vat anite nin na wani mine ah nono mine ida na arik ubiu kurawa kudia. Vat bite kikane ti tumuno kitene lichichinghe tinin ta ilira. ");
INSERT INTO amo_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Nin kidun tininin su elip nimalin, Bulus nin nanan chime tina ti pira jirgin mmen, ka kisin nanan yinusauyenu tin na ikwila nilarimine. ");
INSERT INTO amo_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Nin kidun tichino u Tyre, tileu ubun nin chinbit udu ka gbiri Ptolemais. Kikane anan yinnu sa uyenu wa duku. Timini tiwa liso nanin tiso nan ghinu nin kani kitike ");
INSERT INTO amo_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","nin kuwi ti chino Ptolemais tinin kata udu kipin Kaesariah, kikanere tiwa so kilarin Philip, ulena awa yiru kubi me kap dursuzu nanit indana imma dofunu yesu. awa di nan nya nanit alena anan yinusauyenu wa fere yenje awa ni alena alesumine na ku. ");
INSERT INTO amo_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Awadinin na shono anas na isa su ulimaba. Ufunu Ulau asa benle nanin kaudura nan nya umoron yenji kiti. ");
INSERT INTO amo_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Nin kidun tiwa di ingan Philip nin na yiri gbarde, umong unan yinusauyenu lisame wadi Agabus amini wadak kusari Judea amini wa duru nan nya kaiseria. Kokome kubi asa belle kadura nan nya moro yenjikiti. Amewadi kuannabi ");
INSERT INTO amo_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Nin daki me kika na tiwadik, ani yira libelt Bulus annin tere nabunu me nin na chara me nin belle, “Ufunu Ulau woro 'adide na Yahudawa nan nya Urshalima ma kifu Bulus ku iterughe nafo nene inanin matighe kuti lichin.'” ");
INSERT INTO amo_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Dana tilanza nanin, arik nin nan nanyinusausalinyenu kikane tinin woro Bulus ku, “Na uwado U4shalima ba!” Inja uwado nan nya Urshalima ");
INSERT INTO amo_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Bulus nin kwana nani, “chinon kuchulu mine nin ti salin likara lkibinai nin woro na iwadoba! bar yeri idin su kuchule nin ti usalin likara kibinai. In na kibinai nin in do kuti lichin tutun unku nan nya Urshalima bar kata Chikilaribit Yesu. ");
INSERT INTO amo_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Dana ti yene ama du Urshalima, tinari uwantin ghe. Tinin woro, “Na uso nanin nafo kibinai Chikilari. ");
INSERT INTO amo_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Nin kidun nayirane nan nya Kaiseria, ninanin wasu makeke nimon bit tinin naya kutin udu Urshalima. ");
INSERT INTO amo_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Amon anan yinusauyenu dofuno nari tutun unuzun Kasaria. Inanin wa yiri nari umong unit lisame wadi Mnason. Awadi kusarin Cypros, ame wadi unan dortu Yesu kubia nin chizunu dursuzu nanit kadura kitene me. ");
INSERT INTO amo_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Dana ti duru nan nya Urshalim, kipi nananyinnusauyenu liso nari nin kibinai kibo. ");
INSERT INTO amo_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Nin kui Bulus nin kagisin bit ti do tidi lirin nin Yakub, amere wadi udia kuti kubowe, kika ne. Vat nin na dida kuti kubo Urshalima wadiku tutun. ");
INSERT INTO amo_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Bulus nin liso nani, anin bele nanin vat ilemon na Kutelle nasu nin nan nya Alumai. ");
INSERT INTO amo_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Dana ilaza nanin, Yakukbu nin kagisin na kune su ugodo kiti Kutellẹ. Nin nanin umong nin woro Bulus ku,”Gwana, uyiru kap arik a Yahudawe karin nan nya kikane na inayinin nin Chikilari Yesu. Tutu, uyiru vat bite tile bun durtu ti sharia to na Musa na ninari. ");
INSERT INTO amo_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Tutun nana bit Ayahudawe alena ina yininsauyenu ina bellin nanin andi nan nya nalena a Yahudawari ba, ibelle a yahudawa alena ina yininsauyenu na isosin nan nya nale na a Yahudawa ba kikane ichin u dortu ti sharia Musa. Anit na woro fena bellin a Yahudawa na inayininsauyenu ichin ubozu na churu nono mine nin aladu bit. Arik na yinin ba bar tina yene idn belu kinuwari. ");
INSERT INTO amo_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Tutun nanua bit Ayahudawa anan yinnusauyenu lanza uda, ima lazu ayi ninf. Bar udinin isu imong na imanunu nanin elemon na ina lanza na kiden nariba. ");
INSERT INTO amo_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Bara nanin su elemon na tina bellen munu isu. Anit awa nas na su isilin nan nya bit kiti Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Chan nin na le anite uduo kiti kuti kubowe idi su matiza mana dininsuzu bar anin nin ghinu isu uzazinu nan nya kuti kubowe. Nin na nin andi kubi nizi liti mine da, beng ilemong na inna. Nin kidun, iwa yna ibasa titi mine nanin mati elemon na ina belin imasu. Andi anite yene minu ima yinnu ilemon na ina belin kinuwari. Kikane tutun ima yinu idin durtu ti sharia na Yahudawe vat. ");
INSERT INTO amo_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Kitin na lena a Yahudawari ba arik akune kikane nan nya Urshalima tina belin ti sharia tona inin ma dortu, tinanin na su ma nyertatinani na belin nanin ilemon na tina yinin. Tina su ma nyert, naiwa li inawa ilena ina nizu ichilmine b, tutun naiwa li mmi ninawa b, na iwa lizu inawa elena ina manling utoh ninin ba. tinanin na belin nanin na iwa pizuru awani nanit. ");
INSERT INTO amo_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Nin nanin Bulus nin yina nin lilemon na iworo asu, nin kunye atinna ayira anit awanas, ligowe itinna ikusu ati mine. Nin kidu, Bulus nin duo kuti kubowe anin bele aprist liri lona ima malu kusu nati mine nin liri lona ima niszu inawa kusu litimine. ");
INSERT INTO amo_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Dana ayiru kuzor dakusa inkulu ikusu nati mine, Bulus nin kwinla kuti kubowe. Among a Yahudawa unuzu Asia ni yeneghe kikane inanin wa lanza ayi nin ghe. Inanin wa yichila a Yahudawa alena iwa di nan nya kuti kubowe ibin nanin ikifo Bulus. ");
INSERT INTO amo_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Inin jartiza,”Israila nuanua, dan ida bun nari ushuru nit ule! ule unitere din dursuzu anit kikana apira innari ma dursuzu na Yahudawe. Adin dursuzu anit ichin udurtu ti sahria Musa, nin nanzu kuti kulau. Amini tutun ana pirin nan ghinu nan nya kuti kubua nin ti kiti kane kiti nanzan? ");
INSERT INTO amo_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Iwa bellin nanin bar iwayene Bulus ku ichin nan nya Urshalima ninbTrophimus bar ame wadi ku Yahudawari ba. Bar usharia mine yinna ku wurmi piru kuti kuboa ba, iwa susa Bulus pira nin Trophimus nan nya kuti kubo in wuine. ");
INSERT INTO amo_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Anit vat ka gbiri lanza kuti kubowe rikiche. inin chuo idakikane. Ininkifo Bulus iwunin ghe udas kiti kubuo. Inin tursu nibulun kuti kubuo. Bar anit wa tirikiche nan nya kuti kubuo. ");
INSERT INTO amo_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Dana iwa chinu umolu Bulus ku umong tina di nuzu nin chum ada kiti kuti kubuo anin belle ugo nanan likum na Roman ah anit gbarden din fizu tirikichi kuti kubuowe nan nya Urshalima. ");
INSERT INTO amo_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Udia nanan likum fita dadai ayira anong anan katame nin na mong anan likum gbardan inin chuo ida kiti kuti kubuawe kikana lipitin nanit wadiku. Dana lipintin nanit alena iwa din kwizu Bulus ku yene ugo likum nin nanan likum din chinu itin ichino kwuizu ghe. ");
INSERT INTO amo_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Udia na nanan likum da kikana Bulus diku atinna akifo ghe. Anin belle anan likumme iteru acharan Bulus nin nga. Anin tirino lipitin nanite, Ghari unit ulele, nin yari asumina? ");
INSERT INTO amo_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Among gbardan nanit kikane iwa tinin jartizu nimomo, among tutun jartizu nimomon dabam. Barna iwa liubun din jartizu kan, ude nanan likumme awa yninin ilemong na iwadi belle ba. Tutun ame ude nanan likum ta iyira Bulus ku pira ninghe anan tirino ghe kikane. ");
INSERT INTO amo_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Anan likumme tin na yira Bulus ku udu kiti kana kidimin likar, Vat nanit tin na durtu nnanin, chinin molu Bulus ku. Tutun ugo nanan. Nin nanin ude nanan likumme tin na aworo anan likum iyiri Bulus udu nan nya kuti likara. ");
INSERT INTO amo_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Lipitin durtu iyita jartizu, “mologhe! mologhe!'' ");
INSERT INTO amo_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Dana iwa chinu uyiru Bulus ku udu nan nya kuti kun likar, anin lirina nin udia na nan likumme nin ti Helenist,”Iwaghe ilirina nin fia? Ude nanan likumme woro, udin lanzu ti Helinanchira? ");
INSERT INTO amo_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Idususa fia unuzu kusarin Masarawari iminin din chinu dani nin likichi kitenen gomnaniti nayiri alena na kata imini na yiru anit amui anas na fea likichi nan nya kusho, nin nanin tima yinu ukifume ba. ");
INSERT INTO amo_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Bulus nin kwan, “babban, menghariba! men ku Yahudawari. Iwa mari nan nya Tarsus ka gbiri kusarin Cilicia. Idinin su ilirin nin na nite. ");
INSERT INTO amo_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Kikanere Ude na nan likumme nin na Bulusku kubi alirin. Kikane Bulus ni nakwa uchara me anan talipitin anit ititik. Nin kidun dana lipitin anite ta tik, Bulus nin lirina nin tiyari mine na Yahudawe. ");
INSERT INTO amo_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Bulus woro, “Akune na Yahudwa nan nuana ning, dinang atuf ilanza ile imon na nba bellu alenge na idin vurzi nliru nene!” ");
INSERT INTO amo_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Na ligozin nanite lanza Bulus nlirina nin lilem in Ibranaci, ita tik, itunna nlazughe. Bulus nin woro nani, ");
INSERT INTO amo_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Meng wang ku Ibraniyawa, nafo anunghe. Iwa marue kipin Tarsus, nanya kusarin Sisiliya, Ama nna kunjo kikane in Urshalima. A ndutu gono, iwa yinnin ti duka to na Musa wani an kabite ku. Gamaliyari wadi unan dursuzui. Nwa dortu ti duka tone bara na nwadi nin su ndortu uliru Kutelle, meng tutung yiru anung vat wang din dortun toni ti duke. ");
INSERT INTO amo_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Unare wati meng fo kidowo nkpazu nalenge na iyinna nin kadura Kutelle kitenen Yesu. Nwa pisuru tibau nmolsu nani. Vat kubi ko na nse nalilime sa awani alenge na yinna nin kadure, asa nta ito nani kilari licin. ");
INSERT INTO amo_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Udya na Prieste wa yiru nani, nanere wang inung anit alenge na iwadi nanya kudaru kudya na Yahudawa wa yiru. Iwa ni iyerte ndomun kiti nuana mine a Yahudawa na iwa di kipin in Damaskus. Mani ma yerte wa ni likara nwo ndo kikane nkifo kogha ku na ayinna nin Yesu. Asa nkifo nani, nnin yauna nani nafo acin udu Urushalima, inin di funuan. ");
INSERT INTO amo_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Inin nya udu u Damaskos. Na nda kupopo Ndamaskus, kubi nikoro likure nin naba nwui, nmong nkanang tunna minuzu kitene susut ninmi. ");
INSERT INTO amo_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Nkanaghe wadii kang ntunna ndeu kutiin. Ntunna nlanzaa liwui nmong din liru ninmi piit kitene kani, adin du, 'Shawulu! Shawulu! iyaghari nta udin yoyi?' ");
INSERT INTO amo_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","In kawaghe, 'Feghari Cikilari?' A worei, 'Menghari Yesu un Nazeret, ulenge na udin yoghe.' ");
INSERT INTO amo_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Anit ale na iwa di nin mi yene nkananghe, ama na ilanza imon ilenge na liwuye wadin belle ba. ");
INSERT INTO amo_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Meng tirino, 'Iyaghari udi ninsu nsufi Cikilari?' Cikilare worei, 'Fita upiru nanyan Damaskus. Umong unit di kikane na ama bellin fi vat imon ilenge na uma su.' ");
INSERT INTO amo_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Nkanang mone wadi kang na nkuru yene kiti ba, nkanang wati iduu. Inung anite naa iwa di nin mi kifo ucara ning inin wonu udu nanyan Daskuse. ");
INSERT INTO amo_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Umong unit na lissame wadi Hananiyas da nda yeni. Ame unitari na awadin lanzu fiu Kutelle nin dortu tiduka na Yahudawa. Vat a Yahudawa na iwa sosin Damaskuse belle imon icine kitene me. ");
INSERT INTO amo_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ada adayissina kupo ning anin woro, 'udondon ning Shawulu, 'tunna nyenju tutung!' Ntunna yenju, nyeneghe ayissin kupo ning. ");
INSERT INTO amo_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Atunna aworoi: 'Kutelle kurika nati dighe nsujada, a kurika na acif bite na sughe usujada na fere fi amanin dursu fi imon ile naa adi nin su usu. ");
INSERT INTO amo_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","A dursofi unan katwa kalau warum, Yesu Umasiya, Uminin kuru ulanzaghe din liru litime. ");
INSERT INTO amo_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Bara nani nene yenje uwa molu kubi? Fita nshitinfi nmyen ushitinu ulau, unin su nlira nanya lissan Yesu Cikilari utiringhe akusufi alapi fe!'” ");
INSERT INTO amo_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Na nkpilla Urushalima. Nlonliri ndo kutii nlira kudya, ntunna nlira, na nwadi nanyan lire kikane, nse litining nanya namoro. ");
INSERT INTO amo_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Cikilare lirina ninmi, aworoi, 'Yenje uwa so kiti kane! Suna Urushalima nene, bara anite kikane mayinnu nin nimon ile na uma bellu nani liti nighe ba!' ");
INSERT INTO amo_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Ama meng woroghe, ' Cikilari, iyiru nwo meng nacinu atii nlira adidya kang in pizuru nalenge na iyinna ninfi. Alenge na nse iyinna ninfi, meng wati itiza nani nilari licin, in wadin fonani wang. ");
INSERT INTO amo_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Idin lizinu nin kubi ko na iwa molu kucin fe Istifanus, meng wayissin kite ndin yenjee nkuru na nani uyinu ning kitene nimon ile na iwadin sue. Meng tutung wang wadi nca nimoon ilenge na anan molume wa kala iceo kusari kurum!' ");
INSERT INTO amo_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ama Cikilare woroi, 'Kayi, yenje uwa so kiti kane! Suna Urushalima, bara meng matufi piit nin kiti kane udu kiti namon anit, na idi a Yahudawa ba!'” ");
INSERT INTO amo_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Anite wadin lanzu Bulus ku nlire se na iwa lanza Cikilarin toghe kiti namong anit. Itunna ighanan jartuzu, “Molonghe! Na acaun uso nin lai tutung ba!” ");
INSERT INTO amo_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Na iwa di nanya jaartuze, ikalza altuk kitene mine inin fizza lidau kitene kani, uleli ute din durru tinanayi mine. ");
INSERT INTO amo_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Udya mine tunna ata iyaun Bulus ku iteghe nanya kilari licin. Aworo nani ikpizu Bulus ku anan belle imon ile na ata inanza a Yahudawa ayi kang nani. ");
INSERT INTO amo_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Inin tunna inakpa acara me itereghe nnunwo ikpizughe kimal me. Ama Bulus belle kusoja kupome, “Uma patilunu uduka andi ukpizai, kunan Rumawa, urika na umong nsa do ninghe kilarin shara akpaghe nin kulapi ba!” ");
INSERT INTO amo_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Na kusoje nlanza nani, ado kitin dya mine adi bellinghe. Aworo ndya nasoje, “Ule unite kunan Rumawari! Iyiru dai na uwasa utanari ti kpizoghe ba!” ");
INSERT INTO amo_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Udya nasoje da ada woroghe, “Belli, fe kunan Rumawari?” Bulus woroghe “e-e.” ");
INSERT INTO amo_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Udya nasoje kawaghe aworo, “meng se nin nikufun gbardanghari inase uso kunan Rumawa.” Bulus woroghe, “Meng kumat in Rumawari.” ");
INSERT INTO amo_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Anit ale na iwa cinu udun tirighe tipinpin tunna isughe deidei. Ame udya nadidya nasoje wang fiu wa kifoghe, kube na awal anza Bulus kunan Rumawari, bara na ame wa terughe. ");
INSERT INTO amo_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Ukurtunun nkuye, udya nasoje wadi nin su alanza kidegen nvurzun liru ule na a Yahudawe dumun' kitenen Bulus. Bara nani abuku time, anin ta udya na Prieste nin vat kudaru me izuro. Anin da nin Bulus aceughe in kitik mine. ");
INSERT INTO amo_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Bulus yenje vat anan kudare, aworo, “nuana ning, Nbun Kutelle, lissosin ninghe licinari udak kitimone.” ");
INSERT INTO amo_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Hananiyas u Priest udya woro nale na iyissin kupo me iriughe nnu. ");
INSERT INTO amo_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Bulus woroghe, “Kutelle ba riufi, fe liki longo naliyissin dert ba. Ussosin nene usui ushara nin duka, uminin ta iriyi nanya purun duka?” ");
INSERT INTO amo_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Alenge na iwa yissin kupome woro, “Nenere udin zoguzung ndya na Priest Kutelle?” ");
INSERT INTO amo_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Bulus woro, “Na meng yiruba nuana, au ame udya na Priestari. Bara ina yertin, yenje iwa lira nanzang kitine nadidya nanit.” ");
INSERT INTO amo_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Na Bulu in yene kusari kudare wadi a Sandukiyawa, a kusari kurum a Farisawa, a ghatina liwui kudare kang, “Linuana meng ku Farisawari, usaun na Kufarisawa. Bara na nceo kibinayi nfeu nanan kul unere nta idin wucui nlira.” ");
INSERT INTO amo_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Na a belle nani, mayrdang fita kitik na Farisawa nin na Sandukiyawa, lisossinghe koso kidowo. ");
INSERT INTO amo_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","A Sandukiyawa din du na ufiu nanan kul duku ba, ana anan kadura Kutelle duku ba, na Uruhu ulau duku ba, ama a Yahudawa na woro vat nileli imone duku. ");
INSERT INTO amo_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Ugbejulu udya fita, among anan niyerte na Farisawa fita fita, idi mayardang nworu, “Na tise imonimon inanzang kitin nit ulele ba. Nene andi Uruhu sa unan Kadura Kutelleri nalirin ninghefa?” ");
INSERT INTO amo_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Na mayardanghe ta madyawe, udya nasoje lanza fiu nwo yenje iwa jarza Bulus ku, ata asoje idi nutunghe nin nakara nanya kudaru lissosinghe, ida ninghe ida ceo kupo me. ");
INSERT INTO amo_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Nin kitik kimbe, Cikilari yissina likot me aworo, “Na uwa lanza fiu ba, Nafo na unasui unu unba in Urushalima, nanere wang umatii unu unba in Rumawa.” ");
INSERT INTO amo_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Na kitin shanta, among a Yahuda munu ati isu isilin nati mine: iworo na inung ma li imonimon sa isono nmyen ba se imolo Bulus ku. ");
INSERT INTO amo_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Anan nisilinghe wa katin anit akut anas. ");
INSERT INTO amo_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Ido kiti ndy na Priest nin nakune iworo, arik nta atibite nanyan la'ana uzemzem, tisilo nwo na tiba lii sa usonu nimonimon ba se timolo Bulus ku. ");
INSERT INTO amo_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Nene na kudare bellin udya nasoje adak nin Bulus kitimine, asa anung nsu usharawe gegeme. Arik ba yissinari tiba molughe ana asa daduru kikane ba.” ");
INSERT INTO amo_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ama umong usaun gwanan Bulus kishono lanza nwo iyeshin nca, a nya adi Bellin Bulus ku. ");
INSERT INTO amo_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Bulus yiccilla umong nanya nasoje aworo, “Yira kwanyana kone udomun kitin dya nasoje, adi nin nimon ile na aba belunghe.” ");
INSERT INTO amo_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Kusoje tunna kuyira kwanyane anin daninghe kitin ndya nasoje aworo, “Bulus kucine yicilai ndo kitime, amini belli nda nin kwanyana kone kitife, adinin nimon ile na aba bellinfi.” ");
INSERT INTO amo_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Nasoje kifoghe ncara ado ninghe kusari kurum, anin tiringhe, “Inyanghari udi ninsu ubelli?” ");
INSERT INTO amo_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Kwanyane woro, “A Yahudawa yinna ima bellinfi udak nin Bulus nin kui kudaru mine, nafo ima tirinu iyinnin inyizari uliru me di. ");
INSERT INTO amo_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Na uwa yinnin ninghinu ba, bara anit katin akut anas na iyeshin nca me. Na silo nin nati mine nwo na ima lii imonliba, sa isono nmyenba se imologhe. Nene wang imal ke atimine, idin ca uyinin unakpaghe.” ");
INSERT INTO amo_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Udya nasoje tunna asuna kwanyana anya, awunughe kutu, “Yenje uwa bellin umong ubelli ile imone.” ");
INSERT INTO amo_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Ayicila among asoja aba aworo, “Sen asoja akalt aba iturun nani udu u'Siseriya, se anan ghanju nibark akut kuzor umunuku, unin kuru use anit akalt aba anan tiyop.” ");
INSERT INTO amo_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Iba fitu nanya nikoro itat nin kitik. ata nani ipizuru kibarak kanga na Bulus ma ghanu ku, inin do ninghe kitin Felix ugumna mang. ");
INSERT INTO amo_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Anin su iyerte nafo nenge: ");
INSERT INTO amo_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Lisiya udu kitin gumna udya Felix, indin lisufi. ");
INSERT INTO amo_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","A Yahudawa wa kifo unit ulele inani din cinu umolughe, in mini na lanza ame kunan Rumawari, in mini wadak nin nasoja in bologhe nacara mine. ");
INSERT INTO amo_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","In wa di ninsu inyinin inyaghari nta idin vurzughe uliiru, umini wa do ninghe nanya kudaru mine. ");
INSERT INTO amo_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Inna lanza au idin vurzughe in woru adin nanzu uduka mine, ama na ina seghe nin nimon imon na ibatin imolughe sa itighe licin ba. ");
INSERT INTO amo_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","inmile na lanza nworu among na kye atimine kitenen nite, in mile tunna toghe kitife, arika na idin vurzughe tutung in belle nani ida kitife nin liru mine. Uso ucine.” ");
INSERT INTO amo_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Asoje su kata nin duka ule na inanani: Iyauna Bulus ku idamun kitin Antipatiris. ");
INSERT INTO amo_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Ukurtung kuye, ngbardang nasoje suna anan nibarke nya ninghe, inung tutung kpila kika na inuzu ku. ");
INSERT INTO amo_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Na anan nibarake duru u'Siseriya, inakpa iyerte nacaran gumne umunu Bulus ku vat kitime. ");
INSERT INTO amo_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Na u'Gumne belle iyerte ine, atirino Bulus nanuzu kusa komeri; na ayinno Bulus nanuzun Sisiliyari, ");
INSERT INTO amo_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","aworo, “In ma lanzu fi vat asa anan vursufe nda kikane.” Anin ta iceghe kudaru Hirudus. ");
INSERT INTO amo_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Na ayiri atat in kata, Ananiyas udya na Priest, among akune nin, nin mong una yirun liru lissame Teritullus, nya udu kite. Ale anite da nin vurun liru litin Bulus. ");
INSERT INTO amo_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Na Bulus in yissina in bun gumne, Teritullus tunna aghanan vurzughe in liru aworo ugumne, “Bara fe tidi nin lissosin limang; tutung ukpiluzung in bunfe in danin nimon icene in nmyen bit; ");
INSERT INTO amo_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","nani nin godo udya tikpana vat nin nimon ilenge na usu, Felix uniti udindya. ");
INSERT INTO amo_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Bara na ayedi in yissafi kang ba, indin potufi acara, lanzai baat nin kunene. ");
INSERT INTO amo_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Bara tikpaghe nin kulapin tizu na Yahudawa vat nanya nyii inari uduka. Amere udya nanan dortu kunan Nazeret. ");
INSERT INTO amo_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Amani mala uti kutii inlira kudyawe facak; unare tinani kpaghe. ");
INSERT INTO amo_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Amma ugo likume Lisiyas wa dak, a da kpalkinghe nin likara na cara bite. ");
INSERT INTO amo_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Asa utiro Bulusku kitenen tipinpin tone, fewang manin yinnu imon irika na tidin bellu litime.” ");
INSERT INTO amo_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","A Yahudawe ligowe vat joro Bulus iworo, uliru ulele kidegenghari. ");
INSERT INTO amo_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Ama na ugumne woro Bulus ku alirin, Bulus kawa, “Inyinno nwo fedi unan mawucuwucu nmyen mone inworsu, bara nani nin kibinayi kibo inma bell uliru litining. ");
INSERT INTO amo_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Use uyinnu in woro na isa kata ayiri likure nin naba ba nin duning u'Urushalima indi su usujada; ");
INSERT INTO amo_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","na inung wase mengku nanya kutii in lira kudywe, na meng wasu mayardang nin mong mine ba, tutung na meng na tulu ligozin nanit ba, na inansu nani kutii in lira kudywe ba, a na inna su nani nanya kagbri ba; ");
INSERT INTO amo_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","tutung na inung wasa durofi ulire na idin vuszi mung ba nene. ");
INSERT INTO amo_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ama meng yinna nbunfe nworu, kitene libauwe na inung din yiccu umon ubi, in loli libau lirumere ndin su Kutelle nacif ning katwa. Meng di lau nanya vat nimon ile na idin duka nin nana liru nin nuu Kutelle. ");
INSERT INTO amo_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Meng dinin yinnu urumere kiti Kutelle, nafo na ale anite din caa ndakin fituzu nanan kul, nan vat nanit alau nin nanan dinong; ");
INSERT INTO amo_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","tutung nanya nile imon, ndi katwa nwo in yitta nin kibinayin sali nalapi nbun Kutelle nin nanit nanyan vat nimon. ");
INSERT INTO amo_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Nene kimalin katu nakus gbardan inna dak nin bunnu udya a ufillu nikubu bara anit ning. ");
INSERT INTO amo_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Na nwa din sunani, among a Yahudawa in Asiya wasei nanya lidun kusu litining nanya kutii inlire, na nwa di nin ligozin sa ufiu nayi ba. ");
INSERT INTO amo_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Ale anite na idin bunfe, na ibellin imon irika na idumun kibinayi ninmi, adi idimun nimonimon. ");
INSERT INTO amo_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Sa na anit alele bellin utanu ule na inasei mun kubi ko nq nwq yissin kudaru na Yahudawe; ");
INSERT INTO amo_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","andi na macas ile imon irume na nwa ghatin liwui nbelle kube na nwa yissin nbun mine, 'Ubelen fitu nanan kularita udi mawucuwucu kitimone.'” ");
INSERT INTO amo_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Iwa bellu Felix ku gegeme kitene libauwe, bara nani ata a Yahudawe so ncaa. Aworo, “Vat kubi ko na Lasiya udya nasoje da unuzun Urushalima imanin wusu uliru mine.” ");
INSERT INTO amo_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Anin woro kusoje asu ucaa in Bulus, tutung na awayita gangang ba, yenje awa nazu adondon me nin bunghe sa uda lissughe. ");
INSERT INTO amo_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Na ayiri baat in kata, Felix kpila nin Durisilla uwani me, kunan Jewess, anin to iyiccila Bulus ku, anin lanza kitime ubelle yinnu sa uyenu kitene Kristi Yesu. ");
INSERT INTO amo_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ama na Bulus lira ninghe kitene lissosin lilau, ukifu litin, nin dakin shara, fiu kpa Felix ku; anin kawa, “Can nene, asa nse kubi tutung inma yicculu fi.” ");
INSERT INTO amo_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Kubi kurum kone, awadin su Bulus ma ninghe ikurfu, unare asa to idak ninghe anin lira ninghe. ");
INSERT INTO amo_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ama na akusu aban kata, posiyus Fistus so ugumna kimal in Felix, Felix wadi ninsu ase useru kitin na Yahudawa, asuna Bulus ku alii ubun nanya tursu. ");
INSERT INTO amo_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Nene, Festus pira kipin tigo me, na ayiri atat nkata, anye udu Ukaisariya nin Urushelima. ");
INSERT INTO amo_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Ugo napirist nin na didia na Yahudawa su tizogo kitene Bulus nin Festus, isu uliru nin likara kitin Festus, isu ulinu nin likara kitin Festus. ");
INSERT INTO amo_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Itirino Festus ku ati ayi asheu nin bulus, nworo ayicila ghe udu Urushelimma inan mologhe libau we. ");
INSERT INTO amo_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Ama Festus kauwa nani Bulus kucin nari nanya Kaisariya, ame liti me ba kpinlu kikane. ");
INSERT INTO amo_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","“Bara nani, alenge na iwasa isu,” aworo, “Iba duu nanghirik, asa na imon nnana, iba kifu ghe nin kulapi.” ");
INSERT INTO amo_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Na aso ayiri kulir sa likure, annya udu Ukaisariya, nin liyiri linbe aso kutet nwucu kidegen, ata idanin Bulus kiti me. ");
INSERT INTO amo_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Na ada duru, a Yahudawa unuzu Urushelima da yisina kupo me, ibelle kinu kanga na kidegen duku ba. ");
INSERT INTO amo_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Bulus kusu liti me aworo, “Na kitene lisa na Yahudawa ba, a na kitene kutyi nlirag ba, ana kitene ugo Kaisar ba, anin nsu utanua.” ");
INSERT INTO amo_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ame Festus dinin su ase uyinnu na Yahudawa, anin kauwa Bulus ku aworo, “Udinin su udoo Urushelima meng di wuso fi kidegen, kitene nile imone kikane?” ");
INSERT INTO amo_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Bulus woro, “Meng yisin nbun kutet nwucu kidegen kaisar, kika na iba wussi kidegen. Na nna su Ayahudawa kulapi ba, nafo nafe yiru. ");
INSERT INTO amo_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ko nin nwonu nna taan, nin woro andi nnasu imomon ile na ibatina ukul, na nnari nkuu ba, Bara nani andi na uvuruzu mine na imonari ba, na umong wa nakpai kiti mine ba. In yicila kiti Kaisar.” ");
INSERT INTO amo_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Kubi na Festus nlira nan na didia a kauwa, “Uyicila kitene kaisar; uba duu kitin kaisar.” ");
INSERT INTO amo_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Nene na among ayiri nkata, ame uga Agaripa nin Banis da duru nanya Nkaisariya, isu lizzi kiti Festus. ");
INSERT INTO amo_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Kubi na awadi kikane ayiri gbardang Festus durso uliru Bulus kiti ngowe, a woro, “ Felix na suun umong kikane nafo unan licin. ");
INSERT INTO amo_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Kubi na nwanwandi nanyan Urushalima ago na Priest nin nakukune na Yahudawa da nin nliru kitene nnit une kiti nigh itiri ni nmolu ghe. ");
INSERT INTO amo_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Kiti nlel nkauwa nworu na alada nin na Romawa, inii unit nafo unit ulau, nin nani lenge na avuro ghe, bara anan kusu liti me. ");
INSERT INTO amo_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Bara nani, kubi na ida ligowe, na nwa cicah ba, nin nkuiye nso kutet nwucu kidgen, ntaa idaa nin nite nanye. ");
INSERT INTO amo_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Kubi na ale na vuroge nfita, men yene nafo vat nile imon na ivuro ghe mun, di nin likara ba. ");
INSERT INTO amo_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Nin nani, idinin nimomon ugang kitene nadini mine, kitene nimong Yesu ulenge na ann kuu, ulenge na Bulus dinsu a dinin lai. ");
INSERT INTO amo_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Na meng nyinno iyizari nbasu uleli uliru ba, men bellinghe, andi aba du Urushalima, idi wuso ghe kidegene kitene nile imone. ");
INSERT INTO amo_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","bara kubi na iwa yicila Bulus ku idi ceo ghe kiti licin, bara ubellu ngo udia, men belle i ceo ghe, udu kubi kongo na mba tuu ninghe kiti Kaisar.” ");
INSERT INTO amo_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agarippa wa liru nin Festus, “ Meng wang ba yitu nin su nlanza unit une.” Nin nkui” Festus woro “Una lanza ghe.” ");
INSERT INTO amo_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Udu liyirin ndofine, Agarippa nin Banis ida nin ngonon kang, ida pira nanya kuyiye nin nasoja, nan nanit adidia kagbire, kubi na Festus nlirina ida nin Bulus kiti mine. ");
INSERT INTO amo_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festus woro, “Ugo Agarippa, nin vat nanit alenge na idi kikane nanghinik, iyene unit ule, vat ngardang Nayahudiyawa na da seei kikane tutun, inani na lirin nin liwui, na iwa suun unit ule nin lai ba. ");
INSERT INTO amo_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Meng na lanza na asu imon ile na ibatina ukul ba, ama bara na ana yicila kiti ngo, nmini di nworu ntuu ghe. ");
INSERT INTO amo_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Bara ndimun nimon ident ile na nba nyertinu ugo ba, unnere ntaa, nmini ndaa ninghe kiti mine, fe Ugo Agarippa, bara nnanse imomon gbardang na nba nyertinu kitene nshara ule. ");
INSERT INTO amo_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Bara uba so nafo usalin kpilizu, kiti nigh, ntuu nin nan licin, sa ubelle nimon ile na idin vuruzughe mun.” ");
INSERT INTO amo_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agrippa woro in Bulu ku, “Uwasa usu uliru nin litife” Bulus nakpa ucara me asu uliru nkussu litime. ");
INSERT INTO amo_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“In yira liti ning unan ayi abo, ugo Agrippa, nsu uliru nighe nbunfe kimone nbelleng nimon ile ena a Yhudawa na belin liti ning; ");
INSERT INTO amo_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","bara fe unan yiraari kitine vat ntanda na Yahudawa nin tiru mine. Ndin tiru fi nworo ulanzai nin nayi ashau. ");
INSERT INTO amo_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Kidegere, a Yahudawa vat yiru imusun lissosin longo na nna su a in yita kwanyana nmin nighe nin Ushalima. ");
INSERT INTO amo_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Innung yiru ucizunighe tutung ucaun inin yinin nworu meng ku farisawari, alenge na idin kpilizu imon hem ba. ");
INSERT INTO amo_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Nene in yissing kikane bara ndin piziru nciu nliru ulenge na kutelle wa ni acifi bite. ");
INSERT INTO amo_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Bara nanere akura nnonon Israila na su Kutelle katwa kitik nin lirin nan nya kidegen, arik ani nceo ayi ti duru kite bara ule uciu nayere a Yahudawa nvuroyi, Ugo! ");
INSERT INTO amo_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Iyaghari nta idin yenju uma konu Kutelle fya anan kul? ");
INSERT INTO amo_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Nkon kubi asa nkpilza nsu imon gambalang gbardang kitene lissan Yesu Nnazareth. ");
INSERT INTO amo_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Nna su in Urshalima; nwa yaccu anan katwa kacine kilari licin gbardang, nwa seru likara nsu nani kiti ndya na priest iwa molusu nani, asa mere yinna isu nani. ");
INSERT INTO amo_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Ina tizu nani ineo kang nan nya nilari nlira mine nkuru ntiza nani izoguzu Kutelle. Nwa yita nin tinana nayi nin ghinu kang ndortu nani uduzu mmin das. ");
INSERT INTO amo_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Na nwa din su nani, Nwa do Udamaska nin yinnu a likara ngo na priest; ");
INSERT INTO amo_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","libowe ucin due, nin wui gberere, Ugo, in yene imon nkanan unuzu kitene Kutelle mida mala kiti bite vat umunu alenge na iwa din cin ligowe nan mi. ");
INSERT INTO amo_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","na vat bite ndeo kutyen, nlanza liwui nin ti Ibrananci din liru nin mi, 'Shawulu, Shawulu, iyaghari nta udin tizui nneo? Uwa konui men nari.' ");
INSERT INTO amo_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Ntunna nworo, fe ghari, Cikilaria? Cikilare kawa, ' men Yesu ule na udin funu ghe. ");
INSERT INTO amo_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Nene fita uyissin nin nabunu fe; bara ile imonere ndurso liti nighe kitife, nfere fi uso kucin a unan wazi nbell nimon ile na uyiru inin nin nen nin nimon ile na Mma dursu fi iwa dandaun; ");
INSERT INTO amo_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","mma tucu fi na cara nanite nin na wurme alenge na mma tuu fi ucindu kitimine; ");
INSERT INTO amo_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","udi pun iyizi mine uti nani ikpilin isun adu nsirti mine udak nan nya nkanang, nan nya likara nshaitan udak likara Kutelle, inan se ukussu nalapi kiti Kutelle, nin gadu ulenge na ina ni ceo nani nin liti nighe nan nya yinnu sa uyenu.' ");
INSERT INTO amo_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Bara nani, Ugo Agrippa, Na nna dira uyinnu nin anabci Kutelle ba; ");
INSERT INTO amo_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","amma, kiti na lenge na idin Damaska tukuna, nin na nan Urshalima, nin na lenge vat na idi nmin in Yhudiya, a ining awurmi, ndi wazi i sun alapi mine ikpilin kiti Kutelle, isu imon ile na ima dak nin sunu nalapi. ");
INSERT INTO amo_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Bara ile imonere a Yahudawa na kifo nannya kilari nlira inani pizira imolui. ");
INSERT INTO amo_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Kutelle koni na buni udak nene, in yissin nbelin nbun na talaka nin nanit adidya na umong ubeleng ugan ba se ulenge na anan liru nin nuu Kutelle nin Musa na belin uma se; ");
INSERT INTO amo_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","nworu Kristi ma niu gbas, tutng ama yitu unan burnun fitu nan nya nissek anin kuru a durso nkanang kiti na Yahudawa nin na wurmi. ");
INSERT INTO amo_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Na Bulus nmala ukusu litime, Fastos woro nin liwui gberere, “ Bulus uta ilaza; uyiru udya fe nta fi ilaza.” ");
INSERT INTO amo_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Amma Bulus woro ghe, “Na ndi nin nilaza ba Fastos unit udya; amma nin nayi akone ndin su liru kidegen nin toltenu liti. ");
INSERT INTO amo_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Bara Ugo yiru ubelleng nilenge imone, bara nani, ndi woas nsu nin ghe, bara meng yiru na imonmong nyeshin kiti me ba, bara na ina su ilenge imone likot ba. ");
INSERT INTO amo_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Uyinna nin na annabawe, Ugo Agrippa? Ina yiru uyinna nin ghinu.” ");
INSERT INTO amo_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agrippa woro Bulus ku “ nan nya kabiri bar uma kpiliu nso unan dortu Kutelle?” ");
INSERT INTO amo_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Bulus woro, “Ndi inlira kiti kutelle, sa nin kabiri bat sa nin kubiri gbardang, na fe usanfi ba, amma umunu alenge na idin lanzui kiti mone, iso nafo mewe, amma na nin ninyang kilari licin ba. ");
INSERT INTO amo_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Ugowe tunna a fita ayissina, a udya mine nin Barniki wang fita umuni alenge na iwa sossin ligowe nan ghinu; ");
INSERT INTO amo_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","na isuna kudarua, itunna nliru nin nanit mine idin su, “Na unit ulele nati nkon kulapi kongo na ku batina ukul so utecu ba.” ");
INSERT INTO amo_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agrippa woro Festus ku, “Iwa sunu unit ulele nda fo na afo acara kitin Kaisar ba.” ");
INSERT INTO amo_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Na iwa yenin au ti ma nyeu udu Italiya, I nakpa Bulus ku nin namon anang licin nacaran kon kusoja unang kisan Julius, na awadin Agusta. ");
INSERT INTO amo_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Ti piran Zurgin myein unuzun Andramatiya, ule na uwadin cin kusari kurawan Asiya. Tidoo tidi yene, Aristarkus unuzun Tassalonika nanyan Makidoniya nyaa nan narik. ");
INSERT INTO amo_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Nin kurtunun nkuiye ti pira nanya kagberin Sidon, kikaa na Julius wa yiru Bulus ku adoo ninghe kiti na doone na iwa yenjeghe nsen. ");
INSERT INTO amo_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Unuzu kikane ti doo kurawa kudyawe, ti cina nanyan zirgin myeine udu lidan kulin Kubrus na uma kese ufune, bara na ufune wa wantin nari ucin. ");
INSERT INTO amo_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Na ti wa din nanyan myeine kupoon Kilikiya nin Bamfiliya, ti da Umira, kagbirin Lisiya. ");
INSERT INTO amo_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Kikane ku soje se uzirgi unuzun Iskandariya na uwa cinu udu Italiya. A taa nari nanye. ");
INSERT INTO amo_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Na a wa cinu seng ayiri gbardan unin duru nin nijasi kang kupoo Knidus, Na ufunwe nsuna nari ba, bara nani ti cina kusari kucinen Krete, kupoon Salmone. ");
INSERT INTO amo_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Ti cina ngau kurawa kudgawe nin nijasi se na ti wa dak nkankiti na idin yicu Fiya Havens ule na udi kupoo kagberin Lasiya. ");
INSERT INTO amo_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Ti malu nanzu kubi kang, kubin kifu tinuu na Yahudawa tutung malu kafu, unin so nari nin nijasi ti ti ubum nin cine. Bara nani Bulus wunno nani atuff, ");
INSERT INTO amo_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","anin waro, “Anit, inyene ucin ulele na ti masu uma dak nari nin langzu kull nin duru nimoon gbardang na ma kuturan zerge cas ba, ti lai bite ulang.” ");
INSERT INTO amo_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Bara nani ku soje ceu kibinai me kitin cikilare nin nanang zirge ashawa imoon ile na Bulus din bellu. ");
INSERT INTO amo_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Bara na ufune wa caun ti so nanye ba, ngbardang nanang cine woro ti cinu kikane. Andi ti wa sa tiduru kagbirin Foniks, liwitine katanari kikane, Ufoniks wadi nin nadanga kupoo ngau kurawa nanyan Krete uwadin yenjun kitene kusarin nucun wui nin kusarin disun wui. ");
INSERT INTO amo_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Na ufunu kusarin disun nwuiye ncizina ukuu batbat, anan kuun zirge yenje nafo idin nin vat nimon ile na I dinin su we. Bara nani I kala inyeneghe inin cine kusarin Krete, kupoon ngau we. ");
INSERT INTO amo_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Na I dandauna ba ufunu udya, naidin sun nnin ufunu kusarin nu cun nwui cizina ufoo nari. ");
INSERT INTO amo_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Na uzirge nkpiliya kidowo tutung na uwasa uyenje kusarin fune ba, ti cino unin nanye udin cinu nin narik. ");
INSERT INTO amo_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Ti cun ligowe kusari lidan nanya kuli libene lo na idin yicu ukauda, nin neu udya ti wa se ka zirge kabenen nlai. ");
INSERT INTO amo_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Na I nyangtina ti shote itece uzirgi udyawe mun. I wa lanza fiu au to ma cinu ketene nicicin Nsirtiya, i cino ushote ufunue nyaa nin ghinu. ");
INSERT INTO amo_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Ti wa dira kang nin fune ukurtunung nkui ye anang katwa nzirge nutuzuno imoone ifilzino nanya myeine. ");
INSERT INTO amo_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Liri lin tate anan latwa nzirge nin nacara mene filizino imoone. ");
INSERT INTO amo_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Nanya nayiri gbardang na uwui ming niyini nnuzu ba, ufunu udindya nin din kuu nari, vat in ceu nibinai bite ti ma ulai ula nuzu. ");
INSERT INTO amo_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Na iwa cinu piit sa imonli, Bulus nin yisina kiitik nanan katwa nzirge a woro, “Anit ale nkuru fo ini lanzai, na tiwa nuzu nKrete ba, bara ule ulanzun nkule nin diru nimoon ilele. ");
INSERT INTO amo_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Nene indin ti minu likara nibinai na iwa ti yototo ba, bara na ima diru umong nanya mine ba, ma udirum zirgere. ");
INSERT INTO amo_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Bara nin kiitik unan kadura Kutelle ule na meng di ligowe ninghe, ule na indin tumuzunghe tutung - unan kadura me yisin likot nighe ");
INSERT INTO amo_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","anin woro, 'Na uwa lanza fiu ba, Bulus. Uma yisinu nbun nKaisar, unin yene, Kutelle nanyan nkunekune me ana nife vat nale na una cinu nanghinu.' ");
INSERT INTO amo_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Bara nani, anit, tan kibinai likara bara na inyinna nin Kutelle, au ima so nafo na iwa bellin. ");
INSERT INTO amo_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Bara nani tima nyanju kitune nadan nanya kurawa kudya.” ");
INSERT INTO amo_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Na kiitik kin likune nin kin nas ndaa, na tiwa din cin libau lole au nin nanya kurawa kudyan Adriyatik nin kutek kiitik anan katwan zirge din yenju idaa kupoon ngou kurawe. ");
INSERT INTO amo_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Idumna nmyeine ise abunu likure nin naba, na I dandauna ba ikuru idumna ise abunu likure nin nitaun. ");
INSERT INTO amo_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","I lanza fiu au ima diu kitene natala ituu ucinko unas ligang nzirge inin son ncaa uwui nuzu. ");
INSERT INTO amo_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Anan katwa nzirge wa din piziru ndina nworu I filin unin icum, I wadi imalu tuu uzirgi ubene nanya kurawe, idin dursuzu nafo ima tuu umong ucinko nbune. ");
INSERT INTO amo_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Bulus woro indya na soje nin nasoje, “Andi na unit alele nso nanyan nzirge ba nati ma ti ulai ba.” ");
INSERT INTO amo_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","A soje nin werzine tii nzirge isuna unin unyaa. ");
INSERT INTO amo_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Na nkanang ncizina udasu, Bulus risa nani ili imonli, a woro, “Kitimone liri lin likure nin na nasari ulele na ileu imonli ba. ");
INSERT INTO amo_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Bara nani indin putu minu nacara ipiziru imonli ili, bara inan se ulai; na liti lirum tete mene ma wulu ba.” ");
INSERT INTO amo_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Na abenle nani, ayira uburodi ataa nlira ku niyizi mine vat; anin puco unin acizina ule. ");
INSERT INTO amo_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Inung nin se likara nibinai, inung ulang cizina ule. ");
INSERT INTO amo_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Ti wa di akolt aba nin nakut kuzurr nin kutocin nanyan nzirge. ");
INSERT INTO amo_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Na ileu ibatina nani, I taa uzirge fau na iwa kalza ualkame I tusu nanya kurawe. ");
INSERT INTO amo_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Na kitin shant, na iyino ugauwe tutung ba. Iyene nlon likoot nin ficicin nanya kurawe icizina ukpilzu sa idi ceu uzirge kikane. ");
INSERT INTO amo_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Bara nani ibunku tii nzerge isuna unin nanya kurawe. I kuru ibunku tii nbune isuna ufunu din koo unin bara nani inyaa udu ficicine. ");
INSERT INTO amo_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ida kan kiti na inuu myeine nzuruku uzirge nin cuun udu kutiin. Lican zirge yisina kikane na uwa sa ucina tutung ba bara nani uzirge cizina uputuzu nara tinana nayin kabarkin myeine. ");
INSERT INTO amo_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Ukpilzu na soje wadi imolso acine vat bara umong mine wa su iyiu nanyan myeine acoo. ");
INSERT INTO amo_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Udya mine wadi nin si a tucu Bulus ku, bara nani ayira ukpilzu mine; anin woro ule na awasa akafina kurawe adeu nanyan myeine adi yisin kutiine. ");
INSERT INTO amo_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Kagisin na nite nin dofino, among kitene ku ca, among kitene nimon nanyan nzirge. Nlo libauwe tina se vat bite kaffin kurawe acine. ");
INSERT INTO amo_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Na idaa nin ghirik cancam, tiyinno idin yicu usibire Umalta. ");
INSERT INTO amo_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Anan kipine nama iwa seru nari nin nilip cas ba, ama iwa susuari ula isere nari vat, bara uwuru nin tituwui nat kubi. ");
INSERT INTO amo_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Na Bulus npitirino aca ataa ulaku, bara npuu nle, kubuni nuzu ku kantilaghe ucara. ");
INSERT INTO amo_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Na anan kipine nyene finawa kushoe ncaran Bulus, iworo atimme, “Unit ulele fa unan molsu na nit ari na a surto na nya kuli, na ne na kidegene nsuunghe a taa ulai ba.” ");
INSERT INTO amo_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ama a zalina finawe na nya nla na imon nseeghe ba. ");
INSERT INTO amo_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Iwa din caa iyene ukonu kidowo kikang nkifoghe nworu itene udiu me libi, ama na I dandauna na iyene imon nseghe ba, ikpilya nibinei mine iworo ame unan ncillari. ");
INSERT INTO amo_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Nane ku popo kitene anen waa duku an Go lidan kuli, nin lisa Bublius. A sereari anin leo nin ghirik ayiri atat. ");
INSERT INTO amo_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Uda soo na upiu nin nyrzunu nkifo ucifin Bublius, na Bulus ndoo kitine, ataa ghe nlira, atarda ghe acara anin shino ninghe. ");
INSERT INTO amo_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Nwufu ni le imoonne, ngisin nanit lidan kuli alenge na iwa di a cine ba daa kitime, a shino nin ghinu. ");
INSERT INTO amo_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Anite tutung taa nari gongong nin likara. Kubi koo natiwa din pitiru kutura ti nyaa, inaa nari ile imon na dinin suu we. ");
INSERT INTO amo_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Na tipui titat nkata, tipiran nzirgin myen n Iskandariya kubi tituwui lidan kuli, na ana koo nzirge waa di ibari. ");
INSERT INTO amo_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Na ti tolon na nya kipin Sirakus, ti soo kikane ayiri atot. ");
INSERT INTO amo_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Ti nuzu kikane ti doo kipin kipin Regiyom. Na lilirum kata, ufunu kadas fita, na nya na yiri aba, ti doo nya kipin Putiyoli. ");
INSERT INTO amo_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Kikane ti see long linuwana iyicilari ti soo nanghinu udu ayiri kuzoor. Na nya na nere tiwa dak Uroma. ");
INSERT INTO amo_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Unuzu kikane linuwa na ilanza ubeleng bite, daa piit ida se nari nkasaun Apiyos nin na Danga atat. Na Balus nyene linuwana, a godo Kutelle anin yira akara kibinei. ");
INSERT INTO amo_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Kubi koo nati pira Uroma, icino Bulus se ku a soo nin litime nin ku soje na awa din yenjughe. ");
INSERT INTO amo_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Na ayiri atat nkata Bulus yicila anit nalimine ale na iwadi anan buun na nya na Yahudawa. Na ida ligowe, aworo ani, “Nuwana, ko nane na taa imon ile na inanza atanda nan kaa bite ba, iwa nakpai nafo kucin n Urshalima nacara na nan Uroma. ");
INSERT INTO amo_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Na itirini, usuu minere wa di iciini, bara na iwa se imon woru imolui ba. ");
INSERT INTO amo_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ama na Ayahudawa lirina kitene ni le imon na idinin suu weba, utaayi nfo acara kitin Kaisar, ko nane ne uwa soo fo ndin liru unanzang kitinen min nin. ");
INSERT INTO amo_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Bara ufo nacara ni, nwaa tirin nyene fi nnin kuru liru nin fi. Bara uyinnu n Israila ntaa inani na teri nin ninyan.” ");
INSERT INTO amo_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Inun woro ghe, “Na tina seru mayerte nnuzu Judiya nbelen fe sa iworo nkan gbana bite na da woro sa ana belin imong imon nanzan litife ba. ");
INSERT INTO amo_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Ama ti dinin suu tilanza kitife inyanghari ukpliliu fe kiti na lele, bara na arik yiru uliru ulele di litife koweari. ");
INSERT INTO amo_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Na ice ghe lisi lirum, anit gbardang daa kiti lisosin me A belin nani ulirue, anin kuru a belle nani ubelen kilari Kutelle. A tenizine nworu ase nibinei mine nbe len Yesu, nnuzu ndukan Musa nin una nin liru nin nuu Kutelle, ucizinu kuidinding udu kuleleng. ");
INSERT INTO amo_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Among mine wa yinin nin nile imon na abelle nani, na among yinna ba. ");
INSERT INTO amo_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Na iyinna nin natimine ba, inyaa kubi koo na Bulus se mbelle ligbulang lirum, “Uruhu Ulau wa liru gegeme na nya unan liru nin nuu Kutelle udu an kaa mine. ");
INSERT INTO amo_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Aworo, 'Can kiti nanit alele inin belin iworo, “Na nyan lanzu ima lanzu, ama na iba yinnu ba; na nyan yenju ima yenju, ama na iba yenu ba. ");
INSERT INTO amo_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Kibinei na nit alele ntaa alalang. Atuf mine nlanza nin timang ghe ba, itursu iyizi mine, bara iwa yene nin niyizi mine, inin lanza nin natuf mine, inintutung yinin nin nibinei mine, inin kpilin, meng baa nin shiinu nin ghinu.”' ");
INSERT INTO amo_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Bara nani, usoo uyinin ina tuu nin tuce nnuzu Kutelle cin di Awurmi, tuting iba dinu atuf.” ");
INSERT INTO amo_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Na ilanza ile imone, Ayahuduwa nyaa, na nyan salin nyinnu na nya mine. ");
INSERT INTO amo_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Na nya nakus aba cip, Bulus soo na nya kilari me na awa kifo adin biizu, anin seru ale vat na idaa kitime. ");
INSERT INTO amo_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Awa din sun waazi kilari Kutelle anin dursuzo ile imon nbelen Cikilari Yesu Kristi sa fiu. Na umong wantinghe ba. ");
INSERT INTO amo_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Paul kuchin Yisa Kirsti, na ina yichilagne gono kadura, inin yisagne bara katuwa in nliru nlai Kutelle. ");
INSERT INTO amo_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Urika na awa tinari utai nan nya nliru ulau kiti nanan kadurame. ");
INSERT INTO amo_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","kitenen saune, na iwa marugne kuwunun Dauda, nan nya kidowo. ");
INSERT INTO amo_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Iwa woro ameh gono kutelleri nnuzun fip mi lau, ninfitume nan nya kisek, Yisa Chikilaribit Kirsti. ");
INSERT INTO amo_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Bari ameh, tinaseru ubollu Kutelle nwo tiso nono kadura meh, nin dortun nliru meh, nan nya inyinnu sa uyenu, vat inyi, bara lisameh. ");
INSERT INTO amo_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Nan nya nipinpin inyee, anung wang ina yichala minu nan nya Yisa Kirsti. ");
INSERT INTO amo_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Vat mine na indin Romawa, anan kinayi Kutelle, tutun nin nale na iwayichila ani iso anit alau; ubollu Kutelle kitimine, nin lisosin liman nnuzu kiti Kutelle nin Chikilari bit Yisa Kirsti. ");
INSERT INTO amo_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Inchizina nin godoh Kutelle bari Yisa Kirsti kitemine vat, bara ubellun inyinnun sa uyenu mine di vat inyi. ");
INSERT INTO amo_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Kutelleri iyizi in mbani, ulena indigne katuwa nan nya nfip micine nin, nan nya nliru nlai ngonome, na ndin bellu ubelen minegne kolomeliri. ");
INSERT INTO amo_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ko inshi nan nya nliranin, indin tiru kolomelibau ndunimalin inse unuzu gegeme nene, nan nyan inyinnun Kutelle ndak kitimine. ");
INSERT INTO amo_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Aye di nwo inyene munu, nnan filin munu ufillun nfip michine, ntimunu iti agang, ");
INSERT INTO amo_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","nnan naminu likara na kolon nan nya mine, nan nya inyinnu sa uyenu kogha mine, nin unag. ");
INSERT INTO amo_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Nene na ayedi iso sa uyinnun wo nworsu nuwana, aye din ndak kitimine, inale asa inazai mu, nenere bara nnanse iburi nan nya mine nafo na iwadi nan nya na wurmi. vat ");
INSERT INTO amo_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Meng unan rewari, kiti Nawurmi nin nanan nmin ndas, vat anit alalan nin najiji. ");
INSERT INTO amo_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Bara meng, inkyle litinin nbelluminu nlirun nlai anug na idin Rome. ");
INSERT INTO amo_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Yenen, na meng din lanzu inchin nliru nlaiba, bara likara Kutelleri udun ntuchun kogha na ayinna sa uyenu, inchizinu nin na Yahudawa udu nawurmi. ");
INSERT INTO amo_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","In nan nyere udiru kulapi Kutelle wa pun libau inyinnu sa uyenu udu uyinnun sa uyenu, nafo na idin nya niyerte, “Anan diru kulapi mati ulai libau inyinnu sa uyenu.” ");
INSERT INTO amo_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Tinanayi Kutelle wa pun kidowo nnuzu kitenekani, kiti nanan sali feu Kutelle nin na nit anan kulapi, arikana bara kulapi ina cheu kidegen. ");
INSERT INTO amo_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","bara ile imon na idi kiti Kutelle idi kana in yenju mine, Kutelleri na pun nani nkanan inyenjee. ");
INSERT INTO amo_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Imon irikana idi yenjeba kitime, idi kanan uworsu kubi makeke inyi, na uyine wa dak kiti nimon irika na ana ke, wati nan nya likara me sa sa ligan nin yenju nimon makekeme, inan senani sa udiru nimon bellu. ");
INSERT INTO amo_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Bari dai iyiru ubelle Kutelle, na ina ghantigne nafo Kutelleba, na ina nigne ugodoba, inin ta alalan nan nya kpiluzu mine, nibinayin mine siro. ");
INSERT INTO amo_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Npilu natimine au idi jiji inin ta alala. ");
INSERT INTO amo_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Iwasu kusere ghantinu Kutelle sa unanu, nin yenju nimon na nit asirne in nanu, ayin, inawan ntene nabunu ananas, nin nimon inwunu liburi. ");
INSERT INTO amo_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Bara nani Kutelle wa ni ani ndu ntok nibinayi nin dirun lau mine, bara nidowo mine se udirun ghantinu nan nya mine, ");
INSERT INTO amo_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","inun na inasu kusere kidegen Kutelle nin kinu, inayita achin makeke isuna unan kewe ule na adi ninmari sa ligan usonani. ");
INSERT INTO amo_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Baranani; Kutelle na nakpa ani ndu kiti nimon dirun ghantinu, nin sun lantizu mang mine, awani mine dinsuzu kusere nimon makeke Kutelle nin ninnimon makeke na nit asirne. ");
INSERT INTO amo_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Nanere wang, nalilime mine nchino katuwa Kutelle mine nin nawani, inanin din jujuzu atimine nin ntok nati, nalilime din suzu nin nalilime imon irika na iwansu nin nawani, awani wang in suzu nemon irika na iwasu nin nalilime inun ani din suze nin nawani, inun ani din sesu kusere nalapi mine chot libau nwulu mine. ");
INSERT INTO amo_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Nanita na inun yina nin Kutelle nan nyan nyinu mineba, Amile na sun nani nan nya nibinayi ni fang, isu imon irika na idi chaut ba. ");
INSERT INTO amo_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Vat mine nkulo nin dirun suzu nimon ichine, likara linanza, uchisunizi, ukpilizu unanzan, inani nin kulun nin liyarin, kimolo, ivira, karusuzo, uminu kibinayi kinannazan. ");
INSERT INTO amo_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","Idinin kubellum, unanzulisa, anan nari Kutelle, anan nnung, nin lanzu nin natimine, anan fofigiri, anan nutuzunu nimon inanzan, anan salin lanzu nliru ale na imachani. ");
INSERT INTO amo_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","Na idinin yiruba; na umon wasa ayina nin ghunuba, sa ulantizun mang ni mon ichine, sa nkune kune. ");
INSERT INTO amo_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Idinin yiru nile mon na Kutelle, inyinamun, au ale na idin suzu nile imon na Kutelle narimu chau iku, inale na idinsuzu nimonere chas ba, iyinna nin nale na idin suzai. ");
INSERT INTO amo_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Bara nani idimun nimon inbellu ba, anugne anit, anung anan wusu nliru, imon irika na iwuso kitenen nmon, asa imusuzu natimine. Anugne na idinsu katuwan nwusuze anug wang din su imone. ");
INSERT INTO amo_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Arik nani tiyiru uwusuzu Kutelle kidenere, asa deu kitene nale na idin suzu imon ine. ");
INSERT INTO amo_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Yene ilaimone, anung anit, ale na idin wusuzu among anan suzu nimon inanza anung din suze, ima chum ikata usuzu Kutelle? ");
INSERT INTO amo_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Sa anung din kpilizu imon ichine me chigilin, umolu kubi nin wusuzume, ayi asheume, na anuung yiru imon ichine me din wunu minu uchin dun deu nabunu meh ba? ");
INSERT INTO amo_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Nani tutun, bara gbasminere nin salin ndisu nabunu nibinayi mine, idin chisu atimine tinannayi Kutelle liri tinannayi, lirin puzunu nimon ichine mawusuzu Kutelle. ");
INSERT INTO amo_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Amma kurtunu kogha ku nin nilaimon na unite nbatamun katuwame: ");
INSERT INTO amo_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","inung ale na kitenen suzu nimon ichine sa ushizunu idin pizurun zazunu, ningogon, a upizuru nimon in salin nanuzu, ulai sa ligan. ");
INSERT INTO amo_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Ale tutun na idin pizuru liti, na inari udort kiden, ima di sa ulanzu feu Kutelle, natimine, tinanayi nin nayi ananza ma dak, ");
INSERT INTO amo_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","liguburi nin neu, ma yitu litin kogha na adin su imon inanzan, uchizunu nin kuyahudawa udu kiti kuwurmi. ");
INSERT INTO amo_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Harnani uzazunu, ughantinu, nin lisosi limang ma dak kitin kogha na adin su imon ichine, uchizunu nin Kuyahudawa nin du kiti Kuwurmi. ");
INSERT INTO amo_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Bari nani, Kutelle din feru umong nbun nmong ba, ");
INSERT INTO amo_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Vat narika na ina tizu alapi sa ushara, vat arika na idintizu nalapi kitenen nshara imasu ani uwusuzu nin shara. ");
INSERT INTO amo_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Lanzan, na anan lanzu nliru Kutelleri anan feu me ba, arikana idin dortun nsharawere ma nuzu nan nya tikanchi. ");
INSERT INTO amo_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Adi Awurmi ale na idumun nsharaba, idin dortu bari makeke Kutelle imon irika na usharawen nbele, inung, udirun sharai mine, usharawari natimine. ");
INSERT INTO amo_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Nan nya nani, idin dursu nita nirika na ni di nan nya niyerti nin shara nna nibinayi mine; nan nya nibinayin suzu nimon ichine nin ninanza ita iyizi nba nang ghinu, tutun ukpilizumine ma kesunani, sa unaza ani. ");
INSERT INTO amo_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","liri lirika na Kutelle masuzu mawusu wusu nyeshizunu na nit, nafo na idin nya lirun nlai Yisa Kirsti. ");
INSERT INTO amo_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Asa udin yichu litife Kuyahudawa, yerdine kidowon shara, su liburi libo kitene Kutelle. ");
INSERT INTO amo_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Yinno usumeh, ukuru umala imon irika na idi ngan gan ninninin, nafo na iwabelufi nan nya shara. ");
INSERT INTO amo_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","andi ureu figiri nwo fe wang unan wunu naduwari udu libau lichine, uso nkanan kiti na le na idin sirti, ");
INSERT INTO amo_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","unan kelu nale na idi alala, unan dursuzu nnono, tutun unin dimun nan nya shara uyenju inyiru nin kidegen. ");
INSERT INTO amo_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Asa fe din dursuzu among libauwe, udin dursuzu litife ba? Fena udin bellu among yenje iwasuzu likiri, fe din suzu likire? ");
INSERT INTO amo_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Fena uworo yenje iwasu ufunu, fe dinsun fune? Fena udin lanzu infachak inchil, fe din nwo nitin chille? ");
INSERT INTO amo_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Fena udinin na ayi abo nin shara Kutelle, fedin nanzu lisame kitene kugbas fe? ");
INSERT INTO amo_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Yene “ lisa Kutelle nnana nan nya Nawurmi bara fe,” nafo na idin nya niyerte. ");
INSERT INTO amo_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Bara ubo nono na minu ulinbun asa idin dortun shara, nani tutu adi idin nazu nshara Kutelle, ubomine nso nafo udirun nbo. ");
INSERT INTO amo_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Andi ameh unan nan dirun nbowe din dortu sharawe, na udirun bome so nso ubowa une ba? ");
INSERT INTO amo_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Na ameh urika na bara kumat me di sa ubo, andi a kulo udortu sharame, suminu mawusu wusu, arika na idi nan nya niyerte inliru Kutelle anan nbo nin nanzu sharaba? ");
INSERT INTO amo_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Bara na ame Kuyahudawari ba nan nya yenju ndas; tutun na ame nbowariba urika na udin nan nya kidowoba. ");
INSERT INTO amo_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Ameh Kuyahudawari urika na adi nya kibinayi, tutun ubo uchine unere nya kibinayi, nan nya nfip michine, na nya kidowoba. U zazuna nale anit din dasu kiti Kutelleri na anit asireba. ");
INSERT INTO amo_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Tutun iyari Ayahudawe na se? iyagnari tutun nmari nbowe? ");
INSERT INTO amo_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","imone di gwardan kokome kusari. inchizune, iwayini nin ghnu ipuno ani fiseri Kutelle. ");
INSERT INTO amo_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Andi among Ayahudawa di sa uyinu sa uyenu fa? Udirun nyinu mine mati uliru Kutelle yita imon filluah? ");
INSERT INTO amo_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Ko inyizi. Bara nani wang, na Kutelle yita unan kidegen, adi kogha di unan kinu. Naafo na idi nya niyerte, “ibayiru udi dert nan nya nagulang inlirufe, tutun uyisin gegeme uda in wusu wusu kidegen.” ");
INSERT INTO amo_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Andi udirun dortu nimon ichine bit ndurso imon ichine Kutelle, tima woru ongyang? Na Kutelle dinin dirun sunimon ichine ba, ameh urika na adin puzunu tinanayi, amereh? Indi su uliru nafo unit usirene. ");
INSERT INTO amo_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Na uwasonani. Bara nane, inyizari Kutelle, mawusu kidegen inye? ");
INSERT INTO amo_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Andi kidegen Kutelle nuzu nan nya kinuni nan nya zazunu meh, inyagharita idin wusuzue kidegen nafo unan kulapi? ");
INSERT INTO amo_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Iyang ma wantinu iworo, nafo ubellubit kinu, tiworo, tutun among na yinin tiworo “ Na ti su imon inan zan, bara imon ichine na dawa? Uwusu kidegen kitene mine chau. ");
INSERT INTO amo_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Iyaghari tutun? Tidinin nimon bellua? Ko imon irum. Bari arikin mal vuru Ayahudawa nin Nawurmi, nwo idin nan nya nalapi, ");
INSERT INTO amo_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Nafo na udin nan nya niyerte, na unan fiwu Kutelle dikuba, na warun dikuba. ");
INSERT INTO amo_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Na umondiku na adinin yinuba Na umonduku unan pizuru Kutelleba. ");
INSERT INTO amo_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Vat ina kpilin, vat inghnu so hem. Na umon duku na adin su nimon gegemeba kayi! Nawasame dukuba. ");
INSERT INTO amo_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Asholushok mine pun fang nafo nisek. Tilem so imon nrusuzu kiti. Timun niyii di nakpah tinumine. ");
INSERT INTO amo_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Tinumine kulun nin nizogo nin gbagbai ");
INSERT INTO amo_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Abunu mine din tizu mas mas ngutuzunun nmii. ");
INSERT INTO amo_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Umusuzu nin niu di libau mine. ");
INSERT INTO amo_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Na iyiru libau lisosin liman ba. ");
INSERT INTO amo_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Na ulanzu feu Kutelle di niyizi mineba.” ");
INSERT INTO amo_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Nene tiyiru, vat imerika na ushara belle, nale na idin nan nya shara, inan tursu tinu vat, tutun vat uyi yita nin kwanu Kutelle. ");
INSERT INTO amo_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Udinani bara na kidowo mase inchine libau katuwa niyizi sharaba. Bara nan nya sharawe uyinu kulapi da. ");
INSERT INTO amo_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Nene vat nin dirun sharawe ngegeme Kutelle puno kidowo, ushara nin nanan kadura Kutelle inso iyizi inba, ");
INSERT INTO amo_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","usonani, ngegeme katuwa Kutelle nan nya yinnu sa uyenu, nan nya Yisa Kirsti vat kiti nale na iyinna. Na maferu feru dukuba. ");
INSERT INTO amo_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","Bara vat nati alapi inani na dari kitin ghantinu Kutelle, ");
INSERT INTO amo_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","ita chaut hennani kitenen nbollu Kutelle nan nya kurtunu ulẹ na udin nan nya Yisa Kirsti. ");
INSERT INTO amo_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Bari urika na Kutellẹ natuu Yisa Kirsti unan bolu ari nan nya yinu sa uyenu, nan nya nmii mẹ: ana ni Kirsti ku bara apun nchaut mẹ tutun nin shawu nalapi alẹ nawa adi, bara ayi ashẹu me. ");
INSERT INTO amo_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Vat nani wa yita bara udursun ngegeme mẹ nan nya kokubẹ, anan dursọ litime chaut, akuru adurọ nwo amere din tizu anit chaut vat nalẹ na idinin yinnu sa uyenu nan nya Yisa. ");
INSERT INTO amo_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Unin fofigiri ndẹ? Ẹ kala unin. Kitene inyang? Kitene katwa? Nanare ba kitene inyinnu sa uyenu machas. ");
INSERT INTO amo_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Bari nani, ti malzina nwo unit din sesu nchaut bari uyinnu sa uyenu na katwa inshara dukuba. ");
INSERT INTO amo_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Sa Kutellẹ kun Nayahudawari machàs? Sa na amẹ Kutellẹ Nawurmerẹ. wang ba? Aẹ, nin Nawurmẹ wang. ");
INSERT INTO amo_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Andi Kutellẹ kurumari, ammati ubowe nan nya yinnu sa uyenu nchaut. ");
INSERT INTO amo_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Iyanghri ti din bellẹ, ifilin usharawẹ bari uyinnu sa uyenwá? Na nanni wayita ba. Nin nani ti miin usharawe. ");
INSERT INTO amo_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Nene, Ibrahim uchifi bite nan nya kidowo tibaworu ana se iyang? ");
INSERT INTO amo_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Bari andi Ibrahim wa se nin katwarik kidowo awa yitu nin nimon fofigiri, tutun na nbun Kutellẹ ba. ");
INSERT INTO amo_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Bari iyanghri uliru Kutellẹ na bellin? “Ibrahim na yinni ni liru Kutellẹ inalẹ wa batuzughne mu feu Kutellẹ.” ");
INSERT INTO amo_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Nene urika na adi katwa, na idin batuzughe mun nafo ubollu Kutellẹ ba, ina din batuzughe mu nafo ulẹ na min urẹ. ");
INSERT INTO amo_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Nani tutun kitin nlẹ na adin suzu katwẹ ba, ame na yinna ni lẹ nadi nutuuzunu nchaut kiti na lẹ na iyiru Kutellẹ ba, uyinnu sa uyenu me ibata nafo feu Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Dauda wa belli nmari di litin nit ulẹ na Kutellẹ din batuzu feu mẹ sa katwa. ");
INSERT INTO amo_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","A belle “anan nmareri alẹ na alapi mins ina shawa mun, tutun alẹ na ina tursu nani alapi mine. ");
INSERT INTO amo_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Unan nmareri unit urika na chikilari ma batuzu alapi me ba.” ");
INSERT INTO amo_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Nene mọ nmarẹ idin bellu minin kiti nannan bowarẹ sa vat nin nanna salin nbowe wang? Bari tiworo, “uyinnu sa uyenun Ibrahim iwa bataghe mun feu Kutellẹ.” ");
INSERT INTO amo_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Iyizari iwa nin bata? Kube na Ibrahim wa dinin bowarẹ sa nin salin nbo? Na iwa bataghe mun nan nya nbowari ba, iwa bataghe nan nya salin nbo ");
INSERT INTO amo_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Ibrahim wa seru alama nbowe usoghe utinchara feu Kutellẹ na awadimu adutu sa ubowe, bari anan so uchifin vat n lẹ na iyinna, ko idin nan nya ndirun bowari, inan bata nani feu Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","tutun anan yita uchif nannan dak kitin nbowari machas ba, ndu vat kiti nalẹ na idin chin nabunun inyinnu uyenu inchifbite Ibrahim uyinnu sa uyenu me na awadimun nan nya ndirun nbo. ");
INSERT INTO amo_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Bari na nan nya sharawari ubellu Kutellẹ wa kulo litin Ibrahime nin nisudume, au ima so anan minu iyii, nan nya nani fiu Kutellẹn iyinnu sa uyenu. ");
INSERT INTO amo_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Bari andi alẹ na inuzu, nshara din nan nya nannan serẹ, uyinnu sa uyenu nso hemmari une, tutun ubellu Kutellẹ nnana. ");
INSERT INTO amo_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Bari usharawẹ din dasu nin tinanayi, vat nin nani, kitẹ na ushara dukuba, na udirun ndortun nshara duku wang ba. ");
INSERT INTO amo_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Bari nani. libau inyinnu sa uyenuwari, inan so libau nbolu Kutellẹ, bara ubellu me nan yita vat nisudu. Tutun ilẹ isudẹ na imayitu chas kiti nalẹ na iyiru usharawaba, imayitu vat nin na lẹ na idin nuzun yinu sa uyennun Ibrahim ");
INSERT INTO amo_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","(urika na adi uchifbit vat, nafo na ina idi nya niyertẹ, “ meng natifi uchif nisudu gbardang”). Amẹ Ibrahim wadi nbun lẹ na awayinin ninghe, Kutellẹri une, urika na adin nizu ulai nalẹ na ikuzu, akuru ayichila ilẹ imon na idiba imone yita. ");
INSERT INTO amo_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Vat nin yenju ndas, Ibrahim wayinin nin Kutellẹ iwo aba yitu uchif nisudu gbardang, nafo na iwa bellu “Alelẹ ma yitu isudu fẹ.” ");
INSERT INTO amo_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Na nan nya ndiru nagan inyinnu sa uyenuba, Ibrahim wa yau kidowo me kin kulari-awadi kupo nakus akut likuru, tutun kiti kumatin Saraya wadi kiku kubẹ. ");
INSERT INTO amo_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Vat nin nani, bara ubellu Kutellẹ, Ibrahim wa daudau nan nya indirun yinnu sa uyenuba, awana kwii agaghari nan nya iyinnu sa uyenu, nin liru Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Awaynin vat imon irika na Kutellẹ bellẹ, adinin nagan usuninin. ");
INSERT INTO amo_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Bara nani iwakuru ibatizaghe mun nafo fiu Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Nene na iwa su iyertẹ nwọ ibatizaghe mugha usame nimon ichineba, ");
INSERT INTO amo_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Vat nin gherik wang, nya narika na ima batuzu, arikẹ na tiyina nin lẹ na a fiya Yisa chikilaribit nan nya kul. ");
INSERT INTO amo_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Yisa dana iwa nakpaghe bara alapi ikuru ifiyghe bari akusu ari. ");
INSERT INTO amo_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Andi iwa kusu ari bari uyinnu sa uyenu ari, tidin nin lisosin limang nin Kutellẹ nan nya chikaribit Yisa Kirsti. ");
INSERT INTO amo_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Nan nya mẹ, tidinnin libau bari uyinnu sa uyenu ndu kitin nbollu mẹ na tiyisin ku. Tidin lanzu nmang nan nya nagan ghantinu Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Na ilelẹ chasba, tikuru tidin lanzu nmang nan nya niwẹ na tidying, bari tiyiru uniwẹ din machu ayi akone. ");
INSERT INTO amo_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","Ayi aklne macha useru, useru macha likara kibinayi. ");
INSERT INTO amo_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Na likara kibinayi din dasu nin lanzun ichinba, bara kinayi Kutellẹ wa tinari nan nya nibinayibit nan nya nfip mi lau, na iwani ari. ");
INSERT INTO amo_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Bari vat wadi sa kayiri, kubi kuchinerẹ Kirstiwa ku bara anan ndiru Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Bari imone dinin konu kan iworo umon ma ku bari unan fiwu Kutellẹ. Andi umon ma yinnu aku wang, ama yinnu bari anit achine. ");
INSERT INTO amo_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Vat nani Kutellẹ wa punari kinnayi mẹ, bari tiwa yita anan kulapi Kirsti ku bari arik. ");
INSERT INTO amo_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Nene wang dana ikusunari lau nan nya nmii mẹ, timase utuchu nan nyẹ kiti tinannayi Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Andi arik natiwadi annan ivira, iwa kelẹ ari nin Kutelle nan nya. nsaunẹ, gbardang kan, kimalin kelẹ imanin tuchu ari nan nya nlai mẹ. ");
INSERT INTO amo_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Na nani chas ba, ayibit kuru apugun nan nya Kutellẹ Chikilaribit Yisa Kirsti, na kitemerẹ, nene tise ulẹ ukelẹ ");
INSERT INTO amo_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Bari nani, libau wasemeri kulapi wa piru uyii, nan nya nani ukul pira libau kulapi. Ukul nin dofino liti na nit asire vat, vat narika na ina ti alapi. ");
INSERT INTO amo_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Bari kimalin shara, kulapi wadin iyi, na iwadin batuzu kulapi kitena ushara wa dukuba. ");
INSERT INTO amo_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Vat nani, uku wasu tigoh inchizunnu Adamu udu kubin Musa, vat udu kiti nalẹ na iwasu kulapi nafo aAdamu ba ndirun lanzu liru, na amerẹ wadi kuyoli nlẹ namadakẹ. ");
INSERT INTO amo_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Vat ninnani, uni Kutellẹ nin patilunun shara di arume ba. Bari andi kitenen patilunun shara nwasame ukul na piru uyi litin kogha, nanerẹ wang gbardan ubollu Kutellẹ a unimẹ libau nbollu Kutellẹ wadak kitin wasame, Yisa Kirsti duku gbardan litin kogha. ");
INSERT INTO amo_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Bari unẹ, na umasin nin le na awati kulape ba. Bara nchara urum, ushara innazu wa piru bari upatilinun sharan wasame: inchara nba tutun uni Kutellẹ ni kusu kulapi wadak kimal nalapi gbardan. ");
INSERT INTO amo_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Andi bara kulapin wasame, ukul di tigo nan nya wasame, gbardan nani alẹ na isere ubollu Kutellẹ a unimẹ nan nya fiu mẹ, di tigo nan nya inlai wasamẹ, Yisa Kirsti. ");
INSERT INTO amo_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Usonani kitin wasame, upatilinun shara vat nanit napiru unanu, nanere wang, bara katwa kachine karum ukusu nalapi ndu inlai wa piru liti nanit vat. ");
INSERT INTO amo_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Bara kitin ndiru lanzu nliru wasame gbardang wa so anan nalapi, nanere wang kitin lanzu nlirun wasame gbardan nase fiu Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Nani vat, usharawẹ nadak bari upatilinẹ nan yita gbardang. ");
INSERT INTO amo_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Nane di bara asa kulapi di tigoh nan nya kul, nanere wang ubollu Kutellẹ ma su tigo nan nya fiu mẹ ndu nlai nan nya Yisa Kirsti Chikilari bit. ");
INSERT INTO amo_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","I yaghari tima bellu? tili ubun in su na lapi bara ubolu Kutellẹ tinan gbardang ghe? ");
INSERT INTO amo_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","nauwa sonanin ba. Arik a lena tinna kuzu nin nidowo na lapi? ");
INSERT INTO amo_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Naiyiru oh ingbradang na le na ina ubaptisma nami ligowe ni kristi Yisu iwa suminuubatisma nani udu ulai ba? ");
INSERT INTO amo_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","I wa kassu nari ninghe kuh in baptisma nannyan ku, nafor na iwa fiya kirsti nanere arik wang ma chinu nan nyan in lai upese, ");
INSERT INTO amo_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","timunuati nin ghe nafo nin kulme tima kuru timunu ati nin ghe nin fitu me. ");
INSERT INTO amo_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Tiyeru nene iwa bana kidowo bite nin ghe barn, inan molo kinanzang kin kulapi ");
INSERT INTO amo_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Ulena aku aso unan sali kulapi kiti kulapi. ");
INSERT INTO amo_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Asa tiku nin Kirsti, tiyinna ti ma kuru tiso ligowe nin ghe. ");
INSERT INTO amo_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Ti yiru anfiya kisti ku nan nya kissek tutung na aduu nan nya nan kul ba. Naukul du nin likara kitime ba ");
INSERT INTO amo_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Bara ukule na awaku kiti kulapi, awa ku urumari chas bara vat titun ulai na adimun asosin bara Kutellẹ-ari. ");
INSERT INTO amo_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Anun wang; yiran ayimine anan kul kulapi in lon likot anan lai kite Kutellẹ nin Kirsti Yisa. ");
INSERT INTO amo_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Bara nanin niwa yinin kulapi nodin nidowo mine nin kul ba bara iwa yinin nin ntok kidowo ");
INSERT INTO amo_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Ni wa ni niti niti dowo mine kiti kulapi iso imongkata kulap, ba anun Kutellẹ nidowo min, nafo ana nuzu nannya niti niti ulam bara Kutell. ");
INSERT INTO amo_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Ni wa yinin alapi se likara kitene mine ba, bar na anun du sa in kana, na ti di nan nyan duka ba bara ti di nan nyan mbolu Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Anin iyang? tili ubu n nin na lapi bara na ti du nan nyan duka ba barna ti di nan nyan mbolu Kutellẹ? Na uwa so nanib. ");
INSERT INTO amo_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Na iyiru ule na i nakpa atimine, nan nya lichin in lanzu in liru iso achin in le na idin lanzu ulirume sakulapi udu uku, sa ulanzu inliru udu anan sali na lapia? ");
INSERT INTO amo_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Vat nani liburi libo kiti Kutellẹ, I wa di achin kulap, ina nin yinna nin nibinai udursuzu kiti kanga na ina ni minu. ");
INSERT INTO amo_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Ina nutun munu nan nya tikanchi kulapi, ina ni so achin fiwu Kutellẹ. 19Indin su uliru nafo unit nin sali likara nidowomine. Nafo na ina nidowo mine nafo achin lisosin linanzang linanzan. Nene nakpan nitiniti nidowo mine nafo achin infiwu Kutellẹ nan nya lisosin limang. ");
INSERT INTO amo_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","kubi kona iwadi achin kulafi na iwa di nan nya na nit alauba. ");
INSERT INTO amo_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Ku yapin kunatari iwa dumun kube nan nya nimon ile na ne nene idin lanzu inchin muna? ");
INSERT INTO amo_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Bara kumat ni leli uwonne vat ukulari ");
INSERT INTO amo_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Nafo nene na na inan nutun munu tikanchi kulapi inanin so achin Kutelle, nono kumat mine in so nin lau tutun imalin mine ulai sa ligan. ");
INSERT INTO amo_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Bara kusere kulapi ukullari titun ufillu kibinai Kutellẹ ulai sa ligan nan nya kitin Kirsti Yisa chikilari bite ");
INSERT INTO amo_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Sana iyiru ba linuana in din liru nin na nit ale na yiru uduka bara uduka din dortu nin nit nan nya na yirin in lai me? ");
INSERT INTO amo_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Ame uwani ni luma a terin nin lesse nan nya nisilin niluma ywase ulesse nnku, abuntu nannya ni silin ni luma. ");
INSERT INTO amo_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Bara nan, nan nya kubi ko na ulsse di nin lai asa anuzu asu iluma nin mong ima yichi ghe ukilak. Asa ulesse nku anuzu ni silin nilumea na du ikilaki asa su ilumama nin mong uni. ");
INSERT INTO amo_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Bara nanere nwa na nin i wa ti munu anan kul bar uduka nan nyan Kirst, bara ina dofuzonu ligowe nin nin nat, bara ame, naiwafiya ghe nan nya nan ku, bara bara nan macha nono fiu Kutelle. ");
INSERT INTO amo_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Kube na ti wadi nakidowo wanuzu kamang nan nya niti niti nidowo bite. In nuzum duka bara tinan nut tuno nono kul. ");
INSERT INTO amo_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Nene ina nutun nari nan nyan duk a tinani naku nan nyan in chn bite na ti wa kif, bara ti nan su kata kapese nan nya in fip Kutelle, na nan nya in chin ukuse ba. ");
INSERT INTO amo_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Ani iyari tima belle nene? Ani uduk kulapiari litime? Na uwa so nanin b. Vat nin nan, na inwa na yinin kulapi ba, sasana uduka b. Na inwa yiru iyiru iyari kunaniyizi sasa na uduke na bellin b, “Naubasu kunaniyizi ba,” ");
INSERT INTO amo_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Tutun kulapi nayiru kubi nan nya in duka unare na dak nin vat intok kulapi nan nya nin. Tutun andi na Uduka di ba kulapin nkul ");
INSERT INTO amo_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","so uurum in wa yita nin bai sa Uduka ne uduka dak kulapi koni na kuru kurun fita iminaku ");
INSERT INTO amo_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","Uduka na una din wori ubani ulai unin na da nin kul. ");
INSERT INTO amo_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Kulapi na yiru kubi nan nyan Uduka kurusuzu, nkoni na molii kitenen uduke. ");
INSERT INTO amo_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Nani ushara di lau a uduka lau imon ichine nin chau. So urum in wa yita nin lai sa uduka, nene na uduka na da, kulapi koni na kuru ku fita immini nak, ");
INSERT INTO amo_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Nni nene imon ichine isoyi ukulla? Na nani b. Nani kulapi, bara in durso kulapi ari sai nan nyan ni mon igegeme. uni na dai nin kul bara nan nya induka kulapi na na nnzu kamang. ");
INSERT INTO amo_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Bara tiyiru o Usharawe di nin fip kutelle, vat nanin in di na kidow. Ina lewi udu lichi nan nya, kulapi. ");
INSERT INTO amo_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Bara iwon ile na idin suzuna in yirub. Imon ile na indi nin sun su. Na in nare indun sue ba imon ile nain nari inare indin sue. ");
INSERT INTO amo_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Bara nani andi in din su iwon ile na in dimin suwe b. Men yinni nin woru ushara chau. ");
INSERT INTO amo_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Bara nani na mere din suzu ininb, kulape na kudi in nan nya nigher. ");
INSERT INTO amo_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Bara nanin men nan nya kidowo nigh, na imon ichine duku b, bara usuu ni mon ichine di nmi vat nani na in wasa su ba. ");
INSERT INTO amo_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Bara imon ichine ile na in dinin su in s, indin su b, nani imon inanzang ile na in di nin suwa ba inere in din su. ");
INSERT INTO amo_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Nene asan insuimon ile na indi nin su b, to nanere nane din in sue b, vat nane kulere na kudi nan nya nighe. ");
INSERT INTO amo_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","In se nan nya ime likara lichine in di nin sun in su imon ichin, vat nanin imon inanzanghari di in me. ");
INSERT INTO amo_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","In di nin liburi libo nin shara Kutelle bara uni ule na adi nan nya ni. ");
INSERT INTO amo_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Mmini yene umon uka'idari ugan di niti niti kidowo nighe udi likum nin ukai'da upeseh nan nya kibinai nighe aminin yirai kuchin bara ukai'da kulapi ule udi niti niti nidowo nighe. ");
INSERT INTO amo_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Ki kimong nameng! Ghari ba tuchu menku nan nya kidawo nkul? ");
INSERT INTO amo_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Liburi libo kiti Kutelle bara Kirsti Yisa Chikila bit. Bara nani meng litini ghe in lon li kot mmaa dortu Ushara Kutell, in lon li kot tutung indortu uka'ida kulapi nin kidowo. ");
INSERT INTO amo_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Nene na uchan ukul diku ba, kiti nale na idi nan nya Kirsti Yisa. ");
INSERT INTO amo_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Bara uka'ida infip Kutelle unlai nan nya in kirsti Yisa na nutuni fong in kai'da kulapi nin kul. ");
INSERT INTO amo_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Imon ile na ushara wa yinin usue ba bara na uwadi nin likara ba nan nya kidaw, Kutelle nasu: iwa tu Gono me nin in nit usirne unan kulapi ayiru kiti kulapibit. amini nati kida wo kulapi inkul di in cha nku. ");
INSERT INTO amo_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Awa su nani bara imon pizire nan nya insharawe nan kulo nan nya bite arik ale na uchinbite di na kidawo ba udi nan nya Infip Nnu Kutelle. ");
INSERT INTO amo_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Ale na idin chin nan nya kidowo din chisu nibinai mine nimon kidawo, ale na idin chinu nan nya Ifip Nnu Kutelle din chisu nibinai mine kiti nimon in Ifip KUtell. ");
INSERT INTO amo_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Bara ufo liti kidawo ukullari, a ufo liti kidowo liaison, ");
INSERT INTO amo_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","bara ufo liti di nin ni vira nin Kutell, bara na a yinna nin usharia Kutell, awasa a yinno usue ba. ");
INSERT INTO amo_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Ale na indi na nidawo na idi nin woru ipo Kutetelle ayi b. ");
INSERT INTO amo_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9",". Nani tutung, na idi na nidowob. Idinan Infip Kutelle andi kindegenere Ifip Kutelle di nan nya mine. Andi na umon di nin Fip Kirsti ba na ame un mereba. ");
INSERT INTO amo_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Andi Kirti di nan nya mine in long li kot kidowa maso kin kul bara kulapi in lon likot tutung Ifip Kutelle ulaiyari bara uchinu dert. ");
INSERT INTO amo_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Andi infippin le na awa fi Yisa ku nan nya kissek di inf. Ame ule na wa fiya Kirsti ku nan nya kul ma kuri ani nidowon kul mine ulai bara ame ule na adi adi nan nya mine. ");
INSERT INTO amo_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Bara nanin linuana arik ana tire wari na ti ni nidowo b, na tiwa su lissosin nidowo ba. ");
INSERT INTO amo_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Bara nanin asa udi nan nya kidawo udi bellen kuarun. Asa uku nan nya Ifip Nnu Kutelle kidowo nin kate me uma ti ula. ");
INSERT INTO amo_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Bara vat in gbardang na le na Infip Kutelle din dursuzu nani uchin inun nono Kutelleari. ");
INSERT INTO amo_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Bara na i na seru infip lichin na ima lanzu fiub, ina seru infip in wru i so unit urum uneren ta tidin yichu”Abba Baba ");
INSERT INTO amo_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Ifip Kutelle litime nin min bit infippe yinna arike nono Kutelleari. ");
INSERT INTO amo_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Andi non, tutun anan li ugad, ugadue un Kutelle in kon ku sari a anangadu nin kristi tutun mmon uchara. Andi tutung tiniyo kan nin gh, nanere tutun tima se uzazunu nin ghe ligowe. ");
INSERT INTO amo_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Uyenu nin uniyu bite nin ko kube nee na udurum in gbardang in ghentinu ule na ima dursu nari ba. ");
INSERT INTO amo_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Uchiwu nibinnai kang na makeke din cha idursu nani inin nono Kutelleari. ");
INSERT INTO amo_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","I wa toltin in gongon udu invon ihe, sa usu mine, bara usu in le na amaerie na ti nani ");
INSERT INTO amo_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Bara makeke we atiminene ime nutuno nani nan nya lichin linanzang udipiru lisosin ligongong lin nono Kutelle. ");
INSERT INTO amo_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Bara tiyiru vat makeke di lidurun nin kata nan nya nkunuligowe nene. ");
INSERT INTO amo_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Na nane chas b, arik ma atibite ale na idi nin nonon inchizno Infip Kutelle nan nya nati bite tidin gbondulu, tidin in cha isere nar, ukurtunu ni dowo bite. ");
INSERT INTO amo_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Ina su nari Utuchu vat bara uginnu ari. Uyinnu ule na idinyenju unin na uyinnuariba. Nafo ghari in yinna nin ni mon ile na adingenuju nene? ");
INSERT INTO amo_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Bara asa na tiyino ni ni mon ilena tisa yen, to tiba su uchawe nin na yi asha. ");
INSERT INTO amo_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Nan nya lirum, Innfip Kutelle wang din buzunu nari nan nya lidarin bite. Bara nati yiru yanda na timati inlirab, Ifip Kutelle nin litme din su kata nan nya bite na nin gbondulu ba. ");
INSERT INTO amo_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Ale na adin yeju nibai bitayiru nibinai Infip Kutelle. ");
INSERT INTO amo_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Tiyiru ale na idi nin su Kutelle adinesu kataka chine vat bara ichinn, ina yichila nafo kpilizu me. ");
INSERT INTO amo_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Bara alena na yarin ayinno, ana mali uti usi lisossin nafo gono me bara ana yita gono kin chizinu nan nan nyan nuana gbardang. ");
INSERT INTO amo_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Ale na tutung na amaqlu u feriu ana yichila. Alena ana yichil, inua tutun kusu lau. Ale na awa kusu, inighere ana zazin. ");
INSERT INTO amo_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","I yaghari tima bellu nene kitene nile imone? Andi Kutelle di nan arik ghari ba nari nari? ");
INSERT INTO amo_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Ule na ana nuzu nin Gono me ba a mini na ni kimin bara vat bit, iyari ba wantin ghe na ana imon vat? ");
INSERT INTO amo_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Ghari ma dak nin karusuzu nan nya imonrumn in feiu Kutelle? Kutelleari unon su ushara. ");
INSERT INTO amo_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Ghari ma kiti finu kulapi? Kirsti Yisa, ule na a wak, ule na nan nya nimon vat ichine i wa fiya ghe nan nya kulapi amini nasosin nene in chara Kutell, amini din fo achara bara arike? ");
INSERT INTO amo_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Ghari makosu nari nin su Kristi? liburi lisirne sa imgbagbai kidowo asa uniu wasa kupogha sa lisisosin fiseri, sa uhasaria, sa kuboong? ");
INSERT INTO amo_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Nafo na nyertti di”Bara fewe idin molsu nari ko lome liri ina yiru nari nato alkam indi basu” ");
INSERT INTO amo_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Nan nya vat nimon tikata kitin linbun nan nya inlena na a durso nari usu. ");
INSERT INTO amo_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Bara in kala udinrun yinnu na ukulba sa ulai sa Amalaiku sa tigo sa imonmon na idi nene sa imomong na idin chinu sanlonlikar, sa inzang, ");
INSERT INTO amo_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","sa inchomcho, sa imonmong na ina k, imo yinu ukosu nari nin suKutell, ule na udi nan nya Kirsti Yisa Chikilari bite. ");
INSERT INTO amo_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Ndin bellu kidegen nan nya Kirsti, na in bellẹ kinuba, ulamiri nighe in tayi iyizi nba nan nya Nruhu Kutellẹ ulau. ");
INSERT INTO amo_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Indi nin liburi lisire kang nin konu in salin shizunu nan nya kibinayi nighe. ");
INSERT INTO amo_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Nafo meng litinighe in yita nin su in ti litini unu in nana kitin kirsti bara nuana ning, likura ning nya kidowo. ");
INSERT INTO amo_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Inun na idi Israila. Idi nin seru, nin zazunu, nin nisilin, nin liru Kutellẹ, a likawali. ");
INSERT INTO amo_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Inighari nin na chiff nburnu minere Kirsti na dak nin toltinu nan nya kidowo- Kirsti na amerẹ kitenen vat nimon, unan nmari Kutellẹ sa lingan. Usonani. ");
INSERT INTO amo_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Na uwaso nafo likawali Kutellẹ nso hem. Bara na kogha na adi in Israila kidegen nere kunan Israila. ");
INSERT INTO amo_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Na tutung vat kuwunun Ibrahimari di nonọ me ba. Kiti litin Ishaku timaso likura. ");
INSERT INTO amo_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Usọ, nonọ na kidowo na nonọ Kutellẹri ba. Uso nonọ likawali inugherẹ idin batuzani nonọ likure. ");
INSERT INTO amo_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Bara ulẹ ulirẹ unalikawali ari: '' Nin ko kubẹ nma dak, nmani Saratu ku gọnọ.'' ");
INSERT INTO amo_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Na ulelẹ chas ba, kimalin Rabika wanin nit uwasamme, uchiff bite Ishakuw- ");
INSERT INTO amo_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","11","na iwadi isa mara nonọ ba, ana isa ta imoimon i, hine sa inanzang ba, inan woro ukpilizu kibinayi Kutellẹ inbelen nferu me nan so nani, na bara kata kidowo ba, unuzu kitin nlẹ na ana yichila. ");
INSERT INTO amo_vpl VALUES ("RM9_12","075_9_12","ROM","9","12","12","Iwa taba ubelinghe, ''Ukune mani ubenẹ tikunẹ.'' ");
INSERT INTO amo_vpl VALUES ("RM9_13","075_9_13","ROM","9","13","13","Udi nafo na iyerte di, ''Yakub adi kibinayi nin Isuwa inari amẹ.'' ");
INSERT INTO amo_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Iyari timabellu? Kutellẹ dini dinongha? Na nani wa yitaba. Bara awa bellin Musa ku au, ");
INSERT INTO amo_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","“Nma dursu ujinkai kitilẹ na indi nin jinkai, Nkunekune kitilẹ na indi nin nkunekune”. ");
INSERT INTO amo_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Bara nani, na ule na ana kibinayi ariba, a na ulẹ na asu uchumari ba, bara Kutellẹ ari ulẹ na adurso ujinkai. ");
INSERT INTO amo_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Uliru Kutellẹ w bellin Firauna ku, Bara ma manufẹ rẹ ina fiyafi, innanse indurso likara nighe litife, Lisa nighe nan se upiru kowe nan nya inyẹ. ");
INSERT INTO amo_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Bara nani, a dinij jinkai kitile na ata usu, kitin le na ata usu tutun ataghe gbas. ");
INSERT INTO amo_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Uma belli nenge, ''Iyarin ta udin pizuru anit nin kulapi? Ghari wasa asu umusu nighe? ");
INSERT INTO amo_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Kai unit, saka uyenu, fe ghari na uma kpanu Kutellẹ? Tiwin to na ina ke ma bellu unan kewe, ''Iyari ta una keyi nenẹ?'' ");
INSERT INTO amo_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Ani na unan ke na melenghe wasa akoso tiwin ti shife to ake kumeleng kuchine mun, to tutun a ke nkon 'mun nanzang? ");
INSERT INTO amo_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Andi Kutellẹ, dinin su adurso tinanayi me, akuru ati iyene likarame, awunno kubi nin shew kibinayi me, bara anan da wese anan mizunu tinanayi nibinayi mine. ");
INSERT INTO amo_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Bara tinan yinnọ mgbardang nkune kune kibinayime liti nalẹ na inin dinin kune kune, ale nawa achiu bara a ghanti nani. ");
INSERT INTO amo_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","umunu arikẹ wang, nya nalẹ na ana yichila, na nan nya nayahudawa chasba, umunu ingisin tilem tileme vat. ");
INSERT INTO amo_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Tutun nafo ubellu me in Hosea: “Nma yichilu anit nin alẹ na iwadi anit nin ba, nin nalẹ na indi kauna, bara na inwadi kauna mine uworsuba. ");
INSERT INTO amo_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Tutun umanin so nenge, kiti ka na iwa yertin na anu anit nighari ba, nene ima yichimunu nọnọ Kutellẹ lai.'' ");
INSERT INTO amo_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Ishaya wa su kuchulu bara nonọn Israila, ''Andi ingbardang in nonọ Israila masin licicin kurawa, ingisinghari mase utuchu. ");
INSERT INTO amo_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Bara Chikilari ma su kata nin lirume nan nya iyi ulelẹ vat na nin molu kubiba. ");
INSERT INTO amo_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Nafo ubellu Ishaya na awa bellin mun. “lndafo na Ugo Kutellẹ wa sun nari ingisin nisudu ba, tiwaso nafo Usodom, tutun tiwa lawu masin Ugomorah ");
INSERT INTO amo_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Iyari tiba ku tibellin? Awurmi na iwadi anan fiu Kutellẹ ba, nene iso anan fiu Kutellẹ bara uyinnu sa uyenu. ");
INSERT INTO amo_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Inun Israila na iwa dofin ushara nin fiu Kutellẹ, na iwa duru igan i. nin ba. ");
INSERT INTO amo_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Iyang wantin? Bara na iwa pizuru nin yinnu sa uyenuba, iwa piziru nin kata kidowo inani wa tirọ litala intirzu. ");
INSERT INTO amo_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Nafo na ina yertin, ''yenen in na nonko kutala in tirzu nan nyan Zion a kupara kulapi. Ule na ayinna mun na ama lanzu inchin ba.'' ");
INSERT INTO amo_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Linuana, usu kibinayi nighe nin fọ nachara nin kiti Kutellẹ, unare ise utuchu. ");
INSERT INTO amo_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Meng ta iyizin inba nati mine bara idi nin su isu kata Kutellẹ, na dert nin liru Kutellẹ ba. ");
INSERT INTO amo_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","Na inin di nin yiru Kutellẹ di nin lauba, ina nin na pizuru inin se inlau natimine, na inun nani atimine kiti infeu Kutellẹ litimẹ ba. ");
INSERT INTO amo_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Bara Kirsti amere ukulun duka fiu Kutellẹ udu vat innan yinnu nin Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Bara Musa na su iyertin inbellẹn fiu Kutellẹ ule na udin dasu kitin duka: “Unit ulẹ na su fiu Kutellẹ nan nya duka, basu uchin nan nya nin.” ");
INSERT INTO amo_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Bara fiu Kutellẹ ulẹ na unuzu nan nya yinnu sa uyenu nworo ne, “Na uwabelin nya kibinayife, 'ghari ma ghannu kitenekani?' (bara anan toltinọ Kirsti ku kutin), ");
INSERT INTO amo_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","sa tutun, 'ghari ma piru na kisek?' (adi nutun Kirsti ku adamun.)'' ");
INSERT INTO amo_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Au iyari ibelle? ''Ligbulaghe di susut ninfi, nan nya nnufe a nya kibinayife.'' Ligbula in yinnu sa uyenu ari une, na tina mo girzunẹ. ");
INSERT INTO amo_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Bara asa ubelle nin nufe Yisa Chikilari bitari, unin yinna nya kibinayife au Kutellẹ. wa fiyaghe nan nya kul, umase utuchu. ");
INSERT INTO amo_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Bari unit di yinn fiu Kutellẹ nin kibinayẹ ari, tutun nin nuwari asa uyinnu intuchu. ");
INSERT INTO amo_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Bara uliru Kutellẹ woro, “vat inlẹ na ayinna ninghe na imatighe inchinba,” ");
INSERT INTO amo_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Bara na Ayahudawa di ugan, a Awurmi ugang ba. Bara Chikilari urumerẹ di Chikilari vat, tutun adi susut nin lẹ na ayichilaghe. ");
INSERT INTO amo_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Vat inle na ayichila lisa me ama se utuchu. ");
INSERT INTO amo_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Inyizi ari inin ma yichilu lisa lẹ na anu yinna ningheba? Tutun inyizi ari ima yinnu nin lẹ na isa lanza ulabari meba? Tutun inin ba lanzu inyizi ari sa unan bellun inliru Kutellẹ? ");
INSERT INTO amo_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Tutun ima tiyizari ibellin uliru Kutellẹ s kadura? Nafo na ina yertin “ Inyizi ari inchaut nabunu na nan bellu in liru umang nin nimon ichine!'' ");
INSERT INTO amo_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Tutun na vatari na lanza ulirun inlai ye ba. Unare Ishaya wa woro, “ Chikilari, ghari n yinnin nin kadura bite?'' ");
INSERT INTO amo_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Bara nani, uyinnu sa uyennu din dasu kiti lanzu, tutun ulanzu ligbula Kirsti ");
INSERT INTO amo_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Ameng tutun nworo, “Iwa lanza ba?” Eh!, nanere gbardang. “Liwoi mine na do vat inyẹ. Tutun agbula mine na piru vat ligan inyẹ” ");
INSERT INTO amo_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Tutun, Nworo, “Na Israila na yiru ba?” Uchizunu Musa woro, “Meng ma nazu minu nibinayi nin kiti ka na Immyin mi dyawariba. Nin so immiyin sa uyinnu, Meng ba timinu ilanza ayi.” ");
INSERT INTO amo_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Ishaya nuzu kanang a belle, “ Alẹ na ina pizurui ba ina sei. in na durọ litining kiti na lẹ na ina tiri tidina ning ba. ");
INSERT INTO amo_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Kiti nan Israila abellẹ, “Ko kishi uchara ning yisin kiti nanit ale na idi gbas nin ale na inari. ");
INSERT INTO amo_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","a belle nani sa Kutelle wa nnari anit me? uwanya uso nani ba bara men wangnkuna Isiraila ri unuzu likura Ibrahim tutun lilem benjamin benjamin. ");
INSERT INTO amo_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Kutelle wa nnari anit me b, ale na awadi ananyinu nani, sa lyiru imon ille na inyarta wa bellin litin kitin Iliya na awa sau kuhulu kiti Kutelle abara anan Israila? ");
INSERT INTO amo_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","Chikilari inna mollusu anit anan mbellu naufe ipucho tibagadife miyari chas nlawa tutun idin piziru nighe. ");
INSERT INTO amo_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Kutellẹ wa tarda awaro: “nna chau litinighe nanilime amui kuzor alle na issa tumuno nin naluum mine kitin baale ba”. ");
INSERT INTO amo_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","har nene re nnya ko kusa ufere mboullu Kutellẹ imon nggisin duk. ");
INSERT INTO amo_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Vat nani andi barai ayii ubolluKutellẹ na bara katari ba andina nani ubollu Kutellẹ. di ubollu ba. ");
INSERT INTO amo_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Iyarighari tutungha? imon ule na an Isirale wa piziru iwa se iniba nnan feeru Kuteelẹ wase ngisine ghas. ");
INSERT INTO amo_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","Ud nafo na inyerte wabellin “Kutellẹwa nii nani Ifipnnun me min nyisi na nyeju kiti ba nin atuf ansalin nlanzu uliru udak kitin mon” ");
INSERT INTO amo_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Dauda woro nenghe “na kutebul mine sokutaru libarda litala ntirzu a usọ atunu” kitimine. ");
INSERT INTO amo_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Naiyizi mine uwo isirọ bara i wayeje kiti ko kome mine tumun ");
INSERT INTO amo_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Awa bellin nani “iwa utirzo bara disua idiuwa?” uwa uso nani ba bara nan naudisu mine watii uduchu daa na nan nan nsalin yiru Kutellẹ baraifea nanin ayinasu liyarin. ");
INSERT INTO amo_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Andi uyi naseimon nachara diu mine uwalu mine umon nachara kiti nan ntanni nin malizin nacharaiworo use namon nachara. ");
INSERT INTO amo_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Nene nin indin nliru nanghinu anan ntani kulle meng unan kadura na uda kiti nan ntanni Kutellẹ indin fọfigiri nin katanighe. ");
INSERT INTO amo_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","mmoti mba nanzu amon nibinai issua. lagann alle na idi amon mine se utuch. ");
INSERT INTO amo_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","An di unna rani alele unare ti tise umuni nati an nye '' Yagari useru mine ba ti uba so ulai ki nan kulle?'' ");
INSERT INTO amo_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","An di kumat ifarri adi lau na nere iyip ma, an tillin di lau, annere ti langgye ba yitu. pucu tilangye ina. ");
INSERT INTO amo_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Iwadin woru i puco ton ti lang kuca, f, kucan zaitu kusho iwa shonfi na nya mine uba koswu nan gyinu mmari tiling tiling kuca zaintu, ");
INSERT INTO amo_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","yen je uwa fo figiri nin tilan gye. Asa uba fo figiri na fere nin tilang, na fe re ming ti langye ba, ama tilangyere min fi. ");
INSERT INTO amo_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Uma/ uba nin woru, ''Ina n shono men ku nan nye.'' ");
INSERT INTO amo_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Kidegen nere/ kiden nere! Bara usalin nni kibinai mine iwa pucu tilangye, nin nani uyisa nan nya yenu fe sa uyenu. Nu uwa ganti liti fe kan ba, lanza fiu. ");
INSERT INTO amo_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Sasa na Kutelle wa sun tilang ti cine ba fe wang na awa sun fi ba. ");
INSERT INTO amo_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Yenen nene, imon i cine irka na Kutelle na su. Nlong ikot urinjaya Kutenlle wa wunun ale na iwa dui, inlong likot urinjaya Kutelle na dak ati mine uni wa ti ayi a shaeu me, sasa na ni ba, fe wan iwa wernu i finlo. ` ");
INSERT INTO amo_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Iwasena ituna nan nya salin yinnu ibashonminu nan nya iba shunmunu nann nya. Bara Kutellẹ nwa nya apirun minu nnan nyẹ. ");
INSERT INTO amo_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","fe wang iwa kalafi kiti kuchan nzaitu kusho, ko na litino me din nan nya kusho, ida munu fi nin kuchan nzaitun kilari, nafo na idin suzu belle anun na iyiru litinọ mine, ikuru ishominu kuwa. ");
INSERT INTO amo_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Linuana na iwa so lọn ba, nin nimon liyeshi, bari iwa yita nin yinnu nin kpiluzu nati mine; Israila nase ngbas bat nan nya mine, se na inase ukulu nannan tanni Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Nanere vat nan Israile base utuchu, nafo na ina yerti: “unantuchu ba nuzu nnan nyan Zion; aba kallu udiru kutelle kitin Yakub. ");
INSERT INTO amo_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Likawali nigha lolẹ nan ghinu, nba kalu alapi mine.” ");
INSERT INTO amo_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","Nlon likot nbellen nliru Kutellẹ, ina nari ani bara anun, nlon likot bara uferu Kutellẹ, anan suuwari barian ka mine. ");
INSERT INTO amo_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Bara na Kutellẹ wasa akpiliya kibinai mẹ nan nya fillu nin yichilu me ba. ");
INSERT INTO amo_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Nafo nin chizune ne na iwadi anan dortu Kutellẹ ba, ina se nkune kune Kutellẹ bara udortu me, ");
INSERT INTO amo_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Nene alẹ Ayahudawe iwa nari udortu Kutellẹ, iwa first nani nkune kune nafo na ina durso minu inung ma nene seru nkune kune. ");
INSERT INTO amo_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Kutellẹ na tursu kogha ku nin dirnun dortu me, bara adurọ in nkune kune kitin kogha. ");
INSERT INTO amo_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Kakama, ncham cham nimon nachara inyiru nin yinnu Ketellẹ! Ghari wasa a pizira nan nya nsharamẹ, Tibau me katin likara inyinnu! ");
INSERT INTO amo_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","“Ghari yiru kibinayi in Chikilarẹ? Sa ghari udon nkpiluzu in nliru me? ");
INSERT INTO amo_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Sa ghari na burun ana Kutellẹ imonimon, sa inan kpilla ina ghe?” ");
INSERT INTO amo_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Bari kitimẹ, nin nan nya mẹ, a udu kitimẹre imon di vat. Udu kitimẹ ngongọn so saligang. Ussonani. ");
INSERT INTO amo_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Nin nani, ndi kuchukulu kitimine linana bara gbardang nkune kune Kutellẹ, nan nidowo mine ugutunu mmii, imon seru kiti Kutellẹ, bara unnere unni natimine kiti Kutellẹ, nso katamine nan nya Nfip Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Yenjen iwa dofin lidu inyi ulelẹ, kpilan atimine iso apese nan nya nibinayi mine, inan yinnọ imonirika na idi ichine, inseru, nin chasarak nnufi Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","In din bellu, bara ubollu Kutellẹ. na iwani, bara umon nan nya mine wayiru litime zikiki akata ligan lọ na ina cheghe ku: Na ikpilza ukpilzu uchine, nafo na Kutellẹ na fulọ kogha ku ligan chiu kibinayi in yinnu sa uyenu me. ");
INSERT INTO amo_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Nafo na niti niti di kidowo kirum, vat niti nitẹ ko kame dumun katamẹ, ");
INSERT INTO amo_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Nanere tidi gbardang kidowo kirume nan nya Kirsti, tidin gangang vat nin yitu arumẹ. ");
INSERT INTO amo_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Bara na kogha dimun da diume na ubollu Kutellẹ na nighe. Andi uda diue fe ubellu nnu Kutellẹ'ri, na usu dert nin ligang nimon na ina fuloghemun nan nya inyinnu sa uyenu. ");
INSERT INTO amo_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Andi uda diufe usu nsu nanit katawari, na asu. Andi uda diu fe udursuzu kitẹri, na a dursuzo. ");
INSERT INTO amo_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","Andi uda diu fe unizu nanit likara kibinayari, niza ani: Andi uda diu unizuari, nizafi tapp: Andi uda diu fe uwunun nbunari, su seng. Andi uda diu fe ulanzu nkune kuneri, su nin nayi abho. ");
INSERT INTO amo_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Na ussu mine wanso unrusuzu liti ba. Nari imon inanzan; minọ ilele na ichau. ");
INSERT INTO amo_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Ubellẹ nsu linuana, chiun ussu natimine na nibinayi; nbellen ghantinu na kogha ni gwana me. ");
INSERT INTO amo_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Nbellen kayiri, iwasu ku gwala ba; nbellen nruhu, uyita mas mas; Nbellen Chikilari, su kata me. ");
INSERT INTO amo_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Nan nya nayi akone, su liburi liboọ; nbellen nfizu nayi, nonkon nibinayi; nbellen nlira, na iwachin ba. ");
INSERT INTO amo_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Dan timunu achara tibukatu na nan nsali kulapi, nan atimine anan sesu namara. ");
INSERT INTO amo_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Tan alẹ na idin nizu munu uniu nmari; tizan nmanri na ulaana. ");
INSERT INTO amo_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Sun ayi abho nin nale na idi nayi abho gilan nin nalẹ na idi kuchulu. ");
INSERT INTO amo_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Sun lisosin limang nan nanit vat. Iwaso anan kpilluzu nghantinu nati tibau mine ba, seren anan toltunu nati. Iwa yita jijin nan nya kpilluzu mine ba. ");
INSERT INTO amo_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Yenjen iwa tunu imon inanza nin nimon inanza. Sun imon ichine kiti nanit vat. ");
INSERT INTO amo_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Andi uba sonani, son ligan likara mine mang nan nanit vat. ");
INSERT INTO amo_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Yenjen iwa tunnu atiminemu, linuana, nan tinanayi Kutellẹ libau. Iyerte na woro ''uttunu unanighari; nba tunnu; ubellun inchikilari.'' ");
INSERT INTO amo_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","''Asa unan salin nsufe din lanzu kukpon, naghe alii. Asa ayin kotoghe, naghe asonọ. Uwasu nani, uma pitiringhe achalang nlari litime.'' ");
INSERT INTO amo_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Na iwasun tinanzang lii likara mine ba, lewu likara tinanzang nin gegeme. ");
INSERT INTO amo_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Na kogha dortu uliru nago, na nton tigo duku sa uyinnu Kutellẹ ba; Kutellẹ ameri unan ni tigo. ");
INSERT INTO amo_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Bara. nani ule na yasa tigo ayasa Kutellẹ, tutun anan kiyasa tigo iba sunani ushara. ");
INSERT INTO amo_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Agọ na imon fiuwari ba kiti nanan su nmon kine imon ufiu kiti nnanan sunimon inanzang na aye difi ulanza fiu na nan tigo ba? suu imon meichine ubase liruu kitime. ");
INSERT INTO amo_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Ame kuching kulelle kitimine inanzang lanza yi, na adin mmizinu liyop. hem naninb. Ame kuchin. Kutellẹ ulena aba tunnu tinana na kiti nlena adiṣu inlmon inanza. ");
INSERT INTO amo_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Bara nani ibasuu udurtun nlirun nliru na bara unanu nayii Kutellẹ chas ba har nin lamiri wong. ");
INSERT INTO amo_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Bara nani in bizu nah id ugandu wang. Inun agowe achin Kutellẹ ari alle idin suil ille imone kokome kubi. ");
INSERT INTO amo_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Nan kọghaku ule imon na adin dortu munu, ini anan mmyen ungandu mmyen mine lazan fiu nslale na ibati ilanza fiu mine, nghantinan anan nun ighanlin nani. ");
INSERT INTO amo_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Na Iwa min umon imonimon ba, yinan nin linuana. Ulẹ na ayina nin na lisosin kopome akulo uduka. ");
INSERT INTO amo_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Inna woro, “Na iwa nozo nan nawani nanit ba. Na uwa molu unit ba. Na uwa su likiri ba. Na uwa suu ivira ba. “tutun andi imon uduka duku, vat umala nan nyanlẹ ulirẹ: “uba yinnu nin nan kupo nafo litife.” ");
INSERT INTO amo_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Na uyinnu nya uta ulanza unan kupofe ukul ba. Bara nani, uyinnu nso likulun indukari. ");
INSERT INTO amo_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Bara nani, kubin daduru, kubiko na kogha ma fitu nmoro. Nene utuchu bite nda susut nanghrik ukati. kubi kone na tiwa burun serun nlirẹ. ");
INSERT INTO amo_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Kitik ndo piit, kiti nan na shanta. Bara nani na tifilin imon nsirti, tishon imon likum nkanang. ");
INSERT INTO amo_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Na ti chinu dert, nafo nin lirin, na in nan nya nkpehirzunu sa usọ nadadu ahemhem, na nin halin zina sa nan nya kunanizi kunanza, nin kubun kunanza sa inshina. ");
INSERT INTO amo_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Bara nani tan Chikilari Yisa Kristi, na iwa pun kuna niyizi nadadu kidowo ba. ");
INSERT INTO amo_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Serre ule na uyinu sa uyenume dinin likara kitime ba nene na uwa su usharia kitine matiru tiru ba. ");
INSERT INTO amo_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Nlong likok umon din din manlikara kibinai nworo awanya alleu kome imon nlong likok tutun, unan ndiru likara nibinai ma lie titene cha. ");
INSERT INTO amo_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Na we na adin lii imon vat na awa yenje nfai inlle na adin lii ba tutun ule na adinlii adadu vat ba na awasu anan nlii vate usharia b, bqra Kutellẹ na saru ghe. ");
INSERT INTO amo_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Fee nghari fwe na su kuchin umon ushariya msun nchikilarari sa yinsiku sa adeu amma tighe a yisinu bara Kutellẹ ba tigheayinsin. ");
INSERT INTO amo_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Nlong likot umon nyiira nlonliri katin nlong nonlikot umon nyira ayiri vat arummere na koghasu uyinu nin kibinai me. ");
INSERT INTO amo_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Ulle na ayinna nin nlonliri ayinanmu bara Kutellẹ ar, ulle na alewo imonli vat Kutellẹ imonli vat bara Kutellẹ na anari aleo anari nlii bara chikilari asa duro Kutellẹ libulibo. ");
INSERT INTO amo_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Van ghirike na umon nsosin bara litime batutun na umon din nku bara litime ba. ");
INSERT INTO amo_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Assa tidin lai bara chikilari. Andi tiku tidin nkuzu bara chikilarlari. sa ulai sa ukul arik anit Nchikilariari. ");
INSERT INTO amo_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Bara ule imonere Kristi wa ku, afita tutun anaso Chikilari nan nkul nin na. nanla. ");
INSERT INTO amo_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","fe iyanghari ta udin nsharatu gwanafine? afe yangharin ta udin yenj headline fai? vat bite tibayisuni nbun kukii ishara Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Nafo na ina nyertu “bara na in dinin lai”. ubellu Kutellẹ,”kitinighe kolome lilung ba tumun, kolome ililem basu liru Kutellẹ “. ");
INSERT INTO amo_vpl VALUES ("RM14_12","075_14_12","ROM","14","12","12","Bara nani kogha nan nya bita bani kibatiza nadadu me ubun Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("RM14_13","075_14_13","ROM","14","13","13","Nene na tiwa lawa insu nati ushara ba, na tiworo n, na umong wa chio gwana litala intiru sa barda gwane. ");
INSERT INTO amo_vpl VALUES ("RM14_14","075_14_14","ROM","14","14","14","Bar iyiru chikilari Yisa na risi, na imomon nani litimeb, sai ulle na ayiri nin nani, kitime nanin. ");
INSERT INTO amo_vpl VALUES ("RM14_15","075_14_15","ROM","14","15","15","andi bara imonlife ayin gwana nan, na udin chinu nan nya su tutun na uwanaza kibanai le na Kristi na ku bara ame ninnimonlib. ");
INSERT INTO amo_vpl VALUES ("RM14_16","075_14_16","ROM","14","16","16","Na uwa yinin kata kachine fe ka so umon imon liyakkiti ba. ");
INSERT INTO amo_vpl VALUES ("RM14_17","075_14_17","ROM","14","17","17","Na ubellen nimonli nin nimon nso unere di kila. tigoKutellẹ b, ama ubelen sali kulap, lissosin lita, nin liburilibo nan nya Ifip Nnu Kutell. ");
INSERT INTO amo_vpl VALUES ("RM14_18","075_14_18","ROM","14","18","18","Ullena din su chikilari bite kata nan nya kamin ame se useru kiti Kutellẹ ninyinu nanit. ");
INSERT INTO amo_vpl VALUES ("RM14_19","075_14_19","ROM","14","19","19","Nane re dantidofin imon ile na iba ti tiso tap nin nimong ele ibatari ti yissi. ");
INSERT INTO amo_vpl VALUES ("RM14_20","075_14_20","ROM","14","20","20","Yenghe iwa nan kata Kutellẹ bara imonli. Imone vat di la, tutun unanin kitin ille na adin li umon ile na idin tizu tirzu. ");
INSERT INTO amo_vpl VALUES ("RM14_21","075_14_21","ROM","14","21","21","Uchaun na uwa lii inawa, sa ti sọ intoro ba sa ilemon na iba ti gwafine di. ");
INSERT INTO amo_vpl VALUES ("RM14_22","075_14_22","ROM","14","22","22","Alle al'adue na udumon mino anin kitife nin Kuttellẹ. Unan nmariari ulle na ayira litime nan nya ni le mon na iyinamuba. ");
INSERT INTO amo_vpl VALUES ("RM14_23","075_14_23","ROM","14","23","23","Ulena aleu sauyinnu nin litime adincha ukul bara na udi uyinnu sa uyenu b, vat ilemon na inuzu kiti yinu sa uyenu ba kulapiari. ");
INSERT INTO amo_vpl VALUES ("RM15_1","075_15_1","ROM","15","1","1","Nene arik alẹ na ti dinin nakara ti tizu ayi asheu nin na lẹ n. .. kayiri, ana tiwa ni atibite ulanzun nmang ba. ");
INSERT INTO amo_vpl VALUES ("RM15_2","075_15_2","ROM","15","2","2","Na ko uyemẹ bite poa unan kupome liburi nan nya nimon ile na idi ichine, unan taghe akuno. ");
INSERT INTO amo_vpl VALUES ("RM15_3","075_15_3","ROM","15","3","3","Bara amẹ Kirsti wang na awani litime ulanzu nmang ba: unin so nafo na ina yertin.'' Tizogo na le na iwa zoguzo minu na diyu litining''. ");
INSERT INTO amo_vpl VALUES ("RM15_4","075_15_4","ROM","15","4","4","Bara vat nimon irika na iwa yertu, iwa yertu inin bara udursuzu kiti bitari, nworu nan nya ikune kunebit tinan se likara nibinayi nin liru Kutellẹ tinanse uyinnu mun ");
INSERT INTO amo_vpl VALUES ("RM15_5","075_15_5","ROM","15","5","5","Nene imoneti Kutellẹ Kibinayi kisheu nin likara kibinayẹ yinin minu use nibinayi nirumẹ vat nafo usun Kirsti Yisa, ");
INSERT INTO amo_vpl VALUES ("RM15_6","075_15_6","ROM","15","6","6","bara inan so minu vat mine nin kibinayi kirum inan su liru Kutellẹ uchifin Chikilari bit Yisa Kirsti nin liwoi lirum. ");
INSERT INTO amo_vpl VALUES ("RM15_7","075_15_7","ROM","15","7","7","Uso nani yinnan nin natiminẹ, nafo namẹ Kirsti naserumunu nan nya liru Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("RM15_8","075_15_8","ROM","15","8","8","Meng woro inati Yisa ku aso ku, hin na lẹ na ina bassuni ijah inyisunu kidegen Kutellẹ, bara anan kulo likawali iwani achifmine, ");
INSERT INTO amo_vpl VALUES ("RM15_9","075_15_9","ROM","15","9","9","bara awurmi nan su liru Kutellẹ bai insheu mẹ. Imone di nafo na ina yerti, ''Meng masu lirufe nan nya Nawurmi inkuru in inti avu liru lisafe'' ");
INSERT INTO amo_vpl VALUES ("RM15_10","075_15_10","ROM","15","10","10","Tutun iworo, '' sun liburi libo, anung Awurmi, ligowe nan na nit mẹ.'' ");
INSERT INTO amo_vpl VALUES ("RM15_11","075_15_11","ROM","15","11","11","Nene tutun, '' sun liru Chikilarẹ, vat mine Awurmi: na anit vat suliru mẹ.'' ");
INSERT INTO amo_vpl VALUES ("RM15_12","075_15_12","ROM","15","12","12","Tutun Ishaya na bellin, '' Litinọ Jesse ma yituku, ameh na amafitu asu tigo kitene na Wurmi amere Awurmi ma yinnu ninghe.'' ");
INSERT INTO amo_vpl VALUES ("RM15_13","075_15_13","ROM","15","13","13","Na Kutellẹ likara nibinayi kulo minu nin nayi abo Lisosin limang bara uyinnu, inan kuno nan nya nagang nibinayi, nin likara Infip mi Lau. ");
INSERT INTO amo_vpl VALUES ("RM15_14","075_15_14","ROM","15","14","14","Meng litinighe nkuru inyinna bara anughe, nanani, bara tutun anighe atimine ise ukulu nan nya inchine, ikulọnin yiru vat, tutun ise ughantinu nati. ");
INSERT INTO amo_vpl VALUES ("RM15_15","075_15_15","ROM","15","15","15","Idimunu niyerti ilelẹ nan nya likara kibinayi nimon imon gbardan kitimine na ayidi inlizin munu tutun, bara ufillu indadiu nighe kiti Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("RM15_16","075_15_16","ROM","15","16","16","Inan so kuchin Kirsti Yisa ulẹ na inatu udu kiti Nawurmi, inakpai nafo unan katwa kalau nlirun tuchu Kutellẹ, bara imon infillu Nawurmi se useru, inin so imon nkusu na Infip mi Lauwẹ masu katwamun. ");
INSERT INTO amo_vpl VALUES ("RM15_17","075_15_17","ROM","15","17","17","Ufofigiri nighe nso nin Kirsti Yisa kusari vat nimon ilẹ na idi in Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("RM15_18","075_15_18","ROM","15","18","18","Bara na wasa in belle ko imon irum ba andi na ilẹ na Kirsti na kulo nan nya nin bara uyinnu nibinayi Nawurmi, nan nya iliru nighe nin kata kidowo nighe. ");
INSERT INTO amo_vpl VALUES ("RM15_19","075_15_19","ROM","15","19","19","nin likara nalamu a imon ilẹ na ikatin likara inyinnu nit usirne, nin likaran Infip mi Lau, inan se uyirun Urshalima, inin kilin vat udu Illyricum, ise indo ni lirun kirsti ku vat. ");
INSERT INTO amo_vpl VALUES ("RM15_20","075_15_20","ROM","15","20","20","Nan nya nani, usu kibinayi nighe di ibellu anit uliru Kutellẹ, na niti nanga na iyiru Kirsti ku nin Lisameba, bara uwa tinu kata kitika na umon mal chizunu useuku. ");
INSERT INTO amo_vpl VALUES ("RM15_21","075_15_21","ROM","15","21","21","Udi nafo nan nya niyertẹ, ''Alẹ na uliru umang me nsa diru niti mineba nan yeneghe, ale na isa lanzaba yinni.'' ");
INSERT INTO amo_vpl VALUES ("RM15_22","075_15_22","ROM","15","22","22","Abi gbardang ina quantizing udak kitiminẹ. ");
INSERT INTO amo_vpl VALUES ("RM15_23","075_15_23","ROM","15","23","23","Nene tutun na nkuru ndumun kiti kusari kone ba, tutun inin dimun kibinayi nwo indak kitimine nya nakus alelẹ na akatẹ. ");
INSERT INTO amo_vpl VALUES ("RM15_24","075_15_24","ROM","15","24","24","To nene vat kubiko na ndo Spain, imayitu nin su inyenefi andi in din katu, ukuru utuyi libauni, andi inma kpillu na iyita inmal ");
INSERT INTO amo_vpl VALUES ("RM15_25","075_15_25","ROM","15","25","25","lanzu nmang lisosin ninfi kokube bàt. Nene in ma du u Urshalima indi su anit anan nibinayi ni lau kata. ");
INSERT INTO amo_vpl VALUES ("RM15_26","075_15_26","ROM","15","26","26","Bara imon ichine ari wa di anan Macedoniya nin Achaiya inun su anan indiru kayiri nan nya na nit alau mine alẹ na idin nya Urshalima imon inbunu. ");
INSERT INTO amo_vpl VALUES ("RM15_27","075_15_27","ROM","15","27","27","Eh, uwa dinani imon ichine nibinayi, tutun nanere iwadi anan dortu inremine. Bara andi Awurme wa kosu imon ilau mine, to iwa dortu nani ure in woru ikosu imon inyii ligowẹ. ");
INSERT INTO amo_vpl VALUES ("RM15_28","075_15_28","ROM","15","28","28","Asa Kutellẹ nbuni insu kata kane gegeme, uliru nlai ulelẹ nduru kitimine, nma dak kitife in Spain. ");
INSERT INTO amo_vpl VALUES ("RM15_29","075_15_29","ROM","15","29","29","Inyiru nenge asa in da kitife inma dak nan nya nkulu nmarin Kirsti. ");
INSERT INTO amo_vpl VALUES ("RM15_30","075_15_30","ROM","15","30","30","indi ni 'unu shawara linana, nan nya lisa in Chikilari bite Yisa Kirsti, nin su kibinayi Nfip Kutellẹ, bara ibuni likum nan nya inlira kiti Kutellẹ bara mewe. ");
INSERT INTO amo_vpl VALUES ("RM15_31","075_15_31","ROM","15","31","31","Sun ilelẹ meng nan se utuchu kiti na lẹ na inari ulanzun inlirẹ in Yahudiya inan se tutun kata nighe in Urshalima nan se useru kiti nannan fiu Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("RM15_32","075_15_32","ROM","15","32","32","Bara in nan da kitimine nan nya nayi abo libo Kutellẹ, nani tutun meng nan ghinu tise ushinu ");
INSERT INTO amo_vpl VALUES ("RM15_33","075_15_33","ROM","15","33","33","Na Kutellẹ lisosin limang yita nan ghinu vat. Usonani. ");
INSERT INTO amo_vpl VALUES ("RM16_1","075_16_1","ROM","16","1","1","Meng munu Fibiku bite, unan kata kilari inlira na udi Kankirya ");
INSERT INTO amo_vpl VALUES ("RM16_2","075_16_2","ROM","16","2","2","bara inan sere ghe nan nya lisa inchikilari, nan nya libau na li di dert nin nan fiu Kutellẹ, tutun uyisin kimalme nya ko iyeme imon ile na ama pizurufi. Bara ame ma na buzu. anit gbardang, umunu menkuwang. ");
INSERT INTO amo_vpl VALUES ("RM16_3","075_16_3","ROM","16","3","3","Lissoni Biriska ku ni Akila, adon katani kitin Kirsti Yisa. ");
INSERT INTO amo_vpl VALUES ("RM16_4","075_16_4","ROM","16","4","4","ale na bari ulai ning, iwa nitilai mine. Ndi godo mine, na meng chasba, ligowẹ nan vat nilarin nlira na Wurmi. ");
INSERT INTO amo_vpl VALUES ("RM16_5","075_16_5","ROM","16","5","5","Lisso kilarin nlira ka na kidin ingamine. Lisoi Abanitus unan lanzu nmang kibinayi nin, kumat kun chizununin kataninin Asiya kitin Kirsti. ");
INSERT INTO amo_vpl VALUES ("RM16_6","075_16_6","ROM","16","6","6","Lissoi Maryamu ku urika na awasu kata kang bara fewe. ");
INSERT INTO amo_vpl VALUES ("RM16_7","075_16_7","ROM","16","7","7","Lissoni Andarinukus nin Yuniyus, likura nin, a ado lichin nin, alẹ na inadi nin liyisin kan nan nya nan kadure, alẹ na iwa di nan nya Kirsti ameng dutu sa udak. ");
INSERT INTO amo_vpl VALUES ("RM16_8","075_16_8","ROM","16","8","8","Lissonni Ambiliyatus ku, unan lanzun nmang kibinayi nin nya kiti Chikilari bite. ");
INSERT INTO amo_vpl VALUES ("RM16_9","075_16_9","ROM","16","9","9","Lissonni Urbanus ku, udo kata bite kitin Kirsti, a Istakis unan lanzun nmang kibinayi ning. ");
INSERT INTO amo_vpl VALUES ("RM16_10","075_16_10","ROM","16","10","10","Lissonni Abalis ku, ulẹ na iwa yinni ninghe bara Kirsti. Lissonni vat alẹ na ina dak in gan Aristobulus. ");
INSERT INTO amo_vpl VALUES ("RM16_11","075_16_11","ROM","16","11","11","Lissonni Harodiyyuna ku, likura ning. Lissonni vat nalẹ na inadak in gan Narkissus ku, alẹ na idi nya Chikilari bite. ");
INSERT INTO amo_vpl VALUES ("RM16_12","075_16_12","ROM","16","12","12","Lissonni Tarifana nin Tarifasa ku, alẹ nainasu kata kang bara Chikilari bite. Lissonni Barsisa ku ulẹ na kibinayi nin din lanzun nmangme, urika na anasu kata kan nya Chikilari. ");
INSERT INTO amo_vpl VALUES ("RM16_13","075_16_13","ROM","16","13","13","Lissoni Rifus ku, ulẹ na iwa fereghe bara kata in Chikilari, uname nin mi wang. ");
INSERT INTO amo_vpl VALUES ("RM16_14","075_16_14","ROM","16","14","14","Lissonni Asinkaritus ku, a Filiguna ku, a Harmasa ku, nin gisin linanẹ na idi ligowe na ghinu. ");
INSERT INTO amo_vpl VALUES ("RM16_15","075_16_15","ROM","16","15","15","Lissonni Filulugusa ku, nin Juliya, Niriyus gwana kishonome, nin Ulumbasa a vat nanit alau alẹ na idi ligowe nan ghinẹ. ");
INSERT INTO amo_vpl VALUES ("RM16_16","075_16_16","ROM","16","16","16","Lisizon atime nin sumba ulau vat nilarin nlira in Kirsti din lisu minu. ");
INSERT INTO amo_vpl VALUES ("RM16_17","075_16_17","ROM","16","17","17","Indin fo minu nachara linuan, sun sen nin nalẹ na idin tiziminu in sartizu nin tirzu, alẹ na uchinmine din ugang nin nkwayaswa ulẹ na ina se, kpilan atimine kitimine. ");
INSERT INTO amo_vpl VALUES ("RM16_18","075_16_18","ROM","16","18","18","Bara anit nafo alele na ina su Chikilari Kirsti ku kata ba, inun wa su aburi minere iwasu kata bari anin. Bara nmang kinu tinumine, iwa rusuzu nibinayi na nanna sali nalapi. ");
INSERT INTO amo_vpl VALUES ("RM16_19","075_16_19","ROM","16","19","19","Bara uchau kibinayi fe nin dortun inliru Kutellẹ fe na so imon yenju vat. Indinin nayi abo kitenefe tutun indi nin su uyita jijin nan nya vat nimon ichine yita nin nachara alau nan nya nimon inangza. ");
INSERT INTO amo_vpl VALUES ("RM16_20","075_16_20","ROM","16","20","20","Kutellẹ kutap na nin molu kubi ba majazilinu Shaitan ku nya nabunu mine. Na ubollu kiti in Chikilari bite Yisa Kirsti so nan ghinu. ");
INSERT INTO amo_vpl VALUES ("RM16_21","075_16_21","ROM","16","21","21","Timithawus udon kata ning, din lissu minu, a Lukiyus, nin Yasuna a Sasibatrus tutung, likura ning. ");
INSERT INTO amo_vpl VALUES ("RM16_22","075_16_22","ROM","16","22","22","Meng, Tartiyus, unan nilẹ iyertẹ, ndin lissu minu nan nya lisan Chikilari. ");
INSERT INTO amo_vpl VALUES ("RM16_23","075_16_23","ROM","16","23","23","Gayus, unan kuti namara nin kilari nlira vat din lissu minu. Urastus unan chisu nimon klpin, din lissu minu, nin Kawartus gwana ning. ");
INSERT INTO amo_vpl VALUES ("RM16_24","075_16_24","ROM","16","24","24","Na ubollu Kutellẹ in Yisa Kirsti so ligowe nan ghinu. ");
INSERT INTO amo_vpl VALUES ("RM16_25","075_16_25","ROM","16","25","25","Nene ame ule na ma timinu iyisin nin likara nan nya inlirunnighe inbellẹbin tuchun Yisa Kirsti, unin nya dert nin nilẹ imon na iwa nyeshe uworsu. ");
INSERT INTO amo_vpl VALUES ("RM16_26","075_16_26","ROM","16","26","26","uni nene n nuzu ikuru belle tilem tilem vat in nan nya naffa niyerti, nafo ubellun Kutellẹn da diu, bar unonku liti inyinnu sa uyenu kiti nannan tanni Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("RM16_27","075_16_27","ROM","16","27","27","Udu kiti Kutelle chas unan yiru nimon, nan nya Yisa Kirsti, so nzazunu sa ligang. Usonani. ");
INSERT INTO amo_vpl VALUES ("C11_1","076_1_1","1CO","1","1","1","Meng Bulus, uyiculun Kristi Yisa nso unan kadura bara uyinnu Kutellẹ, a Sostanisu gwana bit, ");
INSERT INTO amo_vpl VALUES ("C11_2","076_1_2","1CO","1","2","2","udu kiti na nan tortu Kutellẹ na idi in Korintus, alenge na Kristi Yisa nati nani iso lan, iwa yiwa nani iso anit alau, vat nan na lenge na idin yicu lissan Cikilari bite Yisa Kristi in ko kame kiti, Cikilari mine nini unbit. ");
INSERT INTO amo_vpl VALUES ("C11_3","076_1_3","1CO","1","3","3","Na ubolu me nin lissosin lisheu unuzu kitiin Kutellẹ ucif bit a Cikilari Yisa Kristi. ");
INSERT INTO amo_vpl VALUES ("C11_4","076_1_4","1CO","1","4","4","Ndin godu Kutelle ning ko kome kubi bara anughe, nan nyan bolu Kutellẹ na Kristi Yisa nani minu. ");
INSERT INTO amo_vpl VALUES ("C11_5","076_1_5","1CO","1","5","5","Ana tti minu anan se nan nya ko lome libau, nan nya nliru nin yiru vat. ");
INSERT INTO amo_vpl VALUES ("C11_6","076_1_6","1CO","1","6","6","Ana ti minu ita imon nacara, nafo na ubellee nimon liburu libo litin Kristi, na nuzu kanang nan nya mine. ");
INSERT INTO amo_vpl VALUES ("C11_7","076_1_7","1CO","1","7","7","Bara nani na idiira ufilllu nruhuba, naffo na ina yita nin tok ncaa nnuzu kanang in Cikilari bite Yisa Kristi. ");
INSERT INTO amo_vpl VALUES ("C11_8","076_1_8","1CO","1","8","8","Ame ni minu akara tutung udi duri imaline, bara inan so sa alapi lirin Cikilari bite Yisa Kristi. ");
INSERT INTO amo_vpl VALUES ("C11_9","076_1_9","1CO","1","9","9","Kutellẹ di nin yinnu, ame ulenge na ana yicila minu nan nya lissosin ligo nin saunne, Yisa Kristi Cikilari bite. ");
INSERT INTO amo_vpl VALUES ("C11_10","076_1_10","1CO","1","10","10","Nene ndi munu kucukusu, nuana nilime nan nishono, nan nya lissan Cikilari bite Yisa Kristi, na vat mine na yinin, na i wa se uwucu nati nati nan nya mine ba. Ndi kucukusu imunu ati umalizinu kugir kun lo ligowe nin kibinai kirum a udalili urim. ");
INSERT INTO amo_vpl VALUES ("C11_11","076_1_11","1CO","1","11","11","Nani anan gan kuluwi na da tyi vet natuf nbeleng nworu uwutuzunu din piun nan nya mine. ");
INSERT INTO amo_vpl VALUES ("C11_12","076_1_12","1CO","1","12","12","Nene uliru niighe ule: Ko gha mine din su, “Mengg un Bulus ari,” “Meng un Apolos” “Meng un Kefas,” sa, “Mengg un Kristi.” ");
INSERT INTO amo_vpl VALUES ("C11_13","076_1_13","1CO","1","13","13","Kristẹ nkoso kidowa? iwa kotun Bulus ku kuca bara anughe? Iwa shintin munu nmyen nan nya lissan Bulussa? ");
INSERT INTO amo_vpl VALUES ("C11_14","076_1_14","1CO","1","14","14","Ndi nin liburi libo kiti Kutellẹ na nna shintin umon mine nmyen ba, se kiribun nin Gayus. ");
INSERT INTO amo_vpl VALUES ("C11_15","076_1_15","1CO","1","15","15","Una so nani bara na umong mine man woru miyari na shintin ghe nmyen nan nya lissa ning ba. ");
INSERT INTO amo_vpl VALUES ("C11_16","076_1_16","1CO","1","16","16","Ina kuru nshintino anan gan Istifanus ku. Nbanda nani, nan yiru sa nnakuru nshinto among tutung ba. ");
INSERT INTO amo_vpl VALUES ("C11_17","076_1_17","1CO","1","17","17","Bara ana Kristi na tuyi nshitu anitari nmyen ba nani nsu uwazi nliru ntucuari na nin nagbulan njinjin nnit ba, bara kuca nkootunu in Kristi wa so imon ihe. ");
INSERT INTO amo_vpl VALUES ("C11_18","076_1_18","1CO","1","18","18","Bara kadura kuca nkotunuee tilalanghari kiti na lenge na i din nan nya nkul. Nani kitii na lenge na Kutellẹ din kacisso mine, likara Kutellẹ ari. ");
INSERT INTO amo_vpl VALUES ("C11_19","076_1_19","1CO","1","19","19","Bara ina nyertin, “Meng ma malu kiti nin dadiu na yinjini” mma canu uyinnu na nan yiru. ");
INSERT INTO amo_vpl VALUES ("C11_20","076_1_20","1CO","1","20","20","Unit ujinjinghe din weri? Unan ni nyerte din we? Unan piziru in yinnu nko kuje din we? Na Kutellẹ na kpilya njinjin in yeh misoo tilalang ba? ");
INSERT INTO amo_vpl VALUES ("C11_21","076_1_21","1CO","1","21","21","Bara na uyih vat nin jinjing nnin na una yinnin Kutellẹ ba, una poah Kutellẹ liburi nan nya tilalan nbellu nliru Kutelle kiti na lenge na iyinna. ");
INSERT INTO amo_vpl VALUES ("C11_22","076_1_22","1CO","1","22","22","A Yahudawa wa piziru imon al'ajibi a Hilinawa pizira njinjing. ");
INSERT INTO amo_vpl VALUES ("C11_23","076_1_23","1CO","1","23","23","Nani arik din uwazi nkotunu in Kristi, litala ntizuru na Yahudawa a tilalang kiti na Hilinawa. ");
INSERT INTO amo_vpl VALUES ("C11_24","076_1_24","1CO","1","24","24","Kiti na lenge na Kutellẹ na yicila, a Yahudawa nin na Hilinawa, ti din su uwazi in Kristi nafo Likara nin kujinjin Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("C11_25","076_1_25","1CO","1","25","25","Bara tilalang Kutellẹ katin likara njinjing nanit, a usali likara Kutellẹ katina akara nanit. ");
INSERT INTO amo_vpl VALUES ("C11_26","076_1_26","1CO","1","26","26","Yenen imusun in yicilue na Kutellẹ na yicila munu mun, nuana nilime nin nishono. Na gbardan mine wa di jinjing ba nan nya yenjun nanit. Na gbardang mine wadi nin gongong mbun nanit ba. ");
INSERT INTO amo_vpl VALUES ("C11_27","076_1_27","1CO","1","27","27","Nani Kutellẹ wa fere imon ilalang in yih ani unit ujinjing ncin. Kutellẹ waa fere imon nsali nakara in yih ani imon nakara in yih ncin mun. ");
INSERT INTO amo_vpl VALUES ("C11_28","076_1_28","1CO","1","28","28","Kutellẹ wa fere imon igugur na ina filing in yih umunu imon ile na tiyira inin nafo imon ile na arik in yira imon icinari. ");
INSERT INTO amo_vpl VALUES ("C11_29","076_1_29","1CO","1","29","29","Ana su nani bara ummong wa se imon for figiri mbun me. ");
INSERT INTO amo_vpl VALUES ("C11_30","076_1_30","1CO","1","30","30","Bara imon ile na Kutellẹ na su, nene i di nan nyan Kristi Yisa, Ulenge na ana so nari njinjing kiti Kutellẹ katwa kacine bite, nlau bite nin utucu bite. ");
INSERT INTO amo_vpl VALUES ("C11_31","076_1_31","1CO","1","31","31","Nafo, na i nyerte nabelin, “Na ulenge na ana fo figiri na a fo nan nyan Cikilari.” ");
INSERT INTO amo_vpl VALUES ("C12_1","076_2_1","1CO","2","1","1","Meng wang, nuanna nilime nan nishon kubi na nwa dak kitimine, na nwa dak nin umon inyiru un litining isa njinjing ninghari ba nwa su munu uliru nimon Kutellẹ ilenge na i nyeshin ba. ");
INSERT INTO amo_vpl VALUES ("C12_2","076_2_2","1CO","2","2","2","Nna yyiru na kibinai ning na mma yinnu imonmong kube na nwa di nan nya mine ba, se dei Yisa Kristi cas, na amere i na kotum kuca. ");
INSERT INTO amo_vpl VALUES ("C12_3","076_2_3","1CO","2","3","3","Tutung nwa di nanghinu nan nya lidarni, nin fiu a nan nya nkitizu. ");
INSERT INTO amo_vpl VALUES ("C12_4","076_2_4","1CO","2","4","4","Uliru nighe nin wazi nighe na nwa su nin nagbulang nrissu kujinjing ba, nani nin dursuzu nimon in yenju nin Ruhu a likara, ");
INSERT INTO amo_vpl VALUES ("C12_5","076_2_5","1CO","2","5","5","bara uyinnu sa nyenu fe wa so nan nya kujinjin nanit, nani nsn nys liksrs Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("C12_6","076_2_6","1CO","2","6","6","Nene asa ti lira nin kujinjin nan nya na wasara, na njinjing nle uyeh ba, sa njinjing nago nko kuje ba, alenge na kubi mine din katuzu. ");
INSERT INTO amo_vpl VALUES ("C12_7","076_2_7","1CO","2","7","7","Nan nya nani ti di bellu njinjing Kutellẹ nan nya kidegen linyeshin njinjing mo na mi wa nyeshin uworsu, mongo na Kutellẹ wa da ceo uworsu ana kuji bite nsa da ba bar ngongong bite. ");
INSERT INTO amo_vpl VALUES ("C12_8","076_2_8","1CO","2","8","8","Na umong nago nko kuje yiru ninn mo njinjing ghe ba, bara andi ina yinin minin nkoni kube, na i wana kotun Cikilarii ugongong ba. ");
INSERT INTO amo_vpl VALUES ("C12_9","076_2_9","1CO","2","9","9","Nafo na ina nyertin, “Imon ilenge na iyizi nsa yene ba, na kutuf nsa lanza ba, na nkan kibinai nsa kipiliza ba, imon ilenge na Kutellẹ na ke bara alenge na idi nin su me.” ");
INSERT INTO amo_vpl VALUES ("C12_10","076_2_10","1CO","2","10","10","Ilenge imonere Kutellẹ na puun nari inin nan nyan Ruhu, bara Uruhu din piziru imon vat, umunu imon iconcom Kutellẹ wang. ");
INSERT INTO amo_vpl VALUES ("C12_11","076_2_11","1CO","2","11","11","Ghari yiru ukpilizu kibinai nmong se dei uruhun nlenge na adi nan nya me? Nanere wang, na umon yiru imon iconcom Kutellẹ ba se dei Uruhu Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("C12_12","076_2_12","1CO","2","12","12","Nani na arike na seru Uruhu in yih ba, fina na seru Uruhu ule na una nuzu kiti Kutelle, arike nan se ti yinno imon ile na ina ni nari unuzu kiti Kutellẹ sheu. ");
INSERT INTO amo_vpl VALUES ("C12_13","076_2_13","1CO","2","13","13","Ti din su uliru kitene nimon nin nagbbwang alenge na njinjing nnit wasa a dursuzu nari. Uruhue din kpilizu agbulang nruhu nin jinjing nruhu. ");
INSERT INTO amo_vpl VALUES ("C12_14","076_2_14","1CO","2","14","14","Na unan salin nruhu wasa a sere imon ile na idi Nruhu Kutellẹ ba, bara ileli imone nlalanghari kitime. Na awa sa a yinno inin ba bara ina dumun inin nin Ruhu. ");
INSERT INTO amo_vpl VALUES ("C12_15","076_2_15","1CO","2","15","15","Ulenge na adi nin ruhu wasa a wuco imon vat, ana imong wasa a wuco imon me ba. ");
INSERT INTO amo_vpl VALUES ("C12_16","076_2_16","1CO","2","16","16","“Nani ghari wasa ayinno kibinai nCikilare, na ama dursuzu ghe?” Vat nani ti din kibinai nKristi. ");
INSERT INTO amo_vpl VALUES ("C13_1","076_3_1","1CO","3","1","1","Meng wang linuana, na nna yinin nsu minu uliru nafo anan ruhu ba, nan nya nani nafo anit na nidowo, nafo nono nibebene nan nyan Kristi. ");
INSERT INTO amo_vpl VALUES ("C13_2","076_3_2","1CO","3","2","2","Ina niza minu mmadrari na inawa ba, bara na iwa di isa duru uli ni nawa ba. Nene wang na isa duru ule ba. ");
INSERT INTO amo_vpl VALUES ("C13_3","076_3_3","1CO","3","3","3","Nene idu nan nya nidowo. Bara kikanga na liyarin nin fyeu nayi diku nan nya mine, na i sosin nan nya nidowo ba, tutung na idin cine nafo usu na nit ba? ");
INSERT INTO amo_vpl VALUES ("C13_4","076_3_4","1CO","3","4","4","Bara asa umong nworo, “Ndin dortu Bulus ku,” umon tutung woro, “Meng din dortu Apolos ku,” na issosin nafo anit asurne ba? ");
INSERT INTO amo_vpl VALUES ("C13_5","076_3_5","1CO","3","5","5","Ame Apolos ghari? A ghari Bulus? Acinari bara inughere ina yinnin, kitin ko uyeme unit Kutellẹ nani imon su. ");
INSERT INTO amo_vpl VALUES ("C13_6","076_3_6","1CO","3","6","6","Meng wa bilisu, Apolos tizza nmyen ku, nan nya nani Kutelleari nati inin tikunan. ");
INSERT INTO amo_vpl VALUES ("C13_7","076_3_7","1CO","3","7","7","Nanere, unan tibila nin nnan tizzu nmyen na imonmonari ba. Nan nya nani unan tibila nin nan tizzin. ");
INSERT INTO amo_vpl VALUES ("C13_8","076_3_8","1CO","3","8","8","Nene ame unan tibila nin nan tizzin nmyen unit urumere, nani ko gha mine ma seru uduk me dedei nin gegeme katwa me. ");
INSERT INTO amo_vpl VALUES ("C13_9","076_3_9","1CO","3","9","9","Bara arik adon katwa Kutellẹari. Ulambu Kutellẹari, Makeke Kutellẹari. ");
INSERT INTO amo_vpl VALUES ("C13_10","076_3_10","1CO","3","10","10","Nafo na ubdu Kutellẹ na iwa nei nafo Cikilari makeke, Meng wa tuno kutyie umong da tunna nkewe, Nan nya nani na ko uyeme unit su seng yanda na ama li ubun nin kewe. ");
INSERT INTO amo_vpl VALUES ("C13_11","076_3_11","1CO","3","11","11","Bara na ina malu u tunu amere Yisa Kristi. ");
INSERT INTO amo_vpl VALUES ("C13_12","076_3_12","1CO","3","12","12","Nene asa umong nke kitene litinoe nin nizinariya, anzurfa, atala acine, akataku, tikpi, sa alut, ");
INSERT INTO amo_vpl VALUES ("C13_13","076_3_13","1CO","3","13","13","ima punu katwa me, bara liyirin ma punu kunin kanang. Bara ima punu nan nya nla. Ulari ma dumunu unutun ngegeme nimon ile na ko uyeme unit nasu. ");
INSERT INTO amo_vpl VALUES ("C13_14","076_3_14","1CO","3","14","14","Vat nimon ile na unit na ke asa i naza ama seru uduk me. ");
INSERT INTO amo_vpl VALUES ("C13_15","076_3_15","1CO","3","15","15","Nani asa katwa mmong nduno, ama niu nin diruu, ame litime ma se utucu, nafo ulenge na ase usurtu in nan nya nla. ");
INSERT INTO amo_vpl VALUES ("C13_16","076_3_16","1CO","3","16","16","Na iyiru anung kutyi nlira Kutellẹarri na Uruhu me sossin nan nya mine ba? ");
INSERT INTO amo_vpl VALUES ("C13_17","076_3_17","1CO","3","17","17","Asa umong nnanzu kutyi nlira Kutellẹ, Kutellẹ ma nanzu unit une. Bara kutyi nlira Kutellẹ di lau, nanere anung wang. ");
INSERT INTO amo_vpl VALUES ("C13_18","076_3_18","1CO","3","18","18","Na umong wa risuzu litime ba. Andi umong din yenju adi jingjing nan nya nko kujie, na aso “ulalang” anan so jinjing. ");
INSERT INTO amo_vpl VALUES ("C13_19","076_3_19","1CO","3","19","19","Bara njinjing in yih ulele tilalanghari kiti Kutellẹ. Bara ina nyertini adin kifizu ajinjinghe nan nya tiwankari mine. ");
INSERT INTO amo_vpl VALUES ("C13_20","076_3_20","1CO","3","20","20","Tutung Cikilarie yiru ukpilizu nnit ujinjinghe udi hem. ");
INSERT INTO amo_vpl VALUES ("C13_21","076_3_21","1CO","3","21","21","Nani na umong nwa fo figiri nin nit ba! Bara imon vat nfyari. ");
INSERT INTO amo_vpl VALUES ("C13_22","076_3_22","1CO","3","22","22","Sa Bulus, Apolos, Kefas, sa uyih. Sa ulai, sa ukul, sa imon ilenge na idi nene, sa Ilenge na idin cinu vat nminare. ");
INSERT INTO amo_vpl VALUES ("C13_23","076_3_23","1CO","3","23","23","Anung tutung anit nKristiari, a Kristi tutung unit Kutellẹari. ");
INSERT INTO amo_vpl VALUES ("C14_1","076_4_1","1CO","4","1","1","Nene na unit yenje ari nafo ne, iba yenju ari a cin Kristi nin na nan katuwa nliru Kutellẹ ulinyeshin. ");
INSERT INTO amo_vpl VALUES ("C14_2","076_4_2","1CO","4","2","2","Vat nene ile imon na idin piziru usẹ unare na iyinin ninghe. ");
INSERT INTO amo_vpl VALUES ("C14_3","076_4_3","1CO","4","3","3","Bara nani kitining imon icing ghari anung su usharia, sa ushariya nanit asurne. Bara meng wang na nsu litinin ushariya ba. ");
INSERT INTO amo_vpl VALUES ("C14_4","076_4_4","1CO","4","4","4","Na meng yiru imomon ile na idin belle litinighe ba, bara nani na uso unan ndiru ba. Chikilari unan su nsharia. ");
INSERT INTO amo_vpl VALUES ("C14_5","076_4_5","1CO","4","5","5","Bara nani na iwabọ usharia kitenne nimomon a kube dutu, na ame Chikilare nsa ba. Aba damun nin nimon ikanang na inyeshin nan nya nsirti, a puun kibinai. Nanere kogha ba seru uru me kiti Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("C14_6","076_4_6","1CO","4","6","6","Nene, nuwana nilime nan nishono, inna su ile imone meg litinighe nin Apollos bara anughe, bara kiti bite anun yinno ile imon na idin bellu, “Na iwa kata ille imon na ina nyertu ba bellin.” Bara nin nani na umon nan nya mine wan ghantin litime kitene nmon ba. ");
INSERT INTO amo_vpl VALUES ("C14_7","076_4_7","1CO","4","7","7","Ghari di yenju umon di ugang kitin na mong? Iyaghari idumun ile na ina filinfiyari ba, andi ina filinferi, iyari udin nfo figiri nafo na usu nane ba? ");
INSERT INTO amo_vpl VALUES ("C14_8","076_4_8","1CO","4","8","8","Una malu use vat nile imon na udin nin suwe! Una mallu use imon nachara! Nenere uma su tigoh, bara tinanse tisu tigowe nanghinu. ");
INSERT INTO amo_vpl VALUES ("C14_9","076_4_9","1CO","4","9","9","Meng ndin nkpilizu Kutellẹ na cheu ari nono kadura nafo anit alle na idin nca nkul. Tiso uyii imon yenju udu nono nanan kadura Kutellẹ nin nanit asurne. ");
INSERT INTO amo_vpl VALUES ("C14_10","076_4_10","1CO","4","10","10","Arik allalag bara Kristi, annug ajinjinghari nanyan Kristi, arik ana nsali nakara, anug anan nakara, ina ghantin anunku, ina toltin arik ku. ");
INSERT INTO amo_vpl VALUES ("C14_11","076_4_11","1CO","4","11","11","Udak ko kube nene tidin kukpong ayin nin kotu nayi mmen sa imon kidowo icine ina fo ari kang na tidumun nilari ba. ");
INSERT INTO amo_vpl VALUES ("C14_12","076_4_12","1CO","4","12","12","Tidinsuu katuwa kaag, katuwe nin nachara bite, iwa yassu ari asa tise mmari, ti kuru tineu assa ti tere nibinai. ");
INSERT INTO amo_vpl VALUES ("C14_13","076_4_13","1CO","4","13","13","Iwa nanza nari lissa, assa tilira nin mang. Har tina so tisso, ina dun yenje ari nafo likinkin nyi nin nimon izemzem vat. ");
INSERT INTO amo_vpl VALUES ("C14_14","076_4_14","1CO","4","14","14","Na ndin nyertu ille imone nti minu iso imon ncin ba bara nkelle munu nafo nono nayi nigh. ");
INSERT INTO amo_vpl VALUES ("C14_15","076_4_15","1CO","4","15","15","Assa idumun nanan ndursuzu minu nimon amui likureri nan nya Kristi, na idumun nacif gbardang ba, bara meng naso ucif mine nan nya Kristi Yisa nan nya liru Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("C14_16","076_4_16","1CO","4","16","16","Bara nani sun nafo menghe. ");
INSERT INTO amo_vpl VALUES ("C14_17","076_4_17","1CO","4","17","17","Unare nati nto minu Timoti ku, kitimine gonni na nya yinnu sa uyenu gono nya Nchikilari, aba lizinmunu tiba nighe nan nya Kristi, nafo na ndin dursuzu nani vat natii Kutellẹ. ");
INSERT INTO amo_vpl VALUES ("C14_18","076_4_18","1CO","4","18","18","Nene among mine dumin nghantinu, insu nafo na mba dak kitimine ba. ");
INSERT INTO amo_vpl VALUES ("C14_19","076_4_19","1CO","4","19","19","Nba dak kitimine nene nin nyinnu Kutellẹ. Kikaneri mba nin yennu ligan nliru na nan nghantinu nati, Vat nani yinnọ akara mine. ");
INSERT INTO amo_vpl VALUES ("C14_20","076_4_20","1CO","4","20","20","Bara na kilari tigoh Kutellẹ na ligan nlirari ba, likara ri. ");
INSERT INTO amo_vpl VALUES ("C14_21","076_4_21","1CO","4","21","21","Iyaghari idumun suwe? Ndak kitimine nin lishonna sa usu nan nya nfip mishau? ");
INSERT INTO amo_vpl VALUES ("C15_1","076_5_1","1CO","5","1","1","Tina nlanza ubellen uworu nenge kulapin zina di nan nya mine, imusu kulapi kọ na iyinna mun nan nya na lumai wang ba. Nafo na ubelle di umon nan nya mine adin nnozu nin nwani ncife. ");
INSERT INTO amo_vpl VALUES ("C15_2","076_5_2","1CO","5","2","2","Anun din nfo figiri! Na iwana di tiyoma ba? Ulle na assu ille imon gbas iba kallughe nanya mine. ");
INSERT INTO amo_vpl VALUES ("C15_3","076_5_3","1CO","5","3","3","Bara nani, nsali ku nan nya kidowo, vat nani nduku nan nya nfip milau, inna malu usu nan su nille imone ushariya nafo uwandi kite. ");
INSERT INTO amo_vpl VALUES ("C15_4","076_5_4","1CO","5","4","4","Assa izurro ligowe nan nya lisan Chikilari bite Yesu, nfip nighe duku nin likara Chikilari bite Yisa-nna mallu usu unit une ushariya. ");
INSERT INTO amo_vpl VALUES ("C15_5","076_5_5","1CO","5","5","5","Nnakpaghe nachara nshitan a mollu kidowo finawa, bara fisudu me nanse utuchu liri ndak in Chikilari. ");
INSERT INTO amo_vpl VALUES ("C15_6","076_5_6","1CO","5","6","6","Ufo figiri mine caun ba. Na anun yiru nwo uyist chingilin asa utah likalang ta fukuku ba? ");
INSERT INTO amo_vpl VALUES ("C15_7","076_5_7","1CO","5","7","7","Wesen atimine kitin nyist ukuse inan nso likalang lipese nene na idi nafo likalan nborodi ubishe. Bara Kristi, kukam ntuchu bite, na iwa gutun mmii me. ");
INSERT INTO amo_vpl VALUES ("C15_8","076_5_8","1CO","5","8","8","Bara nani na tisu ubuki nayi abo, na nin nyist ukuse ba, uyist na udin dasu nin likara linanzang nin magunta, amma nin mborodi nsalin nmucu ucine nin kidegen. ");
INSERT INTO amo_vpl VALUES ("C15_9","076_5_9","1CO","5","9","9","Nna nyertu munu nan nya kuffa niyerte nighe yenje iwa munu ati nin na nan kulapin nzina. ");
INSERT INTO amo_vpl VALUES ("C15_10","076_5_10","1CO","5","10","10","Uwan ma bellin minu nworu na nlon libau duku na linmunu minu nan nanan nzina nanan nsu nimon nyi, nin nanan bolusu nimon, ukudayi, sa akiri, alle nanit, sa anan nchil, ucaun inuzu nan nya nyi. ");
INSERT INTO amo_vpl VALUES ("C15_11","076_5_11","1CO","5","11","11","Nene ndin nyertu munu yenje umon wan munu liit