﻿USE sofia;
DROP TABLE IF EXISTS sofia.amn_n_vpl;
CREATE TABLE amn_n_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES amn_n_vpl WRITE;
INSERT INTO amn_n_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ena moba Sisas God Gishu Wahiag Elni simbianingam suwigig. Ehe Devitna simbianinga afa Devit Abrahamna simbianinga. ");
INSERT INTO amn_n_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahamna leg Aisak. Aisakna leg Jekop. Jekopna leg Juda afa heafna nilite. ");
INSERT INTO amn_n_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judana legnigi Peres i Sera i. Ehenigina afag Tamar. Peresna leg Hesron. Hesronna leg Ram. ");
INSERT INTO amn_n_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ramna leg Aminadap. Aminadapna leg Nason. Nasonna leg Salmon. ");
INSERT INTO amn_n_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmonna leg Boas. Heafna afag Rahap. Boasna leg Obet. Heafna afag Rut. Obetna leg Jesi. ");
INSERT INTO amn_n_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesina leg Devit eba misog el. Devitna leg Solomon. Autunam heafna afag eba Uriana angwag. ");
INSERT INTO amn_n_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomonna leg Rehoboam. Rehoboamna leg Abiya. Abiyana leg Eso. ");
INSERT INTO amn_n_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asana leg Jehosafat. Jehosafatna leg Jehoram. Jehoramna leg Aisaia. ");
INSERT INTO amn_n_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Aisaiana leg Jotam. Jotamna leg Ahas. Ahasna leg Hesekia. ");
INSERT INTO amn_n_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekiana leg Manase. Manasena leg Emon. Emonna leg Josaia. ");
INSERT INTO amn_n_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaiana leg Jekonia afa heafna nilite. Enanam Babilon el Israel elim wanahunam heafgelni bite wa wasani. ");
INSERT INTO amn_n_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Mahim wasanibi Jekoniana leg Sealtiel. Sealtielna leg Serubabel. ");
INSERT INTO amn_n_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabelna leg Abiut. Abiutna leg Eliakim. Eliakimna leg Eso. ");
INSERT INTO amn_n_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Esona leg Sadok. Sadokna leg Akim. Akimna leg Eliut. ");
INSERT INTO amn_n_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliutna leg Elieser. Elieserna leg Matan. Matanna leg Jekop. ");
INSERT INTO amn_n_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekopna leg Josep. Josep Mariana ligag. Afa Maria Sisasim wanigana. Sisasba sefig Krais God Gishu Wahiag El. ");
INSERT INTO amn_n_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Afa Abrahamna simbianinga gohugum ikag Devit nai yi pugug eba 14 wa gohug. Afa Devitna simbianinga agfohianam enanam Babilon Israel elim ambugog wanahuna eba 14 wa gohug. Ena nai yi gofenaba God Gishu Wahiag Elbi gohna eba gwenaig eseg 14. ");
INSERT INTO amn_n_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Sisas Krais, God Gishu Wahiag El, gohug mo enaig eseg ehena afag Maria ati Josepim eso wahini og ma Josepnai yi gai. Afa mas ika gana mo, afa nangunibi Maria Godna Sungwag ati enogni fena. ");
INSERT INTO amn_n_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ehena ligag Josep eba lahlag el. Ehe ogna ehem fagim wahia. Ehe mo ambagwa sihiagim kusina afa so mas Mariam ahwanef mo faina mo. ");
INSERT INTO amn_n_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Josep enam onigkafnaba afa itiwa Godna ofwanai el bona ehem puguna. Enag ofwanai el esona og, “Josep Devitna simbianinga nofeka Mariam fagimba embef. Sa hig enaba enogni wanigiahba el mas enaig eseg mo eba Godna Sungwag ehe faig enag luwalba. ");
INSERT INTO amn_n_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Enaba fagonai luwal wanigaf. Afa ne ehena unehlagimba Sisasim unehlig eso mungwali heafna elni amtakwalig mo hugufatinam afa ehefum wambf eso God ehengelim mas mungo faif.” ");
INSERT INTO amn_n_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Enaba pugunaba Ainiyag ati Godna mo fi sihiule elni mengig wa sihi wahianaba ena moba inim puguna, mo fi sihiule el esona og; ");
INSERT INTO amn_n_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Higim, angwafig mungo angwaming awagwa ga hwainig enogni afa fagonai luwal fokwaf. Afa unehlagba Emanuelim sefif.” Enag mog unehlagba ‘God bigim wanga.’ ");
INSERT INTO amn_n_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josep ginim bihianam eso gwenaig esena Ainiyagna ofwanai el eso sihinagenaba eso ehe enag angwafigbi fana. ");
INSERT INTO amn_n_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Angwafigbi fanam mas mungo kugwa ahgini mo awai isug ahfena afa eso luwal fagona waniganaba. Afa eso ehe Sisasim unehlana. ");
INSERT INTO amn_n_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Maria Sisasim Betlehemwa wanigana, ena provins Judia. Enanam Herot misog el gofnaba. Afa enanam osu pugug wanai anwana el, ambugona Jerusalem wa opukonam. ");
INSERT INTO amn_n_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Afa sahini og, “Ahana nai yi luwalba gohug eba Ju elni misog el? Ehena bagnufut osu puguag wa ka nangugum naso ka ambugog gohug koka ehena unehlagim figifi.” ");
INSERT INTO amn_n_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Misog el Herot ena mom hignam olug fingifena afa Jerusalem wanai el gwenaig esini. ");
INSERT INTO amn_n_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Afa Herot amunai pris mi afa nihe mo anwana el mi unetiginam mahim nuwaganaba eso fasahtigi fenigena og, “Kraisba, God Gishu Wahiag Elbi ahanag kimbig wa gohug?” ");
INSERT INTO amn_n_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Afa sihini og, “Betlehem wa Judianai yi ehe puguf autunam Godna mo fa sihiule el ati ena moba ginofe wahiana, enaig esona og; ");
INSERT INTO amn_n_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Nofeka enaig onigi Betlehem Judanai eba mingnag lahlag Judana kimbig sumifenig. Eso enag kimbig misog el puguf eba ehe Israel, kana elim, nangwahiagef.” ");
INSERT INTO amn_n_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herot enag afwambanai anwana elim efkweg moana fasahtigifiage na og amansi bagnofutni afwambusugbi puguna. ");
INSERT INTO amn_n_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Herot sahinigenam eso Betlehemgam ningitigina og, “Ahunam yisigiahu, nangunim eso kam ambugog sihini. Ka so ikanam mongkokug kwakwagenam ehena unehlam figefuku.” ");
INSERT INTO amn_n_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Afa ehengel ena mom higinim eso ahuna afa bagnofutna afwambusug yuwana eso osu puguiag wa nangunibi enag esena ika sisi gofna enanai yi so luwal gifni. ");
INSERT INTO amn_n_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Afa mahim bagnofutim nangunim eso ehengel hugna sifakalini. ");
INSERT INTO amn_n_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Eso ahu lala saiyegim afa ehena afag Maria enam nangwaginim afa apaigona mongkokug kwakwaginim eso luwalna unehlagim figifukwalina afa wula pigiaginim afa gawig wambinim wambwaini. Gawigba enaba gol i, paura i, sanda i enag wambwaini. ");
INSERT INTO amn_n_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Itiwa God bo sihini og, “Nofe ne piske Herot nangum ahu.” Eso ehengel wahgifini ming minagam heafgelni kimbigamba ahuna. ");
INSERT INTO amn_n_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ainiyagna ofwanai el bona Josepim itiwa sihinagena og, “Pugu wanka Isipgim ikanam eyi wangafum ka ma nem sihinaiba eso Herot luwalim oyisgi og ka tigefaka.” ");
INSERT INTO amn_n_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Josep bihianam pugu wankana sinaini Isipgim. ");
INSERT INTO amn_n_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Josep Isipi yi wangafiba eso Herotba wahaf. Enaba Ainiyag mo fa sihiule elni mengig wa ati sihi wahiana. Ehe esona og; Ka kikeafena luwalim unenaiba eso Isipim wahianam bof. ");
INSERT INTO amn_n_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herot nengeawan afa mas anwana el ambugog ehem opukona mo, heafa kam mwakwalinig. Eso olug kakagenam afa mingnag elim ningitigina Betlehemgam og ma luwalim mungwali kwakskofeahui. Luwalba ninganai enaba sambaga yia enaig og masa kwakskofeahui. ");
INSERT INTO amn_n_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Enaigba esiniba eba God mo fa sihiule el Jeremaiana mengig wa ati sihi wahiana. Enaig esinibi eso inim puguna. Ehe og; ");
INSERT INTO amn_n_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Afa Rama nai el higni Resel ati heafna luwaligim wenaufena. Elbi ahanaig kwenifini mo, awai. Eba ehena luwalig mungwali awaiena mas aman mo gafena mo. ");
INSERT INTO amn_n_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Afa mahim Herotim wahanaba, Ainiyagna ofwanai el Isipi yi Josepim itiwa pugu sihinagena. ");
INSERT INTO amn_n_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ehe og, “Ese piske Israelgam angwafigni luwalnam wanika. Ati elbi pigig ogna ehem tigi kumwahli.” ");
INSERT INTO amn_n_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Afa so Josep bihia wankana Israelgam. ");
INSERT INTO amn_n_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Afa ika higinaba Arkelaus Herotna leg puguna Judiana misog el gofna. Josep esim ikagim embefena. Afa itiwa God sihina Josepim, naso Josep Galili provins gam wankana. ");
INSERT INTO amn_n_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Afa wankanam ming kimbig wa Nasaret wa wangafna, enaigba esenaba mo fa sihiule elni moaihwa og elbi enaba sefig eba Nasaret wanai el. ");
INSERT INTO amn_n_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Enanam Jon buwa aitiaule el pugunam el hwainig wa Judiana kimbigwa mo sihiagekana. ");
INSERT INTO amn_n_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Enaig esona og, “Olug wahgifi. Godna bog meg ati bog afa Godna sawieg wa big saiyenam eso heafna luwalig agfohie.” ");
INSERT INTO amn_n_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Autunam Aisaia mo fa sihiule el ati sihi wahiana, el enaig esona. Jon eba enaig el. Aisaiana mo enaig esona og; El hwainig wa el mungo pugu mo sihiagaf enaig esof, Ainiyagna mina numwehiagi, heafna mina, mina suf faki. ");
INSERT INTO amn_n_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jonba tata lag lofug fatinam. Ena tata lagba eba kamel. Afa afiai kigifena afa fane negba sanglita i afa mumug suwig i enag neakafna. ");
INSERT INTO amn_n_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Enanam Jerusalem el i Judia el i afa Jordan buwa auguiakana enag mungwali ambugog gohna Jon nangum. ");
INSERT INTO amn_n_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ambugona heafgelni amtakwaligim sihiagini afa so Jon Jordan buwa aitina. ");
INSERT INTO amn_n_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Afa farisi el i Sadyusi el i ambugog ogna buwa apaigo, Jon nangwagnam afa esoni og, “Nengelbi giheana luwalig, aman ne sihinigbi ma Godba ma nem amtakwali gihiagef eso ne embemba ahuofe. ");
INSERT INTO amn_n_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","So na lahlag nihe fi eso ma el anwanafi ne ati inim olug wahigifig. ");
INSERT INTO amn_n_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nofeka enaig onigwagi Abraham kagelni simbianinga eso ka gaba lahlag el. Ka nem sihinig God ehe eseba ohuna hunba Abrahamna simbianingag opuko gofe. ");
INSERT INTO amn_n_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Mal ati li mog wa gi. Li fug lahlag lugwag hwanigba, eba higfihinim suwi wa aitif. ");
INSERT INTO amn_n_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ka nem buwaba aitigba eba enaig eseg ati ne olug wahigifig. Afa el sumi yi oboba ehena kigmogba kana kigmogim filafeg. Kaba lahlag el mo naka ehena mong lofugba fakuna. Eba nem buwaba Godna Sungwagni afa suwina aitif. ");
INSERT INTO amn_n_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Elbi enaba oboba forkba ningana fagim ogna hunisege mungwali wambuhiage witinai. Ogna wit agogloi heafna wit lala wahia afa hunisege mo wambinam suwi wa aitif.” ");
INSERT INTO amn_n_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Afa enanam Sisas Galili wahianam Jordan wa pugunam bona Jon nangum og ma kam Jon buwa fati. ");
INSERT INTO amn_n_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Afa Jon ehem gwenam afa esona og, “Nemble he kam buwa fati. Ahnaig esegba nana ka nanguba bog?” ");
INSERT INTO amn_n_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Afa Sisas mungwag ehem sihina og, “Esese, ati ka nem sihinag. Enaig big esahfeba eba ati big Godna sawieg wa big sahof.” Afa so Jon ehena mom pahlukuna. ");
INSERT INTO amn_n_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Afa Sisas buwa penam afa puguna ikana gofnaba ikagna of pigina afa nangunaba Godna Sungwag gamp lofug pebona Sisas nai yi wahlana. ");
INSERT INTO amn_n_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Afa mengig hevenwa wagofna og, “Sohna elbi eba kana leg, ka ehem hugna membenag. Ka olug ehem lahlafenag.” ");
INSERT INTO amn_n_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Godna Sungwag Sisasim el hwanigam wanikina og ma Satan gihnai. ");
INSERT INTO amn_n_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Afa 40 osuna Sisas mas fane nenamo, mahim 40 osuna awaienaba ehem hugna bini wahana. ");
INSERT INTO amn_n_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Afa Satan bona ehem puguna afa sihina og, “Afa ne Godna leg fegba eba sona hunim esoiba soma amba lofei.” ");
INSERT INTO amn_n_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Afa Sisas esona og, “Godna moba enaig esog og, ‘Amba mungo mas elim nofkikenagagba fai. Godna mo mungohe eba so elimba nofkikenagagba fai.’” ");
INSERT INTO amn_n_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Mahim Sisas enaig sihifenaba Satan Sisasim sulfanam Jerusalem gam wanikina. Wanikina Godna nalig lala wofugug sisia nemug wa washona. ");
INSERT INTO amn_n_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Afa Sisasim sihina og, “Afa ne Godna leg fegba eba so na sofuku pekai eba ati Godna mo sihig; Eba heafna ofwanai elim sihiniba ofwanai el ambugog nem ningana kikehli apaigohuf eba mas nem hun sig mong yi pifuf.” ");
INSERT INTO amn_n_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Sisas sihina og, “Godna mo enaig esog, ‘Nofeka Ainiyagim nimbiafna Godum gihna.’” ");
INSERT INTO amn_n_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Satan Sisasim mungwanam mug gam fuko wanikinam afa so mungwali bite i afa lahlag gawig i wagfunagena. ");
INSERT INTO amn_n_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Afa Sisasim sihina og, “Ma ne kam mongkokug kwakwagenam kana unehlagim fingi feiba, ka so nem bite i gawig i mungwali faif.” ");
INSERT INTO amn_n_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Afa Sisas sihina og, “Satan, esimika Godna mo enaig esog, ‘Godum ahnai skaugfenam afa so heafna unehlagim mungo fingife.’” ");
INSERT INTO amn_n_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Afa so Satan Sisasim wahianamba. Afa ofwanai el ambugog Sisasim kweagfuni. ");
INSERT INTO amn_n_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Sisas enaig higina og ati Jonimba kalabusig eso Galili provins gam piske ikana. ");
INSERT INTO amn_n_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Afa ehe Nasaret mo wahianam ika Kaperneam wa mo gafena. Kaperneam Galili bu megim gifni muhwa Sebulun Naptali elni bite wa. ");
INSERT INTO amn_n_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Enamba Godna mo fa sihiule el Aisaia ati sihi wahiana. Enaig esona og; ");
INSERT INTO amn_n_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Sebulun i Naptali i nengelni bite gifni bu wahigeg mina ikagwa gwesim Jordan gohba eba Galili enaksag afwambanai el auguia. ");
INSERT INTO amn_n_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Enag elbi sikikieg wa auguia, ati nalig afwambusug pugunig eso nangug. Afa aman el sikikieg pigieg wa agfohiafiba eso afwambusenif. ");
INSERT INTO amn_n_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Enanam Sisas mo sihiagena og, “Godna bog meg ati bog so na olug wahigifinim saho ahu.” ");
INSERT INTO amn_n_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Sisas Galili bu blugmini ikan sambaganigi etesuminegim nangwagna Saimon Pita mi Andru mi. Sambaganigi fufwalana sawugim kigiag ohofefna. Sambaganigiba sawug gafuga ahfegofna. ");
INSERT INTO amn_n_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Sisas sihini og, “Au, kam ahpahlu bu ka nem elim ahwambugum wagfunuge.” ");
INSERT INTO amn_n_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Sambaganigi ikagna fufwala ahwahianam ahkana Sisasim ahpahlukuna. ");
INSERT INTO amn_n_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Sisas wankan afa ming etesuminegim nangwagna Sebedini legnigim Jems mi Jon mi afa heafningina awag bot wa auguiafenaba fufwala kukohiag kwalig afafna. Sisas uneni. ");
INSERT INTO amn_n_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Sambaganigi heafningina bot na afa awag na ahwatinam ahkana Sisasim ahpahlukuna. ");
INSERT INTO amn_n_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Sisas mungwali Galili yi langwakafna ikafnam nuwagig lala sahofnam kwamblo angwafigim wagfunugiafna afa Godna bog meg mom sihinigiafna afa mungwali ahanaig ahanaig gihna elim lahla feiti feafna. ");
INSERT INTO amn_n_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Afa mungwali el ena mo higiginim sihiagenim eso Sirianai el ahanaig ahanaig gihna elim wambufini. Elig tautigna, mwaifig simbigahlagulem, wuwagini, afa mong lihlina Sisas lahla fetifeafna. ");
INSERT INTO amn_n_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Afa enaksag Galilinai afa Dekapolisinai Jerusalem wanai afa Judianai afa Jordan bu meigi nai el enag mungwali Sisasim pahlukuia gohna. ");
INSERT INTO amn_n_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Sisas el enaksagim nangwagnam afa so mug gam fukukana. Mug wa fuko gafenaba afa heafna pahlukuiag el ehem ningi ahuna. ");
INSERT INTO amn_n_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Afa so Sisas mo pahlukuiag elim enaig wagfufeni og; ");
INSERT INTO amn_n_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Amangel eso enaig onigif, kaba lahlag el mo God so kam kweagfui, afa enag el so ma sifakalifi afa so ma Godna bog megam saihgoi. ");
INSERT INTO amn_n_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Amangel so wewatini auguia enamba so ma sifakalifi eba God ehengelim olug efihlag faif. ");
INSERT INTO amn_n_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","El so heafgelni unehlam pigapaiyegohug enaba so ma sifakalifi afa mungwali bite eba ehengelni. ");
INSERT INTO amn_n_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","El so lahlag nihem membigim pahluhug, enaig elbi ofe enaiba so fane i bu i bini pigig eba so ma sifkalif eba God yuhwa fenugef. ");
INSERT INTO amn_n_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","El so mingnag elim afafegonug enaba so ma sifakalifi eba God ehengelim afafenif. ");
INSERT INTO amn_n_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Elni olug so afsug guhun enaba so ma sifakalifi eba Godum nangufe. ");
INSERT INTO amn_n_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","El so ninimum tigefakig enaba so ma sifakalifi eba enaig sefifif Godna luwalig. ");
INSERT INTO amn_n_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","El so lahlag nihem pahlukugum eso kinig fig enaba so ma sifakalifi eba so ma Godna bog meg saigoi. ");
INSERT INTO amn_n_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Afa so nem nangwagif ne kana mungo ahufef eba nem amtakwalig mo sihigonif afa kokwaitifif eso ahanaig ahanaig mo nem mwakwal hiagif enaba so na sifakalifi. ");
INSERT INTO amn_n_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","So na olug efihlag na agfohiefiba afa sifakalifi mungwag nem nalig faif, eba heven wa nem nengenawo. Afa gwenaig esini el mo fi sihiaule elim ati gofgam amtakwalinagini.” ");
INSERT INTO amn_n_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Nengelbi bite na sol. Afa solba miaklaba awaieba so na ahanaig esibi, so ma piske miaklafei? Enaig solba so mas gafugafei eba el kukofef fatigim afa mongni pigageg. ");
INSERT INTO amn_n_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Nengelbi bitena afwambusugug. Kimbig sisyi mug wa gi enag mas meagam sahoi. ");
INSERT INTO amn_n_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","El so wi gafagim mas meagam kumoahlai eba awai, eba ambagwa gafa oku afa enaba lalanai elim mungwali afwambusugufenig. ");
INSERT INTO amn_n_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Afa so ma nengelni afwambusugug mingnag el nangui. Afa so ma nengelni lahlag nihem nanguagi eso ne esig. Eso ma nengelni Humuana unehlagim heven wanai fingi fi.” ");
INSERT INTO amn_n_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Sisas enaig esona og, “Nofeka onig neaga kam og bo Mosesna nihe mo afa mo fi sihiaule elni mo fingi fati me eba awai, eba ka yuhwa fenagef. ");
INSERT INTO amn_n_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ka nem inim sihinig, mahim of i bite i awaieba, mas ena nihe moba wesig nemug awaie, awai eba nihe moba gwese gofnaba afa so mungwali pugug. ");
INSERT INTO amn_n_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Enaig eseg afa aman wesig nihe mo mas fatinafe eba mingnag elim wagfunig so ma gwenaig esi enaig elbi Godna bog megam wesig nemug feg. Afa aman el ena nihe mo pahlukunam elim ogfu fenugeba eba Godna bog megam ehe gosuf. ");
INSERT INTO amn_n_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ka nem inim sihinig afa neana nihe farisi elni afa nihe mo anwana elni lahlag nihem filafeg hwanigba eba mas ne Godna bog megam sahoi.” ");
INSERT INTO amn_n_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Sisas esona og, “Ati ne higig ena moba simbianingam fini og, ‘Nofeka elimba tigifati afa aman enaigba eseiba eba pugu kotef.’ ");
INSERT INTO amn_n_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Afa yawo ka nem osihin el so heafna nilitem olug kakagenag eba pugu kotef. Afa aman so heafna nilitem amtakwalig mo faig enaba kaunsil nai ika pugui afa el esof ‘Neba lahlag el mo’ enaba ma suwilagig kimbigam ikai, awaiye. ");
INSERT INTO amn_n_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Afa so na sime wa Godum faigim obofuf afa so na piske oningig nimbeafna nilite nem ahanaig mo sihinaf. ");
INSERT INTO amn_n_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Eba so Godum faig mo wahianam ika sihiagefenam eso ne piske sime gam Godum faigim mo ika. ");
INSERT INTO amn_n_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Afa so nem el ogna kot ena ne mina wa ahkafiba eso ati ikagna sihiagaf. Eba ma so nem oku kwefihiage elni ninga nem wa wahiaf afa ehe nem oku plismanna ninga wa wahiaiba, eso plisman mo nem kalabus yi wahiaf. ");
INSERT INTO amn_n_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ka nem inim sihinig neba kalabus lala gafiba afa ma ne mungwali kig piske faiba eso nem wahif.” ");
INSERT INTO amn_n_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Sisas enaig esona og, “Ati ne higig autunam enaig esogona og nengel angwafigni nofeka aga taitu fi. ");
INSERT INTO amn_n_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Afa ka nem enaig sihifenig, afa so aman mungo angwafigim nangunam afa oniginagef eba gwenaig eseg ati keahlag. ");
INSERT INTO amn_n_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Afa eso neana nihiginai nofug amtakwaligim nangunam eseba enaba so fagafati so ma enaig awaie eba mas neana elig mungwali suwilagig kimbig wa fati. ");
INSERT INTO amn_n_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Afa eso neana nihiginai ninga amtakwaligim keahlaf eba so higifanam fati so ma enaig awaie eba mas neana elig mungwali suwilagig kimbig wa fati.” ");
INSERT INTO amn_n_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Sisas esona og, “Autunam enaig esogona og, ‘Aman heafna angwafigim ningihiagba eba so angwafigni ningihiag pepa faifni.’ ");
INSERT INTO amn_n_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Afa yawo ka nem osihin el so heafna angwafigim ningihiaf angwafig ahanaig ese hwainig enag elbi eba heafna moawa ehe angwafigim enaigba esenag afa ena angwafig ming ligagim faiba eba ehenigi ati aga taitu ahfeg.” ");
INSERT INTO amn_n_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Sisas piske esona og, “Ming mo simbiangam finibi ati ne higni enaba enaig eseg. ‘Nofe ne mwakwalinim afa inim moawog. Afa ne Ainiyag gim sihi wahianagim so na inim ese.’ ");
INSERT INTO amn_n_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Afa yawo ka nem osihin nofe ne inim enaigba esogo. Nofe ne hevenimba sefinim afa kifutig mo sihi, hevenba eba Godna kwefihiage sime. ");
INSERT INTO amn_n_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Afa nofe ne bitemba sefinim afa kifutig mo sihi ena bite eba God enanai yi mong pafeuguia. Nofe ne Jerusalemimba sefinim afa kifutig mo sihi eba nalig misog elni kimbig. ");
INSERT INTO amn_n_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Afa nofe ne misog angmowaginam afa kifutig mo sihi afa ne mas neana lapogum mungo busug mi yimilig mi esei. ");
INSERT INTO amn_n_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Afa so na enaig esogo, ei afa awai gwenag ehe. Mingnag moba eba Satan wambu puguafug.” ");
INSERT INTO amn_n_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Sisas esona og, “Ati ne higig autunam enaig esogona og aman amanim nofugum amtakwale fatiba eba so na mungwag amtakwale fatina. Afa ma aman amanam gogum tutohia aitiba eba so na mungo ehena gogum tutohia aiti. ");
INSERT INTO amn_n_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Afa ka nem enaig sihi fenig el eso nem amtakwalig ahanaig ofi nofe ne mungwagba esegon magofi. Ma nem amanba angmogwaba tigeiba eso wahigif ming eheganai nihna. ");
INSERT INTO amn_n_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ma amanba nem kotimenam afa neana lofug hugu faiba afa so na ming kunam lofug ena gaba fai. ");
INSERT INTO amn_n_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Afa ma amanba nem kifutigni og ohuna gawig faku muhwa faka afa so na mo hilife wahigwa yi oku pugu. ");
INSERT INTO amn_n_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Afa ma aman nem mangim og kam fai afa eso fai. Afa eso aman enaig membef og ne kam isug fai afa keso nem mungwag fai enaba nofena masig fatina.” ");
INSERT INTO amn_n_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Sisas enaig esona “Ati ne higig autunam enaig esogona og hihem mungo membenaiba afa angoluwag mo olug kakage goni. ");
INSERT INTO amn_n_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Afa yawo ka nem osihin angoluwagim gaba eso ne membegon, afa so na Godum sihinibi eso ma God elim afafeni eso nem amtakwalig hiagifug. ");
INSERT INTO amn_n_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Enaig ne esibi eba nengelni heven wanai awag esof ‘Kana luwal’, afa mahim ehe osum sisigam esegba naso pukonug el amtakwaligim afa lahlag elim. Afa mahim buum ningihiagba bu feg el lahlagim afa amtakwalig elim. ");
INSERT INTO amn_n_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Afa el eso nem membegonug afa enaig ne membegonug, enaba mangig gau ne fif? Afa kig wambule el gwenaig esig. ");
INSERT INTO amn_n_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Afa so na nimbeafna hihe mungo sihigon enaig nihe mas mingnag elni nihe gosu feg mo. Afwambanai el ati enaig esig. ");
INSERT INTO amn_n_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Afa eso ne hugna lahlag agfofum nengelni awag hevenwa lahlag gwenaig feg.” ");
INSERT INTO amn_n_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Afa Sisas mo sihin gofena, “Ne numwehifum nofe ka enaig onig ka lahlag nihe mingnag elim wagfugonibi eso ma kam nangwagi eba mas nem nimbeafigelni heven wanai awag gau fai. ");
INSERT INTO amn_n_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Afa ne membeg ne og ka isug elim mang faigo ne nofe ka elim gof ningitigi eso ma afag gofiba eso ati sambaga mengig el enaig esifafif nuwagig lala afa mina wa enaig esogonibi eso ma el ehengelni unehlagim figifegoni. Ka nem inim sihinig enag mungwag faig ehe ati piske fig. ");
INSERT INTO amn_n_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ne membeg ne og ka isug elim kwaganim eba so nihiginai ninga ofefiba eba mas sahaganai ninga anwanafei. ");
INSERT INTO amn_n_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Enaig esegba neana kusguog gafugag meagam sahogo, afa neana awagba ati nangug mang so meagam go enaba nem eso mungwag faif.” ");
INSERT INTO amn_n_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Sisas enaig esona, “Ne Godimba asahinifibi nofe ne sambaga mengigna el lufwag eba enaig esifafif nuwagig lala afa mina meigim agfohiaba eso beteni og ma kam mingnag el nangwagi. Ka nem inim mo sihinig enag mungwag faig ehe ati piske fig. ");
INSERT INTO amn_n_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ne betenba ofefiba ika lala megam sahonam mengig kikisenam eso ne betenba fe neana awagba meagam go ati anwanafeg meaganaimba eba nem mungwag faif. ");
INSERT INTO amn_n_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Afa ne betenba ne ofefiba nofe ne mempbug mo sihiage enaiba afwambanai el. Eba enaig onigig ka ma mempbug mo sihiba eso ma God higi. ");
INSERT INTO amn_n_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nofe ne ehengelni nihem pahluku afa ne mahimsi nimbeafna awagimba sahanag hwainig fiahba eba ati anwanafeg mang mungwali so nem awaienig. ");
INSERT INTO amn_n_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Eso ne enaig sahi; Kagelni Humuan ne heven wa ga soma el neana unehlagim fingi fini. ");
INSERT INTO amn_n_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nana bog meg ma boi, neana sawieg eso heven wa pugug eso ma ohuna bite wa gwenaig ese. ");
INSERT INTO amn_n_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Enag osuna so kam fane faiba so ma gwese gofi. ");
INSERT INTO amn_n_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Eso ne kagelni amtakwalig mo ismunagim hugufatini eso kagel gwenaig esig el kagelim amtakwalig gonug eso kagel ehengelim ismunagim hugufati gonug. ");
INSERT INTO amn_n_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nofe ne kam hwati ma kam gihnag pugunibi eba so kam amtakwalig wa nai wambum. ");
INSERT INTO amn_n_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Sa higim ne mingnag elni amtakwalig mo ismunagim hugufatiniba eba nengelni awag heven wa ga enag nengelni amtakwalig mo ismunagim hugufati nif. ");
INSERT INTO amn_n_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Afa ne mingnag elni amtakwalig mo ismunagim hugufati gonug hwanigba eba nengelni awag mas nengelni amtakwalig mo ismunagim hugufatini.” ");
INSERT INTO amn_n_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Sisas esona og, “Ne faneba ne ahoiyufiba nofe ne amtakwalig boseagi sonaigba sambaga mengig el so esifafif amtakwal boseagig so mingnag el nangwagigim anwanafig og eba fane hoiyugofiba ka nem inim sihinig enag mungwag faig ehe ati piske fig. ");
INSERT INTO amn_n_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Afa ne faneba ahoiyugofiba eso ne lapogum pitigifiage afa nofbosugum buwasug fai, ");
INSERT INTO amn_n_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","eba so mas el nem anwanafini fane so na hoiyug. Nana awag meagam sahogoba eba ati eheba anwanafeg eba ati nangug meaganaiba eba nem mungwag faif.” ");
INSERT INTO amn_n_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Afa Sisas esona og, “Nofe ne lahlag gau ohuna bite wa agogloi ohuna biteba susmo afa bwambugug enag gawigba amtakwale skofig afa okwefule el bog tofugum eso okwefig. ");
INSERT INTO amn_n_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Afa nengel eso lahlag gau hevengam agogloi hevengamba mas susmo bwambugugei enag gawigba amtakwale skofig afa okwef el mas bog tofunam saho okwefi. ");
INSERT INTO amn_n_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Afa ahnanai yi neana lahlag gawig go eso neana olug enanai yi go.” ");
INSERT INTO amn_n_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Sisas enaig esona, “Nofugba eligni afwambusugug neana nofug lahlag gohugba eba neana elig mungwali afwambusig. ");
INSERT INTO amn_n_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Afa neana nofug amtakwaleba eba neana elig mungwali sikifig. Afa afwambusugug so sahog neana nihi go enag kikiefiba eba nalig kikifef.” ");
INSERT INTO amn_n_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Sisas enaig esona og, “Mas aman sambaga misog elni mom higinam pahlukui. Eba ming mo membeba afa ming mo kusif afa eso ehe ming i mo hignaiba afa ming i mo mas fatinafe. Nofe ne Godna gafugag mi afa kig gafugag mi wambtigi”. ");
INSERT INTO amn_n_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Sisas enaig esona og, “Nofe ne hugunam nimbeafnam nofkikenam onigigakafum afa ne esog mang kawo ne? Afa nofe ne eligim oniginam afa esog mang lofug ka fatif? Eba nofkikena fanemba flafug afa elig lofugba flafug! ");
INSERT INTO amn_n_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ati ne twafigim nangwagig mas faneba yihi afa mas agogloiaginim fane lalaba sugum. Nengelni awag hevenwa ga enag so faneba faig. Ateaho so na twafigimba flafug? ");
INSERT INTO amn_n_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Aman so nengelinai hugna onigigem eso heafna nofkikenaba hili wahiaf? ");
INSERT INTO amn_n_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ahnaig esegba eso ne hugunam lofugumba onigig. Ati ne li sisigimba nangug ahanaig opukefig. Ehe mas kifutig gafugafei afa lofugba gweli. ");
INSERT INTO amn_n_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Afa ka nem sihinig autunam misog el Solomon na mungwali gau lahlag skonaba mas lahlag li sisig lofena mo. ");
INSERT INTO amn_n_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Pos gaba afa siniba eba ati higfihinim suwi wa wambaitif. Enaig posba God ehe agiageg wahiag. Afa eso nengel wesig olug onigina eso ne numwehe onigi neanga Godba nem gau faif. ");
INSERT INTO amn_n_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Nofe ne enaksag onigwagi afa esogo mang fane afa bu big ahgaf afa esogo mang lofug big aitiagif? ");
INSERT INTO amn_n_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Afwambanai elbi enaigim hugna onignagegim afa so yisigego. Afa nengelni awag hevenwa ga enaba ati anwanafeg eso nem enaig ena mungwali yi fi. ");
INSERT INTO amn_n_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Afa enaig ne esofifiba eba so Godna bog megim gosu onigibi afa eso ne ehena lahlag nihe gosu pahlukuiba eba so nem mingnag gawig gaba nem faif. ");
INSERT INTO amn_n_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nofe ne siniba hugna onig eba enmuna kinig puguf. Yawonai kinig eba heafa gwenanam mungo.” ");
INSERT INTO amn_n_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Afa Sisas esona, “Nofe ne mingnag elni minag ahuagim fahigegonugi afa enaig esogo sohnaba el amtakwalig ne enaigba esibi ma so God nem gwenaig esenif. ");
INSERT INTO amn_n_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Godba nengelni minag ahuagim fahigihagefe eso ati ne mingnag elim esegonug eba gwenaig esef. Eso ne mingnag elim ahanaig hili faigog eba gwenai hili nem faif. ");
INSERT INTO amn_n_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Afa ne nilitem nangunam afa esog nilite ka nem hunisege nofwanai wesig fa fatina. Afa mas ne nimbef mo ne onigi mo aga nimbeafna nofwa so gi. ");
INSERT INTO amn_n_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ahnaig esegba eso ne esog nilite ka nem hunisege wesig neana nofwanai fa fatina afa nimbef mo aga nofwa gi. ");
INSERT INTO amn_n_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Eba ne sambaga mengig el yuwana nimbeafna nofwanai aga fa fatinam afa numwehe nangufe eso nimbeafna nilite na nofwanai mo fa fatina. ");
INSERT INTO amn_n_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Nengel nofe ne mangwalba finim Godum so ati mwalunum afa mawangim faigo afa nimbeafgelni lahlag nemug engig nofe ne tatam aitigon masa pigaskofif masa nem wahgi kwaskofif.” ");
INSERT INTO amn_n_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Sisas esona, “Nengel ne Godum mangimba sahnibi eba ne fif. Afa ne yisigibi eso ne nanguf. Ne mengigiba tigibi eba God nem pitigiefonfie. ");
INSERT INTO amn_n_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Eso mungwali el Godum sahnigim eso mangwalba wambufug. El mangwalba yisigifiba eba nangufe. Afa el mengigiba otigefiba eba God piginafe. ");
INSERT INTO amn_n_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Afa luwal eso awagim sahanafe kam amba fai eso awag hun fagim faig enaigho esifafef? Awai. ");
INSERT INTO amn_n_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Afa luwal esog kam sawug ebinengu fai eso ateaho so awag sombine faif? Awai, mas enaigba esei. ");
INSERT INTO amn_n_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nengel amtakwalig el afa ne nimbiafena luwalim mo mang mang lahlag wambwaigog. Enaig fenaba enag so na numwehe anwanafi. Eba nengelni awag heven wa ga enag so amangel ehem sahinigbi eso ehengelim hugna lahlag fenig. ");
INSERT INTO amn_n_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Eso mingnagim esinibi mang so na membeg eso nem esinig. Enag mo enaho nihe moba afa Godna mo fi sihiule elni mo mog mu.” ");
INSERT INTO amn_n_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Sisas esona og, “Nengel eso mengig wetiklug megam eso ne saiyego. Mengig awaieg minaba eba nalig fegim afa pigiageg gwenaig yuhwafeg afa ena minagamba el numb fafufiahu. ");
INSERT INTO amn_n_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Afa mengig ikag nofkikena fagba eba wetiklug nemug ena minaba ahanaig esig mungwali el pahlukuihia mo eba mungo mungo el ehe ena minaba yisigi nangug.” ");
INSERT INTO amn_n_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Sisas esona og, “Nengel numwehi agfohefum mwakwal el Godna mo fi sihiule el ambugof eba sangwalinai mawang sipsipni lofug aitigogum afa ambugog sipsipni muhwa agfohiegim og na sipsipim kwahagafi. ");
INSERT INTO amn_n_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Eso ne nangwag ehengelni nihem eso ne anwanafi ehe enaig esig. Afa nasna we mas aibi lei afa tautigna li mas fwatamofba lugwi. ");
INSERT INTO amn_n_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Eba enaig eseg li lahlag fug mungwali lahlag leg afa li amtakwaliba fug amtakwali leg. ");
INSERT INTO amn_n_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Afa li lahlag mas fug amtakwali lei afa li amtakwalig mas fug lahlag lei. ");
INSERT INTO amn_n_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Mungwali li amtakwalig mas fug lahlag lei enaba higfihig afa wambug suwi wa aitig. ");
INSERT INTO amn_n_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Eso ne nangwag ehengelni nihem afa eso ne anwanafi eba naho mwakwal el Godna mo fi sihiule. ");
INSERT INTO amn_n_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Mungwali el eso kam sefig og ‘Ainiyag Ainiyag’ eba mas ahui Godna bog megam saigoi, awai. Aman kana awagna sawiegim pahlukuiba eba ena ho Godna bog megamba osahu. ");
INSERT INTO amn_n_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Enanam ka mungwali elim kwefihiagefe el kam sihinif og ‘Ainiyag Ainiyag’, ati ka neana unehlag wa mo fi sihiahug. Afa neana unehlag wa ati ka nimbasa amtakwalig ningitigif afa neana unehlag wa ka ahanaig ahanaig kigmog wagfug. ");
INSERT INTO amn_n_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Enanam ka esof ne mang kana inim el mo. Nengel amtakwalig el gwesim ahu.” ");
INSERT INTO amn_n_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Sisas enaig esona, “Aman kana mom hignam pahlukuiagofiba eba naho lahlag onigig el enag lalaba bite kifutig yi nimblag. ");
INSERT INTO amn_n_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Enamba bu nalig fenam bu yi bugoi bifwat i fefiba mas gafai eba bite ati sumilim kehlag. ");
INSERT INTO amn_n_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Afa aman kana mom higinam afa pahlubu hwanigba eba naho etetig el eso lalaba engig sisiyi nimblag wahiagba. ");
INSERT INTO amn_n_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Afa mahim bu nalig fenam bu i bugo i bifwat i fenam eso ena lalaba tofupef.” ");
INSERT INTO amn_n_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Sisas mahim ena mo sihinaba, el nubwel kwamblo i afa humuan i sineminefini ehena anwanagim. ");
INSERT INTO amn_n_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Mang nihe mo anwana el mo wagfug, eba awai. Eba gwenag anwana el nemug fena. ");
INSERT INTO amn_n_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Sisas mug gum wahia pekana afa el numb sum pahlukuna. ");
INSERT INTO amn_n_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Afa el elig amtakwaligna sefig lepra bonam mong kokoni kwakwagena Sisasim sihina og, “Ainiyag ne membegba eba so na kam lahlafe fati.” ");
INSERT INTO amn_n_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Sisas tuhnam sihina og, “Ei ka membeg, so na lahlafefe.” Mahim enaig esonaba ikagna ena gihba awaiena elbi enaba pugu lahlafena. ");
INSERT INTO amn_n_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Afa Sisas ehem sihina og, “Nofe ne elim sihin. Ikanam prisim nimbeafna eligim wagfunim afa so Godum faig enaig autunam Moses ati sihi wahiana eso ma anwanafi neana gih ati lahlafeg.” ");
INSERT INTO amn_n_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Sisas ika Kaperneam kimbig wa pugunaba afa amini misog el Rom wanai enag bona Sisasim sahna. ");
INSERT INTO amn_n_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Og, “Amunai, kana gafugag el gihegba lala gi. Ati kigba mungwali lihlifeg afa tautig naligfeg.” ");
INSERT INTO amn_n_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Afa Sisas ehem sihina, “Eba ka ikanam eso ehem lahlafe fatif.” ");
INSERT INTO amn_n_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Amini misog el ehem sihina og, “Amunai, kaba lahlag el mo na ne kana lalagamba bo, isug mo bihig sihiba so ma kana gafugag elbi lahlafei. ");
INSERT INTO amn_n_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ka enaig sihifeg kanga ka so misog elim ahnai skaufen. Ka gaba ati soldiaba feg enag kam ahnai skaufinig. Afa so ka amanim sihinaf ika eba ehe ikaf, afa ka ming elim sihinaf aubo eba ehe bof. Afa ka kikeafna gafugag elim sihinaf ohnam gafugafe, eba ehe ika esef.” ");
INSERT INTO amn_n_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Sisas ena mom higinam ehena olug gufifukona afa el eso ehem pahlukuna enam sihini og, “Ka nem inim sihinig mas ka amanim mungo Israel wanai elimba olug onigi nalig feg ohunaig elbi nanguna mo. ");
INSERT INTO amn_n_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Afa ka nem sihinig el numb osu puguag wanai osu peg wanai ambugonam afa Abraham Aisak Jekopna wahlanam eso saiyenam Godna bog megam augunam ahgaf. ");
INSERT INTO amn_n_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Afa amangel enaig onigig kagel so Godna bog megamba saigof eba God ningitigiba eso afwambagam sikifig wa eba wewatonam heafgelni gog tutoa ahgafuf.” ");
INSERT INTO amn_n_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Sisas amini misog elim sihina, “Seika eba neana gafugag elbi lahlafefe eso neana olug onigig wa enaig gohug.” Afa mahim sihiagaf gofnamba elbi enaba ati lahlafena. ");
INSERT INTO amn_n_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Sisas ikana Pitana lala sahonam nangunaba Pitana kuwag gihna kugwa gifni ehena elig hugna nolugenagena. ");
INSERT INTO amn_n_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Sisas ehenam ningam tohnamba gih gweyi awaienaba afa so bihianam Sisasim fane tuhlu faina. ");
INSERT INTO amn_n_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Osupegnam el numb nimbasa simbigahlaule elim wan ambugoguhna Sisas nangum mahim mo esonaba eso nimbasam ningitigina afa mungwali gih elim lahla fetifena. ");
INSERT INTO amn_n_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Godna mo fa sihiule el Aisaia autunam ena mo sihinaba eso enaba ena mo inim puguna. Aisaia og; Ehe bigelni ahanaig ahanaig gihim wambinam afa wambkuna. ");
INSERT INTO amn_n_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Afa Sisas el numb nangwaginam mahim ambugog ehem wahkinaba eso ehe heafna pahlukuiag elim esoni, “Ause, na kwehegam maligim ahu.” ");
INSERT INTO amn_n_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Afa enanam nihe mo anwana el Sisasim bo sihina og, “Amunai, ka nem mungwali kimbig pahlu fefkufufe.” ");
INSERT INTO amn_n_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Afa Sisas ehem sihina og, “Afa sangwali mawang bite meg ati go enana yi gig afa twafigni gag ati feg afa Inim Elbi heafna kugigbi awai.” ");
INSERT INTO amn_n_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Afa ming el eba pahlukuiag el sihina og, “Ainiyag, kam wahiaiba ka ma kikeafena awagim fakanam.” ");
INSERT INTO amn_n_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Sisas ehem sihini og, “Mangofi, kam pahluku. Aman ati wahag enaig el so ma heafgelni melig pigieg elim bite wa skui.” ");
INSERT INTO amn_n_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Sisas heafna elim bot wa wankana. ");
INSERT INTO amn_n_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nalig bifwat ikagna bu mina bona afa bu bona bot megam sahua minefena. Afa Sisas non gifini. ");
INSERT INTO amn_n_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Eso pahlukuiag el ahu Sisasim ilafuni og, “Ainiyag, kam kwagan, muhwa ati bigim awai ofe!” ");
INSERT INTO amn_n_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Sisas wahigi sihini og, “Ahnaig esegba so na embefig? Nengelni olug onigig wesig klug.” Eso ehe bihianam fufei mi bu mi kweniba eso bifwat tigiafona. ");
INSERT INTO amn_n_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Enag el sineminefinim hefum sahigini og, “Sonag elbi eba ahanaig el eso fufei i bu i ehena mom so higig?” ");
INSERT INTO amn_n_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Afa Sisas bu ehengam ikanam afa Gadara bite wa puguna. Afa sambaganingi el nimbasa simbigahlaule hugskug hun meg menai agfwahanam afa Sisas ahufana. Eheningi elim hugna kwagaiti ahfiahkafena eso el mas ena mina ahui. ");
INSERT INTO amn_n_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Eheningi ahunena og, “Ainiyag ne Godna leg asegba ne kam esenig? Eba mahisife ateaho ne yawo kam amtakwalig mungo faigim?” ");
INSERT INTO amn_n_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Afa muhlagig enaksag tata fane enanai yi ahagahu. ");
INSERT INTO amn_n_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Afa enag nimbasa Sisasim hugna sahini og, “Afa kam ningitigiba eso ka ahunam sonag enaksag tatana elig saho go.” ");
INSERT INTO amn_n_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Afa Sisas ehengelim sihini og, “Sa ahu!” Afa nimbasa eheningim wahianim tata wa ahu saho gona eso enag enaksag tata kikini ahunam bu wa apaigo gonam mungwali pigina. ");
INSERT INTO amn_n_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Afa tata yuwigig el nangunim eso kimbig gam kikini ahunam elim ena mom sihigoni. ");
INSERT INTO amn_n_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Afa mungwali el kimbig wanai ahunam Sisasim ufini. Afa nangunim ehem kifutig mo sihini og, “So na kangelni ohuna bitem wahia ika.” ");
INSERT INTO amn_n_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Eso Sisas bot wa fukunam ikana. Afa ehegam ikana heafna kimbig wa puguna. ");
INSERT INTO amn_n_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kig lihligna elim mingnag el yisgofbog wa Sisas nangum flihuna. Sisas nanguagnam ehengelni olug onigigim afa kig lihligna elim sihina og, “Nilite, so ma neana olug kifutig gofi, ati ka neana mungwali nufwefbi hugufafatig.” ");
INSERT INTO amn_n_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Afa nihe mo anwana el Sisasim higinim. Enag hefum sihiageni og, “Enag elbi amtakwalig mo sihig. Ehe Godna sigagwa gohug.” ");
INSERT INTO amn_n_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Afa Sisas ati heafgelni olugum anwanafeni og, “Eba aseg nengelni amtakwalig onigig olug yi go. Eba amtakwalig. ");
INSERT INTO amn_n_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Afa ka enaig sihifeba, ‘Atika neana mungwali nuhwef hugufafatig,’ eso ne mas anwanafe inim mo sihig me awai awai me. Afa ka enaig sihifeba, ‘Bihiaka’ eso ne anwanafe inim sihig me awai awai me. ");
INSERT INTO amn_n_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Afa yuwaba ka nem wagfunag Inim El eba ese fe nuhwef hugufafatif.” Eso kig lihligna elim sihina, “Bihianam kug lala gam faku.” ");
INSERT INTO amn_n_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Eso el bihianam heafena lala gam ikana. ");
INSERT INTO amn_n_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Afa mungwali nangunim sineminefini. Afa so mungwali sihiageahuna, “Godba lahlag nemug. Ehe nalig kifutig elim faini.” ");
INSERT INTO amn_n_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Sisas nanai yi mo wahianam ikana. Ikanam kig wambule elim heafna gafugag lala nanguna. Ehena unehlagba Matyu. Sisas ehem sihina, “Kam pahlu bu,” eso bihia sum ikana. ");
INSERT INTO amn_n_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Mahim Sisas Matyuna lala ahgafafnaba mingnag el kig wambule el i afa nuhwef el i ambugog auguna. Augunam eso Sisas heafna pahlukuiag el i wahlanam ahgana. ");
INSERT INTO amn_n_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Afa farisi el nangunim, afa pahlukuiag elim sahigoni og, “Ahnaig esegba nengelni anwana el ika enaig elbi sahu waniau?” ");
INSERT INTO amn_n_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Afa Sisas higina mahim sihiag fiahfanaba, eso sihini og, “El gihnaba eba so ahui doktaba nangui, afa el gih hwainig eba mas ahu nangui. ");
INSERT INTO amn_n_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ahu mog mu yisigi Godna buk wa go. Autunam God sihina, ‘Ka mas membenig mo Godum sis isug tuhlu faigba, ka membeg ne elim afafena.’” Sisas esog, “Kaba mang bog lahlag elim uneni mo. Ka amtakwalig elim unenig so ma kam pahlukui.” ");
INSERT INTO amn_n_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Afa enanam Jonna pahlukuiag el ambugog Sisasim sahini, “Kagelni niheba fane fahwoiyu gofe. Ahnaig esegba kagel i farisi el i ohuna nihe pahlukuia afa neana pahlukuiag el mas enaig esig mo?” ");
INSERT INTO amn_n_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Afa Sisas angwafig fagim waskwes mo sihini og, “El mungo angwafig fagim, mingnagim buyisnig. Fana augiafnaba, heafna hihe mas hwoiyugona mo, awai. Afa nengigim angoluwag el enag elim wanig ahunaba, afa so heafna hihe fane hwoiyugona.” ");
INSERT INTO amn_n_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Afa Sisas mingnag waskwes mo sihini og, “El mas yimieg lofug autunai lofugi wahe gweli. Mahim gigiafibi, eba yimieg lofug wesigfenam afa autunai lofug mo kwafof. ");
INSERT INTO amn_n_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Enaig mo eseg, el mas yimieg wain bug autunai sis lofug fogwaba mas sugfoi eba awai. Mahim yimieg wain bug memewiafukoba, afa eso sisna lofug fog kwafug. Afa bu pe sufug na lofug amtakwalig. Eso yimieg wain bug yawonai sis lofugwaba eba so efiyi hugunam eba so lahlag ahgofi. ");
INSERT INTO amn_n_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Afa Sisas ehengelim sihi gofenaba afa Junai misog el bona mong kokoni kwakwag penam Sisasim sihina, “Yawo kana naina luwal ati wahag. Eso ne bo ningana kana luwalim tuhwiba eso ma buihiai.” ");
INSERT INTO amn_n_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Afa Sisas bihia pahlukuia gofnaba afa eso pahlukuiag el gwenaig esini. ");
INSERT INTO amn_n_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Ahufefnaba afa angwafig mungo higeg lala gim fawofeakafna 12 yia. Hefum enaig esona og, “Ka ehena lofugumba tuhwiba eso ma kam wanganefe.” Enaig oniginam naso bona Sisasna masig muhwa pugunam afa eso ehena lofugum embegim tuhna. ");
INSERT INTO amn_n_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Afa Sisas wahigefe nangunam afa sihina og, “Angwafig, neana olug onigi ma afahlana gofi. Nana lahlag onigig eba nem lahlafef.” Afa eso gwenanam angwafig lahlafena. ");
INSERT INTO amn_n_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Sisas ika pugunam misog elni lala megam sahokana. Afa nangunam nubwel el wewat lufufna enaig wa auguiafna enaba heafgelni afafegim wagfuni. ");
INSERT INTO amn_n_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Afa Sisas esona, “Opuko ahu. Ena naini luwalba mas wahag mo awai, eba isug nongi.” Afa ehem titige watigohna. ");
INSERT INTO amn_n_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Afa mahim opukonaba afa Sisas gwesim sahu ikana. Luwalim wahanamba ningana kehlanamba afa eso luwal bihiana. ");
INSERT INTO amn_n_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Afa ena mo eso ika minefena. ");
INSERT INTO amn_n_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Sisas nanai yi wahia ikana. Ikafnaba sambaganigi noftetini el Sisasim ahune ahkana og, “Nimba Devitna simbianinga afa kam kusguni.” ");
INSERT INTO amn_n_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Enaig esohokafna afa Sisas lala gam sahonaba afa sambaganigi el ehem ningi ahsahonaba afa so Sisas sahtigina og, “Ne ahanaig onigig ahfeg, ne ohonigig ka neana nofugum ma lahlag feawagime awai awaime?” Sambaganigi el esohona, “Ei Ainiyag, eba ne esef!” ");
INSERT INTO amn_n_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Enaig esohonaba eso Sisas ningana nofugum tuhwaganam sihina og, “Enaig eseg nenigina lahlag olug onigig safegba eba nenigina nofugug lahlafeawagig.” ");
INSERT INTO amn_n_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Afa so ehenigina nofug bahiawagena. Afa Sisas kifutig mo faini og, “Nofeka ahsihi enag gafugag ka esegba.” ");
INSERT INTO amn_n_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Afa mas ena mo ahigina ahpahlukuna mo awai, eheba ahka ahsihinaba mungwali el higiwagini ena moba. ");
INSERT INTO amn_n_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Mahim Sisas fwahakafnaba afa mingnag el mo lagig etetig elim Sisas nangum wanig ahuna. Enag elim nimbasa amtakwalig memtog pwakafini. ");
INSERT INTO amn_n_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Afa Sisas nimbasam nunimu faminefena ningihiana. Eso elbi mo wagna, eso elbi mungwali onigifafna. Afa eso enaig esogona, “Hai! Autunaba Israelna bitewaba mas big enaig nangofini mo, awai.” ");
INSERT INTO amn_n_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Afa farisi el esogona, “Nimbasani misog el ehem kigmog faig. Enana kigmog wa nimbasam ningi tigifeule.” ");
INSERT INTO amn_n_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Sisas ahanaig ahanaig kimbig wa fapugufiahkana. Ehe nuwagig lala sahukanam, Godna bog megam lahlag mo sihinuwagena. Afa ehe ahanaig ahanaig gih lahlag fetifeule. ");
INSERT INTO amn_n_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Afa Sisas mungwalim elim nangwagna. El enaig esini ofeg sipsipna yuwigig el hwainig afa etetiagig ahwagikifna. Mungwali onigig etetiagahufna eba mas hefgelni kwaganangiagi. Afa Sisas ehengelim afafena. ");
INSERT INTO amn_n_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Afa eso heafena pahlukuiag elim sihini og, “Enag afwambanai elbi enaig eseg asonai nefganai nubwel goh, afa nubwel gafugag elbi awai enam wambugumba. ");
INSERT INTO amn_n_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Afa so na asona awagim sahinibi eso ma gafugag elim ningitigiba enag heafena nefganai so ma ahu wambu.” ");
INSERT INTO amn_n_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Sisas unenig heafena 12 pela pahluhug el nuwagig eso kigmog faigba so nimbasa ningitigig afa gihinam lahlagim. Ehengelbi kanog hwatig Aposel. ");
INSERT INTO amn_n_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Enag 12 pela Kanog Hwatig el opukog. Ehengelni unehlag enaig: Saimon heafena Grik unehlagba Pita, heafena sumineg Andru, Jems Sebedina leg, heafena etegsumineg Jon. ");
INSERT INTO amn_n_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip, Bartolomyu, Tomas, Matyu, autunam Matyuna gafugag kig wambule, Jems Alfiusna leg, Tadius, ");
INSERT INTO amn_n_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon, autunam ehe ika mo sihiaule, ka mas membeg mo wahigwanai el bigim misog el gohunigim, Judas Iskariot, enag mwauule el. Nengigim Sisasim angoluwag elni ninga wa wahiani. ");
INSERT INTO amn_n_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Sisas enaig 12 pela elim ningitigim, enag ehe mungwalim sihinim, “Nofeka afwambanai elim muhwafen afa nofeka Samariana latui sahu, ");
INSERT INTO amn_n_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","amo, sona Ju nai el mo ahu. Mungwalim enaig eseg sipsip lofug ehengelni yuwigig el awai. ");
INSERT INTO amn_n_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Sona sihiahu ohuna mo, ‘Godna bog meg ati bog afa Godna sawieg big saiyenam eso heafna luwalig agfo.’ ");
INSERT INTO amn_n_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","So na lahlagim, wahag bihagim, gihinam lofug amtakwalig lahlagim, nimbasa ningitigig. Ka nengelim kigmog isug faig enag elim kwaganig isug faig. ");
INSERT INTO amn_n_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nofeka wula wa kig fanugufu. Awai. ");
INSERT INTO amn_n_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mahim ahuafefiba isug ahuiagim. Mangofi wula, mingnag lofug, mong lofug, agat faufiagim. Gafugag el mingnagim kwagani afa ehem soma kwagfwi. ");
INSERT INTO amn_n_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ahnaig ahanaig kembig i so na opukonam so na yisigi lahlag elim. Aman so nem eheafna lala gam wanikig so na eheafna lala mungo gan so na ika. ");
INSERT INTO amn_n_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ne ahu ena lala saiyenam sona enaig mo faigo, ‘God nem lahla fenif.’ ");
INSERT INTO amn_n_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Sina lalanai nem lahlafenagigba, eba neana lahlag mo so ma ehem ginfi. Afa nem kwaganig hwanigba eba ena lahlag mo so na piske faku. ");
INSERT INTO amn_n_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Afa amangel nem masig fatigonigim, afa ena mo higigim kusigbi. Mahim ne ena kimbig wahia ikagim ofefiba so na munginai smof mo bwiabuf. ");
INSERT INTO amn_n_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Amangel so nem masig fatinig eba ehengelnim mugwag amtakwalig pugunif. Autunam Sodom mi Gomora mi so puguni ena kinigim gosenag.” ");
INSERT INTO amn_n_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Sisas enam sihiagena, “Sahig, enaig eseg mawang ninimule sipsipim ogna kwakskofe, afa ka nem ningitigiba eso el nem ogna amtakwalehiagi. So na numwehe nofiagifibi enaig esi wemlo lofug afa gamp lofug afahlanafe. ");
INSERT INTO amn_n_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Numwehe onigfibi afa mingnag el nem ogna wambinim olyi aitigim. Afa enag el heafgelni nuwagig lala saho nem wanahu wena flagflaketifif. ");
INSERT INTO amn_n_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Afa el mas kam membini eso gavmanna nofwa nem hugfuwanfuagim. Eba so na kana lahlag mo sihigoni afa afwambanai elbi so ma higi. ");
INSERT INTO amn_n_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mahim nem wambu aitibi nofeka onignaginim afa ahanaig mo big sihiagif. Afa gwenanam enana mo ne esibi eso God nem faif. ");
INSERT INTO amn_n_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ena moba nimbiafena mo amo, eba awai. Eba God nengelni awagna Sungwag ehe nengelni mengig wa sihif. ");
INSERT INTO amn_n_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Afa el heafgelni nilitem lasefug mingnag elni ninga wa wahig. Afa el heafgelni luwalim enaig esi. Afa luwal heafgelni awagafag mo fafugoni afa so lasefug mingnag elni ninga wa wahig. ");
INSERT INTO amn_n_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Afa ne kana el ofefiba eso mungwali el nem olug kakagegonif. Afa aman kana mom eso hugna kehlag ukuiafiba eba God i yuhwafeg hawagafef. ");
INSERT INTO amn_n_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mahim ahana kimbig wanai nem ahanaig esegonibi enag kimbig wahianam ikagna ahuiagoh afa so ming kimbigam ahu. Mahim Inim El boiba ne mas Israelna mungwali kimbig gafugagba augwi eba awaie. Eba inim.” ");
INSERT INTO amn_n_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Luwal amunaim filafefe afa gafugag el misog elim filafefe, eba awai. ");
INSERT INTO amn_n_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Eso el amunai mi luwal mi gwenaig esgonibi eba so luwalna olug efihlag gohi. Afa gafugag el gwenaig mungwalofug. Afa ka nengelni humoanig fenig. Afa el humoanim sefig Belsebul, eba nimbasana humuan eso ehena luwaligim nalig unehlag amtakwalig faigog.” ");
INSERT INTO amn_n_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Afa Sisas enag esona, “Nofeka elim embefini, awai. Yawaba sisagegoh afa nengigimba enaba ambagwa puguf. Afa ena sisag moba eba mungwali anwanafif. ");
INSERT INTO amn_n_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Afa Ka nem efkwekna mo sihinig so na ahu ambagwa sihi. Afa muhefuna mo ne higig so na ahu mungwali elim ambwaitina sihigon. ");
INSERT INTO amn_n_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Amanba ogna nem tigifati nofeka embefi. Enag el aseg neana sungwagimba tigifati, eba awai. Afa so na Godum embefena. Ehe mungo esef elig ni sungwagni suwi lagig kimbig wa wambu aitif. ");
INSERT INTO amn_n_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Eso ne wesig sambaganingi twafig wesig kigna fig afa mungo twafig mas bite wa pei eba nengelni Humuan mas membeg mo. ");
INSERT INTO amn_n_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nengelbi enaig, God ati nengelni lapogum suwigig. Afa ati nengelnim anwanafenig. ");
INSERT INTO amn_n_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Afa God wesig twafigim membegim nangwaghiage eso nem gaba hugna membenig. Afa eso nofeka embefi.” ");
INSERT INTO amn_n_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Sisas esog, “Afa aman el sihif og, ‘Ka Sisasna el,’ eso ka kikeafena ofwanai Awagim enaig sihinaf, ‘Enaba kana el.’ ");
INSERT INTO amn_n_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Afa aman el mingnag elni nofwa kam mas fatinaiba eso ka kikeafena ofwanai Awagna nofwa ehem ka mas fatinafe. ");
INSERT INTO amn_n_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Nofeka onigi kaba bog enaig eseg mungwali auguiagim bo mo, awai, ka bog esegba el kukohiagig. ");
INSERT INTO amn_n_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Afa mingnag el kana mo fig; Afa mingnag kam mas fatinig enaba fagonai luwaligna humoanigni hefum fafihiagif. Afa enaig esif muwal ango i afag i hefum fafihiagif. Afa kuwag gwenaig esif hefum fafihiagif. ");
INSERT INTO amn_n_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Mungo lalanai hefum mwanagif. ");
INSERT INTO amn_n_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Aman el sambaga onigigna gohug, eso afahumonig luwaligna hugna oniginag afa kamo wesig onigina fenag eba mas kana el auguiafi. ");
INSERT INTO amn_n_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Afa aman el mas pahluhug mo afa hefum li katigeg wa wahagim mas numweheg mo eba mas kana fei. ");
INSERT INTO amn_n_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Afa aman el onigig heafena nofkikenagag aluwegfenam eso hefum nawo sisife eba enaig el mas inim nofkikena fai afa aman ehefum pigaupinam kam pahluku obofiba eba so higeg nofkikena gagflai.” ");
INSERT INTO amn_n_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Sisas heafena pahlukuiag elim esoni, “Aman nem fa lahla ofeflafliba eba ati kam esenag. Afa God kam ningihiag eso aman kam lahla ofeflafliba eba ati ehem esenag. ");
INSERT INTO amn_n_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Afa aman Godna Mo Fa Sihiaule Elim nangugum anwanafeg eso ehem numweheafa eso ma God enag elimbi lahla fiahfai afa eso Sihiule Elim enaig esenag. Afa aman lahlag elim nangugum anwanafeg eso ehem numweheafa eso ma God enag elimbi lahla fiahfai afa eso lahlag elim enaig esenag. ");
INSERT INTO amn_n_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Afa aman kana elim kweafuimba eso God ehem lahla feahfafe. Afa kana el eba unehlag hwainig eso aman el ehem luputug bu faimba eba God mas enag wesig kwefuagimba eteti.” ");
INSERT INTO amn_n_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Afa Sisas heafena 12 pela pahlukuiag elim ena mo sihi wahianim eso enanai wahianam sihiakana. ");
INSERT INTO amn_n_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Mahim Jon buwa aitiag el kalabus lala gafenaba afa eso Krais God Gishu Wahiag El ahanaig ahanaig gafugag esenaba enam mo higina. Eso heafena pahlukuiag elim ningitigina Sisasim nangugum. ");
INSERT INTO amn_n_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Afa ahu opukonam Sisasim sahini og, “Ne naho Jon sihi wahianaba naho ne bog naiba ming elim kagel nengenif.” ");
INSERT INTO amn_n_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Afa Sisas sihini, “Ati ne nangug afa higig eso Jonim piske ahunam sihini. ");
INSERT INTO amn_n_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ati nofug kuhla el bahiaskofeg afa mong amtakwalna lahla fiahsaieg afa lepra elim wangeneg afa ang tetini ati mo higig afa el melig pigieg bigiagafeg afa gawig hwainig el Godna Lahlag Mo higig. ");
INSERT INTO amn_n_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Afa el kam oniginaiba afa heafena olug onigigba kifutig gofofe enaig elba so ma sifakale.” ");
INSERT INTO amn_n_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Mahim ahunaba eso Sisas mingnag elim sihini. Ehe Jonim esona og, “Autunam ne el hwainig wa ahunam eso Jonna mo higini. Ne ahanaig elim noka nangu? El enaig pos lofug fufei petwa fakafefugu enaig ne nangui me? Jonba mang enaig mo. ");
INSERT INTO amn_n_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mang figim ne membig ahu nangug? Ne membig nangug el lahlag nemug lofugna nangu? Jonba mang enaig mo. Eba el lahlag lofugnaba lala lahlag wa ga. ");
INSERT INTO amn_n_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ahnaig esegba ne ahug? Ne Godna Mo Fa Sihiaule El nangug. Ei, Jonba enaig el. Ka nem ini mo sihinig, ohuna elbi mingnag Mo Fi Sihiule Elim gosinig. ");
INSERT INTO amn_n_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Enaig elbi autunam Godna Buk ati sihi wahiana. Enaba God esog; Sahig, Kana mo fakuwiag elim ningihiaiba. Afa ehe Godna Gishu Wahiag elim gosunam eso mina numwehiage ikaf eso ma el kam olug onigini. ");
INSERT INTO amn_n_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Sisas esona, “Ka nem inim mo sihinig Jon buwa aitiag el mungwali autunai elim pugu gosinig. Afa amangel wetiklug saiyeg Godna bog megam enaba Jonim gosunig. ");
INSERT INTO amn_n_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Afa yuwana Jon nai yi pugunam bog yuwanga pugug afa so kifutig el Godna bog megam bagagigim afa kifutig el membeg ogna bagaginim eso fa. ");
INSERT INTO amn_n_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mungwali Godna Mo Fi Sihiule el i afa Mosesna nihe mo i sihig ena mo sihi mang so sumi puguf. Ena moba ati gofena autunam mahimsi Jon fiahfenaba. ");
INSERT INTO amn_n_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Afa ena moba enaig esona Elaijaba piske bogim. Afa aman ena mog moba membegba eso fa, Jonba Elaija. ");
INSERT INTO amn_n_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Afa aman angnaba eba so na higi.” ");
INSERT INTO amn_n_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Afa el yawo auguia enaba ahanaig el eso ka nem luwal lasugum mo sihinig. Mungwali el enaig esig luwal fane suguafogwa auguiaba afa moawag seafa. Afa luwal mingnag luwalim unegoni. ");
INSERT INTO amn_n_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Afa kagelbi afag i wong i guwagibi eso nengel mas ahfe. Afa kagelbi wewatioahba eso nengel mas wegoi. ");
INSERT INTO amn_n_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Afa yawonai el luwal lofug enaig esig eso Jon wainbug i fane i mas nena mo eba ogna Godna unehlagim fingife afa el esoni nimbasa amtakwalig ehem sahu gohna. ");
INSERT INTO amn_n_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Afa mahim ka Inim El bogba afa ka bu i fane i ahgagig eso el esogona, ‘Sa nangu! Ena el bu i fane i ati hugna ahgagini. Ehe kig wambug el i afa ming amtakwalig el i wanaga.’ Ehengel enaig sihififni. Afa Godna lahlag gafugag wagfunig Godna anwana eba inim.” ");
INSERT INTO amn_n_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Sisas mingnag kimbig enaksag Godna kigmog wagfuiagena eso ena kimbig wanai mas heafgelni amtakwalig wahini mo, afa eso Sisas ehengelim fenugena. ");
INSERT INTO amn_n_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Sisas esog, “Korasin wanai el i Betsaida wanai el i nasabanig, afa mangigim ne enaigba nesig. Afa Tair wanai el i Saidon wanai el i nanguiteba enag kigmogum eso ati ne nangug eso autunam heafgelni amtakwaligim hwahite afa kukohiag lofug i smof i eso heafgelni lofugum esiagini enaba heafena kusugogum wagfuni. ");
INSERT INTO amn_n_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ka nem inim sihinig nengegim God kwefihiagenam mungwag faigim. God Tair wanai mi Saidon wanai mi mungwag amtakwalig faigim afa nengelim mungwag amtakwalig numwehe faif. ");
INSERT INTO amn_n_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Afa Kaperneam wanai el, ne onigig koka lahlag el hevengam ahuf. Eba awai. God suwilagig kimbigam nem aitif. Afa Sodom nanguiteba enag kigmogum ne nangug eso Sodom wanai onigig wahigifite eso ma heafena kimbig yawo kwesegofite. ");
INSERT INTO amn_n_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ka nem inim sihinig nengegim Sodom wanai God kwefihiagenam mungwag amtakwalig faigim afa nengelim mungwag amtakwalig numwehe faif.” ");
INSERT INTO amn_n_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Afa enanam Sisas Godum sihina og, “Humuan, ne heven wanai i bite wanai i Ainiyag el goh. Ka nem lahlag onag. Afa enag inim mo ne anwana elim kumohwanig afa ne etetig elim enag inim mo meagwanai eseg ambagwa opugug. ");
INSERT INTO amn_n_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ei, Humuan enaba nimbiafena lahlag onigig ne eseg. ");
INSERT INTO amn_n_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Kana awag kam mungwali gawig faig. Afa el mas Godna legimba anwanafig mo. Humuan mungohe ena luwalimba numweheg anwanafeg eso ena luwal humuanim numoheg anwanafenag eso aman elim wegifwatigim awagim wagfunig. ");
INSERT INTO amn_n_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Afa nihe mo el kifutig gafugag nem faigog. Afa amangel eso yingmung fiahsaieg, aubo, ka so neana kinig flafatinif. ");
INSERT INTO amn_n_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Afa ne kana mom skaugfenibi eso ka nem wagfunibi so na kana gafugag anwanafi. Afa kaba mang hugunam fenugeah mo eba ka kikefum skaugfeg eso ne hekulia fafim. ");
INSERT INTO amn_n_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Afa ohuna gafugag ka nem faigbi eba hefeg afa mas kinig mo.” ");
INSERT INTO amn_n_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Afa enanam eba Isug Auguiag Osunaba Sisas aso gam ikana. Afa heafena pahlukuiag el binipiginaba eso ehengel asonai wambu ahagigim ofifinibi. ");
INSERT INTO amn_n_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mahim farisi el enam nangunim Sisasim og, “Sa nangu, neana pahlukuiag el bigelni Isug Auguiag Osuna nihe mo flafug.” ");
INSERT INTO amn_n_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Sisas sihini, “Amo, enag el mas flafug mo. Mas ne suwigni mo ahanaig eso Devit eseg? Mahim Devit heafena el binipigibi. ");
INSERT INTO amn_n_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Afa ehe Godna lala sahunam eso ehe heafena el amba Godum faig wanena. Nihe mo sihi pris mungo so enamba ahagai. Devit heafena elim fafo wanena. ");
INSERT INTO amn_n_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ateaho ne Mosesna nihe moba anwanafig afa Isug Auguiag Osuna enaig eseg prisba Godna Nalig Lala wa gafugafifini. Afa ehe mo Isug Auguiag Osuna nihe mo fafuni eso God ehem esoni og, ‘Ne mas mang fig mo.’ ");
INSERT INTO amn_n_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ka nem sihinig aman so go, Godna Nalig Lala goseg. ");
INSERT INTO amn_n_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Godna mo sihig; Ka mas sis faigiba membeg mo, ka membeg ne elim afafegoni. Ati ne ena mog mo anwanafigbi ne mas enag elim fegonigi ahanaig eseg hwainig. ");
INSERT INTO amn_n_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Eso Inim Elbi eba Isug Auguiag Osuna misog el.” ");
INSERT INTO amn_n_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Sisas enanai wahia ikanam nuwagig lala puguna. ");
INSERT INTO amn_n_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","El ninga amtakwalna gafena. Mingnag el ogna Sisasna amtakwalig nihem yisigi nangunim eso mingnag elim mo faigo. Ehem sihini og, “Ateaho bigelni nihe mo esog so enaigba yuhwafei elni gihim Isug Auguiag Osuna lahlafefati?” ");
INSERT INTO amn_n_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Afa ehe sihini, “Amana tata mime wa Isug Auguiag Osuna peiba. So na ahnaig esef? Eba ne fwaklafatif. ");
INSERT INTO amn_n_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Eba el tatam gosunig. Afa bigelni nihe mo esog eso ma bigel Isug Auguiag Osuna lahlafefati.” ");
INSERT INTO amn_n_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Afa Sisas elim sihina og, “Ninga susnufiafo.” Mahim ninga susnufiafonaba eso ehena ninga lahlafena gwenai ming ninga mungwalofug. ");
INSERT INTO amn_n_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Afa farisi el wahinim sihiagini ogna Sisasim tigi. ");
INSERT INTO amn_n_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Afa Sisas ena mom higinam eso nanai wahia ikana. Afa nub el sum pahlu ahuna eso Sisas mungwali gih elim lahla fetifena. ");
INSERT INTO amn_n_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Afa Sisas kifutig mo faini og, “Nofeka mingnag elim sihigon.” ");
INSERT INTO amn_n_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ehe enaig eseg Godna mo ambagwa opugug. Autunam mo faule el Aisaia Godna mo faini. ");
INSERT INTO amn_n_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ehe enaig esog; Eba gafugag el ka kanog wahiag. Ka ehem hugna membenagim afa sifakalenag. Kikiafena Sungwag ka ehem faif eso ehe mungwali elim lahlag nihe mo sihinugef. ");
INSERT INTO amn_n_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ehe mas ahanaig esei afa mas ambwatina fei. Ehe mas mo hugna ambagwa sihi. ");
INSERT INTO amn_n_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Bwei mas kifutig mo ehe enam mas toawagi afa suwi wesig wagi ehe mas fufulufakai. Ehe enaig eseaka enai yuhwafegba ehe lahlag nihe obug pugug. ");
INSERT INTO amn_n_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Afa afwambanai el nengeafufiba eso ma kwagani. ");
INSERT INTO amn_n_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","El mungo nimbasa esinagana mas mo lagwage afa nof tetina. Enaig elim Sisas nangum wanig ambugona. Afa eso Sisas ehem ati lahlafatinaba eso nofug lahlafatifena afa mo lagana. ");
INSERT INTO amn_n_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Afa mungwali sineminefini afa esogona og, “Ena elbi Devitna simbianinga me awai awai me?” ");
INSERT INTO amn_n_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Afa farisi el higinim ena mom afa esogona, “Amo, ehe Belsebulni kigmog wa nimbasa amtakwaligim ningi tigifiaka. Belsebul eba nimbasana misog el.” ");
INSERT INTO amn_n_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Sisas ehengelni onigigim ati anwanafeni esona og, “Amo, neba etetig, amangel kantri kwefihiagim eso hefum hagfe eba ena kantri amtakwalef. Afa kimbig i mungo lala nai i hefum hagfe eba gwenai esef amtakwalef. ");
INSERT INTO amn_n_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Satan heafena gafugag elim amtakwale aitiba eso hefum pwatihiagif. Afa pwatihiaginim afa eso mang so Satan nangwagihiagef eba enag tigefupef. ");
INSERT INTO amn_n_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ne onigi ne esogog ka Belsebulni kigmog wa nimbasam ningitigifiaka. Afa inimba eso aman neana elim kigmog faif? Eso nimbiafena el wagfuf neana onigig amtanafeg. ");
INSERT INTO amn_n_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ka Godna Sungwagni kigmog wa nimbasam ningitigifiakaba eso ne anwanafi Godna bog meg enag ati pugug. ");
INSERT INTO amn_n_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Ahnaig esenam eso el sahukanam kifutig elni lala gawig ugwefef? Afa yawo ehe kifutig elim so wena kikenagegim eba so lalanai gawig ugwefe. ");
INSERT INTO amn_n_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Aman kamble i ahgohug hwanigba enag elbi eba kana angoluwag. Aman kam wambugum kwegfwag hwanigba eba taitufeule el. ");
INSERT INTO amn_n_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Afa ka nem sihinig ahanaig ahanaig nihe amtakwalig afa amtakwalig mo Godum esini, eba ma God elni amtakwaligim fafatinif. Afa aman amtakwalig mo Godna Sungwagim esinibi eba God mas enaigim fafatini. ");
INSERT INTO amn_n_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Afa aman amtakwalig mo Inim Elim esonaiba, eba God ma enam amtakwaligim flafatinif. Eso aman amtakwalig mona Godna Sungwagim esonaiba eba yawo afa nengigim God mas enam amtakwaligim fafatinai.” ");
INSERT INTO amn_n_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Li figetni fug lahlag afa li ambieg eba fug amtakwalig. Afa fug ahanaig afa li gwenaig. ");
INSERT INTO amn_n_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ne sombine lofug! Nengel amtakwalig el eso nengelni mo sihi enag mas nugweg mo. Mang so onigig wa go enam elbi mo sihif. ");
INSERT INTO amn_n_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Lahlag el nugweg onigigim kehlagim eseg. Afa amtakwalig el amtakwalig onigigim kehlagim eseg. ");
INSERT INTO amn_n_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Ka nem sihini ma God kwefihiagenam mungwag faif ehe kwefihianigef mungwali elni ahanaig ahanaig isug mo. ");
INSERT INTO amn_n_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ahnaig mo so na sihig eba God nem kwefihiagefe afa ne lahlag me awai awai me.” ");
INSERT INTO amn_n_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Farisi i afa nihe mo anwanafeg el i Sisasim sihini og, “Tisa, kagel membeg koka neana kifutig wagfuiagim nangui. Eso kagel anwanafi God nem kigmog faig.” ");
INSERT INTO amn_n_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Sisas sihi og, “Amtakwalig el afa Godum mas onigini afa enaig el membeg kigmog ogna nangu. Afa ka mas nem kigmogim wagfunug mo. Afa mo faule el Jonana kigmog so na nangu. ");
INSERT INTO amn_n_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Afa sambaga mungo osuna afa sambaga mungo sinaini Jona nalig sawugna atag wa sahugini. Eso gwenaig esef Inim Elbi sambaga mungo osuna afa sambaga mungo sinaini bite megam sahugif. ");
INSERT INTO amn_n_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Afa nanam God kwefihianigef afa Ninivenai el bigiagafenam eso nengelim setigifi. Ehengel Jona na mo higinim eso heafgelni amtakwalig nihe masigim fatini. Ka nem sihinig aman so go eso Jona gosenag. ");
INSERT INTO amn_n_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Afa nanam God kwefihianigef eba saganai bitenai Kwin bihianam eso nengelim setigifi. Heafena wahigam kimbig wahia bonam eso Solomon na lahlag mo higina. Ka nem sihinig aman so go Solomon gosenag. ");
INSERT INTO amn_n_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Mahim nimbasa elim wahia ikanam ehe bu hwainig bitegam ikanam gagim yisigife afa mas ufag mo. ");
INSERT INTO amn_n_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Hefum esog, ‘Ka piske kiafena lala gam ika.’ Afa piske bo pugug ehe nangu ena lala isug go afa afwambusig go afa ati numwehiageg. ");
INSERT INTO amn_n_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ehe ika nimbasa elegeg wa gohug ena wanbog. Ena nimbasa hugna amtakwalig ahu saiyegim agfo. Yuhwona el gwenag fena afa glauaba hugunam amtakwalig. Eba nengelim amtakwalig elim gwenaig pugunif.” ");
INSERT INTO amn_n_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Afa mahimsi Sisas mo sihi gofenaba heafena afagna sumini puguna ambugog afwambawa agfofenaba ogna Sisasim sihini. ");
INSERT INTO amn_n_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mungo el Sisasim sihina, “Nana afagna sumini puguna agfoahe ogna nem sihini.” ");
INSERT INTO amn_n_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Afa Sisas wahigif sihina, “Aman kana afag? Aman kana nilite?” ");
INSERT INTO amn_n_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ehe heafena pahlukuiag el ninga bulni sufini esona og, “Sa nangu, ohuna el kana afagna nilitenaba. ");
INSERT INTO amn_n_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Aman kana heven wanai Awagna sawiegim esofefiba eba kana afag, nilite, mulwal nemug.” ");
INSERT INTO amn_n_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ena osuna Sisas lala wahianam ikana bu blugyi pugunam ogna wagfufenuge. ");
INSERT INTO amn_n_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Afa nubwel el Sisasim olyi fatini eso ehe bot wa ika peganam mungwali bu blugyi agfohiafena. ");
INSERT INTO amn_n_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Afa Sisas enaksag waskwes mo sihini og, “El enai eseg kon kug asowa aitiageg. ");
INSERT INTO amn_n_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Aitiage ika afa mingnag kug mina wa apaigoiba afa twafig ambugog apaiyegim wambugafig. ");
INSERT INTO amn_n_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Afa mingnag mo funkisigig yi apaiyenam ikagna puguiageg. Eba bite mas hugna pegag mo. ");
INSERT INTO amn_n_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Mahim osu puguba eso aptukwahla skofeg. Afa bigag mas apaigo eba pigif. ");
INSERT INTO amn_n_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Afa mingnag mo usieg weg amtakwalig wa apaigo. Afa usieg pugugum eso kikeg. ");
INSERT INTO amn_n_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Afa mingnag mo lahlag bite wa apaiyegim fugleg. Mingnag 100, mingnag 60, afa mingnag 30 enaig puguiageg. ");
INSERT INTO amn_n_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Aman angnaba eba so na higi.” ");
INSERT INTO amn_n_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Afa pahlukuiag el Sisasim ambugog sahini, “Ahnaig ese ne elimbi waskwes mo sihini?” ");
INSERT INTO amn_n_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Afa wahigif sihini, “Enag moba Godna nangwaghiageg autunam God mas elim sihinig afa yawo eba ati nem mog mo opugugnig afa enag mingnagim mas anwanafini mo. ");
INSERT INTO amn_n_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Aman ati mang fegba eba God ehem faiba eso enaksag fef. Aman el enaig hwanigba eba God ehena wesig fafatif. ");
INSERT INTO amn_n_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Okwenag el nofna nangug afa mas numwehe nangug mo. Afa angugna higigim eba mas numwehe higig mo. Afa mas numwehe anwanafig mo. Enaba inim nasaka ena waskwes mo sihig. ");
INSERT INTO amn_n_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Aisaia mo fi sihiahug el sihinaba ena elbi ena mom inim esini; Ena elbi higahufenaba afa mas anwanafini mo. Afa nanguahufenaba mas numwehe nanguini mo. ");
INSERT INTO amn_n_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Afa ehengelni misog oniginagig mas afwambuseni mo afa ehengelni angug titie skofena afa nofug kohla skofena. Afa ena nihem pahlukuiagba eba God sihig ehengelni angug ati higig, afa nofug ati nangug, afa olug onigig ati anwanafig. Afa ka nangum ati wahigi ambugog enaig esigbi eba ka wangenefe aitif. ");
INSERT INTO amn_n_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Afa Sisas esoni, “Sa sifakali nengelni angug ati ne higig afa nofug ati ne nangug. ");
INSERT INTO amn_n_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ati ka nem sihini mang ati ne higigim afa nangug enaksag lahlag el afa mo fi sihiahug el ogna higinim afa nangu eso ehengel mas higinim afa nangui.” ");
INSERT INTO amn_n_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Sahig sona anwanafi ohuna waskwes mog mo kon kug aitiageg. ");
INSERT INTO amn_n_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Amangel Godna bog meg mom ati higigim afa mas anwanafig mo eba enaig eseg kon kug mina wa apaiyeg. God ena mo olug yi aitig afa Amtakwalig El eba Satan bo wambug. ");
INSERT INTO amn_n_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Afa kon kug funkisigig yi apaiyeg eba enaig eseg el Godna mo higigim ikagna sifakale fag. ");
INSERT INTO amn_n_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Eba kon bigag lofug mas pekag mo. Eba makwalig gohogum awaieg. Eba mahim ehena olug Godum oniginagba eso mingnag el ehem kinig i afa nunimu mo i faigba. Eba ehena onigig tigefupef. ");
INSERT INTO amn_n_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Afa kon kug usieg weg wa apaiyeg eba enaig eseg el Godna mo higigim afa heafena gagim onigigim afa ehe hugna kigim onigka. Eba ena onigig bonam kike fakag. ");
INSERT INTO amn_n_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Afa kon kug lahlag bite wa apaiyeg eba enaig eseg el mo higigim afa anwanafig. Eba fug eso enaig lugufeg mingnag 100, mingnag 60, afa mingnag 30.” ");
INSERT INTO amn_n_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Sisas ming waskwes mo sihina og, “Godna bog meg enaig eseg eba el lahlag kon kug asowa aitiageg. ");
INSERT INTO amn_n_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Afa mahim sinaini el askaba eba el amtakwalig bogim afa lanuwe amtakwalig kon wa taitufiakag. ");
INSERT INTO amn_n_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Mahim kon fug oluguba eso lanuwe nahlum wahe pugug. ");
INSERT INTO amn_n_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Afa gafugag el asona awagim sihini og, ‘Ati ne lahlag kon kug aitiagegba afa yuwamo enaksag lanuwe amtakwalig puguiagego.’ ");
INSERT INTO amn_n_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ehe sihi, ‘Amtakwalig el enaig eseg!’ Afa gafugag el sihi, ‘Ne og kagel lanuwem fagahiagife?’ ");
INSERT INTO amn_n_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Afa ehe sihi, ‘Amo, nofeka lanuwe fagahiagi eba masa na kon nahlum fagaitifif. ");
INSERT INTO amn_n_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Sa wahiyi, ma wahe pugunam ma kon fug luwiba eso ma gafugag el wambu. Enanam ka gafugag elim sihinibi eso ma lanuwe fagahiaginim wena kike skofini wehlagi. Wehlaginim eso ma kon mo wambugini eso ma kana fane lala sugum.’” ");
INSERT INTO amn_n_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Sisas ming waskwes mo sihina og, “Godna bog meg enaig eseg eba el aso wa lifug fatigba. Ena libi mastet. ");
INSERT INTO amn_n_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ena li fug wetiklug afa mahim pugugba enaba naligfegim mingnagim asonai fanem kwaganangeg. Eba li lofug kugum eso twafig gag kagagwa nimbagig.” ");
INSERT INTO amn_n_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Sisas ming waskwes mo sihina og, “Godna bog meg enaig eseg angwafig yist amba wa kokofegim ambam nahlum waheg. Yistba enaba smof lofwag ambam nana pipki. Enaba wesig fegim afa naligfeg.” ");
INSERT INTO amn_n_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ohuna mungwali mo Sisas waskwes mo sihig. Ehe mas ambagwa sihina mo afa mungwali mo ehe waskwes mo sihini. ");
INSERT INTO amn_n_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ehe enaig eseg Godna mo ambagwa opugug. Autunam mo fi sihiahug el sihini og; Ka waskwes mo sihiagim. Afa mang so autunam meagam sahugo bite puguia hwainig fiafenaba eso ka sihif. ");
INSERT INTO amn_n_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Afa Sisas wasanam ika lala sahu ikana. Heafena pahlukuiag el ambugog sihini og, “So na kagelim lanuwe waskwes mog mo sihin.” ");
INSERT INTO amn_n_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ehe wahigi sihini, “Ena elbi lahlag kon kug aitiageg eba Inim El. ");
INSERT INTO amn_n_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Afa aso eba mungwali bite, afa lahlag kon kug eba el Godna bog megam sahuagfo. Afa lanuwe amtakwalig eba Satan na el. ");
INSERT INTO amn_n_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Afa amtakwalig el lanuwe aitiageg eba Satan. Mahim nefgenai wambugum ofefiba eso enanam mungwali awaief. Afa gafugag el eba ofwanai el. ");
INSERT INTO amn_n_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Enaig el pos amtakwalig agogloiagigim so suwi wa tuhlu mahim eba gwenaig esef enanam mungwali awaief. ");
INSERT INTO amn_n_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Inim Elbi heafena ofwanai el ningitigiba eso ahuf. Ehengel ahu saiyenam fahigiagife Godna bog meg wa. Eso mungwali mang i amtakwalig eseg afa amtakwalig el mi eso numwehwaginim. ");
INSERT INTO amn_n_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Eso suwi nalig wa wambu aitif. Enana yi eyu watunam gog kike skofefe. ");
INSERT INTO amn_n_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Enanam lahlag el osu lofwag laukwag skofefe saiyenam heafgelni Humuana bog meg gam. Aman angana eba so na higi.” ");
INSERT INTO amn_n_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Godna bog meg enaig eseg enaksag kig lofug bite wa sahu go. Eso el bumekokogim nangugum ehe piske titi wahiag. Eso sifakalegim ikanam eso heafena gawig faigim eso ena bite ati fag.” ");
INSERT INTO amn_n_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ohnaba ming Godna bog meg waskwes mo. Eba enaig eseg el membeg oka kopu lahlag yisigi. ");
INSERT INTO amn_n_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Afa mahim hugna lahlag kopu yisgegoba eso heafena mungwali gawig faig eso ena kopu ati fag.” ");
INSERT INTO amn_n_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ohnaba ming Godna bog meg waskwes mo. Eba enaig eseg fufwala nalig el buwa fatinam eso ahanaig ahanaig sawug ati wambina. ");
INSERT INTO amn_n_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Mahim fufwala wa memtowa pugunaba bu blug yi skogofena. El gafenaba eso sawug kwefskofena. Sawug lahlag sob yi fatiafena afa sawug amtakwalig fafenam fatiafena. ");
INSERT INTO amn_n_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Enanam mungwali awaieba enaig eseg enaba sawug lasugum sihig. Afa amtakwalig el i afa lahlag el i mungwali wahegofenaba. Eso ofwanai el ikanam amtakwalig elim wambinam aitina. ");
INSERT INTO amn_n_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Afa suwi nalig wa wambinam aitif. Enana yi eyu watunam gog kike skofefe.” ");
INSERT INTO amn_n_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Sisas sahtigina, “Ateaho ne ena momba anwanafig.” Heafena pahlukuiag el piske sihi, “Ei, kati anwanafig.” ");
INSERT INTO amn_n_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Afa ehe sihini, “Enag so nihe mo anwana el, Godna autunam mom anwanafeg afa ehe Godna yawonai bog meg mom enag mungwali anwanafe auwageg. Eba enaig eseg el gawig lala sahu ikanam afa yawonai gawig afa autunai gawig eso wambogif.” ");
INSERT INTO amn_n_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Afa Sisas ena waskwes mo enana yi wahiana. ");
INSERT INTO amn_n_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Afa heafena kimbig gam piske ikana. Ehe nuwagig lala wa mo sihinigena afa mungwali higinim so sineminefini. Ehengel sahini, “Aman mahim ehem anwanafeg kigmog faig? ");
INSERT INTO amn_n_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Bigel anwanafini heafena awag lala nimblaule el. Sinaba ehena legho mahim? Sinaba Mariana legho mahim? Ati big anwanafig Jems, Josep, Saimon, afa Judas heafena sumineg pugug. ");
INSERT INTO amn_n_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Heafena muwalig mungwali big auguia. Ahana nai yi mahim ehe enaba anwanafeg kigmog fag?” ");
INSERT INTO amn_n_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Afa eso ehengel mas ehem sifakalini mo. Afa Sisas sihini og, “Afa mungwali el sihig, mo fi sihiahug el eba misog el. Afa heafena kimbig wanai afa heafena nilite ehem mas higini mo.” ");
INSERT INTO amn_n_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Afa mungwali ehem mas olug onigini mo eso enanai yi Sisas mas kifutig gafugag esena mo. ");
INSERT INTO amn_n_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Enanam Herot Galili nai misog el higina Sisasna kifutig gafugag puguna. ");
INSERT INTO amn_n_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ehe heafena elim sihini, “Eba Jon buwa aitig el afa piske bihia, eso ehe enaig kigmog kifutig gafugag esena.” ");
INSERT INTO amn_n_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Afa Herot ena onigina eso heafena suminegna angwagim fana. Autunam Herodias Filipni yi gana. Jon Herotim esona, “Eba amtakwalig suminegna angwafig fagba.” Afa Herot heafena elim sihini, “Jonim kikehlinim eso lala meg gam wena sumil yi kiki wahiyi.” ");
INSERT INTO amn_n_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herot membena Jonim tigi afa enaig esegba ka Ju elim embefinig. Eso Ju el onigini Jon eba mo fi sihiaule el. ");
INSERT INTO amn_n_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Afa mingnag el ambugog kuhlunim afa sifakalini afag enaig osuna Herotim fokwana. Herodiasna legba naini ehe bihianam elim olyi ilani. Herot nangunam sifakalena. ");
INSERT INTO amn_n_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Eso Herot angwafigim moamo sihina wahianam, “Mangim ne membeg sona kam sahna ka ne faif.” ");
INSERT INTO amn_n_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ena angwafig afagna onigigim pahlukuna. Afa sahna og, “Ka membeg yawo Jon buwa aitig elna misog sob yi fakanam kam bu fai.” ");
INSERT INTO amn_n_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Afa mungwali el misog elni mom higinim eso ehengelni olug kinig. Afa heafena gafugag elim esoni sesi. ");
INSERT INTO amn_n_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Eso ehe elim ningihianaba afa eso ikana Jonna wunehligim hige faitina. ");
INSERT INTO amn_n_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Afa ena misog sob yi fatinam fa bona eso angwafigim faina afa ehe fanam afagim oku faina. ");
INSERT INTO amn_n_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jonna pahlukuiag el ambugonam afa eso elig bihig figagfo kumohlini afa so Sisasim ena mom sihini. ");
INSERT INTO amn_n_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Mahim Sisas ena mo higinam ehe enanai yi wahianam afa bot wa hefwaimu bite bihigam ikana. El ena higinim afa kimbig wahianam eso biteamina ahuna sum. ");
INSERT INTO amn_n_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Sisas bu blug yi pugunam afa nubwel elim nangwagina afafenim afa gih elim lahla fetifena. ");
INSERT INTO amn_n_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Mahim osu pegim ofefenaba afa heafena pahlukuiag el ambugog ehem sihini og, “Osu ati ope afa ohuna biteba lala hwainig. Ohonana so na ningitigi kimbig gam soma ahui fane yisgiawogi.” ");
INSERT INTO amn_n_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Sisas sihini og, “Ehengel mungwali ohunanai yi auguiagim. Nengel so na fane faigo.” ");
INSERT INTO amn_n_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ehengel ehem sihini, “Ambaba afawa gohug afa sawugba sambaga enaig ohonaba afogwa.” ");
INSERT INTO amn_n_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Afa ehe sihini og, “Kam osum wambina.” ");
INSERT INTO amn_n_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Sisas esoni mungwali pos wa apaigo augu. Ehe ambaba afawa gohug enaig wambinam afa sawug sambaga wambtiginim eso ofgam nof fena afa Godum lahlag onanam. Eso ehe kosko fenam eso heafena pahlukuiag elim faini. Pahlukuiag el finim afa eso magiauwagini. ");
INSERT INTO amn_n_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mungwali ahgawaginim afa yuhwafei skofena. Pahlukuiag el fane piske wambini afa 12 sob yi aitinim afa sob yi memtowa puguia skofena. ");
INSERT INTO amn_n_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Enanam 5,000 kwamblo ati ahgawagini afa angwafig i luwal i mas suwigini mo. ");
INSERT INTO amn_n_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Afa Sisas pahlukuiag el kifutig mo faini eso bot wa gof ahu ehegam maligim. Eso ehe mingnag elim sihini og, “Piske lala gam ahu.” ");
INSERT INTO amn_n_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ati sihinigenam eso ehe mungo kukana mug gamba ogna Godum sihina. Sikuleofe fenaba ehe mungo gofena. ");
INSERT INTO amn_n_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Enanam bot mahim wahigam ikanaba. Fufwei nalig bona botim minam gofa pahlana afa bu botim fingi fingi fiafana. ");
INSERT INTO amn_n_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Mahim ohugukafnaba Sisas bu sisi bo pahlukuiag el nai yi muhwa opugufena. ");
INSERT INTO amn_n_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Mahim Sisas bo afenaba afa pahlukuiag el nangunim embembe fiaginim esogona og, “Sonaba ifaf obo!” Eso ehengel eyu watigona. ");
INSERT INTO amn_n_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Afa so Sisas ikagna mo wagna og, “Nofe ne embefi, eba kaho. Sa olug efihlag fi.” ");
INSERT INTO amn_n_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Afa Pita esona og, “Ainiyag, eba neaho? So na kam sihinaiba keso neanangum bu sisyi bo.” ");
INSERT INTO amn_n_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Afa Sisas ehem sihina og, “Sa bo.” Eso Pita botim wahianam pe bu sisyi Sisas nangum ikana. ");
INSERT INTO amn_n_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Afa ehe bifwatim nangunam embefena eso ehem bu meg gam pe akofnaba eso Sisasim unena og, “Ainiyag, kam kweagfu!” ");
INSERT INTO amn_n_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Eso Sisas ikagna Pitam ninga na kikehlanam eso ehem sihina og, “Nana olug onigi wesig, Ahnaig esegba so na sambaga onigigba fag?” ");
INSERT INTO amn_n_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Afa mahim bot wa ahfukunaba eso bifwat awaiena. ");
INSERT INTO amn_n_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Afa bot wa auguiafnaba Sisasna unehlagim fingi finim esogona og, “Eba inim nemug ne Godna leg.” ");
INSERT INTO amn_n_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Afa so wankana bu mo koflakanam ika ehgam Genesaret kimbig wanpuguna. ");
INSERT INTO amn_n_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Mahim wanpugunaba eso Sisasim nangunim anwanafini. Eso mo sihiagahuna mingnag kimbig gam og ma gih elim Sisas nangum wanambugo. ");
INSERT INTO amn_n_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Afa Sisasim hugna sahani gih elim hwatiba og ma ehena lofug meigim tuhwibi. Amangel enaig esibi eso ehengelim lahla feskofefe. ");
INSERT INTO amn_n_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Enanam mingnag farisi el afa mingnag Mosesna nihe mo anwanafeg el Jerusalem wahinim ambugoguhna Sisas nangum afa sahini og, ");
INSERT INTO amn_n_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ahnaig esegba eso neana pahlukuiag el fane ahagaba, ehe mas buwa ningam suwagi eso autunam simbianinga wagfugoni, afa ehe simbianingana nihe flafug.” ");
INSERT INTO amn_n_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Sisas wahigi sihini, “Neagaba nimbiafig elni nihe ne goseg oghug afa Godum nihe mo ne flafug. ");
INSERT INTO amn_n_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Afa God esonig ‘So na nimbiafna afa humoanigim eso ahnai skaug fegonim’ afa ming mo enaig esog, ‘Afa aman awag mi afag mi amtakwalig mo faigba eba tigibi eso ehem wahaf.’ ");
INSERT INTO amn_n_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Afa ne esog afa aman el gawig nubwel fegba eso ma awag mi afag mi kwagani, afa ehe esog, ka mas ne kwagani afa ohonaba gawigba Godum ka faig.” Farisi el onigig ohonaba lahlag nihe. ");
INSERT INTO amn_n_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","“Mahim aman enaig esegba ehe mas awagim ahnai skaug fenag mo. Afa enaig mina feg Godna nihe mo sum fatigim afa nimbiafna nihe mo mo ne goseg oghug. ");
INSERT INTO amn_n_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nengel sambaga mengigna el. Nimbiafgelni mom autunam Aisaia ati sihi wahiana, eba inim. Ehe enaig esona, ");
INSERT INTO amn_n_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","God sihi; Sohna elbi mengigna kana unehlagimba figifig afa olug onigigba enmunam agfoahe. ");
INSERT INTO amn_n_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ehe wagfugonug elni nihe mo afa ena moba seflifinim Godna nihe mo. Eso enag elbi kam mungwinim lotu finig.” ");
INSERT INTO amn_n_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Afa Sisas elim uneni ka nangum ambegoh afa esoni og, “Ne higinim so na anwanafi! ");
INSERT INTO amn_n_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Mang so na mengna negba, eba mas elim nuhwefiyi enag mo, amo eba awai. Eso mang mengmenai pugug eba naho elim kwenag Godum lotu fenagim.” ");
INSERT INTO amn_n_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Afa pahlukuiag el Sisasim ambugog sihini og, “Ateaho ne anwanafeg farisi enag mo higigim afa olug kakage skofena?” ");
INSERT INTO amn_n_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ehe piske sihini, “Mungwali gau kana heven wanai Humuan mas suguageg mo eba so fagahiagefe. ");
INSERT INTO amn_n_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Sa hwati, sonag elbi nofseleni el. Ehe ming nofseleni elim ningana kehla kunam afa ahkanam eso mime wa ahpef.” ");
INSERT INTO amn_n_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Afa Pita ehem sihina og, “Sa kagelim numwehe sihini enag waskwes mog mom.” ");
INSERT INTO amn_n_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Sisas sihini, “Ateaho, ne kana pahlukuiag el ne mas yuhwafig mo? ");
INSERT INTO amn_n_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mas ho ne anwanafig mo? Mang so el negim ehnogam pekagim eso atam ikag. ");
INSERT INTO amn_n_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Afa mang so olug onigig wanai gohugum afa eso mengig wa puguiageg. Eba naho elim nuwehfinag. ");
INSERT INTO amn_n_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Afa amtakwalig onigig oluginai pugug eba enaig eseg: aisilni tigeg, angwafig kehlag, aga taituna, okwefna fag, mang mo, moalamp mo. ");
INSERT INTO amn_n_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Enaig niheba naho elim nuwehfinag. Afa el mas ninga buwa suwage ehe fane negba eba mas nuhwefig mo afa Godum lotu fenagim mas kwenag mo.” ");
INSERT INTO amn_n_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Sisas enanai yi wahianam ika Tairnai yi afa Saidonnai yi kimbig muhwa ika puguna. ");
INSERT INTO amn_n_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Afa angwafig mungo Kenan wanai enanai yi gafena enag bonam Sisasim unena og, “Ainiyag, Devitna simbianinga kam afafena. Nimbasa kana naini luwalim amtakwalenageg.” ");
INSERT INTO amn_n_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Afa Sisas mas ehem wahigi wagna mo. Afa heafna pahlukuiag el ambugogfenaba sihina og, “Piske ningihia makai afa angwafig sum une bofena.” ");
INSERT INTO amn_n_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Sisas sihina, “Eba God kam ningihiagba na kam bog Israelnai elim sipsip lofug awaiegba enam ka kwaganig. Neba neaga afwambanai el.” ");
INSERT INTO amn_n_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Afa angwafig bo Sisasna kig muhwa penam sahna, “Ainiyag, so kam kweagfu!” ");
INSERT INTO amn_n_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Afa Sisas piske sihina, “Naiba mas ihlafegmo luwalna fane mawangim aitigonuba.” ");
INSERT INTO amn_n_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Angwafig sihina, “Ei, inim ne sihina. Afa mawangba awagna sime skaunai ogug fanef.” ");
INSERT INTO amn_n_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Sisas wahigi sihina, “Angwafig, neana olug onigigba numweheg. Mang so na membeg eba puguf.” Gwenanam luwalim lahlafena. ");
INSERT INTO amn_n_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Sisas enanai wahianam Galili bu ehembeg mina ika pugunam afa mug wa fukogafena. ");
INSERT INTO amn_n_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nubwel el ambugog Sisasim nanguni. Eso enag el wambug ambugona mong waikefona, nofseleni, mong ninga lilina, mo tetini, afa mingnag gih el afa so Sisas nai yi mong muhwa wasani. Afa so Sisas lahlafetifena. ");
INSERT INTO amn_n_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Afa nanguni, mahim mo tetini mo sihiagini, mong waikefona lahlafe skofena, mong lilina ahuna, afa nofseleni bahia skofena eso mungwali Israelna Godum fingifini. ");
INSERT INTO amn_n_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Sisas heafena pahlukuiag elim awamonim og, “Ka ohuna elim afafenig, eso sambaga mungo osuna kam waniafag afa fane awai. Kam isug ningitigiagim kusig masa bini pigif, afa mina wa ahuian kilale apaigof.” ");
INSERT INTO amn_n_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Pahlukuiag el ehem sihini og, “Ohnaba bite fane hwainig. Hana so big fane amba finim eso big ohuna enaksag elbi faigof.” ");
INSERT INTO amn_n_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Sisas ehengelim sahini, “Ahanansi bret ne skug?” Afa esogona, “Ka bret elegeg wa gohug afa mungo mungo wesig sawug, enaig ka skug.” ");
INSERT INTO amn_n_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Sisas mungwali elim esoni og eso bite wa apaigo auguiaka. ");
INSERT INTO amn_n_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Afa so bret elegeg wa gohna afa sawug enag wambinam. Afa Godum enaig esona ohonaba lahlag ka nem lahlag onag. Sihi wahianam eso bret i sawug i kukoskofenam, afa pahlukuiag elim fainiba eso mungwali elim mimangegoni. ");
INSERT INTO amn_n_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Afa ahgaginim eso yuhwafei skofena. Afa mingnag bret mo gwese afgokufna eso piske lambogini elegeg wa gohna enaig sobini memtowa puguia skofena. ");
INSERT INTO amn_n_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Kwamblogba enaba ahaganamba 4,000 kwamblo. Afa angwafig i luwal i eba mas suwigini mo. ");
INSERT INTO amn_n_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Afa Sisas elim ningitigi minefenam eso ehe mo bot wa fukoganam afa so Magadan bitegam ikana. ");
INSERT INTO amn_n_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Afa farisi i Sadyusi i Sisas nangum ambugonam. Ona Sisas gihi nangu eso sahani og, “Sa kam Godna kigmogim wagfun.” ");
INSERT INTO amn_n_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Afa piske sihini, “Mahim osu pegba ne sihi, ‘Of kagatotofeg eba osu lahlagna.’ ");
INSERT INTO amn_n_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Afa leanaba ne sihi, ‘Of bufegim nugwag ofe.’ Afa ne ofim nangu eso ne anwanafi mang puguf afa ne mas anwanafig mo kigmog mogim ka wagfuna eba gwese gohfufe ohuna osunagafa. ");
INSERT INTO amn_n_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","El yawo ohnanam eba amtakwalig afa Godum masig fatinig. Enaig el kigmogim ogna nangu eso Godum mas hugna onigi mo. Ka mas nengelim kigmog wagfuni, awai. Eba Jonana kigmogim mungo ne nanguf.” Eso Sisas wahianam ikana. ");
INSERT INTO amn_n_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Mahim pahlukuiag el buum apaiyegohnam ehegam maligim opukunam afa ehengel etetini bret wambug ahuiagim. ");
INSERT INTO amn_n_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Afa Sisas ehengel waskwes mo sihini, “Bwata, afa numwehifibi farisi ni Sadyusi ni yistim.” Yistimba enaba smof lofwag bretim esegba eso pipkig. ");
INSERT INTO amn_n_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Pahlukuiag el hefum sihiagini, “Mas big bret wambu ambugog mo eso Sisas enaig esog.” ");
INSERT INTO amn_n_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Sisas ati anwanafini ehengelni moba afa ehe enaig esona, “Ahnaig esegba enaig moba ne sihiagi kagelni bret awai. Hei, neana olug onigig wesigfeg. ");
INSERT INTO amn_n_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ateaho ne mas anwanafig mo? Ka onigig ne mas etetig mo autunam bret afawa gohug enag ka faini 5,000 elim afa sob 12 gohna eso ne piske wambini. ");
INSERT INTO amn_n_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Afa bret elegeg wa gohug eba 4,000 el ahgagini eso ne piske elegeg wa gohna enaig sobini wambini. ");
INSERT INTO amn_n_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ka mang bretim eso mo. Ahanaig eseg ne mas anwanafig mo? Numwehifibi farisi ni Sadyusini yistim.” ");
INSERT INTO amn_n_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Afa ehengel ati anwanafini Sisas mas enaig mo bretna yistim sihina mo, eba awai. Eba farisi ni Sadyusi ni mom soma numwehi. ");
INSERT INTO amn_n_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Sisas Sisaria Filipai distrik gam ikana, afa heafena pahlukuiag elim sahini og, “El esogo aman mahim Inim Elbi?” ");
INSERT INTO amn_n_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Afa ehengel sihini og, “Mingnag esogo ne Jon buwa aitiag el, afa mingnag esogo ne Elaija, afa mingnag esogo Jeremaia amo ming el mo fi sihiule.” ");
INSERT INTO amn_n_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Sisas sahtigina, “Afa namba ahanaig onigifig? Kaba aman mahim?” ");
INSERT INTO amn_n_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Pita wahigi sihina, “Ne Krais God Gishu Wahiag el afa Godba nofkenagag, nemble heafna leg.” ");
INSERT INTO amn_n_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Sisas piske sihini, “Saimon Jonna leg ena mo sona sihigba, mang el nem sihina mo, eba heafa kana awag heven wanai nem opugunag. Eso ne enam sifakalena. ");
INSERT INTO amn_n_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ka nem sihinag ne Pita neana unehlagba eba hun. (Mo enag ne sihigba enaig eseg hun.) Enaig eseg el lala hun wa nimblag. Enag hun wa kana elim ka wasanig. Afa Satanna kifutig mas kana elim filafati. ");
INSERT INTO amn_n_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Eba Godna bog meg ki ka nem faif. Afa mang sona kikiseg bite wa eso God gwenaig esef. Afa mang sona pigi wahiaiba bite wa eso God gwenaig esef.” ");
INSERT INTO amn_n_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Afa Sisas heafna pahlukuiag elim kweni, og, “Nofeka sihi kaba Krais God Gishu Wahiag El.” ");
INSERT INTO amn_n_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Gwenanam Sisas pahlukuiag elim heafna mom ambagwa sihini og, “Eba so ka Jerusalem gam ikaf. Afa misog el i, el Godum sis tuhlu faiule i, afa nihe mo anwana el i eso kam kinig numb faif. Afa kam wahaf afa sambaga mungo osuna ka piske buihiaf.” ");
INSERT INTO amn_n_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita Sisasim suflaukunam afa nunmuna og, “Soma God gwenai esei, ohuna enaig mas nem so pugunai.” ");
INSERT INTO amn_n_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Afa Sisas wahigi Pitam sihina, “Is kam wahia, Satan! Ne enaig membeg kana mina ogna kagwo. Nana mo mang Godna onigig mo awai, eba elni onigig.” ");
INSERT INTO amn_n_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Afa Sisas enaig sihifeni, “Afa aman membeg kana pahlukuiag el ogofiba eso ehe mas hefum onigig mo afa ehe soma li katige wa wahagim numwehenam afa so kam pahlu boi. ");
INSERT INTO amn_n_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Afa aman el onigig, heafna nofkena aluwegfenam eso hefum nawo sisife eba enaig el mas inim nofkena gagim fai. Afa aman kam pahlu obofiba eso ma heafna nofkena wahiai eba eso ehe higeg nofkena gag fai. ");
INSERT INTO amn_n_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Eba mas lahlafeg mo afa el mungwali bitenai gawig wambugba eso hefum awaief. Afa mungwali gawig mas elim nofkena fai. ");
INSERT INTO amn_n_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Afa Inim El eba Godna kigmogna afa ofwanai elim wanbof. Eso enanam ehe mungwali elim ahanaig ahanaigim kwefiahaginam eso faif. ");
INSERT INTO amn_n_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ka inim sihi mingnag el ohunanai yi goh mahimsi pigieg hwainig fefiba eso enag el nangufe Inim el enaig eso nalig misog el lofug bof.” ");
INSERT INTO amn_n_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Enwesog wa gohug osuna mahim ika awaienaba afa Sisas Pitana, Jemsna, afa Jonna enam sulfu wankanam ahu mog gam fukwalafuna. Ehe fwaimu auguiafena. ");
INSERT INTO amn_n_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Afa auguiafenaba nanguini Sisasna elig enmunam fena. Heafna nofbosug afwambusug osu lofug. Afa heafna fatitiag lofug busugnemwag fena. ");
INSERT INTO amn_n_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mahim pahlukuiag el nangunibi ikagna Moses i Elaija i ahpugunam Sisasim ahwani wagofna. ");
INSERT INTO amn_n_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Afa Pita Sisasim sihina, “Ainiyag, eba lahlag bigel ohunanai yi auguiafim. Ne membegba eso ka ohunanai yi lala wesig sambaga mungo nimblage. Ming neana, ming Mosesna, afa ming Elaijana.” ");
INSERT INTO amn_n_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Afa Pita sihi gofenaba eso lango afwambusug pebonam sagfa skofena. Afa enag leangowaba God sihini og, “Ohnaba kana leg mungo ka hugna membenag afa ka ehem sifakalena eso ehena mo higinim.” ");
INSERT INTO amn_n_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Afa pahlukuiag el higinim embefini eso nofbosug mo bite gam kumuni. ");
INSERT INTO amn_n_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Afa Sisas bonam ningana tutuhenugenam sihini og, “Buguiagafe, nofeka embefi.” ");
INSERT INTO amn_n_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Eso bahia nanguniba afa mas ming elimba nangunim mo eba Sisas mungo gofena. ");
INSERT INTO amn_n_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Afa mog wanai apaigo ambugoafenaba Sisas kifutig mo sihini og, “Eso ne nangug enaba nofeka elim sihigoni soma ikan Inim el wahanam bihiafei.” ");
INSERT INTO amn_n_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Afa pahlukuiag el sahani og, “Ahnaig esegba eso nihe mo anwana el enaig sihififni Elaija gosu bof eso Inim El mo sum bof?” ");
INSERT INTO amn_n_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Afa Sisas sihini, “Eba inim, Elaija ma gosu bof eso ehe mungwali numwehiagef. ");
INSERT INTO amn_n_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ka nem inim sihig Elaijaba ati bog afa el mas ehem anwanafig mo eba heafgelni onigig wa ehem ahanaig ahanaig ese fini. Eba gwenaig esinif, Inim Elim eso kinig faif.” ");
INSERT INTO amn_n_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Eso pahlukuiag el anwanafini Sisas enaig esona Elaija eba Jon buwa aitiag el. ");
INSERT INTO amn_n_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Sisas wanbona el numb yi wanpuguna. Afa so mungo el bo mongkokug kwakwagenam Sisasim sihina og, ");
INSERT INTO amn_n_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Ainiyag, so na kana luwalim afafena. Wuwag ehem amtakwalnageg afa suwi wa i bu wa i fapefiaka. ");
INSERT INTO amn_n_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Afa ka wanikig nimbiafna pahlukuiag el nai yi wani puguba afa ehengel mas lahlafakig mo.” ");
INSERT INTO amn_n_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Sisas piske enaig sihifeni og, “Mungwali el osa gohkaba eba olug onigig mas lahlafig mo afa mahimsi nengel flaflafiafu. Ahanana soka gafiba eso ne anwanafif? Kakwisig higeg nem wangagim. Sa luwalim osum wani bu.” ");
INSERT INTO amn_n_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Sisas wuwagim fenaminefena eso wuwag luwalim fwaihia ikana. Afa luwal ikagna yuhwafena. ");
INSERT INTO amn_n_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Afa pahlukuiag el ehe fwaimu augunam Sisasim sahini og, “Ahnaig esegba kagelbi mas wuwagibi ningihig mo?” ");
INSERT INTO amn_n_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Afa wahigi sihini, “Eba nengelni olug ongig wesig, ka nem inim sihinig afa nengelni olug ongig wesig mastet sisig lofwag enaig, eso ne enag mogum enaig esoiba ‘Susum ika’ eso ikaf. Eba so na mangim mungwali yuhwafif. ");
INSERT INTO amn_n_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Afa Godum eso sahanifibi eso ne fane fwaigo eba so na enaig ena wuwagibi ningitigi.” ");
INSERT INTO amn_n_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Afa ehengel Galili bite wa ahu opukonam Sisas sihi og, “Eba Inim Elim finim eso mingnagna elni ninga wa wahibi. ");
INSERT INTO amn_n_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Afa ehem tigif eso sambaga mungo osuna awaieba eso piske buihiaf.” Mahim sihi wahianaba eso pahlukuiag el olug kinig eskofena. ");
INSERT INTO amn_n_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Afa ming nanam Sisas heafna pahlukuiag elim wankana Kaperneam bite wa wanpuguna afa Godna Nalig lalanai kig wambule el Pitam sahani, “Ateaho nengelni anwana elbi kigba Godna Nalig lala namaunim takisbi fafaif?” ");
INSERT INTO amn_n_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pita sihini, “Ei”. Afa mahim ehe lala gam ika pugunaba afa Sisas gof sahna, “Saimon ne ahanaig onigig feg? Misog el amangelni kig wambugig heafna luwalna me awai afwambanai elni me wambug?” ");
INSERT INTO amn_n_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita sihina, “Afwambanai elni”. Eso Sisas esona, “Enaig esegba luwal mas kig faig mo. ");
INSERT INTO amn_n_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Afa nofe ne big enaig esi eba masa bigim lagonif. So na bu gam ikanam fofwalana sawugim etiawage eso yuwana ne fanam eso ne kig mengig wa nangu. Enag kigba eba bigim ihafenif eso fanam Godna nalig lalanai elim fai.” ");
INSERT INTO amn_n_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Enanam pahlukuiag el ambugona Sisasim sahini, “Afa aman so Godna bog megam goseg puguf?” ");
INSERT INTO amn_n_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Eso Sisas luwalim awamonam bona olyi lasuna. ");
INSERT INTO amn_n_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Afa enaig esona, “Ka nem sihini, afa olug onigig ne wahigi luwal lofwag hwanigba eba mas nengel saho ahui Godna bog megamba. ");
INSERT INTO amn_n_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Aman enag luwal lofenam hefum ahnai skaufeiba, eba so goseg pugui Godna bog megba.” ");
INSERT INTO amn_n_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Aman kana unehla wa luwalim awamonam kweafwiba eba naho kam gwenaig esenag. ");
INSERT INTO amn_n_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Afa luwal so kam olug oniginag, enag so aman wanikinam nuwehfumo waba husiafwibi, eso God ehem mungwag faif eba nalig kinig feg. Afa enaig elim hun naligna wuneg wa wena kikenim bu megam fatif eba wesig kinig feg. ");
INSERT INTO amn_n_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Eba amtakwalig, mang so enaksag ohuna bite wa gohka eba elim nuwehfinag. Enaigba higeg gofif, afa aman mingnag elim enaig esegonibi, nasabanig. ");
INSERT INTO amn_n_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Afa neana ninga i mong i nem hugufaku mang wa husufwagba eba so hegeflaiti. Eba lahlag feg ninga mong hwainig eso God i hafufe. Enaig amtakwalig neana elig mungwali goh afa nem suwi higeg lagig yi finim fatif. ");
INSERT INTO amn_n_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Afa neana nofug nem hugufaku mang wa husufwagba eba so fogafa. Eba lahlag feg mungo nofug hwainig eso God i hafufe. Enaig amtakwalig sambaga nofug goh afa nem suwi lagig kembig yi finim fatif. ");
INSERT INTO amn_n_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ne numwehifibi nofe ne luwalim pagaupenam afa eso, esim gofiba. Afa ka nem osihini heafgelni ofwanai el kana heven wanai Humuana nofbosugum higeg nangwahu. ");
INSERT INTO amn_n_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Afa el minam eteti ahuna eso Inim El bonam eso piske wambug.” ");
INSERT INTO amn_n_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Afa el 100 sipsip tata lofwag enaig ese wanga. Afa mungo sipsip minam eteti ikag. Ne ahanaig onigig, el enaig eseg? Ehe mingnagim sipsip mo mog wa wasanam afa mungo sipsipim yisgiakana. ");
INSERT INTO amn_n_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Afa mungwali mas awaiena mo ehe sifakaleg, afa mungo piske fagim eso ehem hugna sifakalenag. ");
INSERT INTO amn_n_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Afa gwenaig eseg nengelni heven wanai Awag mas membeg mo luwal lofwag mungo awaiegba.” ");
INSERT INTO amn_n_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Afa mahim neana nilite nem ahnaig naiba eso ika nangunam eso nimbe fwaimu ahaganam so niheaugu. Ma ateamba higigba eba so wani bonam eso mungo nilite ahfe. ");
INSERT INTO amn_n_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Afa ehe neana mo higi hwanigba eba so mungo me awai sambaga me so na piske ahu nangu. Eba soma neana mom ahigi. ");
INSERT INTO amn_n_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Afa ehe nengelni mo higi hwainig gwenai esegba eba so Godna elim sihigoni. Afa ehe Godna elni mo higig hwanigba. Eso nengel ehem enaig onigig fini sohnaba angoluwag el. ");
INSERT INTO amn_n_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ka nem sihinig, afa mang so nengel kikisig bite wa, eso God gwenaig esef. Afa so nengel pigi wahiaiba bite wa, eso God gwenaig esef. ");
INSERT INTO amn_n_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Mingnag mo ka nem afai, amanani ohuna bite wa hagafiba eso mangim mungo onigig ne ahsihinaiba eso kam heven wanai Awag eba nengelim esenif. ");
INSERT INTO amn_n_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ahana nai yi sambaga me awai sambaga mungo me kana el ambugog nuwagifiba eba ka olyi wangafif.” ");
INSERT INTO amn_n_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pita bo Sisasim sahna og, “Ainiyag, afa nilite kam ahanaig esenagofiba eso ahanasi nagim ka ehem mas esenai? Afa mas ka enwesog wa gohug mungwag faiyiba eba ateaho yuhwafeg?” ");
INSERT INTO amn_n_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Afa Sisas ehem sihina og, “Amo eba, enwesowa gohug mas yuhwafeg mo. Sa gwenaig ese enwesowa gohug enaig afa ne piske ese ikan eso ne mas piske suwigi. ");
INSERT INTO amn_n_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ka nena ena mo fai, eba Godna bog megam enaig eseg. Misog el membeg heafna elim gafugagim ogna fahigiage. ");
INSERT INTO amn_n_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Afa kigim fahigiag ofefenaba afa gafugag elim wanig ambugona og masa mungwag enaig 10 million kina piske fai. ");
INSERT INTO amn_n_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Afa enaig el kig awaiena piske faigim eso misog el esonig og, ‘Koka kig piske fa eba enaig eseg enag elni heafna angwag na luwal na afa mungwali gawig na wambinim eso mingnag elim faigoiba eso ka enana kig fa.’ ");
INSERT INTO amn_n_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Afa el enag mo higinam eso mongkokug misog elni muhwa kwakwagena afa esona og, ‘Sa kam afafena, ningenafafiba nofeka afgana ese afa eba ka nem mungwali kig mungwag piske faif!’ ");
INSERT INTO amn_n_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Afa misog el ehem afafena eso esona, ‘Kig osa ne kana fanag eba ka nem nangu wahiaf’ afa so ehem wahiana. ");
INSERT INTO amn_n_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Afa el ikanam ming el gwenaig gafuganai apuguiafenam. El kig wesig fana ming elni osa misog el ehem wahiana. Ena kigba enaig eseg mungo mungo kina. Afa so elim wuneglig yi kikehlanam og, ‘Sa kam mungwag fai.’ ");
INSERT INTO amn_n_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Afa heafna hihe mongkokug kwakwagena afa esona og, ‘Sa kam afafena, ningenafafiba nofeka afgana ese afa eba ka nem mungwag faif!’ ");
INSERT INTO amn_n_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ehe kusina enaig esegim eso ehem polisni ninga wa wahianam mahim ikan ma mungwag kam fai. ");
INSERT INTO amn_n_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Afa mungwali mingnag gafuganai el enaigim nangunim eso ehengelni olug amtakwale skofena. Afa so misog elim sihini og el enaig eseg. ");
INSERT INTO amn_n_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Eso misog el ehem awamona afa esona og, ‘Ne amtakwalig gafugag el. Gof kana enaksag kigna ne mas lahla gafuga fena mo. Afa ne og, so kam afafena, eso ka nem nangu wahiana. ");
INSERT INTO amn_n_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ka nem afafena eso neanga gwenaig ese.’ ");
INSERT INTO amn_n_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Afa misog el ehem olug kakagena afa mingnag el ninga wa ehem wahianaba eso ma tautig fanam ikan mahim mungwali mungwag faiba. ");
INSERT INTO amn_n_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Kana heven wanai awag eso nem gwenaig esinif. Eso nimbiafna nilite mas amtakwalig mungwag faig mo so kana Awag heven wanai gwenaig nengelim esenif.” ");
INSERT INTO amn_n_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Sisas ena mo sihi wahianam eso Galili bite wahianam afa Judia gam ikana. Ena biteba Jordan bu meigim. ");
INSERT INTO amn_n_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Afa el numb ehem pahlukuna. Enanai yi mingnag gih elim lahla fetifena. ");
INSERT INTO amn_n_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Afa farisi nangum ambugona. Ona Sisasim gihi nangunim afa ehena mom pagaupigo eso sahini og, “Aseg, so kwamblo heafna membug wa angwafigimbi ningihiai, ateaho bigelni nihe mo yuhwafeg?” ");
INSERT INTO amn_n_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Afa Sisas wahigi sihini og, “Mas ho ne Baibelna mo ne nanguni mo? Autunam God elim eseagenaba afa so kwamblo mi angwafig mi eseagena. ");
INSERT INTO amn_n_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Afa God esog, ‘Eso ma kwamblog el heafna awagim afa afagim hwatiginam ika heafna angwagim ahaganam afa soma mungoahfei.’ ");
INSERT INTO amn_n_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Afa mas enmuna fiagaf eba ati mungoahfeg. Eso el nofekawu pwatihiagahfei eba God ati waheg hwatigig.” ");
INSERT INTO amn_n_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Afa farisi ehem enaig sahinifini og, “Ahnaig esegba Mosesna nihe mo sihig, el membeg heafna angwagim oningihiafiba eso ma ginofe faiba soma okwi?” ");
INSERT INTO amn_n_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Sisas piske sihini og, “Nengelni olug liputini enaig esenaba ena mog Mosesna nihe mo sihina og, ‘Sesi’. Afa autunam eba mas enaigofena mo. ");
INSERT INTO amn_n_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ka nem sihini angwafig ming kwamblo i apugu afe hwanigba enam heafna ligag ningihianam afa ming angwafig fagba eba enaig ati mingnag angwafigim fapugu fenig.” ");
INSERT INTO amn_n_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Afa pahlukuiag el sihini og, “Afa nofeka angwafigim ningihia afa konigig angwafigim fag hwanigba eba lahlafeg.” ");
INSERT INTO amn_n_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Sisas sihini, “Nengelni mo angwafigim fag hwanigba. Mungwali el enag mo mas wahigwa higigim. Afa amanim so God fai eba so ehe ena mom pahlukui. ");
INSERT INTO amn_n_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Eba ahanaig ahanaig mog el enaig eseg mas angwafig wambu. Mingnag elbi mahim afag wanigagba eba elig amtakwalig, afa mingnag elbi heafgelni nihem enaig eseg laligim fikanig, afa mingnag elbi angwafig wambu hwanigba eba heafgelni mungwali onigig Godna bog megam sahugo. Aman ena moba anwanafigba eba so na fa.” ");
INSERT INTO amn_n_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","El luwalim Sisas nangu wanambugona og ma Sisas kagelni luwalim ningana tutohlihinugenam eso Godum sihina. Afa pahlukuiag el elim esogoni, “Mangofi, asim wanahu.” ");
INSERT INTO amn_n_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Afa Sisas sihini og, “Soma luwalim wanamgoi ka nangum afa nofena kwegoni. Aman el enag luwal lofegba eba Godna bog megba enaig elni.” ");
INSERT INTO amn_n_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Afa ehe luwalim ningana tutohlihinugenam enanai wahianam ikana. ");
INSERT INTO amn_n_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Afa el Sisasim bo sihina og, “Anwana el, ka membeg higeg nofkena fagim afa so ka lahlag gafugafe?” ");
INSERT INTO amn_n_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Afa ehem sihina, “Ahnaig esegba ne kam sahanag og, ‘Mang lahlagba?’ God mungo eba ehe lahlag. Ne membeg higeg nofkena fagimba so na Godna nihe mo pahluku.” ");
INSERT INTO amn_n_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","El sahanag, “Ahnam nihe mo so ka pahlukuf?” Sisas wahigi sihina og, “Ohuna niheba enaig eseg, nofeka elim tigefati, afa nofeka ming angwafigim aga fatinai, afa nofeka okwefei, afa nofeka ming elim mang mo sihina. ");
INSERT INTO amn_n_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Afa so na nimbiafna awag mi afag mi ahnai skaufen, afa so na nimbiafna hihem afafen eso ati nimbefum enaig esifafef.” ");
INSERT INTO amn_n_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kwamblog el Sisasim sihina og, “Kaba ati enam mungwali nihem pahluku. yawaba ka mang esef?” ");
INSERT INTO amn_n_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Sisas esona, “Ne lahlag elbi ofefiba eba so nimbiafena mungwali gawig mingnag elim faibi eso ne kig fanam afa ena kig gawig hwainig elim mimagen. Ne enaig esegba eba so na lahlag gau heven wanai fafe, afa so na kam sum pahluku.” ");
INSERT INTO amn_n_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kwamblog elni enaksag gawig fenaba, afa ehe ena mom higinam olug kinigafenaba eso ikana. ");
INSERT INTO amn_n_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Afa Sisas heafna pahlukuiag elim esoni og, “Inim ka nem sihinig, eso elbi gawig nubini feg, enaba Godna bog megam kifutif mas ikagna sahoi. ");
INSERT INTO amn_n_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ka nem piske osihin, kamelba tata nalig. Ateaho so enaba gwelig nil megamba sahoi? Enaba gwelig nil megam hugufeiba eba hugna kifutig. Eso enaig el membeg Godna bog megam seahoiba eba gwesim numweheg.” ");
INSERT INTO amn_n_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Afa mahim pahlukuiag el ena mo higinim sineminefinim etetiagini. Ehengel sahini og, “Aman so yuhwafef Godna el puguf?” ");
INSERT INTO amn_n_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Sisas nofna fahiagenam sihini og, “El mas neana mo enaig esi. Afa God ehe yuhwafef mungwali eseagegim.” ");
INSERT INTO amn_n_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Afa Pita esona, “Is sahig, kagel ati ka mungwali gawig hwatiagigim eso ka nem sum pahluhug. Mang so God kam faif?” ");
INSERT INTO amn_n_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Sisas ehengelim sihini og, “Ka inim mo sihig, mahim enanam mungwali gawig piske yimieg puguia minefeiba eso Inim El ehe ganam mungwali nangwagihiagef. Afa enanam ne kana 12 pela pahlukuiag el augunam eso ne Israelna 12 pela simbianingam nangwagihigif. ");
INSERT INTO amn_n_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Afa amangel so kam sum pahluku eba naho heafna lala, nilite, mulwal, awag, afag, luwal, afa aso hwatigim eba so 100 gwesim hiliflai afa eba nofkena higeg gag fafe. ");
INSERT INTO amn_n_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Afa yawo el numb goseg ahuia eba ambugog sum agfwohiefuf afa el numb so sum ambugog eba ahu gosuf.” ");
INSERT INTO amn_n_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Sisas piske gwena mo sihiagena, “Godna bog megam eba gwenai eseg. Mungo el leana kumbiyi ikag gafugag elim yisigi wambinam eso heafna aso wa wasanif. ");
INSERT INTO amn_n_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Afa gafugag el ehe sawifig mungo osuna gafugafim eso mungo kig denarius wambum. Eso asona awag asogam ningitigi. ");
INSERT INTO amn_n_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Osu bahigini asona awag piske ika mingnag elim nangwagnaba isug agfofena. ");
INSERT INTO amn_n_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Afa ehe sihini, ‘Neangaba ahu aso gafugafi eso ka nem kig lahlag faif.’ ");
INSERT INTO amn_n_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Eso ehengel ahuna. Afa osu misosuf gigini afa osu gahagwagna asona awag piske mingnag elim gwenaig esini. ");
INSERT INTO amn_n_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Mahim osu opogfenaba ehe piske ika gofenaba nangwagna mingnag el isug safewagfenaba eso ehengelim sahini og, ‘Ahnaig esegba eso ne isug ese ahu?’ ");
INSERT INTO amn_n_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Afa ehe esogona, ‘Mas kam aman gafugag wahianig mo.’ Afa asona awag sihini, ‘Neangaba ese ahu kana aso gafugafi.’ ");
INSERT INTO amn_n_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Mahim osu pe fenaba asona awag heafna misog gafugag elim unenam sihina og, ‘Gafugag elim mungwalim unenim kig mimangini. Afa so sumi nai elim mimangini ikan kan kan gofwanai elnai yi pugu.’ ");
INSERT INTO amn_n_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Afa amangel so sumi yi opuko gafuga fini enag mungo mungo kig denarius wambini. ");
INSERT INTO amn_n_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Afa el so leana gafuga fini enag enaig onigini og eba ka kig denarius enaksag wambuf. Afa ehengel gaba mungo mungo kig denarius wambini. ");
INSERT INTO amn_n_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Afa kig denarius wambinim afa sona awagim wagini. ");
INSERT INTO amn_n_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ehe og, ‘Sohna elbi sumi yi opuko gafugafigbi eba mwakwalig gafugafig afa kagelbi osu ihnolna gafugafig ikag osupeg. Afa ehengelni kigba kagelni mungwalofug kig.’ ");
INSERT INTO amn_n_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Afa asona awag wahigi sihini, ‘Hihe, ka mas nem amtakwale fati. Ena kig mungo so ka nem faigba enaba ati big sihiage ahwahiana. ");
INSERT INTO amn_n_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Sa fanam ika kikeafena sawieg wa ka sumi elim gwenaig kig faig. ");
INSERT INTO amn_n_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ohuna kigba eba kikeafena. Ena kigba so ka kikeafena onigi wa enaigba esef. Ahnaig esegba nana ninimug eba ka membeg ming elim enaksag kig wambwaig?’” ");
INSERT INTO amn_n_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Sisas enaig mo sihiage bo agfwaheafenaba enaig esona og, “Amangel so sum agfo eba ahu gosibi afa amangel so goseg enaba ambugog sum agfof.” ");
INSERT INTO amn_n_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Afa enanam Sisas Jerusalem gam fukoakofenba heafna 12 pela pahlukuiag elim wankafenaba enaig sihifeni og, ");
INSERT INTO amn_n_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Sa hig, yawo big Jerusalem gam ahuofeba eba Inim Elim finim Godum sis tuhlu faiule el i afa nihe mo anwana elni ninga wa wahibi eso sihiagenim tigifatif. ");
INSERT INTO amn_n_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Afa angoluwag elni ninga wa faigoiba eso ehem moalamp mo fainim, afa wena flakflakafana gif, afa li katigegwa fi kahlif eso sambaga mungo osuna puguiba eso ehe piske buihiaf.” ");
INSERT INTO amn_n_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Afa Sebedini angwag heafna legnigim wanbonam mongkokug kwakwagena Sisasna kig mungo wa penam, ogna sahna. ");
INSERT INTO amn_n_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Afa Sisas sihina, “Ahanaig eseg?” Afa angwafig enaig esona og, “Sa kam sihi wahianaiba, mahim ne nalig misog el puguiba eso ma kana luwalnigim ahbonam ming nihiginai ninga wa gai afa ming bonam sahaganai ninga wa gai.” ");
INSERT INTO amn_n_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Afa Sisas luwalnigim wahigi sihini og, “Eso ne sahigba mas ne anwanafig mo. So na yuhwa ahfei ena tautigba ahfai, eso ena tautig kaf kamble fafe.” Luwalnigi sohona og, “Eba ka esahfef.” ");
INSERT INTO amn_n_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Sisas enaig sihifeni, “Ei inim, eba ne kana tautig kaf wanai ahnef. Eso aman kana nihiginai ninga wa gai afa aman sahaganai ninga wa gai ka mas kikeaba ohnaiba esoi. Kikeafna awag ati sambaganigi lahlag kugba numwehiage wahiag aman so ena kugba fafe.” ");
INSERT INTO amn_n_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Afa mingnag 10 pela pahlukuiag el ena mom higinim sambaganigim fegonigini. ");
INSERT INTO amn_n_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Eso Sisas ehengelim unenim sihini og, “Ati ne anwanafig afwambanai elni misog el ehe mungohe, afa ehengelni nalig el kifutig numweheg. ");
INSERT INTO amn_n_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nofeka nimbefum enaig esiagi. Aman membeg misog elbi ogofiba ehe so ma mingnag elim ahnai skaufeni. ");
INSERT INTO amn_n_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Afa aman membeg gosuofefiba ehe so ma nengelni isug gafugag el pugui. ");
INSERT INTO amn_n_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Eso ma Inim El gwenaig esei, mang bog el ehem kwefug mo, amo eba awai. Eba ehe ming elim kwaganigim afa heafna nofkena gag faig eso enaksag elim piske wambugum pigi hwatig.” ");
INSERT INTO amn_n_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Sisas Jeriko kimbig wahianam wankana afa el nubwel ehem sum pahlukuna. ");
INSERT INTO amn_n_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Mahim mahimsi ahuafenaba sambaganigi el nofug kuhlag mina embeg wa ahafena. Ahiginaba og ati Sisasba obo eso ahunena, “Nemba Devitna simbianinga so kam afafeni!” ");
INSERT INTO amn_n_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Afa mungwali el ehenigim fegonigini og, “Afwai.” Afa eheba hugna ahunena, “Ainiyag, namba Devitna simbianinga so kam afafeni!” ");
INSERT INTO amn_n_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Afa Sisas gofenaba awamonim, sihini og, “Mang ka nem fenif?” ");
INSERT INTO amn_n_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Afa sohona, “Ainiyag, ka membe ahfeg ne kam nofugum bahia aitin!” ");
INSERT INTO amn_n_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Afa Sisas afafenim ehenigina nofugum tutuhlihinugenaba eso ikagna nofug bahiawagena afa so Sisasim ahpahlukuna. ");
INSERT INTO amn_n_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Afa Sisas heafna pahlukuiag elim Jerusalem gam wankana. Wankan ena mug wa unehlagba Oliv muhwa Betfage kimbig wa wan puguna. Afa so Sisas sambaga pahlukuiag elim gof ningitiginam ");
INSERT INTO amn_n_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","enaig esoni og, “Ahkan okwena kimbig wa ahpugunam, afa ne ikagna ahnagoiba donki-tata mungo li mog wa wena kiki wahig eso luwaligim wanigofuf. Eso ahpiginam kam ahwani bona. ");
INSERT INTO amn_n_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Eso aman ma nem ahanaig moba sihinibi eso ahsihina og, Ainiyag enana ogna gafugafe, eba nem ikagna ningitigif.” ");
INSERT INTO amn_n_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Afa enaba pugugba eba Godna mo inim pugug. Ena moba Godna mo fa sihiule el ati sihi wahiana. ");
INSERT INTO amn_n_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","God og; Mungwali Saion wanai elim ena mo sihigon, so nangu, nengelni misog el ati nem obon, ehe mo flafla hwainig el afa ehe donki-tatana nihi yi fuko agagim obo afa ehe donkina luwaligna gwenaig eseg. ");
INSERT INTO amn_n_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Afa so sambaganigi el Sisasna mo ahiginam gwenaig esahfena. ");
INSERT INTO amn_n_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Eso ahkanam donki luwalig nahlum ahwani bona. Afa heafnigina kwiyieg lofug hugufu askona donkina nihi yi eso Sisas enana yi fuko ganam ikana. ");
INSERT INTO amn_n_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Afa el numb heafgelni kwiyieg lofug hugfunim mina wa suguahuna afa mingana mo li kigag tutoaginim gwenaig esini. ");
INSERT INTO amn_n_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Mahim Sisas ikafenaba eso mingnag gosuni afa mingnag sum agfofena afa mungwali osogona og; Sa Devitna simbianingam unehlagim fingifi fukwalugo. God so ma lahlafeinai eso ehe Ainiyag na kigmogwa obo. Eso God sisinaim, ehena unehlagim fingifi fukwalugo. ");
INSERT INTO amn_n_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Mahim Sisas ika Jerusalem wa seahufnaba afa mungwali el ena kimbig wanai sahig ahfewagfna og, “Sohna elbi aman mahim?” ");
INSERT INTO amn_n_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Afa el ahuafenaba wahigi sihigoni, “Ohnaba Sisas Galili wanai ehe Nasaretna Godna mo fa sihiaule el.” ");
INSERT INTO amn_n_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Afa Sisas Godna nalig lala ika pugunam el enanai yi kigna gawig mimage gofini eso ena elim fenigenam afwambawa ningitigina. Afa el eyi mingnag kantri na kig mimange wagig simem Sisas wahigi wahigi fefatifeni. Afa twafig gamp mimange wagig pegag simem gwenaig esena. ");
INSERT INTO amn_n_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Afa ehe sihini og, “God heafna buk wa enaig sihifeg ‘Kana lalaba sefig God i sihiag ahfeg lala’ afa ne esigbi ena lalaba eyi okwef el meagam ahu saho agfoahe.” ");
INSERT INTO amn_n_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Afa enanai yi nofug kuhlag afa mong angieg ambugog Sisasim nanguni. Afa ehe lahlafetifena. ");
INSERT INTO amn_n_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Afa Godum sis tuhlu faiule el i afa nihe mo anwana el i kigmogim nanguni afa higinim luwal esogona, “Devitna simbianingam sifakalini” eso enag el olug kakagiagini. ");
INSERT INTO amn_n_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Eso Sisasim sahini, “Ateaho ne luwalna moba higig?” Afa ehe sihini og, “Ei ati ka higig. Mas ho ne ena Godna ginofba suwigig mo? Lahlag sifakaleg mo wesig luwal sihigbi eba God ehe eseg.” ");
INSERT INTO amn_n_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Sisas enanai yi elim hwatinam Betani kimbig wa ika gini. ");
INSERT INTO amn_n_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Afa leana Sisas piske Jerusalem gam ikan biniwahana. ");
INSERT INTO amn_n_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Afa fig li mina ehembe wa nangunam ikan muhwa pugunam. Eso nanguna figeg bihig gofena, fug awai. Eso liim esona, “Ne mas fuglei eba ne gwese gofuf.” Eso ikagna li fofena. ");
INSERT INTO amn_n_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Afa pahlukuiag el enam nangunim sineminefini og, “Ahnaig esegba na so sona fig libi ikagna fofeg?” ");
INSERT INTO amn_n_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Afa Sisas sihini og, “Ka nem inim sihinig, afa neana olug Godum oniginiba eso mas ne sambaga onigigufuf eba ne yuhwafif osa ka li esegba. Enaba neangaba gwenaig mugum ne esogof, ‘Susum ika buwa pe’ eso gwenaig esef. ");
INSERT INTO amn_n_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Afa neana olug onigi gwese gohugba eba mangimba ne Godum sahinibi eso ehe esef.” ");
INSERT INTO amn_n_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Sisas ika Godna nalig lala piske sahunam elim wagfuni ofefenaba afa Godum sis tuhlu faiule el i afa amunai el i ambugog Sisasim sahini, “Ahnaig esegba eso ne enaigba eseg? Aman nem sihina?” ");
INSERT INTO amn_n_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Afa Sisas wahigi sihini, “Ka gaba ka nem mungwag asahtigi ma ateamba ne kam yuhwa osihinifibi ka so nem sihin ahanaig so ka eseg. ");
INSERT INTO amn_n_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Aman mahim esonaba eso Jon buwa aitina, God me awai el me?” Eso ehengel hefum sihiagini “Ahnaig sihi so big finif? Afa big esogofiba, God ehem esona eba ehe sihif ‘Ahnaig esegba ne mas Jon na moba fi ni mo?’ ");
INSERT INTO amn_n_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Afa big esogoiba, el ehem esona eba eso big mungwali elim embefig onif ati mungwali onigig Jon eba Godna mo fa sihiaule el.” ");
INSERT INTO amn_n_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Eso Sisasim wahigi sihini, “Kagel mas anwanafig mo.” Afa Sisas sihini, “Kangafa ka mas nem sihini aman so kam esenag.” ");
INSERT INTO amn_n_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Sisas piske sihini og, “Ne ahanaig onigignafug numwehe onignaginim eso sihi. El enaig esena heafna leg sambaga. Ehe etegim ika sihina og, ‘So na yawaba aso gafugafegimba ikai.’ ");
INSERT INTO amn_n_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ehe sihina, ‘Kam kusi’ afa onigiagean wahianam afa so aso gam ikana. ");
INSERT INTO amn_n_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Afa awag ikana suminegim gwenaig sihina afa sumineg og, ‘Ei eba ka ikaf’ afa ehe mas ikana mo. ");
INSERT INTO amn_n_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Aman awagna olugba pahlukuna?” Ehengel esogona, “Eteg”. Eso Sisas sihini og, “Ka nem osihini nengel sumineg lofug. Nengel mas Jonna oningig pahlukuna. Afa kig wambule el i afa mina wa ahwamine angwafig i eso asaiyenam Godna bog megam gosu ahuf. ");
INSERT INTO amn_n_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Afa Jon bog Godna lahlag mina nem wagfunig afa mas ne ena mo fig mo. Afa kig wambule el i afa mina wa ahwamine angwafig i ena moba fig. Ati ne enaba nangug afa mas ne olug wahigi ena mo fig mo.” ");
INSERT INTO amn_n_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Sisas amunaim sihini og, “Sahig ming waskwes mo, el enaig eseg wain aso fegim bogna gohla wahiag enag asowaba lifug bigag bumeko wahiag afa sime wa lala kwina fe wahiag. Afa ehe elim enanai yi waskwes wahiagim ehe mo wahigwa yi kimbig gam ikag. ");
INSERT INTO amn_n_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Mahim wain fug pwatiyigim ofefiba eso asona awag heafna elim ningitigiba eso ahu eso gafuga wanai elim sihigonif og asona awag membeg heafna mungwehigenai eso fai. ");
INSERT INTO amn_n_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Afa mahim ahu opukonaba eso aso gafuga wanai el pahluamifinim ming elim tigegaminefini, afa ming elim mo tigi fatini, afa ming i mo hun na tigekini. ");
INSERT INTO amn_n_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Afa asona awag mingnag elim ningitigina ena elbi numwehena ahuna. Mahim opukonaba gwenaig esegoni. ");
INSERT INTO amn_n_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Afa sumi yi mo heafna legim ningihianam og, ‘Soma kana luwalim numwehe fi.’ ");
INSERT INTO amn_n_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Afa aso wanai el luwalim nangunim hefum sihiageni og, ‘Sonaba mahim awag wahagba enag fag. Ause, nahu tigi fati eso big heafna sofeg eso bigna fi.’ ");
INSERT INTO amn_n_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Afa luwalim kikehlinim asowa afwambagam fi fatinim tigekini.” ");
INSERT INTO amn_n_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Afa Sisas sahini og, “Mahim asona awag boiba eso ahanaig esenif?” ");
INSERT INTO amn_n_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Afa esogona, “Eba amtakwalig elim tigi fatinim afa aso amo ming elim faif eba amangel eso mungwehigenai awagim ikagna faif.” ");
INSERT INTO amn_n_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Sisas ehengelim sihini og, “Ena moba ati Godna bukwa goh. Ahnaig esegba ne na mas anwanafig mo? Mo enaig ikafeg; Ena sumilba lala nimbagig el isugum fi fatig eba naho God esenagba eso sumilba gohug. Afa enaba hugna lahlafeg mahim nangugbi. ");
INSERT INTO amn_n_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Noso ka nem osihi, God heafna bog megam nengelni ninganai fanam afa mingnag elim faif eso enag el nai yi fug luwof. ");
INSERT INTO amn_n_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Afa aman ena aga wa peiba eso ehem tigia hwatif. Afa aga amanim penam eso ehem fisgi fakaf.” ");
INSERT INTO amn_n_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Pris el i afa farisi el i ena waskwes mom higinim anwanafini eba Sisas ehengelni nihem sihina. ");
INSERT INTO amn_n_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Eso ehengel ogna ehem kikehli afa mingnag elim embefegoni. Og eba ati onigig Sisas ehe Godna mo faule el. ");
INSERT INTO amn_n_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Afa Sisas ehengelim piske ming waskwes mo sihini og, ");
INSERT INTO amn_n_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Godna bog megam enaig eseg, misog elni leg angwafig afaba eso misog el nalig bu yis ofen. ");
INSERT INTO amn_n_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Afa ehe elim sihinig og, ma ambugog fane ahagai. Mahim enena osu pugunaba eso heafna gafugag elim ningitigina og ahu enaig elim sihigon, so ma ambugog. Afa el kusi ni ka mas ambugog. ");
INSERT INTO amn_n_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Afa piske minanag gafugag elim ningitigina og, ‘Elim ahu sihigon ati ka faneba numwehiage wahiag. Ati ka nalig bulmakau afagwanai kwagig. Mungwali ati gohug eso ambugog ena bu yis ahga.’ ");
INSERT INTO amn_n_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Afa mahim sihigonibi mas higini mo eheba heafna gafugag wa ahkawag minefena. Ming el mo heafna aso gam ikana afa ming mo heafna ming gafugag wa ikana. ");
INSERT INTO amn_n_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Afa mingnag mo misog elni gafugag elim kikegonuginim kwaskofini. ");
INSERT INTO amn_n_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Afa misog el olug kakagenam eso heafna amiim ningitiginaba ahu elim kwaskofinim afa ehengelni kimbigim suwina tuhlugoni. ");
INSERT INTO amn_n_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Afa heafna gafugag elim esoni og, ‘Faneba ati ka numwehe wahia eso el so ka sihini wahia mang wangene el mo ena mo so ohuna faneba ambugog ahagai.’ ");
INSERT INTO amn_n_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Eso mungwali minahug ahu elim wambinim eso sihigoni eso ma ohuna bu yis wa ambugog. ");
INSERT INTO amn_n_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Afa gafugag el ahu amangelim gaba wambinim eso sulfu wan ambugona. Wan ambugonam lahlag el i amtakwalig el i eso lalam tifagena. ");
INSERT INTO amn_n_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Afa misog el sahu ikana nangwagna. Afa nangunaba el mungo mas bu yis wa lofug yimieg fatina mo. ");
INSERT INTO amn_n_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Afa sahna, ‘Hihe, asegba ne seahug afa ne mas yimieg lofug fatig mo.’ Afa ehe moahlai gofena. ");
INSERT INTO amn_n_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Afa misog el gafugag elim sihini og, ‘Ningam mungom wena kikenaginim afa afwambagam sikigieg megam fi fati. Eso ma enanai yi, el wewatinam heafgelni gog tutohia ahgafuf.’” ");
INSERT INTO amn_n_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Sisas mo sihi awahia fenaba og, “God enaksag elim unenigim afa mungo mungo elim kanog hwatig.” ");
INSERT INTO amn_n_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Farisi el ahuna hefum mina tohlagini ogna Sisasna mom klimoani. ");
INSERT INTO amn_n_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Afa farisi elni pahlukuiag el mi afa Herotna el mi eso ningitini og, “Wagfuiag el, kagel ati ka anwanafig neana moba inim afa ena inim moba ati ne elim Godna mina ogfu fenigeg afa ne mas onigi, ne gauna ahanaig ahanaig elim gaba sihinagahfeg. ");
INSERT INTO amn_n_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Sa kagelni sahigim kam wahigi sihin. Bigna nihe ateaho enaig sihifeg so big kigba Romna misog elbi fai me awai awai me?” ");
INSERT INTO amn_n_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Afa Sisas ehengelni amtakwalig onigigim anwanafinim afa esona og, “Mangigim ne kam ogihini? Nengel sambaga mengigna el! ");
INSERT INTO amn_n_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Sa kam takis kig wagfuni.” Eso ehengel mungo kig fibughuna. ");
INSERT INTO amn_n_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Afa Sisas sahini og, “Aman na nofbosug i unehlag i eso nanai yi go?” ");
INSERT INTO amn_n_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Afa esogona, “Sisar, Romna misog el.” Eso Sisas sihini og, “Sisarnaba eso Sisarim fai afa Godnaba eso Godum fai.” ");
INSERT INTO amn_n_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Afa ena mom higinim afa ehengelni olug fingi feskofenaba eso ehem washu ahuna. ");
INSERT INTO amn_n_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ena osuna Sadyusi el Sisasim nangum ambugona. Sadyusi el enaig onigini og melig pigieg elbi mas bihiagfei. Afa so Sisasim sahini og, ");
INSERT INTO amn_n_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Wagfuiag el, Moses enaig sihifena, afa el luwal hwainig wahagba heafna sumineg so ma ehena esig angwafigbi fai eso ma luwal etegna sigag wa unefei. ");
INSERT INTO amn_n_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Afa autunam elegeg wa gohug nilite ka agfoihiafena. Eteg angwafig fana mahim wahanaba luwal hwainig. Eso esig angwafig agafena. ");
INSERT INTO amn_n_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Afa ehem angigieg fana afa ehem gaba luwal hwainig wahana. Eso gwenai pigifeakan sumineg atamulug nai yi puguna, ");
INSERT INTO amn_n_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","afa sumi yi enag angwafigim gaba wahana. ");
INSERT INTO amn_n_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Afa autunai wa mahim enanam melig pigieg bihiagafeiba eso ehe aman na angwag fef afa mungo nilitena enag angwafig mungo fini?” ");
INSERT INTO amn_n_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Eso Sisas wahigi sihini og, “Godna buk i afa heafna kigmog i ne mas anwanafig mo eso ne etetiagig. ");
INSERT INTO amn_n_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Afa mahim enanam melig pigieg buihiagafenam mas angwafig wambu eba ehe Godna ofwanai el lofif. ");
INSERT INTO amn_n_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Afa enag onigig melig pigieg bihiagfei ena moba eba ati Godna buk wa gofna afa ne mas higig mo ena mo God nem faini. God enaig sihifena og, ");
INSERT INTO amn_n_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Kaba Abraham, Aisak, Jekop na God.’ Eba mang melig pigig elni God mo, eba heafa nofkena elni God.” ");
INSERT INTO amn_n_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Afa mungwali el ena mom higinim ehengelni olug fingi fiasaina. ");
INSERT INTO amn_n_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Afa mahim farisi el higinim Sadyusi el Sisasim mas yuhwa sihini mo eso mungwali wahenam Sisasim ahu nanguni. ");
INSERT INTO amn_n_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Mungo el eba nihe mo wagfuiag el. Ehe ogna Sisasna mom klimoanim eso sahini og, ");
INSERT INTO amn_n_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Wagfuiag el, ahana nihe mo eso mingnagim gosunig?” ");
INSERT INTO amn_n_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Afa Sisas ehem enaig sihifena, “So na Godum nimbiafena Ainiyag hugna membena. So na nimbiafena olug ni, sungwag ni, afa onigi na hugna Godum membena. ");
INSERT INTO amn_n_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ena nihe moba nalig fegim ehe goseg. ");
INSERT INTO amn_n_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Afa angigieg nihe mo gwenaig esog og, so na nimbiafena hihem hugna membena eso ne nimbefum enaig esfafif. ");
INSERT INTO amn_n_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Afa ena sambaganigi nihe mo waba mungwali Moses na nihe mo i afa Godna mo fi sihiule elni mo i enanai yi sahu ahgo.” ");
INSERT INTO amn_n_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Afa farisi el nuwag gofnaba Sisas ehengelim sihini og, ");
INSERT INTO amn_n_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Elbi sohnaba God ati Gishu wahiag elim piske wambugum, enaba amana simbianinga?” Afa ehengel wahigi sihini, “Eba Devitna simbianinga.” ");
INSERT INTO amn_n_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Afa Sisas sahini og, “Ahanaig eseg naso Godna Sungwag Devitim olug onigi wa fainaba eso Devit ehena unehlagim safana, Ainiyag. Devit enaig esona og; ");
INSERT INTO amn_n_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","God Ainiyag kana Ainiyagim sihinag so kana nihiginai ninga wa pegafim ikan ikan ka so kike neana fagule elim tigi feskonam eso ka nem faif. ");
INSERT INTO amn_n_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Afa Devit ehem safana, Ainiyag. Ahnaig esegba enag ehe Devitna simbianinga?” ");
INSERT INTO amn_n_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mas aman piske sihina mo afa enag osuna ikan hefum wahaf ehem sahnigim embefini. ");
INSERT INTO amn_n_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Afa Sisas heafna pahlukuiag el mi afa mingnag el mi sihinuwagena. ");
INSERT INTO amn_n_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ehe enaig esona og, “Farisi el i nihe mo anwana el i Mosesna nihe mona nem ogfu fegonugini. ");
INSERT INTO amn_n_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Afa ena mo so nem faigoba enaba eso higinim pahluku. Nofeka ehengelni nihem pahluku, mangofi. Mom sihigim afa ehe mas enam pahluku mo. ");
INSERT INTO amn_n_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Afa ehe elim kinig kike faigog, afa ena kinigba elim, kahli afa eheba mas ena kinigim ningana wesig pawohlini mo. ");
INSERT INTO amn_n_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Afa mungwali ahanaig ahanaig eso esihiagibi eba elim og so ma kam nangwagi. Afa betenna wagna angeg gigim afa betenna kwieg lofug wa we bugugni kifiyig hwatig. ");
INSERT INTO amn_n_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Afa nalig bu yis wa ehe ogna misog el lofug augu afa nuwagig lala ehe ogna sime lahlag wa gosu augu. ");
INSERT INTO amn_n_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Afa ehe enaig membig nuwagig gohugwa el so ma ehengelim une goni og amunai el afa wagfuiag el. ");
INSERT INTO amn_n_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Afa ese nem enaig sefifif wagfuiag el. Eba mungo neana wagfuiag elbi, afa ne nilitena fiakag. ");
INSERT INTO amn_n_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Afa ohuna bite wa nofeka elim sefi awag fei eba nengelni awagba mungo he heven wa ga. ");
INSERT INTO amn_n_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ese nem sefif ne amunai el eba el mungo he nengelni amunai elbi eba God ati Gishu wahiag elim piske wambugum. ");
INSERT INTO amn_n_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Aman nengelni Ainiyagba eso neana gafugag el fef. ");
INSERT INTO amn_n_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Aman hefum fingi fukuagba eba God ehem pigaupif afa aman hefum fingi fukuag hwanigba eba God ehem fingi fukuf.” ");
INSERT INTO amn_n_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Sisas enaig sihifeni og, “Nasabanig, farisi el i nihe mo anwana el i amtakwalig nem pugunuf. Eba ne sambaga mengigna el. Ne elim mina kikisei gonig Godna bog megam saiyegim. Afa nimbeba mas ne saho afa el ogna saho afa ne gwegonuhu.” ");
INSERT INTO amn_n_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Sisas enaig sihifeni og, “Nasabanig, farisi el i nihe mo anwana el i amtakwalig nem pugunuf. Eba ne sambaga mengigna el. Afa ne esig angwafigim makwale gonigim afa ne ehengelni lala wambugonig. Afa enaig esigim afa ne makwalig kwinam betenaska. Ena mog eba God amtakwalig tautig nem numwehe faif.” ");
INSERT INTO amn_n_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Sisas enaig sihifeni og, “Nasabanig, farisi el i nihe mo anwana el i amtakwalig nem pugunuf. Eba ne sambaga mengigna el. Afa ne biteamina ahwaminefig afa bu mina botwa ahug eba mungo elim neana pahlukuiag elim ne wahig. Afa enaig pahlukuiag elbi nem kwaganig gosu ikaf suwilagig kembig minagam. ");
INSERT INTO amn_n_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ne nofseleni el mingnagim wanahu mina wagfugonig eba nem amtakwalig pugunuf. Ne enaig sihi fegonug afa aman Godna nalig lalam unehlag seafanam afa mo sihi wahiaf eba isug sihi wahiag. Afa aman Godna nalig lalanai golim seafanam afa mo sihi wahiaf eba eso ena mo inim eseg. ");
INSERT INTO amn_n_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nengel moetet el afa nofseleni el. Mang so goseg, gol me awai Godna nalig lala me? Mas ne anwanafig mo lala goseg eso Godna lala enag golim esenagba eba Godna nemug. ");
INSERT INTO amn_n_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Afa ne elim sihigonig, afa aman sis tuhlu Godum fai simem seafanam afa mo sihi wahiaf eba isug sihi wahiag. Afa aman Godum fai sisim seafanam afa mo sihi wahiaf eba eso ena mo inim eseg. ");
INSERT INTO amn_n_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ne inim nofseleni! Mang so goseg sime me awai sis eyigig me? Afa mas ne anwanafig mo sime goseg, eso Godum fai sime enag sisim esenagba eba Godna nemug. ");
INSERT INTO amn_n_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Eso mahim aman Godum fai sime seafanam afa mo sihi wahiaf eba sime i afa mang enanai yi afugwagim ena mo kifutig wahiag. ");
INSERT INTO amn_n_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Afa mahim aman Godna nalig lala seafanam afa mo sihi wahiaf eba lala mi afa God eyi agag lala ena mo kifutig wahiag. ");
INSERT INTO amn_n_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Afa aman heven seafanam afa mo sihi wahiaf eba Godna nangwaghiageg simem seafag afa God ehe enanai yi pegagim seafag ena mo kifutig wahiag.” ");
INSERT INTO amn_n_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Sisas enaig sihifeni og, “Nasabanig, farisi el i nihe mo anwana el i amtakwalig nem pugunuf. Eba ne sambaga mengigna el. Afa yasmoel unehlagba mint, dil, kumin ne wambugum afa 10 pela hap suguahugim Godum mungo fai. Enam wesig nihe mo ne hugna onigig afa nalig nihe mo enaig eseg elim numwehe gwefihiaginim, eso afafegoni, afa lahlag olug onigig mas ne esig mo. Eso ne esi afa nofeka nalig nihe mo wahiyi. ");
INSERT INTO amn_n_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ne nofseleni el mingnagim wanahu mina wagfugonig! Ne buba ahagaba nambganai buwanai wambihiagig afa ne mas nanguna mo kamel-tata bu wa go afa ne ena nahgum neg.” ");
INSERT INTO amn_n_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Sisas enaig sihifeni og, “Nasabanig, farisi el i nihe mo anwana el i amtakwalig nem pugunuf. Eba ne sambaga mengigna el. Afa ne kap i plet i sisinai mungo gigiafiagig afa mo fa fag i afa faghagig i enanai yi memtowa pugu go. ");
INSERT INTO amn_n_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ne farisi nofseleni. Kapim yuwana mo so na meagam numwehe gigiafinim eso ma afwambanai yimieg.” ");
INSERT INTO amn_n_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Sisas enaig sihifeni og, “Nasabanig, farisi el i nihe mo anwana el i amtakwalig nem pugunuf. Eba ne sambaga mengigna el. Ne bite fe lofug wambo bite bigna fatig wahiyi. Afwambagam mo lahlag go afa meagam mo kig i lofug i nongi go. ");
INSERT INTO amn_n_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nengel gaba gwenaig esig. Afwambagam mo el nem nangwagi ne lahlag el afa meagam mo sambaga mengigna fegim amtakwalig nihe go.” ");
INSERT INTO amn_n_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Sisas enaig sihifeni og, “Nasabanig, farisi el i nihe mo anwana el i amtakwalig nem pugunif. Eba ne sambaga mengigna el. Nengel Godna mo fi sihiule elni bitekfem lahlafe fig afa lahlag elni bitekfem anginagig. ");
INSERT INTO amn_n_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ne enaig esogog afa so ka kagelbi simbianga wa wan auguia fiteba eba mas ka esite Godna mo fi sihiule elim kwaskofi. ");
INSERT INTO amn_n_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Eso neana mo wagfug nimbe ne elni luwalig Godna mo fi sihiule elim kwaskofig. ");
INSERT INTO amn_n_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Sa esi, yuwana simbianga ahanaig esini so na gwenaig yuhwa wahiyi. ");
INSERT INTO amn_n_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nengelba sombine afa sombinena luwalig. Ahnaig esegba ne onigig eso God mas kam suwi lagig kimbigaba ningitigi? ");
INSERT INTO amn_n_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Sa hig, ka nem osihin ka kikeafena Godna mo fi sihiule el mi, anwana el mi, afa wagfuiag el mi nem ningitiginiba. Afa eso ne mingnagim kwaskofi, afa mingnagim li katigegwa tigi kahlif, afa mingnagim nuwagig lala wa wena flagflaketifif afa mingnagim pahagemine fifibi eso mingnag kimbig gam ahuiamine fef. ");
INSERT INTO amn_n_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Eso amangel lahlag elim kwaskofig, enag elbi pigigba eba Abel wa pugugum ika Sekaraia wa pugug ena susuba eba mungwag ne fif. Sekaraia Berekiana leg nengelni simbianiga olyi Godna lala afa Godum sis faig sime wa tigekini. ");
INSERT INTO amn_n_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ka nem inim sihinig enag mungwali tautig mungwag eba nem yawonai elim pugunif.” ");
INSERT INTO amn_n_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Sisas sihini og, “Jerusalem wanai luwal, Jerusalem wanai luwal, ne Godna mo fi sihiule elim kwaskofini afa el God nem so ningitigigba ne hun na kwaskofi. Higeg ka membeg nengelni elim wambui kikeafnai yi muhwa wambugofum afa ofenai kakaruk afag heafna luwaligim wambui anglag meg gam kumo wambugu afa mas ne enaigim membeg mo. ");
INSERT INTO amn_n_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Eso God enag lalam neana wahiaf eba esugo fuf. ");
INSERT INTO amn_n_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ka nem enaig sihiofen mas ne kam nangui ikan kan ne enaig esogof, ‘God so ma lahlafenai eso ehe Ainiyagna kigmog wa obo.’” ");
INSERT INTO amn_n_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Sisas Godna nalig lalam wahia ikafenaba heafena pahlukuiag el ambugoafenaba ehem og so nangu sona lala. ");
INSERT INTO amn_n_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Afa Sisas sihini og, “Yawo ne mungwali hun lalam ne nangug, ka nem inim sihinig eba mas gofi. Nengigimba eso hun mungwali bite wa apaigofe afa mas mungo gofi.” ");
INSERT INTO amn_n_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Enana Sisas Oliv mug wa gafena. Afa pahlukuiag el ambugog sisag mona Sisasim sahini, “Sa kam sihini amansi Godna nalig lalam amtakwalef eso mang eseba so ka anwanafi eba nemble bogim afa mungwali awaiyef.” ");
INSERT INTO amn_n_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Sisas wahigi sihini og, “Numwehifibi masa el nem mwakwale gonif. ");
INSERT INTO amn_n_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Afa el numb ambugonam kana unehlag wa mwakwale agfohena esogof, ‘Kike Krais, God kam kanog wahiag.’ Ena mo enaksag elim mwakwalenif. ");
INSERT INTO amn_n_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Afa ne higif faghagig mo eso nofeka olug kinig eskof. Afa eba eso sonaigba puguf afa mungwali awaiye osunaba mahimsi. ");
INSERT INTO amn_n_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Afa mingnag el ahu mingnag elim angoluwag i hagfi afa mingnag misog elni el ahu mingnag misog elni el i hagfi. Afa ahanaig ahanaig biteamba eba bini nalig i afa kugo i puguiagef. ");
INSERT INTO amn_n_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Mungwali enaigba ofe angwafig luwalim tautigim oningis. ");
INSERT INTO amn_n_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Eso enanam nem wambinim mingnag elim wambwaigoiba so nem kwagi aitif. Afa ne kana el agfoihiefiba eso mungwali el nem olug kakagegonif. ");
INSERT INTO amn_n_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Enaksag el kam onigigim wahinim afa hefum mwauaginim afa olug kakagiagif. ");
INSERT INTO amn_n_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Afa enaksag mo fi sihiaule mwakwale el opukonam enaksag elim gasafihiagif. ");
INSERT INTO amn_n_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Eba amtakwalig nihe hugna nalig puguf eso nubwel el mingnagim membegonugim yiskos siagif. ");
INSERT INTO amn_n_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Afa amangel kifutig agfohian ikan mahim kinig awaieba eso ehe lahlag gofuf. ");
INSERT INTO amn_n_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Afa Godna bog megam lahlag mo mungwali kimbig sihiageahufuf eso mungwali el higigif eba ati mungwali awaiyegim opugu.” ");
INSERT INTO amn_n_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ne nanguf mang hugna amtakwalig so afsug kwegig mengig megam gofuf. Enam autunam Daniel Godna mo fa sihiaule el ati sihi wahiana. (Aman so enam suwiginam soma anwanafe.) ");
INSERT INTO amn_n_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Afa enanam Judia nai el opukonam so embem mug gam ahuf. ");
INSERT INTO amn_n_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Afa aman lala wa sisi gohugba eso nofeka mangwalba lalanaiba opuko wambug ahu. ");
INSERT INTO amn_n_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Afa aman asowa gohugba nofeka piske lalagamba ika lofugba fa. ");
INSERT INTO amn_n_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Enanam amtakwalegef angwafig enogni afa angwafig luwalna! ");
INSERT INTO amn_n_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Afa so na Godum sahini, ne mas hugna ninegna afa isug auguia osunaba enaig enaba embem ahui. ");
INSERT INTO amn_n_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Enanaba kinig nalig feahgenam puguiagef. Autunam God bite gafugagfenam bo yawo pugug enaig kinig mas gofena mo. Afa nengigim mas enaig piske pugui. ");
INSERT INTO amn_n_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Afa God ikagna tumegba hwanigba eba mungwali el awaief. Afa God kanog hwatig ena elim oniginigim eso tumenig. ");
INSERT INTO amn_n_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Afa enanam mahim el nem sihinibi og, ‘Sanangu Krais ohogo amo ehe okwenanaiyigo eba el God Gishu wahiag el.’ Nofeka ena mo higim. ");
INSERT INTO amn_n_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Eso mwakwale Krais, afa mwakwale Godna mo fi sihiule el ambugog opukof. Afa ambugonam ahanaig ahanaig kigmog wagfuiag gif afa God kanog hwatig elim gaba enaig esehiagi me. ");
INSERT INTO amn_n_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Enamba mahim fiahba ati ka nem sihi wahianig. ");
INSERT INTO amn_n_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Afa el nem sihigonibi og, ‘Ehe bite bihig go.’ Nofeka asim ahu. Afa esog, ‘Ehe ohunanai yi sahu go.’ Nofeka higim. ");
INSERT INTO amn_n_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Afa afwei osu puguiagam pugunam bo osu pegam ikaf eso mungwali el enam nanguf. Eso Inim El gwenai esef obofiba. ");
INSERT INTO amn_n_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ahana nai yi el melig pigieg afogwa enanai yi gungwe ambugog nuwagig.” ");
INSERT INTO amn_n_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Sisas enaig sihifeg, Gwenanam mahim kinig awaiyeba eso ikagna enaig esef, osu sikigef afa was mas pukoi afa bagnufut apaigofe, afa ofwanai kifutig gau fufiahsaiyif. ");
INSERT INTO amn_n_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Afa enanam Inim Elni wagfuiag of wa puguf. Afa so mungwali bitenai el wewati gofe eso ehengel Inim Elim nanguibi sisi lango wa nalig kifutigni afa nalig afwambusugini wahe bof. ");
INSERT INTO amn_n_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Afa afag nalig mwasiba eso ehe heafena of wanai elim sambaga sambaga bite meigim ningitigiba eso mungwali bitegam ahu God kanog hwatig elim wambugiahuf eso mungo wa ahu nuwagif.” ");
INSERT INTO amn_n_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“So na fik li waskwes mo anwanafi. Afa mahim li kag euwiauofefiba afa so li figeg yiminig puguf eso ne anwanafi eba lahlagna meinofe. ");
INSERT INTO amn_n_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Gwenai ese mahim ne nanguibi eso mungwali puguiagef so na anwanafi eba ati muhwa meiniofeg afa eba puguf. ");
INSERT INTO amn_n_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ka nem inim sihinag sonag el mahimsi agfofiba eso mungwali enaig puguiagef. ");
INSERT INTO amn_n_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Of i bite i mungwali awaiyeba afa kana moamo higeg gwesegofuf.” ");
INSERT INTO amn_n_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Mas aman anwanafe ahanag osuna so enaigba puguf. Godna ofwanai el i afa heafena Leg mas anwanafig mo eba Awag mungo anwanafeg. ");
INSERT INTO amn_n_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Oso yuwana Noa wanesena gwenaig esef mahim Inim El obofiba. ");
INSERT INTO amn_n_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Afa mahimsi bu puguia hwainig fiahfenaba enanam mungwali el hefum ahgagifini afa angwafig wambugifini gwenaig ese ahufenaba eso Noa mungo wansahona sip yi ba. ");
INSERT INTO amn_n_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Afa mungwali mas anwanafini mo enaig puguiagim. Gwenaig eseahufenaba eso bufle nalig bona mungwali kalefena wambkuna. Mahim Inim El obofiba eso gwenaig esef. ");
INSERT INTO amn_n_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Sambaganigi el asowa gafuga ahfegofiba eso God mungo faiba afa ming mo gofuf. ");
INSERT INTO amn_n_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Afa sambaganigi angwafig na ahsne gofiba eso God mungo mo faiba afa ming mo gofuf. ");
INSERT INTO amn_n_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Eso numwehifibi mas ne anwanafig mo ahanag osuna nengelni Ainiyag bonigim. ");
INSERT INTO amn_n_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ohuna mo eso ne anwanafi. Afa lalana awag anwanafegba amansi sinaini so okwef el bof ehe numwehego mas wahiai okwef el lala gam sahu bogim. ");
INSERT INTO amn_n_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Eso neanga numwehe, Inim El enag osuna obofiba ne eteti gofif.” ");
INSERT INTO amn_n_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Aman so misog el goseg wahiagba, eso mingnag gafugag elim fane mimangenigeg? Eba sawieg el onigig anwana. ");
INSERT INTO amn_n_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Enaig el soma sifakale mahim misog el piske bo ehem nanguiba eso lahlag gafuga fegofuf. ");
INSERT INTO amn_n_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ka nem inim sihinig misog el ehem wahiaiba eso heafena mungwali gawig nangwaghiagef. ");
INSERT INTO amn_n_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Afa gafugag el amtakwaligba ehe onigig misog el eyi mahisife. ");
INSERT INTO amn_n_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Afa ehe gohugum mingnag gafugag elim kwagaitifegim eso uflogna bu ahgaule elim fane wan neg afa bu wan neg. ");
INSERT INTO amn_n_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Afa enag osuna ehe etetif eso heafna misog el enanam piske bo puguf. Gwenanam ehe mas anwanafe. ");
INSERT INTO amn_n_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Afa misog el bonam ehem hihige feskofefe. Afa so ehem sambaga mengigna elim wahe hwatiba eso enanai yi eyu watunam gog kike skofefe.” ");
INSERT INTO amn_n_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Sisas esona og, “Enanam Godna bog megam enaig esef 10 pela angwafig angwaming heafgelni lam wambini ahu ufini el mungo angwafig ogna fa. ");
INSERT INTO amn_n_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Afa afawa puguf angwafig onigi etetig afa afawa puguf angwafig onigig anwana. ");
INSERT INTO amn_n_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Onigig etetig angwafig heafgelni lam mo wambinim afa wel mo mas wambini mo. ");
INSERT INTO amn_n_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Afa onigig anwana angwafig mo wel botol wa lam nahugum wambugahuna. ");
INSERT INTO amn_n_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ena el ogna angwafig fa enag mahimsi fiahfena. Afa angwafig nengiafuhun nof tuta feaisainaba non askafena. ");
INSERT INTO amn_n_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Afa ambagolugini el uneni og, ‘Ohonag el ati obo angwafig fagim. Au ambugonam eso ahu.’ ");
INSERT INTO amn_n_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Eso mungwali angwafig angwaming bugia gafenam afa heafgelni lam numwehiagini. ");
INSERT INTO amn_n_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Afa onigig etetig angwafig onigig anwana angwafigim sahigoni og, ‘Is ai, kangelim nimbiafgelni wel sugfu faigo. Kagelni lam ogna fuhluo skofe.’ ");
INSERT INTO amn_n_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Afa ehengel wahigi sihigoni og, ‘Amo ohonaba mas bigim yuhwafeni. Naiba nimbiafena ahu stoa wanai wambinim.’ ");
INSERT INTO amn_n_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Afa onigig etetig angwafig mahim wel wambugum ahuafenaba eso enanam el angwafig fagim ika puguna. Mingnag angwafig eso ati numwehiagini, ena mo angwafig buyis wa sahu wankanaba eso el mengig kikisei wahiana. ");
INSERT INTO amn_n_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Afa mingnag angwafig sumi yi ambugonam esogona og, ‘Ei amunai, kangelim mengig pigini!’ ");
INSERT INTO amn_n_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Afa ehe wahigi sihini og, ‘Amo, ka mas nengelim anwanafinig mo!’” ");
INSERT INTO amn_n_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Afa Sisas esona, “Ne mas anwanafig mo amansi osuna so nengelni Ainiyag bof eso numwehifibi.” ");
INSERT INTO amn_n_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Godna bog megam enaig ese mungo el ogna wahigwa ika. Ehe gafugag elim unenigim afa heafna gawig mimagenigim soma numwehe wambuf. ");
INSERT INTO amn_n_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Afa kig mungo mungo mimagenugegim afa aman so kifutig gafugafe eso ehem mo 5,000 kig faig afa ming elim gwelifeg ehem mo 2,000 kig faig afa yiskosule mo 1,000 kig faigim eso ehe mo ikag. ");
INSERT INTO amn_n_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Afa el 5,000 kig fanam enana oku ikagna gafugag fenam afa ming 5,000 kig fana. ");
INSERT INTO amn_n_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Afa el 2,000 kig gwenaig esena ming 2,000 kig fana. ");
INSERT INTO amn_n_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Afa ming el mo 1,000 kig fanam okunam mas enana gafugagfena mo eba okunam bite konam misog elni kig kumoahla wahiana. ");
INSERT INTO amn_n_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Mahim managenaba eso misog el piske bonam afa heafna elni gafugagim fahigiage. ");
INSERT INTO amn_n_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Afa el 5,000 kig fanam afa ming 5,000 kig fambu faina. Ehe og, ‘Ainiyag, ne kam 5,000 kig kana ninga wa fakagba so ka enana gafugafegim ka piske ming 5,000 kig fag.’ ");
INSERT INTO amn_n_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Heafna misog el ehem sihina og, ‘Ei, ne sawieg el neana gafugag eba lahlag. Ne enag wesigim numwehiafagba eso ka nem aluwegig faiba so na numwehiafaf. Aubo ka sifakaleba so na gwenaig ese.’ ");
INSERT INTO amn_n_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Afa el 2,000 kig fanam gwenaig esena bonam og, ‘Ainiyag, ne kam 2,000 kig kana ninga wa fakagba so ka enana gafugafegim ka piske ming 2,000 kig fag.’ ");
INSERT INTO amn_n_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Heafna misog el ehem sihina og, ‘Ei, ne sawieg el neana gafugag eba lahlag. Ne enag wesigim numwehiafagba eso ka nem aluwegig faiba so na numwehiafaf. Aubo ka sifakaleba so na gwenaig ese.’ ");
INSERT INTO amn_n_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Afa el 1,000 kig fanam bonam og, ‘Ainiyag, kati anwanafeg neana onigig kifutig. Nefgenai neana aso wa ne mas ihi afa ne isug wambule. Afa ming el mahim gafugafegba eso ne ena nai wambug. ");
INSERT INTO amn_n_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Enag ka embefeg ena kigna gafugafegim eso ka neana kig okugum bite megam kog kumohlag. Nana kig ohonaba, so nangu.’ ");
INSERT INTO amn_n_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Afa heafna misog el wahigi enaig sihifena og, ‘Neba amtakwalig yiskosug gafugag el. Ateaho ne anwanafeg nefgenai kana aso wa ka mas ihi afa ka isug wambule afa ming el mahim gafugafegba eso ka ena nai wambug? ");
INSERT INTO amn_n_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ahanaig esenaba ne mas kigba oku fakana mo bengwaba? Afa mahim ka piske obofiba eso ka enana kig i afa winmoni i fafe. ");
INSERT INTO amn_n_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ena kig finim eso ming elim fai osa 10,000 kig fag. ");
INSERT INTO amn_n_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Eso amana nubwel goh eba mingnag faif eso enaksag fenaf. Afa amana enaig hwainig wesigfegba eba enaba mweahwanaf. ");
INSERT INTO amn_n_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Afa enag amtakwalig gafugag elim afwambagam sikifig megam fafatiba, eso enanai yi eyu watunam gog kike skofefe.’” ");
INSERT INTO amn_n_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Mahim Inim El heafna ofwanai elim piske wan obofiba eso ehe nalig misog el fef. Ehe heafna lahlag kug wa ganam ena nai yi mungwali elim kwefihiagefe. ");
INSERT INTO amn_n_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Afa mungwali bitenai el ambugog ehena nofbosugam nuwagif. Eso ehe mungwali elim kwefihiagenam eso mange tigif gwenaig esef sipsip nangwaghiageg el sipsip mi meme mi mange tigif. ");
INSERT INTO amn_n_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Eba wambinam sipsipim nihigim wasani afa memeim sahagam wasani. ");
INSERT INTO amn_n_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Afa so misog el nihiginai elim sihinif og, ‘Aubo, kana awag eso nengelim lahlafihiageg. Au ambugonam nimbiafena gau fi eba Godna bog megam. Yuwana mungwali bite puguia hwainig fiahfenaba God ati numwehe wahiana. ");
INSERT INTO amn_n_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Eso bini kam wahanaba ne kam fane faini afa bu hef kam fenaba ne kam bu efiyaini afa ka afwambanai fenaba ne kam nimbiafena lala gam wanigahuna. ");
INSERT INTO amn_n_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ka lofug hwainig fenaba ne kam lofug faini afa kam gihenaba ne kam wanigagafena, afa ka kalabus lala wa ka gafenaba ne kam ambugog nanguni.’ ");
INSERT INTO amn_n_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Afa enag lahlag nihe el esogona og, ‘Ainiyag, ahanana soka nem biniwahagiba nanguni afa fane faini, afa bu hef ne fenaba ka nem bu efiyaini? ");
INSERT INTO amn_n_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ahanana so na afwambanai fenaba ka nem lala gam wanigahuna, afa lofug hwainig ne fenaba ka nem lofugba faini? ");
INSERT INTO amn_n_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Afa ahanana nem gihenaba ka nem wanigagafena, afa kalabus lala ne gafenaba ka nem ambugog nanguni?’ ");
INSERT INTO amn_n_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Afa misog el wahigi sihinif og, ‘Ka nem inim mo sihinig ne mungo isug elim esinig eba kana nilite enaho ne kam esenag.’ ");
INSERT INTO amn_n_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Afa so misog el sahaganai elim sihinif og, ‘Kam wahinim ahu. God nem heafna mona esinibi. So na suwi lagig kimbig gam ahu. Ena kimbig Satan mi afa heafna gafugag el mi ati numwehiagig wahianig. ");
INSERT INTO amn_n_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Eso bini kam wahanaba ne mas kam fane faini mo afa bu hef kam fenaba ne mas kam bu efiyaini mo, afa ka afwambanai fenaba ne mas kam nimbeafena lala gam wanigahuna mo. ");
INSERT INTO amn_n_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ka lofug hwainig fenaba ne mas kam lofug faini mo afa kam gihena, afa ka kalabus lala wa ka gafenaba ne mas kam ambugog wanigagafena mo.’ ");
INSERT INTO amn_n_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Afa ehengel esogona og, ‘Ainiyag, ahanana ka nem nanguni bini i afa bu hef i afa afwambanai ne fena afa lofug hwainig ne fena afa gihena, afa kalabus lala ne gafena eso ka nem mas kweagfuni mo?’ ");
INSERT INTO amn_n_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Afa eso ehe wahigi sihinif og, ‘Ka nem inim mo sihinig ne mungo isug elim mas esinig mo enaho ne kam mas esenag mo.’ ");
INSERT INTO amn_n_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Afa enaig elbi ahunam tautig amtakwalig higeg gohug wambuf afa lahlag nihe elbi eba ahunam nofkena higeg gohug wambuf.” ");
INSERT INTO amn_n_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Mahim Sisas ena mo mungwali sihiage wahianaba eso heafna pahlukuiag elim enaig sihifeni ");
INSERT INTO amn_n_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","og, “Ati ne anwanafig sambaga osuna mungo goh enaba Pasova buyis. Afa Inim Elim mingnag elni ninga wa faif eso ehem li katigegwa kahlif.” ");
INSERT INTO amn_n_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Afa enanam amunai pris el i afa Israelna amunai el i Kaiafasna lala nuwagena ehe misog pris. ");
INSERT INTO amn_n_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Afa mahimsi Sisasna minam yisginage afafena ogna mwakwalinim eso kikehlinim tigi. ");
INSERT INTO amn_n_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Afa esogona og, “Mas big Pasova buyis waba esi masa el nangui afa ninumugonam opukonam hagfe.” ");
INSERT INTO amn_n_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Sisas Betani kimbig wa ehe Saimon na lala gafena. Ena elbi autunam gih lepra fena. ");
INSERT INTO amn_n_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Enana angwafig sanda hun botolna fanam eso obuna, enag sandaba enaksag kigna. Eso lala fukona afa Sisasba sime wa gafenaba eso angwafigbi sanda bug Sisasna misog wa sugfunagena. ");
INSERT INTO amn_n_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Afa pahlukuiag el enam nangunim ninimugona afa esogona og, “Mangigim sanda bugba awaieg fatig? ");
INSERT INTO amn_n_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Eso big wahitibi ma el kigna fitie so big kig nalig fitie afa eso big gau hwainig elim kwaganite.” ");
INSERT INTO amn_n_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Sisas ati ehengelni mom anwanafenim afa enaig sihifeni og, “Ahnaig esegba so na angwafigimba kinigbi faig eba kam lahla feafag. ");
INSERT INTO amn_n_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Afa el gawig hwainig gwenaig wangafuf. Afa kable ka mas nem gwenaig wangafi. ");
INSERT INTO amn_n_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Afa angwafig sanda bug eso kana elig yi sugfug eba kana eligim numwehiagfag eso bitekfe wa fakif. ");
INSERT INTO amn_n_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ka inim nengelim sihinig afa mungwali bite eso ena lahlag mo sihiahufufe eso enaig angwafig ati eseg eba sihiahufiba eso ehem onigif.” ");
INSERT INTO amn_n_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Enanam Sisasna pahlukuiag el mungo unehlagba Judas Iskariot ehe ikanam amunai prisim nangwagena. ");
INSERT INTO amn_n_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Afa esona og, “Mang ne kam faif eso ka Sisasim nengelni ninga wa fakaf.” Afa eso ehem 30 kig silva suwiginim eso faini. ");
INSERT INTO amn_n_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Afa Judas mina yisiginam ogna Sisasim ehengelni ninga wa faka. ");
INSERT INTO amn_n_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Enanam ena buyis sefig ‘Bret Yist Hwainig’ puguna. Eso ena buyis wa angig osuna pahlukuiag el Sisasim ambugog nangunim esogona, “Ahana nai yi ne membeg kagel eso fane numwehiagif afa so na nafef Pasova buyisba?” ");
INSERT INTO amn_n_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Afa Sisas esoni og, “Ahu kimbig wa opukonam afa saigonam eso ena elim kana mo ugfo sihini, ‘Anwana el enaig esog kana osuba ati awaiegimba muhwafeg koka Pasova buyis pahlukuiag elim neana lala wane.’” ");
INSERT INTO amn_n_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Afa pahlukuiag el gwenaig esini mahim Sisas esonibi afa eso enag fanem numwehiagini. ");
INSERT INTO amn_n_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Afa kwekwe watini Sisas 12 pela pahlukuiag elim sime wa peganam fane wanena. ");
INSERT INTO amn_n_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Afa ahgafafnaba eso esona og, “Ka inim nem sihinig nengelinai aman mungo kam ikanam elim mwauf.” ");
INSERT INTO amn_n_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Pahlukuiag el ena mom higinim olug kinig eskofena afa hefum sahigini mungo mungo esogona og, “Ainiyag, mang ne kam sona mo?” ");
INSERT INTO amn_n_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Afa ehe piske wahigi sihini og, “Nengelinai aman mungo ka fane ahneau enag ehe kam ikanam elim mwaunif. ");
INSERT INTO amn_n_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Inim Elbi eba wahaf, ati Godna buk wa sihi wahiana eso wahaf. Afa aman so Inim Elim, elim mwaunif eba nasabam. Eba lahlag afag mas ehem wanigaite.” ");
INSERT INTO amn_n_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Afa Judas mwaug el Sisasim sahna og, “Anwana el mang ne kam sona mo?” Afa ehe wahigi sihina og, “Ei eba neana mo.” ");
INSERT INTO amn_n_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Afa so ahgafafenaba so Sisas bret mungo fanam Godum sahanam eso pahlukuiag elim kukoskofenam mangeni afa esona og, “Wambinim ahga, ohonaba kana elig.” ");
INSERT INTO amn_n_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Afa wain bug ikafna gwenaig esena fanam Godum sahanam eso mangeni afa esona og, “Sa mungwali enaba ahga. ");
INSERT INTO amn_n_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ohnaba kana taf ena taf eba ogfu wahia Godna mo sihi wahiag ena moba inim. Ka taf sugfoiba eso enaksag elni nuhwefiyi mo hugufatinif. ");
INSERT INTO amn_n_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ka nem sihinig ka mas nem piske wain bugba wan nei eba ikan ikan so ka mulug wain bug nem kikeafna Awagna bog megam saigonam wan nafef.” ");
INSERT INTO amn_n_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Afa mwanafi fatinim ena kimbig mo wahinim eso Oliv mug gam ahuna. ");
INSERT INTO amn_n_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Afa Sisas heafna pahlukuiag elim esoni, “Nengel nangufe mahim mang kam opugunafiba yawo sinaini afa nengel kam wahinim eso ne embem ahuf afa Godna buk ati enaig sihifeg og; Ka sipsip nangwaghiage elim tigeiba soma sipsip mo embem ahuaminafe! ");
INSERT INTO amn_n_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","“Afa ka piske bihiaf afa ka nengelim Galili gam gosunuf.” ");
INSERT INTO amn_n_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Afa Pita wahigi ehem esona og, “Mangofi, afa mingnag mungwali nem wahiyi ahuiba afa kaba mas enaig ese kafi.” ");
INSERT INTO amn_n_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Afa Sisas ehem esona og, “Afa ka nem inim sihinag enaba yawo sinaini kakaruk moasia hwainig fefiba eso ne sambaga mungo nagim esof ne kam mas anwanafeg mo.” ");
INSERT INTO amn_n_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Afa Pita ehem sihina, “Mangofi, kaba nei mungwal big ahwahaf afa ka mas esoi, ‘ka mas nem anwanafenag mo’, awai nemug.” Afa mungwali pahlukuiag el mungo mo esogona. ");
INSERT INTO amn_n_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Afa Sisas pahlukuiag elim wankanam enag bite sefig Getsemani. Ehe og, “Ohuna nai yi auguiafiba kaba osum betennegim aka.” ");
INSERT INTO amn_n_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Afa Sisas Pita mi afa Sebedina luwalnigi mi wankana. Afa ehena olug kinig hugna eseafenaba. ");
INSERT INTO amn_n_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Afa ehe sihini og, “Kam olug kiniageg kam wahagim ati meinofe, ohuna nai yi auguiafiba eso nofkikena fiahfafum.” ");
INSERT INTO amn_n_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ehe gwesim mwakwalig hili ikanam eso nofbosug bite wa penam betenena, “Kana humuan ena kafteba so na kana ninga wanai mwehwai. Eso nofena kana membug wa ese afa keso nimbiafena membeg wa ese.” ");
INSERT INTO amn_n_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Afa ehe piske bo nangwagnaba afa pahlukuiag el non askafena. Sisas Pitam sihina og, “Ateaho, so na kai mungo aua mas nofkena big afeg mo? ");
INSERT INTO amn_n_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","So na nofkena fiahfafiba afa beteneafafum masa nem gihig pugunibi ne mas kifutig agfofi. Sungwag mo sawifeg afa elig mas kigmog mo.” ");
INSERT INTO amn_n_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Afa ehe piske sambaga nagim ikanam betenena enai esona og, “Kana humuan, eba ne mas ena kafba mwehwai afa ne og so ka neba eba yuhwafeg, ka membeg nimbiafena onigi wa so ma pugui.” ");
INSERT INTO amn_n_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Afa ehe piske bo nangwagnaba afa pahlukuiag el non askafena eba ehengelni nofug noftuta fiahsaina. ");
INSERT INTO amn_n_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Afa ehe piske hwatinam ikanam sambaga mungo nagim gwenaig betenena. ");
INSERT INTO amn_n_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Afa ehe piske bonam pahlukuiag elim sihini og, “Mahimho ne askaba afa hekulafa? Is so hig, ati opugu mwauule el Inim Elim amtakwalig elni ninga wa wahiagim. ");
INSERT INTO amn_n_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Bihia gafenam nahuiago. Ati mwauule el obo!” ");
INSERT INTO amn_n_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Sisas mahimsi mo sihi gofenaba el ambugona. Ena elimbi amunai pris i afa amunai el i ningitiginibi. Eso naif i afa maluwi i wambinim eso Judas wanbona. Judasba eba 12 pela nai pahlukuiag el mungo. ");
INSERT INTO amn_n_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ena mwauule el i afa el i nuwag sihiageni, ehe enaig esoni og, “Ka ma amanim afofafna ofefafiba eba naho eso ne kikehli.” ");
INSERT INTO amn_n_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Eso Judas ikagna bona Sisasna muhwa pugunam og, “Ei Ainiyag”, afa eso ehem afofafna fiafana. ");
INSERT INTO amn_n_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Afa Sisas ehem enaig esona og, “Hihe, mang so na fegim obo, eba sesei.” Eso el Sisasim ambugog kehlini. ");
INSERT INTO amn_n_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Afa enana mahim Sisasim okikehlifinibi heafna el mungo naif skofanam misog prisni gafugag elim anglugum higefatina. ");
INSERT INTO amn_n_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Afa Sisas esona og, “Naif piske hugufe. Afa aman naif skofagba eba naif ehem tigeiba eso wahaf. ");
INSERT INTO amn_n_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ateaho ne anwanafeg eba ka kikeafna humuanim sahanaiba eba 12 pela ami i afa mingnag ami i ofwanai elim ningitigiba eso ikagna ambugog kam kweagfuf? ");
INSERT INTO amn_n_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Afa ka enaigba eseba eba Godna mo mas inim pugui. Godna buk ati enaig sihifena eso enaig kam pugunafe.” ");
INSERT INTO amn_n_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Afa Sisas mungwali elim sihini og, “Ne enaig onigig kaba okwef el ho nana naifna malunaba fa bug kam fig? Afa mungo mungo osuna ka Godna nalig lala gafenam elim wagfufenig fakafenaba afa ne mas kam fini mo. ");
INSERT INTO amn_n_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Afa enaig mungwali eso pugugba eba ati Godna mo fi sihiaule el ati ginofi wahini eso inim pugu.” Afa mungwali pahlukuiag el Sisasim wahianim embem ahuaminefena. ");
INSERT INTO amn_n_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Afa enag el Sisasim kikehlinim Kaiafasna lala gam wanigahuna. Kaiafas eba pris misog el. Afa amunai el i afa nihe mo anwana el i ena lala nuwagena. ");
INSERT INTO amn_n_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Afa Pita sum sum fiahkan ikana pris misog elni lalam ambagwa ikagofena. Ehe bog megam sahunam anwasag el nai yi wahe auguiafena. Ehe ogna Sisasim nangwag gofum mahim ahanaig esofinifibi. ");
INSERT INTO amn_n_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Afa amunai pris i afa mungwali amunai el i nuwagenam mingnag elim og ma ahanaig mo Sisasim mwakwal mo sehinim eso ehem tigi. ");
INSERT INTO amn_n_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Afa mas mangim nangunim mo eso el numb goba ambugoafnaba ehe gwenaig mwakwale mo esini. Afa sumi yi sambaga el ahbona, ");
INSERT INTO amn_n_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","afa esohona, “Sonag elbi enaig esog, ‘Eba ka esef Godna nalig lala bufanam afa sambaga mungo osuna ka piske nimbagef.’” ");
INSERT INTO amn_n_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Afa pris misog el bihia gonam afa Sisasim esona, “Ahnaig esegba nana mas ena mo mungwag sihini mo?” ");
INSERT INTO amn_n_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Afa Sisas eba mwahlaigofna. Eso pris misog el ehem piske sahna, “Afa Godna unehlag wa nofkenagag ka yawo nem sahna so na inim sihi, eso kagelim sihi neaho Krais, Godna leg?” ");
INSERT INTO amn_n_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Afa Sisas wahigi ehem sihina, “Ei gwenaho ati ka nem mungwali osihini, nengigim ne nanguibi Inim El Godna nihiginai ninga wa ganam afa ofwa lango i wahe bof.” ");
INSERT INTO amn_n_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Afa gwenanam eso pris misog el heafna lofug piple skofenam afa esona, “Ehe Godum mwalapinag. Nofena mingnagna mo higigon, magofi. Nimbe ati ne higig ena mwalap moba. ");
INSERT INTO amn_n_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Afa ne ahanaig onigifig?” Afa ehengel wahigi osogona og, “Ehe enaigule afa so ma wahai.” ");
INSERT INTO amn_n_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Eso ehem nofbosug wa memp kusufinim afa tigekini afa mingnag ehem ningafana poupou faminefini, ");
INSERT INTO amn_n_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Afa esogona, “Neaho Krais eso Godna mo kam sihin, amangel nem tigahu?” ");
INSERT INTO amn_n_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita ambagwa gafena afa gafugag angwafig angwaming bo muhwa ehem pugunam afa esona og, “Neanga Sisas Galili wanai i ne esahfekafena.” ");
INSERT INTO amn_n_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Afa Pita mungwali elni nofwa awaiena og, “Amo awai, kaba mas enaba anwanafeg mo, mo so na sihigba.” ");
INSERT INTO amn_n_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Afa gwesim hili ika bog mengig muhwa gohfnaba afa ming angwafig angwaming bo nangunam gwenaig esona mahim mungwali el gogafnaba og, “Ohonag elbi Sisas Nasaret wanai i ehe esahfeakafna.” ");
INSERT INTO amn_n_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Afa Pita piske enaig esona og, “Inim nemug, ka mas enaig elbi anwanafenag mo!” ");
INSERT INTO amn_n_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Afa ma nagig hwainig el muhwa agfohiafena nag ambugog Pitam og, “Inim ehe neba enanai el he eba ati nimbeafna mengig pugug.” ");
INSERT INTO amn_n_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Afa Pita enaig esona ka maste inim oi, ateamba ka enaig esegba eba God so ma kam amtakwale fati! Ehe enaig esona og, “Inim inim nemug ka mas enag elbi anwanafenag mo!” Pita enaig sihif gofnaba gweyi ikagna kakaruk moasiyina. ");
INSERT INTO amn_n_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Eso ehe piske ena mom onigina Sisas so sihina og, mahim mahimsi kakaruk moasiag hwainig fefiba ne sambaga mungo nagi esof ka mas ehem anwanafenag mo. Afa eso afwambagam pugu ikafnaba amtakwal ufwe feagena. ");
INSERT INTO amn_n_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Eso leana amunai Pris i afa amunai el i mungwali nuwagnam Sisasim tigi fatigim sihiagini. ");
INSERT INTO amn_n_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Afa kifutig wena kikenaginim eso wanig ahuna. Wanig ahunam Pailatba gavmanna misog el nai yi wahini. ");
INSERT INTO amn_n_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas mwauule el enam nangunam anwanafena mahim el Sisasim tigigim sihiaginibi eso hefum piske ahwanifena. Afa ehe ena 30 kig silva fanam ogna oku amunai pris mi afa amunai el mi piske fai. ");
INSERT INTO amn_n_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Judas enaig esona og, “Kati amtakwalageg. El ahanaig eseg hwainig ka nengelni ninga wa wahiagba eso ehem tigif.” Afa wahigi ehem sihini og, “Mang kagelni moawa mo eba nimbiafena moawa.” ");
INSERT INTO amn_n_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Eso Judas ena kig Godna nalig lala wa aiti wahia ikana. Ikanam we wa luguna. ");
INSERT INTO amn_n_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Afa amunai pris ena kig finim esogona, “Ohuna kigba elni tafim na fag eso bigelni nihe mo sihig nofena Godna lala na kig i wahe faki.” ");
INSERT INTO amn_n_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Afa ehengel sihiageni ena kigba eso big bite enana fi. Ena biteba el bite sospen gafugafe fiahgiafufena ehengelni fagoni. Afa ena biteba angoluwag elni melig pigieg na bitekfe wahini. ");
INSERT INTO amn_n_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Eso enaba sefig Taf Bite gwese goh. ");
INSERT INTO amn_n_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Enanam Godna mo fi sihiule el Jeremaia na mo inim puguna. Autunam ehe ati sihi wahiana og, “Ehengel ena 30 kig silva wambini eba ahanansi kig Israelnai el sihiagini eso ehem fif. ");
INSERT INTO amn_n_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Afa enanai yi el bite sospen gafugafe fiahgiafufena eso ena kigba ena bite fini, eba enaig eseg God kam ati sihinag.” ");
INSERT INTO amn_n_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Gwenanam Sisas Pailatna nofbosugam gofena. Pailatba gavman na misog el. Afa sahna, “Neaho Ju elni misog el?” Afa Sisas esona, “Ei, ati ne sihig.” ");
INSERT INTO amn_n_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Amunai pris i afa amunai el i Sisasim ninga bulni sufini afa Sisas mas wahigi sihini mo. ");
INSERT INTO amn_n_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Afa Pailat ehem sahna, “Mas ho ne ena enaksag moba higig mo eso nem kufi wahig?” ");
INSERT INTO amn_n_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Afa Sisas mwahlai gofenaba eso Pailat oniginagegofena. ");
INSERT INTO amn_n_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Enanam Pasova buyis wa mahim amanim wahigwa finibi eso gavman na misog el kalabus nai elim mungo wahiana. ");
INSERT INTO amn_n_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Afa enanam el mungo gofena mungwali ati anwanafini ehem amtakwalig el heafna unehlagba Sisas Barabas. ");
INSERT INTO amn_n_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Eso mungwali el nuwaganamba afa Pailat sahini og, “Amanim ka wahiaf, Barabas me awai Sisasim me eba el sefig God Gishu Wahiag El?” ");
INSERT INTO amn_n_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailat ati anwanafini el Sisasim ambobuginim eso ehena ninga wa wahini. ");
INSERT INTO amn_n_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Afa mahim ika elim kwefihiageg kug wa gafenaba afa heafna angwag enag mo faina og, “Ka itiwa nangogba enag elbi esinigbi eba ahanaig eseg hwainig.” ");
INSERT INTO amn_n_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Amunai Pris i afa amunai el i mungwali elim heku sihiaginim og so Pailatim sahini ehe so ma Barabasim mo wahianam afa Sisasim mo tigi. ");
INSERT INTO amn_n_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Afa Pailat mungwalim sahtigina og, “Amanim so ka wahiaf?” Afa ehengel mungwali esogona og, “Barabas.” ");
INSERT INTO amn_n_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Afa Pailat sahini og, “Sisasim, el sefig God Gishu Wahiag El so ka ahanaig esenaf?” Afa ehengel esogona og, “Li yi kukufenagi!” ");
INSERT INTO amn_n_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Afa esona, “Ahnaig esegba? Mang mahim fenaba?” Afa hugna esogona, “Li yi kukufenagi!” ");
INSERT INTO amn_n_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailat ati anwanafenim ehengel mas mom higini mo afa ogna hefum hagim eso ehe ehengelni nofwa ningam buwa sugena. Afa og, “Sonag elbi wahaiba eba kana moawa mo eba nimbiafgelni moawa.” ");
INSERT INTO amn_n_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Afa mungwali ehem sihini og, “Ehena tafba kagel i afa kagelni luwalim mi so ma gofi!” ");
INSERT INTO amn_n_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Afa ehe Barabas mo ehengelim wahianim eso Sisasim soldia na ninga wa wahinim eso wena flakflakenaginim afa so li yi kukufenagif. ");
INSERT INTO amn_n_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Afa Pailatna soldia Sisasim gavman na lala wanigahuna. Mungwali soldia ambugonam ehem wahigi fakana. ");
INSERT INTO amn_n_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Afa ehena lofug mo hugufi fatinim afa tafiglek lofug fatini. ");
INSERT INTO amn_n_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Afa nasna we kugunim misog wa fatini eba enaig eseg misog elni mwakwal lofug. Afa misog elni mwakwal agat nihiginai ninga gam faini. Afa mongkokug kwakwaginim eso ahwanef mo sihini og, “Ei namba Ju elni misog el.” ");
INSERT INTO amn_n_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Afa ehem memp kusufini afa agat piske finim enana misog gim tigini. ");
INSERT INTO amn_n_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ehengel gwenaig esenaginim afa lofug hugufi fatinim afa piske heafna lofug fatini. Afa kikehlinim wanigahuna ogna li yi kukufenagi. ");
INSERT INTO amn_n_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Afa wanig ahuafenaba Saimon Sairini nai elim ufinim og Sisasim kweagfunam li katigeg so kufehlakuna. ");
INSERT INTO amn_n_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Afa ahu Golgota bite wa opukona. Ena unehlag mog eba sefig melig misog bite. ");
INSERT INTO amn_n_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Afa enanai yi wain bug finim miaklana buna wahe nihini. Afa Sisas gihinam kusina. ");
INSERT INTO amn_n_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Eso li katigegwa kukufenaginim afa katna wagini eso aman nana Sisasna lofug fai. ");
INSERT INTO amn_n_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Afa nanai yi auguiafenaba nangu fafena. ");
INSERT INTO amn_n_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Afa sisi ehena misog waba enaig ginof sihig mang el esena. Ena ginof enaig eseg og: ");
INSERT INTO amn_n_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Afa enanam Sisasna muhwa sambaganigi okwef elim wambtinim eso migim nihiginai ninga gam li katigegwa kahlini afa migim sahagam ningagam gwenaig esini. ");
INSERT INTO amn_n_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Afa el numb ahu muhwa angmuwagi finibi fahufena. Afa ehem ahwanef mo enaig esogona, ");
INSERT INTO amn_n_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“So na ogna ka Godna Nalig lala bufatinam eso sambaga mungo osuna piske nimbaf. Afa ne Godna legba naiba so li katigegwa wahianam pe!” ");
INSERT INTO amn_n_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Afa amunai pris i nihe mo anwana el i afa amunai el i gwenaig esogona og, ");
INSERT INTO amn_n_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ehe mingnag elim fakwaganif kafena afa mas hefum mo yuhwafenam kweagfwi. Ehe eba Israelna misog el? Ateaba pegba eso big ehem olug onigini. ");
INSERT INTO amn_n_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Eba ati ehe Godum oniginagim afa esog, ‘Kaba Godna leg’. Sa big nangug ma ateamba God ehem yawo okweafugfiba.” ");
INSERT INTO amn_n_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Afa sambaganigi okwef el li katigegwa nai Sisasim gwenaig esohona. ");
INSERT INTO amn_n_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Afa osu misosuf gigini si mungwali bite kigi fakana ikan ikan sambaga mungo aua wa puguna. ");
INSERT INTO amn_n_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Afa ena sambaga mungo aua awaiegim ofefenaba eso Sisas hugna unena og, “Eli Eli lema sabaktani?” Ena moba og, “Kana God kana God asegba nana kam awahia?” ");
INSERT INTO amn_n_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Afa mingnag el muhwa agfohiafenaba ena mo higinim afa esogona og, “Sohna elbi Elaijam ounenag.” ");
INSERT INTO amn_n_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Afa el kikini ikagna ikana spans fanam wain bug wa figihianam aga wa kikenam afa so Sisasim nihna. ");
INSERT INTO amn_n_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Afa mingnag el esogona og, “Au mahimsi, nawo nangwafufum ma ateamba Elaija bo okweagfufiba!” ");
INSERT INTO amn_n_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Mahim Sisas piske unenaba eso heafna sungwag sugu fwagenaba eso olug pwathuna. ");
INSERT INTO amn_n_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Afa gwenanam Godna Nalig lala nai lofug olyi plefunam pekan pitkafena afa kugo ilafonam hun tutohia apaigona. ");
INSERT INTO amn_n_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Afa bitekfeg topi fiahkana afa Godna el enaksag pigina enanam bigiagafena. ");
INSERT INTO amn_n_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Mahim Sisas piske bihianaba eso ehengel bitekfeg wahinim afa ahu Jerusalem wa opukonaba eso el numb nangwagini. ");
INSERT INTO amn_n_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Soldiana misog el afa soldia i Sisasim anwasag fiagfofena. Afa enanam ahanaig ahanaig i afa kugo i eseaginaba enam nangunim eso ehengel embefinim afa esogona og, “Inim he, sona elbi Godna leg he!” ");
INSERT INTO amn_n_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Afa enaksag angwafig ambugog membiagig agfofenaba heagaba nanguni. Ena angwafigbi Sisasim Galili nai pahlubina eso Sisasim kweagfu. ");
INSERT INTO amn_n_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Afa mingnag angwafig eba Maria Makdala wa nai angwafig. Afa ming Mariaba eba Jemsna i Josepna i afag. Afa ming angwafig Sebedina legnigina afag. ");
INSERT INTO amn_n_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Osupegna Josep Arimatea wa nai el bona Pailatim nanguna. Josepba kig enaksagna el afa eba Sisasim pahlukuiag el. ");
INSERT INTO amn_n_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ehe Pailatim sahna ogna Sisasim faku. Eso Pailat soldiaim esoni, “Sisasim pitigifinim eso Josepim fai.” ");
INSERT INTO amn_n_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Afa Josep ena melig fanam fakunam eso yimieg lofugna kikenagina. ");
INSERT INTO amn_n_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Josep heafna mulug hun meg ati numwehiage wahiana eso enanai yi sahoku fakana. Eso hun mogug iteutifiku mengigim pwakafenam eso ikan. ");
INSERT INTO amn_n_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Makdala wa nai afa ming Maria i wahigwa agig ahagag fenaba eso hun megim ahnangufena. ");
INSERT INTO amn_n_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Afa numwehiagig osuna mo awaienaba afa ming osuna mo eso amunai pris i afa farisi el i Pailat nangugum ahuna. ");
INSERT INTO amn_n_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Ahunam esogona og, “Amunai ka onigig autunam enag mwakwal el nofkena ati sihi wahiana og, ‘Sambaga mungo osuna awaiyeba eso ka piske buihiaf.’ ");
INSERT INTO amn_n_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Eso ma ne esoiba so ma soldia ahui bitekfem sambaga mungo osuna anwasafe. Masa heafna pahlukuiag el ambugonam fighunam elim enaig esogonif ehe ati piske bihiag. Enag mwakwale mo sumi puguniba eba hugna amtanafef.” ");
INSERT INTO amn_n_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Eso Pailat esona og, “Sesi, soldia sulfunim ahunam biteg wa numwehe anwasa fiagfofum.” ");
INSERT INTO amn_n_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Eso ehengel ahunam bitegim kikisinim eso soldia mo kaguni agfofena. ");
INSERT INTO amn_n_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Afa isug auguia osuna mahim awaienaba afa leana gubi Maria Makdala wa nai i afa ming Maria i bitekfe ahnangwagim ahbona. Eba Sande angig osuna esahfena. ");
INSERT INTO amn_n_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Afa kugo nalig ilafona eso Ainiyagna ofwanai el penam bo puguna. Afa hun fa wahigi fenam eso enanai yi sisi gafena. ");
INSERT INTO amn_n_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ehena eligbi afwe lofena afa heafna lofugba busbusiagena lango lofug. ");
INSERT INTO amn_n_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Afa anwasag el ehem hugna embefenagini afa kiafigig geaskofenam apaigo melig pigieg lofug afogwafena. ");
INSERT INTO amn_n_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Afa enag ofwanai el sambaganigi angwafigim sihini og, “Nofeka embe ahfe, ati ka anwanafeg nenigi Sisasim ahyisgiegim ahbo. Enag elbi li katigegwa tigini kahlig. ");
INSERT INTO amn_n_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Eba mas ohiaba gi mo eba ati piske bihiakag ehe ati enaig sihifena. Sa ahbo ahnangu ehena kugum. ");
INSERT INTO amn_n_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Eso piske ikagna ahkanam pahlukuiag elim ahsihini, eso enaig sihi afen, ‘Ehe ati piske buihiagim eba Galili gam gof ikaf eso ne enanai yi ehem nanguf. Ati ka nem sihinig.’” ");
INSERT INTO amn_n_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Afa angwafig enanai ahwahianam ahkana, afa ehenigi embeafiahfnaba afa ming ehege mo sifakale ahfena. Eso kikini ahkanam pahlukuiag elim ahsihini. ");
INSERT INTO amn_n_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Afa ahakafenaba Sisas gwei ikagna pugu wambina ehe enaig esoni og, “Leawam”. Eso ehenigi ahbonam ehena mongim ahkehlanam unehlagim fingi ahfena. ");
INSERT INTO amn_n_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Afa Sisas sihini og, “Nofeka embe ahfe eso ahkanam kana nilitem ahsihinim eso Galili gam ahu so ma kam enanai yi nangui.” ");
INSERT INTO amn_n_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Angwafig mahimsi ahkafnaba afa mingnag anwasag el kimbig gam ahunam amunai prisim sihi goni mungwali so ahanaig ahanaig Sisasna biteg wa puguna. ");
INSERT INTO amn_n_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Afa amunai pris i afa amunai el nuwagigna mo sihiaginim eso ena soldiaim enaksag kig faigona. ");
INSERT INTO amn_n_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Afa ehengel soldiaim enaig sihif goni og, “So na enaig sihififni og, ‘Heafna pahlukuiag el sinaini ati ambugog meligbi fighug mahim ka askafenaba.’ ");
INSERT INTO amn_n_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Afa ateamba gavman na misog el ena moba ati higigba eba kagel ehem sihinagif eba mas ne olug kakageni.” ");
INSERT INTO amn_n_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Afa soldia kig finim gwenaig esini. Ena mo Juda nai el sihiageahuag ika gwesego. ");
INSERT INTO amn_n_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Afa 11 pela pahlukuiag el Galili gam ahunam mog wa opukona, Sisas ati ehengelim sihi wahiani. ");
INSERT INTO amn_n_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Mahim ehengel Sisasim nangunim ehena unehlagim fingifini afa mingnag sambaga onigina fini. ");
INSERT INTO amn_n_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Afa Sisas muhwa pugunam sihini og, “Mungwali heven wa nai i afa bite wa nai i God kam kigmog faigba eso ka wambugu. ");
INSERT INTO amn_n_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Enaig esegba afa so na ahu mungwali elim esegonigibi eso ma kana pahlukuiag el agfohi. So na ehengelim buwa Awagna afa Legna afa Godna Sungwag ni unehlag wa aiti. ");
INSERT INTO amn_n_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Afa so na ogfu fegonigi so ma ena mo mungwali pahlukui so ka nem faig. Nofeka eteti eba ka nem higeg wangafuf ikan ikan enag osuna awaiyef.” ");
INSERT INTO amn_n_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ohuna momba sifakalig mo lahlag Sisas Krais Godna legna mo. Autinam newug God Gishu Fwahiana el mungom, ona emba ka wa ningihiaf mungwali elim kwaganigim. (Ehena wunehalamba Krais, enag wunehalamba enag enaig eseg, elim kwaganigim God nangum wanbogum.) Enag Israel el enag elim enam nisanafafema. ");
INSERT INTO amn_n_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Enag enaig apekugonam enaig eso profet Aisaia ginofena enam. Profet el enag enaig eseafena Godum mengigim higifinim enag elim sihinugekafena. Godna mo enag Aisaia ginofena; Emba el kana mom ombuogum ka ningihiaf, emba wa neana gof yikaf. Mina nem numwehianagegim. ");
INSERT INTO amn_n_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","El enag bete amtakwaligwa agafuf el hwanigwa. Enaig wunonugum, ‘Ainiyagna mina numwehiahu, wankeneg mina esi. Enaig esi, nimbefena olug enag numwehiagi.’ Aisaia enaig ginofena iwanam. ");
INSERT INTO amn_n_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Enag Jon, buwa aitiag el, bete bihig wa ena puguna, enag Aisaia ginofena, enaig mo sihinugena, “Negel olug enag wahigifi, ahanaig ahanaig amtakwalig enag eso hwati. Enaigba ne esimbi, God nem enag ahanaig ahanaig amtakwaligim hugufatinif. Enaigba ne esimbi, emba sa ka nem buwa aiti.” Jon enag enaig sihinugena. ");
INSERT INTO amn_n_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Enag esoh el Judia provins wanai Jerusalem kimbig nalig yinai, afa mingnag kimbig Judia provinswa ena kimbig wanai gamba Jon nangum ambogona mo higigim. Eheafena amtakwaligim enag sihiagigim, enag Jon buwa aitina. ");
INSERT INTO amn_n_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon lofug lahlag awaienamba Jon kamelna lag lofugugum fatiafena. Sis lofug hugufugum kigiugwafena. Afa negba angtita wang suwig buk enag ehba neafena. ");
INSERT INTO amn_n_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Enag enaig mo Jon sihinugena, “El mungo kana sumi yi ombo. Ehena tifutukmba kam flafaitig. Kamba wangeneg elmo enag ahanaig ehefena gafungagba ka esemo. ");
INSERT INTO amn_n_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yawoamba kamba nem buwa mungo aitiaka. Ehemba kana sum bonam, emba sa nem Godna Sungwag mimangeni.” ");
INSERT INTO amn_n_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Enananamba Sisas Nasaret kimbig Galili provins wa agafena, enag ena kimbigim wahia bona. Jon Sisasim Jordan bu wa fatina. ");
INSERT INTO amn_n_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Afa Sisas buwanai fusufu pugunamba yikagna gwenagehe nangonamba of pitigiafonam Godna sungwag gamp lofug pembona Sisas nangum. ");
INSERT INTO amn_n_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Awagna wune of wanai pugunam esona, “Nemba kana leg, ka nem membenag. Kana olug nem lahlafenag.” ");
INSERT INTO amn_n_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Eso yikagna Godna sungwag Sisasim bete bihig gam el hwanigam esim ningihiana, og, “Eso ka!” ");
INSERT INTO amn_n_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Was enag mingwo puguka wahana afa mingwo yawo puguna gofnamba ena bete amtakwalig el hwanigwa Sisas enag aganam, eso Satan, sungwag amtakwalig enag, onanawo Sisasim gihnam wanigim ahanaig ahanaig amtakwalig esegim enam. Afa Sisas mas ena mom higna pahalukunamo. Sisas enag ehefwaimu mungo sisnga auguiafenamba. Ensel, Godna gafungag wanai of wanai Sisasim kwegfuni. ");
INSERT INTO amn_n_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Mayi Jon kalabus yi namba, Sisas Galili provinsgam bona puguna Godna mo lahlag sifakalig sihinugena, “Ena mo God yuwana sihina, enag ati pugug. ");
INSERT INTO amn_n_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ati muhwa puguagim ofe God elim wanagagim God afalig fenigim. Olug wahigifinim, ahanaig ahanaig amtakwaligim enag hwati. Godna mo lahlag sifakalig higinim pahalukahu.” Sisas enag enaig mo osoni. ");
INSERT INTO amn_n_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Sisas Galili wahegmeg bu muhwa langwagofena enag Saimonmi ehefena suminigmi Andrumi nangwauguna. Sambaga ningigi enag fufwala aitiagahfegofena Galili wahegmeg buwa, gwenaig gwesa ahfefenam sawog ahwambugo ahfegofena. ");
INSERT INTO amn_n_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Sisas sambaga ningigim enag enaig sihefeni, “Neningigi sawog ahwambugofena, yuwamba kam ahpahalumbo, enag ka nem sihinugem elim ah sulufugum, elim ahsulufunam ka nangum ah wan bogum.” Sisas enag enaig sihifeni. ");
INSERT INTO amn_n_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Yikagna el sambaga ningigi enag sawug kikiaugug gafungag enam ahwahianam Sisasim ahpahalukuna. ");
INSERT INTO amn_n_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Enagna gwesim wesig hilikanam eso Sebedini leningingim, Jems mi Jon mi enam Sisas nangwauguna. Sambaga ningigi enag botwa ahgofenamba fufwala numwehiag ahfegifini. ");
INSERT INTO amn_n_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Sisas sambaga ningigim wunoni, enag sambaga ningigi ehefena awagim Sebediim ahwahiana ahkanamba, eso, awagwo botwa agafena, ena gafungag wanai elingimba gweyi gofofena. Enag sambaga ningigi ahkanam Sisasim ahpahlukuna. ");
INSERT INTO amn_n_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Sisas ehefena nihiyinaim Kaperneam gam wankana. Mayi Sabat osu pugunamba, eso Sisas ehefena nihiyinaim Kaperneam nuwagig lalagam saho wankana. Sabat osunam Israel elmbi enaig esifini gafungafi hwanig, yusug auguiafena. Auguiafenamba enag ehefena nuwagig lalagam ahuafena Godna mo higigim. Enag Sisas gamba gwenaig eswanfena. Sisas ehefena nihiyinaiim Kaperneam nuwagig lalagam saho wankana. Ena lalawa elksa wahegagena agafena. Sisas tisana kugwa gohnam sihinugena. ");
INSERT INTO amn_n_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","El enag Sisasna mo higinim ol wahegesaina, enag enaig sihinugehufena, “Mingnag elbi Mosesna mom sisifugunu gifini. El enag enaig sihigoni ‘Ufuana mo higinim, pahalukahu.’ Afa Sisasba enaig sihinugehmo! Awai! Ehmba enaig sihifeni, ‘Kikefena mo higinim, pahaluku.’ Enamba enaig esenam, mayi sihinugeimba, amangal higinim olug wahigifigmbi. Ehefena mo kifutugum enag.” El enag sihigonugini. ");
INSERT INTO amn_n_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Enanam el mungo nuwagig lala wa agafena enag Satana nihiyinai amtakwalig ehena nihiyi gofena. ");
INSERT INTO amn_n_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Mo enaig osona, hlehlefukona, “Sisas Nasaret wanai, amang na kam bogum fenigim ombo? Amang na kam amtakwalehiagegimho? Ati ka nem olninginag. God nem gishu fwahiagim nem ningihiag ehefena gafungafegim.” ");
INSERT INTO amn_n_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Sisas Satana nihiyinai amtakwaligim enam nunumuafanam, enaig osona, “Mengig ka penifenam, elim enam wahianam pugubo.” ");
INSERT INTO amn_n_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Enag Satana nihiyinai amtakwalig enag kiafigikninina hlehlewo fukonam ehena nihiyinai puguna. ");
INSERT INTO amn_n_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Enag mungwal el enag olug wahig saina enag ehefum ol mewa sihiagahufena. Elimba amangwo? Elimba mulug mo. Elmbi suelimba anuana Satana nihiyinai amtakwaligim sihinigmbi enag ehena mengigim pahalug ahuag. ");
INSERT INTO amn_n_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Enag esenamba ena mo enag yikagna yikanam mungwal kimbig Galili provinswa eyi puguna. ");
INSERT INTO amn_n_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Sisas yikagna nuwagi lalam wahianam enag Saimon Andruana lalagam wankana mungwal Jemsmi Jonmi gamba. ");
INSERT INTO amn_n_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimona angwagna afagim eligim gih nolog gegofena enag kukwa gifini, enag yikagna ahunam Sisasim sihini. ");
INSERT INTO amn_n_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Enag Sisas ehenangum yikana, ningagana kikehalanam gifiolohuna. Afa eso gih nolog enag gweyi awaienamba, eso angwafig enag gweyi bwihianam wohof gafungafena elim kwagana. ");
INSERT INTO amn_n_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Owuipegnam sinainim, gihna elim Sisas nangum wambuk ambogona, mingnag wo gihna, mingnag wo Satana nihiyinai amtakwalig nihiyi gohonfini enaigim. ");
INSERT INTO amn_n_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Mungwal el enag kimbig wanai ena lala mengig muhwa mungwal nuwagena. ");
INSERT INTO amn_n_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ahanaig ahanaig gihim Sisas numwehenugena. Satana nihiyinai amtakwalig wahegagena enam Sisas nigitigina. Satana nihiyinai amtakwalig enag Sisasim ati olningini. Enaig fenamba enag Sisas Satana nihiyinai mengigim ka penifeni. ");
INSERT INTO amn_n_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Leawa kwimbiyim, Sisas bwihianam lala kimbigim wahianam, bete el hwanigam yikana, Godum sihinafena. ");
INSERT INTO amn_n_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Enag Saimon ehefena nihiyinaim wankanam Sisasim yisigiahuna. ");
INSERT INTO amn_n_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ahunam wufuinim eso Sisasim enag sihini, “Amang fegim osumba na bok? Mungwal el enag nem yisigiahu, ogogum ‘Kam kwagan,’ enam.” ");
INSERT INTO amn_n_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Sisas mungwag sihinugena, “Yuwanamba kawo mungwal mingnag kimbig muhwa gohka esim nahunam enanayi ka sihinugekam. Enaig fegmba enag ka osum bok.” Sisas enaig sihifeni. ");
INSERT INTO amn_n_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Enag Sisas yikana mungwal kimbigim Galili provins wa, enanayi langwagofena. Sisas mungwal nuwagigim lalawa mo sihinugena, enag Satana nihiyinai amtakwaligim elni nihiyinai ningitigiafena. ");
INSERT INTO amn_n_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","El mungo enehegog amtakwalig Sisas nangum bonam. Mogukuk kwakwagenam wenamonag sahna, “Na sawiyifegba, emba sa na kam enag lahlafenagei.” Sisasim enaig sahanafena. ");
INSERT INTO amn_n_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Sisas enag nalig afafena, mas embefenamo yikagim enaig elni muhwa puguagim enag ehefena ningagana enag elim tuhunam, enag sihina, “Ka sawiyifeg, nem ma lahlefei.” Sisas enaig sihifena. ");
INSERT INTO amn_n_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Yikagnamehe gih gweyi awaienam enag lahlafena. ");
INSERT INTO amn_n_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Sisas enag elim tifutuk mo sihinagenam eso yikagna ningihiana. ");
INSERT INTO amn_n_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Sisas enag osona. “Nofeka amanim sihinam esel ka nem esenag enam. Awai! Godna lala naligim yika pris nangum. Pris el enag enaig esfafif amang amang ofa enag el mayi wambuk ambogomba eso pris enag ofa enag Godum fa faiyif. Yikanam enag elim enag nimbefena eligim enam ogfunai, eso ma nem sihinai, ‘Nem gihba ati awaieg.’ Mayi nem enaig sihifenaimba eso Mosesna mom pahalukwi. God ena mo autinim Mosesim faina enag Moses ginofena, ena mo enag enaig osog. Amanim gih nihiyinai awaiegmba eso ma enaig esei amang amang enag Godum fai. Nemble enaig esei. Esba na feimba emba el olningif nem gih ati wanganefeg.” Sisas elim enana enai sihifena. ");
INSERT INTO amn_n_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Afa enag el enag yikanam muhwa sihiagena, ena mo enag mungwal kimbigam yikagna kagena enag elksa enag Sisasim yisigiahefena. Enaig fenamba enag Sisas yikagim elni nofwa kimbigam sahoagim enag wahiana. Awai! Kimbig meigim el hwanigam gofena. Ahanagna, ahanagna kimbig wanai enag el enag Sisas nangum ambogwafena. ");
INSERT INTO amn_n_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mingnag osuwi mayi kanamba eso Sisas piskenam Kaperneamgam yikana, lala wa agafena enag mungwal el enag higini. ");
INSERT INTO amn_n_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Enaig fenamba eso mungwali el enag nuwagena, lalam megim enag el mungwal kigfana. Mengig muhwa gamba kuk goho hwanig fenam enam. Eso Sisas mo sihinugegofena. ");
INSERT INTO amn_n_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Figinyegwa gohna el enag elim elig lihiligim Sisas nangum ombugun. ");
INSERT INTO amn_n_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kuk enag kigfagena mungwal el enag, enag ahnaig esigim Sisas muhwamba ombugugum fakihmo. Enaig fenamba enag wofusigim ofukwalagonam, eso enag wofus tutuni Sisas esel gofna enaihwa. El gihna kukwa gifini, enam weawa kikehalafinim opigona ehefena kuk noholugum weawa hilihili fak apeigona. ");
INSERT INTO amn_n_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ati olningini Sisasba emba wa kwegofuf. Sisas anuwana fenamba enag elni olningugugum enag ati olningini, enag Sisas gihna elim enam sihina, “Nilite, ahnaig ahnaig amtakwalig esoh nesena, enamba, ati ka nem hugufatinag.” Sisas enag enaig sihifena elim enam. ");
INSERT INTO amn_n_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mingnag anuana el auguiafena. El enag Mosesna mom ati olninginim enag ogofunugifini. Enag el enag auguiafenamba Sisasna mom higifinim, ol mewa enaig olningugefafena, ");
INSERT INTO amn_n_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Amangim enaig sihimba feg? Elmbi elimba Godum kiapasefag flafatig. Aman ahnaig ahnaig amtakwaligimba hugufatif? God mungwehe!” Anuana el enag enaig olningugefafena. ");
INSERT INTO amn_n_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yikagnam gweyiehe Sisas ehelni olugum enam olningini. Enaig fenamba enag Sisas elim enag sihini. “Amang figim negelmbi nimbefena olyimba enaig olningugefa? ");
INSERT INTO amn_n_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Aman elim ningagag elig enag lilhi fesaina enamba sihinaf, ‘Ahnaig ahnaig amtakwalig esoh nesena enamba ati ka nem hugufatinag.’ Enamba amanwo enaig sihifena, ena, mo enag yinime? Awaime? Mas na nangunimo. Afa amanwo sihina, ‘Bwihianam nimbefena kuk fanam yika.’ Aman enaig sihifena, ena mo enag yinime? Awaime? Embawa na nanguf. ");
INSERT INTO amn_n_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Enag yawomba ka nem ogofuni kamba El Enag God Ningihiana Of wanai enag yawomba ka nem ogofunug God kam tifutuk faig mungwal bete esel enam enaig ahnaig ahnaig amtakwaligim hugufatinigim.” Sisas enaig sihifena. Enag Sisas elim elig enag lihlig feagena enam sihina, “Yawomba ka nem sihina, ");
INSERT INTO amn_n_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Bwihianam nimbefena kuk fanam nimbefena lalagam yika.” ");
INSERT INTO amn_n_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Sisas mayi enai sihifenamba eso mungwal elni nofwa gihna el enag bwihianam, ehefena kuk fanam yikagna pugukana. Enaig mayi esenamba, eso mungwal el enag olug wahegesaina, eso Godna wunehalam gufiyi sisyigem fukwalagonam. Enaig osogona, “Autinamba mas ka enaigba nangufinimo.” ");
INSERT INTO amn_n_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Sisas piske yikanam wahegimeg bu Galili muhwa engig wa langwagofena. Enagsa el ehe nangum ambogonamba, enag. Sisas Godna mom sihinugena. ");
INSERT INTO amn_n_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Sisas yikanam, Alfiusni legim Livaim nangona. Livaiba takis wambuguk el enag takis lala wa agafena. Sisas Livaim sihina, “Kam pahalumbo.” Livai bwihianam Sisasim sum pahalukuna. ");
INSERT INTO amn_n_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Sisas enag esena yikanam Livaini lalagam fukonam agafenamba wohof neawofena. Sisas ehefena nihiyinai gamba mungwal auguiafena. Eso enagsa takis wambahug el i mingnag el gimba ahnaig ahnaig amtakwalig esehufena enag el gimba auguiafena. ");
INSERT INTO amn_n_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mingnag anuana el Mosesna mo fig afa Farisi el. Enag el Sisasim nangunim ahnaig ahnaig elngi ahagafafena, takis wambuguk el afa mingnag elim osogoni amtakwalig el, enag el Sisas ga wohof ahagafafena. Farisi el enag nangunim, enag Sisasna nihiyinai elim sahigoni, “Amang fegim wohof mba mungwal el gimba ahaga, takis wambuguk el, ahnaig ahnaig amtakwalig esehug el gimba? Amang fegim Sisasba enaig elimbi wan neawofena?” Farisi mayi enaig sahigonibi. ");
INSERT INTO amn_n_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Sisas mom enam higinam eso sihini, “Amangal gih hwanig mba mas dokta nangumbi ahwi. Awai! Gihna mungwehe dokta nangumbi fehuf. El enaig osogona, ‘Kagelmbi wangeneg el!’ Kamba enaig elim wunonugum bwahmo. Awai! Kamba bogum el ahnaig ahnaig amtakwalig esehufena enam wunonugum ka bok.” ");
INSERT INTO amn_n_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Mingnam Jonna nihiyinai afa Farisi el gimba wohofum kwegfini. Mingnag el ambogonam Sisasim enaig sihifini. “Ahnaig asegmba enag Jonna nihiyinai afa Farisi el gimba wohofumba kwegig ahufena, afa neana nihiyinaimba mas wohofum enag kwegifinimo?” ");
INSERT INTO amn_n_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","20","Enag Sisas sihini, “Enag aman angwafig afafimba, ehefena nilite i, hiheg i, enag nuwagif sifakalinigim, angwamig fak el, mungwal gofofimba, enag yuhwahofeg. Mayi el enaig nuwagimba, wohofum kwegime? Awai! El mulug angwamig fak enag agagba mas wohofumba kwegi. Enag hwaonam mingnag el elim enam mayi fighuimba, afa enanayi gohog hwanigwa mayi feimba enanamba sa yuhwafe ehena hiheg so wohofum enag kwegig. Enag kamba el angwamig mulug fag lofug. Enag ka gofofenamba kikefena nihiyinai mungwal esel enag ohunanam enag el sa sifakali, mas wohofum ba kwegi. Esenam hwaonamba el amtakwalig kam sulufif, kam amtakwalefif, enag mas ka gofofi kikefena nihiyinai ga mung wal mba enag enanamba sa kana nihiyinai enag afafinim wohofum kwegi.” Sisas enaig sihifeni. ");
INSERT INTO amn_n_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Sisas sawiyifena Farisim mulug olningugigim ogofunugum enaig fenamba enag ahnaig ogofunuhmo mulugum enam. Enag el enag autinai mom mahiyim pahalug ahuafena. Enaig fenamba enag Sisas wanag enag wahiyini, enag wohofum enag mas kwegifinimo. Enag Sisas Farisim piskenam osoni. “Afa aman lofug nimyegmba fanam autinai lofug megimba kwelif? Awai! Enaigba eseimba, emba ena lofug nimyeg enag autinaim kufuwahiamba, meg pugunam numbif. ");
INSERT INTO amn_n_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Enag amanwo nimyeg wain bugba efiyif sis meme lofug autinai wulawamba? Emba, awai! Enaigmba eseimba wainbug ena wolawa kukunam mungwal amtakwalenam awaief. Awai! Elmbi mulug wainmbug mba mulug wola wa fanunguf.” ");
INSERT INTO amn_n_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mungwagim Sabat osunam enag, enanam Sisas ehefena nihiyinai ga mungwal aisagafe kafena wit asowa. Enag witbi rais lofug enaig feg. Ena wit fug enag pwatahaga fehufena. ");
INSERT INTO amn_n_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Enag Farisi el enanayi gofwehenam Sisasim nanguni. Farisi el enag Israelna lotum Ainiyag el fini. Enag Farisi el enag Sisasim sihini, “Mosesna moamba enaig osog, ‘Sabat osunam enag nofeka gafungafim, enag osuinamba esug ehe auguiafum,’ Mosesmba enaig sihifena.” Enag Farisi enag Sisasim enaig sahanafini, “Amang figim neana nihiyinai mba enaig mba esig?” ");
INSERT INTO amn_n_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Sisas Farisim sahini, “Mas na ginofumba buk wa naiimba numwehe fahegagikmo amang eseli Devit autinam esegena enamba. Enanam enag Devitna nihiyinaim enag wohof awaienimba ena bini pigina. ");
INSERT INTO amn_n_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Enanam enag Abiatar Israel pris elni mungwal sisiyi feni, alawieg feni. Prisni gafungag enaig fena, amang amang mungwal el prisim faifinimba, pris enag Godum faifini. Enanam Devit Godna lalagam sahonam bret fa nena Godna nohmbosogam gifini enag. Ena bret enag kwegig, pris mungo ahagafena. Enag Devit nenam ehefena nihiyinaim gamba faini. Enaig esenamba yuhwafena. Ena mo enag mas na fahegaginimo?” Sisas enaig sahinena Farisim. ");
INSERT INTO amn_n_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Sisas enaig osona, “God enag elimbi mas enaig sihifenigmo, ‘Negel enag Sabat osuwum kwegfu!’ Awai! God Sabat osuwum gishu fwahiag elim kwaganigim. ");
INSERT INTO amn_n_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kamba El Enag God Ningihiana Of Wanai, enag Ainiyag ka feg. Sabat gamba enag kamble mungo osog amang yuhwamba feg Sabat osuinamba.” ");
INSERT INTO amn_n_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Sabat osunam enag Sisas Israel elni nuwagig lalagam piskenam yikana. Enanayi el mungo ningagag lilhig agafena. ");
INSERT INTO amn_n_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Enag mungwal el enanayi Sisasim nangwagofofena. Enaig olningini. “Elim enam wa numwehenageime? Awaime? Yuwa Sabat osunam enag Sisas wa gafungafeime? Awaieme?” Mungwali el enag enaig olningini. Sisas mba enag Sabat osuinamba gafunga feimba, emba nunumufinim kotinif. ");
INSERT INTO amn_n_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Sisas el ningagag amtakwaligim enam sihina. “Bonam olugi goh.” ");
INSERT INTO amn_n_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Sisas sahini el mungwal elim eseli nangwagofofena enam, “Ahnaig Mosesna momba osog? Sabat osunam enag bigba lahlafiime? Awaimba, big amtakwalefiime? Enag osunam enag amang big fimbi enag yuhwamba fef? Enanam enag big elimbi kwaganime lahla goheigim enam? Awaimba nawo elim enam kugwag sungo fiime?” Sisas enag elim enag enaig sahinina. Enag el ati olningini Sabat osunam elim lahla fehiaogug yuhwafef, enag el enag mas osogonamo. ");
INSERT INTO amn_n_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Enag Sisas nofna nangwagihiagegofenamba enag ehim olug kakagna. Afa Sisas ati olningini enag elni olug enag numwehegim olningugig hwanig. Enag Sisasim olug kinina, enag Sisas ningagag amtakwalig elim enam sihina, “Ningagag fa suf.” Enag el enag ningagag fasufinimba ningagag ena yuhwafena. ");
INSERT INTO amn_n_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Yikagnam Farisi apekugo ahunam nuwagena Herotna nihiyinai ga mungwal. Enag nuwagenam sihiagehufena, “As big Sisasimba finim eso big tigegif?” Enaig sihiagehufena. ");
INSERT INTO amn_n_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Sisas ehefena nihiyinaim wankana ena kimbigim wahiyinim wahegimeg bugam ahuna. Enagsa el enag ambogonam Sisasim pahalug ahuefena. El Provins Galilinai, mingnag provins Judianai, ");
INSERT INTO amn_n_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","mingnag kimbig nalig Jerusalem wanai, provins Idumeanai, mingnagwo Jordan mingig yinai afa mingnagwo kimbig Tair muhwa nai, afa mingnag Saidon kimbig enagsa el enag amang Sisas fegim eseli enam higini, enag el enag Sisas nangum amgogona. ");
INSERT INTO amn_n_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Sisas ehefena nihiyinai elim sihini, “Enagsa el gofwehe enag ka wa kaguwonuf, enag bot numwehiagifum, keso esim yika fugom.” ");
INSERT INTO amn_n_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Enagsa elim gihnam enag numwehehianug akafena. Enag mingnag el wahegagena gihna enag ambogonam Sisasna nihiyi, og, ona nawo Sisasim tuhum. ");
INSERT INTO amn_n_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Mingnag el Satana nihiyinai amtakwalig nihi mewa gohonfini enaig elim enam wanambogona. Satana nihiyinai enag Sisasim nangunim, enag elni mogukuk kwaogonuginim Sisasim enaig wunini, “Nemba Godna leg.” ");
INSERT INTO amn_n_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Enag Sisas Satana nihiyinaim enam tifutuk mo sihini, “Nogofeika sihim kamba aman!” Sisas enaig sihifeni. ");
INSERT INTO amn_n_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Sisas mugam fukokanam. Enag eso amangalim esel ogum, “Kawo gisfuhwatim,” elim enam awamoni, og, “Ambogo,” eso el enag ehenangum ");
INSERT INTO amn_n_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","12 fena enag elim enam gisfu hwatina ona, “Kawo wan gohonifefum, afa enam enag keso ningitigim kana mom sihigonugehugum. ");
INSERT INTO amn_n_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Kawo ehelim enag tifutik faiyim, so ma Satana nihiyinai amtakwaligim enam hugufuhiagonugi.” ");
INSERT INTO amn_n_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Enaig fenamba enag eso 12 fenam enag elim enag gisfunam hwatina Saimonumwo enag meng wunehlam faina Pitam, ");
INSERT INTO amn_n_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Afa Sebedini leningigim sambaga ningigim enag enaig wunehalam faini Boanerges, enag Boanerges wunehalamba enaig eseg ‘hugni luwal’, ");
INSERT INTO amn_n_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andru, Filip, Bartolomyu, Matyu, Tomas, ming Jems Alfiusna leg, Tadius, Saimon, Selot elyinai, (Enag Selot el enaig eseahufena mingnag el amang amang amtakwalig eseahufena Selot el enag elim enam tifutuk mo sihigon ahufena.) ");
INSERT INTO amn_n_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iskariot, Judasba el esel enengim Sisasim mingnag elim wa fainif, og, “Ma tigegi enag el.” ");
INSERT INTO amn_n_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Eso Sisas lalagam yikana, enag, elksa piske ambogonam nuwagena. Enaig fenamba ena Sisas ehefena nihiyinaim enag wohof ahanana wanehmo. ");
INSERT INTO amn_n_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Sisasna niliteg el higinim, eso ambogona ogona, “Nawo Sisasim wanigiahum.” Mingnag el enag enaig osogona. “Sisasba mwetitig el.” ");
INSERT INTO amn_n_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mingnag el, Mosesna mom anuanafig, Jerusalem kimbig wanai ambogonam, enaig osogona, “Belsebul, ming wunehalamba Satan, enag Sisasna nihiyi gofwehe, Belsebulmba ehefena nihiyinai amtakwaligna Ainiyag amtag. Belsebul Satan enag Sisasim tifutuk faig, so ma Satana nihiyinai amtakwaligim hugufuhianugei.” Anuana el enag enaig osogona. ");
INSERT INTO amn_n_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Sisas elim enam wunoni, “Ka nangum ambogo,” enaig osonim eso enawasim sihini, “Ahnaig asenam eso Satan mba ehefena nihiyinaimba hugufatif? ");
INSERT INTO amn_n_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","El mungwa kimbig wanai mba toogonam esi ka osu ka feimba emba mas tifutinam gohwi. ");
INSERT INTO amn_n_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","El mungo lalanaimba apeigonam esim ahu osum ahumba fimbi, emba mas tifutinim auguiafi. ");
INSERT INTO amn_n_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Enag Satan mba ehefumba tigeimba emba ehena nihiyinai enag olugyi towoguf, emba mas tifutinim auguiafi. Awai! Emba wa yikagnam wa awaief! Enag Satana nihiyinai amtakwalig ka ningitigigba Satana tifutukni ka esehmo. Awai! ");
INSERT INTO amn_n_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Afa el mungwamba ahnaig yika sahogum tifutuk elni lalagamba ehena gawigmba wambuhmo. Awai! Enaigba eso fefimba emba so ma tifutuk elim enag weana kikenam wahianam, eso ma mungwali gawig enag ehena lalanaimba wambugei.” Sisas ehefena mom sihiagena elimba ogofunugum ehe Satanimba enamba flafatif. ");
INSERT INTO amn_n_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","30","El enag enaig sihiagini. “Sisas mba Satana nihiyinai amtakwalig ehena nihiyi go.” Enaig fenamba, enag Sisas sihini, “Yini newug ehe, ka nem osonug, ahnaig ahnaig amtakwaligim elmbi esimbi, afa mungwal mo ahnaig ahnaig amtakwalig enag elmbi sihiaginim enamba Godum asahnafimbi, elimba embawa God hugufatinif. Afa aman Godna sungwagimba kiagaseafaimba, emba God enag mas hugufatinai, yawo ohunanam afa enengim gamba. Awai! Ehena amtakwalig mba gwesenam gofuf.” Sisas enaig sihifeni. ");
INSERT INTO amn_n_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Eso enanam enag Sisasna afagna suminimbugugna ambogonam apekugona. Enag ambagam gofofenamba eso el mungom ningihiyini ogog yika Sisasim wunona. ");
INSERT INTO amn_n_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Elksa Sisasna muhwa ogwiefena, enag el enag Sisasim sihini, “Higi, neana afagna suminimbugugna muluwalningagna ambagam gofohmba nem wununug.” ");
INSERT INTO amn_n_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Eso Sisas elim enag sahini, “Amangalwo kana afahumoanig suminimbugug mba?” ");
INSERT INTO amn_n_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Enag enaig sahininenam eso el esel ehena muhwa ogwiefena enam nangwagihiagenam eso osona, “Ohunag elmbi kana afahumoanig suminimbugug muluwal ningag. ");
INSERT INTO amn_n_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Amanga Godna sawiegim pahalug ahuagimba, enag el enag kana suminimbugug, muluwalningag, afahumoanig,” Sisas enag enaig sihifena. ");
INSERT INTO amn_n_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Sisas wahegimeg bu muhwa piskenam elim mo ohofunugena. Elksa Sisas nayi ambogonam nuwagena enaig fenamba. Enag Sisas botgam fukukanam agafena bot buwa gofena enanayi. Elksa engigwa bu muhwa auguiafena, ");
INSERT INTO amn_n_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","enag eso Sisas enagsa mo enawasim enaig sisifunugena. ");
INSERT INTO amn_n_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Negel higi! El mungo yikanam asowa wit nog rais lofug aitiagena. ");
INSERT INTO amn_n_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Enag aitiagafenamba mingnag witwo mina wa apeigona. Enag twafig ahagana. ");
INSERT INTO amn_n_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mingnag betewo hun etinyaksa singaugum afugwafenamba enag betewo wesig sisigam fena enaig betewa mingnag witwo apeigona. Enag betewo nalig fe hwanig, enag wit weg mas numwehe bete megam apeigonam ahunamo. Enaig fenamba enag wit enag yikagna apekugona. ");
INSERT INTO amn_n_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Enaig fenamba enag osuwu mayi pugunamba enag wit enag ehesafesaina. Ena wit enag bagag hwanig fenamba ena ehesafesainam eso pigina. ");
INSERT INTO amn_n_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mingnag betewo we nasna gofofena enag mingnag witwo enag olugyi apeigona. Enag eso we nasna enag apekugonam wit nogum enam kilmoane sungofini enag wit apekugonam wesig fesaina mas fug lenamo. ");
INSERT INTO amn_n_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mingnag witwo bete lahlagwa apeigona, enag apekugonam numbiasaina, enaig fenamba ena fug lena. Mingnagwo enagsa feg 30, mingnagwo gwesim hilinam enagsa newog feg 60, mingnag gwesim hilinam amtakwal wahegageg feg 100.” ");
INSERT INTO amn_n_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Afa enam enag Sisas sihini, “Aman anganamba, ena mom ma numwehe higinam afa olningi.” ");
INSERT INTO amn_n_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Elksa mayi ahunamba, Sisas mungo gofena. Ehena nihiyinai 12 fenam afa mingnag el Sisasna muhwa gofofena, enag gamba apeigona enag enawasim enam Sisasim sahini. ");
INSERT INTO amn_n_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Enag Sisas enaig sihifeni, “God nem ati ogofunug mog mo megam sahogo enam, ena mo mba enaig eseg, amangal Godum pahalug ahuafena, enamba God wa wanagafuf. God ehe afalig fenam, God ehefena wanagagim enam nem ogofunugeg. Aman Godum pahalugua hwanigba eso enamba enawasim mungo wa higif. ");
INSERT INTO amn_n_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Autinam God profet Aisaiam ogofuna enag Aisaia enaig ginofena, Enag emba wa nangunim, afa mas nangwi afa enag moamba higinim moamba afa mas olnigigba fi enaig fenamba, enag olugbi mas wahigifi, enag ehefena ningalni ahnaig ahnaig amtakwaligim enag God mba mas hugufuiti fani. Aisaia enaig ginofena.” Enag Sisas enaig sihiagena. ");
INSERT INTO amn_n_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Sisas enaig sahinena, “Enawasim enag mas nolningigmo. Enamba nolningig hwanigmba emba mingnag enawasim enamba ahnaig olningig na fif. ");
INSERT INTO amn_n_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","El esel yihugeg elimba Godna mom yihugeg. ");
INSERT INTO amn_n_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mingnag nogwo minawa apeigog. Enag enaig feg, el mayi Godna mom higigmbi gwenanam ehe Satan bogum ehelni oluyinai Godna mom enag wambuk. ");
INSERT INTO amn_n_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Mingnag el wo enaig esig. Wit nog betewa apeigog hun singaugumwo afugwahba ena bete wo wesig sisiyigam gi. El enag enaig feg, ena mom enag yikagna higigim, enag sifakalinig, ");
INSERT INTO amn_n_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","enag Godna momba mas numwehe oluyi saigogmo, mas numwehe kifutuk olninginigmo. Afa enengim mingnag el mayi Godna mom piga wambuk apeigonam ehim enag kinig faiyimbi ehena Godum olningenag enag yikagna gweyi awaief. ");
INSERT INTO amn_n_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Mingnag elwo enaig eseg. Wit nog we nasnawa olugyi apeigona. Enaig el enag Godna mom higigim. ");
INSERT INTO amn_n_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Afa ahnaig ahanaigim ohuna betenaim enam membegonug enaig elni olugyi nag Godna mom kilmoanegonugini enag enaigmba el mas fug legmo. ");
INSERT INTO amn_n_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Mingnag elwo enaig esig, wit nog bete lahlagwa apekugog. Ena Godna mo ehigigim, figim kikeheligmbi enag el enag fug leg. Mingnagwo enagsa feg 30, mingnag wo gwesim numwehe hilinam enagsa newag feg 60, mingnag wo gwesim ilinam amtakwal wahegagna feg 100.” Sisas enaig sihifeni. ");
INSERT INTO amn_n_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Sisas enaig shifeni, “Enag aman mungwamba wi fanam somp mewa afa kife mewamba kumoahalaime? Awai! Sime sisiyi fa foholuf. ");
INSERT INTO amn_n_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Amang amang gawig esel yawamba megam agfo enag enag enengimba amba wa apekugof. Afa mungwal gawig aman atukulegim auguiagba, emba wa ena wi ambawa puguf. ");
INSERT INTO amn_n_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Amangal anganamba, eso ma numwehe higinim afa olningi.” ");
INSERT INTO amn_n_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Sisas enaig sihifeni, “Mo esel na higig, enamba numwehenim olningi. Amang enaihwa na fagmba enaigmba mingnag God nem faif, emba mingnag enag enagsa nem faif. ");
INSERT INTO amn_n_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Aman Godna olningugugum numwehe kikehalagmba emba God enagsa faif. Afa aman Godna olningugugum kikehalag hwanigmba, emba mas kikehalai. Yuwanam wesig esel fana ena gamba awaief.” Sisas enaig sihifena. ");
INSERT INTO amn_n_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Sisas ming mom enaig sihifeni, “God wanagagimba enaig eseg, el nog betewa aitiag akak. ");
INSERT INTO amn_n_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Mungwal sinainim enag gifugum osunam bwihiafugum yika ana nog apekugogum numbigim fuk legim enam enag el enag mas olningigmo, ahnaig asegim ena apekuguk. ");
INSERT INTO amn_n_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Bete ehehe gafungafegim eso nog apekugog, yuwanawo figeg pugug, gohogum musog pugug, gwesim hiligim fug pugug. ");
INSERT INTO amn_n_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Enaig esegim fug enag mayi numbigmba, eso el enag enam ati olningig lifug ati ambig, enag eso naifna fa lef lifug pwatigim.” ");
INSERT INTO amn_n_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Sisas enaig sahinena, “Ahnaig sefa big fif God wanagagimba? Ahnaig big esinim ogofuf enawasimba? Elimba enaig eseg. ");
INSERT INTO amn_n_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","El eseli mastet nog fanam betewa fatina, enaig mastet nogmba hwatambof kug lofug. ");
INSERT INTO amn_n_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Enamba pugunam numbinam mingnagim flafna aitif. Kagagmba naligehe aitiagef, twafig saigonam auguiafuf, gag gamba nimbagif. Mastet nog wasimba enaig ogofufeni. Hwaonamba God enaig wanagafef etinyagsa elim wambubunam, enam enaig lahla wanagafef.” ");
INSERT INTO amn_n_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Sisas elim enag ena mo sihini. Enagsa enawasim Sisas enaig sihifena. Ehefena nihiyinai elni pluningugug esel pugug enaihwa enam Sisas ihinugefena. ");
INSERT INTO amn_n_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Enaig esenam enawasim mo mungo mungwal elim sihini, afa ehefwaimu ehefena nihiyinaim mungo wangagfenamba, eso mog mo wo sihinifini. ");
INSERT INTO amn_n_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Enanam sinainim Sisas sihini ehefena nihiyinaim, “Nawo wahegimeg bugam minggam ehgam ahum.” ");
INSERT INTO amn_n_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Enag enagsa elim enam Sisasna ehefena nihiyinaina wasanim ahuna. Sisas enag gwena botwa agafenamba, ehefena nihiyinai enag gwesim ahunam saigona botgam. Ehefena nihiyinai enag botum ogohuna enag. Mingnag bot gamba mungwali ahuaminifena. ");
INSERT INTO amn_n_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Yikagnam gweyi fufwei nalig puguna buum gamba pupukuafukona botum heogwafatifefana. Botwa bu figfukonam ona nawo mengigwa pugum. ");
INSERT INTO amn_n_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Sisaswo botna masigim gifini pilowa ehefena musogumwo fakanam. Enag ehefena nihiyinai enag Sisasim osoni, “Sisifunug el, muhwa gweliehe bigim awaiofe! Mas na kam afafenigmo?” ");
INSERT INTO amn_n_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Enag Sisas bwihianam, fufweim nunumuafana, afa buum gamba sihinamba. “Huguafona!” Eso fufwei wahana, bu yuhwa gifini. ");
INSERT INTO amn_n_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Eso Sisas elim enam sahini. “Amang figim na embefig? Mas na Godna tifutukumbi olningigmo, Godmba yuhwa wafef nem kwaganigim, afa mas na olningugigmo God nem nangwagihiagewogumba enamba.” ");
INSERT INTO amn_n_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Sisasna nihiyinai enag amtakwal embefini, enag esinim ehefena olyi sihiagafafena, “Elmbi elimba amanwo? Enag fufwei i bu i mba ehena mom higi pahalukahug!” ");
INSERT INTO amn_n_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Sisas ehefena wanagag el ahuna apekugona minggam egam wahegimeg Galili buwa provins Gerasawa. ");
INSERT INTO amn_n_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Enanam enag yawehe Sisas botum wahiana betegam penamba. Enag el mungo hun megam (elim kumogofofna enagnai) pugunam bona Sisas nangum. Elmbi enamba Satanna nihiyinai amtakwalig ehena nihiyi gofena. ");
INSERT INTO amn_n_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Elim hun megam kumogofofna enanayi el enag fawofegofena. Enag ehim enag aman wena gamba ahnaig kikefehmo? Afa senna gamba, ahnaig kikefihmo? ");
INSERT INTO amn_n_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Gwenaig ehe gwesifinim ningagim mongugum senna kikeagifinim wahiyi finimba enag esefenam kukofenam tatuafena. Afa tifutuk el gimba ehim enag ahnaig kikehelafehmo! Awai! ");
INSERT INTO amn_n_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Osunam sinainim enag gwesefenam langwakafena hun megam elim kumogofohogwa aikiawa gamba sufgwafefena. Enaig esefena hlehlewofukofenam amtakwale wune fefena. Afa enaig esefena ehefena eligim hunwa gamba hegohwatiafena. ");
INSERT INTO amn_n_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Enag wahegwa gohonam Sisas nangonam enag enaig esena kikigni bonam Sisasna muhwa penam mogukug kwakwagenam Sisasna nohmbosugum hlehlewofukonamba ehena wuneg enag numbiagena. ");
INSERT INTO amn_n_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Sisas Satanna nihiyinai amtakwaligim enam sihina, “Elim enam wahianam pugumbo!” Sisas enag enaig sihifena. Enag Satanna nihiyinai amtakwalig enag Sisasim sihina, “Sisas, Godna leg, enag Godmba sisiyia newog feg. Amang na kam fenagim?” God bigim nangwagawo enag ka nem tifutigim sahanig, na kam mungwal amtakwal sungofef!” ");
INSERT INTO amn_n_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Enag Sisas sahana. “Neana wunehalamba amanwo?” Satanna nihiyinai amtakwalig enag piskenam Sisasim sihina, “Kamba enagsa, enag kana wunehalamba Ami” ");
INSERT INTO amn_n_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Enag enaig Sisasim sahini fini, “Na kam ohuna betenaimba ningitigif!” ");
INSERT INTO amn_n_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tata ksa aikieg wesig muhwa ahagag gegfofena. ");
INSERT INTO amn_n_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Satanna nihiyinai amtakwalig enag tifutinim Sisasim sahini, “Kam tatana nihigim ningitigi, kawo so ahunam saigona.” ");
INSERT INTO amn_n_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Enag Sisas sawiyifeni mahni. Satanna nihiyinai amtakwalig enag elim enam wahiyinim tatana nihigim ahunam saigona. Ena tata enag kikigni apeigonam aikieg pwapok amtakwaligam apeigonam ahuna. Mungwal tatamba enamba enaig esena wahegageg 2,000. Enag wahegimeg buwa apeigonam pigina. ");
INSERT INTO amn_n_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Tatam nangwagofohog el enag embem ahuna sihiagonugehuna kimbig wanai elim. Afa mingnag el aso lalanaim gamba, mungwal el enag kimbig wanai, asonai, ambogonam enag nanguni amang eseli ese pugug enam enag. ");
INSERT INTO amn_n_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Sisas nayi ahunam apekugonam eso elim enam nanguni autinam enag eseli Satanna nihiyinai amtakwalig ehena nihiyi gofofena enam. Enag el enag yawamba ati lofug aitiagenam agafena olningugug yuhwa fenam eso agafena. Elim enam nangunim eso embefini. ");
INSERT INTO amn_n_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Enag el enag enam nangunim eso ahuna sihiagahufena amang eseli elni nihiyi pugug afa tatana nihiyi pugunug enam. ");
INSERT INTO amn_n_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","El enag tifutinim Sisasim sihini enag elni kimbigim wahianim asika. ");
INSERT INTO amn_n_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Enanam enag Sisas mayi yikanam botwa asahofenamba, eso el eseli Sisas Satanna nihiyinai amtakwaligim hugufatina enag Sisasim sahana, “Kam wanigiahu!” ");
INSERT INTO amn_n_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Enag eso Sisas piskenam enaig sihina, “Nimbefena kimbigam piske yikanam, eso sihinugei amang eseli nem Ainiyag esenag enam enag, mungwal amang eseli God nem afafenagim nem kwegofog enam.” Elim enam Sisas enaig sihifen. ");
INSERT INTO amn_n_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","El enag eso yikanam ena mo sihiagena Dekapolis muhwa kimbig enag ningagagim pugufeogona 10 ena provinswa. Enag mungwal 10 kimbig enag mungwa wuhegalamba Dekapolis. Enanayi sihinugena amang eseli Sisas ehim esenagena enam. Mungwal el enag eso higinim olug wahegasaina. ");
INSERT INTO amn_n_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Sisas botwa piskenam yikana minggam wahigeg bugam enag elksa mungwal enag ambogonam Sisasnayi nuwagena wahigeg bu muhwa. ");
INSERT INTO amn_n_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","El mungo wunehalamba Jairus Sisasim nangumbonam. El enag nuwagig lalam Ainiyag fenam. Bonam enag Sisasim nangonam Sisasna mongug muhwa penam mogukug kwakwagena. ");
INSERT INTO amn_n_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Sisasim tifutinam sahana, “Kana luwal nainim muhwa wahagim ofe. Mayi na bonam tuhuimba eso ma wanganefenam; wangneg gohwi.” ");
INSERT INTO amn_n_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Enag Sisas ahkana. Elksa pahalug ahunam kigfagena. ");
INSERT INTO amn_n_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Angwafig mungo gofena lalawa fawo feakanam mingugiyi gohona yiamba enaig 12 fena. ");
INSERT INTO amn_n_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Dokta ksa ona nawo numwehenagifum enag ase ase fefininim wahiyini mas wesigngiwo wangenefenamo. Gwesim gweyi numbiakafena mungwal mani enag augiagena tatuna. ");
INSERT INTO amn_n_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Enag angwafig enag Sisasna mom higinam, enag boknam el numb eseli ahuafena enanayi puguna. ");
INSERT INTO amn_n_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Enaig olningugena, “Ka Sisasna lofugum tuhuimba, emba sa kam wangenefei.” ");
INSERT INTO amn_n_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Enag esena Sisasna masigim bonam Sisasna lofugu tuhuna. Enaig mayi esenamba enag yikagna lalawfawog enag awaiena enag ati olningenamba eso lalawafawog enag gweyi awaiena. ");
INSERT INTO amn_n_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Angwafig enag enaig esenamba, enag Sisas ati anuwanafena mayi tifutuk enag ehena nihiyinai penakanamba. Enag eso wahigifenam elksam enam nangwagenam, eso sahini, “Aman kana lofugumba tuhuk?” ");
INSERT INTO amn_n_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ehefena nihiyinai enag enaig osoni, “Ati na nangog, el wahegageg neana nihiyi muhwa. Amang fegim na sahig aman eseli nem tuhuk enamba?” ");
INSERT INTO amn_n_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Enag Sisas mahiyim fahegenugegofena ona nawo wufuam aman eseg enam. ");
INSERT INTO amn_n_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Enag angwafig enag ati olningena amang eseli pugug enam enag. Enag embefenam kiafigigi gayifena, enag bonam penam Sisasna mongug muhwa mogukug kwakwagena, eso amang eseli ehim puguna enam enag sihiagenam augena. ");
INSERT INTO amn_n_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Enaig mayi esenamba eso Sisas sihina, “Kana muluwal ati na kam olningenag. Kamba kifutuk feg nem kwaganyegim enag ati nem yuhwa feg. Yikanam afwahalana wangeneg agafum. Neana gihmba gweliehe mungwal awaieg.” Sisas enaig sihifena. ");
INSERT INTO amn_n_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Sisas mahiyim mo sihiagegofenamba mingnag el Jairusna lalanai ambogom. Enaig osogona, “Neana luwal nainimba ati wahag. Amang fegim na mungwelnimba anuana olmbi esefuku wanimbugumba?” El enag Jairusim enaig osoni. ");
INSERT INTO amn_n_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Sisas mas enam higinimo, enag Sisas Jairusim sihina, “Nofeka embefem, emba ka nem kwegofuf, numwehenam olningugifum.” ");
INSERT INTO amn_n_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Enag Sisas mungwal elim enam kweni, “Nogofei na kam pahalug ambogom.” Esonim, eso ehefena nihiyinaim mungo, Pita, Jems, Jemsni sumineg Jon enam sambaga mungom mungo wankana. ");
INSERT INTO amn_n_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Enag ahunam apekugona Jairusni lalawa Sisas nangwagenamba angogon ksa wahegagenam ehefum amtakwal ehuwehegehu fenamba wewatuawofena. ");
INSERT INTO amn_n_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Sisas sahokanam sahini, “Amang figim na enaig angweniasaga, amang figim na wewatuawo? Ena luwalmba enamba mas wahagmo, elimba nonhi gi.” Sisas enaig sihifeni. ");
INSERT INTO amn_n_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","El enag hekembegegwa titigegoni. Enag Sisas ambagam ningitiginam eso luwalna awag, afagim afa ehefena nihiyinai sambaga mungom enam mungo pasna saho wan kana ena kugam luwal eseli gifini esim. ");
INSERT INTO amn_n_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Eso Sisas luwalim enag ningawa kikehalanam Hibruni moana sihina. “Tabita kumi!” Ena momba enaig feg, “Luwal naini, ka nem osonag, bwihia!” ");
INSERT INTO amn_n_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Enag yikagna luwal naini enag bwihianam yikana. Ehefena yiamba 12 fena enaig. Enag el enag enam nangunim enag amtakwal olug wahegasaina. ");
INSERT INTO amn_n_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Afa Sisas tifutuk mo sihini, “Nofeka ena mo sihim, negel nofeka amanim mungo sihinim ena mom enam.” Sisas osoni, “Wohof luwal nainim enam fai.” Sisas enaig sihifeni. ");
INSERT INTO amn_n_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Sisas ena kimbigim wahianam piskenam ehefena kimbigam yikana. Enag ehefena nihiyinai enag pahalug ahuna. ");
INSERT INTO amn_n_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabat osunam enag yikana nuwagig lalagam. Godna mom elim sihinigim. Enagsa el ehena mom higini, enag olug wahegeasainam enag enaig osogona. “Elmbi elimba ahanagna mo fak? Enaig nalig olningugug elimba ahnaig olningugug? Enag enaig esegim, nalig ahnaig ahnaig gafungafag. Mas big autinamba enaigmba nangunimo. Ahanagna tifutuk enaigmba pugunug? ");
INSERT INTO amn_n_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Elmbi elimba lala nimbaogog el sini? Mariana leg? Jems Josep Judas Saimon enag elni eteg sini ehe? Ehena muluwalningag gamba ohwi big mungwal auguia?” Enag ehel enag esinim, Sisasim mas fatini. ");
INSERT INTO amn_n_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Enag Sisas sihini, “Aman profet eseli, mungwal el mingnag kimbig wanai enag emba profetna mo wa higif. Afa ehefena kimbig wanai afa ehefena nilite afa lalanai ehefena mungo wo mas fatinif.” Sisas enaig sihifeni. ");
INSERT INTO amn_n_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Enaig fenamba enag amang tifutuk gafungag enag ena kimbig wa mba mas esei. Enag esenam mungo mungog elim ehe tutohilinam lahlafehiagena. ");
INSERT INTO amn_n_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Enag Sisas olningugena. “Ahnaig asegmba enag, mas numwehegim kam yinim olninginigmo, enag kam ogogum, ahnaig asegim Sisas kam kwaganihmo?” Sisas enaig olningugini. Eso Sisas yikanam langwakafena mungwal kimbig eseli enanayi Godna mom sihinugakafena. ");
INSERT INTO amn_n_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Enag ehefena nihiyinaim 12 fenam enam wunonim, enag enaig esena ningitigi fena sambagahka sambagahka fini. ");
INSERT INTO amn_n_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Enag tifutuk faini. Satanna nihiyinaim amtakwaligim ningitigifigim enam. Enaig osoni, “Nogofeka gawig wambukahum, afa mungo wambuk ahwi, nogofeka bret wambwi afa mani wolagim afa mani ga, enag nogofeka wambukahum. ");
INSERT INTO amn_n_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Su mungo aitiaogwi. Nogofeka ninegna siot sambaga wambtim, mungo mungog wambwi. ");
INSERT INTO amn_n_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nahunam kimbigwa mba apekugonam mayi nem amanba ehefena lala gamba wankaimba eso gweyi mungo wa ahunam auguiafi. ");
INSERT INTO amn_n_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nahunam kimbigwa apekugonam el enag nem awamogonug hwanigba, negelni mom higigonug hwanigmba, emba so ena kimbigim enam hwahiyinim, eso enaig esi mongyinai hunigesige wambihiaginim, enagna elim enam ogofugoni el enag amtakwalig esig.” Sisas enaig osoni. ");
INSERT INTO amn_n_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Enag ehefena nihiyinai enag ahunam enaig mo sihigonini. “Negel olug wahigifi, ahnaig ahnaig amtakwalig enag hwati.” ");
INSERT INTO amn_n_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Enag enagsa Satanna nihiyinai amtakwaligim enam hugufuiti fegoni, afa mingnag gihna elim wel buk eligim sugufugonuginim numwehegonugini. ");
INSERT INTO amn_n_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ena mo Sisas, ehefena nihiyinai i esel enaig esini, ena mo enag mungwal kimbig ena kagna, enag eso Herot gamba enam higna. Mingnag elwo enaig osogona, “Jon bu wa aitiag el wahagim piske bwihiag. Enag eso ena tifutukni amang amang gafungag nalig enag esofe mungwal fena.” ");
INSERT INTO amn_n_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mingnag elwo enaig osogona, “Elaija emba.” (Elaija mba profet autinai), afa mingenag elwo enaig osogona, “Sisas mba ming profet, autinai profet lofug.” ");
INSERT INTO amn_n_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herot gamba enam hignam, enag eso enaig osona, “Jon bu wa aitiag me? Enag ka enam embefeg. Autinam Jonna wuningligim ka hegefatina. Ena me piske bwihiana?” Herot enaig olningugena, enag Herot enag embefena. ");
INSERT INTO amn_n_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Autinam King Herot ehefena suminig Filipni angwafigim fana Filipna nihiyinai. Enag angwafig wunehalamba Herodias. Enag Jon bu wa aitiag el enag Herotum sihinagofena gwesenam, “Mas lahlafegmo nimbeafena suminigna angwagim na fak.” Jon enag Herotum enaig sihifenagofena. Enaig fenamba enag Herodias olug kakagna. Herodias enaig fenamba, enag Herot ehefena soldiam ningitigina Jonum ahu sulufim bogogum kalabusigim ningagag mongugum senna kikenagini wahiyim. Herodias onanawo, “Jonum tigeakam!” Afa Herot enag mas wahianamo. ");
INSERT INTO amn_n_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herot ati olningena Jon mba lahlag, Godna el. Enaig fenamba, Herot Jonum embefena. Herot Jonum enaig esenam kakagwo fefukufna. Herot onanawo Jonna mom higifum afa enag minggamwo olkinig wahegagena. ");
INSERT INTO amn_n_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herodiasna olug kakagig nalig enag gwesenam gofena, enag ati yisiginam wufuana Jonum tigegigim Jonum eseli enam enag. Enam ati gishu fwahiyini Herotum afag fukuana enag osuwum, enag osunam wohof enag wan ahagagnam enanam. Mungwal gavman, ami, Ainiyag, Galili nai, enag el enag ambogona wohof ahagagim enam. ");
INSERT INTO amn_n_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mayi enag el enag ahagafenamba, Herodiasna leg naini enag enanam bonam ilakafena. Enag eso mungwal Ainiyag el eseli enag lahlafini. Enag King Herot luwal nainim enam sahana, “Amangim na membegmba, ka so nem faim. Emba ka newa faif amangim na sahif. ");
INSERT INTO amn_n_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Yinimehe kosok, na sahiimba kana mungwal gawig eseli, enag ka nem olugi towogonam faif.” Herot luwal nainim enam enaig osona. ");
INSERT INTO amn_n_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Enaig fenamba enag luwal enag yikanam afagim sahana, “Amangim ka osonaf, kam fai.” Afag enag osona, “ Jon bu wa aitiag elni mesog kam fai, enaig esonai.” ");
INSERT INTO amn_n_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Luwal enag yikagna piskenam Herot nangum yikanam, enaig tifutinam osona, “Jon bu wa aitiag elni mesog pletwa fatinam ka fai.” ");
INSERT INTO amn_n_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Luwal naini enag mayi enaig osonamba, eso King Herot enag afaf nalig newug fenam enag ahnaig asoahmo? Yuwanam luwalim enag ati sihina, el eseli auguiafena enag elni nofwa enag ati higini. ");
INSERT INTO amn_n_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Enaig fenamba enag Herot soldia mungom ningihiana, yikanam kalabus lalagam sagoham Jonna mesog hegefanam pletwa fatinam ombuna. ");
INSERT INTO amn_n_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Enaig esenam, luwal nainim fainamba, eso luwal naini enag afagim okunam faina. Herodias enag Jonum yusug tigeakana. ");
INSERT INTO amn_n_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jonna nihiyinai enam higinim enag ambogonam Jonna eligim finim ogohunam kumoahalini. Enaig fenamba enag Herot Sisasna mom higinam, enaig olningena, “Jon bu aitiag el piske bwihiag,” enaig fenamba enag Herot embefena. ");
INSERT INTO amn_n_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Sisasna nihiyinai piskenim ambogona. Yuwanam Sisas eseli ningitigina ehefena mo finim elim sihigonug ahufena. Enag piskenim ambogonam Sisasna nihiyi nuwagena sihiagini amang eseli esini, afa mo ieseli faigona enam. ");
INSERT INTO amn_n_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Enagsa el ambogofenam fagufegofofna, enag Sisas ehefena nihiyinaimi ahanana wohof wa neanemo? Enaig fenamba enag Sisas enaig osoni. “Big mungo nawo ahum el hwanig betegam, eso negel enag ahunam ehe fi.” ");
INSERT INTO amn_n_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Enag bot finim minggam el hwanigam ahuna. Sisas enag ehefena nihiyinaim mungo wankana. ");
INSERT INTO amn_n_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Enaig esini, mungwal nangwaginimba Sisas ehefena nihiyinaim mungo wankafena, ati olningini. Enag mungwal el enag mungwal kimbig wanai enag betemina kikigni ahunam apekugona Sisaswo mahiyim wanfeafenamba afa ehelwo atiahunam gofofna. ");
INSERT INTO amn_n_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Sisas bot wanai penam engigwa pafenam nangwagnamba elksa wahegagenam agafena, enag eso Sisas ol mewa afafeni. Sisas olningena el enag sipsip lofug, tata luwalig lofug el nangwagofohof hwanig, enag Sisas enag elim ol mewa afafeni, enag Sisas gweyi enagsa mo sihinugena enag elim. ");
INSERT INTO amn_n_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Osuwu yika pefenamba, Sisasna nihiyinai enag ambogonam Sisasim osoni, “Osuwu yikagim opemba ohunanayimba el hwanig. ");
INSERT INTO amn_n_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Elim enam ningitigi mahunam wohof manina wambugi mungwal kimbig muhwa eseli enanayi.” ");
INSERT INTO amn_n_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Sisas piskenam sihini, “Negelehe wohofmba faigo.” Sisasna nihiyinai enag Sisasim sihini, “Na sawiyi fegho kawo ahunam nalig manina 200 kina enana wohof wambugonum elim enam? Ahanagna wohofum big wambugonuhmo el numbum enam? Awai!” ");
INSERT INTO amn_n_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Sisas sahini, “Negelni bretmba ahanansi? Ahunam nangu.” Ahunam fahegenim enag osogona, “Kagelnimba afa pugufeg enansi bret, afa sawugwo sambaga.” ");
INSERT INTO amn_n_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","Sisas ehefena nihiyinaiim sihini, “Sihigon eso ma auguiagai ahiyiogu ahiyiogu ma fahwi pos wankenegwa eyi.” Sisas enaig osoni eso mingnagwo numwehenam enagsa 100 auguiafena, afa mingnagwo hofawum 50 numwhehfenam auguiafena. ");
INSERT INTO amn_n_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Eso Sisas afapugufeg 5 bret enag wambna, afa sawug sambaga enag wambtina esenam, eso ofgam nunofenam Godum lahlag moaogona. Bret kukosungofenam ehefena nihiyinaim faini enag ehel enag elim enam mumankegoni. Sawug sambagam gamba eso gwenaig esenam eso mumankegoni. ");
INSERT INTO amn_n_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","El enag ahaganam yuhwa gohna. ");
INSERT INTO amn_n_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ehefena nihiyinai enag piskenim wohof ogug enag wambuginim 12 fenam enansi sompyi aitiafolini. ");
INSERT INTO amn_n_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Enag el eseli wohof ahagana enamba 5,000 el. ");
INSERT INTO amn_n_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Sisas ohefena nihiyinaim yikagna ningitigina botwa fukwalagonam gof ati wahegimeg bugam egam ahuafum, Betsaidagam. Sisas ehefwo ona nawo elksam enam ningitigi aminifenam. ");
INSERT INTO amn_n_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Enag elim ningitigi-aminifenam wahianam eso ehefumwo aikiagam fukokana Godum sihinagim. ");
INSERT INTO amn_n_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Enanam omuginim botwo wahegimeg buwa olugi gofena mba, afa Sisaswo ehefwaimu mungo engigwa gofena. ");
INSERT INTO amn_n_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","El botwanai enag onanawo ahuafum afa fufwei nalig bofnam botum kifitifnam kikehlaguafna enag Sisas engig wanai ehefena nihiyinaim enam nangwagnamba nambigni wafihiagi ahufena. Enag leawa kwimbiyim Sisas bu sisiyi langwabonam puguna. Si mahiyim gofenamba muhwa ambafekagim. Enag Sisas bu sisiyi yikana wahegimeg buwa eyi ehefena nihiyinai el nangum ona kawo kanam kwahanigam. ");
INSERT INTO amn_n_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ehefena nihiyinai enag nanaunimba bu sisiyi langwambofena. Enag enaig olningini ogogum, “Yifaf emba!” ");
INSERT INTO amn_n_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Enag mungwal Sisasim enam nangunim enag amtakwal euwatogonam embefagini. Enag eso Sisas yikagna sihini, “Olug tifuti! Kamblehe ombo. Nogofeka embefim.” ");
INSERT INTO amn_n_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Enag botgam yikanam fukonam wanagafenamba eso fufwei enag gweyi awaiena. Enag ehefena nihiyinai enag olug wahegasaina. ");
INSERT INTO amn_n_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Mas numwehenim olninginimo yuwanam Sisas eseli bret kukosungofenam faini. Godna tifutukum ogofuni. Sisas ona so ma olningi ehmba Godna nihiyinai bok. Afa enag Sisasna nihiyinai enag mas olninginimo. Bu sisiyi eseli Sisas yikafena. Enam gamba ehefena nihiyinai enag mas ehim olninginimo, Sisasmba Godna nihiyinai bok. ");
INSERT INTO amn_n_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Enag ahunam wahegimeg buum tigeugunim ahunam minggam egam apekugona, Genesaret kimbigam. Enag botum enanayi kiki wahiyinim. ");
INSERT INTO amn_n_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Afa botum enag wahiyinim apeigomba. El enagna enag ati olningini elimba Sisas emba. ");
INSERT INTO amn_n_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Enaig fenamba enag el mungwal kimbig muhwanai enag yikagna ahuaminifena. Enag eso mungwal enag higifinim Sisas mayi ahananayi gofenamba, so elim gihnam enag wambufinim esim wambuk ahuafena. Enag higifinim Sisas mayi ahananayi gofenamba, enag eso elim enag kug noholugum wambufinim Sisas nangum wambuk ahuafena. ");
INSERT INTO amn_n_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Mungwali kimbig wesig i naligyinai gamba, Sisas mayi yikafenamba mungwal el eseli enag elim gihnam wambufinim Sisas nangum. Wambug ahuafena ogohufenam ena kimbigwa Sisas eseli aga enanayi olugyi sungo gofena, enag tifutifinim Sisasim sahinifini, ogona Sisas ma sawiyifei, eso ma gihna el enag Sisasna lofugum tuhufi. Enag el enag mayi aman Sisasna lofugum tuhufenamba gih enag wangenefefena. ");
INSERT INTO amn_n_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Mingnag Farisi el afa mingnag Mosesna mom anuana fig el Jerusalem wanai enag ambogonam Sisas nayi nuwagena. ");
INSERT INTO amn_n_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Enag ehel enag nangwaginimba Sisasna nihiyinai mas ningagagim buwa sugifinimo, yusug ahagafena. Farisi el enag enaig esehufena, ufuana mom pahalug ahuafena, enag amangal enam pahalug ahuag hwanigmba, enag osogonfini, “Negelmbi Godna nofwa amtakwalig fesaig.” ");
INSERT INTO amn_n_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farisi afa mungwa mingnag Juda el enag ufuana mom pahalug ahuafena. Ningagagim ufuana moaihwa buwa gigiafewogug hwanigmba emba wohof enag mas ahagai. ");
INSERT INTO amn_n_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Maket wanai ambogogum, buwa susug hwanigmba, emba mas ahagai. Amang amang autinam ufu esehufena enam enag gwesifinim pahagahuafena, enaig mungwal ahnaig ahnaig enag. Kap, plet, sospen, nonigi kuk, enaig gamba gigiafegifini. ");
INSERT INTO amn_n_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Enaig fenamba enag Farisi anuana el enag Sisasim sahini, “Ahnaig asegmba enag neana nihiyinaimba mas enamba pahalug ahuahmo mas ufuana moaihwa ningagagim buwa sugihmo, yusug ahagahu?” Sisasim enaig sahnafini. ");
INSERT INTO amn_n_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Enag Sisas sihini, “Autinam profet Aisaia, enag profet el enag Godna mo higinim eso elim sihini enag Godna mom ginofenam yinim osona negelmbi moakwal luwal. Aisaia enaig ginofena; Enag enangelmbi kana wunehalam mengigna bihig gufiyigim ofukwalagof afa enag elni olugmbi kana wahegwa go. ");
INSERT INTO amn_n_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","El enag elni mom mungo sihifinim osogwahufuf, ‘Ohuna momba Godna mo.’ Enaig wa osogwahufuf. Enaig fenamba enag kana wunehalam mungwelni mengigna bihig gufiyinim ofukwalagof. Aisaia enaig ginofena. ");
INSERT INTO amn_n_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Negelmbi ati Godna moamba wahiyig. Yawomba elni mom mungo na gwesigim kikegeligofo.” Sisas enaig sihifeni. ");
INSERT INTO amn_n_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Sisas ming mo sihini, “Negelmbi anuana Godna mo flaguflag el, nimbefna ufuana mo mungo na pahlug ahua. ");
INSERT INTO amn_n_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses enaig osoni, ‘Nemba awagafagna olningugug fanam eso pahlugwi afa aman awagafagim amtakwalig mo waginigmbi enamba eso tigegi!’ Moses enaig osoni. ");
INSERT INTO amn_n_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Enag negel enaig osogoafena, aman maninamba eso awagafagim kwagani, enag awagafagim enaig osoni ‘Ena manimba afi ka fakanag Godum faigim mas ka nem faiyi.’ ");
INSERT INTO amn_n_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Afa enaig sihimba fenam, afa awagafagim kwaganig hwanigmba, emba enaig olningugef, elimba yuhwahofeg, kawo awagafagim kwaganigimwo wahiam. Negel enaig olningugifini. ");
INSERT INTO amn_n_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Enaig fenamba enana ufuana mo eseli na fini enam ena na pahalug ahua. Negelmbi mingnag elim amtakwalig pahlug ahuagim ogfugon. Enag elimba na sihigoni Godna moamba amtakwalig yusug feg! Enam enag nimbehe sihigonufini, afa mingnag amang amang amtakwaligim enaig enag enam gamba nesifini.” Sisas enaig sihifeni ");
INSERT INTO amn_n_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Sisas elim piskenam wunonim, enag sihini, “Negel mungwal enag kana mom higinim, eso olningugi. ");
INSERT INTO amn_n_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Amang eseli elni nihiyi ambagam goh, enamba sahokagim, emba mas elim enam amtakwalei. Awai! Amang eseli meaga goh, enag elmbi gwena mungwehe pugugum amtakwal fafefaf. ");
INSERT INTO amn_n_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(Enag amangal angnamba eso mo enag ma higuginim numwehe olningugi.)” ");
INSERT INTO amn_n_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Enag elim enam wasanam, lalagam yikana. Ehefena nihiyinai enag sahini, “Enawasimba mog momba enam elimba ahnaig wo?” ");
INSERT INTO amn_n_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Enag Sisas sihini, “Negel gimba olningig hwanig ho? Mas na olningigmo. Mungwal wohof eseli ambagam go, ena yikagim sahwagmba mas elmbi amtakwalefai. Emba nihiyi yika sahonam, afa elim enag mas amtakwalefai. ");
INSERT INTO amn_n_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ahnaig asegmba? Enaig wohof mba mas yikanam olugimba sahoi? Awai! Elimba ehnog megam mungo pekagim, eso wambuk ahugum ata lalagam tatugog.” Sisas enaig sihifeni. Enag ena momba Sisas ogofuni mungwal wohof eseli enag elimba lahlag, mas kwegigmo. ");
INSERT INTO amn_n_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Sisas enaig osoni, “Amang eseli meaga go, enagehe pugugum elmbi amtakwalfafefaf. ");
INSERT INTO amn_n_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ahnaig ahnaig amtakwaleg eseli elni olyi go, enagehe pugugum fambof amtakwalig olningugug enaig, agataikug, okwef, elim tigekag, ");
INSERT INTO amn_n_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","angwafig hugwiapahugug mingnag elni gawigim membenig ona, ‘Ka wambum,’ ahnaig ahnaig amtakwalig enaig moakwaleg, amtakwalig gwenaigim mungo gweseahu, mas ahwanifi, olug amtakwalig, elim mo kiapasig, kigambalig enag mwetetig el enaig mba. ");
INSERT INTO amn_n_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mungwal amtakwalig olningugugmba enaig elni nihiyi go, enagehe pugumbogum elimbi amtakwal fafefaf.” ");
INSERT INTO amn_n_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Sisas bwihiana ena kimbigim wahianam Tair provinsigam yikana, yikanam lalagam sahokana onam, “Ma sa kam anuwanafinif ogofei ati bok ohwi aga!” Afa enag el enag ati higini Sisasmba ati bok. Enag ena mom enag ahnaig kumoahalafehmo? Awai! ");
INSERT INTO amn_n_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Angwafig mungo enag enam higina Sisasmba ati bok aga. Enag angwafigni luwal nainim ena Satanna nihiyinai amtakwalig ehena nihiyi gofena. Enag angwafig enag enaig fenamba yikagnam bonam penam mogukug kwakwagena Sisasna mongug muhwa. ");
INSERT INTO amn_n_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Angwafigmbi enamba Juda angomba awai, elimba mingnag elyinai, Finisia Provins Siria kantri yinai. Enag angwafig enag Sisasim tifutinam sahana, “Kana luwal nainim Satanna nihiyinai amtakwaligim hugufatina.” ");
INSERT INTO amn_n_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Enag Sisas ati olningna Israel elmbi mingnag elim ati enaig suwigifini mawang lofug. Enag Sisas angwafigim enam sihina, “Yuwanawo nawo wohofmba luwalim faigom. Amtakwaleg big luwalna wohof wambugum mawankim tatugonugmbi.” Sisas enaig sihina. ");
INSERT INTO amn_n_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Enag eso angwafig enag piskenam Sisasim sihina, “Ainiyag, yinimehe nembe osog. Enag mawank sime singagim auguiahba, mayi luwalna wohofmba apeigogmba, enag mawang wambhaga fafif.” ");
INSERT INTO amn_n_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Enag Sisas piskenam angwafigim sihina, “Neana moamba lahlag olningugug, piskenam lalagam yika, Satanna nihiyinai amtakwalig mba neana luwalim ati wahiakag.” ");
INSERT INTO amn_n_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Enag angwafig enag piskenam lalagam yikana nangonamba luwal enag kukwa gifini enag Satanna nihiyinai amtakwalig enag ati wahiakana. ");
INSERT INTO amn_n_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Sisas bwihianam piskenam Tairm wahianam yikana Saidonwa olugyi puguna. Gwesim hilikanam olugyi puguna ningagagim pugufewogug 10 kimbig enag enaig sefafig Dekapolis yikanam puguna wahegimeg buwa Galiliyi. ");
INSERT INTO amn_n_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Eyi el mungom ombugona angug nihiliagim kakamo nisiakafena enam ombugona Sisasim tifutinim sahini ona, “Tuhu elim enam!” ");
INSERT INTO amn_n_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Sisas elim enam sulufanam wanikina elksamwo gweyi wasanam ehefum mungo ahkanam ahgofenamba. Eso Sisas elim enag angamegam ningagana tuhunam, eso memb kusenam, afa enag elni melegim tuhuna. ");
INSERT INTO amn_n_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Sisas enag esenam eso ofgam nunofehiagena tifutinam ehefefona, eso elim enag Sisas sihina, “Efata!” Ena momba enaig eseg, “Nembe pigina!” ");
INSERT INTO amn_n_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Yikagnam angug higna, amang eseli melegim kaguona, enag awaienamba mo yuhwa wagna. ");
INSERT INTO amn_n_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Enag Sisas tifutinam osoni, “Nogofeika amanim mungom sihinim ohunam enag!” Enaig esenam eso osoni, “Nogofeika sihigonugum!” Enag el enag ahunam gwesim tifutinim sihiagehufena ena mom enag. ");
INSERT INTO amn_n_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Enag eso mungwal el enag ena mom higinim eso olug wahegasaina. El enag enaig sihiagini, “Amang amang eseli eseageg enag ena yuhwa newugehe feg? Angug nihiliag mo hegig! Mengig kapenifegmo wagig.” Enaig sihiagahufena. ");
INSERT INTO amn_n_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Enanam enag elksa piskenam nuwagena enag el enag wohof hwanig. Enag Sisas ehefena nihiyinaim wunoni, “Ambogo,” enag osoni, ");
INSERT INTO amn_n_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“El enag sambaga mungo osunam big mungwal ohunanayi wanagagim auguiagim enag wohof awaienig. Enaig fenamba ena ka afafenig. ");
INSERT INTO amn_n_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Biniwa auguiagim enaig ka ehefena kimbigam ningitigiagmba emba nof pagiasainam minawa apeigof. Mingnagwo kimbig waheg wanai ambogog.” Sisas enaig osoni. ");
INSERT INTO amn_n_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ehefena nihiyinai piskenim osoni, “Ohuna bete mba el hwanig, ahanagna big bret mba finim, eso big faigof enagsa elmbi enamba?” ");
INSERT INTO amn_n_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Sisas piskenam sahini, “Negelni bretmba ahanansi?” Enag osogona, “Elngegwa gohog.” ");
INSERT INTO amn_n_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Enag Sisas mungwal elim enam sihini, “Betewa apeigonam oguwo.” Enag elengegwo gohog bret wampnam, Godum lahlag moaogonam bret enag kukosungofenam, eso ehefena nihiyinaim enam fainim, ogum, “Elksam enam mimangegon.” Ehefena nihiyinai enag enaig esini, bret enag wampinim mimangegonugini. ");
INSERT INTO amn_n_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Afa sawugwo wesig sambagag ahfena. Sisas Godum enag lahlag moaogonam, eso ehefena nihiyinaim enam sihini, “Ena gamba mumankegom.” ");
INSERT INTO amn_n_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Enag eso el enag ahganam yuhwafesaina, elksa eseli ahgana enag enaihwa fena 4,000. Ehefena nihiyinai enag wohof ogug nuwaguginim elengegwa gohona enansi sompyi folini. Sisas mungwal elim enag ningitiginam, ");
INSERT INTO amn_n_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","eso ehewo yikagna yikanam botwa wan fukonam, ehefena nihiyinaim mungwal, eso wankana provins Dalmanutagamwo. ");
INSERT INTO amn_n_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farisi el enag enaig ambogonam Sisasim flaflafena gofofena. Enaig ogona, nawo Sisasim gihinim, Sisasim sahini, ona, Ma tifutuk gafungag ena fei, enag enamba el bihigmba ahnaig esihmo? Afa ogona nawo nangum God Sisasim lahlafenagime, awaime. ");
INSERT INTO amn_n_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Sisas olug kinig fenam enag tifutinam ehefefonam, enaig sahinena, “Amang figim elmbi ohunanamba ogona, nawo tifutuk gafungagim ba nangum? Yinimehe ka nem osonug. Mas ka tifutuk gafungagmba ohunanamba ka fei. Awai newug!” ");
INSERT INTO amn_n_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Enag elim enam wasanam piskenam yikana botwa ming ehmbegam wahegimeg bugam. ");
INSERT INTO amn_n_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ehefena nihiyinai enag ol etetini mas bret wambukambogonamo bretmba mungo botwamba gifini. ");
INSERT INTO amn_n_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Sisas ati olningena Farisi Herotna amtakwalig olningugugum enam. Amang eseli bret pupkuok enaig lofug fig. Afa amanim enag elni amtakwalig olningugug ena tuhuimba enag gwenaig, tata nihig gamba enaig eseg, amta wesig gwenagehe nongigim, eso mungwal nongig awaieg. Elni olug enag enaig feg. ");
INSERT INTO amn_n_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ehefena nihiyinai enag Sisasna ehefum mo mas olningigmo, enag ehefum sihiag ahufena, “Big elmbi bret hwanig ename Sisasba osog.” ");
INSERT INTO amn_n_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Sisas ati olningena ehelni mom enag, enag osonim sahini, “Amang figim nosogog, ‘Kagelmbi bret hwanig?’ Mas na olningugigmo? Negelni olnigugug mba mas yuhwafegmo? ");
INSERT INTO amn_n_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nofna na figim mas nangogmo. Afa angna, na figim mas na higigmo? Mas na nolningigmo bret wasim eso ka sihinig enamba. ");
INSERT INTO amn_n_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Autinam bret afawa gohona ena elksam 5,000 ka faini, enag osohwi ati ahaganam yuhwa fesaina. Afa ahanansi sompni bret ogugmba fena?” Ehefena nihiyinai wahigifinim osoni, “12 fenam, enansi sompni.” ");
INSERT INTO amn_n_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Sisas piske sahini, “Enag elengegwa gohona enansi bret ka faini enagsa elim 4,000 enamba. Ahanansi sompni bret ogugmba fena?” Ehefena nihiyinai wahigifinim osoni, “7 ena elengegwa gohona.” ");
INSERT INTO amn_n_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Enag Sisas enaig sahinena, “Enam enag mas na olningugigmo? Autinam bret ka faigona, afa enag yawangamba wohof ena ka yuhwafef.” ");
INSERT INTO amn_n_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Sisas wankanam wanpuguna Betsaidawa mingnag el el mungom nofselenam Sisas nangum wanibogona. El enag Sisasim tifutinim sihini, “Elim ohunam ningagana tuhu!” ");
INSERT INTO amn_n_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Enag eso Sisas enaig esena, el nofselenam enam ningagana kikehalanam, kimbig wanai opugunam wahikinam eso memb nofwa fugenam, afa ningagagna tuhuna, esenam eso Sisas elim enag sahana, “Atiaho na amang amangimba enamba nangwagig? Awaime?” ");
INSERT INTO amn_n_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","El enag fahegagenam enaig osona, “Mingnag elim enag ati ka nangwagegmba li lofug enaig aisagafesaig.” ");
INSERT INTO amn_n_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Sisas piskenam ningagana nofwa tuhunamba afa eso el enag numwehena nangogihiagena. Nofug enag yuhwafenam mungwal amang amangim nohmbesena. ");
INSERT INTO amn_n_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Sisas elim enam ehefena lalagam piske ningihianam, eso enaig osona, “Nofeka yuwanam ohuna kimbigam piske yikanam sahom!” ");
INSERT INTO amn_n_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Sisas ehefena nihiyinaim wambwiahianam wankanam minawa wanpuguafenamba Sisaria Filipai muhwa. Eso Sisas ehefena nihiyinaim sahini, “Elmbi kamba amanaimwo sefig?” ");
INSERT INTO amn_n_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Enag Sisasim osoni, “Mingnag elwo enaig sefa nem fig, Jon Bu Aitiag El. Afa mingnag elwo enai sefa nem fig, Profet autinai, Elaija, afa mingnag elwo enai sefa nem fig, Mingnag profet el.” ");
INSERT INTO amn_n_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Enag Sisas ehefena nihiyinaim sahini, “Afa Negelmbi ahnaig sefa nakamfig?” Enag Pita wahigifenam sihina, “Nemba Krais. Enag Israel el enag Kraisim nisanahufena. Nembehe ati pugugum enaig gafungag enag na ofe.” Pita enaig sihifena. ");
INSERT INTO amn_n_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Enag ehefena nihiyinaim tifutinam osoni, “Nogofeka amanim sihinim kamba Krais.” ");
INSERT INTO amn_n_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Sisas enag enaig esenam eso ehefena nihiyinaim enag sisifunugena, “Kamba Enag El God Ningihiana Of Wanai. Emba kamba tawetik nalig wafaf. Enag el Ainiyag, mungwal pris eseli Godna lalanai afa anuana el Godna mo fig enag, enag emba wa el enag kam mas fatinim afa kam tigegif. Sambaga mungo osuwo mayi kaimba eso ka wa piskenam bwihiaf.” ");
INSERT INTO amn_n_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Sisas ena mom enag numwehe sihinugena. Enag Pita Sisasim wanikinam nunumuafana. ");
INSERT INTO amn_n_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Sisas wahigifenam ehefena nihiyinaim enag nangwagihiagenam, Pitam nunumuafana, “Satan, kana masigim yika. Godna olningugugumba mas na olningugigmo. Awai! Nemba elni olningugugum mungo olningig!” ");
INSERT INTO amn_n_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Enag Sisas mungwal elksam enam wunoni, mungwal ehefena nihiyinai gamba nohologum, enag osoni, “Aman olningenam kam pahlug ombofimba, emba so ma ehefena olningugugum wahianam, yuwanamwo kam olningenag ena mayi feimba kam membeneg ma sisiyigam fukonam, so ma afa kaga tigeg enag fai kamble osohwi fag enaig, mafanam so ma kam pahlumboi. Enag aga kaga tigegmba enaig eseg amang amang kinig elim enam pugunaf. Mingnagmba kinig fafef, mingnagwo fa pigif. Afa aman kam pahlug ombofimba eso ma ohunaig olningugei, ‘Ahnaig kinig ka nangumboimba, emba mas ka Sisasim wahiai!’ Enaig eso ma esoi. ");
INSERT INTO amn_n_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Afa aman mingnagwo enaig olningugeimba, ehefum ogum, ‘Ka kwisig Sisasim pahluguagim amang amang kinig ehefena aga kaga tigegna ka kwisig,’ aman enaig olningugeimba emba enena lofug enag wahaf eso ehefena sungwagwo tawetik nalig faf. Godna nihiyi wahegwa gwesena hegegwa agafuf. Mingnag elwo amangal enaig olningugeigmba, kam olninginim, kana mo lahlagim sihinim, kana gafungag esel esig enam enag wahagmba. ");
INSERT INTO amn_n_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Aman ohuna betenai gawig enag mungwal wambugegmba, enag ena gawigmba kwegofoime? Awai! Ohuna betenai gawigmba mas kwegofoi, elimba yusugmba! ");
INSERT INTO amn_n_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Aman amang faif ehim ehena sungwagim sulufagimba hegeg gweseg agagimba? Awai! Amang amang gawignamba mas sulufi. ");
INSERT INTO amn_n_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ohunanam enag enagsa el auguiahmba Godum hwoyuafatifefig, enaig esigim, kwamblo i angwafig i ahnaig ahnaig amtakwaligim mungo pahlug ahua. Afa aman mungo enag amtakwalig elni olugyi gohogum enag kam enag ahwanifenagmba, afa kana mom gamba ahwanifehagmba, emba hwaonam mayi Enag Elim God Ningihiana Of Wanai, mayi enag nalig enag ombofimba, ehengamba elim enam ahwanifenaf. Mayi El Enag Of Wanai nalig enag ombofimba mungwal si amba fekag lofug enaig wa pukof ehefena awagna ambafeka, mungwal wankeneg ensel Godna gafungag of wanai Enag El God Ningihiana Of Wanai enag enselim wan bof. Mayi enaig ombofimba ehengamba elim enam ahwanifenaf.” ");
INSERT INTO amn_n_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Sisas mingnag mo sihini, “Yinimihe ka nem osonug, mingnag el ohwi gofo enamba mas pigi, emba auguianam nanguf God puguagum ehefena tifutukni afalig fegim enam.” ");
INSERT INTO amn_n_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Enag ena mayi kanamba afa fasagafinim enuwesowa gohok siyi mayi kanamba eso Sisas Pita, Jems, Jonnum sulufunam fukuka wankana aikieg kwiegam. Ehel mungo ahunam gofwehenam eso enag nangwagofofenamba Sisasna elig enag wahigifenam nemona fena ");
INSERT INTO amn_n_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ehena lofug gamba enaig esena pukowagenam mungwal businam fatinam busug newugehe fena. Mas aman mungo ohuna betenai lofug enag gigiafegim busug enaig pugufehmo? Awai! ");
INSERT INTO amn_n_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Eso Sisasna nihiyinai sambaga munga enag nangwaginimba Elaijam i Mosesmi sambaga ningigi enag. Sisas ga mo sihiyagofofena. ");
INSERT INTO amn_n_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita enam nangonam enag Sisasim osona, “Anuana, nawo bigwo gohiyi auguiafum. Emba sa yuhwafei. Nawo sambaga mungo fofug lala nimbagim, mingwo neana, mingwo Mosesna, mingwo Elaijana.” Pita enaig osona. ");
INSERT INTO amn_n_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ahnaig asegba? Sisasna nihiyinai enag enam embefini, Pitamba mas anuanafegmo, emba ahnaig mo osog? ");
INSERT INTO amn_n_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Leango penam elim enag yisienugena eso mo leango meanai pugunam, enaig osona, “Elimba kana leg, ka olug lahlafenag, ehena mo enag numwehenim higi!” ");
INSERT INTO amn_n_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Yikagnam ehefena nihiyinai nunofehiagini enag mas amanim nangunimo, Sisas mungo gofena. ");
INSERT INTO amn_n_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Enanam enag mugum wahiyinim apekugonam ahuafenamba, Sisas tifutinam osoni ehefena nihiyinaim enag, “Nogofeka amanim sihinim esel na nangug enam enag. Enag El God Ningihiana Of Wanai enag mayi wahanam, piske bwihiaimba, emba sa na sihigonugi.” ");
INSERT INTO amn_n_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ehefena nihiyiani enag ehena mom enam pahalug ahua fenamba, enaig esini ehefum mungo olugyi wa sahugehufena, “Amangwo wahagim bwihiagmba?” ");
INSERT INTO amn_n_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ehefena nihiyinai Sisasim enaig sahinifini, “Ahnaig asegmba el Godna mo anuana fig, enag enaig osogona, ‘Elaija mayi boimba, afa eso Kraiswo sum wambof.’ Anuana el enag enaig osogona. Ahnaig asegmba, enagna osog?” Sisasna nihiyinai enag enaig sahinifini Sisasim. ");
INSERT INTO amn_n_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Sisas wahigifenam osoni, “Elimba yinimehe el mungo Elaija lofug yuwanamba pugunam wambof elni olugum enag numwehenugeimba God nangum ambogogum. Ahnaig, asegba? Autinam el enag Godna mom ginofinim enaig osogona, ‘Enag El Of Wanai God Ningihiaimba enag wa tawetik nalig faf, afa el kwisinim mas fatinif.’” Sisas enaig sihifeni. ");
INSERT INTO amn_n_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Sisas Jon, buwa aitiag el, enam olningenam, enag enaig osoni, “Enag yawomba ka nem osonug, Elaija lofug eseli enag ati pugug, afa amang amangim mingnag eseli membini enag ena ati esini elim enam gwenaig autinam profet eseli ginofini, ena yuhwa gwesif.” ");
INSERT INTO amn_n_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Sisas sambaga mungom ehefena nihiyinaim enam wankanam wan pugunam nangwagnamba ehefena nihiyinai mingnag eseli ehelni nihiyi elksa wahegagena auguiafena. Enag el enag elwo anuana el Godna mom fig el Sisasna nihiyinai ga fuflafegegofofena. ");
INSERT INTO amn_n_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Enag mungwal el enag nangunimba Sisas bwafena enag kukugiafakafinim eso osogona, “Sisasmba atiombo.” Enag eso el enag gwesim kikigni ahunam Sisas nangum, eso enaig osogona, “Atiaho nambok?” ");
INSERT INTO amn_n_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Sisas ehefena nihiyinaim enam sahini, “Amang mo enag el gimba na fuflafegegofona?” ");
INSERT INTO amn_n_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Enag mungo el elksa eseli ena mewa gofena, enag Sisasim osona, “Anuana, kana luwal fangonam Satanna nihiyinai amtakwalig ehena nihiyi go mengig kapinifegim, mo wagi hwanig, enag ka ne nangum ombug. ");
INSERT INTO amn_n_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Enaig esefugum amansiniwo tifutifugum kikehalafugum kiafigigninifugum betewa fatia, memp meng megam puguafug, afa goimo nunuwafug, elig enag lilhifefugum fatia, ena ka neana nihiyinaim sahinig enam enag hugufatini, enag ahnaig asihmo?” ");
INSERT INTO amn_n_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Sisas enaig sihifeni, “Negel, Israel, mas na olningigmo Godmba emba nem kwaganif, negelmbi nimbehe kwisig God nangum ambogogumba, sahinigim, pahalu ahuagimba. Ahanansiyigim ka nem wanagafuf? Ahanansiyigim ka negelni kinig fanif? Luwalim enam ka nangum ombugo.” ");
INSERT INTO amn_n_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Eso luwal fangonam enam Sisas nangum ombugona. Satanna nihiyinai amtakwalig enag Sisasim nangonam, eso yikagnamehe luwalim enag fuluwali fatinamba luwal enag penam betewa wafuakihla fekafenamba memb busug meng megam pugunam wahegagena. ");
INSERT INTO amn_n_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Sisas luwalna awagim enam sahana, “Ahananam enaigmba puguna?” Awag enag osona, “Yuwanam, wesigyiehe esena. ");
INSERT INTO amn_n_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Autinai gwenaig ehe esefugufena, enag Satanna nihiyinai amtakwalig enag suwiwa buwa gamba fa taiku fefuku, enaig esefuku, ogum, ‘Nawo tigenam ma wahai!’ Enag ka nem tifutigim sahanagim, na yuhwafegmba, sa na kam afafenim kam kwagani!” Luwalna awag enag Sisasim enaig sahanafena. ");
INSERT INTO amn_n_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Sisas enaig osona, “Hei, nembehe na enaig olningenagmba, God ehe yininewug feg amang amang enag God ona, ‘Emba kesef’ enag Godmba yinimehe wa esef. Aman Godum enam olningenagmba Godmba emba wa yuhwafef, enamba God wa kwegofuf. Amang amang kifutuk naligmbi God mungo ehe wa esef.” ");
INSERT INTO amn_n_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Yikagnam luwalna awag enag osona, “Enaigmba ati ka olningigim, afa kana olningigmba tumek. Kam kwegofo! Mas ka mungwal olningugugum yuhwa fegmo!” ");
INSERT INTO amn_n_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Sisas nangwagenamba elksa yikagna muhwa nuwagenam wahegagena, enaig fenamba enag, Sisas Satanna nihiyinai amtakwaligim enam nunumuafana, “Nemble Satanna nihiyinai mengig nihifenag angugum nihiliag, ka nem osonag, luwalna nihiyinai enag pugumbo! Nofeika piske ka sahom!” ");
INSERT INTO amn_n_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Satanna nihiyinai amtakwalig nag hlehlefukonam, luwalim enag fuluwalifatinam, ehena nihiyinai enag pugumbona. Luwal fangonam enag nangunimba lilhifefatinam wahag lofug enaig fena. Mungwal el eseli enag enaig osogona, “Ati wahag!” ");
INSERT INTO amn_n_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Enag Sisas enaig esena, luwalim ningagana kikehalanam gifiohlunamba, eso sukli bwihiagofena. ");
INSERT INTO amn_n_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Eso Sisas lalagam sahowankana ehefena nihiyinaim mungo, enag ehefena nihiyinai enag mungwal sahini, “Ahnaig asegmba enag kagelmbi Satanna nihiyinai amtakwalig enag ahnaig hugufati fegonuhmo?” ");
INSERT INTO amn_n_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Enag Sisas osoni, “Amangmba mas enaig amtakwaligimba hugufatini? Awai! Godum sahanag mungwamba sa hugufaiti!” ");
INSERT INTO amn_n_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Sisas ehefena nihiyinaim wankana ena kimbigimwo wahiyinam ahunam olugyi Galili provinswa apekugona wanpuguna. Sisas onanawo ehefena nihiyinaim ahnaig ahnaig mom sisifunugem, enaig fenamba enag ona, masa bigim mingnag el enag anuwanafegonuf enanayi ka yikagim wanaga enam. ");
INSERT INTO amn_n_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Sisas ehefena nihiyinaim osoni, “Enag El Of Wanai God Ningihiana esel enam mingnag el wa kikehelinim tigekigim elim enam wa faigof. Emba wa el enag tigekimbi wahanam. Afa sambaga mungo si mayi ahuimba eso wa piskenam bwihiaf.” ");
INSERT INTO amn_n_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ehefena nihiyinai enag mas ena mom enag olninginimo, enag embefini Sisasim sahinigim. ");
INSERT INTO amn_n_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Enag ahunam Kaperneam kimbigwa apekugoenam, lalagam saigonam, eso Sisas ehefena nihiyinaim sahini, “Amang mom minawamba na fuflafege ambogofena?” ");
INSERT INTO amn_n_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ehefum fuflafege ambogofena, aman Ainiyagmba fef, enaig fenamba enag ehefena nihiyinai enag mas Sisasim osuinimo. ");
INSERT INTO amn_n_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Sisas agafenamba, ehefena nihiyinaim enam wunoni. Mayi ambogonamba, enag osoni, “Aman oi, ‘Kawo Ainiyag fem,’ emba eso ma mungwal elim kukwaganig el fei, enag enaig gafunag elmbi emba sa Ainiyagmba fei.” Sisas enaig sihifeni. ");
INSERT INTO amn_n_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Enag enaig esena, luwal wesigim kikehlanam ombunam olugyi ehefena nihiyinaim elni muhuwa wasonam, eso luwalim enam ehefena nihiniyi fa sambagahla fefanam eso ehefena nihiyinaim enag osoni, ");
INSERT INTO amn_n_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Aman kam pahlukuagmba afa enag luwal ohunaigimba wunonim kwaganimba, elimba kamehe lahlafefag. Aman kam lahlafefagmba elimba amang kam mungo lahlafefahmo, elimba aman esel kam ningihianamba ka bok, enam gamba lahlafefag.” Sisas enaig osoni. ");
INSERT INTO amn_n_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon Sisasim sihina, “Anuana, ka nangugmbi el mungo Satanna nihiyinai amtakwaligim neana tifutukni ningitigifeka, enag ehmba mas big mungwalyi gowahnefihmo. Enaig fenamba enag elim enam ka kwenig.” ");
INSERT INTO amn_n_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Sisas osoni, “Negel nogafeika kwenim. Aman tifutuk gafungag kana tifutukni fegmba, emba mas kam yikagna ahnaig ahnaig amtakwaligim kam osoni. ");
INSERT INTO amn_n_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Aman bigelim waginig hwanigmba elimba bigelni hiheg. ");
INSERT INTO amn_n_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Yinimehe ka nem osonug. Amangal nem enaig olningugonimbi. ‘Elmbi elimba Kraisim pahalukahua, enag enam ka kwaganim,’ enag enaig nem olningugonimbi afa nem buga faiyimbi, emba elim enam ka lahlafehiagef.” ");
INSERT INTO amn_n_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Sisas ming mo sihini, “Luwal wesig mungo osohwi ohunaig kam ati olningenagmba, emba luwalim enam aman wahigifenam okuf, aman enaigmba osofefimba enaigmba sa yuhwafeite amangal hun nalig ma finim enag elni wuningliyi kikinim eso ma bu nofugwa fati eso ma pekanam wahai. ");
INSERT INTO amn_n_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Enaig neana ningagag enag esenam, kam olningenagim pahalukuagimba, mayi amtakwalmba fefeimba, eso hegefati. Enaig esei mungwa ningaganamba, emba sa na Godna muhwa hegeg agag enag fanam agafi. Masa na wa ningagag sambagana fenam afa na wa amtakwaligam kaf suwi mas fuhului esim wa. ");
INSERT INTO amn_n_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ena kukwamba elni ahnaig ahnaig tawetik enag gwesenam gofuf, ena kukwamba suwi enag mas fuhului. ");
INSERT INTO amn_n_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Enaig neana mongug enag esenam, kam olningenagim pahlukuagimba, mayi amtakwalmba fefeimba, eso hegefati. Enaig esei mungwa mongugnimba, emba sa na Godna muhwa hegeg agag enag enaig esenam fanam agafi. Masa na wa mongug sambagana fenam afa na wa amtakwaligam wa kaf suwi mas fuhului esim wa. ");
INSERT INTO amn_n_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ena kukwamba elni ahnaig ahnaig tawetik enag gwesenam gofuf ena kukwamba enag suwi enag mas fuhului. ");
INSERT INTO amn_n_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Enaig neana nofug enag esenam, kam olningenagim pahalukuagimba, mayi amtakwalmba fefeimba, eso nofug enag mingaganai nofugwo fusufati. Enaig esei mungwa nofnamba, emba sa na Godna muhwa hegeg agag enag enaig esenam fanam gofi. Masa na wa nofug sambagana fenam afa na wa amtakwaligam wa kaf suwi mas fuhului esim wa. ");
INSERT INTO amn_n_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ena kukwamba elni ahnaig ahnaig tawetik gwesenam gofuf ena kukwamba ena suwi emba mas fuhului. ");
INSERT INTO amn_n_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Suwi enag eso wa mungwal el ningum bonuf. Suwi enag enaig eseg sol lofugmba. ");
INSERT INTO amn_n_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Solmba lahlagehe, enag sol embeg enag awaiemba, eso aman piskena enaig embeg enag esehmo? Solmba enaig eseg sisim numwehiageg. Negel gimba enaig esi, sol lofugmba nimbefena olugyi numwehiagimbi enag elim olyi lahlafehiagi, emba sa na auguiafi.” ");
INSERT INTO amn_n_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Sisas egam wahianam yikana provins Judiagam yikana gwesim bu Jordangam eso bu enag minggam yikana. Elksa ambogona nuwagena Sisasna nihiyi. Enag Sisas, ehe eso esekafena, enaig esena, Godna mom sisifunugena. ");
INSERT INTO amn_n_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mingnag Farisi el ambogona, ona, “Nawo Sisasim gihinim.” El enag enaig sahinifini, “Enaig aman angwafigim ningihiagmba, elimba yuhwahofeg? Autinam God Mosesim mo faina, enamba? ");
INSERT INTO amn_n_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Sisas piskenam sahini, “Ahnaig mo Mosesmba nem faini yuwanamba?” ");
INSERT INTO amn_n_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Farisi enag wahigifinim Sisasim osoni, “Mosesmba kagelni ufuamba, enaig osoni, ‘Aman angwafigmbi oningihiafimba, eso ma enaig ginofenam fainam, ka nem ningihiag, eso ma ningihiai,’ Moses enaig osoni.” ");
INSERT INTO amn_n_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Sisas piskenam sihini, “Negelni ufuamba olug liputig yafuflag el, enaig fenamba enag Moses ena mom negelni ufum faini, yawo gamba negel gimba enaig esig. ");
INSERT INTO amn_n_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Yuwana newogmba God mungwal gawig enag gafungafe genam, afa kwambolomi angwafigmi God gafungafewogona. ");
INSERT INTO amn_n_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Enaig fenamba kwambolo enag eso ma awagafagim wahianam eso angwafig i mungo olug ahfanam, eso ahagambahlagofi. ");
INSERT INTO amn_n_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Yawamba enaig eseg, ohunanam enag sambaga mas ahagahmo, yawamba ati mungo feg. ");
INSERT INTO amn_n_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Amang ese God numusuhulug enag ena nofeika wo kougum.” ");
INSERT INTO amn_n_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Piskenam lalagam ahunam saigonam eso ehefena nihiyinai enag Sisasim enam enag sahini. ");
INSERT INTO amn_n_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Sisas osoni. “Enag aman mungo ehefena angwafigim ningihianam afa mingim fagmba, elimba enaig eseg, ehefena angwagim enag amtakwalefagim, afa angwafig wambugum amtakwalesungofeg. ");
INSERT INTO amn_n_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Afa enaig angwafig ehefena ligagim wahiagem, ming awag wa kagmba, ehengamba gwenaig eseg, afa awagwagagim enam amtakwalesungofeg.” Sisas ehefena nihiyinaim enaig sihifeni. ");
INSERT INTO amn_n_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Enag el mingnag luwal hutiatanigim Sisas nangum wan ambogona. El enag sawiyifini Sisasim ogum, “Ma luwalim enag ningagana tutohilihiagei.” Enag ehefena nihiyinai enag elim enag nunumuhiagini. ");
INSERT INTO amn_n_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Sisas ehefena nihiyinaim enag nangwagenam, enag nunumuhiagena. Sisas osoni, “Negel nogofeika kwegonum! Hwahiyi! Luwal ma ka nangum ambogoi, Godmba luwal ohunaik lofugumba sa wanagafi. ");
INSERT INTO amn_n_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Elmbi enaig esimbi God ehim enam ma afalig feni. Luwalmba ehefena awagim numwehe olningenif, awagna mom fa higif. Mungwal el enag enaig ma Godum esini. Yinim newugehe ka nem osonug, aman el luwal lofug enaig esei hwanigmba, elimba ahnaig asenam, God afalig elim wanagagim esel esim enag ahnaig sahokahmo! Awai newog!” ");
INSERT INTO amn_n_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Enag Sisas luwal mungogum ningagana tutohilihiagenam, Godum sahanam luwalim lahlafenugena. ");
INSERT INTO amn_n_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Sisas bwihianam yikafenamba, el mungo kikigni bona Sisas nangum, mogukug kwakwagenam Sisasim sahana, “Nemba anuana lahlag, ahnaig kasenam eso ka hegegmba gwesenam gofuf?” ");
INSERT INTO amn_n_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Sisas sihina, “Amang fegim na kam lahlag moaogonag? God mungwehe lahlagmba, mingmba aman fe hwanig? Awai! ");
INSERT INTO amn_n_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Autinam God Mosesim mo faina, ogufunugum lahlafehugum amang amang mo enag. Ati na ena mom enag anuanafeg. Mingnag momba enaig feg, ‘Nofeika amanim tigekam. Nofeika angwafig wambugum amtakwalesungofem. Nofeika okwefem. Nofeika mingnag elim moakwelenim. Nofeika waskwesenam ahnaig ahnaig esenam wambum. Awagafagna mom higigonufi.’ Enaig mo God Mosesim faina.” Ena mom enag Sisas elim sihina. ");
INSERT INTO amn_n_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","El enag Sisasim sihina. “Yuwanam ka luwal fefenamba ena mom enag ka pahalukuna, afa bogum yawangamba ka gwesehe feka.” ");
INSERT INTO amn_n_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Sisas nangonam elim enam olug lahlafena, enag Sisas osona, “Nemba mungom ehe na tumek. Yikanam nimbefena mungwal gawig enag ningitigife, el ma wambwi, enanam mani enag wambnam eso amangal esel wohof, lofug, amang amang enam enaig hwanig feg, enaig elim, mumankeni. Enaig na eseimba emba sa na ofwa yika pugunam enagsa gawig lahlag na wambwi. Gawigim enaig esenam, eso, bonam kam pahalumbwi.” Sisas enaig sihifena. ");
INSERT INTO amn_n_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Enag el enag ena mom higinam nohmbosug wahigifenam afafenam nemonafena afa olug kinig fenam ena kana. Ahnaig asegmba? Enag el enag gawig numbiyinai fena, enag esena. ");
INSERT INTO amn_n_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Sisas ehefena nihiyinaim enag fahegenugenam, enaig sihifeni, “El gawig numbiyinaimba ahnaig ahu saigoahmo God wanagag esel esimba.” ");
INSERT INTO amn_n_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ehefena nihiyinai ena mom higinim enag olug wahegesainam enaig sihiagahufena, Sisas ehefena nihiyinaim ming mo sihini, “Kana luwal, aman God wanagagamba esimba sahwagimba, enag ahnaig sahokafef? ");
INSERT INTO amn_n_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamelmba sis nalig bulmakau nalig lofug, enag yikagim nel nasig megam enag ahnaig sahokafehmo? Awai! Afa aman el gawig numbiyinai gamba gwenaig eseg. God wanagagamba ahnaig sahokafehmo?” Sisas enawasim enaig sihifeni. ");
INSERT INTO amn_n_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ehefena nihiyinai enag olug wahegasainam ehefum sihiagini, “Enaig esegmba aman hegeg gohogmba fanam gwesenam gofuf?” ");
INSERT INTO amn_n_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Sisas, nofna nangwagofenamba, enag osoni, “Elmbi ahnaig asihmo? Awai! God mungwamba sa elim enag numwehenugenam eso ahunam saigoi. Amang amang God esegim esel, enag emba wa yuhwa gweyi esef.” Sisas enaig sihifeni. ");
INSERT INTO amn_n_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pita Sisasim osona, “Higi, kagelmbi mungwal gawig enag ati ka hwatigim, enag ka nem pahalug ahua.” ");
INSERT INTO amn_n_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Sisas osona, “Yinim newug ehe, ka nem osonug, aman kam olningenam, eso yikanam Godna mom lahlag sihiagekafi, afa ehefena lalam wahiyai, etegim, suminigim, muluwalim hwati, awagafagim hwati, luwal, asom hwati ");
INSERT INTO amn_n_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","aman enaig hwatiegmba emba sa enagsa 100 wambwi, ohuna betenai etiniagsa 100 lala, nilite, muluwali, afag, luwal, aso afa emba wa kinig gimba wambof. Enengim ohuna betem wahianam, eso hegeg gohogum enam fanam eso gwese gofi. ");
INSERT INTO amn_n_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Afa enagsa el esel yawo ohunanam gosugmbi enamba enengimba wa sum fesaif. Afa enagsa el yawo ohunanam sum fesaig enag ehe enengimba wa gosuf.” ");
INSERT INTO amn_n_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ena minam ahuafenamba Jerusalemgam Sisas gosna. Sisasna nihiyiani enag olnigninim oluwahegasaina ogogum, “Ahnaig Sisasimba pugunaf?” Mingnag el gimba Sisasim pahalug ahuafena. Enag ehel gamba embefini. Sisas ehefena nihiyinaim 12 fena enam mungo sulufunam. Enaig sihinugena amang ehim wa pugunaf. ");
INSERT INTO amn_n_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Sisas osoni, “Higi, yawomba Jerusalemgam big fukwalgogum ahufe. Enag El God Ningihiana Of Wanai, elim enamoa el mungo pris elmi anuana elmi wa faiyif. Ena pris i anuana el i sihiaginim mungwa mo finim afa so enaig osogof, ‘Eso ma tigekinim ma wahai!’ Mingnag elim wa faigof elimba Israel wanai el mo. ");
INSERT INTO amn_n_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","El enag enaig esinif, kiapasefinim, ahnaig ahnaig esefif, memp fuginif, wena tiginim, afa tigekif. Enaig esef, sambaga mungo siyi osuwu i, mayi yikaimba, eso enagel piskenam bwihiaf.” Sisas enam sihinugena. ");
INSERT INTO amn_n_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jems i Jon i, Sebedini le ningigig, sambaga ningigi enag Sisas nangum ahmbonam ahsahana, “Anuana kohogum kawo nem amang mungom ahsahanam enam enag kam eseni.” ");
INSERT INTO amn_n_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Sisas sahini, “Amangim na sawie ahfeg nohogum, ‘Kam eseni’?” ");
INSERT INTO amn_n_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Enag sambaga ningigi enag ahsihina, “Enagimwo wangenegenam enag nemba afalig fegmba nimbefena elim enag na wanagafuf, enag ka enaig sawie ahfeg, kohogum kawo amanwo neana nihigam agai amanwo neana sahagam agai.” Enaig sahnahfena. ");
INSERT INTO amn_n_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Enag Sisas osoni, “Neningigi enag mas anuana ahfegmo amangim esel na ahsahig enamba. Na yuhwa ahfeime? Kinig nalig esel, kamble fagim. Feg enaigmba na yuhwa ahfaime? Blufle nalig lofug enaig bogum nem yisiyi fa kaugoimba. Kamble fagim esel enaigmba. Enaigmba na yuhwa ahfaime!” Sisas enaig sahinigena. ");
INSERT INTO amn_n_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Sambaga ningiginenag osohona, “Emba ka yuhwa ahfef.” Sisas sambaga ningigim enam sihini, “Yiniho, enag kinigmbi emba na wa ahfafwa, afa mingnag kinig nalig blufle lofug enaig ne wa yisiaogof. ");
INSERT INTO amn_n_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Afa enag aman sahagam agafim nihigim agagim enag, kamba mas gishu fwahiai, elimba God mungwamba sa enaigmba gishu fwahiai. Autinam God ehe elim enag ati gisfugum hwatigig enanayi ahagagimba. ");
INSERT INTO amn_n_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Mingnag Sisasna nihiyinai enag 10 enam, enag enam higinim enag Jemsmi Jonmi wagugoni. ");
INSERT INTO amn_n_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Enag Sisas wunoni, “Ambogonam kana nihiyi nuwag,” enag osoni, “Nolningig mingnag elni nangwag gohogmba, ehfamba enaig esehu, ehefena nihiyinaim tifutigim nangwagihiagewo. Amang amanagim enam og, ‘Kam mayi osoimba, eso kam kwegfwi.’ Enam og enag ehena mom enag mungwal pahlug ahuafena. El enag ehena gafungag figim, afa mungwal pahalug ahug. ");
INSERT INTO amn_n_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Enaig el esel esig, afa negelmbi nogofeka pahago ahum enaigim enag. Negeliyinai aman enaig oliegmba, ‘Kawo nangwagohog el fim,’ aman enaig oliegmba, emba eso ma gafungag luwal fei, afa mungwal elim kwaganyegim yuhwafei. ");
INSERT INTO amn_n_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Aman oimba, kawo sisigam Ainiyag fem, emba eso ma gafungag luwal fei, mungwal el esel enagna singagfeni, mungwal elim enag kukwaganig fei. ");
INSERT INTO amn_n_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ahnaig asegmba, enag ka osog? Enag El God Ningihiana Of Wanai ehe gamba enaimba ohuna betegam bogum ehena gafungag mas figmo el ehim mas kwegofugmo. Awai! Ehe bogum elim gafungafegim kwaganyegim. Ehe bogum elim wahanigim, afa elksam piskegim wambugum ahnaig ahnaig amtakwalig el esel esehufena enagnai!” Sisas enaig sihifena. ");
INSERT INTO amn_n_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ambogonam apekugonam Jerikowa, enengim Jerikomwo wahiyinim ahuna, Sisas ehefena nihiyinaim wankana, afa enagsa el, ena gamba mungwal ahuna. Bartimeus Timeusna leg, enag mina meigim agafena. Ehmba nofselena enag elim manim wunoniaofena. ");
INSERT INTO amn_n_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Enag higinam Sisas Nasaret wanai ombo, enag gweyi hognam amtakwal wuneona, “Sisas Devitni leg, nemble kam afafena.” ");
INSERT INTO amn_n_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Elksa nunumufini, “Kawug kapinife.” Afa enag el enag hognam amtakwal wune nalig fena, “Devitni leg, nemble kam afafena.” ");
INSERT INTO amn_n_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Enag Sisas yikanam muhwa gohnam, eso Sisas osoni, “Wuni, ma boi!” Mingnag el elim nofselenam enam wunoni, “Olug lahlafenam! Bwihia! Sisas ati nem wunonag.” ");
INSERT INTO amn_n_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Lofug foholanam agafena, enag lofug hugufatinam yikagna bwihianam, Sisas nangum yikana. ");
INSERT INTO amn_n_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Sisas enag elim enam sahana, “Amangim na sawiyifeg, nogum?” Nofselena el enag Sisasim osona, “Kogum kawo nunof fehiagem!” ");
INSERT INTO amn_n_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Sisas sihina, “Yisehe yika, ati na olningig emba God ne wa kwegofuf, enag nofug enag piskenam yuhwafena.” Enag yikagnam nunofehiagenam, eso Sisasim minagam pahalukuna. ");
INSERT INTO amn_n_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Sisas elim wankanam Mug Olivyi wanpuguna. Mug Olivmbi kimbig Betfage afa Betani mugwa gofena. Ena kimbig sambaga enag Jerusalem kimbig nalig muhwa ahgifini. Sisas ehefena nihinaim sambaga ningigim ningitiginam, ");
INSERT INTO amn_n_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","eso enaig osoni, “Ne ningigi okwena kimbigam ahka muhwa esel gi esim. Ne ningigi ahkanam enag kimbigam ahsahon, eso yikagnamehe na wa ahnangof donki luwalig mungo el wena kikigim wahiyig. Ena donkiim mas aman mungo enanayi agagim okugmo. Donki enag pitigifanam ahombu. ");
INSERT INTO amn_n_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mingnag elmbi mayi nem enaig sahigonigmbi ogoi, ‘Amang fegim enaigmba nesahofe?’ Eso piske enaig sihiahfeni, ‘Ainiyag ogum kawo enanayi gafungafenam, eso piskenam yikagna ningihiam.’” Sisas enaig sihifeni. ");
INSERT INTO amn_n_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Enag sambaga ningigi enag ahyikanam ahnangonamba donki luwaligim enam wena kikinim wahiyiini ambagam minawa ahnangonamba lala mengig muhwa, enag sambaga ningigi enag we ahpiginam ahwanigina ahfana. ");
INSERT INTO amn_n_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Mingnag el muhwa gofwehiafena enag sambaga ningigim sahigoni, “Ne ningigi amang fegim enana donki luwaligmba elimba ahopitigifa?” ");
INSERT INTO amn_n_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Enag sambaga ningigi enag Sisas esel esona gwenaig sihiahfena. Enag eso el nag wahiyini sambaga ningigim enam ogona ma donkiim enam ahpitigifenam ahokwi. ");
INSERT INTO amn_n_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Enag sambaga ningigi enag donki luwaligim enag Sisas nangum ahpitigifanam ahombuna. Sambaga ningigi enag lofug donkiim masigim ahnufohlanamba eso Sisaswo enanayi fukonam agafena. ");
INSERT INTO amn_n_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Elksa lofug munawa nufohla hwatini. Mingnag elwo asogam ahunam li kagag higfeginim wambuk ambogonam minawa sungwa hwatini. ");
INSERT INTO amn_n_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Afa mingnag elwo gofahuafena, mingnag elwo sum ambagwafena, enawo wunena ambogwafena; Godum lahlag moaogunim. God elim enag ningihianamba, ena bona. God eso ma elim enag lahlafenagei. ");
INSERT INTO amn_n_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Autinam kagelni ufu Devit, Afalig Israel elim wanagafena. Enaig lofug yawamba ati piskegim ombo, God enam eso ma lahlafenagei. Bigel enag nawo Godna wunehalam sisiyigam newug gufiyinim ofukwalgonam enam lahlag moaogonim. Enag el enag enaig wunewat ofwafina. ");
INSERT INTO amn_n_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Sisas yikanam Jerusalemoa pugunam Godna lala naligim yikana sahonam mungwal ena lala mewa eyi fahegagena wahianam. Osuwu yikanam pefenamba, enaig fenamba enag ehefena nihiyinaim mungwal pasnam 12 enam, enam mungwal Betani kimbigam wankana. ");
INSERT INTO amn_n_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Siyini, Betaniim wahiyinim Jerusalemgam ahuafenamba Sisasim bini wahana. ");
INSERT INTO amn_n_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Enag Sisas li figim nangonamba wahegwa gofenamba, figeyimewofena. Enag yikanam muhwa pugunam eso yisigiagena, onam “Atiame fug lege?” Enag nangonamba figeg mungo wahegegena. Ahanaig asegmba? Enanamba fug legnamo? ");
INSERT INTO amn_n_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Sisas lim enag osona, “Mas na fugmba lei enengim gamba! Awai newug!” Ehefena nihiyinai el enag enam higini. ");
INSERT INTO amn_n_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","El enag ahunam Jerusalemoa apekugonam. Eso Sisaswo yikanam Godna lala naligim sahokana. Israel el enag enaig esifini, olyini kawo so mani afa twafig afa sis Godum faiyim. Mingnag el sisim twafigim Godna lala nalig nimbag betewa wambuk ambogofenam sungu finim afa enanam mani wambugegofena. Sisas enag elim enam ningitigifena. Kukofenam fatina simewa eseli enag el mani sungufinim mani wahigififinim mumankegegofofena. Sisas sime enam kukofenam aitini mingnag elwo twafigim manina wambugegofofena, enag ehelini eyi auguiag (sia) enam Sisas kukofe aitinaim. ");
INSERT INTO amn_n_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Enag kweni, “Nogofeka amang amang Godna lala naligim osum wambusaigom. ");
INSERT INTO amn_n_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Autinam enag God ehefena mom faini, ena mom el ginofini, enaig osoni, ‘Kana lalamba el eso ma enaig sefafi, Godum Sihinig Lala. Enag lalamba el mungwal esel gohnefe enag elni lala.’ Enaig autinam God osoni. Afa enag negel enag enaig esigim, enag yawamba enaig feg, okwef elni lala lofug!” Sisas elim enam enaig osoni. ");
INSERT INTO amn_n_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Enginag ainiyag pris el afa anuana el enag ena mom higinim, enag. Eli enag enaig olningugini, “Ahnaig big asinim eso Sisasimba big tigekif?” Pris i anuana el i enag Sisasim embefini. Ahnaig asegmba? El mungwal enag Sisasna mom higinim, enag olug wahegesaina. ");
INSERT INTO amn_n_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Si mayi kigfiafenamba eso. Sisas ehefena nihiyinaim enag wahkana Jerusalemumwo wahiyinim. ");
INSERT INTO amn_n_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Sini leawa kwimbiyim ahunam li figim enam nangonimba ati ehesafena, figeg ehesafenam mungwal puhwag nuhulugum ehesafena. ");
INSERT INTO amn_n_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita piskenam olningugenam, enaig osona, “Anuana, nango, li fig enam nosona, ‘Mas na fug lei enengim gamba.’ Enaig fenamba enag ati ehesafegim wagag!” ");
INSERT INTO amn_n_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Sisas wahigifenam elim enam osoni, “Negel gimba Godum olninginimbi Godmba emba yuhwa fef amang amangim enam. ");
INSERT INTO amn_n_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Aman mungo sambaga olug hwanig, mungo olugnifenam, enaig olningugeimba Godmba emba wa yuhwafef. Enaig olningugeimba, emba amangimehe esel sahig enag emba wa pugunuf. Enag ohuna mugum enag osonaimba, ‘Nemba fgafu kanam wahegimeg bu solna gi enanayi yikanam pe.’ Enaig osoimba, emba wa esef. ");
INSERT INTO amn_n_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Enaig fenamba enag yawo ka nem osonug, enag na Godumba sihinagim ahsahanafimba enaig olningenam, amangim eseli na ahsahini enag figim, enaig leseimbi, emba na wambuf. ");
INSERT INTO amn_n_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“Enag mayi na gohonam Godum sihinagofimba, na enaigim olningimba, aman nem amang amang amtakwalig esenag, enam enag etetinam wahiai. Nogofeika mungwal ahnaig ahnaig amtakwalig enag mingnag el nem esegonum, nogofeika enam kikehelim! Eteti wahiyi! Esmba na fimbi, neana awag ofwa aga, enag nem ahnaig ahnaig amtakwalegim wambihiageni, mas piskenam enam enag olningi. ");
INSERT INTO amn_n_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Enaig na mingnag elni ahnaig ahnaig amtakwalig na etetigim wahiai hwanigmba, emba God neana ahnaig ahnaig amtakwaligim mas eteti wahiai.” Sisas enaig osoni. ");
INSERT INTO amn_n_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Piskenam ahunam Jerusalemoa apekugonam. Enag Sisas Godna lala naligyi tempelyi sahonam langwagofena. El Enginag ainiyag pris el afa Ainiyag sisiyi fesaig el, enag el Sisasim nangum ambogona. ");
INSERT INTO amn_n_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Enag Sisasim enaig sahinifini, “Aman nem osonag, ‘Ena gafungag ena fe,’ aman nem enaigmba osonag?” ");
INSERT INTO amn_n_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Sisas mungwag sihini, “Amang mungom ka nem sahinim, na kam mungwag enam sihinigmbi, emba sa ka nem sihini aman esel kam osonag, ‘Ena gafungag ena fe enam,’ mungwal gafungag esel ka feg. ");
INSERT INTO amn_n_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Aman Jonumba osona. Elim buwa aitiagimba? Ena mo enag ofwanai boname? Elyinai boname? Kam sihini.” Sisas enaig sahinigena. ");
INSERT INTO amn_n_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Enag el ehefem sihiagegofofena, “Amangim big osogof? Big enaigmba osogoimba, ‘Ofwanai bok,’ emba Sisas bigim sahinif, ‘Ahnaig asegmba enam mas na olug wahigifigim Jonna mom pahalug ahugmo?’ ");
INSERT INTO amn_n_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Afa enaigmba big osogoimba, ‘Elyinai bok,’ emba el bigim nunumuhiagif.” Ahnaig asegmba? Enag el enag Godna lalanaim mingnag elim embefegoni. Mungwal el enag olningini Jonmba profet, Jonmba Godna mengig wanai mo fag el. ");
INSERT INTO amn_n_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ainiyag el enag enaig fenamba enag, Sisasim wahigifinim osoni, “Kagelmbi anuanamo.” Enaig fenamba enag Sisas osoni “Enag ka gamba mas ka nem sihini aman esel kam osonag, ‘Ena gafungag ena fe enam.’” ");
INSERT INTO amn_n_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Sisas enawasim sihini enaig osona, “El mungo wain lifug aso fegim bwag aitig. Mime kunim hun tifutukni numwehiaginim enanayi wain fug aitinim mongni wainfug fapaugofigim enaig esigim bug puguagim. Enag sime lala kwina nimbanam el enanayi fahegegohogum ma sa wa okwefna el ambogonam wain fug wambuf. El enag mingnag elim wasanam enag asom fahegegofohogum, afa mingnag lifugwo ena gafungag wanai enam wambugum, afa mingnag lifugwo asoana awagim faifini. Asoana awag wahegam kafenamba. ");
INSERT INTO amn_n_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mayi lifug enag asonai enag ambiafenamba, eso asoana awag gafungag el mungom ningihiafena enag asogam, enaig sawiyifefenam ma mingnag wohof yika wambwi enag asonai. ");
INSERT INTO amn_n_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Enag el asowa fahegeg gofohog enag enaig esifini. Elim enag nangufinim, mayi bwafenamba, sulufifinim tigifinim, yusug piskifinim ningihiyifini. ");
INSERT INTO amn_n_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Asoana awag enag piskenam ming elim ningihiana, enam gamba mesowa topinim amtakwal tigifini, amtakwalefini. ");
INSERT INTO amn_n_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Asoana awag ming elim ningihiafena, enam tigekifini. Enag enagsa el gafungafigim ningitigifena enag asogam. El enag enaig esinim, mingnag elimwo behtanigim kugwag aitifinimbi ahkitigiaogona, mingnag elimwo melni kugwagsungofini. ");
INSERT INTO amn_n_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Enag mungo gofena, elimba ehefena leg mungo enam olug lahlafena. Awag enaig sihifeni, ‘Elimba kana luwal, gafungag el enag kana luwalim anghiginim lahlafinif.’ Enag sumiyim enag ehefena legim ningihiana. ");
INSERT INTO amn_n_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Enag el eseli enag asowa gafungafegofofena enag ehefum oligi sihiagahufena, ‘Elimba asoana awagna leg, emba awagimoa wahaimba mungwal gawig ena wa wambuf. Hegefi! Nawo tigekim, nawo tigekinim, eso ehena asom fim!’ ");
INSERT INTO amn_n_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Enaig fenamba enag tigekinim eligimwo aso leng meigim finim fatini. ");
INSERT INTO amn_n_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Enag wain asoana awagmba ahnaig asef? Emba bonam, el eseli asowa gafungafegofofena, enamba kugwag sungo fenam eso mingnag elimoa asowamba enamba faif. ");
INSERT INTO amn_n_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Mas na ginofum enag fahegaginimo God autinam osona, enamba? ‘Mingnag el lala nimbigim, gungwekigim mungom nangufinim kwisifini, Afa gungwe kik enag yawamba wofugukum pugug. ");
INSERT INTO amn_n_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ainiyag enag enaig esegim pugug; enag ka nangugmbi lahlag newug feg.’” Sisas enag ehefum ena wasim osoni. ");
INSERT INTO amn_n_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ainiyag el enag enam higinim ati olningini Sisas enawasim ehelim osonug olningini “Kagelmbi amtakwalig enawasim enaig fenamba,” enag el enag ogona, “Nawo Sisasim kikehilinim ogohum,” afa enag embefini. Enagsa mingnag el esel Sisasim pahalug ahuafena, enag elim enag embefegoni, enag Ainiyag el enag Sisasim wahiyini ahuna. ");
INSERT INTO amn_n_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Mingnag el Farisi elim afa Herotna nihiyinai elim enam nigitigini Sisas nangum. ");
INSERT INTO amn_n_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ona, “Nawo Sisasim amang amangim sahinim. Ogona mayi Sisas amtakwal sihifeimba, neso sulufinim kotinim.” El eso tatam aula fakahilinif, enaig lofug ogona, “Nawo eso Sisasim esinim.” Israel el Rom wanai gavman elim takis mani faigim, enag nunumugonam kwisini. Enag Farisi el afa Herotna nihiyinai el enag ambogonam Sisasim sahini, “Anuana, ati ka olningig, nemba yinim osfawof, nemba mas embefini ahnaig ahnaig esel nem olninginig enam. Aman esel Ainiyag feg enam enag nemba mas ahnaig mo faiyinam. Afa aman esel hofanam feg enamwo mas na ming mo faiyi. Awai! Nemba yinim fa sihif God esel membeg enam mungo. Enag nimbe kam sihin, Romoanai el elim nangwagawo, wunehalamba, Sisa, enamba ka manimba faiyime? Awaime? Enaigmba ka esimbi ka yuhwa feime? Awaime? Enag kawo mani enag faime? Awaime?” Sisasim enaig, sahinifini. Ainiyag el enag enaig olningugini, “Sisas mayi enaig sihifenimbi, takis mani Sisam fai,’ eso mungwal Israel el Sisasim nunumufif. Afa enaig mo sihinimbi, ‘Nogofeka takis mani Sisam faim,’ eso gavman el Sisasim waginif.” ");
INSERT INTO amn_n_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Sisas ati olningini enagel enag ogona, “Nawo Sisasim gihinim.” Enag Sisas wahigifenam, osoni, “Amang figim nogogum na kam gihinim? Mani busug kam ombugona, kawo nangom.” ");
INSERT INTO amn_n_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Enag el mani mungo ombugona, enag Sisas sahini, “Nohmbusugi wunehalag mba amana?” El enag osoni, “El Ainiyag esel Romoa nangwagawo, wunehalamba Sisa, enagna nohmbusug.” ");
INSERT INTO amn_n_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Enaig fenamba, enag Sisas osoni, “Amang Romoa nangwagohog elnimba, emba eso enam faiyi; afa amang Godnamba eso Godum faiyi.” El enag ena mom higinim olug wahegasaina. ");
INSERT INTO amn_n_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Mingnag el Sadyusi el Sisas nangum ambogona. Sadyusi el enag enaig osogwafena, “Elimbi wahagim, mas piskenam bwihiai.” El enag ambogonam, Sisasim sahinim, ");
INSERT INTO amn_n_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Anuana, Moses ena mom autinam ginofena, amanim luwal hwanig wahaimba, afa ehena angwag agafuf, emba so ehefena suminig enag ena angwafigim enag ma fafim. Luwal mayi feimba eso ena luwalwo eteg esel luwal hwanig wahag ehagna kukwa gohof. ");
INSERT INTO amn_n_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Autinam elengegwa gohona, enansini nilitena gofwehena enag eteg angwafig fanam, afa luwal hwanig wahana. ");
INSERT INTO amn_n_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Etegim engeg enag angwafigim fanam, afa luwal hwanig wahana. Bwali enag fagim gwenag angwafigim fanam, afa ehe gamba luwal hwanig wahana. ");
INSERT INTO amn_n_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Afa figinyeg, afa, enuweso, afa elngeg ena suminimbugug enag finim enag angwafigim mungom enag luwal hwanig fesainam pigina, afa angwafigim gimba sumiyim wahana. ");
INSERT INTO amn_n_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Enag hwaonam, melig pigyeg ena wa bigiagafef, enag hwaonam enag angwafigmbi amana angwag fef? Ati na olningig elengegwa gohona enag el enag angwafig mungom fini.” Sadyusi Sisasim enag enaig sahinifini. ");
INSERT INTO amn_n_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Sisas osoni, “Negelmbi mas na anuana figmo Godna mom autinam el ginofini enam. Enag mas na anuana figmo Godna tifutukum gimba. Enaig fenambe, enag negel enag mwetetiagig, mas na yuhwa figmo? ");
INSERT INTO amn_n_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Enanam melig pigyeg piskenam bigiagofefimba, enanamaba mas angwafigmbi wambwi. Ensel, Godna gafungag wanai, ofwanai, angwafigmbi mas wambwi, enag enaig el gimba wa esif. ");
INSERT INTO amn_n_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Yawo enag nawo olningugim el wahagim piskegim bwihiagim enam autinam Moses ena mom enag ginofena li suwila lagofenamba. God ena suwi mewa sahogohonam Mosesim sihinagena. Ena mo enag mas na fahegigmo? Abraham, Aisak, Jekop enam autinam pigig, enag God Mosesim enaig sihifena, ‘Kamba Abrahamna God, Aisakna God, Jekopna God.’ God Mosesim enaig mo sihina. Afa God ati olningina ehelni sungwagmba mahiyim augwia. ");
INSERT INTO amn_n_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Godmba melig ese pigig enag elni Godmo. Awai! Elimba enag elni God ehe aman esel hegeg gohogum esel, enag elni God. Negelni moamba amtakwal newug feg!” ");
INSERT INTO amn_n_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Anuana el mungo bona Sisas nangum, ena hegenamba mo fuflafegegofofena. Enag higinamba Sisas mo wahigifenam yuhwa sihini. Enaig fenamba, enag el Sisasim sahana, “Godna moamba ahanag sisiyiamba feg?” ");
INSERT INTO amn_n_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Sisas wahigifenam elim enag osona, “Mo sisiyi fegmba ohunag, ‘Negel Israel! Negel higi! Ainiyag God mungwehe mungo Ainiyag bigelni fenig. ");
INSERT INTO amn_n_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nimbefum! Ainiyag enag, nimbefena Godum enam nininewug olug lahlafena. Nimbefena olug, sungwag, tifutuk, enag mungwal Godum ma lahlafini.’ ");
INSERT INTO amn_n_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Enam engeg mom mba enaig eseg, ‘Nimbefum esel na lahlafenagmba, enaig eso mingnag elim gimba enaig olug lahlafenai aman esel neana muhwa aga enam.’ Ming mo mba mas ena mo sambagam enag flafatigmo.” Sisas anuana elim enag enaig osona. ");
INSERT INTO amn_n_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Enag anuana el enag Sisasim sihina, “Anuana, nemba yuhwaho osog. Elimba yuhwahofeg, esel nosog God mungwehe Ainiyag feg, ming Godmba mas fegmo, gweli mungwehe. ");
INSERT INTO amn_n_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","El ena Godum ma olulahlafini, olug, sungwag, tifutuk enag mungwal enag Godum ma olug lahlafini. Ehefum esel lahlafenagmba enaig eso ma minbnag elim gimba esei aman ehena muhwa aga enam gamba ma olug lahlafeinai. Sis afa amang amang enagel Godum fa faiyif, enaig pahalu ahufigim enag elimba yuhwaho. Afa enag sambaga ningigi mo enag pahalukahuagim afa amang amang Godum faiyigim enam flafatig.” Anuana el enag enaig sihi Sisasim fena. ");
INSERT INTO amn_n_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Sisas enam hegnam, enag olningig anuana el ati olningig ena mo lahlag nininewug sihig. Enag Sisas sihina, “Nembe gweli ati na bogum Godna muhwa puguagim ofe. God afalig esel enam wahegwa na gohmo.” Enag mungwal el esel enag embefinim Sisasim ming mom sahingim. ");
INSERT INTO amn_n_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Sisas Godna lala naligyi tempilwa gofenamba elim mo sihinugenam, enaig osoni, “Ahnaig asegmba enag anuana el enag enaig osogog. ‘enag Kraisim enam ogogum Devitni leg?’ Ahnaig asegmba enag enaigmba osogog? ");
INSERT INTO amn_n_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Godna sungwag Devitim ogofunagenamba, enag Devit autinam enaig osona, ‘God Ainiyag enag kana Ainiyag sihina, Nemble kana nihigim ningagim agai. Nihigim augwiagmba enaig eseg aman esel sisiyifeg enag fawof. Enengimba amangal esel nem ona kawo amtakwalefim enag elim enag ka neana mong singag wasanif.’ Devit Godna mo enaig osoni. ");
INSERT INTO amn_n_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Devit ehehmba, ‘Ainiyag’ moaogona, enag Kraismba Devitni leg ena ming momba enaig eseg Devitim gamba Ainiyag fenag.” Sisas enaig osoni. Enag elksa sifakalni Sisasna mom higinim. ");
INSERT INTO amn_n_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Sisas mo ogfunugum enaig osoni, “Anuana el enag mingnag enaig esehu, enam negel gimba nunofifum anuana elim eseli enam. Anuana el enag enaig amtakwaligim membig, lofug kwieg aitiagigim, eso aisagafesai. Lofug kwiegmba autinam enag anuana el mungo aitikigwafena. El enag enaig olyifini ogona, ‘Eso el kam ma lahlafegoni.’ Enag eso ambogofenam ambagam nuwagifinam sahoafena kimbigwa gamba. ");
INSERT INTO amn_n_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Israelna nuwagig lalawa enag el enag kuk lahlagim mungo lahlafini ogonam, ‘Nawo ahufenam ambagwa elni nohmbosogam auguiafum. El ma bigim nangwagi.’ El enag ogona, ‘Nawo wohof nalig ahagagwa gamba ahufenam, kuk lahlagwa mungo auguiafum.’ ");
INSERT INTO amn_n_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Mingnag angwafig esel ligambugugum, mayi pigiafenamba angwafig mungo mayi auguiafenamba, anuana el enag ahufena angwafigni lala enag wambugifini. El enag Godum enaig moakwalnifinim sahinifini kwina gwesim ogohu asagafena. Hwaonam, God fahegagofefimba enanam enag enaig el kinig tawetik nalig newugehe wa wambuf.” Sisas enaig mo osoni. ");
INSERT INTO amn_n_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Sisas mani keg muhwa agafena Godna lala naligyi. Enag elim nangwagawofena mani aitiagofofena enam. El mani numbiyinai el enag mani nalig aitini. ");
INSERT INTO amn_n_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Angwafig esig mani hwanig bonam mani ongug wesig sambaga fatiaogona. ");
INSERT INTO amn_n_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Sisas ehefena nihiyinaim wunoni, “Ambogo, yininewugehe ka nem osonug, angwafig esig esel mani hwanig fegim afa mani nalig fatig. Mingnag elim enam flafugum aitig. ");
INSERT INTO amn_n_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Enag el mungwal eseli enag mani numbni fesaig mingnag hofanam mungo wambuk ambogogum aitig. Afa angwafig esig enag esel, ehewo awai newug fena, mungwal mani gweliehe fatig, wohof gamba amangna wambuhmo?” Sisas enaig mo osoni. ");
INSERT INTO amn_n_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Sisas Godna lala naligim enam wahianam puguna yikana, ehefena nihiyinai mungo Sisasim sihina, “Anuana, nango, hun lahlag naligni Godna lala nimbini, afa lala enag nalig lahlag newug ehe!” ");
INSERT INTO amn_n_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Sisas wahigifena enaig osona, “Ena lala naligim enag atiaho na nangog? Emba hun mungo mas mung hun sisiyi gifi. Awai! Emba wa mungwal tutosungofinim tatugof.” ");
INSERT INTO amn_n_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Sisas Mug Olifyi agafenamba nanguwufena Godna lala naligim. Pita, Jems, Jon, Andru, enag el mungo Sisas nangum ambogona, ");
INSERT INTO amn_n_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","sahini, “Yawo eso na sihig, enamba amansi puguf? Amang ahanaigwo mayi puguimba, eso enam ka nangum so olningim enamba ati muhwa puguagimofe?” ");
INSERT INTO amn_n_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Sisas osoni, “Negel numwehinim nunofifum aman mungo wa nem moakwalenim wankaf. ");
INSERT INTO amn_n_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Elksa emba wa ambogonam kana wunehalam sefinim, enaig osogof, Kikehe Krais, God, kam ningihiyiana. Enaigwa osogonam, eso wa enaig wa esif. Elksam mwakwalegonim wanahuf. ");
INSERT INTO amn_n_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Enaig enengim na hegimbi fak ahagfi afa fakmo bonam puguafi wahegwanai, enamba emba wa puguf, mungwal bete i, of i awaiegimba emba wa mahiyi fefuf. Enam na higinim negel nogofeika oluwahigesaim. ");
INSERT INTO amn_n_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ming betenai elwo ming betenaiim fegonfuf, ming king ehefena nihiyinaim pasifenam mingnag king wan go enam fegonfuf. Minggamwo kugwa puguafuf, minggamwo bini nalig puguafuf. Enamba enaig tawetik angwafig luwal muhwa fukuagim eso esfafef enaig wa puguf. ");
INSERT INTO amn_n_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Negel enag numwehenim nunofifum. Emba wa el nem wanahuf kaunsulna nihigim nahunam enam sihiagigim. Emba wa negelim nuwagig lalawa enanayi kugwag aitifif. Negel kam pahalug ahuafimba gwena mungwehe nem, wan ahunam gavman, kingni nohmbosugwa wan apekugonam wagonuf, eso negel enag Godna mo wankeneg mo sihigoni. ");
INSERT INTO amn_n_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Mungwal el mungwal betewa mungwal esel enanayi Godna mo wangenag enag mayi kaimba eso bite i ofmba enamba awaief. ");
INSERT INTO amn_n_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Enengim mayi el nem wanahufefimba kotimegonugum, nogofei, ‘Ka olug wahigegim, ahnaig big osogof?’ Awai! Mungwal mo God ne faimbi, eso na sihif. Ena mo enag nimbefningalni moamomba! Awai! Emba Godna Sungwagna mo. ");
INSERT INTO amn_n_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mingnag elwo ehefena niliteninga elim faigof, ogofei, ‘Ma tigeki.’ Mingnag el humoanwo luwalim elim faigof, ‘Ma tigeki.’ Luwal gamba wa awagafagim wagugonim elim faigof, ‘Ma kugwag sungofi. ");
INSERT INTO amn_n_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Afa negel enag kam pahalug ahuafimba enag mungwal el eseli enag nem olug kakagegonuf. Amangal tifutinim kam gwesinim pahalug ambogofefimba emba ahuanam mayi bite i of i awaiofefimba, enag God wa elim enag kwaganam wan bonam, eso hegeg gwesenam wan agafuf.” Sisas enaig sihifeni ");
INSERT INTO amn_n_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Enag enag el amtakwalig newug enagwa amang amtakwalig gafungafinim ena wo ombugunam osaigonam washuf, Godna lala naligyi. God newugum esel amang sisim, twafigim el fa faiyif ena kukwa el amtakwalig enag moakwalig Godum ombugonam ena fohluf. Aman ena mo enag fagehagmba eso ma numwehenam olningugei. Autinam God ena mo profet el Danielim sihina, enag ena mo Daniel ginofena. Enanam enag amangal Judiawa oguwa enag, so ma mugam yikagna fukwalgonam ahwi. ");
INSERT INTO amn_n_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Aman lala sime mugyi gofimba, nofeka lala megam sahonam amang amang gawig ena fam. ");
INSERT INTO amn_n_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Aman asowa gohogmba, nofeka lalagam yikanam lofugnga enaig fam. ");
INSERT INTO amn_n_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Enag angwafig afnialigni gamba, elsimbam, angwafig luwal hwutiatanig mahiyim tut yuwig ahufena enag gamba elsimbam. ");
INSERT INTO amn_n_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Negel enag Godum sahini amang enag eso masa ninegnam enana puguf! ");
INSERT INTO amn_n_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Yuwana newug God mungwal gawig esegenam enanayi kinig puguna, enag enanam pugugum bogum yawo ohunanayi feg mingnag kinig mungog gamba ati yawo enag feg, enag enengimba nalig kinig newug ehe wa puguf autinai kinigim wa flafatif. Afa hwaonamba enaig kinig enawa mas piskenam pugwi. ");
INSERT INTO amn_n_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Autinam newug God eso gishu fwahiana enanam enag amtakwalignam tumefatiagim, afa kwina kafimba mungwal el enawa awaiete. Enag asegmba God olningini mingnag elim esel autinam gisfuna hwatina ehe nangum ambogogum enaig fenamba. ");
INSERT INTO amn_n_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Enanam enag aman mungo wa nem osonuf, ‘Nangu! Kraisba esel go! Nangu! Egam ese go!’ Ena mom enag nogofei ka olningim! ");
INSERT INTO amn_n_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Afa mingnag elwo wa enaig moakwalif, ‘Kamba Krais,’ afa mingnag el amtakwalig wa apekugonam ogofei, ‘Kamba profet Godna mom ka wambuk ombugog.’ Enag el enag ogogum ‘Kagelim enam God gisfugum hwatig’, enam ogogum ‘Nawo wan ahum.’ Enag enaig wa esif, tifutuk gafungag wa apekugof, apekugof ahnaig ahnaig ehfamba nemona, autinamba mas enaigimba big nangunimo, ");
INSERT INTO amn_n_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Amang esel mahiyim puguahwanig feg, enag hwaonamba wa puguf. Enam ka nem osonug. Enaig fegmba enag negel enag numwehenim nunofifum.” Sisas enaig sihifeni. ");
INSERT INTO amn_n_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Enag kinig nalig mayi awaieimba, eso osuwu pugog hwanig wa feg, afa waswa pugog hwanig wa fei, ");
INSERT INTO amn_n_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","bagnofut ofwanai fugahianam apeigof. Mungwal tifutuk ofwanaim, enag autinai tifutuk kikehelagu osuwi, was, bagnofut enag ehefena kukwa autinam gofofena, enag emba wa kiafigif. ");
INSERT INTO amn_n_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Enanam enawa Enag El Of Wanai God Ningihiana enawa leangowa pembof, mungwal tifutukni, afa afwambusug nalig newugni feimba, eso el nanguf. ");
INSERT INTO amn_n_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Autinam, God elim ehefum gisfu hwatina. Enanam ombofimba, eso wa enaig esef. God ehefena ensel gafungag of wanaim ningitigif elim ehe esel gisfugu hwatig, enam nuwagug ahugum. Emba wa mungwal bete esel enagna wambugenam afa of i bete i mwetetenaig wanai gamba mungwaliyi wambuf.” ");
INSERT INTO amn_n_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Li fig enag emba nem amangim ogofunuf? Enag li fig enag mulug figeg apekugofehba emba ati na nolningig osuwu nalig muhwa opuguhmba enag esfafef, enag eso ati big olningig ningi sisig esoh enaig esfafef bu puguagim mayi meini ofehba, eso sisesungofafef. ");
INSERT INTO amn_n_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Gwenaig ehe na nanguf amangim esel ka nem osonug, enamba, elim na wa nangwimbi wa puguf, enag emba na wa olningif, El Enag God Ningihiana Of Wanai enag go ambagam mengig muhwa. ");
INSERT INTO amn_n_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ninimehe ka nem osonug, enanam elim enag pigeg hwanig fe fimba, eso enanam mungwal amang amang enawa puguf. ");
INSERT INTO amn_n_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Of i, bete i, gamba emba wa awaief, afa kana moamba mas awaiei.” ");
INSERT INTO amn_n_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Aman mungo olningig hwanig amansini ehe wa bof osuiname, sinainime. Godna gafungagwanai ofwanai gamba mas anuanafigmo, Godna leg gamba mas anuanafegmo. Awag ehe mungo ati anuanafeg enam enag. ");
INSERT INTO amn_n_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Negel numwehinim nunofifum, mas na olningigmo amansihe enag enawa pugu osuiname, sinainime. ");
INSERT INTO amn_n_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Elimba enaig eseg, aman mungo ehefena lalam wahiagim. Enag ehefena gafungag wanaim elim osonug, ‘Kana gafungagmi, gawigmi fahegegofofum.’ Enaig osonugum mungo mungogum gisfua hwatig gafungagim enam. Mengigwa nunofegohog elim, enam osonag, ‘Numwehenam mengigim fa nangofegofum,’ El Enag enaig osonag. ");
INSERT INTO amn_n_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Enag negel gimba gwenaig numwehinim nunofifum, amansihe lalana awag wa bof osuwipegnam boime, si olugyi gohognam boime, leawa kwimbiyim boime, leawam boime mas na olningigmo. ");
INSERT INTO amn_n_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Enaig bogmba yawo yikagnam ehe wa puguf, enag wa nem nangoimba, na non gifuf. ");
INSERT INTO amn_n_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Enaig fegmba enag ka nem osonug, enaig fenamba enag ka mungwal elim osonug, ‘Numwehinim nunofifum!’” Sisas enaig osoni. ");
INSERT INTO amn_n_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Sambaga osuwu mahiyi gohmba olningigim Pasovami afa bret pupkuog hwanig ahagagim osuwu nuguagim, enanam enag muwagigim, Enginag ainiyag pris i, anuana el i, yisigiagini, “Ahnaig big asinim so Sisasimba big kikeheli sulufinim tigekif? ");
INSERT INTO amn_n_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Enaig mas big lahlagnam Pasovanamba enanamba mas big esi. El masa wa el bagagif.” ");
INSERT INTO amn_n_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Sisas Betaniyi agafena Saimonna lalawa enag el autinam ehehna fena. Enanam enag kukwa aganam wohof onefenamba, angwafig bonam sahona hun keg botol wel fungug lahlagna mengigwa puguag ombuna. Ena wel nog weg wesig bugba fungugni lahlag, enag wunehalamba nalt. Mani naligni fana. Botol enag pugugenam afa wel enag Sisasim mesowa sugfuna. ");
INSERT INTO amn_n_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Mingnag el auguiafena enag olugakagni. Ehefum olugyi sihiage gofofena, “Amang fegim ena welmba yusugmba fatig. ");
INSERT INTO amn_n_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Enaig big mani figbi mani nalig big wafiti. Big enaig wa 300 kina fiti, eso big elim amang hwanigim enam faigoite.” El enag angwafigim nunumufini. ");
INSERT INTO amn_n_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Sisas osoni, “Wahiyi! Amang figim, na enag angwafigim kinigbi faiyig? Elimba yuhwahe kam esenag. ");
INSERT INTO amn_n_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Autinai ehe el amang hwanig auguia. Amansi na sawiyi fegim kwaganiegimba, eso kwagan. Enag kamba, ohiyiaga hegeg gwesegim awohmo. ");
INSERT INTO amn_n_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Amang angwafig enag esegmba yuhwaho eseg. Elimba wel lahlag kam eligim sugfunag, kam numwehenageg kumoagaligim gwenaig esifinimbi enag kam wahagim ma sa yikagna nongif. ");
INSERT INTO amn_n_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Yinim newug ehe ka nem osonug. Mungwal bete esel enanayi Godna mo lahlagwa sihiahufuf, enam gamba angwafig esel eseg enamoa sihif, feimba olninguguf.” Sisas enaig sihifena. ");
INSERT INTO amn_n_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Enanam enag 12 fenam Sisasna nihiyihai, enag elyinai, mungo Judas Iskariot, enag yikanam enginag ainiyag prisim ona nawo Sisasim faim. ");
INSERT INTO amn_n_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Enginag ainiyag pris enag ena mom higinim enag sifakalni. Enag osoni, “Emba ka nem mani faiyif.” Enag Judas enag mina yisigiagena ogum ahana minawawo amansini pris elim enag Sisasimba ka faiyif? ");
INSERT INTO amn_n_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Israel el enag mungwaliyi yiawa osum elengegiwa gohog osuwum gishu fwahiyinim. Enag wikwo angig fegim yikagim elngegwa pugug enag mungwal osuinamba bret pupkuog hwanig ahgahufena. Angig enag osuwu enag puguna, enanam enag sipsip luwalig fa kugwagif Pasovawamba. Ehefena nihiyinai enag Sisasim sahini, “Na sawiyifeg ahananayi kahunam Pasovamba numwehiagimbi, eso pasova enag na nef?” ");
INSERT INTO amn_n_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Sisas sambaga ningigim sihinim, eso ningitigina, “Ne ningigi ahkanam ahsahon kimbig naligyi. El mungowo bu sompni ombofuf enag nem wa minawa wa bof. Eso ne ningigi enag eso elim enag ahpahalukui. ");
INSERT INTO amn_n_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Mayi yikanam ahna lala mungowa sahoimba eso ne ningigi enag lalana awagim enam enaig sihiahfenai, Anuana osog, ‘Kana kukmba ahananayi go? Kawo Pasova enanayi kikefena nihiyinaim wan nem.’ ");
INSERT INTO amn_n_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Emba wa nem ogofunuf kuk nalig sisiyigam go ati numwehiagigim wahiyig. Ne ningigi wohof enanayi numwehiage ahfe. Enag ehefena nihiyinaim sambaga ningigim ena ningitiginamba, ahkana.” ");
INSERT INTO amn_n_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Sambaga ningigi enag ahkanam kimbigwa ahpuguna, enaig sambaga ningigi enag ahwufuana gwenaig eso Sisas osoni enaig. Enag sambaga ningigi Pasova numwehiagahfena. ");
INSERT INTO amn_n_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Osuwupegnam Sisas ehefena nihiyinaim mungwaliyi wanbona. ");
INSERT INTO amn_n_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Enanam enag ogunam ahgafenamba Sisas osoni, “Yininewug ehe ka nem osonug. Negelyinai mungo kam elim faiyif enag kam tigekigim, el mungo osohwi kamble i ahneawo enag.” ");
INSERT INTO amn_n_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ehefena nihiyinai enag olug wahegasainam, enaig esini, ehefum mungo mungog enag sahugini, “Kamble me?” ");
INSERT INTO amn_n_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Sisas osoni, “12 feg enanayi el enag yawo mungwa sompyinai ka lifug bug bretna figihiane ahofe. ");
INSERT INTO amn_n_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Elimba yiniho, autinam God osonamba, enag el ginofini, ‘Emba wa Enag El God Ningihiana Of Wanai enam wahaf.’ Afa aman Elim Enam God Ningihiana enam elim mingnag elim faiyimbi, emba kinig nalig ehnangum wa bof. Ma ehefena afag eseite, elim enam fukuag wahiaite, emba sa yuhwafeite.” ");
INSERT INTO amn_n_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Enanam mahiyim ahgafafenamba Sisas bret fanam, Godum lahlag moaogonam eso kukwasungofenam ehefena nihiyinaim faini. Enag osoni, “Fi, ohwimba kikefumehe ka nem afai.” ");
INSERT INTO amn_n_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Enag wain bug kapna fanam Godum lahlag moaogonam, ehefena nihiyinaim enag faini. Enag ena mungwal enag ahgana. ");
INSERT INTO amn_n_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Enag osoni, “Ohwimba kana taf, elimba enaig esena, taf kifutugum ehe ogfuni, amangim God eseli autinaim sihina yininewug ehe ena wa puguf. Enag tafmba ka sugfunuf elksam kwaganigim God nangum ambogogum. ");
INSERT INTO amn_n_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Yinimewug ehe ka nem osonug, mas ka piskenam ena wain bugmba nei yikanam mulug wainbug ka nef Godna wanagagwa.” Sisas enaig osoni. ");
INSERT INTO amn_n_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Enaig esinim, sangig mungo ogonam eso mug Olif gimwo fukwalogonam ahuna. ");
INSERT INTO amn_n_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Sisas enaig osoni, “Negel mungwal ena na wa esif, embem wa nahunam, kam wahiyinim. Autinam God enaig osona, enag, el ginofini; Mayi ka sipsipum nangwagohogum elim enam mayi ka tigekaimba, eso sipsip enag wa gweyi ahkitigiaogof. Enaig autinaim ginof enag osona. ");
INSERT INTO amn_n_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Afa ka wahambwihianam Galiligim ka kaf, negelni gof.” Sisas enaig esoni. ");
INSERT INTO amn_n_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita Sisasim osona, “Mingnag elmbi sa nem wahiyi, kamba mas ne wahiai!” ");
INSERT INTO amn_n_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Sisas Pitam sihina, “Yinenewug ka nem osonag, yawo ohuna sinainim sambaga mungogum wa na osof, ‘Mas ka Sisasimba anuanafenagmo,’ enaig na osoimba, eso kakaruk awag sambagagim wa moasiawogof.” ");
INSERT INTO amn_n_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Afa Pita tifutiagenam osona, “Enaig ka nemble i ahwahagimba, emba kesef, mas ka enaigmba osoi!” Mingnag Sisasna nihiyinai gamba gwenaig osogona. ");
INSERT INTO amn_n_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Sisas ehefena nihiyinaim egam wankanam wan puguna Getsemanigam, enag ehefena nihiyinaim osoni, “Ohiyi auguiafimba, kawo Godum sahnam.” ");
INSERT INTO amn_n_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Enag Pita, Jems, Jonnam ena mungo sulufunam wankana. Enag Sisasim oluginig fena, ");
INSERT INTO amn_n_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","enag ehefena nihiyinaim enag osoni, “Enag olkinig kam ofe enag ohuna kinig naligni gweliehe kam awaha. Ohunanayi auguiafimba nunofifum.” ");
INSERT INTO amn_n_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Enaig osonim, afa wesig hilikanam ehefum kanam betewa penam, eso Godum sahana, enaig na yuhwafegmba, ogum ena kinig ohunanam ma kam wahia. ");
INSERT INTO amn_n_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Godum enaig sahnafena, “Humoan, kana awag, nemba yuhwafef mungwal amang esel enag, ka sawiyifeg emba tawetik i, kinig i enag kana nihiyinai hikifati. Enag kana sawiegim nofeka pahalukum! Awai! Nimbefena sawiegim enam pahalukui.” Sisas Godum enaig sahanafena. ");
INSERT INTO amn_n_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Enag piske kanam nangwagenamba ehefena nihiyinai enag non asagafena. Enag Pitam osona, “Saimon, nonho na gi? Mas na wesigngiwo nofkike auguiamo? ");
INSERT INTO amn_n_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Negel enag nunofifimbi Godum sahinifi, enaig wa nem amang gihnigim wa bonam puguf. Negelni sungwagwo ogum nawo yuhwa fefum, afa elig ehe kifutieg hwanig feg.” ");
INSERT INTO amn_n_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Piskenam ehefena nihiyinaim wasanam yikana Godum piskenam sahanagim, yuwanam eso sahana enaig sahana piskefena. ");
INSERT INTO amn_n_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Afa piskenam bonam ehefena nihiyinaim nangwagenamba non asagafena ehelnim nofug kinignewug fesaina. Enag mas olningingimo ahnaig Sisasim asihinif enam? ");
INSERT INTO amn_n_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Bowalyi enag piskembonam, enag osoni, “Mahiyimho na ehe kukule asaga? Gweli! Ati meini ofe. Nunofi! Yawomba Enag El God Ningihiana Of Wanai, enag el enag elim wa faiyif. El ahnaig ahnaig amtakwalig esehugum enam wa faiyif. ");
INSERT INTO amn_n_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Bigiagafe. Nawo ahum, Nangu! Ati ombo el enag kam mingnag elim faiyigimbi eso kam tigekif, enag ati ombo.” ");
INSERT INTO amn_n_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Sisas ehefena nihiyinaim mahiyim sihinugego fenamba, eso yikagnam Judas puguna enag el 12 fenam enagna mungo enag. El kisa numb mungwaliyi enag gweyi ambogona, piso i, aga i wambuginim. Enginag ainiyag pris el, anuana el, ainiyag el, enag el elksam enam ningiyiginimba enag ambogona. ");
INSERT INTO amn_n_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","El enag Sisasim faiyigim elel, enag enaig esena, yuwanam ati enaig osoni, “Elim ena ka afwaf fatimba, elimba Sisas eso negel enag gwenamho kikehelinim, numwehenim nangwagufi.” ");
INSERT INTO amn_n_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Enanam enag Judas pugunam Sisasim osona, “Anuana,” esonam eso afwafe fatina. ");
INSERT INTO amn_n_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Enaig fenamba enag el enag Sisasim numwehinim ningagawa kikehelini eso nangwahufena. ");
INSERT INTO amn_n_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mungo gofena muhwa enag piso ehefena angagwanai sugufanam eso el mungom angalog hugufatina. Elmbi elimba prisni misog elni gafungag wanaim. ");
INSERT INTO amn_n_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Sisas el esel ambogonam kikehilini enam osoni, “Piso i, afa aga i na wambugigim wambuk ambogog kam sulufigim okwef luwalim lofug enaig. ");
INSERT INTO amn_n_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mungwaliyi osuwi enag ka Godna lala naligyi big mungwaliyi auguiafenam agofwehefenam ogogum afa ka nem sihinugekafena. Amang fegim enanamba na kam kikeheli hwanigba wahiyini? Afa amang amang mo enag God autinam esogba emba wa puguf.” ");
INSERT INTO amn_n_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ehefena nihiyinai mungwal el enag Sisasim wahiyinim embem ahuna. ");
INSERT INTO amn_n_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kwambolo mungo Sisasim pahalu bwafena. Lofug busug mungo kigeugonam enag, mingnag el elim enam kikehelini. ");
INSERT INTO amn_n_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Afa enag enaig esena, lofugwo hugufatinam nihig bihig embem yikana. ");
INSERT INTO amn_n_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Enag Sisasim wanigiahuna prisni misog elni lalagam. Ena lala wa enginag ainiyag pris, el sisiyi fesaig enag el, mo anuana el, el enag ambogonam nuwagena. ");
INSERT INTO amn_n_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Enanam enag Pita Sisasna sum yikafena sumifena wahegwehe. Ena yikanam sahonam bwag megam prisni misog elni lala muhwa. Enanayi mungwal ami el gi gofwehena. Ami el enag lalam nunofegofohog el. Enag Pita gamba yikanam sahona ena suwa nolokewofena. ");
INSERT INTO amn_n_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Enginag ainiyag pris el i mungwal el sisiyifesaig i, enag el mo yisigiagini amang esel Sisas eseg. Enam ogona, “Nawo wufuwinim eso Sisasim tigekim.” Enag mas ahnaig mom wufuinimo. ");
INSERT INTO amn_n_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Elksa Sisasim moakwelini, enag elni mo enag mungwa lofugmo. Awai! Nemona fesaina. ");
INSERT INTO amn_n_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Mingnag el gofwehenam Sisasim enaig moakwelini, ");
INSERT INTO amn_n_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Enaig ka higini, Sisas ogum, ‘Godna lala nalig enag ka tufatinam enag sambaga mungo osuwunam ka piske nimbanam augif. Elimba ningagana nimbahmo.’” ");
INSERT INTO amn_n_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Enag ena mo gamba mas mungwa lofug fegmo. Elimba ehfamba mingnag mingnag nemona fesaina. ");
INSERT INTO amn_n_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Prisni misog el enag olugyi gohonam, eso Sisasim sahana, “Na wahigifegim mo sihiagimba na kwisikho ena mo esel nem enaig osonug enamba?” ");
INSERT INTO amn_n_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Enag Sisaswo mengig kapinifenam gofena, mas amang mo wahigifenam osonimo. Prisni misog el enag piskenam Sisasim sahana, “Bwata nemba Kraisni, eso autinam God osona, ‘Emba ka ningihiaf elim kwaganegim ka nangum asambogogum.’ Enag Godum enag mungwal el lahlag moaogonuf. Nemba Kraisme? Awaime?” Prisni misog el enag Sisasim enaig sahanafena. ");
INSERT INTO amn_n_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Sisas osona, “Kamba. Emba na wa nanguf El Enag God Ningihiana Of Wanai enag Godna nihigimoa ka agafuf. Godmba tifutuk newug feg. Emba leango i wa piske ahbof ofwanai!” ");
INSERT INTO amn_n_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Prisni misog el enag ehefena lofug plefu wahianam enag mingnag elim sahini, “Amang figim big mingnag elimbi wunogonug ma mo ambogonam sihi? ");
INSERT INTO amn_n_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Sisasna amtakwalig mo ati na higig, osog, ‘Kamba God lofug.’ Negelmbi ahnaig olnignig amang ahnaig big esinif?” Mungwaliyi el enag mungwa mo fini, “Sisas amtakwaleg. Ma Wahai!” ");
INSERT INTO amn_n_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Yikanam mingnag el gweyi Sisasim memp kusini. Lofugna nofugum yisiyinim wahiyinim, eso tigini eso enaig osogona, “Nemba profet lofe. Nemba wahigifenam sihi, aman nem tikgeg?” Ami el sulufinim asangigim pepefefini. ");
INSERT INTO amn_n_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita ambagam betewa ambwagwa lala mengig muhuwa gofna. Angwafig, prisni misog elni gafungag wanai, bonam. ");
INSERT INTO amn_n_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Enag nangonamba Pita suwa nologewofena, enag angwafig enag numwehenam nangonam enag osona, “Ne gamba Sisas Nasaret wanai nahkafena.” ");
INSERT INTO amn_n_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Enaig Pita osona, “Awai! Mas kamba anuanafenagmo! Ahnaig mo elimba nosog?” Pita bwag mengig muhwagam kana. Enanam enag kakaruk awag moasiyina. ");
INSERT INTO amn_n_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Enag gafungag wanai angwafig enag piskenam nangonam, mingnag elim muhwanaim sihini, “Elimba mungo ehelyinai ehe.” ");
INSERT INTO amn_n_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Enag Pita piskenam osona, “Awai!” Wesig gohonam, el Pitana muhwa gofofena, enag piskenam osoni, “Amang fegim enaigmba nosog, ‘Kamba enag elmo!’ Neana wuneg Galilinai elni mo lofug. Ne gamba Galilinai na bok!” ");
INSERT INTO amn_n_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pita tifutiagena, “Yininewug ehe ka osog. Ka sawiyifeg ka yinim osogmba eso God ma kam kinig faiyi. Mas ka anuanafegmo elim esel na osogog enamba!” ");
INSERT INTO amn_n_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Enag yikagnam kakaruk awag piskenam moasiyina. Pita olningnam oiskenam ena mo Sisas eso sihina enam, “Sambaga mungogum na osof, ‘Mas ka Sisasimba anuanafenagmo!’ Enaig wa na osoimba eso kakaruk awag wa moasiyif sambagagim.” Enag Pita fisgi pena eso ufwena. ");
INSERT INTO amn_n_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Leawa kwumbiyim enginig ainiyag pris el, el sisiyifesaig el, el mo anuwana el, Israel kot el anuwana sisiyifesaig el enag el nuwagena. Ona nawo olninguginim gisfu wahiyim ahnaig big asif. Enag el Sisasim wena kikinim eso Pailat nangum ogohuna. Pailatmba kiap lofug Jerusalemoa kimbig nalig agafena. ");
INSERT INTO amn_n_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pailat Sisasim sahana, “Nemba Judana kingme? Awaime?” Sisas wahigifenam osona, “Nembe esel ati na gweli osog.” ");
INSERT INTO amn_n_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Enginig ainiyag pris enag Sisasim mo ksa sihinageni, ohunaig osogona, “Ahnaig ahnaig amtakwalig enag na esena!” ");
INSERT INTO amn_n_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Enag Pailat piskenam Sisasim sahana, “Ati na hegig esel nem sihinig ahnaig ahnaig amtakwalig mo esel enam. Masho na wahigife sihimo?” ");
INSERT INTO amn_n_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Enag Sisas mas amang mo ga sihinamo. Enaig fenamba, enag Pailat enag olug wahigegena. ");
INSERT INTO amn_n_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","7","Enanam enag el mungo kalabusyi gofena wunehalagmba Barabas. Mingnag elngi eseli gafman elngi bagagini. Enag elim enag mingnag elimwo ati kugwagsungofini melni. Mungwal yiawa Pasovanam enag Pailat enag el mungom kalabusyinaim pitigiafatiafena amanim mungwal el enag mayi membifinimbi, eso Pailat enag elim enam pitigifatiafena kalabus lalanai. ");
INSERT INTO amn_n_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Enanam enag el ambogona Pailatim sahini gwenaig eso esei. ");
INSERT INTO amn_n_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pailat elim sahini, “Na sawiyifigmbi kawo Judana kingim wahiam ma pugugai?” ");
INSERT INTO amn_n_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailat ati olningni enginag ainiyag prisna olningugugum. El Sisasna mom higifini, afa prisni momwo kwisifini, enag pris enag olug kakagini, enaig fenamba enag, pris Sisasim Pailatim faiyini. ");
INSERT INTO amn_n_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pris el Ainiyag enag mungwal elim enag sihigoni, ma Pailatim osoni, “Barabasim pitigifati!” ");
INSERT INTO amn_n_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pailat piskenam elim enag sahini, “Na sawiyifigbi ahnaig ka esef elim eseli na sefig, ‘Juda elni king?’” ");
INSERT INTO amn_n_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","El hogonam wune ogona, “Aga kaga tigegwa kukufinim tigeki!” ");
INSERT INTO amn_n_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pailat sahini, “Amang fegmba? Amang ahnaig ahnaig amtakwalig asegmba?” Enag hogna newug amtakwale wune nalig ogona, “Aga kaga tigegwa kukufinim tigeki!” ");
INSERT INTO amn_n_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pailat enag ona “Kawo elksam enam sawiyi fenim eso ma kam lahlafini.” Enag Pailat Barabasim pitigifatina ma pugugai. Eso Pailat Sisasim ami elim faiyini, ona, “Ma we kigna ma tiginim eso aga kaga tigegwa kukufinim tigeki.” ");
INSERT INTO amn_n_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Enag ami el Sisasim wanigiahunam saigona bwag megam gafmanna lala muhwagam. Ami elim enag mingnag ami el wunogoni, “Mungwal, ambogo!” ");
INSERT INTO amn_n_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Lofug tafkleg kwinam king oso fa fatif, enaig lofug enag ami el Sisasim fatini. Ami el enag we nasna kugunim Sisasim musowa kikini, busung lofug enaig king elmbi busung lahlag aitiag fafif enag busung lahlag hun mugna. ");
INSERT INTO amn_n_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Enag mayi ami el enag Sisasim busung lofug fatinim afa busung nasna musowa kikini esinim eso Sisasim mo kiapasefni. Ami el enag moakwalinim Sisasim king lofug lahlag moaogoni, “Ka sawiyifig nembe gwesenam gofum Juda elni king lahlag!” ");
INSERT INTO amn_n_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ami el enag Sisasim musowa agana tiginim. Afa memp kusufini. Ami el enag Sisasnayi moakwelinim mongukug kwakwaginim sifakaleni. ");
INSERT INTO amn_n_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Sisasim mo kiapasefinim wahiyinim, afa lofug tafkleg kwieg enag hugufinim afa piskenim ehefena lofug enag finim fatini. ");
INSERT INTO amn_n_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Minawa ahuanam nangunimbi el mungo bwafena wunehalamba Saimon. Saimon ehefena kimbig wesig Sairinim wahianam pugunim nalig kimbigam akafena. Ami el enag enaig esinifini, Saimonum ogogum, “Sisasna aga kaga tigeg enag faku.” Enaig fenamba enag Saimon fakuna. Saimonmba, enag Aleksander i Rufusni awag. ");
INSERT INTO amn_n_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ami el enag Sisasim sulufinim kimbigimwo wahiyinim ming betegam ogohuna, ena bete enag wunehalamba Golgota. Enag ena wunehalamba enaig eseg, Musog Kig Bihig Bete. Aman ahnaig ahnaig amtakwalig esegmba enagnagim ena betewamba elim kugwagsungo fegofogog. Enaig fenamba enag el enag ena betem enaig sefifini, Golgota. ");
INSERT INTO amn_n_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Mingnag el wain bug i mir bug marasin i ehuwahiaginim Sisasim faini. Mir bugmba marasin eseli enaig feg, tawetik wesigim kwegfowag afa ena bug enag Sisas mas nenamo. ");
INSERT INTO amn_n_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ami el enag aga kaga tigegwa Sisasim nelni kukufeginim. Mungwal eso ami el enag hun hutiatanaigwa ehefngelni wunehalag ginofeginim, eso enaig esini sompyi aitinim eso glenglefini, eso hun mungo amana wunehalana mayi pefenamba, eso enag el enag Sisasna lofug fafena. Gwenaig esinim Sisasna lofug enag mungo mungog enaig wambinim augini. ");
INSERT INTO amn_n_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Osuwu fukumbonam olugyi pugunamba (9 klok) enaignam ami el enag Sisasim aga kagag tigegwa kukufini. ");
INSERT INTO amn_n_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Enanam enag el enaig ginofifini elim ogofugunugum amang figim tigekig. Sisasimwo enaig ginofini: Judana king. Osogonam eso ginof enag aga kaga tigegwa kahalini. ");
INSERT INTO amn_n_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Afa Sisasna muhwawo ming aga kaga tigegwa el elim sambaga kugwagsungo ahfefnam afa okwefna ahwambna, ena sambagam enag mingimwo nihigim kahilini, afa mingimwo sahagam kahilini, aga kaga tigegwa eyi. ");
INSERT INTO amn_n_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Autinam Baibel osona, enag yawo ati pugug, Baibel enaig osona, “Enag ehim gamba enaig osoni ogonam el amtakwalig ga enaig.” ");
INSERT INTO amn_n_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","El enag ambogonam fahufegofofenamba Sisasim kiapase mo sihinahufna. El enag angmow waginim enaig osogona, “Hegefe, ena na osona ‘Emba ka Godna lala nalig bumbuge sungofenam, piskenam sambaga mungo osuwunam nimbaf.’ ");
INSERT INTO amn_n_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Enag nimbefum nembe kwegfo, nembe aga kaga tigegim wahianam, pe!” Sisasim enaig osoni. ");
INSERT INTO amn_n_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mungwal enginag ainiyag pris el afa anuwana el gimba Sisasim enaig mo kiapasefini. El enag ehefum olugyi sihiagahufena, “Mingnag elim mungo kwaganig, afa ehefumwo ahnaig asegim kwegfofehmo? ");
INSERT INTO amn_n_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Krais enag, Israelna king, ehe ma aga kaga tigegim wahianam pei, nawo oso nangum. Nawo enam nangunim, emba sa big olningi emba Kraisho.” Enag el enaig sihiagahufena. Afa sambaga ningigim esel katigini enag ehe gamba ati amtakwal mingig Sisasim sihinag ahfena. ");
INSERT INTO amn_n_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Osuwu muso suflulugnam si mungwal bitem enam kigfihiagenam osuwum mayi hikifwafenamba yika fenam eso 3 klok pugug. ");
INSERT INTO amn_n_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Osuwu hikifugwa gifinimba eso Sisas tifutinam wunona, “Eloi, Eloi, lama sabaktani?” Ena mo enag bigmba wahigifigim enaig osogof, “Kana God, Kana God, Amang fegim na kam wahiag?” ");
INSERT INTO amn_n_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Mingnag el muhwa gofwehiafena, enag enam higinim enag osogona, “Higi! Elaijam wunego.” ");
INSERT INTO amn_n_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","El mungo kikigini kanam lifug bug nongug ninim embeg efiyimbuna wagyi kikeugunim fifukwalaogonam Sisasim nihini ona, “ma nei.” El enag osona, “Awum, nawo nunofegofofum Elaija wa bonam pitigiafaime? Awaime?” ");
INSERT INTO amn_n_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Sisas tifutinam hogna wunonam, eso gweyi wahana. ");
INSERT INTO amn_n_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Enanam enag lofug nalig kinigni kwieg Godna lala naligyi enag eso sisiyi kukweogonam pekanam simewa pugunamba sambaga lofug ahfena. ");
INSERT INTO amn_n_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kepten, el mungo ami elim sisiyi fenig, enag muhwa gofenamba Sisasna wahagim nangwagofena. Enag osona, “Yini newugehe, elmbi elimbi Godna leg!” ");
INSERT INTO amn_n_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Mingnag angwafig gimba wahigwa gofofenamba wag nunofegofofena. Mingwo Maria Makdala kimbigwa wanai, afa ming Mariawo Jems i Josep i afag (enag Jemsba sumiyinai ming Jems,) afa ming angwafigwo Salome, afa mingnag angwafig gimba apeyena. ");
INSERT INTO amn_n_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yuwanam Sisas Provins Galiligim langwa kanamba enanam enag angwafig enag pahalug ahuafenamba Sisasim gafungagim kwegfuni. Mingnag angwafig ksa Sisasim pahalukahuna Jerusalemgam, ena gamba enanayi gofofenamba nunofegofofena. ");
INSERT INTO amn_n_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Osuwu yikanam pefenamba, Josep kimbig Arimateanai bonam puguna. Josepmba kot anuana el esel enag elyinai mungo. Mungwal kot el olningni Josepmba nininewug el lahlag. Ehe gamba Godna wanagagim nisanawofena. Enag sinimba Sabat osuwu wa puguf, enag yawanamba amang amang numwehiagigim sinigim. Israelna moamba enaig feg ming osunam gamba autinam Sabat elim wahagmba mas li kaga tigegwamba Sabatnamba luwafi. Sabatnamba mungwal Israel el enag ming osuwu pegam autinam Sabatnamba gafungagmba enag wahiyifini yikafenam Sabat osuwupegwa puguafena. Enanam enag Josep mas embefenamo Josep enag yikanam Pailatna nihiyi pugunam eso Pailatim enaig sahana fena, “Kawo Sisasim pitigifakunam hun megam osaigonam fakim.” ");
INSERT INTO amn_n_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailat kukugi fakanam osona, “Kamba kogum ahanana wahahmo?” Pailat el ami elni keptenim wunena, “Sisasimba atiaho wahag?” Kepten enag osona, “Ei, ati wahag.” ");
INSERT INTO amn_n_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pailat enag hignam eso osona Josep ma Sisasna eligim pitigifakwi. ");
INSERT INTO amn_n_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josep lofug busug lahlag manina fanam eso Sisasim pitigifanam opina, lofug busugni enana saganam, eso hun mimewa kumoahilini. Hun mimemba enamba autinam Josep ehefena gafungag wanai el kunim wahiyini, ena hun megam Sisasna eligim fakinim. Eso hun amta nalig yitiwiti fefug ambogwanam eso hun mengigim kaguwunim wahiyini. ");
INSERT INTO amn_n_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria, Makdala kimbig wanai afa ming Maria, Josepna afag, enag sambaga ningigi enag nunof ahfegofena enag ati ahnangona Sisasim esel fakini ena kugum enag. ");
INSERT INTO amn_n_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabat osuwu mayi kanam awaienamba, enag Maria Makdalanai, afa ming Maria Jemsna afag, afa ming angwafig Salome, enag angwafig enag wel fungugni lahlag ena manina wambuginim. Onanawa ambogonam Sisasna eligim susulenagim. ");
INSERT INTO amn_n_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sabat osuwunam enag siini leawo kwimbiyim enag angwafig enag bigigafenam hun megim nangugum ahuna. ");
INSERT INTO amn_n_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Angwafig enag ehefum sihiagahufena, “Aman bigim waganam hun mengigwa kagwog gi, enamba yitifatif?” (Hun enag amta nalig fena.) ");
INSERT INTO amn_n_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Eso angwafig enag nunofinimba hun mengigwa kaguonim wahiyini, enag mas gifinimo! Awai! Ati yitifatina! ");
INSERT INTO amn_n_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Angwafig enag saigonam hun megam esim ahuna. Nangunimba kwambolo mungo nihigim agafena lofug busug kwieg fatinam. Enag eso angwafig enag kukugiafakafini. ");
INSERT INTO amn_n_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Enag kwambolo enag enaig sihifeni, “Negel nogofeika olug wahigim. Ati ka olningig negelmbi Sisas Nasaret wanaim nangugum nambogog, Sisasim osohwi aga kaga tigegwa kukufini enam. Emba ati piske bwihiag, ohunanayimba mas gihmo. Ohuna kugum enam nangu, ohiyi fakini, enag mas gihmo. ");
INSERT INTO amn_n_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Negel enag ahunam ehefena nihiyinaim sihigoni, afa Pitam gamba enaig sihifini, Sisasmba neningalni gof ati wa kaf Galiligim. Emba na wa Galiliyi nanguf. Osohwi ati Sisas nem autinam osoni,” kwambolo enag angwafigim enaig sihifeni. ");
INSERT INTO amn_n_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Angwafig enag hun menai apekugonam embem yikagna ahuna. Enag eso kiafigig wahegasainam afa olug wahegasaina. Mas amang mo amanim sihinimo. Ahnaig asegmba? Angwafig enag embefini. (Ming el ohuna mo ginofenam augena buk Mak eseli enam enag) ");
INSERT INTO amn_n_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Leawa kwimbiyim Sabat osunam sini enag Sisas piske bwihiana. Enag Maria Makdalanai enagna nofwa yuwanamba puguna. Enag angwafig enag autinam Satanna nihiyinai amtakwalig elngegwa gohona enam Sisas hugufu aitina. ");
INSERT INTO amn_n_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Enag el Sisas wan gohonifefena enag el enag Sisasim olninginim wewufewofena. Maria yikanam enam enag sihini, “Sisasmba nofkike eliehe aga, ati ka nangog!” Ehel enag ena mom enam hignim, afa mas olninginimo. ");
INSERT INTO amn_n_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Enanam sambaga ningigi Sisasna nihiyinai kimbig naligim ahwahianam eso ahkana. Sisas pugunam wambna aman lofug enaig. ");
INSERT INTO amn_n_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Sambaga ningigi enag piskenam ahkanam mingnag elim Sisasna nihiyinaim ahsihini. Afa enag sambaga ningigina mom enam ati higim, afa olningi hwanig. ");
INSERT INTO amn_n_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Afa enengem ehefena nihiyinai el oguafenamba ahagafafenamba, enag Sisas pugunam wambnam, eso ehefena nihiyinaim enag wagini. Ehel enag mas olninginimo, enagenagim ehelni olug enag mweteti hun lofug. El esel sihigoni Sisasmba ati piskegam bwihiag, ena mom enag olningi hwanig. Enaig fenamba enag Sisas wagini. ");
INSERT INTO amn_n_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Eso Sisas sihini, “Negel ahunam, Godna mo lahlag mungwal betewa el eseli gohka, enag mungwal elim enag enanayi sihigonugahu. ");
INSERT INTO amn_n_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Aman olug wahigifenam Godum pahalukwi afa el buwa fati emba sa God sulufanam afa ehefena muhwa hegeg gohogum enam faiyi. Afa aman enaig olug wahigife hwanigmba, emba Godum mas pahalukwi, ahnaig ahnaig amtakwalig ehena nihiyi gwesegim go, enaigmba, eso wa tawetik nalig faf. ");
INSERT INTO amn_n_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Aman olningenam oi Godna moamba yinimehe, enaig esenam, Godum sahanaimba, emba sa God tifutuk gafungag ogofunai enaig gafungag enag el bihigmba mas ehe gafungafei, God enag enaig gafungafegim, og eso mingnag el enag olningi Godna moamba yiniho feg. El esel olningig enam kwaganegim eso Satanna nihiyinai amtakwaligim hugufuhianugeg enag nemona mog sihigoni enam enag autinamba mas higifinimo. ");
INSERT INTO amn_n_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Enaig sombine ga kikehelinim ningagana afa amang amang wahembug lofug ga enag ahagaimba, emba mas amtakwale sungofei. Emba wa gihna elim ningagana tuhwimba, emba el ena wangnefef.” ");
INSERT INTO amn_n_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Sisas Ainiyag enag mo sihinugenam, mayi wahianamba, eso God sulufanam ofgam wanikina, enag Sisas Godna nihigim aga. ");
INSERT INTO amn_n_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Sisasna nihiyinai enag ahuaminifegim Godna mo mungwal bete esel enanayi sihiagahug. Ainiyag kwaganig elbi ahnaig ahnaig kifutuk enag ogogfufenig elbi enaigba ahnaig gafungafihmo? Enaig gafungafigmbi emba enaig eseg elim ogfunug Godna moamba yiniho. ");
INSERT INTO amn_n_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kana nilite Tiofilus, kog autunam el numb gaba ena moba ginofini mang so kangelnai yi olyi puguna. ");
INSERT INTO amn_n_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Afa ena moba pahlukunaba ati mingnag el heafna nofna nanguni. Yuwana enaigba pugunaba eba el ati nanguni afa enaig elbi ofenaiba Godna mo gafugafeg el. Eso ena moba kam faigog. ");
INSERT INTO amn_n_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Afa na so ka ena moba kog ka kagaba nem ginofe fai. Afa ati ka ena enaigim fahigenagegim afa ka mogim yisigigim afa ka anwanafeg. Eso ohuna moba ini mo ka nem ginofenag na so ka nem faig. ");
INSERT INTO amn_n_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Afa ka enaigba esegba eba eso ne ena mom suwiginam eso ne numwehe anwanafe eso ati nem wagfunagig eba inim ehe. ");
INSERT INTO amn_n_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Afa enanam mahim Herot Judiana misog el gofnaba afa enanai yi pris mungo gofena. Ehena unehlagba Sekaraia. Eba Abiya wangofnaba ehganai eheba fena. Afa ehena angwagba eba Aron wangofnaba ehganai eheba fena. Ehena unehlagba Elisabet. ");
INSERT INTO amn_n_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Afa eheningi mas mang ahanaig ahanaig esafena mo eba heafna Godna nofwa lahlag ahgofenaba afa eba heafna Godna nihe mom mi afa membug mi mungo ahpahlu ahfefkufena. ");
INSERT INTO amn_n_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Afa eheningi luwal hwainig ati muhna ahfena. ");
INSERT INTO amn_n_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Afa mungonagim Sekaraiana ehganai el mungo eba pris Godna nalig lala wa enag gafugafe gofena. ");
INSERT INTO amn_n_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Enaig gafugagba eba mungo pris Godna nalig lala sahufenam sanda suwi wa tuhluiafena. Afa so mungonagim Sekaraiam sihini og soma enaig gafugafei. ");
INSERT INTO amn_n_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Afa mahim ehe lala megam sahukanamba eso el numb afwambawa agfohiafenaba eso Godum betenini. ");
INSERT INTO amn_n_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Afa so Ainiyagna ofwanai el bonam Sekaraiana nof wa puguna. Afa so ehe nihiginai ningagam sanda sime wa gofena. ");
INSERT INTO amn_n_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Afa Sekaraia ehem nangunam sineminefenam afa embefena. ");
INSERT INTO amn_n_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Afa so ofwanai el ehem enaig sihifena og, “Sekaraia, nofe ne embef. God ati neana sahigimba higig. Eba neana angwag Elisabetba fangonai luwal wanigaf eso ne Jonim unehla. ");
INSERT INTO amn_n_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Eba so ma neana olug lahlafenam afa ne sifakalef afa eba el numb sifakalif mahim enanam luwal gohiba. ");
INSERT INTO amn_n_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Enaba ahanaig, eba Ainiyag ehem nangunam og sonag elni unehlag eba naligfef. Eba mas mileaklana bu ne. Afa mahimsi afagna atag wa gifinibi eba Godna Sungwag ehem yuhwafenagef. ");
INSERT INTO amn_n_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Eba ehe enaksag elim Israel wa naim esenibi eso heafgelni Ainiyag Godna gum wahigi ahuf. ");
INSERT INTO amn_n_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Afa eba Elaijana nihe mi afa kifutig mi wambugegim eso Ainiyagim gosunaf afa so afahumonigni luwalignam esenibi eso mungo olug pugunif. Afa el so mom flafug enam ehengelni onigigim numwehenugeba so ma lahlag onigig finim afa so ma afsug el feasai. Afa eba elim numwehenugeba eso el Ainiyag bogim numweheaginim gofuf.” ");
INSERT INTO amn_n_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Afa Sekaraia ofwanai elim enaig sihifena og, “Ahnaig esegba eso ka ena moba anwanafef neana moba inim feg? Eba ati kam muhnafeg afa kana angwafig gaba gwenaig eseg.” ");
INSERT INTO amn_n_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Afa ofwanai el wahigi enaig esona og, “Eba kable Gebriel, na kaba Godna nofbusugam fagohf na so God ehe kam ningihiagba na ka bog nem sihinagim afa ohuna mo lahlag ka nem obu faig. ");
INSERT INTO amn_n_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Afa so na higim afa ne kana mo onigig hwanigba eba yawo neana mo wagigba awai ofe, ne mas mo wagi eba ikan ikan mahim enenam mang so mungwali puguf. Kana ohuna moba eba inim puguf enenam so God gishug wahiag.” ");
INSERT INTO amn_n_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Afa el Sekaraiam nengena fafnaba hugunam onigiga fafna og, mang mahim fegba naso mahimsi Godna lala saho ga. ");
INSERT INTO amn_n_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Afa so nengigim pugu afwambagam bonam afa ehe mas ehengelim mo wagini mo. Eso ehengel anwanafinim og, sohnaba mangim ahanaigim ehe nangug Godna lala megam. Afa ehe ningana mungo wagfunigena afa mengigna sihiagegba awai, ehena mengig ati pwakafena. ");
INSERT INTO amn_n_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Afa Sekaraiana gafuga feawagigba ati awaienaba eso ehe piske heafna kimbig gam ikana. ");
INSERT INTO amn_n_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Afa so sumi yi ehena angwag Elisabet enogni fena eba ehe meagam saho gohun ikan afawa pugufeg wasifenaba afa so Elisabet enaig esona ");
INSERT INTO amn_n_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","og, “Sawo autunam ka enogni hwainig fenaba eso kam Ainiyag afafenagim ohuna ahwanefuba tigefa fakanag.” ");
INSERT INTO amn_n_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Afa mahim enwesog wa pugufeg wasifenaba Elisabet ati enogni fenaba eso God ofwanai elim Gebrielim Nasaret kimbig gam ningihiana eba Galili provins gam. ");
INSERT INTO amn_n_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Afa ehe ikanam angwafig angwaming gim puguna enag angwafigbi ati Josepim faigim eso wahini ena elbi King Devit gofenaba ehganaifena. Afa enag angwafig angwamingna unehlagba Maria. Ehe mas kwamblo i mungo kug wa ahgini mo eba lahlag angwafig fena. ");
INSERT INTO amn_n_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Afa Gebriel ofwanai el enag angwafig enaig esona og, “Angwafig nasabam, Ainiyag ati ne i ahgo eso ma nem hugunam lahla feafai.” ");
INSERT INTO amn_n_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Afa Maria ena mo higinam olug fingifenam afa onigigna og, sohnaba ahanaig mo he! ");
INSERT INTO amn_n_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Afa ofwanai el ehem sihina og, “Maria, nofe ne embef, eba God ati nem hugunam olug lahla fenag. ");
INSERT INTO amn_n_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Sa hig, eba ne enogni fenam afa ne fangonai luwal wanigaf, eso ne Sisasim unehla. ");
INSERT INTO amn_n_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Eba amunai el gofe afa so enaig sefifif og eba Godna leg kifutig nemug. Eba God ehem gaba misog el washu ofe ehena simbianiga king Devit lofef. ");
INSERT INTO amn_n_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Eba Jekopna simbianigagna misog el higeg gofif, ehena misog el gafugag mas awaie nai.” ");
INSERT INTO amn_n_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Afa Maria ofwanai elim enaig sahna fena og, “Enaigba so ahanaig pugufef? Kaba mas awagana feg mo.” ");
INSERT INTO amn_n_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Afa ofwanai el ehem piske wahigi sihina og, Godna Sungwag ehe nem bonaf eso Godna kifutig nem yuhwafenagba eso ne ena luwalba nengigim wanigaf. Enaba Godna lahlag afsug el eso ehem enaig sefifif og Godna Leg. ");
INSERT INTO amn_n_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Sa hig, neana mangaug Elisabet ati muhnafeg enaig enogni fegba eba fangonai luwal wanigaf. Afa yuwana enaig esogona og eba mas luwalba fai. Afa yawoaba ati enogni feg afa ehena enwesog wa gohug was ati ahunag. ");
INSERT INTO amn_n_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Eba God ehe mungwali mangwalba eseagef.” ");
INSERT INTO amn_n_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Afa Maria esona og, “Sa hig, kaba Ainiyagna gafugag angwafig eso ati ne esog so ma gwenaig ese.” Afa so ofwanai el ehem wahia ikana. ");
INSERT INTO amn_n_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Afa so gwenenam Maria ikagna distrik Judiana kimbig mugam kukana. ");
INSERT INTO amn_n_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Afa ikanam Sekaraiana lala megam saho ikanam Elisabetim lahlag ogna. ");
INSERT INTO amn_n_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Afa Elisabet Mariana mengig higinam afa so luwal ehena atag wanai higmug fiagegifni. Afa Godna Sungwag ati Elisabetim yuhwafenagenaba. ");
INSERT INTO amn_n_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Afa ehe hugna enaig esona og, “God ati nem lahlag nemug esenagim afa ne mingnag angwafigim gosinig. Afa sona luwal so neana atag wa gibi ehe gaba God lahlag nemug ehem faif. ");
INSERT INTO amn_n_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Kaba aman afa kana Ainiyagna afag ka nangum bog? ");
INSERT INTO amn_n_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Sa hig, mahim ena mo neana bog kana angug wa pegba eso luwal kana atag wanai sifakalegim afa fapisofeaka. ");
INSERT INTO amn_n_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","So na onigim Ainiyagba nem enaig esenaf so ati nem sihinag eba se inim sifakale.” ");
INSERT INTO amn_n_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria enaig esona og; Kana olug Ainiyagna unehlagim fingi ofe; ");
INSERT INTO amn_n_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Afa kana sungwag Godum sifakalenag ehe kam kweagfug afa kam esenagba ka lahlag nemug goh. ");
INSERT INTO amn_n_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kaba ehena gafugag angwafig isug feg afa ehe eba mas kam etetig mo; afa so yawo afa nengigim gaba mungwali el enaig esogof og, God nalig sifakaleg ehem faig. ");
INSERT INTO amn_n_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Afa so kifutig God kam enaig esenagba eso kam lahlag pugunag. Eso ma ehena unehlag gwese afsug gofi. ");
INSERT INTO amn_n_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Afa el so ehem ahnai skaufinig enag ehengelim afafenig. Eba gwenaig esenif yawo gaba higeg gwese gofif. ");
INSERT INTO amn_n_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ehena ninga kifutig gafugafeg, afa el enaig onigig ka kike gosug el feasaig, eso heafgelni unehlam fingifig wambuhuia minefeg enaig elbi eba ehe amtakwalig aitif. ");
INSERT INTO amn_n_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Afa eba misog elim pigaupif afa unehlag hwainig elim mo fingi wamb fukuf. ");
INSERT INTO amn_n_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Afa elim bini pigig eba ehengelim lahla gawig wamboaibi eso eheba yuhwa feasaif afa so gawig enaksagna el feasaig eba mas fai eso ningitigiba isug ahuf. ");
INSERT INTO amn_n_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Afa autunam bigelni simbianigam God mo sihi wahiani eso ehe heafna gafugag elim Israel wanaim kwaganig. ");
INSERT INTO amn_n_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Afa ehe mahimsi onigig gofena enag ogna Abrahamim afafenam eso ma enag gwese simbianigam gohun fi. ");
INSERT INTO amn_n_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria Elisabet i ahaganam ikan sambaga mungo was fenaba eso heafna kimbig gam piske ikana. ");
INSERT INTO amn_n_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Afa mahim enag osuna pugunaba Elisabet fangonai luwal wanigana. ");
INSERT INTO amn_n_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Afa so heafna hihe i afa mungo kimbig wanai i ena mom higinim og Ainiyag ehem hugna afafenag afa so ehengel sifakalini. ");
INSERT INTO amn_n_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Afa mahim kug yi gohug osuna pugunaba eso ehengel ambugog ogna luwalna lofugum kofuni enaigba esenibi eba Ju heafgelni nihe enaig fena. Ehengel ogna awagna unehlagim Sekaraiam unehli. ");
INSERT INTO amn_n_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Afa luwalna afag esona og, “Mangofi, nawo Jonim unehli.” ");
INSERT INTO amn_n_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Afa ehengel ehem sihini og, “Nengelinai enaig unehlagba goh mo.” ");
INSERT INTO amn_n_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Afa ehengel ninga bulni wagfuiagim ahu awagim sahni og, “Amanim ne luwalba ounehla?” ");
INSERT INTO amn_n_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Afa sihini og osum mang fifiba keso enanai yi ginofe afa so ehe enaig ginofena og, “Ehena unehlagba Jon.” Afa so ehengel hugna onigiga fafna. ");
INSERT INTO amn_n_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Afa so Sekaraia piske ikagna mo wanwagenam eso Godna unehlagim fingife fukuna. ");
INSERT INTO amn_n_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Afa heafna kimbig wa nai mungwali enaigim nangunim embefeagini afa ena mo mungwali Judiana mug kimbig wa so guhkafna enam ikaminefeni. ");
INSERT INTO amn_n_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Afa mungwali el ena mom higiginim afa enaig sihiagini og, “Sohna luwalba so sumi yi ba ahanaig el fef?” Ati anwanafini Ainiyagna kifutigbi ehe ahgofuf. ");
INSERT INTO amn_n_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Afa enag luwalna awagim Sekaraiam Godna Sungwag ati ehem yuhwafenagenaba eso enaig mo sihina og; ");
INSERT INTO amn_n_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Nawo Godna unehlagim fingifi Israelna Ainiyagim ehe bog bigim heafna elim kwaganigim afa bigim piske wambug. ");
INSERT INTO amn_n_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Afa kifutig el mungo God Gishu wahiag eso ehe bigim piske wambuf. Afa sonag elbi eba ehe Devitna simbianiga. Devitba Godna gafugag el. ");
INSERT INTO amn_n_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Eso ati autunam Godna mo fi sihiaule elni mengig wa ena moba sihi wahiana. ");
INSERT INTO amn_n_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ena moba enaig esona og God bigim kwaganig eso angoluwag el i afa fagule el i ogna bigim ahanaig ahanaig esegon eso ehengel mas bigim enaig esegoni. ");
INSERT INTO amn_n_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Autunam God mo bigelni simbianigam sihi wahiani. Afa enaig esoni og ka nem afafenig afa kikeafna kifutig mo ka mas onigig etetini. ");
INSERT INTO amn_n_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Afa ehe bigelni simbianigam Abrahamim enag ini mo sihi wahianaba. Afa so yawa gaba ogna bigim gwenaig esen. ");
INSERT INTO amn_n_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Afa ogna bigim angoluwagna ninganai moehnam og so ma heafna gafugagim kikehli afa mas big embefi. ");
INSERT INTO amn_n_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Afa big higeg nofkikena ahuamine fifibi afa so big lahlag nihe wa afa afsug nihe wa Godna nofwa eseahufum. ");
INSERT INTO amn_n_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Afa ne kana luwal, afa nengigimba nem enaig seafa fif og sonag elbi eba mo fa sihiaule el God sisia nemug feg. Eba ne Ainiyagim gosunam ehena minam tohlakaf. ");
INSERT INTO amn_n_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Afa so enagba elim wagfufenugeiba so ma anwanafi ehena nalig afafeg God sawifegim amtakwalig nihem elni hugufatinim eso piske wambuf. ");
INSERT INTO amn_n_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Afa bigelni Godna afafenag nengigim nengigim fiaka. Afa enag elbi God Gishu wahiag elbi eba ofenaiba leana osu bugug lofug. ");
INSERT INTO amn_n_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Eba ehe ofwanai pe bonam afa el so sikifig wa auguia eba ati muhwa pigiegim ofesai eso enam afwambusug faif. Eba ehe enag olug efihlag mina gam wagfunif. ");
INSERT INTO amn_n_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Afa ena luwalba sumi pugu numbinam afa heafna sungwag gaba pugu kifutif afa so ehe pugunam bite bihig gam ikaf afa so nengigim mo Israel elim ambagwa pugunif. ");
INSERT INTO amn_n_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Enenam mahim Romna misog el Ogastas unehlag osugonfinibi ehe nihe mo mungwali elim kagahlani. ");
INSERT INTO amn_n_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Enaba yuwana. Misog el Kwirinius Siria provins wa gofnaba enenam unehlagba suguni. ");
INSERT INTO amn_n_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Eso mungwali ahanag ahanag kimbigim hwatiaginim piske heafgelni kimbig gam fahufena og so ma misog el ehengelni unehlag sugoni. ");
INSERT INTO amn_n_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Afa Josepba King Devit gofenaba ehgenaifena eso Nasaret Galilim wahianam Judiagam Devitna kimbig gam Betlehem gam ikana. ");
INSERT INTO amn_n_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Afa naso Maria i ahkana. Enag angwafigbi autunam ehem esu wahini. Misog el ogna eheningina unehlag buk wa fakan. Enenam Maria ati enugini. ");
INSERT INTO amn_n_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Afa gwenanai yi mahimsi Betlehem wa ahagag fenaba luwal gohugim ati meinifeafena. ");
INSERT INTO amn_n_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Noso fangonai luwalim fukwana eba angwam luwal afa ehem bulmakauna fane ahgag bokis wa fakanam lofugna fwahla wahiana. Enaigba esenaba eba mungwali lala el ati yuhwafeagena. ");
INSERT INTO amn_n_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Afa ena kimbig wanai sipsip nangwaghiawagig el ahu kimbig meigim sinaini sipsipim nangwaghiage ahufna. ");
INSERT INTO amn_n_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Afa Ainiyagna ofwanai el bona ehem puguni. Afa Ainiyagna nalig afwambusugni ehe ehengelim molu kugofakaniba afa ehengel hugna embefeagini. ");
INSERT INTO amn_n_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Afa so ofwanai el ehengelim enaig esoni og, “Nofe ne embefi. Sa higim ka nem lahlag mo obunig. Ena moba mungwali el so hugna sifakalif. ");
INSERT INTO amn_n_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Afa ohunag osuna Devitna kimbig wa angwafig mungo luwal fukwag afa ena luwalba mungwali nem piske wambf. Eba Ainiyag ehe fegim afa el God Gishu Wahiag Elim piske hefum wambugum. ");
INSERT INTO amn_n_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Afa so na enaig nanguf eso ne anwanafi eba kana mo inim feg. Ne nanguiba luwalim lofugna kikenaginim bulmakauni fane ahgag bokis wa fati wahif.” ");
INSERT INTO amn_n_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Afa mahim ofwanai el enaig mo sihi wahianaba afa so gwei ikagnam enaksag ofwanai el ofwanai apaigo ambugonam wanig agfohiafna ogna Godna unehlagim figifi. Afa so ehengel enaig esogona og, ");
INSERT INTO amn_n_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","God sisinai nemugna unehlagim fingifi. Eso ma bitenai el Godna membug wa olug efihlag wa guhkai. ");
INSERT INTO amn_n_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Afa mahim ofwanai el ofgam ahunaba afa sipsip nangwaghiawagig el hefum sihiaginim og, “Is ai nawo ahu nangui mang ehe Betlehem wa pugug. Ainiyag so bigim ena mo sihinig.” ");
INSERT INTO amn_n_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Afa eso ehengel ikagna ahuna. Ahu nangwagnibi Maria i Josep i ahagafnaba afa luwal mo bulmakauni fane ahgag bokis wa pegifni. ");
INSERT INTO amn_n_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Afa nangu wahinim eso moamo sihigoni ofwanai el so luwal mom sihini enam. ");
INSERT INTO amn_n_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Afa mungwali el ena mom higiginim hugunam onigwagiafafna. Sipsip nangwaghiawagig el so esinibi enam. ");
INSERT INTO amn_n_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Afa Maria ena mo mungwali fanam onigig gofna. ");
INSERT INTO amn_n_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Afa sipsip nangwaghiawagig el piske ahunam Godna unehlagim fingifini. Ehengel Godum sifakalini eso ehe enam mo higini afa nanguni afa ofwanai el so sihinibi enaig ena puguna. ");
INSERT INTO amn_n_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mahim kug yi gohug osuna ika awaienaba afag wanigina eso luwalna lofugum mo kufunim afa so Sisasim unehlini enaigba esenibi eba Ju heafgelni nihe enaig feg. Enag unehlagba mahimsi afagna atag wa feafnaba ofwanai el ati unehla wahiana. ");
INSERT INTO amn_n_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Enaigba pugunaba eba Josep i Maria i ikan Jerusalem wa Godna nalig lala pugunam eso ogna Ju elni nihem ahpahluku eso afsug ahfef. Afa luwalim ahwanibunam eso ogna Godum sis tuhlu ahfai. ");
INSERT INTO amn_n_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Enaigba sahfenaba eba autunam God enaig nihem fakani. Ena nihe enaig esona og, “Fangonai luwalim so afag yuwanam wanigag eba so ma enaig esogoi ohonaba Godna.” ");
INSERT INTO amn_n_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Afa so eheningi gaba gwenaig esahfena afa sambaga twafig Godum tuhlu ogna ahfai. Enaba Ainiyagna nihe mo ati enaig sihifena og so ma gamp sambaga me awai was sambaga me so ma enag tuhlu fai. ");
INSERT INTO amn_n_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Afa enanai yiba Simeon gafena. Enag Jerusalem wanai elbi eba lahlag el fenam Godum lotu fenakafnaba afa ehe mahimsi nengeakafna el so God Gishu Wahiag Elim og so ma Israel elim esenibi so ma olug efihlag wa augui. Afa Godna Sungwag Simeon nai yi gofenaba. ");
INSERT INTO amn_n_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Afa Godna Sungwag ehem enaig sihifena og, neba mas ikagnaba wahai eba el so God elim wambugum Gishu wahiag enam nangufe. ");
INSERT INTO amn_n_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Eso Godna Sungwag ehem olugim fingifenaba afa so Godna nalig lala gam ika saho gafnaba. Eso Sisasna awag i afag i Sisasim ahwanigina ahsahona enaigba esahfenaba eba ati nihe mo wa enaig mo gifini. ");
INSERT INTO amn_n_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Afa so Simeon eheningi muhwa pugunam luwalim fokwanam Godna unehlagim fingifukuna og; ");
INSERT INTO amn_n_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ainiyag autunam ne kam sihi wahianaba enaba inim pugug. Yawo kaba neana gafugag el so ma kam olug efihlag yi wahai. ");
INSERT INTO amn_n_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ati ka kikeafna nofna nangug mang so na esegba enaba kangelim wambug. ");
INSERT INTO amn_n_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Enaba ne numehiageg ambagwa wahiag. ");
INSERT INTO amn_n_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Afa enaba afwambagam elim afwambusug faig so ma anwanafi neana sawiegim eso ma Israelna elim unehlag fingifini. ");
INSERT INTO amn_n_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Sisasna awag i afag i Simeonna mom ahigina mahim enaig sihifeagof fenaba afa so eheningi hugna onigwag ahfegofena. ");
INSERT INTO amn_n_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Afa Simeon og God nem lahlafenif afa so Mariam sihina og, “Sa hig, sohna luwalba God Gishu wahiag eso enaksag Israel elim kwaganif afa eba enaksag elim mingnagim mo amtakwalig aitif. Afa mahim enaig el Godna onigigim wagfuiba eso el numb ehem moalampinagif. ");
INSERT INTO amn_n_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Mahim enaig esibi eso ehengelni meaganai onigig ambagwa puguamine fenugef. Afa enaig olug kinig ofenaiba naif neana olugim pifif.” ");
INSERT INTO amn_n_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Afa mo fa sihiaule angwafig ehena unehlag Ana enanai yi gofena. Afa ehena awagna unehlagba Fanuel afa Fanuelba Aser gofnaba ehgenai fena. Afa Anaba ati muhnafena. Ehena ligag wa ganaba ehe krismasba elegeg wa gohug enaig fena. ");
INSERT INTO amn_n_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Eso gwenai yia wa ehena ligagim mahim wahanaba eso ehe fwaimu eseakafna. Anaba eba 84 krismas enaig fena. Afa Ana mas Godna nalig lalam wahia ikana mo eba eheba gwese Godna unehlagim fingi fegufna. Afa ehe fane hwaiyunam afa sinaini i osuna i higeg Godna nalig lala beten wa fawof gofna. ");
INSERT INTO amn_n_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Afa so enenam ehe bonam luwalna muhwa pugunam eso Godna unehlagim fingi fukunam. Afa mungwali elim nenge agfo God Jerusalem elim wambuf eso enam luwalna mom sihina. ");
INSERT INTO amn_n_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ehengel enaig gafugag eseaginibi eba Ainiyagna nihe mo ati enaig sihi fe wahiana. Afa so Josep i Maria i Galili wa ika ahpugunam eso heafna kimbig Nasaret gam mo piske ahkana. ");
INSERT INTO amn_n_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Afa luwalba enaba ati nalig feagenam afa kifutigna afa anwanag lahlag enaksag wambugena afa Godna membug ehem gohna. ");
INSERT INTO amn_n_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Afa mungwali krismas so ikafnaba Sisasna awag i afag i Jersusalem gam Pasova buyis wa fakaf ahfegofena eba autunam so God Israelim eseniba eso lahlag augufena naso enag osunam onigifini. ");
INSERT INTO amn_n_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Sisas 12 pela krismas fenaba eso Jerusalem gamba wani fahufeahufna. ");
INSERT INTO amn_n_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Afa mahim enag buyis awai enaba eso Josep i Maria i piske heafna kimbig gam ahakafna. Afa Sisasba kwablog ofefnaba enaig Jerusalem kimbig gafnaba awag i afag i washu ahkana mas ehem anwana ahfena mo. ");
INSERT INTO amn_n_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Afa eheningi enaig onigig ahfena og eba mingnag elim atiba pahlukug, eheningi ati ahka mungo osuna ahfena. Afa eheningi Sisasna hihem fasahtigi ahfenam. ");
INSERT INTO amn_n_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Afa mas ahnanguna mo eso piske Jerusalem gam ahyisgi ahkana. ");
INSERT INTO amn_n_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Eheningi ahyisge gohun ikan sambaga mungo osuna fena. Ahyisge gohun ahnangonaba Godna nalig lala saho gafna ehe anwana elni mom mi afa misog elni mom mi higwagenam eso fasahtigife hiageaufna. ");
INSERT INTO amn_n_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Afa mungwali el ehena mom higinim afa sineminefini ehena anwanagim eso mo mungwag wahigi sahini ena gaba gwenaig esini. ");
INSERT INTO amn_n_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Afa awag i afag i bo ahnangonam olug hugunam fingi ahfenam afa afag esona og, “Luwal mangigim ne enaigba eseg. Eba ne ka mi nimbeafna awag mi olug kinig ne kam faigbi ka nem ahyisge ahbog.” ");
INSERT INTO amn_n_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Afa ehe wahigi sihini og, “Neaho kam ahyisge gohug? Enaigba mas ne anwana ahfeg mo, kaba atiasi kikeafna humuana lala ga?” ");
INSERT INTO amn_n_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Afa eheningi mas ena mogim anwana ahfena mo. ");
INSERT INTO amn_n_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Afa so Sisas piske pahlu kana Nasaret kimbig gam ahu enanai yi opukonam eso ehe higeg eheningina mungwali mom pahlukuni. Afa ehena afag mo mungwali enaig mom olug onigig wa fanam keahlana. ");
INSERT INTO amn_n_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Afa Sisas pugu kwamblo fenam heafna anwanag pugu hugunam lahla feagena. Afa so God ehem hugna membenagena afa el gaba gwenaig esini. ");
INSERT INTO amn_n_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Afa mahim 15 yia fenaba Taiberius Rom elni misog el fena. Afa Pontius Pailat eba distrik Judia gavmanna gosug el fena. Enenaba Herot distrik Galilim nangwaghiage gofna afa ehena sumineg Filip mo distrik Ituria mi afa Trakonitis mi enam nangwagehiagena afa Lisanias mo distrik Abilenem nangwagehiagena. ");
INSERT INTO amn_n_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Afa Anas i Kaiafas i eba prisni misog el ahgofena. Enenaba Sekaraiana leg Jon bite bihig wa gafna. Afa God Jonim mo faina. ");
INSERT INTO amn_n_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Afa so ma mungwali elim Jordan bu bug muhwa gohka enam sihinwageakai afa enaig esona og, “Sa ma olug wahigifinim, bu wa apaiyeiba afa so ma God ehengelni amtakwalig nihem hugufatini.” ");
INSERT INTO amn_n_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Afa enaigba pugunaba eba ati mo fa sihiaule el Aisaiana mo buk wa gofena. Ena mo enaig esona og; El mungo bite bihig wa mo sihiakaf afa ehe enaig esof og, ‘Ainiyagna mina ambafeaginim numwehiagi.’ ");
INSERT INTO amn_n_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Afa mungwali mog tutohiageakaiba so ma tafafakai so ma hugufagim fegim fuku gwenaig eseg. Afa mina kiapesegim so ma misosuf gi afa mina mas lahlafeg mo so ma numwehefi. ");
INSERT INTO amn_n_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Afa bitenai el mungwali so ma Godna gafugagim nangunim eso ehe bigim wambugum eseg. ");
INSERT INTO amn_n_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Afa eso el numb Jon nangum fambofena buwa apaiyegim afa Jon enaig sihifeni og, “Nengel giheana luwalig, God so ma nem tautig fai afa aman nem sihinigbi so na embemba ahuf? ");
INSERT INTO amn_n_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Afa ateamba ne inim olug wahigifigbi eba so ma nimbeafgelni nihem wagfui eba ati ne inim olug wahigifig. Nofeka nimbefum esogo, ‘Abraham eba kangelni simbianiga.’ Ka nem sihinig eba God ehe ohuna hunim eseiba eso Abrahamna simbianiga opuko agfohef. ");
INSERT INTO amn_n_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Afa mal ati li mog wa gi afa mungwali li so lahlag fug leg hwanigba, eba malna higfihinim suwi wa aitif.” ");
INSERT INTO amn_n_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Afa el Jonna mom higinim afa esogona og, “Ahnaig so ka esife?” ");
INSERT INTO amn_n_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Afa ehe wahigi sihini og, “El so sambaga lofugna fef eso ma ming mo aman so lofug hwainig feg so ma enam fai. Afa aman so fane hwainig feg ena gaba so ma gwenaig esenai.” ");
INSERT INTO amn_n_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Afa mingnag kig wambule el ambugog buwa apaiyofefnaba Jonim sahni og, “Tisa, ahanaig so ka esife?” ");
INSERT INTO amn_n_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Afa ehe wahigi sihini og, “Kig so na wambugbi eso ne gavmanna moaihwa wambufum nofena gwesim hilifi.” ");
INSERT INTO amn_n_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Afa ami gaba ambugog ehem sahni og, “Ka gaba ahanaig so ka esife?” Afa ehe sihini og, “Nofeka mingnag elim amtakwal hiaginim kig wambugoni, afa so nofeka mingnagim mungunim mwakwalogon so na nimbeafna kigim oniginim eso ne gwenaig yuhwa eseahufum.” ");
INSERT INTO amn_n_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Afa el enaigim nangunim olug fingi feskofenam afa enaig onigini og eba ohuna Jon me awai God Gishu Wahiag el me. ");
INSERT INTO amn_n_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Afa Jon piske wahigi sihini og, “Kaba buna nem esenig, afa el so sumi yi obo ena elbi eba kifutigni feg ehena kifutig kana kifutigim kwegfug gwesim ikag, kaba mang lahlag el mo na ka ehena mong lofug weba pigina. Eba ehe nem Godna Sungwagni afa suwina eso nem buwa aitif. ");
INSERT INTO amn_n_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Eba ehe savol ningana fanam eso bof afa ehe bonam hunisege mo wit yi nai wambuhiagenam eso wit mo wambinam heafna wit lala skofe afa hunisege mo wambinam suwi higeg lagig yi wahlaf.” ");
INSERT INTO amn_n_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon mahim ena mo sihinaba afa ena mo elni olugim fuku wasana. Ehe elim Godna lahlag mo sihinwageg gafugafena. ");
INSERT INTO amn_n_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Afa mahim Herot heafna suminegna angwagim Herodiasim fapuguf nagohun eso fana afa ahanaig ahanaig nihem gaba gwenaig esagena naso Jon ehem nunmuna. ");
INSERT INTO amn_n_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Afa so ena nangum Herot Jonim kalabus lala fa fati wahiana. ");
INSERT INTO amn_n_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Afa Jon mahimsi kalabus seg hwainig fiafnaba afa mungwali el buwa apaigona afa Sisas gaba gwenaig esena buwa pena. Afa buwa penam pugu betene gofenaba afa so of pigina. ");
INSERT INTO amn_n_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Afa mahim of pigi gofnaba Godna Sungwag gamp lofug Sisas nangum pe bonam afa higfufnaba Godna mengig heven wa enaig wagofna og, “Ne kana leg, ka nem hugna membenag, afa kana olug nem lahlafenag.” ");
INSERT INTO amn_n_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Afa so Sisas gafugafena enag ehena krismasba 30 enaig wa fena. Afa el enaig onigini og eba Josepna leg, afa Josepba Helina leg, ");
INSERT INTO amn_n_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","afa Heliba Matatna leg, afa Matatba Livaina leg, afa Livaiba Melkini leg, afa Melkibi Janaina leg, afa Janaiba Josepna leg, ");
INSERT INTO amn_n_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","afa Josepba Matatiasna leg, afa Matatiasba Amosna leg, afa Amosba Nahumni leg, afa Nahumbi Eslina leg, afa Esliba Nagaini leg, ");
INSERT INTO amn_n_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","afa Nagaibi Matna leg, afa Matba Matatiasna leg, afa Matatiasba Semenna leg, afa Semenba Josekna leg, afa Josekba Jodana leg, ");
INSERT INTO amn_n_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","afa Jodaba Joananna leg, afa Joananba Resana leg, afa Resaba Serubabelna leg, afa Serubabelba Sealtielna leg, afa Sealtielba Nerina leg, ");
INSERT INTO amn_n_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","afa Neribi Melkini leg, afa Melkibi Adini leg, afa Adibi Kosamna leg, afa Kosamba Elmadamna leg, afa Elmadamba Erni leg, ");
INSERT INTO amn_n_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","afa Erbi Josuana leg, afa Josuaba Elieserna leg, afa Elieserba Jorimna leg, afa Jorimba Matatna leg, afa Matatba Livaina leg, ");
INSERT INTO amn_n_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","afa Livaiba Simeonna leg, afa Simeonba Judana leg, afa Judaba Josepna leg, afa Josepba Jonamna leg, afa Jonamba Eliakimni leg, ");
INSERT INTO amn_n_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","afa Eliakimbi Meleana leg, afa Meleaba Menana leg, afa Menaba Matatana leg, afa Matataba Natanna leg, afa Natanba Devitna leg, ");
INSERT INTO amn_n_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","afa Devitba Jesini leg, afa Jesibi Obetna leg, afa Obetba Boasna leg, afa Boasba Salmonna leg, afa Salmonba Nasonna leg, ");
INSERT INTO amn_n_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","afa Nasonba Aminadapna leg, afa Aminadapba Atminna leg, afa Atminba Arnina leg, afa Arniba Hesronna leg, afa Hesronba Peresna leg, afa Peresba Judana leg, ");
INSERT INTO amn_n_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","afa Judaba Jekopna leg, afa Jekopba Aisakna leg, afa Aisakba Abrahamna leg, afa Abrahamba Terana leg, afa Teraba Nahorna leg, ");
INSERT INTO amn_n_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","afa Nahorba Serukna leg, afa Serukba Reuni leg, afa Reubi Pelekna leg, afa Pelekba Eberna leg, afa Eberba Selana leg, ");
INSERT INTO amn_n_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","afa Selaba Kainanna leg, afa Kainanba Arpaksatna leg, afa Arpaksatba Siemna leg, afa Siemba Noana leg, afa Noaba Lamekna leg, ");
INSERT INTO amn_n_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","afa Lamekba Metuselana leg, afa Metuselaba Enokna leg, afa Enokba Jaretna leg, afa Jaretba Mahalalelna leg, afa Mahalalelba Kenanna leg, ");
INSERT INTO amn_n_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","afa Kenanba Enosna leg, afa Enosba Setna leg, afa Setba Adamna leg, afa Adamba Godna leg. ");
INSERT INTO amn_n_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Afa mahim Godna Sungwag Sisasim yuhwafenagenaba eso Sisas Jordan buum wahianam eso el hwainig gam ikana. Eba Godna Sungwag ehe wanikina. ");
INSERT INTO amn_n_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Afa Sisas enanai yi ika ganaba eba fane neg hwainig ikan 40 osuna fena afa mahim enaig osuna awaienaba ehem bini hugna wahana afa so Satan ehem gihna. ");
INSERT INTO amn_n_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Afa ehe Sisasim enaig esona og, “Afa ne Godna leg fegba sona ohuna hunim esoiba so ma amba lofei.” ");
INSERT INTO amn_n_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Afa Sisas esona og, “Godna moba enaig esog, Afa faneba mungo mas elim nofkenagag fai.” ");
INSERT INTO amn_n_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Afa mahim Sisas enaig sihifenaba afa so Satan ehem sulufanam mug gam fuku wanikina ena mugba mungwanam fena. Enanai yi ehe mungwali bite i afa lahlag gawig i enam ikagna wagfunagena. ");
INSERT INTO amn_n_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Afa so Sisasim sihina og, “Ma ne kam mong kokini kwakwagenam kana unehlagim fingifeiba, eba ka so nem bite i gawig i mungwali faiba so na enam mungwali nangwagihagef, enaba kana feg. Afa amanim ka membenagba eba ka so ehem faif. ");
INSERT INTO amn_n_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ma ne kam mong kokini kwakwagena enaig eseiba eba ka so nem fai.” ");
INSERT INTO amn_n_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Afa Sisas wahigi sihina og, “Godna mo ati enaig sihifeg, So na Godum ahnai skaug fena eba naho neana Ainiyag eso ne ehem mungo lotu fena!” ");
INSERT INTO amn_n_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Afa ena mug ahwahianam pe Jerusalem gam ahkanam enanai yi Godna nalig lala wofugug sisyi nemug wa Sisasim washunam afa sihina og, “Ne Godna leg fegba eso ne sofuku pekai. ");
INSERT INTO amn_n_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Eba ati Godna mo sihig; Eba heafna ofwanai elim sihinibi eso ambugog nem ningana kikehli apaigohuf. ");
INSERT INTO amn_n_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Afa hun sig mas nem mong yi pifi eba ehe ati nem numwehefugu.” ");
INSERT INTO amn_n_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Afa Sisas wahigi sihina og, “Godna mo enaig sihifeg, Nofena Godna kifutigim gihna nimbiafna Ainiyagimba.” ");
INSERT INTO amn_n_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Afa Satan Sisasim ahanaig ahanaigim gihnagegim wahia ikagim mwakwalig nengego. ");
INSERT INTO amn_n_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Afa Sisas piske distrik Galili gam Godna Sungwagni kifutig yi ikana. Afa so Sisasna mom mungwali kimbig sihiageahuna. ");
INSERT INTO amn_n_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Afa ehe Ju elni nuwagig lala ika sahunam eso mungwali elim enanai yi wagfufenugeafnaba eso mungwali el ehem lahlagoni. ");
INSERT INTO amn_n_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Afa Sisas Nasaret kimbig gam ika puguna. Afa Nasaretba enaba ehe enanai yi numbina fena. Afa mahim nuwagig osuna pugunaba Sisas ika ehengelni nuwagig lala saho gofnaba. Afa ehe buhia gohnam eso ogna Godna mom suwigim. ");
INSERT INTO amn_n_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Afa so mo fa sihiaule Asaiana ginof finim ehem fainiba eso piginam suwigina. Ena moba enaig esona og; ");
INSERT INTO amn_n_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ainiyagna Sungwag kam bonag, afa gishu wahiagba eso ka ehena lahlag mo isug elim fa bonig. Enag ehe kam ningihiagba na koka kalabusinai elim mo sihinibi eso ma enanai yi wahinim opuko isug ahui. Afa koka ikanam nofseleni elim sihigonibi eso ma nofug bahia skofei ehe kam ningihiagba enag ka bo koka elni kinigim fafatini. ");
INSERT INTO amn_n_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ehe kam ningihiag kam og eso ma enaig sihifei og, Ainiyagna osuna ati pugug, og na heafna elim esinibi eso ma lahlag augufei. ");
INSERT INTO amn_n_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Sisas Godna moamo suwigi pe wahianam piske buk mo pwakafenam elim fainim eso ehe mo ika peganam afa mungwali el nuwagig lalanai Sisasim mungo nofna nangu fafna. ");
INSERT INTO amn_n_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Afa Sisas enaig sihifeni og, “Sohna mo Godna buk wa nai so na ati higig, yawoba eba inim pugug.” ");
INSERT INTO amn_n_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Afa ehengel ehem lahlagonim afa hugunam onigwagea fafna eso ehe lahlag mo sihinibi enam afa ehengel esogona og, “Ati big anwanafig sona elbi Josepna leg ehe, asegba so enaig moba yuhwa sihig?” ");
INSERT INTO amn_n_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Afa Sisas ehengelim enaig sihifeni og, “Ateaho ne sona moba fig eso ne kam sehif ena mo enaig esog, ‘Dokta so ma heafna eligim eseiba so ma lahlafei.’ Afa ne esogog, ati kam moaba higig mang so na Kaperneam wa ne eseg. Afa yawo ohuna nai yi gaba ne gwenaig esig.” ");
INSERT INTO amn_n_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Afa Sisas sihini og, “Inim ka nem sihinig, Godna mo fa sihiaule elni kimbig wanai ehengel mas ehena mom higi. ");
INSERT INTO amn_n_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Afa ka nem ini mo sihinig, yuwana so Elaija gofnaba enenaba osu kig gohna ikan ikan sambaga mungo yia fena afa ika enwesog wa gohug was fena. Osuba gohnaba eso ehengelni mungwali bite bini nalig puguni afa enenaba Israel wanai angwafig enaksag ehengelni ligabugug ati pigie skofenaba. ");
INSERT INTO amn_n_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Eso God mang Elaijaba Israel angwafigim ningihinig mo eba heafa Sarefatim Saidon kimbig muhwa naim ningihianig. Afa ehe angoluwag angwafigim ligag ati wahanag enam ningihianag. ");
INSERT INTO amn_n_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Afa enena Elaija gofnaba enenaba Israel el enaksag enehna feasaina afa mas amanim mo ena gihba wangene fena mo awai afa eba Naman ehe afwambanai el Sirianai mungo he enaigba fena.” ");
INSERT INTO amn_n_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Afa nuwagig lalanai el mungwali yi ena mom higinim afa hugna olug kakage skofena. ");
INSERT INTO amn_n_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Afa so Sisasim kimbig meigim fi ningihini. Ehengelni kimbigba mug wa gifni afa so ehem mugam wanig ahuna ogna plau fati. ");
INSERT INTO amn_n_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Afa so ehe ehengelim olyinai hwatinam pugu ika kana. ");
INSERT INTO amn_n_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Sisas Kaperneam gam pekanam distrik Galili wa gafna. Enanai yi nuwagig gohug osuna higeg feahufna enaba sefig de Sabat afa so Sisas enanai elim wagfufenugena. ");
INSERT INTO amn_n_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Afa ehengel ehena mom higinim olug fingife skofena ofenaiba amunai anwanag el wagfufenig. ");
INSERT INTO amn_n_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Afa enanai el mungo bo nuwagig lala gafna ena elbi mwaifig amtakwalig simbagahlaule enag hugna enaig esona og, ");
INSERT INTO amn_n_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Hei, Sisas Nasaret wanai ne bog ahanaig kam ogna esen? Enaigba kam si noka amtakwale aiti? Ati ka anwanafig neba afsug el Godna ne bog.” ");
INSERT INTO amn_n_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Afa Sisas ehem ninmunamine fenam afa esona og, “Mwahlai lifenam sohna elim wahianam ika.” Eso mwaifig amtakwalig elni nihinai hugofu akafenaba el mo bite wa elni usmuiag wa pena afa mas elbi enaba amtakwaligna mo. ");
INSERT INTO amn_n_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Afa mungwali el enam nangunim embefeaginim afa hefum sihiagini og, “Hai, sohnaba ahanaig mo mahim ofenaiba anwana el kifutig nafeg naso mwaifig amtakwaligim esonagba afa so elni nihinai hugofug ikag.” ");
INSERT INTO amn_n_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Afa so ehengel mo mungwali kimbig sihiageahuna Sisas so elim esenaba enam. ");
INSERT INTO amn_n_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Afa Sisas ena nuwagig lala mo wahianam pugu ikanam Saimonna lala sahu kana. Afa ena lalaba Saimonna kuwag gihna gifni ehena elig hugunam nalbafeagenaba eso ehengel Sisasim sihini og so ma ehem kweagfui. ");
INSERT INTO amn_n_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Afa so Sisas ika ehem muhwa kuluhlanam eso gihim kifutig mona esonaba afa so gih angwafigni nihinai hugofu kanaba eso enag angwafigbi ikagna bihiana ika fane ehengelim tuhluni. ");
INSERT INTO amn_n_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Afa mahim osu penaba enaigna el heafgelni hihem gihna wanambugona Sisas nangum. Afa so Sisas mungo mungoagim ningana tutuhlunugeniba eso mungwali ehengelni gih wagine feasaina. ");
INSERT INTO amn_n_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Afa Sisas mingnag elim mwaifig simbagahlaulem gwenaig esenibi eso mwaifig ehengelni nihinai hugofuhia ahuaminefeni afa mwaifig elni nihinai hugofuhia ahuamine ofefnaba ehengel enaig esogona og, “Ne Godna Leg!” Afa Sisas ninimuhiagenam afa kweni og, nofeka moaba wagim afa ehengel ati anwanafini sona elbi God Gishu Wahiag el. ");
INSERT INTO amn_n_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Sisas leana gubi yi ena kimbig wahianam el hwainig gam ikana. Afa el yisigiahunam nangunim kwini og, ese masa ehengelim wasani ikaf. ");
INSERT INTO amn_n_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Afa Sisas enaig sihifeni og, “Kaba kawo Godna bog meg mom mingnag kimbig wa gaba sihiage. God kam ningihiagba enag ka bog koka enaig gafugafe.” ");
INSERT INTO amn_n_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Afa Sisas distrik Judiam ikanam nuwagig lala saho mo sihiagena. ");
INSERT INTO amn_n_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Afa mahim Sisas ika Genesaret bu bug yi gofnaba afa el numb ehem nangum ambugog ogna Godna mom higim afa so ambugonam ehem muhwa wahigi fakanam kikegenagini. ");
INSERT INTO amn_n_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Afa Sisas sambaganigi botim bu blug yi nangwagnaba el sawugim kikiageaguhun wahinim fufwalam bu wa kigiage ahufna. ");
INSERT INTO amn_n_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Afa so Sisas ika fuku Saimonna bot wa peganam Saimonim sihina og, aubo sahu peganam botim susum plau plau fefkuiba so ma ohuna nai yi wesig wahia ikai. Afa Sisas bot wa gafnaba elim wagfuwagenam. ");
INSERT INTO amn_n_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Afa so Saimonim sihina og, “Gwesim ma bot mo ikai eso ne i nimbiafna hihe i fufwala mo ahfatinam sawug ahwambugum.” ");
INSERT INTO amn_n_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Afa Saimon esona og, “Ainiyag ati kaba sinaini yisigeafuhug ehegepuseg si ambafeskofig mas ka sawugba fufwalanaba wambug mo, eba ati ne esog eba ka esife.” ");
INSERT INTO amn_n_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Eso gwenaig esini mahim fufwala fatinibi sawug fufwala mengig wa puguna ogna fufwala kwagfo. ");
INSERT INTO amn_n_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Eso eheningi ming el sambagam ningafuei ahfeni og so ma kam kwaganig. Eso eheningi ming bot ahbonam ahkwaganaba eso sawug mo fufwalana finim eso sambaga bot wa kokofeawagniba memtog wa puguiag ahfen. Afa sambaga bot enag kinig ogna bu megam pe ahka. ");
INSERT INTO amn_n_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Afa so Saimon Pita Sisasna kig muhwa kwakwage penam og, “Ainiyag ika kaba mang lahlag el mo, kaba el amtakwalig.” ");
INSERT INTO amn_n_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Enaigba esonaba eba mungwali sawug so wambini enam nangunam sineminefena afa ehena hihe gaba gwenaig esini. ");
INSERT INTO amn_n_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Afa Saimonna hihe Jems i Jon i Sebedini legningig gaba gwenaig ahfena. Afa Sisas Saimonim sihina og, “Nofe ne embefe, yawo ne sawug wambug afa nengigim ne gwenaig esef elim gaba ne kam nangum wanbof.” ");
INSERT INTO amn_n_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Afa so ehengel ahu bot mo fohlunim afa heafgelni mungwali gawig mo hwatinim afa so Sisasim pahlukuna. ");
INSERT INTO amn_n_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Afa ehe ika mungo kimbig wa gafnaba afa el mungo enanai yi enehna bo Sisasim nangunam eso mong kokini kwakwagenam nofbosug mo bite gam fisah penam Sisasim enaig sihifena og, “Ainiyag ateamba ne membegba eba so na kam lahla fefati.” ");
INSERT INTO amn_n_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Afa Sisas ningana tuhugufnaba esona, “Ei, ka membeg, nem so ma lahlafei.” Mahim Sisas enaig esonaba eso enag enehba gwei ikagna awaienaba eso elbi enaba lahlafena. ");
INSERT INTO amn_n_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Afa so Sisas ehem kifutig mo faina og, “Nofe ne ena moba elim sihin, magofi eba isug ikanam prisim nimbeafena eligim wagfunim afa so Godum sis tuhlu fai enaigba ati autunam Mosesna mo sihi wahiana eso ma el anwanafi ena gih ati lahlafeg.” ");
INSERT INTO amn_n_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Afa so Sisas elim ese fatinaba ena mo gwesim mungwanam el kimbig ikaminefenaba eso higinim ambogoafena afa ambugog mo higifni afa gihnam lahla feitifeafna. ");
INSERT INTO amn_n_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Enaig eseitife wahianam afa so elim mo wasanfna betenegim el hwanigam ikafnam beteneafna. ");
INSERT INTO amn_n_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Afa enenam Sisas elim mo sihinwageafnaba afa elim gihnam lahla feitifeafna. Enag elbi Farisi el i afa nihe mo anwanag el i enag Jerusalem kimbig afa distrik Galili kimbig afa Judia enanai ambugog minefe gohkafnaba. Eso Godna kifutig Sisas i ahgohfnaba eso gih elim lahla feitifena. ");
INSERT INTO amn_n_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Afa mingnag el ming elim ninga mog lihlignam isgof bog wa fi obuguna ogna Sisas nangum lala megam saho ugfo. ");
INSERT INTO amn_n_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Afa mahim el mungwali kimihli fakanaba gihiginim. Eso lala wofusgim fukwali okuhunam enanai yi lala wofusum tutunim afa so elim mo isgof sime weana kihlinim eso Sisas gofnaba ena mina fatini. ");
INSERT INTO amn_n_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Afa Sisas ehengelni olug onigigim anwanafenim eso enaig esona og, “Hihe, ati ka neana amtakwalig niheaba fafatinag.” ");
INSERT INTO amn_n_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Afa nihe mo anwana el i afa Farisi el i ena mom higinim hugna wagni og, “Sohna elbi ogna Godna kufeg wa gohnam eso enaig esefim. Afa mas el bihigba enaigba esi eba heafa Godna gafugag mungo he.” ");
INSERT INTO amn_n_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Afa Sisas ehengelni onigigim anwanafenim wahigi enaig sihifeni og, “Nengel ne ahanaig ahanaig onigig nafeasaieg? ");
INSERT INTO amn_n_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Afa ka enaig sihifeba, ‘ati ka neana amtakwalig moba fafatinag’, eso mas ne enam anwanafe ini me awai awai me. Afa ka enaig sihifeba, ‘bihia kug fanam ika’, eso ne enam ati anwanafe ini feg me awai awai me. ");
INSERT INTO amn_n_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Afa kog so na anwanafi kaba Inim El kifutig ohuna bite wa yuhwafeg amtakwalig nihem fafatiagimba.” Afa Sisas ninga mong lihlig elim nofna nangunam enaig esona og, “Ka nem sihinag bihia nimbeafna kug fanam lala gam ika!” ");
INSERT INTO amn_n_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Eso ena elbi ikagna bihianam mungwali elni nofwa eso Godna unehlagim fingi fukunam so heafna lala ga mo ikana. ");
INSERT INTO amn_n_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Afa mungwali el Godna nalig kifutigim nangunim afa embefeaginim eso Godna unehlagim fingi finim afa so enaig esogona og, “Yuwaho enaigba puguba big nangug.” ");
INSERT INTO amn_n_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Afa so sumi yi Sisas ikan nangunaba el kig wambule saho kig wambug lala gafna. Ehena unehlagba Livai. Sisas ehem unenam og, “Aubo kam pahlu bu.” ");
INSERT INTO amn_n_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Afa so Livai heafna mungwali gawig mo hwatiagenam eso pugu Sisasim pahlukuna. ");
INSERT INTO amn_n_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Afa Livai ikanam Sisasim heafna lala buyisenaba. Eso kig wambule el i afa mingnag amtakwalig el i fini enag mungwali ahgafafnaba. ");
INSERT INTO amn_n_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Afa Farisi el i afa nihemo anwana el i enag hugunam wagnim Sisasna pahlukuiag elim sihinigoni og, “Mangigim ne kig wambule el mi afa amtakwalig el miba wanahgag?” ");
INSERT INTO amn_n_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Afa Sisas wahigi sihini og, “El so gih hwainig feg eba mas ika doktaba nangui, afa el so gihna feg ena mungo he eba so ika doktaba nangui. ");
INSERT INTO amn_n_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Afa gwenaig ehe ka gaba ka mang bog lahlag elim mungo sulfuah mo, amo eba kog kawo amtakwalig elim gaba sulfu.” ");
INSERT INTO amn_n_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Afa el Sisasim enaig sahna fini og, “Afa Jonna pahlukuiag el higeg enaig esig, fane mo kwegwagigim eso beten mo fig. Afa Farisini pahlukuiag el gaba gwenaig esig. Afa neana pahlukuiag el mo eba fane i bu i ahgagig.” ");
INSERT INTO amn_n_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Afa so Sisas sihini og, “Eba el so enaig esfafif angwafigbi fagim eso buyis segim afa heafna hihem wanahgagim. Eso enenamba ehengelim mas fane kweni. ");
INSERT INTO amn_n_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Afa mahim angoluwag el ambugog angwafig fag elim wanigiahugba eso ehena hihe fane kwegig.” ");
INSERT INTO amn_n_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Afa Sisas waskwes mo enaig sihifena og, “Eba fiteg lofug enaba ati kofo gohugba mas el enaba yawonai lofugim kofanam eso kofwagim kagunam eso kweli. Enaigba eseiba eba yawonaim amtakwalef. Mang mungo lofug mo. ");
INSERT INTO amn_n_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Afa mas el yawonai wain bugba fanam autunai meme lofug waba sugfoi eba enag meme lofug kofunam eso wain bug bite wa sugfof ena meme lofugba eba amtakwalef. ");
INSERT INTO amn_n_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Afa el so ma enaig ese ena wain bug yawonai so ma fanam yawonai meme lofug wa sugfoi. ");
INSERT INTO amn_n_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Afa el so autunai wain bug negim afa yawonai wain bug mo kusigim afa og autunai wain bugba lahlafeg.” ");
INSERT INTO amn_n_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Afa enenam mahim nuwagig osuna pugunaba, Sisas heafna pahlukuiag elim wanka wit aso wa wansaho wanikafnaba. Afa ehena pahlukuiag el mo wit fug pwatinim ningana sunpaniaginim mahim alfieg mo hugfuhia ahunaba eso ahgana. ");
INSERT INTO amn_n_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Afa Farisi el enam nangunim afa esogona og, “Sohnaigba mas lahlafeg mo enaig osunaba mas esi. Eba Mosesna nihe mo enaig esog nofeka enaig osunaba gafugafi. Ahnaig esegba so na enaigba esig?” ");
INSERT INTO amn_n_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Afa Sisas wahigi enaig sihifeni og, “Mas ne Devitna moaba suwigi mo? Devit so enaig esena, enenam ehem afa heafna hihe fena eso ehengelim bini pigina. ");
INSERT INTO amn_n_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Afa so Devit ika Godna lala sahonam amba Godum mwao fakini enag fa enanam heafna hihem fainibi eso ehengel ahgana. Afa mas sona lalanaiba mungunim elbi ahgai eba heafa pris mungo he so ena lalanaiba ahgai.” ");
INSERT INTO amn_n_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Afa Sisas sumi yi mo ehengelim sihini og, “Kaba Inim El nuwagig osunaba awag feg.” ");
INSERT INTO amn_n_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Afa mahim ming nuwagig osuna pugunaba Sisas ika nuwagig lala sahonam elim mo sihiagena. Enanai yiba afa el nihiginai ninga lihligna gafna. ");
INSERT INTO amn_n_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Afa nihe mo anwana el i afa Farisi el i enanai yi auguiafnaba Sisasim nofna nangu fafena og ma ateamba ena elim enaig osuna lahlafe afatifiba awai awai me afa og naso ehena minam fahigenaginim eso ehem sehini. ");
INSERT INTO amn_n_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Afa Sisas ati ehengelni onigigim anwanafenim afa so ninga lihligna elim sihina og, “Sa bihiana ohuna nai yi olyi bo gohum.” Afa so enag el bihianam gohna. ");
INSERT INTO amn_n_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Afa Sisas sihini og, “Ka nem ahsahtigi bigelni nihe moba ahanaig feg, enaig osunaba so big lahla nihe fig me awai big amtakwalig nihe fig me? Afa enaigba big elim kwaganig me, awai big amtanafegonig me?” ");
INSERT INTO amn_n_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Afa Sisas mungwali elim nofna fahigiagenam ninga lihlig elim sihina og, “Nimbeafna ninga fa susnifeafo.” Afa so enag el mahim gwenaig esenaba eso ehena ninga piske lahlafena. ");
INSERT INTO amn_n_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Afa nihe mo anwana el i afa Farisi el i hugna olug kakageaginim hefum sihiagini og, “Ahnaig so big Sisasimba esinif?” ");
INSERT INTO amn_n_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Afa so Sisas enenam betenegim mugam fukukana enanai yi Godum sinaini beteneawan ikan ikan si ambafena. ");
INSERT INTO amn_n_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Afa mahim osu ati opugufenaba enaigna ogna heafna pahlukuiag elim awamoni mahim ambugonaba eso 12 pela el mo kwefi hwatinam eso ehengelim Aposel unehlag hwatina. ");
INSERT INTO amn_n_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Afa enag 12 pela elni unehlagba eba Saimon ming unehlag Pita, afa ehena sumineg Andru afa Jems, afa Jon, Filip, Bartolomyu, ");
INSERT INTO amn_n_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","afa Matyu, Tomas, Jems Alfiusna leg, afa Saimon sefig Selot, ");
INSERT INTO amn_n_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","afa Judas Jemsna leg, afa ming Judas Iskariotna leg sona elbi angoluwag elim mwauni. ");
INSERT INTO amn_n_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Afa Sisas mugam wanwahianam bite tafagam pe wankana. Afa enanai yiba el numb nuwagigna distrik Judia kimbig wanai afa Jerusalem wanai afa gwenanai bu bug yi nai kimbig Tair i afa Saidon i enag ambugog guhkafna. ");
INSERT INTO amn_n_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ogna Sisasna mo higifibi afa ehem og ma kam gihnam lahla feitifei eso Sisas mwaifig simbahlaulem elim lahla feitifena. ");
INSERT INTO amn_n_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Afa mungwali el enaig esini ogna Sisasna eligim ningana tuhufibi eso ma ehena kifutig pugunam mungwali gihim plau fatini. ");
INSERT INTO amn_n_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Sisas pahlukuiag elim nofna fahigihiagenam enaig sihifeni og; Amangel eso enaig onigif, kaba lahlag el mo God so kam kweagfui, afa enag el so ma sifakalifi afa so ma Godna bog megba saihoi. ");
INSERT INTO amn_n_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Afa nengel so yawo nem bini pigi so na sifakali eba ne yuhwafif. Afa nengel so na wewatini auguia eba se sifakali nengigimba eba ne titigena auguiafuf. ");
INSERT INTO amn_n_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Afa nengel so na Inim El pahlukuiaba eba ming el nem olug kakagegonif afa nem amtakwalig mo faigonam, afa nem mas fatigonif afa nem sihigonif og sona el eba amtakwalig, ma nem enaigba esegonibi eba se sifakali. ");
INSERT INTO amn_n_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Afa ma ateamba amtakwalig nihena nem esofegonifbi eba so na sifakalinim afa hugunam afigigi. Sa hig, nalig mungwag nem faif eba heven wa nem nengenawo. Afa autunam ehengelni simbianiga Godna mo fi sihigulem elim gwenaig esegoni. ");
INSERT INTO amn_n_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Afa nengel gau nubni el, nasabanig, eba ati ne bitenai mungwag fig afa mas ne mingba fi. ");
INSERT INTO amn_n_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Afa el so na fane ahgagigbi nem yuhwa faskofeg, nasabam, enaba numwehifibi nengigimba bini nem pigif. Afa el so na titigena auguia, nasabanig nengigimba eba ne wewatini auguiafuf. ");
INSERT INTO amn_n_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Afa nasabanig mungwali el so nengelni unehlam fingifegonig eba so numwehifibi autunam ehengelni simbianiga enaig niheba fini mwakwal mo fi sihiaule elim gwenaigba esegoni. ");
INSERT INTO amn_n_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Afa Sisas enaig esona og, “Sa hig, so na enaig esi, angoluwag elim membegonim afa el nem olug kakagenug eso ehem lahla fehiagi. ");
INSERT INTO amn_n_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Afa so mingnag el enaig esogof og, God so ma nem amtakwale aiti afa nawo so na ehem lahlag mo fai. Afa aman nem so amtakwalig hiagig eso ne Godum betenenibi so ma God ehengelim afafenim afa olug efihlag fai. ");
INSERT INTO amn_n_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Afa aman so nem angmug wa pouf afa so na ming angmug nihna afa aman so neana nihinai lofug huguafanaf eba so na ming lofug gaba wahiana. ");
INSERT INTO amn_n_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Afa el so mungwali nem sahigonif og kam osum mang fai afa so na faim. Afa so aman neana mang fanaf nofena sihina og so ma kana piske fai. ");
INSERT INTO amn_n_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Afa ahanaig ahanaig nihe so na membig ne og so ma kam esegoni, eba so na mingnag elim gwenaig esegon. ");
INSERT INTO amn_n_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Afa el nem membegonigba afa ne enaig elim mungo membegonig, enag niheba eba isug feg. Afa amtakwalig nihenai el gaba og el kam membegonig ka ehem gwenaig esegonig. ");
INSERT INTO amn_n_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Afa el nem lahlafe hiagigbi afa ne enaig elim mungo lahlafe hiagig, enag niheba eba isug feg. Afa amtakwalig nihenai el gaba gwenaig nihe fig. ");
INSERT INTO amn_n_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Afa elim so na ismunagim faigogba afa ne og so ma kam mungwag faigoi, enag niheba eba isug feg. Afa amtakwalig nihenai el gaba gwenaig minafig. Ehengel enaig esig og so ma kam mungwag faigoi. ");
INSERT INTO amn_n_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Afa ka nem sihinig so na angoluwag elim membegonim afa lahlafe hiagi. Afa enaig elim ismunagim faigonam afa nofena enam mungwag nem faigogim onigim. Afa ne enaig esigba, eba nalig mungwag nem faif, afa eba ne Godna luwalig feasaif. Afa Godba, el so ehem mas fatinag ena mi afa amtakwalig nihenai el mi enam gaba lahlafenig. ");
INSERT INTO amn_n_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Afa so na elim afafegon osa ati nengelni awag heven wanai gwenaig eseg elim afafenig.” ");
INSERT INTO amn_n_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Afa Sisas enaig sihifeni og, “Nofe ne elni nihem fahigenaginim afa so elim amtakwalig mo faigo, mangofi, masa God nem mungwag gwenaig esenif. Afa nofe ne elni nihem pigaupi eba God nem gwenaig esenaf. Afa so na elni amtakwaligim isug wahiaiba eba God nem gwenaig esenaf. ");
INSERT INTO amn_n_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Afa so na elim mang gawig faigoiba so ma God nem gwenaig eseni. Eba numwehe lahlag kwefihiagenam eso neana wula wa memtowa pugunam bite wa kokofehia pekam minefef. Afa elim so na enaig yuhwa faigog eba God nem gwenaig yuhwa faif.” ");
INSERT INTO amn_n_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Afa Sisas enaig waskwes mo sihini og, “Ateaho so nofseleni elbi ming nofseleni elim minaba fawagfunaf, amo, eba awai eba naba ahkanam mungwali bu me wa ahpef. ");
INSERT INTO amn_n_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Afa skulinai luwal mas tisa lofba fei eba numweheg skuligim eso tisa lofba feg. ");
INSERT INTO amn_n_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ahnaig esegba so na og ka nilitena nof wanai hunisege fafatina afa nimbeafena nof wanai sumil mo mas ne onigig mo. ");
INSERT INTO amn_n_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Mangigim so na enaig esog, nilite ka neana nof wanai hunisege fafati, afa ne mas sumil nimbeafna nof wanai nangug mo. Ne sohnaig elbi eba ne mwakwalule el. Afa ne yuwana mo nimbeafna nof wanai sumil fafatinam ma neana nofug lahlafeba eso ne nengigim nimbeafna nilitena nof wanai wesig hunisege mo fafatina.” ");
INSERT INTO amn_n_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Afa Sisas enaig esona og, “Li figetni mas fug amtakwalig luwoi, afa li bangafeg mas fug lahlag luwoi. ");
INSERT INTO amn_n_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Afa yuwanaba el li fugim nangugim anwanafig feg lahlag me awai amtakwalig me. Afa el mas yuhwi fug pwatigimba usieg minaba ahui afa mas baf fug pwatigimba kwalamp minaba ahui. ");
INSERT INTO amn_n_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Afa lahlag el lahlag onigigna fegim eso lahla nihe feageg. Afa amtakwalig el amtakwalig onigigna fegim eso amtakwalig nihe feageg. Afa ahanaig onigig so goh enag ehe ambagwa mo sihig.” ");
INSERT INTO amn_n_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Afa Sisas enaig sihifeni og, “Mangigim ne kam enaig safaiba fig og, Ainiyag, Ainiyag afa eba ateaho so na kana moaba pahluhug? ");
INSERT INTO amn_n_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Afa aman so na ka nanguba bonam kana mo higinam afa so pahlukuf eba enaig elbi el so lala nimbagim enaig esfafif. ");
INSERT INTO amn_n_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Mime mungwanam kwagegim eso sumil mo wambug aitigim hun mo sumil megam aitia fukuag mengig wa wahiagim afa simen mo enena waheg titig wahiag afa mahim bifwatbi sahigba mas ena lalaba toafui eba ati kifutig goh. Enaba eba el ehe kifutig lala nimblag wahiag. ");
INSERT INTO amn_n_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Afa so aman kana mo mas higigim pahlukug mo enaig elbi lalaba onimbaba eba mas mimeba mungwanam koi afa mas sumilbi hun aitinam titi eso eba ena lalaba mas kifutig gofi. Afa mahim bifwatbi sahigba eba sona lalaba ati tofu bambuhia pegi.” ");
INSERT INTO amn_n_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Sisas elim mo sihi wahianim eso ika Kaperneam kimbig gam sahu ikana. ");
INSERT INTO amn_n_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Afa enanai yiba amini misog el heafna gafugag elim gihna faka auguiafna. Eheba 100 amiim nangwaghiageule. Enag hugna heafna gafugag elim membena. Enag gafugag elbi ati wahagim meini ofefna. ");
INSERT INTO amn_n_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Afa amini misog el higinaba og Sisas ati bog enanai yi ga eso Ju elni misog elim ningitigina og ma ahu Sisasim sihinibi so ma bo ehena gafugag elim lahla fefati. ");
INSERT INTO amn_n_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Afa so ehengel ahu Sisasnai opukonam Sisasim kifutig mona sihini og, “Hai, sona elbi lahlag el ehem so kweagfu. ");
INSERT INTO amn_n_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Eba ehe bigim Ju elim membenigim afa nuwagig lala kangelni nimbanig.” ");
INSERT INTO amn_n_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Afa so Sisas wankana muhwa wan opugufnaba afa amini misog el heafna hihem sihiagenam ningitigina og, ma ahu gwesim Sisasim sihini ehengel ahu enaig esogona og, “Amunai luwal, mangigim ne ehegepusig bo og, kaba mang lahlag el mo na ne kana lala gamba bo. ");
INSERT INTO amn_n_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Afa og, kaba mang lahlag el mo na ka bo nem sihina isug mo bihig sihiba so ma kana gafugag elbi lahla fei. ");
INSERT INTO amn_n_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ka enaig sihifeg kagaba ka so misog elim ahnai skaufen. Ka gaba ati soldiaba feg enag kam ahnai skaufinig. Afa so ka ming elim sihinaf aubo eba ehe bof. Afa ka kikeafna gafugag elim sihinaf ohnam gafugafe eba ehe ika esef.” ");
INSERT INTO amn_n_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Sisas ena mom higinam ehena olug fingi fena afa el eso ehem pahlukuna enam sihini og, “Ka nem inim sihinig mas ka amanim Israel wanai elimba olug onigi nalig feg enaig elbi nanguna mo.” ");
INSERT INTO amn_n_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Afa el so amini misog el ningitigina enag piske lala gam ahuafnaba nanguni gih elbi enaba ati pugu lahlafena. ");
INSERT INTO amn_n_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Afa managig hwainig Sisas Nain kimbig gam ikafnaba afa so pahlukuiag el apaigona afa mingnag el numb apaigona enag Sisas wan ikana. ");
INSERT INTO amn_n_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Afa wan ikana kimbig bogna mengig muhwa wanpuguafnaba afa el ehgam elim wahagim fabugohna enag opukefeagini. Afa el numb afagim wanig ambugona, ehena awagagba ati wahana afa enag wahag elbi eba gwenag mungo fena. ");
INSERT INTO amn_n_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Afa so Ainiyag enag angwafigim nangunam hugunam afafenam afa enaig sihifena og, “Nofeka ufwe.” ");
INSERT INTO amn_n_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Afa so Sisas ika muhwa gohnam eso wahag elim gig simem ningana tuhuna mahim el gwese ofuhiafnaba. Afa so Sisas enaig esona og, “Luwal kwablog ka nem osihina, so bihia.” ");
INSERT INTO amn_n_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Mahim enaig esonaba eso enag elbi bihianam mo wagenaba afa so Sisas piske afag nangum ningihiana. ");
INSERT INTO amn_n_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Afa mungwali el Godna kifutigim nangunim embefini. Afa so Godna unehlagim fingi finim afa enaig esogona og, “Godna mo fa sihiaule el nalig bigim olyi pugunig afa God ati bog heafna elim kwaganigim.” ");
INSERT INTO amn_n_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Afa so mungwali el distrik Judia ahwa minefenam ena mom sihiageahuna. Sisas so wahag elim ese fatina enam mom. ");
INSERT INTO amn_n_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jonna pahlukuiag el Jonim sihinagini, Sisas so mungwali eseagenaba enam. ");
INSERT INTO amn_n_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Afa Jon heafna pahlukuiag elim sambaganigim awamonim eso ogna Sisas nangum ningitigi eheningi so ma ika opukenam Sisasim ahsihinai og, “Neaho so Jon sihi wahianaba naho ne bo awai naiba ming el me kagelbi nengenafo?” ");
INSERT INTO amn_n_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Afa ika ahpugunam eso enaig esohona og, “Eba Jon buwa aitiag el kam ningitigiba na ka ahbog ehe nem sahna og, neaho so God nem ningihiagim sihi wahianam ena me awai ming el me?” ");
INSERT INTO amn_n_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Afa so enenam Sisas enaksag elim ahanaig ahanaig gihnam lahla feitifeafna afa nimbasa amtakwalig elni nihinai wambuningitigi feafna, afa el numb nofug kuhlag nofug bahia skofena. ");
INSERT INTO amn_n_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Afa Sisas wahigi sambaganigi elim enaig sihifeni og, “Sa piske ahkanam Jonim ahsihina mang so na mungwali ahnanagug afa ahigig, afa nofug kuhla el bahia skofeg afa el mong lihli fegna bihiakag afa enehna lahla fiahsaig afa ang tetini ati mo higig afa melig pigieg el pigiagafeg, afa gawig hwainig el Godna lahlag mo higig. ");
INSERT INTO amn_n_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Afa el so kam oniginig ehengelni olug onigiba eba kifutig agfohiefuf. Enaig elbi so ma sifakali.” ");
INSERT INTO amn_n_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Afa mahim sambaganigi piske Jon nangu ahkanaba afa so Sisas elim sihini ehe Jonim enaig esona og, “Autunam ne bite bihig wa ahunam eso ne Jonna mo higini. Ne ahanaig elim nanguni? El enaig pos lofug fufei petwa fakafefugu, enaigim ne nanguni me? Amo, Jonba mang enaig mo. ");
INSERT INTO amn_n_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Mangwalfigim ne membig ahu nangug? Ne membig nangug el lahlag nemug lofug go me? Jonba mang enaig mo. Eba el lahlag lofugnaba lala lahlag wa ga. ");
INSERT INTO amn_n_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ahnaig esegba ne ahug? Ne Godna mo fa sihiaule elim ne nangug me? Ei, Jonba enaig el. Ka nem ini mo sihinig ohuna elbi mingnagim mo fi sihifule elim gosinig. ");
INSERT INTO amn_n_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Enag elbi autunam Godna Buk ati sihi wahiana enaba God esog; Sahig, kana mo fakuwiag elim ka ningihiaiba. Afa so ehe Godna Gishu Wahiag elim gosunim eso mina numwehiage kafe eso ma el ehem olug onigini.” ");
INSERT INTO amn_n_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Afa Sisas esona, “Ka nem ini mo sihinig Jon buwa aitiag el mungwali elim autunaim pugu gosinig. Afa amangel so wetiklug saiyeg Godna bog megam enaba Jonim gosunig.” ");
INSERT INTO amn_n_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Afa kig wambule el i afa gwenanai amtakwalig el i ena mo higinim afa so ehengel og Godna mina eba yuhwafeg. Afa ehengel ati Jonna ninga wa bu wa apaiyeg. ");
INSERT INTO amn_n_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Afa Farisi el i afa nihemo anwana el i Jonna ninga wa buwa apaiyegim mas esig mo. Eso ehengel kusig Godna sawiegim pahlukuiagim. ");
INSERT INTO amn_n_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Afa Sisas esona og, “Afa ka yawoba elni niheba oku opugun fibi eba so ka ahanaig waskwes mo sihif? Eba ahanaig el mahim? ");
INSERT INTO amn_n_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Afa ofenaiba luwal fane sugwahog wa auguiaba afa moawag seafahba mingnag luwalim unegonigim afa enaig esogona og, ‘Kagelbi afag i wong i guwagihbi afa nengel mas ahfei afa kangel wewatoahba afa nengel mas wegoi.’ ");
INSERT INTO amn_n_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Afa yawonai el enaig luwal lofug enaig esig, Jonba mas wain bug i afa fane i neagena mo eba ogna Godna unehlagim fingi fe afa el esogona og ‘Nimbasa amtakwalig ehem saho gohna!’ ");
INSERT INTO amn_n_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Afa mahim ka Inim El bogba afa ka bu i fane i wanegba afa ne enaig esogog, ‘Sa nangu enag elbi bu i fane i ati hugunam waneg. Afa ehe kig wambule el mi afa ming amtakwalig el mi wanaga.’ ");
INSERT INTO amn_n_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Afa elni nihe Godna onigigim pahlukuba eba ambagwa puguf enaig niheba eba yuhwafeg.” ");
INSERT INTO amn_n_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Afa Farisi el mungo Sisasim unenam ogna fane ahga afa so Sisas ehem ningi ikanam eso fane ehena lala ahga fafnaba. ");
INSERT INTO amn_n_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Afa mina angwafig ena kimbig gafna ehe Sisas enag lala gam higinam eso sanda hun botolna fanam eso obuna. ");
INSERT INTO amn_n_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Afa ehe Sisasim nombna pahlukuiafnaba afa ehena nomb mo Sisasna mong yi apaigonaba eso ehe heafna wapogni titehiagenam afa so Sisasna mogum kikehlanam kikige fana afa so sanda bug mo mongim susulenagena. ");
INSERT INTO amn_n_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Afa Farisi el so Sisas i ahagafna enag ehem nangunam enaig oniginagenam og, “Afa sona elbi ateamba mo faule el nemug fegba eba so angwafigni nihem anwanafei eso ehem ningana tuhunaba enam. Afa sonag angwafigbi eba amtakwalig nihe feageaka.” ");
INSERT INTO amn_n_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Sisas ati ehena onigigim anwanafenam afa esona og, “Saimon, ka membeg soka nem mo sihina.” Afa Saimon esona og, “Ei, tisa sesei.” ");
INSERT INTO amn_n_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Afa so Sisas ehem enaig esona og, “Sambaganigi el kig elni ahwambana ena mo sihina og, ming elbi 100 kig enaig fana afa ming elbi eba 10 kig mungo fana. ");
INSERT INTO amn_n_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Afa eheningi mas mungwag ahfaina mo afa enag el so kig faig eheningim sihini og, mangofi ka gwesim wahiag. Afa so na onigig aman mahim ehemba hugna membenag?” ");
INSERT INTO amn_n_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Afa Saimon wahigi Sisasim sihina og, “Eba aman so numwehenag.” Afa Sisas esona, “Ei neana onigig yuhwafeg.” ");
INSERT INTO amn_n_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Afa Sisas wahigi angwafigim nangunam Saimonim sihina og, “Sa ohunag angwafigim nangu. Ka neana lala gamba bonaba mas ne ka bu faina mo mungom sugimba. Afa sonag angwafigbi eba heafna nombna kana mungom sufagim afa wapogni mo nobum kana munginai titeageg. ");
INSERT INTO amn_n_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Afa mas ne kam kikige fana mo ka bog ma yawo pugugba ohunag angwafig kana mongim kikigeafag. ");
INSERT INTO amn_n_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Afa mas ne kam wel bug na misogim susulenagena mo. Afa ohuna angwafigbi eba sanda bug fa bugum enena kana mungom susulenageg. ");
INSERT INTO amn_n_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Afa ka nem sihinag, so nangu sona angwafigbi kam hugna membenag enaba wagfug God ati ehena enaksag nihe amtakwaligba fafatinag. Eso big anwanafi afa aman so amtakwalig nihe wesig esegba eso God fafatinag enag elbi ehena membegba eba wesig feg.” ");
INSERT INTO amn_n_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Afa so Sisas angwafigim enaig sihifena og, “Ati ka neana amtakwalig niheba fafatinag.” ");
INSERT INTO amn_n_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Afa el enanai yi mungwali wahe auguiafnaba fane ahgag sime wa, ena mom higinim hefum sihiaginim afa og, “Sohna elbi aman mahim naso amtakwalig nihem wambaitifehug?” ");
INSERT INTO amn_n_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Afa so Sisas enag angwafigim enaig sihifena og, “Nimbeafna olug onigig ati lahlafeg afa yawaba eba ati ne God i ahfeg neana olug soma afahlana gofi.” ");
INSERT INTO amn_n_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Afa Sisas managig hwainig elni kimbig wa fapuguf akafnaba elim Godna bog meg mom sihinagiakafna. Afa heafna 12 pela pahlukuiag elim mungwal wangoh minefeafna. ");
INSERT INTO amn_n_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Afa mingnag angwafig gaba Sisasim pahlukuna. Enag angwafigbi autunam so Sisas ehengelni nihinai nimbasa amtakwaligim wambu ningitigifeni afa gihim lahlafeni. Enag ehe esini, ehengelni unehlagba Maria Makdala kimbig wanai. Eheba autunam Sisas elegeg wa gohug nimbasa amtakwalig ehena nihinai wambu ningitigina. ");
INSERT INTO amn_n_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Afa mingba Joana fena afa Susana fena, afa mingnag angwafig apaigona enag Sisasim pahlukuna. Afa Joanaba Kusana angwag, enag elbi Herotna lalam gosu fahigeule fena. Afa sonag el angwafigbi heafgelni gawigba Sisas mi afa pahlukuiag el mi kwagani. ");
INSERT INTO amn_n_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Afa mungwali kimbig el ambugog minefenam Sisasnai yi nuwagignaba eso Sisas waskwes mo sihini og, ");
INSERT INTO amn_n_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“El enaig eseg kon kug aso wa aitiageg afa mahim aitiage kagba afa mingnag mo mina wa apaiyeg. Afa so el mongni pigafugba afa so twafig mo ambugog apaiyegim wambugafig. ");
INSERT INTO amn_n_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Afa mingnag mo hungisigig yi apaiyegim ikagna puguiageg. Eba bite mas bitekolna feg mo. Afa mahim osu pugu pukogba eso aftukuhla skofegim afa so melig mungwali pigiageg. ");
INSERT INTO amn_n_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Afa mingnag mo usieg weg amtakwalig wa apaigogba afa so usieg nahlum wahe puguiagegim eso ehem sagfa fakag. ");
INSERT INTO amn_n_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Afa mingnag mo lahlag bite wa apaiyegim fug leg skofeg. Enaig 100 fug leg skofeg. Sisas enag waskwes mo sihi wahianam afa so esona og, aman anginaba eba so na higi.” ");
INSERT INTO amn_n_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Afa pahlukuiag el ambugog Sisasim sihini og, “So na kam waskwes mog mom sihin.” ");
INSERT INTO amn_n_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Afa ehe wahigi sihini og, “God enaig membeg nengel so na anwanafi enag Godna bog meg nihe mas autunam ambagwa puguna mo. Afa ka mingnag elim waskwes mo sihig; Eso ehengel yisigig yisigig afa mas nanguig mo afa hig higig afa mas anwanafig mo.” ");
INSERT INTO amn_n_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Afa Sisas enaig esona og, “Ohuna waskwes mog moba enaig eseg, kon kugba eba Godna mom wagfug. ");
INSERT INTO amn_n_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Amangel so Godna mo higigim afa mas pahluhug mo enaba naho ofenaiba kon kug lofug mina wa apaiyeg. Afa God mahim ena mo elni olug yi aitinugeba afa el amtakwalig Satan bogim ena moba wambinig afa Satan enaig onigig fe og, masa Godum olug oniginibi afa God ehem wambf. ");
INSERT INTO amn_n_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Afa kon kug so hungisigig yi apaiyeg eba enaig eseg el Godna mo higigim ikagna sifakale fag. Afa so kon bigag mas numwehe pekag mo eba gohugum afa amtakwaligim awaieg. Eba enaig eseg eba el Godum oniginagim afa mahim mingnag el ehem kinig i afa nunimu mo i faigbi eba ehena olug onigig tigefu pef enaba onigig wesigfeg. ");
INSERT INTO amn_n_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Afa kon kug usieg weg wa apaiyeg eba enaig eseg el Godna mo higigim afa heafna gagim onigigim. Afa ehe hugna kigim onigkahba og na ahanaig ahanaig gawigim opuguiage. Afa na so enaig onigig bogim ehem kike fakagba mas fug luwoi. ");
INSERT INTO amn_n_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Afa kon kug so lahlag bite wa apaiyeg eba enaig eseg el so Godna mom higigim afa heafgelni lahlag olug onigig wa hugunam kehligim eso pahluhug eba naho so ehengelni nihe pugu lahlag feg.” ");
INSERT INTO amn_n_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Afa Sisas enaig esona og, “El mas wiba gafanam sime skaubi kumoahlai eba awai. Eba heafa gafagim sime sisyi fohlugba eso el enam nangugim afa so ambugog lala megamba saiyeg. ");
INSERT INTO amn_n_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Afa ahanaig ahanaig gawig so saiyeg meagam gohka eba ambagwa puguia minefef. Afa enag meagam kumo wahiag enaba eba ambagwa puguiba eso mungwali el enam anwana fif. ");
INSERT INTO amn_n_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Afa mo so na higi ena mo numwehifibi afa amangel so anwanafi eba God ehengelim gwesim hilifenif, afa amangel so anwana awaienig afa ehe enaig onigifig kati wesig anwanafig eba God enaig onigigim ehengelni fafatinif.” ");
INSERT INTO amn_n_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Afa ming nanam Sisasna afag i nilite i ogna ambugog Sisasim nangui afa el numb nuwagigena Sisasim kagu fakinibi. ");
INSERT INTO amn_n_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Afa so mingnag ambugog Sisasim sihini og, “Nana afag i nilite i ambugog meigim agfohieba ogna nem nangui.” ");
INSERT INTO amn_n_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Afa Sisas wahigi piske enaig sihifeni og, “El so Godna mom higigim pahluhug eba naho kana afag i nilite i ba feg.” ");
INSERT INTO amn_n_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Afa ming nanam Sisas heafna pahlukuiag elim bot wa wan ofkofnaba og, “Na kwegam malgim ahu” eso ahuna. ");
INSERT INTO amn_n_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Afa bot wambu wambukuafnaba Sisasba ati nongini afa ahuan bu musuag wa apukoafnaba afa so bifwat nalig sahbona botim wahigi wahigi fefafnaba afa bu bot megam figfna. Eba gwena awaie skofegim ofena. ");
INSERT INTO amn_n_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Afa so pahlukuiag el Sisasim ilafunim sihini og, “Ainiyag Ainiyag! Yawo bigim goh ati awai ofe.” Afa so Sisas bihianam bifwatim kwenaba afa so bifwat gweyi tigeafuna. Afa bu uleule awaiena. ");
INSERT INTO amn_n_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Afa so Sisas ehengelim enaig saheni og, “Ahnaig esegba so na enaig embebeba nafig enaigba nengelni olug onigigba wesig feg.” Afa ehengel Sisasna kifutigim nanguni embefeagini. Afa hugunam onigwagi fafnaba afa hefum sihiagini og, “Sohna elbi eba aman mahim naso bu mi bifwat mi kwenigbi eso ahtigeafog.” ");
INSERT INTO amn_n_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Sisas heafna pahlukuiag elim Gerasa kimbig ika wan puguna. Ena kimbigba Galili buum tigeaugugum ika gifni. ");
INSERT INTO amn_n_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Afa Sisas wan ikan bot mo fohlu wan gofnaba afa el mungo ena kimbig wanai bo ehem puguni. Ena elbi nimbasa amtakwalig esenaginibi eso heafna nihi lofug hugfuoaiti feagenam ika bitekfe wa gikafna. ");
INSERT INTO amn_n_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Afa so Sisasim nangu eyiunam bo Sisasna mong muhwa penam hugunam enaig esona og, “Sisas ne kifutig Godna leg, ne ahanaig kam esofena? Mas esi ne kam nofeka amtakwalig aiti?” ");
INSERT INTO amn_n_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Afa mahim enaig esonaba eso Sisas nimbasam fenugena og, “Sa ma elim wahinim ahui.” Afa sona elbi el higeg numwehefufna mahim kifutig wena kikenagi fakifnibi afa eba nimbasa amtakwalig esenag gifinibi eso we mo kukoiti fefnam eso pugu bite bihigam ikafna. ");
INSERT INTO amn_n_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Afa so Sisas ehem sahna og, “Nana unehlagba aman?” Afa og, “Kaba ami.” Ena mogba eba enaig eseg ehena nihi yi enaksag nimbasa amtakwalig saho gohna. ");
INSERT INTO amn_n_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Afa enag nimbasa amtakwalig Sisasim embefini eso hugna esofini og, “Nofe ne kam tautig kimbig megam ningitigi.” ");
INSERT INTO amn_n_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Afa enaksag tata okwe yi mug wa ahgagi agfo. Afa nimbasa amtakwalig enaig sihififni og, “Eba so na kam tatagam ningitigi.” Eso Sisas gwenaig esena. ");
INSERT INTO amn_n_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Afa ehengel elni nihi nai opukonam eso ahu tatana nihi yi saigonamba afa so tata fapisofe fwalgona bu wa apaigo mungwali pigi kumoahlana. ");
INSERT INTO amn_n_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Afa tatam nangwaghiagig el enam nangunim kimbig gam embem ahunam enanai yi ena mo sihiageahuna. ");
INSERT INTO amn_n_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Afa mungwali el ambugog Sisas nai yi opukonam ena elim nangunibi ati lahla fenam lofug aitiagenam Sisasna mong muhwa gafnaba mo wangeneg wagofna. Ehengel enam nangunim embefeagini. ");
INSERT INTO amn_n_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Afa el enaigim nangunim mo sihiageahuna Sisas so elim lahla fefatina. Yuwana so nimbasa amtakwalig ehena nihi megam saiyenam esenagini ena elbi ati pugu lahlafena. ");
INSERT INTO amn_n_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Afa mungwali el Gerasa distriki nai Sisasna kifutigim oniginim embefeaginim. Sisasim kifutig mo sihini og, “Ohuna bite wahianam piske ika.” Eso Sisas ehengelim hwatinam ika bot wa fukunam piske ikana. ");
INSERT INTO amn_n_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Afa Sisas akafenaba el so Sisas lahla fefatina enag Sisasim sahna og, “Sa big ahkai.” Afa Sisas ehem onigihiafna enaig esona og, ");
INSERT INTO amn_n_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Piske nimbeafna kimbig gam ikanam so na ena mo sihinuge God so nem kweagfug ena mom.” Eso gwenaig esena. ");
INSERT INTO amn_n_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Sisas piske bu meigim ehgam mangig ikafnaba. Afa mungwali el ehe nangum sifakaligna ambugog gohna. Enaigba esinibi eba so ehem nengenafan. ");
INSERT INTO amn_n_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Afa nuwagig lala nai misog el bona, ehena unehlagba Jairus. Enag bo Sisasna mong muhwa, mong kokugna kwakwage penam Sisasim kifutig mona sahna og so ma ehena lala gam ikai. ");
INSERT INTO amn_n_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Afa ena elbi luwal naini mungo fena, afa ena luwalna krismasba 12 enaig fena. Enag ati wahagim meiniofefna. Afa enaksag elim Sisas wan ikafnaba, minaba kagwo fakana. ");
INSERT INTO amn_n_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Afa angwafig mungo enanai fena. Enag angwafigbi wahigehlana afa higeg esefkufna. Enaig esenaba 12 pela krismas ena. Afa ehena mungwali kig doktam faifinibi afa mas aman ena gihimba tige fakana mo, awai. ");
INSERT INTO amn_n_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Afa enag angwafigbi Sisasna masigim bonam lofug angsa boagim tuhna. Mahim enaig esenaba ehena wahigehlag gweyi awaiena. ");
INSERT INTO amn_n_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Afa Sisas enaig sahna og, “Aman kam ninganaba otuhug?” Afa mungwali el esogona og, “Siseime, siseime” afa Pita esona og, “Amunai, eba mungwali el nem mug yi pugunag!” ");
INSERT INTO amn_n_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Afa Sisas esona og, “Eba mahim kam ningana tuhugba, afa kana kifutig gweyi hugofug kag eba kati anwanafeg el kam tuhug.” ");
INSERT INTO amn_n_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Afa enag angwafig ati anwanafena ehe ambagwa olyi gofna eso kiafigig ehem ofefnaba eso mungwali elni nofwa bonam mong kokugna kwakwagena nof bosug mo bite gam Sisasna kig muhwa fisihli penam eso esona og mang ehe esegba eso kana gihimba ikagna awaieg. ");
INSERT INTO amn_n_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Afa Sisas ehem sihina og, “Angwafig, ati ne kam olug oniginaba nem piskeg lahla feg eso ma neana olug efihlag gofi.” ");
INSERT INTO amn_n_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Afa Sisas mahimsi sihiagofnaba afa Jairusna gafugag el bona Jairusim sihina og, “Ati neana legba wahag, nofe ne amunai elimbi kinig fai.” ");
INSERT INTO amn_n_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Afa Sisas ena mo higinam afa so Jairusim sihina og, “Nofena kinigfam so na kam olug onigina eba sona luwalba neana lahla fef.” ");
INSERT INTO amn_n_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Afa so Sisas enag misog elni lala gam ikana. Afa ika lala opukonam afa lala megam asaigofnaba enaksag elim mo afwambawa wasanam eso Pita na, Jon na, Jems na afa awag i afag i ahfena enag lala megamba saho ahuna. ");
INSERT INTO amn_n_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Afa el ena lala nai luwalim afafinim wewatinaufna afa Sisas sihini og, “Nofeka wewatona eba mas wahag mo eba isug ehe nongi.” ");
INSERT INTO amn_n_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Afa el ena mo higinim afa titige watona og, eba ati ini wahafeg. ");
INSERT INTO amn_n_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Afa so Sisas luwalna ningam kikehlanam eso enaig esona og, “Luwal bihia.” ");
INSERT INTO amn_n_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Afa so luwalna sungwag piske bo sigeagenam eso bihiana. Afa so Sisas esoni og fane ehem fai. ");
INSERT INTO amn_n_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Afa so awag i afag i olug mungo ahwagofenaba Sisas sihini og, “Ahanaig so pugugba nofeka elim ahsihin, magofi.” ");
INSERT INTO amn_n_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Sisas pahlukuiag elim awamonim kifutig faini og, so ma nimbasa amtakwalig mi afa gih el mi lahla fetifif. ");
INSERT INTO amn_n_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Afa ogna ningitigiba soma ahu Godna bog meg mo sihif afa gih elim lahla fetifif. ");
INSERT INTO amn_n_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Afa enaig sihifeni og, “Ne ahu ofefiba nofeka nimbeafgelni gawig wambug ahu, moni i, mingnag nihinai lofug i, fane i, wula i, afa agat enena mina ikag enaig wambugu. ");
INSERT INTO amn_n_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Afa ne ahana kimbig waba opukonam eso ne mungo lala ahu auguiafim mahim manageiba eso ne ena kimbig mo wahinim afa so na ming kimbig mo ahu. ");
INSERT INTO amn_n_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Afa mahim ena kimbig wanaiba nem sulfug hwanigba eso ne ena kimbigba wahiyi ahu ofefiba so na bite moginai mo titeagenim hwatinim eso ne ahu goh. Eso ma enam anwanafi eba ehengel amtanafig.” ");
INSERT INTO amn_n_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Afa so pahlukuiag el gwenaig esini mungwali kimbig ahuaminefifnibi Godna mo sihifinim afa gih elim lahla feitififni. ");
INSERT INTO amn_n_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Afa mahim Sisas enaig gafuga feagenaba Herot gavmanna misog el ena mom higinam hugunam onigwaginam. Afa mingnag og, Jon buwa aitiag el bite kifenai piskeg bihiag. ");
INSERT INTO amn_n_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Afa mingnag og, Elaija piskeg pugug. Afa mingnag og, mo fi sihiaule el enana mungo autunai piskeg bite kifenai bihiag. ");
INSERT INTO amn_n_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Afa Herot misog el enaig esona og, “Jonba ati kana gafugag el kasuni higefakana afa sona elbi aman mahim, afa ka higigba ehena gafugagba eba enmunafeg”. Afa so ehe ogna Sisasim nangu. ");
INSERT INTO amn_n_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Afa pahlukuiag el piske ambugog Sisas nai yi opukonam eso sihinagini gafuga so ahu feagini enam. Afa Sisas mingnag elim mo hwatinam heafna pahlukuiag mo sulfu Betsaida kimbig wan ikana. ");
INSERT INTO amn_n_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Afa mahim Sisas wan ikanaba afa mungwali el ehem sum pahlukuna opukonaba Sisas ehengelim sifakalinim eso Godna bog meg mo sihinugenam afa gih elim lahla feitifena. ");
INSERT INTO amn_n_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Afa mahim osu pegim ofefnaba Sisasna pahlukuiag el ambugog ehem sihini og, “Osuba ati ope gwese ohnaina elim ningitigi mine feiba soma ahu heafnai yi aska minefenam aso nai fane yisgiagi, ohuna nai yiba bite bihig wa big auguia.” ");
INSERT INTO amn_n_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Afa Sisas esona og, “Amo, nengel ehe so na faneba faigo.” Afa ehengel enaig esogona og, “Kangelbi enaksag faneba awai eba afawa pugufeg amba feg afa sambaganigi sawug fog feg. Afa neaga kam og ahunam mungwali elim fane wlamugon.” ");
INSERT INTO amn_n_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Afa eba 5,000 el enaig fena afa angwafig i luwal i mas enaba suwigigni mo. Afa Sisas pahlukuiag elim sihini og, “Ahu sihigonibi so ma 50, 50 enaig augu feakai.” ");
INSERT INTO amn_n_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Afa so pahlukuiag el gwenaig sihi fegoniginibi eso gwenaig augu feakana. ");
INSERT INTO amn_n_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Afa so Sisas afa wa pugu feg amba wambina afa sambaganini sawug fog wambtina eso of gam ninofi fegofnaba afa so Godum lahlag onam eso amba kukosko fena afa sawug fog tutosko fena eso pahlukuiag elim fainibi afa so mimagegonigni. ");
INSERT INTO amn_n_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Afa so ehengel ahgawagin mahim yuhwa feskofenaba ena mo 12 pela sob yi sobyifeagini. ");
INSERT INTO amn_n_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Afa mungonagim Sisas beten ofefnaba afa so heafna pahlukuiag el ambugonaba afa Sisas sahini og, “Afa elbi ahanaig esogog, ka mo aman mahim?” ");
INSERT INTO amn_n_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Afa ehengel wahigi sihini og, “Eba mingnag enaig esogog og, Jon bu wa aitiag el, afa mingnag og, Elaija, afa mingnag og, mo fa sihiaule el autunai bite kifenai piskeg pugug.” ");
INSERT INTO amn_n_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Afa Sisas ehengelim sahtigina og, “Nimbeaba ahanaig onigig nafig.” Afa Pita wahigi sihina og, “Ne Kraist God Gishu Wahiag El.” ");
INSERT INTO amn_n_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Afa Sisas heafna pahlukuiag elim kifutig mo faini og, nofena enaig mo aman elim sihini. ");
INSERT INTO amn_n_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Afa enaig esona og, “Kaba Inim El nalig kinig fafe. Afa so misog el i amunai pris i afa nihemo anwana el i kam mas fatinim eso tigifatibi afa so ka sambaga mungo osuna piske buihiaf.” ");
INSERT INTO amn_n_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Afa Sisas enaig sihifeni og, “Afa aman kana pahlukuiag elbi ofefiba eba ehe mas hefum onigi eso ma ehe higeg li katigeg wa wahagim numwehenam eso ma kam sum pahlu boi. ");
INSERT INTO amn_n_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Afa aman so onigig, heafna nofkikena gag nalig fenag eso ogna heafum gwese gofum eba enaig el mas inim nofkikena gagba fai. Afa aman kam pahluku obofiba eso ma heafna nofkikena gagba wahiaiba eba eso ehe higeg nofkikena gag fafe. ");
INSERT INTO amn_n_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Eba mas lahlafeg mo afa el mungwali bitenai gawigim wambugba eso hefum awaief. Afa mungwali gawig mas sohnaig elim nofkikena gagba fai. ");
INSERT INTO amn_n_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Afa aman so kam i afa kana mo mi ahwanefe afa enena mahim eba Inim El heafna nalig afwambusugni kifutigni bonam eso ehe gaba sohnaig elim ahwanefenaf. Enag afwambusug i kifutigba eba mungwalofug Awagna afa of wa nai elni. ");
INSERT INTO amn_n_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ka nem inim sihinig mingnag el yawo so na agfohie eba mas nem pigi eba ne Godna bog megba nanguf.” ");
INSERT INTO amn_n_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Afa mahim kug yi gohug osuna enaig wa ofefnaba Sisas Pitana Jonna afa Jemsna mug gam fuku wan ikana ogna enanai yi betene. ");
INSERT INTO amn_n_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ehe ika beten naufnaba afa ehena nofbosugba enmuna fena afa ehena fatiag lofugba hugunam busug nemug fena. ");
INSERT INTO amn_n_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Afa ikagna Moses i Elaija i ahpugunam Sisasim ahwani ahwagofna. ");
INSERT INTO amn_n_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Afa eheningiba Godna nalig afwambusugugni ahbona ahsihiagofna Sisas so mang Jerusalem wa fenam eso wahaf afa ehena wahagba Godna mom ambagwa opuguf. ");
INSERT INTO amn_n_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Afa sambaga mungo elbi noftuta feasainaba non askana. Askan bigiagafef Sisasna afwambusugugim nanguni mahim Moses i Elaija i ehem ahwani gofna. ");
INSERT INTO amn_n_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Afa mahim eheningi Sisasim ahwahia ahagofnaba. Pita enaig esona og, “Tisa nawo ohuna nai yi auguiafim lahlag kagel so sambaga mungo sangwali lala nimbagi, nem Mosesim afa Elaijam.” (Pita enaig sihiba fenaba eba ehena mo mas mog fena mo.) ");
INSERT INTO amn_n_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Afa mahim Pita ena mo sihiagofnaba eso lango afwambusug pe bonam sagfa skofenaba ehengel embefeagini. ");
INSERT INTO amn_n_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Afa ena lango waba mo God wagofna og, “Sohna el kana Leg kana gafugagim gafugafegim ka gishu wahiag. Eso ne ehena mo higim.” ");
INSERT INTO amn_n_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Afa mahim mo lagig awaienaba nangunibi Sisas mungo gofna afa pahlukuiag el mas ena mo sihiagini mo eso nanguni enam. ");
INSERT INTO amn_n_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Afa Sisas ming osuna ena mug mo wahinim apaigo ambugoguhna. Eso ehe wan bonaba afa el numb ehem mina wa wambini. ");
INSERT INTO amn_n_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Afa enanai yi, el mungo Sisasim unenam og, “Amunai el ka nem asahna so na kana luwalim nangu kana mungohe feg. ");
INSERT INTO amn_n_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Higeg wuwag ehem simbigahla esefku kiafigig fefigim afa memp mimewug wesig fefig afa unena gohminefefig. Afa so ehem hugna amtakwalefag afa mas ehem ikagna wahiai. ");
INSERT INTO amn_n_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Afa ka neana pahlukuiag elim sihinigbi ehengel ahu esinigbi mas lahla feg mo.” ");
INSERT INTO amn_n_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Afa Sisas wahigi enaig sihifena og, “Ahanansi nagim mahim ka nem wan gafiba eso ka nengelni kinigbi fa gofif. Afa ne mas onigig mo nengelni olug onigig i afa nihe i mas yuhwafeg mo. Sa osum luwalim wani bu.” ");
INSERT INTO amn_n_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Afa mahim ena luwal bona Sisasna muhwa pugunaba eso wuwag luwalim ese fatinaba bite wa penam kiafigig aitiagifnibi eso Sisas wuwagim fenagenam luwal mo lahla fefatinam piske awagim nangum ningihiana. ");
INSERT INTO amn_n_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Afa mungwali el Godna nalig kifutigim nangunim sineminefiageni. Afa enam hugunam onigahufna Sisas so enaig eseagenaba enam afa Sisas heafna pahlukuiag elim sihini og, ");
INSERT INTO amn_n_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Sa ohuna mo numwehe higim, eba Inim Elim okunam mingnag elni ningana wahif.” ");
INSERT INTO amn_n_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Afa God ena mom meagam kumoahla gufna eso pahlukuiag el enanam mas numwehi enag mog mom anwanafini mo afa ehengel Sisasim sahnigim embefini. ");
INSERT INTO amn_n_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Afa ming enanam pahlukuiag el hefum flafihiagini og, aman so gosuf. ");
INSERT INTO amn_n_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Sisas ati ehengelni onigigim anwanafeni eso ehe luwalim suguafa bu olyi wani gofenaba. ");
INSERT INTO amn_n_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Afa so pahlukuiag elim enaig sihifeni og, “Aman so na kam oniginam ohuna luwalim kweagfuiba eba naho kam ninimwehiafag eba humuanim gaba gwenaig esenag ehe so kam ningihiag. Eba el wetiklug unehlag hwainig nengelnai olyi go enaba naho goseg elbi ofe.” ");
INSERT INTO amn_n_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jon Sisasim sihina og, “Amunai, ka nangugbi el mungo neana unehlag wa nimbasam ningitigi feageg. Afa eba mas bigim pahag kana mo enag ka kwinig.” ");
INSERT INTO amn_n_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Afa Sisas ehengelim sihini og, “Nofena kwini eba mang angoluwag mo eba nengelni hihe.” ");
INSERT INTO amn_n_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Afa God Sisasim heven gam wanikagim ati meiniofefnaba afa so Sisas kifutig onigig kikehlanam ogna so Jerusalem gam mo ika. ");
INSERT INTO amn_n_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Afa so ehe elim gof ningitigina og ma ahu Samaria kimbig ninimweheagif. ");
INSERT INTO amn_n_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Afa ena kimbig wanai mas Sisasim sawiyifi heafgelni lala gam wanigahuna mo. Afa ati anwanafini og eba Sisasba Jerusalem gam ikaf. ");
INSERT INTO amn_n_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Afa sambaganigi pahlukuiag el Jems i Jon i Samariana nihem ahnangwagnam Sisasim ahsahna og, “Ainiyag ne ahanaig onigig feg ne membegba ka so winibi so ma suwi heven wanai pe bo sona elim laskofei.” ");
INSERT INTO amn_n_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Afa Sisas wahigi sambaganigi elim fenugena. ");
INSERT INTO amn_n_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Afa so enanai mo wahinim ming kimbig gam ahuna. ");
INSERT INTO amn_n_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Afa Sisas mingnagim wankafnaba afa el mungo enaig esona og, “Mungwali kimbig so na kafiba ka nem pahlugemnefefku.” ");
INSERT INTO amn_n_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Afa Sisas ehem enaig sihifena og, “Sangwalinai mawang ati bite kogim ena megam gi afa twafigni gag ati feg afa kaba Inim El eba ehena kug gigbi awai.” ");
INSERT INTO amn_n_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Afa Sisas ming elim sihina og, “Aubo kam pahluku.” Afa enag el enaig esona og, “Ainiyag, kam yawo wahiaiba kawo ika kikeafna awagim kumoahlanam.” ");
INSERT INTO amn_n_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Afa Sisas ehem sihina og, “Mangofi, kam pahluku. Eba amangel sati pigig enag el ehe so ma melig pigieg elimbi faki. Afa neba eba so na Godna bog meg mom ika sihi.” ");
INSERT INTO amn_n_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Afa mingnag el gwenaig esona og, “Eba ka nem pahlukuf afa yuwaba ka kikeafna afahumonigim bwatamonim ka so bo.” ");
INSERT INTO amn_n_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Afa Sisas ehem sihina og, “El so enaig eseg tataba ouifba mas nofbosug mo masigim ninofeg gofiba eso pifuf eba tatam fukwauguf afa enaig elbi eba mas yuhwafei Godna bog meg moba gafugafei.” ");
INSERT INTO amn_n_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Afa Sisas 72 elim hugwefu hwatinam gafuga wa ningitigi minefena, ehe sambaga sambaga feitifena og so ma mungwali kimbig gof ahuamine fifibi ogna so ehe mo sum ika. ");
INSERT INTO amn_n_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Afa ehe enaig esona og, “Asonai fane enaksag ati ambiakag afa mas el numb feg mo enag fane wambugigimba so na asona awagim betenninibi so ma gafugag elim ningitigiba ma ahunam ehena ena fane agogluinagi. ");
INSERT INTO amn_n_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ahu! Sa hig, ka nem tata luwalig lofug sangwal mawangna olyi onigitigi. ");
INSERT INTO amn_n_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Afa ne afufefiba nofena nimbeafgelni kig i mong lofug i afa gawigba wambug ahu afa nofeka elim mina wa wambinim bwata gonim. ");
INSERT INTO amn_n_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Afa mahim ne ahu ahana lalaba asaihogofiba so na enaig esogo, ohuna lala nai el so olug efihlagna auguiafim. ");
INSERT INTO amn_n_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Afa ma ateamba aman el ena lala nai olug efihlagna gafiba eba nengelni lahlag mo ehenai gofuf. Afa enaig el gag hwanigba eba ena mo lahlagba piske bo nimbeafgel nai yi gofuf. ");
INSERT INTO amn_n_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Afa so na gwena lala mungo auguiafim nofena mungwali lala ahuiaminefi, fane sati nem wambwaigog so na gwenanai ahgafafum afa enag el gafuga feageba eso ma enanam so ma mungwag fai. ");
INSERT INTO amn_n_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Afa mahim ne ahu ahana kimbig waba opukeba ma ateamba nem sulufu heafgelni lala gam wan ahu ofefiba eba so na fane mo wambug ahu so nem wambwaigog. ");
INSERT INTO amn_n_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Afa so na ena kimbig wa nai elim gihnam lahla feitifinim afa so na mo enaig sihif og, Godna bog meg ati bo muhwa nem ofen. ");
INSERT INTO amn_n_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Afa ne ahanag kimbig waba opukof afa el so nem wan ahu lala saiyeg hwainig fef eba so na gweyi agfoahiefiba eso ne enaig esogo, ");
INSERT INTO amn_n_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ma mong yi nai bite mo go ohuna nai yi afgwafi eba amtana minafig afa so na numwehe onigim Godna bog meg ati bog muhwa feg.’ ");
INSERT INTO amn_n_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ka nem sihinig God elim kwefihiagegim ati enag osuba gisfu wahiag. Enag elni kinig so opugun eba gwesim hilifeg Sodomnai elni kinigim kwegfugkag.” ");
INSERT INTO amn_n_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Sisas enaig esog, “Korasin wanai el i Betsaida wanai el i nasambanig, afa mangigim ne enaigba ne esig. Afa mahim Tair wanai el i Saidon wanai el i ma nanguiteba enag kigmogim. Sa ati ne nanguni eso autunam heafgelni amtakwaligim ahwahifnibi afa so kokohiag lofug aitiagini afa simof susleagini enaba heafgelni kusgogim wagfuni. ");
INSERT INTO amn_n_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Afa nengegim God kwefihiageg osuna mungwag faigim. God Tair wanai mi Saidon wanai me gwenaig amtakwalig mungwag faif. Afa nengelimbi eba nem numwehe faif. ");
INSERT INTO amn_n_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","“Afa Kaperneam wanai el ne onigig noka lahlag el hevengam ahuf, eba awai, eba God nem suwi lagig kimbig gam wambu aitif. ");
INSERT INTO amn_n_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Afa Sisas pahlukuiag elim enaig sihifeni og, aman so nengelni mo higif eba ati kana mo higig afa aman so nengelni mo kusi wahia kaf eba ati kana mo kusi wahiag ikag afa aman enaigba esef eba ati Godum mas fatinag ehe so kam ningihiag.” ");
INSERT INTO amn_n_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Afa Sisas so 72 elim ningitigina enag piske ambugog opukegohna, afa ehe sifakalifinibi enaig esogona og, “Ainiyag, ka neana unehlagim sefigbi nimbasa amtakwalig ena mo higigim opuko embem ahkawag minefeg.” ");
INSERT INTO amn_n_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Afa Sisas enaig sihifeni, og, “Ka nangogba Satan of wanai opefenaba afwe lofug yifiyifeg. ");
INSERT INTO amn_n_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Sa hig, ati ka nem kifutigbi faig eba ne sombine afa gongigna nihiahuafiba. Afa eba ne ming Satanna mungwali kifutigim ne flafatif. Afa mas nem mang amanim fei. ");
INSERT INTO amn_n_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nofeka enaig sifakali nimbasa ati kagelni mo higig onigim embem ahug. Amo, eba Godum ehe so na sifakalini eba ati ehe nengelni unehlag heven wa nofkikena gag buk wa fakanig.” ");
INSERT INTO amn_n_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Afa enenam Godna Sungwag Sisasim sifakalig fainaba Sisas enaig esona, og, “Humuan ne heven wanai afa bitenai Ainiyag, ka nem lahlag onag afa ne ohunaig anwanagba anwana elbi ne sisagenigim afa ne etetig elim mo ambagwa opugunig. Humuan ne enaigba esegba eba ne nibeafna membugum pahlufefku.” ");
INSERT INTO amn_n_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Afa Sisas enaig esona og, “Kikeafna Awag mungwali gawig kana ninga wa wahiag afa mas aman kana Awagba anwanafenag mo eba kike mungo fegim afa aman so ka kikeafna Awagim wagfunig ena mungo he ehem anwanafinig.” ");
INSERT INTO amn_n_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Afa pahlukuiag el mungo auguiafnaba Sisas wahigi nanguagnam eso enaig esoni, og, “El so mangim nanguig eba nengel sati ne fanangufi eba so ma sifakali. ");
INSERT INTO amn_n_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Afa ka nem osihin autunam mo fi sihiaule el i afa misog el i ogna ohnaigim nangui afa mas nanguig mo afa ogna ohunaig mo higim afa mas higig mo.” ");
INSERT INTO amn_n_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Afa nihemo anwana el mungo ogna Sisasim gihna ehe enaig sahna og, “Tisa so ka ahanaig esenam so ka nofkikena higeg gagba fafe?” ");
INSERT INTO amn_n_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Afa Sisas wahigi ehem sihina og, “Ne ati anwanafeg nihem, ne ahanaig onigig feg?” ");
INSERT INTO amn_n_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Afa nihemo anwana el enaig esona og, “So na Godum hugna membena. Afa nimbiafna olugni, onigigna sungwagni afa kifutigni eso ne Godum membena afa so na nibeafna hihem hugna membena eso nibefum enaig esfafef.” ");
INSERT INTO amn_n_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Sisas ehem sihina og, “Ei, enaig ho ati ne yuhwa sihig enaigba ne eseiba eba ne nofkikenaba fafe.” ");
INSERT INTO amn_n_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Afa anwana el enaig onigig fena og, eba Sisasim og masa enaig onigig fef og sona elbi mas pahlukug mo. Afa so Sisasim enaig esona, og, “Afa kana hihe aman mahim?” ");
INSERT INTO amn_n_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Afa Sisas waskwes mo enaig sihifena og, “El mungo Jerusalemim wahianam Jerikogam pe ikafna afa raskol el ati ambugog mina puguag wa agfohiafna, enag opuko ehena gawig mwehnaginim afatigi kaminefi fati ahunaba ati wahagim meini ofefna. ");
INSERT INTO amn_n_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“Afa enenam pris mungo bo nanguafnaba meigim mina kwegfu ikana. ");
INSERT INTO amn_n_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Afa lotunai gafugag el mungo gwenaig esena bo nangunam meigim mina kwegfu ikana. ");
INSERT INTO amn_n_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Afa Samarianai eba afwambanai el sum bonam eso nanguna mahim mina wa gifnibi afa so afafena. ");
INSERT INTO amn_n_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Afa so ika fahigenagenam eso marasin bugna mawu gokugum sugfunagenam kikenagena, enaig donki wa washunam eso luwal nena lalagam wanikina. ");
INSERT INTO amn_n_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Enanai yi wanigiafum mahim managenaba eso lalana mogim silva kig fainam og, ‘Eso numwehe sani gafim, afa so nofeka ming sisiyi pahla eba se gafiba ka piske bonam keso nem fai.’ ");
INSERT INTO amn_n_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Afa Sisas anwana elim sahna og, sambaga mungo el so aman mahim raskol tigifatig elimbi kweagfuna. Afa aman mahim ehena hiheaba feg?” ");
INSERT INTO amn_n_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Afa ehe esona og, “Eba el so hugunam afafenam afa kweagfuna.” Afa Sisas ehem sihina og, “Ei, so na gwenaig ne gaba ese.” ");
INSERT INTO amn_n_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Sisas pahlukuiag elim wan ikana kimbig wa wan sahu pugunaba afa Marta bonam Sisasim sulufanam heafna lalagam wanikina. ");
INSERT INTO amn_n_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Afa Marta ati heafna sumineg fena ehena unehlagba Maria enag bo Sisasim muhwa kluhlanam Sisasna mo hignaufna. ");
INSERT INTO amn_n_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Afa Martaba gafugagim hugunam onigina ehe fwaimu fane kukumwei yegohun ehem kusinaiba eso ika Sisasim sihina og, “Ainiyag, so na kam kusguna so na kikeafna suminegim sihinaiba so ma bo kam kweagfoi ka kike fwaimu gafuga fego.” ");
INSERT INTO amn_n_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Afa Ainiyag ehem esona og, “O Marta, ne hugunam gawigim onigigi. ");
INSERT INTO amn_n_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Afa so na mangim mungo onigigi, afa Maria so afahba eba lahlag nemugfeg mas big ehena enaigim fi fatini”. ");
INSERT INTO amn_n_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Afa mahim Sisas betene gafnaba, afa so pahlukuiag el mungo Sisasim enaig sahnafena og, “Ainiyag, so kam betenegim wagfunim Jon sati autunam esena heafna pahlukuiag elim wagfuni.” ");
INSERT INTO amn_n_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Afa Sisas enaig sihifeni og, “So na enaig beteni og; Humuan el so ma neana unehlagim fingifi afa neana bog meg so ma boi. ");
INSERT INTO amn_n_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Afa so na kam fane mungo mungo osuna faibi so ma gwese gofi. ");
INSERT INTO amn_n_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Afa ne kagelni amtakwalig nihem ismunagim pigihianugeg fatinig. Afa ka gwenaig esig el kagelim amtakwalig hiagibi eso kagel gwenaig esegonig ehengelni amtakwaligim pigi fatigonig ne kam hwatif, ma kam gihnagba pugunibi so na kam amtakwalig wanai wambum.” ");
INSERT INTO amn_n_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Afa Sisas enaig sihifeni og, “Aman so heafna hihefeg enag sinaini bogim heafna hihem esonag og, ‘O, hihe ka membeg kam sambaga mungo amba faim. ");
INSERT INTO amn_n_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Afa ehe ikagim heafna ming hihem sihinag, og, kana hihe minagwi bowagim sinaini kana lala puguba afa kam fane awaienag ka mas faig mo.’ ");
INSERT INTO amn_n_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Afa eheba lala megam gibi enaig esog, og, ‘Nofe ka kam ilafofafa ati ka mengigba kikisegim ka wangi. Ka mas bihianam nem gawigba fai.’ ");
INSERT INTO amn_n_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ka nem sihinig lalana mog hihem so gawig faig hwainig awaief eba ehe mahimsi sahna go mahim feg ehem kusiba eso buihiagim mungwali gawig ehem wambwaig. ");
INSERT INTO amn_n_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Afa so na gwenaig esi ma ne Godum sahnibi so ma nem mangwalba fai afa ne yisgibi eba ne nanguf afa ne mengigimba faheugufibi eba nem mengig piginif. ");
INSERT INTO amn_n_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Afa mungwali el so mangwalimba Godimba sahnigbi eba fif. Afa amangel enam hugnamba oyisgibi eba so nanguf afa aman mengigim faheugufefibi eba piginugef. ");
INSERT INTO amn_n_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Afa so nengelni luwal aman heafna awagim sahnaf og, kam sawug embinegu fai, afa so wahigif gihe sombine faig, amo. ");
INSERT INTO amn_n_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Afa luwal awagim sahnaf kam amb suwig fai afa so wahigifegim gaigo faig, amo ena gaba awai. ");
INSERT INTO amn_n_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Afa nengel luwalna humoanig eba amtakwalig el afa so na luwalim lahla fehiagig so na anwanafi nengelni awag hevenwa ga eba nem sifakalinim afa amangel so ehem sahnig enam heafna Sungwag faif.” ");
INSERT INTO amn_n_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Sisas mo etetini elim lahla fefatina, ena elbi nimbasa esenagini. Afa mahim el mo wagenaba eso mungwali el enam nangunim sineminefini. ");
INSERT INTO amn_n_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Afa mingnag el enaig esogona og, “Sohna elbi eba Belsebulni kigmog wa gafuga feaka.” Belsebul eba Satan nimbasana misog el. ");
INSERT INTO amn_n_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Afa mingnag el ogna Sisasim gihni eso ehengel ehem sihini og, “Sa kigmog ogfu enaigba ne esegba eba naho wagfug ne Godna gafugagba feageaka.” ");
INSERT INTO amn_n_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Afa Sisas ati ehengelni onigigim anwana fenim afa enaig esona og. “Eba enaig eseg, so amangel kantri kwefihiagim eso hefum hagfe eba ena kantri amtakwalef. Afa mungo nilitena so hefum hagfe eba gwenaig esef amtakwalef. ");
INSERT INTO amn_n_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Afa Satan heafna gafugag elim amtakwale aitiba eso hefum pwatihiagif, afa pwatihiaginim afa so mang so Satan nangwagihiageg eba enag tigefupef. Afa so na esgog, kam og, Belsebulni kigmog wa nimbasa amtakwaligim ningitigi feaka. ");
INSERT INTO amn_n_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Afa inimba eso aman so nengelni elbi kigmogba faif eso nimbasamba ningitigi feaka? Eso nibeafna elim wagfunfe, nengelni onigig amtanafeg. ");
INSERT INTO amn_n_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Afa ateamba God kigmog faigba amba so ena kigmogna ka nimbasa amtakwaligim ningitigi feakagba eba so na anwanafi, eba Godna bog meg ati pugug. ");
INSERT INTO amn_n_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Afa so kifutig el mungo fangoba wambugum heafna lalam kokoago afa so ehena lalanai gawigba lahla gohna. ");
INSERT INTO amn_n_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Afa eba ming el hugna kifutig elbi ehe bigagahfenam eso ehem filafe fatinam afa so fango mo numwehenam afa ehena mungwali gawig mo okwefenam mingnag elim mimagenif. ");
INSERT INTO amn_n_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Afa aman so kablei ahgohug hwanigba eba kam angoluwag el fenag afa aman so elim wambugum kam kwegfwag hwanigba eba elim pahagagule el.” ");
INSERT INTO amn_n_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Afa Sisas enaig esona “Nimbasa elim wahiagim ikagim bu hwainig bite eyi gagim yisgig, afa mas ufag mo. Eso ehe enaig esog og, ka piske kikeafna lalagam ika. ");
INSERT INTO amn_n_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Afa so ikag ena lalam nangogba isug go afa ati afwambusiagigim afa numwehiagig wahig. ");
INSERT INTO amn_n_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Afa so ehe piske ikagim elegeg wa gohug nimbasa hugna amtakwaligim sulufugim eso wanbog saiyeg agfohie, eso elbi enaba hugna nemug amtakwaleageg, afa yuwana mo gweyiagig fena.” ");
INSERT INTO amn_n_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Afa mahim mungwali el nuwag gofnaba eso Sisas enanai mo sihina afa angwafig mungo enanai enaig esona og, “Angwafig so nem wanigagim afa nem tut faig enaba so sifakalei.” ");
INSERT INTO amn_n_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Afa Sisas enaig esona og, “Amo, so big enaig esogo, el so Godna mo higigim pahluhug enaig elbi eba so ma sifakali.” ");
INSERT INTO amn_n_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Afa el numb ambugonaba afa so Sisas enaig esona og el enenamba amtakwalig augiafnaba og kawo kifutigim nangu afa enaba wagfug ka Godna gafugag ka eseg. Afa mas enag wagfuiagimba nanguig mo eba awai eba Jonana kifutigim mungo nangufe. ");
INSERT INTO amn_n_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Afa autunam Godna mo faule el Jona Niniva nai el amtakwaligim eso Inim el gwenaig nengelim esenif. ");
INSERT INTO amn_n_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Afa enenam God so elim kwefihianugef afa wahigwanai kwin bihianam eso nengelim setigif. Afa ena kwinbi eba heafna kimbig wahia bonam Soloman na lahlag mo eso higif. ");
INSERT INTO amn_n_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Afa enenam God elim kwefihianugef afa so Niniva wa nai el bugia gafenam eso nengelim setigif. Afa ehengel Jonana mo higinim eso heafgelni amtakwalig nihe masigim fatini, ka nem sihinig aman el mungo so ohunanai yi go, eso enag Jonamba gosenag. ");
INSERT INTO amn_n_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Sisas enaig esona og, “Mas amanba wiba gafanam meagamba kumoahlai, eba awai, eba wiba gafagim ambagwa oguhba eba ena lalanaim elim afwambusug faig. ");
INSERT INTO amn_n_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Afa nofugba eligni afwambusug neana nofug lahla gohugba eba neana elig mungwali afwambusig. Afa neana nofug amtakwaligba eba neana elig sikifig. ");
INSERT INTO amn_n_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Afa so numwehifibi ese neana afwambusug so saho neana nihi go masa hugunam sikigiagef. ");
INSERT INTO amn_n_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Afa eba neana elig so mungwali afwambusi go enag sikifig mas nanai yi gofi enag so ma mungwali afwambusi gofi ofenaiba lam pukogofi.” ");
INSERT INTO amn_n_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Afa mahim Sisas mo sihi wahianaba afa so Farisi el mungo bo ehem awamonam og na fane ahga afa so Sisas ehengelni lala ika saho sime wa pegana. ");
INSERT INTO amn_n_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Afa mahim Sisas fane buwa ningam sugeg hwainig onefnaba afa ena Farisi el enam nangunam hugunam onigaufna. ");
INSERT INTO amn_n_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Afa Sisas ati ehena onigigim anwanafenam eso enaig esona og, “Nengel Farisi el ne kap afa pletba afwambagam mungo gigiafeagig afa meagam nengelni onigigba eba okwefi afa ahanaig ahanaig nihei memtowa pugu go. ");
INSERT INTO amn_n_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Afa ne mo etetig el! Mas ne numweheg anwanafig mo eba God gafugafefug afa so ehe meagam gaba gwenaig esefug. ");
INSERT INTO amn_n_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Afa mang so plet wa afogoa enag so na elim faigo eso ehengelim enaig tumenig afa ne enaigba esibi eba nengelni mungwali gawig afsug pugu ikagef. ");
INSERT INTO amn_n_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Afa Farisi el nasabanig eba nem amtakwalig pugunif ne enaig esig, yasmoel unehlagba mint, dil, kumin enag ne wambugum afa ne 10 pela hap sugwahugum afa mungwehigenai mo Godum faig afa ne lahlag nihe God so membeg enam ne wahig. So na enam hugna kifuti ma so na mingnag nihem gaba wahif. ");
INSERT INTO amn_n_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Afa Farisi el nasabanig nem amtakwalig pugunif. Ne enaig esig ogka nuwag guhug lala gosuf lahlag sime wa augu. Afa ne enaig membig nog so ma kam unegoni og, amunai el. ");
INSERT INTO amn_n_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Afa nasabanig ne bitekfeg lofug. Sisiyiamo el nangugbi lahlag go afa el ena mina gam ahugim afa mas anwanafig mo skaug mo bitemegamba eba kigi lofugi ati nogi go.” ");
INSERT INTO amn_n_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Afa nihe mo anwana el mungo ena mom higinam Sisasim sihina og, “Wagfuiag el ne enaig mo Farisiim esonibi eba kagelim gaba ne kam mungwali moalabenig.” ");
INSERT INTO amn_n_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Afa Sisas anwana elim enaig esoni og, “Nasabanig eba amtakwalig nem pugunif ne elim kinig kike faigog, afa ena kinigbi el kahlig, afa nimbea mo mas ne wesig ningana agig mo. ");
INSERT INTO amn_n_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Afa nasabanig nengelni simbianiga Godna mo fi sihiaule elim kwaskofigim afa ne bitekfe mo hugunam lahlafeagig. ");
INSERT INTO amn_n_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Afa enaigba eba ne elim wagfugonig, eba enaba ne mungo onigig fig nengelni simbianiga so autunam esini. ");
INSERT INTO amn_n_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Afa Godna lahlag onigig enaig esog, og eba ka mo fi sihiaule elni afa gishug hwatieg elni ningitigiba eso ahu amtakwalig el nai opukeiba afa so mingnag mo pahagemine fenigim eso kwaskofif afa mingnag i mo isug kwaskofig hwatig. ");
INSERT INTO amn_n_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Afa so ena kinigbi gwesego yuwana so God mungwal gawig eseage wahianaba enanai puguagim bog yawoga go. Enaig mungwali nihe God yuwaga elim mungwag faig. ");
INSERT INTO amn_n_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Afa mo figsihihuule elim so kwaskofigbi ena niheba Abel naiyi puguagim bog Sekaraia nai pugug. Afa Sekaraiaba tigi fatinibi eba Godum sis tuhlu faig sime i afa Godna nalig lala i ena olyi tigi fatini. Ei ka nem sihinig, ena tautig amtakwaligba eba nem mungwali elim mungwag faigimba yuwanaba pugunif. ");
INSERT INTO amn_n_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Afa nihemo anwanag el nasabanig, ne Godum anwanafenag minam kwegonig afa nimbea mo mas ne ena minagamba ahu saho anwanafi afa ne ehengelim kwegonig.” ");
INSERT INTO amn_n_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Afa mahim Sisas ena lalam wahia akafenaba afa Farisi el i afa nihemo anwanag el i olug kakagenaginim afa so ahanaig ahanaig sahig opuko fenagini. ");
INSERT INTO amn_n_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Afa ehe mwakwalini Sisasim og mahim ahanaig mo sihiba og naso ehem kotimini. ");
INSERT INTO amn_n_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Afa el numb hugunam nuwagig enam mina kagwu fakanaba enanam Sisas pahlukuiag elim enaig sihifeni og, “Farisini yistim numwehifibi, enaba ka nem sihinigbi eba ehengelni mwakwal mo amtakwalig. ");
INSERT INTO amn_n_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Afa mang so mungwali meagam yawo sisagego eba nengigim ambagwa puguf. Afa sisag moba eba mungwali el anwanafif. ");
INSERT INTO amn_n_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Afa yawo so na mungwali mo muhefuna ne sihig afa nengigimba eba el ambagwa higif. Afa mungwali mo so na yawo muhefuna lala megam sihig, afa nengigimba eba el ambagwa ambwaitina sihif.” ");
INSERT INTO amn_n_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Afa Sisas enaig esoni og, “Kana hihe nofeka embefi aman so nem og, ka tikefati enag elbi mas neana sungwagimba tikefati, eba awai. ");
INSERT INTO amn_n_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ka nem ambagwa osihin, so na Godum embefini, eba ehe nem eligni sungwagni suwi lagig kimbig gam wambu aitif ka nem ini mo sihinig so na Godum mungo embefini. ");
INSERT INTO amn_n_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Afa so na afawa pugufeg twafig wesig kigna wambug ese masa mungo pef eba God mas enaigimba eteti. ");
INSERT INTO amn_n_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Afa eba God ati nengelni wapogum suwigig hwatig, afa ati nem anwanafenig afa namba gwesim twafigim, hili fegonig Godna onigigimba eso nofe ne embefi.” ");
INSERT INTO amn_n_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Afa Sisas enaig esog og, “Afa aman el so enaig esof og kaba Sisasna el, eba afa kaba Inim El gaba Godna ofwanai elim sihinif og, ohonaba kana el. ");
INSERT INTO amn_n_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Afa aman el so mingnag elni nofwa kam mas fatinafe eba ka gaba Godna ofwanai elim sihinif ohunag elbi ka mas ehem anwanafenag mo. ");
INSERT INTO amn_n_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Afa aman el so amtakwalig mo Inim Elim esenaf eba God ma ena amtakwaligba fafatif. Afa eso aman Godna sungwagim amtakwalig mo esenaiba eba yawo afa nengigim God ena amtakwaligimba mas fafatinai. ");
INSERT INTO amn_n_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Afa mahim nem wanahu gavmanna nofwa afa lotuinai amunai elni nof wa wambu aitibi nofeka enaig onignagim afa ahanaig mo so big sihif. ");
INSERT INTO amn_n_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Afa eba gwenenam nem Godna sungwag nengelim wagfunibi eso ne moaba sihigonif.” ");
INSERT INTO amn_n_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Afa el mungo bo Sisasim enaig sihifena og, “Wagfuiag el kana awag ati wahagba gawig mo sko wahia kag ka membeg ne kana etegim sihinaiba so ma gawig mangetigi kam fai.” ");
INSERT INTO amn_n_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Afa Sisas ehem wahigi sahna og, “Aman so kam enaig kwefihiagegimba gishu wahiag og so ma nenigina gawig mangetigini amo eba awai?” ");
INSERT INTO amn_n_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Afa Sisas enaig sihifeni og, “Numwehifibi masa ne ahanaig ahanaig gawigim, enaba ne enaig nubinifefe, afa mas nem enaig gawig nof kikenag fai.” ");
INSERT INTO amn_n_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Afa Sisas enaig waskwes mo sihina og “Kig elni asonai gawig enaksag pugug kug luwageg. ");
INSERT INTO amn_n_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Afa enag el enaig onigifena og, ahanaig so ka esef, ena asonai faneba so ka mang lala skofe ka lala awai. ");
INSERT INTO amn_n_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Naiba kawo enaig ese, ka fane lala wetiklug bubugeiti feakanam afa ka so nalig lala nimbagenam enanai asonai fanei witi sko. ");
INSERT INTO amn_n_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ei keso kikeahba enaig eso, kaba hugunam enaig eseageg, ka enaksag gawig lahlag eseagegba eba gwese higeg enaksag yia wa gofiba afa so ka hekuleaufiba fane mo agogluinam neaufiba sifakalef. ");
INSERT INTO amn_n_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Afa God ehem enaig esona og, ‘Ne moetetig el yawo nem ohuna sinaini wahaiba afa so neana mungwali gawigba aman fafe?’” ");
INSERT INTO amn_n_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Sisas enaig esona og, “Sonaig el so enaksag bitenai gawig agogluig enaba ahunam Godna nofbosug wa isug el amtakwalig agfohiefuf.” ");
INSERT INTO amn_n_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Afa Sisas heafna pahlukuiag elim sihini og, “Ka nem enaig sihiofen so na waskwes mom onig. Nofe ne nimbeafgelni nofkikenam hugna onignaginim afa ne enaig esegof nog mang so big ahgaf? Afa nofe ka nimbeafna lofugum oniginim afa enaig esogo mang lofug so big fatif? ");
INSERT INTO amn_n_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Afa ena nofkikena eba fanem flafug afa elig lofugim flafug. ");
INSERT INTO amn_n_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Afa ati ne twafigim nangwagig mas faneba yihi afa mas agogluinim fane lalaba sugum, eba God ehe faneba faig, afa namba ati ne twafigim flafug! ");
INSERT INTO amn_n_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Afa aman so nengelnai onignagegim eso heafna nofkikenaba hilifeg wahiag, amo eba awai. ");
INSERT INTO amn_n_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Afa mas ne ena wetiklugba esei, ahanaig esegba so na hugunam mingimba onigig. ");
INSERT INTO amn_n_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Ati ne li sisigimba nangug ahanaig so pugug afa ehe mas kifutig gafugafei afa lofugba kweli. Afa ka nem sihinig autunam misog el Solomanna mungwali gau lahla skofenaba mas lahlag li sisig lofena mo. ");
INSERT INTO amn_n_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Afa yawo so ohuna pos gohka afa siniba higfihinim suwi wa wambu aitif, enaig posba God ehe wagwageg wahiag, afa so nengel wesig onigig feg eso ne numwehe onigim nemgamba Godba nem gau faif. ");
INSERT INTO amn_n_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Afa nofe ka enaksag onignaginim afa esogo mang fane afa bu big ahgaf. ");
INSERT INTO amn_n_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Afa afwambanai elbi enaigim hugna onignagigim afa so hugunam yisgeafo, afa nengelni awag ati anwanafeg eso ne enaig fif. ");
INSERT INTO amn_n_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Afa ne enaig esofifibi eba so Godna bog meg gosu hugunam onigibi eba so nem enag gawig gaba nem faif.” ");
INSERT INTO amn_n_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Afa Sisas enaig esona og, “Nengel kana mungo sambaga sipsip nofe ne embefi eba nengelni awag sifakalef nem minaba wagfunif eba ehe nengelni misog el fenam eso ne heafna bog megam saigof. ");
INSERT INTO amn_n_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Afa so na elim wahiagonibi so ma nengelni mungwali gawig wambuibi eso ne kig fi so na ena kig mo el so gawig tumenig so na kigba enam faigo. Afa so na lahlag gawig heven wanai agogloi. Heven waba eba mas susmofei i afa mas okwef el okwef i afa mas awaie i. ");
INSERT INTO amn_n_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Afa enanai yi so neana gawig go enaba neana onigig gaba eba gwese enanai yi gofif.” ");
INSERT INTO amn_n_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Afa Sisas enaig esona og, “So na gafugag lofug aitiagenim afa lam pukogifi so na nimwehiaginim gofum. ");
INSERT INTO amn_n_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Afa so na enaig esi ofenaiba kwamblo el angwafig fag buyisegim oboba ne enam nimwehiagigim negeafo. Ma ateamba bo mengigim tigegba eba ikagna mengig pitigiefunif. ");
INSERT INTO amn_n_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Afa so ena elbi bo gafugag elim nanguagif so ehengel non askag hwainig fif eba so ma sifakalif. Ka nem inim sihinig, ena amunai ehe gafugag lofug aitagegnam eso sihinif og, apaigo sime wa augu, eso ehe bonam faneba mimagenif. ");
INSERT INTO amn_n_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Afa so amunai mongkokug liputegna me awai ambagna me bo gafuga elim nanguagif so ehengel non askag hwanigfif eba so ma sifakali. ");
INSERT INTO amn_n_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ateaho ne enam anwanafig, el so lalana mog feg enag so ati anwanafef eba amansi so sinaini okwef elbi bof eso ehe numwehego afa mas wahiai eba og masa okwef el lalagam saho bof. ");
INSERT INTO amn_n_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Afa nemgamba so na numweheage gofim Inim El so enag osuna obofiba ne etetiegafif.” ");
INSERT INTO amn_n_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Afa Pita Sisasim sahna og, “Ainiyag ena waskwes moaba fig kagelim mungo me awai mungwali el nahlu me?” ");
INSERT INTO amn_n_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Afa Sisas esona og, “Aman so gafugag el so lahlag onigig fegim eso heafna gafugagim numweheageg enaig elbi eba naho misog el ehem gishu wahiag og so ma ehena gafugag elim nangoghiagnam afa so fane mimageni. ");
INSERT INTO amn_n_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Afa enenam so misog el piske bonam eso ehem nangufe mahim gafugafegofiba afa enaig elbi so ma sifakalei. ");
INSERT INTO amn_n_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Afa ka nem ini mo sihinig afa enag gafugag elbi eba misog el ehem gishu wahiag og so ma mungwali gawigim nangoghiagei. ");
INSERT INTO amn_n_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Afa enag gafugag el enaig ming onigig fenaba ehe enaig esona misog el eba mahimsi fe afa eso ehe puguagim mingnag gafugag elim kwablogim afa angwafigim kwagaitifiahka afa wain bug negim hugna tutofihiafeageg. ");
INSERT INTO amn_n_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Afa enag osuna ehe etetif mahim heafna misog el piske bo puguf afa enag misog el ehem amtakwale fanam afwambanai el naiyi wahe wahiaf. ");
INSERT INTO amn_n_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Afa gafugag elbi ati ehe misog elni sawiegiba anwana fenam afa ehe mas nimweheagena mo misog elni sawiegim pahluku mo eba misog el bonam ehem hugunam tigikaminefef. ");
INSERT INTO amn_n_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Afa aman gafugag el so misog elni sawiegim etetig eba mwakwalig tautig fafe, afa amangel el so na enaksag gawig wambugig afa ne ming pasnim eso ne piske sugo afa so el enaksag gawig mungo elni ninga wa sugof eba enag el so ma mingnag pasnam eso ma piske ehengelim wambwai yi.” ");
INSERT INTO amn_n_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Afa Sisas enaig esona og, “Ka bogim suwi bite wa fati wahiag, afa ka sawiyifeg ena suwi ati pahalag. ");
INSERT INTO amn_n_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Afa mahim ka wahaf eba enaig ofenaiba ka enmunam buwa pe fag suf, enag kam olug hugna kinig enaig gafugag so ma gohun ikan enenam awaie. ");
INSERT INTO amn_n_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Afa masa ne enaig onigig fif kam og eba bog ohuna bite wa fag hagigim tigefakaf. Amo, eba ka bo elim olyi magetigif. ");
INSERT INTO amn_n_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Afa nengigba eba afawa pugufeg mungo lalanai el hefum bambuhiagi kamine fenam eso hefum tigetifeagif. Afa sambaga mungo agfohienam eso sambaga elim wagonuf afa sambaga el ahgohnam sambaga mungo elim ahfenif. ");
INSERT INTO amn_n_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Afa awag gohnam heafna fangonai luwalim wagnaf afa fangonai luwal gohnam heafna awagim wagnaf afa afag gohnam heafna naini luwalim wagnaf afa naini luwal gohnam heafna afagim wagnaf, afa kuwag gohnam heafna kuwagim wagnaf afa kuwag wahigife mungwag heafna kuwagim wagnaf.” ");
INSERT INTO amn_n_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Afa Sisas enaksag elim enaig sihifeni og, “Afa so na ofim osu pegam nangug mahim nugwagofeba ne enaig esogog bu fegim eso bufeg. ");
INSERT INTO amn_n_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Afa ne nanguig kifutig fufei osu peg meigim wanai bog. Afa ne esog osu klaig opuko eso gwenaig eseg. ");
INSERT INTO amn_n_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Afa ne sambaga mengigna el ne enaig esig bitenai gawig mi afa ofwanai mi ne hugna kwefihianagig afa ne mas numweheg anwanafig mo mang so yawo pugug.” ");
INSERT INTO amn_n_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Sisas enaig esona og, “Afa ahanaig esegba so na mas numweheg onigig mo so na numwehe kwefihiagi ahanaig nihe so yuhwaba feg. ");
INSERT INTO amn_n_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Afa el so nem ogna kotimena enaba so na mina wa ahkafiba so na sihiagaf. Masa nem fanam jasna ninga wa wahiaiba afa jas nem fanam plismanna ninga wa wahiaiba eso nem fanam kalabus lala fatif. ");
INSERT INTO amn_n_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Afa ka nem inim sihinig, eba ne kalabus lala gweyi gafiba eso ne kigna mungwali baimef.” ");
INSERT INTO amn_n_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Afa mahim Sisas mo sihiage wahianaba afa el mingnag Galilina mom sihinagini, og Pailat heafna amiim sihinigbi ehengel elim kwasko fifug, mahim Godum sis tuhlu faigim ofibi afa elni taf pefum Godum faigim ofibi afa elni taf pefum Godum sis tuhlu faig taf wa fafpahlif. ");
INSERT INTO amn_n_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Afa Sisas enaig sihifeni og, “Ateaho so na onigig, enag Galili elbi amtakwalig gafugag enaksag feagigbi eso enag amtakwalig ehengelim pugunig? Afa mingnag Galili el eba lahlag afa so mas enaig amtakwalig ehengelim puguni mo? ");
INSERT INTO amn_n_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Amo eba awai ka nem inim sihinig, eba ne olug wahigifig hwanigba eba nem amtakwalig gwenaig mungwali pugunif. ");
INSERT INTO amn_n_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Afa autunam Siloamna kimbig kwieg lala tufupei 18 yi gohug elim pigasko fenaba eso pigina so na enam onig amtakwalig so figbi, enaba ne og el so Jerusalem wa auguia enam filafig me? ");
INSERT INTO amn_n_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Amo ena gaba awai, ka nem inim sihinig eba so na olug wahigifig hwainig fif eba nem amtakwalig gwenaig mungwali pugunif.” ");
INSERT INTO amn_n_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Afa Sisas enaig waskwes mo sihina og, “El mungo fik li heafna aso wa gahag wahiag, afa nengigimba eba ehe piske bonam eso fik li fugim oyisigifiba afa mas fugim nangui. ");
INSERT INTO amn_n_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Afa so ehe heafna gafugag elim enaig esona og, ‘Sa hig, sona fik libi sambaga mungo yia wa gohug, afa mas fug leg mo ka fahigeagegba mas ka fugim nangug mo eba so na higefefati ehe mugunim lahlag bite wa go.’ ");
INSERT INTO amn_n_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Afa gafugag el wahigi ehem sihina og, ‘Amunai luwal so magofi ma mungo yia wa gofiba kawo mogim bite tutohiagenam afa bulmakauni ata sukonage.’” ");
INSERT INTO amn_n_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ma ateamba nengigim fug olefiba eba lahlag, afa awaiba fegba eba so higefefati. ");
INSERT INTO amn_n_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Afa Sisas nuwagig osuna nuwagig lala mo sihinugeni. ");
INSERT INTO amn_n_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Afa enanaiba angwafig mungo gihna fena eba nimbasa amtakwalig saho esenagini ena gihba higeg gwese gofna, yiaba 18 ena enaig fena, enag ehena kigibugbi ati fiasaif ahanaig seg bihiah mo. ");
INSERT INTO amn_n_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Afa Sisas ehem unenam afa enaig esona og, ‘Angwafig ati ka neana gihba hugufatinag.’ ");
INSERT INTO amn_n_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Afa so Sisas angwafigim ningana tuhnaiba eso kigibugbi bihia susni feafuna. Afa so ehe Godna unehlagim fingi fukuna. ");
INSERT INTO amn_n_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Afa nuwag gohug lalanai gosug el Sisasim olug kakagenam ehe mungwali elim enaig esona og, ‘Gihna so na og el so ma kam lahla fefati eba enwesog wa gohug gafugag osuna ehe so na bo. Afa nofe kawo elbi gihim lahlafe fatiagimba nuwagig osunaba bo sahna, magofi.’ ");
INSERT INTO amn_n_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Afa Sisas wahigi ehem enaig sihifena og, “Ne sambaga mengigna el, afa nengelni mo i nihe i mas mungwalofug ahfeg mo, eba ne nuwagig osunaba bulmakau lalagam ahugim bulmakauni donkinam pigihiagonigigim bu wambwaigogim wanahug. ");
INSERT INTO amn_n_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Afa ohunag angwafig so eba Abrahamna luwalig mungo he feg enag Satan ehem kehlaguagim 18 yia enaig wa enaigim pigi fatinag afa ne kam og masa ne nuwagig osunaba esef?’ ");
INSERT INTO amn_n_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Afa mahim Sisas enaig sihifenaba, afa ehena angoluwag el ehem hugna ahwanifesko fena. Afa mungwali el giafigigini mahim enaig lahla pugunaba. ");
INSERT INTO amn_n_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Afa Sisas enaig esona, og, “Godna bog meg so ahanaig seg, ka enaig waskwes mo osihi. ");
INSERT INTO amn_n_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Eba wesig klug mastet lifug lofug afa mahim el aso wa kumohlagba eso fukoagim nalig feagegba afa eso twafig ambugogim enanai yi gag nimbagig.’ ");
INSERT INTO amn_n_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Afa Sisas ming waskwes mo sihini og, “Godna bog meg so ahanaig eseg. Ahnaig waskwes mo so ka sihig? ");
INSERT INTO amn_n_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Afa eba yist lofug, angwafig mungo yist wesig fagim plaua nalig wa wahegba eso plaua pipkia fugog.” ");
INSERT INTO amn_n_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Sisas Jerusalem minagam ikafnaba elim taun wanai elim afa kimbig wanaim mo wagfufunugena. ");
INSERT INTO amn_n_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Afa el mungo Sisasim enaig sahnafena og, ‘Sa God ba mungo mungo elbi piske wambu me?” ");
INSERT INTO amn_n_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Afa Sisas wahigi enaig sihifeni og, “So na hugunam kifuti ahu mengig wesig megam saho. Afa ka nem sihinig, eba el numb ogna ena minaba saho afa mas enaig esi. ");
INSERT INTO amn_n_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Afa mahim nengigim lalana mog mengig kikiseiba eba ne ambugonam afwambawa agfohiefiba afa ne enaig esogof ne og, ‘Ei amunai luwal kam mengig piginim.’ Afa nem wahigi enaig esonif og, ‘Ka mas nem anwana fenig mo ne ahnanai bog.’ ");
INSERT INTO amn_n_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Afa ne enaig esogof ‘Kaba ati big fane ahgafena afa ne olyi gohugim kam wagfunigeg.’ ");
INSERT INTO amn_n_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Afa eba nem enaig sihinif, ‘Ka mas nem anwana fenig mo ne ahnanai el, ne amtakwalig el gwesim ahu.’ ");
INSERT INTO amn_n_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Afa ne nanguibi Abraham, Aisak, Jekop afa mungwali Godna mo fi sihiaule el enag Godna bog megamba saho agfohiefif. Afa negelbi nem wambu aitibi ne afwamba wa agfohiefiba afa ne wewatini nibeafgelni gog kike sko fef. ");
INSERT INTO amn_n_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Afa el osu puguiag wanai, osu peg wanai, afa meigim wa nai afa ohgo nai ehnge nai eso ambugonam Godna bog megam saiyenam fane ahgafatife. ");
INSERT INTO amn_n_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Is, so hig, enenam mingnag el so yawo sum ambugog eba ahu gosuf. Afa mingnag so gosug ahuia eba ambugonam sum agfohiefif.” ");
INSERT INTO amn_n_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Afa gwenenam Farisi el ambugog Sisasim sihini og, “Ne ohuna kimbig wahianam ming kimbig gam ika Herot nem ogna tigefati.” ");
INSERT INTO amn_n_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Afa Sisas sihini og, “Herotba ifouwai lofug ahunam so na ehem enaig sihififni. Is so hig, yawo i, sini i ka nimbasa amtakwaligim ningitigifei afa gih elim lahla feitifei, afa mahim sambaga mungo osu feiba eba keso kikeafna gafugagba awaie fati. ");
INSERT INTO amn_n_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Afa yawo, sini, esnag ka gwesim ikafuf profetba mas enmuna kimbig waba gafiba enanaiba tigifati eba heafna Jerusalemwaba so tigifati.” ");
INSERT INTO amn_n_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Sisas enaig esona og, “O Jerusalem wanai luwal ne Godna mo sihiaule elim kwaskofig. Afa el God nem ningitiginigbi afa ne hunna kwaskofig, afa higeg goka elim wambui kikeafnai yi wambugufum, ofe naiba kakaruk afag heafna luwaligim wambui anglag meg gam kumo wambku afa mas ne enaig membig mo. ");
INSERT INTO amn_n_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Is so hig. yawoaba nengelni kimbig amtakwalenam isug gofuf. Afa ka nem ini sihiofen ne mas kam nangui ne auguan so na esogof. Sonag elbi God ehe numwehenageg Ainiyagna unehlag wa ningihiag. Sa ma God ehem lahlafiah fai.” ");
INSERT INTO amn_n_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Afa mahim nuwagig osuna pugunaba Sisas ika Farisini goseg elni lala fane ahgafafnaba afa ehengel Sisasim nangufafna. ");
INSERT INTO amn_n_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Afa kwakug el bonam Sisasim nanguna. ");
INSERT INTO amn_n_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Afa so Sisas enaig elim nangunam afa so anwanag el mi Farisi el mi enaig saheni og, “Bigelni nihemo so ahanaig esog so big gih elim bi nuwagig osunaba lahla fifati me awai, awai me?” ");
INSERT INTO amn_n_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Afa ehengel mwahlai auguafena mas mo ahanaig esogona mo, eso Sisas ena elim lahla fefatinaba eso pugu ikana. ");
INSERT INTO amn_n_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Afa so Sisas enaig sihifeni og, “Eba so nengelnai so na nuwagig osunaba luwalim o bulmakaubi mimewa pe nawakofiba so na nangu wahiai me awai ne ikagna fuakwa fati me?” ");
INSERT INTO amn_n_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Afa ehengel mas mo mungwag wahigi Sisasim fatini mo. ");
INSERT INTO amn_n_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Afa Sisas elim fane ahga fag wa nangwagna, ehengel ogna ehe lahlag sime wa gosuf augu, afa so Sisas waskwes mo enaig sihifeni. ");
INSERT INTO amn_n_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Og, “Afa so el mungo nem angwafig fa buyis wa unetigif nofe ne ahu lahlag sime wa gosuf augu eba ateame ming elim gishu wahianag ehe nalig unehlana fegim afa gwesim nem gosunig. ");
INSERT INTO amn_n_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Afa enag el mahim nengigim boiba afa so buyis el nem unenam afa nem enaig sihinaf, og, sona elim siaba so wahiana mahim enaig esoiba afa so nem ahwanefe afa so na ikanam masgim amtakwalig sime wa pegaf. ");
INSERT INTO amn_n_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Afa so buyis el bo nem fane negimba unenaf eba so ne ikanam masgim pega, ma ne enaig eseiba, eba so sonag el nem unenam enaig esonaf og hihe se bo ohuna gosug siawa pega. Ma nem enaig esenaiba eba el so na fane ahgafa ne ehengelni nofug wa unehlag nalig fafe. ");
INSERT INTO amn_n_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Afa el so heafna unehlagim figifukuf eba God ehena unehlagim pigaupif, afa el so heafna unehlagim pigaupig eba God ehena unehlagim figifukuf.” ");
INSERT INTO amn_n_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Afa Sisas buyis awag elim enaig sihifena og, “Ne buyisba ofefiba nofe ka hihem, nilitem, hamagaum, afa gau ninganam enam mugom esen. Eso ehengel so nem mungwag buyis wa uninim gwenaig nem esinif. ");
INSERT INTO amn_n_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Magofi, afa ne buyisba ofefiba eba so na gawig hwainig elim uneni, mong kukwaligni ninga wahigifenam afa nofug hwanigna. ");
INSERT INTO amn_n_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Afa enaig elbi mas nem mungwag enaig esini, eba so na sifakale nengigimba God nem mungo faif mahim bite kifenai lahlag el piske bugiaga ofefiba.” ");
INSERT INTO amn_n_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Afa el mungo Sisas fane waneaufna enag ena mo higinam Sisasim enaig sihi fena og, “El so Godna bog megam saiyego buyis ne eba so ma sifakali.” ");
INSERT INTO amn_n_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Afa Sisas ehem enaig sihifena og, “El mungo ena buyis nalig ofeba enag enaksag elim unetigig. ");
INSERT INTO amn_n_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Afa ehe sufu wahiagim eso heafna gafugag elim ningihiana afa so gafugag el ikagim enaig eso og, ‘Au ambugog mungwali fane ati kukumeig gohug.’ ");
INSERT INTO amn_n_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Afa mungwali el wahigi ehem enaig sihi fini og kam kusig, afa ming el og, ‘Kaba bite ka kigna baimeg wahiag enag ka nanguagim aka, nasabam.’ ");
INSERT INTO amn_n_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Afa ming el og, ‘Kaba bulmakau baimeg enag ka yuwigim aka nasabam.’ ");
INSERT INTO amn_n_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Afa ming el og, ‘Kaba yawo ka angwafig fag na aseg ka bo mo nasabam.’ ");
INSERT INTO amn_n_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Afa so gafugag el ena mo wambinam piske oku misog elim sihina afa misog el ena mom hignam abobugena afa so piske gafugag elim enaig sihifena og, ‘Ikagna ika mungwali mina wehstiatanig so taun mina ahkawag minefe so na ena mina ikafiba afa so na el elig amtakwalignam sulfuaka, nofug kuhlag afa mong wahigifenam so kana lala megam wan sahu ambugog.’ ");
INSERT INTO amn_n_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Afa so gafugag el gwenaig eseg, ehe bonam misog elim, enaig sihifena og, ‘So na esogba ati ka gwenaig eseg afa mas lala megim yuhwa gohugeg mo.’ ");
INSERT INTO amn_n_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Afa amunai el piske gafugag elim sihina og, ‘Taun mo wahianam so na minahug mina aso bog mina ika nangwagnam eso ne kifutig mo faim so ma kana lala yuhwa gohugei. ");
INSERT INTO amn_n_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Afa ka nem osihin, mungwali el so ka gofgam unenig eba mas kana fane wesig ahgai.’” ");
INSERT INTO amn_n_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Sisas nubwel elim wan ikafnaba wahigi enaig sihifeni og. ");
INSERT INTO amn_n_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Eba amanba ne kam pahluku obofiba so na kam hugna membena. Afa nimbiafna humuan, afahumuan, angwafig, luwal, nilite, mulwal afa nimbeafna nofkenagag so na ena mo sumi yi memben, Afa aman enaig eseg hwanigba eba enaig elbi mas kana pahlukuiag elbi fei. ");
INSERT INTO amn_n_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Afa aman so hefum wahagim numwehiageg hwainig kam pahluku obofimba, enaig elbi mas kana pahlukuiag elbi fei. ");
INSERT INTO amn_n_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Afa so aman nengelnai ogna lala nimba enaig elbi so ateaho gagim numweheg onigugeg og, lalaba enaba kigba yuhwa fei me awai, awai me? ");
INSERT INTO amn_n_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Afa mas yuwana enaig onigugba fei, eba gweyi ikagna sumil guwatigig afa mas ena lalaba auwigi, afa so el enam nanguigim ehem moalabunug. ");
INSERT INTO amn_n_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Afa so ehengel enaig esogog og, sonag elbi lalaba esegim mas auwigig mo. ");
INSERT INTO amn_n_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Afa misog el ogna ming misog el i fagna ahskotigi enag gahba onignageg ehena amibi 10 tausen ami feg afa ming misog elni amibi eba 20 tausen enaig ami feg enag ehe ogna anwanafenam eso fagna ahskotigi ateamba ehem filafe fati me awai, awai me? ");
INSERT INTO amn_n_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Afa so ehe enaig onigigfef, og, mas yuhwafei eba mahim fagule wahigwa fifibi eso elim ningitigif og so ma mo fighunam sihibi soma fagna hagigim awaie. ");
INSERT INTO amn_n_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Afa enaig feg so nengelnai aman heafna mungwali gawigim masgim fatiag hwainig fef eba mas kana pahlukuiag elbi gofi.” ");
INSERT INTO amn_n_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Afa Sisas enaig esona og, “Solba lahlag ehe, afa so solna miaklag awaief eba so big ahanaig esibi so ma piske miaklagwa fei? ");
INSERT INTO amn_n_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Afa enaig solba mas fanem esenaiba mas lahla fei. Eba hugunam amtakwaleagegba el isugum fatig. El angnaba so na ena mom higim.” ");
INSERT INTO amn_n_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Afa moni wambug el i afa ahanaig ahanaig nihenai el i ambugog muhwa agfohiafnaba Sisasna mo higfafna. ");
INSERT INTO amn_n_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Afa Farisi el i nihemo anwanag el i olug kakageaginim og, “Mangigim Sisasba ehengelimbi hihe fenigim afa faneba wan one.” ");
INSERT INTO amn_n_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Afa mahim enaig esinibi eso Sisas waskwes mo sihina. ");
INSERT INTO amn_n_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Og, “Eba el nengelnai 100 sipsip feg afa mahim mungo mo awaiegba afa so 99 mungo agfohieba faneba ahu ahgage agfo. Afa enag el mas wahiai eba mahimsi yisgegohug eso ufag. ");
INSERT INTO amn_n_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Afa ufagim eso fokwag ohumbug wa kufehlag ombuahba ehe mo sifakale bo. ");
INSERT INTO amn_n_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Afa mahim lalagam obugum eso heafna hihem afa mungo kimbig wanaim unetigigim og, ‘Au ambugog nawo sifakali kana sipsip mungo awaiena ati ka piskeg ufagim sulufa obug.’ ");
INSERT INTO amn_n_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Sisas enaig esona. Ka nem inim osihin ahanaig sifakal so hevenwaba puguf eba mahim mungo el amtakwalig nihe nai olug wahigifeg eba nalig feg, afa enaig sifakalba 99 elbi gwenaig lahlag agfohie eba gweyiagig feg. Afa el so amtakwalig nihenai so olug wahigi ofe enaba naho ehem hugunam sifakalinig.” ");
INSERT INTO amn_n_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Afa Sisas enaig sihifena og, “Angwafig sambaga ningam pugufewagig kig enaig feg afa mungo awaieg lala wa afa so ehe wi gafagim pupohiageakahba mahimsi yisgiego, feg feg ufagim. ");
INSERT INTO amn_n_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Eso heafna hihem afa mungo kimbig wanaim unetigigim og, ‘Ei au ambugog nawo sifakali kig mungo kana awaiena ka yisgiegohug ati ka piskeg fag’” ");
INSERT INTO amn_n_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Afa Sisas enaig esona og, “Ka nem yuhwa mo sihinig. Enaig sifakalba eba gwenaig Godna ofwanai el gaba esig mahim amanba olug wahigi feg Ainiyagna mina gamba puguba.” ");
INSERT INTO amn_n_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Afa Sisas piske enaig sihigena og, “El sambaganigi luwal feg. ");
INSERT INTO amn_n_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Afa so sumineg enaig esona og, ‘Humuan ka onigig, kam gwese mungwali gawig mimangetiginuge, fi kam fai afa kikeafna etegim fai, kamba yawu so faim’, eso awag gwenaig eseni. ");
INSERT INTO amn_n_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Afa managig hwainig suminegba heafna mungwali gawig elim mimagen kafnaba enananam kig mo wambunam afa so eheba wahigwa kimbig gam ikana, ika enanai esegofnaba heafna kigba mungwali taituf awaie fatina. ");
INSERT INTO amn_n_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Afa mahim kig awaienaba, afa so bini nalig ena kimbig pugunaba ehem bini hugunam wahanaba eso pugu elim gafugagim sahinugea ikafna. ");
INSERT INTO amn_n_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Sahinugeakan el mungo tatam wangafna enag fa tata gafugag wa ningihiana og, ma tatam nangwaghige gofi. ");
INSERT INTO amn_n_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Afa eheba tatam fane fainim mahim ahgageafufnaba afa tatam nangogawan mahim ehem bini wahanaba eso ogna tatana fane wambenefena afa mas aman fane faina mo. ");
INSERT INTO amn_n_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Afa so gan gweyi oniginam esona og, ‘Afa kana Humuana gafugag elni mungwaliba eba faneba nalighe gohun, afa ka ohuna nai yi gahba kam bini hugunam wahageg. ");
INSERT INTO amn_n_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Magofi kawo Humuan nangum piske ika, ka ikanam ka so Humuanim enaig sihifena Humuan, ati ka nem mi God mi amtakwalig nihe ka nem fenig. ");
INSERT INTO amn_n_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Afa kaba mang lahlag el mo na ne kam kana luwal moawonai, se kam isug wahiaiba ka so neana gafugag el lofei.’ ");
INSERT INTO amn_n_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Eso gwenaig esena bihianam Awag nangum ikana, afa mahim wahigwa feafnaba, Awag nangunam afa hugna sifakalinam eso kikini ikan heafna legim ningana pugufenam afofafena feafana. ");
INSERT INTO amn_n_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Afa leg enaig esona og, ‘Humuan, kaba ati ka nem mi God mi amtakwalig nihe ka nem fenig. Kaba mang lahlag el mo na ne kam, kana luwal moawona.’ ");
INSERT INTO amn_n_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Afa so awag heafna gafugag elim unenim enaig sihifeni og, ‘Ikagna ahu kwieg lofug kikeafna fambugu fatini afa kig wesig ningabuli yi fatini afa mog lofug mong yi fatini. ");
INSERT INTO amn_n_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Afa ahunam bulmakau ambag sulufu wanig ambugonam so tigi, nawo ahganam so sifakali. ");
INSERT INTO amn_n_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Afa enaba eba ohuna luwal kana ati awaiena afa yawaba ati piske bog nofkikena gohug. Afa mas awaieg mo.’ Afa so nalig fane ahgamine fenam eso sifakalini. ");
INSERT INTO amn_n_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Afa enenamba eba ehena etegba aso wa gan so bona afa bo muhwa pugunaba heafgelni lala muhwa afa so buyisna auneh higna. ");
INSERT INTO amn_n_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Afa so gafugag elim unena, ma bonaba eso sahnagena, og, ‘Sonaba mang ofi?’ ");
INSERT INTO amn_n_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Afa gafugag el ehem sihina, og, ‘Eba neana sumineg ati piske bo pugugba enaig neana awag bulmakau ambag tigeg. Enaba awag legim nangugim sifakaleg, luwal mas awaiena mo afa eba ati piske bo pugug.’ ");
INSERT INTO amn_n_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Afa eteg ena mo higinam olug kakageagena mas lalagam sawiyifei ikana mo eso awag pugu afwabagam bona motitfenagena, og, ma eiyi ehena olug efihiahlai. ");
INSERT INTO amn_n_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Afa eheba wahigi awagim enaig sihifena, og, ‘Ahnaig eseg? Sa kaba enaksag yiawaba ka neana gafugagim ehegepuseakag, ka ofe naiba isug gafugag el lofeg, afa ka mas neana mom flafui, afa ne mas kam ahnana mo meme luwalig faina mo afa mas ka kikeafna hihem enaig sifakal ka wan feg mo, eba awai. ");
INSERT INTO amn_n_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Afa sona luwal kikeafna sumineg so eba mungwali gawig neana okug ahanaig ahanaig wa taitufeg wahiagim eso piske yawa mo bogba ne ehem sifakalenagim afa ne bulmakau ambag tigeg.’ ");
INSERT INTO amn_n_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Afa awag ehem enaig sihifena og, ‘Luwal higeg ati big ahagag mungwali gawig so kana feg eba neana. ");
INSERT INTO amn_n_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Afa yawaba nawo sifakali so ma bigna olug lahla fei neana sumineg ati ika awaiena afa yawaba piske bog nofkikena gohug, afa big ehem suluofig.’” ");
INSERT INTO amn_n_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Afa Sisas heafna pahlukuiag elim enaig sihifeni og, “Amunai el heafa ati fahigeawagig el fena, afa enag mingnag el ambugonam ehena amunai elim sihini og sonag fahigeawagig elbi neana gawig isug awaieg fatig. ");
INSERT INTO amn_n_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Afa eso amunai el fahigeawagig elim unenam ma bonaba eso sihina, og, ‘Ka neana ohunaig nihe mo higig? So na ikanam kana mungwali gawig so na wambugena so na enam sihiage. Afa mas ne enaig gafugaba piske fei.’ ");
INSERT INTO amn_n_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Afa so fahigeawagig el hefum enaig esona og, ‘Afa so ka ahanaig esef? Afa kam amunai el ogna fahigeawagig gafuga wanaim ningihia, afa ka mas kifutig mo namo ka so aman elniba ika bite tutohiagig gafugaba fegofi, afa ka elni kig mungunim fagim kam ahwanifeg. ");
INSERT INTO amn_n_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Afa yawu ka onigig, ka mang fegimba, mahim kam amunai elbi enaig gafuga wanaiba ningihiaiba so ma el kam kweagfui.’ ");
INSERT INTO amn_n_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Afa so mungo mungo elim unenugenaba eso ambugona, ehengel so amunai elni gawig isug wambugini, afa mungo el bo gof pugunaba, eso fahigeawagig el ehem sahna, og, ‘Ne ahanansi kana amunai elni gawigba isugba fana.’ ");
INSERT INTO amn_n_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Afa wahigi ehem sihina, og, ‘Pepa enaig sihifeg 100 wel dramna’ afa fahigeawagig el ehem sihina og, ‘Afa so na susulenam ikagna 50 dram ginofe.’ ");
INSERT INTO amn_n_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Afa ming el sum bo pugunaba afa fahigeawagig el ehem sahna og, ‘Nana isug fag gawigba ahanansi’, afa sihina og, ‘Pepa enaig sihifeg 100 wit bekna,’ afa fahigeawagig el ehem sihina og, ‘Afa so enag pepa nem fainiba afa ne 80 bek ginofena.’ ");
INSERT INTO amn_n_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Afa so sumi yi amunai el ati ehena enaigim anwanafenam og, ‘Sonag elbi lahlag elho fegim afa eba heafna onigigim goseg okug.’ Afa bitenai nihenai elni onigig eba afambusug elni onigigim gwesim gosunug bitenai gafuga figibi.” ");
INSERT INTO amn_n_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Afa Sisas sihini og, “Afa ne bitenai gawigim kikehli gafuga feagfohba nog so ma kam el muhwa fegoni, afa sona gawigba eba mahim autunai wa awaieba eso God nem sulufunim ahu lala higeg gohug wa lahlag auguiafuf. ");
INSERT INTO amn_n_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Afa mahim aman mungo mungo gawigimba numwehiage akafi eba enaksag gawigim gaba gwenaig eseg. Afa so aman mas wesig nihem yuhwafei eba nalig nihem gaba gwenaig eseg. ");
INSERT INTO amn_n_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Afa eba ne ohuna bitenai gawigim numwehig hwanigba eba aman so nem heven wanai mang lahlagba faibi so na ninumwehige? ");
INSERT INTO amn_n_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Afa eba ne mingnag elni gawigim numwehig hwainig fif, eba aman so neana gawigba nem faif? ");
INSERT INTO amn_n_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Afa mas aman sambaga misog elni gafugaba fei eba aman misog el so ehem lahla feafag, eba naho ehena mo higigim pahlukug, afa aman misog el so mas ehem lahla feafai eba ehena mo mas hignam pahlukui, afa eba amani mo ahnai skaug fenaiba afa amani mo mas fatinafe, afa nofe ne God mi bitenai gawig mi wahi.” ");
INSERT INTO amn_n_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Afa Farisi elbi hugna kigim onigahu, afa ehengel ena mungwali mo higinim, mahim Sisas sihiagenaba afa so Sisasim moalabuni. ");
INSERT INTO amn_n_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Afa Sisas enaig sihifeni og, “Nengel ne enaig onigig nog elni nof wa kikeahba lahlag nihe feahu. Afa eba God ati neana olug onigigimba anwanafenig, afa enaba ne onigig eba lahlag, afa Godna nofwaba eba amtakwalig. ");
INSERT INTO amn_n_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Afa nihe mo i mo fa sihiaule elni mo i gwese gohug ikag Jon pugu gohug, afa enanaiba Godna bog meg lahlag mo mungwali kimbig opugu ka afa so mungwali el hugunam kifutigim gafuga fig ogna ahu Godna bog megam saho gohum. ");
INSERT INTO amn_n_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Afa of i bite i eba ika awaief afa wetiklug ginofba Godna nihe moba mas awaie eba gwese gofuf. ");
INSERT INTO amn_n_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Sisas enaig esona og, aman so heafna angwafigim hwaiyunam afa ming angwafig fafe, enaig elbi eba aga taitug el. Afa aman so angwafigim hwaiyu fatif afa so ming el fafe ehe gaba aga taitufeg el.” ");
INSERT INTO amn_n_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Afa autunam el mungo gawig numbni fena eheba lahlag lofug yimieg aitiagefnam afa fane lahlag negeaufna. ");
INSERT INTO amn_n_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Afa ehena lala mengig muhwaba eba el kukwalig enehna gafna ehena unehlagba Lasarus, ");
INSERT INTO amn_n_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ehe enaig onigina og ma gawig numbni elni fane ogug sime skaug apaigofiba ogna so wambinefefum afa so mawang ambugofnam ehena nehugugum libeahga fifni. ");
INSERT INTO amn_n_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Afa so gof mahim ehem wahanaba, Godna ofwanai el ambugog wanigahunaba eso ika Abraham mi ahagafnaba afa sumi yi gawig numbni elim wahanaba eso fakini. ");
INSERT INTO amn_n_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Afa so ehe ika tautig kimbig pugunam eso onigigaufna afa so gweyi sisigam ninofenaba Abraham mi Lasarusi wahigwa ahagafna. ");
INSERT INTO amn_n_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Afa so enaig unefena og, ‘Humuan Abraham kam afafenam eso Lasarusim ningihiaba so ma kam bu ningabulni figihiana obu mileg wa fakanaiba so ma kam liputi. Ka sahug suwi ihnol megam goba afa kam tautigfiageg.’ ");
INSERT INTO amn_n_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Afa Abraham ehem sihina og, ‘Luwal so na onigim, afa ne nofkikenaba gofnaba mungwali gawig ne nimbefum mungo ne onigina afa Lasarusba eba amtakwalig mungwali ehem pugunagena. Enag yawaba bog ohuna kimbig wa lahlag ga, afa neba tautig amtakwalig ne afa. ");
INSERT INTO amn_n_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Afa mingba enaig eseg, God bigim bite olyi kowaugug fakanig afa nengel ne mas kagel nangum peifambufi ambugoi afa kagel ka mas peifambufi nengel nangum gaba ahui.’ ");
INSERT INTO amn_n_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Afa gawig numbni el enaig esona og, ‘Humuan ka nem enaig sahna ofena so na Lasarusim ningihiaba so me kikeafna Awagna lalagam ikai. ");
INSERT INTO amn_n_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Afa kana niliteba afawa pugufeg Lasarus so ma ika kifutig mo faibi eso ma amtakwalig nihem wahinim olug wahgifi masa ambugog ohuna kimbig wa tautig fif.’ ");
INSERT INTO amn_n_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Afa Abraham esona og, ‘Mosesna mo i afa mo fiule elni mo i so ma numwehe angug wabuihaginim ohuna moba higi.’ ");
INSERT INTO amn_n_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Afa gawig numbni el esona og, ‘Humuan Abraham sonaigba ahanaig esi mo eba aman sati wahag enag ehe so ma piske bitekfenai puguna ika sihinibi eso ma olug wahgifi.’ ");
INSERT INTO amn_n_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Afa Abraham ehem enaig sihifena og, ‘Afa so Mosesna mo i afa mo fiule elni mo i higig hwanigba fif eba melig wahag el gaba ika sihinibi mas olug wahgifi.’” ");
INSERT INTO amn_n_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Afa Sisas pahlukuiag elim enaig sihifeni og, “Ahnaig ahanaig nihe amtakwalig pugunam elim esenagba so el enanaig amtakwalig eseagig, afa sonag el so na ming elim esenagba eso enaig wa peg eba nasabam. ");
INSERT INTO amn_n_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Afa ateamba el luwalim enaig nihem wagfunagba afa so luwal enaig wa pef eba se hun naligna weana kikenagim eso bugam fatibi so ma wahai, sonaigba eba lahlafeg. Masa enaig hugna amtakwalig eseagef. ");
INSERT INTO amn_n_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Afa nimbefum mo numwehigibi. Afa neana nilite so amtakwalig nihefef eba so na niheangu, afa ateamba olug wahigi ofefi eba so na mwanugwefena. ");
INSERT INTO amn_n_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Afa so nem elegeg wa gohug amtakwalig nihe mungo osuna esenafnam afa bofnam nem sihinagofuf og ka nem amtakwalenag se mwanugwefenafim.” ");
INSERT INTO amn_n_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Afa pahlukuiag el Ainiyagim enaig sihififni, og, “So na kagelni olug onigigim esenibi so ma gwesim ikafum.” ");
INSERT INTO amn_n_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Afa Ainiyag ehem enaig esoni, og, “Magofi, ma ateamba nengelni olug onigig wesig fegba eba ofenaiba ambwe sisig lofug. Eba so na yuhwafif, so na liim sihini og susum fagahu ika solwarawa pegofum afa so libi nengelni mo hignam eso gwenaig eseg.” ");
INSERT INTO amn_n_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Sisas mo gwesim hili enaig sihifena, og, “Ma ateamba neana gafugag el fegba so ma ika bite gafai me awaie sipsipim nangwaghiage me so ma enaig ese. Afa mahim sonag gafugag elbi piske lalagamba obofiba so na ehem enaig sihibafe enai og, ‘Au ikagna bo ganam fane ne. So na enaigba esoi? Eba awai.’ ");
INSERT INTO amn_n_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Afa eba so na enaig sihifena, og, ‘Ne kana fane numwehiaginim afa so na kam fambofena, ka ma kawo gof fane i bu i nageiba eso nawo sum nage.’ ");
INSERT INTO amn_n_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Afa so gafugag elbi sohnaig gafugaba feageiba so amunai elbi ehemba lahlag onai? Ena gaba awai. ");
INSERT INTO amn_n_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Afa nengel gaba gwenaig, ateamba ne mungwali gawig esig auwigibi, God so nem sihinig, so na enaig esog kaba gafugag el ehe ohunaig so ka esigbi eba kangelni gafugag mungohe.” ");
INSERT INTO amn_n_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Sisas Jerusalem minam pahlukuna, distrik Samaria gini afa Galili gini ena olyi ikana. ");
INSERT INTO amn_n_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Afa ika mungo kimbig wa pugunaba, afa ningam pugu fewagig el enehna ambugog mina wa wambug. ");
INSERT INTO amn_n_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Afa ambugog wahigwa yi agfohieafnaba hugunam enaig esogona og, “Sisas ainiyag so na kam afafen.” ");
INSERT INTO amn_n_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Sisas nangwagnam enaig sihifeni, og, “Ahunam pris elim nihigoni eba ati neana elig lahlafeasaig so ma enam anwanafi. Eso ahuna afa ahuafnaba ehengelni elig ati lahla feskofena.” ");
INSERT INTO amn_n_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Afa ehengelinai mungo heafna eligim nanguna ma lahla fenaba eso wahigefe piske ikafnaba Godna unehlagim fingi fukuna. ");
INSERT INTO amn_n_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Afa ehe ikan Sisasim muhwa fenam eso mongkokini kwakwagena nofbosug mo bite wa fisihli pena Sisasna kigmogwa. Afa so Sisasim lahlag ogna. Enag elbi Samarianai. ");
INSERT INTO amn_n_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Afa Sisas enag elim nangunam afa esona, og, “10 pela el ati lahlafeg afa mingnag 9 wa gohug elbi ahnanai yi agfohie. ");
INSERT INTO amn_n_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Afa mas aman el piske bog Godna unehlagim fingi ofe mo? Afa ohunag el mungo eba heafa afwamba nai el enag mungo eseg?” ");
INSERT INTO amn_n_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Afa Sisas ehem sihina, og, “Sa bihia ika. Eba neana olug kam oniginag nem esenagba nem lahlafeg.” ");
INSERT INTO amn_n_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Afa Farisi el Sisasim enaig sahnafini og, “Amansi so Godna bog megba bof?” Afa Sisas wahigefe enaig sihifeni, og, “Afa mahim Godna bog megba bogba afa mas mangwalba wagfuiba elbi mas nofnaba nangug mo? ");
INSERT INTO amn_n_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Afa mas enaigba esogoi, og, so nangu ohuna nai yi goh me awai okwe nanai yi me, so hig Godna bog megba ati neana olug yi wahigi goh fakanig.” ");
INSERT INTO amn_n_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Afa Sisas heafna pahlukuiag elim enaig esoni, og, “Sumi yi mahim enaig opugufiba nog ka Inim El heafna osuna bo puguiba ne enam mas nanguf. ");
INSERT INTO amn_n_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Afa so nem sihigonif, og, Inim Elbi okwesimhe amo ohuna nai yi afa nofe ka pahlugahu. ");
INSERT INTO amn_n_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Afa ati ne afwe anwanafig afwe ofim mungwali mugyi kugofakagba eso of afwambusig fakag. Afa mahim heafna osuna obofiba eso gwenaig eseiba so el nanguf. ");
INSERT INTO amn_n_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Afa yawo ohuna nanam el mahim ehem mas fatinibi afa so enaksag tautig fafe. ");
INSERT INTO amn_n_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Afa yawana so Noana el esini ahanaig ahanaig nihefeagini, yawoga eba gwenaig esif mahim Inim El heafna osuna obofiba. ");
INSERT INTO amn_n_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Afa yawana so Noa wangafnaba enenaba ehengel enaig esini fane i bu i ahgafena afa angwafig wambugifni, gwenaig gafugag wa agfohieafnaba Noa ehe mo sip megam wan sahonaba eso sona elim mo bu pugu mungwali sagfa kumoahlana. ");
INSERT INTO amn_n_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Afa mingnag elim gaba gwenaig eseni eba Lot gofnaba enenam, aso gafugafea gifini afa angwafig wambugifini afa gawig gafugafifni afa bu ahgagifni afa lala nimbagifni enaig nihe wa gofna. ");
INSERT INTO amn_n_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Afa Lot Sodom kimbig wahia ikafnaba afa gwenenam suwi ofwanai pena, elim mungwali wa kumoahlana. ");
INSERT INTO amn_n_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Afa eba gwenaig mungwalofug puguf mahim Inim El piske bo ambagwa opugu fiba. ");
INSERT INTO amn_n_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Afa enag osuna el so lala gofif mas heafna gawig wambugumba ikai, afa el so aso wa gofif eba mas lalagamba piske ikai. ");
INSERT INTO amn_n_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Afa so na Lotna angwagim onigim mang mahim fena. ");
INSERT INTO amn_n_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Afa aman so nibeafna nofkikena gagim ne nibefum kehla guhmine fefuf eba neana nofkikena gag awaief. Afa aman so heafna nofkikena gag isug wahiaf. Eba ehena nofkikena gag gwese lahlag gofuf. ");
INSERT INTO amn_n_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Afa ka nem osihin Inim El so bof. Eba el so sambagana mungo kug wa ahgi eba God amanim mo suluafaiba afa amanim mo wahiaf. ");
INSERT INTO amn_n_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Afa angwafig sambaga amba na ahsine gofuf eba God mugom suluafaiba afa ming mo wahiaf. ");
INSERT INTO amn_n_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","(Afa sambaganigi el aso wa nog yihig ahfe gofuf eba God mungom suluia faiba afa ming mo wahiaf.)” ");
INSERT INTO amn_n_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Afa pahlukuiag el ena mo hignim Sisasim sahni, og, “Ainiyag ahnanai yi?” Afa Sisas enaig sihifeni, og, “Ahana nai yi suwieg ne nangug eso ne anwanafig eba suwi eyi wagi.” ");
INSERT INTO amn_n_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Sisas ming waskwes mo pahlukuiag elim sihinim afa betenegim wagfuni og so ma higeg beteneahufi masa esi yisgosif. ");
INSERT INTO amn_n_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Afa enaig sihifeni og “Afa Jas kimbig wa gafna ehe mas Godum onigina mo afa elim gaba mas hugna onigini mo. ");
INSERT INTO amn_n_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Afa so angwafig mungo ena kimbig wa fena ehena awagagba ati wahana enag bofnam Jas elim sihinafna og so ma kam kweagfui, ehe enaig esona og, ‘El kam amtakwalefig so na kam kot wa kweagfu.’ ");
INSERT INTO amn_n_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Afa Jas yuwana mo mas ehem kweagfuna mo afa sumi yi ehe enaig onigina og ka mas Godum oniginai afa elim gaba ka mas onigini. ");
INSERT INTO amn_n_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Afa enag angwafig kam higeg kinig fafaiefgu. Naiba ka kweagfu, kam ehena mo higohugum yiskoseg, masa higeg fabofe gofif.” ");
INSERT INTO amn_n_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Afa Sisas ming mo gwesim hilifena enaig sihifeni, og “Sa ohuna mo higim amtakwalig Jas elni mom. ");
INSERT INTO amn_n_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ateaho ne onigig? God ogna heafna elim kwagani me? Enag ehengel higeg osuna afa sinaini mahimsi Godum sahnahufiba afa God mas yiskosei. ");
INSERT INTO amn_n_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Afa ka nem sihinig eba ehe ikagnam kwaganf. Afa so ma Inim El bonam nangwagi, bitenai el ateame olug onigig nafig me awai awai me?” ");
INSERT INTO amn_n_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Afa mingnag el onigig og eba lahlag elba afa mingba mas lahlafeg mo afa Sisas enaig waskwes mo sihina, og, enaig el feg, ");
INSERT INTO amn_n_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Sambaganigi el ogna Godna nalig lala beten ahfe. Elbi naba Farisi el i afa kig wambule el i. ");
INSERT INTO amn_n_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Afa Farisi el gofnaba hefum beten ena, og ‘God ka nem lahlag onag kaba mang mingnag el lofug mo. Mingnag elbi ahanaig ahanaig el ehe okwefihug afa angwafigim ligag wanaim aga taitufegonahu. Afa kaba mang sohnaig el kig wambule el lofug mo, kaba enaigba awai. ");
INSERT INTO amn_n_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Afa mungwali wik sa ikaiba ka sambaga osunam sufu wahiagim afa ka fane kwegigi. Afa ka mangwalba fagim afa ka mimageg nem mungo ehegenai faig.’ ");
INSERT INTO amn_n_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Afa kig wambule el mo wahigwa yi gofnaba, ehe mas sisigam ninofena mo eba awai. Eba ehe angmu waginam enaig esona, og ‘God, kaba mang lahlag el mo, kaba nuhwefni amtakwalig el, so na kam afafena.’” ");
INSERT INTO amn_n_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Sisas sihini, og, “Ka nem osihin kig wambule elbi piske heafna lalagamba ikanaba eba Godna nofwa lahlag el fena. Afa ming elbi eba awai, eba enaig eseg, amangel so heafgelni unehlagim fingifig eba God ehengelni unehlagim pigaupenif. Afa amangel so heafgelni unehlagim pigiupigog eba God ehengelni unehlagim figifugunif.” ");
INSERT INTO amn_n_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Afa so afahumonig luwal witatanigim Sisas nangum wanabugona, fig ninganai luwal. Afa ehe apaigo ahuag luwal enaigim wanabugona og so ma Sisas ningabulni tutuhenugei. Afa pahlukuiag el nangwagnim ehengelim fegonigini. ");
INSERT INTO amn_n_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Afa Sisas luwalim uneni mahim ambugog muhwa ehem finibi afa so wahigefe pahlukuiag elim enaig sihifeni og, “Nofe ne luwalimba kwegon ma ka nangum ambugoi afa Godna bog megba eba enaig elni. ");
INSERT INTO amn_n_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Afa ka nem inim sihinig afa aman el so luwalna onigig lofeg hwainig eba mas Godna bog megamba seahui.” ");
INSERT INTO amn_n_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Afa amunai el Sisasim enaig sahnafena og, “Lahlag wagfuiag el ahanaig so ka esenam eso ka higeg nofkikena gagba fafe?” ");
INSERT INTO amn_n_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Afa Sisas ehem enaig sihifena, og, “Mangigim ne kam lahlag onag, eba God mungo he lahlagba feg. ");
INSERT INTO amn_n_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Afa ateaho ne nihe moba anwanageg, og kwamblo so angwafig nafig nofe ka aga taitufi afa elim kwagaitifi afa okwefi afa elim mwakwalinim kotimini. Afa so na awag afagim ahnai skaug fegonim afa ehengelni mom pahluhugoni.” ");
INSERT INTO amn_n_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Afa amunai el enaig esona, og “Ati ka wesig wa ena nihe moba pahluku bog, ka bog kwamblo wa pugug.” ");
INSERT INTO amn_n_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Afa Sisas ena mo hignam afa ehem enaig sihifena, og, “Nasabam mangsul so nem awaienag, so na nibeafna mungwali gawig mingnag elim mimagenige eso ne kig fanam so na gawig hwainig elim ena kig mo faim ne enaigba eseiba eba ne heven wanai lahlag gawig fafe, eso kam pahlubu.” ");
INSERT INTO amn_n_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Afa amunai el enaig mom hignam ehem olug kiniagena enaba ehe so gawig numbni fena. ");
INSERT INTO amn_n_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Afa Sisas ehena olug kinigim nangunam afa enaig esona, og, “Amangel so gawig numbni feasaig enaba Godna bog megam saiyegim ehem ehegepusig feasaif. ");
INSERT INTO amn_n_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Afa kamelba tata lofug ogna lofug kwelig nilni megam sahu eba ehegepusig. Afa gawig numbni el, Godna bog megam ogna sahu eba ehe hugunam gihig.” ");
INSERT INTO amn_n_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Afa el ena mo hignim enaig esogona, og, “Afa ma ateamba enaig esegba, afa so aman yuhwafenam eso nofkikena higeg gagba fafe?” ");
INSERT INTO amn_n_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Afa Sisas sihini og, “Elbi ahanaig esi mo, God eheba so enaigba esei.” ");
INSERT INTO amn_n_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Afa Pita enaig esona, og, “Sa hig kagelbi ka kikeafna kimbig i gawig i ka hwatigim ka nem pahluambugog.” ");
INSERT INTO amn_n_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Afa Sisas esoni, og, “Ka nem inim osihin amangel so Godna bog megim onigig eba naho heafgelni gawig i angwafig i luwal i afahumonig i afa nilite i enam hwatiagigim ambugog. ");
INSERT INTO amn_n_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Afa mahim ohuna bite wa mahimsi gofiba God enaksag gawig faif ena gawig eba gwesim gofanaim kwegfugkag afa mahim sumi yi enaig puguiba eso el nofkikena higeg gag fif.” ");
INSERT INTO amn_n_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Afa Sisas 12 pela pahlukuiag elim sulfahunam afa so enaig sihifeni, og, “Sa hig, yawo big Jerusalemgam ahuofe. Afa enaba autunam Godna mo fi sihiaule el ati mungwali moba ginofi wahini, og ohunaig so Inim Elim pugunafe, eso inim gwenaig pugu ofena. ");
INSERT INTO amn_n_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Afa eba ehem angoluwag elni ningala wahibi eso ehem moalapinaginim afa mep kusufinif. ");
INSERT INTO amn_n_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Afa nasna wena flaflakenaginim eso tigi fatif, afa eba mahim sambaga mungo osuna feiba eso piske buihiaf.” ");
INSERT INTO amn_n_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Afa God ena mom meagam kumoahla gufna eso pahlukuiag el enanam mas numwehi enag mog mom anwanafini mo. ");
INSERT INTO amn_n_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Sisas ika Jeriko kimbig wa opuguhuaba, afa nofug kuhlag el mina meigim wa gafnaba elim lofug kamini afa kig kamini fenigeaufna. ");
INSERT INTO amn_n_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Afa higinaba el numb moauf watini fambuafna afa so mingnag elim sahini, og sonaba mang ofi? ");
INSERT INTO amn_n_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Afa ehem sihini, og, “Sisas Nasaret wa nai obo” ");
INSERT INTO amn_n_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Afa so Sisasim unena, og, “Sisas, ne Devitna simbianiga kam so afafena.” ");
INSERT INTO amn_n_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Afa mingnag el gosuf ambugog ahuafnaba ehem fenagini og is mwahlai gafim afa eheba hugunam amboitinina unenam afa enaig esona, og, “Devitna simbianiga kam so afafena.” ");
INSERT INTO amn_n_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Afa Sisas gofnaba elim sihini og osum wanigambugo, afa mahim nofug kuhlag el ika muhwa pugunaba afa so Sisas ehem enaig sahnafena. ");
INSERT INTO amn_n_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Afa ahanaig so na kam og kam esena.” Afa esona, og, “Ainiyag, ka enaig onigig kana nofug ma bahiyi.” ");
INSERT INTO amn_n_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Afa Sisas ehem sihina, og, “Nana nofugba eba enaba lahlafefe. Afa nibeafna olug onigig nem esenaiba eso nem lahlafefe.” ");
INSERT INTO amn_n_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Afa so ehena nofug gweyi ikagna bahiyinaba afa so Sisasim pahlukunam Godna unehlagim figifukuna, afa mungwali el enam nangunim ehengel gaba Godna unehlagim fingifini. ");
INSERT INTO amn_n_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Afa Sisas ika Jeriko kimbig pugunam ikafnaba ogna Jerusalem kimbig gam ika. ");
INSERT INTO amn_n_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Afa el mungo ena kimbig wa gafna ehena unehlagba Sakias eba kig wambugule elni misog el afa ehe enaksag kigna fena. ");
INSERT INTO amn_n_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Afa enag ogna Sisasim nangu, og, ahanaig el mahim, afa mahim el numb Sisasim kagunibi gihigegfohun aseg nangwag mo. Eba tumog el fena. ");
INSERT INTO amn_n_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Afa so gof ikanam fik liyi fukonam gafna ogna Sisasim nangu, ati anwanafena, og Sisasba ohuna mina bof. ");
INSERT INTO amn_n_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Afa Sisas ika enanai yi pugunam eso liim fahigeagena mahim Sakias gafnaba so Sakiasim enaig esona og, “Sakias, au ikagna pebo yawaba ka neana lalagam ahkagim.” ");
INSERT INTO amn_n_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Afa ehe ikagna penam. Afa so ehena olug kiafigigeafnaba eso Sisasim sulufana lalagam ahkana. ");
INSERT INTO amn_n_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Afa mungwali el nangwagnim heafgelni olug yi enaig esogona, og, “Ei, sohnaba amtakwalig elni lala ika ga.” ");
INSERT INTO amn_n_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Afa ahka lala ahagafnaba eso Sakias bihianam enaig esona, og, “Ainiyag so hig, ming gehnai ka elim gawig hwainigim mimagenif. Afa gawig so ka okwefen ikafna eba ka piske sambaga sambaga fenif.” ");
INSERT INTO amn_n_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Afa Sisas ehem enaig sihifena og, “Yawo God ati ohuna lalanaiba mungwali elim wambug. Sohna el gaba eba Abrahamna luwalig. ");
INSERT INTO amn_n_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Inim Elbi eba el so awaie saigog enam yisigin bog ogna piske wambum.” ");
INSERT INTO amn_n_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Afa mahim Sisas mo sihiagofnaba el ena mo higahufna, afa so Sisas waskwes mo enaig sihifeni, og, eba ati Jerusalemgam ika puguagim muhwa fena. Ehengel onigini og, eba Godna bog meg ambagwa ikagna puguf. ");
INSERT INTO amn_n_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Afa Sisas enaig esona, og, “Amunai el so ogna wahigam kimbig gam ika eba enanai yi so el ehem misog el wahif. Afa nengigimba eba piske bonam eso heafna kimbigim nangwaghiagef. ");
INSERT INTO amn_n_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Afa mahim akafiba eba heafna gafugag elim ningam pugufewagig enaig elim unetiginam eso kig mimagenim afa so enaig esonif, og, ‘Ena kig ne wambinim eso ne gawig enena gafugafeagi mahim ikan enanai yi feiba ka so piske bo.’ ");
INSERT INTO amn_n_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Afa heafna kimbig wanai ehem olug hugunam kagagenagini. Afa mahim ikanaba afa so mingnag el ningitigini, og ma ahu mo sihi, amunai el so ikag ena kimbig eso enaig sihifif og, ‘Kam kusig masa sonag el kagelni misog el fef.’ ");
INSERT INTO amn_n_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Afa mahim misog elim wahiniba eso piske bona ehe bonam enaig esona, og gafugag elim unegon autunam so ka kig faini enag koka anwanafe ahanansi kig mungo mugog el mungwali kikig. ");
INSERT INTO amn_n_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Afa mungo el gosu bonam enaig sihifena og, ‘Amunai, neana kig so ka fag enena gafugafegba ka 10 kig gwesim hilig fag.’ ");
INSERT INTO amn_n_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Afa misog el ehem enaig esona og, ‘Ne lahlag gafugag el ne lahlag gafugafeg. Ne weitiaklugim ninumwehea fagba pugu naligfeg ka nem wahiaiba so na ningam pugufewagig kimbigim nangwaghiage.’ ");
INSERT INTO amn_n_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Afa angigieg gafugag el bona enaig esona og, ‘Amunai, neana kig so ka fag enena gafugafegba ka afawa pugufeg kig gwesim hilig fag.’ ");
INSERT INTO amn_n_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Afa so misog el ehem sihina, og ‘Ka nem wahiaiba so na afawa pugufeg kimbigim nangwaghiage.’ ");
INSERT INTO amn_n_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Afa ming gafugag el bonam enaig esona og, ‘Amunai, neana kig so ka fag enaba hoka ka lofugna kikegim faka wahiag. ");
INSERT INTO amn_n_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Naigba ka esegba eba ka nem enaig anwanafenag ne kifutig mo sihiaule el nafeg. Afa mahim mingnag elbi mangwalba fakigbi afa ne wafaf. Afa mahim mingnag el fane ihigimbi afa ena gaba ne faf. Enag so ka embefeg.’ ");
INSERT INTO amn_n_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Afa misog el ehem enaig sihifena, og, ‘Ne gafugag el amtakwalig nibeafna moawa ka nem kotim enafe. Ati anwanafeg kaba kifutig mo sihiaule el afa kaba amangel so mang sukug enag ka wambug, afa amangel so asona fane ihigig enag ka wambug. ");
INSERT INTO amn_n_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Afa ne enaig eseite so na kana kigba benk wa fakaite. Koka piske bonam eso ming moni nahlum gwesim hilifeg fa?’ ");
INSERT INTO amn_n_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Afa el muhwa agfohiafnaba eso enaig esona og, ‘Nengel so na ehena kig wambug so na faim el so 10 kig feg.’ ");
INSERT INTO amn_n_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Afa enaig esogona, og, ‘Amunai sonag elbi ati 10 kig feg.’ ");
INSERT INTO amn_n_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Afa esona og, ‘Ka nem osihin mungwali el so mangna feasaig eba ka mingnag pasinif afa amangel mang wambug hwainig awaieg afa wesig kiki wambughu eba ka mwehwa fatinafe. ");
INSERT INTO amn_n_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Afa sonag angoluwag el so kana agfohie ehe mas ka misog el gohugum membig mo enam wambinim wanambugonam kana nofwa kwagiaiti.’” ");
INSERT INTO amn_n_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Afa Sisas enaig waskwes mo sihi wahianam eso ehe mo Jerusalemgam ikana. ");
INSERT INTO amn_n_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Afa Sisas ika Betfage afa Betani kimbig oliv mug muhwa ofefnaba. Afa sambaganigi pahlukuiag elim ningitigina. ");
INSERT INTO amn_n_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Afa onigitigifnaba enaig sihifeni, og, “Afa ne ena kimbig ika ahpugunam afa ne ahnanguiba donki ambag weana kikeagig wahig mas aman enanai yi pegana mo eso ne wemo ahpigina so na osum ahwanibo. ");
INSERT INTO amn_n_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Afa ma ateamba nem amanba sahtigiba ‘Mang ahfe?’ So na enaig sohona, og, ‘Ainiyag oka enena gafugafe.’” ");
INSERT INTO amn_n_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Sisas enaig sihifenugenam eso ningitigina afa ika ahnangonaba gwenaig esagena mo so sihinugenaba. ");
INSERT INTO amn_n_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Eso wemo donkina nihinai ohopigifnaba afa so donkina awag ehem sahtigina og “Mangigim ne donkina nihinaiba weaba ahpigig.” ");
INSERT INTO amn_n_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Afa ehenigi ehem ahsihina og “Ainiyag enena gafuga ofe.” ");
INSERT INTO amn_n_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Afa so ehenigi lofug mo heafgina ahug fanam donkina limuli yi ahskonam eso ahwani bona Sisasim og ma enanai yi fuku gai. ");
INSERT INTO amn_n_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Eso fuku ganam ikana, afa mahim akafenaba el heafgelni nihi lofug hugfuhiaginim mina wa skoahuna. ");
INSERT INTO amn_n_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Afa ma bo oliv mug mina wa pugunam enam wahia pe akafenaba afa so enaksag pahlukuiag el sifakaligna ambugoafnaba Godna unehlagim fingifini enaigba esinibi eba mungwali kifutigim so nanguni. ");
INSERT INTO amn_n_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Afa ehengel enaig esogona og; God so ma sonag misog elbi lahla feafai, Godna unehlagim sisigam nemug figifi. Afa heven wa nai el so ma safakali. ");
INSERT INTO amn_n_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Afa mingnagba Farisi el enanaiyi saho agfohiafna ena mungwali ahunam Sisasim enaig esuni, og, “Tisa, so na kwenim so ma sohnaig esigim wahiyi.” ");
INSERT INTO amn_n_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Afa Sisas wahgi enaig sihifeni, og, “Afa eba mwahlaibi agfohiefiba, afa so sona hunba Godna unehlagimba figifi.” ");
INSERT INTO amn_n_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Afa Sisas bo Jerusalem muhwa pugunam ena kimbigim nangunam ufwena. ");
INSERT INTO amn_n_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Afa ehe og, “O Jerusalemnai el nasabanig ka membig yawo ne anwanafi mang so ma nem lahlafeni, eba meagam goh. ");
INSERT INTO amn_n_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Afa nengigimba neana angoluwag el ambugonam nem wagfigonam minam kagwakef. ");
INSERT INTO amn_n_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","God so nem obon eba ne mas anwanafig mo eso angoluwag nem ambugog amtakwale aitif afa kimbig wa nai luwalim gaba gwenaig esegonif. Afa mas mangim ga mo wahiyi.” ");
INSERT INTO amn_n_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Afa Sisas Godna Nalig lala sahukanam gawig gafugag elim ningitigiaminefena. ");
INSERT INTO amn_n_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Afa ehengelim enaig esoni og, “Godna mom enaig esog og, ‘Kana lala eba Godum beten nenag lala afa ne enaig esigbi ofenaiba okwef elni nuwagig lala.’” ");
INSERT INTO amn_n_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Afa mungwali osuna enanai yi Sisas elim ogfu fenugena. Afa so amunai pris i, nihemo anwana el i, afa amunai el i enag one ehem tigifati. ");
INSERT INTO amn_n_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Afa mungwali ehena mom hugna membeni naso sonag elni minam kikisegoni eso mas Sisasim tigifatini mo. ");
INSERT INTO amn_n_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Afa enanam Sisas Godna nalig lala wa elim wagfufenugenam afa Godna lahlag mo sihini. Afa amunai pris i, nihe mo anwana el i, afa amunai el i enag ambugog ogna ehem nangui. ");
INSERT INTO amn_n_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Afa ehengel Sisasim sahini og, “Ahana nai ne kifutigbi fag afa aman nem faig?” ");
INSERT INTO amn_n_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Afa Sisas wahigi sihini og, “Sa ka nem sahin so na kam sihini. ");
INSERT INTO amn_n_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Aman mahim Jonimba buwa aitiag gafugaba kifutigbi faina eba God me awai el me?” ");
INSERT INTO amn_n_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Afa ehengel ahunam hefum sihiagini og, “Ahnaig mo so big sihif. Afa eba big enaig sihifibi God ehem kifutig faig. Eba bigim enaig sihinfenif og Ahnaig esegba so na mas Jonna moba higigim pahluhug mo. ");
INSERT INTO amn_n_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Afa eba big enaig sihifibi eba el ehe ehem kifutig faig. Eba el bigim hunna amtakwale aitif ehengel enaig onigig finim og eba Jon Godna mo fa sihiaule el God ehem ninghiag.” ");
INSERT INTO amn_n_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Afa so ehengel piske Sisas nangum ahunam enaig sihififni og, “Kangel ka mas anwanafig mo.” ");
INSERT INTO amn_n_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Afa Sisas ehengelim sihini og, “Kanga ka mas nem sihini aman so kam kifutig faig.” ");
INSERT INTO amn_n_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Afa Sisas mungwali elim enag waskwes mo sihini og, “El aso gafugafegim afa ehe mo wahigwa kimbig gam akafenaba heafna aso mo nangwaghiawagig elni ningala wahianaba og so ma asom ninumwehe hugufi. ");
INSERT INTO amn_n_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Afa ika enanai yi gan mahim asonai fane fug luwonaba eso heafna gafugag elim ningitigina og so ma ahu ehena asonai fane wambu. Afa nangwaghiawagig el enag elim tigekaminefenim piske isug ningihiana. ");
INSERT INTO amn_n_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Afa mahim piske ika isug pugunaba afa asona mog ming gafugag elim ningihianaba afa ehem gaba gwenaig esena tigekamine fenam amtakwalig mo sihinagenam piske isug ningihiana. ");
INSERT INTO amn_n_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Afa mahim ika isug pugunaba afa ehe ming gafugag elim ningihianaba afa ehem gaba gwenaig esena tige amtakwale fanam afwambagam fafatina. ");
INSERT INTO amn_n_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Afa so asona mog enaig esona og, ‘Ahnaig ka esef. Naiba ka kikeafna luwalim ningihia, ka ehem hugna membenag. Eba ehena mo higi me.’ ");
INSERT INTO amn_n_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Afa mahim nangwaghiawagig el legim nangunim hefum sihinagini og, ‘Sohna asona mogna luwal obo. Na tigifatinim eso big aso mo fi.’ ");
INSERT INTO amn_n_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Eso ehem fi aso afwambagam ningihini eso tigi fatini.” Sisas sihi wahianam afa ming mo sihini og, “Asona mog ehengelim so ahanaig esenif? ");
INSERT INTO amn_n_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Afa eba bonam sonag elim kwagi aitinam eso aso mo mingnag elim faif.” Afa mahim mungwali el ena mom higinim enaig esogona og, “Masa enaig puguf.” ");
INSERT INTO amn_n_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Afa Sisas nangwaginam eso enaig saheni og, “Afa ahanaig mog mo mahim Godna mo waba goh. Afa enaba enaig esog; Ena sumilba lala nimbagig el isugum fi fatig eba naho God esenagba eso sumilbi gohug. ");
INSERT INTO amn_n_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Afa aman enag aga waba peiba eso ehem tigia hwatif. Afa aga amanim penam ehem piga fakaf.” ");
INSERT INTO amn_n_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Afa nihemo anwana el i, afa amunai pris i ati anwanafini enag waskwes moba ehengelni amtakwalig onigig opuguni. Eso ogna Sisasim kikehli afa ehengel mungwali elim embefegoni. ");
INSERT INTO amn_n_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Afa so ehem numwehenaginim eso elim ningitigini og so ma Sisasim mwakwalinibi eso ehem moalambini so ma gavman na ningala wahiyi. ");
INSERT INTO amn_n_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Afa sonag el Sisasim sahini og, “Wagfuiag el, kagel ati ka anwanafig neana moba inim afa ena inim moba ati ne elim Godna mina ogfu fenigeg, afa ne mas onigi ne gauna ahanaig ahanaig elim gaba sihinag feg. ");
INSERT INTO amn_n_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Sa kam sihin, bigna nihe mo ateaho enaig sihifeg so big kigba Romna misog elbi fai me awai awai me?” ");
INSERT INTO amn_n_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Afa Sisas ehengelni mwakwal onigigim anwanafenim afa esona og, ");
INSERT INTO amn_n_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Sa kam kig wagfuni. Aman na nofbosug i unehlag i eso enanai yi go?” ");
INSERT INTO amn_n_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Afa esogona, “Sisar Romna misog el.” Eso Sisas sihini og, “Afa Sisarnaba eso Sisarim fai afa Godnaba eso Godum fai.” ");
INSERT INTO amn_n_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Afa ehengel mas ehem enaig mwakwal mo mungwali elnai yi fini mo. Eba ehengel sineminefinim mwahlai auguiafna. ");
INSERT INTO amn_n_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Afa mingnag sadyusi el Sisasim nangugum ambugona. Sadyusi el enaig onigini og melig pigieg elbi mas bigiagafei. Afa Sisasim sahini og, ");
INSERT INTO amn_n_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Wagfuiag el, Moses enaig sihifena, afa el luwal hwainig wahagba heafna sumineg so ma ehena esig angwafigbi fai eso ma luwal etegna sigagwa unehlif. ");
INSERT INTO amn_n_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Afa autunam elegeg wa gohug nilite ka agfoihiafena. Eteg angwafig fana mahim wahanaba luwal hwainig. Eso esig angwafig agafena. ");
INSERT INTO amn_n_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Afa ehem angigieg fana afa ehem gaba luwal hwainig wahana. ");
INSERT INTO amn_n_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Afa olyi nai fana gwenaig esena ehem gaba wahana. Eso gwenai pigi feakan ikan sumineg ne mog wa puguna. ");
INSERT INTO amn_n_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Afa sumi yi enag angwafigim gaba wahana. ");
INSERT INTO amn_n_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Afa autunai wa mahim enanam melig pigieg bigiagafeiba eso ehe amanna angwag fef afa mungo nilitena enag angwafig mungo fini?” ");
INSERT INTO amn_n_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Afa Sisas enaig sihififni og, “Afa yawonai el so na angwafig wambug. ");
INSERT INTO amn_n_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Afa kwamblo i angwafig i melig pigieg bgiagafegim eba yuhwa fif afa sumi yi so feg enenaba mas angwafig wambu. ");
INSERT INTO amn_n_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Afa eba ehengel Godna ofwanai el lofif mas piske pigi. God ehengelim ilafu aitiba eso ehengel Godna luwalig feskofefe. ");
INSERT INTO amn_n_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Afa Moses gaba gwenaig wagfufeg God melig pigieg elim ilafu aitigba eso li suwi lagigna mo Moses enaig sihifeg og, Ainiyagba eba Abraham, Aisak, afa Jekop na God. ");
INSERT INTO amn_n_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Afa enaba wagfug eba ehe mang melig pigieg elni God mo, eba heafa nofkena elni God. Afa so ehengel ehena nofwa ati nofkena gag feasaig.” ");
INSERT INTO amn_n_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Afa mingnag nihemo anwana el og, “Wagfuiag el neana mo sihiagba eba lahla feg.” ");
INSERT INTO amn_n_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Afa enenam mungwali el ehem ming mo sahinigim kusini. ");
INSERT INTO amn_n_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Afa Sisas sahini og, “Ahnaig esegba el enaig esogog El God Gishu Wahiag eba Devitna simbianiga? ");
INSERT INTO amn_n_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Afa Godna buk wa Devit ehe enaig esog; God Ainiyag Kana Ainiyagim sihinag so kana nihiginai ninga wa pegafim ");
INSERT INTO amn_n_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ikan ikan ka so kike neana fagule elim tigfeskonam eso ka nem faif. ");
INSERT INTO amn_n_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Afa Devit ehem safana, Ainiyag. Ahnaig esegba enag ehe Devitna simbianigaba feg?” ");
INSERT INTO amn_n_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Afa el Sisasna mo higahufna mahim pahlukuiag elim osihifinibi og, ");
INSERT INTO amn_n_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“So na numwehifibi nihe mo anwana elni enaigim. Ehengel enaig membig ogna heafna beten lofug wagwaginim eso ahu. Afa ehengel hugna membig og so ma kam enaig suwigi amunai el. Afa bu yis wa ehe ogna misog el lofug augu afa nuwagig lala ehe ogna sime lahlag wa gosu augu. ");
INSERT INTO amn_n_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Afa ehengel bulwag angwafigim mwakwale gonigim afa ehengelni lala wambugonig. Afa enaig esigim afa ehengel mwakwalig kwinam betenaska. Afa enanam God kwefihiage ofefiba eso enaig elim nalig tautig faif.” ");
INSERT INTO amn_n_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Afa Sisas nangwahiage nangunaba enaksag kigna el Godum kig faini. ");
INSERT INTO amn_n_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Afa nangunaba bulwag angwafig gaba eba sambaga kig wetiklug Godum faina. ");
INSERT INTO amn_n_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Afa Sisas enaig esona og, “Ka nem inim sihinig sonag angwafigbi eba kig hwainig, afa enaigba fainaba eba ehe numwehe gwesim mingnag elim hili fenig. ");
INSERT INTO amn_n_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Afa mingnag elbi eba kigna feasaina afa ehengel hefum mo wambugahufnaba afa Godum mo mungkwehegenai wetiklug faini. Afa sonag angwafigbi eba kig hwainig fena afa eba wetiklug kig mungo fanena maugum ogufna enag gwesim Godum mungwali faiena.” ");
INSERT INTO amn_n_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Afa pahlukuiag el mingnag enaig onigig fini og, Godna nalig lalaba eba lahlafegim afa hun i gau i hugunam lahlafiageg. Afa Sisas enaig sihifena og, ");
INSERT INTO amn_n_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Yawo ne mungwali enag hun lalam ne nangug, eba mas gofi. Nengigimba angoluwag ambugof hunim titoitifif afa so mungwali bite wa apaigofe afa mas mungo gofi.” ");
INSERT INTO amn_n_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Afa ehengel sahini og, “Wagfuiag el, amansi so enaigba puguf? Afa so mang puguiba eso ka enam nanguf afa enaigba kam wagfunig eba amtakwalig osuna puguiagim ati muhwa ofe.” ");
INSERT INTO amn_n_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Afa Sisas sihini og, “Numwehifibi masa el nem mwakwale gonif. Afa el numb ambugonam kana unehlag wa mwakwale agfoihenam esogof, kike Kraist God kam kanog wahiag afa gwesim ming mo enaig sihi fif og enag osuna ati meini ofe. Nofe ne ehengelim pahag ahu. ");
INSERT INTO amn_n_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Afa enenam ne higibi mingnag kantri hefum hagkafufe afa nofe ne embefi. Sohnaigba eba gof opugu afa awaieg osunaba eba mahimsi sumi yi fe.” ");
INSERT INTO amn_n_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Afa ehe gwesim ming mo sihina og, “Afa kantri hefum hagkafufe afa misog el hefum hagkafufe. ");
INSERT INTO amn_n_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Afa ahanaig ahanaig bite eba kugo i nalig bini i, afa kinig i puguiagef afa mang amtakwalig bite wa puguiagef afa of wa puguiagef. ");
INSERT INTO amn_n_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Afa enaig puguia hwainig mahimsi fefiba el nem wambinim kinig faigof. Afa ne kana el agfoihiefiba eba lotuni misog el nem kwefihian nugenam eso kalabus lala wambu aitif. Afa nem Gavman i misog elni ningala hwatibi eso ne ehengelni nofwa agfohiefuf. ");
INSERT INTO amn_n_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Enaba enenai yi so na ehengelim Godna mo sihigon. ");
INSERT INTO amn_n_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Afa so na numwehe onigim nofe ne hugunam onignaginim enaig esogo mang mo so ka sihigonif. ");
INSERT INTO amn_n_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Afa eba kike nem kwaganam afa nengelni mengig waba kike sihif afa ka nem lahlag onigig faiba afa so angoluwag mas ena mom flafui. ");
INSERT INTO amn_n_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Afa nembiafgelni afahumonig, nilite, mungo musuna, afa hihe enag nem angoluwagna ninga wa hwatibi eso mingnag nem kwaskofif. ");
INSERT INTO amn_n_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Afa ne kana el agfoihiefiba eso mungwali el nem olug kakagegonif. ");
INSERT INTO amn_n_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Afa mas nengelni lapug mungo amtakwale. ");
INSERT INTO amn_n_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Afa ateamba ne kifutigbi eba ne nofkikena agfohiefuf.” ");
INSERT INTO amn_n_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Afa Sisas sihini og, “Afa mahim angoluwag el ambugog Jerusalemim mugi yi pugu fakafiba so na nangufe eba so na anwanafi enaba ati amtakwaligim ofe. ");
INSERT INTO amn_n_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Afa mahim enenam ofefiba eso Judia nai el ikagna mug gam embem ikaf. Afa kimbig wa nai el kimbigim ikagna wahinim ahuna afa sangwali nai el nofena kimbig gam ahu. ");
INSERT INTO amn_n_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Afa enaig osuna God ehengelim amtakwalig tautig afai. Afa enaigba esegba eba Godna inim mo ati enaig sihifeg. ");
INSERT INTO amn_n_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Enanam amtakwalegef angwafig enogni afa angwafig wesig luwalna. Afa eba hugna amtakwalig ohuna bite wa puguf afa enenam God sonag elim olug kakagenugef. ");
INSERT INTO amn_n_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Afa mingnag elimbi angoluwag el kwaskofif afa mingnagim mungwali kimbig kalabus lala wambu aitiahuf. Afa afwambinai el Jerusalemim numwehefufuf. Afa gwenaig esif ikan heafgelni enag osuna awaief.” ");
INSERT INTO amn_n_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Afa Sisas sihini og, “Afa mahim enenam enaig ofefiba eso mang ahanaig ahanaig puguiagef eso osu i, was i, afa bagnafut i enanaiyi eseagef. Afa bitenai el mungwal enam oniginim afa so olug wahige skofefe afa mahim bu naligna mwagim higinim eso nanguf mahim bu nalig mimewe bo humu ofiba eso embefeagif. ");
INSERT INTO amn_n_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Eso el hugunam embefeagif mahim sumi yi mungwali bitem enaig puguiagofefiba eso mang ofwanai heafgelni kug hwatiagi ahkawag minefef. ");
INSERT INTO amn_n_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Afa enanam ehengel Inim Elim nanguiba sisyi lango wa nalig kifutigni afa nalig afwambusugni wahe bof. ");
INSERT INTO amn_n_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Afa mahim enanam enaig ofefiba afa so na olug hugna kifuti skofe eba God nem wambugum muhwa ofe.” ");
INSERT INTO amn_n_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Afa Sisas ena waskwes mo sihini og, “So na fik li afa ming li nangwaginim eso ne onigim. ");
INSERT INTO amn_n_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Afa mahim li figeg yiminig puguf eso ne anwanafi eba lahlagnam meinofe. ");
INSERT INTO amn_n_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Gwenaig esef mahim ne nanguibi eso mungwali puguiagef so na anwanafi eba Godna bog meg muhwa bo meini ofe. ");
INSERT INTO amn_n_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Ka nem inim sihinig afa enag el mahimsi agfofiba eso mungwali enaig puguiagef. ");
INSERT INTO amn_n_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Of i bite i mungwali awaieba afa kana moamo higeg gwese gofuf.” ");
INSERT INTO amn_n_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Afa Sisas enaig sihifeni og, “Nengel so na numwehifim. Nofena buyisif afa uflogna bu ahgagif afa hugunam onignageahufum. Masa enag osuna ikagna nem pugunif. Afa ne mas numwehiagig mo. ");
INSERT INTO amn_n_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Afa enag osuna mungwali bitenai elim ikagna pugunif ofenaiba sis mime wa apaigof. ");
INSERT INTO amn_n_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Eso ne numwehi agfohiafiba so na Godum higeg sahna hufum so ma God nem kifutig faibi so na enaigim kweagfu ahu, eba ne Inim Elim nangunim afa ne mas ehem ahwanif fini.” ");
INSERT INTO amn_n_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Afa mungwali osuna Sisas Godna Nalig lala wa elim wagfufenugena afa osu pegnam ehe afwamba gam pugu ika oliv mug wa sinaini gofena. ");
INSERT INTO amn_n_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Afa mungwali el ogna leana gubi Godna nalig lala gam ambugonam Sisasna mo higim. ");
INSERT INTO amn_n_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Afa enanam Ju elni pasova buyis meinofe fenaba sona buyisba sefig bret yist hwainig buyis. ");
INSERT INTO amn_n_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Afa so amunai pris i afa nihe mo anwana el i ogna Sisasim tigi fati afa so ehengel mungwali elim embefegoni. ");
INSERT INTO amn_n_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Afa enanam Sisasna pahlukuiag el mungo ehena unehlagba Judas Iskariot, Satan ehena nihi, sahona. ");
INSERT INTO amn_n_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Eso Judas amunai pris mi afa Godna Nalig lala anwasag el mi ika nangwagenam og, ahanaig so ka esenam Sisasim nengelni ninga wa wahia fe. ");
INSERT INTO amn_n_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Afa enag el sifakalinim eso ehem enaig esoni og, “Eba ne enaig eseba eba ka nem kig faif.” ");
INSERT INTO amn_n_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Afa Judas ehengelni mom sawifenim afa mina yisiginam afa mahim el numb awaienaba eso ehe Sisasim ehengelni ninga wa wahiaf. ");
INSERT INTO amn_n_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Afa enanam Bret yist Hwainig buyis ati puguna. Enag osuna el sipsip luwalig kwaginim eso Pasova buyis wa ahgagini. ");
INSERT INTO amn_n_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Afa Sisas Pitami Jon mi sihinugenam eso ningitiginam og, “So na ahkanam bibeafgelni fanem numwehiagahfeiba afa so big ena Pasova buyis ahga.” ");
INSERT INTO amn_n_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Eheningi ehem ahsihina og, “Ahana nai yi ka numwehiagafefe?” ");
INSERT INTO amn_n_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Afa Sisas sihini og, “Sa hig, afa ne ahkanam kimbig wa ahsahonam afa so na elim askotigif mahim bu obofiba so na ahpahlukui ma lala wa osahofiba so na sahoahka. ");
INSERT INTO amn_n_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Afa lalana mogim ahsihina og, ‘Wagfuiag el enaig saheg og, ahanag mengig megam so ka kikeafna pahlukuiag elim wanef.’ ");
INSERT INTO amn_n_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Afa eba enag el nem wagfunif eba nalig mengig sisi gam go. Ena mengigba ati numwehiage go enanai yi so na faneba numwehiage ahfe.” ");
INSERT INTO amn_n_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Afa pahlukuiag el so enaigim ahnanguna mahim Sisas ena mo fainibi afa so enag faneba numwehiage ahfena. ");
INSERT INTO amn_n_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Afa kwekwe watini Sisas 12 pela pahlukuiag elim sime wa wan pegnam fane wanena. ");
INSERT INTO amn_n_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Afa ehe enaig esona og, “Ka hugna membeg ena Pasova buyis nengelim koka nem wane afa so ma kam sumi yi tautigba pugunai. ");
INSERT INTO amn_n_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ka nem sihinig ka mas piske ena buyisba ne eba ikan ikan mahim Godna bog meg ena buyis mog nemug faiba eso ambagwa opuguf.” ");
INSERT INTO amn_n_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Afa so Sisas bu kapna fanam Godum lahlag onam eso enaig esona og, “Ohuna bu finim eso nimbefum mimangi. ");
INSERT INTO amn_n_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ka nem sihinig ka mas ena wain bug piske nei eba ikan ikan eso Godna bog meg eba pugunam bof.” ");
INSERT INTO amn_n_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Afa so amba fanam Godum lahlag onam eso kukosko fenam mimangeni eso enaig esona og, “Ohnaba kana lofug, ka nem faig koka nem kwaganim, so na enaig esi kam higeg oniginafufim.” ");
INSERT INTO amn_n_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Afa mahim ahganaba eso ehe bu kapna fanam gwenaig esena ehengelim mimangenim afa so enaig esona og, “Ohuna buba eba kana taf, ka sugfenam eso ka wahaf. Ena tafba ese wahiag eba Godna mulug mo sihi wahiag. ");
INSERT INTO amn_n_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Sa hig! Nengelnai aman mungo ka wan one ehe kam ikanam elim mwaunif. ");
INSERT INTO amn_n_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Autunam God sihi wahiana mang mina so Inim Elbi wahaf afa so sonag el ehem elim mwaunif eba nasabam.” ");
INSERT INTO amn_n_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Afa pahlukuiag el hefum sahigini og, aman bigelnai so enaigba esef. ");
INSERT INTO amn_n_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Afa pahlukuiag el hefum fiflafeagini og aman so ehengelnai gosug elbi fef. ");
INSERT INTO amn_n_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Afa Sisas ehengelim sihini og, “Afwambanai elni misog el ehe hugunam kifutiageg elim nangwahiagegba. Afa el ehena unehlagim fingifigim afa sefig og sohnaba elni hihe.” ");
INSERT INTO amn_n_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Afa Sisas enaig esona og, “Nofena enaig esi. Amo, eba aman so nengelinai gosug el feg eba so ma sumi nai el lofei. Afa aman so nengelinai misog el feg eba so ma isug gafugag el fei. ");
INSERT INTO amn_n_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Afa aman el so fane nawu afa aman el so fane numwehiageg bug enaba aman so gosug? Eba el so fane mungwagug wa nawo eba naho gosug elbi feg. Afa eba ka olyi fenam eso ka isug gafugag el lofef. ");
INSERT INTO amn_n_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Afa mahim kam kinigbi pugunagba afa ne mas kam wahiai. ");
INSERT INTO amn_n_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Afa kana awag kam heafna bog meg faig eso kanga gwenaig esef ka nem faif. ");
INSERT INTO amn_n_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Afa ne ambugonam kana bog megam fane i bu i ka nem wanef. Afa ne misog elni pegag sime wa augunam eso ne 12 pela Israel elim nangwaghiagif.” ");
INSERT INTO amn_n_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Afa Sisas Pitam sihina og, “Saimon so hig, Satan Godum sahnag ogna neana olug onigigim gihna. Eso ofenaiba fufei liim fe fuhla faka ofefa. ");
INSERT INTO amn_n_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Afa ka neana olug onigigim Godum sahnaiba eba mas neana olug onigig wahi. Afa mahim ne piske boiba eba so na nimbiafna nilitem ehengelni onigigim fuku wasanif.” ");
INSERT INTO amn_n_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Afa Pita higi enaig sihifena og, “Ainiyag, afa ne kalabusiba akafiba big mungwal ahkaf. Afa nem tigi afatifibi eba so ma kam gaba tigi fati. Ka mas embefei.” ");
INSERT INTO amn_n_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Afa Sisas ehem sihina og, “Pita ka nem sihinag enaba yawo sinaini kakaruk moasia hwainig fefiba eso ne sambaga mungo nagim esof ne kam mas anwanafenag mo.” ");
INSERT INTO amn_n_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Afa Sisas pahlukuiag elim enaig saheni feni og, “Afa mahim ka nem ningitigiba ne mas kig wula na, wula, afa mong lofug enaig ne wambug ahuf mo. Afa mang mahim nem tumenig?” Afa so ehengel wahigi sihini og, “Amo, eba awai.” ");
INSERT INTO amn_n_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Afa ehe esoni og, “Afa ne enaig fegba so na wambug ahu. Afa aman ne kasu hwanigba so na nimbiafna lofug el fainam eso ne kig enananam fanam afa kasu so na wambum. ");
INSERT INTO amn_n_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Afa Godna mo ati sihi wahiana eba inim kam enaig pugunafe. Godna mo ati enaig sihifeg og eba el enaig onigigfig og eba ehe el amtakwalig. Ei, eba inim kam fenaf.” ");
INSERT INTO amn_n_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Afa pahlukuiag el sihini og, “Ainiyag, so nangu kagelbi sambaga kasu feg!” Ehe og, “Eba magwese.” ");
INSERT INTO amn_n_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Afa Sisas Jerusalem kimbig wahianam gwenaig ese gofna oliv mug gam ehem pahlukuna. ");
INSERT INTO amn_n_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Afa enanai yi opukonam afa so enaig esona og, “So na Godum betenini eba neana olug onigig mas tigefupei.” ");
INSERT INTO amn_n_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Afa ehe ehengelim hwatinam gwesim mwakwalig hilife ikanam eso mongkokini kwakwagenam afa so beten enam og, ");
INSERT INTO amn_n_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Kana humuan ena kapteba so na kana ninga wa nai mwehwai. Eso nofena kana membug wa ese afa eba ka so nimbiafena membug wa ese.” ");
INSERT INTO amn_n_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Afa ofwanai el ehem pugunam afa so ehem kifutinagena. ");
INSERT INTO amn_n_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Afa nalig kinig ehem guhnagenaba eso ehe hugna betenafnaba ehege ehena nihi pugu penafena ofenaiba taf. ");
INSERT INTO amn_n_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Afa betene wahianam eso piske pahlukuiag elim ningwagna ikana afa ika nangwagenaba ehengelni olug kinig skofenaba eso ehengel non aska fena. ");
INSERT INTO amn_n_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Afa ehe ehengelim enaig esoni og, “Ahnaig esegba so na non aska? Afa so bugia gafenam beteni masa neana olug onigig tigefu penif.” ");
INSERT INTO amn_n_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Sisas mahimsi mo sihi gofenaba afa so el numb ambugonam. Afa so Judas eba pahlukuiag el enag ehe gosu ika mina wagfunim, afa bo Sisasim muhwa fenam ogna ehem afofafna fiafai. ");
INSERT INTO amn_n_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Afa Sisas ehem enaig sahna fiafana og, “Neaho nog Ka Inim Elim afofafna fiafanam eso angoluwagna ninga wa wahia?” ");
INSERT INTO amn_n_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Afa pahlukuiag el ati anwanafini el ogna Sisasim kikehli eso sahini og, “Ainiyag ne membegba ka so kasuni hagim?” ");
INSERT INTO amn_n_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Afa so ehengelnai mungo kasu skofanam prisni misog elni gafugag elim nihiginai anglugum higefatina. ");
INSERT INTO amn_n_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Afa Sisas enaig esona og, “Magwese wahia!” Afa so Sisas ehena anglugum ningana piske gabahlana. ");
INSERT INTO amn_n_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Afa amunai pris i, anwasag el i afa amunai el i ogna ambugog Sisasim kikehli eso Sisas ehengelim enaig sihi feni og, “Ne enaig onigig Kaba okwef el ho feg na ne kasu na mal na fa bug kam fig. ");
INSERT INTO amn_n_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Afa mungo mungo osuna Ka Godna Nalig lala ikafenam gafenaba afa enanam ne mas kam fini mo. Afa nag yuwaba eba enanam ne kam esofini. Afa enanam si kifiagim filafe fatif.” ");
INSERT INTO amn_n_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Afa so Sisasim kikehlinim misog prisni lala gam wanigahuafnaba afa Pita sum kiniafohla fiakafna. ");
INSERT INTO amn_n_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Afa el lala bog muhwa olyi suwi wehlinim enanai yi auguiafnaba Pita gaba ika nanai yi gafena. ");
INSERT INTO amn_n_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Afa gafuga angwafig angwaming ehem suwi afwambusugi fahigefam eso enaig esona og, “Sonag elbi eba ati Sisas i safahkafna.” ");
INSERT INTO amn_n_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Afa Pita esona og, “Angwafig ka mas ehem anwanafenag mo.” ");
INSERT INTO amn_n_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Afa managig hwainig ming el bona fahigefanam afa gwenaig esona og, “Ne gaba ati ne mungwal safahkafna.” Afa Pita esona og, “Amo, kaba mas ehiba safahkafna mo.” ");
INSERT INTO amn_n_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Afa mwakwalig agfohiafenba afa ming el gwenaig esona og, “Eba inim ehe sonag elbi eba Sisas i safahkafna enag ehe gaba Galili wanai el.” ");
INSERT INTO amn_n_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Afa Pita esona og, “Ka mas anwanafeg mo ena mo so na esogba.” Pita enaig sihifegofnaba afa gweyi ikagna kakaruk moasiyinaba. ");
INSERT INTO amn_n_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Afa Sisas wahigifenam Pitam nangwagofenaba. Eso Pita piske ena mom oniginam Sisas so ehem sihina og, “Mahim mahimsi kakaruk moasiag hwainig fefiba ne sambaga mungo nagim esof ka mas ehem anwanafenag mo.” ");
INSERT INTO amn_n_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Afa eso afwambagam pugu ikanam amtakwal ufwe feagena. ");
INSERT INTO amn_n_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Afa anwasag el Sisasim kikehlinim amtakwalig mo sihinaginim afa tigekaminefini. ");
INSERT INTO amn_n_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Afa ehengel Sisasim nofugum lofugna kagunim eso sahnagini og, “Neaho Godna mo fa sihiaule el so na kam sihin aman el nem tigikahu?” ");
INSERT INTO amn_n_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Afa ehengel mingnag enaksag molamp mo faini. ");
INSERT INTO amn_n_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Afa leana gubi yi amunai el i, amunai pris i, afa nihemo anwana el i enag ambugog nuwaganamba eso Sisasim ehengelni nof wa wanig ambugona. ");
INSERT INTO amn_n_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Afa so ehengel Sisasim sihini og, “So na kam sihin neaho Kraist God nem Gishu Wahiag?” Afa ehe wahigi enaig esona og, “Ka nem sihinibi ne mas kana mo higi. ");
INSERT INTO amn_n_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Afa ka nem sahtigiba afa ne mas kam kwegfug wagini. ");
INSERT INTO amn_n_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Afa yawo fenam afa ikan autunai wa fef eba Inim El ehe gosug ikanam kifutig God ena muhwa pegafuf.” ");
INSERT INTO amn_n_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Afa so mungwali el ehem sahini og, “Neaho ne Godna leg?” Afa ehe sihini og, “Ei, eba gwenaho, ati ne sihig.” ");
INSERT INTO amn_n_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Afa ehengel esogona og, “Mangofi eba mingnag el ati ehem sehig. Eba ati ka higig eba heafna moawa.” ");
INSERT INTO amn_n_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Afa so enag mungwali el Sisasim Pailat nangum wanig ahuna, eba Romna misog el. ");
INSERT INTO amn_n_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Afa so ehengel Sisasim sehini og, “Sonag elbi og na bigelni kantrim filafefati. Ehe elim wagfunig og masa kig Romna misog elim faif. Afa ehe enaig esog og kaba Kraist kike misog el feg.” ");
INSERT INTO amn_n_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Eso Pailat Sisasim sahna og, “Neaho ne Ju elni misog elbi feg?” Afa Sisas esona og, “Ei, gwenaho ne sihig.” ");
INSERT INTO amn_n_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Afa so Pailat amunai pris el mi afa mungwali el mi sihini og, “Sonag elbi mas ahanaig eseg mo.” ");
INSERT INTO amn_n_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Afa ehengel hugna olug kifutigni esogona og, “Amo, eba heafna mo Judianai elim olugim fuku wasaneakag. Enaba Galili wa puguagim bog ohunanai yi pugug.” ");
INSERT INTO amn_n_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Afa Pailat ena mo higinam eso sahtigina og, “Sonag elbi eba Galili wanai ho mahim?” ");
INSERT INTO amn_n_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Afa ehe enam ati anwanafena afa enaig onigina og, Herotba Galili wanai elim nangwaghiageg el feg afa enag yawaba Jerusalem wa ga. Eso Sisasim esim ningihiana. ");
INSERT INTO amn_n_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Autunam Herot ati higina Sisas kigmog wagfunaba enam ogna nangu eso ehe Sisasim nangunam mahim boafenaba eso sifakalena. ");
INSERT INTO amn_n_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Afa so ehe Sisasim hugna sahnagenaba afa Sisas mwahlai gofena. ");
INSERT INTO amn_n_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Afa so amunai pris i nihemo anwana el i bugiaga fenam eso Sisasim hugna sehini. ");
INSERT INTO amn_n_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Eso Herot fena afa heafna soldia apaigona Sisasim molamp mo fainim amtakwale fini. Afa misog elni lofug ehem fatinim eso Pailat nangum piske ningihini. ");
INSERT INTO amn_n_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Autunam Herotba Pailatna angoluwag el fena afa yuwaba ehe hihe ahfeg. ");
INSERT INTO amn_n_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Afa so Pailat amunai pris i, amunai el i, afa mungwali el mi unetigina og ma ambugog. ");
INSERT INTO amn_n_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Afa ehe ehengelim enaig sihifeni og, “Sa ka sonag elim wangig ambugona ofenaiba ahanaig ahanaig el lofeg. Afa ka mungwali elni nof wa fahigenagegba mas ka ehena ahanaigim nangug mo. ");
INSERT INTO amn_n_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Afa Herot gaba gwenaig onigig fenam eso piske ningihiana. So na anwanafi ohuna elbi mas ahanaig eseg mo eso ka onigihiaba so na tigifati. ");
INSERT INTO amn_n_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Afa so ka ehem wena flakflakenagini eso wahia.” ");
INSERT INTO amn_n_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Enanam Pasova buyis wa ehengel ogma amanim kalabus elim membinibi eso Pailat mungo elim wahiaf. ");
INSERT INTO amn_n_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Afa mungwali el mungo mengna esogona og, “Sonag el mo tigifatibi afa Barabas mo ningihia.” ");
INSERT INTO amn_n_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Autunam Barabas eba kimbig wa malwu penim afa so elim tigefatina enaig esenaba eso ehem kalabus yi fifatini.) ");
INSERT INTO amn_n_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Afa Pailat ogna Sisasim wahia eso elim enaig piske sihi feni. ");
INSERT INTO amn_n_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Afa mungwali mungo mengna hugna esog ogna og, “Sonag elimbi li katigeg wa kukufenagi! Sonag elimbi li katigeg wa kukufenagi!” ");
INSERT INTO amn_n_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Afa Pailat piske ehengelim sihini og, “Ahanaig eseg! Mang mahim fegba. Afa ka mas ehena ahanaigim nangug mo eba ka ehem wena flakflakenagini eso wahia fe.” ");
INSERT INTO amn_n_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Afa ehengel hugunam mungo mengna esogo ahufna og, “So na Sisasim li katigeg wa kukufenagi.” Eso Pailat ena mo higinam. ");
INSERT INTO amn_n_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Afa Pailat gaba mungo mo sihina so ma gwenaig esi. ");
INSERT INTO amn_n_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Afa sonag el kalabus wanai eba Barabas autunam ehe malwu kimbig wa penim afa so elim tigi fatina afa enag mungwali el ehem membini Pailatim og soma wahiai. Eso Pailat gwenaig esena afa so Sisasim mo mungwali elni ningala wahiana. ");
INSERT INTO amn_n_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Eso Sisasim wanig ahuafnaba afa nangunibi Sairini wanai el Saimon ogna kimbig wa ika saho enag ehem kehlinim Sisasna li katigeg ehem fi kufehlinibi eso kufehlanam eso Sisasim sum pahlukuna. ");
INSERT INTO amn_n_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Eso el numb mungwali ahuna afa mingnag angwafig mo wewatini Sisasim pahlukahuafna. ");
INSERT INTO amn_n_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Afa Sisas wahigifenam ehengelim enaig sihifeni og, “Jerusalem wa nai angwafig nofe ne kam wewatina eso ne nimbefum afa luwal fe so na gwenaig esi. ");
INSERT INTO amn_n_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Afa sumi yi puguiba el enaig sihifefi og, ‘Afa angwafig afaisufeg afa angwafig luwal hwainig afa angwafig luwalim tut faig hwainig eba so ma sifakali.’ ");
INSERT INTO amn_n_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Afa enanam; El mugam enaig sihinaf og ‘Kam tufupe sagfa kumwahla’. ");
INSERT INTO amn_n_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Afa ateamba el kam enaig esigbi mahim li figetinim eso ehengel hugna amtakwalig eseagif mahim li fufefimba.” ");
INSERT INTO amn_n_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Afa amtakwalig el ahfena afa Sisas fena enam el wanahunam ogna ehem kwaskofi. ");
INSERT INTO amn_n_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Afa ena mug wa ogna kwaskofi ena mug sefig misog kig mug. Enanai yi Sisasim olyi kahlini afa sambaganigi el ming ehgam kahlini afa migim ming ehgam kahlini. ");
INSERT INTO amn_n_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Afa Sisas esona og, “Humuan, ehengel mas heafgelni amtakwalig nihem anwanafig mo so na ehengelni enaigim hugufanim.” Afa el Sisasna lofug hugufinim eso katna wagini ogma aman so enana lofug fai. ");
INSERT INTO amn_n_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Afa el nangwafofenaba afa so Ju elni amunai el Sisasim molamp mo faini enaig esogona og, “Eba ehe so ming elim fakwaganif enag so ma hefum kweagfui. Ateaba God Kraistim Gishu Wahiag El fegba eso ma gwenaig ese hefum kweagfui.” ");
INSERT INTO amn_n_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Afa anwasag el gaba Sisasim molamp mo fainim eso mileaklana bu nihni. ");
INSERT INTO amn_n_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Afa enaig esogona og, “Ateaba ne Ju elni misog el fegba so na nimbefum kweagfu.” ");
INSERT INTO amn_n_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Afa so li kukwefag wa enaig ginofini og: Sonag elbi eba Ju elni misog el feg. Eso Sisasna misog sisyi kukufi wahini. ");
INSERT INTO amn_n_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Afa mungo el so Sisas nahlum wahe kagini enag Sisasim molamp mo faina og, “Neba naho Godna Gishu Wahiag El me awai awai me? So na bibefum kwaganim.” ");
INSERT INTO amn_n_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Afa ming el ehem nunimu fanam enaig esona og, “Ateaho ne Godimba embefenag? Neanga gwenaig tautig fag. ");
INSERT INTO amn_n_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Afa eba bibefningina moawa big enag tautigba ahfag enaba yuhwafeg. Afa sonag elbi eba mas ahanaig esena mo.” ");
INSERT INTO amn_n_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Afa Sisasim enaig sihifena og, “Sisas ne misog el ofefiba so na kam onigina!” ");
INSERT INTO amn_n_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Afa Sisas ehem enaig sihifena og, “Ka nem inim osihina yawoba ne kai heven wa ahagafuf.” ");
INSERT INTO amn_n_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Afa osu misosuf gigni osu meagam seahufnaba mungwali bite si kigi fakana ikan ikan sambaga mungo aua wa puguna. ");
INSERT INTO amn_n_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Afa gwenanam Godna Nalig lala nai lofug olyi plefunam pekan pitkafena. ");
INSERT INTO amn_n_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Afa Sisas ambwaitina esona og, “Humuan, ka kikeafna sungwagbi nibeafna ninga wa awahia.” Afa ena mo sihinam eso wahana. ");
INSERT INTO amn_n_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Afa anwasagna misog el mungwali enam nangunim Godna unehlag fingi finim og, “Eba inim ehe sonag elbi lahlag ehe.” ");
INSERT INTO amn_n_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Afa el enanai yi agfohiafna enag enam nangunim heafna bahaligim tigeaginim afa ningam gwana kakugini eso ahuna. ");
INSERT INTO amn_n_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Afa Sisasna hihe i afa mingnag angwafig i enag membiagig agfohiafnaba ehe gaba nanguni. Autunam ena angwafigbi Sisasim Galili nai pahlubuna. ");
INSERT INTO amn_n_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Afa amunai el mungo ehena unehlagba Josep. Eba Judia nai el ehena kimbigba Arimatea. Sonag elbi eba lahlag el fena. ");
INSERT INTO amn_n_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Afa mingnag amunai el so Sisasim otigigifinibi ehe mas mungo mo sihini mo eba ehe Godna bog megim nangwagim nenge gofena. ");
INSERT INTO amn_n_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Eso ehe Pailatim sahna ogna Sisasna eligim faku. ");
INSERT INTO amn_n_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Afa so ehe Sisasna eligim li katigeg wa nai ningasuwa opi fakanam eso lofugna sagfa kikenagenam eso faku hun meg wa fakana. Ena hun megba mulug gofna mas amanim eyi fakini mo. ");
INSERT INTO amn_n_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Afa eba Fraide osupegna, enanaba el nuwagig osuna numwehiagini. Afa enaba ati meiniofefna. ");
INSERT INTO amn_n_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Afa so angwafig Sisasim Galili nai pahlubuna enag Josepim pahlukunam hun meg wa nangwafufnaba eso Josep enanai yi fakana. ");
INSERT INTO amn_n_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Afa ehengel piske lala gam ahunam afa so pauda i fungugnia bu i numwehiaginim ogna so Sisasna lofugim aitinagi. Afa so isug auguiag osuna ehengel ena nihe mo pahlukunam eso isug auguna. ");
INSERT INTO amn_n_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Afa Sande leana gubi enag angwafig hun meg nanguigim ahufefnaba eso pauda i fungugnia bu i wambug ahuna. ");
INSERT INTO amn_n_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Afa ahu nangunibi hun mogug hun megim pwaka feg ati pigi gofna. ");
INSERT INTO amn_n_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Eso ehengel saho ahunam mas Sisas Ainiyag na eligim nanguini mo. ");
INSERT INTO amn_n_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Afa so ehengel agfohiafnaba hugna onigahufna. Afa so gweyi yi ikagna el sambaga heafnigina lofug eba hugunam busiag ahfena enag muhwa ahgofna. ");
INSERT INTO amn_n_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Afa angwafig nangwaginim embefiagini bite nofeahufna. Afa so sambaganigi el enaig sihi ahfeni og, “Ahnaig esegba so na noka nofkikena elbi bite kug wa yisigi nangu? ");
INSERT INTO amn_n_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Eba mas ohunanai yi ba gah mo. Eba awai. Eba ati piske bihiag. Ateaho ne ehena moba onigig eso ati nem Galili yi sihini. ");
INSERT INTO amn_n_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ehe enaig esona og, ‘Eba Inim Elim amtakwalig elni ningawa wahibi eso ehem li katigeg wa tigi kahlif afa mahim sambaga mungo osuna ika puguiba afa so ehe piske buihiaf.’” ");
INSERT INTO amn_n_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Afa so angwafig Sisasna mom piske enam onigini. ");
INSERT INTO amn_n_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Afa so ehengel enanai wahinim eso piske ahunam 11 pela pahlukuiag el mi afa mingnag el mi sihigoni. ");
INSERT INTO amn_n_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Afa enag angwafigbi eba Maria Makdala nai, afa Joana, afa Jemsna afag Maria afa mingnag apaigona. Enag Kanog Hwatieg elim ena mom sihigoni. ");
INSERT INTO amn_n_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Afa Kanog Hwatieg el enaig onigini og angwafig eheba mwakwalig. ");
INSERT INTO amn_n_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Afa Pita bihia kikini ikan hun meg gim sahu nangonamba lofug mungo gifini afa elig mo awaiena. Afa so ehe piske lala gam ikanam hugunam onigaufna. ");
INSERT INTO amn_n_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Afa mahim angwafig ambugog ena mo sihinibi afa ming el sambaga ati ena mo ahiginam eso enanam Emeus kimbig gam ahakafna. Enag kimbigba eba mungwanam hilifeg ikag. ");
INSERT INTO amn_n_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Afa eheningi ahakafenaba hefum sihiag ahfe ikafna Sisasim so esenagini ena mom. ");
INSERT INTO amn_n_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Afa mahim sihiago ahfekafnaba afa Sisas olyi ehem pugunim eso ahuiafna. ");
INSERT INTO amn_n_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Afa ahuiafnaba eheningi mas ehem anwana ahfena mo. ");
INSERT INTO amn_n_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Afa so Sisas eheningim sahtigina og, “Mang mo ne sihiag ahfeaka?” Afa eheningi ahkinihlanam nofbusug mo kuko fuiagafenam enaig ahgofna. ");
INSERT INTO amn_n_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Afa ming el ehena unehlagba Kliopas enaig esona og, “Afa mungwal el Jerusalem wanai ati enam anwanafig, mang so enanam enanai yi puguiageg. Mas ho ne enam anwanafeg mo?” ");
INSERT INTO amn_n_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Afa ehe ehem sahtigina og, “Mang mahim?” Afa eheningi enaig esohona og, “Ena moba eba mang so Sisasim Nasaret wa nai elim so puguna enam. Sonag elbi Godna mo fa sihiaule el feg afa kifutig wagfuiaule feg afa ehe lahlag mo sihiaule feg. Afa ehe lahlag el Godna nofwa feg afa elni nofwa feg. ");
INSERT INTO amn_n_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Afa misog pris i afa amunai el i ehem angoluwag elni ninga wa wahigbi eso ehem tigigim li yi kahli. ");
INSERT INTO amn_n_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Afa kangel ka onigig sonag elbi eba Israel elim wambinam eso kwaganf. Afa enaigba esegba eba sambaga mungo osuna mahim awaiegba eso enaigba pugug. ");
INSERT INTO amn_n_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Afa leana gubi kangelnai angwafig ahug bite kug wa opukogum ena mo fi big sihigbi kangel sineminefeg. ");
INSERT INTO amn_n_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Afa mas Sisas na eligim bite kug wa nanguini mo. Afa enanai yi of wanai el ehengelim ahsihini mo. Afa enanai yi of wanai el ehengelim ahsihini og Sisasba eba nofkikena goh. ");
INSERT INTO amn_n_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Afa mingnag kangel nai ehe gaba ahu bitekfem nangug. Enaba angwafig sihinibi eso enaigba esini afa mas ehena eligim nanguni mo.” ");
INSERT INTO amn_n_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Afa Sisas eheningim enaig sihifeni og, “Mas ne numwehe ohonigig mo afa mas ne Godna mo fi sihiaule elni mom hugunam ahkehla ohonigina mo. ");
INSERT INTO amn_n_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Eba Godna Gishu Wahiag El so ma tautig fanam afa nengigim so ma nalig unehlag fai.” ");
INSERT INTO amn_n_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Afa so Sisas eheningim Godna mungwali mom sihinuwagena. Moses nai yi opugunam afa ikan mungwali Godna mo fi sihiaule elnai yi puguna. Enaba Sisasna mom sihiahufna. ");
INSERT INTO amn_n_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Afa ahu kimbig wa opukonam afa so Sisas ogna eheningi wasanam ika. ");
INSERT INTO amn_n_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Afa eheningi ehem ahsihina og, “Osu ati pegim ofe so na kam wangi.” Eso ahu lala meg gam saho ahuna. ");
INSERT INTO amn_n_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Afa enanai yi augunam eso fane ogna ahga afa so Sisas amba fanam Godum lahlag onam eso kwawagenam eso mange tigini. ");
INSERT INTO amn_n_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Afa mahim enaig esenaba eso eheningi enam ahnangonam eso anwana ahfena eba Sisas ehe. Afa so ehe gweyi ikagna awaienaba afa eheningi mas ehem ahnanguna mo. ");
INSERT INTO amn_n_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Afa eheningi hefum sihiag ahfenam og, “Afa, big eteti ahfena mahim bigim mina wa Godna mo bigim sihinuge boafnaba afa so bigna olug hugunam fingi fiahwagena.” ");
INSERT INTO amn_n_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Afa eheningi gweyi ikagna Jerusalem gam ahkana. Afa enanai yi ika ahnangwagnaba 11 pela pahlukuiag el apaigona afa mingnag hihe apaigona enag nuwagofna. ");
INSERT INTO amn_n_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Afa ehengel enaig sihi fegoni og, “Eba inim ehe Ainiyag ati piske bihiag. Ehe ati Saimonim pugunag.” ");
INSERT INTO amn_n_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Afa eheningi gaba sihiagafena Ainiyag so mina wa pugunim afa lala opukonam mahim ehe amba okuwag fenaba eso enanai yi anwana ahfena eba Sisas ehe. ");
INSERT INTO amn_n_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Afa mahim lala meg gam auguia sihiage afanaba Sisas gweyi ikagna pugu olyi gofna. Afa so sihini og, “Nengelni olug efihlag nem gohunif.” ");
INSERT INTO amn_n_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Afa ehengel sineminefinim embefinim og eba ifaf eba. ");
INSERT INTO amn_n_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Afa ehe enaig sihifeni og, “Ahnaig esegba so na sineminefig? Ahnaig esegba so na enaig onigifig mang so na nangugim ne og mas inim feg mo? ");
INSERT INTO amn_n_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Afa so nangu kana ninga mi mong mi so na enam anwanafi eba kike ehe. So na kam tuhum kaba ifaf mo. Afa ifaf eba kig hwainig afa nihig hwainig. Afa kaba eba kigna feg afa nihigni feg.” ");
INSERT INTO amn_n_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Afa ehe enaig sihifenim afa so heafna ninga me mong mi wagfuni. ");
INSERT INTO amn_n_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Afa ehengel mas enam numwehe anwanafini mo. Afa ehengel olug fingi feskofenam afa sifakalini. Afa Sisas ehengelim sahtigina og, “Ateaho ne faneba fig?” ");
INSERT INTO amn_n_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Afa so sawug ehem fainibi ");
INSERT INTO amn_n_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","eso fanam ehengelni nofwa nena. ");
INSERT INTO amn_n_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Afa enaig sihifeni og, “Enaba autunam ati ka nem sihi wahiani kana mom mungwali yi Moses na, Godna mo fa sihiaule el i, Song buk wa i ati ginofi wahini enaba eba so kam inim fenag.” ");
INSERT INTO amn_n_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Afa so ehe wagfufenugenaba eso ehengel Godna mom numwehe anwanafini. ");
INSERT INTO amn_n_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Afa so ehe enaig sihifeni og, “Godna ginof enaig esog Godna Gishu Wahiag El eba so ma tautig fanam eso ma wahai afa mahim sambaga mungo osuna feba eso piske buihiaf. ");
INSERT INTO amn_n_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Afa heafna unehlag wa mungwali bitenai elim olug wahigefe mom sihigo ningia hwiba so ma God ehengelni amtakwaligim fafatini. Ena moba so ma Jerusalem wa pugunam so ma gwese ika minefe. ");
INSERT INTO amn_n_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Afa ati ne enam nangug afa so na enaig mom sihiagahu. ");
INSERT INTO amn_n_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Afa kana awag ati sihi wahiag afa eba kike nem enaig faif eso ne gwena kimbig wa auguiafim ikan so na kifutig heven wa nai fi.” ");
INSERT INTO amn_n_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Afa Sisas ehengelim Betani Kimbig muhwa wankana. Afa heafna ningam fingi fe fuku gufnaba eso enaig esona og God so ma nem lahlafehiage gofi. ");
INSERT INTO amn_n_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Afa ehe enaig ese wahianim eso God ehem heven gam sulu fa fukuna. ");
INSERT INTO amn_n_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Afa ehengel ehena unehlagim fingi finim eso sifakali finibi Jerusalem gam piske ahuna. ");
INSERT INTO amn_n_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Afa enanai yi Godna Nalig lala auguiafenaba afa so Godum lahla fe fini. ");
INSERT INTO amn_n_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Afa autunam nemug ohuna bite mas gifni mo afa el mungo fena eba Godna Mo afa ehe God i ahagag fena afa ehe God fena. ");
INSERT INTO amn_n_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Eba inim autunam nemug enag Mo ati gofena afa enag Mo eba el God i ahagag fena. ");
INSERT INTO amn_n_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Afa enag Mo eba mog feg eso mungwali pugug afa big nangug afa mingnag meagam gohug. Afa God enag Mona mungwali gafugafiahgena. ");
INSERT INTO amn_n_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Afa inim nofkenagag enag Mo wa go afa enag nofkenagag elim afwambusug faig. ");
INSERT INTO amn_n_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Afa enag el eba afwambusug sikikiegim higafeg afa sikifig mas afwambusugim filafe. ");
INSERT INTO amn_n_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Afa God mungo elim ningihiag heafna unehlagba Jon. ");
INSERT INTO amn_n_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Afa Jon bogim mungwali elim ohuna afwambusug mo sihinig eso mungwali heafna mo higigim soma enag mom olug onigini. ");
INSERT INTO amn_n_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Afa Jon ehe mang enag afwambusug mo eba awai afa ehe enag afwambusugim elim wagfunig. ");
INSERT INTO amn_n_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Afa enag inim afwambusug eso ohuna bite wa pe bog eso mungwali elim afwambusug fenif. ");
INSERT INTO amn_n_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Afa God mo bihig esonaba eso enag Mo mungwali ohuna bite wa opukeakana. Afa enag Mo ohuna bite wa ehe puguna afa ohuna bitenai el mas anwanafini mo eso mungwali ehe gafugafeg. ");
INSERT INTO amn_n_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Afa ehe heafna mungo musunai elim boni afa heafna el mas ehem mas lahlafe fini mo. ");
INSERT INTO amn_n_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Afa amangel ehem lahlafe figbi eso ehem olug oningigba God enaig elim mina piginig eso God enaig esog ne kana luwalig opukog. ");
INSERT INTO amn_n_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Afa enaig luwal afag mas wanigai afa mang bigelni awag afagna membug wa mo eba God ehe feg eso opukog. ");
INSERT INTO amn_n_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Afa enag Mo el lofug bonam bigelim olyi fenif. Afa mahim bigim wangafenaba afa big nangug ehe hugna nalig feg. Afa God ehem enaig esenagba nalig feg eso heafna leg mungo feg. Afa ehe ati elim ismunagim kwaganig afa ehe Godna ahanaig ahanaigim mungwali bigim inim wagfunig. ");
INSERT INTO amn_n_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Afa Jon bogim ehena mo sihiakag. Afa ehe enaig esog “Autunam ka nengelim sihinig ka ma gosu ikafiba eso mungo el sum bof afa ehena unehlag nalig feg afa kaba wesig feg eso ka mahim meini fiahfenaba afa ehe ati God i ahagafena.” ");
INSERT INTO amn_n_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Afa heafna nihe eba bigim higeg ismunagim kwaganig gohugim eso bigim lahlag wambfieg afa ehe bigim gwenaig esenigofif. ");
INSERT INTO amn_n_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Autunam God heafna nihe mo Mosesim faina eso bigel anwanafig afa yawo Sisas Krais wagfug Godna nihe enaig ismunagim kwaganig afa inim mo bigim pugunig. ");
INSERT INTO amn_n_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Afa mas aman el Godum nanguna mo afa heafna leg mungo ehe God fena afa ehe Awag i ahagag fena eso bigim God numwehe wagfunig. ");
INSERT INTO amn_n_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Afa Jerusalemnai Ju elni misog el membeni Jonim sahna eso gafuga elim afa mingnag prisim Jon nangum ningitigina. Afa ehengel ambugonam ehem sahni og, “Ne aman mahim?” ");
INSERT INTO amn_n_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Afa Jon mas mwahlai gofena mo eba ehe ambagwa esoni og, “Ka mang Godna Gishu Wahiag El mo.” ");
INSERT INTO amn_n_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Afa ehengel ehem piske sahni og, “Ne mang enag el mo afa ne aman mahim? Ateaho ne Elaija?” Afa ehe og, “Kaba mang enag el mo.’ Afa ehengel agfofenaba piske sahni og, “Ateaho ne Godna mo fi sihiaule el eso kagel nengia agfofena?” Afa ehe sihini og, “Amo kaba awai.” ");
INSERT INTO amn_n_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Afa ehengel enaig esogona, “Kagelim sihi neba aman mahim. Afa mahim ne sihiba ka higinim eso piske ahunam kikiafgelni misog elim sihigoni eso kagelim ningitigi eso sihi nembefum ne aman mahim?” ");
INSERT INTO amn_n_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Afa Jon sihini og, “Autunam Godna mo fi sihiaule el Aisaia enaig esog; ‘Afa kaba el mungo bite bihig wa gonam afa hugna esof og, Ainiyagna mina lahlafiahgi soma boi.’” ");
INSERT INTO amn_n_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Afa mingnag el Jonim nangugim ambugona eba farisi el, ");
INSERT INTO amn_n_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","afa ehem sahnagim og, “Afa ne mang Godna Gishu Wahiag El, Elaija, afa Godna mo fi sihiaule el mo eso ahanaig esegba ne elim bu wa aitig?” ");
INSERT INTO amn_n_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Afa Jon sihig, “Ka bu bihig wa aitig afa mungo el nengelnai yi olyi eso go afa ehem ne mas anwanafig mo. ");
INSERT INTO amn_n_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Afa ehe kana sum eso bof. Kaba el feg afa eheba hugna lahlag nemug eso ka mas ehem muhwa fenai afa kweagfunam ehena mong lofug hugufanai.” ");
INSERT INTO amn_n_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Afa enag el enaig Betani kimbig wa esena eba Jordan bu ehengam maligim, afa enanai yi Jon aitiagena. ");
INSERT INTO amn_n_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Afa ming osuna Sisas Jon nangum boafenaba eso Jon ehem nangonam esona og, “Sa nangu, enag el Godna sipsip luwalig obo afa ehe bigelni amtakwaligim kufa fatiagim. ");
INSERT INTO amn_n_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Enag el ati ka nengelim sihinig. Ehe sum bonam afa ehe gosuf afa ehe hugna nalig feg eso ka mahim meini fiahfenaba afa ehe ati God i ahagafena. ");
INSERT INTO amn_n_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Afa gof ka mas ehem anwanafena mo eso ka enaig eseg elim bu wa aitinugeg eso God enag elim bigel Israelnaim ambagwa wagfunif.” ");
INSERT INTO amn_n_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Afa Jon ming mo sihina og, “Ka nangug Godna Sungwag gamb lofug of wa nai pe bonam Sisas i ahgofuf. ");
INSERT INTO amn_n_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ka gaba ehem mas anwanafenag mo. Afa autunam God kam ningihiana elim bu wa aitiagim afa ati kam sihina og, ‘Mahim ne nanguiba Sungwag pe bonam el i ahgofuf eso ne anwanafef eba enag el Godna Sungwagna bu wa aitif.’ ");
INSERT INTO amn_n_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Afa kike ati nangug eso ka nengelim sihinig enag el eba Godna Leg.” ");
INSERT INTO amn_n_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Afa ming osuna Jon afa heafna sambaganigi pahlukuiag el gwenanai yi piske agfofena. ");
INSERT INTO amn_n_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Afa nanguni mahim Sisas ikafenaba afa Jon sihina og, “Nango enag el Godna sipsip luwalig!” ");
INSERT INTO amn_n_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Afa sambaganigi enag mo ahiginam eso Sisas nangum sum ahkana. ");
INSERT INTO amn_n_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Afa Sisas wahigefe nanguagena sambaganigi sum ahboafena eso sahtigina og, “Mangim neningi memb ahfeg?” Eheningi esona og, “Rabai ahnanai yi ne gafif?” (Enag mo ‘Rabai’ Hibruna mona sefig eba tisa.) ");
INSERT INTO amn_n_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Afa ehe sihini og, “Eso ahbo ahnangu.” Eba osuna eso eheningi ahkanam afa heafna kugagim wagfuni. Afa enanai yi enag osuna Sisasim wani ahwanigiafena. ");
INSERT INTO amn_n_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Afa enag mungo el eba Andru afa ehe Saimon Pitana sumineg. ");
INSERT INTO amn_n_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Afa Andru Sisasim washunam afa ikagna eteg nangum ikana eso sihina og, “Kaningi Godna Gishu Wahiag Elim ahnanagug.” (Afa Grikna mo enag elim sefig Krais.) ");
INSERT INTO amn_n_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Afa ehe Saimonim Sisas nangum wanibuna. Afa Sisas ehem nangunam esona og, “Nana unehlagba Saimon Jonna leg afa yawo ka nem yawonai unehlag faif eba Sifas.” (Enag unehlag Grikna mo sefig Pita eba hun.) ");
INSERT INTO amn_n_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Afa ming osuna Sisas oningina og ka Galili gam ikaf. Afa ehe Filipim yisigi nangunam eso esona og, “Sa bo kam pahlu bu.” ");
INSERT INTO amn_n_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Afa Betsaida eba Filip, Andru afa Pita ehengelni kimbig feg. ");
INSERT INTO amn_n_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Afa Filip Natanielim yisigi nangunam sihina og, “Autunam Moses heafna nihe mo mungo lahlag elim ginofena afa Godna mo fi sihiaule el ehengel gaba gwenag elim ginofena. Afa kagel enag elim ati nangug eba Sisas Josepna leg ehe Nasaretnai el.” ");
INSERT INTO amn_n_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Afa Nataniel esona og, “Ka oningig enag kimbig Nasaret mas mang lahlag pugui.” Afa Filip esona, “Sa bo nangu.” ");
INSERT INTO amn_n_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Afa Nataniel bihia ikafnaba. Afa Sisas Natanielim nangunam mahim boafenaba afa esona og, “Ohuna elim so nangu ehe Israelna nihe lahlag pahluku feg afa heafna mo i nihe i eba inim feg.” ");
INSERT INTO amn_n_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Afa Nataniel ehem sahna og, “Ahnaig anwana ne kam fenag?” Sisas esona og, “Afa Filip mas nem puguna eso ne fik li mog wa gafena eso ka nem nanguna.” ");
INSERT INTO amn_n_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Afa Nataniel sineminafenam esona og, “Tisa, neba Godna leg afa ne Israelna misog el.” ");
INSERT INTO amn_n_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Afa Sisas esona og, “Ka nem sihinag ka nem nangug eso ne li mog gafena eba wesig feg eso ne kam olug oningina. Eso ne nalig kigmog nangufe.” ");
INSERT INTO amn_n_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Afa ehe ming mo sihina og, “Ka nem inim sihinig so na nanguf heven wa nai mengig pigif eso ka Inim Elbi gofiba enaig ling lofug afa Godna ofwanai el enag mina apaigo gofenam afa piske kwaliafena.” ");
INSERT INTO amn_n_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Afa sambaga sinaini mahim ikanaba Sisas heafna pahlukuiag elim Galilina bite wa opukona afa Kena kimbig wa auguna. Enanai yi el mungo angwafig fana eso ehem buyis fini. Afa Sisasna afag ehe gaba enag buyis yi bona. ");
INSERT INTO amn_n_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Afa ehengel Sisasim afa heafna pahlukuiag elim esogoni og, “Au ambugo kagelni buyis wa.” Eso ehengel ahuiagohna. ");
INSERT INTO amn_n_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Afa mahim ehengelni wainbug awaienaba afa Sisasna afag ehem esona og, “Ehengelni wainbug awai.” ");
INSERT INTO amn_n_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Sisas esog, “Mia, magim ne ehengelni kinig mo ne kam sihinag? Ohnaba mang kana was mo eso ka kikefum ambagwa puguf afa enag osuba meini fe.” ");
INSERT INTO amn_n_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Afa heafna afag gafugag elim sihini og, “Heafna mo so nengel pahluku.” ");
INSERT INTO amn_n_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Afa Ju elni nihe enaig fane ahgaginim ofibi eso ninga bu wa sugum eso ahgag. Afa enwesog wa gohug sob muhwa fohlu hwai yi eba ninga sug sob. Enag sob eba naligig yi enaig dram lofug. ");
INSERT INTO amn_n_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Afa Sisas gafugag elim sihini og, “Ohuna sobni bu efiyibi.” Eso enag sob soma memtog wa pugui. ");
INSERT INTO amn_n_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Eso ehe ehengelim enaig esoni og, “So na wesig efiyi buyisna awagim faiba soma ne nangui.” Eso ehengel enaig esini. ");
INSERT INTO amn_n_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Afa bu ati wainbug lofena eso bu yisna awag ne nanguna. Afa ehe mas anwanafena mo ahnanai ehengel fig. Afa gafugag el enam anwanafini afa mas sihini mo. Afa buyisna awag el angwafig eso fag enam awamonam ahkanam, ");
INSERT INTO amn_n_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","eso sihiagena og, “Mungwali el enaig esini lahlag wainbug gof mangeni eso heafna mangau ningag ahgagini afa sumi ehe mingnag wainbug mangeni eso enag mas lahlag fena mo eso gof mangeni. Eso ne hugna lahlag wainbug ne kumuhlagim eso yawo ne mangofin.” ");
INSERT INTO amn_n_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Afa enag kigmog Sisas gof wagfuna Kenana kimbig wa Galili provins ehe enaig esena. Afa enag kigmog heafna pahlukuiag el wagfuni heafna kifutig eba hugna nalig feg eso ehengel ehem olug onigini. ");
INSERT INTO amn_n_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Afa Sisas, heafna awag i, sumineg i, afa pahlukuiag el enag kimbig wahinim eso Kaperneam wa mwakwalig augunam eso ahuna. ");
INSERT INTO amn_n_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Afa Ju elni Pasova buyis muhwa ofefenaba eso Sisas Jerusalem gam ikana. ");
INSERT INTO amn_n_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Afa ehe Godna nalig lala sahu ikanam nanguna el enanai yi enaig gafugafini kig wambufini afa kau, sipsip, afa twafig mimageagifini. Afa mingnag el angoluwagna kig fifinim afa heafgelni kig mo ehengelim faigofena. ");
INSERT INTO amn_n_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Afa ehe nangunam mahim enaig esinibi eso ehem olug kinig fena afa ehe we fanam sisim enana kukoaitifenam eso sis embem opuko ahuaminefena. Afa kig wambug elni sime wahigefe kig nahgum wambaitifena. ");
INSERT INTO amn_n_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Afa ehe twafig mage elim wagnana og, “Enag wambinam gwesim wanika. Nofeka kana Humuana lalam maket lala lofug enaig esi.” ");
INSERT INTO amn_n_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Afa Sisasna pahlukuiag el nangunim eso onigini autunam enag Godna mo ginofini eba enaig esog, “Ka oningig Godna lala soma lahlag gofi eso enag oningig kana olug yi suwi lofug wagi. Afa ka oningig gwenam mungo fenag.” ");
INSERT INTO amn_n_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Afa Ju el Sisasim waginini og, “Ne magim enaig eseg. Enaig eso nimbiafna kigmog kagelim wagfuni eso kagel anwanafi God nem sawiyi fenag nem og enaig ese eso ne enaig eseg.” ");
INSERT INTO amn_n_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Afa Sisas wahigi sihini og, “Afa nengel ohuna nalig lala bubugi aitifigba eso ka sambaga mungo osuna piske nimbaf.” ");
INSERT INTO amn_n_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Afa Ju el sihini og, “Ateaho, ne enaig esef? Afa 46 yia kagelni amunai el ohuna lalaba nimbig. Ahanaig eseg so na esog sambaga mungo osuna ka piske nimbaf?” ");
INSERT INTO amn_n_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Afa enag nalig lalam Sisas esonaba eba heafna eligim esona. ");
INSERT INTO amn_n_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Eso mahim ehe wahanaba afa piske bihiana afa heafna pahlukuiag el piske onigini enag mo ehe esona. Eso ehengel olug oningig Godna mo buk wa gi afa oningig Sisasna mo eba inim. ");
INSERT INTO amn_n_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Afa mahim Ju elni Pasova buyis ofefenaba Sisas Jerusalem wa gafena. Afa el heafna kigmog nanguni eso el numb ehem olug oningig. ");
INSERT INTO amn_n_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Afa Sisas ehengelim anwanafenim eso mas muhwafeni mo. ");
INSERT INTO amn_n_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Afa ehe hefum ati anwanafeg ehengelni oningigim eso aman el mas ehem sihinai. ");
INSERT INTO amn_n_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Afa mungo el heafna unehlagba Nikodemus eba Ju elni misog el. Afa ehe mingnag Godna mo anwana elim wangafena afa enaig el sefig farisi el. ");
INSERT INTO amn_n_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Afa sinaini ehe Sisasim nangwagim bonam sihina og, “Amunai, kagel anwanafig ne tisa God ehe nem ningihiag. Afa el Godna feg hwanigba eso ehe mas enaig kigmog wagfuni eso ne eseg.” ");
INSERT INTO amn_n_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Afa Sisas sihina og, “Ka nem inim sihinag afa el so piske ikanam ninganai luwal fe hwanigba eso enag el mas Godna bog megam nangui.” ");
INSERT INTO amn_n_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Afa Nikodemus sahna og, “Ahnaig esegba eso muhuna el piske ikanam ninganai luwal fef. Afa ehe mas afagna wula wa sahunam eso piske wanigai. Afa el bigel mas enaig esi.” ");
INSERT INTO amn_n_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Afa Sisas piske sihina og, “Ka nem inim sihinag afa el eso buna afa Godna Sungwagni ninganai luwal feg hwanigba eba ehe mas Godna bog megam sahokai. ");
INSERT INTO amn_n_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Afa luwal awagafagna mungo usumu wa agfohieg eba awagafagna membug wa eseg eso luwalna eligim nofkenagag faig. Afa el Godna mungo usumu wa agfohieg eba Godna Sungwag eseg eso elni sungwagim nofkenagag faig. ");
INSERT INTO amn_n_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nofeka sineminafe ka nem enaig sihifenag so na piske ikanam ninganai luwal fe. ");
INSERT INTO amn_n_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Afa Godna Sungwag eba fufei lofug. Afa fufei bogim afa el ehena mina mas anwanafeg mo ehe ahanaig bofeg afa ahanaig ikafeg. Godna Sungwag enaig eseg eso elim yimieg nofkenagag faig enaig ninganai luwal lofeg.” ");
INSERT INTO amn_n_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Afa Nikodemus ehe mas anwanafena mo eso sahna og, “Ahnaig esegba soma enag enaig eseg?” ");
INSERT INTO amn_n_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Afa Sisas og, “Ateaho ne Israelnai elni tisa asegba ne kana mo mas anwanafeg mo. ");
INSERT INTO amn_n_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ka nem inim sihinag mang eso kagel anwanafig afa nengelim sihigonug afa mang eso kagel nangug nengelim sihig eso nengel kagelni mo mas higigonig mo. ");
INSERT INTO amn_n_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Afa ka nem bitenaina waskwes mo sihinigba eso heven wa nai gawigim wagfunig eso ne mas ena mo higig mo afa ka nem ofwanaina mo sihinaiba, so na higi? Amo, eba mas ne enam gaba higi. ");
INSERT INTO amn_n_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Afa mas aman el Godna kimbigam nangug mo, kike mungo. Kaba Inim El afa ka enanai yi wahianam eso ohuna bite wa pe bog. ");
INSERT INTO amn_n_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Afa ne anwanafeg autunam Moses mwakwal sombine kapa kegna gafugafena eso aga wa kikenam sisyi fingi fena eso aman gih el enam nangwafenaba gih lahlafefena. Afa Inim Elim gaba kikenam aga sisyi fingi fif. ");
INSERT INTO amn_n_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Eso aman el ehem olug oningigba soma higeg nofkikenagag fi. ");
INSERT INTO amn_n_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Afa God mungwali elim hugna membini eso heafna Leg mungo nemug ohuna bite wa ningihiana. Eso aman el ehem olug oningig soma higeg nofkenagag fi afa ehe mas awaiye. ");
INSERT INTO amn_n_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Afa God heafna legim ningihiana mang kwefihiagegim afa tautig fai enaigim bo mo eba awai God ehem ningihiana soma ehe elim kwagani. ");
INSERT INTO amn_n_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Afa aman el legim olug oningig afa enag el kwefihiagegim mas kuskufe. Afa aman el enag Godna legim mungo mas olug oninginag mo eba enaig God ehem ati kwefihiageg. ");
INSERT INTO amn_n_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Afa enag mina God elim kwefihiageg afa afwambusug ati bog eso mungwali elim ambagwa wagfunig ehengelni auguiagim. Afa el ehe afwambusugim mas membinag mo afa heafgelni nihe amtakwalig pahluhug eso ehengel og ka so sikifig wa agfohiefim. ");
INSERT INTO amn_n_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Afa el amtakwaligim esig ehe afwambusugim mas membeni eso afwambusugim mas muhwa feni. Afa ehe enaig esig eso ehengel embefig enag afwambusug heafgelni amtakwalig nihe ambagwa wagfuf. ");
INSERT INTO amn_n_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Afa aman el inim mo pahluku eba afwambusug yi go afa ehe mas embefe. Soma enag afwambusug heafna gafugagim ambagwa wagfunai eba Godna membug wa ehe enaig eseg.” ");
INSERT INTO amn_n_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Afa mahim enaig esenaba Sisas afa heafna pahlukuiag el provins Judia ahuna. Enanai yi auguiafenaba eso elim bu wa aitigonugini. ");
INSERT INTO amn_n_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Afa Jon Ainon kimbig wa gafna eba Salim muhwa go. Enanai yi enaksag buna feg afa el ehem nangugim ambugona eso ehe gaba ehengelim bu wa aitina. ");
INSERT INTO amn_n_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Afa enanam Jon mas kalabus lala gofena mo. ");
INSERT INTO amn_n_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Afa mingnag Jonna pahlukuiag el Ju elim mo esuni. Afa ehengel Ju elni buwa sug nihem sihiageni. ");
INSERT INTO amn_n_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Afa ehengel Jonim nangunim eso sihini og, “Tisa, autunam enag mungo elim ne sihina eso Jordan buum magim ne yi ahagafena. Sa hig, mungwali el enag elim nangum ahuiaba eso ehe bu wa aitif.” ");
INSERT INTO amn_n_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Afa Jon wahigi sihina og, “Mungwali mang el eso fag eba God ehem faig. ");
INSERT INTO amn_n_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nengel nimbe ati higig ka nem enaig esoni og, ‘Kaba mang Godna Gishu Wahiag El mo kaba gof mina isug tuhla bog.’” ");
INSERT INTO amn_n_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Afa Jon enaig waskwes mo piske sihina og, “Afa el angwafig fagim ofeba eso heafna hihe buyis numwehiagena. Afa enag hihe mas angwafig fai eso ehe gafugafenagim enag angwafig fag elim ningenago. Afa mahim ehe angwafig fag elni mengigim higinam eso sifakalef. Afa ka ati Sisasna mengigim higinam eso ka gaba gwenaig sifakaleg. ");
INSERT INTO amn_n_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Afa ka oningig ehe naligfeba afa kaba wesigfef. ");
INSERT INTO amn_n_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Afa el heven wanai bog eba sisi fenig bitenai elim. Afa el bitenai feg ehe bitenai mo sihiagig. Afa el Godna kimbig wa nai bog ehe mungwalim sisi fenig. ");
INSERT INTO amn_n_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Afa mang ehe ati nangug afa higig eso sihinig. Afa el heafna mo higigim eso mas fi. ");
INSERT INTO amn_n_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Afa aman el heafna mo kehlag eso enag wagfunag Godna mo eba inim. ");
INSERT INTO amn_n_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Afa enag el God ningihiag eba God ehena Sungwag ehem mungwali faig eso heafna mo eba Godna mo. ");
INSERT INTO amn_n_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Afa Awag Legim hugna membegim eso mungwali ehena ninga wa wahiag. ");
INSERT INTO amn_n_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Afa aman Legim olug ehe ati higeg nofkenagag fag. Afa aman Legim masig fatig eba mas nofkenagag fai eso Godna nunimu ehenai yi higeg gofif.” ");
INSERT INTO amn_n_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Afa el numb Sisasim pahlukuna eso bu wa aiti fena. Afa mungo mungo Jonim pahlukuna afa farisi el enag mo higig. ");
INSERT INTO amn_n_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Afa Sisas ehe mas elim bu wa aitina mo eba heafna pahlukuiag el elim bu wa aitini. ");
INSERT INTO amn_n_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Afa mahim Sisas anwanafenaba farisi el enag gafugam mo sihiagini eso ehe Judia provins wahianam Galili provins piske ikana. ");
INSERT INTO amn_n_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Afa enag mina Galili yi gam ikagba eba Samaria provins wa pugunam eso Galili wa ika pugug. ");
INSERT INTO amn_n_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Afa ehe Samaria ikafenaba afa Sikar kimbig wa puguna. Autunam Jekop heafna leg Josep bite faina. Enag kimbig ohuna bite wa muhwa feg. ");
INSERT INTO amn_n_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Afa Sisas Jekopna mime wa pugunam afa ehena kig euiauwina eso enanai yi ehefena. Eba osu misosuf gigni. ");
INSERT INTO amn_n_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Afa Samariana angwafig mungo bu efiyigim bona eso Sisas ehem sahna og, “Kam bu efiyi fai, kau nem.” ");
INSERT INTO amn_n_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Afa heafna pahlukuiag el kimbig gam ahuna fane wambugum.) ");
INSERT INTO amn_n_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Afa enag angwafig sineminafena eso ehem sihina og, “Neba Ju el afa ka Samarianai angwafig asegba ne kam buum sahnag?” (Afa ehe enaig esog eso Ju el mas Samariana enag kaf mungo wa ahgai.) ");
INSERT INTO amn_n_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Afa Sisas sihina og, “Ne mas anwanafeg mo mang God elim eso isug faig afa kaba aman mahim. Afa ne enam anwanafegba afa ne kam buum sahnaiba eso ka nem nofkenagag bu faif. Enag bu soma higeg nofkenagag nem fai.” ");
INSERT INTO amn_n_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Afa angwafig sihina og, “Amunai, ne sobini mo buba efiyi yi afa mime eba mungwanam pekag. Ahana nai yi so na enag nofkenagag bu efiyif? ");
INSERT INTO amn_n_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Kagelni simp Jekop enag mime kona afa ehe heafna luwaligna afa heafna sisna eso enag mime bu ahgafufena. Ehe enag mime kagelim faig. Ateaho ne oningig ne nalig el eso kagelni simpim Jekop filafeg.” ");
INSERT INTO amn_n_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Afa Sisas wahigi sihina og, “Aman ne enag bu negba eba nem piske bu hefef. ");
INSERT INTO amn_n_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Afa aman ohuna bu nafef eso ka nem fai eba mas nem piske bu hefei. Afa enag bu el nai yi sahu go enaig bu eba lugifif afa mas awaiye eba elim higeg nofkenagag faif.” ");
INSERT INTO amn_n_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Afa angwafig ehem enaig esog, “Amunai, enaig so kam enag bu fai eso ka mas bu hefei afa piske boi ohunanai efiyi yi.” ");
INSERT INTO amn_n_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Afa ehe angwafigim sihina og, “Sa ikanam nimbiafna ligagim wani bu.” ");
INSERT INTO amn_n_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Afa angwafig wahigi esona, “Kana awagagba awai.” Sisas sihina og, “Enag moba ne sihigba eba inim. ");
INSERT INTO amn_n_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Afa ming mo ne sisage afa inim nemug autunam ne afawa gohug kwamblo ne wambug afa yawo so na ahagag eba mang neana ligag mo.” ");
INSERT INTO amn_n_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Afa ehe Sisasim esona og, “Amunai, ka anwanafeg neba Godna mo fi sihiule el. ");
INSERT INTO amn_n_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Kagelni simbianingag enag Samarianai mug gim enaig esog enanai yi kagel so Godum sahni afa heafna unehlag fingi fi. Afa nengel Ju el enaig esogog kagel Jerusalem wa mungo so enaig esig.” ");
INSERT INTO amn_n_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ehe enaig esog eso Sisas sihina og, “Kana mo higinam so lahlag kikehlaf. Autunai wa nengel enaig esif. Ehengel mas enag mug wa afa Jerusalem wa ambugonam eso Humuana unehlag fingi fif. ");
INSERT INTO amn_n_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Afa nengel Samaria nai el mas Godum numwehe anwanafig mo eso nengel heafna unehlagim mas lahlag fingi fig mo. Afa kagel Ju el Godum lahlag anwanafig eso ehem fingi fig. Afa God kagelim Ju elim kano hwatig eso heafna mo ehengelim faig eso enag mina ehe mungwali elim kweafug. ");
INSERT INTO amn_n_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ati meini ofe afa el mas oningig ahnanai yi so Godum fingi fef afa lahlag el yawo enaig eseg ehe Sungwag kifutigni afa inim nihena Humuanim fingi fi. Afa God membeg enaig el soma gwenaig ehem eseni. ");
INSERT INTO amn_n_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God eba lahlag sungwag afa el ogna ehem inim ahnai skaufinig eso Sungwag kifutigni afa inim oningig Godum fingi fig.” ");
INSERT INTO amn_n_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Afa angwafig sihina og, “Ka anwanafeg Godna Gishu Wahiag El eso bof (el ehem sefig Krais) afa mahim ehe boiba afa enag el Godna mungwali oningig bigelim sihinig eso ambagwa wagfunif.” ");
INSERT INTO amn_n_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Afa Sisas sihina og, “Biningi eso sihiag ahfegoba. Eba kike enag el.” ");
INSERT INTO amn_n_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Afa sihiage fegofenaba heafna pahlukuiag el ambugonam eheningim nangwagini. Afa ehengel oningig Ju elni tisa mas angwafig i mo sihiag ahfei eso ehengel sineminafini. Afa ehengel mas angwafigim sahani mo, “Mang ne membeg?” Afa Sisasim mas sahani mo, “Ahnaig esegba ne angwafigim mo sihinag?” ");
INSERT INTO amn_n_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Eso enag angwafig heafna sob wahianam ikanam kimbig wa nai elim sihinig og, ");
INSERT INTO amn_n_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Au ambugog elim nangu. Ahnaig ahanaig eso ka eseg enag el ehe kana mo ambagwa sihig. Ateaho enag el Godna Gishu Wahiag El mahim?” ");
INSERT INTO amn_n_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Eso enag el kimbig wahinim ahu Sisasim nanguni. ");
INSERT INTO amn_n_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Afa enanam pahlukuiag el Sisasim mengigna esoni og, “Tisa, fane afogwa so na.” ");
INSERT INTO amn_n_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Afa ehe ehengelim sihini og, “Kaba kiafna fane ati feg ka ma enag nafef. Afa enag fane nengel mas anwanafig mo.” ");
INSERT INTO amn_n_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Afa pahlukuiag el hefum sihiageni og, “Ateame aman el ehem fane fa bu faig me eso ehe mas biniwahag mo?” ");
INSERT INTO amn_n_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Afa Sisas esog, “Afa God kam ningihiag eso ka heafna sawiegim pahlukug. Kana fane eba enag gafugag esenagim eso heafna gafugag auginif. ");
INSERT INTO amn_n_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Afa nengelni mo enaig esog, ‘Sambaga sambaga was mahim asonai takeba.’ Afa ka nem sihinag Godna aso so nangu afa enag asonai ati takeg eso wambugef.” ");
INSERT INTO amn_n_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Afa Sisas waskwes mo piske sihina og, “Autunam gafugag el asonai ihigig afa yawo mingnag gafugag el ambugog asonai wambuf eso ehengel enag gafugag enanam kig wambuf afa enag asonai higeg gwese afoguafuf eso ihigig el afa wambug el soma eheningi sifakalafei. ");
INSERT INTO amn_n_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Afa el numb gwenaig mo sihig og, ‘Mungo el asonai ihigeg afa ming el bo wambug.’ Enag mo eba inim. ");
INSERT INTO amn_n_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Afa mingnag Godna aso nengel mas ihigig mo ka nem ningitigiba so na asonai wambugi. Mingnag el enag aso nalig gafugafig afa henigi faskofeg afa ehengelni gafugag ati nengelim kweafug.” ");
INSERT INTO amn_n_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Afa angwafig kimbig wa naim sihini og, “Ahnaig ahanaig eso ka eseg enag el ehe kana mo ambagwa sihig” afa enaksag Samaria wa nai el ehena mo higinim eso Sisasim olug onigini. ");
INSERT INTO amn_n_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Eso Samaria wa nai el ambugog ehem mengna sihini og, ne kagelim ohunanai yi wangagim. Eso ehe sambaga osuna ehengelim wangana. ");
INSERT INTO amn_n_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Afa ehe bo sihiagegba afa heafna mo higigim eso el numb ehem olug oningig. ");
INSERT INTO amn_n_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Afa ehengel angwafigim sihini og, “Autunam ne sihinaba eso neana mo kagel kikehli ogfuhiafena afa yawo kike heafna mengigim higigim eso kagel anwanafig ehe eba enag el ehe mungwali elim kwaganig.” ");
INSERT INTO amn_n_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Afa Sisas enanai yi sambaga osuna ganam afa wahianam Galili gam ikana. ");
INSERT INTO amn_n_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Afa Sisas hefum enaig esona og, “Godna mo fi sihiule el heafna kimbig wa nai mas ehem lahlafe fi mo.” ");
INSERT INTO amn_n_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Afa mahim ehe Galili provins pugunaba afa enag kimbig wa nai el ehem nangunim sifakalini eso mahim ehengel Jerusalem wa Pasova buyis wa ahunaba eso ehengel enanai yi heafna mungwali kifutig gafugag nanguni. ");
INSERT INTO amn_n_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Afa ehe piske ikanam Kena kimbig wa pugunam enanai yi ehe eso buum wahigifena wain bug lofena. Afa Kaperneam wa nai gavmanna misog el Sisas nangum bona. Heafna leg Kaperneam wa gihna gifni. ");
INSERT INTO amn_n_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Afa ehe higinam Sisas Judia wahianam piske bog eso Sisasim nangwagim bonam sahna og kana leg wahagim ofe so na ikai Kaperneam gam ehem lahla fenagim. ");
INSERT INTO amn_n_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Afa Sisas ehem sihina og, “Nengel kam mas inim olug onigini mo. Nengel enaig onigfig eso ehe kifutig kigmog kagelim wagfug hwanigba eso kagel ehem mas olug onigini.” ");
INSERT INTO amn_n_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Afa gavmanna misog el ehem esona og, “Amunai, awamona ikagna ahka kana luwal mas so wahaf.” ");
INSERT INTO amn_n_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Sisas wahigi sihina og, “Eseka, neana luwal eba gohugimba.” Afa ehe enag mo higinam eso piske fakaf. ");
INSERT INTO amn_n_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Afa meini minam ikafenaba afa heafna gafugag el ambugonam mina wa ufinim sihini og, “Nana luwal eba gohugimba mas wahai.” ");
INSERT INTO amn_n_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Afa ehe ehengelim sahni og, “Mangigna eso luwalba lahlafeg?” Afa ehengel enaig esogona og, “Amu osu misosuf gigni ehem elig liputina.” ");
INSERT INTO amn_n_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Afa awag anwanafena amu osu misosuf gigni Sisas kam sihina og “Nana luwal eba gohuf.” Eso ehe heafna mungwali nilitena Sisasim olug onigini. ");
INSERT INTO amn_n_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Afa Sisas Judiam wahianam Galili puguna eso ehe enaig esena ohonaba angigieg kigmog ehe wagfuna. ");
INSERT INTO amn_n_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Afa ming osuna Ju elni buyis ofefiba eso Sisas Jerusalem gam ikaf. ");
INSERT INTO amn_n_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Afa mengig mungo Jerusalem kimbig wa go enag mengig eba sefig sipsipna mengig. Enag mengig eba mime bu muhwa go. Enag bugig Hibruna mo sefig Betesda afa wa gohug afwambag sime enag buum wagfiyig. ");
INSERT INTO amn_n_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Afa afwambag sime wa enaksag gih el enanai yi gofena. Afa enag gih el eba nof etetini afa mong ninga lihligna eso auguiafena. ");
INSERT INTO amn_n_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Afa mungo el mong lihlifegna 38 yia enaig fena. ");
INSERT INTO amn_n_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Afa Sisas ehem nangunam afa anwanafena ehe higeg gwenaig fena eso ehem sahna og, “Ateaho ne membeg so ma nem lahlafe?” ");
INSERT INTO amn_n_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Afa el sihina og, “Amunai, mas aman kam kweafug mo afa mahim bu nekuneku ofeba afa mingnag el goseg ahug apaigo go afa kaba awai.” ");
INSERT INTO amn_n_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Afa Sisas ehem esona og, “Sa bihianam kug fanam ika.” ");
INSERT INTO amn_n_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Afa ikagna ehe lahlafena afa heafna kug mumwane fanam eso ikana. Eba Isug Auguiag Osuna ehem enaig esena. ");
INSERT INTO amn_n_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Eso Ju el enag elim waginini og, “Afa yuwaba Isug Auguiag Osuna nofeka kug fanam eso oku. Afa bigelni nihe mo enaig gafugam kweg.” ");
INSERT INTO amn_n_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Afa el wahigi sihina og, “Ohuna el kam lahlafenag kam enaig esonag og, ‘Nimbeafna kug fanam ika.’” ");
INSERT INTO amn_n_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Afa ehengel ehem sahni og, “Aman nem enaig sihifenag?” ");
INSERT INTO amn_n_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Afa enag el mas anwanafeni mo aman ehem lahlafenag eso Sisas el numb meagam mungwali ahuwahena. ");
INSERT INTO amn_n_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Manige hwainig Sisas ehem Godna Nalig lala wa nangonam eso ehem sihina og, “Ei, neana elig ati lahlafeg. Sa higi so na enaig amtakwalig nihem so na wahia afa ne wahia hwanigba masa ne hugna tautig nalig fafe.” ");
INSERT INTO amn_n_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Afa enag el ikanam eso Ju elim sihini Sisas kana eligim lahlafefatig. ");
INSERT INTO amn_n_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Afa Sisas Isug Auguiag Osuna enaig esena eso Ju el ehem kinig faini. ");
INSERT INTO amn_n_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Afa Sisas ehengelim wahigi sihini og, “Kana awag mungwali osuna gafuga fafefe eso ka gaba gwenaig eseg.” ");
INSERT INTO amn_n_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Afa Juni misog el Sisasim wagini afa mahim enag mo higinibi ehengel Sisasim olug kakagenim og ehem tigibi ma wahai. Afa ehengel og ehe mas Isug Auguiag Osuna nihem pahluku mo afa mingam enaig esog God kana awag afa hefum fingi feg og kaba God i mungwalofug. ");
INSERT INTO amn_n_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Afa Sisas sihina og, “Ka inim sihinig, afa Leg mas heafna oningig wa enaig esei. Afa Awagna gafugam nangugim afa Leg gwenaig eseg eso mang awag eseg eba Leg gaba enag gafugag eseg. ");
INSERT INTO amn_n_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Afa Awag Legim hugna membenag eso wagfunag mungwali mang ehe eseg. Yawo nengel Godna kigmog ati nangug afa Awag Legim kigmog nalig wagfunagba eso Leg enaig esef eso nengel sineminafif. ");
INSERT INTO amn_n_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Afa Awag enaig esfaf ehe wahag elim fukwag washog afa higeg nofkenagag faig. Afa Leg gaba gwenaig eseg eso heafna membeg ehe amanim membenag eso nofkenagag faig. ");
INSERT INTO amn_n_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Afa Awag ehe mas elim kwefihiage afa kwefihiageg gafugag eba Legna ninga wa wahiag. ");
INSERT INTO amn_n_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Eso mungwali el soma Legim fingi fi gwenaig eso Awagim fingi fini. Afa Awag Legim ningihiag eso aman el mas ehem fingi fenag mo eba awagim gwenaig esenag. ");
INSERT INTO amn_n_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ka nem inim sihinig, aman el kana mo higinim afa Godum olug oniginigbi eso ehe kam ningihiag afa enag el higeg nofkikenagna feg eso God ehem mas kwefihiagenam tautig fai. Afa ehe wahagna mina wahiagim eso nofkenagag mina wa go. ");
INSERT INTO amn_n_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ka nem inim sihinig, ati muhwa feg eba yawo enag puguf afa el wahag mina wa agfo eso Godna Legna mengig higinim eso aman el ehena mengigim ati higinag eba nofkenagag fafe. ");
INSERT INTO amn_n_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Afa God elim nofkenagag faig eso ehe nofkenagag mog feg. Afa ehe Legim kigmog faig eso Leg gaba nofkenagag mog feg. ");
INSERT INTO amn_n_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Afa Leg eba Inim El eso God ehem enaig esona og, so na mungwali elim kwefihiagenuge. ");
INSERT INTO amn_n_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Afa enag puguiba eso nofeka kana mo sineminafi. Afa mungwali wahag el bitekfe wa afugoku eso Inim Elni mengigim higinim, ");
INSERT INTO amn_n_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","eso heafgelni bitekfe wahinim opukof. Afa aman el lahlag nihe esena eso bihianam piske nofkenagag fafe. Afa aman amtakwalig nihe esena eso bihianam God ehengelim kufenif. ");
INSERT INTO amn_n_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Kikefum mungo ka mas mang enaig esei. God kam sihinag eso ka higigim afa ka kwefihiageg. Ka mas kikeafna sawiegim pahlukui eba awai. Afa kam el eso ningihiag ka ehena sawiegim pahlu fakuf eso kana kwefihiag eba inim nemug. ");
INSERT INTO amn_n_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Afa kikeafna mo mungo sihiba kaba aman mahim eso enag mo eba mo bihig feg. ");
INSERT INTO amn_n_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Afa ming el kana mo sihif eba kana mo kweafug. Afa ka anwanafeg heafna mo kam sihinag eba inim. ");
INSERT INTO amn_n_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Afa nengel elim Jon nangum ningitigina eso ahu anwanafi ka aman mahim. Afa Jonna mo ambagwa inim sihina. ");
INSERT INTO amn_n_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ka mas oningig elni mo soma kana mo kweagfui. Afa ka Jonna mo sihinig eso nengelim kweafug soma nengel amtakwalig mina wahianam afa lahlag mina pahluku. ");
INSERT INTO amn_n_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Afa Jonna mo lam lofug eso nengelim afwambusug faig eso nengel enanam mwakwalig enag afwambusugum sifakalig. ");
INSERT INTO amn_n_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Afa Awag gafugag kana ninga wa wahianag eso ka enag gafugafe. Eso enag gafugag kana mo kweafug afa wagfug Awag kam ningihiag. Afa Jonna mo eba enaig eseg afa ohuna mo eba hugna lahlafeg. ");
INSERT INTO amn_n_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Afa Awag kam ningihiag afa ehe gaba kana mo kweafug. Afa nengel heafna mengigim mas higi afa heafna eligim mas nangug mo, ");
INSERT INTO amn_n_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","afa heafna mo mas nengelni oningi wa go mo. Eso nengel kam mas olug oningi mo eso ehe kam ningihiag. ");
INSERT INTO amn_n_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Afa nengel Godna ginofim ati fahigefig eso ne enaig esogog afa ka enag mogim anwanafeba ehe kam higeg nofkenagag faif. Afa enag ginof kam sihinag afa kam wagfunag kike aman mahim. ");
INSERT INTO amn_n_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Eba sihig ka elim nofkenagag faif eso nengel yiskosig kam pahlu ambugogim. ");
INSERT INTO amn_n_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Afa mahim el kam fingi figbi eso ka mas enam hugna oniginai. ");
INSERT INTO amn_n_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Afa ka ati anwanafenig nengel mas Godum inim membenig mo. ");
INSERT INTO amn_n_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Afa ka Awagna unehlag wa bog eso nengel kana mo mas kikehlig mo afa ming el heafna unehlag wa mungo boiba eso nengel heafna mo kehlif. ");
INSERT INTO amn_n_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Afa nengel nuwagigim nembefum fingi fig eso enam sifakali. Afa nengel mas oningi God mungo soma kagelni unehlagim fingi feni eso mas kam olug onigini. ");
INSERT INTO amn_n_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nofeka enaig onigifi ahanaig ahanaig amtakwalig nihe so na esig eso ka Godna nof wa nengelim kufinif eba awai eba Moses ehe enaig eseg. Nengel onigini Mosesna mo nengelim kweafug eso enag mo nengelim kufinig. ");
INSERT INTO amn_n_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Afa Moses kam ginofenag afa nengel inim Mosesna mo pahlukuibi eso kana mo gaba nengel pahlu ambugof. Afa nengel mas enaig esig mo. ");
INSERT INTO amn_n_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Afa Mosesna ginofim nengel mas kikehlig mo. Ahnaig esegba nengel so kana mo kehlif?” ");
INSERT INTO amn_n_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Afa mingnag osu wahianam Sisas Galili bu wa pugunam eso bot yi ehengam maligim ikana. (Galili bu ming unehlagba Taiberius.) ");
INSERT INTO amn_n_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Afa el heafna kigmogim nanguni mahim gih elim lahlafetifenaba eso el numb ehem pahlukuna. ");
INSERT INTO amn_n_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Afa Sisas mogim fukokanam afa heafna pahlukuiag elim wangafena. ");
INSERT INTO amn_n_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Afa enanam Ju elni Pasova buyis muhwa ofefenaba. ");
INSERT INTO amn_n_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Afa Sisas nof fiagena afa nangwagena el numb ehem nangugim ambugona eso Filipim sahna og, “Ahana nai so bigel fane finim ohunag enaksag elim faigoiba soma ahgai?” ");
INSERT INTO amn_n_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Afa ehe enaig esog ka Filipna oningig gihna mahim ahanaig sihi ofefiba. Afa Sisas ati ehe anwanafeg ehe enag fane faif. ");
INSERT INTO amn_n_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Afa Filip ehem wahigi sihina og, “Afa ka kug wa gohug was gafugafegba eso kig fag afa enag kigna ka stoa nai aba fim. Afa enaig aba mas ehengelim yuhwafenig mo.” ");
INSERT INTO amn_n_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Afa ming pahlukuiag el Saimon Pitana sumineg Andru kwablog luwalim nangunam eso ehe enaig esog, ");
INSERT INTO amn_n_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Ohuna kwablog luwal afa wa gohug aba sagig wesig wambina afa sambaga sawug wesig wambtigina. Afa enag fane mas enaksag elim yuhwafenig mo.” ");
INSERT INTO amn_n_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Afa Sisas enaig esona og, “Sihigonibi soma apaigo augui.” Enanai yi enaksag pos go eso 5,000 kwamblo enanai yi apaigo auguna. ");
INSERT INTO amn_n_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Afa Sisas enag aba sagig fanam eso Godum sahna og eba lahlag. Afa ehe kukoskofenam eso el apaigo augug enag elim mimangegoni. Afa ehe sawugim gwenaig esena. Afa mungwali ahgaginim yuhwa feskofena. ");
INSERT INTO amn_n_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Afa mahim enug feskofenaba ehe pahlukuiag elim sihini og, “Eso ahu wamb enag fane el mas ahgag mo masa wambaitifibi awaief.” ");
INSERT INTO amn_n_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Afa ehengel angoglui wambinam afa 12 pela sob yi aitini. Afa Sisas afa wa gohug aba sagig kukoskofena afa mungwali ahgagini eso angoglui sob yi aitini afa mengig wa puguna. ");
INSERT INTO amn_n_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Afa el enag kigmog nanguni afa enaig esogona og, “Autunam Moses sihi wahiana og Godna Mo Fi Sihiaule El ohuna bite wa bof. Ateaho inim enag el eso bona.” ");
INSERT INTO amn_n_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Afa Sisas ehengelim ati anwanafeni ehengel ogna Sisasim kikehlinim eso bigelni misog el goni. Eso ehe wasanam eso hefum mog gam piske ikana. ");
INSERT INTO amn_n_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Afa osupeafenaba afa Sisas mas bona mo. Eso heafna pahlukuiag el Galili bu blugum ahunam. ");
INSERT INTO amn_n_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Afa ehengel bot wa augunam eso Kaperneam gam bu nalig mina ahuna. Afa siokigfi fenaba ehengel meini bot yi ahuafenaba Sisas mas ehengelim wambina mo. ");
INSERT INTO amn_n_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Eso bifwat bonam afa buum wahigi wahigifena. ");
INSERT INTO amn_n_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Afa bot meini enwesog wa gohug kilomita olyi bu wa gofena eso ehengel Sisasim nanguni mahim bu sisyi ehengelim nangwagigim boafenaba. Eso ehengel hugna embefini afa kig kilafeskofena. ");
INSERT INTO amn_n_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Afa Sisas ehengelim esoni og, “Nofeka embefi eba kikeba.” ");
INSERT INTO amn_n_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Eso ehem awamoni afa ehe bot yi fukokaganam afa gwenanam enag bot ikagna bu blug yi ika puguna mina wa eso ehengel membeni. ");
INSERT INTO amn_n_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Afa Sisas elim fane eso faini enanai yi ehengel askanam lawam bihia gafenam afa ehefum sahigini og, “Sisas ahnanai yi mahim?” Afa ehengel anwanafini ehe mas heafna pahlukuiag el wankai afa ming bot awai. ");
INSERT INTO amn_n_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Afa mingnag Taiberius wa nai bot ambugonam enanai yi opukona. Afa enanai yi Sisas Godum sahnam og, eba lahlag eso fane mungwali elim faini. ");
INSERT INTO amn_n_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Afa ehengel anwanafini og Sisas i afa heafna pahlukuiag el i ohunanai yi mas go mo. Eso ehengel bot yi Kaperneam gam ahunam Sisasim yisigi ahuna. ");
INSERT INTO amn_n_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Afa ehengel bot wa ahunam ehengam maligim opukona. Afa Sisasim enanai yi nangunim eso sahini og, “Tisa, ohunanai yi amansi ne bona?” ");
INSERT INTO amn_n_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Afa Sisas wahigi sihini og, “Ka nem inim sihinig, ka nengelim aba sagig faini afa ne ahgagim eso ne enam membigim eso kam ambugog yisigig. Afa nengel kana kigmogim mas numwehe anwanafig mo eso ka wagfug. ");
INSERT INTO amn_n_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nofeka bite nai fanem hugna onigini eba enag nogif. Afa nengelni oningig so na nofkenagag fanem onigini soma nengelim higeg nofkenagag fai. Afa God kana Awag kam kanog wahiag eso ka heafna gafugag esenag eso enag fane Inim El nengelim faif.” ");
INSERT INTO amn_n_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Afa ehengel ehem sahni og, “Mang gafugag eso ka Godum esinif?” ");
INSERT INTO amn_n_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Afa Sisas wahigi sihina og, “Enag el eso God ningihiag so na ehem olug onigini. Afa enaig eba Godna gafugag.” ");
INSERT INTO amn_n_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Afa ehengel enaig esogog, “Mang kigmog kagelim wagfunif eso kagel enam nangunim nem olug oniginif. Mang so na esef? ");
INSERT INTO amn_n_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Afa mahim bigelni simbianinga bite bihig wa auguiafenaba afa aba ahgana eba sefig mana. Afa Godna mo enaig sihifeg, ‘Ehe ehengelim of wa nai aba faini eso ahgana.’” ");
INSERT INTO amn_n_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Afa Sisas sihina og, “Ka nem inim sihinig. Enag aba Moses bigelni simbianingam faini eba mang inim of wa nai aba mo. Afa kana Awag eso nengelim inim of wa nai aba faig. ");
INSERT INTO amn_n_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Afa Godna aba eba enag el eso of wa nai pe bog eso bite nai elim inim nofkenagag faig.” ");
INSERT INTO amn_n_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Afa ehengel sahni og, “Amunai, enaig so na kagelim enag aba higeg mange gonigofim.” ");
INSERT INTO amn_n_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Afa Sisas sihina og, “Enag aba ka nengelim sihinig eba kike. Ka elim higeg nofkenagag faig. Afa aman ne kam nangum boiba mas piske biniwahai. Afa aman ne kam olug onigiba mas piske bu hefei. ");
INSERT INTO amn_n_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Afa ka nengelim sihinig nengel kana kigmog ati nangug afa mas ne kam olug oniginig mo. ");
INSERT INTO amn_n_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Afa mungwali el kana Awag kam faig afa enag el ka nangum ambugugofe. Afa aman enaig esef eso kam olug onigini ka ehengelim mas waginini eba awai. ");
INSERT INTO amn_n_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Afa ka mas kikeafena oningigim pahlukui. Eba el kam heven wa nai ningihiag eso ka bogim heafna sawiegim pahlukui. ");
INSERT INTO amn_n_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Afa ehe kam ningihiagim og, ‘Ka elim neana ninga wa hwatif eso ne ehengelim nangwaghiagofim masa mungo awaief. Afa mahim kwefihiageg osuna puguiba eso ne ehengelim bitek fenai ilafaitifef.’ ");
INSERT INTO amn_n_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Afa mungwali el Godna Leg nangum ambugof afa ehem olug onigini eso kana Awag membeg enag el higeg nofkenagag fig. Afa kwefihiageg osuna eso ka ehengelim ilafaitifenam nofkenagag faif.” ");
INSERT INTO amn_n_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Afa Sisas esona og, “Kaba heven wa nai aba.” Eso Ju el enag mo higinim afa hefum memtog mona sihiagini. ");
INSERT INTO amn_n_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Afa ehengel enaig esogog, “Ati big anwanafig eba Sisas Josepna leg ehe el feg. Big anwanafig heafna awag mi afag miba. Ahnaig esegba ehe enaig esog ‘Ka heven wa nai pe bog?’ Enag mo mas lahlafeg mo.” ");
INSERT INTO amn_n_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Afa Sisas sihina og, “Afwai, nofeka nimbefum memtog mona sihiagahufum. ");
INSERT INTO amn_n_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Sa higi, afa el ehe mas kam pahlu boi eba kana Awag ehem awamonam eso ka nangum wani buf. Afa ka kwefihiageg osuna ehem ilafuf. ");
INSERT INTO amn_n_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Afa aman el kana Awagna mo higinim afa heafna mo kikehlig eso enag el ka nangum ambugof. Eba enaig Godna mo fi sihiaule el eso ginofini og, ‘God ehe mungwali elni tisafef.’ ");
INSERT INTO amn_n_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nofeka nengel onigifi kana mo enaig esog el kana Awagim nangug. Mungo el ehe kana Awagim ati nangug eba enag el God i ahagafena eso ehem ningihiag. ");
INSERT INTO amn_n_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ka nem inim sihinig aman el kam olug oningig eso enag el higeg nofkenagag fag. ");
INSERT INTO amn_n_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Kaba enag aba eso elim inim nofkenagag faig. ");
INSERT INTO amn_n_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nengelni simbianinga bite bihig wa mana ahganam eso mas nofkenagag fini mo afa muhuna feskofenam eso pigina. ");
INSERT INTO amn_n_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Enag aba mang mana lofug mo. Eba heven wa nai aba afa el enag ahgaiba eso ehengelim mas pigi. ");
INSERT INTO amn_n_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Eba kike enag heven wa nai aba. Afa el enag aba neba eso ehenai yi higeg nofkenagag gofif. Enag aba eba kana elig. Afa ka kiafna elig bite nai elim faig eso bite nai el soma nofkenagag fi.” ");
INSERT INTO amn_n_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Afa Ju el hefum mo soagini afa enaig esogona og, “Ahnaig esegba sonag el heafna elig bigim faif eso big enag ahgaf?” ");
INSERT INTO amn_n_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Afa Sisas ehengelim sihini og, “Eba inim feg afa ne Inim Elni elig i afa heafna taf i fi hwanigba afa nofkenagag mas nengelni go mo. ");
INSERT INTO amn_n_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Afa ne aman kana elig i afa taf i neba eso higeg nofkenagag ehenai yi gofif. Afa kwefihiageg osuna eso ka ehengelim ilafo tiginam nofkenagag faif. ");
INSERT INTO amn_n_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Afa kana elig eba inim fane afa kana taf eba inim bu. ");
INSERT INTO amn_n_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Afa ne aman kana elig i afa taf i neba eba ehe ka i ahfeg afa ka ehe i ahgofuf. ");
INSERT INTO amn_n_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Kana Awag nofkenaga afa ehe kam ningihiag eso heafna kifutig kam nofkenagag fai. Eso aman kam ne ba eso kana kifutig ehem nofkenagag faif. ");
INSERT INTO amn_n_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Afa enag aba of wa nai bog eba mang mungo lofug aba mo eso nengelni simbianinga ahgana afa sum yi pigina. Afa aman ne enag aba neba eba ehe higeg nofkenagag fafe.” ");
INSERT INTO amn_n_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Sisas ohuna mo sihini nuwagig lala Kaperneam wa. ");
INSERT INTO amn_n_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Afa el numb Sisasim pahlukuiaule ohuna mo higinim afa esogona og, “Enag mo bigel mas numwehe anwanafi. Aman so enag moba kikehlaf?” ");
INSERT INTO amn_n_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Sisas ehe ati anwanafena mingnag el ehem eso pahlukuna hefum memtog mona sihiagini eso ehengelim enaig esoni og, “Ateaho ohuna mo nengelim kinig faig? ");
INSERT INTO amn_n_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Mang kinig so na fif afa ne nanguibi Inim El of gam piske kwakofiba eso ehe enanai bona. ");
INSERT INTO amn_n_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Godna Sungwag inim nofkenagag elim faig. Afa elni elig mas elim kweagfui. Afa mo ka nem sihinag enag mo soma nengelni sungwagum kweagfui afa inim nofkenagag nem faif. ");
INSERT INTO amn_n_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Afa nengel mingnag kana mom mas onigini.” (Afa yuwanam Sisas ati anwanafeg aman mas ehem oniginig mo afa aman el eso ehem angoluwagna ninga wa wahiaf.) ");
INSERT INTO amn_n_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Afa Sisas piske sihini og, “El mas kam onigig mo enagba mog feg autunam ka nem sihina kana awag elim kifutig faig hwainig ba afa enag el ka nangum mas boi.” ");
INSERT INTO amn_n_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Afa el numb Sisasim pahlukuna afa enag mo higinim eso Sisasim wahinim mas piske pahlukuna mo. ");
INSERT INTO amn_n_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Afa Sisas heafna 12 pela pahlukuiag elim sahna og, “Nengel gaba ne kam hwai yi me?” ");
INSERT INTO amn_n_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Afa Saimon Pita enaig sihifena og, “Ainiyag aman nangum ka so ahunam eso pahluguf. Nana mo mungo bigelim higeg nofkenagag faig. ");
INSERT INTO amn_n_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Afa kagel olug onigig afa anwanafig neba afsug kabag el God nem ningihiag.” ");
INSERT INTO amn_n_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Afa Sisas sihina og, “Ka kike nengelim 12 pela elim kanognig afa el mungo nengel nai yi eso go eba Satanna gafuga esef.” ");
INSERT INTO amn_n_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Enag mo eba Judasim sihinag. Ehe Saimon Iskariotna leg. Afa eheba Sisasna pahlukuiag el fena eso Sisasim angoluwag elni ninga wa wahiaf. ");
INSERT INTO amn_n_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Afa Sisas esenam eso Galili gam wagiakafena. Afa Ju elni misog el ogna Sisasim tigi eso ehe Judia gam ikagim kusina. ");
INSERT INTO amn_n_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Afa Ju elni ugufige lala buyis muhwa ofefenaba, ");
INSERT INTO amn_n_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","eso Sisasna nilite ehem sihina og, “So na ohuna kimbig wahianam Judia gam ikai eso neana pahlukuiag el so ma neana kigmogim nangui. ");
INSERT INTO amn_n_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Afa el hefum ambagwa wagfuba enag el mas heafna gafugag meagam kumohlai. So na enag eseba so ma mungwali el nem anwanafeni.” ");
INSERT INTO amn_n_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Afa heafna nilite enaig esoni eso ehengel gaba mas Sisasim olug onigini mo. ");
INSERT INTO amn_n_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Afa Sisas ehengelim sihina og, “Kana was meini fe afa nengel nimbiafgelni membug wa so ahuiago. ");
INSERT INTO amn_n_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Afa bite nai el nengelim mas wagini goni, afa kaba ehengelni amtakwaligim sihiageba eso kam olug kakagfini fi. ");
INSERT INTO amn_n_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kaba mas yawaba ikai kana was meini fe afa nengel buyis gim so ahuiago.” ");
INSERT INTO amn_n_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Afa Sisas enaig sihifenam afa hefum mo Galili wa gafna. ");
INSERT INTO amn_n_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Afa Sisasna nilite gof ahunaba afa ehe gaba sum fakaf. Afa ehe mas ambagwa puguna mo afa ehe elni megam sahu fiakafena. ");
INSERT INTO amn_n_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Afa Ju elni misog el buyis wa ehem yisgiafofena og ka ehem nangu eso sahini og, “Sonag el ahanag yi mahim?” ");
INSERT INTO amn_n_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Afa mungwali el hefum mohe mona Sisasna mom sihiagini. Mingnag el esogona, “Eheba lahlag el.” Mingnag el esogona, “Amo, ehe mungwali elim mwakwalenigule.” ");
INSERT INTO amn_n_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Afa mungwali el Ju elni misog elim embefini eso sagmonam hefum mohe mona enaig sihififni. ");
INSERT INTO amn_n_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Afa buyis ati olyi ofefnaba eso Sisas Godna nalig lala ikanam elim mo sihinug fafefe. ");
INSERT INTO amn_n_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Afa Ju elni misog el Sisasna mo higinim sineminefinim afa hefum esogona og, “Ahana nai sonag elbi nalig onigiba fana ehe mas skul yi ikana mo?” ");
INSERT INTO amn_n_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Afa Sisas sihina og, “Enag mo ka nem sihinig mang kiafena mo mo, eba awai. El kam ningihiag eba ehena mo ka nem sihinig. ");
INSERT INTO amn_n_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Afa aman membeg Godna sawiegim pahlukuia gofiba afa enag el eba anwanafef mo so ka sihig Godna me awai kiafna me. ");
INSERT INTO amn_n_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Afa aman el heafna onigig wa sihiageg ogna hefum gufiyifukog. Afa el ming elni unehlagim gufiyifukogba eso ehem ningihiag afa heafna moba eba inim afa enag el mas mwakwale. ");
INSERT INTO amn_n_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Afa nengel ati anwanafini Moses Godna nihe mo nem faini afa nengel mas enag nihem pahlukuna mo. Mangigim ne kam ogna tigi?” ");
INSERT INTO amn_n_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Afa el esogona og, “Nimbasa amtakwalig ne nai yi go eso ne onigig etetig el lofeg eso ne enaig sihifeg. Aman el ogna nem tigi?” ");
INSERT INTO amn_n_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Afa Sisas sihina og, “Ka mungo kigmog Auguiag Osuna eseba afa ne kukufakif. ");
INSERT INTO amn_n_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Afa nengel enaig esig Auguiag Osuna ne fangonai luwalna elig lofug kofug eso ne Mosesna nihe mo pahluhug. (Afa Moses mas gof enaig esena mo afa nengelni simbianinga autunam enaig esini.) ");
INSERT INTO amn_n_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Afa Auguiag Osuna ne enaig esigbi luwalna lofug wesig kofatig ne og kagel mas Mosesna nihe mo filafati mo. Ahanaig eseg ba ne kam waginig mahim gih elim ati ka lahlafatig Auguiag Osuna. ");
INSERT INTO amn_n_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nofeka nofugna bihig kwefihiage afa ne inim mogim nangonam so na kwefihiage.” ");
INSERT INTO amn_n_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Afa mingnag Jerusalem wa nai el hefum enaig esogona og, “Ateaho enag el mahim eso misog el ogna tigi? ");
INSERT INTO amn_n_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Sa nangu, Sisas ambagwa moaba sihiago fenaba afa mas aman ehem ahanaig esoni mo. Ateaho misog el onigig ehe Godna Gishu Wahiag el me? ");
INSERT INTO amn_n_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Afa mahim Godna Gishu Wahiag el boi ba bigel mas heafna kimbig anwanafi afa bigel ati anwanafig Sisas ahnanai mahim bog.” ");
INSERT INTO amn_n_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Afa Sisas Godna nalig lala gafenaba afa hugna sihinugena og, “Ei, ne kam anwanafinif eba kana kimbig gaba ne ati anwanafig. Afa ka mang kikeafna kifutigni bo mo, awai. Afa el inim onigigna feg eso ehe kam ningihiag. Afa ne mas ehem anwanafinig mo. ");
INSERT INTO amn_n_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Afa ka ehem ati anwanafenag afa ka ehe i ahagigim enag kam ningihiag eso ka bog.” ");
INSERT INTO amn_n_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Afa Sisas enaig esonaba eso el ogna ehem ningana kikehli afa ehem tigig was meini fiahfenaba eso mas aman enaig esena mo. ");
INSERT INTO amn_n_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Afa el numb Sisasim olug onigig finim enaig esogona og, “Afa ohuna el eso enaksag kigmog wagfug eba Godna Gishu Wahiag el gwenaig esef.” ");
INSERT INTO amn_n_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Afa farisi el enag sagmona mo higinim eso ehengel i afa misog pris i anwasag elim ningitigini ahu Sisasim kikehli. ");
INSERT INTO amn_n_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Afa Sisas sihina og, “Ka nengelim mwakwalig wanganam afa ka elim nangwagim ikaf eso kam ningihiag. ");
INSERT INTO amn_n_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Afa ne kam yisigif afa mas ne kam nangui eso kimbig ka ga ne mas boi.” ");
INSERT INTO amn_n_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Afa Ju elni misog el hefum sihiagini og, “Ehe asim ikaf eso ehem mas big nangui? Ateaho enaig ese me? Afa ehe afwambanai elni kimbig gam ikanam eso ehengelim mo sihinugef afa enanai yi Ju el auguia. ");
INSERT INTO amn_n_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ehe enaig esog ‘Ne kam yisigif afa mas ne kam nangui’ afa ming mo esoni ‘Kimbig eso ka ga ne mas boi.’ Afa enag mo ka mas anwanafig mo ehe mangim esog?” ");
INSERT INTO amn_n_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Afa buyis osu buswagin meini ofefenaba eba nalig osuna fena. Afa enag osuna Sisas bihianam hugna esona og, “Aman el ne bu hef fegba so na ka nangum bonam bu ne. ");
INSERT INTO amn_n_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Afa Godna mo enaig esog afa aman kam olug oniginaf afa nofkenagag bu ehe nai yi lugofuf enaig hun bu lofug.” ");
INSERT INTO amn_n_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Afa ohuna mo enaig esog Godna Sungwag enaig esef aman eso Sisasim olug onigina eso ikanam ehe ahagafuf. Afa enanam Sisas mas piske heven gam kukana mo afa nalig unehlag fagim eso enanam God heafna Sungwag elim mas faini mo. ");
INSERT INTO amn_n_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Afa mingnag el ohuna mo higinim esogona og, “Sonag el eba inim Godna mo fi sihiaule el!” ");
INSERT INTO amn_n_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Afa mingnag el sihini og, “Eheba Godna Gishu Wahiag el!” Afa mingnag el enaig esog, “Amo, Godna Gishu Wahiag el mas Galili nai boi. ");
INSERT INTO amn_n_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Afa Godna mo enaig esog Godna Gishu Wahiag el eba Devitna simbianinga afa ehe Betlehem wa afag wanigaf Devitna kimbig wa.” ");
INSERT INTO amn_n_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Eso el Sisasim sambaga onigig finim eso hefum mungo mungo kukohiaginim eso ahuiaminefena. ");
INSERT INTO amn_n_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Afa mingnag el ogna Sisasim kalabusimini afa mas aman el ehem kehlini mo. ");
INSERT INTO amn_n_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Afa anwasag el gwenag piske ambugona. Afa misog pris i afa farisi el i ehengelim sahtigini og, “Ahnaig esegba ne ehem mas wanig ambugog mo?” ");
INSERT INTO amn_n_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Afa anwasag el wahigi sihini og, “Afa heafna mo enmunam feg mas bigel i aman enaig feg mo.” ");
INSERT INTO amn_n_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Afa farisi el ehengelim wagigoni og, “Ateaho ehe nengelim gaba mwakwal fafenif eso ne ehem pahluhug? ");
INSERT INTO amn_n_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Afa ne ati anwanafini kagel farisi el afa misog el heafna mom mas higinig mo. Kagel Mosesna nihe mo pahluhug. ");
INSERT INTO amn_n_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Afa enag el numb Mosesna nihe mo mas anwanafini mo eso ehe mungwali elim mwakwalini. Eba God ehengelim amtakwale aitif.” ");
INSERT INTO amn_n_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Afa mungo farisi el Nikodimus ehe autunam Sisasim ati nanguna eso mingnagim esoni og, ");
INSERT INTO amn_n_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Bigel nofeka ehem mungwinim sehini afa bigelni nihe mo enaig eseg yawo bigel so elni mom higinim eso anwanafi ehe ati mang eseg me.” ");
INSERT INTO amn_n_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Afa ehengel Nikodimusim waginini og, “Ateaho ne gaba Galili nai el? So na piske ikanam Godna mo ugwe fahigiafa eso ne anwanafe Godna mo fi sihiaule el mas Galili nai boi.” ");
INSERT INTO amn_n_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Afa ehengel enaig esinim afa lala gam ahuaminefena. ");
INSERT INTO amn_n_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Afa Sisas Oliv mug gam kukana. ");
INSERT INTO amn_n_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Afa leana gubi Godna nalig lala gam ehe piske ikana. Afa el numb ehem muhwa nuwagigena eso ehe peganam mo sihinugiaufna. ");
INSERT INTO amn_n_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Afa nihe mo anwana el i afa farisi el i angwafig aga fatiaulem wani ambugonam eso ehem enaig esini mungwali elni nof wa bu gona washunim. ");
INSERT INTO amn_n_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Afa ehengel Sisasim sihini og, “Ohuna angwafig kagel ati kike nangug ehe ming kwablogim pahlukug. ");
INSERT INTO amn_n_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Afa Mosesna nihe mo bigim kifutig mo faig. Sa big enaig angwafigim hunna tuagu so ma wahai. Afa ne ahanaig esof? Eso bigel mang fif?” ");
INSERT INTO amn_n_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Afa ehengel Sisasim ogna gihni eso enaig mo ehem sihinim eso ehem kufini. Afa Sisas peskafenam ningana bite wa ginofena. ");
INSERT INTO amn_n_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Mahim ehengel ehem sahnahufnaba ehe bihianam ehengelim sihini og, “Aman nengeli nai mas mang amtakwalig eseg mo eso enag el so ma hunna gof tigifati.” ");
INSERT INTO amn_n_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Afa Sisas piske peskafenam ningana bite wa ginofena. ");
INSERT INTO amn_n_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Mahim ehengel ohuna mo higinim eso mungo mungo Sisasim wahinim ahuaminefena. amunaiyig enag mo gof ahuna afa luwal kwablog sum fahufena. Afa mahim ehengel mo enaig esinibi afa enag angwafig Sisas i ahgofena. ");
INSERT INTO amn_n_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Afa ehe bihianam angwafigim sahna og, “Ei, ahnanai yi elbi agfohie? Ateaho mungo elbi go eso nem kufenaf?” ");
INSERT INTO amn_n_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Afa ehe wahigi sihina og, “Amunai, mungwali el awai.” Afa Sisas esona og, “Ka gaba nem mas kufenai. Eseka, nofeka amtakwaligim piske enaig ese.” ");
INSERT INTO amn_n_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Afa Sisas mungwali elim piske sihina og, “Ka kike enag afwambusug ohuna bite wa feg. Aman el kam pahlu obofiba enag afwambusug nanguiba eso enag ehem nofkenagag faif afa ehe mas sikifig wa wagegofi.” ");
INSERT INTO amn_n_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Afa farisi el ehem sihini og, “Ne nimbefum sihiageg afa nimbiafena onigig wa mungo so na sihig. Nana mo mungo mas kagelim wagfunig mo eba inim me awai awai me?” ");
INSERT INTO amn_n_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Afa Sisas sihina og, “Ka anwanafeg kike ahnanai bog afa asim ka ikaf eso ka kikefum sihiageba enag mo eba inim nemug. Afa nengel enam mas anwanafig mo. ");
INSERT INTO amn_n_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Afa nengel nimbeafgelni onigig wa elim kwefihiagig. Afa ka mas elim kwefihiagei. ");
INSERT INTO amn_n_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Afa ka elim enaigba esofenifiba afa kana kwefihiageg eba inim feg eso mang kable mungo eseg mo. Afa awag kam ningihiag eso ehe ka i ahagag. ");
INSERT INTO amn_n_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Afa nengelni nihe mo enaig esog afa mahim sambaganigi el mungo mo ahsihiba eba inim. ");
INSERT INTO amn_n_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Afa ka kikefum sihiageg afa awag kam ningihiag ehe gaba kana mom ati sihig.” ");
INSERT INTO amn_n_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Afa ehengel Sisasim sahini og, “Nana awag ahnanai yi mahim?” Afa Sisas wahigi sihina og, “Ne kam mas anwanafinig mo, eba kana awagim gaba ne mas anwanafig mo. Afa ne kam ati anwanafinibi eba kana awagim gaba ne anwanafinig.” ");
INSERT INTO amn_n_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Afa Sisas enaig esona Godna nalig lala meg wa afa enag lala meg eso kig wambugum Godum fakig wahig. Afa el mas ehem kikehlinim tigini mo eso enag osuna ehem enaig esigim mahim fiahfena. ");
INSERT INTO amn_n_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Afa Sisas ehengelim piske sihina og, “Ka ikaf afa ne kam yisiginim mas ne kam nangui. Afa ne ahanaig ahanaig fiahkan eso mahim ne wahaiba nengelni amtakwalig nengelni gofuf. Afa ka ikaf eso ne enanai yi mas ne boi.” ");
INSERT INTO amn_n_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Afa Ju elni misog el hefum sihiagini og, “Ahnaig esegba ehe enaig sihifeg ka ikaf eso ne enanai yi mas ne boi? Ateaho ehe hefum tige fati me?” ");
INSERT INTO amn_n_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Afa Sisas sihina og, “Ka sisyi nai el afa nengel skaugu nai el feg. Nengelni niheba bite nai feg afa kana nihe mang bite nai mo. ");
INSERT INTO amn_n_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Eso ka nem enaig sihifenig afa mahim ne wahaiba nengelni amtakwalig nengelni gofuf. Ka nem ati sihinig kaba aman mahim afa ne enam olug onigig hwanigba eba enag nengelim inim esenif.” ");
INSERT INTO amn_n_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Afa ehengel sahini og, “Kagelim sihini ne aman mahim?” Afa ehe sihini og, “Enag mo ka nem gof sihini eba gwenaig mo ka nem sihinif. ");
INSERT INTO amn_n_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ka mo numb feg eso nengelim kufunigim. Afa el kam ningihiag eheba inim feg. Mang mo ehe sihig eso ka higigim enag mo mungo ka ohuna bite nai elim sihinigofuf.” ");
INSERT INTO amn_n_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Afa ehe awagna mo sihinugena afa ehengel enag mo mas anwanafini mo. ");
INSERT INTO amn_n_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Eso Sisas enaig sihifeni og, “Mahim nengel Inim elim li katigeg wa fingi fi kahlibi afa enanam ne anwanafif ka kike aman mahim eso ka nem ati sihinig. Afa enanam ne anwanafini ka mas kikeafna onigig pahlukui. Awag kam eso sihinag enag mo mungo eso ka sihig. ");
INSERT INTO amn_n_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Afa ehe kam ningihiag eso ehe ka i ahagag. Mang so ka anwanafeg eso ehem sifakal faig enag mungo ka enaig eseg eso ehe kam mas hwai ikai.” ");
INSERT INTO amn_n_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Afa el numb enag mo higinim eso Sisasim olug onigini. ");
INSERT INTO amn_n_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Afa Ju el Sisasim olug onigig fini eso Sisas ehengelim enaig sihifeni og, “Nengel kana mo higinim pahlukuiba eso nengel kana pahlukuiag el inim fig. ");
INSERT INTO amn_n_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Afa enaig esigbi ne inim mo anwanafif afa mang nengelim kikeg eso enag inim mo nengelim isug pigi hwatifi.” ");
INSERT INTO amn_n_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Afa ehengel sihini og, “Bigel Abrahamna simbianga afa mingnag el bigim mas kikegoni. Ahnaig esegba ne esog nengelim isug pigi hwatifi?” ");
INSERT INTO amn_n_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Afa Sisas sihini og, “Eba inim feg aman el amtakwalig nihe eseg eso amtakwalig nihe ehem kikenagim afa enam ahnai skaug fenag. ");
INSERT INTO amn_n_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Afa isug gafugag el misog elim ahnai skaug fenag afa ehe mas misog elim higeg wanga fi. Afa luwalig humuanigim higeg wanga. ");
INSERT INTO amn_n_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Eso Godna leg nengelim isug pigi fwatifeba eso nengelim inim nemug hwatif. ");
INSERT INTO amn_n_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ka anwanafeg nengel Abrahamna simbianga afa nengel kana mo mas fig mo eso nengel ogna kam tigi. ");
INSERT INTO amn_n_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Afa kana Awag kam mang wagfunag eso enag ka nem sihinig. Afa mang nengelni awag nem wagfunig eso nengel enaig esig.” ");
INSERT INTO amn_n_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Afa ehengel enaig esogona og, “Kagelni simp eba Abraham.” Afa Sisas esona og, “Nengel Abrahamna simbianga inim fegba eso nengel gaba heafna nihem gwenaig esi. ");
INSERT INTO amn_n_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Afa God kam sihinag eso ka higigim enag inim mo ka nengelim sihinugegofif afa nengel ogna kam tigi. Abraham mas enaig esena mo. ");
INSERT INTO amn_n_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Afa nengel gwenaig esig eso nengelni awag esena.” Afa ehengel enaig esogona og, “Kagel mang mina luwal mo. God ehe kagelni Awag.” ");
INSERT INTO amn_n_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Afa Sisas ehengelim sihini og, “Afa God nengelni awag inim fef nengel kam membenif eso ka ehem wahiagim enag ka bog. Ka mas kikeafna onigig wa boi ehe kam ningihiag. ");
INSERT INTO amn_n_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Ahnaig esegba nengel kana mo mas anwanafinig mo? Eba enaig nengel kana mo figim mas membig mo. ");
INSERT INTO amn_n_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Satan eba nengelni awag eso ne membig heafna gafugam esig. Afa autunam nemug ehe elim tigeule afa mungwali inim mo ehe mas fatig afa inim mo ehenai yi mas go mo. Afa Satan mwakwal el eso mwakwal elni awag feg. Afa mahim ehe mwakwal mo sihigba ehe sifakaleg eso enag nihe ehem mog feg. ");
INSERT INTO amn_n_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Afa nengel kana mom mas onigig mo eso kana mo eba inim feg. ");
INSERT INTO amn_n_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Afa mas aman el kana amtakwaligim ambagwa pugu sihi. Afa ka nem inim sihinig asegba kana mo nengel mas onigig mo? ");
INSERT INTO amn_n_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Afa aman Godna el fef enag el Godna mo higif. Afa nengel mas Godna el fig mo eso enag mo nengel mas membig mo.” ");
INSERT INTO amn_n_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Afa ehengel Sisasim sihini og, “Kagelni moba inim feg eso kagel enaig esogog neba amtakwalig Samaria nai el afa nimbasa amtakwalig nanai yi go.” ");
INSERT INTO amn_n_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Afa Sisas wahigi sihini og, “Ka nimbasa awai. Ka kikeafna awagim fingi feg afa nengel kam pigapego. ");
INSERT INTO amn_n_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ka mas kiafna unehlagim fingi fei. Afa God kana unehlagim fingi fena afa ehe mungwali elim kwefihiageg. ");
INSERT INTO amn_n_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Eba inim feg aman so kana mo kehlag enag el mas wahai.” ");
INSERT INTO amn_n_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Afa Ju elni misog el enaig esogona og, “Yawo kagel ati anwanafig nimbasa nanai yi go! Autunam Abraham wahana afa Godna mo fi sihiaule el gwenaig esini afa ne enaig sihifeg el kana mo kikehlif ehe mas wahai. ");
INSERT INTO amn_n_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Bigelni simp Abraham ati wahana asegba ne onigig ne ehem filafeg? Godna mo fi sihiaule el gaba pigina. Ne onigig ne ahanaig el mahim eso ne enaig sihiageg?” ");
INSERT INTO amn_n_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Afa Sisas sihini og, “Ka kiafna unehlagim fingi fegba afa enag gafugag mas fug luwoi. Afa enag el nengel enaig esogog ehe kagelni God eheba kana awag eso kana unehlagim fingi fena. ");
INSERT INTO amn_n_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Afa nengel mas ehem anwanafinig mo afa ka ehem anwanafenag. Afa ka enaig sihifegba eba ka mas ehem anwanafenag mo afa enag mo ka mwakwaleg eso ka nengel lofeg mwakwalule. Afa ka ehem ati anwanafenag afa ka ehena mo pahlukahuf. ");
INSERT INTO amn_n_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Autunam nengelni simbianga Abraham kam anwanafena og ka bof eso ehe sifakalena. Afa enag ehe nangunam eso hugna sifakalena.” ");
INSERT INTO amn_n_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Afa ehengel Sisasim sihini og, “Abraham autunai fena afa ne mang muhuna mo. Ateaho ne ehem nanguna?” ");
INSERT INTO amn_n_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Afa Sisas sihina og, “Eba inim feg afa Abraham mahim fiahfenaba ka ati gohna.” ");
INSERT INTO amn_n_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Afa ehengel ehena mo higinim eso hun finim ogna ehem wahigi. Afa Sisas meagam gofenam eso Godna nalig lala wahiana. ");
INSERT INTO amn_n_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Afa Sisas ikanam nof slenam elim nanguna. Enag el afag nof etetni gwenaig wanigana. ");
INSERT INTO amn_n_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Afa pahlukuiag el sahini og, “Tisa, aman mahim amtakwalig eseg eso ohuna el nof etetni gohug? Eba ehe me awai awag afag esini me?” ");
INSERT INTO amn_n_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Afa Sisas wahigi sihina og, “Amo, eba mang enaig mo. Eba ohunaig soma Godna kifutig enag el nai yi mingnag elim wagfuniba soma nangui. ");
INSERT INTO amn_n_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","yawoba lahlag osuna eso big Godna gafugam esi eso ehe kam ningihiag. Afa sikifig bof eso el mas gafugafi. ");
INSERT INTO amn_n_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Afa mahim ka ohuna bite wa gofiba kike bite nai elim afwambusug fenig.” ");
INSERT INTO amn_n_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ehe enaig esonam afa bitem mepna kusufenam mahim euwiauwinaba eso fanam nof etetni nof wa gabahlana. ");
INSERT INTO amn_n_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Afa enaig esenam esona og, “Bu wa sugum ika Siloam mime bu gam.” (afa enag unehlag Siloam eba ningihiag) Eso enag el ikanam bu wa sunam nofug baihina afa ehe piske kimbig gam bona. ");
INSERT INTO amn_n_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Kimbig wa nai el afa mingnag el gaba ehem ati nanguni ehe eso gaba elim kigim fasahniofe. Afa ehengel enaig esogona, “Autunam nof etetni el kigim fasahniofe ateaho enag el mahim?” ");
INSERT INTO amn_n_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Mingnag el enaig esogona, “Ei ena ho.” Afa mingnag enaig esogona, “Amo, ehe ming el afa nofbosug eba mungwalofug.” Afa enag el ehe gofenaba enaig esona og, “Eba kike!” ");
INSERT INTO amn_n_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Afa ehengel ehem sahni og, “Ahnaig ne esegba eso neana nofug baihig?” ");
INSERT INTO amn_n_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Afa ehe enaig sihifena og, “Afa el eso sefig Sisas ehe bite euwiauwigim eso kana nof wa labahlagim kam sihinag ika bu wa su. Afa ka bu wa sugum eso gwenana kana nofug baihig afa ka nufmbusiageg.” ");
INSERT INTO amn_n_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Afa ehengel sahni og, “Enag el ahnanai yi mahim?” Ehe esona, “Ka mas anwanafeg mo.” ");
INSERT INTO amn_n_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Afa kimbig wa nai el enam nangunim eso enag el nofug baihina eso ehem farisi el nangum wani ahuna. ");
INSERT INTO amn_n_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Afa Ju elni Auguiag Osuna Sisas euwiaug bite fanam afa nof tet elim ugwe fatina. ");
INSERT INTO amn_n_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Afa farisi el gaba ehem sahni og asegba neana nofug baihig? Afa ehe ehengelim sihini og, “Ehe euwiaug bitena kana nofugum labahlagim kam esonag so bu wa su eso ka nufmbusiageg.” ");
INSERT INTO amn_n_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Afa mingnag farisi el esogona og, “Enag el enaig eseg ehe mang Godna el mo eso ehe bigelni Auguiag Osuna nihe mas pahlukug mo. Afa mingnag sihini og, “Afa amtakwalig el mas enaig kigmog esei. Eso hefum mungo mungo ahuaminefena. ");
INSERT INTO amn_n_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Afa farisi el elim piske sahni og, “Nana nofugum eso lahlafefatig afa neba onigig enag el aman mahim?” Afa ehe wahigi sihina og, “Ehe eba Godna mo fa sihiaule el.” ");
INSERT INTO amn_n_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Eba inim autunam enag el nof etetni fena afa enag Ju elni misog el ena mo higigim kusini. Eso enag elni awagafag awamogonibi so ahbon. ");
INSERT INTO amn_n_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Afa ehengel sambaganingim sahtigini og, “Ateaho ohuna neningina leg? Eba inim mahim ehe nof etetni gohna? Ahnaig esegba yawoba ehe nufmbusiageg?” ");
INSERT INTO amn_n_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Afa humonig esogona og, “Ei, kaningi ati anwanahfeg eba kaningina leg afa ehe nof etetni gohna. ");
INSERT INTO amn_n_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Afa kaningi mas anwanahfeg mo aman ehem lahlafatig afa mang ehem esenagba eso ehe nufmbusiageg. Ehe mang luwal mo, hefum sahnibi soma nengelim sihinuge.” ");
INSERT INTO amn_n_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Afa Ju elni misog el enaig sihifig afa aman enaig sihifef og Sisas eba Godna Gishu Wahiag el afa enag elim eba nuwagig lala kwegonuf eso afwambanai el agfohiaf. Afa awag i afag i enag mom embe ahfenam eso enaig sihi ahfena og kaningi mas anwanahfeg mo. ");
INSERT INTO amn_n_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Eso eheningi ming mo esona og, “Ehe mang luwal mo, hefum sahni.” ");
INSERT INTO amn_n_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Afa el nofug eso yuhwafena farisi el enag elim piske awamonim ehem enaig sihififni og, “Godna nof wa so na kagelim inim sihini eso kagel anwanafi enag el eba amtakwalig el.” ");
INSERT INTO amn_n_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Afa ehe esoni og, “Enag el amtakwalig el me awai awai me afa enag ka mas anwanafeg mo. Autunam ka nof etetni fena afa yawo ka nufmbusiageg enaig mungo ka anwanafeg.” ");
INSERT INTO amn_n_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Afa ehengel ehem sahni og, “Ahnaig ehe nem esenag? Nana nofug ahanaig bahiyifeg?” ");
INSERT INTO amn_n_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Afa ehe sihina og, “Kati nengelim sihinig afa ne mas higig mo. Ahnaig esegba nengel membig enag mo piske higigim? Ateaho nengel gaba ogka heafna pahlukuiag el opuko?” ");
INSERT INTO amn_n_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Afa ehengel ehem kwasonagini afa sihini og, “Ne enag amtakwalig el pahlukug afa kagelbi Mosesna pahlukuiag el fig. ");
INSERT INTO amn_n_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kagel anwanafig God ehe Mosesim ati sihina afa kagel mas anwanafig mo enag el ahnanai mahim bog?” ");
INSERT INTO amn_n_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Afa ehe sihina og, “Enag enmunam feg nengel inim anwana el enam ne mas anwanafig mo. Ehe kana nofugum lahla fenag eso nengel mas anwanafig mo ehe ahnanai mahim bog.” ");
INSERT INTO amn_n_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Bigel anwanafig God amtakwalig elni mo mas higinai. Afa el Godum ahnai skaufenag afa heafna mo pahlukug eso God enag elni mo eba higinag. ");
INSERT INTO amn_n_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Afa yawo el mungo mingnag elni nofug lahla fetifena afa autunam nemug enaig mo el mas higini mo. ");
INSERT INTO amn_n_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Afa enag el Godna el feg hwanigba eso ehe mas ahanaig ese eso heafna kifutig eba awai.” ");
INSERT INTO amn_n_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Afa ehengel olug kakaginim esogona og, “Mahim ne gohnaba ne amtakwalig el fena eso yawa gaba ne gwenaig go. Ne hugna amtakwalig el asegba ne og kagelim sihinuge.” Eso ehengel ehem fena minefinim eso ningihinim afa ehem nuwagig lalam kweni. ");
INSERT INTO amn_n_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Afa Sisas higina mahim enag elim enaig esofini finibi eso bonam ehem nangunam esona og, “Ateaho ne Inim Elim olug oniginag?” ");
INSERT INTO amn_n_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Afa ehe esona og, “Kam sihina ehe aman mahim eso ka ehem olug onigina.” ");
INSERT INTO amn_n_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Afa Sisas ehem sihina og, “Ne ehem ati nangug eba ehe yawo ne nai yi eso ahwago.” ");
INSERT INTO amn_n_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Afa enag el mongkokini kwakwagenam enaig esona og, “Ainiyag, ka nem olug onigina.” ");
INSERT INTO amn_n_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Afa Sisas sihina og, “Ka ohuna bite wa bog eso el kwefihiagenam. Afa nof tet el nuhmbusiagef afa el nof lahlagna eba nof tet el lofef.” ");
INSERT INTO amn_n_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Afa mingnag farisi el ehe yi mungwal hafufenaba ena mo higinim sahni og, “Ateaho kagel gaba nof etetni el?” ");
INSERT INTO amn_n_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Afa Sisas sihina og, “Afa ne enaig sihifeba kagel nof etetni el eso nengelnai yi amtakwalig mas go mo. Afa ne enaig esog, kagel mang nof etetni mo eso nengelni amtakwalig nengelnai yi nago.” ");
INSERT INTO amn_n_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Afa Sisas sipsipni waskwes mo sihina og, “Eba inim feg, afa sipsip bog megam sahu agfohie afa amtakwalig el mas mengigna sahu boi. Enaig el eba okwef el ehe eso bogim tufug seahug eso okwefig. ");
INSERT INTO amn_n_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Afa kike enaig sipsipni lahlag nangwaghiawageg el afa ka enaig esfaf mungosni mengig gam eso sahu bog. ");
INSERT INTO amn_n_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Afa el eso mengig wa anwasa fego afa kam mengig piginag eso ka sipsipni unehlagim suwigigba afa kana sipsip kana mengigim ati higig eso afwambagam wankag. ");
INSERT INTO amn_n_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Afwambagam wanpugugum afa kana sipsip unem ati anwanafig afa mahim ka goseg ikaba eso sipsip kam sum pahlukuiag fug. ");
INSERT INTO amn_n_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Afa enag sipsip ming elni unem higigim afa mas ehem pahlukui. Eba ehena mengigim mas anwanafinig mo eso ehem washu ahuaminafeg.” ");
INSERT INTO amn_n_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Afa Sisas enag waskwes mo sihini eso farisi el mas anwanafig mo. ");
INSERT INTO amn_n_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Eso Sisas piske sihini og, “Eba inim feg kike eba sipsipni bog mengig lofeg. ");
INSERT INTO amn_n_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Afa mungwali el eso yuwanam ambugog enag el eba okwef el eso sipsip ehena mo mas higini. ");
INSERT INTO amn_n_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Kike mengig feg afa aman ne ka nangum sahu boiba eba ne lahla gafef. Eso ne sahufenam afa afwambagam pugufenam eso ne lahlag bite wa wagiafufif ");
INSERT INTO amn_n_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Afa okwef elni onigig eba enaig ehe bonam eso sipsipim okwefenam afa tigenam afa mingnagim mo amtakwalig aitikaf. Afa ka bogba soma kana sipsip nofkenagag fif eso enag nofkenagag ehengelnai yi nalig feni. ");
INSERT INTO amn_n_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ka kike sipsipni lahlag anwasag el. Afa ka enaig esef kiafna eligim agfwoiyeba eso ka sipsipim kwaganif. ");
INSERT INTO amn_n_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Afa anwasag el eba sipsipni awag afa gafugag el eba isug nangwahiagego mang ehena mo. Afa mahim sangwal mawang obofiba afa ehe nangugim eso sipsipim embem wasan ikag. Eso mawang bonam sipsipim tigeiba eso embem afuiaminefef. ");
INSERT INTO amn_n_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Afa enag el eba isug gafugag el afa ehe mas sipsipim onigini eso ehe embem ikag. ");
INSERT INTO amn_n_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ka kike sipsipni lahlag anwasag el. Kikiafna sipsipim ka ati anwanafenig afa kiafna sipsip kam ati anwanafinig. ");
INSERT INTO amn_n_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Eba gwenaig eseg Awag kam anwanafenag afa ka ehem anwanafenag. Afa ka kiafna eligim agfwoiyeba eso ka sipsipim kwaganif. ");
INSERT INTO amn_n_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Afa mingnag sipsip eba kana afa ehengel mas ohuna bog megam agfohie mo. Afa ehengel gaba soma kana mo higinim afa kam pahlubugoiba afa ka wambinam mungo bog megam wasanif. Afa mungo anwasag el eso mungwali sipsipim nangwahiage wambuf gofif. ");
INSERT INTO amn_n_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Afa kana wahagna mona ka mas enam kwenai eso Awag kam hugna membenag. Afa ka kiafna nofkena agfwoiyeba eso ka piske fafe. ");
INSERT INTO amn_n_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mas aman el kana wahagna mina gishu agfwahe eba kiafna onigig wa eso ka kiafna eligim agfwahef. Afa kaba kifutigni feg kiafna eligim hwaiyanam afa ka kifutigni feg eso enag nofkenagag piske fafe. Afa kana Awag ohuna kifutig mo kam faig eso ka enaig esef.” ");
INSERT INTO amn_n_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Afa Ju el enag mo higinim eso hefum mungo mungo fiahgini. ");
INSERT INTO amn_n_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Afa el numb enaig esogona og, “Enag el eba nimbasa amtakwaligna afa ehe motet el lofeg. Ahnaig esegba ne ehena mo higini?” ");
INSERT INTO amn_n_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Afa mingnag enaig esogona og, “Amo, enaig el eba mas enaig sihif. Afa nimbasa mas noftet elim ugwe fati.” ");
INSERT INTO amn_n_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Afa ming Ju elni buyis puguna. Afa enag buyis sefig Godna nalig lala buyis. Enanam eba bu was afa ninegna. ");
INSERT INTO amn_n_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Afa Sisas Godna nalig lala gam ikanam afa wagiakafenaba enanai yi sefig Solomonna afwambag sime. ");
INSERT INTO amn_n_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Afa Ju el ehem muhwa ambugog opukonam afa esogona og, “Afa mungwanam nembefum ne sisageg kagel kusig enam nengiafogum. So na kagelim ambagwa sihini ateaho ne Godna Gishu Wahiag el me awai awai me?” ");
INSERT INTO amn_n_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Afa Sisas wahigi sihina og, “Ka nem ati sihinig afa nengel mas higig mo. Afa kana awagna kifutigni ka kigmog esena afa enag gafugag nengelim wagfunig ka aman mahim. ");
INSERT INTO amn_n_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Afa nengel enam mas olug onigini mo. Afa ena enaig esigbi eso nengel mang kana sipsip mo. ");
INSERT INTO amn_n_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Afa ka ati kiafna sipsipim anwanafenig afa ehengel kana mengigim higinim eso kam pahluhug. ");
INSERT INTO amn_n_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Afa ka ehengelim higeg nofkenagag faibi afa mas amanim awaiye. Afa mas aman el kana ninganai bo okwefei kike mungo ati feg. ");
INSERT INTO amn_n_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Afa kana awag ehengelim kana ninga wa wahiag. Afa ehe mungwali elim gosinig eso mas aman el heafna ninga nai ehengelim okwefei wambu. ");
INSERT INTO amn_n_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Afa ka i awag i kaningi mungo ahfeg.” ");
INSERT INTO amn_n_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Afa Ju el piske gwenaig esini hun fini ogna Sisasim hunna tuagu, ");
INSERT INTO amn_n_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Afa Sisas ehengelim sihini og, “Ka nengelim enaksag kigmog wagfunig eso Awag eseg. Afa mang lahlag ka esegba eso ne og kam ogna tigifati?” ");
INSERT INTO amn_n_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Afa Ju el wahigi sihini og, “Kagel mang neana gafugam enam esoni mo. Afa neana mo ne Godum moalamp onag eso kagel ogna nem tigi. Afa ne el nemug feg eso ne onigig og kaba God.” ");
INSERT INTO amn_n_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Afa Sisas esona og, “Nengelni nihe mo wa God elim enaig sihifena og, ‘Nengel god lofig.’ ");
INSERT INTO amn_n_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Afa autunam God heafna nihe mo elim faini afa ehe enag elim seafag eba god. Afa big anwanafig Godna mo eba inim higeg gwenaig gofif. ");
INSERT INTO amn_n_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Afa God elim enaig sihfenaba eso kam ahanaig esonaf? Afa Awag kam wignageg wahiagim eso kam ohuna bite gam ningihiag. Ahnaigesegba ne esogog ka Godum molamp onag mahim ka enaig sihifegba kaba Godna leg?” ");
INSERT INTO amn_n_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Afa ka kikeafna gafugag ese hwanigba nofeka kana mo higini. ");
INSERT INTO amn_n_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Afa ka awagna gafugag ati ka esenag. Afa nengel kana mo higigim kusi ofinifibi, afa kana kigmogim so na nangunim oniginim eso enag ne anwanafi Awag ka i ahagag afa ka awag i ahagag kaningi eba mungo ahfeg. ");
INSERT INTO amn_n_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Afa ehengel ogna piske ehem kikehli afa Sisas wasan ikana. ");
INSERT INTO amn_n_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Afa Sisas piske Jordan bu gam ehengam maligim ikanam agfohiefena. Enanai yi autunam Jon elim bu wa aitina. ");
INSERT INTO amn_n_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Afa el numb ehem nangum ambugona afa esogona og, “Jon mas mang kigmog wagfug mo afa mungwali mo Jon eso Sisasim sihinag eba ini feg.” ");
INSERT INTO amn_n_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Afa enanai yi el numb Sisasim olug onigini. ");
INSERT INTO amn_n_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Afa Betani nai el gihena heafna unehlagba Lasarus. Afa heafna muwalningi Maria i afa Marta i gaba gwenaig kimbig wa nai. ");
INSERT INTO amn_n_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Afa Maria eba enag angwafig Sisasim sanda bug sufuna afa heafna lapug ni ehena mongim titenagena. Heafna nisag Lasarus gihena.) ");
INSERT INTO amn_n_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Afa muwalningi Sisas nangum mo ahningihiana og, “Ainiyag neana hihe gihnagi.” ");
INSERT INTO amn_n_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Afa mahim Sisas enag mo higinam afa ehe enaig sihifeni og, “Ohuna gih eso ehem fag eba mas wahai. Enaig pugugba soma el Godna unehlagim fingifini afa Godna legim gwenaig esinif.” ");
INSERT INTO amn_n_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Afa Sisas Martam, Mariam, afa Lasarusim eso ehengelim membeni. ");
INSERT INTO amn_n_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Afa mahim Sisas ehenigina mom higinam afa ehe mas ikagna ikana mo. Ehe gwenanai yi gafena sambaga osuna. ");
INSERT INTO amn_n_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Afa mahim sambaga osuna fenaba ehe pahlukuiag elim enaig esoni og, “Ause big Judia gam piske ahuiagim.” ");
INSERT INTO amn_n_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Afa pahlukuiag el esogona og, “Tisa, mas manageg mo enanai yi Ju el ogna nem hunna tigi. Ahnaig esegba ne og ka piske susum ika?” ");
INSERT INTO amn_n_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Afa Sisas sihina og, “ Afwambusug eba osuna feg. Afa el osuna ikagba ehe mas mong kiakipe eso osu bitem afwambusug faig. ");
INSERT INTO amn_n_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Afa el sinaini ikagba eba afwambusug awai eso ehem mwelkiakipef.” ");
INSERT INTO amn_n_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Afa Sisas enaig sihifenam afa ming mo sihina og, “Lasarus bigelni hihe eba ehe nongi afa ka ehem ilafof.” ");
INSERT INTO amn_n_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Afa pahlukuiag el esogona og, “Ainiyag, afa ehem gih bihig fenam eso gifuf eba lahlafefe.” ");
INSERT INTO amn_n_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Afa Sisas Lasarusna wahagna mo sihinaba afa pahlukuiag el enaig onigifini ehe isug nongi. ");
INSERT INTO amn_n_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Eso Sisas ehengelim ambagwa sihini og, “Lasarusba ati wahag. ");
INSERT INTO amn_n_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Afa mahim wahagba ka mas enanai yi gafena mo afa ka nengelim sifakalinig eso ne kam olug onigini. Ause, nawo ahu ehem nangu.” ");
INSERT INTO amn_n_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Afa Tomas (heafna ming unehlag eba Didimus) mingnag pahlukuiag elim sihini og, “Bigel ehem mungwal pahlukunam afa ehe awahafuf eba bigel gaba pigiahiaf.” ");
INSERT INTO amn_n_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Ahunam Lasarusna kimbig wa opukonam. Afa kimbig wa nai el ati Lasarusim hun megam ahu fakini afa sambaga sambaga osuna enaig ati fena. ");
INSERT INTO amn_n_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Afa Betani eba muhwa Jerusalem wa go. ");
INSERT INTO amn_n_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Eso enaksag Ju el ambugonam Marta mi Maria mi kusugugonim mahim eheningina nisagim wahanibi. ");
INSERT INTO amn_n_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Afa mahim Marta anwanafenaba Sisas muhwa bofena eso ikanam Sisasim ufana. Afa Mariaba lala gafena. ");
INSERT INTO amn_n_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Afa Marta Sisasim sihina og, “Ainiyag, ne ohunanai yi gafiteba kana nisag mas wahaite. ");
INSERT INTO amn_n_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Afa ka ati anwanafeg yawa gaba ne mangim sahnaiba Godum eba nem faif.” ");
INSERT INTO amn_n_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Afa Sisas ehem sihina og, “Nana nisag eba nofkenagag piske fagim.” ");
INSERT INTO amn_n_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Afa Marta esona og, “Ka anwanafeg mahim God elim kwefihiagofefiba enanam eso ehe piske buihiaf.” ");
INSERT INTO amn_n_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Afa Sisas ehem esona og, “Kike enaig esef, wahag elim ilafotiginam afa higeg nofkenagag faif. Afa aman el kam olug oniginag eso wahag eba nofkenagag fafe. ");
INSERT INTO amn_n_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Afa aman el nofkena agfohie eso kam olug oniginag eba mas wahai. Ateaho ne enag mo olug oniginag?” ");
INSERT INTO amn_n_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Afa ehe wahigi sihina og, “Ei Ainiyag, ka enag olug oniginag neba Godna leg afa Godna Gishu Wahiag el eso God autunam ati sihi wahiana og ka nem bite gam ningihiaf.” ");
INSERT INTO amn_n_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Afa ehe enaig sihifenam lala gam piske ikanam afa Mariam sagmonam sihina og, “Tisa ati bog afa ehe nem awamona.” ");
INSERT INTO amn_n_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Afa mahim Maria ena mo higinam eso bihianam ehe nangum ikagna ikana. ");
INSERT INTO amn_n_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Sisas mas kimbig wa puguna mo ehe gwenanai yi gofena eso Marta ufana.) ");
INSERT INTO amn_n_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Afa Ju el Mariam kusugunim afa lala auguiafena. Afa mahim Maria bihianam kikini akafenaba eso ehengel ehem nangunim pahlukuna. Afa ehengel onigini og ehe bitekfe wa ufwegim aka. ");
INSERT INTO amn_n_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Afa Maria Sisasim pugunam afa ehena mong yi kwakwage peganam afa enaig esona og, “Ainiyag, ne ohunanai yi gafiteba kana nisag mas wahaite.” ");
INSERT INTO amn_n_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Afa mahim Sisas nangwagenaba Maria afa Ju el wewat wahiafenaba eso ehe kusugufenim afa ehena olug mas hugna lahlafena mo. ");
INSERT INTO amn_n_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Afa ehe ehengelim sahni og, “Ahana nai yi ne fakig?” Afa ehengel wahigi sihini og, “Ainiyag so bo nangu.” ");
INSERT INTO amn_n_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Afa Sisas nomb pe afenaba. ");
INSERT INTO amn_n_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Afa Ju el enam nangunim esogona og, “Nasabam, enag el heafna nihem hugna membenag.” ");
INSERT INTO amn_n_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Afa mingnag ehengelnai enaig esogona og, “Ehe enag el nof etetni elim nofug ati ugwe fatina afa ehe ohnam gaba enaig eseite Lasarus mas wahaite.” ");
INSERT INTO amn_n_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Afa Sisasna olug piske bihianam afa bitekfe gam ikana. Eba hun meg afa hun fifagna mengigim kaguni. ");
INSERT INTO amn_n_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Afa Sisas esoni og, “Hunim so bigifa fati.” Afa wahag elni muwalig, Marta esona og, “Hei Ainiyag, eba amtakwalig nofung puguiagim ehe ati bitekfe wa sambaga sambaga osuna feg.” ");
INSERT INTO amn_n_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Afa Sisas sihina og, “Ka nem ati sihinag afa ne kam olug oniginaiba eba ne Godna kifutig nangufe.” ");
INSERT INTO amn_n_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Afa ehengel hunim bigifi fatini. Afa Sisas ofim sisi nofenam esona og, “Humuan ka nem lahlag onag eso ne kana mo fahiginaf. ");
INSERT INTO amn_n_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ka ati anwanafeg ne kana mo fahiginaf afa ka ohuna mo enaig sihifenif eso el osa muhwa agfohie soma higinim afa anwanafi ne kam ningihiag.” ");
INSERT INTO amn_n_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Enaig sihi wahianam afa ehe hugna unena, “Lasarus pugu bo.” ");
INSERT INTO amn_n_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Afa enag wahag el pugu bona afa heafna mongningam lofugna kikenagini afa mingnag lofug ehena nofbosugum kaguni. Afa Sisas esona og, “Lofug piginagibi soma ikai.” ");
INSERT INTO amn_n_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Afa enaksag Ju el Maria nangum ambugonam afa enag kigmog nanguni eso Sisasim olug onigini. ");
INSERT INTO amn_n_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Afa mingnag el farisi elim nangugim ahunam afa enag mo sihigonugini eso Sisas esena. ");
INSERT INTO amn_n_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Farisi el i afa amunai pris i misog elni nof wa nuwagnam enaig esogona og, “Ahnaig so big esif? Enag el enaksag ahanaig ahanaig kigmog awgfuiageg. ");
INSERT INTO amn_n_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Afa big ehem isug nangu wahibi afa ehe mingnag kigmog enaig eseiba eso mungwali el ehem olug oniginif. Afa mungwali el ehem enaig esinibi eso Romna misog el ambugog nangunim eso Godna nalig lalam afa bigelni elim gaba amtakwalig aitif.” ");
INSERT INTO amn_n_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Afa mungo el ehengelnai heafna unehlag Kaiafas enanam prisni misog el enaig esona og, “Nengelni onigig wesig feg. ");
INSERT INTO amn_n_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Sa hig, afa enag mungo el wahaiba eba lahlafeg eso mungwali el mas awaiye.” ");
INSERT INTO amn_n_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Afa Kaiafas ohuna mo enaig sihifena afa enag mo eba mang heafna onigig wa enaig sihifiah mo. Enanam ehe prisni misog el fena eso enag mo sihina enaig Godna mo fi sihiaule el lofug fena. Ohuna mo enaig sihifeg Sisasna wahag Ju elim kwaganigim. ");
INSERT INTO amn_n_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Eba mang Ju elim mungo kwagani mo afa Godna el eso mungwali goka afa ehena wahag ehengelim wambinim eso Godna mungo el fif. ");
INSERT INTO amn_n_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Afa gwenanam enag mo higinim afa mina yisigiagini Sisasim tigigim. ");
INSERT INTO amn_n_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Eso Sisas mas Ju elni nofwa ambagwa ikana mo. Sisas afa heafna pahlukuiag el bite bihig gam muhwa ahuna. Ehengel Efraim kimbig auguiafena. ");
INSERT INTO amn_n_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Afa Pasova buyis meini ofefenaba eso el numb kimbig wahinim Jerusalem gam ahunam afa Mosesna nihem esinim eso buyisim numwehiagini. ");
INSERT INTO amn_n_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Afa el Sisasim yisiginim mahim awaiyenaba eso Godna nalig lala nuwagnam hefum sahigini og, “Ne ahanaig onigig fig ehe buyis wa boi me?” ");
INSERT INTO amn_n_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Afa amunai pris i afa farisi el i kifutig mo faig gona og, afa ne aman Sisasim nangwagba so kagelim sihigonibi eso kagel ahu ehem kikehli. ");
INSERT INTO amn_n_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Afa Pasova buyis meini ofe eba enwesog wa gohug osuna enanam puguf. Afa Sisas Betani wa puguna. Eba Lasarusna kimbig eso enanai yi ehem wahanaba eso Sisas ehem ilafona. ");
INSERT INTO amn_n_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Afa Sisasim fane numwehiagini. Marta fane magegiagena afa mingnag el i afa Sisas i sime wa auguiafena afa Lasarus gaba mungwali auguiafena. ");
INSERT INTO amn_n_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Afa Maria sanda botolna nalig bihia fanam Sisasna mong yi sugfunam heafna lapugni titenagena. Eso lahlag fungug lala wa puguna. Ohuna sanda eba enaksag kigna feg. ");
INSERT INTO amn_n_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Afa Judas Iskariot Sisasna pahlukuiag el fena ehe mas sifakalena mo mahim Maria enaig esenaba. Judas eba enag el eso Sisasim angoluwag elni ninga wa wahiaf. ");
INSERT INTO amn_n_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Afa ehe ninimuna og, “Enag sanda bugba elim faigote soma 300 kigna fiti eso big enag kigna gawig hwainig elim kwaganite.” ");
INSERT INTO amn_n_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ehe mang gawig hwainig elim onigini enag sihifiah mo. Eba ehe okwef el. Afa ehe ehengelni kig fakehlaf eso ehe mingnag mo wambug meagam kumug enag hefum kweafug. ");
INSERT INTO amn_n_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Afa Sisas esona og, “Afwai, nofeka ehem kwena. Ohuna sanda bug ehe faka wahianaba eso kana eligim numwehenageg bitekfe wa fakigim. ");
INSERT INTO amn_n_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","El gawig hwainig nengel nai yi higeg agfofi afa ka mas nengelim higeg wangafi.” ");
INSERT INTO amn_n_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Afa Sisas Betani wa gafena afa enaksag Ju el enam higinim eso ahu Sisasim nanguni. Afa ogna Lasarusim gaba nangu eso wahagba Sisas ehem ilafona. ");
INSERT INTO amn_n_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Eso amunai pris mo sihiagini ogna Lasarusim gaba tigi. ");
INSERT INTO amn_n_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Eso ehena yi enaksag Ju el ehengelni misog elim hwatigim eso Sisasim olug onigini. ");
INSERT INTO amn_n_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Afa ming osuna el numb buyis nangugim ambugona afa higinim og Sisas ohuna mina Jerusalem gam bo ikaf. ");
INSERT INTO amn_n_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Eso ehengel komb figeg tutoaginim ahunam ehem ufinim eso enaig esogona og; Godna unehlag nalig feg. Enag el God eso ningihiag soma God ehem lahlafia fai. God soma Ju elni misog elim lahlafia fai. ");
INSERT INTO amn_n_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Afa Sisas donki fanam afa fukoka ganam eso ikana. Afa mahim ehe enaig esenaba eso Godna mo inim pugug. Autunam Godna mo ati enaig ginofi wahini; ");
INSERT INTO amn_n_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Jerusalem wa nai el, so hig. Nofeka embefig, so nangu, nengelni misog el donki wa sisi obo. ");
INSERT INTO amn_n_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Afa enanam heafna pahlukuiag el enag mo mas onigini mo. Afa autunai wa Sisas wahanam afa bihianam awag nangum piske kukaf eso enanam ehengel enag mo anwanafif eba Sisasim sunig afa ehem kweagfunim enaig esini. ");
INSERT INTO amn_n_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Afa el Sisasim nanguni mahim Lasarusim ilafonaba bitek fenai eso enag mo sihiageahuna. ");
INSERT INTO amn_n_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Afa el numb enag kigmog mo higinim eso ambugonam Sisasim mina wa ufini. ");
INSERT INTO amn_n_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Afa farisi el hefum sihiageni og, “Bigel mas ehem kwenig mo. Sa nangu, el numb bigim hwatigim ehem pahluhug!” ");
INSERT INTO amn_n_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Afa mingnag Grik el Jerusalem gam ahuna. Ehengelbi afwambanai el ogna buyis ambugonam eso Godna unehlagim fingi fini. ");
INSERT INTO amn_n_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Afa ehengel ambugonam Filipim sahni og, “Amunai kagel ogna Sisasim nangu.” Afa Filipna Kimbig Betsaida Galili wa nai. ");
INSERT INTO amn_n_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Afa Filip Andrum sihinagim ikana eso eheningi Sisasim ahsihina. ");
INSERT INTO amn_n_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Afa Sisas esona og, “Yawaba eso God elim wagfunif Inim el eba nalig feg. ");
INSERT INTO amn_n_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Kike enaig kon fug lofug fe, kon kug enaig eseg afa ne mungo isug ningana faguafiba eba gwenaig mungo fifuf. Afa enag ne bite megam kumohlaiba eso noginam eso nog puguf enag mungo lig yi enaksag kug fef. ");
INSERT INTO amn_n_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Afa aman el hefum hugna onigkafuf enag el eba awaiyef. Afa aman el mas bitenaim hugna membeg mo afa heafna nofkenagag kusig eso enag el higeg nofkenagagim numwehiageg. ");
INSERT INTO amn_n_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Afa aman ne kana gafugag esenag ehe soma kana onigigim pahlubui. Eso ka ahnanai yi feg eba kana gafugag el gaba gwenanai yi fifuf. Afa aman el kana gafugag eseg eso kana awag ehem lahlag onaf.” ");
INSERT INTO amn_n_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Afa kana wahag muhwa ofe eso kana olug kinig feg. Ahnaig sihi ka fef. Ohuna kinig eba mog feg na ka bog. Eso masa ka enaig esof, ‘O Humuan ohuna kinig masa ne kana ninga wa wahiaf.’ ");
INSERT INTO amn_n_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Afa ka enaig esof, ‘O Humuan, so na nimbiafna unehlagim fingi fe!’” Afa God of wa wagofna og, “Ka ati kiafna unehlagim fingi feg afa ka gwenaig piske esef.” ");
INSERT INTO amn_n_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Afa el numb agfofenaba enag mengigim higini. Afa mingnag el enaig esogona og, “Eba hug moasig!” Afa mingnag el enaig esogona og, “Amo, eba of wa nai el ehem sihinago!” ");
INSERT INTO amn_n_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Afa Sisas ehengelim sihini og, “Enag mo mang kam kwegfwag mo eba nengelim kwaganigim. ");
INSERT INTO amn_n_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Afa enanam God bitenai elim kwefihiagefe eso ehe bitenai misog elim filafatif. ");
INSERT INTO amn_n_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Afa mahim el kam sisi kahlibi afa ka mungwali elim wambuiba eso kam ambugog muhwafinif.” ");
INSERT INTO amn_n_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Afa Sisas enag mo enaig sihifeni eba wagfug heafna wahag enaig esef. ");
INSERT INTO amn_n_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Afa ehengel esogona og, “Godna buk enaig sihifeg Godna Gishu Wahiag El higeg gafif. Ahnaig esegba so na enaig sihifeg Inim Elim sisyi kahlif? Kagelim sihini Inim El aman mahim?” ");
INSERT INTO amn_n_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Afa Sisas sihina og, “ Afwambusug nengel nai yi mas higeg gofi mahim enag afwambusug gofiba so na ati ika masa nem sikikfinaf. Eso el sinaini fakaf ehe mas anwanafe ehe asim aka. ");
INSERT INTO amn_n_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Afa ka enag afwambusug nem faig. Afa mahim ka nengel nai yi gofiba so na kam olug onigini eso nengel enaig fi eso el afwambusugni fakaf.” Afa Sisas enag mo sihi wahianam eso wasanam ikana afa mas ambagwa gofena mo. ");
INSERT INTO amn_n_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Afa Ju el enaksag kigmog nanguni eso Sisas esena eso ehengel ehem mas olug onigini mo. ");
INSERT INTO amn_n_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Afa ehengel enaig esini eso Aisaiana mo inim puguna. Ehe Godna mo fa sihiaule el afa autunam ehe enaig esona og; O Ainiyag, ne ati nimbiafena kigmog wagfug eso kagel neana mo sihigonugbi afa ehengel mas higig mo. ");
INSERT INTO amn_n_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Afa ehengel mas Sisasim olug onigini mo eso Aisaia ming mo piske sihini og; ");
INSERT INTO amn_n_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","God ehengelni nofugum kagunig eso ehe mas nunofihiagini mo afa onigigim kikisenig eso mas numwehe anwanafi. Afa God enaig esog afa ka enaig ese hwanigba eba ehengel kam piske oniginif eso ka ehengelim lahlafetifef. ");
INSERT INTO amn_n_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Autunam God Aisaiam itiwa wagfuna eso Sisasna kifutigim nanguna eso enag mo ehem sihinag. ");
INSERT INTO amn_n_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Afa farisi el enaig sihififni aman ne Sisasim olug oniginaf eso nofeka nuwagig lala gam ambugog go. Afa enaksag Ju elni amunai el Sisasim olug onigini. Afa farisi elim embefegoni eso enag mo mas ambagwa sihiagini mo. ");
INSERT INTO amn_n_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Afa ehengel hugna membig el soma ehengelim lahlag goni afa Godum mas enaig onigifini mo. ");
INSERT INTO amn_n_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Afa Sisas ambagwa sihina og, “Aman ne kam olug oniginag afa el kam eso ningihiag ehem gaba olug oniginaf. ");
INSERT INTO amn_n_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Afa aman ne kam nangufe afa el kam eso ningihiag ehem gaba nangufe. ");
INSERT INTO amn_n_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Afa ka ohuna bite wa bog afa ka elim afwambusug faig eso mungwali el kam olug oniginif ehengel mas sikifig wa agfohiefi. ");
INSERT INTO amn_n_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Afa aman ne kana mo higinam afa mas pahlukui afa kike ehem mas kufeni. Afa ka mang bite nai elim kufenigim boah mo afa ka elim wambugum ka bog. ");
INSERT INTO amn_n_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Afa aman ne kam mas fatinag afa kana mo mas kehlag mo afa mahim kwefihiageg osuna ohuna mo ka sihinag eba ehem kufenaf. ");
INSERT INTO amn_n_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Afa kana ohuna mo enaig esef eso ka mas kiafna onigig wa enaig sihif. Awag kam ningihiag afa ehe kam kifutig mo faig eso ka gwenag mo fagim so ka sihiageg. ");
INSERT INTO amn_n_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Afa ka anwanafeg heafna mo elim higeg nofkenagag mina wagfunig. Eso mo ka sihig eba Awag kam faig naka sihig.” ");
INSERT INTO amn_n_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Afa enanam Pasova buyis meini ofefenaba. Afa Sisas anwanafena ehe bite wahiagim ati muhwa ofe eso Awag nangum piske ikaf. Afa ehe heafna elim higeg membenig fafefe eso ohuna bite wa feg eso ehena membug gwesim mungwal fafaini. ");
INSERT INTO amn_n_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Afa Satan ati Judas Iskariotim amtakwalig onigig faina eso ehe Sisas angoluwag elni ninga wa wahiaf. Enag Judas eba Saimonna leg. Afa Sisas heafna pahlukuiag el mungwali augunam fane ahgafenaba. ");
INSERT INTO amn_n_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Afa Sisas anwanafeg Awag ehem mungwali kifutig ati faig eso mungwali ehem ahnai skaufenig. Afa ehe anwanafeg ehe Godum wahia bog afa piske ikaf. ");
INSERT INTO amn_n_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Eso Sisas bihianam nineg lofug hugufanam afa taul agagig wa kigauguna. ");
INSERT INTO amn_n_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Afa ehe bu sob yi sugfunam afa so heafna pahlukuiag elni mongim gigiafenugena afa taul hugufanam eso enana titenugena. ");
INSERT INTO amn_n_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Afa ehe ogna Saimon Pitam enaig esena. Afa Pita enaig esona og, “Ainiyag, ateaho so na kana mongim gaba buna gigiafenai?” ");
INSERT INTO amn_n_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Afa Sisas wahig sihina og, “Mang ka eseg ne enag mas yawo anwanafeg mo afa autunai wa ne enam anwanafef.” ");
INSERT INTO amn_n_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Afa Pita ehem sihina og, “Amo, nofeka kana mongim gigiafena.” Afa Sisas wahig sihina og, “Afa ka nem enaig esenag hwanigba eba ne mas kana pahlukuiag el fenai.” ");
INSERT INTO amn_n_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Afa Pita esona og, “Ainiyag, afa enaig inimemfef afa kam kusig mong bihig gigiafegimba ka membeg so na kana eligim mungwali sufa.” ");
INSERT INTO amn_n_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Afa Sisas esona og, “Afa aman ne bu wa suf eso ehena eligbi ambug gofuf. Afa kimbig wa pugunam eso mong bihig gigiafena. Afa nengelbi mungwali ambug agfohie eso mungo el nengel nai mas enaig goh mo.” ");
INSERT INTO amn_n_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Sisas ati anwanafeg aman el afa ehem angoluwag elni ninga wa wahiaf eso ehe enaig esog, “Nengelbi mungwali ambug agfohie eso mungo el nengel nai mas enaig goh mo.”) ");
INSERT INTO amn_n_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Afa Sisas ehengelni mong sufuhiage wahinim afa lofug piske fatinam afa sime gam ikanam eso ehengelim sahtigini og, “Ateaho ne ohnam anwanafig so ka nem esenig? ");
INSERT INTO amn_n_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Afa ne kam enaig sefi fig Tisa afa Ainiyag eba ne lahla sihifeg eso kike enag elbi feg. ");
INSERT INTO amn_n_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Sa nangu! Kaba Tisa afa Ainiyag ka nengelni mongim buna sufuhianugeg eso ka isug gafugag elni gafugam esenig. Afa ne gaba nimbiafgelni nai elni mongim so na sufuhiage gonugibi enaig eba lahlafeg. ");
INSERT INTO amn_n_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Afa kati nem minaba wagfunig eso ka nem esenig so na mingnag elim enaig esegoni. ");
INSERT INTO amn_n_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Eba inim feg. Afa gafugag el mas gosu eba misog el gosu fakaf. Afa el eso mo fabug enag el mas gosui eba el eso ehem ningihiag enag el gosu fakaf. ");
INSERT INTO amn_n_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Yawaba ne enag inim mo anwanafig afa ne enam pahlukuiba eso ne sifakali. ");
INSERT INTO amn_n_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Kana mo mang nengelim mungwali esoni mo. Ka nengelim awamonigim eso ka nengelim ati anwanafenig ne ahanaig el mahim. Afa Godna mo enaig sihifeg ‘Enag el ka fane mungwali ahneule ehe kam amtakwalinagim.’ ");
INSERT INTO amn_n_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ka nengelim ohuna mo osihini afa mahim enagba puguiba nengel kam olug onigif kike i afa kiafna mo i higeg ka ahgofuf. ");
INSERT INTO amn_n_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Eba inim feg. Ka elim ningitigi afa aman ehengelim awamogonibi eba kam gaba gwenaig esenig. Afa aman kam awamonaiba eba kana elim gaba gwenaig esigonug eso ka ningitigig.” ");
INSERT INTO amn_n_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Afa enag mo sihi wahianam afa ehem olug kinig fenam eso ambagwa sihina og, “Eba inim feg nengelnai mungo kam angoluwagna ninga wa wahiaf.” ");
INSERT INTO amn_n_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Afa pahlukuiag el hefum fanangu feaginim afa etetiagini og ehe aman elim esonag. ");
INSERT INTO amn_n_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Afa pahlukuiag el mungo Sisas eso ehem hugna membenag enag el Sisas i muhwa ahagag fena. ");
INSERT INTO amn_n_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Eso Pita ehem mingigna sehneina og, “Sahna ehe amanim esonag?” ");
INSERT INTO amn_n_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Eso enag el Sisasna elig nai yi muhwa gafena afa enag sahna og, “Ainiyag, eba aman mahim?” ");
INSERT INTO amn_n_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Afa Sisas wahigig sihina og, “Ka amba fane bug wa fatinam elim faiba eba enag el kam esenaf.” Eso ehe amba bu wa fatinam Judasim faina. Judas eba Saimon Iskariotna leg. ");
INSERT INTO amn_n_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Afa enanam Judas amba fanam afa ikagna Satan ehem simbagahlana. Afa Sisas ehem sihina og, “Afa ne mang enaig esofefiba so na ikagna ese.” ");
INSERT INTO amn_n_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Afa mingnag pahlukuiag el auguiafena afa enag mo mas anwanafini mo asegba Sisas ehem enaig sihifena. ");
INSERT INTO amn_n_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Afa Judas ehe kigim kehlag eso mingnag pahlukuiag el enaig onigifini og Sisas ehem ningihiag ma ka buyisna fane wambu. Afa mingnag enaig onigifini og Sisas ehem ningihiag soma gawig hwainig elim kwagani. ");
INSERT INTO amn_n_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Afa Judas amba fanam eso ikagna afwambagam pugu kana. Eba sinaini ehe enaigba esena. ");
INSERT INTO amn_n_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Afa Judas mahim ikanaba Sisas sihini og, “Yawo God Inim elni kifutig ambagwa wagfuf afa Godna kifutig Inim el nai yi ambagwa puguf. ");
INSERT INTO amn_n_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Kaba Inim el afa Godna kifutig ka nai yi ambagwa wagfuiba eso nanguf eso God ehe kana kifutig elim wagfunif. Yawo God enaig esef. ");
INSERT INTO amn_n_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Kana luwal, ka mwakwalig ganam afa ikaf. Afa nengel kam ogna yisigi afa ne kam mas nangui. Afa Ju elim ohuna mo ka sihinig nengelim gaba gwenaig mo ka nem esonig, ‘Asim eso ka aka nengel mas ambugog.’ ");
INSERT INTO amn_n_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Afa ka nengelim yawonai nihe mo faig. Eba enaig esog so na nimbeafgeli nai hugna membagi. Eso ka nem hugna membenig so nengel gaba gwenaig esi nimbeafgel naim so na membagi. ");
INSERT INTO amn_n_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Afa ne enaig esegba mingnagim membegonif eso mungwali el anwanafif ne kana pahlukuiag el.” ");
INSERT INTO amn_n_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Afa Saimon Pita sahna og, “Ainiyag, asim ne aka?” Afa Sisas sihina og, “Asim so ka aka yawo ne kam mas pahlubui afa sumi yi ne kam pahlukuf.” ");
INSERT INTO amn_n_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Afa Pita sahna og, “Ainiyag, asegba ka mas nem yawo pahlukui? Eso el biningim sofegonifibi ka mas wahagim embefe!” ");
INSERT INTO amn_n_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Afa Sisas sihina og, “Ateaho ne enaig inim esef? Afa kana kugum fanam eso wahaf? Eba inim feg afa kakaruk mosiagim meinifefiba afa ne sambaga mungonagim ne enaig esof ka mas ehem anwanafenag mo.” ");
INSERT INTO amn_n_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Afa Sisas pahlukuiag elim enaig esoni og, “Masa nengel hugna kukugeskofif afa olug kinig feskofif. So na Godum olug onigini afa kam gaba gwenaig esini. ");
INSERT INTO amn_n_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Afa kana Awagna lalaba enaksag kug gohka. Enaig inim hwanigba ka mas nem enaig esoni. Eso ka nengelni kug numwehiage gim ka aka. ");
INSERT INTO amn_n_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Afa ka nengelni kug numwehiagenam eso ka piske bonam nengelim wambinam eso big mungwali enanai yi ahu auguf. ");
INSERT INTO amn_n_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Afa ohuna mina ne anwanafig mo ka asim aka” ");
INSERT INTO amn_n_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Afa Tomas ehem sahna og, “Ainiyag, kagel mas anwanafig mo asim ne aka! Ahnaig ka esigbi eso ka ena minam ahuiagimba anwanafif?” ");
INSERT INTO amn_n_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Afa Sisas wahigi sihina og, “Afa el membeg inim mo anwanafigim afa nofkenagag figim eba kike ena minaba feg. Afa Awag nangum ahuiagba mas ming minaba goh mo, eba awai, kike mungo feg. ");
INSERT INTO amn_n_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Afa ne kam numwehe anwanafigbi eba kana Awagim gaba ne ehem anwanafif. Yawo ne ehem anwanafig afa ne ati nangug.” ");
INSERT INTO amn_n_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Afa Filip sihina og, “Ainiyag, nimbiafena Awagim kam wagfunibi eso ka enam nanguf eba kagelni sahigbi ati yuhwafeg.” ");
INSERT INTO amn_n_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Afa Sisas esona og, “O Filip, big higeg ahwagiakaba. Afa asegba ne kam mas anwanafenag mo? Afa aman ne kam nangug eba ehe ati Awagim nangug. Afa asegba ne kam esonag, ‘Kam Awagim wagfuni?’ ");
INSERT INTO amn_n_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Afa Awag ka i ahgohug afa ka Awag i ahgohug; afa ne enam mas onigig mo? Afa mo ka nem sihinig eba mang kana mu mo eba kiafna Awag ka i ahgoba enag ehe heafna gafugafeg. ");
INSERT INTO amn_n_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","So na kana mom onigim eso ka nem sihinig ka Awag i ahgohug afa Awag ka i ahgohug. Afa awaiegba so na kana kigmogim piske onigigim eso ne kam olug onigini. ");
INSERT INTO amn_n_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ka nem inim sihinig aman el kam olug oniginaf eba ehe gaba gwenaig kigmog esef eso ka eseg. Afa enaig elni gafugag kana gafugagim goseg eso kaba Awag nangum aka. ");
INSERT INTO amn_n_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Afa mangim ne kana unehlag wa sahiba eba ka esef eso ka Leg Awagna unehlagim fingifef. ");
INSERT INTO amn_n_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Afa mungwali mangim gaba ne kana unehlag wa sahiba eba ka esef. ");
INSERT INTO amn_n_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Afa ne kam hugna membenagba eba so na kana mom ugwe pahlukui.” ");
INSERT INTO amn_n_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","“Afa ka Awagim sahnam eso ehe nengelim ming Kwagfwag el ningihianif eba nengelim simbigahlanam higeg wangofuf. ");
INSERT INTO amn_n_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Enag Kwagfwag el eba Godna Sungwag eso Godna inim mo ambagwa nem pugunif. Afa bitenai el ehem mas nanguni afa anwanafini mo eso ehem mas sugufini mo. Afa ne ehem ati anwanafini eso ehe nengelim wangofna afa nengel i sahogofna. ");
INSERT INTO amn_n_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Afa ka nem mas hwati ofenaiba bulwag luwal lofug. Afa ka nem piske bonam nangwag fe. ");
INSERT INTO amn_n_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Afa mungwanam feg hwainig bitenai el mas kam nangui afa ne kam nanguf. Ka nofkikenafeg eso nengel gaba nofkena auguf. ");
INSERT INTO amn_n_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Afa enag osuna puguiba ne anwanafif ka kiafena Awag i ahgo afa ne ka i ahgo afa ka ne i ahgo gwenaig. ");
INSERT INTO amn_n_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Afa aman el kana nihe mo kikehlanam pahlukuiba eba enaig el kam hugunam membenag. Afa sohnaig el kam enaig esenaiba afa kana Awag ehem membenaf afa ka gaba gwenaig esenam eso ka kefum ehem ambagwa pugunafe.” ");
INSERT INTO amn_n_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Afa ming Judas (ehe mang Judas Iskariot mo) ehe enaig esona og, “Ainiyag, asegba ne ogna nimbefum kam wagfuni afa ne mas nimbefum mingnagim mungwali wagfunig mo.” ");
INSERT INTO amn_n_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Afa Sisas wahigi sihini og, “Aman kam membenaf eba kana mo higigim pahlubug. Afa kana Awag ehem membenag eso kaningi ahbonam enag el i ahgofuf. ");
INSERT INTO amn_n_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Afa aman mas kam membenai eba kana mo ehe mas pahlubui. Ena mo ne higig eba mang kana onigig wa bo mo awai, Awag kam ningihiag afa enag heafna mo. ");
INSERT INTO amn_n_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Afa enanam ka nem wangofenaba ka nem ohuna mungwali mo sihinig. ");
INSERT INTO amn_n_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Afa Awag kana unehlag wa Kwagfwag el ningihiaf. Enaba Godna Sungwag afa ehe nengelim mungwali wagfunim afa ehe nengelni onigigim fokwa wasanaba eso ne enam piske onigif mo so ka nem sihini. ");
INSERT INTO amn_n_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Ati muhwa ofe ka nem wasanif afa kaba olug efihlagna feg enag afafug ka nem faif. Bitenai elbi mas nem enaig olug efihlagba fai, eba awai. Eso nofeka hugna oniginim afa embe olug fi. ");
INSERT INTO amn_n_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Afa ne kana mo ati higini ka enaig esona kog ka nem wasan ikanam afa ka nem piske bo pugunif. Afa Awag kam gosenag. Afa ne kam membeniba so na sifakali ka Awag nangum kako. ");
INSERT INTO amn_n_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Oso ka nem yawo osihini eba autunai wa so puguf. Mahim enag puguiba so na enam onigif eso ne anwanafif kana moba inim feg. ");
INSERT INTO amn_n_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Afa Satan bitenai misog el ati obo eso ka aseg nem hugna sihin goh mo. Afa heafna kifutig mas kam yuhwafenag mo. ");
INSERT INTO amn_n_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Afa bitenai el so ma anwanafi ka Awagim membenag. Ehe kam esonagba na ka ehena gafugag mungwali esenag. Au ambugog nawo ahu.” ");
INSERT INTO amn_n_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Afa Sisas enaig esog, “Kaba inim we afalig afa kana Awagba asona mogba feg. ");
INSERT INTO amn_n_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Afa mungwali iklig eso ka nai yi agfo afa mas fug luwug mo afa ehe higfeitifef afa mingnag iklig eso fug luwug ehe enaba afwambusugnugegba so ma enaksag fug luwoi. ");
INSERT INTO amn_n_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Afa kana mo ati ka nem faig eba enag mo nengelim afwambusunugegba eso ne afsug agfohie. ");
INSERT INTO amn_n_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","So na ka i ahgohi afa ka gaba ne i ahgohfif. Afa iklig afalig i kufeg hwanigba eba mas fug luwoi. Eba mungwalofug gwenaig feg afa ne ka i ahgohug hwanigba eba ne nai yi fug mas luwoi. ");
INSERT INTO amn_n_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Afa kaba we afalig feg afa nengelbi iklig feg. Afa el ka i ahgohug afa ka ehe i ahgohug eso ehe enaksag fug luwof. Afa ne ka i ahgohug hwanigba eba mas ne mangim gaba esei. ");
INSERT INTO amn_n_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Afa aman el ka i ahgohug hwanigba ehe enaig li iklig lofeg eso higfei susugbi eso fofeg. Afa enagba wambugum suwi wa wehlig. ");
INSERT INTO amn_n_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Afa ne ka i ahgohfiba afa kana mo gaba ne nai yi ati goh eso ne nimbiafena membug wa Awagim sahnaba afa ehe nem enaig esenaf. ");
INSERT INTO amn_n_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Afa mahim ne enaksag fug legeageg eso enaba wagfug ne kana pahlukuiag el fegba eso kana Awag unehlag nalig fag. ");
INSERT INTO amn_n_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Awag kam hugna membenag afa ka gaba nengelim gwenaig esenig. So na higeg kana membug wa agfohefum. ");
INSERT INTO amn_n_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Afa ne kana mo pahlukuiba eso ne kana membug wa agfohiefim. Eba gwenaig ka gaba kiafena Awagna mo pahlukug eso ka heafna membug wa ka goh. ");
INSERT INTO amn_n_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Afa ka nem ohunaig sihiofin kana sifakal so ma nengel nai yi pahaiba afa enag sifakal nengel nai yi gofiba eba nem ihafenif. ");
INSERT INTO amn_n_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Afa kana nihe mo ohunaig esog afa ka nem membenig eso nengel gaba mingnagim gwenaig esegoni. ");
INSERT INTO amn_n_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Nalig membug eba enaig feg el so ma heafna nofkikenag wahianam eso heafna hihem kweagfug. ");
INSERT INTO amn_n_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Afa ne kana mom pahlukuiba eba ne kana hihe feg. ");
INSERT INTO amn_n_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Afa Sisas esog, Ka mas nengelim isug gafugag el oni eba misog el mangim onigigba afa heafna isug gafugag el mas enam anwanafi. Afa ka nengelim esonig neba kana hihe feg eso mungwali mang Awag kam wagfunag eba enag ka ati nengelim wagfunig. ");
INSERT INTO amn_n_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Afa ne mas kam kanoi mo, amo ka ati nengelim kanog hwatina eso ne ahu gafugafibi so ma enag fug luwoi. Afa enag fug so ma higeg gofi. Eso mangim kana unehlag wa Awagim sahnibi eba ehe enag nem faif. ");
INSERT INTO amn_n_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Afa kana nihe mo enaig esog so na enaig esi, ‘So na nimbefum hugna membeagi.’” ");
INSERT INTO amn_n_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Afa Sisas esog, “Afa bitenai el nengelim olug kakagfegonibi so na piske onigi ehengel ati gof kam enaig esini. ");
INSERT INTO amn_n_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Afa ne bitenai fegba eba bitenai el nem membegonif, amo ka nem ati kanog hwatig eso ne bitenai nihe wahia afa ne enaig esibi eso bitenai el nem olug kakagfegonif. ");
INSERT INTO amn_n_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","So na piske onigif mo so ka nengelim sihinig, ‘Afa isug gafugag el mas misog elim gosenai.’ Afa ehengel kam amtakwal efibi eba nengelim gaba gwenaig esegonif. Afa ehengel kana mom higigbi eba nengelni mom gaba gwenaig esif. ");
INSERT INTO amn_n_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Afa ne kana el fegba eso ehengel nem enaig esegonif. Afa Awag kam nigihiagba na ka bog afa ehengel ehem mas anwanafig mo. ");
INSERT INTO amn_n_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Afa ka bo ehengelim mo sihinig hwanigfefiteba ehengelni nuhwef mas goh mo. Afa yawo ehengel mas enaig esogoi kagel mas anwanafig mo mang ka esig eba amtakwalig. ");
INSERT INTO amn_n_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Afa aman el kam olug kakaginibi eso ehe gaba kana Awagim gwenaig esinig. ");
INSERT INTO amn_n_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Afa ka ehengel nai yi olyi kigmog wagfug afa mas aman el enag enaig esena mo. Afa ehengel kam mas olug onigigim eso ehengelni nuhwef eba gwese goh. Afa yawo kigmog ati nangugim afa ehengel ka mi kana Awag mi olug kam kakage gonig. ");
INSERT INTO amn_n_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Afa autunam ehengelni nihe mo enaig esog; Ehengel kam mungwinim olug kakagini. “Afa yawo enag mo inim pugug. ");
INSERT INTO amn_n_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Afa ka Godna Sungwag nengelim ningihianif. Afa ehe Awag i ahagag eso bonam nengelim kwaganif afa heafna mo eba inim. Afa heafna mo eba kana mom sihinaf. ");
INSERT INTO amn_n_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Afa mulug yi nengel ka nai yi agfohiafena eso ne gaba mingnag elim kana mom sihigonif.” ");
INSERT INTO amn_n_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Afa ka nengelim enag mo sihinig eso nengelni olug onigig nofeka amusna piske ahu. ");
INSERT INTO amn_n_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Afa ehengel nengelim nuwagig lala afwambawa wambaitif. Afa sumi yi enag osuna puguiba el eso nengelim kwagihig ehengel enaig onigifif og ka Godum kweagfug. ");
INSERT INTO amn_n_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Afa ehengel Awag mi ka mi mas anwanafegonig mo eso ehengel enaig esif. ");
INSERT INTO amn_n_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Afa ka nengelim enaig mo sihinig eso enaig kinig osuna opugufiba so na piske onigif eso ka nem numwehenugenig mo sihinig. Afa yuwanam yi ka ne i ahgofena eso ka mas nengelim enag mo sihini mo.” ");
INSERT INTO amn_n_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Afa yawo ka Awag nangum aka afa ne mas kam sahnag mo, ‘Ne asim aka?’ ");
INSERT INTO amn_n_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Afa yawo ka nem ohuna mo sihinig eso enag nengelni olug kinig faskofeg. ");
INSERT INTO amn_n_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Afa ka nem inim mo sihinig afa ka nengelim wahia ikaiba enagba nengelim lahlafenig. Afa ka ika hwanigba Godna Sungwag nengelim mas boni. Afa ka ikagba eba ka ehem ningihiaf nengel nangum. ");
INSERT INTO amn_n_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Afa mahim ehe boiba ehe bitenai elim amtakwalig nihe afa lahlag nihe afa kwefihiag nihe enag sihinugef. ");
INSERT INTO amn_n_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Afa el kam mas olug onigini eso ehe ehengelni amtakwalig nihem wagfunif. ");
INSERT INTO amn_n_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Afa ka Awag nangum ikaf afa nengel mas kam nangui eso ehe lahlag nihe sihinugef. ");
INSERT INTO amn_n_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Afa God bitenai elni misog elim, Satanim, ati kwefihiageg eso Godna Sungwag elim kwefihiag nihe sihinuge wahiag. ");
INSERT INTO amn_n_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Afa ka membeg enaksag mo nem fai afa ne mas enam yuhwafig mo. ");
INSERT INTO amn_n_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Afa Sungwag ehe Godna inim mo kehlag afa mahim ehe boiba ehe nengelim mungwali inim mo ogfunugef. Afa ehe mas heafna onigig wa nengelim sihini amo, afa mang ehe higig eba enam sihif. Afa mang sumi yi so puguf ehe enam nengelim sihinif. ");
INSERT INTO amn_n_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Afa ehe kana mo fanam afa nem sihinif eso ehe kana unehlagim fingi fef. ");
INSERT INTO amn_n_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Afa mungwali gawig Awagna feg eba kana. Eso ka ati sihig Sungwag kana mo fanam nem sihinif.” ");
INSERT INTO amn_n_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Afa Sisas enaig esog, “Mwakwalig afa ne kam mas nangui eso manageg hwainig ne kam piske nanguf.” ");
INSERT INTO amn_n_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Afa mingnag pahlukuiag el hefum sihiageni og, “Mangigim bigim enaig esonug, ‘Mwakwalig afa ne kam mas nangui eso manageg hwainig ne kam piske nanguf’ afa mingam ehe enaig esog ‘Ka Awag nangum aka eso enaig puguf.’ ");
INSERT INTO amn_n_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Enag mo ‘Mwakwalig’ eba mangim esog afa enag ehena mo bigel mas anwanafig mo.” ");
INSERT INTO amn_n_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Afa Sisas anwanafeg ehengel enam mo onigiahufnaba ogna ehem sahni eso ehe sihini og, “Ka esog ‘Mwakwalig afa ne kam mas nangui eso manageg hwainig ne kam piske nanguf.’ Atiasni enam ne nimbefum sihiageahu? ");
INSERT INTO amn_n_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Afa ka nem inim sihinig afa ne wewatunam nomb mewa auguiafiba afa bitenai el eheba sifakalifi. Afa ne olug kinig faskofeg afa nengelni kinig eba wahigefe sifakaleg puguf. ");
INSERT INTO amn_n_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Sa hig, mahim luwal gohugum ofeba eba angwafig tautig mu gof fagim. Afa mahim luwal mo gohugba eso angwafig mas piske tautig onigi eba ehe sifakaleg luwal ati gohug. ");
INSERT INTO amn_n_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nengel gaba gwenaig esif, yawana mo ne olug kinig finim afa ka nem nangwagiba eba ne sifakalifi. Enag sifakal mas aman nengelni nihinai hugufati.” ");
INSERT INTO amn_n_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Afa enag osuna puguiba eba ne mas kam mangim sahini. Ka nem inim sihinig mangim ne kana unehlag wa sahiba eso kana Awag nem faif. ");
INSERT INTO amn_n_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Afa yawa gaba nengel kana unehlag wa mas mangim sahig mo. Esese ne sahiba ne fafe eso nengelni sifakaleg yuhwafef.” ");
INSERT INTO amn_n_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Afa Sisas enaig esog, “Ka nem ati waskwes mo sihini afa enag osuna puguiba ka mas nem waskwes mo sihini eso ka ambagwa kiafna Awagna mom nem sihinif. ");
INSERT INTO amn_n_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Afa mahim enag osuna puguiba ne Awagim kana unehlag wa sahnaiba, ka mas enaig esog enanam ka nem kweagfunam ehem sahani, amo, ");
INSERT INTO amn_n_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ka mas nengelim enaig esini eba kiafna Awag ehe nengelim hugna membenig. Afa ne kam hugna membeni afa ne onigig God kam ningihiag naka bog eso ehe nengelim membenig. ");
INSERT INTO amn_n_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Eba inim feg ka kiafna Awagim wahiagim naka ohuna bite wa bog afa yawo ka ohuna bite wahianam eso ka piske Awag nangum ikaf.” ");
INSERT INTO amn_n_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Afa pahlukuiag el enaig esogona og, “Ei, yawo ne ambagwa sihig afa ne mas waskwes mo sihig mo. ");
INSERT INTO amn_n_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Afa yawo kagel anwanafig ne mungwali ati anwanafeg mangofi kagel yiskosig nem ming sahnigim eso kagel ati olug onigig ne Godna bog.” ");
INSERT INTO amn_n_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Afa Sisas esoni, “Ateaho ne enam olug onigig? ");
INSERT INTO amn_n_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Higim, enag osu ati muhwa ofe amo eba ati pugug eso ne mungwali kam wahinim ahuiaminefef nimbiafgelni mungo mungo kimbig gam eso ka kikefwaimu gofuf. Afa ka mas kikefwaimu nemug gofi eba kiafna Awag i ka ahgofuf. ");
INSERT INTO amn_n_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Afa ka nem enag sihinig eso ka nai yi agfofum eba so na olug efihlagna agfofufe. Afa ohuna bitewaba kinig nengelim pugunif eso nofeka embefi eba kati bitenai nihe filafatig.” ");
INSERT INTO amn_n_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Afa Sisas ena mo sihi wahianim afa ofim nangunam so enaig esona og, “Humuan, kam wahag was ati pugug so na nimbeafna Legim fingi fe eso ma nimbeafna Leg nem fingi fei. ");
INSERT INTO amn_n_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ne kam kanog og so ma elni misog el fei eso aman el kana ninga wa wasanig eba ka ehengelim inim nofkenagag faif. ");
INSERT INTO amn_n_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Afa inim nofkenagag eba enaig eseg eso ehengel nem ati anwanafig ne inim God mungo feg afa ka Sisas Krais ne kam ningihiag. ");
INSERT INTO amn_n_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Afa ena gafugag ne kam faina eba ati ka augig eso ka enaig fegba ka neana unehlagim ohuna bite wa fingi feg. ");
INSERT INTO amn_n_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","O Humuan, afa bite mahim fiahfenaba afa big ahagafenaba enanam kana unehlag eba nalig fena. Afa yawo ka membeg nimbeafna nof wa enag nalig unehlag ne kam piske fai. ");
INSERT INTO amn_n_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Afa enag bitenai el ne kam faina ka ehengelim sihinig afa nem ati anwanafig. Ehengelbi neana fena afa ne kana ninga wa hwatig afa ehengel neana mo higigim pahluhug. ");
INSERT INTO amn_n_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Afa mungwali kike mungo fegba ehengel ati anwanafig enag ne kam faig eba neana bog. ");
INSERT INTO amn_n_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Afa mungwali mo ne kam faig enag ka ehengelim faig eso ati fig. Afa ehengel anwanafig enag mo eba inim afa olug onigig ne kam ningihiagba na ka nem wahigim ka bog. ");
INSERT INTO amn_n_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ka mas bitenai elim betenenig mo amo el eso ne kana ninga wa hwatig eba neana feg na ka ehengelim betenenig. ");
INSERT INTO amn_n_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Mungwali el kana feg eba neana afa neana eso feg eba kana. Afa enag el wagfug kana unehlag eba nalig feg. ");
INSERT INTO amn_n_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Afa yawo ka ohuna bite wahianam nem nangwagim bof afa ehengel so bite wa auguia. O Humuan, neba afsug nemug afa nimbeafna kifutig unehlag so na kam faig ena unehlag wa so na ehengelim nangwaghiage fegofum so ma ehengel mungo agfofi eso big mungo nemug ahfeg. ");
INSERT INTO amn_n_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Afa mahim ka ehengelim wangofnaba ka ehengelim kaguagfwehiafna gofna enag neana kifutigni ne kam fainaba eso ka enaig esena. Mungwali lahlaggofena mas aman awaiena mo afa el mungo awaiena. Autunam neana mo enaig sihi fewahiana enag el mungo awaief afa enaba inim puguf. ");
INSERT INTO amn_n_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Afa ati muhwa ofe ka neanangum bof afa ka bite wa gohba ohuna mo ka esona eso kana sifakal so ma ehengel nai yi yuhwafeni. ");
INSERT INTO amn_n_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Afa ka neana mo ehengelim faig enag figim eso mas enaig bitenai el opukog mo eso ka gaba mang bitenai el mo. Eso bitenai el ehengelim olug kakag fegonug. ");
INSERT INTO amn_n_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ka mas nem esonai enag elim wambuiba so ma ohuna bite wa wahiyi amo, ka nem enaig sahna fenag so na kagwuf hiage gofiba eba Satan mas ehengelim amtakwale aiti. ");
INSERT INTO amn_n_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Afa ka mang bitenai el feg mo eso ehengel gaba gwenaig. ");
INSERT INTO amn_n_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Afa neana mo eba inim nemug feg. Ka membeg ohuna inim mo so ma ehengelni onigig wa gohfi eso neana el nemug apukuf. ");
INSERT INTO amn_n_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Afa ne kam bite gam ningihiag afa ka gaba ehengelim ohuna bite wa ningitigif. ");
INSERT INTO amn_n_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ka kefum nem mungwali faig eso ehengel gaba gwenaig neana nemug fig. ");
INSERT INTO amn_n_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ka mang enag pahlukuiag el mungo beteneni mo amo afa mungwali el eso pahlukuiag elni mo higigim afa kam olug oniginig na ka ehengelim gaba ka betenenig. ");
INSERT INTO amn_n_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Afa ehengel so ma mungo agfohiefi eso big esahfeg ne ka i ahgohug afa ka ne i ahgohug. Sa ma ehengel eba biningi nai yi agfofi afa mungwali bitenai el so ma onigi ne kam ningihiag na ka bog. ");
INSERT INTO amn_n_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Afa ne kam nalig unehlag faig afa ka ehengelim enaig unehlag faig eso ma ehengel mungo agfohiefi eso big mungo ahfeg. ");
INSERT INTO amn_n_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ka ehengelim wangohug afa ne ka i ahgohug so ma ehengel mungo nemug fi. Eso bitenai el anwanafi ne kam ningihiagim afa ne kam hugna membenag afa ehengelim gaba ne gwenaig esenig. ");
INSERT INTO amn_n_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Afa ohuna bite puguia hwainig fiahfenaba ne kam hugna membenam eso ne nalig unehlag kam faina. O Humuan, ka membeg mungwali el ne kam faig ma ka nai yi ohi agfofiba so ma kana kifutig nangui. ");
INSERT INTO amn_n_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Humuan ne lahlag nemug feg, afa bitenai el mas nem anwanafenig mo. Afa ka nem ati anwanafeg afa el ne kam faina ehengel ati anwanafig ne kam ningihiag na ka bog. ");
INSERT INTO amn_n_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ka ehengelim neana unehlag wagfunig afa nem ati ambagwa anwanafenig afa ka gwenaig afa membug so na kam fenag so ma ehengel nai yi gofi. Afa kike gaba ehengel nai yi gofif.” ");
INSERT INTO amn_n_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Afa Sisas betene wahianam heafna pahlukuiag elim wankana bu wesigim pe pafefukolina, ena bu sefig Kidron. Afa ena maligim aso ati gi eso ehe enam mina saigoahuna. ");
INSERT INTO amn_n_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Afa Judas eba moaule el anwanafena Sisas esim wanfaka fafegof. ");
INSERT INTO amn_n_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Eso amunai pris afa farisi el Godna nalig lala anwasag el mi afa mingnag ami mi ningitigi. Afa ehengel wina malwo wambinim eso Judas esim wankana. ");
INSERT INTO amn_n_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Afa Sisas ati anwanafena mungwali enag ehem pugunafe. Eso ehe hilife ika gonam ehengel nai yi eso ehengelim sahtigina og, “Nengel amanim ne yisigi ambugog?” ");
INSERT INTO amn_n_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Afa ehengel wahigi esogona og, “Sisas Nasaret wa naim ka yisigi ambugog.” Afa Sisas esog, “Ena ka ohonaba feg.” (Mauule el Judas mungwali agfofena.) ");
INSERT INTO amn_n_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Afa mahim Sisas esonaba og, “Ena ka ohonaba feg” afa ehengel amusna ahunam bite wa apaigona. ");
INSERT INTO amn_n_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Bigiagafe agfohiafenaba afa Sisas piske sahtigina og, “Nengel amanim ne yisigi ambugog?” Afa ehengel esogona og, “Sisas Nasaret wa naim.” ");
INSERT INTO amn_n_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Afa Sisas sihina og, “Kati nem sihinig na ka ohonaba. Afa ne kam kehligim ambugogba afa enag pahlukuiag el mo hwati so ma ahui.” ");
INSERT INTO amn_n_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Afa ehe ohuna mo sihig eso heafna mo eba inim puguf. Eba ehe enaig sihina og, “Mungwali el ne kam faina lahlagagofena mas aman awaiena mo.” ");
INSERT INTO amn_n_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Afa Saimon Pita naif skofanam prisni misog elni gafugag elim tigena. Ehe ehena ninganai anglugum hugufatina. Enag gafugag elni unehlag eba Malkus. ");
INSERT INTO amn_n_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Afa Sisas Pitam kifutig mo sihina og, “Naif piske geg wa fanugu! Ena kinig Humuan kam faig eba mas ka kwenai.” ");
INSERT INTO amn_n_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Afa Romna ami afa ehengelni misog el afa Ju elni anwasag el Sisasim kikehlinim wena kikenagini. ");
INSERT INTO amn_n_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Afa ehengel Sisasim Anas nangum wanigahuna. Afa Anas eba Kaiafasna kuwag. Afa ena yiana Kaiafas eba prisni misog el gofena. ");
INSERT INTO amn_n_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Enag Kaiafas Ju misog elim enaig sihifeni og, “Eba lahlafeg enag elim mungo tigibi so ma mungwali el lahla agfohie.” ");
INSERT INTO amn_n_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Pita i afa mingnag pahlukuiag el i sum Sisasim pahlukuna. Prisni misog el enag pahlukuiag elim anwanafegoni eso ehe Sisasim misog elni lalana bog megam pahlukunam saho ahuna. ");
INSERT INTO amn_n_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Afa Pitam kwenamba eso ehe afwambawa mengig muhwa gofena. Afa prisni gafugag angwafig mengig wa gofena. Afa ming pahlukuiag el piske ikana angwafigim sihinam eso Pitam sahu wanikana. ");
INSERT INTO amn_n_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Afa enag angwafig angwaming Pitam sahna og, “Atiasni ne gaba ehena pahlukuiag el si me?” Afa ehe esog, “Amo, kaba awai.” ");
INSERT INTO amn_n_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Afa nineg feskofenaba eso gafugag el i, anwasag el i suwi wehlinim noluk fiagfofnaba afa Pita gaba enanai yi agfofenaba so noluke gofena. ");
INSERT INTO amn_n_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Afa enanam prisni misog el Sisasim heafna pahlukuiag el mi afa heafna wagfuiag mo mi enam sahnagini. ");
INSERT INTO amn_n_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Afa Sisas wahigi sihina og, “Ka ohuna mo mungwali elim ambagwa sihinig. Godna nalig lala afa Ju elni nuwagig lala ka enaig eseg. Ka mas meagam gafugafeg mo. ");
INSERT INTO amn_n_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ahnaig esegba ne kam sahnageg? Aman el kana mo so higig ehengel ena mom ati anwanafig. So na ehengelim sahtigi mangim so ka sihina.” ");
INSERT INTO amn_n_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Afa mahim Sisas esonaba anwasag el mungo Sisasim asang wa pounam og, “Ne mangigim prisni misog el enaig sihifenag?” ");
INSERT INTO amn_n_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Afa Sisas ehem sahna og, “Afa kana mo mas lahlafeg hwanigba eba so na ena mo ambagwa elim sihini osa agfohie. Afa kana mo ugwe ika fegba asegba ne kam tigeg?” ");
INSERT INTO amn_n_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Afa we Sisasna ninga wa gwese gofenaba afa Anas ehem prisni misog el Kaiafas nangum ningihiana. ");
INSERT INTO amn_n_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Afa Pita mahim noluke gofenaba afa el ehem sahni og, “Atiasni ne gaba ehena pahlukuiag el si me?” Afa ehe esog, “Amo, kaba awai.” ");
INSERT INTO amn_n_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Afa prisni misog elni gafugag el mungo enanai yi gofena. Eso Pita ehena nilitem anglugum hugufafatina. Ehe Pitam sihina og, “Atiasni ka nem nangunaba neba ehe aso wa ahgofena?” ");
INSERT INTO amn_n_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Afa Pita piske sihina og, “Amo, kaba awai.” Afa ikagna kakaruk moasihina. ");
INSERT INTO amn_n_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Afa Sisasim Kaiafasna lala nai sugufinim eso Romna misog elni lala gam wanigahuna. Eba leana gubi fena eso Ju el ena lala mas saho. Afa ehe membig Pasova buyis ahgagim afa Ju elni nihe mo enaig esog Ju el nofeka afwambanai elni lalam saho. ");
INSERT INTO amn_n_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Eso Pailat afwambagam ehengelim nangum ikanam sahtigina og, “Mang ehe nem fenigbi na ne ehem sehinig?” ");
INSERT INTO amn_n_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Afa ehengel enaig sihifeni og, “Afa ehe ahanaig ahanaig eseg hwanigba ka mas ehem neana nangum wanig ambugog.” ");
INSERT INTO amn_n_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Afa Pailat sihini og, “Nimbe piske wanigahunam eso nimbiafgelni nihe mona kwefihianagi.” Afa Ju el ehem piske sihini og, “Nengelni Romna nihe mo enaig sihifeg kagel mas elim kwefihianaginim tigifati.” ");
INSERT INTO amn_n_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Afa ohuna enaig pugugba eba Sisas ati esona eso enag inim puguna. Enag mo ehe sihig ehe li katigeg wa wahaf. ");
INSERT INTO amn_n_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Afa Pailat piske sahu ikanam Sisasim awamonam eso ehem sahna og, “Ateaho neba Ju elni misog el?” ");
INSERT INTO amn_n_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Afa Sisas esona og, “Enag sahig eba nimbeafna onigig wa me awai aman el nem enaig sihifenagba na ne enaig sahig feg?” ");
INSERT INTO amn_n_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Afa Pailat sihina og, “Ka mang Ju el mo! Eba nimbeafna el i afa amunai pris i ehengel nem ka nangum wanigambugo. Eba ahanaig ne esenaba?” ");
INSERT INTO amn_n_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Afa Sisas enaig esog, “Ei kaba misog el feg afa ka mas bitenai elni misog el lofeg mo. Afa ka bitenai misog el lofeiteba eba kana gafugag el ambugog kam kifutim angoluwag gim fegoniti eso mas ka Ju elni ninga wa gofite. Afa mungwali el ka nangwaghiageg ehengel mas bitenai nihem onigi.” ");
INSERT INTO amn_n_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Afa Pailat ehem sahna, “Ei, neba misog el ehe?” Afa Sisas sihina og, “Ei, neana mo eba inim kaba misog el feg. Ka ohuna bitegam ka bogum eso ka enag gafugafegim eba inim mo sihiagim eso mia kam wanigag. Afa aman el eso inim mo mungo pahlukug enag el kana mo higig.” ");
INSERT INTO amn_n_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Afa Pailat sahna og, “Inim mo eba mang mahim?” Afa ehe piske afwambagam pugunam Ju elim nangwag ikanam esona og, “Ka nangug enag el mas mang feg mo eso ka enaig eso ehem tigi ma wahai. ");
INSERT INTO amn_n_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Afa mungo mungo Pasova buyis ofibi nengel kam fasahinif afa enanam ka kalabus el mungo nengelni ka fafhwatif. Afa enag Pasova buyis opuguba nengel membig ka sonag ‘Ju elni misog el’ nengel nai yi wahia?” ");
INSERT INTO amn_n_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Afa ehengel ehem hugna esogona og, “Amo, sonag el eba awai, so na Barabasim wahia.” (Afa eba okwefule afa elim tigifatiule el.) ");
INSERT INTO amn_n_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Afa Pailat amiim esonibi so na Sisas kikehlinim flakflakefi. ");
INSERT INTO amn_n_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Afa ami enaig esini afa we nasna wambinim molukugunim Sisasna misog wa hugohlini afa tafiglek lofug ehem fatini. Afa enag misog elni mwakwalig gau ehem enaig esenagini. ");
INSERT INTO amn_n_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Afa ehengel ehem muhwa opukonam afa mwakwalini ehem esogona og, “Sa nangu, neba Ju elni misog el.” Eso ehem kukufenagini. ");
INSERT INTO amn_n_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Afa Pailat piske afwambagam pugunam Ju elim sihini og, “Sa hig, ka ehem fahigenagegba ehe mas mang feg mo. Na ka pugu nengel nangum waniblug eso ne nangui.” ");
INSERT INTO amn_n_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Afa enag we nasig nai yi afa lofug tafiglek yi gwese Sisasna elig i agfohiafenaba eso ehe afwambagam pugu bona. Afa Pailat ehengelim sihini og, “Na ohuna elbi, so nangu.” ");
INSERT INTO amn_n_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Afa mahim amunai pris i anwasag el i ehem nangunim eso hugna esogona og, “Tigi, tigi ehem tiginim li katigeg wa fi kahli.” Afa Pailat esoni og, “Nimbe membigbi so na wanigahunam li katigeg wa so ma wahai. Afa kike fahigenagegba afa ka onigig ehe mas mang feg mo.” ");
INSERT INTO amn_n_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Afa Ju el enaig esogona og, “Ehe enaig sihifeg kaba Godna leg afa kagelni nihe mo enaig gifeg el enaig esogba so ma wahai.” ");
INSERT INTO amn_n_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Afa Pailat ena mo higinam eso ehe hugna embefena. ");
INSERT INTO amn_n_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Afa ehe piske lalagam sahukanam Sisasim sahna, “Ne ahnanai bog?” Afa Sisas mas ehem mo kwagfuwagna mo. ");
INSERT INTO amn_n_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Afa Pailat ehem sihina og, “Ahanaig eseg ne mas kam mo kwagfuwagnag mo? Sa hig, ka enaig kifutigni feg eba ka nem wahiai afa ka nem li katigeg wa kahli.” ");
INSERT INTO amn_n_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Afa Sisas ehem sihina og, “Afa God nem kifutig faig hwainig fegba eso mas ne kam pigaupi eso el kam neana ninga wa wahig enag elni amtakwalig eba neanam gosunag.” ");
INSERT INTO amn_n_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Afa Pailat ena mom higinam afa mina yisigiafena Sisasim wahiagim. Afa Ju el hugna esogona og, “Afa ne sonag el wahiaiba eso ikaf eba ne mang misog el Sisarna hihe mo. Aman el so esog kaba misog el feg enag el eba Sisarna angoluwag.” ");
INSERT INTO amn_n_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Afa Pailat ena mom higinam eso Sisasim afwambagam wanikinam kwefihiageg kug wa pegana. Afa enag lala meg eba hun simena. (Afa Hibru mona sefig Gabata.) ");
INSERT INTO amn_n_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Afa sini Pasova buyis puguf afa osu misosufgigim mahim fiahfenaba. Afa Pailat Ju elim esoni og, “Nangui nengelni misog el.” ");
INSERT INTO amn_n_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Afa ehengel hugna esogona og, “Tigi, tigi, ehem tigifati li katigeg wa kahli!” Afa Pailat sahtigina og, “Ne membig ka nengelni misog elim li katigeg wa fi kahlibi so ma wahai?” Afa amunai pris enaig kweagfuwagni og, “Sisar mungo kagelni misog el feg mingnag misog el eba awai.” ");
INSERT INTO amn_n_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Afa Pailat Sisasim ehengelni ninga wa wahiniba eso ehe li katigeg wa fi kahlini. Eso ami ehem kikehlinim. ");
INSERT INTO amn_n_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Afa ehe heafna li katigeg mahim okufehlanamba eso wanigahuna. Afa mungwali ahu ena bite wa opukona eba sefig misog kig gig bite. (Afa Hibru mona eba sefig Golgota.) ");
INSERT INTO amn_n_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Afa enanai yi ehengel Sisasim afa ming sambaganigi el mi li katigeg wa wambu kagini. Afa Sisas olyi luguna afa sambaganigi el mo meigim ahlugwagna. ");
INSERT INTO amn_n_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Afa Pailat esonibi eso li katigeg wa enaig ginofini: ");
INSERT INTO amn_n_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Sisasim so kahlini eba Jerusalem muhwa afa enag ginof eba Hibru mona afa Romna mona afa Grikni mona ginofini. ");
INSERT INTO amn_n_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Afa Ju elni amunai pris Pailatim wagnana og, “Ne magigim enaig ginofeg ‘Eba Ju elni misog el’ so na enaig ginofeite ‘Ehe enaig esog kaba Ju elni misog el’”. ");
INSERT INTO amn_n_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Afa Pailat sihina og, “Mangofi, mo so ka ginofeg ati gwenaig goh.” ");
INSERT INTO amn_n_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Afa ami Sisasim eso li katigeg wa kahlinim afa enag sambaga sambaga ami Sisasna lofug finim afa hefum mimagini. Afa ming nineg lofug fini eba mungo mas ming lofugna pahli kwalini mo. ");
INSERT INTO amn_n_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Eso ami hefum enaig esogona og, “Ese big enag lofug kukoskofif. Nawo satu enana so wagi mahim aman afafiba.” Afa ehengel enaig esigbi afa Godna mo ati gifini enag inim puguna. Enag mo enaig esog; Kana lofug hefum mimagif afa kana nineg lofug finim enana satu wagif. Eso ami enaig esini. ");
INSERT INTO amn_n_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Afa Sisasna afag, heafna sumineg, afa sambaganigi Maria ahfena, ming eba Klopasna angwag afa ming Maria Makdala wanai afa ambugonam Sisasim muhwa muhwa agfohiafena. ");
INSERT INTO amn_n_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Afa Sisas heafna afagim nangunam afa pahlukuiag el eso ehe hugna membena nangunam mahim muhwa gofenaba afa afagim esona og, “Mia sonag el eba neana leg.” ");
INSERT INTO amn_n_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Afa ehe enag pahlukuiag elim esona og, “Enag angwafig eba neana afag.” Afa enanam pahlukuiag el ehem heafna lalagam wanikinam eso enag angwafigim lahlafiafana. ");
INSERT INTO amn_n_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Afa Sisas anwanafeg heafna mungwali gafugag ati augig. Afa ehe membeg Godna mo asagi so ma enag inim pugui eso ehe enaig esog “Ka bu hefeg.” ");
INSERT INTO amn_n_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Afa miaklana bu botolna muhwa gofena eso ulefle lofug enaig finim miaklana bu wa fighinim aga wa kiknim fingi kwalig Sisasna memtog wa nihini. ");
INSERT INTO amn_n_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Afa Sisas enag bu enanam eso ehe esona og, “Eba gwenaho!” Afa ehena misog sulfu penam afa ehe ini wahafena. ");
INSERT INTO amn_n_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Afa enag osuna eba Fraide afa ming osuna eba nalig buyis puguf. Afa Ju elni amunai kusig enag osuna wahag el li katigeg wa luwanam eso ehengel Pailatim sahni og, “So na mongim tutohianugeba so ma ikagnaule pigigba eso melig mo li katigeg wanai wamb pei.” ");
INSERT INTO amn_n_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Eso ami ahunam sambaganigi elni mongim tutohianugini eso Sisasna muhwa katigini. ");
INSERT INTO amn_n_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Afa ehengel Sisasim ambugog nangunibi eba ati wahana eso mas ehena mongim tutohianagini mo. ");
INSERT INTO amn_n_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Eso ehemba enaig esini ami mungo emesigim fagna pifinaba eso taf i bu i sugfuna. ");
INSERT INTO amn_n_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Afa el enam nanguna mahim enag pugunaba eso ehe ena mo sihiageg afa heafna mo eba inim feg. Afa ehe anwanafeg heafna moba inim eso ehe enaig sihifeg so ma nengel enam olug onigigim kikehli.) ");
INSERT INTO amn_n_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Afa enag pugugba eba Godna mom yuhwafeg. Eba enaig esog, “Mas ehena mungo kigim toafui mo.” ");
INSERT INTO amn_n_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Afa ming Godna mo enaig esog, “El so fagna pifina so ma ehengel ehem enam nangwagfofi.” ");
INSERT INTO amn_n_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Afa Arimatea kimbig wa nai el Josep bonam Pailatim sahna og, “Ma ka wahiaiba Sisasna eligim ka so faku.” Afa Josep eba Sisasim pahlukuiaule afa ehe Ju elni amunaim embefenam eso ehe hefum kumwahlana. Afa Pailat ehem sawifenaba eso Josep ika fanam so fakuna. ");
INSERT INTO amn_n_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Afa Nikodemus i ehe i ahkana. Autunam Nikodemus Sisasim sinaini bo nanguna. Afa ehe 30 kilogram sanda i pauda i wambu wanmbona. Enag sanda eba sefig mer afa alos. ");
INSERT INTO amn_n_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Afa eheningi Sisasna elig ahfakunam eso sandana paudana waheg ahfenam so aitinag ahfena afa lofugna sagnag ahfena. Enag gafugag eba Ju elni nihe wahag elim enaig esafif. ");
INSERT INTO amn_n_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Sisasim eso tigi kahlini eba aso muhwa. Enanai yi yawonai hun meg gofena afa mas enag hun meg wa hug skogfufna mo. ");
INSERT INTO amn_n_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Afa enag hun meg muhwa gofena afa Ju elni auguiag osuna muhwa ofefenaba eso eheningi enanai yi Sisasim ahfaku ahfakana. ");
INSERT INTO amn_n_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Afa Sande lawam si mognam Maria Makdala nai bitekfeg nangwagim ikana afa ika nangunaba hun eso mengigim kaguni enag hun mengig wanai hilifu enmunam fakinibi mengigba pigi gofena. ");
INSERT INTO amn_n_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Afa ehe kikini ikana Pita mi afa ming pahlukuiag el mi Sisas eso ehem membena ehe ika wambanam sihini og, “El ati Ainiyagna eligbi fighug eso kagel mas anwanafig mo ahnanai yi ehe okhufakig!” ");
INSERT INTO amn_n_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Eso Pita i afa enag pahlukuiag el i biteg kifeg gam ahkana. ");
INSERT INTO amn_n_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Afa eheningi kikini ahkana eso ming el Pitam washunam gof biteg kifeg gam ika puguna. ");
INSERT INTO amn_n_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Afa ehe mas sahu kana mo ehe fisahfe penam bitekfeg gam nofenaba lofug so enana kikenagi fakini enam mungo afogwafena. ");
INSERT INTO amn_n_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Afa Pita sumi yi bonam bitekfeg gam sahu ikanam nangonaba lofug mungo afogwafena. ");
INSERT INTO amn_n_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Afa lofug Sisasna misog kikenagini enag lofug mas mungo wa afogwafena mo eba enmunam topeskesinim faki wahini. ");
INSERT INTO amn_n_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Afa enag pahlukuiag el so gof bitekfeg wa ika puguna ehe gaba so sahu ikana afa ehe nangunam eso olug onigina. ");
INSERT INTO amn_n_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Afa eheningi Godna mom mas enam numwehe anwanafena mo eso enaig sihifeg og Sisas wahanam piske bitekfeg wanai bihiaf. ");
INSERT INTO amn_n_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Afa enag sambaga pahlukuiag el piske lala gam ahkana. ");
INSERT INTO amn_n_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Afa Maria Makdala nai bitekfeg wa afwambawa gofenam ufwe gofena eso fisahfe penam nofeagena, ");
INSERT INTO amn_n_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","afa sambaganigi ofwanai elim nanguna afa ehenigina lofugba busug. Afa autunam enanai yi Sisasim fakini eso eheningi enaig esahfena ming misog gam gana afa ming mongim gana. ");
INSERT INTO amn_n_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Afa eheningi ehem ahsahna og, “Angwafig, magigim ne ufweg?” Afa ehe esona og, “El kana Ainiyagna eligim fighug eso ka mas anwanafeg mo ahnanai yi ehem ugfo fakig.” ");
INSERT INTO amn_n_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Afa ehe enaig sihif wahianam eso wahigefe Sisasim nanguna ma gofenaba. Afa ehe mas anwanafena mo ehe eba Sisas, ehe etetina. ");
INSERT INTO amn_n_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Afa Sisas ehem sahna og, “Angwafig, magigim ne ufweg? Amanim ne yisige bog?” Afa Maria onigig enag el ehe asona mog eso enaig sihifena og, “Amunai, neaho Sisasna eligim wanaiba fakug so ka sihina ahnanai yi ne ehem fakag eso ka ika fanam oku.” ");
INSERT INTO amn_n_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Afa Sisas ehem sihina og, “Maria.” Eso ehe wahigefe Sisasim nofbosug nehina afa Hibru mona sihig, “Rabonai.” (Enag mog mo eba tisa.) ");
INSERT INTO amn_n_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Afa Sisas ehem sihina og, “Ka mas Awagim piske nanguagim ikag mo eso nofena kam kehla. Amo, eba so na kana nilitem ika sihini og, “Ka kiafena Awag nangum piske aka ehe nengelni Awag eba kana God afa nengelni God.” ");
INSERT INTO amn_n_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Eso Maria Makdala nai higinam ikana pahlukuiag elim sihini og, “Kati Ainiyagim nangug” afa mungwali mo so ehe ehem sihina enag ehe sihiagena. ");
INSERT INTO amn_n_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Afa Sande osupegna pahlukuiag el lala nuwag gofena. Afa ehengel Juni misog elim embefegoni eso mengig kikisinim auguiafna. Afa Sisas ehengel nai yi olyi pugunam enaig esoni og, “Nengelni olug so ma efihlagna gofi.” ");
INSERT INTO amn_n_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Afa ehe enaig esonam eso heafna ninga i afa heafna efihlag ehengelim wagfuni. Afa pahlukuiag el Ainiyagim nangunim eso ehengel hugna sifakalini. ");
INSERT INTO amn_n_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Afa Sisas piske sihina og, “Nengelni olug so ma afafug gofi. Awag kam ningihiag eso ka gaba nengelim ningitigif.” ");
INSERT INTO amn_n_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Afa ehe enaig esonam eso ehengelim heafna fufeig faini afa sihini og, “Nengel so ma Godna Sungwag fi. ");
INSERT INTO amn_n_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Afa ne mingnag elni amtakwalig hugufafatinagba eso ehena amtakwalig awaieg. Afa ne ehem esinig hwanigba eso ehena amtakwalig gwese gonfuf.” ");
INSERT INTO amn_n_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Afa Sisas heafna pahlukuiag elim bona nangwagina afa enanam Tomas mas mungwal auguiafena mo. (Tomasna ming unehlag eba Didimus.) ");
INSERT INTO amn_n_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Eso mingnag pahlukuiag el ehem sihini og, “Kagel Ainiyagim ati nangug.” Afa Tomas ehengelim esoni og, “Eso ka heafna ninga wa nil gokug nangufe. Eso kiafena ninga bul nil gokug megam hugufenam eso kiafena ninga ehena fag gokug megam efihlag wa hugufenai. Afa ka enaig eseg hwanigba ka mas nengelni mo higini.” ");
INSERT INTO amn_n_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Afa mahim elegeg wa gohug osuna awai enaba afa mungwali pahlukuiag el lala megam auguiafena Tomas mungwali. Afa mengig ati kikisini afa Sisas olyi puguni afa esoni og, “Nengelni olug so ma efihlagef.” ");
INSERT INTO amn_n_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Afa ehe Tomasim esona og, “Kana ninga gokug nangunam afa nimbiafena ninga bul ohunanai yi hugufe. Eso nimbiafena ninga kana agmagig megam hugufe. Masa nanai yi sambaga onigig gofuf enaig mo wahianam eso ne kam olug onigina.” ");
INSERT INTO amn_n_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Afa Tomas ehem sihina og, “Neba kana Ainiyag afa kana God.” ");
INSERT INTO amn_n_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Afa Sisas ehem sihina og, “Ne kam nangugim eso ne kam olug oniginag. Afa mingnag el kam mas nangu mo eso ehengel kam olug oniginig ehengel so ma sifakali.” ");
INSERT INTO amn_n_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Afa Sisas enaksag kigmog heafna pahlukuiag elni nof wa wagfuna afa enag mo mas ohuna buk wa agfohe mo. ");
INSERT INTO amn_n_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Afa ka ohuna mo ginofeg eso ne anwanafenim Sisas eba Godna Gishu Wahiag El ehe Godna leg. Afa ehe enam olug onigini eso heafna unehlag wa so ma ne inim nofkenagag fif. ");
INSERT INTO amn_n_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Afa sumi yi Sisas Taiberius bu wa heafna pahlukuiag elim piske puguni. Eba enaig pugufena. ");
INSERT INTO amn_n_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pita afa Tomas (heafna ming unehlag eba Didimus) afa Nataniel ehe Kena wanai kimbig eba Galili provins wanai afa Sebedina sambaganigi luwal afa sambaganigi ming pahlukuiag el mungwal auguiafena. ");
INSERT INTO amn_n_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Afa Saimon Pita ehengelim enaig esoni og, “Ka sawug lagum aka.” Afa ehengel ehem esoni og, “Bigel mungwal ahuiagim.” Eso ahu bot wa augunam ahuna afa ena sinaini mas sawug mungo gaba fini mo. ");
INSERT INTO amn_n_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Afa leana gubi osu puguiagim ofefenaba Sisas bu blug yi gofena. Afa pahlukuiag el mas anwanafini mo enag el eba Sisas. ");
INSERT INTO amn_n_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Afa ehe ehengelim sahtigina og, “Oi nilite, ateaho ne sawugba wambug?” Afa ehengel wahigi sihini, “Amo, awai, kagel mas mungwag gaba fig mo.” ");
INSERT INTO amn_n_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Afa ehe ehengelim sihini, “Sa nimbiafgelni fufwala finim nihiginai ehegam fati eba ne sawug wambuf.” Eso ehengel enaig esinibi eso sawug fufwalam memtog wa puguiagenaba eso ehengel fufwalam figim kinig esniahufna. ");
INSERT INTO amn_n_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Afa enag pahlukuiag el Sisas ehem membena, ehe Pitam sihina og, “Eba Ainiyag ehe.” Afa Pita ena mo higinam ikagna nineg lofug mo piske fafatinam ogna Sisas nangum ika eso ehe bu wa penam bu sis fakaf. ");
INSERT INTO amn_n_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Afa mingnag pahlukuiag el bot wa sumi yi ambugona afa fufwala mo sawug na wambugahuna egig gam. Eba bu blug yi muhwa enaig 100 mita eso ehengel enaig esini. ");
INSERT INTO amn_n_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Afa ehengel ambugog maligim opukonam nangunibi sawugna amana suwi wa afoguafena. ");
INSERT INTO amn_n_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Afa Sisas ehengelim sihina og, “Sawug so na yawo wambug osum mingnag mo wambu.” ");
INSERT INTO amn_n_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Saimon Pita bot wa piske fukunam eso fufwala mo maligim sugfakuna. Afa fufwala megamba 153 nalig sawug mungwali fena. Eba enaksag sawug fenam afa fufwalaba mas kwafuna mo. ");
INSERT INTO amn_n_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Afa Sisas ehengelim sihina og, “Au ambugog ahga.” Ehengel ati anwanafini eba Ainiyag eso ehem mas aman sahna mo og, “Neba aman mahim?” ");
INSERT INTO amn_n_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Eso Sisas ika amba fanam eso ehengelim mimageni afa sawug gaba gwenaig eseni. ");
INSERT INTO amn_n_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Afa Sisas bitekfeg wa nai piske bihianam afa hefum oku pahlukuiag elim wagfunibi enag eba sambaga mungo nangim esena. ");
INSERT INTO amn_n_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Afa ehengel fane ahgagi wahinim eso Sisas Saimon Pitam enaig esona og, “Saimon Jonna leg, ateaho neana olug ka nai yi luwa awai me ne mingnagim gosinig?” Afa Pita wahigi esog, “Ei Ainiyag, ne ati anwanafeg ka nem membenag.” Afa Sisas sihina og, “Kana sipsip luwaligim so na fane yuwig gofum.” ");
INSERT INTO amn_n_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Afa Sisas piske sahna og, “Saimon Jonna leg, ateaho neana olug ka nai yi luwa?” Afa Pita wahigi esog, “Ei Ainiyag, ne ati anwanafeg ka nem membenag.” Afa Sisas sihina og, “Kana sipsipim so na nangwagihiage gofum.” ");
INSERT INTO amn_n_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Afa Sisas piske sahna og, “Saimon Jonna leg, ateaho ne kam membenag?” Eso Pita olug kinig fena mahim Sisas sambaga mungo nagim ehem enaig sahna fenaba og, “Ateaho ne kam membenag?” Afa Pita wahigi esog, “Ainiyag, ne mungwali ati anwanafeg. Ne ati anwanafeg ka nem membenag.” Afa Sisas sihina og, “Kana sipsip so na fane yuwig gofum. ");
INSERT INTO amn_n_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Afa ka nem inim sihinag yawana ne kwablog fiahfenaba ne numwehiage fenam nimbeafna membug wa ikafena. Afa mahim ne muhnaba ne nimbeafna ninga aitiageba eso el neana ningam wena kikenaginim eso nem wanigafuf afa ne mas membeg mo esim ikagim.” ");
INSERT INTO amn_n_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Sisas enaig sihifena eba enag mo wagfug Pita so ahanaig wahaf eso ehe Godum finig fef. Afa ehe Pitam sihina og, “So na kam pahluku!” ");
INSERT INTO amn_n_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Afa Pita wahigifenam sum nanguna enag pahlukuiag el Sisas eso ehem membenag. Ehe sum pahag wa bona. Autunam enag pahlukuiag el buyis ahgafenaba eso ehe Sisasim muhwa fenam sahna og, “Ainiyag, aman so nem angoluwag elni ninga wa wahiaf?” ");
INSERT INTO amn_n_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita ehem nangunam afa Sisasim sahna og, “Ohuna elbi so ahanaig esef?” ");
INSERT INTO amn_n_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Afa Sisas ehem sihina og, “Ka membeg sonag el so ma nofkenagag gafiba so ka piske bof. Enaba mang neana mo mo. Afa neawo so na kam pahlubu.” ");
INSERT INTO amn_n_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Afa Sisasna el ena mo higinim eso hefum sihiageni og sonag pahlukuiag el mas wahai. Afa Sisas mas enaig sihifena mo. Afa ehe ohunaig sihifena og, “Ka membeg sonag el so ma nofkenagag gafiba so ka piske bof. Enaba mang neana mo mo.” ");
INSERT INTO amn_n_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Sonag pahlukuiag el eba kike. Afa ka ena mom sihigim eso ka ginofeg. Afa mungwali anwanafig ena mo eba inim feg. ");
INSERT INTO amn_n_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Afa Sisas enaksag mingnag gafugag fiahgena. Afa el mungwali enag mom buk wa ginofigbi afa mungwali bite sigag mas gohug mo enag buk enanai yi skugum. Gweliho. ");
INSERT INTO amn_n_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","O Tiofilus, ka nem ohuna ginof ningihinag ohuna bukwaba gof ka enaig mo ginofena. Sisas yuwana ehe mungwali mang elim wagfufenig feaka ikag wahag wa pugugba God suguafag hevengam wanikig. Afa ika heafna pahlukuiag elim pugunigim eso gafugag elim mo sihiahugum gishu hwatigba Godna Sungwagni kigmog wa ena mo sihinibi og, so ma heafna gafugafeagi. ");
INSERT INTO amn_n_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Afa Sisas yuwana mo tautig fagim afa wahag, afa sumi yi mo nofkenagag fagim ika gafugag elim puguni. Sa ma enam anwanafi. Afa piske bihianam 40 osuna gafugag elim wanganamba eso nanguni. Afa Godna bog meg mo sihinugena. ");
INSERT INTO amn_n_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Enanam mahimsi wangafenaba enaig sihifeni og, “Nofeka Jerusalemba wahiyi eso nengiafafum mangim Humuan so sihi wahiag nem isug faigim yuwana so ati ka nem enam sihini. ");
INSERT INTO amn_n_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon elim buwa aitina afa yuwaba mas managei eba ne Godna Sungwagni buwa apaigofe.” ");
INSERT INTO amn_n_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Afa enanam pahlukuiag el nuwagnam afa ehem sahini og, “Ainiyag enaiba yawo gohnanam eseiba eso Israel ma piske pugu kifutigba eso bigel misog el nangwaghiagef?” ");
INSERT INTO amn_n_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Afa ehe piske sihini og, “Humuan so enag osuna gisfu hwatig, eba mas ne enam anwanafi eba ehe heafa enaigimba nangwaghiageg. ");
INSERT INTO amn_n_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Afa ma nengigim Godna Sungwag pe bonam nengelim gohoni bi eso ne kigmog finim eso ne kana moaba Jerusalem wa sihinim afa gwesim Judana mungwali bite afa distrik Samaria afa mungwali bite so ma yuhwa gohugei.” ");
INSERT INTO amn_n_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Sisas ena mo sihi wahianam mahim nangwaskafenaba eso ehe mo fuku lango megam sahonaba afa mas nanguni mo. ");
INSERT INTO amn_n_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Afa mahim fukokanaba afa ehengel mahimsi of gam nunof fiaskafnaba afa gwenanam ikagna sambaganigi ofwanai el ahwangofena afa eheningina lofugba hugna busbusiagena. ");
INSERT INTO amn_n_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Afa sambaganigi el enaig sihi ahfeni og, “Ne Galili nai el mangigim mugunim ne of gamba nunof fiaska ena Sisasba eba God ehe lahlaflag enag nem wasanig of gam fukokag eba gwenaig piske bof eso yawo ne nangugbi of gam fukokag.” ");
INSERT INTO amn_n_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Afa pahlukuiag el Oliv mug wahinim Jerusalem gam ahuna. Jerusalemba Oliv mug muhwa gifini. ");
INSERT INTO amn_n_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Afa enanai yi ahu opukonam eso lalagam mo fukwali ahuna. Enaba fukwali ahunaba eba Pita, Jon, Jems, Andru, Filip, Tomas, Bartolomyu, Matyu, Jems eba Alfiusna leg, Saimon eba Selot ehgenai el afa Judas eba Jemsna leg. ");
INSERT INTO amn_n_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Mungwali enag nuwagenam eso mungo onigig finim so betenneafufena. Afa angwafig apaiyegona afa Maria Sisasna afag fena afa Sisasna nilite apaiyegona enag mungwali nuwagenam eso esifini. ");
INSERT INTO amn_n_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Afa enanam so el Sisasim oniginibi eba ehegelni nambaba 120 enaig fena. Afa Pita olyi gohnam mo enaig sihi feni og, ");
INSERT INTO amn_n_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Ei, nilite autunam Godna sungwag Devitim esenamba eso Devit mo sihina afa ena moba Godna buk wa goh. Judasim sihinig og, sona elbi moaule el eso Sisasim angoluwagni ninga wa wahiag eso enag yuwaba pugugba eba Devit ati sihi wahiana. ");
INSERT INTO amn_n_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Afa yuwana Judasba kagel yi gofnaba afa ehe mungwalofug gafugag kafini.” ");
INSERT INTO amn_n_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Judas amtakwalig esenam eso kig fanam afa enana bitem baimena afa so negigim hefum mo ena bite wa misogna penam afa atag simbenam eso wahana. ");
INSERT INTO amn_n_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Eso sumi yi Jerusalem wa nai el mungwali enam anwanafini. Afa ena biteba heafgelni mona sefig Akeldama eba enaig esogog taf bite. ");
INSERT INTO amn_n_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Afa Pita piske sihina og, “Ohuna moba ati mwanafi buk wa gofena, enaig ginofini og; Heafna lala soma isug gofi. Ese aman enanai yi gafif. Afa ming ginof ena bukwaba enaig esog; Soma ming el ehena kug wa gohnam gafugafei. ");
INSERT INTO amn_n_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Afa nawu amanim mungo hugwefu wahiyi aman so higeg bigel nena gofena mahim Sisas Ainiyag bigim wangofenaba. ");
INSERT INTO amn_n_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Sonaig elbi ati gofena mahim Jon buwa atiag el mo sihiakag ikag mahim God Sisasim suluafagba eso bigim wasanig sisi gam fukokag. Eso big enaig elim hugwefu wahibi eba ati mungwali ahanaig ahanaigim fahigiageg soma bigim pahlanim Sisasna piske bihiag mom sihi.” ");
INSERT INTO amn_n_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Mahim Pita enaig sihifenaba, eso sambaganigi elim hugwefu hwatigini eba Josepmi Matias mi. Afa Josep ming unehlag sefinibi eba Barsabas afa Jastus. ");
INSERT INTO amn_n_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Afa ehengel enaig betenini og, “Ainiyag, ati ne mungwali elni olnigigim anwanafenig so na kam wagfuni ohuna sambaganigi elbi amanim so na hugwefu wahiag. ");
INSERT INTO amn_n_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Eso ma kanog wahiag el pugunam Judasna kugwa bo gohi Judas ati wahiagim afa ehe awaieg kimbig gam ikag.” ");
INSERT INTO amn_n_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Afa so hun aitini, ogma ateamba amana hun opugufiba eba enaho Godna mo sihiakaule elbi ogoh. Eso Matiasna hun puguna afa so Matiasim wahini eso 11 pela Aposelim pahlani. ");
INSERT INTO amn_n_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Afa mahim Pentikos buyis pugunaba enanam Ainiyagna el mungo lala nuwag gofena. ");
INSERT INTO amn_n_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Afa so auneh gweyi ikagna puguna heven wa gohnam afa bona el nuwagig lalam puguagena. Ofenaiba bifwat obo. ");
INSERT INTO amn_n_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Afa nangunibi ofenaiba suwi mileg bo kokohiagim ahu elni nihiba lasai. ");
INSERT INTO amn_n_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Afa mungwali elim Godna Sungwag bo yuhwa fenugenaba eso ahanaig ahanaig mona sihiagini. Eba Sungwag ehe esenigba enag so ahanaig ahanaig moba sihiagini. ");
INSERT INTO amn_n_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Afa mingnag Ju el Godum lotu finig afa mungwali bite so gohkafena enag ambugog Jerusalem wa gofena. ");
INSERT INTO amn_n_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Mahim enag auneh pugunaba eso el numb ambugog nuwagnam mom higahufna mahim Ainiyagna el enaig esofifnibi eso sineminefini mahim mungo mungog el ehengelni mona sihiag ofifinibi. ");
INSERT INTO amn_n_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Enag Ju el hugna sineminefini afa esogona og, “Kati anwanafig sonag elbi eba Galili wa nai, ");
INSERT INTO amn_n_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","asegba eso big mungo mungo higigbi bigelni mona mog? ");
INSERT INTO amn_n_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Eso bigel Partiana kimbig wa nai afa Midia nai afa Elam wa nai afa bigel mingnag distrik Mesopotemia wa auguia enag feg afa distrik Judia nai afa Provins Kapadosia wa nai afa Provins Pontus wa nai afa Esia nai afa. ");
INSERT INTO amn_n_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","distrik Frigia nai afa Pamfilia nai afa Isip nai el afa distrik Libia nai Sairini muhwa nai afa bigel Rom wa nai ambugog ohi gohka. ");
INSERT INTO amn_n_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Afa Ju afa minginag el Ju elni lotu nai afa Krit afa distrik Arebia nai bigel big mungwali ena mo biafgelni mungo mungo mona higig sonag elbi sihigbi eba Godna kigmogna gafugafig.” ");
INSERT INTO amn_n_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Afa mungwali olug fingi feskofenam onigigafafna. Afa hefum sihiagini og, “Sonaig pugugba yuwaba enaba mang mahim?” ");
INSERT INTO amn_n_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Afa mingnag mo enaig mo sihini og, “Ei, eba uflogna bu ahgagim enag eba mo etetiag ofi.” ");
INSERT INTO amn_n_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Eso Pita 11 pela pahlukuiag elim wan gohnam afa so hugna unetigina og, “Nengel Judia nai afa mungwali el ambugog Jerusalem gohka so kana mom higahufum eso ena mog so yawo mangwalba ne nangug ka nem ambagwa osihin. ");
INSERT INTO amn_n_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ne enaig onigig, ne og sona elbi mo etetiag ofi. Amo eba awai, eba yawo lawamhe. ");
INSERT INTO amn_n_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Afa yawo enaigba pugug enaba autunam Joel Godna mo fa sihiaule el enaig sihi wahiana og; ");
INSERT INTO amn_n_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","God ati sihig awaiyeg osuna mahim meini ofefiba eba ka kikeafna sungwagim mungwali elim ningihianif afa so nengelni fangonai luwal i afa naini luwal i kana mo fi sihiahufufe afa kwablog el itiwa lofug ahanaig ahanaigim nangogihiagig, afa muhna el itiwa panangiagif. ");
INSERT INTO amn_n_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Afa enanam ka kikeafna sungwag kikeafna gafugag kwamblo afa angwafigim ka faif eso kikeafna mo fi sihiahufuf. ");
INSERT INTO amn_n_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Eba ka eseba eso ofwa ahanaig ahanaig puguafi afa bite wa gaba puguafi eba taf i suwi i afa suwieg i enaig puguagef. ");
INSERT INTO amn_n_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Afa osu kifiakohla fegif afa was pugu tafukleg eso negigim Ainiyagna osuna mo puguf enag osunam Ainiyag heafna kigmog i afa afwambusug i wagfuf. ");
INSERT INTO amn_n_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Afa enanam mungwali amangel so Ainiyagim uninif og, ma kam kwagani, afa so ehe wambuf eso ehengel wangineg augufef. “Enaba Joel Godna mo fa elni mo sihi wahiag. ");
INSERT INTO amn_n_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ne Israel el numwehe kana mo higini ka nem osihin Sisas Nasaret wa nai el, nem ne anwanafini God ati ehena ninga wa kifutigbi nem wagfunig. God ehem enaig esenagba nem og soma anwanafi heafa ehehe ena elbi ningihiagba eso bog. ");
INSERT INTO amn_n_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Afa sona elbi God nengelni ninga wa wahiag afa autunam ati oniginam ena moba kikisei wahiana enaig esegim. Afa amtakwalig afwambanai el i nengel i ne li katigeg wa kokufenagigbi eso wahag. ");
INSERT INTO amn_n_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","God mas ena tautigba gwesim wahiana mo, eba God sona elbi bite kifenai ilafofatig mas ehem gwesim wahag mo. ");
INSERT INTO amn_n_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Afa autunam Devit gaba enaig sihifena og; Ka Ainiyagim nangug kam bog higeg muhwa fenag eso ka mas mangwalimba embefenai. ");
INSERT INTO amn_n_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Enaig fenaba enag so kana olug lahlag nemug go eso ka sifakal mo eseg, afa ka nengego eligim lahlagim eso God membeg kam esenagim. ");
INSERT INTO amn_n_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Eba mas ne kam elim pigieg kimbig wa wahiai, afa neana lahlag gafugag elbi so na mas ehem wahiaiba eso mas bitewaba nogi. ");
INSERT INTO amn_n_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ati ne kam wagfunag nofkikena fag minagagba so na ka i ahgofiba ka so hugna sifakale. “Ena moba Devit sihi wahiag. ");
INSERT INTO amn_n_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ei nilite, ka nem biafgelni simbianigam osihin, Devit ati wahag afa fakinibi afa ehena bitekfe eba gweseg bigelnai yi olyi yuwanaba go. ");
INSERT INTO amn_n_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Afa Devit eba Godna mo fa sihiule el feg ehe ati anwanafeg God ini mo sihig og, nengigim ka neana mungo luwalim esenaba eso ehe nimbe lofug misog el gofe. ");
INSERT INTO amn_n_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Enaig esena Devit gof ati anwanafena eso enaig sihifena og God Kraisim wahag wa nai ilafo wasuhof eso ehe mas bitekfe wa gwesim nogig mo. ");
INSERT INTO amn_n_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Afa sonag el Sisas eba God ati ehem bitekfenai ilafofatigba eso ehe nofkikenaga. Afa enam ati ka nofna nanguig. ");
INSERT INTO amn_n_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Afa Sisas ati sisyi fukokag Godna nihiginai ninga wa ga. Autunam Awag ehem sihi wahiana heafna Sungwag pe bof. Afa ehe ati enam ningihiagba eso yuwaba ne enam nangug afa higig. ");
INSERT INTO amn_n_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Devitba mas Sisas so esena hevengam fukokana enaig esena mo. Afa Devit enaig esona, og; God ati kana Ainiyagim enaig sihifena, og, ne kana nihiginai ninga wa gafif. ");
INSERT INTO amn_n_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Eba yuhwafef ka angoluwag elim neana ninga wa hwatiba so ma nem ahnai skaugfini. ");
INSERT INTO amn_n_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Eso Israel nai el mungwali ne numwehe nam anwanafi Sisasba nengel tigigim li katigeg wa kahligbi God ati ehem gishu wahiana og so ma Ainiyag fenam eso elim wambu.” ");
INSERT INTO amn_n_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Afa mahim mungwali el ena mom higinibi eso enag mo ehengelni olugim fingi feskofena eso ehengel Pita mi afa mingnag kanog hwatieg el mi sahigoni og, “Nilite, ahanaig so ka esif?” ");
INSERT INTO amn_n_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Afa so Pita sihini og, “Nengel so mungo mungo mungwali olug wahigifinim Sisas Kraisna unehlag wa bu wa apaigoiba so ma God nengelni amtakwalig nihem fa fatini ma ne enaig esibi eba God nem heafna Sungwag faif. ");
INSERT INTO amn_n_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","God ati autunam sihi wahiana Sungwag nem faigimba, afa nengelni luwal i afa wahigwanai el i gwenaig esenif. Afa God bigelni Ainiyag mungwali elim ehe awamonigim gaba ati sihi wahiana.” ");
INSERT INTO amn_n_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Afa Pita mingnag enaksag mo sihinugenam afa kifutig mo faini og, “Numwehifibi masa nem amtakwalig el nahgum awaief.” ");
INSERT INTO amn_n_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pita mo sihinaba eso el numb olug oniginim eso buwa mo apaigona afa mingnag ambugog pahsihianaba ehengelni nambaba 3,000 enaig fena. ");
INSERT INTO amn_n_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ehengel kanog hwatieg elni mom ati ugwe higini eso hefum fakwegfu feagini afa ambugog mungo wa nuwagnam fane ahgafna afa betennifini. ");
INSERT INTO amn_n_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Afa God kanog hwatieg elni ninga wa ahanaig ahanaig kigmog esenibi eso mungwali enam nangunim afa sineminefeagini. ");
INSERT INTO amn_n_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Afa mungwali el Sisasim olug oniginim mungo mo hefum sihiaginim afa heafgelni mang mang eba mungwali ehengelni fena. ");
INSERT INTO amn_n_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Afa ehengel heafgelni bite i gawig i elim wahiagonifinibi eso enanam kig fifnim eso heafgelnaim elim gawig awaiyegim mimagegonfini. ");
INSERT INTO amn_n_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Afa mungwali osuna Godna nalig lala nuwagenam afa mungo mungo lala nuwagenam fane ahgageahufna afa ehengel lahlafiaginim sifakaligna auguna. ");
INSERT INTO amn_n_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Afa higeg Godna unehlagim fingifini eso el ehengelim olug lahlag gohnigbi. Eso Ainiyag mungwali osuna mingnagim wambfenaba eso ehengel Sisasim oniginig gwesim numb el fiagena. ");
INSERT INTO amn_n_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Mungo osuna Pita i Jon i beten ahfegim osu efihlagna Godna nalig lala ahkana. ");
INSERT INTO amn_n_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Afa enanaba mingnag el mong kikwaligni ati obuguafena higeg gwenaig eseahufna, obugufenam Godna nalig lala mengig muhwa washu wahifini enag mengigba enaig sefi fini og, lahlag mengig afa enag elbi mahim el ahu ena mengig wa sahogoafnaba moni kamini feni aufna. Afa ehena mongug so kikwalignaba eba afag wesigi gwenaig wanigana. ");
INSERT INTO amn_n_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Afa enag elbi mahim Pita i Jon i ahkana mengig wa hopugufnaba eso nangwagnam kamininu og kam mang ahfai. ");
INSERT INTO amn_n_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Afa Pita i Jon i hugna ahnangwagohun afa Pita enaig esona og, “Osum kam nangwag.” ");
INSERT INTO amn_n_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Afa so nangwagaufena, ehe enaig onigina og, eba kam mang ahfaif. ");
INSERT INTO amn_n_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Afa so Pita enaig sihi fena og, “Kaningi kigba awai afa mang so ka ahfeg eba ka nem ahfaigim. Sisas Nasaret wa nai elni unehlagwa nem kog so bihianam ika.” ");
INSERT INTO amn_n_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Afa so ehena nihiginai ningam kikehlanam fukwa wasunaba eso bihia gohna ehena mong kikwalig gweyi ikagna kifutigna. ");
INSERT INTO amn_n_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Afa ehe efguafukoahfe gohnam eso Pita mi Jon mi Godna Nalig lala gam pahlu ika sahuna. Afa ehe sahonam efguafuko feakafnaba so Godna unehlagim gufifukona. ");
INSERT INTO amn_n_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Eso mungwali el nangunim mahim ikafenaba afa Godna unehlagim fingi fukwiafnaba. ");
INSERT INTO amn_n_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Afa so anwanafinim eso gona og, “Ei, sona elbi higeg Godna Nalig lala ‘Lahlag mengigwa’ sahwag wa fawofegofnaba kig kamini fafegof.” Afa nangunim mahim lahlafenaba eso ehengelni olug fingi feskofena. ");
INSERT INTO amn_n_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","El ena mom higni mahim enaig pugunaba eso sineminefinim kikini ambugoguhna enag elim nangugim. Afa ambugog nanguinibi ehe ati Pita mi Jon mi kiketiginam gofna. Enam pugunamba eba Godna Nalig lala, afwambag sime wa enaba sefig og, Solomonna afwambag sime. ");
INSERT INTO amn_n_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita nangwaghiagenam enaig sihifeni og, “Nengel Israel el ahanaig esegba so na sineminefig mahim enaig pugugba, ahanaig esegba so na kam hugunam nangwagsiga masa ne enaig onigigfif eba kaningina kifutig me amo kaningi afsug kabag el me eso sohnagba esahfeg. Amo eba awai. ");
INSERT INTO amn_n_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Eba Abraham Aisak Jekopna God afa ehe bigelni simbianigana God. Afa ehe heafna gafugag elim Sisasim nalig unehlag faig. Afa enag elim ho ne angoluwagna ninga wa wahini. Afa mahim Pailat og, na wahia afa nengel ne ehem masig fatinim afa ne esogona, ne og Pailat nofena isug wahia. ");
INSERT INTO amn_n_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Afa ehe afsug kabag el fegim afa lahlag nihe mungwali feakafna. Afa ne ehem masig fatinim eso ne esogna og Pailat amanim so wahiaf enaig el eba kwaskog elim so wahia. ");
INSERT INTO amn_n_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Afa elbi eba nofkikenagag minam pigieg eba enag elim ne tigifatigbi eso God ehem piske bitekfenai ilafofatig. Enam ka nofna ahnangugum naso ka ena mo ahsihig. ");
INSERT INTO amn_n_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ka Sisasna unehlagim olug ohoniginaba eso sonag el mong kikwaligniba so yuhwafeg. Afa sonag yawo so na nangug eba so na anwanafi eba Sisasna kifutigni eseg. Afa kaningi Sisasim olug ohoniginaba eso nengelni nof wa sonag elbi ati yuhwafeg. ");
INSERT INTO amn_n_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Nilite inim ati ka anwanafeg nengel i afa nimbeafigelni misog el i mas ne numwehe anwanafini mo naso ne Sisasim enaig nihe fenagini. ");
INSERT INTO amn_n_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Afa autunam God mo fa sihiaule el nai yi megig wa sihi wahiana og, eba heafna Gishu wahiag el tautig fafe. Noso yuwaba ne enaig esefigbi. Eso enag esegba Godna mom ati inim pugug. ");
INSERT INTO amn_n_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Eso nimbeafgelni amtakwalig nihe mo masig fatinim afa wahigifinim Godum oniginibi eso ma God nengelni amtakwalig nihe mo fa fatini. ");
INSERT INTO amn_n_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Afa ateamba ne enaig esigbi eso ne Ainiyag nai yi ambugog muhwa agfohianam eba so na wangine auguf. Sisas eba Godna Gishu wahiag el afa God ehem ati kanog wahiana afa ehem so ningihiaiba so ma ehe bonam nengel enanam gofuf. ");
INSERT INTO amn_n_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Afa enag yuwaba heven wa gahba nengego enag osuna God so eso wahiag mahim eseiba, eso mungwali gawig lahlag piske pugu gohfe. Autunam ati ehe Godna mo fi sihiaule elni mengig wa sihi wahiana ehe enaig gafugafegim. ");
INSERT INTO amn_n_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Autunam nengelni amunai el Moses enaig esona og, ‘God nengelni Ainiyag, eba God ehe nengel nai yi mungo el gisfu wahiaf eso pugu mo fi sihiaule el lofef kike lofug. Eso ne ehena mungwali mom higinim pahluguf. ");
INSERT INTO amn_n_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Afa aman sonag elni mom higi hwanigba eba God ehem kwagi aitifeba eso ehe mas Israel enanam agfofi.’ ");
INSERT INTO amn_n_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Autunai Godna mo fi sihiaule el Godna mo ati sihiahufna Samuel nai yi pugunam ikan mungwali sumi nai Godna mo fi sihiaule el nai yi pugug, ena mo sihinibi yawo sati pugug. ");
INSERT INTO amn_n_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","God Abrahamim enaig sihifena og, ‘Nana simbianigag nai yi pugunam eba mungwali bitenai elim lahlag fenugef.’ Afa nengelbi Godna mo fi sihiahug simbianigag luwalig eso mangim so sihi wahig eba enam ne fif. ");
INSERT INTO amn_n_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Eso God heafna gafugag elim nem gof ningihianig ogma nem kwaganiba eso nengel mungwali amtakwalig nihem hwatibi eso enaba nem lahlafenig.” ");
INSERT INTO amn_n_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Enanam Pita i Jon i mahimsi mo elim ahsihiagofnaba afa Pris el i afa Sadyusi el i afa Godna nalig lala nai polisni misog el i ambugog opukona. ");
INSERT INTO amn_n_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Afa opukonam eheningina mo higafofna. Eheningi ena mo ahsihina og, “Sisas ati wahagim piske bihiag eso el gaba gwenaig esif.” Afa ehegel higinim mas ena mom membini mo. ");
INSERT INTO amn_n_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Eso sikikofefenaba enaignam kiketiginim kalabus lala hwatiginibi ikana lawamfena. ");
INSERT INTO amn_n_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Afa el numb ena mom higinim olug onigig wa kikehlinim pahlukuna. Eso enaig esinibi eba 5,000 wa gohna. ");
INSERT INTO amn_n_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Afa lawam opukonam Ju misog el i, amunai el i afa nihe mo wagfuiag el i Jerusalem gam nuwagigna. ");
INSERT INTO amn_n_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anas eba pris misog el bona afa Kaiafas na, Jon na, Aleksander na afa mingnag mungo muswuna apaigona. ");
INSERT INTO amn_n_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Eso Pita mi Jon mi wanambugo olyi wasanim so sahigoni og, “Ahnaig esegba so na elimbi wangene feiti ahfeg? Mang kigmogna afa aman na unehlag wa ne so ahfeg?” ");
INSERT INTO amn_n_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Afa Godna Sungwag Pitam ati yuhwafenagenaba eso mo sihina og, “Amunai el i afa elni misog el i sahig. ");
INSERT INTO amn_n_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Yawo ne kam sahigoni mang lahlag so ka esahfeg. Ati aman ne membig anwana ofifibi eso sona el mong kikwalni lahlafegba eba aseg, ");
INSERT INTO amn_n_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Nengel i afa mungwali Israel wanai el i so anwanafi. Eba Sisas Nasaret wanai elni unehlag i afa heafna kigmog i sona elbi ati wangenefego. Eba Krais Godna Gishu Wahiag Elim ne tigifatigba afa God ehem piske bitekfem ilafo fatig. ");
INSERT INTO amn_n_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Autunam Godna ginof Sisasim sihi wahiana, enaig esona og; Sohna sumilba nengel lala nimbagig el isugum fi fatig, eba naho God esenagba eso sumilba gohug. ");
INSERT INTO amn_n_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","God mas ming elim gishu wahiag mo elim piske wambugum, eba awai. Sisas mungo he bigna minaba go eso big Godna el agfohieg.” ");
INSERT INTO amn_n_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pita i Jon i hugna kifuti ahgofenaba eso amunai el nangwaginim sineminefini og, “Hai, sona elbi isug el ahfena afa eheningi mas skul yi ahkana mo.” Afa ehegel anwanafini, ati eheningi Sisas nai yi ahgofena. ");
INSERT INTO amn_n_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Afa nangunibi el mong kikwaligni ati wangenefena afa so Pita mi Jon mi wangofena eso ehegel mwahlai agfohiafna. ");
INSERT INTO amn_n_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Eso amunai el eheningim sihigoni og, “Afwambawa ma puguia ahgofiba”. Eso hefum mo sihinagini. ");
INSERT INTO amn_n_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Afa esogona, “Ahnaig so big esogonif? Mungwali Jerusalem wanai el ati anwanafig eheningi hugna kifutig gafuga ahfeg eso big mas sihi ohonaba mas pugu mo. ");
INSERT INTO amn_n_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Afa mas so ena mom minganag kimbig sihiageahufuf. Nawo kifutig mo sihigon ma enaig esahfe, ese, Sisas na unehlagim elim mo ahsihinif.” ");
INSERT INTO amn_n_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Afa so awamogonim afa kwegoni ne mas elim ahsihinim afa ahwagfuni ena unehlagimba. ");
INSERT INTO amn_n_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Afa so Pita i Jon i wahigi ahsihini og, “Neaga nimbe kwefihiagi mang mahim Godna nof wa lahlafeg, ka nengelni mo ahpahluku me awai Godna mo ahpahluku me. ");
INSERT INTO amn_n_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Afa mas ka mwahlai ahgofi. Eso ati ka ahnanagug afa ahigig eba ka ahsihiagofuf.” ");
INSERT INTO amn_n_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Afa misog el sambaganigim hugna kifutig mo piske sihigonim eso wasani opuko ahuna. Ahnaig esegon mo eba mungwali el mas misog el i mungo onigig fini mo. Afa God elim mong amtakwaligna wangenefe fatinaba eso mungwali el Godna unehlagim fingi fini. ");
INSERT INTO amn_n_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Enag elbi wangenefenaba eba 40 yia fegim so gwese hilifeg. ");
INSERT INTO amn_n_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Enanam Pita mi Jon mi wasanibi eso heafa piske ehef luwal nangum ahkana. Eso ahsihina mang so amunai pris i afa amunai el i eheningim esogoni. ");
INSERT INTO amn_n_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Afa higinim eso mungo onigig finim so Godum sahini og, “Ainiyag, nem ne of i, bite i, bu i afa mungwali gawig gohka enaig ne gafugafeg. Afa ati ne anwanafeg ena mo misog el kagelim faig. ");
INSERT INTO amn_n_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Enaig eseg ena mo Godna Sungwag kagelni simbianiga Devitim faina. Devit neana gafugag el autunam sihi wahiag; Ahnaig esegba eso afwambanai elbi kakageahu, afa hefum augugum nuwagnam eso mina tohlagi onawo Godum pigau apaigo, afa enaig mas puguna mo. ");
INSERT INTO amn_n_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Afa bite nai misog el fag wa numwehiagofi. Afa amunai el nuwagigim ogna Ainiyag mi afa God Gishu Wahiag El mi eso hagim. ");
INSERT INTO amn_n_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Eso gwenaig esef Herot i Pontius Pailat ambugonam ena kimbig wa afwambanai el nai yi i, Israel el nai yi i nuwagnam eso mina tohlaginim eso neana gafugag elim Sisasim pigau apaigofe. Sohna elbi nem ati gishug wahiana eso elim piske wambf. ");
INSERT INTO amn_n_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Afa ehegel nuwagigim enaig eseagofibi eba ati autunam ne sihi wahiana so puguf. Eso gwenaig esig nimbiafna sawieg mi afa kifutig mi pahluhug. ");
INSERT INTO amn_n_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Eso Ainiyag sahig ehegel kam fegonigig. Sa kam yawo mo kifutinibi eso kigmonim neana mo sihiahufufe. ");
INSERT INTO amn_n_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Afa so nimbiafna kifutig yi ningitigiba so ma gih elim lahlafetifif afa ahanaig ahanaig kigmog wagfuiagi, nimbiafna Sisas afsug gafugag elni unehlag wa.” ");
INSERT INTO amn_n_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Mahim enai betenni wahinibi eso kugo gwena lala puguna. Gwena elim mungwali Godna Sungwag simbagahlanibi eso mas mo sihigim embefini mo eba sihiageahuna. ");
INSERT INTO amn_n_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Mungwali el nuwagigim Sisasim olug onigi eba mungwamo sihini. Mas aman mungo hefum enaig esoi ohonaba kana mungohe eba awai, heafna gawigba eba mungwali elni feni. ");
INSERT INTO amn_n_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Afa kanog hwatieg el Ainiyag Sisasna waha bihiag mo sihinibi eba nalig kifutig ni sihini. Afa God elim lahlag auguiag faig. ");
INSERT INTO amn_n_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Afa aman mas gawig hwainig gohna mo, afa aman bite i lala i fegba ehe minganag elim faigbi eso enanam kig fag. Afa ehena kigba fagim eso obugum ");
INSERT INTO amn_n_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","kanog hwatieg elni ninga wa fakag afa so ehegel figim, minganag elim so gawig hwainig enam mimange gonigig. ");
INSERT INTO amn_n_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Afa gwenaig Josep esena. Livai eba heafna simbianiga afa ehe Saiprus wanai el. Kanog hwatieg el ehem sefini, Barnabas. Ena unehlag mogba eba ‘kwagfwag el’. ");
INSERT INTO amn_n_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Afa ehe elim heafna bite faig afa nana kig fagim eso obugum kanog hwatieg elni ninga wa fakag. ");
INSERT INTO amn_n_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Afa el unehlagba Ananaias afa heafna angwagba Safaira eso ehe heafningina ming ehegenai bite mingnag elim faini eso enanam kig fana. ");
INSERT INTO amn_n_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Eso mingnag kig mo hefum sugonam afa mingnag mo kanog hwatieg elim faini. Afa angwag enam ati anwanafena. ");
INSERT INTO amn_n_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Eso Pita ehem sihina og, “Ananaias, mangigim ne Satanim pahluku afa ne Godna Sungwagim mo ne mwakwalenag afa mingnag kig mo ne sugo wahiag. ");
INSERT INTO amn_n_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Afa ena bite eba neana eso enana so na kig fag, kigba eba neana. Afa mangigim ne amtakwalig niheba eseg? Enaig so na eseg eba elim ne mwakwale mo eba Godum ne esenag.” ");
INSERT INTO amn_n_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Afa Ananaias enag mo higinam eso waha pena afa mingnag ena mom higinim eso hugna embefini. ");
INSERT INTO amn_n_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Afa kwamblog el ambugog saigonam meligim saginim eso okufehlinim ugfo fakini. ");
INSERT INTO amn_n_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Afa sambaga mungo aua enaig fenaba eso angwag mas anwanafena mo so saigohu bona. ");
INSERT INTO amn_n_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Afa Pita ehem sahna og, “Kam sihina, kigba gohnaho eso nimbeafna bite enanam so na ahfag?” Afa angwafig enaig esona og, “Inim gwenaho.” ");
INSERT INTO amn_n_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pita ehem esona, “Nenigi nimbeafna ligag i mangigim ne Ainiyagim ahgihna afa el so neana ligagim so fakig eba ati ambugog mengig wa agfohie ogna nem gaba figahu.” ");
INSERT INTO amn_n_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Afa ikana enag angwafig Pitana mong yi waha pena. Afa kwamblog el saho ambugonam so nanguni mahim waha gifnibi eso fi opukonam ahunam ligagna yi muhwa fakini. ");
INSERT INTO amn_n_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Afa mungwali sios wa nai el afa mungwali minginag el enam mo higinim hugna embefini. ");
INSERT INTO amn_n_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Afa kanog hwatieg el ahanaig ahanaig enaksag kigmog olyi el nai yi eseagini. Mungwali Ainiyagna el Solomonna afwambag sime wa nuwag gofena. ");
INSERT INTO amn_n_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Afa el embefinim eso mas ambugona nuwagigna mo. Afa mungwali el ehegelim og eba lahlag el fig. ");
INSERT INTO amn_n_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Afa mingnag kwamblo i angwafig i Ainiyagim so olug onigini eba nubiagena. Eso enag el ambugonam ehegel enanam pasihiana. ");
INSERT INTO amn_n_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Eso el gih elim ahanaig ahanaig sime wa wambinam afa so mina wa wasani. Afa ehengel og mahim Pita obofiba so ma ehena sungwag ika gih elim puguahuafenaiba so ma lahlafi. ");
INSERT INTO amn_n_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Afa el numb muhwa kimbig wa nai Jerusalem gam ambugona. Eso gih el mi afa mwaifig simbagahlag el mi eso wanambugonaba eso enag mungwali el lahlag feskofena. ");
INSERT INTO amn_n_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Afa misog pris i afa heafna hihe i eba Sadyusi el kanog hwatieg elim ambugof ahwagoni. ");
INSERT INTO amn_n_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Eso opukonam kanog hwatieg elim kikegonigim wambugu eso kalabus yi wasani mungwali amtakwalig el nahgum. ");
INSERT INTO amn_n_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Afa sinaini Ainiyagna ofwanai el bonam mengig pigina eso afwambagam wankanam afa esonag. ");
INSERT INTO amn_n_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ahunam Godna nalig lala wa agfohienam eso mungwali elim sihigoni enag mulug nofkenagag mom.” ");
INSERT INTO amn_n_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Afa kanog hwatieg el enag mo higinim eso lawam gubi Godna nalig lala gam ahuna. Eso elim ena nai yi mo sihigoni. Afa misog pris afa heafna hihe ambugonam eso kaunsel mi afa Juni amunai el mi unegoni eso ambugona nuwagigna. Afa ningitigini kalabus lala gam ogma ahunam kanog hwatieg elim kalabus lala nai wanambugoi. ");
INSERT INTO amn_n_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Eso polis kalabus lala gam ahuna afa mas kanog hwatieg elim nangwagini mo. Afa piske ahunam esogona og. ");
INSERT INTO amn_n_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Mahim kangel ahu kalabus lala opukogba, mengigba kikisei gofena afa anwasag el ati mengig wa agfofna. Mahim kangel mengig pigi nangugbi mas aman ena nai yi gafna mo.” ");
INSERT INTO amn_n_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Afa amunai pris i afa Godna nalig lala nai anwasag elni misog el i enag mo higinim afa hugunam onignagini, afa esogona, mang so puguf? ");
INSERT INTO amn_n_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Afa el mungo pugunam afa sihini og, “Sa hig, enag el so na kalabus lala aitig ehengel ati Godna nalig lala wa agfoba elim mo osihigon.” ");
INSERT INTO amn_n_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Afa so anwasag elni misog el i afa heafna el i ehengelim ahu wambinim afa mas kifutigni esegoni mo. Afa embefinim esogona og masa bigim el hun na tatugonif. ");
INSERT INTO amn_n_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Afa polis kanog hwatieg elim wanambugonam kaunselna nof wa wasani. Afa misog pris sihigoni og, ");
INSERT INTO amn_n_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Ka nem kifutigni esogonug nofena ohnagna unehlagwaba mo sihi, mangigim ne enaigba esig! Ne ati nimbiafna mo mungwali Jerusalem wa sihig afa ne membig og kangel naho Sisasimba isug tigifatig eso ne kagelim ahwanifi faig.” ");
INSERT INTO amn_n_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pita i afa mingnag kanog hwatieg el i wahigi esogona og, “Kagel so ka Godna mom mungo pahluku masa nengelni mo kagelim kwenig feg eso ka mas Godna mom pahlukui! ");
INSERT INTO amn_n_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nengel ati Sisasim li yi kukufinagigim afa ehem tigi kahligbi eso wahag, afa God bigelni simbiangana ehe ati piske ilafogba eso bihiag. ");
INSERT INTO amn_n_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","God ati wanikigim afa heafna nihigenai ninga wa washu wahiag. Afa God ehem enaig esenagba eso ehe amunai fegim afa ehe elim piske wambug el feg. Eba enaig eseg eso ma Israel el olug wahigifibi eso ehe ehengelni amtakwaligim hugufatinif. ");
INSERT INTO amn_n_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Afa kagel enam nangug God ehe eseg afa kagel so ena mom sihig. Afa Godna Sungwag gaba gwenaig eseg. Afa amangel so Godna mom pahluhug eso God heafna Sungwag ehengelim faig.” ");
INSERT INTO amn_n_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Afa kaunsil enag mo higinim afa olug kakag feskofenam afa ogna kanog hwatieg elim kwagi aiti. ");
INSERT INTO amn_n_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Afa mungo kaunsil bihiagohnam eba Farisi el feg heafna unehlagba Gamaliel. Eba nihe mo anwana el fena afa mungwali el heafna unehlagimba fingi fini. Afa ehe elim sihini og kanog hwatieg elim afwambagam mwakwalig wanahu. ");
INSERT INTO amn_n_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Mahim afwambagam ahunamba eso Gamaliel minginag kaunsilim sihini og, “Nengel Israel el afa ne mangwalba esofegonifiba eso numwehe oniginim. ");
INSERT INTO amn_n_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nengel anwanafig autunam Teudas pugu gohnam esona og, kaba lahlag nemug el feg afa 400 el ehem pahlukuna. Afa mahim ehem tigi wahagba afa el ehem pahluhug eso embem ahuaminafeg. Eso heafna gafugagba awaiena. ");
INSERT INTO amn_n_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Afa enanam Judas Galili wa nai el pugunam enag osunaba gavman elni unehlag wambofna. Ehe elni onigigim fuku wasanig. Afa mahim ehem gaba wahagba eso el ehem pahlukuna enag embem ahuaminefena. ");
INSERT INTO amn_n_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Afa enaig esegba naka nengelim osihini, nofeka ahanaig esegon. Nangwag hwati ma auguiafi. Afa ateamba enag gafugag so elni onigig wa pugug eba awaiyef. ");
INSERT INTO amn_n_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Afa ateamba enag gafugag Godna bof eba nengel mas kwegoni eba masa nimbefum God i askotigif fafe.” Eso kaunsil Gamalielna onigigim pahlukuna. ");
INSERT INTO amn_n_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Afa kaunsil kanog hwatieg elim unegonim ma ambugonaba eso heafgelni gafugag elim mo sihini eso ne ehengelim kwagatif. Afa kifutig mo sihigoni og nofena Sisasna unehlag waba moba sihiahu eso hwatinim ahuna. ");
INSERT INTO amn_n_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Afa kanog hwatieg el kaunsilim wahinim ahufefnamba Godum sifakalini eso God ehengelim onigini ehengel eba ma enaig esife eso ehengelim hwatigba eso ehengel Sisasna unehlag wa ahwanfeg fi. ");
INSERT INTO amn_n_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Afa mungwali osuna Godna nalig lala wa afa elni lala ahugum eso elim wagfugonig afa enag gafugagba mas awai eba higeg sihiahufuf Sisasna moba. Ehengel enaig sihififni og Sisas eba enag el ati God sihi wahiana eso ningihiaiba eso bonam bigim piske wambuf. ");
INSERT INTO amn_n_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Afa gwenanam pahlukuiag el numb opukona. Afa pahlukuiag el so Grikna mengna lagig enag agfonam ninimugona minginag pahlukuiag elim eso Hibru mengna lagig afa esogona og, “Nengel Hibru el nimbeafgelni elim kwagani eso fanem awaienig afa nengel mas kangelni Grik elni bulwag angwafigim kwagani eso ligag ati pigig.” ");
INSERT INTO amn_n_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Afa enag esenaba 12 pela kanog hwatieg elim unegonim mungwali pahlukuiag el ambugona afa sihigoni og, “Afa kangel fane mimagegonug eso enag kagelim Godna mo sihiagim kufapahlanif enaig eba mas lahlafeg mo. ");
INSERT INTO amn_n_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nilite so na enaig esi, nengel eso 7 pela elim yisigi olyi nengel nai yi so agfo. Eso ehengel eba lahlag el afa Godna Sungwagni yuhwafigim afa lahlag onigignafug. Eso big enag elim faigo soma enag gafugagim nangwaghiagi. ");
INSERT INTO amn_n_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Kangel ehe ka enaig gafugafif higeg betennifinim afa Godna mo sihiahufufe.” ");
INSERT INTO amn_n_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Afa mungwali el ena mom membig. Afa Stivenim gishu wahini ehe hugunam olug onigig el fena afa Godna Sungwag ehem yuhwafenagena. Afa minginag elim gishu fatini eba Filip afa Prokorus afa Nikanor afa Timon afa Pamenas afa Nikolas. Nikolas ehe Antiok el. Autunam ehe afwambanai el fena eso bonam Ju el nai yi sahu gohna. ");
INSERT INTO amn_n_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Afa so kanog hwatieg elni nof wa wanambugonaba eso kanog hwatieg el ehengelim ninga misog wa fakagonim afa so betennegoni. ");
INSERT INTO amn_n_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Eso Godna mo ikaminefenaba afa Jerusalem wa nai pahluhug el gwesim numbiagena. Afa enaksag pris olug wahigifinim pahlukuna. ");
INSERT INTO amn_n_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Afa God Stivenim kweagfunam afa kifutig fainaba. Eso Stiven ahanaig ahanaig kifutig kigmog elim wagfunigena. ");
INSERT INTO amn_n_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Afa minginag el bigiagafenam Stivenim mo fafaiye fini. Enag elbi mungo Ju elni lotu wa nai. Enag lotu sefig ‘isug elni’. Afa enag el eba Sairini nai afa Aleksandria nai afa provins Silisia nai afa Esia nai. Enag ambugog minafenam eso Stiven i mo fiflafeagini. ");
INSERT INTO amn_n_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Afa Godna Sungwag Stivenim lahlag onigig fainaba eso el mas ehem mo flafuni mo. ");
INSERT INTO amn_n_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Afa ehengel minginag elim sisag mona esogoni og, “So na mwakwal mo sihi ka higig Stiven amtakwalig mo Moses mi afa God mi faig”. ");
INSERT INTO amn_n_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Afa enaig mo el mi afa amunai el mi afa nihe anwana el mi olugim fingi feskofenaba. Eso Stivenim kikehlinim kaunsil nangum wanigambugona. ");
INSERT INTO amn_n_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Afa minginag elim wanambugonam eso ehengelim mwakwal mo faigona afa enaig esogona og, “Sonag el eba higeg Godna nalig lala mi afa heafna nihe mi moalamp fafenif. ");
INSERT INTO amn_n_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Afa ka higig ehe enaig sihifeg og, Sisas Nasaret nai Godna nalig lalam bufanam afa nihem wahigifef eso autunam Moses bigim faini.” ");
INSERT INTO amn_n_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Afa mungwali kaunsil so Stivenim nofna fefini afa nangunibi heafna nofbosugba pukogofena ofenaiba of wa nai elni nofbosug mungwalofug enaig fena. ");
INSERT INTO amn_n_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Afa prisni misog el Stivenim sahna og, “Ohuna moba inim ho?” ");
INSERT INTO amn_n_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stiven esona og, “Nilite afa humuani nengel so kana mom higim. Autunam bigelni simbianiga Abraham mahim Haran wa ika hwainig fiahfenaba, afa God heven wanai ehem Mesopotemia wa pugunam ");
INSERT INTO amn_n_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","afa ehem esona og, ‘Nimbeafena humoanig, hihe afa kimbig mo wahianam eso ika eba ka nem bite wagfunaf.’ ");
INSERT INTO amn_n_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Eso ehe heafna Kaldia kimbig wahianam eso ikanam Haran wa gafena. Mahim heafna awagim wahanaba God ehem ningihiana. Eso ikana ena bite wa gana eso nengel ena nai yi auguia. ");
INSERT INTO amn_n_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","God mas bite wesig Abrahamim fainam mo. Afa God ehem esona og ka ehem fai eso enagba heafna afa heafna simbianigagim. Enanam God ehem enaig esona Abrahamba luwal hwainig fiakafenaba. ");
INSERT INTO amn_n_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","God Abrahamim enaig sihifena og, ‘Nana simbianigaba ahunam angoluwag elni bite wa auguiafiba afa so ehengelim 400 yia wa amtakwal hiagibi eso ehengel ehengelni isug gafugag el feasaif. ");
INSERT INTO amn_n_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Afa enaig elbi eba ka kike tautig mungwag faif afa bitena luwalba Isipim wahinim ambugog ohuna nai yi kana unehlagim fingi fif.’ ");
INSERT INTO amn_n_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Afa God esona og ma Abraham so ma heafna lofugum kwafui enaba enaig wagfufeg God ati ehe sihiag ahfe ahwahianaba eso gwenaig esena. Abraham, Aisakna awag fenam eso Aisakna lofugum kwafunai mahim ika 8 enaig osuna pugunaba eso Abraham enaig esenagena. Afa Aisakba Jekopna awag fena eso Jekopim gwenaig esena. Afa Jekop bigelni 12 pela simbianigana awag fena afa ehe ehengelim gwenaig esenugena. ");
INSERT INTO amn_n_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Afa ena simbianigaba heafgelni suminegim Josepim ambobugini amtakwal oniginaginim angoluwag el nai yi ningihinibi ikanam angoluwag wa isug gafugag el fena afa enag el etegim kig faigonim eso suluflinim Isip gim wanigahuna afa enanai yiba God ehe ahgofna. ");
INSERT INTO amn_n_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Afa God ehem kweagfunamba eso heafna kinigim filifatina. Afa so ehena lahlag onigig i afa anwanafeg i eso Isipni misog el Fero ehem membenam afa so ehem wahianaba eso Isipni amunai fenam afa so Ferona gawig i lala i nangwaghiage gofna. ");
INSERT INTO amn_n_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Afa autunam Isip bite yi afa Kenan bite yi fane awaienaba enanam bini nalig mungwali elim pugunugenaba afa so ehengel mahim nalig kinig fini afa bigelni simbianigam gaba gwenaig eseni. ");
INSERT INTO amn_n_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Afa Jekop ati higina og Isip yi fane eyi go afa so heafna luwaligim bigelni simbianigam ningitiginaba ehengel ahu Isip yi opukonam afa piske ambugog opukona. ");
INSERT INTO amn_n_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Afa ming enana piske ahunaba eso Josep heafna nilitem hefum ambagwa wagfuni afa so Isipni misog el gaba ehena nilitem anwanafeni. ");
INSERT INTO amn_n_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Afa so Josep heafna awagim mo ningihianaba og so ma Jekop Isip gim wanboi. Mungwali el enanai ambugog eba 75 enaig fena. ");
INSERT INTO amn_n_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Afa Jekop Isip yi ahu augunam so wahana afa bigelni simbianiga gaba gwenanai yi pigig. ");
INSERT INTO amn_n_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Afa ehengelni elig mo wambughunam Sekem bite wa suguni. Ena bitekfeba autunam Abraham Hamorna luwaligna ninga nai baimini wahiana. ");
INSERT INTO amn_n_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Afa autunam God so Abrahamim sihi wahiana bite faigim ena ati puguiagim meinofe, afa so Isip kimbig enanai yi bigelni simbianiga enaksag puguagena. ");
INSERT INTO amn_n_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Afa so enanai yi sumi yi el mungo Isipni misog el fena. Afa ehe Josepim mas anwanafena mo. ");
INSERT INTO amn_n_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Afa ehe bigelni simbianigam mwakwale hiagenam afa amtakwale hiagenam afa hekusihiagena ogma ninganai luwalim taitufibi so ma pigi. ");
INSERT INTO amn_n_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Afa enanam Mosesna afag ehem waniginamba afa ena luwal hugna lahlafeagena. Afa sambaga mungo was yi afahmonigbi lalaba wanigafana. ");
INSERT INTO amn_n_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Afa so nengigim mo finim afwambagam fatiniba afa so misog elni leg naini ango bo hefum fokwaku wahna. ");
INSERT INTO amn_n_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Afa Mosesim Isipni mungwali anwanagim wagfufenagenaba afa so ehena mo lagig lahlafena afa gafugag gaba gwenaig fena. ");
INSERT INTO amn_n_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Afa mahim Moses 40 yia enaig fenaba afa ehe ogna ika heafna hihem nangwagim. ");
INSERT INTO amn_n_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Afa ehe ika nangunaba Isip nai luwal Israel luwalim ismunagim otigekafnaba afa so ehe Israel elim kweagfonam eso Isip nai luwalim tigifatina. ");
INSERT INTO amn_n_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Afa ehe enaig onigifena heafna hihe ma anwanafi afa so God ehem gishug wahiag so ehengelim kwagan fe. Afa ehengel mas enam onigini mo. ");
INSERT INTO amn_n_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Afa ming osuna Moses piske ika nangwagnaba Israel el hefum bigag ohofefena afa ogna eheningim kwenim og, ‘Ei, mangigim na nembefumba bigag ohofe, eba ne nilitena ahfeg.’ ");
INSERT INTO amn_n_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Afa el so ming elim otigekafna enag el wahigif Mosesim esona og, ‘Aman nem sihinagba so na kangelni amunai el fegim na kam kwefihiagnug ofe? ");
INSERT INTO amn_n_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Afa neaga kam ogna tigifati eso ati ne amu Isip yi nai elim tigifatig?’ ");
INSERT INTO amn_n_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Afa Moses ena mom higinam ehe embem Midian bite gam ikana. Enanai yi ika ehengel enanam ganam ehe angwafig fanam luwalba sambaga fangonai ahfena. ");
INSERT INTO amn_n_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Afa mahim 40 yia ikanaba of wanai el bo Mosesim suwi wa puguna. Enaba Sainai mug muhwa namba el hwainig wa Moses nangunaba suwi wesig li figeg wa lagofena. ");
INSERT INTO amn_n_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Afa ehe nangunam afa sineminefenam eso bo muhwa pugunaba afa enanai yi Ainiyag sihinagofena og, ");
INSERT INTO amn_n_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Kaba neana simbianigana Abraham, Aisak, Jekopna God feg.’ Afa Moses embe i kiafigigi fiagenam esim nunofegim kusina. ");
INSERT INTO amn_n_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Afa Ainiyag ehem sihina og, ‘Ohnaba biteba eba afsug feg kable eyi ga afa so na nimbiafena su mo sulfu sko. ");
INSERT INTO amn_n_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Afa ka kikeafna elim nangwagigba kinig figagfo afa ka ehengelni wewatin higinig na ka bog koka ehem kwaganiba so ma kinig mo wahinim ahui. Ka nem onigihiaba so na Isip gim ika.’ ");
INSERT INTO amn_n_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Afa Israel el Mosesim masig fatinim esogona og, ‘Aman nem sihinagba so na kangelni amunai el fegim na kam kwefihiagnug ofe?’ Eba God ehe Mosesim ningihianaba amunai el fenam eso Israel elim wambina eba of wanai el so wesig li figeg wa suwi lagofena enag Mosesna ningam kifutignaba eso enaig gafuga mo fena. ");
INSERT INTO amn_n_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Afa Moses Isip yi Godna kifutig wagfunim eso Israel elim Isip yi nai pugu wankana afa ika ming kifutig Ret Si yi wagfuni afa ehe ika 40 yia wa el hwainig wa wanganam enanai yiba ehe ahanaig ahanaig Godna kigmogim wagfuiagena. ");
INSERT INTO amn_n_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Afa Moses eba sonag el Israel elim sihini og, ‘Eba Godna mo fi sihiaule elim God nem ningihianif. Eba ehe nengel nai yi olyi gofuf eba kable lofug fef.’ ");
INSERT INTO amn_n_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Afa Moses fena Israel el fini el hwainig wa auguiafenaba. Afa ehe bigelni simbianiga afa ofwanai el Sainai mug wa ehem mo sihina ena nai yi wangafenaba. Afa ehe nofkikenageg mo fainaba eso ena mo bigim faig. ");
INSERT INTO amn_n_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Afa bigelni simbianiga ehena mom mas higini mo eso ehem masig fatinim ogna piske Isip gim ahu. ");
INSERT INTO amn_n_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Afa ehengel Aronim sihini og, ‘Moses bigim Isip yi nai wanbogim hwatig mug gam fukokagba afa mas big ehem yuwaba nangug mo eba mang mahim fenag.” Enaiba nawo Aronum sihinibi so ma bimbeafgelni godum nifehiagenam gafuga fiageba so ma bigim gosini.’ ");
INSERT INTO amn_n_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Afa so bulmakau luwaligna sungwagim gafugafenaba eso ehengel heafgelni gawig wambug ambugonam bulmakau luwaligna sungwagim wambwainibi eba sohnagba ehe ningana esinim fena enam fingi finim so buyisini. ");
INSERT INTO amn_n_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Afa mahim ehengel enaig esinibi so God ehem hwatinaba eso ehengel osuna, wasni, bagnufutni lotu fegoni. Enaba enaig eseg Godna mo fi sihiule el ati Godna buk wa ena mo ginofi wahini; Afa nengel Israel ne 40 yia wa el hwainig wa augunam ne mas kam sis tigi faini mo. Eba awai. ");
INSERT INTO amn_n_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Afa ne mwakwal god Molekna sel lala kufihlig oghug afa ne mwakwal god Refana bagnofutna sungwagim ne gwenaig esinig afa ne enam ningana esigim afa ne lotu fenigbi eba ka nem ningitigiba ahu Babilon opukona gwesim wahigwa yi ahunam angoluwag enanam auguiafuf. ");
INSERT INTO amn_n_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Afa mahim bigelni simbianiga el hwainig wa auguiafenaba afa ehe Godna sel lalam kikehli ogfafena. God ehe Mosesim ena sel lala nimbig mina wagfunaba eso ehengel gwenaig esini. ");
INSERT INTO amn_n_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Afa sumi yi eso ehengelni luwal ena sel lalam finim oghunaba afa so God ehe gosunam angoluwag elim mo wambu ningitigi fiakafnaba afa so Josua ena sel lalaba fa wan okuna bite figim. Enag sel lalaba gwese gofuf ikan Devit nai yi puguf. ");
INSERT INTO amn_n_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Afa God ehe Devitim membenaba eso Devit Godum esona og so kam wahiaiba ka so neana lala nimbaiba so ma Jekopna God enanai yi gafi. ");
INSERT INTO amn_n_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Afa ena lalaba Devit mas nimbana mo eba heafna leg Solomon ena lalaba nimbana. ");
INSERT INTO amn_n_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Afa God sisyi nai nemug feg ehe mas el nimbig lalaba gofi. Afa Godna mo fi sihiaule el enaig sihiba fe wahiana og; ");
INSERT INTO amn_n_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","God enaig sihifeg hevenba eba ka enanai yi gaba nangwagehiagego afa ohuna biteba eba mong eyi ka pafeg oguia. Afa ahanaig lala so na kam nimbanaf? Eba mangig wa ne nimba mo. Afa ahnanai yi so ka gaf? ");
INSERT INTO amn_n_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Afa eba kikehe ka mungwali gawigba gafuga fiageg.” ");
INSERT INTO amn_n_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Afa ena moba Stiven mahimsi gwese kaunsilim sihin gofna og, “Nengel mo filafilaule. Afa nengelni olug i angug i ofenaiba afwambanai el lofug ne esiahu. Afa ne nimbiafgelni simbianiga lofig ne Godna Sungwagim kwinig. ");
INSERT INTO amn_n_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Afa nengelni simbianiga mungwali Godna mo fi sihiule elim amtakwali hiagini. Afa enaig el so sihini og, ‘Godna afsug nemug el bof’ eso ehengel enaig elim kwaskofig. Afa yawo gaba ne ehem masig fatinigim afa ne ehem tigifatig. ");
INSERT INTO amn_n_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Afa of wanai el ati nem Godna nihe moba faigbi afa ne enam filafig.” ");
INSERT INTO amn_n_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Afa ehengel Stivenna mom higinim afa so olug kakaginim gog moag hilhileaginim guana ningam tigiagini. ");
INSERT INTO amn_n_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Afa Stiven ehe Godna Sungwagni fenam kifutig guhunam eso sisi gam hevenim nangwagofenaba eso Godna lahlag afwambusugug gofena enag afwambusugug yiba Sisas Godna nihiginai ninga bihia gam gofena. ");
INSERT INTO amn_n_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Afa Stiven sihini og, “Sa hig, ka nangogba heven pigig gohba afa so Inim El Godna nihiginai ninga gam bihia goh.” ");
INSERT INTO amn_n_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Afa ehengel heafgelni angugum ningana pupuhiaginim afa hugna gonkun nagini. Afa ikagna efihia ambugonam Stivenim wahigi fakana. ");
INSERT INTO amn_n_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Afa so ambugog ehem kikehlinim hugufihu kimbig wa afwambagam fatinim eso hun na tigekini. Afa ehe heafgelni kwiyeg lofug mo sulfu skuniba eso kwamblog el mungo Sol so ena lofugumba kuklu wambugufena. ");
INSERT INTO amn_n_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Afa mahim hunna otigikifinibi afa so Stiven enaig esona og, “Ainiyag Sisas nimbe kana sungwag mo fana.” ");
INSERT INTO amn_n_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Afa ehe mongkokini kwakwagenam hugna enaig esona og, “Ainiyag nofeka mungwagba enaig esen.” Ehe enaig esonam eso hefum mo wahana. ");
INSERT INTO amn_n_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Sol mungwamo sihini Stivenim tigigim. Afa Godna lahlag el Stivenim fakinim afa hugna wewatinaufena. Enag osuna nalig kinig Jerusalem wanai sios elim puguni. Afa mungwali el mo Judia Samaria kimbig gam ahkau minefenaba. Afa kanog hwatieg el mo gweyi auguiafena. ");
INSERT INTO amn_n_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Afa Sol mo ogna sios elim amtakwale fati. Eso ikafenam mungo mungo elni lala sahufenam Godna kwamblo mi angwafig mi sulfu wambfenam kalabus yi wankafena. ");
INSERT INTO amn_n_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Afa el so ahunam gwesim minganag kimbig gam Godna mo sihiageahuna. ");
INSERT INTO amn_n_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip Samaria nai kimbig gam ikanam Krais, Godna Gishu Wahiag Elni mo sihini. ");
INSERT INTO amn_n_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Afa el numb higahufenaba afa onigigem ahufena afa ehena kifutigim nanguni. ");
INSERT INTO amn_n_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Afa eso enaig esena nimbasa famoasiwatunam enaksag elni nihinai sugfuhia apukoahuna. Afa el numb elig lihligna el mi afa mong lihligna el mi lahla fiahsaiana. ");
INSERT INTO amn_n_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Eso enag kimbig wanai hugna sifakalini. ");
INSERT INTO amn_n_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Afa Samaria wanai el mungo, Saimon, ehe fagseg wambug el afa ahanaig ahanaig kigmog fiahageakafule el feg. Afa mungwali Samaria wanai el nangunim sineminefini. Afa enag ehe heafna unehlam fingi fukuna og, hei kikehe. ");
INSERT INTO amn_n_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Amunai el i afa isug el i ena mo higinim eso esogona og, “Inim, sona elbi ena god sefig ‘Eba Nalig Kifutig’”. ");
INSERT INTO amn_n_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Afa el ahanaig ahanaig kigmogim higeg fanangu figfohunam afa enam sineminefinim eso ehena mo pahlukuna. ");
INSERT INTO amn_n_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Afa mahim Filip Godna bog meg lahlag mo afa Sisas Kraisna unehlag sihinaba eso el higinim afa olug onigigna finim eso kwamblo i angwafig i bu wa apaigona. ");
INSERT INTO amn_n_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimon gaba Filipna mo olug onigigna fanam eso buwa pena. Afa so ehe Filip nai yi muhwa gofenam nangwafena mahim Filip ahanaig ahanaig Godna kigmogim wagfuiafenaba eso enam nangunam sineminefena. ");
INSERT INTO amn_n_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Afa kanog hwatieg el Jerusalem wa higinim mahim Samaria wanai el Godna mo finibi eso Pita mi Jon mi esim ningitigini. ");
INSERT INTO amn_n_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Afa ika ahpugunam beten ahfini afa amangel el so olug onigi so ma Godna Sungwag fi. ");
INSERT INTO amn_n_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ahanaig esenaba Godna Sungwag mas ehegelim pe boni mo. Enag elbi Sisas Ainiyagna unehlag wa buwa apaigona. ");
INSERT INTO amn_n_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Eso Pita i Jon i ninga sisyi misog wa askonibi eso ehegel Godna Sungwag fini. ");
INSERT INTO amn_n_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Afa Saimon nangwagnam mahim sambaganigi kanog hwatieg el ninga askonabi eso ehegel Sungwag fini. Eso Saimon ogna kig fainim og, ");
INSERT INTO amn_n_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Sa ma kam kifutig ahfai ka so kangaba amanim ninga fakaiba so ma Godna Sungwag fai.” ");
INSERT INTO amn_n_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Afa Pita esona og, “Sa ma nem kig nangum awaiye eso ne onigig ne oka kig fatinam eso Godna mang lahlag fa. ");
INSERT INTO amn_n_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Enaig olug mas Godna nof wa yuhwafeg mo eso ne mas kagelni gafuga wa seahui. ");
INSERT INTO amn_n_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Eso ne enaig onigig wahianam Godum sihinaiba eso ma neana enaig onigigim fa fatinai. ");
INSERT INTO amn_n_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ka ati anwanafeg neana olug yi eba ambo bughiageg afa nimbiafena amtakwalig nihe nem kehlagu.” ");
INSERT INTO amn_n_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Afa Saimon wahigi sihini og, “Ainiyagim ahsahanaiba so ma kam afafenai eso ne kam sihinag enaig mas so kam pugunafe.” ");
INSERT INTO amn_n_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Afa Pita i Jon i Ainiyagna mo afa mang God eso esena ena mo ahsihinam eso Jerusalem gam piske ahkana. Afa Samaria enaksag kimbig ahakafenaba ena Godna mo ahsihiakana. ");
INSERT INTO amn_n_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Afa Ainiyagna ofwanai el bo Filipim enaig sihifena og, “Buihianam bite bihig mina ika. Ena minaba Jerusalem wahiagim eso Gasa gam ikag.” ");
INSERT INTO amn_n_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Eso ehe ikana. Afa ikafenaba Itiopia wanai elim mina wa ufana. Enag elbi Itiopia misog angwafig Kandasina gafugag el. Ehe ehena kigim nangwaghiage gofena. Enag elbi Jerusalem gam ikanam eso Godum fingi fena. ");
INSERT INTO amn_n_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Eso ehe piske akafna heafna kimbig gam. Afa ehe hosna masig yi sime wa gafenaba Aisaia Godna mo fa sihiaule elni ginof suwigaufna. ");
INSERT INTO amn_n_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Afa Godna Sungwag Filipim enaig sihifena og, “Ika muhwa masig yi sime wa ikafum.” ");
INSERT INTO amn_n_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Eso Filip kikini ika muhwa pugunam afa so higina mahim el Aisaiana ginof osuwigfena. Afa Filip sahna og, “Enag ginofba ateaho ne anwanafeg?” ");
INSERT INTO amn_n_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Afa el sihina og, “Ahnaig anwana kafef, mas ka aman wagfunai.” Afa Filipim sihina og, “Au fuko bo na ohunanai yi ahagag.” ");
INSERT INTO amn_n_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Enag ginof ehe suwignaba enaig esona og; Ehe mengig pwakafenam mwahlai gofena gwenaig sipsip lofug mahim el wanig ahufeiba tigigim o lag higfinim ofibi ehe mas eyuoyi. ");
INSERT INTO amn_n_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Afa ehem ahwanfeg mo hwaini afa mas ehem numwehe kwefihianagini mo. Afa el enag elim tigigba eso wahag eso eheba luwalig hwainig. ");
INSERT INTO amn_n_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Afa enag el Filipim sahna og, “Sa kam sihina, Godna mo fa sihiaule el hefum esog me awai ming elim me?” ");
INSERT INTO amn_n_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Eso Filip ena mo mog wa fa fakanam eso gwesim Sisasna lahlag mo sihiakana. ");
INSERT INTO amn_n_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Afa mina wa ahkan ika buwa pugunam afa ena misog el sihina og, “Buba ahuigi. Mang kam bu wa pegimba kagfugu.” ");
INSERT INTO amn_n_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Afa amunai heafna gafugag elim sihina hosna sime kikeahla. Mahim sime gofenaba afa ahpenam bu gam ahkana eso Filip Itiopia nai misog elim bu wa fatina. ");
INSERT INTO amn_n_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Afa mahim bu wanai pugu ahbonaba eso ikagna Godna Sungwag Filipim suguafa wanikana, afa sona el mas piske nanguna mo eso ehe mo mina gam ikafenaba sifakalena. ");
INSERT INTO amn_n_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Afa ikagna Filip Asdot kimbig wa gohfena. Afa ikafenaba Sisasna lahlag mo sihiakan kan Sisaria wa puguna. ");
INSERT INTO amn_n_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","2","Enanam Sol wagofna ogna Ainiyagna pahlukuiag elim kwakskofe. Ogna Damaskus wa nuwagig lala ika amangel angwafig i kwamblo i Sisasna el fiahsaieg enam sulufunam eso Jerusalem gam wankanam kalabus lala aiti. Afa ehe enaig onigifenam eso misog prisim sahna og ma kam nihe mo pepa faibi ka so enaig ese. ");
INSERT INTO amn_n_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Afa mahim Sol Damaskus kimbig muhwa pugunaba eso ikagna of wanai nalig afwambusug bo molugkugo fakana. ");
INSERT INTO amn_n_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Afa so ehe bite wa pena gifinibi afa higina mo gweyi ehem sihina og, “Sol, Sol, asegba nana kam amtakwaleafag?” ");
INSERT INTO amn_n_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sol esona og, “Amunai, neba aman?” Afa esona og, “Kaho Sisas ena elim so nokawo amtakwaleafla. ");
INSERT INTO amn_n_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Sa bihianam ika na ne kimbig wa puguiba eso ma el nem sihinai mang so na fef.” ");
INSERT INTO amn_n_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Afa Sol minganagim wanikanam eso ehegel moagim higinim afa mas nanguni mo eso mwahlai agfohiafena. ");
INSERT INTO amn_n_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol bihianam nofug mo bahinam afa ninofi fegim mo sikikeagena. Eso ningana kikehlinim Damaskus gam wanig ahuna. ");
INSERT INTO amn_n_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Afa sambaga mungo osuna ehe gwenaig gafena eso ehe fane i bu i mas nena mo. ");
INSERT INTO amn_n_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Afa Damaskus kimbig wa pahlukuiag el mungo gafena eba Ananaias. Afa ehe nangunaba itiwa lofug Ainiyag unena og, “Ananaias”. Eso ehe esona og, “Ainiyag, ho ka ga”. ");
INSERT INTO amn_n_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Afa Ainiyag ehem sihina og, “Pugu mina gam Judasna lalam ika ena mina sefig ‘Misosufgoh’. Afa so sahin el mungo Tarsus wanaim ehena unehlagba Sol. Ehe beteneau. ");
INSERT INTO amn_n_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Afa Sol nangunaba itiwa lofug el mungo bona ehena unehlagba Ananaias. Ena elbi mahim ningana tuhwiba eso ehe piske ninofi fiahgena.” ");
INSERT INTO amn_n_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Afa Ananaias sihina og, “Ainiyag, ati ka enaksag mo higigeg sona elbi neana elim Jerusalem kimbig ahanaig ahanaig fenugiahka. ");
INSERT INTO amn_n_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Afa ehe nihe mo pepa misog prisni ninganai ohunanai yi fambui pugug. Ogna kike wambku amangel so neana unehlag fingi fig.” ");
INSERT INTO amn_n_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Eso Ainiyag ehem sihina og, “Eseka, ati ka kanog wahiag enag elbi kana mo lagig el. Eso ehe kana unehlagim afwambanai elim, misog elim, afa Israel elim ogfunugef. ");
INSERT INTO amn_n_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Eba ka ehem wagfunaf eso mungwali tautig fafe mahim kana gafugag ofekafiba.” ");
INSERT INTO amn_n_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Afa Ananaias ikanam lala sahunam eso ningana Solna misog wa fakanam og, “Sol nilite, eso ne mina wa obofnaba Sisas Ainiyag nem puguna. Enag kam ningihiag og so ma nem nofug wangenefei afa so Godna Sungwag nem bo simblahlai gufi.” ");
INSERT INTO amn_n_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Afa ikagna gweyi Solna nofug wanai sawugna kisigig lofug hugofu penaba eso ehe piske ninofihiagenam eso bu wa pena. ");
INSERT INTO amn_n_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Afa so ehe fane neagena afa ehena lofug piske kifutigna. Afa Sol mwakwalig Damaskus wa pahlukuiag elim wanana. ");
INSERT INTO amn_n_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Gwenana ehe nuwagig lala ikafnam eso mo sihiafna og, “Sisasba Godna Leg.” ");
INSERT INTO amn_n_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ehengel higinim sineminefinim hefum sihiagahfewagfena afa og, “Atiahog, sona Pol eseaka eso Jerusalem wa elim Sisasna unehlag fingi fig ehe amtanafehiagena? Afa ohunanai yi bog elim wambugum piske amunai pris nangum wambku.” ");
INSERT INTO amn_n_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Afa ehena mo pugu hugna kifutinagena eso Juna elim wagfuni Sisas eba Gishu Wahiag El God ningihiag elim wambugum. Afa Ju el Damaskus wanai higinim onignageni eso mas ehem mo ahanaig esuni mo. ");
INSERT INTO amn_n_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Afa mwakwal managenaba eso Ju el nuwagnam ogna mina yisgiaginim eso Solim tigifati. ");
INSERT INTO amn_n_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Afa higeg osu i sinaini i kimbig mengig wa anwasafegofena ogna so ehem tigi. Eso Sol ena mom higinam ehe mas mengig gam pugu ikana mo. ");
INSERT INTO amn_n_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Afa Solna pahlukuiag el sinaini ambugonam wanigahunam Solim sobi yi fatinim eso kimbig bog meg megam wena kikehlinim fi afwambagam fatini. ");
INSERT INTO amn_n_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Afa Sol ika Jerusalem pugunam Sisasna pahlukuiag elim nangwagnam eso ogna gwenaig gafugafi. Afa ehegel enaig onigini og ehe Sisasna mwakwal el ofe eso mungwali embefeagini. ");
INSERT INTO amn_n_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Afa Barnabas kweagfunam eso kanog hwatieg el nangum wanikina. Afa sihini so Sol Ainiyagim mina wa nangunaba afa Ainiyag ehem sihina. Afa ehe Damaskus kimbig ikanam ehe mas embefena mo Ainiyagna mom kifutig mo sihina. ");
INSERT INTO amn_n_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Eso Sol mungwal auguiafena afa Jerusalem wa Ainiyagna mom kifutig mo sihiageakana. ");
INSERT INTO amn_n_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Sol Ju elim Grikna mo sihiagim wan flafihiagena eso ogna Solim tigifati. ");
INSERT INTO amn_n_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Afa nilite mahim enam anwanafinim eso Sisaria gam apaigo wanigahunam afa ugfo Tarsus gam ningihini. ");
INSERT INTO amn_n_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Afa enanam Judia nai, Galili nai, afa Samaria nai sios lahlag augufena. Afa Godna Sungwag siosim kwaganam afa kifutihiagena eso el numb pugunam so Ainiyagim ahnai skaugfini. ");
INSERT INTO amn_n_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita enaksag kimbig wagiakan ikana Lida nai Godna elim nangwagena. ");
INSERT INTO amn_n_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Enanai yi elim mungo nanguna eba Ainias. Enag elbi kig lihlifenagena afa 8 pela yia ehe kug wa gwese gifini. ");
INSERT INTO amn_n_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Afa Pita sihina og, “Ainias, Sisas Krais nem ati wangenefe fatig, so bihianam kug mumwan enam eso faku.” Eso ikagna Ainias bihiana. ");
INSERT INTO amn_n_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Afa enaksag Lida nai Saron nai el nangunim eso Ainiyagim olug onigig faini. ");
INSERT INTO amn_n_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Afa angwafig mungo Jopa wa gofena, heafna unehlagba Tabita. Eba Grikna mo ehem sefig Dorkas. Ehe Sisasna pahlukuiag el lahlag gafugafefenam afa gawig hwainig elim kwefoafna. ");
INSERT INTO amn_n_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Afa enanam ehem gihenam eso wahana. Afa so meligim bu wa sugfunaginim figagfo sisyi lala megam faki wahini. ");
INSERT INTO amn_n_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jopaba Lida muhwa. Afa pahlukuiag el higinim mahim Pita Lida wa gafenaba eso sambaganigi ningitigina ehem ahnangonam hugna sohona og, “Hei, so ikagna bo.” ");
INSERT INTO amn_n_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Eso Pita pahag ika pugunam afa sisyi lala megam fukwali wanigahuna. Afa mungwali esig bulwag angwafig bigiagafenam Pitam wahigifakanam wewatoni. Afa ahanaig ahanaig lofug so Dorkas nofkena gafenaba kwelugefenam mimagen fini enam Pitam wagfuni. ");
INSERT INTO amn_n_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pita afwambagam ningitiginam eso mongkokini kwakwagenam so Godum sahna. Ehe wahigi meligim nangunam eso sona og, “Tabita so bihia.” Eso ehena nofug bahia Pitam nangunam bihiana. ");
INSERT INTO amn_n_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita ehena ningam kikehlanam fokwa wasona. Afa Pita Godna el mi afa esig bulwag angwafig mi une tiginam wagfunim og Dorkasba ati piske bihiag. ");
INSERT INTO amn_n_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Afa so ena mo Jopa nai el mungwali higiginim eso el numb Ainiyagim olug onigig faini. ");
INSERT INTO amn_n_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Afa Pita mwakwalig Jopa wa Saimonna ahagana. Afa Saimon eba bulmakauna lofug gafugafeule. ");
INSERT INTO amn_n_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Afa Sisaria kimbig wa mungo afwambanai el Kornilius enaig gafugafeg eba 100 Romna soldia elim nangwaghiawagig. Ena soldiaba sefig Itali soldia. ");
INSERT INTO amn_n_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Sohna afwambanai elbi heafna angwafig ni luwal na Godum ahnai skaug wanfegim eso Godna unehlagim fingi wanafeg. Afa enaksag Ju elim gawig hwainigim ehe kwaganig, eba Godum sahanaule. ");
INSERT INTO amn_n_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Mungunagim osu efihlagna ehe itiwa lofug nangonamba eso Godna ofwanai el bo ehem sihina og, “Kornilius”. ");
INSERT INTO amn_n_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Afa ehe nangunam embefena og, “Amunai, mang mahim?” Afa ofwanai el wahigi sihina og, “God ati neana sahanagim higig afa so na gawig hwainig elim kwaganig enaba ati anwanafegim eso onigina go. ");
INSERT INTO amn_n_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Eso elim Jopa gam ningitigiba so ahu Saimonim wanig ambugog afa ming unehlagba Pita. ");
INSERT INTO amn_n_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Eba ming Saimon ehe bulmakauna lofug gafugafeule el i ahagag. Ehena lalaba nalig bu muhwa go.” ");
INSERT INTO amn_n_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Afa mahim ofwanai el ikanaba Kornilius sambaga gafugag el mi afa mungo soldia el fena enam awamoni. Ena soldiaba lahlag el Godum ahnai skaufena. ");
INSERT INTO amn_n_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Afa ehegelim sihini so ofwanai el ehem ahanaig mo sihinagena eso Jopa gam ningitigina. ");
INSERT INTO amn_n_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Askanam so ka osu misosuf gigni Jopa muhwa opukogum ofefenaba afa Pita lala sisi gam fukokanam betenena. ");
INSERT INTO amn_n_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Mahim biniwahanaba ehe ogna fane ne afa mahim fane numwehiagifinibi. Enanam itiwa lofug nanguna. ");
INSERT INTO amn_n_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Afa ehe nangonamba of piginam nalig lofug sambaga sambaga angsambona enaig pe bona. ");
INSERT INTO amn_n_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Enanai yiba ahanaig ahanaig sis i wutwai i afa twafig i saho agfogoafna. ");
INSERT INTO amn_n_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Afa Pita higinamba God ehem sihinagofna og, “Pita bihianam sisba sohnaba so kwagnefe.” ");
INSERT INTO amn_n_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Afa Pita esona og, “Ainiyag, amo yo ka mas ese. Ka mas ena kwegig sisba neafna mo.” ");
INSERT INTO amn_n_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Afa God ehem piske sihina og, “Mang so God sihig eba lahlag eso nofeka enam oniginam kwegim.” ");
INSERT INTO amn_n_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Sambaga mungo nagim gwenaig esenam eso lofug piske of gam fukokana. ");
INSERT INTO amn_n_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Afa Pita enam nangunam hugna onigeaufna. Enam elim Kornilius ningitiginaba eso lalam yisgi ahuian mengig wa agfohiafna. ");
INSERT INTO amn_n_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ehengel une sahini og, “Saimon afa ming unehlag sefig Pita ohiahogo?” ");
INSERT INTO amn_n_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita mahim ena itiwa lofug nanguna enam onigaufnaba afa Godna Sungwag ehem sihina og, “Hai so nangu sambaga mungo el nem yisgi ambugog. ");
INSERT INTO amn_n_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Eso peka nangwag, nofeka ahuiagim kusi. Eba kikehe ningitigig.” ");
INSERT INTO amn_n_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Eso Pita penam elim esoni og, “Kaho ne kam yisgi ambugog. Ahnaig esegba so na ambugog?” ");
INSERT INTO amn_n_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Afa ehegel sihini og, “Korniliusba soldiana misog el na kam ningitigi. Eba afsug el Godum ahnai skaufenaule, afa Ju el mungwali ehem mungo lahlafe fig. Afa Godna of wanai el pugunam ehem sihinag so ma nem unenaiba so na heafna lala gam bonam eso ma neana mo higi.” ");
INSERT INTO amn_n_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Eso Pita lala megam sulfu wan sahokana wangafna. Afa askanam pigiagafenam Pita mungwal ahufefnamba eso minganag Jopa nai Ainiyagna el mungwali ahuna. ");
INSERT INTO amn_n_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Afa ming osuna ahu Sisaria kimbig opukona. Kornilius Pitam nengiaufnaba eso heafna nilite mi hihe mi une tiginam heafna lala nuwagigna. ");
INSERT INTO amn_n_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Afa mahim Pita lala megam asahofnaba eso Kornilius bo muhwa pugunam mongkokini kwakwage penam hefum ahnai skaufena. ");
INSERT INTO amn_n_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Afa Pita ehem fukwa fukunam esona og, “Bihia, kagaba elhe.” ");
INSERT INTO amn_n_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Afa Pita sihiagafeakan lala megam ahsahonam afa nangwanaba el numb nuwagofna. ");
INSERT INTO amn_n_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Afa so mungwali sihini og, “Ne ati anwanafig kagelni Ju elni nihe mo enaig esona, Ju el nofeka afwambanai elni lala ahu saigonam wahinim augu. Eba God ati kam wagfunag ka mas minganag elim kwenam afa esoi nengel Godna nofwa nuhwef el. ");
INSERT INTO amn_n_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Mahim ne kam awamonagba eso ka mas anksam meg mo. Ahnaig esegba so na kam awamonag? Ka mas anwanafeg mo.” ");
INSERT INTO amn_n_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Afa Kornilius esona og, “Afa sambaga sambaga osuna awaienaba ka osu efihlagna lala wa beten neaufnaba afa ikagna el mungo afwambusug lofugna bo gofenaba, ");
INSERT INTO amn_n_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","afa kam sihina og, ‘Korniliuso, God neana betenim ati higig, afa mang so na gawig hwainig elim faig ehe mas etetig mo. ");
INSERT INTO amn_n_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Eso elim Jopa gam ningitigiba so ahu Saimonim wanig ambugog afa ming unehlagba Pita. Eba ming Saimon ehe bulmakauna lofug gafugafeule el i ahagag. Ehena lalaba bu muhwa go.’ ");
INSERT INTO amn_n_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Eso ikagna ka nem awamona afa kagel sifakalig so na bog. Enaig fenaba na soka yawo Godna nof wa nuwagigim afa Ainiyagna mungwali mo ehe nem faig eso kagel koka higim.” ");
INSERT INTO amn_n_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Afa Pita enaig sihifena og, “Yawo kati anwanafeg eba inim nemug, mungwali el Godna nofwa mungwalofug fiahsaieg. ");
INSERT INTO amn_n_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Afa amangel ahanaig ahanaig el Godum ahnai skaufenigim afa lahlag nihe pahluhug enaig elim God sawiyi fegim wambug. ");
INSERT INTO amn_n_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ne anwanafig God kagel Ju elim heafna mo gof kam ningihianig. Ena lahlag moba enaig sihifeg Sisas Krais ehe mungwali elni Ainiyag bigim esenigbi eso big God i mungo onigigna ahfeg. ");
INSERT INTO amn_n_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Afa ne anwanafig mang Israel wanai puguna. Yuwana Galili provins wa Jon mo sihifenam og ma el onigig wahigifenam bu wa apaigofi. ");
INSERT INTO amn_n_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Afa Sisas Nasaret wanaim God heafna Sungwag i kigmog i faina. Afa God ehe ahgofena eso ikafenaba lahlag gafugafiahkafena afa amangelim so Satan amtakwale aitifena enam lahla fetifena. ");
INSERT INTO amn_n_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Enaigim na ka nangugim mahim Ju elni mungwali kimbig afa Jerusalem wa enaig esenigbi na so ka ena mo sihig. Afa enaig elim li katigeg wa tigi kahli. ");
INSERT INTO amn_n_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Afa mahim sambaga mungo osuna awaienaba God ehem ilafofatig eso ambagwa pugugba nangug. ");
INSERT INTO amn_n_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Afa mas mungwali el nanguni mo, eba minganag amangel so God gishug hwatig gwenag mungo ehe nangunim sihini. Afa mahim bihianaba so ka fane i bu i mungwali wanig ahagag. ");
INSERT INTO amn_n_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Afa ehe kam esonig so ena lahlag mo elim sihigon enag elbi God ehe gishug wahiag elim kwefihianugegim melig pigieg mi afa nofkena gag mi. ");
INSERT INTO amn_n_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Mungwali Godna mo fi sihigule el ena moba sihi wahini amangel ehem olug onigig finigbi ehena unehlag wa God ehegelni amtakwaligim hugufatinif.” ");
INSERT INTO amn_n_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita mahimsi mo sihiagofenaba afa ena el mo higinibi eso Godna Sungwag pe bo mungwali ehengelim puguni. ");
INSERT INTO amn_n_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Afa Kristen Ju el Pitam wanig ambugonam nangunimbi afwambanai el so Godna Sungwag wambini eso ehegel enam sineminefini. ");
INSERT INTO amn_n_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Afa higinibi enag el ahanaig ahanaig mona lagwaginim Godna unehlagim fingi fini. Eso Pita sihina og, ");
INSERT INTO amn_n_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Sa nangu, enag elbi Godna Sungwag wambugbi eba big gwenaig mungwalofug big fig eso aman enag elim bu wa apaigoguba kwenife? Eba mas aman enaig esei.” ");
INSERT INTO amn_n_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Eso Pita sihini sona el so ma Sisasna unehlag wa bu waba apaigo. Afa ehegel Pitam sahini og, “Sa kam mwakwalig wanaganam.” ");
INSERT INTO amn_n_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Kanog hwatieg el i afa Judia nai pahlukuiag el i higini, mahim afwambanai el Godna mo ati fini. ");
INSERT INTO amn_n_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Mahim Pita ika Jerusalem gam pugunamba pahlukuiag el kokohiawagig nihem pahlukuna eso ehem fenagini og, ");
INSERT INTO amn_n_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Enag el mas kukohiagig nihem pahluhug mo afa ne heafgelni lala fukog waneg. Nofeka enaig ese.” ");
INSERT INTO amn_n_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Eso Pita wahigi sihini mungwali mang so ehem puguna. ");
INSERT INTO amn_n_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Afa enaig esona og, “Ka Jopa wa gafnamba beteneaufna eso ka mangim itiwa lofug nanguna. Eso ka nangogba ofenai lofug nalig fufugihiag afa ofim mo wahiagim so pe bog ka nai yi muhwa gofena. ");
INSERT INTO amn_n_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Afa ka nangonamba ahanaig ahanaig sis i wutwai i afa twafig i saho agfogoafna. ");
INSERT INTO amn_n_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Afa ka higinamba God kam sihina og, ‘Pita bihianam sisba sohnaba so kwagnefe.’ ");
INSERT INTO amn_n_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Afa ka wahigi sihina og, ‘Ainiyag, amo ka mas ese. Ena kwegig sisba mas kana mengig wa feg mo.’ ");
INSERT INTO amn_n_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Afa God kam piske sihina og, ‘Mang so God sihig eba lahlag eso nofeka enam oniginam kwegim.’ ");
INSERT INTO amn_n_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Sambaga mungo nagim gwenaig esenam eso lofug piske of gam fukokana. ");
INSERT INTO amn_n_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Gwenana sambaga mungo Sisaria wanai elim ka nangum ningitiginimbi eso ambugog lala opukona. ");
INSERT INTO amn_n_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Afa Godna Sungwag kam enaig sihifena og, ‘Nofeka ahuiagim kusi.’ Afa ohunag enwesog wa gohug nilite ka wanig augim afa Korniliusna lala wani saigog ahug. ");
INSERT INTO amn_n_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ehe kagelim sihini mang so ehem puguna. Eba Godna of wanai el heafna lala wa nangonamba afa ehem enaig sihifena og, ‘Eso elim Jopa gam ningitigiba so ahu Saimonim wanig ambugog afa ming unehlagba Pita. ");
INSERT INTO amn_n_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Afa ehe nem mo figagfo faif eso God nem gwena lala naim wambf.’ ");
INSERT INTO amn_n_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Afa autunam Godna Sungwag pe bo bigelim puguni afa enanam ka mo sihi gofenaba gwenaig esena ehegelim gaba puguni. ");
INSERT INTO amn_n_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Afa ka onigig yuwana Ainiyag esona og, ‘Jon buna buwa elim aitig afa God heafna Sungwagni buwa nengelim aitig.’ ");
INSERT INTO amn_n_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Afa mahim big Sisas Krais Ainiyagim oniginimbi eso God bigim heafna Sungwag faig. Eso gwenaig afwambanai elim esenigbi so ambagwa pugug eba God ehe gafugafeg. Enaig esegba na so ka mas Godna gafugagim kwei.” ");
INSERT INTO amn_n_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Afa ena mo higinim mas Pitam fenagini mo eba Godna unehlagim mungo fingi finim afa esogona og, “Ei eba inim, God afwambanai elim gaba minaba ambafenig eso ma ehegel olug wahigi finim nofkena fi.” ");
INSERT INTO amn_n_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Yuwanam Stivenim mahim tigi fatinimbi Ainiyagna el kinig finim afa ika Fonisia, Saiprus, afa Antiok kimbig embem ahkawag minefena. Enanai yi Sisasna mo Ju elim mungo sihigoni. ");
INSERT INTO amn_n_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Afa minganag Saiprus nai afa Sairini nai el Antiok gam ahunam afa afwambanai elim gaba Sisas Ainiyag lahlag mo sihigoni. ");
INSERT INTO amn_n_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Afa Ainiyagna kigmog ehegelim guhunimbi eso el numb olug wahigifinim Ainiyagim onigini. ");
INSERT INTO amn_n_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Afa Jerusalem wanai sios ena mom higinim eso Barnabasim Antiok gam ningihini. ");
INSERT INTO amn_n_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Afa ehe pugunam nangwagna mahim God ehegelim lahlafe hiagenamba eso ehe sifakalena. Ehe lahlag onigig faini og ma mungwali Ainiyagim hugna kifuti kikehli ogfuhe. ");
INSERT INTO amn_n_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Eheba lahlag el ehena olug onigig hugna kifutigna afa Godna Sungwag ehem yuhwafenagena eso el numb Ainiyagna el opukona. ");
INSERT INTO amn_n_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Eso Barnabas Tarsus gam Solim nangwagim ikana. ");
INSERT INTO amn_n_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Afa ika pugunam yisginam eso sulufa Antiok gam wani bonam mungo yia wa ahagena. Afa mahim sios el nuwagfenamba eso enaksag elim wagfufenug ahfena. Yuwana nemug ena kimbig wa Ainiyag elim unehlag fini Kristen. ");
INSERT INTO amn_n_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Enanam minganag Godna mo fi sihiule el Jerusalemim wahinim afa Antiok gam ambugona. ");
INSERT INTO amn_n_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Afa sonag el nai mungo eba Agabus. Ehe Godna Sungwagni kifuti guhunam eso ena mo sihina og nengigim nalig bini mungwali bite puguf. (Enamba mahim Klodius Rom wanai misog el gofenamba eso enaig puguna.) ");
INSERT INTO amn_n_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ainiyagna el ena mo higinim eso ati onigini Judia nai Kristenim gwena yuhwa kwaganif. ");
INSERT INTO amn_n_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Gwenaig esini Barnabas mi Sol mi kig faigonam ningitigini eso enag kig oku Juda nai sios amunai elim ahfaina. ");
INSERT INTO amn_n_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Enanam misog el Herot, siosna elim kinig faini. ");
INSERT INTO amn_n_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Afa ehe gafugag elim ningitigina og ma Jemsim Jonna etegim higefaki. ");
INSERT INTO amn_n_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Afa enaig esenam Ju elim nangwagena mahim sifakalinimbi eso Pitam kikehlanam kalabus lala fati wahiana. (Enanam Ju el Bret Yist Hwainig buyis esifini.) ");
INSERT INTO amn_n_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Afa so Pitam kikehlinim kalabus lala fatini. Afa ena lala 16 soldia Pitam nangwafofna. Afa sambaga sambaga agfohiafna mahim ahuiafnamba afa mingang sambaga sambaga ambugog ehegelni kugwa agfohiafna. Herot og mahim Pasova buyis awaiyeba eso Pitam elni nof wa fahigenage. ");
INSERT INTO amn_n_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Afa mahim Pita kalabus lala agafenamba afa sios higeg Godum sahanafafna og so ma God Pitam kweagfwi. ");
INSERT INTO amn_n_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Lawam mahimsi feafnamba Herot Pitam fahigenag ogna fe. Afa sinaini Pita sambaganigi soldia nai yi olyi gifini. Afa sambaga senna kikenagi fakinim eso sambaganigi soldia mengig wa kagwo ahgofna. ");
INSERT INTO amn_n_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Afa Ainiyag of wanai el ikagna pugunam afwambusug lala megam puko gofena. Afa so Pitam epinig wa ilafo fatinamba eso Pita nof tutafe bahianamba afa so of wanai el sihina og, “Is ikagna bihia.” Eso gweyi sen Pitana ninga nai pitigifu ahpena. ");
INSERT INTO amn_n_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Afa of wanai el ehem sihina og, “Piske lofug i afa mong lofug i aitiage.” Eso Pita gwenaig esenamba of wanai el piske sihina og, “So na liputig lofug fwahlanam kam pahlu bu.” ");
INSERT INTO amn_n_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Eso Pita ehem pahlukuiafnamba mengigim fakwegfu ahfeakana. Ehe nangonamba eso of wanai el esena ehe enaig onigina eba mang inim mo. Ehe enaig etitinam og eba ka itiwamba nangug. ");
INSERT INTO amn_n_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Afa sambaganigi kwagana ikana afa ika ming mengig wanai kwagana ikana afa ikanam ain mengig wa pugunam, afa ena minamba gwesim kimbig gam ikafna. Afa ena ain mengigba ehe heafa pitigiafunamba eso pugu afwambagam ahkana. Mina wa mwakwalig ahkanam eso of wanai el gweyi ikagna ehem washu ikana. ");
INSERT INTO amn_n_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Afa so Pita enam anwanafenam esona og, “Eba inim yawo ka ati anwanafeg eba Ainiyag heafna ofwanai elim ningihiagba eso kam Herotna ninga nai afa Ju el amtakwal kam ofinifini so nanai kam fag.” ");
INSERT INTO amn_n_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Afa mahim ehe enam anwanafenam eso Maria Jon Makna afagna lala gam ikana. Afa el numb enanai yi nuwagnam beteneafafna. ");
INSERT INTO amn_n_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita ikanam mengig wa ningana tige gofena. Afa Roda gafugag angwafig eso ikanam ogna mengig pigi. ");
INSERT INTO amn_n_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Afa ehe ati Pitana mengigim higna eso sifakalenam ehe mengig pigiegim etetinam eso kikini piske ikanam sihina og, “Pitamba ati mengig wa bo go.” ");
INSERT INTO amn_n_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Afa ehem esogona og, “Ne moetetiofe.” Afa ehe hugna kifutinam esona og, “Eba inim ehe.” Afa ehe esogona og, “Amo, eba Pitana ofwanai el feg.” ");
INSERT INTO amn_n_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Afa Pita mahimsi gwese mengig wa tige gofenaba eso ahu mengig pigi nangunim sineminefini. ");
INSERT INTO amn_n_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Afa Pita ningana pigafenim og afwai afwai. Eso heafna mo so Ainiyag ehem kalabus lala suguafa puguna. Afa ehe sihina og, “Sa ahu Jems afa minganag nilitem ena mo sihigon.” Eso ma wahinim asim ahui. ");
INSERT INTO amn_n_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Afa lawam soldia etetiagenim hefum onignaginim sahawagini og, “Afa, asim mahim Pitamba ikag?” ");
INSERT INTO amn_n_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Afa Herotna gafugag el Pitam yisgiahuan mas nanguni mo. Eso Herot Pitam anwasafenafuhug elim hugna fasahitigifenam afa sona og, “Sa kwaskofi!” Afa mahim kwaskofinimbi eso Herot Judia wahianam mwakwalig Sisaria wa gana. ");
INSERT INTO amn_n_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Afa Herot Tair nai Saidon nai elim olug kakagen gofena. Eso ehegel onigini ehegelni kimbigim mas fane kwagana mo eso nuwagnam ogna nangui. Yuwana mo Blastusim Herotna misog gafugag elim sihini og ma kam kwagani. Eso ahunam Herotim nangunim sahini og ma olug kakagig wahiai. ");
INSERT INTO amn_n_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Afa so mungo osunam sufini wahiani eso Herot heafgelni misog elni lofug wagwagenam heafgelni misog elni sime wa peganam so ma mo sihinugeni. ");
INSERT INTO amn_n_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Afa mungwali el ambagwa hugna enaig esogona og, “Enamba mang elni moamo eba heafa god ehe sihiago.” ");
INSERT INTO amn_n_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Afa Herot ena mom sifakalena afa ehe mas Godna unehlagim fingi fena mo. Eso ikagna Ainiyagna of wanai el ehem tigenamba so gihenam afa peitu atagim ahgaginimbi eso wahana. ");
INSERT INTO amn_n_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Afa Godna mo pugu kifutinam eso fafukaminefna. ");
INSERT INTO amn_n_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Afa Barnabas i Sol i Jerusalem wa gafugag auwigiafenam afa Jon Makim ahsulfanam Antiok kimbig gam eso piske ahuna. ");
INSERT INTO amn_n_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Afa enanai yi Antiok sios waba Godna mo fi sihiule el i afa wagfuiag el i agfohiafna. Ehegelni unehlagba Barnabas, Simeon (heafna ming unehlagba Niger), Lusius (eba Sairini nai el), Manain (eba autunam misog el Herot i mungo niliag ahfena), afa Sol. ");
INSERT INTO amn_n_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Enanam sios el fane hwaiyi gonam Ainiyagim lotu finimbi so Godna Sungwag sihini og, “Barnabas mi Sol mi wambtiginim enmuna hwatigi ati ka ena gafugag wa gishug hwatigig so ma gafugafe.” ");
INSERT INTO amn_n_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Afa so fane hwai yi gonam betennini eso ninga eheningi nai yi skunim afa so ningitigini. ");
INSERT INTO amn_n_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Afa Godna Sungwag ningitinimba eso Selusia gam ahkana. Selusia ahpugunam bot wa ahgonam eso ailan Saiprus gam ahkana. ");
INSERT INTO amn_n_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Afa Salamis kimbig ahpugunam ika Ju na nuwagig lala ika ahsahonam Godna mo ahsihina. Jon Mak auguiafenamba eheningim kwaganfna. ");
INSERT INTO amn_n_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Afa ehegel enag ailan wa fapuke fiahuian ming maligim Pafos kimbig opukonam nanaiyi nangunimbi Ju el mungo Bar Sisas heafna unehlag Grikna mona sefig Elimas. Enag elbi agisu ule wini ule afa ehe mwakwal Godna mo fa sihiaule el feg. ");
INSERT INTO amn_n_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ehe misog elni gafugafegofna. Enag misog elbi Sergius Paulus eba numwehe anwana el, afa ehe ogna Godna mo higim eso Barnabas mi Sol mi uneni. ");
INSERT INTO amn_n_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Afa Elimas enag elbi agisu ule el, ogna eheningim kwenim og ese misog el masa Sisasim oniginaf. ");
INSERT INTO amn_n_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Afa Godna Sungwag Solim, afa ming unehlagba Pol, ehem yuhwafenagenamba eso ehe Elimasim hugna nofna nangunam sihini og, ");
INSERT INTO amn_n_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Nemba Satanna leg. Ne lahlag nihena angoluwag go. Mungwali ahanaig ahanaig mo mwakwalig neana onigi wa naligfiageg eso ne Ainiyagna mom amtakwale fag. ");
INSERT INTO amn_n_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Eso ma Ainiyagna ninga nem filafati afa so nem nofug mwakwalig amtakwalig gohi so na mas osuna afwambusugum nangui.” Afa Elimas nangunam ikagna lango sikigifenam pe bo nofugum sagfa fakana eso etetiage akafnamba elim yisgiakafna og ma kam ningana kikehlanam waniki. ");
INSERT INTO amn_n_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Afa misog el enam nangunam afa Ainiyagna mo ehem olug fingi fenamba eso olug onigig Ainiyagim faina. ");
INSERT INTO amn_n_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Afa Pol fena heafna hihe apaiyenam eso bot finim Pafos wahinim Perga kimbig Pamfilia provins gam ahuna. Afa Jon Mak mo enanai yi wasana piske Jerusalem gam ikana. ");
INSERT INTO amn_n_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Afa eheningi Perga ahwahianam Pisidia distrik Antiok kimbig ahpuguna. Afa mahim Isug Auguiag Osuna pugunamba eso eheningi ahkanam Ju elni nuwagig lala ahsahonam pe ahagana. ");
INSERT INTO amn_n_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Afa mahim Mosesna mo i Godna mo fi sihiule elni mo i Godna buk wa suwigni wahinimbi, eso amunai el eheningim sahigoni og, “Nilite, atiamba ne mo ahfegba eso ehengelim ahkwaganam so ahfai.” ");
INSERT INTO amn_n_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Afa Pol bihianam ninga fatinim og ma sifeiba eso esoni og, “Israel nai el i afa afwambanai el i Godum ahnai skaugfinim so kam higini. ");
INSERT INTO amn_n_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Autunam Israel na God kangelni simbianigam ati kanog hwatina afa mahim Isip yi auguiafnamba God esenimbi pugug enaksag feagena. Afa hugna kifuti gafugag fenam Isip yi nai wambana wambpukuna. ");
INSERT INTO amn_n_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Afa Israel mahim 40 yia bite bihig wa Godum gasafinimbi afa God mas hwatina mo. ");
INSERT INTO amn_n_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Afa ehe mahim elegeg wa gohug Kenan wa nai kantriim flafonamba eso heafna elim wahianamba eso ehe bitena mog fiahsaina. ");
INSERT INTO amn_n_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Afa enaig esena 450 yia fenamba. Eso God ehegelim nangwaghiageg elim fainimba so ikan ikan Samuel Godna mo fa sihiaule nai yi puguna. ");
INSERT INTO amn_n_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Afa mahim ehegel membini misog elim sahinimbi eso God Solim wahiani. Sol eba Kisna leg afa ehe Benjaminna mungo simbiangana. Afa ehe 40 yia nangwaghiagena. ");
INSERT INTO amn_n_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Afa God Solim mo ningihianam eso Devitim misog el wahiana. God esona og, ‘Devitba Jesina leg ka nangugim afa ka ehem hugna membenageg. Eba kana olug fafe.’ ");
INSERT INTO amn_n_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Autunam God ati sihi wahiag ehe og eba Devitna simbianiga fenam eso Israel elim wambf, ena elbi eba Sisas. ");
INSERT INTO amn_n_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Sisas mahimsi gafugafeg hwainig fiafenamba enanam Jon puguna Israel elim mo fainim og ma olug wahigifinim amtakwalig nihem wahinim eso ma bu wa apaigo. ");
INSERT INTO amn_n_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Afa Jon gafugag awaiegim meini ofefenamba ehe enaig sihini og, ‘Ne enaig onigini kaba aman? Kaba mang sonag el God so Gishu Wahiag so na nengiahu, ena mo. Nengigim sonag elbi eso kana sum yi bof. Kaba mang lahlag el mo, ka mas ehem kweagfunam ehena mong lofug huguiafam nai.” ");
INSERT INTO amn_n_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Pol enaig sihifeni og, “Nilite, nengel Abrahamna simbianiga i afa afwambanai el i Godum ahnai skaugfini, afa God ogna elim wambum eso ena mo bigim ningihianig. ");
INSERT INTO amn_n_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalem nai el i afa heafgelni misog el i mas anwanafini mo Sisas eba God Gishu Wahiag el. Afa mungwali Isug Auguiag Osuna ena mom suwigfofnamba, afa ehegel mas numwehi anwanafini mo Godna mo fi sihiaule elni ginofim. Enag ginof inim esenamba eso ehegel ogna Sisasim tigifati. ");
INSERT INTO amn_n_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Afa mas ehena ahanaig ahanaig nanguni mo afa ehegel Pailatim sahini og ma Sisasim tigi kahli. ");
INSERT INTO amn_n_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Sonag elbi ati Baibel sihi wahiana eso ehem enaig esenag gif so gwenaig esini li katigeg wa nai numbwasginim bite meg gam fakini. ");
INSERT INTO amn_n_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Afa so God ehem piske ilafo fatina. ");
INSERT INTO amn_n_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Afa enaksag osuna hefum wagfunfini. Afa so yuwana el Galili wahifinim Jerusalem gam wanig ahuafenaba eso yawo nai mo Israel nai elim sihinigena mang so nofna nanguna. ");
INSERT INTO amn_n_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Na so kaningi nem ena lahlag mo ka nem ahbonig. Autunam God bigelni simbianigam sihi wahianimbi eso ena elim ningihiagba bigim wambug. ");
INSERT INTO amn_n_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Afa ehe Sisasim ilafo fatigba eso ena mo inim bigel ehegelni luwaligim pugunug. Afa Baibelna mo Buk Song 2 wa enaig esog og; Yawo kaba neana awag eso neba kana leg. ");
INSERT INTO amn_n_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Afa minginag moaba God sihig, eba ehem ilafo fatigba, eba mas ehena elig nogig mo. Ena mo enaig sihi feg og; Ka Devitim sihi wahiana ka ehem lahlag esenag. Enag sihi wahiag eba inim feg afa afsug kabag feg. ");
INSERT INTO amn_n_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","“Afa minginag mo enaig eseg; Mas ne nimbiafna lahlag gafugag elim wahiana mo eso bite meg gam ika nogig mo. ");
INSERT INTO amn_n_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Afa Devit nofkike gafenamba Godna sawiegim pahlufefkuan mahim wahanamba. Afa ma bite wa fakinimbi ehe simbianigana kig i waheg nogig. ");
INSERT INTO amn_n_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Afa ming elbi enamba God ilafo fatigba eba mas ehena elig nogig mo. ");
INSERT INTO amn_n_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Nilite, kog so na anwanafi Sisasba ehe mog moaba kagelni feg. Afa aman ehem olug oniginaiba eba God ehena amtakwalig mom fa fatinafe eso ehe Godna nofwa afsug kabag puguf. Afa Mosesna nihe mo mas enaig eseg mo. ");
INSERT INTO amn_n_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Afa numwehifibi Godna mo fi sihiaule el sihi wahigbi masa ne enaig esif. Enaig esog; ");
INSERT INTO amn_n_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Sa nangui, ne aman Godna mo masig fatig, so na numwehe onigifibi eba nem pigif. Eba ka mangim eseba eso ne sineminefif. Afa mahim el ena mog mo wagfugba, ne mas onigi.” ");
INSERT INTO amn_n_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Afa Pol i Barnabas i nuwag lala wahia hakafnamba afa enanai el esogoni og, “Sa ming Isug Auguiag Osuna piske ahbo gwenaig mo ahsihi.” ");
INSERT INTO amn_n_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Afa so ena lala wahinim opuko afwambagam ahuna Ju el i afwambanai el i Pol mi Barnabas mi pahagahuna. Sonag afwambanai elbi Ju elni nihem pahlukuna. Afa sambaganigi lahlag mo ahfaini God ehengelim ismunagim kwaganig. Sa ma enanai yi saho agfohiefi. ");
INSERT INTO amn_n_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Afa ming Isug Auguiag Osuna opugufnamba afa mungwali kimbig nai el ogna nuwagnam Ainiyagna mo higim. ");
INSERT INTO amn_n_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Afa Ju elni amunai el mahim enaksag elim nangwagnim ehengel kusiasaina afa so Polna mom pagau apaiyenam afa ahwanef mo faini. ");
INSERT INTO amn_n_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Afa Pol i Barnabas i hugna kifuti hogonam wahigi ahsihini og, “Eba inim yuwana kati nem Ju elim Godna mo ahfainimbi afa nimbe ne kusini afa mas ne nofkikena lahlag higeg gagim onigi mo. Naig fenamba na so ka nem ahwatigim afwambanai gam ka haka. ");
INSERT INTO amn_n_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Afa Ainiyag kam esonig og; Ka nem afwambusug esenibi eso afwambanai el enam nangunim pahluguf eso ena mina God mungwali bite nai elim piske wambf.” ");
INSERT INTO amn_n_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Afa afwambanai ena mom higinim sifakalinim eso Ainiyagna mo fingi fukualina. Afa amangelim so God kanog hwatig nofkikena higeg gagba enag el Ainiyagim olug onigini. ");
INSERT INTO amn_n_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Afa so Ainiyagna mo ena bite wa fafukaminefena. ");
INSERT INTO amn_n_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Afa Ju el kimbig wanai amunai el mi afa Godum lotu fenag misog angwafig mi ehegelni olugim wahigi fegonibi eso ehegel mas Pol mi Barnabas mi membegoni mo. Eso ehegel eheningim kinig faigona eso ehem enanai ningitigini. ");
INSERT INTO amn_n_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Enaig esafena, pugu hakafnamba smof mong yi nai buambu ahfenam ahkana. Enamba enaig eseg eba mas ena kimbigim ahfatigim gwesim Aikoniam kimbig ahkana. ");
INSERT INTO amn_n_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Afa Antiok nai pahlukuiag elim Godna Sungwag yuhwa fiasainaba eso hugna sifakalini. ");
INSERT INTO amn_n_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pol i Barnabas i Aikoniam gam ahka ahpugunam Ju elni nuwagig lala asahuna gwenaig nihe ahfiafena. Afa mahim mo ahsihiafenamba ena mo elni olug fingi wahigiskona eso enaksag Ju el i afa afwambanai el i Ainiyagim olug onigini. ");
INSERT INTO amn_n_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Afa minginag Ju oniginigim kusini afa afwambanaim ikaghiagini og ma Kristenim olug kakagegoni. ");
INSERT INTO amn_n_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Afa sambaganigi mwakwalig nanai yi ahaganam Ainiyagna mo gwese ahsihiagofna. Afa eheningi ahanaig ahanaig kigmog esiagafenamba enamba Godna kigmogim wagfug afa enag afafeg mo ahsihinamba eba inim. ");
INSERT INTO amn_n_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Afa enanai el bambuhiaginim, minginag Ju elni amunai elim pahagahuafna afa minginag kanog hwatieg el sambagam pahagahuafna. ");
INSERT INTO amn_n_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Afa Ju el i afwambanai el i afa eheningina amunai el i ogna sambaganigi elim amtakwalihiaginim eso hun na kwaskofi. ");
INSERT INTO amn_n_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Afa sambaganigi ena mo ahiginam distrik Likonia gam ahkana, afa enanai yi ahpugunamba eba Listra afa Derbe afa minginag kimbig muhwa gohkana. ");
INSERT INTO amn_n_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Afa so enanai yi Godna lahlag mo ahsihina. ");
INSERT INTO amn_n_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Afa Listra kimbig waba el mong kukwaligni gafna. Enaig esenamba eba afag gwenaig wesig wa wanigana. Afa kwamblogfenam mas gominefena mo. ");
INSERT INTO amn_n_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Afa enanam mahim Pol lahlag mo sihiagofnamba enag el ena mo higina ofena. Afa so Pol ehem fahigenagenam anwanafena ehena olug onigig ati yuhwafeg eso God ehem wangenefe fatif. ");
INSERT INTO amn_n_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Eso Pol ehem ambagwa sihina og, “Buihia gohum!” Eso ehe pusoka gohnam so ikana. ");
INSERT INTO amn_n_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Afa el numb nanguni mahim Pol enaig esenamba eso ehengel Likoniana mona ambagwa esona og, “Sohna elbi eba sambaganigi god el lofug bigim pe ahbonug.” ");
INSERT INTO amn_n_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Afa Barnabasimba eba sefini Sus afa Pol eba hugna mo sihiaule ofenaiba god Hermes eso ehem sefini Hermes. ");
INSERT INTO amn_n_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Afa ena lalaba enanai yi el god Susni unehlagim fingi fifini enamba afwambagam kimbig wa gofna. Susni pris bulmakaum tagni wagwagifinim eso kimbig mengig gam wambug ambugoafna. Ehe fena afa mungwali el apaigona ogna kwagi wehlim eso eheningina unehlagim fingi fiawag. ");
INSERT INTO amn_n_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Afa mahim enaig esinimbi eso Barnabas i Pol i ena mo ahiginam afa so heafningina nihi lofug kuko ahwatiafenam so ahpugu olyi kikini ahkafnaba hugna unehona og, ");
INSERT INTO amn_n_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Afa mangigim ne enaigba esig? Kaningiba el big mungwalofug fig. Kaningiba ahbog nem lahlag mo ahfaig eso ne mwakwal godum wahinim eso ne wahigi God nofkikenagim onigini. Ehe of i bite i bu i mungwali gawig gafugafiageg. ");
INSERT INTO amn_n_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Autunam ehe afwambanai elim hwatina eso heafgelni sawiegim pahlukiahufna. ");
INSERT INTO amn_n_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Afa ehe lahlag gawig wambwai gofnaba eso bu fiafna afa nefgenai so heafna osuna puguageafna. Afa so ehe enaksag fane faifinim afa ehe nengelni olug yi afigig faig. Enamba wagfug ehe nofkikena go.” ");
INSERT INTO amn_n_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Afa gwenaig mo ahsihinam afa ehe og ma ehegelni onigig wahgifi, ese ehegel masa bulmakau tigi tuhulunim eheningim fingi fiawagfe. ");
INSERT INTO amn_n_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Afa enana Ju el Antiok Aikoniam kimbig wahinim Listra kimbig gam ambugonam ena kimbig wanai elim hekusihiaginimbi, eso Polim hun na tatuni og ateaba wahag eso ehem fini kimbig wa afwambagam fatini. ");
INSERT INTO amn_n_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Afa mahim Kristen el ehem wagfinimba eso Pol bihianam so piske kimbig gam sahokana. Afa lawam Pol i Barnabas i ena kimbig wahianam Derbe gam ahkana. ");
INSERT INTO amn_n_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Afa eheningi Derbe wa ahagafinamba lahlag mo ahsihinamba enanai el enaksag Ainiyagna fiahsaina. Afa piske Listra afa Aikoniam afa Antiok Pisidia gam ahkana. ");
INSERT INTO amn_n_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Afa ahkafnamba kigmog mo pahlukuiag elim ahfaifinim og, “Nofeka olug onigim wahiyi yi. Amangel Godna bog meg gam saiyegogumba ofifibi eso ma kinig numb finim eso saho.” ");
INSERT INTO amn_n_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Barnabas i Pol i mungo mungo siosna amunai elim hugwefu ahwati hofefnaba. Eso fane hoiyioaklafinim so betennini og ma God heafna ninga wa agfohie, eba ehegelni Ainiyag. ");
INSERT INTO amn_n_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Afa eheningi Pisidia ahwahianam Pamfilia gam ika ahpuguna. ");
INSERT INTO amn_n_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Afa Perga wa Ainiyagna mo ahsihinam afa gwesim Atalia gam ahkana. ");
INSERT INTO amn_n_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Afa nanai yi bot wa afkonam Antiok gam ahkana enanai yi autunam Kristen eheningim Godna ninga wa hwatiginimbi eso God ismunagim kwaganaba eso ena gafugagfeag ahfeakan eso piske ahbona. ");
INSERT INTO amn_n_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Afa ahpugunam enanai yi sios elim ahunetigina og ma ambugog nuwagiba eso heafningina gafugagim sihinug ahfenam og, “God ehe esegim minaba pigiba eso afwambanai elbi Ainiyagim olug onigini.” ");
INSERT INTO amn_n_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Afa sambaganigi enanai yi pahlukuiag elim hugna ahwangana. ");
INSERT INTO amn_n_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Afa mingnag Judia nai el Antiok kimbig opukonam Kristenim esogoni og, “Mosesna nihe mo enaig esog so na lofugum kukuhiawagi, eso ne ena moba mas pahluhug mo, eba God mas nem wambu.” ");
INSERT INTO amn_n_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pol i Barnabas i ena mom ahiginam hugna ahwagnaba eso sios el sihiaginim sambaganigi mi afa minginag apaiyenamba enam hwatini og ma ahui Jerusalem wa siosna amunai el mi afa kanog hwatieg el mi numwehe sihigoni. ");
INSERT INTO amn_n_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Afa so Antiok sios ehegelim ningitiginimbi eso distrik Fonisia gam afa Samaria gam eso sihiageahuna, og ati afwambanai el Godum olug oniginig, afa mungwali Kristen ena mom higinim eso hugna sifakalini. ");
INSERT INTO amn_n_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Afa mahim Jerusalem opukonaba sios el i kanog hwatieg el i afa amunai el i ehegelim nangwaginim sifakalini. Eso ehegel sihiagini mang so mungwali God ehegelni ninga wa gafugafeni. ");
INSERT INTO amn_n_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Afa minginag Kristen farisi nihem pahlukuiaule bigiagafenam og, “Afwambanai el gaba so ma heafna lofugum kukohiaginim afa minginag mungwali nihem Mosesna pahlukui.” ");
INSERT INTO amn_n_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Eso kanog hwatieg el i afa amunai el i nuwagnam ena mom kwefuhiageafafna. ");
INSERT INTO amn_n_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Afa ena mo sihiageafafnaba eso Pita bihianam sihini og, “Nilite, ati ne anwanafig autunam God kam nengel nai yi olyi kanog wahiag ka afwambanai elim Godna lahlag mo faibi so ma Sisasim olug onigini. ");
INSERT INTO amn_n_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Afa God ati elni olug onigigim anwanafegim afa heafna Sungwag ehegelim faig eso gwenaig eseg bigelim gaba faig. Enamba bigim wagfunig ati ehegelim gaba wambug. ");
INSERT INTO amn_n_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Afa big Ju el i afa afwambanai el i Godna nof wa mungwalofug afa mahim ehegel onigigbi eso God ehegelni olug yi nai amtakwalig nihe wambug aitinigbi eso ehegelni olug afsug agfohienig. ");
INSERT INTO amn_n_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Big i afa bigelni simbianiga i mas numwehig Mosesna lahlag nihem pahluhug mo. Eba hugna kifutig. Ahnaig esegba so na og ka ena kinigbi kikinim Kristenba faigo afa so na enaig esegonibi eba God ninimuf. ");
INSERT INTO amn_n_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Amo, ati big anwanafig Sisas Ainiyagna afafegwahe God bigim sulfug na so big ehem olug oniginig gwenaig seg afwambanai gaba esig.” ");
INSERT INTO amn_n_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Afa so mungwali el sifinam Barnabas nai i Pol nai i mom higwagfofna. Afa eheningi enaig sihi ahfini og God afwambanai elim ahanaig ahanaig kigmog kaningina ninga wa esinig. ");
INSERT INTO amn_n_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Afa eheningi mahim sihi ahwahianamba eso Jems sihini og, “Nilite, so kam higini. ");
INSERT INTO amn_n_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saimon ati sihi wahiana og God yuwana minginag afwambanai elim wambugum afa heafna el fiahsaiyig. ");
INSERT INTO amn_n_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Enamba Godna mo fi sihiule el gwenaig ginofi wahini og. Godna buk enaig sihifeg; ");
INSERT INTO amn_n_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Devitna simbianiga enaig eseg lala lofug bufug pegi afa so nengigim ka bonam piske nimbaiba. ");
INSERT INTO amn_n_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Eso mungwali el Ainiyagim yisigif eba afwambanai el ati ka kanog hwatig eba kana el. ");
INSERT INTO amn_n_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Enamba Ainiyagna mo ati autunam sihi wahiana afa el enam ati anwanafig eso enaig puguf.” ");
INSERT INTO amn_n_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Afa Jems gwenaig sihifena og, “Eso ka enaig onigig afwambanai el ogna Ainiyagim olug onigi, nofeka hugna ehegepusug faigo. ");
INSERT INTO amn_n_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Magofi, naiba nawo ginof finim so big enaig esogo, nofeka fane nimbasam faigo ahga, afa nofeka aga taitufi, afa nofeka sis wena kihlagba ahga, afa nofeka taf ahga. ");
INSERT INTO amn_n_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Afa ati ne anwanafig mungwali kimbig nuwagig lala Mosesna nihe mo mungwali Isug Auguia Osuna suwigahu, autunam pugugum bog yuwaga pugug.” ");
INSERT INTO amn_n_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Afa kanog hwatieg el i amunai i afa mungwali sios el i mungo mo sihiaginim eso ehengel nai yi minginag el hwatigbi so ma Pol mi Barnabas mi Antiok kimbig gam wanahui. Eso Judas fena afa ming unehlagba Barsabas afa ming Sailas fena. Eheningiba eba siosna misog el ahfena. ");
INSERT INTO amn_n_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ena elbi pas wahe ningihini. Ena ginof enaig esog: O nilite, Kangel kanog hwatieg el i afa amunai el i enag ginofba afwambanai Kristenim fatigonug, nengel Antiok, Siria, afa Silisia wanai amangel so eyi go. ");
INSERT INTO amn_n_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Kangel enaig higig minginag kangel nai el ambugog nem opukegonugum kilimoan mo faigog. Ka mas ehem enaig sihifegonug mo. ");
INSERT INTO amn_n_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Eso ka mungo mo sihiagigim afa so minginag elim hwatigbi so kangelni lahlag nilite Pol mi Barnabas mi nengelim ningihia gonug. ");
INSERT INTO amn_n_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Enag eheningiba yuwana mahim Sisas Krais Ainiyagna gafugag hofefnaba minginag el ogna patigi skotigi. ");
INSERT INTO amn_n_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Enaig esegba na so ka Judas mi Sailas mi ningitigibi so ma ahbonam ena mo mengig na ahsihi enag ginofba mungwalofug. ");
INSERT INTO amn_n_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Godna Sungwag i kangel i mungwalofug onigig fig mas ka nem kinig skogonahufi. Afa ka sawiyifig so na ohuna nihe mom pahluku. ");
INSERT INTO amn_n_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Sa nofena fane nimbasam faigo ahga, nofena taf ahga, afa nofena sis wena kihlagba ahga, afa nofena aga taitufi. Afa ne enaig esi hwanigba eba ne yuhwafif. Gweliho. ");
INSERT INTO amn_n_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Afa sios el enag elim ningitiginimbi eso Antiok kimbig gam pas oguhuna. Afa opukonam Antiok sios elim unetiginim mahim nuwaganamba eso pas mo faigona. ");
INSERT INTO amn_n_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Afa ena ginof suwiginim mahim ehem kwaganamba eso sifakalini. ");
INSERT INTO amn_n_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas i Sailas i eba Godna mo fa sihiaule el ahfena eso eheningi Kristenim hugna sihinug gafenam afa kigmognug ahfenam ena mona ahkwagana. ");
INSERT INTO amn_n_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Afa eheningi ati numwehe enanai yi ahagana afa so Kristen esogona og, “Sa ma Godna olug efihlag nem gohoni.” Enaig esogonam eso piske heafgina kimbig gam ningitigini. ");
INSERT INTO amn_n_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Afa Pol i Barnabas i afa minginag el fini Antiok kimbig auguiafenamba eso Ainiyagna mo wagfufegonfni afa mo sihigonfni. ");
INSERT INTO amn_n_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Afa mahim managenaba Pol Barnabasim sihina og, “Nawo piske nilitem nangwaghiag ahfiah ka mungwali kimbig so big Ainiyagna mo sihinug ahfe bog na ika ahnangwag fig lahlag auguia me awai awai me.” ");
INSERT INTO amn_n_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Afa Barnabas ogna Jon Makim ahwaniki. ");
INSERT INTO amn_n_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Afa Pol mas enaig onigina mo. Ehe enaig onigina og autunam Jon Makba big ambugog Pamfilia wa opukonam afa ehe bigim piske wasani ikana. Afa ehe mas gafugagim auwigina mo. ");
INSERT INTO amn_n_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Afa hefum flafihiag ahfenam eso ahpwatigina. Afa Barnabas Makim sulufanam ahka bot wa ahkanam eso Saiprus gam ahkana. ");
INSERT INTO amn_n_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Afa Pol Sailasim sulufanam ogna ahka afa sios esogoni og, “Ainiyagna afafeg so nem numwehe wambufiahkafi” eso ahkana. ");
INSERT INTO amn_n_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Afa eheningi Siria afa Silisia wa enanai yi enaksag kimbig fapugu ahfiahkafnaba sios elim kigmognug ahfiahkana. ");
INSERT INTO amn_n_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol ikan Derbe yi wanpugunam afa ena kimbig wahianam Listra gam ika wanpuguna. Afa enanai yi Timoti Kristen el gafena. Afa heafna afag gaba Kristen afa ehe Ju angwafig afa awagba eba Grik el. ");
INSERT INTO amn_n_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Afa mungwali Listra wa nai i Aikoniam wa nai i Kristen el enaig esogona og, “Timotiba lahlag el.” ");
INSERT INTO amn_n_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Afa Pol ogna Timotim waniki afa mungwali Ju el enanai ati ehe anwanafini Timotina awag eba Grik el eso Pol Timotina lofugum kukohianagena. Grik el mas enaig esi afa Pol enaig esenamba, eba mas Ju el Timotim ahanaig esini. ");
INSERT INTO amn_n_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Afa Listra kimbig wahinim eso ahanaig ahanaig kimbig fapuke fiahufnamba eso sios elim sihigonugiahufna. Ena nihe Jerusalem wanai kanog hwatieg el i afa amunai el i ena mo sihini wahinimbi og soma enam pahlukui. ");
INSERT INTO amn_n_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Eso sios elni olug onigig kifuti saigonamba afa so mungwali osuna minginag el ambugog fasahofena. ");
INSERT INTO amn_n_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pol fena afa minginag apaigona eso Frigia Galesiana bite gam ahuna. Afa Godna Sungwag ehegelim kweni og masa Esia na provins Godna mo sihif. ");
INSERT INTO amn_n_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Afa ahu Misiana bite wa opukonam eso gwesim Bitinia bite gam ogna ahu afa so Sisasna Sungwag ehegelim kweni. ");
INSERT INTO amn_n_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Mahim enaig esenamba eso Misia mo wahinim afa Troas gam apaigo ahuna. ");
INSERT INTO amn_n_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Afa sinaini Pol itiwa lofug nangonamba el mungo provins Masedonia nai gofenamba Polim unena gofena og, “Ne Masedonia gam bonam so kam kwagan.” ");
INSERT INTO amn_n_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Afa Pol enam nangunam eso ikagna kangel numwehiagofi Masedonia gam ahuiagim. Ati ka onigig enamba God kam wagfunug ehe kam ningitigi heafna lahlag mo enag elim sihigonugim. ");
INSERT INTO amn_n_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Kangel sip yi fukwalunam Troasim wahinim eso Samotres gam gwesim ahuna opukonam afa nanai lawam ka wahinim Neapolis gam ahu opukona. ");
INSERT INTO amn_n_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Afa nanai ka ena kimbig wahinim Filipai gam ahu opukona. Ena kimbigba Masedoniana nalig kimbig afa Rom el nanai yi auguna. Kangel nanai yi mwakwalig auguna. ");
INSERT INTO amn_n_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Afa Isug Auguia Osuna koka esim ahu nanai yi augu Godum sihinafuhug kugim nangu. Ka kimbig muhwa ahunam bu blugum opukonam afa angwafig nuwag gofena eso ka augunam mo sihiagini. ");
INSERT INTO amn_n_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Afa mungo angwafig gaba ena mo higina ehena unehlagba Lidia. Ehe Taiataira nai ango, lahlag nemug tafiglek lofug faig eso enanam kig nalig fag. Ehe Godna unehlag fingi fiafna. Ainiyag ehe ehena olugim numwehenage namba eso Polna mo higinam keahlana. ");
INSERT INTO amn_n_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ehe afa heafna mungo lala nai bu wa apaigona. Enanam kangelim heafna lala gam kam unegoni. Ehe enaig esona og “Ne onigig ka inim Ainiyagim oniginagba eso ne kana lala ambugog auguiafim.” Ehe kam hugna hekusihiagenamba eso ka ahuna. ");
INSERT INTO amn_n_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Nanam ka Godum sihinag kugam ahuofefnamba ka gafuga angwafig angwamingim ufini. Ena angwafigbi mwaifig simbagahlana esefkufna eso ehe ahanaig ahanaig sumi yi puguiagegim sihiageafena. Ehe enaig gafuga fiahgefenam enanam kig nalig fafenam ena kigba nangwaghiawagig elim faifini. ");
INSERT INTO amn_n_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Afa Pol kam wankafnaba ena angwafig sum bonam unetigina og, “Sohna elbi eba ehengel God sisinai na gafugag el. Ehe enaig mo sihig God ena mina elim wambugum.” ");
INSERT INTO amn_n_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ehe gwenaig sihi higeg fegofnamba Pol kusinam wahigefe mwaifigim sihina og, “Sisas Kraisna unehlag wa ka nem mo osihina ne ohuna angwafig wahianam ika.” Eso ikagna mwaifig ehem wahianam ikana. ");
INSERT INTO amn_n_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Nangwaghiageg el nangunim mahim heafgelni kig mina awaienimbi eso ehengel Pol mi Sailas mi wambtiginim ambagwa hwatigini og soma kimbig wanai misog el nangwagi. ");
INSERT INTO amn_n_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ehengel wambtiginim misog elni nofwa wanahu hwatiginim afa esogona og, “Sohna elbi Ju el afa eheningi bigelni kimbigim gasafahfeg. ");
INSERT INTO amn_n_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Eheningi elim hekusihiagafeg enaig nihe bigel Rom el nofeka enaig esi.” ");
INSERT INTO amn_n_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Afa minginag el mungwali wasanam ogna Pol mi Sailas mi patigini. Eso misog el enaig esona og polis ma lofug hugfuoaiti fegonim eso eheningim flakflaketifi. ");
INSERT INTO amn_n_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Afa eheningim hugna wena kwaskofinim eso kalabus lala fatiauguni. Afa misog el kalabus lala nangwaghiawagig elim sihina og hugna nangwaghiage agfofum. ");
INSERT INTO amn_n_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Afa higinam eso wambtinam yiminig mengig gam fatiauguni. Afa so eheningina mongugum palangna singihla hwatigini. ");
INSERT INTO amn_n_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Afa sinaini mogug liputegna Pol i Sailas i beten ahfenam afa mwanafi Godum ahfatiaufna eso minginag gwena lala nai el higafafena. ");
INSERT INTO amn_n_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Afa gwenana ikagna nalig kugo ilafona kalabus lalam fagakuku fiafana. Afa gwenanam mungwali mengig pigiakanam afa sen kalabus elim kikeg pigi apaigona. ");
INSERT INTO amn_n_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Afa kalabus lala nangwaghiawagig el bihianam afa nangunam mahim mengig pigi gohkafnaba ehe enaig onigina og ateaba opuko ahkau minefeg. Eso ehe naif fanam ogna hefum higefaka. ");
INSERT INTO amn_n_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Afa Pol unenam og, “Nofeka nimbefum amtakwale fati. Ohwi mungwali auguia.” ");
INSERT INTO amn_n_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Enag el ming elim unenam og ma wi gafa boi. Afa ehe mo kikini bonam Pol Sailasna nihi penam kiafigig gegifini. ");
INSERT INTO amn_n_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Afa sambaganigim wambtiginim afwambagam pugu wankanam sahtigina og, “Amunai, ahanaig so ka eseba eso God ma kam kweagfunam lahla fai.” ");
INSERT INTO amn_n_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Afa sambaganigi esohona og, “Sisas Ainiyagim so na olug onigina eba so ma God nem afa mungwali nimbeafna mungo lala naim wambu.” ");
INSERT INTO amn_n_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Eso eheningi Ainiyagna mo enag el mi afa heafna lala nai mi ahsihini. ");
INSERT INTO amn_n_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Enanam gwena sinaini ena el kalabus lala nangwaghiawagig el sambaganigim bu wa nehugugum sufuhiagena afa enanam ehe fena afa heafna mungo lala nai apaigona afa eso bu wa apaigona. ");
INSERT INTO amn_n_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Afa so sonag el sambaganigim heafna lala wankanam fane tuhlunam faini. Afa so ehe fena afa heafna mungo lala nai fena Godum oniginim eso hugna sifakalini. ");
INSERT INTO amn_n_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Afa lawam misog el polisim ningitiginibi eso ahu sihini og, “Sohna sambaganigi elim ningitigibi so makai.” ");
INSERT INTO amn_n_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Eso kalabus lala nangwaghiawagig el Polim sihina og, “Misog el ati sihig ne i Sailas i se ohunanai ahwahianam ahka eso ne olug efihlag na ahka.” ");
INSERT INTO amn_n_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Afa Pol polisim sihini og, “Ka mas mang ahfeg mo ehe kam mungunim mungwali elni nof wa kwaskofigim kalabus lala fatiaugug. Kaningi Rom el eso enamba amtakwalig afa kam esegonigim enamba meagam kumoahlig. Afa ehe enaig wahigamte kam og ma pugu ahkai eba so ma kam ambugog sihigonitem eso kam wanahuite.” ");
INSERT INTO amn_n_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Afa polis ena mo misog elim oguhu sihini og Pol i Sailas i ba Rom el eso ehengel sineminefinim embefini. ");
INSERT INTO amn_n_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Eso ahunam lahlag mo sihigonuginim afa wanapuko ahunam og “Ei, so na ohnagna mo ahwahianam eso ahka.” ");
INSERT INTO amn_n_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Afa so eheningi kalabus lala ahwahianam Lidiana lala gam ahkana. Afa ahka Kristen nilitem ahkuklunam mo kifutihiag ahfenam eso ahkana. ");
INSERT INTO amn_n_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Afa eheningi ahka Amfipolis mi afa Apolonia mi mo ahwahianam Tesalonaika wa ika ahpuguna. Enanai yi Ju ni nuwagig lala gofena. ");
INSERT INTO amn_n_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Afa Pol enaig eseakafena ikafenam nuwagig lala sahokafenam afa nanai yi sambaga mungo Isug Auguiag Osuna ehe Baibelna mo wagfunugiafna. ");
INSERT INTO amn_n_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ehe enaig sihifena Godna Gishu Wahiag el ehe kinig fagim afa so piske bihiag. Ehe og, “Sohna Sisasba ka nem osihin eba Godna Gishu Wahiag el.” ");
INSERT INTO amn_n_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Minginag Ju el ena mom higinim kehlini. Ena el i afa enaksag Grik Godna unehlagim fingi fiule el i afa minginag misog angwafig i Pol Sailas nai yi pasna. ");
INSERT INTO amn_n_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Afa Ju el kusiasaina eso amtakwalig elim sulfuiahuna mungo wa wasanam amtakwalig onigig faigona so ma olug kakageagi wagnim eso mungwali kimbig gwenaig esini. Ehe ogna Pol mi Sailas mi wambtinim olyi wasan eso kikini ahunam Jesonna lala opukonam mengig tutunim saho yisigini. ");
INSERT INTO amn_n_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Afa mas wambini mo eso Jeson mi afa mingnag Kristen nilite mi wanagagim sulfu wanahuna kimbigna misog el nangum eso wagini og, “Sonag elbi mungwali kimbig ahanaig ahanaig amtakwalig gafugag eseagahfiakag bog bigelni kimbig wa ahpugug. ");
INSERT INTO amn_n_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Afa Jesonba eheningina hihe na so ehena lala ahagag. Ehengel Romna misog elni nihe mom mas fatig. Afa ehe enaig esogog ming misog el goh eba sefig unehlagba Sisas.” ");
INSERT INTO amn_n_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Afa misog el i mungwali el i enaig mo higinim eso ehengelni olug kifuti eskofenam hefum gihkafna. ");
INSERT INTO amn_n_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Afa ehengel ogma Jeson wanag kigna baiminim eso ma enanai wahiyi. ");
INSERT INTO amn_n_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Afa si kifiagna Beria gam Kristen nilite Pol mi Sailas mi ningitigini. Ika ahpugunam Ju elni nuwagig lala asahuna. ");
INSERT INTO amn_n_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Beria nai elni nihe hugna lahlafena eba mang mungwalofug mo Tesalonaika el eso esini. Enag elbi higinim sifakalini afa ehe mungwali osuna Baibelna mom fahigifinim eso Polna mom kwefihianagini afa inim me awai awai me. ");
INSERT INTO amn_n_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Eso el numb Ainiyagim onigini. Ju el i afa enaksag Grik el i afa minginag Grik misog angwafig i gwenaig esini. ");
INSERT INTO amn_n_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Enanam Tesalonaika nai Ju el ena mo anwanafini mahim Pol Beria wa Godna mo sihini gofefenaba eso ahu opukonam ehengelni onigigim fingi fegoni ogma Pol mi Sailas mi amtakwalihiagi. ");
INSERT INTO amn_n_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Afa so ikagna Kristen el Polim buum blugum ningihini. Afa Sailas i Timoti mo Beria wa ahagfena. ");
INSERT INTO amn_n_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Afa minginag el Pol ika Atens wa wanpugunam enanai yi ehem washunim eso piske Beria gam ambugona. Pol ehengelim sihini og so ma Sailas mi Timoti mi sihigonibi so ma ikagna Atens gam ahboi. ");
INSERT INTO amn_n_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Afa Pol enanai yi gafenaba Sailas mi Timoti mi nenge niaufena. Afa mahim ena kimbig ahanaig ahanaig enaksag mwakwal god esiaginimbi enam fahigiagenam olug fingi fena. ");
INSERT INTO amn_n_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Eso ikana nuwagig lala sahunam Ju el mi afa Grik Godna unehlag fingi fiule el mi sihinigena. Afa minginag osuna nuwag guhug wa gohnam eso enanai elim sihini. ");
INSERT INTO amn_n_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Minginag anwana el Epikurian nai i afa Stoik nai i onigigim pahag ahuafena enag Pol wanflafihiagena. Minginag hefum sahawagini og, “Sohna elbi ehe mimewofe. Ahnaig mo mahim osihiba?” Afa minginag enaig esogona og, “Eba ehe ming bite nai godum bigim hekusihiagofe.” Mahim enaig esogonaba eso Pol Sisasna mo i afa wahag bihiag mo i faini. ");
INSERT INTO amn_n_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Afa Polim Areopagus nuwag mug wa wanikahunam afa enaig esogona og, “Kangel koka mulug mo higim eso ne minginag elim sihinige bog. ");
INSERT INTO amn_n_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Minginag mo soka higigba eba enmuna onigig kam fenig eso koka ena mogum numwehe anwanafi.” ");
INSERT INTO amn_n_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Afa Atens el i afa mingnag kimbig wa nai el i gafugag mo wahinim ahanaig ahanaig mulug mo hugna membini higinim afa hefum sihiagini eso ehe enaig esogona.) ");
INSERT INTO amn_n_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Eso Pol bihiagonam amunai elim Areopagus mog wa auguiafenaba eso esona og, “Ne Atens el, ati ka nangug nengel noka enaksag ahanaig ahanaig godna unehlagim fingi fi. ");
INSERT INTO amn_n_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ka gohminefiahba ka fahigiagegba ahanaig ahanaig gawigim ne lotufinig. Ka nangogba mungo godum faig sime wa enaig ginof goh. Ena ginof sihi og, ‘Ena godba ka mas anwanafinig mo eba ehena sime.’ Ena god ne mas anwanafig mo eso ne ehena unehlagim fingi fig na ka nem ambagwa opugunig. ");
INSERT INTO amn_n_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","God ehe mungwali bite i gawig i eseageg ehe ofna bitenaina Ainiyag feg. Ehe mas el lala nimbagba nanai yi gofi. ");
INSERT INTO amn_n_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Bigel el mas big mangwalimba kweagfui. Ehe mungohe yuhwafiahgeg. Afa eba ehe mungwali elim nofkikenag faig, afa fufeig faig, afa mungwali gawig faig. ");
INSERT INTO amn_n_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ehe mungo elim esenagba eso mungwali el mungwali bite puguiageg. Ehe enag osuna bigelni afahumonim bigim wanafagim wahiana afa ahnanai yi bite big auguiagim bigim wahiani. ");
INSERT INTO amn_n_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","God enaig esegba og ma el eso ma ehem yisgi ahunam afa atiamba ehem ufi me. Afa ehe mas bigim mungo mungo wahigwa yi fenig mo. ");
INSERT INTO amn_n_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Afa ehe nofkikenai i afa kifutig i bigim faigbi eso big gohka. Eba gwenaig eseg autunam nengelni anwana el ati ginofi wahini og, ‘Ati big gaba heafna luwalig fiahsaieg.’ ");
INSERT INTO amn_n_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Eso big Godna luwal fig. Eso nofeka enaig onigig God eba gol, silva, hun lofug eso el heafna onigig wa ningana fagim ginof fenageg. ");
INSERT INTO amn_n_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Autunam bigel mas numwehi anwanafini mo eso God mas bigim kifutig kwefihiageni mo. Afa yawo ehe mungwali bite nai elim kifutig mo faig og so ma olug wahigifinim amtakwalig nihe wahiyi. ");
INSERT INTO amn_n_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","God ati ena osuna wahiag eso elim kwefihiagefe afa ati elim gishu wahiag eso numwehe hugna kwefihianugef. Ena elbi ati wahagim piske bihiag enamba wagfug God ehe ehem gishu wahiag.” ");
INSERT INTO amn_n_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Afa mahim Pol sihinaba el wahanam bihiag mo eso minginag el ehem titigini. Afa minginag enaig esogona og, “Ka membig koka higim eso ne piske kam gwena mo sihin.” ");
INSERT INTO amn_n_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Mahim enaig sihifinimba eso Pol wasanam ikana. ");
INSERT INTO amn_n_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Afa minginag el Polim pahlukunam eso Ainiyagim onigini. Afa mungo pahlukuiag el eba Dionisius ehe Areopagus nai amunai el. Mingba angwafig unehlagba Damaris fena afa minginag el apaigona. ");
INSERT INTO amn_n_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Afa Pol Atens wahianam Korin gam ikana. ");
INSERT INTO amn_n_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Afa enanai yi ehe Ju el Akwilam ufana. Afa Akwilana mog kimbigba Pontus ehe heafna angwag i Prisila managig hwainig Italim ahwahianam Korin gam ahkana. Ahnaig esenaba, eba Romna misog el Klodius sihini mungwali Ju el so ma Rom kimbig wahinim ahui. ");
INSERT INTO amn_n_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Akwila i Prisila i sel lala kwaligig el gwenaig Polna gafugag lofug. Eso Pol ehem ika nangwagenam mwakwalig augunam eso ena gafugafini. ");
INSERT INTO amn_n_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Mungwali Isug Auguia Osuna Pol Ju elni nuwagig lala ika sahufenam sihinigeafna afa ehe ogna Ju el mi Grik el mi hekusihianige og ma Ainiyagim onigi. ");
INSERT INTO amn_n_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Afa mahim Sailas i Timoti i Masedoniam ahwahianam ahbonaba Pol heafna gafugag mo wahianam afa higeg Ainiyagna mom gafugafegofna. Ehe hugna Ju elim kifutig mo sihini og, “Sisas eba Godna Gishu Wahiag el elim wambf.” ");
INSERT INTO amn_n_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Afa Ju el mas ena mom membini mo afa ehengel Polim amtakwalig mo sihinaginiba eso Pol heafna nihinai lofug wa nai nohusige buabufehiagenam afa esona og, “Ka nem inim mo sihinigbi afa ne mas fatinig eso God kam mas esonai. Eba ne mungwag nimbeafena tautig amtakwalig wambuf. Afa yawamba eba ka afwambanai elim oku sihinif.” ");
INSERT INTO amn_n_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Afa Pol Ju elni nuwagig lala mo wahianam pugunam ika Titius Jastusna lala gafena. Ena lalaba nuwagig lala muhwa gofena. Ena elbi afwambanai eba Godna unehlag fingi feule. ");
INSERT INTO amn_n_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Afa Krispus eba Ju elni nuwagig lalana amunai el fena afa ehe fenam heafna mungo lala nai apaigona afa Korin nai el enaksag apaigona enag Godna mo higinim afa olug wahigifinim eso bu wa apaigona. ");
INSERT INTO amn_n_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Mungo sinaini Pol itiwa lofug nanguna. Afa Ainiyag ehem sihina og, “Nofeka embefe. So na hugna sihiakafum. Nofeka mwahlai gofim. ");
INSERT INTO amn_n_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Eba ka ne i ahgofuf. Mas nem aman amtakwale fati eba ati kana el numb fiahsaieg ena kimbig wa.” ");
INSERT INTO amn_n_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Eso Pol enanai yi mungo yia fena afa haf fena enaig wa ganam Godna mom ogfu fenugena. ");
INSERT INTO amn_n_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Enanam mahim Galio eba Akaia nai provins misog el fenamba enanam Ju el nuwagnam ogna Polim ahanaig minafenagi afa so ehem finim misog el nangum wanigahunam eso ma misog el kwefihianage. ");
INSERT INTO amn_n_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Afa ehengel enaig esogona og, “Sonag elbi elim wambugum hekusihiageg Godum lotu fenigim eba bigelni nihe mo flafug.” ");
INSERT INTO amn_n_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pol og nawo wahigi sihin afa Galio Ju elim esoni og, “Ateaho nengel Ju so na enaig esogog sona elbi ehe hugna amtakwalig eseageg enag kog kawo nengelni mo higinam eso ehem kwefihianage. ");
INSERT INTO amn_n_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Afa ne hugunam unehlag mi afa nimbiafgelni nihe mo mi ne sislafofiagig. Enam kam kusig, neaga nimbefum ehe so na kwefihiagi.” ");
INSERT INTO amn_n_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Afa so ehe Ju elim enanai ningitigina. ");
INSERT INTO amn_n_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Afa ehengel olug kakagini eso Ju elni nuwagig lala naim amunai elim Sostenisim kikehlinim kot lala muhwa tigekini. Afa Galio mas enaigim onigina mo. ");
INSERT INTO amn_n_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Afa Pol Korin wa mwakwaliganam eso Kristenim mo wasanam. Afa so Akwila mi Prisila mi wanikana bot wa wanfukonam eso Siria gam ahuna. Pol akafenaba Senkria wa samawina eba enaig esenaba eba wagfug ehe ati Godum mo sihi wahiana. ");
INSERT INTO amn_n_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Afa ahu Efesus wa opukonam Pol Prisila mi Akwila mi mo wasanam ehe mo ikana Ju elni nuwag lala sahunam Ju elim mo wansihiagena. ");
INSERT INTO amn_n_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Afa minginag ehem sahanagini og, “So na kam mwakwalig ohunanai.” Afa ehe og, “Ka mas enaig ese.” ");
INSERT INTO amn_n_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Afa awasan fenamba ehe enaig esona og, “Afa God sawiyi fegba eba ka piske bof.” Afa so ika bot wa mo fukonam Efesus mo wahianam ikana. ");
INSERT INTO amn_n_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Bot wa ikan Sisaria wa pugunam ika Jerusalemna sios elim ika nangwagena. Ika nangwagenam eso Antiok gam ikana. ");
INSERT INTO amn_n_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Pol enanai yi mwakwalig ganam afa wahianam ika distrik Galesiana kimbig mi afa Frigiana kimbig mi enanai yi Kristen elim kifutihiagena. ");
INSERT INTO amn_n_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Afa enanam Aleksandria wanai Ju el Apolos ehe bo Efesus wa gafena. Ehe lahlag sihifeafena afa ehe ati Godna bukim numwehe anwanafena. ");
INSERT INTO amn_n_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Enaba ati numwehe Ainiyagna minam wagfufenagini naso afigigenam ena mo sihinaba afa ena mo inimfena. Afa ehe mas anwanafena mo Sisasna unehlag wa bu wa apaiyegim eba Jonna bu wa apaiyegim mungo anwanafena. ");
INSERT INTO amn_n_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Afa ehe ikanam Ju elni nuwagig lala hugunam sihinaba eso Prisila i Akwila i ahiginam afa ahsulfanam heafningina lala gam ahwanikinam enanai yi numwehe minginag mo Godna minam wagfufenag ahfena. ");
INSERT INTO amn_n_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Afa Apolos ogna Akaia gam ika afa Efesus nai Kristen ogna ehem kweagfu. Eso pas ginofinim Akaia Kristenim faigona og soma ehem sulfi. Afa mahim Apolos Akaia wa pugunam eso Kristenim enanai yi hugna kwagana. Enag elbi God ati afafenigbi eso ehengel Godum oniginig. ");
INSERT INTO amn_n_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Afa Apolos Ju amunai elim mo soaginim afa ambagwa hugna ehengelni mom pigawampupenam eso ehe Godna bukim ambagwa wagfuni og, “Sisas eba God Gishu Wahiag el elim wambugum.” ");
INSERT INTO amn_n_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Afa mahim Apolos Korin wa gafenaba Pol mahimsi mina wa wagiebon eso Efesus wa mo puguna. Enanai yi pahlukuiag elim nangwagina. ");
INSERT INTO amn_n_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Afa ehengelim sahtigina og, “Mahim ne olug oniginiba ateaho ne Godna Sungwagba wambug?” Afa wahigi sihini og, “Awai, ka mas higini mo Godna Sungwag gohugba.” ");
INSERT INTO amn_n_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Afa Pol sahtigina og, “Ateaho, eba ahanag bu wa apaiyeg ne fig?” Afa wahigig sihini og, “Jonna bu wa apaiyeg ka fig.” ");
INSERT INTO amn_n_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Afa Pol sihina og, “Jonba enaig esena amangel olug wahigifigbi eso bu wa apaigoafena. Afa ehe elim og so olug onigini el so sum obo eba Sisas.” ");
INSERT INTO amn_n_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ena mo higinim eso Sisas Ainiyagna unehlag wa bu wa apaigona. ");
INSERT INTO amn_n_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Eso Pol ninga ehengelim sisi fakanimbi eso Godna Sungwag ehengelim bo gohunimba eso ehengel ahanaig ahanaig mona fiahgini afa Godna mo fi sihiule lofug fifini. ");
INSERT INTO amn_n_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Enag kwamblogna nambaba gwesim hili 12 fena muhwa fena. ");
INSERT INTO amn_n_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Afa sambaga mungo was yi Pol Ju elni nuwagig lala fakafegofena mo sihiagim afa ehe soaginim afa hugna sihinigeafna mas embefena mo ehe wagfuni Godna bog meg inim feg. ");
INSERT INTO amn_n_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Afa minginag el ena mo higigim eyapusogona afa ehe Ainiyagim onigigim kusini afa elni nof wa Kristeneg minam molampiagini eso Pol nuwagig lala wahianam minginag Kristenim wankana. Afa mungwali osuna eso ikafna Tiranusna anwana lala sahufenam sihiageafena. ");
INSERT INTO amn_n_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Gwenaig esegohum ikan sambaga yia fena. Eso Ju el i Grik el i enanai yi Esia provins wa gofena enag Ainiyagna mo higini. ");
INSERT INTO amn_n_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","God Polna ninga wa ahanaig ahanaig kigmog wagfuiagena. ");
INSERT INTO amn_n_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Afa el hankisip i lofug plefwag i wambfinim ogohufenam Polna nihi yi nana tuhfinim eso wambugenam gih elim wambwai goafenamba eso gih i nimbasa i wahia ahuafena. ");
INSERT INTO amn_n_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Afa minginag Ju el ahufeanim Ainiyag Sisas unehlag wa ogna nimbasam ningitigif. Afa ehengel nimbasam enaig esogoni og, “Sisasna unehlagim Pol sihiba enag ka nem sihinigbi so ika.” ");
INSERT INTO amn_n_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Afa Skeva eba Ju el ehe misog pris heafna luwalig enwesog wa gohna. Enag el nimbasam enaig esegonugini. ");
INSERT INTO amn_n_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Afa nimbasa amtakwalig ehengelim sihini og, “Sisasba kati anwanafeg afa Polba kati anwanafeg afa nengelbi amangel?” ");
INSERT INTO amn_n_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Afa ena el nimbasa amtakwalig ehenai yi gohoule sofuku kugunam hugna kwaskofiahkanaba lofug mo hugfuoaiti gifenimbi eso ehengelni nihi buagmalig fiahsainam eso taf puko peminefena so lala mo wahinim nihig bihig embem ahuna. ");
INSERT INTO amn_n_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Afa Efesus wanai Ju el i Grik el i mahim ena mo higinim eso hugna embefeagenim so Sisas Ainiyagna unehlam hugna fingi fini. ");
INSERT INTO amn_n_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Afa el numb autunam so ahanaig ahanaig eseagini enag Ainiyagim onigini enag ambugog minginagna elni nof wa heafgelni ahanaig ahanaig mo sihiagini. ");
INSERT INTO amn_n_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Afa el numb agisu ule afa wini ule enaig eseagifini ena buk amtakwalig angogluinim eso elni nof wa suwi wa wehlini. Mungwali ena bukba suwiginimbi eba 50,000 kina enaig fena. ");
INSERT INTO amn_n_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Enaig esifinimbi eso Ainiyagna mo kifutinam eso pugu mungwali kimbig ikaminefena. ");
INSERT INTO amn_n_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Afa mahim enaig esinimbi eso Pol ogna Masedonia afa Akaia gam pugunam eso Jerusalem gam mo ika. Ehe og, “Ati ka osumba nangug afa ka so Romim gaba ika nangu.” ");
INSERT INTO amn_n_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Afa so Pol Timoti mi Erastus mi Masedonia gam ningitigina. Eheningi Polim ahkweg fwafena. Afa Pol mo Esia Provins wa mahimsi gafena. ");
INSERT INTO amn_n_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Enanam Efesus el hefum hugna flafihiagini afa fiflafeagini Ainiyagna minam. ");
INSERT INTO amn_n_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Afa Demitrius Efesus wa nai el heafna gafugagba silva fiageule. Afa silva fafenam higfehiagefenam wetiklug lotu lala lofug gafugafeafna. Ena lotu lalaba ofenaiba Artemisna nalig lotu lala Efesus wa gofena. Artemis eba Efesusna god angwafig. Demitrius fena afa minginag gafugag el apaigona ena gafugagna kig nalig fifini. ");
INSERT INTO amn_n_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Afa heafna gafugag el mi afa minginag gwenag gafugag wa nai mi unetiginam ma nuwaganamba. Ehe enaig esona og, “O nilite, ne ati ne anwanafig big enaksag kig ena gafugagna big fig. ");
INSERT INTO amn_n_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Afa big higigim nangug Pol so eseageg. Ehe enaig esog god el ningina gafugafegba eba mang god mo. Eba ehe Efesus wa nai el mi afa Esia provins wa nai el mi ehengelni onigigim gasaf wambuf. ");
INSERT INTO amn_n_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Afa gwenaigba ikafiba eba el bigna gafugagim moalampbi fi. Afa bigelni nalig god angwafig Artemisna unehlagba amtakwalef. Afa mungwali el Esia provins nai afa mungwali bite enanai yi go ehena unehlagim so fingi fig. Enag masa enaig onigif Artemisba eba kifutig awai afa heafna lotu lala eba isug gofuf.” ");
INSERT INTO amn_n_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Afa mungwali ena mom higinim olug kakagiagini afa kifutigni wagini og, “Bigelni Efesusna Artemis eba ehe sisi fenig.” ");
INSERT INTO amn_n_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Afa managig hwainig mungwali kimbig bigiagafenam. Afa Gaius i Aristarkas i Pol Masedonia nai wanbona, eheningim wambtinim nuwag guhug wa ikagna wanahuna. ");
INSERT INTO amn_n_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pol ogna ika el nai yi olyi pugu afa so pahlukuiag el ehem kweni. ");
INSERT INTO amn_n_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Afa minginag Esia provins wa nai misog el afa Polna hihe gaba, ehem mo ningihini og, “Nofeka enanai yi nuwagig guhug waba ika.” ");
INSERT INTO amn_n_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Afa el nuwagnam etetiagenim hefum sahigini. Afa minginag enmuna onigig flifinim hugna wagfini. Afa minginag gaba gwenaig esiagini. Afa enaksag mas ena mog nuwagigim anwanafini mo. ");
INSERT INTO amn_n_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Afa Ju el Aleksanderim hekusi ningihini ogma olyi gohnam eso ma mo faiyi. Eso ma ika gohnam ningana kweni afa ehe ogna mungwali ehengelim enaig sihifeni Pol eba mas mang eseg mo. ");
INSERT INTO amn_n_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Afa nangunim enag elbi Ju el eso sambaga aua mungo mengna hugna wagini afa esogona og, “Bigelni Efesusna Artemis eba ehe sisi fenig.” ");
INSERT INTO amn_n_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Afa kimbig wa nai misog el bihianam kwenim eso sihini og, “Efesus luwal sahig, mungwali el bite wa gohka enam ati anwanafig bigelni kimbig Artemisna lotu lala mi afa heafna uflog hun mi of wa nai pena enag big numwehefugu. ");
INSERT INTO amn_n_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Afa mas aman esoi eba mas inimfeg mo. Eba awai. Eso ne afafug augu. Nofeka ikagna ahanaig esego. ");
INSERT INTO amn_n_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Ne ati enag elim ohunanai yi wanambugo afa eheningi mas ahanaig esahfeg mo. Afa mas bigelni god Artemisim moalamp ahfeg mo afa ehena lotu lala mas okwef ahfeg mo. ");
INSERT INTO amn_n_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Afa Demitrius feg afa mungwag gafugag el apaiyeg afa atiamba ahanaig kinig figbi eba ati mina feg so big wahibi, so ma heafa sonag el kotime goni afa kwefihiageg el ati feg. ");
INSERT INTO amn_n_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ati amba ne ming mo fegba so na ningenim eso ne nengigim amunai elni nof wa sihiageba so ma enam kwefihianagi. ");
INSERT INTO amn_n_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Afa yawo osuna big el numb nuwagigim mo flafihiagig enag nuwagimba mas mog feg mo. Atiamba Romna misog el bigim kotim ofenfibi eba bimbeafgelni moawa. ");
INSERT INTO amn_n_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Afa ehe gwenaig esenim eso elim ningitiaminefena.” ");
INSERT INTO amn_n_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Afa enag flafihiagig mo mahim wesig fenaba eso Pol Kristenim awamonim eso kifutihiagenam og ne yi auguiafuf. Afa so enana mo wahianam eso Masedonia gam ikana. ");
INSERT INTO amn_n_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Afa enanai yi enaksag kimbig fapugu fiahkafnaba enaksag mo elim kifutihiageikan ika Grik wa ika pugunam enanai i sambaga mungo was fatina. ");
INSERT INTO amn_n_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Afa Pol Siria gam bot wa ikagim ofefnamba eso higina Ju el mo sihiag ofifinibi ogna ehem tigi eso ehe ming onigig fanam og naso Masedonia mina gam eso Jerusalem gam piske ika. ");
INSERT INTO amn_n_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Afa Sopater Pirusna leg eba Beria nai el afa Aristarkas i Sekundus i afa sambaganigi Tesalonaika nai afa Gaius Derbe nai fena afa Tikikus i Trofimus i eba Esia nai ahfena afa Timoti fena eso mungwali Pol wanikana. ");
INSERT INTO amn_n_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Afa ehengel gof ahunam Troas wa kangelim nengegon nafafiba. ");
INSERT INTO amn_n_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Afa buyis Bret Yist Hwainig awaiyeba eso kangel Filipaim wahinim bot wa ahuf. Afa mahim afa wa pugufeg osuna awaiegba eso ka ahu Troas wa mo opukonam enag elim wambuf. Enanai yi elegeg wa gohug osuna ka fif. ");
INSERT INTO amn_n_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Afa Sande kangel nuwagnam Ainiyagna fane fini. Afa Pol ogna lawam ika afa so ehe Godna mo sihiagegohun ika mongokuk liputegna puguna. ");
INSERT INTO amn_n_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ena lala meg ka nuwaganamba eba sisyi gofna afa enanai yiba enaksag lam kagi hwatini. ");
INSERT INTO amn_n_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Afa luwal kwamblog heafna unehlagba Yutikus ena lala meg sigagwa agafenamba noftuta fiaufena. Afa mahim Pol mo mungwanam sihiagofnaba eba ati nongifini afa ehem so noninai bite gam tigefu pekana. Afa apaigona kikehlinimbi ati wahana. ");
INSERT INTO amn_n_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Afa Pol penam ehena nihiginim ningana kikenagenam afa esona og “Nofeka kusguni eba nofkena gi.” ");
INSERT INTO amn_n_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Afa piske sisyi megig gam fukoli ahunam afa Ainiyagna fane finim afa fane mo ahgagini. Afa mo sihiagiafan ikan si ambafiakanaba Pol wasana ikana. ");
INSERT INTO amn_n_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Afa ena luwal piske bihianamba eso heafna lala gam wanigahuna, afa so ehengelni olug lahla feskofena. ");
INSERT INTO amn_n_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Pol kangelim esoni og, “Ne gof sip yi Asos gam ahuf afa kaba bite mina sum bof. Afa enanai yi so ka nem bo wambunam so big sip yi mungwal ahuf.” Eso ka enaig esini. ");
INSERT INTO amn_n_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Afa mahim ka ehem Asos wa ufinim eso ehe sip yi fukonamba so ka mungwal Mitilini gam ahuna. ");
INSERT INTO amn_n_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Afa ka sip yi Mitilini wahinim afa ming osuna ka Kios wa opukonam afa ming osuna ka Samos wa opukonam afa ming osuna ka Miletus gam opukona. ");
INSERT INTO amn_n_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pol ogna Jerusalem gam ikagna ika puguiba soma Pentikos buyis pugui. Afa ehe oniginam masa ka se hugna Esia provins wa gafuf eso ka sip yi Efesusim kwegfu ahuna. ");
INSERT INTO amn_n_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Afa Pol Miletus wa gafena Efesusna sios amunai elim mo ningihiana og, “Kam ambugog nangu.” ");
INSERT INTO amn_n_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Afa mahim ambugog opukenamba afa esoni og, “Yuwana ka Esia provins wa pugunam nem nangwagnam afa bo yiauwofeg enamba ati ne anwanafig eso ka ahanaig ahanaig esagena. ");
INSERT INTO amn_n_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Afa Ju el ogna kam ahanaig ahanaig minafenaginim eso tigifati eso enam ka kinig fag. Afa ka kefum ahnai skaufegim eso ka nombna Ainiyagna gafugafeg. ");
INSERT INTO amn_n_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ne ati anwanafig ena mo so nem kwaganig eba ka mas kehlagufi. Eso ka nem nuwagig guhug wa i afa nengelni mungo mungo lala i sihinigiafena. ");
INSERT INTO amn_n_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ju el mi afa Grik el mi ka gwenaig esonig so olug waikifinim Godum onigini eso Sisas Ainiyagim olug onigina hufum. ");
INSERT INTO amn_n_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Afa yawo Sungwag kam hekusenagba ka Jerusalem gam aka afa ka mas anwanafeg mo enanai yi mang kam fef. ");
INSERT INTO amn_n_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Afa kati anwanafeg mungwali kimbig ka ikaba Godna Sungwag kam sihina el kam ogna kalabus yi fatinim afa ahanaig ahanaig kinig kam pugunafe. ");
INSERT INTO amn_n_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Afa ka mas onigig kikefumba afa kaba mungo onigig feg Ainiyag Sisas gafugag kam faig ka so gafugag okwian augi enaba Godna afafeg lahlag mo ka sihiageg. ");
INSERT INTO amn_n_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Afa ka mungwali kimbig wagiakafna Godna bog meg mo nem sihinifini. Yawo ka nem wasanigba afa ka anwanafeg ne mas kam piske nangui. ");
INSERT INTO amn_n_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","27","Ka mungwali Godna sawieg mo faig mas ka mungo kumwahlag mo. Eso ka nem inim osihin aman mungo awaiegba eba mang kana moawa mo. ");
INSERT INTO amn_n_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Afa Godna Sungwag nem siosna misog el kanog hwatig eso nimbefum mi afa mungwali sios el mi numwehifim eso el sipsipim nangwaghiagfafef eso enaig fi. Enamba ati Ainiyag heafna tafna enag elim mungwali wambug. ");
INSERT INTO amn_n_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ati ka anwanafeg mahim ka nem wasanig ikaiba minginag el ogna ambugog nem amtakwalhiagi. Enaig sangwali mawang lofug ambugog sipsipim kwaskofif. ");
INSERT INTO amn_n_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Afa minginag nengel nai opukonam wahigifenam nem mwakwal mo sihigonigba eso ehengel membeg ne ehengelim pahlugahuf. ");
INSERT INTO amn_n_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Eso enam numwehifibi afa nofeka eteti sambaga mungo yia osuna sinaini higeg ka nem nombna wahe sihinifini. ");
INSERT INTO amn_n_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Afa yawo ka nem Godna ninga wa awasan afa heafna afafeg mo soma nem kwagani eso nengel lahlafifig afa enaigba God heafna elim enaig esenig. ");
INSERT INTO amn_n_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Ka mas amana silvam, golim afa lofugum membena mo, eba awai. ");
INSERT INTO amn_n_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ati ne anwanafig ka mas nem esoni ka kike kiafena ningana gafugafegim kefum feg afa kikeafena mungo gafuganaim kweafug. ");
INSERT INTO amn_n_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Enaig ka mungwali eseagegba eba ka nem wagfunug so big minginag euwiaug elim kwaganim. Afa ka Sisas Ainiyagna mo onigig ehe enaig esog ‘Afa enanam ne fagba eba lahlafeg afa enanam ne faigba eba hugna lahlag nemug feg.’” ");
INSERT INTO amn_n_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Afa mahim Pol mo sihi wahianam eso ehe ehengel enanam mongkokini kwakwagenim so betenini. ");
INSERT INTO amn_n_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Afa ehengel mungwali wewatonam afa ehem ningana kikenagim eso esogona nasabam eyi ne ikafif. ");
INSERT INTO amn_n_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Afa ehena mom oniginim eso ehe esona ehengel ehem mas piske nangui afa so ehengelni olug hugna kinia skofena. Afa so sip gim wanigahuna. ");
INSERT INTO amn_n_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Afa kangel ehengelim wasanam afa misosuf bot wa ahuna Kos ailan wa opukona. Afa ming osuna ka Rodes wa ahu opukonam eso Patara kimbig wa opukona. ");
INSERT INTO amn_n_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Enanai yi ka nanguni sip Fonisia gam ogna ika. Afa ka fukolinim eso ka ahuna. ");
INSERT INTO amn_n_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Afa ka sip yi ahuian ailan Saiprus nangunim afa kwefunim Siria provins gam ahuna. Afa Tair kimbig wa ka opukonam eso enanai yi sipna gawig suguni. ");
INSERT INTO amn_n_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Afa kangel minginag Kristenim wambinim eso enag el ka mungwali auguna enaig mungo wik. Afa Godna Sungwag enag elim onigig faini eso Polim sihini og, “Nofeka Jerusalem gam ika.” ");
INSERT INTO amn_n_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Afa mahim sip ena kimbig ogna wahia ikaiba eso enag el heafgelni angwafig luwal kimbigim wahinim bu blugum wanahuna. Enanai yi ka mungwali mongkokini kwakwaginim beten fafif. ");
INSERT INTO amn_n_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Afa kangel esogona “Nasabam eyi auguiafuf.” Afa so kike mo sip yi fukolinim afa ehengel piske lala gam ahuna. ");
INSERT INTO amn_n_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Afa kangel Tairim wahinim ahuian Tolemes opukona. Afa enanam Kristenim wambinim afa mungo osuna ka auguna. ");
INSERT INTO amn_n_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Afa lawam ka wasanim ahunam Sisaria opukona. Enanai yi ka Filipna lala auguiafena. Ehe Godna lahlag mo sihiaule. Autunam aposel elegeg el kanog hwatini eso ehegelim kwagani afa Filip ehengel nai. ");
INSERT INTO amn_n_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Heafna sambaga sambaga angwaming angwafig luwal eba Godna mo fi sihiaule el. ");
INSERT INTO amn_n_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Afa kangel mwakwalig augunam afa Agabus eba Godna mo fi sihiaule el ehe Judia nai wahia bona. ");
INSERT INTO amn_n_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ehe bonam Polna afiai hugufa hefum mong mi ninga mi enana kikenaginam afa esona og, “Godna Sungwag enaig sihifeg ‘Jerusalem wa nai Ju el amanim heafna afiaini kikenagifi eso gwenaig esef, afa ehem angoluwagna ninga wa fakif.’” ");
INSERT INTO amn_n_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Afa higinim kangel afa mungwali Polim kifutig mo sihini og, “Nofeka Jerusalem gam ika.” ");
INSERT INTO amn_n_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Afa Pol wahigi sihina og, “Mang fegba afa ne wewatig eso kana olugum kinig feg. Enanam ka Jerusalem wa Sisas Ainiyagna gafugafef afa enanai yi kam kalabus yi fati afa kam tigifati eba kati numwehego. Eba mang ka fiah mo.” ");
INSERT INTO amn_n_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Afa ehena onigig kifutigna eba mas onigig wahigifena mo. Eso kangel wahiana esoni og, “Soma Ainiyagna sawieg esif.” ");
INSERT INTO amn_n_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Afa enaig esenim eso kangel numwehiaginim Jerusalem gam ahuna. ");
INSERT INTO amn_n_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Afa minginag Sisaria nai pahlukuiag el wanahunam, afa Nasonna lala wanambugona eso kangel enanai yi auguiafena. Nason eba Saiprus nai el ehe yuwana pahlukuiag el fena. ");
INSERT INTO amn_n_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Afa mahim Jerusalem wa opukenamba Kristen el kangelim nangwaginim afa sifakalini. ");
INSERT INTO amn_n_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Afa ming osuna Pol afa kangel Jemsim nangugum ahuna. Afa enanai yi siosna amunai el nuwagigna. ");
INSERT INTO amn_n_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Afa Pol esonim eso ehengelim sihinigena mungwali lahlag gafugag God afwambanai elim esenugeg. ");
INSERT INTO amn_n_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Afa higinim Godna unehlag fingi fini. Afa Polim esuni og, “Nilite, numwehe enag anwanafenam afa enaksag Ju el kifutig Mosesna nihe mom onigig eba Sisasim olug onigig. ");
INSERT INTO amn_n_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Afa minginag enaig esogog ne ati sihig Ju elbi afwambanai elim mungwal auguia so Mosesna nihe mo mas fatig afa ne ehengelim sihinig nofeka nimbiafgelni fangona luwalna lofug wesig kofifatini eso bigelni nihem mas pahluhug mo. ");
INSERT INTO amn_n_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Eso mang big esif? Afa ehengel higifi ne ati bog. ");
INSERT INTO amn_n_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Afa kangel membig so na enaig ese. Afa enag sambaga sambaga el Godum ati sihi wahini. ");
INSERT INTO amn_n_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Afa kangel membig so na sonag elim Godna Nalig lala gam wanahunam afa Juna nihe mom pahluhug eso nengel afsug auguf. Afa nimbe enag gafugagim kig faif eso ma enag el heafgelni lapug wigoni. Afa ne enaig esibi mungwali anwanafif amtakwalig mo nem esinig eba mwakwaleg. Afa nem inim bigelni nihem higeg pahluku. ");
INSERT INTO amn_n_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Afa kangel afwambanai Kristen elim kikeafgelni onigig ginofinim ati ningihigoni. Ka ehengelim enaig esogoni og, ‘Sa nofena fane nimbasam faigog ahga, nofena taf ahga, afa nofena sis wena kihlagba ahga, afa nofena aga taitufi.’” ");
INSERT INTO amn_n_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Afa ming osuna Pol enag sambaga sambaga elim wambtiginim eso enaig nihem pahlukuiba so ma afsug augui. Afa ehe Godna Nalig lala gam ikanam prisim mo sihina amansi ehengel enag nihem auwigig. Afa amansi ambugonam ehengel mungo mungo Godum sis tuhlu faif. ");
INSERT INTO amn_n_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Afa enag elegeg gohug osuna meini fenaba afa minginag Esia nai Ju el Polim Godna Nalig lala wa nanguni. Afa enaksag elim olug fuko wasanim afa Polim ningina kehlini. ");
INSERT INTO amn_n_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Ehengel unegoni og, “Israelna luwal kam kwagani. Sonag elbi mungwali kimbig elim sihini fiahkag afa enaig esog Israel nai el i, Mosesna nihe mo i, afa ohuna Godna Nalig lala eba isug. Afa afwambanai el ese Godna nalig lala gam sahu kaf afa yawo Pol afwambanai elim Godna nalig lala sahu wanbogum eso enag afsug lalam Godna nof wa amtakwale skofig.” ");
INSERT INTO amn_n_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Afa minginag el Trofimus mi Pol mi nangwaginimbi kimbig wa ahkafena. Trofimusba Efesus wanai el. Afa enaig onigini Polba enag afwambanai elim Godna Nalig lala sahug wanikig eso ehengel enaig esogona.) ");
INSERT INTO amn_n_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Afa kimbig wanai el etetinim eso kikini fambugofinim Polim kikehlinim Godna Nalig lala menai hugufi afwambagam okuhunam eso ikagna mengig mo kikisini. ");
INSERT INTO amn_n_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Afa Ju el ogna Polim tigi afa Rom wanai soldiana misog el enaig higina og Jerusalem el hefum fagahag. ");
INSERT INTO amn_n_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Eso ehe heafna soldiam ikagna wanika wan opugu fenamba eso Ju el ehem nangwagnim eso Polim wahini. ");
INSERT INTO amn_n_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Afa enag misog el ika Pol nai yi muhwa pugunam og kikehlinim sambaga sen na kikenaginim afa so sahini og, “Eba aman afa mang mai fegba?” ");
INSERT INTO amn_n_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Afa minginag el mungo onigig finim hugna wagini afa minginag mo enmuna onigig fini eso misog el mas ehengelni mom numwehe anwana fenugena mo. Eso misog el soldiam sihinimbi afa so ehem soldiana auguiag lala gam wanig ahuna. ");
INSERT INTO amn_n_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","36","Afa enag el numb pahag ahuiafenamba hugna esogona og, “Sohna mo tigifaki.” Afa soldia wanig ahu ling muhwa wanig opukof fenamba afa mungwali el ogna tigifati eso soldia Polim ningana fukui oguhuna. ");
INSERT INTO amn_n_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Afa soldia ogna Polim lala megam sahu wanig ahuf fenamba Pol misog elim sahna og, “Kogna wesig mo sihiagaf.” Eso misog el sahna og, “Ei, namba Grikna mo anwanafe ule ho? ");
INSERT INTO amn_n_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Afa kawo kog namba Isip yi nai el autunam enag el gavman i biga gafenam 4,000 fagule elim wambinam bite bihig gam embem wanahuna. Eba mang namba enag el mo.” ");
INSERT INTO amn_n_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Afa Pol wahigi sihina og, “Amo, kaba Ju el. Afa kikeafena kimbigba Tarsus Silisia nai na provins. Kana kimbig nalig unehlag feg eso kam sawiyi fenaiba ka so mungwali elim mo sihinige.” ");
INSERT INTO amn_n_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Afa mahim misog el sawiyi fenamba eso Pol ling yi guhunam ninga na kwenim. Afa mahim el sifinamba eso ehegelim Hibru mo na sihini. ");
INSERT INTO amn_n_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Afa Pol sihini og, “Amunai i nilite i sahig kana mom.” ");
INSERT INTO amn_n_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Afa ehe mahim Hibru mo na sihinaba ena mom higinim eso ehengel hugna mwahlai sifina. Afa Pol mahimsi sihiagofena. ");
INSERT INTO amn_n_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Kaba Ju el. Kikeafena kimbigba Tarsus Silisia nai na provins. Afa ka bog ohuna nai yi numbig. Afa Gamaliel kam numwehe bigelni simbianga na nihe mom wagfunagena. Afa Ka Godum hugna membenagim eso ka kifutig gafugafeg ehem pahlukuiagim eso ne yawo gwenaig esi. ");
INSERT INTO amn_n_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Afa amangel Kristen na mina ahuiagim ka ehengelim ahanaig ahanaig esehiagena. Ka kwamblo mi angwafig mi wambufenam kalabus yi aitiafnaba eso mingnag pigihiana. ");
INSERT INTO amn_n_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Afa misog pris i mungwali kaunsil i ati anwanafini kana moba inimfeg. Autunam ehengel kam pas wa kifutig mo ginof fainibi eso ka Damaskus nai Ju amunai elim fai, eso koka Damaskus gam ikanam Kristen elim sen na Jerusalem gam kike wambuf eso ma amtakwalig hiagi.” ");
INSERT INTO amn_n_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Afa ka ikan osu misosuf gigini Damaskus wa opugufenamba eso ikana heven wanai afwambusug nalig kam wagfig fakana. ");
INSERT INTO amn_n_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Eso ka bite wa pe gifinimbi afa ka elni mengigim higina kam sihina og, ‘Sol, Sol! Ahanaig esenaba so na kam amtakwali afana?’ ");
INSERT INTO amn_n_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Ka sahna kog, ‘Ainiyag, ne aman?’ Afa ehe esona og, ‘Kaba Sisas Nasaret wanai eso ne kam amtakwali afana.’ ");
INSERT INTO amn_n_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Afa el so ka ahuna ati ehe afwambusugbi nanguni afa mas ehena mengig higini mo eso kam sihina gofena. ");
INSERT INTO amn_n_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Afa ka sahna kog, ‘Ainiyag, mang ka fef?’ Afa Ainiyag esona og, ‘Buihianam ika Damaskus gam sahoka. Afa enanai yi so nem el sihinaf enag mungwali gafugag God nem wahianag eso ne esef.’ ");
INSERT INTO amn_n_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Afa enag afwambusug nalig nofugum kam tonbusinaba eso kikeafna hihe ambugonam kam ninga na kikehlinim Damaskus gam wani saho ahuna. ");
INSERT INTO amn_n_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Afa enanai yi Ananaias gafena. Afa enag el Godna nihe mom lahlag pahlukuf ule afa enanai mungwali Ju el ehem hugna lahlafe fini. ");
INSERT INTO amn_n_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ehe kam nangunam eso ehe bo ka nai yi muhwa pugu gofenaba afa sihina og, ‘Kana nilite Sol, so bahia ninofe.’ Eso ka ikagna ehem nanguna. ");
INSERT INTO amn_n_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Afa Ananaias kam sihina og, ‘Bigelni simbianigana God nem wahianag eso ehena sawiegim anwanafenam afa Sisas Godna lahlag elim nangunam eso heafna mengigim higina. ");
INSERT INTO amn_n_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Afa eba ne ikanam elim Godna ahanaig ahanaig sihinugef afa so na mang nanguna afa higina enam ne sihinif. ");
INSERT INTO amn_n_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Eso nofeka awauyife. Bihianam bu wa penam Ainiyagim unenaiba eso ma neana nuwehfumo gigiafenai.’” ");
INSERT INTO amn_n_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Afa ka Jerusalem gam piske bonam afa mahim ka Godna nalig lala sahu beten fiaufenaba eso wa itiwa lofug nanguna. ");
INSERT INTO amn_n_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Afa ka nangug Ainiyagim afa ehe kam esona og, ‘Afa kana mo faigbi eso el ena mo mas fig mo eba so na ikagna Jerusalem wahianam ika.’ ");
INSERT INTO amn_n_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Afa ka sihina kog, ‘Ainiyag, mungwali anwanafig amangel so nem olug oniginig eso ka enag elim mungo mungo nuwagig lala nai wambkafena eso kwaskofefena kalabus lala aitiafena. ");
INSERT INTO amn_n_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Afa mahim el neana gafugag elim Stivenim tigifatinimbi ka gaba enam sawifena afa ka ehengelni lofug nangwagofena.’ ");
INSERT INTO amn_n_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Afa Ainiyag kam enaig sihifena og, ‘Amo se ika, ka nem wahigwa yi afwambanai gam ningihiaf.’” ");
INSERT INTO amn_n_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Afa mungwali el sumi yi mo higinim afa olug kakageagini ming mo higigim kusini. Ehengel hugna waginim esogona og, “Sonag elimbi so gwesim tigifati. Ese gofuf.” ");
INSERT INTO amn_n_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Afa ehengel waginim afa lofug fuluwal fagifini afa smof ehigifinim sisi gam taitufifini. ");
INSERT INTO amn_n_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Afa soldiana misog el heafna elim esoni og, “Polim nimbiafgelni lala gam wanig ahu. Afa wena flakflakefinim eso mog gim sahanagi asegba Ju el nem wagnig.” ");
INSERT INTO amn_n_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Afa Polna ningam kikenaginim eso ogna flakflakefinagi afa Pol soldiam esona og, “Romna nihe mo enaig eseg nofeka Rom elim afgana tigeki mahim mo sihiba. Kaba Rom el.” ");
INSERT INTO amn