﻿USE sofia;
DROP TABLE IF EXISTS sofia.amn_amanab_vpl;
CREATE TABLE amn_amanab_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES amn_amanab_vpl WRITE;
INSERT INTO amn_amanab_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ena moba Sisas God Gisfu Fwahag Elni simbianingam suwigig. Ehe Devitna simbianinga afa Devit Abrahamna simbianinga. ");
INSERT INTO amn_amanab_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahamna leg Aisak. Aisakna leg Jekop. Jekopna leg Juda afa heafna nilite. ");
INSERT INTO amn_amanab_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judana legnigi Peres i Sera i. Ehenigina afag Tamar. Peresna leg Hesron. Hesronna leg Ram. ");
INSERT INTO amn_amanab_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ramna leg Aminadap. Aminadapna leg Nason. Nasonna leg Salmon. ");
INSERT INTO amn_amanab_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmonna leg Boas. Heafna afag Rahap. Boasna leg Obet. Heafna afag Rut. Obetna leg Jesi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesina leg Devit eba misog el. Devitna leg Solomon. Autunam heafna afag eba Uriana angwag. ");
INSERT INTO amn_amanab_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomonna leg Rehoboam. Rehoboamna leg Abiya. Abiyana leg Asa. ");
INSERT INTO amn_amanab_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asana leg Jehosafat. Jehosafatna leg Jehoram. Jehoramna leg Aisaia. ");
INSERT INTO amn_amanab_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Aisaiana leg Jotam. Jotamna leg Ahas. Ahasna leg Hesekia. ");
INSERT INTO amn_amanab_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekiana leg Manase. Manasena leg Emon. Emonna leg Josaia. ");
INSERT INTO amn_amanab_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaiana leg Jekonia afa heafna nilite. Enanam Babilon el Israel elim wanafunam heafgelni bite la lasani. ");
INSERT INTO amn_amanab_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Maia lasanibi Jekoniana leg Sealtiel. Sealtielna leg Serubabel. ");
INSERT INTO amn_amanab_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabelna leg Abiut. Abiutna leg Eliakim. Eliakimna leg Eso. ");
INSERT INTO amn_amanab_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Esona leg Sadok. Sadokna leg Akim. Akimna leg Eliut. ");
INSERT INTO amn_amanab_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliutna leg Elieser. Elieserna leg Matan. Matanna leg Jekop. ");
INSERT INTO amn_amanab_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jekopna leg Josep. Josep Mariana alagag. Afa Maria Sisasim wanigana. Sisasba seflig Krais God Gisfu Fwahag El. ");
INSERT INTO amn_amanab_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Afa Abrahamna simbianinga gohugum ikag Devit nai yi pugug eba 14 la gohug. Afa Devitna simbianinga afohianam enanam Babilon Israel elim ambe wanafuna eba 14 la gohug. Ena nai yi gofenaba God Gisfu Fwahag Elbi gohna eba gwenaig eseg 14. ");
INSERT INTO amn_amanab_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Sisas Krais, God Gisfu Fwahag El, gohug mo enaig eseg ehena afag Maria ati Josepim eso fwahini og ma Josepnai yi gai. Afa mas ika gana mo, afa nangunibi Maria Godna Sungwabug ati afnialigni fena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ehena alagag Josep eba suialag el. Ehe ogna ehem flagim fwaha. Ehe mo ambala sihiagim oksina afa sa mas Mariam afwanef mo faina mo. ");
INSERT INTO amn_amanab_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Josep enam onigkafnaba afa itila Godna oflanai el blona ehem puguna. Enag oflanai el esona og, “Josep Devitna simbianinga nofeka Mariam flagiba embefe. Sa hig enaba afnialigni wanigiahba el mas enaig eseg mo eba Godna Sungwabug ehe faig enag luwalba. ");
INSERT INTO amn_amanab_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Enaba fagonai luwal wanigafe. Afa ne ehena unehlagimba Sisasim unehlig asa mungwali heafna elni amtakwalig mo huguflaitinam afa ehefum lambfe asa God ehengelim mas mungwa faifi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Enaba pugunaba Ainiyag ati Godna mo fli sihiule elni mengig la sihi fwahanaba ena moba nufunam puguna, mo fli sihiule el esona og; ");
INSERT INTO amn_amanab_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Higim, angwafig mungu angwaming alagagla ga fwainig afnialigni afa fagonai luwal foklafe. Afa unehlagba Emanuelim seflife.” Enag mog unehlaba ‘God bigim wanga.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Josep ginim buihianam asa gwenaig esena Ainiyagna oflanai el asa sihinagenaba asa ehe enag angwafigbi flana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Angwafigbi flanam mas mungua kifela ahginimo awai esug afena afa asa luwal fagona waniganaba. Afa asa ehe Sisasim unehlana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Maria Sisasim Betlehemla wanigana, ena provins Judia. Enanam Herot misog el gofnaba. Afa enanam osu puguglanai anwena el, ambena Jerusalem la apukenam. ");
INSERT INTO amn_amanab_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Afa sahini og, “Hanai yi luwalba gohug eba Ju elni misog el? Ehena bagnofut osu puguag la ka nangugum nasa ka ambe gohug koka ehena unehlagim figifi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Misog el Herot ena mom hignam olug fingifena afa Jerusalem lanai el gwenaig esini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Afa Herot saglag pris mi afa nihe mo anwena el mi unetiginam maia laskuahlanaba asa fasahtigi fenigena og, “Kraisba, God Gisfu Fwahag Elbi hag kembig la gohug?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Afa sihini og, “Betlehem la Judianai yi ehe pugufe autunam Godna mo fla sihiule el ati ena moba ginofe fwahana, enaig esona og; ");
INSERT INTO amn_amanab_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Nofeka enaig onigi Betlehem Judanai eba mingnag suialag Judana kembig sumifenig. Asa enag kembig misog el pugufe eba ehe Israel, kana elim, nangwahiagefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herot enag afwambanai anwena elim efkwek moaini fasahtigifiage na og ansi bagnofutni ombusugbi puguna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Herot sahinigenam asa Betlehemgam ningitigina og, “Afunam yisigiafuhun, nangunim asa kam ambe sihini. Ka sa ikanam mongkogini kwakwagenam ehena unehlam figefuku.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Afa ehengel ena mom higinim asa afuna afa bagnofna ombusug ilawana asa osu puguiag la nangunibi enag esena ika sisi gofna enanai yi sa luwal gifni. ");
INSERT INTO amn_amanab_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Afa maia bagnofutim nangunim asa ehengel fwina sifakalini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Asa afu lala saiyegim afa ehena afag Maria enam nangwaginim afa apaiyena mongkogini kwakwaginim asa luwalna unehlagim figifugwalina afa wula pigaginim afa gawig lambinagin lambwaini. Gawigba enaba gol i, paura i, sanda i enag lambwaini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Itila God blo sihini og, “Nofe ne pese Herot nangum afu.” Asa ehengel wahgifini ming minagam heafgelni kembigamba afuna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ainiyagna oflanai el blona Josepim itila sihinagena og, “Pugu wanka Isipgim ikanam eyi wanafim ka ma nem sihinaiba asa Herot luwalim oyisgi og ka tigefaka.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Josep buihianam pugu wankana sinaini Isipgim. ");
INSERT INTO amn_amanab_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Josep Isipi yi wanafiba asa Herotba lahafe. Enaba Ainiyag mo fla sihiule elni mengig la ati sihi fwahana. Ehe esona og; Ka kikiafena luwalim unenaiba asa Isipim fwahanam blofe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herot nengeawan afa mas anwena el ambe ehem apukena mo, heafa kam mwakwalinig. Asa olug kakagenam afa mingnag elim ningitigina Betlehemgam og ma luwalim mungwali kwaskofeafui. Luwalba ninganai enaba sambaga yia enaig og masa kwaskofeafui. ");
INSERT INTO amn_amanab_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Enaigba esiniba eba God mo fla sihiule el Jeremaiana mengig la ati sihi fwahana. Enaig esinibi asa nufunam puguna. Ehe og; ");
INSERT INTO amn_amanab_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Afa Rama nai el higni Resel ati heafna luwaligim weonafena. Elbi haig kwenifini mo, awai. Eba ehena luwalig mungwali awaiena mas amban mo gafena mo. ");
INSERT INTO amn_amanab_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Afa maia Herotim lahanaba, Ainiyagna oflanai el Isipi yi Josepim itila pugu sihinagena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ehe og, “Ese pese Israelgam angwafigni luwalnam wanika. Ati elbi pigig ogna ehem tigi kumohli.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Afa sa Josep buihia wankana Israelgam. ");
INSERT INTO amn_amanab_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Afa ika higinaba Arkelaus Herotna leg puguna Judiana misog el gofna. Josep esim ikagim embefena. Afa itila God sihina Josepim, nasa Josep Galili provins gam wankana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Afa wankanam ming kembig la Nasaret la wanafna, enaigba esenaba mo fla sihiule elni moaihla og elbi enaba seflig eba Nasaret lanai el. ");
INSERT INTO amn_amanab_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Enanam Jon bula laitiaule el pugunam el fwainig la Judiana kembigla mo sihiagekana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Enaig esona og, “Olug waikefi. Godna bog meg ati blog afa Godna sawieg la big saiyenam asa heafna luwalig afohie.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Autunam Aisaia mo fla sihiule el ati sihi fwahana, el enaig esona. Jon eba enaig el. Aisaiana mo enaig esona og; El fwainig la el mungu pugu mo sihiagafe enaig esofe, Ainiyagna mina numwehiagi, heafna mina, mina suf faki. ");
INSERT INTO amn_amanab_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jonba tata lag lofug fatinam. Ena tata lagba eba kamel. Afa afiai kigifena afa fane negba sanglik i afa ihif suwig i enag neakafna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Enanam Jerusalem el i Judia el i afa Jordan bula auguiakana enag mungwali ambe gohna Jon nangum. ");
INSERT INTO amn_amanab_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ambena heafgelni amtakwaligim sihiagini afa sa Jon Jordan bula laitina. ");
INSERT INTO amn_amanab_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Afa farisi el i Sadyusi el i ambe ona bula apaiye, Jon nangwagnam afa esoni og, “Nengelbi gihiana luwalig, amban ne sihinigbi ma Godba ma nem amtakwali gihiagefe asa ne embemba afuofe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Sa ne suialag nihe fi asa ma el anwenafi ne ati nufunam olug waikefig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Nofeka enaig onigwagi Abraham kagelni simbianinga asa ka gafa suialag el. Ka nem sihinig God ehe eseba hwa funba Abrahamna simbianingag apuke gofe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Mal ati li mog la gi. Li fug suialag lugwag fwainigba, eba higfihinim suwi la laitife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ka nem bulaba laitigba eba enaig eseg ati ne olug waikefig. Afa el sumi yi obloba ehena kigmogba kana kigmogim filafeg. Kaba suialag elmo naka ehena mong lofugba flaukuna. Eba nem bulaba Godna Sungwabugni afa suwina laitfe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Elbi enaba obloba forkba ningana flagim ogna fungisge mungwali lambuhiage witinai. Ogna wit agoguli heafna wit lala fwaha afa fungisge mo lambinam suwi la laitife.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Afa enanam Sisas Galili fwahanam Jordan la pugunam blona Jon nangum og ma kam Jon bula fati. ");
INSERT INTO amn_amanab_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Afa Jon ehem gwenam afa esona og, “Nemble he kam bula fati. Haig esegba nane ka nanguba blog?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Afa Sisas mungwag ehem sihina og, “Sese, ati ka nem sihinag. Enaig big sahfeba eba ati big Godna sawieg la big sahofe.” Afa sa Jon ehena mom patalukuna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Afa Sisas bula penam afa puguna ikana gofnaba ikagna of bafuna afa nangunaba Godna Sungwabug gamp lofug peblona Sisas nai yi gahlana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Afa mengig hevenla lagofna og, “Sona elbi eba kana leg, ka ehem fwina membenag. Ka olug ehem suialafenag.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Godna Sungwabug Sisasim el fwainigam wanikina og ma Satan yuhnai. ");
INSERT INTO amn_amanab_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Afa 40 osuna Sisas mas fane nenamo, maia 40 osuna awaienaba ehem fwina bini lahana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Afa Satan blona ehem puguna afa sihina og, “Afa ne Godna leg fegba eba sane funim esoiba sama amba lofei.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Afa Sisas esona og, “Godna moba enaig esog og, ‘Amba mungu mas elim nofkenagagba fai. Godna mo munguhe eba sa elimba nofkenagagba fai.’” ");
INSERT INTO amn_amanab_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Maia Sisas enaig sihifenaba Satan Sisasim sulflanam Jerusalem gam wanikina. Wanikina Godna kwania lala wofugug sisia nemug la lasuwona. ");
INSERT INTO amn_amanab_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Afa Sisasim sihina og, “Afa ne Godna leg fegba eba sa ne puso pekai eba ati Godna mo sihig; Eba heafna oflanai elim sihiniba oflanai el ambe nem ningana kehli apaiyeufufe eba mas nem fun sig mong yi pifi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Sisas sihina og, “Godna mo enaig esog, ‘Nofeka Ainiyagim nimbiafna Godim yuhna.’” ");
INSERT INTO amn_amanab_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Satan Sisasim mungwanam mug gam fuko wanikinam afa sa mungwali bite i afa suialag gawig i ogfunagena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Afa Sisasim sihina og, “Ma ne kam mongkogini kwakwagenam kana unehlagim fingi feiba, ka sa nem bite i gawig i mungwali faife.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Afa Sisas sihina og, “Satan, esimika Godna mo enaig esog, ‘Godim ahnai skaufenam afa sa heafna unehlagim mungu fingife.’” ");
INSERT INTO amn_amanab_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Afa sa Satan Sisasim fwahanamba. Afa oflanai el ambe Sisasim kwefuni. ");
INSERT INTO amn_amanab_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Sisas enaig higina og ati Jonimba kalabusig asa Galili provins gam pese ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Afa ehe Nasaret mo fwahanam ika Kaperneam la mo gafena. Kaperneam Galili bu megim gifni muhla Sebulun Naptali elni bite la. ");
INSERT INTO amn_amanab_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Enamba Godna mo fla sihiule el Aisaia ati sihi fwahana. Enaig esona og; ");
INSERT INTO amn_amanab_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Sebulun i Naptali i nengelni bite gifni bu wagieg mina ikagla gwesim Jordan gohfba eba Galili kaksag afwambanai el auguia. ");
INSERT INTO amn_amanab_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Enag elbi sikuleg la auguia, ati kwania ombusug pugunig asa nangug. Afa amban el sikuleg pigieg la afohiafiba asa ombusenife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Enanam Sisas mo sihiagena og, “Godna bog meg ati blog sa ne olug waikefinim saiye afu.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Sisas Galili bu blugmini ikan sambaganigi etesuminegim nangwagna Saimon Pita mi Andru mi. Sambaganigi fufwalana sawagim kigiag hofefna. Sambaganigiba sawag gafuga ahfegofna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Sisas sihini og, “Au, kam ahpatal blu ka nem elim ahlambigim ogfunige.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Sambaganigi ikagna fufwala ahfwahnam ahkana Sisasim ahpatalkuna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Sisas wankan afa ming etesuminegim nangwagna Sebedini legnigim Jems mi Jon mi afa heafningina alag bot la auguiafenaba fufwala kokohiag kwelwagia flafna. Sisas uneni. ");
INSERT INTO amn_amanab_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Sambaganigi heafningina bot na afa alag na ahfwatinam ahkana Sisasim ahpatalkuna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Sisas mungwali Galili yi wagiakana ikafnam laskuhlag lala seifofnam saglag angwafigim ogfunigiafna afa Godna bog meg mom sihinigiafna afa mungwali haig haig gihna elim suiala feiti feafna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Afa mungwali el ena mo higwaginim sihiagenim asa Sirianai el haig haig gihna elim lambifini. Elig susuna, mwaifig simbigahlagulem, nilagini, afa mong lihlina Sisas suiala fetifeafna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Afa kaksag Galilinai afa Dekapolisinai Jerusalem lanai afa Judianai afa Jordan bu magigi nai el enag mungwali Sisasim patalfuia gohna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Sisas el kaksagim nangwagnam afa sa mug gam fukukana. Mug la fuko gafenaba afa heafna patalfuiag el ehem nigi afuna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Afa sa Sisas mo patalfuiag elim enaig ogfufeni og; ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Ambangel asa enaig onigife, kaba suialag el mo God sa kam kweafui, afa enag el sa ma sifakalifi afa sa ma Godna bog megam saiyefoi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Ambangel sa wewatini auguia enamba sa ma sifakalifi eba God ehengelim olug enesieg faifi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","El sa heafgelni unehlam pigapaiyegohug enaba sa ma sifakalifi afa mungwali bite eba ehengelni. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","El sa suialag nihem membigim patalfug, enaig elbi ofe enaiba sa fane i bu i bini pigig eba sa ma sifkalifi eba God ihla fenugefe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","El sa mingnag elim aflafegonug enaba sa ma sifakalifi eba God ehengelim aflafenife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Elni olug sa afsug gohon enaba sa ma sifakalifi eba Godim nangufe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","El sa ninimum tigeflakig enaba sa ma sifakalifi eba enaig seflififi Godna luwalig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","El sa suialag nihem patalfugum asa kinig flig enaba sa ma sifakalifi eba sa ma Godna bog meg saiyefoi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Afa sa nem nangwagfi ne kana mungu afufufe eba nem amtakwalig mo sihigonifi afa kokwaitififi asa haig haig mo nem mwakwal hiagifi enaba sa ne sifakalifi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Sa ne olug enesieg na afohiefiba afa sifakalifi mungwag nem kwania faifi, eba heven la nem nengeniawo. Afa gwenaig esini el mo fli sihiaule elim ati gofgam amtakwalinagini.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Nengelbi bite na sol. Afa solba mileakaba awaieba sa ne haig esibi, sa ma pese mileaklafei? Enaig solba sa mas gafugafei eba el kokofe fatigim afa mongni pigageg. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Nengelbi bitena ombusugug. Kembig sisi yi mug la gi enag mas meagam seaifoi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","El sa wi gaflagim mas meagam kumohlai eba awai, eba ambala gafla uku afa enaba lalanai elim mungwali ombusugufenig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Afa sa ma nengelni ombusugug mingnag el nangui. Afa sa ma nengelni suialag nihem nanguagi asa ne esig. Asa ma nengelni Apina unehlagim heven lanai fingi fi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Sisas enaig esona og, “Nofeka onig neafa kam og blo Mosesna nihe mo afa mo fli sihiaule elni mo fingi fati me eba awai, eba ka ihla fenagefe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ka nem nufunam sihinig, maia of i bite i awaieba, mas ena nihe moba weti nemug awaie, awai eba nihe moba gwese gofnaba afa sa mungwali pugug. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Enaig eseg afa amban weti nihe mo mas fatinafe eba mingnag elim ogfunig sa ma gwenaig esi enaig elbi Godna bog megam weti nemug feg. Afa amban el ena nihe mo patalkunam elim ogfu fenugeba eba Godna bog megam ehe gosefe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ka nem nufunam sihinig afa neana nihe farisi elni afa nihe mo anwena elni suialag nihem filafeg fwainigba eba mas ne Godna bog megam seaifoi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Sisas esona og, “Ati ne higig ena moba simbianingam flini og, ‘Nofeka elimba tigifati afa amban enaigba eseiba eba pugu kotefe.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Afa ilawo ka nem osihin el sa heafna nilitem olug kakagenag eba pugu kotefe. Afa amban sa heafna nilitem amtakwalig mo faig enaba kaunsil nai ika pugui afa el esofe ‘Neba suialag el mo’ enaba ma suwilagig kembigam ikai, awaiye. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Afa sa ne sime la Godim faigim oblofufe afa sa ne pese oningig nimbeafna nilite nem haig mo sihinafe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Eba sa Godim faig mo fwahanam ika sihiagefenam asa ne pese sime gam Godim faigim mo ika. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Afa sa nem el ogna kot ena ne mina la ahkafiba asa ati ikagna sihiagafe. Eba ma sa nem uku kwefihiage elni ninga nem la fwahafe afa ehe nem uku plismanna ninga la fwahaiba, asa plisman mo nem kalabusi fwahafe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ka nem nufunam sihinig neba kalabus lala gafiba afa ma ne mungwali kig pese faiba asa nem fwaihifi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Sisas enaig esona og, “Ati ne higig autunam enaig esogona og nengel angwafigni nofeka aga taitu fi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Afa ka nem enaig sihifenig, afa sa amban mungu angwafigim nangunam afa oniginagefe eba gwenaig eseg ati keahlag. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Afa asa neana nihiginai nofug amtakwaligim nangunam eseba enaba sa fagaflaiti sa ma enaig awaie eba mas neana elig mungwali suwilagig kembig la fati. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Afa asa neana nihiginai ninga amtakwaligim keahlafe eba sa higeflanam fati sa ma enaig awaie eba mas neana elig mungwali suwilagig kembig la fati.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Sisas esona og, “Autunam enaig esogona og, ‘Amban heafna angwafigim ningihiagba eba sa angwafigni ningihiag pepa faifni.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Afa ilawo ka nem osihin el sa heafna angwafigim ningihiafe angwafig haig ese fwainig enag elbi eba heafna moala ehe angwafigim enaigba esenag afa ena angwafig ming alagagim flaiba eba ehenigi ati aga taitu ahfeg.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Sisas pese esona og, “Ming mo simbiangam finibi ati ne higni enaba enaig eseg. ‘Nofe ne mwakwalinim afa nufunam moalag. Afa ne Ainiyag gim sihi fwahanagim sa ne nufunam ese.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Afa ilawo ka nem osihin nofe ne nufunam enaigba esogo. Nofe ne hevenimba seflinim afa wasneig mo sihi, hevenba eba Godna kwefihiage sime. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Afa nofe ne bitemba seflinim afa wasneig mo sihi ena bite eba God enanai yi mong pafeuguia. Nofe ne Jerusalemimba seflinim afa wasneig mo sihi eba kwania misog elni kembig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Afa nofe ne misog angmowaginam afa wasneig mo sihi afa ne mas neana lapogum mungu busug mi yimilig mi esei. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Afa sa ne enaig esogo, ei afa awai gwenag ehe. Mingnag moba eba Satan lamb puguiafug.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Sisas esona og, “Ati ne higig autunam enaig esogona og amban ambanim nofugim amtakwale fatiba eba sa ne mungwag amtakwale fatina. Afa ma amban ambanam gogum tuto klaitiba eba sa ne mungwa ehena gogum tuto klaiti. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Afa ka nem enaig sihi fenig el asa nem amtakwalig haig ofi nofe ne mungwagba esegon magofi. Ma nem ambanba angmoglaba tigeiba asa wahigife ming eheganai nehna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ma ambanba nem kotimenam afa neana lofug hugu flaiba afa sa ne ming kunam lofug ena gafa fai. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Afa ma ambanba nem wasneigni og hwa gawig flauku muhla faka afa sa ne mo hilife membi yi uku pugu. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Afa ma amban nem mangwalim og kam fai afa asa fai. Afa asa amban enaig membefe og ne kam esug fai afa kasa nem mungwag fai enaba nofene masig fatina.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Sisas enaig esona “Ati ne higig autunam enaig esogona og hihem mungu membenaiba afa angoluwag mo olug kakage goni. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Afa ilawo ka nem osihin angoluwagim gafa asa ne membegon, afa sa ne Godim sihinibi asa ma God elim aflafeni asa nem amtakwalig hiagifug. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Enaig ne esibi eba nengelni heven lanai alag esofe ‘Kana luwal’, afa maia ehe osum sisigam esegba nasa laugonug el amtakwaligim afa suialag elim. Afa maia bum ningihiagba bu feg el suialagim afa amtakwalig elim. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Afa el asa nem membegonug afa enaig ne membegonug, enaba mangig wag ne flife? Afa kig lambiule el gwenaig esig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Afa sa ne nimbeafna hihe mungu sihigon enaig nihe mas mingnag elni nihe gose feg mo. Afwambanai el ati enaig esig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Afa asa ne fwina suialag afufum nengelni alag hevenla suialag gwenaig feg.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Afa Sisas mo sihin gofena, “Ne numwehifum nofe ka enaig onig ka suialag nihe mingnag elim ogfugonibi asa ma kam nangwagi eba mas nem nimbeafigelni heven lanai alag gau fai. ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Afa ne membeg ne og ka esug elim mangwal faigo ne nofe ka elim gof ningitigi asa ma fuf gofiba asa ati sambaga mengig el enaig esifafife laskuhlag lala afa mina la enaig esogonibi asa ma el ehengelni unehlagim figifegoni. Ka nem nufunam sihinig enag mungwag faig ehe ati pese flig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ne membeg ne og ka esug elim kwaganim eba sa nihiginai ninga ofefiba eba mas sahagani ninga anwenafei. ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Enaig esegba neana kusguog gafugag meagam seifugo, afa neana alagba ati nangug mangwal sa meagam go enaba nem asa mungwag faife.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Sisas enaig esona, “Ne Godimba asahinifibi nofe ne sambaga mengigna el lofwagfi eba enaig esifafife laskuhlag lala afa mina embegam agfohiaba asa beteni og ma kam mingnag el nangwagi. Ka nem nufunam mo sihinig enag mungwag faig ehe ati pese flig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ne betenba ofefiba ika lala megam seifonam mengig kikisenam asa ne betenba fe neana alagba meagam go ati anwenafeg meaganaimba eba nem mungwag faife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Afa ne betenba ne ofefiba nofe ne mempbug mo sihiage enaiba afwambanai el. Eba enaig onigig ka ma mempbug mo sihiba asa ma God higi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Nofe ne ehengelni nihem patalfu afa ne maisim nimbeafna alagimba sahanag fwainig fiahba eba ati anwenafeg mangwal mungwali sa nem awaienig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Asa ne enaig sahi; Kagelni Api ne heven la ga sama el neana unehlagim fingi fini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Neana bog meg ma bloi, neana sawieg asa heven la pugug asa ma hwa bite la gwenaig ese. ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Enag osuna sa kam fane faiba sa ma gwese gofi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Asa ne kagelni amtakwalig mo esmunagim huguflaitini asa kagel gwenaig esig el kagelim amtakwalig gonug asa kagel ehengelim esmunagim huguflaiti gonug. ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Nofe ne kam fwati ma kam yuhnag pugunibi eba sa kam amtakwalig la nai lambim. ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Sa higim ne mingnag elni amtakwalig mo esmunagim huguflaitiniba eba nengelni alag heven la ga enag nengelni amtakwalig mo esmunagim huguflaiti nife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Afa ne mingnag elni amtakwalig mo esmunagim huguflaiti gonug fwainigba eba nengelni alag mas nengelni amtakwalig mo esmunagim huguflaitini.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Sisas esona og, “Ne faneba ne afoiyufiba nofe ne amtakwalig boseagi sonaigba sambaga mengig el sa esifafife amtakwal bosegig sa mingnag el nangwagigim anwenafig og eba fane foiyugofiba ka nem nufunam sihinig enag mungwag faig ehe ati pese flig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Afa ne faneba afoiyugofiba asa ne lapogum pitigifiage afa nofbosugum bulasug flai, ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","eba sa mas el nem anwenafini fane sa ne foiyug. Neana alag meagam seifogofba eba ati hefba anwenafeg eba ati nangug meaganaiba eba nem mungwag faife.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Afa Sisas esona og, “Nofe ne suialag gau hwa bite la agoguli hwa biteba sismo afa ambig enag wagiba amtakwale skofig afa ukwefule el bog tofugum asa ukwefig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Afa nengel asa suialag gau hevengam agoguli hevengamba mas sismo ambigei enag wagiba amtakwale skofig afa ukwef el mas bog tofunam saiye ukwefi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Afa hanai yi neana suialag gawig go asa neana olug enanai yi go.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Sisas enaig esona, “Nofugba eligni ombusugug neana nofug suialag gohugba eba neana elig mungwali ombusig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Afa neana nofug amtakwaleba eba neana elig mungwali sikulufeg. Afa ombusugug sa seifog neana nihi go enag kulofefiba eba kwania kulufefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Sisas enaig esona og, “Mas amban sambaga misog elni mom higinam patalkui. Eba ming mo membeba afa ming mo oksife afa asa ehe ming i mo hinaiba afa ming i mo mas fatinafe. Nofe ne Godna gafugag mi afa kig gafugag mi lambtigi”. ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Sisas enaig esona og, “Nofe ne fwinam nimbeafnam nofkikenam onigwageakafim afa ne esog mangwal kawo ne? Afa nofe ne nihim oniginam afa esog mangwal lofug ka fatife? Eba nofkikena fanemba flafug afa elig lofugba flafug! ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ati ne twafigim nangwagig mas faneba yihi afa mas agoguliaginim fane lalaba sugui. Nengelni alag hevenla ga enag sa faneba faig. Atiaho sa ne twafigimba flafug? ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Amban sa nengelinai fwina onigwage asa heafna nofkikenaba hili fwahafe? ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Haig esegba asa ne fwinam lofugumba onigig. Ati ne li sisigimba nangug haig apukefig. Ehe mas wasneig gafugafei afa lofugba gweli. ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Afa ka nem sihinig autunam misog el Solomon na mungwali wag suialag skonaba mas suialag li sisig lofena mo. ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Pos gafa afa siniba eba ati higfihinim suwi la lambaitife. Enaig posba God ehe wagwageg fwahag. Afa asa nengel weti olug onigina asa ne numwehe onigi neanga Godba nem wag faife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Nofe ne kaksag onigwagi afa esogo mangwal fane afa bu big ahagafe afa esogo mangwal lofug big laitiagifi? ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Afwambanai elbi enaigim fwina onigwagegim afa sa yisigego. Afa nengelni alag hevenla ga enaba ati anwenafeg asa nem enaig ene mungwali yi fli. ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Afa enaig ne esofifiba eba sa Godna bog megim gose onigibi afa asa ne ehena suialag nihe gose patalfuiba eba sa nem mingnag gawig gafa nem faifi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Nofe ne siniba fwina onig eba algana kinig pugufe. Glaunai kinig eba heafa gwenanam mungu.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Afa Sisas esona, “Nofe ne mingnag elni minag afuagim fahigegonugi afa enaig esogo sonaba el amtakwalig ne enaigba esibi ma sa God nem gwenaig esenife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Godba nengelni minag afuagim fahigihagefe asa ati ne mingnag elim esegonug eba gwenaig esefe. Asa ne mingnag elim haig hili faigog eba gwenai hili nem faife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Afa ne nilitem nangunam afa esog nilite ka nem fungisge noflanai weti fla fatina. Afa mas ne nimbef mo ne onigi mo aga nimbeafna nofla sa gi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Haigsegba asa ne esog nilite ka nem fungisge weti neana noflanai fla fatina afa nimbef mo aga nofla gi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Eba ne sambaga mengig el ilawana nimbeafna noflanai aga fla fatinam afa numwehe nangufe asa nimbeafna nilite na noflanai mo fla fatina. ");
INSERT INTO amn_amanab_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Nengel nofe ne mangwalba flinim Godim sa ati mwalunum afa malangim faigo afa nimbeafgelni suialag nemug engig nofe ne tatam laitigon masa pigaskofife masa nem wahgi kwaskofife.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Sisas esona, “Nengel ne Godim mangwaliba sahnibi eba ne flife. Afa ne yisigibi asa ne nangufi. Ne mengigiba tigibi eba God nem pitigiefonfie. ");
INSERT INTO amn_amanab_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Asa mungwali el Godim sahnigim asa mangwalba lambifug. El mangwalba yisigifiba eba nangufe. Afa el mengigiba otigefiba eba God piginafe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Afa luwal asa alagim sahanafe kam amba fai asa alag fun flagim faig enaigho esifafefe? Awai. ");
INSERT INTO amn_amanab_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Afa luwal esog kam sawag ebinengu fai asa atiaho sa alag sombine faife? Awai, mas enaigba esei. ");
INSERT INTO amn_amanab_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Nengel amtakwalig el afa ne nimbiafena luwalim mo mangwal mangwal suialag lambwaigog. Enaig fenaba enag sa ne numwehe anwenafi. Eba nengelni alag heven la ga enag sa ambangel ehem sahinigbi asa ehengelim fwina suialag fenig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Asa mingnagim esinibi mangwal sa ne membeg asa nem esinig. Enag mo enaho nihe moba afa Godna mo fli sihiule elni mo mog mu.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Sisas esona og, “Nengel asa mengig wetiklug megam asa ne saiyego. Mengig awaieg minaba eba kwania fegim afa pigiageg gwenaig ihlafeg afa ena minagamba kaksag el fafufiafu. ");
INSERT INTO amn_amanab_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Afa mengig ikag nofkikena flagba eba wetiklug nemug ena minaba haig esig mungwali el patalfuihia mo eba mungu mungu el ehe ena minaba yisigi nangug.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Sisas esona og, “Nengel numwehi agfohefim mwakwal el Godna mo fli sihiule el ambefe eba sangwalinai malang sipsipni lofug laitigogum afa ambe sipsipni muhla agfohiegim og na sipsipim kwahagafi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Asa ne nangwag ehengelni nihem asa ne anwenafi ehe enaig esig. Afa nasigna we mas aibi lei afa susugna li mas fwatamofba lugwi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Eba enaig eseg li suialag fug mungwali suialag leg afa li amtakwaliba fug amtakwali leg. ");
INSERT INTO amn_amanab_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Afa li suialag mas fug amtakwali lei afa li amtakwalig mas fug suialag lei. ");
INSERT INTO amn_amanab_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Mungwali li amtakwalig mas fug suialag lei enaba higfihig afa lambig suwi la laitig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Asa ne nangwag ehengelni nihem afa asa ne anwenafi eba naho mwakwal el Godna mo fli sihiule. ");
INSERT INTO amn_amanab_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Mungwali el asa kam seflig og ‘Ainiyag Ainiyag’ eba mas afui Godna bog megam saigoi, awai. Amban kana alagna sawiegim patalkuiba eba ena ho Godna bog megamba oseifu. ");
INSERT INTO amn_amanab_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Enanam ka mungwali elim kwefihiagefe el kam sihinife og ‘Ainiyag Ainiyag’, ati ka neana unehlag la mo fli sihiafug. Afa neana unehlag la ati ka sanel amtakwalig ningitigifi afa neana unehlag la ka haig haig kigmog ogfug. ");
INSERT INTO amn_amanab_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Enanam ka esofe ne mango kana nufunam el mo. Nengel amtakwalig el gwesim afu.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Sisas enaig esona, “Amban kana mom hignam patalkuiagofiba eba naho suialag onigig el enag lalaba bite wasneig yi nimblag. ");
INSERT INTO amn_amanab_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Enamba bu kwania fenam bu yi bugoi bifwat i fefiba mas toafoi eba bite ati sumulim kehlag. ");
INSERT INTO amn_amanab_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Afa amban kana mom higinam afa patalblu fwainigba eba naho etetig el asa lalaba engig sisiyi nimblag fwahagba. ");
INSERT INTO amn_amanab_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Afa maia bu kwania fenam bu i bugo i bifwat i fenam asa ena lalaba tofupefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Sisas maia ena mo sihinaba, el nubwel saglag i afa humoan i sineminefini ehena anwenagim. ");
INSERT INTO amn_amanab_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Mangwal nihe mo anwena el mo ogfug, eba awai. Eba gwenag anwena el nemug fena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Sisas mug gum fwaha pekana afa kaksag el sum patalfuna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Afa el elig amtakwaligna seflig lepra blonam mong kokoni kwakwagena Sisasim sihina og, “Ainiyag ne membegba eba sa ne kam suialafe fati.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Sisas tuhnam sihina og, “Ei ka membeg, sa ne suialafefe.” Maia enaig esonaba ikagna ena gihba awaiena elbi enaba pugu suialafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Afa Sisas ehem sihina og, “Nofe ne elim sihin. Ikanam prisim nimbeafna eligim ogfunim afa sa Godim faig enaig autunam Moses ati sihi fwahana asa ma anwenafi neana gih ati suialafeg.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Sisas ika Kaperneam kembig la pugunaba afa amini misog el Rom lanai enag blona Sisasim sahna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Og, “Saglag, kana gafugag el gihegba lala gi. Ati kigba mungwali lihlifeg afa susu kwaniafeg.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Afa Sisas ehem sihina, “Eba ka ikanam asa ehem suialafe fatife.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Amini misog el ehem sihina og, “Saglag, kaba suialag el mo na ne kana lalagamba blo, esug mo behig sihiba sa ma kana gafugag elbi suialafei. ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ka enaig sihifeg kanga ka sa misog elim ahnai skaufen. Ka gafa ati soldiaba feg enag kam ahnai skaufinig. Afa sa ka ambanim sihinafe ika eba ehe ikafe, afa ka ming elim sihinafe aublo eba ehe blofe. Afa ka kikeafna gafugag elim sihinafe hwam gafugafe, eba ehe ika esefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Sisas ena mom higinam ehena olug figifena afa el asa ehem patalfuna enam sihini og, “Ka nem nufunam sihinig mas ka ambanim mungu Israel lanai elimba olug onigi kwania feg hwaig elbi nanguna mo. ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Afa ka nem sihinig kaksag el osu puguag lanai osu peg lanai ambenam afa Abraham Aisak Jekopna wahlanam asa saiyenam Godna bog megam augunam ahagafe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Afa ambangel enaig onigig kagel sa Godna bog megamba saiyefe eba God ningitigiba asa afwambagam sikulufeg la eba wewatonam heafgelni gog tutoa ahgafife.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Sisas amini misog elim sihina, “Seika eba neana gafugag elbi suialafefe asa neana olug onigig la enaig gohug.” Afa maia sihiagafe gofnamba elbi enaba ati suialafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Sisas ikana Pitana lala seifonam nangunaba Pitana kowag gihna kifela gifni ehena elig fwina nolugenagena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Sisas ehenam ningam tohnamba gih gweyi awaienaba afa sa buihianam Sisasim fane tuhlu faina. ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Osupegnam kaksag el sanel simbigahlaule elim wan ambegohna Sisas nangum maia mo esonaba asa sanelim ningitigina afa mungwali gih elim suiala fetifena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Godna mo fla sihiule el Aisaia autunam ena mo sihinaba asa enaba ena mo nufunam puguna. Aisaia og; Ehe bigelni haig haig gihim lambinam afa lambkuna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Afa Sisas kaksag el nangwaginam maia ambe ehem wahkinaba asa ehe heafna patalfuiag elim esoni, “Ause, na kwehegam maligim afu.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Afa enanam nihe mo anwena el Sisasim blo sihina og, “Saglag, ka nem mungwali kembig patal fefkufufe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Afa Sisas ehem sihina og, “Afa sangwali malang bite meg ati go enana yi gig afa twafigni gag ati feg afa Nufunam Elbi heafna kugigbi awai.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Afa ming el eba patalfuiag el sihina og, “Ainiyag, kam fwahaiba ka ma kikiafena alagim fakanam.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Sisas ehem sihini og, “Mangofi, kam patalku. Amban ati lahag enaig el sa ma heafgelni melig pigieg elim bite la skui.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Sisas heafna elim bot la wankana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kwania bifwat ikagna bu mina sah blona afa bu blona bot megam sefua minefena. Afa Sisas non gifini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Asa patalfuiag el afu Sisasim ihlafuni og, “Ainiyag, kam kwagan, muhla ati bigim awai ofe!” ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Sisas wahigi sihini og, “Haisegba sa ne embefig? Nengelni olug onigig weti klug.” Asa ehe buihianam efef mi bu mi kweniba asa bifwat tigiafona. ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Enag el sineminefinim hefum sahwagini og, “Sonag elbi eba haig el asa efef i bu i ehena mom sa higig?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Afa Sisas bu ehengam ikanam afa Gadara bite la puguna. Afa sambaganingi el sanel sambagalaule hugskug fun meg menai afwahanam afa Sisas ahuflana. Eheningi elim fwina kwagaiti ahfiahkafena asa el mas ena mina afui. ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Eheningi ahunena og, “Ainiyag ne Godna leg haisegba ne kam esenig? Eba maisife atiaho ne glau kam amtakwalig mungwa faigim?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Afa muhlagig kaksag tata fane enanai yi ahagafu. ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Afa enag sanel Sisasim fwina sahini og, “Afa kam ningitigiba asa ka afunam sonag kaksag tatana elig saiye go.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Afa Sisas ehengelim sihini og, “Se afu!” Afa sanel eheningim fwahanim tata la afu saiye gona asa enag kaksag tata kikini afunam bu la apaiye gonam mungwali pigina. ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Afa tata yuwigig el nangunim asa kembig gam kikini afunam elim ena mom sihigoni. ");
INSERT INTO amn_amanab_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Afa mungwali el kembig lanai afunam Sisasim uflini. Afa nangunim ehem wasneig mo sihini og, “Sa ne kangelni hwa bitem fwaha ika.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Asa Sisas bot la fukunam ikana. Afa ehegam ikana heafna kembig la puguna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Kig lihligna elim mingnag el yisgofbog la Sisas nangum flifuna. Sisas nanguagnam ehengelni olug onigigim afa kig lihligna elim sihina og, “Nilite, sa ma neana olug wasneig gofi, ati ka neana mungwali nufwefbi huguflafatig.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Afa nihe mo anwena el Sisasim higinim. Enag hefum sihiageni og, “Enag elbi amtakwalig mo sihig. Ehe Godna sigagla gohug.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Afa Sisas ati heafgelni olugum anwenafeni og, “Eba haiseg nengelni amtakwalig onigig olug yi go. Eba amtakwalig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Afa ka enaig sihifeba, ‘Atika neana mungwali nufwef huguflafatig,’ asa ne mas anwenafe nufunam mo sihig me awai awai me. Afa ka enaig sihifeba, ‘Buihiaka’ asa ne anwenafe nufunam sihig me awai awai me. ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Afa ilawaba ka nem ogfunag Nufunam El eba ese fe nufwef huguflafatife.” Asa kig lihligna elim sihina, “Buihianam kife lala gam flauku.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Asa el buihianam heafena lala gam ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Afa mungwali nanguinim sineminefini. Afa sa mungwali sihiageafuna, “Godba suialag nemug. Ehe kwania wasneig elim faini.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Sisas nanai yi mo fwahanam ikana. Ikanam kig lambiule elim heafna gafugag lala nanguna. Ehena unehlagba Matyu. Sisas ehem sihina, “Kam patal blu,” asa buihia sum ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Maia Sisas Matyuna lala ahagaflafnaba mingnag el kig lambiule el i afa nufwef el i ambe auguna. Augunam asa Sisas heafna patalfuiag el i wahlanam ahagana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Afa farisi el nangunim, afa patalfuiag elim sahigoni og, “Haisegba nengelni anwena el ika enaig elbi sefu waniau?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Afa Sisas higina maia sihiag fiahflanaba, asa sihini og, “El gihnaba eba sa afui doktaba nangui, afa el gih fwainig eba mas afu nangui. ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Afu mog mu yisigi Godna buk la go. Autunam God sihina, ‘Ka mas membenig mo Godim sis esug tuhlu faigba, ka membeg ne elim aflafena.’” Sisas esog, “Kaba mango blog suialag elim uneni mo. Ka amtakwalig elim unenig sa ma kam patalfui.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Afa enanam Jonna patalfuiag el ambe Sisasim sahini, “Kagelni niheba fane fafoiyu gofe. Haisegba kagel i farisi el i hwa nihe patalfuia afa neana patalfuiag el mas enaig esig mo?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Afa Sisas angwafig flagim lasug mo sihini og, “El mungu angwafig flagim, mingnagim buyisnig. Flana augiafnaba, heafna hihe mas foiyugona mo, awai. Afa nengigim angoluwag el enag elim wanig afunaba, afa sa heafna hihe fane foiyugona.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Afa Sisas mingnag lasug mo sihini og, “El mas yimieg lofug autunai lofugi wahe gweli. Maia gigiafibi, eba yimieg lofug wetifenam afa autunai lofug mo kwafofe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Enaig mo eseg, el mas yimieg wain bug autunai sis lofug foglaba mas sugfui eba awai. Maia yimieg wain bug memewiafukoba, afa asa sisna lofug fog kwafug. Afa bu pe sufug na lofug amtakwalig. Asa yimieg wain bug glaunai sis lofuglaba eba sa efi fwinam eba sa suialag ahgofi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Afa Sisas ehengelim sihi gofenaba afa Junai misog el blona mong kokoni kwakwag penam Sisasim sihina, “Ilawo kana naina luwal ati lahag. Asa ne blo ningana kana luwalim tuhwiba asa ma buihiai.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Afa Sisas buihia patalkuia gofnaba afa asa patalfuiag el gwenaig esini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Afufefnaba afa angwafig mungu wahkig lala gim fawofeakafna 12 yia. Hefum enaig esona og, “Ka ehena lofugumba tuhwiba asa ma kam wanganefe.” Enaig oniginam nasa blona Sisasna masig muhla pugunam afa asa ehena lofugum embegim tuhna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Afa Sisas waikefe nangunam afa sihina og, “Angwafig, neana olug onigi ma aflahlana gofi. Neana suialag onigig eba nem waginefefe.” Afa asa gwenanam angwafig waginefena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Sisas ika pugunam misog elni lala megam sefukana. Afa nangunam nubwel el wewat lufufna enaig la auguiafna enaba heafgelni aflafegim ogfuni. ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Afa Sisas esona, “Apuke afu. Ena naini luwalba mas lahag mo awai, eba esug nongi.” Afa ehem titige watigohna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Afa maia apukenaba afa Sisas gwesim sefu ikana. Luwalim lahanamba ningana kehlanamba afa asa luwal buihiana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Afa ena mo asa ika minefena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Sisas nanai yi fwaha ikana. Ikafnaba sambaganigi noftetini el Sisasim ahune ahkana og, “Nimba Devitna simbianinga afa kam kusguni.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Enaig esohokafna afa Sisas lala gam sefunaba afa sambaganigi el ehem ningi ahsefunaba afa sa Sisas sahtigina og, “Ne haig onigig ahfeg, ne honigig ka neana nofugum ma wangene feawagime awai awaime?” Sambaganigi el esohona, “Ei Ainiyag, eba ne esefe!” ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Enaig esohonaba asa Sisas ningana nofugum tuhwaganam sihina og, “Enaig eseg nenigina suialag olug onigig safegba eba nenigina nofugug suialafeawagig.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Afa sa ehenigina nofug bahiawagena. Afa Sisas wasneig mo faini og, “Nofeka ahsihi enag gafugag ka esegba.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Afa mas ena mo ahigina ahpatalkuna mo awai, eheba ahka ahsihinaba mungwali el higiwagini ena moba. ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Maia Sisas fwahakafnaba afa mingnag el mo lagig etetig elim Sisas nangum wanig afuna. Enag elim sanel amtakwalig memtog pwakafini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Afa Sisas sanelim ninimu flaminefena ningihiana. Asa elbi mo lagna, asa elbi mungwali onigwagflafna. Afa asa enaig esogona, “Hai! Autunaba Israelna bitelaba mas big enaig nangufini mo, awai.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Afa farisi el esogona, “Sanelni misog el ehem kigmog faig. Enana kigmog la sanelim ningi tigifeule.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Sisas haig haig kembig la fapugufiahkana. Ehe laskuhlag lala sefukanam, Godna bog megam suialag mo sihinuwagena. Afa ehe haig haig gih wangene fetifeule. ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Afa Sisas mungwalim elim nangwagna. El enaig esini ofeg sipsipna yuwigig el fwainig afa etetiagig ahwagikifna. Mungwali onigig etetiagafufna eba mas hefgelni kwaganangiagi. Afa Sisas ehengelim aflafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Afa asa heafena patalfuiag elim sihini og, “Enag afwambanai elbi enaig eseg asonai nefganai nubwel goh, afa nubwel gafugag elbi awai enam lambigimba. ");
INSERT INTO amn_amanab_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Afa sa ne asona alagim sahinibi asa ma gafugag elim ningitigiba enag heafena nefganai sa ma afu lambi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Sisas unenig heafena 12 pela patalfug el laskuhlag asa kigmog faigba sa sanel ningitigig afa gihinam ugwegim. Ehengelbi kanog fwatig Aposel. ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Enag 12 pela Kanog Fwatig el apukeg. Ehengelni unehlag enaig: Saimon heafena Grik unehlagba Pita, heafena sumineg Andru, Jems Sebedina leg, heafena etegsumineg Jon. ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip, Bartolomyu, Tomas, Matyu, autunam Matyuna gafugag kig lambiule, Jems Alfiusna leg, Tadius, ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Saimon, autunam ehe ika mo sihiaule, ka mas membeg mo membinai el bigim misog el gohunigim, Judas Iskariot, enag mwauule el. Nengigim Sisasim angoluwag elni ninga la fwahani. ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Sisas enaig 12 pela elim ningitigim, enag ehe mungwalim sihinim, “Nofeka afwambanai elim muhlafen afa nofeka Samariana latui seaifu, ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","amo, sane Ju nai el mo afu. Mungwalim enaig eseg sipsip lofug ehengelni yuwigig el awai. ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Sane sihiafu hwa mo, ‘Godna bog meg ati blog afa Godna sawieg big saiyenam asa heafna luwalig afo.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Sa ne ugwegim, lahag buihagim, gihinam lofug amtakwalig ugwegim, sanel ningitigig. Ka nengelim kigmog esug faig enag elim kwaganig esug faig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Nofeka wula la kig fanugufu. Awai. ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Maia afuafefiba esug afwiagim. Mangofi wula, mingnag lofug, mong lofug, agat flaufiagim. Gafugag el mingnagim kwagani afa ehem sama kwagfwi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Haig haig latu i sa ne apukenam sa ne yisigi suialag elim. Amban sa nem eheafna lala gam wanikig sa ne eheafna lala mungu gan sa ne ika. ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ne afu ena lala saiyenam sane enaig mo faigo, ‘God nem suiala fenife.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Sina lalanai nem suialafenagigba, eba neana suialag mo sa ma ehem ginfi. Afa nem kwaganig fwainigba eba ena suialag mo sa ne pese flauku. ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Afa ambangel nem masig fatigonigim, afa ena mo higigim oksigbi. Maia ne ena kembig fwaha ikagim ofefiba sa ne munginai smof mo bwiabufe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ambangel sa nem masig fatinig eba ehengelnim mugwag amtakwalig pugunife. Autunam Sodom mi Gomora mi sa puguni ena kinigim gosenag.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Sisas enam sihiagena, “Sahig, enaig eseg malang ninimule sipsipim ona kwaskofe, afa ka nem ningitigiba asa el nem ona amtakwalehiagi. Sa ne numwehe nofiagifibi enaig esi wemlo lofug afa gamp lofug aflahlanafe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Numwehe onigfibi afa mingnag el nem ona lambinim olyi aitigim. Afa enag el heafgelni laskuhlag lala saiye nem wanafu wena fifiletififi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Afa el mas kam membini asa gavmanna nofla nem hugfuwanfuagim. Eba sa ne kana suialag mo sihigoni afa afwambanai elbi sa ma higi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Maia nem lambi aitibi nofeka onigwaginim afa haig mo big sihiagifi. Afa gwenanam enana mo ne esibi asa God nem faifi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ena moba nimbiafena mo amo, eba awai. Eba God nengelni alagna Sungwabug ehe nengelni mengig la sihife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Afa el heafgelni nilitem lasefug mingnag elni ninga la fwahig. Afa el heafgelni luwalim enaig esi. Afa luwal heafgelni alagafagim mo flafugoni afa sa lasefug mingnag elni ninga la fwahig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Afa ne kana el ofefiba asa mungwali el nem olug kakagegonfi. Afa amban kana mom asa fwina kehlag ukuiafiba eba God i ugweg hawagafefe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Maia ha kembig lanai nem haig esegonibi enag kembig fwahanam ikagna afuiagoh afa sa ming kembigam afu. Maia Nufunam El bloiba ne mas Israelna mungwali kembig gafugagba augwi eba awaie. Eba nufunam.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Luwal saglagim filafefe afa gafugag el misog elim filafefe, eba awai. ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Asa el saglag mi luwal mi gwenaig esgonibi eba sa luwalna olug enesieg gohi. Afa gafugag el gwenaig mungwalofug. Afa ka nengelni humoanig fenig. Afa el humoanim sefig Belsebul, eba sanelna humoan asa ehena luwaligim kwania unehlag amtakwalig faigog.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Afa Sisas enag esona, “Nofeka elim embefini, awai. Glauwaba sisagegoh afa nengigimba enaba ambala pugufe. Afa ena sisag moba eba mungwali anwenafifi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Afa Ka nem efkwekna mo sihinig sa ne afu ambala sihi. Afa muhefuna mo ne higig sa ne afu mungwali elim ambwaitina sihigon. ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ambanba ona nem tigifati nofeka embefi. Enag el haiseg neana sungwabugimba tigifati, eba awai. Afa sa ne Godim embefena. Ehe mungu esefe elig ni sungwabugni suwi lagig kembig la lambi aitife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Asa ne weti sambaganingi twafig wetiklu kigna flig afa mungu twafig mas bite la pei eba nengelni Api mas membeg mo. ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Nengelbi enaig, God ati nengelni lapogum suwigig. Afa ati nengelnim anwenafenig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Afa God weti twafigim membegim nangwaghiage asa nem gafa fwina membenig. Afa asa nofeka embefi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Sisas esog, “Afa amban el sihife og, ‘Ka Sisasna el,’ asa ka kikiafena oflanai Alagim enaig sihifenafe, ‘Enaba kana el.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Afa amban el mingnag elni nofla kam mas fatinaiba asa ka kikiafena oflanai Alagna nofla ehem ka mas fatinafe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Nofeka onigi kaba blog enaig eseg mungwali auguiagim blo mo, awai, ka blog esegba el kokohiagig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Afa mingnag el kana mo flig; Afa mingnag kam mas fatinig enaba fagonai luwaligna humoanigni hefum flafihiagife. Afa enaig esifi muluwal ango i afag i hefum flafihiagife. Afa kowag gwenaig esifi hefum flafihiagife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Mungu lalanai hefum mwanagife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Amban el sambaga onigigna gohug, asa afahumonig luwaligna fwina oniginag afa kamo weti onigina fenag eba mas kana el auguiafi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Afa amban el mas patalfug mo afa hefum li katigeg la lahagim mas numweheg mo eba mas kana fei. ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Afa amban el onigig heafena nofkikenagag aluwegfenam asa hefum nawo sisife eba enaig el mas nufunam nofkikena flai afa amban ehefum pigaupinam kam patalfu oblofiba eba sa wahkig nofkikena gagflai.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Sisas heafena patalfuiag elim esoni, “Amban nem fla suiala ofeflafliba eba ati kam esenag. Afa God kam ningihiag asa amban kam suiala ofeflafliba eba ati ehem esenag. ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Afa amban Godna Mo Fla Sihiaule Elim nangugum anwenafeg asa ehem numweheafla asa ma God enag elimbi suiala fiahflai afa asa Sihiule Elim enaig esenag. Afa amban suialag elim nangugum anwenafeg asa ehem numweheafla asa ma God enag elimbi suiala fiahflai afa asa suialag elim enaig esenag. ");
INSERT INTO amn_amanab_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Afa amban kana elim kweafuimba asa God ehem suiala feahflafe. Afa kana el eba unehlag fwainig asa amban el ehem luputug bu faimba eba God mas enag weti kwefuagimba eteti.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Afa Sisas heafena 12 pela patalfuiag elim ena mo sihi fwahanim asa enanai fwahanam sihiakana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Maia Jon bula laitiag el kalabus lala gafenaba afa asa Krais God Gisfu Fwahag El haig haig gafugag esenaba enam mo higina. Asa heafena patalfuiag elim ningitigina Sisasim nangugum. ");
INSERT INTO amn_amanab_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Afa afu apukenam Sisasim sahini og, “Ne naho Jon sihi fwahanaba naho ne blog naiba ming elim kagel nengenife.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Afa Sisas sihini, “Ati ne nangug afa higig asa Jonim pese afunam sihini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ati nofug hafinig el bahiaskofeg afa mung amtakwalna wangene fiahsaieg afa lepra elim wangeneg afa ang tetini ati mo higig afa el melig pigieg buguiagafeg afa gawig fwainig el Godna Suialag Mo higig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Afa el kam oniginaiba afa heafena olug onigigba wasneig gofofe enaig elba sa ma sifakale.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Maia afunaba asa Sisas mingnag elim sihini. Ehe Jonim esona og, “Autunam ne el fwainig la afunam asa Jonna mo higini. Ne haig elim noka nangu? El enaig pos lofug efef petla fakafefugu enaig ne nangui me? Jonba mango enaig mo. ");
INSERT INTO amn_amanab_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Mangwal figim ne membig afu nangug? Ne membig nangug el suialag nemug lofugna nangu? Jonba mango enaig mo. Eba el suialag lofugnaba lala suialag la ga. ");
INSERT INTO amn_amanab_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Haisegba ne afug? Ne Godna Mo Fla Sihiaule El nangug. Ei, Jonba enaig el. Ka nem nufuna mo sihinig, hwa elbi mingnag Mo Fli Sihiule Elim gosenig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Enaig elbi autunam Godna Buk ati sihi fwahana. Enaba God esog; Sahig, Kana mo flaukwiag elim ningihiaiba. Afa ehe Godna Gisfu Fwahag elim gosenam asa mina numwehiage ikafe asa ma el kam olug onigini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Sisas esona, “Ka nem nufunam mo sihinig Jon bula laitiag el mungwali autunai elim pugu gosenig. Afa ambangel wetiklug saiyeg Godna bog megam enaba Jonim gosinig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Afa ilawana Jon nai yi pugunam blog ilawanga pugug afa sa wasneig el Godna bog megam bagagigim afa wasneig el membeg ogna bagaginim asa fla. ");
INSERT INTO amn_amanab_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mungwali Godna Mo Fli Sihiule el i afa Mosesna nihe mo i sihig ena mo sihi mangwal sa sumi pugufe. Ena moba ati gofena autunam maisim Jon fiahfenaba. ");
INSERT INTO amn_amanab_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Afa ena moba enaig esona Elaijaba pese blogim. Afa amban ena mog moba membegba asa fla, Jonba Elaija. ");
INSERT INTO amn_amanab_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Afa amban anganaba eba sa ne higi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Afa el ilawo auguia enaba haig el asa ka nem luwal lasugum mo sihinig. Mungwali el enaig esig luwal fane suguafogla auguiaba afa gosis seafla. Afa luwal mingnag luwalim unegoni. ");
INSERT INTO amn_amanab_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","Afa kagelbi fuf i anba i guwagibi asa nengel mas ahfe. Afa kagelbi wewatioahba asa nengel mas wegoi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Afa glaunai el luwal lofug enaig esig asa Jon wainbug i fane i mas nena mo eba ogna Godna unehlagim fingife afa el esoni sanel amtakwalig ehem sefu gohna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Afa maia ka Nufunam El blogba afa ka bu i fane i ahagagig asa el esogona, ‘Sa nangu! Ena el bu i fane i ati fwina ahagagini. Ehe kig lambig el i afa ming amtakwalig el i wana.’ Ehengel enaig sihifini. Afa Godna suialag gafugag ogfunig Godna anwena eba nufunam.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Sisas mingnag kembig kaksag Godna kigmog ogfuiagena asa ena kembig lanai mas heafgelni amtakwalig fwahini mo, afa asa Sisas ehengelim fenugena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Sisas esog, “Korasin lanai el i Betsaida lanai el i niasabanig, afa mangigim ne enaigba nesig. Afa Tair lanai el i Saidon lanai el i nanguiteba enag kigmogum asa ati ne nangug asa autunam heafgelni amtakwaligim fwahite afa kokohiag lofug i smof i asa heafgelni nihim esiagini enaba heafena kusugogum ogfuni. ");
INSERT INTO amn_amanab_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ka nem nufunam sihinig nengegim God kwefihiagenam mungwag faigim. God Tair lanai mi Saidon lanai mi mungwag amtakwalig faigim afa nengelim mungwag amtakwalig numwehe faife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Afa Kaperneam lanai el, ne onigig koka suialag el hevengam afufe. Eba awai. God suwilagig kembigam nem laitife. Afa Sodom nanguiteba enag kigmogum ne nangug asa Sodom lanai onigig waikefite asa ma heafena kembig glau kwesegofite. ");
INSERT INTO amn_amanab_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ka nem nufunam sihinig nengegim Sodom lanai God kwefihiagenam mungwag amtakwalig faigim afa nengelim mungwag amtakwalig numwehe faife.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Afa enanam Sisas Godim sihina og, “Api, ne heven lanai i bite lanai i Ainiyag el goh. Ka nem suialag onag. Afa enag nufunam mo ne anwena elim kumohlanig afa ne etetig elim enag nufunam mo meaglanai eseg ambala opugug. ");
INSERT INTO amn_amanab_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ei, Api enaba nimbiafena suialag onigig ne eseg. ");
INSERT INTO amn_amanab_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Kana alag kam mungwali gawig faig. Afa el mas Godna legimba anwenafig mo. Api munguhe ena luwalimba numweheg anwenafeg asa ena luwal apiim numoheg anwenafenag asa amban elim wegifwatigim alagim ogfunig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Afa nihe mo el wasneig gafugag nem faigog. Afa ambangel asa yingmung fiahsaieg, aublo, ka sa neana kinig flafatinife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Afa ne kana mom skaufenibi asa ka nem ogfunibi sa ne kana gafugag anwenafi. Afa kaba mango fwinam fenugeah mo eba ka kikefum skaufeg asa ne hekulia flafim. ");
INSERT INTO amn_amanab_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Afa hwa gafugag ka nem faigbi eba hefeg afa mas kinig mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Afa enanam eba Esug Auguiag Osunaba Sisas aso gam ikana. Afa heafena patalfuiag el binipiginaba asa ehengel asonai lambi ahagigim ofifinibi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Maia farisi el enam nangunim Sisasim og, “Sa nangu, neana patalfuiag el bigelni Esug Auguiag Osuna nihe mo flafug.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Sisas sihini, “Amo, enag el mas flafug mo. Mas ne suwigni mo haig asa Devit eseg? Maia Devit heafena el binipigibi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Afa ehe Godna lala sefunam asa ehe heafena el amba Godim faig wanena. Nihe mo sihi pris mungu sa enamba ahagai. Devit heafena elim flafo wanena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Atiaho ne Mosesna nihe moba anwenafig afa Esug Auguiag Osuna enaig eseg prisba Godna Kwania Lala la gafugafifini. Afa ehe mo Esug Auguiag Osuna nihe mo flafuni asa God ehem esoni og, ‘Ne mas mangwal fig mo.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ka nem sihinig amban sa go, Godna Kwania Lala goseg. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Godna mo sihig; Ka mas sis faigiba membeg mo, ka membeg ne elim aflafegoni. Ati ne ena mog mo anwenafigbi ne mas enag elim fegonigi haig eseg fwainig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Asa Nufunam Elbi eba Esug Auguiag Osuna misog el.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Sisas enanai fwaha ikanam laskuhlag lala puguna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","El ninga amtakwalna gafena. Mingnag el ogna Sisasna amtakwalig nihem yisigi nangunim asa mingnag elim mo faigo. Ehem sihini og, “Atiaho bigelni nihe mo esog sa enaigba ihlafe elni gihim Esug Auguiag Osuna suialafefati?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Afa ehe sihini, “Ambana tata bume la Esug Auguiag Osuna peba. Sa ne haisefe? Eba ne fwaklafatife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Eba el tatam gosinig. Afa bigelni nihe mo esog asa ma bigel Esug Auguiag Osuna suialafefati.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Afa Sisas elim sihina og, “Ninga susnufiafo.” Maia ninga susnufiafonaba asa ehena ninga suialafena gwenai ming ninga mungwalofug. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Afa farisi el fwahinim sihiagini ogna Sisasim tigi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Afa Sisas ena mom higinam asa nanai fwaha ikana. Afa nub el sum patal afuna asa Sisas mungwali gih elim wangene fetifena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Afa Sisas wasneig mo faini og, “Nofeka mingnag elim sihigon.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ehe enaig eseg Godna mo ambala upugug. Autunam mo flaule el Aisaia Godna mo faini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Ehe enaig esog; Eba gafugag el ka kanog fwahag. Ka ehem fwina membenagim afa sifakalenag. Kikiafena Sungwabug ka ehem faife asa ehe mungwali elim suialag nihe mo sihinigefe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ehe mas haig esei afa mas ambwatina fei. Ehe mas mo fwina ambala sihi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Bwei mas wasneig mo ehe enam mas toawagi afa suwi weti lagi ehe mas fufulufakai. Ehe enaig eseaka enai ihlafegba ehe suialag nihe ublug pugug. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Afa afwambanai el nengeafufiba asa ma kwagani. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","El mungu sanel esinagana mas mo lagwage afa nof tetina. Enaig elim Sisas nangum wanig ambena. Afa asa Sisas ehem ati suialafatinaba asa nofug wagenefena afa mo lagana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Afa mungwali sineminefini afa esogona og, “Ena elbi Devitna simbianinga me awai awai me?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Afa farisi el higinim ene mom afa esogona, “Amo, ehe Belsebulni kigmog la sanel amtakwaligim ningi tigifiaka. Belsebul eba sanelni misog el.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Sisas ehengelni onigigim ati anwenafeni esona og, “Amo, neba etetig, ambangel kantri kwefihiagim asa hefum hagfe eba ena kantri amtakwalefe. Afa kembig i mungu lala nai i hefum hagfe eba gwenai esefe amtakwalefe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Satan heafena gafugag elim amtakwale aitiba asa hefum pwatihiagife. Afa pwatihiaginim afa asa mangwal sa Satan nangwagihiagefe eba enag tigefupefe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ne onigi ne esogog ka Belsebulni kigmog la sanelim ningitigifiaka. Afa nufunamba asa amban neana elim kigmog faife? Asa nimbiafena el ogfufe neana onigig amtanafeg. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ka Godna Sungwabugni kigmog la sanelim ningitigifiakaba asa ne anwenafi Godna bog meg enag ati pugug. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Haisenam asa el sefukanam wasneig elni lala gawig ugwefefe? Afa ilawo ehe wasneig elim sa wena kikenagegim eba sa lalanai gawig ugwefe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Amban kamble i ahgohug fwainigba enag elbi eba kana angoluwag. Amban kam lambigim kwefwag fwainigba eba taitufeule el. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Afa ka nem sihinig haig haig nihe amtakwalig afa amtakwalig mo Godim esini, eba ma God elni amtakwaligim flafatinifi. Afa amban amtakwalig mo Godna Sungwabugim esinibi eba God mas enaigim flafatini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Afa amban amtakwalig mo Nufunam Elim esonaiba, eba God ma enam amtakwaligim flafatinife. Asa amban amtakwalig mona Godna Sungwabugim esonaiba eba glau afa nengigim God mas enam amtakwaligim flafatinai.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Li figetini fug suialag afa li ambieg eba fug amtakwalig. Afa fug haig afa li gwenaig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ne sombine lofug! Nengel amtakwalig el asa nengelni mo sihi enag mas nugweg mo. Mango sa onigig la go enam elbi mo sihife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Suialag el nugweg onigigim kehlagim eseg. Afa amtakwalig el amtakwalig onigigim kehlagim eseg. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Ka nem sihini ma God kwefihiagenam mungwag faife ehe kwefihianigefe mungwali elni haig haig esug mo. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Haig mo sa ne sihig eba God nem kwefihiagefe afa ne suialag me awai awai me.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Farisi i afa nihe mo anwenafeg el i Sisasim sihini og, “Tisa, kagel membeg koka neana wasneig ogfuiagim nangui. Asa kagel anwenafi God nem kigmog faig.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Sisas sihi og, “Amtakwalig el afa Godim mas onigini afa enaig el membeg kigmog ona nangu. Afa ka mas nem kigmogim ogfunug mo. Afa mo flaule el Jonana kigmog sa ne nangu. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Afa sambaga mungu osuna afa sambaga mungu sinaini Jona kwania sawagna atag la sefugini. Asa gwenaig esefe Nufunam Elbi sambaga mungu osuna afa sambaga mungu sinaini bite megam sefugife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Afa nanam God kwefihianigefe afa Ninivenai el bigiagafenam asa nengelim setigifi. Ehengel Jona na mo higinim asa heafgelni amtakwalig nihe masigim fatini. Ka nem sihinig amban sa go asa Jona gosenag. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Afa nanam God kwefihianigefe eba saganai bitenai Kwin buihianam asa nengelim setigifi. Heafena membia kembig fwaha blonam asa Solomon na suialag mo higina. Ka nem sihinig amban sa go Solomon gosenag. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Maia sanel elim fwaha ikanam ehe bu fwainig bitegam ikanam gagim yisigife afa mas uflag mo. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Hefum esog, ‘Ka pese kiafena lala gam ika.’ Afa pese blo pugug ehe nangu ena lala esug go afa ombusig go afa ati numwehiageg. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ehe ika sanel elegeg la gohug ena wanblog. Ena sanel fwina amtakwalig afu saiyegim agfo. Ilawona el gwenag fena afa glauaba fwinam amtakwalig. Eba nengelim amtakwalig elim gwenaig pugunifi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Afa maisim Sisas mo sihi gofenaba heafena afagna sumini puguna ambe afwambala afofenaba ona Sisasim sihini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mungu el Sisasim sihina, “Neana afagna sumini puguna afwahie ona nem sihini.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Afa Sisas wahigife sihina, “Amban kana afag? Amban kana nilite?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ehe heafena patalfuiag el ninga bulni sufini esona og, “Sa nangu, hwa el kana afagna nilitenaba. ");
INSERT INTO amn_amanab_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Amban kana heven lanai Alagna sawiegim esofefiba eba kana afag, nilite, mulwal nemug.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Ena osuna Sisas lala fwahanam ikana bu blugyi pugunam ogna ogfufenuge. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Afa nubwel el Sisasim olyi fatini asa ehe bot la ika peganam mungwali bu blugyi afohiafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Afa Sisas kaksag lasug mo sihini og, “El enai eseg kon gug asola laitiageg. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Laitiage ika afa mingnag gug mina la apaiyeba afa twafig ambe apaiyegim lambagafig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Afa mingnag mo funkisigig yi apaiyenam ikagna puguiageg. Eba bite mas fwina pegag mo. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Maia osu puguba asa aptukwahla skofeg. Afa bagag mas apaiye eba pigife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Afa mingnag mo usieg weg amtakwalig la apaiye. Afa usieg pugugum asa kikeg. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Afa mingnag mo suialag bite la apaiyegim fugleg. Mingnag 100, mingnag 60, afa mingnag 30 enaig puguiageg. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Amban anganaba eba sa ne higi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Afa patalfuiag el Sisasim ambe sahini, “Haise ne elimbi lasug mo sihini?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Afa wahigife sihini, “Enag moba Godna nangwaghiageg autunam God mas elim sihinig afa glau eba ati nem mog mo upugugnig afa enag mingnagim mas anwenafini mo. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Amban ati mangwal fegba eba God ehem faiba asa kaksag fefe. Amban el enaig fwainigba eba God ehena weti flafatife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Okwenag el nofna nangug afa mas numwehe nangug mo. Afa angugna higigim eba mas numwehe higig mo. Afa mas numwehe anwenafig mo. Enaba nufunam nasaka ena lasug mo sihig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Aisaia mo fli sihiafug el sihinaba ena elbi ena mom nufunam esini; Ena elbi higafufenaba afa mas anwenafini mo. Afa nanguafufenaba mas numwehe nanguini mo. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Afa ehengelni misog onigwagig mas ombuseni mo afa ehengelni angug titie skofena afa nofug kohla skofena. Afa ena nihem patalfwiagba eba God sihig ehengelni angug ati higig, afa nofug ati nangug, afa olug onigig ati anwenafig. Afa ka nangum ati waike ambe enaig esigbi eba ka wangenefe laitife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Afa Sisas esoni, “Se sifakali nengelni angug ati ne higig afa nofug ati ne nangug. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ati ka nem sihini mangwal ati ne higigim afa nangug kaksag suialag el afa mo fli sihiafug el ogna higinim afa nangu asa ehengel mas higinim afa nangui.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Sahig sane anwenafi hwa lasug mog mo kon gug laitiageg. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ambangel Godna bog meg mom ati higigim afa mas anwenafig mo eba enaig eseg kon gug mina la apaiyeg. God ena mo olug yi laitig afa Amtakwalig El eba Satan blo lambig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Afa kon gug funkisigig yi apaiyeg eba enaig eseg el Godna mo higigim ikagna sifakale flag. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Eba kon bagag lofug mas pekag mo. Eba makwalig gohogum awaieg. Eba maia ehena olug Godim oniginagba asa mingnag el ehem kinig i afa ninimu mo i faigba. Eba ehena onigig tigefupefe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Afa kon gug usieg weg la apaiyeg eba enaig eseg el Godna mo higigim afa heafena gagim onigigim afa ehe fwina kigim onigka. Eba ena onigig blonam kike fakag. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Afa kon gug suialag bite la apaiyeg eba enaig eseg el mo higigim afa anwenafig. Eba fug asa enaig lugufeg mingnag 100, mingnag 60, afa mingnag 30.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Sisas ming lasug mo sihina og, “Godna bog meg enaig eseg eba el suialag kon gug asola laitiageg. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Afa maia sinaini el askaba eba el amtakwalig blogim afa lanuwe amtakwalig kon la taitufiakag. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Maia kon fug oluguba asa lanuwe nahlum wahe pugug. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Afa gafugag el asona alagim sihini og, ‘Ati ne suialag kon gug laitiagegba afa ilawamo kaksag lanuwe amtakwalig puguiagego.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ehe sihi, ‘Amtakwalig el enaig eseg!’ Afa gafugag el sihi, ‘Ne og kagel lanuwem fagahiagife?’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Afa ehe sihi, ‘Amo, nofeka lanuwe fagahiagi eba masa na kon nahlum fagaitifife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Sa fwahi, ma wahe pugunam ma kon fug luwiba asa ma gafugag el lambi. Enanam ka gafugag elim sihinibi asa ma lanuwe fagahiaginim wena kike skofini wehlagi. Wehlaginim asa ma kon mo lambwagini asa ma kana fane lala sugui.’” ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Sisas ming lasug mo sihina og, “Godna bog meg enaig eseg eba el aso la lifug fatigba. Ena libi mastet. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ena li fug wetiklug afa maia pugugba enaba kwaniafegim mingnagim asonai fanem kwaganangeg. Eba li lofug kugum asa twafig gag kagagla nimblagig.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Sisas ming lasug mo sihina og, “Godna bog meg enaig eseg angwafig yist amba la kokofegim ambam nahlum waheg. Yistba enaba smof lofwag ambam nana pipki. Enaba weti fegim afa kwaniafeg.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Hwa mungwali mo Sisas lasug mo sihig. Ehe mas ambala sihina mo afa mungwali mo ehe lasug mo sihini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ehe enaig eseg Godna mo ambala upugug. Autunam mo fli sihiafug el sihini og; Ka lasug mo sihiagim. Afa mangwal sa autunam meagam sefugo bite puguia fwainig fiafenaba asa ka sihife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Afa Sisas lasanam ika lala sefu ikana. Heafena patalfuiag el ambe sihini og, “Sa ne kagelim lanuwe lasug mog mo sihin.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ehe wahigi sihini, “Ena elbi suialag kon gug laitiageg eba Nufunam El. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Afa aso eba mungwali bite, afa suialag kon gug eba el Godna bog megam saiyeafo. Afa lanuwe amtakwalig eba Satan na el. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Afa amtakwalig el lanuwe laitiageg eba Satan. Maia nefgenai lambigim ofefiba asa enanam mungwali awaiefe. Afa gafugag el eba oflanai el. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Enaig el pos amtakwalig angogoluagigim sa suwi la tuhlu maia eba gwenaig esefe enanam mungwali awaiefe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nufunam Elbi heafena oflanai el ningitigiba asa afufe. Ehengel afu saiyenam fahigiagife Godna bog meg la. Asa mungwali mangwal i amtakwalig eseg afa amtakwalig el mi asa numwehwaginim. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Asa suwi kwania la lambi aitife. Enana yi eyu watinam gog kike skofefe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Enanam suialag el osu lofwag laukwag skofefe saiyenam heafgelni Apina bog meg gam. Amban angana eba sa ne higi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Godna bog meg enaig eseg kaksag kig lofug bite la sefu go. Asa el bumekokogim nangugum ehe pese titi fwahag. Asa sifakalegim ikanam asa heafena gawig faigim asa ena bite ati flag.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Hwaba ming Godna bog meg lasug mo. Eba enaig eseg el membeg oka kopu suialag yisigi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Afa maia fwina suialag kopu yisgegoba asa heafena mungwali gawig faig asa ena kopu ati flag.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Hwaba ming Godna bog meg lasug mo. Eba enaig eseg fufwala kwania el bula fatinam asa haig haig sawag ati lambina. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Maia fufwala la memtola pugunaba bu blug yi skogofena. El gafenaba asa sawag kwefskofena. Sawag suialag sob yi fatiafena afa sawag amtakwalig flafenam fatiafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Enanam mungwali awaieba enaig eseg enaba sawag lasugum sihig. Afa amtakwalig el i afa suialag el i mungwali wahegofenaba. Asa oflanai el ikanam amtakwalig elim lambinam laitina. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Afa suwi kwania la lambinam aitife. Enana yi eyu watinam gog kike skofefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Sisas sahtigina, “Atiaho ne ena momba anwenafig.” Heafena patalfuiag el pese sihi, “Ei, kati anwenafig.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Afa ehe sihini, “Enag sa nihe mo anwena el, Godna autunam mom anwenafeg afa ehe Godna glaunai bog meg mom enag mungwali anwenafe auwageg. Eba enaig eseg el gawig lala sefu ikanam afa glaunai gawig afa autunai gawig asa lambogifi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Afa Sisas ena lasug mo enana yi fwahana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Afa heafena kembig gam pese ikana. Ehe laskuhlag lala la mo sihinigena afa mungwali higinim sa sineminefini. Ehengel sahini, “Amban maia ehem anwenafeg kigmog faig? ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Bigel anwenafini heafena alag lala nimblaule el. Sinaba ehena legho maia? Sinaba Mariana legho maia? Ati big anwenafig Jems, Josep, Saimon, afa Judas heafena sumineg pugug. ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Heafena muwalig mungwali big auguia. Hanai yi maia ehe enaba anwenafeg kigmog flag?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Afa asa ehengel mas ehem sifakalini mo. Afa Sisas sihini og, “Afa mungwali el sihig, mo fli sihiafug el eba misog el. Afa heafena kembig lanai afa heafena nilite ehem mas higini mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Afa mungwali ehem mas olug onigini mo asa enanai yi Sisas mas wasneig gafugag esena mo. ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Enanam Herot Galili nai misog el higina Sisasna wasneig gafugag puguna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ehe heafena elim sihini, “Eba Jon bula laitig el afa pese buihia, asa ehe enaig kigmog wasneig gafugag esena.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Afa Herot ena onigina asa heafena suminegna angwagim flana. Autunam Herodias Filipni yi gana. Jon Herotim esona, “Eba amtakwalig suminegna angwafig flagba.” Afa Herot heafena elim sihini, “Jonim kehlinim asa lala meg gam wena sumul yi kiki fwahi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Herot membena Jonim tigi afa enaig esegba ka Ju elim embefinig. Asa Ju el onigini Jon eba mo fli sihiaule el. ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Afa mingnag el ambe kuhlunim afa sifakalini afag enaig osuna Herotim foklana. Herodiasna legba nainai ehe buihianam elim olyi ilani. Herot nangunam sifakalena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Asa Herot angwafigim moamo sihina fwahanam, “Mangwalim ne membeg sane kam sahana ka ne faife.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ena angwafig afagna onigigim patalkuna. Afa sahana og, “Ka membeg ilawo Jon bula laitig elna misog sob yi fakanam kam blu fai.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Afa mungwali el misog elni mom higinim asa ehengelni olug kinig. Afa heafena gafugag elim esoni sesi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Asa ehe elim ningihianaba afa asa ikana Jonna unehligim hige flaitina. ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Afa ena misog sob yi fatinam flau bluna asa angwafigim faina afa ehe flanam afagim uku faina. ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Jonna patalfuiag el ambenam afa asa elig behig flifu kumohlini afa sa Sisasim ena mom sihini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Maia Sisas ena mo higinam ehe enanai yi fwahanam afa bot la hefwaimu bite behigam ikana. El ena higinim afa kembig fwahanam asa biteamina afuna sum. ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Sisas bu blug yi pugunam afa nubwel elim nangwagina aflafenim afa gih elim suiala fetifena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Maia osu pegim ofefenaba afa heafena patalfuiag el ambe ehem sihini og, “Osu ati ope afa hwa biteba lala fwainig. Hwaina sa ne ningitigi kembig gam sama afui fane yisgiawogi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Sisas sihini og, “Ehengel mungwali wanai yi auguiagim. Nengel sa ne fane faigo.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ehengel ehem sihini, “Ambaba afala gohug afa sawagba sambaga enaig hwaba afogwa.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Afa ehe sihini og, “Kam osum lambina.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Sisas esoni mungwali pos la apaiye augu. Ehe ambaba afala gohug enaig lambinam afa sawag sambaga lambtiginam asa ofgam nof fena afa Godim suialag onanam. Asa ehe kosko fenam asa heafena patalfuiag elim faini. Patalfuiag el flinim afa asa magiauwagini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Mungwali ahgawaginim afa ihlafe skofena. Patalfuiag el fane pese lambini afa 12 sob yi laitinim afa sob yi memtola puguia skofena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Enanam 5,000 saglag ati ahgawagini afa angwafig i luwal i mas suwigini mo. ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Afa Sisas patalfuiag el wasneig mo faini asa bot la gof afu ehegam maligim. Asa ehe mingnag elim sihini og, “Pese lala gam afu.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ati sihinigenam asa ehe mungu kukana mug gamba ogna Godim sihina. Sikuleofe fenaba ehe mungu gofena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Enanam bot maia membigam ikanaba. Efef kwania blona botim minam gofla pahlana afa bu botim figi figi fiaflana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Maia ohugukafnaba Sisas bu sisi blo patalfuiag el nai yi muhla opugufena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Maia Sisas blo afenaba afa patalfuiag el nangunim embembe fiaginim esogona og, “Sonaba iflaf oblo!” Asa ehengel eyu watigona. ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Afa sa Sisas ikagna mo lagna og, “Nofe ne embefi, eba kaho. Sa olug enesieg fli.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Afa Pita esona og, “Ainiyag, eba neaho? Sa ne kam sihinaiba kasa neanangum bu sisi yi blo.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Afa Sisas ehem sihina og, “Se blo.” Asa Pita botim fwahanam pe bu sisi yi Sisas nangum ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Afa ehe bifwatim nangunam embefena asa ehem bu meg gam pe akofnaba asa Sisasim unena og, “Ainiyag, kam kweagfu!” ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Asa Sisas ikagna Pitam ninga na kehlanam asa ehem sihina og, “Neana olug onigi wetiklu, Haisegba sa ne sambaga onigigba flag?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Afa maia bot la ahfukunaba asa bifwat awaiena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Afa bot la auguiafnaba Sisasna unehlagim fingi finim esogona og, “Eba nufunam nemug ne Godna leg.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Afa sa wankana bu mo koflakanam ika ehgam Genesaret kembig wanpuguna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Maia wanpugunaba asa Sisasim nangunim anwenafini. Asa mo sihiagafuna mingnag kembig gam og ma gih elim Sisas nangum wanambe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Afa Sisasim fwina sahani gih elim fwatiba og ma ehena lofug meigim tuhwibi. Ambangel enaig esibi asa ehengelim wangene feskofefe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Enanam mingnag farisi el afa mingnag Mosesna nihe mo anwenafeg el Jerusalem fwahinim ambegohna Sisas nangum afa sahini og, ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Haisegba asa neana patalfuiag el fane ahagaba, ehe mas bula ningam suwagi asa autunam simbianinga ogfugoni, afa ehe simbianingana nihe flafug.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Sisas wahigi sihini, “Neagaba nimbiafig elni nihe ne goseg ufug afa Godim nihe mo ne flafug. ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Afa God esonig ‘Sa ne nimbiafna afa humoanigim asa ahnai skau fegonim’ afa ming mo enaig esog, ‘Afa amban alag mi afag mi amtakwalig mo faigba eba tigibi asa ehem lahafe.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Afa ne esog afa amban el gawig nubwel fegba asa ma alag mi afag mi kwagani, afa ehe esog, ka mas ne kwagani afa hwaba gawigba Godim ka faig.” Farisi el onigig hwaba suialag nihe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","“Maia amban enaig esegba ehe mas alagim ahnai skau fenag mo. Afa enaig mina feg Godna nihe mo sum fatigim afa nimbiafna nihe mo mo ne goseg ufug. ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Nengel sambaga mengigna el. Nimbiafgelni mom autunam Aisaia ati sihi fwahana, eba nufunam. Ehe enaig esona, ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","God sihi; Sona elbi mengigna kana unehlagimba figifig afa olug onigigba alganam afwahie. ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ehe ogfugonug elni nihe mo afa ena moba seflifinim Godna nihe mo. Asa enag elbi kam munum lotu finig.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Afa Sisas elim uneni ka nangum ambegoh afa esoni og, “Ne higinim sa ne anwenafi! ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Mango sa ne mengna negba, eba mas elim nufwehi enag mo, amo eba awai. Asa mango mengmenai pugug eba naho elim kwenag Godim lotu fenagim.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Afa patalfuiag el Sisasim ambe sihini og, “Atiho ne anwenafeg farisi enag mo higigim afa olug kakage skofena?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ehe pese sihini, “Mungwali gau kana heven lanai Api mas suguageg mo eba sa fagahiagefe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Se fwati, sonag elbi nof tetini el. Ehe ming nof tetini elim ningana kehla kunam afa ahkanam asa bume la ahpefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Afa Pita ehem sihina og, “Sa kagelim numwehe sihini enag lasug mog mom.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Sisas sihini, “Atiaho, ne kana patalfuiag el ne mas ihlafig mo? ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Mas ho ne anwenafig mo? Mango sa el negim ehnogam pekagim asa atam ikag. ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Afa mango sa olug onigig lanai gohugum afa asa mengig la puguiageg. Eba naho elim nufwehinag. ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Afa amtakwalig onigig oluginai pugug eba enaig eseg: aisilni tigeg, angwafig kehlag, aga taituna, ukwefna flag, makwal mo, moalamp mo. ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Enaig niheba naho elim nufwehinag. Afa el mas ninga bulasuwage ehe fane negba eba mas nufwehig mo afa Godim lotu fenagim mas kwenag mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Sisas enanai yi fwahanam ika Tairnai yi afa Saidonnai yi kembig muhla ika puguna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Afa angwafig mungu Kenan lanai enanai yi gafena enag blonam Sisasim unena og, “Ainiyag, Devitna simbianinga kam aflafena. Sanel kana nainai luwalim amtakwalenageg.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Afa Sisas mas ehem wahigi lagna mo. Afa heafna patalfuiag el ambefenaba sihina og, “Pese ningihia makai afa angwafig sum une blofena.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Sisas sihina, “Eba God kam ningihiagba na kam blog Israelnai elim sipsip lofug awaiegba enam ka kwaganig. Neba neafa afwambanai el.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Afa angwafig blo Sisasna kig muhla penam sahana, “Ainiyag, sa kam kweafu!” ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Afa Sisas pese sihina, “Naiba mas ihlafegmo luwalna fane malangim laitigonuba.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Angwafig sihina, “Ei, nufunam ne sihina. Afa malangba alagna sime skaunai ogug fanefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Sisas wahigi sihina, “Angwafig, neana olug onigigba numweheg. Mangwal sa ne membeg eba pugufe.” Gwenanam luwalim suialafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Sisas enanai fwahanam Galili bu ehembeg mina ika pugunam afa mug la fukogafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Nubwel el ambe Sisasim nanguni. Asa enag el lambug ambegona mong waikefona, nof tetini, mong ninga lilina, mo tetini, afa mingnag gih el afa sa Sisas nai yi mong muhla lasani. Afa sa Sisas suialafetifena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Afa nanguni, maia mo tetini mo lagwagini, mong waikefona suialafe skofena, mong lilina afuna, afa nof tetini bahia skofena asa mungwali Israelna Godim figifini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Sisas heafena patalfuiag elim awamonim og, “Ka hwa elim aflafenig, asa sambaga mungu osuna kam waniaflag afa fane awai. Kam esug ningitigiagim oksig masa bini pigife, afa mina la afuian kilale apaiyegofe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Patalfuiag el ehem sihini og, “Hwaba bite fane fwainig. Hana sa big fane amba flinim asa big hwa kaksag elbi faigofe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Sisas ehengelim sahini, “Hanansi bret ne skug?” Afa esogona, “Ka bret elegeg la gohug afa mungu mungu weti sawag, enaig ka skug.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Sisas mungwali elim esoni og asa bite la apaiye auguiaka. ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Afa sa bret elegeg la gohna afa sawag enag lambinam. Afa Godim enaig esona hwaba suialag ka nem suialag onag. Sihi fwahanam asa bret i sawag i koskofenam, afa patalfuiag elim fainiba asa mungwali elim mangegoni. ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Afa ahagaginim asa ihlafe skofena. Afa mingnag bret mo gwese afgokufna asa pese lambogini elegeg la gohna enaig sobini memtola puguia skofena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Saglagba enaba ahaganamba 4,000 saglag. Afa angwafig i luwal i eba mas suwigini mo. ");
INSERT INTO amn_amanab_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Afa Sisas elim ningitigi minefenam asa ehe mo bot la fukoganam afa sa Magadan bitegam ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Afa farisi i Sadyusi i Sisas nangum ambegonam. Ona Sisas gihi nangu asa sahani og, “Sa kam Godna kigmogim ogfun.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Afa pese sihini, “Maia osu pegba ne sihi, ‘Of kagatotofeg eba osu suialagna.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Afa leanaba ne sihi, ‘Of bufegim nugwag ofe.’ Afa ne ofim nangu asa ne anwenafi mangwal pugufe afa ne mas anwenafig mo kigmog mogim ka ogfuna eba gwese gohfufe hwa osunagafa. ");
INSERT INTO amn_amanab_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","El glau ohnanam eba amtakwalig afa Godim masig fatinig. Enaig el kigmogim ogna nangu asa Godim mas fwina onigi mo. Ka mas nengelim kigmog ogfuni, awai. Eba Jonana kigmogim mungu ne nangufi.” Asa Sisas fwahanam ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Maia patalfuiag el bum apaiyegohnam ehegam maligim apukunam afa ehengel etetini bret lambug afuiagim. ");
INSERT INTO amn_amanab_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Afa Sisas ehengel lasug mo sihini, “Bwata, afa numwehifibi farisi ni Sadyusi ni yistim.” Yistimba enaba smof lofwag bretim esegba asa pipkig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Patalfuiag el hefum sihiagini, “Mas big bret lambu ambeg mo asa Sisas enaig esog.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Sisas ati anwenafini ehengelni moba afa ehe enaig esona, “Haisegba enaig moba ne sihiagi kagelni bret awai. Hei, neana olug onigig wetifeg. ");
INSERT INTO amn_amanab_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Atiaho ne mas anwenafig mo? Ka onigig ne mas etetig mo autunam bret afala gohug enag ka faini 5,000 elim afa sob 12 gohna asa ne pese lambini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Afa bret elegeg la gohug eba 4,000 el ahagagini asa ne pese elegeg la gohna enaig sobini lambini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ka mango bretim eso mo. Haiseg ne mas anwenafig mo? Numwehifibi farisi ni Sadyusini yistim.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Afa ehengel ati anwenafini Sisas mas enaig mo bretna yistim sihina mo, eba awai. Eba farisi ni Sadyusi ni mom sama numwehi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Sisas Sisaria Filipai distrik gam ikana, afa heafena patalfuiag elim sahini og, “El esogo amban maia Nufunam Elbi?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Afa ehengel sihini og, “Mingnag esogo ne Jon bula laitiag el, afa mingnag esogo ne Elaija, afa mingnag esogo Jeremaia amo ming el mo fli sihiule.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Sisas sahtigina, “Afa nemba haig onigifig? Kaba amban maia?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Pita wahigi sihina, “Ne Krais God Gisfu Fwahag el afa Godba nofkenagag, nemble heafna leg.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Sisas pese sihini, “Saimon Jonna leg ena mo sane sihigba, mango el nem sihina mo, eba heafa kana alag heven lanai nem upugunag. Asa ne enam sifakalena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ka nem sihinag ne Pita neana unehlagba eba fun. (Mo enag ne sihigba enaig eseg fun.) Enaig eseg el lala fun la nimblag. Enag fun la kana elim ka lasanig. Afa Satanna wasneig mas kana elim filafati. ");
INSERT INTO amn_amanab_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Eba Godna bog meg ki ka nem faife. Afa mangwal sane kikiseg bite la asa God gwenaig esefe. Afa mangwal sane pigi fwahaiba bite la asa God gwenaig esefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Afa Sisas heafna patalfuiag elim kweni, og, “Nofeka sihi kaba Krais God Gisfu Fwahag El.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Gwenanam Sisas patalfuiag elim heafna mom ambala sihini og, “Eba sa ka Jerusalem gam ikafe. Afa misog el i, el Godum sis tuhlu faiule i, afa nihe mo anwena el i asa kam kaksag kinig faife. Afa kam lahafe afa sambaga mungu osuna ka pese buihiafe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita Sisasim suflaukunam afa fenagena og, “Sama God gwenai esei, hwa enaig mas nem sa pugunai.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Afa Sisas wahigi Pitam sihina, “Is kam fwaha, Satan! Ne enaig membeg kana mina ogna kagfo. Neana mo mango Godna onigig mo awai, eba elni onigig.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Afa Sisas enaig sihifeni, “Afa amban membeg kana patalfuiag el ogofiba asa ehe mas hefum onigig mo afa ehe sama li katige la lahagim numwehenam afa sa kam patal blui. ");
INSERT INTO amn_amanab_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Afa amban el onigig, heafna nofkena aluwegfenam asa hefum nawo sisife eba enaig el mas nufunam nofkena gagim flai. Afa amban kam patal oblofiba asa ma heafna nofkena fwahai eba asa ehe wahkig nofkena gag flai. ");
INSERT INTO amn_amanab_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Eba mas suialafeg mo afa el mungwali bitenai gawig lambigba asa hefum awaiefe. Afa mungwali gawig mas elim nofkena fai. ");
INSERT INTO amn_amanab_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Afa Nufunam El eba Godna kigmogna afa oflanai elim wanblofe. Asa enanam ehe mungwali elim haig haigim kwefiahaginam asa faifi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ka nufunam sihi mingnag el wanai yi goh maisim pigieg fwainig fefiba asa enag el nangufe Nufunam el enaig asa kwania misog el lofug blofe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Enwesog la gohug osuna maia ika awaienaba afa Sisas Pitana, Jemsna, afa Jonna enam sulfu wankanam afu mog gam fukwalafuna. Ehe fwaimu auguiafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Afa auguiafenaba nanguini Sisasna elig alganam fena. Heafna nofbosug ombusug osu lofug. Afa heafna fatitiag lofug busugnemwag fena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Maia patalfuiag el nangunibi ikagna Moses i Elaija i ahpugunam Sisasim ahwani lagofena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Afa Pita Sisasim sihina, “Ainiyag, eba suialag bigel wanai yi auguiafim. Ne membegba asa ka wanai yi lala weti sambaga mungu nimblage. Ming neana, ming Mosesna, afa ming Elaijana.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Afa Pita sihi gofenaba asa leango ombusug peblonam sagfla skofena. Afa enag leangolaba God sihini og, “Hwaba kana leg mungu ka fwina membenag afa ka ehem sifakalena asa ehena mo higinim.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Afa patalfuiag el higinim embefini asa nofbosug mo bite gam kumuni. ");
INSERT INTO amn_amanab_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Afa Sisas blonam ningana tutuhenugenam sihini og, “Buguiagafe, nofeka embefi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Asa bahia nanguniba afa mas ming elimba nangunim mo eba Sisas mungu gofena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Afa mog lanai apaiye ambeafenaba Sisas wasneig mo sihini og, “Asa ne nangug enaba nofeka elim sihigoni sama ikan Nufunam el lahanam buihiafei.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Afa patalfuiag el sahani og, “Haisegba asa nihe mo anwena el enaig sihifini Elaija gose blofe asa Nufunam El mo sum blofe?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Afa Sisas sihini, “Eba nufunam, Elaija ma gose blofe asa ehe mungwali numwehiagefe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ka nem nufunam sihig Elaijaba ati blog afa el mas ehem anwenafig mo eba heafgelni onigig la ehem haig haig ese flini. Eba gwenaig esinife, Nufunam Elim asa kinig faife.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Asa patalfuiag el anwenafini Sisas enaig esona Elaija eba Jon bula laitiag el. ");
INSERT INTO amn_amanab_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Sisas wanblona kaksag el yi wanpuguna. Afa sa mungu el blo mongkogini kwakwagenam Sisasim sihina og, ");
INSERT INTO amn_amanab_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Ainiyag, sa ne kana luwalim aflafena. Nilag ehem amtakwalnageg afa suwi la i bu la i fapefiaka. ");
INSERT INTO amn_amanab_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Afa ka wanikig nimbiafna patalfuiag el nai yi wani puguba afa ehengel mas ugweflakig mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Sisas pese enaig sihifeni og, “Mungwali el hosa gohkaba eba olug onigig mas suialafig mo afa maisi nengel flaflafiafu. Hanana saka gafiba asa ne anwenafife? Kamoksig wahkig nem wangagim. Sa luwalim osum wani blu.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Sisas nilagim fenaminefena asa nilag luwalim fwaihia ikana. Afa luwal ikagna ugwena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Afa patalfuiag el ehe fwaimu augunam Sisasim sahini og, “Haisegba kagelbi mas nilagibi ningihig mo?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Afa wahigi sihini, “Eba nengelni olug ongig wetiti, ka nem nufunam sihinig afa nengelni olug ongig wetiti mastet sisig lofwag enaig, asa ne enag mogum enaig esoiba ‘Susum ika’ asa ikafe. Eba sa ne mangwalim mungwali ihlafife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Afa Godim asa sahanifibi asa ne fane fwaigo eba sa ne enaig ena nilagibi ningitigi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Afa ehengel Galili bite la afu apukenam Sisas sihi og, “Eba Nufunam Elim flinim asa mingnagna elni ninga la fwahibi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Afa ehem tigife asa sambaga mungu osuna awaieba asa pese buihiafe.” Maia sihi fwahanaba asa patalfuiag el olug kinig eskofena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Afa ming nanam Sisas heafna patalfuiag elim wankana Kaperneam bite la wanpuguna afa Godna Kwania lalanai kig lambiule el Pitam sahani, “Atiaho nengelni anwena elbi kigba Godna Kwania lala namaunim takisbi fafaife?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pita sihini, “Ei”. Afa maia ehe lala gam ika pugunaba afa Sisas gof sahana, “Saimon ne haig onigig feg? Misog el ambangelni kig lambogig heafna luwalna me awai afwambanai elni me lambig?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita sihina, “Afwambanai elni”. Asa Sisas esona, “Enaig esegba luwal mas kig faig mo. ");
INSERT INTO amn_amanab_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Afa nofe ne big enaig esi eba masa bigim lagonife. Sa ne bu gam ikanam fofwalana sawagim etiawage asa ilawana ne flanam asa ne kig mengig la nangu. Enag kigba eba bigim ihlafenife asa flanam Godna kwania lalanai elim fai.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Enanam patalfuiag el ambena Sisasim sahini, “Afa amban sa Godna bog megam goseg pugufe?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Asa Sisas luwalim awamonam bluna olyi lasuna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Afa enaig esona, “Ka nem sihini, afa olug onigig ne waike luwal lofwag fwainigba eba mas nengel saiye afui Godna bog megamba. ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Amban enag luwal lofenam hefum ahnai skaufeba, eba sa goseg pugui Godna bog megba.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Amban kana unehla la luwalim awamonam kweafwiba eba naho kam gwenaig esenag. ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Afa luwal sa kam olug oniginag, enag sa amban wanikinam nufwehimo laba husiafwibi, asa God ehem mungwag faife eba kwania kinig feg. Afa enaig elim fun kwaniana wuneg la wena kikenim bu megam fatife eba weti kinig feg. ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Eba amtakwalig, mangwal sa kaksag hwa bite la gohka eba elim nufwehinag. Enaigba wahkig gofife, afa amban mingnag elim enaig esegonibi, niasabanig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Afa neana ninga i mong i nem huguflaku mangwal la husufwagba eba sa hegeflaiti. Eba suialag feg ninga mong fwainig asa God i hafufe. Enaig amtakwalig neana elig mungwali goh afa nem suwi wahkig lagig yi flinim fatife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Afa neana nofug nem huguflaku mangwal la husufwagba eba sa fogafla. Eba suialag feg mungu nofug fwainig asa God i hafufe. Enaig amtakwalig sambaga nofug goh afa nem suwi lagig latu yi flinim fatife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Ne numwehifibi nofe ne luwalim pagaupenam afa eso, esim gofiba. Afa ka nem osihini heafgelni oflanai el kana heven lanai Apina nofbosugim wahkig nangwafu. ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Afa el minam eteti afuna asa Nufunam El blonam asa pese lambig.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Afa el 100 sipsip tata lofwag enaig ese wanga. Afa mungu sipsip minam eteti ikag. Ne haig onigig, el enaig eseg? Ehe mingnagim sipsip mo mog la lasanam afa mungu sipsipim yisgiakana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Afa mungwali mas awaiena mo ehe sifakaleg, afa mungu pese flagim asa ehem fwina sifakalenag. ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Afa gwenaig eseg nengelni heven lanai Alag mas membeg mo luwal lofwag mungu awaiegba.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Afa maia neana nilite nem haise naiba asa ika nangunam asa nimbe fwaimu ahwaganam sa niheaugu. Ma atiaba higigba eba sa wanim blunam asa mungu nilite ahfe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Afa ehe neana mo higi fwainigba eba sa mungu me awai sambaga me sa ne pese afu nangu. Eba sama neana mom ahigi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Afa ehe nengelni mo higi fwainig gwenai esegba eba sa Godna elim sihigoni. Afa ehe Godna elni mo higig fwainigba. Asa nengel ehem enaig onigig fini sonaba angoluwag el. ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ka nem sihinig, afa mangwal sa nengel kikisig bite la, asa God gwenaig esefe. Afa sa nengel pigi fwahaiba bite la, asa God gwenaig esefe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Mingnag mo ka nem afai, ambanani hwa bite la hafiba asa mangwalim mungu onigig ne ahsihinaiba asa kam heven lanai Alag eba nengelim esenife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Hanai yi sambaga me awai sambaga mungu me kana el ambe laskuhlafiba eba ka olyi wangafife.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pita blo Sisasim sahana og, “Ainiyag, afa nilite kam haig esenagofiba asa hanasi nagim ka ehem mas esenai? Afa mas ka enwesog la gohug mungwag faiyiba eba atiaho ihlafeg?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Afa Sisas ehem sihina og, “Amo eba, enwesola gohug mas ihlafeg mo. Sa gwenaig ese enwesola gohug enaig afa ne pese ese ikan asa ne mas pese suwigi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ka nena ena mo fai, eba Godna bog megam enaig eseg. Misog el membeg heafna elim gafugagim ogna fahigiage. ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Afa kigim fahigiag ofefenaba afa gafugag elim wanig ambena og masa mungwag enaig 10 million kina pese fai. ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Afa enaig el kig awaiena pese faigim asa misog el esonig og, ‘Koka kig pese fla eba enaig eseg enag elni heafna angwag na luwal na afa mungwali gawig na lambinim asa mingnag elim faigoiba asa ka enana kig fla.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Afa el enag mo higinam asa mongkogini misog elni muhla kwakwagena afa esona og, ‘Sa kam aflafena, ningenafiba nofeka ahmona ese afa eba ka nem mungwali kig mungwag pese faife!’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Afa misog el ehem aflafena asa esona, ‘Kig hosa ne kana flanag eba ka nem nangu fwahafe’ afa sa ehem fwahana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Afa el ikanam ming el gwenaig gafuganai apuguiafenam. El kig weti flana ming elni hosa misog el ehem fwahana. Ena kigba enaig eseg mungu mungu kina. Afa sa elim wuneglig yi kehlanam og, ‘Sa kam mungwag fai.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Afa heafna hihe mongkogini kwakwagena afa esona og, ‘Sa kam aflafena, ningenafiba nofeka ahmona ese afa eba ka nem mungwag faife!’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ehe oksina enaig esegim asa ehem polisni ninga la fwahanam maia ikan ma mungwag kam fai. ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Afa mungwali mingnag gafuganai el enaigim nangunim asa ehengelni olug amtakwale skofena. Afa sa misog elim sihini og el enaig eseg. ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Asa misog el ehem awamona afa esona og, ‘Ne amtakwalig gafugag el. Gof kana kaksag kigna ne mas nungwe gafuga fena mo. Afa ne og, sa kam aflafena, asa ka nem nangu fwahana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ka nem aflafena asa neanga gwenaig ese.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Afa misog el ehem olug kakagena afa mingnag el ninga la ehem fwahanaba asa ma susu flanam ikan maia mungwali mungwag faiba. ");
INSERT INTO amn_amanab_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Kana heven lanai alag asa nem gwenaig esinifi. Asa nimbiafna nilite mas amtakwalig mungwag faig mo sa kana Alag heven lanai gwenaig nengelim esenifi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Sisas ena mo sihi fwahanam asa Galili bite fwahanam afa Judia gam ikana. Ena biteba Jordan bu embegam. ");
INSERT INTO amn_amanab_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Afa kaksag el ehem patalfuna. Enanai yi mingnag gih elim suiala fetifena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Afa farisi nangum ambegona. Ona Sisasim gihi nangunim afa ehena mom pagaupigo asa sahini og, “Aseg, sa saglag heafna membug la angwafigimbi ningihiai, atiaho bigelni nihe mo ihlafeg?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Afa Sisas wahigi sihini og, “Mas ho ne Baibelna mo ne nanguni mo? Autunam God elim eseagenaba afa sa saglag mi angwafig mi eseawagena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Afa God esog, ‘Asa ma kwamblog el heafna alagim afa afagim fwatiginam ika heafna angwagim hawagenam afa sama mungwafe.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Afa mas enmuna fiagafe eba ati mungwafeg. Asa el nofekawu pwatihiagahfe eba God ati waheg fwatigig.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Afa farisi ehem enaig sahinifini og, “Haisegba Mosesna nihe mo sihig, el membeg heafna angwagim oningihiafiba asa ma ginofe faiba sama ukwi?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Sisas pese sihini og, “Nengelni olug liputini enaig esenaba ena mog Mosesna nihe mo sihina og, ‘Sesi’. Afa autunam eba mas enaigofena mo. ");
INSERT INTO amn_amanab_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ka nem sihini angwafig ming saglag i apugu afe fwainigba enam heafna alagag ningihianam afa ming angwafig flagba eba enaig ati mingnag angwafigim fapugu fenig.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Afa patalfuiag el sihini og, “Afa nofeka angwafigim ningihia afa konigig angwafigim flag fwainigba eba suialafeg.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Sisas sihini, “Nengelni mo angwafigim flag fwainigba. Mungwali el enag mo mas membi higigim. Afa ambanim sa God fai eba sa ehe ena mom patalkui. ");
INSERT INTO amn_amanab_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Eba haig haig mog el enaig eseg mas angwafig lambi. Mingnag elbi maia afag wanigagba eba elig amtakwalig, afa mingnag elbi heafgelni nihem enaig eseg laligim pukunig, afa mingnag elbi angwafig lambi fwainigba eba heafgelni mungwali onigig Godna bog megam sefugo. Amban ena moba anwenafigba eba sa ne fla.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","El luwalim Sisas nangu wanambena og ma Sisas kagelni luwalim ningana tohunigenam asa Godim sihina. Afa patalfuiag el elim esogoni, “Mangofi, asim wanafu.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Afa Sisas sihini og, “Sama luwalim wanambei ka nangum afa nofene kwegoni. Amban el enag luwal lofegba eba Godna bog megba enaig elni.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Afa ehe luwalim ningana tohunigenam enanai fwahanam ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Afa el Sisasim blo sihina og, “Anwena el, ka membeg wahkig nofkena flagim afa sa ka suialag gafugafe?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Afa ehem sihina, “Haisegba ne kam sahanag og, ‘Mango suialagba?’ God mungu eba ehe suialag. Ne membeg wahkig nofkena flagimba sa ne Godna nihe mo patalku.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","El sahanag, “Ham nihe mo sa ka patalkufe?” Sisas wahigi sihina og, “Hwa niheba enaig eseg, nofeka elim tigefati, afa nofeka ming angwafigim aga fatinai, afa nofeka ukwefe, afa nofeka ming elim makwal mo sihina. ");
INSERT INTO amn_amanab_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Afa sa ne nimbiafna alag mi afag mi ahnai skaufen, afa sa ne nimbiafna hihem aflafen asa ati nimbefum enaig esifafefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kwamblog el Sisasim sihina og, “Kaba ati enam mungwali nihem patalku. Ilawaba ka mangwal esefe?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Sisas esona, “Ne suialag elbi ofefiba eba sa nimbiafena mungwali gawig mingnag elim faibi asa ne kig flanam afa ena kig gawig fwainig elim mimagen. Ne enaig esegba eba sa ne suialag wag heven lanai flafe, afa sa ne kam sum patalku.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Kwamblog elni kaksag gawig fenaba, afa ehe ena mom higinam olug kinigafenaba asa ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Afa Sisas heafna patalfuiag elim esoni og, “Nufunam ka nem sihinig, asa elbi gawig nubini feg, enaba Godna bog megam wasneife mas ikagna seaifoi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ka nem pese osihin, kamelba tata kwania. Atiaho sa enaba gwelig nil megamba seaifoi? Enaba gwelig nil megam hugufeiba eba fwina wasneig. Asa enaig el membeg Godna bog megam seaifoiba eba gwesim numweheg.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Afa maia patalfuiag el ena mo higinim sineminefinim etetiagini. Ehengel sahini og, “Amban sa ihlafefe Godna el pugufe?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Sisas nofna fahiagenam sihini og, “El mas neana mo enaig esi. Afa God ehe ihlafefe mungwali eseagegim.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Afa Pita esona, “Is sahig, kagel ati ka mungwali gawig fwatiagigim asa ka nem sum patalfug. Mangwal sa God kam faife?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Sisas ehengelim sihini og, “Ka nufunam mo sihig, maia enanam mungwali gawig pese yimieg puguia minefeiba asa Nufunam El ehe ganam mungwali nangwagihiagefe. Afa enanam ne kana 12 pela patalfuiag el augunam asa ne Israelna 12 pela simbianingam nangwagihigife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Afa ambangel sa kam sum patalfu eba naho heafna lala, nilite, mulwal, alag, afag, luwal, afa aso fwatigim eba sa 100 gwesim hiliflai afa eba nofkena wahkig gag flafe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Afa ilawo kaksag el goseg afuia eba ambe sum afwahiefufe afa kaksag el sa sum ambe eba afu gosefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Sisas pese gwena mo sihiagena, “Godna bog megam eba gwenai eseg. Mungu el leana kumbi ikag gafugag elim yisigi lambinam asa heafna aso la lasanfe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Afa gafugag el ehe sawiefig mungu osuna gafugafim asa mungu kig denarius lambim. Asa asona alag asogam ningitigi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Osu bahigini asona alag pese ika mingnag elim nangwaganaba esug afofena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Afa ehe sihini, ‘Neangafa afu aso gafugafi asa ka nem kig suialag faife.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Asa ehengel afuna. Afa osu misosuf gigini afa osu gahagwagna asona alag pese mingnag elim gwenaig esini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Maia osu opegfenaba ehe pese ika gofenaba nangwagna mingnag el esug safewagfenaba asa ehengelim sahini og, ‘Haisegba asa ne esug ese afu?’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Afa ehe esogona, ‘Mas kam amban gafugag fwahianig mo.’ Afa asona alag sihini, ‘Neangafa ese afu kana aso gafugafi.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Maia osu pe fenaba asona alag heafna misog gafugag elim unenam sihina og, ‘Gafugag elim mungwalim unenim kig mimangin. Afa sa sumi nai elim mimangin ikan kan kan goflanai elnai yi pugu.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Afa ambangel sa sumi yi apuke gafuga fini enag mungu mungu kig denarius lambini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Afa el sa leana gafuga fini enag enaig onigini og eba ka kig denarius kaksag lambfi. Afa ehengel gafa mungu mungu kig denarius lambini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Afa kig denarius lambinim afa sona alagim lagini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ehe og, ‘Sona elbi sumi yi apuke gafugafigbi eba moalagig gafugafig afa kagelbi osu ihnolna gafugafig ikag osupeg. Afa ehengelni kigba kagelni mungwalofug kig.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Afa asona alag wahigi sihini, ‘Hihe, ka mas nem amtakwale fati. Ena kig mungu sa ka nem faigba enaba ati big sihiage afwahana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Sa flanam ika kikeafena sawieg la ka sumi elim gwenaig kig faig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Hwa kigba eba kikeafena. Ena kigba sa ka kikeafena onigi la enaigba esefe. Haisegba nane ninimug eba ka membeg ming elim kaksag kig lambwaig?’” ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Sisas enaig mo sihiage blo afwahafenaba enaig esona og, “Ambangel sa sum agfo eba afu gosebi afa ambangel sa goseg enaba ambe sum afofe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Afa enanam Sisas Jerusalem gam fukwakofenba heafna 12 pela patalfuiag elim wankafenaba enaig sihifeni og, ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Sa hig, ilawo big Jerusalem gam afuofeba eba Nufunam Elim flinim Godim sis tuhlu faiule el i afa nihe mo anwena elni ninga la fwahibi asa sihiagenim tigifatifi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Afa angoluwag elni ninga la faigoiba asa ehem moalamp mo fainim, afa wena fliflifena gife, afa li katigegla fli kahlifi asa sambaga mungu osuna puguiba asa ehe pese buihiafe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Afa Sebedini angwag heafna legnigim wanblonam mongkogini kwakwagena Sisasna kig mungu la penam, ogna sahana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Afa Sisas sihina, “Haiseg?” Afa angwafig enaig esona og, “Sa kam sihi fwahanaiba, maia ne kwania misog el puguiba asa ma kana luwalnigim ahblonam ming nihiginai ninga la gai afa ming blonam sahaganai ninga la gai.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Afa Sisas luwalnigim wahigi sihini og, “Asa ne sahigba mas ne anwenafig mo. Sa ne ihla ahfei ena susugba ahflai, asa ena susug kaf kamble flafe.” Luwalnigi sohona og, “Eba ka sahfefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Sisas enaig sihifeni, “Ei nufunam, eba ne kana susug kaf lanai ahnefe. Asa amban kana nihiganai ninga la gai afa amban sahaganai ninga la gai ka mas kikiaba hwaiba esoi. Kikeafna alag ati sambaganigi suialag kugba numwehiage fwahag amban sa ena kugba flafe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Afa mingnag 10 pela patalfuiag el ena mom higinim sambaganigim fegonigini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Asa Sisas ehengelim unenim sihini og, “Ati ne anwenafig afwambanai elni misog el ehe munguhe, afa ehengelni kwania el wasneig numweheg. ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Nofeka nimbefum enaig esiagi. Amban membeg misog elbi ogofiba ehe sa ma mingnag elim ahnai skaufeni. ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Afa amban membeg gosofefiba ehe sa ma nengelni esug gafugag el pugui. ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Asa ma Nufunam El gwenaig esei, mango blog el ehem kwefug mo, amo eba awai. Eba ehe ming elim kwaganigim afa heafna nofkena gag faig asa kaksag elim pese lambigim pigi fwatig.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Sisas Jeriko kembig fwahanam wankana afa el nubwel ehem sum patalfuna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Maia maisim afuiafenaba sambaganigi el nofug hafinigna mina embeg la ahafena. Ahiginaba og ati Sisasba oblo asa ahunena, “Nemba Devitna simbianinga sa kam aflafeni!” ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Afa mungwali el ehenigim fegonigini og, “Afwai.” Afa eheba fwina ahunena, “Ainiyag, nemba Devitna simbianinga sa kam aflafeni!” ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Afa Sisas gofenaba awamonim, sihini og, “Mango ka nem fenfe?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Afa sohona, “Ainiyag, ka membe ahfeg ne kam nofugum bahia aitin!” ");
INSERT INTO amn_amanab_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Afa Sisas aflafenim ehenigina nofugum tuhwagenaba asa ikagna nofug bahiawagena afa sa Sisasim ahpatalkuna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Afa Sisas heafna patalfuiag elim Jerusalem gam wankana. Wankan ena mug la unehlagba Oliv muhla Betfage kembig la wan puguna. Afa sa Sisas sambaga patalfuiag elim gof ningitiginam ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","enaig esoni og, “Ahkan okwena kembig la ahpugunam, afa ne ikagna ahnagoiba donki-tata mungu li mog la wena kiki fwahig asa luwaligim wanigofufe. Asa ahpiginam kam ahwani bluna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Asa amban ma nem haig moba sihinibi asa ahsihina og, Ainiyag enana ogna gafugafe, eba nem ikagna ningitigife.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Afa enaba pugugba eba Godna mo nufunam pugug. Ena moba Godna mo fla sihiule el ati sihi fwahana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","God og; Mungwali Saion lanai elim ena mo sihigon, sa nangu, nengelni misog el ati nem oblon, ehe mo flafla fwainig el afa ehe donki-tatana nihi yi fuko agagim oblo afa ehe donkina luwaligna gwenaig eseg. ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Afa sa sambaganigi el Sisasna mo ahiginam gwenaig sahfena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Asa ahkanam donki luwalig nahlum ahwani bluna. Afa heafnigina kwiyieg lofug hugufu askona donkina nihi yi asa Sisas enana yi fuko ganam ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Afa kaksag el heafgelni kwiyieg lofug hugfunim mina la suguafuna afa mingana mo li kigag totwaginim gwenaig esini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Maia Sisas ikafenaba asa mingnag gosini afa mingnag sum afofena afa mungwali sogona og; Sa Devitna simbianingam unehlagim fingifi fukwaligo. God sa ma suialafenai asa ehe Ainiyag na kigmogla oblo. Asa God sisinaim, ehena unehlagim fingifi fukwaligo. ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Maia Sisas ika Jerusalem la seaifunaba afa mungwali el ena kembig lanai sahawag ahfewagfna og, “Sona elbi amban maia?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Afa el afuiafenaba wahigi sihigoni, “Hwaba Sisas Galili lanai ehe Nasaretna Godna mo fla sihiaule el.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Afa Sisas Godna kwania lala ika pugunam el enanai yi kigna gawig mimage gofini asa ena elim fenigenam afwambala ningitigina. Afa el eyi mingnag kantri na kig mimange wagig simem Sisas waike waike fetifeni. Afa twafig gamp mimange wagig pegag simem gwenaig esena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Afa ehe sihini og, “God heafna buk la enaig sihifeg ‘Kana lalaba seflig God i sihiag ahfeg lala’ afa ne esigbi ena lalaba eyi ukwef el meagam afu saiye afwahie.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Afa enanai yi nofug hafinigna afa mong kukwalini ambe Sisasim nanguni. Afa ehe suialafetifena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Afa Godim sis tuhlu faiule el i afa nihe mo anwena el i kigmogim nanguni afa higinim luwal esogona, “Devitna simbianingam sifakalini” asa enag el olug kakagiagini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Asa Sisasim sahini, “Atiaho ne luwalna moba higig?” Afa ehe sihini og, “Ei ati ka higig. Mas ho ne ena Godna ginofba suwigig mo? Suialag sifakaleg mo weti luwal sihigbi eba God ehe eseg.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Sisas enanai yi elim fwatinam Betani kembig la ika gini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Afa leana Sisas pese Jerusalem gam ikan binilahana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Afa fig li mina ehembe la nangunam ikan muhla pugunam. Asa nanguna figeg behig gofena, fug awai. Asa liim esona, “Ne mas fuglei eba ne gwese gofufe.” Asa ikagna li fofena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Afa patalfuiag el enam nangunim sineminefini og, “Haisegba na sa sona fig libi ikagna fofeg?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Afa Sisas sihini og, “Ka nem nufunam sihinig, afa neana olug Godim oniginiba asa mas ne sambaga onigigufufi eba ne ihlafife hosa ka li esegba. Enaba neangafa gwenaig mugum ne esogofe, ‘Susum ika bula pe’ asa gwenaig esefe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Afa neana olug onigi gwese gohugba eba mangwaliba ne Godim sahinibi asa ehe esefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Sisas ika Godna kwania lala pese sefunam elim ogfuni ofefenaba afa Godim sis tuhlu faiule el i afa saglag el i ambe Sisasim sahini, “Haisegba asa ne enaigba eseg? Amban nem sihina?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Afa Sisas wahigi sihini, “Ka gafa ka nem mungwag asahtigi ma atiaba ne kam ihla osihinifibi ka sa nem sihin haig sa ka eseg. ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Amban maia esonaba asa Jon bula laitina, God me awai el me?” Asa ehengel hefum sihiwagini “Haig sihi sa big finifi? Afa big esogofiba, God ehem esona eba ehe sihife ‘Haisegba ne mas Jon na moba fli ni mo?’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Afa big esogoiba, el ehem esona eba asa big mungwali elim embefig onife ati mungwali onigig Jon eba Godna mo fla sihiaule el.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Asa Sisasim wahigi sihini, “Kagel mas anwenafig mo.” Afa Sisas sihini, “Kangafa ka mas nem sihini amban sa kam esenag.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Sisas pese sihini og, “Ne haig onigignafig numwehe onigwaginim asa sihi. El enaig esena heafna leg sambaga. Ehe etegim ika sihina og, ‘Sa ne glaba aso gafugafegimba ikai.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ehe sihina, ‘Kam oksi’ afa onigiwagean fwahanam afa sa aso gam ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Afa alag ikana suminegim gwenaig sihina afa sumineg og, ‘Ei eba ka ikafe’ afa ehe mas ikana mo. ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Amban alagna olugba patalkuna?” Ehengel esogona, “Eteg”. Asa Sisas sihini og, “Ka nem osihini nengel sumineg lofug. Nengel mas Jonna oningig patalkuna. Afa kig lambiule el i afa mina la afwamine angwafig i asa asaiyenam Godna bog megam gose afufe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Afa Jon blog Godna suialag mina nem ogfunig afa mas ne ena mo flig mo. Afa kig lambiule el i afa mina la afwamine angwafig i ena moba flig. Ati ne enaba nangug afa mas ne olug waike ena mo flig mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Sisas saglagim sihini og, “Sahig ming lasug mo, el enaig eseg wain aso fegim bogna gohla fwahag enag asolaba lifug pagag bumeko fwahag afa sime la lala kwina fe fwahag. Afa ehe elim enanai yi lasug fwahagim ehe mo membi yi kembig gam ikag. ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Maia wain fug pwatigim ofefiba asa asona alag heafna elim ningitigiba asa afu asa gafuga lanai elim sihigonife og asona alag membeg heafna mungwehigenai asa fai. ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Afa maia afu apukenaba asa aso gafuga lanai el patageminefinim ming elim tigaminefini, afa ming elim mo tigi fatini, afa ming i mo fun na wagini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Afa asona alag mingnag elim ningitigina ena elbi numwehena afuna. Maia apukenaba gwenaig esegoni. ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Afa sumi yi mo heafna legim ningihianam og, ‘Sama kana luwalim numwehe fli.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Afa aso lanai el luwalim nangunim hefum sihiawageni og, ‘Sonaba maia alag lahagba enag flag. Ause, nafu tigi fati asa big heafna safeg asa bignag fli.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Afa luwalim kehlinim asola afwambagam fli fatinim tigekini.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Afa Sisas sahini og, “Maia asona alag bloiba asa haig esenifi?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Afa esogona, “Eba amtakwalig elim tigi fatinim afa aso amo ming elim faifi eba ambangel asa mungwehigenai alagim ikagna faifi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Sisas ehengelim sihini og, “Ena moba ati Godna bukla goh. Haisegba ne na mas anwenafig mo? Mo enaig ikafeg; Ena sumulba lala nimblawagig el esugum fli fatig eba naho God esenagba asa sumulba gohug. Afa enaba fwina suialafeg maia nangugbi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Nasa ka nem osihi, God heafna bog megam nengelni ninganai flanam afa mingnag elim faife asa enag el nai yi fug lugufe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Afa amban ena aga la peba asa ehem tigia fwatife. Afa aga ambanim penam asa ehem fisgi fakafe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Pris el i afa farisi el i ena lasug mom higinim anwenafini eba Sisas ehengelni nihem sihina. ");
INSERT INTO amn_amanab_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Asa ehengel ogna ehem kehli afa mingnag elim embefegoni. Og eba ati onigig Sisas ehe Godna mo flaule el. ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Afa Sisas ehengelim pese ming lasug mo sihini og, ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Godna bog megam enaig eseg, misog elni leg angwafig aflaba asa misog el kwania bu yis ofen. ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Afa ehe elim sihinig og, ma ambe fane ahagai. Maia enena osu pugunaba asa heafna gafugag elim ningitigina og afu enaig elim sihigon, sa ma ambe. Afa el oksi ni ka mas ambe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Afa pese minanag gafugag elim ningitigina og, ‘Elim afu sihigon ati ka faneba numwehiage fwahag. Ati ka kwania bulmakau lambag kwagig. Mungwali ati gohug asa ambe ena bu yis ahaga.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Afa maia sihigonibi mas higini mo eheba heafna gafugag la ahkawag minefena. Ming el mo heafna aso gam ikana afa ming mo heafna ming gafugag la ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Afa mingnag mo misog elni gafugag elim kikegonuginim kwaskofini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Afa misog el olug kakagenam asa heafna amiim ningitiginaba afu elim kwaskofinim afa ehengelni kembigim suwina tuhlugoni. ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Afa heafna gafugag elim esoni og, ‘Faneba ati ka numwehe fwaha asa el sa ka sihini fwaha mango wangene el mo ena mo sa hwa faneba ambe ahagai.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Asa mungwali minehug afu elim ulambinim asa sihigoni asa ma hwa bu yis la ambe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Afa gafugag el afu ambangelim gafa ulambinim asa sulfu wan ambena. Wan ambenam suialag el i amtakwalig el i asa lalam tiflagena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Afa misog el sefu ikana nangwagna. Afa nangunaba el mungu mas bu yis la lofug yimieg fatina mo. ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Afa sahana, ‘Hihe, haisegba ne seaifug afa ne mas yimieg lofug fatig mo.’ Afa ehe malfwai gofena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Afa misog el gafugag elim sihini og, ‘Ningam mungum wena kikenaginim afa afwambagam sikigieg megam fli fati. Asa ma enanai yi, el wewatinam heafgelni gog tuto ahgafife.’” ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Sisas mo sihi afwaha fenaba og, “God kaksag elim unenigim afa mungu mungu elim kanog fwatig.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Farisi el afuna hefum mina tohlagini ogna Sisasna mom klimoani. ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Afa farisi elni patalfuiag el mi afa Herotna el mi asa ningitini og, “Ogfuiag el, kagel ati ka anwenafig neana moba nufunam afa ena nufunam moba ati ne elim Godna mina ogfu fenigeg afa ne mas onigi, ne gauna haig haig elim gafa sihinagfeg. ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Sa kagelni sahigim kam wahigi sihin. Bigna nihe atiaho enaig sihifeg sa big kigba Romna misog elbi fai me awai awai me?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Afa Sisas ehengelni amtakwalig onigigim anwenafinim afa esona og, “Mangigim ne kam ogihini? Nengel sambaga mengigna el! ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Sa kam takis kig ogfuni.” Asa ehengel mungu kig flibina. ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Afa Sisas sahini og, “Amban na nofbosug i unehlag i asa nanai yi go?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Afa esogona, “Sisar, Romna misog el.” Asa Sisas sihini og, “Sisarnaba asa Sisarim fai afa Godnaba asa Godim fai.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Afa ena mom higinim afa ehengelni olug fingi feskofenaba asa ehem lasu afuna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Ena osuna Sadyusi el Sisasim nangum ambena. Sadyusi el enaig onigini og melig pigieg elbi mas buihiagafe. Afa sa Sisasim sahini og, ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Ogfuiag el, Moses enaig sihifena, afa el luwal fwainig lahagba heafna sumineg sa ma ehena esig angwafigbi flai asa ma luwal etegna sigag la unefei. ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Afa autunam elegeg la gohug nilite ka afwaihiafena. Eteg angwafig flana maia lahanaba luwal fwainig. Asa esig angwafig agafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Afa ehem angigieg flana afa ehem gafa luwal fwainig lahana. Asa gwenai pigifeakan sumineg atamolug nai yi puguna, ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","afa sumi yi enag angwafigim gafa lahana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Afa autunai la maia enanam melig pigieg buihiagafeba asa ehe amban na angwag fefe afa mungwa nilitena enag angwafig mungu flini?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Asa Sisas wahigi sihini og, “Godna buk i afa heafna kigmog i ne mas anwenafig mo asa ne etetiagig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Afa maia enanam melig pigieg buihiagafenam mas angwafig lambi eba ehe Godna oflanai el lofifi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Afa enag onigig melig pigieg buihiagafe ena moba eba ati Godna buk la gofna afa ne mas higig mo ena mo God nem faini. God enaig sihifena og, ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Kaba Abraham, Aisak, Jekop na God.’ Eba mango melig pigig elni God mo, eba heafa nofkena elni God.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Afa mungwali el ena mom higinim ehengelni olug fingi fiasaina. ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Afa maia farisi el higinim Sadyusi el Sisasim mas ihla sihini mo asa mungwali wahenam Sisasim afu nanguni. ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Mungu el eba nihe mo ogfuiag el. Ehe ogna Sisasna mom klimoanim asa sahini og, ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ogfuiag el, ha nihe mo asa mingnagim gosinig?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Afa Sisas ehem enaig sihifena, “Sa ne Godim nimbiafena Ainiyag fwina membena. Sa ne nimbiafena olug ni, sungwabug ni, afa onigi na fwina Godim membena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ena nihe moba kwania fegim ehe goseg. ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Afa angigieg nihe mo gwenaig esog og, sa ne nimbiafena hihem fwina membena asa ne nimbefum enaig sifafefe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Afa ena sambaganigi nihe molaba mungwali Moses na nihe mo i afa Godna mo fli sihiule elni mo i enanai yi sefu ahgo.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Afa farisi el laskuhla gofnaba Sisas ehengelim sihini og, ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Elbi sonaba God ati Gisfu fwahag elim pese lambigim, enaba ambana simbianinga?” Afa ehengel wahigi sihini, “Eba Devitna simbianinga.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Afa Sisas sahini og, “Haiseg nasa Godna Sungwabug Devitim olug onigi la fainaba asa Devit ehena unehlagim seaflana, Ainiyag. Devit enaig esona og; ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","God Ainiyag kana Ainiyagim sihinag sa kana nihiginai ninga la pegafim ikan ikan ka sa kike neana fagiule elim tigi feskonam asa ka nem faife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Afa Devit ehem seaflana, Ainiyag. Haisegba enag ehe Devitna simbianinga?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mas amban pese sihina mo afa enag osuna ikan hefum lahafe ehem sahnigim embefini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Afa Sisas heafna patalfuiag el mi afa mingnag el mi sihinuwagena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","Ehe enaig esona og, “Farisi el i nihe mo anwena el i Mosesna nihe mona nem ogfu fegonuwugini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Afa ena mo sa nem faigoba enaba asa higinim patalfu. Nofeka ehengelni nihem patalfu, mangofi. Mom sihigim afa ehe mas enam patalfu mo. ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Afa ehe elim kinig kike faigog, afa ena kinigba elim, kahli afa eheba mas ena kinigim ningana weti sehilini mo. ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Afa mungwali haig haig asa esiagibi eba elim og sa ma kam nangwagi. Afa betenna wagna wawag gigim afa betenna kwieg lofug la we bugugni kigfig fwatig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Afa kwania bu yis la ehe ogna misog el lofug augu afa laskuhlag lala ehe ogna sime suialag la gose augu. ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Afa ehe enaig membig laskuhlag fohugla el sa ma ehengelim une goni og saglag el afa ogfuiag el. ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Afa ese nem enaig seflifife ogfuiag el. Eba mungu neana ogfuiag elbi, afa ne nilitena fiakag. ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Afa hwa bite la nofeka elim sefli alag fei eba nengelni alagba mungu he heven la ga. ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ese nem seflifi ne saglag el eba el mungu he nengelni saglag elbi eba God ati Gisfu fwahag elim pese lambigim. ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Amban nengelni Ainiyagba asa neana gafugag el fefe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Amban hefum figi fukuagba eba God ehem pagaupife afa amban hefum figi fukuag fwainigba eba God ehem figi fukufe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Sisas enaig sihifeni og, “Niasabanig, farisi el i nihe mo anwena el i amtakwalig nem pugunufe. Eba ne sambaga mengigna el. Ne elim mina kikise gonig Godna bog megam saiyegim. Afa nimbeba mas ne saiye afa el ogna saiye afa ne gwegonufu.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Sisas enaig sihifeni og, “Niasabanig, farisi el i nihe mo anwena el i amtakwalig nem pugunufe. Eba ne sambaga mengigna el. Afa ne esig angwafigim makwale gonigim afa ne ehengelni lala lambigonig. Afa enaig esigim afa ne makwalig kwinam beteniaska. Ena mog eba God amtakwalig susug nem numwehe faife.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Sisas enaig sihifeni og, “Niasabanig, farisi el i nihe mo anwena el i amtakwalig nem pugunufe. Eba ne sambaga mengigna el. Afa ne biteamina afwaminefig afa bu mina botla afug eba mungu elim neana patalfuiag elim ne fwahig. Afa enaig patalfuiag elbi nem kwaganig gose ikafe suwilagig latu minagam. ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ne nof tetini el mingnagim wanafu mina ogfugonig eba nem amtakwalig pugunufe. Ne enaig sihi fegonug afa amban Godna kwania lalam unehlag seflanam afa mo sihi fwahafe eba esug sihi fwahag. Afa amban Godna kwania lalanai golim seflanam afa mo sihi fwahafe eba asa ena mo nufunam eseg. ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Nengel moietet el afa nof tetini el. Mangwal sa goseg, gol me awai Godna kwania lala me? Mas ne anwenafig mo lala goseg asa Godna lala enag golim esenagba eba Godna nemug. ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Afa ne elim sihigonig, afa amban sis tuhlu Godim fai simem seflanam afa mo sihi fwahafe eba esug sihi fwahag. Afa amban Godim fai sisim seflanam afa mo sihi fwahafe eba asa ena mo nufunam eseg. ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ne nufunam nof tetini! Mangwal sa goseg sime me awai sis eyigig me? Afa mas ne anwenafig mo sime goseg, asa Godim fai sime enag sisim esenagba eba Godna nemug. ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Asa maia amban Godim fai sime seflanam afa mo sihi fwahafe eba sime i afa mangwal enanai yi afugwagim ena mo wasneig fwahag. ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Afa maia amban Godna kwania lala seflanam afa mo sihi fwahafe eba lala mi afa God eyi agag lala ena mo wasneig fwahag. ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Afa amban heven seflanam afa mo sihi fwahafe eba Godna nangwaghiageg simem seflag afa God ehe enanai yi pegagim seflag ena mo wasneig fwahag.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Sisas enaig sihifeni og, “Niasabanig, farisi el i nihe mo anwena el i amtakwalig nem pugunufe. Eba ne sambaga mengigna el. Afa yasmoel unehlagba mint, dil, kumin ne lambigim afa 10 pela hap suguafugim Godim mungu fai. Enam weti nihe mo ne fwina onigig afa kwania nihe mo enaig eseg elim numwehe gwefihiaginim, asa aflafegoni, afa suialag olug onigig mas ne esig mo. Asa ne esi afa nofeka kwania nihe mo fwahi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ne nof tetini el mingnagim wanafu mina ogfugonig! Ne buba ahagaba nambaganai bulanai lambuhiagig afa ne mas nanguna mo kamel-tata bu la go afa ne ena nahgum neg.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Sisas enaig sihifeni og, “Niasabanig, farisi el i nihe mo anwena el i amtakwalig nem pugunufe. Eba ne sambaga mengigna el. Afa ne kap i plet i sisinai mungu gigiafiagig afa mo fla flag i afa faghagig i enanai yi memtola pugu go. ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ne farisi nof tetini. Kapim ilawana mo sa ne meagam numwehe gigiafinim asa ma afwambanai yimieg.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Sisas enaig sihifeni og, “Niasabanig, farisi el i nihe mo anwena el i amtakwalig nem pugunufe. Eba ne sambaga mengigna el. Ne biteg fe lofug lambo bite bigna fatig fwahi. Afwambagam mo suialag go afa meagam mo kig i lofug i nongi go. ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Nengel gafa gwenaig esig. Afwambagam mo el nem nangwagi ne suialag el afa meagam mo sambaga mengigna fegim amtakwalig nihe go.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Sisas enaig sihifeni og, “Niasabanig, farisi el i nihe mo anwena el i amtakwalig nem pugunufe. Eba ne sambaga mengigna el. Nengel Godna mo fli sihiule elni biteg kifem suialafe flig afa suialag elni biteg kifem waganagig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Ne enaig esogog afa sa ka kagelbi simbianga la wan auguia fiteba eba mas ka esite Godna mo fli sihiule elim kwaskofi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Asa neana mo ogfug nimbe ne elni luwalig Godna mo fli sihiule elim kwaskofig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Sa esi, ilawana simbianga haig esini sa ne gwenaig ihla fwahi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Nengelba sombine afa sombinena luwalig. Haisegba ne onigig asa God mas kam suwi lagig latuigimba ningitigi? ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Sa hig, ka nem osihin ka kikiafena Godna mo fli sihiule el mi, anwena el mi, afa ogfuiag el mi nem ningitiginiba. Afa asa ne mingnagim kwaskofi, afa mingnagim li katigegla tigi kahlifi, afa mingnagim laskuhlag lala la wena fifiletififi afa mingnagim patagemine fifibi asa mingnag kembig gam afwiamine fefe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Asa ambangel suialag elim kwaskofig, enag elbi pigigba eba Abel la pugugum ika Sekaraia la pugug ena susuba eba mungwag ne flifi. Sekaraia Berekiana leg nengelni simbianiga olyi Godna lala afa Godim sis faig sime la tigekini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ka nem nufunam sihinig enag mungwali susug mungwag eba nem ilawonai elim pugunife.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Sisas sihini og, “Jerusalem lanai luwal, Jerusalem lanai luwal, ne Godna mo fli sihiule elim kwaskofini afa el God nem sa ningitigigba ne fun na kwaskofi. Wahkig ka membeg nengelni elim lamblu kiafnai yi muhla lambugofum afa ofenai kakaruk afag heafna luwaligim lamblu anglag meg gam kumo lambugu afa mas ne enaigim membeg mo. ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Asa God enag lalam neana fwahafe eba esugo fufe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ka nem enaig sihiofen mas ne kam nangui ikan kan ne enaig esogofe, ‘God sa ma suialafenai asa ehe Ainiyagna kigmog la oblo.’” ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Sisas Godna kwania lalam fwaha ikafenaba heafena patalfuiag el ambeafenaba ehem og sa nangu sona lala. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Afa Sisas sihini og, “Glau ne mungwali fun lalam ne nangug, ka nem nufunam sihinig eba mas gofi. Nengigimba asa fun mungwali bite la apaiyefe afa mas mungu gofi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Enana Sisas Oliv mug la gafena. Afa patalfuiag el ambe sisag mona Sisasim sahini, “Sa kam sihini ansi Godna kwania lalam amtakwalefe asa mangwal eseba sa ka anwenafi eba nemble blogim afa mungwali awaiyefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Sisas wahigi sihini og, “Numwehifibi masa el nem mwakwale gonife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Afa kaksag el ambenam kana unehlag la mwakwale afwaihena esogofe, ‘Kike Krais, God kam kanog fwahag.’ Ena mo kaksag elim mwakwalenife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Afa ne higife faghagig mo asa nofeka olug kinig eskofe. Afa eba asa sonaigba pugufe afa mungwali awaiye osunaba maisim. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Afa mingnag el afu mingnag elim angoluwag i hagfi afa mingnag misog elni el afu mingnag misog elni el i hagfi. Afa haig haig biteamba eba bini kwania i afa asag i puguiagefe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Mungwali enaigba ofe angwafig luwalim susugim oningis. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Asa enanam nem lambinim mingnag elim lambwaigoiba sa nem kwagi aitifi. Afa ne kana el afwaihiefiba asa mungwali el nem olug kakagegonife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Kaksag el kam onigigim fwahinim afa hefum mwauiaginim afa olug kakagiagifi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Afa kaksag mo fli sihiaule mwakwale el apukenam kaksag elim gasafihiagife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Eba amtakwalig nihe fwina kwania pugufe asa nubwel el mingnagim membegonugim yiskos siagife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Afa ambangel wasneig afwaihian ikan maia kinig awaieba asa ehe suialag gofufe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Afa Godna bog megam suialag mo mungwali kembig sihiageafufe asa mungwali el higwagife eba ati mungwali awaiyegim opugu.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ne nangufi mangwal fwina amtakwalig sa afsug kwegig mengig megam gofufe. Enam autunam Daniel Godna mo fla sihiaule el ati sihi fwahana. (Amban sa enam suwiginam sama anwenafe.) ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Afa enanam Judia nai el apukenam sa embem mug gam afufe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Afa amban lala la sisi gohugba asa nofeka mangwalba lalanaiba apuke lambug afu. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Afa amban asola gohugba nofeka pese lalagamba ika lofugba fla. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Enanam amtakwalegefe angwafig afnialigni afa angwafig luwalna! ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Afa sa ne Godim sahini, ne mas fwina ninegna afa esug auguia osunaba enaig enaba embem afui. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Enanaba kinig kwania fiahgenam puguiagefe. Autunam God bite gafugagfenam blo gla pugug enaig kinig mas gofena mo. Afa nengigim mas enaig pese pugui. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Afa God ikagna futefwagba fwainigba eba mungwali el awaiefe. Afa God kanog fwatig ena elim oniginigim asa futeafonig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Afa enanam maia el nem sihinibi og, ‘Sanangu Krais ohogo amo ehe akwenaiyigo eba el God Gisfu fwahag el.’ Nofeka ena mo higim. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Asa mwakwale Krais, afa mwakwale Godna mo fli sihiule el ambe apukefe. Afa ambenam haig haig kigmog ogfuiag gifi afa God kanog fwatig elim gaba enaig esehiagi me. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Enamba mahim fiahba ati ka nem sihi fwahanig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Afa el nem sihigonibi og, ‘Ehe bite behig go.’ Nofeka asim afu. Afa esog, ‘Ehe wanai yi sefu go.’ Nofeka higim. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Afa afwei osu puguiagam pugunam blo osu pegam ikafe asa mungwali el enam nangufi. Asa Nufunam El gwenai esefe oblofiba. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Hanai yi el melig pigieg afogwa enanai yi gungwe ambe laskuhlag.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Sisas enaig sihifeg, Gwenanam maia kinig awaiyeba asa ikagna enaig esefe, osu sikulufefe afa was mas laugwi afa bagnofut apaiyefe, afa oflanai wasneig wag fufiahsaifi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Afa enanam Nufunam Elni ogfuiag of la pugufe. Afa sa mungwali bitenai el wewati gofe asa ehengel Nufunam Elim nanguibi sisi leango la kwania wasneigini afa kwania ombusugini wahe blofe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Afa fuf kwania mwasiba asa ehe heafena of lanai elim sambaga sambaga bite ehembegam ningitigiba asa mungwali bitegam afu God kanog fwatig elim lambwagiafufe asa mungu la afu laskuhlafe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Sa ne fik li lasug mo anwenafi. Afa maia li kag auwiauofefiba afa sa li figeg yiminig pugufe asa ne anwenafi eba suialagna meyiofe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Gwenai ese maia ne nanguibi asa mungwali puguiagefe sa ne anwenafi eba ati muhla meyiofeg afa eba pugufe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ka nem nufunam sihinag sonag el maisi afofiba asa mungwali enaig puguiagefe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Of i bite i mungwali awaiyeba afa kana moamo wahkig gwesegofufe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Mas amban anwenafe hag osuna sa enaigba pugufe. Godna oflanai el i afa heafena Leg mas anwenafig mo eba Alag mungu anwenafeg. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Hosa ilawana Noa wansena gwenaig esefe maia Nufunam El oblofiba. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Afa maisi bu puguia fwainig fiahfenaba enanam mungwali el hefum ahagagifini afa angwafig lambwagifini gwenaig ese afufenaba asa Noa mungu wanseaifuna sip yi ba. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Afa mungwali mas anwenafini mo enaig puguiagim. Gwenaig eseafufenaba asa bufle kwania blona mungwali kalefena lambkuna. Maia Nufunam El oblofiba asa gwenaig esefe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Sambaganigi el asola gafuga ahfegofiba asa God mungu flaiba afa ming mo gofufe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Afa sambaganigi angwafig na ahsne gofiba asa God mungu mo flaiba afa ming mo gofufe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Asa numwehifibi mas ne anwenafig mo hag osuna nengelni Ainiyag blonigim. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Hwa mo asa ne anwenafi. Afa lalana alag anwenafegba ansi sinaini sa ukwef el blofe ehe numwehego mas fwahai ukwef el lala gam sefu blogim. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Asa neanga numwehe, Nufunam El enag osuna oblofiba ne eteti gofife.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Amban sa misog el goseg fwahagba, asa mingnag gafugag elim fane mimangenigeg? Eba sawieg el onigig anwena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Enaig el sama sifakale maia misog el pese blo ehem nanguiba asa suialag gafuga fegofufe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ka nem nufunam sihinig misog el ehem fwahaiba asa heafena mungwali gawig nangwaghiagefe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Afa gafugag el amtakwaligba ehe onigig misog el eyi maisife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Afa ehe gohugum mingnag gafugag elim kwagaitifegim asa uflogna bu ahagaule elim fane wan neg afa bu wan neg. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Afa enag osuna ehe etetife asa heafna misog el enanam pese blo pugufe. Gwenanam ehe mas anwenafe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Afa misog el blonam ehem hige hige feskofefe. Afa sa ehem sambaga mengigna elim wahe fwatiba asa enanai yi eyu watinam gog kike skofefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Sisas esona og, “Enanam Godna bog megam enaig esefe 10 pela angwafig angwaming heafgelni lam lambini afu uflini el mungu angwafig ogna fla. ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Afa afala pugufe angwafig onigi etetig afa afala pugufe angwafig onigig anwena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Onigig etetig angwafig heafgelni lam mo lambinim afa wel mo mas lambini mo. ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Afa onigig anwena angwafig mo wel botol la lam nahugum lambugafuna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ena el ogna angwafig fla enag maisi fiahfena. Afa angwafig nengiafuhun nof tuta feaisainaba non askafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Afa ambagolugini el uneni og, ‘Hwag el ati oblo angwafig flagim. Au ambenam asa afu.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Asa mungwali angwafig angwaming bugia gafenam afa heafgelni lam numwehiagini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Afa onigig etetig angwafig onigig anwena angwafigim sahigoni og, ‘Is ai, kangelim nimbiafgelni wel sugfu faigo. Kagelni lam ona fuflu skofe.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Afa ehengel wahigi sihigoni og, ‘Amo hwaba mas bigim ihlafeni. Naiba nimbiafena afu stoa lanai lambinim.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Afa onigig etetig angwafig maia wel lambigim afuiafenaba asa enanam el angwafig flagim ika puguna. Mingnag angwafig asa ati numwehiagini, ena mo angwafig buyis la sefu wankanaba asa el mengig kikise fwahana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Afa mingnag angwafig sumi yi ambenam esogona og, ‘Ai saglag, kangelim mengig pigini!’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Afa ehe wahigi sihini og, ‘Amo, ka mas nengelim anwenafinig mo!’” ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Afa Sisas esona, “Ne mas anwenafig mo ansi osuna sa nengelni Ainiyag blofe asa numwehifibi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Godna bog megam enaig ese mungu el ona membi ika. Ehe gafugag elim unenigim afa heafna gawig mimagenigim sama numwehe lambfufi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Afa kig mungu mungu mimagenugegim afa amban sa wasneig gafugafe asa ehem mo 5,000 kig faig afa ming elim gweifeg ehem mo 2,000 kig faig afa yiskosule mo 1,000 kig faigim asa ehe mo ikag. ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Afa el 5,000 kig flanam enana uku ikagna gafugag fenam afa ming 5,000 kig flana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Afa el 2,000 kig gwenaig esena ming 2,000 kig flana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Afa ming el mo 1,000 kig flanam ukunam mas enana gafugagfena mo eba ukunam bite konam misog elni kig kumohla fwahana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Maia managenaba asa misog el pese blonam afa heafna elni gafugagim fahigiage. ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Afa el 5,000 kig flanam afa ming 5,000 kig flablu faina. Ehe og, ‘Ainiyag, ne kam 5,000 kig kana ninga la fakagba sa ka enana gafugafegim ka pese ming 5,000 kig flag.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Heafna misog el ehem sihina og, ‘Ei, ne sawieg el neana gafugag eba suialag. Ne enag wetim numwehiaflagba asa ka nem aluwegig faiba sa ne numwehiaflafe. Aublo ka sifakaleba sa ne gwenaig ese.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Afa el 2,000 kig flanam gwenaig esena blonam og, ‘Ainiyag, ne kam 2,000 kig kana ninga la fakagba sa ka enana gafugafegim ka pese ming 2,000 kig flag.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Heafna misog el ehem sihina og, ‘Ei, ne sawieg el neana gafugag eba suialag. Ne enag wetim numwehiaflagba asa ka nem aluwegig faiba sa ne numwehiaflafe. Aublo ka sifakaleba sa ne gwenaig ese.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Afa el 1,000 kig flanam blonam og, ‘Ainiyag, kati anwenafeg neana onigig wasneig. Neflanai neana aso la ne mas ihi afa ne esug lambiule. Afa ming el maia gafugafegba asa ne ena nai lambig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Enag ka embefeg ena kigna gafugafegim asa ka neana kig ukugum bite megam kog kumohlag. Neana kig honaba, sa nangu.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Afa heafna misog el wahigi enaig sihifena og, ‘Neba amtakwalig yiskosug gafugag el. Atiaho ne anwenafeg neflanai kana aso la ka mas ihi afa ka esug lambiule afa ming el maia gafugafegba asa ka ena nai lambig? ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Haisenaba ne mas kigba uku fakana mo benglaba? Afa maia ka pese oblofiba asa ka enana kig i afa winmoni i flafe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Ena kig flinim asa ming elim fai hosa 10,000 kig flag. ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Asa ambana nubwel goh eba mingnag faife asa kaksag fenafe. Afa ambana enaig fwainig wetifegba eba enaba mweahlanafe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Afa enag amtakwalig gafugag elim afwambagam sikulufeg megam flafatiba, asa enanai yi eyu watinam gog kike skofefe.’” ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Maia Nufunam El heafna oflanai elim pese wan oblofiba asa ehe kwania misog el fefe. Ehe heafna suialag kife la ganam ena nai yi mungwali elim kwefihiagefe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Afa mungwali bitenai el ambe ehena nofbosugam laskuihlafe. Asa ehe mungwali elim kwefihiagenam asa mange tigife gwenaig esefe sipsip nangwaghiageg el sipsip mi meme mi mange tigife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Eba lambinam sipsipim nihigim lasani afa memeim sahagam lasani. ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Afa sa misog el nihiginai elim sihinifi og, ‘Aublo, kana alag asa nengelim suialafihiageg. Au ambenam nimbiafena gau fli eba Godna bog megam. Ilawana mungwali bite puguia fwainig fiahfenaba God ati numwehe fwahana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Asa bini kam lahanaba ne kam fane faini afa bu hef kam fenaba ne kam bu efiyaini afa ka afwambanai fenaba ne kam nimbiafena lala gam wanigafuna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Ka lofug fwainig fenaba ne kam lofug faini afa kam gihenaba ne kam wanigaflafena, afa ka kalabus lala la ka gafenaba ne kam ambe nanguni.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Afa enag suialag nihe el esogona og, ‘Ainiyag, ahanana saka nem binilahagiba nanguni afa fane faini, afa bu hef ne fenaba ka nem bu efiyaini? ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Ahanana sa ne afwambanai fenaba ka nem lala gam wanigafuna, afa lofug fwainig ne fenaba ka nem lofugba faini? ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Afa ahanana nem gihenaba ka nem wanigaflafena, afa kalabus lala ne gafenaba ka nem ambe nanguni?’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Afa misog el wahigi sihinifi og, ‘Ka nem nufunam mo sihinig ne mungu esug elim esinig eba kana nilite enaho ne kam esenag.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Afa sa misog el sahaganai elim sihinifi og, ‘Kam fwahinim afu. God nem heafna mona esinibi. Sa ne suwi lagig kembig gam afu. Ena kembig Satan mi afa heafna gafugag el mi ati numwehiagig fwahanig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Asa bini kam lahanaba ne mas kam fane faini mo afa bu hef kam fenaba ne mas kam bu efiyaini mo, afa ka afwambanai fenaba ne mas kam nimbiafeni lala gam wanigafuna mo. ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ka lofug fwainig fenaba ne mas kam lofug faini mo afa kam gihena, afa ka kalabus lala la ka gafenaba ne mas kam ambe wanigaflafena mo.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Afa ehengel esogona og, ‘Ainiyag, ahanana ka nem nanguni bini i afa bu hef i afa afwambanai ne fena afa lofug fwainig ne fena afa gihena, afa kalabus lala ne gafena asa ka nem mas kwegfuni mo?’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Afa asa ehe wahigi sihinifi og, ‘Ka nem nufunam mo sihinig ne mungu esug elim mas esinig mo enaho ne kam mas esenag mo.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Afa enaig elbi afunam susu amtakwalig wahkig gohug lambfi afa suialag nihe elbi eba afunam nofkena wahkig gohug lambfi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Maia Sisas ena mo mungwali sihiage fwahanaba asa heafna patalfuiag elim enaig sihifeni ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","og, “Ati ne anwenafig sambaga osuna mungu goh enaba Pasova buyis. Afa Nufunam Elim mingnag elni ninga la faife asa ehem li katigegla kahlifi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Afa enanam saglag pris el i afa Israelna saglag el i Kaiafasna lala laskuiahlana ehe misog pris. ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Afa maisim Sisasna minam yisginage aflafena ogna mwakwalinim asa kehlinim tigi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Afa esogona og, “Mas big Pasova buyis laba esi masa el nanguim afa ninumugonam apukenam hagfe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Sisas Betani kembig la ehe Saimon na lala gafena. Ena elbi autunam gih lepra fena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Enana angwafig sanda fun botolna flanam asa ubluna, enag sandaba kaksag kigna. Asa lala fukona afa Sisasba sime la gafenaba asa angwafigbi sanda bug Sisasna misog la sugfunagena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Afa patalfuiag el enam nangunim ninimugona afa esogona og, “Mangigim sanda bugba awaieg fatig? ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Asa big fwahiteba ma el kigna flite sa big kig kwania flite afa asa big gau fwainig elim kwaganite.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Sisas ati ehengelni mom anwenafenim afa enaig sihifeni og, “Haig esegba sa ne angwafigimba kinigbi faig eba kam suiala feaflag. ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Afa el gawig fwainig gwenaig wangafufe. Afa kable ka mas nem gwenaig wangafi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Afa angwafig sanda bug asa kana elig yi sugfug eba kana eligim numwehiagflag asa biteg kife la fakife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ka nufunam nengelim sihinig afa mungwali bite asa ena suialag mo sihiafufe asa enaig angwafig ati eseg eba sihiafufiba asa ehem onigifi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Enanam Sisasna patalfuiag el mungu unehlagba Judas Iskariot ehe ikanam saglag prisim nangwagena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Afa esona og, “Mangwal ne kam faife asa ka Sisasim nengelni ninga la fakafe.” Afa asa ehem 30 kig silva suwiginim asa faini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Afa Judas mina yisiginam ona Sisasim ehengelni ninga la faka. ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Enanam ena buyis seflig ‘Bret Yist Fwainig’ puguna. Asa ena buyis la angig osuna patalfuiag el Sisasim ambe nangunim esogona, “Hanai yi ne membeg kagel asa fane numwehiagifi afa sa ne nefe Pasova buyisba?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Afa Sisas esoni og, “Afu kembig la apukenam afa saiyenam asa ena elim kana mo ufu sihini, ‘Anwena el enaig esog kana osuba ati awaiegimba muhlafeg koka Pasova buyis patalfuiag elim neana lala wane.’” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Afa patalfuiag el gwenaig esini maia Sisas esonibi afa asa enag fanem numwehiagini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Afa kwekwe watini Sisas 12 pela patalfuiag elim sime la peganam fane wanena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Afa ahagaflafnaba asa esona og, “Ka nufunam nem sihinig nengelinai amban mungu kam ikanam elim mwaufe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Patalfuiag el ena mom higinim olug kinig eskofena afa hefum sahwagini mungu mungu esogona og, “Ainiyag, mango ne kam sona mo?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Afa ehe pese wahigi sihini og, “Nengelinai amban mungu ka fane ahneau enag ehe kam ikanam elim mwaunife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nufunam Elbi eba lahafe, ati Godna buk la sihi fwahana asa lahafe. Afa amban sa Nufunam Elim, elim mwaunufe eba niasabam. Eba suialag afag mas ehem wanigaite.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Afa Judas mwaug el Sisasim sahana og, “Anwena el mango ne kam sona mo?” Afa ehe wahigi sihina og, “Ei eba neana mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Afa sa ahagaflafenaba sa Sisas bret mungu flanam Godim sahanam asa patalfuiag elim kukoskofenam mangeni afa esona og, “Lambinim ahaga, hwaba kana elig.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Afa wain bug kafna gwenaig esena flanam Godim sahanam asa mangeni afa esona og, “Sa mungwali enaba ahaga. ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Hwaba kana taf ena taf eba ogfu fwaha Godna mo sihi fwahag ena moba nufunam. Ka taf sugfoiba asa kaksag elni nufwehi mo huguflaitinife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ka nem sihinig ka mas nem pese wain bugba wan nei eba ikan ikan sa ka mulug wain bug nem kikeafna Alagna bog megam saiyenam wan nefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Afa mwanafi fatinim ena kembig mo fwahinim asa Oliv mug gam afuna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Afa Sisas heafna patalfuiag elim esoni, “Nengel nangufe maia mangwal kam opugunafiba gla sinaini afa nengel kam fwahinim asa ne embem afufe afa Godna buk ati enaig sihifeg og; Ka sipsip nangwaghiage elim tigeiba sama sipsip mo embem afuaminafe! ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","“Afa ka pese buhiafe afa ka nengelim Galili gam gosenifi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Afa Pita wahigi ehem esona og, “Mangofi, afa mingnag mungwali nem fwahi afuiba afa kaba mas enaig ese kafi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Afa Sisas ehem esona og, “Afa ka nem nufunam sihinag enaba gla sinaini kakaruk mwasiag fwainig fefiba asa ne sambaga mungu nagim esofe ne kam mas anwenafeg mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Afa Pita ehem sihina, “Mangofi, kaba nei mungwal big lahawagife afa ka mas esoi, ‘ka mas nem anwenafenag mo’, awai nemug.” Afa mungwali patalfuiag el mungu mo esogona. ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Afa Sisas patalfuiag elim wankanam enag bite seflig Getsemani. Ehe og, “Hwa nai yi auguiafiba kaba osum betennegim ako.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Afa Sisas Pita mi afa Sebedina luwalnigi mi wankana. Afa ehena olug kinig fwina eseafenaba. ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Afa ehe sihini og, “Kam olug kiniageg kam lahagim ati meyiofe, hwa nai yi auguiafiba asa nofkikena fiahflafim.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ehe gwesim mwakwalig hili ikanam asa nofbosug bite la penam betenena, “Kanapi ena kafteba sa ne kana ninga lanai mwehlai. Asa nofene kana membug la ese afa kasa nimbiafena membeg la ese.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Afa ehe pese blo nangwagnaba afa patalfuiag el non askafena. Sisas Pitam sihina og, “Atiaho, sa ne kai mungu aua mas nofkena big afeg mo? ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Sa ne nofkena fiahflafiba afa beteneflaf masa nem yuhunag pugunibi ne mas wasneig afofi. Sungwabug mo sawiefeg afa elig mas kigmog mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Afa ehe pese sambaga nagim ikanam betenena enai esona og, “Kanapi, eba ne mas ena kafba mwehlai afa ne og sa ka neba eba ihlafeg, ka membeg nimbiafena onigi la sa ma pugui.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Afa ehe pese blo nangwagnaba afa patalfuiag el non askafena eba ehengelni nofug noftuta fiahsaina. ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Afa ehe pese fwatinam ikanam sambaga mungu nagim gwenaig betenena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Afa ehe pese blonam patalfuiag elim sihini og, “Mahiaho ne askaba afa hekulafla? Is sa hig, ati opugu mwauule el Nufunam Elim amtakwalig elni ninga la fwahagim. ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Buguia gafenam nafuiago. Ati mwauule el oblo!” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Sisas maisim mo sihi gofenaba el ambena. Ena elimbi saglag pris i afa saglag el i ningitiginibi. Asa pina i afa maluwi i lambinim asa Judas wanblona. Judasba eba 12 pela nai patalfuiag el mungu. ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ena mwauule el i afa el i laskuhla sihiageni, ehe enaig esoni og, “Ka ma ambanim asanktata ofeflafiba eba naho asa ne kehli.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Asa Judas ikagna blona Sisasna muhla pugunam og, “Ei Ainiyag”, afa asa ehem asanktata fiahflana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Afa Sisas ehem enaig esona og, “Hihe, mangwal sa ne fegim oblo, eba sese.” Asa el Sisasim ambe kehlini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Afa enana maia Sisasim okehlifinibi heafna el mungu pina skoflanam misog prisni gafugag elim angugum higeflaitina. ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Afa Sisas esona og, “Pina pese hugufe. Afa amban pina skoflagba eba pina ehem tigeiba asa lahafe. ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Atiaho ne anwenafeg eba ka kikeafna apiim sahanaiba eba 12 pela ami i afa mingnag ami i oflanai elim ningitigiba asa ikagna ambe kam kwegfufi? ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Afa ka enaigba eseba eba Godna mo mas nufunam pugui. Godna buk ati enaig sihifena asa enaig kam pugunafe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Afa Sisas mungwali elim sihini og, “Ne enaig onigig kaba ukwef el ho nane pinana malunaba fla blug kam flig? Afa mungu mungu osuna ka Godna kwania lala gafenam elim ogfufenig fakafenaba afa ne mas kam flini mo. ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Afa enaig mungwali asa pugugba eba ati Godna mo fli sihiaule el ati ginofi fwahini asa nufunam pugu.” Afa mungwali patalfuiag el Sisasim fwahanim embem afuminefena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Afa enag el Sisasim kehlinim Kaiafasna lala gam wanigafuna. Kaiafas eba pris misog el. Afa saglag el i afa nihe mo anwena el i ena lala laskuiahlana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Afa Pita sum sum fiahkan ikana pris misog elni lalam ambagala ikagofena. Ehe bog megam sefunam anwasag el nai yi wahe auguiafena. Ehe ogna Sisasim nangwag gofum maia haig esofinifibi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Afa saglag pris i afa mungwali saglag el i laskuiahlanam mingnag elim og ma haig mo Sisasim mwakwal mo sehinim asa ehem tigi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Afa mas mangwalim nangunim mo asa kaksag el goba ambeafnaba ehe gwenaig mwakwale mo esini. Afa sumi yi sambaga el ahblona, ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","afa ahsohna, “Sonag elbi enaig esog, ‘Eba ka esefe Godna kwania lala bubugenam afa sambaga mungu osuna ka pese nimbalafe.’” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Afa pris misog el buihia gonam afa Sisasim esona, “Haisegba nane mas ena mo mungwag sihini mo?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Afa Sisas eba mwalfwaigofna. Asa pris misog el ehem pese sahana, “Afa Godna unehlag la nofkenagag ka ilawo nem sahana sa ne nufunam sihi, asa kagelim sihi neaho Krais, Godna leg?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Afa Sisas wahigi ehem sihina, “Ei gwenaho ati ka nem mungwali osihini, nengigim ne nanguibi Nufunam El Godna nihiginai ninga la ganam afa ofla leango i wahe blofe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Afa gwenanam asa pris misog el heafna lofug piple skofenam afa esona, “Ehe Godim mwalapinag. Nofena mingnagna mo higigon, magofi. Nimbe ati ne higig ena mwalap moba. ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Afa ne haig onigifig?” Afa ehengel wahigi sogona og, “Ehe enaigule afa sa ma lahai.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Asa ehem nofbosug la memp kusufinim afa tigekini afa mingnag ehem ningafana pupu flaminefini, ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Afa esogona, “Neaho Krais asa Godna mo kam sihin, ambangel nem tigafu?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita ambagala gafena afa gafugag angwafig angwaming blo muhla ehem pugunam afa esona og, “Neanga Sisas Galili lanai i ne sahfekafena.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Afa Pita mungwali elni nofla awaiena og, “Amo awai, kaba mas enaba anwenafeg mo, mo sa ne sihigba.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Afa gwesim hili ika bog mengig muhla gohfnaba afa ming angwafig angwaming blo nangunam gwenaig esona maia mungwali el gogafnaba og, “Hwag elbi Sisas Nasaret lanai i ehe sahfekafna.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Afa Pita pese enaig esona og, “Nufunam nemug, ka mas enaig elbi anwenafenag mo!” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Afa ma nagig fwainig el muhla afohiafena nag ambe Pitam og, “Nufunam ehe neba enanai el he eba ati nimbeafna mengig pugug.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Afa Pita enaig esona ka maste nufunam oi, atiaba ka enaig esegba eba God sa ma kam amtakwale fati! Ehe enaig esona og, “Nufunam nufunam nemug ka mas enag elbi anwenafenag mo!” Pita enaig sihife gofnaba gweyi ikagna kakaruk moasiyina. ");
INSERT INTO amn_amanab_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Asa ehe pese ena mom onigina Sisas sa sihina og, maia maisim kakaruk moasiag fwainig fefiba ne sambaga mungu nagi esofe ka mas ehem anwenafenag mo. Afa asa afwambagam pugu ikafnaba nugwakal ufwe feagena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Asa leana saglag Pris i afa saglag el i mungwali laskuhlanam Sisasim tigi fatigim sihiagini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Afa wasneig wena kikenaginim asa wanig afuna. Wanig afunam Pailatba gavmanna misog el nai yi fwahini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas mwauule el enam nangunam anwenafena maia el Sisasim tigigim sihi waginibi asa hefum pese afwanefena. Afa ehe ena 30 kig silva flanam ogna uku saglag pris mi afa saglag el mi pese fai. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Judas enaig esona og, “Kati amtakwalegeg. El haig eseg fwainig ka nengelni ninga la fwahagba asa ehem tigife.” Afa wahigi ehem sihini og, “Mango kagelni moala mo eba nimbiafena moala.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Asa Judas ena kig Godna kwania lala la laiti fwaha ikana. Ikanam we la luguna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Afa saglag pris ena kig flinim esogona, “Hwa kigba elni tafim na flag asa bigelni nihe mo sihig nofene Godna lala na kig i wahe faki.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Afa ehengel sihiageni ena kigba asa big bite enana fli. Ena biteba el bite sospen gafugafe fiahgiafufena ehengelni flagoni. Afa ena biteba angoluwag elni melig pigieg na bitefe fwahini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Asa enaba seflig Taf Bite gwese goh. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Enanam Godna mo fli sihiule el Jeremaia na mo nufunam puguna. Autunam ehe ati sihi fwahana og, “Ehengel ena 30 kig silva lambini eba hanansi kig Israelnai el sihiagini asa ehem flifi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Afa enanai yi el bite sospen gafugafe fiahgiafufena asa ena kigba ena bite flini, eba enaig eseg God kam ati sihinag.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Gwenanam Sisas Pailatna nofbosugam gofena. Pailatba gavman na misog el. Afa sahana, “Neaho Ju elni misog el?” Afa Sisas esona, “Ei, ati ne sihig.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Saglag pris i afa saglag el i Sisasim ninga bulni sufini afa Sisas mas wahigi sihini mo. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Afa Pailat ehem sahana, “Mas ho ne ena kaksag moba higig mo asa nem kufi fwahig?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Afa Sisas mwalfwai gofenaba asa Pailat oniginagegofena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Enanam Pasova buyis la maia ambanim membi finibi asa gavman na misog el kalabus nai elim mungu fwahafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Afa enanam el mungu gofena mungwali ati anwenafini ehem amtakwalig el heafna unehlagba Sisas Barabas. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Asa mungwali el laskuiahlanaba afa Pailat sahini og, “Ambanim ka fwahafe, Barabas me awai Sisasim me eba el seflig God Gisfu Fwahag El?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pailat ati anwenafini el Sisasim ambofehlinim asa ehena ninga la fwahini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Afa maia ika elim kwefihiageg kife la gafenaba afa heafna angwag enag mo faina og, “Ka itila nangugba enag elbi esinigbi eba haig eseg fwainig.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Saglag Pris i afa saglag el i mungwali elim kuku sihiaginim og sa Pailatim sahini ehe sa ma Barabasim mo fwahanam afa Sisasim mo tigi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Afa Pailat mungwalim sahtigina og, “Ambanim sa ka fwahafe?” Afa ehengel mungwali esogona og, “Barabas.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Afa Pailat sahini og, “Sisasim, el seflig God Gisfu Fwahag El sa ka haig esenafe?” Afa ehengel esogona og, “Li yi kukufenagi!” ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Afa esona, “Haisegba? Mango maia fenaba?” Afa fwina esogona, “Li yi kukufenagi!” ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pailat ati anwenafenim ehengel mas mom higini mo afa ogna hefum hagim asa ehe ehengelni nofla ningam bula suwagena. Afa og, “Sonag elbi lahaiba eba kana moala mo eba nimbiafgelni moala.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Afa mungwali ehem sihini og, “Ehena tafba kagel i afa kagelni luwalim mi sa ma gofi!” ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Afa ehe Barabas mo ehengelim fwahanim asa Sisasim soldia na ninga la fwahinim asa wena fliflifenaginim afa sa li yi kukufenagife. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Afa Pailatna soldia Sisasim gavman na lala wanigafuna. Mungwali soldia ambenam ehem waki fakana. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Afa ehena lofug mo hugufli fatinim afa tafnaig lofug fatini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Afa nasigna we kugunim misog la fatini eba enaig eseg misog elni mwakwal lofug. Afa misog elni mwakwal agat nihiginai ninga gam faini. Afa mongkogini kwakwaginim asa afwanef mo sihini og, “Ei nemba Ju elni misog el.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Afa ehem memp kusufini afa agat pese flinim enana misog gim tigini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ehengel gwenaig esenaginim afa lofug hugufli fatinim afa pese heafna lofug fatini. Afa kehlinim wanigafuna ona li yi kukufenagi. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Afa wanig afuiafenaba Saimon Sairini nai elim uflinim og Sisasim kwefunam li katigeg sa kufehlakuna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Afa afu Golgota bite la apukena. Ena unehlag mog eba seflig melig misog bite. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Afa enanai yi wain bug flinim miaklana buna wahe nehini. Afa Sisas gihinam oksina. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Asa li katigegla kukufenaginim afa katna gosisini asa amban nana Sisasna lofug flai. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Afa nanai yi auguiafenaba nangu flafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Afa sisi ehena misog laba enaig ginof sihig mangwal el esena. Ena ginof enaig eseg og: ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Afa enanam Sisasna muhla sambaganigi ukwef elim lambtinim asa mingim nihiginai ninga gam li katigegla kahlini afa mingim sahagam ningagam gwenaig esini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Afa kaksag el afu muhla angmuwagi finibi fafufena. Afa ehem afwanef mo enaig esogona, ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Sa ne ona ka Godna Kwania lala boflaitinam asa sambaga mungu osuna pese nimblafe. Afa ne Godna legba naiba sa li katigegla fwahanam pe!” ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Afa saglag pris i nihe mo anwena el i afa saglag el i gwenaig esogona og, ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Ehe mingnag elim fakwaganfe kafena afa mas hefum mo ihlafenam kweagfwi. Ehe eba Israelna misog el? Atiaba pegba asa big ehem olug onigini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Eba ati ehe Godim oniginagim afa esog, ‘Kaba Godna leg’. Sa big nangug ma atiaba God ehem ilawo okwefugfiba.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Afa sambaganigi ukwef el li katigegla nai Sisasim gwenaig esohona. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Afa osu misosuf gigini si mungwali bite kigi fakana ikan ikan sambaga mungu aua la puguna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Afa ena sambaga mungu aua awaiegim ofefenaba asa Sisas fwina unena og, “Eli Eli lema sabaktani?” Ena moba og, “Kana God kana God haisegba nane kam afwaha?” ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Afa mingnag el muhla afohiafenaba ena mo higinim afa esogona og, “Sona elbi Elaijam ounenag.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Afa el kikini ikagna ikana spans flanam wain bug la figihianam aga la kikenam afa sa Sisasim nehna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Afa mingnag el esogona og, “Au maisim, nawo nangwafufum ma atiaba Elaija blo okwefufiba!” ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Maia Sisas pese unenaba asa heafna sungwabug sugu fwagenaba asa olug pwatfuna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Afa gwenanam Godna Kwania lala nai lofug olyi plewagena pekan pitikafena afa asag ihlafonam fun tutohia apaiyefena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Afa bitegfeg tofpi fiahkana afa Godna el kaksag pigina enanam bigiagafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Maia Sisas pese buihianaba asa ehengel bitefeg fwahinim afa afu Jerusalem la apukenaba asa kaksag el nangwagini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Soldiana misog el afa soldia i Sisasim anwasag fiahfofena. Afa enanam haig haig i afa asag i eseaginaba enam nangunim asa ehengel embefinim afa esogona og, “Nufunam he, sona elbi Godna leg he!” ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Afa kaksag angwafig ambe membiagig afofenaba heagafa nanguni. Ena angwafigbi Sisasim Galili nai patalbina asa Sisasim kwefu. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Afa mingnag angwafig eba Maria Makdala la nai angwafig. Afa ming Mariaba eba Jemsna i Josepna i afag. Afa ming angwafig Sebedina legnigina afag. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Osupegna Josep Arimatea la nai el blona Pailatim nanguna. Josepba kig kaksagna el afa eba Sisasim patalkuiag el. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ehe Pailatim sahana ogna Sisasim flauku. Asa Pailat soldiaim esoni, “Sisasim pitigiflinim asa Josepim fai.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Afa Josep ena melig flanam flaukunam asa yimieg lofugna kikenagina. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Josep heafna mulug fun meg ati numwehiage fwahana asa enanai yi sefuku fakana. Asa fun mogug teuitfefku mengigim pwakafenam asa ikan. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Makdala la nai afa ming Maria i membi agig hawag fenaba asa fun megim ahnangufena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Afa numwehiagig osuna mo awaienaba afa ming osuna mo asa saglag pris i afa farisi el i Pailat nangugum afuna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Afunam esogona og, “Saglag luwal ka onigig autunam enag mwakwal el nofkena ati sihi fwahana og, ‘Sambaga mungu osuna awaiyeba asa ka pese buihiafe.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Asa ma ne esoiba sa ma soldia afui bitegfem sambaga mungu osuna anwasafe. Masa heafna patalfuiag el ambenam flifunam elim enaig esogonife ehe ati pese buihiag. Enag mwakwale mo sumi puguniba eba fwina amtanafefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Asa Pailat esona og, “Sesi, soldia sulfunim afunam biteg la numwehe anwasa fiahfofum.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Asa ehengel afunam bitegim kikisinim asa soldia mo kaguni afofena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Afa esug auguia osuna maia awaienaba afa leana gubi Maria Makdala la nai i afa ming Maria i bitegfe ahnangwagim ahblona. Eba Sande angig osuna sahfena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Afa asag kwania ihlafona asa Ainiyagna oflanai el penam blo puguna. Afa fun fla waike fenam asa enanai yi sisi gafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ehena eligbi afwe lofena afa heafna lofugba busbusiagena leango lofug. ");
INSERT INTO amn_amanab_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Afa anwasag el ehem fwina embefenagini afa kiafigig geaskofenam apaiye melig pigieg lofug afogwafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Afa enag oflanai el sambaganigi angwafigim sihini og, “Nofeka embe ahfe, ati ka anwenafeg nenigi Sisasim ahyisgiegim ahblo. Enag elbi li katigegla tigini kahlig. ");
INSERT INTO amn_amanab_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Eba mas ohiaba gif mo eba ati pese buihiakag ehe ati enaig sihifena. Sa ahblo ahnangu ehena kifegim. ");
INSERT INTO amn_amanab_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Asa pese ikagna ahkanam patalfuiag elim ahsihini, asa enaig sihi afen, ‘Ehe ati pese buihiagim eba Galili gam gof ikafe asa ne enanai yi ehem nangufi. Ati ka nem sihinig.’” ");
INSERT INTO amn_amanab_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Afa angwafig enanai ahfwahanam ahkana, afa ehenigi embeafiahfnaba afa ming ehege mo sifakale ahfena. Asa kikini ahkanam patalfuiag elim ahsihini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Afa ahkafenaba Sisas gwei ikagna pugu ulambina ehe enaig esoni og, “Leana”. Asa ehenigi ahblonam ehena mongim ahkehlanam unehlagim fingi ahfena. ");
INSERT INTO amn_amanab_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Afa Sisas sihini og, “Nofeka embe ahfe asa ahkanam kana nilitem ahsihinim asa Galili gam afu sa ma kam enanai yi nangui.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Angwafig maisi ahkafnaba afa mingnag anwasag el kembig gam afunam saglag prisim sihi goni mungwali sa haig haig Sisasna biteg la puguna. ");
INSERT INTO amn_amanab_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Afa saglag pris i afa saglag el laskuhlana mo sihiawagenim asa ena soldiaim kaksag kig faigona. ");
INSERT INTO amn_amanab_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Afa ehengel soldiaim enaig sihife goni og, “Sa ne enaig sihifini og, ‘Heafna patalfuiag el sinaini ati ambeg meligbi flifug maia ka askafenaba.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Afa atiaba gavman na misog el ena moba ati higigba eba kagel ehem sihinagifi eba mas ne olug kakageni.” ");
INSERT INTO amn_amanab_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Afa soldia kig flinim gwenaig esini. Ena mo Juda nai el sihiageafuiag ika gwesego. ");
INSERT INTO amn_amanab_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Afa 11 pela patalfuiag el Galili gam afunam mog la apukena, Sisas ati ehengelim sihi fwahiani. ");
INSERT INTO amn_amanab_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Maia ehengel Sisasim nangunim ehena unehlagim fingifini afa mingnag sambaga onigina fini. ");
INSERT INTO amn_amanab_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Afa Sisas muhla pugunam sihini og, “Mungwali heven la nai i afa bite la nai i God kam kigmog faigba asa ka lambugu. ");
INSERT INTO amn_amanab_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Enaig esegba afa sa ne afu mungwali elim esegonigibi asa ma kana patalfuiag el afohi. Sa ne ehengelim bula Alagna afa Legna afa Godna Sungwabug ni unehlag la laiti. ");
INSERT INTO amn_amanab_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Afa sa ne ogfu fegonigi sa ma ena mo mungwali patalfui sa ka nem faig. Nofeka eteti eba ka nem wahkig wangafufe ikan ikan enag osuna awaiyefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ohuna momba sifakalig mo lahlag Sisas Krais Godna legna mo. Autinam newug God Gishu Fwahiana el mungom, ona emba ka wa ningihiaf mungwali elim kwaganigim. (Ehena wunehalamba Krais, enag wunehalamba enag enaig eseg, elim kwaganigim God nangum wanbogum.) Enag Israel el enag elim enam nisanafafema. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Enag enaig apekugonam enaig eso profet Aisaia ginofena enam. Profet el enag enaig eseafena Godum mengigim higifinim enag elim sihinugekafena. Godna mo enag Aisaia ginofena; Emba el kana mom ombuogum ka ningihiaf, emba wa neana gof yikaf. Mina nem numwehianagegim. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","El enag bete amtakwaligwa agafuf el hwanigwa. Enaig wunonugum, ‘Ainiyagna mina numwehiahu, wankeneg mina esi. Enaig esi, nimbefena olug enag numwehiagi.’ Aisaia enaig ginofena iwanam. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Enag Jon, buwa aitiag el, bete bihig wa ena puguna, enag Aisaia ginofena, enaig mo sihinugena, “Negel olug enag wahigifi, ahanaig ahanaig amtakwalig enag eso hwati. Enaigba ne esimbi, God nem enag ahanaig ahanaig amtakwaligim hugufatinif. Enaigba ne esimbi, emba sa ka nem buwa aiti.” Jon enag enaig sihinugena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Enag esoh el Judia provins wanai Jerusalem kimbig nalig yinai, afa mingnag kimbig Judia provinswa ena kimbig wanai gamba Jon nangum ambogona mo higigim. Eheafena amtakwaligim enag sihiagigim, enag Jon buwa aitina. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jon lofug lahlag awaienamba Jon kamelna lag lofugugum fatiafena. Sis lofug hugufugum kigiugwafena. Afa negba angtita wang suwig buk enag ehba neafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Enag enaig mo Jon sihinugena, “El mungo kana sumi yi ombo. Ehena tifutukmba kam flafaitig. Kamba wangeneg elmo enag ahanaig ehefena gafungagba ka esemo. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yawoamba kamba nem buwa mungo aitiaka. Ehemba kana sum bonam, emba sa nem Godna Sungwag mimangeni.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Enananamba Sisas Nasaret kimbig Galili provins wa agafena, enag ena kimbigim wahia bona. Jon Sisasim Jordan bu wa fatina. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Afa Sisas buwanai fusufu pugunamba yikagna gwenagehe nangonamba of pitigiafonam Godna sungwag gamp lofug pembona Sisas nangum. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Awagna wune of wanai pugunam esona, “Nemba kana leg, ka nem membenag. Kana olug nem lahlafenag.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Eso yikagna Godna sungwag Sisasim bete bihig gam el hwanigam esim ningihiana, og, “Eso ka!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Was enag mingwo puguka wahana afa mingwo yawo puguna gofnamba ena bete amtakwalig el hwanigwa Sisas enag aganam, eso Satan, sungwag amtakwalig enag, onanawo Sisasim gihnam wanigim ahanaig ahanaig amtakwalig esegim enam. Afa Sisas mas ena mom higna pahalukunamo. Sisas enag ehefwaimu mungo sisnga auguiafenamba. Ensel, Godna gafungag wanai of wanai Sisasim kwegfuni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Mayi Jon kalabus yi namba, Sisas Galili provinsgam bona puguna Godna mo lahlag sifakalig sihinugena, “Ena mo God yuwana sihina, enag ati pugug. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ati muhwa puguagim ofe God elim wanagagim God afalig fenigim. Olug wahigifinim, ahanaig ahanaig amtakwaligim enag hwati. Godna mo lahlag sifakalig higinim pahalukahu.” Sisas enag enaig mo osoni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Sisas Galili wahegmeg bu muhwa langwagofena enag Saimonmi ehefena suminigmi Andrumi nangwauguna. Sambaga ningigi enag fufwala aitiagahfegofena Galili wahegmeg buwa, gwenaig gwesa ahfefenam sawog ahwambugo ahfegofena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Sisas sambaga ningigim enag enaig sihefeni, “Neningigi sawog ahwambugofena, yuwamba kam ahpahalumbo, enag ka nem sihinugem elim ah sulufugum, elim ahsulufunam ka nangum ah wan bogum.” Sisas enag enaig sihifeni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Yikagna el sambaga ningigi enag sawug kikiaugug gafungag enam ahwahianam Sisasim ahpahalukuna. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Enagna gwesim wesig hilikanam eso Sebedini leningingim, Jems mi Jon mi enam Sisas nangwauguna. Sambaga ningigi enag botwa ahgofenamba fufwala numwehiag ahfegifini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Sisas sambaga ningigim wunoni, enag sambaga ningigi ehefena awagim Sebediim ahwahiana ahkanamba, eso, awagwo botwa agafena, ena gafungag wanai elingimba gweyi gofofena. Enag sambaga ningigi ahkanam Sisasim ahpahlukuna. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Sisas ehefena nihiyinaim Kaperneam gam wankana. Mayi Sabat osu pugunamba, eso Sisas ehefena nihiyinaim Kaperneam nuwagig lalagam saho wankana. Sabat osunam Israel elmbi enaig esifini gafungafi hwanig, yusug auguiafena. Auguiafenamba enag ehefena nuwagig lalagam ahuafena Godna mo higigim. Enag Sisas gamba gwenaig eswanfena. Sisas ehefena nihiyinaiim Kaperneam nuwagig lalagam saho wankana. Ena lalawa elksa wahegagena agafena. Sisas tisana kugwa gohnam sihinugena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","El enag Sisasna mo higinim ol wahegesaina, enag enaig sihinugehufena, “Mingnag elbi Mosesna mom sisifugunu gifini. El enag enaig sihigoni ‘Ufuana mo higinim, pahalukahu.’ Afa Sisasba enaig sihinugehmo! Awai! Ehmba enaig sihifeni, ‘Kikefena mo higinim, pahaluku.’ Enamba enaig esenam, mayi sihinugeimba, amangal higinim olug wahigifigmbi. Ehefena mo kifutugum enag.” El enag sihigonugini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Enanam el mungo nuwagig lala wa agafena enag Satana nihiyinai amtakwalig ehena nihiyi gofena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Mo enaig osona, hlehlefukona, “Sisas Nasaret wanai, amang na kam bogum fenigim ombo? Amang na kam amtakwalehiagegimho? Ati ka nem olninginag. God nem gishu fwahiagim nem ningihiag ehefena gafungafegim.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Sisas Satana nihiyinai amtakwaligim enam nunumuafanam, enaig osona, “Mengig ka penifenam, elim enam wahianam pugubo.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Enag Satana nihiyinai amtakwalig enag kiafigikninina hlehlewo fukonam ehena nihiyinai puguna. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Enag mungwal el enag olug wahig saina enag ehefum ol mewa sihiagahufena. Elimba amangwo? Elimba mulug mo. Elmbi suelimba anuana Satana nihiyinai amtakwaligim sihinigmbi enag ehena mengigim pahalug ahuag. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Enag esenamba ena mo enag yikagna yikanam mungwal kimbig Galili provinswa eyi puguna. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Sisas yikagna nuwagi lalam wahianam enag Saimon Andruana lalagam wankana mungwal Jemsmi Jonmi gamba. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimona angwagna afagim eligim gih nolog gegofena enag kukwa gifini, enag yikagna ahunam Sisasim sihini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Enag Sisas ehenangum yikana, ningagana kikehalanam gifiolohuna. Afa eso gih nolog enag gweyi awaienamba, eso angwafig enag gweyi bwihianam wohof gafungafena elim kwagana. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Owuipegnam sinainim, gihna elim Sisas nangum wambuk ambogona, mingnag wo gihna, mingnag wo Satana nihiyinai amtakwalig nihiyi gohonfini enaigim. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Mungwal el enag kimbig wanai ena lala mengig muhwa mungwal nuwagena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ahanaig ahanaig gihim Sisas numwehenugena. Satana nihiyinai amtakwalig wahegagena enam Sisas nigitigina. Satana nihiyinai amtakwalig enag Sisasim ati olningini. Enaig fenamba enag Sisas Satana nihiyinai mengigim ka penifeni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Leawa kwimbiyim, Sisas bwihianam lala kimbigim wahianam, bete el hwanigam yikana, Godum sihinafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Enag Saimon ehefena nihiyinaim wankanam Sisasim yisigiahuna. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Ahunam wufuinim eso Sisasim enag sihini, “Amang fegim osumba na bok? Mungwal el enag nem yisigiahu, ogogum ‘Kam kwagan,’ enam.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Sisas mungwag sihinugena, “Yuwanamba kawo mungwal mingnag kimbig muhwa gohka esim nahunam enanayi ka sihinugekam. Enaig fegmba enag ka osum bok.” Sisas enaig sihifeni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Enag Sisas yikana mungwal kimbigim Galili provins wa, enanayi langwagofena. Sisas mungwal nuwagigim lalawa mo sihinugena, enag Satana nihiyinai amtakwaligim elni nihiyinai ningitigiafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","El mungo enehegog amtakwalig Sisas nangum bonam. Mogukuk kwakwagenam wenamonag sahna, “Na sawiyifegba, emba sa na kam enag lahlafenagei.” Sisasim enaig sahanafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Sisas enag nalig afafena, mas embefenamo yikagim enaig elni muhwa puguagim enag ehefena ningagana enag elim tuhunam, enag sihina, “Ka sawiyifeg, nem ma lahlefei.” Sisas enaig sihifena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Yikagnamehe gih gweyi awaienam enag lahlafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Sisas enag elim tifutuk mo sihinagenam eso yikagna ningihiana. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","Sisas enag osona. “Nofeka amanim sihinam esel ka nem esenag enam. Awai! Godna lala naligim yika pris nangum. Pris el enag enaig esfafif amang amang ofa enag el mayi wambuk ambogomba eso pris enag ofa enag Godum fa faiyif. Yikanam enag elim enag nimbefena eligim enam ogfunai, eso ma nem sihinai, ‘Nem gihba ati awaieg.’ Mayi nem enaig sihifenaimba eso Mosesna mom pahalukwi. God ena mo autinim Mosesim faina enag Moses ginofena, ena mo enag enaig osog. Amanim gih nihiyinai awaiegmba eso ma enaig esei amang amang enag Godum fai. Nemble enaig esei. Esba na feimba emba el olningif nem gih ati wanganefeg.” Sisas elim enana enai sihifena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Afa enag el enag yikanam muhwa sihiagena, ena mo enag mungwal kimbigam yikagna kagena enag elksa enag Sisasim yisigiahefena. Enaig fenamba enag Sisas yikagim elni nofwa kimbigam sahoagim enag wahiana. Awai! Kimbig meigim el hwanigam gofena. Ahanagna, ahanagna kimbig wanai enag el enag Sisas nangum ambogwafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mingnag osuwi mayi kanamba eso Sisas piskenam Kaperneamgam yikana, lala wa agafena enag mungwal el enag higini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Enaig fenamba eso mungwali el enag nuwagena, lalam megim enag el mungwal kigfana. Mengig muhwa gamba kuk goho hwanig fenam enam. Eso Sisas mo sihinugegofena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Figinyegwa gohna el enag elim elig lihiligim Sisas nangum ombugun. ");
INSERT INTO amn_amanab_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Kuk enag kigfagena mungwal el enag, enag ahnaig esigim Sisas muhwamba ombugugum fakihmo. Enaig fenamba enag wofusigim ofukwalagonam, eso enag wofus tutuni Sisas esel gofna enaihwa. El gihna kukwa gifini, enam weawa kikehalafinim opigona ehefena kuk noholugum weawa hilihili fak apeigona. ");
INSERT INTO amn_amanab_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ati olningini Sisasba emba wa kwegofuf. Sisas anuwana fenamba enag elni olningugugum enag ati olningini, enag Sisas gihna elim enam sihina, “Nilite, ahnaig ahnaig amtakwalig esoh nesena, enamba, ati ka nem hugufatinag.” Sisas enag enaig sihifena elim enam. ");
INSERT INTO amn_amanab_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mingnag anuana el auguiafena. El enag Mosesna mom ati olninginim enag ogofunugifini. Enag el enag auguiafenamba Sisasna mom higifinim, ol mewa enaig olningugefafena, ");
INSERT INTO amn_amanab_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Amangim enaig sihimba feg? Elmbi elimba Godum kiapasefag flafatig. Aman ahnaig ahnaig amtakwaligimba hugufatif? God mungwehe!” Anuana el enag enaig olningugefafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Yikagnam gweyiehe Sisas ehelni olugum enam olningini. Enaig fenamba enag Sisas elim enag sihini. “Amang figim negelmbi nimbefena olyimba enaig olningugefa? ");
INSERT INTO amn_amanab_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Aman elim ningagag elig enag lilhi fesaina enamba sihinaf, ‘Ahnaig ahnaig amtakwalig esoh nesena enamba ati ka nem hugufatinag.’ Enamba amanwo enaig sihifena, ena, mo enag yinime? Awaime? Mas na nangunimo. Afa amanwo sihina, ‘Bwihianam nimbefena kuk fanam yika.’ Aman enaig sihifena, ena mo enag yinime? Awaime? Embawa na nanguf. ");
INSERT INTO amn_amanab_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Enag yawomba ka nem ogofuni kamba El Enag God Ningihiana Of wanai enag yawomba ka nem ogofunug God kam tifutuk faig mungwal bete esel enam enaig ahnaig ahnaig amtakwaligim hugufatinigim.” Sisas enaig sihifena. Enag Sisas elim elig enag lihlig feagena enam sihina, “Yawomba ka nem sihina, ");
INSERT INTO amn_amanab_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Bwihianam nimbefena kuk fanam nimbefena lalagam yika.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Sisas mayi enai sihifenamba eso mungwal elni nofwa gihna el enag bwihianam, ehefena kuk fanam yikagna pugukana. Enaig mayi esenamba, eso mungwal el enag olug wahegesaina, eso Godna wunehalam gufiyi sisyigem fukwalagonam. Enaig osogona, “Autinamba mas ka enaigba nangufinimo.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Sisas piske yikanam wahegimeg bu Galili muhwa engig wa langwagofena. Enagsa el ehe nangum ambogonamba, enag. Sisas Godna mom sihinugena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Sisas yikanam, Alfiusni legim Livaim nangona. Livaiba takis wambuguk el enag takis lala wa agafena. Sisas Livaim sihina, “Kam pahalumbo.” Livai bwihianam Sisasim sum pahalukuna. ");
INSERT INTO amn_amanab_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Sisas enag esena yikanam Livaini lalagam fukonam agafenamba wohof neawofena. Sisas ehefena nihiyinai gamba mungwal auguiafena. Eso enagsa takis wambahug el i mingnag el gimba ahnaig ahnaig amtakwalig esehufena enag el gimba auguiafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mingnag anuana el Mosesna mo fig afa Farisi el. Enag el Sisasim nangunim ahnaig ahnaig elngi ahagafafena, takis wambuguk el afa mingnag elim osogoni amtakwalig el, enag el Sisas ga wohof ahagafafena. Farisi el enag nangunim, enag Sisasna nihiyinai elim sahigoni, “Amang fegim wohof mba mungwal el gimba ahaga, takis wambuguk el, ahnaig ahnaig amtakwalig esehug el gimba? Amang fegim Sisasba enaig elimbi wan neawofena?” Farisi mayi enaig sahigonibi. ");
INSERT INTO amn_amanab_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Sisas mom enam higinam eso sihini, “Amangal gih hwanig mba mas dokta nangumbi ahwi. Awai! Gihna mungwehe dokta nangumbi fehuf. El enaig osogona, ‘Kagelmbi wangeneg el!’ Kamba enaig elim wunonugum bwahmo. Awai! Kamba bogum el ahnaig ahnaig amtakwalig esehufena enam wunonugum ka bok.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Mingnam Jonna nihiyinai afa Farisi el gimba wohofum kwegfini. Mingnag el ambogonam Sisasim enaig sihifini. “Ahnaig asegmba enag Jonna nihiyinai afa Farisi el gimba wohofumba kwegig ahufena, afa neana nihiyinaimba mas wohofum enag kwegifinimo?” ");
INSERT INTO amn_amanab_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","20","Enag Sisas sihini, “Enag aman angwafig afafimba, ehefena nilite i, hiheg i, enag nuwagif sifakalinigim, angwamig fak el, mungwal gofofimba, enag yuhwahofeg. Mayi el enaig nuwagimba, wohofum kwegime? Awai! El mulug angwamig fak enag agagba mas wohofumba kwegi. Enag hwaonam mingnag el elim enam mayi fighuimba, afa enanayi gohog hwanigwa mayi feimba enanamba sa yuhwafe ehena hiheg so wohofum enag kwegig. Enag kamba el angwamig mulug fag lofug. Enag ka gofofenamba kikefena nihiyinai mungwal esel enag ohunanam enag el sa sifakali, mas wohofum ba kwegi. Esenam hwaonamba el amtakwalig kam sulufif, kam amtakwalefif, enag mas ka gofofi kikefena nihiyinai ga mung wal mba enag enanamba sa kana nihiyinai enag afafinim wohofum kwegi.” Sisas enaig sihifeni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Sisas sawiyifena Farisim mulug olningugigim ogofunugum enaig fenamba enag ahnaig ogofunuhmo mulugum enam. Enag el enag autinai mom mahiyim pahalug ahuafena. Enaig fenamba enag Sisas wanag enag wahiyini, enag wohofum enag mas kwegifinimo. Enag Sisas Farisim piskenam osoni. “Afa aman lofug nimyegmba fanam autinai lofug megimba kwelif? Awai! Enaigba eseimba, emba ena lofug nimyeg enag autinaim kufuwahiamba, meg pugunam numbif. ");
INSERT INTO amn_amanab_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Enag amanwo nimyeg wain bugba efiyif sis meme lofug autinai wulawamba? Emba, awai! Enaigmba eseimba wainbug ena wolawa kukunam mungwal amtakwalenam awaief. Awai! Elmbi mulug wainmbug mba mulug wola wa fanunguf.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mungwagim Sabat osunam enag, enanam Sisas ehefena nihiyinai ga mungwal aisagafe kafena wit asowa. Enag witbi rais lofug enaig feg. Ena wit fug enag pwatahaga fehufena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Enag Farisi el enanayi gofwehenam Sisasim nanguni. Farisi el enag Israelna lotum Ainiyag el fini. Enag Farisi el enag Sisasim sihini, “Mosesna moamba enaig osog, ‘Sabat osunam enag nofeka gafungafim, enag osuinamba esug ehe auguiafum,’ Mosesmba enaig sihifena.” Enag Farisi enag Sisasim enaig sahanafini, “Amang figim neana nihiyinai mba enaig mba esig?” ");
INSERT INTO amn_amanab_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Sisas Farisim sahini, “Mas na ginofumba buk wa naiimba numwehe fahegagikmo amang eseli Devit autinam esegena enamba. Enanam enag Devitna nihiyinaim enag wohof awaienimba ena bini pigina. ");
INSERT INTO amn_amanab_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Enanam enag Abiatar Israel pris elni mungwal sisiyi feni, alawieg feni. Prisni gafungag enaig fena, amang amang mungwal el prisim faifinimba, pris enag Godum faifini. Enanam Devit Godna lalagam sahonam bret fa nena Godna nohmbosogam gifini enag. Ena bret enag kwegig, pris mungo ahagafena. Enag Devit nenam ehefena nihiyinaim gamba faini. Enaig esenamba yuhwafena. Ena mo enag mas na fahegaginimo?” Sisas enaig sahinena Farisim. ");
INSERT INTO amn_amanab_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Sisas enaig osona, “God enag elimbi mas enaig sihifenigmo, ‘Negel enag Sabat osuwum kwegfu!’ Awai! God Sabat osuwum gishu fwahiag elim kwaganigim. ");
INSERT INTO amn_amanab_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kamba El Enag God Ningihiana Of Wanai, enag Ainiyag ka feg. Sabat gamba enag kamble mungo osog amang yuhwamba feg Sabat osuinamba.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Sabat osunam enag Sisas Israel elni nuwagig lalagam piskenam yikana. Enanayi el mungo ningagag lilhig agafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Enag mungwal el enanayi Sisasim nangwagofofena. Enaig olningini. “Elim enam wa numwehenageime? Awaime? Yuwa Sabat osunam enag Sisas wa gafungafeime? Awaieme?” Mungwali el enag enaig olningini. Sisas mba enag Sabat osuinamba gafunga feimba, emba nunumufinim kotinif. ");
INSERT INTO amn_amanab_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Sisas el ningagag amtakwaligim enam sihina. “Bonam olugi goh.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Sisas sahini el mungwal elim eseli nangwagofofena enam, “Ahnaig Mosesna momba osog? Sabat osunam enag bigba lahlafiime? Awaimba, big amtakwalefiime? Enag osunam enag amang big fimbi enag yuhwamba fef? Enanam enag big elimbi kwaganime lahla goheigim enam? Awaimba nawo elim enam kugwag sungo fiime?” Sisas enag elim enag enaig sahinina. Enag el ati olningini Sabat osunam elim lahla fehiaogug yuhwafef, enag el enag mas osogonamo. ");
INSERT INTO amn_amanab_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Enag Sisas nofna nangwagihiagegofenamba enag ehim olug kakagna. Afa Sisas ati olningini enag elni olug enag numwehegim olningugig hwanig. Enag Sisasim olug kinina, enag Sisas ningagag amtakwalig elim enam sihina, “Ningagag fa suf.” Enag el enag ningagag fasufinimba ningagag ena yuhwafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Yikagnam Farisi apekugo ahunam nuwagena Herotna nihiyinai ga mungwal. Enag nuwagenam sihiagehufena, “As big Sisasimba finim eso big tigegif?” Enaig sihiagehufena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Sisas ehefena nihiyinaim wankana ena kimbigim wahiyinim wahegimeg bugam ahuna. Enagsa el enag ambogonam Sisasim pahalug ahuefena. El Provins Galilinai, mingnag provins Judianai, ");
INSERT INTO amn_amanab_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","mingnag kimbig nalig Jerusalem wanai, provins Idumeanai, mingnagwo Jordan mingig yinai afa mingnagwo kimbig Tair muhwa nai, afa mingnag Saidon kimbig enagsa el enag amang Sisas fegim eseli enam higini, enag el enag Sisas nangum amgogona. ");
INSERT INTO amn_amanab_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Sisas ehefena nihiyinai elim sihini, “Enagsa el gofwehe enag ka wa kaguwonuf, enag bot numwehiagifum, keso esim yika fugom.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Enagsa elim gihnam enag numwehehianug akafena. Enag mingnag el wahegagena gihna enag ambogonam Sisasna nihiyi, og, ona nawo Sisasim tuhum. ");
INSERT INTO amn_amanab_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Mingnag el Satana nihiyinai amtakwalig nihi mewa gohonfini enaig elim enam wanambogona. Satana nihiyinai enag Sisasim nangunim, enag elni mogukuk kwaogonuginim Sisasim enaig wunini, “Nemba Godna leg.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Enag Sisas Satana nihiyinaim enam tifutuk mo sihini, “Nogofeika sihim kamba aman!” Sisas enaig sihifeni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Sisas mugam fukokanam. Enag eso amangalim esel ogum, “Kawo gisfuhwatim,” elim enam awamoni, og, “Ambogo,” eso el enag ehenangum ");
INSERT INTO amn_amanab_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","12 fena enag elim enam gisfu hwatina ona, “Kawo wan gohonifefum, afa enam enag keso ningitigim kana mom sihigonugehugum. ");
INSERT INTO amn_amanab_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Kawo ehelim enag tifutik faiyim, so ma Satana nihiyinai amtakwaligim enam hugufuhiagonugi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Enaig fenamba enag eso 12 fenam enag elim enag gisfunam hwatina Saimonumwo enag meng wunehlam faina Pitam, ");
INSERT INTO amn_amanab_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Afa Sebedini leningigim sambaga ningigim enag enaig wunehalam faini Boanerges, enag Boanerges wunehalamba enaig eseg ‘hugni luwal’, ");
INSERT INTO amn_amanab_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andru, Filip, Bartolomyu, Matyu, Tomas, ming Jems Alfiusna leg, Tadius, Saimon, Selot elyinai, (Enag Selot el enaig eseahufena mingnag el amang amang amtakwalig eseahufena Selot el enag elim enam tifutuk mo sihigon ahufena.) ");
INSERT INTO amn_amanab_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Judas Iskariot, Judasba el esel enengim Sisasim mingnag elim wa fainif, og, “Ma tigegi enag el.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Eso Sisas lalagam yikana, enag, elksa piske ambogonam nuwagena. Enaig fenamba ena Sisas ehefena nihiyinaim enag wohof ahanana wanehmo. ");
INSERT INTO amn_amanab_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Sisasna niliteg el higinim, eso ambogona ogona, “Nawo Sisasim wanigiahum.” Mingnag el enag enaig osogona. “Sisasba mwetitig el.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mingnag el, Mosesna mom anuanafig, Jerusalem kimbig wanai ambogonam, enaig osogona, “Belsebul, ming wunehalamba Satan, enag Sisasna nihiyi gofwehe, Belsebulmba ehefena nihiyinai amtakwaligna Ainiyag amtag. Belsebul Satan enag Sisasim tifutuk faig, so ma Satana nihiyinai amtakwaligim hugufuhianugei.” Anuana el enag enaig osogona. ");
INSERT INTO amn_amanab_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Sisas elim enam wunoni, “Ka nangum ambogo,” enaig osonim eso enawasim sihini, “Ahnaig asenam eso Satan mba ehefena nihiyinaimba hugufatif? ");
INSERT INTO amn_amanab_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","El mungwa kimbig wanai mba toogonam esi ka osu ka feimba emba mas tifutinam gohwi. ");
INSERT INTO amn_amanab_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","El mungo lalanaimba apeigonam esim ahu osum ahumba fimbi, emba mas tifutinim auguiafi. ");
INSERT INTO amn_amanab_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Enag Satan mba ehefumba tigeimba emba ehena nihiyinai enag olugyi towoguf, emba mas tifutinim auguiafi. Awai! Emba wa yikagnam wa awaief! Enag Satana nihiyinai amtakwalig ka ningitigigba Satana tifutukni ka esehmo. Awai! ");
INSERT INTO amn_amanab_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Afa el mungwamba ahnaig yika sahogum tifutuk elni lalagamba ehena gawigmba wambuhmo. Awai! Enaigba eso fefimba emba so ma tifutuk elim enag weana kikenam wahianam, eso ma mungwali gawig enag ehena lalanaimba wambugei.” Sisas ehefena mom sihiagena elimba ogofunugum ehe Satanimba enamba flafatif. ");
INSERT INTO amn_amanab_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","30","El enag enaig sihiagini. “Sisas mba Satana nihiyinai amtakwalig ehena nihiyi go.” Enaig fenamba, enag Sisas sihini, “Yini newug ehe, ka nem osonug, ahnaig ahnaig amtakwaligim elmbi esimbi, afa mungwal mo ahnaig ahnaig amtakwalig enag elmbi sihiaginim enamba Godum asahnafimbi, elimba embawa God hugufatinif. Afa aman Godna sungwagimba kiagaseafaimba, emba God enag mas hugufatinai, yawo ohunanam afa enengim gamba. Awai! Ehena amtakwalig mba gwesenam gofuf.” Sisas enaig sihifeni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Eso enanam enag Sisasna afagna suminimbugugna ambogonam apekugona. Enag ambagam gofofenamba eso el mungom ningihiyini ogog yika Sisasim wunona. ");
INSERT INTO amn_amanab_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Elksa Sisasna muhwa ogwiefena, enag el enag Sisasim sihini, “Higi, neana afagna suminimbugugna muluwalningagna ambagam gofohmba nem wununug.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Eso Sisas elim enag sahini, “Amangalwo kana afahumoanig suminimbugug mba?” ");
INSERT INTO amn_amanab_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Enag enaig sahininenam eso el esel ehena muhwa ogwiefena enam nangwagihiagenam eso osona, “Ohunag elmbi kana afahumoanig suminimbugug muluwal ningag. ");
INSERT INTO amn_amanab_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Amanga Godna sawiegim pahalug ahuagimba, enag el enag kana suminimbugug, muluwalningag, afahumoanig,” Sisas enag enaig sihifena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Sisas wahegimeg bu muhwa piskenam elim mo ohofunugena. Elksa Sisas nayi ambogonam nuwagena enaig fenamba. Enag Sisas botgam fukukanam agafena bot buwa gofena enanayi. Elksa engigwa bu muhwa auguiafena, ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","enag eso Sisas enagsa mo enawasim enaig sisifunugena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Negel higi! El mungo yikanam asowa wit nog rais lofug aitiagena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Enag aitiagafenamba mingnag witwo mina wa apeigona. Enag twafig ahagana. ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Mingnag betewo hun etinyaksa singaugum afugwafenamba enag betewo wesig sisigam fena enaig betewa mingnag witwo apeigona. Enag betewo nalig fe hwanig, enag wit weg mas numwehe bete megam apeigonam ahunamo. Enaig fenamba enag wit enag yikagna apekugona. ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Enaig fenamba enag osuwu mayi pugunamba enag wit enag ehesafesaina. Ena wit enag bagag hwanig fenamba ena ehesafesainam eso pigina. ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Mingnag betewo we nasna gofofena enag mingnag witwo enag olugyi apeigona. Enag eso we nasna enag apekugonam wit nogum enam kilmoane sungofini enag wit apekugonam wesig fesaina mas fug lenamo. ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mingnag witwo bete lahlagwa apeigona, enag apekugonam numbiasaina, enaig fenamba ena fug lena. Mingnagwo enagsa feg 30, mingnagwo gwesim hilinam enagsa newog feg 60, mingnag gwesim hilinam amtakwal wahegageg feg 100.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Afa enam enag Sisas sihini, “Aman anganamba, ena mom ma numwehe higinam afa olningi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Elksa mayi ahunamba, Sisas mungo gofena. Ehena nihiyinai 12 fenam afa mingnag el Sisasna muhwa gofofena, enag gamba apeigona enag enawasim enam Sisasim sahini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Enag Sisas enaig sihifeni, “God nem ati ogofunug mog mo megam sahogo enam, ena mo mba enaig eseg, amangal Godum pahalug ahuafena, enamba God wa wanagafuf. God ehe afalig fenam, God ehefena wanagagim enam nem ogofunugeg. Aman Godum pahalugua hwanigba eso enamba enawasim mungo wa higif. ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Autinam God profet Aisaiam ogofuna enag Aisaia enaig ginofena, Enag emba wa nangunim, afa mas nangwi afa enag moamba higinim moamba afa mas olnigigba fi enaig fenamba, enag olugbi mas wahigifi, enag ehefena ningalni ahnaig ahnaig amtakwaligim enag God mba mas hugufuiti fani. Aisaia enaig ginofena.” Enag Sisas enaig sihiagena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Sisas enaig sahinena, “Enawasim enag mas nolningigmo. Enamba nolningig hwanigmba emba mingnag enawasim enamba ahnaig olningig na fif. ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","El esel yihugeg elimba Godna mom yihugeg. ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mingnag nogwo minawa apeigog. Enag enaig feg, el mayi Godna mom higigmbi gwenanam ehe Satan bogum ehelni oluyinai Godna mom enag wambuk. ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Mingnag el wo enaig esig. Wit nog betewa apeigog hun singaugumwo afugwahba ena bete wo wesig sisiyigam gi. El enag enaig feg, ena mom enag yikagna higigim, enag sifakalinig, ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","enag Godna momba mas numwehe oluyi saigogmo, mas numwehe kifutuk olninginigmo. Afa enengim mingnag el mayi Godna mom piga wambuk apeigonam ehim enag kinig faiyimbi ehena Godum olningenag enag yikagna gweyi awaief. ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Mingnag elwo enaig eseg. Wit nog we nasnawa olugyi apeigona. Enaig el enag Godna mom higigim. ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Afa ahnaig ahanaigim ohuna betenaim enam membegonug enaig elni olugyi nag Godna mom kilmoanegonugini enag enaigmba el mas fug legmo. ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Mingnag elwo enaig esig, wit nog bete lahlagwa apekugog. Ena Godna mo ehigigim, figim kikeheligmbi enag el enag fug leg. Mingnagwo enagsa feg 30, mingnag wo gwesim numwehe hilinam enagsa newag feg 60, mingnag wo gwesim ilinam amtakwal wahegagna feg 100.” Sisas enaig sihifeni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Sisas enaig shifeni, “Enag aman mungwamba wi fanam somp mewa afa kife mewamba kumoahalaime? Awai! Sime sisiyi fa foholuf. ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Amang amang gawig esel yawamba megam agfo enag enag enengimba amba wa apekugof. Afa mungwal gawig aman atukulegim auguiagba, emba wa ena wi ambawa puguf. ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Amangal anganamba, eso ma numwehe higinim afa olningi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Sisas enaig sihifeni, “Mo esel na higig, enamba numwehenim olningi. Amang enaihwa na fagmba enaigmba mingnag God nem faif, emba mingnag enag enagsa nem faif. ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Aman Godna olningugugum numwehe kikehalagmba emba God enagsa faif. Afa aman Godna olningugugum kikehalag hwanigmba, emba mas kikehalai. Yuwanam wesig esel fana ena gamba awaief.” Sisas enaig sihifena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Sisas ming mom enaig sihifeni, “God wanagagimba enaig eseg, el nog betewa aitiag akak. ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Mungwal sinainim enag gifugum osunam bwihiafugum yika ana nog apekugogum numbigim fuk legim enam enag el enag mas olningigmo, ahnaig asegim ena apekuguk. ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Bete ehehe gafungafegim eso nog apekugog, yuwanawo figeg pugug, gohogum musog pugug, gwesim hiligim fug pugug. ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Enaig esegim fug enag mayi numbigmba, eso el enag enam ati olningig lifug ati ambig, enag eso naifna fa lef lifug pwatigim.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Sisas enaig sahinena, “Ahnaig sefa big fif God wanagagimba? Ahnaig big esinim ogofuf enawasimba? Elimba enaig eseg. ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","El eseli mastet nog fanam betewa fatina, enaig mastet nogmba hwatambof kug lofug. ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Enamba pugunam numbinam mingnagim flafna aitif. Kagagmba naligehe aitiagef, twafig saigonam auguiafuf, gag gamba nimbagif. Mastet nog wasimba enaig ogofufeni. Hwaonamba God enaig wanagafef etinyagsa elim wambubunam, enam enaig lahla wanagafef.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Sisas elim enag ena mo sihini. Enagsa enawasim Sisas enaig sihifena. Ehefena nihiyinai elni pluningugug esel pugug enaihwa enam Sisas ihinugefena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Enaig esenam enawasim mo mungo mungwal elim sihini, afa ehefwaimu ehefena nihiyinaim mungo wangagfenamba, eso mog mo wo sihinifini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Enanam sinainim Sisas sihini ehefena nihiyinaim, “Nawo wahegimeg bugam minggam ehgam ahum.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Enag enagsa elim enam Sisasna ehefena nihiyinaina wasanim ahuna. Sisas enag gwena botwa agafenamba, ehefena nihiyinai enag gwesim ahunam saigona botgam. Ehefena nihiyinai enag botum ogohuna enag. Mingnag bot gamba mungwali ahuaminifena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Yikagnam gweyi fufwei nalig puguna buum gamba pupukuafukona botum heogwafatifefana. Botwa bu figfukonam ona nawo mengigwa pugum. ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Sisaswo botna masigim gifini pilowa ehefena musogumwo fakanam. Enag ehefena nihiyinai enag Sisasim osoni, “Sisifunug el, muhwa gweliehe bigim awaiofe! Mas na kam afafenigmo?” ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Enag Sisas bwihianam, fufweim nunumuafana, afa buum gamba sihinamba. “Huguafona!” Eso fufwei wahana, bu yuhwa gifini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Eso Sisas elim enam sahini. “Amang figim na embefig? Mas na Godna tifutukumbi olningigmo, Godmba yuhwa wafef nem kwaganigim, afa mas na olningugigmo God nem nangwagihiagewogumba enamba.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Sisasna nihiyinai enag amtakwal embefini, enag esinim ehefena olyi sihiagafafena, “Elmbi elimba amanwo? Enag fufwei i bu i mba ehena mom higi pahalukahug!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Sisas ehefena wanagag el ahuna apekugona minggam egam wahegimeg Galili buwa provins Gerasawa. ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Enanam enag yawehe Sisas botum wahiana betegam penamba. Enag el mungo hun megam (elim kumogofofna enagnai) pugunam bona Sisas nangum. Elmbi enamba Satanna nihiyinai amtakwalig ehena nihiyi gofena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Elim hun megam kumogofofna enanayi el enag fawofegofena. Enag ehim enag aman wena gamba ahnaig kikefehmo? Afa senna gamba, ahnaig kikefihmo? ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Gwenaig ehe gwesifinim ningagim mongugum senna kikeagifinim wahiyi finimba enag esefenam kukofenam tatuafena. Afa tifutuk el gimba ehim enag ahnaig kikehelafehmo! Awai! ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Osunam sinainim enag gwesefenam langwakafena hun megam elim kumogofohogwa aikiawa gamba sufgwafefena. Enaig esefena hlehlewofukofenam amtakwale wune fefena. Afa enaig esefena ehefena eligim hunwa gamba hegohwatiafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Enag wahegwa gohonam Sisas nangonam enag enaig esena kikigni bonam Sisasna muhwa penam mogukug kwakwagenam Sisasna nohmbosugum hlehlewofukonamba ehena wuneg enag numbiagena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Sisas Satanna nihiyinai amtakwaligim enam sihina, “Elim enam wahianam pugumbo!” Sisas enag enaig sihifena. Enag Satanna nihiyinai amtakwalig enag Sisasim sihina, “Sisas, Godna leg, enag Godmba sisiyia newog feg. Amang na kam fenagim?” God bigim nangwagawo enag ka nem tifutigim sahanig, na kam mungwal amtakwal sungofef!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Enag Sisas sahana. “Neana wunehalamba amanwo?” Satanna nihiyinai amtakwalig enag piskenam Sisasim sihina, “Kamba enagsa, enag kana wunehalamba Ami” ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Enag enaig Sisasim sahini fini, “Na kam ohuna betenaimba ningitigif!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Tata ksa aikieg wesig muhwa ahagag gegfofena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Satanna nihiyinai amtakwalig enag tifutinim Sisasim sahini, “Kam tatana nihigim ningitigi, kawo so ahunam saigona.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Enag Sisas sawiyifeni mahni. Satanna nihiyinai amtakwalig enag elim enam wahiyinim tatana nihigim ahunam saigona. Ena tata enag kikigni apeigonam aikieg pwapok amtakwaligam apeigonam ahuna. Mungwal tatamba enamba enaig esena wahegageg 2,000. Enag wahegimeg buwa apeigonam pigina. ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Tatam nangwagofohog el enag embem ahuna sihiagonugehuna kimbig wanai elim. Afa mingnag el aso lalanaim gamba, mungwal el enag kimbig wanai, asonai, ambogonam enag nanguni amang eseli ese pugug enam enag. ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Sisas nayi ahunam apekugonam eso elim enam nanguni autinam enag eseli Satanna nihiyinai amtakwalig ehena nihiyi gofofena enam. Enag el enag yawamba ati lofug aitiagenam agafena olningugug yuhwa fenam eso agafena. Elim enam nangunim eso embefini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Enag el enag enam nangunim eso ahuna sihiagahufena amang eseli elni nihiyi pugug afa tatana nihiyi pugunug enam. ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","El enag tifutinim Sisasim sihini enag elni kimbigim wahianim asika. ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Enanam enag Sisas mayi yikanam botwa asahofenamba, eso el eseli Sisas Satanna nihiyinai amtakwaligim hugufatina enag Sisasim sahana, “Kam wanigiahu!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Enag eso Sisas piskenam enaig sihina, “Nimbefena kimbigam piske yikanam, eso sihinugei amang eseli nem Ainiyag esenag enam enag, mungwal amang eseli God nem afafenagim nem kwegofog enam.” Elim enam Sisas enaig sihifen. ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","El enag eso yikanam ena mo sihiagena Dekapolis muhwa kimbig enag ningagagim pugufeogona 10 ena provinswa. Enag mungwal 10 kimbig enag mungwa wuhegalamba Dekapolis. Enanayi sihinugena amang eseli Sisas ehim esenagena enam. Mungwal el enag eso higinim olug wahegasaina. ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Sisas botwa piskenam yikana minggam wahigeg bugam enag elksa mungwal enag ambogonam Sisasnayi nuwagena wahigeg bu muhwa. ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","El mungo wunehalamba Jairus Sisasim nangumbonam. El enag nuwagig lalam Ainiyag fenam. Bonam enag Sisasim nangonam Sisasna mongug muhwa penam mogukug kwakwagena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Sisasim tifutinam sahana, “Kana luwal nainim muhwa wahagim ofe. Mayi na bonam tuhuimba eso ma wanganefenam; wangneg gohwi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Enag Sisas ahkana. Elksa pahalug ahunam kigfagena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Angwafig mungo gofena lalawa fawo feakanam mingugiyi gohona yiamba enaig 12 fena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Dokta ksa ona nawo numwehenagifum enag ase ase fefininim wahiyini mas wesigngiwo wangenefenamo. Gwesim gweyi numbiakafena mungwal mani enag augiagena tatuna. ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Enag angwafig enag Sisasna mom higinam, enag boknam el numb eseli ahuafena enanayi puguna. ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Enaig olningugena, “Ka Sisasna lofugum tuhuimba, emba sa kam wangenefei.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Enag esena Sisasna masigim bonam Sisasna lofugu tuhuna. Enaig mayi esenamba enag yikagna lalawfawog enag awaiena enag ati olningenamba eso lalawafawog enag gweyi awaiena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Angwafig enag enaig esenamba, enag Sisas ati anuwanafena mayi tifutuk enag ehena nihiyinai penakanamba. Enag eso wahigifenam elksam enam nangwagenam, eso sahini, “Aman kana lofugumba tuhuk?” ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ehefena nihiyinai enag enaig osoni, “Ati na nangog, el wahegageg neana nihiyi muhwa. Amang fegim na sahig aman eseli nem tuhuk enamba?” ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Enag Sisas mahiyim fahegenugegofena ona nawo wufuam aman eseg enam. ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Enag angwafig enag ati olningena amang eseli pugug enam enag. Enag embefenam kiafigigi gayifena, enag bonam penam Sisasna mongug muhwa mogukug kwakwagena, eso amang eseli ehim puguna enam enag sihiagenam augena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Enaig mayi esenamba eso Sisas sihina, “Kana muluwal ati na kam olningenag. Kamba kifutuk feg nem kwaganyegim enag ati nem yuhwa feg. Yikanam afwahalana wangeneg agafum. Neana gihmba gweliehe mungwal awaieg.” Sisas enaig sihifena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Sisas mahiyim mo sihiage gofenamba mingnag el Jairusna lalanai ambogom. Enaig osogona, “Neana luwal nainimba ati wahag. Amang fegim na mungwelnimba anuana olmbi esefuku wanimbugumba?” El enag Jairusim enaig osoni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Sisas mas enam higinimo, enag Sisas Jairusim sihina, “Nofeka embefem, emba ka nem kwegofuf, numwehenam olningugifum.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Enag Sisas mungwal elim enam kweni, “Nogofei na kam pahalug ambogom.” Esonim, eso ehefena nihiyinaim mungo, Pita, Jems, Jemsni sumineg Jon enam sambaga mungom mungo wankana. ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Enag ahunam apekugona Jairusni lalawa Sisas nangwagenamba angogon ksa wahegagenam ehefum amtakwal ehuwehegehu fenamba wewatuawofena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Sisas sahokanam sahini, “Amang figim na enaig angweniasaga, amang figim na wewatuawo? Ena luwalmba enamba mas wahagmo, elimba nonhi gi.” Sisas enaig sihifeni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","El enag hekembegegwa titigegoni. Enag Sisas ambagam ningitiginam eso luwalna awag, afagim afa ehefena nihiyinai sambaga mungom enam mungo pasna saho wan kana ena kugam luwal eseli gifini esim. ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Eso Sisas luwalim enag ningawa kikehalanam Hibruni moana sihina. “Tabita kumi!” Ena momba enaig feg, “Luwal naini, ka nem osonag, bwihia!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Enag yikagna luwal naini enag bwihianam yikana. Ehefena yiamba 12 fena enaig. Enag el enag enam nangunim enag amtakwal olug wahegasaina. ");
INSERT INTO amn_amanab_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Afa Sisas tifutuk mo sihini, “Nofeka ena mo sihim, negel nofeka amanim mungo sihinim ena mom enam.” Sisas osoni, “Wohof luwal nainim enam fai.” Sisas enaig sihifeni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Sisas ena kimbigim wahianam piskenam ehefena kimbigam yikana. Enag ehefena nihiyinai enag pahalug ahuna. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sabat osunam enag yikana nuwagig lalagam. Godna mom elim sihinigim. Enagsa el ehena mom higini, enag olug wahegeasainam enag enaig osogona. “Elmbi elimba ahanagna mo fak? Enaig nalig olningugug elimba ahnaig olningugug? Enag enaig esegim, nalig ahnaig ahnaig gafungafag. Mas big autinamba enaigmba nangunimo. Ahanagna tifutuk enaigmba pugunug? ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Elmbi elimba lala nimbaogog el sini? Mariana leg? Jems Josep Judas Saimon enag elni eteg sini ehe? Ehena muluwalningag gamba ohwi big mungwal auguia?” Enag ehel enag esinim, Sisasim mas fatini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Enag Sisas sihini, “Aman profet eseli, mungwal el mingnag kimbig wanai enag emba profetna mo wa higif. Afa ehefena kimbig wanai afa ehefena nilite afa lalanai ehefena mungo wo mas fatinif.” Sisas enaig sihifeni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Enaig fenamba enag amang tifutuk gafungag enag ena kimbig wa mba mas esei. Enag esenam mungo mungog elim ehe tutohilinam lahlafehiagena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Enag Sisas olningugena. “Ahnaig asegmba enag, mas numwehegim kam yinim olninginigmo, enag kam ogogum, ahnaig asegim Sisas kam kwaganihmo?” Sisas enaig olningugini. Eso Sisas yikanam langwakafena mungwal kimbig eseli enanayi Godna mom sihinugakafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Enag ehefena nihiyinaim 12 fenam enam wunonim, enag enaig esena ningitigi fena sambagahka sambagahka fini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Enag tifutuk faini. Satanna nihiyinaim amtakwaligim ningitigifigim enam. Enaig osoni, “Nogofeka gawig wambukahum, afa mungo wambuk ahwi, nogofeka bret wambwi afa mani wolagim afa mani ga, enag nogofeka wambukahum. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Su mungo aitiaogwi. Nogofeka ninegna siot sambaga wambtim, mungo mungog wambwi. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nahunam kimbigwa mba apekugonam mayi nem amanba ehefena lala gamba wankaimba eso gweyi mungo wa ahunam auguiafi. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nahunam kimbigwa apekugonam el enag nem awamogonug hwanigba, negelni mom higigonug hwanigmba, emba so ena kimbigim enam hwahiyinim, eso enaig esi mongyinai hunigesige wambihiaginim, enagna elim enam ogofugoni el enag amtakwalig esig.” Sisas enaig osoni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Enag ehefena nihiyinai enag ahunam enaig mo sihigonini. “Negel olug wahigifi, ahnaig ahnaig amtakwalig enag hwati.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Enag enagsa Satanna nihiyinai amtakwaligim enam hugufuiti fegoni, afa mingnag gihna elim wel buk eligim sugufugonuginim numwehegonugini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ena mo Sisas, ehefena nihiyinai i esel enaig esini, ena mo enag mungwal kimbig ena kagna, enag eso Herot gamba enam higna. Mingnag elwo enaig osogona, “Jon bu wa aitiag el wahagim piske bwihiag. Enag eso ena tifutukni amang amang gafungag nalig enag esofe mungwal fena.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Mingnag elwo enaig osogona, “Elaija emba.” (Elaija mba profet autinai), afa mingenag elwo enaig osogona, “Sisas mba ming profet, autinai profet lofug.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herot gamba enam hignam, enag eso enaig osona, “Jon bu wa aitiag me? Enag ka enam embefeg. Autinam Jonna wuningligim ka hegefatina. Ena me piske bwihiana?” Herot enaig olningugena, enag Herot enag embefena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Autinam King Herot ehefena suminig Filipni angwafigim fana Filipna nihiyinai. Enag angwafig wunehalamba Herodias. Enag Jon bu wa aitiag el enag Herotum sihinagofena gwesenam, “Mas lahlafegmo nimbeafena suminigna angwagim na fak.” Jon enag Herotum enaig sihifenagofena. Enaig fenamba enag Herodias olug kakagna. Herodias enaig fenamba, enag Herot ehefena soldiam ningitigina Jonum ahu sulufim bogogum kalabusigim ningagag mongugum senna kikenagini wahiyim. Herodias onanawo, “Jonum tigeakam!” Afa Herot enag mas wahianamo. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Herot ati olningena Jon mba lahlag, Godna el. Enaig fenamba, Herot Jonum embefena. Herot Jonum enaig esenam kakagwo fefukufna. Herot onanawo Jonna mom higifum afa enag minggamwo olkinig wahegagena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Herodiasna olug kakagig nalig enag gwesenam gofena, enag ati yisiginam wufuana Jonum tigegigim Jonum eseli enam enag. Enam ati gishu fwahiyini Herotum afag fukuana enag osuwum, enag osunam wohof enag wan ahagagnam enanam. Mungwal gavman, ami, Ainiyag, Galili nai, enag el enag ambogona wohof ahagagim enam. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mayi enag el enag ahagafenamba, Herodiasna leg naini enag enanam bonam ilakafena. Enag eso mungwal Ainiyag el eseli enag lahlafini. Enag King Herot luwal nainim enam sahana, “Amangim na membegmba, ka so nem faim. Emba ka newa faif amangim na sahif. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Yinimehe kosok, na sahiimba kana mungwal gawig eseli, enag ka nem olugi towogonam faif.” Herot luwal nainim enam enaig osona. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Enaig fenamba enag luwal enag yikanam afagim sahana, “Amangim ka osonaf, kam fai.” Afag enag osona, “Jon bu wa aitiag elni mesog kam fai, enaig esonai.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Luwal enag yikagna piskenam Herot nangum yikanam, enaig tifutinam osona, “Jon bu wa aitiag elni mesog pletwa fatinam ka fai.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Luwal naini enag mayi enaig osonamba, eso King Herot enag afaf nalig newug fenam enag ahnaig asoahmo? Yuwanam luwalim enag ati sihina, el eseli auguiafena enag elni nofwa enag ati higini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Enaig fenamba enag Herot soldia mungom ningihiana, yikanam kalabus lalagam sagoham Jonna mesog hegefanam pletwa fatinam ombuna. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Enaig esenam, luwal nainim fainamba, eso luwal naini enag afagim okunam faina. Herodias enag Jonum yusug tigeakana. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Jonna nihiyinai enam higinim enag ambogonam Jonna eligim finim ogohunam kumoahalini. Enaig fenamba enag Herot Sisasna mom higinam, enaig olningena, “Jon bu aitiag el piske bwihiag,” enaig fenamba enag Herot embefena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Sisasna nihiyinai piskenim ambogona. Yuwanam Sisas eseli ningitigina ehefena mo finim elim sihigonug ahufena. Enag piskenim ambogonam Sisasna nihiyi nuwagena sihiagini amang eseli esini, afa mo ieseli faigona enam. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Enagsa el ambogofenam fagufegofofna, enag Sisas ehefena nihiyinaimi ahanana wohof wa neanemo? Enaig fenamba enag Sisas enaig osoni. “Big mungo nawo ahum el hwanig betegam, eso negel enag ahunam ehe fi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Enag bot finim minggam el hwanigam ahuna. Sisas enag ehefena nihiyinaim mungo wankana. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Enaig esini, mungwal nangwaginimba Sisas ehefena nihiyinaim mungo wankafena, ati olningini. Enag mungwal el enag mungwal kimbig wanai enag betemina kikigni ahunam apekugona Sisaswo mahiyim wanfeafenamba afa ehelwo atiahunam gofofna. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Sisas bot wanai penam engigwa pafenam nangwagnamba elksa wahegagenam agafena, enag eso Sisas ol mewa afafeni. Sisas olningena el enag sipsip lofug, tata luwalig lofug el nangwagofohof hwanig, enag Sisas enag elim ol mewa afafeni, enag Sisas gweyi enagsa mo sihinugena enag elim. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Osuwu yika pefenamba, Sisasna nihiyinai enag ambogonam Sisasim osoni, “Osuwu yikagim opemba ohunanayimba el hwanig. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Elim enam ningitigi mahunam wohof manina wambugi mungwal kimbig muhwa eseli enanayi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Sisas piskenam sihini, “Negelehe wohofmba faigo.” Sisasna nihiyinai enag Sisasim sihini, “Na sawiyi fegho kawo ahunam nalig manina 200 kina enana wohof wambugonum elim enam? Ahanagna wohofum big wambugonuhmo el numbum enam? Awai!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Sisas sahini, “Negelni bretmba ahanansi? Ahunam nangu.” Ahunam fahegenim enag osogona, “Kagelnimba afa pugufeg enansi bret, afa sawugwo sambaga.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","40","Sisas ehefena nihiyinaiim sihini, “Sihigon eso ma auguiagai ahiyiogu ahiyiogu ma fahwi pos wankenegwa eyi.” Sisas enaig osoni eso mingnagwo numwehenam enagsa 100 auguiafena, afa mingnagwo hofawum 50 numwhehfenam auguiafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Eso Sisas afapugufeg 5 bret enag wambna, afa sawug sambaga enag wambtina esenam, eso ofgam nunofenam Godum lahlag moaogona. Bret kukosungofenam ehefena nihiyinaim faini enag ehel enag elim enam mumankegoni. Sawug sambagam gamba eso gwenaig esenam eso mumankegoni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","El enag ahaganam yuhwa gohna. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ehefena nihiyinai enag piskenim wohof ogug enag wambuginim 12 fenam enansi sompyi aitiafolini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Enag el eseli wohof ahagana enamba 5,000 el. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Sisas ohefena nihiyinaim yikagna ningitigina botwa fukwalagonam gof ati wahegimeg bugam egam ahuafum, Betsaidagam. Sisas ehefwo ona nawo elksam enam ningitigi aminifenam. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Enag elim ningitigi-aminifenam wahianam eso ehefumwo aikiagam fukokana Godum sihinagim. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Enanam omuginim botwo wahegimeg buwa olugi gofena mba, afa Sisaswo ehefwaimu mungo engigwa gofena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","El botwanai enag onanawo ahuafum afa fufwei nalig bofnam botum kifitifnam kikehlaguafna enag Sisas engig wanai ehefena nihiyinaim enam nangwagnamba nambigni wafihiagi ahufena. Enag leawa kwimbiyim Sisas bu sisiyi langwabonam puguna. Si mahiyim gofenamba muhwa ambafekagim. Enag Sisas bu sisiyi yikana wahegimeg buwa eyi ehefena nihiyinai el nangum ona kawo kanam kwahanigam. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Ehefena nihiyinai enag nanaunimba bu sisiyi langwambofena. Enag enaig olningini ogogum, “Yifaf emba!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Enag mungwal Sisasim enam nangunim enag amtakwal euwatogonam embefagini. Enag eso Sisas yikagna sihini, “Olug tifuti! Kamblehe ombo. Nogofeka embefim.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Enag botgam yikanam fukonam wanagafenamba eso fufwei enag gweyi awaiena. Enag ehefena nihiyinai enag olug wahegasaina. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Mas numwehenim olninginimo yuwanam Sisas eseli bret kukosungofenam faini. Godna tifutukum ogofuni. Sisas ona so ma olningi ehmba Godna nihiyinai bok. Afa enag Sisasna nihiyinai enag mas olninginimo. Bu sisiyi eseli Sisas yikafena. Enam gamba ehefena nihiyinai enag mas ehim olninginimo, Sisasmba Godna nihiyinai bok. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Enag ahunam wahegimeg buum tigeugunim ahunam minggam egam apekugona, Genesaret kimbigam. Enag botum enanayi kiki wahiyinim. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Afa botum enag wahiyinim apeigomba. El enagna enag ati olningini elimba Sisas emba. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Enaig fenamba enag el mungwal kimbig muhwanai enag yikagna ahuaminifena. Enag eso mungwal enag higifinim Sisas mayi ahananayi gofenamba, so elim gihnam enag wambufinim esim wambuk ahuafena. Enag higifinim Sisas mayi ahananayi gofenamba, enag eso elim enag kug noholugum wambufinim Sisas nangum wambuk ahuafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Mungwali kimbig wesig i naligyinai gamba, Sisas mayi yikafenamba mungwal el eseli enag elim gihnam wambufinim Sisas nangum. Wambug ahuafena ogohufenam ena kimbigwa Sisas eseli aga enanayi olugyi sungo gofena, enag tifutifinim Sisasim sahinifini, ogona Sisas ma sawiyifei, eso ma gihna el enag Sisasna lofugum tuhufi. Enag el enag mayi aman Sisasna lofugum tuhufenamba gih enag wangenefefena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Mingnag Farisi el afa mingnag Mosesna mom anuana fig el Jerusalem wanai enag ambogonam Sisas nayi nuwagena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Enag ehel enag nangwaginimba Sisasna nihiyinai mas ningagagim buwa sugifinimo, yusug ahagafena. Farisi el enag enaig esehufena, ufuana mom pahalug ahuafena, enag amangal enam pahalug ahuag hwanigmba, enag osogonfini, “Negelmbi Godna nofwa amtakwalig fesaig.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farisi afa mungwa mingnag Juda el enag ufuana mom pahalug ahuafena. Ningagagim ufuana moaihwa buwa gigiafewogug hwanigmba emba wohof enag mas ahagai. ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Maket wanai ambogogum, buwa susug hwanigmba, emba mas ahagai. Amang amang autinam ufu esehufena enam enag gwesifinim pahagahuafena, enaig mungwal ahnaig ahnaig enag. Kap, plet, sospen, nonigi kuk, enaig gamba gigiafegifini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Enaig fenamba enag Farisi anuana el enag Sisasim sahini, “Ahnaig asegmba enag neana nihiyinaimba mas enamba pahalug ahuahmo mas ufuana moaihwa ningagagim buwa sugihmo, yusug ahagahu?” Sisasim enaig sahnafini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Enag Sisas sihini, “Autinam profet Aisaia, enag profet el enag Godna mo higinim eso elim sihini enag Godna mom ginofenam yinim osona negelmbi moakwal luwal. Aisaia enaig ginofena; Enag enangelmbi kana wunehalam mengigna bihig gufiyigim ofukwalagof afa enag elni olugmbi kana wahegwa go. ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","El enag elni mom mungo sihifinim osogwahufuf, ‘Ohuna momba Godna mo.’ Enaig wa osogwahufuf. Enaig fenamba enag kana wunehalam mungwelni mengigna bihig gufiyinim ofukwalagof. Aisaia enaig ginofena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Negelmbi ati Godna moamba wahiyig. Yawomba elni mom mungo na gwesigim kikegeligofo.” Sisas enaig sihifeni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Sisas ming mo sihini, “Negelmbi anuana Godna mo flaguflag el, nimbefna ufuana mo mungo na pahlug ahua. ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moses enaig osoni, ‘Nemba awagafagna olningugug fanam eso pahlugwi afa aman awagafagim amtakwalig mo waginigmbi enamba eso tigegi!’ Moses enaig osoni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Enag negel enaig osogoafena, aman maninamba eso awagafagim kwagani, enag awagafagim enaig osoni ‘Ena manimba afi ka fakanag Godum faigim mas ka nem faiyi.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Afa enaig sihimba fenam, afa awagafagim kwaganig hwanigmba, emba enaig olningugef, elimba yuhwahofeg, kawo awagafagim kwaganigimwo wahiam. Negel enaig olningugifini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Enaig fenamba enana ufuana mo eseli na fini enam ena na pahalug ahua. Negelmbi mingnag elim amtakwalig pahlug ahuagim ogfugon. Enag elimba na sihigoni Godna moamba amtakwalig yusug feg! Enam enag nimbehe sihigonufini, afa mingnag amang amang amtakwaligim enaig enag enam gamba nesifini.” Sisas enaig sihifeni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Sisas elim piskenam wunonim, enag sihini, “Negel mungwal enag kana mom higinim, eso olningugi. ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Amang eseli elni nihiyi ambagam goh, enamba sahokagim, emba mas elim enam amtakwalei. Awai! Amang eseli meaga goh, enag elmbi gwena mungwehe pugugum amtakwal fafefaf. ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","(Enag amangal angnamba eso mo enag ma higuginim numwehe olningugi.)” ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Enag elim enam wasanam, lalagam yikana. Ehefena nihiyinai enag sahini, “Enawasimba mog momba enam elimba ahnaig wo?” ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Enag Sisas sihini, “Negel gimba olningig hwanig ho? Mas na olningigmo. Mungwal wohof eseli ambagam go, ena yikagim sahwagmba mas elmbi amtakwalefai. Emba nihiyi yika sahonam, afa elim enag mas amtakwalefai. ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ahnaig asegmba? Enaig wohof mba mas yikanam olugimba sahoi? Awai! Elimba ehnog megam mungo pekagim, eso wambuk ahugum ata lalagam tatugog.” Sisas enaig sihifeni. Enag ena momba Sisas ogofuni mungwal wohof eseli enag elimba lahlag, mas kwegigmo. ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Sisas enaig osoni, “Amang eseli meaga go, enagehe pugugum elmbi amtakwalfafefaf. ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ahnaig ahnaig amtakwaleg eseli elni olyi go, enagehe pugugum fambof amtakwalig olningugug enaig, agataikug, okwef, elim tigekag, ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","angwafig hugwiapahugug mingnag elni gawigim membenig ona, ‘Ka wambum,’ ahnaig ahnaig amtakwalig enaig moakwaleg, amtakwalig gwenaigim mungo gweseahu, mas ahwanifi, olug amtakwalig, elim mo kiapasig, kigambalig enag mwetetig el enaig mba. ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Mungwal amtakwalig olningugugmba enaig elni nihiyi go, enagehe pugumbogum elimbi amtakwal fafefaf.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Sisas bwihiana ena kimbigim wahianam Tair provinsigam yikana, yikanam lalagam sahokana onam, “Ma sa kam anuwanafinif ogofei ati bok ohwi aga!” Afa enag el enag ati higini Sisasmba ati bok. Enag ena mom enag ahnaig kumoahalafehmo? Awai! ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Angwafig mungo enag enam higina Sisasmba ati bok aga. Enag angwafigni luwal nainim ena Satanna nihiyinai amtakwalig ehena nihiyi gofena. Enag angwafig enag enaig fenamba yikagnam bonam penam mogukug kwakwagena Sisasna mongug muhwa. ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Angwafigmbi enamba Juda angomba awai, elimba mingnag elyinai, Finisia Provins Siria kantri yinai. Enag angwafig enag Sisasim tifutinam sahana, “Kana luwal nainim Satanna nihiyinai amtakwaligim hugufatina.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Enag Sisas ati olningna Israel elmbi mingnag elim ati enaig suwigifini mawang lofug. Enag Sisas angwafigim enam sihina, “Yuwanawo nawo wohofmba luwalim faigom. Amtakwaleg big luwalna wohof wambugum mawankim tatugonugmbi.” Sisas enaig sihina. ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Enag eso angwafig enag piskenam Sisasim sihina, “Ainiyag, yinimehe nembe osog. Enag mawank sime singagim auguiahba, mayi luwalna wohofmba apeigogmba, enag mawang wambhaga fafif.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Enag Sisas piskenam angwafigim sihina, “Neana moamba lahlag olningugug, piskenam lalagam yika, Satanna nihiyinai amtakwalig mba neana luwalim ati wahiakag.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Enag angwafig enag piskenam lalagam yikana nangonamba luwal enag kukwa gifini enag Satanna nihiyinai amtakwalig enag ati wahiakana. ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Sisas bwihianam piskenam Tairim wahianam yikana Saidonwa olugyi puguna. Gwesim hilikanam olugyi puguna ningagagim pugufewogug 10 kimbig enag enaig sefafig Dekapolis yikanam puguna wahegimeg buwa Galiliyi. ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Eyi el mungom ombugona angug nihiliagim kakamo nisiakafena enam ombugona Sisasim tifutinim sahini ona, “Tuhu elim enam!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Sisas elim enam sulufanam wanikina elksamwo gweyi wasanam ehefum mungo ahkanam ahgofenamba. Eso Sisas elim enag angamegam ningagana tuhunam, eso memb kusenam, afa enag elni melegim tuhuna. ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Sisas enag esenam eso ofgam nunofehiagena tifutinam ehefefona, eso elim enag Sisas sihina, “Efata!” Ena momba enaig eseg, “Nembe pigina!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Yikagnam angug higna, amang eseli melegim kaguona, enag awaienamba mo yuhwa wagna. ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Enag Sisas tifutinam osoni, “Nogofeika amanim mungom sihinim ohunam enag!” Enaig esenam eso osoni, “Nogofeika sihigonugum!” Enag el enag ahunam gwesim tifutinim sihiagehufena ena mom enag. ");
INSERT INTO amn_amanab_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Enag eso mungwal el enag ena mom higinim eso olug wahegasaina. El enag enaig sihiagini, “Amang amang eseli eseageg enag ena yuhwa newugehe feg? Angug nihiliag mo hegig! Mengig kapenifegmo wagig.” Enaig sihiagahufena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Enanam enag elksa piskenam nuwagena enag el enag wohof hwanig. Enag Sisas ehefena nihiyinaim wunoni, “Ambogo,” enag osoni, ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“El enag sambaga mungo osunam big mungwal ohunanayi wanagagim auguiagim enag wohof awaienig. Enaig fenamba ena ka afafenig. ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Biniwa auguiagim enaig ka ehefena kimbigam ningitigiagmba emba nof pagiasainam minawa apeigof. Mingnagwo kimbig waheg wanai ambogog.” Sisas enaig osoni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ehefena nihiyinai piskenim osoni, “Ohuna bete mba el hwanig, ahanagna big bret mba finim, eso big faigof enagsa elmbi enamba?” ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Sisas piskenam sahini, “Negelni bretmba ahanansi?” Enag osogona, “Elngegwa gohog.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Enag Sisas mungwal elim enam sihini, “Betewa apeigonam oguwo.” Enag elengegwo gohog bret wampnam, Godum lahlag moaogonam bret enag kukosungofenam, eso ehefena nihiyinaim enam fainim, ogum, “Elksam enam mimangegon.” Ehefena nihiyinai enag enaig esini, bret enag wampinim mimangegonugini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Afa sawugwo wesig sambagag ahfena. Sisas Godum enag lahlag moaogonam, eso ehefena nihiyinaim enam sihini, “Ena gamba mumankegom.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Enag eso el enag ahganam yuhwafesaina, elksa eseli ahgana enag enaihwa fena 4,000. Ehefena nihiyinai enag wohof ogug nuwaguginim elengegwa gohona enansi sompyi folini. Sisas mungwal elim enag ningitiginam, ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","eso ehewo yikagna yikanam botwa wan fukonam, ehefena nihiyinaim mungwal, eso wankana provins Dalmanutagamwo. ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farisi el enag enaig ambogonam Sisasim flaflafena gofofena. Enaig ogona, nawo Sisasim gihinim, Sisasim sahini, ona, Ma tifutuk gafungag ena fei, enag enamba el bihigmba ahnaig esihmo? Afa ogona nawo nangum God Sisasim lahlafenagime, awaime. ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Sisas olug kinig fenam enag tifutinam ehefefonam, enaig sahinena, “Amang figim elmbi ohunanamba ogona, nawo tifutuk gafungagim ba nangum? Yinimehe ka nem osonug. Mas ka tifutuk gafungagmba ohunanamba ka fei. Awai newug!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Enag elim enam wasanam piskenam yikana botwa ming ehmbegam wahegimeg bugam. ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ehefena nihiyinai enag ol etetini mas bret wambukambogonamo bretmba mungo botwamba gifini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Sisas ati olningena Farisi Herotna amtakwalig olningugugum enam. Amang eseli bret pupkuok enaig lofug fig. Afa amanim enag elni amtakwalig olningugug ena tuhuimba enag gwenaig, tata nihig gamba enaig eseg, amta wesig gwenagehe nongigim, eso mungwal nongig awaieg. Elni olug enag enaig feg. ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ehefena nihiyinai enag Sisasna ehefum mo mas olningigmo, enag ehefum sihiag ahufena, “Big elmbi bret hwanig ename Sisasba osog.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Sisas ati olningena ehelni mom enag, enag osonim sahini, “Amang figim nosogog, ‘Kagelmbi bret hwanig?’ Mas na olningugigmo? Negelni olnigugug mba mas yuhwafegmo? ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nofna na figim mas nangogmo. Afa angna, na figim mas na higigmo? Mas na nolningigmo bret wasim eso ka sihinig enamba. ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Autinam bret afawa gohona ena elksam 5,000 ka faini, enag osohwi ati ahaganam yuhwa fesaina. Afa ahanansi sompni bret ogugmba fena?” Ehefena nihiyinai wahigifinim osoni, “12 fenam, enansi sompni.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Sisas piske sahini, “Enag elengegwa gohona enansi bret ka faini enagsa elim 4,000 enamba. Ahanansi sompni bret ogugmba fena?” Ehefena nihiyinai wahigifinim osoni, “7 ena elengegwa gohona.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Enag Sisas enaig sahinena, “Enam enag mas na olningugigmo? Autinam bret ka faigona, afa enag yawangamba wohof ena ka yuhwafef.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Sisas wankanam wanpuguna Betsaidawa mingnag el el mungom nofselenam Sisas nangum wanibogona. El enag Sisasim tifutinim sihini, “Elim ohunam ningagana tuhu!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Enag eso Sisas enaig esena, el nofselenam enam ningagana kikehalanam, kimbig wanai opugunam wahikinam eso memb nofwa fugenam, afa ningagagna tuhuna, esenam eso Sisas elim enag sahana, “Atiaho na amang amangimba enamba nangwagig? Awaime?” ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","El enag fahegagenam enaig osona, “Mingnag elim enag ati ka nangwagegmba li lofug enaig aisagafesaig.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Sisas piskenam ningagana nofwa tuhunamba afa eso el enag numwehena nangogihiagena. Nofug enag yuhwafenam mungwal amang amangim nohmbesena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Sisas elim enam ehefena lalagam piske ningihianam, eso enaig osona, “Nofeka yuwanam ohuna kimbigam piske yikanam sahom!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Sisas ehefena nihiyinaim wambwiahianam wankanam minawa wanpuguafenamba Sisaria Filipai muhwa. Eso Sisas ehefena nihiyinaim sahini, “Elmbi kamba amanaimwo sefig?” ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Enag Sisasim osoni, “Mingnag elwo enaig sefa nem fig, Jon Bu Aitiag El. Afa mingnag elwo enai sefa nem fig, Profet autinai, Elaija, afa mingnag elwo enai sefa nem fig, Mingnag profet el.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Enag Sisas ehefena nihiyinaim sahini, “Afa Negelmbi ahnaig sefa nakamfig?” Enag Pita wahigifenam sihina, “Nemba Krais. Enag Israel el enag Kraisim nisanahufena. Nembehe ati pugugum enaig gafungag enag na ofe.” Pita enaig sihifena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Enag ehefena nihiyinaim tifutinam osoni, “Nogofeka amanim sihinim kamba Krais.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Sisas enag enaig esenam eso ehefena nihiyinaim enag sisifunugena, “Kamba Enag El God Ningihiana Of Wanai. Emba kamba tawetik nalig wafaf. Enag el Ainiyag, mungwal pris eseli Godna lalanai afa anuana el Godna mo fig enag, enag emba wa el enag kam mas fatinim afa kam tigegif. Sambaga mungo osuwo mayi kaimba eso ka wa piskenam bwihiaf.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Sisas ena mom enag numwehe sihinugena. Enag Pita Sisasim wanikinam nunumuafana. ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Sisas wahigifenam ehefena nihiyinaim enag nangwagihiagenam, Pitam nunumuafana, “Satan, kana masigim yika. Godna olningugugumba mas na olningugigmo. Awai! Nemba elni olningugugum mungo olningig!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Enag Sisas mungwal elksam enam wunoni, mungwal ehefena nihiyinai gamba nohologum, enag osoni, “Aman olningenam kam pahlug ombofimba, emba so ma ehefena olningugugum wahianam, yuwanamwo kam olningenag ena mayi feimba kam membeneg ma sisiyigam fukonam, so ma afa kaga tigeg enag fai kamble osohwi fag enaig, mafanam so ma kam pahlumboi. Enag aga kaga tigegmba enaig eseg amang amang kinig elim enam pugunaf. Mingnagmba kinig fafef, mingnagwo fa pigif. Afa aman kam pahlug ombofimba eso ma ohunaig olningugei, ‘Ahnaig kinig ka nangumboimba, emba mas ka Sisasim wahiai!’ Enaig eso ma esoi. ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Afa aman mingnagwo enaig olningugeimba, ehefum ogum, ‘Ka kwisig Sisasim pahluguagim amang amang kinig ehefena aga kaga tigegna ka kwisig,’ aman enaig olningugeimba emba enena lofug enag wahaf eso ehefena sungwagwo tawetik nalig faf. Godna nihiyi wahegwa gwesena hegegwa agafuf. Mingnag elwo amangal enaig olningugeigmba, kam olninginim, kana mo lahlagim sihinim, kana gafungag esel esig enam enag wahagmba. ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Aman ohuna betenai gawig enag mungwal wambugegmba, enag ena gawigmba kwegofoime? Awai! Ohuna betenai gawigmba mas kwegofoi, elimba yusugmba! ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Aman amang faif ehim ehena sungwagim sulufagimba hegeg gweseg agagimba? Awai! Amang amang gawignamba mas sulufi. ");
INSERT INTO amn_amanab_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ohunanam enag enagsa el auguiahmba Godum hwoyuafatifefig, enaig esigim, kwamblo i angwafig i ahnaig ahnaig amtakwaligim mungo pahlug ahua. Afa aman mungo enag amtakwalig elni olugyi gohogum enag kam enag ahwanifenagmba, afa kana mom gamba ahwanifehagmba, emba hwaonam mayi Enag Elim God Ningihiana Of Wanai, mayi enag nalig enag ombofimba, ehengamba elim enam ahwanifenaf. Mayi El Enag Of Wanai nalig enag ombofimba mungwal si amba fekag lofug enaig wa pukof ehefena awagna ambafeka, mungwal wankeneg ensel Godna gafungag of wanai Enag El God Ningihiana Of Wanai enag enselim wan bof. Mayi enaig ombofimba ehengamba elim enam ahwanifenaf.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Sisas mingnag mo sihini, “Yinimihe ka nem osonug, mingnag el ohwi gofo enamba mas pigi, emba auguianam nanguf God puguagum ehefena tifutukni afalig fegim enam.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Enag ena mayi kanamba afa fasagafinim enuwesowa gohok siyi mayi kanamba eso Sisas Pita, Jems, Jonnum sulufunam fukuka wankana aikieg kwiegam. Ehel mungo ahunam gofwehenam eso enag nangwagofofenamba Sisasna elig enag wahigifenam nemona fena ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ehena lofug gamba enaig esena pukowagenam mungwal businam fatinam busug newugehe fena. Mas aman mungo ohuna betenai lofug enag gigiafegim busug enaig pugufehmo? Awai! ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Eso Sisasna nihiyinai sambaga munga enag nangwaginimba Elaijam i Mosesmi sambaga ningigi enag. Sisas ga mo sihiyagofofena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita enam nangonam enag Sisasim osona, “Anuana, nawo bigwo gohiyi auguiafum. Emba sa yuhwafei. Nawo sambaga mungo fofug lala nimbagim, mingwo neana, mingwo Mosesna, mingwo Elaijana.” Pita enaig osona. ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ahnaig asegba? Sisasna nihiyinai enag enam embefini, Pitamba mas anuanafegmo, emba ahnaig mo osog? ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Leango penam elim enag yisienugena eso mo leango meanai pugunam, enaig osona, “Elimba kana leg, ka olug lahlafenag, ehena mo enag numwehenim higi!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Yikagnam ehefena nihiyinai nunofehiagini enag mas amanim nangunimo, Sisas mungo gofena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Enanam enag mugum wahiyinim apekugonam ahuafenamba, Sisas tifutinam osoni ehefena nihiyinaim enag, “Nogofeka amanim sihinim esel na nangug enam enag. Enag El God Ningihiana Of Wanai enag mayi wahanam, piske bwihiaimba, emba sa na sihigonugi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ehefena nihiyiani enag ehena mom enam pahalug ahua fenamba, enaig esini ehefum mungo olugyi wa sahugehufena, “Amangwo wahagim bwihiagmba?” ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ehefena nihiyinai Sisasim enaig sahinifini, “Ahnaig asegmba el Godna mo anuana fig, enag enaig osogona, ‘Elaija mayi boimba, afa eso Kraiswo sum wambof.’ Anuana el enag enaig osogona. Ahnaig asegmba, enagna osog?” Sisasna nihiyinai enag enaig sahinifini Sisasim. ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Sisas wahigifenam osoni, “Elimba yinimehe el mungo Elaija lofug yuwanamba pugunam wambof elni olugum enag numwehenugeimba God nangum ambogogum. Ahnaig, asegba? Autinam el enag Godna mom ginofinim enaig osogona, ‘Enag El Of Wanai God Ningihiaimba enag wa tawetik nalig faf, afa el kwisinim mas fatinif.’” Sisas enaig sihifeni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Sisas Jon, buwa aitiag el, enam olningenam, enag enaig osoni, “Enag yawomba ka nem osonug, Elaija lofug eseli enag ati pugug, afa amang amangim mingnag eseli membini enag ena ati esini elim enam gwenaig autinam profet eseli ginofini, ena yuhwa gwesif.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Sisas sambaga mungom ehefena nihiyinaim enam wankanam wan pugunam nangwagnamba ehefena nihiyinai mingnag eseli ehelni nihiyi elksa wahegagena auguiafena. Enag el enag elwo anuana el Godna mom fig el Sisasna nihiyinai ga fuflafegegofofena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Enag mungwal el enag nangunimba Sisas bwafena enag kukugiafakafinim eso osogona, “Sisasmba atiombo.” Enag eso el enag gwesim kikigni ahunam Sisas nangum, eso enaig osogona, “Atiaho nambok?” ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Sisas ehefena nihiyinaim enam sahini, “Amang mo enag el gimba na fuflafegegofona?” ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Enag mungo el elksa eseli ena mewa gofena, enag Sisasim osona, “Anuana, kana luwal fangonam Satanna nihiyinai amtakwalig ehena nihiyi go mengig kapinifegim, mo wagi hwanig, enag ka ne nangum ombug. ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Enaig esefugum amansiniwo tifutifugum kikehalafugum kiafigigninifugum betewa fatia, memp meng megam puguafug, afa goimo nunuwafug, elig enag lilhifefugum fatia, ena ka neana nihiyinaim sahinig enam enag hugufatini, enag ahnaig asihmo?” ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Sisas enaig sihifeni, “Negel, Israel, mas na olningigmo Godmba emba nem kwaganif, negelmbi nimbehe kwisig God nangum ambogogumba, sahinigim, pahalu ahuagimba. Ahanansiyigim ka nem wanagafuf? Ahanansiyigim ka negelni kinig fanif? Luwalim enam ka nangum ombugo.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Eso luwal fangonam enam Sisas nangum ombugona. Satanna nihiyinai amtakwalig enag Sisasim nangonam, eso yikagnamehe luwalim enag fuluwali fatinamba luwal enag penam betewa wafuakihla fekafenamba memb busug meng megam pugunam wahegagena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Sisas luwalna awagim enam sahana, “Ahananam enaigmba puguna?” Awag enag osona, “Yuwanam, wesigyiehe esena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Autinai gwenaig ehe esefugufena, enag Satanna nihiyinai amtakwalig enag suwiwa buwa gamba fa taiku fefuku, enaig esefuku, ogum, ‘Nawo tigenam ma wahai!’ Enag ka nem tifutigim sahanagim, na yuhwafegmba, sa na kam afafenim kam kwagani!” Luwalna awag enag Sisasim enaig sahanafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Sisas enaig osona, “Hei, nembehe na enaig olningenagmba, God ehe yininewug feg amang amang enag God ona, ‘Emba kesef’ enag Godmba yinimehe wa esef. Aman Godum enam olningenagmba Godmba emba wa yuhwafef, enamba God wa kwegofuf. Amang amang kifutuk naligmbi God mungo ehe wa esef.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Yikagnam luwalna awag enag osona, “Enaigmba ati ka olningigim, afa kana olningigmba tumek. Kam kwegofo! Mas ka mungwal olningugugum yuhwa fegmo!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Sisas nangwagenamba elksa yikagna muhwa nuwagenam wahegagena, enaig fenamba enag, Sisas Satanna nihiyinai amtakwaligim enam nunumuafana, “Nemble Satanna nihiyinai mengig nihifenag angugum nihiliag, ka nem osonag, luwalna nihiyinai enag pugumbo! Nofeika piske ka sahom!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Satanna nihiyinai amtakwalig nag hlehlefukonam, luwalim enag fuluwalifatinam, ehena nihiyinai enag pugumbona. Luwal fangonam enag nangunimba lilhifefatinam wahag lofug enaig fena. Mungwal el eseli enag enaig osogona, “Ati wahag!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Enag Sisas enaig esena, luwalim ningagana kikehalanam gifiohlunamba, eso sukli bwihiagofena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Eso Sisas lalagam sahowankana ehefena nihiyinaim mungo, enag ehefena nihiyinai enag mungwal sahini, “Ahnaig asegmba enag kagelmbi Satanna nihiyinai amtakwalig enag ahnaig hugufati fegonuhmo?” ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Enag Sisas osoni, “Amangmba mas enaig amtakwaligimba hugufatini? Awai! Godum sahanag mungwamba sa hugufaiti!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Sisas ehefena nihiyinaim wankana ena kimbigimwo wahiyinam ahunam olugyi Galili provinswa apekugona wanpuguna. Sisas onanawo ehefena nihiyinaim ahnaig ahnaig mom sisifunugem, enaig fenamba enag ona, masa bigim mingnag el enag anuwanafegonuf enanayi ka yikagim wanaga enam. ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Sisas ehefena nihiyinaim osoni, “Enag El Of Wanai God Ningihiana esel enam mingnag el wa kikehelinim tigekigim elim enam wa faigof. Emba wa el enag tigekimbi wahanam. Afa sambaga mungo si mayi ahuimba eso wa piskenam bwihiaf.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ehefena nihiyinai enag mas ena mom enag olninginimo, enag embefini Sisasim sahinigim. ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Enag ahunam Kaperneam kimbigwa apekugoenam, lalagam saigonam, eso Sisas ehefena nihiyinaim sahini, “Amang mom minawamba na fuflafege ambogofena?” ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ehefum fuflafege ambogofena, aman Ainiyagmba fef, enaig fenamba enag ehefena nihiyinai enag mas Sisasim osuinimo. ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Sisas agafenamba, ehefena nihiyinaim enam wunoni. Mayi ambogonamba, enag osoni, “Aman oi, ‘Kawo Ainiyag fem,’ emba eso ma mungwal elim kukwaganig el fei, enag enaig gafunag elmbi emba sa Ainiyagmba fei.” Sisas enaig sihifeni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Enag enaig esena, luwal wesigim kikehlanam ombunam olugyi ehefena nihiyinaim elni muhuwa wasonam, eso luwalim enam ehefena nihiniyi fa sambagahla fefanam eso ehefena nihiyinaim enag osoni, ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Aman kam pahlukuagmba afa enag luwal ohunaigimba wunonim kwaganimba, elimba kamehe lahlafefag. Aman kam lahlafefagmba elimba amang kam mungo lahlafefahmo, elimba aman esel kam ningihianamba ka bok, enam gamba lahlafefag.” Sisas enaig osoni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jon Sisasim sihina, “Anuana, ka nangugmbi el mungo Satanna nihiyinai amtakwaligim neana tifutukni ningitigifeka, enag ehmba mas big mungwalyi gowahnefihmo. Enaig fenamba enag elim enam ka kwenig.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Sisas osoni, “Negel nogafeika kwenim. Aman tifutuk gafungag kana tifutukni fegmba, emba mas kam yikagna ahnaig ahnaig amtakwaligim kam osoni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Aman bigelim waginig hwanigmba elimba bigelni hiheg. ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Yinimehe ka nem osonug. Amangal nem enaig olningugonimbi. ‘Elmbi elimba Kraisim pahalukahua, enag enam ka kwaganim,’ enag enaig nem olningugonimbi afa nem buga faiyimbi, emba elim enam ka lahlafehiagef.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Sisas ming mo sihini, “Luwal wesig mungo osohwi ohunaig kam ati olningenagmba, emba luwalim enam aman wahigifenam okuf, aman enaigmba osofefimba enaigmba sa yuhwafeite amangal hun nalig ma finim enag elni wuningliyi kikinim eso ma bu nofugwa fati eso ma pekanam wahai. ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Enaig neana ningagag enag esenam, kam olningenagim pahalukuagimba, mayi amtakwalmba fefeimba, eso hegefati. Enaig esei mungwa ningaganamba, emba sa na Godna muhwa hegeg agag enag fanam agafi. Masa na wa ningagag sambagana fenam afa na wa amtakwaligam kaf suwi mas fuhului esim wa. ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ena kukwamba elni ahnaig ahnaig tawetik enag gwesenam gofuf, ena kukwamba suwi enag mas fuhului. ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Enaig neana mongug enag esenam, kam olningenagim pahlukuagimba, mayi amtakwalmba fefeimba, eso hegefati. Enaig esei mungwa mongugnimba, emba sa na Godna muhwa hegeg agag enag enaig esenam fanam agafi. Masa na wa mongug sambagana fenam afa na wa amtakwaligam wa kaf suwi mas fuhului esim wa. ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ena kukwamba elni ahnaig ahnaig tawetik enag gwesenam gofuf ena kukwamba enag suwi enag mas fuhului. ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Enaig neana nofug enag esenam, kam olningenagim pahalukuagimba, mayi amtakwalmba fefeimba, eso nofug enag mingaganai nofugwo fusufati. Enaig esei mungwa nofnamba, emba sa na Godna muhwa hegeg agag enag enaig esenam fanam gofi. Masa na wa nofug sambagana fenam afa na wa amtakwaligam wa kaf suwi mas fuhului esim wa. ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ena kukwamba elni ahnaig ahnaig tawetik gwesenam gofuf ena kukwamba ena suwi emba mas fuhului. ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Suwi enag eso wa mungwal el ningum bonuf. Suwi enag enaig eseg sol lofugmba. ");
INSERT INTO amn_amanab_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","“Solmba lahlagehe, enag sol embeg enag awaiemba, eso aman piskena enaig embeg enag esehmo? Solmba enaig eseg sisim numwehiageg. Negel gimba enaig esi, sol lofugmba nimbefena olugyi numwehiagimbi enag elim olyi lahlafehiagi, emba sa na auguiafi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Sisas egam wahianam yikana provins Judiagam yikana gwesim bu Jordangam eso bu enag minggam yikana. Elksa ambogona nuwagena Sisasna nihiyi. Enag Sisas, ehe eso esekafena, enaig esena, Godna mom sisifunugena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Mingnag Farisi el ambogona, ona, “Nawo Sisasim gihinim.” El enag enaig sahinifini, “Enaig aman angwafigim ningihiagmba, elimba yuhwahofeg? Autinam God Mosesim mo faina, enamba? ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Sisas piskenam sahini, “Ahnaig mo Mosesmba nem faini yuwanamba?” ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Farisi enag wahigifinim Sisasim osoni, “Mosesmba kagelni ufuamba, enaig osoni, ‘Aman angwafigmbi oningihiafimba, eso ma enaig ginofenam fainam, ka nem ningihiag, eso ma ningihiai,’ Moses enaig osoni.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Sisas piskenam sihini, “Negelni ufuamba olug liputig yafuflag el, enaig fenamba enag Moses ena mom negelni ufum faini, yawo gamba negel gimba enaig esig. ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Yuwana newogmba God mungwal gawig enag gafungafe genam, afa kwambolomi angwafigmi God gafungafewogona. ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Enaig fenamba kwambolo enag eso ma awagafagim wahianam eso angwafig i mungo olug ahfanam, eso ahagambahlagofi. ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Yawamba enaig eseg, ohunanam enag sambaga mas ahagahmo, yawamba ati mungo feg. ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Amang ese God numusuhulug enag ena nofeika wo kougum.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Piskenam lalagam ahunam saigonam eso ehefena nihiyinai enag Sisasim enam enag sahini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Sisas osoni. “Enag aman mungo ehefena angwafigim ningihianam afa mingim fagmba, elimba enaig eseg, ehefena angwagim enag amtakwalefagim, afa angwafig wambugum amtakwalesungofeg. ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Afa enaig angwafig ehefena ligagim wahiagem, ming awag wa kagmba, ehengamba gwenaig eseg, afa awagwagagim enam amtakwalesungofeg.” Sisas ehefena nihiyinaim enaig sihifeni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Enag el mingnag luwal hutiatanigim Sisas nangum wan ambogona. El enag sawiyifini Sisasim ogum, “Ma luwalim enag ningagana tutohilihiagei.” Enag ehefena nihiyinai enag elim enag nunumuhiagini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Sisas ehefena nihiyinaim enag nangwagenam, enag nunumuhiagena. Sisas osoni, “Negel nogofeika kwegonum! Hwahiyi! Luwal ma ka nangum ambogoi, Godmba luwal ohunaik lofugumba sa wanagafi. ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Elmbi enaig esimbi God ehim enam ma afalig feni. Luwalmba ehefena awagim numwehe olningenif, awagna mom fa higif. Mungwal el enag enaig ma Godum esini. Yinim newugehe ka nem osonug, aman el luwal lofug enaig esei hwanigmba, elimba ahnaig asenam, God afalig elim wanagagim esel esim enag ahnaig sahokahmo! Awai newog!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Enag Sisas luwal mungogum ningagana tutohilihiagenam, Godum sahanam luwalim lahlafenugena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Sisas bwihianam yikafenamba, el mungo kikigni bona Sisas nangum, mogukug kwakwagenam Sisasim sahana, “Nemba anuana lahlag, ahnaig kasenam eso ka hegegmba gwesenam gofuf?” ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Sisas sihina, “Amang fegim na kam lahlag moaogonag? God mungwehe lahlagmba, mingmba aman fe hwanig? Awai! ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Autinam God Mosesim mo faina, ogufunugum lahlafehugum amang amang mo enag. Ati na ena mom enag anuanafeg. Mingnag momba enaig feg, ‘Nofeika amanim tigekam. Nofeika angwafig wambugum amtakwalesungofem. Nofeika okwefem. Nofeika mingnag elim moakwelenim. Nofeika waskwesenam ahnaig ahnaig esenam wambum. Awagafagna mom higigonufi.’ Enaig mo God Mosesim faina.” Ena mom enag Sisas elim sihina. ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","El enag Sisasim sihina. “Yuwanam ka luwal fefenamba ena mom enag ka pahalukuna, afa bogum yawangamba ka gwesehe feka.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Sisas nangonam elim enam olug lahlafena, enag Sisas osona, “Nemba mungom ehe na tumek. Yikanam nimbefena mungwal gawig enag ningitigife, el ma wambwi, enanam mani enag wambnam eso amangal esel wohof, lofug, amang amang enam enaig hwanig feg, enaig elim, mumankeni. Enaig na eseimba emba sa na ofwa yika pugunam enagsa gawig lahlag na wambwi. Gawigim enaig esenam, eso, bonam kam pahalumbwi.” Sisas enaig sihifena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Enag el enag ena mom higinam nohmbosug wahigifenam afafenam nemonafena afa olug kinig fenam ena kana. Ahnaig asegmba? Enag el enag gawig numbiyinai fena, enag esena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Sisas ehefena nihiyinaim enag fahegenugenam, enaig sihifeni, “El gawig numbiyinaimba ahnaig ahu saigoahmo God wanagag esel esimba.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ehefena nihiyinai ena mom higinim enag olug wahegesainam enaig sihiagahufena, Sisas ehefena nihiyinaim ming mo sihini, “Kana luwal, aman God wanagagamba esimba sahwagimba, enag ahnaig sahokafef? ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kamelmba sis nalig bulmakau nalig lofug, enag yikagim nel nasig megam enag ahnaig sahokafehmo? Awai! Afa aman el gawig numbiyinai gamba gwenaig eseg. God wanagagamba ahnaig sahokafehmo?” Sisas enawasim enaig sihifeni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ehefena nihiyinai enag olug wahegasainam ehefum sihiagini, “Enaig esegmba aman hegeg gohogmba fanam gwesenam gofuf?” ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Sisas, nofna nangwagofenamba, enag osoni, “Elmbi ahnaig asihmo? Awai! God mungwamba sa elim enag numwehenugenam eso ahunam saigoi. Amang amang God esegim esel, enag emba wa yuhwa gweyi esef.” Sisas enaig sihifeni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pita Sisasim osona, “Higi, kagelmbi mungwal gawig enag ati ka hwatigim, enag ka nem pahalug ahua.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Sisas osona, “Yinim newug ehe, ka nem osonug, aman kam olningenam, eso yikanam Godna mom lahlag sihiagekafi, afa ehefena lalam wahiyai, etegim, suminigim, muluwalim hwati, awagafagim hwati, luwal, asom hwati ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","aman enaig hwatiegmba emba sa enagsa 100 wambwi, ohuna betenai etiniagsa 100 lala, nilite, muluwali, afag, luwal, aso afa emba wa kinig gimba wambof. Enengim ohuna betem wahianam, eso hegeg gohogum enam fanam eso gwese gofi. ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Afa enagsa el esel yawo ohunanam gosugmbi enamba enengimba wa sum fesaif. Afa enagsa el yawo ohunanam sum fesaig enag ehe enengimba wa gosuf.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ena minam ahuafenamba Jerusalemgam Sisas gosna. Sisasna nihiyiani enag olnigninim oluwahegasaina ogogum, “Ahnaig Sisasimba pugunaf?” Mingnag el gimba Sisasim pahalug ahuafena. Enag ehel gamba embefini. Sisas ehefena nihiyinaim 12 fena enam mungo sulufunam. Enaig sihinugena amang ehim wa pugunaf. ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Sisas osoni, “Higi, yawomba Jerusalemgam big fukwalgogum ahufe. Enag El God Ningihiana Of Wanai, elim enamoa el mungo pris elmi anuana elmi wa faiyif. Ena pris i anuana el i sihiaginim mungwa mo finim afa so enaig osogof, ‘Eso ma tigekinim ma wahai!’ Mingnag elim wa faigof elimba Israel wanai el mo. ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","El enag enaig esinif, kiapasefinim, ahnaig ahnaig esefif, memp fuginif, wena tiginim, afa tigekif. Enaig esef, sambaga mungo siyi osuwu i, mayi yikaimba, eso enagel piskenam bwihiaf.” Sisas enam sihinugena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jems i Jon i, Sebedini le ningigig, sambaga ningigi enag Sisas nangum ahmbonam ahsahana, “Anuana kohogum kawo nem amang mungom ahsahanam enam enag kam eseni.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Sisas sahini, “Amangim na sawie ahfeg nohogum, ‘Kam eseni’?” ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Enag sambaga ningigi enag ahsihina, “Enagimwo wangenegenam enag nemba afalig fegmba nimbefena elim enag na wanagafuf, enag ka enaig sawie ahfeg, kohogum kawo amanwo neana nihigam agai amanwo neana sahagam agai.” Enaig sahnahfena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Enag Sisas osoni, “Neningigi enag mas anuana ahfegmo amangim esel na ahsahig enamba. Na yuhwa ahfeime? Kinig nalig esel, kamble fagim. Feg enaigmba na yuhwa ahfaime? Blufle nalig lofug enaig bogum nem yisiyi fa kaugoimba. Kamble fagim esel enaigmba. Enaigmba na yuhwa ahfaime!” Sisas enaig sahinigena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Sambaga ningiginenag osohona, “Emba ka yuhwa ahfef.” Sisas sambaga ningigim enam sihini, “Yiniho, enag kinigmbi emba na wa ahfafwa, afa mingnag kinig nalig blufle lofug enaig ne wa yisiaogof. ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Afa enag aman sahagam agafim nihigim agagim enag, kamba mas gishu fwahiai, elimba God mungwamba sa enaigmba gishu fwahiai. Autinam God ehe elim enag ati gisfugum hwatigig enanayi ahagagimba. ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Mingnag Sisasna nihiyinai enag 10 enam, enag enam higinim enag Jemsmi Jonmi wagugoni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Enag Sisas wunoni, “Ambogonam kana nihiyi nuwag,” enag osoni, “Nolningig mingnag elni nangwag gohogmba, ehfamba enaig esehu, ehefena nihiyinaim tifutigim nangwagihiagewo. Amang amanagim enam og, ‘Kam mayi osoimba, eso kam kwegfwi.’ Enam og enag ehena mom enag mungwal pahlug ahuafena. El enag ehena gafungag figim, afa mungwal pahalug ahug. ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Enaig el esel esig, afa negelmbi nogofeka pahago ahum enaigim enag. Negeliyinai aman enaig oliegmba, ‘Kawo nangwagohog el fim,’ aman enaig oliegmba, emba eso ma gafungag luwal fei, afa mungwal elim kwaganyegim yuhwafei. ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Aman oimba, kawo sisigam Ainiyag fem, emba eso ma gafungag luwal fei, mungwal el esel enagna singagfeni, mungwal elim enag kukwaganig fei. ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ahnaig asegmba, enag ka osog? Enag El God Ningihiana Of Wanai ehe gamba enaimba ohuna betegam bogum ehena gafungag mas figmo el ehim mas kwegofugmo. Awai! Ehe bogum elim gafungafegim kwaganyegim. Ehe bogum elim wahanigim, afa elksam piskegim wambugum ahnaig ahnaig amtakwalig el esel esehufena enagnai!” Sisas enaig sihifena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ambogonam apekugonam Jerikowa, enengim Jerikomwo wahiyinim ahuna, Sisas ehefena nihiyinaim wankana, afa enagsa el, ena gamba mungwal ahuna. Bartimeus Timeusna leg, enag mina meigim agafena. Ehmba nofselena enag elim manim wunoniaofena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Enag higinam Sisas Nasaret wanai ombo, enag gweyi hognam amtakwal wuneona, “Sisas Devitni leg, nemble kam afafena.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Elksa nunumufini, “Kawug kapinife.” Afa enag el enag hognam amtakwal wune nalig fena, “Devitni leg, nemble kam afafena.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Enag Sisas yikanam muhwa gohnam, eso Sisas osoni, “Wuni, ma boi!” Mingnag el elim nofselenam enam wunoni, “Olug lahlafenam! Bwihia! Sisas ati nem wunonag.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Lofug foholanam agafena, enag lofug hugufatinam yikagna bwihianam, Sisas nangum yikana. ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Sisas enag elim enam sahana, “Amangim na sawiyifeg, nogum?” Nofselena el enag Sisasim osona, “Kogum kawo nunof fehiagem!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Sisas sihina, “Yisehe yika, ati na olningig emba God ne wa kwegofuf, enag nofug enag piskenam yuhwafena.” Enag yikagnam nunofehiagenam, eso Sisasim minagam pahalukuna. ");
INSERT INTO amn_amanab_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Sisas elim wankanam Mug Olivyi wanpuguna. Mug Olivmbi kimbig Betfage afa Betani mugwa gofena. Ena kimbig sambaga enag Jerusalem kimbig nalig muhwa ahgifini. Sisas ehefena nihinaim sambaga ningigim ningitiginam, ");
INSERT INTO amn_amanab_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","eso enaig osoni, “Ne ningigi okwena kimbigam ahka muhwa esel gi esim. Ne ningigi ahkanam enag kimbigam ahsahon, eso yikagnamehe na wa ahnangof donki luwalig mungo el wena kikigim wahiyig. Ena donkiim mas aman mungo enanayi agagim okugmo. Donki enag pitigifanam ahombu. ");
INSERT INTO amn_amanab_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Mingnag elmbi mayi nem enaig sahigonigmbi ogoi, ‘Amang fegim enaigmba nesahofe?’ Eso piske enaig sihiahfeni, ‘Ainiyag ogum kawo enanayi gafungafenam, eso piskenam yikagna ningihiam.’” Sisas enaig sihifeni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Enag sambaga ningigi enag ahyikanam ahnangonamba donki luwaligim enam wena kikinim wahiyiini ambagam minawa ahnangonamba lala mengig muhwa, enag sambaga ningigi enag we ahpiginam ahwanigina ahfana. ");
INSERT INTO amn_amanab_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Mingnag el muhwa gofwehiafena enag sambaga ningigim sahigoni, “Ne ningigi amang fegim enana donki luwaligmba elimba ahopitigifa?” ");
INSERT INTO amn_amanab_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Enag sambaga ningigi enag Sisas esel esona gwenaig sihiahfena. Enag eso el nag wahiyini sambaga ningigim enam ogona ma donkiim enam ahpitigifenam ahokwi. ");
INSERT INTO amn_amanab_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Enag sambaga ningigi enag donki luwaligim enag Sisas nangum ahpitigifanam ahombuna. Sambaga ningigi enag lofug donkiim masigim ahnufohlanamba eso Sisaswo enanayi fukonam agafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Elksa lofug munawa nufohla hwatini. Mingnag elwo asogam ahunam li kagag higfeginim wambuk ambogonam minawa sungwa hwatini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Afa mingnag elwo gofahuafena, mingnag elwo sum ambagwafena, enawo wunena ambogwafena; Godum lahlag moaogunim. God elim enag ningihianamba, ena bona. God eso ma elim enag lahlafenagei. ");
INSERT INTO amn_amanab_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Autinam kagelni ufu Devit, Afalig Israel elim wanagafena. Enaig lofug yawamba ati piskegim ombo, God enam eso ma lahlafenagei. Bigel enag nawo Godna wunehalam sisiyigam newug gufiyinim ofukwalgonam enam lahlag moaogonim. Enag el enag enaig wunewat ofwafina. ");
INSERT INTO amn_amanab_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Sisas yikanam Jerusalemoa pugunam Godna lala naligim yikana sahonam mungwal ena lala mewa eyi fahegagena wahianam. Osuwu yikanam pefenamba, enaig fenamba enag ehefena nihiyinaim mungwal pasnam 12 enam, enam mungwal Betani kimbigam wankana. ");
INSERT INTO amn_amanab_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Siyini, Betaniim wahiyinim Jerusalemgam ahuafenamba Sisasim bini wahana. ");
INSERT INTO amn_amanab_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Enag Sisas li figim nangonamba wahegwa gofenamba, figeyimewofena. Enag yikanam muhwa pugunam eso yisigiagena, onam “Atiame fug lege?” Enag nangonamba figeg mungo wahegegena. Ahanaig asegmba? Enanamba fug legnamo? ");
INSERT INTO amn_amanab_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Sisas lim enag osona, “Mas na fugmba lei enengim gamba! Awai newug!” Ehefena nihiyinai el enag enam higini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","El enag ahunam Jerusalemoa apekugonam. Eso Sisaswo yikanam Godna lala naligim sahokana. Israel el enag enaig esifini, olyini kawo so mani afa twafig afa sis Godum faiyim. Mingnag el sisim twafigim Godna lala nalig nimbag betewa wambuk ambogofenam sungu finim afa enanam mani wambugegofena. Sisas enag elim enam ningitigifena. Kukofenam fatina simewa eseli enag el mani sungufinim mani wahigififinim mumankegegofofena. Sisas sime enam kukofenam aitini mingnag elwo twafigim manina wambugegofofena, enag ehelini eyi auguiag (sia) enam Sisas kukofe aitinaim. ");
INSERT INTO amn_amanab_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Enag kweni, “Nogofeka amang amang Godna lala naligim osum wambusaigom. ");
INSERT INTO amn_amanab_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Autinam enag God ehefena mom faini, ena mom el ginofini, enaig osoni, ‘Kana lalamba el eso ma enaig sefafi, Godum Sihinig Lala. Enag lalamba el mungwal esel gohnefe enag elni lala.’ Enaig autinam God osoni. Afa enag negel enag enaig esigim, enag yawamba enaig feg, okwef elni lala lofug!” Sisas elim enam enaig osoni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Enginag ainiyag pris el afa anuana el enag ena mom higinim, enag. Eli enag enaig olningugini, “Ahnaig big asinim eso Sisasimba big tigekif?” Pris i anuana el i enag Sisasim embefini. Ahnaig asegmba? El mungwal enag Sisasna mom higinim, enag olug wahegesaina. ");
INSERT INTO amn_amanab_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Si mayi kigfiafenamba eso. Sisas ehefena nihiyinaim enag wahkana Jerusalemumwo wahiyinim. ");
INSERT INTO amn_amanab_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Sini leawa kwimbiyim ahunam li figim enam nangonimba ati ehesafena, figeg ehesafenam mungwal puhwag nuhulugum ehesafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita piskenam olningugenam, enaig osona, “Anuana, nango, li fig enam nosona, ‘Mas na fug lei enengim gamba.’ Enaig fenamba enag ati ehesafegim wagag!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Sisas wahigifenam elim enam osoni, “Negel gimba Godum olninginimbi Godmba emba yuhwa fef amang amangim enam. ");
INSERT INTO amn_amanab_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Aman mungo sambaga olug hwanig, mungo olugnifenam, enaig olningugeimba Godmba emba wa yuhwafef. Enaig olningugeimba, emba amangimehe esel sahig enag emba wa pugunuf. Enag ohuna mugum enag osonaimba, ‘Nemba fgafu kanam wahegimeg bu solna gi enanayi yikanam pe.’ Enaig osoimba, emba wa esef. ");
INSERT INTO amn_amanab_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Enaig fenamba enag yawo ka nem osonug, enag na Godumba sihinagim ahsahanafimba enaig olningenam, amangim eseli na ahsahini enag figim, enaig leseimbi, emba na wambuf. ");
INSERT INTO amn_amanab_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","“Enag mayi na gohonam Godum sihinagofimba, na enaigim olningimba, aman nem amang amang amtakwalig esenag, enam enag etetinam wahiai. Nogofeika mungwal ahnaig ahnaig amtakwalig enag mingnag el nem esegonum, nogofeika enam kikehelim! Eteti wahiyi! Esmba na fimbi, neana awag ofwa aga, enag nem ahnaig ahnaig amtakwalegim wambihiageni, mas piskenam enam enag olningi. ");
INSERT INTO amn_amanab_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Enaig na mingnag elni ahnaig ahnaig amtakwalig na etetigim wahiai hwanigmba, emba God neana ahnaig ahnaig amtakwaligim mas eteti wahiai.” Sisas enaig osoni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Piskenam ahunam Jerusalemoa apekugonam. Enag Sisas Godna lala naligyi tempelyi sahonam langwagofena. El Enginag ainiyag pris el afa Ainiyag sisiyi fesaig el, enag el Sisasim nangum ambogona. ");
INSERT INTO amn_amanab_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Enag Sisasim enaig sahinifini, “Aman nem osonag, ‘Ena gafungag ena fe,’ aman nem enaigmba osonag?” ");
INSERT INTO amn_amanab_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Sisas mungwag sihini, “Amang mungom ka nem sahinim, na kam mungwag enam sihinigmbi, emba sa ka nem sihini aman esel kam osonag, ‘Ena gafungag ena fe enam,’ mungwal gafungag esel ka feg. ");
INSERT INTO amn_amanab_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Aman Jonumba osona. Elim buwa aitiagimba? Ena mo enag ofwanai boname? Elyinai boname? Kam sihini.” Sisas enaig sahinigena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Enag el ehefem sihiagegofofena, “Amangim big osogof? Big enaigmba osogoimba, ‘Ofwanai bok,’ emba Sisas bigim sahinif, ‘Ahnaig asegmba enam mas na olug wahigifigim Jonna mom pahalug ahugmo?’ ");
INSERT INTO amn_amanab_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Afa enaigmba big osogoimba, ‘Elyinai bok,’ emba el bigim nunumuhiagif.” Ahnaig asegmba? Enag el enag Godna lalanaim mingnag elim embefegoni. Mungwal el enag olningini Jonmba profet, Jonmba Godna mengig wanai mo fag el. ");
INSERT INTO amn_amanab_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ainiyag el enag enaig fenamba enag, Sisasim wahigifinim osoni, “Kagelmbi anuanamo.” Enaig fenamba enag Sisas osoni “Enag ka gamba mas ka nem sihini aman esel kam osonag, ‘Ena gafungag ena fe enam.’” ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Sisas enawasim sihini enaig osona, “El mungo wain lifug aso fegim bwag aitig. Mime kunim hun tifutukni numwehiaginim enanayi wain fug aitinim mongni wainfug fapaugofigim enaig esigim bug puguagim. Enag sime lala kwina nimbanam el enanayi fahegegohogum ma sa wa okwefna el ambogonam wain fug wambuf. El enag mingnag elim wasanam enag asom fahegegofohogum, afa mingnag lifugwo ena gafungag wanai enam wambugum, afa mingnag lifugwo asoana awagim faifini. Asoana awag wahegam kafenamba. ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Mayi lifug enag asonai enag ambiafenamba, eso asoana awag gafungag el mungom ningihiafena enag asogam, enaig sawiyifefenam ma mingnag wohof yika wambwi enag asonai. ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Enag el asowa fahegeg gofohog enag enaig esifini. Elim enag nangufinim, mayi bwafenamba, sulufifinim tigifinim, yusug piskifinim ningihiyifini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Asoana awag enag piskenam ming elim ningihiana, enam gamba mesowa topinim amtakwal tigifini, amtakwalefini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Asoana awag ming elim ningihiafena, enam tigekifini. Enag enagsa el gafungafigim ningitigifena enag asogam. El enag enaig esinim, mingnag elimwo behtanigim kugwag aitifinimbi ahkitigiaogona, mingnag elimwo melni kugwagsungofini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Enag mungo gofena, elimba ehefena leg mungo enam olug lahlafena. Awag enaig sihifeni, ‘Elimba kana luwal, gafungag el enag kana luwalim anghiginim lahlafinif.’ Enag sumiyim enag ehefena legim ningihiana. ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Enag el eseli enag asowa gafungafegofofena enag ehefum oligi sihiagahufena, ‘Elimba asoana awagna leg, emba awagimoa wahaimba mungwal gawig ena wa wambuf. Hegefi! Nawo tigekim, nawo tigekinim, eso ehena asom fim!’ ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Enaig fenamba enag tigekinim eligimwo aso leng meigim finim fatini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Enag wain asoana awagmba ahnaig asef? Emba bonam, el eseli asowa gafungafegofofena, enamba kugwag sungo fenam eso mingnag elimoa asowamba enamba faif. ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Mas na ginofum enag fahegaginimo God autinam osona, enamba? ‘Mingnag el lala nimbigim, gungwekigim mungom nangufinim kwisifini, Afa gungwe kik enag yawamba wofugukum pugug. ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ainiyag enag enaig esegim pugug; enag ka nangugmbi lahlag newug feg.’” Sisas enag ehefum ena wasim osoni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ainiyag el enag enam higinim ati olningini Sisas enawasim ehelim osonug olningini “Kagelmbi amtakwalig enawasim enaig fenamba,” enag el enag ogona, “Nawo Sisasim kikehilinim ogohum,” afa enag embefini. Enagsa mingnag el esel Sisasim pahalug ahuafena, enag elim enag embefegoni, enag Ainiyag el enag Sisasim wahiyini ahuna. ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Mingnag el Farisi elim afa Herotna nihiyinai elim enam nigitigini Sisas nangum. ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ona, “Nawo Sisasim amang amangim sahinim. Ogona mayi Sisas amtakwal sihifeimba, neso sulufinim kotinim.” El eso tatam aula fakahilinif, enaig lofug ogona, “Nawo eso Sisasim esinim.” Israel el Rom wanai gavman elim takis mani faigim, enag nunumugonam kwisini. Enag Farisi el afa Herotna nihiyinai el enag ambogonam Sisasim sahini, “Anuana, ati ka olningig, nemba yinim osfawof, nemba mas embefini ahnaig ahnaig esel nem olninginig enam. Aman esel Ainiyag feg enam enag nemba mas ahnaig mo faiyinam. Afa aman esel hofanam feg enamwo mas na ming mo faiyi. Awai! Nemba yinim fa sihif God esel membeg enam mungo. Enag nimbe kam sihin, Romoanai el elim nangwagawo, wunehalamba, Sisa, enamba ka manimba faiyime? Awaime? Enaigmba ka esimbi ka yuhwa feime? Awaime? Enag kawo mani enag faime? Awaime?” Sisasim enaig, sahinifini. Ainiyag el enag enaig olningugini, “Sisas mayi enaig sihifenimbi, takis mani Sisam fai,’ eso mungwal Israel el Sisasim nunumufif. Afa enaig mo sihinimbi, ‘Nogofeka takis mani Sisam faim,’ eso gavman el Sisasim waginif.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Sisas ati olningini enagel enag ogona, “Nawo Sisasim gihinim.” Enag Sisas wahigifenam, osoni, “Amang figim nogogum na kam gihinim? Mani busug kam ombugona, kawo nangom.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Enag el mani mungo ombugona, enag Sisas sahini, “Nohmbusugi wunehalag mba amana?” El enag osoni, “El Ainiyag esel Romoa nangwagawo, wunehalamba Sisa, enagna nohmbusug.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Enaig fenamba, enag Sisas osoni, “Amang Romoa nangwagohog elnimba, emba eso enam faiyi; afa amang Godnamba eso Godum faiyi.” El enag ena mom higinim olug wahegasaina. ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Mingnag el Sadyusi el Sisas nangum ambogona. Sadyusi el enag enaig osogwafena, “Elimbi wahagim, mas piskenam bwihiai.” El enag ambogonam, Sisasim sahinim, ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Anuana, Moses ena mom autinam ginofena, amanim luwal hwanig wahaimba, afa ehena angwag agafuf, emba so ehefena suminig enag ena angwafigim enag ma fafim. Luwal mayi feimba eso ena luwalwo eteg esel luwal hwanig wahag ehagna kukwa gohof. ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Autinam elengegwa gohona, enansini nilitena gofwehena enag eteg angwafig fanam, afa luwal hwanig wahana. ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Etegim engeg enag angwafigim fanam, afa luwal hwanig wahana. Bwali enag fagim gwenag angwafigim fanam, afa ehe gamba luwal hwanig wahana. ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Afa figinyeg, afa, enuweso, afa elngeg ena suminimbugug enag finim enag angwafigim mungom enag luwal hwanig fesainam pigina, afa angwafigim gimba sumiyim wahana. ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Enag hwaonam, melig pigyeg ena wa bigiagafef, enag hwaonam enag angwafigmbi amana angwag fef? Ati na olningig elengegwa gohona enag el enag angwafig mungom fini.” Sadyusi Sisasim enag enaig sahinifini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Sisas osoni, “Negelmbi mas na anuana figmo Godna mom autinam el ginofini enam. Enag mas na anuana figmo Godna tifutukum gimba. Enaig fenambe, enag negel enag mwetetiagig, mas na yuhwa figmo? ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Enanam melig pigyeg piskenam bigiagofefimba, enanamaba mas angwafigmbi wambwi. Ensel, Godna gafungag wanai, ofwanai, angwafigmbi mas wambwi, enag enaig el gimba wa esif. ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","“Yawo enag nawo olningugim el wahagim piskegim bwihiagim enam autinam Moses ena mom enag ginofena li suwila lagofenamba. God ena suwi mewa sahogohonam Mosesim sihinagena. Ena mo enag mas na fahegigmo? Abraham, Aisak, Jekop enam autinam pigig, enag God Mosesim enaig sihifena, ‘Kamba Abrahamna God, Aisakna God, Jekopna God.’ God Mosesim enaig mo sihina. Afa God ati olningina ehelni sungwagmba mahiyim augwia. ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Godmba melig ese pigig enag elni Godmo. Awai! Elimba enag elni God ehe aman esel hegeg gohogum esel, enag elni God. Negelni moamba amtakwal newug feg!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Anuana el mungo bona Sisas nangum, ena hegenamba mo fuflafegegofofena. Enag higinamba Sisas mo wahigifenam yuhwa sihini. Enaig fenamba, enag el Sisasim sahana, “Godna moamba ahanag sisiyiamba feg?” ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Sisas wahigifenam elim enag osona, “Mo sisiyi fegmba ohunag, ‘Negel Israel! Negel higi! Ainiyag God mungwehe mungo Ainiyag bigelni fenig. ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nimbefum! Ainiyag enag, nimbefena Godum enam nininewug olug lahlafena. Nimbefena olug, sungwag, tifutuk, enag mungwal Godum ma lahlafini.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Enam engeg mom mba enaig eseg, ‘Nimbefum esel na lahlafenagmba, enaig eso mingnag elim gimba enaig olug lahlafenai aman esel neana muhwa aga enam.’ Ming mo mba mas ena mo sambagam enag flafatigmo.” Sisas anuana elim enag enaig osona. ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Enag anuana el enag Sisasim sihina, “Anuana, nemba yuhwaho osog. Elimba yuhwahofeg, esel nosog God mungwehe Ainiyag feg, ming Godmba mas fegmo, gweli mungwehe. ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","El ena Godum ma olulahlafini, olug, sungwag, tifutuk enag mungwal enag Godum ma olug lahlafini. Ehefum esel lahlafenagmba enaig eso ma minbnag elim gimba esei aman ehena muhwa aga enam gamba ma olug lahlafeinai. Sis afa amang amang enagel Godum fa faiyif, enaig pahalu ahufigim enag elimba yuhwaho. Afa enag sambaga ningigi mo enag pahalukahuagim afa amang amang Godum faiyigim enam flafatig.” Anuana el enag enaig sihi Sisasim fena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Sisas enam hegnam, enag olningig anuana el ati olningig ena mo lahlag nininewug sihig. Enag Sisas sihina, “Nembe gweli ati na bogum Godna muhwa puguagim ofe. God afalig esel enam wahegwa na gohmo.” Enag mungwal el esel enag embefinim Sisasim ming mom sahingim. ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Sisas Godna lala naligyi tempilwa gofenamba elim mo sihinugenam, enaig osoni, “Ahnaig asegmba enag anuana el enag enaig osogog. ‘enag Kraisim enam ogogum Devitni leg?’ Ahnaig asegmba enag enaigmba osogog? ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Godna sungwag Devitim ogofunagenamba, enag Devit autinam enaig osona, ‘God Ainiyag enag kana Ainiyag sihina, Nemble kana nihigim ningagim agai. Nihigim augwiagmba enaig eseg aman esel sisiyifeg enag fawof. Enengimba amangal esel nem ona kawo amtakwalefim enag elim enag ka neana mong singag wasanif.’ Devit Godna mo enaig osoni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“Devit ehehmba, ‘Ainiyag’ moaogona, enag Kraismba Devitni leg ena ming momba enaig eseg Devitim gamba Ainiyag fenag.” Sisas enaig osoni. Enag elksa sifakalni Sisasna mom higinim. ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Sisas mo ogfunugum enaig osoni, “Anuana el enag mingnag enaig esehu, enam negel gimba nunofifum anuana elim eseli enam. Anuana el enag enaig amtakwaligim membig, lofug kwieg aitiagigim, eso aisagafesai. Lofug kwiegmba autinam enag anuana el mungo aitikigwafena. El enag enaig olyifini ogona, ‘Eso el kam ma lahlafegoni.’ Enag eso ambogofenam ambagam nuwagifinam sahoafena kimbigwa gamba. ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Israelna nuwagig lalawa enag el enag kuk lahlagim mungo lahlafini ogonam, ‘Nawo ahufenam ambagwa elni nohmbosogam auguiafum. El ma bigim nangwagi.’ El enag ogona, ‘Nawo wohof nalig ahagagwa gamba ahufenam, kuk lahlagwa mungo auguiafum.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Mingnag angwafig esel ligambugugum, mayi pigiafenamba angwafig mungo mayi auguiafenamba, anuana el enag ahufena angwafigni lala enag wambugifini. El enag Godum enaig moakwalnifinim sahinifini kwina gwesim ogohu asagafena. Hwaonam, God fahegagofefimba enanam enag enaig el kinig tawetik nalig newugehe wa wambuf.” Sisas enaig mo osoni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Sisas mani keg muhwa agafena Godna lala naligyi. Enag elim nangwagawofena mani aitiagofofena enam. El mani numbiyinai el enag mani nalig aitini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Angwafig esig mani hwanig bonam mani ongug wesig sambaga fatiaogona. ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Sisas ehefena nihiyinaim wunoni, “Ambogo, yininewugehe ka nem osonug, angwafig esig esel mani hwanig fegim afa mani nalig fatig. Mingnag elim enam flafugum aitig. ");
INSERT INTO amn_amanab_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Enag el mungwal eseli enag mani numbni fesaig mingnag hofanam mungo wambuk ambogogum aitig. Afa angwafig esig enag esel, ehewo awai newug fena, mungwal mani gweliehe fatig, wohof gamba amangna wambuhmo?” Sisas enaig mo osoni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Sisas Godna lala naligim enam wahianam puguna yikana, ehefena nihiyinai mungo Sisasim sihina, “Anuana, nango, hun lahlag naligni Godna lala nimbini, afa lala enag nalig lahlag newug ehe!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Sisas wahigifena enaig osona, “Ena lala naligim enag atiaho na nangog? Emba hun mungo mas mung hun sisiyi gifi. Awai! Emba wa mungwal tutosungofinim tatugof.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Sisas Mug Olifyi agafenamba nanguwufena Godna lala naligim. Pita, Jems, Jon, Andru, enag el mungo Sisas nangum ambogona, ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","sahini, “Yawo eso na sihig, enamba amansi puguf? Amang ahanaigwo mayi puguimba, eso enam ka nangum so olningim enamba ati muhwa puguagimofe?” ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Sisas osoni, “Negel numwehinim nunofifum aman mungo wa nem moakwalenim wankaf. ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Elksa emba wa ambogonam kana wunehalam sefinim, enaig osogof, Kikehe Krais, God, kam ningihiyiana. Enaigwa osogonam, eso wa enaig wa esif. Elksam mwakwalegonim wanahuf. ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Enaig enengim na hegimbi fak ahagfi afa fakmo bonam puguafi wahegwanai, enamba emba wa puguf, mungwal bete i, of i awaiegimba emba wa mahiyi fefuf. Enam na higinim negel nogofeika oluwahigesaim. ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ming betenai elwo ming betenaiim fegonfuf, ming king ehefena nihiyinaim pasifenam mingnag king wan go enam fegonfuf. Minggamwo kugwa puguafuf, minggamwo bini nalig puguafuf. Enamba enaig tawetik angwafig luwal muhwa fukuagim eso esfafef enaig wa puguf. ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Negel enag numwehenim nunofifum. Emba wa el nem wanahuf kaunsulna nihigim nahunam enam sihiagigim. Emba wa negelim nuwagig lalawa enanayi kugwag aitifif. Negel kam pahalug ahuafimba gwena mungwehe nem, wan ahunam gavman, kingni nohmbosugwa wan apekugonam wagonuf, eso negel enag Godna mo wankeneg mo sihigoni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Mungwal el mungwal betewa mungwal esel enanayi Godna mo wangenag enag mayi kaimba eso bite i ofmba enamba awaief. ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Enengim mayi el nem wanahufefimba kotimegonugum, nogofei, ‘Ka olug wahigegim, ahnaig big osogof?’ Awai! Mungwal mo God ne faimbi, eso na sihif. Ena mo enag nimbefningalni moamomba! Awai! Emba Godna Sungwagna mo. ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Mingnag elwo ehefena niliteninga elim faigof, ogofei, ‘Ma tigeki.’ Mingnag el humoanwo luwalim elim faigof, ‘Ma tigeki.’ Luwal gamba wa awagafagim wagugonim elim faigof, ‘Ma kugwag sungofi. ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Afa negel enag kam pahalug ahuafimba enag mungwal el eseli enag nem olug kakagegonuf. Amangal tifutinim kam gwesinim pahalug ambogofefimba emba ahuanam mayi bite i of i awaiofefimba, enag God wa elim enag kwaganam wan bonam, eso hegeg gwesenam wan agafuf.” Sisas enaig sihifeni ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Enag enag el amtakwalig newug enagwa amang amtakwalig gafungafinim ena wo ombugunam osaigonam washuf, Godna lala naligyi. God newugum esel amang sisim, twafigim el fa faiyif ena kukwa el amtakwalig enag moakwalig Godum ombugonam ena fohluf. Aman ena mo enag fagehagmba eso ma numwehenam olningugei. Autinam God ena mo profet el Danielim sihina, enag ena mo Daniel ginofena. Enanam enag amangal Judiawa oguwa enag, so ma mugam yikagna fukwalgonam ahwi. ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Aman lala sime mugyi gofimba, nofeka lala megam sahonam amang amang gawig ena fam. ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Aman asowa gohogmba, nofeka lalagam yikanam lofugnga enaig fam. ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Enag angwafig afnialigni gamba, elsimbam, angwafig luwal hwutiatanig mahiyim tut yuwig ahufena enag gamba elsimbam. ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Negel enag Godum sahini amang enag eso masa ninegnam enana puguf! ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Yuwana newug God mungwal gawig esegenam enanayi kinig puguna, enag enanam pugugum bogum yawo ohunanayi feg mingnag kinig mungog gamba ati yawo enag feg, enag enengimba nalig kinig newug ehe wa puguf autinai kinigim wa flafatif. Afa hwaonamba enaig kinig enawa mas piskenam pugwi. ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Autinam newug God eso gishu fwahiana enanam enag amtakwalignam tumefatiagim, afa kwina kafimba mungwal el enawa awaiete. Enag asegmba God olningini mingnag elim esel autinam gisfuna hwatina ehe nangum ambogogum enaig fenamba. ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Enanam enag aman mungo wa nem osonuf, ‘Nangu! Kraisba esel go! Nangu! Egam ese go!’ Ena mom enag nogofei ka olningim! ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Afa mingnag elwo wa enaig moakwalif, ‘Kamba Krais,’ afa mingnag el amtakwalig wa apekugonam ogofei, ‘Kamba profet Godna mom ka wambuk ombugog.’ Enag el enag ogogum ‘Kagelim enam God gisfugum hwatig’, enam ogogum ‘Nawo wan ahum.’ Enag enaig wa esif, tifutuk gafungag wa apekugof, apekugof ahnaig ahnaig ehfamba nemona, autinamba mas enaigimba big nangunimo, ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Amang esel mahiyim puguahwanig feg, enag hwaonamba wa puguf. Enam ka nem osonug. Enaig fegmba enag negel enag numwehenim nunofifum.” Sisas enaig sihifeni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Enag kinig nalig mayi awaieimba, eso osuwu pugog hwanig wa feg, afa waswa pugog hwanig wa fei, ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","bagnofut ofwanai fugahianam apeigof. Mungwal tifutuk ofwanaim, enag autinai tifutuk kikehelagu osuwi, was, bagnofut enag ehefena kukwa autinam gofofena, enag emba wa kiafigif. ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Enanam enawa Enag El Of Wanai God Ningihiana enawa leangowa pembof, mungwal tifutukni, afa afwambusug nalig newugni feimba, eso el nanguf. ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Autinam, God elim ehefum gisfu hwatina. Enanam ombofimba, eso wa enaig esef. God ehefena ensel gafungag of wanaim ningitigif elim ehe esel gisfugu hwatig, enam nuwagug ahugum. Emba wa mungwal bete esel enagna wambugenam afa of i bete i mwetetenaig wanai gamba mungwaliyi wambuf.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Li fig enag emba nem amangim ogofunuf? Enag li fig enag mulug figeg apekugofehba emba ati na nolningig osuwu nalig muhwa opuguhmba enag esfafef, enag eso ati big olningig ningi sisig esoh enaig esfafef bu puguagim mayi meini ofehba, eso sisesungofafef. ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Gwenaig ehe na nanguf amangim esel ka nem osonug, enamba, elim na wa nangwimbi wa puguf, enag emba na wa olningif, El Enag God Ningihiana Of Wanai enag go ambagam mengig muhwa. ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ninimehe ka nem osonug, enanam elim enag pigeg hwanig fe fimba, eso enanam mungwal amang amang enawa puguf. ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Of i, bete i, gamba emba wa awaief, afa kana moamba mas awaiei.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Aman mungo olningig hwanig amansini ehe wa bof osuiname, sinainime. Godna gafungagwanai ofwanai gamba mas anuanafigmo, Godna leg gamba mas anuanafegmo. Awag ehe mungo ati anuanafeg enam enag. ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Negel numwehinim nunofifum, mas na olningigmo amansihe enag enawa pugu osuiname, sinainime. ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Elimba enaig eseg, aman mungo ehefena lalam wahiagim. Enag ehefena gafungag wanaim elim osonug, ‘Kana gafungagmi, gawigmi fahegegofofum.’ Enaig osonugum mungo mungogum gisfua hwatig gafungagim enam. Mengigwa nunofegohog elim, enam osonag, ‘Numwehenam mengigim fa nangofegofum,’ El Enag enaig osonag. ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Enag negel gimba gwenaig numwehinim nunofifum, amansihe lalana awag wa bof osuwipegnam boime, si olugyi gohognam boime, leawa kwimbiyim boime, leawam boime mas na olningigmo. ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Enaig bogmba yawo yikagnam ehe wa puguf, enag wa nem nangoimba, na non gifuf. ");
INSERT INTO amn_amanab_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Enaig fegmba enag ka nem osonug, enaig fenamba enag ka mungwal elim osonug, ‘Numwehinim nunofifum!’” Sisas enaig osoni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Sambaga osuwu mahiyi gohmba olningigim Pasovami afa bret pupkuog hwanig ahagagim osuwu nuguagim, enanam enag muwagigim, Enginag ainiyag pris i, anuana el i, yisigiagini, “Ahnaig big asinim so Sisasimba big kikeheli sulufinim tigekif? ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Enaig mas big lahlagnam Pasovanamba enanamba mas big esi. El masa wa el bagagif.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Sisas Betaniyi agafena Saimonna lalawa enag el autinam ehehna fena. Enanam enag kukwa aganam wohof onefenamba, angwafig bonam sahona hun keg botol wel fungug lahlagna mengigwa puguag ombuna. Ena wel nog weg wesig bugba fungugni lahlag, enag wunehalamba nalt. Mani naligni fana. Botol enag pugugenam afa wel enag Sisasim mesowa sugfuna. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Mingnag el auguiafena enag olugakagni. Ehefum olugyi sihiage gofofena, “Amang fegim ena welmba yusugmba fatig. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Enaig big mani figbi mani nalig big wafiti. Big enaig wa 300 kina fiti, eso big elim amang hwanigim enam faigoite.” El enag angwafigim nunumufini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Sisas osoni, “Wahiyi! Amang figim, na enag angwafigim kinigbi faiyig? Elimba yuhwahe kam esenag. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Autinai ehe el amang hwanig auguia. Amansi na sawiyi fegim kwaganiegimba, eso kwagan. Enag kamba, ohiyiaga hegeg gwesegim awohmo. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Amang angwafig enag esegmba yuhwaho eseg. Elimba wel lahlag kam eligim sugfunag, kam numwehenageg kumoagaligim gwenaig esifinimbi enag kam wahagim ma sa yikagna nongif. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Yinim newug ehe ka nem osonug. Mungwal bete esel enanayi Godna mo lahlagwa sihiahufuf, enam gamba angwafig esel eseg enamoa sihif, feimba olninguguf.” Sisas enaig sihifena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Enanam enag 12 fenam Sisasna nihiyihai, enag elyinai, mungo Judas Iskariot, enag yikanam enginag ainiyag prisim ona nawo Sisasim faim. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Enginag ainiyag pris enag ena mom higinim enag sifakalni. Enag osoni, “Emba ka nem mani faiyif.” Enag Judas enag mina yisigiagena ogum ahana minawawo amansini pris elim enag Sisasimba ka faiyif? ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Israel el enag mungwaliyi yiawa osum elengegiwa gohog osuwum gishu fwahiyinim. Enag wikwo angig fegim yikagim elngegwa pugug enag mungwal osuinamba bret pupkuog hwanig ahgahufena. Angig enag osuwu enag puguna, enanam enag sipsip luwalig fa kugwagif Pasovawamba. Ehefena nihiyinai enag Sisasim sahini, “Na sawiyifeg ahananayi kahunam Pasovamba numwehiagimbi, eso pasova enag na nef?” ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Sisas sambaga ningigim sihinim, eso ningitigina, “Ne ningigi ahkanam ahsahon kimbig naligyi. El mungowo bu sompni ombofuf enag nem wa minawa wa bof. Eso ne ningigi enag eso elim enag ahpahalukui. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Mayi yikanam ahna lala mungowa sahoimba eso ne ningigi enag lalana awagim enam enaig sihiahfenai, Anuana osog, ‘Kana kukmba ahananayi go? Kawo Pasova enanayi kikefena nihiyinaim wan nem.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Emba wa nem ogofunuf kuk nalig sisiyigam go ati numwehiagigim wahiyig. Ne ningigi wohof enanayi numwehiage ahfe. Enag ehefena nihiyinaim sambaga ningigim ena ningitiginamba, ahkana.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Sambaga ningigi enag ahkanam kimbigwa ahpuguna, enaig sambaga ningigi enag ahwufuana gwenaig eso Sisas osoni enaig. Enag sambaga ningigi Pasova numwehiagahfena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Osuwupegnam Sisas ehefena nihiyinaim mungwaliyi wanbona. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Enanam enag ogunam ahgafenamba Sisas osoni, “Yininewug ehe ka nem osonug. Negelyinai mungo kam elim faiyif enag kam tigekigim, el mungo osohwi kamble i ahneawo enag.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ehefena nihiyinai enag olug wahegasainam, enaig esini, ehefum mungo mungog enag sahugini, “Kamble me?” ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Sisas osoni, “12 feg enanayi el enag yawo mungwa sompyinai ka lifug bug bretna figihiane ahofe. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Elimba yiniho, autinam God osonamba, enag el ginofini, ‘Emba wa Enag El God Ningihiana Of Wanai enam wahaf.’ Afa aman Elim Enam God Ningihiana enam elim mingnag elim faiyimbi, emba kinig nalig ehnangum wa bof. Ma ehefena afag eseite, elim enam fukuag wahiaite, emba sa yuhwafeite.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Enanam mahiyim ahgafafenamba Sisas bret fanam, Godum lahlag moaogonam eso kukwasungofenam ehefena nihiyinaim faini. Enag osoni, “Fi, ohwimba kikefumehe ka nem afai.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Enag wain bug kapna fanam Godum lahlag moaogonam, ehefena nihiyinaim enag faini. Enag ena mungwal enag ahgana. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Enag osoni, “Ohwimba kana taf, elimba enaig esena, taf kifutugum ehe ogfuni, amangim God eseli autinaim sihina yininewug ehe ena wa puguf. Enag tafmba ka sugfunuf elksam kwaganigim God nangum ambogogum. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Yinimewug ehe ka nem osonug, mas ka piskenam ena wain bugmba nei yikanam mulug wainbug ka nef Godna wanagagwa.” Sisas enaig osoni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Enaig esinim, sangig mungo ogonam eso mug Olif gimwo fukwalogonam ahuna. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Sisas enaig osoni, “Negel mungwal ena na wa esif, embem wa nahunam, kam wahiyinim. Autinam God enaig osona, enag, el ginofini; Mayi ka sipsipum nangwagohogum elim enam mayi ka tigekaimba, eso sipsip enag wa gweyi ahkitigiaogof. Enaig autinaim ginof enag osona. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Afa ka wahambwihianam Galiligim ka kaf, negelni gof.” Sisas enaig esoni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita Sisasim osona, “Mingnag elmbi sa nem wahiyi, kamba mas ne wahiai!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Sisas Pitam sihina, “Yinenewug ka nem osonag, yawo ohuna sinainim sambaga mungogum wa na osof, ‘Mas ka Sisasimba anuanafenagmo,’ enaig na osoimba, eso kakaruk awag sambagagim wa moasiawogof.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Afa Pita tifutiagenam osona, “Enaig ka nemble i ahwahagimba, emba kesef, mas ka enaigmba osoi!” Mingnag Sisasna nihiyinai gamba gwenaig osogona. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Sisas ehefena nihiyinaim egam wankanam wan puguna Getsemanigam, enag ehefena nihiyinaim osoni, “Ohiyi auguiafimba, kawo Godum sahnam.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Enag Pita, Jems, Jonnam ena mungo sulufunam wankana. Enag Sisasim oluginig fena, ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","enag ehefena nihiyinaim enag osoni, “Enag olkinig kam ofe enag ohuna kinig naligni gweliehe kam awaha. Ohunanayi auguiafimba nunofifum.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Enaig osonim, afa wesig hilikanam ehefum kanam betewa penam, eso Godum sahana, enaig na yuhwafegmba, ogum ena kinig ohunanam ma kam wahia. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Godum enaig sahnafena, “Humoan, kana awag, nemba yuhwafef mungwal amang esel enag, ka sawiyifeg emba tawetik i, kinig i enag kana nihiyinai hikifati. Enag kana sawiegim nofeka pahalukum! Awai! Nimbefena sawiegim enam pahalukui.” Sisas Godum enaig sahanafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Enag piske kanam nangwagenamba ehefena nihiyinai enag non asagafena. Enag Pitam osona, “Saimon, nonho na gi? Mas na wesigngiwo nofkike auguiamo? ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Negel enag nunofifimbi Godum sahinifi, enaig wa nem amang gihnigim wa bonam puguf. Negelni sungwagwo ogum nawo yuhwa fefum, afa elig ehe kifutieg hwanig feg.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Piskenam ehefena nihiyinaim wasanam yikana Godum piskenam sahanagim, yuwanam eso sahana enaig sahana piskefena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Afa piskenam bonam ehefena nihiyinaim nangwagenamba non asagafena ehelnim nofug kinignewug fesaina. Enag mas olningingimo ahnaig Sisasim asihinif enam? ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Bowalyi enag piskembonam, enag osoni, “Mahiyimho na ehe kukule asaga? Gweli! Ati meini ofe. Nunofi! Yawomba Enag El God Ningihiana Of Wanai, enag el enag elim wa faiyif. El ahnaig ahnaig amtakwalig esehugum enam wa faiyif. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Bigiagafe. Nawo ahum, Nangu! Ati ombo el enag kam mingnag elim faiyigimbi eso kam tigekif, enag ati ombo.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Sisas ehefena nihiyinaim mahiyim sihinugego fenamba, eso yikagnam Judas puguna enag el 12 fenam enagna mungo enag. El kisa numb mungwaliyi enag gweyi ambogona, piso i, aga i wambuginim. Enginag ainiyag pris el, anuana el, ainiyag el, enag el elksam enam ningiyiginimba enag ambogona. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","El enag Sisasim faiyigim elel, enag enaig esena, yuwanam ati enaig osoni, “Elim ena ka afwaf fatimba, elimba Sisas eso negel enag gwenamho kikehelinim, numwehenim nangwagufi.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Enanam enag Judas pugunam Sisasim osona, “Anuana,” esonam eso afwafe fatina. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Enaig fenamba enag el enag Sisasim numwehinim ningagawa kikehelini eso nangwahufena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mungo gofena muhwa enag piso ehefena angagwanai sugufanam eso el mungom angalog hugufatina. Elmbi elimba prisni misog elni gafungag wanaim. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Sisas el esel ambogonam kikehilini enam osoni, “Piso i, afa aga i na wambugigim wambuk ambogog kam sulufigim okwef luwalim lofug enaig. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Mungwaliyi osuwi enag ka Godna lala naligyi big mungwaliyi auguiafenam agofwehefenam ogogum afa ka nem sihinugekafena. Amang fegim enanamba na kam kikeheli hwanigba wahiyini? Afa amang amang mo enag God autinam esogba emba wa puguf.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ehefena nihiyinai mungwal el enag Sisasim wahiyinim embem ahuna. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kwambolo mungo Sisasim pahalu bwafena. Lofug busug mungo kigeugonam enag, mingnag el elim enam kikehelini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Afa enag enaig esena, lofugwo hugufatinam nihig bihig embem yikana. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Enag Sisasim wanigiahuna prisni misog elni lalagam. Ena lala wa enginag ainiyag pris, el sisiyi fesaig enag el, mo anuana el, el enag ambogonam nuwagena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Enanam enag Pita Sisasna sum yikafena sumifena wahegwehe. Ena yikanam sahonam bwag megam prisni misog elni lala muhwa. Enanayi mungwal ami el gi gofwehena. Ami el enag lalam nunofegofohog el. Enag Pita gamba yikanam sahona ena suwa nolokewofena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Enginag ainiyag pris el i mungwal el sisiyifesaig i, enag el mo yisigiagini amang esel Sisas eseg. Enam ogona, “Nawo wufuwinim eso Sisasim tigekim.” Enag mas ahnaig mom wufuinimo. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Elksa Sisasim moakwelini, enag elni mo enag mungwa lofugmo. Awai! Nemona fesaina. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Mingnag el gofwehenam Sisasim enaig moakwelini, ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Enaig ka higini, Sisas ogum, ‘Godna lala nalig enag ka tufatinam enag sambaga mungo osuwunam ka piske nimbanam augif. Elimba ningagana nimbahmo.’” ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Enag ena mo gamba mas mungwa lofug fegmo. Elimba ehfamba mingnag mingnag nemona fesaina. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Prisni misog el enag olugyi gohonam, eso Sisasim sahana, “Na wahigifegim mo sihiagimba na kwisikho ena mo esel nem enaig osonug enamba?” ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Enag Sisaswo mengig kapinifenam gofena, mas amang mo wahigifenam osonimo. Prisni misog el enag piskenam Sisasim sahana, “Bwata nemba Kraisni, eso autinam God osona, ‘Emba ka ningihiaf elim kwaganegim ka nangum asambogogum.’ Enag Godum enag mungwal el lahlag moaogonuf. Nemba Kraisme? Awaime?” Prisni misog el enag Sisasim enaig sahanafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Sisas osona, “Kamba. Emba na wa nanguf El Enag God Ningihiana Of Wanai enag Godna nihigimoa ka agafuf. Godmba tifutuk newug feg. Emba leango i wa piske ahbof ofwanai!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Prisni misog el enag ehefena lofug plefu wahianam enag mingnag elim sahini, “Amang figim big mingnag elimbi wunogonug ma mo ambogonam sihi? ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Sisasna amtakwalig mo ati na higig, osog, ‘Kamba God lofug.’ Negelmbi ahnaig olnignig amang ahnaig big esinif?” Mungwaliyi el enag mungwa mo fini, “Sisas amtakwaleg. Ma Wahai!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Yikanam mingnag el gweyi Sisasim memp kusini. Lofugna nofugum yisiyinim wahiyinim, eso tigini eso enaig osogona, “Nemba profet lofe. Nemba wahigifenam sihi, aman nem tikgeg?” Ami el sulufinim asangigim pepefefini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita ambagam betewa ambwagwa lala mengig muhuwa gofna. Angwafig, prisni misog elni gafungag wanai, bonam. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Enag nangonamba Pita suwa nologewofena, enag angwafig enag numwehenam nangonam enag osona, “Ne gamba Sisas Nasaret wanai nahkafena.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Enaig Pita osona, “Awai! Mas kamba anuanafenagmo! Ahnaig mo elimba nosog?” Pita bwag mengig muhwagam kana. Enanam enag kakaruk awag moasiyina. ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Enag gafungag wanai angwafig enag piskenam nangonam, mingnag elim muhwanaim sihini, “Elimba mungo ehelyinai ehe.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Enag Pita piskenam osona, “Awai!” Wesig gohonam, el Pitana muhwa gofofena, enag piskenam osoni, “Amang fegim enaigmba nosog, ‘Kamba enag elmo!’ Neana wuneg Galilinai elni mo lofug. Ne gamba Galilinai na bok!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pita tifutiagena, “Yininewug ehe ka osog. Ka sawiyifeg ka yinim osogmba eso God ma kam kinig faiyi. Mas ka anuanafegmo elim esel na osogog enamba!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Enag yikagnam kakaruk awag piskenam moasiyina. Pita olningnam oiskenam ena mo Sisas eso sihina enam, “Sambaga mungogum na osof, ‘Mas ka Sisasimba anuanafenagmo!’ Enaig wa na osoimba eso kakaruk awag wa moasiyif sambagagim.” Enag Pita fisgi pena eso ufwena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Leawa kwumbiyim enginig ainiyag pris el, el sisiyifesaig el, el mo anuwana el, Israel kot el anuwana sisiyifesaig el enag el nuwagena. Ona nawo olninguginim gisfu wahiyim ahnaig big asif. Enag el Sisasim wena kikinim eso Pailat nangum ogohuna. Pailatmba kiap lofug Jerusalemoa kimbig nalig agafena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pailat Sisasim sahana, “Nemba Judana kingme? Awaime?” Sisas wahigifenam osona, “Nembe esel ati na gweli osog.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Enginig ainiyag pris enag Sisasim mo ksa sihinageni, ohunaig osogona, “Ahnaig ahnaig amtakwalig enag na esena!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Enag Pailat piskenam Sisasim sahana, “Ati na hegig esel nem sihinig ahnaig ahnaig amtakwalig mo esel enam. Masho na wahigife sihimo?” ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Enag Sisas mas amang mo ga sihinamo. Enaig fenamba, enag Pailat enag olug wahigegena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","7","Enanam enag el mungo kalabusyi gofena wunehalagmba Barabas. Mingnag elngi eseli gafman elngi bagagini. Enag elim enag mingnag elimwo ati kugwagsungofini melni. Mungwal yiawa Pasovanam enag Pailat enag el mungom kalabusyinaim pitigiafatiafena amanim mungwal el enag mayi membifinimbi, eso Pailat enag elim enam pitigifatiafena kalabus lalanai. ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Enanam enag el ambogona Pailatim sahini gwenaig eso esei. ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pailat elim sahini, “Na sawiyifigmbi kawo Judana kingim wahiam ma pugugai?” ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pailat ati olningni enginag ainiyag prisna olningugugum. El Sisasna mom higifini, afa prisni momwo kwisifini, enag pris enag olug kakagini, enaig fenamba enag, pris Sisasim Pailatim faiyini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pris el Ainiyag enag mungwal elim enag sihigoni, ma Pailatim osoni, “Barabasim pitigifati!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pailat piskenam elim enag sahini, “Na sawiyifigbi ahnaig ka esef elim eseli na sefig, ‘Juda elni king?’” ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","El hogonam wune ogona, “Aga kaga tigegwa kukufinim tigeki!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pailat sahini, “Amang fegmba? Amang ahnaig ahnaig amtakwalig asegmba?” Enag hogna newug amtakwale wune nalig ogona, “Aga kaga tigegwa kukufinim tigeki!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pailat enag ona “Kawo elksam enam sawiyi fenim eso ma kam lahlafini.” Enag Pailat Barabasim pitigifatina ma pugugai. Eso Pailat Sisasim ami elim faiyini, ona, “Ma we kigna ma tiginim eso aga kaga tigegwa kukufinim tigeki.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Enag ami el Sisasim wanigiahunam saigona bwag megam gafmanna lala muhwagam. Ami elim enag mingnag ami el wunogoni, “Mungwal, ambogo!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Lofug tafkleg kwinam king oso fa fatif, enaig lofug enag ami el Sisasim fatini. Ami el enag we nasna kugunim Sisasim musowa kikini, busung lofug enaig king elmbi busung lahlag aitiag fafif enag busung lahlag hun mugna. ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Enag mayi ami el enag Sisasim busung lofug fatinim afa busung nasna musowa kikini esinim eso Sisasim mo kiapasefni. Ami el enag moakwalinim Sisasim king lofug lahlag moaogoni, “Ka sawiyifig nembe gwesenam gofum Juda elni king lahlag!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ami el enag Sisasim musowa agana tiginim. Afa memp kusufini. Ami el enag Sisasnayi moakwelinim mongukug kwakwaginim sifakaleni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Sisasim mo kiapasefinim wahiyinim, afa lofug tafkleg kwieg enag hugufinim afa piskenim ehefena lofug enag finim fatini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Minawa ahuanam nangunimbi el mungo bwafena wunehalamba Saimon. Saimon ehefena kimbig wesig Sairinim wahianam pugunim nalig kimbigam akafena. Ami el enag enaig esinifini, Saimonum ogogum, “Sisasna aga kaga tigeg enag faku.” Enaig fenamba enag Saimon fakuna. Saimonmba, enag Aleksander i Rufusni awag. ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ami el enag Sisasim sulufinim kimbigimwo wahiyinim ming betegam ogohuna, ena bete enag wunehalamba Golgota. Enag ena wunehalamba enaig eseg, Musog Kig Bihig Bete. Aman ahnaig ahnaig amtakwalig esegmba enagnagim ena betewamba elim kugwagsungo fegofogog. Enaig fenamba enag el enag ena betem enaig sefifini, Golgota. ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Mingnag el wain bug i mir bug marasin i ehuwahiaginim Sisasim faini. Mir bugmba marasin eseli enaig feg, tawetik wesigim kwegfowag afa ena bug enag Sisas mas nenamo. ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ami el enag aga kaga tigegwa Sisasim nelni kukufeginim. Mungwal eso ami el enag hun hutiatanaigwa ehefngelni wunehalag ginofeginim, eso enaig esini sompyi aitinim eso glenglefini, eso hun mungo amana wunehalana mayi pefenamba, eso enag el enag Sisasna lofug fafena. Gwenaig esinim Sisasna lofug enag mungo mungog enaig wambinim augini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Osuwu fukumbonam olugyi pugunamba (9 klok) enaignam ami el enag Sisasim aga kagag tigegwa kukufini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Enanam enag el enaig ginofifini elim ogofugunugum amang figim tigekig. Sisasimwo enaig ginofini: Judana king. Osogonam eso ginof enag aga kaga tigegwa kahalini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Afa Sisasna muhwawo ming aga kaga tigegwa el elim sambaga kugwagsungo ahfefnam afa okwefna ahwambna, ena sambagam enag mingimwo nihigim kahilini, afa mingimwo sahagam kahilini, aga kaga tigegwa eyi. ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Autinam Baibel osona, enag yawo ati pugug, Baibel enaig osona, “Enag ehim gamba enaig osoni ogonam el amtakwalig ga enaig.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","El enag ambogonam fahufegofofenamba Sisasim kiapase mo sihinahufna. El enag angmow waginim enaig osogona, “Hegefe, ena na osona ‘Emba ka Godna lala nalig bumbuge sungofenam, piskenam sambaga mungo osuwunam nimbaf.’ ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Enag nimbefum nembe kwegfo, nembe aga kaga tigegim wahianam, pe!” Sisasim enaig osoni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mungwal enginag ainiyag pris el afa anuwana el gimba Sisasim enaig mo kiapasefini. El enag ehefum olugyi sihiagahufena, “Mingnag elim mungo kwaganig, afa ehefumwo ahnaig asegim kwegfofehmo? ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Krais enag, Israelna king, ehe ma aga kaga tigegim wahianam pei, nawo oso nangum. Nawo enam nangunim, emba sa big olningi emba Kraisho.” Enag el enaig sihiagahufena. Afa sambaga ningigim esel katigini enag ehe gamba ati amtakwal mingig Sisasim sihinag ahfena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Osuwu muso suflulugnam si mungwal bitem enam kigfihiagenam osuwum mayi hikifwafenamba yika fenam eso 3 klok pugug. ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Osuwu hikifugwa gifinimba eso Sisas tifutinam wunona, “Eloi, Eloi, lama sabaktani?” Ena mo enag bigmba wahigifigim enaig osogof, “Kana God, Kana God, Amang fegim na kam wahiag?” ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Mingnag el muhwa gofwehiafena, enag enam higinim enag osogona, “Higi! Elaijam wunego.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","El mungo kikigini kanam lifug bug nongug ninim embeg efiyimbuna wagyi kikeugunim fifukwalaogonam Sisasim nihini ona, “ma nei.” El enag osona, “Awum, nawo nunofegofofum Elaija wa bonam pitigiafaime? Awaime?” ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Sisas tifutinam hogna wunonam, eso gweyi wahana. ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Enanam enag lofug nalig kinigni kwieg Godna lala naligyi enag eso sisiyi kukweogonam pekanam simewa pugunamba sambaga lofug ahfena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Kepten, el mungo ami elim sisiyi fenig, enag muhwa gofenamba Sisasna wahagim nangwagofena. Enag osona, “Yini newugehe, elmbi elimbi Godna leg!” ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Mingnag angwafig gimba wahigwa gofofenamba wag nunofegofofena. Mingwo Maria Makdala kimbigwa wanai, afa ming Mariawo Jems i Josep i afag (enag Jemsba sumiyinai ming Jems,) afa ming angwafigwo Salome, afa mingnag angwafig gimba apeyena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yuwanam Sisas Provins Galiligim langwa kanamba enanam enag angwafig enag pahalug ahuafenamba Sisasim gafungagim kwegfuni. Mingnag angwafig ksa Sisasim pahalukahuna Jerusalemgam, ena gamba enanayi gofofenamba nunofegofofena. ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Osuwu yikanam pefenamba, Josep kimbig Arimateanai bonam puguna. Josepmba kot anuana el esel enag elyinai mungo. Mungwal kot el olningni Josepmba nininewug el lahlag. Ehe gamba Godna wanagagim nisanawofena. Enag sinimba Sabat osuwu wa puguf, enag yawanamba amang amang numwehiagigim sinigim. Israelna moamba enaig feg ming osunam gamba autinam Sabat elim wahagmba mas li kaga tigegwamba Sabatnamba luwafi. Sabatnamba mungwal Israel el enag ming osuwu pegam autinam Sabatnamba gafungagmba enag wahiyifini yikafenam Sabat osuwupegwa puguafena. Enanam enag Josep mas embefenamo Josep enag yikanam Pailatna nihiyi pugunam eso Pailatim enaig sahana fena, “Kawo Sisasim pitigifakunam hun megam osaigonam fakim.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pailat kukugi fakanam osona, “Kamba kogum ahanana wahahmo?” Pailat el ami elni keptenim wunena, “Sisasimba atiaho wahag?” Kepten enag osona, “Ei, ati wahag.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Pailat enag hignam eso osona Josep ma Sisasna eligim pitigifakwi. ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josep lofug busug lahlag manina fanam eso Sisasim pitigifanam opina, lofug busugni enana saganam, eso hun mimewa kumoahilini. Hun mimemba enamba autinam Josep ehefena gafungag wanai el kunim wahiyini, ena hun megam Sisasna eligim fakinim. Eso hun amta nalig yitiwiti fefug ambogwanam eso hun mengigim kaguwunim wahiyini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria, Makdala kimbig wanai afa ming Maria, Josepna afag, enag sambaga ningigi enag nunof ahfegofena enag ati ahnangona Sisasim esel fakini ena kugum enag. ");
INSERT INTO amn_amanab_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Sabat osuwu mayi kanam awaienamba, enag Maria Makdalanai, afa ming Maria Jemsna afag, afa ming angwafig Salome, enag angwafig enag wel fungugni lahlag ena manina wambuginim. Onanawa ambogonam Sisasna eligim susulenagim. ");
INSERT INTO amn_amanab_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Sabat osuwunam enag siini leawo kwimbiyim enag angwafig enag bigigafenam hun megim nangugum ahuna. ");
INSERT INTO amn_amanab_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Angwafig enag ehefum sihiagahufena, “Aman bigim waganam hun mengigwa kagwog gi, enamba yitifatif?” (Hun enag amta nalig fena.) ");
INSERT INTO amn_amanab_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Eso angwafig enag nunofinimba hun mengigwa kaguonim wahiyini, enag mas gifinimo! Awai! Ati yitifatina! ");
INSERT INTO amn_amanab_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Angwafig enag saigonam hun megam esim ahuna. Nangunimba kwambolo mungo nihigim agafena lofug busug kwieg fatinam. Enag eso angwafig enag kukugiafakafini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Enag kwambolo enag enaig sihifeni, “Negel nogofeika olug wahigim. Ati ka olningig negelmbi Sisas Nasaret wanaim nangugum nambogog, Sisasim osohwi aga kaga tigegwa kukufini enam. Emba ati piske bwihiag, ohunanayimba mas gihmo. Ohuna kugum enam nangu, ohiyi fakini, enag mas gihmo. ");
INSERT INTO amn_amanab_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Negel enag ahunam ehefena nihiyinaim sihigoni, afa Pitam gamba enaig sihifini, Sisasmba neningalni gof ati wa kaf Galiligim. Emba na wa Galiliyi nanguf. Osohwi ati Sisas nem autinam osoni,” kwambolo enag angwafigim enaig sihifeni. ");
INSERT INTO amn_amanab_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Angwafig enag hun menai apekugonam embem yikagna ahuna. Enag eso kiafigig wahegasainam afa olug wahegasaina. Mas amang mo amanim sihinimo. Ahnaig asegmba? Angwafig enag embefini. (Ming el ohuna mo ginofenam augena buk Mak eseli enam enag.) ");
INSERT INTO amn_amanab_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Leawa kwimbiyim Sabat osunam sini enag Sisas piske bwihiana. Enag Maria Makdalanai enagna nofwa yuwanamba puguna. Enag angwafig enag autinam Satanna nihiyinai amtakwalig elngegwa gohona enam Sisas hugufu aitina. ");
INSERT INTO amn_amanab_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","11","Enag el Sisas wan gohonifefena enag el enag Sisasim olninginim wewufewofena. Maria yikanam enam enag sihini, “Sisasmba nofkike eliehe aga, ati ka nangog!” Ehel enag ena mom enam hignim, afa mas olninginimo. ");
INSERT INTO amn_amanab_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Enanam sambaga ningigi Sisasna nihiyinai kimbig naligim ahwahianam eso ahkana. Sisas pugunam wambna aman lofug enaig. ");
INSERT INTO amn_amanab_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Sambaga ningigi enag piskenam ahkanam mingnag elim Sisasna nihiyinaim ahsihini. Afa enag sambaga ningigina mom enam ati higim, afa olningi hwanig. ");
INSERT INTO amn_amanab_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Afa enengem ehefena nihiyinai el oguafenamba ahagafafenamba, enag Sisas pugunam wambnam, eso ehefena nihiyinaim enag wagini. Ehel enag mas olninginimo, enagenagim ehelni olug enag mweteti hun lofug. El esel sihigoni Sisasmba ati piskegam bwihiag, ena mom enag olningi hwanig. Enaig fenamba enag Sisas wagini. ");
INSERT INTO amn_amanab_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Eso Sisas sihini, “Negel ahunam, Godna mo lahlag mungwal betewa el eseli gohka, enag mungwal elim enag enanayi sihigonugahu. ");
INSERT INTO amn_amanab_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Aman olug wahigifenam Godum pahalukwi afa el buwa fati emba sa God sulufanam afa ehefena muhwa hegeg gohogum enam faiyi. Afa aman enaig olug wahigife hwanigmba, emba Godum mas pahalukwi, ahnaig ahnaig amtakwalig ehena nihiyi gwesegim go, enaigmba, eso wa tawetik nalig faf. ");
INSERT INTO amn_amanab_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Aman olningenam oi Godna moamba yinimehe, enaig esenam, Godum sahanaimba, emba sa God tifutuk gafungag ogofunai enaig gafungag enag el bihigmba mas ehe gafungafei, God enag enaig gafungafegim, og eso mingnag el enag olningi Godna moamba yiniho feg. El esel olningig enam kwaganegim eso Satanna nihiyinai amtakwaligim hugufuhianugeg enag nemona mog sihigoni enam enag autinamba mas higifinimo. ");
INSERT INTO amn_amanab_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Enaig sombine ga kikehelinim ningagana afa amang amang wahembug lofug ga enag ahagaimba, emba mas amtakwale sungofei. Emba wa gihna elim ningagana tuhwimba, emba el ena wangnefef.” ");
INSERT INTO amn_amanab_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Sisas Ainiyag enag mo sihinugenam, mayi wahianamba, eso God sulufanam ofgam wanikina, enag Sisas Godna nihigim aga. ");
INSERT INTO amn_amanab_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Sisasna nihiyinai enag ahuaminifegim Godna mo mungwal bete esel enanayi sihiagahug. Ainiyag kwaganig elbi ahnaig ahnaig kifutuk enag ogogfufenig elbi enaigba ahnaig gafungafihmo? Enaig gafungafigmbi emba enaig eseg elim ogfunug Godna moamba yiniho. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kana nilite Tiofilus, kog autunam kaksag el gafa ena moba ginofini mangwal sa kangelnai yi olyi puguna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Afa ena moba patalfunaba ati mingnag el heafna nofna nanguni. Ilawana enaigba pugunaba eba el ati nanguni afa enaig elbi ofenaiba Godna mo gafugafeg el. Asa ena moba kam fiagog. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Afa na sa ka ena moba kog ka kagafa nem ginofe fai. Afa ati ka ena enaigim fahigenagegim afa ka mogim yisigigim afa ka anwenafeg. Asa hwa moba nufuna mo ka nem ginofenag na sa ka nem faig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Afa ka enaigba esegba eba asa ne ena mom suwiginam asa ne numwehe anwenafe asa ati nem ogfunagig eba nufunam ehe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Afa enanam maia Herot Judiana misog el gofnaba afa enanai yi pris mungu gofena. Ehena unehlagba Sekaraia. Eba Abiya wangofnaba ehganai eheba fena. Afa ehena angwagba eba Aron wangofnaba ehganai eheba fena. Ehena unehlagba Elisabet. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Afa eheningi mas mangwal haig haig safena mo eba heafna Godna nofla suialag ahgofenaba afa eba heafna Godna nihe mom mi afa membug mi mungu ahpatal ahfefkufena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Afa eheningi luwal fwainig ati watiau ahfena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Afa mungunagim Sekaraiana ehganai el mungu eba pris Godna kwania lala la enag gafugafe gofena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Enaig gafugagba eba mungu pris Godna kwania lala sefufenam sanda suwi la tulufuiafena. Afa sa mungunagim Sekaraiam sihini og sama enaig gafugafei. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Afa maia ehe lala megam sefukanamba asa kaksag el afwambala afohiafenaba asa Godim betenini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Afa sa Ainiyagna oflanai el blonam Sekaraiana nof la puguna. Afa sa ehe nihiginai ningagam sanda sime la gofena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Afa Sekaraia ehem nangunam sineminefenam afa embefena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Afa sa oflanai el ehem enaig sihifena og, “Sekaraia, nofe ne embefe. God ati neana sahigimba higig. Eba neana angwag Elisabetba fangonai luwal wanigafe asa ne Jonim unehla. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Eba sa ma neana olug suialafenam afa ne sifakalefe afa eba kaksag el sifakalife maia enanam luwal gohiba. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Enaba haig, eba Ainiyag ehem nangunam og sonag elni unehlag eba kwaniafefe. Eba mas mileaklana bu ne. Afa maisim afagna atag la gifinibi eba Godna Sungwabug ehem ihlafenagefe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Eba ehe kaksag elim Israel la naim esenibi asa heafgelni Ainiyag Godna gum waike afufe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Afa eba Elaijana nihe mi afa wasneig mi lamboagegim asa Ainiyagim gosenafe afa sa afahumonigni luwalignam esenibi asa mungu olug pugunifie. Afa el sa mom flafug enam ehengelni onigigim numwehenugeba sa ma suialag onigig flinim afa sa ma afsug el feasai. Afa eba elim numwehenugeba asa el Ainiyag blogim numweheaginim gofufe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Afa Sekaraia oflanai elim enaig sihifena og, “Haisegba asa ka ena moba anwenafefe neana moba nufunam feg? Eba ati kam watiaueg afa kana angwafig gafa gwenaig eseg.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Afa oflanai el wahigi enaig esona og, “Eba kable Gebriel, na kaba Godna nofbusugam fagohfe na sa God ehe kam ningihiagba na ka blog nem sihinagim afa hwa mo suialag ka nem ublu faig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Afa sa ne higim afa ne kana mo onigig fwainigba eba glau neana mo lagigba awai ofe, ne mas mo lagi eba ikan ikan maia enenam mangwal sa mungwali pugufe. Kana hwa moba eba nufunam pugufe enenam sa God wefug fwahag.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Afa el Sekaraiam nengena flafnaba fwinam onigwagia flafna og, mangwal maia fegba nasa maisim Godna lala seifo ga. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Afa sa nengigim pugu afwambagam blonam afa ehe mas ehengelim mo lagini mo. Asa ehengel anwenafinim og, sonaba mangwalim haigim ehe nangug Godna lala megam. Afa ehe ningana mungu ogfunigena afa mengigna sihiagegba awai, ehena mengig ati pwakafena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Afa Sekaraiana gafuga feawagigba ati awaienaba asa ehe pese heafna kembig gam ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Afa sa sumi yi ehena angwag Elisabet afnialigni fena eba ehe meagam sefo gohun ikan afala pugufeg wasifenaba afa sa Elisabet enaig esona ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","og, “Sawou autunam ka afnialigni fwainig fenaba asa kam Ainiyag aflafenagim hwa afwanefimba tigefla fakanag.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Afa maia enwesog la pugufeg wasifenaba Elisabet ati afnialigni fenaba asa God oflanai elim Gebrielim Nasaret kembig gam ningihiana eba Galili provins gam. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Afa ehe ikanam angwafig angwaming gim puguna enag angwafigbi ati Josepim faigim eso fwahini ena elbi King Devit gofenaba ehganaifena. Afa enag angwafig angwamingna unehlagba Maria. Ehe mas saglag i mungwa kife la ahgini mo eba suialag angwafig fena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Afa Gebriel oflanai el enag angwafig enaig esona og, “Angwafig niasabam, Ainiyag ati ne i ahgo asa ma nem fwinam suiala feaflai.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Afa Maria ena mo higinam olug fingifenam afa onigigna og, sonaba haig mo he! ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Afa oflanai el ehem sihina og, “Maria, nofe ne embefe, eba God ati nem fwinam olug suiala fenag. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Sa hig, eba ne afnialigni fenam afa ne fangonai luwal wanigafe, asa ne Sisasim unehla. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Eba saglag el gofe afa sa enaig seflifife og eba Godna leg wasneig nemug. Eba God ehem gafa misog el lasu ofe ehena simbianiga king Devit lofefe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Eba Jekopna simbianigagna misog el wahkig gofife, ehena misog el gafugag mas awaie nai.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Afa Maria oflanai elim enaig sahna fena og, “Enaigba sa haig pugufefe? Kaba mas alagana feg mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Afa oflanai el ehem pese waike sihina og, “Heafa Godna Sungwabug ehe nem blonafe asa Godna wasneig nem ihlafenagba asa ne ena luwalba nengigim wanigafe. Enaba Godna suialag afsug el asa ehem enaig seflififie og Godna Leg. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Sa hig, neana mangaug Elisabet ati watiaueg enaig afnialigni fegba eba fangonai luwal wanigafe. Afa ilawana enaig esogona og eba mas luwalba flai. Afa glawanaba ati afnialigni feg afa ehena enwesog la gohug was ati afunag. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Eba God ehe mungwali mangwalba eseagefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Afa Maria esona og, “Sa hig, kaba Ainiyagna gafugag angwafig asa ati ne esog sa ma gwenaig ese.” Afa sa oflanai el ehem fwaha ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Afa sa gwenenam Maria ikagna distrik Judiana kembig mugam kukana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Afa ikanam Sekaraiana lala megam seifo ikanam Elisabetim suialag ona. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Afa Elisabet Mariana mengig higinam afa sa luwal ehena atag lanai bigmug fiagifni. Afa Godna Sungwabug ati Elisabetim ihlafenagenaba. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Afa ehe fwina enaig esona og, “God ati nem suialag nemug esenagim afa ne mingnag angwafigim gosenig. Afa sona luwal sa neana atag la gibi ehe gafa God suialag nemug ehem faife. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Kaba amban afa kana Ainiyagna afag ka nangum blog? ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Sa hig, maia ena mo neana blog kana angug la pegba asa luwal kana atag lanai sifakalegim afa fapisofeaka. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Sa ne onigim Ainiyagba nem enaig esenafe sa ati nem sihinag eba se nufunam sifakale.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Maria enaig esona og; Kana olug Ainiyagna unehlagim fingi ofe; ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Afa kana sungwabug Godim sifakalenag ehe kam kweagfug afa kam esenagba ka suialag nemug goh. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Kaba ehena gafugag angwafig esug feg afa ehe eba mas kam etetig mo; afa sa ilawo afa nengigim gafa mungwali el enaig esogofe og, God kwania sifakaleg ehem faig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Afa sa wasneig God kam enaig esenagba asa kam suialag pugunag. Asa ma ehena unehlag gwese afsug gofi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Afa el sa ehem ahnai skaufinig enag ehengelim aflafenig. Eba gwenaig esenfie ilawa gafa wahkig gwese gofife. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ehena ninga wasneig gafugafeg, afa el enaig onigig ka kike gosig el feasaig, asa heafgelni unehlam fingifig lambfuia minefig enaig elbi eba ehe amtakwalig aitife. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Afa eba misog elim pigalampife afa unehlag fwainig elim mo fingi lamb fukufe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Afa elim bini pigig eba ehengelim suiala gawig lamboaibi asa ehefba ihla feasaife afa sa gawig kaksagna el feasaig eba mas fai asa ningitigiba esug afufe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Afa autunam bigelni simbianigam God mo sihi fwahani asa ehe heafna gafugag elim Israel lanaim kwaganig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Afa ehe maisim onigig gofena enag ogna Abrahamim aflafenam asa ma enag gwese simbianigam gohon fi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Maria Elisabet i hawagin ikan sambaga mungu was fenaba asa heafna kembig gam pese ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Afa maia enag osuna pugunaba Elisabet fangonai luwal wanigana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Afa sa heafna hihe i afa mungwa kembig lanai i ena mom higinim og Ainiyag ehem fwina aflafenag afa sa ehengel sifakalini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Afa maia gug yi gohug osuna pugunaba asa ehengel ambe ona luwalna nihim kofuni enaigba esenibi eba Ju heafgelni nihe enaig fena. Ehengel ona alagna unehlagim Sekaraiam unehli. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Afa luwalna afag esona og, “Mangofi, nawo Jonim unehli.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Afa ehengel ehem sihini og, “Nengelinai enaig unehlagba goh mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Afa ehengel ninga bulni ogfuiagim afu alagim sahni og, “Ambanim ne luwalba ounehla?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Afa sihini og osum mangwal flibiba kasa enanai yi ginofe afa sa ehe enaig ginofena og, “Ehena unehlagba Jon.” Afa sa ehengel fwina onigwagia flafna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Afa sa Sekaraia pese ikagna mo lagwagenam asa Godna unehlagim fingife fukuna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Afa heafna kembig la nai mungwali enaigim nangunim embefeagini afa ena mo mungwali Judiana mug kembig la sa gohkafna enam ikaminefeni. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Afa mungwali el ena mom higwaginim afa enaig sihiagini og, “Sona luwalba sa sumi yi ba haig el fefe?” Ati anwenafini Ainiyagna wasneigbi ehe ahgofife. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Afa enag luwalna alagim Sekaraiam Godna Sungwabug ati ehem ihlafenagenaba asa enaig mo sihina og; ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Nawo Godna unehlagim fingifi Israelna Ainiyagim ehe blog bigim heafna elim kwaganigim afa bigim pese lambig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Afa wasneig el mungu God Gisfu fwahag asa ehe bigim pese lambfie. Afa sonag elbi eba ehe Devitna simbianiga. Devitba Godna gafugag el. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Asa ati autunam Godna mo fli sihiafule elni mengig la ena moba sihi fwahana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ena moba enaig esona og God bigim kwaganig asa angoluwag el i afa fagiule el i ona bigim haig haig esegon asa ehengel mas bigim enaig esegoni. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Autunam God mo bigelni simbianigam sihi fwahani. Afa enaig esoni og ka nem aflafenig afa kikeafna wasneig mo ka mas onigig etetini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Afa ehe bigelni simbianigam Abrahamim enag nufuna mo sihi fwahanaba. Afa sa glawa gafa ogna bigim gwenaig esen. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Afa ogna bigim angoluwagna ninganai moehnam og sa ma heafna gafugagim kehli afa mas big embefi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Afa big wahkig nofkikena afoamine fifibi afa sa big suialag nihe la afa afsug nihe la Godna nofla eseafufum. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Afa ne kana luwal, afa nengigimba nem enaig sefla fife og sonag elbi eba mo fla sihiaule el God sisia nemug feg. Eba ne Ainiyagim gosenam ehena minam tohlagefe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Afa sa enagba elim ogfufenugeiba sa ma anwenafi ehena kwania aflafeg God sawifegim amtakwalig nihem elni huguflaitinim asa pese lambife. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Afa bigelni Godna aflafenag nengigim nengigim fiahka. Afa enag elbi God Gisfu fwahag elbi eba ofenaiba leana osu bugug lofug. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Eba ehe oflanai pe blonam afa el sa sikulufeg la auguia eba ati muhla pigiegim ofesai asa enam ombusug faifi. Eba ehe enag olug enesieg mina gam ogfunfie. ");
INSERT INTO amn_amanab_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Afa ena luwalba sumi pugu kwaniafenam afa heafna sungwabug gafa pugu wasneife afa sa ehe pugunam bite behig gam ikafe afa sa nengigim mo Israel elim ambala pugunife. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Enenam maia Romna misog el Ogastas unehlag osugonfinibi ehe nihe mo mungwali elim kagahlani. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Enaba ilawana. Misog el Kwirinius Siria provins la gofnaba enenam unehlagba suguni. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Asa mungwali hana hana kembigim fwatiaginim pese heafgelni kembig gam fafufena og sa ma misog el ehengelni unehlag sugoni. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Afa Josepba King Devit gofenaba ehgenaifena asa Nasaret Galilim fwahanam Judiagam Devitna kembig gam Betlehem gam ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Afa nasa Maria i ahkana. Enag angwafigbi autunam ehem esu fwahini. Misog el ogna eheningina unehlag buk la fakan. Enenam Maria ati afnialinifena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Afa gwenanai yi maisim Betlehem la hawag fenaba luwal gohugim ati meifena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Nasa fangonai luwalim fuklana eba angwam luwal afa ehem bulmakauna fane ahgag bokis la fakanam lofugna fwahla fwahana. Enaigba esenaba eba mungwali lala el ati ihlafeagena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Afa ena kembig lanai sipsip nangwaghiawagig el afu kembig ehbegam sinaini sipsipim nangwaghiage afufna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Afa Ainiyagna oflanai el blona ehem puguni. Afa Ainiyagna kwania ombusugni ehe ehengelim molu kugofakaniba afa ehengel fwina embefeagini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Afa sa oflanai el ehengelim enaig esoni og, “Nofe ne embefi. Sa higim ka nem suialag mo ublunig. Ena moba mungwali el sa fwina sifakalife. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Afa hwag osuna Devitna kembig la angwafig mungu luwal fuklag afa ena luwalba mungwali nem pese lambfe. Eba Ainiyag ehe fegim afa el God Gisfu Fwahiag Elim pese hefum lambigim. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Afa sa ne enaig nangufife asa ne anwenafi eba kana mo nufunam feg. Ne nanguiba luwalim lofugna kekenaginim bulmakauni fane ahgag bokis la fati fwahife.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Afa maia oflanai el enaig mo sihi fwahanaba afa sa gwei ikagnam kaksag oflanai el oflanai apaiye ambenam wanig afohiafna ogna Godna unehlagim figifi. Afa sa ehengel enaig esogona og, ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","God sisinai nemugna unehlagim fingifi. Asa ma bitenai el Godna membug la olug enesieg la gohkai. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Afa maia oflanai el ofgam afunaba afa sipsip nangwaghiawagig el hefum sihiawaginim og, “Is ai nawo afu nangui mangwal ehe Betlehem la pugug. Ainiyag sa bigim ena mo sihinig.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Afa asa ehengel ikagna afuna. Afu nangwagnibi Maria i Josep i hawagfnaba afa luwal mo bulmakauni fane ahgag bokis la pegifni. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Afa nangu fwahinim asa moamo sihigoni oflanai el sa luwal mom sihini enam. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Afa mungwali el ena mom higwaginim fwinam onigwagiaflafna. Sipsip nangwaghiawagig el sa esinibi enam. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Afa Maria ena mo mungwali flanam onigig gofna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Afa sipsip nangwaghiawagig el pese afunam Godna unehlagim fingifini. Ehengel Godim sifakalini asa ehe enam mo higini afa nanguni afa oflanai el sa sihinibi enaig ena puguna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Maia gug yi gohug osuna ika awaienaba afag wanigina asa luwalna nihim mo kufunim afa sa Sisasim unehlini enaigba esenibi eba Ju heafgelni nihe enaig feg. Enag unehlagba maisim afagna atag la feafnaba oflanai el ati unehla fwahana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Enaigba pugunaba eba Josep i Maria i ikan Jerusalem la Godna kwania lala pugunam asa ona Ju elni nihem ahpatalku asa afsug ahfefe. Afa luwalim ahwaniblunam asa ona Godim sis tuhulu ahfai. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Enaigba sahfenaba eba autunam God enaig nihem fakani. Ena nihe enaig esona og, “Fangonai luwalim sa afag lasflam wanigag eba sa ma enaig esogoi hwaba Godna.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Afa sa eheningi gafa gwenaig sahfena afa sambaga twafig Godim tuhulu ona ahfai. Enaba Ainiyagna nihe mo ati enaig sihifena og sa ma gamp sambaga me awai was sambaga me sa ma enag tuhulu fai. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Afa enanai yiba Simeon gafena. Enag Jerusalemlanai elbi eba suialag el fenam Godim lotu fenakafnaba afa ehe maisim nengeakafna el sa God Gisfu Fwahag Elim og sa ma Israel elim esenibi sa ma olug enesieg la augui. Afa Godna Sungwabug Simeon nai yi gofenaba. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Afa Godna Sungwabug ehem enaig sihifena og, neba mas ikagnaba lahai eba el sa God elim lambigim Gisfu fwahag enam nangufe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Asa Godna Sungwabug ehem olugim fingifenaba afa sa Godna kwania lala gam ika seifo gafnaba. Asa Sisasna alag i afag i Sisasim ahwanigina ahseaifona enaigba sahfenaba eba ati nihe mo la enaig mo gifini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Afa sa Simeon eheningi muhla pugunam luwalim foaklanam Godna unehlagim fingifukuna og; ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Ainiyag autunam ne kam sihi fwahanaba enaba nufunam pugug. Ilawo kaba neana gafugag el sa ma kam olug enesieg yi lahai. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Ati ka kikeafna nofna nangug mangwal sa ne esegba enaba kangelim lambig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Enaba ne numehiageg ambala fwahag. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Afa enaba afwambagam elim ombusug faig sa ma anwenafi neana sawiegim asa ma Israelna elim unehlag fingifini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Sisasna alag i afag i Simeonna mom ahigina maia enaig sihifeagofe fenaba afa sa eheningi fwina onigwag ahfegofena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Afa Simeon og God nem suialafenifie afa sa Mariam sihina og, “Sa hig, sana luwalba God Gisfu fwahag asa kaksag Israel elim kwaganife afa eba kaksag elim mingnagim mo amtakwalig aitife. Afa maia enaig el Godna onigigim ogfuiba asa kaksag el ehem moalampinagife. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Maia enaig esibi asa ehengelni meaganai onigig ambala puguamine fenugefe. Afa enaig olug kinieg ofenaiba pina neana olugim pifife.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Afa mo fla sihiaule angwafig ehena unehlag Ana enanai yi gofena. Afa ehena alagna unehlagba Fanuel afa Fanuelba Aser gofnaba ehgenai fena. Afa Anaba ati watiauena. Ehena alagag la ganaba ehe krismasba elegeg la gohug enaig fena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Asa gwenai yia la ehena alagagim maia lahanaba asa ehe fwaimu eseakafna. Anaba eba 84 krismas enaig fena. Afa Ana mas Godna kwania lalam fwaha ikana mo eba eheba gwese Godna unehlagim fingi fegufna. Afa ehe fane fwaiyunam afa sinaini i osuna i wahkig Godna kwania lala beten la fawofe gofna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Afa sa enenam ehe blonam luwalna muhla pugunam asa Godna unehlagim fingi fukunam. Afa mungwali elim nenge afo God Jerusalem elim lambife asa enam luwalna mom sihina. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Ehengel enaig gafugag eseaginibi eba Ainiyagna nihe mo ati enaig sihi fe fwahana. Afa sa Josep i Maria i Galili la ika ahpugunam asa heafna kembig Nasaret gam mo pese ahkana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Afa luwalba enaba ati kwania feagenam afa wasneina afa anwenag suialag kaksag lamboagena afa Godna membug ehem gohna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Afa mungwali krismas sa ikafnaba Sisasna alag i afag i Jersusalem gam Pasova buyis la fakafe ahfegofena eba autunam sa God Israelim eseniba asa suialag augufena nasa enag osunam onigifini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Sisas 12 pela krismas fenaba asa Jerusalem gamba wani fafufeafufna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Afa maia enag buyis awai enaba asa Josep i Maria i pese heafna kembig gam ahakofna. Afa Sisasba kwablog ofefnaba enaig Jerusalem kembig gafnaba alag i afag i lasu ahkana mas ehem anwena ahfena mo. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Afa eheningi enaig onigig ahfena og eba mingnag elim atiba patalkig, eheningi ati ahka mungu osuna ahfena. Afa eheningi Sisasna hihem fasahtigi ahfenam. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Afa mas ahnanguna mo asa pese Jerusalem gam ahyisgi ahkana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Eheningi ahyisge gohun ikan sambaga mungu osuna fena. Ahyisge gohun ahnangunaba Godna kwania lala seifo gafna ehe anwena elni mom mi afa misog elni mom mi higwagenam asa fasahtigife hiageaufna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Afa mungwali el ehena mom higinim afa sineminefini ehena anwenagim asa mo mungwag waike sahini ena gafa gwenaig esini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Afa alag i afag i blo ahnangunam olug fwinam fingi ahfenam afa afag esona og, “Luwal mangigim ne enaigba eseg. Eba ne ka mi nimbeafna alag mi olug kinig ne kam faigbi ka nem ahyisge ahblog.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Afa ehe wahigi sihini og, “Neaho kam ahyisge gohug? Enaigba mas ne anwena ahfeg mo, kaba atiasi kikeafna apina lala ga?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Afa eheningi mas ena mogim anwena ahfena mo. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Afa sa Sisas pese patal kana Nasaret kembig gam afu enanai yi apukenam asa ehe wahkig eheningina mungwali mom patalfukuni. Afa ehena afag mo mungwali enaig mom olug onigig la flanam keahlana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Afa Sisas pugu saglag fenam heafna anwenag pugu fwinam suiala feagena. Afa sa God ehem fwina membenagena afa el gafa gwenaig esini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Afa maia 15 yia fenaba Taiberius Rom elni misog el fena. Afa Pontius Pailat eba distrik Judia gavmanna gosig el fena. Enenaba Herot distrik Galilim nangwaghiage gofna afa ehena sumineg Filip mo distrik Ituria mi afa Trakonitis mi enam nangwagehiagena afa Lisanias mo distrik Abilenem nangwagehiagena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Afa Anas i Kaiafas i eba prisni misog el ahgofena. Enenaba Sekaraiana leg Jon bite behig la gafna. Afa God Jonim mo faina. ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Afa sa ma mungwali elim Jordan bu blug muhla gohka enam sihinwageakai afa enaig esona og, “Sa ma olug waikefinim, bu la apaiyeiba afa sa ma God ehengelni amtakwalig nihem huguflaitini.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Afa enaigba pugunaba eba ati mo fla sihiaule el Aisaiana mo buk la gofena. Ena mo enaig esona og; El mungu bite behig la mo sihiakafe afa ehe enaig esofe og, ‘Ainiyagna mina ombusiaginim numwehiagi.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Afa mungwali mog tutohiageakaiba sa ma tafafiakai sa ma kombugu fegim fuku gwenaig eseg. Afa mina kiapesegim sa ma misosuf gi afa mina mas suialafeg mo sa ma numwehiafli. ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Afa bitenai el mungwali sa ma Godna gafugagim nangunim asa ehe bigim lambigim eseg. ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Afa asa kaksag el Jon nangum flaubluna bula apaiyegim afa Jon enaig sihifeni og, “Nengel giheana luwalig, God sa ma nem susug fai afa amban nem sihinigbi sa ne embemba afufe? ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Afa atiaba ne nufunam olug waikefigbi eba sa ma nimbeafgelni nihem ogfui eba ati ne nufunam olug waikefig. Nofeka nimbefum esogo, ‘Abraham eba kangelni simbianiga.’ Ka nem sihinig eba God ehe hwa funim eseiba asa Abrahamna simbianiga apuke afohiefe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Afa mal ati li mog la gi afa mungwali li sa suialag fug leg fwainigba, eba malna higfihinim suwi la laitife.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Afa el Jonna mom higinim afa esogona og, “Haig sa ka esife?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Afa ehe wahigi sihini og, “El sa sambaga lofugna fefe asa ma ming mo amban sa lofug fwainig feg sa ma enam fai. Afa amban sa fane fwainig feg ena gafa sa ma gwenaig esenai.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Afa mingnag kig lambiule el ambe bula apaiyofefnaba Jonim sahni og, “Tisa, haig sa ka esife?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Afa ehe wahigi sihini og, “Kig sa ne lambigbi asa ne gavmanna moaihla lambifum nofene gwesim hilifi.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Afa ami gafa ambe ehem sahni og, “Ka gafa haig sa ka esife?” Afa ehe sihini og, “Nofeka mingnag elim amtakwal hiaginim kig lambigoni, afa sa nofeka mingnagim muni gofegon sa ne nimbeafna kigim oniginim asa ne gwenaig ihla eseafufum.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Afa el enaigim nangunim olug fingi feskofenam afa enaig onigini og eba hwa Jon me awai God Gisfu Fwahag el me. ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Afa Jon pese wahigi sihini og, “Kaba buna nem esenig, afa el sa sumi yi oblo ena elbi eba wasneigni feg ehena wasneig kana wasneigim kwegfug gwesim ikag, kaba mangwal suialag el mo na ka ehena mong lofug weba pigina. Eba ehe nem Godna Sungwabugni afa suwina asa nem bula laitife. ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Eba ehe savol ningana flanam asa blofe afa ehe blonam fungisge mo wit yi nai lambuhiagenam asa wit mo lambinam heafna wit lala skofe afa fungisge mo lambinam suwi wahkig lagig yi wehlafe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jon maia ena mo sihinaba afa ena mo elni olugim fwaki lasana. Ehe elim Godna suialag mo sihinwageg gafugafena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Afa maia Herot heafna suminegna angwagim Herodiasim fapugufe nagohun asa flana afa haig haig nihem gafa gwenaig eseagena nasa Jon ehem fenagena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Afa sa ena nangum Herot Jonim kalabus lala fla fati fwahana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Afa Jon maisim kalabus seg fwainig fiafnaba afa mungwali el bula apaiyena afa Sisas gafa gwenaig esena bula pena. Afa bula penam pugu betene gofenaba afa sa of bafona. ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Afa maia of bafo gofnaba Godna Sungwabug gamp lofug Sisas nangum pe blonam afa higfufnaba Godna mengig heven la enaig lagofna og, “Ne kana leg, ka nem fwina membenag, afa kana olug nem suialafenag.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Afa sa Sisas gafugafena enag ehena krismasba 30 enaig la fena. Afa el enaig onigini og eba Josepna leg, afa Josepba Helina leg, ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","afa Heliba Matatna leg, afa Matatba Livaina leg, afa Livaiba Melkini leg, afa Melkibi Janaina leg, afa Janaiba Josepna leg, ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","afa Josepba Matatiasna leg, afa Matatiasba Amosna leg, afa Amosba Nahumni leg, afa Nahumbi Eslina leg, afa Esliba Nagaini leg, ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","afa Nagaibi Matna leg, afa Matba Matatiasna leg, afa Matatiasba Semenna leg, afa Semenba Josekna leg, afa Josekba Jodana leg, ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","afa Jodaba Joananna leg, afa Joananba Resana leg, afa Resaba Serubabelna leg, afa Serubabelba Sealtielna leg, afa Sealtielba Nerina leg, ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","afa Neribi Melkini leg, afa Melkibi Adini leg, afa Adibi Kosamna leg, afa Kosamba Elmadamna leg, afa Elmadamba Erni leg, ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","afa Erbi Josuana leg, afa Josuaba Elieserna leg, afa Elieserba Jorimna leg, afa Jorimba Matatna leg, afa Matatba Livaina leg, ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","afa Livaiba Simeonna leg, afa Simeonba Judana leg, afa Judaba Josepna leg, afa Josepba Jonamna leg, afa Jonamba Eliakimni leg, ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","afa Eliakimbi Meleana leg, afa Meleaba Menana leg, afa Menaba Matatana leg, afa Matataba Natanna leg, afa Natanba Devitna leg, ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","afa Devitba Jesini leg, afa Jesibi Obetna leg, afa Obetba Boasna leg, afa Boasba Salmonna leg, afa Salmonba Nasonna leg, ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","afa Nasonba Aminadapna leg, afa Aminadapba Atminna leg, afa Atminba Arnina leg, afa Arniba Hesronna leg, afa Hesronba Peresna leg, afa Peresba Judana leg, ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","afa Judaba Jekopna leg, afa Jekopba Aisakna leg, afa Aisakba Abrahamna leg, afa Abrahamba Terana leg, afa Teraba Nahorna leg, ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","afa Nahorba Serukna leg, afa Serukba Reuni leg, afa Reubi Pelekna leg, afa Pelekba Eberna leg, afa Eberba Selana leg, ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","afa Selaba Kainanna leg, afa Kainanba Arpaksatna leg, afa Arpaksatba Siemna leg, afa Siemba Noana leg, afa Noaba Lamekna leg, ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","afa Lamekba Metuselana leg, afa Metuselaba Enokna leg, afa Enokba Jaretna leg, afa Jaretba Mahalalelna leg, afa Mahalalelba Kenanna leg, ");
INSERT INTO amn_amanab_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","afa Kenanba Enosna leg, afa Enosba Setna leg, afa Setba Adamna leg, afa Adamba Godna leg. ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Afa maia Godna Sungwagbug Sisasim ihlafenagenaba asa Sisas Jordan bum fwahanam asa el fwainig gam ikana. Eba Godna Sungwabug ehe wanikina. ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Afa Sisas enanai yi ika ganaba eba fane neg fwainig ikan 40 osuna fena afa maia enaig osuna awaienaba ehem bini fwina lahana afa sa Satan ehem yuhna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Afa ehe Sisasim enaig esona og, “Afa ne Godna leg fegba sane hwa funim esoiba sa ma amba lofei.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Afa Sisas esona og, “Godna moba enaig esog, Afa faneba mungu mas elim nofkenagag fai.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Afa maia Sisas enaig sihifenaba afa sa Satan ehem suluflanam mug gam fuku wanikina ena mugba mungwanam fena. Enanai yi ehe mungwali bite i afa suialag gawig i enam ikagna ogfunagena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Afa sa Sisasim sihina og, “Ma ne kam mong kokini kwakwagenam kana unehlagim fingifeiba, eba ka sa nem bite i gawig i mungwali faiba sa ne enam mungwali nangwaghagefe, enaba kana feg. Afa ambanim ka membenagba eba ka sa ehem faife. ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ma ne kam mong kokini kwakwagena enaig eseiba eba ka sa nem fai.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Afa Sisas wahigi sihina og, “Godna mo ati enaig sihifeg, Sa ne Godim ahnai skau fena eba naho neana Ainiyag asa ne ehem mungu lotu fena!” ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Afa ena mug ahfwahanam pe Jerusalem gam ahkanam enanai yi Godna kwania lala wofugug sisi yi nemug la Sisasim lasunam afa sihina og, “Ne Godna leg fegba asa ne puso pekai. ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Eba ati Godna mo sihig; Eba heafna oflanai elim sihinibi asa ambe nem ningana kehli apaiyeufufe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Afa fun sig mas nem mong yi pifi eba ehe ati nem numwehefu.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Afa Sisas wahigi sihina og, “Godna mo enaig sihifeg, Nofene Godna wasneigim yuhna nembiafna Ainiyagimba.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Afa Satan Sisasim haig haigim yuhnagegim fwaha ikagim mwakwalig nengego. ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Afa Sisas pese distrik Galili gam Godna Sungwabugni wasneig yi ikana. Afa sa Sisasna mom mungwali kembig sihiageafuna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Afa ehe Ju elni laskuhlag lala ika seifufnam asa mungwali elim enanai yi ogfufenugeafnaba asa mungwali el ehem suialagoni. ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Afa Sisas Nasaret kembig gam ika puguna. Afa Nasaretba enaba ehe enanai yi muhna fena. Afa maia laskuhlag osuna pugunaba Sisas ika ehengelni laskuhlag lala seifo gofnaba. Afa ehe buhia gohnam asa ogna Godna mom suwigim. ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Afa sa mo fla sihiaule Asaiana ginof flinim ehem fainiba asa bafonam suwigina. Ena moba enaig esona og; ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ainiyagna Sungwabug kam blonag, afa wegig fwahagba asa ka ehena suialag mo esug elim fla blunig. Enag ehe kam ningihiagba na koka kalabusinai elim mo sihinibi asa ma enanai yi fwahinim apuke esug afui. Afa koka ikanam nof tetini elim sihigonibi asa ma nofug bahia skofei ehe kam ningihiagba enag ka blo koka elni kinigim flafatini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Ehe kam ningihiag kam og asa ma enaig sihifei og, Ainiyagna osuna ati pugug, og na heafna elim esinibi asa ma suialag augufei. ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Sisas Godna moamo suwigi pe fwahanam pese buk mo pwakafenam elim fainim asa ehe mo ika peganam afa mungwali el laskuhlag lalanai Sisasim mungu nofna nangu flafna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Afa Sisas enaig sihifeni og, “Sona mo Godna buk la nai sa ne ati higig, glauwaba eba nufunam pugug.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Afa ehengel ehem suialagonim afa fwinam onigwagea flafna asa ehe suialag mo sihinibi enam afa ehengel esogona og, “Ati big anwenafig sona elbi Josepna leg ehe, haisegba sa enaig moba ihla sihig?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Afa Sisas ehengelim enaig sihifeni og, “Atiaho ne sona moba flig asa ne kam sehifie ena mo enaig esog, ‘Dokta sa ma heafna eligim eseiba sa ma suialafei.’ Afa ne esogog, ati kam moaba higig mangwal sa ne Kaperneam la ne eseg. Afa glawo hwa nai yi gafa ne gwenaig esig.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Afa Sisas sihini og, “Nufunam ka nem sihinig, Godna mo fla sihiaule elni kembig lanai ehengel mas ehena mom higi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Afa ka nem nufuna mo sihinig, ilawana sa Elaija gofnaba enenaba osu kig gohna ikan ikan sambaga mungu yia fena afa ika enwesog la gohug was fena. Osuba gohnaba asa ehengelni mungwali bite bini kwania puguni afa enenaba Israel lanai angwafig kaksag ehengelni aligabugug ati pigie skofenaba. ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Asa God mango Elaijaba Israel angwafigim ningihinig mo eba heafa Sarefatim Saidon kembig muhla naim ningihianig. Afa ehe angoluwag angwafigim aligag ati lahanag enam ningihianag. ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Afa enena Elaija gofnaba enenaba Israel el kaksag enehna feasaina afa mas ambanim mo ena gihba wangene fena mo awai afa eba Naman ehe afwambanai el Sirianai mungu he enaigba fena.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Afa lasukuhlag lalanai el mungwali yi ena mom higinim afa fwina olug kakage skofena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Afa sa Sisasim kembig ehbegam fli ningihini. Ehengelni kembigba mug la gifni afa sa ehem mugam wanig afuna ogna plau fati. ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Afa sa ehe ehengelim olyinai fwatinam pugu ika kana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Sisas Kaperneam gam pekanam distrik Galili la gafna. Enanai yi laskuhlag gohug osuna wahkig feafufna enaba seflig de Sabat afa sa Sisas enanai elim ogfufenugena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Afa ehengel ehena mom higinim olug fingife skofena ofenaiba saglag anwenag el ogfufenig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Afa enanai el mungu blo laskuhlag lala gafna ena elbi mwaifig amtakwalig simbagahlaule enag fwina enaig esona og, ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Hei, Sisas Nasaret lanai ne blog haig kam ona esen? Enaigba kam si noka amtanafe klaiti? Ati ka anwenafig neba afsug el Godna ne blog.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Afa Sisas ehem fenamine fenam afa esona og, “Mwalfwai lifefunam sana elim fwahanam ika.” Asa mwaifig amtakwalig elni nihinai hugofu akofenaba el mo bite la elni usmuiag la pena afa mas elbi enaba amtakwaligna mo. ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Afa mungwali el enam nangunim embefeaginim afa hefum sihiagini og, “Hai, sonaba haig mo maia ofenaiba anwena el wasneig nifeg nasa mwaifig amtakwaligim esonagba afa sa elni nihinai hugofug ikag.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Afa sa ehengel mo mungwali kembig sihiageafuna Sisas sa elim esenaba enam. ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Afa Sisas ena laskuhlag lala mo fwahanam pugu ikanam Saimonna lala seifu kana. Afa ena lalaba Saimonna kowag gihna gifni ehena elig fwinam nolugeagenaba asa ehengel Sisasim sihini og sa ma ehem kweagfui. ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Afa sa Sisas ika ehem muhla kuhlanam asa gihim wasneig mona esonaba afa sa gih angwafigni nihinai hugofu kanaba asa enag angwafigbi ikagna buihiana ika fane ehengelim tulfuni. ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Afa maia osu penaba enaigna el heafgelni hihem gihna wanambena Sisas nangum. Afa sa Sisas mungu mungugim ningana tuhunwagenaba asa mungwali ehengelni gih wagine feasaina. ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Afa Sisas mingnag elim mwaifig simbagahlaulem gwenaig esenibi asa mwaifig ehengelni nihinai hugofuhia afuaminefeni afa mwaifig elni nihinai hugofuhia afuamine ofefnaba ehengel enaig esogona og, “Ne Godna Leg!” Afa Sisas ninimuhiagenam afa kweni og, nofeka moaba lagim afa ehengel ati anwenafini sona elbi God Gisfu Fwahag el. ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Sisas leana gubi yi ena kembig fwahanam el fwainig gam ikana. Afa el yisigiafunam nangunim kwini og, ese masa ehengelim lasani ikafe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Afa Sisas enaig sihifeni og, “Kaba kawo Godnabog meg mom mingnag kembig la gafa sihiage. God kam ningihiagba enag ka blog koka enaig gafugafe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Afa Sisas distrik Judiam ikanam laskuhlag lala seifo mo sihiwagena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Afa maia Sisas ika Genesaret bu blug yi gofnaba afa kaksag el ehem nangum ambe ona Godna mom higim afa sa ambenam ehem muhla waki fakanam kikigenagini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Afa Sisas sambaganigi botim bu blug yi nangwagnaba el sawagim kikiageafuhun fwahinim fufwalam bu la gigeage afufna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Afa sa Sisas ika fuku Saimonna bot la peganam Saimonim sihina og, aublo seifu peganam botim susum plau plau fefkuiba sa ma hwa nai yi weti fwaha ikai. Afa Sisas bot la gafnaba elim ogfuwagenam. ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Afa sa Saimonim sihina og, “Gwesim ma bot mo ikai asa ne i nimbiafna hihe i fufwala mo ahfatinam sawag ahlambigim.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Afa Saimon esona og, “Ainiyag ati kaba sinaini yisigeafuhug ehegepusig si huguka skofig mas ka sawagba fufwalanaba lambig mo, eba ati ne esog eba ka esife.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Asa gwenaig esini maia fufwala fatinibi sawag fufwala mengig la puguna ona fufwala kwagfo. ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Asa eheningi ming el sambagam ningafuei ahfeni og sa ma kam kwaganig. Asa eheningi ming bot ahblunam ahkwaganaba asa sawag mo fufwalana flinim asa sambaga bot la kokofeawagniba memtog la puguiag ahfen. Afa sambaga bot enag kinig ogna bu megam pe ahka. ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Afa sa Saimon Pita Sisasna kig muhla kwakwage penam og, “Ainiyag ika kaba mangwal suialag el mo, kaba el amtakwalig.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Enaigba esonaba eba mungwali sawag sa lambini enam nangunam sineminefena afa ehena hihe gafa gwenaig esini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Afa Saimonna hihe Jems i Jon i Sebedini legningig gafa gwenaig ahfena. Afa Sisas Saimonim sihina og, “Nofe ne embefe, gla ne sawag lambig afa nengigim ne gwenaig esefe elim gafa ne kam nangum wanblofe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Afa sa ehengel afu bot mo folfunim afa heafgelni mungwali gawig mo fwatinim afa sa Sisasim patalfuna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Afa ehe ika mungu kembig la gafnaba afa el mungu enanai yi enehna blo Sisasim nangunam asa mong kokini kwakwagenam nofbosug mo bite gam fiahsah penam Sisasim enaig sihifena og, “Ainiyag atiaba ne membegba eba sa ne kam suiala fefati.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Afa Sisas ningana tuhugufnaba esona, “Ei, ka membeg, nem sa ma suialafei.” Maia Sisas enaig esonaba asa enag enehba gwei ikagna awaienaba asa elbi enaba suialafena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Afa sa Sisas ehem wasneig mo faina og, “Nofe ne ena moba elim sihin, magofi eba esug ikanam prisim nimbeafena eligim ogfunim afa sa Godim sis tuhlu fai enaigba ati autunam Mosesna mo sihi fwahana asa ma el anwenafi ena gih ati suialafeg.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Afa sa Sisas elim ese fatinaba ena mo gwesim mungwanam el kembig ikaminefenaba asa higinim ambefena afa ambe mo higifni afa gihnam wangene feitifeafna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Enaig eseitife fwahanam afa sa elim mo lasanfna betenegim el fwainigam ikafnam beteneafna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Afa enenam Sisas elim mo sihinwageafnaba afa elim gihnam wangene feitifeafna. Enag elbi Farisi el i afa nihe mo anwenag el i enag Jerusalem kembig afa distrik Galili kembig afa Judia enanai ambe minefe gohkafnaba. Asa Godna wasneig Sisas i ahgohfnaba asa gih elim wangene feitifena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Afa mingnag el ming elim ninga mog lihlignam isgof bog la fli ubina ogna Sisas nangum lala megam saiye ufu. ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Afa maia el mungwali kimihli fakanaba gihwaginim. Asa lala wofusgim fukwali ufunam enanai yi lala wofusim tofunim afa sa elim mo isgof bogna weana kihlinim asa Sisas gofnaba ena mina fatini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Afa Sisas ehengelni olug onigigim anwenafenim asa enaig esona og, “Hihe, ati ka neana amtakwalig niheaba flafatinag.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Afa nihe mo anwena el i afa Farisi el i ena mom higinim fwina lagni og, “Sona elbi ogna Godna kufeg la gohnam asa enaig esefim. Afa mas el behigba enaigba esi eba heafa Godna gafugag mungu he.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Afa Sisas ehengelni onigigim anwenafenim wahigi enaig sihifeni og, “Nengel ne haig haig onigig nafeasaieg? ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Afa ka enaig sihifeba, ‘ati ka neana amtakwalig moba flafatinag’, asa mas ne enam anwenafe nufuna me awai awai me. Afa ka enaig sihifeba, ‘buihia kife flanam ika’, asa ne enam ati anwenafe nufuna feg me awai awai me. ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Afa kog sa ne anwenafi kaba Nufunam El wasneig hwa bite la ihlafeg amtakwalig nihem flafatiagimba.” Afa Sisas ninga mong lihlig elim nofna nangunam enaig esona og, “Ka nem sihinag buihia nimbeafna kife flanam lala gam ika!” ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Asa ena elbi ikagna buihianam mungwali elni nofla asa Godna unehlagim fingi fukunam sa heafna lala ga mo ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Afa mungwali el Godna kwania wasneigim nangunim afa embefeaginim asa Godna unehlagim fingi finim afa sa enaig esogona og, “Ilawaho enaigba puguba big nangug.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Afa sa sumi yi Sisas ikan nangunaba el kig lambiule seifo kig lambig lala gafna. Ehena unehlagba Livai. Sisas ehem unenam og, “Aublo kam patal blu.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Afa sa Livai heafna mungwali gawig mo fwatiagenam asa pugu Sisasim patalfukuna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Afa Livai ikanam Sisasim heafna lala buyisenaba. Asa kig lambiule el i afa mingnag amtakwalig el i fini enag mungwali ahgaflafnaba. ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Afa Farisi el i afa nihemo anwena el i enag fwinam lagnim Sisasna patalfuiag elim sihinigoni og, “Mangigim ne kig lambiule el mi afa amtakwalig el miba wanahgag?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Afa Sisas wahigi sihini og, “El sa gih fwainig feg eba mas ika doktaba nangui, afa el sa gihna feg ena mungu he eba sa ika doktaba nangui. ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Afa gwenaig ehe ka gafa ka mango blog suialag elim mungu sulfuah mo, amo eba kog kawo amtakwalig elim gafa sulfu.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Afa el Sisasim enaig sahna fini og, “Afa Jonna patalfuiag el wahkig enaig esig, fane mo kwegwagigim asa beten mo fig. Afa Farisini patalfuiag el gafa gwenaig esig. Afa neana patalfuiag el mo eba fane i bu i ahgagig.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Afa sa Sisas sihini og, “Eba el sa enaig sifafefe angwafigbi flagim asa buyis segim afa heafna hihem wanahgagim. Asa enenamba ehengelim mas fane kweni. ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Afa maia angoluwag el ambe angwafig flag elim wanigiafugba asa ehena hihe fane kwegig.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Afa Sisas lasug mo enaig sihifena og, “Eba fiteg lofug enaba ati kofo gohugba mas el enaba glaunai lofugim koflanam asa kofwagim kagunam asa kweli. Enaigba eseiba eba glaunaim amtakwalefe. Mango mungwa lofug mo. ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Afa mas el glaunai wain bugba flanam autunai meme lofug laba sugfoi eba enag meme lofug kofunam asa wain bug bite la sugfofe ena meme lofugba eba amtakwalefe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Afa el sa ma enaig ese ena wain bug glaunai sa ma flanam glaunai meme lofug la sugfui. ");
INSERT INTO amn_amanab_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Afa el sa autunai wain bug negim afa glaunai wain bug mo oksigim afa og autunai wain bugba suialafeg.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Afa enenam maia laskuhlag osuna pugunaba, Sisas heafna patalfuiag elim wanka wit aso la wanseifo wanikafnaba. Afa ehena patalfuiag el mo wit fug pwatinim ningana sunpaniaginim maia alifieg mo hugfuhia afunaba asa ahgana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Afa Farisi el enam nangunim afa esogona og, “Sonaigba mas suialafeg mo enaig osunaba mas esi. Eba Mosesna nihe mo enaig esog nofeka enaig osunaba gafugafi. Haig esegba sa ne enaigba esig?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Afa Sisas wahigi enaig sihifeni og, “Masi ne Devitna moaba suwigi mo? Devit sa enaig esena, enenam ehem afa heafna hihe fena asa ehengelim bini pigina. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Afa sa Devit ika Godna lala seifonam amba Godim mwalo fakini enag fla nenam heafna hihem fainibi asa ehengel ahgana. Afa mas sona lalanaiba muni elbi ahgai eba heafa pris mungu he sa ena lalanaiba ahgai.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Afa Sisas sumi yi mo ehengelim sihini og, “Kaba Nufunam El laskuhlag osunaba alag feg.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Afa maia ming laskuhlag osuna pugunaba Sisas ika laskuhlag lala seifonam elim mo sihiwagena. Enanai yiba afa el nihiginai ninga lihligna gafna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Afa nihe mo anwena el i afa Farisi el i enanai yi auguiafnaba Sisasim nofna nangu flafena og ma atiaba ena elim enaig osuna suialafe afatifiba awai awai me afa og nasa ehena minam fahigenaginim asa ehem sehini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Afa Sisas ati ehengelni onigigim anwenafenim afa sa ninga lihligna elim sihina og, “Sa buihiana hwa nai yi olyi blo gohum.” Afa sa enag el buihianam gohna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Afa Sisas sihini og, “Ka nem ahsahtigi bigelni nihe moba haig feg, enaig osunaba sa big suiala nihe fig me awai big amtakwalig nihe fig me? Afa enaigba big elim kwaganig me, awai big amtanafegonig me?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Afa Sisas mungwali elim nofna fahigiagenam ninga lihlig elim sihina og, “Nimbeafna ninga fla susnifeafo.” Afa sa enag el maia gwenaig esenaba asa ehena ninga pese suialafena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Afa nihe mo anwena el i afa Farisi el i fwina olug kakageaginim hefum sihiagini og, “Haig sa big Sisasimba esinife?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Afa sa Sisas enenam betenegim mugam fukukana enanai yi Godim sinaini beteneawan ikan ikan si ambafena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Afa maia osu ati opugufenaba enaigna ogna heafna patalfuiag elim awamoni maia ambenaba asa 12 pela el mo kwefi fwatinam asa ehengelim Aposel unehlag fwatina. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Afa enag 12 pela elni unehlagba eba Saimon ming unehlag Pita, afa ehena sumineg Andru afa Jems, afa Jon, Filip, Bartolomyu, ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","afa Matyu, Tomas, Jems Alfiusna leg, afa Saimon seflig Selot, ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","afa Judas Jemsna leg, afa ming Judas Iskariotna leg sona elbi angoluwag elim mwauni. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Afa Sisas mugim wanfwahanam bite tafagam pe wankana. Afa enanai yiba kaksag el laskuhlana distrik Judia kembig lanai afa Jerusalem lanai afa gwenanai bu blug yi nai kembig Tair i afa Saidon i enag ambe gohkafna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ogna Sisasna mo higifibi afa ehem og ma kam gihnam suiala feitifei asa Sisas mwaifig simbahlaulem elim suiala feitifena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Afa mungwali el enaig esini ogna Sisasna eligim ningana tuhufibi asa ma ehena wasneig pugunam mungwali gihim plau fatini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Sisas patalfuiag elim nofna fahigihiagenam enaig sihifeni og; Ambangel asa enaig onigife, kaba suialag el mo God sa kam kweagfui, afa enag el sa ma sifakalifi afa sa ma Godna bog megba saiyefoi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Afa nengel sa ilawo nem bini pigi sa ne sifakali eba ne ihlafifie. Afa nengel sa ne wewatini auguia eba se sifakali nengigimba eba ne titigena auguiafufe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Afa nengel sa ne Nufunam El patalfuiaba eba ming el nem olug kakagegonife afa nem amtakwalig mo faigonam, afa nem mas fatigonifie afa nem sihigonfie og sona el eba amtakwalig, ma nem enaigba esegonibi eba se sifakali. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Afa ma atiaba amtakwalig nihena nem esofegonfibi eba sa ne sifakalinim afa fwinam afigigi. Sa hig, kwania mungwag nem faifi eba heven la nem nengeniawo. Afa autunam ehengelni simbianiga Godna mo fli sihigulem elim gwenaig esegoni. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Afa nengel wag nubni el, niasabanig, eba ati ne bitenai mungwag flig afa mas ne mingba fli. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Afa el sa ne fane ahgagigbi nem ihla feskofeg, niasabam, enaba numwehifibi nengigimba bini nem pigife. Afa el sa ne titigena auguia, niasabanig nengigimba eba ne wewatini auguiafufe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Afa niasabanig mungwali el sa nengelni unehlam fingifegonig eba sa numwehifibi autunam ehengelni simbianiga enaig niheba fini mwakwal mo fli sihiafule elim gwenaigba esegoni. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Afa Sisas enaig esona og, “Sa hig, sa ne enaig esi, angoluwag elim membegonim afa el nem olug kakagenug asa ehem suiala fehiagi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Afa sa mingnag el enaig esogofe og, God sa ma nem nugwakale klaiti afa neau sa ne ehem suialag mo fai. Afa amban nem sa amtakwalig hiagig asa ne Godim betenenibi sa ma God ehengelim aflafenim afa olug enesieg fai. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Afa amban sa nem angmug la poufe afa sa ne ming angmug nehna afa amban sa neana nihinai lofug huguaflanafe eba sa ne ming lofug gafa fwahana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Afa el sa mungwali nem sahigonife og kam osum mangwal fai afa sa ne faim. Afa sa amban neana mangwal flanafe nofene sihina og sa ma kana pese fai. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Afa haig haig nihe sa ne membig ne og sa ma kam esegoni, eba sa ne mingnag elim gwenaig esegon. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Afa el nem membegonigba afa ne enaig elim mungu membegonig, enag niheba eba esug feg. Afa amtakwalig nihenai el gafa og el kam membegonig ka ehem gwenaig esegonig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Afa el nem suialafe hiagigbi afa ne enaig elim mungu suialafe hiagig, enag niheba eba esug feg. Afa amtakwalig nihenai el gafa gwenaig nihe fig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Afa elim sa ne esmunagim faigogba afa ne og sa ma kam mungwag faigoi, enag niheba eba esug feg. Afa amtakwalig nihenai el gafa gwenaig minafig. Ehengel enaig esig og sa ma kam mungwag faigoi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Afa ka nem sihinig sa ne angoluwag elim membegonim afa suialafe hiagi. Afa enaig elim esmunagim faigonam afa nofene enam mungwag nem faigogim onigim. Afa ne enaig esigba, eba kwania mungwag nem faifi, afa eba ne Godna luwalig feasaife. Afa Godba, el sa ehem mas fatinag ena mi afa amtakwalig nihenai el mi enam gafa suialafenig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Afa sa ne elim aflafegon hosa ati nengelni alag heven lanai gwenaig eseg elim aflafenig.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Afa Sisas enaig sihifeni og, “Nofe ne elni nihem fahigenaginim afa sa elim amtakwalig mo faigo, mangofi, masa God nem mungwag gwenaig esenfe. Afa nofe ne elni nihem pigaupui eba God nem gwenaig esenafe. Afa sa ne elni amtakwaligim esug fwahaiba eba God nem gwenaig esenafe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Afa sa ne elim mangwal gawig faigoiba sa ma God nem gwenaig eseni. Eba numwehe suialag kwefihiagenam asa neana wula la memtola pugunam bite la kokofehia pekam minefefe. Afa elim sa ne enaig ihla faigog eba God nem gwenaig ihla faife.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Afa Sisas enaig lasug mo sihini og, “Atiaho sa nof tetini elbi ming nof tetini elim minaba faogfunafe, amo, eba awai eba naba ahkanam mungwali bu me la ahpefe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Afa skulinai luwal mas tisa lofba fei eba numweheg skuligim asa tisa lofba feg. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Haisegba sa ne og ka nilitena nof lanai fungisge flafatina afa nimbeafena nof lanai sumul mo mas ne onigig mo. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Mangigim sa ne enaig esog, nilite ka neana nof lanai fungisge flafati, afa ne mas sumul nimbeafna nof lanai nangug mo. Ne sonaig elbi eba ne mwakwalule el. Afa ne ilawana mo nimbeafna nof lanai sumul flafatinam ma neana nofug suialafeba asa ne nengigim nimbeafna nilitena nof lanai weti fungisge mo flafatina.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Afa Sisas enaig esona og, “Li figetini mas fug amtakwalig lugui, afa li fealameg mas fug suialag lugui. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Afa ilawanaba el li fugim nangugim anwenafig feg suialag me awai amtakwalig me. Afa el mas yifu fug pwatigimba usieg minaba afui afa mas baf fug pwatigimba kwalamp minaba afui. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Afa suialag el suialag onigigna fegim asa suiala nihe feageg. Afa amtakwalig el amtakwalig onigigna fegim asa amtakwalig nihe feageg. Afa haig onigig sa goh enag ehe ambala mo sihig.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Afa Sisas enaig sihifeni og, “Mangigim ne kam enaig seflaba fig og, Ainiyag, Ainiyag afa eba atiaho sa ne kana moaba patalfug? ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Afa amban sa ne ka nanguba blonam kana mo higinam afa sa patalkufe eba enaig elbi el sa lala nimblagim enaig sifafefe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Bume mungwanam kwagegim asa sumul mo lambig aitigim fun mo sumul megam laitia fukuag mengig la fwahagim afa simen mo enena waheg titig fwahag afa maia bifwatbi sahigba mas ena lalaba toafui eba ati wasneig goh. Enaba eba el ehe wasneig lala nimblag fwahag. ");
INSERT INTO amn_amanab_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Afa sa amban kana mo mas higigim patalkug mo enaig elbi lalaba onimblaba eba mas bumeba mungwanam koi afa mas sumulbi fun laitinam titi asa eba ena lalaba mas wasneig gofi. Afa maia bifwatbi sahigba eba sona lalaba ati tofu bambuhia pegi.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Sisas elim mo sihi fwahanim asa ika Kaperneam kembig gam seifu ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Afa enanai yiba amini misog el heafna gafugag elim gihna faka auguiafna. Eheba 100 amiim nangwaghiageule. Enag fwina heafna gafugag elim membena. Enag gafugag elbi ati lahagim meiye ofefna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Afa amini misog el higinaba og Sisas ati blog enanai yi ga asa Ju elni misog elim ningitigina og ma afu Sisasim sihinibi sa ma blo ehena gafugag elim wangene fefati. ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Afa sa ehengel afu Sisasnai apukenam Sisasim wasneig mona sihini og, “Hai, sona elbi suialag el ehem sa kweagfu. ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Eba ehe bigim Ju elim membenigim afa laskuhlag lala kangelni nimblanig.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Afa sa Sisas wankana muhla wan opugufnaba afa amini misog el heafna hihem sihiwagenam ningitigina og, ma afu gwesim Sisasim sihini ehengel afu enaig esogona og, “Saglag luwal, mangigim ne ehegepuseg blo og, kaba mangwal suialag el mo na ne kana lala gamba blo. ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Afa og, kaba mangwal suialag el mo na ka blo nem sihina esug mo behig sihiba sa ma kana gafugag elbi wangene fei. ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ka enaig sihifeg kaga ka sa misog elim ahnai skaufen. Ka gafa ati soldiaba feg enag kam ahnai skaufinig. Afa sa ka ming elim sihinafe aublo eba ehe blofe. Afa ka kikeafna gafugag elim sihinafe hwam gafugafe eba ehe ika esefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Sisas ena mom higinam ehena olug fingi fena afa el asa ehem patalfuna enam sihini og, “Ka nem nufunam sihinig mas ka ambanim Israel lanai elimba olug onigi kwania feg enaig elbi nanguna mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Afa el sa amini misog el ningitigina enag pese lala gam afuafnaba nanguni gih elbi enaba ati pugu suialafena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Afa managig fwainig Sisas Nain kembig gam ikafnaba afa sa patalfuiag el apaiyena afa mingnag kaksag el apaiyena enag Sisas wan ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Afa wan ikana kembig bogna mengig muhla wanpuguafnaba afa el ehgam elim lahagim fliubiegohna enag apukefeagini. Afa kaksag el afagim wanig ambena, ehena alagagba ati lahana afa enag lahag elbi eba gwenag mungu fena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Afa sa Ainiyag enag angwafigim nangunam fwinam aflafenam afa enaig sihifena og, “Nofeka ufwe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Afa sa Sisas ika muhla gohnam asa lahag elim gig simem ningana tuhuna maia el gwese ufuhiefnaba. Afa sa Sisas enaig esona og, “Luwal kwablog ka nem osihina, sa buihia.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Maia enaig esonaba asa enag elbi buihianam mo lagwagenaba afa sa Sisas pese afag nangum ningihiana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Afa mungwali el Godna wasneigim nangunim embefini. Afa sa Godna unehlagim fingi finim afa enaig esogona og, “Godna mo fla sihiaule el kwania bigim olyi pugunig afa God ati blog heafna elim kwaganigim.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Afa sa mungwali el distrik Judia ahkawag minefenam ena mom sihiageafuna. Sisas sa lahag elim ese fatina enam mom. ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jonna patalfuiag el Jonim sihinagini, Sisas sa mungwali eseagenaba enam. ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Afa Jon heafna patalfuiag elim sambaganigim awamonim asa ogna Sisas nangum ningitigi eheningi sa ma ika ahpukenam Sisasim ahsihinai og, “Neaho sa Jon sihi fwahanaba naho ne blo awai naiba ming el me kangelbi nengenafo?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Afa ika ahpugunam asa enaig esohona og, “Eba Jon bula laitiag el kam ningitigiba na ka ahblog ehe nem sahna og, neaho sa God nem ningihiagim sihi fwahanam ena me awai ming el me?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Afa sa enenam Sisas kaksag elim haig haig gihnam suiala feitifeafna afa sanel amtakwalig elni nihinai lambiningitigi feafna, afa kaksag el nofug hafinigna nofug bahia skofena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Afa Sisas wahigi sambaganigi elim enaig sihifeni og, “Se pese ahkanam Jonim ahsihina mangwal sa ne mungwali ahnangug afa ahigig, afa nofug hafinig el bahia skofeg afa el mong lilig fegna buihiakag afa enehna wagene fiahsaig afa ang tetini ati mo higig afa melig pigieg el puguiagafeg, afa gawig fwainig el Godna suialag mo higig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Afa el sa kam oniginig ehengelni olug onigiba eba wasneig afohiefufe. Enaig elbi sa ma sifakali.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Afa maia sambaganigi pese Jon nangu ahkanaba afa sa Sisas elim sihini ehe Jonim enaig esona og, “Autunam ne bite behig la afunam asa ne Jonna mo higini. Ne haig elim nanguni? El enaig pos lofug efef petla fakafefugu, enaigim ne nanguni me? Amo, Jonba mango enaig mo. ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Mangwalfigim ne membig afu nangug? Ne membig nangug el suialag nemug lofug gu me? Jonba mango enaig mo. Eba el suialag lofugnaba lala suialag la ga. ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Haisegba ne afug? Ne Godna mo fla sihiaule elim ne nangug me? Ei, Jonba enaig el. Ka nem nufuna mo sihinig hwa elbi mingnagim mo fli sihifule elim gosenig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Enag elbi autunam Godna Buk ati sihi fwahana enaba God esog; Sahig, kana mo flaukwiag elim ka ningihiaiba. Afa sa ehe Godna Gisfu Fwahag elim gosenim asa mina numwehiage kafe asa ma el ehem olug onigini.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Afa Sisas esona, “Ka nem nufuna mo sihinig Jon bula laitiag el mungwali elim autunaim pugu gosenig. Afa ambangel sa wetiklug saiyeg Godna bog megam enaba Jonim gosinig.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Afa kig lambiule el i afa gwenanai amtakwalig el i ena mo higinim afa sa ehengel og Godna mina eba ihlafeg. Afa ehengel ati Jonna ninga la bu la apaiyeg. ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Afa Farisi el i afa nihemo anwena el i Jonna ninga la bula apaiyegim mas esig mo. Asa ehengel oksig Godna sawiegim patalfuiagim. ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Afa Sisas esona og, “Afa ka glauwaba elni niheba ugu opugun fibi eba sa ka haig lasug mo sihife? Eba haig el maia? ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Afa ofenaiba luwal fane sugwafog la auguiaba afa gosis seaflahba mingnag luwalim unegonigim afa enaig esogona og, ‘Kagelbi fuf i anba i guwagihbi afa nengel mas ahfei afa kangel wewatoahba afa nengel mas wegoi.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Afa glaunai el enaig luwal lofug enaig esig, Jonba mas wain bug i afa fane i neagena mo eba ogna Godna unehlagim fingi fe afa el esogona og ‘Sanel amtakwalig ehem seifo gohna!’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Afa maia ka Nufuna El blogba afa ka bu i fane i wanegba afa ne enaig esogog, ‘Sa nangu enag elbi bu i fane i ati fwinam waneg. Afa ehe kig lambiule el mi afa ming amtakwalig el mi wana.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Afa elni nihe Godna onigigim patalkuba eba ambala pugufe enaig niheba eba ihlafeg.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Afa Farisi el mungu Sisasim unenam ogna fane ahga afa sa Sisas ehem ningi ikanam asa fane ehena lala ahga flafnaba. ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Afa mina angwafig ena kembig gafna ehe Sisas enag lala gam higinam asa sanda fun botolna flanam asa ubluna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Afa ehe Sisasim nobna patalkuiafnaba afa ehena nob mo Sisasna mong yi apaiyenaba asa ehe heafna lapogni titehiagenam afa sa Sisasna mogum kehlanam kikige flana afa sa sanda bug mo mongim susulenagena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Afa Farisi el sa Sisas i hawagfna enag ehem nangunam enaig oniginagenam og, “Afa sona elbi atiaba mo flaule el nemug fegba eba sa angwafigni nihem anwenafei asa ehem ningana tuhunaba enam. Afa sonag angwafigbi eba amtakwalig nihe feageaka.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Sisas ati ehena onigigim anwenafenam afa esona og, “Saimon, ka membeg saka nem mo sihina.” Afa Saimon esona og, “Ei, tisa sese.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Afa sa Sisas ehem enaig esona og, “Sambaganigi el kig elni ahlambana ena mo sihina og, ming elbi 100 kig enaig flana afa ming elbi eba 10 kig mungu flana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Afa eheningi mas mungwag ahfaina mo afa enag el sa kig faig eheningim sihini og, mangofi ka gwesim fwahag. Afa sa ne onigig amban maia ehemba fwina membenag?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Afa Saimon wahigi Sisasim sihina og, “Eba amban sa numwehenag.” Afa Sisas esona, “Ei neana onigig ihlafeg.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Afa Sisas wahigi angwafigim nangunam Saimonim sihina og, “Sa hwag angwafigim nangu. Ka neana lala gamba blonaba mas ne ka bu faina mo mungum sugimba. Afa sonag angwafigbi eba heafna nobna kana mungum suflagim afa lapogni mo nobim kana munginai titeageg. ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Afa mas ne kam kikige flana mo ka blog ma glawo pugugba hwag angwafig kana mungim kikigeaflag. ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Afa mas ne kam wel bug na misogim susulenagena mo. Afa hwa angwafigbi eba sanda bug fla blugim enena kana mungum susulenageg. ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Afa ka nem sihinag, sa nangu sona angwafigbi kam fwina membenag enaba ogfug God ati ehena kaksag nihe amtakwaligba flafatinag. Asa big anwenafi afa amban sa amtakwalig nihe weti esegba asa God flafatinag enag elbi ehena membegba eba weti feg.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Afa sa Sisas angwafigim enaig sihifena og, “Ati ka neana amtakwalig niheba flafatinag.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Afa el enanai yi mungwali wahe auguiafnaba fane ahgag sime la, ena mom higinim hefum sihiaginim afa og, “Sona elbi amban maia nasa amtakwalig nihem lambaitifefug?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Afa sa Sisas enag angwafigim enaig sihifena og, “Nimbeafna olug onigig ati suialafeg afa glawaba eba ati ne God i ahfeg neana olug sama aflahlana gofi.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Afa Sisas managig fwainig elni kembig la fapugufe akafnaba elim Godna bog meg mom sihinwagiakafna. Afa heafna 12 pela patalfuiag elim mungwal wangoh minefeafna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Afa mingnag angwafig gafa Sisasim patalfuna. Enag angwafigbi autunam sa Sisas ehengelni nihinai sanel amtakwaligim lambi ningitigifeni afa gihim wangenefeni. Enag ehe esini, ehengelni unehlagba Maria Makdala kembig lanai. Eheba autunam Sisas elegeg la gohug sanel amtakwalig ehena nihinai lambi ningitigina. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Afa mingba Joana fena afa Susana fena, afa mingnag angwafig apaiyena enag Sisasim patalfuna. Afa Joanaba Kusana angwag, enag elbi Herotna lalam gose fahigeule fena. Afa sonag el angwafigbi heafgelni gawigba Sisas mi afa patalfuiag el mi kwagani. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Afa mungwali kembig el ambe minefenam Sisasnai yi laskuhlagenaba asa Sisas lasug mo sihini og, ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“El enaig eseg kon gug aso la laitiageg afa maia laitiage kagba afa mingnag mo mina la apaiyeg. Afa sa el mungni pigafugba afa sa twafig mo ambe apaiyegim lambigafig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Afa mingnag mo fungisigig yi apaiyegim ikagna puguiageg. Eba bite mas bitegwelna feg mo. Afa maia osu pugu laugogba asa aftukuhla skofegim afa sa melig mungwali pigiageg. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Afa mingnag mo usieg weg amtakwalig la apaiyegba afa sa usieg nahlum wahe puguiagegim asa ehem sagfla fakag. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Afa mingnag mo suialag bite la apaiyegim fug leg skofeg. Enaig 100 fug leg skofeg. Sisas enag lasug mo sihi fwahanam afa sa esona og, amban anginaba eba sa ne higi.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Afa patalfuiag el ambe Sisasim sihini og, “Sa ne kam lasug mog mom sihin.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Afa ehe wahigi sihini og, “God enaig membeg nengel sa ne anwenafi enag Godna bog meg nihe mas autunam ambala puguna mo. Afa ka mingnag elim lasug mo sihig; Asa ehengel yisigig yisigig afa mas nanguig mo afa hig higig afa mas anwenafig mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Afa Sisas enaig esona og, “Hwa lasug mog moba enaig eseg, kon gugba eba Godna mom ogfug. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ambangel sa Godna mo higigim afa mas patalfug mo enaba naho ofenaiba kon gug lofug mina la apaiyeg. Afa God maia ena mo elni olug yi laitinugeba afa el amtakwalig Satan blogim ena moba lambinig afa Satan enaig onigig fe og, masa Godim olug oniginibi afa God ehem lambfe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Afa kon gug sa fungisigig yi apaiyeg eba enaig eseg el Godna mo higigim ikagna sifakale flag. Afa sa kon bagag mas numwehe pekag mo eba gohugum afa amtakwaligim awaieg. Eba enaig eseg eba el Godim oniginagim afa maia mingnag el ehem kinig i afa ninimu mo i faigbi eba ehena olug onigig tigefu pefe enaba onigig wetitifeg. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Afa kon gug usieg weg la apaiyeg eba enaig eseg el Godna mo higigim afa heafna gagim onigigim. Afa ehe fwina kigim onigkahba og na haig haig gawigim upuguiage. Afa na sa enaig onigig blogim ehem kike fakagba mas fug lugwe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Afa kon gug sa suialag bite la apaiyeg eba enaig eseg el sa Godna mom higigim afa heafgelni suialag olug onigig la fwinam kehligim asa patalfug eba naho sa ehengelni nihe pugu suialag feg.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Afa Sisas enaig esona og, “El mas wiba gaflanam sime skaubi kumohlai eba awai. Eba heafa gaflagim sime sisi yi folfugba asa el enam nangugim afa sa ambeg lala megamba saiyeg. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Afa haig haig gawig sa saiyeg meagam gohka eba ambala puguia minefefe. Afa enag meagam kumo fwahag enaba eba ambala puguiba asa mungwalig el enam anwena fife. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Afa mo sa ne higi ena mo numwehifibi afa ambangel sa anwenafi eba God ehengelim gwesim hilifenifie, afa ambangel sa anwena awaienig afa ehe enaig onigifig kati weti anwenafig eba God enaig onigigim ehengelni flafatinifie.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Afa ming nanam Sisasna afag i nilite i ogna ambe Sisasim nangui afa kaksag el laskuhlagena Sisasim kagui fakinibi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Afa sa mingnag ambe Sisasim sihini og, “Neana afag i nilite i ambeg ehbegam afohieba ogna nem nangui.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Afa Sisas wahigi pese enaig sihifeni og, “El sa Godna mom higigim patalfug eba naho kana afag i nilite i ba feg.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Afa ming nanam Sisas heafna patalfuiag elim bot la wan ogofnaba og, “Na kwegam malgim afu” asa afuna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Afa bot lambi lambkuafnaba Sisasba ati nongini afa afuan bu usmuiag la apukeafnaba afa sa bifwat kwania sahblona botim waike waike feflafnaba afa bu bot megam figfna. Eba gwena awaie skofegim ofena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Afa sa patalfuiag el Sisasim ilafunim sihini og, “Saglag luwal saglag luwal! Glawo bigim goho ati awai ofe.” Afa sa Sisas buihianam bifwatim kwenaba afa sa bifwat gweyi tigeafuna. Afa bu laikwaieg awaiena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Afa sa Sisas ehengelim enaig saheni og, “Haisegba sa ne enaig embebeba nafig enaigba nengelni olug onigigba weti feg.” Afa ehengel Sisasna wasneigim nanguni embefeagini. Afa fwinam onigwagi flafnaba afa hefum sihiagini og, “Sona elbi eba amban maia nasa bu mi bifwat mi kwenigbi asa ahtigeafog.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Sisas heafna patalfuiag elim Gerasa kembig ika wan puguna. Ena kembigba Galili buum tigeawagigim ika gifni. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Afa Sisas wan ikan bot mo folfu wan gofnaba afa el mungu ena kembig lanai blo ehem puguni. Ena elbi sanel amtakwalig esenaginibi asa heafna nihi lofug hugfuoiti feagenam ika bitekife la gikiafna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Afa sa Sisasim nangu eyionam blo Sisasna mong muhla penam fwinam enaig esona og, “Sisas ne wasneig Godna leg, ne haig kam esofena? Mas esi ne kam nofeka amtakwalig klati?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Afa maia enaig esonaba asa Sisas sanelim fenugena og, “Sa ma elim fwahinim afui.” Afa sona elbi el wahkig numwehefufna maia wasneig wena kikenagi fakifnibi afa eba sanel amtakwalig esenag gifinibi asa we mo kukoiti fefnam asa pugu bite behigam ikafna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Afa sa Sisas ehem sahna og, “Neana unehlagba amban?” Afa og, “Kaba ami.” Ena mogba eba enaig eseg ehena nihi yi kaksag sanel amtakwalig saiye gohna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Afa enag sanel amtakwalig Sisasim embefini asa fwina esoflini og, “Nofe ne kam susug kembig megam ningitigi.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Afa kaksag tata okwe yi mug la ahgagi afo. Afa sanel amtakwalig enaig sihifini og, “Eba sa ne kam tatagam ningitigi.” Asa Sisas gwenaig esena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Afa ehengel elni nihi nai apukenam asa afu tatana nihi yi seifoalafenaba afa sa tata fapisofe fwaligona bu la apaiye mungwali pigi kumohlana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Afa tatam nangwaghiagig el enam nangunim kembig gam embem afunam enanai yi ena mo sihiageafuna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Afa mungwali el ambe Sisas nai yi apukenam ena elim nangunibi ati suiala fenam lofug laitiagenam Sisasna mong muhla gafnaba mo wangeneg lagwageaufna. Ehengel enam nangunim embefeagini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Afa el enaigim nangunim mo sihiageafuna Sisas sa elim suiala fefatina. Ilawana sa sanel amtakwalig ehena nihi megam saiyenam esenagini ena elbi ati pugu suialafena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Afa mungwali el Gerasa distriki nai Sisasna wasneigim oniginim embefeaginim. Sisasim wasneig mo sihini og, “Hwa bite fwahanam pese ika.” Asa Sisas ehengelim fwatinam ika bot la fukunam pese ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Afa Sisas akofenaba el sa Sisas suiala fefatina enag Sisasim sahna og, “Sa big ahkai.” Afa Sisas ehem onigihiafna enaig esona og, ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Pese nimbeafna kembig gam ikanam sa ne ena mo sihinuwage God sa nem kweagfug ena mom.” Asa gwenaig esena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Sisas pese bu pahlag ehgam mangig ikafnaba. Afa mungwali el ehe nangum sifakaligna ambe gohna. Enaigba esinibi eba sa ehem nengenaflan. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Afa laskuhlag lala nai misog el blona, ehena unehlagba Jairus. Enag blo Sisasna mong muhla, mong kokni kwakwage penam Sisasim wasneig mona sahna og sa ma ehena lala gam ikai. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Afa ena elbi luwal naini mungu fena, afa ena luwalna krismasba 12 enaig fena. Enag ati lahagim meiofefna. Afa kaksag elim Sisas wan ikafnaba, minaba kagwo fakana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Afa angwafig mungu enanai fena. Enag angwafigbi wahigehlana afa wahkig sefkufna. Enaig esenaba 12 pela krismas ena. Afa ehena mungwali kig doktam faifinibi afa mas amban ena gihimba nugwe flakana mo, awai. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Afa enag angwafigbi Sisasna masigim blonam lofug angsa boagim tuhna. Maia enaig esenaba ehena wahigehlag gweyi awaiena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Afa Sisas enaig sahna og, “Amban kam ninganaba otuhug?” Afa mungwali el esogona og, “Siseme, siseme” afa Pita esona og, “Saglag luwal, eba mungwali el nem mug yi pugunag!” ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Afa Sisas esona og, “Eba maia kam ningana tuhugba, afa kana wasneig gweyi hugofug kag eba kati anwenafeg el kam tuhug.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Afa enag angwafig ati anwenafena ehe ambala olyi gofna asa kiafigig ehem ofefnaba asa mungwalig elni nofla blonam mong kokni kwakwagena nof bosug mo bite gam Sisasna kig muhla fisihli penam asa esona og mangwal ehe esegba asa kana gihimba ikagna awaieg. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Afa Sisas ehem sihina og, “Angwafig, ati ne kam olug oniginaba nem peseg suiala feg asa ma neana olug enesieg gofi.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Afa Sisas maisim sihiagofnaba afa Jairusna gafugag el blona Jairusim sihina og, “Ati neana legba lahag, nofe ne saglag elimbi kinig fai.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Afa Sisas ena mo higinam afa sa Jairusim sihina og, “Nofene kinigfe sa ne kam olug onigina eba sona luwalba neana suiala fefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Afa sa Sisas enag misog elni lala gam ikana. Afa ika lala apukenam afa lala megam oseifofnaba kaksag elim mo afwambala lasanam asa Pita na, Jon na, Jems na afa alag i afag i ahfena enag lala megamba saiye afuna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Afa el ena lala nai luwalim aflafinim wewatinaufna afa Sisas sihini og, “Nofeka wewatona eba mas lahag mo eba esug ehe nongi.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Afa el ena mo higinim afa titige watona og, eba ati nufuna lahafeg. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Afa sa Sisas luwalna ningam kehlanam asa enaig esona og, “Luwal buihia.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Afa sa luwalna sungwag pese blo sigeagenam asa buihiana. Afa sa Sisas esoni og fane ehem fai. ");
INSERT INTO amn_amanab_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Afa sa alag i afag i olug mungu ahwagofenaba Sisas sihini og, “Hwaig sa pugugba nofeka elim ahsihin, magofi.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Sisas patalfuiag elim awamonim wasneig faini og, sa ma sanel amtakwalig mi afa gih el mi suiala fetififi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Afa ogna ningitigiba sama afu Godna bog meg mo sihifi afa gih elim suiala fetififi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Afa enaig sihifeni og, “Ne afu ofefiba nofeka nimbeafgelni gawig lambug afu, moni i, mingnag nihinai lofug i, fane i, wula i, afa agat enena mina ikag enaig lambfu. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Afa ne ha kembig laba apukenam asa ne mungu lala afu auguiafim maia manageiba asa ne ena kembig mo fwahinim afa sa ne ming kembig mo afu. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Afa maia ena kembig lanaiba nem sulfug fwainigba asa ne ena kembigba fwahi afu ofefiba sa ne bite moginai mo titeagenim fwatinim asa ne afu goh. Asa ma enam anwenafi eba ehengel amtanafig.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Afa sa patalfuiag el gwenaig esini mungwali kembig afoaminefifnibi Godna mo sihifinim afa gih elim suiala feitififni. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Afa maia Sisas enaig gafuga feagenaba Herot gavmanna misog el ena mom higinam fwinam onigwaginam. Afa mingnag og, Jon bula laitiag el bite kifenai peseg buihiag. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Afa mingnag og, Elaija peseg pugug. Afa mingnag og, mo fli sihiafule el enana mungu autunai peseg bite kifenai buihiag. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Afa Herot misog el enaig esona og, “Jonba ati kana gafugag el kasuni hegeflakana afa sona elbi amban maia, afa ka higigba ehena gafugagba eba numwenafeg”. Afa sa ehe ogna Sisasim nangu. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Afa patalfuiag el pese ambe Sisas nai yi apukenam asa sihinagini gafuga sa afu feagini enam. Afa Sisas mingnag elim mo fwatinam heafna patalfuiag mo sulfu Betsaida kembig wan ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Afa maia Sisas wan ikanaba afa mungwali el ehem sum patalfuna apukenaba Sisas ehengelim sifakalenim asa Godna bog meg mo sihinuwagenam afa gih elim suiala feitifena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Afa maia osu pegim ofefnaba Sisasna patalfuiag el ambe ehem sihini og, “Osuba ati ope gwese hwaina elim ningitigi mine feiba sama afu heafnai yi aska minefenam aso nai fane yisgiawagi, hwa nai yiba bite behig la big auguia.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Afa Sisas esona og, “Amo, nengel ehe sa ne faneba faigo.” Afa ehengel enaig esogona og, “Kangelbi kaksag faneba awai eba afala pugufeg amba feg afa sambaganigi sawag fog feg. Afa neafa kam og afunam mungwali elim fane lambigon.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Afa eba 5,000 el enaig fena afa angwafig i luwal i mas enaba suwigigni mo. Afa Sisas patalfuiag elim sihini og, “Afu sihigonibi sa ma 50, 50 enaig augu feakai.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Afa sa patalfuiag el gwenaig sihi fegoniginibi asa gwenaig augu feakana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Afa sa Sisas afa la pugu feg amba lambina afa sambaganini sawag fog lambtina asa of gam ninof fegofnaba afa sa Godim suialag onam asa amba kukosko fena afa sawag fog titosko fena asa patalfuiag elim fainibi afa sa mimagegonigni. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Afa sa ehengel ahgawagin maia ihla feskofenaba ena mo 12 pela sob yi sobyifeagini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Afa mungunagim Sisas beten ofefnaba afa sa heafna patalfuiag el ambenaba afa Sisas sahini og, “Afa elbi haig esogog, ka mo amban maia?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Afa ehengel wahigi sihini og, “Eba mingnag enaig esogog og, Jon bu la laitiag el, afa mingnag og, Elaija, afa mingnag og, mo fla sihiafule el autunai bite kifenai peseg pugug.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Afa Sisas ehengelim sahtigina og, “Nimbeafba haig onigig nafig.” Afa Pita wahigi sihina og, “Ne Kraist God Gisfu Fwahag El.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Afa Sisas heafna patalfuiag elim wasneig mo faini og, nofene enaig mo amban elim sihini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Afa enaig esona og, “Kaba Nufunam El kwania kinig flafe. Afa sa misog el i saglag pris i afa nihemo anwena el i kam mas fatinim asa tigifatibi afa sa ka sambaga mungu osuna pese buihiafe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Afa Sisas enaig sihifeni og, “Afa amban kana patalfuiag elbi ofefiba eba ehe mas hefum onigi asa ma ehe wahkig li katigeg la lahagim numwehenam asa ma kam sum patal blui. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Afa amban sa onigig, heafna nofkikena gag kwania fenag asa ogna heafum gwese gufum eba enaig el mas nufunam nofkikena gagba flai. Afa amban kam patalfu oblofiba asa ma heafna nofkikena gagba fwahaiba eba asa ehe wahkig nofkikena gag flafe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Eba mas suialafeg mo afa el mungwali bitenai gawigim lambigba asa hefum awaiefe. Afa mungwali gawig mas sonaig elim nofkikena gagba fai. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Afa amban sa kam i afa kana mo mi afwanefefe afa enena maia eba Nufunam El heafna kwania ombusugni wasneigni blonam asa ehe gafa sonaig elim afwanefenafe. Enag ombusug i wasneigba eba mungwalofug Alagna afa of la nai elni. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ka nem nufunam sihinig mingnag el ilawo sa ne afohie eba mas nem pigi eba ne Godna bog megba nangufie.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Afa maia gug yi gohug osuna enaig la ofefnaba Sisas Pitana Jonna afa Jemsna mug gam fuku wan ikana ogna enanai yi betene. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ehe ika beten naufnaba afa ehena nofbosugba algana fena afa ehena fatiag lofugba fwinam busug nemwag fena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Afa ikagna Moses i Elaija i ahpugunam Sisasim ahwani ahlagofna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Afa eheningiba Godna kwania ombusugugni ahblona ahsihiagofna Sisas sa mangwal Jerusalem la fenam asa lahagfe afa ehena lahagba Godna mom ambala upugufe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Afa sambaga mungu elbi noftuta feasainaba non askana. Askan buguiagafe Sisasna ombusugugim nanguni maia Moses i Elaija i ehem ahwani gofna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Afa maia eheningi Sisasim ahfwahia ahagofnaba. Pita enaig esona og, “Tisa nawo hwa nai yi auguiafim suialag kagel sa sambaga mungu sangwali lala nimblagi, nem Mosesim afa Elaijam.” (Pita enaig sihiba fenaba eba ehena mo mas mog fena mo.) ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Afa maia Pita ena mo sihiagofnaba asa leango ombusug pe blonam sagfla skofenaba ehengel embefeagini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Afa ena leango laba mo God lagofna og, “Sona el kana Leg kana gafugagim gafugafegim ka wegig fwahag. Asa ne ehena mo higim.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Afa maia mo lagig awaienaba nangunibi Sisas mungu gofna afa patalfuiag el mas ena mo sihiagini mo asa nanguni enam. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Afa Sisas ming osuna ena mug mo fwahinim apaiye ambegohna. Asa ehe wan blonaba afa kaksag el ehem mina la ulambini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Afa enanai yi, el mungu Sisasim unenam og, “Saglag el ka nem asahna sa ne kana luwalim nangu kana munguhe feg. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Wahkig nilag ehem simbigahla esefku kiafigig fefigim afa memp mimeuweti fefig afa unena gohminefefig. Afa sa ehem fwina nugwakaleaflag afa mas ehem ikagna fwahai. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Afa ka neana patalfuiag elim sihinigbi ehengel afu esinigbi mas suiala feg mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Afa Sisas wahigi enaig sihifena og, “Hanansi nagim maia ka nem wan gafiba asa ka nengelni kinigbi fla gofife. Afa ne mas onigig mo nengelni olug onigig i afa nihe i mas ihlafeg mo. Sa osum luwalim wani blu.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Afa maia ena luwal blona Sisasna muhla pugunaba asa nilag luwalim ese fatinaba bite la penam kiafigig laitiagifnibi asa Sisas nilagim fenagenam luwal mo suiala fefatinam pese alagim nangum ningihiana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Afa mungwali el Godna kwania wasneigim nangunim sineminefiageni. Afa enam fwinam onigwageafufna Sisas sa enaig eseagenaba enam afa Sisas heafna patalfuiag elim sihini og, ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Sa hwa mo numwehe higim, eba Nufuna Elim ufunam mingnag elni ningana fwahife.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Afa God ena mom meagam kumohla gufna asa patalfuiag el enanam mas numwehi enag mog mom anwenafini mo afa ehengel Sisasim sahnigim embefini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Afa ming enanam patalfuiag el hefum flafihiagini og, amban sa gosefe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Sisas ati ehengelni onigigim anwenafeni asa ehe luwalim sulufla blu olyi wani gofenaba. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Afa sa patalfuiag elim enaig sihifeni og, “Amban sa ne kam oniginam hwa luwalim kweagfuiba eba naho kam ninimwehiaflag eba apiim gafa gwenaig esenag ehe sa kam ningihiag. Eba el wetiaklug unehlag fwainig nengelnai olyi go enaba naho goseg elbi ofe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jon Sisasim sihina og, “Saglag luwal, ka nangugbi el mungu neana unehlag la sanelim ningitigi feageg. Afa eba mas bigim patag kana mo enag ka kwinig.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Afa Sisas ehengelim sihini og, “Nofene kwini eba mango angoluwag mo eba nengelni hihe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Afa God Sisasim heven gam wanikiagim ati meyiofefnaba afa sa Sisas wasneig onigig kehlanam ogna sa Jerusalem gam mo ika. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Afa sa ehe elim gof ningitigina og ma afu Samaria kembig ninimweheagifi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Afa ena kembig lanai mas Sisasim sawiyifi heafgelni lala gam wanigafuna mo. Afa ati anwenafini og eba Sisasba Jerusalem gam ikafe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Afa sambaganigi patalfuiag el Jems i Jon i Samariana nihem ahnangwagnam Sisasim ahsahna og, “Ainiyag ne haig onigig feg ne membegba ka sa unibi sa ma suwi heven lanai pe blo sona elim laskofei.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Afa Sisas wahigi sambaganigi elim fenugena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Afa sa enanai mo fwahinim ming kembig gam afuna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Afa Sisas mingnagim wankafnaba afa el mungu enaig esona og, “Mungwali kembig sa ne kafiba ka nem patalfefkufufe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Afa Sisas ehem enaig sihifena og, “Sangwalinai malang ati bite kogim ena megam gi afa twafigni gag ati feg afa kaba Nufuna El eba ehena kug gigbi awai.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Afa Sisas ming elim sihina og, “Aublo kam patalku.” Afa enag el enaig esona og, “Ainiyag, kam ilawo fwahaiba kawo ika kikeafna alagim kumohlanam.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Afa Sisas ehem sihina og, “Mangofi, kam patalku. Eba ambangel sati pigig enag el ehe sa ma melig pigieg elimbi faki. Afa neba eba sa ne Godna bog meg mom ika sihi.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Afa mingnag el gwenaig esona og, “Eba ka nem patalfukufe afa ilawaba ka kikeafna afahumonigim bwataonim ka sa blo.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Afa Sisas ehem sihina og, “El sa enaig eseg tataba opifba mas nofbosug mo masigim ninofeg gofiba asa pifi eba tatam faugufefe afa enaig elbi eba mas ihlafe Godna bog meg moba gafugafei.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Afa Sisas 72 elim wegi fwatinam gafuga la ningitigi minefena, ehe sambaga sambaga feitifena og sa ma mungwali kembig gof afoamine fifibi ogna sa ehe mo sum ika. ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Afa ehe enaig esona og, “Asonai fane kaksag ati ambiakag afa mas kaksag el feg mo enag fane lambwagigimba sa ne asona alagim betenninibi sa ma gafugag elim ningitigiba ma afunam ehena ena fane agogulinagi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Afu! Sa hig, ka nem tata luwalig lofug sangwal malangna olyi onigitigi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Afa ne afufefiba nofene nimbeafgelni kig i mong lofug i afa gawigiba lambug afu afa nofeka elim mina la ulambinim bwata gonim. ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Afa maia ne afu ha lalaba asaiyegofiba sa ne enaig esogo, hwa lala nai el sa olug enesiegna auguiafim. ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Afa ma atiaba amban el ena lala nai olug enesiegna gafiba eba nengelni suialag mo ehenai gofufe. Afa enaig el gag fwainigba eba ena mo suialagba pese blo nimbeafgel nai yi gofufe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Afa sa ne gwena lala mungu auguiafim nofene mungwali lala afwaminefi, fane sati nem lambwaigog sa ne gwenanai ahgaflafim afa enag el gafuga feageba asa ma enanam sa ma mungwag fai. ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Afa maia ne afu ha kembig laba apukeba ma atiaba nem sulufu heafgelni lala gam wan afu ofefiba eba sa ne fane mo lambug afu sa nem lambwaigog. ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Afa sa ne ena kembig la nai elim gihnam suiala feitifinim afa sa ne mo enaig sihifi og, Godna bog meg ati blo muhla nem ofen. ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Afa ne hag kembig laba apukefe afa el sa nem wan afu lala saiyeg fwainig fefe eba sa ne gweyi afoahiefiba asa ne enaig esogo, ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Ma mong yi nai bite mo go hwa nai yi afgwafi eba amtana minafig afa sa ne numwehe onigim Godna bog meg ati blog muhla feg.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ka nem sihinig God elim kwefihiagegim ati enag osuba wegfu fwahiag. Enag elni kinig sa opugun eba gwesim hilifeg Sodomnai elni kinigim kwegfugkag.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Sisas enaig esog, “Korasin lanai el i Betsaida lanai el i niasambanig, afa mangigim ne enaigba ne esig. Afa maia Tair lanai el i Saidon lanai el i ma nanguiteba enag kigmogim. Sa ati ne nanguni asa autunam heafgelni amtakwaligim afwahifnibi afa sa kokohiag lofug laitiagini afa simof susleagini enaba heafgelni kusugogim ogfuni. ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Afa nengegim God kwefihiageg osuna mungwag faigim. God Tair lanai mi Saidon lanai me gwenaig amtakwalig mungwag faifi. Afa nengelimbi eba nem numwehe faifi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","“Afa Kaperneam lanai el ne onigig noka suialag el hevengam afufe, eba awai, eba God nem suwi lagig kembig gam labi klaitife. ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Afa Sisas patalfuiag elim enaig sihifeni og, amban sa nengelni mo higife eba ati kana mo higig afa amban sa nengelni mo oksi fwaha kafe eba ati kana mo oksi fwahag ikag afa amban enaigba esefe eba ati Godim mas fatinag ehe sa kam ningihiag.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Afa Sisas sa 72 elim ningitigina enag pese ambe apukegohna, afa ehe sifakalifinibi enaig esogona og, “Ainiyag, ka neana unehlagim sefligbi sanel amtakwalig ena mo higigim apuke embem ahkawag minefeg.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Afa Sisas enaig sihifeni, og, “Ka nangugba Satan of lanai opefenaba afwe lofug fliakafeg. ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Sa hig, ati ka nem wasneigbi faig eba ne sobine afa gongigna nihiafuiafiba. Afa eba ne ming Satanna mungwali wasneigim ne filafefatife. Afa mas nem mangwal ambanim fei. ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nofeka enaig sifakali sanel ati kagelni mo higig onigim embem afug. Amo, eba Godim ehe sa ne sifakalini eba ati ehe nengelni unehlag heven la nofkikena gag buk la fakanig.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Afa enenam Godna Sungwabug Sisasim sifakalig fainaba Sisas enaig esona, og, “Api ne heven lanai afa bitenai Ainiyag, ka nem suialag onag afa ne hwaig anwenagba anwena elbi ne sisagenigim afa ne etetig elim mo ambala upugunig. Api ne enaigba esegba eba ne nibeafna membugum patalfefku.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Afa Sisas enaig esona og, “Kikeafna Alag mungwali gawig kana ninga la fwahag afa mas amban kana Alagba anwenafenag mo eba kike mungu fegim afa amban sa ka kikeafna Alagim ogfunig ena mungu he ehem anwenafinig.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Afa patalfuiag el mungu auguiafnaba Sisas wahigi nanguagnam asa enaig esoni, og, “El sa mangwalim nanguig eba nengel sati ne fanangufie eba sa ma sifakali. ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Afa ka nem osihin autunam mo fli sihiafule el i afa misog el i ogna hwaigim nangui afa mas nanguig mo afa ogna hwaig mo higim afa mas higig mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Afa nihemo anwena el mungu ogna Sisasim yuhna ehe enaig sahna og, “Tisa sa ka haig esenam sa ka nofkikena wahkig gagba flafe?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Afa Sisas wahigi ehem sihina og, “Ne ati anwenafeg nihim, ne haig onigig feg?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Afa nihemo anwena el enaig esona og, “Sa ne Godim fwina membena. Afa nimbiafna olugni, onigigna sungwabugni afa wasneigni asa ne Godim membena afa sa ne nibeafna hihem fwina mebena asa nibefum enaig safafefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Sisas ehem sihina og, “Ei, enaig ho ati ne ihla sihig enaigba ne eseiba eba ne nofkikenaba flafe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Afa anwena el enaig onigig fena og, eba Sisasim og masa enaig onigig fefe og sona elbi mas patalkug mo. Afa sa Sisasim enaig esona, og, “Afa kana hihe amban maia?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Afa Sisas lasug mo enaig sihifena og, “El mungu Jerusalemim fwahanam Jerikogam pe la kafna afa raskol el ati ambe mina puguag la afohieafna, enag apuke ehena gawig mwehnaginim afatigi kaminefi fati afunaba ati lahagim meini ofefna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“Afa enenam pris mungu blo nanguafnaba ehmbeg mina kwegfu ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Afa lotunai gafugag el mungu gwenaig esena blo nangunam ehmbeg mina kwegfu ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Afa Samarianai eba afwambanai el sum blonam asa nanguna maia mina la gifnibi afa sa aflafena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Afa sa ika fahigenagenam asa marasin bugna malu gokigim sugfunagenam kikenagena, enaig donki la lasunam asa luwal nena lalagam wanikina. ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Enanai yi wanigiau maia managenaba asa lalana mogim silva kig fainam og, ‘Asa numwehe sani gafim, afa sa nofeka ming sisiyi pahla eba se gafiba ka pese blonam kasa nem fai.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Afa Sisas anwena elim sahna og, sambaga mungu el sa amban maia raskol tigifatig elimbi kweagfuna. Afa amban maia ehena hiheaba feg?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Afa ehe esona og, “Eba el sa fwinam aflafenam afa kweagfuna.” Afa Sisas ehem sihina og, “Ei, sa ne gwenaig ne gafa ese.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Sisas patalfuiag elim wan ikana kembig la wan seifu pugunaba afa Marta blonam Sisasim suluflanam heafna lalagam wanikina. ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Afa Marta ati heafna sumineg fena ehena unehlagba Maria enag blo Sisasim muhla kuguhlanam Sisasna mo hignaufna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Afa Martaba gafugagim fwinam onigina ehe fwaimu fane kukumwei yegohun ehem oksinaba asa ika Sisasim sihina og, “Ainiyag, sa ne kam kusguna sa ne kikeafna suminegim sihinaiba sa ma blo kam kweagfoi ka kike fwaimu gafuga fego.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Afa Ainiyag ehem esona og, “O Marta, ne fwinam gawigim onigigi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Afa sa ne mangwalim mungu onigigi, afa Maria sa aflahba eba suialag nemugfeg mas big ehena enaigim fli fatini”. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Afa maia Sisas betene gafnaba, afa sa patalfuiag el mungu Sisasim enaig sahnafena og, “Ainiyag, sa kam betenegim ogfunim Jon sati autunam esena heafna patalfuiag elim ogfuni.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Afa Sisas enaig sihifeni og, “Sa ne enaig beteni og; Api el sa ma neana unehlagim fingifi afa neana bog meg sa ma bloi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Afa sa ne kam fane mungu mungu osuna faibi sa ma gwese gofi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Afa ne kagelni amtakwalig nihem esmunagim pigihianugeg fatinig. Afa ka gwenaig esig el kagelim amtakwalig hiagibi asa kagel gwenaig esegonig ehengelni amtakwaligim pigi fatigonig ne kam fwatife, ma kam yuhnagba pugunibi sa ne kam amtakwalig lanai lambim.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Afa Sisas enaig sihifeni og, “Amban sa heafna hihefeg enag sinaini blogim heafna hihem esonag og, ‘O, hihe ka membeg kam sambaga mungu amba faim. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Afa ehe ikagim heafna ming hihem sihinag, og, kana hihe minagwi blowag sinaini kana lala puguba afa kam fane awaienag ka mas faig mo.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","“Afa eheba lala megam gibi enaig esog, og, ‘Nofe ka kam ilafofeafla ati ka mengigba kikisegim ka wangi. Ka mas buihianam nem gawigba fai.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ka nem sihinig lalana mog hihem sa gawig faig fwainig awaiefe eba ehe maisim sahna go maia feg ehem oksiba asa buihiagim mungwali gawig ehem lambwaig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Afa sa ne gwenaig esi ma ne Godim sahnibi sa ma nem mangwalba fai afa ne yisgibi eba ne nangufie afa ne mengigimba faheugufibi eba nem mengig piginife. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Afa mungwali el sa mangwalimba Godimba sahnigbi eba flife. Afa ambangel enam fwinamba oyisgibi eba sa nangufi afa amban mengigim faheugufeflibi eba piginugefe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“Afa sa nengelni luwal amban heafna alagim sahnafe og, kam sawag embinegu fai, afa sa wahigife gihe sobine faig, amo. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Afa luwal alagim sahnafe kam amb suwig fai afa sa wahigifegim gaigo faig, amo ena gafa awai. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Afa nengel luwalna humoanig eba amtakwalig el afa sa ne luwalim suiala fehiagig sa ne anwenafi nengelni alag hevenla ga eba nem sifakalenim afa ambangel sa ehem sahnig enam heafna Sungwabug faife.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Sisas mengim hafinig elim suiala fefatina, ena elbi sanel esenagini. Afa maia el mo lagwagenaba asa mungwali el enam nangunim sineminefini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Afa mingnag el enaig esogona og, “Sona elbi eba Belsebulni kigmog la gafuga feaka.” Belsebul eba Satan sanelni misog el. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Afa mingnag el ogna Sisasim yuhni asa ehengel ehem sihini og, “Sa kigmog ogfu enaigba ne esegba eba naho ogfug ne Godna gafugagba feageaka.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Afa Sisas ati ehengelni onigigim anwena fenim afa enaig esona og. “Eba enaig eseg, sa ambangel kantri kwefihiagim asa hufum hagfe eba ena kantri amtakwalefe. Afa mungu nilitena sa hefum hagfe eba gwenaig esefe amtakwalefe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Afa Satan heafna gafugag elim amtakwale klaitiba asa hefum pwatihiagife, afa pwatihiaginim afa sa mangwal sa Satan nangwagihi ageg eba enag tigefupefe. Afa sa ne esgog, kam og, Belsebulni kigmog la sanel amtakwaligim ningitigi feaka. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Afa nufunamba asa amban sa nengelni elbi kigmoagba faife asa sanelimbi ningitigi feaka? Asa nibeafna elim ogfunfe, nengelni onigig amtanafeg. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Afa atiaba God kigmog faigba amba sa ena kigmogna ka sanel amtakwaligim ningitigi feakagba eba sa ne anwenafi, eba Godna bog meg ati pugug. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Afa sa wasneig el mungu fangoba lambigim heafna lalam kokoago afa sa ehena lalanai gawigba suiala gohna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Afa eba ming el fwina wasneig elbi ehe bagagafenam asa ehem filafe fatinam afa sa fango mo mwehenam afa ehena mungwali gawig mo ukwefenam mingnag elim mimagenfie. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Afa amban sa kablei ahgohug fwainigba eba kam angoluwag el fenag afa amban sa elim lambigim kam kwegfwag fwainigba eba elim patageule el.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Afa Sisas enaig esona “Sanel elim fwahagim ikagim bu fwainig bite eyi gagim yisgig, afa mas uflag mo. Asa ehe enaig esog og, ka pese kikeafna lalagam ika. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Afa sa ikag ena lalam nangugba esug go afa ati ombusiagigim afa numwehiagig fwahig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Afa sa ehe pese ikagim elegeg la gohug sanel fwina amtakwaligim sulufugim asa wanblog saiyeg afohie, asa elbi enaba fwina nemug amtakwaleageg, afa ilawana mo gweyiagig fena.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Afa maia mungwali el laskuhla gofnaba asa Sisas enanai mo sihina afa angwafig mungu enanai enaig esona og, “Angwafig sa nem wanigagim afa nem tut faig enaba sa sifakalei.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Afa Sisas enaig esona og, “Amo, sa big enaig esogo, el sa Godna mo higigim patalfug enaig elbi eba sa ma sifakali.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Afa kaksag el ambenaba afa sa Sisas enaig esona og el enenamba amtakwalig augiafnaba og kawo wasneigim nangu afa enaba ogfug ka Godna gafugag ka eseg. Afa mas enag ogfuiagimba nanguig mo eba awai eba Jonana wasneigim mungu nangufe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Afa autunam Godna mo flaule el Jona Niniva nai el amtakwaligim asa Nufunam el gwenaig nengelim esenfie. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Afa enenam God sa elim kwefihianugefe afa membinai kwin buihianam asa nengelim setigifie. Afa ena kwinbi eba heafna kembig fwaha blonam Soloman na suialag mo asa higife. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Afa enenam God elim kwefihianugefe afa sa Niniva la nai el bugia gafenam asa nengelim setigifie. Afa ehengel Jonana mo higinim asa heafgelni amtakwalig nihe masigim fatini, ka nem sihinig amban el mungu sa wanai yi go, asa enag Jonamba gosenag. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Sisas enaig esona og, “Mas ambanba wiba gaflanam meagamba kumohlai, eba awai, eba wiba gaflagim ambala uguhba eba ena lalanaim elim ombusug faig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Afa nofugba eligni ombusug neana nofug suiala gohugba eba neana elig mungwali ombusig. Afa neana nofug amtakwaligba eba neana elig sikulufeg. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Afa sa numwehifibi ese neana ombusug sa seifo neana nihi go masa fwinam sikulufeagefe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Afa eba neana elig sa mungwali ombusi go enag sikulufeg mas neanai yi gofi enag sa ma mungwali ombusi gofi ofenaiba lam laugugo.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Afa maia Sisas mo sihi fwahanaba afa sa Farisi el mungu blo ehem awamonam og na fane ahga afa sa Sisas ehengelni lala ika seifo sime la pegana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Afa maia Sisas fane bula ningam suwageg fwainig onefnaba afa ena Farisi el enam nangunam fwinam onigwageaufna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Afa Sisas ati ehena onigigim anwenafenam asa enaig esona og, “Nengel Farisi el ne kap afa pletba afwambagim mungu gigiafeagig afa meagam nengelni onigigba eba ugwefi afa haig haig nihei memtola pugu go. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Afa ne mo etetig el! Mas ne numweheg anwenafig mo eba God gafugafefug afa sa ehe meagam gafa gwenaig esefug. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Afa mangwal sa plet la afogoa enag sa ne elim faigo asa ehengelim enaig tumenig afa ne enaigba esibi eba nengelni mungwali gawig afsug pugu go hwagefe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Afa Farisi el niasabanig eba nem amtakwalig pugunfie ne enaig esig, yasmoel unehlagba mint, dil, kumin enag ne lambigim afa ne 10 pela hap sugwafugim afa mungwehigenai mo Godim faig afa ne suialag nihe God sa membeg enam ne fwahig. Sa ne enam fwina wasneiyi ma sa ne mingnag nihim gafa fwahife. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Afa Farisi el niasabanig nem amtakwalig pugunfie. Ne enaig esig ogka laskuhla fohug lala gosi suialag sime la augu. Afa ne enaig membig nog sa ma kam unegoni og, saglag el. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Afa niasabanig ne bite kife lofug. Sisiyiamo el nangugbi suialag go afa el ena mina gam afugim afa mas anwenafig mo skau mo bitemegamba eba kigi lofugi ati nogi go.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Afa nihe mo anwena el mungu ena mom higinam Sisasim sihina og, “Ogfuiag el ne enaig mo Farisiim esonibi eba kagelim gafa ne kam mungwali moalabenig.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Afa Sisas anwena elim enaig esoni og, “Niasabanig eba amtakwalig nem pugunfe ne elim kinig kike faigog, afa ena kinigbi el kahlig, afa nibeah mo mas ne weti ningana sehlig mo. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Afa niasabanig nengelni simbianiga Godna mo fli sihiafule elim kwaskofigim afa ne bite kife mo fwinam suialafeagig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Afa enaigba eba ne elim ogfugonig, eba enaba ne mungu onigig flig nengelni simbianiga sa autunam esini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Afa Godna suialag onigig enaig esog, og eba ka mo fli sihiafule elni afa wefug fwatieg elni ningitigiba asa afu amtakwalig el nai apukeiba afa sa mingnag mo patagiemine fenigim asa kwaskofife afa mingnag i mo esug kwaskofig fwatig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Afa sa ena kinigbi gwesego ilawana sa God mungwal gawig eseage fwahanaba enanai pugugim blog glawaga go. Enaig mungwali nihe God glawanga elim mungwag faig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Afa mo flisihiafule elim sa kwaskofigbi ena niheba Abel naiyi pugugim blog Sekaraia nai pugug. Afa Sekaraiaba tigi fatinibi eba Godim sis tuhlu faig sime i afa Godna kwania lala i ena olyi tigi fatini. Ei ka nem sihinig, ena susug amtakwaligba eba nem mungwali elim mungwag faigimbi ilawaga pugunfe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Afa nihemo anwenag el niasabanig, ne Godim anwenafenag minam kwegonig afa nibeah mo mas ne ena minagamba afu saiye anwenafi afa ne ehengelim kwegonig.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Afa maia Sisas ena lalam fwahia akofenaba afa Farisi el i afa nihemo anwenag el i olug kakagenaginim afa sa haig haig sahig apuke fenagini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Afa ehe mwakwalini Sisasim og maia haig mo sihiba og nasa ehem kotimini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Afa kaksag el fwinam laskuhlag enam mina kagfu fakanaba enanam Sisas patalfuiag elim enaig sihifeni og, “Farisini yistim numwehifibi, enaba ka nem sihinigbi eba ehengelni mwakwal mo amtakwalig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Afa mangwal sa mungwali meagam ilawo sisagego eba nengigim ambala pugufe. Afa sisag moba eba mungwali el anwenafife. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Afa ilawo sa ne mungwali mo muhefuna ne sihig afa nengigimba eba el ambala higife. Afa mungwali mo sa ne ilawo muhefuna lala megam sihig, afa nengigimba eba el ambala ambwaitina sihife.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Afa Sisas enaig esoni og, “Kana hihe nofeka embefi amban sa nem og, ka tikefati enag elbi mas neana sungwabugimba tikefati, eba awai. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Ka nem ambala osihin, sa ne Godim embefini, eba ehe nem eligni sungwabugni suwi lagig kembig gam lambi aitife ka nem nufuna mo sihinig sa ne Godim mungu embefini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Afa sa ne afala pugufeg twafig weti kigna lambig ese masa mungu pefe eba God mas enaigimba eteti. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Afa eba God ati nengelni lapogim suwigig fwatig, afa ati nem anwenafenig afa nemba gwesim twafigim, hili fegonig Godna onigigimba asa nofe ne embefi.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Afa Sisas enaig esog og, “Afa amban el sa enaig esofe og kaba Sisasna el, eba afa kaba Nufunam El gafa Godna oflanai elim sihinfe og, hwaba kana el. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Afa amban el sa mingnag elni nofla kam mas fatinafe eba ka gafa Godna oflanai elim sihinfe hwag elbi ka mas ehem anwenafenag mo. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Afa amban el sa amtakwalig mo Nufunam Elim esenafe eba God ma ena amtakwaligba flafatife. Afa asa amban Godna sungwabugim amtakwalig mo esenaiba eba glau afa nengigim God ena amtakwaligimba mas flafatinai. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Afa maia nem wanafu gavmanna nofla afa lotuinai saglag elni nof la lambi aitibi nofeka enaig onigwagim afa haig mo sa big sihife. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Afa eba gwenenam nem Godna sungwabug nengelim ogfunibi asa ne moaba sihigonfe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Afa el mungu blo Sisasim enaig sihifena og, “Ogfuiag el kana alag ati lahagba gawig mo sko fwaha kag ka membeg ne kana etegim sihinaiba sa ma gawig mangetigi kam fai.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Afa Sisas ehem wahigi sahna og, “Amban sa kam enaig kwefihiagegimba wefug fwahag og sa ma nenigina gawig mangetigini amo eba awai?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Afa Sisas enaig sihifeni og, “Numwehifibi masa ne haig haig gawigim, enaba ne enaig nubinifefe, afa mas nem enaig gawig nof kikenag fai.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Afa Sisas enaig lasug mo sihina og “Kig elni asonai gawig kaksag pugug gug lugwageg. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Afa enag el enaig onigifena og, haig sa ka esefe, ena asonai faneba sa ka mangwal lala skofe ka lala awai. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","“Naiba kawo enaig ese, ka fane lala wetianig bubugeiti feakanam afa ka sa kwania lala nimblagenam enanai asonai fanei witi sko. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ei kasa kikeahba enaig eso, kaba fwinam enaig eseageg, ka kaksag gawig suialag eseagegba eba gwese wahkig kaksag yia la gofiba afa sa ka hekuleaufiba fane mo agogulinam neaufiba sifakalefe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Afa God ehem enaig esona og, ‘Ne moetetig el ilawo nem hwa sinaini lahaiba afa sa neana mungwali gawigba amban flafe?’” ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Sisas enaig esona og, “Sonaig el sa kaksag bitenai gawig agogulig enaba afunam Godna nofbosug la esug el amtakwalig afohiefufe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Afa Sisas heafna patalfuiag elim sihini og, “Ka nem enaig sihiofen sa ne lasug mom onig. Nofe ne nimbeafgelni nofkikenam fwina onigwaginim afa ne enaig esegofe nog mangwal sa big ahgafe? Afa nofe ka nimbeafna nihim oniginim afa enaig esogo mangwal lofug sa big fatife? ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Afa ena nofkikena eba fanem flafug afa elig lofugim flafug. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Afa ati ne twafigim nangwagig mas faneba yihi afa mas agogulinim fane lalaba sugui, eba God ehe faneba faig, afa nimba ati ne twafigim flafug! ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Afa amban sa nengelnai onigwagegim asa heafna nofkikenaba hilifeg fwahag, amo eba awai. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Afa mas ne ena wetiaklugba esei, haig esegba sa ne fwinam mingimba onigig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Ati ne li sisigimba nangug haig sa pugug afa ehe mas wasneig gafugafei afa lofugba kweli. Afa ka nem sihinig autunam misog el Solomanna mungwali wag suiala skofenaba mas suialag li sisig lofena mo. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Afa ilawo sa hwa pos gohka afa siniba higfihinim suwi la lambi aitife, enaig posba God ehe wagwageg fwahag, afa sa nengel weti onigig feg asa ne numwehe onigim neaga Godba nem wag faife. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Afa nofe ka kaksag onigwaginim afa esogo mangwal fane afa bu big ahgafe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Afa afwambanai elbi enaigim fwina onigwagigim afa sa fwinam yisgeafo, afa nengelni alag ati anwenafeg asa ne enaig flife. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Afa ne enaig esofifibi eba sa Godna bog meg gose fwinam onigibi eba sa nem enag gawig gafa nem faifi.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Afa Sisas enaig esona og, “Nengel kana mungu sambagag sipsip nofe ne embefi eba nengelni alag nem gaunamug minaba ogfunfie eba ehe nengelni misog el fenam asa ne heafna bog megam saiyefe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Afa sa ne elim fwahiagonibi sa ma nengelni mungwali gawig lambibi asa ne kig fli sa ne ena kig mo el sa gawig tumenig sa ne kigba enam faigo. Afa sa ne suialag gawig hevenlanai agoguli. Hevenlaba eba mas susmofe i afa mas ugwef el ugwef i afa mas awaie i. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Afa enanai yi sa neana gawig go enaba neana onigig gafa eba gwese enanai yi gofife.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Afa Sisas enaig esona og, “Sa ne gafugag lofug laitiagenim afa lam gawagi sa ne ninmwehiaginim gofum. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Afa sa ne enaig esi ofenaiba saglag el angwafig flag buyisegim oblohba ne enam ninmwehiagigim negeafo. Ma atiaba blo mengigim tigegba eba ikagna mengig pitigiefunife. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Afa sa ena elbi blo gafugag elim nanguagfe sa ehengel non askag fwainig fife eba sa ma sifakalife. Ka nem nufunam sihinig, ena saglag luwal ehe gafugag lofug laitagegnam asa sihinfe og, apaiye sime la augu, asa ehe blonam faneba mimagenfe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Afa sa saglag luwal mongkok luputiegna me awai ambagna me blo gafuga elim nanguagfe sa ehengel non askag fwainigfife eba sa ma sifakali. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Atiaho ne enam anwenafig, el sa lalana mog feg enag sa ati anwenafefe eba ansi sa sinaini ukwef elbi blofe asa ehe numwehego afa mas fwahai eba og masa ukwef el lalagam feifu blofe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Afa neaga sa ne numweheage gofim Nufunam El sa enag osuna oblofiba ne etetiegafife.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Afa Pita Sisasim sahna og, “Ainiyag ena lasug moaba fig kagelim mungu me awai mungwali el nahlu me?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Afa Sisas esona og, “Amban sa gafugag el sa suialag onigig fegim asa heafna gafugagim numweheageg enaig elbi eba naho misog el ehem wefug fwahag og sa ma ehena gafugag elim nangwaghiagnam afa sa fane mimageni. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Afa enenam sa misog el pese blonam asa ehem nangufe maia gafugafegofiba afa enaig elbi sa ma sifakalei. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Afa ka nem nufuna mo sihinig afa enag gafugag elbi eba misog el ehem wefug fwahag og sa ma mungwali gawigim nangwaghiagei. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Afa enag gafugag el enaig ming onigig fenaba ehe enaig esona misog el eba maisim fe afa asa ehe pugugim mingnag gafugag elim saglagim afa angwafigim kwagaitifiahka afa wain bug negim fwina toififeageg. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Afa enag osuna ehe etetife maia heafna misog el pese blo pugufe afa enag misog el ehem nugwakale flanam afwambanai el naiyi wahe fwahafe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Afa gafugag elbi ati ehe misog elni sawiegiba anwena fenam afa ehe mas ninumweheagena mo misog elni sawiegim patalku mo eba misog el blonam ehem fwinam tigikaminefefe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Afa amban gafugag el sa misog elni sawiegim etetig eba moalagig susug flafe, afa ambangel el sa ne kaksag gawig lambwagig afa ne ming pasnim asa ne pese suku afa sa el kaksag gawig mungu elni ninga la sukufe eba enag el sa ma mingnag pasnam asa ma pese ehengelim lambwai yi.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Afa Sisas enaig esona og, “Ka blogim suwi bite la fati fwahag, afa ka sawyifeg ena suwi ati pahlag. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Afa maia ka lahafe eba enaig ofenaiba ka alganam bula pe flag sufe, enag kam olug fwina kinig enaig gafugag sa ma gohun ikan enenam awaie. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Afa masa ne enaig onigig fife kam og eba blog hwa bite la fag hagigim tigeflakafe. Amo, eba ka blo elim olyi magetigife. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Afa nengigba eba afala pugufeg mungu lalanai el hefum bambuhiagi kamine fenam asa hefum tigetifeagife. Afa sambaga mungu afohienam asa sambaga elim fegonfe afa sambaga el ahgohnam sambaga mungu elim ahfenfe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Afa alag gohnam heafna fangonai luwalim fenagefi afa fangonai luwal gohnam heafna alagim fenagefi afa afag gohnam heafna naini luwalim fenagefi afa naini luwal gohnam heafna afagim fenagefi, afa kowag gohnam heafna kowagim fenagefi afa kowag wahgife mungwag heafna kowagim fenagefi.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Afa Sisas kaksag elim enaig sihifeni og, “Afa sa ne ofim osu pegam nangug maia nugwagofeba ne enaig esogog bu fegim asa bufeg. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Afa ne nanguig wasneig efef osu peg ehbeg lanai blog. Afa ne esog osu klaig alaugu asa gwenaig eseg. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Afa ne sambaga mengigna el ne enaig esig bitenai gawig mi afa oflanai mi ne fwina kwefihianagig afa ne mas numweheg anwenafig mo mangwal sa glawo pugug.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Sisas enaig esona og, “Afa haig segba sa ne mas numweheg onigig mo sa ne numwehe kwefihiagi haig nihe sa ihlaba feg. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Afa el sa nem ogna kotimena enaba sa ne mina la ahkafiba sa ne sihiagafe. Masa nem flanam jasna ninga la fwahaiba afa jas nem flanam plismanna ninga la fwahaiba asa nem flanam kalabus lala fatife. ");
INSERT INTO amn_amanab_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Afa ka nem nufunam sihinig, eba ne kalabus lala gweyi gafiba asa ne kigna mungwali baimefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Afa maia Sisas mo sihiage fwahanaba afa el mingnag Galilina mom sihinagini, og Pailat heafna amiim sihinigbi ehengel elim kwasko fifug, maia Godim sis tuhlu faigim ofibi afa elni taf pefug Godim faigim ofibi afa elni taf pefug Godim sis tuhlu faig taf la pahlafig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Afa Sisas enaig sihifeni og, “Atiaho sa ne onigig, enag Galili elbi amtakwalig gafugag kaksag feagigbi asa enag amtakwalig ehengelim pugunig? Afa mingnag Galili el eba suialag afa sa mas enaig amtakwalig ehengelim puguni mo? ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Amo eba awai ka nem nufunam sihinig, eba ne olug waikefig fwainigba eba nem amtakwalig gwenaig mungwali pugunfe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Afa autunam Siloamna kembig kwieg lala tofupe 18 yi gohug elim pigasko fenaba asa pigina sa ne enam onig amtakwalig sa figbi, enaba ne og el sa Jerusalem la auguia enam filafig me? ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Amo ena gafa awai, ka nem nufunam sihinig eba sa ne olug waikefig fwainig fife eba nem amtakwalig gwenaig mungwali pugunfe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Afa Sisas enaig lasug mo sihina og, “El mungu fik li heafna aso la gahag fwahag, afa nengigimba eba ehe pese blonam asa fik li fugim oyisigifiba afa mas fugim nangui. ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Afa sa ehe heafna gafugag elim enaig esona og, ‘Sa hig, sona fik libi sambaga mungu yia la gohug, afa mas fug leg mo ka fahigeagegba mas ka fugim nangug mo eba sa ne higeflaiti ehe munim suialag bite la go.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Afa gafugag el wahigi ehem sihina og, ‘Saglag luwal sa magofi ma mungu yia la gofiba kawo mogim bite tutohiagenam afa bulmakauni ata sukonage.’” ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ma atiaba nengigim fug olefiba eba suialag, afa awaiba fegba eba sa higeflaiti. ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Afa Sisas laskuhlag osuna laskuhlag lala mo sihinwagena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Afa enanaiba angwafig mungu gihna fena eba sanel amtakwalig saiye esenagini ena gihba wahkig gwese gofna, yiaba 18 ena enaig fena, enag ehena kigibugbi ati fiahsafena haig seg buihiah mo. ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Afa Sisas ehem unenam afa enaig esona og, ‘Angwafig ati ka neana gihba huguflatinag.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Afa sa Sisas angwafigim ningana tuhnaba asa kigibugbi buihia susni feafona. Afa sa ehe Godna unehlagim figi fukuna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Afa laskuhla gohug lalanai gosig el Sisasim olug kakagenam ehe mungwali elim enaig esona og, ‘Gihna sa ne og el sa ma kam suiala fefati eba enwesog la gohug gafugag osuna ehe sa ne blo. Afa nofe kawo elbi gihim suialafe fatiagimba laskuhlag osunaba blo sahna, magofi.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Afa Sisas wahigi ehem enaig sihifena og, “Ne sambaga mengigna el, afa nengelni mo i nihe i mas mungwalofug ahfeg mo, eba ne laskuhlag osunaba bulmakau lalagam afugim bulmakauni donkinam pigihiagonigigim bu lambwaigogim wanafug. ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Afa hwag angwafig sa eba Abrahamna luwalig mungu he feg enag Satan ehem kehlaguiag 18 yia enaig la enaigim pigi fatinag afa ne kam og masa ne laskuhlag osunaba esefe?’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Afa maia Sisas enaig sihifenaba, afa ehena angoluwag el ehem fwina afwanefesko fena. Afa mungwali el afigigini maia enaig suiala pugunaba. ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Afa Sisas enaig esona, og, “Godna bog meg sa haig seg, ka enaig lasug mo osihi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Eba weti klug mastet lifug lofug afa maia el aso la kumohlagba asa fugogim kwania feagegba afa asa twafig ambegim enanai yi gag nimblagig.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Afa Sisas ming lasug mo sihini og, “Godna bog meg sa haig eseg. Haig lasug mo sa ka sihig? ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Afa eba yist lofug, angwafig mungu yist weti flagim plaua kwania la wahegba asa plaua pupkuia fugog.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Sisas Jerusalem minagam ikafnaba elim taun lanai elim afa kembig lanaim mo ogfufehiagena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Afa el mungu Sisasim enaig sahnafena og, ‘Sa God ba mungu mungu elbi pese lambi me?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Afa Sisas wahigi enaig sihifeni og, “Sa ne fwinam wasneiyi afu mengig weti megam saiye. Afa ka nem sihinig, eba kaksag el ona ena minaba saiye afa mas enaig esi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Afa maia nengigim lalana mog mengig kikiseba eba ne ambenam afwambala afohiefiba afa ne enaig esogofe ne og, ‘Ei saglag luwal kam mengig piginim.’ Afa nem wahigi enaig esonfe og, ‘Ka mas nem anwena fenig mo ne hanai blog.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Afa ne enaig esogofe ‘Kaba ati big fane ahgafena afa ne olyi gohugim kam ogfunigeg.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Afa eba nem enaig sihifenfe, ‘Ka mas nem anwena fenig mo ne hanai el, ne amtakwalig el gwesim afu.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Afa ne nanguibi Abraham, Aisak, Jekop afa mungwali Godna mo fli sihiafule el enag Godna bog megamba saiye afohiefife. Afa negelbi nem lambi klaitibi ne afwamba la afohiefiba afa ne wewatini nibeafgelni gog kike sko fefe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Afa el osu puguiag lanai, osu peg lanai, afa ehmbeg la nai afa ohgo nai ehnge nai asa ambenam Godna bog megam saiyenam fane ahgaflatife. ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Is, sa hig, enenam mingnag el sa ilawo sum ambe eba afu gosife. Afa mingnag sa gosig afuia eba ambenam sum afohiefife.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Afa gwenenam Farisi el ambe Sisasim sihini og, “Ne hwa kembig fwahanam ming kembig gam ika Herot nem ona tigefati.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Afa Sisas sihini og, “Herotba ifauwi lofug afunam sa ne ehem enaig sihifini. Is sa hig, gla i, sini i ka sanel amtakwaligim ningitigifei afa gih elim suiala feitifei, afa maia sambaga mungu osu feiba eba kasa kikeafna gafugagba awaie fati. ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Afa ilawo, sini, esnag ka gwesim ikafufe profetba mas algana kembig laba gafiba enanaiba tigifati eba heafna Jerusalemlaba sa tigifati.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Sisas enaig esona og, “O Jerusalem lanai luwal ne Godna mo sihiafule elim kwaskofig. Afa el God nem ningitiginigbi afa ne funna kwaskofig, afa wahkig goka elim lamblu kikeafnai yi lambugufim, ofe naiba kakaruk afag heafna luwaligim lamblu anglag meg gam kumo lambgu afa mas ne enaig membig mo. ");
INSERT INTO amn_amanab_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Is sa hig. Ilawoba nengelni kembig amtakwalenam esug gofufe. Afa ka nem nufuna sihiofen ne mas kam nangui ne auguan sa ne esogofe. Sonag elbi God ehe numwehenageg Ainiyagna unehlag la ningihiag. Sa ma God ehem suialafiah flai.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Afa maia laskuhlag osuna pugunaba Sisas ika Farisini goseg elni lala fane ahgaflafnaba afa ehengel Sisasim nanguflafna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Afa kwakug el blonam Sisasim nanguna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Afa sa Sisas enaig elim nangunam afa sa anwenag el mi Farisi el mi enaig saheni og, “Bigelni nihemo sa haig esog sa big gih elim bi laskuhlag osunaba suiala fifati me awai, awai me?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Afa ehengel mwalfwai auguafena mas mo haig esogona mo, asa Sisas ena elim suiala fefatinaba asa pugu ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Afa sa Sisas enaig sihifeni og, “Eba sa nengelnai sa ne laskuhlag osunaba luwalim o bulmakaubi bumelaba pe nilagofiba sa ne nangu fwahai me awai ne ikagna fwakla fati me?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Afa ehengel mas mo mungwag wahigi Sisasim fatini mo. ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Afa Sisas elim fane ahga flag la nangwagna, ehengel ona ehe suialag sime la gosi augu, afa sa Sisas lasug mo enaig sihifeni. ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","Og, “Afa sa el mungu nem angwafig fla buyis la unetigife nofe ne afu suialag sime la gosi augu eba atiame ming elim gisfu fwahanag ehe kwania unehlana fegim afa gwesim nem hilifenig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Afa enag el maia nengigim bloiba afa sa buyis el nem unenam afa nem enaig sihifenafe, og, sona elim siaba sa fwahana maia enaig esoiba afa sa nem afwanefefe afa sa ne ikanam masgim amtakwalig sime la pegafe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Afa sa buyis el blo nem fane negimba unenafe eba sa ne ikanam masgim pega, ma ne enaig eseiba, eba sa sonag el nem unenam enaig esonage og hihe se blo hwa gosig siala pega. Ma nem enaig esenaiba eba el sa ne fane ahgafla ne ehengelni nofug la unehlag kwania flafe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Afa el sa heafna unehlagim figifukufe eba God ehena unehlagim pigaupife, afa el sa heafna unehlagim pigaupig eba God ehena unehlagim figifukufe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Afa Sisas buyis alag elim enaig sihifena og, “Ne buyisba ofefiba nofe ka hihem, nilitem, hamagaum, afa gau ninganam enam mugom esen. Asa ehengel sa nem mungwag buyis la uninim gwenaig nem esinife. ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Magofi, afa ne buyisba ofefiba eba sa ne gawig fwainig elim uneni, mong kukwaligni ninga waikefonam afa nofug hafinignam. ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Afa enaig elbi mas nem mungwag enaig esini, eba sa ne sifakale nengigimba God nem mungwa faife maia bite kifenai suialag el pese bugiaga ofefiba.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Afa el mungu Sisas fane waneaufna enag ena mo higinam Sisasim enaig sihi fena og, “El sa Godna bog megam saiyefego buyis ne eba sa ma sifakali.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Afa Sisas ehem enaig sihifena og, “El mungu ena buyis kwania ofeba enag kaksag elim unetigig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Afa ehe sufu fwahagim asa heafna gafugag elim ningihiana afa sa gafugag el ikagim enaig eso og, a ‘Au ambe mungwali fane ati kukumeig gohug.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Afa mungwali el wahigi ehem enaig sihi fini og kam oksig, afa ming el og, ‘Kaba bite ka kigna baimeg fwahag enag ka nanguagim ako, niasabam.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Afa ming el og, ‘Kaba bulmakau baimeg enag ka yuwigim ako niasabam.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Afa ming el og, ‘Kaba ilawo ka angwafig flag na haiseg ka blo mo niasabam.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Afa sa gafugag el ena mo lambinam pese uku misog elim sihina afa misog el ena mom hignam abofeahlana afa sa pese gafugag elim enaig sihifena og, ‘Ikagna ika mungwali mina weitianig sa taun mina ahkawag minefe sa ne ena mina ikafiba afa sa ne el elig amtakwalignam sulfuiaka, nofug hafinigna afa mong waikefonam sa kana lala megam wan sefu ambe.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Afa sa gafugag el gwenaig eseg, ehe blonam misog elim, enaig sihifena og, ‘Sa ne esogba ati ka gwenaig eseg afa mas lala megim ihla gohwageg mo.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Afa saglag el pese gafugag elim sihina og, ‘Taun mo fwahanam sa ne minahug mina aso bog mina ika nangwagnam asa ne wasneig mo faim sa ma kana lala ihla gohwagei. ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Afa ka nem osihin, mungwali el sa ka gofgam unenig eba mas kana fane weiti ahgai.’” ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Sisas nubwel elim wan ikafnaba wahigi enaig sihifeni og. ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Eba ambanba ne kam patalfu oblofiba sa ne kam fwina membena. Afa nimbiafna humoan, afahumoan, angwafig, luwal, nilite, muwal afa nimbeafna nofkenagag sa ne ena mo sumi yi memben, Afa amban enaig eseg fwainigba eba enaig elbi mas kana patalfuiag elbi fei. ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Afa amban sa hefum lahagim ninumwehiageg fwainig kam patalfu oblofimba, enaig elbi mas kana patalkuiag elbi fei. ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Afa sa amban nengelnai ona lala nimbla enaig elbi sa atiaho gagim numweheg oniguageg og, lalaba enaba kigba ihla fei me awai, awai me? ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Afa mas ilawana enaig oniguagba fei, eba gweyi ikagna sumul ugwatigig afa mas ena lalaba awigi, afa sa el enam nanguigim ehem moalabinig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Afa sa ehengel enaig esogog og, sonag elbi lalaba esegim mas auwigig mo. ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Afa misog el ona ming misog el i fagna ahufla enag gahba onigwageg ehena amibi 10 tausen ami feg afa ming misog elni amibi eba 20 tausen enaig ami feg enag ehe ona anwenafenam asa fagna ahufla atiaba ehem filafe fati me awai, awai me? ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Afa sa ehe enaig onigigfefe, og, mas ihlafei eba maia fagiule membiyi fifibi asa elim ningitigife og sa ma mo flifunam sihibi sama fagna hagigim awaie. ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Afa enaig feg sa nengelnai amban heafna mungwali gawigim masgim fatiag fwainig fefe eba mas kana patalfuiag elbi gofi.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Afa Sisas enaig esona og, “Solba suialag ehe, afa sa solna mileaklag awaiefe eba sa big haig esibi sa ma pese mileakla fei? ");
INSERT INTO amn_amanab_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Afa enaig solba mas fanem esenaiba mas suiala fei. Eba fwinam amtakwaleagegba el esugum fatig. El anganaba sa ne ena mom higim.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Afa moni lambig el i afa haig haig nihenai el i ambe muhla afohiafnaba Sisasna mo higfana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Afa Farisi el i nihemo anwenag el i olug kakageaginim og, “Mangigim Sisasba ehengelimbi hihe fenigim afa faneba wan one.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Afa maia enaig esinibi asa Sisas lasug mo sihina. ");
INSERT INTO amn_amanab_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","Og, “Eba el nengelnai 100 sipsip feg afa maia mungu mo awaiegba afa sa 99 mungu afohieba faneba afu ahgage afo. Afa enag el mas fwahai eba maisim yisgegohug asa uflag. ");
INSERT INTO amn_amanab_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Afa uflagim asa fwaklag ohumbug la kufehlag ubluiahba ehe mo sifakale blo. ");
INSERT INTO amn_amanab_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Afa maia lalagam ublugim asa heafna hihem afa mungu kembig lanaim unetigigim og, ‘Au ambe nawo sifakali kana sipsip mungu awaiena ati ka peseg uflagim sulfla ublug.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Sisas enaig esona. Ka nem nufunam osihin haig sifakal sa hevenlaba pugufe eba maia mungu el amtakwalig nihe nai olug waikefeg eba kwania feg, afa enaig sifakalba 99 elbi gwenaig suialag afohie eba gweyiagig feg. Afa el sa amtakwalig nihenai sa olug waike ofe enaba naho ehem fwinam sifakalinig.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Afa Sisas enaig sihifena og, “Angwafig mungu ningam pugufewagig kig enaig feg afa mungu awaieg lala la afa sa ehe wi gaflagim pupohiageakahba maisim yisgiego, feg feg uflagim. ");
INSERT INTO amn_amanab_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Asa heafna hihem afa mungu kembig lanaim unetigigim og, ‘Ei au ambe nawo sifakali kig mungu kana awaiena ka yisgiegohug ati ka peseg flag’” ");
INSERT INTO amn_amanab_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Afa Sisas enaig esona og, “Ka nem ihla mohe sihinig. Enaig sifakalba eba gwenaig Godna oflanai el gafa esig maia ambanba olug waike feg Ainiyagna mina gamba puguba.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Afa Sisas pese enaig sihigena og, “El sambaganigi luwal feg. ");
INSERT INTO amn_amanab_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Afa sa sumineg enaig esona og, ‘Api ka onigig, kam gwese mungwali gawig mangetiginuge, fi kam fai afa kikeafna etegim fai, kamba glawu sa faim’, asa alag gwenaig eseni. ");
INSERT INTO amn_amanab_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Afa managig fwainig suminegba heafna mungwali gawig elim mimagen kafnaba enananam kig mo lambnam afa sa eheahba membi kembig gam ikana, ika enanai esegofnaba heafna kigba mungwali taitufe awaie fatina. ");
INSERT INTO amn_amanab_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Afa maia kig awaienaba, afa sa bini kwania ena kembig pugunaba ehem bini fwinam lahanaba asa pugu elim gafugagim sahinwagea kafna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Sahinwageakan el mungu tatam wangafna enag fla tata gafugag la ningihiana og, ma tatam nangwaghige gofi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Afa eheba tatam fane fainim maia ahgageafufnaba afa tatam nagwagwan maia ehem bini lahanaba asa ogna tatana fane lambenefena afa mas amban fane faina mo. ");
INSERT INTO amn_amanab_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Afa sa gan gweyi oniginam esona og, ‘Afa kana Apina gafugag elni mungwaliba eba faneba numbwelihe gohun, afa ka hwa nai yi gahba kam bini fwinam lahageg. ");
INSERT INTO amn_amanab_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Magofi kawu Api nangum pese ika, ka ikanam ka sa Apiim enaig sihifena Api, ati ka nem mi God mi amtakwalig nihe ka nem fenig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Afa kaba mango suialag el mo na ne kam kana luwal moalonai, se kam esug fwahaiba ka sa neana gafugag el lofe.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Asa gwenaig esena buihianam Alag nangum ikana, afa maia membiyi feafnaba, Alag nangunam afa fwina sifakalinam asa kikini ikan heafna legim ningana pugufenam asag tita feaflana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Afa leg enaig esona og, ‘Api, kaba ati ka nem mi God mi amtakwalig nihe ka nem fenig. Kaba mango suialag el mo na ne kam, kana luwal moalona.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Afa sa alag heafna gafugag elim unenim enaig sihifeni og, ‘Ikagna afu kwieg lofug kikeafna flibi fatini afa kil weiti ningabuli yi fatini afa mog lofug mong yi fatini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Afa afunam bulmakau lambag sulufli wanig ambenam sa tigi, nawo ahganam sa sifakali. ");
INSERT INTO amn_amanab_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Afa enaba eba hwa luwal kana ati awaiena afa glawaba ati pese blog nofkikena gohug. Afa mas awaieg mo.’ Afa sa kwania fane ahgamine fenam asa sifakalini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Afa enenamba eba ehena etegba aso la gan sa blona afa blo muhla pugunaba heafgelni lala muhla afa sa buyisna aune higna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Afa sa gafugag elim unena, ma blonaba asa sahnagena, og, ‘Sonaba mangwal ofi?’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Afa gafugag el ehem sihina, og, ‘Eba neana sumineg ati pese blo pugugba enaig neana alag bulmakau lambag tigeg. Enaba alag legim nangugim sifakaleg, luwal mas awaiena mo afa eba ati pese blo pugug.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Afa eteg ena mo higinam olug kakageagena mas lalagam sawiyife ikana mo asa alag pugu afwabagam blona moai nugwefenagena, og, ma eiyi ehena olug tikaiyi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Afa eheba wahigi alagim enaig sihifena, og, ‘Haig eseg? Sa kaba kaksag yialaba ka neana gafugagim ehegepuseakag, ka ofe naiba esug gafugag el lofeg, afa ka mas neana mom flafoi, afa ne mas kam ahnana mo meme luwalig faina mo afa mas ka kikeafna hihem enaig sifakal ka wan feg mo, eba awai. ");
INSERT INTO amn_amanab_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Afa sona luwal kikeafna sumineg sa eba mungwali gawig neana ukug haig haig la taitufeg fwahagim asa pese glawa mo blogba ne ehem sifakalenagim afa ne bulmakau lambag tigeg.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Afa alag ehem enaig sihifena og, ‘Luwal wahkig ati big hawagig mungwali gawig sa kana feg eba neana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Afa glawaba nawo sifakali sa ma bigna olug suiala fei neana sumineg ati ika awaiena afa glawaba pese blog nofkikena gohug, afa big ehem suluoflig.’” ");
INSERT INTO amn_amanab_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Afa Sisas heafna patalfuiag elim enaig sihifeni og, “Saglag el heafa ati fahigeawagig el fena, afa enag mingnag el ambenam ehena saglag elim sihini og sonag fahigeawagig elbi neana gawig esug awaieg fatig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Afa asa saglag el fahigeawagig elim unenam ma blonaba asa sihina, og, ‘Ka neana hwaig nihe mo higig? Sa ne ikanam kana mungwali gawig sa ne lambwagena sa ne enam sihiage. Afa mas ne enaig gafugaba pese fei.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Afa sa fahigeawagig el hefum enaig esona og, ‘Afa sa ka haig esefe? Afa kam saglag el ona fahigeawagig gafuga lanaim ningihia, afa ka mas wasneig mo namo ka sa amban elniba ika bite tutohiawagig gafugaba fegofi, afa ka elni kig muni flagim kam afwanefeg. ");
INSERT INTO amn_amanab_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Afa glawu ka onigig, ka mangwal fegimba, maia kam saglag elbi enaig gafuga lanaiba ningihiaiba sa ma el kam kwegfui.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Afa sa mungu mungu elim unenugenaba asa ambena, ehengel sa saglag elni gawig esug lambwagini, afa mungu el blo gof pugunaba, asa fahigeawagig el ehem sahna, og, ‘Ne hanansi kana saglag elni gawigba esugba flana.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Afa wahigi ehem sihina, og, ‘Pepa enaig sihifeg 100 wel dramna’ afa fahigeawagig el ehem sihina og, ‘Afa sa ne susulenam ikagna 50 dram ginofe.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Afa ming el sum blo pugunaba afa fahigeawagig el ehem sahna og, ‘Neana esug flag gawigba hanansi’, afa sihina og, ‘Pepa enaig sihifeg 100 wit bekna,’ afa fahigeawagig el ehem sihina og, ‘Afa sa enag pepa nem fainiba afa ne 80 bek ginofena.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Afa sa sumi yi saglag el ati ehena enaigim anwenafenam og, ‘Sonag elbi suialag elhu fegim afa eba heafna onigigim goseg ukug.’ Afa bitenai nihenai elni onigig eba ombusuginai elni onigigim gwesim hilifegonig bitenai gafuga figibi.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Afa Sisas sihini og, “Afa ne bitenai gawigim kehli gafuga feafuhba nog sa ma kam el muhla fegoni, afa sona gawigba eba maia autunai la awaieba asa God nem sulufunim afu lala wahkig gohug la suialag auguiafufe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Afa maia amban mungu mungu gawigimba numwehiage akafife eba kaksag gawigim gafa gwenaig eseg. Afa sa amban mas weitim nihem ihlafei eba kwania nihem gafa gwenaig eseg. ");
INSERT INTO amn_amanab_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Afa eba ne hwa bitenai gawigim ninumwehig fwainigba eba amban sa nem heven lanai mangwal suialagba faibi sa ne ninumwehige? ");
INSERT INTO amn_amanab_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Afa eba ne mingnag elni gawigim ninumwehig fwainig fife, eba amban sa neana gawigba nem faifie? ");
INSERT INTO amn_amanab_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Afa mas amban sambaga misog elni gafugaba fei eba amban misog el sa ehem suiala feaflag, eba naho ehena mo higigim patalkug, afa amban misog el sa mas ehem suiala feaflai eba ehena mo mas hignam patalkui, afa eba ambani mo ahnai skau fenaiba afa ambani mo mas fatinafe, afa nofe ne God mi bitenai gawig mi wahi.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Afa Farisi elbi fwina kigim onigafu, afa ehengel ena mungwali mo higinim, maia Sisas sihiagenaba afa sa Sisasim moalabini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Afa Sisas enaig sihifeni og, “Nengel ne enaig onigig nog elni nof la kikeahba suialag nihe feafu. Afa eba God ati neana olug onigigimba anwenafenig, afa enaba ne onigig eba suialag, afa Godna noflaba eba amtakwalig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Afa nihe mo i mo fla sihiafule elni mo i gwese gohug ikag Jon pugu gohug, afa enanaiba Godna bog meg suialag mo mungwali kembig opugu ka afa sa mungwali el fwinam wasneigim gafuga fig ona afu Godna bog megam saiye gohum. ");
INSERT INTO amn_amanab_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Afa of i bite i eba ika awaiefe afa wetiklug ginofba Godna nihe moba mas awaie eba gwese gofufe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Sisas enaig esona og, amban sa heafna angwafigim fwaiyunam afa ming angwafig flafe, enaig elbi eba aga taitug el. Afa amban sa angwafigim fwaiyu fatife afa sa ming el flafe ehe gafa aga taitufeg el.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Afa autunam el mungu gawig numbni fena eheba suialag lofug yimieg laitiagefnam afa fane suialag neageaugna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Afa ehena lala mengig muhlaba eba el kukwalig enehna gafna ehena unehlagba Lasarus, ");
INSERT INTO amn_amanab_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ehe enaig onigina og ma gawig numbni elni fane ogug sime skau apaiyefiba ona sa lambinefefim afa sa malang ambefnam ehena nehugugim libeahga fifni. ");
INSERT INTO amn_amanab_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Afa sa gof maia ehem lahanaba, Godna oflanai el ambe wanigafunaba asa ika Abraham mi hawagfnaba afa sumi yi gawig numbni elim lahanaba asa fakini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Afa sa ehe ika susug kembig pugunam asa onigwageufna afa sa gweyi sisigam ninofenaba Abraham mi Lasarusi membiyi hawagfna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Afa sa enaig unefena og, ‘Api Abraham kam aflafenam asa Lasarusim ningihiaba sa ma kam bu ningabulni figihiana ublu mileg la fakanaiba sa ma kam luputie. Ka seifug suwi ihnol megam goba afa kam susufiageg.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Afa Abraham ehem sihina og, ‘Luwal sa ne onigim, afa ne nofkikenaba gofnaba mungwali gawig ne nimbefum mungu ne onigina afa Lasarusba eba amtakwalig mungwali ehem pugunagena. Enag glawaba blog hwa kembig la suialag ga, afa neba susug amtakwalig ne afla. ");
INSERT INTO amn_amanab_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Afa mingba enaig eseg, God bigim bite olyi kowagig fakanig afa nengel ne mas kagel nangum peifuafufi ambei afa kagel ka mas peifuafufi negel nangum gafa afui.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Afa gawig numbni el enaig esona og, ‘Api ka nem enaig sahna ofena sa ne Lasarusim ningihiaba sa me kikeafna Alagna lalagam ikai. ");
INSERT INTO amn_amanab_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Afa kana niliteaba afala pugufeg Lasarus sa ma ika wasneig mo faibi asa ma amtakwalig nihem fwahinim olug waikefi masa ambe hwa kembig la susug flife.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Afa Abraham esona og, ‘Mosesna mo i afa mo fliule elni mo i sa ma numwehe angug labuihaginim hwa moba higi.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Afa gawig numbni el esona og, ‘Api Abraham sonaigba haig esi mo eba amban sati lahag enag ehe sa ma pese bitekifelanai puguna ika sihinibi asa ma olug waikefi.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Afa Abraham ehem enaig sihifena og, ‘Afa sa Mosesna mo i afa mo fliule elni mo i higig fwanigba fife eba melig lahag el gafa ika sihinibi mas olug waikefi.’” ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Afa Sisas patalfuiag elim enaig sihifeni og, “Haig haig nihe amtakwalig pugunam elim esenagba sa el enanaig amtakwalig eseagig, afa sonag el sa ne ming elim esenagba asa enaig la peg eba niasabam. ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Afa atiaba el luwalim enaig nihem ogfunagba afa sa luwal enaig la pefe eba se fun kwaniana weana kikenaigim asa bugam fatibi sa ma lahai, sonaigba eba suialafeg. Masa enaig fwina amtakwalig eseagefe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Afa nimbefu mo numwehigibi. Afa neana nilite sa amtakwalig nihefefe eba sa ne niheangu, afa atiaba olug waike ofefife eba sa ne mwanugwefena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Afa sa nem elegeg la gohug amtakwalig nihe mungu osuna esenafnam afa blofnam nem sihinagofufe og ka nem amtanafenag se mwanugwefenafim.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Afa patalfuiag el Ainiyagim enaig sihifini, og, “Sa ne kagelni olug onigigim esenibi sa ma gwesim ikafi.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Afa Ainiyag ehem enaig esoni, og, “Magofi, ma atiaba nengelni olug onigig weiti fegba eba ofenaiba ambwe sisig lofug. Eba sa ne ihlafifi, sa ne liim sihini og susum fagafu ika solwarala pegofum afa sa libi nengelni mo hignam asa gwenaig eseg.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Sisas mo gwesim hili enaig sihifena, og, “Ma atiaba neana gafugag el fegba sa ma ika bite toafoi me awaie sipsipim nangwaghiage me sa ma enaig ese. Afa maia sonag gafugag elbi pese lalagamba oblofiba sa ne ehem enaig sihibafe enai og, ‘Au ikagna blo ganam fane ne. Sa ne enaigba esoi? Eba awai.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Afa eba sa ne enaig sihifena, og, ‘Ne kana fane numwehiaginim afa sa ne kam flaubluna, ka ma kawu gof fane i bu i neageba asa neawu sum neage.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Afa sa gafugag elbi sonaig gafugaba feageiba sa saglag elbi ehemba suialag onai? Ena gafa awai. ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Afa nengel gafa gwenaig, atiaba ne mungwali gawig esig awigibi, God sa nem sihinig, sa ne enaig esog kaba gafugag el ehe hwaig sa ka esigbi eba kangelni gafugag munguhe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Sisas Jerusalem minam patalfukuna, distrik Samaria gini afa Galili gini ena olyi ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Afa ika mungu kembig la pugunaba, afa ningam pugu fewagig el enehna ambe mina la uflin. ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Afa ambe membi yi afohieafnaba fwinam enaig esogona og, “Sisas saglag luwal sa ne kam aflafen.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Sisas nangwagnam enaig sihifeni, og, “Afunam pris elim nehegoni eba ati neana elig suialafeasaig sa ma enam anwenafi. Asa afuna afa afuafnaba ehengelni elig ati suiala feskofena.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Afa ehengelinai mungu heafna eligim nanguna ma suiala fenaba asa waikefe pese ikafnaba Godna unehlagim figi fukuna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Afa ehe ikan Sisasim muhla fenam asa mongkokini kwakwagena nofbosug mo bite la fisihli pena Sisasna kimugola. Afa sa Sisasim suialag ona. Enag elbi Samarianai. ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Afa Sisas enag elim nangunam afa esona, og, “10 pela el ati suialafeg afa mingnag 9 la gohug elbi hanai yi afohie. ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Afa mas amban el pese blog Godna unehlagim figi ofe mo? Afa hwag el mungu eba heafa afwamba nai el enag mungu eseg?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Afa Sisas ehem sihina, og, “Se buihia ika. Eba neana olug kam oniginag nem esenagba nem suialafeg.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Afa Farisi el Sisasim enaig sahnafini og, “Ansi sa Godna bog megba blofe?” Afa Sisas waikefe enaig sihifeni, og, “Afa maia Godna bog megba blogba afa mas mangwalba ogfuiba elbi mas nofnaba nangug mo? ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Afa mas enaigba esogoi, og, sa nangu hwa nai yi goh me awai okwe nanai yi me, sa hig Godna bog megba ati neana olug yi wagi goh fakanig.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Afa Sisas heafna patalfuiag elim enaig esoni, og, “Sumi yi maia enaig opugufiba nog ka Nufuna El heafna osuna blo puguiba ne enam mas nangufie. ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Afa sa nem sihigonfie, og, Nufuna Elbi okwesimhe amo hwa nai yi afa nofe ka patagafu. ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Afa ati ne afwe anwenafig afwe ofim mungwali molu kugofakagba asa of ombusig fakag. Afa maia heafna osuna oblofiba asa gwenaig eseiba sa el nangufie. ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Afa ilawo hwa nanam el maia ehem mas fatinibi afa sa kaksag susug flafe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Afa glawana sa Noana el esini haig haig nihefeagini, glawaga eba gwenaig esifie maia Nufuna El heafna osuna oblofiba. ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Afa glawana sa Noa wanafnaba enenaba ehengel enaig esini fane i bu i ahgafena afa angwafig lambwagifni, gwenaig gafugag la afohieafnaba Noa ehe mo sip megam wan seaifonaba asa sona elim mo bu pugu mungwali sagfla kumohlana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Afa mingnag elim gafa gwenaig eseni eba Lot gofnaba enenam, aso gafugafea gifini afa angwafig lambwagifini afa gawig gafugafifni afa bu ahgagifni afa lala nimblagifni enaig nihe la gofna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Afa Lot Sodom kembig fwaha ikafnaba afa gwenenam suwi oflanai pena, elim mungwali la kumohlana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Afa eba gwenaig mungwalofug pugufe maia Nufuna El pese blo ambala opugu fiba. ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Afa enag osuna el sa lala gofife mas heafna gawig lambigimba ikai, afa el sa aso la gofife eba mas lalagamba pese ikai. ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Afa sa ne Lotna angwagim onigim mangwal maia fena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Afa amban sa nibeafna nofkikena gagim ne nibefum kehla guhmine fefufe eba neana nofkikena gag awaiefe. Afa amban sa heafna nofkikena gag esug fwahafe. Eba ehena nofkikena gag gwese suialag gofufe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Afa ka nem osihin Nufuna El sa blofe. Eba el sa sambagana mungu kife la ahgi eba God ambani mo suluaflaiba afa ambani mo fwahafe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Afa angwafig sambaga amba na ahsine gofufe eba God mugom suluaflaiba afa ming mo fwahafe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","(Afa sambaganigi el aso la nog yihiwag ahfe gofufe eba God mungum suluia flaiba afa ming mo fwahafe.)” ");
INSERT INTO amn_amanab_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Afa patalfuiag el ena mo hignim Sisasim sahni, og, “Ainiyag hanai yi?” Afa Sisas enaig sihifeni, og, “Hanai yi suwieg ne nangug asa ne anwenafig eba suwi eyi lagi.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Sisas ming lasug mo patalfuiag elim sihinim afa betenegim ogfuni og sa ma wahkig beteneafufi masa esi yisgosife. ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Afa enaig sihifeni og “Afa Jas kembig la gafna ehe mas Godim onigina mo afa elim gafa mas fwina onigini mo. ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Afa sa angwafig mungu ena kembig la fena ehena alagagba ati lahana enag blofnam Jas elim sihinafna og sa ma kam kweagfui, ehe enaig esona og, ‘El kam amtanafeflig sa ne kam kot la kweagfu.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Afa Jas ilawana mo mas ehem kweagfuna mo afa sumi yi ehe enaig onigina og ka mas Godim oniginai afa elim gafa ka mas onigini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Afa enag angwafig kam wahkig kinig fafaiefgu. Naiba ka kweagfu, kam ehena mo higohugim yiskoseg, masa wahkig fablofe gofife.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Afa Sisas ming mo gwesim hilifena enaig sihifeni, og “Sa hwa mo higim amtakwalig Jas elni mom. ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Atiaho ne onigig? God ona heafna elim kwagani me? Enag ehengel wahkig osuna afa sinaini maisim Godim sahnafufba afa God mas yiskosei. ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Afa ka nem sihinig eba ehe ikagnam kwaganfe. Afa sa ma Nufuna El blonam nangwagi, bitenai el atiame olug onigig nafig me awai awai me?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Afa mingnag el onigig og eba suialag elba afa mingba mas suialafeg mo afa Sisas enaig lasug mo sihina, og, enaig el feg, ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Sambaganigi el ona Godna kwania lala beten ahfe. Elbi naba Farisi el i afa kig lambiule el i. ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Afa Farisi el gofnaba hefum beten ena, og ‘God ka nem suialag onag kaba mangwal mingnag el lofug mo. Mingnag elbi haig haig el ehe ugwefifug afa angwafigim alagag lanaim aga taitufegonaifu. Afa kaba mangwal sonaig el kig lambiule el lofug mo, kaba enaigba awai. ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Afa mungwali wik saikaba ka sambaga osunam sufu fwahagim afa ka fane kwegigi. Afa ka mangwalba flagim afa ka mimageg nem mungwa ehegenai faig.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Afa kig lambiule el mo membi yi gofnaba, ehe mas sisigam ninofena mo eba awai. Eba ehe ango mo wahginam enaig esona, og ‘God, kaba mangwal suialag el mo, kaba nufwehni amtakwalig el, sa ne kam aflafena.’” ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Sisas sihini, og, “Ka nem osihin kig lambiule elbi pese heafna lalagamba ikanaba eba Godna nofla suialag el fena. Afa ming elbi eba awai, eba enaig eseg, ambangel sa heafgelni unehlagim fingifig eba God ehengelni unehlagim pigaupenfe. Afa ambangel sa heafgelni unehlagim pigiupigog eba God ehengelni unehlagim figifugunfie.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Afa sa afahumonig luwal weitianigim Sisas nangum wanabena, fig ninganai luwal. Afa ehe apaiye afuiag luwal enaigim wanabena og sa ma Sisas ningabulni tutuhenugei. Afa patalfuiag el nangwagnim ehengelim fegonigini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Afa Sisas luwalim uneni maia ambe muhla ehem finibi afa sa waikefe patalfuiag elim enaig sihifeni og, “Nofe ne luwalimba kwagon ma ka nangum ambei afa Godna bog megba eba enaig elni. ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Afa ka nem nufunam sihinig afa amban el sa luwalna onigig lofeg fwainig eba mas Godna bog megamba seaifui.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Afa saglag el Sisasim enaig sahnafena og, “Suialag ogfuiag el haig sa ka esenam asa ka wahkig nofkikena gagba flafe?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Afa Sisas ehem enaig sihifena, og, “Mangigim ne kam suialag onag, eba God mungu he suialagba feg. ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Afa atiaho ne nihe moba anwenageg, og saglag sa angwafig nifig nofe ka aga taitufi afa elim kwagaitifi afa ugwefi afa elim mwakwalinim kotimini. Afa sa ne alag afagim ahnai skau fegonim afa ehengelni mom patalfugoni.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Afa saglag el enaig esona, og “Ati ka weiti la ena nihe moba patalfu blog, ka blog saglag la pugug.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Afa Sisas ena mo hignam afa ehem enaig sihifena, og, “Niasabam mangwal suwal sa nem awaienag, sa ne nibeafna mungwali gawig mingnag elim mimagenige asa ne kig flanam sa ne gawig fwainig elim ena kig mo faim ne enaigba eseiba eba ne hevenlanai suialag gawig flafe, asa kam patalfublu.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Afa saglag el enaig mom hignam ehem olug kiniagena enaba ehe sa gawig numbni fena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Afa Sisas ehena olug kinigim nangunam afa enaig esona, og, “Ambangel sa gawig numbni feasaig enaba Godna bog megam saiyegim ehem ehegepuseg feasaife. ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Afa kamelba tata lofug ona lofug kwelig nilni megam seaifu eba ehegepuseg. Afa gawig numbni el, Godna bog megam ona seaifu eba ehe fwinam gehig.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Afa el ena mo hignim enaig esogona, og, “Afa ma atiaba enaig esegba, afa sa amban ihlafenam asa nofkikena wahkig gagba flafe?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Afa Sisas sihini og, “Elbi haig esi mo, God eheba sa enaigba esei.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Afa Pita enaig esona, og, “Sa hig kagelbi ka kikeafna kembig i gawig i ka fwatigim ka nem patalfubieg.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Afa Sisas esoni, og, “Ka nem nufunam osihin ambangel sa Godna bog megim onigig eba naho heafgelni gawig i angwafig i luwal i afahumonig i afa nilite i enam fwatiagigim ambeg. ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","Afa maia hwa bite la maisim gofiba God kaksag gawig faife ena gawig eba gwesim goflanaim kwegfugkag afa maia sumi yi enaig puguiba asa el nofkikena wahki gag fife.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Afa Sisas 12 pela patalfuiag elim sulafunam afa sa enaig sihifeni, og, “Sa hig, glawo big Jerusalemgam afuofe. Afa enaba autunam Godna mo fli sihiafule el ati mungwali moba ginofi fwahini, og hwaig sa Nufunam Elim pugunafe, asa nufunam gwenaig pugu ofena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Afa eba ehem angoluwag elni ningala fwahibi asa ehem moalapinaginim afa mep kusufinife. ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Afa nasigna wena fliakilenaginim asa tigi fatife, afa eba maia sambaga mungu osuna feiba asa pese buihiafe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Afa God ena mom meagam kumohla gufna asa patalfuiag el enanam mas numwehi enag mog mom anwenafini mo. ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Sisas ika Jeriko kembig la opugufuaba, afa nofug hafinigna el mina ehbeg la gafnaba elim lofug kamini afa kig kamini fenigeaufna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Afa higinaba kaksag el moauf watini flaubluafna afa sa mingnag elim sahini, og sanaba mangwal ofi? ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Afa ehem sihini, og, “Sisas Nasaret la nai oblo” ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Afa sa Sisasim unena, og, “Sisas, ne Devitna simbianiga kam sa aflafena.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Afa mingnag el gosi ambe afuafnaba ehem fenagini og is mwalfwai gafim afa eheba fwinam amboitina unenam afa enaig esona, og, “Devitna simbianiga kam sa aflafena.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Afa Sisas gofnaba elim sihini og osum wanigambe, afa maia nofug hafinigna el ika muhla pugunaba afa sa Sisas ehem enaig sahnafena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Afa haig sa ne kam og kam sena.” Afa esona, og, “Ainiyag, ka enaig onigig kana nofug ma bahiai.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Afa Sisas ehem sihina, og, “Neana nofugba eba enaba suialafefe. Afa nibeafna olug onigig nem esenaiba asa nem suialafefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Afa sa ehena nofug gweyi ikagna bahianaba afa sa Sisasim patalfukunam Godna unehlagim figifukuna, afa mungwali el enam nangunim ehengel gafa Godna unehlagim figifini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Afa Sisas ika Jeriko kembig pugunam ikafnaba ona Jerusalem kembig gam ika. ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Afa el mungu ena kembig la gafna ehena unehlagba Sakias eba kig lambigule elni misog el afa ehe kaksag kigna fena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Afa enag ona Sisasim nangu, og, haig el maia, afa maia kaksag el Sisasim kagfunibi gihwagegohun haiseg nangwag mo. Eba teimona el fena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Afa sa gof ikanam fik liyi fukonam gafna ogna Sisasim nangu, ati anwenafena, og Sisasba hwa mina blofe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Afa Sisas ika enanai yi pugunam asa liim fahigeagena maia Sakias gafnaba sa Sakiasim enaig esona og, “Sakias, au ikagna peblo glaba ka neana lalagam ahkagim.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Afa ehe ikagna penam. Afa sa ehena olug afgigeafnaba asa Sisasim suluflana lalagam ahkana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Afa mungwali el nangwagnim heafgelni olug yi enaig esogona, og, “Ei, sonaba amtakwalig elni lala ika ga.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Afa ahka lala hawagfnaba asa Sakias buihianam enaig esona, og, “Ainiyag sa hig, ming gehnai ka elim gawig fwainigim mimagenifie. Afa gawig sa ka ukwefen kafna eba ka pese sambaga sambaga fenfe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Afa Sisas ehem enaig sihifena og, “Ilawo God ati hwa lalanaiba mungwali elim lambig. Sona el gafa eba Abrahamna luwalig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Nufuna Elbi eba el sa awaie saieg enam yisigin blog ona pese lambim.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Afa maia Sisas mo sihiagofnaba el ena mo higafufna, afa sa Sisas lasug mo enaig sihifeni, og, eba ati Jerusalemgam ika puguagim muhla fena. Ehengel onigini og, eba Godna bog meg ambala ikagna pugufe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Afa Sisas enaig esona, og, “Saglag el sa ona membia kembig gam ika eba enanai yi sa el ehem misog el fwahife. Afa nengigimba eba pese blonam asa heafna kembigim nangwaghiagefe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Afa maia akofiba eba heafna gafugag elim ningam pugufewagig enaig elim unetiginam asa kig mimagenim afa sa enaig esonfe, og, ‘Ena kig ne lambinim asa ne gawig enena gafugafeagi maia ikan enanai yi feiba ka sa pese blo.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Afa heafna kembig lanai ehem olug fwinam kagagenagini. Afa maia ikanaba afa sa mingnag el ningitigini, og ma afu mo sihi, saglag el sa ikag ena kembig asa enaig sihifife og, ‘Kam oksig masa sonag el kagelni misog el fefe.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Afa maia misog elim fwahiniba asa pese blona ehe blonam enaig esona, og gafugag elim unegon autunam sa ka kig faini enag koka anwenafe hanansi kig mungu mugog el mungwali kikig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Afa mungu el gose blonam enaig sihifena og, ‘Saglag luwal, neana kig sa ka flag enena gafugafegba ka 10 kig gwesim hilig flag.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Afa misog el ehem enaig esona og, ‘Ne suialag gafugag el ne suialag gafugafeg. Ne weitiaklugim ninumwehea flagba pugu kwaniafeg ka nem fwahaiba sa ne ningam pugufewagig kembigim nangwaghiage.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Afa angigieg gafugag el blona enaig esona og, ‘Saglag luwal, neana kig sa ka flag enena gafugafegba ka afala pugufeg kig gwesim hilig flag.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Afa sa misog el ehem sihina, og ‘Ka nem fwahaiba sa ne afala pugufeg kembigim nangwaghiage.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Afa ming gafugag el blonam enaig esona og, ‘Saglag luwal, neana kig sa ka flag enaba hoka ka lofugna kikegim faka fwahag. ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Naigba ka esegba eba ka nem enaig anwenafenag ne wasneig mo sihiaule el nafeg. Afa maia mingnag elbi mangwalba fakigbi afa ne faflafe. Afa maia mingnag el fane ihwagigbi afa ena gafa ne faflfe. Enag sa ka embefeg.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Afa misog el ehem enaig sihifena, og, ‘Ne gafugag el amtakwalig nibeafna moala ka nem kotim enafe. Ati anwenafeg kaba wasneig mo sihiaule el afa kaba ambangel sa mangwal sukug enag ka lambig, afa ambangel sa asona fane ihwagig enag ka lambig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Afa ne enaig esete sa ne kana kigba benk la fakate. Koka pese blonam asa ming moni nahlum gwesim hilifeg fla?’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Afa el muhla afohiafnaba asa enaig esona og, ‘Nengel sa ne ehena kig lambig sa ne faim el sa 10 kig feg.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Afa enaig esogona, og, ‘Saglag luwal sonag elbi ati 10 kig feg.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Afa esona og, ‘Ka nem osihin mungwali el sa mangwalna feasaieg eba ka mingnag pasinfe afa ambangel mangwal lambig fwainig awaieg afa weiti kiki lamfu eba ka mwehla fatinafe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Afa sonag angoluwag el sa kana afohie ehe mas ka misog el gofugum membig mo enam lambinim wanambanam kana nofla kwagilaiti.’” ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Afa Sisas enaig lasug mo sihi fwahanam asa ehe mo Jerusalemgam ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Afa Sisas ika Betfage afa Betani kembig oliv mug muhla ofenaba. Afa sambaganigi patalfuiag elim ningitigina. ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Afa onigitigifnaba enaig sihifeni, og, “Afa ne ena kembig ika ahpugunam afa ne ahnanguiba donki lambag weana kikeagig fwahig mas amban enanai yi pegana mo asa ne wemo ahpigina sa ne osum ahwaniblu. ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Afa ma atiaba nem ambanba sahtigiba ‘Mango ahfe?’ Sa ne enaig sohona, og, ‘Ainiyag oka enena gafugafe.’” ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Sisas enaig sihifenugenam asa ningitigina afa ika ahnangunaba gwenaig eseagena mo sa sihinwagenaba. ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Asa wemo donkina nihinai ahopigifnaba afa sa donkina alag ehem sahtigina og “Mangigim ne donkina nihinaiba weaba ahpigig.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Afa ehenigi ehem ahsihina og “Ainiyag enena gafuga ofe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Afa sa ehenigi lofug mo heafgina ahug funam donkina kigibugi yi ahskonam asa ahwani bluna Sisasim og ma enanai yi fuku gai. ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Asa fuku ganam ikana, afa maia akofenaba el heafgelni nihi lofug hugfuhiahlaginim mina la skoafuna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Afa ma blo oliv mug mina la pugunam enam fwahia pe akofenaba afa sa kaksag patalfuiag el sifakaligna ambeafnaba Godna unehlagim figifini enaigba esinibi eba mungwali wasneigim sa nanguni. ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Afa ehengel enaig esogona og; God sa ma sonag misog elbi suiala feaflai, Godna unehlagim sisigam nemug figifi. Afa heven la nai el sa ma safakali. ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Afa mingnagba Farisi el enanaiyi saiye afohiafna ena mungwali afunam Sisasim enaig esuni, og, “Tisa, sa ne kwenim sa ma sonaig esigim fwahi.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Afa Sisas wahgi enaig sihifeni, og, “Afa eba mwalfwaibi afohiefiba, afa sa sona funba Godna unehlagimba figifi.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Afa Sisas blo Jerusalem muhla pugunam ena kembigim nangunam ufwena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Afa ehe og, “O Jerusalemnai el niasabanig ka membig gla ne anwenafi mangwal sa ma nem suialafeni, eba meagam goh. ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Afa nengigimba neana angoluwag el ambenam nem wagigonam minam kagwakafe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","God sa nem oblon eba ne mas anwenafig mo asa angoluwag nem ambe nugwakale klaitife afa kembig la nai luwalim gafa gwenaig esegonfi. Afa mas mangwalim ga mo fwahi.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Afa Sisas Godna Kwania lala sefukanam gawig gafugag elim ningitigifena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Afa ehengelim enaig esoni og, “Godna mom enaig esog og, ‘Kana lala eba Godim beten nenag lala afa ne enaig esigbi ofenaiba ukwefelni laskuhlag lala.’” ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Afa mungwali osuna enanai yi Sisas elim ogfu fenugena. Afa sa saglag pris i, nihemo anwena el i, afa saglag el i enag one ehem tigifati. ");
INSERT INTO amn_amanab_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Afa mungwali ehena mom fwina membeni nasa sonag elni minam kikisegoni asa mas Sisasim tigifatini mo. ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Afa enanam Sisas Godna kwania lala la elim ogfufenugenam afa Godna suialag mo sihini. Afa saglag pris i, nihe mo anwena el i, afa saglag el i enag ambe ogna ehem nangui. ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Afa ehengel Sisasim sahini og, “Hanai ne wasneigbi flag afa amban nem faig?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Afa Sisas wahigi sihini og, “Sa ka nem sahin sa ne kam sihini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Amban maia Jonimba bula laitiag gafugaba wasneigbi faina eba God me awai el me?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Afa ehengel afunam hefum sihiagini og, “Haig mo sa big sihifi. Afa eba big enaig sihifibi God ehem wasneig faig. Eba bigim enaig sihinfenfi og Haig segba sa ne mas Jonna moba higigim patalfug mo. ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Afa eba big enaig sihifibi eba el ehe ehem wasneig faig. Eba el bigim funna nugwakale klaitifi ehengel enaig onigig finim og eba Jon Godna mo fla sihiaule el God ehem ninghiag.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Afa sa ehengel pese Sisas nangum afunam enaig sihifini og, “Kangel ka mas anwenafig mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Afa Sisas ehengelim sihini og, “Kanga ka mas nem sihini amban sa kam wasneig faig.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Afa Sisas mungwali elim enag lasug mo sihini og, “El aso gafugafegim afa ehe mo membi kembig gam akofenaba heafna aso mo nangwaghiawagig elni ningala fwahanaba og sa ma asom ninumwehe fugufi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Afa ika enanai yi gan maia asonai fane fug lugonaba asa heafna gafugag elim ningitigina og sa ma afu ehena asonai fane lambi. Afa nangwaghiawagig el enag elim tikaminefenam pese esug ningihiana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Afa maia pese ika esug pugunaba afa asona mog ming gafugag elim ningihianaba afa ehem gafa gwenaig esena tikamine fenam amtakwalig mo sihinagenam pese esug ningihiana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Afa maia ika esug pugunaba afa ehe ming gafugag elim ningihianaba afa ehem gafa gwenaig esena tige nugwakale flanam afwambagam flafatina. ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Afa sa asona mog enaig esona og, ‘Haig ka esefe. Naiba ka kikeafna luwalim ningihia, ka ehem fwina membenag. Eba ehena mo higi me.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Afa maia nangwaghiawagig el legim nangunim hefum sihiawagini og, ‘Sona asona mogna luwal oblo. Na tigifatinim asa big aso mo fli.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Asa ehem fli aso afwambagam ningihini asa tigi fatini.” Sisas sihi fwahanam afa ming mo sihini og, “Asona mog ehengelim sa haig esenifi? ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Afa eba blonam sonag elim kwagi klaitinam asa aso mo mingnag elim faifi.” Afa maia mungwali el ena mom higinim enaig esogona og, “Masa enaig pugufe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Afa Sisas nangwaginam asa enaig saheni og, “Afa haig mog mo maia Godna molaba goh. Afa enaba enaig esog; Ena sumulba lala nimblawagig el esugum fli fatig eba naho God esenagba asa sumulbi gohug. ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“Afa amban enag aga laba peba asa ehem tigia fwatife. Afa aga ambanim penam ehem piga fakafe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Afa nihemo anwena el i, afa saglag pris i ati anwenafini enag lasug moba ehengelni amtakwalig onigig upuguni. Asa ogna Sisasim kehli afa ehengel mungwali elim embefegoni. ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Afa sa ehem numwehenaginim asa elim ningitigini og sa ma Sisasim mwakwalinibi asa ehem moalambini sa ma gavman na ningala fwahi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Afa sonag el Sisasim sahini og, “Ogfuiag el, kagel ati ka anwenafig neana moba nufunam afa ena nufunam moba ati ne elim Godna mina ogfu fenigeg, afa ne mas onigi ne gauna haig haig elim gafa sihinag feg. ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Sa kam sihin, bigna nihe mo atiaho enaig sihifeg sa big kigba Romna misog elbi fai me awai awai me?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Afa Sisas ehengelni mwakwal onigigim anwenafenim afa esona og, ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Sa kam kig ogfuni. Amban na nofbosug i unehlag i asa enanai yi go?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Afa esogona, “Sisar Romna misog el.” Asa Sisas sihini og, “Afa Sisarnaba asa Sisarim fai afa Godnaba asa Godim fai.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Afa ehengel mas ehem enaig klimoan mo mungwali elnai yi fini mo. Eba ehengel sineminefinim mwalfwai auguiafna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Afa mingnag sadyusi el Sisasim nangugum ambena. Sadyusi el enaig onigini og melig pigieg elbi mas buguagafei. Afa Sisasim sahini og, ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Ogfuiag el, Moses enaig sihifena, afa el luwal fwainig lahagba heafna sumineg sa ma ehena esig angwafigbi flai asa ma luwal etegna sigagla unehlifi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Afa autunam elegeg la gohug nilete ka afwaihiafena. Eteg angwafig flana maia lahanaba luwal fwainig. Asa esig angwafig agafena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Afa ehem angigieg flana afa ehem gafa luwal fwainig lahana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Afa olyi nai flana gwenaig esena ehem gafa lahana. Asa gwenai pigi feakan ikan sumineg ne mog la puguna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Afa sumi yi enag angwafigim gafa lahana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Afa autunai la maia enanam melig pigieg buguagafeiba asa ehe ambanna angwag fefe afa mungwa niletena enag angwafig mungu flini?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Afa Sisas enaig sihifini og, “Afa glaunai el sa ne angwafig lambig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Afa saglag i angwafig i melig pigieg buguiagafegim eba ihla fifi afa sumi yi sa feg enenaba mas angwafig lambi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Afa eba ehengel Godna oflanai el lofifi mas pese pigi. God ehengelim ilafo laitiba asa ehengel Godna luwalig feskofefe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Afa Moses gafa gwenaig ogfufeg God melig pigieg elim ilafo laitigba asa ahnabugo li suwi lagigna mo Moses enaig sihifeg og, Ainiyagba eba Abraham, Aisak, afa Jekop na God. ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Afa enaba ogfug eba ehe mango melig pigieg elni God mo, eba heafa nofkena elni God. Afa sa ehengel ehena nofla ati nofkena gag feasaieg.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Afa mingnag nihemo anwena el og, “Ogfuiag el neana mo sihiagba eba suiala feg.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Afa enenam mungwali el ehem ming mo sahinigim oksini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Afa Sisas sahini og, “Haig segba el enaig esogog El God Gisfu Fwahag eba Devitna simbianiga? ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Afa Godna buk la Devit ehe enaig esog; God Ainiyag Kana Ainiyagim sihinag sa kana nihiginai ninga la pegafim ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ikan ikan ka sa kike neana fagiule elim tigfeskonam asa ka nem faife. ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Afa Devit ehem seaflana, Ainiyag. Haisegba enag ehe Devitna simbianigaba feg?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Afa el Sisasna mo higafufna maia patalfuiag elim osihifinibi og, ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Sa ne numwehifibi nihe mo anwena elni enaigim. Ehengel enaig membig ogna heafna beten lofug wagwaginim asa afu. Afa ehengel fwina membig og sa ma kam enaig suwigi saglag el. Afa bu yis la ehe ogna misog el lofug augu afa laskuhlag lala ehe ogna sime suialag la gose augu. ");
INSERT INTO amn_amanab_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Afa ehengel bontag angwafigim mwakwale gonigim afa ehengelni lala lambigonig. Afa enaig esigim afa ehengel mwakwalig kwinam beteniaska. Afa enanam God kwefihiage ofefiba asa enaig elim kwania susug faifi.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Afa Sisas nangwahiage nangunaba kaksag kigna el Godim kig faini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Afa nangunanaba bontag angwafig gafa eba sambaga kig weti klug Godim faina. ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Afa Sisas enaig esona og, “Ka nem nufunam sihinig sonag angwafigbi eba kig fwainig, afa enaigba fainaba eba ehe numwehe gwesim mingnag elim hili fenig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Afa mingnag elbi eba kigna feasaina afa ehengel hefum mo lambugafufnaba afa Godim mo mungkwehegenai wetia klug faini. Afa sonag angwafigbi eba kig fwainig fena afa eba wetiaklug kig mungu fanena maugum ugufna enag gwesim Godim mungwali faiena.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Afa patalfuiag el mingnag enaig onigig fini og, Godna kwania lalaba eba suialafegim afa fun i wag i fwinam suialafiageg. Afa Sisas enaig sihifena og, ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Glau ne mungwali enag fun lalam ne nangug, eba mas gofi. Nengigimba angoluwag ambefe funim titoitifife afa sa mungwali bite la apaiyefe afa mas mungu gofi.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Afa ehengel sahini og, “Ogfuiag el, ansi sa enaigba pugufe? Afa sa mangwal puguiba asa ka enam nangufi afa enaigba kam ogfunig eba amtakwalig osuna puguiagim ati muhla ofe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Afa Sisas sihini og, “Numwehifibi masa el nem mwakwale gonife. Afa kaksag el ambenam kana unehlag la mwakwale afwaihenam esogofe, kike Kraist God kam kanog fwahag afa gwesim ming mo enaig sihi fife og enag osuna ati meyi ofe. Nofe ne ehengelim patag afu. ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Afa enenam ne higibi mingnag kantri hefum hagkafufe afa nofe ne embefi. Sonaigba eba gof opugu afa awaieg osunaba eba maisim sumi yi fe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Afa ehe gwesim ming mo sihina og, “Afa kantri hefum hagkafufe afa misog el hefum hagkafufe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Afa haig haig bite eba asag i kwania bini i, afa kinig i puguiagefe afa mangwal amtakwalig bite la puguiafi afa of la puguiafi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Afa enaig puguia fwainig maisim fefiba el nem lambinim kinig faigofe. Afa ne kana el afwaihiefiba eba lotuni misog el nem kwefihian nugenam asa kalabus lala lambi laitife. Afa nem Gavman i misog elni ningala fwatibi asa ne ehengelni nofla afohiefufe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Enaba enenai yi sa ne ehengelim Godna mo sihigon. ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Afa sa ne numwehe onigim nofe ne fwinam onigwaginim enaig esogo mangwal mo sa ka sihigonfe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Afa eba kike nem kwaganam afa nengelni mengig laba kike sihife afa ka nem suialag onigig faiba afa sa angoluwag mas ena mom flafui. ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Afa nembiafgelni afahumonig, nilete, mungwa usmuna, afa hihe enag nem angoluwagna ninga la fwatibi asa mingnag nem kwaskofife. ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Afa ne kana el afwaihiefiba asa mungwali el nem olug kakagegonife. ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Afa mas nengelni lapug mungu amtakwale. ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Afa atiaba ne wasneigbi eba ne nofkikena afohiefufe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Afa Sisas sihini og, “Afa maia angoluwag el ambe Jerusalemim mugi yi pugu fakafiba sa ne nangufe eba sa ne anwenafi enaba ati amtakwaligim ofe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Afa maia enenam ofefiba asa Judia nai el ikagna mug gam embem ikafe. Afa kembig la nai el kembigim ikagna fwahinim afuna afa sangwali nai el nofene kembig gam afu. ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Afa enaig osuna God ehengelim amtakwalig susug afai. Afa enaigba esegba eba Godna nufunam mo ati enaig sihifeg. ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Enanam amtakwalegefe angwafig afnialigni afa angwafig weti luwalna. Afa eba fwina amtakwalig hwa bite la pugufe afa enenam God sonag elim olug kakagenugefe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Afa mingnag elimbi angoluwag el kwaskofife afa mingnagim mungwali kembig kalabus lala lambi aitiafufe. Afa afwambinai el Jerusalemim numwehefufufe. Afa gwenaig esifi ikan heafgelni enag osuna awaiefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Afa Sisas sihini og, “Afa maia enenam enaig ofefiba asa mangwal haig haig puguiagefe asa osu i, was i, afa bagnafut i enanaiyi eseagefe. Afa bitenai el mungwal enam oniginim afa sa olug wahige skofefe afa maia bu kwaniana mwagim higinim asa nangufi maia bu kwania mimewe blo humu ofiba asa embefeagifi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Asa el fwinam embefeagifi maia sumi yi mungwali bitem enaig puguiagofefiba asa mangwal oflanai heafgelni kifeg fwatiagi ahkawag minefefe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Afa enanam ehengel Nufunam Elim nanguiba sisi yi leango la kwania wasneigni afa kwania ombusugni wahe blofe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Afa maia enanam enaig ofefiba afa sa ne olug fwina wasneiye skofe eba God nem lambigim muhla ofe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Afa Sisas ena lasug mo sihini og, “Sa ne fik li afa ming li nangwaginim asa ne onigim. ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Afa maia li figeg yiminig pugufe asa ne anwenefi eba suialagnam meyiofe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Gwenaig esefe maia ne nanguibi asa mungwali puguiagefe sa ne anwenafi eba Godna bog meg muhla blo meyi ofe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Ka nem nufunam sihinig afa enag el maisi afofiba asa mungwali enaig puguiagefe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Of i bite i mungwali awaieba afa kana moamo wahkig gwese gofufe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Afa Sisas enaig sihifeni og, “Nengel sa ne numwehifim. Nofene buyisifi afa uflogna bu ahgagifi afa fwinam onigwageafufum. Masa enag osuna ikagna nem pugunifie. Afa ne mas numwehiagig mo. ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Afa enag osuna mungwali bitenai elim ikagna pugunfi ofenaiba sis bume la apaiyofe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Asa ne numwehi afohiafiba sa ne Godim wahkig sahna fufum sa ma God nem wasneig faibi sa ne enaigim kwegfu afu, eba ne Nufunam Elim nangunim afa ne mas ehem afwane fini.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Afa mungwali osuna Sisas Godna Kwania lala la elim ogfufenugena afa osu pegnam ehe afwamba gam pugu ika oliv mug la sinaini gofena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Afa mungwali el ogna leana gubi Godna kwania lala gam ambenam Sisasna mo higim. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Afa enanam Ju elni pasova buyis meyiofe fenaba sona buyisba seflig bret yist fwainig buyis. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Afa sa saglag pris i afa nihe mo anwena el i ogna Sisasim tigi fati afa sa ehengel mungwali elim embefegoni. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Afa enanam Sisasna patalfuiag el mungu ehena unehlagba Judas Iskariot, Satan ehena nihi, sefuna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Asa Judas saglag pris mi afa Godna Kwania lala anwasag el mi ika nangwagenam og, haig sa ka esenam Sisasim nengelni ninga la fwaha fe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Afa enag el sifakalinim asa ehem enaig esoni og, “Eba ne enaig eseba eba ka nem kig faifi.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Afa Judas ehengelni mom sawifenim afa mina yisiginam afa maia kaksag el awaienaba asa ehe Sisasim ehengelni ninga la fwahafe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Afa enanam Bret yist Fwainig buyis ati puguna. Enag osuna el sipsip luwalig kwaginim asa Pasova buyis la ahgagini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Afa Sisas Pitami Jon mi sihinugenam asa ningitiginam og, “Sa ne ahkanam bibeafgelni fanem ninumwehiagafeba afa sa big ena Pasova buyis ahga.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Eheningi ehem ahsihina og, “Hanai yi ka numwehiagafefe?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Afa Sisas sihini og, “Sa hig, afa ne ahkanam kembig la ahsefunam afa sa ne elim ahuflafe maia bu ubluiofiba sa ne ahpatalfuku ma lala la osefufiba sa ne sefuahka. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Afa lalana mogim ahsihina og, ‘Ogfuiag el enaig saheg og, hag mengig megam sa ka kikeafna patalfuiag elim wanefe.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Afa eba enag el nem ogfunifi eba kwania mengig sisi gam go. Ena mengigba ati ninumwehiage go enanai yi sa ne faneba numwehiage ahfe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Afa patalfuiag el sa enaigim ahnanguna maia Sisas ena mo fainibi afa sa enag faneba numwehiage ahfena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Afa kwekwe watini Sisas 12 pela patalfuiag elim sime la wan pegnam fane wanena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Afa ehe enaig esona og, “Ka fwina membeg ena Pasova buyis nengelim koka nem wane afa sa ma kam sumi yi susugba pugunai. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ka nem sihinig ka mas pese ena buyisba ne eba ikan ikan maia Godna bog meg ena buyis mog nemug faiba asa ambala upugufe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Afa sa Sisas bu kapna flanam Godim suialag onam asa enaig esona og, “Hwa bu flinim asa nimbefum mimangi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ka nem sihinig ka mas ena wain bug pese nei eba ikan ikan asa Godna bog meg eba pugunam blofe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Afa sa amba flanam Godim suialag onam asa kukosko fenam mimangeni asa enaig esona og, “Hwaba kana lofug, ka nem faig koka nem kwaganim, sa ne enaig esi kam wahkig oniginafufim.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Afa maia ahganaba asa ehe bu kapna flanam gwenaig esena ehengelim mimangenim afa sa enaig esona og, “Hwa buba eba kana taf, ka sugfenam asa ka lahafe. Ena tafba ese fwahag eba Godna mulug mo sihi fwahag. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Sa hig! Nengelnai amban mungu ka wan one ehe kam ikanam elim mwaunfe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Autunam God sihi fwahana mango mina sa Nufunam Elbi lahafe afa sa sonag el ehem elim mwaunufe eba niasabam.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Afa patalfuiag el hefum sahwagini og, amban bigelnai sa enaigba esefe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Afa patalfuiag el hefum moanagini og amban sa ehengelnai gosig elbi fefe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Afa Sisas ehengelim sihini og, “Afwambanai elni misog el ehe fwinam wasneiageg elim nangwahiagegba. Afa el ehena unehlagim fingifigim afa seflig og sonaba elni hihe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Afa Sisas enaig esona og, “Nofene enaig esi. Amo, eba amban sa nengelinai gosig el feg eba sa ma sumi nai el lofei. Afa amban sa nengelinai misog el feg eba sa ma esug gafugag el fei. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Afa amban el sa fane neauwug afa amban el sa fane numwehiageg blug enaba amban sa gosig? Eba el sa fane mungwaug la neau eba naho gosig elbi feg. Afa eba ka olyi fenam asa ka esug gafugag el lofefe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Afa maia kam kinigbi pugunagba afa ne mas kam fwahai. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Afa kana alag kam heafna bog meg faig asa kanga gwenaig esefe ka nem faifi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Afa ne ambenam kana bog megam fane i bu i ka nem wanefe. Afa ne misog elni pegag sime la augunam asa ne 12 pela Israel elim nangwaghiagifie.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Afa Sisas Pitam sihina og, “Saimon sa hig, Satan Godim sahnag ogna neana olug onigigim yuhna. Asa ofenaiba efef liim fe safla faka ofefla. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Afa ka neana olug onigigim Godim sahnaiba eba mas neana olug onigig fwahie. Afa maia ne pese bloiba eba sa ne nimbiafna nilitem ehengelni onigigim fwaki lasanfe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Afa Pita higi enaig sihifena og, “Ainiyag, afa ne kalabusiba akofiba big mungwal ahkafe. Afa nem tigi afatifibi eba sa ma kam gafa tigi fati. Ka mas embefei.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Afa Sisas ehem sihina og, “Pita ka nem sihinag enaba gla sinaini kakaruk mwasiag fwainig fefiba asa ne sambaga mungu nagim esofe ne kam mas anwenafenag mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Afa Sisas patalfuiag elim enaig saheni feni og, “Afa maia ka nem ningitigiba ne mas kig wula na, wula, afa mong lofug enaig ne lambug afufe mo. Afa mango maia nem tumenig?” Afa sa ehengel wahigi sihini og, “Amo, eba awai.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Afa ehe esoni og, “Afa ne enaig fegba sa ne lambig afu. Afa amban ne kasu fwainigba sa ne nimbiafna lofug el fainam asa ne kig enananam flanam afa kasu sa ne lambim. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Afa Godna mo ati sihi fwahana eba nufunam kam enaig pugunafe. Godna mo ati enaig sihifeg og eba el enaig onigigfig og eba ehe el amtakwalig. Ei, eba nufunam kam fenafe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Afa patalfuiag el sihini og, “Ainiyag, sa nangu kangelbi sambaga kasu feg!” Ehe og, “Eba magwese.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Afa Sisas Jerusalem kembig fwahanam gwenaig ese gofna oliv mug gam ehem patalfuna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Afa enanai yi apukenam afa sa enaig esona og, “Sa ne Godim betenini eba neana olug onigig mas tigefupei.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Afa ehe ehengelim fwatinam gwesim mwakwalig hilife ikanam asa mongkokini kwakwagenam afa sa beten enam og, ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Kanapi ena kapteba sa ne kana ninga la nai mwehlai. Asa nofene kana membug la ese afa eba ka sa nimbiafena membug la ese.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Afa oflanai el ehem pugunam afa sa ehem wasneinagena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Afa kwania kinig ehem gohnagenaba asa ehe fwina beteniafnaba ehenge ehena nihi pugu penafena ofenaiba taf. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Afa betene fwahanam asa pese patalfuiag elim ningwagna ikana afa ika nangwagenaba ehengelni olug kinig skofenaba asa ehengel non aska fena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Afa ehe ehengelim enaig esoni og, “Haisegba sa ne non aska? Afa sa bugia gafenam beteni masa neana olug onigig tigefu penfie.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Sisas maisi mo sihi gofenaba afa sa kaksag el flaublunam. Afa sa Judas eba patalfuiag el enag ehe gose ika mina ogfunim, afa blo Sisasim muhla fenam ona ehem asanktata fiahfla. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Afa Sisas ehem enaig sahna fiahflana og, “Neho nog Ka Nufunam Elim asanktata fiahflanam asa angoluwagna ninga la fwaha?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Afa patalfuiag el ati anwenafini el ogna Sisasim kehli asa sahini og, “Ainiyag ne membegba ka sa kasuni hagim?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Afa sa ehengelnai mungu kasu skoflanam prisni misog elni gafugag elim nihiginai angum higeflaitina. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Afa Sisas enaig esona og, “Magwese fwaha!” Afa sa Sisas ehena angugum ningana pese gabahlana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Afa saglag pris i, anwasag el i afa saglag el i ogna ambe Sisasim kehli asa Sisas ehengelim enaig sihi feni og, “Ne enaig onigig Kaba ukwef el ho feg na ne kasu na malu na fla blug kam flig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Afa mungu mungu osuna Ka Godna Kwania lala ikafenam gafenaba afa enanam ne mas kam flini mo. Afa nag ilawaba eba enanam ne kam esofini. Afa enanam si kifiagim filafe fatife.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Afa sa Sisasim kehlinim misog prisni lala gam wanigafuiafnaba afa Pita sum kiniafwaha fiahkafna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Afa el lala bog muhla olyi suwi wehlinim enanai yi auguiafnaba Pita gafa ika nanai yi gafena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Afa gafuga angwafig angwaming ehem suwi ombusugi fahigeflam asa enaig esona og, “Sonag elbi eba ati Sisas i safeakfna.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Afa Pita esona og, “Angwafig ka mas ehem anwenafenag mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Afa managig fwainig ming el blona fahigeflanam afa gwenaig esona og, “Ne gafa ati ne mungwal safeakafna.” Afa Pita esona og, “Amo, kaba mas ehiba sahfeakafna mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Afa mwakwalig afohiafenba afa ming el gwenaig esona og, “Eba nufunam ehe sonag elbi eba Sisas i sahfeakafna enag ehe gafa Galili lanai el.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Afa Pita esona og, “Ka mas anwenafeg mo ena mo sa ne esogba.” Pita enaig sihifegofnaba afa gweyi ikagna kakaruk moasiyinaba. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Afa Sisas wahigifenam Pitam nangwagofenaba. Asa Pita pese ena mom oniginam Sisas sa ehem sihina og, “Maia maisim kakaruk moasiag fwainig fefiba ne sambaga mungu nagim esofe ka mas ehem anwenafenag mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Afa asa afwambagam pugu ikanam nugwakal ufwe feagena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Afa anwasag el Sisasim kehlinim amtakwalig mo sihinaginim afa tikaminefini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Afa ehengel Sisasim nofugim lofugna kagfunim asa sahnagini og, “Neaho Godna mo fla sihiaule el sa ne kam sihin amban el nem tigikafu?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Afa ehengel mingnag kaksag molamp mo faini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Afa leana gubi yi saglag el i, saglag pris i, afa nihemo anwena el i enag ambe laskuiahlanaba asa Sisasim ehengelni nof la wanig ambena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Afa sa ehengel Sisasim sihini og, “Sa ne kam sihin neaho Kraist God nem Gisfu Fwahag?” Afa ehe wahigi enaig esona og, “Ka nem sihinibi ne mas kana mo higi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Afa ka nem sahtigiba afa ne mas kam kwegfug lagini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Afa glau fenam afa ikan autunai la fefe eba Nufunam El ehe gosig ikanam wasneig God ena muhla pegafufe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Afa sa mungwali el ehem sahini og, “Neaho ne Godna leg?” Afa ehe sihini og, “Ei, eba gwenaho, ati ne sihig.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Afa ehengel esogona og, “Mangofi eba mingnag el ati ehem sehig. Eba ati ka higig eba heafna moala.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Afa sa enag mungwali el Sisasim Pailat nangum wanig afuna, eba Romna misog el. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Afa sa ehengel Sisasim sehini og, “Sonag elbi og na bigelni kantrim filafefati. Ehe elim ogfunig og masa kig Romna misog elim faifi. Afa ehe enaig esog og kaba Kraist kike misog el feg.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Asa Pailat Sisasim sahna og, “Neaho ne Ju elni misog elbi feg?” Afa Sisas esona og, “Ei, gwenaho ne sihig.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Afa sa Pailat saglag pris el mi afa mungwali el mi sihini og, “Sonag elbi mas haig eseg mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Afa ehengel fwina olug wasneigni esogona og, “Amo, eba heafna mo Judianai elim olugim fwaki lasaneakag. Enaba Galili la pugugim blog wanai yi pugug.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Afa Pailat ena mo higinam asa sahtigina og, “Sonag elbi eba Galili lanai ho maia?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Afa ehe enam ati anwenafena afa enaig onigina og, Herotba Galililanai elim nangwaghiageg el feg afa enag glawaba Jerusalem la ga. Asa Sisasim esim ningihiana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Autunam Herot ati higina Sisas kigmog ogfunaba enam ona nangu asa ehe Sisasim nangunam maia blofenaba asa sifakalena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Afa sa ehe Sisasim fwina sahnagenaba afa Sisas mwalfwai gofena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Afa sa saglag pris i nihemo anwena el i bugiaga fenam asa Sisasim fwina sehini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Asa Herot fena afa heafna soldia apaiyena Sisasim molamp mo fainim nugwakale flini. Afa misog elni lofug ehem fatinim asa Pailat nangum pese ningihini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Autunam Herotba Pailatna angoluwag el fena afa ilawaba ehe hihe ahfeg. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Afa sa Pailat saglag pris i, saglag el i, afa mungwali el mi unetigina og ma ambe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Afa ehe ehengelim enaig sihifeni og, “Sa ka sonag elim wangig ambena ofenaiba haig haig el lofeg. Afa ka mungwali elni nof la fahigenagegba mas ka ehena haigim nangug mo. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Afa Herot gafa gwenaig onigig fenam asa pese ningihiana. Sa ne anwenafi hwa elbi mas haig eseg mo asa ka onigihiaba sa ne tigifati. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Afa sa ka ehem wena fliakilenagenam asa fwaha.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Enanam Pasova buyis la ehengel ogma ambanim kalabus elim membinibi asa Pailat mungu elim fwahafe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Afa mungwali el mungwa mengna esogona og, “Sonag el mo tigifatibi afa Barabas mo ningihia.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Autunam Barabas eba kembig la maluna penim afa sa elim tigefatina enaig esenaba asa ehem kalabus yi flifatini.) ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Afa Pailat ona Sisasim fwaha asa elim enaig pese sihi feni. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Afa mungwali mungwa mengna fwina esog ona og, “Sonag elimbi li katigeg la kukufenagi! Sonag elimbi li katigeg la kukufenagi!” ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Afa Pailat pese ehengelim sihini og, “Haiseg! Mango maia fegba. Afa ka mas ehena haigim nangug mo eba ka ehem wena fliakilenagenam asa fwaha fe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Afa ehengel fwinam mungwa mengna esogo afufna og, “Sa ne Sisasim li katigeg la kukufenagi.” Asa Pailat ena mo higinam. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Afa Pailat gafa mungwa mo sihina sa ma gwenaig esi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Afa sonag el kalabus lanai eba Barabas autunam ehe maluna kembig la penim afa sa elim tigi fatina afa enag mungwali el ehem membini Pailatim og sama fwahai. Asa Pailat gwenaig esena afa sa Sisasim mo mungwali elni ningala fwahana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Asa Sisasim wanig afuafnaba afa nangunibi Sairini lanai el Saimon ona kembig la ika seaifo enag ehem hehlinim Sisasna li katigeg ehem fli kufehlinibi asa kufehlanam asa Sisasim sum patalkuna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Asa kaksag el mungwali flaukunaba afa mingnag angwafig mo wewatini Sisasim patalfuiafna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Afa Sisas wahigifenam ehengelim enaig sihifeni og, “Jerusalem la nai angwafig nofe ne kam wewatina asa ne nimbefe afa luwal fe sa ne gwenaig esi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Afa sumi yi puguiba el enaig sihifefie og, ‘Afa angwafig alaisuwufeg afa angwafig luwal fwainig afa angwafig luwalim tut faig fwainig eba sa ma sifakali.’ ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Afa enanam; El mugim enaig sihifenafe og ‘Kam tufupe sagfla kumwahla’. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Afa atiaba el kam enaig esigbi maia li figetinim asa ehengel fwina amtakwalig eseagifie maia li fofeba.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Afa amtakwalig el ahfena afa Sisas fena enam el wanafunam ogna ehem kwaskofi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Afa ena mug la ogna kwaskofi ena mug seflig misog kig mug. Enanai yi Sisasim olyi kahlini afa sambaganigi el ming ehgam kahlini afa mingim ming ehgam kahlini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Afa Sisas esona og, “Api, ehengel mas heafgelni amtakwalig nihem anwenafig mo sa ne ehengelni enaigim huguflanim.” Afa el Sisasna lofug huguflinim asa katna gosisini ogma amban sa enana lofug flai. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Afa el nangwafofenaba afa sa Ju elni saglag el Sisasim molamp mo faini enaig esogona og, “Eba ehe sa ming elim fakwaganfe enag sa ma hefum kweagfui. Atiaba God Kraistim Gisfu Fwahag El fegba asa ma gwenaig ese hefum kweagfui.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Afa anwasag el gafa Sisasim molamp mo fainim asa mileaklana bu nehni. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Afa enaig esogona og, “Atiaba ne Ju elni misog el fegba sa ne nimbefum kweagfu.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Afa sa li kukweflag la enaig ginofini og: Sonag elbi eba Ju elni misog el feg. Asa Sisasna misog sisi yi kukufi fwahini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Afa mungu el sa Sisas nahlum wahe kagini enag Sisasim molamp mo faina og, “Neba naho Godna Gisfu Fwahag El me awai awai me? Sa ne bibefum kwaganim.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Afa ming el ehem ninimu flanam enaig esona og, “Atiaho ne Godimba embefenag? Neanga gwenaig susug flag. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Afa eba bibeafgina moala big enag susugba ahflag enaba ihlafeg. Afa sonag elbi eba mas haig esena mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Afa Sisasim enaig sihifena og, “Sisas ne misog el ofefiba sa ne kam onigina!” ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Afa Sisas ehem enaig sihifena og, “Ka nem nufunam osihina glauwaba ne kai heven la hawagfife.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Afa osu misosuf gigni osu meagam seaifunaba mungwali bite si kigi fakana ikan ikan sambaga mungu aua la puguna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Afa gwenanam Godna Kwania lala nai lofug olyi plefunam pekan pitkafena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Afa Sisas ambwaitina esona og, “Api, ka kikeafna sungwabugbi nibeafna ninga la afwaha.” Afa ena mo sihinam asa lahana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Afa anwasagna misog el mungwali enam nangunim Godna unehlag fingi finim og, “Eba nufunam ehe sonag elbi suialag ehe.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Afa el enanai yi afohiafna enag enam nangunim heafna bahaligim tigewaginim afa ningam gwana kakuwagini asa afuna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Afa Sisasna hihe i afa mingnag angwafig i enag membiagig afohiafnaba ehe gafa nanguni. Autunam ena angwafigbi Sisasim Galili nai patalfubina. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Afa saglag el mungu ehena unehlagba Josep. Eba Judia nai el ehena kembigba Arimatea. Sonag elbi eba suialag el fena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Afa mingnag saglag el sa Sisasim otigiginibi ehe mas mungwa mo sihini mo eba ehe Godna bog megim nangwagim nenge gofena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Asa ehe Pailatim sahna ogna Sisasna eligim flauku. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Afa sa ehe Sisasna eligim li katigeg la nai nibwasala upi fakanam asa lofugna sagfla kikenagenam asa flauku fun meg la fakana. Ena fun megba mulug gofna mas ambanim eyi fakini mo. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Afa eba Fraide osupegna, enanaba el laskuhlag osuna numwehiagini. Afa enaba ati meyiofefna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Afa sa angwafig Sisasim Galili nai patalfubina enag Josepim patalfunam fun meg la nangwafufnaba asa Josep enanai yi fakana. ");
INSERT INTO amn_amanab_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Afa ehengel pese lala gam afunam afa sa pauda i fungunia bu i numwehiaginim ogna sa Sisasna lofugim laitinagi. Afa sa esug auguiag osuna ehengel ena nihe mo patalfunam asa esug auguna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Afa Sande leana gubi enag angwafig fun meg nanguigim afufefnaba asa pauda i fungunia bu i lambug afuna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Afa afu nangunibi fun mogug fun megim pwaka feg ati bafo gofna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Asa ehengel saiye afunam mas Sisas Ainiyag na eligim nanguini mo. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Afa sa ehengel afohiafnaba fwina onigwageafufna. Afa sa gweyi yi ikagna el sambaga heafnigina lofug eba fwinam busiag ahfena enag muhla ahgofna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Afa angwafig nangwaginim embefiagini bite nofeafufna. Afa sa sambaganigi el enaig sihi ahfeni og, “Haisegba sa ne noka nofkikena elbi bite kife la yisigi nangu? ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Eba mas wanai yi ba gah mo. Eba awai. Eba ati pese buihiag. Atiaho ne ehena moba onigig asa ati nem Galili yi sihini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ehe enaig esona og, ‘Eba Nufunam Elim amtakwalig elni ningala fwahibi asa ehem li katigeg la tigi kahlife afa maia sambaga mungu osuna ika puguiba afa sa ehe pese buihiafe.’” ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Afa sa angwafig Sisasna mom pese enam onigini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Afa sa ehengel enanai fwahinim asa pese afunam 11 pela patalfuiag el mi afa mingnag el mi sihigoni. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Afa enag angwafigbi eba Maria Makdala nai, afa Joana, afa Jemsna afag Maria afa mingnag apaiyena. Enag Kanog Fwatieg elim ena mom sihigoni. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Afa Kanog Fwatieg el enaig onigini og angwafig eheba mwakwalig. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Afa Pita buihia kikini ikan fun meg gim sefu nangunamba lofug mungu gifini afa elig mo awaiena. Afa sa ehe pese lala gam ikanam fwinam onigwageaufna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Afa maia angwafig ambe ena mo sihinibi afa ming el sambaga ati ena mo ahiginam asa enanam Emeus kembig gam ahakofna. Enag kembigba eba mungwanam hilifeg ikag. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Afa eheningi ahkafenaba hefum sihiaga ahfe kafna Sisasim sa esenagini ena mom. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Afa maia sihiago ahfekafnaba afa Sisas olyi ehem pugunim asa afuiafna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Afa afuiafnaba eheningi mas ehem anwena ahfena mo. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Afa sa Sisas eheningim sahtigina og, “Mangwal mo ne sihiag ahfeaka?” Afa eheningi ahkinihlanam nofbusug mo kuko fuiagafenam enaig ahgofna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Afa ming el ehena unehlagba Kliopas enaig esona og, “Afa mungwal el Jerusalem lanai ati enam anwenafig, mangwal sa enanam enanai yi puguiageg. Mas ho ne enam anwenafeg mo?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Afa ehe ehem sahtigina og, “Mangwal maia?” Afa eheningi enaig esohona og, “Ena moba eba mangwal sa Sisasim Nasaret la nai elim sa pugunageg enam. Sonag elbi Godna mo fla sihiaule el feg afa wasneig ogfuiaule feg afa ehe suialag mo sihiaule feg. Afa ehe suialag el Godna nofla feg afa elni nofla feg. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Afa misog pris i afa saglag el i ehem angoluwag elni ninga la fwahigbi asa ehem tigigim li yi kahli. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Afa kangel ka onigig sonag elbi eba Israel elim lambinam asa kwaganfe. Afa enaigba esegba eba sambaga mungu osuna maia awaiegba asa enaigba pugug. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Afa leana gubi kangelnai angwafig afug bite kife la apukegim ena mo fli big sihigbi kangel sineminefeg. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Afa mas Sisas na eligim bite kife la nanguini mo. Afa enanai yi of lanai el ehengelim ahsihini mo. Afa enanai yi of lanai el ehengelim ahsihini og Sisasba eba nofkikena goh. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Afa mingnag kangel nai ehe gafa afu bite kifem nangug. Enaba angwafig sihinibi asa enaigba esini afa mas ehena eligim nanguni mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Afa Sisas eheningim enaig sihifeni og, “Masi ne numwehe ohonigig mo afa mas ne Godna mo fli sihiafule elni mom fwinam ahkehla ohonigina mo. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Eba Godna Gisfu Fwahag El sa ma susug flanam afa nengigim sa ma kwania unehlag flai.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Afa sa Sisas eheningim Godna mungwali mom sihinuwagena. Moses nai yi upugunam afa ikan mungwali Godna mo fli sihiaule elnai yi puguna. Enaba Sisasna mom sihiafufna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Afa afu kembig la apukenam afa sa Sisas ona eheningi lasanam ika. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Afa eheningi ehem ahsihina og, “Osu ati pegim ofe sa ne kam wangi.” Asa afu lala meg gam saiye afuna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Afa enanai yi augunam asa fane ona ahga afa sa Sisas amba flanam Godim suialag onam asa kwawagenam asa mange tigini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Afa maia enaig esenaba asa eheningi enam ahnangunam asa anwena ahfena eba Sisas ehe. Afa sa ehe gweyi ikagna awaienaba afa eheningi mas ehem ahnanguna mo. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Afa eheningi hefum sihiag ahfenam og, “Afai, big eteti ahfena maia bigim mina la Godna mo bigim sihinuwage blofnaba afa sa bigna olug fwinam fingi fiahwagena.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Afa eheningi gweyi ikagna Jerusalem gam ahkana. Afa enanai yi ika ahnangwagnaba 11 pela patalfuiag el apaiyena afa mingnag hihe apaiyena enag laskuhlagofna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Afa ehengel enaig sihi fegoni og, “Eba nufunam ehe Ainiyag ati pese buihiag. Ehe ati Saimonim pugunag.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Afa eheningi gafa sihiagafena Ainiyag sa mina la pugunim afa lala apukenam maia ehe amba okowag fenaba asa enanai yi anwena ahfena eba Sisas ehe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Afa maia lala meg gam auguia sihiage aflanaba Sisas gweyi ikagna pugu olyi gofna. Afa sa sihini og, “Nengelni olug enesieg nem gohonfi.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Afa ehengel sineminefinim embefinim og eba iflaf eba. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Afa ehe enaig sihifeni og, “Haisegba sa ne sineminefig? Haisegba sa ne enaig onigifig mangwal sa ne nangugim ne og mas nufunam feg mo? ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Afa sa nangu kana ninga mi mong mi sa ne enam anwenafi eba kike ehe. Sa ne kam tuhum kaba iflaf mo. Afa iflaf eba kig fwainig afa nihig fwainig. Afa kaba eba kigna feg afa nihigni feg.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Afa ehe enaig sihifenim afa sa heafna ninga me mong mi ogfuni. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Afa ehengel mas enam numwehe anwenafini mo. Afa ehengel olug fingi feskofenam afa sifakalini. Afa Sisas ehengelim sahtigina og, “Atiaho ne faneba fig?” ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Afa sa sawag ehem fainibi ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","asa flanam ehengelni nofla nena. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Afa enaig sihifeni og, “Enaba autunam ati ka nem sihi fwahani kana mom mungwali yi Moses na, Godna mo fla sihiaule el i, Song buk la i ati ginofi fwahini enaba eba sa kam nufunam fenag.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Afa sa ehe ogfufenugenaba asa ehengel Godna mom numwehe anwenafini. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Afa sa ehe enaig sihifeni og, “Godna ginof enaig esog Godna Gisfu Fwahag El eba sa ma susug flanam asa ma lahai afa maia sambaga mungu osuna feba asa pese buihiafe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Afa heafna unehlag la mungwali bitenai elim olug waikefe mom sihigo ningia fwiba sa ma God ehengelni amtakwaligim flafatini. Ena moba sa ma Jerusalem la pugunam sa ma gwese ika minefe. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Afa ati ne enam nangug afa sa ne enaig mom sihiagafu. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Afa kana alag ati sihi fwahag afa eba kike nem enaig faife asa ne gwena kembig la auguiafim ikan sa ne wasneig heven la nai fli.” ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Afa Sisas ehengelim Betani Kembig muhla wankana. Afa heafna ningam fingi fe fuku gufnaba asa enaig esona og God sa ma nem suialafehiage gofi. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Afa ehe enaig ese fwahanim asa God ehem heven gam sulu fla fukuna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Afa ehengel ehena unehlagim fingi finim asa sifakali finibi Jerusalem gam pese afuna. ");
INSERT INTO amn_amanab_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Afa enanai yi Godna Kwania lala auguiafenaba afa sa Godim suiala fe flini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Afa autunam nemug hwa bite mas gifni mo afa el mungu fena eba Godna Mo afa ehe God i ahwag fena afa ehe God fena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Eba nufunam autunam nemug enag Mo ati gofena afa enag Mo eba el God i ahwag fena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Afa enag Mo eba mog feg asa mungwali pugug afa big nangug afa mingnag meagam gohug. Afa God enag Mona mungwali gafugafiahgena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Afa nufunam nofkenagag enag Mo la go afa enag nofkenagag elim ombusug faig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Afa enag el eba ombusug sikulufegim higafeg afa sikulufeg mas ombusugim filafe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Afa God mungu elim ningihiag heafna unehlagba Jon. ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Afa Jon blogim mungwali elim hwa ombusug mo sihinig asa mungwali heafna mo higigim sama enag mom olug oningini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Afa Jon ehe mango enag ombusug mo eba awai afa ehe enag ombusugim elim ogfunig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Afa enag nufunam ombusug asa hwa bite la pe blog asa mungwali elim ombusug fenife. ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Afa God mo behig esonaba asa enag Mo mungwali hwa bite la apukeakana. Afa enag Mo hwa bite la ehe puguna afa hwa bitenai el mas anwenafini mo asa mungwali ehe gafugafeg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Afa ehe heafna mungu usumunai elim bloni afa heafna el mas ehem mas suialafe flini mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Afa ambangel ehem suialafe fligbi asa ehem olug oningigba God enaig elim mina piginig asa God enaig esog ne kana luwalig apukeg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Afa enaig luwal afag mas wanigai afa mango bigelni alag afagna membug la mo eba God ehe feg asa apukeg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Afa enag Mo el lofug blonam bigelim olyi fenife. Afa maia bigim wangafenaba afa big nangug ehe fwina kwania feg. Afa God ehem enaig esenagba kwania feg asa heafna leg mungu feg. Afa ehe ati elim esmunagim kwaganig afa ehe Godna haig haigim mungwali bigim nufunam ogfunig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Afa Jon blogim ehena mo sihiakag. Afa ehe enaig esog “Autunam ka nengelim sihinig ka ma gose ikafiba asa mungu el sum blofe afa ehena unehlag kwania feg afa kaba weti feg asa ka maia meyi fiahfenaba afa ehe ati God i ahwagfena.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Afa heafna nihe eba bigim wahkig esmunagim kwaganig gohugim asa bigim suialag lafieg afa ehe bigim gwenaig esenigofife. ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Autunam God heafna nihe mo Mosesim faina asa bigel anwenafig afa ilawo Sisas Krais ogfug Godna nihe enaig esmunagim kwaganig afa nufunam mo bigim pugunig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Afa mas amban el Godim nanguna mo afa heafna leg mungu ehe God fena afa ehe Alag i ahwag fena asa bigim God numwehe ogfunig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Afa Jerusalemnai Ju elni misog el membeni Jonim sahna asa gafuga elim afa mingnag prisim Jon nangum ningitigina. Afa ehengel ambenam ehem sahni og, “Ne amban maia?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Afa Jon mas mwalfwai gofena mo eba ehe ambala esoni og, “Ka mango Godna Gisfu Fwahag El mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Afa ehengel ehem pese sahni og, “Ne mango enag el mo afa ne amban maia? Atiaho ne Elaija?” Afa ehe og, “Kaba mango enag el mo.’ Afa ehengel afofenaba pese sahni og, “Atiaho ne Godna mo fli sihiaule el asa kagel nengia afofena?” Afa ehe sihini og, “Amo kaba awai.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Afa ehengel enaig esogona, “Kagelim sihi neba amban maia. Afa maia ne sihiba ka higinim asa pese afunam kiafgelni misog elim sihigoni asa kagelim ningitigi asa sihi nembefum ne amban maia?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Afa Jon sihini og, “Autunam Godna mo fli sihiaule el Aisaia enaig esog; ‘Afa kaba el mungu bite behig la gonam afa fwina esofe og, Ainiyagna mina suialafiahgi sama bloi.’” ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Afa mingnag el Jonim nangugim ambena eba farisi el, ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","afa ehem sahnagim og, “Afa ne mango Godna Gisfu Fwahag El, Elaija, afa Godna mo fli sihiaule el mo asa haig esegba ne elim bu la laitig?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Afa Jon sihig, “Ka bu behig la laitig afa mungu el nengelnai yi olyi asa go afa ehem ne mas anwenafig mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Afa ehe kana sum asa blofe. Kaba el feg afa eheba fwina suialag nemug asa ka mas ehem muhla fenai afa kweafunam ehena mong lofug huguflanai.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Afa enag el enaig Betani kembig la esena eba Jordan bu ehengam maligim, afa enanai yi Jon laitiagena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Afa ming osuna Sisas Jon nangum blofenaba asa Jon ehem nangonam esona og, “Sa nangu, enag el Godna sipsip luwalig oblo afa ehe bigelni amtakwaligim kufla fatiagim. ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Enag el ati ka nengelim sihinig. Ehe sum blonam afa ehe gosefe afa ehe fwina kwania feg asa ka maia meyi fiahfenaba afa ehe ati God i ahwagfena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Afa gof ka mas ehem anwenafena mo asa ka enaig eseg elim bu la laitinugeg asa God enag elim bigel Israelnaim ambala ogfunife.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Afa Jon ming mo sihina og, “Ka nangug Godna Sungwabug gamb lofug of la nai pe blonam Sisas i ahgofife. ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ka gafa ehem mas anwenafenag mo. Afa autunam God kam ningihiana elim bu la laitiagim afa ati kam sihina og, ‘Maia ne nanguiba Sungwabug pe blonam el i ahgofife asa ne anwenafefe eba enag el Godna Sungwabugna bu la laitife.’ ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Afa kike ati nangug asa ka nengelim sihinig enag el eba Godna Leg.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Afa ming osuna Jon afa heafna sambaganigi patalfuiag el gwenanai yi pese afofena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Afa nanguni maia Sisas ikafenaba afa Jon sihina og, “Nangu enag el Godna sipsip luwalig!” ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Afa sambaganigi enag mo ahiginam asa Sisas nangum sum ahkana. ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Afa Sisas waikefe nanguagena sambaganigi sum ahblofena asa sahtigina og, “Mangwalim neningi memb ahfeg?” Eheningi esona og, “Rabai hanai yi ne gafife?” (Enag mo ‘Rabai’ Hibruna mona seflig eba tisa.) ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Afa ehe sihini og, “Asa ahblo ahnangu.” Eba osuna asa eheningi ahkanam afa heafna kugagim ogfuni. Afa enanai yi enag osuna Sisasim wani ahwagifena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Afa enag mungu el eba Andru afa ehe Saimon Pitana sumineg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Afa Andru Sisasim lasunam afa ikagna eteg nangum ikana asa sihina og, “Kaningi Godna Gisfu Fwahag Elim ahnangug.” (Afa Grikna mo enag elim seflig Krais.) ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Afa ehe Saimonim Sisas nangum wanibluna. Afa Sisas ehem nangunam esona og, “Neana unehlagba Saimon Jonna leg afa ilawo ka nem glaunai unehlag faife eba Sifas.” (Enag unehlag Grikna mo seflig Pita eba fun.) ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Afa ming osuna Sisas oningina og ka Galili gam ikafe. Afa ehe Filipim yisigi nangunam asa esona og, “Sa blo kam patal blu.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Afa Betsaida eba Filip, Andru afa Pita ehengelni kembig feg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Afa Filip Natanielim yisigi nangunam sihina og, “Autunam Moses heafna nihe mo mungu suialag elim ginofena afa Godna mo fli sihiaule el ehengel gafa gwenag elim ginofena. Afa kagel enag elim ati nangug eba Sisas Josepna leg ehe Nasaretnai el.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Afa Nataniel esona og, “Ka oningig enag kembig Nasaret mas mangwal suialag pugui.” Afa Filip esona, “Sa blo nangu.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Afa Nataniel buihia ikafnaba. Afa Sisas Natanielim nangunam maia blofenaba afa esona og, “Hwa elim sa nangu ehe Israelna nihe suialag patalku feg afa heafna mo i nihe i eba nufunam feg.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Afa Nataniel ehem sahna og, “Haig anwena ne kam fenag?” Sisas esona og, “Afa Filip mas nem puguna asa ne fik li mog la gafena asa ka nem nanguna.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Afa Nataniel sineminafenam esona og, “Tisa, neba Godna leg afa ne Israelna misog el.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Afa Sisas esona og, “Ka nem sihinag ka nem nangug asa ne li mog gafena eba weti feg asa ne kam olug oningina. Asa ne kwania kigmog nangufe.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Afa ehe ming mo sihina og, “Ka nem nufunam sihinig sa ne nangufi heven la nai mengig pigife asa ka Nufunam Elbi gofiba enaig ging lofug afa Godna oflanai el enag mina apaiye gofenam afa pese kwaliafena.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Afa sambaga sinaini maia ikanaba Sisas heafna patalfuiag elim Galilina bite la apukena afa Kena kembig la auguna. Enanai yi el mungu angwafig flana asa ehem buyis fini. Afa Sisasna afag ehe gafa enag buyis yi blona. ");
INSERT INTO amn_amanab_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Afa ehengel Sisasim afa heafna patalfuiag elim esogoni og, “Au ambego kagelni buyis la.” Asa ehengel afuiagohna. ");
INSERT INTO amn_amanab_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Afa maia ehengelni wainbug awaienaba afa Sisasna afag ehem esona og, “Ehengelni wainbug awai.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Sisas esog, “Mia, magim ne ehengelni kinig mo ne kam sihinag? Hwaba mango kana was mo asa ka kikefum ambala pugufe afa enag osuba meyi fe.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Afa heafna afag gafugag elim sihini og, “Heafna mo sa nengel patalfu.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Afa Ju elni nihe enaig fane ahgaginim ofibi asa ninga bu la sugum asa ahgag. Afa enwesog la gohug sob muhla folfu fwai yi eba ninga sug sob. Enag sob eba kwaniagig yi enaig dram lofug. ");
INSERT INTO amn_amanab_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Afa Sisas gafugag elim sihini og, “Hwa sobni bu hefibi.” Asa enag sob sama memtog la pugui. ");
INSERT INTO amn_amanab_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Asa ehe ehengelim enaig esoni og, “Sa ne weti hefi buyisna alagim faiba sama ne nangui.” Asa ehengel enaig esini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Afa bu ati wainbug lofena asa bu yisna alag ne nanguna. Afa ehe mas anwenafena mo hanai ehengel flig. Afa gafugag el enam anwenafini afa mas sihini mo. Afa buyisna alag el angwafig asa flag enam awamonam ahkanam, ");
INSERT INTO amn_amanab_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","asa sihiagena og, “Mungwali el enaig esini suialag wainbug gof mageni asa heafna mangau ningag ahgagini afa sumi ehe mingnag wainbug mageni asa enag mas suialag fena mo asa gof mageni. Asa ne fwina suialag wainbug ne kumuhlagim asa glau ne mangofen.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Afa enag kigmog Sisas gof ogfuna Kenana kembig la Galili provins ehe enaig esena. Afa enag kigmog heafna patalfuiag el ogfuni heafna wasneig eba fwina kwania feg asa ehengel ehem olug oningini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Afa Sisas, heafna alag i, sumineg i, afa patalfuiag el enag kembig fwahinim asa Kaperneam la mwakwalig augunam asa afuna. ");
INSERT INTO amn_amanab_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Afa Ju elni Pasova buyis muhla ofefenaba asa Sisas Jerusalem gam ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Afa ehe Godna kwania lala sefu ikanam nanguna el enanai yi enaig gafugafini kig lambifini afa kau, sipsip, afa twafig mageagifini. Afa mingnag el angoluwagna kig flifinim afa heafgelni kig mo ehengelim faigofena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Afa ehe nangunam maia enaig esinibi asa ehem olug kinig fena afa ehe we flanam sisim enana kuguaitifenam asa sis embem apuke afuiaminefena. Afa kig lambig elni sime waikefe kig nahgum labaitifena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Afa ehe twafig mage elim lagnana og, “Enag lambinam gwesim wanika. Nofeka kana Apina lalam maket lala lofug enaig esi.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Afa Sisasna patalfuiag el nangunim asa oningini autunam enag Godna mo ginofini eba enaig esog, “Ka oningig Godna lala sama suialag gofi asa enag oningig kana olug yi suwi lofug lagi. Afa ka oningig gwenam mungu fenag.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Afa Ju el Sisasim laginini og, “Ne magim enaig eseg. Enaig asa nimbiafna kigmog kagelim ogfuni asa kagel anwenafi God nem sawi fenag nem og enaig ese asa ne enaig eseg.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Afa Sisas wahigi sihini og, “Afa nengel hwa kwania lala bubugi aitifigba asa ka sambaga mungu osuna pese nimblafe.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Afa Ju el sihini og, “Atiaho, ne enaig esefe? Afa 46 yia kagelni saglag el hwa lalaba nimblig. Haiseg sa ne esog sambaga mungu osuna ka pese nimblafe?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Afa enag kwania lalam Sisas esonaba eba heafna eligim esona. ");
INSERT INTO amn_amanab_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Asa maia ehe lahanaba afa pese buihiana afa heafna patalfuiag el pese oningini enag mo ehe esona. Asa ehengel olug oningig Godna mo buk la gi afa oningig Sisasna mo eba nufunam. ");
INSERT INTO amn_amanab_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Afa maia Ju elni Pasova buyis ofefenaba Sisas Jerusalem la gafena. Afa el heafna kigmog nanguni asa kaksag el ehem olug oningig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Afa Sisas ehengelim anwenafenim asa mas muhlafeni mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Afa ehe hefum ati anwenafeg ehengelni oningigim asa amban el mas ehem sihinai. ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Afa mungu el heafna unehlagba Nikodemus eba Ju elni misog el. Afa ehe mingnag Godna mo anwena elim wangafena afa enaig el seflig farisi el. ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Afa sinaini ehe Sisasim nangwagim blonam sihina og, “Saglag, kagel anwenafig ne tisa God ehe nem ningihiag. Afa el Godna feg fwainigba asa ehe mas enaig kigmog ogfuni asa ne eseg.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Afa Sisas sihina og, “Ka nem nufunam sihinag afa el sa pese ikanam ninganai luwal fe fwainigba asa enag el mas Godna bog megam nangui.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Afa Nikodemus sahna og, “Haisegba asa watiaug el pese ikanam ninganai luwal fefe. Afa ehe mas afagna wula la sefunam asa pese wanigai. Afa el bigel mas enaig esi.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Afa Sisas pese sihina og, “Ka nem nufunam sihinag afa el asa buna afa Godna Sungwabugni ninganai luwal feg fwainigba eba ehe mas Godna bog megam sefukai. ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Afa luwal alagafagna mungu usumu la afohieg eba alagafagna membug la eseg asa luwalna eligim nofkenagag faig. Afa el Godna mungu usumu la afohieg eba Godna Sungwabug eseg asa elni sungwabugim nofkenagag faig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Nofeka sineminafe ka nem enaig sihifenag sa ne pese ikanam ninganai luwal fe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Afa Godna Sungwabug eba efef lofug. Afa efef blogim afa el ehena mina mas anwenafeg mo ehe haig blofeg afa hiag ikafeg. Godna Sungwabug enaig eseg asa elim yimieg nofkenagag faig enaig ninganai luwal lofeg.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Afa Nikodemus ehe mas anwenafena mo asa sahna og, “Haisegba sama enag enaig eseg?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Afa Sisas og, “Atiaho ne Israelnai elni tisa haisegba ne kana mo mas anwenafeg mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ka nem nufunam sihinag mangwal asa kagel anwenafig afa nengelim sihigonug afa mangwal asa kagel nangug nengelim sihig asa nengel kagelni mo mas higigonig mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Afa ka nem bitenaina lasug mo sihinigba asa heven la nai gawigim ogfunig asa ne mas ena mo higig mo afa ka nem oflanaina mo sihinaiba, sa ne higi? Amo, eba mas ne enam gafa higi. ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Afa mas amban el Godna latuim nangug mo, kike mungu. Kaba Nufunam El afa ka enanai yi fwahanam asa hwa bite la pe blog. ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Afa ne anwenafeg autunam Moses mwakwal sombine kapa kegna gafugafena asa aga la kikenam sisi yi fingi fena asa amban gih el enam nangwafenaba gih suialafefena. Afa Nufunam Elim gafa kikenam aga sisi yi fingi fifi. ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Asa amban el ehem olug oningigba sama wahkig nofenagag fli. ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Afa God mungwali elim fwina membini asa heafna Leg mungu nemug hwa bite la ningihiana. Asa amban el ehem olug oningig sama wahkig nofkenagag fli afa ehe mas awaiye. ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Afa God heafna legim ningihiana mango kwefihiagegim afa susug fai enaigim blo mo eba awai God ehem ningihiana sama ehe elim kwagani. ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Afa amban el legim olug oningig afa enag el kwefihiagegim mas kuskufe. Afa amban el enag Godna legim mungu mas olug oninginag mo eba enaig God ehem ati kwefihiageg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Afa enag mina God elim kwefihiageg afa ombusug ati blog asa mungwali elim ambala ogfunig ehengelni auguiagim. Afa el ehe ombusugim mas membinag mo afa heafgelni nihe amtakwalig patalfug asa ehengel og ka sa sikulufeg la afohiefim. ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Afa el amtakwaligim esig ehe ombusugim mas membeni asa ombusugim mas muhla feni. Afa ehe enaig esig asa ehengel embefig enag ombusug heafgelni amtakwalig nihe ambala ogfufe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Afa amban el nufunam mo patalku eba ombusug yi go afa ehe mas embefe. Sama enag ombusug heafna gafugagim ambala ogfunai eba Godna membug la ehe enaig eseg.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Afa maia enaig esenaba Sisas afa heafna patalfuiag el provins Judia afuna. Enanai yi auguiafenaba asa elim bu la laitigonugini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Afa Jon Ainon kembig la gafna eba Salim muhla go. Enanai yi kaksag buna feg afa el ehem nangugim ambena asa ehe gafa ehengelim bu la laitina. ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Afa enanam Jon mas kalabus lala gofena mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Afa mingnag Jonna patalfuiag el Ju elim mo esuni. Afa ehengel Ju elni bula sug nihem sihiageni. ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Afa ehengel Jonim nangunim asa sihini og, “Tisa, autunam enag mungu elim ne sihina asa Jordan bum magim ne yi ahwagfena. Sa hig, mungwali el enag elim nangum afuiaba asa ehe bu la laitife.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Afa Jon wahigi sihina og, “Mungwali mangwal el asa flag eba God ehem faig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Nengel nimbe ati higig ka nem enaig esoni og, ‘Kaba mango Godna Gisfu Fwahag El mo kaba gof mina esug tola blog.’” ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Afa Jon enaig lasug mo pese sihina og, “Afa el angwafig flagim ofeba asa heafna hihe buyis numwehiagena. Afa enag hihe mas angwafig flai asa ehe gafugafenagim enag angwafig flag elim ningenago. Afa maia ehe angwafig flag elni mengigim higinam asa sifakalefe. Afa ka ati Sisasna mengigim higinam asa ka gafa gwenaig sifakaleg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Afa ka oningig ehe kwaniafeba afa kaba wetifefe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Afa el heven lanai blog eba sisi fenig bitenai elim. Afa el bitenai feg ehe bitenai mo sihiagig. Afa el Godna kembig la nai blog ehe mungwalim sisi fenig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Afa mangwal ehe ati nangug afa higig asa sihinig. Afa el heafna mo higigim asa mas fli. ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Afa amban el heafna mo kehlag asa enag ogfunag Godna mo eba nufunam. ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Afa enag el God ningihiag eba God ehena Sungwabug ehem mungwali faig asa heafna mo eba Godna mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Afa Alag Legim fwina membegim asa mungwali ehena ninga la fwahiag. ");
INSERT INTO amn_amanab_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Afa amban Legim olug oninginafe ehe ati wahkig nofkenagag flag. Afa amban Legim masig fatig eba mas nofkenagag flai asa Godna ninimu ehenai yi wahkig gofife.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Afa kaksag el Sisasim patalfuna asa bu la laiti fena. Afa mungu mungu Jonim patalfuna afa farisi el enag mo higig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Afa Sisas ehe mas elim bu la laitina mo eba heafna patalfuiag el elim bu la laitini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Afa maia Sisas anwenafenaba farisi el enag gafugam mo sihiagini asa ehe Judia provins fwahanam Galili provins pese ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Afa enag mina Galili yi gam ikagba eba Samaria provins la pugunam asa Galili la ika pugug. ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Afa ehe Samaria ikafenaba afa Sikar kembig la puguna. Autunam Jekop heafna leg Josep bite faina. Enag kembig hwa bite la muhla feg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Afa Sisas Jekopna bume la pugunam afa ehena kig ewiauwina asa enanai yi hehefena. Eba osu misosuf gigni. ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Afa Samariana angwafig mungu bu efigim blona asa Sisas ehem sahna og, “Kam bu efi fai, kau ne.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Afa heafna patalfuiag el kembig gam afuna fane lambigim.) ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Afa enag angwafig sineminafena asa ehem sihina og, “Neba Ju el afa ka Samarianai angwafig haisegba ne kam bum sahnag?” (Afa ehe enaig esog asa Ju el mas Samariana enag kaf mungu la ahgai.) ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Afa Sisas sihina og, “Ne mas anwenafeg mo mangwal God elim asa esug faig afa kaba amban maia. Afa ne enam anwenafegba afa ne kam bum sahnaiba asa ka nem nofkenagag bu faife. Enag bu sama wahkig nofkenagag nem fai.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Afa angwafig sihina og, “Saglag, ne sobini mo buba efi yi afa bume eba mungwanam pekag. Hanai yi sa ne enag nofkenagag bu efife? ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Kagelni simp Jekop enag bume kukona afa ehe heafna luwaligna afa heafna sisna asa enag bume bu ahgafufena. Ehe enag bume kagelim faig. Atiaho ne oningig ne kwania el asa kagelni simpim Jekop filafeg.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Afa Sisas wahigi sihina og, “Amban ne enag bu negba eba nem pese bu hefefe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Afa amban hwa bu nefe asa ka nem fai eba mas nem pese bu hefei. Afa enag bu el nai yi sefu go enaig bu eba logifife afa mas awaiye eba elim wahkig nofkenagag faife.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Afa angwafig ehem enaig esog, “Saglag, enaig sa kam enag bu fai asa ka mas bu hefei afa pese bloi wanai efi yi.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Afa ehe angwafigim sihina og, “Sa ikanam nimbiafna alagagim wani blu.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Afa angwafig wahigi esona, “Kana alagagba awai.” Sisas sihina og, “Enag moba ne sihigba eba nufunam. ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Afa ming mo ne sisage afa nufunam nemug autunam ne afala gohug saglag ne lambig afa ilawo sa ne ahwag eba mango neana alagag mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Afa ehe Sisasim esona og, “Saglag, ka anwenafeg neba Godna mo fli sihiule el. ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Kagelni simbianingag enag Samarianai mug gim enaig esog enanai yi kagel sa Godim sahni afa heafna unehlag fingi fi. Afa nengel Ju el enaig esogog kagel Jerusalem la mungu sa enaig esig.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ehe enaig esog asa Sisas sihina og, “Kana mo higinam sa suialag kehlafe. Autunai la nengel enaig esifi. Ehengel mas enag mug la afa Jerusalem la ambenam asa Apina unehlag fingi fifi. ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Afa nengel Samaria nai el mas Godim numwehe anwenafig mo asa nengel heafna unehlagim mas suialag fingi fig mo. Afa kagel Ju el Godim suialag anwenafig asa ehem fingi fig. Afa God kagelim Ju elim kano fwatig asa heafna mo ehengelim faig asa enag mina ehe mungwali elim kweafug. ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ati meyini ofe afa el mas oningig hanai yi sa Godim fingi fefe afa suialag el ilawo enaig eseg ehe Sungwabug wasneigni afa nufunam nihena Apim fingi fi. Afa God membeg enaig el sama gwenaig ehem eseni. ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","God eba suialag sungwabug afa el ogna ehem nufunam ahnai skaufinig asa Sungwabug wasneigni afa nufunam oningig Godim fingi fig.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Afa angwafig sihina og, “Ka anwenafeg Godna Gisfu Fwahag El asa blofe (el ehem seflig Krais) afa maia ehe bloiba afa enag el Godna mungwali oningig bigelim sihinig asa ambala ogfunife.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Afa Sisas sihina og, “Biningi asa sihiag ahfegoba. Eba kike enag el.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Afa sihiage fegofenaba heafna patalfuiag el ambenam eheningim nangwagini. Afa ehengel oningig Ju elni tisa mas angwafig i mo sihiag ahfei asa ehengel sineminafini. Afa ehengel mas angwafigim sahani mo, “Mango ne membeg?” Afa Sisasim mas sahani mo, “Haisegba ne angwafigim mo sihinag?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Asa enag angwafig heafna sob fwahanam ikanam kembig la nai elim sihinig og, ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Au ambe elim nangu. Haig haig asa ka eseg enag el ehe kana mo ambala sihig. Atiaho enag el Godna Gisfu Fwahag El maia?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Asa enag el kembig fwahinim afu Sisasim nanguni. ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Afa enanam patalfuiag el Sisasim mengigna esoni og, “Tisa, fane afogwa sa ne.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Afa ehe ehengelim sihini og, “Kaba kiafna fane ati feg ka ma enag nefe. Afa enag fane nengel mas anwenafig mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Afa patalfuiag el hefum sihiageni og, “Atiame amban el ehem fane flau blu faig me asa ehe mas binilahag mo?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Afa Sisas esog, “Afa God kam ningihiag asa ka heafna sawiegim patalkug. Kana fane eba enag gafugag esenagim asa heafna gafugam auginefe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Afa nengelni mo enaig esog, ‘Sambaga sambaga was maia asonai lagnufeba.’ Afa ka nem sihinag Godna aso sa nangu afa enag asonai ati lagnufeg asa lambogefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Afa Sisas lasug mo pese sihina og, “Autunam gafugag el asonai yiwagig afa ilawo mingnag gafugag el ambe asonai lambifi asa ehengel enag gafugag enanam kig lambifi afa enag asonai wahkig gwese afogwafife asa yiwagig el afa lambig el sama eheningi sifakalafei. ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Afa kaksag el gwenaig mo sihig og, ‘Mungu el asonai yiwageg afa ming el blo lambig.’ Enag mo eba nufunam. ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Afa mingnag Godna aso nengel mas yiwagig mo ka nem ningitigiba sa ne asonai lambogi. Mingnag el enag aso kwania gafugafig afa henige feskofeg afa ehengelni gafugag ati nengelim kweafug.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Afa angwafig kembig la naim sihini og, “Haig haig asa ka eseg enag el ehe kana mo ambala sihig” afa kaksag Samaria la nai el ehena mo higinim asa Sisasim olug oningini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Asa Samaria la nai el ambe ehem mengna sihini og, ne kagelim wanai yi wangagim. Asa ehe sambaga osuna ehengelim wangana. ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Afa ehe blo sihiagegba afa heafna mo higigim asa kaksag el ehem olug oningig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Afa ehengel angwafigim sihini og, “Autunam ne sihinaba asa neana mo kagel kehli fwiafena afa ilawo kike heafna mengigim higigim asa kagel anwenafig ehe eba enag el ehe mungwali elim kwaganig.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Afa Sisas enanai yi sambaga osuna ganam afa fwahanam Galili gam ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Afa Sisas hefum enaig esona og, “Godna mo fli sihiule el heafna kembig la nai mas ehem suialafe fli mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Afa maia ehe Galili provins pugunaba afa enag kembig la nai el ehem nangunim sifakalini asa maia ehengel Jerusalem la Pasova buyis la afunaba asa ehengel enanai yi heafna mungwali wasneig gafugag nanguni. ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Afa ehe pese ikanam Kena kembig la pugunam enanai yi ehe asa bum waikefena wain bug lofena. Afa Kaperneam la nai gavmanna misog el Sisas nangum blona. Heafna leg Kaperneam la gihna gifni. ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Afa ehe higinam Sisas Judia fwahanam pese blog asa Sisasim nangwagim blonam sahna og kana leg lahagim ofe sa ne ikai Kaperneam gam ehem suiala fenagim. ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Afa Sisas ehem sihina og, “Nengel kam mas nufunam olug oningini mo. Nengel enaig oningifig asa ehe wasneig kigmog kagelim ogfug fwainigba asa kagel ehem mas olug oningini.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Afa gavmanna misog el ehem esona og, “Saglag, auna ikagna ahka kana luwal mas sa lahafe.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Sisas wahigi sihina og, “Seka, neana luwal eba gohugimba.” Afa ehe enag mo higinam asa pese fakafe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Afa meyi minam ikafenaba afa heafna gafugag el ambenam mina la huflinim sihini og, “Neana luwal eba gohugimba mas lahai.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Afa ehe ehengelim sahni og, “Mangigna asa luwalba suialafeg?” Afa ehengel enaig esogona og, “Amu osu misosuf gigni ehem elig liputina.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Afa alag anwenafena amu osu misosuf gigni Sisas kam sihina og “Neana luwal eba gohufe.” Asa ehe heafna mungwali nilitena Sisasim olug oningini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Afa Sisas Judiam fwahanam Galili puguna asa ehe enaig esena hwaba angigieg kigmog ehe ogfuna. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Afa ming osuna Ju elni buyis ofefiba asa Sisas Jerusalem gam ikafe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Afa mengig mungu Jerusalem kembig la go enag mengig eba seflig sipsipna mengig. Enag mengig eba bume bu muhla go. Enag bugig Hibruna mo seflig Betesda afa la gohug afwambag sime enag bum wagifakag. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","4","Afa afwambag sime la kaksag gih el enanai yi gofena. Afa enag gih el eba nof etetini afa mong ninga liligna asa auguiafena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Afa mungu el mong lilifegna 38 yia enaig fena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Afa Sisas ehem nangunam afa anwenafena ehe wahkig gwenaig fena asa ehem sahna og, “Atiaho ne membeg sa ma nem suialafe?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Afa el sihina og, “Saglag, mas amban kam kweafug mo afa maia bu nekuneku ofeba afa mingnag el goseg afug apaiye go afa kaba awai.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Afa Sisas ehem esona og, “Sa buihianam kife flanam saika.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Afa ikagna ehe suialafena afa heafna kife topeske flanam asa ikana. Eba Esug Auguiag Osuna ehem enaig esena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Asa Ju el enag elim laginini og, “Afa ilawaba Esug Auguiag Osuna nofeka kife flanam asa uku. Afa bigelni nihe mo enaig gafugam kweg.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Afa el wahigi sihina og, “Hwa el kam suialafenag kam enaig esonag og, ‘Nimbiafna kife flanam saika.’” ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Afa ehengel ehem sahni og, “Amban nem enaig sihifenag?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Afa enag el mas anwenafeni mo amban ehem suialafenag asa Sisas kaksag el meagam mungwali walagena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Manige fwainig Sisas ehem Godna Kwania lala la nangonam asa ehem sihina og, “Ei, neana elig ati suialafeg. Sa higi sa ne enaig amtakwalig nihem sa ne fwaha afa ne fwaha fwainigba masa ne fwina susug kwania flafe.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Afa enag el ikanam asa Ju elim sihini Sisas kana eligim suialafefatig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Afa Sisas Esug Auguiag Osuna enaig esena asa Ju el ehem kinig faini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Afa Sisas ehengelim wahigi sihini og, “Kana alag mungwali osuna gafuga fafefe asa ka gafa gwenaig eseg.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Afa Juni misog el Sisasim lagini afa maia enag mo higinibi ehengel Sisasim olug kakagenim og ehem tigibi ma lahai. Afa ehengel og ehe mas Esug Auguiag Osuna nihem patalku mo afa mingam enaig esog God kana alag afa hefum fingi feg og kaba God i mungwalofug. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Afa Sisas sihina og, “Ka nufunam sihinig, afa Leg mas heafna oningig la enaig esei. Afa Alagna gafugam nangugim afa Leg gwenaig eseg asa mangwal alag eseg eba Leg gafa enag gafugag eseg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Afa Alag Legim fwina membenag asa ogfunag mungwali mangwal ehe eseg. Glau nengel Godna kigmog ati nangug afa Alag Legim kigmog kwania ogfunagba asa Leg enaig esefe asa nengel sineminafif. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Afa Alag enaig fasefe ehe lahag elim fukulag lasug afa wahkig nofkenagag faig. Afa Leg gafa gwenaig eseg asa heafna membeg ehe ambanim membenag asa nofkenagag faig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Afa Alag ehe mas elim kwefihiage afa kwefihiageg gafugag eba Legna ninga la fwahag. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Asa mungwali el sama Legim fingi fi gwenaig asa Alagim fingi fini. Afa Alag Legim ningihiag asa amban el mas ehem fingi fenag mo eba alagim gwenaig esenag. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Ka nem nufunam sihinig, amban el kana mo higinim afa Godim olug oninginigbi asa ehe kam ningihiag afa enag el wahkig nofkenagagna feg asa God ehem mas kwefihiagenam susug fai. Afa ehe lahagna mina fwahagim asa nofkenagag mina la go. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ka nem nufunam sihinig, ati muhla feg eba ilawo enag pugufe afa el lahag mina la afo asa Godna Legna mengig higinim asa amban el ehena mengigim ati higinag eba nofkenagag flafe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Afa God elim nofkenagag faig asa ehe nofkenagag mog feg. Afa ehe Legim kigmog faig asa Leg gafa nofkenagag mog feg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Afa Leg eba Nufunam El asa God ehem enaig esona og, sa ne mungwali elim kwefihiagenuge. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","“Afa enag puguiba asa nofeka kana mo sineminafi. Afa mungwali lahag el biteg kife la afogoku asa Nufunam Elni mengigim higinim, ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","asa heafgelni biteg fe fwahinim apukefe. Afa amban el suialag nihe esena asa buihianam pese nofkenagag flafe. Afa amban amtakwalig nihe esena asa buihianam God ehengelim kufenifi. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Kikefum mungu ka mas mangwal enaig esei. God kam sihinag asa ka higigim afa ka kwefihiageg. Ka mas kikeafna sawiegim patalkui eba awai. Afa kam el asa ningihiag ka ehena sawiegim patal fakufe asa kana kwefihiag eba nufunam nemug. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Afa kikeafna mo mungu sihiba kaba amban maia asa enag mo eba mo behig feg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Afa ming el kana mo sihife eba kana mo kweafug. Afa ka anwenafeg heafna mo kam sihinag eba nufunam. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Afa nengel elim Jon nangum ningitigina asa afu anwenafi ka amban maia. Afa Jonna mo ambala nufunam sihina. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ka mas oningig elni mo sama kana mo kweafui. Afa ka Jonna mo sihinig asa nengelim kweafug sama nengel amtakwalig mina fwahanam afa suialag mina patalku. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Afa Jonna mo lam lofug asa nengelim ombusug faig asa nengel enanam mwakwalig enag ombusugum sifakalig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Afa Alag gafugag kana ninga la fwahanag asa ka enag gafugafe. Asa enag gafugag kana mo kweafug afa ogfug Alag kam ningihiag. Afa Jonna mo eba enaig eseg afa hwa mo eba fwina suialafeg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Afa Alag kam ningihiag afa ehe gafa kana mo kweafug. Afa nengel heafna mengigim mas higi afa heafna eligim mas nangug mo, ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","afa heafna mo mas nengelni oningi la go mo. Asa nengel kam mas olug oningi mo asa ehe kam ningihiag. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Afa nengel Godna ginofim ati fahigeflig asa ne enaig esogog afa ka enag mogim anwenafeba ehe kam wahkig nofkenagag faife. Afa enag ginof kam sihinag afa kam ogfunag kike amban maia. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Eba sihig ka elim nofkenagag faife asa nengel yiskosig kam patal ambegim. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Afa maia el kam fingi figbi asa ka mas enam fwina oninginai. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Afa ka ati anwenafenig nengel mas Godim nufunam membenig mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Afa ka Alagna unehlag la blog asa nengel kana mo mas kehlig mo afa ming el heafna unehlag la mungu bloiba asa nengel heafna mo kehlifi. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Afa nengel laskuhlagim nembefum fingi fig asa enam sifakali. Afa nengel mas oningi God mungu sama kagelni unehlagim fingi feni asa mas kam olug oningini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nofeka enaig oningifi haig haig amtakwalig nihe sa ne esig asa ka Godna nof la nengelim kufinife eba awai eba Moses ehe enaig eseg. Nengel oningini Mosesna mo nengelim kweafug asa enag mo nengelim kufinig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Afa Moses kam ginofenag afa nengel nufunam Mosesna mo patalfuibi asa kana mo gafa nengel patal ambefe. Afa nengel mas enaig esig mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Afa Mosesna ginofim nengel mas kehlig mo. Haisegba nengel sa kana mo kehlifi?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Afa mingnag osu fwahanam Sisas Galili bu la pugunam asa bot yi ehengam maligim ikana. (Galili bu ming unehlagba Taiberius.) ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Afa el heafna kigmogim nanguni maia gih elim suialafetifenaba asa kaksag el ehem patalfuna. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Afa Sisas mogim kukanam afa heafna patalfuiag elim wangafena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Afa enanam Ju elni Pasova buyis muhla ofefenaba. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Afa Sisas nof fiagena afa nangwagena kaksag el ehem nangugim ambena asa Filipim sahna og, “Hanai sa bigel fane flinim hwag kaksag elim faigoiba sama ahgai?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Afa ehe enaig esog ka Filipna oningig yuhna maia haig sihi ofefiba. Afa Sisas ati ehe anwenafeg ehe enag fane faife. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Afa Filip ehem wahigi sihina og, “Afa ka gug la gohug was gafugafegba asa kig flag afa enag kigna ka stoa nai aba flig. Afa enaig aba mas ehengelim ihlafenig mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Afa ming patalfuiag el Saimon Pitana sumineg Andru kwablog luwalim nangunam asa ehe enaig esog, ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Hwa kwablog luwal afa la gohug aba sagig weti lambina afa sambaga sawag weti lambtigina. Afa enag fane mas kaksag elim ihlafenig mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Afa Sisas enaig esona og, “Sihigonibi sama apaiye augui.” Enanai yi kaksag pos go asa 5,000 saglag enanai yi apaiye auguna. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Afa Sisas enag aba sagig flanam asa Godim sahna og eba suialag. Afa ehe koskofenam asa el apaiye augug enag elim mangegoni. Afa ehe sawagim gwenaig esena. Afa mungwali ahgaginim ihla feskofena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Afa maia enog feskofenaba ehe patalfuiag elim sihini og, “Asa afu lamb enag fane el mas ahgag mo masa lambaitifibi awaiefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Afa ehengel angogoli lambinam afa 12 pela sob yi aitini. Afa Sisas afa la gohug aba sagig koskofena afa mungwali ahgagini asa angogoli sob yi aitini afa memto la puguna. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Afa el enag kigmog nanguni afa enaig esogona og, “Autunam Moses sihi fwahana og Godna Mo Fli Sihiaule El hwa bite la blofe. Atiaho nufunam enag el asa blona.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Afa Sisas ehengelim ati anwenafeni ehengel ogna Sisasim kehlinim asa bigelni misog el goni. Asa ehe lasanam asa hefum mog gam pese ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Afa osupefenaba afa Sisas mas blona mo. Asa heafna patalfuiag el Galili bu blugim afunam. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Afa ehengel bot la augunam asa Kaperneam gam bu kwania mina afuna. Afa siokifi fenaba ehengel meyi bot yi afuiafenaba Sisas mas ehengelim ulambina mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Asa bifwat blonam afa buum waike waikefena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Afa bot meyi enwesog la gohug kilomita olyi bu la gofena asa ehengel Sisasim nanguni maia bu sisi yi ehengelim nangwagigim blofenaba. Asa ehengel fwina embefini afa kig kilafeskofena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Afa Sisas ehengelim esoni og, “Nofeka embefi eba kikeba.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Asa ehem awamoni afa ehe bot yi kukaganam afa gwenanam enag bot ikagna bu blug yi ika puguna mina la asa ehengel membeni. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Afa Sisas elim fane asa faini enanai yi ehengel askanam leana buihia gafenam afa ehefum sahwagini og, “Sisas hanai yi maia?” Afa ehengel anwenafini ehe mas heafna patalfuiag el wankai afa ming bot awai. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Afa mingnag Taiberius la nai bot ambenam enanai yi apukena. Afa enanai yi Sisas Godim sahnam og, eba suialag asa fane mungwali elim faini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Afa ehengel anwenafini og Sisas i afa heafna patalfuiag el i wanai yi mas go mo. Asa ehengel bot yi Kaperneam gam afunam Sisasim yisigi afuna. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Afa ehengel bot la afunam ehengam maligim apukena. Afa Sisasim enanai yi nangunim asa sahini og, “Tisa, wanai yi ansi ne blona?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Afa Sisas wahigi sihini og, “Ka nem nufunam sihinig, ka nengelim aba sagig faini afa ne ahgagim asa ne enam membigim asa kam ambe yisigig. Afa nengel kana kigmogim mas numwehe anwenafig mo asa ka ogfug. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Nofeka bite nai fanem fwina oningini eba enag nogife. Afa nengelni oningig sa ne nofkenagag fanem oningini sama nengelim wahkig nofkenagag fai. Afa God kana Alag kam kanog fwahag asa ka heafna gafugag esenag asa enag fane Nufunam El nengelim faife.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Afa ehengel ehem sahni og, “Mangwal gafugag asa ka Godim esinifi?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Afa Sisas wahigi sihina og, “Enag el asa God ningihiag sa ne ehem olug oningini. Afa enaig eba Godna gafugag.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Afa ehengel enaig esogog, “Mangwal kigmog kagelim ogfunifi asa kagel enam nangunim nem olug oninginifi. Mangwal sa ne esefe? ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Afa maia bigelni simbianinga bite behig la auguiafenaba afa aba ahgana eba seflig mana. Afa Godna mo enaig sihifeg, ‘Ehe ehengelim of la nai aba faini asa ahgana.’” ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Afa Sisas sihina og, “Ka nem nufunam sihinig. Enag aba Moses bigelni simbianingam faini eba mango nufunam of la nai aba mo. Afa kana Alag asa nengelim nufunam of la nai aba faig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Afa Godna aba eba enag el asa of la nai pe blog asa bite nai elim nufunam nofkenagag faig.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Afa ehengel sahni og, “Saglag, enaig sa ne kagelim enag aba wahkig mange gonigofim.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Afa Sisas sihina og, “Enag aba ka nengelim sihinig eba kike. Ka elim wahkig nofkenagag faig. Afa amban ne kam nangum bloiba mas pese binilahai. Afa amban ne kam olug oningiba mas pese bu hefei. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Afa ka nengelim sihinig nengel kana kigmog ati nangug afa mas ne kam olug oninginig mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Afa mungwali el kana Alag kam faig afa enag el ka nangum ambegofe. Afa amban enaig esefe asa kam olug oningini ka ehengelim mas laginini eba awai. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Afa ka mas kikeafena oningigim patalkui. Eba el kam heven la nai ningihiag asa ka blogim heafna sawiegim patalkui. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Afa ehe kam ningihiagim og, ‘Ka elim neana ninga la fwatife asa ne ehengelim nangwaghiagofim masa mungu awaiefe. Afa maia kwefihiageg osuna puguiba asa ne ehengelim biteg fenai ihlaftigi.’ ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Afa mungwali el Godna Leg nangum ambefe afa ehem olug oningini asa kana Alag membeg enag el wahkig nofkenagag flig. Afa kwefihiageg osuna asa ka ehengelim ihlaftiginam nofkenagag faife.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Afa Sisas esona og, “Kaba heven la nai aba.” Asa Ju el enag mo higinim afa hefum memtog mona sihiagini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Afa ehengel enaig esogog, “Ati big anwenafig eba Sisas Josepna leg ehe el feg. Big anwenafig heafna alag mi afag miba. Haisegba ehe enaig esog ‘Ka heven la nai pe blog?’ Enag mo mas suialafeg mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Afa Sisas sihina og, “Afwai, nofeka nimbefum memtog mona sihiagefufum. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Sa higi, afa el ehe mas kam patal blui eba kana Alag ehem awamonam asa ka nangum wani bluife. Afa ka kwefihiageg osuna ehem ihlafufe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Afa amban el kana Alagna mo higinim afa heafna mo kehlig asa enag el ka nangum ambefe. Eba enaig Godna mo fli sihiaule el asa ginofini og, ‘God ehe mungwali elni tisafefe.’ ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nofeka nengel oningifi kana mo enaig esog el kana Alagim nangug. Mungu el ehe kana Alagim ati nangug eba enag el God i ahwagfena asa ehem ningihiag. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Ka nem nufunam sihinig amban el kam olug oningig asa enag el wahkig nofkenagag flag. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Kaba enag aba asa elim nufunam nofkenagag faig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Nengelni simbianinga bite behig la mana ahganam asa mas nofkenagag flini mo afa watiaug feskofenam asa pigina. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Enag aba mango mana lofug mo. Eba heven la nai aba afa el enag ahnagaiba asa ehengelim mas pigi. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Eba kike enag heven la nai aba. Afa el enag aba neba asa ehenai yi wahkig nofkenagag gofife. Enag aba eba kana elig. Afa ka kiafna elig bite nai elim faig asa bite nai el sama nofkenagag fli.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Afa Ju el hefum mo soagini afa enaig esogona og, “Haisegba sonag el heafna elig bigim faife asa big enag ahgafe?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Afa Sisas ehengelim sihini og, “Eba nufunam feg afa ne Nufunam Elni elig i afa heafna taf i fli fwainigbi afa nofkenagag mas nengelni go mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Afa ne amban kana elig i afa taf i neba asa wahkig nofkenagag ehenai yi gofife. Afa kwefihiageg osuna asa ka ehengelim ihlafo tiginam nofkenagag faife. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Afa kana elig eba nufunam fane afa kana taf eba nufunam bu. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Afa ne amban kana elig i afa taf i neba eba ehe ka i ahfeg afa ka ehe i ahgofife. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Kana Alag nofkenaga afa ehe kam ningihiag asa heafna wasneig kam nofkenagag fai. Asa amban kam ne ba asa kana wasneig ehem nofkenagag faife. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Afa enag aba of la nai blog eba mango mungwa lofug aba mo asa nengelni simbianinga ahgana afa sum yi pigina. Afa amban ne enag aba neba eba ehe wahkig nofkenagag flafe.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Sisas hwa mo sihini laskuhlag lala Kaperneam la. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Afa kaksag el Sisasim patalfuiaule hwa mo higinim afa esogona og, “Enag mo bigel mas numwehe anwenafi. Amban sa enag moba kehlafe?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Sisas ehe ati anwenafena mingnag el ehem asa patalfuna hefum memtog mona lagwagini asa ehengelim enaig esoni og, “Atiaho hwa mo nengelim kinig faig? ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Mangwal kinig sa ne flifi afa ne nanguibi Nufunam El of gam pese kwakofiba asa ehe enanai blona. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Godna Sungwabug nufunam nofkenagag elim faig. Afa elni elig mas elim kweafui. Afa mo ka nem sihinag enag mo sama nengelni sungwabugum kweafui afa nufunam nofkenagag nem faifi. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Afa nengel mingnag kana mom mas onigini.” (Afa ilawanam Sisas ati anwenafeg amban mas ehem oniginig mo afa amban el asa ehem angoluwagna ninga la fwahafe.) ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Afa Sisas pese sihini og, “El mas kam onigig mo enagba mog feg autunam ka nem sihina kana alag elim wasneig faig fwainig ba afa enag el ka nangum mas bloi.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Afa kaksag el Sisasim patalfuna afa enag mo higinim asa Sisasim fwahinim mas pese patalfuna mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Afa Sisas heafna 12 pela patalfuiag elim sahana og, “Nengel gafa ne kam fwai yi me?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Afa Saimon Pita enaig sihifena og, “Ainiyag amban nangum ka sa afunam asa patalfufe. Neana mo mungu bigelim wahkig nofkenagag faig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Afa kagel olug onigig afa anwenafig neba afsug kabag el God nem ningihiag.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Afa Sisas sihina og, “Ka kike nengelim 12 pela elim kanognig afa el mungu nengel nai yi asa go eba Satanna gafuga esefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Enag mo eba Judasim sihinag. Ehe Saimon Iskariotna leg. Afa eheba Sisasna patalfuiag el fena asa Sisasim angoluwag elni ninga la fwahafe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Afa Sisas esenam asa Galili gam wagiakafena. Afa Ju elni misog el ogna Sisasim tigi asa ehe Judia gam ikagim oksina. ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Afa Ju elni kogma lala buyis muhla ofefenaba, ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","asa Sisasna nilite ehem sihina og, “Sa ne hwa kembig fwahanam Judia gam ikai asa neana patalfuiag el sa ma neana kigmogim nangui. ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Afa el hefum ambala ogfuba enag el mas heafna gafugag meagam kumhlai. Sa ne enag eseba sa ma mungwali el nem anwenafeni.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Afa heafna nilite enaig esoni asa ehengel gafa mas Sisasim olug onigini mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Afa Sisas ehengelim sihina og, “Kana was meyi fe afa nengel nimbiafgelni membug la sa afuiago. ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Afa bite nai el nengelim mas lagini goni, afa kaba ehengelni amtakwaligim sihiageba asa kam olug kakagfini fi. ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Kaba mas glaba ikai kana was meyi fe afa nengel buyis gim sa afuiago.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Afa Sisas enaig sihifenam afa hefum mo Galili la gafna. ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Afa Sisasna nilite gof afunaba afa ehe gafa sum fakafe. Afa ehe mas ambala puguna mo afa ehe elni megam seaifu fiakafena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Afa Ju elni misog el buyis la ehem yisgiafofena og ka ehem nangu asa sahini og, “Sonag el hana yi maia?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Afa mungwali el hefum behe mona Sisasna mom sihiagini. Mingnag el esogona, “Eheba suialag el.” Mingnag el esogona, “Amo, ehe mungwali elim mwakwalenigule.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Afa mungwali el Ju elni misog elim embefini asa sagmonam hefum behe mona enaig sihifini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Afa buyis ati olyi ofefnaba asa Sisas Godna kwania lala ikanam elim mo sihinug fafefe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Afa Ju elni misog el Sisasna mo higinim sineminefinim afa hefum esogona og, “Hanai sonag elbi kwania onigiba flana ehe mas skul yi ikana mo?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Afa Sisas sihina og, “Enag mo ka nem sihinig mango kiafena mo mo, eba awai. El kam ningihiag eba ehena mo ka nem sihinig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Afa amban membeg Godna sawiegim patalkuia gofiba afa enag el eba anwenafefe mo sa ka sihig Godna me awai kiafna me. ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Afa amban el heafna onigig la sihiageg ogna hefum fingifeg. Afa el ming elni unehlagim fingifegba asa ehem ningihiag afa heafna moba eba nufunam afa enag el mas mwakwale. ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Afa nengel ati anwenafini Moses Godna nihe mo nem faini afa nengel mas enag nihem patalfuna mo. Mangigim ne kam ona tigi?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Afa el esogona og, “Sanel amtakwalig ne nai yi go asa ne onigig etet el lofeg asa ne enaig sihifeg. Amban el ona nem tigi?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Afa Sisas sihina og, “Ka mungu kigmog Auguiag Osuna eseba afa ne iskofakifi. ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Afa nengel enaig esig Auguiag Osuna ne fangonai luwalna elig lofug koflig asa ne Mosesna nihe mo patalfug. (Afa Moses mas gof enaig esena mo afa nengelni simbianinga autunam enaig esini.) ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Afa Auguiag Osuna ne enaig esigbi luwalna lofug weti koflifatig ne og kagel mas Mosesna nihe mo filafati mo. Haigseg ba ne kam laginig maia gih elim ati ka suialafatig Auguiag Osuna. ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nofeka nofugna behig kwefihiage afa ne nufunam mogim nangonam sa ne kwefihiage.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Afa mingnag Jerusalem la nai el hefum enaig esogona og, “Atiaho enag el maia asa misog el ona tigi? ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Sa nangu, Sisas ambala moaba sihiago fenaba afa mas amban ehem haig esoni mo. Atiaho misog el onigig ehe Godna Gisfu Fwahag el me? ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Afa maia Godna Gisfu Fwahag el bloi ba bigel mas heafna kembig anwenafi afa bigel ati anwenafig Sisas hanai maia blog.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Afa Sisas Godna kwania lala gafenaba afa fwina sihinugena og, “Ei, ne kam anwenafinifi eba kana kembig gafa ne ati anwenafig. Afa ka mango kikeafna wasneigni blo mo, awai. Afa el nufunam onigigna feg asa ehe kam ningihiag. Afa ne mas ehem anwenafinig mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Afa ka ehem ati anwenafenag afa ka ehe i awagigim enag kam ningihiag asa ka blog.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Afa Sisas enaig esonaba asa el ona ehem ningana kehli afa ehem tigig was meyi fiahfenaba asa mas amban enaig esena mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Afa kaksag el Sisasim olug onigig flinim enaig esogona og, “Afa hwa el asa kaksag kigmog ogfug eba Godna Gisfu Fwahag el gwenaig esefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Afa farisi el enag sagmona mo higinim asa ehengel i afa misog pris i anwasag elim ningitigini afu Sisasim kehli. ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Afa Sisas sihina og, “Ka nengelim mwakwalig wanganam afa ka elim nangwagim ikafe asa kam ningihiag. ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Afa ne kam yisgifi afa mas ne kam nangui asa kembig ka ga ne mas bloi.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Afa Ju elni misog el hefum sihiagini og, “Ehe asim ikafe asa ehem mas big nangui? Atiaho enaig ese me? Afa ehe afwambanai elni kembig gam ikanam asa ehengelim mo sihinugefe afa enanai yi Ju el auguia. ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ehe enaig esog ‘Ne kam yisigifi afa mas ne kam nangui’ afa ming mo esoni ‘Kembig asa ka ga ne mas bloi.’ Afa enag mo ka mas anwenafig mo ehe mangwalim esog?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Afa buyis osu buswagin meyi ofefenaba eba kwania osuna fena. Afa enag osuna Sisas buihianam fwina esona og, “Amban el ne bu hef fegba sa ne ka nangum blonam bu ne. ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Afa Godna mo enaig esog afa amban kam olug oniginafe afa nofkenagag bu ehe nai yi logofife enaig fun bu lofug.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Afa hwa mo enaig esog Godna Sungwabug enaig esefe amban asa Sisasim olug onigina asa ikanam ehe hwagfife. Afa enanam Sisas mas pese heven gam kukana mo afa kwania unehlag flagim asa enanam God heafna Sungwabug elim mas faini mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Afa mingnag el hwa mo higinim esogona og, “Sonag el eba nufunam Godna mo fli sihiaule el!” ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Afa mingnag el sihini og, “Eheba Godna Gisfu Fwahag el!” Afa mingnag el enaig esog, “Amo, Godna Gisfu Fwahag el mas Galili nai bloi. ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Afa Godna mo enaig esog Godna Gisfu Fwahag el eba Devitna simbianinga afa ehe Betlehem la afag wanigefe Devitna kembig la.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Asa el Sisasim sambaga onigig flinim asa hefum mungu mungu kokohiaginim asa afwiaminefena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Afa mingnag el ona Sisasim kalabusimini afa mas amban el ehem kehlini mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Afa anwasag el gwenag pese ambena. Afa misog pris i afa farisi el i ehengelim sahtigini og, “Haisegba ne ehem mas wanig ambeg mo?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Afa anwasag el wahigi sihini og, “Afa heafna mo alganam feg mas bigel i amban enaig feg mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Afa farisi el ehengelim lagigoni og, “Atiaho ehe nengelim gafa mwakwal fafenife asa ne ehem patalfug? ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Afa ne ati anwenafini kagel farisi el afa misog el heafna mom mas higinig mo. Kagel Mosesna nihe mo patalfug. ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Afa enag kaksag el Mosesna nihe mo mas anwenafini mo asa ehe mungwali elim mwakwalini. Eba God ehengelim amtakwale klaitife.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Afa mungu farisi el Nikodimus ehe autunam Sisasim ati nanguna asa mingnagim esoni og, ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Bigel nofeka ehem munum sehini afa bigelni nihe mo enaig eseg ilawo bigel sa elni mom higinim asa anwenafi ehe ati mangwal eseg me.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Afa ehengel Nikodimusim laginini og, “Atiaho ne gafa Galili nai el? Sa ne pese ikanam Godna mo ugwe fahigiafla asa ne anwenafe Godna mo fli sihiaule el mas Galili nai bloi.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Afa ehengel enaig esinim afa lala gam afuiaminefena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Afa Sisas Oliv mug gam kukana. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Afa leana gubi Godna kwania lala gam ehe pese ikana. Afa kaksag el ehem muhla laskuhlagunam asa ehe peganam mo sihinugiaufna. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Afa nihe mo anwena el i afa farisi el i angwafig aga fatiaulem wani ambenam asa ehem enaig esini mungwali elni nof la blu gona lasunim. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Afa ehengel Sisasim sihini og, “Hwa angwafig kagel ati kike nangug ehe ming saglagim patalkug. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Afa Mosesna nihe mo bigim wasneig mo faig. Sa big enaig angwafigim funna tawagi sa ma lahai. Afa ne haig esofe? Asa bigel mango fifi?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Afa ehengel Sisasim ona yuhni asa enaig mo ehem sihinim asa ehem kufini. Afa Sisas peskafenam ningana bite la ginofena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Maia ehengel ehem sahnafufnaba ehe buihianam ehengelim sihini og, “Amban nengeli nai mas mangwal amtakwalig eseg mo asa enag el sa ma funna gof tigifati.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Afa Sisas pese peskafenam ningana bite la ginofena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Maia ehengel hwa mo higinim asa mungu mungu Sisasim fwahinim afuiaminefena. Saglagig enag mo gof afuna afa luwal kwablog sum fafufena. Afa maia ehengel mo enaig esinibi afa enag angwafig Sisas i ahgofena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Afa ehe buihianam angwafigim sahana og, “Ei, hanai yi elbi afohie? Atiaho mungu elbi go asa nem kufenafe?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Afa ehe wahigi sihina og, “Saglag, mungwali el awai.” Afa Sisas esona og, “Ka gafa nem mas kufenai. Seka, nofeka amtakwaligim pese enaig ese.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Afa Sisas mungwali elim pese sihina og, “Ka kike enag ombusug hwa bite la feg. Amban el kam patal oblofiba enag ombusug nanguiba asa enag ehem nofkenagag faife afa ehe mas sikulufeg la wagigofi.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Afa farisi el ehem sihini og, “Ne nimbefum sihiageg afa nimbiafena onigig la mungu sa ne sihig. Neana mo mungu mas kagelim ogfunig mo eba nufunam me awai awai me?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Afa Sisas sihina og, “Ka anwenafeg kike hanai blog afa asim ka ikafe asa ka kikefim sihiageba enag mo eba nufunam nemug. Afa nengel enam mas anwenafig mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Afa nengel nimbeafgelni onigig la elim kwefihiagig. Afa ka mas elim kwefihiagei. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Afa ka elim enaigba esofenifiba afa kana kwefihiageg eba nufunam feg asa mango kable mungu eseg mo. Afa alag kam ningihiag asa ehe ka i hawag. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Afa nengelni nihe mo enaig esog afa maia sambaganigi el mungu mo ahsihiba eba nufunam. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Afa ka kikefim sihiageg afa alag kam ningihiag ehe gafa kana mom ati sihig.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Afa ehengel Sisasim sahini og, “Neana alag hanai yi maia?” Afa Sisas wahigi sihina og, “Ne kam mas anwenafinig mo, eba kana alagim gafa ne mas anwenafig mo. Afa ne kam ati anwenafinibi eba kana alagim gafa ne anwenafinig.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Afa Sisas enaig esona Godna kwania lala meg la afa enag lala meg asa kig lambigim Godim fakig fwaihig. Afa el mas ehem kehlinim tigini mo asa enag osuna ehem enaig esigim mahim fiahfena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Afa Sisas ehengelim pese sihina og, “Ka ikafe afa ne kam yisiginim mas ne kam nangui. Afa ne haig haig fiahkan asa maia ne lahaiba nengelni amtakwalig nengelni gofufe. Afa ka ikafe asa ne enanai yi mas ne bloi.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Afa Ju elni misog el hefum sihiagini og, “Haig esegba ehe enaig siihifeg ka ikafe asa ne enanai yi mas ne bloi? Atiaho ehe hefum tige fati me?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Afa Sisas sihina og, “Ka sisi yi nai el afa nengel skaugu nai el feg. Nengelni niheba bite nai feg afa kana nihe mango bite nai mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Asa ka nem enaig sihifenig afa maia ne lahaiba nengelni amtakwalig nengelni gofufe. Ka nem ati sihinig kaba amban maia afa ne enam olug onigig fwainigbi eba enag nengelim nufunam esenife.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Afa ehengel sahini og, “Kagelim sihini ne amban maia?” Afa ehe sihini og, “Enag mo ka nem gof sihini eba gwenaig mo ka nem sihinife. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ka mo nup feg asa nengelim kufunigim. Afa el kam ningihiag eheba nufunam feg. Mangwal mo ehe sihig asa ka higigim enag mo mungu ka hwa bite nai elim sihinigofufe.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Afa ehe alagna mo sihinugena afa ehengel enag mo mas anwenafini mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Asa Sisas enaig sihifeni og, “Maia nengel Nufunam elim li katigeg la fingi fi kahlibi afa enanam ne anwenafifi ka kike amban maia asa ka nem ati sihinig. Afa enanam ne anwenafini ka mas kikeafna onigig patalkui. Alag kam asa sihinag enag mo mungu asa ka sihig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Afa ehe kam ningihiag asa ehe ka i ahwag. Mangwal sa ka anwenafeg asa ehem sifakal faig enag mungu ka enaig eseg asa ehe kam mas fwai ikai.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Afa kaksag el enag mo higinim asa Sisasim olug onigini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Afa Ju el Sisasim olug onigig fini asa Sisas ehengelim enaig sihifeni og, “Nengel kana mo higinim patalfuiba asa nengel kana patalfuiag el nufunam fig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Afa enaig esigbi ne nufunam mo anwenafifi afa mangwal nengelim kikeg asa enag nufunam mo nengelim esug pigi fwatifi.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Afa ehengel sihini og, “Bigel Abrahamna simbianga afa mingnag el bigim mas kikegoni. Haig esegba ne esog nengelim esug pigi fwatifi?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Afa Sisas sihini og, “Eba nufunam feg amban el amtakwalig nihe eseg asa amtakwalig nihe ehem kikenagim afa enam ahnai skaug fenag. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Afa esug gafugag el misog elim ahnai skaug fenag afa ehe mas misog elim wahkig wanga fi. Afa luwalig humonigim wahkig wanga. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Asa Godna leg nengelim esug pigi fwatifeba asa nengelim nufunam nemug fwatife. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ka anwenafeg nengel Abrahamna simbianga afa nengel kana mo mas flig mo asa nengel ogna kam tigi. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Afa kana Alag kam mangwal ogfunag asa enag ka nem sihinig. Afa mangwal nengelni alag nem ogfunig asa nengel enaig esig.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Afa ehengel enaig esogona og, “Kagelni simp eba Abraham.” Afa Sisas esona og, “Nengel Abrahamna simbianga nufunam fegba asa nengel gafa heafna nihem gwenaig esi. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Afa God kam sihinag asa ka higigim enag nufunam mo ka nengelim sihinugegofife afa nengel ogna kam tigi. Abraham mas enaig esena mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Afa nengel gwenaig esig asa nengelni alag esena.” Afa ehengel enaig esogona og, “Kagel mango mina luwal mo. God ehe kagelni Alag.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Afa Sisas ehengelim sihini og, “Afa God nengelni alag nufunam fefe nengel kam membenife asa ka ehem fwahagim enag ka blog. Ka mas kikeafna onigig la bloi ehe kam ningihiag. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Haisegba nengel kana mo mas anwenafinig mo? Eba enaig nengel kana mo fligim mas membig mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Satan eba nengelni alag asa ne membig heafna gafugam esig. Afa autunam nemug ehe elim tigeule afa mungwali nufunam mo ehe mas fatig afa nufunam mo ehenai yi mas go mo. Afa Satan mwakwal el asa mwakwal elni alag feg. Afa maia ehe mwakwal mo sihigba ehe sifakaleg asa enag nihe ehem mog feg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Afa nengel kana mom mas onigig mo asa kana mo eba nufunam feg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Afa mas amban el kana amtakwaligim ambala pugu sihi. Afa ka nem nufunam sihinig haisegba kana mo nengel mas onigig mo? ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Afa amban Godna el fefe enag el Godna mo higife. Afa nengel mas Godna el fig mo asa enag mo nengel mas membig mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Afa ehengel Sisasim sihini og, “Kagelni moba nufunam feg asa kagel enaig esogog neba amtakwalig Samaria nai el afa sanel amtakwalig neanai yi go.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Afa Sisas wahigi sihini og, “Ka sanel awai. Ka kikeafna alagim fingi feg afa nengel kam pigapego. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ka mas kiafna unehlagim fingi fei. Afa God kana unehlagim fingi fena afa ehe mungwali elim kwefihiageg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Eba nufunam feg amban sa kana mo kehlag enag el mas lahai.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Afa Ju elni misog el enaig esogona og, “Glau kagel ati anwenafig sanel neanai yi go! Autunam Abraham lahana afa Godna mo fli sihiaule el gwenaig esini afa ne enaig sihifeg el kana mo kehlife ehe mas lahai. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Bigelni simp Abraham ati lahana haisegba ne onigig ne ehem filafeg? Godna mo fli sihiaule el gafa pigina. Ne onigig ne haig el maia asa ne enaig sihiageg?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Afa Sisas sihini og, “Ka kiafna unehlagim fingi fegba afa enag gafugag mas fug lugui. Afa enag el nengel enaig esogog ehe kagelni God eheba kana alag asa kana unehlagim fingi fena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Afa nengel mas ehem anwenafinig mo afa ka ehem anwenafenag. Afa ka enaig sihifegba eba ka mas ehem anwenafenag mo afa enag mo ka mwakwaleg asa ka nengel lofeg mwakwalule. Afa ka ehem ati anwenafenag afa ka ehena mo patalfakufe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Autunam nengelni simbianga Abraham kam anwenafena og ka blofe asa ehe sifakalena. Afa enag ehe nangunam asa fwina sifakalena.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Afa ehengel Sisasim sihini og, “Abraham autunai fena afa ne mango watiaug mo. Atiaho ne ehem nanguna?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Afa Sisas sihina og, “Eba nufunam feg afa Abraham mahim fiahfenaba ka ati gohna.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Afa ehengel ehena mo higinim asa fun flinim ogna ehem wagi. Afa Sisas meagam gofenam asa Godna kwania lala fwahana. ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Afa Sisas ikanam nof tet elim nanguna. Enag el afag nof tetni gwenaig wanigana. ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Afa patalfuiag el sahini og, “Tisa, amban maia amtakwalig eseg asa hwa el nof tetni gohug? Eba ehe me awai alag afag esini me?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Afa Sisas wahigi sihina og, “Amo, eba mango enaig mo. Eba hwaig sama Godna wasneig enag el nai yi mingnag elim ogfuniba sama nangui. ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Glauba suialag osuna asa big Godna gafugam esi asa ehe kam ningihiag. Afa sikulufeg blofe asa el mas gafugafi. ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Afa maia ka hwa bite la gofiba kike bite nai elim ombusug fenig.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ehe enaig esonam afa bitem mepna kusufenam maia auwiauwinaba asa flanam nof tetni nof la gabahlana. ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Afa enaig esenam esona og, “Bu la sugim ika Siloam bume bu gam.” (afa enag unehlag Siloam eba ningihiag) Asa enag el ikanam bu la sunam nofug baihiana afa ehe pese kembig gam blona. ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Kembig la nai el afa mingnag el gafa ehem ati nanguni ehe asa gaba elim kigim fasahniofe. Afa ehengel enaig esogona, “Autunam nof tetni el kigim fasahniofe atiaho enag el maia?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Mingnag el enaig esogona, “Ei ena ho.” Afa mingnag enaig esogona, “Amo, ehe ming el afa nofbosug eba mungwalofug.” Afa enag el ehe gofenaba enaig esona og, “Eba kike!” ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Afa ehengel ehem sahni og, “Haig ne esegba asa neana nofug baihiag?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Afa ehe enaig sihifena og, “Afa el asa seflig Sisas ehe bite auwiauwigim asa kana nof la gabahlagim kam sihinag ika bu la su. Afa ka bu la sugim asa gwenana kana nofug baihiag afa ka numbusiageg.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Afa ehengel sahni og, “Enag el hanai yi maia?” Ehe esona, “Ka mas anwenafeg mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Afa kembig la nai el enam nangunim asa enag el nofug baihiana asa ehem farisi el nangum wani afuna. ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Afa Ju elni Auguiag Osuna Sisas auwiauwig bite flanam afa nof tet elim ugwe fatina. ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Afa farisi el gafa ehem sahni og haisegba neana nofug baihiag? Afa ehe ehengelim sihini og, “Ehe auwiauwig bitena kana nofugim gabahlagim kam esonag sa bu la su asa ka numbusiageg.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Afa mingnag farisi el esogona og, “Enag el enaig eseg ehe mango Godna el mo asa ehe bigelni Auguiag Osuna nihe mas patalkug mo. Afa mingnag sihini og, “Afa amtakwalig el mas enaig kigmog esei. Asa hefum mungu mungu afuiaminefena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Afa farisi el elim pese sahni og, “Neana nofugim asa suialafatig afa neba onigig enag el amban maia?” Afa ehe wahigi sihina og, “Ehe eba Godna mo fla sihiaule el.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Eba nufunam autunam enag el nof tetni fena afa enag Ju elni misog el ena mo higigim oksini. Asa enag elni alagafagim awamogonibi sa ahblon. ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Afa ehengel sambaganingim sahtigini og, “Atiaho hwa neningina leg? Eba nufunam maia ehe nof tetni gohna? Haisegba ilawanba ehe numbusiageg?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Afa humonig esogona og, “Ei, kaningi ati anwenahfeg eba kaningina leg afa ehe nof tetni gohna. ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Afa kaningi mas anwenahfeg mo amban ehem suialafatig afa mangwal ehem esenagba asa ehe numbusiageg. Ehe mango luwal mo, hefum sahnibi sama nengelim sihinuge.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Afa Ju elni misog el enaig sihifig afa amban enaig sihifefe og Sisas eba Godna Gisfu Fwahag el afa enag elim eba laskuhlag lala kwegonufe asa afwambanai el afohiafe. Afa alag i afag i enag mom embe ahfenam asa enaig sihi ahfena og kaningi mas anwenahfeg mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Asa eheningi ming mo esona og, “Ehe mango luwal mo, hefum sahni.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Afa el nofug asa ugwena farisi el enag elim pese awamonim ehem enaig sihifini og, “Godna nof la sa ne kagelim nufunam sihini asa kagel anwenafi enag el eba amtakwalig el.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Afa ehe esoni og, “Enag el amtakwalig el me awai awai me afa enag ka mas anwenafeg mo. Autunam ka nof tetni fena afa ilawo ka numbusiageg enaig mungu ka anwenafeg.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Afa ehengel ehem sahni og, “Haig ehe nem esenag? Neana nofug haig baihiafeg?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Afa ehe sihina og, “Kati nengelim sihinig afa ne mas higig mo. Haisegba nengel membig enag mo pese higigim? Atiaho nengel gafa ogka heafna patalfuiag el apuke?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Afa ehengel ehem kosnagini afa sihini og, “Ne enag amtakwalig el patalkug afa kagelbi Mosesna patalfuiag el fig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Kagel anwenafig God ehe Mosesim ati sihina afa kagel mas anwenafig mo enag el hanai maia blog?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Afa ehe sihina og, “Enag alganam feg nengel nufunam anwena el enam ne mas anwenafig mo. Ehe kana nofugim suiala fenag asa nengel mas anwenafig mo ehe hanai maia blog.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Bigel anwenafig God amtakwalig elni mo mas higinai. Afa el Godim ahnai skaufenag afa heafna mo patalkug asa God enag elni mo eba higinag. ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Afa ilawo el mungu mingnag elni nofug suiala fetifena afa autunam nemug enaig mo el mas higini mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Afa enag el Godna el feg fwainigba asa ehe mas haig ese asa heafna wasneig eba awai.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Afa ehengel olug kakaginim esogona og, “Maia ne gohnaba ne amtakwalig el fena asa glawa gafa ne gwenaig go. Ne fwina amtakwalig el haisegba ne og kagelim sihinuge.” Asa ehengel ehem fena minefinim asa ningihinim afa ehem laskuhlag lalam kweni. ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Afa Sisas higina maia enag elim enaig esofini finibi asa blonam ehem nangunam esona og, “Atiaho ne Nufunam Elim olug oniginag?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Afa ehe esona og, “Kam sihina ehe amban maia asa ka ehem olug onigina.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Afa Sisas ehem sihina og, “Ne ehem ati nangug eba ehe ilawo ne nai yi asa ahlago.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Afa enag el mongkokini kwakwagenam enaig esona og, “Ainyiag, ka nem olug onigina.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Afa Sisas sihina og, “Ka hwa bite la blog asa el kwefihiagenam. Afa nof tet el numbusiagefe afa el nof suialagna eba nof tet el lofefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Afa mingnag farisi el ehe yi mungwal hafufenaba ena mo higinim sahni og, “Atiaho kagel gafa nof tetni el?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Afa Sisas sihina og, “Afa ne enaig sihifeba kagel nof tetni el asa nengelnai yi amtakwalig mas go mo. Afa ne enaig esog, kagel mango nof tetni mo asa nengelni amtakwalig nengelnai yi nago.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Afa Sisas sipsipni lasug mo sihina og, “Eba nufunam feg, afa sipsip bog megam seaifu afohie afa amtakwalig el mas mengigna sefu bloi. Enaig el eba ukwef el ehe asa bogim tofug seaifug asa ukwefig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Afa kike enaig sipsipni suialag nangwaghiawageg el afa ka enaig fasefe mungosni mengig gam asa sefu blog. ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Afa el asa mengig la anwasa fego afa kam mengig piginag asa ka sipsipni unehlagim suwigigba afa kana sipsip kana mengigim ati higig asa afwambagam wankag. ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Afwambagam wanpugugum afa kana sipsip unem ati anwenafig afa maia ka goseg ikaba asa sipsip kam sum patalfuiag fug. ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Afa enag sipsip ming elni unem higigim afa mas ehem patalfui. Eba ehena mengigim mas anwenafinig mo asa ehem lasu afuiaminafeg.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Afa Sisas enag lasug mo sihini asa farisi el mas anwenafig mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Asa Sisas pese sihini og, “Eba nufunam feg kike eba sipsipni bog mengig lofeg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Afa mungwali el asa lasflam ambegog enag el eba ukwef el asa sipsip ehena mo mas higini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Kike mengig feg afa amban ne ka nangum sefu bloiba eba ne suiala gafefe. Asa ne sefufenam afa afwambagam pugufenam asa ne suialag bite la wagiafufife ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Afa ukwef elni onigig eba enaig ehe blonam asa sipsipim ukwefenam afa tigenam afa mingnagim mo amtakwalig klaitikafe. Afa ka blogba sama kana sipsip nofkenagag flifi asa enag nofkenagag ehengelnai yi kwania feni. ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ka kike sipsipni suialag anwasag el. Afa ka enaig esefe kiafna eligim fwaiyeba asa ka sipsipim kwaganife. ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Afa anwasag el eba sipsipni alag afa gafugag el eba esug nangwahiagego mango ehena mo. Afa maia sangwal malang oblofiba afa ehe nangugim asa sipsipim embem lasan ikag. Asa malang blonam sipsipim tigeba asa embem afuiaminefefe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Afa enag el eba esug gafugag el afa ehe mas sipsipim onigini asa ehe embem ikag. ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ka kike sipsipni suialag anwasag el. Kiafna sipsipim ka ati anwenafenig afa kiafna sipsip kam ati anwenafinig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Eba gwenaig eseg Alag kam anwenafenag afa ka ehem anwenafenag. Afa ka kiafna eligim fwaiyeba asa ka sipsipim kwaganife. ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Afa mingnag sipsip eba kana afa ehengel mas hwa bog megam afohie mo. Afa ehengel gafa sama kana mo higinim afa kam patalubigoiba afa ka lambinam mungu bog megam lasanife. Afa mungu anwasag el asa mungwali sipsipim nangwahiage lambfie gofife. ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Afa kana lahagna mona ka mas enam kwenai asa Alag kam fwina membenag. Afa ka kiafna nofkena fwaiyeba asa ka pese flafe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mas amban el kana lahagna mina wefug fwaiye eba kiafna onigig la asa ka kiafna eligim fwaiyefe. Afa kaba wasneigni feg kiafna eligim fwaiyenam afa ka wasneigni feg asa enag nofkenagag pese flafe. Afa kana Alag hwa wasneig mo kam faig asa ka enaig esefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Afa Ju el enag mo higinim asa hefum mungu mungu fiahgini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Afa kaksag el enaig esogona og, “Enag el eba sanel amtakwaligna afa ehe motet el lofeg. Haisegba ne ehena mo higini?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Afa mingnag enaig esogona og, “Amo, enaig el eba mas enaig sihife. Afa sanel mas noftet elim ugwe fati.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Afa ming Ju elni buyis puguna. Afa enag buyis seflig Godna kwania lala buyis. Enanam eba bu was afa ninegna. ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Afa Sisas Godna kwania lala gam ikanam afa wagiakafenaba enanai yi seflig Solomonna afwambag sime. ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Afa Ju el ehem muhla ambe apukenam afa esogona og, “Afa mungwanam nembefum ne sisageg kagel oksig enam nengiafogum. Sa ne kagelim ambala sihini atiaho ne Godna Gisfu Fwahag el me awai awai me?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Afa Sisas wahigi sihina og, “Ka nem ati sihinig afa nengel mas higig mo. Afa kana alagna wasneigni ka kigmog esena afa enag gafugag nengelim ogfunig ka amban maia. ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Afa nengel enam mas olug onigini mo. Afa ena enaig esigbi asa nengel mango kana sipsip mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Afa ka ati kiafna sipsipim anwenafenig afa ehengel kana mengigim higinim asa kam patalfug. ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Afa ka ehengelim wahkig nofkenagag faibi afa mas ambanim awaiye. Afa mas amban el kana ninganai blo ukwefe kike mungu ati feg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Afa kana alag ehengelim kana ninga la fwahag. Afa ehe mungwali elim gosenig asa mas amban el heafna ninga nai ehengelim ukwefe lambi. ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Afa ka i alag i kaningi mungu ahfeg.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Afa Ju el pese gwenaig esini fun flini ogna Sisasim funna tawagi, ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Afa Sisas ehengelim sihini og, “Ka nengelim kaksag kigmog ogfunig asa Alag eseg. Afa mangwal suialag ka esegba asa ne og kam ogna tigifati?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Afa Ju el wahigi sihini og, “Kagel mango neana gafugam enam esoni mo. Afa neana mo ne Godim moalamp onag asa kagel ogna nem tigi. Afa ne el nemug feg asa ne onigig og kaba God.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Afa Sisas esona og, “Nengelni nihe mo la God elim enaig sihifena og, ‘Nengel god lofig.’ ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Afa autunam God heafna nihe mo elim faini afa ehe enag elim seaflag eba god. Afa big anwenafig Godna mo eba nufunam wahkig gwenaig gofife. ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Afa God elim enaig sihfeniba asa kam haig esonafe? Afa Alag kam wegnageg fwahagim asa kam hwa bite gam ningihiag. Haisigbi ne esogog ka Godim molamp onag maia ka enaig sihifegba kaba Godna leg?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Afa ka kikeafna gafugag ese fwainigba nofeka kana mo higini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Afa ka alagna gafugag ati ka esenag. Afa nengel kana mo higigim oksi ofinifibi, afa kana kigmogim sa ne nangunim oniginim asa enag ne anwenafi Alag ka i hawag afa ka alag i hawag kaningi eba mungu ahfeg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Afa ehengel ogna pese ehem kehli afa Sisas lasan ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Afa Sisas pese Jordan bu gam ehengam maligim ikanam afohiefena. Enanai yi autunam Jon elim bu la laitina. ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Afa kaksag el ehem nangum ambena afa esogona og, “Jon mas mangwal kigmog ogfug mo afa mungwali mo Jon asa Sisasim sihinag eba nufuna feg.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Afa enanai yi kaksag el Sisasim olug onigini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Afa Betani nai el gihena heafna unehlagba Lasarus. Afa heafna muwalningi Maria i afa Marta i gafa gwenaig kembig la nai. ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Afa Maria eba enag angwafig Sisasim sanda bug sufuna afa heafna lapo ni ehena mongim titenagena. Heafna nisag Lasarus gihena.) ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Afa muwalningi Sisas nangum mo ahningihiana og, “Ainiyag neana hihe gihnagi.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Afa maia Sisas enag mo higinam afa ehe enaig sihifeni og, “Hwa gih asa ehem flag eba mas lahai. Enaig pugugba sama el Godna unehlagim fingifini afa Godna legim gwenaig esinifi.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Afa Sisas Martam, Mariam, afa Lasarusim asa ehengelim membeni. ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Afa maia Sisas ehenigina mom higinam afa ehe mas ikagna ikana mo. Ehe gwenanai yi gafena sambaga osuna. ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Afa maia sambaga osuna fenaba ehe patalfuiag elim enaig esoni og, “Ause big Judia gam pese afuiagim.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Afa patalfuiag el esogona og, “Tisa, mas manigeg mo enanai yi Ju el ogna nem funna tigi. Haisegba ne og ka pese susum ika?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Afa Sisas sihina og, “Ombusug eba osuna feg. Afa el osuna ikagba ehe mas mong kiakipe asa osu bitem ombusug faig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Afa el sinaini ikagba eba ombusug awai asa ehem mwelkiakipefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Afa Sisas enaig sihifenam afa ming mo sihina og, “Lasarus bigelni hihe eba ehe nongi afa ka ehem ilafofe.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Afa patalfuiag el esogona og, “Ainiyag, afa ehem gih behig fenam asa gifife eba suialafefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Afa Sisas Lasarusna lahagna mo sihinaba afa patalfuiag el enaig onigifini ehe esug nongi. ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Asa Sisas ehengelim ambala sihini og, “Lasarusba ati lahag. ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Afa maia lahagba ka mas enanai yi gafena mo afa ka nengelim sifakalinig asa ne kam olug onigini. Ause, nawo afu ehem nangu.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Afa Tomas (heafna ming unehlag eba Didimus) mingnag patalfuiag elim sihini og, “Bigel ehem mungwal patalfunam afa ehe alahafife eba bigel gafa pigiahiafe.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Afunam Lasarusna kembig la apukenam. Afa kembig la nai el ati Lasarusim fun megam afu fakini afa sambaga sambaga osuna enaig ati fena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Afa Betani eba muhla Jerusalem la go. ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Asa kaksag Ju el ambenam Marta mi Maria mi kusugugonim maia eheningina nisagim lahanibi. ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Afa maia Marta anwenafenaba Sisas muhla blofena asa ikanam Sisasim uflana. Afa Mariaba lala gafena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Afa Marta Sisasim sihina og, “Ainiyag, ne wanai yi gafiteba kana nisag mas lahaite. ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Afa ka ati anwenafeg glauwa gaba ne mangwalim sahnaiba Godim eba nem faife.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Afa Sisas ehem sihina og, “Neana nisag eba nofkenagag pese flagim.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Afa Marta esona og, “Ka anwenafeg maia God elim kwefihiagofefiba enanam asa ehe pese buihiafe.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Afa Sisas ehem esona og, “Kike enaig esefe, lahag elim ilafotiginam afa wahkig nofkenagag faife. Afa amban el kam olug oniginag asa lahag eba nofkenagag flafe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Afa amban el nofkena afohie asa kam olug oniginag eba mas lahai. Atiaho ne enag mo olug oniginag?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Afa ehe wahigi sihina og, “Ei Ainiyag, ka enag olug oniginag neba Godna leg afa Godna Gisfu Fwahag el asa God autunam ati sihi fwahana og ka nem bite gam ningihiafe.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Afa ehe enaig sihifenam lala gam pese ikanam afa Mariam sagmonam sihina og, “Tisa ati blog afa ehe nem awamona.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Afa maia Maria ena mo higinam asa buihianam ehe nangum ikagna ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Sisas mas kembig la puguna mo ehe gwenanai yi gofena asa Marta uflaguna.) ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Afa Ju el Mariam kusugunim afa lala auguiafena. Afa maia Maria buihianam kikini akofenaba asa ehengel ehem nangunim patalfuna. Afa ehengel onigini og ehe bite kife la ufwegim ako. ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Afa Maria Sisasim pugunam afa ehena mong yi kwakwage peganam afa enaig esona og, “Ainiyag, ne wanai yi gafiteba kana nisag mas lahaite.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Afa maia Sisas nangwagenaba Maria afa Ju el wewat fwahafenaba asa ehe kusugufenim afa ehena olug mas fwina suialafena mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Afa ehe ehengelim sahni og, “Hanai yi ne fakig?” Afa ehengel wahigi sihini og, “Ainiyag sa blo nangu.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Afa Sisas nob pe afenaba. ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Afa Ju el enam nangunim esogona og, “Niasabam, enag el heafna nihem fwina membenag.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Afa mingnag ehengelnai enaig esogona og, “Ehe enag el nof etetni elim nofug ati ugwe fatina afa ehe hwam gafa enaig esete Lasarus mas lahaite.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Afa Sisasna olug pese buihianam afa biteg kife gam ikana. Eba fun meg afa fun lolugni mengigim kagfuni. ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Afa Sisas esoni og, “Funim sa bigifla fati.” Afa lahag elni muwalig, Marta esona og, “Hei Ainiyag, eba amtakwalig nufug puguiagim ehe ati biteg kife la sambaga sambaga osuna feg.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Afa Sisas sihina og, “Ka nem ati sihinag afa ne kam olug oniginaiba eba ne Godna wasneig nangufe.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Afa ehengel funim bigifli fatini. Afa Sisas ofim sisi nofenam esona og, “Api ka nem suialag onag asa ne kana mo fahiginafe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ka ati anwenafeg ne kana mo fahiginafe afa ka hwa mo enaig sihifenife asa el hosa muhla afohie sama higinim afa anwenafi ne kam ningihiag.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Enaig sihi fwahanam afa ehe fwina unena, “Lasarus pugu blo.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Afa enag lahag el pugu blona afa heafna mongningam lofugna kikenagini afa mingnag lofug ehena nofbosugim kagfuni. Afa Sisas esona og, “Lofug piginagibi sama ikai.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Afa kaksag Ju el Maria nangum ambenam afa enag kigmog nanguni asa Sisasim olug onigini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Afa mingnag el farisi elim nangugim afunam afa enag mo sihigonugini asa Sisas esena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Farisi el i afa saglag pris i misog elni nof la laskuhlanam enaig esogona og, “Haig sa big esifi? Enag el kaksag haig haig kigmog ogfuiageg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Afa big ehem esug nangu fwaihibi afa ehe mingnag kigmog enaig eseiba asa mungwali el ehem olug oniginife. Afa mungwali el ehem enaig esinibi asa Romna misog el ambe nangunim asa Godna kwania lalam afa bigelni elim gafa amtakwalig klaitifi.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Afa mungu el ehengelnai heafna unehlag Kaiafas enanam prisni misog el enaig esona og, “Nengelni onigig weti feg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Sa hig, afa enag mungu el lahaiba eba suialafeg asa mungwali el mas awaiye.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Afa Kaiafas hwa mo enaig sihifena afa enag mo eba mango heafna onigig la enaig sihifiah mo. Enanam ehe prisni misog el fena asa enag mo sihina enaig Godna mo fli sihiaule el lofug fena. Hwa mo enaig sihifeg Sisasna lahag Ju elim kwaganigim. ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Eba mango Ju elim mungu kwagani mo afa Godna el asa mungwali goka afa ehena lahag ehengelim ulambinim asa Godna mungu el fifi. ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Afa gwenanam enag mo higinim afa mina yisgiagini Sisasim tigigim. ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Asa Sisas mas Ju elni nofla ambala ikana mo. Sisas afa heafna patalfuiag el bite behig gam muhla afuna. Ehengel Efraim kembig auguiafena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Afa Pasova buyis meyini ofefenaba asa kaksag el kembig fwahinim Jerusalem gam afunam afa Mosesna nihem esinim asa buyisim numwehiagini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Afa el Sisasim yisginim maia awaiyenaba asa Godna kwania lala laskuhlanam hefum sahwagini og, “Ne haig onigig fig ehe buyis la bloi me?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Afa saglag pris i afa farisi el i wasneig mo faig gona og, afa ne amban Sisasim nangwagba sa kagelim sihigonibi asa kagel afu ehem kehli. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Afa Pasova buyis meyi ofe eba enwesog la gohug osuna enanam pugufe. Afa Sisas Betani la puguna. Eba Lasarusna kembig asa enanai yi ehem lahanaba asa Sisas ehem ilafona. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Afa Sisasim fane numwehiagini. Marta fane magegiagena afa mingnag el i afa Sisas i sime la auguiafena afa Lasarus gafa mungwali auguiafena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Afa Maria sanda botolna kwania buihia flanam Sisasna mong yi sufunam heafna laponi titenagena. Asa suialag fungug lala la puguna. Hwa sanda eba kaksag kigna feg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Afa Judas Iskariot Sisasna patalfuiag el fena ehe mas sifakalena mo maia Maria enaig esenaba. Judas eba enag el asa Sisasim angoluwag elni ninga la fwahafe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Afa ehe ninimuna og, “Enag sanda bugba elim faigote sama 300 kigna flite asa big enag kigna gawig fwainig elim kwaganite.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ehe mango gawig fwainig elim onigini enag sihifiah mo. Eba ehe ukwef el. Afa ehe ehengelni kig fakehlafe asa ehe mingnag mo lambig meagam kumug enag hefum kweafug. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Afa Sisas esona og, “Afwai, nofeka ehem kwena. Hwa sanda bug ehe faka fwahanaba asa kana eligim numwehenageg biteg kife la fakigim. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","El gawig fwainig nengel nai yi wahkig afofife afa ka mas nengelim wahkig wangafi.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Afa Sisas Betani la gafena afa kaksag Ju el enam higinim asa afu Sisasim nanguni. Afa ogna Lasarusim gafa nangu asa lahagba Sisas ehem ilafona. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Asa saglag pris mo sihiagini ogna Lasarusim gafa tigi. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Asa ehena yi kaksag Ju el ehengelni misog elim fwatigim asa Sisasim olug onigini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Afa ming osuna kaksag el buyis nangugim ambegona afa higinim og Sisas hwa mina Jerusalem gam blo ikafe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Asa ehengel komb figeg totoaginim afunam ehem uflinim asa enaig esogona og; Godna unehlag kwania feg. Enag el God asa ningihiag sama God ehem suialafia flai. God sama Ju elni misog elim suialafia flai. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Afa Sisas donki flanam afa kuka ganam asa ikana. Afa maia ehe enaig esenaba asa Godna mo nufunam pugug. Autunam Godna mo ati enaig ginofi fwahini; ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Jerusalem la nai el, sa hig. Nofeka embefig, sa nangu, nengelni misog el donki la sisi oblo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Afa enanam heafna patalfuiag el enag mo mas onigini mo. Afa autunai la Sisas lahanam afa buihianam alag nangum pese kukafe asa enanam ehengel enag mo anwenafifi eba Sisasim sunig afa ehem kwefunim enaig esini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Afa el Sisasim nanguni maia Lasarusim ilafonaba biteg fenai asa enag mo sihiageafuna. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Afa kaksag el enag kigmog mo higinim asa ambenam Sisasim mina la uflini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Afa farisi el hefum sihiageni og, “Bigel mas ehem kwenig mo. Sa nangu, kaksag el bigim fwatigim ehem patalfug!” ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Afa mingnag Grik el Jerusalem gam afuna. Ehengelbi afwambanai el ogna buyis ambenam asa Godna unehlagim fingi fini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Afa ehengel ambenam Filipim sahni og, “Saglag kagel ogna Sisasim nangu.” Afa Filipna Kembig Betsaida Galili la nai. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Afa Filip Andrum sihinagim ikana asa eheningi Sisasim ahsihina. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Afa Sisas esona og, “Glauwaba asa God elim ogfunife Nufunam el eba kwania feg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Kike enaig kon fug lofug fe, kon gug enaig eseg afa ne mungu esug ningana flagiafiba eba gwenaig mungu fifife. Afa enag ne bite megam kumhlaiba asa noginam asa nog pugufe enag mungu lig yi kaksag gug fefe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Afa amban el hefim fwina onigkafife enag el eba awaiye fe. Afa amban el mas bitenaim fwina membeg mo afa heafna nofkenagag oksig asa enag el wahkig nofkenagagim numwehiageg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Afa amban ne kana gafugag esenag ehe sama kana onigigim patalblui. Asa ka hanai yi feg eba kana gafugag el gafa gwenanai yi fifife. Afa amban el kana gafugag eseg asa kana alag ehem suialag onafe.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Afa kana lahag muhla ofe asa kana olug kinig feg. Haig sihi ka fefe. Hwa kinig eba mog feg na ka blog. Asa masa ka enaig esofe, ‘O Api hwa kinig masa ne kana ninga la fwahafe.’ ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Afa ka enaig esofe, ‘O Api, sa ne nimbiafna unehlagim fingi fe!’” Afa God of la lagofena og, “Ka ati kiafna unehlagim fingi feg afa ka gwenaig pese esefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Afa kaksag el afofenaba enag mengigim higini. Afa mingnag el enaig esogona og, “Eba hug moasig!” Afa mingnag el enaig esogona og, “Amo, eba of la nai el ehem sihinago!” ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Afa Sisas ehengelim sihini og, “Enag mo mango kam kwefwag mo eba nengelim kwaganigim. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Afa enanam God bitenai elim kwefihiagefe asa ehe bitenai misog elim filafatife. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Afa maia el kam sisi kahlibi afa ka mungwali elim lambiba asa kam ambe muhlafinife.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Afa Sisas enag mo enaig sihifeni eba ogfug heafna lahag enaig esefe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Afa ehengel esogona og, “Godna buk enaig sihifeg Godna Gisfu Fwahag El wahkig gafife. Haisegba sa ne enaig sihifeg Nufunam Elim sisi yi kahlife? Kagelim sihini Nufunam El amban maia?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Afa Sisas sihina og, “Ombusug nengel nai yi mas wahkig gofi maia enag ombusug gofiba sa ne ati ika masa nem sikulufenafe. Asa el sinaini fakafe ehe mas anwenafe ehe asim ako. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Afa ka enag ombusug nem faig. Afa maia ka nengel nai yi gofiba sa ne kam olug onigini asa nengel enaig fi asa el ombusugni fakafe.” Afa Sisas enag mo sihi fwahanam asa lasanam ikana afa mas ambala gofena mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Afa Ju el kaksag kigmog nanguni asa Sisas esena asa ehengel ehem mas olug onigini mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Afa ehengel enaig esini asa Aisaiana mo nufunam puguna. Ehe Godna mo fla sihiaule el afa autunam ehe enaig esona og; O Ainiyag, ne ati nimbiafena kigmog ogfug asa kagel neana mo sihigonugbi afa ehengel mas higig mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Afa ehengel mas Sisasim olug onigini mo asa Aisaia ming mo pese sihini og; ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","God ehengelni nofugim kagfonig asa ehe mas nofihiagini mo afa onigigim kikisenig asa mas numwehe anwenafi. Afa God enaig esog afa ka enaig ese fwainigba eba ehengel kam pese oniginife asa ka ehengelim ugwetifefe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Autunam God Aisaiam itila ogfuna asa Sisasna wasneigim nanguna asa enag mo ehem sihinag. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Afa farisi el enaig sihifini amban ne Sisasim olug oniginafe asa nofeka laskuhlag lala gam ambe go. Afa kaksag Ju elni saglag el Sisasim olug onigini. Afa farisi elim embefegoni asa enag mo mas ambala sihiagini mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Afa ehengel fwina membig el sama ehengelim suialag goni afa Godim mas enaig onigifini mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Afa Sisas ambala sihina og, “Amban ne kam olug oniginag afa el kam asa ningihiag ehem gafa olug oniginafe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Afa amban ne kam nangufe afa el kam asa ningihiag ehem gafa nangufe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Afa ka hwa bite la blog afa ka elim ombusug faig asa mungwali el kam olug oniginife ehengel mas sikulufeg la afohiefi. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Afa amban ne kana mo higinam afa mas patalkui afa kike ehem mas kufeni. Afa ka mango bite nai elim kufenigim blah mo afa ka elim lambigim ka blog. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Afa amban ne kam mas fatinag afa kana mo mas kehlag mo afa maia kwefihiageg osuna hwa mo ka sihinag eba ehem kufenafe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Afa kana hwa mo enaig esefe asa ka mas kiafna onigig la enaig sihife. Alag kam ningihiag afa ehe kam wasneig mo faig asa ka gwenag mo flagim sa ka sihiageg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Afa ka anwenafeg heafna mo elim wahkig nofkenagag mina ogfunig. Asa mo ka sihig eba Alag kam faig naka sihig.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Afa enanam Pasova buyis meyini ofefenaba. Afa Sisas anwenafena ehe bite fwahiagim ati muhla ofe asa Alag nangum pese ikafe. Afa ehe heafna elim wahkig membenig fafefe asa hwa bite la feg asa ehena membug gwesim mungwal faifeni. ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Afa Satan ati Judas Iskariotim amtakwalig onigig faina asa ehe Sisas angoluwag elni ninga la fwahafe. Enag Judas eba Saimonna leg. Afa Sisas heafna patalfuiag el mungwali augunam fane ahgafenaba. ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Afa Sisas anwenafeg Alag ehem mungwali wasneig ati faig asa mungwali ehem ahnai skaufenig. Afa ehe anwenafeg ehe Godim fwahia blog afa pese ikafe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Asa Sisas buihianam nineg lofug huguflanam afa taul agagig la kiaguna. ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Afa ehe bu sob yi sufunam afa sa heafna patalfuiag elni mongim gigiafenugena afa taul huguflanam asa enana titenugena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Afa ehe ogna Saimon Pitam enaig esena. Afa Pita enaig esona og, “Ainiyag, atiaho sa ne kana mongim gafa buna gigiafenai?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Afa Sisas wahig sihina og, “Mangwal ka eseg ne enag mas ilawo anwenafeg mo afa autunai la ne enam anwenafefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Afa Pita ehem sihina og, “Amo, nofeka kana mongim gigiafena.” Afa Sisas wahig sihina og, “Afa ka nem enaig esenag fwainigba eba ne mas kana patalfuiag el fenai.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Afa Pita esona og, “Ainiyag, afa enaig nufunafefe afa kam oksig mong behig gigiafegimba ka membeg sa ne kana eligim mungwali sufla.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Afa Sisas esona og, “Afa amban ne bu la sufe asa ehena eligbi ambug gofufe. Afa kembig la pugunam asa mong behig gigiafena. Afa nengelbi mungwali ambug afohie asa mungu el nengel nai mas enaig goh mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Sisas ati anwenafeg amban el afa ehem angoluwag elni ninga la fwahafe asa ehe enaig esog, “Nengelbi mungwali ambug afohie asa mungu el nengel nai mas enaig goh mo.”) ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Afa Sisas ehengelni mong gigiafe fwahinim afa lofug pese fatinam afa sime gam ikanam asa ehengelim sahtigini og, “Atiaho ne hwam anwenafig sa ka nem esenig? ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Afa ne kam enaig sefli fig Tisa afa Ainiyag eba ne suiala sihifeg asa kike enag elbi feg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Sa nangu! Kaba Tisa afa Ainiyag ka nengelni mongim buna gigiafenugeg asa ka esug gafugag elni gafugam esenig. Afa ne gafa nimbiafgelni nai elni mongim sa ne gigiafe gonugibi enaig eba suialafeg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Afa kati nem minaba ogfunig asa ka nem esenig sa ne mingnag elim enaig esegoni. ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Eba nufunam feg. Afa gafugag el mas gose eba misog el gose fakafe. Afa el asa mo flablug enag el mas gosei eba el asa ehem ningihiag enag el gose fakafe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Glauwaba ne enag nufunam mo anwenafig afa ne enam patalkuiba asa ne sifakali. ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Kana mo mango nengelim mungwali esoni mo. Ka nengelim awamonigim asa ka nengelim ati anwenafenig ne haig el maia. Afa Godna mo enaig sihifeg ‘Enag el ka fane mungwawli ahneule ehe kam amtakwalinagim.’ ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ka nengelim hwa mo osihini afa maia enagba puguiba nengel kam olug onigifie kike i afa kiafna mo i wahkig ka ahgofife. ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Eba nufunam feg. Ka elim ningitigi afa amban ehengelim awamogonibi eba kam gafa gwenaig esenig. Afa amban kam awamonaiba eba kana elim gafa gwenaig esigonug asa ka ningitigig.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Afa enag mo sihi fwahanam afa ehem olug kinig fenam asa ambala sihina og, “Eba nufunam feg nengelnai mungu kam angoluwagna ninga la fwahafe.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Afa patalfuiag el hefum fanangu feaginim afa etetiagini og ehe amban elim esonag. ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Afa patalfuiag el mungu Sisas asa ehem fwina membenag enag el Sisas i muhla ahwag fena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Asa Pita ehem mingigna sehneina og, “Sahna ehe ambanim esonag?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Asa enag el Sisasna elig nai yi muhla gafena afa enag sahna og, “Ainiyag, eba amban maia?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Afa Sisas wahigig sihina og, “Ka amba fane bug la fatinam elim faiba eba enag el kam esenafe.” Asa ehe amba bu la fatinam Judasim faina. Judas eba Saimon Iskariotna leg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Afa enanam Judas amba flanam afa ikagna Satan ehem simbagahlana. Afa Sisas ehem sihina og, “Afa ne mangwal enaig esofefiba sa ne ikagna ese.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Afa mingnag patalfuiag el auguiafena afa enag mo mas anwenafini mo haisegba Sisas ehem enaig sihifena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Afa Judas ehe kigim kehlag asa mingnag patalfuiag el enaig onigifini og Sisas ehem ningihiag ma ka buyisna fane lambi. Afa mingnag enaig onigifini og Sisas ehem ningihiag sama gawig fwainig elim kwagani. ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Afa Judas amba flanam asa ikagna afwambagam pugu kana. Eba sinaini ehe enaigba esena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Afa Judas maia ikanaba Sisas sihini og, “Ilawo God Nufunam elni wasneig ambala ogfufe afa Godna wasneig Nufunam el nai yi ambala pugufe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Kaba Nufunam el afa Godna wasneig ka nai yi ambala ogfuiba asa nangufi asa God ehe kana wasneig elim ogfunife. Ilawo God enaig esefe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Kana luwal, ka mwakwalig ganam afa ikafe. Afa nengel kam ogna yisigi afa ne kam mas nangui. Afa Ju elim hwa mo ka sihinig nengelim gafa gwenaig mo ka nem esonig, ‘Asim asa ka ako nengel mas ambe.’ ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Afa ka nengelim glaunai nihe mo faig. Eba enaig esog sa ne nimbeafgeli nai fwina membiagi. Asa ka nem fwina membenig sa nengel gafa gwenaig esi nimbeafgel naim sa ne membiagi. ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Afa ne enaig esegba mingnagim membegonife asa mungwali el anwenafifi ne kana patalfuiag el.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Afa Saimon Pita sahna og, “Ainiyag, asim ne ako?” Afa Sisas sihina og, “Asim sa ka ako ilawo ne kam mas patalblui afa sumi yi ne kam patalkufe.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Afa Pita sahna og, “Ainiyag, haisegba ka mas nem gla patalkui? Asa el biningim sofegonifibi ka mas lahagim embefe!” ");
INSERT INTO amn_amanab_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Afa Sisas sihina og, “Atiaho ne enaig nufunam esefe? Afa kana kugum flanam asa lahafe? Eba nufunam feg afa kakaruk mosigim meyifefiba afa ne sambaga mungunagim ne enaig esofe ka mas ehem anwenafenag mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Afa Sisas patalfuiag elim enaig esoni og, “Masa nengel fwina kusgufifi afa olug kinig feskofifi. Sa ne Godim olug onigini afa kam gafa gwenaig esini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Afa kana Alagna lalaba kaksag skag gohka. Enaig nufunam fwainigba ka mas nem enaig esoni. Asa ka nengelni skag numwehiage gim ka ako. ");
INSERT INTO amn_amanab_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Afa ka nengelni skag numwehiagenam asa ka pese blonam nengelim lambinam asa big mungwali enanai yi afu augufe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Afa hwa mina ne anwenafig mo ka asim ako” ");
INSERT INTO amn_amanab_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Afa Tomas ehem sahna og, “Ainiyag, kagel mas anwenafig mo asim ne ako! Haig ka esigbi asa ka ena minam afuiagimba anwenafifi?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Afa Sisas wahigi sihina og, “Afa el membeg nufunam mo anwenafigim afa nofkenagag fligim eba kike ena minaba feg. Afa Alag nangum afuiagba mas ming minaba goh mo, eba awai, kike mungu feg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Afa ne kam numwehe anwenafigbi eba kana Alagim gafa ne ehem anwenafifi. Glanuwo ne ehem anwenafig afa ne ati nangug.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Afa Filip sihina og, “Ainiyag, nimbiafena Alagim kam ogfunibi asa ka enam nangufi eba kagelni sahigbi ati ihlafeg.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Afa Sisas esona og, “O Filip, big wahkig ahwagiahkaba. Afa haisegba ne kam mas anwenafinag mo? Afa amban ne kam nangug eba ehe ati Alagim nangug. Afa haisegba ne kam esonag, ‘Kam Alagim ogfuni?’ ");
INSERT INTO amn_amanab_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Afa Alag ka i ahgohug afa ka Alag i ahgohug; afa ne enam mas onigig mo? Afa mo ka nem sihinig eba mango kana mu mo eba kiafna Alag ka i ahgoba enag ehe heafna gafugafeg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Sa ne kana mom onigim asa ka nem sihinig ka Alag i ahgohug afa Alag ka i ahgohug. Afa awaiegba sa ne kana kigmogim pese onigigim asa ne kam olug onigini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ka nem nufunam sihinig amban el kam olug oniginafe eba ehe gafa gwenaig kigmog esefe asa ka eseg. Afa enaig elni gafugag kana gafugagim goseg asa kaba Alag nangum ako. ");
INSERT INTO amn_amanab_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Afa mangwalim ne kana unehlag la sahiba eba ka esefe asa ka Leg Alagna unehlagim fingifefe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Afa mungwali mangwalim gafa ne kana unehlag la sahiba eba ka esefe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Afa ne kam fwina membenagba eba sa ne kana mom ugwe patalkufei.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","“Afa ka Alagim sahnam asa ehe nengelim ming Kwefwag el ningihianife eba nengelim simbigahlanam wahkig wangofife. ");
INSERT INTO amn_amanab_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Enag Kwefwag el eba Godna Sungwabug asa Godna nufunam mo ambala nem pugunife. Afa bitenai el ehem mas nanguni afa anwenafini mo asa ehem mas suguflini mo. Afa ne ehem ati anwenafini asa ehe nengelim wangofna afa nengel i sefugofna. ");
INSERT INTO amn_amanab_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Afa ka nem mas fwati ofenaiba bontag luwal lofug. Afa ka nem pese blonam nangwag fe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Afa mungwanam feg fwainig bitenai el mas kam nangui afa ne kam nangufi. Ka nofkenafeg asa nengel gafa nofkena augufi. ");
INSERT INTO amn_amanab_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Afa enag osuna puguiba ne anwenafife ka kiafena Alag i ahgo afa ne ka i ahgo afa ka ne i ahgo gwenaig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Afa amban el kana nihe mo kehlanam patalbluiba eba enaig el kam fwinam membenag. Afa sonaig el kam enaig esenaiba afa kana Alag ehem membenafe afa ka gafa gwenaig esenam asa ka kefum ehem ambala pugunafe.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Afa ming Judas (ehe mango Judas Iskariot mo) ehe enaig esona og, “Ainiyag, haisegba ne ona nimbefum kam ogfuni afa ne mas nimbefum mingnagim mungwali ogfunig mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Afa Sisas wahigi sihini og, “Amban kam membenafe eba kana mo higigim patalblug. Afa kana Alag ehem membenag asa kaningi ahblonam enag el i ahgofife. ");
INSERT INTO amn_amanab_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Afa amban mas kam membenai eba kana mo ehe mas patalblui. Ena mo ne higig eba mango kana onigig la blo mo awai, Alag kam ningihiag afa enag heafna mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Afa enanam ka nem wangofenaba ka nem hwa mungwali mo sihinig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Afa Alag kana unehlag la Kwefwag el ningihiafe. Enaba Godna Sungwabug afa ehe nengelim mungwali ogfunim afa ehe nengelni onigigim fokla lasaniba asa ne enam pese onigifi mo sa ka nem sihini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Ati muhla ofe ka nem lasanife afa kaba olug enesiegna feg enag enesieg ka nem faifi. Bitenai elbi mas nem enaig olug enesiegba fai, eba awai. Asa nofeka fwina oniginim afa embe olug fli. ");
INSERT INTO amn_amanab_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Afa ne kana mo ati higini ka enaig esona kog ka nem lasan ikanam afa ka nem pese blo pugunife. Afa Alag kam gosenag. Afa ne kam membeniba sa ne sifakali ka Alag nangum kako. ");
INSERT INTO amn_amanab_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Hosa ka nem ilawo osihini eba autunai la sa pugufe. Maia enag puguiba sa ne enam onigifi asa ne anwenafifi kana moba nufunam feg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Afa Satan bitenai misog el ati oblo asa ka haiseg nem fwina sihin goh mo. Afa heafna wasneig mas kam ihlafenag mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Afa bitenai el sa ma anwenafi ka Alagim membenag. Ehe kam esonagba na ka ehena gafugag mungwali esenag. Au ambe nawo afu.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Afa Sisas enaig esog, “Kaba nufunam we afalig afa kana Alagba asona mogba feg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Afa mungwali iklig asa ka nai yi afo afa mas fug lugug mo afa ehe higfeitifefe afa mingnag iklig asa fug lugug ehe enaba ombusugnugegba sa ma kaksag fug lugwage. ");
INSERT INTO amn_amanab_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Afa kana mo ati ka nem faig eba enag mo nengelim ombusunugegba asa ne afsug afohie. ");
INSERT INTO amn_amanab_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Sa ne ka i ahgohi afa ka gafa ne i ahgohfife. Afa iklig afalig i kufeg fwainigba eba mas fug lugui. Eba mungwalofug gwenaig feg afa ne ka i ahgohug fwainigba eba ne nai yi fug mas lugui. ");
INSERT INTO amn_amanab_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Afa kaba we afalig feg afa nengelbi iklig feg. Afa el ka i ahgohug afa ka ehe i ahgohug asa ehe kaksag fug lugufe. Afa ne ka i ahgohug fwainigba eba mas ne mangwalim gafa esei. ");
INSERT INTO amn_amanab_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Afa amban el ka i ahgohug fwainigba ehe enaig li iklig lofeg asa higfei susugbi asa fofeg. Afa enagba lambigim suwi la wehlig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Afa ne ka i ahgohfiba afa kana mo gafa ne nai yi ati goh asa ne nimbiafena membug la Alagim sahnaba afa ehe nem enaig esenafe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Afa maia ne kaksag fug lugugba asa enaba ogfug ne kana patalfuiag el fegba asa kana Alag unehlag kwania flag. ");
INSERT INTO amn_amanab_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Alag kam fwina membenag afa ka gafa nengelim gwenaig esenig. Sa ne wahkig kana membug la afohiefeim. ");
INSERT INTO amn_amanab_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Afa ne kana mo patalfuiba asa ne kana membug la afohiefim. Eba gwenaig ka gafa kiafena Alagna mo patalkug asa ka heafna membug la ka goh. ");
INSERT INTO amn_amanab_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Afa ka nem hwaig sihiofeni kana sifakal sa ma nengel nai yi pahlaiba afa enag sifakal nengel nai yi gofiba eba nem ihlafenife. ");
INSERT INTO amn_amanab_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Afa kana nihe mo hwaig esog afa ka nem membenig asa nengel gafa mingnagim gwenaig esegoni. ");
INSERT INTO amn_amanab_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Kwania membug eba enaig feg el sa ma heafna nofkikenag fwahanam asa heafna hihem kweagfug. ");
INSERT INTO amn_amanab_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Afa ne kana mom patalfuiba eba ne kana hihe feg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Afa Sisas esog, Ka mas nengelim esug gafugag el oni eba misog el mangwalim onigigba afa heafna esug gafugag el mas enam anwenafi. Afa ka nengelim esonig neba kana hihe feg asa mungwali mangwal Alag kam ogfunag eba enag ka ati nengelim ogfunig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Afa ne mas kam kanogni mo, amo ka ati nengelim kanog fwatina asa ne afu gafugafibi sa ma enag fug lugui. Afa enag fug sa ma wahkig gofi. Asa mangwalim kana unehlag la Alagim sahnibi eba ehe enag nem faifi. ");
INSERT INTO amn_amanab_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Afa kana nihe mo enaig esog sa ne enaig esi, ‘Sa ne nimbefum fwina membeagi.’” ");
INSERT INTO amn_amanab_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Afa Sisas esog, “Afa bitenai el nengelim olug kakagfegonibi sa ne pese onigi ehengel ati gof kam enaig esini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Afa ne bitenai fegba eba bitenai el nem membegonifi, amo ka nem ati kanog fwatig asa ne bitenai nihe fwahia afa ne enaig esibi asa bitenai el nem olug kakagfegonifi. ");
INSERT INTO amn_amanab_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Sa ne pese onigifi mo sa ka nengelim sihinig, ‘Afa esug gafugag el mas misog elim gosenai.’ Afa ehengel kam amtakwal feflibi eba nengelim gafa gwenaig esegonifi. Afa ehengel kana mom higigbi eba nengelni mom gafa gwenaig esifi. ");
INSERT INTO amn_amanab_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Afa ne kana el fegba asa ehengel nem enaig esegonife. Afa Alag kam ninihiagba na ka blog afa ehengel ehem mas anwenafig mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Afa ka blo ehengelim mo sihinig fwainigfefiteba ehengelni nufweh mas goh mo. Afa glawo ehengel mas enaig esogoi kagel mas anwenafig mo mangwal ka esig eba amtakwalig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Afa amban el kam olug kakaginibi asa ehe gafa kana Alagim gwenaig esinig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Afa ka ehengel nai yi olyi kigmog ogfug afa mas amban el enag enaig esena mo. Afa ehengel kam mas olug onigigim asa ehengelni nufweh eba gwese goh. Afa glawo kigmog ati nangugim afa ehengel ka mi kana Alag mi olug kam kakage gonig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Afa autunam ehengelni nihe mo enaig esog; Ehengel kam munum olug kakagini. “Afa glawo enag mo nufunam pugug. ");
INSERT INTO amn_amanab_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Afa ka Godna Sungwabug nengelim ningihianife. Afa ehe Alag i ahwag asa blonam nengelim kwaganife afa heafna mo eba nufunam. Afa heafna mo eba kana mom sihinafe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Afa mulug yi nengel ka nai yi afohiafena asa ne gafa mingnag elim kana mom sihigonifi.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Afa ka nengelim enag mo sihinig asa nengelni olug onigig nofeka amosna pese afu. ");
INSERT INTO amn_amanab_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Afa ehengel nengelim laskuhlag lala afwambala lambaitife. Afa sumi yi enag osuna puguiba el asa nengelim kwagihig ehengel enaig onigififi og ka Godim kweagfug. ");
INSERT INTO amn_amanab_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Afa ehengel Alag mi ka mi mas anwenafegonig mo asa ehengel enaig esifi. ");
INSERT INTO amn_amanab_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Afa ka nengelim enaig mo sihinig asa enaig kinig osuna opugufiba sa ne pese onigifi asa ka nem numwehiawagig mo sihinig. Afa lasflam yi ka ne i ahgofena asa ka mas nengelim enag mo sihini mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Afa glawo ka Alag nangum ako afa ne mas kam sahnag mo, ‘Ne asim ako?’ ");
INSERT INTO amn_amanab_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Afa glawo ka nem hwa mo sihinig asa enag nengelni olug kinig feskofeg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Afa ka nem nufunam mo sihinig afa ka nengelim fwaha ikaiba enagba nengelim suialafenig. Afa ka ika fwainigba Godna Sungwabug nengelim mas bloni. Afa ka ikagba eba ka ehem ningihiafe nengel nangum. ");
INSERT INTO amn_amanab_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Afa maia ehe bloiba ehe bitenai elim amtakwalig nihe afa suialag nihe afa kwefihiag nihe enag sihinugefe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Afa el kam mas olug onigini asa ehe ehengelni amtakwalig nihem ogfunife. ");
INSERT INTO amn_amanab_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Afa ka Alag nangum ikafe afa nengel mas kam nangui asa ehe suialag nihe sihinugefe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Afa God bitenai elni misog elim, Satanim, ati kwefihiageg asa Godna Sungwabug elim kwefihiag nihe sihinuge fwahag. ");
INSERT INTO amn_amanab_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Afa ka membeg kaksag mo nem fai afa ne mas enam ihlafig mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Afa Sungwabug ehe Godna nufunam mo kehlag afa maia ehe bloiba ehe nengelim mungwali nufunam mo ogfunugefe. Afa ehe mas heafna onigig la nengelim sihini amo, afa mangwal ehe higig eba enam sihife. Afa mangwal sumi yi sa pugufe ehe enam nengelim sihinife. ");
INSERT INTO amn_amanab_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Afa ehe kana mo flanam afa nem sihinife asa ehe kana unehlagim fingi fefe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Afa mungwali gawig Alagna feg eba kana. Asa ka ati sihig Sungwabug kana mo flanam nem sihinife.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Afa Sisas enaig esog, “Mwakwalig afa ne kam mas nangui asa manigeg fwainig ne kam pese nangufi.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Afa mingnag patalfuiag el hefim sihiageni og, “Mangigim bigim enaig esonug, ‘Mwakwalig afa ne kam mas nangui asa manigeg fwainig ne kam pese nangufi’ afa mingam ehe enaig esog ‘Ka Alag nangum ako asa enaig pugufe.’ ");
INSERT INTO amn_amanab_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Enag mo ‘Mwakwalig’ eba mangwalim esog afa enag ehena mo bigel mas anwenafig mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Afa Sisas anwenafeg ehengel enam mo onigiafufnaba ona ehem sahni asa ehe sihini og, “Ka esog ‘Mwakwalig afa ne kam mas nangui asa manigeg fwainig ne kam pese nangufi.’ Atiasi enam ne nimbefum sihiageafu? ");
INSERT INTO amn_amanab_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Afa ka nem nufunam sihinig afa ne wewatinim nob mela auguiafiba afa bitenai el eheba sifakalifi. Afa ne olug kinig feskofeg afa nengelni kinig eba waikefe sifakaleg pugufe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Sa hig, maia luwal gohugum ofeba eba angwafig susug mu gof flagim. Afa maia luwal mo gohugba asa angwafig mas pese susugum onigi eba ehe sifakaleg luwal ati gohug. ");
INSERT INTO amn_amanab_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Nengel gafa gwenaig esifi, glawana mo ne olug kinig flinim afa ka nem nangwagiba eba ne sifakalifi. Enag sifakal mas amban nengelni nihinai huguflaiti.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Afa enag osuna puguiba eba ne mas kam mangwalim sahini. Ka nem nufunam sihinig mangwalim ne kana unehlag la sahiba asa kana Alag nem faife. ");
INSERT INTO amn_amanab_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Afa glawa gafa nengel kana unehlag la mas mangwalim sahig mo. Sese ne sahiba ne flafe asa nengelni sifakaleg ihlafefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Afa Sisas enaig esog, “Ka nem ati lasug mo sihini afa enag osuna puguiba ka mas nem lasug mo sihini asa ka ambala kiafna Alagna mom nem sihinifi. ");
INSERT INTO amn_amanab_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Afa maia enag osuna puguiba ne Alagim kana unehlag la sahnaiba, ka mas enaig esog enanam ka nem kwefunam ehem sahani, amo, ");
INSERT INTO amn_amanab_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Ka mas nengelim enaig esini eba kiafna Alag ehe nengelim fwina membenig. Afa ne kam fwina membeni afa ne onigig God kam ningihiag naka blog asa ehe nengelim membenig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Eba nufunam feg ka kiafna Alagim fwahagim naka hwa bite la blog afa glawo ka hwa bite fwahanam asa ka pese Alag nangum ikafe.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Afa patalfuiag el enaig esogona og, “Ei, glawo ne ambala sihig afa ne mas lasug mo sihig mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Afa glawo kagel anwenafig ne mungwali ati anwenafeg mangofi kagel yiskosig nem ming sahnigim asa kagel ati olug onigig ne Godna blog.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Afa Sisas esoni, “Atiaho ne enam olug onigig? ");
INSERT INTO amn_amanab_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Higim, enag osu ati muhla ofe amo eba ati pugug asa ne mungwali kam fwahinim afuiaminefefe nimbiafgelni mungu mungu kembig gam asa ka kefwaimu gofufe. Afa ka mas kefwaimu nemug gofi eba kiafna Alag i ka ahgofufe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Afa ka nem enag sihinig asa ka nai yi afofum eba sa ne olug enesiegna afofufe. Afa hwa bitelaba kinig nengelim pugunife asa nofeka embefi eba kati bitenai nihe filafatig.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Afa Sisas ena mo sihi fwahanim afa ofim nangunam sa enaig esona og, “Api, kam lahag was ati pugug sa ne nimbeafna Legim fingi fe asa ma nimbeafna Leg nem fingi fei. ");
INSERT INTO amn_amanab_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ne kam kanog og sa ma elni misog el fei asa amban el kana ninga la lasanig eba ka ehengelim nufunam nofkenagag faifi. ");
INSERT INTO amn_amanab_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Afa nufunam nofkenagag eba enaig eseg asa ehengel nem ati anwenafig ne nufunam God mungu feg afa ka Sisas Krais ne kam ningihiag. ");
INSERT INTO amn_amanab_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Afa ena gafugag ne kam faina eba ati ka augig asa ka enaig fegba ka neana unehlagim hwa bite la fingi feg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","O Api, afa bite mahim fiahfenaba afa big ahwagfenaba enanam kana unehlag eba kwania fena. Afa glawo ka membeg nimbeafna nof la enag kwania unehlag ne kam pese fai. ");
INSERT INTO amn_amanab_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Afa enag bitenai el ne kam faina ka ehengelim sihinig afa nem ati anwenafig. Ehengelbi neana fena afa ne kana ninga la fwatig afa ehengel neana mo higigim patalfug. ");
INSERT INTO amn_amanab_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Afa mungwali kike mungu fegba ehengel ati anwenafig enag ne kam faig eba neana blog. ");
INSERT INTO amn_amanab_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Afa mungwali mo ne kam faig enag ka ehengelim faig asa ati flig. Afa ehengel anwenafig enag mo eba nufunam afa olug onigig ne kam ningihiagba na ka nem fwahigim ka blog. ");
INSERT INTO amn_amanab_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ka mas bitenai elim betenenig mo amo el asa ne kana ninga la fwatig eba neana feg na ka ehengelim betenenig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Mungwali el kana feg eba neana afa neana asa feg eba kana. Afa enag el ogfug kana unehlag eba kwania feg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Afa glawo ka hwa bite fwahanam nem nangwagim blofe afa ehengel sa bite la auguia. O Api, neba afsug nemug afa nimbeafna wasneig unehlag sa ne kam faig ena unehlag la sa ne ehengelim nangwaghiage fegofum sa ma ehengel mungu afofi asa big mungu nemug ahfeg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Afa maia ka ehengelim wangohfnaba ka ehengelim kagfufehiage gofna enag neana wasneigni ne kam fainaba asa ka enaig esena. Mungwali suialagofena mas amban awaiena mo afa el mungu awaiena. Autunam neana mo enaig sihi fefwahana enag el mungu awaiefe afa enaba nufunam pugufe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Afa ati muhla ofe ka neanangum blofe afa ka bite la gohba hwa mo ka esona asa kana sifakal sa ma ehengel nai yi ihlafeni. ");
INSERT INTO amn_amanab_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Afa ka neana mo ehengelim faig enag fligim asa mas enaig bitenai el apukeg mo asa ka gafa mango bitenai el mo. Asa bitenai el ehengelim olug kakag fegonug. ");
INSERT INTO amn_amanab_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ka mas nem esonai enag elim lambiba sa ma hwa bite la fwahi amo, ka nem enaig sahna fenag sa ne kagfufe hiage gofiba eba Satan mas ehengelim amtakwale klaiti. ");
INSERT INTO amn_amanab_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Afa ka mango bitenai el feg mo asa ehengel gafa gwenaig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Afa neana mo eba nufunam nemug feg. Ka membeg hwa nufunam mo sa ma ehengelni onigig la gohfi asa neana el nemug apukufe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Afa ne kam bite gam ningihiag afa ka gafa ehengelim hwa bite la ningitigife. ");
INSERT INTO amn_amanab_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Ka kefum nem mungwali faig asa ehengel gafa gwenaig neana nemug fig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Ka mango enag patalfuiag el mungu beteneni mo amo afa mungwali el asa patalfuiag elni mo higigim afa kam olug oniginig na ka ehengelim gafa ka betenenig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Afa ehengel sa ma mungu afohiefi asa big ahsafeg ne ka i ahgohug afa ka ne i ahgohug. Sa ma ehengel eba biningi nai yi afofi afa mungwali bitenai el sa ma onigi ne kam ningihiag na ka blog. ");
INSERT INTO amn_amanab_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Afa ne kam kwania unehlag faig afa ka ehengelim enaig unehlag faig asa ma ehengel mungu afohiefi asa big mungu ahfeg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Ka ehengelim wangohug afa ne ka i ahgohug sa ma ehengel mungu nemug fi. Asa bitenai el anwenafi ne kam ningihiagim afa ne kam fwina membenag afa ehengelim gafa ne gwenaig esenig. ");
INSERT INTO amn_amanab_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Afa hwa bite puguia fwainig fiahfenaba ne kam fwina membenam asa ne kwania unehlag kam faina. O Api, ka membeg mungwali el ne kam faig ma ka nai yi ohi afofiba sa ma kana wasneig nangui. ");
INSERT INTO amn_amanab_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Api ne suialag nemug feg, afa bitenai el mas nem anwenafenig mo. Afa ka nem ati anwenafeg afa el ne kam faina ehengel ati anwenafig ne kam ningihiag na ka blog. ");
INSERT INTO amn_amanab_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Ka ehengelim neana unehlag ogfunig afa nem ati ambala anwenafenig afa ka gwenaig siakafiba afa membug sa ne kam fenag sa ma ehengel nai yi gofi. Afa kike gafa ehengel nai yi gofife.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Afa Sisas betene fwahanam heafna patalfuiag elim wankana bu wetim pe pafekolina, ena bu seflig Kidron. Afa ena maligim aso ati gi asa ehe enam mina saiyefuna. ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Afa Judas eba mauule el anwenafena Sisas esim wanfaka fafegofe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Asa saglag pris afa farisi el Godna kwania lala anwasag el mi afa mingnag ami mi ningitigi. Afa ehengel wina maluna lambinim asa Judas esim wankana. ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Afa Sisas ati anwenafena mungwali enag ehem pugunafe. Asa ehe hilife ika gonam ehengel nai yi asa ehengelim sahtigina og, “Nengel ambanim ne yisigi ambeg?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Afa ehengel wahigi esogona og, “Sisas Nasaret la naim ka yisigi ambeg.” Afa Sisas esog, “Ena ka hwaba feg.” (Mauule el Judas mungwali afofena.) ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Afa maia Sisas esonaba og, “Ena ka hwaba feg” afa ehengel amosna afunam bite la apaiyena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Bugiagafe afohiafenaba afa Sisas pese sahtigina og, “Nengel ambanim ne yisigi ambeg?” Afa ehengel esogona og, “Sisas Nasaret la naim.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Afa Sisas sihina og, “Kati nem sihinig na ka hwaba. Afa ne kam kehligim ambegba afa enag patalfuiag el mo fwati sa ma afui.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Afa ehe hwa mo sihig asa heafna mo eba nufunam pugufe. Eba ehe enaig sihina og, “Mungwali el ne kam faina suialagofena mas amban awaiena mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Afa Saimon Pita pina skoflanam prisni misog elni gafugag elim tigena. Ehe ehena ninginai angugum higiaflaitina. Enag gafugag elni unehlag eba Malkus. ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Afa Sisas Pitam wasneig mo sihina og, “Pina pese gauwag la fangu! Ena kinig Api kam faig eba mas ka kwenai.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Afa Romna ami afa ehengelni misog el afa Ju elni anwasag el Sisasim kehlinim wena kikenagini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Afa ehengel Sisasim Anas nangum wanigafuna. Afa Anas eba Kaiafasna kowag. Afa ena yiana Kaiafas eba prisni misog el gofena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Enag Kaiafas Ju misog elim enaig sihifeni og, “Eba suialafeg enag elim mungu tigibi sa ma mungwali el suiala afohie.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Pita i afa mingnag patalfuiag el i sum Sisasim patalfuna. Prisni misog el enag patalfuiag elim anwenafegoni asa ehe Sisasim misog elni lalana bog megam patalfunam saiye afuna. ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Afa Pitam kwenimba asa ehe afwambala mengig muhla gofena. Afa prisni gafugag angwafig mengig la gofena. Afa ming patalfuiag el pese ikana angwafigim sihinam asa Pitam sefu wanikana. ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Afa enag angwafig angwaming Pitam sahna og, “Atiasi ne gafa ehena patalfuiag el si me?” Afa ehe esog, “Amo, kaba awai.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Afa nineg feskofenaba asa gafugag el i, anwasag el i suwi wehlinim nahbwag fiahfufnaba afa Pita gafa enanai yi afofenaba sa nahbwage gofena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Afa enanam prisni misog el Sisasim heafna patalfuiag el mi afa heafna ogfuiag mo mi enam sahnagini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Afa Sisas wahigi sihina og, “Ka hwa mo mungwali elim ambala sihinig. Godna kwania lala afa Ju elni laskuhlag lala ka enaig eseg. Ka mas meagam gafugafeg mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Haisegba ne kam sahnageg? Amban el kana mo sa higig ehengel ena mom ati anwenafig. Sa ne ehengelim sahtigi mangwalim sa ka sihina.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Afa maia Sisas esonaba anwasag el mungu Sisasim asank la pounam og, “Ne mangigim prisni misog el enaig sihifenag?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Afa Sisas ehem sahna og, “Afa kana mo mas suialafeg fwainigba eba sa ne ena mo ambala elim sihini hosa afohie. Afa kana mo ugwe ika fegba haisegba ne kam tigeg?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Afa we Sisasna ninga la gwese gofenaba afa Anas ehem prisni misog el Kaiafas nangum ningihiana. ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Afa Pita mahim nahbwage gofenaba afa el ehem sahni og, “Atiasi ne gafa ehena patalfuiag el si me?” Afa ehe esog, “Amo, kaba awai.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Afa prisni misog elni gafugag el mungu enanai yi gofena. Asa Pita ehena nilitem angugum higiflaitina. Ehe Pitam sihina og, “Atiasi ka nem nangunaba neba ehi aso la ahgofena?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Afa Pita pese sihina og, “Amo, kaba awai.” Afa ikagna kakaruk moasihina. ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Afa Sisasim Kaiafasna lala nai suguflinim asa Romna misog elni lala gam wanigafuna. Eba leana gubi fena asa Ju el ena lala mas saiye. Afa ehe membig Pasova buyis ahgagim afa Ju elni nihe mo enaig esog Ju el nofeka afwambanai elni lalam saiye. ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Asa Pailat afwambagam ehengelim nangum ikanam sahtigina og, “Mangwal ehe nem fenigbi na ne ehem sehinig?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Afa ehengel enaig sihifeni og, “Afa ehe haig haig eseg fwainigba ka mas ehem neana nangum wanig ambe.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Afa Pailat sihini og, “Nimbe pese wanigafunam asa nimbiafgelni nihe mona kwefihianagi.” Afa Ju el ehem pese sihini og, “Nengelni Romna nihe mo enaig sihifeg kagel mas elim kwefihianaginim tigifati.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Afa hwa enaig pugugba eba Sisas ati esona asa enag nufunam puguna. Enag mo ehe sihig ehe li katigeg la lahafe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Afa Pailat pese sefu ikanam Sisasim awamonam asa ehem sahna og, “Atiaho neba Ju elni misog el?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Afa Sisas esona og, “Enag sahig eba nimbeafna onigig la me awai amban el nem enaig sihifenagba na ne enaig sahig feg?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Afa Pailat sihina og, “Ka mango Ju el mo! Eba nimbeafna el i afa saglag pris i ehengel nem ka nangum wanigambe. Eba haig ne esenaba?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Afa Sisas enaig esog, “Ei kaba misog el feg afa ka mas bitenai elni misog el lofeg mo. Afa ka bitenai misog el lofeteba eba kana gafugag el ambe kam kwefutim angoluwag gim fegoniti asa mas ka Ju elni ninga la gofite. Afa mungwali el ka nangwaghiageg ehengel mas bitenai nihem onigi.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Afa Pailat ehem sahna, “Ei, neba misog el ehe?” Afa Sisas sihina og, “Ei, neana mo eba nufunam kaba misog el feg. Ka hwa bitegam ka blogum asa ka enag gafugafegim eba nufunam mo sihiagim asa mia kam wanigag. Afa amban el asa nufunam mo mungu patalkug enag el kana mo higig.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Afa Pailat sahna og, “Nufunam mo eba mangwal maia?” Afa ehe pese afwambagam pugunam Ju elim nangwag ikanam esona og, “Ka nangug enag el mas mangwal feg mo asa ka enaig eso ehem tigi ma lahai. ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Afa mungu mungu Pasova buyis ofibi nengel kam fasahinifi afa enanam ka kalabus el mungu nengelni ka fafwatife. Afa enag Pasova buyis opuguhba nengel membig ka sonag ‘Ju elni misog el’ nengel nai yi fwaha?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Afa ehengel ehem fwina esogona og, “Amo, sonag el eba awai, sa ne Barabasim fwaha.” (Afa eba ugwefule afa elim tigifatiule el.) ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Afa Pailat amiim esonibi sa ne Sisas kehlinim fliflifefli. ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Afa ami enaig esini afa we nasigna lambinim molukugunim Sisasna misog la hogolini afa tafnaig lofug ehem fatini. Afa enag misog elni mwakwalig wag ehem enaig esenagini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Afa ehengel ehem muhla apukenam afa mwakwalini ehem esogona og, “Sa nangu, neba Ju elni misog el.” Asa ehem pupufenagini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Afa Pailat pese afwambagam pugunam Ju elim sihini og, “Sa hig, ka ehem fahigenagegba ehe mas mangwal feg mo. Na ka pugu nengel nangum waniblug asa ne nangui.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Afa enag we nasig nai yi afa lofug tafnaig yi gwese Sisasna elig i afohiafenaba asa ehe afwambagam pugu blona. Afa Pailat ehengelim sihini og, “Na hwa elbi, sa nangu.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Afa maia saglag pris i anwasag el i ehem nangunim asa fwina esogona og, “Tigi, tigi ehem tiginim li katigeg la fli kahli.” Afa Pailat esoni og, “Nimbe membigbi sa ne wanigafunam li katigeg la sa ma lahai. Afa kike fahigenagegba afa ka onigig ehe mas mangwal feg mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Afa Ju el enaig esogona og, “Ehe enaig sihifeg kaba Godna leg afa kagelni nihe mo enaig gifig el enaig esogba sa ma lahai.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Afa Pailat ene mo higinam asa ehe fwina embefena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Afa ehe pese lalagam sefukanam Sisasim sahna, “Ne hanai blog?” Afa Sisas mas ehem mo kwegfulagna mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Afa Pailat ehem sihina og, “Haiseg ne mas kam mo kwegfulagnag mo? Sa hig, ka enaig wasneigni feg eba ka nem fwahai afa ka nem li katigeg la kahli.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Afa Sisas ehem sihina og, “Afa God nem wasneig faig fwainig fegba asa mas ne kam pigaupi asa el kam neana ninga la fwahig enag elni amtakwalig eba neanam gosinag.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Afa Pailat ena mom higinam afa mina yisigiafena Sisasim fwahiagim. Afa Ju el fwina esogona og, “Afa ne sonag el fwahiaiba asa ikafe eba ne mango misog el Sisarna hihe mo. Amban el sa esog kaba misog el feg enag el eba Sisarna angoluwag.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Afa Pailat ena mom higinam asa Sisasim afwambagam wanikinam kwefihiageg kife la pegana. Afa enag lala meg eba fun simena. (Afa Hibru mona seflig Gabata.) ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Afa sini Pasova buyis pugufe afa osu misosufgigim mahim fiahfenaba. Afa Pailat Ju elim esoni og, “Nangui nengelni misog el.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Afa ehengel fwina esogona og, “Tigi, tigi, ehem tigifati li katigeg la kahli!” Afa Pailat sahtigina og, “Ne membig ka nengelni misog elim li katigeg la fli kahlibi sa ma lahai?” Afa saglag pris enaig kwegfulagni og, “Sisar mungu kagelni misog el feg mingnag misog el eba awai.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Afa Pailat Sisasim ehengelni ninga la fwahaniba asa ehe li katigeg la fli kahlini. Asa ami ehem kehlinim. ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Afa ehe heafna li katigeg maia kufehlanamba asa wanigafuna. Afa mungwali afu ena bite la apukena eba seflig misog kig gig bite. (Afa Hibru mona eba seflig Golgota.) ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Afa enanai yi ehengel Sisasim afa ming sambaganigi el mi li katigeg la lambi kagini. Afa Sisas olyi luguna afa sambaganigi el mo ehbegam ahlugwagna. ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Afa Pailat esonibi asa li katigeg la enaig ginofini: ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Sisasim sa kahlini eba Jerusalem muhla afa enag ginof eba Hibru mona afa Romna mona afa Grikni mona ginofini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Afa Ju elni saglag pris Pailatim lagnana og, “Ne magigim enaig ginofeg ‘Eba Ju elni misog el’ sa ne enaig ginofeite ‘Ehe enaig esog kaba Ju elni misog el’”. ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Afa Pailat sihina og, “Mangofi, mo sa ka ginofeg ati gwenaig goh.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Afa ami Sisasim asa li katigeg la kahlinim afa enag sambaga sambaga ami Sisasna lofug flinim afa hefum mimagini. Afa ming nineg lofug flini eba mungu mas ming lofugna pahli kwelini mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Asa ami hefum enaig esogona og, “Ese big enag lofug koskofifi. Nawo satu enana sa gosisi maia amban aflafiba.” Afa ehengel enaig esigbi afa Godna mo ati gifini enag nufunam puguna. Enag mo enaig esog; Kana lofug hefum mimagifi afa kana nineg lofug flinim enana satu gosisifi. Asa ami enaig esini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Afa Sisasna afag, heafna sumineg, afa sambaganigi Maria ahfena, ming eba Klopasna angwag afa ming Maria Makdala lanai afa ambenam Sisasim muhla muhla afohiafena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Afa Sisas heafna afagim nangunam afa patalfuiag el asa ehe fwina membena nangunam maia muhla gofenaba afa afagim esona og, “Mia sonag el eba neana leg.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Afa ehe enag patalfuiag elim esona og, “Enag angwafig eba neana afag.” Afa enanam patalfuiag el ehem heafna lalagam wanikinam asa enag angwafigim suialafiahflana. ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Afa Sisas anwenafeg heafna mungwali gafugag ati augig. Afa ehe membeg Godna mo asagi sa ma enag nufunam pugui asa ehe enaig esog “Ka bu hefeg.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Afa miaklana bu botolna muhla gofena asa ulefle lofug enaig flinim miaklana bu la fighinim aga la pahginim fingi kwalig Sisasna memtog la nehini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Afa Sisas enag bu nenam asa ehe esona og, “Eba gwenaho!” Afa ehena misog hugfu penam afa ehe nufuna lahafena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Afa enag osuna eba Fraide afa ming osuna eba kwania buyis pugufe. Afa Ju elni saglag oksig enag osuna lahag el li katigeg la lugwagim asa ehengel Pailatim sahni og, “Sa ne mongim tutohianugeba sa ma ikagnaule pigigba asa melig mo li katigeg lanai lamb pei.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Asa ami afunam sambaganigi elni mongim tutohianugini asa Sisasna muhla katigini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Afa ehengel Sisasim ambe nangunibi eba ati lahana asa mas ehena mongim tutohianagini mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Asa ehemba enaig esini ami mungu emesiegim fagna pifinaba asa taf i bu i sugfuna. ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","(Afa el enam nanguna maia enag pugunaba asa ehe ena mo sihiageg afa heafna mo eba nufunam feg. Afa ehe anwenafeg heafna moba nufunam asa ehe enaig sihifeg sa ma nengel enam olug onigigim kehli.) ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Afa enag pugugba eba Godna mom ihlafeg. Eba enaig esog, “Mas ehena mungu kigim tofui mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Afa ming Godna mo enaig esog, “El sa fagna pifina sa ma ehengel ehem enam nangwafufi.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Afa Arimatea kembig la nai el Josep blonam Pailatim sahna og, “Ma ka fwahaiba Sisasna eligim ka sa flauku.” Afa Josep eba Sisasim patalkuiaule afa ehe Ju elni saglagim embefenam asa ehe hefum kumwahlana. Afa Pailat ehem sawifenaba asa Josep ika flanam sa flaukuna. ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Afa Nikodemus i ehe i ahkana. Autunam Nikodemus Sisasim sinaini blo nanguna. Afa ehe 30 kilogram sanda i pauda i lambi lambluna. Enag sanda eba seflig mer afa alos. ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Afa eheningi Sisasna elig aflaukunam asa sandana paudana waheg ahfenam sa aitinag ahfena afa lofugna sagnag ahfena. Enag gafugag eba Ju elni nihe lahag elim enaig safifi. ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Sisasim asa tigi kahlini eba aso muhla. Enanai yi glaunai fun meg gofena afa mas enag fun meg la hugum skoafufna mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Afa enag fun meg muhla gofena afa Ju elni auguiag osuna muhla ofefenaba asa eheningi enanai yi Sisasim ahflauku ahfakana. ");
INSERT INTO amn_amanab_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Afa Sande leana si melam Maria Makdala nai biteg kifeg nangwagim ikana afa ika nangunaba fun asa mengigim kagfuni enag fun mengig lanai hilifu alganam fakinibi mengigba pigi gofena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Afa ehe kikini ikana Pita mi afa ming patalfuiag el mi Sisas asa ehem membena ehe ika ulambanam sihini og, “El ati Ainiyagna eligbi flifug asa kagel mas anwenafig mo hanai yi ehe ufufakig!” ");
INSERT INTO amn_amanab_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Asa Pita i afa enag patalfuiag el i biteg kifeg gam ahkana. ");
INSERT INTO amn_amanab_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Afa eheningi kikini ahkana asa ming el Pitam lasunam gof biteg kifeg gam ika puguna. ");
INSERT INTO amn_amanab_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Afa ehe mas seaifu kana mo ehe fisahfe penam biteg kifeg gam nofenaba lofug sa enana kikenagi fakini enam mungu afogwafena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Afa Pita sumi yi blonam biteg kifeg gam seaifu ikanam nangonaba lofug mungu afogwafena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Afa lofug Sisasna misog kikenagini enag lofug mas mungu la afogwafena mo eba alganam topeskesinim faki fwahini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Afa enag patalfuiag el sa gof biteg kifeg la ika puguna ehe gafa sa sefu ikana afa ehe nangunam asa olug onigina. ");
INSERT INTO amn_amanab_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Afa eheningi Godna mom mas enam numwehe anwenafena mo asa enaig sihifeg og Sisas lahanam pese biteg kifeg lanai buihiafe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Afa enag sambaga patalfuiag el pese lala gam ahkana. ");
INSERT INTO amn_amanab_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Afa Maria Makdala nai biteg kifeg la afwambala gofenam ufwe gofena asa fisahfe penam nofeagena, ");
INSERT INTO amn_amanab_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","afa sambaganigi oflanai elim nanguna afa ehenigina lofugba busug. Afa autunam enanai yi Sisasim fakini asa eheningi enaig ahsafena ming misog gam gana afa ming mongim gana. ");
INSERT INTO amn_amanab_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Afa eheningi ehem ahsahna og, “Angwafig, magigim ne ufweg?” Afa ehe esona og, “El kana Ainiyagna eligim flifug asa ka mas anwenafeg mo hanai yi ehem ufu fakig.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Afa ehe enaig sihife fwahanam asa waikefe Sisasim nanguna ma gofenaba. Afa ehe mas anwenafena mo ehe eba Sisas, ehe etetina. ");
INSERT INTO amn_amanab_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Afa Sisas ehem sahna og, “Angwafig, magigim ne ufweg? Ambanim ne yisige blog?” Afa Maria onigig enag el ehe asona mog asa enaig sihifena og, “Saglag, neaho Sisasna eligim wanaiba flaukug sa ka sihina hanai yi ne ehem fakag asa ka ika flanam uku.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Afa Sisas ehem sihina og, “Maria.” Asa ehe waikefe Sisasim nofbosug nehina afa Hibru mona sihig, “Rabonai.” (Enag mog mo eba tisa.) ");
INSERT INTO amn_amanab_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Afa Sisas ehem sihina og, “Ka mas Alagim pese nanguagim ikag mo asa nofene kam kehla. Amo, eba sa ne kana nilitem ika sihini og, “Ka kiafena Alag nangum pese ako ehe nengelni Alag eba kana God afa nengelni God.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Asa Maria Makdala nai higinam ikana patalfuiag elim sihini og, “Kati Ainiyagim nangug” afa mungwali mo sa ehe ehem sihina enag ehe sihiagena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Afa Sande osupegna patalfuiag el lala laskuhla gofena. Afa ehengel Juni misog elim embefegoni asa mengig kikisinim auguiafna. Afa Sisas ehengel nai yi olyi pugunam enaig esoni og, “Nengelni olug sa ma enesiegna gofi.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Afa ehe enaig esonam asa heafna ninga i afa heafna emesieg ehengelim ogfuni. Afa patalfuiag el Ainiyagim nangunim asa ehengel fwina sifakalini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Afa Sisas pese sihina og, “Nengelni olug sa ma enesieg gofi. Alag kam ningihiag asa ka gafa nengelim ningitigife.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Afa ehe enaig esonam asa ehengelim heafna efefug faini afa sihini og, “Nengel sa ma Godna Sungwabug fli. ");
INSERT INTO amn_amanab_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Afa ne mingnag elni amtakwalig huguflafatinagba asa ehena amtakwalig awaieg. Afa ne ehem esinig fwainigba asa ehena amtakwalig gwese gonfifie.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Afa Sisas heafna patalfuiag elim blona nangwagina afa enanam Tomas mas mungwal auguiafena mo. (Tomasna ming unehlag eba Didimus.) ");
INSERT INTO amn_amanab_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Asa mingnag patalfuiag el ehem sihini og, “Kagel Ainiyagim ati nangug.” Afa Tomas ehengelim esoni og, “Asa ka heafna ninga la nil gokug nangufe. Asa kiafena ninga bul nil gokug megam hugufenam asa kiafena ninga ehena fag gokug megam emesieg la hugufenai. Afa ka enaig eseg fwainigba ka mas nengelni mo higini.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Afa maia elegeg la gohug osuna awai enaba afa mungwali patalfuiag el lala megam auguiafena Tomas mungwali. Afa mengig ati kikisini afa Sisas olyi puguni afa esoni og, “Nengelni olug sa ma enesiegfe.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Afa ehe Tomasim esona og, “Kana ninga gokug nangunam afa nimbiafena ninga bul wanai yi hugufe. Asa nimbiafena ninga kana hagmagig megam hugufe. Masa neanai yi sambaga onigig gofufe enaig mo fwahanam asa ne kam olug onigina.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Afa Tomas ehem sihina og, “Neba kana Ainiyag afa kana God.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Afa Sisas ehem sihina og, “Ne kam nangugim asa ne kam olug oniginag. Afa mingnag el kam mas nangu mo asa ehengel kam olug oniginig ehengel sa ma sifakali.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Afa Sisas kaksag kigmog heafna patalfuiag elni nof la ogfuna afa enag mo mas hwa buk la afwaiye mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Afa ka hwa mo ginofeg asa ne anwenafenim Sisas eba Godna Gisfu Fwahag El ehe Godna leg. Afa ehe enam olug onigini asa heafna unehlag la sa ma ne nufunam nofkenagag flifi. ");
INSERT INTO amn_amanab_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Afa sumi yi Sisas Taiberius bu la heafna patalfuiag elim pese puguni. Eba enaig pugufena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Saimon Pita afa Tomas (heafna ming unehlag eba Didimus) afa Nataniel ehe Kena lanai kembig eba Galili provins lanai afa Sebedina sambaganigi luwal afa sambaganigi ming patalfuiag el mungwal auguiafena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Afa Saimon Pita ehengelim enaig esoni og, “Ka sawag lagum ako.” Afa ehengel ehem esoni og, “Bigel mungwal afuiagim.” Asa afu bot la augunam afuna afa ena sinaini mas sawag mungwa gafa flini mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Afa leana gubi osu puguiagim ofefenaba Sisas bu blug yi gofena. Afa patalfuiag el mas anwenafini mo enag el eba Sisas. ");
INSERT INTO amn_amanab_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Afa ehe ehengelim sahtigina og, “Oi nilite, atiaho ne sawagba lambig?” Afa ehengel wahigi sihini, “Amo, awai, kagel mas mungwag gafa flig mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Afa ehe ehengelim sihini, “Sa nimbiafgelni fufwala flinim nihiginai ehegam fati eba ne sawag lambifi.” Asa ehengel enaig esinibi asa sawag fufwalam memtog la puguiagenaba asa ehengel fufwalam fligim kinig usniafufna. ");
INSERT INTO amn_amanab_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Afa enag patalfuiag el Sisas ehem membena, ehe Pitam sihina og, “Eba Ainiyag ehe.” Afa Pita ena mo higinam ikagna nineg lofug mo pese flafatinam ogna Sisas nangum ika asa ehe bu la penam bu sus fakafe. ");
INSERT INTO amn_amanab_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Afa mingnag patalfuiag el bot la sumi yi ambena afa fufwala mo sawag nel lambilafuna ehgig gam. Eba bu blug yi muhla enaig 100 mita asa ehengel enaig esini. ");
INSERT INTO amn_amanab_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Afa ehengel ambe maligim apukenam nangunibi sawagna ambana suwi la afogafena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Afa Sisas ehengelim sihina og, “Sawag sa ne glawo lambig osum mingnag mo lambi.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Saimon Pita bot la pese fukunam asa fufwala mo maligim suflaukuna. Afa fufwala megamba 153 kwania sawag mungwali fena. Eba kaksag sawag fenam afa fufwalaba mas kwafona mo. ");
INSERT INTO amn_amanab_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Afa Sisas ehengelim sihina og, “Au ambe ahga.” Ehengel ati anwenafini eba Ainiyag asa ehem mas amban sahna mo og, “Neba amban maia?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Asa Sisas ika amba flanam asa ehengelim mimageni afa sawag gafa gwenaig eseni. ");
INSERT INTO amn_amanab_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Afa Sisas biteg kifeg la nai pese buihianam afa hefum uku patalfuiag elim ogfunibi enag eba sambaga mungu nangim esena. ");
INSERT INTO amn_amanab_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Afa ehengel fane ahgagi fwahinim asa Sisas Saimon Pitam enaig esona og, “Saimon Jonna leg, atiaho neana olug ka nai yi lugwa awai me ne mingnagim gosenig?” Afa Pita wahigi esog, “Ei Ainiyag, ne ati anwenafeg ka nem membenag.” Afa Sisas sihina og, “Kana sipsip luwaligim sa ne fane yuwig gofum.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Afa Sisas pese sahna og, “Saimon Jonna leg, atiaho neana olug ka nai yi lugwa?” Afa Pita wahigi esog, “Ei Ainiyag, ne ati anwenafeg ka nem membenag.” Afa Sisas sihina og, “Kana sipsipim sa ne nangwagihiage gofum.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Afa Sisas pese sahna og, “Saimon Jonna leg, atiaho ne kam membenag?” Asa Pita olug kinig fena maia Sisas sambaga mungu nagim ehem enaig sahna fenaba og, “Atiaho ne kam membenag?” Afa Pita wahigi esog, “Ainiyag, ne mungwali ati anwenafeg. Ne ati anwenafeg ka nem membenag.” Afa Sisas sihina og, “Kana sipsip sa ne fane yuwig gofum. ");
INSERT INTO amn_amanab_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Afa ka nem nufunam sihinag glawana ne kwablog fiahfenaba ne numwehiage fenam nimbeafna membug la ikafena. Afa maia ne watiaugba ne nimbeafna ninga aitiageba asa el neana ningam wena kikenaginim asa nem wanigafufe afa ne mas membeg mo esim ikagim.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Sisas enaig sihifena eba enag mo ogfug Pita sa haig lahafefe asa ehe Godim finig fefe. Afa ehe Pitam sihina og, “Sa ne kam patalku!” ");
INSERT INTO amn_amanab_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Afa Pita waikefenam sum nanguna enag patalfuiag el Sisas asa ehem membenag. Ehe sum patag la bluna. Autunam enag patalfuiag el buyis ahgafenaba asa ehe Sisasim muhla fenam sahna og, “Ainiyag, amban sa nem angoluwag elni ninga la fwahafe?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita ehem nangunam afa Sisasim sahna og, “Hwa elbi sa haig esefe?” ");
INSERT INTO amn_amanab_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Afa Sisas ehem sihina og, “Ka membeg sonag el sa ma nofkenagag gafiba sa ka pese blofe. Enaba mango neana mo mo. Afa neawo sa ne kam patalblu.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Afa Sisasna el ena mo higinim asa hefum sihiageni og sonag patalfuiag el mas lahai. Afa Sisas mas enaig sihifena mo. Afa ehe hwaig sihifena og, “Ka membeg sonag el sa ma nofkenagag gafiba sa ka pese blofe. Enaba mango neana mo mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Sonag patalfuiag el eba kike. Afa ka ena mom sihigim asa ka ginofeg. Afa mungwali anwenafig ena mo eba nufunam feg. ");
INSERT INTO amn_amanab_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Afa Sisas kaksag mingnag gafugag fiahgena. Afa el mungwali enag mom buk la ginofigbi afa mungwali bite sigag mas gohug mo enag buk enanai yi skugum. Gwenaho. ");
INSERT INTO amn_amanab_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","O Tiofilus, ka nem hwa ginof ningihinag hwa buklaba gof ka enaig mo ginofena. Sisas ilawana ehe mungwali mangwal elim ogfufenig feaka ikag lahag la pugugba God suluflag hevengam wanikig. Afa ika heafna patalfuiag elim pugunigim asa gafugag elim mo sihiafugum wegig fwatigba Godna Sungwabugni kigmog la ena mo sihinibi og, sa ma heafna gafugafeagi. ");
INSERT INTO amn_amanab_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Afa Sisas ilawana mo susug flagim afa lahag, afa sumi yi mo nofkenagag flagim ika gafugag elim puguni. Sa ma enam anwenafi. Afa pese buihianam 40 osuna gafugag elim wananamba asa nanguni. Afa Godna bog meg mo sihinugena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Enanam maisim wanafenaba enaig sihifeni og, “Nofeka Jerusalemba fwahi asa nengiaflafim mangwalim Api sa sihi fwahag nem esug faigim ilawana sa ati ka nem enam sihini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jon elim bula laitina afa ilawaba mas maisifei eba ne Godna Sungwabugni bula apaiyefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Afa enanam patalfuiag el laskuhlanam afa ehem sahini og, “Ainiyag enaiba ilawo gohnanam eseiba asa Israel ma pese pugu kigmoiba asa bigel misog el nangwaghiagefe?” ");
INSERT INTO amn_amanab_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Afa ehe pese sihini og, “Api sa enag osuna wegfu fwatig, eba mas ne enam anwenafi eba ehe heafa enaigimba nangwaghiageg. ");
INSERT INTO amn_amanab_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Afa ma nengigim Godna Sungwabug pe blonam nengelim gohoni bi asa ne kigmog flinim asa ne kana moaba Jerusalem la sihinim afa gwesim Judana mungwali bite afa distrik Samaria afa mungwali bite sa ma ihla gohwagei.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Sisas ena mo sihi fwahanam maia nangwaskafenaba asa ehe mo fuku leango megam seaifonaba afa mas nanguni mo. ");
INSERT INTO amn_amanab_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Afa maia fukukanaba afa ehengel maisim of gam nunof fiaskafnaba afa gwenanam ikagna sambaganigi oflanai el ahwangofena afa eheningina lofugba fwina busbusiagena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Afa sambaganigi el enaig sihi ahfeni og, “Ne Galili nai el mangigim munim ne of gamba nunof fiaska ena Sisasba eba God ehe suialaflag enag nem lasanig of gam fukukag eba gwenaig pese blofe asa ilawo ne nangugbi of gam fukukag.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Afa patalfuiag el Oliv mug fwahinim Jerusalem gam afuna. Jerusalemba Oliv mug muhla gifini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Afa enanai yi afu apukenam asa lalagam mo fukwali afuna. Enaba fukwali afunaba eba Pita, Jon, Jems, Andru, Filip, Tomas, Bartolomyu, Matyu, Jems eba Alfiusna leg, Saimon eba Selot ehgenai el afa Judas eba Jemsna leg. ");
INSERT INTO amn_amanab_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Mungwali enag laskuhlafenam asa mungu onigig flinim sa betenneafufena. Afa angwafig apaiyegona afa Maria Sisasna afag fena afa Sisasna nilite apaiyegona enag mungwali laskuhlafenam asa esifini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Afa enanam sa el Sisasim oniginibi eba ehegelni nambaba 120 enaig fena. Afa Pita olyi gohnam mo enaig sihi feni og, ");
INSERT INTO amn_amanab_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Ei, nilite autunam Godna sungwabug Devitim esenamba asa Devit mo sihina afa ena moba Godna buk la goh. Judasim sihinig og, sona elbi mauule el asa Sisasim angoluwagni ninga la fwahag asa enag ilawaba pugugba eba Devit ati sihi fwahana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Afa ilawana Judasba kagel yi gofnaba afa ehe mungwalofug gafugag kafini.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Judas amtakwalig esenam asa kig flanam afa enana bitem baimena afa sa negigim hefum mo ena bite la misogna penam afa atag pukonam asa lahana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Asa sumi yi Jerusalem la nai el mungwali enam anwenafini. Afa ena biteba heafgelni mona seflig Akeldama eba enaig esogog taf bite. ");
INSERT INTO amn_amanab_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Afa Pita pese sihina og, “Hwa moba ati mwanafi buk la gofena, enaig ginofini og; Heafna lala sama esug gofi. Ese amban enanai yi gafife. Afa ming ginof ena buklaba enaig esog; Sama ming el ehena kug la gohnam gafugafei. ");
INSERT INTO amn_amanab_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Afa nawu ambanim mungu wegi fwahi amban sa wahkig bigel nena gofena maia Sisas Ainiyag bigim wangofenaba. ");
INSERT INTO amn_amanab_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Sonaig elbi ati gofena maia Jon bula latiag el mo sihiakag ikag maia God Sisasim suluaflagba asa bigim lasanig sisi gam fukukag. Asa big enaig elim wegi fwahibi eba ati mungwali haig haigim lambusiageg sama bigim pahlanim Sisasna pese buihiag mom sihi.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Maia Pita enaig sihifenaba, asa sambaganigi elim wegi fwatigini eba Josepmi Matias mi. Afa Josep ming unehlag seflinibi eba Barsabas afa Jastus. ");
INSERT INTO amn_amanab_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Afa ehengel enaig betenini og, “Ainiyag, ati ne mungwali elni olnigigim anwenafenig sa ne kam ogfuni hwa sambaganigi elbi ambanim sa ne wegi fwahag. ");
INSERT INTO amn_amanab_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Asa ma kanog fwahag el pugunam Judasna kifegla blo gohi Judas ati fwahagim afa ehe awaieg kembig gam ikag.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Afa sa fun klaitini, ogma atiaba ambana fun opugufiba eba enaho Godna mo sihiakaule elbi ogoh. Asa Matiasna fun puguna afa sa Matiasim fwahini asa 11 pela Aposelim pahlani. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Afa maia Pentikos buyis pugunaba enanam Ainiyagna el mungu lala laskuhla gofena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Afa sa aune gweyi ikagna puguna heven la gohnam afa blona el laskuhlag lalam puguagena. Ofenaiba bifwat oblo. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Afa nangunibi ofenaiba suwi mileg blo kokohiagim afu elni nihiba lasai. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Afa mungwali elim Godna Sungwabug blo ihla fenugenaba asa haig haig mona lagwagini. Eba Sungwabug ehe esenigba enag sa haig haig moba lagwagini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Afa mingnag Ju el Godim lotu finig afa mungwali bite sa gohkafena enag ambe Jerusalem la gofena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Maia enag aune pugunaba asa kaksag el ambe laskuhlanam mom higwagafufna maia Ainiyagna el enaig esofifnibi asa sineminefini maia mungu mungug el ehengelni mona lagwag ofifinibi. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Enag Ju el fwina sineminefini afa esogona og, “Kati anwenfig sonag elbi eba Galili la nai, ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","haisegba asa big mungu mungu higigbi bigelni mona mog? ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Asa bigel Partiana kembig la nai afa Midia nai afa Elam la nai afa bigel mingnag distrik Mesopotemia la auguia enag feg afa distrik Judia nai afa Provins Kapadosia la nai afa Provins Pontus la nai afa Esia nai afa. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","distik Frigia nai afa Pamfilia nai afa Isip nai el afa distik Libia nai Sairini muhla nai afa bigel Rom la nai ambe ohi gohka. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Afa Ju afa minginag el Ju elni lotu nai afa Krit afa distrik Arebia nai bigel big mungwali ena mo biafgelni mungu mungu mona higig sonag elbi sihigbi eba Godna kigmogna gafugafig.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Afa mungwali olug fingi feskofenam onigwage aflafna. Afa hefum sihiagini og, “Sonaig pugugba ilawaba enaba mangwal maia?” ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Afa mingnag mo enaig mo sihini og, “Ei, eba uflogna bu ahgagim enag eba mo etetiag ofi.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Asa Pita 11 pela patalfuiag elim wan gohnam afa sa fwina unetigina og, “Nengel Judia nai afa mungwali el ambeg Jerusalem gohka sa kana mom higafufum asa ena mog sa ilawo mangwalba ne nangug ka nem ambala osihin. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ne enaig onigig, ne og sona elbi mo etetiag ofi. Amo eba awai, eba ilawo leanahe. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Afa ilawo enaigba pugug enaba autunam Joel Godna mo fla sihiaule el enaig sihi fwahana og; ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","God ati sihig awaiyeg osuna maia meiye ofefiba eba ka kikeafna sungwabugim mungwali elim ningihianife afa sa nengelni fangonai luwal i afa nainai luwal i kana mo fli sihiafufe afa kwablog el itila lofug haig haigim lambusiagifufe, afa watiawug el itila panangiagifi. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Afa enanam ka kikeafna sungwabug kikeafna gafugag saglag afa angwafigim ka faife asa kikeafna mo fli sihiafufufe. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Eba ka eseba asa ofla haig haig puguafi afa bite la gafa puguafi eba taf i suwi i afa suwieg i enaig puguagefe. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Afa osu kifiakofla fegifi afa was pugu tafnaiyi asa negigim Ainiyagna osuna mo pugufe enag osunam Ainiyag heafna kigmog i afa ombusug i ogfufe. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Afa enanam mungwali ambangel sa Ainiyagim uninife og, ma kam kwagani, afa sa ehe lambife asa ehengel wangineg augufefe. “Enaba Joel Godna mo fla elni mo sihi fwahag. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Ne Israel el numwehe kana mo higini ka nem osihin Sisas Nasaret la nai el, nembe ne anwenafini God ati ehena ninga la wasneigbi nem ogfunig. God ehem enaig esenagba nem og sama anwenafi heafa ehehe ena elbi ningihiagba asa blog. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Afa sona elbi God nengelni ninga la fwahag afa autunam ati oniginam ena moba kikise fwahana enaig esegim. Afa amtakwalig afwambanai el i nengel i ne li katigeg la kokufenagigbi asa lahag. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","God mas ena susugba gwesim fwahana mo, eba God sona elbi bite kifenai ihlafofatig mas ehem gwesim lahag mo. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Afa autunam Devit gafa enaig sihifena og; Ka Ainiyagim nangug kam blog wahkig muhla fenag asa ka mas mangwalimba embefenai. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Enaig fenaba enag sa kana olug suialag nemug go asa ka sifakal mo eseg, afa ka nengego eligim suialagim asa God membeg kam esenagim. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Eba mas ne kam elim pigieg kembig la fwahai, afa neana suialag gafugag elbi sa ne mas ehem fwahaiba asa mas bitelaba nogi. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ati ne kam ogfunag nofkikena flag minagagba sa ne ka i ahgofiba ka sa fwina sifakale. “Ena moba Devit sihi fwahag. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ei nilite, ka nem biafgelni simbianigam osihin, Devit ati lahag afa fakinibi afa ehena bitekife eba gweseg bigelnai yi olyi ilawaga go. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Afa Devit eba Godna mo fla sihiule el feg ehe ati anwenafeg God nufuna mo sihig og, nengigim ka neana mungu luwalim esenaba asa ehe nimbe lofug misog el gofe. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Enaig esena Devit gof ati anwenafena asa enaig sihifena og God Kraisim lahag la nai ihlafo lasufe asa ehe mas bitekife la gwesim nogig mo. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Afa sonag el Sisas eba God ati ehem bitekifenai ihlafofatigba asa ehe nofkikenaga. Afa enam ati ka nofna nanguig. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Afa Sisas ati sisi yi fukokag Godna nihiginai ninga la ga. Autunanam Alag ehem sihi fwahana heafna Sungwabug pe blofe. Afa ehe ati enam ningihiagba asa ilawaba ne enam nangug afa higig. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Devitba mas Sisas sa esena hevengam fukokana enaig esena mo. Afa Devit enaig esona, og; God ati kana Ainiyagim enaig sihifena, og, ne kana nihiginai ninga la gafife. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Eba ihlafefe ka angoluwag elim neana ninga la fwatiba sa ma nem ahnai skaufini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Asa Israel nai el mungwali ne numwehe nam anwenafi Sisasba nengel tigigim li katigeg la kahligbi God ati ehem gisfu fwahana og sa ma Ainiyag fenam asa elim lambi.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Afa maia mungwali el ena mom higinibi asa enag mo ehengelni olugim fingi feskofena asa ehengel Pita mi afa mingnag kanog fwatieg el mi sahigoni og, “Nilite, haig sa ka esifi?” ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Afa sa Pita sihini og, “Nengel sa mungu mungu mungwali olug waikefinim Sisas Kraisna unehlag la bu la apaiyeba sa ma God nengelni amtakwalig nihem fla fatini ma ne enaig esibi eba God nem heafna Sungwabug faifi. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","God ati autunam sihi fwahana Sungwabug nem faigimbi, afa nengelni luwal i afa membinai el i gwenaig esenife. Afa God bigelni Ainiyag mungwali elim ehe awamonigim gafa ati sihi fwahana.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Afa Pita mingnag kaksag mo sihinugenam afa wasneig mo faini og, “Numwehifibi masa nem amtakwalig el nahgum awaiefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Pita mo sihinaba asa kaksag el olug oniginim asa bula mo apaiyena afa mingnag ambe pahsihianaba ehengelni nambaba 3,000 enaig fena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Ehengel kanog fwatieg elni mom ati ugwe higini asa hefum fakwegfu feagini afa ambe mungu la laskuhlanam fane ahgafna afa betennifini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Afa God kanog fwatieg elni ninga la haig haig kigmog esenibi asa mungwali enam nangunim afa sineminefeagini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Afa mungwali el Sisasim olug oniginim mungwa mo hefum sihiaginim afa heafgelni mangwal mangwal eba mungwali ehengelni fena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Afa ehengel heafgelni bite i gawig i elim fwahiagonifinibi asa enanam kig flifnim asa heafgelnaim elim gawig awaiyegim mimagegonfini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Afa mungwali osuna Godna kwania lala laskuhlafenam afa mungu mungu lala laskuhlafenam fane ahagageafufna afa ehengel suialafiaginim sifakaligna auguna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Afa wahkig Godna unehlagim fingifini asa el ehengelim olug suialag gohnigbi. Asa Ainiyag mungwali osuna mingnagim lambfenaba asa ehengel Sisasim oniginig gwesim nup el fiagena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Mungu osuna Pita i Jon i beten ahfegim osu efilagna Godna kwania lala ahkana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Afa enanaba mingnag el mong kukwaligni atiubiafena wahkig gwenaig esefufna, ubifnam Godna kwania lala mengig muhla lasu fwahifini enag mengigba enaig sefli fini og, suialag mengig afa enag elbi maia el afu ena mengig la saiyeafnaba moni kamini feni aufna. Afa ehena mongug sa kukwalignaba eba afag wetila gwenaig wanigana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Afa enag elbi maia Pita i Jon i ahkana mengig la hopugufnaba asa nangwagnam kaminini og kam mangwal ahfai. ");
INSERT INTO amn_amanab_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Afa Pita i Jon i fwina ahnangwagohun afa Pita enaig esona og, “Osum kam nangwag.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Afa sa nangwagaufena, ehe enaig onigina og, eba kam mangwal ahfaife. ");
INSERT INTO amn_amanab_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Afa sa Pita enaig sihi fena og, “Kaningi kigba awai afa mangwal sa ka ahfeg eba ka nem ahfaigim. Sisas Nasaret la nai elni unehlagla nem kog sa buihianam ika.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Afa sa ehena nihiginai ningam kehlanam fukla lasunaba asa buihia gohna ehena mong kukwalig gweyi ikagna wasneina. ");
INSERT INTO amn_amanab_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Afa ehe psoakufe gohnam asa Pita mi Jon mi Godna Kwania lala gam patal ika seaifuna. Afa ehe seaifunam fapsok feakafnaba sa Godna unehlagim figifena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Asa mungwali el nangunim maia ikafenaba afa Godna unehlagim figi fukwiafnaba. ");
INSERT INTO amn_amanab_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Afa sa anwenafinim eso gona og, “Ai, sona elbi wahkig Godna Kwania lala ‘Suialag mengigla’ sefuag la fawofegofnaba kig kamini fafegofe.” Afa nangunim maia suialafenaba asa ehengelni olug figi feskofena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","El ena mom higni maia enaig pugunaba asa sineminefinim kikini ambegohna enag elim nangugim. Afa ambe nanguinibi ehe ati Pita mi Joni mi ketiginam gofna. Enam pugunamba eba Godna Kwania lala, afwambag sime la enaba seflig og, Solomonna afwambag sime. ");
INSERT INTO amn_amanab_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pita nangwaghiagenam enaig sihifeni og, “Nengel Israel el haig esegba sa ne sineminefig maia enaig pugugba, haig esegba sa ne kam fwinam nangwagsiga masa ne enaig onigigfife eba kaningina wasneig me amo kaningi afsug kabag el me asa sonagba esahfeg. Amo eba awai. ");
INSERT INTO amn_amanab_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Eba Abraham Aisak Jekopna God afa ehe bigelni simbianigana God. Afa ehe heafna gafugag elim Sisasim kwania unehlag faig. Afa enag elim ho ne angoluwagna ninga la fwahini. Afa maia Pailat og, na fwaha afa nengel ne ehem masig fatinim afa ne esogona, ne og Pailat nofene esug fwaha. ");
INSERT INTO amn_amanab_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Afa ehe afsug kabag el fegim afa suialag nihe mungwali feakafna. Afa ne ehem masig fatinim asa ne esogna og Pailat ambanim sa fwahafe enaig el eba kwaskog elim sa fwaha. ");
INSERT INTO amn_amanab_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Afa elbi eba nofkikenagag minam pigieg eba enag elim ne tigifatigbi asa God ehem pese bitekifenai ihlafofatig. Enam ka nofna ahnangugim nasa ka ena mo ahsihig. ");
INSERT INTO amn_amanab_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ka Sisasna unehlagim olug honiginaba asa sonag el mong kokwaligniba sa ugweg. Afa sonag glau sa ne nangug eba sa ne anwenafi eba Sisasna kigmogla eseg. Afa kaningi Sisasim olug honiginaba asa nengelni nof la sonag elbi ati ugweg. ");
INSERT INTO amn_amanab_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Nilite nufunam ati ka anwenafeg nengel i afa nimbeafigelni misog el i mas ne numwehe anwenafini mo nasa ne Sisasim enaig nihe fenagini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Afa autunam God mo fla sihiafule el nai yi megig la sihi fwahana og, eba heafna Gisfu fwahag el susug flafe. Nasa ilawaba ne enaig esefligbi. Asa enag esegba Godna mom ati nufunam pugug. ");
INSERT INTO amn_amanab_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Asa nimbeafgelni amtakwalig nihe mo masig fatinim afa waikefinim Godim oniginibi asa ma God nengelni amtakwalig nihe mo fla fatini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Afa atiaba ne enaig esigbi asa ne Ainiyag nai yi ambe muhla afohianam eba sa na wangine augufi. Sisas eba Godna Gisfu fwahag el afa God ehem ati kanog fwahana afa ehem sa ningihiaiba sa ma ehe blonam nengel nenam gofufe. ");
INSERT INTO amn_amanab_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Afa enag ilawaba heven la gahba nengego enag osuna God sa eso fwahag maia eseiba, asa mungwali gawig suialag pese pugu gohfe. Autunam ati ehe Godna mo fli sihiafule elni mengig la sihi fwahana ehe enaig gafugafegim. ");
INSERT INTO amn_amanab_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Autunam nengelni saglag el Moses enaig esona og, ‘God nengelni Ainiyag, eba God ehe nengel nai yi mungu el wegfu fwahafe asa pugu mo fli sihiafule el lofefe kike lofug. Asa ne ehena mungwali mom higinim patalfufe. ");
INSERT INTO amn_amanab_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Afa amban sonag elni mom higi fwainigba eba God ehem kwagi klaitifeba asa ehe mas Israel nenam agfofi.’ ");
INSERT INTO amn_amanab_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Autunai Godna mo fli sihiafule el Godna mo ati sihiafufna Samuel nai yi pugunam ikan mungwali sumi nai Godna mo fli sihiafule el nai yi pugug, ena mo sihinibi ilawo sati pugug. ");
INSERT INTO amn_amanab_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","God Abrahamim enaig sihifena og, ‘Neana simbianigag nai yi pugunam eba mungwali bitenai elim suialag fenugefe.’ Afa nengelbi Godna mo fli sihiafug simbianigag luwalig asa mangwalim sa sihi fwahig eba enam ne flifie. ");
INSERT INTO amn_amanab_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Asa God heafna gafugag elim nem gof ningihianig ogma nem kwaganiba asa nengel mungwali amtakwalig nihem fwatibi asa enaba nem suialafenig.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Enanam Pita i Jon i maisim mo elim ahsihiagofnaba afa Pris el i afa Sadyusi el i afa Godna kwania lala nai polisni misog el i ambe apukena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Afa apukenam eheningina mo higafofna. Eheningi ena mo ahsihina og, “Sisas ati lahagim pese buihiag asa el gafa gwenaig esifi.” Afa ehegel higinim mas ena mom membini mo. ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Asa sikuliofefenaba enaignam ketiginim kalabus lala fwatiginibi ikana lianafena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Afa kaksag el ena mom higinim olug onigig la kehlinim patalfuna. Asa enaig esinibi eba 5,000 la gohna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Afa liana apukenam Ju misog el i, saglag el i afa nihe mo ogfuiag el i Jerusalem gam laskuhlana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anas eba pris misog el blona afa Kaiafas na, Jon na, Aleksander na afa mingag mungwa usumuna apaiyena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Asa Pita mi Jon mi wanambe olyi lasanim sa sahigoni og, “Haisegba sa ne elimbi wangene feiti ahfeg? Mango kigmogna afa amban na unehlag la ne sa ahfeg?” ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Afa Godna Sungwabug Pitam ati ihlafenagenaba asa mo sihina og, “Saglag el i afa elni misog el i sahig. ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Ilawo ne kam sahigoni mangwal suialag sa ka sahfeg. Ati amban ne membig anwena ofifibi asa sona el mong kukwalni suialafegba eba haiseg, ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Nengel i afa mungwali Israel lanai el i sa anwenafi. Eba Sisas Nasaret lanai elni unehlag i afa heafna kigmog i sona elbi ati wangenefego. Eba Krais Godna Gisfu Fwahag Elim ne tigifatigba afa God ehem pese bite kife ihlafo fatig. ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Autunam Godna ginof Sisasim sihi fwahana, enaig esona og; Sona sumulba nengel lala nimblawagig el esugum fli fatig, eba naho God esenagba asa sumulba gohug. ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","God mas ming elim wefug fwahag mo elim pese lambigim, eba awai. Sisas mungu he bigna minaba go asa big Godna el afwahieg.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Pita i Jon i fwina wasnei ahgofenaba asa saglag el nangwaginim sineminefini og, “Hai, sona elbi esug el ahfena afa eheningi mas skul yi ahkana mo.” Afa ehegel anwenafini, ati eheningi Sisas nai yi ahogofena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Afa nangunibi el mong kokwaligni ati wangenefena afa sa Pita mi Jon mi wangofena asa ehegel mwalfwai afohiafna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Asa saglag el eheningim sihigoni og, “Afwambala ma puguia ahogofiba”. Asa hefum mo sihiawagini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Afa esogona, “Haig sa big esogonifi? Mungwali Jerusalem lanai el ati anwenafig eheningi fwina wasneig gafuga ahfeg asa big mas sihi hwaba mas pugu mo. ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Afa mas sa ena mom minganag kembig sihiageafufe. Nawo wasneig mo sihigon ma enaig esahfe, ese, Sisas na unehlagim elim mo ahsihinfe.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Afa sa awamogonim afa kwegoni ne mas elim ahsihinim afa hogfuni ena unehlagimba. ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Afa sa Pita i Jon i wahigi ahsihini og, “Neafa nimbe kwefihiagi mango maia Godna nof la suialafeg, ka nengelni mo ahpatalku me awai Godna mo ahpatalku me. ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Afa mas ka mwalfwai ahogofi. Asa ati ka ahnangug afa ahigig eba ka ahsihiagofufe.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Afa misog el sambaganigim fwina wasneig mo pese sihigonim asa lasani apuke afuna. Haisegon mo eba mungwali el mas misog el i mungu onigig flini mo. Afa God elim mong amtakwaligna wangenefe fatinaba asa mungwali el Godna unehlagim fingi fini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Enag elbi wangenefenaba eba 40 yia fegim sa gwese hilifeg. ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Enanam Pita mi Jon mi lasanibi asa heafa pese hefulual nangum ahkana. Asa ahsihina mangwal sa saglag pris i afa saglag el i eheningim esogoni. ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Afa higinim asa mungu onigig flinim sa Godim sahini og, “Ainiyag, nembe ne of i, bite i, bu i afa mungwali gawig gohka enaig ne gafugafeg. Afa ati ne anwenafeg ena mo misog el kagelim faig. ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Enaig eseg ena mo Godna Sungwabug kagelni simbianiga Devitim faina. Devit neana gafugag el autunam sihi fwahag; Haisegba asa afwambanai elbi kakageafu, afa hefum augugum laskuhlanam asa mina tohlagi onawo Godim pigau apaiye, afa enaig mas puguna mo. ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Afa bite nai misog el fag la numwehiagofi. Afa saglag el laskuhlagim ogna Ainiyag mi afa God Gisfu Fwahag El mi asa hagim. ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Asa gwenaig esefe Herot i Pontius Pailat ambenam ena kembig la afwambanai el nai yi i, Israel el nai yi i laskuhlanam asa mina tohlaginim asa neana gafugag elim Sisasim pigau apaiyefe. Sona elbi nembe ati wefug fwahana asa elim pese lambfe. ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Afa ehegel laskuhlagim enaig seagofibi eba ati autunam ne sihi fwahana sa pugufe. Asa gwenaig esig nimbiafna sawieg mi afa wasneig mi patalfug. ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Asa Ainiyag sahig ehegel kam fegonigig. Sa kam ilawa mo wasneinibi asa kigmonim neana mo sihiafufe. ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Afa sa nimbiafna wasneig yi ningitigiba sa ma gih elim suialafetififi afa haig haig kigmog ogfuiagi, nimbiafna Sisas afsug gafugag elni unehlag la.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Maia enai betenni fwahinibi asa asag gwena lala puguna. Gwena elim mungwali Godna Sungwabug simbigiahlanibi asa mas mo sihigim embefini mo eba sihiageafuna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Mungwali el laskuhlagim Sisasim olug onigi eba mungwamo sihini. Mas amban mungu hefum enaig esoi hwaba kana munguhe eba awai, heafna gawigba eba mungwali elni feni. ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Afa kanog fwatieg el Ainiyag Sisasna laha buihiag mo sihinibi eba kwania wasneig ni sihini. Afa God elim suialag auguiag faig. ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Afa amban mas gawig fwainig gohna mo, afa amban bite i lala i fegba ehe minganag elim faigbi asa enanam kig flag. Afa ehena kigba flagim asa ublugim ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","kanog fwatieg elni ninga la fakag afa sa ehegel fligim, minganag elim sa gawig fwainig enam mimange gonigig. ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Afa gwenaig Josep esena. Livai eba heafna simbianiga afa ehe Saiprus lanai el. Kanog fwatieg el ehem seflini, Barnabas. Ena unehlag mogba eba ‘kwefuag el’. ");
INSERT INTO amn_amanab_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Afa ehe elim heafna bite faig afa nana kig flagim asa ublugim kanog fwatieg elni ninga la fakag. ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Afa el unehlagba Ananaias afa heafna angwagba Safaira asa ehe heafningina ming ehegenai bite mingnag elim faini asa enanam kig flana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Asa mingnag kig mo hefum sugonam afa mingnag mo kanog fwatieg elim faini. Afa angwag enam ati anwenafena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Asa Pita ehem sihina og, “Ananaias, mangigim ne Satanim patalku afa ne Godna Sungwabugim mo ne mwakwalenag afa mingnag kig mo ne sugo fwahag. ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Afa ena bite eba neana asa enana sa ne kig flag, kigba eba neana. Afa mangigim ne amtakwalig niheba eseg? Enaig sa ne eseg eba elim ne mwakwalen mo eba Godim ne esenag.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Afa Ananaias enag mo higinam asa laha pena afa mingnag ena mom higinim asa fwina embefini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Afa kwamblog el ambe saiyenam meligim saginim asa kufehlinim ufu fakini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Afa sambaga mungu aua enaig fenaba asa angwag mas anwenafena mo sa saiyefu blona. ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Afa Pita ehem sahana og, “Kam sihina, kigba guhwaho asa nimbeafna bite enanam sa ne ahflag?” Afa angwafig enaig esona og, “Nufunam gwenaho.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pita ehem esona, “Nenigi nimbefna alagag i mangigim ne Ainiyagim ahyuhnag afa el sa neana alagagim sa fakig eba ati ambe mengig la afohie ona nem gafa flifuago.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Afa ikana enag angwafig Pitana mong yi laha pena. Afa kwamblog el saiye ambenam sa nanguni maia laha gifnibi asa fli apukenam afunam alagagna yi muhla fakini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Afa mungwali sios la nai el afa mungwali minginag el enam mo higinim fwina embefini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Afa kanog fwatieg el haig haig kaksag kigmog olyi el nai yi eseagini. Mungwali Ainiyagna el Solomonna afwambag sime la laskuhla gofena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Afa el embefinim asa mas ambena laskuhlana mo. Afa mungwali el ehegelim og eba suialag el fig. ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Afa mingnag saglag i angwafig i Ainiyagim sa olug onigini eba nubiagena. Asa enag el ambenam ehegel nenam pasihiana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Asa el gih elim haig haig sime la lambinam afa sa mina la lasani. Afa ehengel og maia Pita oblofiba sa ma ehena sungwag ika gih elim puguiafufeniba sa ma suialafi. ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Afa kaksag el muhla kembig la nai Jerusalem gam ambena. Asa gih el mi afa mwaifig simbagahlag el mi asa wanambenaba asa enag mungwali el suialag feskofena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Afa misog pris i afa heafna hihe i eba Sadyusi el kanog fwatieg elim ambofe ahlagoni. ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Asa apukenam kanog fwatieg elim kikegonigim lambfu asa kalabus yi lasani mungwali amtakwalig el nahgum. ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Afa sinaini Ainiyagna oflanai el blonam mengig pigina asa afwambagam wankanam afa esonag. ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Afunam Godna kwania lala la afohienam asa mungwali elim sihigoni enag mulug nofkenagag mom.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Afa kanog fwatieg el enag mo higinim asa liana gubi Godna kwania lala gam afuna. Asa elim ena nai yi mo sihigoni. Afa misog pris afa heafna hihe ambegonam asa kaunsel mi afa Juni saglag el mi unegoni asa ambegona laskuhlana. Afa ningitigini kalabus lala gam ogma afunam kanog fwatieg elim kalabus lala nai wanambegoi. ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Asa polis kalabus lala gam afuna afa mas kanog fwatieg elim nangwagini mo. Afa pese afunam esogona og. ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Maia kangel afu kalabus lala apukegba, mengigba kikise gofena afa anwasag el ati mengig la afofna. Maia kangel mengig pigi nangugbi mas amban ena nai yi gafna mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Afa saglag pris i afa Godna kwania lala nai anwasag elni misog el i enag mo higinim afa fwinam onigwagini, afa esogona, mangwal sa pugufe? ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Afa el mungu pugunam afa sihini og, “Sa hig, enag el sa ne kalabus lala laitig ehengel ati Godna kwania lala la afoba elim mo osihigon.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Afa sa anwasag elni misog el i afa heafna el i ehengelim afu lambinim afa mas wasneigni esegoni mo. Afa embefinim esogona og masa bigim el fun na wagihiagifi. ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Afa polis kanog fwatieg elim wanambenam kaunsilna nof la lasani. Afa misog pris sihigoni og, ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Ka nem wasneigni esogonug nofene hwana unehlaglaba mo sihi, mangigim ne enaigba esig! Ne ati nimbiafna mo mungwali Jerusalem la sihig afa ne membig og kangel naho Sisasimba esug tigifatig asa ne kagelim afwanfi faig.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pita i afa mingnag kanog fwatieg el i wahigi esogona og, “Kagel sa ka Godna mom mungu patalfu masa nengelni mo kagelim kwenig feg asa ka mas Godna mom patalfui! ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Nengel ati Sisasim li yi kokufinagigim afa ehem tigi kahligbi asa lahag, afa God bigelni simbiangana ehe ati pese ihlafogba asa buihiag. ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","God ati wanikigim afa heafna nihigenai ninga la lasu fwahag. Afa God ehem enaig esenagba asa ehe saglag luwal fegim afa ehe elim pese lambig el feg. Eba enaig eseg asa ma Israel el olug waikefibi asa ehe ehengelni amtakwaligim huguflaitinife. ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Afa kagel enam nangug God ehe eseg afa kagel sa ena mom sihig. Afa Godna Sungwabug gafa gwenaig eseg. Afa ambangel sa Godna mom patalfug asa God heafna Sungwabug ehengelim faig.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Afa kaunsil enag mo higinim afa olug kakag feskofenam afa ona kanog fwatieg elim kwagi klaiti. ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Afa mungu kaunsil buihiagohnam eba Farisi el feg heafna unehlagba Gamaliel. Eba nihe mo anwena el fena afa mungwali el heafna unehlagimba fingi fini. Afa ehe elim sihini og kanog fwatieg elim afwambagam mwakwalig wanafu. ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Maia afwambagam afunamba asa Gamaliel minginag kaunsilim sihini og, “Nengel Israel el afa ne mangwalba esofegonifibi asa numwehe oniginim. ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nengel anwenafig autunam Teudas pugu gohnam esona og, kaba suialag nemug el feg afa 400 el ehem patalfuna. Afa maia ehem tigi lahagba afa el ehem patalfug asa embem afuiaminafeg. Asa heafna gafugagba awaiena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Afa enanam Judas Galili la nai el pugunam enag osunaba gavman elni unehlag lamblofna. Ehe elni onigigim fuku lasanig. Afa maia ehem gafa lahagba asa el ehem patalfuna enag embem afuiaminefena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Afa enaig esegba naka nengelim osihini, nofeka haig esegon. Nangwag fwati ma auguiafi. Afa atiaba enag gafugag sa elni onigig la pugug eba awaiyefe. ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Afa atiaba enag gafugag Godna blofe eba nengel mas kwegoni eba masa nimbefum God i ahu flafe.” Asa kaunsil Gamalielna onigigim patalfuna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Afa kaunsil kanog fwatieg elim unegonim ma ambenaba asa heafgelni gafugag elim mo sihini asa ne ehengelim kwagatife. Afa wasneig mo sihigoni og nofene Sisasna unehlag laba moba sihiafu asa fwatinim afuna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Afa kanog fwatieg el kausilim fwahinim afufefnamba Godim sifakalini asa God ehengelim onigini ehengel eba ma enaig esife asa ehengelim fwatigba asa ehengel Sisasna unehlag la afwanfeg fli. ");
INSERT INTO amn_amanab_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Afa mungwali osuna Godna kwania lala la afa elni lala afugum asa elim ogfugonig afa enag gafugagba mas awai eba wahkig sihiafufufe Sisasna moba. Ehengel enaig sihifini og Sisas eba enag el ati God sihi fwahana asa ningihiaiba asa blonam bigim pese lambife. ");
INSERT INTO amn_amanab_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Afa gwenanam patalfuag el nup apukena. Afa patalfuiag el sa Grikna mengna lagig enag afonam ninimugona minginag patalfuiag elim asa Hibru mengna lagig afa esogona og, “Nengel Hibru el nimbeafgelni elim kwagani asa fanem awaienig afa nengel mas kangelni Grik elni bontag angwafigim kwagani asa alagag ati pigig.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Afa enag esenaba 12 pela kanog fwatieg elim unegonim mungwali patalfuiag el ambena afa sihigoni og, “Afa kangel fane mimagegonug asa enag kagelim Godna mo sihiagim kopahlanife enaig eba mas suialafeg mo. ");
INSERT INTO amn_amanab_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Nilite sa ne enaig esi, nengel asa 7 pela elim yisigi olyi nengel nai yi sa afo. Asa ehengel eba suialag el afa Godna Sungwabugni ihlafigim afa suialag onigignafig. Asa big enag elim faigo sama enag gafugagim nangwaghiagi. ");
INSERT INTO amn_amanab_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Kangel ehe ka enaig gafugafife wahkig betennifinim afa Godna mo sihiafufe.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Afa mungwali el ena mom membig. Afa Stivenim wegig fwahini ehe fwinam olug onigig el fena afa Godna Sungwabug ehem ihlfenagena. Afa minginag elim wegig fatini eba Filip afa Prokorus afa Nikanor afa Timon afa Pamenas afa Nikolas. Nikolas ehe Antiok el. Autunam ehe afwambanai el fena asa blonam Ju el nai yi sefu gohna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Afa sa kanog fwatieg elni nof la wanambenaba asa kanog fwatieg el ehengelim ninga misog la fakagonim afa sa betennegoni. ");
INSERT INTO amn_amanab_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Asa Godna mo ikaminefenaba afa Jerusalem la nai patalfug el gwesim nupiagena. Afa kaksag pris olug waikefinim patalfuna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Afa God Stivenim kweafunam afa wasneig fainaba. Asa Stiven haig haig wasneig kigmog elim ogfunigena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Afa minginag el bugiagafenam Stivenim mo fafaiye flini. Enag elbi mungu Ju elni lotu la nai. Enag lotu seflig ‘esug elni’. Afa enag el eba Sairini nai afa Aleksandria nai afa provins Silisia nai afa Esia nai. Enag ambe minafenam asa Stiven i mo flafehiagini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Afa Godna Sungwabug Stivenim suialag onigig fainaba asa el mas ehem mo filafini mo. ");
INSERT INTO amn_amanab_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Afa ehengel minginag elim sisag mona esogoni og, “Sa ne mwakwal mo sihi ka higig Stiven amtakwalig mo Moses mi afa God mi faig”. ");
INSERT INTO amn_amanab_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Afa enaig mo el mi afa saglag el mi afa nihe anwena el mi olugim fingi feskofenaba. Asa Stivenim kehlinim kaunsil nangum wanigambena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Afa minginag elim wanambenam asa ehengelim mwakwal mo faigona afa enaig esogona og, “Sonag el eba wahkig Godna kwania lala mi afa heafna nihe mi moalamp fafenife. ");
INSERT INTO amn_amanab_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Afa ka higig ehe enaig sihifeg og, Sisas Nasaret nai Godna kwania lalam bubugenam afa nihem waikefefe asa autunam Moses bigim faini.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Afa mungwali kaunsil sa Stivenim nofna feflini afa nangunibi heafna nofbosugba laugwafna ofenaiba of la nai elni nofbosug mungwalofug enaig fena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Afa prisni misog el Stivenim sahana og, “Hwa moba nufunam ho?” ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stiven esona og, “Nilite afa humoani nengel sa kana mom higim. Autunam bigelni simbianiga Abraham maia Haran la ika fwainig fiahfenaba, afa God heven lanai ehem Mesopotemia la pugunam ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","afa ehem esona og, ‘Nimbiafena humoanig, hihe afa kembig mo fwahanam asa ika eba ka nem bite ogfunafe.’ ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Asa ehe heafna Kaldia kembig fwahanam asa ikanam Haran la gafena. Maia heafna alagim lahanaba God ehem ningihiana. Asa ikana ena bite la gana asa nengel ena nai yi auguia. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","God mas bite wetiti Abrahamim fainam mo. Afa God ehem esona og ka ehem fai asa enagba heafna afa heafna simbianigagim. Enanam God ehem enaig esona Abrahamba luwal fwainig fiakafenaba. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","God Abrahamim enaig sihifena og, ‘Neana simbianigaba afunam angoluwag elni bite la auguiafiba afa sa ehengelim 400 yia la amtakwal hiagibi asa ehengel ehengelni esug gafugag el feasaife. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Afa enaig elbi eba ka kike susug mungwag faife afa bitena luwalba Isipim fwahinim ambe hwa nai yi kana unehlagim fingi fife.’ ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Afa God esona og ma Abraham sa ma heafna nihim kokohiage enaba enaig ogfufeg God ati ehi sihiag ahfe ahfwahanaba asa gwenaig esena. Abraham, Aisakna alag fenam asa Aisakna nihim kokohiagena maia ika 8 enaig osuna pugunaba asa Abraham enaig esenagena. Afa Aisakba Jekopna alag fena asa Jekopim gwenaig esena. Afa Jekop bigelni 12 pela simbianigana alag fena afa ehe ehengelim gwenaig esenugena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Afa ena simbianigaba heafgelni suminegim Josepim ambobugini amtakwal oniginaginim angoluwag el nai yi ningihinibi ikanam angoluwag la esug gafugag el fena afa enag el etegim kig faigonim asa suluflinim Isip gim wanigafuna afa enanai yiba God ehi ahgofna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Afa God ehem kwegfunamba asa heafna kinigim filifatina. Afa sa ehena suialag onigig i afa anwenafeg i asa Isipni misog el Fero ehem membenam afa sa ehem fwahanaba asa Isipni saglagluwal fenam afa sa Ferona gawig i lala i nangwaghiage gofna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Afa autunam Isip bite yi afa Kenan bite yi fane awaienaba enanam bini kwania mungwali elim pugunigenaba afa sa ehengel maia kwania kinig flini afa bigelni simbianigam gafa gwenaig eseni. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Afa Jekop ati higina og Isip yi fane eyi go afa sa heafna luwaligim bigelni simbianigam ningitiginaba ehengel afu Isip yi apukenam afa pese ambe apukena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Afa ming enana pese afunaba asa Josep heafna nilitem hefum ambala ogfuni afa sa Isipni misog el gafa ehena nilitem anwenafeni. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Afa sa Josep heafna alagim mo ningihianaba og sa ma Jekop Isip gim wanbloi. Mungwali el enanai ambeg eba 75 enaig fena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Afa Jekop Isip yi afu augunam sa lahana afa bigelni simbianiga gafa gwenanai yi pigig. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Afa ehengelni elig mo lambfunam Sekem bite la skuni. Ena bitekifegba autunam Abraham Hamorna luwaligna ninga nai baimini fwahana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Afa autunam God sa Abrahamim sihi fwahana bite faigim ena ati puguiagim meyiofe, afa sa Isip kembig enanai yi bigelni simbianiga kaksag puguiagena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Afa sa enanai yi sumi yi el mungu Isipni misog el fena. Afa ehe Josepim mas anwenafena mo. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Afa ehe bigelni simbianigam mwakwale hiagenam afa amtanafe hiagenam afa kukusihiagena ogma ninginai luwalim taitufibi sa ma pigi. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Afa enanam Mosesna afag ehem waniginamba afa ena luwal fwina suialafeagena. Afa sambaga mungu was yi afahumonigbi lalaba wanigaflana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Afa sa nengigim mo flinim afwambagam fatiniba afa sa misog elni leg naini ango blo hefum foklaku lahna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Afa Mosesim Isipni mungwali anwenagim ogfufenagenaba afa sa ehena mo lagig suialafena afa gafugag gafa gwenaig fena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Afa maia Moses 40 yia enaig fenaba afa ehe ona ika heafna hihem nangwagim. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Afa ehe ika nangunaba Isip nai luwal Israel luwalim esmunagim otigekafnaba afa sa ehe Israel elim kweagfonam asa Isip nai luwalim tigifatina. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Afa ehe enaig onigifena heafna hihe ma anwenafi afa sa God ehem wefug fwahag sa ehengelim kwagan fe. Afa ehengel mas enam onigini mo. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Afa ming osuna Moses pese ika nangwagnaba Israel el hefum bagag hofefena afa ogna eheningim kwenim og, ‘Ei, mangigim na nembefumba bagag hofe, eba ne nilitena ahfeg.’ ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Afa el sa ming elim otigekafna enag el wahigife Mosesim esona og, ‘Amban nem sihinagba sa ne kangelni saglag el fegim na kam kwefihiagnug ofe? ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Afa neafa kam ogna tigifati asa ati ne amu Isip yi nai elim tigifatig?’ ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Afa Moses ena mom higinam ehe embem Midian bite gam ikana. Enanai yi ika ehengel nenam ganam ehe angwafig flanam luwalba sambaga fangonai ahfena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Afa maia 40 yia ikanaba of lanai el blo Mosesim suwi la puguna. Enaba Sainai mug muhla namba el fwainig la Moses nangunaba suwi weti li figeg la lagegofena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Afa ehe nangunam afa sineminefenam asa blo muhla pugunaba afa enanai yi Ainiyag sihinagofena og, ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Kaba neana simbianigana Abraham, Aisak, Jekopna God feg.’ Afa Moses embe i kiafigigi fiagenam esim nunofegim oksina. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Afa Ainiyag ehem sihina og, ‘Hwaba biteba eba afsug feg kable eyi ga afa sa ne nimbiafena su mo hugfu sko. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Afa ka kikeafna elim nangwagigba kinig flifu afa ka ehengelni wewatin higinig na ka blog koka ehem kwaganiba sa ma kinig mo fwahinim afui. Ka nem onigihiaba sa ne Isip gim ika.’ ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Afa Israel el Mosesim masig fatinim esogona og, ‘Amban nem sihinagba sa ne kangelni saglag el fegim na kam kwefihiagnug ofe?’ Eba God ehe Mosesim ningihianaba saglag el fenam asa Israel elim lambina eba of lanai el sa weti li figeg la suwi lagegofena enag Mosesna ningam wasneignaba asa enaig gafuga mo fena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Afa Moses Isip yi Godna wasneig ogfunim asa Israel elim Isip yi nai pugu wankana afa ika ming wasneig Ret Si yi ogfuni afa ehe ika 40 yia la el fwainig la wanganam enanai yiba ehe haig haig Godna kigmogim ogfuiagena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Afa Moses eba sonag el Israel elim sihini og, ‘Eba Godna mo fli sihiaule elim God nem ningihianife. Eba ehe nengel nai yi olyi gofufe eba kable lofug fefe.’ ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Afa Moses fena Israel el fini el fwainig la auguiafenaba. Afa ehe bigelni simbianiga afa oflanai el Sainai mug la ehem mo sihina ena nai yi wangafenaba. Afa ehe nofkikenageg mo fainaba asa ena mo bigim faig. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Afa bigelni simbianiga ehena mom mas higini mo asa ehem masig fatinim ona pese Isip gim afu. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Afa ehengel Aronim sihini og, ‘Moses bigim Isip yi nai wanblogim fwatig mug gam fukokagba afa mas big ehem ilawaba nangug mo eba mangwal maia fenag.” Enaiba nawo Aronim sihinibi sa ma bimbeafgelni godim nifiagenam gafuga fiageba sa ma bigim goseni.’ ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Afa sa bulmakau luwaligna sungwagim gafugafenaba asa ehengel heafgelni gawig lambug ambenam bulmakau luwaligna sungwagim lambwainibi eba sonagba ehe ningana esinim fena enam fingi finim sa buyisini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Afa maia ehengel enaig esinibi sa God ehem fwatinaba asa ehengel osuna, wasni, bagnofutnim lotu fegoni. Enaba enaig eseg Godna mo fli sihiule el ati Godna buk la ena mo ginofi fwahini; Afa nengel Israel ne 40 yia la el fwainig la augunam ne mas kam sis tigi faini mo. Eba awai. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Afa ne mwakwal god Molekna sel lala kufihlig ufug afa ne mwakwal god Refana bagnofutna sungwagim ne gwenaig esinig afa ne enam ningana esigim afa ne lotu fenigbi eba ka nem ningitigiba afu Babilon apukena gwesim membi yi afunam angoluwag nenam auguiafefe. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Afa maia bigelni simbianiga el fwainig la auguiafenaba afa ehe Godna sel lalam kehli uflafena. God ehe Mosesim ena sel lala nimblig mina ogfunaba asa ehengel gwenaig esini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Afa sumi yi asa ehengelni luwal ena sel lalam flinim ufunaba afa sa God ehe gosenam angoluwag elim mo lambi ningitigi fiakafnaba afa sa Josua ena sel lalaba fla wan ukuna bite fligim. Enag sel lalaba gwese gofufe ikan Devit nai yi pugufe. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Afa God ehe Devitim membenaba asa Devit Godim esona og sa kam fwahaiba ka sa neana lala nimblaiba sa ma Jekopna God enanai yi gafi. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Afa ena lalaba Devit mas nimblana mo eba heafna leg Solomon ena lalaba nimblana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Afa God sisi yi nai nemog feg ehe mas el nimblig lalaba gofi. Afa Godna mo fli sihiaule el enaig sihiba fe fwahana og; ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","God enaig sihifeg hevenba eba ka enanai yi gaba nangwagehiagego afa hwa biteba eba mong eyi ka pafeg uguia. Afa haig lala sa ne kam nimblanafe? Eba mangig la ne nimblah mo. Afa hanai yi sa ka gafe? ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Afa eba kikehe ka mungwali gawigba gafuga fiageg.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Afa ena moba Stiven maisim gwese kaunsilim sihin gofna og, “Nengel mo flaflaule. Afa nengelni olug i angug i ofenaiba afwambanai el lofug ne esiafu. Afa ne nimbiafgelni simbianiga lofig ne Godna Sungwabugim kwinig. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Afa nengelni simbianiga mungwali Godna mo fli sihiule elim amtakwali hiagini. Afa enaig el sa sihini og, ‘Godna afsug nemog el blofe’ asa ehengel enaig elim kwaskofig. Afa ilawa gafa ne ehem masig fatinigim afa ne ehem tigifatig. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Afa of lanai el ati nem Godna nihe moba faigbi afa ne enam filafig.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Afa ehengel Stivenna mom higinim afa sa olug kakaginim gog moag lagwaginim gwana ningam tigiagini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Afa Stiven ehe Godna Sungwabugni fenam wasneig gohonam asa sisi gam hevenim nangwagofenaba asa Godna suialag ombusugug gofena enag ombusugug yiba Sisas Godna nihiginai ninga buihia gam gofena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Afa Stiven sihini og, “Sa hig, ka nangugba heven bafog gohba afa sa Nufunam El Godna nihiginai ninga gam buihia goh.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Afa ehengel heafgelni angugim ningana kafuti niaginim afa fwina gonkun niagini. Afa ikagna efihia ambenam Stivenim waki fakana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Afa sa ambe ehem kehlinim hugufliufu kembig la afwambagam fatinim asa fun na wagini. Afa ehe heafgelni kuweg lofug mo hugfu skuniba asa kwamblog el mungu Sol sa ena lofugimba kuklu lambgufena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Afa maia funna awagfinibi afa sa Stiven enaig esona og, “Ainiyag Sisas nimbe kana sungwabug mo flana.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Afa ehe mongkokini kwakwagenam fwina enaig esona og, “Ainiyag nofeka mungwagba enaig esen.” Ehe enaig esonam asa hefum mo lahana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Sol mungwamo sihini Stivenim tigigim. Afa Godna suialag el Stivenim fakinim afa fwina wewatinaufena. Enag osuna kwania kinig Jerusalem lanai sios elim puguni. Afa mungwali el mo Judia Samaria kembig gam ahkwag minefenaba. Afa kanog fwatieg el mo gweyi auguiafena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Afa Sol mo ogna sios elim amtakwale fati. Asa ikafenam mungu mungu elni lala sefufenam Godna saglag mi angwafig mi hugfu lambfenam kalabus yi wankafena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Afa el sa afunam gwesim minganag kembig gam Godna mo sihiageafuna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip Samaria nai kembig gam ikanam Krais, Godna Gisfug Fwahag Elni mo sihini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Afa kaksag el higafufenaba afa onigwage afufena afa ehena wasneigim nanguni. ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Afa asa enaig esena sanel moasiagafenam kaksag elni nihinai sufuhia apukeafuna. Afa kaksag el elig lihligna el mi afa mong lihligna el mi wangene fiahsaiana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Asa enag kembig lanai fwina sifakalini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Afa Samaria lanai el mungu, Saimon, ehe faisig lambigule afa haig haig kigmog fiahageakafule el feg. Afa mungwali Samaria lanai el nangunim sineminefini. Afa enag ehe heafna unehlam fingi fukuna og, hei kikehe. ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Saglag el i afa esug el i ena mo higinim asa esogona og, “Nufunam, sona elbi ena god seflig ‘Eba Kwania Wasneig’”. ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Afa el haig haig kigmogim wahkig fanangu fiahfohun afa enam sineminefinim asa ehena mo patalfuna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Afa maia Filip Godna bog meg suialag mo afa Sisas Kraisna unehlag sihinaba asa el higinim afa olug onigigna flinim asa saglag i angwafig i bu la apaiyena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Saimon gafa Filipna mo olug onigigna flanam asa bula pena. Afa sa ehe Filip nai yi muhla gofenam nangwafena maia Filip haig haig Godna kigmogim ogfuiafenaba asa enam nangunam sineminefena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Afa kanog fwatieg el Jerusalem la higinim maia Samaria lanai el Godna mo flinibi asa Pita mi Jon mi esim ningitigini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Afa ika ahpugunam beten ahfini afa ambangel el sa olug onigi sa ma Godna Sungwabug fli. ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Haisenaba Godna Sungwabug mas ehegelim pe bloni mo. Enag elbi Sisas Ainiyagna unehlag la bula apaiyena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Asa Pita i Jon i ninga sisi yi misog la askonibi asa ehegel Godna Sungwabug fini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Afa Saimon nangwagnam maia sambaganigi kanog fwatieg el ninga askonabi asa ehegel Sungwabug flini. Asa Saimon ogna kig fainim og, ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Sa ma kam wasneig ahfai ka sa kangafa ambanim ninga fakaiba sa ma Godna Sungwabug flai.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Afa Pita esona og, “Sa ma nem kig nangum awaiye asa ne onigig ne oka kig fatinam asa Godna mangwal suialag fla. ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Enaig olug mas Godna nof la ihlafeg mo asa ne mas kagelni gafuga la seaifui. ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Asa ne enaig onigig fwahanam Godim sihinaiba asa ma neana enaig onigigim fla fatinai. ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ka ati anwenafeg neana olug yi eba ambo bughiageg afa nimbiafena amtakwalig nihe nem kehlaugu.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Afa Saimon wahigi sihini og, “Ainiyagim ahsahanaiba sa ma kam aflafenai asa ne kam sihinag enaig mas sa kam pugunafe.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Afa Pita i Jon i Ainiyagna mo afa mangwal God asa esena ena mo ahsihinam asa Jerusalem gam pese ahkana. Afa Samaria kaksag kembig ahkafenaba ena Godna mo ahsihiakana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Afa Ainiyagna oflanai el blo Filipim enaig sihifena og, “Buihianam bite behig mina ika. Ena minaba Jerusalem fwahagim asa Gasa gam ikag.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Asa ehe ikana. Afa ikafenaba Itiopia lanai elim mina la uflana. Enag elbi Itiopia misog angwafig Kandasina gafugag el. Ehe ehena kigim nangwaghiage gofena. Enag elbi Jerusalem gam ikanam asa Godim fingi fena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Asa ehe pese akofna heafna kembig gam. Afa ehe hosna masig yi sime la gafenaba Aisaia Godna mo fla sihiaule elni ginof suwigaufna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Afa Godna Sungwabug Filipim enaig sihifena og, “Ika muhla masig yi sime la ikafim.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Asa Filip kikini ika muhla pugunam afa sa higina maia el Aisaiana ginof osuwigfena. Afa Filip sahana og, “Enag ginofba atiaho ne anwenafeg?” ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Afa el sihina og, “Haig anwena kafefe, mas ka amban ogfunai.” Afa Filipim sihina og, “Au fuko blo na wanai yi hawag.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Enag ginof ehe suwignaba enaig esona og; Ehe mengig pwakafenam mwalfwai gofena gwenaig sipsip lofug maia el wanig afufeba tigigim o lag kufugim ofibi ehe mas eyuoiyi. ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Afa ehem afwanfeg mo fwaini afa mas ehem numwehe kwefihianagini mo. Afa el enag elim tigigba asa lahag asa eheba luwalig fwainig. ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Afa enag el Filipim sahana og, “Sa kam sihina, Godna mo fla sihiaule el hefum esog me awai ming elim me?” ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Asa Filip ena mo mog la fla fakanam asa gwesim Sisasna suialag mo sihiakana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","37","Afa mina la ahkan ika bula pugunam afa ena misog el sihina og, “Buba hogi. Mango kam bu la pegimba kagfugu.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Afa saglagluwal gafugag elim sihina hosna sime keahla. Maia sime gofenaba afa ahpenam bu gam ahkana asa Filip Itiopia nai misog elim bu la fatina. ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Afa maia bu lanai pugu ahblonaba asa ikagna Godna Sungwabug Filipim sulufla wanikana, afa sona el mas pese nanguna mo asa ehe mo mina gam ikafenaba sifakalena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Afa ikagna Filip Asdot kembig la gohfena. Afa ikafenaba Sisasna suialag mo sihiakan kan Sisaria la puguna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","2","Enanam Sol lagofena ogna Ainiyagna patalfuiag elim kwaskofe. Ogna Damaskus la laskuhlag lala ika ambangel angwafig i saglag i Sisasna el fiahsaieg enam sulufenam asa Jerusalem gam wankanam kalabus lala laiti. Afa ehe enaig onigifenam asa misog prisim sahana og ma kam nihe mo pepa faibi ka sa enaig ese. ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Afa maia Sol Damaskus kembig muhla pugunaba asa ikagna of lanai kwania ombusug blo molukugo fakana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Afa sa ehe bite la pena gifinibi afa higina mo gweyi ehem sihina og, “Sol, Sol, haisegba nane kam amtakwaleaflag?” ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sol esona og, “Saglag, neba amban?” Afa esona og, “Kaho Sisas ena elim sa nokawo amtakwaleafla. ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Sa buihianam ika na ne kembig la puguiba asa ma el nem sihinai mangwal sa ne fefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Afa Sol minganagim wanikanam asa ehegel moagim higinim afa mas nanguni mo asa mwalfwai afohiafena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sol buihianam nofug mo bahianam afa ninof fegim mo sikulufeagena. Asa ningana kehlinim Damaskus gam wanig afuna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Afa sambaga mungu osuna ehe gwenaig gafena asa ehe fane i bu i mas nena mo. ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Afa Damaskus kembig la patalfuiag el mungu gafena eba Ananaias. Afa ehe nangunaba itila lofug Ainiyag unena og, “Ananaias”. Asa ehe esona og, “Ainiyag, ho ka ga”. ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Afa Ainiyag ehem sihina og, “Pugu mina gam Judasna lalam ika ena mina seflig ‘Misosufgoh’. Afa sa sahin el mungu Tarsus lanaim ehena unehlagba Sol. Ehe beteneau. ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Afa Sol nangunaba itila lofug el mungu blona ehena unehlagba Ananaias. Ena elbi maia ningana tuhwiba asa ehe pese ninof fiahgena.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Afa Ananaias sihina og, “Ainiyag, ati ka kaksag mo higwageg sona elbi neana elim Jerusalem kembig haig haig fenugfiahka. ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Afa ehe nihe mo pepa misog prisni ninganai wanai yi flaublu pugug. Ogna kike lambku ambangel sa neana unehlag fingi fig.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Asa Ainiyag ehem sihina og, “Seka, ati ka kanog fwahag enag elbi kana mo lagig el. Asa ehe kana unehlagim afwambanai elim, misog elim, afa Israel elim ogfunugefe. ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Eba ka ehem ogfunafe asa mungwali susug flafe maia kana gafugag ofekafiba.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Afa Ananaias ikanam lala sefunam asa ningana Solna misog la fakanam og, “Sol nilite, asa ne mina la oblofnaba Sisas Ainiyag nem puguna. Enag kam ningihiag og sa ma nem nofug wangenefei afa sa Godna Sungwabug nem blo simbigahlai gufi.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Afa ikagna gweyi Solna nofug lanai sawagna kisigig lofug hugofu penaba asa ehe pese ninofihiagenam asa bu la pena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Afa sa ehe fane neagena afa ehena lofug pese wasneina. Afa Sol mwakwalig Damaskus la patalfuiag elim wanana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Gwenana ehe laskuhlag lala ikafnam asa mo sihiafna og, “Sisasba Godna Leg.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ehegel higinim sineminefinim hefum sihiagafewagfena afa og, “Atiahog, sona Pol seaka asa Jerusalem la elim Sisasna unehlag fingi fig ehe amtanafehiagena? Afa wanai yi blog elim lambigim pese saglag pris nangum lambku.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Afa ehena mo pugu fwina wasneiagena asa Juna elim ogfuni Sisas eba Gisfu Fwahag El God ningihiag elim lambigim. Afa Ju el Damaskus lanai higinim onigwageni asa mas ehem mo haig esuni mo. ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Afa mwakwal managenaba asa Ju el laskuhlanam ogna mina yisgiaginim asa Solim tigifati. ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Afa wahkig osu i sinaini i kembig mengig la anwasafegofena ogna sa ehem tigi. Asa Sol ena mom higinam ehe mas mengig gam pugu ikana mo. ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Afa Solna patalfuiag el sinaini ambenam wanigafunam Solim sobi yi fatinim asa kembig bog meg megam wena kehlinim fli afwambagam fatini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Afa Sol ika Jerusalem pugunam Sisasna patalfuiag elim nangwagnam asa ogna gwenaig gafugafi. Afa ehegel enaig onigini og ehe Sisasna mwakwal el ofe asa mungwali embefeagini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Afa Barnabas kwefugnam asa kanog fwatieg el nangum wanikina. Afa sihini sa Sol Ainiyagim mina la nangunaba afa Ainiyag ehem sihina. Afa ehe Damaskus kembig ikanam ehe mas embefena mo Ainiyagna mom wasneig mo sihina. ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Asa Sol mungwal auguiafena afa Jerusalem la Ainiyagna mom wasneig mo sihiageakana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Sol Ju elim Grikna mo sihiagim wan flafihiagena asa ogna Solim tigifati. ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Afa nilite maia enam anwenafinim asa Sisaria gam paiye wanigafunam afa ufu Tarsus gam ningihini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Afa enanam Judia nai, Galili nai, afa Samaria nai sios wangene augufena. Afa Godna Sungwabug siosim kwaganam afa wasneihiagena asa kaksag el pugunam sa Ainiyagim ahnai skaufini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita kaksag kembig wagiakan ikana Lida nai Godna elim nangwagena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Enanai yi elim mungu nanguna eba Ainias. Enag elbi kig lihilifenagena afa 8 pela yia ehe kife la gwese gifini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Afa Pita sihina og, “Ainias, Sisas Krais nem ati wangenefe fatig, sa buihianam kife mwanmwan enam asa flaku.” Asa ikagna Ainias buihiana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Afa kaksag Lida nai Saron nai el nangunim asa Ainiyagim olug onigig faini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Afa angwafig mungu Jopa la gofena, heafna unehlagba Tabita. Eba Grikna mo ehem seflig Dorkas. Ehe Sisasna patalfuiag el suialag gafugafefenam afa gawig fwainig elim kwefoafna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Afa enanam ehem gihenam asa lahana. Afa sa meligim bu la sugfunaginim flifu sisi yi lala megam faki fwahini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jopaba Lida muhla. Afa patalfuiag el higinim maia Pita Lida la gafenaba asa sambaganigi ningitigina ehem ahnangunam fwina sohona og, “Hei, sa ikagna blo.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Asa Pita patag ika pugunam afa sisi yi lala megam fukwali wanigafuna. Afa mungwali esig bontag angwafig buguiagafenam Pitam wakifakanam wewatoni. Afa haig haig lofug sa Dorkas nofkena gafenaba kweluwagefenam mimagen fini enam Pitam ogfuni. ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pita afwambagam ningitiginam asa mongkokini kwakwagenam sa Godim sahana. Ehe waike meligim nangunam asa sona og, “Tabita sa buihia.” Asa ehena nofug bahia Pitam nangunam buihiana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita ehena ningam kehlanam fokla lasona. Afa Pita Godna el mi afa esig bontag angwafig mi une tiginam ogfunim og Dorkasba ati pese buihiag. ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Afa sa ena mo Jopa nai el mungwali higwaginim asa kaksag el Ainiyagim olug onigig faini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Afa Pita mwakwalig Jopa la Saimonna hawagna. Afa Saimon eba bulmakauna lofug gafugafeule. ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Afa Sisaria kembig la mungu afwambanai el Kornilius enaig gafugafeg eba 100 Romna soldia elim nangwaghiawagig. Ena soldiaba seflig Itali soldia. ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Sona afwambanai elbi heafna angwafig ni luwal na Godim ahnai skau wanfegim asa Godna unehlagim fingi wanafeg. Afa kaksag Ju elim gawig fwainigim ehe kwaganig, eba Godim sahanaule. ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Mungunagim osu efilagna ehe itila lofug nangunamba asa Godna oflanai el blo ehem sihina og, “Kornilius”. ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Afa ehe nangunam embefena og, “Saglag, mango maia?” Afa oflanai el wahigi sihina og, “God ati neana sahanagim higig afa sa ne gawig fwainig elim kwaganig enaba ati anwenafegim asa onigina go. ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Asa elim Jopa gam ningitigiba sa afu Saimonim wanig ambe afa ming unehlagba Pita. ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Eba ming Saimon ehe bulmakauna lofug gafugafeule el i hawag. Ehena lalaba kwania bu muhla go.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Afa maia oflanai el ikanaba Kornilius sambaga gafugag el mi afa mungu soldia el fena enam awamoni. Ena soldiaba suialag el Godim ahnai skaufena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Afa ehegelim sihini sa oflanai el ehem haig mo sihinagena asa Jopa gam ningitigina. ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Askanam sa ka osu misosuf gigni Jopa muhla apukegim ofefenaba afa Pita lala sisi gam kukanam betenena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Maia binilahanaba ehe ogna fane ne afa mahim fane numwehiagifinibi. Enanam itila lofug nanguna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Afa ehe nangunamba of piginam kwania lofug sambaga sambaga afwagna enaig pe bluna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Enanai yiba haig haig sis i wutlai i afa twafig i saiye afogoafna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Afa Pita higinamba God ehem sihinagofna og, “Pita buihianam sisba sonaba sa kwagnefe.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Afa Pita esona og, “Ainiyag, amo yo ka mas ese. Ka mas ena kwegig sisba neafna mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Afa God ehem pese sihina og, “Mangwal sa God sihig eba suialag asa nofeka enam oniginam kwegim.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Sambaga mungu nagim gwenaig esenam asa lofug pese of gam fukokana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Afa Pita enam nangunam fwina onigwage aufna. Enam elim Kornilius ningitiginaba asa lalam yisgi afuian mengig la afohiafna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ehegel une sahini og, “Saimon afa ming unehlag seflig Pita ohiahogo?” ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita mahim ena itila lofug nanguna enam onigaufnaba afa Godna Sungwabug ehem sihina og, “Hai sa nangu sambaga mungu el nem yisgi ambe. ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Asa peka nangwag, nofeka afuiagim oksi. Eba kikehe ningitigig.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Asa Pita penam elim esoni og, “Kaho ne kam yisgi ambeg. Haisegba sa ne ambeg?” ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Afa ehegel sihini og, “Korniliusba soldiana misog el na kam ningitigi. Eba afsug el Godim ahnai skaufenaule, afa Ju el mungwali ehem mungu suialafe flig. Afa Godna of lanai el pugunam ehem sihinag sa ma nem unenaiba sa ne heafna lala gam blonam asa ma neana mo higi.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Asa Pita lala megam sulfu wan sefukana wanafna. Afa askanam pigiagafenam Pita mungwal afufefnamba asa minganag Jopa nai Ainiyagna el mungwali afuna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Afa ming osuna afu Sisaria kembig apukena. Kornilius Pitam nengiaufnaba asa heafna nilite mi hihe mi une tiginam heafna lala laskuhlana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Afa maia Pita lala megam osefofnaba asa Kornilius blo muhla pugunam mongkokini kwakwage penam hefum ahnai skaufena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Afa Pita ehem fukla fukunam esona og, “Buihia, kaga elhe.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Afa Pita sihiagafeakan lala megam ahsaifunam afa nangwanaba kaksag el laskuhlagofna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Afa sa mungwali sihini og, “Ne ati anwenafig kagelni Ju elni nihe mo enaig esona, Ju el nofeka afwambanai elni lala afu saiyegonam wahinim augu. Eba God ati kam ogfunag ka mas minganag elim kwenam afa esoi nengel Godna nofla nufweg el. ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Maia ne kam awamonagba asa ka mas anksam meg mo. Haisegba sa ne kam awamonag? Ka mas anwenafeg mo.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Afa Kornilius esona og, “Afa sambaga sambaga osuna awaienaba ka osu efilagna lala la beten neaufnaba afa ikagna el mungu ombusug lofugna blo gofenaba, ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","afa kam sihina og, ‘Korniliuso, God neana betenim ati higig, afa mangwal sa ne gawig fwainig elim faig ehe mas etetig mo. ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Asa elim Jopa gam ningitigiba sa afu Saimonim wanig ambe afa ming unehlagba Pita. Eba ming Saimon ehe bulmakauna lofug gafugafeule el i hawag. Ehena lalaba bu muhla go.’ ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Asa ikagna ka nem awamona afa kagel sifakalig sa ne blog. Enaig fenaba na saka ilawo Godna nof la laskuhlagim afa Ainiyagna mungwali mo ehe nem faig asa kagel koka higim.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Afa Pita enaig sihifena og, “Ilawo kati anwenafeg eba nufunam nemog, mungwali el Godna nofla mungwalofug fiahsaieg. ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Afa ambangel haig haig el Godim ahnai skaufenigim afa suialag nihe patalfug enaig elim God sawiyi fegim lambig. ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ne anwenafig God kagel Ju elim heafna mo gof kam ningihianig. Ena suialag moba enaig sihifeg Sisas Krais ehe mungwali elni Ainiyag bigim esenigbi asa big God i mungu onigigna ahfeg. ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Afa ne anwenafig mangwal Israel lanai puguna. Ilawana Galili provins la Jon mo sihifenam og ma el onigig waikefenam bu la apaiyefi. ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Afa Sisas Nasaret lanaim God heafna Sungwabug i kigmog i faina. Afa God ehi ahgofena asa ikafenaba suialag gafugafiahkafena afa ambangelim sa Satan amtakwaletifena enam wangene fetifena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Enaigim na ka nangugim maia Ju elni mungwali kembig afa Jerusalem la enaig esenigbi na sa ka ena mo sihig. Afa enaig elim li katigeg la tigi kahli. ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Afa maia sambaga mungu osuna awaienaba God ehem ihlafofatig asa ambala pugugba nangug. ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Afa mas mungwali el nanguni mo, eba minganag ambangel sa God wefug fwatig gwenag mungu ehe nangunim sihini. Afa maia buihianaba sa ka fane i bu i mungwali wanig ahagag. ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Afa ehe kam esonig sa ena suialag mo elim sihigon enag elbi God ehe wefug fwahag elim kwefihiawagigim melig pigieg mi afa nofkena gag mi. ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Mungwali Godna mo fli sihigule el ena moba sihi fwahini ambangel ehem olug onigig finigbi ehena unehlag la God ehegelni amtakwaligim huguflaitinife.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Pita maisi mo sihiagofenaba afa ena el mo higinibi asa Godna Sungwabug pe blo mungwali ehengelim puguni. ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Afa Kristen Ju el Pitam wanig ambenam nangunimbi afwambanai el sa Godna Sungwabug lambini asa ehegel enam sineminefini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Afa higinibi enag el haig haig mona lagwaginim Godna unehlagim fingi fini. Asa Pita sihina og, ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Sa nangu, enag elbi Godna Sungwabug lambigbi eba big gwenaig mungwalofug big fig asa amban enag elim bu la apaiyegiba kwenife? Eba mas amban enaig esei.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Asa Pita sihini sona el sa ma Sisasna unehlag la bu laba apaiye. Afa ehegel Pitam sahini og, “Sa kam mwakwalig wananam.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Kanog fwatieg el i afa Judia nai patalfuiag el i higini, maia afwambanai el Godna mo ati flini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Maia Pita ika Jerusalem gam pugunamba patalfuiag el kokohiawagig nihem patalfuna asa ehem fenagini og, ");
INSERT INTO amn_amanab_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Enag el mas kokohiawagig nihem patalfug mo afa ne heafgelni lala nef fukog waneg. Nofeka enaig ese.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Asa Pita wahigi sihini mungwali mangwal sa ehem puguna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Afa enaig esona og, “Ka Jopa la gafnamba beteneaufna asa ka mangwalim itila lofug nanguna. Asa ka nangugba ofenai lofug kwania fufugihiag afa ofim mo fwahagim sa pe blog ka nai yi muhla gofena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Afa ka nangunamba haig haig sis i wutlai i afa twafig i saiye afogoafna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Afa ka higinamba God kam sihina og, ‘Pita buihianam sisba sonaba sa kwagnefe.’ ");
INSERT INTO amn_amanab_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Afa ka wahigi sihina og, ‘Ainiyag, amo ka mas ese. Ena kwegig sisba mas kana mengig la feg mo.’ ");
INSERT INTO amn_amanab_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Afa God kam pese sihina og, ‘Mangwal sa God sihig eba suialag asa nofeka enam oniginam kwegim.’ ");
INSERT INTO amn_amanab_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Sambaga mungu nagim gwenaig esenam asa lofug pese of gam fukokana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Gwenana sambaga mungu Sisaria lanai elim ka nangum ningitiginimbi asa ambe lala apukena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Afa Godna Sungwabug kam enaig sihifena og, ‘Nofeka afuiagim oksi.’ Afa hwag enwesog la gohug nilite ka wanig augim afa Korniliusna lala wani saiyeg afug. ");
INSERT INTO amn_amanab_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ehe kagelim sihini mangwal sa ehem puguna. Eba Godna of lanai el heafna lala la nangunamba afa ehem enaig sihifena og, ‘Asa elim Jopa gam ningitigiba sa afu Saimonim wanig ambe afa ming unehlagba Pita. ");
INSERT INTO amn_amanab_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Afa ehe nem mo flifu faifi asa God nem gwena lala naim lambfe.’ ");
INSERT INTO amn_amanab_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Afa autunam Godna Sungwabug pe blo bigelim puguni afa enanam ka mo sihi gofenaba gwenaig esena ehegelim gafa puguni. ");
INSERT INTO amn_amanab_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Afa ka onigig ilawana Ainiyag esona og, ‘Jon buna bula elim laitig afa God heafna Sungwabugni bula nengelim laitig.’ ");
INSERT INTO amn_amanab_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Afa maia big Sisas Krais Ainiyagim oniginimbi asa God bigim heafna Sungwabug faig. Asa gwenaig afwambanai elim esenigbi sa ambala pugug eba God ehe gafugafeg. Enaig esegba na sa ka mas Godna gafugagim kwei.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Afa ena mo higinim mas Pitam fenagini mo eba Godna unehlagim mungu fingi finim afa esogona og, “Ei eba nufunam, God afwambanai elim gafa minaba ambafenig asa ma ehegel olug waike finim nofkena fli.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ilawanam Stivenim maia tigi fatinimbi Ainiyagna el kinig flinim afa ika Fonisia, Saiprus, afa Antiok kembig embem ahkawag minefena. Enanai yi Sisasna mo Ju elim mungu sihigoni. ");
INSERT INTO amn_amanab_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Afa minganag Saiprus nai afa Sairini nai el Antiok gam afunam afa afwambanai elim gafa Sisas Ainiyag suialag mo sihigoni. ");
INSERT INTO amn_amanab_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Afa Ainiyagna kigmog ehegelim gohonimbi asa kaksag el olug waikefinim Ainiyagim onigini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Afa Jerusalem lanai sios ena mom higinim asa Barnabasim Antiok gam ningihini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Afa ehe pugunam nangwagna maia God ehegelim suialafe hiagenamba asa ehe sifakalena. Ehe suialag onigig faini og ma mungwali Ainiyagim fwina wasnei kehli ufufi. ");
INSERT INTO amn_amanab_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Eheba suialag el ehena olug onigig fwina wasneina afa Godna Sungwabug ehem ihlafenagena asa kaksag el Ainiyagna el apukena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Asa Barnabas Tarsus gam Solim nangwagim ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Afa ika pugunam yisginam asa sulfla Antiok gam wani blunam mungwa yia la hawagena. Afa maia sios el laskuhlafenamba asa kaksag elim ogfufenug ahfena. Ilawana nemug ena kembig la Ainiyag elim unehlag flini Kristen. ");
INSERT INTO amn_amanab_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Enanam minganag Godna mo fli sihiule el Jerusalemim fwahinim afa Antiok gam ambena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Afa sonag el nai mungu eba Agabus. Ehe Godna Sungwabugni wasnei gohonam asa ena mo sihina og nengigim kwania bini mungwali bite pugufe. (Enamba maia Klodius Rom lanai misog el gofenamba asa enaig puguna.) ");
INSERT INTO amn_amanab_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ainiyagna el ena mo higinim asa ati onigini Judia nai Kristenim gwena ihla kwaganifi. ");
INSERT INTO amn_amanab_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Gwenaig esini Barnabas mi Sol mi kig faigonam ningitigini asa enag kig uku Juda nai sios saglag elim ahfaina. ");
INSERT INTO amn_amanab_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Enanam misog el Herot, siosna elim kinig faini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Afa ehe gafugag elim ningitigina og ma Jemsim Jonna etegim higeflaki. ");
INSERT INTO amn_amanab_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Afa enaig esenam Ju elim nangwagena maia sifakalinimbi asa Pitam kehlanam kalabus lala fati fwahana. (Enanam Ju el Bret Yist Fwainig buyis sifini.) ");
INSERT INTO amn_amanab_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Afa sa Pitam kehlinim kalabus lala fatini. Afa ena lala 16 soldia Pitam nangwafofna. Afa sambaga sambaga afohufna maia afuiafnamba afa mingang sambaga sambaga ambe ehegelni kugla afohiafna. Herot og maia Pasova buyis awaiyeba asa Pitam elni nof la fahigenage. ");
INSERT INTO amn_amanab_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Afa maia Pita kalabus lala gafenamba afa sios wahkig Godim sahanafofna og sa ma God Pitam kweagfwi. ");
INSERT INTO amn_amanab_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Liana maisi feafnamba Herot Pitam fahigenag ogna fe. Afa sinaini Pita sambaganigi soldia nai yi olyi gifini. Afa sambaga senna kikenagi fakinim asa sambaganigi soldia mengig la kagfo ahgofna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Afa Ainiyag of lanai el ikagna pugunam ombusug lala megam laugo gofena. Afa sa Pitam epinig la ihlafo fatinamba asa Pita nof tutafe bahianamba afa sa of lanai el sihina og, “Is ikagna buihia.” Asa gweyi sen Pitana ninga nai pitigifu ahpena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Afa of lanai el ehem sihina og, “Pese lofug i afa mong lofug i laitiage.” Asa Pita gwenaig esenamba of lanai el pese sihina og, “Sa ne laputig lofug fwahalanam kam patal blu.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Asa Pita ehem patalkuiafnamba mengigim fakwegfu ahfeakana. Ehe nangunamba asa of lanai el esena ehe enaig onigina eba mango nufunam mo. Ehe enaig etitinam og eba ka itilamba nangug. ");
INSERT INTO amn_amanab_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Afa sambaganigi kwagana ikana afa ika ming mengig lanai kwagana ikana afa ikanam ain mengig la pugunam, afa ena minamba gwesim kembig gam ikafna. Afa ena ain mengigba ehe heafa pitigiafunamba asa pugu afwambagam ahkana. Mina la mwakwalig ahkanam asa of lanai el gweyi ikagna ehem lasu ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Afa sa Pita enam anwenafenam esona og, “Eba nufunam ilawo ka ati anwenafeg eba Ainiyag heafna oflanai elim ningihiagba asa kam Herotna ninga nai afa Ju el amtakwal kam ofinifini sa nanai kam flag.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Afa maia ehe enam anwenafenam asa Maria Jon Makna afagna lala gam ikana. Afa kaksag el enanai yi laskuhlanam beteneaflafna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita ikanam mengig la ningana tige gofena. Afa Roda gafugag angwafig asa ikanam ogna mengig pigi. ");
INSERT INTO amn_amanab_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Afa ehe ati Pitana mengigim higigna asa sifakalenam ehe mengig pigiegim tetinam asa kikini pese ikanam sihina og, “Pitamba ati mengig la blo go.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Afa ehem esogona og, “Ne moetetiofe.” Afa ehe fwina wasneinam esona og, “Eba nufunam ehe.” Afa ehe esogona og, “Amo, eba Pitana oflanai el feg.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Afa Pita maisim gwese mengig la tige gofenaba asa afu mengig pigi nangunim sineminefini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Afa Pita ningana pagafenim og afwai afwai. Asa heafna mo sa Ainiyag ehem kalabus lala sulufla puguna. Afa ehe sihina og, “Sa afu Jems afa minganag nilitem ena mo sihigon.” Asa ma fwahinim asim afui. ");
INSERT INTO amn_amanab_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Afa liana soldia etetiagenim hefum onigwaginim sahawagini og, “Afai, asim maia Pitamba ikag?” ");
INSERT INTO amn_amanab_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Afa Herotna gafugag el Pitam yisgiafuan mas nanguni mo. Asa Herot Pitam anwasafenafuhug elim fwina fasahitigifenam afa sona og, “Sa kwaskofi!” Afa maia kwaskofinimbi asa Herot Judia fwahanam mwakwalig Sisaria la gana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Afa Herot Tair nai Saidon nai elim olug kakagen gofena. Asa ehegel onigini ehegelni kembigim mas fane kwagana mo asa laskuhlanam ogna nangui. Ilawana mo Blastusim Herotna misog gafugag elim sihini og ma kam kwagani. Asa afunam Herotim nangunim sahini og ma olug kakagig fwahai. ");
INSERT INTO amn_amanab_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Afa sa mungu osunam sufini fwahani asa Herot heafgelni misog elni lofug wagwagenam heafgelni misog elni sime la peganam sa ma mo sihinwagena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Afa mungwali el ambala fwina enaig esogona og, “Enamba mango elni moamo eba heafa god ehe sihiago.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Afa Herot ena mom sifakalena afa ehe mas Godna unehlagim fingi fena mo. Asa ikagna Ainiyagna of lanai el ehem tigenamba sa gihenam afa petu atagim ahagawaginimbi asa lahana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Afa Godna mo pugu wasneinam asa fafokaminefna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Afa Barnabas i Sol i Jerusalem la gafugag awugafenam afa Jon Makim ahsulflanam Antiok kembig gam asa pese afuna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Afa enanai yi Antiok sios laba Godna mo fli sihiule el i afa ogfuiag el i afohiafna. Ehegelni unehlagba Barnabas, Simeon (heafna ming unehlagba Niger), Lusius (eba Sairini nai el), Manain (eba autunam misog el Herot i mungu niliag afena), afa Sol. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Enanam sios el fane fwaiyi gonam Ainiyagim lotu finimbi sa Godna Sungwabug sihini og, “Barnabas mi Sol mi lambtiginim algana fwatigi ati ka ena gafugag la wefug fwatigig sa ma gafugafe.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Afa sa fane fwai yi gonam betennini asa ninga eheningi nai yi skunim afa sa ningitigini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Afa Godna Sungwabug ningitinimba asa Selusia gam ahkana. Selusia ahpugunam bot la ahgonam asa ailan Saiprus gam ahkana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Afa Salamis kembig ahpugunam ika Ju na laskuhlag lala ika ahsaifunam Godna mo ahsihina. Jon Mak auguiafenamba eheningim kwaganfna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Afa ehegel enag ailan la fapuke fiahfuian ming maligim Pafos kembig apukenam nanaiyi nangunimbi Ju el mungu Bar Sisas heafna unehlag Grikna mona seflig Elimas. Enag elbi agisu ule weni ule afa ehe mwakwal Godna mo fla sihiaule el feg. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ehe misog elni gafugafegofna. Enag misog elbi Sergius Paulus eba numwehe anwena el, afa ehe ogna Godna mo higim asa Barnabas mi Sol mi uneni. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Afa Elimas enag elbi agisu ule el, ogna eheningim kwenim og ese misog el masa Sisasim oniginafe. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Afa Godna Sungwabug Solim, afa ming unehlagba Pol, ehem ihlafenagenamba asa ehe Elimasim fwina nofna nangunam sihini og, ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Nemba Satanna leg. Ne suialag nihena angoluwag go. Mungwali haig haig mo mwakwalig neana onigi la kwaniafiahgeg asa ne Ainiyagna mom nugwakale flag. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Asa ma Ainiyagna ninga nem filafati afa sa nem nofug mwakwalig amtakwalig gohi sa ne mas osuna ombusugum nangui.” Afa Elimas nangunam ikagna leango sikulufenam pe blo nofugum sagfla fakana asa etetiage akafnamba elim yisgiakafna og ma kam ningana kehlanam waniki. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Afa misog el enam nangunam afa Ainiyagna mo ehem olug fingi fenamba asa olug onigig Ainiyagim faina. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Afa Pol fena heafna hihe apaiyenam asa bot flinim Pafos fwahinim Perga kembig Pamfilia provins gam afuna. Afa Jon Mak mo enanai yi lasana pese Jerusalem gam ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Afa eheningi Perga ahfwahanam Pisidia distrik Antiok kembig ahpuguna. Afa maia Esug Auguiag Osuna pugunamba asa eheningi ahkanam Ju elni laskuhlag lala ahsaifunam pe hawagna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Afa maia Mosesna mo i Godna mo fli sihiule elni mo i Godna buk la suwigni fwahinimbi, asa saglag el eheningim sahigoni og, “Nilite, atiamba ne mo ahfegba asa ehengelim ahkwaganam sa ahfai.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Afa Pol buihianam ninga fatinim og ma sifeiba asa esoni og, “Israel nai el i afa afwambanai el i Godim ahnai skaufinim sa kam higini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Autunam Israel na God kangelni simbianigam ati kanog fwatina afa maia Isip yi auguiafnamba God esenimbi pugug kaksag feagena. Afa fwina wasnei gafugag fenam Isip yi nai lambana lambpuguna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Afa Israel maia 40 yia bite behig la Godim gasafinimbi afa God mas fwatina mo. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Afa ehe maia elegeg la gohug Kenan la nai kantriim flafonamba asa heafna elim fwahanamba asa ehe bitena mog fiahsaina. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Afa enaig esena 450 yia fenamba. Asa God ehegelim nangwaghiageg elim fainimba sa ikan ikan Samuel Godna mo fla sihiaule nai yi puguna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Afa maia ehegel membini misog elim sahinimbi asa God Solim fwahiani. Sol eba Kisna leg afa ehe Benjaminna mungwa simbiangana. Afa ehe 40 yia nangwaghiagena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Afa God Solim mo ningihianam asa Devitim misog el fwahana. God esona og, ‘Devitba Jesina leg ka nangugim afa ka ehem fwina fwefenag. Eba kana olug flafe.’ ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Autunam God ati sihi fwaha ehe og eba Devitna simbianiga fenam asa Israel elim lambfe, ena elbi eba Sisas. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Sisas maisim gafugafeg fwainig fiahfenamba enanam Jon puguna Israel elim mo fainim og ma olug waikefinim amtakwalig nihem fwahinim asa ma bu la apaiye. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Afa Jon gafugafefim awaiegim meyi ofefenamba ehe enaig sihini og, ‘Ne enaig onigini kaba amban? Kaba mango sonag el God sa Wefug Fwahag sa ne nengiafu, ena mo. Nengigim sonag elbi asa kana sum yi blofe. Kaba mango suialag el mo, ka mas ehem kwefunam ehena mong lofug huguiafla nai.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Pol enaig sihifeni og, “Nilite, nengel Abrahamna simbianiga i afa afwambanai el i Godim ahnai skaufini, afa God ogna elim lambim asa ena mo bigim ningihianig. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Jerusalem nai el i afa heafgelni misog el i mas anwenafini mo Sisas eba God Gisfu Fwahag el. Afa mungwali Esug Auguiag Osuna ena mom suwigfofnamba, afa ehegel mas numwehi anwenafini mo Godna mo fli sihiaule elni ginofim. Enag ginof nufunam esenamba asa ehegel ogna Sisasim tigifati. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Afa mas ehena haig haig nanguni mo afa ehegel Pailatim sahini og ma Sisasim tigi kahli. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Sonag elbi ati Baibel sihi fwahana asa ehem enaig esenag gifi sa gwenaig esini li katigeg la nai numbwaslinim bite meg gam fakini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Afa sa God ehem pese ihlafla fatina. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Afa kaksag osuna hefum ogfunfini. Afa sa ilawana el Galili fwahifinim Jerusalem gam wanig afuiafenaba asa ilawo nai mo Israel nai elim sihinigena mangwal sa nofna nanguna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Na sa kaningi nem ena suialag mo ka nem ahblunug. Autunam God bigelni simbianigam sihi fwahanimbi asa ena elim ningihiagba bigim lambig. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Afa ehe Sisasim ihlafla fatigba asa ena mo nufunam bigel ehegelni luwaligim pugunug. Afa Baibelna mo Buk Song 2 la enaig esog og; Ilawo kaba neana alag asa neba kana leg. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","“Afa minginag moaba God sihig, eba ehem ihlafla fatigba, eba mas ehena elig nogig mo. Ena mo enaig sihi feg og; Ka Devitim sihi fwahana ka ehem suialag esenag. Enag sihi fwahag eba nufunam feg afa afsug kabag feg. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","“Afa minginag mo enaig eseg; Mas ne nimbiafna suialag gafugag elim fwahana mo asa bite meg gam ika nogig mo. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","“Afa Devit nofkike gafenamba Godna sawiegim patalfefkuian maia lahanamba. Afa ma bite la fakinimbi ehe simbianigana kig i waheg nogig. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Afa ming elbi enamba God ihlafla fatigba eba mas ehena elig nogig mo. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Nilite, kog sa ne anwenafi Sisasba ehe mog moaba kagelni feg. Afa amban ehem olug oniginaiba eba God ehena amtakwalig mom fla fatinafe asa ehe Godna nofla afsug kabag pugufe. Afa Mosesna nihe mo mas enaig eseg mo. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Afa numwehifibi Godna mo fli sihiaule el sihi fwahigbi masa ne enaig esefie. Enaig esog; ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Sa nangui, ne amban Godna mo masig fatig, sa ne numwehe onigifibi eba nem pigife. Eba ka mangwalim eseba asa ne sineminefife. Afa maia el ena mog mo ogfugba, ne mas onigi.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Afa Pol i Barnabas i laskuhla lala fwaha hakofnamba afa enanai el esogoni og, “Sa ming Esug Auguiag Osuna pese ahblo gwenaig mo ahsihi.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Afa sa ena lala fwahinim apuke afwambagam afuna Ju el i afwambanai el i Pol mi Barnabas mi patagafuna. Sonag afwambanai elbi Ju elni nihem patalfuna. Afa sambaganigi suialag mo ahfaini God ehengelim esmunagim kwaganig. Sa ma enanai yi saiye afohiefi. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Afa ming Esug Auguiag Osuna opugufnamba afa mungwali kembig nai el ogna laskuhlanam Ainiyagna mo higim. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Afa Ju elni saglag el maia kaksag elim nangwagnim ehengel oksiasaina afa sa Polna mom pagau apaiyenam afa afwanef mo faini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Afa Pol i Barnabas i fwina wasnei ahogonam wahigi ahsihini og, “Eba nufunam ilawana kati nem Ju elim Godna mo ahfainimbi afa nimbe ne oksini afa mas ne nofkikena suialag wahkig gagim onigi mo. Naig fenamba na sa ka nem ahfwatigim afwambanai gam ka hako. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Afa Ainiyag kam esonig og; Ka nem ombusug esenibi asa afwambanai el enam nangunim patalfufe asa ena mina God mungwali bite nai elim pese lambfe.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Afa afwambanai ena mom higinim sifakalinim asa Ainiyagna mo fingi fukoalina. Afa ambangelim sa God kanog fwatig nofkikena wahkig gagba enag el Ainiyagim olug onigini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Afa sa Ainiyagna mo ena bite la fafokaminefena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Afa Ju el kembig lanai saglag el mi afa Godim lotu fenag misog angwafig mi ehegelni olugim waike fegonibi asa ehegel mas Pol mi Barnabas mi membegoni mo. Asa ehegel eheningim kinig faigona asa ehem enanai ningitigini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Enaig safena, pugu hakofnamba smof mong yi nai buiambu ahfenam ahkana. Enamba enaig eseg eba mas ena kembigim ahfatigim gwesim Aikoniam kembig ahkana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Afa Antiok nai patalfuiag elim Godna Sungwabug ihla fiahsainaba asa fwina sifakalini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Pol i Barnabas i Aikoniam gam ahka ahpugunam Ju elni laskuhlag lala asaifuna gwenaig nihe ahfiahfena. Afa maia mo ahsihiafenamba ena mo elni olug fingi waikeskona asa kaksag Ju el i afa afwambanai el i Ainiyagim olug onigini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Afa minginag Ju oniginigim oksini afa afwambanaim kukusihiageni og ma Kristenim olug kakagegoni. ");
INSERT INTO amn_amanab_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Afa sambaganigi mwakwalig nanai yi hawagenam Ainiyagna mo gwese ahsihiagofna. Afa eheningi haig haig kigmog siagafenamba enamba Godna kigmogim ogfug afa enag aflafeg mo ahsihinamba eba nufunam. ");
INSERT INTO amn_amanab_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Afa enanai el bambuhiaginim, minginag Ju elni saglag elim patagafuiafna afa minginag kanog fwatieg el sambagam patagafuiafna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Afa Ju el i afwambanai el i afa eheningina saglag el i ogna sambaganigi elim amtakwalihiaginim asa fun na kwaskofi. ");
INSERT INTO amn_amanab_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Afa sambaganigi ena mo ahiginam distrik Likonia gam ahkana, afa enanai yi ahpugunamba eba Listra afa Derbe afa minginag kembig muhla gohkana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Afa sa enanai yi Godna suialag mo ahsihina. ");
INSERT INTO amn_amanab_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Afa Listra kembig laba el mong kukwaligni gafna. Enaig esenamba eba afag gwenaig weti la wanigana. Afa saglafenam mas gominefena mo. ");
INSERT INTO amn_amanab_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Afa enanam maia Pol suialag mo sihiagofnamba enag el ena mo higina ofena. Afa sa Pol ehem fahigenagenam anwenafena ehena olug onigig ati ihlafeg asa God ehem wangenefe fatife. ");
INSERT INTO amn_amanab_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Asa Pol ehem ambala sihina og, “Buihia gohum!” Asa ehe pusoka gohnam sa ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Afa kaksag el nanguni maia Pol enaig esenamba asa ehengel Likoniana mona ambala esona og, “Sona elbi eba sambaganigi god el lofug bigim pe ahblonig.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Afa Barnabasimba eba seflini Sus afa Pol eba fwina mo sihiaule ofenaiba god Hermes asa ehem seflini Hermes. ");
INSERT INTO amn_amanab_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Afa ena lalaba enanai yi el god Susni unehlagim fingi fifini enamba afwambagam kembig la gofna. Susni pris bulmakaum tagni wagwagifinim asa kembig mengig gam lambug ambeafna. Ehe fena afa mungwali el apaiyena ogna kwagi wehlim asa eheningina unehlagim fingi fiawag. ");
INSERT INTO amn_amanab_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Afa maia enaig esinimbi asa Barnabas i Pol i ena mo ahiginam afa sa heafningina nihi lofug koko ahfwatiafenam sa ahpugu olyi kikini ahkafnaba fwina unehona og, ");
INSERT INTO amn_amanab_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Afa mangigim ne enaigba esig? Kaningiba el big mungwalofug fig. Kaningiba ahblog nem suialag mo ahfaig asa ne mwakwal godim fwahinim asa ne waike God nofkikenagim onigini. Ehe of i bite i bu i mungwali gawig gafugafiageg. ");
INSERT INTO amn_amanab_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Autunam ehe afwambanai elim fwatina asa heafgelni sawiegim patagiafufna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Afa ehe suialag gawig lambwaie gofnaba asa bu fiahfna afa nefgenai sa heafna osuna puguiageafna. Afa sa ehe kaksag fane faifinim afa ehe nengelni olug yi afigig faig. Enamba ogfug ehe nofkikena go.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Afa gwenaig mo ahsihinam afa ehe og ma ehegelni onigig waikefi, ese ehegel masa bulmakau tigi tuhulunim eheningim fingi fiahwagfe. ");
INSERT INTO amn_amanab_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Afa enana Ju el Antiok Aikoniam kembig fwahinim Listra kembig gam ambenam ena kembig lanai elim kukusihiaginimbi, asa Polim fun na waginim og atimba lahag asa ehem flini kembig la afwambagam fatini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Afa maia Kristen el ehem wakinamba asa Pol buihianam sa pese kembig gam sefukana. Afa liana Pol i Barnabas i ena kembig fwahanam Derbe gam ahkana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Afa eheningi Derbe la hafinamba suialag mo ahsihinamba enanai el kaksag Ainiyagna fiahsaina. Afa pese Listra afa Aikoniam afa Antiok Pisidia gam ahkana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Afa ahkafnamba kigmog mo patalfuiag elim ahfaifinim og, “Nofeka olug onigim fwahi yi. Ambangel Godna bog meg gam saiyegogimba ofifibi asa ma kaksag kinig flinim asa saiye.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Barnabas i Pol i mungu mungu siosna saglag elim wegi ahfwati hofefnaba. Asa fane foiyioaklafinim sa betennini og ma God heafna ninga la afohie, eba ehegelni Ainiyag. ");
INSERT INTO amn_amanab_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Afa eheningi Pisidia ahfwahanam Pamfilia gam ika ahpuguna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Afa Perga la Ainiyagna mo ahsihinam afa gwesim Atalia gam ahkana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Afa nanai yi bot la afkonam Antiok gam ahkana enanai yi autunam Kristen eheningim Godna ninga la fwatiginimbi asa God esmunagim kwaganaba asa ena gafugagfeag ahfeakan asa pese ahblona. ");
INSERT INTO amn_amanab_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Afa ahpugunam enanai yi sios elim ahunetigina og ma ambe laskuhlaiba asa heafningina gafugagim sihinuwag ahfenam og, “God ehe esegim minaba pigiba asa afwambanai elbi Ainiyagim olug onigini.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Afa sambaganigi enanai yi patalfuiag elim fwina ahwanana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Afa mingnag Judia nai el Antiok kembig apukenam Kristenim esogoni og, “Mosesna nihe mo enaig esog sa ne nihim kokohiawagi, asa ne ena moba mas patalfug mo, eba God mas nem lambi.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pol i Barnabas i ena mom ahiginam fwina ahlagnaba asa sios el sihiaginim sambaganigi mi afa minginag apaiyenamba enam fwatini og ma ahfui Jerusalem la siosna saglag el mi afa kanog fwatieg el mi numwehe sihigoni. ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Afa sa Antiok sios ehegelim ningitiginimbi asa distrik Fonisia gam afa Samaria gam asa sihiageafuna, og ati afwambanai el Godim olug oniginig, afa mungwali Kristen ena mom higinim asa fwina sifakalini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Afa maia Jerusalem apukenaba sios el i kanog fwatieg el i afa saglag el i ehegelim nangwaginim sifakalini. Asa ehegel sihiwagini mangwal sa mungwali God ehegelni ninga la gafugafeni. ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Afa minginag Kristen farisi nihem patalfuiaule buguiagafenam og, “Afwambanai el gafa sa ma heafna nihim kokohiaginim afa minginag mungwali nihem Mosesna patalfui.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Asa kanog fwatieg el i afa saglag el i laskuhlanam ena mom kwefuhiageaflafna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Afa ena mo sihiageaflafnaba asa Pita buihianam sihini og, “Nilite, ati ne anwenafig autunam God kam nengel nai yi olyi kanog fwahag ka afwambanai elim Godna suialag mo faibi sa ma Sisasim olug onigini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Afa God ati elni olug onigigim anwenafegim afa heafna Sungwabug ehegelim faig asa gwenaig eseg bigelim gafa faig. Enamba bigim ogfunig ati ehegelim gafa lambig. ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Afa big Ju el i afa afwambanai el i Godna nof la mungwalofug afa maia ehegel onigigbi asa God ehegelni olug yi nai amtakwalig nihe lambig aitinigbi asa ehegelni olug afsug afohienig. ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Big i afa bigelni simbianiga i mas numwehig Mosesna suialag nihem patalfug mo. Eba fwina wasneig. Haisegba sa ne og ka ena kinigbi kikinim Kristenba faigo afa sa ne enaig esegonibi eba God ninimufe. ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Amo, ati big anwenafig Sisas Ainiyagna aflafeglahe God bigim sulfug na sa big ehem olug oniginig gwenaig seg afwambanai gafa esig.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Afa sa mungwali el sifinam Barnabas nai i Pol nai i mom higwagfofna. Afa eheningi enaig sihi ahfini og God afwambanai elim haig haig kigmog kaningina ninga la esinig. ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Afa eheningi maia sihi ahfwahanamba asa Jems sihini og, “Nilite, sa kam higini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Saimon ati sihi fwahana og God ilawana minginag afwambanai elim lambigim afa heafna el fiahsaiyig. ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Enamba Godna mo fli sihiule el gwenaig ginofi fwahini og. Godna buk enaig sihifeg; ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Devitna simbianiga enaig eseg lala lofug bofug pegi afa sa nengigim ka blonam pese nimblaiba. ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Asa mungwali el Ainiyagim yisigifi eba afwambanai el ati ka kanog fwatig eba kana el. ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Enamba Ainiyagna mo ati autunam sihi fwahana afa el enam ati anwenafig asa enaig pugufe.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Afa Jems gwenaig sihifena og, “Asa ka enaig onigig afwambanai el ogna Ainiyagim olug onigi, nofeka fwina ehegepusug faigo. ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Magofi, naiba nawo ginof finim sa big enaig esogo, nofeka fane sanelim faigo ahaga, afa nofeka aga taitufi, afa nofeka sis wena kihlagba ahaga, afa nofeka taf ahaga. ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Afa ati ne anwenafig mungwali kembig laskuhlag lala Mosesna nihe mo mungwali Esug Auguia Osuna suwigafu, autunam pugugum blog glawanga pugug.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Afa kanog fwatieg el i saglag i afa mungwali sios el i mungwa mo sihiaginim asa ehengel nai yi minginag el fwatigbi sa ma Pol mi Barnabas mi Antiok kembig gam wanafui. Asa Judas fena afa ming unehlagba Barsabas afa ming Sailas fena. Eheningiba eba siosna misog el ahfena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Ena elbi pas wahe ningihini. Ena ginof enaig esog: O nilite, Kangel kanog fwatieg el i afa saglag el i enag ginofba afwambanai Kristenim fatigonug, nengel Antiok, Siria, afa Silisia lanai ambangel sa eyi go. ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Kangel enaig higig minginag kangel nai el ambe nem apukegonugum kilimoan mo faigog. Ka mas ehem enaig sihifegonug mo. ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Asa ka mungwa mo sihiagigim afa sa minginag elim fwatigbi sa kangelni suialag nilite Pol mi Barnabas mi nengelim ningihia gonug. ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Enag eheningiba ilawana maia Sisas Krais Ainiyagna gafugag hofefnaba minginag el ogna patigi skotigi. ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Naigsegba na sa ka Judas mi Sailas mi ningitigibi sa ma ahblonam ena mo mengig na ahsihi enag ginofba mungwalofug. ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Godna Sungwabug i kangel i mungwalofug onigig fig mas ka nem kinig skogoniafufi. Afa ka sawiyifig sa ne hwa nihe mom patalfu. ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Sa nofene fane sanelim faigo ahaga, nofene taf ahaga, afa nofene sis wena kihlagba ahaga, afa nofene aga taitufi. Afa ne enaig esi fwainigba eba ne suialafifi. Gwenaho. ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Afa sios el enag elim ningitiginimbi asa Antiok kembig gam pas ufuna. Afa apukenam Antiok sios elim unetiginim maia laskuhlanamba asa pas mo faigona. ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Afa ena ginof suwiginim maia ehem kwaganamba asa sifakalini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Judas i Sailas i eba Godna mo fla sihiaule el ahfena asa eheningi Kristenim fwina sihinug gafenam afa kigmognug ahfenam ena mona ahkwagana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","34","Afa eheningi ati numwehe enanai yi hawagna afa sa Kristen esogona og, “Sa ma Godna olug enesieg nem gohoni.” Enaig esogonam asa pese heafgina kembig gam ningitigini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Afa Pol i Barnabas i afa minginag el fini Antiok kembig auguiafenamba asa Ainiyagna mo ogfufegonfni afa mo sihigonfni. ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Afa maia managenaba Pol Barnabasim sihina og, “Nawo pese nilitem nangwaghiag ahfiah ka mungwali kembig sa big Ainiyagna mo sihinug ahfe blog na ika ahnangwag fig suialag auguia me awai awai me.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Afa Barnabas ogna Jon Makim ahwaniki. ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Afa Pol mas enaig onigina mo. Ehe enaig onigina og autunam Jon Makba big ambe Pamfilia la apukenam afa ehe bigim pese lasani ikana. Afa ehe mas gafugagim auwigina mo. ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Afa hefum flafihiag ahfenam asa ahpwatwagna. Afa Barnabas Makim suluflanam ahka bot la ahkonam asa Saiprus gam ahkana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Afa Pol Sailasim suluflanam ona ahka afa sios esogoni og, “Ainiyagna aflafeg sa nem numwehe lambfiahkafi” asa ahkana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Afa eheningi Siria afa Silisia la enanai yi kaksag kembig fapugu ahfiahkafnaba sios elim kigmognug ahfiahkana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pol ikan Derbe yi wanpugunam afa ena kembig fwahanam Listra gam ika wanpuguna. Afa enanai yi Timoti Kristen el gafena. Afa heafna afag gafa Kristen afa ehe Ju angwafig afa alagba eba Grik el. ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Afa mungwali Listra la nai i Aikoniam la nai i Kristen el enaig esogona og, “Timotiba suialag el.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Afa Pol ogna Timotim waniki afa mungwali Ju el enanai ati ehe anwenafini Timotina alag eba Grik el asa Pol Timotina nihim kokohianagena. Grik el mas enaig esi afa Pol enaig esenamba, eba mas Ju el Timotim haig esini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Afa Listra kembig fwahinim asa haig haig kembig fapuke fiahfufnamba asa sios elim sihigonugiafufna. Ena nihe Jerusalem lanai kanog fwatieg el i afa saglag el i ena mo sihini fwahinimbi og sama enam patalfui. ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Asa sios elni olug onigig wasnei asainamba afa sa mungwali osuna minginag el ambe fasaiyena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Pol fena afa minginag apaiyena asa Frigia Galesiana bite gam afuna. Afa Godna Sungwabug ehegelim kweni og masa Esia na provins Godna mo sihife. ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Afa afu Misiana bite la apukenam asa gwesim Bitinia bite gam ogna afu afa sa Sisasna Sungwabug ehegelim kweni. ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Maia enaig esenamba asa Misia mo fwahinim afa Troas gam paiye afuna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Afa sinaini Pol itila lofug nangunamba el mungu provins Masedonia nai gofenamba Polim unena gofena og, “Ne Masedonia gam blonam sa kam kwagan.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Afa Pol enam nangunam asa ikagna kangel numwehiagofi Masedonia gam afuiagim. Ati ka onigig enamba God kam ogfunug ehe kam ningitigi heafna suialag mo enag elim sihigonugim. ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Kangel sip yi fukoalinam Troasim fwahinim asa Samotres gam gwesim afuna apukenam afa nanai liana ka fwahinim Neapolis gam afu apukena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Afa nanai ka ena kembig fwahinim Filipai gam afu apukena. Ena kembigba Masedoniana kwania kembig afa Rom el nanai yi auguna. Kangel nanai yi mwakwalig auguna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Afa Esug Auguia Osuna koka esim afu nanai yi augu Godim sihinafuhug kugim nangu. Ka kembig muhla afunam bu blugim apukenam afa angwafig laskuhla gofena asa ka augunam mo sihiagini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Afa mungu angwafig gafa ena mo higina ehena unehlagba Lidia. Ehe Taiataira nai ango, suialag nemog tafnaig lofug faig asa enanam kig kwania flag. Ehe Godna unehlag fingi fiahfna. Ainiyag ehe ehena olugim numwehenage namba asa Polna mo higinam keahlana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ehe afa heafna mungu lala nai bu la apaiyena. Enanam kangelim heafna lala gam kam unegoni. Ehe enaig esona og “Ne onigig ka nufunam Ainiyagim oniginagba asa ne kana lala ambe auguiafim.” Ehe kam fwina kukusihiagenamba asa ka afuna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Nanam ka Godim sihinag kugam afuofefnamba ka gafuga angwafig angwamingim uflini. Ena angwafigbi mwaifig simbagahlana esefkufna asa ehe haig haig sumi yi puguiagegim sihiageafena. Ehe enaig gafuga fiahgefenam enanam kig kwania flafnam ena kigba nangwaghiawagig elim faifini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Afa Pol kam wankafnaba ena angwafig sum blonam unetigina og, “Sona elbi eba ehengel God sisinai na gafugag el. Ehe enaig mo sihig God ena mina elim lambigim.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ehe gwenaig sihi wahkig fegofnamba Pol oksinam waikefe mwaifigim sihina og, “Sisas Kraisna unehlag la ka nem mo osihina ne hwa angwafig fwahanam ika.” Asa ikagna mwaifig ehem fwahanam ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Nangwaghiawagig el nangunim maia heafgelni kig mina awaienimbi asa ehengel Pol mi Sailas mi lambtiginim ambala fwatigini og sama kembig lanai misog el nangwagi. ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ehengel lambtiginim misog elni nofla wanafu fwatiginim afa esogona og, “Sona elbi Ju el afa eheningi bigelni kembigim gasafahfeg. ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Eheningi elim kukusihiagafeg enaig nihe bigel Rom el nofeka enaig esi.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Afa minginag el mungwali lasnam ogna Pol mi Sailas mi patigini. Asa misog el enaig esona og polis ma lofug hugfuoiti fegonim asa eheningim fifiletifi. ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Afa eheningim fwina wena kwaskofinim asa kalabus lala lambtianhini. Afa misog el kalabus lala nangwaghiawagig elim sihina og fwina nangwaghiage afufum. ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Afa higinam asa lambtinam yiminig mengig gam lambtigianhini. Afa sa eheningina mongugum palangna singihla fwatigini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Afa sinaini mokug luputiegna Pol i Sailas i beten ahfenam afa mwanafi Godim ahfatiaufna asa minginag gwena lala nai el higaflafena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Afa gwenana ikagna kwania asag ihlafona kalabus lalam fagakuku fiahflana. Afa gwenanam mungwali mengig pigiakanam afa sen kalabus elim kikeg pigia apaiyena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Afa kalabus lala nangwaghiawagig el buihianam afa nangunam maia mengig pigi gohkafnaba ehe enaig onigina og atimba apuke ahkwag minefeg. Asa ehe pina flanam ogna hefum higeflaka. ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Afa Pol unenam og, “Nofeka nimbefum amtakwale fati. Hoka mungwali auguia.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Enag el ming elim unenam og ma wi gafla blui. Afa ehe mo kikini blonam Pol Sailasna nihi penam kiafigig gegifini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Afa sambaganigim lambtiginam afwambagam pugu wankanam sahtigina og, “Saglag, haig sa ka eseba asa God ma kam kwefunam suiala flai.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Afa sambaganigi esohona og, “Sisas Ainiyagim sa ne olug onigina eba sa ma God nem afa mungwali nimbeafna mungwa lala naim lambi.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Asa eheningi Ainiyagna mo enag el mi afa heafna lala nai mi ahsihini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Enanam gwena sinaini ena el kalabus lala nangwaghiawagig el sambaganigim bu la nehugugim suhiagena afa enanam ehe fena afa heafna mungwa lala nai apaiyena afa asa bu la apaiyena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Afa sa sonag el sambaganigim heafna lala wankanam fane tuhlfunam faini. Afa sa ehe fena afa heafna mungwa lala nai fena Godim oniginim asa fwina sifakalini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Afa liana misog el polisim ningitiginibi asa afu sihini og, “Sona sambaganigi elim ningitigibi sa makai.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Asa kalabus lala nangwaghiawagig el Polim sihina og, “Misog el ati sihig ne i Sailas i se wanai ahfwahanam ahka asa ne olug eneisieg na ahka.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Afa Pol polisim sihini og, “Ka mas mangwal ahfeg mo ehe kam muni mungwali elni nof la kwaskofigim kalabus lala lambtianhig. Kaningi Rom el asa enamba amtakwalig afa kam esegonigim enamba meagam kumohlig. Afa ehe enaig membite kam og ma pugu ahkai eba sa ma kam ambe sihigonitem asa kam wanafuite.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Afa polis ena mo misog elim oku sihini og Pol i Sailas i ba Rom el asa ehengel sineminefinim embefini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Asa afunam suialag mo sihigoniginim afa wanapuke afunam og “Ai, sa ne hwana mo ahfwahanam asa ahka.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Afa sa eheningi kalabus lala ahfwahanam Lidiana lala gam ahkana. Afa ahka Kristen nilitem ahkuklunam mo wasneihiag ahfenam asa ahkana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Afa eheningi ahka Amfipolis mi afa Apolonia mi mo ahfwahanam Tesalonaika la ika ahpuguna. Enanai yi Ju ni laskuhlag lala gofena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Afa Pol enaig eseakafena ikafenam laskuhlag lala sefukafenam afa nanai yi sambaga mungu Esug Auguiag Osuna ehe Baibelna mo ogfunigiafna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ehe enaig sihifena Godna Gisfu Fwahag el ehe kinig flagim afa sa pese buihiag. Ehe og, “Sona Sisasba ka nem osihin eba Godna Gisfu Fwahag el.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Minginag Ju el ena mom higinim kehlini. Ena el i afa kaksag Grik Godna unehlagim fingi fiule el i afa minginag misog angwafig i Pol Sailas nai yi wuhlana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Afa Ju el oksiasaina asa amtakwalig elim sulfuiafuna mungu la lasnam amtakwalig onigig faigona sa ma olug kakageagi lagnim asa mungwali kembig gwenaig esini. Ehe ogna Pol mi Sailas mi lambtinim olyi lasan asa kikini afunam Jesonna lala apukenam mengig tofunim saiye yisigini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Afa mas ulambini mo asa Jeson mi afa mingnag Kristen nilite mi wanagim hugfu wanafuna kembigna misog el nangum asa lagini og, “Sonag elbi mungwali kembig haig haig amtakwalig gafugag eseagahfiakag blog bigelni kembig la ahpugug. ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Afa Jesonba eheningina hihe na sa ehena lala hawag. Ehengel Romna misog elni nihe mom mas fatig. Afa ehe enaig esogog ming misog el goh eba seflig unehlagba Sisas.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Afa misog el i mingwali el i enaig mo higinim asa ehengelni olug wasnei eskofenam hefum gifigakafna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Afa ehengel ogma Jeson wanag kigna baiminim asa ma enanai fwahi. ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Afa si kifiagna Beria gam Kristen nilite Pol mi Sailas mi ningitigini. Ika ahpugunam Ju elni laskuhlag lala asaifuna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Beria nai elni nihe fwina suialafena eba mangwal mungwalofug mo Tesalonaika el asa esini. Enag elbi higinim sifakalini afa ehe mungwali osuna Baibelna mom fahigifinim asa Polna mom kwefihianagini afa nufunam me awai awai me. ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Asa kaksag el Ainiyagim onigini. Ju el i afa kaksag Grik el i afa minginag Grik misog angwafig i gwenaig esini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Enanam Tesalonaika nai Ju el ena mo anwenafini maia Pol Beria la Godna mo sihini gofefenaba asa afu apukenam ehengelni onigigim fingi fegoni ogma Pol mi Sailas mi amtakwalihiagi. ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Afa sa ikagna Kristen el Polim buum blugim ningihini. Afa Sailas i Timoti mo Beria la hawagfena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Afa minginag el Pol ika Atens la wanpugunam enanai yi ehem lasunim asa pese Beria gam ambena. Pol ehengelim sihini og sa ma Sailas mi Timoti mi sihigonibi sa ma ikagna Atens gam ahbloi. ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Afa Pol enanai yi gafenaba Sailas mi Timoti mi nenge niaufena. Afa maia ena kembig haig haig kaksag mwakwal god esiaginimbi enam fahigiagenam olug fingi fena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Asa ikana laskuhlag lala sefunam Ju el mi afa Grik Godna unehlag fingi fiule el mi sihinigena. Afa minginag osuna laskuhla fohug la gohnam asa enanai elim sihini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Minginag anwena el Epikurian nai i afa Stoik nai i onigigim patag afuiafena enag Pol wanflafihiagena. Minginag hefum sahawagini og, “Sona elbi ehe mimewofe. Haig mo maia osihiba?” Afa minginag enaig esogona og, “Eba ehe ming bite nai godim bigim kukusihiagofe.” Maia enaig esogonaba asa Pol Sisasna mo i afa lahag buihiag mo i faini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Afa Polim Areopagus laskuhla mug la wanikafunam afa enaig esogona og, “Kangel koka mulug mo higim asa ne minginag elim sihinige blog. ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Minginag mo saka higigba eba algana onigig kam fenig asa koka ena mogum numwehe anwenafi.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Afa Atens el i afa mingnag kembig la nai el i gafugag mo fwahinim haig haig mulug mo fwina membini higinim afa hefum sihiagini asa ehe enaig esogona.) ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Asa Pol buihiagonam saglag elim Areopagus mog la auguiafenaba asa esona og, “Ne Atens el, ati ka nangug nengel noka kaksag haig haig godna unehlagim fingi fi. ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Ka gohminefiahba ka fahigiagegba haig haig gawigim ne lotufinig. Ka nangugba mungu godim faig sime la enaig ginof goh. Ena ginof sihi og, ‘Ena godba ka mas anwenafinig mo eba ehena sime.’ Ena god ne mas anwenafig mo asa ne ehena unehlagim fingi fig na ka nem ambala upugunig. ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","God ehe mungwali bite i gawig i eseageg ehe ofna bitenaina Ainiyag feg. Ehe mas el lala nimblagba nanai yi gofi. ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Bigel el mas big mangwalimba kwegfui. Ehe munguhe ihlafiahgeg. Afa eba ehe mungwali elim nofkikenag faig, afa efefug faig, afa mungwali gawig faig. ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ehe mungu elim esenagba asa mungwali el mungwali bite puguiageg. Ehe enag osuna bigelni afahumonim bigim wanaflagim fwahana afa hanai yi bite big auguiagim bigim fwahani. ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","God enaig esegba og ma el asa ma ehem yisgi afunam afa atiamba ehem ufli me. Afa ehe mas bigim mungu mungu membi yi fenig mo. ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Afa ehe nofkikenai i afa wasneig i bigim faigbi asa big gohka. Eba gwenaig eseg autunam nengelni anwena el ati ginofi fwahini og, ‘Ati big gafa heafna luwalig fiahsaieg.’ ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Asa big Godna luwal fig. Asa nofeka enaig onigig God eba gol, silva, fun lofug asa el heafna onigig la ningana flagim ginof fenageg. ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Autunam bigel mas numwehi anwenafini mo asa God mas bigim wasneig kwefihiageni mo. Afa ilawo ehe mungwali bite nai elim wasneig mo faig og sa ma olug waikefinim amtakwalig nihe fwahi. ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","God ati ena osuna fwahag asa elim kwefihiagefe afa ati elim wefug fwahag asa numwehe fwina kwefihianugefe. Ena elbi ati lahagim pese buihiag enamba ogfug God ehe ehem wefug fwahag.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Afa maia Pol sihinaba el lahanam buihiag mo asa minginag el ehem titigini. Afa minginag enaig esogona og, “Ka membig koka higim asa ne pese kam gwena mo sihin.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Maia enaig sihifinimba asa Pol lasanam ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Afa minginag el Polim patalfunam asa Ainiyagim onigini. Afa mungu patalfuiag el eba Dionisius ehe Areopagus nai saglag el. Mingba angwafig unehlagba Damaris fena afa minginag el apaiyena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Afa Pol Atens fwahanam Korin gam ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Afa enanai yi ehe Ju el Akwilam uflana. Afa Akwilana mog kembigba Pontus ehe heafna angwag i Prisila managig fwainig Italim ahfwahanam Korin gam ahkana. Haisenamba, eba Romna misog el Klodius sihini mungwali Ju el sa ma Rom kembig fwahinim afui. ");
INSERT INTO amn_amanab_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Akwila i Prisila i sel lala kwelwagig el gwenaig Polna gafugag lofug. Asa Pol ehem ika nangwagenam mwakwalig augunam asa ena gafugafini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Mungwali Esug Auguia Osuna Pol Ju elni laskuhlag lala ika sefufenam sihinigeafna afa ehe ogna Ju el mi Grik el mi kukusihianige og ma Ainiyagim onigi. ");
INSERT INTO amn_amanab_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Afa maia Sailas i Timoti i Masedoniam ahfwahanam ahblonaba Pol heafna gafugag mo fwahanam afa wahkig Ainiyagna mom gafugafegofna. Ehe fwina Ju elim wasneig mo sihini og, “Sisas eba Godna Gisfu Fwahag el elim lambfe.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Afa Ju el mas ena mom membini mo afa ehengel Polim amtakwalig mo sihinaginiba asa Pol heafna nihinai lofug la nai nufusige buiabufehiagenam afa esona og, “Ka nem nufunam mo sihinigbi afa ne mas fatinig asa God kam mas esonai. Eba ne mungwag nimbeafena susug amtakwalig lambfi. Afa ilawamba eba ka afwambanai elim uku sihinfi.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Afa Pol Ju elni laskuhlag lala mo fwahanam pugunam ika Titius Jastusna lala gafena. Ena lalaba laskuhlag lala muhla gofena. Ena elbi afwambanai eba Godna unehlag fingi feule. ");
INSERT INTO amn_amanab_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Afa Krispus eba Ju elni laskuhlag lalana saglag el fena afa ehe fenam heafna mungwa lala nai apaiyena afa Korin nai el kaksag apaiyena enag Godna mo higinim afa olug waikefinim asa bu la apaiyena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Mungu sinaini Pol itila lofug nanguna. Afa Ainiyag ehem sihina og, “Nofeka embefe. Sa ne fwina sihiakafim. Nofeka mwalfwai gofim. ");
INSERT INTO amn_amanab_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Eba ka ne i ahgofife. Mas nem amban amtakwale fati eba ati kana kaksag el fiahsaieg ena kembig la.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Asa Pol enanai yi mungwa yia fena afa haf fena enaig la ganam Godna mom ogfu fenugena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Enanam maia Galio eba Akaia nai provins misog el fenamba enanam Ju el laskuhlanam ogna Polim haig minefenagi afa sa ehem flinim misog el nangum wanigafunam asa ma misog el kwefihianage. ");
INSERT INTO amn_amanab_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Afa ehengel enaig esogona og, “Sonag elbi elim lambigim kukusihiageg Godim lotu fenigim eba bigelni nihe mo flafog.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pol og nawo wahigi sihin afa Galio Ju elim esoni og, “Atiaho nengel Ju sa ne enaig esogog sona elbi ehe fwina amtakwalig eseageg enag kog kawo nengelni mo higinam asa ehem kwefihianage. ");
INSERT INTO amn_amanab_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Afa ne fwinam unehlag mi afa nimbiafgelni nihe mo mi ne seslefofiagig. Enam kam oksig, neafa nimbefum ehe sa ne kwefihiagi.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Afa sa ehe Ju elim enanai ningitigina. ");
INSERT INTO amn_amanab_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Afa ehengel olug kakagini asa Ju elni laskuhlag lala naim saglag elim Sostenisim kehlinim kot lala muhla tigekini. Afa Galio mas enaigim onigina mo. ");
INSERT INTO amn_amanab_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Afa Pol Korin la mwakwaliganam asa Kristenim mo lasanam. Afa sa Akwila mi Prisila mi wanikana bot la wanfokunam asa Siria gam afuna. Pol akofenaba Senkria la samawina eba enaig esenaba eba ogfug ehe ati Godim mo sihi fwahana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Afa afu Efesus la apukenam Pol Prisila mi Akwila mi mo lasanam ehe mo ikana Ju elni laskuhla lala sefunam Ju elim mo wansihiagena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Afa minginag ehem sahanagini og, “Sa ne kam mwakwalig wanai.” Afa ehe og, “Ka mas enaig ese.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Afa alasan fenamba ehe enaig esona og, “Afa God sawiyi fegba eba ka pese blofe.” Afa sa ika bot la mo fukonam Efesus mo fwahanam ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Bot la ikan Sisaria la pugunam ika Jerusalemna sios elim ika nangwagena. Ika nangwagenam asa Antiok gam ikana. ");
INSERT INTO amn_amanab_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Pol enanai yi mwakwalig ganam afa fwahanam ika distrik Galesiana kembig mi afa Frigiana kembig mi enanai yi Kristen elim wasneihiagena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Afa enanam Aleksandria lanai Ju el Apolos ehe blo Efesus la gafena. Ehe suialag sihifeafena afa ehe ati Godna bukim numwehe anwenafena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Enaba ati numwehe Ainiyagna minam ogfufenagini nasa afigigenam ena mo sihinaba afa ena mo nufunafena. Afa ehe mas anwenafena mo Sisasna unehlag la bu la apaiyegim eba Jonna bu la apaiyegim mungu anwenafena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Afa ehe ikanam Ju elni laskuhlag lala fwinam sihinaba asa Prisila i Akwila i ahiginam afa ahsulflanam heafningina lala gam ahwanikanam enanai yi numwehe minginag mo Godna minam ogfufenag ahfena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Afa Apolos ogna Akaia gam ika afa Efesus nai Kristen ogna ehem kwefu. Asa pas ginofinim Akaia Kristenim faigona og sama ehem sulfli. Afa maia Apolos Akaia la pugunam asa Kristenim enanai yi fwina kwagana. Enag elbi God ati aflafenigbi asa ehengel Godim oniginig. ");
INSERT INTO amn_amanab_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Afa Apolos Ju saglag elim mo soaginim afa ambala fwina ehengelni mom pigalampinam asa ehe Godna bukim ambala ogfuni og, “Sisas eba God Gisfu Fwahag el elim lambigim.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Afa maia Apolos Korin la gafenaba Pol maisim mina la wagieblon asa Efesus la mo puguna. Enanai yi patalfuiag elim nangwagina. ");
INSERT INTO amn_amanab_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Afa ehengelim sahtigina og, “Maia ne olug oniginiba satiaho ne Godna Sungwabugba lambig?” Afa wahigi sihini og, “Awai, ka mas higini mo Godna Sungwabug gohogba.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Afa Pol sahtigina og, “Atiaho, eba hag bu la apaiyeg ne flig?” Afa wahigig sihini og, “Jonna bu la apaiyeg ka flig.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Afa Pol sihina og, “Jonba enaig esena ambangel olug waikefigbi asa bu la apaiyeafena. Afa ehe elim og sa olug onigini el sa sum oblo eba Sisas.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Ena mo higinim asa Sisas Ainiyagna unehlag la bu la apaiyena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Asa Pol ninga ehengelim sisi fakanimba asa Godna Sungwabug ehengelim blo gohonimba asa ehengel haig haig mona fiahgini afa Godna mo fli sihiule lofug fifini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Enag saglagna nambaba gwesim hili 12 fena muhla fena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Afa sambaga mungu was yi Pol Ju elni laskuhlag lala fakafegofena mo sihiagim afa ehe soaginim afa fwina sihinigeafna mas embefena mo ehe ogfuni Godna bog meg nufunam feg. ");
INSERT INTO amn_amanab_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Afa minginag el ena mo higigim angsam minim afa ehe Ainiyagim onigigim oksini afa elni nof la Kristeneg minam molampiagini asa Pol laskuhlag lala fwahanam minginag Kristenim wankana. Afa mungwali osuna asa ikafna Tiranusna anwena lala sefufenam sihiageafena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Gwenaig esegohum ikan sambaga yia fena. Asa Ju el i Grik el i enanai yi Esia provins la gofena enag Ainiyagna mo higini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","God Polna ninga la haig haig kigmog ogfuiagena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Afa el hankisip i lofug plefwag i lambfinim ufufenam Polna nihi yi nana tuhfinim asa lambfufenam gih elim lambwai goafenamba asa gih i sanel i fwahia afuiafena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Afa minginag Ju el afufeanim Ainiyag Sisas unehlag la ogna sanelim ningitigifi. Afa ehengel sanelim enaig esogoni og, “Sisasna unehlagim Pol sihiba enag ka nem sihinigbi sa ika.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Afa Skeva eba Ju el ehe misog pris heafna luwalig enwesog la gohna. Enag el sanelim enaig esegonigini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Afa sanel amtakwalig ehengelim sihini og, “Sisasba kati anwenafeg afa Polba kati anwenafeg afa nengelbi ambangel?” ");
INSERT INTO amn_amanab_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Afa ena el sanel amtakwalig ehenai yi gohoule puso kugunam fwina kwaskofiahkanaba lofug mo hugfuoiti gifenimbi asa ehengelni nihi buihiamalig fiahsainam asa taf puko peminefena sa lala mo fwahinim emegfoi embem afuna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Afa Efesus lanai Ju el i Grik el i maia ena mo higinim asa fwina embefeagenim sa Sisas Ainiyagna unehlam fwina fingi fini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Afa kaksag el autunam sa haig haig eseagini enag Ainiyagim onigini enag ambe minginagna elni nof la heafgelni haig haig mo sihiagini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Afa kaksag el agisu ule afa weni ule enaig eseagifini ena buk amtakwalig angogulinim asa elni nof la suwi la wehlini. Mungwali ena bukba suwiginimbi eba 50,000 kina enaig fena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Enaig esifinimbi asa Ainiyagna mo wasneinam asa pugu mungwali kembig ikaminefena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Afa maia enaig esinimbi asa Pol ogna Masedonia afa Akaia gam pugunam asa Jerusalem gam mo ika. Ehe og, “Ati ka osumba nangug afa ka sa Romim gafa ika nangu.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Afa sa Pol Timoti mi Erastus mi Masedonia gam ningitigina. Eheningi Polim ahkweg fwafena. Afa Pol mo Esia Provins la maisi gafena. ");
INSERT INTO amn_amanab_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Enanam Efesus el hefum fwina flafihiagini afa moanagini Ainiyagna minam. ");
INSERT INTO amn_amanab_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Afa Demitrius Efesus la nai el heafna gafugagba silva fiageule. Afa silva flafenam higfehiagefenam weti klug lotu lala lofug gafugafeafna. Ena lotu lalaba ofenaiba Artemisna kwania lotu lala Efesus la gofena. Artemis eba Efesusna god angwafig. Demitrius fena afa minginag gafugag el apaiyena ena gafugagna kig kwania flifini. ");
INSERT INTO amn_amanab_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Afa heafna gafugag el mi afa minginag gwenag gafugag la nai mi unetiginam ma laskuhlanamba. Ehe enaig esona og, “O nilite, ne ati ne anwenafig big kaksag kig ena gafugagna big flig. ");
INSERT INTO amn_amanab_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Afa big higigim nangug Pol sa eseageg. Ehe enaig esog god el ningina gafugafegba eba mango god mo. Eba ehe Efesus la nai el mi afa Esia provins la nai el mi ehengelni onigigim gasaf lambfie. ");
INSERT INTO amn_amanab_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Afa gwenaigba ikafiba eba el bigna gafugagim moalampbi fi. Afa bigelni kwania god angwafig Artemisna unehlagba amtakwalefe. Afa mungwali el Esia provins nai afa mungwali bite enanai yi go ehena unehlagim sa fingi fig. Enag masa enaig onigifi Artemisba eba wasneig awai afa heafna lotu lala eba esug gofufe.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Afa mungwali ena mom higinim olug kakagiagini afa wasneigni lagini og, “Bigelni Efesusna Artemis eba ehe sisi fenig.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Afa managig fwainig mungwali kembig bugiagafenam. Afa Gaius i Aristarkas i Pol Masedonia nai wanblona, eheningim lambtinim laskuhla fuhug la ikagna wanfuna. ");
INSERT INTO amn_amanab_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pol ogna ika el nai yi olyi pugu afa sa patalfuiag el ehem kweni. ");
INSERT INTO amn_amanab_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Afa minginag Esia provins la nai misog el afa Polna hihe gafa, ehem mo ningihini og, “Nofeka enanai yi laskuhlag fuhug laba ika.” ");
INSERT INTO amn_amanab_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Afa el laskuhlanam etetiagenim h