﻿USE sofia;
DROP TABLE IF EXISTS sofia.amm_vpl;
CREATE TABLE amm_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES amm_vpl WRITE;
INSERT INTO amm_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ni mo Isiso Kolaisoni aniyopatono iyalini siyolo siyolo na. Isiso, tota mo Toiwini nakosai. Toiwi mo Apolofamoni nakosai. ");
INSERT INTO amm_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Apolofamo mo Isakoni apitono. Isako mo Yokoponi apitono. Yokopo mo Yutoni apitono, tani auwatono iyaliwoi mani, apitono mo tomoso nali. ");
INSERT INTO amm_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yuto mo Piliso noko tini apitono, Pilisowoi Silawoi. Totini atino mo Toima. Piliso mo Hisolunoni apitono. Hisoluno mo Lamoni apitono. ");
INSERT INTO amm_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Lamo mo Aminotaponi apitono. Aminotapo mo Nasononi apitono. Nasono mo Salomononi apitono. ");
INSERT INTO amm_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salomono mo Puwasoni apitono. Atino mo Lihapo. Puwaso mo Opoitoni apitono. Atino mo Luto. Opoito mo Yasini apitono. ");
INSERT INTO amm_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yasi mo samukuko nokota siyoli Toiwini apitono. Toiwi mo Solomononi apitono. Atino mo toku mo Uliyani noni. ");
INSERT INTO amm_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomono mo Lihapowani apitono. Lihapowa mo Apiyani apitono. Apiya mo Asani apitono. ");
INSERT INTO amm_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa mo Yohasofatoni apitono. Yohasofato mo Yolamoni apitono. Yolamo mo Usiyani apitono. ");
INSERT INTO amm_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiya mo Yotamoni apitono. Yotamo mo Ahasoni apitono. Ahaso mo Hisikaiyani apitono. ");
INSERT INTO amm_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hisikaiya mo Manasani apitono. Manasa mo Amoni apitono. Amo mo Yosaiyani apitono. ");
INSERT INTO amm_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosaiya mo Yokonaiya iyalini apitono, Nonani noko iyali simai Poipilono nokoyo uo monoi tiki, Isolilo noko tukuwoliya tumokino, siyai mo yau yau, siyai mo Poipilono asiso na kuloli ilomanokino, mi anoti monoi. ");
INSERT INTO amm_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Kuloli ilomanokino mo; Yokonaiya mo Siyalotiyaloni apitono. Siyalotiyalo mo Silapopiloni apitono. ");
INSERT INTO amm_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Silapopilo mo Apiyatoni apitono. Apiyato mo Iliyakimoni apitono. Iliyakimo mo Aisoloni apitono. ");
INSERT INTO amm_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Aisolo mo Satokoni apitono. Satoko mo Aikimoni apitono. Aikimo mo Iliyatoni apitono. ");
INSERT INTO amm_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Iliyato mo Iliyasani apitono. Iliyasa mo Motanoni apitono. Motano mo Yokoponi apitono. ");
INSERT INTO amm_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yokopo mo Yusifoni apitono. Yusifo mo Moilini nokitono. Moiliyo Isiso mo na kiki. Kolaiso tokaluwai manokoni, noko no mo Kotoyo no muwokaiki no, Isolilo noko moi fasimoka tumo monoi. ");
INSERT INTO amm_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","No monoi no mo, Apolofamoni nakosaitono iyali mo ainoso Toiwiwoi nali no, noko mo naino ti uwai toitati noko, 14 na. Toiwini nakosaitono iyali mo ainoso Yokonaiyawoi tomoso nali no, noko mo naino ti uwai toitati noko, 14 na. Nosai no Poipilono asiso monoi kuloli ilomanokino. Yokonaiyani nakosaitono iyali mo ainoso Kolaisowoi tomoso nali no, noko mo naino ti uwai toitati noko, 14 na. ");
INSERT INTO amm_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Moiliyo Isiso Kolaiso ki aino imo mo noino. Moili mo Yusifoyo kauso monoi yasoi muwosokaikino. Ulai kalumanisowoi muwoi, muwoliwoisoso na kosokino. Kotoni Mulu Itouniyaimo Nokotani amiyo muwoliwoi na tolosoki. ");
INSERT INTO amm_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Muwosokai nokota, Yusifo, to mo mulu itouniyaimo nokota. Noko nokolaloni molo timai mo auwosi imo isowoi muwoi, na mulumolokoki, “Yo mo wosu woso na tafolikaiso.” ");
INSERT INTO amm_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Mulumoloko manoki mo; na solitonomoki. Solitonosai Siyoli Nokotani kumoki nokotaso kiki, na imoki, “Yusifo, Toiwini nakosaitono, nono mo nonani noni, Moili, kauso monoi mo noiyo nisoi. Na pukwaimono. Kotoni Mulu Itouniyaimo Nokotani amiyo nali no, no monoi no muwoliwoi na toloso. ");
INSERT INTO amm_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nokokai alu na kiyoimo, tani siyolo mo Isiso pako kaluwai. Ulai afonimaiso? To mo noko nokolaloni mulu kopokoiyau saloso uwokoimo, no monoi no samiyaikiyoinomo.” ");
INSERT INTO amm_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Komaso no fiyamosokoki no, no mo afonimaiso fiyamosokowoi muwoi. Koto Siyolini imo motu fiyamosi monoi na fiyamosokoki, tani mulu lukasiko nokotayo no kumokaiki no, noino, ");
INSERT INTO amm_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Na pukwaimono, maputo nukonu, nokoyo kalumaniso somiso nukonu, to mo muwoliwoi na tolosoimo, alu nokokai na kiyoimo. Tani siyolo mo noino na kaluwaiyoinomo, Imanuwilo.” Toku aino na kumokaiki. Namolisai mo motu na fiyamosiki. Imanuwilo imo folosai mo noino, Koto mo moiwoi totolo fasikomomokomoi. ");
INSERT INTO amm_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Nosai no mo; Yusifo mo solitono mo uwai; na auwoniyouki. Siyoli Nokotani kumoki nokota, tani imososo aluwainiyouki, no monoi no Moili mo na kausoki. ");
INSERT INTO amm_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ulai kalumanisowoi muwoi, ainoso hani alu kiki. Tani siyolo mo Isiso na kaluwaiki, Yusifoyo mo. ");
INSERT INTO amm_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Moiliyo Isiso na kiki, Pitolifimo Yutiya asi nokonumai. Nomai no Hilo komano nokota siyoli toloki. Alu kiki mo; amoloku monoi sai sisiyoli noko mo ulo amiyo asisai na tiki, Yolusolimo nokonu siyoliso. Na iyamoki, ");
INSERT INTO amm_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Alufa no no, Yuto noko no samukukaki no, to no moiso tanokaino, woi? Koi mo amoloku siyoli wimo toloso kinoki, ulo amiyo ausaimisai. Na tomolokima tumonoki.” ");
INSERT INTO amm_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Hilo siyoli mo nonani imofaso kwaiki, na umanomoki. Mulumolokoki, “Asasu mo samukuko nokota siyoli.” Yolusolimo noko nokolalo komaso mani, kufauko liyaiki. ");
INSERT INTO amm_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Nosai no mo; Hilo mo tolomu nokotalo iyaliso aliyonikoki, lotu samukuko noko komasowoi Musini imo sai sisiyoli noko komasowoiso aliyonikoki. Na utolukoki, “Kolaiso, noko no no Kotoyo no muwokai no, to no moinani asimai ki, woi?” ");
INSERT INTO amm_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Na imokino, “Pitolifimo nokonu, Yutiya asimai kisu. Kotoni mulu lukasiko nokotayo nonani monoi noino na kumokaiki, Kotoni pukoso, ");
INSERT INTO amm_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“Pitolifimo noko, moini nokonu, Yuto nokoni asi mulumai no tanokaino no, moini nokonu no ulai afonimaiso nokonu? Wiyouwa wiyou, noko siyoli nokota mo amai na fiyamosiyoimo, moini nokonumai. Asani Isolilo asi noko samukukoimo, noko siyoli na.” Aino na tiyomuko, Kotoni imo mo. ");
INSERT INTO amm_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Nosai no mo; Hilo mo amoloku monoi sai sisiyoli nokoso wosu woso aliyonikoki, na ikoki, “Nonani amoloku no maniwoi wi toloso kinuwo, woi?” ");
INSERT INTO amm_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Imokino mo, na iko taikiyoki, “Pitolifimo nokonuso na ponuwo, nonani alufa na pikoliyalowo. Atiyaiyaso pikoliyalowo. Kiyanakinuwomo, ifou pa imona tumowo. No monoi no asa mani, molokimanoimo.” No mo topoko imo na, tukolo monoi louwa yoki. ");
INSERT INTO amm_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Komano nokota siyolini imo kwaimo uwai; na nuki, alufa ikoliyalokino. Nonani amoloku toku ulo amiyosai no kikino no, toku toku na wiyaloki, alufa ki nu komu puwomai tomokimoki, na wi toloki. ");
INSERT INTO amm_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Amolokuso kikino mo, siyoliso na molokikino. ");
INSERT INTO amm_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Nuso tiki, alufawoi atino Moiliwoiso na koka tikino. Alokomu losinasikino, alufaso na molokimokino. Iso ifasikino, tomoki kamo kamo hani haniwoi, inoso wotiwoi, kou woti iwowoi ifasikino, alufaso na kouwokaikino. ");
INSERT INTO amm_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Nosai no mo; solitonosai Kotoyo sosaikoki, ikoki, “Hiloni au molosai noiyo nuwoiwo.” No monoi no molo siyasai nuki, totaini asiso ifou nuki. ");
INSERT INTO amm_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nosai no mo; solitonosai Noko Siyolini kumoki nokotayo Yusifoso na imoki, “Na pomoi, alufa noko ti, atinowoi na pokoliyono, Isipi asiso. Na pulolowo. Isipimaiso tola manakinimo, ainoso hani asayo imoiki, ifou tumo monoi mo. Hilo mo alufa mo tukola tumoimo, no monoi no.” ");
INSERT INTO amm_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Nosai no mo; Yusifo mo amolokiyamai auwoniyou nikoki, alufawoi atinowoi mo. Yasoi, Isipi asiso. ");
INSERT INTO amm_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Nomai no si manoki si manoki, ainoso hani Hilo kalo imoso kwaikino. Ainonani monoi mo Kotoni pukoso toku kumokaiki, tani mulu lukasiko nokotayo. No mo Koto Siyolini imo na, totayo toku yomukaiki, noino, “Yani alu nokokai mo Isipi asiso no tolanoki no, yo mo ifou na aliyoniki, ifou tumumo.” Aino na kumokaiki, namolisai mo motuwa na fiyamosiki, Isipi asiso sanomai mo. ");
INSERT INTO amm_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Hilosu mo mulumolokaloki, na mulumolokoki, “Sai sisiyoli nokoyo ifoluwaimonokino, ulo amiyo asi noko toiyo. Yani auso mo ifou tiwoi muwoi.” Wiyou, tani uo mo ta topi. Uo mulu na atolokomoki, Isiso mo na louwa tukoloki. Nokoso na iko taikiyoki, Pitolifimo nokonuso, aumoifaso asisowoi. Na ikoki, “Paumai nokokai alalo lolofa komaso mo na potukuwoliyanowo.” No mo afonimaiso muwoi. Isiso mo paumai alu na. Sai sisiyoli nokoyo yasoi imokino. Amoloku siyoli lolaloso wimo tolo imo mo yasoi imokino. ");
INSERT INTO amm_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Ainonani monoi mo Kotoni pukoso toku kumokaiki, Iyolomaiyayo, Kotoni mulu lukasiko nokota. No mo Kotoni imo na, totayo toku yomukaiki, Pitolifimo aumoifaso nokonu monoi, noino, “Lama nokonu noko nokolalo mo siyoliso sosonuno manoki, alalo monoi na sonukuko manokino. Loisoloni nakosaitono iyalini alalo lolofa noko siyaiyo tukuwolikino, yau yau, no monoi no sonukuko manokino. Mulu kolikaliki, nokoyo no moloi hamukuko monoi? Alalo mo uwofa nali.” Aino na kumokaiki, namolisai mo motuwa na fiyamosiki, Hiloyo alalo tukuwolimai mo. ");
INSERT INTO amm_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Nosai no mo; Hilo mo kaloki, yau. Kaloki mo; Siyoli Nokotani kumoki nokotayo Yusifoso ima tumoki. Isipi asimai ima tumoki, solitonosai, ");
INSERT INTO amm_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","na imoki, “Na pauwoniyou, alufawoi atinowoi na pokoliyono, Isolilo asiso ifou na ponuwo. Nokoyo alu tukolo monoi louwa fi yokino no, toi mo yau yau.” ");
INSERT INTO amm_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Imoki mo; Yusifo mo auwonoki, alufawoi atinowoi na koliyonoki, Isolilo asiso monoi ifou na nuki. ");
INSERT INTO amm_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ulai nosai no mo; imo siya tumoki, “Akolaiyayo apitono Hilo kwalomai monoi totolokaino, Yutiya asi nokoni samukuko nokota siyoli na.” Nonani imo tumoki, na kokolomoki, Yusifo mo. Yutiya asiso mano monoi mo kokolomoki. Ulai solitonosai Kotoyo ti monoi na sosaiki, no monoi no Kalili asiso monoi nuki. ");
INSERT INTO amm_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nokonu siyaso na tolanoki, Nasolito nokonuso. Ainonani monoi mo Kotoni pukoso toku kumokaiki, Kotoni mulu lukasiko nokoyo. No mo Kotoni imo na, totayo toku yomukaiki, “Nasolito nokotaso na kaluwaiyoinomo.” Aino na kumokaiki, motuwa na fiyamosiki, Nasolito numai mo. ");
INSERT INTO amm_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Nomai no mo; Iyono, iwoso uluwako nokota, to mo Kotoni imo noko nokolaloso lukasiko tola tumoki. Nu somiso asiso tolanoki, Yutiya asiso. ");
INSERT INTO amm_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Noino na yomuki, “Molo koiyauso na putukaimowo, molo itouniyaimoso na pa aluwaiwo. Kumokiso you tolokaino nokota mo aumoifaso na samukumoka tumoimo.” ");
INSERT INTO amm_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Iyono mo niya, toku Kotoyo to monoi yomu unuki. Totani mulu lukasiko nokota Aisaiyayo noino kumokaiki, to monoi, “Nokoyo imo siyoliso yomoimo, nu somiso asimai. Na iko toloimo, “Molo koiyauso na putukaimowo, molo itouniyaimoso na pa aluwaiwo. Noko Siyoli mo tumoimo. Na pofoumowo.” Aino na kumokaiki, Iyono monoi. ");
INSERT INTO amm_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Iyono mo kamilo wiyo tuno koiyau asisiki. Toukosiyo tomanomoki. Tani no mo somowoi nuwoi iwowoi saso. ");
INSERT INTO amm_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Noko molopoi noko mo Iyononi auso poti liyai manoki, Yolusolimo nokonu nokowoi Yutiya asi nokowoi Yotano iwo ilo asi aumoifaso si nokowoi. ");
INSERT INTO amm_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Mulu mo yau yau, na iyama tumo liyaiki, “Woi, koi mo molo koiyausoso na taluwai manonoki.” Iyamoki mo; nosai no Iyono mo Yotano iwoso na uluwakoki, Kotoso muwokokainoni monoi. ");
INSERT INTO amm_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Nosai no mo; noko siyaiyo tiki, Falisi moloso aluwai nokowoi Satusi moloso aluwai nokowoi. Toi mani, iwoso uluwako monoi tiki. Kwaikoki, na ikoki, Iyono mo, “Hani monoi tulolonuwo? Nuwo komiyai louwa tulolonuwo, ta monoi. Noiyo no imokinuwo, ulolo no? Kotoyo mulu atolokomo unu monoi ulai hani monoi tulolonuwo? ");
INSERT INTO amm_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Noko mo mulu alosimo uwai, molo itouniyaimoso na aluwaiyumo. ");
INSERT INTO amm_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Moiyosu mo pomulumolokonuwo, “Mulu alosokomomoko mo wiyou tiyamonoki.” Piyamonuwo, “Koini aniyopa mo Apolofamo, no monoi no Kotoyo mo pa amiyaikiyomokoisowo.” Ulai ya timonukuwo, aino muwoi. Molo koiyauso aluwaiyakinuwomo, na amiyaikiyoinuwomo, Apolofamoni alalo siyai mo tomokiso ufosikoimo, moi kwalomai monoi. ");
INSERT INTO amm_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Muwo mo a folomai mo na totolokaino. A komaso a mo a wamo si somiso mo, iko taikiyoimo, taso na fofoukoimo.” Siyokawi imo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ti monoi na ikoki, “Mulu alosokomakinuwomo, yo mo iwoso uluwakomoikuwomo. Noko siyasu mo namolisai amai tumoimo. Tani ami mo siyoli. Yani ami mo koufasu. Yo no moloi fasi monoi? To mo Kotoni Mulu Itouniyaimo Nokotaso na imo taikiyoimo, momaini mulu poiso. Ta komiyai fofouko taikiyoimo, momaini mulu kopokoiyau mo. No monoi nosu muwokomo kaininoinuwomo. ");
INSERT INTO amm_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Totani sawolo mo nainomai na tokomi toliso, paluwa tuo u iyouwaloimo. Ulai hani monoi? Fulomuyo mo kukumo ufosifoliyafoumoimo, paluwa u ititounisu mo ifou salo kono liyaiyoimo. Nosai no mo; no mo uwai; totani paluwa u ititouni mo isikokaiyoimo, totani nuso. Kukumo mo taso utoimo, aniyopa poi poi taso.” Iyono mo aino na ikoki, nokotalo iyaliso. ");
INSERT INTO amm_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nosai no mo; Isiso mo Kalili asiso utukaimoki, Yotano iwoso monoi manoki. Iyonoso mo kiya tumoki, na imoki, “Iwoso puluwamono.” ");
INSERT INTO amm_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ulai Iyonoyo mo wiyou yomuki, imoki, “Yo mo wiyou tiyomu. Nonayosu mo na puluwamono. No mo waliyo na. Yoso no hani monoi timononi, “Iwoso puluwamono.” ");
INSERT INTO amm_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ulai Isiso mo na fowaki, “Waliyo na puluwamono. Aino uwomonakinimo, moti mo Kotoni molo itouniyaimoso aluwai monoi.” No monoi no mo Iyono mo waliyo na yomuki. ");
INSERT INTO amm_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Isiso mo iwoso uluwa uwai; iloso somaiso tola yoki. Nosai no mo; tola yoki mo; kumoki mo na poliyaliyaiki, Kotoni Mulu Itouniyaimo Nokota mo na amukonoki. Anomu komiyai amukonoso na kwaiki, tani auso amukonoso. ");
INSERT INTO amm_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Kumokisai ko na mo koloma konoki, na yomuki, “Ni mo yani alu na. Yo mo to mulu mo siyoli. Yani mulu mo waliyo, to monoi mo.” ");
INSERT INTO amm_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Nosai no mo; Kotoni Mulu Itouniyaimo Nokotayo Isiso mo na kalumaniki, noko somiso asiso. Kalumaniki, Sokolo Nokota Waiyo aini ifoluwai monoi. ");
INSERT INTO amm_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nowoi muwoi, Isiso mo, tiyawoiso potolomosiki, amoloki amoloki ulo ulo, 40. ");
INSERT INTO amm_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nosai no mo; aini ifoluwai nokota mo kiya tumoki, na imoki, “Nono mo Kotoni awitono mo, na piyomu, tomoki ni mo tuo komiyai na ulolumo.” ");
INSERT INTO amm_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Isiso mo na fowaki, “Kotoni puko imo na tiyomuko, “Tuo saso mo wiyou, noko mo pakoso si itouniyaimoiso. Noko mo Koto totani imoso kwaimo mo, na yousi itouniyaimomoi.” ");
INSERT INTO amm_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nosai no mo; Sokolo Nokota Waiyo mo kawiyo tiki, Yolusolimo nokonu siyoliso, Kotoni nokonu no tokaluwai manono no. Lotu nu siyoli nu komumai na kawiyo yoki, ");
INSERT INTO amm_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","na imoki, “Nono mo Kotoni awitono mo, na pofolamo. Ulai afonimaiso? Kotoni puko imoyo na tiyomuko, “Koto mo tani kumoki nokoso iko taikiyoimo, “Na pofasiya konowo.” Ninoino mani, na tiyomuko, “Totaini nainomai komikaiyoinimo. Tomokimai pa kitolomoiniso.” ");
INSERT INTO amm_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ulai Isiso mo na fowaki, “Kotoni imo mo noinoso mani, “Nani Kotoso noiyo imo kiyoi. To mo nani Noko Siyoli.” ");
INSERT INTO amm_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Nosai no mo; Sokolo Nokota Waiyo kawiyo yoki, yuso, yu soliyakiso. Asi asi mo woiso ku tolono liyai na ku wiyononi taikiyoki. Wiyou, asi ititouni nali. ");
INSERT INTO amm_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Isisoso na imoki, “Asi asi komaso ni mo ya na niyoikimo, losiyaiko unumonakinimo, imonakinimo, “Asani Noko Siyoli.” ");
INSERT INTO amm_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Nosai no mo; Isiso mo na imoki, “Sokolo Nokota Wai, fuwoi, na putukaimono. Kotoni puko imo mo na tiyomuko, “Koto mo nani Noko Siyoli. Totasosu na pa molokimomoi, tani mi na pa anomoi.” Aino na tiyomukokai, puko imo mo.” ");
INSERT INTO amm_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Nosai no mo; Sokolo Nokota Wai mo utukaimoki. Kotoni kumoki nokoyo fasiya tumokino. ");
INSERT INTO amm_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Nosai no mo; imofa mo koloma tumoki, Iyono mo kalopulo nuso yasoi kiyono. Isiso mo nonani imofa kwaiki mo, Kalili asiso manoki. ");
INSERT INTO amm_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Nasolito nokonusai manoki, Kopanaumo nokonuso na tolanoki. Kopanaumo nokonu mo iwo toku ilo kwamai toi. Sipulo asiwoi Napotalai asiwoi, nonani asi mulumai toi, Kopanaumo mo. ");
INSERT INTO amm_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Kopanaumo nokonuso afonimaiso tolanowoi muwoi, Kotoni imoyo motu fiyamosi monoi, tani mulu lukasiko nokota Aisaiyayo toku no kumokaiki no, noino, ");
INSERT INTO amm_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sipulo asiwoi Napotalai asiwoi mo Kalili iwo toku ilo kwamai tanono. Kalili iwo toku mo Yotano iwoninoi komu. Noko nokonu noko mo na tosi liyai, Kalili nokowoi tosi tomasika tumono. ");
INSERT INTO amm_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Tolomu noko mo Kotoso pa tomulumolo luwainoso, folosumono kolokokai. Folosumono kolokokai mano mo, saponi siyoli na kiyoinomo. Folosumaiso tosi liyai, kolikali moloso taluwaiyalono. Taluwaiyalo manono mo, na fupiniyaimo kolokoimo.” Toku aino na kumokaiki. Namolisai mo motu na fiyamosiki. ");
INSERT INTO amm_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nosai no mo; Isiso mo lolaloso lukasikaloki, Kotoni imo mo. Na ikoki, “Molo koiyauso na putukaimowo, molo itouniyaimososo na pa aluwaiwo. Kumokiso you tolokaino nokota mo aumoifaso na samukukomoinuwomo.” ");
INSERT INTO amm_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Nosai no mo; Kalili iwo toku ilo kwa kwaso manaloki. Isiso mo noko ti auwatonowoiso na koka tumoki. Saimo, siyolo siya mo Pita, tani auwatono Anotoluwoi, totiso koka tumoki. La imo kuo tolokino, iwoso, la i nokota ti nali. ");
INSERT INTO amm_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Na ikoki, Isiso mo, “Yoso na paluwaimonowo. Ya amai wiyononinoikuwomo, noko kolisalo mano mi mo.” ");
INSERT INTO amm_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ikoki mo; somaiso la imo utukaikokino, na aluwaikino, Isisoso. ");
INSERT INTO amm_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Manoki manoki mo; noko ti auwatonowoi siyaiso na koka tumoki, Sipitini alalo ti, Yamisowoi auwatono Iyonowoi. Ayouso piyousikino, apitonowoi. La imo topoliko siki. Totiso mani, na aliyonikalomanoki, “Na pa aluwaimonowo.” ");
INSERT INTO amm_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Somaiso toti mo apitono mo utukaimokino, ayouso. Isisoso na aluwaikino. ");
INSERT INTO amm_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nosai no mo; Isiso mo Kalili asi komaso asiso liyaiyalo manoki. Totaini lotu nu lolofa poiso lukasikalo manoki, imo itouniyaimo mo. Na ikaloki, “Koto mo samukukomoinuwomo.” Aino ikaloki. Ai ai noko nokolalo molopoi ititounikaiyalo manoki, hani hani uwoko noko mo. ");
INSERT INTO amm_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Wiyou, tota monoi aino imo mo maliyaliyaloki, Siliya asi komasoso. No monoi no hani hani aiyo uwokaikokai noko kiyokoma tumo liyaikino. Iyanoko uwoko nokowoi popuwayo uwokaikokai nokowoi kalalotiko si nokowoi au nomoli nomoli nokowoi, toi mo Isisoso na kiyokoma tumo liyaikino, na ititounikaiki. ");
INSERT INTO amm_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Noko nokolalo molopoi aluwaiyalokino. Kalili asi nokowoi Tikapoli asi nokowoi Yolusolimo nokonu nokowoi Yutiya asi nokowoi Yotano iwo ausaimi asi nokowoi, toi komaso mo Isisoso aluwaiyalokino. ");
INSERT INTO amm_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Isisoyo nonani noko nokolalo molopoi nokoso kwaikoki mo, yuso na amiyoki, yousikaina yoki. Siyokutono iyaliwoi noko nokolalowoi na kiya yokino. ");
INSERT INTO amm_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Nosai no aiyolokoki. Isiso mo na aiyolokoki, noino na ikoki, ");
INSERT INTO amm_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Noko no tosainono no, totai amu mo Kotoni molo timai mo waliyo pa tosiso, nonani noko toi mo na molokiwumo. Kumokiso you tolokaino nokota na tosamukukomoi. ");
INSERT INTO amm_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mulu kolikali si noko mani, na molokiwumo. Kotoyo mo na hamukukoimo. ");
INSERT INTO amm_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Kukamokokai somiso noko mani, na molokiwumo. Kotoyo noinomo toi mo noko sisiyoli na soimo, asi asi komaso mo toini nasu wosuwoimai soimo. ");
INSERT INTO amm_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Noko mo molo itouniyaimoso aluwai monoi yakinomo, na molokiwumo. Wiyou, molo itouniyaimoso aluwai mulu mo siyoli, koloni no tiya mulu siyoli komiyai, iwo siko nukuwa mulu siyoli komiyai. Molo itouniyaimoso aluwai mulu siyoli monoi aino yakinomo, Kotoni amiyo mulu ititouni saso soimo. ");
INSERT INTO amm_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Noko mulu uku noko mo na molokiwumo. Ulai afonimaiso? Nokoso tofasiko manono. No monoi no Koto mo mulu ukoimo, suomoso monoiso na fasikoimo. ");
INSERT INTO amm_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mulu wofu wofu noko mani, na molokiwumo. Kotoni auso na kiya yoinomo. ");
INSERT INTO amm_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Uo tukoluwano noko alukiko noko, toi mo na molokiwumo. Kotoyo mo na kolaloimo, “Yani alalo na.” ");
INSERT INTO amm_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Molo itouniyaimoso aluwai noko, toiso uo nokoyo uwokakinomo, na molokiwumo. Kumokiso you tolokaino nokota mo na tosamukukomoi. ");
INSERT INTO amm_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Asaso aluwaimonomoi noko moi mo na pa molokiwo. Aluwaimono foli monoi nokoyo alisiyoli komoinuwomo, uo nokoyo uwokomoinuwomo, topoko imo kali kalimikomoinuwomo. ");
INSERT INTO amm_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Toku nu liyai noko mani, uo nokoyo puwoko manokino, Kotoni mulu lukasiko nokoso. Na pa moloki si manowo. Ulukukumoso na pa si manowo. Kumokiso suo foli mo siyoli.” Isiso mo aino na ikoki, noko nokolaloso. ");
INSERT INTO amm_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Nosai no mo; ti monoi noino na ikoki, siyokawi imo mo, “Mamoyo nofuwa nokoso uluwaulakimo, usutono soimo. Noinoso moi mo mamo ititouni komiyai, na pa si fasikowo, asi asi noko nokolalowoi. Si fasikakinuwomo, moiyo molo itouniyaimo aluwaiso kiyoinuwomo, molo koiyauso na utukaimoinomo. Ulai mamo koiyaumakimo, usutono no moloi tano monoi? Usutonowoi muwoi. Ulai ti monoi no moloi yo monoi, woi, usutono tano monoi no? Nonani mamo mo uo somiso mo, nokoyo tafoli taikiyono, fonayo tofolulu manono. ");
INSERT INTO amm_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Moi mo saponi komiyai, asiso na tofupiniyaimo kolo sinuwo. Moloi woi? Nokonu mo, yuso no you tanokaino no, nonani monoi no sosoli no moloi si monoi, noko no? Noinoso Kotoso mulumolo luwai noko monoi mani, nokoyo no sosoli no moloi si monoi? ");
INSERT INTO amm_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Noko mo lamu ta falosisakimo, nauyo no moloi ufiyaiso monoi? Wiyouwa wiyou. Puwoso na tafonikokaisomoi. Nu poiso si noko mo tofupiniyaimo kolokomoi. ");
INSERT INTO amm_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Noinoso na, noko nokolaloni molo timai mo saponi komiyai na fupiniyaimo siwo. No monoi no nokoyo molo itouniyaimo aluwaiso kwaiyoinuwomo, momaini Apononi siyolo na kaluwaiyoinomo, kumokiso ni you tolo no.” Isiso mo aino na ikoki, noko nokolaloso. ");
INSERT INTO amm_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Nosai no mo; noino na ikoki, Isiso mo, “Moi mo piyamonuwo, yo mo tokumi imoso tokosiyaika tumowo, Musini ami imowoi Kotoni mulu lukasiko nokoni imowoiso. Wiyou, aino muwoi. Yo mo toini imo folosai mo na toposasoko wiyononina tumonukuwo. ");
INSERT INTO amm_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Yo mo motuwa na timonukuwo. Kumokiwoi asiwoi amai tanokainomai Musini imo komaso mani, amai na tosi, komaso na. Toku no kulukaiki no, noinoso na tosimoi, ainoso hani kumokiwoi asiwoi uwaimo taikiyoimo. ");
INSERT INTO amm_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Noko mo Musini imo amiso kulaliyakimo, kumokiso you tolokaino nokotayo samukukomomaiso mo afonimai nokota na toloimo, Kotoni molo timai mo. Nasu, imo koufasofa mani, kulaliyakimo, afonimai nokota toloimo. Noko siyaiwoiso imo kulali monoi wiyolukakimo, noko siyoli no moloi tolo monoi? Nokoyosu mo Musini imoso aluwaiyakimo, noko nokolaloso aluwai monoi aiyolokakimo, to mo noko siyoli na toloimo, samukukomomaiso mo. ");
INSERT INTO amm_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ya timonukuwo. Musini imo sai sisiyoli nokowoi Falisi moloso aluwai nokowoi, toi monoi mo noko nokolaloyo piyamo, noko ititouni nokowo. Ulai Kotosu mo toini mulu mo sai, pa tomulumolo luwainoso. Moi mo toini muluso aluwaikakinuwomo, kumokiso you tolokaino nokotayo mo pakoso samukukomoinuwoso.” Noko nokolaloso aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Nosai no mo; ti monoi na ikoki, “Moi mo yasoi kwaikinuwo, nonani imo mo aniyopano iyaliyo toku no kwaikino no, noino, “Noko mo noiyo tukoloi. Nokoso tukolakimo, noko tukolo foli monoi mo na uwoyoimo.” ");
INSERT INTO amm_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ulai ya timonukuwo, noko mo siyokutonoso uo imo imakimo, uo imo foli monoi mo na uwoyoimo. Wolitonoso kaloni imo imakimo, ainonani foli monoi nokotalo iyaliyo imo lukasokaiyoinomo. Nokoyosu mo imakimo, “Nono mo mulu somiso nokota koiyau wai,” to mo tani moloso na manoimo. ");
INSERT INTO amm_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","No monoi no mo, Kotoso hani anoninakinimo, toku mo siyokunowoi uo imo monoi pa hamukukuwanowo, momati amu mo. Hamukukuwano uwai; ifou na pa tumo, Kotoni hani pa ana tumo, toku no akaikaini no. Kotoso na pa anoni, pa molokimo. ");
INSERT INTO amm_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Nokoyo nonoso uo imo lukaso ni monoi kauwakinimo, imo kwai nokota siyolini auso, toku mo momati amu mo na pa hamukukuwanowo, nonani uo imo monoi. Molomai pa hamukukuwanowo, nokotaloni auso monoi mano monoi mo. Wonikaluso tani auso aiko kiyoini. Nosai no totayo polimano nokoni nainoso aiko kiyoini, kalopulo nuso aiko kiyoini. ");
INSERT INTO amm_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Motuwa na timonoki, kalopulo nusai somaiso pa amufoiniso. Na yousikaino manoinimo, ainoso hani molo koiyau foli imo mo futo.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Nosai no mo; noko nokolaloso na ikoki, Isiso mo, “Moi mo yasoi kwaikinuwo, toku no iyamoki no, “Noko kwami nukonu mo noiyo uwokaisoi.” ");
INSERT INTO amm_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ulai ya timonukuwo, noko mo noni siyaso mulu usakimo, nonani nokota mo uloliyo nokota na, noni siyaso mulu uso totolo, no monoi no. ");
INSERT INTO amm_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Naina ausaimi moloyo molo koiyauso kalumaniyakinimo, na pa solifoli taikiyo, molo mo. Wonikaluso taso aiko afoliyoini. Nonani molo solifoliyakinimo, waliyo, molo koiyauso pa aluwaiyoiniso, taso pa afoli taikiyoiniso. ");
INSERT INTO amm_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Nainayo molo koiyauso kalumaniyakinimo, na pa kokolofoliko taikiyo, naina mo. Wonikaluso taso aiko afoliyoini. Nonani nainaso kokolofolikakinimo, waliyo, molo koiyauso pa aluwaiyoiniso, pa afoli taikiyoiniso, taso mo.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Nosai no mo; ti monoi na ikoki, “Toku mo nokoyo noino iyamoki, “Noni afolikaiso mo waliyo. Noko mo noniso afolikaisakimo, pasosu kumotisumo, afolikaiso monoi mo. No monoi nosu sauwoso tolosumo.” ");
INSERT INTO amm_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ulai ya timonukuwo, noko mo uloliyo somiso nukonuso afolikaisakimo, to mo noniso na koiyausoimo. Nonani nukonuso noko siyayo kausakimo, toti mo uloliyo moloso na taluwaino.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Nosai no mo; na ikoki, Isiso mo, “Imo siya mani, yapoli kwaikinuwo, aniyopano iyaliyo no ikokino no, noino, “Nono mo noiyo topokoi. Noko Siyolini siyoloso kaluwaiyakinimo, noiyo topokoi, na pa aluwai, nonani imo no auwolakini no.” ");
INSERT INTO amm_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ulai ya timonukuwo, noiyo auwolokaloiwo. Kumokini siyoloso no hani monoi kaluwai monoi? Wiyouwa. Kumokisu mo Koto mo tiyou yousikaino. ");
INSERT INTO amm_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Asini siyoloso mani, noiyo kaluwaiyalo manoiwo. Ulai afonimaiso? Kotoni fona wosuwoimai toi, asi mo. Yolusolimo nokonu siyoloso mani, noiyo kaluwai manoiwo. Ulai afonimaiso? Yolusolimo mo samukukomo nokota siyolini nokonu. ");
INSERT INTO amm_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Nona amu monoi mani, noiyo auwoloi. Ulai afonimaiso? Ulai nono no amiwoi? Soliso komu suwo no ulai nonani amiyo no moloi alosimo monoi, mafomuso no? Mafomuso komu suwo mani, ulai moloi alosimo monoi, soliso no? ");
INSERT INTO amm_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Motu monoiso iyamakinuwomo, motu monoiso na pa iyamowo. Noiyo topokoiwo. Wiyou monoiso iyamakinuwomo, wiyou na pa iyamowo. Noiyo topokoiwo. Hani hanini siyolo siyoloso noiyo kolalaloiwo. No mo Sokolo Nokota Waiyosu na towiyolukomo manonuwo.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Nosai no mo; Isiso mo ti monoi na ikoki, noko nokolaloso, “Moi mo yasoi kwaikinuwo, toku no iyamoki no, “Nokoyo moloso toluniyakinimo, suo mani, tani molo mo na pako toluni. Nokoyo iso tofiyaimakinimo, suo mani, tani i na pako tofiyaimo.” ");
INSERT INTO amm_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ulai ya timonukuwo, nokoyo uwokomakinuwomo, suowoi noiyo uwokoiwo. Nokoyo umosai ifasiyaimakinimo, umo siyaiwoi na pako alosimo. ");
INSERT INTO amm_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nokoyo uo imo imakinimo, nani pau tuno anowai monoi, atoli tuno siya mani, na pako anoni. ");
INSERT INTO amm_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Nokoyo ilolu ilomanononi monoi totami yoluwaiyakinimo, aumoifaso kiyokononi monoi, aluwamai mani, waliyo na pako kiyokononinano. ");
INSERT INTO amm_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nokoyo hani anoni monoi utolumakinimo, wiyou imo mo noiyo imoi, waliyo na pako anoni. Nokoyo awaso anoni monoi imakinimo, wiyou imo mo noiyo imoi, waliyo na pako anoni.” Aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Nosai no mo; na ikoki, Isiso mo, “Moi mo yasoi na kwaikinuwo, toku no iyamoki no, “Siyokuno iyaliso mulu na pa uku, uo nokoso mulu na pa atolokomo uku.” ");
INSERT INTO amm_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ulai ya timonukuwo, uo nokoso mulu na pa ukuwo. Uo uwokomo noko monoi Kotoso na pa utolumo ukuwo, totayo fasiko monoi mo. ");
INSERT INTO amm_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","No monoi no Apono Siyolini alalo soinuwomo, kumokiso ni you tolo no. Totayo noinomo ulo mo noko komaso nokoso towi kolokomoi, noko kopokoiyau nokowoi noko ititouni nokowoiso. Sa mani, tamukonomoi, molo itouniyaimoso aluwai nokowoi molo koiyauso aluwai nokowoiso tokuno kolokomoi. ");
INSERT INTO amm_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Noko, toiyo no tomulu unu manonuwo no, toisoso mulu ukakinuwomo, Kotoyo no moloi uwokomo itouniyaimo monoi, siyokuno iyali mulu uku foli monoi no? No mo siyoli hani muwoi. Molo koiyauso aluwai noko mani, ainoso mulu tuku manono, totaini siyokutono iyali monoi. Moi uo noko, toi mani, na pa mulu uku manowo, no monoi no Koto mo itouniyaimoso uwokomoinuwomo, suo foli monoi mo. ");
INSERT INTO amm_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Siyokuno iyalisoso woli iyali kolalakinuwomo, no mo siyoli hani muwoi. Mulumolo luwai somiso noko mani, ainoso tokolalalo manono. Moi uo noko mani, woli iyali na pokolali manowo. ");
INSERT INTO amm_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Moini Apono kumokiso ni you tolo no, to mo itouniyaima itouniyaimo nali no. Moi mani, totani mulu komiyai na pako si manowo.” Isiso mo aino na ikoki, noko nokolaloso mo. ");
INSERT INTO amm_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Nosai no mo; ti monoi na ikoki, Isiso mo, “Moiyo atiyaiso. Afonimai nokoso fasikakinuwomo, noko nokolaloni molo timai mo noiyo fasikaloiwo. No mo noko sisiyoli si mulu saso. Noko nokolaloni molo timai fasikakinuwomo, moini Apono kumokiso ni you tolo no, to mo pa molokikomoinuwoso, suo foli monoi mo pa fasikomoinuwoso. Wosu woso fasikalo mo waliyo. ");
INSERT INTO amm_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Topoko nokoyo mo noko tikauko manono. Ikauko manono mo; noko nokolaloni molo timai mo tofasikalo manono, ilolu somiso nokoso. Ainoso tiyo manono, lotu nufa poiwoiso molo kwamaiwoi. Asuwo noko nokolaloni molo timai noko sisiyoli si mulu saso. Motuwa na timonukuwo. Noko nokolaloyo na tomolokiko manono, Kotosu mo pa molokikoiso, suo foli monoi mo pa fasikoiso. Topoko nokoni moloso noiyo aluwaikoiwo. ");
INSERT INTO amm_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ilolu somiso nokoso fasikakinuwomo, wosu woso na pa fasikowo. Wonikaluso noko nokolaloyo aiko kwaikomoinuwo. ");
INSERT INTO amm_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","No monoi no wosu woso pa fasikowo. Apono mo wosu woso fasiko monoi mo sai, na molokikomoinuwomo, suo foli monoi mo na fasikomoinuwomo.” Aino ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Nosai no mo; Isiso mo noko nokolaloso ti monoi na ikoki, “Topoko nokoyo Kotowoi imo tolukaso ni si liyaimoi, noko nokolaloni molo timai, lotu nufa poiwoiso molo touwokonimaiwoi. Noko sisiyoli si mulu saso, toi mo, no monoi no. Ulai ya motuwa na timonukuwo, noko nokolaloyo na tomolokiko manono, Kotosu mo pa molokikoiso, suo foli monoi mo pa fasikoiso. Topoko nokoni moloso noiyo aluwaikoiwo. ");
INSERT INTO amm_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nono mo noko siyoli tolo mulu noiyo yoi. Kotowoi imo lukaso niyakinimo, ulololi si nu poiso na pa asikaiyo ti. Nokoyo ki somiso nokotaso na pa lukaso ni, nani Aponoso. To mo sai, nonani mulu monoi mo, na molokimoinimo, suo foli monoi mo na fasiyoinimo. ");
INSERT INTO amm_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Kotowoi imo lukaso niyakinuwomo, afonimaiso imo isoiso noiyo lukasoiwo, mulumolo luwai somiso noko komiyai. Na tiyamo, “Imo isoiyaso imakikonimo, Kotoyo mo na fasimokoimo.” ");
INSERT INTO amm_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Toini moloso noiyo aluwaikoiwo. Hani hani uwofa sinuwo mo, Apono mo sai. Imo lukaso ni somisomai to mo sai. No monoi no afonimaiso imo isoiyaso noiyo lukaso niyoiwo. ");
INSERT INTO amm_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Noino na pa lukaso ni manowo, Kotowoi, “Koini Apou, kumokiso tiyou yousini. Nono mo itouniyaima itouniyaimo nokota. Nani siyolo mo na tokaluwaiyalounoki. ");
INSERT INTO amm_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Na posamukumoka tumo. Asi si noko koi mo nani mulusoso aluwai mulu monoi na tiyonoki, kumoki nokoyo komiyai no taluwai manoni no, kumokiso. ");
INSERT INTO amm_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ulo siyamai koloni saiso saiso na pa nimokomoi. ");
INSERT INTO amm_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Nokoyo kopokoiyau komomokakinomo, koi mo imowoi muwoi, waliyo. Nono mani, kokaini molo kopokoiyau monoi imo mo na pa tokosokiko. ");
INSERT INTO amm_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Sokolo Nokota Wai monoi na pa samukumokomoi, aiko ainikomomoko ifoluwaimokoi. Nonosu mo aniyopa poi poi tosamukumoko manoni, amiso na totolokaino manoni, Siyoli Nokota nali no, aniyopa poi poi. Motu nali no.” ");
INSERT INTO amm_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Na pukwaimonowo. Kopokoiyaukomo foli monoi mo nokoso iko somiso mo, moini Apono, kumokiso ni you tolokaino no, to mo moini molo kopokoiyau monoi mani, imo mo futo. ");
INSERT INTO amm_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ulai moi mo imo tokosokiko somiso mo, moini Apono mani, moini molo koiyau foli monoi imo mo futo muwoi, amai.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Nosai no mo; na ikoki, Isiso mo, “Topoko noko iyali mo koloni au au tiyo manono, Kotowoi lukaso ni monoi. Ulai amuwaso tosimoi, noko nokolaloyo kwaiko monoi, koloni au au na tosiwo, Kotowoi tolukaso niwo. No mo noko sisiyoli si monoi tiyo manono. Motuwa na timonukuwo. Noko nokolaloyo na tomolokiko manono, Kotosu mo pa molokikoiso, suo foli monoi mo pa fasikoiso. Topoko nokoni moloso noiyo aluwaikoiwo. ");
INSERT INTO amm_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ulai nono mo koloni au mulu yakinimo, Kotowoi lukaso ni monoi mo, amuwaso noiyo, amu moloso na pako uluwa, kou woti iwoyo komu suwoso na pa louwoko. ");
INSERT INTO amm_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","No monoi no noko nokolalo no moloi saino monoi, koloni au totoloniwo? Nokoyo ki somiso nokota saso mo sai, nani Apono mo. To mo sai, nani mulu monoi mo, na molokimoinimo, suo foli monoi mo na fasiyoinimo.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Nosai no mo; Isiso mo noko nokolaloso ti monoi ikoki, “Asini hani hani ilolu i mulu monoiso mo noiyo yoiwo. No mo alopu sosomu kopokoiyauyo no sosomuwakokai, toliki toliki na si. Siyai mo polamoko nokoyo wosu woso tiwaimoko manono. ");
INSERT INTO amm_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kumokini hani hani ititounisoso na pa iwo. No mo tolikikowoi muwoi, alopu sosomuyo no sosomuwakowoi ilolu muwoi. Polamoko nokoyo polamokowoi muwoi. ");
INSERT INTO amm_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Nokoyo ilolu mo nuso isikokai mo, to mo nonani nuso mano mulu saso. Kumokiso isikokai mo, kumokiso amiyo mulu saso.” Siyokawi imo mo aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Nosai no mo na ikoki, “Nokoni molo ti mo lamu ta komiyai towi kolo, tani au poiso. Molo ti mo itouniyaimoso tanakinomo, mulu mani, saponiwoi na tanoimo. ");
INSERT INTO amm_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ulai molo ti koiyauso tanakinomo, mulu mani, folosu na tanoimo. Nonani folosumono mo soliyakiso na tanoimo, mulu mo fupiniyaimo kolo somiso mo.” Aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Nosai no mo; ti monoi na ikoki, “Ulai mi nokota no noko sisiyoli tini mi tiwoi no moloi ano monoi? Aino yakimo, siya monoi mo mulu atolokomo unoimo, siya monoisu mo mulu unoimo. Kotoso aluwaiyakinuwomo, asini hani no moloi aluwai monoi, moi no?” Noko nokolaloso aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Nosai no mo; na ikoki, Isiso mo, “No monoi no ya timonukuwo. Mulu mo noiyo kolikalikaiyoiwo, momaini si monoi mo. Noiyo iyamoiwo, “Moi no haniso tonokoni, woi? Haniso tosikokoni, woi?” Ulai mulu noiyo kolikaliyoiwo, momaini au monoi mo. Noiyo iyamoiwo, “Moi no tuno no haniso asisiko monoi, woi?” Ulai sinono no koloni saso? Au no ulai kouwo saso? ");
INSERT INTO amm_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Uo, puwoso no tofufoimuwano manono no, toi monoi na pomulumoloko ukuwo. Uo mo aliyoli ali pa tikai manonoso, isini aliyoli pa ti manonoso. Koloni isikokai nu mo uwofa. Ulai kumokiso you tolokaino nokota, moini Apono mo, tosu mo na tonikomoi, koloni mo. Noko nokolalo moi mo uoso na tosouwaiko manonuwo. No monoi no moi mani, Kotoyo na tosamukukomo manonuwo. Mulu mo noiyo kolikalikaiyoiwo. ");
INSERT INTO amm_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Kalo monoi mulu kalo mo, moi nokota siya no ulai ti monoi no alu komiyai no moloi wiyono monoi? ");
INSERT INTO amm_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Moi no hani monoi mulu tokolikali manonuwo, tuno kou mulu monoiso no? A uso na pomulumolokowo. Afonimaiso na tofofoliko manono. Toini mi anosai muwoi, afonimaiso nali. ");
INSERT INTO amm_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ulai ya timonukuwo. Solomono mani, kou ititouni nokota toku no toloki no, ulai tani kou mo a uni kou komiyai muwoi. Wiyou, a uyo souwaikino. ");
INSERT INTO amm_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Motu na, sosono mo konoi monoiso kiso totoloko. Amuwoi mo isiko utoinomo, taso. Nonani sosonoso Kotoyo tokouwokokaimoi. Moisu mo sosonoso na tosouwaiko manonuwo. No monoi no mo Koto mo na tosamukukomo manonuwo. Moini mulumolo luwai mulu no, a, koufasu, woi? ");
INSERT INTO amm_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Mulu mo noiyo kolikalikaiyoiwo. Noiyo mulumoloko manoiwo, “Moi no konoi no haniso tonokoni, woi? Iwo mani, haniso tosikokoni, woi? Tuno no haniso tasisikokoni, woi?” Ainoso muwoi. ");
INSERT INTO amm_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Mulumolo luwai somiso nokoyo ilolu mulu monoisu tiyo manono. Moini Apono kumokiso ni you tolokaino no, to mo sai, afonimaiso sakinuwomo, no monoi no fasikomoinuwomo. ");
INSERT INTO amm_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Hani hani ilolu mulu noiyo yoiwo. Kotoyo samukukomo mulu monoi saso na pa yo manowo, tani molo itouniyaimoso aluwai mulu monoi mo. Ainoso yakinuwomo, hani hani mani, nikomoinuwomo. ");
INSERT INTO amm_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","No monoi no mo amuwoi monoi mo mulu noiyo kolikaliyoiwo. Amuwoi monoi mo amuwoi monoi. Konoi monoisu na pomulumolokowo.” Isiso mo aino na ikoki, noko nokolaloso mo. ");
INSERT INTO amm_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Nosai no mo; Isiso mo ti monoi na ikoki, “Noko siyai monoi noiyo lukaso ukoiwo, “Kopokoiyauwo.” Wonikaluso momaini molo kopokoiyau foli monoi mani, Kotoyo yomukaiyoimo. ");
INSERT INTO amm_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Molo koiyau aluwai foli monoi imo lukaso ukakinuwomo, Kotoyo mani, yomu unoinuwomo. Uo imo lukaso ukakinuwomo, Kotoyo mani, uo imo yomu unoinuwomo. Koufaso lukaso ukakinuwomo, Kotoyo mani, koufaso yomu unoinuwomo. ");
INSERT INTO amm_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Noko siya monoi noiyo iyamoiwo, molo koiyau aluwai foli monoi mo. No mo molo kukumo koufa komiyaisu. Ulai nono mani, molo koiyauso yapoli na taluwai manoni, molo kukumo soliyaki komiyai tanokaino, a soliyaki topi. ");
INSERT INTO amm_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Hani monoi siyokunoso timoni, “Woli, yo mo kukumo koufa tafoliwainoki, nani moloso.” Ulai nono mani, a pokamono siyoli pa tokiniso, nani molo tiso. ");
INSERT INTO amm_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Nono mo imo topoko nokota nali, nona amu monoi tiyomuni, noko itouniyaimowo. Molo koiyauso aluwai nokota na, nono mo. A pokamono siyoli nani molo tiso no tanokaino no, no mo na pafoli taikiyo, toku mo. Namolimai mo waliyo foinalikoinimo, siyokunoni molo kukumo pa afoliwai. ");
INSERT INTO amm_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Kotoni imo kulalikai nokoso noiyo aiyolokoiwo. Aiyolokakinuwomo, aluwouyo noko tukuwoli komiyai uwokaikomoinuwomo. Kotoso namoliyo alosimokai nokoso mani, noiyo aiyolokoiwo. Aiyolokakinuwomo, no mo fuso kouwoko komiyai. Kou ititouniyo no fu no moloi kouwoko monoi? Kou mo totowitolokono, na tuwokaikono, asi topamu saso tosi. No monoi no imo kulali nokoso mo noiyo aiyolokoiwo.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ulai ikoki, Isiso mo, “Kotoso na pa utolumo manowo, no monoi no nikomoinuwomo. Na pa ikolikalowo, no monoi no kokoinuwomo. Itu lotiso pa ukou ukou nimo manowo, no monoi no itu na kolali unoinuwomo, Kotoyo, moini imo kwaimoinuwomo. ");
INSERT INTO amm_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Noko mo Kotoso haninoi monoi utolumo manakimo, nonani hani na aninoimo. Nokoyo haniso ikoliyalakimo, na kiyoimo. Nokoyo itu lotiso ukou ukou nimo manakimo, itu na kolali unoimo, imo kwaimoimo. ");
INSERT INTO amm_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Apitono iyali moi ni tosinuwo no, moi mo na pukwaimonowo. Aluyo apitonoso imo mo, “Tiya tokalomono, tuo pamono.” Ulai apitonoyo no tomokiso no moloi anoni monoi, aluso no? Wiyou nali. ");
INSERT INTO amm_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ti monoi timo, apitonoso, “Tiya tokalomono, la pasomono.” Ulai momai koiyau no moloi anoni monoi, apitonoyo no, aluso no? Wiyou nali. ");
INSERT INTO amm_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ulai mulu kopokoiyau noko moi mo, itouniyaimo hani suomoso monoiso toniko manonuwo, momaini alaloso. No monoi no moi mo sai, moini Apono mani, kumokiso ni you tolo no, to mo hani hani ititouni na tonikomo manonuwo, totaso utolumo manakinuwomo. ");
INSERT INTO amm_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Moi mo nokoyo fasikomo mulu monoi tiyo manonuwo. No monoi no nokoso pa fasiko mano liyaiwo. Ni mo Musini ami imo folosaiwoi Kotoni mulu lukasiko nokoni imo folosaiwoi.” Aino ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Ti monoi na ikoki, “Noko uwokaiko molo mo tofu siyoli. Noko nokolalo molopoi mo nonani moloso taluwaiyalo manono. Itu loti mani, soliyaki na. Momaisu mo itu loti mumukufaso na potiwo. Aniyopa poi poi sinono molo mo mumukufa, siyoli muwoi. Noko molopoi tokiyali manono. Siyasonuso tonumoi.” Aino ikoki. ");
INSERT INTO amm_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Nosai no mo; ti monoi na ikoki, Isiso mo, “Atiyaiso, imo topoko noko monoi. Tima tumo liyai manonuwo, “Koi mo Kotoni muluyosu imo na tolukasiya tumonukuwo.” No monoi no moi siyaiyo iyamoinuwomo, noko ititouniwo, sipo koloni komiyaiwo, uowoi muwoi. Ulai toini mulu poiso mo uo mulu mo yapoli na, asikoiyo aluwou komiyai. ");
INSERT INTO amm_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Totaini moloso atiyaiso na pa kwaiko kiwo. Molo itouniyaimoso poi taluwaino. Moloi woi? Ulai molosu aso no si wamo no moloi si monoi? Sosiwoi sosono mo sipoki wamo ititouni mo pa tosimoiso. ");
INSERT INTO amm_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Noinoso nali, a koiyau mo a wamo kopokoiyau na tosimoi. A ititouni mo a wamo ititouni na tosimoi. ");
INSERT INTO amm_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","A koiyau no a wamo ititouni no moloi si monoi? A itouniyaimo no a wamo kopokoiyau no moloi si monoi? ");
INSERT INTO amm_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","A mo a wamo si somiso mo, iko taikiyoimo, taso na utoimo. ");
INSERT INTO amm_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Noinoso nali, imo topoko nokoni moloso atiyaiso na pa kwaiko kiwo. Molo itouniyaimoso poi taluwaino, molo koiyauso poi taluwaino. ");
INSERT INTO amm_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Noko nokolalo molopoi mo tokaluwaimono manono, “Koini Siyoli Nokota, koini Siyoli Nokota.” Ulai siyaisoso samukukoimo, kumokiso you tolokaino nokotayo mo. Siyai mo afonimaiso tokaluwaimono manono. Siyaisu mo yani Apou, kumokiso ni you tolo no, tani mulusoso taluwai manono. Toisoso na samukukoimo, to mo. ");
INSERT INTO amm_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Asi fokumomai mo noko nokolalo molopoi mo imonoinomo, “Koini Siyoli Nokota, koini Siyoli Nokota, koi mo nani imo na posasoko manokinoki, nani amiyo mo. Nani amimai koi mo popuwa na pamiyaikiyokalo manokinoki. Mulu ifolaluwawoi miwoi pano manokinoki, nonani amiyo.” ");
INSERT INTO amm_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nomai no mo; siyoliso na ikoimo, “Yo mo moi monoi mo sai muwoi. Imo kulali noko, moi mo. Soi suwo, na ponuwo.” Aino ikoki. ");
INSERT INTO amm_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Isiso mo ulai ikoki, “Yani imo ni tolukasinukuwo no, nonani imoso kwai itouniyaimakimo, nokoyo, to mo muluwoi na. Tomokimai nu ko nokota komiyai. ");
INSERT INTO amm_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Sa mo tamukono, iwo usoiyo siyoli totumo, imonu siyoliwoi. Iwo miyo nu louwa tusainiyaikiyo fu. Ulai pa takokonoso. Tomokimaiso na toloki, amiso, no monoi no nu mo akokonowoi muwoi. ");
INSERT INTO amm_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ulai yani imo mo iyoyoso kwaimonokaiyakimo, to mo muluwoi muwoi, upoimai nu ko nokota komiyai. ");
INSERT INTO amm_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Sa mo tamukono, iwo usoiyo siyoli totumo, imonu siyoliwoi. Nu mo iwo miyo tusainiyaikiyo fu, na takokono. Na totokolitoloko.” Aino ikoki, Isiso mo, siyokawi imo mo. ");
INSERT INTO amm_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Nonani imo iko uwai; ukouniyaiko noko nokolalo kufaukoki, totayo aiyoloko monoi. ");
INSERT INTO amm_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Moloi monoi woi? Musini imo sai sisiyoli noko komiyai aiyolokowoi muwoi. Isiso mo mulu ifolaluwawoi nali no, no monoi no aiyoloko itouniyaimoki. ");
INSERT INTO amm_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Nosai no mo; Isiso mo yusai amukonoki. Wiyou, noko nokolalo molopoi aluwainiyo konokino. ");
INSERT INTO amm_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Amukonoki mo; uluoyo uwokaikai nokota mo na losiyaiko yousa tumoki, Isisoni aumai. Na imoki, “Noko Siyoli, yo no waliyo titouniyaimomononi?” ");
INSERT INTO amm_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Nosai no mo; Isiso mo nainoyo na akaikomoki, na imoki, “Yo mo waliyo na tiyomu, noko itouniyaimo na totoloni.” Imoki mo; lolai siyaso uluo mo na kokamokoki. ");
INSERT INTO amm_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Imo taikiyoki, Isisoyo mo, “Noinaninoi aino imo noiyo ikaloi. Nani au mo lotu samukuko nokotaso na powiyononinano. Kotoso pakononinano, nonani hani mo toku Musiyo no yomukaiki no. No monoi no noko mo sai, nani uluo mo kokamokokai, noko itouniyaimo na totoloni.” ");
INSERT INTO amm_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Nosai no mo; Isiso mo Kopanaumo nokonuso lotiki. Lotiki mo; polimano samukuko nokota siyoli, Lomo nokota nali no, to mo tumoki, na utoluma tumoki, ");
INSERT INTO amm_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Siyoli Nokota, yani mi anomono nokota mo ai tuwo, nuso amai tanokaino. Au mo nomoli nomolikomokai, naino fonawoi mani, yau yau nomolikokai, iyanoko siyoliwoi na.” ");
INSERT INTO amm_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Nosai no mo; Isisoyo na imoki, “Ya amai titouniyaimano.” ");
INSERT INTO amm_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ulai polimano samukuko nokota siyoliyo mo imoki, “Siyoli Nokota, yani nu poiso no nono no moloi loti monoi? Yo mo noko itouniyaimo muwoi. Imoyoso na piyomu, yani mi ano nokota mo waliyo na toloimo. ");
INSERT INTO amm_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Yo mani, noko siyani fiyo wosuwoimai totolo. Polimano noko siyai mo yapoli na si, asani fiyo wosuwoimai tosi. Yo mo siyaso imo mo, “Na pomoi,” to mo na tomoi. Noko siyaso imo mo, “Potumo,” to mo na totumo. Yani mi ano nokotaso imo mo, “Mi na pano,” to mo mi na tano. Noinoso nani imoyosu titouniyaimoni, yani mi anomono nokotaso mo.” ");
INSERT INTO amm_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Isiso mo tani imoso kwaimoki mo, na mulumoloko manoki, aluwai nokoso ikoki, “Ya motuwa na timonukuwo. Ninani nokota mo waliyo na tomulumolo luwaimono, siyoliso nali. Isolilo noko moi mo siyoliso pa tomulumolo luwaimononuwoso. ");
INSERT INTO amm_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ya timonukuwo. Noko nokonu noko molopoi mo yoso mulumolo luwaimonoinomo. Wiyou, molopoi nali, na ti liyaiyoimo, ulo amiyo asisaiwoi ulo amukono asisaiwoi. Na ti liyaiyoimo, yani samukuko nokonuso mo, kumokiso ni toi no. Apolofamo iyaliwoi no fasika tumoinomo, Isakowoi Yokopowoi. ");
INSERT INTO amm_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ulai Isolilo noko moi mo Kotoyo no louwa tosamukukomonuwo no, moisu mo amiyaikiyokomo taikiyoinuwomo, folosumono asiso monoi kiyokomo taikiyoinuwomo. Wiyou, sosonuno soinuwomo, i mo sisikomo soinuwomo.” Noko nokolaloso aino ikoki. ");
INSERT INTO amm_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nosai no mo; Isisoyo polimano samukuko nokota siyoliso na imoki, “Soi su, na pomoi. Yo mo na tiyo. Ulai afonimaiso? Yoso na tomulumolo luwaimononi.” No monoi no tani mi ano nokota mo lolai siyaso itouniyaimoso na toloki. ");
INSERT INTO amm_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Nosai no mo; Isiso mo Pitani nuso lotiki. Lotiki mo; Pitani amokitonoso kosoki, au momono ai tasoki. ");
INSERT INTO amm_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Nainosai na komisoki, ai mo futo. Na auwonisiyouki, koloni ta nononiki, Isiso monoi. ");
INSERT INTO amm_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Nosai no mo; upimoso popuwayo uwokokai noko nokolalo molopoi kiyokoma tumo liyaikino, Isisoni auso. Tani imo monoisu popuwa mo na uloloniyo fu liyaiki, nokoni au poisai. Ai ai noko mani, na ititounikaiki, ai ai noko komaso mo. ");
INSERT INTO amm_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","No mo afonimaiso muwoi, Kotoni imoyo motu fiyamosi monoi, tani mulu lukasiko nokota Aisaiyayo toku no kumokaiki no, noino, “Ai ai saloso uwomokoki, ai ai kopokoiyau mo. Yasoi na ilomanoki.” ");
INSERT INTO amm_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Wiyou, noko nokolalo mo molopoi, tani auso pukumo fiyaima tumokino. Isiso mo kwaikaloki, siyokutono iyaliso ikoki, “Soiwo, iwo ilo ausaimiso totikoni.” ");
INSERT INTO amm_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ikoki mo; Musini imo sai siyoli nokotayo ima tumoki, Isisoso, “Aiyolokomomoko nokota, ya taluwainoki. Isoni ausoni liyaiyalo manakinimo, yowoi foiya na aluwaiyalo manoikimo.” ");
INSERT INTO amm_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ulai na imoki, Isisoyo mo, “Asikoiyo aluwou mo asi i poiso tosi liyai. Asi i mo totaini nu na. Uo mani, niyou poiso tosi liyaimoi. Yosu mo nuwoi muwoi. Asi asi noko nokolaloni noko siyoli nokota, yo no nu haniso tano monoi? A, nono no waliyo taluwaimononi? Toku na pomulumoloko ki, waliyo poimo, wiyou poimo, aluwaimono monoi mo.” ");
INSERT INTO amm_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nosai no mo; siyokutono siyayo imoki, “Siyoli Nokota, nono no waliyo timononi, yo mo toku apou yau tai unano. Ai unu uwai, na aluwaiyoikimo.” ");
INSERT INTO amm_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ulai Isiso mo na imoki, “Tofolo, mulumolo luwaimono somiso nokoyo noko yau yau aiko ukanowumo. Nono mo yoso na paluwaimono.” ");
INSERT INTO amm_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nosai no mo; Isiso mo ayouso folamiyo konoki. Siyokutono iyali mani, na aluwaikino, ayou moloso. ");
INSERT INTO amm_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Alomakokino. Amai alomako manokino mo, wiyou, imonu siyoli mo na auwoniyouki. Iwo mi siyoli na tolauki, ayouso louwa komikoki. Ulai Isiso mo ulololi na tanokainoki. ");
INSERT INTO amm_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Na lusiyaikiyokino, imokino, “Oi, Noko Siyoli, na pofasimoko. Aumoifaso iwoyo totukuwoli solimoko.” ");
INSERT INTO amm_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ulai ikoki, Isiso mo, “Hani monoi tokokolokomonuwo? Hani monoi pa tomulumolo luwaimononuwoso?” Ikoki mo; na auwoniyouki, imonu siyoliwoi iwowoiso na ikauki, imo amiso, “Wosu woso.” Na tolosuwaki, imonu mo, iwo mi mani, futo. ");
INSERT INTO amm_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Mulumoloko manokino, siyokutono iyaliyo, totai amu lukasikuwanokino, “Hani nokota, woi? Imonuwoi iwowoi mo tani imoso na kwaimono.” ");
INSERT INTO amm_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nosai no mo; imonu mo uwai; Isiso iyali mo iwo toku ilo ausaimi fiyamosiyanokino, Kotalo nokoni asiso. Asi tolomu nokota ti mo Isisoso na kiya tumokino, popuwawoi nokota ti na. Noko yau yau aiko uku asisai tumokino. Totini uo mi mo siyoli, no monoi no noko nokolaloyo nonani molosai pakoso ponu manokiso. ");
INSERT INTO amm_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Popuwayo noinomo Isisoso siyoliso na ima tumokino, “Nono mo Kotoni alu. Hani monoi totumo unumokoni? Suo foli monoi imo mo amai, namolisai. Lolai no iyanoko no hani monoi tuwomoka tumoni?” Aino imokino, kwalu kwalu nokota ti mo. ");
INSERT INTO amm_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Aumoifa, aluwamai muwoi, aumoifa mo fu molopoi mo asi pono siki. ");
INSERT INTO amm_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","No monoi no popuwa iyali mo Isisoso imalokino, “Noko tini ausai amiyaikiyomokakinimo, funi au poiso na pako kwaiya kiyomoko taikiyo.” ");
INSERT INTO amm_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Nosai no mo; na iko taikiyoki, “Na ponuwo.” Iko taikiyoki mo; noko tini ausai mo na utukaikokino, funi au poiso na uloloniyo tiki. Tiki mo; fu komaso mo koli siyolisai fufumuwana konoki. Iwo toku iwoso usukunalo kono liyaiki, na tukuwoli soliki, yau yau. ");
INSERT INTO amm_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Nosai no mo; fu samukuko nokoyo uloloki, nokonuso uloloniyo tiki. Ainonani monoi imo lukasika tikino, popuwawoi nokota ti aino imo monoi. ");
INSERT INTO amm_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Lukasikokino mo; tolomu noko komaso noko mo Isisoso kiya tumokino, na ima tumokino, “Koini asisai mo na putukaimoko, na pomoi.” ");
INSERT INTO amm_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Nosai no mo; Isiso iyali mo ayouso ti monoi folamuwanoki, ifou nuki, iwo toku ilo ausaimiso, totayo yousimosiso. ");
INSERT INTO amm_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Nosai no mo; naino fona nomolikomokai nokota mo molo tokosimai sokuniyo tumokino. Isiso mo toini mulu poiso kokoki, totaso mulumolo luwaiso. No monoi no mo nomolikomokai nokotaso na imoki, “Woli, mulu noiyo kaloi. Yo mo imo mo futo, nani molo koiyau monoi imo mo.” ");
INSERT INTO amm_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ulai Musini imo sai sisiyoli noko siyai mo totaini muluyoso mulumolokokino, “Ninani nokota mo Kotoso talisiyoli, woi.” ");
INSERT INTO amm_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Toini mulu mo sai, na ikoki, Isiso mo, “Mulu koiyau mulu no hani monoi tomulumolokonuwo? ");
INSERT INTO amm_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Yo mo nokoso mulu koiyau afoliwai monoi imo mo, moiyo pimononuwo, “Topokoniwo.” Ulai ya imakimo, “Pauwoniyou, na poliyai,” nosai no moloi imono monoi topokoni? ");
INSERT INTO amm_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Asi asi noko nokolaloni noko siyoli nokota yo mo mulu ifolaluwawoi nali, mulu kopokoiyau saloso uwoko ami mo yapoli, yo mo. Ya towiyononinukuwo, moiyo saino monoi.” Ikoki mo; naino fona nomolikomokai nokotaso na imoki, “Na pauwoniyou, nani molo tokosi palomako, nuso na pomoi.” Aino na imoki, tani ami mo noko nokolaloso wiyoti monoi, mulu kopokoiyau saloso uwoko ami mo. ");
INSERT INTO amm_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Imoki mo; naino fona nomolikomokai nokota mo na auwoniyouki, nuso na manoki. ");
INSERT INTO amm_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Noko nokolaloyo nonaniso no kwaikino mo, na mulumoloko manokino. Kotoni siyoloso kaluwaiyaloukino. Ulai afonimaiso? Noka noko mo mulu ifolaluwawoi na tolo. ");
INSERT INTO amm_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nosai no mo; Isiso mo manoki manoki, takiso muwoni i nokotaso na kiya tumoki, takiso nuso yousikainoso. Tani siyolo mo Matiyu. Na imoki, “Kuku, yoso na paluwaimono.” Imoki mo; na amufuki, Isisoso na aluwaiki. ");
INSERT INTO amm_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Aluwai manoki mo, Matiyuni nuso koloni no sanoki. Takiso muwoni i noko kopokoiyau noko molopoiwoi molo koiyauso aluwai noko molopoiwoi, toi mani, no fasika tumokino, Isiso iyaliwoi. ");
INSERT INTO amm_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ulai Falisi moloso aluwai nokoyo no fasikoso kwaika tumokino, totani siyokutono iyaliso na ikokino, “Moini aiyolokomo nokota no hani monoi tono fasiko, takiso muwoni i noko kopokoiyauwoi molo koiyauso aluwai nokowoiso no?” ");
INSERT INTO amm_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Nosai no mo; Isiso mo nonani imoso kwaikoki mo, na yomuki, “Ai ai somiso noko mo tokotani auso pa tonumoiso. Wiyou. Ai ai noko saso na tonumoi, tani auso mo. ");
INSERT INTO amm_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Hani monoi pa tosainonuwoso? Kotoni pukoso na pa kokanowo. Noino na tiyomuko, “Yo mo koloniyo utumono monoi mo wiyou. Noko nokolaloso fasikonuwo mo waliyo. Mulu na pukuwo, suomoso monoiso na pa fasikanowo.” Motu na tiyomuko. Yo no noko ititouni nokoni mulu alosoko monoi tumo noiyo? Noko kopokoiyau nokoni mulu alosoko monoi na tumo.” Aino na yomuki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nosai no mo; Iyononi siyokutono iyali mo Isisoso kiya tumokino, na imokino, “Moloi monoi woi? Koiwoi Falisi moloso aluwai nokowoi, koi mo koloni au au na tosimosinoki. Ulai nani siyokuno iyali mo koloni au au pa tosimoiso.” ");
INSERT INTO amm_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Nosai no mo; Isiso mo na ikoki, “Toi mo mulu kolikaliwoi muwoi, no monoi no koloni au au pa tosiso. Toi mo noni kauso nokotani siyokutono iyali komiyai. Tolo fasikomaiso, nomai no koloni wasi popo na totoi. Mulu no moloi kolikali monoi? Ulai namolimai mo nonani nokota mo noko siyaiyo komi kausiyakinomo, siyokutono iyalini aumai mo uwofa toloimo, nomai no koloni au au na soimo, mulu na kolikaliyoinomo.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ti monoi na ikoki, “Tuno tonufuwaso no moloi tokosano monoi, tokumi tunoso moloi topolimo monoi? Aino piyo mo, nonani tuno tokosanofayo tokumi tuno mo popoliyaliyaiko taikiyo, i loluwa siyoli na potoi. ");
INSERT INTO amm_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ninoino mani, nokoyo pa tiyomoiso, molo wamo ito iwo tonofalo mo tokumi koloni tunomai soluki muwoi. Nokoyo ainonani piyo mo, molo wamo ito tonofalo mo tokumi tuno mo na popoliyaliyaikaiyo kono, asiso posolitolomo. Koloni tuno no mani, na popoliyaliyai taikiyo. Noko mo molo wamo ito iwo tonofalo mo koloni tuno tonofalomaiso na tuwolikomoi. Molo wamo ito iwo tonufuwa mo koloni tuno tonofalomai mo itouniyaimoso na totoi.” Aino ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Isiso mo nonani imo mo amai piko tolo manoki mo, nokotalo mo tani auso alokomu losiyaika tumoki, na imoki, “Yani alu mo lolai na kaloso, woi. Ulai nainoyosu na pokomisa tumo, waliyo na tolosoimo.” ");
INSERT INTO amm_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","No monoi no Isiso mo na aluwaiki. Siyokutono iyali mani, na aluwaikokino. ");
INSERT INTO amm_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Apitonoso louwa aluwaiki. Louwa aluwaiki mo; nosai no mo noni mo wosu woso tolosa tumoki, totani namolisai, nufaisoyo uwokaisokai nukonu mo. Aisamu mo molo tiwoi mo nonani aiyo puwosokai manoki. Totani namolisai wosu woso na tolosa tumoki, tani tuno soposai na komiki, tuno unusai. ");
INSERT INTO amm_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Totani muluyoso mulumolokoki, “Yo mo tani tunosai komiyakimo, waliyo na toloimo.” ");
INSERT INTO amm_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ulai namoli moloso monoi na kwaisoki, Isiso mo, na isoki, “Woli, mulu noiyo kaloi. Waliyo tomulumolo luwaimononi, no monoi no mo waliyo na totoloni.” Lolai siyaso nufaiso ai mo futo, waliyo na tolosoki. ");
INSERT INTO amm_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Nosai no mo; yasoi, alu kaloso nokotani nuso monoi. Nu mo komama tumokino, nokoyo louwo uwoko siso kwaikalo tumokino, sonukuso mo wiyou, siyoliso nali. ");
INSERT INTO amm_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Na ikoki, Isiso mo, “Fuwoi, na pokiyomonowo. Alu mo yau muwoi, ulololi totaso.” Ulai na soluwaikino. ");
INSERT INTO amm_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Noko nokolalo mo sofuwamo uwai; na lotiki, nu poiso. Alu yauni nainosai na komisoki, na auwonisiyouki. ");
INSERT INTO amm_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Alu yausai auwonisiyou aino imo maliyali liyaiki, nokonu nokonuso. ");
INSERT INTO amm_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Nosai no mo; Isiso mo nonani nokonuso utukaimoki, na manoki. Molo kau kau nokota ti mo na aluwaikino, siyoliso na imalokino, “Nono mo Toiwini nakosai, moini aniyopa siyolini nakosai. Koti na pomulu unumoko, na pofasimoko.” Aino imalokino. ");
INSERT INTO amm_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Imalo manokino mo, nu poiso lotiki, Isiso mo. Toti mani, na aluwainiyo tikino. Isiso mo na ikoki, “Moti mo yoso mulumolo luwaimonakinuwomo, waliyo na toloinuwomo. Motini mulu no yoso no yapoli tomulumolo luwaimononuwo?” Na fowakino, “Siyoli Nokota, nasu, na tomulumolo luwainoki.” ");
INSERT INTO amm_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Nosai no mo; totatini molo ti mo nainoyo na ufiyaikoki, na ikoki, “Na tomulumolo luwaimononuwo, no monoi no tuwokomo itouniyaimonukuwo.” ");
INSERT INTO amm_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ikoki mo; waliyo na foinalikokino. Na ikikoki, “Atiyaiso, nokoyo ninani monoi aiko sainoino.” ");
INSERT INTO amm_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ulai toti mo asiyofoloso amufukino, Isisoyo totatiso fasiko aino imo monoi lukasikalo manokino, nokonu nokonuso. ");
INSERT INTO amm_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Totiyo amufu manokino mo, nokoyo ko lopumokai nokota mo Isisoni auso kiyoma tumokino, popuwayo uwokaikai nokota mo. ");
INSERT INTO amm_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nosai no mo; Isisoyo popuwaso na amiyaikiyowaiki, no monoi no ko lopumokai nokota mo waliyo na lukasoki. Wiyou, noko nokolaloyo mulumoloko manokino, iyamoki, “Moloi monoi woi? Toku mo ainonani mo kiwoi muwoi, Isolilo asimai mo.” ");
INSERT INTO amm_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ulai Falisi moloso aluwai nokoyo piyamoki, “Popuwa mo tani amiyo pa tamiyaikiyokosowo, popuwa samukuko nokota siyolini amiyo na tamiyaikiyokomoi, Sokolo Nokota Waini amiyo.” ");
INSERT INTO amm_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Nosai no mo; Isiso mo nokonu nokonuso liyaiyalo manoki. Noko nokolaloso aiyolokalo manoki, totaini lotu nu lolofa poiso. Kotoyo samukuko imo itouniyaimoso lukasikalo manoki. Hani hani ai ai kopokoiyau saloso uwoko manoki mo, ititouniso waliyo na siki. ");
INSERT INTO amm_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ukouniyaiko noko nokolaloso kokaloki, mulu na kalo ukuki. Ulai afonimaiso? Toi mo mulu kolikalikai, mulumolokowoi muwoi. Sipo koloni komiyai, samukuko nokota mo uwofa. ");
INSERT INTO amm_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","No monoi no mo, siyokutono iyaliso siyokawi imo na ikoki, “Noko nokolalo molopoi mo Kotoso mulumolo luwai monoi louwa, ulai toi mo sai muwoi, toi mo sosoli. Toi mo isini aliyoli molopoi wamokokai komiyai na si, ulai isi mi ano nokota mo iya tumowoi muwoi. Isi mi ano noko mo pounu muwoi, no monoi no. Isi mi ano noko mo Kotoni mi analomano noko nali no, pounu muwoi, ");
INSERT INTO amm_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","no monoi no Koto Siyoliso na pa imalowo, isi kiyo nokotaso, isi mi ano noko iko taikiyumo, isini aliyoli iyanowumo.” Aino ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Nosai no mo; Isiso mo siyokutono iyaliso na aliyonikoki, noko molo tiwoiso. Tiki mo; ami sisiyoli na nikoki, popuwa kopokoiyau amiyaikiyokalo monoi. Ai ai noko ititounikaiyalowoi monoi na nikoki. ");
INSERT INTO amm_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Kotoni imo lukasikalomano noko, noko molo tiwoi no mo, totaini siyolo siyolo mo noino, totawoi nokotani siyolo mo Saimo, siyolo siya mo Pita. Siya mo Anotolu, Saimoni auwatono. Siya mo Yamiso, Sipitini awitono. Siya mo Iyono, Yamisoni auwatono. ");
INSERT INTO amm_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Siya mo Filipo, siya mo Patolumiyo. Siya mo Tomo. Siya mo Matiyu, takiso muwoni i nokota. Siya mo Yamiso, Alofiyani awitono. Siya mo Tatiya. ");
INSERT INTO amm_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Siya mo Saimo siya, siyolo siya mo Siloto. Siya mo Yutaso Isokailiyo, Isiso uo nokoni auso kiyo taikiyo nokota. No mo Kotoni imo lukasikalomano nokoni siyolo siyolo na. ");
INSERT INTO amm_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Nosai no mo; Isiso mo nonani noko molo tiwoiso na iko taikiyoki, amiso na ikoki, “Noko nokonu nokoni asiso noiyo nuwoiwo. Somaliya asi nokonu nokonuso mani, noiyo nu liyaiyoiwo. ");
INSERT INTO amm_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Isolilo nokoni ausoso na pa nuwo. Toi mo sipo koloni komiyai, samukuko nokotawoi pa siso. Wonikaluso aiko uwokaikoi. ");
INSERT INTO amm_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Moi mo na ponuwo, noino na pikalo manowo, “Kumokiso you tolokaino nokota mo aumoifaso na samukukomoinuwomo.” ");
INSERT INTO amm_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ai ai noko nokolalo na pa ititounikaiyalowo. Yau yau noko mani, na pa lusokalowo. Uluoyo uwokaikokai noko mani, na pa ititounikaiyalowo. Popuwa na pa amiyaikiyoko uwokalowo. Kotoyo suomoso monoiso fasikomonuwo, no monoi no moi mani, suomoso monoiso na pa fasikalowo, noko nokolaloso. ");
INSERT INTO amm_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Muwoniwoi noiyo ilomanoiwo. ");
INSERT INTO amm_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Nuwakinuwomo, iwoi noiyo ilomanoiwo. Kwalomai monoi tuno noiyo ilomanoiwo, siyasonuso pa asisikiyouwo. Fona su mani, siyasonuso pa asisikiyouwo. Atouwoi noiyo losi ilomanoiwo. Noko mo mi anoti mo, mi anoti foli monoi no niwumo. No monoi no hani haniwoi noiyo ilomanoiwo. ");
INSERT INTO amm_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Nokonu siyaso fiyamosiyakinuwomo, atiyaiso na pa kwaiko kiwo. Nonani asi tolomu nokota no itouniyaimo no noi? Nonani nokotani nusoso na pa simosiwo, ulololi mo, ainoso hani utukaimoinuwo, nonani nokonuso. ");
INSERT INTO amm_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nuso takinuwomo, toku na pa ikowo, tolomu nokoso, “Mulu tomokiso na posi itouniyaimowo.” ");
INSERT INTO amm_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ititouni noko sakimo, toi mo nonani imo kwaimoinuwomo, na si itouniyaimoimo, mulu tomokiso. Ulai noko ititouni si somiso mo, pa si itouniyaimoiso, moi saso si itouniyaimoinuwomo, mulu tomokiso. ");
INSERT INTO amm_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ulai toiyo imakinuwomo, “Noiyo toiwo,” nonani nokonu na pa utukaimowo, moini imo kwai somiso mo. Fona asi kukumo pa kitotasokokaiyouwo, toini molo timai. Ulai afonimaiso? Toiyo imo kulali monoi nali no, imonuwo, “Koini nokonuso noiyo toiwo.” ");
INSERT INTO amm_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Motuwa na timonukuwo. Koto mo noko wauwakimo, Sotomo noko kopokoiyau nokowoi Komola noko kopokoiyau nokowoi, toi mo koufaso uwokoimo. Namoliyo alosikomo nokosu, toi mo soliyakiso na uwokoimo. Ulai koufa, soliyaki nali.” Aino ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ti monoi na ikoki, “Na pukwaimonowo. Yo mo sipo koloni komiyai timo taikiyonukuwo, asikoiyo aluwouni auso nu monoi. Kotoso mulumolo luwai somiso noko mo asikoiyo aluwouyo komiyai na louwa uwokaikomoinuwomo. No monoi no mo atiyaiso na pa siwo. Na pukwaiwo. Nuwo mo muluwoi na, atiyaiso toliyaiyalo manono. Wonikaluso nokoyo aiko wasouloino. Moi mani, nuwo komiyai atiyaiso na pako liyai manowo. Ulai uo mo noiyo yoiwo. Anomu komiyai na pa siwo. To mo uowoi nokota muwoi, uo mo uwofa. ");
INSERT INTO amm_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Noko monoi mo atiyaiso, wonikaluso kiyokomoinuwomo, uo imo aiko lukaso unoinuwo, nokotalo iyalini molo timai, lotu nu lolofa poimai aiko wasouloinuwo, moloyo. ");
INSERT INTO amm_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nokoyo uo imo lukaso unanoinuwomo, sisiyoli nokoso, komano nokoso mo. Ulai afonimaiso? Moi mo yoso tomulumolo luwaimono manonuwo, no monoi no uwokomoinuwomo. Noko sisiyoli nokoni molo timaiso kiyokomakinuwomo, Kotoni imo mo waliyo pa posasoko wiyolukowo, toiwoi noko nokonu nokowoiso. ");
INSERT INTO amm_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","20","Uo nokoyo kiyokomakinuwomo, mulu mo noiyo kolikaliyoiwo, hani imoso ikonuwowo. Imo mo moiyo pakoso posasokoinuwoso. Moini Apononi Mulu Itouniyaimo Nokotayo na posasoko wiyoninoinuwomo, no ikakinuwo no. ");
INSERT INTO amm_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Noko mo auwatono monoi komano nokoso uo imo lukaso unanoimo, toiyo tukolo yau imo mo. Apitonoyo mani, awitonoso ainoso nali no uwoyoimo. Alaloyo atino apitono iyaliso namoliyo alosikoinomo, komano noko iyaliso lukaso ukanoinomo, toiyo tukuwoli yau yau imo mo. Ulai afonimaiso? Yoso mulumolo luwaimono foli monoi na tukuwoliyoinomo. ");
INSERT INTO amm_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Noko komaso noko mo mulu atolokomo unoinuwomo. Ulai afonimaiso? Moi mo yani noko nokolalo na. Noko mo mulu ami amiso sakimo, ainoso hani asi fokumoimo, toi mo na samiyaikiyoinomo. ");
INSERT INTO amm_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nokonu siyaso uwokoma tumakinuwomo, na pa ulolowo, nokonu siyaso monoi. Motuwa na timonukuwo. Isolilo nokonu komasoso mo lukasikalo liyai mi uwaimo taikiyo somisomai asi asi noko nokolaloni noko siyoli nokota ya ifou na amukonoimo. ");
INSERT INTO amm_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Sokolu alaloyo no totaini aiyoloko nokota no moloi souwai monoi? Ulai mi anononi nokotayo no totani samuku nokota no moloi souwai monoi? ");
INSERT INTO amm_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nokoyo alaloni aiyoloko nokotaso koiyaumakinomo, sokolu alaloso mani, kopokoiyaukoinomo. Nokoyo noko siyani samuku nokotaso koiyaumakinomo, mi anononi nokotaso mani, koiyaumoinomo. Noinoso nali, asaso mulumolo luwai noko moiso mo siyolo siyolo kopokoiyau na kolalaloinuwomo. Ulai afonimaiso? Yoso mo Pilisipulo Waiso kaluwaimonokaikino, popuwa iyalini samukuko nokotawo.” Aino ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ulai ikoki, Isiso mo, “No monoi no mo, uo noko monoi mo noiyo kokolokomoiwo. Hani hani mo fiyokaikokai sakimo, amuwoi tino mo na fiyamosokoimo. Hani hani mo kukalokokai sakimo, nokoni molo timai fiyamosokoimo, toi saino monoi. ");
INSERT INTO amm_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Imo mo folosumai wosu woso no imonukuwo no, nonani imo mo saponimai na pa lukasikalowo, noko nokolaloso. Imo mo moisoso no imonukuwo no, nonani imo mo siyoliso na pa posasoko wiyotiwo. ");
INSERT INTO amm_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Au monoiso tukuwoli noko monoi noiyo kokolokomoiwo, muluwoi no moloi tukuwoli monoi? Moi uwokaikomo taikiyo nokota monoisu na pa nimowo. To mo Koto nali. Mulumolo luwai somiso mo, au mo uwokaikomoinuwomo, mulu mani, uwokaikomoinuwomo, taso utoinuwomo. ");
INSERT INTO amm_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Moi mo sai, soso uo mo lolofa, lolofa nali. Ulai moini Aponoyo wiyou yomakimo, nonani uofa mo asiso mo pakoso usukunosoiso. Soso uo lolofa monoi na tosamukukomoi. ");
INSERT INTO amm_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Moi monoisu momaini komu suwo komaso yasoi na kolalikai. Wiyou, na tosamukukomo itouniyaimo manonuwo, mulumolo luwai noko iyali moi mo. ");
INSERT INTO amm_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","No monoi no noiyo kokolokomoiwo. Moi mo uo lolofa tosouwaiko manonuwo.” Aino ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Nosai no mo; ti monoi ikoki, Isiso mo, “Noko mo yani siyolo kaluwaimono wiyotiyakimo, noko nokolaloso, yo mani, tani siyolo na kaluwai wiyononinoimo, asani Apouso, kumokiso ni you tolokaino no. ");
INSERT INTO amm_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ulai noko mo noko nokolaloni molo timai namoliyo alosimomonakimo, asayo mani, nonani nokotaso namoliyo na alosimoimo, Apouni molo timai mo.” Aino ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Ulai ikoki, siyokutono iyaliso, “Moi mo tiyamonuwo, yo mo asi noko moini uo tokosiyaima tumonukuwowo. Ulai yo mo uo pa tokosiyaima tumonukuwoso. Yoso mulumolo luwaimono monoi mo uo mulu tiyo ununuwo, noko siyaiyo. ");
INSERT INTO amm_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Apitono mulumolo luwaimonakimo, awitonoyo uo mulu yo unu manoimo. Atoki mani, atinoso uo mulu yo uso manoimo. Soputono mani, soputonoyo atinoso uo mulu yo uso manoimo. ");
INSERT INTO amm_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Nu tomoso si noko mani, mulumolo luwai nokota monoi uo mulu yo unu manoinomo. ");
INSERT INTO amm_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Noko mo atino apitono mulu saso yo mano mo, yo monoi siyoliso molokimomono somiso mo, nonani nokota mo yani woli muwoi. Noko mo alalo mulu saso yo mano mo, to mani, yani woli muwoi. ");
INSERT INTO amm_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Yo mo a moki sokunalomakoimo. Noinoso aluwaimono nokota mani, uo nokoyo uwoyakinomo, moloi ulosukomo monoi? Nokoyo ulosukomo mo, to mo yani woli muwoi. Uo nokoyo takimo, yoso na aluwaimonumo. ");
INSERT INTO amm_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nokoyo totani au monoisu mulu unakimo, aniyopa poi poi moloi yousi itouniyaimo monoi, na kaloimo. Nokoyosu mo yoso aluwaimono monoi kalakimo, pa kalokaiyoiso, aniyopa poi poi na yousikaino itouniyaimo manoimo.” Aino ikoki. ");
INSERT INTO amm_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Isiso mo ti monoi ikoki, “Noko mo moiso imo mo, “Waliyo potiwo,” to mo yoso mani, imono, “Waliyo na potumo.” Yoso aino imono mo, imono taikiyo nokotaso mani, imo, tumumo. ");
INSERT INTO amm_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nokoyo Kotoni mulu lukasiko nokotaso imakimo, “Nono mo Kotoni mulu lukasiko nokota, yani nuso waliyo potumo,” to mani, Kotoni mulu lukasiko foli na anoimo. Nokoyo mulu itouniyaimo nokotaso imakimo, “Nono mo mulu itouniyaimo nokota, yani nuso waliyo potumo,” to mani, mulu itouniyaimo foli na anoimo. ");
INSERT INTO amm_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nokoyo aluwaimono nokotafaso fulomu iwo woliyoninakimo, motu nali, Koto mo suo foli na aninoimo. Ulai afonimaiso? Yani wolifa fasi monoi, no monoi no. Motuwa na timonukuwo.” Isiso mo aino iko taikiyo liyaiki, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nosai no mo; siyokutono iyaliso ikiko uwai; Isiso mo nonani nukutaiso utukaimoki, aumoifa aumoifa nokonu nokonuso liyaiki. Noko nokolaloso aiyolokaloki, Kotoni imo lukasikaloki. ");
INSERT INTO amm_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ulai Iyono mo kalopulo nuso kiyokaikino. Imofa mo nosoni koloma tumoki, Kolaisoyo mi ano imofa mo. No monoi no Isisoni auso na iko taikiyoki, wolitono iyaliso, ");
INSERT INTO amm_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","na yomu taikiyoki, “Noko no tumo monoi no, a, nono na, Kotoyo imo taikiyo nokota, no mo nono na poimo, o, siyaso poimo foumoikimo.” ");
INSERT INTO amm_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Isiso mo toini imo na fowakoki, “Iyonoso na pa imanowo, hani hani komaso no kokonuwo no, no kwaimononuwo no. ");
INSERT INTO amm_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Molo kau kau noko mo na toposasouluko, na tofoinaliko si liyai. Fona nomoli nomoli noko mani, na toliyaino. Uluoyo uwokaikokai noko, iyo uku nokowoi, toi komaso mo waliyo na tosi liyai. Yau yau noko mani, na tauwonoulu liyai. Sonosoni somiso noko mo imo itouniyaimo na tukwai manono. ");
INSERT INTO amm_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Noko mo asa monoi mulu tiwoi tolo somiso mo, nonani nokota mo na tomoloki tolo.” Isiso mo aino na ikoki, Iyononi wolitono iyaliso. ");
INSERT INTO amm_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Noko no mo, Iyonoyo no iko taikiyoki no, toi yasoi. Nosai no mo; Isiso mo noko nokolaloso Iyono monoi iko unuki, “Toku no haniso kiyanokinuwo, noko somiso asiso no? Nakomo moi mo muo muo yapoli kiyanokinuwo, fulomuyo no fuo fuolomani tolo no. Pa kiyanokinuwoso. ");
INSERT INTO amm_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Noi nokotaso kiyanokinuwo? Nakomo kou ititouni nokotaso kiyanokinuwo. Wiyou na. Noko kou ititouni noko, toi mo noko somiso asiso siwoi muwoi, noko siyolini nuso tosimoi, hani hani ititouniwoi. ");
INSERT INTO amm_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ulai noi nokotaso kiyanokinuwo? A, Kotoni mulu lukasiko nokotaso no kiyanokinuwo? Wuo, nasu, Kotoni mulu lukasiko nokotaso na kiyanokinuwo, Iyonoso mo. Toku nokoso na tosouwaiko, Kotoni imo toku no posasokokino no. Ya timonukuwo. ");
INSERT INTO amm_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ninani nokota monoisu mo Kotoni puko imoyo noino tiyomuko unu, “Pukwai, asani imo lukasikalo nokotaso imo taikiyoimo, to mo toku na manoimo, nono monoi. Molo na yono foumaloinimo.” Aino tiyomuko, Iyono monoi. ");
INSERT INTO amm_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Motuwa na timonukuwo. Iyono, iwoso uluwako nokota mo asi noko komaso nokoso toku souwaikoki. Ulai lolai mo folo, afonimai nokota mo asani moloso aluwai mo, to mo Iyonoso na tosouwai, kumokiso you tolokaino nokotayo samukumai mo. ");
INSERT INTO amm_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Iyono iwoso uluwako nokota tolomai ainoso hani lolai, nokoyo louwa imonokino, asuwo ya aluwaiko monoi, toini asi moloso. Ulai yo mo ainonani monoi wiyou tiyomu. Yo mo amukonoki, Kotoyo noko nokolaloso samukuko monoi. ");
INSERT INTO amm_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Kotoni mulu lukasiko noko komaso nokowoi Musiwoi, toi mo kumokiso you tolokaino nokotayo samukuko imo posasokalo manokino, ainoso Iyono tumoki. ");
INSERT INTO amm_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Toini imoso waliyo kwaikakinuwomo, na pa sainowo, Ilaiya mo toku tumo mo. Iyono mo Ilaiya na. ");
INSERT INTO amm_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Noko mo iyo uku somiso mo, imo mo na pa kwaimono itouniyaimowo.” Aino ikoki. ");
INSERT INTO amm_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Nosai no mo; Isiso mo ikoki, “Lolaimai si noko nokolalo moi, yo no moini siyolo siyolo no moloi tokolalinukuwo, woi? Noiwo noko komiyai, moi no? Moi mo alalo lolofa komiyai tosomaimo sinuwo, nokonu mulumai. Alalo siyaiyo taliyonikomo manonuwo, somaimo monoi, ");
INSERT INTO amm_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Koi mo louwo tuwokonoki, ulai moi mo pa tonamonuwoso. Koi mo noko yau monoi tosonuku sinoki, asuwo asuwo, ulai moi mo sosonunowoi muwoi.” ");
INSERT INTO amm_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Noinoso moi mo pa tiyamonuwoso, “Iyononi molo mo itouniyaimo.” Iyono, iwoso uluwako nokota tumoki, tuo mo nowoi muwoi, molo wamo ito iwo sikowoi muwoi. No monoi no tiyamo manonuwo, “No mo kwaimo muwoi. Hani monoi pa tonomoiso?” Tiyamonuwo, popuwayo tuwowo. ");
INSERT INTO amm_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ulai asi asi noko nokolaloni noko siyoli nokota ya tumoki, yo monoi mani, pa tiyamonuwoso, itouniyaimo. Yo mo na tonomoi, molo wamo ito iwo tosikomosi, no monoi no moiyo tiyamonuwo, “Pokiwo, kwaimo muwoi, no siyoli nokota, molo wamo ito iwo siko siyoli nokota. Takiso muwoni i noko kopokoiyau nokoni wolitono, molo koiyauso aluwai nokowoi, toini siyokutono, kwaimo muwoi.” Aino no hani monoi tiyamo manonuwo? Kotoyo mi anoso na pokokalowo, no monoi nosu posainowo, itouniyaimo na. Koto mo mulu mo iwoi.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nokonu nokonuso Isiso mo mulu ifolaluwawoi mi siyoli ano liyai manoki. Ulai noko nokolalo mo mulu mo alosokowoi muwoi. No monoi no uo imo siyoli na yomu taikiyoki, ");
INSERT INTO amm_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Woi, Kolasi noko moi, woi. Woi, Pisaito noko moi mani, woi. Yo mo mulu ifolaluwawoi mi pano manoki, momaini nokonu timai, Yuto noko moini molo timai, ulai molo koiyau monoi mulu kolikaliwoi muwoi, mulu pa alosokokinuwoso. Yo mo nonani mulu ifolaluwawoi mi pano mo, noko nokonu nokoni molo timai, Taiya nokonuwoi Saito nokonuwoiso, mulu na pokolikali, asi pokoukono, ta nuso papoloiyo konokai, toini molo koiyau monoi, mulu palosokono. ");
INSERT INTO amm_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ya timonukuwo. Koto mo noko wauwakimo, Taiya nokowoi Saito nokowoi, toi mo koufasoso uwokoimo. Kolasi noko moiwoi Pisaito noko moiwoi, moi mo soliyakiso na uwokomoinuwomo. Ulai koufa, soliyaki nali. ");
INSERT INTO amm_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kopanaumo noko, a, moi no kumokiso nuwoinuwomo a? Ya timonukuwo, pa nuwoinuwoso. Taso na kunoinuwomo. Yo mo mulu ifolaluwawoi mi pano manoki, moini molo timai. Yo mo nonani mulu ifolaluwawoi mi pano mo, Sotomo nokoni molo timai mo, mulu palosoko, Sotomo nokonu nu mo pa pulalokoso, amai na potoi. ");
INSERT INTO amm_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ya na timonukuwo. Koto mo noko wauwakimo, Sotomo noko kopokoiyau noko, toi mo koufaso uwokoimo. Moisu mo soliyakiso na uwokomoinuwomo. Ulai koufa, soliyaki nali.” Aino ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nomai no mo; Isiso mo Apitonoso na imoki, “Apou, nono mo kumoki asi asi samukuko nokota siyoli. Ya na tomolokimonoki, wafisu. Noko no tiyamo no, “Koi mo mulu mo iwoi,” toi mo nani samukuko mi mo sainowoi muwoi, sosoli. Noko siyai no tiyamo no, “Koi mo sai siyoli muwoi,” toisu mo sai, nani samukuko mi monoi mo, yasoi wiyotikini. ");
INSERT INTO amm_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Nasu, Apou, nani mulu itouniyaimo mo ainoso na. No monoi no wafisu timonoki.” Ainoso imoki, Apitonoso. ");
INSERT INTO amm_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Nosai no mo; nokoso ikoki, “Yani Apou mo hani hani komaso mo yani nainomai yasoi na isikokaimomonoki. Ulai noko mo asa monoi mo sainowoi muwoi, Kotoni awitono monoi mo. Apou Siyoli saso mo sai, asa monoi mo. Ulai noko siyayo no Apou Siyoli no sai? Asa, Kotoni awitono asayosu mo sai. Noko nokolalo siyai mani, sai. Ya na towiyoti. ");
INSERT INTO amm_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Mulu folokomokai noko moi yoso na pimona tumowo. Ya fasiyoikuwomo, na si itouniyaimo manoinuwomo, mulu folokomokaiwoi muwoi. ");
INSERT INTO amm_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yowoi mi pa ano fasimona tumowo. Ano fasimonakinuwomo, ya na wiyolukomoikuwomo, molo itouniyaimoso aluwai monoi. Ulai afonimaiso? Yo mo nokoso waliyo tuwokomoi. Imo koufaso tikomoi, kukamokowoi nokota muwoi, yo mo. No monoi no mulu tomokiso soinuwomo. ");
INSERT INTO amm_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Yowoi mi ano fasimonakinuwomo, moi mo mulu mo folokomokaiwoi muwoi. Ulai afonimaiso? Ya na fasikomo manoikuwomo.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mi fou fouko ulomai mo isi mulumai molomai nu liyaiki, Isiso iyali mo, paluwa tuo sosono isimai. Tiya uwokoki, siyokutono iyali mo, paluwa u na tofu nokalokino. ");
INSERT INTO amm_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Ulai Falisi moloso aluwai noko mo kokalo tumokino, Isisoso na imokino, “Na pokoko, nonani monoi no hani monoi tiyono, siyokuno iyali no? Mi fou fouko ulomaisu mo ausu.” ");
INSERT INTO amm_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Nosai no mo; Isiso mo na fowakoki, “Ulai moi no Toiwi aino imo pa kwainuwoso? Ulai pa kokonuwoso, ninani puko imo no? Toiwi iyali mo tiya kolikaliki mo, ");
INSERT INTO amm_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","nomai no mo paluwa tuo iya tiki, Kotoni lotu nu poiso, paluwa tuo no mo, Kotoso muwokokainonikai yasoi. Nonani paluwa tuo mo afonimai noko mo au au. Lotu samukuko nokoyosu noko mo waliyo. Toiwi mo lotu samukuko nokota muwoi, ulai na noka tiki. Lotu samukuko nokotayo niki, paluwa tuo mo. Siyokutono iyali mani, na noka tikino. ");
INSERT INTO amm_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ulai moi no Musini imo ami siya pa kwaimonuwoso? Ulai pa kokonuwoso, ninani puko imo no? Mi fou fouko ulo saiso saiso mo lotu samukuko noko mo lotu samukuko mi na tano manono, lotu nu siyoli poiso. No mo mi ano nali no, mi fou fouko ulomai mo, ulai toi mo hani mo yowoi muwoi. ");
INSERT INTO amm_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ya timonukuwo. Yo mo lotu nu siyoli na tosamukumoi. ");
INSERT INTO amm_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kotoni puko imoyo mo tiyomuko, “Yo mo koloniyo utumono monoi mo wiyou. Noko nokolaloso fasikonuwo mo waliyo. Mulu na pukuwo. Suomoso monoiso na pofasikanowo.” Moi mo nonani imo folosai imoso posainonuwo mo, molo koiyau foli pa puwokonuwoso, molo koiyau aluwai somiso nokoso mo. ");
INSERT INTO amm_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Asi asi noko nokolaloni noko siyoli nokota, asa mo mi fou fouko ulo na tosamuku.” Aino ikoki, mi fou fouko ulo monoi. ");
INSERT INTO amm_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Nosai no mo; Isiso mo isisai manoki, totaini lotu nufa poiso lotiki. ");
INSERT INTO amm_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Naino nomoli nokota mo na tu tolokainoki. Isiso monoi faumiko monoi louwa fi yokino, nokoyo, no monoi no na imokino, “Oi, moi no mi fou fouko ulomai no naino nomoli nokota no waliyo titouniyaimokoni? No mo au poimo, waliyo poimo.” ");
INSERT INTO amm_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Isiso mo na ikoki, “Moi nokotani sipo koloni mo asi iso usukunosakimo, mi fou fouko ulomai, nonani nokota mo sipo koloni mo waliyo na komisiyo yoimo. ");
INSERT INTO amm_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ulai ya timonukuwo. Noko mo sipo koloni na tosouwaiko. No monoi no mo waliyo, nokoso mani, niya tofasikoni, mi fou fouko ulomai mo.” ");
INSERT INTO amm_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ikoki mo; nosai no naino nomoli nokotaso na imoki, “Naino mo na pofouko.” Nosai no mo naino na foukoki. Foukoki mo; naino mo waliyo na takoki, naino siyai komiyai. ");
INSERT INTO amm_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ulai Falisi moloso aluwai nokoyo fuki, Isiso tukolo imo monoi na lukaso unukaikino. ");
INSERT INTO amm_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ulai Isiso mo imofaso kwaiki, tukolo monoi imofa, no monoi no nonani nokonusai utukaimoki. Noko nokolalo molopoiyo aluwai manokino, ai ai noko koliyo tumokino. Na ititounikaiki, ");
INSERT INTO amm_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","na iko taikiyoki, “Yani siyolo noiyo kaluwai wiyotiyaloiwo.” ");
INSERT INTO amm_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","No mo afonimaiso muwoi, Kotoni imoyo motu fiyamosi monoi, tani mulu lukasiko nokota Aisaiyayo toku no kumokaiki no, noino, ");
INSERT INTO amm_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ni mo yani mi ano nokota, ya yasoi muwokaiki. Yani mulu mo waliyo, to monoi mo, na tomulu unumoi. Asani Mulu Itouniyaimo Nokotaso na imo taikiyoimo, tani auso, no monoi no molo itouniyaimo na wiyotiyoimo, asi asi nokoso. ");
INSERT INTO amm_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Pa kiyoluwaikoiso. Imo siyoliso pa alolamoiso, noko molopoi mulumaiso. ");
INSERT INTO amm_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Koufaso mulumolo luwaimono nokotaso na fasiyoimo, muo muo komiyai pa tofufoli taikiyoiso. Wosiyaikokai muo muo komiyai pa tofufoli taikiyoiso. Lamu ta komiyai pa sopokumiyai taikiyoiso. Lamu ta koufaso no tamuko no, ulai komaso pa sopokumiyai taikiyoiso. Na fasiyoimo, ainoso hani uo uwaima tumoimo. ");
INSERT INTO amm_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Asi asi nokoyo mulumolo luwaiyoinomo, na foumo soimo.” Aino toku kumokaiki. Namolisai mo motu na fiyamosiki. ");
INSERT INTO amm_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nosai no mo; popuwawoi nokota na kiyoma tumokino, kowoi molo tiwoi ufiyaikomokai nokota. Na itouniyaimokaiki, Isisoyo mo. Imo mo waliyo na lukasoki, molo ti mani, waliyo na foinalikoki. ");
INSERT INTO amm_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Noko nokolalo molopoi nokoyo kufaukoki, iyamoki, “Noko to ni mo Toiwini alisaimi poimo, noko siyoli Kotoyo no muwokai no.” ");
INSERT INTO amm_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ulai Falisi moloso aluwai noko mo nonani imofaso kwaikino mo, na iyamoki, “Noko to ni mo, to mo popuwa mo Pilisipulo Waini amiyo na tamiyaikiyoko uwokomoi, popuwa samukuko nokota siyolini amiyo mo.” ");
INSERT INTO amm_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ulai Isiso mo toini mulu mo sai, na ikoki, siyokawi imo mo, “Asi siya noko iyaliyo totai amu tukoluwanakinomo, totai amu pa asisikuwanoinoso, na uwokaikuwanoinomo. Nokonu siya noko iyaliyo totai amu tukoluwanakinomo, totai amu pa asisikuwanoinoso, si itouniyaimowoi muwoi, pa si itouniyaimoiso. Nu siya noko iyaliyo totai amu tukoluwanakinomo, totai amu pa asisikuwanoinoso, kwaimo pa soiso. ");
INSERT INTO amm_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Sokolo Nokota Waiyo siyokutono iyali pamiyaikiyoko mo, totai amu pa pasisikuwanonoso, kwaimo pa posiso. ");
INSERT INTO amm_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ulai yo no Pilisipulo Waini amiyo no moloi amiyaikiyoko monoi, popuwa no? Moini mulumai mani, popuwa amiyaikiyoko noko siyaiyo na tosi liyai. A, noini amiyo tamiyaikiyoko manono? Kotoni amiyo nali no. Totaiyosu na imoinuwomo, “Topokonuwo, Pilisipulo Waini amiyo no moloi amiyaikiyoko monoi, popuwa no?” ");
INSERT INTO amm_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Motu na, Kotoni Mulu Itouniyaimo Nokotani amiyo na tamiyaikiyokomoi, yo mo. No monoi no moi mo sai, Kotoni amiyo yasoi na samukuya tumokinuwo.” Aino ikoki. ");
INSERT INTO amm_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Siyokawi imo mo ti monoi na ikoki, “Ulai noko siya mo noko ami nokotani nuso afonimaiso lotiwoi muwoi, polamoko monoi. Wiyou, toku noko ami nokotani naino timai tokonosuwakokai, moloyo. Konosuwako uwai; nosai no na topolamoka ti.” Aino ikoki, siyokawi imo mo. Imo folosai imo mo noino. Isiso mo Sokolo Nokota Waiso tosouwaikai, no monoi no popuwa mo waliyo tamiyaikiyokomoi. ");
INSERT INTO amm_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ulai ti monoi ikoki, “Noko mo yani woli tolo somiso mo, koti mo uowoi. Noko mo yani imo lukasikalo somiso mo, nonani nokota mo noko nokolalo tuwokaiko, no monoi no folo folo tulolo liyai. ");
INSERT INTO amm_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","No monoi no ya timonukuwo. Molo kopokoiyauso aluwaikalo noko mo mulu alosokakinomo, Koto mo imo mo futo. Alisiyolikuwano noko mani, mulu alosokakinomo, imo mo futo. Ulai nokosu mo Kotoni Mulu Itouniyaimo Nokotaso alisiyoliyakimo, Koto mo nonani alisiyoli imo foli monoi imo mo futo muwoi, amai. ");
INSERT INTO amm_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Asa, asi asi noko nokolaloni noko siyoli nokota yoso imo koiyau imonakinomo, Koto mo nonani imo koiyau foli monoi imo mo futo, yoso mulumolo luwaimonakinomo. Ulai noko mo Kotoni Mulu Itouniyaimo Nokotaso imo koiyau imakinomo, nonani imo koiyau foli monoi mo futo muwoi, amai. Lolaiwoi amuwoi tinowoi mani, ainoso na.” Aino ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ulai ikoki, “A mo koiyau tolakimo, a wamo mo ititouni pa soiso. A mo itouniyaimoso tolakimo, a wamo ititouniwoi na soimo. Nokoyo a wamoso kokakimo, na sainoimo, nonani a monoi. Koiyau mo koiyau. Itouniyaimo mo itouniyaimo. ");
INSERT INTO amm_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Noko kopokoiyau noko moi mo nuwo kopokoiyau komiyai. Moi no imo itouniyaimoso no moloi lukaso monoi? Mulu koiyauwoi nokota tani imo mo kwaimo pa tolukasoso, tani imo mo koiyau. Mulumoloko itouniyaimo mulu tano mo, nonani nokota mo imo itouniyaimoso tolukasomoi. ");
INSERT INTO amm_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Noko koiyau nokota, tani mulu mo wapumokai. No monoi no imo koiyausoso na tolukasalomoi. Noko itouniyaimo mo mulu itouniyaimowoi na totolomoi. No monoi no imo itouniyaimososo na tolukasalomoi. ");
INSERT INTO amm_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ulai ya timonukuwo. Kotoyo noko nokolalo wauwoimo, totaiyo imo lukasalo foli monoi. ");
INSERT INTO amm_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Imo kopokoiyau iyamo foli monoi mo Koto mo na kolaloimo, noko kopokoiyau, na uwokaikoimo. Imo ititouni iyamo foli monoi mo na kolaloimo, noko ititouni.” Isiso mo aino ikoki, Falisi moloso aluwai nokoso. ");
INSERT INTO amm_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nosai no mo; Musini imo sai sisiyoli nokowoi Falisi moloso aluwai nokowoi, toi mo na imokino, “Aiyolokomomoko nokota, koiyo timonoki, mulu ifolaluwawoi mi na powiyomoko.” ");
INSERT INTO amm_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ulai na ikoki, “Lolaimai si noko nokolalo moi mo mulu kopokoiyau, Kotoso namoliyo talosimo manonuwo. Mulu ifolaluwawoi mi saso wiyononi monoi tiyo manonuwo. Ulai yo mo pa wiyononinoikuwoso. Kotoni mulu lukasiko nokota Iyona tolomai Koto mo mulu ifolaluwawoi mi wiyotiki, noko nokolaloso. Noinososu na wiyononinoikuwomo, yo mo. ");
INSERT INTO amm_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Toku Iyona mo la siyolini nomoli poiso yousikaino manoki, ulo amoloki mo tiwoi. Noinoso na, asa, asi asi noko nokolaloni noko siyoli nokota yo mani, yu asi i poiso na tu tanoimo, ulo amoloki mo tiwoi. ");
INSERT INTO amm_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Koto mo noko nokolalo wauwakimo, Niniwa noko nokolalo mani, auwonoulu tomasima tumoinuwomo, lolaimai si noko nokolalo moiwoi. Moi monoi na iyamoimo, “Kwaimo muwoi, kopokoiyau.” Ulai afonimaiso? Afonimaiso muwoi. Niniwa noko nokolalo mo Iyonani imo kwaimokino, mulu na alosokokino. Lolaimai yo mo ni totola tumo mo, Iyonaso tosouwai. Ulai lolaimai si noko nokolalo moi mo yani imo mo kwaimonowoi muwoi. No monoi no uwokaikomoinuwomo. ");
INSERT INTO amm_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Koto mo noko nokolalo wauwakimo, aluwaso noko samukuko nukonu siyoli, tokuwa toku no tolosoki no, to mo auwonisiyou tomasima tumoinuwomo, lolaimai si noko nokolalo moiwoi. Moi monoi na yomusoimo, “Kwaimo muwoi, kopokoiyau.” Ulai afonimaiso? Afonimaiso muwoi. Nonani aluwaso nukonu siyoli mo Solomononi imo itouniyaimoso kwaima tumoki. Lolaimai yo mo ni totola tumo mo, Solomonoso na tosouwai. Ulai lolaimai si noko nokolalo moi mo yani imo mo kwaimonowoi muwoi. No monoi no uwokaikomoinuwomo.” Isiso mo aino ikoki, nokotalo iyaliso. ");
INSERT INTO amm_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Nosai no mo; siyokawi imo na ikoki, “Popuwa koiyau mo nokoni ausai tutukaimo mo, nu somiso asiso tomoi, mi louwa tofou foukano. ");
INSERT INTO amm_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ulai tiyomu, “Yo mo ifou na tomoi, nokoni au poiso. Toku yo no tu toloki no, nonani au poiso totolano, yo mo.” Yasoi. Nokoni au mo ifou totumo mo, popuwa siya uwofaso tokiya tumo, aso itouniyaimokaiso, kouwokaiso. ");
INSERT INTO amm_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","No monoi no mo popuwa siyai, 7 mo, na tokolisano. Ami ami, totawoi popuwani amiso tosouwaino. Na toti, nonani nuso tosa ti. Toku mo nonani nokota mo koiyau potolokainoki. Ulai lolai mo wiyou, koiyauwa na totolokaino. Noinoso na, lolaimai si noko nokolalo kopokoiyau moi mani, koiyauso posinononuwo. Namolisai mo koiyauwa koiyauso sinonoinuwomo, nonani nokota komiyai.” Aino ikoki. ");
INSERT INTO amm_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Isiso mo noko nokolaloso imo polukasiyoluwaiko toloki. Nosai no mo; atinowoi auwatono iyaliwoi mo asiyofolosai fu sa tumoki, Isisowoi lukaso ni monoi. ");
INSERT INTO amm_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Nokoyo imoki, “Anoni auwano iyali mo asiyofoloso fu si. Na tima tumoni.” ");
INSERT INTO amm_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ulai Isiso mo na imoki, “Yani anoiwoi auwa iyaliwoi no noiwo noko, woi?” ");
INSERT INTO amm_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tani siyokutono iyaliso nainoyo na foukaloki, na yomuki, “Yani anoi auwa iyali mo niya si. ");
INSERT INTO amm_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Nokoyo yani Apou, kumokiso ni you tolo no, tani imoso kwaimono mo, toi mo yani anoi auwa inai iyali na.” Isiso mo aino na yomuki. ");
INSERT INTO amm_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nomai no mo, Isiso mo nusai manoki, iwo toku iloso yousanoki. ");
INSERT INTO amm_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Nosai no mo; noko nokolalo molopoi mani, ukouniyaikokuya tumokino, no monoi no Isiso totasu mo ayouso yousa konoki. Noko nokolaloyo mo upoisai si liyaiki. ");
INSERT INTO amm_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Siyokawi imo na lukasiyoluwaiko manoki. Na ikoki, “Noko mo aliyoli ali tokosikwiyalo, isiso. ");
INSERT INTO amm_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tokosikwiyalo mo, aliyoli ali siyai mo molomai na tosalo kono liyai. Uoyo na tonokalo tumono. ");
INSERT INTO amm_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Siyai mo tomoki asimai tosalo kono liyai. Asi somuso mo tanowoi muwoi, nonukanofa totoi. No monoi no mo somaiso na tauwonoulu liyai. ");
INSERT INTO amm_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Uloyo tokoko mo, na tonomoliko taikiyo. Totiwoi pa tosiso. ");
INSERT INTO amm_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Siyai mo molosu to to mulumai tosalo kono liyai. Molosu isi atoniyo tauwonoulu liyai, na tofiyokaikono. ");
INSERT INTO amm_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Aliyoli ali siyaisu mo asi itouniyaimomai na tosalo kono liyai, itouniyaimoso na tauwonoulu liyai. Wamokomai mo u molopoi na tosi liyai. U siyai mo sisiyoli. Siyai mo sisiyoli nali no. Siyai mo wiyou, molopoi molopoi, soliyaki soliyaki. ");
INSERT INTO amm_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Noko mo iyo uku somiso mo, imo mo na pa kwaimono itouniyaimowo.” Siyokawi imo aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nosai no mo; siyokutono iyali mo Isisoni auso na ima tumokino, “Nono no siyokawi imo no hani monoi tikoni?” ");
INSERT INTO amm_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Na fowakoki, “Kumokiso you tolokaino nokotayo mo moi samukukomo mulu yasoi wiyononikinuwo. Nonani kukalokokai imo mo momaisoso na wiyononikinuwo. Anunani noko nokolalo, toisu mo sai muwoi. ");
INSERT INTO amm_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Noko mo Kotoni imoso sainakimo, to mo Kotoyo aiyolomoimo, wiyou, sai siyoliwoi toloimo. Nokosu mo koufaso sainakimo, nonani koufaso mani, fufolikomoimo. ");
INSERT INTO amm_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","No monoi no siyokawi imo saso tikomoi. Molo saso tofoinalikono, ulai hani mo kiwoi muwoi. Imo saso tukwaino, ulai imo folosai mo sainowoi muwoi. ");
INSERT INTO amm_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nonani noko nokolalo monoi Kotoni mulu lukasiko nokota Aisaiya kumo ukuki, lolai mo motu na tofiyamosi. Noino na tiyomuko, “Imo saso kwai manoinuwomo, ulai imo folosai mo pa sainoinuwoso. Molo saso foinaliko manoinuwomo, ulai hani mo pa kiyoinuwoso. ");
INSERT INTO amm_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ninani noko nokolalo mo mulu mo wapu wapukokai si. Imo kwai monoi mo wiyou tiyamo, iyo mo uku ukukokai. Moloyo koko monoi mani, wiyou tiyamo. Wiyou iyamo somiso mo, moloyo pokokono, hani mo pokino. Imo pukwaino mo, imo folosai mo na posaino itouniyaimono. Mulu palosokono mo, ya na pititounikai.” Aino tiyomuko, Kotoni puko imoyo mo, mulu wapu wapukokai noko monoi. ");
INSERT INTO amm_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Moisu mo na pa molokiwo. Hani mo yasoi tokoko manonuwo. Hani imo mo yasoi tukwai manonuwo. ");
INSERT INTO amm_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Motuwa na timonukuwo. Toku mo Kotoni mulu lukasiko nokowoi mulu ititouni nokowoi, toi mo ninani ki monoi louwa, ni tokinuwo no, ulai toi mo kiwoi muwoi. Ninani imo kwai monoi louwa, ni tukwainuwo no, ulai toi mo kwaiwoi muwoi.” Isiso mo aino na ikoki, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Ulai na ikoki, Isiso mo, “Na pukwaiwo, nokoyo aliyoli ali kosikwiyalo imo folosai mo. ");
INSERT INTO amm_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Noko siyai mo Kotoyo samukuko imo tukwaino, ulai toi mo imo folosai imo mo sai muwoi. No mo aliyoli ali komiyai molomai tosalo kono liyai. Sokolo Nokota Waiyo mo toini auso somaiso na totumomoi, Kotoni imo tosaloso uwoka tumomoi, nonani nokoni mulu poiso. ");
INSERT INTO amm_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Noko siyai mo Kotoni imo mo tukwaino, na tomolokimono, toku mo. No mo aliyoli ali komiyai tomoki asimai tosalo kono liyai. ");
INSERT INTO amm_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Ulai nonani noko iyali mo toti somiso ali komiyai, Kotoni imo mo fokufaso na taluwai manono. Afonimai nokoyo Kotoni imoso aluwai monoi alukika tumakinomo, lolai siyaso namoliyo na alosimoinomo. Uo nokoyo uwoko monoi, no monoi no. ");
INSERT INTO amm_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Noko siyai mo Kotoni imo tukwaino. Ulai asini hani hani monoi mulu tokolikalimoi, muwoni mulu monoiso na tiyo manono. No mo aliyoli ali komiyai molosu to to mulumai tosalo kono liyai. Nonani asini hani hani mulu mo Kotoni imoso na tofiyokaikokai manono. Nonani noko iyali mo a wamo si somiso a komiyai. ");
INSERT INTO amm_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Noko siyai mo Kotoni imo na tukwai itouniyaimono, imo folosai imo mani, na tosainono. No mo aliyoli ali komiyai asi itouniyaimoso tosalo kono liyai. Nonani noko iyali mo a komiyai na tosimoi, a wamo molopoiwoi. Siyai mo sisiyoli. Siyai mo sisiyoli nali no. Siyai mo wiyou, molopoi molopoi, soliyaki soliyaki.” Isiso mo aino na ikoki, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Nosai no mo; Isiso mo siyokawi imo siya na ikoki, “Kumokiso you tolokaino nokotani samukukomo mulu mo noino. Noko mo aliyoli ali ititouni tokosikwiyalo, isiso. ");
INSERT INTO amm_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ulai noko nokolalo ulololi simai uo nokota mo wosu woso totumo, sosono aliyoli kopokoiyauyo na tosaloso tokolikalo. Nosai no mo na tomoi. ");
INSERT INTO amm_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Namolisai mo aliyoli ali ititouni na tauwonoulu, u fofoliko monoi mo aumoifaso. Ulai sosono kopokoiyau mani, na tauwonoulu tomasikono. ");
INSERT INTO amm_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nosai no mo; tani mi anononi nokoyo isi kiyo nokotaso timanono, “Noko Siyoli, koi tiyamonoki, aliyoli ali ititouniso kosikwini. Ulai sosono kopokoiyauwoi no hani monoi auwonoulu liyai, woi?” ");
INSERT INTO amm_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Nosai no mo na ikoki, “Uo nokotayo na yo.” Mi ano nokoyo imokino, “A, nonani sosono kopokoiyau no waliyo toli foliyafoumoikimo?” ");
INSERT INTO amm_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ulai na ikoki, “Tofolo, sosono kopokoiyauso toli foliyafoumakinuwomo, wonikaluso aliyoli ali ititouni fuwoi toli foliyafoumoinuwomo. ");
INSERT INTO amm_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Na pukwaikokaiwo, wamokaki no. U tofukomai mo mi ano nokoso amai ikoimo, “Sosono kopokoiyau mo foloso monoi pa tolisokaiyalowo, na pa yoluwalokokaiyalowo, taso utu monoi. U ititouni mo asani no isikokai nuso na pa isikokaiya tumowo.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Nosai no mo; Isiso mo siyokawi imo siya mo noino na ikoki, “Kumokiso you tolokaino nokotayo samukuko noko nokolalo iyali mo sipoki ino komiyai. Nokoyo nonani sipoki ino tikaiyano, totani isiso. ");
INSERT INTO amm_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Sipoki ino mo a wamo ino siyai komiyai muwoi. Wiyou, siyoli muwoi, koufa, ulai namolisai mo soliyakikoso, siyoli na totoloso. Isi aliyoli komasoso na tosouwaiko. A na totoloso, touwowoi na tosi. Uo mo nonani a touwoso tosinona tumo liyai.” ");
INSERT INTO amm_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nosai no mo; siyokawi imo siya na ikoki, “Kumokiso you tolokaino nokotayo samukukomo mi mo paluwa tuo sisiyoliko asu komiyai. Noni mo paluwa tuo totopolomo tomasi, sisiyoliko asuwoi, poso siyolimai. Nosai no mo tokoma liyo, puwoso puwoso ko kowaso.” Isiso mo siyokawi imo aino ikoki. Totaso mulumolo luwai noko nokolalo mo molopoi molopoi soimo. ");
INSERT INTO amm_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Nonani imo komaso mo Isisoyo no posasoko wiyotiki no, noko nokolaloso, no mo siyokawi imo saso. Imo folosai imo mo pa ikokiso, siyokawi imo saso na ikokaiki. ");
INSERT INTO amm_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","No monoi no Kotoni mulu lukasiko nokotani imoyo motu na tumoki, Isisoyo siyokawi imo posasoko wiyolukomai. Kotoni pukoso toku noino kumokaiki, Siyoli Nokotani imo mo, “Yani koyo siyokawi imo saso yomoimo. Na posasoko wiyolukoimo, hani hani mo kumoki asi asi fonanikomosai kukalokokai no tosi liyai no.” Aino kumokaiki, Kotoni pukoso. ");
INSERT INTO amm_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Nosai no mo; Isiso mo noko nokolalo utukaikoki, nuso lotiki. Siyokutono iyali mo aluwainiyo tikino, na ima tikino, “Sosono kopokoiyau imo folosai na polukaso wiyomoko, sosono mo isiso no tauwonokiyou no.” ");
INSERT INTO amm_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Isiso mo fowakoki, “Noko mo aliyoli ali ititouni isiso tokosikwiyalo mo, no mo asa asi asi noko nokolaloni noko siyoli nokota. ");
INSERT INTO amm_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Isi mo asi niya. Aliyoli ali ititouni mo, no mo Kotoyo samukuko noko nokolalo. Sosono kopokoiyau mo, no mo uo nokota siyolini noko nokolalo. ");
INSERT INTO amm_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Uo nokota mo sosono kopokoiyau aliyoli ali no tokosikwiyalo no, no mo Sokolo Nokota Wai na. U tofukomai mo asi mo fokumomai mo. Mi ano noko mo Kotoni kumoki noko iyali. ");
INSERT INTO amm_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Sosono kopokoiyau mo foloso monoi totolisokaiyalono, tiyaluwalokalono, taso utu monoi. Noinoso na, asi fokumomai mani, tomoso na uwokoinomo, noko nokolalo monoi mo. ");
INSERT INTO amm_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Asa, asi asi noko nokolaloni noko siyoli nokota yo mo asani kumoki noko iyali na iko taikiyoimo, asiso, noino, “Asini hani hani kopokoiyau na posaloso uwoka konowo, yani noko nokolaloso. Ainiko ifoluwaiko noko na posaloso uwoka konowo. Kotoni imo kulali mano noko nokolalo mani, na pa amiyaikiyokowo.” Aino ya iko taikiyoimo. ");
INSERT INTO amm_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ta siyoliso na saloso utoinomo. Wiyou, sosonuno soimo, i mo sisiko soimo. ");
INSERT INTO amm_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Nomai nosu mulu ititouni noko nokolalo mo ulo komiyai wiko soimo, Apitononi samukuko asimai mo. Noko mo iyo uku somiso mo, imo na pukwaimono itouniyaimowo.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Ulai na ikoki, siyokawi imo mo, “Kumokiso you tolokaino nokotayo samukukomo monoi aino imo mo muwoni pokili komiyai, isiso no tai usokaino no. Nosai no mo noko siyayo na tokosa tumo, ulai ifou takokaiso. Na tomoloki, mulu siyoli tiyo. No monoi no totani ilolu komaso na tiyano, isi kiyo nokotaso toniya tumo, tosuo suomokomo, nonani isi ano monoi, muwoni pokiliwoi.” ");
INSERT INTO amm_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ti monoi timonukuwo. Kumokiso you tolokaino nokotayo samukukomo monoi aino imo mo noino. Suo suomoko nokota mo kou ititounisoso tikolikalomoi. ");
INSERT INTO amm_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Kou itouniyaimoso tokikai, mulu siyoli tiyo. No monoi no totani ilolu komaso mo na tiyano, kou kiyo nokotaso toniya tumo, tosuo suomokomo, nonani kou ano monoi.” Isiso mo siyokawi imo ti aino ikoki, Kotoyo samukukomomoko mulu monoi mo. Kotoyo samukukomo mulu monoi yokoni mo, mulu no tiwoi no moloi yo monoi? ");
INSERT INTO amm_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ulai ikoki, “Ti monoi timonukuwo. Kumokiso you tolokaino nokotani samukukomo mulu mo noino. Nokoyo la imo mo tokukiyalono mo, hani hani la na tokunoka tumo liyai, imo poiso. ");
INSERT INTO amm_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Imo mo ko kowaso iloso takiyonono. Takiyonono mo; na tosa kono, la folo folo tisikokaiyalono. La ititouni mo pososo na tisikokaiyalono. La kopokoiyau mo na tosalosono, iwoso. ");
INSERT INTO amm_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Noinoso na, asi fokumomai mani, kumoki noko iyaliyo mulu ititouni nokoni mulumaiso kolisaloinomo, noko kopokoiyau noko mo. ");
INSERT INTO amm_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ta siyoliso na saloso utu taikiyoimo. Wiyou, sosonuno soimo, i mo sisiko soimo.” Aino ikoki, Isiso mo, siyokawi imo, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Nosai no mo; Isiso mo utolukoki, “Nakomo imo folosai imo komaso mo sai, moi mo.” Na imokino, “Nasu, koi mo sai na.” ");
INSERT INTO amm_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Na ikoki, “No monoi no mo Musini imo sai siyoli nokota mo yoso mulumolo luwaimonakimo, to mo tokumi molowoi tonufuwa molowoi sainoimo, kumokiso you tolokaino nokotani samukuko monoi aiyolomakimo, nokoyo. To mo nu kiyo nokota komiyai ilolu no tiyo fu no, tokumi iloluwoi tonofalo iloluwoi noko nokolaloso na towiyoluko. Noinoso Musini imo sai siyoli nokota mo yoso mulumolo luwaimonakimo, to mo tokumi molowoi tonofalo molowoi sainoimo, noko nokolaloso na wiyolukoimo.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nosai no mo; siyokawi imo lukasiko uwai; nonani asi utukaimoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Totani asiso monoi na manoki. Lotu nu mo tumoki, Kotoni imo aiyoloka tiki, noko nokolaloso. Ulai iyamoki, “Noko to no mulu iwoi no moloi ano, woi? Mulu ifolaluwawoi mi no moloi ano, woi?” Aino iyamoki, na kufaukoki. ");
INSERT INTO amm_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Na iyamaloki, “To mo nu kololi nokotani awitono na. Moilisu mo tani atino nali no. Yamiso Yusifo Saimo Yutaso, toi mo tani auwatono iyalisu na. ");
INSERT INTO amm_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Inaitono iyali komaso mo moini aumai niya si. Ninani hani hani ami no moloi ano, woi?” ");
INSERT INTO amm_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Aino no iyamoki mo, uo mulu na atolokomo unukino. Ulai Isiso mo na ikoki, tota amu monoi, “Noko nokonu nokoyo Kotoni mulu lukasiko nokotaso tokisosomi manono. Nokonu tomoso nokoyosu pa tokisosominoso. Nuwa noko iyali mani, tauwosisimono.” ");
INSERT INTO amm_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Aino ikoki. Mulu ifolaluwawoi mi siyoli anowoi muwoi, nonani asimai mo. Ulai afonimaiso? Pa mulumolo luwaikinoso. ");
INSERT INTO amm_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nomai no mo, komano nokota siyoli Hilo mo, to mo Isiso aino imo koloma tumoso kwaiki. ");
INSERT INTO amm_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Totani mi anononi nokoso na ikoki, “Noko to no mo Iyono, iwoso uluwako nokota na, yausai ifou na auwoniyouki. No monoi no mulu ifolaluwawoi na totolokaino.” Hilo mo ainoso piyomuki, Iyonowo, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ulai afonimaiso yomuki? Afonimaiso muwoi. Toku mo, Iyono mo tukolo somisomai Hiloyo komi kausiki, moloyo konosuwakomoki, kalopulo nuso na kominalomanoki. Hilotiya, Hiloni auwatono Filiponi noni, to foli monoi na yoki. ");
INSERT INTO amm_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Toku mo, kalopuloso kiyo somisomai, Iyono mo Hiloso na imoki, “Auwanoni noni no hani monoi kauso wanonini? No mo kwaimo muwoi, au na.” ");
INSERT INTO amm_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","No monoi no Hilo mo Iyono tukolo monoi na yo unuki. Ulai noko nokolalo monoi kokolomoki. Ulai afonimaiso? Toiyo iyamoki, “Iyono mo Kotoni mulu lukasiko nokota na.” ");
INSERT INTO amm_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Nosai no mo; koloni wasi tomasima tumokino, Hiloni wolitono iyaliyo. Koloni amai wasi manokino mo, Hilotiyani atoki mo nokoni molo timai na namoso tolosa tumoki. Wiyou, Hilo mo mulu na usoki, namoso monoi mo. ");
INSERT INTO amm_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Na isoki, “Motu nali no, haninoi monoi timononi, ya nonani hani tanoninoki, molo lou.” Ainosu nali auwoloki. ");
INSERT INTO amm_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nosai no mo; Hiloso na imoki, “Iyono, iwoso uluwako nokotani komu mo naumai pako aniyo tumomono.” No mo totani muluyosu pakoso imokiso, atinoyo noinomo na imoki, “Iyononi komu na paniyo tumomono.” ");
INSERT INTO amm_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nonani imo no imoki mo, Hilo siyoli mo mulu kaloki, Iyono tukolo imo monoi mo. Ulai auwolo imo monoi mo mulumolokoki, koloni wasi no niko nokoni molo timai no auwoloki no. No monoi no nokoso na imoki, “Nonani hani na panano, na pa atisa tumo.” ");
INSERT INTO amm_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","No monoi no nokoyo kalopulo nuso manoki, Iyononi komu na tokosonanoki. ");
INSERT INTO amm_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Komu saso na atisa tumoki, naumai, maputo nukonuso na atisoki. Tasu mo atinoso na atisanoki. ");
INSERT INTO amm_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Siyokutono iyalisu mo Iyononi yau ana tumokino, asiso ai unanokino. Ai unu uwai; Isisoso na imanokino. ");
INSERT INTO amm_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Isiso mo Iyono yau imofaso kwaiki mo, noko somiso asiso monoi na manoki, ayou molosai. Tota siyofoloso manoki. Noko nokolalosu mo mano monoi imofaso kwaikino. No monoi no mo totaini nokonu nokonusai utukaiko liyaikino, namolisai na tanomo manokino, ilo molosai. No monoi no toku tiki, tota monoi. ");
INSERT INTO amm_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nosai no mo; Isiso mo ayou akaiya tumoki mo, noko nokolalo molopoiso ukouniyaikokaiso koka tumoki. Mulu na kalo ukuki, toini ai ai noko na ititounikaitiki. ");
INSERT INTO amm_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Nosai no mo; upimoso siyokutono iyali mo ima tumokino, “Ninani asi mo nokowoi asi muwoi. Ulo mo yasoi aumoifaso na tomoi. Noko nokolaloso na piko taikiyo, nokonu nokonuso, totaini koloni na suo suomokano liyaiwumo.” ");
INSERT INTO amm_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Nosai no mo; Isiso mo na ikoki, “Ulai hani monoi nuwoimo? Koloni mo momaiyo na ponikowo.” ");
INSERT INTO amm_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Na imokino, “Koi mo koloni mo molopoi pakoso siso. Paluwa tuo komu mo naino siyai saso. La mo tiwoi.” ");
INSERT INTO amm_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Nosai no mo ikoki, “Isoni pa kiyo tumowo, yani auso.” ");
INSERT INTO amm_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nosai no mo; noko nokolalo mo na ikoki, “Sosono tonimai na posiwo.” Ikoki mo, paluwa tuo komu naino siyaiwoi la tiwoi akowaikoki, kumokiso you foinalikoki, wafisu imo na imoki, Apitonoso. Paluwa tuo na folouluki, siyokutono iyaliso na nikoki, noko nokolaloso wauti monoi. ");
INSERT INTO amm_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nosai no mo na no si liyaiki, noko nokolalo komaso noko mo. Touwai sisiyoli na toloko liyaiki. No waloto mo amai na siki, i molo tiwoiso na alokino. ");
INSERT INTO amm_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Noko molopoi molopoi mo 5000, na no siki. Fuwaluwouwoi pa kolalikinoso, apitono iyalisoso kolalikino. ");
INSERT INTO amm_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nosai no mo; lolai siyaso Isisoyo siyokutono iyaliso ikoki, “Ayou molosai toku na ponuwo, iwo toku ilo ausaimiso. Yo mo namolisai. Toku mo noko nokolaloso tokiyoko taikiyo.” ");
INSERT INTO amm_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Noko nokolalo kiyoko taikiyo uwai; nosai no mo; tota siyofoloso amiyoki, yuso, Kotowoi imo lukasa yoki. Folosumono mo aumoifaso tumoki mo, tota siyofoloso amai na you tolokainoki, yuso. ");
INSERT INTO amm_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ayousu mo iwo toku mulumai manokoki. Imonu mo amulusai usainiyaikalo tumoki. Iwo miyo ayou na alolomanikoki. ");
INSERT INTO amm_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Nosai no mo; posasi aumoifaso tanomai mo; Isiso mo siyokutono iyaliso monoi koka tumoki. Iwo toku iwo tonimai na liyaiyalo tumoki, fona molosai. ");
INSERT INTO amm_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Wiyou, iwo tonimai tumoso kwaikino mo, na kokolokoki, na umanokoki, piyamoki, popuwawo. Na omuwano manoki. ");
INSERT INTO amm_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ulai lolai siyaso na ikoki, “Mulu noiyo kolikaliyoiwo. Nisu mo asasu. Noiyo kokolokomoiwo.” ");
INSERT INTO amm_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Nosai no mo; Pitayo na fowaki, “Siyoli Nokota, a nonosu na? Nono no waliyo timononi yo no iwo tonimai no waliyo liyaiyoimo, nani auso no?” ");
INSERT INTO amm_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Isisoyo na imoki, “Waliyo na, kuku na potumo.” Nosai no mo; Pita mo ayousai na folamiyo konoki, iwo tonimai na manoki, Isisoni auso monoi. ");
INSERT INTO amm_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ulai imonuso kwaiki mo, na kokolomoki, iwoso na louwa popolufoliyo konoki, iwo mi siyoliyo louwa tukolo soliki. No monoi no mo siyoliso imaloki, Isisoso, “Siyoli Nokota, yo na pofasimono.” ");
INSERT INTO amm_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nosai no mo; lolai siyaso Pita mo Isisoyo nainosai na kominiyouki, na imoki, “Nono mo yoso mulumolo luwaimono mulu mo koufaso na. Ulai mulu tiwoi no hani monoi taluwaini?” ");
INSERT INTO amm_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ayouso kou koumuwaniyo yoki, toti mo. Ayouso kou koumuwaniyo yoki mo; imonu mo futo, futo nali. ");
INSERT INTO amm_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ayouso si noko mo tani siyoloso na molokimokino, imokino, “Motu nali no, nono mo Kotoni awitono nali.” ");
INSERT INTO amm_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nosai no mo; Isiso iyali mo iwo toku iwoso tokosiyaiyo tikino, Kinisali nokonuso komama tumokino. ");
INSERT INTO amm_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Nonani nokonu noko mo sai, na iyamoki, “Ni mo Isiso niya.” Nosai no mo imo na alomani liyaikino, komaso nokonu nokonu aumoifaso nokonuwoiso imo na ikalo manokino, no monoi no ai ai noko kiyokoma tumo liyaikino. ");
INSERT INTO amm_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Kiyokoma tumokino mo; na utolumalokino, “A, ai ai noko nokolalo no nani tuno unusai no waliyo komiyaloinimo?” Ikoki, “Waliyo.” No monoi no komiyalokino mo, waliyo na siki. ");
INSERT INTO amm_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Nosai no mo; nokotalo iyali mo tiki, Yolusolimo nokonu siyolisai. Falisi moloso aluwai noko siyaiwoi Musini imo sai sisiyoli noko siyaiwoi, toi mo Isisoni auso tiki, na ima tumokino, ");
INSERT INTO amm_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Moloi monoi woi, nani siyokuno iyali no tokumi moloso no hani monoi souwaiko liyaino, aniyopa iyaliyo no amokokaiyoukino no? Tono manono mo, naino mo iwoso pa tuluwako manonoso.” ");
INSERT INTO amm_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Nosai no mo; Isiso mo na fowakoki, “Moloi monoi momaini tokumi moloso no hani monoi taluwai manonuwo? Kotoni ami imoso no hani monoi tokulali manonuwo? ");
INSERT INTO amm_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kotoyo na yomukaiki, “Anoni apono noko tiso na pa kisosomikomoi.” Ninoino mani, yomukaiki, “Noko mo atino apitono noko tiso imo koiyau imo ikakimo, to mo na kalumo.” ");
INSERT INTO amm_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Moisu mo nonani imo mo kwaiwoi muwoi. Imo folo taiyoloko manonuwo, noko nokolaloso, noino. Noko mo muwoni mo yapoli mo, atino apitono noko ti fasiko muwoni mo, nonani muwoni mo waliyo Kotoso muwokononi monoi. Nonani nokotayo totiso ikakimo, “Moti fasikomo muwoni mo Kotoso muwokononikai,” momaiyo imoinuwomo, ");
INSERT INTO amm_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","“No mo waliyo na, tofolo anoni apono noko ti noiyo fasikoi.” Nonani mulu koiyau mulu mo taluwai manonuwo mo, no mo Kotoni imoso tokulali manonuwo. Momaini aniyopano iyalini tokumi molososo taluwaiyalo manonuwo. ");
INSERT INTO amm_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Moi mo topoko noko na. Kotoni mulu lukasiko nokota Aisaiya, to mo moi monoi motu na kumo unukaikinuwo, noino, ");
INSERT INTO amm_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Ninani noko nokolalo iyali mo asuwo asuwo tokisosomimono ifoluwaimonalo manono, totaini koyoso. Ulai yowoi mulu tomoso pa tosiso, aluwamai amai tosi. ");
INSERT INTO amm_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nokoni imo monoiso taiyolokalo manono, tifoluwaikalo manono, Kotoni imowo. No monoi no yani siyolo na tomoloki ifoluwaimonalo manono.” Motu imo mo Aisaiyayo aino na kumo unukaikinuwo.” Isisoyo mo aino na ikoki, nokotalo iyaliso. ");
INSERT INTO amm_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nosai no mo; nokotalo iyaliso iko uwai; Isiso mo noko nokolaloso aliyonikoki, totani auso ti monoi. Na ikoki, “Yani imo na pukwaimonowo, na posainowo. ");
INSERT INTO amm_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Noko mo hani haniso nokakimo, no mo tani mulu mo pa uwokaiyoiso. Ulai imo kopokoiyauso lukasakimo, no mo tani mulu mo na uwokaiyoimo.” Aino ikoki. ");
INSERT INTO amm_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nosai no mo; siyokutono iyali mo ima tumokino, “Nakomo nono mo sai na, Falisi moloso aluwai noko mo nani imoso no kwaimoni no, toi mo mulu na atolokomo ununi.” ");
INSERT INTO amm_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Nosai no mo; na ikoki, siyokawi imofa ikoki, “Yani Apou, kumokiso ni you tolokaino no, to mo isi mo yapoli na. Komaso aliyoli ali mo totayo mo ikaiwoi muwoi, no mo toti foiya na tolifoliyafoumoimo. ");
INSERT INTO amm_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Falisi noko mo tofolo, na pukwaikokaiwo. Toi mo molo mo kau kau. Toi no nokoso no moloi wiyoti monoi, molo no? Molo kau kau nokota ti, totati amu no molo no moloi wiyolukuwano monoi? Asi iso tomoso usukunalo konoimo.” Isiso mo aino ikoki. ");
INSERT INTO amm_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Nosai no mo; Pita mo Isisoso na imoki, “Siyokawi imo folosai na pako lukaso wiyomoko, koi saino monoi.” ");
INSERT INTO amm_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Isiso mo na ikoki, “Ya piyomu, saiwo. A, sosoli amai na tosinuwo? ");
INSERT INTO amm_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Nakomo moi mo sai muwoi, komaso koloni mo koso tonoko manonuwo mo, nomoliso na tosa konomoi. Tosa konomoi mo; tousai tomanokano manonuwo. No monoi no hani hani koloniyo mo mulu mo pa tuwokaikomo manonuwoso. ");
INSERT INTO amm_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Nokosu mo imo kopokoiyau imoso tolukasomoi mo, totani mulusai tomulumoloko, kosai na tamufu. Nonani hani haniyosu mo nokoni mulu na tuwokaiko manono, mulu na toliki tolikikokai. ");
INSERT INTO amm_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Kopokoiyau hani mo mulusaisu toti liyaimoi, noinosu nali no. Kopokoiyauso mulumolokalo mulu, noko tukuwoli mulu, noko kwami nukonu uwokaiso mulu, uloliyo mulu, polamoko mulu, noko siya monoi ifoluwai unu mulu, kali kalimikuwano mulu. ");
INSERT INTO amm_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nonani hani haniyo mo nokoni mulu na tuwokaiko manono, toliki tolikikokai na tosi. Nokosu mo koloni no mo naino uluwako somiso mo, no mo nokoni mulu uwokaikowoi muwoi.” Isiso mo aino ikoki, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Nosai no mo; Isiso mo nonani nokonusai utukaimoki, Taiya nokonu asiwoi Saito nokonu asiwoiso na manoki. ");
INSERT INTO amm_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Koinono asi nukonu mo nonani nokonu ti aumoifaso nokonuso na potolosoki. Isisoni auso na tumosoki, siyoliso na imaloki, “Siyoli Nokota, Toiwini nakosaitono. Na pofasimono. Mulu punumono. Popuwayo uwokaisokai, yani alu mo.” ");
INSERT INTO amm_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ulai fowasowoi muwoi. No monoi no tani siyokutono iyali mo na ima tumokino, “Noni to no mo siyoliso timo tolo manoni, na taluwaimokiyo tumo. Na piso taikiyo, ifou na manosu.” ");
INSERT INTO amm_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Nosai no mo; Isiso mo na ikoki, “Isolilo noko nokolalo mo sipo uo komiyai, samukuko nokota somiso tosimoi. No monoi no Kotoyo imono taikiyoki, toi samukuko monoi. Ninani nukonu mo Isolilo nukonu muwoi.” ");
INSERT INTO amm_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ulai nonani nukonu mo alokomu na losiyaiko sisa tumoki, na imoki, “Siyoli Nokota, na pofasimono.” ");
INSERT INTO amm_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Na fowasoki, “Alaloni koloni no moloi niko monoi, aluwouso no?” Siyokawi imo mo ainoso na isoki. Ulai afonimaiso? Afonimaiso muwoi. Yuto nokoyo tiyamo, “Noko nokonu noko mo aluwou komiyai. Isolilo noko koi saso mo Kotoni alalo.” No monoi no nonani imo na isoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ulai nonani nukonu mo na imoki, “Noko Siyoli, nani imo mo motu nali no. Ulai apitono iyaliyo koloni potikimonasi mo nusiso tusukunalo kono liyai mo, aluwouyo waliyo na tonoko manono.” ");
INSERT INTO amm_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Nosai no mo; Isiso mo na isoki, “Woli, waliyo na tomulumolo luwaimononi. Nani alu monoi imo mo yasoi na tukwaimonoki, popuwayo uwokaisokai imo mo.” Nomai no lolai niso waliyo na tolosoki. ");
INSERT INTO amm_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Nosai no mo; Isiso mo nonani asisai utukaimoki, Kalili iwo toku ilo kwasai manaloki. Nosai no yuso na yousa yoki. ");
INSERT INTO amm_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Noko nokolalo molopoi mo tani auso ukouniyaikokuya tumo liyai manokino. Fona nomoli nomoli nokowoi molo kau kau nokowoi naino fona kolukuwa kolukuwa nokowoi ko lopu nokowoi komaso ai ai noko molopoiwoi na kiyokoma tumo liyai manokino, Isisoni auso. Na ititounikaiyalo manoki. ");
INSERT INTO amm_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Wiyou, noko nokolaloyo na mulumoloko manokino. Ulai afonimaiso? Ko lopu nokoso imo lukasoso kwaiko liyaikino, fona kolukuwa kolukuwa noko mani, waliyo liyai siso na kwaikokino. Fona nomoli nomoli noko mani, waliyo liyaikino. Molo kau kau nokowoi mani, waliyo na foinaliko liyaikino. No monoi no Kotoni siyoloso kaluwaiyaloukino, Isolilo nokoni Koto na. ");
INSERT INTO amm_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Nosai no mo; Isiso mo siyokutono iyaliso aliyonikoki, na ikoki, “Yo mo ninani noko nokolalo monoi mulu tokalo uku. Tauno na sa tumoki. Koloni mo uwofa, toi mo. Yo mo koloni no somiso iko taikiyakimo, wonikaluso molomai molo folulumokoimo, tiyayo mo.” ");
INSERT INTO amm_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ulai imokino, “Ninani asi no ulai nokowoi? Ulai paluwa tuo no moiso i monoi, ninani noko nokolalo molopoiso niko monoi no?” ");
INSERT INTO amm_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Na ikoki, Isiso mo, “Moi no paluwa tuo komu no moloi moloi?” Fowakino, “Koi mo paluwa tuo komu mo nano siyawoi, 7. La lolofa mani, pounu muwoi, siyasonuso.” ");
INSERT INTO amm_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ulai Isiso mo noko nokolaloso na ikoki, “Asimai na posinona konowo.” ");
INSERT INTO amm_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ikoki mo; paluwa tuo komu nano siyawoi mo ikoki kusomi, la lolofawoi. Kotoso imoki, “Wafisu.” Folouluki mo, siyokutono iyaliso nikoki, nosai no toiyo noko nokolaloso na nikalokino. ");
INSERT INTO amm_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Na nokokino, noko nokolalo mo, touwai na siki. Touwai siki mo; no waloto mo amai, na isikokaiyalokino. I nano siyawoiso, 7, na alokino, siyokutono iyaliyo. ");
INSERT INTO amm_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Noko no nokino no, toi mo tiso tiso muwoi, molopoi molopoi, 4000. Ulai fuwaluwouwoi pakoso kolalikinoso. Noko saso kolalikino. ");
INSERT INTO amm_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Nosai no mo; Isiso mo noko nokolalo mo iko taikiyoki, totaini asiso ifou nu liyai monoi. Iko taikiyoki mo; ayouso folamiyo konoki, Makotani nokonu asiso monoi manoki. ");
INSERT INTO amm_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Nosai no mo; nokotalo iyali mo tiki, Falisi moloso aluwai nokowoi Satusi moloso aluwai nokowoi. Isiso mo louwa imo kiya tumokino, asuwo totaini molo timai kumokini mulu ifolaluwawoi mi ano wiyoti monoi. ");
INSERT INTO amm_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ulai na ikoki, “Kumoki mo upimosomai nakiyai tano mo, na tiyamo manonuwo, “Kumoki mo nakiyai na toi, fumu siyoli monoi.” ");
INSERT INTO amm_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Kumoki mo somosaimai nakiyai tano mo, na tiyamo manonuwo, “Kumoki mo nakiyai na totoi. Sa noi mo siyoli.” Wuo, motu na, moi mo kumokiso tukwaiko itouniyaimo manonuwo, no monoi no moi mo sai, sa tumowoi ulo wiwoi monoi. Yani mi ano mani, yasoi na tukwaimono manonuwo. Ulai hani monoi? Yo monoi mo moi mo sai muwoi. ");
INSERT INTO amm_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Lolaimai si noko nokolalo moi mo mulu kopokoiyau, Kotoso namoliyo talosimo manonuwo. Mulu ifolaluwawoi mi saso wiyononi monoi tiyo manonuwo. Ulai yo mo pa wiyononinoikuwoso. Kotoni mulu lukasiko nokota Iyona tolomai Koto mo mulu ifolaluwawoi mi wiyotiki, noko nokolaloso. Noinososu na wiyononinoikuwomo, yo mo.” Aino ikoki, na utukaikoki. ");
INSERT INTO amm_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Nosai no mo; Isiso iyali mo iwo toku iwo mulumai tokosiyaikaiyoukino mo, siyokutono iyali mo paluwa tuo mo iyo tumowoi muwoi, na fufolikokino. Nosai no mo; Isiso mo siyokawi imo ikoki, noko sisiyolini molo koiyau monoi. ");
INSERT INTO amm_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Noino na ikoki, “Atiyaiso, Falisi moloso aluwai nokowoi Satusi moloso aluwai nokowoi, toini paluwa tuo sisiyoliko asu monoi mo atiyaiso.” ");
INSERT INTO amm_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ulai toi mo imo folosai imo mo sai muwoi, no monoi no totai amu lukasikuwanokino, “Moi mo paluwa tuo mo pakoso iyo tumokoniso, no monoi no timoko.” ");
INSERT INTO amm_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ulai to mo sai, toini imo monoi mo, na ikoki, “Hani monoi moi no waliyo pa tomulumolo luwaimononuwoso? Hani monoi iyamonuwo, momai amu no, “Paluwa tuo mo uwofa.” ");
INSERT INTO amm_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nakomo moi mo imo folosai mo sai muwoi. Ulai moi no muluwoi? Paluwa tuo komu naino siyai monoi pa tomulumolokonuwoso, noko molopoi molopoi nokoyo, 5000, no nokono no. I no moloi moloi alokainuwo, no waloto no? ");
INSERT INTO amm_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Paluwa tuo komu nano siyawoi monoi mani, pa tomulumolokonuwoso, noko molopoi molopoi nokoyo, 4000, no nokono no. I no moloi moloi alokainuwo, no waloto no? ");
INSERT INTO amm_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Moloi monoi woi? Yo mo paluwa tuo monoi pa imonukuwoso. Ya na timonukuwo, atiyaiso pa siwo, Falisi nokowoi Satusi nokowoini paluwa tuo sisiyoliko asu monoi mo.” ");
INSERT INTO amm_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","No monoi no mo, toi mo sai, paluwa tuo sisiyoliko asu monoi pa ikokiso. Wiyou, Falisi nokowoi Satusi nokowoi toini imo monoi ikoki, atiyaiso si monoi. ");
INSERT INTO amm_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ulai nosai no mo; Isiso iyali mo Sisaliya Filipai nokonu asiso nuki. No mo tiki mo, siyokutono iyaliso na utolukoki, “Noko nokolalo no moloi tokaluwaimono manono? Asa, asi asi noko nokolaloni noko siyoli nokota yo no noi, woi?” ");
INSERT INTO amm_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Imokino, “Siyaiyo tokaluwai manoni, “Iyono iwoso uluwako nokota.” Siyaiyo tokaluwai manoni, “To mo Ilaiya.” Siyaiyo tokaluwai manoni, “To mo Iyolomaiya.” Siyai mo tiyamo, “Nakomo Kotoni mulu lukasiko nokota poimo, aniyopa nokota na.” ");
INSERT INTO amm_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Nosai no mo na ikoki, “Momaiyo no moloi tokaluwaimononuwo? Yo no noi, woi?” ");
INSERT INTO amm_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Nosai no mo; Saimo Pita mo na fowaki, “Nono mo Kolaiso, amai tolokaino nokota Kotoni awitono. Isolilo noko koi fasimoka tumo monoi na muwokaikini.” ");
INSERT INTO amm_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Nosai no mo; Isisoyo na imoki, “Saimo, Iyonani awitono nono mo na pomoloki. Asi nokoyo nonani imo pa posaso wiyononiniso. Kumokiso tolo nokota yani Apouyo mo na posaso wiyononini, nonani imo mo. ");
INSERT INTO amm_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ya timonoki. Nono mo Pita, nani siyolo imo folosai mo tomoki. Asayo noinomo yoso mulumolo luwaimono noko nokolalo mo ninani tomoki siyolimai amisoso na soimo. Sokolo Nokota Waini amiyo pa uwokaikoiso. ");
INSERT INTO amm_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Yani ami mo na aninoikimo. Noko mo nani imoso kwaimakinimo, Kotoyo na samukukoimo. Asini hani haniso alukikakinimo, Koto mani, kumokiso yo monoi na alukikoimo. Waliyo no yomakinimo, Koto mani, kumokiso yo monoi pa alukikoiso.” Pitaso aino na imoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nosai no mo; siyokutono iyaliso na ikoki, “Woli iyali, nokoso noiyo kaluwai wiyotiyoiwo, yani siyolo Kolaiso imo mo. Noiyo ikoiwo, “To mo Kotoyo muwokai nokota, Isolilo noko koi no fasimoka tumo no.” ");
INSERT INTO amm_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nosai no mo; Isiso mo totawoi imo ikoki, siyokutono iyaliso, tota uwo monoi aino imo. Na yomuki, “Yo mo Yolusolimo nokonu siyoliso na manoimo. No mo afonimaiso muwoi. Kotoyo ainonani monoi na imono taikiyoki. Nokoyo iyanoko siyoli na uwomonoinomo, nokotalo iyaliwoi lotu samukuko noko sisiyoliwoi Musini imo sai sisiyoli nokowoiyo. Na tukolomonoinomo, yau. Ulai amoloki tiwoi mo uwai; ulo siya mo ifou na auwoniyouwoimo, yausai.” Aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ulai Pitayo mo Isiso kominiyonoki, kwaso monoi. Imo amiso na imoki, “Siyoli Nokota, wiyou na tiyomu. Nonani haniyo mo pa uwoyoiniso.” ");
INSERT INTO amm_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ulai Isiso mo namoliyo alosimoki, Pitaso, na imoki, “Fuwoi, no mo Sokolo Nokota Waini imoso timononi. Nono mo yani mi louwa tufiyaimononi. Kotoni muluso pa taluwainiso. Nokoni mulusoso taluwaini.” Aino na imoki, Pitaso. ");
INSERT INTO amm_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nosai no mo; Isiso mo siyokutono iyaliso na ikoki, “Nokoyo yoso aluwaimono monoi yakimo, totani muluso no moloi aluwai monoi? Yo mo a moki sokunalomakoimo. Noinoso aluwaimono nokota mani, uo nokoyo uwoyakinomo, moloi ulosukomo monoi? Ulo ulo amoloki amoloki aluwaimonumo. ");
INSERT INTO amm_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Nokoyo totani au monoisu mulu unakimo, aniyopa poi poi moloi yousi itouniyaimo monoi? Na kaloimo. Nokosu mo yoso aluwaimono monoi kalakimo, pa kalokaiyoiso, aniyopa poi poi yousikaino itouniyaimo manoimo. ");
INSERT INTO amm_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Noko mo muwoni mi anakimo, asini sonosoni komasoso iyakimo, nonani haniyo no moloi fasi monoi? Kotoso mulumolo luwai somiso mo, na uwokaiyoimo. Nokoyo totani mulu ifou ano monoi no haniyo moloi suo suomoko unoimo? Wiyou, na uwokaikaiyoimo. ");
INSERT INTO amm_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Motu na, asa, asi asi noko nokolaloni noko siyoli nokota yo mo ifou amukonoimo, asiso, Apouni ami siyoliwoi. Yani kumoki nokowoi koliyo konoimo. Nomai no mo, suo foli monoi na ikaloimo, noko nokolalo siyasonuso. No tiyalo manono no, nonani foli monoi na ikaloimo. ");
INSERT INTO amm_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Yo mo motuwa na timonukuwo. Noko siyai ni si mo, toi mo kolikali somisomai you kimonoinomo, asa, asi asi noko nokolaloni noko siyoli nokota ya amukonoso. Motu na, samukuko nokota siyoli toloso kimonoinomo, kolikali somisomai.” Aino na ikoki, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Nosai no mo; amoloki toufo mo uwai; nosai no mo; Isiso mo noko tauwoi mo yu siyoli soposo koliyo yoki. Pitawoi Yamisowoi tani auwatono Iyonowoi toiso koliyo yoki. Totaiso na sa yoki. ");
INSERT INTO amm_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Sa yoki mo, au mo folo na alosimo taikiyoki, toini molo tiyo kikino mo. Tani amu molo mo ulo komiyai na wi toloki. Totani tunowoi mani, na kamoko taikiyoki, saponi topi. ");
INSERT INTO amm_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Wiyou, lolai siyasu, toku nokota ti, Musiwoi Ilaiyawoi tokuwa toku no kolikaliki no, toti mo Isisoni auso na tola tumokino. Imo lukaso ni toloso kokokino. ");
INSERT INTO amm_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pitayo nosoni kokoki mo, Isisoso na imoki, “Siyoli Nokota, nimaino mo waliyo tosikoni. Waliyo yomakinimo, yo mo fulomu nu tauwoi kololoimo, siya mo nani, siya mo Musini, siya mo Ilaiyani.” ");
INSERT INTO amm_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nonani imo yomu tolo manoki mo; kumoki kopuyo na fiyokaika konoki, kamoso siyoli. Ulai ko na mo kumoki kopu mulusai na tu kwaimokino, noino na yomuki, “Ni mo yani alu na. Yo mo na tomulu unumoi. Yani mulu mo waliyo, to monoi mo. Tani imo mo na pa kwaimo itouniyaimo manowo.” ");
INSERT INTO amm_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Nosai no mo; siyokutono noko tauwoi mo nonani imoso no kwaikino mo, ukuwoli sa konoki. Wiyou, na kokolokoki, na umomalotikoki. ");
INSERT INTO amm_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ulai Isiso mo kulola tumoki, na ikoki, “Na posauwo. Noiyo kokolokomoiwo.” ");
INSERT INTO amm_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nosai no na kwaikino, Isiso mo totaso toloso na kikino, noko tiso kokowoi muwoi. ");
INSERT INTO amm_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nosai no mo; yusai you kunoki, molomai imo amiso ikoki, “Yumai no kokonuwo no, noko nokolaloso noiyo ikaloiwo, ainoso asi asi noko nokolaloni noko siyoli nokota asa yausai ifou no auwoniyouwaki no, nomai no na pa posasokowo.” ");
INSERT INTO amm_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Nosai no mo; siyokutono noko tauwoi mo na imokino, “Musini imo sai sisiyoli nokoyo tiyamomoi, “Kotoyo muwokai nokota Kolaiso, to mo namolisai tumoimo. Kotoni mulu lukasiko nokota Ilaiya, to mo toku tumoimo, tota monoi.” Ulai hani monoi tiyamomoi?” ");
INSERT INTO amm_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Nosai no mo na fowakoki, “Motu nali no, Ilaiya mo ti monoi na tumumo, hani hani foukaiya tumo monoi. ");
INSERT INTO amm_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ulai ya timonukuwo. Ilaiya mo yasoi na tumo. Noko nokolalosu mo sai muwoi, tota monoi mo. Totaini mulusoso aluwaikokino, Ilaiya mo na uwokaikino. Noinoso tomoso nali, asa, asi asi noko nokolaloni noko siyoli nokota, yoso mani, na uwokaimonoinomo.” ");
INSERT INTO amm_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ikoki mo; siyokutono iyali mo sai, “Iyono iwoso uluwako nokota monoi timoko.” ");
INSERT INTO amm_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Nosai no mo; Isiso iyali mo noko nokolalo molopoiso koka konokino. Koka konokino mo, noko mo Isisoni auso na tumoki, alokomu losiyaiko yousa tumoki, ");
INSERT INTO amm_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","na imoki, “Siyoli Nokota, yani alu na pofasi, mulu punu. Tukwalu kwalumomoi. Wiyou, na tuwokai. Saiso saiso taso na totukaiya konomoi. Noinoso iwoso mani, saiso saiso tokalo solimoi. ");
INSERT INTO amm_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Yo mo nani siyokuno iyalini auso louwa kau, waliyo tolo monoi. Ulai itouniyaimokaiwoi muwoi. Sosoli nali no. Toi mo sai muwoi.” ");
INSERT INTO amm_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nosai no mo; Isiso mo ikoki, “Lolaimai noko nokolalo moi ni sinuwo mo, moi mo yoso mulumolo luwaimonowoi muwoi, moini mulu mo kwamu kwaimo muwoi, kopokoiyau. Moiwoi no moloi tolo tomasimoikuwomo? Ya tulosukomomono. Alu na pokawiyo tumowo.” ");
INSERT INTO amm_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Nosai no mo; popuwaso uo imo na imoki. Imoki mo; popuwa mo aluni ausai mo na utukaimoki. Lolai siyaso waliyo na tolo. ");
INSERT INTO amm_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Nosai no mo; namolisai siyokutono iyali mo ima tumokino, wosu wososu, na imokino, “Moloi monoi woi, koi no popuwa koiyau amiyaikiyowai sosoli no hani monoi?” ");
INSERT INTO amm_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Na ikoki, “Moi mo waliyo pa tomulumolo luwaimononuwoso, no monoi no popuwa koiyau amiyaikiyo monoi mo sosoli, moi mo. Yo mo motuwa na timonukuwo. Sipoki ali mo koufa nali. Noinoso koufasosu mulumolo luwaimonakinuwomo, yuso mo waliyo imoinuwomo, “Auso na pomoi.” No monoi no na manoimo, yu mo. Motu na, koufasosu mulumolo luwaimonakinuwomo, hani hani komaso mo waliyo na yalomano manoinuwomo. ");
INSERT INTO amm_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ninani popuwa koiyau ya no amiyaikiyo no, tota amiyaikiyo monoi mo noinososu, Kotoso utolumo saso, koloni au au simai.” Aino na ikoki, siyokutono iyaliso, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nosai no mo; Kalili asiso ukouniyaika tumo liyaiki, Isiso iyali mo. Siyokutono iyaliso na ikoki, “Asa, asi asi noko nokolaloni noko siyoli nokota yo mo uo nokoni auso na kiyomono taikiyoinomo. ");
INSERT INTO amm_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Na tukolomonoinomo, yau. Amoloki tiwoi mo uwai, ulo siya mo ifou na auwoniyouwoimo, yausai.” Tani imoso no kwaikino mo, mulu mo na kolikali unukino. ");
INSERT INTO amm_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nosai no mo; yasoi. Kopanaumo nokonu mo tiki, Isiso iyali mo. Tiki mo; lotu nu siyoli muwoni i nokoyo tiki, Pitani auso. No mo takiso muwoni i noko na. Pitaso na ima tumokino, “Nakomo moini aiyolokomo nokota no lotu nu siyoli muwoni no yapoli tonimoi, takiso muwoni i nokotaso?” ");
INSERT INTO amm_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pita mo ikoki, “Nasu, yapoli na tonimoi.” Isiso mo nu poiso toku yasoi lotiki. Pita mo lotiki mo, ulai lolai siyaso Isisoyo mo na imoki, “Saimo, na pukwaimono, siyokawi imo mo. Moloi tomulumolokoni? Asi asi samukuko noko sisiyoli no takiso muwoni no noiwo nokoso tuwoko manono, woi? Totaini alalo iyaliso poimo tuwoko manono. Noko nokolaloso poimo tuwoko manono.” ");
INSERT INTO amm_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pitayo fowaki, “Noko nokolalososu tuwoko manono.” Isiso mo na imoki, “Motu na, totaini alalo iyaliyo takiso muwoni pa toniko manonoso. Yo mo Kotoni alu na. Lotu nu siyoli takiso muwoni niko somiso mo, uo imo no moloi imono monoi, Koto no? ");
INSERT INTO amm_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ulai wonikaluso takiso muwoni i nokoyo uo mulu aiko atolokomo unumokoino. No monoi no iwo toku iwoso molosu na pafoliyano. Totawoi la asiyo yakinimo, ko na pa pokomiyaikoso, muwoni mo na kosoinimo, lani ko poiso. Nonani muwoni mo asakinimo, nokoso na pa asotiyano, motini takiso monoi.” ");
INSERT INTO amm_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nosai no mo; nonani ulomai siyokutono iyali mo Isisoso na ima tumokino, “Kumokiso you tolokaino nokotayo samukumoka tumakimo, totawoi nokota noiyo toloimo, siyoli tolo monoi no?” ");
INSERT INTO amm_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nosai no mo; Isiso mo aluso aliyoniki, imoki, “Koini auso na potolokaina tumo.” ");
INSERT INTO amm_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Siyokutono iyaliso na ikoki, “Motuwa na timonukuwo. Mulu alosoko somiso mo, kumokiso you tolokaino nokotayo mo pa samukukomoinuwoso. Alalo lolofani mulu komiyai si somiso mo, moloi samukukomo monoi, kumokiso you tolokaino nokotayo no? ");
INSERT INTO amm_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Noko mo ninani alu komiyai afonimaiso tolakimo, to mo totawoi na toloimo, kumokiso you tolokaino nokotayo samukukomomai mo. ");
INSERT INTO amm_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Mulumolo luwaimono nokotayo aluso imo mo, “Waliyo potumo,” to mo yoso mani, imono, “Waliyo na potumo.” Siyokutono iyaliso aino ikoki. ");
INSERT INTO amm_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ti monoi ikoki, “Noko mo mulumolo luwaimono nokotafaso aini ifoluwaiyakimo, wiyou, siyoliso na uwoyoimo, mulumolo luwaimono nokota aini ifoluwai foli monoi. Nokoyo iwo utaiso tukolo silakinomo, tomoki siyoliyo imo molomai konosuwakaiyakinomo, no mo koufasu. Mulumolo luwaimono nokota aini ifoluwai foli mo soliyakiso na uwokaiyoimo. ");
INSERT INTO amm_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Mulumolo luwaimono nokoso ainiko ifoluwaiko noko, woi, na tainiko manono, hani hani molo kopokoiyauso aluwaiko monoi. Asi asi ainiko ifoluwaiko noko, toi fau, atiyaiso na suomo. Motu na, amai na ainiko ifoluwaikalo manoinomo. Wiyouwa wiyou. No monoi no noko nokolalo mo molo kopokoiyauso nu liyaiyoimo. Wiyouwa wiyou. Molo koiyauso wiyoti nokota, to fau, atiyaiso na tolumo. ");
INSERT INTO amm_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Naino fonawoiyo molo koiyauso kalumaniyakinimo, na pa kokolo foliyafoumo taikiyo. Nonani naino fona no kalumanini no, nonaniwoi tolakinimo, no mo waliyo muwoi, wonikaluso aniyopa poi poi taso na afoli taikiyoinimo. Naino fonawoi kokolo foliyafoumakinimo, no mo waliyo, molo koiyauso pa aluwaiyoiniso, aniyopa poi poi toloinimo. ");
INSERT INTO amm_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Molo siyayo molo koiyauso kalumaniyakinimo, na pa solifoli taikiyo, nonani molo siya mo. Molo tiwoi tolakinimo, no mo waliyo muwoi, wonikaluso Sokolo Nokota Waini taso afoli taikiyoinimo. Molo siyaso solifoli taikiyakinimo, no mo waliyo, molo koiyauso pa aluwaiyoiniso, aniyopa poi poi toloinimo. ");
INSERT INTO amm_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Atiyaiso na posiwo. Alalo ni si no, toiso namoliyo noiyo alosikoiwo. Ya timonukuwo. Kotoni kumoki nokoyo no tosamukuko manono no, toi mo Apouni amu molo na toki manono, kumokiso you tolokaino nokotani amu molo mo. ");
INSERT INTO amm_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ulai afonimaiso? Asi asi noko nokolaloni noko siyoli nokota yo mo molo koiyauso aluwai nokoso na tofasika tumo, samiyaikiyo si monoi, aiko uwokaikoi.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Ulai ikoki, “Na pomulumoloko kiwo. Noko mo sipo koloni molopoi molopoi, 100, na tosamukukomoi. Ulai sipo siya mo na tolomuso, uwofa na, moiso poimo manoso. Nosai no mo, sipo samukuko nokota mo na tikolisalo. Sipo siyai mo, 99, yuso amai tutukaiko. Sipo siya na tikolisalo. Yani imo mo motu poimo. Na pomulumoloko kiwo. ");
INSERT INTO amm_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Motuwa na timonukuwo. Kosakimo, siyoliso na molokisoimo, nonani sipo no lomuso no. Wiyou, siyoliso na molokiso manoimo. Ulolo somiso sipo monoi koufaso tomolokiko. ");
INSERT INTO amm_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Noinoso nali, moini Apou, kumokiso ni you tolokaino no, to mo wiyou tiyomu, noko siyaiyo sofuwamokaiyou liyai monoi mo.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Ti monoi ikoki, “Mulumolo luwai nokota siyayo koiyaumakinimo, momatisu imo pa lukasiyoluwai kuwanowo, na pa ikimo. Nani imo kwaimakinimo, nonani nokota ifou na pa kausi, nani auwano na. ");
INSERT INTO amm_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Nani imo kwai somiso mo, mulumolo luwai nokota siya poimo, tiwoi poimo na pa koliso, tani auso pa koliyono. No monoi no mo Kotoni puko imoyo na tiyomuko, “Noko tiwoi tauwoi mo noko siyayo molo koiyauso aluwai monoi sai mo, imo tomoso tolukaso ununo mo, toini imo mo motu na. No kwaikakikonimo, imo na lukasokai monoi.” ");
INSERT INTO amm_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Moini imoso kwaimo somiso mo, mulumolo luwai noko komaso pa ikanowo. Mulumolo luwai noko komaso noko moini imoso mani, kulalikomakinuwomo, tofolo, to mo molo koiyau mulu saso aluwai nokota, muwoni i mulu saso nokota. ");
INSERT INTO amm_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Yo mo motuwa na timonukuwo. Asini hani haniso alukikakinuwomo, Koto mani, kumokiso yo monoi na alukikoimo. Waliyo iyamakinuwomo, Koto mani, kumokiso yo monoi pa alukikoiso. ");
INSERT INTO amm_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Imo siya na timonukuwo. Mulumolo luwai nokota ti moti asiso no tolokainonuwo no, moti mo hani ano mulu monoi Kotoso tomoso utolumakinuwomo, Apou, kumokiso ni you tolokaino no, totayo na yo unoinuwo mo. ");
INSERT INTO amm_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Motu na, noko tiwoi tauwoiyo yani siyoloso tomoso kaluwaimono sakimo, yo mo toini mulumai na tolokainoimo.” Aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nosai no mo; Pita mo Isisoso na ima tumoki, “Siyoli Nokota, auwa mo saiso saiso koiyaumomono mosakimo, yo no moloi moloi imo manoimo, “Yo mo imowoi muwoi.” Nano siyawoi mo waliyo poimo.” ");
INSERT INTO amm_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Isisoyo na imoki, “Nano siyawoimaisoso yo monoi muwoi, saiso saiso na pa imomoi, “Yo mo imowoi muwoi.” Aniyopa poi poi pa imomoi. ");
INSERT INTO amm_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ulai afonimaiso? Afonimaiso muwoi. Na pukwaimonowo, siyokawi imo na timonukuwo. Kumokiso you tolokaino nokotani samukukomo mulu mo noino. Samukuko nokota siyoli mo totani mi anononi nokoyo afonimaiso ilolu puwomosikino. No monoi no mo na tiko, “Afonimaiso ilolu uwomonomosi mo koma na. Lolai mo ilolu foli monoi mo muwoni mo koma na ponimonowo.” ");
INSERT INTO amm_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tiko mo; toku mo totawoi nokotaso tokiyoma tumono, tani auso. To mo ilolu foli monoi mo muwoni mo siyoli wiyou. Ulai koufa? Muwoni mo soliyaki nali no, 10000 kina. ");
INSERT INTO amm_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ulai moloi ni monoi, muwoni mo uwofa. No monoi no noko siyoliyo noko siyaiso tiko, “Ninani nokota mo na pokiyokanowo, tani fuwaluwouwoi, noko nokonu nokoni auso, toini mi anoti monoi, suo mo muwoni pa kiyo tumomonowo, tani afonimaiso ilolu i foli monoi. Tani ilolu komaso mani, na pa uwowo. No mani, afonimaiso ilolu i foli monoi.” ");
INSERT INTO amm_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","No monoi no mo, nonani mi ano nokota mo totani siyoli nokotani auso alokomu tolosiyaiko yousa tumo, na timalo, “Awi, na pa atotalimono, awi, amuwoi tinoso amai akononinoikimo, muwoni komaso mo.” ");
INSERT INTO amm_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Siyoli nokotayo mulu tokalo unu, na timo taikiyo. Afonimaiso ilolu i foli monoi mani, na talukimo, imo mo futo. ");
INSERT INTO amm_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ulai nonani mi ano nokota mo totani siyokutono, mi ano siyamai nokotaso na tokiya fu, imo molomai na tokomikai, imo amiso na timo, “Yani 10 kina na pamono, afonimaiso ilolu no i wamonokini no, nonani foli monoi na.” ");
INSERT INTO amm_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","No monoi no mo, siyokutono mo alokomu tolosiyaiko, na timalo, “Awi, na pa atotalimono, awi, amuwoi tinoso amai akononinoikimo, muwoni mo.” ");
INSERT INTO amm_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ulai to mo wiyou. Kalopulo nuso na tokiyo, ainoso hani muwoni akononi uwai, no monoi no amufoimo. ");
INSERT INTO amm_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Ulai mi ano siyamai noko iyali mo siyokutonoso no tukwaino mo, mulu tokolikali. Totaini siyoli nokotaso na timanono, ainonani monoi. ");
INSERT INTO amm_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","No monoi no mo, siyoli nokotayo nonani mi ano nokotaso taliyoni, na tikimo, “Nono mo mi ano nokota koiyau. Toku yasoi no imonaloni mo, ya na fasinoki. Afonimaiso ilolu i foli monoi mo yo mo na alukimonoki. ");
INSERT INTO amm_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Yo mo mulu ununoki, suomoso monoiso na fasinoki. Ulai nono no siyokuno mulu no pa ununiso, pa fasiniso?” ");
INSERT INTO amm_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Aino timo, mulu na tatolokomo, mi ano nokota monoi. Kalopulo nuso na tokiyo. Wiyou, iyanoko siyoli tuwo. Ainoso hani muwoni akononi uwai, no monoi no amufoimo. ");
INSERT INTO amm_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Noinoso moi komaso mani, auwano iyaliyo kopokoiyaukomo foli imo tokosokiko somiso mo, yani Apou, kumokiso ni you tolokaino no, to mo momaini molo kopokoiyau monoi na uwokaikomoinuwomo.” Isiso mo aino na ikoki, Pita iyaliso. ");
INSERT INTO amm_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Nosai no mo; ikoki mo; Isiso mo Kalili asiso utukaimoki, Yutiya asiso monoi na manoki. Yotano iwo tokosiyaikaiyo tiki, iwo ilo ausaimiso. ");
INSERT INTO amm_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Noko nokolalo molopoi mo aluwainiyo tumokino. Nonani asimai mo toini ai ai noko nokolalo na ititounikaiyalo tiki. ");
INSERT INTO amm_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Nosai no mo; Falisi moloso aluwai noko siyai mo na louwa imo kiya tumokino, “A, koini aniyopa molo no waliyo afonimaiso noni afolikaiso no? Au poimo.” ");
INSERT INTO amm_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ulai Isiso mo na fowakoki, “Nako moi mo ninani puko imo mo pa tokoko manonuwoso, noino no tiyomuko no, “Tokuwa toku, hani hani fonanikomo nokotayo nanomuwoi toniyoiwoi mani, na mulumolokoki, na tolokino.” ");
INSERT INTO amm_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Mulumolokoki mo; na yomuki, “No monoi no mo, sauwo nokota mo atino apitono noko tiso utukaikumo, kwamitonoso na kunaliyaisa tumumo. Toti mo au mo tomoso na, mulu mani, tomoso na totolono.” Aino na yomuki. ");
INSERT INTO amm_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","No monoi no au fofamo pa totolonoso, au tomoso na totolono. No monoi nosu mo Koto mo yasoi muwokokaiki, toti mo. Noko no moloi afolikaiso monoi?” ");
INSERT INTO amm_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ulai Falisi noko mo na imokino, “Moloi monoi woi? Musiyosu imo ami mo na imokokaiki, “Noko mo noni afolikaiso monoi yo mo, paso kumotisumo, na afolikaisumo.” ");
INSERT INTO amm_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ulai Isiso mo na ikoki, “Momaiyo kukamokokai manonuwo, no monoi no mo Musiyo waliyo yomuki, nokolalo salosokai monoi mo. Toku mo nonani molo mo tanowoi muwoi. ");
INSERT INTO amm_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ya ainonani monoi na timonukuwo. Nokoyo totani uloliyo somiso nukonu afolikaisakimo, noni siyaso kausakimo, to mo uloliyo nokota na.” Falisi nokoso ainoso na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Nosai no mo; siyokutono iyali mo na imokino, “Nono tiyomuni, noni kauso monoi mo aino na. Tofolo, ulai noniwoi no moloi kauso monoi?” ");
INSERT INTO amm_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Na ikoki, “Noko komaso noko mo ninani imo kwaiwoi muwoi. Wiyou, noko siyaisu mo Kotoni amiyo waliyo tiyamo, nokolalo koliko somiso monoi mo. ");
INSERT INTO amm_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Na pukwaimonowo, noko siyaisu mo tiyamomoi, nokolalo koliko mo tofolo. Siyai ni si mo, atino iyalini nomoliwoisai mo noko kopokoiyau, no monoi no mo nokolalo kolikowoi muwoi. Siyai mani, ni si mo, nokoyo au tokosonasikomo, no monoi no nokolalo kolikowoi muwoi. Noko siyai mo kumokiso you tolokaino nokotayo samukuko monoisu tomulumoloko manono, no monoi no nokolalo mo kolikowoi muwoi. Noko mo nonani imoso waliyo yomu mo, no mo waliyo, noni mo kausowoi muwoi.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nosai no mo; alalo lolofa koliyoniyo tumo liyai manokino, Isisoni auso, nainoyo kulolalo monoi, Kotoso utolumo uku monoi yokino. Ulai siyokutono iyaliyo mo uo imo na ikokino. ");
INSERT INTO amm_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ulai na ikoki, Isiso mo, “Tofolo na pukwaikokaiwo, alalo mo yani auso mo waliyo na tuo. Hani monoi talukikonuwo? Noko komaso noko mo ninani alalo komiyai no tosi no, toiso tosamukukomoi, kumokiso you tolokaino nokotayo mo.” ");
INSERT INTO amm_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ikoki mo; naino mo alaloni komumai na kulolaloki. Nosai no utukaikoki. ");
INSERT INTO amm_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Nosai no mo; noko siya mo Isisoso na ima tumoki, “Aiyolokomomoko nokota, yo no molo itouniyaimoso no moloi aluwaiyoimo, aniyopa poi poi yousi itouniyaimo monoi no?” ");
INSERT INTO amm_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ulai Isisoyo na imoki, “Itouniyaimoso aluwai monoi no hani monoi timononi? Noko itouniyaimo mo siyasoso. Yousi itouniyaimo monoi mulu yakinimo, Kotoni ami imoso na pa aluwaimoi.” ");
INSERT INTO amm_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ulai nonani nokotayo na imoki, “Yo no hani imo amiso aluwaikoimo?” Na imoki, “Nisu, noko mo noiyo tukoloi, noko kwami nukonu mo noiyo uwokaisoi, noiyo polamokoi, noko siya monoi noiyo ifoluwai unoi, ");
INSERT INTO amm_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","anoni apono noko tiso na pa kisosomikomoi. Nona amu mulu no tiyo manoni no, noko nokolalo monoi mani, noinoso na pa mulu ukumoi.” ");
INSERT INTO amm_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Nosai no mo; nonani alu sokuyo mo na imoki, “Nonani imo komaso mo yo mo yapoli na taluwaikomoi. A, yo no mulu siyaso monoi no yapoli yoimo?” ");
INSERT INTO amm_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Nosai no mo; Isiso mo na imoki, “Noko itouniyaima itouniyaimo tolo monoi tiyoni mo, nani ilolu mo ilolu somiso nokoso na pa wautiyalo, ilolu komaso mo. No monoi no suo foli monoi anoinimo, kumokiso. Wau niko uwai; yoso pa aluwaimoniyo tumo.” ");
INSERT INTO amm_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ulai alu soku no mo, to mo nonani imoso kwaikaiki, ilolu mulu na kaloki. Ulai afonimaiso nokota? Ilolu molopoi nokota nali. Isisoso utukaimoki, na manoki. ");
INSERT INTO amm_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nosai no mo; Isiso mo siyokutono iyaliso na ikoki, “Motuwa na timonukuwo. Ilolu molopoi noko no kumokiso you tolokaino nokotani auso no moloi toimo, asi no samukukaki no. Wiyou, nonani mi mo siyoli, muluso nali no. ");
INSERT INTO amm_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Siyokawi imo na pukwaiwo. Kamilo koloni siyoli no moloi lotiso monoi, iwoi nilini i poiso no? Moloi lotiso monoi, to mo sosoli. Ilolu molopoi nokota, to no Kotoni auso no moloi amiyo monoi, asi no samukukaki no? Moloi amiyo monoi, to mo sosoli. Ulai ya timonukuwo. Kamiloni mi, iwoi nilini i poiso lotiso monoi, nonani mi mo koufasu. Ilolu molopoi nokotani mi, Kotoni auso amiyo monoi, nonani mi mo soliyaki, muluso nali.” Siyokawi imo mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Siyokutono iyali mo nonani imoso kwaimokino mo, siyoliso kufaukoki, na imokino, Isisoso, “Ulai aino mo, noi nokotayo no waliyo no moloi amiyoimo, Kotoni auso no? Noi no samiyaikiyoimo?” ");
INSERT INTO amm_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Isiso mo kokaloki, na ikoki, “Nokoyo no ulai moloi yo monoi? Kotoyososu mo hani hani mo waliyo na tiyomoi.” ");
INSERT INTO amm_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nosai no mo; Pitayo imoki, “Koi mo kokaini asi yasoi na utukaikalokinoki, iloluwoi mani, utukaikalokinoki. Nonoso taluwainiyo tumonoki. Koi no suo foli monoi no haniso moloi iyoikimo, woi?” ");
INSERT INTO amm_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Na ikoki, “Motuwa na timonukuwo. Kumokiwoi asiwoi tonofalo tanomaiso asi asi noko nokolaloni noko siyoli nokota yo mo noko samukuko nokota siyoli na tola yoimo, kumokiso na yousa yoimo, ami siyoliwoi. Nomai no mo yoso aluwaimono noko iyali moi mani, samukuko noko sisiyoli na soinuwomo. Moini nasu wosuwoimai soimo, Isolilo asi molo tiwoi asi noko, 12. ");
INSERT INTO amm_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Mulumolo luwaimono noko mo hani hani utukaiko liyaiyakinomo, suo foli monoi mo siyoliso na nikoimo, ulai koufa, soliyakiso na nikoimo, aniyopa poi poi si itouniyaimoimo. Motu na, nu, auwatono iyali, inaitono iyali, apitono iyali, atino iyali, totaini alalo, isi, no mo utukaiko liyaiyakinomo, suo foli monoi na nikoimo. ");
INSERT INTO amm_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ulai lolaimai si nokotalo iyali mo afonimaiso na soimo. Afonimai noko mo sisiyoli na soimo.” Aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Nosai no mo; Isiso mo ulai ikoki, “Kumokiso you tolokaino nokotani samukukomo mulu mo noino. Isi kiyo nokota mo posasi yakomai nokoso tokolisano, siyawoiso tani isi mi anononi monoi. ");
INSERT INTO amm_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Imo tolukasokaino mo, waliyo na tiyamo, ulo siyani mi ano foli monoi mo kina siyasonuso niko monoi mo. Nosai no totani isiso mi ano monoi na tiko taikiyo. ");
INSERT INTO amm_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Nosai no mo; 9 kilo yakomai noko siyai mo ukouniyaikokai na tokoka tumo, afonimaiso siso. ");
INSERT INTO amm_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Na tiko, “Moi mani, yani isi mi na pananowo. Suo mo muwoni niyoikuwomo.” ");
INSERT INTO amm_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Na tonu. 12 kilo yakomaiwoi 3 kilo yakomaiwoi ainoso na, noko siyaiso tiko taikiyo. ");
INSERT INTO amm_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nosai no mo; upimoso 5 kilo yakomai na tokoka tumo, noko siyai mo afonimaiso siso. Na tiko, “Ulo siyoli no afonimaiso hani monoi sinuwo?” ");
INSERT INTO amm_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Na tofowano, “Nokoyo mi mo amokowoi muwoi.” Na tiko, “Moi mani, yani isi mi na pananowo.” ");
INSERT INTO amm_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Nosai no mo; amoloki mo, isi kiyo nokotayo mi samukuko nokotaso tima tumo, “Mi ano noko na paliyoniko, muwoni niko monoi. Toku mo 5 kilo yakomai ti nokoso poniko, ainoso 3 kilomai ti nokoso nikoini, 12 kilomai ti nokoso nikoini, 9 kilomai ti nokoso nikoini, topi topima mo posasimai ti nokoso pa niko.” ");
INSERT INTO amm_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Nosai no mo; 5 kilo yakomai ti noko mo kina siyasonuso tiya tumono. ");
INSERT INTO amm_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","No monoi no posasimai ti noko mo muwoni tiya tumono mo, na tiyamo, “Koi mo muwoni mo sisiyoli na iyoikimo.” Ulai wiyouwa wiyou, toi mani, kina siyasonuso na tino. ");
INSERT INTO amm_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tino mo; isi kiyo nokotaso amuwaso talino, na timono, ");
INSERT INTO amm_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","“Topimo ti noko mo asosasosofa mi ana tumono. Ulai toini muwoni koini muwoni komiyai tino. Ulai koisu mo posasi yakosai mi analo konalo manonoki, wiyou, ulo ta siyoliyo na iyolokomomokomoi.” ");
INSERT INTO amm_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ulai isi kiyo nokota mo siya nokotasoso na timo, “Woli, yo mo pa tokoiyaumonokiso. Moti mo waliyo na yomukaikoni, ulo siyani mi ano foli mo kina siyaso. ");
INSERT INTO amm_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nonani muwoni mo paso, na pomoi. Muwoni no ninukuwo no, noinoso na, topi topima noko mani, ainoso yasoi na niko. ");
INSERT INTO amm_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ni mo yani hani na. Nisu mo asani muwonisu na, asani muluyososo na toninukuwo, tomoso noinoso tiyalonuwo. Ulai hani monoi taliyoluwaimononi, amuwa no? Yosu mo noko niko monoi tiyo.” Aino timo. ");
INSERT INTO amm_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","No monoi no ya timonukuwo, kumokiso you tolokaino nokotayo samukukomomai mani, noinososu na. Namolisai ti noko mo suo foli mo toku iyoinomo. Toku ti noko, toi mo namolisai na iyoinomo.” ");
INSERT INTO amm_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Nosai no mo; Isiso iyali mo Yolusolimo nokonu siyoliso monoi nuki. Molomai mo siyokutono iyali kwasai koliyonoki, noko molo tiwoiso, na ikoki, ");
INSERT INTO amm_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Na pukwaiwo, konoi mo Yolusolimoso na tonukoni. Asa, asi asi noko nokolaloni noko siyoli nokota yo mo nokotalo iyalini nainoso kiyomonoinomo. Lotu samukuko noko sisiyoliwoi Musini imo sai sisiyoli nokowoi, toini auso na kiyomono taikiyoinomo. Imo na lukaso unumonokaiyoinomo, tukolomono imo monoi mo. ");
INSERT INTO amm_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Noko nokonu nokoni nainoso na kiyomonoinomo. Na alisiyoli yoluwaimonoinomo, noko nokonu nokoyo suwoi suwoi moloyo wasomonoinomo, a mokimai na ukou ukou nikomomonoinomo, yau. Amoloki tiwoi mo uwai; ulo siya mo ifou na auwoniyouwoimo.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nosai no mo; Sipitini awitono noko tini atino na tumosoki. Awitono noko ti mani, aluwaisiyo tumokino, Isisoni auso. Alokomu losiyaika sisa tumoki, na imoki, “Yani alalo ti na pofasiko.” ");
INSERT INTO amm_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Na isoki, “Hani yo uku monoi tiyoni?” Nosai no Isisoso na imoki, “Noko nokolalo samukuka tumakinimo, yani alalo ti ni mo, toti mo nonowoi yousikaino monoi tiyono. Siya mo nainasai siya mo sokonisai yousikaino monoi tiyono, noko sisiyoli ti tolo monoi. Nonayo piyomu.” ");
INSERT INTO amm_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ulai Isiso mo noko tiso na ikoki, “Nonani hani monoi no tutolumomononuwo no, moti mo sai muwoi. Moti mo aluwaimonakinuwomo, iyanoko sisiyoli uwokomoinuwomo, asa komiyai. Moti no waliyo?” Na imokino, “Koti mo waliyo.” ");
INSERT INTO amm_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Na ikoki, “Motu na, iyanoko sisiyoli na uwoyoinuwomo. Ulai yani auso yousi nokota ti muwoko monoi mo yani hani muwoi, nainasai yousikainowoi sokonisai yousikaino monoiwoi. No mo yani hani muwoi. Nonani yousi ti mo yani Apouyo noko ti monoi na foukaitiki.” ");
INSERT INTO amm_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nosai no mo; siyokutono iyali noko naino ti, toi mo nonani imoso kwaikino mo, siyokutono noko ti monoi mulu atolokomo ukukino. ");
INSERT INTO amm_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ulai Isiso mo aliyonikoki, na ikoki, “Moi mo sai, noko nokonu nokoni noko sisiyoli no tosamukuko manono no, toi mo totamiyoluwaiko manono, toini noko nokolaloso. Nokotalo iyali mani, talotoluwaiko manono, totaini nasu wosuwoimai no tosi no. ");
INSERT INTO amm_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Momaisu mo nonani moloso noiyo aluwaiyoiwo. Moi nokota mo siyoli tolo mulu yakimo, to mo moini mi ano fasikomo nokota na tolumo. ");
INSERT INTO amm_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Moi nokota mo totawoi nokota tolo mulu yakimo, to mo moini nasu wosuwoimai na tolumo, suomoso monoiso mi ano nokota nali. ");
INSERT INTO amm_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Noinoso asa, asi asi noko nokolaloni noko siyoli nokota yo mo moiyo fasimono monoi pa amukonokiso. Yo mo moi monoiso na fasikoma konokinukuwo, ifou kolisoikuwomo. Afonimaiso kolisowoi muwoi, suo mo na kalo unoikuwomo, no monoi no noko molopoi noko moi soinuwomo, aniyopa poi poi.” Isiso mo aino na ikoki, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Nosai no mo; Isiso iyali mo Iyoliko nokonusai utukaimokino. Noko nokolalo molopoi aluwaikiyo fukino. ");
INSERT INTO amm_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Molo kau kau noko ti mo molomai na yousikainokino. Isiso tumo imoso no kwaikino mo, siyoliso na imalokino, “Siyoli Nokota, nono mo Toiwini nakosaitono, koti mo na pomulu unumoko, na pofasimoko.” ");
INSERT INTO amm_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Noko nokolaloyosu ikikalokino, “Oi, wosu woso.” Ulai siyoliso amai na imalo manokino, “Siyoli Nokota, nono mo Toiwini nakosaitono, koti mo na pomulu unumoko, na pofasimoko.” ");
INSERT INTO amm_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nosai no mo; Isiso mo totini imoso no kwaika tumoki mo, na tomokima tumoki, na ikoki, “Moti no ya hani uwokomo monoi tiyonuwo?” ");
INSERT INTO amm_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nosai no mo na fowakino, “Siyoli Nokota, kotini molo ti poposasoulukomomoko, foinaliko monoi.” ");
INSERT INTO amm_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Isiso mo mulu kalo ukuki, nainoyo totini molo tiso na kuloliki. Lolai siyaso toti mo waliyo na tolokino, na foinalikokino, Isisoso na aluwaikino. ");
INSERT INTO amm_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Nosai no mo; Isiso iyali mo Yolusolimo nokonu siyoli aumoifaso tiki mo, Pitifaki nokonufaso fiyamosiya tumokino. Oli yu kiyoku kwamai toi. Tiki mo; nosai no Isiso mo siyokutono noko tiso na iko taikiyoki, ");
INSERT INTO amm_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","na ikoki, “Nokonufaso na pomanowo, na pa lotiwo, nokonu aumoifaso ni tokinuwo no. Lotakinuwomo, lolai siyaso na kokoinuwomo, hosofa uo atinowoi. Konosuwakokaiso kokoinuwomo, na pako fololokowo, yani auso na pako kiyokomomona tumowo. ");
INSERT INTO amm_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ulai nokoyo alukimakinuwomo, na pako imowo, “Siyoli Nokotayo timoko taikiyo, ninani hosofa ti kiyokomo monoi. To mo somaiso ifou amai kiyokomo taikiyoinimo.” Isiso mo aino na iko taikiyoki. ");
INSERT INTO amm_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","No mo afonimaiso pa fiyamosikiso. Kotoni imo motu tumo monoi na fiyamosikaiki, tani mulu lukasiko nokotayo toku no kumokaiki no, noino, ");
INSERT INTO amm_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Saiyono nokonu noko nokolaloso noinonani imo monoi na pako ikowo, “Na pukwaiwo, moini samukukomo nokota siyoli mo moini auso na totumo. Kukamokokai somiso nokota, hosofani namoli toni molosai na totumo, hoso uofani namoli toni molosai.” Aino tiyomuko. ");
INSERT INTO amm_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Nosai no mo; yasoi; siyokutono noko ti mo ninoino na yanokino, Isisoyo no ikoki no. ");
INSERT INTO amm_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Hosofa uo atinowoi mo na kiyokoma tumokino. Totini tuno ti mo hosofa tini namoli tonimai na isikokaiya yokino. Isikokaiya yokino; Isiso mo na yousikaina yoki. ");
INSERT INTO amm_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Nosai no mo; noko nokolalo molopoi molopoi noko mo tuno mo molomai asisikaiya tumo liyaikino, na soikai unalokino. Siyai mo iwasuwo mi tofu iyo tumokino, molomai na isikokaiya tumokino. To tumo monoi molokimokino, no monoi no yokino. ");
INSERT INTO amm_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Siyai mo toku toku tolono nikino, siyai mo namolisai tiki, na isalo niyalokino, siyoliso na iyamaloki, “Toiwini nakosaitono monoi na tomolokimokoni. Ninani nokota, Noko Siyolini amimai ni totumo no, tani siyolo na tokaluwaiyaloukoni. Siyoliya Nokotani siyoloso na tomolokimokoni.” Aino iyamaloki. ");
INSERT INTO amm_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Nosai no mo; Yolusolimo nokonu siyoliso monoi lotiki. Tolomu si noko nokolalo mo kufaukoki, na iyamaloki, “Ni no noi nokota, woi?” ");
INSERT INTO amm_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Aluwainiyo tumo noko nokolaloyo na ikokino, “Nisu mo Isiso, Kotoni mulu lukasiko nokota, Kalili asi mulumai nokota, Nasolito nokota nali.” ");
INSERT INTO amm_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Nosai no mo; Yolusolimo lotiki mo; Isiso mo lotu nu siyoliso lotiki. Hani hani suo suomoko noko iyaliso na amiyaikiyoko taikiya tiki. Muwoni suo suomoko nokoni kotisokoso na alokwi wati taikiyoki. Anomu suo suomoko nokoni sinono hani mani, na alokwi wati taikiyoki. ");
INSERT INTO amm_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Na ikoki, “Kotoni puko imoyo mo na tiyomuko, “Yani nu mo asaso utolumomono nu na kaluwaiyoinomo.” Ulai moisu mo noko nokolaloni muwoni ti wati manonuwo. Wiyouwa wiyou, ni mo moini polamoko nu muwoi.” ");
INSERT INTO amm_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Lotu nu siyoli poiso amai potu yousikainoki, noko kopokoiyauyo kiya tikino. Molo kau kau nokowoi fona nomoli nomoli nokowoi na ititounikaiki, Isisoyo mo. ");
INSERT INTO amm_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ulai nokotalo iyaliyo mulu atolokomo unukino, lotu samukuko noko sisiyoliwoi Musini imo sai sisiyoli nokowoi. Mulu atolokomo unukino. Ulai afonimaiso? Mulu ifolaluwawoi mi anoso kwaikino. Wiyou, tani mi mo wiyou. Alaloni isaloso kwaikokino, no tu iyama liyoumoki no, lotu nu poiso, “Toiwini nakosaitono monoi na tomolokimokoni.” Nosoni kwaikalokino mo, mulu atolokomo unukino, ");
INSERT INTO amm_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","na imokino, “Alaloni imo no yapoli tukwaikoni?” Nosai no mo; Isiso mo na ikoki, “Wuo, yapoli na kwai. Nakomo ninani puko imo mo kokowoi muwoi, noino, “Nonayo noinomo paumai alaloyo na tokisosomini. Alalo mala iyali mani, nani siyolo na tokaluwaiyalouni.” ");
INSERT INTO amm_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ikoki mo; na utukaikoki, nokonu siyoliso utukaimiyo fuki. Pitano nokonuso tananoki, tanuwou mo. ");
INSERT INTO amm_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Nosai no mo; posasi; Isiso mo nokonu siyoliso monoi ifou tumoki. Tiya na uwoyalo tumoki. ");
INSERT INTO amm_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Molomai sipoki a mo na kosa tumoki, molo kwamai. Aumoifaso amunoki, na kosoki, ulai wamowoi muwoi, suwo saso. Nosai no mo sipoki aso na isoki, “Wamowoi noiyo si manoi.” No monoi no a mo lolai siyaso na somosoki. ");
INSERT INTO amm_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Siyokutono iyali mo nonani aso kosokino mo, na mulumoloko manokino, na iyamoki, “Moloi woi? Sipoki a no lolai siyaso no moloi tosomoso taikiyo, woi?” ");
INSERT INTO amm_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","No monoi no mo, Isiso mo na fowakoki, “Motuwa na timonukuwo. Yoso waliyo mulumolo luwaimonakinuwomo, moi mani, noino na yoinuwomo, ya sipoki aso ni tiso no. Mulu tiwoi si somiso mo, waliyo na yoinuwomo. Ulai ni saso pa yoinuwoso. Yu ni tolo no, nosoniso imakinuwomo, “Mamo iwo siyoli mulumai potolano,” yu mo na tolanoimo. ");
INSERT INTO amm_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Yoso mulumolo luwaimono noko moiyo hani ano monoi utolumomonakinuwomo, nonani hani mo waliyo na anoinuwomo.” ");
INSERT INTO amm_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Nosai no mo; Isiso mo lotu nu siyoli poiso aiyoloka tiki. Lotu samukuko noko sisiyoliwoi Isolilo nokotalo iyaliwoi, toi mo kiya tumokino, na imokino, “Noini amiyo nonani mi ano monoi no? Noiyo imo taikiyokini?” ");
INSERT INTO amm_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Na fowakoki, “Yo mani, imo siya utolumo monoisu na tiyo. Yani imoso fowamonakinuwomo, suo foli monoi mo imono taikiyo nokota monoi aino imo na imoikuwomo. ");
INSERT INTO amm_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Iyono mo nokoso uluwako manoki, iwoso. No mo asini hani poimo, kumokini hani poimo. Moloi tiyamonuwo, na pimonowo.” Nosai no mo; totai amu imo lukasikuwanokino, na iyamoki, “Moi mo iyamakikonimo, “No mo kumokini hani nali no,” to mo imokoimo, “Hani monoi totani imoso pa mulumolo luwaikinuwoso?” ");
INSERT INTO amm_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ulai iyamakikonimo, “No mo asini hani nali no,” noko nokolalo monoi na kokolokomomokoimo. Ulai afonimaiso? Toi komaso mo Iyonoso waliyo mulumolo luwaikino, tiyamo, “Kotoni mulu lukasiko nokota.” ");
INSERT INTO amm_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Totai amu lukasikuwanokino mo; Isisoso na imokino, “Koi mo sai muwoi, Iyono no iwoso uluwako no noini amiyo, woi? Noiyo poimo imo taikiyoki.” Nosai no mo ikoki, “Noinoso na, yo mo pa imoikuwoso, yo mani, noiyo poi imono taikiyoki, yani mi ano monoi mo.” ");
INSERT INTO amm_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Nosai no mo; Isiso mo nokotalo iyaliso siyokawi imo na ikoki, “Moloi tomulumolokonuwo? Alalo tiwoi nokotayo toku aluso na timano, “Isi mi na panano.” ");
INSERT INTO amm_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ulai awitono mo tukwali, wiyou tiyomu. Ulai namolisai ti monoi tomulumoloko, na tomoi, isi mi ano monoi mo. ");
INSERT INTO amm_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Apitonoyo namolisai aluso mani, tomoso noinoso na timano, isi mi ano monoi mo. Na timo ifoluwai, “Apou, waliyo na.” Ulai manowoi muwoi. ");
INSERT INTO amm_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nonani alalo ti no apitononi imo no noiyo taluwai itouniyaimo? Toku aluyo poimo namolisai aluyo poimo.” Nosai no mo; na tiyamo, “Toku alu mo na tukwaimo itouniyaimo, apitononi imo mo.” Nosai no mo na ikoki, “Ya motuwa na timonukuwo. Takiso muwoni i noko kopokoiyauwoi uloliyo nokolalo kopokoiyauwoi mo, toi mo nonani toku alu komiyai, mulu alosokokai, no monoi no toku na toimo, Kotoni auso mo, totayo samukukoimo. Moi mo namolisai na toinuwomo. ");
INSERT INTO amm_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ulai afonimaiso? Iyonoyo toku yasoi na wiyononi manokinuwo, molo itouniyaimo mo, ulai moi mo tani imoso mo kwaimo itouniyaimowoi muwoi. Noko kopokoiyausu, takiso muwoni i nokowoi uloliyo nokolalowoi, toi mo Iyononi imoso na kwaimo itouniyaimokino. Toiyo mulumolo luwai yapoli kokalokinuwo, ulai mulu mo alosokowoi muwoi, moi mo, mulumolo luwaiwoi muwoi.” Aino ikoki, nokotalo iyaliso. ");
INSERT INTO amm_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Nosai no mo; ti monoi na ikoki, “Siyokawi imo siyafa na pukwaiwo. Isi kiyo nokota mo aliyoli ali na tikaiyalo. Ikai uwai; tokoki fiyaikalo. A wamo kunoliko monoi asi i taikalo, isi poiso. Samukuko nokotani nu sopofa tokononikai. Nosai no isi mi ano nokoso na tikano, “Yani isi na posamukumonowo.” Ikano mo; noko nokonu nokoni asiso na tomoi. ");
INSERT INTO amm_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Nosai no mo; wamoko popo mo aumoifaso totana tumo mo, nomai no mo mi ano nokoso na tiko taikiyo, “Isini no na pimonanowo.” ");
INSERT INTO amm_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ulai isi samuku nokoyo na tuwokono, tani mi ano nokoso no tiko taikiyo no. Siya mo tuwasono, siya mo totukolono, yau, siya mo tomoki tosalosomono. ");
INSERT INTO amm_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","No monoi no isi kiyo nokota mo mi ano noko siyai na tiko taikiyo. Toku komiyai muwoi, ni mo noko molopoi tiko taikiyo. Ulai isi samuku noko mo ainoso tomoso na tuwokaiko wanonino. ");
INSERT INTO amm_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Namolisai mo totani awitonoso na timo taikiyo, tiyomu, “Yani aluso auwosiwaiyoinomo.” ");
INSERT INTO amm_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ulai isi samuku nokoyo awitono tumoso tukwaino mo, totai amu tikuwanono, “Anunani nokota mo amuwoi tino mo apitononi isi kwalomai monoi na anoimo. Moi soi, niya totukolokoni. No monoi no momaini na ano monoi, ninani isi mo.” ");
INSERT INTO amm_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ikuwanono; awitonoso na tokomikaino, asiyofoloso tafoliyo funo, na totukolono, yau. ");
INSERT INTO amm_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ulai moloi tomulumolokonuwo? Nonani isi kiyo nokotayo tumakimo, moloi poimo uwoka tumoi, isi samuku noko iyaliso mo.” ");
INSERT INTO amm_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Nosai no mo na imokino, “Nonani noko kopokoiyau noko mo na uwokaika tumoimo. Noko siyaiso na atiyoimo, isi mo, toiyo na samukuyoinomo. Isini no siyai mo isi kiyo nokotaso na niwumo, wamo wamoko popomai.” ");
INSERT INTO amm_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Nosai no mo; Isiso mo na ikoki, “Nakomo moi mo Kotoni puko imo siyaso mo kokowoi muwoi. Ninoinosu niya tiyomuko, “Nu kololi nokoyo a moki mo afoli taikiyokino, piyamoki, afonimai a koiyauwo. Ulai Siyoli Nokotasu mo nonani a moki na ikaiki, sopo i a na. Koiyo tokinoki mo, no mo itouniyaimo nali no.” Aino tiyomuko. ");
INSERT INTO amm_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","No monoi no ya timonukuwo, Koto mo samukukomo monoi louwa tiyomoi, ulai wiyou tiyamo manonuwo. Pa samukukomoinuwoso. Noko siyaisoso na samukukoimo. Molo itouniyaimoso aluwaiyalo manoinomo. Toi mo a komiyai, a wamo ititouniwoi no saki no. ");
INSERT INTO amm_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ya timonukuwo, noko mo nonani sopo i asai kitolomo taikiyakimo, uwokaikaiyoimo. Nonani ayo nokoso itokolimakimo, to mo kolisoulukai anoinomo. Yo mo nonani a komiyai.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Lotu samukuko noko sisiyoliwoi Falisi moloso aluwai nokowoi, toi mo Isisoyo siyokawi imo ikoso na kwaimokino, iyamoki, “Koi monoi na tiyomu unumokokai.” ");
INSERT INTO amm_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kominalomano monoi louwa fi, ulai noko nokolalo monoi nikokino. Noko nokolaloyo piyamoki, “Isiso mo Kotoni mulu lukasikomomoko nokota.” ");
INSERT INTO amm_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Nosai no mo; Isiso mo siyokawi imo siya na ikoki, ");
INSERT INTO amm_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Kumokiso you tolokaino nokotani samukukomo mulu mo noino. Samukuko nokota siyolini awitono mo noni kausoimo. No monoi no apitono mo koloni tofoukaimoi, noko nokolalo wasiya tumo monoi. ");
INSERT INTO amm_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Toku wolitono iyaliso na ikokaiki, noni kauso wasi koloni no sa tumo monoi mo. Foukai uwai; koloni wasi popomai totani mi ano nokoso tiko taikiyo, “Yani woli iyaliso na paliyonikalowo.” Ikalokino mo, ulai toi mo tiwoi muwoi, wiyou na tiyamo liyaiyalo. ");
INSERT INTO amm_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Nosai no mo; ti monoi mi anononi noko siyaiso na tiko taikiyo, “Toku ya no aliyonikokaiki no, nonani nokoso na pokolisalowo. Na pa ikowo, “Koloni mo yasoi na foukai. Polomoko nanomu siyaiwoi koloni sokoma sokoma koloniwoi yasoi na tukuwolikai. Komaso hani hani mo yasoi na foukai. Kukuwo, noni kauso wasi koloni na pona tumowo.” ");
INSERT INTO amm_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Nosai no mo; iko uwai; mi ano nokoyo nonani imo tikalo manono. Ulai imo mo kwaikowoi muwoi. Siyai mo totaini isiso tonu liyai, siyai mo muwoni suo suomoko monoi tonu liyai. ");
INSERT INTO amm_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ulai siyai mo tani mi anononi noko tiko ukoukukou, na tuwokalono, na totukuwolino, yau yau. ");
INSERT INTO amm_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Wiyou, siyoli nokota mo mulu na tatolokomo, totani polimano iyaliso na tiko taikiyo, “Na potukuwoliyanowo, mi ano noko tukuwoli nokososo. Nu tawoi na paliko ukanowo.” Iko uwai; ainoso na tiyanono. ");
INSERT INTO amm_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Nosai no mo; Siyoli Nokota mo totani mi ano noko siyaiso na tiko, “Noni kauso koloni mo yasoi na foukai. Ulai noko mo ya no louwa aliyonikoki no, toi mo noko ititouni muwoi, tiwoi muwoi. ");
INSERT INTO amm_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","No monoi no molo touwokonikoso pofoukano liyaiwo. Komaso nokoso kwaikakinuwomo, na pa aliyonikowo, noni kauso wasi koloni no monoi na tuomo.” ");
INSERT INTO amm_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Iko uwai; nonani mi ano noko mo molomai si noko nokolaloso na tokolisalo liyaino. Noko kopokoiyau nokowoi noko ititouni nokowoiso na tokolisalo liyaino. Noni kauso wasiso tukouniyaiko sa tumo liyai. Wiyou, noko molopoi mo ukouniyaikokai, nu mo noko nokolalo saso. ");
INSERT INTO amm_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Noko nokolalo molopoi mo koloni tuwasi sinono. Amai wasi si mano mo, siyoli nokota mo tokoka ti. Noko yousiso mo na toki, noni kauso monoi moloki tuno itouniyaimoso asisiwoi muwoi. ");
INSERT INTO amm_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Siyoli nokotayo na timo, “Woli, hani monoi noni kauso monoi moloki tuno no pa asisiyo tumoniso? Moloi loti monoi, nono no?” Ulai imo lukasowoi muwoi, na tauwosimo. ");
INSERT INTO amm_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ulai mi ano nokoso na tiko, “Naino fonawoi na pokonosuwakomowo. Asiyofoloso na pa afoliyo fuwo, folosumaiso tofolo fu tolumo. Wiyou, na soni toloimo, iwoi sisikomo toloimo.” Aino tiko. ");
INSERT INTO amm_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Motusu na, Kotoyosu mo noko molopoi taliyonikomoi. Tani auso ti monoisu mo siyasonuso na muwokokai.” Aino ikoki, nokotalo iyaliso. ");
INSERT INTO amm_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nosai no mo; Falisi moloso aluwai noko iyali mo totai amu imo lukasikuwanokino, “Isisoni imo monoi tukwailuwaimokoni. Imo koiyau imoso yomakimo, komanoso na faumikano monoi.” ");
INSERT INTO amm_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Imo lukasikuwanokino mo; aluwaikalo mano nokowoi Hiloni nokowoiso iko taikiyokino. No monoi no Isisoso mo na ima tumokino, “Aiyolokomomoko nokota, koi mo sai, nono mo imo motu imo nokota nali no. Kotoni molo monoi na taiyolokalo manoni. Motu imo saso na tiko manoni. Nonoso no moloi aini monoi, nokoyo no? Imo alinoso na tiko manoni, noko sisiyoliwoi afonimai nokowoiso. ");
INSERT INTO amm_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","No monoi no mo na pimoko, nono no moloi tomulumolokoni? Moi no takiso muwoni no waliyo toni manokoni, Lomo nokota siyoliso no, Sisiso no? Wiyou poimo.” ");
INSERT INTO amm_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ulai Isiso mo sai, toini mulu kopokoiyau monoi mo. Na ikoki, “Moi mo topoko noko. Hani monoi louwa tainimono ifoluwaimononuwo? ");
INSERT INTO amm_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Takiso nokotaso asononi muwoni na powiyosomonowo.” Tomoki muwoni wiyosononikino. ");
INSERT INTO amm_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Na ikoki, “Komuwoi muwoni, noini na, woi? Noini siyolowoi taso?” ");
INSERT INTO amm_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Na imokino, “Sisi, Lomo nokota siyolini nawoi siyolowoi taso.” Nosai no mo na ikoki, Isiso mo, “Sisini hani mo Sisiso na poniwo. Kotoni hani mo Kotoso na poniwo.” ");
INSERT INTO amm_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tani imoso kwaimokino mo, na mulumoloko manokino. Na nuki, utukaimokino. ");
INSERT INTO amm_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nosai no mo; lolai siyaso Satusi moloso aluwai noko mo Isisoso ima tumokino. Toi mo noko no mo, no tiyamomoi no, “Yau yau noko mo ifou pakoso auwonouloiso.” ");
INSERT INTO amm_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Isisoso na ima tumokino, “Aiyolokomomoko nokota, Musini aniyopa imoyo mo noino na tiyomuko, moi monoi mo. Noniwoi nokota mo ali somisomai kalo mo, tani noni mo auwatonoyo na kausumo, to kwalomai monoi. Alu kiyakinomo, nonani alu mo auwatono kwalomai monoi na tolumo. ");
INSERT INTO amm_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Koi timonoki, noino, toku auwa auwa noko iyali nano siya, 7 na siki, koini mulumai. Imu alu mo noni na kausoki, ali mo kiwoi muwoi, nosai no mo yau. No monoi no auwatono kwalomai monoi na kausoki, Nokiyamoyo. ");
INSERT INTO amm_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","To mani, ali mo kiwoi muwoi, yau. Noino noinoso nali no. Yamu alu mani, nonani nukonu kausoki, yau. Imaliwoi Imamuwoi Imowawoi Liyaliwoi, toi komaso mo nonani nukonusoso na kausalo manokino, ulai aliwoi kokowoi muwoi, yau yau. ");
INSERT INTO amm_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Namolisai mo nonani nukonu mani, yau, yasoi na kalosoki. ");
INSERT INTO amm_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ulai yau yau noko mo ifou auwonoulakimo, nonani nukonu no noini kwamitono tolosoimo, noiyo kausoimo? Toku nano siyawoi auwatono noko koli koliyo kausalo manokino.” ");
INSERT INTO amm_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Nosai no mo; Isiso mo na fowakoki, “Moi mo Kotoni puko imo mo sainowoi muwoi. Kotoni ami mani, sainowoi muwoi. No monoi no afonimaiso na tiyamonuwo. ");
INSERT INTO amm_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Yau yau noko nokolalo auwonoulakimo, toi mo pa kolikuwanoinoso. Kotoni kumoki noko komiyai na soimo, susauwoso. ");
INSERT INTO amm_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ulai yau yausai ifou auwonoulu monoi ya na timonukuwo. Nakomo moi mo ninani puko imo mo kokowoi muwoi, toku Kotoyo no imokinuwo no. Toku kolikali noko monoi noino na tiyomuko, ");
INSERT INTO amm_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Yo mo Apolofamoni Koto, Isakoni Koto, Yokoponi Koto nali no.” Koto mo kolikali nokoni Koto muwoi, amai si nokoni Koto na. No monoi no nonani noko iyali mo pa kolikalikaikiso, yausai ifou na auwonouluki.” ");
INSERT INTO amm_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Noko nokolaloyo Isisoni imo no kwaimokino mo, na kufaukoki, iyamoki, “Hani imo taiyolokomomoko, woi?” ");
INSERT INTO amm_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Isiso mo yausai auwonoulu imo ikoki mo, Satusi moloso aluwai noko mo imo mo tototuo. Nosai no mo, ainonani monoi kwaikino mo, Falisi moloso aluwai noko iyali mo tani auso ukouniyaikokuya tumokino. ");
INSERT INTO amm_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Toi nokota siya, aniyopa imo sai siyoli nokota na, to mo Isisoso na utolumo kiki, ");
INSERT INTO amm_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Aiyolokomomoko nokota, Musiyo no posasokoki no, hani ami imoyo tosouwaiko, ami imo siyaiso no?” ");
INSERT INTO amm_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Nosai no mo; Isiso mo na imoki, “Puko imoyo tiyomuko, “Koto monoi mulu punu. Noko Siyoli, nonani Koto monoi, mulu siyoliso na pa unu. Na pa mulumoloko unu.” ");
INSERT INTO amm_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","No mo imo ami itouniyaima, hani hani imo siyaiso na tosouwaiko. ");
INSERT INTO amm_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Imo siya mo totawoi imo komiyai na. Noino, “Nona amu mulu no tiyo manoni no, noko nokolalo monoi mani, noinoso na pa mulu ukumoi.” ");
INSERT INTO amm_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Nonani imo ti ni mo, no mo tonofalo hani muwoi. Musini ami imowoi Kotoni mulu lukasiko nokoni imowoi, toini imo folosai mani, tomoso noinoso na, Kotoso mulu unu na, noko nokolaloso mani, mulu uku na.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Nosai no mo; Falisi moloso aluwai noko mo amai ukouniyaiko siki mo, Isiso mo utolukoki, ");
INSERT INTO amm_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Moi no moloi tomulumolokonuwo? Kolaiso no noini alu, woi, nokosu no no Isolilo noko moi no fasikomakinuwo no, to no noini alu?” Na imokino, “Toiwini nakosaitono.” ");
INSERT INTO amm_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Na ikoki, “Moloi monoi woi? Kotoni Mulu Itouniyaimo Nokotayo noinomo Toiwi mo tani nakosaitono monoi mo Siyoli Nokota na kaluwaiki. Na yomuki, Toiwi mo, ");
INSERT INTO amm_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“Siyoli Nokotayo yani Noko Siyoliso na imoki, “Yani nainasai na piyousikaino. Yousikaino manakinimo, ainoso hani nono uo noko mo nani fona wosuwoimai na soimo, yani amiyo noinomo.” ");
INSERT INTO amm_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Na pomulumolokowo. Toiwi totayosu mo kaluwaiki, Noko Siyoli na. Moloi monoi woi? Ulai Toiwini nakosaitonosu no?” ");
INSERT INTO amm_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ulai noko mo fowawoi muwoi. Utolumo monoi nimo manokino, pa utolumo manokinoso. ");
INSERT INTO amm_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nosai no mo; Isiso mo siyokutono iyaliwoi noko nokolalowoiso imo na ikoki, ");
INSERT INTO amm_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Musini imo sai sisiyoli nokowoi Falisi moloso aluwai nokowoi, toi mo Musi kwalomai monoi na tosimoi, Kotoni imoso taiyolokomo manonuwo. ");
INSERT INTO amm_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","No monoi no toini imo komasoso na pa kwaiko manowo, na pa aluwaiko manowo. Ulai totaini molo no taluwai manono no, nonani moloso mo noiyo aluwaikoiwo, tofolo. Imo motu imo itouniyaimo na tolukasikomo manonuwo, ulai aluwai itouniyaimowoi muwoi, totaiyo mo. ");
INSERT INTO amm_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Hani hani au imo tiko manono, noko nokolaloso. Wiyou, mulu tofolokokai manono, noko nokolalo mo. Moloi aluwai monoi, au au imo no no? Aiyoloko nokoyo pa tofasiko manonoso. ");
INSERT INTO amm_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Aiyoloko noko mo hani hani tiyo manono, asuwo noko nokolaloyo kwaiko monoi. Kotoni imo kulukai lolofa mo pokisi sisiyolisai tunonisoko manono, siyai mo nanukosi sisiyolisai tunonisoko manono, asuwo noko nokolaloyo kwaiko monoi. Kou tuno sopo sopowoi tasisikokai manono. ");
INSERT INTO amm_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Koloni wasimai nokotalo iyalini nu simai sinono monoi tiyo manono. Lotu nuso mani, noinoso na, noko nokolaloyo kwaiko monoi tiyo manono. ");
INSERT INTO amm_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ukouniyaikomai nokoyo “woli iyali moi kuo” imo iko monoi tiyo manono. Asuwo “aiyolokomomoko noko” kolali monoi tiyo manono. ");
INSERT INTO amm_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Momaiso no nokoyo no ulai moloi kolali monoi, aiyoloko noko imo no? Tofolo. Aiyolokomo nokota mo siyasoso niya tolo. Moi komaso mo auwa noko auwa noko saso niya tosinuwo. ");
INSERT INTO amm_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Asimai tolo nokotaso Apou Siyoli imo mo noiyo kaluwaiyoiwo. Moini Apou Siyoli mo siyasoso nali no, kumokiso niya you tolo. ");
INSERT INTO amm_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Moiso no hani monoi kolali monoi samukuko noko imo no? Moini samukukomo nokota mo siyasoso, Kolaiso nali, Isolilo noko moi fasikomo nokota, Kotoyo no muwokaiki no. ");
INSERT INTO amm_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Moini noko siyoli mo momaini mi ano fasikomo nokota na tolumo. ");
INSERT INTO amm_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ya timonukuwo, noko mo noko siyoli tolo mulu yakimo, Kotoyo pa molokimoiso, na auwosisimoimo. Noko mo noko siyoli tolo mulu yo somiso mo, Kotoyo molokimoimo. Kotoni molo timai siyoli nokota na toloimo.” Aino ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Nosai no mo; Isiso mo nokotalo iyaliso na ikoki, “Musini imo sai sisiyoli nokowoi Falisi moloso aluwai nokowoi moi fau, atiyaiso na posiwo. Moi mo imo topoko noko na. Kumokiso you tolokaino nokotayo noko nokolaloso louwa tosamukukomoi, ulai na talukiko manonuwo. Momai mani, tanomowoi muwoi, no monoi no pa tosamukukomonuwoso. Noko siyai mani, no louwa taluwaino no, toiso mani, na talukiko manonuwo. ");
INSERT INTO amm_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Musini imo sai sisiyoli nokowoi Falisi moloso aluwai nokowoi moi fau, atiyaiso na posiwo. Moi mo imo topoko noko na. Susawi nokolalo tifoluwaiko manonuwo, ilolu i wati monoi. Kotowoi imo lukasomai totopoko manonuwo, imo sopo soposo tolukasalo manonuwo, asuwo asuwo. Kotoyo noko nokolalo wauwakimo, soliyakiso na uwokomoinuwomo, wiyou, soliyakiso na. ");
INSERT INTO amm_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Musini imo sai sisiyoli nokowoi Falisi moloso aluwai nokowoi moi fau, atiyaiso na posiwo. Moi mo imo topoko noko na. Poso ayou molosaiwoi asi molosaiwoi tonu manonuwo, asi aluwa aluwa nokoni auso, na taiyolokalomano manonuwo, tikalo manonuwo, “Koini moloso na pa aluwaimokowo.” No monoi no moini moloso na taluwaiyalo manono. Ulai no mo kwaimo muwoi, taso na nuwoimo, momai komiyai. Wiyou, molo koiyau siyoliso taluwai manono. Moiso na tosouwaikomonuwo. Toini molo koiyau mo sisiyoli. Ulai afonimaiso? Momaiyosu na taiyoloko manonuwo. ");
INSERT INTO amm_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Molo kau kau noko moi, noko nokolaloso molo no towiyotinuwo no, moi fau, atiyaiso na posiwo. Noino na tiyamo manonuwo, “Nokoyo lotu nu siyolini siyoloso kaluwaiyakimo, no mo afonimai hani na. Ulai nokoyo lotu nu poiso tomoki kamo kamoni siyoloso kolalakimo, no mo auwolo imo, ulai hani monoi kulali monoi?” ");
INSERT INTO amm_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Moi mo muluwoi muwoi, molo kau kau noko komiyai. Haniyo no siyoli? Tomoki kamo kamoyo poimo, o, lotu nu siyoliyo poimo. Tomoki kamo kamo mo lotu nu poiso si somiso mo, nu siyaso posi, Kotoni pa posiso, afonimai hani na posi. ");
INSERT INTO amm_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Noino mani, na tiyamo manonuwo, “Nokoyo lotu nu poiso kotisokoni siyoloso kaluwaiyakimo, no mo afonimai hani. Ulai nokoyo Kotoso ni kolonini siyoloso kolalakimo, no mo auwolo imo, ulai hani monoi kulali monoi?” ");
INSERT INTO amm_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Moi mo molo kau kau noko komiyai nali no. Haniyo no siyoli? Kotoso ni koloni poimo, o, lotu nu poi kotisoko poimo. Kotoso ni koloni mo lotu nu poi kotisokomai utu somiso mo, Kotoni koloni pa posiso, afonimaiso na posi. ");
INSERT INTO amm_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","No monoi no mo, nokoyo lotu nu poiso kotisokoni siyoloso tokaluwai mo, hani hani koloni mo kotisoko tonimai no si no, nonani siyolo siyoloso mani, na tokolali, no monoi no tauwolo. ");
INSERT INTO amm_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nokoyo lotu nu siyolini siyoloso tokaluwai mo, lotu nu poiso tolo nokota Koto, totani siyoloso mani, na tokaluwai, no monoi no tauwolo. ");
INSERT INTO amm_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Nokoyo kumokini siyoloso tokaluwai mo, Kotoni yousi kotisokoni siyoloso mani, na tokaluwai, no monoi no tauwolo. Nonani kotisokoso yousikaino nokota, tani siyoloso mani, na tokaluwai, na tauwolo. ");
INSERT INTO amm_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Musini imo sai sisiyoli nokowoi Falisi moloso aluwai nokowoi moi fau, atiyaiso na posiwo. Moi mo imo topoko noko na. Moi mo sumonowoi fisawoi apiyawoi naino ti tokunoloko manonuwo, kunolokokai siyasonuso Kotoso toni manonuwo. Kotoni imo ainoso taluwai manonuwo. Ulai Musini ami imo folosai mo na tokulaliko manonuwo. Noko nokolaloso atiyaiyaso pa tuwoko manonuwoso. Mulu pa tuku manonuwoso. Pa tofasiko manonuwoso. Mulu amiso pa taluwai manonuwoso, Kotoni moloso mo. Nofuwa noko kunolokokai siyasonuso Kotoso ni mo waliyo. Ulai noino mani, noko nokolaloso atiyaiso na pa uwoko manowo, mulu pa uku manowo, na pa fasiko manowo, mulu amiso na pa aluwai manowo, Kotoni moloso mo. ");
INSERT INTO amm_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Moi mo molo kau kau noko komiyai, noko nokolaloso molo no towiyotinuwo no. Musini imo folosai mo pa taluwaiko manonuwoso. Tani imo siyaisoso taluwaiko manonuwo. ");
INSERT INTO amm_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Musini imo sai sisiyoli nokowoi Falisi moloso aluwai nokowoi moi fau, atiyaiso posiwo. Moi mo imo topoko noko na. Moi mo nau asiyofolosaiso tuluwako manonuwo. Ulai moini mulu poiso mo wofu wofuwoi muwoi, polamoko mulu saso moi mo, momaini mulusoso na taluwaiko manonuwo. ");
INSERT INTO amm_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Falisi moloso aluwai noko, moi mo molo kau kau noko komiyai. Nau mo toku mo poisai na pa uluwako manowo. No monoi no asiyofolosai mani, wofu wofu na soimo. ");
INSERT INTO amm_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Musini imo sai sisiyoli nokowoi Falisi moloso aluwai nokowoi moi fau, atiyaiso na posiwo. Moi mo imo topoko noko na. Moi mo noko yau yau aiko uku asi komiyai, kouwokokai. Asiyofolosaiso mo wiyou, itouniyaimo, noko nokolaloni molo timai mo. Ulai asi poisai mo noko yau yau nokoni miwoi uwokokai na ku si. Hani hani kopokoiyaukokai toliki toliki na ku si. ");
INSERT INTO amm_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Moi mo noinoso na tosinuwo. Nokoyo ausoso tokokomo manonuwo mo, tiyamo, “Noko ititouniwo.” Mulu poisaisu mo wiyou, imo topoko saso, moi mo. Kotoni imo na tokulali manonuwo.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Isiso mo ulai ikoki, “Musini imo sai sisiyoli nokowoi Falisi moloso aluwai nokowoi moi fau, atiyaiso na posiwo. Moi mo imo topoko noko na. Aniyopano iyaliyo Kotoni mulu lukasiko noko iyaliso potukuwoli liyai manokino, yau yau. Nonani yau yau nokoni asi aiko uku moiyo tokouwoko manonuwo. Mulu ititouni nokoni asi aiko uku asi tokouwoko manonuwo. ");
INSERT INTO amm_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Na tiyamonuwo, “Koi mo aniyopa iyaliwoi foiya posinoki mo, koi mo Kotoni mulu lukasiko nokoso mo pa potukuwoli fasikonokiso.” ");
INSERT INTO amm_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Motu na, momaini aniyopano iyaliyo mo Kotoni mulu lukasiko noko iyali na potukuwoli liyai manokino. Totaini nakosai na tosinuwo, mulu mo tomoso ainoso na. ");
INSERT INTO amm_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Noinoso na, aniyopano iyalini moloso na taluwaiko manonuwo. Totaini mi na pa uwaimo taikiyowo. ");
INSERT INTO amm_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Moi mo nuwo kopokoiyau komiyai. Kotoyo noko wauwakimo, taso na kiyokomo taikiyoinuwomo. Ulai moloi uloloinuwomo? ");
INSERT INTO amm_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","No monoi no mo, na pukwaimonowo. Yo mo Kotoni mulu lukasiko noko kiyokomoikuwomo. Mulu iwoi nokowoi Kotoni imo aiyolokomo nokowoi mani, kiyokomoikuwomo, moini auso. Ulai siyai mo na tukuwoliyoinuwomo, a mokimai ukou ukou nikokaiyoinuwomo, yau yau. Siyai mo momaini lotu nu poimai wasouli liyai manoinuwomo, suwoi suwoi moloyo. Nokonu nokonuso amiyaikiyokalo manoinuwomo. ");
INSERT INTO amm_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","No monoi no mo tukuwoli foli monoi uwokomoinuwomo. Mulu ititouni noko mo, asimai no potukuwoli liyai manokino no, aniyopano iyaliyo, toi tukuwoli foli monoi moisu mo na uwokomoinuwomo, Kotoyo mo. Toku totawoi mo Aipolo itouniyaimo tukolokino. Nosai no Kotoni mulu lukasiko noko iyali tukuwoli liyai manokino tukuwoli liyai manokino tukuwoli liyai manokino; ainoso hani Sokolaiya, Pilokaiyani awitono, to mani, na tukolokaikino, lotu nu siyoli asiyofoloso, koloni utu kotisokosai. Ulai ya timonukuwo, moi mani, molo koiyau tomoso na taluwai manonuwo. No monoi no Kotoyo na uwokomoinuwomo, aniyopano iyaliyo tukuwoli foli monoi mo. ");
INSERT INTO amm_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ya motuwa na timonukuwo. Nonani yo foli monoi mo iyanoko na uwokomoinuwomo, lolaimai si noko moi mo.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Nosai no mo; na yomuki, Isiso mo, “Yolusolimo noko, woi. Yolusolimo noko, woi, Kotoni mulu lukasiko noko tukuwoli noko moi, woi. Kotoyo louwa tokiyokomo taikiyo manonuwo, ulai tomoki tosalosoko manonuwo, yau yau. Moi woi. Kokalo uo lolofa komiyai yo mo saiso saiso na louwa tosamukukomo manonukuwo. Moiyosu mo wiyou tiyamo manonuwo. ");
INSERT INTO amm_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Na pukwaimonowo. Koto mo moini nokonuso tutukaikomonuwo. ");
INSERT INTO amm_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ulai afonimaiso? Ya timonukuwo, ti monoi pa kimonoinuwoso. Pa kimono manoinuwoso, ainoso hani iyamoinuwomo, “Ninani nokota, Noko Siyolini amimai ni totumo no, tani siyolo na tokaluwaiyaloukoni.” Ainoso iyamoinuwomo, nuwoi no ti monoi na tumoimo, yo mo.” Isiso mo aino na yomuki. ");
INSERT INTO amm_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Nosai no mo; Isiso mo lotu nu siyolisai utukaimoki, na manoki. Amai liyai manoki mo, siyokutono iyali mo na ima tumokino, “Lotu nu namoli auso monoi na pokoko.” ");
INSERT INTO amm_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ulai na fowakoki, “Yo mo motuwa na timonukuwo. Ni tokokonuwo no, no mo amuwoi tino mo na ulalokoinomo. Tomoki puwomai ni si mo, amai pa soiso. Komaso na ulaloko taikiyoinomo.” Aino ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Nosai no mo; Isiso mo Oli yuso yousa yoki. Siyokutono iyali saso na ima yokino, “Na pimoko, maniwoiso no lotu nu ulalokoinomo? Aumoifaso ifou amukonakinimo, toku no haniyo fiyamosiyoimo, koi saino monoi no? Asi mo aumoifaso fokumakimo, toku no haniyo fiyamosiyoimo, koi saino monoi no? Nonayo piyomu.” ");
INSERT INTO amm_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Nosai no mo; Isiso mo na fowakoki, “Atiyaiso na pa siwo. Wonikaluso nokoyo aiko ifoluwaikomoinuwo. ");
INSERT INTO amm_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Noko molopoi na toimo, ifoluwaikoma tumoinuwomo, iyamaloimo, “Yo mo Kolaiso, Kotoyo muwomonokaiki, Isolilo noko moi fasikoma tumo monoi.” Wiyou, noko nokolalo molopoiso na ifoluwaikaloinomo. ");
INSERT INTO amm_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Nomai no mo, uo tukoluwano umano siyoliso kwai manoinuwomo. Uo tukoluwano imofaso na kwai manoinuwomo. Moi mo atiyaiso, noiyo umomalotikomoiwo. Nonani hani mo toku fiyamosoko liyaiyoimo, asi fokumosu mo namolisai. ");
INSERT INTO amm_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Asi siya noko mo noko siyai nokowoi uo tukoluwanoinomo. Noko nokonu noko mo tolomu nokowoi uo tukoluwanoinomo. Noko mo koloni somiso si liyaiyoimo, tiya sisiyoliyo kolikali si liyaiyoimo. Nou nou mo asisai auwonoulu liyaiyoimo. ");
INSERT INTO amm_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Nonani hani hani kopokoiyau mo iyanoko komiyai. Nokolaloyo alalo no tokoko manono no, nonani iyanoko komiyai nali no. Lolaloso iyanoko mo koufaso, nosai no mo soliyaki. Kopokoiyau hani no tumaki no, no mani, toku mo koufaso, namolisai mo soliyaki soliyakikomo nali no. ");
INSERT INTO amm_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Nosai no mo; nokoyo na kolisalo manoinuwomo, wiyou, uwokomoinuwomo, na tukuwoliyoinuwomo. Asi asi noko komaso nokoyo mulu na atolokomo unoinuwomo. Ulai afonimaiso? Moi mo yoso mulumolo luwaimono noko nali no. ");
INSERT INTO amm_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nomai no mo, mulumolo luwai noko molopoi noko mo Kotoso namoliyo na alosimoinomo. Uo nokoni nainoso kiyokuwano liyaiyoinomo. Mulu atolokomo ukuwanoinomo. ");
INSERT INTO amm_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Imo topoko noko molopoiyo iyama tumo liyaiyoimo, “Koi mo Kotoni muluyosu imo na toposasoka tumonoki.” No monoi no noko nokolalo molopoiso ifoluwaikalo liyaiyoinomo. ");
INSERT INTO amm_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Wiyouwa wiyou, Kotoni imo na kulaliyalo manoinomo. No monoi no mulu pa ukuwanoinoso. ");
INSERT INTO amm_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Noko mo mulu ami amiso sakimo, ainoso hani asi fokumoimo, toi mo na samiyaikiyoinomo. ");
INSERT INTO amm_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Noko mo Kotoyo samukuko imo itouniyaimo imo na posasokaloinomo, asi asi komaso noko nokolaloso posasoko wiyotiyoinomo. Nosai no mo, asi mo na fokumoimo.” Aino ikoki, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Nosai no mo; ti monoi ikoki, Isiso mo, “Nomai no mo ya no timonukuwo no, nomai no koiyau hani toloso na kiyoinuwomo, lotu nu poiso toloso. Asi uwokai koiyau hani nali, toku Kotoni mulu lukasiko nokota Taniyoloyo no kumo unukaiki no.” Matiyu ya na timonukuwo, noko mo ninani puko imoso kokakimo, na mulumoloko itouniyaimumo. ");
INSERT INTO amm_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","“Nonani ulomai Yutiya asiso si noko nokolalo moi mo yuso pa uloloniyo yowo. ");
INSERT INTO amm_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Noko mo nu komu tofumaiso you yousakimo, nu poiso tu si hani hani no moloi iya kono monoi? ");
INSERT INTO amm_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Noinoso nali, noko mo isimai tolakimo, tuno no nuso no moloi anano monoi? ");
INSERT INTO amm_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Nomai no, woi. Muwoliwoi nokolalo, woi. Paumai alalo atino iyali, woi. ");
INSERT INTO amm_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Kotoso na pa utolumo manowo, fulomu popomai mo ulolo somiso monoi. Mi fou fouko ulo monoi mani, pa utolumo manowo, moi ulolo somiso monoi. ");
INSERT INTO amm_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ulai afonimaiso? Afonimaiso muwoi. Ulolomaiso mo siyoliso na uwokomoinuwomo. Mulu mo folokomo kaiyoinuwomo. Asi tonofalosai ainoso lolaiwoi ainonani koiyau mo fiyamosiwoi muwoi. Asi fokumomai saso siyoliso na uwokomoinuwomo. Nosai no mo uwai, ti monoi pa uwokomoinuwoso. ");
INSERT INTO amm_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Asi fokumomai mo wiyou, na uwokomo manoinuwomo. Kotoyo fokusimo somiso mo, noko nokolalo komaso mo kolikaliyoimo. Ulai mulu mo ukukaiyoimo, muwokokai noko nokolalo monoi, no monoi no mo na fokusimoimo. ");
INSERT INTO amm_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Nomai no mo, nokoyo iyamaloimo, “Na pokiwo. Ni mo Kolaiso na, noko no mo Kotoyo no muwokaiki no, Isolilo noko moi fasikoma tumo monoi.” Siyaiyo iyamaloimo, “Kolaiso mo ausoni tolokaino.” Topoko imo aino iyamakimo, noiyo kwaikoiwo. ");
INSERT INTO amm_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Imo topoko noko mo na iyamo liyaiyoimo, “Yo mo Kolaiso.” Siyai mo iyamaloimo, “Yo mo Kotoni mulu lukasiko nokota.” Mulu ifolaluwawoi mi sisiyoli ano topoko ifoluwaiko liyaiyoinomo, folo folo. Kotoyo muwokokai noko nokolaloso louwa ainiko ifoluwaikaloinomo. ");
INSERT INTO amm_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Na pukwaimonowo. Nonani hani fiyamosi somisomai, yo mo yasoi imonukuwo. ");
INSERT INTO amm_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","No monoi no mo, nokoyo imakinuwomo, “Pukwaiwo, Kolaiso mo noko somiso asiso tolokaino.” Noso monoi noiyo nuwoiwo. Iyamalakimo, “Nu poiso tu yousikaino.” Noiyo kwaikoiwo. ");
INSERT INTO amm_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ulai afonimaiso? Asi asi noko nokolaloni noko siyoli nokota ya ifou amukonoso na you kwaimonoinomo, noko nokolalo komaso noko mo. Saloma momaliyoma liyakimo, noko nokolalo komaso mo na kwai si liyaiyoimo. Ya amukonomai mani, ainoso nali no you kwaimonoinomo. ");
INSERT INTO amm_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Noko yau yau salokukoukumai wiyo wiyoyo tonoka tumo liyai manono, noko yau yau somuso.” Aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Nosai no mo; Isiso mo na ikoki, “Nonani hani sisiyoliyo uwokomo uwai; lolai siyaso “ulo mo na sopokumonoimo, amu mani, pa wisoiso. Amoloku mo kumokisai na kiyalo kono liyaiyoimo. Hani hani sisiyoli mo kumokiso you si, nonani hani hani mo kumolokoimo.” ");
INSERT INTO amm_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Nomai no mo, siya hani mo kumokisai na fiyamosiyoimo, asi asi noko nokolaloni noko siyoli nokota ya tumo monoi. Asi asi noko nokolaloyo sosonuno liyaiyoimo. Nosai no mo; ya amukonoimo. Asi asi noko nokolaloni noko siyoli nokota yo mo na amukonoimo. Yo amukonoso you kimonoinomo, noko nokolaloyo, kumoki kopu molosai amukonoso. Wiyou, amiwoi amukonoimo, Kotoni saponi siyoli yakomaiso. ");
INSERT INTO amm_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nosai no mo; yani kumoki noko iyaliso na iko taikiyo liyaiyoimo. Louwo na uwokaloinomo, asayo muwokokai noko nokolaloso mo na kolisalo liyaiyoinomo. Isaino ti liyaiyoimo, ausaino ti liyaiyoimo, asi asi komaso asisai.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Nosai no mo; Isiso mo siyokawi imo ikoki, sipoki a aino imo mo, na ikoki, “Sipoki aso tokoko manonuwo. Touwo mo iwowoi totu si mo, iwasuwo tomu tonofalo na tomomoloko taikiyo. No mo moi mo sai, fumu itouniyaimo monoi. ");
INSERT INTO amm_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Noinoso nali, ulo sopoku hani haniso kwaikalakinuwomo, moi mo sai, ya aumoifaso na amukonoimo. ");
INSERT INTO amm_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Motuwa na timonukuwo. Noko komaso noko kolikali somisomai, nonani hani hani mo na fiyamosokaloimo. ");
INSERT INTO amm_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kumokiwoi asiwoi mo uwaimo taikiyoimo. Yani imosu mo amai na tanoimo.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Isiso mo ulai ikoki, “Yo amukono monoi, ulai noko no moloi saino monoi? Maniwoiso poimo. Kotoni kumoki noko mani, ulai toi no sai? Totani awitono, yo mani, sai muwoi. Apou totasu mo sai. ");
INSERT INTO amm_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Toku Nowa tolomai noko nokolalo mo tani imo mo pa pukwaimo manokinoso. Nosai no sa mo lolai siyaso somaiso na tumoki. Asi asi noko nokolaloni noko siyoli nokota asa mani, lolai siyaso somaiso na amukonoimo. ");
INSERT INTO amm_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Iwo usoiyo tumo somisomai noko nokolalo mo koloni pono si liyai manoki, pokolikuwano liyai manokino, ainoso hani Nowa mo poso ayou poiso na lotiki. ");
INSERT INTO amm_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Pa mulumolokokinoso. Iwo usoiyo tumo imo monoi na kulalikino. Imo amai kulali manokino mo, iwo usoiyoyo na tukuwoli soli liyaiki, yau yau. Noinoso nali, asi asi noko nokolaloni noko siyoli nokota ya amukonomai mani, noko nokolalo mo yo monoi mo sai muwoi, pa foumonoinoso, no monoi no kolikaliyoimo. ");
INSERT INTO amm_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Isi mi ano nokota ti tolakinomo, siyasoso kumoki nokoyo na kausiya tumoinomo, siya mo amai ano toloimo. ");
INSERT INTO amm_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nokolalo ti mo noinoso nali, toti mo tuo waso utuko tolakinomo, siyasoso kumoki nokoyo kausisa tumoinomo, siya mo amai tolosoimo. ");
INSERT INTO amm_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","No monoi no mo, moi mo atiyaiso na pa siwo. Moi mo sai muwoi, moini Noko Siyoli mo maniwoiso poimo tumoi. ");
INSERT INTO amm_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ninani hani na pomulumolokowo. Nu kiyo nokota mo polamoko nokotayo tumo monoi posaino mo, na posamuku, na palukimo. Ulai maniwoiso poi tumoi, ulai to no sai? ");
INSERT INTO amm_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Moi mani, na pa foumonowo. Asi asi noko nokolaloni noko siyoli nokota yo no maniwoiso tumoimo? Ulai moi no sai? Moiyo iyamakinuwomo, pa tumoisowo, yo mo na tumoimo.” Siyokutono iyaliso aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Nosai no mo; Isiso mo siyokawi imo na ikoki, siyokutono iyaliso, noino, “Mi ano itouniyaimo nokota no noi? To mo muluwoi na, mulu itouniyaimowoi nali. Nonani nokota mo noko siyoliyo toku muwokaiki, totani mi ano noko nokolalo samukuko monoi. No yakomai saiso saiso tuwautimoi, koloni mo. ");
INSERT INTO amm_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Siyoli nokotayo mi ano itouniyaimoso kiya tumakimo, nonani mi ano nokota mo na molokiyumo. ");
INSERT INTO amm_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Yo mo motuwa na timonukuwo. Noko siyoliyo na muwokaiyoimo, totani hani hani komaso samukuko monoi. ");
INSERT INTO amm_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ulai mi anononi nokota siya mo totolo. To mo mulu mo koiyau, na tomulumoloko, “Yani noko siyoli mo somaiso pa tumoiso.” ");
INSERT INTO amm_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","No monoi no mi ano siyamai nokoso tuwasouliyanomoi, koloni tonokanomoi, iwo koiyau tosiko tomasikanomoi, kwalu kwalu nokowoi. ");
INSERT INTO amm_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Aino yo manakimo, tani noko siyoliyo ifou na tumoimo, foumo somisomaiso. Noko siyolini tumo monoi mo sai muwoi. ");
INSERT INTO amm_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","No monoi no mo siyoli nokotayo na uwokaiyoimo, imo topoko nokowoi tolo tomasikoimo. Wiyou, na soni toloimo, iwoi sisikomo toloimo.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Nosai no mo; Isiso mo siyokutono iyaliso na ikoki, “Yo ifou tumomai mo kumokiso you tolokaino nokotayo noko samukuko mo noino. Noni tonofalo kauso nokota mo molomai totumo. Nokolalo nuko naino ti uwai, toi mo lamu tawoi na tofalo kausiyanono, totani nonini auso kawiyo tumo monoi. ");
INSERT INTO amm_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Naino siyai nokolalo mo muluwoi muwoi. Naino siyai mo muluwoi nali no. ");
INSERT INTO amm_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Mulu somiso nokolalo mo lamu ta saso tiyo tumono. Ta iwowoi woliyo tumowoi muwoi. ");
INSERT INTO amm_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Muluwoi nokolalosu mo lamuwoi nau iwowoi na tiyo tumono. ");
INSERT INTO amm_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Noni tonofalo kauso nokota mo somaiso tumowoi muwoi. No monoi no mo ulo molo tuwoko, molomai na tosi, ulololi. ");
INSERT INTO amm_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Nosai no mo; amoloki siyolimai mo imo mo tokoloma tumo, “Noni tonofalo kauso nokota mo na totumo. Molomai pofoumanowo.” ");
INSERT INTO amm_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nosai no mo; nokolalo nuko komaso mo tauwonoulu, lamu ta na tofalosokono. ");
INSERT INTO amm_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ulai mulu somiso nokolalo mo muluwoi nokolaloso na tikono, “Ta iwo waloto lolofa na puwololumomokowo. Koini lamu ta mo konoi mo aumoifaso na sopokumaloti liyai.” ");
INSERT INTO amm_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ulai muluwoi nokolaloyo mo na tofowakono, “Wiyou tiyamonoki. Koini ta iwo mo sisiyoli muwoi, pa tuwololu komonukuwoso. Ulai momai folo na pa suo suomokanowo, situwaso.” ");
INSERT INTO amm_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","No monoi no yasoi. Nu uwai; nosai no mo; noni tonofalo kauso nokota mo na totumo. Foumo nokolalo mo na taluwainiyo tino, noni kauso koloni tuwasi sa ti. Itu na tasino, nokoyo. ");
INSERT INTO amm_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Namolisai nokolalo nuko siyai mo na toti, mulu somiso nokolalo mo itu lotisai tofu sa tumo, siyoliso na timalono, “Noko siyoli, noko siyoli, itu na pokolali unumoko.” ");
INSERT INTO amm_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ulai na tiko, “Ya motuwa na timonukuwo. Yo mo moi monoi mo sai muwoi.” Aino na tiko. ");
INSERT INTO amm_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","No monoi no moi mo atiyaiso na pa siwo. Ulai moi no sai, yo amukono no? Moi mo sai muwoi.” Aino ikoki, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Nosai no mo; Isiso mo siyokawi imo siya na ikoki, “Kumokiso you tolokaino nokotayo noko samukuko mo noino. Noko siya mo asi aluwaso mano monoi tiyo. Toku mo totani mi anononi nokoso taliyoniko, na tiko, “Yani muwoni na posamukukomonowo.” ");
INSERT INTO amm_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Mi ano nokoni mulu folo folo monoi na tomulumolokoki. No monoi no noko siya mo muwoni molopoi molopoi 5000 kina na takononi. Siya nokotaso mo noino takononi, 2000 kina. Siyaso mo noino na takononi, 1000 kina. Na tutukaiko, yasoi. ");
INSERT INTO amm_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Mano uwai; 5000 kina akononi nokota mo lolai siyaso suo suomoko mi tanano, na tanomoi. Nonani mi ano foli monoi mo 5000 kina siya na tako. ");
INSERT INTO amm_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Wolitono, 2000 kina akononi nokota mani, suo suomoko mi tanano. Nonani mi ano foli monoi mo 2000 kina siya na tako. ");
INSERT INTO amm_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ulai 1000 kina akononi nokota mo asi na taikaiyano, siyoli nokotani muwoni tanukokaikano, asi iso. ");
INSERT INTO amm_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Amu amu poi poi uwai; totaini siyoli nokota mo ifou na tokoka tumo, muwoni niko imo monoi fou fouko monoi. ");
INSERT INTO amm_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nosai no mo; 5000 kina nokota mo na totumo. 5000 kina siya mani, na takiyo tumo, na timo, totani noko siyoliso, “Noko siyoli, 5000 kina na akomonokini. Na pokoko, yo mo suo suomoko mi na pano manoki, no monoi no mo 5000 kina siyawoi na tako.” ");
INSERT INTO amm_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Totani siyoli nokotayo na timo, “Nono mo yani mi anomono nokota itouniyaimo. Mi atiyaisosu na tanomono manoni. Hani koufa monoi atiyaiso tiyo manoni, no monoi no mo yo mo tiyomukai, hani hani sisiyoli mo na samukukomonoinimo. Yani auso potumo, moti na tasisikuwano tolokoni.” ");
INSERT INTO amm_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Nosai no mo; 2000 kina nokota mani, totumo, na tima tumo, “Noko siyoli, 2000 kina na akomonokini. Na pokoko, yo mo suo suomoko mi na pano manoki, no monoi no mo 2000 kina siyawoi na tako.” ");
INSERT INTO amm_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Totani siyoli nokotayo na timo, “Nono mo yani mi anomono nokota itouniyaimo. Mi atiyaisoso na tanomono manoni. Hani koufa monoi atiyaiso tiyo manoni, no monoi no mo yo mo tiyomukai, hani hani sisiyoli mo na samukukomonoinimo. Yani auso potumo, moti na tasisikuwano tolokoni.” ");
INSERT INTO amm_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Nosai no mo; 1000 kina akononi nokota mani, na tima tumo, “Noko siyoli, yo mo sai, itotolo nokota, nono mo. Noko mulu uku nokota muwoi. Wiyou, mi siyoli tanononi manonoki, mulu mo folokomomokokai. Ulai mi ano foli monoi mo nonayosu ti manoni. Koi monoi mo pa tomulu unumoko manoniso. ");
INSERT INTO amm_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","No monoi no yo mo kokolomomono, nani muwoni 1000 kina anukokaiko noninanokinoki, asi iso. Nani muwoni mo niyasu.” ");
INSERT INTO amm_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Ulai totani siyoli nokotayo mo na timo, “Nono mo yani mi anomono nokota itouniyaimo muwoi, koiyau. Mi ano ufolo nokota nali. A, yo no noko mulu uku nokota muwoi? A, moi no mi siyoli no tanomono manonuwo? A, mulu no folokomokainuwo? A, mi ano foli monoi no asasoso no timoi? A, moi monoi no pa tomulu unu manonukuwoso? ");
INSERT INTO amm_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Motu na tiyomuni. Ulai hani monoi yani muwoni no muwoni suo suomoko nokoni nainomai pa akaikokiniso? Aino piyoni mo, yo mo muwoni siyaiwoi piya tumo, toini nainosai.” ");
INSERT INTO amm_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Nosai no mo; noko siyaiso na tiko, “1000 kina na pakowaiwo, 10000 kina nokotaso monoi pakononiwo. ");
INSERT INTO amm_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ulai afonimaiso? Afonimaiso muwoi. Hani hani molopoiwoi noko mo no monoi no, yo mo hani hani niko manoimo. Wiyou, na tokiko taikiyoimo. Nokosu mo hani hani mo uwofawo, koufasosu mo yapoli, nonani koufa hani mo ya uwokoimo. ");
INSERT INTO amm_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ninani mi ano koiyau nokota mo folosuso monoi na pafoliyo fuwo. Wiyou, na soni toloimo, iwoi sisikomo toloimo.” Aino ikoki. ");
INSERT INTO amm_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Ti monoi na ikoki, Isiso mo, “Asi asi noko nokolaloni noko siyoli nokota ya amukonakimo, yo mo ami siyoliwoi na toloimo. Kumokini amiyo na samukukoimo, noko nokolalo mo. Asasoso pa amukonoiso, asani kumoki nokowoi na aluwaimoniyo konoinomo. ");
INSERT INTO amm_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Asi asi komaso noko nokolalo mo ukouniyaika tumo liyaiyoimo, yani molo timai. Na wauwoimo, molo tiwoi. Nukutai koloni samukuko nokota komiyai mulumai na tokosiyaikoimo, sipo uo mo iso monoi na toimo, mimi uo mo auso monoi na nuwoimo. ");
INSERT INTO amm_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Sipo koloni mo nainasai soimo. Mimi koloni mo sokonisai soimo. ");
INSERT INTO amm_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Nosai no mo; samukuko nokota siyoli mo totani nainasai si noko nokolaloso na ikoimo, “Yani Apouyo na tofasinuwo. Tani nukutaiso na potiwo, samukukomo monoi mo. Yasoi na foukainonikinuwo. Kumoki asi asi fonanikomomai yasoi foukainonikinuwo. ");
INSERT INTO amm_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ulai afonimaiso? Toku mo tiya kalomonoki mo, moi mo koloni na nimonokinuwo. Iwo nukuwa uwomonoki mo, ulai moi mo iwo woliyomonokinuwo. Asi siya nokota yo mo tumoki mo, na imonokinuwo, “Nu poiso na poloti.” ");
INSERT INTO amm_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Yo mo tuno somiso toloki mo, tuno na amonokinuwo. Ai uwomonoki mo, na yoisuwamonokinuwo. Kalopulo nuso tolomai mani, na kimona tumokinuwo.” ");
INSERT INTO amm_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","No monoi no mo, mulu ititouni noko mo na fowayoinomo, “Siyoli Nokota, tiya uwo no hanimai kwaikinoki, hanimai koloni nikinoki? Iwo nukuwa uwo no hanimai kwaikinoki, hanimai woliyononikinoki? ");
INSERT INTO amm_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Haninoimai asi siya nokota nono tumoso na kwaikinoki, haninoimai imokinoki, “Nu poiso na poloti.” Haninoimai tuno somiso tolokini, haninoimai tuno na anonikinoki? ");
INSERT INTO amm_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Haninoimai nono ai uwoso kiyanokinoki? Haninoimai nono kalopulo nuso toloso kiyanokinoki?” ");
INSERT INTO amm_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Samukuko nokota siyoliyo mo na fowakoimo, “Motuwa na timonukuwo. Yani auwa iyali lolofa ni si mo, toiso no fasiko manokinuwo mo, yoso mani, na fasimonokinuwo.” ");
INSERT INTO amm_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Nosai no mo; sokonisai si nokoso na ikoimo, “Molo koiyau aluwai foli na uwokaikomoinuwomo. Na pokiyomonowo, Sokolo Nokota Waini sopokumono somiso ta siyoliso na ponuwo. Nonani ta mo yani Apouyo na yolikaitiki, Sokolo Nokota Wai iyali sakolouko monoi. ");
INSERT INTO amm_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ulai afonimaiso? Toku mo tiya kalomonoki mo, moi mo koloni pa nimonokinuwoso. Iwo nukuwa uwomonoki mo, ulai moi mo iwo pa woliyomonokinuwoso. ");
INSERT INTO amm_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Asi siya nokota yo mo tumoki mo, pa imonokinuwoso, “Nu poiso na poloti.” Yo mo tuno somiso toloki mo, tuno pa amonokinuwoso. Ai uwomonoki mo, pa yoisuwamonokinuwoso. Kalopulo nuso tolomai mani, pa kimona tumokinuwoso.” ");
INSERT INTO amm_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","No monoi no mo, molo koiyauso aluwai noko mo na fowayoinomo, “Siyoli Nokota, tiya uwo no hanimai kwaikinoki? Iwo nukuwa uwo no hanimai kwaikinoki? Haninoimai asi siya nokota nono tumoso na kwaikinoki? Haninoimai tuno somiso toloso kwaikinoki? Haninoimai ai uwoso kwaikinoki? Haninoimai kalopulo nuso toloso kwaikinoki? Haninoimai pa fasikinokiso?” Aino ikoimo. ");
INSERT INTO amm_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Samukuko nokota siyoliyo mo na fowakoimo, “Motuwa na timonukuwo. Afonimai noko ni si mo, toiso no fasiko somiso mo, yoso mani, pa fasimonokinuwoso.” Aino ikoimo. ");
INSERT INTO amm_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","No monoi no mo, nonani noko iyali mo yasoi, molo koiyau foli monoi na uwoko manoimo, aniyopa poi poi. Mulu ititouni noko saso aniyopa poi poi na sinono itouniyaimo manoimo.” Isiso mo aino na ikoki, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Isiso mo nonani imo sopo siyoli lukasiko uwai; nosai no mo; siyokutono iyaliso na ikoki, ");
INSERT INTO amm_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Moi mo sai, Pasowa koloni wasi popo mo aumoifaso toi, tinoso. Asa, asi asi noko nokolaloni noko siyoli nokota yo mo uo nokoni auso na kiyomono taikiyoinomo, a mokimai ukou ukou nikomomonoinomo, yau.” ");
INSERT INTO amm_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Nomai no mo, lotu samukuko noko sisiyoliwoi Isolilo nokotalo iyaliwoi, toi mo Kaiyofani nu siyoliso ukouniyaiko siki, totawoi lotu samukuko nokota siyolini nuso na. ");
INSERT INTO amm_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Isiso tukolo imo na lukaso unukino, asuwo wosu woso tukolo monoi komi kau monoi. ");
INSERT INTO amm_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Na iyamoki, “Mi fou fouko ulomai pa yo monoiso. Wonikaluso noko nokolalo mo mulu puwoso puwoso. Uo mulu aiko uwokoi.” ");
INSERT INTO amm_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Nosai no mo; Isiso mo Pitano nokonuso toloki mo, Saimo uluoyo uwokaikai nokotani nuso na yousa tiki. ");
INSERT INTO amm_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Amai yousi manoki mo, noni mo tumosoki, tomoki nau itouniyaimo na asiyo tumoki, kou woti iwo itouniyaimowoi, muwoni mo siyoli, wiyou. Nonani woti iwo mo Isisoni komuso na solukimoki, no yousiso. ");
INSERT INTO amm_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Siyokutono iyali mo nonaninoiso kwaisokino mo, mulu atolokomo usokino, na iyamoki, “Ulai afonimaiso no hani monoi solukimo, woi? ");
INSERT INTO amm_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nonani woti iwo mo suo suomoko nokoso patikoni mo, suo mo muwoni mo siyoliso na ponimokono, ilolu somiso nokoso ponikalokoni.” ");
INSERT INTO amm_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Isiso mo sai, toini imo mo, na ikoki, “Uo imo no hani monoi tisonuwo, ninani nukonuso no? Itouniyaimososu na tuwomono. ");
INSERT INTO amm_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ilolu somiso nokowoi aniyopa poi poi tosi tomasiko manonuwo. Yosu mo aniyopa poi poi pa totolo tomasimonukuwoso. ");
INSERT INTO amm_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Noniyosu kou woti iwoyo no solukimomono mo, to mo waliyo na tiyo. Yo mo nokoyo amai tukolomonoinomo, yau, no monoi no na louwomono, nokoyo ai unumono monoi. ");
INSERT INTO amm_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Motuwa na timonukuwo. Kotoni imo itouniyaimo posasoko liyaiyakinomo, asi asi komaso asiso, ninani monoi aino imo mani, nokoyo na lukasikaloinomo, noniyo ni uwomono no. No monoi no noko nokolaloyo saino usoinomo.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Nosai no mo; noko molo tiwoi mulumai nokota, tani siyolo mo Yutaso Isokailiyo, to mo lotu samukuko noko sisiyolini auso manoki, ");
INSERT INTO amm_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","na ikanoki, “Suo no haniyo amonoinuwomo, ya Isiso kiyomo monoi no?” No monoi no mo tomoki muwoni molopoi na akononikino, 30. ");
INSERT INTO amm_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Nosai no mulumolokaloki, Yutaso mo, “Yo mo Isiso mo maniwoiso poimo kiyokoi, toini nainoso mo.” ");
INSERT INTO amm_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Totawoi mi fou fouko ulo, nonani ulomai sisiyoliko asu somiso tuo no puwasimosikino no, nomai no mo siyokutono iyali mo Isisoso ima tumokino, “Moisoni foukaininanoikimo, Pasowa koloni no monoi no?” ");
INSERT INTO amm_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Nosai no mo na ikoki, “Yolusolimo nokonu siyoliso na potiwo. Noko siyaso na pa kiya tiwo, na pa ima tiwo, “Aiyolokomomoko nokota mo na tiyomu taikiyo, “Yo kalomono ulo mo aumoifaso na toi. Nani nuso Pasowa sipo koloni noikimo, yani woli iyaliwoi.” ");
INSERT INTO amm_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Nosai no mo; siyokutono iyali mo Isisoni imososo na aluwaikino, Pasowa koloni foukaiyanokino. ");
INSERT INTO amm_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Nosai no mo; folosu yasoi; Pasowa koloni wasi nikoki, noko molo tiwoi nokowoi. ");
INSERT INTO amm_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","No no si manoki mo, na ikoki, “Motuwa na timonukuwo. Moi nokotayo uo nokoni auso na kiyomono taikiyoimo.” ");
INSERT INTO amm_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Wiyouwa wiyou, nonani imoso kwaikino mo, mulu mo na kolikaliki. Siyasonuso imalokino, “Noko Siyoli, noiyo poimo, ya muwoi.” ");
INSERT INTO amm_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ulai na ikoki, “Noko to ni no, nauso yowoi tomoso ni tukolonalonoki no, nonani nokotayo na kiyomono taikiyoimo, uo nokoni auso. ");
INSERT INTO amm_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Asa, asi asi noko nokolaloni noko siyoli nokota yo mo uo nokoyo na uwomonoinomo, ainonani monoi Kotoni puko imoyo tiyomuko. Wiyou, ta fau, uo nokoni auso kiyomono nokota no moloi uwoyoimo, woi? Atinoyo to ki somiso mo, waliyo na potolo, kiyomono foli monoi pa puwoso.” ");
INSERT INTO amm_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nosai no Yutaso, uo nokoni auso kiyoko nokotayo mo na imoki, “Aiyolokomomoko nokota, noiyo poimo, ya muwoi.” Na imoki, “Topokoni, nonosu na.” ");
INSERT INTO amm_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Amai no si manokino mo, Isiso mo paluwa tuo na anoki, Kotoso wafisu imo na imoki, na foloulu nikoki, siyokutono iyaliso. Na ikoki, “Fuo, na ponokowo. Ni mo yani au somu.” ");
INSERT INTO amm_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Molo wamo ito iwo mani, na woliyonoki. Wafisu imo imoki mo, na woliyotiki, na ikoki, “Fuo, na posikalowo. ");
INSERT INTO amm_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ni mo yani nako na. Noko nokolalo komaso noko moi kwalomai monoi kalo unoikuwomo. Yani nakoyo amukono monoi Kotoyo auwolo ukukaiyoimo, noko nokolalo monoi, molo siya posaso wiyoti monoi. No monoi no molo koiyau monoi imo mo futo. ");
INSERT INTO amm_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ya na timonukuwo, na pukwaiwo. Yo mo molo wamo ito iwo mo ti monoi pa sikoiso, asimai mo. Yani Apou mo asi asi noko nokolaloso samukuka tumakimo, nomai noso na siko niyoikuwomo.” Aino ikoki. ");
INSERT INTO amm_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nosai no mo; si molosikino. Si molosi uwai; Oli yuso na yoki. ");
INSERT INTO amm_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Nosai no mo; Isiso mo molomai na ikoki, “Konoi amoloki mo namoliyo alosimomonoinuwomo. Ulai afonimaiso? Kotoni puko imoyo mo moi monoi noino na tiyomuko, “Samukuko nokotaso tukolo mo, sipo koloni mo ulolo na.” ");
INSERT INTO amm_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ulai yo ifou auwoniyouwakimo, toku toku manoimo, Kalili asiso, moi foumanoikuwomo.” ");
INSERT INTO amm_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Nosai no mo; Pita mo na imoki, “Ya muwoi. Noko komasoyo namoliyo alosimakinimo, yosu mo namoliyo pa alosimo manoikiso.” ");
INSERT INTO amm_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ulai na imoki, “Ya motuwa na timonoki, konoi amolokimai kokalo imo yomu somisomai, taumai na yomumosoinimo, “Yo mo Isiso mo sai muwoi.” ");
INSERT INTO amm_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ulai Pitayo na imoki, “Yo mo kalo tomasimakinokimo, namoliyo pa alosimo manoikiso.” Siyokutono iyali komaso mo ainonani imoso na imalokino. ");
INSERT INTO amm_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Nosai no mo; Isiso iyali mo nuki, Kitosimoniso mo fiyamosiya tumokino. Isi siyolo mo Kitosimoni. Siyokutono iyaliso na ikoki, “Imaino na posiwo. Yo mo Kotowoi imo tolukaso ni tolano, ausoni.” ");
INSERT INTO amm_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nosai no mo; tau nokososo koliyonoki, Pitawoi Sipitini alalo tiwoi, toisoso na koliyonoki. Ulai mulu mo na kaloki, mulu mo yau. ");
INSERT INTO amm_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Na ikoki, “Yo mo mulu siyoli na tokalomono. Mulu mo yau nali no. Nimai no na posiwo, na pofoinalikumono siwo.” ");
INSERT INTO amm_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nosai no amunofamoki, asiso ukuwoli tana konoki, Kotoso na imoki, “Apou, nono mo waliyo yomakinimo, tukolomono monoi na pa ufiyaiko. Ulai yani muluyoso muwoi, nani muluyosu nali no.” ");
INSERT INTO amm_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nosai no mo; ifou tumoki, siyokutono iyalini auso. Ulololi siso na koka tumoki. Pitaso lusiki, na imoki, “Moloi monoi, hani monoi ulololi tosinuwo? Yo no koufasofa pa foinalikumononuwoso? ");
INSERT INTO amm_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ulololi mo noiyo soiwo, Kotowoi imo na polukaso siwo. Wonikaluso Sokolo Nokota Waiyo aiko ainikomo ifoluwaikoma tumoinuwo. Moini muluyosu mo ami ami si monoi louwa fi, ulai auyosu mo ami amiwoi muwoi.” ");
INSERT INTO amm_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nosai no mo; ti monoi no amunofamoki mani, noinososu nali no. Kotoso na imoki, “Apou, tukolomono monoi ufiyaiko wiyou yakinimo, tofolo, waliyo na tukolomonowumo, uo nokoyo. Yo mo nani muluso na aluwaiyoikimo.” ");
INSERT INTO amm_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ulai ifou tumoki mo, ti monoi ulololi siso na koka tumoki. Wiyou, ulo molo siyoli uwokoki. ");
INSERT INTO amm_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","No monoi no utukaikoki, ifou tau monoi utolumanoki, Kotoso. Toku no utolumoki no, nonani imo ainoso na utolumanoki. ");
INSERT INTO amm_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Nosai no mo; ifou tumoki, siyokutono iyaliso na ika tumoki, “Ulololi amai na tololiyonokomo si manonuwo. Na pukwaiwo, tukolomono ulo mo aumoifaso na toi, asa, asi asi noko nokolaloni noko siyoli nokota yo mo molo koiyauso aluwai nokoni auso na kiyomono taikiyoimo. ");
INSERT INTO amm_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Na pauwonouluwo, moi soi, na tonukoni. Uo nokoni auso kiyomono nokota to mo aumoifaso na tokomi kausimona tumo.” ");
INSERT INTO amm_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Isiso mo imo amai polukasiko toloki, nomai no mo noko molo tiwoi mulumai nokota Yutaso mo na tumoki. Uo noko molopoiwoi na koliyoniyo tumoki. Muwo sopo sopowoi awoi nainomai na loliyo tumo unukino, lotu samukuko noko sisiyoliwoi Isolilo nokotalo iyaliwoi, toiyo no iko taikiyokino no, uo noko mo molopoi molopoi. ");
INSERT INTO amm_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Uo nokoni auso kiyoko nokota, Yutaso, to mo nokoso toku yasoi ikokaiki, Isiso wiyoti monoi, toku yasoi na ikokaiki, “Noko, ya no asisi ifoluwaiyaki no, to mo Isiso. Na pako komi kauwo.” ");
INSERT INTO amm_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Yutaso tumoki mo; nosai no Isisoni auso somaiso na amunoki, na imo ifoluwaiki, “Woli, aiyolokomomoko nokota nono kuo.” Na asisi ifoluwaiki. ");
INSERT INTO amm_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ulai Isisoyo na imoki, “Woli, hani yo monoi tumakinimo, somaiso nali no na pako yo.” Imoki mo; uo nokoyo imokino ukou, na komikaikino. ");
INSERT INTO amm_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nosai no mo; Isisowoi tolo tomasimo nokota, to mo totani muwo sopo kusomoniyouki, nokoni iyoso na tokoso kukiyowaiki, totawoi lotu samukuko nokota siyolini mi ano nokotani iyoso. ");
INSERT INTO amm_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ulai Isiso mo na imoki, “Muwo sopo mo totani niyouso ifou na panali. Noko komaso noko mo muwo sopo sopoyo tukoluwanakinomo, na uwai uwaimikuwanoinomo. ");
INSERT INTO amm_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ulai nono no sai muwoi? Yo mo Apouso kumoki noko molopoi molopoi kiyokomomono taikiyo monoi utolumakimo, na fasimona konoinomo. ");
INSERT INTO amm_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ulai yosu mo aino yakimo, Kotoni puko imo no motu no moloi fiyamosi monoi? Kotoni puko imoyo na tiyomuko, tukolomono imo mo motu nali no tumoimo.” ");
INSERT INTO amm_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Nosai no mo; Isiso mo uo noko iyaliso na ikoki, “Hani monoi tokomi kausimona tumonuwo? Muwo sopo sopowoi awoi no hani monoi tololiyo tumo unumononuwo? Ulai uo nokota, yo no? Yo mo uo nokota muwoi, noko pa tukuwolimoiso. Amuwoisai amuwoisai yo mo lotu nu siyoliso noko nokolaloso paiyoloko manoki, ulai pa komi kausimona tumokinuwoso. ");
INSERT INTO amm_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ulai Kotoni mulu lukasiko noko iyalini imo motu tumo monoi ninani hani mo niya tofiyamosimomono.” Ikoki mo; na utukaimokino, siyokutono iyali komaso mo na uloloki. ");
INSERT INTO amm_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Nosai no mo; Isiso komikai noko iyali mo totawoi lotu samukuko nokota siyolini nu mo kiya tumokino, Kaiyofani auso. Musini imo sai sisiyoli nokowoi nokotalo iyaliwoi, toi mo yasoi na ukouniyaikokaiya tumoki. ");
INSERT INTO amm_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pitasu mo aluwaiyaloki, namoli namoli nomasoso na aluwaiyaloki. Totawoi lotu samukuko nokota siyolini nu koki poiso lotiki, polimano noko iyaliwoi yousi tomasika tiki. Molo foinali monoi, moloi tuwono, woi, Isisoso no? ");
INSERT INTO amm_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","60","Nosai no mo; lotu samukuko noko sisiyoliwoi nokotalo iyaliwoi, toi mo Isisoni imo kwailuwai noko louwa ikolikalokino, lukaso ifoluwai unu nokoso. Ulai afonimaiso? Tani imo foli monoi tukolo monoi louwa. Ifoluwai noko molopoiyo ti liyai manoki, na louwa lukaso ifoluwaiyalo unukino. Nosai no noko tiwoi tumokino, ");
INSERT INTO amm_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","yomukino, “Noko to ni mo noino na yomuki, “Yo mo Kotoni lotu nu siyoli mo waliyo na ulaloimo, ulo tauwoimai ifou na ko uwaimoimo.” ");
INSERT INTO amm_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nosai no mo; totawoi lotu samukuko nokota siyoli mo tolauki, Isisoso na imoki, “Hani monoi pa fowakoniso? Imo na tokosiyokononini. Totini imo mo motu poimo.” ");
INSERT INTO amm_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ulai imo lukasowoi muwoi. Nosai no mo; totawoi lotu samukuko nokota siyoliyo ti monoi na imoki, “A, nono no Kotoni awitono Kolaiso na? A, Isolilo noko koi fasimoka tumo monoi na muwokaikini? Amai tolokaino nokota Kotoni siyoloso pokaluwai, na pauwolo, motu poimo. Nonayo piyomu.” ");
INSERT INTO amm_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Isiso mo na fowaki, “Nonani imo no tiyomuni mo, motu na. Ulai ya na timonukuwo. Amuwoi tino mo asi asi noko nokolaloni noko siyoli nokota yo na you kimonoinuwomo. Ami siyoli nokotani nainasai yousiso you kimonoinuwomo. Kumoki kopu molosai amukonoso na kwaimonoinuwomo.” ");
INSERT INTO amm_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Nosai no mo; ikoki mo; totawoi lotu samukuko nokota siyoli mo uo mulu siyoli atolokomoki, totani tuno na kukoliyaikoki, na yomuki, “Kotoni siyoloso na talisiyoli, woi. Tofolo, tani imo kwaimo noko mo tofolo. Koma na, Kotoni siyoloso yapoli na alisiyoli. A, yasoi tukwaimonuwo? ");
INSERT INTO amm_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Moloi tomulumolokonuwo?” Nosai no na imokino, “Tofolo, na kalumo, Kotoso alisiyoli foli monoi na kalumo.” ");
INSERT INTO amm_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nosai no mo; usuwo amu moloso na aso kolokino, amusai tuwasomo manokino, na waso manokino, nainoyo. ");
INSERT INTO amm_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Na alisiyolikino, “Woli Kolaiso, noiyo wasoni? Na pa imoko. A, Kotoni amimai no nono no sai pakoso? Noiyo wasoni?” ");
INSERT INTO amm_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Nomai no mo; Pita mo asiyofolosai fu tolokainoki. Fu tolokainoki mo, mi ano nukonu mo na ima tumoki, “Siyasu mo nonosu na, Isiso, Kalili nokotawoi tolo tomasimo nokota na.” ");
INSERT INTO amm_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ulai Pita mo na yomuki, noko nokolaloni molo timai, “Ulai yo no sai, nonani imo no tiyomuni no?” ");
INSERT INTO amm_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nosai no kokiko itu loti kwamai tolokaina fuki. Noni siyayo toloso kiki, aumoifaso si noko nokolaloso na ikoki, “Noko to ni mo, Isiso, Nasolito nokotawoi tolo tomasimo nokota na.” ");
INSERT INTO amm_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ulai Pita mo siyoliso ti monoi na yomuki, “Molo lou, yo mo nonani nokota mo sai muwoi.” ");
INSERT INTO amm_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Nosai no mo; namolisaifa aumoifaso si noko, toi mo Pitaso na ima tumokino, “Motu nali no, nono mo Isisoni siyokutono na. Nani imo mo koi mo sai, nono mo Kalili asi nokota na. Nonayo piyomu.” ");
INSERT INTO amm_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ulai nosai no mo Pita mo auwoloki, na yomuki, “Molo lou, motuwa na timonukuwo, yo mo nonani nokota mo sai muwoi. Wiyouwa wiyou. Topoko imo yomakimo, Kotoyo na uwokaimonoimo.” Yomu uwai; lolai siyaso kokalo mo imo na yomuki. ");
INSERT INTO amm_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Nosai nosu Pita mo ti monoi na mulumolokoki, nonani imo Isisoyo no imoki no, “Kokalo yomu somisomai, taumai na yomumosoinimo, “Yo mo Isiso mo sai muwoi.” Nosai no Pita mo lofuki, na soni yousa fuki, wiyou, na soni manoki. ");
INSERT INTO amm_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nosai no mo; somosaiyamai lotu samukuko noko sisiyoliwoi Isolilo nokotalo iyaliwoi, toi mo Isiso tukolo monoi na lukasokaikino. ");
INSERT INTO amm_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Moloyo na konosuwakino, Pailatoni auso na kominalomanokino, komano nokota siyolini auso. ");
INSERT INTO amm_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Nosai no mo; Yutaso, Isiso uo nokoso kiyoko nokota, to mo tukolo imo lukasokaiso no kwaikoki mo, mulu tiwoi na mulumoloko manoki. Tomoki muwoni molopoi, 30, no mo ifou kiyokoki, lotu samukuko noko sisiyoliwoi nokotalo iyaliwoiso. ");
INSERT INTO amm_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Na ikoki, “Yo mo molo koiyauso yapoli aluwai. Hani yo somiso nokotaso yo mo fai kiyomo taikiyanukuwo, no monoi no tani nako mo amukonoimo, yau.” Ulai na imokino, “Ulai koini hani? No mo nonani hani na.” ");
INSERT INTO amm_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","No monoi no mo, Yutaso mo tomoki muwoni mo lotu nu siyoli poiso tu afoliko taikiyoki, yasoi, tota amu imo molomai moloyo na tomanomanoki, na folosiyaimoki, yau. ");
INSERT INTO amm_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ulai lotu samukuko noko sisiyoli mo nonani tomoki muwoni ikanokino kusomi, iyamoki, “Lotu nu muwoniwoi tomoso pa kosinoloko monoiso. Ni mo noko tukolo muwoni na. Hani monoi kosinoloko monoi? Au nali no.” ");
INSERT INTO amm_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Muwoni imo lukaso manokino, na lukasokaikino. No monoi no nonani muwoniyo asifaso suo suomokokino, asi nau lokuko nokoni asifa. Asi aluwa noko yau yau aiko uku monoi suo suomokokaikino, nonani asi mo. ");
INSERT INTO amm_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","No monoi no mo, nonani asi mo Nako Asi kaluwaikino. Nonani siyolo mo amai toi, amai na tokaluwai manokoni. ");
INSERT INTO amm_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","No monoi nosu Kotoni imo mo motu tumoki. Kotoni mulu lukasiko nokota Iyolomaiyayo toku no kumokaiki no, nonani imo mo motu na fiyamosiki. Noino na kumokaiki, “Noko mo tomoki muwoni molopoi, 30, na ikino, Isolilo nokoyo no muwokokaikino no, noko tukolo suo suomoko muwoni na. ");
INSERT INTO amm_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Nonani muwoniyo mo asifa na suo suomokokino, asi nau lokuko nokoni asifa. Nonani hani monoi Siyoli Nokotayo na imonoki.” Aino kumokaiki, Iyolomaiyayo mo. ");
INSERT INTO amm_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Nomai no mo, Isiso mo komano nokota siyolini molo timai na toloki. Na utolumoki, “A, nono no Yuto noko samukuko nokota siyoli na?” Na fowaki, “Wuo, no tiyomuni no, ainoso na motu.” ");
INSERT INTO amm_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Lotu samukuko noko sisiyoliwoi nokotalo iyaliwoi, toiyo faumikino, ulai Isiso mo fowakowoi muwoi. ");
INSERT INTO amm_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","No monoi no Pailatoyo imoki, “Nakomo nokoni imo pa tukwaikoniso, no tokosiyokononini no.” ");
INSERT INTO amm_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ulai Isiso mo fowawoi muwoi, tomokiwaiki. Wiyou, na mulumoloko manoki, Pailatoyo. ");
INSERT INTO amm_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Pasowa popomai kalopulo noko siyasonuso pokolali uku taikiyomosiki, komano nokota siyoliyo. Ukouniyaiko si noko nokolaloso putolukomosiki, “Noi nokota siya no tokolali unu taikiyo?” ");
INSERT INTO amm_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Isiso uwokaimai, nomai no mo uo nokota koiyau mo kalopulo nuso potolokainoki. Tani siyolo mo Palopaso. ");
INSERT INTO amm_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","No monoi no mo, noko nokolalo ukouniyaikokaiki mo, Pailato mo na ikoki, “Moloi tomulumolokonuwo? Noi nokotaso tokiyo taikiyo, moini auso no? A, moloi, Palopasoso tokiyo taikiyo, o, Isisoso tokiyo taikiyo, Kolaiso no tokaluwai manonuwo no.” ");
INSERT INTO amm_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","To mo sai, Isiso monoi foluwalikino mo, lotu samukuko nokoyo, no monoi no tani auso kiyoma tumokino, uo imo lukaso unukino. ");
INSERT INTO amm_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nosai no mo; Pailato mo imo kwai monoi no yousikainoki mo, totani noniyo imo na yomuso taikiyoki, noino, “Yo somiso nokotaso mo afonimaiso noiyo uwoyoi. Amolokimai yo mo solitonoluwai, mulu mo na kalomonokai.” ");
INSERT INTO amm_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ulai lotu samukuko noko sisiyoliwoi nokotalo iyaliwoi toiyo noko nokolaloso ainiko ifoluwaikokino, Isiso tukolo monoi. Ikokino, “Pailatoso na piko, Palopaso mo kalopulo nusai kiyo taikiyumo, Isiso tukolumo.” ");
INSERT INTO amm_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Nosai no komano nokota siyoli Pailato mo ti monoi na ikoki, “Moloi tomulumolokonuwo, ninani nokota ti monoi no, noiso tokiyo taikiyo?” Imokino, “Palopasoso na pokiyo taikiyo.” ");
INSERT INTO amm_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ulai Pailato mo na ikoki, “Yo no moloi tuwo, woi, Isiso no, Kolaiso ni tokaluwai manonuwo no?” Noko nokolalo komaso noko mo na iyamo taikiyoki, “A mokimai na pukou ukou nikomokaiwo.” ");
INSERT INTO amm_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ulai Pailato mo na ikoki, “Ulai hani monoi, hani foli monoi, woi?” Ulai siyoliso na iyamalo manoki, “A mokimai na pukou ukou nikomokaiwo.” ");
INSERT INTO amm_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Wiyou, toini uo mo siyoli, mulu mo puwoso puwoso. Pailatoni imo mo kwaiwoi muwoi. No monoi no yomuki, “Tofolo.” Nosai no iwo woliyonoki, naino mo iwoso na solikaikoki, noko nokolaloni molo timai. Na ikoki, “Yo mo moini molo timai naino tuluwako, moi saino monoi, yo mo wiyou tiyomu, ninani nokotani nako amukono monoi mo. Ulai kalakimo, yani hani muwoi, moini hani nali no.” ");
INSERT INTO amm_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Noko nokolalo komaso mo imokino, “Koini hani nali no. Kotoyo uwomoko monoi mulumolokakimo, koiwoi kokaini alalowoi waliyo, tofolo, na uwokaimokumo.” ");
INSERT INTO amm_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","No monoi no Pailato mo Palopasoso kiyoko taikiyo fuki. Isisosu mo polimano noko iyalini auso na kiyoko taikiyoki, na ikoki, “Suwoi suwoi moloyo na puwasowo. A mokimai na pa ukou ukou nikomanowo.” ");
INSERT INTO amm_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Nosai no mo; komano nokota siyolini polimano noko iyaliyo Isiso kawiyo tikino, komano nokota siyolini imo lukaso nu siyoli poiso. Polimano noko komaso noko mo ukouniyaikokuya tumokino, ");
INSERT INTO amm_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Alisiyolikino mo, tuno asiyonowaikino, nakiyaiso tuno itouniyaimoyo na asisikaimokino, siyoli nokotani tuno nali. ");
INSERT INTO amm_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Yoku mo suwoi suwoi moloso poiyakimo unukino, no monoi no na asisikaikomokino, komuso. Atou koiyau nainasai mo anonikino. Nosai no mo; alokomu losinasi unukino, na alisiyoli yoluwaikino, “Woli, Yuto noko nokolalo samukuko nokota siyoli nono kuo.” ");
INSERT INTO amm_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Usuwoyo na aso kolo manokino, atou imokino kusomi, komumai na waso manokino, saiso saiso. ");
INSERT INTO amm_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Alisiyoliyoluwai uwai; pau tuno sopo asiyonowaikino, totani tunoyoso asisikaimokino. Na kominalomanokino, a mokimai ukou ukou nikomokai monoi na. ");
INSERT INTO amm_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Molomai nu manoki mo, Sailini asi nokotayo na tumoki. Tani siyolo mo Saimo. Ulai polimano noko mo totamikino, imokino, “Oi, a moki ni posokunalomako.” ");
INSERT INTO amm_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nosai no mo; Kalokato yufa mo na komama tumokino. Moini imosai mo Komu Foli Yu. ");
INSERT INTO amm_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Tomu itowoi iwo louwa woliyononikino. Louwa sikoki, ulai sikowoi muwoi. ");
INSERT INTO amm_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Nosai no mo a mokimai na ukou ukou nikomokino. Ukou ukou nikomokai uwai; tani tuno totai amu wau monoi tomoki lolofayo na somaimo ukukino. ");
INSERT INTO amm_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tuno i uwai; tolomuso amai siki, Isiso na samuku siki. ");
INSERT INTO amm_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Komu puwosaimi mo noino na kumokaikino, “Ni mo Isiso na, Yuto noko nokolalo samukuko nokota siyoli.” Nonani foli monoisu tukolokino. ");
INSERT INTO amm_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ulai polamoko nokota ti, toti mani, Isisoni kwasai ukou ukou nikokaikino, a moki tiwoimai. Siya mo nainasai, siya mo sokonisai. ");
INSERT INTO amm_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ifou ifou ti liyai noko nokolaloyo palisiyoli yoluwaikaiyo tumomosikino. Totaini komuso pokolikali yomuwaniyo tumomosikino, ");
INSERT INTO amm_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","na pimomosikino, “A, lotu nu siyoli ulalo nokota na? Ulai nono no lotu nu tonofalo no ulo tauwoimai ko uwaimoinimo? Nona amu na pofasi. Ulai nono mo Kotoni alu mo, a mokisai na pofolamiyo kono.” ");
INSERT INTO amm_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Lotu samukuko noko sisiyoliwoi Musini imo sai sisiyoli nokowoi nokotalo iyaliwoi, toi mani, na alisiyolikino, ");
INSERT INTO amm_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Noko nokolalososo pofasiko manoki, ulai tota amusu mo pakoso tofasiso. To mo Isolilo noko nokolalo moi samukukomomoko nokota mo, a mokisai mo utukaimiyo konu. Ainoso yakimo, koi mo waliyo na mulumolo luwaiyoikimo. ");
INSERT INTO amm_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","To mo Kotoso mulumolo luwai nokota, na tiyomu, “Yo mo Kotoni alu na.” Ulai Kotoyo mulu unakimo, konoimaiso mo na fasiyumo.” ");
INSERT INTO amm_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Isisoni kwasai ukou ukou nikokai nokota ti mani, tomoso na alisiyolikino. ");
INSERT INTO amm_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ulo yakomai, ulo mo na lotiki, asi asi komaso mo na folosumono kolokaloki. Ainoso hani upimo tanoki. Nosai no ifou wi taikiyoki. ");
INSERT INTO amm_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Nomai no Isiso mo siyoliso na yomuki, totani imosai yomuki, “Iloi, Iloi, lama sapakotani?” Moini imosai mo noino, “Asani Koto, asani Koto, hani monoi tukwaimonokaini?” ");
INSERT INTO amm_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Nosoni si noko siyaiyo Isisoni imoso no kwaimokino mo, na iyamoki, “Ilaiyaso na taliyoni.” ");
INSERT INTO amm_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nosai no toi nokotayo somu somu mo somaiso na fumo akanoki. Itolowoi iwoso solikaikanoki, poni aumai konosuwakokaiki. Isisoni koso na louwa you akaikomoki, iwo woliyononi monoi louwa fi. ");
INSERT INTO amm_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ulai noko siyaiyo nosoni no siki no, toiyo alukimokino, na imokino, “Awi, na tukwai kikoni. Ilaiya mo amai poimo tofasiya tumo.” ");
INSERT INTO amm_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Nosai no mo; Isiso mo ti monoi siyoliso na omoki. Omo uwai; tani mulu mo Kotoni auso monoi na kiyo taikiyoki, koma, yau na kaloki. ");
INSERT INTO amm_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Nomai no mo, wiyouwa wiyou, tuno siyoli lotu nu siyoli kokiko poiso no kitafoli kukiyokaikino no, nonani tuno mo na poliyaliyaiko taikiyoki, puwosai na you poliyaliyaikalo konoki, woiso. Asi mo na kumolomo taikiyoki, tomokiwoi na posilu taikiyoki. ");
INSERT INTO amm_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Noko aiko uku asiwoi na kolalifoliyafoumo uku taikiyoki. Kotoni noko nokolalo molopoi no kolikaliki no, toi mo ifou na auwonoulu liyaiki. ");
INSERT INTO amm_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Noko aiko uku asisai mo na utukaimo liyaikino. Isisoyo yausai ifou auwoniyou uwai, nomai no mo Yolusolimo nokonu siyoliso tiki. Noko nokolalo molopoiyo na kokalokino. ");
INSERT INTO amm_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Isiso kaloki mo; nosai no polimano iyali mo kokolokoki. Polimano nokowoi toi samukuko nokota siyoliwoi, Isisoso no samukukino no, toi mo kokolokoki. Asi kumolomowoi hani hani fiyamosokowoiso no kwaikokino mo, siyoliso na kokolokoki. Na iyamoki, “Motu nali, noko to ni mo Kotoni awitono na.” ");
INSERT INTO amm_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nokolalo molopoi mani, posiki, Kalili asisai no aluwainiyo tumokino no, tota fasiyalo monoi. Aluwamaifa siki, na kwaikino. ");
INSERT INTO amm_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Toi nukonu siya mo Moili, Makotalo asi nukonu. Moili siya mo Yamisowoi Yusifowoi totini atino. Noni siya mo Sipitini alalo tini atino. ");
INSERT INTO amm_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Nosai no mo; upimoso mo muwoni molopoi nokota, Alimatiyo asi nokota, Yusifo, to mo na tumoki, Isisoni moloso aluwai nokota na. ");
INSERT INTO amm_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nonani nokota mo Pailatoso na imanoki, “Yo no Isiso yau no waliyo totokomonano, ai unano monoi?” Fowaki, “Waliyo na.” Polimano noko iyaliso na ikoki, “Isiso yau mo na panoniwo, Yusifoso.” ");
INSERT INTO amm_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","No monoi no Yusifo mo Isiso yau na ananoki, kamoso tuno itouniyaimoyo na yalokonoki. ");
INSERT INTO amm_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Totani yu asi i tonofaloso na akaiyanoki, toku yasoi no aikaiki no. Nosai no tomoki tofu siyoliso na lolomotaiki, asi i ufiyaimo monoi. Uwai; nosai no mo yasoi. ");
INSERT INTO amm_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Moili, Makotalo asi nukonuwoi Moili siyawoi, totiyo yu asi i aumoifaso yousikainokino. ");
INSERT INTO amm_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Isiso kalomai mo mi fou fouko koloni foukai ulo na. Nosai no mo; amuwoisai lotu samukuko noko sisiyoliwoi Falisi moloso aluwai nokowoi, toi mo Pailatoni auso na ukouniyaiko kuyanokino. ");
INSERT INTO amm_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Na imokino, “Noko Siyoli, koi mo imofaso tomulumolokonoki, noino. Topoko nokota mo molotano tolomai mo na yomuki, “Amoloki tiwoi uwai; ulo siya mo ifou na auwoniyouwoimo, yo mo.” ");
INSERT INTO amm_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","No monoi no na piko, polimano noko iyaliso, nonani yu asi i itu loti mo atiyaiso na asi itouniyaimowumo, na samuku itouniyaimowumo, ainoso amoloki tiwoi mo uwai. Wonikaluso siyokutono iyaliyo noko nokolaloso aiko ifoluwaikaloino, “Yausai ifou yasoi na auwoniyou.” Wiyou, kwaimo muwoi, tokumi ifoluwaiko imo na souwaiyoimo.” ");
INSERT INTO amm_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pailatoyo ikoki, “Polimano noko siyaiso na pako kolisiyonowo, itu loti samuku monoi. Atiyaiso na pa kouniyaikowo, momaiyo no tiyo manonuwo no, noinani komiyai.” ");
INSERT INTO amm_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","No monoi no yu asi i itu loti na asikaiyanokino, na molosokukaikino. Molosokukaikino mo; polimano noko siyaiso na ikokino, itu loti samuku si monoi. ");
INSERT INTO amm_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Mi fou fouko ulo mo uwai; amuwoisai posasi, Moili, Makotalo asi nukonuwoi Moili siyawoi, toti mo Isiso yau mo na kiya tumokino. ");
INSERT INTO amm_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Nomai no lolai siyaso nou nou siyoli mo na tumoki. Siyoli Nokotani kumoki nokota mo kumokisai na amukonoki, asi i ufiyaimo tomoki tofu siyoli na lolomotaiki, itu loti kolali foli monoi. Nonani tomoki tonimai yousikainoki. ");
INSERT INTO amm_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Tani amu molo mo saloma momaliyomo komiyai na wi toloki. Tunowoi mani, kamo kamo mafomuso nali no. ");
INSERT INTO amm_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Wiyou, polimano noko iyali mo kokoloko manoki, kumolokoki. Na kalalotikoki, yau yau. ");
INSERT INTO amm_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nosai no mo; kumoki nokota mo nokolalo tiso na ikoki, “Noiyo kokolokomoiwo. Yo mo sai, Isiso yau mo tokiya tumonuwo, nonani nokota a mokimai no ukou ukou nikomokino no. ");
INSERT INTO amm_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Yau amai pa toiso. Yasoi na auwoniyou, toku no imokinuwo no. Yau akokai kwalososo na pokiya tiwo, uwofa nali. ");
INSERT INTO amm_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Somaiso na pomanowo, totani siyokutono iyaliso na pikanowo, “Yausai ifou yasoi na auwoniyou. Moi monoi toku yasoi na moi, Kalili asiso, na foukomanonuwo. Nosoniso na pa kiyanowo.” Aino na pikanowo, lolai ni timonukuwo no.” ");
INSERT INTO amm_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","No monoi no mo, nokolalo ti mo kokolo mulu, ulai moloki siyoli muluwoi na yokino. Asi i utukaimokino, somaiso na fufumuwanoki, siyokutono iyaliso ikano monoi na louwa fi. ");
INSERT INTO amm_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ulai Isiso mo molomai na koka tumoki, na ikoki, “Woli noko ti, moti kuo.” Aumoifaso manokino mo, fona timai komiyanokino, na losinasi yousa konokino. Wiyou, toti mo siyoliso na molokimokino. ");
INSERT INTO amm_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Na ikoki, “Noiyo kokolokomoiwo. Yani woli iyali na pikanowo, Kalili asiso kimonanowumo.” ");
INSERT INTO amm_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nokolalo ti mo moloso amai manomai polimano noko iyali, asi ai unu samuku noko iyali, toi mani, nokonu siyoliso nuki, lotu samukuko noko sisiyoli nokoso na ikanokino, nonani hani fiyamosi no monoi no. ");
INSERT INTO amm_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","No monoi no mo lotu samukuko noko sisiyoliwoi nokotalo iyaliwoi, toi mo ukouniyaikoki, imo na lukasokaikino. Lukasokaikino; no monoi no muwoni molopoi nikokino, polimano nokoso, ");
INSERT INTO amm_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","na ikokino, “Noko nokolaloso noino na pikalowo, “Totani siyokutono iyaliyo to yau mo yasoi polamona tumono, amoloki siyolimai, koi ulololi simai.” ");
INSERT INTO amm_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ulai komano nokota siyoliyo nonani imoso kwaiyakimo, koi fasiyoikuwomo, imo lukaso niyoikimo, no monoi no haniyo pa uwoyoinuwoso.” ");
INSERT INTO amm_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","No monoi no mo polimano noko iyali mo muwoni na ikino, toini imoso na kwaikokino. Nonani topoko imo mo na kolo kolomo liyaiki, komaso Yuto nokoni auso. Lolai mani, siyaiyo tiyamo, motuwo. ");
INSERT INTO amm_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Nosai no mo; siyokutono iyali, noko molo siya 11 noko, toi mo Kalili asiso na nuki, Isisoyo no ikoki no, nonani yuso na yoki. ");
INSERT INTO amm_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Isisoso na kiya yokino, na molokimokino. Ulai siyokutono iyali siyai mo mulu mo tiwoi mulumolokokino. ");
INSERT INTO amm_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Isiso mo aumoifaso no tumoki mo, na ikoki, “Kotoyo ami siyoli na amonoki. Asini hani haniwoi kumokini hani haniwoi mo yani nasu wosuwoiso na tosimoi. ");
INSERT INTO amm_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","No monoi no Kotoni imo mo asi asi komaso noko nokolaloso na pa lukasikalo liyaiwo, yani moloso na aluwaimonowumo. Iwoso pa uluwako liyaiwo, muwokokai monoi. Apou iyali koiwoi tomoso si monoi na pa muwokokaimokowo, Apou Siyoliwoi totani awitono asawoi totani Mulu Itouniyaimo Nokotawoi. No monoi no pa muwokokaiwo. ");
INSERT INTO amm_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Komaso imo ya no aiyolokomo manokinukuwo no, nonani imoso na pa aiyolokalo liyaiwo, toiyo kwai itouniyaimo monoi mo. Na pukwaiwo. Yo mo aniyopa poi poi na tolo tomasimo manoikuwomo, ainoso hani asi fokumoi.” ");
INSERT INTO amm_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ni mo imo itouniyaimo, Isiso Kolaiso monoi, Kotoni awitono. Noino na fiyamosiki, ");
INSERT INTO amm_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kotoni mulu lukasiko nokota Aisaiyayo no kumokaiki no, noino, “Pukwai, asani imo lukasikalo nokotaso imo taikiyoimo, to mo toku na manoimo, nono monoi. Molo na yono foumaloinimo.” No mo Kotoyo totani awitonoso toku imokaiki. ");
INSERT INTO amm_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Imo siyai mani, Aisaiyayo na kumoki, ninoino, “Nokoyo imo siyoliso yomoimo, nu somiso asimai. Na iko toloimo, “Molo koiyauso na putukaimowo, molo itouniyaimoso na pa aluwaiwo. Noko Siyoli mo tumoimo. Na pofoumowo.” Aisaiyayo aino na kumoki. ");
INSERT INTO amm_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","No monoi no mo, Kotoyo noko mo na imo taikiyoki. Tani siyolo mo Iyono, iwoso uluwako nokota. Nu somiso asiso na tola tumoki. Kotoni imo lukasiko toloki, noko nokolaloso, na ikoki, “Mulu na palosokomowo. Alosokomakinuwomo, iwoso uluwakomoikuwomo, Kotoso muwokomokainoni monoi. No monoi no molo koiyau monoi imo mo futo.” Aino iko toloki. ");
INSERT INTO amm_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Wiyou, noko nokolalo molopoi mo Iyonoso pokiya tumo liyai manokino, Yutiya asi nokowoi Yolusolimo nokonu nokowoi na poti liyai manoki. Iyononi imoso kwaikino mo, mulu mo yau yau, na iyamo liyaiki, “Woi, koi mo molo koiyausoso na taluwai manonoki.” Iyamoki mo; nosai no Iyono mo Yotano iwoso na uluwakoki, Kotoso muwokokainoni monoi. ");
INSERT INTO amm_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Iyono mo tuno koiyauwoiso potolo manoki, kamilo koloni au wiyo tuno na. Toukosiyo potomanomomosiki. Somo saso ponoko manoki, nuwoi iwoso posiko manoki. ");
INSERT INTO amm_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Kotoni imo na posaso wiyotiki, noino “Noko siya mo namolisai amai tumoimo. Tani ami mo siyoli. Yani ami mo koufasu. Yo no moloi fasi monoi? ");
INSERT INTO amm_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yo mo iwoso tuluwakomonukuwo. Totasu mo Kotoni Mulu Itouniyaimo Nokotaso na imo taikiyoimo, momaini mulu poiso. No monoi nosu muwokomo kaininoinuwomo, Kotoso.” ");
INSERT INTO amm_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Iyonoyo nu somiso asiso tolo manoki mo, Isiso mo kiya tumoki. Nasolito nokonusai tumoki, Kalili asisai. Ulai Yotano iwoso uluwaki, Iyonoyo. ");
INSERT INTO amm_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Iloso tola yoki mo; lolai siyaso mo kumoki poliyaliyaiso na kiki. Nosai no Kotoni Mulu Itouniyaimo Nokota mo na amukonoki. Anomu komiyai amukonoso na kwaiki, tani auso amukonoso. ");
INSERT INTO amm_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kumokisai ko na mo koloma konoki, na yomuki, “Nono mo yani alu na. Yo mo nono mulu mo siyoli. Yani mulu mo waliyo, nono monoi mo.” ");
INSERT INTO amm_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Nosai no mo; lolai siyaso Isiso mo Kotoni Mulu Itouniyaimo Nokotayo kiyo taikiyoki, noko somiso asiso. ");
INSERT INTO amm_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Tolo manoki tolo manoki, amoloki amoloki ulo ulo, 40. Tolo manoki mo, Sokolo Nokota Wai mo na louwa paini ifoluwaiya tumomosiki. Aku kolonini aumai potolo manoki, Isiso mo. Kotoni kumoki nokoyo pofasiya konomosikino. ");
INSERT INTO amm_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Nosai no mo; Iyono kalopulo nuso kiyokaikino mo, Isiso mo Kalili asiso monoi na manoki. Noko nokolaloso mo na posasoko wiyotiyalomano mosiki, Kotoni imo itouniyaimo mo. ");
INSERT INTO amm_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Na ikoki, “Kotoyo samukukomo ulo mo aumoifaso na fiyamosiyoimo. Aumoifaso na samukukomoinuwomo. Mulu na palosokowo. Imo itouniyaimoso na pomulumolo luwaiwo.” Aino na pikomosiki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Nosai no mo; Kalili iwo toku ilo kwa kwaso manaloki, Isiso mo. Saimo noko tiso koka tumoki, auwatono Anotoluwoiso. Toti mo la imo na kuo tolokino, la i nokota ti na. ");
INSERT INTO amm_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Na ikoki, Isiso mo, “Yoso na paluwaimonowo. Ya amai wiyononinoikuwomo, noko kolisalo mano mi mo.” ");
INSERT INTO amm_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ikoki mo; somaiso la imo utukaikokino, na aluwaikino, Isisoso. ");
INSERT INTO amm_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Nosai no mo; amunofamoki mo, Sipitini alalo tiso na koka tumoki, Yamisowoi auwatono Iyonowoiso. Ayou siyaso piyousikino, la imo topoliko yousikino. ");
INSERT INTO amm_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Lolai siyaso na aliyonikalomanoki. Aliyonikoki mo, apitono Sipiti iyaliso na utukaikokino, Isisoso na aluwaikino. Apitonowoi tani mi ano nokowoi, toi mo ayoumai amai siki. ");
INSERT INTO amm_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ulai nosai no mo; Kopanaumo nokonuso nuki. Mi fou fouko ulomai mo Isiso mo lotu nufa poiso somaiso lotiki. Aiyoloka tiki, noko nokolaloso. ");
INSERT INTO amm_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Na kufaukoki, totayo aiyoloko monoi. Moloi monoi woi? Musini imo sai sisiyoli noko komiyai aiyolokowoi muwoi. Isiso mo mulu ifolaluwawoi nali no, no monoi no aiyoloko itouniyaimoki. ");
INSERT INTO amm_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Popuwa koiyauyo uwokaikai nokota mo nosoni yousikainoki, lotu nu poiso. Nosai no mo siyoliso na yomaloki, Isisoso na imoki, ");
INSERT INTO amm_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Isiso, Nasolito nokota, hani monoi totumo unumokoni? Hani monoi tuwokaimoka tumoni? Yo mo sai, nono mo Kotoyo imo taikiyo nokota nali.” ");
INSERT INTO amm_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ulai na ikimoki, “Wosu woso, nokoni auso na putukaimo.” ");
INSERT INTO amm_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nosai no mo na fafololomanikomo kaiyouki, siyoliso omo kukoluwaiki, na utukaimoki. ");
INSERT INTO amm_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Wiyouwa wiyou, noko nokolalo mo na mulumoloko manokino, totai amu na ikuwanalokino, “Hani imo, woi? Imo tonofalo na. Wiyouwa wiyou, ami mo siyoli, to mo. Popuwa kopokoiyauso iko mo, tani imo mo na kwaimono.” ");
INSERT INTO amm_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nonani popuwa amiyaikiyo imo mo somaiso kolo kolomo liyaiki, Kalili asi komaso noko nokolaloni auso. ");
INSERT INTO amm_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Nosai no mo; Isiso iyali mo lotu nufasai fuki. Saimo noko ti, Anotoluwoi, totini nuso somaiso nuki, na tiki. Yamiso noko tiyo aluwaikiyo tikino, Yamisowoi Iyonowoiyo. ");
INSERT INTO amm_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Saimoni amokitono mo ai na potasoki, au momono na. Isisoyo lolaloso lotiki mo, na imokino, “Ai tuwoso.” ");
INSERT INTO amm_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Nosai no ai nukonuni auso lotiki. Nainosai na komisiyouki. Au momono mo futo. Koloni ta na notiki. ");
INSERT INTO amm_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Upimomai, ulo mo ku poki, nosai no mo, ai ai nokowoi popuwayo uwokaikokai nokowoi na kiyokoma tumo liyaikino, Isisoyo ititounikai monoi. ");
INSERT INTO amm_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Saimoni nu itu lotimai mo noko nokolalo saso, tolomu nokoyo ukouniyaiko siki. ");
INSERT INTO amm_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ai ai noko nokolalo molopoiso ititounikai manoki, hani hani ai ai nokoso. Popuwa mani, na amiyaikiyokoki. Toi mo sai, Isiso monoi mo, no monoi no ikikoki, “Wosu woso, yani siyolo noiyo kaluwai wiyotiyaloiwo.” ");
INSERT INTO amm_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Somosaiyamai Isiso mo auwonoki, posasowoi muwoi. Na amufuki, noko somiso asiso manoki, Kotowoi imo lukaso niyanoki. ");
INSERT INTO amm_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Saimo iyaliyo namolisai tanomokino, ");
INSERT INTO amm_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ikoliyalokino. Kikino mo, imokino, “Noko nokolalo komaso mo tikoliyaloni.” ");
INSERT INTO amm_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ulai na fowakoki, “Wiyou, tofolo. Moi soiwo. Aumoifa aumoifaso nokonuso na tonu liyaikoni. Yo mo Kotoni imo posasoko wiyotiyalo monoi tiyomu. Nonani monoisu na tumoki.” ");
INSERT INTO amm_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nosai no mo; yasoi, Kalili nokonu nokonuso liyaiyalo manokino. Isiso mo Kotoni imo lukasikaloki, totaini lotu nu lolofaso. Popuwa amiyaikiyoko uwokalo manoki. ");
INSERT INTO amm_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Nosai no mo; uluoyo uwokaikai nokota mo Isisoso na kiya tumoki. Alokomu losiyaiko yousa tumoki, na utolumaloki, “Yo no waliyo titouniyaimomononi?” ");
INSERT INTO amm_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","No monoi no mulu kalo unuki, Isisoyo mo, nainoyo na akaikomoki, na imoki, “Yo mo waliyo na tiyomu, noko itouniyaimo na totoloni.” ");
INSERT INTO amm_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Imoki mo; lolai siyaso uluo mo na kokamoko taikiyoki, noko itouniyaimo na toloki. ");
INSERT INTO amm_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Lolai siyaso imo taikiyoki, Isisoyo mo, imo amiso imoki, ");
INSERT INTO amm_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Nokoso noiyo ikaloi, ainonani monoi mo. Nani au mo lotu samukuko nokotaso na powiyoninano, totayo koloniyo utunoni unoinimo, Kotoso, toku Musiyo no yomukaiki no. No monoi no noko mo sai, nani uluo mo kokamokokai, noko itouniyaimo na totoloni.” ");
INSERT INTO amm_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ulai noko to no mo, tota itouniyaimokai aino imo na lukasikalo manoki. No monoi no nokonu nokonuso no moloi loti liyai monoi, Isiso no? Noko ukoumo fiyaimokai monoi nokonu nokonuso pa poloti liyai manokiso, noko nokolaloni molo timai mo. Nu somiso asimai potolo manoki. Ulai noko nokolalo molopoi kiya tumo liyaikino. ");
INSERT INTO amm_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Posasi posasi uwai; nosai no mo; Isiso mo ifou na tumoki, Kopanaumo nokonuso. Imofaso kwaiyalokino, noko nokolaloyo, “Isiso mo yasoi na tumo, nuso niya yousikaino.” ");
INSERT INTO amm_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Wiyou, noko nokolalo molopoi mo na ukouniyaika tumoki. Nu mo ukou, noko nokolalo saso. Itu lotimai mani, na fiyokaikaikino. Isiso mo Kotoni imo posasoko wiyotiki. ");
INSERT INTO amm_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nosai no mo; noko koiyau na louwa kiyoma tumokino, Isisoni auso, naino fona nomolikomokai nokota mo. Toitati nokoyo sokuniyo tumokino, molo tokosimai. ");
INSERT INTO amm_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Itu loti mo noko nokolalo saso. Ulai moloi kiyoma ti monoi, Isisoni auso no? No monoi no nu komu tofuso yoki, kolaliyai molosai. Nu komu mulumai na ulalalo konokino. Isiso mo woiso ku toloki. Nu komu ulalo uwai; naino fona nomoli nokota mo ku kiyalo konokino. Molo tokosimai wosu woso na ku kiyalo konokino, molosai. ");
INSERT INTO amm_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ku kiyalo konokino mo; Isiso mo toini mulu poiso kokoki, totaso mulumolo luwaiso. No monoi no mo nomolikomokai nokotaso na imoki, “Woli, yo mo imo mo futo, nani molo koiyau monoi imo mo.” ");
INSERT INTO amm_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Musini imo sai sisiyoli noko toi mani, na siki, totaini muluyoso na mulumolokalo manokino, ");
INSERT INTO amm_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ninani nokota no hani monoi yomu, woi? To mo Kotoso na talisiyoli. Ulai noko siyayo no mulu koiyau no moloi afoliwai monoi? Koto saso mo sai, mulu kopokoiyau saloso monoi.” ");
INSERT INTO amm_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ulai lolai siyaso Isiso mo sai, toini mulu mo, na ikoki, “Hani monoi tomulumolokonuwo? ");
INSERT INTO amm_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nomolikomokai nokotaso ya mulu koiyau afoliwai monoi imo mo, moiyo pimononuwo, “Topokoniwo.” Ulai ya imakimo, “Pauwoniyou, molo tokosi palomako, na poliyaiyalo,” nosai no moloi imono monoi topokoni? ");
INSERT INTO amm_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Asi asi noko nokolaloni noko siyoli nokota yo mo mulu ifolaluwawoi nali, mulu kopokoiyau saloso uwoko ami mo yapoli, yo mo. Ya towiyononinukuwo, moiyo saino monoi.” Ikoki mo; naino fona nomolikomokai nokotaso na imoki, ");
INSERT INTO amm_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Na timonoki, pauwoniyou, nani molo tokosi palomako, nuso na pomoi.” Aino na imoki, tani ami mo noko nokolaloso wiyoti monoi, mulu kopokoiyau saloso uwoko ami mo. ");
INSERT INTO amm_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","No monoi no mo, noko nokolaloni molo timai mo na auwoniyouki, nomolikomokai nokota mo. Totani molo tokosiwoi somaiso na sokunalomakoki, yasoi. Kufaukaloki, noko nokolalo mo, Kotoni siyoloso kaluwaiyaloukino, na iyamoki, “Toku mo koi mo noinani mo kwai manowoi muwoi.” ");
INSERT INTO amm_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Nosai no mo; Isiso mo iwo tokuso ifou manoki. Ilomai na tola tumoki. Noko nokolalo molopoi molopoi nokoyo ukouniyaikokuya tumokino, Kotoni imo aiyoloko toloki. ");
INSERT INTO amm_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Nosai no mo; iwo tokuso utukaimoki, na manoki, Liwaiso na kiki, takiso nuso yousikainoso, Alofiyani awitonoso. Na imoki, “Kuku, yoso na paluwaimono.” Imoki mo; na amufuki, Isisoso na aluwaiki. ");
INSERT INTO amm_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Aluwai manoki mo, Liwaini nuso koloni no sanoki. Takiso muwoni i noko kopokoiyau noko molopoiwoi molo koiyauso aluwai noko molopoiwoi, toi mani, no fasiko siki, Isiso iyaliwoi. Noko molopoi mo aino na, Isisoso aluwaiyalo manokino. ");
INSERT INTO amm_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Musini imo sai sisiyoli noko siyai, Falisi moloso no aluwaikino no, toi mo fu kwaikokino, Isisowoi no fasi siso, molo koiyauso aluwai nokowoi takiso muwoni i nokowoi no fasi siso kwaikokino. Isisoni siyokutono iyaliso na ikokino, “Hani monoi tono fasiko, takiso muwoni i noko kopokoiyauwoi molo koiyauso aluwai nokowoiso no?” ");
INSERT INTO amm_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Nosai no mo; Isiso mo nonani imoso kwaikoki mo, na ikoki, “Ai ai somiso noko mo tokotani auso pa tonumoiso. Wiyou. Ai ai noko saso na tonumoi, tani auso mo. Yo no noko ititouni nokoni mulu alosoko monoi tumo noiyo? Noko kopokoiyau nokoni mulu alosoko monoi na tumo.” ");
INSERT INTO amm_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Nosai no mo; Iyononi siyokutono iyaliwoi Falisi moloso aluwai nokowoi, toi mo koloni au au siki. Si manoki mo, Isisoso na ima tumokino, noko siyaiyo, “Moloi monoi woi? Iyononi siyokutono iyaliwoi Falisi nokoni siyokutono iyaliwoi, toi mo koloni au au na tosi. Ulai nani siyokuno iyali mo koloni au au pa tosiso.” ");
INSERT INTO amm_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Nosai no mo; Isiso mo na ikoki, “Toi mo noni kauso nokotani siyokutono iyali komiyai. Tolo fasikomaiso, nomai no koloni wasi popo na totoi. Koloni au au no moloi si monoi? Tolo fasikomaiso, koloni au au pa tosiso. ");
INSERT INTO amm_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ulai namolimai mo nonani nokota mo noko siyaiyo komi kausiyakinomo, siyokutono iyalini aumai mo uwofa toloimo, nonani ulomai mo koloni au au na soimo.” ");
INSERT INTO amm_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ti monoi na ikoki, “Tuno tonufuwaso no moloi tokosano monoi, tokumi tunoso moloi topolimo monoi? Aino piyo mo, nonani tuno tokosanofayo tokumi tuno mo popoliyaliyaiko taikiyo, i loluwa siyoli na potoi. ");
INSERT INTO amm_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ninoino mani, nokoyo pa tiyomoiso, molo wamo ito iwo tonofalo mo tokumi koloni tunomai soluki muwoi. Nokoyo ainonani piyo mo, molo wamo ito tonofalo mo tokumi tuno mo na popoliyaliyaikaiyo kono, asiso posolitolomo. Koloni tuno no mani, na popoliyaliyai taikiyo. Noko mo molo wamo ito tonofalo iwo mo koloni tuno tonofalomaiso na tuwolikomoi.” Aino ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Mi fou fouko ulomai mo isi mulumai molomai nu liyaiki, Isiso iyali mo, paluwa tuo sosono isimai. Nu liyai manoki mo; siyokutono iyali mo paluwa u na tofukalokino, koso noko monoi. ");
INSERT INTO amm_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Falisi moloso aluwai noko, toi mani, aluwaikino, imokino, Isisoso, “Na pokoko, nonani monoi no hani monoi tiyono, siyokuno iyali no? Mi fou fouko ulomai mo ausu.” ");
INSERT INTO amm_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Nosai no mo; Isiso mo na fowakoki, “Ulai moi no Toiwi aino imo pa kwai manonuwoso? Ulai pa koko manonuwoso, ninani puko imo no? Toiwi iyali mo koloni mo uwofa mo, tiya na kolikaliki. ");
INSERT INTO amm_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Nomai no paluwa tuo iya tiki, Kotoni lotu nu poiso, paluwa tuo no mo, Kotoso muwokokainonikai yasoi. Nonani paluwa tuo mo afonimai noko mo au au. Lotu samukuko nokoyosu noko mo waliyo. Toiwi mo lotu samukuko nokota muwoi, ulai na noka tiki. Apiyatasu, totawoi lotu samukuko nokota siyoli, totayosu niki, paluwa tuo mo. Siyokutono iyaliso mani, nikoki, Toiwiyo mo. Na nokokino. ");
INSERT INTO amm_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Toku mo Kotoyo noko mo na mulumolokoki, na auwonouluki, namolisai mo mi fou fouko ulo kaluwaiki, noko fasiko monoi. ");
INSERT INTO amm_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","No monoi no asa, asi asi noko nokolaloni noko siyoli nokota asa mo mi fou fouko ulo na tosamuku.” Aino ikoki, mi fou fouko ulo monoi. ");
INSERT INTO amm_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Nosai no mo; Isiso mo lotu nuso ifou lotiki. Naino nomoli nokota mo piyousikainoki. ");
INSERT INTO amm_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Isisoso molo amiso na kwaikino, noko siyaiyo, na mulumolokokino, “Moloi tiyo, woi, mi fou fouko ulomai no? Konoi no amai titouniyaimokai, woi?” Faumiko monoi louwa fi yokino, no monoi no molo amiso kwaikino. ");
INSERT INTO amm_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Nosai no mo; naino nomoli nokotaso na imoki, “Na pauwono, mulumai na potolau.” ");
INSERT INTO amm_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Imoki mo; na louwa ikoki, nokoso, “Musini imo no moloi tiyomuko? Molo koiyauso aluwai mo waliyo poimo, molo itouniyaimoso aluwai mo waliyo poimo, mi fou fouko ulomai mo. Ai nokota tofasikoni poimo, tofolo, na kaloimo poimo.” Ainonani monoi louwa ikoki. Pa fowakinoso. ");
INSERT INTO amm_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nosai no kwailuwaikaloki, mulu atolokomoki, toini mulu poiso kokoki, mulu wapu wapu saso. Mulu mo yau, to mo. Naino nomoli nokotaso imoki, “Naino mo na pofouko.” Nosai no mo naino na foukoki, waliyo na takoki. ");
INSERT INTO amm_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nosai no mo; Falisi moloso aluwai noko mo fuki, Hiloni siyokutono iyaliwoi somaiso ukouniyaikanoki. Isiso tukolo imo monoi na lukaso unukaikino. ");
INSERT INTO amm_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Nosai no mo; Isiso iyali mo Kopanaumo nokonuso utukaimokino, iwo tokuso nuki. Kalili asi noko nokolalo molopoi mo na aluwaikino. ");
INSERT INTO amm_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Noko nokonu noko mani, ti liyai manoki. Yutiya asi nokowoi Yolusolimo nokonu nokowoi Itumiya asi nokowoi Yotano iwo ausaimi si nokowoi Taiya asi nokowoi Saito asi nokowoi, toi komaso mo Isisoni auso ti liyai manoki. Imoso toku yasoi kwaikino, Isisoyo hani hani yo imoso, no monoi no mo na ti liyai manoki. ");
INSERT INTO amm_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Nosai no mo; Isiso mo siyokutono iyaliso na ikoki, “Noko nokolalo molopoi molopoi na tosi liyai. Wonikaluso aiko fiyokaimonokaiyoino. Ayouyo mo toku na pofoukaiwo, yo folamiyo kono monoi mo.” ");
INSERT INTO amm_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Ulai afonimaiso, toku mo ai ai noko ititounikaiki, no monoi no mo ai ai nokoyo mo amai na fiyokaimokaikino, nainoyo komiyalo monoi. ");
INSERT INTO amm_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Popuwa kopokoiyauwoi nokoyo kikino mo, tani fokutonomai alokomu losinasikino, siyoliso iyamaloki, na imokino, “Nono mo Kotoni awitono.” ");
INSERT INTO amm_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ulai ikikoki, “Yani siyolo noiyo kaluwai wiyotiyaloiwo.” ");
INSERT INTO amm_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Nosai no mo; Isiso mo yuso amiyoki, noko siyai aliyonikoki, totani muluyososu muwokokai monoi. Aliyonikoki mo; tani auso na yoki. ");
INSERT INTO amm_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Nosai no noko molo tiwoi mo na muwokokaiki, totawoi si tomasimo monoi, Kotoni imo posasokalo monoi. ");
INSERT INTO amm_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ami niko monoi yomukaiki, popuwa amiyaikiyoko monoi. ");
INSERT INTO amm_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Noko molo tiwoi muwokoki, noino, Saimo, siyolo siya kaluwaiki, Pita. ");
INSERT INTO amm_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Sipitini alalo ti, Yamisowoi auwatono Iyonowoi, totini siyolo siya kolaliki, Powonisi. Nonani imo folosai mo noino, sauku komiyai nokota ti. ");
INSERT INTO amm_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Siyolo siyolo siyai mo noino, Anotolu, Filipo, Patolumiyo, Matiyu, Tomo, Yamiso, Alofiyani awitono. Siya mo Tatiya. Siya mo Saimo siya, siyolo siya mo Siloto. ");
INSERT INTO amm_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Siya mo Yutaso Isokailiyo, Isiso uo nokoni auso kiyo taikiyo nokota. Isiso mo nonani molo tiwoi noko muwokokaiki. ");
INSERT INTO amm_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Nosai no mo; Isiso iyali mo nuso nuki. Koloni no monoi louwa, ulai noko nokolalo molopoiyo ti monoi ukouniyaikokukokino. ");
INSERT INTO amm_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Isisoni nako siyamai iyaliyo nonani imoso no kwaikino mo, na auwonouluki, na nuwalo manoki, louwa kausiyanokino, na iyamoki, “To mo mulu wapu na.” ");
INSERT INTO amm_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Atino iyali molomai ti liyaiki mo; nosai no mo; Musini imo sai sisiyoli noko mo Yolusolimo nokonu siyolisai kunoki, na iyamoki, “Popuwa mo tani amiyo pa amiyaikiyokoso, popuwa samukuko nokota siyolini amiyo na tamiyaikiyokomoi, Pilisipulo Waini amiyo.” ");
INSERT INTO amm_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Nosai no mo; Isiso mo aliyonikoki, “Kukuwo, yani auso na potiwo.” Siyokawi imo na ikaloki, “Moloi woi? Sokolo Nokota Wai tota amu no moloi amiyaikiyo monoi? ");
INSERT INTO amm_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Asi siya noko iyaliyo totai amu tukoluwanakinomo, totai amu pa asisikuwanoinoso, si itouniyaimowoi muwoi, pa si itouniyaimoiso. ");
INSERT INTO amm_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Nu siya noko iyali mani, totai amu tukoluwanakinomo, totai amu pa asisikuwanoinoso, kwaimo pa soiso. ");
INSERT INTO amm_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Sokolo Nokota Wai iyaliyo totai amu potukoluwanono mo, kwaimo pa posiso. Totai amu asisikuwano somiso mo, pa potolo itouniyaimoso, Sokolo Nokota Wai mo. Na puwaimo taikiyo.” Aino ikoki. ");
INSERT INTO amm_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Siyokawi imo mo ti monoi na ikoki, “Ulai noko siya mo noko ami nokotani nuso afonimaiso lotiwoi muwoi, polamoko monoi. Wiyou, toku noko ami nokotani naino timai tokonosuwakokai, moloyo. Konosuwako uwai; nosai no na topolamoka ti.” Aino ikoki, siyokawi imo mo. Imo folosai imo mo noino. Isiso mo Sokolo Nokota Waiso tosouwaikai, no monoi no popuwa mo waliyo tamiyaikiyokomoi. ");
INSERT INTO amm_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Nosai no mo; ti monoi na ikoki, “Motuwa na timonukuwo. Kotoyo noinomo hani hani molo kopokoiyau foli monoi imo mo futo. Alisiyolikalo monoi mani, imo mo futo. ");
INSERT INTO amm_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ulai nokosu mo Kotoni Mulu Itouniyaimo Nokotaso alisiyoliyakimo, Koto mo nonani alisiyoli imo foli monoi imo mo futo muwoi, amai. Wiyou, nonani alisiyoli imo foli mo amai na tano manoimo, aniyopa poi poi.” ");
INSERT INTO amm_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ulai afonimaiso, Isisoyo aino yomuki. Noko sisiyoliyo iyamoki, popuwa koiyauwoi tolo nokotawo. ");
INSERT INTO amm_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Nosai no mo; Isisoni atinowoi auwatono iyaliwoi, toi mo tiki, na louwa kiya tumokino. Asiyofoloso fu siki, imo iko taikiyokino, Isiso na amufu mo. ");
INSERT INTO amm_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Noko nokolalo molopoi ukouniyaikoku siki, na imokino, “Anoni auwano iyali mo asiyofoloso fu si. Na tokiya tumoni.” ");
INSERT INTO amm_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ulai Isiso mo na imoki, “Yani anoiwoi auwa iyaliwoi no noiwo noko, woi?” ");
INSERT INTO amm_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ukouniyaikoku si noko nokolaloso kokaloki, na yomuki, “Yani anoi auwa iyali mo niya si. ");
INSERT INTO amm_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Nokoyo Kotoni imoso kwaimono mo, toi mo yani anoi auwa inai iyali na.” Isiso mo aino na yomuki. ");
INSERT INTO amm_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Nosai no mo; Isiso mo iwo toku iloso ifou manoki. Kotoni imo aiyoloko monoi. Noko nokolalo molopoi molopoi mani, ukouniyaikokuya tumokino, no monoi no ayouso yousa konoki. Noko nokolaloyo mo upoisai si liyaiki, iwo toku kwa kwamai. ");
INSERT INTO amm_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Siyokawi imo na lukasiyoluwaiko manoki, na aiyolokoki, noino, ");
INSERT INTO amm_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Na pukwaiwo. Noko mo aliyoli ali tokosikwiyalo, isiso. ");
INSERT INTO amm_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Tokosikwiyalo mo, aliyoli ali siyai mo molomai na tosalo kono liyai. Uoyo na tonokalo tumono. ");
INSERT INTO amm_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Siyai mo tomoki asimai tosalo kono liyai. Asi somuso mo tanowoi muwoi, nonukanofa totoi. No monoi no mo somaiso na tauwonoulu liyai. ");
INSERT INTO amm_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ulai uloyo tokoko mo, na tonomoliko taikiyo. Totiwoi pa tosiso. ");
INSERT INTO amm_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Siyai mo molosu to to mulumai tosalo kono liyai. Molosu isi atoniyo tauwonoulu liyai, na tofiyokaikono. U mo pa tosiso. ");
INSERT INTO amm_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Aliyoli ali siyaisu mo asi itouniyaimomai na tosalo kono liyai, itouniyaimoso na tauwonoulu liyai. Puwoso puwoso; wamokomai mo u molopoi na tosi liyai. U siyai mo sisiyoli. Siyai mo sisiyoli nali no. Siyai mo wiyou, molopoi molopoi, soliyaki soliyaki.” Siyokawi imo aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Nosai no ti monoi ikoki, “Noko mo iyo uku somiso mo, imo mo na pa kwaimono itouniyaimowo.” ");
INSERT INTO amm_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Nosai no mo; noko nokolaloyo utukaimokino mo, aluwai noko siyaiyo imokino, noko molo tiwoi nokowoi noko siyaiwoi no aluwai manokino no, toiyo na imokino, “Siyokawi imo folosai na posaso wiyolumoko.” ");
INSERT INTO amm_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Na fowakoki, “Kotoyo mo moi samukukomo mulu yasoi wiyononikinuwo. Nonani kukalokokai imo mo momaisoso na wiyononikinuwo. Aluwaimono somiso noko, toi mo sai muwoi. Siyokawi imo saso na tolukasikomosi. ");
INSERT INTO amm_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","No monoi no, “Molo saso foinaliko manoinomo, ulai hani mo pa kiyoinoso. Imo saso kwai manoinomo, ulai imo folosai mo pa sainoinoso. Mulu palosokono mo, mulu kopokoiyau posaloso uwoko, Koto mo.” Aino tiyomuko, Kotoni puko imoyo mo.” Aino na ikoki, Isiso mo, siyokawi imo monoi. ");
INSERT INTO amm_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Nosai no mo; Isiso mo na ikoki, “Moi no ninani siyokawi imo folosai no sai pakoso? Siyokawi imo siyai no moloi sainoinuwomo, ya imakinukuwo no? ");
INSERT INTO amm_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Aliyoli ali nokoyo no tokosikwiyalo no, no mo Kotoni imo. ");
INSERT INTO amm_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Aliyoli ali molomai no tosalo kono liyai no, no mo Kotoni imo komiyai, nokoyo kwai monoi louwa. Ulai Sokolo Nokota Waiyo somaiso totumo, na tifoluwaika tumo, no monoi no Kotoni imo mo fufoli, toi mo. ");
INSERT INTO amm_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Aliyoli ali tomoki asimai no tosalo kono liyai no, no mo Kotoni imo komiyai, nokoyo tukwaino, toku na tomolokimono. ");
INSERT INTO amm_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Ulai nonani noko iyali mo toti somiso ali komiyai. Kotoni imo mo fokufaso na taluwai manono. Afonimai nokoyo Kotoni imoso aluwai monoi alukika tumakinomo, lolai siyaso namoliyo na alosimoinomo. Uo nokoyo uwoko monoi, no monoi no. ");
INSERT INTO amm_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Aliyoli ali molosu to to mulumai no tosalo kono liyai no, no mo Kotoni imo komiyai, nokoyo tukwaino. ");
INSERT INTO amm_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ulai asini hani hani monoi mulu tokolikalimoi, muwoni mulu monoiso na tiyo manono, hani hani ilolu muluwoi. Nonani asini mulu mo Kotoni imoso na tofiyokaikokai manono. Nonani noko iyali mo a wamo si somiso a komiyai. ");
INSERT INTO amm_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Aliyoli alisu asi itouniyaimoso no tosalo kono liyai no, no mo Kotoni imo komiyai, nokoyo tukwaino. Na tomulumolo luwaino. Nonani noko iyali mo a komiyai na tosimoi, a wamo molopoiwoi. Siyai mo sisiyoli. Siyai mo sisiyoli nali no. Siyai mo wiyou, molopoi molopoi, soliyaki soliyaki.” Isiso mo aino na ikoki, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Nosai no mo; Isiso mo ti monoi na ikoki, siyokawi imo mo, “Noko mo lamu ta asiyo takimo, falosisakimo, nauyo no moloi ufiyaiso monoi? Ulai kotisoko wosuwoiso no moloi akaiso monoi? Wiyouwa wiyou, puwoso na tafonikokaisomoi, fupiniyaimo monoi. ");
INSERT INTO amm_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Hani hani mo kukalokokai sakimo, nokoni molo timai fiyamosokoimo. Hani hani imo ufiyaikokai sakimo, saponimaiso soimo, noko saino monoi. ");
INSERT INTO amm_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Noko mo iyo uku somiso mo, imo mo na pa kwaimono itouniyaimowo. ");
INSERT INTO amm_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Imo ni tukwaimononuwo no, na pa mulumoloko itouniyaimowo. Atiyaiso mulumolokakinuwomo, Kotoyo noinomo sai sisiyoliwoi soinuwomo, wiyou, soliyaki na. Koufaso mulumolokakinuwomo, Kotoyo noinomo koufaso sainoinuwomo. ");
INSERT INTO amm_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Noko mo Kotoni imoso sainakimo, to mo Kotoyo aiyolomoimo, sai siyoliwoi toloimo. Nokosu mo koufaso sainakimo, nonani koufaso mani, fufolikomoimo.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Nosai no mo; Isiso mo na yomuki, “Kotoyo noko nokolaloso samukuko mo nokoyo aliyoli ali kosikwiyalo komiyai na. ");
INSERT INTO amm_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Amoloki amoloki nonani nokota mo ulololi totanomoi. Ulo yako mo toliyaimoi. Aliyoli alisu mo na tauwonoulu liyai. Ulai sisiyoli si monoi no, noko no moloi saino monoi? ");
INSERT INTO amm_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Asini miyoso na tanomoi, wamoko monoi mo. Toku mo muwoyo tauwonoulumoi. Muwoyo auwonoulu uwai; uwoi na tosi, nosai no na tuwamoko. ");
INSERT INTO amm_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Wamoko uwai mo, muwo mo somaiso timo kusomi, isi kiyo nokota mo, isini no na totokoso iyalo.” Aino na ikoki, siyokawi imo mo. ");
INSERT INTO amm_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Nosai no mo; Isiso mo ti monoi na yomuki, “Kotoyo samukukomo mi no moloi woi? Moloi towiyononinukuwo? Siyokawi imo no yapoli toi, ainonani monoi no? ");
INSERT INTO amm_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kotoyo samukuko noko nokolalo iyali mo sipoki ino komiyai. Nonani sipoki ino mo nokoyo tikaiyano. Sipoki ino mo a wamo ino siyai komiyai muwoi. Wiyou, siyoli muwoi, koufa. ");
INSERT INTO amm_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ulai ikai uwai; na siyoliso taikiyo, siyoli na totoloso. Isi aliyoli komasoso na tosouwaiko. Touwo sisiyoliwoi na tosi. Uo mo nonani a touwoso tosinona tumo liyai. Iwasuwo poiso waliyo tosi, fulomu monoi mo.” Isiso mo siyokawi imo aino ikoki. Totaso mulumolo luwai noko nokolalo mo molopoi molopoi soimo. ");
INSERT INTO amm_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Ainoso ainoso pikomosiki, Isiso mo. Siyokawi imo monoiso pikomosiki, noko nokolaloso. Siyai mo sai poimo, o, siyai mo sosoli poimo. ");
INSERT INTO amm_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Imo folosai imo mo noko nokolaloso lukasikowoi muwoi. Wiyou, siyokawi imo saso na pikomosiki. Imo folosai imo komaso mo siyokutono iyalisoso posasoko wiyolukaloki, siyokawi imo folosai mo, toi saino monoi mo. ");
INSERT INTO amm_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Nosai no mo; upimosomai siyokutono iyaliso ikoki, Isiso mo, “Soiwo, iwo ilo ausaimiso totikoni.” ");
INSERT INTO amm_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Nosai no mo noko nokolalo molopoiso utukaikokino, siyokutono iyaliyo na kaukino, ayou molosai, toku yasoi no yousiki no. Ayou siyai noko mani, aluwaikokino. ");
INSERT INTO amm_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Nosai no mo; imonu siyoli mo na auwoniyouki. Iwo mo ayou poiso na pukamofoliyo yoki, na koma liyoki. ");
INSERT INTO amm_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Isiso, to mo ayou kuomai ulololi na tanokainoki, komu kinasimai. Na lusiyaikiyokino, imokino, “Aiyolokomomoko nokota, aumoifaso iwoyo na totukuwoli solimoko. Hani monoi mulu pa tokalo unumokoniso?” ");
INSERT INTO amm_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Nosai no mo; na auwoniyouki, imonu siyoliwoi iwowoiso na ikauki, imo amiso, “Wosu woso.” Na tolosuwaki, imonu mo, iwo mi mani, futo. ");
INSERT INTO amm_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Na ikoki, “Hani monoi tokokolokomonuwo? Hani monoi pa tomulumolo luwaimononuwoso?” ");
INSERT INTO amm_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Wiyouwa wiyou, siyoliso na kokolokoki, siyokutono iyali mo, na lukasikuwanokino, “Hani nokota, woi? Imonuwoi iwowoi mo tani imoso na kwaimono.” ");
INSERT INTO amm_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Nosai no mo; imonu mo uwai; Isiso iyali mo iwo toku ilo ausaimi fiyamosiyanokino, Kilasa asiso. ");
INSERT INTO amm_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Isiso ayousai folamiyo konoki mo, iloso, popuwa koiyauwoi nokota mo somaiso na kiya tumoki. Noko aiko uku asisai tumoki. ");
INSERT INTO amm_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Noko aiko uku asi mo tani nokonu na, nosoni na potolo manoki. Nokoyo no moloi komikai monoi? Waiya moloyo mani, moloi konosuwa monoi? ");
INSERT INTO amm_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Waiya moloyo louwa pokonosuwakomo kaimosikino, naino ti fona timai. Wiyou, na potokosoulalo manoki, waiya molo mo. Ulai noko noiyo komikai monoi? Tani mi mo ami ami. ");
INSERT INTO amm_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Ulo ulo amoloki amoloki poliyaiyalomano manoki, noko aiko uku asiwoi yuwoiso, siyoliso na pomomosiki, tota amu tomokiyo posolamoulumosiki. ");
INSERT INTO amm_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Isisoyo iloso folamiyo konoki mo; aluwamai kwaiki, popuwawoi nokotayo mo. Na fuma tumoki, Isisoni fokutonomai losiyaiko una tumoki. ");
INSERT INTO amm_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Popuwayo noinomo noko mo imo siyoliso na imaloki, “Isiso, nono mo Kotoni awitono, Kota Kotoni awitono mo. Hani monoi totumo unumononi? Iyanoko noiyo uwomonoi. Kotoyo na tokimoko.” Aino imoki. ");
INSERT INTO amm_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ulai afonimaiso? Isiso mo toku yasoi imoki, “Popuwa koiyau, nokoni ausai na putukaimo.” ");
INSERT INTO amm_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Nosai no mo; Isiso mo na imoki, “Nani siyolo no moloi?” Na fowaki, “Popuwa molopoiwoi na totolo, no monoi no yani siyolo mo Ukouniyaiko.” ");
INSERT INTO amm_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Imalo manoki, Isisoso, “Aluwaso noiyo iko taikiyoi, yani popuwa mo.” ");
INSERT INTO amm_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Fu molopoi molopoi yufaso asi pono siki, aumoifaso. ");
INSERT INTO amm_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","No monoi no popuwa mo Isisoso imalokino, “Funi au poiso no waliyo tukwaiya kiyomokoni?” ");
INSERT INTO amm_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Fowakoki, “Waliyo na.” Nosai no mo; nokoso na utukaimokino, nonani popuwa kopokoiyau mo, funi au poiso na uloloniyo tiki. Tiki mo; fu mo koli siyolisai fufumuwana konoki. Iwo toku iwoso usukunalo kono liyaiki, iwoso na tukuwoli soliki, yau yau. Fu molopoi molopoi, 2000, na kolikali soliki, iwoso. ");
INSERT INTO amm_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Nosai no mo; fu samukuko nokoyo uloloki. Nonani monoi aino imo lukasikalo manokino, nokonu noko nokolaloso, nu siyasonuso asimai si nokowoiso. No monoi no noko nokolalo mo yasoi, nonani haniso kiyanokino. ");
INSERT INTO amm_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Isisoni au mo tiki mo, nokoso na kiya tumokino, popuwa molopoiyo utukaimo nokotaso. Tuno atolikaimokai. Kwalu kwalumowoi muwoi, mulu mo itouniyaimoso na popomuwakaiki. Kikino mo; na kokolokoki, toi mo. ");
INSERT INTO amm_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Popuwawoi nokota itouniyaimokaiso ki noko, totaiyo nonani monoi aino imo lukasiko si manoki. Fu kolikali soli aino imo mani, lukasiko si manoki. ");
INSERT INTO amm_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","No monoi no Isisoso imalokino, “Koini asisai mo na putukaimoko, na pomoi.” ");
INSERT INTO amm_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","No monoi no mo, Isiso mo ayouso folamiyo konoki mo, popuwayo utukaimo nokotayo mo imaloki, “Yo mo taluwainoki.” ");
INSERT INTO amm_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ulai Isiso mo wiyou yomuki, na imoki, “Nuso na pomoi, fuwaluwouso na pikano, Noko Siyoliyo no itouniyaimokaini no, nonani aino imo na polukasikano. Mulu ununi, na fasini.” ");
INSERT INTO amm_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","No monoi no mo, nonani nokota mo na manoki, tota itouniyaimokai aino imo lukasikaloki, Tikapoli asiso. Wiyouwa wiyou, noko nokolaloyo mulumoloko manokino, “Moloi amiyaikiyokowai, woi?” ");
INSERT INTO amm_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Nosai no mo; ifou nuki, ayou molosai tokosiyaikaiyo tikino, iwo toku ilo siyaiso. Isiso mo fiyamosiya tiki mo, noko nokolalo molopoi molopoiyo Isisoso na ukouniyaikokuya tumokino, iwo toku iloso tolomai. ");
INSERT INTO amm_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nomai no lotu nufa samuku nokota siya mo tani auso na tumoki. Tani siyolo mo Yailo. Isisoso no kiki mo, tani fokutonomai na losiyaika tumoki, ");
INSERT INTO amm_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","na imaloki, “Yani alu, woi, aumoifaso na tokaloso. Ulai nainoyosu na pokomisa tumo, itouniyaisokai monoi, no monoi no waliyo na tolosoimo.” ");
INSERT INTO amm_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","No monoi no Isisoyo mo na aluwaiki. Noko nokolalo molopoi mani, tanokokino. Na ukouniyaikokaiki, fiyokaimokino. ");
INSERT INTO amm_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Nomai no noni mo na tolosoki, nufaisoyo uwokaisokai nukonu mo. Aisamu mo molo tiwoi mo nonani aiyo puwosokai manoki. ");
INSERT INTO amm_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Tokota iyali molopoi mo louwa pofasiso mosikino. Ulai itouniyaisowoi muwoi, iyanoko saso puwosomosikino. Muwoniwoi na uwaimokaiki, fasiso foli monoi mo. Ulai siyoliso na uwokaisokaiki. ");
INSERT INTO amm_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Isisoyo fasiko mi imo mo toku yasoi kwaiki, no monoi no noko molopoi nokoni aumai lotisoki, Isisoni namolisai wosu woso na tolosa tumoki, tani tuno soposai na komiki. ");
INSERT INTO amm_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Mulumolokoki, to mo, “Yo mo tani tunosai komiyakimo, waliyo na toloimo.” ");
INSERT INTO amm_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","No monoi no mo lolai siyaso nako mo na tolosuwasoki, na mulumolokoki, “Yo mo waliyo. Nako mo futo.” ");
INSERT INTO amm_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Isiso mani, lolai siyaso to mo sai na, ami mo noniso na amisoki. Namoli molo foinalikoki mo, yomuki, “Yani tunosai no noiyo tokomimono?” ");
INSERT INTO amm_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nosai no mo; siyokutono iyaliyo imokino, “Nono no noko nokolaloso pa kokoniso? Hani monoi tiyomuni, “Noiyo tokomimono?” ");
INSERT INTO amm_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Isisosu mo amai kwailuwaikaloki, na mulumolokoki, “Noiyo komimono, woi?” ");
INSERT INTO amm_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Nosai no mo; noni mo Isisoni fokutonomai alokomu na losiyaika tumoki. To mo sai na, “Yo mo waliyo na totolo.” Kokolosoki, na kumolokosoki. Nufaiso uwoso monoi aino imo komaso mo na posasoko wiyononiki. ");
INSERT INTO amm_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Na isoki, Isiso mo, “Woli, waliyo tomulumolo luwaimononi, no monoi no mo waliyo na totoloni. Atiyaiso potolano, mulu tomokiso. Nani ai mo futo.” Aino na isoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Isisoyo amai lukaso niso manoki mo, nomai no mo lotu nufa samuku nokota Yailoni nusai na tiki, nokoyo, toso na ima tumokino, “Nani alu mo yau, yasoi na kaloso. Aiyoloko nokotaso afonimaiso noiyo fololuwaiyoi. Konoi no moloi fasiso monoi?” ");
INSERT INTO amm_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ulai Isiso mo toini imo kulalikoki, lotu nufa samuku nokotaso na imoki, “Noiyo kokolomoi. Na pomulumolo luwaimonosu.” ");
INSERT INTO amm_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Imoki mo; noko nokolaloso alukikoki. Pita iyalisu na koliyonoki, Pitawoi Yamiso noko ti, auwatono Iyonowoi. ");
INSERT INTO amm_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Nosai no mo; lotu nufa samuku nokotani nu mo fiyamosiya tumokino. Noko nokolaloyo sosonuno umano siso na kwaika tumokino. Wiyouwa wiyou, siyoliso na sonukuso si manoki. ");
INSERT INTO amm_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nu poiso tiki, na ikoki, “Oi, hani monoi tosonukusonuwo? Hani monoi tiyonuwo, siyoliso no? Alu mo yau muwoi, ulololi totaso.” ");
INSERT INTO amm_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ulai na soluwaikino. Nosai no mo; Isiso mo na amiyaikiyoka tiki, na ikoki, “Fuwoi, na pokiyomonowo.” Atino apitonowoi siyokutono iyali noko tauwoisoso na koliyo tiki, nu poiso monoi, alu yau tasoso. ");
INSERT INTO amm_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Alu yauni nainosai na komisoki, na isoki, “Talita kumi.” Nonani imo folosai mo noino, “Alu noniyanikofa, ya timonoki, na pauwoniyou.” ");
INSERT INTO amm_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ulai lolai siyaso alu mo na auwonisiyouki, na liyaisoki. Alufa muwoi, alu noniyaniko siyoli sowiyafa na, aisamu 12. Wiyouwa wiyou, kufaukoki, naino foli iyo nokokino, iyamoki, “Ulai moloi monoi woi?” ");
INSERT INTO amm_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Imo amiso na ikoki, Isiso mo, “Ainonani monoi imo noiyo ikaloiwo.” Nosai no atino noko tiso ikoki, “Koloni na ponisowo.” ");
INSERT INTO amm_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Nosai no mo; Isiso iyali mo Kopanaumoso utukaimokino, totani asiso na nuki. ");
INSERT INTO amm_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nosai no mo; mi fou fouko ulomai lotu nufa poiso aiyoloka tiki, Kotoni imo mo. Noko nokolalo molopoi, no kwaimokino no, kufaukokino, na iyamaloki, “Noko to no ninani imo no moloi ano, woi? Wiyouwa wiyou, mulu ifolaluwawoi mi na tanalomoi. Nonani mulu iwoi no moloi ano, woi? Noiyo anoniki, woi? ");
INSERT INTO amm_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","To mo nu kololi nokota na. Nasu, Moilini awitono, to mo. Yamiso Yusiso Yutaso Saimo, toini auwatono na, to mo. Inaitono iyali mo moini aumai niya si.” Aino no iyamoki mo, uo mulu na atolokomo unukino. ");
INSERT INTO amm_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Nosai no mo; Isiso mo na ikoki, tota amu monoi, “Noko nokonu nokoyo Kotoni mulu lukasiko nokotaso tokisosomi manono. Nokonu tomoso nokoyosu pa tokisosominoso. Nako tomoso noko mani, tauwosisimono. Nuwa noko iyali mani, pa tokisosominoso.” Aino ikoki. ");
INSERT INTO amm_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Mulu ifolaluwawoi mi no moloi ano monoi, nonani asimai no? Ai ai noko tiwoi tauwoiso kuloliki, nainoyo, waliyo siki. ");
INSERT INTO amm_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Tolomu noko iyali, toi mo pa mulumolo luwaikinoso. No monoi no Isiso mo mulumoloko manoki, “Moloi woi? Hani monoi pa tomulumolo luwaimononoso?” Nosai no mo; Nasolito nokonuso utukaimoki, aumoifa aumoifaso nokonuso liyaiyaloki, Kotoni imo aiyolokaloki, noko nokolaloso. ");
INSERT INTO amm_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nosai no mo; Isiso mo noko molo tiwoi nokoso na aliyonikoki. Tiki mo; ami sisiyoli na nikoki, popuwa kopokoiyau saloso uwokalo monoi. Na iko taikiyaloki, ti tiso. ");
INSERT INTO amm_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Toku mo na ikoki, “Nuwakinuwomo, hani haniwoi noiyo ilomanoiwo, atousu mo waliyo pa losi ilomanowo. Tuowoi iwoi muwoniwoi noiyo ilomanoiwo. ");
INSERT INTO amm_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Fona su siyasonuso pa asisikiyouwo. Kwalomai monoi tuno noiyo ilomanoiwo, siyasonuso pa asisikiyouwo. ");
INSERT INTO amm_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nokonuso fiyamosiyakinuwomo, tolomu nokotani nuso na pa tiwo. Nonani nokotani nusoso na pa simosiwo, ulololi mo, ainoso hani utukaimoinuwo, nonani nokonuso. ");
INSERT INTO amm_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nokonu siya nokoyo imakinuwomo, “Noiyo toiwo,” nonani nokonu na pa utukaimowo, moini imo kwai somiso mo. Fona asi kukumo pa kitotasokokaiyouwo, toini molo timai. Ulai afonimaiso? Toiyo imo kulali monoi nali no, imonuwo, “Koini nokonuso noiyo toiwo.” Aino na iko taikiyoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nosai no mo; yasoi; siyokutono iyali mo na nu liyaiki, imo mo noino na posasoko wiyotiyalokino, “Mulu na palosokomowo.” ");
INSERT INTO amm_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Popuwa na amiyaikiyoko uwokalo manokino. Woilo iwoyo louwokalo manokino, ai ai noko nokolaloso. Waliyo na siki, ai ai mo uwai. ");
INSERT INTO amm_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Nosai no mo; komano nokota siyoli Hilo mo, to mo Isiso aino imo koloma tumoso kwaiki. Noko molopoi noko mani, Isiso aino imo yasoi kwaiyalokino. Siyai mo piyamaloki, Iyono, iwoso uluwako nokotawo. Na iyamoki, “Nakomo yausai lusiyaikiyoki. No monoi no mulu ifolaluwawoi na totolokaino.” ");
INSERT INTO amm_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Siyaiyo piyamaloki, Ilaiya, aniyopatonowo. Siyaiyo piyamaloki, Kotoni mulu lukasiko nokotawo, aniyopatono iyaliso posasoko wiyoti nokota komiyai. ");
INSERT INTO amm_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Hilosu mo nonani imoso kwaiki mo, na yomuki, “Asayo noinomo, woi, Iyono mo imo molomai tokosonowaikino. Ulai yausai ifou na auwoniyouki.” Hilo mo ainoso piyomuki, Iyonowo Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ulai afonimaiso yomuki? Afonimaiso muwoi. Toku mo Iyono mo tukolo somisomai Hilo, totayosu noinomo nokoyo komi kausikino, kalopulo nuso na kominalomanokino, moloyo konosuwakomokaikino. Hilotiya, Hiloni auwatono Filiponi noni, to foli monoi na yoki. Hilo mo auwatononi noni yasoi polamoso wanoniki, na kausoki. ");
INSERT INTO amm_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Toku mo kalopuloso kiyo somisomai Iyono mo Hiloso na imoki, “Auwanoni noni no hani monoi kauso wanonini? No mo kwaimo muwoi, au na.” ");
INSERT INTO amm_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","No monoi no mo, Hilotiya mo mulu atolokomo unuki, Iyono monoi. Tukolo monoi louwa fi. Ulai moloi tukolo monoi? ");
INSERT INTO amm_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Hiloyo atiyaiso na kwailuwai itouniyaimoki. Ulai afonimaiso? Kokolo mulu na, to mo sai, Kotoso aluwai nokota itouniyaimo na. Iyononi imoso no pukwaimomosiki mo, na mulumoloko manoki. Ulai tani imo kwai monoi mo waliyo na yoki. ");
INSERT INTO amm_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Nosai no mo; Hilotiyayo noinomo Iyono mo na tukolokino, yau. Nonani aino imo mo noino. Hilo mo atinoyo ki koloni wasi nikoki, komano mi ano noko sisiyoliwoi polimano samukuko noko sisiyoliwoi Kalili asi noko sisiyoliwoi. ");
INSERT INTO amm_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Nosai no mo; Hilotiyani atoki mo namoso tolosa tiki. Hilowoi koloni wasi niko nokowoi, toi mo tani namoso monoi mo mulu na usokino. Komano nokota siyoli Hiloyo na isoki, maputo nukonuso, “Nono no hani ano monoi tiyoni? Hani anoni monoi imonakinimo, na anoninoikimo.” ");
INSERT INTO amm_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ti monoi na isoki, “Molo lou, na pimonosu. Hani anoni monoi imonakinimo, na anoninoikimo. Yoso imonakinimo, samukuko fasimono monoi mo, moti waliyo na samukuko monoi.” Aino na isoki, Hilo mo. ");
INSERT INTO amm_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nosai no mo; atinoni auso ifou amusiyofuki, na isa fuki, “Anoi, yo no hani ano monoi timononi?” Nosai no mo, atinoyo na isoki, “Iyono iwoso uluwako nokota, tani komu ano monoi timonoki.” ");
INSERT INTO amm_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Isoki mo; somaiso ifou lotisoki, Hiloni auso, na ima tiki, “Iyono, iwoso uluwako nokotani komu mo naumai pako aniyo tumomono. Somaiso.” ");
INSERT INTO amm_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Wiyouwa wiyou, Hilo siyoli mo mulu kaloki, Iyono tukolo imo monoi mo. Ulai auwolo imo monoi mulumolokoki, koloni wasi no niko nokoni molo timai no auwoloki no. No monoi no nonini imoso pa kulalisokiso. ");
INSERT INTO amm_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","No monoi no somaiso imo taikiyoki, tani mi ano nokotaso, “Soi su, Iyononi komu na potokosonano, tonomai, komu mo na pa aniyo tumomono.” Imoki mo; kalopulo nuso manoki, mi ano nokotayo, Iyononi komu na tokosonowaiyanoki. ");
INSERT INTO amm_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Komu saso na atisa tumoki, naumai, maputo nokonuso na atisoki. Tasu mo atinoso na atisanoki. ");
INSERT INTO amm_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Iyononi siyokutono iyali mo ainonani monoi kwaikino mo, to yau ana tumokino, yu asi iso ai unanokino. ");
INSERT INTO amm_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Nosai no mo; Kotoni imo lukasikalomano noko mo ifou tiki, Isisoni auso. Totaini mi analo aino imo lukasiya tumokino, noko nokolaloso no aiyolokalokino no, nonani imo monoi lukaso wiyononikino. ");
INSERT INTO amm_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Lukasiyoluwai manokino mo; noko nokolaloyo ifou ifou liyaiyalomano si manoki. Isiso iyali no koloni no moloi no monoi, nowoi muwoi. No monoi no na ikoki, Isiso mo, “Moi soiwo, moisu mo. Nu somiso asiso tofou fouko sanokoni.” ");
INSERT INTO amm_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ikoki mo; totaiso mo ayou molosai na nuki, nu somiso asiso monoi nuki. ");
INSERT INTO amm_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ulai noko nokolalo molopoi nokoyo kwaiya kiyokokino, iyamoki, “Ni mo Isiso iyali na.” No monoi no tolomu asi noko nokolalo mo upoi molosai fufumuwano liyaiki, nokonu nokonusai, ayou molosai ti nokoso souwaikokino. ");
INSERT INTO amm_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Nosai no mo; Isiso mo ayou akaiya tumoki mo, noko nokolalo molopoiso ukouniyaikokaiso koka tumoki. Mulu na kalo ukuki. Ulai afonimaiso? Toi mo sipo koloni komiyai, samukuko nokota mo uwofa. No monoi no aiyolokauki, hani hani imo mo. ");
INSERT INTO amm_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Nosai no mo; upimoso siyokutono iyali mo ima tumokino, “Ninani asi mo nokowoi asi muwoi. Ulo mo yasoi aumoifaso na tomoi. ");
INSERT INTO amm_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Noko nokolaloso na piko taikiyo, aumoifa nokonu nokonuso, totaini koloni na suo suomokano liyaiwumo.” ");
INSERT INTO amm_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Nosai no mo; Isiso mo na ikoki, “Ulai hani monoi? Koloni mo momaiyo na ponikowo.” Na imokino, “Moloi monoi woi? Koloni no moloi iyano monoi, koi no? Noko molopoi molopoi, muwoni mo wiyou, 200 kina na. Moloi no niko monoi?” ");
INSERT INTO amm_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nosai no mo; Isiso mo na ikoki, “Paluwa tuo komu no moloi moloi si? Na pokokalowo.” Koko uwai; na ima tumokino, “Koi mo paluwa tuo komu mo naino siyai. La mo tiwoi.” ");
INSERT INTO amm_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nosai no mo na ikoki, “Na pikalowo, pama sosono itouniyaimomai fofamoso na sinonalumo, koli koliso.” ");
INSERT INTO amm_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","No monoi no sinonaloki. Si tomasikuwano noko siyai mo pounu, 50. Si tomasikuwano noko siyai mo molopoi molopoi, 100. ");
INSERT INTO amm_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Nosai no mo; Isiso mo paluwa tuo komu naino siyaiwoi la tiwoi akowaikoki, kumokiso you foinalikoki, wafisu imo na imoki, Apitonoso. Paluwa tuo na folouluki, siyokutono iyaliso na nikoki, noko nokolaloso wauti monoi. La mo lolofa ti mani, Isisoyo noinomo na wautikino. ");
INSERT INTO amm_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nosai no mo na no si liyaiki, noko nokolalo komaso noko mo. Touwai sisiyoli na toloko liyaiki. ");
INSERT INTO amm_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","No waloto, paluwa tuowoi lawoi mo amai na siki, i molo tiwoiso na alokino. ");
INSERT INTO amm_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Noko molopoi molopoi mo, 5000 na no siki. No mo noko iyalisoso kolalikino. ");
INSERT INTO amm_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nosai no mo; lolai siyaso Isiso mo siyokutono iyaliso ikoki, “Ayou molosai toku na ponuwo, iwo toku ilo ausaimiso, Pisaito nokonuso. Yo mo namolisai. Toku mo noko nokolaloso tokiyoko taikiyo.” ");
INSERT INTO amm_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kiyoko taikiyoki mo; nosai no mo; yuso amiyoki, Kotowoi imo lukasa yoki. ");
INSERT INTO amm_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Nosai no mo; folosumono mo aumoifaso tumoki mo, tota siyofoloso amai na tolokainoki, iloso. Ayou mo iwo toku mulumai manokoki. ");
INSERT INTO amm_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Siyokutono iyaliso kwaikoki, imonuyo amulusai usainiyaikaloso. Mulu na folokoki, ayou alomako monoi. Nosai no mo; posasi aumoifaso tanomai mo; Isiso mo siyokutono iyaliso na koka tumoki. Iwo toku iwo tonimai na liyaiyalo tumoki, fona molosai. Ayou aumoifaso na tumoki, louwa souwaikoki. ");
INSERT INTO amm_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Wiyou, iwo tonimai tumoso kwaikino mo, piyamoki, popuwawo. Na omuwano manoki. ");
INSERT INTO amm_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ulai afonimaiso? Na umanokoki, Isiso tumoso kwaikino, no monoi no. Ulai lolai siyaso na ikoki, “Mulu noiyo kolikaliyoiwo. Nisu mo asasu. Noiyo kokolokomoiwo.” ");
INSERT INTO amm_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nosai no mo; ayouso koumiyo yoki, yousi tomasika konoki. Yousi tomasika tumoki mo, imonu mo futo. Wiyou, na kufaukoki. ");
INSERT INTO amm_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ulai afonimaiso? Toi mo mulu mo wapu wapu saso. Paluwa tuo komu lolofa wauti ami monoi toi mo pa sainokinoso, toku Isisoyo no wautiki no, noko nokolalo molopoi molopoiso. Nonani ami monoi mo toi mo sai muwoi, sosoli na. ");
INSERT INTO amm_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Nosai no mo; iwo toku iwo mo tokosiyaiyo tikino, Kinisali nokonuso komama tumokino. Ayou akaikino. ");
INSERT INTO amm_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ayou akai uwai; lolaloso tiki mo, noko nokolalo mo sai, na iyamoki, “Ni mo Isiso niya.” ");
INSERT INTO amm_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Nosai no mo; fufumuwana liyaiki, nokonu nokonuso. Ai ai noko nokolalo koliyo tumo liyaikino. Noko nokolaloyo ninani imoso no kwaikino mo, “Isiso mo niya tolo,” o, “Isiso mo ausoni tolo,” no monoi no ai ai noko mo molo tokosimaiso sokukoiyo tumo liyai manokino, Isisoni auso, ititounikai monoi. ");
INSERT INTO amm_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Asi asi liyaiyalo manoki mo, noinoso na yalo manokino, nokonu nokonuso, nokonu mulumai na pokiyokoma tumo manokino. Kiyokoma tumokino mo; utolumalokino, “A, nani tuno unusai no waliyo komiyaloinimo?” Ikoki, “Waliyo.” No monoi no komiyalokino mo, waliyo na siki. ");
INSERT INTO amm_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Nosai no mo; Falisi moloso aluwai nokowoi Musini imo sai sisiyoli nokowoi, Yolusolimo nokonu siyolisai no tiki no, toi mo Isisoni auso na ukouniyaika tumoki. ");
INSERT INTO amm_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Isisoni siyokutono iyali no siso kwaikokino, na iyamoki, “Toi mo naino mo iwoso mo uluwakowoi muwoi, tokumo foiya na tonono.” ");
INSERT INTO amm_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Falisi moloso aluwai nokowoi Yuto noko komasowoi, toi mo tokumi molososo aluwaikino. Toku naino uluwako somiso mo, somaiso pa tono manonoso. ");
INSERT INTO amm_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Makitosai koloni tiyo tumo manono mo, toku naino uluwako somiso mo, somaiso pa tono manonoso. Aniyopa molo siyai mani, taluwaikalo manono. No monoi no hani hani nausoso tuluwakalo manono. ");
INSERT INTO amm_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","No monoi no mo, Falisi moloso aluwai nokowoi Musini imo sai sisiyoli nokowoi, toi mo Isisoso imokino, “Moloi monoi woi? Nani siyokuno iyali mo tokumi moloso pa taluwai manonoso. Naino tokumo foiya na tonono.” ");
INSERT INTO amm_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Nosai no mo; Isiso mo na fowakoki, “Kotoni mulu lukasiko nokota Aisaiya, to mo topoko noko moi monoi motu na kumo unukaikinuwo, noino, “Ninani noko nokolalo iyali mo asuwo asuwo tokisosomimono ifoluwaimonalo manono, totaini koyoso. Ulai yowoi mulu tomoso pa tosiso, aluwamai amai tosi. ");
INSERT INTO amm_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nokoni imo monoiso taiyolokalo manono, tifoluwaikalo manono, Kotoni imowo. No monoi no yani siyolo na tomoloki ifoluwaimonalo manono.” Motu imo mo Aisaiyayo aino na kumo unukaikinuwo. ");
INSERT INTO amm_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Kotoni imo ami imoso utukaimokinuwo. Nokoni imososo taluwaiko manonuwo.” ");
INSERT INTO amm_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Nosai no mo; ti monoi na ikoki, “Moloi monoi woi? Momaini tokumi moloso no hani monoi taluwai manonuwo? Wiyouwa wiyou, na taluwai manonuwo, no monoi no Kotoni ami imoso na tokulali manonuwo. ");
INSERT INTO amm_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Musiyo na yomukaiki, “Anoni apono noko tiso na pa kisosomikomoi.” Ninoino mani, yomukaiki, “Noko mo atino apitono noko tiso imo koiyau imo ikakimo, to mo na kalumo.” ");
INSERT INTO amm_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Moisu mo nonani imo mo kwaiwoi muwoi. Imo folo taiyoloko manonuwo, noko nokolaloso, noino. Noko mo muwoni mo yapoli mo, atino apitono noko ti fasiko muwoni mo, nonani muwoni mo waliyo Kotoso muwokononi monoi. Nonani nokotayo totiso ikakimo, “Moti fasikomo muwoni mo Kotoso muwokononikai,” momaiyo imoinuwomo, ");
INSERT INTO amm_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","“No mo waliyo na, tofolo anoni apono noko tiso noiyo fasikoi”. ");
INSERT INTO amm_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Nonani mulu koiyau mulu no taluwai manonuwo mo, no mo Kotoni imoso tokulali manonuwo. Momaini aniyopano iyalini tokumi molososo taluwaiyalo manonuwo. Alaloso mani, tomoso na taiyoloko manonuwo.” Isisoyo mo aino na ikoki, nokotalo iyaliso. ");
INSERT INTO amm_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Nosai no mo; nokotalo iyaliso iko uwai; Isiso mo noko nokolaloso ti monoi aliyonikoki, totani auso ti monoi. Na ikoki, “Moi komaso mo yani imo na pukwaimonowo, na posainowo. Noino. ");
INSERT INTO amm_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Noko mo hani haniso nokakimo, no mo tani mulu mo pa uwokaiyoiso. Ulai totani mulu koiyausoso aluwaiyakimo, no mo tani mulu mo na uwokaiyoimo. ");
INSERT INTO amm_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Noko mo iyo uku somiso mo, imo mo na pa kwaimono itouniyaimowo.” ");
INSERT INTO amm_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nosai no mo; Isiso mo noko nokolaloso utukaikoki, nuso manoki. Lotikimo; siyokutono iyali mo nonani siyokawi imo folosai monoi na utolumokino, “Na poposaso wiyomoko.” ");
INSERT INTO amm_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Isiso mo na ikoki, “Ya piyomu, moi mo saiwo. A, sosoli na tosinuwo? Nakomo moi mo sai muwoi, komaso koloni mo koso noko manakinuwomo, no mo momaini mulu no moloi uwokaikomo monoi? Pa uwokaikomoinuwoso. ");
INSERT INTO amm_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Hani hani koloni koso tonoko manonuwo mo, nomoliso na tosa konomoi. Tosa konomoi mo; tousai tomanokano manonuwo. No monoi no hani hani koloniyo no mulu no moloi uwokaikomo monoi?” No monoi no Isiso mo na yomuki, komaso koloni mo waliyo noko na. Au auwoi muwoi, waliyo. ");
INSERT INTO amm_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Nosai no mo; ti monoi na ikoki, “Noko mo totani mulu koiyausoso aluwaiyakimo, no mo totani mulu uwokaiyoimo, na tolikimokaiyoimo. ");
INSERT INTO amm_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Kopokoiyau hani mo mulusaisu na toti liyaimoi, noinoso nali no. Kopokoiyauso mulumolokalo mulu, uloliyo mulu, polamoko mulu, noko tukuwoli mulu, noko kwami nukonu uwokaiso mulu, ");
INSERT INTO amm_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ilolu molopoi i mulu, mulu koiyau mulu, nokoso ifoluwaiko mulu, mulu uku mulu koiyau, foluwaliko mulu, kali kalimikuwano mulu, noko sisiyoli si mulu, mulu wapu mulu. ");
INSERT INTO amm_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nonani kopokoiyau hani haniyo mo nokoni mulusaisu toti liyaimoi, na tuwokaiko manono, nokoni mulu mo. Toliki tolikikokai na tosi.” Isiso mo aino na ikoki, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Nosai no mo; Isiso mo nonani nokonusai na utukaimoki, Taiya asiso monoi na manoki. Tolomu nokoni nuso na lotiki. To mo nokoyo ki mo wiyou. Ulai moloi kukaloko monoi? ");
INSERT INTO amm_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","No monoi no noni mo tumosoki. To tumo imoso no kwaiki mo, somaiso na tumosoki. Nonani nukonu mo alu mo popuwa koiyauyo uwosokaiki. Tumosoki mo; Isisoni fokutonomai alokomu na losiyaika tumoki. ");
INSERT INTO amm_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nonani nukonu mo asi siya nukonu na, Fonisiya nukonu. Fonisiya mo Siliya nokoni asifa na. Isisoso na imalo tumoki, “Yani alu woi, na pofasisomono. Popuwa na pamiyaikiyowaiso.” ");
INSERT INTO amm_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Na isoki, Isiso mo, “Koloni mo alalososo na tonikomoi, nokoyo. Alaloni koloni no moloi niko monoi, aluwouso no?” Siyokawi imo mo ainoso na isoki. Ulai afonimaiso? Afonimaiso muwoi. Yuto noko, toi mo tiyamo, “Noko nokonu noko mo aluwou komiyai. Isolilo noko koi saso mo Kotoni alalo.” No monoi no nonani imo na isoki. ");
INSERT INTO amm_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ulai nonani nukonu mo na imoki, “Noko Siyoli, nani imo mo motu nali no. Ulai alalo iyaliyo koloni potikimonasi mo nusiso tusukunalo kono liyai mo, kotisoko wosuwoi si aluwouyo waliyo na tonoko manono.” ");
INSERT INTO amm_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nosai no mo; Isiso mo na isoki, “Motu na tiyomuni, no monoi no nuso na pomoi. Nani alu mo popuwa mo yasoi na utukaiso.” ");
INSERT INTO amm_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Nosai no ifou no manosoki mo, alu mo waliyo na kosa tumoki, ulololi tasoso. Popuwa mo na utukaisokaiki. ");
INSERT INTO amm_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Nosai no mo; Isiso mo Taiya asiso utukaimoki, Saito asi mulumai tokosiyaikaiyouki. Ulai nosai no mo Tikapoli asi mulumai tokosiyaikaiyouki. Ulai nosai no mo Kalili iwo tokuso na komama tumoki. ");
INSERT INTO amm_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nosai no mo; iyo uku nokota mo nokoyo na kiya tumokino, Isisoyo itouniyaimokai monoi. Ko mani, muwoli siyoli. Na imalokino, “Nainoyo na pokomi.” ");
INSERT INTO amm_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nosai no mo; Isiso mo kawiyonofamoki, noko nokolalo utukaikokino. Totatiso tolokino mo, Isisoyo mo naino muwoyo na noikomoki, nokoni iyo poiso. Noikomoki mo; totani naino muwoso aso koloki, tani koso na akaimoki. ");
INSERT INTO amm_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Kumokiso kwailuwaiki, mulu siyoliso asofoliki, iyo uku nokotaso na imoki, “Ifata.” Nonani imo folosai mo noino, “Fupi.” ");
INSERT INTO amm_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Imoki mo; lolai siyaso nonani nokotani iyo mo fupi. Ko mani, muwoliwoi muwoi, waliyo na lukasauki. ");
INSERT INTO amm_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Nosai no mo; ikikoki, ikoki, “Noiyo lukasoiwo, ko lopumo nokota itouniyaimokai aino imo mo.” Amiso na louwa ikaloki. Ulai, wiyou, na posasokalokino. ");
INSERT INTO amm_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Wiyouwa wiyou, noko nokolaloyo kufaukoki, na iyamoki, “Ulai moloi monoi woi? Hani hani komaso no yomoi mo, itouniyaimoso na. Iyo uku uku noko ititounikaimoi, imo na kwai liyaino. Ko lopu lopu noko mani, imo na lukaso liyaino.” ");
INSERT INTO amm_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Nomai no mo, noko nokolalo molopoi ulai ti monoi ukouniyaika tumoki. Ulai koloni mo uwofa na. No monoi no Isiso mo siyokutono iyaliso aliyonikoki, na ikoki, ");
INSERT INTO amm_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Yo mo ninani noko nokolalo monoi mulu tokalo uku. Tauno na sa tumoki. Koloni mo uwofa, toi mo. ");
INSERT INTO amm_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Yo mo koloni no somiso iko taikiyakimo, totaini nu nuso, molomai molo folulumokoimo, tiyayo mo. Siyai mo aluwasai tiki, no monoi no.” ");
INSERT INTO amm_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ulai imokino, “Ninani asi no ulai nokowoi? Ulai paluwa tuo no moiso i monoi, ninani noko nokolalo molopoiso niko monoi no?” ");
INSERT INTO amm_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Na ikoki, Isiso mo, “Moi no paluwa tuo komu no moloi moloi?” Fowakino, “Koi mo paluwa tuo komu mo nano siyawoi, 7.” ");
INSERT INTO amm_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ulai Isiso mo noko nokolaloso na ikoki, “Asimai na posinona konowo.” Nosai no paluwa tuo nano siyawoi mo ikoki kusomi, Kotoso imoki, “Wafisu.” Imoki mo, na folouluki, siyokutono iyaliso nikoki, nosai no toiyo na wautiyalokino, noko nokolaloso mo. ");
INSERT INTO amm_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","La siyasonuso lolofa mani, yapoli na. Kotoso imoki, “Wafisu.” Imoki mo, siyokutono iyaliso na ikoki, “La lolofa mani, na puwautiwo.” ");
INSERT INTO amm_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nosai no na nokokino, noko nokolalo mo, touwai na siki. Touwai siki mo; no waloto mo amai, na isikokaiyalokino, i nano siyawoiso, 7, na alokino. ");
INSERT INTO amm_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Noko mo molopoi molopoi, 4000 na no si liyaiki. Nosai no mo; Isiso mo noko nokolalo mo iko taikiyoki, totaini asiso ifou nu liyai monoi. ");
INSERT INTO amm_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Iko taikiyoki mo; somaiso ayouso folamuwaniyo konoki, Isiso iyali mo, Talomanuto asiso monoi nuki. ");
INSERT INTO amm_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Nosai no mo; Falisi moloso aluwai noko mo tiki, Isisoso utolumalo tumokino. Na louwa imo kikino, asuwo totaini molo timai kumokini mi ifolaluwawoi mi ano wiyoti monoi. ");
INSERT INTO amm_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ulai mulu siyoliso asofoliki, na ikoki, Isiso mo, “Lolaimai si noko nokolalo moi no mulu ifolaluwawoi mi wiyononi monoi no hani monoi tiyo manonuwo? Motuwa na timonukuwo, pa wiyononinoikuwoso.” ");
INSERT INTO amm_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nosai no na utukaikoki. Yasoi; ayouso ti monoi folamuwaniyo konoki, Isiso iyaliyo, iwo toku ilo siyaiso monoi na nuki. ");
INSERT INTO amm_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Nosai no mo; Isiso iyali mo iwo toku iwo mulumai tokosiyaikaiyoukino mo, paluwa tuo mo uwofa. Siyokutono iyali mo iyo tumowoi muwoi, na fufolikokino. Komu siyasu aniyo tumokino, ayou poiso. ");
INSERT INTO amm_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Nosai no mo; Isiso mo siyokawi imo ikoki, noko sisiyolini molo koiyau monoi. Noino na ikoki, “Atiyaiso, Falisi moloso aluwai nokowoi Hilo siyoliwoi, toini paluwa tuo sisiyoliko asu monoi mo atiyaiso.” ");
INSERT INTO amm_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ulai toi mo imo folosai imo mo sai muwoi, no monoi no totai amu lukasikuwanokino, “Paluwa tuo mo uwofa, no monoi no timoko.” ");
INSERT INTO amm_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ulai to mo sai, toini imo monoi mo, na ikoki, “Hani monoi tiyamonuwo, “Paluwa tuo mo uwofa.” Nakomo moi mo imo folosai mo sai muwoi. Ulai moi no muluwoi? A, mulu no wapukomokai? ");
INSERT INTO amm_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Moi mo molo tiyo tofoinaliko manonuwo, ulai hani hani mo pa tokoko manonuwoso. Moi mo iyowoi na, ulai imo mo pa tukwai manonuwoso. A, na tofufolikomonuwo? ");
INSERT INTO amm_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Paluwa tuo komu naino siyai foloulu monoi pa tomulumolokonuwoso, noko molopoi molopoi nokoyo, 5000, no nokokino no. I no moloi moloi alokinuwo, no waloto no?” Fowakino, “I molo tiwoi alokinoki.” ");
INSERT INTO amm_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ti monoi ikoki, “Paluwa tuo komu nano siyawoi foloulu monoi mani, pa tomulumolokonuwoso, noko molopoi molopoi nokoyo, 4000, no nokono no. I no moloi moloi alokainuwo, no waloto no?” Fowakino, “I nano siyawoi alokainoki.” ");
INSERT INTO amm_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Na ikoki, Isiso mo, “Nakomo moi mo sai muwoi.” Aino ikoki. Paluwa tuo sisiyoliko asu monoi pa ikokiso, noko sisiyolini imo monoi atiyaiso si monoisu na ikoki. ");
INSERT INTO amm_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Nosai no mo; Pisaito nokonuso fiyamosiya tumokino. Nomai no molo kau kau nokota na kawiyo tumokino, nokoyo, Isisoni auso. Na imalokino, “Naino na pakaikomo.” ");
INSERT INTO amm_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Nosai no mo; molo kau kau nokotani nainosai na kominalomanoki, nokonuso kawiyo fuki. Usuwoyo moloso na aso kolokomoki, naino tiyo na akaikomoki, na utolumoki, “Hani hani no yapoli kokoni.” ");
INSERT INTO amm_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nosai no foinalikoki, na yomuki, “Yo mo noko tokoko, a komiyai liyai siso.” ");
INSERT INTO amm_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ulai ti monoi nainoyo akaikomoki, molo tiso. Akaikomoki mo; na foinaliko itouniyaimoki. Hani hani komaso mo fiyamoso na koko taikiyoki. ");
INSERT INTO amm_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Nosai no mo; Isisoyo imo taikiyoki, imoki, “Nokonuso noiyo lotoi, nuso na pomoi.” ");
INSERT INTO amm_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Nosai no mo; Isiso iyali mo Sisaliya Filipai aumoifaso nokonu nokonuso monoi nuki. Molomai nu manoki mo, siyokutono iyaliso na utolukoki, “Noko nokolalo no moloi tokaluwaimono manono? Yo no noi, woi?” ");
INSERT INTO amm_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Na fowakino, “Siyaiyo tokaluwai manoni, “Iyono iwoso uluwako nokota.” Siyaiyo tokaluwai manoni, “To mo Ilaiya.” Siyaiyo tiyamo, “Nakomo Kotoni mulu lukasiko nokota poimo, aniyopa nokota na.” ");
INSERT INTO amm_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Nosai no mo na ikoki, “Momaiyo no moloi tokaluwaimononuwo? Yo no noi, woi?” Nosai no mo; Pitayo na fowaki, “Nono mo Kolaiso. Koto mo Isolilo noko koi fasimoka tumo monoi na muwokaikini.” ");
INSERT INTO amm_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Nosai no mo na ikikoki, “Woli iyali, nokoso noiyo kaluwai wiyotiyoiwo, asa monoi mo.” ");
INSERT INTO amm_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nosai no mo; Isiso mo totawoi imo aiyolokoki, siyokutono iyaliso, tota uwo monoi aino imo. Na yomuki, “Asa, asi asi noko nokolaloni noko siyoli nokota yo mo iyanoko siyoli na uwomonoinomo. No mo afonimaiso muwoi. Kotoyo ainonani monoi na imono taikiyoki. Nokoyo iyanoko siyoli uwomonoinomo, nokotalo iyaliwoi lotu samukuko noko sisiyoliwoi Musini imo sai sisiyoli nokowoiyo. Namoliyo na alosimomonoinomo, na tukolomonoinomo, yau. Ulai amoloki tiwoi mo uwai; ulo siya mo ifou na auwoniyouwoimo, yausai.” ");
INSERT INTO amm_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Aino na ikoki, siyokutono iyaliso, ima imo mo. Ulai Pitayo mo Isiso kominiyonoki, kwaso monoi. Imo amiso na imoki, “Aino noiyo yomoi.” ");
INSERT INTO amm_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ulai Isiso mo namoliyo alosimoki, Pitaso, siyokutono iyaliso kwailuwaikoki, imo amiso na imoki, Pitaso, “Fuwoi, no mo Sokolo Nokota Waini imoso timononi. Kotoni muluso pa taluwainiso. Nokoni mulusoso taluwaini.” Aino na imoki, Pitaso. ");
INSERT INTO amm_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nosai no mo; Isiso mo ukouniyaiko noko nokolalowoi siyokutono iyaliwoi, toiso na aliyonikoki, totani auso ti monoi. Tiki mo, na ikoki, “Nokoyo yoso aluwaimono monoi yakimo, totani muluso no moloi aluwai monoi? Yo mo a moki sokunalomakoimo. Noinoso aluwaimono nokota mani, uo nokoyo uwoyakinomo, moloi ulosukomo monoi? Ulo ulo amoloki amoloki aluwaimonumo. ");
INSERT INTO amm_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Nokoyo totani au monoisu mulu unakimo, aniyopa poi poi moloi yousi itouniyaimo monoi? Na kaloimo. Nokosu mo yoso aluwaimono monoi kalakimo, pa kalokaiyoiso, aniyopa poi poi yousikaino itouniyaimo manoimo. Kotoni imo itouniyaimo lukasikalomai kalakimo, pa kalokaiyoiso, aniyopa poi poi yousikaino itouniyaimo manoimo. ");
INSERT INTO amm_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Noko mo muwoni mi anakimo, asini sonosoni komasoso iyakimo, nonani haniyo no moloi fasi monoi? Kotoso mulumolo luwai somiso mo, na uwokaiyoimo. ");
INSERT INTO amm_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nokoyo totani mulu ifou ano monoi no haniyo moloi suo suomoko unoimo? ");
INSERT INTO amm_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Lolaimai si noko nokolalo, moi mo molo koiyausoso taluwai manonuwo, Kotoso namoliyo talosimo manonuwo. Moini mulumai tolo nokota mo nokoni molo timai aluwaimono monoi kokolomakimo, yo mani, namoliyo na alosimoimo, yo ifou amukonomaiso, Apouni ami siyoliwoi totani kumoki noko ititouniwoi. Ulai afonimaiso? Yani imo aluwaimono monoi louwa, ulai nokoyo uo imo monoi kokolomo, namoliyo na alosimomono. Asa, asi asi noko nokolaloni noko siyoli nokota ya ifou amukonakimo, yo mani, namoliyo na alosimoimo, nonani nokotaso mo.” Aino na ikoki, noko nokolalowoi siyokutono iyaliwoiso. ");
INSERT INTO amm_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Nosai no mo; ti monoi na ikoki, Isiso mo, “Yo mo motuwa na timonukuwo. Noko siyai ni si mo, toi kolikali somisomai Kotoyo mo na samukuya tumoinuwomo. Motu na, ami siyoliwoi samukuya tumoinuwomo, toi kolikali somisomai.” Isiso mo aino na ikoki, noko nokolalowoi siyokutono iyaliwoiso. ");
INSERT INTO amm_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Nosai no mo; amoloki toufo mo uwai; nosai no mo; Isiso mo noko tauwoi mo yu siyoli soposo koliyo yoki. Pitawoi Yamisowoi Iyonowoi, toiso koliyo yoki. Totaiso na sa yoki. Sa yoki mo, au mo folo na alosimo taikiyoki, toini molo tiyo kikino mo. ");
INSERT INTO amm_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Tani tuno mo na kamoko taikiyoki. Wiyouwa wiyou, unakiyoini topi. Asi noko, moi no moloi ano monoi? Nonani kamo pa tanokoniso. ");
INSERT INTO amm_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Nosai no toku nokota ti, Ilaiyawoi Musiwoi tokuwa toku no kolikaliki no, toti mo Isisoni auso na tola tumokino. Imo lukaso ni toloso kokokino. ");
INSERT INTO amm_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita mo nosoni kokoki mo, Isisoso na imoki, “Aiyolokomomoko nokota, nimai no mo waliyo tosikoni. Fulomu nu tauwoi kololoikimo, siya mo nani, siya mo Musini, siya mo Ilaiyani.” ");
INSERT INTO amm_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Pita mo imo monoiso yomuki. Na kokolokoki, no monoi no. ");
INSERT INTO amm_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Nosai no mo; kumoki kopuyo na fiyokaika konoki. Ulai ko na mo kumoki kopu mulusai na tu kwaimokino, noino na yomuki, “Ni mo yani alu na. Yo mo na tomulu unumoi. Tani imo na pa kwaimo itouniyaimo manowo.” ");
INSERT INTO amm_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nosai no lolai siyaso kwaiyalokino mo, noko ti mo uwofa kokokino. Isiso totaso toloso na kikino. ");
INSERT INTO amm_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nosai no mo; yusai you kunoki, molomai imo amiso ikoki, “Yumai no kokonuwo no, noko nokolaloso noiyo ikaloiwo, ainoso asi asi noko nokolaloni noko siyoli nokota asa yausai ifou no auwoniyouwaki no, nomai no na pa posasokowo.” ");
INSERT INTO amm_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Nonani imo mo totaini mulumaiso wosu woso na kukalokokaikino, totai amuso ikuwanokaikino, “Yausai ifou auwoniyou imo folosai no moloi woi?” ");
INSERT INTO amm_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nosai no mo; siyokutono noko tauwoi mo na imokino, “Musini imo sai sisiyoli nokoyo tiyamomoi, “Kotoyo muwokai nokota Kolaiso, to mo namolisai tumoimo. Kotoni mulu lukasiko nokota Ilaiya, to mo toku tumoimo, tota monoi.” Ulai moloi monoi tiyamomoi?” ");
INSERT INTO amm_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Nosai no mo na fowakoki, Isiso mo, “Motu nali no, Ilaiya mo ti monoi na tumumo, hani hani foukaiya tumo monoi. Asa, asi asi noko nokolaloni noko siyoli nokota yo monoisu mo Kotoni puko imoyo tiyomuko, noino, “Iyanoko siyoli uwoyoinomo, namoliyo alosimoinomo, nokoyo.” Hani imo poimo, na piyamowo. ");
INSERT INTO amm_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ulai ya timonukuwo. Ilaiya mo yasoi na tumo. Noko nokolalosu mo totaini mulusoso aluwaikokino, Ilaiya mo na uwokaikino. Ainonani monoi mani, Kotoni puko imoyo tiyomuko.” Siyokawi imo mo ainoso na ikoki, siyokutono noko tauwoiso. ");
INSERT INTO amm_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Nosai no mo; Isiso iyali mo siyokutono iyali siyaiso koka konokino, noko nokolaloyo ukouniyaiko kukoso na koka konokino. Musini imo sai sisiyoli nokoyo lukaso nikokino, koyoso imo mo. ");
INSERT INTO amm_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Noko nokolaloyo Isiso amukonoso kwaikino mo, na kufaukoki. Tani au mo fufumuwana tumoki, na imokino, “Woli, nona kuo.” ");
INSERT INTO amm_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Na utolukoki, Isiso mo, “Uo imo no moloi monoi?” ");
INSERT INTO amm_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nosai no mo; noko nokolalo mulumai nokota mo na tolauki, na fowaki, “Aiyolokomomoko nokota, yani alu mo popuwayo na uwokaikai, ko lopumokai. Noinoso louwa tokiyoma tumonoki. ");
INSERT INTO amm_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Saiso saiso nonani popuwayo mo tuwokaimosi. Asiso na tofakukiyo taikiyomoi. Somusouwoi na totomukomomoi. I muwo touwoi toukomoi. Tofololilukomo kaimoi. Yo mo nani siyokuno iyaliso louwa iko, popuwa koiyau amiyaikiyo monoi. Ulai toi no sai? Toi mo sosoli.” Aluni apitono mo Isisoso aino na imoki. ");
INSERT INTO amm_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Nosai no mo; Isiso mo ikoki, “Lolaimai noko nokolalo moi ni sinuwo mo, moi mo yoso mulumolo luwaimonowoi muwoi. Moiwoi no moloi tolo tomasimoikuwomo? Yo tulosukomomono. Alu mo na pokawiyo tumowo.” ");
INSERT INTO amm_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","No monoi no kawiyo tumokino. Popuwa mo Isisoso fu kwaiki mo, alu mo lolai siyaso na fafololomanikomo kaiyouki. Asiso na usukunoki, kokalolomani komaloki. Ko mo somusouwoi na tomukomoki. ");
INSERT INTO amm_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Nosai no mo; Isiso mo apitonoso na imoki, “Alu no maniwoi uwoki?” Na fowaki, “Alufasai noinoso nali no. ");
INSERT INTO amm_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Saiso saiso tuwomosi. Nuwoi siya mo taso tofakukiyomosi. Nuwoi siya mo iwoso. Na louwa totukolokaimoi. Nono mo sai mo, mulu na pokalo unumoko, na pofasimoko.” ");
INSERT INTO amm_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Nosai no mo; Isiso mo na imoki, “Hani monoi timononi, sai monoi no? Noko mo mulumolo luwaimonakimo, komaso hani hani mo waliyo yoimo.” ");
INSERT INTO amm_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nosai no lolai siyaso siyoliso na imoki, “Yo mo nonoso niya tomulumolo luwainoki, koufaso. Na pofasimono, mulumolo luwainoki mo. No monoi no siyoliso mulumolo luwaiyoikimo.” Aino imoki, aluni apitonoyo mo. ");
INSERT INTO amm_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nosai no mo; noko nokolaloyo fufumuwanalo tumoki. Isisoyo kwaikoki mo, popuwa koiyauso mo na ikimoki, “Aluni ausai mo na putukaimo, iyowoi kowoi lopumokai aluni ausai mo. Ya timonoki, ifou noiyo tumoi.” ");
INSERT INTO amm_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","No monoi no omoki, nonani popuwa mo, aluni auso na fafololomanikomo kaiyouki, na utukaimoki. No monoi no mo, alu mo yau komiyai tanoki. Noko siyaiyo piyamoki, yauwo. ");
INSERT INTO amm_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ulai Isiso mo nainosai na kominiyouki, no monoi no tolauki, alu no mo. ");
INSERT INTO amm_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Nosai no mo; Isiso iyali mo utukaikokino, nu poiso tiki. Tiki mo; siyokutono iyali mo wosu wososu na imokino, “Moloi monoi woi, koi no popuwa koiyau amiyaikiyowai sosoli no hani monoi?” ");
INSERT INTO amm_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Na ikoki, “Kotososo putolumonuwo mo, nonani popuwa koiyau mo waliyo pamiyaikiyonuwo. Molo siyawoi muwoi.” ");
INSERT INTO amm_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Nosai no mo; nonani asi utukaimokino, Kalili asi mulumai tokosiyaikaiyoukino. Isiso mo noko nokolaloso kukalikaikokaiyouki, to ki monoi mo wiyou. ");
INSERT INTO amm_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Ulai afonimaiso? Siyokutono iyaliso aiyolokaloki. Na ikoki, “Asa, asi asi noko nokolaloni noko siyoli nokota yo mo uo nokoni auso na kiyomono taikiyoinomo. Na tukolomonoinomo, yau. Amoloki tiwoi mo uwai, ulo siya mo ifou na auwoniyouwoimo, yausai.” Aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ulai toi no nonani imo no sai? Imo folosai mo sai muwoi, sosoli. Utolumo monoi nimokino. ");
INSERT INTO amm_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Nosai no mo; Kopanaumo nokonuso tiki. Nu poiso tiki mo, siyokutono iyaliso na ikoki, “Moi no molomai no hani imoso lukasonuwo?” ");
INSERT INTO amm_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ulai pa fowakinoso. Ulai afonimaiso? Molomai mo iyamaloki, “Totawoi nokota siyoli no noiyo toloimo, woi?” ");
INSERT INTO amm_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Nosai no mo na yousa konoki, noko molo tiwoi nokoso aliyonikoki. Tiki mo; na ikoki, “Nokoyo siyoli nokota tolo mulu yakimo, to mo afonimai nokotasu na tolumo, nokoso mi ano fasiko nokota na tolumo.” ");
INSERT INTO amm_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ikoki mo; alufaso kausiki, toini mulumai na kauwokaiki. Alu ufalo toliki, na ikoki, ");
INSERT INTO amm_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Mulumolo luwaimono nokotayo aluso imo mo, “Waliyo potumo,” to mo yoso mani, imono, “Waliyo na potumo.” Yoso aino imono mo, imono taikiyo nokotaso mani, imo, tumumo.” Aino na ikoki, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Nosai no mo; Iyono mo Isisoso na imoki, “Aiyolokomomoko nokota, koi mo noko siya kinoki, popuwa amiyaikiyoko waikoso. Nani siyolo kaluwaiyaloni, no monoi no popuwa amiyaikiyoko waikomoi. Ulai moiso pakoso taluwaimokoso. No monoi no koi mo wiyou, na alukimonoki.” ");
INSERT INTO amm_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ulai ikoki, Isisoyo mo, “Noiyo alukimoiwo. Yani siyolo kaluwaimono nokota mo mulu ifolaluwawoi mi anakimo, somaiso mo uo imo pa yomoiso, asa monoi. Uo imo pa yomoiso. ");
INSERT INTO amm_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nokoyo moiso uo mulu yo unu somiso mo, to mo moini woli na. ");
INSERT INTO amm_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Motuwa na timonukuwo. Nokoyo Kolaisoni siyokutono iyali moiso mo iwo woliyoninakinuwomo, motu nali, Koto mo suo foli na aninoimo. Ulai afonimaiso? Kolaisoni siyokutono iyali moi fasikomo monoi, no monoi no.” ");
INSERT INTO amm_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ti monoi ikoki, siyokawi imo mo, na ikoki, “Noko mo mulumolo luwaimono nokotafaso aini ifoluwaiyakimo, wiyou, siyoliso na uwoyoimo, mulumolo luwaimono nokota aini ifoluwai foli monoi. Nokoyo iwo utaiso tukolo silakinomo, tomoki siyoliyo imo molomai konosuwakaiyakinomo, no mo koufasu. Mulumolo luwaimono nokota aini ifoluwai foli mo soliyakiso na uwokaiyoimo. ");
INSERT INTO amm_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Nainoyo molo koiyauso kalumaniyakinimo, na pa kokolofoliko taikiyo. Nonani naino no kalumanini no, nonaniwoi tolakinimo, no mo waliyo muwoi, wonikaluso sopokumono somiso taso na manoinimo. Nainoso kokolofolikakinimo, no mo waliyo, molo koiyauso pa aluwaiyoiniso, aniyopa poi poi toloinimo. ");
INSERT INTO amm_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Sokolo Nokota Waini auso si noko mo “omokoyo na tonoko manono. Ulai pa tokolikalimoiso, nonani omoko mo. Aniyopa poi poi na tosimoi. Ta mani, aniyopa poi poi na totanomoi, pa sopokumonomoiso.” ");
INSERT INTO amm_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Fonayo molo koiyauso kalumaniyakinimo, na pa kokolofoliko taikiyo. Nonani fona no kalumanini no, nonaniwoi tolakinimo, no mo waliyo muwoi, wonikaluso taso na afoli taikiyoinimo. Fona kokolofolikakinimo, no mo waliyo, molo koiyauso pa aluwaiyoiniso, aniyopa poi poi toloinimo. ");
INSERT INTO amm_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Sokolo Nokota Waini auso si noko mo “omokoyo na tonoko manono. Ulai pa tokolikalimoiso, nonani omoko mo. Aniyopa poi poi na tosimoi. Ta mani, aniyopa poi poi na totanomoi, pa sopokumonomoiso.” ");
INSERT INTO amm_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Molo siyayo molo koiyauso kalumaniyakinimo, na pa solifoli taikiyo, nonani molo siya mo. Molo tiwoi tolakinimo, no mo waliyo muwoi, wonikaluso taso afoli taikiyoinimo. Molo siyaso solifoli taikiyakinimo, no mo waliyo, molo koiyauso pa aluwaiyoiniso, Kotoni auso amiyoinimo, na samukuyoinimo. ");
INSERT INTO amm_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Sokolo Nokota Waini auso si noko mo “omokoyo na tonoko manono. Ulai pa tokolikalimoiso, nonani omoko mo. Aniyopa poi poi na tosimoi. Ta mani, aniyopa poi poi na totanomoi, pa sopokumonomoiso.” ");
INSERT INTO amm_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Nofuwa noko mo mamoyo tuluwaulu manokoni. Noinoso na, tayo mo noko nokolaloso na sakoloukoimo, ");
INSERT INTO amm_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Mamo mo itouniyaimo na. Ulai mamo koiyaumakimo, usutono no moloi tano monoi? Usutonowoi muwoi. Ulai ti monoi no moloi yo monoi, woi, usutono tano monoi no? Noinoso moi mo mamo ititouni komiyai, na pa siwo. Uo imo noiyo ikuwanoiwo. Na pa asisikuwanowo.” Siyokutono iyaliso aino na ikaloki, siyokawi imo mo. ");
INSERT INTO amm_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Nosai no mo; Isiso mo Kopanaumo nokonuso utukaimoki, Yutiya asiso monoi manoki. Yotano iwo tokosiyaikaiyo tiki, iwo ilo ausaimiso. Nomai no mani, noko nokolalo molopoi mo ukouniyaikokuya tumokino, Isisoni auso. Na aiyolokoki. Kotoni imo no paiyolokalo manoki no, ainoso na. ");
INSERT INTO amm_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Nosai no mo; Falisi moloso aluwai noko siyai mo na louwa imo kiya tumokino, “A, koini aniyopa molo no waliyo noni afolikaiso no? Au poimo.” ");
INSERT INTO amm_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Isiso mo fowakoki, “Musiyo no hani imoso kumokaiki?” ");
INSERT INTO amm_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Na imokino, “Musiyo waliyo yomuki, na kumokaiki, “Noko mo noni afolikaiso monoi yo mo, paso kumotisumo, na afolikaisumo.” ");
INSERT INTO amm_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ulai Isiso mo na ikoki, “Momaiyo kukamokokai manonuwo, no monoi no mo Musiyo ainoso kumokainonikinuwo, nokolalo salosokai monoi mo. Ulai noino mani, tiyomuko, ");
INSERT INTO amm_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","“Tokuwa toku, Kotoyo hani hani no mulumoloko manoki mo, na auwonouluki. Nanomuwoi toniyoiwoi mani, na mulumolokoki, na tolokino.” ");
INSERT INTO amm_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“No monoi no mo, sauwo nokota mo atino apitono noko tiso utukaikumo, kwamitonoso na kunaliyaisa tumumo. ");
INSERT INTO amm_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Toti mo au mo tomoso na, mulu mani, tomoso na tiyousino.” No monoi no au fofamo pa totolonoso, au tomoso na totolono. ");
INSERT INTO amm_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","No monoi nosu mo Koto mo yasoi muwokokaiki, toti mo. Noko no moloi afolikaiso monoi?” Falisi nokoso ainoso na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nosai no mo; nuso tiki mo, siyokutono iyaliyo imokino, nonani imo folosai monoi. ");
INSERT INTO amm_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Na fowakoki, Isiso mo, “Nokoyo totani noni afolikaisakimo, noni siyaso kausakimo, to mo uloliyo nokota na, totawoi nukonuso koiyausoimo. ");
INSERT INTO amm_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Noniyo totani nokoso utukaimakimo, noko siyaso auwanakimo, to mo uloliyo nukonu nali.” Siyokutono iyaliso aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Nosai no mo; alalo lolofa koliyoniyo tumo liyai manokino, Isisoni auso, nainoyo isikokaikalo monoi. Ulai uo imo na ikokino, siyokutono iyaliyo. ");
INSERT INTO amm_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ulai Isiso mo nonani imo kwaiki mo, mulu atolokomoki, amiso na ikoki, siyokutono iyaliso, “Tofolo na pukwaikokaiwo, alalo mo yani auso mo waliyo na tuo. Hani monoi talukikonuwo? Noko komaso noko mo ninani alalo komiyai no tosi no, toiso tosamukukomoi, Kotoyo mo. ");
INSERT INTO amm_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Motuwa na timonukuwo, Kotoyo noko nokolaloso samukuka tumakimo, alaloyo na iyamoimo, “Waliyo na posamukumoka tumo.” Moi mo aino iyamo somiso mo, Kotoyo pa samukukomoinuwoso.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nosai no mo; alalo mo na ufufalo tolikoki. Komumai mo nainoyo na isikokaikaloki, na ikoki, “Koto mo na tofasikomo manonuwo.” ");
INSERT INTO amm_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Nosai no mo; Isiso mo louwa manoki, ulai noko mo fuma tumoki, alokomu losiyaiko una tumoki, na imoki, “Aiyolokomomoko itouniyaimo nokota, yo no moloi yoimo, woi, aniyopa poi poi yousi itouniyaimo monoi no?” ");
INSERT INTO amm_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ulai Isisoyo na imoki, “Hani monoi tokaluwaimononi, itouniyaimoso no? Koto saso mo itouniyaimo na. ");
INSERT INTO amm_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Nono mo Kotoni ami imo mo sai na, noino. Noko mo noiyo tukoloi, noko kwami nukonu mo noiyo uwokaisoi, noiyo polamokoi, noko siya monoi noiyo ifoluwai unoi, nokoni ilolu noiyo i watiyoi, anoni apono noko tiso na pa kisosomikomoi. Kotoni imo nino, nono mo sai. Na piyomu.” ");
INSERT INTO amm_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Na imoki, nonani nokota mo, “Aiyolokomomoko nokota, alusai na taluwaikomoi, nonani imo komaso mo.” ");
INSERT INTO amm_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Nosai no mo; Isiso mo nonani nokotaso kwaiki, mulu unuki, na imoki, “Mulu siya mo amai piyo. Nani ilolu mo ilolu somiso nokoso na pa wautiyalo, ilolu komaso mo. No monoi no suo foli monoi anoinimo, kumokiso. Wau niko uwai; yoso pa aluwaimoniyo tumo.” ");
INSERT INTO amm_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ulai noko to no mo, to mo nonani imoso kwaiki, amuwaso mulu na uwoki, ilolu mulu na kaloki. Ulai afonimaiso nokota? Ilolu molopoi nokota nali. Isisoso utukaimoki, na manoki. ");
INSERT INTO amm_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Nosai no mo; Isiso mo siyokutono iyaliso kokaloki, na ikoki, “Ilolu molopoi noko no Kotoni auso no moloi toimo, asi no samukukaki no? Wiyou, nonani mi mo siyoli, muluso nali no.” ");
INSERT INTO amm_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nosai no mo; siyokutono iyali mo nonani imoso no kwaikino mo, na mulumoloko manokino. Ulai ti monoi na ikoki, Isiso mo, “Woli iyali, noko no Kotoni auso no moloi toimo, asi no samukukaki no? ");
INSERT INTO amm_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Siyokawi imo na pukwaiwo. Kamilo koloni siyoli no moloi lotiso monoi, iwoi nilini i poiso no? Moloi lotiso monoi, to mo sosoli. Ilolu molopoi nokota, to no Kotoni auso no moloi amiyo monoi, asi no samukukaki no? Moloi amiyo monoi, to mo sosoli. Ulai ya timonukuwo. Kamiloni mi, iwoi nilini i poiso lotiso monoi, nonani mi mo koufasu. Ilolu molopoi nokotani mi, Kotoni auso amiyo monoi, nonani mi mo soliyaki, muluso nali.” Siyokawi imo mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ikoki mo; siyokutono iyali mo siyoliso na kufaukoki, na lukasikuwanalokino, “Ulai aino mo, noi nokotayo no waliyo no moloi amiyoimo, Kotoni auso no? Noi no samiyaikiyoimo?” ");
INSERT INTO amm_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Isiso mo kokaloki, na ikoki, “Nokoyo no ulai moloi yo monoi? Kotoyosu mo waliyo. Totayososu mo hani hani mo waliyo na tiyomoi.” ");
INSERT INTO amm_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Nosai no mo; Pitayo imoki, “Koi mo kokaini asi yasoi na utukaikalokinoki, iloluwoi mani, utukaikalokinoki. Nonoso taluwainiyo tumonoki. Motu na piyomu.” ");
INSERT INTO amm_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Na ikoki, Isiso mo, “Motuwa na timonukuwo. Mulumolo luwaimono noko, Kotoni imo itouniyaimo no lukasikalo no, toi mo hani hani utukaiko liyaiyakinomo, suo foli monoi mo siyoliso na nikoimo, ulai koufa, soliyakiso na nikoimo, asimai simai. Namolimaiso mani, aniyopa poi poi si itouniyaimoimo. Motu na, nu, auwatono iyali, inaitono iyali, atino iyali, apitono iyali, alalo, isi, no mo utukaiko liyaiyakinomo, suo foli monoi mo soliyakiso na nikoimo, nu molopoiwoi, auwatono iyali molopoiwoi, inaitono iyali molopoiwoi, atino iyali molopoiwoi, alalo molopoiwoi, isi molopoiwoi, nonani hani hani tonofalowoi na soimo. Aino sinonakimo, uo nokoyo uwokaikoinomo. Namolimaiso Kotoni auso na si itouniyaimoimo. ");
INSERT INTO amm_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ulai noko sisiyoli siyai lolaimai no tosi liyai no, toi mo afonimaiso na soimo. Afonimai noko mo sisiyoli na soimo.” Aino na ikoki, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Nosai no mo; Yolusolimo molo na nuki. Isiso mo toku na tolono nikoki. Siyokutono iyali mo namolisai, na mulumolokalo manokino. Noko nokolaloyo no aluwaikokino no, toi mani, na kokolokaloki. Nuwalo manoki mo, Isiso mo noko molo tiwoi nokoso foukoki, kwasai koliyo noki. Nosai no tota uwokai aino imo monoi lukasiyoluwaikoki. ");
INSERT INTO amm_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Na ikoki, “Na pukwaiwo, konoi mo Yolusolimoso na tonukoni. Asa, asi asi noko nokolaloni noko siyoli nokota yo mo nokotalo iyalini nainoso kiyomonoinomo. Lotu samukuko noko sisiyoliwoi Musini imo sai sisiyoli nokowoi, toini auso na kiyomono taikiyoinomo. Imo na lukaso unumonokaiyoinomo, tukolomono imo monoi mo. Noko nokonu nokoni nainoso na kiyomonoinomo. ");
INSERT INTO amm_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Na alisiyoli yoluwaimonoinomo, usuwoyo aso kolomonoinomo, noko nokonu nokoyo, suwoi suwoi moloyo wasomonoinomo, na tukolomonoinomo, yau. Amoloki tiwoi mo uwai; ulo siya mo yausai ifou na auwoniyouwoimo.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Nosai no mo; Sipitini alalo tiyo mo Isisoni auso tumokino, Yamisowoi Iyonowoi. Na imokino, “Aiyolokomomoko nokota, koti mo tutolumonoki, siya hani monoi. A, koti no waliyo tuwaiyomimokoni?” ");
INSERT INTO amm_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Na ikoki, “Moti no ya hani uwokomo monoi tiyonuwo?” ");
INSERT INTO amm_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Na fowakino, “Ami siyoliwoi tola tumakinimo, koti mo nonowoi yousikaino monoi tiyonoki. Siya mo nainasai siya mo sokonisai yousi monoi tiyonoki, noko sisiyoli ti tolo monoi. Nonayo piyomu.” ");
INSERT INTO amm_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ulai Isiso mo noko tiso na ikoki, “Nonani hani monoi no tutolumomononuwo no, moti mo sai muwoi. Moti mo aluwaimonakinuwomo, iyanoko uwokomoinuwomo, asa komiyai, iyanoko sisiyoli nali no. Moti no waliyo?” ");
INSERT INTO amm_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Na imokino, “Koti mo waliyo.” Na ikoki, “Motu na, iyanoko na uwoyoinuwomo, iyanoko sisiyoli na. ");
INSERT INTO amm_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ulai yani auso yousi nokota ti muwoko monoi, no mo yani hani muwoi, nainasai yousikainowoi sokonisai yousikaino monoiwoi. No mo yani hani muwoi. Nonani yousi ti mo yani Apouyo noko ti monoi yasoi na foukaitiki.” ");
INSERT INTO amm_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Nosai no mo; siyokutono iyali noko naino ti, toi mo nonani imoso kwaikino mo, mulu atolokomo ukukino, Yamisowoi Iyonowoi monoi. ");
INSERT INTO amm_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ulai Isiso mo aliyonikoki, na ikoki, “Moi mo sai, noko nokonu nokoyo no tiyamo uku no, noko sisiyoli, toi mo totamiyoluwaiko manono, toini noko nokolaloso. Nokotalo iyali mani, talotoluwaiko manono, totaini nasu wosuwoimai no tosi no. ");
INSERT INTO amm_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Momaisu mo nonani moloso noiyo aluwaiyoiwo. Moi nokota mo siyoli tolo mulu yakimo, to mo moini mi ano fasikomo nokota na tolumo. ");
INSERT INTO amm_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Moi nokota mo totawoi nokota tolo mulu yakimo, to mo noko nokolalo komasoni nasu wosuwoimai na tolumo, suomoso monoiso mi ano nokota nali. ");
INSERT INTO amm_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Asa, asi asi noko nokolaloni noko siyoli nokota yo mani, moiyo fasimono monoi pa amukonokiso. Yo mo moi monoiso na fasikoma konokinukuwo, ifou kolisoikuwomo. Afonimaiso kolisowoi muwoi, suo mo na kalo unoikuwomo, no monoi no noko molopoi noko moi soinuwomo, aniyopa poi poi.” Isiso mo aino na ikoki, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Nosai no mo; Isiso iyali mo Iyoliko nokonuso tiki mo, ulai nosai no mo na utukaimokino. Noko nokolalo molopoi molopoiyo aluwaikokino. Utukaimokino mo; Patimiya, Timiyani awitono mo molo kwamai na piyousikainoki. Molo kau kau nokota na, muwoni ni monoi pikomosiki, “Muwoni na ponimonowo.” ");
INSERT INTO amm_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Isiso, Nasolito nokota, to tumo imoso no kwaiki mo, siyoliso na imaloki, “Isiso, nono mo Toiwini nakosaitono, na pomulu unumono, na pofasimono.” ");
INSERT INTO amm_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Noko nokolalo molopoiyosu ikimokino, “Oi, wosu woso.” Ulai siyoliso amai imalo manoki, “Nono mo Toiwini nakosaitono, na pomulu unumono, na pofasimono.” ");
INSERT INTO amm_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nosai no mo; Isiso mo na tola tumoki, noko nokolaloso ikoki, “Na paliyoniwo.” No monoi no molo kau kau nokotaso aliyonikino, na imokino, “Mulu noiyo kaloi. Na pauwoniyou. Nono monoi na taliyonini.” ");
INSERT INTO amm_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","No monoi no fulomu tuno asifoliki mo, Isisoni auso amunoki. ");
INSERT INTO amm_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Nosai no mo na imoki, Isisoyo mo, “Nono no ya hani uwo monoi tiyoni?” Molo kau kau nokota mo na imoki, “Aiyolokomomoko nokota, yani molo ti poposaso ulukomomono.” ");
INSERT INTO amm_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Nosai no mo; Isiso mo na imoki, “Na pomoi, waliyo tomulumolo luwaimononi, no monoi no mo waliyo na totoloni.” Lolai siyaso to mo waliyo na toloki, na foinalikoki. Isisoso na aluwaiki, Yolusolimo molomai. ");
INSERT INTO amm_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Nosai no mo; Isiso iyali mo Yolusolimo nokonu siyoli aumoifaso tiki mo, nokonu lolofa tiso fiyamosiya tumokino, Pitifaki nokonuwoi Pitano nokonuwoi. Oli yu kiyoku kwamai tanono, nokonu ti mo. Tiki mo; nosai no Isiso mo siyokutono noko tiso na iko taikiyoki, ");
INSERT INTO amm_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","na ikoki, “Nokonufaso na pomanowo, na pa lotiwo, nokonu aumoifaso ni tokinuwo no. Lotakinuwomo, lolai siyaso na kiyoinuwomo, hosofa mo. Konosuwakaiso kiyoinuwomo. Toku nokoyo yousa yowoi muwoi. Na pako fololokomowo, yani auso na pako kiyomomona tumowo. ");
INSERT INTO amm_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ulai nokoyo utolumakinuwomo, “Hani monoi tiyonuwo?” Noino na pako imowo, “Siyoli Nokotayo timoko taikiyo, ninani hosofa kiyomo monoi. To mo somaiso ifou amai na kiyomo taikiyoinimo. Mulu mo noiyo kaloi, awa.” Isiso mo aino na iko taikiyoki. ");
INSERT INTO amm_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Nosai no mo; toti mo yasoi, hosofa mo kiya tumokino, nu itu lotimai konosuwakaiso, molo kwamai. Na fololokomokino. ");
INSERT INTO amm_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Ulai aumoifaso si nokoyo na ikokino, “Moti no hani monoi tiyonuwo? Hosofa no hani monoi tofololokomonuwo?” ");
INSERT INTO amm_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ulai toti mo Isisoyo no ikoki no, nonani imososo na ikokino. No monoi no mo waliyo na iyamoki, hosofa kau monoi mo. ");
INSERT INTO amm_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Nosai no mo; yasoi, hosofa kiyoma tumokino, Isisoni auso mo. Totini tuno mo hosofani namoli tonimai na akaikoma yokino. Akaikoma yokino mo; Isiso mo na yousikaina yoki. ");
INSERT INTO amm_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Nosai no mo; noko nokolalo molopoi mo tuno mo molomai asisikaiya tumo liyaikino, na soikai unalokino. Siyai mo iwasuwo mi tofu iyo tumokino, isisai, molomai na isikokaiya tumokino. To tumo monoi molokimokino, no monoi no yokino. ");
INSERT INTO amm_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Siyai mo toku toku tolono nikino, siyai mo namolisai tiki, na isalo niyalokino, siyoliso na iyamaloki, “Na tomolokimokoni. Ninani nokota, Noko Siyolini amimai ni totumo no, tani siyolo na tokaluwaiyaloukoni. ");
INSERT INTO amm_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Moini aniyopa, Toiwi, tota komiyai tosamukumoka tumo. No monoi no tomolokimokoni. Siyoliya Nokotani siyoloso na tomolokimokoni.” Aino iyamaloki. ");
INSERT INTO amm_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Nosai no Yolusolimo nokonuso fiyamosiya tumokino. Isiso mo lotu nu siyoliso lotiki, na ki kiyaloki. Ulai ulo mo ku poki. No monoi no mo noko molo tiwoi noko koliyo fuki, Pitano nokonufaso sanoki, ulololi mo. ");
INSERT INTO amm_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Ulai amuwoisai ifou, Pitano nokonusai utukaimokino, Yolusolimo nokonu siyoliso monoi nuki. Isiso mo tiya na kaloki. ");
INSERT INTO amm_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Sipoki aso kosoki, molo kwa aluwamaifa tolososo. Suwo mo soni siyoli. Nosai no aumoifaso na kosanoki, sipoki wamo monoi. Ulai wamowoi muwoi, uwofa, suwo saso. Ulai afonimaiso, wamoko popo pa toiso. ");
INSERT INTO amm_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ulai Isisoyo nonani sipoki aso na isoki, “Wamowoi noiyo si manoi.” Siyokutono iyaliyo nonani imoso na kwaimokino. ");
INSERT INTO amm_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Nosai no mo; Isiso mo Yolusolimo nokonuso tumoki mo, lotu nu siyoliso lotiki. Hani hani suo suomoko noko iyaliso na amiyaikiyoko taikiya tiki. Muwoni suo suomoko nokoni kotisokoso na alokwi wati taikiyoki. Anomu suo suomoko nokoni sinono hani mani, na alokwi wati taikiyoki. ");
INSERT INTO amm_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","To mo wiyou yomuki, lotu nu poiso suo suomoko monoi mo. Na yomuki, “Ilolu iyo ti liyai mo wiyou tiyomu, yo mo.” ");
INSERT INTO amm_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Kotoni imo aiyolokoki, na ikoki, “Kotoni puko imoyo mo na tiyomuko, “Yani nu mo asaso utolumomono nu na kaluwaiyoinomo. Asani nu poiso mo asi asi noko nokolaloyo imo lukaso nimonoinomo.” Ulai moisu mo noko nokolaloni muwoni ti wati manonuwo. Wiyouwa wiyou, ni mo polamoko nu muwoi.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Nosai no mo; lotu samukuko noko sisiyoliwoi Musini imo sai sisiyoli nokowoi, toi mo Isisoni imo kwaimokino mo, to tukolo molo monoi lukaso unukino. Ulai tukolo monoi nimokino. Noko nokolaloyo tani aiyoloko monoi kufaukoki, no monoi no. ");
INSERT INTO amm_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Nosai no mo; amoloki mo; Isiso iyali mo yasoi, nokonu siyolisai utukaimokino. ");
INSERT INTO amm_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Amuwoisai somosai ifou nuki mo, molomai sipoki aso na kosokino, somaiso na somoso taikiyoki. Totiwoi samo samokokai. ");
INSERT INTO amm_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita mo nonaniso no kosoki mo, mulumolokoki, Isisoso na imoki, “Aiyolokomomoko nokota, fai na sipoki a uo imo ni isani mo, na somoso taikiyo.” ");
INSERT INTO amm_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Nosai no mo; Isiso mo na fowakoki, “Kotoso na pa mulumolo luwaiwo. ");
INSERT INTO amm_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Motuwa na timonukuwo. Yu ni tolo no, nokoyo nosoniso imakimo, “Mamo iwo siyoli mulumai potolano,” yu mo na tolanoimo. Motu na, mulu tiwoi somiso nokotayo mulumolokakimo, “Ya ni tiyomu no, nonani imo mo motu na fiyamosiyoimo,” Koto mo nonani imo na kwaiyoimo, na yononinoimo. ");
INSERT INTO amm_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ulai ti monoi na timonukuwo, mulumolo luwai noko moiyo hani ano monoi Kotoso utolumakinuwomo, nonani hani mo waliyo na anoinuwomo, Kotoso noino imakinuwomo, “Motu na, nonani hani mo Kotoyo na amokoimo.” ");
INSERT INTO amm_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Kotoso utolumo monoi yakinuwomo, toku mo uo imo na pa tokosokikowo. Kopokoiyaukomo foli monoi mo nokoso iko somiso mo, moini Apono, kumokiso ni you tolokaino no, to mani, moini molo kopokoiyau monoi imo mo futo. ");
INSERT INTO amm_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ulai moi mo imo tokosokiko somiso mo, moini Apono, kumokiso ni you tolokaino no, to mo moini molo koiyau foli monoi imo mo futo muwoi, amai.” Siyokutono iyaliso aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Nosai no mo; Isiso iyali mo ifou tiki, Yolusolimoso. Lotu nu siyoli poimai liyaiki, Isiso mo. Liyai manoki, lotu samukuko noko sisiyoliwoi Musini imo sai sisiyoli nokowoi Isolilo nokotalo iyaliwoi, toi mo kiya tumokino, ");
INSERT INTO amm_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","na imokino, “Noini amiyo nonani mi ano monoi no? Noiyo imo taikiyokini?” ");
INSERT INTO amm_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Na fowakoki, “Yo mani, imo siya utolumo monoisu na tiyo. Yani imoso fowamonakinuwomo, suo foli monoi mo imono taikiyo nokota monoi aino imo na imoikuwomo. ");
INSERT INTO amm_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Iyono mo noko mo iwoso puluwako manoki. No mo asini hani poimo, kumokini hani poimo. Moloi tiyamonuwo, na pimonowo.” ");
INSERT INTO amm_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Nosai no mo; totai amu imo lukasikuwanokino, na iyamoki, “Moi mo iyamakikonimo, “No mo kumokini hani nali no,” to mo imokoimo, “Hani monoi totani imoso pa mulumolo luwaikinuwoso?” ");
INSERT INTO amm_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ulai iyamakikonimo, “No mo asini hani nali no,” noko nokolaloyo na uwomokoimo.” No monoi no kokolokoki. Ulai afonimaiso? Noko nokolalo komaso noko mo Iyonoso waliyo mulumolo luwaikino, iyamoki, “Kotoni mulu lukasiko nokota na.” ");
INSERT INTO amm_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Totai amu lukasikuwanokino mo; Isisoso na imokino, “Koi mo sai muwoi, Iyono no iwoso uluwako no noini amiyo, woi? Noiyo poimo imo taikiyoki.” Nosai no mo ikoki, “Noinoso na, yo mo pa imoikuwoso, yo mani, noiyo poi imono taikiyoki, yani mi ano monoi mo.” ");
INSERT INTO amm_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Nosai no mo; Isiso mo nokotalo iyaliso aiyolokoki, siyokawi imo sopo posasokoki, na ikoki, “Noko mo aliyoli ali na tikaiyalo, isiso. Ikai uwai; tokoki fiyaikalo. A wamo kunoliko monoi asi i taikalo, isi poiso. Samukuko nokotani nu sopofa tokononikai. Nosai no isi mi ano nokoso na tikano, “Yani isi na posamukumonowo.” Ikano mo; noko nokonu nokoni asiso na tomoi. ");
INSERT INTO amm_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Nosai no mo; wamo wamokomai nonani nokota mo mi ano nokotaso timo taikiyo, isi samuku nokoni auso. Na timo taikiyo, “Isini no siyai na pimonano.” ");
INSERT INTO amm_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ulai isi samuku noko mo nonani mi ano nokota tuwono, na tuwasono, afonimaiso ifou tamiyaikiyo taikiyono. Isi aliyoli pa toninoso, niwoi muwoi. ");
INSERT INTO amm_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Nosai no mo; ti monoi mani, mi ano nokota siyaso timo taikiyo. Ulai nonani nokota mani, komumai tuwasono, na tuwokaino. ");
INSERT INTO amm_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nosai no mi ano nokota siya timo taikiyo. Ulai na totukolono, yau. Ulai siyasonuso noko molopoi tiko taikiyalo. Siyai mo tuwasoulino. Siyai mo na totukuwolino, yau yau. ");
INSERT INTO amm_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Iko taikiyalo mo; nosai no mo; mi ano noko mo uwai. Awitonosu mo amai totolo. Wiyou, apitono mo mulu siyoli tunu. Ulai na timo taikiyo, tiyomu, “Yani aluso auwosiwaiyoinomo.” ");
INSERT INTO amm_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ulai isi samuku nokoyo awitono tumoso tukwaino mo, totai amu tikuwanono, “Anunani nokota mo amuwoi tino mo apitononi isi kwalomai monoi na anoimo. Moi soi, niya totukolokoni. No monoi no ninani isi mo momaini na ano monoi.” ");
INSERT INTO amm_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ikuwanono; awitonoso na tokomikaino, na totukolono, yau. Asiyofoloso tafoliyo funo. ");
INSERT INTO amm_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Moloi woi? Isi kiyo nokotayo mo moloi poimo uwokoi. Ya timonukuwo, isi samuku noko iyali mo isi kiyo nokotayo na tukuwoliya tumoimo. Isi mo noko siyaiso na atiya tumoimo, samuku monoi. ");
INSERT INTO amm_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nakomo moi mo Kotoni puko imo siyaso mo kokowoi muwoi. Ninoinosu niya tiyomuko, “Nu kololi nokoyo a moki mo afoli taikiyokino, piyamoki, afonimai a koiyauwo. Ulai Siyoli Nokotasu mo nonani a moki na ikaiki, sopo i a na. ");
INSERT INTO amm_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Noko Siyoli mo aino na yoki. Koiyo tokinoki mo, no mo itouniyaimo nali no.” Aino tiyomuko.” Siyokawi imo mo ainoso na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ikoki mo; nokotalo iyaliyo kominalomano monoi louwa. Toi mo sai na, toi monoi yomu ukuki, no monoi no kominalomano monoi louwa fi. Ulai noko nokolalo monoi nikokino. No monoi no tofolo, na utukaimokino. ");
INSERT INTO amm_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Nosai no mo; nokotalo iyaliyo imo lukasikuwanokino, “Isisoni imo monoi tukwailuwaimokoni. Imo koiyau imoso yomakimo, komanoso na faumikano monoi.” No monoi no Falisi moloso aluwai noko siyaiwoi Hiloni nokowoiso iko taikiyokino. ");
INSERT INTO amm_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Isisoso mo na ima tumokino, “Aiyolokomomoko nokota, koi mo sai, nono mo imo motu nokota nali no. Nonoso no moloi aini monoi, nokoyo no? Imo alinoso na tiko manoni, noko sisiyoliwoi afonimai nokowoiso. Kotoni molo monoi na taiyolokalo manoni. Motu imo saso na tiko manoni. No monoi no mo na pimoko. Moi no takiso muwoni no waliyo toni manokoni, Lomo nokota siyoliso no, Sisiso no? ");
INSERT INTO amm_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Waliyo poimo, wiyou poimo, na pimoko.” Ulai Isiso mo sai, toini mulu monoi mo, topoko saso. Na ikoki, “Hani monoi louwa tainimono ifoluwaimononuwo? Tomoki muwoni siya pasomonowo. Yo tokoso.” ");
INSERT INTO amm_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Tomoki muwoni asononikino. Na ikoki, Isiso mo, “Komuwoi muwoni no noini na, woi? Noini siyolowoi taso?” Na imokino, “Sisi, Lomo nokota siyolini nawoi siyolowoi taso.” ");
INSERT INTO amm_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nosai no mo; na ikoki, “Sisini hani mo Sisiso na poniwo. Kotoni hani mo Kotoso na poniwo.” Wiyou, na mulumoloko manokino, tani imo monoi mo. ");
INSERT INTO amm_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Nosai no mo; Satusi moloso aluwai noko mo Isisoso ima tumokino. Toi mo noko no mo, no tiyamomoi no, “Yau yau noko mo ifou pakoso auwonouloiso.” ");
INSERT INTO amm_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Isisoso na ima tumokino, “Aiyolokomomoko nokota, Musini aniyopa imoyo mo noino na tiyomuko, moi monoi mo. Noniwoi nokota mo ali somisomai kalo mo, tani noni mo auwatonoyo na kausumo, to kwalomai monoi. Alu kiyakinomo, nonani alu mo auwatono kwalomai monoi na tolumo. ");
INSERT INTO amm_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Koi timonoki, noino, toku auwa auwa noko iyali nano siya, 7 na siki. Imu alu mo noni na kausoki, ali mo kiwoi muwoi, nosai no mo yau. ");
INSERT INTO amm_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Nosai no mo; Nokiyamoyo kausoki, auwatono kwalomai monoi. To mani, ali mo kiwoi muwoi, yau. Noinoso nali no, Yamu alu mani, nonani nukonu kausoki, yau. ");
INSERT INTO amm_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Noino noinoso nali no. Imaliwoi Imamuwoi Imowawoi Liyaliwoi, toi komaso mo nonani nukonusoso na kausalo manokino, ulai aliwoi kokowoi muwoi, yau yau. Namolisai mo nonani nukonu mani, yau, yasoi na kalosoki. ");
INSERT INTO amm_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ulai yau yau noko mo ifou auwonoulakimo, nonani nukonu no noini kwamitono tolosoimo, noiyo kausoimo? Toku nano siyawoi auwatono noko koli koliyo kausalo manokino.” ");
INSERT INTO amm_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Nosai no mo; Isiso mo na fowakoki, “Moi mo Kotoni puko imo mo sainowoi muwoi. Kotoni ami mani, sainowoi muwoi. No monoi no afonimaiso na tiyamonuwo. ");
INSERT INTO amm_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Yau yau noko nokolalo auwonoulakimo, toi mo pa kolikuwanoinoso. Kotoni kumoki noko komiyai na soimo, susauwoso. ");
INSERT INTO amm_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ulai yau yausai ifou auwonoulu monoi ya na timonukuwo. Nakomo moi mo Musini puko imo mo kokowoi muwoi, afaso fofoumo aino imo mo. Nonani aino imo mo Kotoyo Musiso lukaso wiyononiki, toku kolikali noko monoi, noino, “Yo mo Apolofamoni Koto, Isakoni Koto, Yokoponi Koto nali no.” ");
INSERT INTO amm_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Koto mo kolikali nokoni Koto muwoi, amai si nokoni Koto na. Moi mo sai muwoi. Sosoli.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Nosai no mo; Musini imo sai siyoli nokota mo na tumoki, koyoso imo lukaso siso. Isisoyo imo itouniyaimo ikoso kwaimoki. No monoi no na utolumoki, “Ami imo, Kotoyo no yomukaiki no, hani imoyo tosouwaiko, komaso imo no?” ");
INSERT INTO amm_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Na fowaki, “Totawoi imo mo nisu, “Moi Isolilo noko, moi mo na pukwaiwo. Noko Siyoli mo Koto saso nali, moini Koto na. ");
INSERT INTO amm_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Nasu, Noko Siyoli, nonani Koto monoi mulu punu. Mulu siyoliso na pa unu. Na pa mulumoloko unu. Na pa aluwaimoi.” ");
INSERT INTO amm_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ami imo siya mo noino tiyomuko, “Nona amu mulu no tiyo manoni no, noko nokolalo monoi mani, noinoso na pa mulu ukumoi.” Nonani imo tisu mo ititouni.” Aino na imoki. ");
INSERT INTO amm_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nosai no mo; Musini imo sai siyoli nokota, to mo Isisoso na imoki, “Aiyolokomomoko nokota, motu na tiyomuni. Koto tota saso mo noko siyoli na, siya mo tolowoi muwoi. ");
INSERT INTO amm_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Kotososo mulu siyoliso na tunukoni. Niya tomulumoloko unukoni. Niya taluwai manokoni. Momai amu mulu no tiyo manokoni no, noko nokolalo mani, ainoso mulu uku na. Nokoyo Kotoso koloni utunoni mo, no mo siyoli hani muwoi. Koloni sakoloukononi mo, no mo siyoli hani muwoi. Kotoso mulu unu, noko nokolaloso mulu uku, nonani ami imo tiso aluwaikakikonimo, no mo waliyo, siyoli hani nali no.” Isisoso aino na imoki, nonani nokotayo mo. ");
INSERT INTO amm_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Isisoyo nonani imoso kwaimoki mo, to mo na yomuki, “Saiwoi nokotayo na timono.” Na imoki, “Nono mo Kotoni au aluwamai pa totoloniso. Na samukuyoinimo.” Imoki mo; nokoyo utolumo monoi mo nimo manokino, pa utolumo manokinoso. ");
INSERT INTO amm_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Nosai no mo; Isiso mo lotu nu siyoli poiso aiyoloko toloki, na ikoki, “Musini imo sai sisiyoli noko no hani monoi tiyamomoi, woi, “Kotoyo muwokai nokota Kolaiso mo Toiwini nakosaitonosu.” ");
INSERT INTO amm_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ulai Kotoni Mulu Itouniyaimo Nokotayo noinomo Toiwi tota mo tani nakosaitono monoi na yomu unuki, noino, “Siyoli Nokotayo yani Noko Siyoliso na imoki, “Yani nainasai na piyousikaino. Yousikaino manakinimo, ainoso hani nono uo noko mo nani fona wosuwoimai na soimo, yani amiyo noinomo.” ");
INSERT INTO amm_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Na pomulumolokowo. Toiwi totayosu mo kaluwaiki, Noko Siyoli na. Moloi monoi woi? Ulai Toiwini nakosaitonosu no?” Ukouniyaiko noko nokolalo molopoi tani imo no kwaimokino no, toi mo siyoliso molokikino, tani imo monoi. ");
INSERT INTO amm_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Isiso mo aiyolokalo tolo manoki, na ikoki, “Atiyaiso na pa siwo, Musini imo sai sisiyoli noko monoi. Tuno sopo sopo asisiko monoi tiyo manono, liyai niko monoi. Asuwo noko nokolaloyo kwaiko monoi tiyo manono. Ukouniyaikomai nokoyo “woli iyali moi kuo” imo iko monoi tiyo manono. ");
INSERT INTO amm_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Lotu numai nokotalo iyalini nu simai sinono monoi tiyo manono. Koloni wasimai mani, noinoso na, noko nokolaloyo kwaiko monoi tiyo manono. ");
INSERT INTO amm_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Susawi nokolalo tifoluwaiko manono, ilolu i wati monoi. Kotowoi imo lukasomai totopoko manono, imo sopo soposo tolukasalo manono, asuwo asuwo. Kotoyo noko nokolalo wauwakimo, soliyakiso na uwokoimo, wiyou, soliyakiso na.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Nosai no mo; Isiso mo yousikainoki. Lotu nu muwoni isikokai pokili mo fokutono ausaimi tasoki, Kotoni mi ano monoi muwoni na. Noko nokolaloyo muwoni inaloso kwaiko yousiki. Na potimosiki, muwoni na pinalokaiyo tumomosikino. Muwoniwoi nokoyo muwoni mo sisiyoliso na inalokino. ");
INSERT INTO amm_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ulai sawi nukonu mo muwoni lolofa tisu na analika tumoki, ilolu somiso nukonuyo mo. Tani analiko muwoni mo siyoli muwoi, koufa nali. ");
INSERT INTO amm_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Nosai no mo; Isiso mo siyokutono iyaliso aliyonikoki, na ikoki, “Motuwa na timonukuwo. Noni sawi ni mo, ilolu somiso nukonu ni mo, to mo muwoni mo siyoli na tanalika tumo. Noko nokolalo siyaiso na tosouwaiko. ");
INSERT INTO amm_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Muwoniwoi noko mo muwoni molopoi mo amai na si. Walotofaso nino, Kotoso. Ulai noni to ni mo, to mo muwoni mo uwofa nali no, komaso yasoi na ni, Kotoso. Koloni no ulai haniyo suo suomokoimo? Muwoni mo uwofa nali no.” Siyokutono iyaliso aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Nosai no mo; Isiso iyali mo lotu nu siyoliso utukaimokino mo, siyokutonoyo imoki, “Aiyolokomomoko nokota, nu sisiyoli na pokoko, tomoki sisiyoliyo kololikino. Wiyou, nu ititouniya ititouni.” ");
INSERT INTO amm_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ulai Isiso mo na fowaki, “Nasu, sisiyoli nu ni mo na pokoko. Ulai amuwoi tino mo na ulalokoinomo. Tomoki puwomai ni si mo, amai pa soiso. Komaso na ulaloko taikiyoinomo.” Aino na imoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Nosai no mo; Isiso mo Oli yuso yousa yoki. Lotu nu mo tu kiki, fokutono ausaimi toloso. Siyokutono iyali siyai mo ima yokino, Pitawoi Yamisowoi Iyonowoi Anotoluwoi. Na ima yokino, ");
INSERT INTO amm_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Na pimoko, maniwoiso lotu nu ulaloinomo? Toku no haniyo fiyamosiyoimo, koi saino monoi no? Nonayo piyomu.” ");
INSERT INTO amm_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Isiso mo na fowakoki, “Atiyaiso na pa siwo. Wonikaluso nokoyo aiko ifoluwaikomoinuwo. ");
INSERT INTO amm_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Noko molopoi na toimo, ifoluwaikoma tumoinuwomo, iyamaloimo, “Yo mo Kotoyo muwomonokaiki, Isolilo noko moi fasikoma tumo monoi.” Wiyou, noko nokolalo molopoiso na ifoluwaikaloinomo. ");
INSERT INTO amm_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Uo tukoluwano umanoso kwaiyakinuwomo, noiyo umomalotikomoiwo, uo tukoluwano imofaso kwai manakinuwomo. Nonani hani mo toku fiyamosoko liyaiyoimo, asi fokumosu mo namolisai. ");
INSERT INTO amm_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Asi siya noko mo noko siyai nokowoi uo tukoluwanoinomo. Noko nokonu noko mo tolomu nokowoi uo tukoluwanoinomo. Nou nou mo asisai auwonoulu liyaiyoimo. Noko mo koloni somiso si liyaiyoimo, tiya sisiyoliyo kolikali si liyaiyoimo. Nonani hani hani kopokoiyau mo iyanoko komiyai. Nokolaloyo alalo no tokoko manono no, nonani iyanoko komiyai nali no. Lolaloso iyanoko mo koufaso, nosai no soliyaki. Kopokoiyau hani no tumaki no, no mani, toku mo koufaso, namolisai mo soliyaki soliyakikomo nali no. ");
INSERT INTO amm_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Atiyaiso, wonikaluso nokoyo kiyokomoinuwomo, uo imo aiko lukaso unoinuwo, nokotalo iyalini molo timai, lotu nu lolofa poimai aiko wasouloinuwo, moloyo. Nokoyo uo imo lukaso unanoinuwomo, sisiyoli nokoso, komano nokoso mo. Ulai afonimaiso? Moi mo yoso tomulumolo luwaimono manonuwo, no monoi no uwokomoinuwomo. Noko sisiyoli nokoni molo timai sakinuwomo, Kotoni imo mo waliyo pa posasoko wiyolukowo. ");
INSERT INTO amm_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Nonani hani hani mo namolisai, toku mo asi asi noko nokolalo komaso mo Kotoni imo itouniyaimoso na kwaiyalowumo. Nokoyo na posasoko wiyotiyalowumo. ");
INSERT INTO amm_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Uo nokoyo kiyokomakinuwomo, mulu mo noiyo kolikaliyoiwo, hani imoso ikonuwowo. Imo mo moiyo pakoso posasokoinuwoso. Kotoni Mulu Itouniyaimo Nokotayo na posasoko wiyoninoinuwomo, no ikakinuwo no. ");
INSERT INTO amm_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Noko mo auwatono monoi komano nokoso uo imo lukaso unanoimo, toiyo tukolo yau imo mo. Apitonoyo mani, awitonoso ainoso nali no uwoyoimo. Alaloyo atino apitono iyaliso namoliyo alosikoinomo, komano noko iyaliso lukaso ukanoinomo, toiyo tukuwoli yau yau imo mo. Ulai afonimaiso? Yoso mulumolo luwaimono foli monoi na tukuwoliyoinomo. ");
INSERT INTO amm_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Noko komaso nokoyo mulu atolokomo unoinuwomo. Ulai afonimaiso? Moi mo yani noko nokolalo na. Noko mo mulu ami amiso sakimo, ainoso hani asi fokumoimo, toi mo na samiyaikiyoinomo.” Siyokutono noko toitatiso aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Nosai no mo; Isiso mo ti monoi na ikoki, “Nomai no mo ya no timonukuwo no, nomai no koiyau hani toloso na kiyoinuwomo, au nu poiso toloso. Asi uwokai koiyau hani nali no.” Mako ya na timonukuwo, noko mo ninani puko imoso kokakimo, na mulumoloko itouniyaimumo. “Nonani ulomai Yutiya asiso si noko nokolalo moi mo yu nokonuso pa uloloniyo yowo. ");
INSERT INTO amm_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Noko mo nu komu tofumaiso you yousakimo, nu poiso tu si hani hani no moloi iya kono monoi? ");
INSERT INTO amm_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Noinoso nali, noko mo isimai tolakimo, tuno no nuso no moloi anano monoi? ");
INSERT INTO amm_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Nomai no, woi. Muwoliwoi nokolalo, woi. Paumai alalo atino iyali, woi. ");
INSERT INTO amm_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Kotoso na pa utolumo manowo, fulomu popomai mo uwokomo somiso monoi. ");
INSERT INTO amm_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ulai afonimaiso? Afonimaiso muwoi. Ulolomaiso mo siyoliso na uwokomoinuwomo. Mulu mo folokomo kaiyoinuwomo. Asi tonofalosai, Kotoyo no mulumolokoki no, ainoso lolaiwoi ainonani koiyau fiyamosiwoi muwoi. Asi fokumomai saso siyoliso na uwokomoinuwomo. Nosai no mo uwai, ti monoi pa uwokomoinuwoso. ");
INSERT INTO amm_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Asi fokumomai mo wiyou, na uwokomo manoinuwomo. Noko Siyoliyo fokusimo somiso mo, noko nokolalo komaso mo kolikaliyoimo. Ulai mulu mo ukukaiyoimo, totayo muwokokai noko nokolalo monoi, no monoi no mo na fokusimoimo. ");
INSERT INTO amm_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Nomai no mo, nokoyo iyamaloimo, “Na pokiwo. Ni mo Kolaiso na, noko no mo Kotoyo no muwokaiki no, Isolilo noko moi fasikoma tumo monoi.” Siyaiyo iyamaloimo, “Na pokiwo. Kolaiso mo ausoni tolokaino.” Topoko imo aino iyamakimo, noiyo kwaikoiwo. ");
INSERT INTO amm_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Imo topoko noko mo na iyamo liyaiyoimo, “Yo mo Kolaiso.” Siyai mo iyamaloimo, “Yo mo Kotoni mulu lukasiko nokota.” Mulu ifolaluwawoi mi sisiyoli ano topoko ifoluwaiko liyaiyoinomo, folo folo. Kotoyo muwokokai noko nokolaloso louwa ainiko ifoluwaikaloinomo. ");
INSERT INTO amm_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Atiyaiso na posiwo. Nonani hani fiyamosoko somisomai, yo mo yasoi imonukuwo.” Aino na ikoki, Isisoyo. ");
INSERT INTO amm_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Nosai no mo; Isiso mo na ikoki, “Nonani hani sisiyoliyo uwokomo uwai; nomai no “ulo mo na sopokumonoimo, amu mani, pa wisoiso. ");
INSERT INTO amm_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Amoloku mo kumokisai na kiyalo kono liyaiyoimo. Hani hani sisiyoli kumokiso you si, nonani hani mo kumolokoimo.” ");
INSERT INTO amm_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nomai no mo, ya amukonoimo. Asi asi noko nokolaloni noko siyoli nokota yo mo na amukonoimo. Yo amukonoso you kimonoinomo, noko nokolaloyo, kuomai amukonoso. Wiyou, ami siyoliwoi amukonoimo, Kotoni saponi yakomaiso. ");
INSERT INTO amm_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nosai no mo; yani kumoki noko iyaliso na iko taikiyo liyaiyoimo, asayo muwokokai noko nokolaloso mo kolisalo monoi. Isaino ti liyaiyoimo, ausaino ti liyaiyoimo, aumoifawoi aluwasaiwoi asi asi komaso asisai.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Nosai no mo; Isiso mo siyokawi imo ikoki, sipoki a aino imo mo, na ikoki, “Sipoki aso tokoko manonuwo. Touwo mo iwowoi totu si mo, iwasuwo tomu tonofalo na tomomoloko taikiyo. No mo moi mo sai, fumu itouniyaimo monoi. ");
INSERT INTO amm_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Noinoso nali, ulo sopoku hani haniso kwaikalakinuwomo, moi mo sai, ya aumoifaso na amukonoimo. ");
INSERT INTO amm_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Motuwa na timonukuwo. Noko komaso noko kolikali somisomai, nonani hani hani mo na fiyamosokaloimo. ");
INSERT INTO amm_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kumokiwoi asiwoi mo uwaimo taikiyoimo. Yani imosu mo amai na tanoimo.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Isiso mo ulai ikoki, “Yo amukono monoi, ulai noko no moloi saino monoi? Maniwoiso poimo. Kotoni kumoki noko mani, ulai toi no sai? Totani awitono, yo mani, sai muwoi. Apou Siyoli totasu mo sai. ");
INSERT INTO amm_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Atiyaiso na pa si manowo. Atiyaiyaso. Moi mo sai muwoi, maniwoiso poimo tumoi. ");
INSERT INTO amm_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ainonani mo nokoyo totani nu utukaimo komiyai na. Nokonu siyaso monoi tomoi. Tani mi anononi nokoso na tikokaiyou, “Yani ilolu na posamukukomono siwo.” Mi siyasonuso tonikokaiyou. Itu loti samuku nokotaso mo na timo, “Atiyaiso na pa samukumoi, itu loti mo.” ");
INSERT INTO amm_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","No monoi no mo, moi mani, atiyaiso na pa fou siwo. Moi mo sai muwoi, nu kiyo nokota mo maniwoiso poi tumoi. Upimoso poi tumoi, amoloki poi tumoi, posasi yako poi tumoi, somosai poi tumoi. Ulai moi no sai? Na kufaukomoinuwomo. ");
INSERT INTO amm_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Wonikaluso somaiso aiko tumoi. Ulololi simai aiko kokoma tumoinuwo. ");
INSERT INTO amm_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ninani imo ni timonukuwo mo, noko nokolalo komaso monoi na tiyomu. Atiyaiso na pa si manowo.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Nosai no mo; Pasowa koloni wasi popo mo aumoifaso na toi, tinoso. Sisiyoliko asu somiso tuo wasi popo mani, aumoifaso na. Nomai no mo, lotu samukuko noko sisiyoliwoi Musini imo sai sisiyoli nokowoi, toi mo Isiso tukolo imo na lukaso unukino, asuwo wosu woso tukolo monoi komi kau monoi. ");
INSERT INTO amm_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Na iyamoki, “Mi fou fouko ulomai pa yo monoiso. Wonikaluso noko nokolalo mo mulu puwoso puwoso. Uo mulu aiko uwokoi.” ");
INSERT INTO amm_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Nosai no mo; Isiso mo Pitano nokonuso toloki mo, Saimo uluoyo uwokaikai nokotani nuso na yousa tiki. Koloni no yousa tiki. Amai no yousi manoki mo, noni mo tumosoki, tomoki nau itouniyaimo na asiyo tumoki, kou woti iwo itouniyaima itouniyaimowoi, muwoni mo siyoli, wiyou. Nau posiluki, woti iwo mo Isisoni komuso na solukimoki. ");
INSERT INTO amm_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Si tomasimo noko siyai mo mulu atolokomo usokino, na lukasikuwanokino, “Ulai afonimaiso no hani monoi solukimo, woi? ");
INSERT INTO amm_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nonani woti iwo mo suo suomoko nokoso patikoni mo, suo mo muwoni mo siyoliso na ponimokono, ilolu somiso nokoso ponikalokoni. Wiyou, muwoni mo sisiyoli.” No monoi no uo imo ikisokino. ");
INSERT INTO amm_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Na ikoki, Isiso mo, “Tofolo, na pukwaisowo. Uo imo no hani monoi tisonuwo? Itouniyaimososu na tuwomono. ");
INSERT INTO amm_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ilolu somiso nokowoi aniyopa poi poi tosi tomasiko manonuwo. Fasiko monoi tiyonuwo mo, amuwoi tinoso mo waliyo na pa fasikowo. Yosu mo aniyopa poi poi pa totolo tomasimonukuwoso. ");
INSERT INTO amm_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Noni mo fasimono monoi tiyo, no monoi no kou woti iwoyo solukimomono. No mo waliyosu. Yo mo nokoyo amai tukolomonoinomo, yau, no monoi no na louwomono, nokoyo ai unumono monoi. ");
INSERT INTO amm_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Motuwa na timonukuwo. Kotoni imo itouniyaimo posasoko liyaiyakinomo, asi asi komaso asiso, ninani monoi aino imo mani, nokoyo na lukasikaloinomo, noniyo ni uwomono no. No monoi no noko nokolaloyo saino usoinomo.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Nosai no mo; noko molo tiwoi mulumai nokota, tani siyolo mo Yutaso Isokailiyo, to mo lotu samukuko noko sisiyolini auso manoki, Isiso toini auso kiyoko monoi ikokaiyanoki. ");
INSERT INTO amm_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","No kwaikino mo, wiyou, toi mo siyoliso na molokikino, imo lukaso nikaikino, na imokaikino, “Suo mo muwoni niyoikimo.” No monoi no Yutaso mo mulumolokaloki, “Yo mo Isiso mo maniwoiso poimo kiyokoi, toini nainoso mo.” ");
INSERT INTO amm_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Totawoi mi fou fouko ulo, nomai no Pasowa sipo potukuwolimosikino, aisamu saiso saisomai. Nonani ulo mo sisiyoliko asu somiso tuo no puwasimosikino no, nomai no mo siyokutono iyali mo Isisoso ima tumokino, “Moisoni foukaininanoikimo, Pasowa koloni no monoi no?” ");
INSERT INTO amm_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","No monoi no mo, Isiso mo siyokutono noko tiso iko taikiyoki, na ikoki, “Nokonu siyoliso lotakinuwomo, nokoyo iwo woliyoniyo tumoso kwaiyoinuwomo. Na pa aluwaiwo. ");
INSERT INTO amm_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Nu poiso lotakimo, nonani nu kiyo nokotaso na pa imowo, “Aiyolokomomoko nokotayo tiyomu taikiyo, “Pasowa koloni no si nu no moiso, woi, yani woli iyaliwoi no niko si nu no?” ");
INSERT INTO amm_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Nosai no puwo nu siyoli mo ta na wiyoninoinuwomo. Nokoyo hani hani toku yasoi isikokai foukai. Nonani nu simai mo na pa foukaiwo, Pasowa koloni mo.” ");
INSERT INTO amm_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ikoki mo; toti mo manokino, nokonu siyoliso lotikino. Na kikino, Isisoyo toku no ikoki no. No monoi no Pasowa koloni na foukaikino. ");
INSERT INTO amm_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Nosai no mo; folosu yasoi; Isiso iyali mo na sa tumoki. ");
INSERT INTO amm_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Pasowa sipo koloni wasi niko manoki mo, Isiso mo na ikoki, “Motuwa na timonukuwo. Moi nokotayo uo nokoni auso na kiyomono taikiyoimo, moi nokotayo ni tono fasimono no.” ");
INSERT INTO amm_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Wiyou, nonani imoso kwaikino mo, mulu mo na kolikaliki. Siyasonuso imalokino, “Noiyo poimo, ya muwoi.” ");
INSERT INTO amm_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ulai na ikoki, “Noko molo tiwoi moi mulumai nokotayo nali no. Noko to ni no, paluwa tuo mo nauso tomoso ni totukolonalonoki no, nonani nokotayo nali. ");
INSERT INTO amm_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Asa, asi asi noko nokolaloni noko siyoli nokota yo mo uo nokoyo na uwomonoinomo, ainonani monoi nokoyo toku kumokaiki, Kotoni pukoso. Wiyou, ta fau, uo nokoni auso kiyomono nokota no moloi uwoyoimo, woi? Atinoyo to ki somiso mo, waliyo na potolo, kiyomono foli monoi pa puwoso.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Amai no si manoki mo, Isiso mo paluwa tuo na anoki, Kotoso wafisu imo na imoki, na foloulu nikoki, siyokutono iyaliso. Na ikoki, “Fuo, ni mo yani au somu.” ");
INSERT INTO amm_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Molo wamo ito iwo mani, na woliyonoki, wafisu imo na imoki. Woliyotiki mo, na sikalokino. ");
INSERT INTO amm_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Na ikoki, Isiso mo, “Ni mo yani nako na. Noko nokolalo komaso noko moi kwalomai monoi kalo unoikuwomo. Yani nakoyo amukono monoi Kotoyo auwolo ukukaiyoimo, noko nokolalo monoi, molo siya posaso wiyoti monoi. ");
INSERT INTO amm_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Motuwa na timonukuwo. Yo mo molo wamo ito iwo mo ti monoi pa sikoiso, asimai mo. Kotoyo asi asi noko nokolalo samukuka tumakimo, nomai noso ti monoi na sikoimo, yo mo.” Aino ikoki. ");
INSERT INTO amm_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nosai no mo; si molosikino. Si molosi uwai; Oli yuso na yoki. ");
INSERT INTO amm_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Nosai no mo; Isiso mo na ikoki, siyokutono iyaliso, “Moi komaso mo namoliyo alosimomonoinuwomo. Ulai afonimaiso? Kotoni puko imoyo mo moi monoi noino na tiyomuko, “Samukuko nokotaso tukolo mo, sipo koloni mo ulolo na.” ");
INSERT INTO amm_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ulai yo ifou auwoniyouwakimo, toku toku manoimo, Kalili asiso, moi foumanoikuwomo.” ");
INSERT INTO amm_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Nosai no mo; Pita mo na imoki, “Ya muwoi, noko komasoyo namoliyo alosimakinimo, yosu mo namoliyo pa alosimo manoikiso.” ");
INSERT INTO amm_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ulai na imoki, “Ya motuwa na timonoki, konoi amoloki siyolimai kokalo mo ti monoi imo yomu somisomai, taumai na yomumosoinimo, “Yo mo Isiso mo sai muwoi.” ");
INSERT INTO amm_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ulai Pitayo amiso na imokaiki, “Yo mo kalo tomasimakinokimo, namoliyo pa alosimo manoikiso.” Siyokutono iyali komaso mo ainonani imoso na imalokino. ");
INSERT INTO amm_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ulai nosai no mo; nuki. Kitosimoniso na fiyamosiya tumokino. Isi siyolo mo Kitosimoni. Ulai Isiso mo siyokutono iyaliso na ikoki, “Nimaino na posiwo. Yo mo Kotowoi imo tolukaso niyano.” ");
INSERT INTO amm_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nosai no mo; tau nokososo na koliyo noki, Pitawoi Yamisowoi Iyonowoi, toisoso koliyo noki. Wiyouwa wiyou, mulu mo na kaloki, mulu mo yau na. ");
INSERT INTO amm_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Na ikoki, Isiso mo, “Yo mo mulu siyoli na tokalomono. Mulu mo yau nali no. Nimaino na posiwo. Na pofoinalikumono siwo.” ");
INSERT INTO amm_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nosai no amunofamoki, asiso ukuwoli tana konoki, Kotowoi imo lukasoki. Na imoki, “Ninaniyo ni uwomonakinomo, yo mo samiyaikiyo monoi tiyo. Waliyo poimo.” ");
INSERT INTO amm_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ulai ti monoi imoki, “Apou yani Apou, nono mo waliyo na tofasimononi. Tukolomono monoi na pa ufiyaiko. Ulai yani muluyoso muwoi, nani muluyosu nali no.” ");
INSERT INTO amm_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nosai no mo; ifou tumoki, siyokutono iyalini auso. Ulololi siso na koka tumoki. Pitaso lusiki, na imoki, “Saimo, hani monoi ulololi totanoni? Yo no koufasofa pa foinalikumononiso? ");
INSERT INTO amm_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ulololi mo noiyo soiwo, Kotowoi imo na polukaso siwo. Wonikaluso Sokolo Nokota Waiyo aiko ainikomo ifoluwaikoma tumoinuwo. Moini muluyosu mo ami ami si monoi louwa fi, ulai auyosu mo ami amiwoi muwoi.” ");
INSERT INTO amm_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nosai no mo; Isiso mo ti monoi utolumanoki, Kotoso. Toku no utolumoki no, nonani imo alinososo na utolumanoki. ");
INSERT INTO amm_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ulai ifou tumoki mo, ti monoi ulololi siso na koka tumoki. Wiyou, ulo molo siyoli uwokoki. Ulai toi no sai, hani imoso imo monoi? ");
INSERT INTO amm_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Tau monoi utolumanoki, Kotoso. Utolumo uwai; ifou na tumoki. Siyokutono noko tauwoiso na ika tumoki, “Ulololi amai na tololiyonokomo si manonuwo. Koma na. Tukolomono ulo mo aumoifaso na toi. Na pukwaiwo, asa, asi asi noko nokolaloni noko siyoli nokota yo mo molo koiyauso aluwai nokoni auso na kiyomono taikiyoimo. ");
INSERT INTO amm_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Na pauwonouluwo, moi soi, na tonukoni. Uo nokoni auso kiyomono nokota mo aumoifaso na tokomi kausimona tumo.” ");
INSERT INTO amm_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Nosai no mo; Isiso mo imo amai polukasiko toloki, lolai siyaso Yutaso mo na tumoki, noko molo tiwoi mulumai nokota mo. Uo noko na koliyoniyo tumoki. Muwo sopo sopowoi awoi na loliyo tumo unukino. Lotu samukuko noko sisiyoliwoi Musini imo sai sisiyoli nokowoi Isolilo nokotalo iyaliwoi, toiyo no iko taikiyokino no, uo noko mo pounu. ");
INSERT INTO amm_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Uo nokoni auso kiyoko nokota, Yutaso, to mo nokoso toku yasoi na ikokaiki, Isiso wiyoti monoi toku yasoi na ikokaiki, “Noko, ya no asisi ifoluwaiyaki no, to mo Isiso. Na pako komi kauwo, atiyaiso na pako samukuyalowo.” ");
INSERT INTO amm_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Yutaso tumoki mo; nosai no Isisoni auso somaiso na amunoki, na imo ifoluwaiki, “Woli, aiyolokomomoko nokota.” Na asisi ifoluwaiki. ");
INSERT INTO amm_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nosai no uo nokoyo imokino ukou, na komikaikino. ");
INSERT INTO amm_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ulai aumoifaso tolokaino nokota mo muwo sopo na kusomoniyouki, nokoni iyoso na tokoso kukiyowaiki, totawoi lotu samukuko nokota siyolini mi ano nokotani iyoso. ");
INSERT INTO amm_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nosai no mo; Isiso mo na ikoki, “Hani monoi tokomi kausimona tumonuwo? Muwo sopo sopowoi awoi no hani monoi tololiyo tumo unumononuwo? Ulai uo nokota, yo no? Yo mo uo nokota muwoi, noko pa tukuwolimoiso. ");
INSERT INTO amm_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Amuwoisai amuwoisai yo mo lotu nu siyoliso piyousikaino fasi manokinukuwo, noko nokolaloso paiyoloko manoki. Ulai pa komi kausimona tumokinuwoso. Ulai Kotoni puko imoyo mo motu monoiso fiyamosi na.” ");
INSERT INTO amm_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ikoki mo; na utukaimokino, siyokutono iyali mo, na uloloki. ");
INSERT INTO amm_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Alu soku mani, Isisowoi tolo tomasimoki. Mafomuso tunowoi atolikai toloki. Uo nokoyo komikaikino mo, ");
INSERT INTO amm_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","tunowoi na kololifolikaiyouki, tuno asoso na lomuki. ");
INSERT INTO amm_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Nosai no mo; Isiso mo totawoi lotu samukuko nokota siyolini auso kiyanokino. Lotu samukuko noko sisiyoliwoi nokotalo iyaliwoi Musini imo sai sisiyoli nokowoi, toiyo ukouniyaikoki, imo lukaso unu monoi. ");
INSERT INTO amm_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pitasu mo aluwaiyaloki, namoli namoli nomasoso na aluwaiyaloki. Totawoi lotu samukuko nokota siyolini nu koki poiso lotiki, polimano noko iyaliwoi yousi tomasika tiki. Ta asi yousa tiki. ");
INSERT INTO amm_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Nosai no mo; lotu samukuko noko sisiyoliwoi nokotalo iyaliwoi, toi mo Isisoni imo kwailuwai noko louwa ikolikalokino. Ulai afonimaiso? Tani imo foli monoi tukolo monoi louwa. ");
INSERT INTO amm_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Noko molopoi nokoyo ifoluwaiyalo unukino, ulai imo mo tomoso muwoi, imo folo foloso lukasalokino. ");
INSERT INTO amm_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Nosai no mo; noko siyai sauki, imo lukaso ifoluwai unukino, na iyamoki, ");
INSERT INTO amm_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Koiyo noino na kwaimokinoki, “Nokoyo ko lotu nu mo asayo na ulaloimo. Namolisai mo ulo tauwoi mo uwai; ti monoi na ko uwaimoimo. Ulai nokoyo pa koinoso.” ");
INSERT INTO amm_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ulai nonani imo no posasokokino mo, no mani, folo folo, ima imoso pa lukaso unukinoso. ");
INSERT INTO amm_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nosai no mo; totawoi lotu samukuko nokota siyoli mo toini molo timai na tolauki, Isisoso na imoki, “Hani monoi pa fowakoniso? Imo na tokosiyokononini. Toini imo mo motu poimo.” ");
INSERT INTO amm_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ulai imo lukasowoi muwoi, pa fowakiso. Ti monoi na imoki, totawoi lotu samukuko nokota siyoliyo mo, “No tomolokimonoki no, a, tani awitono Kolaiso no nono na? A, Isolilo noko koi fasimoka tumo monoi na muwokaikini? Nonayo piyomu.” ");
INSERT INTO amm_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Isiso mo na fowaki, “Nasu, motu nali no. Asa, asi asi noko nokolaloni noko siyoli nokota yo na you kimonoinuwomo. Ami siyoli nokotani nainasai yousiso you kimonoinuwomo. Kumoki kopu molosai amukonoso na kwaimonoinuwomo.” ");
INSERT INTO amm_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Nosai no mo; ikoki mo; totawoi lotu samukuko nokota siyoli mo uo mulu siyoli atolokomoki, totani tuno na kukoliyaikoki, na yomuki, “Tofolo, tani imo kwaimo noko mo tofolo. ");
INSERT INTO amm_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Koma na, Kotoni siyoloso yapoli na alisiyoli. A, yasoi tukwainuwo? Moloi tomulumolokonuwo?” Nosai no tukolo imo na iyamoki, “Kotoso alisiyoli foli monoi na kalumo.” ");
INSERT INTO amm_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nosai no mo; noko siyaiyo sauki, usuwoyo na aso kolalokino. Molo ti mo tunoyo na ufiyaikomokino, nainoyo waso manokino, na alisiyolikino, “Noiyo wasoni? A, Kotoni amimai no nono no sai pakoso? Noiyo wasoni?” Polimano noko iyaliyo mani, na komi kausikino, na waso manokino. ");
INSERT INTO amm_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Pita mo nu asiyofoloso pofu yousiki, kokikokai poiso. Yousiki mo, noni mo na tumosoki, totawoi lotu samukuko nokota siyolini mi ano nukonu na. ");
INSERT INTO amm_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Pitaso na kiya tumoki, ta asi yousiso. Molo amiso na kwaiki, na imoki, “Siyasu mo nonosu na, Nasolito nokota Isisowoi tolo tomasimo nokota na.” ");
INSERT INTO amm_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ulai Pita mo na yomuki, “Nonani imo no tiyomuni no, yo mo sai muwoi, sosoli.” Ainoso yomuki, kokiko itu loti kwasai tola fuki. Nosai no kokaloyo imo na yomuki. ");
INSERT INTO amm_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Nonani mi ano nukonuyo kiki mo, ti monoi yomusoki, aumoifaso si nokoso na ikoki, “Noko to ni mo, to mo Isisoni siyokutono na.” ");
INSERT INTO amm_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ulai ti monoi na yomuki, “Topokoni.” Nosai no mo; namolisaifa aumoifaso si noko, toi mo Pitaso na imokino, “Motu nali no, nono mo Isisoni siyokutono na. Koi mo sai, Kalili asi nokota na, nono mo. Nonayo piyomu.” ");
INSERT INTO amm_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ulai nosai no mo Pita mo auwoloki, na ikoki, “Molo lou, motuwa na timonukuwo, yo mo nonani nokota mo sai muwoi, noko ni tiyamo ununuwo no. Wiyouwa wiyou. Topoko imo yomakimo, Kotoyo na uwokaimonoimo.” ");
INSERT INTO amm_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Yomu uwai; lolai siyaso kokalo mo ti monoi imo na yomuki. Nosai nosu Pita mo ti monoi na mulumolokoki, nonani imo Isisoyo no imoki no, “Kokalo ti monoi imo yomu somisomai, taumai na yomumosoinimo, “Yo mo Isiso mo sai muwoi.” Nosai no na soniki, Pita mo. ");
INSERT INTO amm_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nosai no mo; somosaiyamai imo na lukasokaikino. Lotu samukuko noko sisiyoliwoi nokotalo iyaliwoi Musini imo sai sisiyoli nokowoi noko sisiyoli komasowoi, toi mo Isiso monoi imo na lukasokaikino. Moloyo na konosuwakino, komano nokota siyolini auso na kominalomanokino, Pailatoni auso. ");
INSERT INTO amm_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Nosai no mo; Pailato mo Isisoso na utolumoki, “A, nono no Yuto noko nokolalo samukuko nokota siyoli na?” Na fowaki, “Wuo, no tiyomuni no, ainoso na motu.” ");
INSERT INTO amm_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ulai faumikino, lotu samukuko noko sisiyoliyo. ");
INSERT INTO amm_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","No monoi no Pailato mo ti monoi na utolumoki, “Ulai hani monoi fowakowoi muwoi? Imo na tokosiyokononini.” ");
INSERT INTO amm_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ulai Isisoyo mo nonani imo mani, imo mo fowawoi muwoi. Wiyou, Pailato mo mulumoloko manoki. ");
INSERT INTO amm_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Pasowa popomai mo kalopulo noko siyasonuso pokolali uku taikiyomosikino. Komano nokota siyoliyo noko nokolaloso putolukomosiki, “Noi nokota siya no tokolali unu taikiyo?” ");
INSERT INTO amm_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Isiso uwokaimai nomai no mo, noko, tani siyolo mo Palopaso, to mo kalopulo nuso potolokainoki, komano tukoluwano nokowoi yousi tomasikoki, noko tukuwoli nokowoi na. ");
INSERT INTO amm_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nosai no mo; noko nokolaloyo Pailatoso ukouniyaikokukino, na imokino, “Toku no piyomosikini no, noinoso kalopulo nokota siya na pokolali unu.” ");
INSERT INTO amm_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Nosai no mo; Pailato mo na ikoki, “Noi, woi? A, Yuto noko moi samukukomo nokota siyoliso kiyo taikiyo monoi tiyonuwo?” ");
INSERT INTO amm_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","To mo sai, Isiso monoi foluwalikino mo, lotu samukuko noko sisiyoliyo, no monoi no tani auso kiyoma tumokino, uo imo lukaso unukino. ");
INSERT INTO amm_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ulai lotu samukuko noko iyaliyo noko nokolaloni mulu auwonoulu monoi yokino, Palopasoso kiyo taikiyo monoi, toini auso. ");
INSERT INTO amm_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ulai Pailato mo ti monoi na ikoki, “Yo no moloi tuwo, woi, toso no, Yuto noko nokolalo samukuko nokota siyoli ni tokaluwai manonuwo no?” ");
INSERT INTO amm_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Siyoliso na iyamaloki, “A mokimai na pukou ukou nikomokaiwo.” ");
INSERT INTO amm_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ulai Pailato mo na ikoki, “Ulai hani monoi, hani foli monoi woi?” Ulai siyoliso na iyamalo manoki, “A mokimai na pukou ukou nikomokaiwo.” ");
INSERT INTO amm_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","No monoi no imo kulaliko monoi wiyou yomuki mo, Palopasoso kiyoko taikiyo fuki. Isisosu mo polimano noko iyalini auso na kiyoko taikiyoki, na ikoki, “Suwoi suwoi moloyo na puwasowo. A mokimai na pukou ukou nikomanowo.” ");
INSERT INTO amm_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Nosai no mo; polimano noko iyaliyo Isiso kawiyo tikino, komano nokota siyolini imo lukaso nu siyoli poiso. Polimano noko komaso noko aliyonikokino, na ukouniyaikokuya tumokino. ");
INSERT INTO amm_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Alisiyolikino mo, nakiyaiso tuno itouniyaimoyo na asisikaimokino, siyoli nokotani tuno nali. Yoku mo suwoi suwoi moloso poiyakimo unukino, no monoi no na asisikaikomokino, komuso. ");
INSERT INTO amm_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Na alisiyoli yoluwaikino, imokino, “Woli, Yuto noko nokolalo samukuko nokota siyoli nona kuo.” ");
INSERT INTO amm_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Atou imokino kusomi, komumai na waso manokino, saiso saiso. Usuwoyo na aso kolo manokino. Alokomu losinasi unukino, na molokimo ifoluwaikino. ");
INSERT INTO amm_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Alisiyoliyoluwai uwai; nakiyaiso tuno itouniyaimo asiyonowaikino, totani tunoyoso asisikaimokino. Na kominalomanokino, a mokimai ukou ukou nikomokai monoi na. ");
INSERT INTO amm_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Nu manoki mo, noko mo tumoki. Tani siyolo mo Saimo, Sailini asi nokota, Alikosatowoi Lofasowoi totini apitono na. Nokonuso monoi louwa tumoki. Ulai polimano noko mo totamikino, na imokino, “Oi, a moki ni posokunalomako.” ");
INSERT INTO amm_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nosai no mo; Isiso mo na kaukino, Kalokato yufaso. Moini imosai mo Komu Foli Yu. ");
INSERT INTO amm_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Komama tumokino mo, aliyoli itowoi iwo louwa woliyononikino, iyanoko tolosuwa aliyoli itowoi iwo na. Ulai sikowoi muwoi. ");
INSERT INTO amm_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nosai no mo a mokimai na ukou ukou nikomokino. Tani tuno totai amu wau monoi tomoki lolofayo na somaimo ukukino, noko siyasonuso wau monoi. ");
INSERT INTO amm_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Somosaimai na ukou ukou nikomokaikino, 9 kilomai. ");
INSERT INTO amm_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","A moki puwosai mo noino na kumokaikino, “Yuto noko nokolalo samukuko nokota siyoli.” Nonani foli monoisu tukolokino. ");
INSERT INTO amm_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ulai polamoko nokota ti, toti mani, Isisoni kwasai ukou ukou nikokaikino, a moki tiwoimai. Siya mo nainasai, siya mo sokonisai. ");
INSERT INTO amm_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","No monoi no Kotoni puko imo mo motu na fiyamosiki, ni tiyomukokai no, noino, “Imo kulali nokota komiyai kaluwaiyoinomo.” ");
INSERT INTO amm_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ifou ifou ti liyai noko nokolaloyo palisiyoli yoluwaikaiyo tumomosikino, totaini komuso pokolikaliyo muwaniyo tumomosikino, na pimomosikino, “A, nono no lotu nu siyoli ulalo nokota na? Ulai nono no lotu nu tonofalo no ulo tauwoimai ko uwaimoinimo? ");
INSERT INTO amm_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ulai motu mo, nona amu na pofasi. A mokisai na pofolamiyo kono.” ");
INSERT INTO amm_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Lotu samukuko noko sisiyoliwoi Musini imo sai sisiyoli nokowoi, toi mani, na alisiyolikino. Totai amu ikuwanokino, “Noko nokolaloso pofasiko manoki, ulai tota amusu mo pakoso tofasiso. ");
INSERT INTO amm_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","A, to no Kolaiso na, Kotoyo no muwokaiki no, Isolilo noko nokolalo moi samukumoko monoi no? A mokisai amai poimo tutukaimiyo kono, moi na tukwai sikoni. Amukonakimo, no monoi no mulumolo luwai monoi.” Isisoni kwasai ukou ukou nikokai nokota ti mani, tomoso na alisiyolikino. ");
INSERT INTO amm_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ulo yakomai, ulo mo na lotiki, asi asi komaso mo na folosumono kolokaloki. Ainoso hani upimo tanoki. Nosai no ifou wi taikiyoki. ");
INSERT INTO amm_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Nomai no Isiso mo siyoliso na yomuki, totani imosai yomuki, “Iloi, Iloi, lama sapakotani?” Moini imosai mo noino, “Asani Koto, asani Koto, hani monoi tukwaimonokaini?” ");
INSERT INTO amm_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Aumoifaso si noko siyaiyo Isisoni imoso no kwaimokino mo, na iyamoki, “Na pukwaiwo, Ilaiyaso na taliyoni.” ");
INSERT INTO amm_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nosai no noko siyayo fumanoki, itolowoi iwoso solikaikanoki, somu somuyo. Poni aumai konosuwakokaiki, Isisoni koso na you akaikomoki, iwo siko monoi. Na yomuki, nokoyo, “Awi, na tukwai kikoni. Ilaiyayo amai poimo totokomo uwoya tumo, kawiyo kono monoi.” ");
INSERT INTO amm_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nosai no mo; Isiso mo siyoliso na omoki. Omoki mo; mulu mo futo, yau na kaloki. ");
INSERT INTO amm_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Nomai no mo, tuno siyoli lotu nu siyoli kokiko poiso no kitafoli kukiyokaikino no, nonani tuno na poliyaliyaiko taikiyoki, puwosai na you poliyaliyaikalo konoki, woiso. ");
INSERT INTO amm_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ulai polimano samukuko nokota siyoliyo a moki fokutonosai potoloki. Isisoyo omoso kwaiki. Kaloso kiki mo, na yomuki, “Motu nali, noko to ni mo Kotoni awitono na.” ");
INSERT INTO amm_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Nokolalo siyai mani, posiki. Aluwamaifa siki, na kwaikino. Toi nukonu siya mo Moili, Makotalo asi nukonu, Moili siya mo Yamisofawoi Yusisowoi totini atino. Noni siya mo Salomi. ");
INSERT INTO amm_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Kalili asimai toku paluwaiyalo manokino, pofasiyalo manokino. Nokolalo siyai mani, nokolalo molopoiyo si liyaiki, Yolusolimoso aluwai nokolalo na. ");
INSERT INTO amm_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Isiso kalomai mo mi fou fouko koloni foukai ulo na. Mi fou fouko ulo mo amuwoisai. No monoi no upimoso ");
INSERT INTO amm_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Alimatiyo asi nokota, Yusifo, to mo Pailatoni auso manoki. Yusifo mo Yuto nokota siyoli na, nokotalo iyaliwoi pukouniyaikomosikino. Mulumolo luwai nokota na, Kotoyo asi asi komaso samukuko monoi pofou manoki. Nonani nokota mo kokolomowoi muwoi. Pailatoso na imanoki, “Yo no Isiso yau no waliyo totokomonano, ai unano monoi?” ");
INSERT INTO amm_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ulai Pailato mo mulumoloko manoki mo, na yomuki, “Yasoi kalo, woi?” Polimano iyali samukuko nokotaso aliyoniki, na utolumoki, “Isiso no yasoi kalo?” ");
INSERT INTO amm_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Fowaki, “Nasu, yau na.” Nosai no mo Pailato mo Yusifoso na imoki, “Waliyo na, Isiso yau na panano.” ");
INSERT INTO amm_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Nosai no mo; Yusifo mo kamoso tuno itouniyaimo na ananoki, suo mo muwoni. Isiso yau na kominiyo konoki, kamoso tunoyo na yalokonoki. Noko yau yu asi iso na akaiyanoki, toku yasoi no aikaikino no. Nosai no tomoki tofu siyoliso na lolomotaiki, asi i ufiyaimo monoi. ");
INSERT INTO amm_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Moili, Makotalo asi nukonuwoi Moili siyawoi, Yusisoni atino, totiyo kwai tolo manokino, Isiso yau akaiya tumoso. ");
INSERT INTO amm_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Mi fou fouko ulo mo uwai; nosai no mo, Moili iyali mo sauki. Moili Makotalo asi nukonuwoi, Moili siya Yamisoni atinowoi, Salomiwoi, toi mo aliyoli akanokino, suo mo muwoni, Isiso yauso louwo monoi louwa. ");
INSERT INTO amm_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Nosai no mo; nonani somosaiyamai yasoi, ulo lolaloso wiya liyoki mo, ai unu asi iso monoi nuki. ");
INSERT INTO amm_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Totai amu lukasikuwanokino, “A, tomoki no noiyo lolomotai fasimokoimo, woi, itu loti kolali foli monoi no?” ");
INSERT INTO amm_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Lukasikuwano manokino mo, na you foinalikokino, lolomotaikaiso kikino, pokomosikaiso. Wiyou, ulai tomoki no mo soliyaki siyoli. ");
INSERT INTO amm_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Yau akokai asi i poiso tiki, nosai no mo alu soku na kikino, nainasai yousiso, kamoso tuno sopowoi. Wiyou, na umomalotikoki. ");
INSERT INTO amm_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Nosai no mo na ikoki, “Noiyo umanokomoiwo. Isiso, Nasolito nokota yau mo na tokiya tumonuwo, a mokimai no ukou ukou nikomokaikino no. Ulai yausai ifou yasoi na auwono. Yau amai pa toiso. Akokai kwalososo na pokiwo, uwofa nali. ");
INSERT INTO amm_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ulai totani siyokutono iyaliso na pikanowo, Pita iyaliso, “Isiso mo moi monoi toku yasoi na moi, Kalili asiso, na foukomanonuwo. Nosoniso na pa kiyanowo, totayo toku yasoi no imokaikinuwo no.” Kamoso tunowoi nokota mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ikoki mo; nosai no mo asi i kiya ti nokolalo mo ulai ifou fuki, na uloloki. Wiyou, na kokolokoki, mulu mo na koli kolimuwanoki. Ulai imo lukasikowoi? Imo lukasikanowoi muwoi. Na kokolokoki, no monoi no. ");
INSERT INTO amm_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Mi fou fouko ulo mo uwai; amuwoisai somosaiyamai, nomai no mo Isiso mo yausai na auwoniyouki. Toku mo Makotalo asi nukonu Moiliso na kosa tumoki. Nonani nukonu mo toku Isiso totayo nano siyawoi popuwa amiyaikiyoko waisoki. ");
INSERT INTO amm_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Kosa tumoki mo; Moili mo Isisoso aluwai noko nokolaloso na ikanoki, yausai ifou auwoniyou aino imo mo. Wiyouwa wiyou, nonani noko nokolalo iyali mo mulu mo yau yau, na sosonuno siki. ");
INSERT INTO amm_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Na ikoki, Moili mo, “Isiso mo yausai auwono, yo mo yasoi na ki.” Ulai tani imoso kwaisokino mo, pa mulumolo luwaisokinoso. Na isokino, “Topokoni.” ");
INSERT INTO amm_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Nosai no mo; Isisoso aluwai noko ti mo nokonusai utukaimokino, na manokino. Molomai Isiso mo na koka tumoki, au mo folo alosimokaiki. ");
INSERT INTO amm_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nosai no mo; ifou na manokino, molomai ki imo ikanokino, siyokutono iyaliso. Ulai toi mo totini imo mani, kwaikowoi muwoi, pa mulumolo luwaikokinoso. Na ikokino, “Topokonuwo.” ");
INSERT INTO amm_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Nosai no mo; namolisai mo, Isiso mo na koka tumoki, noko molo siya 11 nokoso. Koloni no simai koka tumoki, na ikikoki, “Hani monoi pa mulumolo luwaimononuwoso?” Ulai afonimaiso? Toi mo kukamokokai, yausai auwoniyou imoso pa kwaikokinoso. ");
INSERT INTO amm_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Na ikoki, “Kotoni imo itouniyaimo mo na pa lukasikalo liyaiwo, asi asi noko nokolalo komasoso. ");
INSERT INTO amm_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Noko mo Kotoso mulumolo luwai somiso mo, nonani foli monoi na uwokaiyoimo. Noko mo Kotoso mulumolo luwaiyakimo, na samiyaikiyoimo, nokoyo iwoso uluwayakimo, Kotoso muwokainoni monoi. ");
INSERT INTO amm_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Mulumolo luwaimono nokota, tota mo hani hani mulu ifolaluwawoi mi na ano liyaiyoimo, noko nokolaloni molo timai. Hani hani, popuwa amiyaikiyoko, asani amiyo. Hani hani, imo lukasalo, imo folo folo imosai. ");
INSERT INTO amm_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Hani hani uowoi nuwo mo kulolakinomo, pa tukuwoliyoinoso. Aliyoli ito iwo koiyauso sikakinomo, pa uwokaikoiso. Ulai ai ai nokoso nainoyo kulolakinomo, waliyo na soimo, ai mo futo.” Isiso mo aino na ikoki, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Isiso Siyoli mo imo ikiko uwai; Kotoyo kumokiso na kawiyo yoki. Kotoni nainasai na yousa yoki. ");
INSERT INTO amm_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Nosai no siyokutono iyali mo asi asiso nu liyaiki, Kotoni imo na posasokalokino. Siyoli Nokotayo fasikalo manoki, no monoi no mulu ifolaluwawoi mi na analo liyaikino, noko nokolaloni molo timai. Na iyamaloki, “Motu nali, toini imo mo.” ");
INSERT INTO amm_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Tiyofila siyoli, koini molo timai no fiyamosokoki no, ainonani monoi aino imo noko molopoi mo kulalokino. ");
INSERT INTO amm_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Afonimaiso imo muwoi, Kotoni imo lukasikalo nokoyo no posasoko wiyolumokalokino no, totaini molo timai tokusai no pokokalo manokino no, nonani imosu na kulalokino, noko molopoiyo mo. ");
INSERT INTO amm_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Yo mani, nonani imo folosai monoi putolukalo manoki. Tokusai atiyaiyaso pukwaiko ki manoki. No monoi no mo yo mo ima imo na tokulunoninoki, ");
INSERT INTO amm_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","nonayo saino monoi, nokoyo no aiyolomokini no, no mo imo mo motu nali no. ");
INSERT INTO amm_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Hiloyo Yutiya noko nokolalo samukukomai lotu samukuko nokota mo tolokainoki, tani siyolo mo Sokolaiya. Apiya iyaliwoi lotu mi pano fasiko manoki. Tani noni mani, lotu samukuko nokota siyolini alisaitono, Alononi alisaitono na. Tani siyolo mo Ailisopoi. ");
INSERT INTO amm_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Toti mo molo itouniyaimoso aluwaikino, Kotoni molo timai. Imo komaso paluwai manokino, Noko Siyoliyo no wiyolukoki no. Uo imo no moloi yomu monoi, toti monoi no? ");
INSERT INTO amm_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ulai aliwoi muwoi, toti mo. Ailisopoi mo anapo nali no. Noko mo nokotalo yasoi, noni mani, noniya yasoi. ");
INSERT INTO amm_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Nosai no mo; Sokolaiya iyaliyo lotu miso ana tikino. Ano manokino mo, Sokolaiya mani, lotu mi analoki, Kotoni molo timai. ");
INSERT INTO amm_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Lotu mi analo manoki mo, lotu samukuko noko totaini moloyo tomoki lolofayo somaimokino, Noko Siyolini nu poi mi anononi nokota muwokai monoi, inoso wotiwoi momotola ti monoi. No monoi no Sokolaiyaso muwokino. ");
INSERT INTO amm_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Inoso woti momotola tiki. Momotolomai Yuto noko nokolalo molopoiyo asiyofolosai fu ukouniyaiko siki, Kotowoi imo lukaso siki. ");
INSERT INTO amm_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Nosai no mo; Sokolaiya mo lotiki mo; Noko Siyolini kumoki nokotaso na kiki, inoso woti kotisoko naina ausaimisai toloso. ");
INSERT INTO amm_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Kumoki nokota toloso kiki mo, wiyou, na umanomoki, na kokolomoki. ");
INSERT INTO amm_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ulai kumoki nokotayo mo na imoki, “Sokolaiya, noiyo kokolomoi. Koto mo nani imo yasoi kwaimoni. Nani noni Ailisopoi mo alu na kiyoimo. Tani siyolo mo Iyono pa kaluwai. ");
INSERT INTO amm_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ulukukumoso na, na molokimoinimo. Alu kimai mo noko nokolalo molopoiyo mani, molokiyoinomo. ");
INSERT INTO amm_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Alu mo Koto Siyolini molo timai mo noko siyoli toloimo. Molo wamo ito iwo pa siko manoiso. Itolowoi iwo pa siko manoiso. Atinoni nomolisai mo Kotoni Mulu Itouniyaimo Nokotayo mulu amimokaiyoimo. ");
INSERT INTO amm_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Isolilo noko nokolalo molopoi ifou kolisoimo, Kotoni auso si monoi, totaini Noko Siyolini auso. ");
INSERT INTO amm_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kotoni mulu lukasiko nokota Ilaiya komiyai toloimo, mulu mo tomoso, ami siyoliwoi. Toku tumoimo, Siyoli Nokota monoi. Ta noinomo apitono iyaliyo mulu alosokoinomo, awitono iyali monoi mulu ukoimo. Ta noinomo imo kulali noko iyali mani, mulu alosokoinomo, mulumoloko itouniyaimoinomo, mulu ititouni noko komiyai. No monoi no Siyoli Nokotaso na foumo soimo.” Kumoki nokotayo mo ainoso na imoki, Sokolaiyaso. ");
INSERT INTO amm_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Nosai no mo; Sokolaiya mo kumoki nokotaso na imoki, “Moloi monoi woi? Motu poimo. Yo no moloi saino monoi? Yo mo nokotalo yasoi. Noni mani, noniya na.” ");
INSERT INTO amm_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Kumoki nokotayo mo na fowaki, “Yo mo Kopoliyoilo. Yo mo Kotoni molo timai totolokainomoi. Totayo na imono taikiyo, imo itouniyaimo posaso wiyononi monoi. ");
INSERT INTO amm_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ulai na pukwai. Nono mo waliyo pa tomulumoloko unumononiso. No monoi no ko mo pu, imo pa lukaso manoiniso, ainoso hani fiyamosiyoimo, ya ni posasoko no. Kotoyo yomukaiyakimo, yani imo mo motu na tumoimo.” Kumoki nokotayo aino na imoki. ");
INSERT INTO amm_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Sokolaiyayo tu tolo manoki mo, noko nokolalo mo fu foumo si manoki, mulumoloko si manoki, “Hani totu ano tolomoi, woi?” ");
INSERT INTO amm_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Nosai no mo; asiyofoloso ifou lofuki, Sokolaiya mo. Imo lukasowoi muwoi, ko mo pu. No monoi no noko nokolalo mo sai, Kotoyo haniso wiyononiki, lotu nu poiso. Imo lukasowoi muwoi, nainoyo wiyolukaloki, ko mo pu. ");
INSERT INTO amm_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Nosai no mo; lotu mi ano uwai; ifou manoki, totani asiso. ");
INSERT INTO amm_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Nosai no mo; tani noni Ailisopoi mo muwoliwoi. Amu mo naino siyaiso tu toloso manoki, pa pamusiyofu manokiso. ");
INSERT INTO amm_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Yomusoki, “Noko Siyoliyo na fasimono. No monoi no noko nokolaloni molo timai auwosimomono mo uwofa.” ");
INSERT INTO amm_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Nosai no mo; Ailisopoi mo amu toufowoi muwoliwoisomai, nonani amumai Koto mo kumoki nokotaso imo taikiyoki, Kopoliyoiloso. Na imo taikiyoki, “Kalili asiso na pamukono, Nasolito nokonuso, ");
INSERT INTO amm_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","maputo nukonuni auso.” Nonani nukonu mo nokoso isokaikino. Noko siyolo mo Yusifo, Toiwini alisaitono na. Maputo nukonu, tani siyolo mo Moili. ");
INSERT INTO amm_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Nosai no mo; nonani kumoki nokota mo na amukonoki, na isa konoki, “Woli Moili, nono kuo, Kotoyo siyoliso na tofasini, Noko Siyoliyo mo. Na totolo fasi manoni.” ");
INSERT INTO amm_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Isoki mo; na umanosoki. Mulumolokalo manoki, “Hani imo, woi?” ");
INSERT INTO amm_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nosai no mo; kumoki nokota mo na isoki, “Moili, noiyo kokolomoi. Kotoyo tomolokimoni, na tofasini. ");
INSERT INTO amm_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Na pukwai, nono mo muwoliwoi na toloinimo, alu nokokai na kiyoinimo. Tani siyolo Isiso na pa kaluwai. ");
INSERT INTO amm_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","To mo noko siyoli na toloimo. Kota Kotoni awitono kaluwaiyoinomo. Koto Siyoliyo yasoi muwokaiki, noko nokolalo samukuko monoi, tani aniyopatono Toiwi komiyai. ");
INSERT INTO amm_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Yokoponi alisaitono iyali na samukuko manoimo, aniyopa poi poi. Tani ami mo uwaimowoi muwoi, na samukuko manoimo, aniyopa poi poi.” ");
INSERT INTO amm_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Nosai no mo; Moili mo Kotoni kumoki nokotaso na imoki, “Yoso no moloi fiyamosimomonoimo, woi? Yo mo nokowoi nukonu muwoi.” ");
INSERT INTO amm_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nosai no mo; kumoki nokota mo na fowasoki, “Kotoni Mulu Itouniyaimo Nokotayo na amukonoimo, nani auso. Kota Kotoni amiyo na fasiyoinimo. No monoi no alu na kiyoinimo. Itouniyaima nokota na toloimo, Kotoni awitono na kaluwaiyoinomo. ");
INSERT INTO amm_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Na pukwai, nani amino Ailisopoi mani, alu na kiyoimo. Noniya na, ulai lolai mo muwoliwoi yasoi. Anapo nukonu pokaluwaiso manokino, ulai lolai mo tani muwoliwoiso amu mo toufowoi uwai yasoi. ");
INSERT INTO amm_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Koto mo hani hani komaso mo waliyo tiyalomanomoi.” Kumoki nokota mo aino na isoki, Moiliso. ");
INSERT INTO amm_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Nosai no mo; Moili mo na imoki, “Waliyo na, yo mo Siyoli Nokotani mi anononi nukonu. To mo aino na yo unumonoimo, nonayo no tiyomuni no.” Nosai no mo; kumoki nokota mo utukaisoki. ");
INSERT INTO amm_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Nosai no mo; Moili mo puwotolosoki, somaiso manosoki, yu nukutai asiso amusiyoyoki, Yuto nokoni nokonuso. ");
INSERT INTO amm_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Amusiyoyoki mo; nosai no mo Sokolaiyani nuso lotisoki, Ailisopoiso na isa tiki, “Woli, nono kuo.” ");
INSERT INTO amm_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ailisopoi mo Moilini imoso kwaisoki mo, alufa mo nomoli poiso naino ikuwa ilomaniuluki. Nosai no Kotoni Mulu Itouniyaimo Nokotayo mulu na amisoki. ");
INSERT INTO amm_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Siyoliso na isoki, Moiliso, “Nani siyolo niya tokaluwaiyalonoki, nokolalo komaso koiso tosouwaikomomokoni. Nani alu mani, nomoli poiso no tanokaino no, tani siyolo mani, niya tokaluwaiyalonoki. ");
INSERT INTO amm_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Woli kuo, yoso no moloi woi? Yani Siyoli Nokotani atino nonayo no moloi monoi tokimona tumoni? ");
INSERT INTO amm_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Na pukwai, yo mo nani ko naso kwaimonoki mo, alu mo yani nomoli poiso moloki, naino fonawoi ilomaniulu. ");
INSERT INTO amm_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Koto Siyoliyo no imokini no, waliyo na mulumoloko unukini. No monoi no na pomoloki. Ulai afonimaiso? Na tiyomuni, “Siyoli Nokotayo no yomukaiki no, noinoso na yo unumonoimo.” Ailisopoi mo ainoso na isoki, Moiliso. ");
INSERT INTO amm_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Nosai no mo; Moili mo na yomusoki, “Wiyouwa wiyou, Noko Siyoliso na tokisosomi, yo mo. ");
INSERT INTO amm_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Yani mulu mo moloki saso, Kotoso na tomolokimo, yani samiyaikiyo kiyo nokotaso mo. ");
INSERT INTO amm_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Yo mo tani mi anononi nukonu. Yani amiyo no ulai moloi ano monoi? Yo mo afonimaiso nukonu na. Totasu mo waliyo mulumoloko unumonoki. Lolaisai ainoso ainoso noko nokolaloyo iyamo unumonalo manoinomo, “Kotoyo noinomo na molokisowumo.” ");
INSERT INTO amm_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Koto mo ami nokota siyoli, siyoliso na yo unumonoki. Tani siyolo mo itouniyaima itouniyaimo. ");
INSERT INTO amm_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Noko mo auwosiwaiyakinomo, toi monoi mulu ukoimo. Suomoso monoiso na fasikoimo. Alisaimi mani, ainoso nasu, ainoso ainoso aniyopa loloi loloi. ");
INSERT INTO amm_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Tani nainoyo mo mi siyoli tanomoi. Noko sisiyoli si mulu nokoso tamiyaikiyoko taikiyomoi, totaini muluyoso aluwaikalo nokoso. ");
INSERT INTO amm_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Noko nokolalo samukuko noko sisiyoli usainiyaikaloki. Ta noinomo afonimaiso noko mo noko sisiyoli na, totani molo timai mo. ");
INSERT INTO amm_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Tiya uwoko noko nokolaloso hani hani ititouni tonikomoi, touwai si monoi. Ilolu molopoiwoi nokoso pa tonikomoiso, afonimaiso tokiyoko taikiyo. ");
INSERT INTO amm_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Tani noko nokolaloso na tofasikomoi, Isoliloni alisaitono iyaliso. Amai tomulumoloko uku, mulu tuku, suomoso monoiso tofasikomoi. ");
INSERT INTO amm_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ainoso toku ikokaiki, moini aniyopa iyaliso, Apolofamowoi totani alisaitono iyaliwoiso fasikalo monoi, ainoso ainoso aniyopa loloi loloi.” Moili mo ainoso na yomusoki. ");
INSERT INTO amm_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Nosai no mo; Moili mo Ailisopoiwoi tolo tomasiso manoki, amu mo tauwoi. Nosai no ifou manosoki, totani asiso. ");
INSERT INTO amm_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Nosai no mo; sisomai mo Ailisopoi mo alu na kiki. Alu nokokai na kiki. ");
INSERT INTO amm_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Imo mo maliyaliki mo, asi tomoso nokowoi nako siyamai nokowoi, toini auso kolo kolomo liyaiki, Siyoli Nokotayo mulu uso monoi, suomoso monoiso fasiso monoi. Wiyou, toi mani, na moloki fasisokino. ");
INSERT INTO amm_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Ulo nano ti mo uwai; nosai no mo au tuno tokosiyaima tumokino, alufani au tunoso. Apitononi siyolo kaluwai monoi louwa, Sokolaiya. ");
INSERT INTO amm_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ulai atinoyo mo ikoki, “Wiyou aino muwoi, tani siyolo mo Iyono na tokaluwaikoni.” ");
INSERT INTO amm_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ulai na isokino, “Ulai alufani alaitono mo Iyono siyolo tolowoi muwoi.” ");
INSERT INTO amm_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nosai no mo; apitonoso ukou ukou niyalokino, “Moloi tokaluwaini, alu no?” ");
INSERT INTO amm_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Sokolaiya mo a pokamono ano monoi yoki, nosai no na kumoki, “Tani siyolo mo Iyono.” Wiyou, na mulumoloko manokino. ");
INSERT INTO amm_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kumoki mo; lolai siyaso ko mo fololikoki. Imo mo na lukasauki, Kotoni siyolo kaluwaiyaloki. ");
INSERT INTO amm_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Wiyouwa wiyou, asi siyamai noko nokolalo mo kokolokoki. Ainonani monoi aino imo posasokalokino, Yutiya yu asimaiso. Wiyou, asi mo imo saso. ");
INSERT INTO amm_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Nonani imo kolo kolomo liyaiki mo, noko nokolaloyo mulumolokokaikino, iyamaloki, “Alu no siyolimai moloi toloimo, woi?” Aino iyamaloki. Ulai afonimaiso? Alu mo Noko Siyolini amiwoi na toloki. ");
INSERT INTO amm_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Nosai no mo; Kotoni Mulu Itouniyaimo Nokotayo aluni apitono Sokolaiyani muluso amimoki. Amimo manoki mo, Sokolaiya mo Kotoni imo na posasokoki, noino, ");
INSERT INTO amm_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Koto Siyolini siyolo tokaluwaiyalokoni, Isolilo noko moini Kotoni siyolo mo. Tani noko nokolalo moi fasimoka tumoki, ifou kolisomoko monoi. ");
INSERT INTO amm_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","To mo ami nokotaso na muwokaiki, tani mi ano nokota Toiwini alisaitonoso. Nonani nokotayo noinomo moi mo na samiyaikiyo monoi. ");
INSERT INTO amm_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ainonani monoi toku posasokokino, Kotoni mulu lukasiko noko ititouni iyaliyo. ");
INSERT INTO amm_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Noino na posasokokino, “Uo noko monoi samiyaikiyoinomo, mulu atolokomo uku nokoni ami monoi.” ");
INSERT INTO amm_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Koto mo moini aniyopa iyali monoi mulu ukuki, suomoso monoiso na fasikoki. Na auwoloki, totani moloso wiyotiki. Nonani imo itouniyaimo to no ulai moloi fufolikomo monoi? Amai na tomulumolokomoi. ");
INSERT INTO amm_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Na auwoloki, moini aniyopa Apolofamoso, na imokaiki. No imokaiki mo, moi monoi mani, na yomu unumokokaiki, ");
INSERT INTO amm_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","uo nokoni nainosai koponi imoko monoi. Ulai moloi kokolokomomoko monoi? Tani mi ano mo waliyo. ");
INSERT INTO amm_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Asiso amai sinonomai mulu ititouniyawoi si monoi yomu unumokokaiki, molo itouniyaimoso aluwai monoi, totani molo timai. ");
INSERT INTO amm_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Yani alu, nono monoisu timonoki, Kotoni mulu lukasiko nokota nokoyo na kaluwaiyoinimo, Kota Kotoni mulu posasoko nokota na. No mo afonimaiso muwoi, nono mo Siyoli Nokota monoi toku manoinimo, molo yono foumalo monoi. ");
INSERT INTO amm_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Kotoni noko nokolaloso aiyolokoinimo, toiyo saino monoi, samiyaikiyo si monoi. Molo koiyau monoi imo mo futo mo, na samiyaikiyoinomo. ");
INSERT INTO amm_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Moini Koto mo mulu siyoliso tunumokomoi, suomoso monoiso tofasimokomoi. Noinoso na yoimo. Kumokini saponiyo wi kolokomomoka tumoimo. ");
INSERT INTO amm_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Folosumai si nokoso fupiniyaimo kolokoimo, kolikali moloso aluwai nokoso mani, fupiniyaimo kolokoimo. Na kuloli ilomanimokoimo, mulu tomoki moloso aluwai monoi.” Sokolaiya mo aino na yomuki. ");
INSERT INTO amm_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Nosai no mo; alu mo komu mo puwoso puwoso puwoso; siyoli yasoi. Tani mulu mani, amimaloki. Nosai no mo; nu somiso asiso na tolokainanoki. Tolo manoki tolo manoki tolo manoki; Isolilo noko nokolaloyo kiya tumo liyaikino. ");
INSERT INTO amm_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Nosai no mo; Lomo nokota siyoli, Sisi Okasota mo yomukaiki, noko nokolaloni siyolo siyolo i monoi. Nokoso iko taikiyoki, nonani imo alomano monoi, asi asi komaso asiso. ");
INSERT INTO amm_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ni mo totawoi siyolo siyolo i. Nomai no mo komano nokota Kwailiniyayo Siliya asi samuku fasi toloki. ");
INSERT INTO amm_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","No monoi no mo, totaini asi asiso nu liyaiki, noko nokolalo komaso mo. Komano noko iyaliyo toini siyolo siyolo i monoi nu liyaiki. ");
INSERT INTO amm_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Yusifo mani, na manoki. To mo Toiwini alisaimi, tani nakosai na. No monoi no Nasolito nokonuso utukaimoki, Kalili asimai. Yutiya asiso monoi manoki, Toiwini aniyopa nukutai Pitolifimoso. ");
INSERT INTO amm_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Moili mo na aluwaiki, toku no muwosokaikino no, no ikokaikino no. Totini siyolo siyolo i monoi na manokino. Moili mo muwoliwoi yasoi. ");
INSERT INTO amm_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Nosai no mo; nonani asi mo amai tolo manokino mo, siso puwo aumoifaso na potanoki. ");
INSERT INTO amm_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Imu alu nokokai na kiki, tunoyo na yalokonoki, polomokoni sosono pokili poiso na akaiki, ulololi monoi. Nu nu mo noko saso ukouniyaikokai, noko molopoi, no monoi no polomokoni nuso na sisoki. ");
INSERT INTO amm_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nomai no mo, sipo koloni samukuko noko mo nokonu kwamai siki. Amoloki amoloki samukuko manokino, totaini sipo koloni mo. ");
INSERT INTO amm_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Nosai no mo; Siyoli Nokotani kumoki nokota mo toini auso na amukonoki. Saponi siyoli na fupiniyaimo kolokoki, Siyoli Nokotani saponi mo. Wiyou, siyoliso na kokolokoki. ");
INSERT INTO amm_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Na ikoki, “Noiyo kokolokomoiwo. Na pukwaiwo. Imo itouniyaimo na toposasoko wiyononinukuwo. Noko nokolalo kwaiyakinomo, siyoliso moloki soimo, noko nokolalo komaso mo. ");
INSERT INTO amm_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Lolaimai mo noni mo alu na ki, Toiwini aniyopa nukutaimai. To mo Kolaiso Siyoli, noko no mo Kotoyo no muwokaiki no, Isolilo noko moi fasikoma tumo monoi. Ta noinomo samiyaikiyoinuwomo. ");
INSERT INTO amm_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Noino na pa kiyanowo. Moi mo alu mo tunoyo yalokonokai na kiyoinuwomo. Polomokoni sosono pokili poiso toi.” Kumoki nokota mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Nosai no mo; kumoki noko iyali mo lolai siyaso na ukouniyaika konoki, sipo koloni samukuko nokoni auso, molopoisu na. Wolitononi auso ukouniyaikokuya konokino. Kotoso kisosomiyalokino, na iyamoki, ");
INSERT INTO amm_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Kotoni siyolo na tokaluwaiyalokoni, Kota Kotoni siyolo mo. Asi asi noko nokolalo mo mulu tomokiso soimo, noko nokolalo Kotoyo no tomolokikalo no.” Aino na iyamoki. ");
INSERT INTO amm_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Nosai no mo; Kotoni kumoki noko mo kumokiso ifou yoki. Utukaikiyo yokino mo; sipo samukuko noko mo ikuwanokino, “Soiwo, Pitolifimo nokonuso na tonukoni, nonani hani fiyamosi na tokiyanokoni, Koto Siyoliyo no posasoko wiyomoko no.” ");
INSERT INTO amm_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Nosai no mo; somaiso na nuki. Yusifo koli ikolikalokino, Moiliwoi aluwoi. Toti yousiso na koka tikino. Alu mo polomokoni pokili poiso tanoki. ");
INSERT INTO amm_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Alu ki uwai; nosai no mo, alu aino imo na posasokokino, alu monoi aino imo no kwaikino no, nonani imo na lukasikokino. ");
INSERT INTO amm_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Noko nokolalo mani, imo kwaikokino, sipo samukuko nokoyo no ikalokino no. Na mulumoloko manokino. ");
INSERT INTO amm_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ulai Moili mo nonani imo komaso mulumolokokai manoki, tani mulu poiso. ");
INSERT INTO amm_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Nosai no mo; sipo samukuko noko mo ifou nuki, Kotoni siyolo kaluwaiyalo manokino. Afonimaiso pa kisosomikinoso, totaini molo tiyo yasoi na kikino, imo na kwaimokino, kumoki nokotayo no ikoki no, no monoi no. ");
INSERT INTO amm_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Nosai no mo; ulo mo nano ti mo uwai; aluni au tuno tokosiyaimokino mo, tani siyolo mo Isiso na kaluwaikino. Atinoni nomoli poiso tanowoi muwoi, kumokiso amai na, nomai no kumoki nokotayo kaluwaiya konoki, tani siyolo mo Isiso. ");
INSERT INTO amm_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Nosai no mo; alu mala nu siso mo uwai; Yusifo noko ti Moiliwoi mo alufa kaukino, Yolusolimo nokonu siyoliso. No mo afonimaiso muwoi, Musini ami imoyo tiyomuko, atino noko ti alufawoi ititounikaiyano monoi, Kotoni molo timai. No monoi no Koto Siyolini auso kaukino. ");
INSERT INTO amm_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Ainonani monoi Koto Siyolini imo amiyo tiyomuko, noino, “Imu alalo mo atino iyaliyo koko mo, nonani alalo mo Noko Siyoliso muwokokainoniwumo.” ");
INSERT INTO amm_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Alufa mo Koto Siyolini auso kawiyo tikino mo, uo ti utunina tikino. No mani, afonimaiso muwoi, ainonani monoi Koto Siyolini imo amiyo tiyomuko, noino, “Anomu ti pa akononiwo. Uwofawo, ufoiyo ti mo waliyo.” ");
INSERT INTO amm_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Ulai noko mo Yolusolimo nokonumai toloki. Tani siyolo mo Simiyo. Molo itouniyaimoso aluwai nokota, lotu aluwai nokota na. Isolilo noko hamukuko nokotaso foumo toloki. Kotoni Mulu Itouniyaimo Nokotayo tani muluso tanoki. ");
INSERT INTO amm_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Nonani nokotayo toku yasoi posaso wiyononiki, na imoki, “Nono mo somaiso pa kaloiniso. Wiyou, toku Noko Siyolini Kolaisoso kiyoinimo, noko no mo toku no muwokaiki no, Isolilo noko moi fasikomo monoi.” Aino imoki. ");
INSERT INTO amm_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Nosai no mo; Kotoni Mulu Itouniyaimo Nokotayo noinomo Simiyo mo lotu nuso lotiki. Lotiki mo; atino apitono noko ti mo alufa Isiso na kawiyo tikino, aniyopa imo amiyo yo unu monoi. ");
INSERT INTO amm_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Nosai no mo; kawiyo tikino mo; Simiyo mo alufa na kausiwaisoki, Kotoni siyolo kaluwaiyaloki, noino na imoki, ");
INSERT INTO amm_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Siyoli Nokota, toku no imonokaikini no, motu yasoi na tumo. Lolai mo kalomono mo waliyo. Nani mi anononi nokota yoso na pimono taikiyo, mulu tomokiso tano monoi. ");
INSERT INTO amm_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Asani molo tiyo yasoi na ki, samiyaikiyo kiyo nokotaso. ");
INSERT INTO amm_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Aino na yokaikini, noko nokolalo komasoyo ki monoi. ");
INSERT INTO amm_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Saponi siyoli komiyai na. Noko nokonu nokoso fupiniyaimo kolokaloimo, toi saino monoi. Sainakinomo, nani Isolilo noko moini siyolo siyolo kolalimokoinomo.” Simiyo mo ainoso na imoki, Kotoso. ");
INSERT INTO amm_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nosai no mo; atino apitono mo mulumoloko manokino. Simiyoyo no posasoko unuki no, nonani monoi na mulumoloko manokino. ");
INSERT INTO amm_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Mulumoloko manokino mo; nosai no Simiyo mo ikoki, “Kotoyo na tofasinuwo.” Nosai no aluni atino Moiliso na isoki, “Na pukwai, nani alu ni mo Kotoyo yasoi muwokaiki. Ta noinomo Isolilo noko siyai usukunalo konoimo, mulumolo luwai somiso monoi. Siyaisu mo pa usukunalo konoiso, Kotoni moloso na aluwaiyoinomo. Noko nokolaloni molo timai na toloimo, Kotoni mulu wiyotiyoimo. Ulai noko molopoiyo imo kulaliyoinomo. ");
INSERT INTO amm_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","No monoi no totani molo timai noko nokolaloni mulu na fiyamosokoimo. Nokoyo uwokaiyakinomo, wiyou, nono mo mulu na kaloinimo, muwo sopoyo komiyai tukoliyonoinimo.” Simiyo mo aino na isoki, Moiliso. ");
INSERT INTO amm_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Kotoni mulu lukasiko nukonu mani, na tolosoki, tani siyolo mo Ana, Fanuwiloni atoki, Asaini alisaimi. To mo noniya wai yasoi. Toku mo noko na auki. Noko kwamimai mo aisamu nano siya saso tolosoki. ");
INSERT INTO amm_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Nosai no noko mo kaloki, yau. Sawi toloso manoki toloso manoki toloso manoki, ainoso tani aisamu mo 84. Lotu nuso pa utukaimo manokiso, Kotowoi aumoifaso toloso mulu siyoli yoki. Koloni au au potolosomosiki, Kotowoi polukaso manoki. No monoi no pomolokimo manoki, Kotoso, ulo ulo amoloki amoloki. ");
INSERT INTO amm_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Simiyoyo alufa komo tolimai to mani, tumosoki, Kotoso na imoki, “Wafisu.” Nosai no mo, alufa aino imo polukasikalomosiki, Yolusolimo noko nokolalo siyaiso. Kotoso no foumo siki no, ifou koliso monoi, toiso posaso wiyotiyalo manoki. ");
INSERT INTO amm_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Noko Siyolini imo amiyo komaso yo uwai; ulai nosai no mo Kalili asiso ifou nuki, totini nukutaiso, Nasolitoso. ");
INSERT INTO amm_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Nosai no mo; alu mo komu mo puwoso puwoso puwoso; alu itouniyaimo na. Mulu mo iwoi saso. Kotoni amiyo na pofasi manoki. ");
INSERT INTO amm_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Isisoni atino apitono noko ti mo aisamu siyasonuso pomanomosikino, Yolusolimo nokonu siyoliso. Pasowa koloni wasi popomai pomanomosikino. ");
INSERT INTO amm_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Isiso mo siyoli sowiyafa, aisamu mo 12, nosai no mo; to mani, nonani aniyopa moloso aluwaiki, atino apitono noko tiso na aluwaikoki, Yolusolimo nokonu siyoliso. ");
INSERT INTO amm_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Nosai no mo; koloni wasi popo mo uwai; ifou manokino. Ulai Isiso alu soku, to mo ifou manowoi muwoi, Yolusolimoso amai na toloki. Atino apitono noko ti mo sai muwoi. Piyomukino, “Na taluwaimokowo.” ");
INSERT INTO amm_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Kiwoi muwoi, piyomukino, “Noko nokolalo siyaiso taluwaikalowo.” No monoi no ulo siyamai manalokino. Ulai kiwoi muwoi. Nosai no moloso ikoliyalokino. Siyokutono iyaliwoi nako siyamai nokowoi, toini auso ikoliyalokino. ");
INSERT INTO amm_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Ikoliyalokino ikoliyalokino, ulai kiwoi muwoi. Yolusolimo nokonuso ifou manokino, na ikoliyalokino. ");
INSERT INTO amm_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Na ikoliyalo manokino. Nosai no amoloki tiwoi mo uwai; na kiya tumokino, lotu nu siyoli poiso yousikainoso, aiyoloko noko sisiyolini mulumai yousikainoso. Imo kwaiko yousiki, na utolukaloki. ");
INSERT INTO amm_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Noko nokolaloyo tani imo kwaimokino mo, na kufaukoki, “Sai siyoli no moloi ano, woi, imo no fowako no?” ");
INSERT INTO amm_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Toti mo kikino mo, toti mani, na kufaukoki. Atinoyo mo na imoki, “Yani alu, nono no koti no hani monoi uwomokoni? Apono koti mo mulu mo yau yau, nono ikoli manonoki mo.” ");
INSERT INTO amm_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ulai na fowakoki, “Hani monoi ikolimonalo manonuwo? Moti mo sai pakoso, yo mo Apouni nuso niya tiyousikaino.” ");
INSERT INTO amm_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ulai toti mo sai muwoi, imo folosai imo mo, nonani imo no ikoki mo. ");
INSERT INTO amm_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ulai nosai no mo; ifou na aluwaikoki, Nasolito nokonuso. Totini imo saiso saiso pukwaikomosiki. Atinosu mo nonani haninoi na mulumolokokaiki, tani mulu poiso. ");
INSERT INTO amm_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Nosai no mo; Isiso mo komu puwoso puwoso; siyoli yasoi. Tani mulu mani, iwoi na, sai siyoli pano manoki. Kotowoi noko nokolalowoi mani, pomolokimo manokino. ");
INSERT INTO amm_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Lomo nokota siyoli Sisi Taipiliyayo samukukomai, asi asiso aisamu 15 posamukuko manoki, nosai no mo; Kotoyo Iyonoso na imo taikiyoki, tani imo lukasikalo monoi. Komano nokota Ponatiya Pailatoyo Yutiya asi samuku fasi toloki. Komano nokota siyoli Hiloyo Kalili asi samuku fasi toloki. Auwatono Filipo mani, komano nokota siyoli, Ituliya asiwoi Tolakunaiti asiwoi samukuko fasi toloki. Laisaniyayo Apilini asi samuku fasi toloki. Anaso noko ti Kaiyofawoi, totiyo lotu samukuko noko sisiyoli ti tolokino. Nomai no mo, Sokolaiyani awitono Iyono mo nu somiso asiso toloki. Tolo manoki mo, Kotoyo na imo taikiyoki, tani imo lukasikalo monoi. ");
INSERT INTO amm_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","No monoi no mo, Yotano iwo aumoifaso manoki, nonani asimai liyaiyaloki. Kotoni imo lukasikaloki, noko nokolaloso, na ikoki, “Mulu na palosokomowo. Alosokomakinuwomo, iwoso uluwakomoikuwomo, Kotoso muwokomokainoni monoi. No monoi no molo koiyau monoi imo mo futo.” Aino na ikaloki. ");
INSERT INTO amm_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ainonani monoi Kotoni mulu lukasiko nokota Aisaiyayo na kumokaiki, pukoso, noino, “Nokoyo imo siyoliso yomoimo, nu somiso asimai. Na iko toloimo, “Molo koiyauso na putukaimowo, molo itouniyaimoso na pa aluwaiwo. Noko Siyoli mo tumoimo. Na pofoumowo. ");
INSERT INTO amm_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tani molo mo itouniyaimo saso. Mukuwoli moloso amimoimo. Yu sisiyoli molo mo ki molo komiyai na soimo. Yu lolofa molo mani, tomoso na soimo. Molo mo kolukuwa kolukuwa, nosai no mo fou foukoimo. Molo mo tomoki saso, nosai no folofoliyafoumoimo. ");
INSERT INTO amm_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Nosai no mo, noko komaso nokoyo samiyaikiyo kiyo nokotaso kiyoinomo, Kotoyo no imo taikiyaki no.” Aisaiyayo aino na kumokaiki. ");
INSERT INTO amm_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Noko nokolalo molopoi ti liyai manoki ti liyai manoki ti liyai manoki, Iyonoyo iwoso uluwako monoi, noko nokolalo molopoi. Na ikoki, “Hani monoi tulolonuwo? Nuwo komiyai louwa tulolonuwo, ta monoi. Noiyo no imokinuwo, ulolo no? Kotoyo mulu atolokomo unu monoi ulai hani monoi tulolonuwo? ");
INSERT INTO amm_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Noko mo mulu alosimo uwai, molo itouniyaimoso na aluwaiyumo. Moiyosu mo pomulumolokonuwo, “Mulu alosokomomoko mo wiyou tiyamonoki.” Piyamonuwo, “Koini aniyopa mo Apolofamo, no monoi no Kotoyo mo pa amiyai kiyomokoisowo.” Ulai ya timonukuwo, aino muwoi. Molo koiyauso aluwaiyakinuwomo, na amiyaikiyoinuwomo, Apolofamoni alalo siyai mo tomokiso ufosikoimo, moi kwalomai monoi. ");
INSERT INTO amm_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Muwo mo a folomai mo na totolokaino. A komaso a mo a wamo si somiso mo, iko taikiyoimo, taso na fofoukoimo.” Siyokawi imo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Nosai no mo; noko nokolalo mo utolumalokino, “Koi no moloi tiyonoki, woi?” ");
INSERT INTO amm_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Noino na fowakoki, “Noko mo pau tuno tiwoi nokota, siya mo afonimai nokotaso anoninumo. Koloni mani, noinoso nali no.” ");
INSERT INTO amm_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Takiso muwoni i noko mani, iwoso uluwako monoi tiki. Iyonoso na imokino, “Aiyolokomomoko nokota, koi no moloi tiyonoki, woi?” ");
INSERT INTO amm_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ikoki, “Komanoyo no timonuwo no, noinoso na pa i manowo, muwoni sisiyoli noiyo i watiyoiwo, noko nokolaloso mo.” ");
INSERT INTO amm_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Nosai no mo; polimano noko mo imokino, “Koi no moloi tiyonoki?” Na ikoki, “Nokoso noiyo uwokoiwo, muwoni iwaiko monoi mo. Noiyo faumi ifoluwai ukoiwo. Momaini mi ano foli muwoni mo koma na.” ");
INSERT INTO amm_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Nosai no mo; noko nokolalo mo mulu auwonoulu liyaiki, mulumolokalokino, iyamoki, “Nakomo Iyono mo Kolaiso na, noko no mo Kotoyo muwokaiki, Isolilo noko koi fasimoko monoi.” ");
INSERT INTO amm_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ulai Iyono mo na ikoki, “Yo mo iwoso tuluwakomonukuwo. Namolisai noko siya mo na tumoimo. Tani ami mo siyoli. Yani ami mo koufasu. Yo no moloi fasi monoi? To mo Kotoni Mulu Itouniyaimo Nokotaso na imo taikiyoimo, momaini mulu poiso. Ta komiyai fofouko taikiyoimo, momaini mulu kopokoiyau mo. No monoi nosu muwokomo kaininoinuwomo. ");
INSERT INTO amm_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Totani sawolo nainomai na tokomi toliso, paluwa tuo u iyouwalo monoi. No monoi no fulomuyo mo kukumo ufosifoliyafoumoimo, paluwa u ititounisu mo ifou salo kono liyaiyoimo. Nosai no mo; no mo uwai; totani paluwa u ititouni mo isikokaiyoimo, totani nuso. Kukumo mo taso utoimo, aniyopa poi poi taso.” ");
INSERT INTO amm_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Iyono mo aino na ikoki. Ainoso ainoso pikikomosiki. Imo itouniyaimo posasoko wiyotimosiki, noko nokolaloso. ");
INSERT INTO amm_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ulai Iyono mo komano nokota siyoli Hiloso ikimoki, auwatononi noni Hilotiya foli monoi. Hani hani kopokoiyau foli monoi mani, ikimoki. ");
INSERT INTO amm_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Wiyou, Hilo mo molo kopokoiyau aluwaiko nokota nali. Iyono mo ikimoki mo; siya hani mani, yoki, ikimo foli monoi kalopulo nuso na kiyokaiki. ");
INSERT INTO amm_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Hiloyo Iyonoso kalopulo nuso kiyo somisomai Iyono mo noko nokolalo molopoi iwoso puluwako manoki. Isiso mani, na uluwaki, muwokai monoi. Iwoso uluwa uwai; Isiso mo Kotowoi imo lukaso tola yoki, nomai no mo kumoki mo na poliyaliyaiki. ");
INSERT INTO amm_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Kotoni Mulu Itouniyaimo Nokota mo na amukonoki. Anomu komiyai amukonoso na kwaiki, tani auso amukonoso. Kumokisai ko na mo koloma konoki, na yomuki, “Nono mo yani alu na. Yo mo nono mulu mo siyoli. Yani mulu mo waliyo, nono monoi mo.” ");
INSERT INTO amm_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Nosai no mo; Isiso mo totawoi misu na anoki. Tani aisamu mo 30. Noko nokolaloyo piyamoki, Yusifoni awitonowo. Yusifo mo Hilaini awitono. ");
INSERT INTO amm_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Hilai mo Motatoni awitono. Motato mo Liwaini awitono. Liwai mo Milikaini awitono. Milikai mo Yanoini awitono. Yanoi mo Yusifoni awitono. ");
INSERT INTO amm_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yusifo mo Matotiyasoni awitono. Matotiyaso mo Aimosoni awitono. Aimoso mo Nafumoni awitono. Nafumo mo Isolaini awitono. Isolai mo Nakaini awitono. ");
INSERT INTO amm_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nakai mo Matoni awitono. Mato mo Matotiyasoni awitono. Matotiyaso mo Soimini awitono. Soimi mo Yusikoni awitono. Yusiko mo Yotani awitono. ");
INSERT INTO amm_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yota mo Yuwanoni awitono. Yuwano mo Lisani awitono. Lisa mo Silapopiloni awitono. Silapopilo mo Siyalotiyaloni awitono. Siyalotiyalo mo Nilaini awitono. ");
INSERT INTO amm_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nilai mo Milikaini awitono. Milikai mo Ataini awitono. Atai mo Kusamoni awitono. Kusamo mo Ilomotamoni awitono. Ilomotamo mo Ilani awitono. ");
INSERT INTO amm_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Ila mo Yosuwani awitono. Yosuwa mo Iliyosoni awitono. Iliyoso mo Yulimoni awitono. Yulimo mo Motatoni awitono. Motato mo Liwaini awitono. ");
INSERT INTO amm_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Liwai mo Simiyoni awitono. Simiyo mo Yutoni awitono. Yuto mo Yusifoni awitono. Yusifo mo Yunamoni awitono. Yunamo mo Iliyakimoni awitono. ");
INSERT INTO amm_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Iliyakimo mo Miliyani awitono. Miliya mo Minani awitono. Mina mo Matotani awitono. Matota mo Natanoni awitono. Natano mo Toiwini awitono. ");
INSERT INTO amm_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Toiwi mo Yasini awitono. Yasi mo Opoitoni awitono. Opoito mo Puwasoni awitono. Puwaso mo Salomononi awitono. Salomono mo Nasononi awitono. ");
INSERT INTO amm_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nasono mo Aminotaponi awitono. Aminotapo mo Atominoni awitono. Atomino mo Anaini awitono. Anai mo Hisolunoni awitono. Hisoluno mo Pilisoni awitono. Piliso mo Yutoni awitono. ");
INSERT INTO amm_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yuto mo Yokoponi awitono. Yokopo mo Isakoni awitono. Isako mo Apolofamoni awitono. Apolofamo mo Tilani awitono. Tila mo Nafoloni awitono. ");
INSERT INTO amm_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nafolo mo Silukoni awitono. Siluko mo Liyuni awitono. Liyu mo Pilikini awitono. Piliki mo Iponi awitono. Ipo mo Silani awitono. ");
INSERT INTO amm_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sila mo Koinanoni awitono. Koinano mo Afakosani awitono. Afakosa mo Siyoimoni awitono. Siyoimo mo Nowani awitono. Nowa mo Lamikoni awitono. ");
INSERT INTO amm_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamiko mo Mitusilani awitono. Mitusila mo Inokoni awitono. Inoko mo Yalitoni awitono. Yalito mo Mohalolini awitono. Mohaloli mo Kinanoni awitono. ");
INSERT INTO amm_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kinano mo Inoni awitono. Ino mo Sitoni awitono. Sito mo Atamoni awitono. Atamo mo Kotoni awitono. ");
INSERT INTO amm_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Isisoni mulu mo ami saso, Kotoni Mulu Itouniyaimo Nokotayo amimokaiki. Yotano iwoso utukaimoki, ifou manoki. Manoki manoki manoki; nosai no mo, Kotoni Mulu Itouniyaimo Nokotayo na kalumaniki. Nu somiso asiso na kalumaniyaloki. ");
INSERT INTO amm_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Ulo ulo amoloki amoloki 40 mo nosoni tolokainoki. Tolokainoki mo, Sokolo Nokota Waiyo louwa paini ifoluwaiya tumomosiki. No tolo manoki mo, Isiso mo nowoi muwoi, nosai no tiyawoiso toloki. ");
INSERT INTO amm_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Nosai no Sokolo Nokota Wai mo ima tumoki, na imoki, “Nono mo Kotoni awitono mo, na piyomu, tomoki ni mo tuo komiyai wiyonumo.” ");
INSERT INTO amm_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Isiso mo na fowaki, “Kotoni puko imo na tiyomuko, “Tuo saso mo wiyou, noko mo pakoso si itouniyaimoiso.” ");
INSERT INTO amm_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Nosai no mo; Sokolo Nokota Waiyo kawiyo yoki, yu nukutaiso. Lolai siyaso na ku wiyononi taikiyoki, asi asi mo woiso ku tolono liyai. ");
INSERT INTO amm_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Isisoso na imoki, “Asi asi komaso ya na niyoikimo, asayo noinomo nani nasu wosuwoimai soimo. Wiyou, asi asi ititouni nali. Ni hani hani komaso mo yaninoi nali. Yo mo nokoso ni mulu monoi yakimo, na niyoimo. ");
INSERT INTO amm_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Losiyaiko unumonakinimo, komaso ni ku si liyai no, no mo nani nali no, nonayo imonakinimo, “Asani noko siyoli.” ");
INSERT INTO amm_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Nosai no mo; Isiso mo na imoki, “Kotoni puko imo mo na tiyomuko, “Koto mo nani Noko Siyoli. Totasosu na pa molokimomoi, tani mi na pa anomoi.” Aino na tiyomukokai, puko imo mo.” ");
INSERT INTO amm_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Nosai no mo; Sokolo Nokota Waiyo mo kawiyo tiki, Yolusolimo nokonu siyoliso. Lotu nu siyoli nu komumai na kawiyo yoki, na imoki, “Nono mo Kotoni awitono mo, isaino na pofolamo. ");
INSERT INTO amm_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Ulai afonimaiso? Kotoni puko imoyo na tiyomuko, “Koto mo tani kumoki nokoso iko taikiyoimo, “Na pofasiya konowo. Atiyaiso na posamuku itouniyaima konowo.” ");
INSERT INTO amm_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ninoino mani, na tiyomuko, “Totaini nainomai komikaiyoinimo. Tomokimai pa kitolomoiniso.” ");
INSERT INTO amm_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ulai Isiso mo na fowaki, “Kotoni imo mo noinoso na, “Nani Kotoso noiyo imo kiyoi. To mo nani Noko Siyoli.” ");
INSERT INTO amm_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Sokolo Nokota Wai mo aini ifoluwaiyalo uwai; nosai no mo Isisoso utukaimoki, mulumolokoki, “Awi, amuwoi tinoso ulai aini ifoluwai kiyoimo.” ");
INSERT INTO amm_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Nosai no mo; Kotoni Mulu Itouniyaimo Nokotani amimai ifou manoki, Isiso mo, Kalili asiso. To tumo monoi aino imo na kolo kolomo liyaiki, Kalili asi komaso mo. ");
INSERT INTO amm_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Saiso saiso paiyolokalo manoki, lotu nu lolofa poiso. Tani siyoloso kaluwaiyalokino, noko nokolalo komaso mo. ");
INSERT INTO amm_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Nosai no mo; Isiso mo Nasolito nokonuso manoki, alumai no toloki no, nosoni na. Mi fou fouko ulomai lotu nufa poiso lotiki. Saiso saiso aino piyomosiki, no monoi no. Na tolokaina tiki, Kotoni puko imo lukasiko tola tiki. ");
INSERT INTO amm_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Nosai no Aisaiyayo kulu puko akononikino, Kotoni mulu lukasiko nokotayo kulu puko mo. Pokomosikoki mo, imoso kokoki, no tiyomuko no, noino, ");
INSERT INTO amm_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Noko Siyolini Mulu Itouniyaimo Nokotayo mulu tamimomono. Noko Siyoli mo na muwokaimonoki, imo itouniyaimo lukasikalo monoi, hani hani sonosoni somiso nokoso. Na imono taikiyoki, samiyaikiyo imo posaso wiyoti monoi, kalopulo komiyai si noko nokolaloso. Molo kau kau noko mani, na foinalikoinomo. Hani haniyo uwoko noko mani, na samiyaikiyoinomo. ");
INSERT INTO amm_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Na imono taikiyoki, posasoko monoi, Noko Siyoliyo noko nokolalo fasika tumo monoi.” Aino tiyomuko. ");
INSERT INTO amm_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Isiso mo nonani imo lukasiko uwai; nosai no mo, puko ufiyaikoki, ifou akononiki, lotu nu samuku nokotaso. Na yousa konoki. Amiso na kwai siki, lotu nufaso si noko komasoyo. ");
INSERT INTO amm_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nosai no mo; na ikoki, “Lolai mo Kotoni imo ni mo motu na fiyamosi. Imo mo yasoi kwainuwo.” ");
INSERT INTO amm_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Ikoki mo; noko nokolalo mo iyamo unukino, noko itouniyaimo. Mulumoloko manokino, tani imo mo ulukukumoso, no monoi no. Na iyamoki, “Moloi woi? Yusifoni awitono, woi?” ");
INSERT INTO amm_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nosai no mo; Isiso mo na ikoki, “Nakomo siyokawi imo imonoinuwomo, noino, “Woli tokota, nona amu na pitouniyaimokai.” Nakomo imo folosai mani, imonoinuwomo, noino, “Kopanaumo nokonumai mulu ifolaluwawoi mi anomosi imo koloma tumoki. Tomoso na pa yo, nani asimai ni mo.” ");
INSERT INTO amm_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Nosai no ulai na ikoki, “Motuwa na timonukuwo. Kotoni mulu lukasiko nokotaso pa tokisosominoso, nokonu tomoso nokoyo. ");
INSERT INTO amm_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Imo motu na timonukuwo. Kotoni mulu lukasiko nokota Ilaiya tolomai susawi nokolalo molopoi si liyaiki, Isolilo asimai. Ulai sa mo ufiyaimokaiki, pa potumo manokiso. aisamu mo tauwoi, amu mo toufowoi. No monoi no isini aliyoli mo auwonouluwoi muwoi, samo samokokaiki. Tiya siyoli puwoko manoki, Isolilo noko nokolalo komaso mo. ");
INSERT INTO amm_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ulai Isolilo sawi nukonu fasiso monoi Ilaiya mo Kotoyo pa imo taikiyokiso. Salifato sawi nukonu fasiso monoi na imo taikiyoki, noko nokonu nukonu Saito asimai no tolosoki no, to fasiso monoi imo taikiyoki. ");
INSERT INTO amm_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kotoni mulu lukasiko nokota Ilaisa tolomai mani, ainoso na. Uluoyo uwokaikokai noko molopoi si liyaiki, Isolilo asimai. Ulai toi mulumai noko tolosuwakowoi muwoi, uluo uwokaikokai mo amai. Noko nokonu nokota saso tolosuwaki, Namano mo, Siliya nokota na.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nosai no mo; mulu atolokoki. Lotu nufa poiso si noko komaso noko mo nonani imo kwaimokino mo, mulu siyoliso na atolokomo unukino, ta topi. ");
INSERT INTO amm_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Auwonouluki, na amiyaikiyokino, asiyofoloso. Nokonu asiyofoloso fu kiyokino. Nokonu mo yu nukutaiso you tanokainoki. Yu koliso kiyokino. Na louwa fakukiyokino. ");
INSERT INTO amm_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ulai noko nokolalo ukouniyaikokai mulumai manoki, na utukaikoki. Yasoi. ");
INSERT INTO amm_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Nosai no mo; Kopanaumo nokonuso amukonoki, Kalili asimai. Amukonoki mo; nosai no mi fou fouko ulomai noko nokolaloso aiyoloka tiki. ");
INSERT INTO amm_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Na kufaukoki, totayo aiyoloko monoi. Moloi monoi woi? Isiso mo mulu ifolaluwawoi nali no, no monoi no aiyoloko itouniyaimoki. ");
INSERT INTO amm_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Popuwa koiyauyo uwokaikai nokota mo nosoni yousikainoki, lotu nu poiso. Nosai no mo siyoliso na yomaloki, Isisoso na imoki, ");
INSERT INTO amm_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Oi, Isiso, Nasolito nokota, hani monoi totumo unumokoni? Hani monoi tuwokaimoka tumoni? Yo mo sai, nono mo Kotoyo imo taikiyo nokota nali.” ");
INSERT INTO amm_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ulai na ikimoki, “Wosu woso, nokoni auso na putukaimo.” Imoki mo; noko mo popuwayo fakukiyo taikiyoki, asiso usukunoki, noko nokolaloni molo timai. Ulai uwokaiwoi muwoi, tani auso na utukaimoki. ");
INSERT INTO amm_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Wiyouwa wiyou, noko nokolalo mo na mulumoloko manokino, totai amu na ikuwanalokino, “Hani imo, woi? Wiyouwa wiyou, ami mo siyoli, to mo. Popuwa kopokoiyauso iko mo, na utukaimono.” ");
INSERT INTO amm_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Nosai no Isiso aino imo kolo kolomo liyaiki, ninani asi asi komaso noko nokolaloni auso. ");
INSERT INTO amm_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Nosai no mo; Isiso mo yasoi, lotu nufasai lofuki. Saimoni nuso manoki, na lotiki. Saimoni amokitono mo ai na potasoki, au momono siyoli na. No monoi no Isisoso na imokino, “Na pofasisa tumo.” ");
INSERT INTO amm_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nosai no mo; aumoifa tola tumoki, imo amiyo ai mo tolosuwasoki, au momono mo futo. Lolai siyaso auwonisiyouki, koloni ta na notiki. ");
INSERT INTO amm_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Nosai no mo; ulo mo ku poki, hani hani ai ai noko mo Isisoni auso kiyokoma tumo liyaikino, siyokutono iyaliyo. Nainoyo kulolaloki mo, na ititounikaiyaloki. ");
INSERT INTO amm_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Popuwawoi noko mani, ititounikaiki, noko nokolalo molopoi. Popuwa iyaliyo utukaikalokino mo, siyoliso imalokino, “Nono mo Kotoni awitono.” Ulai Isiso mo alukikoki, na ikikoki, “Wosu woso, yani siyolo noiyo kaluwai wiyotiyaloiwo.” Toi mo sai, ni mo Kolaiso, noko no mo Kotoyo muwokaiki, Isolilo noko fasiko monoi. ");
INSERT INTO amm_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Amuwoisai posasi Isiso mo auwoniyouki, nokonuso utukaimoki, noko somiso asiso manoki. Noko nokolaloyo ikoliyalokino, na kiya tumokino. Utukaiko monoi louwa alukimokino. ");
INSERT INTO amm_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ulai na ikoki, “Yo mo Kotoni imo itouniyaimo na toposasokalomoi, Kotoyo moi samukukomo monoi aino imo. Nokonu nokonuso mani, toposasoko wiyotiyalo. Nonani mi ano monoi na imono taikiyoki, Kotoyo mo.” ");
INSERT INTO amm_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Nosai no mo; imo polukasika timosiki, lotu nu lolofa poiso, Yutiya asimai. ");
INSERT INTO amm_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Nosai no mo; iwo toku iloso toloki, Kinisali iwo toku ilomai. Isiso mo Kotoni imo lukasiko toloki. Wiyou, noko molopoiyo tani auso fiyokaimo siki, Kotoni imo kwaimo monoi. ");
INSERT INTO amm_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Imo lukasiko tolo manoki mo, ayou tiso kokoki, upoimai takoso. La i nokosu mo ayou tiso utukaikokino, la imo uluwakanokino. ");
INSERT INTO amm_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nosai no mo, ayouso folamiyo tiki, Saimoni ayouso. Na imoki, Saimoso, “Upoisai putukaimiyonofamo.” Ayouso yousikaina konoki, noko nokolaloso na aiyolokoki. ");
INSERT INTO amm_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Imo lukasiko uwai; nosai no mo Saimoso na imoki, “Iwo utaimai na palomoi. La imo na pokukiyoko taikiyo, la i monoi.” ");
INSERT INTO amm_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Na imoki, Saimoyo, “Noko Siyoli, amoloki siyoli kukiyoko taikiyalo manonoki, ainoso posasi. Mi mo siyoli, ulai la mo iwoi muwoi. Nonayosu timononi mo, waliyo na tokukiyoko.” ");
INSERT INTO amm_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","No monoi no la imo kukiyokokino. Kukiyokokino mo; wiyou, la molopoi na ikino, molopoi nali. La imo poliyaliyaikaloki. ");
INSERT INTO amm_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Siyokutono iyaliso aliyonikokino, ayou siya nokoso, la i fasika tumo monoi. Tiki mo; wiyouwa wiyou, ayou ti poiso isikokaiyalokino, ko kowaso, la molopoi molopoi. Na louwa alotolokoki, ayou ti no mo. ");
INSERT INTO amm_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Saimo Pita mo ainoso kokoki mo, Isisoni aumai losiyaikanoki, na imoki, “Noko Siyoli, na putukaimono. Yo mo molo koiyauso aluwai nokota.” ");
INSERT INTO amm_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Aino imoki, ulai afonimaiso? Na mulumoloko manokino, Saimo iyali mo, la molopoi i monoi. ");
INSERT INTO amm_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Sipitini awitono noko ti mani, kufaukoki, Yamisowoi Iyonowoi, Saimoni siyokutono noko ti. Ulai Isiso mo Saimoso na imoki, “Noiyo kokolomoi. Lolai mo laso tini. Noinoso na, noko nokolaloso na kolisaloinimo, Kotoni auso ti monoi.” ");
INSERT INTO amm_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Imoki mo; nosai no mo; ayou ti koki ilomanokino, upoiso, hani hani komaso utukaikiyoukino, Isisoso na aluwaikino. ");
INSERT INTO amm_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Nosai no mo; nokonu siya mo tola tumoki. Uluoyo uwokaikai nokota mo na tolokainoki, au mo uluo saso. Isiso tumoso kwaiki mo, na ukuwoli tana konoki, na imaloki, “Noko Siyoli, yo no waliyo titouniyaimomononi?” ");
INSERT INTO amm_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Nosai no mo; Isiso mo nainoyo na akaikomoki, na imoki, “Yo mo waliyo na tiyomu, noko itouniyaimo na totoloni.” Imoki mo; lolai siyasu uluo mo na kokamokoki. ");
INSERT INTO amm_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Amiso ikimoki, “Noinaninoi aino imo noiyo ikaloi. Nani au mo lotu samukuko nokotaso na powiyononinano. Kotoso pakononinano, nonani hani mo toku Musiyo no yomuki no. No monoi no noko mo sai, nani uluo mo kokamokokai, noko itouniyaimo na totoloni.” ");
INSERT INTO amm_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ulai Isisoyo noko ititounikai aino imo maliyaliyaloki, nokonu nokonuso. No monoi no mo noko nokolalo molopoiyo imo kwaima tumo liyaikino, ai ai ititounikai monoi ti liyaiki. Noko molopoi, wiyou nali no. ");
INSERT INTO amm_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Isisosu mo noko somiso asiso pomanomosiki, Kotowoi imo polukaso nimosiki. ");
INSERT INTO amm_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Nosai no mo; Isiso mo ulo siyamai aiyoloko toloki, noko nokolaloso. Nokotalo iyali mani, siki, Falisi moloso aluwai nokowoi Musini imo aiyoloko nokowoi. Toi mo ti liyaiki, Kalili asisaiwoi Yutiya asisaiwoi Yolusolimo nokonu siyolisaiwoi ti liyaiki, sa tumoki. Isiso mo Noko Siyolini amiwoi toloki, ai ai noko ititounikai monoi. ");
INSERT INTO amm_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Nosai no mo; noko siyai mo naino fona nomolikomokai nokota mo molo tokosimai na sokuniyo tumokino. Nu poiso louwa kiya tikino, Isisoni aumai akai monoi. ");
INSERT INTO amm_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ulai itu loti mo noko nokolalo saso. Ulai moloi kiya ti monoi, Isisoni auso no? No monoi no nu komu tofuso na yoki, kolaliyai molosai. Nu komu mulumai na ulalalo konokino. Isiso mo woiso ku toloki. Nu komu ulalo uwai; naino fona nomoli nokota mo molosai ku kiyalo konokino, molo tokosimai. Noko nokolaloni au mulumai wosu woso ku kiyalo konokino, Isisoni fokutonomai na akaiyalo konokino. ");
INSERT INTO amm_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Akaiyalo konokino mo; Isiso mo toini mulu poiso kokoki, totaso mulumolo luwaiso. No monoi no nomolikomokai nokotaso na imoki, “Woli, yo mo imo mo futo, nani molo koiyau monoi imo mo.” ");
INSERT INTO amm_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ulai nokotalo iyali mo totai amu imo lukasikuwanokino. Musini imo sai sisiyoli nokowoi Falisi moloso aluwai nokowoi, totai amu imo lukasikuwanokino, na iyamoki, “Ni no noi, woi, Koto Siyoliso ni talisiyoli no? Ulai noko siyayo no mulu koiyau no moloi afoliwai monoi? Koto saso mo sai, mulu kopokoiyau saloso monoi.” ");
INSERT INTO amm_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Isiso mo toini mulu mo sai, na ikoki, “Hani monoi tomulumolokonuwo? ");
INSERT INTO amm_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Yo mo nokoso mulu koiyau afoliwai monoi imo mo, moiyo pimononuwo, “Topokoniwo.” Ulai ya imakimo, “Pauwoniyou, na poliyaiyalo,” nosai no moloi imono monoi topokoni? ");
INSERT INTO amm_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Asi asi noko nokolaloni noko siyoli nokota yo mo mulu ifolaluwawoi nali, mulu kopokoiyau saloso uwoko ami mo yapoli, yo mo. Ya towiyononinukuwo, moiyo saino monoi.” Ikoki mo; naino fona nomolikomokai nokotaso na imoki, “Na timonoki, pauwoniyou, nani molo tokosi palomako, nuso na pomoi” Aino na imoki, tani ami mo noko nokolaloso wiyoti monoi, mulu kopokoiyau saloso uwoko ami mo. ");
INSERT INTO amm_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","No monoi no mo, lolai siyaso noko nokolaloni molo timai mo na auwoniyouki, nomolikomokai nokota mo. Totani tano molo tokosiwoi na sokunalomakoki, nuso na manoki. Manoki mo, Kotoni siyoloso na kaluwaiyaloki. ");
INSERT INTO amm_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kufaukaloki, noko nokolalo mo, Kotoni siyoloso kaluwaiyalokino. Kokolo mulu saso, na iyamoki, “Lolai mo moi mo folo na kikoni.” ");
INSERT INTO amm_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Nosai no mo; Isiso mo manoki manoki, takiso muwoni i nokotaso na kiya tumoki, takiso nuso yousikainoso. Tani siyolo mo Liwai. Na imoki, “Kuku, yoso na paluwaimono.” ");
INSERT INTO amm_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Imoki mo; hani hani komaso utukaikiyouki, na amufuki, Isisoso na aluwaiki. ");
INSERT INTO amm_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Nosai no mo; Liwai mo koloni wasi monoi foumanoki, Isisoso no ni monoi, totani nuso. Takiso muwoni i noko kopokoiyau noko molopoiwoi noko siyaiwoi no fasika tumokino. ");
INSERT INTO amm_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ulai nokotalo iyali mo amuwaso aliya tumokino. Falisi moloso aluwai nokowoi toini sai sisiyoli nokowoi, Musini imo sai na, toi mo amuwaso. Isisoni siyokutono iyaliso ikokino, “Hani monoi tono fasikonuwo, takiso muwoni i noko kopokoiyauwoi molo koiyauso aluwai nokowoiso no?” ");
INSERT INTO amm_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Nosai no mo; Isiso mo na fowakoki, “Ai ai somiso noko mo tokotani auso pa tonumoiso. Wiyou. Ai ai noko saso na tonumoi, tani auso mo. ");
INSERT INTO amm_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Yo no noko ititouni nokoni mulu alosoko monoi tumo noiyo? Noko kopokoiyau nokoni mulu alosoko monoi na tumo.” ");
INSERT INTO amm_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Nosai no mo; noko sisiyoli mo Isisoso na imokino, “Iyononi siyokutono iyali mo koloni au au tosimosino, Kotowoi imo lukaso mano monoi. Falisi nokoni siyokutono iyali mani, tomoso na. Nani siyokuno iyalisu mo aino muwoi, na tonoko manono.” ");
INSERT INTO amm_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Nosai no mo; Isiso mo na ikoki, “Toi mo noni kauso nokotani siyokutono iyali komiyai. Tolo fasikomaiso, nomai no koloni wasi popo na totoi. Koloni au au no moloi si monoi? Tolo fasikomaiso koloni au au pa tosiso. ");
INSERT INTO amm_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ulai namolimai mo nonani nokota mo noko siyaiyo komi kausiyakinomo, siyokutono iyalini aumai mo uwofa toloimo, nomai no koloni au au na soimo.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Siyokawi imo ti monoi na ikoki, “Tuno tonufuwaso no moloi tokosano monoi, toku mi tunoso moloi topolimo monoi? Aino piyo mo, tuno tonufuwa mo na puwokai. Nonani tuno tonofalo tokosanofa monoi mani, no mo tomoso muwoi, tokumi tuno komiyai muwoi, fofamo. ");
INSERT INTO amm_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ninoino mani, nokoyo pa tiyomoiso, molo wamo ito iwo tonofalo mo tokumi koloni tunomai soluki muwoi. Nokoyo ainonani piyo mo, molo wamo ito tonofalo mo tokumi tuno mo na popoliyaliyaikaiyo kono, asiso posolitolomo. Koloni tuno no mani, na popoliyaliyai taikiyo. ");
INSERT INTO amm_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Noko mo molo wamo ito tonofalo iwo mo koloni tuno tonofalomaiso wolikumo. ");
INSERT INTO amm_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Tokumi molo wamo ito iwo siko nokota, to mo molo wamo ito iwo tonofalo mo sikowoi muwoi, wiyou tiyomu. To mo tiyomu, “Tokumi mo waliyo na tosiko.” Aino ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Mi fou fouko ulo siyamai mo isi mulumai molomai nu liyaiki, Isiso iyali mo, paluwa tuo sosono isimai. Nu liyai manoki mo; siyokutono iyali mo paluwa u na tofukalokino, nainomai totunokokino, na nokokino. ");
INSERT INTO amm_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ulai Falisi moloso aluwai noko mo na ika tumokino, “Mi fou fouko ulomaisu mo ausu. Ulai hani monoi tiyonuwo?” ");
INSERT INTO amm_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Nosai no mo; Isiso mo na fowakoki, “Ulai moi no Toiwi aino imo pa kwainuwoso? Ulai pa kokonuwoso, nonani puko imo no? Toiwi iyali mo tiya kolikaliki mo, ");
INSERT INTO amm_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","nomai no mo paluwa tuo iya tiki, Kotoni lotu nu poiso, paluwa tuo no mo, Kotoso muwokokainonikai yasoi. Nonani paluwa tuo mo afonimai noko mo au au. Lotu samukuko nokoyosu noko mo waliyo. Toiwi mo lotu samukuko nokota muwoi, ulai na noka tiki. Lotu samukuko nokotayo niki, paluwa tuo mo. Siyokutono iyaliso mani, nikoki, Toiwiyo mo. Na nokokino. ");
INSERT INTO amm_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Asi asi noko nokolaloni noko siyoli nokota, asa mo mi fou fouko ulo na tosamuku.” Aino ikoki, mi fou fouko ulo monoi. ");
INSERT INTO amm_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Mi fou fouko ulo siyamai lotu nufa poiso aiyoloka ti ki. Naino nomoli nokota mo na tu yousikainoki, nainasai naino mo nomolimokaiki. ");
INSERT INTO amm_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Nokotalo iyalisu mo Isisoso molo amiso kwaikino, Falisi moloso aluwai nokowoi Musini imo sai sisiyoli nokowoiyo. Na mulumolokokino, “Moloi tiyo, woi, mi fou fouko ulomai no? Konoi no amai titouniyaimokai, woi?” Faumiko monoi louwa fi yokino, no monoi no molo amiso kwaikino. ");
INSERT INTO amm_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Totasu mo sai, toini mulu mo. No monoi no naino nomoli nokotaso na imoki, “Na pauwono, mulumai na potolau. Nokoni mulumai na potola tumo.” Imoki mo; na auwoniyouki, na tolauki. ");
INSERT INTO amm_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nokotalo iyaliso na louwa ikoki, “Ya timonukuwo, Musini imo no moloi tiyomuko? Molo koiyauso aluwai mo waliyo poimo, molo itouniyaimoso aluwai mo waliyo poimo, mi fou fouko ulomai mo. Ai nokota tofasikoni poimo, tofolo, na uwokaiyoimo poimo.” Ainonani monoi louwa ikoki. ");
INSERT INTO amm_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nosai no kwailuwaikaloki, naino nomoli nokotaso imoki, “Naino mo na pofouko.” Nosai no naino na foukoki, waliyo na takoki. ");
INSERT INTO amm_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ulai nokotalo iyali mo uo mulu saso, totai amu imo lukasikuwanokino, Isisoso uwo monoi. ");
INSERT INTO amm_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Nosai no mo; Isiso mo Kotowoi imo lukasa yoki, yuso. Amoloki siyolimai mo Kotowoi imo lukaso yousi manoki, lukaso manoki lukaso manoki lukaso manoki, ainoso posasi. ");
INSERT INTO amm_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Ulo amiyoki mo; nosai no mo; aluwai nokoso aliyonikoki. Siyaiso na muwokokaiki, Kotoni imo lukasikalomano monoi, noko molo tiwoi noko na muwokokaiki. ");
INSERT INTO amm_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Siya mo Saimo, siyolo siya kaluwaiki, Pita. Siya mo Anotolu, Saimoni auwatono. Siyolo siyolo siyai mo noino, Yamiso, Iyono, Filipo, Patolumiyo, ");
INSERT INTO amm_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiyu, Tomo, Yamiso, Alofiyani awitono. Siya mo Saimo siya, siyolo siya mo Siloto. ");
INSERT INTO amm_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Siya mo Yutaso, Yamisoni awitono. Siya mo Yutaso Isokailiyo, Isiso monoi uo nokoso no ifoluwaiko unuki no. No mo Kotoni imo lukasikalomano nokoni siyolo siyolo na. ");
INSERT INTO amm_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Nosai no mo; Isiso iyali mo kunoki, kiso na sa konoki, aluwai noko molopoi nokoni auso. Wiyou, noko nokolalo molopoi na sa tumo liyaiki, Yutiya asi nokowoi, Yolusolimo nokonu nokowoi, mamo iwo aumoifaso si noko, Taiya nokonusaiwoi Saito nokonusaiwoi no tiki no, toiwoi na. ");
INSERT INTO amm_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Isisoni imo kwaima tumokino. Ai ai noko ti liyai manoki, ititounikai monoi. Popuwayo uwokaikokai noko mani, na ititounikaiki, Isisoyo mo. ");
INSERT INTO amm_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Fiyaimokaikino, tani ausai komi monoi piyo manokino. Tani amiyo ititounikaiki, no monoi no komi monoi na yokino. ");
INSERT INTO amm_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Nosai no mo; Isisoyo siyokutono iyaliso kwaikaloki, na ikoki, “Ilolu somiso noko, moi mo na pa molokiwo. Koto na tosamukukomo manonuwo. ");
INSERT INTO amm_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Tiyawoiso noko moi mo na pa molokiwo. Na noinuwomo, touwai na tolokomoinuwomo. Sosonuno si noko moi mo na pa molokiwo. Na soluwanoinuwomo. ");
INSERT INTO amm_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Asi asi noko nokolaloni noko siyoli nokotaso aluwai noko moi, moi mo na pa molokiwo. Aluwai foli monoi nokoyo uo mulu atolokomo unoinuwomo, na alifoliyafoumo komoinuwomo, alisiyoli komoinuwomo. Moini siyolo siyolo kwaimo pa kolaloinuwoso, kopokoiyau imo kolaloinuwomo. ");
INSERT INTO amm_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Aniyopatono iyaliyo mani, tomoso na, Kotoni mulu lukasiko noko iyaliso uwokaikalokino. Ulai ainonani uwoyakinuwomo, na pa moloki siwo, na pa namoulu siwo. Pukwaiwo, kumokiso suo foli mo siyoli. ");
INSERT INTO amm_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ilolu molopoi noko moisu fau, atiyaiso. Asimai saso tosi itouniyaimonuwo. ");
INSERT INTO amm_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","No siyoli noko moi, touwai siyoli no tosinuwo no, moi fau, atiyaiso, amuwoi tinoso tiya na kolikaliyoinuwomo. Soluwano si noko moi fau, atiyaiso, amuwoi tinoso mulu kolikaliyoinuwomo, sosonunoinuwomo. ");
INSERT INTO amm_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Noko komasoyo iyamo unakinuwomo, noko ititouni imo, moi fau, atiyaiso. Aniyopatono iyaliyo mani, tomoso na, imo topoko noko monoi piyamo uku manokino, noko ititouniwo.” Isiso mo ainoso na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Nosai no mo; ti monoi na ikoki, Isiso mo, “Yani imo kwai noko moiso ya timonukuwo, uo nokoso mulu na pa ukuwo. Nokoyo mulu atolokomo unakinuwomo, atiyaiso pa yo ititouniwo. ");
INSERT INTO amm_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Nokoyo kaloni imo imakinuwomo, na pa ikowo, “Kotoyo na tofasinuwo.” Nokoyo koiyaukomakinuwomo, Kotoso na pa utolumo ukuwo, totayo fasiko monoi mo. ");
INSERT INTO amm_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nokoyo umosai ifasiyaimakinimo, umo siyai na pako alosimo. Nokoyo nani atoli tuno ano wayakinimo, wiyou imo mo noiyo imoi, pau tuno mani, na pako anoni. ");
INSERT INTO amm_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Nokoyo hani niko monoi utolumakinimo, wiyou imo mo noiyo ikoi, waliyo na pako niko. Nokoyo ilolu ako waninakinimo, amiso noiyo imoi, “Ifou pakomono.” ");
INSERT INTO amm_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Moi mo nokoyo fasikomo mulu monoi tiyo manonuwo. No monoi no nokoso pa fasiko mano liyaiwo. ");
INSERT INTO amm_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Noko, toiyo no tomulu unu manonuwo no, toisoso mulu ukakinuwomo, Kotoyo no moloi uwokomo itouniyaimo monoi, siyokuno iyali mulu uku foli monoi no? No mo siyoli hani muwoi. Molo koiyauso aluwai noko mani, ainoso mulu tuku manono, totaini siyokutono iyali monoi. Moi uo noko, toi mani, na pa mulu uku manowo, no monoi no Koto mo itouniyaimoso uwokomoinuwomo, suo foli monoi mo. ");
INSERT INTO amm_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Noko, toiyo no tofasikomo manonuwo no, toisoso fasikakinuwomo, Kotoyo no moloi uwokomo itouniyaimo monoi, siyokuno iyali fasiko foli monoi no? No mo siyoli hani muwoi. Molo koiyauso aluwai noko mani, noinoso tiyo manono. ");
INSERT INTO amm_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Noinoso nokoso nikakinuwomo, na iyamoinuwomo, “Suo mo amai nimokoinomo.” Suo i monoi nikakinuwomo, Kotoyo no moloi uwokomo itouniyaimo monoi? No mo siyoli hani muwoi. Molo koiyauso aluwai noko mani, na tonikalo manono, molo koiyauso aluwai noko siyaiso, suo monoi i monoi. ");
INSERT INTO amm_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ulai uo nokoso mulu na pa ukuwo. Atiyaiso na pa yo ititouniwo. Suomoso monoiso na pa nikowo, suo monoi noiyo iyamoiwo. Aino yakinuwomo, suo mo siyoli anoinuwomo. Kota Kotoni alalo na soinuwomo. Wafisu imo somiso nokoso Koto mo tofasikomoi. Noko nokolalo kopokoiyauso mani, tofasikomoi. ");
INSERT INTO amm_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Moini Apono mo mulu tokalo ukumoi. Moi mani, mulu na pokolikali ukuwo. Suomoso monoiso na pa fasiko manowo.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Nosai no mo; Isiso mo ti monoi na ikoki, “Noko siya monoi noiyo lukaso ukoiwo, “Kopokoiyauwo.” Wonikaluso momaini molo kopokoiyau foli monoi Kotoyo yomukaiyoimo. Molo koiyau foli monoi nokoso noiyo uwokoiwo, momaini molo kopokoiyau foli monoi Kotoyo aiko uwokomoinuwo. Imo na potokosokikowo, no monoi no moi monoi mani, Koto mo imo mo futo. ");
INSERT INTO amm_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Nokoso pa niko manowo, suo mani, Kotoyo mo na niyoinuwomo. Siyoliso na wauninoinuwomo. Siyoliso na inaloimo, ko kowaso. Nosai no kotiyonikoimo, woiso amukiyokonoimo. Ulai ti monoi na inaloimo, ko kowaso, wiyou nali wolitoloko monoi louwa. Siyoliso wautiyakinuwomo, nokoso, Koto mani, suo monoi siyoliso wauninoinuwomo. Koufaso wautiyakinuwomo, Koto mani, suo monoi koufaso wauninoinuwomo.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Nosai no mo; Isiso mo siyokawi imo ti monoi na ikoki, “Molo kau kau nokota ti, totati amu no molo no waliyo wiyolukuwano, woi? Wiyou, toti mo asi iso tomoso usukunalo konoimo. ");
INSERT INTO amm_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Sokolu alaloyo no totaini aiyoloko nokota no moloi souwai monoi? Sokolu uwaisu mo aiyoloko nokota komiyai na soimo, sai sisiyoliwoi.” Isiso mo siyokawi imo ainoso na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ulai Isiso mo na ikoki, “Noko siya monoi noiyo iyamoiwo, molo koiyau aluwai foli monoi mo. No mo molo kukumo koufa komiyaisu. Ulai nono mani, molo koiyauso yapoli na taluwai manoni, molo kukumo soliyaki komiyai tanokaino, a soliyaki topi. ");
INSERT INTO amm_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Hani monoi siyokunoso timoni, “Woli, yo mo kukumo koufa tafoliwainoki, nani moloso.” Ulai nono mani, a pokamono siyoli pa tokiniso, nani molo tiso. Nono mo imo topoko nokota nali, nona amu monoi tiyomuni, noko itouniyaimowo. Molo koiyauso aluwai nokota na, nono mo. A pokamono siyoli nani molo tiso no tanokaino no, no mo na pa afoli taikiyo, toku mo. Namolimai mo waliyo na foinalikoinimo, siyokunoni molo kukumo pa afoliwai.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Isiso mo ti monoi na ikoki, “A itouniyaimo mo a wamo kopokoiyauwoi pa tosiso. Noinosu nali, a koiyau mani, a wamo ititouniwoi pa tosiso. ");
INSERT INTO amm_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Nokoyo a wamoso atiyaiso kokakimo, na sainoimo, a koiyau poimo itouniyaimo poimo. Moloi woi? Molosu aso no sipoki wamo no moloi si monoi? Molosu a koufa mo si wamo ititouni mo pa tosimoiso. ");
INSERT INTO amm_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Noko koiyau nokota, tani mulu mo wapumokai. No monoi no imo koiyausoso na tolukasalomoi. Noko itouniyaimo mo mulu itouniyaimowoi na totolomoi. No monoi no imo itouniyaimososo na tolukasalomoi. Mulu koiyauwoi nokota tani imo mo kwaimo pa tolukasoso, tani imo mo koiyau. Mulumoloko itouniyaimo mulu tano mo, nonani nokota mo imo itouniyaimoso tolukasomoi.” Aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Isiso mo ulai ikoki, “Hani monoi tokaluwaimono manonuwo, “Koini Siyoli Nokota, koini Siyoli Nokota.” Moi mo yani imoso pa taluwaimono manonuwoso. ");
INSERT INTO amm_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nokoyo yani imoso kwaimona tumakimo, to no noi komiyai? Noko mo yani imoso aluwaimonakimo, to no noi komiyai? Ya towiyononinukuwo ninoino. ");
INSERT INTO amm_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nonani nokota mo nu ko nokota komiyai. Toku mo asi i na taiyalo kono, woiso. A soliyaki ikaiyalo kono, tomoki tonimai mo totola kono. Namolisai mo nu tolokolisiya yo. Nosai no mo, iwo usoiyo siyoli totumo. Iwo miyo nu louwa tusainiyaikiyo fu. Akokonowoi muwoi, amiso amai na totoloko. Ulai afonimaiso? Nonani nokota mo nu mo itouniyaimoso na ko. ");
INSERT INTO amm_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ulai nokoyo yani imo iyoyoso kwaimonokaiyakimo, to mani, nu ko nokota komiyai. Asi i aikowoi muwoi, asimai nu toko. Nosai no mo, iwo usoiyomaiso iwo miyo na tusainiyaikiyo fu, lolai siyaso takokono. Na tokolitoloko.” Aino ikoki, Isiso mo, siyokawi imo mo. ");
INSERT INTO amm_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Nosai no mo; Isiso mo noko nokolaloso ikoki mo; yasoi, na manoki. Kopanaumo nokonu mo tumoki. ");
INSERT INTO amm_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Polimano samukuko nokota siyoli nonani nokonuso tolokainoki, Lomo nokota na. Mi anononi nokota mo yapoli na, mulu siyoli no unuki no. Nonani nokota mo ai na uwoki, na louwa kaloki. ");
INSERT INTO amm_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nosai no mo; polimanota siyoli no mo, tani auso imofa kolo koloma tumoki, Isiso monoi aino imo. No monoi no Yuto noko sisiyoli nokoso iko taikiyoki, “Isisoso na pimanowo, yani mi anomono nokota itouniyaimokaiya tumumo.” ");
INSERT INTO amm_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Isisoni au mo tiki mo, na imalokino, “Polimanota itouniyaimo na, waliyo na pofasiyano. ");
INSERT INTO amm_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Yuto noko moi monoi tomulu unumokomoi. Koini lotu nufa mo ta noinomo na komokokino.” ");
INSERT INTO amm_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Nosai no mo yasoi, Isiso mo na aluwaikoki. Polimanotani nu aumoifa mo tumoki mo, polimanota mo siyokutono iyaliso iko taikiyoki, na yomu taikiyoki, “Noko Siyoli, tofolo ino. Yo no nonoso no moloi fololuwai monoi? Yani nu poiso no nono no moloi loti monoi? Yo mo noko itouniyaimo muwoi. ");
INSERT INTO amm_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Motu na, yo mo noko itouniyaimo muwoi. Yo no nonoso no moloi kiyano monoi? Imoyosu na piyomu, yani mi ano nokota mo waliyo na toloimo. ");
INSERT INTO amm_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Yo mani, noko siyani fiyo wosuwoimai totolo. Polimano noko siyai mo yapoli na si, asani fiyo wosuwoimai tosi. Yo mo siyaso imo mo, “Na pomoi,” to mo na tomoi. Noko siyaso imo mo, “Potumo,” to mo na totumo. Yani mi ano nokotaso imo mo, “Mi na pano,” to mo mi na tano. Noinoso nani imoyosu titouniyaimoni, yani mi anomono nokotaso mo.” ");
INSERT INTO amm_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Isiso mo nonani imo kwaimoki mo, na mulumoloko manoki, aluwai noko nokolalo molopoi nokoso fokutonoyo alosikoki, na ikoki, “Ya timonukuwo. Ninani nokota mo waliyo na tomulumolo luwaimono, siyoliso nali. Isolilo noko moi mo siyoliso pa tomulumolo luwaimononuwoso.” Aino ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Nosai no mo; noko iyali, polimanota siyoliyo no iko taikiyoki no, toi mo nu mo ifou tiki. Mi anononi nokotaso na kiya tumokino, waliyo toloso. ");
INSERT INTO amm_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Nosai no mo; namolimaifa, Nino nokonuso manoki, Isiso mo. Siyokutono iyaliwoi noko nokolalo molopoiwoi aluwaikino. ");
INSERT INTO amm_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nokonu kokikokai itu loti kwamai fu tola tumoki mo, noko yau na sokuniyo fukino. Atino mo alu mo kalo watisoki, alu mo siyaso, sawi nukonu na. Tolomu noko nokolalo molopoiyo aluwainisiyo fukino. ");
INSERT INTO amm_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Isiso Siyoli mo nonani nukonuso kwaisoki mo, mulu kalo usoki, na isoki, “Noiyo sinoi.” ");
INSERT INTO amm_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nosai no aumoifaso na amunoki, noko yauni molo tokosisai komikanoki. No monoi no ututomokikoki, molo tokosi sokuko nokoyo. Noko yauso na imoki, “Wolifa, ya timonoki, na pauwoniyou.” ");
INSERT INTO amm_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nosai no mo; yau nokota mo na yousauki, imo na lukasoki. No monoi no Isiso mo alu mo ifou atisoki, atinoso. ");
INSERT INTO amm_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","No monoi no mo, noko nokolalo komaso mo kokolokoki, Kotoni siyolo kaluwaiyaloukino, ikuwanokino, “Kotoni mulu lukasiko nokota siyoli mo moini auso na tolokaina tumo.” Ti monoi ikuwanokino, “Koto mo yasoi na tumo, tani noko nokolalo moi fasimoka tumo monoi.” ");
INSERT INTO amm_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ainonani monoi imo kolo kolomo liyaiki, Yutiya asiwoi aumoifa aumoifaso asiwoiso, Isiso monoi aino imo mo. ");
INSERT INTO amm_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Nosai no mo; Iyononi siyokutono iyaliyo Iyono totaso imo lukasiya tumokino, Isiso monoi aino imo, hani hani no yo manoki no. ");
INSERT INTO amm_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Imo lukasiya tumokino mo; Iyono mo siyokutono noko tiso aliyonikoki, “Kukuwo.” Na iko taikiyoki, Isiso Siyolini auso mano monoi, ikoki, “Na pimanowo, “Noko no tumo monoi no, a, nono na, Kotoyo imo taikiyo nokota, no mo nono na poimo, o, siyaso poimo foumoikimo.” ");
INSERT INTO amm_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Aino iko taikiyoki. Isisoni au mo tumokino, na ima tumokino, “Iyono iwoso uluwako nokotayo tiyomu taikiyo, “Noko no tumo monoi no, a, nono na, Kotoyo imo taikiyo nokota, no mo nono na poimo, o, siyaso poimo foumoikimo.” Aino tiyomu taikiyo, nono monoi.” ");
INSERT INTO amm_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Toti tumomai mo Isiso mo ai ai noko nokolalo pititounikaiyalo manoki. Popuwa molopoi pamiyaikiyokowaikalo manoki. Molo kau kau noko molopoi mani, molo posasoulukoki, na foinalikokino. ");
INSERT INTO amm_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","No monoi no mo, Isiso mo totini imo na fowakoki, “Iyonoso na pa imanowo, hani hani komaso no kokonuwo no, no kwaimononuwo no. Molo kau kau noko mo na toposasouluko, na tofoinaliko si liyai. Fona nomoli nomoli noko mani, na toliyaino. Uluoyo uwokaikokai noko, iyo uku nokowoi, toi komaso mo waliyo na tosi liyai. Yau yau noko mani, na tauwonoulu liyai. Sonosoni somiso noko mo imo itouniyaimo na tukwai manono. ");
INSERT INTO amm_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Noko mo asa monoi mulu tiwoi tolo somiso mo, nonani nokota mo na tomoloki tolo.” Isiso mo aino na ikoki, noko tiso. ");
INSERT INTO amm_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Noko ti no mo, Iyonoyo no iko taikiyoki no, toti yasoi. Nosai no mo; Isiso mo noko nokolaloso Iyono monoi iko unuki, “Toku no haniso kiyanokinuwo, noko somiso asiso no? Nakomo moi mo muo muo yapoli kiyanokinuwo, fulomuyo no fuo fuolomani tolo no. Pa kiyanokinuwoso. ");
INSERT INTO amm_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Noi nokotaso kiyanokinuwo? Nakomo kou ititouni nokotaso kiyanokinuwo. Wiyou na. Noko kou ititouni noko, toi mo noko somiso asiso siwoi muwoi, noko siyolini nuso tosimoi, hani hani ititouniwoi. ");
INSERT INTO amm_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ulai noi nokotaso kiyanokinuwo? A, Kotoni mulu lukasiko nokotaso no kiyanokinuwo? Wuo, nasu, Kotoni mulu lukasiko nokotaso na kiyanokinuwo, Iyonoso mo. Toku nokoso na tosouwaiko, Kotoni imo toku no posasokokino no. Ya timonukuwo. ");
INSERT INTO amm_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ninani nokota monoisu mo Kotoni puko imoyo noino tiyomuko unu, “Pukwai, asani imo lukasikalo nokotaso imo taikiyoimo, to mo toku na manoimo, nono monoi. Molo na yono foumaloinimo.” Aino tiyomuko, Iyono monoi. ");
INSERT INTO amm_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ya timonukuwo. Iyono, iwoso uluwako nokota mo asi noko komaso nokoso toku souwaikoki. Ulai lolai mo folo, afonimai nokota mo asani moloso aluwai mo, to mo Iyonoso na tosouwai, Kotoyo samukumai mo.” Isiso mo aino ikoki. ");
INSERT INTO amm_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Isisoni imo kwaikino mo, noko nokolalo komaso iyamoki, “Nasu, Kotoni imo mo motu nali.” Takiso muwoni i noko kopokoiyau mani, tomoso na iyamoki. Iwoso yasoi uluwakoki, muwokokai monoi, Iyononi nainoyo. ");
INSERT INTO amm_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Nokotalo iyalisu mo Iyonoyo iwoso uluwakowoi muwoi, Falisi moloso aluwai nokowoi aniyopa imo sai sisiyoli nokowoi. Wiyou iyamoki. Kotoyo no louwa wiyotiki no, nosoni namoliyo na alosimokino. ");
INSERT INTO amm_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Nosai no mo; Isiso mo ikoki, “Lolaimai si noko moi, yo no moini siyolo siyolo no moloi tokolalinukuwo, woi? Noiwo noko komiyai, moi no? ");
INSERT INTO amm_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Moi mo alalo lolofa komiyai tosomaimo sinuwo, nokonu mulumai. Taliyonikuwano manono, somaimo monoi, “Koi mo louwo tuwokonoki, ulai moi mo pa tonamonuwoso. Koi mo noko yau monoi tosonuku sinoki, asuwo asuwo, ulai moi mo sosonunowoi muwoi.” ");
INSERT INTO amm_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Noinoso moi mo pa tiyamonuwoso, “Iyononi molo mo itouniyaimo.” Iyono, iwoso uluwako nokota tumoki, tuo mo nowoi muwoi, molo wamo ito iwo sikowoi muwoi. No monoi no tiyamo manonuwo, “No mo kwaimo muwoi. Hani monoi pa tonomoiso.” Tiyamonuwo, popuwayo tuwowo. ");
INSERT INTO amm_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ulai asi asi noko nokolaloni noko siyoli nokota ya tumoki, yo monoi mani, pa tiyamonuwoso, itouniyaimo. Yo mo na tonomoi, molo wamo ito iwo tosikomosi, no monoi no moiyo tiyamonuwo, “Pokiwo, kwaimo muwoi, no siyoli nokota, molo wamo ito iwo siko siyoli nokota. Takiso muwoni i noko kopokoiyau nokoni wolitono, molo koiyauso aluwai nokowoi, toini siyokutono. Kwaimo muwoi.” Aino no hani monoi tiyamo manonuwo? ");
INSERT INTO amm_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Kotoni mi ano nokoso na pukwaikalowo, no monoi nosu posainowo, ititouni na. Koto mo mulu mo iwoi.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Nosai no mo; Falisi moloso aluwai nokotayo Isisoso ima tumoki, “Yani nuso pono fasimona tumo.” Yasoi, Falisi moloso aluwai nokotani nu mo tumoki, no yousa tumoki. ");
INSERT INTO amm_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Nonani nokonumai mo noni tolosoki, molo koiyauso aluwai nukonu na. To mo imoso na kwaiki, Falisi nokotani nuso no yousa tumo monoi. Nosai no mo; tomoki nau itouniyaimo na asiyo tumoki, kou woti iwo itouniyaimowoi. ");
INSERT INTO amm_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Nu poiso asiyo tiki, Isisoni auso losiyaika tiki, namolisai, na soniki. Soni molo iwo mo Isisoni fona tiso amukono liyaiki. Amukono liyaiki mo, komu suwo sopoyo na uwosuwakomoki, amoliyo akaikomoki, fona timai. Totani kou woti iwo itouniyaimo na solukikomaloki, tani fona tiso. ");
INSERT INTO amm_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Nosai no mo; Falisi moloso aluwai nokota no mo, Isisoso no imanoki no, “Yani nuso pono fasimona tumo,” nonani nokotayo mo kiki mo, na mulumolokoki, “Noko ni mo Kotoni mulu posaino mo, na posaino, noni ni tokomi no, to mo molo koiyauso aluwai nukonu na.” ");
INSERT INTO amm_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ulai imoki, Isisoyo mo, Falisi moloso aluwai nokotaso, “Saimo, yo mo imo tolukasinoki.” Saimoyo imoki, “Aiyolokomomoko nokota, waliyo na pimono.” ");
INSERT INTO amm_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Nosai no mo; siyokawi imo na lukasiki, imoki, “Muwoni nokota siyoliyo noko tiso mo muwoni toniko. Awa toniko. Muwoni foli mo amai. Siya mo muwoni foli mo siyoli, 100 kina. Siya mo muwoni foli mo koufaso, 10 kina saso. ");
INSERT INTO amm_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ifou no moloi ni monoi, toti no? Muwoni mo uwofa na. Ulai muwoni nokota siyoliyo na alukikoki, nonani muwoni ti foli monoi mo.” Isiso mo siyokawi imo aino imoki, ulai nosai no imoki, “Noi no mulu siyoliso unoimo, muwoni nokota siyoli monoi? Noi no mulu koufaso unoimo?” ");
INSERT INTO amm_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Saimoyo fowaki, “Ya tiyomu, 100 kina nokota, muwoni siyoli foli monoi no alukimoki no, nonani nokotayo mo mulu siyoliso unoimo.” Isisoyo imoki, “Motu na tiyomuni.” ");
INSERT INTO amm_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Nosai no mo; noniso monoi alosisoki, fokutono mo. Saimoso na imoki, “Noni ni pokoso. Yo mo nani nuso tola ti mo, nono mo fona uluwakomomono iwo mo pako woliyomononiso. Nonisu mo totani soni molo iwoyo na uluwakomomono, yani fona mo. Komu suwoyo na uwosuwakomomono. ");
INSERT INTO amm_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ya tumomai nono mo amoliyo pa akaimomononiso. Ya lotimai ainoso lolai ninani nukonusu mo yani fona tiso amoliyo na akaikomomonomoi, pa ulosukosomoiso. ");
INSERT INTO amm_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Nono mo yani komu mo woilo iwoyo pako uluwamononiso. Nonisu mo kou woti iwoyo na uluwakomomono, yani fona tiso. Nono mo aniyopa molo itouniyaimoso pa aluwainiso, totasu mo tuwomono itouniyaimomoi. ");
INSERT INTO amm_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","No monoi no ya timonoki, ni mo molo koiyauso aluwaiyalo nukonu. Mulu koiyau no ulai koufa, siyoli na. Ulai yo mo yasoi afoli watiso, yani molo timai mo futo. No monoi no siyoliso na tomulu unumono. Mulu koiyaufa saso afoliwai mo, koufaso mulu unumono.” Isiso mo ainoso imoki, Saimoso. ");
INSERT INTO amm_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nosai no mo; Isiso mo na isoki, “Yo mo nani molo koiyau monoi imo mo futo.” ");
INSERT INTO amm_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Noko no si tomasimokino no, totai amu imo lukasikuwanalokino, “Ni no noi, woi? Hani hani tiyomoi, mulu kopokoiyau mani, tosaloso uwokomoi.” ");
INSERT INTO amm_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ulai Isiso mo na isoki, “Na tomulumolo luwaimononi, no monoi no tosamiyaikiyoni. Atiyaiso potolano, mulu tomokiso.” ");
INSERT INTO amm_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Nosai no mo; Isiso mo nokonu nokonuso liyaiyalo manoki. Imo na posasokalo manoki, imo itouniyaimo, Koto samukumoko imo mo. Noko molo tiwoi noko aluwaikino. ");
INSERT INTO amm_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Nokolalo mani, na aluwaikino. Popuwa kopokoiyau toku saloso uwokaloki, ai ai mani, toku ititounikaiyaloki. Na aluwaikino. Siya mo Moili, Makotalo asi nukonu kaluwaisokino. Nonani nukonu mo toku Isiso totayo nano siyawoi popuwa amiyaikiyokowaisoki. ");
INSERT INTO amm_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Noni siya mo Yowana, Hiloni nu samuku nokotani noni. Nu samuku nokota siyolo mo Kusa. Siya mo Susana. Toi saso muwoi, molopoi na aluwaikino. Nonani nokolalo mo Isiso iyaliso fasikalokino, totaini muwoniyo fasikalokino. ");
INSERT INTO amm_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Nosai no mo; noko nokolalo molopoi molopoi ukouniyaikokuya tumokino. Nokonu nokonusai Isisoni auso ti liyai manoki mo, siyokawi imo na ikoki, ");
INSERT INTO amm_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Noko mo aliyoli ali tokosikwiyalo, isiso. Tokosikwiyalo mo, aliyoli ali siyai mo molomai tosalo kono liyai. Nokoyo totowitolokono. Nosai no uoyo na tonokalo tumono. ");
INSERT INTO amm_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Siyai mo tomoki asimai tosalo kono liyai. Na tauwonoulu liyai, ulai asi mo iwowoi muwoi, no monoi no na tonomoliko taikiyo. ");
INSERT INTO amm_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Siyai mo molosu to to mulumai tosalo kono liyai. Molosu isi atoniyo tauwonoulu liyai, na tofiyokaikono. ");
INSERT INTO amm_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Aliyoli ali siyaisu mo asi itouniyaimomai na tosalo kono liyai, itouniyaimoso na tauwonoulu liyai. Wamokomai mo u molopoi molopoi na tosi liyai, soliyaki soliyaki.” Siyokawi imo aino na ikoki, Isiso mo. Nosai no ti monoi ikoki, siyoliso, “Noko mo iyo uku somiso mo, imo mo na pa kwaimono itouniyaimowo.” ");
INSERT INTO amm_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Nosai no mo; siyokutono iyaliyo na imokino, “Siyokawi imo folosai na posaso wiyolumoko.” ");
INSERT INTO amm_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Na fowakoki, “Kotoyo mo moi samukukomo mulu yasoi wiyononikinuwo. Nonani kukalokokai imo mo momaisoso na wiyononikinuwo. Noko nokolalo siyai mo sai muwoi. Siyokawi imo saso na tolukasikomosi. No monoi no, “Molo saso tofoinalikono, ulai hani mo kiwoi muwoi. Imo saso tukwaino, ulai imo folosai mo sainowoi muwoi.” Aino tiyomuko, Kotoni puko imoyo mo.” Aino na ikoki, Isiso mo, siyokawi imo monoi. ");
INSERT INTO amm_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Nosai no mo; Isiso mo ti monoi na ikoki, “Ninani siyokawi imo folosai mo noino, aliyoli ali mo Kotoni imo na. ");
INSERT INTO amm_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Aliyoli ali molomai no tosalo kono liyai no, no mo Kotoni imo komiyai, nokoyo kwai monoi louwa. Ulai Sokolo Nokota Waiyo mo toini auso somaiso na totumomoi, Kotoni imo tosaloso uwoka tumomoi, nonani nokoni mulu poiso. Na tomulumoloko, “Wonikaluso Kotoso mulumolo luwaiyoinomo, aiko samiyaikiyo soi.” ");
INSERT INTO amm_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Aliyoli ali tomoki asimai no tosalo kono liyai no, no mo Kotoni imo komiyai, nokoyo tukwaino, toku na tomolokimono. Ulai nonani noko iyali mo toti somiso ali komiyai. Koufaso tomulumolo luwaino. Ulai hani hani uwoko kimai namoliyo na alosimoinomo. ");
INSERT INTO amm_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Aliyoli ali molosu to to mulumai no tosalo kono liyai no, no mo Kotoni imo komiyai, nokoyo tukwaino. Ulai amiso siwoi muwoi. Asini hani hani mulusoso tiyo manono, muwoni mulu monoiso na tiyo manono, hani hani ilolu muluwoi. Nonani asini mulu mo Kotoni imoso na tofiyokaikokai manono. Nonani noko iyali mo a wamo itouniyaimo si somiso a komiyai. ");
INSERT INTO amm_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Aliyoli alisu asi itouniyaimoso no tosalo kono liyai no, no mo Kotoni imo komiyai, nokoyo tukwaino. Na tomulumolo luwaino. Mulu mo ititouni saso. Toi mo pa tulosukomoiso, mulu mo ami ami, a komiyai a wamowoi tosimoi.” Isiso mo aino na ikoki, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Nosai no mo; Isiso mo ti monoi na ikoki, siyokawi imo mo, “Noko mo lamu ta falosisakimo, nauyo no moloi ufiyaiso monoi? Ulai kotisoko wosuwoiso no moloi akaiso monoi? Wiyouwa wiyou, puwoso na tafonikokaisomoi. No monoi no nokoyo nu poiso toti liyai mo, lamu ta fupiniyaimoso na tokiya tino. ");
INSERT INTO amm_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Hani hani mo kukalokokai sakimo, nokoni molo timai fiyamosokoimo. Hani hani imo ufiyaikokai sakimo, saponimaiso soimo, noko saino monoi. ");
INSERT INTO amm_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Imo ni tukwaimononuwo no, atiyaiso na pukwaiwo. Noko mo Kotoni imoso sainakimo, to mo Kotoyo aiyolomoimo, sai siyoliwoi toloimo. Nokosu mo koufaso sainakimo, nonani koufaso mani, fufolikomoimo. Wonikaluso sai somisomai iyamoinuwomo, saiwo.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Nosai no mo; atinowoi auwatono iyaliwoi mo Isiso monoi louwa kiya tumokino. Ulai noko nokolalo molopoiyo ukouniyaikoku siki. Aumoifaso no moloi kiya ti monoi? ");
INSERT INTO amm_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Nosai no nokoyo imoki, “Anoni auwano iyali mo asiyofoloso fu si. Na tokiya tumoni.” ");
INSERT INTO amm_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ulai na imoki, “Nokoyo Kotoni imoso kwaimono mo, toi mo yani anoi auwa iyali na.” Isiso mo aino na yomuki. ");
INSERT INTO amm_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Nosai no mo; ulo siya mo Isiso mo siyokutono iyaliso ikoki, “Soiwo, iwo ilo ausaimiso totikoni.” No monoi no ayouso folamuwaniyo konoki, yasoi. ");
INSERT INTO amm_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ayou mo alomakalokino mo, Isiso mo ulololi na ku tanokainoki, ayou poiso. Nosai no mo; imonu siyoli na auwoniyouki. Iwo mo na koma liyoki, ayou poiso. Aumoifaso tukuwoli soli monoi louwa. Moloi woi? ");
INSERT INTO amm_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Isiso na lusiyaikiyokino, imokino, “Siyoli Nokota, Siyoli Nokota, aumoifaso iwoyo na totukuwoli solimoko.” Nosai no na auwoniyouki, imonu siyoliwoi iwo mi siyoliwoiso na ikauki, “Wosu woso.” Na tolosuwaki, imonu mo, iwo mi mani, futo. ");
INSERT INTO amm_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Na ikoki, “Hani monoi pa tomulumolo luwaimononuwoso?” Toisu mo kokoloko manoki, mulumoloko manokino, totai amu lukasikuwanokino, “Hani nokota, woi? Imonuwoi iwowoiso iko mo, tani imoso na kwaimono.” ");
INSERT INTO amm_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Nosai no mo; imonu mo uwai; yasoi upoiso monoi, Kilasa asimai. No mo iwo toku ilo ausaimi na, Kalili asi mo isaimi. ");
INSERT INTO amm_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Isiso ayousai folamiyo konoki mo, iloso, popuwa kopokoiyauwoi nokota mo na kiya tumoki, nokonu aumoifaso nokota na. Toku tokusai to mo tuno mo asisiwoi muwoi, tuno asoso na potolo manoki. Nuso mani, pa tolo manokiso. Wiyou. Noko aiko uku asimai potolo manoki. ");
INSERT INTO amm_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Nonani nokota mo Isisoso kwaiki mo, na omoki, tani fokutonomai alokomu losiyaika tumoki. Popuwayo noinomo noko mo siyoliso na imaloki, “Isiso, nono mo Kotoni awitono, Kota Kotoni awitono mo. Hani monoi totumo unumononi? Iyanoko noiyo uwomonoi.” Aino imoki. ");
INSERT INTO amm_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ulai afonimaiso? Isiso mo toku yasoi imoki, “Popuwa koiyau, nokoni ausai na putukaimo.” Toku toku inosai pokololuwakaimosiki. Nokoyo louwa posamukumosikino, waiya moloyo louwa pokonosuwakomo kaimosikino, naino ti fona timai. Wiyou, na potokosoulalo manoki, waiya molo mo. Popuwayo polomu kalumanimosikino, noko somiso asiso. ");
INSERT INTO amm_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Nosai no mo; Isiso mo na imoki, “Nani siyolo no moloi?” Na fowaki, “Yani siyolo mo Ukouniyaiko.” Popuwa molopoiyo sa tiki, tani au poiso. No monoi no fowaki, “Yani siyolo mo Ukouniyaiko.” ");
INSERT INTO amm_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Imalo manokino, Isisoso, “Kaki somiso asi iso noiyo kiyomoko taikiyoi.” ");
INSERT INTO amm_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Fu molopoi molopoi yufaso asi pono siki, aumoifaso. No monoi no popuwa mo Isisoso imalokino, “Funi au poiso no waliyo tukwaiya kiyomokoni?” Fowakoki, “Waliyo na.” ");
INSERT INTO amm_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Nosai no mo; nokoso na utukaimokino, funi au poiso na uloloniyo tiki. Tiki mo; fu mo koli siyolisai fufumuwana konoki. Iwo toku iwoso usukunalo kono liyaiki, iwoso na tukuwoli soliki, yau yau. ");
INSERT INTO amm_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Fu samukuko nokoyo nonani haniso kwaikino mo; nosai no na uloloki. Nonani monoi aino imo lukasikalo manokino, nokonu noko nokolaloso, nu siyasonuso asimai si nokowoiso. ");
INSERT INTO amm_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","No monoi no noko nokolalo mo yasoi, nonani haniso kiyanokino. Isisoni au mo tiki mo, nokoso na kiya tumokino, popuwa molopoiyo utukaimo nokotaso. Tuno atolikaimokai. Kwalu kwalumowoi muwoi, mulu mo itouniyaimoso na popomuwakaiki. Isisoni fonamai yousikainoso kiya tumokino mo, na kokolokoki. ");
INSERT INTO amm_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Popuwawoi nokota itouniyaimokaiso ki noko, totaiyo nonani monoi aino imo lukasiko si manoki. ");
INSERT INTO amm_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Noko komaso, Kilasa asimai no si liyaiki no, toi mo Isisoso imalokino, “Koini ausai mo na putukaimoko, na pomoi.” Wiyou, na kokolokoki, no monoi no imokino. No monoi no mo, Isiso mo ayouso folamiyo konoki, ifou mano monoi. ");
INSERT INTO amm_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Nosai no mo; popuwayo utukaimo nokota mo Isisoso imaloki, “Yo mo taluwainoki.” Ulai Isiso mo imoki, “Yani ausai na putukaimono, ");
INSERT INTO amm_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","nuso na pomoi. Na pikano, Kotoyo no itouniyaimokaini no, nonani aino imo polukasikano.” No monoi no mo, nonani nokota mo na manoki, tota itouniyaimokai aino imo lukasikaloki, totani nukutai noko nokolaloso. ");
INSERT INTO amm_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Nosai no mo; Isiso mo Kalili asi mo ifou tumoki mo; noko nokolalo molopoiyo foumo siki, tota tumo monoi molokimo siki. ");
INSERT INTO amm_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Nomai no noko siya mo na tumoki, Isisoni fokutonomai losiyaika tumoki. Tani siyolo mo Yailo, lotu nufa samuku nokota na. Na imaloki, “Yani nuso na paluwaimono.” ");
INSERT INTO amm_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Nonani nokota mo alu mo siyasu, alu noniyaniko siyoli sowiyafa, aisamu mo 12. Aumoifaso na kalosoki, no monoi no ima tumoki. Isiso mo louwa manoki, ulai noko nokolaloyo na ukouniyaikokaiki, fiyokaimokino. ");
INSERT INTO amm_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Nomai no noni mo na tolosoki, nufaisoyo uwokaisokai nukonu mo. Aisamu mo molo tiwoi mo nonani ai puwosokai manoki. Toku toku inosai louwa itouniyaiso manokino. Ulai moloi isololuwaiso monoi? ");
INSERT INTO amm_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Isisoni namolisaiso wosu woso na tolosa tumoki, tani tuno soposai na komiki, tuno unusai. Wiyou, lolai siyaso nako mo tolosuwasoki. ");
INSERT INTO amm_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Nosai no mo; Isiso mo yomuki, “Noiyo tokomimono?” Ulai siyasonuso iyamaloki, “Yoi, ya muwoi, ya muwoi, ya muwoi.” Nosai no Pitayo, “Siyoli Nokota, noko nokolaloyo na tukouniyaikokuni, na tofiyokaimoni.” ");
INSERT INTO amm_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ulai yomuki, “Aino muwoi, siyayosu na komimono. Yo mo sai, ami mo noniso na tamiso.” ");
INSERT INTO amm_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Nosai no mo; noni mo kumolokosoki, Isisoni fokutonomai alokomu losiyaika tumoki. Moloi kukali monoi? Noko nokolaloni molo timai Isisoso imoki, “Ya na tokominoki. Wiyou, lolai siyaso waliyo na totolo, yo mo.” ");
INSERT INTO amm_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Na isoki, “Woli, waliyo tomulumolo luwaimononi, no monoi no mo waliyo na totoloni. Atiyaiso potolano, mulu tomokiso.” Aino na isoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Isisoyo amai lukaso niso manoki mo, nomai no mo, lotu nufa samuku nokota Yailoni nusai na tumoki, nokoyo, toso na ima tumoki, “Nani alu mo yau, yasoi na kaloso. Aiyoloko nokotaso afonimaiso noiyo fololuwaiyoi.” ");
INSERT INTO amm_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Nonani imo kwaimoki mo, Isiso mo Yailoso na imoki, “Noiyo kokolomoi. Na pomulumolo luwaimonosu. Ya na titouniyaiso kaiyano.” Aino imoki. Yasoi, Yailoni nuso monoi. ");
INSERT INTO amm_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Nu mo tiki mo, noko nokolaloso alukikoki, ikoki, “Nu poiso noiyo toiwo.” Pita iyalisu na koliyo tiki, Pitawoi Iyonowoi Yamisowoi. Aluni apitono noko ti mani, koliyo tiki. ");
INSERT INTO amm_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Noko nokolaloyosu fu sosonuno manoki, na fu sonukuso manokino. Na ikoki, Isiso mo, “Noiyo sonukusoiwo. To mo yau muwoi, ulololi totaso.” ");
INSERT INTO amm_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ulai na soluwaikino. Toi mo sai, yau yasoi na. Na kalosoki. ");
INSERT INTO amm_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ulai Isiso mo alu yauni nainosai na komisoki, na isoki, “Yani wolifa, na pauwoniyou.” ");
INSERT INTO amm_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Isoki mo; tani mulu mo ifou na tumosoki, lolai siyaso na auwonisiyouki. Atino noko tiso ikoki, Isiso mo, “Koloni na ponisowo.” ");
INSERT INTO amm_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Wiyou, atino apitono noko ti mo kufaukoki. Ulai imo amiso na ikoki, “Ainonani monoi imo noiyo ikaloiwo.” ");
INSERT INTO amm_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Nosai no mo; Isiso mo noko molo tiwoi nokoso na aliyonikoki. Tiki mo; ami sisiyoli na nikoki, popuwa kopokoiyau saloso uwokalo monoi. Ai ai noko ititounikaiyalowoi monoi na nikoki. ");
INSERT INTO amm_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Na iko taikiyoki, Kotoni imo posasoko monoi, Kotoyo noko samukuko imo mo. Ai ai noko ititounikaiyalo monoi mani, iko taikiyoki. ");
INSERT INTO amm_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Toku mo na ikoki, “Nuwakinuwomo, hani haniwoi noiyo ilomanoiwo. Atouwoi noiyo ilomanoiwo. Iwoi tuowoi muwoniwoi mani, noiyo ilomanoiwo. Kwalomai monoi tuno noiyo ilomanoiwo. ");
INSERT INTO amm_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nokonuso fiyamosiyakinuwomo, tolomu nokotani nuso na pa tiwo. Nonani nokotani nusoso na pa simosiwo, ulololi mo, ainoso hani utukaimoinuwo, nonani nokonuso. ");
INSERT INTO amm_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nokonu siya nokoyo imakinuwomo, “Noiyo toiwo,” nonani nokonu na pa utukaimowo. Fona asi kukumo pa kitotasokokaiyouwo, toini molo timai. Ulai afonimaiso? Toiyo imo kulali monoi nali no, imonuwo, “Koini nokonuso noiyo toiwo.” Aino na iko taikiyoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Nosai no mo; yasoi, siyokutono iyali mo nokonu nokonuso nu liyaiki, Kotoni imo itouniyaimo na posasoko wiyotiyalokino, ai ai noko nokolalo na ititounikaiyalokino. ");
INSERT INTO amm_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Nomai no mo, komano nokota siyoli Hilo mo, to mo Isiso aino imo koloma tumoso kwaiki. Mulumoloko manoki. Siyai mo Isiso monoi piyamaloki, Iyono, iwoso uluwako nokotawo. Na iyamoki, “Yausai ifou lusikaiki, nokoyo.” No monoi no mulumoloko manoki, Hilo mo. ");
INSERT INTO amm_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Siyaiyo piyamaloki, aniyopatono Ilaiyayo fiyamosiwo. Siyaiyo piyamaloki, Kotoni mulu lukasiko nokota siyawo, yausai auwoniyouwo. ");
INSERT INTO amm_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Hilosu mo nonani imoso kwaiki mo, na yomuki, “Asayo noinomo, woi, Iyono mo imo molomai tokosonowaikino. Ulai ninani nokota no noi, woi? Noi monoi woi, hani hani imo kolo koloma tumo liyai, woi?” Aino yomuki, Isisoso ki mulu na yoki. ");
INSERT INTO amm_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Nosai no mo; Kotoni imo lukasikalomano noko mo ifou tiki, Isisoni auso. Totaini mi analo aino imo lukasiya tumokino. Tiki mo; Isiso mo na koliyonoki, noko nokolaloso utukaikiyoukino, totaisu mo nokonu siyaso nuki. Nokonu siyolo mo Pisaito. ");
INSERT INTO amm_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Noko nokolalosu mo nu monoi imofaso kwaikino mo, namolisai na tanomo manokino. Tiki mo, ikoki, “Waliyo potiwo.” Nosai no imo lukasikoki, Kotoyo samukuko imo mo. Ai ai noko ititounikaiyaloki. ");
INSERT INTO amm_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Nosai no mo; upimoso noko molo tiwoi noko ima tumokino, “Noko nokolaloso na piko taikiyo, aumoifa nokonu nokonuso sano liyaiyu, totaini koloni na suo suomokano liyaiwumo. Ninani asi mo nokowoi asi muwoi.” ");
INSERT INTO amm_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Nosai no mo; Isiso mo na ikoki, “Ulai hani monoi? Koloni mo momaiyo na ponikowo.” Siyokutono iyaliyosu na imokino, “Koi mo koloni mo molopoi pakoso siso. Paluwa tuo komu mo naino siyai saso. La mo tiwoi. A, nono no moloi tomulumolokoni? Noko nokolalo molopoi na. Koi no koloni no moloi iyano monoi, muwoniyo no?” ");
INSERT INTO amm_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Wiyou, noko molopoi molopoi mo, 5000, na siki. Nosai no mo na ikoki, “Na pikalowo, fofamoso na sinonalu, noko siyai mo 50, noko siyai mo 50. Noinoso noinoso sinonalu.” ");
INSERT INTO amm_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Ikoki mo; aino na yokino, no monoi no noko nokolalo mo sinonaloki. ");
INSERT INTO amm_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Nosai no mo; Isiso mo paluwa tuo komu naino siyaiwoi la tiwoi akowaikoki, kumokiso you foinalikoki, wafisu imo na imoki, Apitonoso. Paluwa tuo na folouluki, siyokutono iyaliso na nikoki, noko nokolaloso wauti monoi. ");
INSERT INTO amm_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nosai no mo na no si liyaiki, noko nokolalo komaso noko mo. Touwai sisiyoli na toloko liyaiki. No waloto mo amai na siki, i molo tiwoiso na alokino. ");
INSERT INTO amm_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Nosai no mo; ulo siya mo Isiso mo Kotowoi imo lukaso yousiki, totasosu. Siyokutono iyali mo aumoifaso siki. Nosai no mo; na utolukoki, “Noko nokolalo no moloi tokaluwaimono manono? Yo no noi, woi?” ");
INSERT INTO amm_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Na fowakino, “Siyaiyo tokaluwai manoni, “Iyono iwoso uluwako nokota.” Siyaiyo tokaluwai manoni, “To mo Ilaiya.” Siyaiyo tiyamo, “Nakomo Kotoni mulu lukasiko nokota poimo, yausai ifou auwoniyouki.” ");
INSERT INTO amm_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nosai no mo na ikoki, “Momaiyo no moloi tokaluwaimononuwo? Yo no noi, woi?” Nosai no mo; Pitayo na fowaki, “Nono mo Kolaiso. Koto mo Isolilo noko koi fasimoka tumo monoi muwokaikini.” ");
INSERT INTO amm_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Nosai no mo; Isiso mo na ikoki, siyokutono iyaliso, “Woli iyali, nokoso noiyo kaluwai wiyotiyoiwo, asa monoi mo.” ");
INSERT INTO amm_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ti monoi na ikoki, “Asa, asi asi noko nokolaloni noko siyoli nokota yo mo iyanoko siyoli na uwomonoinomo. No mo afonimaiso muwoi. Kotoyo ainonani monoi na imono taikiyoki. Nokoyo iyanoko siyoli uwomonoinomo, nokotalo iyaliwoi lotu samukuko noko sisiyoliwoi Musini imo sai sisiyoli nokowoiyo. Namoliyo na alosimomonoinomo, na tukolomonoinomo, yau. Ulai amoloki tiwoi mo uwai; ulo siya mo ifou na auwoniyouwoimo, yausai.” Aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nosai no mo; noko komaso nokoso ikoki, “Nokoyo yoso aluwaimono monoi yakimo, totani muluso no moloi aluwai monoi? Yo mo a moki sokunalomakoimo. Noinoso aluwaimono nokota mani, uo nokoyo uwoyakimo, moloi ulosukomo monoi? Ulo ulo amoloki amoloki aluwaimonumo. ");
INSERT INTO amm_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Nokoyo totani au monoisu mulu unakimo, aniyopa poi poi moloi yousi itouniyaimo monoi? Na kaloimo. Nokosu mo yoso aluwaimono monoi kalakimo, pa kalokaiyoiso, aniyopa poi poi yousikaino itouniyaimo manoimo. ");
INSERT INTO amm_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Noko mo muwoni mi anakimo, asini sonosoni komasoso iyakimo, nonani haniyo no moloi fasi monoi? Kotoso mulumolo luwai somiso mo, na uwokaiyoimo. ");
INSERT INTO amm_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Noko mo nokoni molo timai aluwaimono monoi kokolomakimo, yo mani, namoliyo na alosimoimo, yani amiwoi ifou amukonomaiso, Apou Siyolini ami siyoliwoi totani kumoki noko ititounini amiwoi. Ulai afonimaiso? Yani imo aluwaimono monoi louwa, ulai nokoyo uo imo monoi kokolomo, namoliyo na alosimomono. Asa, asi asi noko nokolaloni noko siyoli nokota ya ifou amukonakimo, ya mani, namoliyo na alosimoimo, nonani nokotaso.” Aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ti monoi na ikoki, “Yo mo motuwa na timonukuwo. Noko siyai ni si mo, toi mo kolikali somisomai Kotoyo mo na samukuya tumoinuwomo.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Nonani imo ikoki mo; amoloki nano ti mo uwai; nosai no mo; Isiso mo noko tauwoi mo yuso koliyo yoki. Pitawoi Iyonowoi Yamisowoi toiso koliyo yoki, Kotowoi imo lukaso monoi. ");
INSERT INTO amm_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Kotowoi imo lukaso yousi manomai tani amu molo na alosimo taikiyoki. Totani tuno mani, na kamoko taikiyoki. Wiyouwa wiyou, unakiyoini topi. ");
INSERT INTO amm_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Wiyou, lolai siyaso toku nokota ti, Musiwoi Ilaiyawoi tokuwa toku no kolikaliki no, toti mo Isisowoi imo lukaso ni tola tumokino. ");
INSERT INTO amm_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Kotoni saponi siyoliwoi tolokainoso kokokino, Isisowoi imo lukaso toloso, tota Yolusolimo nokonumai kalo monoi, asiso utukaimo monoi. ");
INSERT INTO amm_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita iyalisu mo ulo molo moloso, ulololi si monoi louwa. Ulai auwonouluki mo, Isisoso ulo komiyai wiso na kwaikino, noko ti tolo tomasimoso kokokino. ");
INSERT INTO amm_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Nosai no mo; totiyo utukaimomai Pita mo Isisoso na imoki, “Siyoli Nokota, nimaino mo waliyo tosikoni. Fulomu nu tauwoi kololoikimo, siya mo nani, siya mo Musini, siya mo Ilaiyani.” Pita mo imo monoiso na yomuki. ");
INSERT INTO amm_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nonani imo yomu tolo manoki mo; kumoki kopuyo na fiyokaika konoki. Na kokolokoki. ");
INSERT INTO amm_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ulai ko na mo kumoki kopu mulusai na tu kwaimokino, noino na yomuki, “Ni mo yani alu na. Tani imo na pa kwaimo itouniyaimo manowo.” ");
INSERT INTO amm_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Nonani ko na yomu uwai; Isiso totaso toloso kikino. Nosai no mo; wosu woso siki, imowoi muwoi. Isiso mo asiso amai tolomai noinani aino imo pa lukasiko manokinoso. ");
INSERT INTO amm_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Amuwoisai; yusai kunoki mo, noko nokolalo molopoiyo Isisoso kiya tumokino, molomai. ");
INSERT INTO amm_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Nosai no noko nokolalo mulumai nokota mo siyoliso ima tumoki, “Aiyolokomomoko nokota, ya timonoki, yani alu ni poki. Yo mo alalo molopoi muwoi, siyasosu na. ");
INSERT INTO amm_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Saiso saiso popuwayo mo tuwokaimosi. Wiyou, saiso saiso tomomosi. Na tofafololomanikomo kaiyoumosi. Somusouwoi na totomukomomoi. Na tuwokaimosi. Uwokaimosimai somaiso kiyowoi muwoi. ");
INSERT INTO amm_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Yo mo nani siyokuno iyaliso louwa iko, popuwa koiyau amiyaikiyo monoi. Ulai toi no sai? Toi mo sosoli.” Aluni apitono mo Isisoso aino na imoki. ");
INSERT INTO amm_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Nosai no mo; Isiso mo ikoki, “Lolaimai noko nokolalo ni sinuwo mo, moi mo yoso mulumolo luwaimonowoi muwoi, moini mulu mo kwamu kwaimo muwoi, kopokoiyau. Moiwoi no moloi tolo tomasimoikuwomo? Ya tulosukomomono. Alu na pokawiyo tumo.” ");
INSERT INTO amm_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Totani alu mo lolaloso amai na potumoki, nomai no popuwa koiyauyo asiso fakukiyo taikiyoki, na fafololomanikomo kaiyouki. Ulai Isiso mo uo imo na imoki, popuwaso. Alu mo na itouniyaimokaiki, apitonoso na kau wanoniki. ");
INSERT INTO amm_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Kotoni ami siyoli anaso kwaikino mo, noko nokolalo komasoyo na kufaukoki. Noko nokolalo mulumoloko manokino mo, komaso hani hani Isisoyo no yoki no, totasu mo tani siyokutono iyaliso na ikoki, ");
INSERT INTO amm_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Yani imo na pukwaimono itouniyaimowo, ni timonukuwo no. Asa, asi asi noko nokolaloni noko siyoli nokota yo mo uo nokoni auso na kiyomono taikiyoinomo.” Aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ulai toi no nonani imo no sai? Imo folosai mo sai muwoi, sosoli. Imo folosai mo utolumo monoi nimokino. ");
INSERT INTO amm_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Nosai no mo; Isisoni siyokutono iyali mo totai amu uo imo lukasikuwanokino, siyasonuso iyamaloki, “Yo mo totawoi nokota siyoli.” ");
INSERT INTO amm_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Isisosu mo sai, toini mulu mo. No monoi no mo, alufaso kausiki, totani auso tolo tomasima tumoki. ");
INSERT INTO amm_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Na ikoki, “Mulumolo luwaimono nokotayo aluso imo mo, “Waliyo potumo,” to mo yoso mani, imono, “Waliyo na potumo.” Yoso aino imono mo, imono taikiyo nokotaso mani, imo, tumumo. Moita yomu somiso mo, “Yo mo noko siyoli,” nonani nokota mo noko siyoli nali no.” Aino na ikoki, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Nosai no mo; Iyono mo Isisoso na imoki, “Noko Siyoli nokota, koi mo noko siya kinoki, popuwa amiyaikiyoko waikoso. Nani siyolo kaluwaiyaloni, no monoi no popuwa amiyaikiyoko waikomoi. Ulai moiso pakoso taluwaimokoso. No monoi no koi mo wiyou, na alukimonoki.” ");
INSERT INTO amm_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ulai ikoki, Isisoyo mo, “Noiyo alukimoiwo. Nokoyo moiso uo mulu yo unu somiso mo, to mo woli na.” ");
INSERT INTO amm_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kotoyo kawiyo yo mo aumoifaso na, nomai no mo Isiso mo mulu amisoso, Yolusolimo nokonu siyoliso mano monoi. ");
INSERT INTO amm_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Nokoso toku iko taikiyoki, “Moi mo toku ponuwo.” Toi mo yasoi, Somaliya asi nokonu mo tiki mo, nu louwa koko foumalokino. ");
INSERT INTO amm_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ulai tolomu noko mo wiyou iyamoki, Isisoyo toini auso tana tumo monoi mo. Yuto nokota na, Yolusolimo nokonu siyoliso mano monoi, no monoi no wiyou iyamoki. ");
INSERT INTO amm_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Siyokutono noko ti, Yamisowoi Iyonowoi, toti mo ainoso kwaikokino mo, Isisoso na imokino, “Siyoli Nokota, nono no waliyo tiyomuni, ta imo monoi no? Kumokisai ta amukonumo, noko sakolouka konumo.” ");
INSERT INTO amm_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ulai Isiso mo fokutonoyo alosikoki, imo amiso ikoki, “Tofolo, yo mo wiyou tiyomu.” ");
INSERT INTO amm_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Nosai no nonani nokonuso utukaimokino, nokonu siyaso nuki. ");
INSERT INTO amm_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nosai no mo; molomai nuki. Nu liyai manoki mo, noko siyayo Isisoso na ima tumoki, “Ya taluwainoki. Isoni ausoni liyaiyalo manakinimo, yowoi foiya na aluwaiyalo manoikimo.” ");
INSERT INTO amm_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ulai na imoki, Isisoyo mo, “Asikoiyo aluwou mo asi i poiso tosi liyai. Asi i mo totaini nu na. Uo mani, niyou poiso tosi liyaimoi. Yosu mo nuwoi muwoi. Asi asi noko nokolaloni noko siyoli nokota, yo no nu haniso tano monoi? A, nono no waliyo taluwaimononi? Toku na pomulumoloko ki, waliyo poimo, wiyou poimo, aluwaimono monoi mo.” ");
INSERT INTO amm_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Nosai no mo; Isiso mo noko siyaso na imoki, “Kuku, yoso paluwaimoniyo tumo.” Ulai fowaki, “Siyoli Nokota, nono no waliyo timononi, yo mo toku apou yau tai unano. Ai unu uwai, na aluwaiyoikimo.” ");
INSERT INTO amm_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ulai Isiso mo na imoki, “Tofolo, mulumolo luwaimono somiso nokoyo noko yau yau aiko ukanowumo. Nonosu mo Kotoni samukuko imo na pa posasokalo.” ");
INSERT INTO amm_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ulai noko siyayo mani, na imoki, “Noko Siyoli, yo mo taluwainoki. Ulai nono no waliyo timononi, yo mo fuwaluwouso woiyo woiyo imo tikano.” ");
INSERT INTO amm_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ulai Isiso mo na imoki, “Nokoyo aluwaimoniyo tumo mo, namoli moloso no moloi mano monoi? Namoli moloso mano nokota no Kotoyo samuku asiso no moloi loti monoi?” Aino imoki, Isisoyo mo. ");
INSERT INTO amm_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Nosai no mo; Isiso Siyoli mo noko siyai 72so muwokoki, ti tiso iko taikiyo liyaiki. Asi asi nokonu nokonu, to mano monoi no yoki no, nosoni toku iko taikiyaloki. ");
INSERT INTO amm_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Siyokawi imo na ikoki, “Noko nokolalo molopoi mo Kotoso mulumolo luwai monoi louwa, ulai toi mo sai muwoi, toi mo sosoli. Toi mo isini aliyoli molopoi wamokokai komiyai na si, ulai isi mi ano nokota mo iya tumowoi muwoi. Isi mi ano noko mo pounu muwoi, no monoi no. Isi mi ano noko mo Kotoni mi analomano noko nali no, pounu muwoi, no monoi no Koto Siyoliso na pa imalowo, isi kiyo nokotaso, isi mi ano noko iko taikiyumo, isini aliyoli iyanowumo. ");
INSERT INTO amm_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","No monoi no mo, moi mo na ponuwo. Na pukwaimonowo. Yo mo sipo uo lolofa komiyai timo taikiyonukuwo, asikoiyo aluwouni auso nu monoi. Kotoso mulumolo luwai somiso noko mo asikoiyo aluwouyo komiyai na louwa uwokaikomoinuwomo. ");
INSERT INTO amm_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Muwoni alo iwoi noiyo ilomanoiwo. Nuwakinuwomo, iwoi noiyo ilomanoiwo. Fona su mani, noiyo ilomanoiwo. Noko nokolalo molomaiso kokakinuwomo, afonimai imo sopo noiyo lukaso nikoiwo. ");
INSERT INTO amm_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nokonu nokoni nuso takinuwomo, toku na pa ikowo, tolomu nokoso, “Mulu tomokiso na posi itouniyaimowo.” ");
INSERT INTO amm_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Mulu tomoki nokota yousakimo, to mo nonani imo kwaimoinuwomo, na yousi itouniyaimoimo. Ulai mulu tomoki nokota yousi somiso mo, pa yousi itouniyaimoiso, moi saso si itouniyaimoinuwomo, mulu tomokiso. ");
INSERT INTO amm_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nokonu takinuwo mo, nu siyasoso na pa si manowo, tanuwou monoi. Koloni nikomakinuwomo, na pa uwokowo, pa nokowo. No mo waliyo, noko mo mi anoti mo, mi anoti foli monoi fasiwumo. Nu nuso noiyo nu liyaiyoiwo, nu siyasoso na pa si manowo, nokonuso takinuwomo. ");
INSERT INTO amm_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Nokonuso waliyo takinuwomo, koloni nikomakinuwomo, waliyo na pa uwokowo, na pa nokowo. ");
INSERT INTO amm_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ai ai noko nokolalo na pa ititounikaiyalowo. Tolomu nokoso na pa ikowo, “Koto mo aumoifaso na samukuyoinuwomo.” ");
INSERT INTO amm_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ulai nokonu siyaso timai mo waliyo imo somiso mo, nonani nokonu mulumaiso pa sanowo, na pa ikowo, ");
INSERT INTO amm_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Moini asi topamu koini fonaso no tololomanikokai no, no mo ifou na tokitotasokononi kaiyounukuwo. Atiyaiyasu na pomulumolokowo, Kotoyo moi samukukomo monoi louwa.” Aino na pa ikowo. ");
INSERT INTO amm_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Ya na timonukuwo, asi fokumakimo, Sotomo noko kopokoiyau noko no mo, toi mo koufa uwokoimo. Namoliyo alosikomo nokosu, toi mo soliyakiso na uwokoimo. Ulai koufa, soliyaki nali.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Isiso mo ti monoi na ikoki, “Woi, Kolasi noko moi, woi. Woi, Pisaito noko moi mani, woi. Yo mo mulu ifolaluwawoi mi pano manoki, nonani nokonu timai, Yuto noko moini molo timai, ulai molo koiyau monoi mulu kolikaliwoi muwoi, mulu pa alosokokinuwoso. Yo mo nonani mulu ifolaluwawoi mi pano mo, noko nokonu nokoni molo timai, Taiya nokonuwoi Saito nokonuwoiso, mulu na pokolikali, asi pokoukono, ta nuso papoloiyo konokai, toini molo koiyau monoi, mulu palosokono. ");
INSERT INTO amm_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Koto mo noko wauwakimo, Taiya nokowoi Saito nokowoi, toi mo koufasoso uwokoimo. Kolasi noko moiwoi Pisaito noko moiwoi, moi mo soliyakiso na uwokomoinuwomo. Ulai koufa, soliyaki nali. ");
INSERT INTO amm_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Kopanaumo noko, a, moi no kumokiso nuwoinuwomo a? Ya timonukuwo, pa nuwoinuwoso. Taso na kunoinuwomo.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ti monoi ikoki, “Nokoyo moini imoso kwaimakinuwomo, yani imo mani, kwaimonoimo. Nokoyo namoliyo alosikomakinuwomo, yoso mani, namoliyo alosimomonoimo. Nokoyo namoliyo alosimomonakimo, imono taikiyo nokotaso mani, namoliyo alosimoimo.” Aino ikoki. Ikoki mo; na nu liyaiki, nonani noko 72 mo. ");
INSERT INTO amm_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Nosai no mo; noko 72 mo ifou na tiki, na molokiya tumokino. Na ima tumokino, “Noko Siyoli, nani ami mo wiyou. Popuwa iyali mani, imo na tukwaimokalo manono.” ");
INSERT INTO amm_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Nosai no mo; Isiso mo siyokutono iyaliso na fowakoki, “Motu na, yo mo Sokolo Nokota Waiso toku na kwaiki, kumokisai usukuno taikiyoso, saloma komiyai momaliyomalo konoso. ");
INSERT INTO amm_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Pukwaiwo. Yo mo ami siyoli yasoi na anonikinukuwo. Nuwowoi apiyumoiwoiso towitoloko manoinuwomo, asani amiyo. Uo nokota waini amiso na souwaiyaloinuwomo. Hani koiyauyo pakoso uwokaikomo manoinuwoso. ");
INSERT INTO amm_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Motu na, popuwa iyaliyo imo tukwaikomalo manonuwo. Ulai ainonani monoi moloki mo koufasu. Moloki siyoli mo noino, momaini siyolo siyolo mo kumokiso yasoi na kulukaiki. Ainonani monoi siyoliso na pa molokiwo.” Isiso mo ainoso na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Nosai no mo; nonani ulo yakomai Kotoni Mulu Itouniyaimo Nokotayo noinomo Isiso mo moloki mulu saso. Apitonoso na imoki, “Apou, nono mo kumoki asi asi samukuko nokota siyoli. Ya na tomolokimonoki, wafisu. Noko no tiyamo no, “Koi mo mulu mo iwoi.” toi mo nani samukuko mi mo sainowoi muwoi, sosoli. Noko siyai no tiyamo no, “Koi mo sai siyoli muwoi,” toisu mo sai, nani samukuko mi monoi mo, yasoi wiyotikini. Nasu, Apou, nani mulu itouniyaimo mo ainoso na. No monoi no wafisu timonoki.” Ainoso imoki, Apitonoso. ");
INSERT INTO amm_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Nosai no mo; nokoso ikoki, “Yani Apou mo hani hani komaso mo yani nainomai yasoi na isikokaimomonoki. Ulai noko mo asa monoi mo sainowoi muwoi, Kotoni awitono monoi mo. Apou Siyoli saso mo sai, asa monoi mo. Ulai noko siyayo mo Apou Siyoli no sai? Asa, Kotoni awitono asayosu mo sai. Noko nokolalo siyai mani, sai. Ya na towiyoti.” Aino ikoki. ");
INSERT INTO amm_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Nosai no mo; siyokutono iyaliso alosikoki, fokutonoyo, toi saso ikoki, “Nokoyo moi komiyai kiyakinomo, siyoliso na molokiyoinomo. ");
INSERT INTO amm_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","No monoi no ya timonukuwo. Toku mo Kotoni mulu lukasiko nokowoi nokotalo sisiyoliwoi, toi mo ninani ki monoi louwa, ni tokinuwo no, ulai toi mo kiwoi muwoi. Ninani imo kwai monoi louwa, ni tukwainuwo no, ulai toi mo kwaiwoi muwoi.” Isiso mo aino na ikoki, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Nosai no mo; aniyopa imo sai siyoli nokota mo auwoniyouki, Isisoso na utolumo kiki, “Aiyolokomomoko nokota, yo no moloi yoimo woi, aniyopa poi poi tolokaino itouniyaimo monoi no?” ");
INSERT INTO amm_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Nosai no mo; Isiso mo na imoki, “Musini ami imoyo no moloi tiyomuko? Nonani imo lukasikomai moloi tiyomuni?” ");
INSERT INTO amm_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nosai no mo; na fowaki, “Noino na tiyomuko, “Koto monoi mulu punu. Noko Siyoli, nonani Koto monoi, mulu siyoliso na pa unu. Na pa aluwaimoi. Na pa mulumoloko unu.” Noinoso mani, tiyomuko, “Nona amu mulu no tiyo manoni no, noko nokolalo monoi mani, noinoso na pa mulu ukumoi.” ");
INSERT INTO amm_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Nosai no Isisoyo na imoki, “Aino, motu na tofowamononi. Ainoso yakinimo, aniyopa poi poi na tolokaino manoinimo.” ");
INSERT INTO amm_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ulai aniyopa imo sai siyoli nokota mo noko itouniyaimo tolo mulu yoki, no monoi no Isisoso na imoki, “Noiwo noko nokolalo monoi tiyomuko?” ");
INSERT INTO amm_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ulai Isiso mo fowaki mo, siyokawi imo na lukasiyoluwaiki, noino imoki, “Yuto nokota mo Yolusolimo nokonu siyoliso tutukaimiyou, Iyoliko nokonuso louwa tamukono. Ulai uo nokoyo molomai na tokino. Tuno na ti wanonino, na tuwasono. Nosai no tutukaimono, aumoifaso kalo monoi louwa. ");
INSERT INTO amm_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Nosai no mo; Yuto nokota siya mo nonani moloso taluwainiyo kono, lotu samukuko nokota nali. Ulai molomai tano nokotaso tokikaiyou. Na tosouwo, molo kwasai na tomoi, yasoi. ");
INSERT INTO amm_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Nosai no mo; Yuto nokota siya mani, nonani moloso taluwainiyo kono, Liwaini alisaitono na. Nosoni tofiyamosiya tumo mo, ainoso na tokikaiyou. Na tosouwo, molo kwasai na tomoi, yasoi. ");
INSERT INTO amm_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ulai Somaliya asi nokota mani, nonani moloso taluwainiyo kono, noko nokonu nokota na. Molomai tano nokotani auso totumo mo, na toki, mulu na tokalo unu. ");
INSERT INTO amm_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Tani auso aumoifaso tokiyano. Nosai no uluoso iwoyo na tosololukimo, woilo iwowoi molo wamo ito iwowoiyo. Tunoyo na tokonosuwakomalo. Uwai; totani hosofani namoli tonimai tokauwokaiya yo. Tanuwou nuso tokau. Na tosamuku itouniyaimo tolo. ");
INSERT INTO amm_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nosai no mo; amuwoisai; Somaliya nokota mo tomoki muwoni tiwoi na takononi, nu kiyo nokotaso. Na timo, “Ninani nokota mo atiyaiso na pa samukumoi. Muwoni mo uwofawo, ya ifou tumakimo, na niyoikimo, muwoni siyaiwoi.” Isiso mo siyokawi imo aino lukasiyoluwaiki, aniyopa imo sai nokotaso. ");
INSERT INTO amm_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Nosai no na imoki, Isisoyo, “Moloi tomulumolokoni? Noko tauwoi ti. Uo nokoyo uwokai nokota, noini wolitono itouniyaimo?” ");
INSERT INTO amm_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Aniyopa imo sai siyoli nokotayo na fowaki, “Mulu no kalo unu no, suomoso monoiso no fasi no, to mo wolitono nali.” Nosai no Isisoyo na imoki, “Na pomoi, ainoso na piyano.” ");
INSERT INTO amm_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ulai nosai no mo; nuki nuki nuki; nukutai siya mo tiki. Noni mo tolosoki, tani siyolo mo Mata. Isiso iyaliso na ikoki, “Koi kolini auso na pona tiwo.” ");
INSERT INTO amm_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mata mo auwatonowoi, tani siyolo mo Moili. Moili mo na sisa tumoki, Isiso Siyolini auso, tani fona timai, imo kwaimo sisa tumoki. ");
INSERT INTO amm_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Matasu mo koloni ta no tolosoki. Wiyou, mi mo soliyaki. No monoi no mulu mo puwoso, Isisoso imanoki, na imoki, “Noko Siyoli, yani auwa mo mi pa tano fasimonoso. Asa saso na tanomoi. Hani monoi pa tomulumoloko unumononiso? Na piso, fasimonumo.” ");
INSERT INTO amm_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ulai isoki, “Woli Mata, nono mo hani hani monoi tomulumoloko manoni, mulu tokalo ukalo manoni. ");
INSERT INTO amm_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Siya hani mo koma na. Moili mo nonani monoi mulu na tiyo. Wiyou no moloi alukiso monoi?” Isiso mo ainosu na isoki, Mataso. ");
INSERT INTO amm_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Nosai no mo; Isiso mo foloso monoi imo lukaso yousanoki, Kotowoi. Imo lukaso uwai; siyokutonoyo na imoki, “Noko Siyoli, Kotowoi imo lukaso monoi powiyomoko, toku Iyonoyo no wiyotiki no, totani siyokutono iyaliso, noinoso.” ");
INSERT INTO amm_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Na ikoki, “Kotowoi imo lukasakinuwomo, noino na pa imowo, “Apou, nono mo itouniyaima itouniyaimo nokota. Nani siyolo na tokaluwaiyalounoki. Na posamukumoka tumo. ");
INSERT INTO amm_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ulo siyamai koloni saiso saiso na pa nimokomoi. ");
INSERT INTO amm_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Nokoyo kopokoiyau komomokakinomo, koi mo imowoi muwoi, waliyo. Nono mani, kokaini molo kopokoiyau monoi imo mo na pa tokosokiko. Sokolo Nokota Wai monoi na pa samukumokomoi, aiko ainikomomoko ifoluwaimokoi.” Kotowoi imo lukaso ni aino imo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Nosai no mo; na ikoki, siyokawi imo mo, “Moi nokota mo totolo. To mo siyokutono mo yapoli. Amoloki siyolimai mo siyokutonoso na timano, “Woli, tuo komu tauwoi na pakomono. ");
INSERT INTO amm_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Yani woli mo nuso kimona tumo. Ulai yo no tuo no haniso ni monoi? Uwofa na.” ");
INSERT INTO amm_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Nosai no mo; totu fowa, nu poisai, “Mi siyoliso noiyo amonoi. Itu mo pu na totoi. Koi koli mo ulololi tosinoki. Yo no moloi auwono monoi, tuo akononi monoi no?” Siyokutonoso aino totu imo. ");
INSERT INTO amm_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ulai ya timonukuwo, nu kiyo nokota mo asisikuwano monoi pa takononiso, siyokutonoso. Ulai siyokutonoyo tofu yomu tolomoi, tuo anoni monoi. Tiyomalo tiyomalo, wiyou nu kiyo nokota mo tulosukomo, na tauwoniyou, na takononi, tuo somiso nokotaso. ");
INSERT INTO amm_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","No monoi no mo, ya timonukuwo, Kotoso na pa utolumo manowo, no monoi no nikomoinuwomo. Na pa ikolikalowo, no monoi no kokoinuwomo. Itu lotiso pa ukou ukou nimo manowo, no monoi no itu na kolali unoinuwomo, Kotoyo, moini imo kwaimoinuwomo. ");
INSERT INTO amm_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Noko mo Kotoso haninoi monoi utolumo manakimo, nonani hani na aninoimo. Nokoyo haniso ikoliyalakimo, na kiyoimo. Nokoyo itu lotiso ukou ukou nimo manakimo, itu na kolali unoimo, imo kwaimoimo. ");
INSERT INTO amm_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Apitono iyali moi ni tosinuwo no, moi mo na pukwaimonowo. Aluyo apitonoso imo mo, “Tiya tokalomono, la pasomono.” Ulai momai koiyau no moloi anoni monoi, apitonoyo no, aluso no? Wiyou nali. ");
INSERT INTO amm_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ti monoi timo, apitonoso, “Tiya tokalomono, uo i pasomono.” Ulai apiyumoi koiyau no moloi asononi monoi, apitonoyo no, aluso no? Wiyou nali. ");
INSERT INTO amm_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ulai mulu kopokoiyau noko moi mo, itouniyaimo hani suomoso monoiso na tuwoko manonuwo, moini alaloso. No monoi no moi mo sai, moini Apono mani, kumokiso ni you tolo no, to mo totani Mulu Itouniyaimo Nokota na tanoninuwo, totaso utolumo manakinuwomo.” Aino ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Nosai no mo; Isiso mo popuwaso amiyaikiyowaiki, ko lopumokai nokotaso. Popuwayo nokoso utukaimoki mo; nonani ko lopumokai nokotayo imo na lukasoki. Wiyou, noko nokolaloyo mulumoloko manokino. ");
INSERT INTO amm_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ulai noko siyai mo piyamoki, “To mo popuwa mo Pilisipulo Waini amiyo na tamiyaikiyoko uwokomoi, popuwa samukuko nokota siyolini amiyo mo.” ");
INSERT INTO amm_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Siyai mo na imo kikino, imokino, “Kumoki mulu ifolaluwawoi mi na powiyomoko, kokaini molo timai.” ");
INSERT INTO amm_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ulai Isiso mo toini mulu mo sai, na ikoki, siyokawi imo mo, “Asi siya noko iyaliyo totai amu tukoluwanakinomo, totai amu pa asisikuwanoinoso, na uwokaikuwanoinomo. Noko koliyo totai amu tukoluwanakinomo, na kolikaliyoimo, yau yau, totai amu asisikuwano somiso mo. ");
INSERT INTO amm_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Sokolo Nokota Wai iyali totai amu potukoluwanono mo, totai amu pa pasisikuwanonoso, kwaimo pa posiso. Ulai hani monoi tiyamonuwo, Pilisipulo Waini amiyo popuwaso amiyaikiyokowo. ");
INSERT INTO amm_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ulai yo no Pilisipulo Waini amiyo no moloi amiyaikiyoko monoi, popuwa no? Moini mulumai mani, popuwa amiyaikiyoko noko siyaiyo na tosi liyai. A, noini amiyo tamiyaikiyoko manono? Kotoni amiyo nali no. Totaiyosu na imoinuwomo, “Topokonuwo, Pilisipulo Waini amiyo no moloi amiyaikiyoko monoi, popuwa no?” ");
INSERT INTO amm_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Motu na, Kotoni amiyo na tamiyaikiyokomoi, yo mo. No monoi no moi mo sai, Kotoni amiyo yasoi na samukuya tumokinuwo.” Aino ikoki. ");
INSERT INTO amm_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Siyokawi imo ti monoi na ikoki, “Ami nokota mo toni lamo tokomiko tolo, tani nu mo na tosamuku tolo. Ilolu no moloi i wanoni monoi? ");
INSERT INTO amm_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ulai ami soliyaki nokotayo uo ano una tumakimo, na souwaiyoimo. Toni lamo na salosowaiyoimo, toni lamo no amimo no. Ilolu i waninoimo, noko siyaiso wautiyaloimo.” Isiso mo siyokawi imo aino na ikoki, na posaso wiyotiki, tani ami mo Sokolo Nokota Waini amiso tosouwaimoi. ");
INSERT INTO amm_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ulai ti monoi ikoki, “Noko mo yani woli tolo somiso mo, koti mo uowoi. Noko mo yani imo lukasikalo somiso mo, nonani nokota mo noko nokolalo tuwokaiko, no monoi no folo folo na tulolo liyai.” Isiso mo aino ikoki. ");
INSERT INTO amm_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Nosai no mo; siyokawi imo na ikoki, “Popuwa koiyau mo nokoni ausai tutukaimo mo, nu somiso asiso tomoi, mi louwa tofou foukano. Ulai tiyomu, “Yo mo ifou na tomoi, nokoni au poiso. Toku yo no tu toloki no, nonani au poiso totolano, yo mo.” Yasoi. ");
INSERT INTO amm_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Nokoni au mo ifou totumo mo, aso itouniyaimokaiso tokiya tumo, kouwokaiso. ");
INSERT INTO amm_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","No monoi no mo popuwa siyai, 7 mo, na tokolisano. Ami ami, totawoi popuwani amiso tosouwaino. Na toti, nonani nuso tosa ti. Toku mo nonani nokota mo koiyau potolokainoki. Ulai lolai mo wiyou, koiyauwa na totolokaino.” Aino ikoki. ");
INSERT INTO amm_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Isiso mo nonani imo lukasiko manoki mo, noko nokolalo molopoiyo ukouniyaiko siki. Nosai no mo, noni mo siyoliso yomusoki, “Noni no kikini no, nano no anonikini no, to mo na molokiyumo.” ");
INSERT INTO amm_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ulai fowasoki, “Motu na, ulai Kotoni imo kwaimo noko, toi mo siyoliso na molokiwumo, tani imoso aluwai noko mo.” ");
INSERT INTO amm_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Nosai no mo; noko nokolalo molopoi ukouniyaikokukaikino mo, Isiso mo na ikoki, “Lolaimai si noko nokolalo moi mo mulu kopokoiyau. Mulu ifolaluwawoi mi saso wiyononi monoi tiyo manonuwo. Ulai yo mo pa wiyononinoikuwoso. Iyona tolomai Koto mo mulu ifolaluwawoi mi wiyotiki, noko nokolaloso. Noinososu na wiyononinoikuwomo, yo mo. ");
INSERT INTO amm_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Iyonaso no uwoki no, no mo Kotoyo Niniwa nokoso na wiyotiki, totayosu muwokaiki. Noinoso na, asi asi noko nokolaloni noko siyoli nokota yoso no uwomonakino mo, Koto mo lolaimai si noko nokolaloso na wiyotiyoimo, totayoso muwomonokaiki. ");
INSERT INTO amm_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Koto mo noko nokolalo wauwakimo, aluwaso noko samukuko nukonu siyoli, tokuwa toku no tolosoki no, to mo auwonisiyou tomasima tumoinuwomo, lolaimai si noko nokolalo moiwoi. Moi monoi na yomusoimo, “Kwaimo muwoi, kopokoiyau.” Ulai afonimaiso? Afonimaiso muwoi. Nonani aluwaso nukonu siyoli mo Solomononi imo itouniyaimoso kwaima tumoki. Lolaimai yo mo ni totola tumo mo, Solomonoso na tosouwai. Ulai lolaimai si noko nokolalo mo yani imo mo kwaimonowoi muwoi. No monoi no uwokaikomoinuwomo. ");
INSERT INTO amm_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Koto mo noko nokolalo wauwakimo, Niniwa noko nokolalo mani, auwonoulu tomasima tumoinuwomo, lolaimai si noko nokolalo moiwoi. Moi monoi na iyamoimo, “Kwaimo muwoi, kopokoiyau.” Ulai afonimaiso? Afonimaiso muwoi. Niniwa noko nokolalo mo Iyonani imo kwaimokino, mulu na alosokokino. Lolaimai yo mo ni totola tumo mo, Iyonaso tosouwai. Ulai lolaimai si noko nokolalo moi mo yani imo mo kwaiwoi muwoi. No monoi no uwokaikomoinuwomo.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Ulai Isiso mo ti monoi ikoki, “Noko mo lamu ta falosisakimo, fiyokaisowoi muwoi. Nau mani, moloi ufiyaiso monoi? Wiyouwa wiyou. Puwoso na tafonikokaisomoi. No monoi no nokoyo nu poiso toti liyai mo, lamu ta fupiniyaimoso na tokiya tino. ");
INSERT INTO amm_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Moini molo ti mo lamu ta komiyai towi kolo, moini au poiso. Moini molo ti mo itouniyaimoso sakimo, moini mulu mani, saponiwoi na soimo. Ulai moini molo ti kopokoiyauso sakimo, moini mulu mani, folosu na soimo. ");
INSERT INTO amm_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","No monoi no atiyaiso na pa siwo. Wonikaluso moini fupiniyaimoso folosu koiyauyo uwokaiya toimo. ");
INSERT INTO amm_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Mulu mo fupiniyaimo tanakimo, folosu mo pa tanoiso, saponi saso na tanoimo, lamu ta komiyai fupiniyaimo kolokomoinuwomo.” ");
INSERT INTO amm_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Isiso mo imo lukaso uwai; nosai no mo; Falisi moloso aluwai nokotayo mo aliyoniki, no fasiya tumo monoi. No monoi no tani nu poiso lotiki, no fasi yousa tiki. ");
INSERT INTO amm_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Nonani Falisi moloso aluwai nokota mo Isisoso no yousiso kwaiki mo, na mulumoloko manoki. Ulai afonimaiso? Isiso mo naino toku uluwakomowoi muwoi. Yuto iyalini molo mo noino na, nainoso toku puluwako manokino, nosai no mo koloni no. ");
INSERT INTO amm_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ulai Isiso Siyoliyo na imoki, “Falisi moloso aluwai noko moi mo nau asiyofolosaiso tuluwako manonuwo. Ulai moini mulu poiso mo wofu wofuwoi muwoi, polamoko mulu saso moi mo, mulu kopokoiyau na. ");
INSERT INTO amm_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Moi mo muluwoi muwoi. Asiyofolosaiwoi mulu poisowoi mo Kotoyo na fonanikomoki. ");
INSERT INTO amm_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Ulai poiso no tu si no, momaini mulu na, nonani mulu na pa kolikali ukuwo, afonimai noko monoi, na pa fasikowo. Aino yakinuwomo, mulu wofu wofuwoi soinuwomo. ");
INSERT INTO amm_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Ulai Falisi moloso aluwai noko moi fau, atiyaiso na posiwo. Moi mo sumonowoi soiwoi hani hani nofuwa nokowoi naino ti tokunoloko manonuwo, kunolokokai siyasonuso Kotoso toni manonuwo. Kotoni imo ainoso taluwai manonuwo. Ulai molo siya pa taluwai manonuwoso. Noko nokolaloso atiyaiyaso pa tuwoko manonuwoso. Koto monoi pa tomulu unu manonuwoso. Nofuwa noko kunolokokai siyasonuso Kotoso ni mo waliyo. Ulai noino mani, noko nokolaloso atiyaiso na pa uwoko manowo, Koto monoi mulu na pa unuwo.” Aino ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Ti monoi ikoki, “Falisi moloso aluwai noko moi fau, atiyaiso na posiwo. Lotu numai nokotalo iyalini nu simai sinono monoi tiyo manonuwo, noko nokolaloyo kwaikomo monoi tiyo manonuwo. Ukouniyaikomai nokoyo “woli iyali moi kuo” imo moiso imo monoi tiyo manonuwo. ");
INSERT INTO amm_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Moi fau, atiyaiso na posiwo. Moi mo noko yau yau aiko uku asi komiyai. Noko mo sai muwoi, kopokoiyau monoi asi wosuwoiso no ku si no, asi puwosaiso toliyaikuko manono.” Aino ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ulai aniyopa imo sai siyoli nokotayo fowaki, “Aiyolokomomoko nokota, koi mani, na tauwosisimomokoni.” ");
INSERT INTO amm_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Nosai no mo; Isiso mo na ikoki, “Aniyopa imo sai sisiyoli noko iyali moi mani, moi fau, atiyaiso na posiwo. Noko nokolaloso tofololuwaiko manonuwo, hani hani au imo tiko manonuwo. Ulai moloi aluwai monoi, toi no? Wiyou, muwoli siyoli komiyai tuwokomoi. Ulai moi no fasikonuwo? Pa tofasiko manonuwoso. ");
INSERT INTO amm_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Moi fau, atiyaiso na posiwo. Aniyopano iyaliyo Kotoni mulu lukasiko noko iyaliso potukuwoli liyai manokino, yau yau. Nonani yau yau nokoni asi aiko uku moiyo tokouwoko manonuwo. ");
INSERT INTO amm_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","No monoi no koi mo sai tukuwoli monoi mo waliyo tiyamonuwo. Aniyopano iyaliyo potukuwoli manokino, yau yau. Moi mani, mulu mo tomoso, asi aiko uku na tokouwoko manonuwo. ");
INSERT INTO amm_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","No monoi no mo, mulu iwoi nokota Koto mo na yomuki, “Yo mo yani mulu lukasiko nokowoi yani imo lukasikalomano nokowoi kiyokoimo, toini auso. Ulai siyai mo na tukuwoliyoinomo, siyai mo amiyaikiyokoinomo.” ");
INSERT INTO amm_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Kumoki asi asi fonanikomosai mo Kotoni mulu lukasiko noko iyaliso potukuwoli liyai manokino. Toku totawoi mo Aipolo tukolokino. Nosai no Kotoni mulu lukasiko noko iyali tukuwoli liyai manokino tukuwoli liyai manokino tukuwoli liyai manokino; ainoso hani Sokolaiya mani, na tukolokaikino, lotu nu siyoli asiyofoloso, koloni utu kotisokosai. Ulai ya timonukuwo, lolaimai si noko moi mani, molo koiyau tomoso na taluwai manonuwo. No monoi no Kotoyo na uwokomoinuwomo, aniyopano iyaliyo tukuwoli foli monoi mo. ");
INSERT INTO amm_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Aniyopa imo sai sisiyoli noko iyali moi fau, atiyaiso na posiwo. Moi mo Kotoni mulu saino monoi na talukiko manonuwo. Ulai moi no taluwainuwo, Kotoni muluso no? Pa taluwainuwoso. Noko siyai mani, no louwa taluwaino no, toiso mani, na talukiko manonuwo.” Isiso mo aino na ikoki, aniyopa imo sai sisiyoli noko iyaliso. ");
INSERT INTO amm_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Nosai no mo; Isiso mo amufuki. Wiyou, nokotalo iyali mo uo mo ta topi. Mulu atolosai hani hani imo utolumalo manokino, Musini imo sai sisiyoli nokowoi Falisi moloso aluwai noko iyaliwoiyo. ");
INSERT INTO amm_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Utolumalo ki manokino, asuwo imo koiyau yomoimo, toiyo komanoso faumiko monoi. ");
INSERT INTO amm_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Noko nokolalo molopoi ukouniyaiko liyaiya tumoki. Ulai siyasonuso, molopoi molopoi molopoi, wiyou. Naino fona no moloi ilomani monoi? Nosai no mo; Isiso mo siyokutono iyaliso toku na ikoki, siyokawi imo mo noino, “Falisi moloso aluwai noko monoi atiyaiso na pa siwo, totaini sisiyoliko asu monoi mo. Toini topoko imo monoi timonukuwo, atiyaiso. ");
INSERT INTO amm_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Hani hani mo fiyokaikokai sakimo, amuwoi tino mo na fiyamosokoimo. Hani hani mo kukalokokai sakimo, nokoni molo timai fiyamosokoimo, toi saino monoi. ");
INSERT INTO amm_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Imo mo folosumai lukasakinuwomo, noko nokolaloyo saponimai kwaiyoinomo. Imo mo nu poiso wosu woso lukasakinuwomo, nonani imo mani, nokoyo siyoliso posasoko taikiyoinomo.” Siyokutono iyaliso aino ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Ti monoi ikoki, Isiso mo, “Woli iyali, ya timonukuwo. Au monoiso tukuwoli noko monoi noiyo kokolokomoiwo. Nosai no moloi uwokomo monoi, moiso no? Moini mulu mo waliyo. ");
INSERT INTO amm_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Moi uwokaikomo taikiyo nokota ya wiyononinoikuwomo, moi nimo monoi. Tani fiyo wosuwoimai tosi manonuwo. To mo Koto nali. Mulumolo luwai somiso mo, au mo uwokaikomoinuwomo, mulu mani, uwokaikomoinuwomo, taso utoinuwomo. Nasu, ya timonukuwo, nonani nokota monoi na pa nimowo. ");
INSERT INTO amm_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Moi mo sai, soso mo uo mo lolofa, lolofa nali. Ulai Koto mo uo lolofa monoi pa tofufolikomomoiso, na tosamukukomoi. ");
INSERT INTO amm_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Moi monoisu momaini komu suwo komaso yasoi na kolalikai. Wiyou, atiyaiyaso na tosamukukomo itouniyaimo manonuwo, mulumolo luwai noko iyali moi mo. Noiyo kokolokomoiwo. Moi mo uo lolofa tosouwaiko manonuwo.” Aino ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Nosai no mo; ti monoi ikoki, Isiso mo, “Ya timonukuwo, noko mo yani siyolo kaluwaimono wiyotiyakimo, noko nokolaloso, asi asi noko nokolaloni noko siyoli nokota yo mani, tani siyolo na kaluwai wiyotiyoimo, Kotoni kumoki nokoso. ");
INSERT INTO amm_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ulai noko mo noko nokolaloni molo timai namoliyo alosimomonakimo, asayo mani, nonani nokotaso namoliyo na alosimoimo, Kotoni kumoki nokoni molo timai mo. ");
INSERT INTO amm_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Asa, asi asi noko nokolaloni noko siyoli nokota yoso imo koiyau imonakinomo, Koto mo nonani imo koiyau foli monoi imo mo futo, yoso mulumolo luwaimonakinomo. Ulai noko mo Kotoni Mulu Itouniyaimo Nokotaso alisiyoliyakimo, Koto mo nonani alisiyoli imo foli monoi imo mo futo muwoi, amai. ");
INSERT INTO amm_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Lotu nu samukuko noko sisiyolini molo timai kiyokomakinuwomo, komano noko sisiyoli nokoni molo timai sakinuwomo, nokotalo iyalini molo timai, nomai no mo mulu mo noiyo kolikaliyoiwo, hani imoso ikonuwowo. ");
INSERT INTO amm_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Kotoni Mulu Itouniyaimo Nokotayo na wiyononinoinuwomo, no ikakinuwo no.” Isiso mo aino ikoki. ");
INSERT INTO amm_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Nosai no mo; noko nokolalo molopoi mulumai nokotayo Isisoso na imoki, “Aiyolokomomoko nokota, auwaso na pa imo, apouyo ilolu utai siyai nimonumo.” ");
INSERT INTO amm_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Nosai no mo; Isiso mo na imoki, “Moloi woi? Noiyo muwokaimonoki, ilolu wau imo kwaimo monoi no? No mo yani mi muwoi.” ");
INSERT INTO amm_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Nosai no noko nokolaloso ikoki, “Atiyaiso na pa siwo. Ilolu molopoi i mulu noiyo yaloiwo. Si itouniyaimo mo ilolu molopoiwoi siwoi muwoi. Si itouniyaima mo folo.” ");
INSERT INTO amm_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Nosai no mo; siyokawi imo na ikoki, “Ilolu molopoi nokotani isini aliyoli molopoi tauwonoulu, na tuwamokokai si liyai. ");
INSERT INTO amm_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","No monoi no nonani nokota mo tani muluyosu tomulumoloko, “Yo no moloi tiyo, woi? Isini aliyoli no moiso tisikokai, woi?” ");
INSERT INTO amm_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nosai no tiyomu, “Yo mo noino na tiyo, yani no isikokai nu lolofa lolofa tulaloko. Sisiyoliso kololi ukoimo. Isini aliyoli komaso nosoni tu uwokokaiyaloimo, hani hani iloluwoi. ");
INSERT INTO amm_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Isikokaiyakimo, yo mo noino mulumolokoimo, isini no ititouni molopoi molopoi isikokaikai, amuwoi tino tiya monoi. Aisamu aisamu pa uwaimoiso. Yo mo mi na tofou foukalomoi, no moloki yousi saso mo waliyo, yo mo na tosomaimo yousimoi.” ");
INSERT INTO amm_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ulai Kotoyosu na timo, “Nono mo muluwoi muwoi. Lolai amolokimai na kaloinimo, yau. Komaso hani hani no isikokai manokini no, noiyo moloi iyoimo?” Siyokawi imo aino ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ulai ikoki, “No monoi no ilolu isikokai noko komaso noko mani, totai amu isikokaiyakinomo, ainoso na uwokaikoimo, Koto monoi mulu fufolikakimo.” Aino ikoki, Isiso mo, siyokawi imo mo. ");
INSERT INTO amm_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Nosai no mo; Isiso mo siyokutono iyaliso na ikoki, “No monoi no ya timonukuwo. Mulu mo noiyo kolikaliyoiwo, momaini si monoi mo. Noiyo iyamoiwo, “Moi no haniso tonokoni, woi?” Ulai mulu noiyo kolikaliyoiwo, momaini au monoi mo. Noiyo iyamoiwo, “Moi no tuno no haniyo asisiko monoi, woi?” ");
INSERT INTO amm_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ulai sinono no koloni saso? Au no ulai kouwo saso? ");
INSERT INTO amm_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Uo monoi na pomulumoloko ukuwo. Toi mo aliyoli ali pa tikai manonoso, isini aliyoli pa ti manonoso. Koloni isikokai nu mo uwofa. Ilolu nu mani, uwofa na. Ulai Kotoyosu mo na tonikomoi, koloni mo. Noko nokolalo moi mo uo lolofaso na tosouwaiko manonuwo. No monoi no moi mani, Kotoyo na tosamukukomo manonuwo. Mulu mo noiyo kolikalikaiyoiwo. ");
INSERT INTO amm_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Kalo monoi mulu kalo mo, moi nokota siya no ulai ti monoi no alu komiyai no moloi wiyono monoi? ");
INSERT INTO amm_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Moi mo sai muwoi, sosoli na. Kotoni molo timaisu mo siyoli hani muwoi, koufa na. No monoi no koloni ilolu monoi mani, mulu mo noiyo kolikaliyoiwo. Kotoni ami mo siyoli. ");
INSERT INTO amm_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","A uso na pomulumolokowo. Afonimaiso na tofofoliko manono. Toini mi anosai muwoi, afonimaiso nali. Ulai ya timonukuwo. Solomono mani, kou ititouni nokota toku no toloki no, ulai tani kou mo a uni kou komiyai muwoi. Wiyou, a uyo souwaikino. ");
INSERT INTO amm_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Motu na, sosono mo konoi monoiso kiso totoloko. Amuwoi mo isiko utoinomo, taso. Nonani sosono Kotoyo tokouwokokaimoi. Moisu mo sosonoso na tosouwaiko manonuwo. No monoi no mo Koto mo na tosamukukomo manonuwo. Moini mulumolo luwai mulu no, a, koufasu, woi? ");
INSERT INTO amm_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","No monoi no noiyo mulumoloko manoiwo, haniso noinuwomo, haniso sikoinuwomo. Mulu noiyo kolikaliyoiwo. ");
INSERT INTO amm_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Mulumolo luwai somiso nokoyo ilolu mulu monoisu tiyo manono. Moini Apono mo sai, afonimaiso sakinuwomo, no monoi no fasikomoinuwomo. ");
INSERT INTO amm_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Hani hani ilolu mulu noiyo yoiwo. Kotoyo samukukomo mulu monoi saso na pa yo manowo. No monoi no hani hani mani, nikomoinuwomo.” Aino ikoki, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Ulai ikoki, siyokutono iyaliso, Isiso mo, “Moi mo sipo uo komiyai tosinuwo, pounu muwoi. Ulai noiyo kokolokomoiwo. Moini Apono mo mulu mo waliyo, moi monoi, na yomukaiki, noko nokolaloso samukuko fasiyoinuwomo. ");
INSERT INTO amm_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ilolu mo suo suomoko nokoso pa nikowo, suo mo muwoni. Nonani muwoniyo afonimai nokoso na pa fasikalowo. Muwoni alo i mo tolikikokai. Kumokini hani hani ititouniso na pa iwo. Kumokiso hani hani mo kopokoiyaukowoi muwoi, polamoko nokoyo aumoifaso pa totimoiso. No mo alopu sosomuyo no sosomuwakowoi ilolu muwoi. ");
INSERT INTO amm_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Nokoyo ilolu mo nuso isikokai mo, to mo nonani nuso mano mulu saso. Kumokiso isikokai mo, kumokiso amiyo mulu saso.” Siyokawi imo mo aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Nosai no mo; Isiso mo ulai ikoki, “Na popuwotolowo, lamu tayo pofalosokowo, saponimai si monoi. Na pa foumo siwo. ");
INSERT INTO amm_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Totaini noko siyoli nokota foumo noko komiyai pa siwo. Noko siyoli mo koloni wasikai utukaikiyo tumakimo, na foumo soimo. Itu lotiso ukou ukou nima tumakimo, somaiso na kolali unoinomo. ");
INSERT INTO amm_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mi anononi noko, to tumomaiso no foumo saki no, toi mo na molokiwumo. Yo mo motuwa na timonukuwo. Nonani siyoli nokota mo ikoimo, “Na posiwo,” koloni na no nikoimo. ");
INSERT INTO amm_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ulai amoloki mulu pusumai tumakimo, ulololi si somiso noko mo na molokiwumo. Wiyo wiyo imo yakomai mani, ulololi si somisoso koka tumakimo, na molokiyoinomo. ");
INSERT INTO amm_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ninani hani na pomulumolokowo. Nu kiyo nokota mo polamoko nokotayo tumo monoi posaino mo, na palukimo. Ulai maniwoiso poi tumoi, ulai to no sai? ");
INSERT INTO amm_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Moi mani, pa foumowo. Asi asi noko nokolaloni noko siyoli nokota yo no maniwoiso tumoimo? Ulai moi no sai? Moiyo iyamakinuwomo, pa tumoisowo, yo mo na tumoimo.” Siyokutono iyaliso aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Nosai no mo; Pita mo imoki, Isisoso, “Siyoli Nokota, ninani siyokawi imo no koi monoi saso timokoni, o, noko nokolalo siyaiwoi monoi?” ");
INSERT INTO amm_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nosai no Noko Siyoliyo na fowaki, “Mi ano itouniyaimo nokota no noi? To mo muluwoi na, mulu itouniyaimowoi nali. Nonani nokota mo noko siyoliyo tomuwokai, totani mi ano noko samukuko monoi. No yakomai saiso saiso tuwautimoi, koloni mo. ");
INSERT INTO amm_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Siyoli nokotayo mi ano itouniyaimoso kiya tumakimo, nonani mi ano nokota mo na molokiyumo. ");
INSERT INTO amm_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Yo mo motuwa na timonukuwo. Noko siyoliyo na muwokaiyoimo, totani hani hani komaso samukuko monoi. ");
INSERT INTO amm_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ulai mi anononi nokota siya mo na tomulumoloko, “Yani noko siyoli mo somaiso pa tumoiso.” No monoi no mi ano siyamaiso noko nokolaloso tuwasouliyanomoi, koloni tonokomoi, iwo koiyau tosikomoi, tukwalu kwalumo. ");
INSERT INTO amm_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Aino yo manakimo, tani noko siyoliyo ifou na tumoimo, foumo somisomaiso. Noko siyolini tumo monoi mo sai muwoi. No monoi no mo siyoli nokotayo na uwokaiyoimo, mulumolo luwai somiso nokowoi tolo tomasikoimo. ");
INSERT INTO amm_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Mi ano nokota no mo, to mo tani siyoli nokotani mulu mo sai. Ulai hani hani foukaiwoi muwoi. Siyoli nokotayo no imoki no, to mo yowoi muwoi. Siyoli nokota mo tumakimo, wiyou, siyoliso na waso manoimo. ");
INSERT INTO amm_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ulai mi anononi nokota siya mo siyoli nokotani mulu mo sai muwoi. Molo koiyauso aluwaiyakimo, koufasosu wasoimo. Noko mo Kotoyo sai anoni mo, suo mani, mi anoninumo. Siyoliso niyakimo, Kotoyo imoimo, “Mi amiso na pa anomono manowo.” Pitaso aino imoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Isiso mo siyokutono iyaliso ulai ikoki, “Yo mo asiso amukonoki, ta yoli monoi. Wiyou, mulu siyoliso tiyo, amukokai monoi. ");
INSERT INTO amm_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Ulai toku mo iyanoko siyoli uwomonoinomo. Wiyou, mulu na tokalomonomoi, ainoso uwaimoimo. ");
INSERT INTO amm_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ulai moi mo tiyamonuwo, yo mo asi noko moini uo tokosiyaima tumonukuwowo. Wiyou, ainosu muwoi. Ya timonukuwo, ya noinomo pa asisikuwano soinuwoso. ");
INSERT INTO amm_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Naino siyai noko nokolalo nu siyaso no tosi no, toi mo pa asisikuwanoinoso. Lolaisai siyai mo yoso mulumolo luwaimono manoinomo. Tiwoi tauwoiyo suo suo uo mulu yo ukuwano manoinomo. ");
INSERT INTO amm_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Pa asisikuwanoinoso. Apitonowoi awitonowoiyo suo suo uo mulu yo ukuwanoinomo. Atino mani, atokiwoi suo suo uo mulu yo ukuwanoinomo. Atino soputonowoi suo suo uo mulu yo ukuwanoinomo.” Siyokutono iyaliso ikoki, ainoso na. ");
INSERT INTO amm_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Nosai no mo; noko nokolaloso mani, na ikoki, “Moi mo sa noiso toki manonuwo, kumoki fiyokaimoso, no monoi no tiyamo manonuwo, “Sa mo na totumo.” Motu nali, nosai no sa somaiso na totumomosi. ");
INSERT INTO amm_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Imonu mo puwosai totumomoi mo, na tiyamo manonuwo, “Ulo ta siyoliyo wiyoimo.” Motu nali, ainoso na fiyamosiyoimo. ");
INSERT INTO amm_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Asiwoi kumokiwoiso tukwaiko itouniyaimo manonuwo, no monoi no moi mo sai, sa tumowoi ulo wiwoi monoi. Yani mi ano mani, yasoi na tukwaimono manonuwo. Ulai hani monoi? Yo monoi mo moi mo sai muwoi.” Aino ikoki. ");
INSERT INTO amm_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Isiso mo ulai ikoki, noko nokolaloso, “Moloi monoi woi? Hani monoi pa tomulumoloko itouniyaimo manonuwoso? Na pa mulumoloko kiwo, molo itouniyaimoso aluwai monoi. ");
INSERT INTO amm_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Nokoyo uo imo lukaso ni monoi kauwakinimo, imo kwai nokota siyolini auso, toku mo momati amu mo molomai uo imo monoi na pa hamukukuwanowo, imo futo monoi. Wonikaluso aiko imo kwai nokotani auso kiyoini. Nosai no totayo polimano nokoni nainoso aiko kiyoini, kalopulo nuso aiko kiyoini. ");
INSERT INTO amm_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ya timonoki, kalopulo nusai somaiso pa amufoiniso. Na yousikaino manoinimo, ainoso hani molo koiyau foli imo mo futo.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Nomai no mo, noko siyai mo Isisoni auso siki, na imokino, “Pailatoyo tani mi ano nokoso iko taikiyoki, Kalili nokoso tukuwoli monoi. Kotoso koloni utunoni simai na tukuwoliya tumokino.” ");
INSERT INTO amm_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Nosai no mo; Isiso mo na ikoki, “Moiyo no moloi tomulumolokonuwo? Nonani Kalili noko iyali, nokoyo no tukuwolikino no, toi mo molo koiyau siyoliso poi toku aluwaikino. Kalili noko siyaiyo koufaso poimo. Molo koiyau siyoli aluwai foli monoi Kotoyo poi uwokaikoki. ");
INSERT INTO amm_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Ya timonukuwo, wiyouwa wiyou. Moi mo mulu alosoko somiso mo, moi komaso mani, ainoso na uwokaikomoinuwomo. ");
INSERT INTO amm_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Noko siyai mani, noko molopoi, 18, toi mani, kolikaliki, Silowamo asimai nu sopo siyoliyo itokolikoki, yau yau. Moloi tomulumolokonuwo? Toini molo koiyau mo Yolusolimo noko siyaini molo koiyau poi souwaikokino. ");
INSERT INTO amm_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Ya timonukuwo, wiyouwa wiyou. Moi mo mulu alosoko somiso mo, moi komaso mani, ainoso na uwokaikomoinuwomo.” Ainoso na ikoki, Isiso mo, nokoso. ");
INSERT INTO amm_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Nosai no mo; Isiso mo siyokawi imo na ikoki, noko nokolaloso, “Noko mo sipoki ino kosisokaiki, tani isiso. Sipoki a siyoli yasoi; a wamo loloko monoi louwa tumoki. Ulai sipoki wamo mo siwoi muwoi, uwofa. ");
INSERT INTO amm_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","No monoi no isi mi ano nokotaso na imoki, “Pukwai, aisamu mo tauwoi yo mo saiso saiso potumomosiki, a wamo loloko monoi louwa. Ulai a wamo mo siwoi muwoi, uwofa saso. Na pi. Asini komo no afonimaiso no hani monoi tuwaimomoi?” ");
INSERT INTO amm_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Nosai no mo; isi mi ano nokotayo fowaki, “Noko siyoli, ninani aisamu mo tofolo na tolosu. Awi, ya asiso ai manoimo, asiwoi polomoko noniwoiyo isikaiso kiyoimo. ");
INSERT INTO amm_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","No monoi no aisamu siyamai wamo mo amai poimo soi. Si somiso mo, tofolo, na pa i taikiyo.” Isiso mo siyokawi imo mo ainoso ikoki. ");
INSERT INTO amm_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nosai no mo; Isiso mo mi fou fouko ulomai imo lukaso tola tiki, noko nokolaloso, lotu nu siya poiso. ");
INSERT INTO amm_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Nosoni noni mo tolosoki, noni koiyau wai, popuwayo uwokaisokai. Aisamu molopoi molopoi, 18 mo ainoso na. Namoli mo ikomuwai. Fouso no moloi liyaiso monoi? ");
INSERT INTO amm_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Isiso mo nonani nokonuso kosoki, aliyonisoki, “Kuku.” Na isoki, “Woli, ai koiyau ya na tafoliwainoki.” ");
INSERT INTO amm_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nainoyo na komisoki, lolai siyaso na auwonisiyouki, fouso na liyaisoki. Kotoni siyolo kaluwaiyalouki. ");
INSERT INTO amm_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Nosai no mo; lotu samukuko nokota mo Isiso monoi mulu atolokomo unuki, mi fou fouko ulomai itouniyaisokai foli monoi. Noko nokolaloso ikoki, “Mi ano ulo mo toufowoisu. Mi ano ulomai na pa ti manowo, ai ai ititounikomokai monoi mo. Mi fou fouko ulo mo ai ai ititounikomokai ulo muwoi.” ");
INSERT INTO amm_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Nosai no mo; Isiso Siyoliyo na fowaki, “Moi mo imo topoko noko saso. Momai mani, mi fou fouko ulomai mo polomokoni nuso toti manonuwo, polomokowoi hosofawoi iwoso tokoliyono manonuwo, iwo siko monoi. ");
INSERT INTO amm_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ulai noni to ni mo, to mo Apolofamoni alisaimi. Sokolo Nokota Waiyo uwokaisokaiki, aisamu molopoi molopoi, 18. Moloi monoi woi? Mi fou fouko ulomai itouniyaisokai no koiyau, a?” ");
INSERT INTO amm_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Isiso mo aino yomuki mo, uo noko auwosikoki. Noko nokolalosu mo molokikino, Isisoyo no yaloki mo, ulukukumoso. ");
INSERT INTO amm_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Nosai no mo; Isiso mo ti monoi na yomuki, “Kotoyo samukukomo mi no moloi woi? Moloi towiyononinukuwo? ");
INSERT INTO amm_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Kotoyo samukuko noko nokolalo iyali mo sipoki ino komiyai. Nokoyo nonani sipoki ino tikaiyano, totani isiso. Namolisai mo na siyoliso taikiyo, a na totoloso, touwowoi na tosi. Uo mo nonani a touwoso tosinono tumo liyai.” ");
INSERT INTO amm_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ulai ikoki, “Kotoyo samukukomo mi no moloi towiyononinukuwo? ");
INSERT INTO amm_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Totayo samukukomo mi mo paluwa tuo sisiyoliko asu komiyai. Noni mo paluwa tuo totopolomo tomasi, sisiyoliko asuwoi, poso siyolimai. Nosai no mo tokoma liyo, puwoso puwoso ko kowaso.” Isiso mo siyokawi imo aino ikoki. Totaso mulumolo luwai noko nokolalo mo molopoi molopoi soimo. ");
INSERT INTO amm_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Nosai no mo; Isiso mo Yolusolimo nokonu siyoli molomai manaloki, nokonu nokonuso tokosonasiyaloki, nokonu sisiyoliwoi nokonu lolofawoiso. Kotoni imo aiyolokalo manoki, noko nokolaloso. ");
INSERT INTO amm_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Nosai no mo; nokoyo imoki, “Siyoli Nokota, moloi woi, a, noko nokolalo siyasonuso samiyaikiyo soimo?” Nosai no noko nokolaloso na ikoki, Isisoyo mo, ");
INSERT INTO amm_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Amiso na pomulumolo luwaiwo, Kotoni auso ti monoi mo. Itu loti mo mumukufa na. Ya timonukuwo, noko nokolalo molopoiyo louwa ti liyaiyoimo, ulai pa toiso. ");
INSERT INTO amm_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Nu kiyo nokota mo tolauwoimo, itu na asiyoimo. Ulai moi mo asiyofolosai fu sakinuwomo, ituso ukou ukou nimoinuwomo, imoinuwomo, “Siyoli Nokota, itu pokolali unumoko.” Ulai na fowakomoinuwomo, “Yo mo moi monoi mo sai muwoi. Moi no moinani asi noko?” ");
INSERT INTO amm_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ulai moiyo imoinuwomo, “Koi mo koloni no no fasiya tumokinoki no, koi mo nonani noko na. Koini nokonu mulumai aiyolokomomoko tola tumokini.” ");
INSERT INTO amm_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ulai moiso na imoinuwomo, “Yo mo moi monoi mo sai muwoi. Moi mo moinani asi noko? Moi mo molo koiyauso aluwai noko. Sai suwo, na ponuwo.” ");
INSERT INTO amm_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Wiyouwa wiyou, aniyopano iyaliso kokoinuwomo, Kotoyo samukukoso, Apolofamowoi Isakowoi Yokopowoi Kotoni mulu lukasiko noko iyaliwoi. Kokakinuwomo, moi saso mo amiyaikiyokomo kaiyoinuwomo, asiyofolosai fu soinuwomo. Wiyou, na sosonuno soinuwomo, iwoi sisikomo soinuwomo. ");
INSERT INTO amm_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Noko nokonu noko molopoi mo yoso mulumolo luwaimonoinomo. Wiyou, molopoi nali, na ti liyaiyoimo, ulo amiyo asisaiwoi ulo amukono asisaiwoi. Isaino ausaino ti liyaiyoimo, noinoso noinoso. Koloni no si fasiya tumo liyaiyoinomo, Kotoni samukuko nokonuso mo. ");
INSERT INTO amm_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Afonimai noko siyai mo yapoli lolaimai tosi, ulai namolimai mo Kotoni aumai mo noko sisiyoli na soimo. Noko siyaisu mo yapoli tosi, noko sisiyoli nali. Ulai namolimai mo Kotoni aumai mo afonimaiso na soimo.” Isiso mo aino na ikoki, Yuto noko iyaliso. ");
INSERT INTO amm_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Nosai no mo; Falisi moloso aluwai noko siyai mo Isisoso ima tumokino, “Tolomuso na putukaimo, asi siyaso na pomoi. Hiloyo nonoso tukolo monoi tiyo.” ");
INSERT INTO amm_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ulai Isiso mo na ikoki, “Hiloso na pimanowo, nonani asikoiyo aluwou koiyau waiso. Na pimanowo, noino, “Isisoyo tiyomu taikiyo, “Lolaiwoi amuwoiwoi yo mo popuwaso amiyaikiyokaloimo, ai ai noko nokolalo ititounikaiyaloimo. Tinoso mi uwaimoimo.” Ainoso na pimanowo. ");
INSERT INTO amm_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Motu na, lolaiwoi amuwoiwoi tinosowoi yo mo na manaloimo, Yolusolimo molomai mi analoimo. Yo mo Kotoni mulu lukasiko nokota. Asi siyamai no moloi tukolomono monoi? Yolusolimo nokonu siyolimaisu na tukolomonoinomo, no monoi no Yolusolimoso na manoimo, yo mo.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Nosai no mo; na yomuki, “Yolusolimo noko, woi. Yolusolimo noko, woi, Kotoni mulu lukasiko noko tukuwoli noko moi, woi. Kotoyo louwa tokiyokomo taikiyo manonuwo, ulai tomoki tosalosoko manonuwo, yau yau. Moi, woi. Kokalo uo lolofa komiyai yo mo saiso saiso na louwa tosamukukomo manonukuwo. Momaiyosu mo wiyou tiyamo manonuwo. ");
INSERT INTO amm_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Na pukwaimonowo. Koto mo moini nokonuso tutukaikomonuwo. Ulai afonimaiso? Ya timonukuwo, ti monoi pa kimonoinuwoso. Pa kimono manoinuwoso, ainoso hani iyamoinuwomo, “Nonani nokota, Noko Siyolini amimai no totumo no, tani siyolo na tokaluwaiyaloukoni.” Ainoso iyamoinuwomo, nuwoi no ti monoi na tumoimo, yo mo.” Isiso mo aino na yomuki. ");
INSERT INTO amm_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Nosai no mo; mi fou fouko ulo siyamai Isiso mo Falisi moloso aluwai nokota siyolini nuso no yousi fasiyanoki. Molo amiso na kwailuwaikino, Falisi moloso aluwai nokoyo mo. ");
INSERT INTO amm_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Wou woukomokai nokota mo Isisoni aumai yousikainoki. ");
INSERT INTO amm_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Isiso mo nonani nokotaso kiki, nokotalo iyaliso na ikoki, aniyopa imo sai sisiyoli nokowoi Falisi moloso aluwai nokowoiso. Na ikoki, “Moloi tiyamonuwo? Ai ai noko no mi fou fouko ulomai ititounikai no waliyo?” ");
INSERT INTO amm_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ulai toi mo fowawoi muwoi, ko lopuso na siki. No monoi no mo, Isiso mo nonani nokotaso na komiki, na itouniyaimokaiki. Nosai no kiyo taikiyoki. ");
INSERT INTO amm_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nosai no mo ikoki, “Moi nokotani alu poimo polomoko poimo iwo iso usukunoi, mi fou fouko ulomai mo, ya tiyomu, apitono mo lolai siyaso kominiyo yoimo. Motu poimo.” ");
INSERT INTO amm_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ulai tani imo no moloi fowa monoi? Na auwosikoki. ");
INSERT INTO amm_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Nosai no mo; Isiso mo na kokaloki, koloni no wasiya tumokino no, toi mo noko sisiyolini auso aumoifaso sinona tumoki. No monoi no mo, siyokawi imo na ikoki, noino, ");
INSERT INTO amm_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","9","“Nokoyo aliyoniyakinimo, koloni wasiya tumo monoi, tani auso aumoifaso noiyo yousa tumoi, noko siyoli, no monoi no. Wonikaluso noko siyoli siyayo tumoimo, nu kiyo nokotayo aiko imoi, “Yani aumai piyousa tumo,” aiko fafoli taikiyoini. Wiyou, na auwosimoinimo, afonimai nokoni auso yousanoinimo. ");
INSERT INTO amm_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ulai nokoyo aliyoniyakinimo, koloni wasiya tumo monoi, afonimai nokoni auso na pa yousano. Aino yakinimo, nu kiyo nokotayo imoinimo, “Woli, yani auso na piyousa tumo.” Ainoso imakinimo, no si noko nokolaloyo nani siyolo kaluwaiyalouwoinimo. ");
INSERT INTO amm_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ya timonukuwo, noko mo noko siyoli tolo mulu yakimo, Kotoyo pa molokimoiso, na auwosisimoimo. Noko mo noko siyoli tolo mulu yo somiso mo, Kotoyo molokimoimo. Kotoni molo timai siyoli nokota toloimo.” Siyokawi imo aino ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Nosai no mo; Isiso mo Falisi moloso aluwai nokotaso imoki, koloni wasi monoi no aliyoniki no, nonani nokotaso na imoki, “Koloni wasi monoi nokoso aliyonikakinimo, siyokuno iyaliso noiyo aliyonikoi. Auwano iyaliwoi nako siyamai noko iyaliwoi muwoni molopoi asi siyamai nokowoi, toiso noiyo aliyonikoi. Toiso aliyonikakinimo, suo suo aliyonikuwano manoinuwomo. Ni mo Kotoni molo timai siyoli hani muwoi. ");
INSERT INTO amm_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Afonimai si nokoso na pa aliyoniko, koloni wasiya tumo monoi. Ilolu somiso nokowoi au kopokoiyau nokowoi fona nomolikokai nokowoi molo kau kau nokowoi, toisoso na pa aliyoniko. ");
INSERT INTO amm_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","No monoi no na molokiyoinimo. Ulai afonimaiso? Nonani noko iyali mo suowoi pa niyoiniso. Ulai mulu ititouni noko yausai auwonoulakimo, nomai no mo Kotoyo suo foli monoi na niyoinimo.” Isiso mo Falisi nokotaso aino imoki. ");
INSERT INTO amm_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nosai no mo; no si noko mulumai nokota mo Isisoni imo kwaimoki mo, na imoki, “Noko mo Kotoyo samukuko asimaiso koloni wasiyakimo, to mo na molokiyumo.” ");
INSERT INTO amm_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nosai no mo; Isiso mo siyokawi imo na imoki, nokoso, “Noko mo koloni wasi monoi tofouko. Noko nokolalo molopoiso taliyonikalo, koloni wasiya tumo monoi. ");
INSERT INTO amm_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Nosai no mo, koloni wasimai mo mi anononi nokotaso timo taikiyo, noko nokolalo kolisalo monoi, toku no aliyonikoki no. Na louwa tikalo, “Kukuwo, koloni wasi mo konoiso na. Yasoi na foukai.” ");
INSERT INTO amm_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ulai toi siyasonuso tiyamalo, “Koi mo pakoso nuwoikiso, wiyou tiyamonoki.” Siya mo tiyomu, “Yo mo isi mo tonofalo, aliyoli ali amai tikai. Woli, yo mo pakoso manoiso.” ");
INSERT INTO amm_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Noko siya mani, tiyomu, “Yo mo polomoko nanomu naino ti kukokai. Niya tokokano, mi ano uku ki monoi. Woli, yo mo pakoso manoiso.” ");
INSERT INTO amm_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Noko siya mo tiyomu, “Yo mo pakoso manoiso, noni mo lolai kauso.” ");
INSERT INTO amm_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Nosai no mo; mi ano nokota mo ifou, tani noko siyoliso ainonani monoi tima tumo. Wiyou, nu kiyo nokota mo mulu tatolokomo, mi anononi nokotaso ti monoi na timo taikiyo, “Nokonuso somaiso na pomoi. Molo sisiyoliwoi molo lolofawoiso paluwaikalo, afonimai noko nokolaloso na pa kolisalo. Ilolu somiso nokowoi au kopokoiyau nokowoi molo kau kau nokowoi fona nomolikokai nokowoi, toiso pa koliyo tumo, yani nuso.” ");
INSERT INTO amm_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Nonani yo uwai; mi ano nokotayo tima tumo, “Noko siyoli, no imononi no, no mo koma na. Ulai nu si siyai mo sofuwa amai ni si.” ");
INSERT INTO amm_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nosai no mo; siyoli nokota mo totani mi ano nokotaso ti monoi timo, “Akuso na pomoi. Molo sisiyoliwoi molo lolofawoiso paluwaikalo, noko nokolalo na pa kolisalo. Na pa koliyo tumo. Yani nu mo noko nokolalo saso mo waliyo. ");
INSERT INTO amm_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Ya timonoki, noko toku no louwa aliyonikoki no, toi mo yani koloni pakoso nokoinoso.” Isiso mo siyokawi imo ainoso na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Noko nokolalo molopoi molopoi mo Isisoso aluwaiyalokino, molomai. Nosai no mo; fokutonoyo alosikoki, na ikoki, ");
INSERT INTO amm_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Noko mo asani auso tumakimo, atino apitono noko tini muluso no moloi aluwaiko monoi? Fuwaluwouni muluso mani, ulai moloi aluwaiko monoi, yani auso tumakimo. Auwatono iyaliwoi inaitono iyaliwoi totaini muluso no hani monoi aluwaiko monoi? Tota amu mulu mani, moloi aluwai monoi? Mulu siyaso aluwaiyakimo, ulai moloi aluwaimono monoi, yoso no? ");
INSERT INTO amm_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Yo mo a moki sokunalomakoimo. Noinoso aluwaimono nokota mani, uo nokoyo uwoyakinomo, moloi ulosukomo monoi? Nokoyo ulosukomo mo, to mo yoso pa taluwaimonoso. Uo nokoyo takimo, yoso na aluwaimonumo. ");
INSERT INTO amm_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Moloi monoi woi? Moi nokota mo nu sopo siyoli ko monoi yakimo, toku mo na mulumoloko kiyoimo, noino, “Nokoyo nu ko fasimonakinomo, yo mo mi ano foli monoi yapoli poi nikoi, mi uwaimo monoi.” ");
INSERT INTO amm_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Wonikaluso nu mi paikoso ano uwaimoiso. A saso ikaikaiso kokakinomo, nokoyo alisiyoliyoinomo, ");
INSERT INTO amm_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","iyamoimo, “Ninani nokota mo a saso ikaikai, ko uwaimo monoi mo sosoli.” Isiso mo siyokawi imo aino ikoki, noko nokolaloso, toku mulumoloko ki monoi, Isisoso mulumolo luwai monoi. ");
INSERT INTO amm_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Nosai no mo; Isiso mo siyokawi imo siya na ikoki, “Noko samukuko nokota siyoli mo siyoli nokota siyaso uo faiso monoi tiyo. Ulai toku mo na tomulumoloko ki, “Yo mo noko molopoi muwoi, siyasonuso fasimonoinomo. Totasu mo noko mo molopoi molopoi. Koi mo waliyo poi uo ano ukoikimo, poi souwaikoikimo.” ");
INSERT INTO amm_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Wiyou yomakimo, uo nokoyo aluwamai amai sakimo, nokoso iko taikiyoimo, hamukukuwano monoi. ");
INSERT INTO amm_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Noinoso nali, moi nokota namoliyo alosoko somiso mo, tani hani hani komaso mo, moloi aluwaimono monoi, to no? Asaso aluwaimono monoi na pa mulumoloko kiwo.” Ainoso na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Nosai no mo; Isiso mo ikoki, “Mamo mo itouniyaimo na. Ulai mamo koiyaumakimo, usutono no moloi tano monoi? Usutonowoi muwoi. Ulai ti monoi no moloi yo monoi, woi, usutono tano monoi no? ");
INSERT INTO amm_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Nonani mamo koiyau no mi no moloi ano monoi? Ulai asi itouniyaimokaiwoi muwoi. Moi mo afonimaiso na tosaloso manokoni. Noko mo iyo uku somiso mo, imo mo na pa kwaimono itouniyaimowo.” Aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Nosai no mo; takiso muwoni i nokowoi molo koiyauso aluwai nokowoi, toi mo Isisoni auso ukouniyaika tumoki, imo kwaimo monoi. ");
INSERT INTO amm_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Nosai no Falisi moloso aluwai nokowoi Musini imo sai sisiyoli nokowoi amuwaso alikino, iyamaloki, “Ninani nokota mo molo koiyauso aluwai nokoso tuwolimikomoi, na tono fasikomoi.” ");
INSERT INTO amm_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","No monoi no mo, Isiso mo siyokawi imo na ikoki, ");
INSERT INTO amm_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Moi nokota mo sipo koloni molopoi molopoi, 100, na tosamukukomoi. Ulai sipo siya mo uwofa na, moiso poimo manoso. Nosai no mo, sipo samukuko nokota mo na tikolisalo. Sipo siyai mo, 99, nu somiso asiso amai tutukaiko. Sipo siya na tikolisalo. ");
INSERT INTO amm_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Nosai no mo; koso uwai; noma timai tatisiyo tumo, na tomolokisa tumo. ");
INSERT INTO amm_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Totani nu mo ifou tatisiyo tumo. Siyokutono iyaliwoi asi siyamai nokowoi taliyoniko, ukouniyaiko monoi. Na tiko, “Na pomoloki fasimonowo. Yani sipo no lomuso no, yasoi na kosano, ifou na kausiyo tumo.” ");
INSERT INTO amm_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ya timonukuwo, noinoso na, kumoki noko iyaliyo mani, koufasoso tomolokikono, mulu ititouni noko molopoi monoi, 99. Yasoi alosokokino, mulu mo. Ulai molo koiyau nokota mo muluso alosiyakimo, wiyouwa wiyou, kumoki nokoyo siyoliso na molokimaloinomo.” Isiso mo siyokawi imo mo ainoso ikoki. ");
INSERT INTO amm_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Nosai no mo; Isiso mo siyokawi imo siya na ikoki, “Noni mo muwoni mo naino tiwoi. Ulai muwoni siya mo uwofa, na tikolikaiso. Nosai no lamu ta tofalosiso. Tofalosiso mo; nu kukumo tasoko, ikoliso monoi. Tikolisomoi tikolisomoi, ainoso hani na tokoso, muwoni mo. ");
INSERT INTO amm_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Koso uwai; siyokutono iyaliwoi asi siyamai noko nokolalowoi taliyoniko, ukouniyaiko monoi. Na tiko, “Na pomoloki fasimonowo. Muwoni siya mo ikolikaiso, lolai mo yasoi koso, ifou yasoi na aso.” ");
INSERT INTO amm_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ya timonukuwo, noinoso na, Kotoni kumoki nokoyo mani, na molokimo manoinomo, molo koiyauso aluwai nokotayo mulu alosimakimo.” Ainoso na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Nosai no mo; Isiso mo imo lukasiyoluwaikoki, na ikoki, “Noko mo alalo tiwoi nokota, awitono noko ti. ");
INSERT INTO amm_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Namolisai alu mo apitonoso na imoki, “Apou, kalakinimo, ilolu utai mo auwa kotiyo iyoikimo. Ulai ya tiyomu, yani mo toku na ponimono.” Imoki mo; apitono mo ilolu wautiki, alalo tiso. ");
INSERT INTO amm_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nosai no mo; atotalowoi muwoi, namolisai alu mo tani ilolu aliyouki. Yasoi, na manoki, aluwamai asiso. Aluwamai asiso tolo manoki mo, mulu mo koiyau saso, muwoni komasoso suo suomokaloki, molo koiyauso aluwaiyalo monoi. ");
INSERT INTO amm_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Suo suomokalo manoki mo; muwoni mo uwofa. Nosai no nonani asimai mo tolomu nokoyo tiya sisiyoli uwokoki. To mani, sofuwamoki, tiya na. ");
INSERT INTO amm_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","No monoi no mo mi ananoki. Asi tolomu nokotani mi anoninanoki. Nonani nokotayo imo taikiyoki, “Yani fuso na puwoliko tolano.” ");
INSERT INTO amm_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Fuyo noso pukwaikomosiki mo, wiyou, tota mani, no mulu puwomosiki. Yohapou tunoso noko fasiko monoi louwa fi. Ulai noko no noiyo ni monoi? ");
INSERT INTO amm_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Nosai no mo; mulumolokoki, na yomuki, “Yo mo kwaimo pa tiyousiso. Apouni mi anononi noko mo koloni molopoi mo yapoli tonoko manono. Yosu mo tiya siyoli ni tokalomonomoi. ");
INSERT INTO amm_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Yo mo yasoi, apouni auso ifou manoimo. Na imanoimo, “Apou, yo mo molo koiyauso aluwai nokota, Kotoni molo timaiwoi nonani molo timaiwoi. ");
INSERT INTO amm_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Yo mo noko itouniyaimo muwoi. Nono no alu imo no moloi kaluwaimono monoi? Nani mi ano nokota na pokaluwaimono.” ");
INSERT INTO amm_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Nosai no mo; yasoi, apitononi auso ifou na manoki. Aluwamai amai tumoki mo, nosai no mo apitono mo aluwamai tumoso na kwaiki. Mulu mo yau, awitono monoi. Tani auso na fumo unuki, na kololuwayanoki, na sonukuyanoki. ");
INSERT INTO amm_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Aluyo na imoki, “Yo mo molo koiyauso aluwai nokota, Kotoni molo timaiwoi nani molo timaiwoi. Yo mo noko itouniyaimo muwoi. Nono no alu imo no moloi kaluwaimono monoi?” ");
INSERT INTO amm_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ulai apitono mo totani mi anononi nokoso na ikoki, “Yani tuno sopo itouniyaimo na panononiwo. Somaiso na pa aniyo tumowo, na pa asisikaimowo. Naino koliwoi pa asisikaimowo. Fona suwoi pa asisikokaimowo. ");
INSERT INTO amm_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Polomoko uo tononoso na punanowo, koloni wasi monoi, moloki si monoi. ");
INSERT INTO amm_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Ya piyomuki, yani alu mo yauwo. Ulai lolai mo ifou na tumo. Ya piyomuki, uwokaiwo, ulai yasoi na kimona tumo.” Aino ikoki. No monoi no koloni wasi nikino. ");
INSERT INTO amm_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Toku alusu mo isiso amai tolokainoki. Ulai nosai no mo; nuso ifou tumoki, iyomosi imowoi namo siwoiso na kwaika tumoki. ");
INSERT INTO amm_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Mi ano nokotaso aliyoniki, imoki, “Hani tanono, woi?” ");
INSERT INTO amm_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Nosai no mo; mi ano nokotayo na imoki, “Auwano mo yasoi na tumo. Aponoyo polomoko uo tononoso na unu. Tani alu mo waliyo ifou tumo, kalowoi muwoi. No monoi no koloni tuwasi nino.” ");
INSERT INTO amm_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ulai toku alu mo mulu na atolokomoki, lotiwoi muwoi. Nosai no apitonoyo na ima fuki, imaloki, “Tofolo, imo mo futo.” ");
INSERT INTO amm_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ulai na fowaki, apitonoso, “Na pukwaimono. Aisamu aisamu yo mo mi na tanononi manonoki. Imo mo pa tokulali manonokiso. Ulai nono mo koloni wasi nimonowoi muwoi, mimi uofa mani, pa nimono manokiniso, yani woli iyaliso koloni wasi niko monoi mo. Wiyouwa wiyou. ");
INSERT INTO amm_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Nonani alu mo, muwoni no i wanonikini no, uloliyo nokolaloso no ponikalo manoki no, ta tumomai ulai hani monoi polomoko uo tononoso ununonini?” ");
INSERT INTO amm_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Nosai no mo; apitono mo awitonoso na imoki, “Yani alu, nono mo aniyopa poi poi totolo tomasimomononi. Yani komaso hani hani mo nani ilolu na. ");
INSERT INTO amm_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ulai lolai mo na tomoloki sikoni, koloni tuwasi sikoni. Moti piyomukikoni, auwano mo yauwo. Ulai lolai mo ifou na tumo. Piyomukikoni, uwokaiwo, ulai yasoi na kimoka tumo.” Isiso mo siyokawi imo mo ainoso na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Nosai no mo; Isiso mo siyokutono iyaliso imo lukasiyoluwaikoki, na ikoki, “Ilolu molopoi nokota mo ilolu samukuko nokota yapoli na tolo. Ulai noko siyaiyo ilolu molopoi nokotaso faumiya tumokino, imokino, “Nani ilolu samukuko nokotayo mo ilolu na ti wanoni manoni.” ");
INSERT INTO amm_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Nosai no mo; ilolu samukuko nokotaso aliyoniki, na imoki, “Yo mo imofa kwai, nokoyo no faumimonono no, nonayo ilolu tiwaimono manoni. Motu poimo. Siyolo siyolo na pokulukaiyano, yani ilolu komaso monoi. Nosai no na pa utukaimono. Ilolu no hani monoi samukukomono monoi?” ");
INSERT INTO amm_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Nosai no mo; nonani ilolu samukuko nokota mo mulumoloko manoki, “Yo no moloi yoimo, woi? Noko siyoliyo amiyaikiyomonoimo, mi anononisai. Moloi yoimo, woi? Yo no isi mi no moloi ano monoi? Yani mi mo ami mo uwofa. Yo mo tauwosimomono, nokoso muwoni ikalo monoi mo. ");
INSERT INTO amm_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ulai yo mo sai na, noino na yoimo. Yo mo muwoni uwofa nokoso fasikakimo, suo mo totaini nuso mo waliyo tumo liyaiyoimo, yo mo, koloni no nimonoinomo. No monoi no siyoli nokotayo amiyaikiyomonakimo, yo mo waliyo.” ");
INSERT INTO amm_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","No monoi no mo, noko siyasonuso aliyonikaloki, noko siyoliso ilolu toku no uwokino no, awa monoi, toiso aliyonikaloki. Nosai no totawoi nokotaso na imoki, “Ilolu afonimaiso no moloi moloi uwokini, yani siyoli nokotaso no?” ");
INSERT INTO amm_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Fowaki, “Yo mo woilo iwo nau sisiyoli molopoi molopoi, 100, na uwoki.” Ilolu samukuko nokotayo mo na imoki, “Fuo, ni no kumokaiki no, 100 mo. Somaiso piyousa kono, 100 na puwosuwako, 50 saso na pokumo.” ");
INSERT INTO amm_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Nosai no mo; noko siya tumoki mo, ilolu samukuko nokotayo na imoki, “Ilolu afonimaiso no moloi moloi uwokini?” Fowaki, “Yo mo paluwa tuo i sisiyoli molopoi molopoi, 100, na uwoki.” Na imoki, “Fuo, ni no kumokaiki no. 100 mo na puwosuwako, 80 saso na pokumo.” ");
INSERT INTO amm_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Nosai no mo; noko siyoliyo ilolu samukuko nokota koiyauso na imoki, “Nono mo ilolu i foli monoi fokusokotini, no monoi no suo monoi na fasiyoinimo, nonani noko iyaliyo. Nono mo muluwoi nali.” Wiyouwa wiyou, nonani ilolu samukuko nokota mo tota amu monoisu mulumolokoki, asini moloso atiyaiyaso aluwaiki. Saponi moloso aluwai nokosu mo atiyaiso pa taluwai manonoso.” Isiso mo siyokutono iyaliso siyokawi imo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nosai no mo; ti monoi na ikoki, “Ya timonukuwo. Asini hani hani afonimai nokoso nikakinuwomo, na wolimikomoinuwomo. Asini hani hani uwai; Kotoyo imoinuwomo, “Yani auso waliyo na potiwo.” No monoi no kumokiso aniyopa poi poi si manoinuwomo. ");
INSERT INTO amm_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Noko mo noko siyaso ifoluwai mo, noko molopoi mani, ifoluwaikalomoi. Noko mo mi koufa ano itouniyaimakimo, mi siyoli mani, na ano itouniyaimoimo. ");
INSERT INTO amm_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Asini hani haniso atiyaiso samukuko somiso mo, Kotoni hani no moloi samukuko monoi, moi no? ");
INSERT INTO amm_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ulai moi mo nokoni ilolu atiyaiso samukuko somiso mo, momaini ilolu mo Kotoyo pa niyoinuwoso. ");
INSERT INTO amm_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Ulai mi ano nokota no noko sisiyoli tini mi tiwoi no moloi ano monoi? Aino yakimo, siya monoi mo mulu atolokomo unoimo, siya monoisu mo mulu unoimo. Kotoso aluwaiyakinuwomo, asini hani no moloi aluwai monoi, moi no?” Isiso mo siyokutono iyaliso aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Falisi moloso aluwai noko mo muwoni mulu mo sisiyoli. Isisoni imoso kwaimalokino mo, na alisiyolikino. ");
INSERT INTO amm_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ulai na ikoki, “Noko nokolaloni molo timai noko ititouni si monoi tiyo manonuwo. Kotosu mo sai, moini mulu mo. Noko nokolaloyo no tiyamalo no, ititouniwo, no monoi no Kotoyo tiyomu, “Asani molo timai mo kwamu kwaimo muwoi, kopokoiyau.” ");
INSERT INTO amm_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Musini imowoi Kotoni mulu lukasiko nokoni imowoi mo posasoko manokino, ainoso hani Iyonoyo imo tonofalo posasoka tumoki. Posasokoki mo; imo itouniyaimo tomaliyali, Kotoyo samukukomo imo na. Noko nokolalo komasoyo Kotoni auso ti monoi mulu siyoliso tiyo manono. ");
INSERT INTO amm_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Kumokiwoi asiwoi mo uwaimoimo, Musini imo komasosu mo amai na tosi, toku no kulukaiki no.” Aino ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Nosai no mo; na ikoki, Isiso mo, “Nokoyo totani noni afolikaisakimo, noni siyaso kausakimo, to mo uloliyo nokota na. Noko siyayo noni na kausakimo, toku nokitonoyo afolikaiso nukonuso, nonani nokota mani, uloliyo nokota na.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Nosai no mo; Isiso mo siyokutono iyaliso imo lukasiyoluwaikoki, na ikoki, “Toku mo muwoni molopoi nokota mo toloki. Tuno ititouniwoi pasisiko manoki, tuno nakiyai nakiyaiwoi, kamo kamosowoi. Ulo ulo saiso saiso koloni ititouniso ponokomosiki. ");
INSERT INTO amm_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Tani itu loti kwamai mo muwoni somiso nokota potanomosiki. Tani siyolo mo Lasolaso. Uluoyo uwokaikai, tani au mo. ");
INSERT INTO amm_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Muwoni molopoi nokotani koloni kosaimi noko monoi louwa piyomosiki. Wiyouwa wiyou, aluwouyo uluoso popanuwaya tumomosikino. ");
INSERT INTO amm_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Nosai no mo; muwoni somiso nokota mo kaloki, yau. Kotoni kumoki nokoyo alomanokino, Apolofamoni auso na kiyoniyo yokino. Muwoni molopoi nokota mani, kaloki, yau, na ai unukino. ");
INSERT INTO amm_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Aupoisolu Yuso tolokainanoki, iyanoko siyoli uwo manoki. Tolo manoki mo, puwoso monoi you foinalikoki, Apolofamo noko tiso aluwamai toloso na you kokoki, Lasolasowoiso, Apolofamoni auso yousiso. ");
INSERT INTO amm_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Nosai no mo; muwoni molopoi nokota mo siyoliso na you imoki, “Apou Apolofamo, pomulu unumono, na pofasimono. Lasolasoso yani auso piyou imo taikiyo, naino muwoyo iwoso solikaiyumo, yani isaunoso akaimomona tumumo, yo fulomumomono monoi. Wiyou, tayo na tuwomonomoi.” ");
INSERT INTO amm_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ulai Apolofamoyo na imoki, “Yani alu, na pomulumoloko ki. Molotano tolomai nono mo hani hani ititouniwoi potolo manokini. Lasolasosu mo umamoso tolowoi muwoi. Ulai nimai nosu mo ya tohamukumoi. Nonosu mo iyanoko siyoli tuwo manoni. ");
INSERT INTO amm_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ulai ya timonoki, moiwoi koiwoi asi i tokosoko no ulai aumoifa, moloi folamuwaniyo ti monoi? Ifou ifou no moloi folamuwaniyo ti liyai monoi?” ");
INSERT INTO amm_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Nosai no mo; muwoni molopoi nokotayo mo na imoki, “Apou, no monoi no ya timonoki, Lasolasoso na pimo taikiyo, yani apouni nuso na manu. ");
INSERT INTO amm_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Yani auwa iyali mo naino siya uwai amai na si. Lasolasoso pimo taikiyo, ikikumo. Ya topoiniyaikomomono, wonikaluso toi mani, iyanoko siyoli na uwoka tumoimo, isoniso, kolikaliyakimo.” ");
INSERT INTO amm_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Ulai Apolofamo mo na fowaki, “Toi mo Musini imo mo yapoli na, Kotoni mulu lukasiko nokoni imowoi. Nonani imoso na kwaiwumo.” ");
INSERT INTO amm_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Muwoni molopoi nokotayo mo na fowaki, “Apou Apolofamo, wiyouwa wiyou, imo mo pa tukwaiko manonoso. Ulai yausai auwoniyou nokota mo toini auso ika tumakimo, mulu na alosokoinomo.” ");
INSERT INTO amm_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Nosai no mo; Apolofamoyo imoki, “Musini imowoi Kotoni mulu lukasiko nokoni imowoi kwai somiso mo, yausai auwoniyou nokotani imo mani, pa kwaimoinoso. Waliyo pa mulumoloko unoinoso.” Isiso mo aino na ikoki, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Nosai no mo; Isiso mo siyokutono iyaliso na ikoki, “Ainiko ifoluwaiko noko mo na toimo, noko nokolaloso ainikoinomo, hani hani molo kopokoiyauso aluwaiko monoi. Wiyouwa wiyou. Molo koiyauso wiyoti nokota, to fau, atiyaiso na tolumo. ");
INSERT INTO amm_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nokofaso aini ifoluwaiyakimo, wiyou, siyoliso na uwoyoimo, aini ifoluwai foli monoi. Nokoyo iwo utaiso tukolo silakinomo, tomoki siyoliyo imo molomai konosuwakaiyakinomo, no mo koufasu. Nokofaso aini ifoluwai foli mo soliyakiso na uwokaiyoimo. No monoi no atiyaiso na pa si manowo. ");
INSERT INTO amm_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Mulumolo luwai nokota siyayo molo koiyauso aluwaiso kwaiyakinimo, na pa ikimo itouniyaimo. Mulu alosimakimo, molo koiyau monoi imo mo futo. ");
INSERT INTO amm_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nonoso koiyaumomosi nokota mo mulu kalomosakimo, molo koiyauso aluwai monoi, uo imo noiyo imoi, na pa imo, “Yo mo imo mo futo. Ulo siyamai mo saiso saiso koiyaumomosakinimo, ulai mulu kalomosakimo, saiso saiso na pa imomosi, “Yo mo imo mo futo.” Isiso mo siyokutono iyaliso aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Nosai no mo; Kotoni imo lukasikalomano noko mo Isiso Siyoliso na imokino, “Nonoso mulumolo luwai mulu ami amiso na ponimoko, koiso.” ");
INSERT INTO amm_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","No monoi no siyokawi imo na ikoki, “Sipoki ali mo koufa nali. Noinoso koufasosu mulumolo luwaimonakinuwomo, aso waliyo imoinuwomo, “Nani totiwoi na potoliyokiyo yo, mamo iwo siyoliso na potolano.” Aso ainoso imakinuwomo, nonani a mo moini imoso na kwaimoinuwomo, iwo siyoliso na tolanoimo, moiyo koufaso mulumolo luwaimonakinuwomo.” Noko Siyoli mo siyokawi imo aino ikoki. ");
INSERT INTO amm_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Nosai no mo; ti monoi na ikoki, Isiso mo, “Moi nokota mo mi anononi nokota mo yapoli totolo. Isi mi poi tanalo, sipo samukuko mi poimo. Mi ano uwai; nuso ifou totumo. Ulai totani siyoli nokotayo no moloi imo monoi, “Kuku, somaiso na potumo. Koloni na pono yousa tumo.” ");
INSERT INTO amm_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Ainoso pa timoso, wiyou. Na timo, “Koloni ta ponomona tumo. Tuno wofu na pa asisi, koloni na pa nimona tumo. Yo mo toku noimo. No uwai; nono mo namolisai na pa no.” ");
INSERT INTO amm_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Siyoli nokotayo no mi anononi nokotaso no ulai wafisu imo no moloi imo monoi, totani imoso kwai foli monoi? Wiyou, wafisu imo pa imoiso. ");
INSERT INTO amm_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Moi mani, noinoso na, Kotoyo no imakinuwo no, no mo yo uwai; na pa iyamowo, “Koi mo mi anononi noko saso. Koini mi na, totayosu mo muwomokokaiki. Wafisu imo no moloi imoko monoi?” Ainoso ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Isiso mo Yolusolimo nokonu moloso monoi manalo manoki mo, Somaliya asiwoi Kalili asiwoi nonani kwa kwasai manaloki. ");
INSERT INTO amm_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Nokonu siyaso fiyamosiki mo, nosai no mo, uluoyo uwokaikokai noko mo molomai kiya tumokino, noko mo naino tiwoi. Aluwasai na sa tumoki, ");
INSERT INTO amm_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","siyoliso na imokino, “Isiso Siyoli, na pomulu unumoko, na pofasimoko.” ");
INSERT INTO amm_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","No kokoki mo, na ikoki, “Moini au mo lotu samukuko nokoso na powiyolukanowo.” Ikoki mo; na nuki. Molomai nu liyai manoki mo, na tolosuwakoki, au ititouni saso. ");
INSERT INTO amm_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ulai noko siyasu mo Isisoni auso ifou na tumoki. Totani au itouniyaimoso kiki, ifou na tumoki. Kotoni siyolo kaluwaiyaloki, siyoliso nali. ");
INSERT INTO amm_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Isisoni fokutonomai na ukuwoli tana tumoki. Wafisu imo na ima tumoki. Noko nokonu nokota na, Somaliya asi nokota. ");
INSERT INTO amm_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Nosai no mo; Isiso mo noko nokolaloso ikoki, “Ya tiyomu, noko naino ti au ititouni na tosi. Siyasu mo ifou totumo. Noko siyai no hani monoi pa totiso? ");
INSERT INTO amm_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kotoni siyoloso pa tokaluwaiya tumonoso. Ninani noko nokonu nokota saso mo Kotoni siyoloso tokaluwaiya tumo.” ");
INSERT INTO amm_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nosai no mo; nokoso na imoki, “Na pauwoniyou, na pomoi. Yoso tomulumolo luwaimononi, no monoi no waliyo na totoloni.” ");
INSERT INTO amm_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Nosai no mo; Falisi moloso aluwai noko iyali mo Isisoso utolumokino, “Koto no maniwoiso samukukomomoka tumoimo?” Isiso mo na fowakoki, “Koto mo samukukomakinuwomo, ulai moi no moloi ki monoi, moini molo tiyo no? ");
INSERT INTO amm_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Kotoyo samukuko monoi mulumolo luwai nokoyo sai yasoi. Moloi iyamo monoi, noko nokolalo no, “Isoni poi tolokaino, ausoni poi tolokaino.” Koto mo moi komaso louwa tosamukukomo manonuwo.” ");
INSERT INTO amm_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ulai Isiso mo siyokutono iyaliso na ikoki, “Namolimaiso foumonoinuwomo, asa, asi asi noko nokolaloni noko siyoli nokota yoso kimono monoi yoinuwomo, ulai pa kimonoinuwoso. ");
INSERT INTO amm_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Nomai no noko nokolaloyo imoinuwomo, “Na pokiwo, ausoni tolokaino, o, isoni tolokaino.” Ulai moi mo noiyo aluwaikoiwo. ");
INSERT INTO amm_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Salomayo momaliyomo mo moi mo sai yasoi, na tukwai manonuwo. Kumoki komaso tomomaliyomalo. Asi asi noko nokolaloni noko siyoli nokota ya amukonomai mani, noko nokolalo komasoyo na you kimonoinomo. ");
INSERT INTO amm_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ulai yo mo iyanoko siyoli toku uwomonoinomo. No mo afonimaiso muwoi. Kotoyo ainonani monoi na imono taikiyoki. Lolaimai si noko nokolalo mo namoliyo alosimomonoinomo. ");
INSERT INTO amm_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Toku Nowa tolomai noko nokolalo mo tani imo mo pa pukwaimo manokinoso. Nosai no sa mo lolai siyaso somaiso na tumoki. Asi asi noko nokolaloni noko siyoli nokota asa mani, lolai siyasu somaiso na amukonoimo. ");
INSERT INTO amm_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Nowa tolomai mo noko nokolalo mo koloni pono si liyai manoki, pokolikuwano liyai manokino, ainoso hani Nowa mo poso ayou poiso na lotiki. Nosai no mo, iwo usoiyo siyoli na tumoki. Yau yau, noko nokolalo komaso mo iwo siyoliyo na tukuwoli soliki. ");
INSERT INTO amm_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Loto tolomai mani, noinoso na, noko nokolalo mo koloni pono si liyai manoki, hani hani ilolu posuo suomokuwano manokino, isi aliyoli pikai manokino, nu pokololi manokino. ");
INSERT INTO amm_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ulai Loto koli mo Sotomo nokonuso utukaimokino mo, lolai siyaso tawoi tomoki mukolaikokaiwoi mo kumokisai na usukunalokonoki, sa komiyai, noko nokolalo komaso mo na uwokaikaloki, yau yau. ");
INSERT INTO amm_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Noinoso nali, asi asi noko nokolaloni noko siyoli nokota ya fiyamosiya konomai mani, lolai siyaso na uwokoimo. ");
INSERT INTO amm_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Asa amukonomai noko mo nu komu tofumaiso you yousakimo, nu poiso tu si hani hani no moloi iya kono monoi? Noinoso nali, noko mo isimai tolakimo, nuso no ifou no moloi mano monoi? ");
INSERT INTO amm_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Lotoni noniso na pomulumolokowo, no uwosoki no. ");
INSERT INTO amm_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Nokoyo totani au monoisu mulu unakimo, aniyopa poi poi moloi yousi itouniyaimo monoi, na kalokaiyoimo. Nokoyosu mo yoso aluwaimono monoi kalakimo, pa kalokaiyoiso, aniyopa poi poi yousikaino itouniyaimo manoimo. ");
INSERT INTO amm_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Ya timonukuwo, asa amukonomai nonani amolokimai noko ti mo tomoso tanakinomo, siyasoso kumoki nokoyo na kausiya tumoinomo, siya mo amai tanokainoimo, ulololi. ");
INSERT INTO amm_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Nokolalo ti mani, noinoso nali, toti mo tuo waso utuko tolakinomo, siyasoso kumoki nokoyo kausisa tumoinomo, siya mo amai tolosoimo. ");
INSERT INTO amm_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Isi mi ano nokota ti mani, noinoso na, siyasoso kumoki nokoyo na kausiya tumoinomo, siya mo amai ano toloimo.” Isiso mo aino ikoki, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Nonani imoso kwaikino mo; na imokino, “Siyoli Nokota, moiso uwokoimo, woi?” Isiso mo fowakoki, “Noko yau yau salokukoukumai wiyo wiyoyo tonoka tumo liyai manono, noko yau yau somuso.” Ainososu fowakoki, molo koiyau foli monoi imo mo. ");
INSERT INTO amm_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Nosai no mo; Isiso mo siyokawi imo na lukasikoki, imo folosai mo noino, Kotoso imomosiwumo. Moloi ulosukomo monoi? Siyokawi imo mo noino na lukasiyoluwaikoki, ");
INSERT INTO amm_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Nokonu siyamai imo kwai nokota siyoli mo totolokaino. Kotoso pa tauwosiwaiso. Noko nokolalo monoi mani, pa tauwosiwaikoso. ");
INSERT INTO amm_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Sawi nukonu mani, nonani nokonuso totoloso. Saiso saiso imo kwai nokotaso tima tumomosi, “Uo nokoyo ilolu ti wamona tumomosino. Na pofasimono. Ilolu i foli monoi na pa yomu uku, na pa uwoko.” ");
INSERT INTO amm_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Toku imo kwai nokota siyoli mo fasisowoi muwoi, wiyou tiyomu. Ulai namolisai mo na tomulumoloko, “Ulai yo mo Kotoso pa tauwosiwaiso. Noko nokolaloso mani, pa tauwosiwaikoso. ");
INSERT INTO amm_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Ulai noni to ni mo, to mo saiso saiso timona tumomosi, fasiso monoi mo. Moloi woi, yo mo niya fasisoimo, aiko tumosomosoi, aiko ulosukomomonoi.” Siyokawi imo ainoso ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Nosai no mo; Isiso Siyoli mo na ikoki, “A, yapoli kwaimonuwo, imo kwai nokota koiyauyo no iso no? “Ya fasisoimo,” aino na iso. ");
INSERT INTO amm_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","No monoi no moi mo sai, Koto itouniyaimo mani, totayo muwokokai noko nokolaloso na fasikoimo. Ulo ulo amoloki amoloki tutolumalo manono. Wiyou no moloi yomu monoi, fasiko monoi no? Somaiso na fasikoimo. ");
INSERT INTO amm_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ya timonukuwo, somaiso na fasikoimo. Ulai asi asi noko nokolaloni noko siyoli nokota ya amukonakimo, noko nokolalo mulumolo luwaimonoso yapoli poimo kokoi.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Totai amu monoi no iyamoki no, molo itouniyaimoso aluwaiwo, noko siyai monoi no iyamoki no, mulu kopokoiyauwo, totaiso Isiso mo siyokawi imo ikoki. ");
INSERT INTO amm_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Noino ikoki, “Noko ti mo Kotowoi imo lukasanokino, lotu nu siyoliso. Siya mo Falisi moloso aluwai nokota. Siya mo takiso muwoni i nokota. ");
INSERT INTO amm_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Falisi nokota mo tota amu monoi Kotoso imoki, “Koto, yo mo noko siyai komiyai muwoi, no monoi no wafisu imo na timonoki. Toi mo nokoni nainomi tuwoko manono, molo koiyauso taluwai manono, nokoni nokolaloso tuwokaikalo manono. Motu na, ulai yo no anunani takiso muwoni i nokota koiyau komiyai? ");
INSERT INTO amm_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Yo mo saiso saiso pa tonomoiso, nonowoisu imo tolukasomoi. Wiko siyani ulo ti mo ainoso na, saiso saiso. Komaso hani hani ya no timoi no, yo mo naino ti tokunolokalomoi. Kunolokokai siyasonuso mo nonoso toni manonoki.” Falisi moloso aluwai nokota mo Kotoso aino imaloki. ");
INSERT INTO amm_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Takiso muwoni i nokotasu mo aluwamai na toloki. Na auwosiwaiki, Kotoso, no monoi no kumokiso pa you foinalikokiso. Mulu mo na kaloki, fokutonoso na wasoki, Kotoso na imoki, “Koto, yo mo molo koiyauso aluwai nokota. Mulu na pokalo unumono, na pofasimono.” ");
INSERT INTO amm_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Ya timonukuwo, nonani takiso muwoni i nokota mo mulu itouniyaimokai, Kotoni molo timai. Falisi moloso aluwai nokota, to mo Kotoni molo timai mo itouniyaimo muwoi. Motu na, noko mo noko siyoli tolo mulu yakimo, Kotoyo pa molokimoiso, na auwosisimoimo. Noko mo noko siyoli tolo mulu yo somiso mo, Kotoyo molokimoimo. Kotoni molo timai siyoli nokota toloimo.” Aino ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Nosai no mo; alalo lolofa koliyoniyo tumo liyai manokino, Isisoni auso, nainoyo isikokaikalo monoi. Ulai siyokutono iyaliyo mo alalo koliyoniyo tumoso kwaikokino mo, uo imo na ikokino. ");
INSERT INTO amm_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ulai Isiso mo alalo iyaliso aliyonikoki, “Kukuwo, yani auso mo waliyo na potiwo.” Siyokutono iyaliso na ikoki, “Tofolo na pukwaikokaiwo, alalo mo yani auso mo waliyo na tuo. Hani monoi talukikonuwo? Noko komaso noko mo ninani alalo komiyai no tosi no, toiso tosamukukomoi, Kotoyo mo. ");
INSERT INTO amm_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Motuwa na timonukuwo, Kotoyo noko nokolaloso samukuka tumakimo, alaloyo na iyamoimo, “Waliyo na posamukumoka tumo.” Moi mo aino iyamo somiso mo, Kotoyo pa samukukomoinuwoso.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Nosai no mo; nokotalo mo Isisoso na imoki, “Aiyolokomomoko itouniyaimo nokota, yo no moloi yoimo, woi, aniyopa poi poi tolokaino itouniyaimo monoi no?” ");
INSERT INTO amm_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ulai Isisoyo na imoki, “Hani monoi tokaluwaimononi, itouniyaimoso no? Koto saso mo itouniyaimo na. ");
INSERT INTO amm_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Nono mo Kotoni ami imo mo sai na, noino. Noko kwami nukonu mo noiyo uwokaisoi, noko mo noiyo tukoloi, noiyo polamokoi, noko siya monoi noiyo ifoluwai unoi, anoni apono noko tiso na pa kisosomikomoi. Kotoni imo nino, nono mo sai. Na piyomu.” ");
INSERT INTO amm_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Na imoki, nonani nokota mo, “Alusai na taluwaikomoi, nonani imo komaso mo.” ");
INSERT INTO amm_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Isisoyo tani imoso kwaimoki mo, na imoki, “Mulu siya mo amai piyo. Nani ilolu mo ilolu somiso nokoso na pa wautiyalo, ilolu komaso mo. No monoi no suo foli monoi anoinimo, kumokiso. Wau niko uwai; yoso pa aluwaimoniyo tumo.” ");
INSERT INTO amm_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ulai siyoli nokota no mo, to mo nonani imoso kwaiki mo, mulu na kaloki. Ulai afonimaiso nokota? Ilolu molopoi nokota nali. ");
INSERT INTO amm_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Nosai no mo; Isisoyo mo mulu kalokai muluso na kiki, noko nokolaloso na ikoki, “Ilolu molopoi noko no Kotoni auso no moloi toimo, asi no samukukaki no? Wiyou, nonani mi mo siyoli, muluso nali no. ");
INSERT INTO amm_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Siyokawi imo na pukwaiwo. Kamilo koloni siyoli no moloi lotiso monoi, iwoi nilini i poiso no? Moloi lotiso monoi, to mo sosoli. Ilolu molopoi nokota, to no Kotoni auso no moloi amiyo monoi, asi no samukukaki no? Moloi amiyo monoi, to mo sosoli. Ulai ya timonukuwo. Kamiloni mi, iwoi nilini i poiso lotiso monoi, nonani mi mo koufasu. Ilolu molopoi nokotani mi, Kotoni auso amiyo monoi, nonani mi mo soliyaki, muluso nali.” Siyokawi imo mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Noko nokolalo mo nonani imoso kwaimokino mo, na imokino, Isisoso, “Ulai aino mo, noi nokotayo no waliyo no moloi amiyoimo, Kotoni auso no? Noi no samiyaikiyoimo?” ");
INSERT INTO amm_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Isiso mo na ikoki, “Nokoyo no ulai moloi yo monoi? Kotoyosu mo waliyo na tiyo.” ");
INSERT INTO amm_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Nosai no mo; Pitayo imoki, “Koi mo kokaini asi yasoi na utukaikalokinoki, iloluwoi mani, utukaikalokinoki. Nonoso taluwainiyo tumonoki. Motu na piyomu.” ");
INSERT INTO amm_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","30","Na ikoki, Isiso mo, “Motuwa na timonukuwo. Mulumolo luwaimono noko, Kotoyo no samukuko no, toi mo hani hani utukaiko liyaiyakinomo, suo foli monoi mo siyoliso na nikoimo, ulai koufa, soliyakiso na nikoimo, asimai simai. Namolimaiso mani, aniyopa poi poi si itouniyaimoimo. Motu na, nu, noni, auwatono iyali, atino iyali, apitono iyali, alalo, no mo utukaiko liyaiyakinomo, suo foli monoi mo soliyakiso na nikoimo. Nonani hani hani tonofalowoi na soimo. Namolimaiso Kotoni auso na si itouniyaimoimo.” Siyokutono iyaliso aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Nosai no mo; Isiso mo noko molo tiwoi nokoso koliyonoki, na ikoki, “Na pukwaiwo, konoi mo Yolusolimoso na tonukoni. Komaso imo, Kotoni mulu lukasiko nokoyo toku no kulukaiyalokino no, asi asi noko nokolaloni noko siyoli nokota asa monoi, nonani imo mo aumoifaso motu na tumoimo. ");
INSERT INTO amm_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Noko nokonu nokoni nainoso kiyomonoinomo. Na alisiyoli yoluwaimonoinomo, koiyaumomonoinomo, usuwoyo aso kolomonoinomo, noko nokonu nokoyo, ");
INSERT INTO amm_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","suwoi suwoi moloyo wasomonoinomo, na tukolomonoinomo, yau. Amoloki tiwoi mo uwai; ulo siya mo ifou na auwoniyouwoimo.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Ulai siyokutono iyali mo sai muwoi, tani imo mo. Imo folosai mo amai kukalokokaiki. No ikoki no, toi mo sosoli. ");
INSERT INTO amm_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Nosai no mo; Isiso iyali mo Iyoliko nokonuso aumoifaso tiki mo, molo kau kau nokota mo molo kwamai piyousikainoki, noko nokolaloso pikomosiki, “Muwoni na ponimonowo.” ");
INSERT INTO amm_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nosai no mo; yousikainoki mo, noko nokolaloni somoso kwaikaloki, noko nokolalo molopoiyo molosai ti liyaiso. Nokoso ikoki, “Hani tanono?” ");
INSERT INTO amm_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Na imokino, “Isiso, Nasolito nokota mo na totumo.” ");
INSERT INTO amm_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nosai no mo; siyoliso na imaloki, “Isiso, nono mo Toiwini nakosaitono, na pomulu unumono, na pofasimono.” ");
INSERT INTO amm_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Noko toku no nu liyaiki no, toi mo ikimokino, “Oi, wosu woso.” Ulai siyoliso amai imaloki, “Nono mo Toiwini nakosaitono, na pomulu unumono, na pofasimono.” ");
INSERT INTO amm_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nosai no mo; Isiso mo na tola tumoki, noko nokolaloso ikoki, “Yani auso na pokiyomomona tumowo.” Molo kau kau nokota mo aumoifaso tumoki mo; Isisoyo na utolumoki, ");
INSERT INTO amm_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Nono no ya hani uwo monoi tiyoni?” Na fowaki, “Noko Siyoli, yani molo ti poposaso ulukomomono.” ");
INSERT INTO amm_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Nosai no mo; Isiso mo na imoki, “Nani molo ti mo waliyo na tofoinalikoni. Waliyo tomulumolo luwaimononi, no monoi no waliyo na totoloni.” ");
INSERT INTO amm_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Lolai siyaso to mo waliyo na toloki, na foinalikoki. Isisoso na aluwaiki, Kotoni siyoloso na kaluwaiyaloki. Noko nokolalo mani, foinalikoso kwaikino mo, Kotoso kisosomiyalokino. ");
INSERT INTO amm_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Isiso mo Yolusolimo moloso manoki mo, Iyoliko nokonuso na tumoki. ");
INSERT INTO amm_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Tolomu nokota mo toloki, tani siyolo mo Sakiyaso. Takiso muwoni i noko samukuko nokota siyoli, ilolu molopoi nokota nali. ");
INSERT INTO amm_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Isiso ki monoi yoki. Ulai noko nokolalo molopoiyo ukouniyaiko kukaikino, Isisoso. Moloi ki monoi? Noko mo foku nokota. ");
INSERT INTO amm_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","No monoi no mo, toku fumoki, aso na liyanoki, Isisoni amu molo ki monoi. To mo sai, Isiso mo ninani molosai tumo monoi nali no. ");
INSERT INTO amm_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Nosai no mo; Isiso mo nonani a folomai tumoki mo, na you kiki, na imoki, “Sakiyaso, somaiso na piyou lukono. Konoi mo nani nuso na tiyousano, yo mo.” ");
INSERT INTO amm_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","No monoi no somaiso na lukonoki, na molokiya konoki. Isisoso na imoki, “Yani nuso waliyo na potumo.” ");
INSERT INTO amm_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Sakiyasoyo Isisoso kauso kwaikino mo, noko nokolaloyo amuwaso alikino, iyamoki, “Molo koiyau nokotani nuso no hani monoi tiyousano, woi?” ");
INSERT INTO amm_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ulai Sakiyaso mo noko nokolaloni molo timai na tolauki, Siyoli Nokotaso na imoki, “Siyoli Nokota, na pukwaimono, yo mo konoimai mo yani iloluwoi muwoniwoi mo mulumai tokukaliyaiko. Siyai mo asani, siyai mo ilolu somiso nokoso tonikalo, na tuwauti. Ya afonimaiso no i watiki no, toiso yo mo ifou nikaloimo, toitati toitatiso.” ");
INSERT INTO amm_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Nosai no mo; Isiso mo na yomuki, “Lolai mo Sakiyaso koli mo na tosamiyaikiyo si. To mani, Apolofamoni alisaimi nali, no monoi no. ");
INSERT INTO amm_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Asi asi noko nokolaloni noko siyoli nokota yo mo molo koiyauso aluwai nokoso na tikolika tumo, samiyaikiyo si monoi, aiko uwokaikoi.” Isiso mo aino na yomuki. ");
INSERT INTO amm_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Nonani imoso yasoi kwaimokino mo; siyokawi imo mani, na ikoki. Ulai afonimaiso? Yolusolimo nokonu aumoifaso tumoki. Tumoki mo; noko nokolaloyo piyamoki, “Lolai siyaso Kotoyo na tosamukumoka tumo, kokaini molo timaiwo.” ");
INSERT INTO amm_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","No monoi no Isiso mo siyokawi imo lukasiyoluwaikoki, na ikoki, “Noko siyoli nokota mo asi aluwaso awa tomoi, samukuko nokota siyoliyo muwo monoi, tolomu nokoso samukuko tolo monoi. ");
INSERT INTO amm_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Manowoi muwoi, toku totani mi anononi nokoso taliyoniko, noko naino tiwoiso, muwoni nikalo monoi. Muwoni molopoi, 20 kina 20 kina tonikalomoi, siyasonuso. Na tiko, “Ninani muwoniyo mi na pa anomono manowo, ainoso hani yo mo ifou tumoimo.” ");
INSERT INTO amm_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ulai totani asi tolomu noko mo mulu tatolokomo ununo. No monoi no noko siyaiso tiko taikiyono, samukuko nokota siyolini auso, na tiyamo taikiyo, “Koi mo wiyou tiyamonoki, ninani nokotayo samukukomomoko mo. Noiyo muwoyoi. Tofolo.” ");
INSERT INTO amm_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ulai wiyou, noko siyoliyo imo mo pa tukwaikoso. Nonani nokotaso mo na tomuwokai, toi samukuko monoi. Muwokai mo; totani asi mo ifou totumo, nokoso tiko taikiyo, “Mi anomono noko iyali paliyonikowo, muwoni toku no nikoki no. Ya saino monoi, muwoni siyai moloi moloi ino.” ");
INSERT INTO amm_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Nosai no mo; totawoi nokota totola tumo, siyoli nokotaso na timo, “Siyoli nokota, yo mo nani 20 kinayo mi pano manoki, suo mo muwoni siyoli, 200 kina yo mo yasoi akoki.” ");
INSERT INTO amm_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Samukuko nokotayo na timo, “Nono mo yani mi anomono nokota itouniyaimo. Hani koufa monoi atiyaiso tiyo manoni, no monoi no yo mo na tomuwokainoki, nokonu nokonu naino tiwoi samukuko monoi.” ");
INSERT INTO amm_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Nosai no mo; noko siya mani, totola tumo, siyoli nokotaso na timo, “Siyoli nokota, yo mo nani 20 kinayo mi pano manoki, suo mo muwoni siyoli, 100 kina yo mo yasoi akoki.” ");
INSERT INTO amm_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Samukuko nokotayo na timo, “Yo mo tomuwokainoki, nokonu nokonu naino siyai samukuko monoi.” ");
INSERT INTO amm_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Nosai no mo; mi ano nokota siya mo totola tumo, siyoli nokotaso na timo, “Siyoli nokota, nani 20 kina mo fuo. Tunofamai na yalokonikokai. ");
INSERT INTO amm_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Ulai afonimaiso? Yo mo nimokinoki, itotolo nokota, nono mo. Wiyou, mi siyoli tanononi manonoki, mulu mo folokomomokokai. Ulai mi ano foli monoi mo nonayosu ti manoni. Koi monoi mo pa tomulu unumoko manoniso.” ");
INSERT INTO amm_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Nosai no mo; samukuko nokotayo na timo, “Nono mo yani mi anomono noko itouniyaimo muwoi, koiyau. Nonani imo monoisosu na uwoyoikimo, mi koiyau foli monoi. A, yo no itotolo nokota? A, moi no mi siyoli na tanomono manonuwo? A, mulu no folokomokainuwo? A, mi ano foli monoi no asasoso na timoi? A, moi monoi no pa tomulu unu manonukuwoso? ");
INSERT INTO amm_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Motu na tiyomuni. Ulai hani monoi yani muwoni no muwoni suo suomoko nokoni nainomai pa akaikokiniso? Aino piyoni mo, yo mo muwoni siyaiwoi piya tumo, toini nainosai.” ");
INSERT INTO amm_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nosai no mo; aumoifaso si nokoso tiko, “20 kina na pakowaiwo, 200 kina nokotaso monoi pakononiwo.” ");
INSERT INTO amm_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ulai toiyo timono, “Siyoli nokota, to mo muwoni siyoli yasoi na ako, 200 kina. Hani monoi takononini?” ");
INSERT INTO amm_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Nosai no mo; na tiko, “Ya timonukuwo, hani hani molopoiwoi noko mo no monoi no, yo mo hani hani niko manoimo. Nokosu mo hani hani mo uwofawo, koufasosu mo yapoli, nonani koufa hani mo ya uwokoimo. ");
INSERT INTO amm_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ulai uo noko iyali, wiyou no iyamo unumonokino no, ya samukuko monoi mo, nonani noko iyali mo na pokolisalowo, pa koliyo tumomonowo. Asani molo timai na pa tukuwoliwo, yau yau.” Siyokawi imo mo aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Isiso mo nonani imo lukasiko uwai; nosai no mo; toku manoki, Yolusolimo nokonu siyoli molomai. Siyokutono iyaliyo tanomokino. ");
INSERT INTO amm_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nu manoki mo, nokonu lolofa ti mo fiyamosiya tumokino, Pitifaki nokonuwoi Pitano nokonuwoi. Oli yu kiyoku kwamai tanono, nokonu ti mo. Tiki mo; nosai no Isiso mo siyokutono noko tiso na iko taikiyoki, ");
INSERT INTO amm_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","na ikoki, “Nokonufaso na pomanowo, na pa lotiwo, nokonu aumoifaso ni tokinuwo no. Lotakinuwomo, na kiyoinuwomo, hosofa mo. Konosuwakaiso kiyoinuwomo. Toku nokoyo yousa yowoi muwoi. Na pako fololokomowo, yani auso na pako kiyomomona tumowo. ");
INSERT INTO amm_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ulai nokoyo utolumakinuwomo, “Hani monoi tofololokomonuwo, hosofa no?” Noino na pako imowo, “Siyoli Nokotayo timoko taikiyo, ninani hosofa kiyomo monoi.” ");
INSERT INTO amm_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Nosai no mo; iko taikiyoki mo; toti mo na manokino. Isisoyo no ikoki no, ainoso na kiyanokino. ");
INSERT INTO amm_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Hosofani moloso fololokomokino mo, hosofa kiyo noko iyaliyo ikokino, “Hani monoi tofololokomonuwo, hosofa no?” ");
INSERT INTO amm_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Na fowakokino, “Siyoli Nokotayo timoko taikiyo, ninani hosofa kiyomo monoi.” ");
INSERT INTO amm_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Nosai no mo; yasoi, hosofa kiyoma tumokino, Isisoni auso mo. Totini tuno mo hosofani namoli tonimai na akaikoma yokino. Akaikoma yokino mo; Isiso mo na you kiyo taikiyokino, hosofani namoli toniso yousikaina yo monoi. ");
INSERT INTO amm_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","You kiyo taikiyokino mo; na liyai kalumaniki, hosofayo. Noko nokolaloyo tuno mo molomai asisikaiya tumo liyaikino, na soikai unalokino. ");
INSERT INTO amm_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Oli yu fonomai potumoki. Molo mo woiso monoi tolo konoki. Yolusolimo nokonu mo aumoifaso. Nomai no mo siyokutono iyali molopoi mo molokiyalo liyaikino, Kotoso na kisosomiyalokino. No mo afonimaiso muwoi, mulu ifolaluwawoi mi Isisoyo anoso pukwai manokino, no monoi no siyoliso iyamaloki, Kotoso kisosomiyalokino. ");
INSERT INTO amm_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Noino iyamaloki, “Moini samukumoko nokota siyoli, Noko Siyolini amimai ni totumo no, tani siyolo na tokaluwaiyaloukoni.” “Kumoki tolomu nokota siyoli mo mulu mo waliyo, moi monoi. Kota Kotoni siyolo tokaluwaiyaloukoni.” ");
INSERT INTO amm_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Falisi moloso aluwai noko siyai, no ukouniyaiko si tomasikokino no, toi mo na imokino, Isisoso, “Aiyolokomomoko nokota, nani siyokuno iyaliso na pikiko, iyamaloi.” ");
INSERT INTO amm_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Nosai no mo; Isiso mo na ikoki, “Ya timonukuwo, toiyo iyamalo somiso mo, ulai tomokiyosu na iyamaloimo.” ");
INSERT INTO amm_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Nosai no mo; Yolusolimo nokonu aumoifaso na komama tumoki. Isiso mo nokonuso kiki mo, na sonukukoki, tolomu noko nokolaloso. ");
INSERT INTO amm_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Na yomuki, “Momai mo Kotowoi si tomasimo monoi mo sai muwoi. Si tomasimo monoi lolaimai posainonuwo mo, waliyo na posinuwo. Ulai lolai mo nonani hani hani kukalokokai si, pa tosainonuwoso. ");
INSERT INTO amm_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Amuwoi tino mo uo nokoyo ti unoinuwomo, na woliyai una tumoinuwomo, koloso una tumoinuwomo. Moi no moloi ulolo monoi? ");
INSERT INTO amm_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Wiyou, na uwokaikomoinuwomo. Kokikokai poiso tukuwoliyoinuwomo, yau yau. Nu mani, na ulaloulu waninoinuwomo, uwofa nali. Ulai afonimaiso? Koto tumomai pa tomulumolo luwainuwoso.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Nosai no mo; Isiso mo lotu nu siyoliso na lotiki. Hani hani suo suomoko noko iyaliso na amiyaikiyoko taikiya tiki. ");
INSERT INTO amm_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Na ikoki, “Kotoni puko imoyo mo na tiyomuko, “Yani nu mo asaso utolumomono nu.” Ulai moisu mo noko nokolaloni muwoni ti wati manonuwo. Wiyouwa wiyou, ni mo polamoko nu muwoi.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nosai no mo; saiso saiso ulo ulo Isiso mo noko nokolaloso paiyolokomosiki, lotu nu siyoli poiso. Lotu samukuko noko sisiyoliwoi Musini imo sai sisiyoli nokowoi nokotalo iyaliwoi, toi mo Isiso tukolo molo monoi lukaso unukino. ");
INSERT INTO amm_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Noko nokolalosu mo tani imososo pukwaimo itouniyaimo manokino, no monoi no mo nokotalo iyali no ulai moloi tukolo monoi? ");
INSERT INTO amm_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Nosai no mo; ulo siyamai Isiso mo Kotoni imo itouniyaimo aiyoloko toloki, noko nokolaloso, lotu nu siyoli poiso. Aiyoloko tolo manoki mo, noko sisiyoli mo tiki, lotu samukuko noko sisiyoliwoi Musini imo sai sisiyoli nokowoi Isolilo nokotalo iyaliwoi. Na kiya tumokino, ");
INSERT INTO amm_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","na imokino, “Na pimoko, noini amiyo nonani mi ano monoi no? Noiyo imo taikiyokini?” ");
INSERT INTO amm_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Na ikoki, “Yo mani, imo siya utolumo monoisu na tiyo. ");
INSERT INTO amm_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Iyono mo noko mo iwoso puluwako manoki. No mo asini hani poimo, kumokini hani poimo. Moloi tiyamonuwo, na pimonowo.” ");
INSERT INTO amm_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Nosai no mo; totai amu mo na lukasikuwanokino, na iyamoki, “Moi mo iyamakikonimo, “No mo kumokini hani nali no,” to mo imokoimo, “Hani monoi totani imoso pa mulumolo luwaikinuwoso?” ");
INSERT INTO amm_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ulai iyamakikonimo, “No mo asini hani nali no,” noko komasoyo tomoki salosomomokoinomo. Ulai afonimaiso? Toi mo Iyonoso waliyo tomulumolo luwaino, tiyamo, “Kotoni mulu lukasiko nokota na.” ");
INSERT INTO amm_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Totai amu lukasikuwanokino mo; Isisoso na imokino, “Koi mo sai muwoi, Iyono no iwoso uluwako no noini amiyo, woi? Noiyo poimo imo taikiyoki.” ");
INSERT INTO amm_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Nosai no mo ikoki, “Noinoso na, yo mo pa imoikuwoso, yo mani, noiyo poi imono taikiyoki, yani mi ano monoi mo.” ");
INSERT INTO amm_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Nosai no mo; Isiso mo siyokawi imo sopo posasokoki, noko nokolaloso na ikoki, “Noko mo aliyoli ali na tikaiyalo, isiso. Ikai uwai; isi mi ano nokoso na tikano, “Yani isi posamukumonowo.” Ikano mo; noko nokonu nokoni asiso na tomoi, totolokainano. ");
INSERT INTO amm_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Nosai no mo; wamo wamokomai nonani nokota mo mi ano nokotaso timo taikiyo, isi samuku nokoni auso. Na timo taikiyo, “Isini no siyai na pimonano.” Ulai isi samuku noko mo nonani mi ano nokota na tuwasono, afonimaiso ifou tamiyaikiyo taikiyono. Isi aliyoli pa toninoso, niwoi muwoi. ");
INSERT INTO amm_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Nosai no mo; ti monoi mani, mi ano nokotaso timo taikiyo. Ulai nonani nokota mani, na tuwasono, na tuwokaino. Afonimaiso ifou tamiyaikiyo taikiyono. Isi aliyoli pa toninoso, niwoi muwoi. ");
INSERT INTO amm_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Nosai no mo; tau monoi mani, mi ano nokotaso timo taikiyo. Ulai na tuwasono, wiyou nako mo iwo topi, asiyofoloso tafoliyo funo. ");
INSERT INTO amm_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Nosai no mo; isi kiyo nokota mo tiyomu, “Yo no moloi yoimo, woi? Yo no tomulu unu no, yani alu mo ya kiyoko taikiyoimo. Nakomo auwosiwaiyoinomo poimo.” Aino tiyomu, awitonoso timo taikiyo, “Na pomoi.” ");
INSERT INTO amm_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ulai isi samuku nokoyo awitonoso tumoso tukwaino mo, totai amu tikuwanono, “Anunani nokota mo amuwoi tino mo apitononi isi kwalomai monoi na anoimo. Moi soi, niya totukolokoni. No monoi no ninani isi mo momaini na ano monoi.” ");
INSERT INTO amm_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ikuwanono; awitonoso asiyofoloso na tafoliyo funo, na totukolono, yau. Moloi woi? Isi kiyo nokotayo mo moloi poimo uwokoi. ");
INSERT INTO amm_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ya timonukuwo, isi samuku noko iyali mo isi kiyo nokotayo na tukuwoliya tumoimo. Isi mo noko siyaiso na atiya tumoimo, samuku monoi.” Isiso mo siyokawi imo aino ikoki. Noko mo nonani imoso kwaikino mo, na iyamoki, “Wiyouwa wiyou, aino muwoi.” ");
INSERT INTO amm_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ulai Isiso mo amiso kokoki, na ikoki, “Kotoni puko imoyo ainonani monoi na tiyomuko, noino, “Nu kololi nokoyo a moki mo afoli taikiyokino, piyamoki, afonimai a koiyauwo. Ulai Siyoli Nokotasu mo nonani a moki na ikaiki, sopo i a na.” Imo folosai no moloi? Moloi tiyamonuwo? ");
INSERT INTO amm_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ya timonukuwo, noko mo nonani sopo i asai kitolomo taikiyakimo, uwokaikaiyoimo. Nonani ayo nokoso itokolimakimo, to mo kolisoulukai anoinomo. Yo mo nonani a komiyai.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Musini imo sai sisiyoli nokowoi lotu samukuko noko sisiyoliwoi, toi mo sai, Isiso mo nonani siyokawi imo toi monoi yomu ukuki. No monoi no kominalomano monoi louwa fi, somaiso tukolo monoi. Ulai noko nokolalo monoi nikokino. ");
INSERT INTO amm_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Nosai no mo; nokotalo iyali mo Isisoni imo lukaso monoi kwailuwaimokino mo, nokoso iko taikiyokino, wosu woso kwailuwaimo monoi, asuwo ima imo utolumalowo. No monoi no tani imo kwailuwaimokino. Komano nokota siyoliso faumiyano monoi yokino, no monoi no. ");
INSERT INTO amm_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","No iko taikiyokino no, toiyo noino na imokino, “Aiyolokomomoko nokota, koi mo sai, nono mo imo mo motu imo nokota nali no. Kotoni imo na taiyolokalo manoni. Motu imo saso na tiko manoni. Imo alinoso na tiko manoni, noko sisiyoliwoi afonimai nokowoiso. Kotoni molo monoi na taiyolokalo manoni. ");
INSERT INTO amm_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Moloi tomulumolokoni? Moi no takiso muwoni no waliyo toni manokoni, Lomo nokota siyoliso no, Sisiso no? Wiyou poimo.” ");
INSERT INTO amm_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Ulai Isiso mo sai, toini ifoluwai mulu monoi mo. Na ikoki, ");
INSERT INTO amm_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Tomoki muwoni na powiyosomonowo. Komuwoi muwoni no noini na, woi? Noini siyolowoi taso?” Na imokino, “Sisi, Lomo nokota siyolini nawoi siyolowoi taso.” ");
INSERT INTO amm_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Nosai no mo; na ikoki, Isiso mo, “Sisini hani mo Sisiso na poniwo. Kotoni hani mo Kotoso na poniwo.” ");
INSERT INTO amm_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ulai tani imo lukaso monoi moloi faumiyano monoi, noko nokolaloni molo timai no lukasoki no? Mulumoloko manokino, nonani imo monoi no fowakoki no. Wosu wososo siki. ");
INSERT INTO amm_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Nosai no mo; Satusi moloso aluwai noko mo Isisoso ima tumokino. Toi mo noko no mo, no tiyamomoi no, “Yau yau noko mo ifou pakoso auwonouloiso.” ");
INSERT INTO amm_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Isisoso na ima tumokino, “Aiyolokomomoko nokota, Musini aniyopa imoyo mo noino na tiyomuko, moi monoi mo. Noniwoi nokota mo ali somisomai kalo mo, tani noni mo auwatonoyo na kausumo, to kwalomai monoi. Alu kiyakinomo, nonani alu mo auwatono kwalomai monoi na tolumo. ");
INSERT INTO amm_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Koi timonoki, noino, toku auwa auwa noko iyali nano siya, 7 na siki. Imu alu mo noni na kausoki, ali mo kiwoi muwoi, nosai no mo yau. ");
INSERT INTO amm_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Nosai no mo; auwatono kwalomai monoi na kausoki, Nokiyamoyo. To mani, ali mo kiwoi muwoi, yau. ");
INSERT INTO amm_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Noino noinoso nali no. Yamu alu mani, nonani nukonu kausoki, yau. Imaliwoi Imamuwoi Imowawoi Liyaliwoi, toi komaso mo nonani nukonusoso na kausalo manokino, ulai aliwoi kokowoi muwoi, yau yau. ");
INSERT INTO amm_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Namolisai mo nonani nukonu mani, yau, yasoi na kalosoki. ");
INSERT INTO amm_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ulai yau yau noko mo ifou auwonoulakimo, nonani nukonu no noini kwamitono tolosoimo, noiyo kausoimo? Toku nano siyawoi auwatono noko koli koliyo kausalo manokino.” ");
INSERT INTO amm_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Nosai no mo; Isiso mo na ikoki, “Lolaimai si noko nokolaloyo tokolikuwano manono. ");
INSERT INTO amm_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Yau yau noko nokolalo auwonoulakimo, toi mo pa kolikuwanoinoso. Kotoyo waliyo no tiyomu uku no, yau yausai auwonoulu monoi, namolisai amai si mano monoi, toi mo yau yausai auwonoulakimo, pa kolikuwano manoinoso. ");
INSERT INTO amm_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ti monoi pa kolikaliyoiso, no monoi no. Kotoni kumoki noko komiyai na soimo, susauwoso. Kotoyo yau yausai na lusokokaiyakimo, Kotoni alalo na soimo. ");
INSERT INTO amm_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Musiyo mani, yasoi na wiyomokoki, noko yau yausai auwonoulu monoi mo. Tayo afaso fofoumo aino imo lukasikoki mo, na yomuki, “Siyoli Nokota mo Apolofamoni Koto, Isakoni Koto, Yokoponi Koto.” Toku kolikali noko monoi aino na yomuki. ");
INSERT INTO amm_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Koto mo kolikali nokoni Koto muwoi, amai si nokoni Koto na. Totani molo timai mo noko mo pa tokolikalikaimoiso, aniyopa poi poi si manoimo, toso mulumolo luwaiyakinomo.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ikoki mo; Musini imo sai sisiyoli noko siyai mo na imokino, “Aiyolokomomoko nokota, imo mo itouniyaimoso na tiyomuni.” ");
INSERT INTO amm_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","No monoi no nokoyo utolumo monoi mo nimo manokino, pa utolumo manokinoso. ");
INSERT INTO amm_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Nosai no mo; Isiso mo na ikoki, “Hani monoi tiyamomoi, woi, “Kotoyo muwokai nokota Kolaiso mo Toiwini nakosaitonosu.” ");
INSERT INTO amm_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Kotoni siyolo kaluwai si pukomai Toiwi tota mo tani nakosaitono monoi na yomu unuki, noino, “Siyoli Nokotayo yani Noko Siyoliso na imoki, “Yani nainasai na piyousikaino. ");
INSERT INTO amm_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Yousikaino manakinimo, ainoso hani nono uo noko mo nani fiyo wosuwoimai soimo, yani amiyo.” ");
INSERT INTO amm_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Na pomulumolokowo. Toiwi totayosu mo kaluwaiki, Noko Siyoli na. Moloi monoi woi? Ulai Toiwini nakosaitonosu no?” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Noko nokolalo molopoi nokoyo amai kwaimo si manoki mo, Isiso mo siyokutono iyaliso na ikoki, ");
INSERT INTO amm_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Atiyaiso na pa siwo, Musini imo sai sisiyoli noko monoi. Tuno sopo sopo asisiko monoi tiyo manono, liyai niko monoi. Asuwo noko nokolaloyo kwaiko monoi tiyo manono. Ukouniyaikomai nokoyo “woli iyali moi kuo” imo iko monoi tiyo manono. Lotu numai nokotalo iyalini nu simai sinono monoi tiyo manono. Koloni wasimai mani, noinoso na, noko nokolaloyo kwaiko monoi tiyo manono. ");
INSERT INTO amm_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Susawi nokolalo tifoluwaiko manono, ilolu i wati monoi. Kotowoi imo lukasomai totopoko manono, imo sopo soposo tolukasalo manono, asuwo asuwo. Kotoyo noko nokolalo wauwakimo, soliyakiso na uwokoimo, wiyou, soliyakiso na.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Nosai no mo; Isiso mo foinalikoki, muwoni inaloso kwaikoki, lotu nu muwoni isikokai pokiliso, Kotoni mi ano monoi muwoni na. Muwoniwoi nokoyo inaloso kwaikaloki, ti liyai manoso. ");
INSERT INTO amm_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ulai sawi nukonuso mani, kwaisoki, muwoni lolofa tisu analika tumoso, ilolu somiso nukonu na. ");
INSERT INTO amm_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nosai no mo; siyokutono iyaliso na ikoki, “Motuwa na timonukuwo. Noni sawi ni mo, ilolu somiso nokonu ni mo, to mo muwoni mo siyoli na tanalika tumo. Noko nokolalo siyaiso na tosouwaiko. ");
INSERT INTO amm_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Muwoniwoi noko mo muwoni molopoi mo amai na si. Walotofaso nino, Kotoso. Ulai noni to ni mo, to mo muwoni mo uwofa nali no, komaso yasoi na ni, Kotoso. Koloni no ulai haniyo suo suomokoimo? Muwoni mo uwofa nali no.” ");
INSERT INTO amm_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Nosai no mo; siyokutono iyali siyai mo lotu nu siyoli monoi imo lukasokino, iyamoki, “Lotu nu mo tomoki ititouniyo na kouwokai. Hani hani nokoyo Kotoso no nikino no, wiyou, na kouwokai.” Ulai Isiso mo na ikoki, ");
INSERT INTO amm_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Ni tokokonuwo no, amuwoi tino mo na ulalokoinomo. Tomoki puwomai ni si mo, amai pa soiso. Komaso na ulaloko taikiyoinomo.” ");
INSERT INTO amm_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nosai no mo; Isisoso na utolumokino, “Aiyolokomomoko nokota, maniwoiso no lotu nu ulaloinomo? Toku no haniyo fiyamosiyoimo, koi saino monoi no? Nonayo piyomu.” ");
INSERT INTO amm_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Isiso mo na fowakoki, “Atiyaiso na pa siwo. Wonikaluso nokoyo aiko ifoluwaikomoinuwomo. Noko molopoi na toimo, ifoluwaikoma tumoinuwomo, iyamaloimo, “Yo mo Kotoyo muwomonokaiki, Isolilo noko moi fasikoma tumo monoi.” Noino mani, iyamaloimo, “Asi mo aumoifaso na fokumoimo.” Moisu mo noiyo aluwaikoiwo. ");
INSERT INTO amm_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Uo tukoluwano umanoso kwaiyakinuwomo, noiyo umomalotikomoiwo, uo uwokuwano imo monoi. Nonani hani mo toku fiyamosoko liyaiyoimo. Ulai asi fokumo mo aumoifaso pa toiso.” ");
INSERT INTO amm_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ti monoi na ikoki, “Asi siya noko mo noko siyai nokowoi uo tukoluwanoinomo. Noko nokonu noko mo tolomu nokowoi uo tukoluwanoinomo. ");
INSERT INTO amm_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nou nou sisiyoli mo asisai auwonoulu liyaiyoimo. Noko mo koloni somiso si liyaiyoimo, tiya sisiyoliyo kolikali si liyaiyoimo. Ai ai uwokaikaloimo. Kumokisai mani, wiyou, hani hani fiyamosokaloimo, momaini molo timai, na kokolokomoinuwomo. ");
INSERT INTO amm_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ulai nonani hani hani fiyamosoko somisomai uo nokoyo na kuloloinuwomo, na uwokomoinuwomo. Kiyokomaloinuwomo, lotu nu lolofa poiwoi kalopulo nuwoiso. Nokoyo uo imo lukaso unanoinuwomo, sisiyoli nokoso, komano nokoso mo. Ulai afonimaiso? Moi mo yoso tomulumolo luwaimono manonuwo, no monoi no uwokomoinuwomo. ");
INSERT INTO amm_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Noko sisiyoli nokoni molo timai sakinuwomo, Kotoni imo mo waliyo pa posasoko wiyolukowo. ");
INSERT INTO amm_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","No monoi no mo mulu mo noiyo kolikaliyoiwo, hani imoso ikonuwowo. ");
INSERT INTO amm_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Asayo mo na posasoko wiyolumoikuwomo, no ikakinuwo no. Asayo noinomo mulu iwoi soinuwomo. Uo nokoyo no moloi fowakomo monoi? Moini imo pa kulalikomoinuwoso. ");
INSERT INTO amm_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Siyokuno iyaliyo uo nokoni auso kiyokomoinuwomo. Anoni apono noko iyaliwoi auwano iyaliwoi nako siyamai nokowoi, toiyo mani, uo nokoni nainoso kiyokomoinuwomo. Moi siyai mo na tukuwoliyoinuwomo, yau yau. ");
INSERT INTO amm_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Noko komaso nokoyo mulu atolokomo unoinuwomo. Ulai afonimaiso? Moi mo yani noko nokolalo na. ");
INSERT INTO amm_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ulai ya timonukuwo, pa uwokaikomoinuwoso. ");
INSERT INTO amm_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Amiso sakinuwomo, na samiyaikiyoinuwomo.” Isiso mo aino na ikoki, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Nosai no mo; Isiso mo ti monoi na ikoki, “Uo nokoyo Yolusolimo nokonuso woliyai una tumoso kwaikakinuwomo, no monoi no moi mo pa sainowo, Yolusolimo nokonu mo aumoifaso na uwokaiyoinomo. ");
INSERT INTO amm_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Nonani ulomai Yutiya asiso si noko nokolalo moi mo yu nokonuso pa uloloniyo yowo. Yolusolimo noko nokolalo moi mani, tolomuso na pa utukaimowo. Nokonu asiyofolosai si noko nokolalo mani, nokonu siyoliso noiyo toiwo. ");
INSERT INTO amm_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Nomai no mo Kotoyo molo koiyau foli monoi na uwokomoinuwomo. Tani puko imoyo no tiyomukalo no, no mo motu na fiyamosiyoimo. ");
INSERT INTO amm_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Nomai no, woi. Muwoliwoi nokolalo, woi. Paumai alalo atino iyali, woi. Molo koiyau foli monoi siyoliso na uwokomoinuwomo, ninani asi noko nokolalo moi mo. Kotoyo mulu atolokomo unoinuwomo, totani Yuto noko nokolalo moi monoi. ");
INSERT INTO amm_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Muwo sopo sopoyo na tukuwoli uwaimoinuwomo. Uo nokoyo koliso tumakinuwomo, noko nokonu nokoni asiso kiyokomo liyaiyoinuwomo, kalopuloso. Noko nokonu noko mo moini Yolusolimo nokonuso towitoloma tumoinomo. Towitolomo manoinomo, ainoso hani Kotoyo alukikoimo.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Nosai no mo; Isiso mo na ikoki, “Ulo amu amoloku folo folo na alosokoimo, momaini molo timai mo. Asi asi noko nokolalo mo mulu na kolikaliyoimo. Mamo iwo siyolini mi umuko siyoliso kwaiyakinomo, na mulumoloko manoinomo. ");
INSERT INTO amm_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Poiniyaikoimo, asiso hani haniyo poimo fiyamosokoi. Na kokolokoimo, molowoi na folulumokoimo. Ulai afonimaiso? Hani hani sisiyoli kumokiso you si, nonani hani mo kumolokoimo. ");
INSERT INTO amm_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nomai no mo, ya amukonoimo. Asi asi noko nokolaloni noko siyoli nokota yo mo na amukonoimo. Yo amukonoso you kimonoinomo, noko nokolaloyo, kuomai amukonoso. Wiyou, ami siyoliwoi amukonoimo, Kotoni saponi yakomaiso. ");
INSERT INTO amm_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nonani hani hani mo lolaloso fiyamosokakimo, amiso na pa sauwo, puwoso monoi na pa foinalikowo. Kotoyo aumoifaso kolisoinuwomo.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Nosai no mo; Isiso mo siyokawi imo na ikoki, noino, “Sipoki aso na pokokowo. A siyaiso mani, na pokokalowo. ");
INSERT INTO amm_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Iwasuwo tomu tonofalo na tomomoloko taikiyo. No mo moi mo sai, fumu itouniyaimo monoi. ");
INSERT INTO amm_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Noinoso nali, kumokisai fiyamosoko hani haniso kwaikalakinuwomo, moi mo sai, Kotoyo aumoifaso samukukoma tumakinuwomo. ");
INSERT INTO amm_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Motuwa na timonukuwo. Noko komaso noko kolikali somisomai, nonani hani hani mo na fiyamosokaloimo. ");
INSERT INTO amm_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kumokiwoi asiwoi mo uwaimo taikiyoimo. Yani imosu mo amai na tanoimo.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Nosai no mo; Isiso mo siyokutono iyaliso na ikoki, “Atiyaiso na pa siwo, kwalu kwalu iwo aiko sikoinuwo, aiko kwalu kwalukomoinuwo. Wonikaluso asiso si itouniyaimo monoiso mulu kolikaliyoinuwomo, Kotoyo lolai siyaso aiko uwokomoinuwo, la komiyai la wiyoso aiko kunokomoinuwo, yo tumomai mo. ");
INSERT INTO amm_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Asi asi noko nokolalo komasoso na uwokaloimo, molo kopokoiyauso aluwaiko foli monoi. ");
INSERT INTO amm_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Moi mo atiyaiso na pa si manowo. Kotoso saiso saiso pa utolumo manowo, mulu amikomo monoi. No monoi no kopokoiyauso souwaikoinuwomo. Asi asi noko nokolaloni noko siyoli nokota asani molo timai na soinuwomo.” Siyokutono iyaliso aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Isiso mo noko nokolaloso saiso saiso paiyolokomosiki, lotu nu siyoli poiso, ulo ulo. Amolokimai mo yuso potana yomosiki, Oli yu no kaluwai manokino no, nonani yuso na. ");
INSERT INTO amm_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Noko nokolalo mo somosaiyamai na potimosiki. Lotu nu siyoli poiso pukwaima tumomosikino. ");
INSERT INTO amm_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Nosai no mo; sisiyoliko asu somiso tuo wasi popo mo aumoifaso. Siyolo siya mo Pasowa koloni wasi popo pokaluwai manokino. ");
INSERT INTO amm_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Nomai no mo, lotu samukuko noko sisiyoliwoi Musini imo sai sisiyoli nokowoi, toi mo noko nokolalo monoi kokolokoki, na ikuwanokino, “Moi no Isiso no moloi tukolo monoi, woi?” ");
INSERT INTO amm_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nosai no mo; Sokolo Nokota Waiyo Yutasoni mulu poiso na lotiki. Siyolo siya mo Isokailiyo pokaluwai manokino. Noko molo tiwoi mulumai nokota na. ");
INSERT INTO amm_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Noko sisiyoliwoi lukaso nikanoki, lotu samukuko noko sisiyoliwoi lotu nu polimano noko sisiyoliwoi. Nonani noko iyaliso na ikanoki, “Yo mo Isisoso kiyoma tumoikuwomo.” ");
INSERT INTO amm_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Wiyou, toi mo siyoliso na molokikino, imo lukaso nikaikino, na imokaikino, “Suo mo muwoni niyoikimo.” ");
INSERT INTO amm_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Nosai no Yutaso mo ikoki, “Waliyo na.” Mulumolokaloki, “Yo mo Isiso mo maniwoiso poimo kiyokoi, toini nainoso mo. Awi, noko nokolaloyo ukouniyaiko somisomai mo waliyo.” ");
INSERT INTO amm_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nosai no mo; sisiyoliko asu somiso tuo wasi ulo auwoniyouki, Pasowa koloni tukuwolimosi ulo na. ");
INSERT INTO amm_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Nosai no mo; Isiso mo Pita noko tiso Iyonowoi iko taikiyoki, na ikoki, “Na pofoukaimokanowo, Pasowa koloni noko monoi mo.” ");
INSERT INTO amm_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ulai totiyo imokino, “Moloi tiyomuni, moiso tofoukaiyanonoki, woi?” ");
INSERT INTO amm_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Na ikoki, “Na pukwaimonowo, nokonu siyoliso lotakinuwomo, nokoyo iwo woliyoniyo tumoso kwaiyoinuwomo. Nu poiso pa aluwainiyo tiwo. ");
INSERT INTO amm_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Nu kiyo nokotaso na pa imowo, “Aiyolokomomoko nokotayo tiyomu taikiyo, “Pasowa koloni no si nu no moiso, woi, yani woli iyaliwoi no niko si nu no?” ");
INSERT INTO amm_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Nosai no puwo nu siyoli mo ta na wiyononinoinuwomo. Nokoyo hani hani toku yasoi isikokai foukai. Nonani nu simai mo na pa foukaiwo, Pasowa koloni mo.” ");
INSERT INTO amm_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ikoki mo; toti mo manokino, na kikino, Isisoyo toku no ikoki no. No monoi no Pasowa koloni na foukaikino. ");
INSERT INTO amm_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Nosai no mo; Isiso mo Pasowa koloni wasi nikoki, totani imo lukasikalomano nokowoi. ");
INSERT INTO amm_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Na ikoki, “Yo mo Pasowa koloni no nikomo monoi siyoliso tiyomoi. Aumoifaso iyanoko siyoli na uwomonoinomo. ");
INSERT INTO amm_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ya timonukuwo, yo mo ti monoi Pasowa koloni mo pa noiso, asimai mo. Koto mo asi asi noko nokolalo samukukakimo, nomai noso ti monoi na noimo.” ");
INSERT INTO amm_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nosai no mo; molo wamo ito iwo na woliyonoki, Kotoso na imoki, “Wafisu.” Siyokutono iyaliso na ikoki, “Fuo, na posikalowo. ");
INSERT INTO amm_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ya timonukuwo, yo mo molo wamo ito iwo mo ti monoi pa sikoiso, asimai mo. Kotoyo asi asi noko nokolalo samukuka tumakimo, nomai noso ti monoi na sikoimo, yo mo.” Aino ikoki. ");
INSERT INTO amm_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nosai no mo; tuo na anoki, na imoki, Kotoso, “Wafisu.” Na foloulu nikoki, na ikoki, “Ni mo yani au somu na. Moi fasikomo monoi kalo unoikuwomo. Nokakinuwomo, yoso na pa mulumoloko unumonowo.” ");
INSERT INTO amm_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Noko uwai, tomoso nali, molo wamo ito iwo nau na woliyonoki, na ikoki, “Naumai mo yani nako na. Moi kwalomai monoi kalo unoikuwomo. Yani nako amukonakimo, Kotoyo auwolo unoinuwomo, molo tonofalo posaso wiyononinoinuwomo. ");
INSERT INTO amm_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ulai na pukwaiwo, uo nokoni auso no kiyomonaki no, to mo ni tiyousi tomasimomono. ");
INSERT INTO amm_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Asa, asi asi noko nokolaloni noko siyoli nokota yo mo Kotoni imoso aluwaiyoimo, Kotoyo ainonani monoi muwomonokaiki. Wiyou, to fau, uo nokoni auso kiyomono nokota no moloi uwoyoimo, woi?” ");
INSERT INTO amm_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Aino ikoki mo; totai amu na utolukuwanalokino, “Noiyo yoimo, woi?” ");
INSERT INTO amm_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Nosai no mo; Isisoni siyokutono iyali mo totai amu kiyoluwaikuwanokino, siyasonuso iyamaloki, “Nokoyo tiyamo, asa mo totawoi nokota siyoli.” ");
INSERT INTO amm_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ulai na ikoki, Isiso mo, “Noko nokonu nokoso samukuko noko sisiyoli mo totamiyoluwaiko manono, toini noko nokolaloso. Alotoluwaiko noko iyali mo totai amu monoi tiyamalo, samukuko ititouniwo. ");
INSERT INTO amm_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Momaisu mo toi komiyai noiyo yoiwo. Moi nokota mo totawoi nokota siyoli mo, to mo auwanofa komiyai tolumo. Moi samukukomo nokota mo mi ano fasi nokota komiyai na tolumo. ");
INSERT INTO amm_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Noi no siyoli nokota, woi? Koloni foukai nokota poimo, o, koloni no yousi nokota poimo. Motu na, koloni no yousi nokota mo siyoli nokota nali. Ulai asasu mo moini mulumai na tiyousi, mi ano fasikomo nokota na. ");
INSERT INTO amm_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Hani haniyo uwomonomai na tosi tomasimomono manonuwo, pa tutukaimononuwoso. ");
INSERT INTO amm_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Yani Apouyo mo noko nokolalo muwokokaimonoki, ya samukuko monoi. Noinoso yo mani, noko nokolalo na tomuwoko kainoninukuwo, moiyo samukuko monoi. ");
INSERT INTO amm_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ulai afonimaiso? Afonimaiso muwoi. Ya samukuyakinukuwomo, koloni no fasimonoinuwomo. Samukuko noko sisiyoli na soinuwomo. Moini nasu wosuwoimai soimo, Isolilo asi molo tiwoi asi noko, 12.” Isiso mo aino na ikoki, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Nosai no mo; Saimo Pitaso na imoki, Isisoyo mo, “Saimo, Saimo, na pukwaimono. Sokolo Nokota Waiyo uwokomo ki monoi tiyo. Nokoyo paluwa tuo aliyoli no tiyou salosalo no, fulomuyo kukumoso ufosifoliyafoumo monoi, noinoso na uwokomo ki monoi tiyo, Sokolo Nokota Waiyo. ");
INSERT INTO amm_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ulai yo mo Kotoso yapoli na imo ununoki, nonoso fasi monoi. Wonikaluso paikoso mulumolo luwaimonoiniso. Ulai ifou tumakinimo, mulumolo luwaimono noko nokolaloni mulu na pa amikomoi.” ");
INSERT INTO amm_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Nosai no mo; Pitayo na imoki, “Noko Siyoli, yo mo na topuwotolokai, nonoso aluwai monoi, kalopulo nuso. Kalakinimo, yo mani, kalomonoimo.” ");
INSERT INTO amm_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Isisoyo na imoki, “Pita, ya timonoki, konoi amolokimai kokalo imo yomu somisomai, taumai na yomumosoinimo, “Yo mo Isiso mo sai muwoi.” ");
INSERT INTO amm_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Nosai no mo; Isiso mo na ikoki, “Yani imo lukasikalo monoi toku no imo taikiyokinukuwo no, nomai no mo muwoni alo iwoi pa ilomanokinuwoso. Ilolu iwoi suwoi mani, pa ilomanokinuwoso. Nomai no no hani hani somiso no yapoli sikinuwo?” Na imokino, “Yoi, koi mo sofuwakomomokowoi muwoi, waliyo.” ");
INSERT INTO amm_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Na ikoki, Isiso mo, “Ulai lolai mo muwoni alo iwoi yapoli mo, na pa ilomanowo. Ilolu i mani, ainoso na pa ilomanowo. Noko mo muwo sopo uwofawo, to mo tani tunoyo na suo suomokumo, muwo sopo ano monoi mo. ");
INSERT INTO amm_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ulai afonimaiso? Kotoni puko imoyo ainonani monoi na tiyomuko, noino, “Imo kulali nokota komiyai kaluwaiyoinomo.” Aino tiyomuko, Kotoni puko imo mo. Ya na timonukuwo, nonani imoyo na fiyamosimomona tumumo. Nasu, Kotoni puko imoyo no tiyomuko unumono no, nonani imo mo motu na fiyamosiyoimo, aumoifaso.” ");
INSERT INTO amm_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Na imokino, “Siyoli Nokota, na pokoko. Koi mo muwo sopo sopo tiwoi yapoli niya tako.” Na ikoki, “No mo koma na.” ");
INSERT INTO amm_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nosai no mo; Isiso mo Yolusolimo nokonusai amufuki, Oli yuso amiyoki. No piyomosiki no, ainoso na. Siyokutono iyaliyo aluwaikino. ");
INSERT INTO amm_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Oli yuso yoki mo; na ikoki, “Kotowoi imo na polukaso siwo. Wonikaluso Sokolo Nokota Waiyo aiko ainikomo ifoluwaikoma tumoinuwo.” ");
INSERT INTO amm_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nosai no na utukaikoki, amunofamoki, alokomu na losiyaikoki, Kotoso na imoki, ");
INSERT INTO amm_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Apou, nono mo waliyo yomakinimo, tukolomono monoi na pa ufiyaiko. Ulai yani muluyoso muwoi, nani muluyosu nali no.” ");
INSERT INTO amm_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Nosai no mo; Kotoni kumoki nokotayo amukonoki, mulu na amima konoki. ");
INSERT INTO amm_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Wiyou, mulu siyoli na kalokaiki, no monoi no Kotowoi imo amiso na lukaso manoki. Koki mo nako komiyai na amukonoki, asiso, nakiyaiso. ");
INSERT INTO amm_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Imo lukaso uwai; nosai no mo; tolauki, siyokutono iyalini auso ifou manoki. Ulololi siso na koka tumoki. Mulu kolikalikaiki, no monoi no. ");
INSERT INTO amm_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Na ikoki, “Hani monoi ulololi tosinuwo. Na pauwonouluwo, Kotowoi imo na polukaso siwo. Wonikaluso Sokolo Nokota Waiyo aiko ainikomo ifoluwaikoma tumoinuwo.” ");
INSERT INTO amm_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nosai no mo; Isiso mo amai polukasiko toloki, noko molopoi mo na tiki. Noko molo tiwoi mulumai nokota, Yutaso no kaluwai manokino no, to mo toku na toloniyo tumoki. Isisoni auso aumoifaso tumoki, na asisi ifoluwaiki. ");
INSERT INTO amm_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ulai Isisoyo na imoki, “Yutaso, asi asi noko nokolaloni noko siyoli nokota yoso tasisi ifoluwaimona tumoni, uo nokoni auso kiyomono monoi no? Motu poimo. Na piyomu.” ");
INSERT INTO amm_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Nosai no mo; siyokutono iyali mo nonani haniyo uwoso kwaikino, iyamoki, “Uo nokoyo na tuwono.” Isisoso na imokino, “Siyoli Nokota, koi no muwo sopoyo tukuwoli no waliyo?” ");
INSERT INTO amm_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Imokino mo; toi nokotayo nokoni iyoso tokoso kukiyowaiki, totawoi lotu samukuko nokota siyolini mi ano nokotani iyoso. Nainasai iyo na. ");
INSERT INTO amm_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ulai Isiso mo fowakoki, “Tofolo.” Nainoyo akaikomoki, iyoso, na itouniyaimokaiki. ");
INSERT INTO amm_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Nosai no mo; Isiso mo tota kausi nokoso ikoki, lotu samukuko noko sisiyoliwoi lotu nu polimano noko sisiyoliwoi nokotalo iyaliwoi, toiso na ikoki, “Muwo sopo sopowoi awoi no hani monoi tololiyo tumo unumononuwo? Ulai uo nokota, yo no? Yo mo uo nokota muwoi, noko pa tukuwolimoiso. ");
INSERT INTO amm_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Amuwoisai amuwoisai yo mo lotu nu siyoliso piyousikaino fasi manokinukuwo, ulai pa komi kausimona tumokinuwoso. Ulai lolaimai folosu siyoliyo na tosouwaikomonuwo. Lolai mo tokomi kausimona tumonuwo.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Nosai no mo; na komikaikino, kominalomanokino. Totawoi lotu samukuko nokota siyolini nu mo kiya tumokino. Pitasu mo na aluwaiyaloki, namoli namoli nomasoso na aluwaiyaloki. ");
INSERT INTO amm_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Nosai no mo; nu asiyofoloso ta fu yoli siki. Pita mani, na sokuka tumoki. ");
INSERT INTO amm_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ulai mi ano nukonuyo Pitaso na kiki, tamai yousikainoso. Amiso na kwaiki, tamai si nokoso na ikoki, “Ninani nokota mo tolo tomasimo nokota na.” ");
INSERT INTO amm_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ulai Pita mo na fowasoki, “Woli, yo mo to monoi mo sai muwoi.” ");
INSERT INTO amm_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Namolisaifa noko siyayo na kiki, na imoki, “Nono mani, Isisoni siyokutono na.” Pitasu mo na imoki, “Yoi, yowoi muwoi.” ");
INSERT INTO amm_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Yousi manoki, yousi yousi, nosai no noko siyayo amiso na yomuki, “Motu nali no, noko to ni mo na tolo tomasimo. Koi mo sai, to mo Kalili asi nokota na.” ");
INSERT INTO amm_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ulai Pitayo na imoki, “Yoi, ulai yo no sai, nonani imo no tiyomuni no?” Aino yomumai lolai siyaso kokalo mo imo na yomuki. ");
INSERT INTO amm_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nosai no mo; Siyoli Nokotayo na alosiki, Pitaso na kwaiki. Nosai nosu Pita mo ti monoi na mulumolokoki, nonani imo Siyoli Nokotayo no imoki no, “Konoi amolokimai mo kokalo yomu somisomai, taumai na yomumosoinimo, “Yo mo Isiso mo sai muwoi.” ");
INSERT INTO amm_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Nosai no Pita mo lofuki, na soni yousa fuki, wiyou, na soni manoki. ");
INSERT INTO amm_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Nosai no mo; Isisoso no komikaikino no, nonani noko iyali mo alisiyolikino, na waso manokino. ");
INSERT INTO amm_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Tani molo ti mo tunoyo ufiyaikomokino, na imokino, “Noiyo wasoni? Na pa imoko. A, Kotoni amimai no nono no sai pakoso? Noiyo wasoni?” ");
INSERT INTO amm_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Imo kopokoiyau imo mo ainoso na imalokino. ");
INSERT INTO amm_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nosai no mo; somosaimai Isolilo nokotalo iyali mo ukouniyaikoki. Lotu samukuko noko sisiyoliwoi Musini imo sai sisiyoli nokowoi, toi mo ukouniyaikoki. Isiso mo polimano nokoyo kiyoka tumokino, toini auso. Na imokino, nokotalo iyali mo, ");
INSERT INTO amm_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“A, nono no Kolaiso na? A, Isolilo noko koi fasimoka tumo monoi na muwokaikini? Nonayo piyomu.” Na fowakoki, “Ya imakinukuwomo, waliyo pa mulumoloko unumonoinuwoso. ");
INSERT INTO amm_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Ulai ya imo siyaso utolumakinukuwomo, moi mo pakoso fowamonoinuwoso. ");
INSERT INTO amm_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ulai lolaisai ainoso amuwoi tinowoi asi asi noko nokolaloni noko siyoli nokota yo mo Kotoni nainasai na yousikainoimo, ami siyoli nokotani auso.” ");
INSERT INTO amm_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","No monoi no mo, noko komaso noko mo na imokino, “A, nono no Kotoni awitono?” Na fowakoki, “Moiyo ni tiyamonuwo no, ni mo asa na.” ");
INSERT INTO amm_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nosai no mo; totai amu na ikuwanokino, “Imo lukaso unu nokoni imo kwaiko tofolo. Tani koso yasoi kwaimokoni, imo topoko mo.” ");
INSERT INTO amm_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Nosai no mo; noko komaso noko mo sauki. Isiso mo kaukino, Pailatoni auso, komano nokota siyolini auso. ");
INSERT INTO amm_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Pailatoso faumiyanokino, na imokino, “Ninani nokota mo Yuto noko koiso na louwa tainikomomoko ifoluwaikomomokomoi. Sisiso takiso muwoni ni monoi mani, na talukikomomoko. Tota amu monoi tokaluwai, Kolaisowo. Tiyomu, “Kotoyo muwomonokaiki, noko nokolalo samukuko monoi.” ");
INSERT INTO amm_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Nosai no mo; Pailato mo Isisoso na utolumoki, “A, nono no Yuto noko nokolalo samukuko nokota siyoli na?” Na fowaki, “Wuo, no tiyomuni no, ainoso na motu.” ");
INSERT INTO amm_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Nosai no mo; Pailato mo lotu samukuko noko sisiyoliwoi noko nokolalowoiso na ikoki, “Ninani nokota mo hani mo yowoi muwoi. Asa no uo foli monoi no moloi yomu monoi?” ");
INSERT INTO amm_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ulai imo amiso na imalokino, “Noko nokolaloso imo koiyau na taiyolokalomoi. Wiyou, Yutiya noko komaso nokoyo taluwaiyalono. Kalili asisai ainoso tolomu asiwoi aiyoloka tumoki.” ");
INSERT INTO amm_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pailato mo nonani imo kwaikoki mo, na utolukoki, “A, to no Kalili nokota?” ");
INSERT INTO amm_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Fowakino, “Nasu, Kalili asi nokota na. No mo Hiloyo samuku asi.” No monoi no nokoso iko taikiyoki, “Isiso mo na pokauwo, Hiloni auso.” Hilo mani, Yolusolimo nokonu siyoliso awa tolokaina tumoki. ");
INSERT INTO amm_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Nosai no mo; Hilo mo Isisoso kiki mo, siyoliso na molokiki. Tokusai ki monoi louwa, no monoi no. Mulu ifolaluwawoi mi anoso kwai monoi yoki. Ulai afonimaiso? Imofa toku kolo koloma tumoki. ");
INSERT INTO amm_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","No monoi no Isiso mo tani auso tumoki mo, na utolumalo manoki. Ulai Isiso mo fowawoi muwoi, wosu woso toloki. ");
INSERT INTO amm_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Nokotalo iyali mani, aumoifaso siki, lotu samukuko noko sisiyoliwoi Musini imo sai sisiyoli nokowoi. Wiyou, na faumi unalokino. ");
INSERT INTO amm_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Nosai no mo; Hilowoi totani polimano nokowoi, toi mo imo koiyau imalokino, na alisiyolikino. Tuno sopo itouniyaimoyo na asisimokino. Ulai afonimaiso? Koiyaumokino, no monoi no. Nosai no Pailatoni auso ifou kaukino, polimano noko iyaliyo. ");
INSERT INTO amm_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Toku mo Hilowoi Pailatowoi mo wolimikuwanowoi muwoi, uowoi na. Ulai lolaimai mo waliyo na wolimikuwanokino. ");
INSERT INTO amm_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Nosai no mo; Pailato mo nokoso aliyonikoki, lotu samukuko noko sisiyoliwoi nokotalo iyaliwoi noko nokolalowoi aliyonikoki, tani auso ti monoi. ");
INSERT INTO amm_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Na ikoki, “Ninani nokota mo kawiyo tumomononuwo, faumimononuwo, noko nokolaloso ainiko ifoluwaikowo, komano nokoso namoliyo alosiko monoi. Momaini molo timai ya utolumalomoi. Woli iyali, na pukwaimonowo, ninani nokota mo hani mo yowoi muwoi. Hani monoi faumimono monoi? ");
INSERT INTO amm_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Hiloyo mani, tomoso tiyomu. Ifou na kiyomomoko. Na pukwaiwo. To mo hani mo yowoi muwoi. Moloi tukolo monoi, moi no? ");
INSERT INTO amm_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Wasosu mo waliyo, nosai no yo mo kiyo taikiyoimo.” Pailato mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pasowa popomai mo komano nokota siyoliyo kalopulo noko siyasonuso kolali uku taikiyomosumo. ");
INSERT INTO amm_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ulai noko nokolaloyo siyoliso na imokino, tomososo, “Ninani nokota mo na potukolo. Palopaso mo ifou na pokiyomomoko taikiyo, kalopulosai.” ");
INSERT INTO amm_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Palopaso mo komano nokowoi toku uo tukoluwanokino, nokonu siyolimai mo. Nokoso tukoloki, no monoi no kalopulo nuso kiyokaikino. ");
INSERT INTO amm_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ulai Pailato mo ti monoi na ikoki, Isisoso kiyo taikiyo monoi louwa. ");
INSERT INTO amm_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ulai siyoliso na iyamaloki, “A mokimai na pukou ukou nikomokaiwo.” ");
INSERT INTO amm_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ulai tau monoi na ikoki, “Ulai hani monoi, hani foli monoi woi? Hani mo yowoi muwoi. Ulai moloi tukolo monoi? Wasosu mo waliyo, nosai no yo mo kiyo taikiyoimo.” ");
INSERT INTO amm_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ulai siyoliso na imalo manokino, a mokimai ukou ukou nikomokai monoi. Wiyou, siyoliso iyamaloki, Pailatoni imoso souwaikino. ");
INSERT INTO amm_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","No monoi no Pailato mo toini imoso na aluwaikoki. ");
INSERT INTO amm_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Kalopulo nokota ifou kiyoko taikiyoki, noko no mo komano nokowoi toku no tukoluwanokino no, nokoso no tukoloki no. Nonani nokota mo ifou na kiyoko taikiyoki, kalopulo nusai, noko nokolaloyo no imo unukino no. Isisosu mo uo nokoni nainoso na kiyokoki, totaini muluyosu uwo monoi. ");
INSERT INTO amm_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Nosai no mo; Isiso mo kominalomanokino. Saimo, Sailini asi nokota, to mo nokonuso monoi louwa tumoki. Ulai polimano nokoyo komi kausikino. A moki sokuwokaikomokino, Isisoni namolisai sokunalomako monoi. ");
INSERT INTO amm_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Noko nokolalo molopoiyo aluwaikino. Nokolalo iyali mo sonukuyalokino, namolisai soniyoluwaiyalokino. ");
INSERT INTO amm_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Isisosu mo fokutonoyo alosikoki, na ikoki, “Yolusolimo nokolalo, moi mo noiyo sonukumonoiwo. Momai amu na posonukukuwanowo, momaini alalowoi monoi na posonukukowo. ");
INSERT INTO amm_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Pukwaiwo. Amuwoi tino mo nokoyo iyamoimo, “Anapo nokolalo moi mo na pa molokiwo. Alalo koko somiso nokolalo moi mo na pa molokiwo. Nano niko somiso nokolalo moi mani, na pa molokiwo.” ");
INSERT INTO amm_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Nomai no mo, “Yuso ikoinomo, “Yu, koi pukuwoli fiyaimokowo.” Yu lolofaso mani, na ikoinomo, “Na pofiyokai komomokowo.” ");
INSERT INTO amm_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ulai afonimaiso? Asa komiyai uwokomoinuwomo. Yo mo a suwowoi a komiyai ni totolo, ulai na tuwokaimonono. Moi mo a samo samo komiyai, wiyouwa wiyou, na uwokomoinuwomo.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Molo koiyauso aluwai nokota tiwoi mani, na koliyo tumokino, Isisowoi tukuwoli tomasi monoi. ");
INSERT INTO amm_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Yu asi mo komama tumokino, Komu Foli Yu no pokaluwai manokino no. Nosoni a mokimai na ukou ukou nikomokino. Molo koiyauso aluwai nokota ti, toti mani, Isisoni kwasai ukou ukou nikokaikino, a moki tiwoimai. Siya mo nainasai, siya mo sokonisai. ");
INSERT INTO amm_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nosai no mo Isiso mo Kotoso na imoki, “Apou, yo foli imo na potokosokiko. Toi mo sai muwoi, ni tiyono mo.” Ulai polimano nokoyo tani tuno totai amu wau monoi tomoki lolofayo na somaimo ukukino. ");
INSERT INTO amm_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Noko nokolaloyo Isisoso kwai si liyaiki. Noko sisiyolisu mo alisiyolikino, iyamoki, “Noko nokolalososo pofasiko manoki, tota amusu na fasiyumo. Tota amu monoi tiyomu, Kolaisowo, Kotoyo muwokai nokotawo, Isolilo noko moi fasimoka tumo monoi. Motu mo, tota amu na fasiyumo.” ");
INSERT INTO amm_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Polimano noko iyali mani, na alisiyoli manokino. Aumoifaso tiki, molo wamo ito iwo koiyau woliyononi monoi louwa. ");
INSERT INTO amm_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Na imokino, “Nono mo Yuto noko nokolalo samukuko nokota siyoli mo, nona amu na pofasi.” ");
INSERT INTO amm_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","A moki puwosai mo noino na kumokaikino, “Ni mo Yuto noko nokolalo samukuko nokota siyoli.” ");
INSERT INTO amm_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Molo koiyauso aluwai nokota ti no you akaikokaikino no, ulai siyayo Isisoso na alisiyoliki, imoki, “Nono mo Kotoyo muwokai nokota Kolaiso mo, nona amu na pofasi. Koti mani, na pofasimoko.” ");
INSERT INTO amm_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Molo koiyauso aluwai nokota siyasu mo siyokutonoso na ikimoki, “Nonoso mani, tuwokaini. Ulai hani monoi pa tauwosiwainiso, Kotoso no? ");
INSERT INTO amm_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Motini molo koiyau foli monoi na tuwokaimokokaino. No mo waliyo. Mulumai nokota nisu, to mo hani mo yowoi muwoi.” ");
INSERT INTO amm_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nosai no mo na imoki, “Isiso, nonani asiso amiyakinimo, yowoi pa mulumoloko unumono.” ");
INSERT INTO amm_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Isiso mo na imoki, “Yo mo motuwa na timonoki, konoi mo yowoi asi itouniyaimoso na yousi itouniyaimoinimo, kumokiso.” ");
INSERT INTO amm_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Ulo yakomai, ulo mo na lotiki, asi asi komaso mo na folosumono kolokaloki. Ainoso hani upimo tanoki. Nosai no ifou wi taikiyoki. ");
INSERT INTO amm_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ulo wi somisomai nomai no mo, tuno siyoli lotu nu siyoli kokiko poiso no kitafoli kukiyokaikino no, nonani tuno na poliyaliyaiko taikiyoki. ");
INSERT INTO amm_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nosai no mo; Isiso mo siyoliso na imoki, “Apou, yani mulu mo nani nainoso na tanoninoki.” Aino imoki mo, yau na kaloki. ");
INSERT INTO amm_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Polimano samukuko nokota siyoli mo Isiso kaloso kwai tolo manoki mo, Kotoni siyolo kaluwaiyaloki, na yomuki, “Motu nali, molo itouniyaimoso aluwai nokota na.” ");
INSERT INTO amm_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ukouniyaikokaiya tumo noko nokolalo mani, nonani haniso kwaikino mo, mulu kolikalikaiki, fokutonoso wasoulikino, nuso ifou nuki. ");
INSERT INTO amm_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Siyokutono iyali mo aluwasai siki, siyokutono iyali komasowoi Kalili nokolalowoi no aluwainiyo tumokino no. Aluwasai siki, nonani hani komasoso kwai si manoki. ");
INSERT INTO amm_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Alimatiyo asi nokota, Yusifo, to mo nosoni tolokainoki. Yuto nokota siyoli na, nokotalo iyaliwoi pukouniyaiko mosikino. Noko itouniyaimo, molo koiyauso pa aluwai manokiso. ");
INSERT INTO amm_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Nokotalo iyaliyo Isiso tukolo imo lukasokaikino mo, Yusifo mo waliyo imo pa yomukiso. Kotoyo asi asi komaso samukuko monoi pofou manoki. ");
INSERT INTO amm_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Nonani nokota mo Pailatoso na imanoki, “Yo no Isiso yau no waliyo totokomonano, ai unano monoi?” Fowaki, “Waliyo na.” ");
INSERT INTO amm_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","No monoi no Isiso yau na kominiyo konoki, kamoso tunoyo na yalokonoki. Noko yau yau asi iso na akaiyanoki, toku yasoi no aikaikino no. Toku mo noko yau akaiwoi muwoi, tonofalo nali. ");
INSERT INTO amm_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Isiso kalomai mo mi fou fouko koloni foukai ulo na, mi mo aumoifaso fou fouko na. ");
INSERT INTO amm_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Kalili nokolalo Isisoso no aluwainiyo tumokino no, toi mo Yusifoso aluwaikino, Isiso yau akai monoi asi iso kwaiyanokino. ");
INSERT INTO amm_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kwaiyano uwai; nuso ifou nuki. Aliyoliwoi kou woti iwowoi na foukaikino. Ulai mi fou fouko ulo monoi sinonoki, Musini aniyopa imoyo no tiyomuko no. ");
INSERT INTO amm_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Amuwoisai, somosaiyamai nokolalo iyali mo ai unu asi iso monoi na nuki. Aliyoli ilomanokino, Isiso yau louwoyano monoi louwa, toku yasoi no foukaikino no. ");
INSERT INTO amm_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ulai ai unu i ufiyaimo tomoki lolomotaikaiso na kiya tumokino, pokomosikaiso. ");
INSERT INTO amm_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","No tiki mo, ulai Isiso Siyoli yau mo pa kikinoso, uwofa na kikino. ");
INSERT INTO amm_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ainonani monoi mulumoloko manokino mo, lolai siyaso noko ti aumoifaso tola tumoso na kokokino. Totini tuno mo uloni fupiniyaimo topi, kamoso na. ");
INSERT INTO amm_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Wiyou, na kokolokoki, komu kuloliyo konokino, asiso foinalikokino. Ulai noko tiyo na ikokino, “Hani monoi amai tolo nokota tikoliya tumonuwo, noko aiko uku asiso no? ");
INSERT INTO amm_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Yau amai pa toiso. Yasoi na auwoniyou. Na pomulumolokowo, toku imo totayo no imokinuwo no, Kalili asimai. ");
INSERT INTO amm_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Noinoso imokinuwo, “Asa, asi asi noko nokolaloni noko siyoli nokota yo mo molo koiyauso aluwai nokoni nainomai kiyomonoinomo. A mokimai na ukou ukou nikomomonoinomo. Amoloki tiwoi mo uwai; ulai ifou na auwoniyouwoimo.” ");
INSERT INTO amm_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ikokino mo; nokolalo mo mulumolokokaikino. Toi mo sai, Isisoyo toku no ikoki no. ");
INSERT INTO amm_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Ai unu asisai utukaimokino, ifou nuki. Siyokutono iyaliso ikanokino, noko molo siya 11 nokowoi, noko siyaiwoiso. Komaso hani no kokokino no, nonani monoi na ikanokino. ");
INSERT INTO amm_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Nonani nokolalo iyali mo Moili, Makotalo nukonu, Yowanawoi Moili siyawoi, Yamisoni atino, nokolalo siyaiwoi, toisu mo nonani imo ikokino, Kotoni imo lukasikalomano noko iyaliso. ");
INSERT INTO amm_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ulai waliyo mulumoloko ukuwoi muwoi, piyamoki, topoko imowo. ");
INSERT INTO amm_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ulai Pitasu mo tolauki, na fumanoki, ai unu asiso. Komama tumoki mo, na ukuwoli tanoki, na tu luluwoluwaiki, asi i poiso. Wiyou, yalokono tuno saso na tu kokoki. Ulai nuso ifou manoki, nonani monoi mulumolokalo manoki. ");
INSERT INTO amm_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Isiso auwoniyou ulomai mo toi nokota ti mo manalokino, Imiyaso nokonufa monoiso. Aluwamaifa manalokino, Yolusolimo nokonu siyolisai. ");
INSERT INTO amm_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","No manokino mo, imo lukasikuwanokino, no fiyamosiki no. ");
INSERT INTO amm_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Totati amu imo lukasikuwanokino mo, ulai Isiso totasu mo namolisai utolikai kiyo tumoki, na lotiyonoka tumoki, nosai no mo tomoso na nuki. ");
INSERT INTO amm_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ulai totisu mo sai muwoi, piyomukino, noko siyawo. ");
INSERT INTO amm_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Nosai no mo; na ikoki, Isiso mo, “Ni totumonuwo no, moti no hani imo tolukasalo tumonuwo?” Ikoki mo; toti mo ututomokika tumoki, mulu kolikalikaiki, amuwaso tolokino. ");
INSERT INTO amm_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Toti nokota, tani siyolo mo Koliyopa, ta fowaki, “Ulai nono no sai pakoso, Yolusolimo nokonumai no fiyamosi no? Tolomu noko komaso mo sai.” ");
INSERT INTO amm_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Isisosu mo ikoki, “Haninoiyo fiyamosi?” Nosai no mo; toti mo na fowakino, “Isiso, Nasolito nokota monoi. Wiyou, to mo Kotoni mulu lukasiko nokota na. Kotoni molo timai mo mi ami na pano manoki. Tani imo mani, noko nokolaloni molo timai mo amiwoi na. ");
INSERT INTO amm_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Komano nokotani nainoso kiyokino, momaini lotu samukuko noko sisiyoliwoi nokotalo iyaliwoiyo. Nosai no komano nokota siyoliyo tukolo monoi imo yomukaiki, ukou ukou nikomokaikino, a mokimai, yau. ");
INSERT INTO amm_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Toku koi mo mulumoloko unukinoki, Isolilo noko moi kolisomoka tumo monoiwo. Ulai tino na tukolokino, yau. ");
INSERT INTO amm_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Nosai no mo; lolai mo koi mo kufaukomomoko. Ulai afonimaiso? Lolai somosaimai koini nokolalo iyali mo ai unuso na kiyanono, ");
INSERT INTO amm_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ulai Isiso yau mo kiwoi muwoi, uwofa. Ifou na ti, na imoka tumono, “Kumoki nokoso na kokonoki. Toiyo imokono, “Ifou yasoi na auwoniyou, yausai.” ");
INSERT INTO amm_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Nosai no koi mulumai noko siyai mani, nosoni nu, ai unuso. Nokolaloyo no imoka tumo no, noinoso na kinoki. Isisosu mo kiwoi muwoi, uwofa na.” ");
INSERT INTO amm_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Nosai no mo; totiso na ikoki, “Moti no ulai muluwoi? Mulu somiso nali. Kotoni mulu lukasiko nokoyo no piyamalo manoki no, hani monoi pa tomulumoloko ukunuwoso. ");
INSERT INTO amm_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Moloi woi? Ulai moti no sai pakoso? Kotoyo muwokai nokota Kolaiso mo iyanoko toku uwo na, nosai no Kotoni saponimai yousa yoimo.” Aino ikoki. ");
INSERT INTO amm_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nosai no mo Musini imoso toku wiyotiyaloki, ainoso hani Kotoni mulu lukasiko nokoni imoso wiyolukalo mo uwai. Kotoni puko imo komaso mo afonimaiso wiyolukalowoi muwoi, tota amu monoi no tiyomukalo no, nonani imoso na wiyolukaloki. ");
INSERT INTO amm_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Imo lukasiko manoki mo, aumoifaso na potanoki, nonani nokonu mo no manokino no. Isisosu mo louwa souwaiki. ");
INSERT INTO amm_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ulai toti mo na imalokino, “Noiyo manoi, kotiwoi na potanimoko. Ulo mo na tamukono. Folosu mo aumoifaso.” No monoi no nuso na lotiki, taniko monoi. ");
INSERT INTO amm_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Nosai no mo; no nikino mo, Isiso mo tuo na anoki, Kotoso na imoki, “Wafisu.” Na foloulu nikoki. ");
INSERT INTO amm_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Foloulu nikoki mo, na sainokino, Isiso monoi na. Ulai lolai siyaso uwofa na kikino. ");
INSERT INTO amm_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Totati amu na lukasikuwanokino, “Molomai imo lukaso nimokalomai, wiyou, moti mo mulu mo na auwonoulu, Kotoni puko imo folosai wiyomokalomai mo. Na piyomu, motu na.” ");
INSERT INTO amm_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Nosai no mo; somaiso auwoniyoukino, yasoi, Yolusolimo nokonu siyoliso monoi. Isisoni siyokutono iyaliso mo koka tumokino, noko molo siya, 11, nokowoi, noko siyaiwoi, ukouniyaiko siso. ");
INSERT INTO amm_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Totiso na ikokino, “Motu nali, Noko Siyoli mo yausai na auwoniyou. Saimoyo yasoi na ki.” ");
INSERT INTO amm_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nosai no toti mani, na lukaso wiyotikino, molomai no fiyamosoka tumoki no. Na ikokino, “Tuo foloulu nimokomai na sainonoki, Isiso totasu na.” ");
INSERT INTO amm_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Siyokutono iyali nonani imoso lukaso siki mo, Isiso totasu mo toini mulumaiso lolai siyaso na fiyamosiki. Na ikoki, “Mulu tomokiso na posiwo.” ");
INSERT INTO amm_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ulai umanokoki, na kokolokoki, piyamoki, “Popuwaso tokinokiwo.” ");
INSERT INTO amm_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ulai na ikoki, “Moi no hani monoi tumanokomonuwo? Mulu tiwoi no hani monoi tomulumolokonuwo? ");
INSERT INTO amm_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Yani nainowoi fonawoi na pokokomomonowo, simosiyo no ukou ukou nikomomonokino no. Asa mo niya tolo. Nainoyo na pokomimonowo. Na posainowo, yo mo popuwa muwoi, auwoi somuwoi mo yapoli, noka noko nali.” ");
INSERT INTO amm_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Aino no ikoki mo, nainowoi fonawoi na wiyolukoki. ");
INSERT INTO amm_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Wiyou, na molokikino, ulai mulumolo luwaiwoi muwoi, na mulumoloko manokino. Mulumoloko manokino mo, na ikoki, “Moi no koloni no yapoli si?” ");
INSERT INTO amm_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Yapoli na, la somu asononikino. ");
INSERT INTO amm_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Asoki mo; na nosoki, koso. Toini molo timai mo na nosoki. ");
INSERT INTO amm_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nosai no mo; na ikoki, Isiso mo, “Moiwoi tolo tomasikomomai ya imokinukuwo, noino, “Yo monoi no kulukaiyalokino no, Musini ami imowoi Kotoni mulu lukasiko nokoyo kulukaiwoi Kotoni siyolo kaluwai si pukowoi, nonani imo komaso mo motu na tumumo.” ");
INSERT INTO amm_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Aino na ikoki. Nosai no tani amiyo fasikoki, Kotoni puko imo saino monoi. ");
INSERT INTO amm_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Na ikoki, “Kotoni puko imoyo noino na tiyomukokai, “Kotoyo muwokai nokota Kolaiso mo iyanoko na anoimo. Amoloki tiwoi mo uwai; yausai na auwoniyouwoimo. ");
INSERT INTO amm_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Tani amimai nokoyo Kotoni imo posasoko wiyotiyaloinomo, asi asi noko nokolalo komasoso. Mulu alosoko imo na. Mulu alosokakinomo, Koto mo molo koiyau monoi imo mo futo.” Nonani imo mo Yolusolimo nokonu siyolisai maliyali liyaiyoimo. ");
INSERT INTO amm_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Momaiyosu na pa posasokalo manowo, ninani asiso ni fiyamosiki no. ");
INSERT INTO amm_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Na pukwaiwo. Apouyo toku no yomukaiki no, kiyokomononi monoi, no mo ya na kiyokomononi taikiyoikuwomo. Moisu mo ninani nokonumaiso na pa foumo si manowo, ainoso hani Kotoni ami na tumoimo.” Isiso mo aino na ikoki, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Nosai no mo; Isiso mo siyokutono iyali mo Pitano nokonuso na kiyokanoki. Nainoyo na akiyouki, na ikoki, “Kotoyo na tofasinuwo.” ");
INSERT INTO amm_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ikomai mo na utukaikoki, Kotoyo na kawiyo yoki, kumokiso. ");
INSERT INTO amm_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nosai no mo; molokimokino, Yolusolimo nokonu siyoliso ifou nuki. Na molokiyalokino. ");
INSERT INTO amm_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Lotu nu siyoliso posi manoki. Kotoni siyolo na pokaluwai manokino. ");
INSERT INTO amm_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Tokuwa toku hani hani mo auwonouluwoi muwoi, noko mo na tolokainoki. Imo kaluwaiki, tani siyolo mo. Kotoni auso tolokainoki. Koto mo tomoso, to mo. ");
INSERT INTO amm_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Tokuwa toku tani auso na potoloki, Imo mo. ");
INSERT INTO amm_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Noko no mo, tani siyolo mo Imo, nonani nokota mo Kotoyo noinomo hani hani komaso na mulumolokoki, na auwonouluki. Ainoso nali no auwonouluki. Ta mulumoloko somiso mo, pa pauwonouluso. ");
INSERT INTO amm_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","To mo itouniyaimoso si kiyo nokota. Totayo noinomo saponi komiyai towimoi, noko nokolaloni molo timai. Moiyo Koto saino monoi towimoi. ");
INSERT INTO amm_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Nonani saponiyo mo folosumonoso na towi kolomoi. Folosuyo saponi mo pa tosouwaiso. Saponi mo na towimoi. ");
INSERT INTO amm_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Nosai no mo; nokoso imo taikiyoki, Kotoyo. Tani siyolo mo Iyono. Na imo taikiyoki, ");
INSERT INTO amm_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","“Yani saponi monoi na poposasokano.” Nonani saponi monoi posasoko wiyotiya tumoki, noko nokolaloyo saino monoi. Imoso mulumolo luwai monoi na ika tumoki, noko komaso nokoyo mulumolo luwai monoi. ");
INSERT INTO amm_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Tota amu mo saponi komiyai pa wikiso. Saponi monoisu na posasoka tumoki. ");
INSERT INTO amm_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Nonani saponi mo saponiya saponi. Asi asi noko nokolalo moini auso na auwoniyouwaloki, na towiyalo, moini molo timai. Moiyo Koto saino monoi towiyalo. ");
INSERT INTO amm_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Noko no mo, tani siyolo mo Imo, to mo asiso na tolokaina konoki. Kotoyo noinomo hani hani komaso mo toku yasoi mulumolokoki, no monoi no auwonouluki. Ulai tumomai asi asi noko nokolaloyo to monoi mo sai muwoi. ");
INSERT INTO amm_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Totani asiso tumoki, ulai totani asi noko nokolaloyo wiyou iyamoki. ");
INSERT INTO amm_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Noko siyaisu mo waliyo na iyamoki, na mulumolo luwaikino. No monoi no na ikokaiki, “Kotoni alalo na pa siwo.” ");
INSERT INTO amm_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Kotoni alalo nali no, totani muluyosu. Atino iyaliyo kokolo monoi muwoi, apitono iyalini alisai monoi muwoi. Nokoni muluyo muwoi, Kotoni muluyosu totani alalo nali no. ");
INSERT INTO amm_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Noko no mo, to monoi kaluwaiki, Imo, to mo noka noko na wiyonoki, koini auso tolokaina konoki. Tani ami siyoliso yasoi kikinoki. Wiyou, ami siyoliwoi tolokainoki, Apitono Siyolini muluyosu. Awitona awitono siyasu, no monoi no. Nonani nokota mo noko fasiko mulu mo siyoli, wiyou. Suomoso monoiso tofasimokomoi. Wiyou, to mo Kota Koto na wiyomokoki. ");
INSERT INTO amm_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Iyono mo posasokoki, siyoliso piyomumosiki, “Ni mo noko, yo toku no yomu unuki no, noino, “Noko mo namolisai tumoimo, asa monoi, ulai na tosouwaimono. Noko siyoli, wiyou. Toku ino yani anoiyo kimonowoi muwoi, nonani nokota mo you tolokainoki, no monoi no tosouwaimono.” ");
INSERT INTO amm_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Noko fasiko mulu mo siyoli, wiyou, no monoi no fasimoko manoki fasimoko manoki fasimoko manoki. Suomoso monoiso na tofasimokomoi. ");
INSERT INTO amm_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Kotoyo noinomo Musiyo imo ami posasoko wiyotiki, aniyopa noko nokolaloso. Toi aluwai monoi posasoko wiyotiki. Ulai moloi aluwai monoi? Ulai noko no kaluwaiki no Imo, Isiso Kolaiso nali, to mo suomoso monoiso na fasimoka konoki. Kota Koto na wiyomoka konoki. ");
INSERT INTO amm_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Noko siyayo Kotosu mo kiwoi muwoi. Koto tomoso nokota, awitona awitono saso, to mo Kotoso na tokimoi. Apitono Siyolini nainomai yousikaino nokota, totasu mo Apitono na wiyomokoki, Koto nali. ");
INSERT INTO amm_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Yuto noko sisiyoli, Yolusolimo nokonu siyoliso no siki no, toiyo nokoso iko taikiyokino, “Iyononi auso na ponuwo.” Lotu samukuko nokowoi Liwaini alisaitono nokowoi, toiso iko taikiyokino, “Iyononi auso na ponuwo.” Na iyamo taikiyoki, “Nono no noi? A, Kotoyo muwokini?” Nosai no mo; Iyono mo amiso na yomuki. ");
INSERT INTO amm_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Imo kukalokowoi muwoi, toini molo timai na fowakoki, “Yo mo Kolaiso muwoi. Kotoyo no muwokaiki no, Isolilo noko moi fasimoka tumo monoi, no mo yo muwoi.” ");
INSERT INTO amm_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ulai imokino, “Moloi woi, nono no noi? A, Ilaiya, Kotoni mulu lukasiko nokota, nono no? Nonani aniyopa nokota poimo, nono mo.” Fowakoki, “Yoi, yo mo Ilaiya muwoi.” “A, Kotoni mulu lukasiko nokota siyoli siya, nono no? Koi no tofoumonoki no, nonani nokota poimo.” “Yoi, yo mo nonani nokota muwoi.” ");
INSERT INTO amm_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nosai no mo imokino, “Na pimoko, nono no noi? Imoko taikiyo nokoso moloi ikoikimo, koi no? Nona amu monoi na pimoko, hani mi poi tanoni.” ");
INSERT INTO amm_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Iyono mo na fowakoki, “Aisaiyayo asa monoi toku kumo unumonoki, “Nokoyo imo siyoliso yomoimo, nu somiso asimai. Na iko toloimo, “Molo koiyauso na putukaimowo. Molo itouniyaimoso na pa aluwaiwo. Noko Siyoli mo tumoimo.” Aisaiyayo aino kumo unumonoki.” Iyonoyo mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Nosai no mo; nokoyo no iko taikiyokino no, siyai mo Falisi moloso aluwai noko, ");
INSERT INTO amm_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","toi mani, Iyonoso na imokino, “Nono mo Kolaiso muwoi, Ilaiya muwoi. Kotoni mulu lukasiko nokota siyoli siya muwoi. Ulai moloi monoi iwoso tuluwako manoni, noko muwokokai monoi?” ");
INSERT INTO amm_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Fowakoki, Iyono mo, “Nasu, iwoso tuluwakomosi, yo mo. Ulai moini mulumai mo noko siya mo na totolokaino. Moi mo sai muwoi, to monoi mo. ");
INSERT INTO amm_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","To mo noko siyoli, ulai namolisai tumoimo, asa monoi. Noko siyoli, wiyou. Yo no moloi fasi monoi?” ");
INSERT INTO amm_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Iyono mo aino ikoki, Pitano nokonuso, Yotano iwo ausaimiso. Noko nokolaloso puluwako tolo manoki, nomai no. ");
INSERT INTO amm_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nosai no mo; amuwoisai Iyono mo Isiso tumoso kwaiki mo, noko nokolaloso na ikoki, “Oi, noko tumoso na pukwaiwo. To mo Kotoni sipo uo komiyai tukoloinomo. No monoi no Koto mo imo mo futo, asi asi noko nokolaloni molo koiyau monoi imo mo. ");
INSERT INTO amm_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ni mo noko, yo toku no yomu unuki no, noino, “Noko mo namolisai tumoimo, asa monoi, ulai na tosouwaimono. Noko siyoli wiyou. Toku ino yani anoiyo kimonowoi muwoi, nonani nokota mo you tolokainoki, no monoi no tosouwaimono.” ");
INSERT INTO amm_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Toku asa mani, sai muwoi, noko to ni mo. Ulai moiyo to monoi saino monoi iwoso na uluwakoma tumokinukuwo, Isolilo noko nokolalo moiyo saino monoi na.” ");
INSERT INTO amm_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Nosai no mo; ulai ikoki, Iyono mo. Na posasokoki, noino, “Kotoni Mulu Itouniyaimo Nokotayo kumokisai amukonoso kwaiki, yo mo. Anomu topi amukonoki, ninani nokotani auso tolokaina konoki. ");
INSERT INTO amm_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Imono taikiyo nokotayo toku yasoi imono somiso mo, yo mo to monoi mo pa posainoso. Iwoso uluwako monoi imono taikiyoki mo, na imonoki, noino, “Yani Mulu Itouniyaimo Nokotayo amukonoso kwaiyoinimo, nokoni aumai tolokaina konoso. Nonani nokotayo mo asani Mulu Itouniyaimo Nokotaso na imo taikiyoimo, noko nokolaloni mulu poiso. No monoi nosu muwokokaimonoimo.” Imono taikiyo nokotayo aino toku yasoi na imonoki. ");
INSERT INTO amm_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Motu na fiyamosiki, yo mo yasoi na kiki, no monoi no imo amiso na timonukuwo, noko ni totumo no, to mo Kotoni awitono nali.” Aino na ikoki, Iyono mo. ");
INSERT INTO amm_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Nosai no mo; amuwoisai Iyono mo nosoni ulai potoloki. Siyokutono noko tiwoi tolo tomasimokino. ");
INSERT INTO amm_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Nosai no mo; Isiso souwaikoso kwaiki mo, siyokutono noko tiso na ikoki, “Oi, souwaimoko nokotaso na pukwaiwo. To mo Kotoni sipo uo komiyai tukoloinomo.” ");
INSERT INTO amm_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Noko tiyo nonani imo kwaikino mo, Isisoso na aluwaikino. ");
INSERT INTO amm_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Aluwai manokino mo, Isiso mo namoli molo kwaikoki, na ikoki, “Hani monoi tiyonuwo?” Fowakino, “Lapi.” Nonani imo folosai mo aiyolokomomoko nokota. Imokino, “Lapi, moiso totanomosini?” ");
INSERT INTO amm_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ikoki, “Kukuwo, na paluwaimonowo, na pokiya tumowo.” No monoi no aluwaikino, ulololi tanomosiso kiyanokino. Upimomai aluwainiyonokino. Tani auso yousikainokino, ainoso hani folosu. ");
INSERT INTO amm_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Nonani nokota ti Iyononi imo no kwaikino no, Isisoso no aluwaikino no, toti mo Saimo Pitani auwatono Anotoluwoi noko siyawoi. ");
INSERT INTO amm_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Isisoso utukaimokino mo; Anotolu mo auwatono Saimoso somaiso kiyanoki, na imoki, “Koti mo Kotoyo muwokaimoko nokota yasoi na kinoki, Isolilo noko moi fasimoko nokota mo.” No mo Koliko nokoyo Kolaiso tokaluwai manono. ");
INSERT INTO amm_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Nosai no mo yasoi; Saimo na kawiyo tumoki, Isisoni au mo. Isiso mo Saimoso kiki, na imoki, “Nono mo Saimo, Iyononi awitono. Ulai Sifaso, siyolo siyasai na kaluwaiyoinomo.” Sifaso mo Koliko imosai mo Pita. Pita imo folosai mo tomoki. ");
INSERT INTO amm_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Nosai no mo; amuwoisai Isiso mo yomukaiki, “Yo mo Kalili asiso tomoi.” Yomukaiki mo; na manoki. Manoki mo, nokoso kiya tumoki, tani siyolo mo Filipo. Na imoki, “Na paluwaimono.” ");
INSERT INTO amm_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipo mo Pisaito nokota. Anotolu noko ti Pitawoi, toti mani, Pisaito nokota ti. ");
INSERT INTO amm_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Nosai no mo; Filipo mo noko siyaso kiya tumoki. Tani siyolo mo Nataniyalo. Nataniyaloso kiya tumoki, na imoki, “Noko Musiyo no kulu unuki no, Kotoni ami imo pukoso, nonani nokotaso yasoi na kinoki. Kotoni mulu lukasiko noko iyali mani, kulu unukino. To mo Isiso, Nasolito nokota, Yusifoni awitono.” ");
INSERT INTO amm_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Ulai Nataniyaloyo imoki, “Moloi su? A, Nasolito nokota no? Mi itouniyaimo no moloi ano monoi, Nasolito nokota no?” Fowaki, Filipoyo mo, “Na pokiya tumo.” ");
INSERT INTO amm_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Nosai no mo; Isiso mo nonani noko tiso aluwamai kokoki, Nataniyalo monoi yomu unuki, “Noko nanu mo Isolilo nokota itouniyaimo nali. Ifoluwai muluwoi muwoi.” ");
INSERT INTO amm_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ulai Nataniyaloyo imoki, “A, yo monoi no moloi tosainoni?” Fowaki, “Filipoyo nono kausi somisomai aluwamai yousiso ya kwainoki, sipoki a folomai yousiso.” ");
INSERT INTO amm_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Na imoki, Nataniyaloyo mo, “Aiyolokomomoko nokota, nono mo Kotoni awitono nali. Isolilo noko koi samukumoko nokota siyoli, nono mo.” ");
INSERT INTO amm_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ulai Isisoyo mo imoki, “Ya timonoki, sipoki a folomai kinoki mo, no monoi no tomulumolo luwaimononi. Moloi monoi woi? No mo koufa hanisu, siyoli haniso mo amai kiyoinimo.” ");
INSERT INTO amm_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ulai ikoki, “Motuwa na timonukuwo. Kumoki itu loti kolalikaiso kiyoinuwomo. Yoso mani, kimonoinuwomo, kolaliyai sopo komiyai, yo asi asi noko nokolaloni noko siyoli nokota. Kotoni kumoki nokoyo ifou kuno ifou yo liyaiso kwaikoinuwomo.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Tinosai nokoyo noni kausoki, Kano nokonuso, Kalili asimai. Isisoni atino mo koloni wasiya tumoki. ");
INSERT INTO amm_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Isiso iyali mani, koloni wasiya tumokino. Noni kauso nokotayo toku utolukokaiki. No monoi no koloni wasiya tumokino. ");
INSERT INTO amm_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Molo wamo ito iwo sikokino, noko nokolaloyo. Molo wamo ito iwo mo uwai; Isisoni atino mo awitonoso imoki, “Molo wamo ito iwo mo uwai.” ");
INSERT INTO amm_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Fowasoki, “Anoi, no mo asani hani muwoi. Yani mi ano ulo mo amai toi.” ");
INSERT INTO amm_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ulai mi ano noko iyaliso na ikoki, atinoyo mo, “Imakinuwomo, na pa kwaimowo.” ");
INSERT INTO amm_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Yuto noko iyaliyo tokumi moloso aluwai manokino, naino fona puluwakomosikino, Kotoni molo timai, piyamoki, Koto mo imo mo futowo. No monoi no tomoki nau sisiyoli nosoni siki, naino fona uluwako monoi, tomoki nau toufowoi. Nonani nau mo lolofa muwoi, sisiyoli nali. Nokoyo tomoki nau siyasonuso poso siyoliyo koso solinoloko mo, wiyou, poso sisiyoli mo naino ti, 10, nali. ");
INSERT INTO amm_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Nosai no mo; Isiso mo mi ano noko iyaliso na ikoki, “Iwa iwo na posolinolokowo, nauso.” Ikoki mo; iwa iwo na solinolokokino, ko sisiyoli. ");
INSERT INTO amm_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Solinolokokino mo; nosai no Isiso mo ikoki, “Iwo puwoliyonina tiwo, no samukuko nokota siyoliso.” Yokino mo, ");
INSERT INTO amm_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ulai iwa iwo mo molo wamo ito iwo na wiyonoki. No samukuko nokota siyoli mo iwo siko kiki mo, na mulumolokaloki, “Moisai poi tuwoliyomona tino?” Woliyononi noko iyali saso mo sai. Noni kauso nokotaso imanoki, ");
INSERT INTO amm_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","na imoki, “Oi, ni mo molo wamo ito iwo itouniyaimo nali. Moiso poi anukokaini? Moloi si? Molo wamo ito iwo itouniyaimo mo toku tuwololuka timosi, nokoyo. Noko nokolaloyo siyoliso siko uwai; nosai no mo usutono somiso iwo tuwololuka timosi. Nonosu mo aino yowoi muwoi. Molo wamo ito iwo itouniyaimo mo anukokaini, lolaisu na tuwololuka tini.” No samukuko nokotayo aino na imoki, noni kauso nokotaso. ");
INSERT INTO amm_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Isiso mo nonani mulu ifolaluwawoi mi anoki, Kano nokonuso, Kalili asiso, totawoi mulu ifolaluwawoi mi nali no. Noko nokolaloni molo timai anoki mo, no monoi no wiyotiki, ami siyoli mo. Siyokutono iyali mani, na mulumolo luwaikino. ");
INSERT INTO amm_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Nosai no mo; Isiso iyali mo Kopanaumo nokonuso kunoki, atinowoi auwatono iyaliwoi siyokutono iyaliwoi. Amoloki tiwoi tauwoi na sa konoki. ");
INSERT INTO amm_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Nosai no mo; Pasowa koloni wasi popo mo aumoifaso potanoki, Yuto noko nokolaloni mi fou fouko popo siyoli mo. Nomai no mo Isiso mo Yolusolimo nokonu siyoliso amiyoki. ");
INSERT INTO amm_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Amiyoki mo; lotu nu siyoliso lotiki, na kokaloki. Lotu nu siyolimai mo hani hani suo suomoko nokoso na kokaloki. Polomoko suo suomoko nokowoi sipo suo suomoko nokowoi anomu suo suomoko nokowoi na kokaloki. Noko nokolaloyo nonani koloni puwokomosikino, Kotoso ni monoi. Afonimaiso iwoi muwoi, suo mo muwoniyo. Muwoni suo suomoko noko mani, siki. Noko nokonu nokoni muwoni folo folo posuo suomokomosikino. Na kokaloki, kotisokomai siso. ");
INSERT INTO amm_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Wiyou, mulu mo siyoliso na atolokomoki. Moloyo manikoki. Nonani molo sopoyo wasouliki, na amiyaikiyokalo fuki. Suo suomoko noko komaso na amiyaikiyokalo fuki. Sipo koloniwoi polomokowoi amiyaikiyokalo fuki. Asiyofoloso na uloloniyo fuki. Muwoni suo suomoko nokoni kotisoko na alokwi taikiyoki. Muwoni mo kosifoliyafoumo watiki. ");
INSERT INTO amm_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Anomu suo suomoko noko iyaliso amiso na ikoki, “Anomu na pokoliyoniyo fuwo. Yani Apouni nu mo hani hani suo suomoko nu muwoi. Noiyo yoiwo.” ");
INSERT INTO amm_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Siyokutono iyaliyo amiyaikiyokoso kwaikino mo, Kotoni puko imo monoi mulumolokokino, tiyomuko, noino, “Nani lotu nu mulu mo siyoliso tuwomono, no monoi no nokoyo uwokaimonoinomo.” ");
INSERT INTO amm_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Nosai no mo; Yuto noko sisiyoli mo Isisoso imokino, “Hani monoi tamiyaikiyokalo funi? Noiyo imo taikiyokini? A, mulu ifolaluwawoi mi no yapoli towiyomokoni, koini molo timai? Wiyomoko somiso mo, koi no moloi saino monoi, noiyo imo taikiyokini?” ");
INSERT INTO amm_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Fowakoki, na ikoki, “Lotu nu siyoli ni mo ulalakinuwomo, ulo tauwoimai yo mo ko uwaimoimo, lotu nu tonofalo mo.” ");
INSERT INTO amm_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Imokino, Yuto noko sisiyoliyo mo, “Lotu nu siyoli ni mo toku nokoyo ko manokino, aisamu molopoi molopoi molopoi, 46. Ulo tauwoimai no moloi ko uwaimo monoi, nono no?” ");
INSERT INTO amm_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Aino louwa imokino, ulai imo folosai mo lotu nu siyoli monoi muwoi, tota amu monoisu ikoki, siyokawi imo na. ");
INSERT INTO amm_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Namolisai mo, yausai lusikai uwai; siyokutono iyaliyo nonani imo monoi mulumolokokino. No monoi no Kotoni puko imo mo waliyo mulumolo luwaikino. Isisoni imo mani, waliyo na mulumolo luwaikino. ");
INSERT INTO amm_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Pasowa koloni wasi popomai Isiso mo Yolusolimo nokonu siyoliso amai yousikainoki. Hani hani mulu ifolaluwawoi mi ano manoki, noko nokolaloni molo timai. No monoi no na mulumolo luwaikino, noko nokolalo molopoiyo. ");
INSERT INTO amm_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Isisosu mo noko monoi waliyo pa mulumoloko ukukiso. Noko komasoni mulu monoi mo sai, no monoi no pa mulumoloko ukukiso. ");
INSERT INTO amm_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","To mo sai, nokoni mulu monoi. Nokoyo pa posasoko wiyononikinoso, totayosu mo sai. ");
INSERT INTO amm_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Falisi moloso aluwai nokota, tani siyolo mo Nikotimo, Yuto noko samukuko nokota siya. ");
INSERT INTO amm_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Nonani nokota mo amolokimai tumoki, Isisoni auso. Na ima tumoki, “Aiyolokomomoko nokota, koi mo sai, Kotoyo imo taikiyokini. Mulu ifolaluwawoi mi na tano manoni, koini molo timai. Kotoyo fasi somiso mo, pa panoniso.” Aino ima tumoki, Nikotimoyo mo. ");
INSERT INTO amm_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Nosai no mo; Isisoyo mo na imoki, “Motuwa na timonoki. Noko mo tonofalo auwono somiso mo, Koto no ulai moloi samuku monoi?” ");
INSERT INTO amm_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ulai Nikotimoyo imoki, “Ulai moloi woi? Siyolimai no moloi auwono, tonofalo no? Atinoni nomoli poiso ti monoi no moloi loti monoi? Ti monoi no moloi siso monoi, atino no?” ");
INSERT INTO amm_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Nosai no mo; Isiso mo na fowaki, “Motuwa na timonoki. Noko mo iwoyo muwokai somiso mo, mulu tonofalo no moloi auwono monoi? Kotoni Mulu Itouniyaimo Nokotayo muwokai somiso mo, mulu tonofalo pa auwonoiso. Noko mo mulu tonofalo auwono somiso mo, ulai moloi samuku monoi, Kotoyo no? Mulu tonofalo auwono mo waliyo. ");
INSERT INTO amm_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nokoni au tuno mo atino apitononi alisai auwoniyou. Nokoni mulu tonofalosu mo Kotoni Mulu Itouniyaimo Nokotayo na anoni. ");
INSERT INTO amm_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Na tiyomukai, yo mo, mulu tonofalo auwonouluomo, noko komaso noko mo. Nono no moloi kufaumo monoi? ");
INSERT INTO amm_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Moloi si? Imonuyo ifou ifou tomaliyali, totani muluyosu. Noko mo imonu umuko tukwai, ulai moisai totumo, noko mo sai muwoi. Moiso tomoi, noko mo sosoli. Noinoso mulu tonofalo auwono monoi, noko no moloi ki monoi? Kotoni Mulu Itouniyaimo Nokotayo noinomo noko mo mulu tonofalo auwonoulu liyai.” Isiso mo aino na imoki, Nikotimoso mo. ");
INSERT INTO amm_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ulai Nikotimoyo imoki, “Moloi woi?” ");
INSERT INTO amm_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Nosai no mo; Isiso mo na imoki, “A, Isolilo noko aiyoloko nokota siyoli, nono no? Hani monoi nono no sai pakoso, Kotoni Mulu Itouniyaimo Nokotani mi no? ");
INSERT INTO amm_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Motuwa na timonoki. No tosainonoki no, nonani monoi na toposasoko wiyononinukuwo. Yasoi no kokokinoki no, nonani monoi na toposasoko wiyolukomonukuwo. Hani monoi tokulalimoko manonuwo, Yuto noko moi no? ");
INSERT INTO amm_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Kotoni asimai mi aino imo timonukuwo, ulai pa tukwaimono itouniyaimonuwoso. Kumoki mi aino imo imakinukuwomo, moloi kwaimono itouniyaimo monoi? ");
INSERT INTO amm_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nokoyo kumokiso awa amiyowoi muwoi, asasu mo kumokisai na amukonoki, yo asi asi noko nokolaloni noko siyoli nokota na. No monoi no asasu mo sai, kumokini hani hani mo. ");
INSERT INTO amm_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Moloi si? Toku mo Musiyo tomoki nuwo akaiya yoki, a mokiso, nu somiso asimai. Tomoki nuwo akaiya yoki, noko nokolaloyo ki monoi, ititounikai monoi. Noinoso akaimona yoinomo, asi asi noko nokolaloni noko siyoli nokota yo mo. Akaimona yakinomo, noko nokolaloyo mulumolo luwaimonoinomo. ");
INSERT INTO amm_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","Noko mo mulumolo luwaimonakimo, Kotoni auso na yousi itouniyaimo manoimo, aniyopa poi poi. ");
INSERT INTO amm_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Ulai afonimaiso? Koto mo mulu ukukaiki, asi asi noko nokolalo monoi. No monoi no mo totani awitona awitono na imo taikiyoki, asiso. Noko mo nonani nokotaso mulumolo luwaiyakimo, uwokaiwoi muwoi, na yousi itouniyaimoimo, aniyopa poi poi. ");
INSERT INTO amm_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Noko nokolaloni molo koiyau foli monoi pa imo taikiyokiso. Noko samiyaikiyo monoisu na imo taikiyoki, tani awitonoso. No monoi no. ");
INSERT INTO amm_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Nokoyo nonani nokotaso mulumolo luwai somiso mo, mulumolo luwai somiso foli monoi yasoi yomukai, Koto mo. Ulai afonimaiso? Kotoni awitona awitono pa tomulumolo luwaiso, no monoi no. Nokoyosu mo mulumolo luwaiyakimo, molo koiyau foli monoi pa uwoyoiso. ");
INSERT INTO amm_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Koto mo noko nokolaloni mulu kopokoiyau foli monoi na tiyomukai. Ulai afonimaiso? Saponi komiyai na amukonoki, asiso. Ulai folosu mulu saso tiyono, molo koiyau mulu na. Saponi mulu mo yowoi muwoi, folosu mulu saso tiyono. Molo koiyauso taluwaino, no monoi no folosu mulu saso tiyono. ");
INSERT INTO amm_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Molo koiyauso aluwai nokota mo saponi monoi mulu tatolokomo unu, namoliyo talosimo, saponiso. Ulai afonimaiso? Saponimai poliyai mo, nokoyo pukwai, molo koiyauso aluwaiso. ");
INSERT INTO amm_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nokoyosu mo Kotoni imo motu imoso aluwai itouniyaimakimo, saponi moloso aluwainiyo tumoimo, noko nokolaloni molo timai. Kotoni imoso kwai itouniyaimo nokota, no monoi no.” Isiso mo aino na imoki, Nikotimoso mo. ");
INSERT INTO amm_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Nosai no mo; Isiso iyali mo Yolusolimo nokonu siyoliso utukaimokino, Yutiya asiso nuki, sanoki. Siyokutono iyali yousi fasiko manoki mo, noko nokolalo iwoso puluwakomosikino, muwokokai monoi. ");
INSERT INTO amm_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Iyono mani, noko nokolalo puluwakomosiki, Ainonomai, Silimo mo aumoifaso. Iwo mo siyoli, no monoi no nosoni puluwakomosiki. Wiyou, noko nokolalo molopoiyo poti liyaimosiki, iwoso uluwako monoi. ");
INSERT INTO amm_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Iyono mo kalopulo nuso mo kiyowoi muwoi, amai, nomai no iwoso puluwakomosiki. ");
INSERT INTO amm_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Nosai no mo; uo imo lukasokino. Iyononi siyokutono iyali mo uo imo lukasokino, Yuto nokota siyawoi. Nonani nokotayo piyomuki, “Iyonoyo iwoso uluwakakimo, Koto mo imo mo futo muwoi. Isisoyo uluwako mo waliyo.” ");
INSERT INTO amm_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","No monoi no mo, Iyonoso ima tumokino, na imokino, “Oi, aiyolokomomoko nokota, noko toku no tolo tomasimokini no, Yotano iwo ausaimiso, toku no posasoko unukini no, nonani nokotayo mani, to mo noko nokolalo iwoso tuluwakomoi. Wiyou, totani auso na tonu liyaimoi, noko nokolalo molopoiyo. Koi mo wiyou tiyamonoki.” ");
INSERT INTO amm_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ulai na ikoki, Iyono mo, “Kumoki tolomu nokotayo noko fasi somiso mo, nonani nokota mo noko siyoli pa toloiso. ");
INSERT INTO amm_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Moiyosu mo yani imo yasoi kwaikinuwo, ya yomuki mo, “Yo mo Kolaiso muwoi, noko no mo Kotoyo no muwokaiki no, Isolilo noko moi fasimoka tumo monoi. No mo yo muwoi. Yo mo Kotoyo toku imono taikiyoki, “Na pomoi. Nono mo toku pomoi, tota monoi.” Kotoyo aino imono taikiyoki. Yo mo toku yasoi imokinukuwo. Moi mo sai. ");
INSERT INTO amm_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Moloi si? Siyokawi imo timonukuwo, noino. Noniyo nokitononi auso tosiso. Ainoso no moloi? Na tokauso, no monoi no. Tani noni nali. Nonani nokotani siyokutonosu, to mo noni kauso nokotayo ulukukumososu tukwai, no monoi no to mani, ulukukumoso na. Yo mo nonani siyokutono komiyai. Siyoliso na tomolokimokai. Noko nokolaloyo tani auso tosi mo, yo mo ulukukumoso na totolomoi. ");
INSERT INTO amm_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Yo mo afonimai nokota. To mo noko siyoli. Na tosouwaimonalo.” ");
INSERT INTO amm_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Siyokutono iyaliso ulai na ikoki, Iyono mo, “Puwosai amukono nokota mo noko komaso noko na tosouwaiko. Asi liyai nokotasu mo asiso totolokaino, asini imo saso tiyomumoi. Kumokisai amukono nokota mo noko komaso na tosouwaiko. ");
INSERT INTO amm_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Kumokisai imo no kwaiki no, nonani imo na toposasokalo. Kumokiso no kokoki no, nonani monoi aino imo na toposasokalo. Ulai wiyou, noko nokolaloyo waliyo pa tomulumoloko ununoso. ");
INSERT INTO amm_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Noko mo waliyo mulumoloko unakimo, nonani nokota mo na yomukaiyoimo, “Koto mo motu imo saso na tiyomukai.” ");
INSERT INTO amm_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Kotoyo imo taikiyo nokota mo Kotoni imo saso na tikalo. Kotoyo noinomo tani Mulu Itouniyaimo Nokotayo tamimomoi, wiyou, siyoliso tamimomoi. No monoi no tikalo. ");
INSERT INTO amm_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Apou Siyoli mo totani awitono monoi mulu tunumoi. Komaso hani mo tani nainomai yasoi na niki. ");
INSERT INTO amm_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Noko mo awitononi imo kulaliyakimo, Koto mo mulu atolokomokai unoimo, aniyopa poi poi koiyau yousoimo. Awitonoso mulumolo luwaiyakimo, na yousi itouniyaimoimo, aniyopa poi poi.” Iyono mo aino na ikoki, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Nosai no mo; Falisi moloso aluwai nokoni auso imofa kolo koloma tumoki, noino, “Isisoyo mo Iyono tosouwaiyalo. Noko nokolalo molopoi iwoso tuluwako tolomoi.” ");
INSERT INTO amm_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ulai Isisoyo mo noko uluwakowoi muwoi, tani siyokutono iyaliyoso iwoso puluwakomosikino. ");
INSERT INTO amm_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Isiso Siyolisu mo sai, Falisi moloso aluwai nokoyo imofa kwaikino mo, no monoi no Yutiya asiso utukaimoki, Kalili asiso ifou manoki. ");
INSERT INTO amm_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Manoki manoki manoki, Somaliya asi mulumai tokosiyaiyouki. ");
INSERT INTO amm_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Somaliya asi tokosiyaiyouki mo, nokonuso na tumoki. Nokonu siyolo mo Saiko. Yokoponi aniyopa asi mo aumoifaso, asi no mo totani awitono Yusifoso no anoniki no. ");
INSERT INTO amm_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Nokonu kwamai mo Yokoponi iwo si i ku toi. Ulo yakomai iwo si imai na yousikaina tumoki, Isiso mo. Mulu si yousa tumoki. Aluwasai tumoki, no monoi no. ");
INSERT INTO amm_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Nosai no mo; amai yousikainoki mo, Somaliya nukonu mo na tumosoki. Iwo woliyona tumoki. Na isoki, Isiso mo, “Iwo puwoliyomono.” ");
INSERT INTO amm_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Totani siyokutono iyali mo uwofa. Koloni iya tikino, nokonuso. No monoi no isoki, “Iwo puwoliyomono.” ");
INSERT INTO amm_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Isoki mo; na imoki, “Nono mo Yuto nokota, asasu mo Somaliya nukonu. Hani monoi timononi, “Iwo puwoliyomono.” Yuto nokoyo Somaliya nokowoi pa pasisikuwano manokinoso. No monoi no imoki, “Hani monoi timononi, “Iwo puwoliyomono.” ");
INSERT INTO amm_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Nosai no mo; Isiso mo na isoki, “Nono mo Kotoyo fasi monoi mo sai muwoi. Nono mo sai muwoi, yo no noi? Posainoni mo, nonayo pimononi, “Iwo puwoliyomono.” Iwo puwoliyononinoki, itouniyaimo iwo mo. Yani iwo sikakinimo, na yousi itouniyaimo manoinimo.” Aino na isoki, siyokawi imo mo. ");
INSERT INTO amm_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Nosai no mo imoki, “Noko Siyoli, nono mo iwo nau mo uwofa. Moloi toku woliyononi? Iwo mo woiso na ku toi. Moisai tuwoliyonomononi, nonani iwo itouniyaimo no? ");
INSERT INTO amm_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","A, nono no moini aniyopa Yokoposo tosouwaini? Totayo na aimokoki, ninani iwo si i mo, na posikomosiki. Awitono iyali mani, puwolikomosikino. Nukutai koloniso puwololukomosikino. A, nono no iwo siya tuwoliyonomononi?” ");
INSERT INTO amm_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Nosai no mo fowasoki, siyokawi imo na isoki, “Nokoyo ninani iwo sikakimo, iwo nukuwa ti monoi uwoyoimo. ");
INSERT INTO amm_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ulai nokosu mo yani iwo siyaso sikakimo, iwo nukuwa mo ti monoi pa kalo manoiso. Wiyou, asani iwoso sikakimo, iwo komu komiyai auwoniyouwoimo, tani mulu poiso. Na yousi itouniyaimoimo, aniyopa poi poi.” Siyokawi imo aino na isoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Nosai no mo imoki, noni mo, “Noko Siyoli, nonani iwo na puwoliyomono. Ya sikakimo, iwo nukuwa pa uwomonoiso, pa woliya tumomosoiso.” Ainoso imoki, piyomusoki, iwa iwo monoiwo. ");
INSERT INTO amm_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Nosai no mo; imoki mo; noniso na isoki, “Soi su, nani noko na pokausiyano.” ");
INSERT INTO amm_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ulai noniyo, “Yo mo nokowoi muwoi, noko mo uwofa.” Nosai no mo na isoki, “Motu na timononi. Nono mo noko molopoi aulu nukonu na. ");
INSERT INTO amm_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Naino siya uwai nokoso aulalokini, siyasonuso. Lolaisu mo noko siyani auso tiyousini, wosu woso, pa aukiniso. Motu na timononi.” ");
INSERT INTO amm_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Nosai no mo; noni mo na imoki, “Noko Siyoli, moloi nono no sai? Koto saso mo asani molo aluwai mo sai. Ya tiyomu, nono mo Kotoni mulu lukasiko nokota nali.” ");
INSERT INTO amm_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ulai imoki, “Ninani yu tonimai Koto monoi pomolokima yomosikino, koini aniyopa iyaliyo. Yuto noko iyali moiyo tiyamonuwo, Yolusolimo nokonu siyolimai saso molokimowumo, noko komaso noko mo. Nonayo piyomu.” ");
INSERT INTO amm_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Nosai no mo na isoki, “Woli, yani imo na pukwaimono. Amuwoi tinoso ninani yu tonimai saso pa molokimoinuwoso. Apou Siyoli monoi mo Yolusolimo nokonu siyoli saso pa molokimoikiso.” ");
INSERT INTO amm_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ulai isoki, “Somaliya noko nokolalo moi mo to monoi mo sai muwoi, afonimaiso tomolokimo manonuwo. Yuto noko koi mo sai. Na tomolokimo manonoki. Noko fasiko nokota siyoli mo Yuto nokoni alisai tauwono. No monoi no. ");
INSERT INTO amm_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Amuwoi tino mo Kotoni Mulu Itouniyaimo Nokotayo Apou Siyoli na wiyotiyoimo, asi asi noko nokolaloso mo. To mo Kota Koto na. No monoi no saino itouniyaimoinomo, na molokimalo liyaiyoinomo. Tani Mulu Itouniyaimo Nokotayo noinomo molokimaloinomo. Lolai mani, siyai mo sai. Nonani noko iyali monoi Apou Siyoli mo mulu mo waliyo. Toiyo molokimo monoi na tiyo. ");
INSERT INTO amm_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Koto mo mulu saso. Ta noinomo noko mo mulu tonofalowoi si na. Tani Mulu Itouniyaimo Nokotani amiyo mulu tonofalo ulolakimo, Kota Koto monoi saino itouniyaimoinomo, na molokimoinomo.” Aino isoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Nosai no mo; noni mo na imoki, “Yo mo sai, Kotoyo muwokai nokota mo tumoimo, noko no mo moi no fasimoka tumaki no. Tani siyolo mo Kolaiso tokaluwai manono. Ta tumakimo, na posasoko wiyolumokaloimo.” ");
INSERT INTO amm_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ulai na isoki, Isiso mo, “Asa, nonowoi imo ni tolukaso no, asa mo nonani nokota nali no.” ");
INSERT INTO amm_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Nosai no mo; amai isoki mo, siyokutono iyali mo ifou tiki, na mulumoloko manokino, “Oi, noniso no hani monoi tiso?” Ulai pa imokinoso, “Moloi tisoni?” Noinoso mani, pa imokinoso, “Hani monoi tisoni?” Aino pa imokinoso. ");
INSERT INTO amm_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nosai no mo; noni mo yasoi. Iwo nau saso potoloso. Nokonuso ifou manosoki. Noko nokolaloso ifou ika tiki, ikoki, ");
INSERT INTO amm_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Kukuwo, nokoso na pukwaima fuwo. Wiyou, hani komaso ya toku no yaloki no, to mo sai, yasoi na imono. Moloi saino, woi? Nakomo Kolaiso poimo, noko no mo Kotoyo muwokaiki, moi fasimoka tumo monoi.” ");
INSERT INTO amm_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ikoki mo; nokonuso utukaimokino, Isisoni auso monoi nuki, noko nokolalo mo. ");
INSERT INTO amm_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Noko nokolaloyo tiwoi muwoi, Isisoni siyokutono iyaliyo imokino, “Aiyolokomomoko nokota, fuo, na pono.” Koloni yasoi iyo tumokino, na imalokino, “Fuo, na pono.” ");
INSERT INTO amm_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ulai Isisoyo ikoki, “Yo mo koloni mo yapoli. Moi mo sai muwoi, nonani koloni mo.” No mo siyokawi imo na. ");
INSERT INTO amm_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ulai ikuwanokino, “Nakomo koloni mo noko siyayo poimo iyo tumo.” ");
INSERT INTO amm_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Nosai no na ikoki, “Yo mo imono taikiyo nokotani muluso aluwaiyakimo, yo mo yousi itouniyaimoimo, no touwai nokota komiyai. Tani mi uwaimakimo, na yousi itouniyaimoimo, no touwai nokota komiyai.” ");
INSERT INTO amm_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ulai na ikoki, “Noko nokolaloyo tiyamomosi, “Amu toitati mo uwai; isi aliyoli ulai wamokoimo, na iyoikimo.” Ulai ya timonukuwo, “Lolaisu mo yasoi na wamokokai, lolaisu mo i mo waliyo. Na pofoinaliko taikiyowo. Isi na pukwaikalowo.” Aino ikoki, isi aliyoli monoi muwoi, siyokawi imo nali, noko nokolaloyo mulu alosoko monoi na ikoki. ");
INSERT INTO amm_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ti monoi ikoki, “Nokoyo mulu alosoko mo, no mo isi aliyoli komiyai i. Nonani nokoso aiyoloko mo, Kotoyo suo foli monoi na tanoni, aiyoloko nokotaso mo. Mulu alosoko noko nokolaloyo aniyopa poi poi si itouniyaimo monoi na tomolokiko. Noko mo Kotoni imo toku no lukasikaloki no, to mo aliyoli ali kosikwiyalo nokota komiyai. To mani, tomolokiko. No monoi no toti mo tomoso molokiko na, noko nokolaloyo mulu alosoko monoi. ");
INSERT INTO amm_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Nokoyo motu imo tiyamomosi, noino, “Noko siyai mo aliyoli ali tokosikwiyalono, siyai mo isi aliyoli tiyalono.” ");
INSERT INTO amm_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yo mo na imo taikiyokinukuwo, noko mo isi aliyoli komiyai i monoi. Noko siyaiyo aliyoli ali komiyai toku kosikwiyalokino, Kotoni imo mo. Nonani mi siyoli pa anokinuwoso, toiyo na fasikomokinuwo, no monoi no mi uwaimoinuwomo.” Isiso mo siyokawi imo aino ikoki, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Nosai no mo; Saiko noko nokolalo molopoiyo Isisoso mulumolo luwaiyalo tumokino, Somaliya asi noko nokolalo na. Ulai afonimaiso? Noniyo toku yasoi posasoko wiyotiki, na ikoki, “Ya toku no yaloki no, to mo sai, yasoi na imono.” No monoi no Isisoso mulumolo luwaikino, tani auso monoi nuki. ");
INSERT INTO amm_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Nosai no mo; Isisoni au mo tiki, imalokino, “Koini auso tanuwou na potoi.” Ikoki, “Waliyo na.” No monoi no amoloki tiwoi tanoki. ");
INSERT INTO amm_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Imo na lukasikaloki mo, noko molopoi noko mo lolaloso mulumolo luwaikino, noko molopoi, wiyou. ");
INSERT INTO amm_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Noniso isokino, “Nani imo monoi saso pa tomulumolo luwainokiso. Koi mo tani imo mo yasoi na kwaimonoki. Koi mo sai, ta noinomo asi asi noko moi na samiyaikiyo monoi.” Aino isokino. ");
INSERT INTO amm_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Nosai no mo; amoloki tiwoi mo uwai; Isiso mo utukaikoki, Kalili asiso na manoki. ");
INSERT INTO amm_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Toku yomuki, “Kotoni mulu lukasiko nokota mo totani asiya asimai tolo mo, tolomu nokoyo pa kisosominoso.” Isiso mo aino toku yomuki, tota amu monoi. ");
INSERT INTO amm_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ulai Kalili asi mo tumoki mo, tolomu nokoyo imokino, “Waliyo potumo.” Toi mani, Isisoyo yaloso toku yasoi kwaikino, Pasowa koloni wasi popomai, Yolusolimo nokonu siyoliso numai. ");
INSERT INTO amm_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Nosai no mo; Kano nokonuso ti monoi manoki, Kalili asimai na. Toku mo iwa iwoyo molo wamo ito iwoso no wiyonoki no, nonani nokonuso na. Kopanaumo nokonu Kalili asimai no tanoki no, nomai no komano nokota mo tolokainoki. Nonani nokotani awitono mo ai uwoki. ");
INSERT INTO amm_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Nosai no mo apitononi auso imofa kolo koloma tumoki, noino, “Isiso mo yasoi tumoki. Kalili asiso tumoki, Yutiya asisai.” No monoi no Kano nokonuso manoki, Isisoso imanoki, na imaloki, “Yani alu mo ai tuwo, ai mo siyoli. Na kaloimo. Kuku, na pitouniyaima kono, Kopanaumo nokonuso.” ");
INSERT INTO amm_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Nosai no mo; Isiso mo na imoki, “Hani monoi pa tomulumolo luwaimononuwoso? Moini molo timai mo mulu ifolaluwawoi mi ano somiso mo, pa mulumolo luwaimononuwoso. Hani monoi mulu ifolaluwawoi mi mulu saso tiyonuwo?” ");
INSERT INTO amm_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ulai imoki, komano nokotayo mo, “Noko Siyoli, woi, na pamukono. Amukono somiso mo, yani alu mo na kaloimo, woi.” ");
INSERT INTO amm_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Nosai no mo na imoki, “Soi su, nani alu mo pa kaloiso, waliyo na toloimo.” Imoki mo; nonani nokota mo Isisoni imoso waliyo na mulumoloko unuki, na utukaimoki. ");
INSERT INTO amm_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Molo mo manoki manoki manoki; tani mi ano nokoyo molomai na tiki, na ima tumokino, “Oi, nani alu mo waliyo na totolo.” ");
INSERT INTO amm_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ikoki, “A, maniwoi tolosuwa?” Na imokino, “Fai, fai au momono mo futo, ulo yakomai.” ");
INSERT INTO amm_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Imokino mo; apitono mo na yomuki, “Ulo yakomai nali no Isisoyo fai imona, “Nani alu mo pa kaloiso, waliyo na toloimo.” No monoi no toi koli mulumolo luwaikino. ");
INSERT INTO amm_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","No mo ti monoi mulu ifolaluwawoi mi nali no. Noko nokolaloni molo timai anoki, Kalili asimai, Yutiya asisai ifou ana tumomai. ");
INSERT INTO amm_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Nosai no mo; Yolusolimo nokonu siyoliso amiyoki, Isiso mo. Yuto nokoni mi fou fouko popo siya na, no monoi no amiyoki. ");
INSERT INTO amm_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Yolusolimo nokonu siyoli mo koki fiyaimokai, muluso tu tanoki. Koki fiyaimokai itu loti mo yapoli na. Itu loti siya siyolo mo Sipo Koloni Itu na. Nonani itu aumoifaso mo iwo toi, iwo toku iwo koufa na. Nonani iwo toku iwo mo Pitisato tokaluwai manono. No mo Hipolu imosai, Yuto nokoni imosai na. Fulomu nu naino siya uwai kololi anokoukukai, iwo toku ilomai. ");
INSERT INTO amm_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Noko molopoi, noko kopokoiyau nokoyo si liyaiki, molo kau kau nokowoi naino fona nomoli nomoli nokowoi. Iwo moli moli monoi foumo si liyaiki. ");
INSERT INTO amm_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Nuwoi siya mo Kotoni kumoki nokotayo iwo toku iwoso pamukonomosiki, iwoso pomoli moli tola konomosiki. Iwo moli moli uwai; totawoi nokotayo amukono mo, ai mo uwai. ");
INSERT INTO amm_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Aniyopa ai nokota mani, tanokainoki. Tokusai ai uwokaiki, aisamu molopoi, 38. ");
INSERT INTO amm_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Nosai no mo; Isiso mo tumoki, nonani nokota tanokainoso kwaiki, aniyopa ai no uwokaiki no, na imoki, “A, noko itouniyaimo tolo mulu monoi tiyoni?” ");
INSERT INTO amm_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Nosai no mo; noko koiyau mo fowaki, “Noko Siyoli, yo mo asaso. Iwo moli molimai mo nokoyo fasimonowoi muwoi, iwoso kawiyo konomonowoi muwoi, iwo no moloi louko monoi? Iwo louko mo waliyo. Yo mo iwoso louwa tolouka konomosi, ulai nokoyo na tosouwaimonomosino.” ");
INSERT INTO amm_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Nosai no mo; Isiso mo na imoki, “Na potolau. Molo tokosi na palomako, na pomoi.” ");
INSERT INTO amm_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Imoki mo; lolai siyaso waliyo na toloki, na manoki, molo tokosi na alomakoki. Mi fou fouko ulomai na itouniyaimokaiki. ");
INSERT INTO amm_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","No monoi no Yuto noko sisiyoli mo Isisoyo itouniyaimokai nokotaso ima tumokino, “Lolai mo mi fou fouko ulo. Hani monoi molo tokosi tosokunalomanikoni? Aniyopa imoyo tiyomuko au.” ");
INSERT INTO amm_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ulai ikoki, “Itouniyaimomonokai nokotayo imono, “Molo tokosi na palomako, na pomoi.” ");
INSERT INTO amm_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nosai no mo imokino, “A, nonani nokota no noi? Hani monoi imoni, molo tokosi alomako monoi no?” ");
INSERT INTO amm_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Isisoyo itouniyaimokai nokotasu mo sai muwoi, to mo sosoli, noiyo poimo. Noko nokolalo molopoi ukouniyaikokai. Ulai moloi ki monoi, Isisoso no? ");
INSERT INTO amm_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Nosai no mo; Isiso mo lotu nu siyoliso kiya tiki, na imoki, “Na pukwaimono. Waliyo na totoloni. Molo koiyauso noiyo aluwaiyoi. Wonikaluso koiyau siyoliyo aiko uwokaiyoini.” ");
INSERT INTO amm_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Imoki mo; Yuto noko sisiyoliso ikanoki, ikoki, “Isisoyo itouniyaimomonokai, Isisoyo nali.” ");
INSERT INTO amm_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","No monoi no mo, Yuto noko sisiyoli mo Isiso uwokino. Mi fou fouko ulomai itouniyaimokai foli monoi uwokino. ");
INSERT INTO amm_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ulai ikoki, Isiso mo, “Yani Apou mo tokusai ititounikaimoi, ulo ulo saiso saiso ainoso lolaiwoi. Asa mani, ainoso na, tomoso nali.” ");
INSERT INTO amm_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Nonani imo monoi, tukolo mulu siyoli monoi yalokino, Yuto noko sisiyoli mo. Na iyamoki, “Mi fou fouko ulomai itouniyaimokai mo au. No mo koufa. Ulai Koto monoi tokaluwai, totani apitonowo. Wiyouwa wiyou. Ulai moloi yomu monoi, Koto toti mo tomosowo.” Yuto noko sisiyoli mo aino iyamoki, tukolo mulu monoi na yokino. ");
INSERT INTO amm_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Nosai no mo; Isiso mo Yuto noko sisiyoliso na ikoki, “Motuwa na timonukuwo. Kotoni awitono yo mo asani amiyoso pa tiyomoiso. Apou Siyoliyo yaloso yo tukwaimoi, na tiyalo. Apou Siyoliyo no tiyalo no, tani awitono yo mani, tiyalo. ");
INSERT INTO amm_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Apou Siyoli mo mulu tunumono, tani awitono yo monoi. Hani hani no tiyalo no, na towiyolumonalo. Mulu ifolaluwawoi mi no wiyolukomokinukuwo no, no mo koulolofasu. Mi sisiyoli wiyolumonakimo, ya na analoimo, moini molo timai. Wiyou, na mulumolokaloinuwomo. ");
INSERT INTO amm_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Apou Siyoli mo yau yau noko tolusokokaimoi, yausai. Ta noinomo tosi itouniyaimomoi. Noinoso na, tani awitono yo mani, tomoso na tiyo. Asani muluyosu, noko nokolalo tosi itouniyaimo liyai. ");
INSERT INTO amm_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Apou Siyoli mo molo koiyau foli monoi yomukaiwoi muwoi, asaso na imonokaiki, “Nonayosu pa yomukai, molo koiyau foli imo mo.” Ainoso imonoki. ");
INSERT INTO amm_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ya molo koiyau foli monoi yomakimo, noko nokolalo komasoyo na kisosomimonoinomo. Apou Siyoli tokisosomi manono. Noinoso kisosomimonoinomo. Nokoyo kisosomimono somiso mo, yani Apouso no moloi kisosomi monoi? Na imono taikiyoki.” Isiso mo aino na ikoki, Yuto noko sisiyoliso mo. ");
INSERT INTO amm_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ulai na ikoki, “Motuwa na timonukuwo. Noko mo yani imoso kwai itouniyaimakimo, imono taikiyo nokotaso mulumolo luwaiyakimo, aniyopa poi poi yousi itouniyaimoimo. Molo koiyau foli monoi pa uwoyoiso. Nonani nokota mo kolikali moloso yasoi utukaimo, yousi itouniyaimo moloso na taluwaimoi. ");
INSERT INTO amm_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Motuwa na timonukuwo. Amuwoi tino mo kolikali moloso aluwai nokoyo yani imoso kwaimonoinomo. Kotoni awitono, yani imoso kwaimono itouniyaimakinomo, na si itouniyaimoimo, aniyopa poi poi. Lolaisu mani, ainoso na. ");
INSERT INTO amm_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Apou Siyoli mo noko muwokokai, aniyopa poi poi si mano monoi. Tani awitono yo mani, noko muwokokai, aniyopa poi poi si mano monoi. Nonani amiyo na amonoki. ");
INSERT INTO amm_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Yo mo asi asi noko nokolaloni noko siyoli nokota. No monoi no imono taikiyoki, “Molo koiyau foli imo mo nonayo na pa yomukai.” ");
INSERT INTO amm_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Hani monoi tomulumoloko manonuwo? Amuwoi tino mo noko yau yau mo yani imo kwaimonoinomo. Asiso toku no aiko ukukino no, nonani noko iyali mo yani imo kwaimonoinomo, ");
INSERT INTO amm_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","na auwonouloimo. Molo koiyauso aluwai noko mo auwonouloimo. Nosai no molo koiyau foli monoi na uwokoimo. Molo itouniyaimoso aluwai noko mo auwonouloimo, na si itouniyaimoimo, aniyopa poi poi.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ulai ikoki, Yuto noko sisiyoliso. Isiso mo na ikoki, “Yo mo asani amiyoso mo pa tiyomoiso. Molo koiyau foli imo yomukaiyakimo, motu imo na yomukaiyoimo, motu nali. Ulai afonimaiso? Asani muluyosu yomukaiwoi muwoi, imono taikiyo nokotani muluyoso na yomukaiyoimo. ");
INSERT INTO amm_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Asa amu monoi yomukaiyakimo, ulai moloi kwaimono monoi, moi no? ");
INSERT INTO amm_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Noko siyayosu mo na tiyomu unumonokai, Apou Siyoliyo mo. Motu na tiyomukai. Yo mo sai. ");
INSERT INTO amm_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Toku moi mo nokoso iko taikiyokinuwo, Iyono imano monoi, “Nono no noi, woi?” Ulai Iyono mo asa monoi aino imo posasokoki, imo motu nali. ");
INSERT INTO amm_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Yo fasimono monoi pa posasokokiso. Moi fasikomo monoisu na posasokoki, moiyo mulumolo luwaimono monoi, samiyaikiyo monoi. No monoi no timonukuwo, Iyononi imo monoi. ");
INSERT INTO amm_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Iyono mo ta komiyai amukoki, na fupiniyaimoki. Tani imo mo saponi komiyai. Fokufaso kwaimokinuwo, molokimokinuwo. ");
INSERT INTO amm_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Iyononi imo no posasoko unumonoki no, no mo koufa hani. Mi ya no tanomoi no, no mo siyoli hani. Apou Siyoliyo imono taikiyoki, totani mi uwaimo monoi. Nonani misu na tanomoi, yo mo, moini molo timai. No monoi no na towiyononinukuwo, Apou Siyoliyo imono taikiyoki mo. ");
INSERT INTO amm_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Apou Siyoli to mani, asa monoi na yomu unumonoki. Tani ko na mo moi mo kwaiwoi muwoi, tani amu molo mani, kiwoi muwoi. ");
INSERT INTO amm_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Tani imo monoi pa tomulumoloko manonuwoso. To mo na imono taikiyoki, ulai pa tomulumolo luwaimononuwoso. ");
INSERT INTO amm_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Aniyopa poi poi si itouniyaimo monoi tiyonuwo, no monoi no Kotoni puko imoso tokokalo manonuwo. Hani monoi moi no sai pakoso, asa monoisu tiyomuko unumono no? ");
INSERT INTO amm_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ulai wiyou tiyamonuwo, yoso pa tomulumolo luwaimononuwoso. Aniyopa poi poi no moloi si itouniyaimo monoi, moi no.” Isiso mo aino na ikoki, Yuto noko sisiyoliso. ");
INSERT INTO amm_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ulai ikoki, “Nokoyo yani siyolo kaluwaimono mulu monoi pa tiyoso, yo mo. ");
INSERT INTO amm_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Moi mo folo. Noko sisiyoli si mulu monoi na tiyonuwo. Koto monoi mulu pa tununuwoso. Yo mo sai. ");
INSERT INTO amm_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yani Apouyo imono taikiyoki. Ulai yani imo na tokulalimononuwo. Afonimai nokoyo totaini muluyosu ima tumonuwo mo, imo kulalikowoi muwoi, waliyo na mulumolo luwaikonuwo. ");
INSERT INTO amm_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","A, yoso no moloi mulumolo luwaimono monoi, moi no? Nokoni molo timai noko sisiyoli si mulu saso tiyonuwo. Kotoni molo timai noko sisiyoli si mulu pa tiyonuwoso, Kota Kotoni molo timai. No monoi no yoso pa tomulumolo luwaimononuwoso. ");
INSERT INTO amm_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Moini molo koiyau foli monoi mo Apou Siyoliso pa faumiyoiso, yo mo. Musi aniyopa nokota siyoli, totani imo monoisu na auwosikomoinuwomo, Apouni molo timai. Musini imoso louwa taluwainuwo, tiyamonuwo, aniyopa poi poi si itouniyaimo monoiwo. ");
INSERT INTO amm_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Musi mo asa monoi aino imo na kumo unumonoki. Musiso waliyo pomulumoloko ununuwo mo, yoso mani, pomulumolo luwaimononuwo. ");
INSERT INTO amm_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Musiyo toku no kumo unumonoki no, nonani imoso pa tomulumolo luwainuwoso. No monoi no yani imo mani, tomoso na, pa tomulumolo luwaimononuwoso.” Isiso mo aino na ikoki, Yuto noko sisiyoliso. ");
INSERT INTO amm_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Nosai no mo; amuwoi tinosai Isiso iyali mo Kalili iwo toku ausaimiso tiki. Nonani iwo toku iwoni siyolo siya mo Taipiliyo iwo. ");
INSERT INTO amm_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Noko molopoi noko mo aluwaiyalokino, noko molopoi, wiyou. Ai ai noko ititounikaiso pukwaimosikino, mulu ifolaluwawoi miso. No monoi no aluwaiyalokino. ");
INSERT INTO amm_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Nosai no mo; yuso na sa yoki, Isiso iyali mo. ");
INSERT INTO amm_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Pasowa koloni wasi popo mo aumoifaso, Yuto noko nokolaloni mi fou fouko popo siyoli mo. ");
INSERT INTO amm_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Nosai no mo; si manoki mo, Isiso mo ku foinalikoki. Wiyouwa wiyou, noko nokolalo molopoi ti liyaiso kwaikoki, noko nokolalo molopoi mo wiyou. Filiposo na imoki, “Oi, paluwa tuo no moiso tiyanokoni, toi tiya monoi no?” ");
INSERT INTO amm_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Filiposo aino na imo kiki. Isiso totayo mo sai yasoi, mulumolokokaiki, hani yo monoi mo. ");
INSERT INTO amm_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Nosai no mo; Filipoyo na fowaki, “Paluwa tuo suo suomokakikonimo, muwoni mo wiyou, 200 kina mo koma muwoi. Noko nokolalo mo pounu, atiyaiso pa komamoiso. Noko komaso no moloi noko monoi?” ");
INSERT INTO amm_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Nosai no mo; siyokutono siya, tani siyolo mo Anotolu, Saimo Pitani auwatono, to mo Isisoso na imoki, ");
INSERT INTO amm_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Oi, alu ni tolo no, to mo paluwa tuo komu lolofa mo naino siyai. La lolofa mo tiwoi. Ulai noko nokolalo mo molopoi, wiyou. Pa komamoiso.” ");
INSERT INTO amm_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Nosai no mo; Isiso mo siyokutono iyaliso na ikoki, “Noko nokolaloso pikowo, sinonalumo.” Sosonowoi asi, no monoi no sinonaloki. Noko mo molopoi molopoi, wiyou na, 5000 nali no. ");
INSERT INTO amm_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Sinona konoki mo, Isiso mo paluwa tuo komu komu na uwoki, Kotoso na imoki, “Wafisu.” No monoi no na wautiki, ainoso komaso kolosi. La somu mani, tomoso na. ");
INSERT INTO amm_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Na nokokino, touwaiwoi na tolokoki. No uwai; Isiso mo na ikoki, siyokutono iyaliso, “Waloto mo ifou na pisikokaiwo. Wonikaluso aiko popikoi.” ");
INSERT INTO amm_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ikoki mo; na iyalokino, paluwa tuo mo iso na alokino, i molo tiwoiso, 12. Noko molopoiyo paluwa tuo komu naino siya noko uwai; waloto mo amai na si liyaiki. Nonani waloto na alokaikino, i molo tiwoiso. ");
INSERT INTO amm_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Noko nokolaloyo nonani mulu ifolaluwawoi mi anoso kwaikino mo, na iyamoki, “Motu na, noko ni mo, to mo Kotoni mulu lukasiko nokota siyoli na, aniyopa nokoyo no iyamo unuki no, asiso tumo monoi.” ");
INSERT INTO amm_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Ulai Isiso mo toini mulu mo sai, mulumolokoki, “Wonikaluso alotoluwaimonoinomo, asi samukuko nokota siyoli aiko muwomonoino.” No monoi no utukaikoki, yuso ulai amiyoki, totaso. ");
INSERT INTO amm_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Nosai no mo; upimoso; Isisoni siyokutono iyali mo iwo toku iloso kunoki. ");
INSERT INTO amm_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Ayouso folamuwaniyo konoki, yasoi, na louwa alomakokino, Kopanaumo nokonuso louwa nuki, iwo toku ausaimi nokonuso. Folosu na, ulai Isiso mo amai, tumowoi muwoi. ");
INSERT INTO amm_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Imonu siyoli auwoniyouki, iwo mi mo siyoli, na siyolimo taikiyoki. ");
INSERT INTO amm_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Nosai no mo; aluwamaifa alomakokino mo; nosai no Isiso tumoso na kwaikino, iwo tonimai fona molo tumoso. Aumoifaso tumoki mo, wiyou, na kokolokoki. ");
INSERT INTO amm_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ulai na ikoki, “Nisu mo asasu, noiyo kokolokomoiwo.” ");
INSERT INTO amm_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nosai no toi mo mulu mo waliyo, ayou poiso na kominiyo yokino. Kominiyo yokino mo; lolai siyaso toloka tiki, iwo iloso toku no louwa nuki no. ");
INSERT INTO amm_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Nosai no mo; amuwoisai noko nokolalo amai no siki no, iwo toku ilo ausaimimai, toi mo na iyamoki, “Oi, ayou mo siyasu fai taka. Isiso mo pa lotaso, siyokutono iyali saso na alomakano. Isiso no moiso mana, woi?” ");
INSERT INTO amm_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Nosai no mo; ayou siyaiyo Taipiliyo nokonusai tiki, asi aumoifaso paluwa tuo no wautiki no, fainisai Isisoyo wafisu no yomuki no, noko nokolaloyo paluwa tuo no nokokino no, nonani asi aumoifaso tiki, ayou siyaiyo. ");
INSERT INTO amm_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Noko nokolalo mo Isiso iyaliso uwofa kokokino mo, nosai no ayouso folamuwaniyo kono liyaiki, Kopanaumo nokonuso nuki, Isiso ikoliyalo monoi. ");
INSERT INTO amm_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Nosai no mo; noko nokolalo mo Isisoso kiya tumokino, imokino, “Aiyolokomomoko nokota, maniwoi tumoni?” ");
INSERT INTO amm_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ulai na ikoki, “Motuwa na timonukuwo, mulu ifolaluwawoi mi anoso fai kwaimonanuwo. Nonani monoi pa tikolimona tumonuwoso. Paluwa tuo touwai monoisu na tikolimona tumonuwo. Mulu ifolaluwawoi miya mi pa tosainonuwoso. ");
INSERT INTO amm_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Tuo mulu saso noiyo yoiwo. Tuo mo na faisokoimo. Tuo mo ausu tamikomonuwo. Mulusu amikomo mulu monoi na piyowo, aniyopa poi poi si itouniyaimoinuwomo. Asa, asi asi noko nokolaloni noko siyoli nokota yo amikomoikuwomo, moini mulu mo. Apou Siyoli Kotoyo na muwomonokaiki, no monoi no.” ");
INSERT INTO amm_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Nosai no mo imokino, “Koi no moloi yoikimo, Kotoni mi ano monoi no?” ");
INSERT INTO amm_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Fowakoki, na ikoki, “Kotoni mulu mo noino, yoso mulumolo luwaimono na. Na imono taikiyoki, moiyo mulumolo luwaimono monoi.” ");
INSERT INTO amm_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ulai imokino, “Noini mi tanoni? A, mulu ifolaluwawoi mi no yapoli towiyomokoni, koini molo timai? Wiyomoko somiso mo, koi no moloi mulumolo luwai monoi? Na powiyomoko. ");
INSERT INTO amm_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Aniyopa iyaliyo tuo siya ponoko manokino, mana tuoso. Nu somiso asimai mo mana tuoso ponoko manokino. Ainonani monoi mo Kotoni puko imoyo tiyomuko, noino, “Kumokisai nika kono tuo ponoko manokino.” Aino kumoki, Kotoni pukoso mo.” Isisoso aino imokino, noko nokolalo mo. ");
INSERT INTO amm_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Nosai no mo; Isiso mo na ikoki, “Motuwa na timonukuwo. Aniyopa nokota Musiyo kumokini tuo pa nikokiso. Yani Apouyosu mo kumokini tuowa tuo na tanoninuwo. ");
INSERT INTO amm_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Kotoni tuo mo kumokisai na amukonoki. Nonani kumokisai tuoyo nokoso amimakimo, aniyopa poi poi yousi itouniyaimo manoimo.” ");
INSERT INTO amm_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Nosai no imokino, “Noko Siyoli, nonani tuo na pa nimokomoi, saiso saiso.” ");
INSERT INTO amm_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Nosai no mo; Isiso mo siyokawi imo na ikoki, “Asa mo tuo itouniyaimo komiyai. Yo noinomo aniyopa poi poi tosi itouniyaimo manonuwo. Noko mo yani auso tumakimo, tiya pa uwoyoiso, tuo touwai nokota komiyai na yousikainoimo. Iwo nukuwa mani, pa uwoyoiso. ");
INSERT INTO amm_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Momaini molo tiyo na tokimononuwo. Ulai hani monoi pa tomulumolo luwaimononuwoso? Toku yasoi imokinukuwo. ");
INSERT INTO amm_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Apou Siyoliyo no tomuwokokaimono no, toi mo yani auso na toimo. Takimo, yo mo usainiyaikowoi muwoi, yani auso na koliyo toimo. ");
INSERT INTO amm_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Ulai afonimaiso? Yo mo kumokisai amukonoki, asani muluso aluwaiwoi muwoi, imono taikiyo nokotani muluso na taluwai. ");
INSERT INTO amm_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Tani mulu mo noino. Noko nokolalo yoso no muwokokaimonoki no, toi no moloi uwokaiko monoi? Asani nainomai suomo. Asi fokumakimo, yausai na lusokokaiyoimo, yo mo. ");
INSERT INTO amm_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Motu na, yani Apouni mulu mo noino. Tani awitono yoso aluwaimonakimo, noko mo, aniyopa poi poi na yousi itouniyaimo manoimo. Mulumolo luwaimonakimo, ya na lusikaiyoimo, yausai, asi fokumomaiso. Aniyopa poi poi na yousi itouniyaimo manoimo.” Isiso mo ainoso na ikoki, noko nokolaloso. ");
INSERT INTO amm_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Nosai no mo; Yuto noko mo amuwaso alikino, na ikuwanokino, “Moloi woi? Hani monoi timoko, “Asa mo tuo itouniyaimo komiyai, kumokisai no amukonoki no.” Ainoso no moloi imoko monoi? ");
INSERT INTO amm_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Noko ni mo, to mo Yusifoni awitono nali. Tani siyolo mo Isiso. Atino apitono noko ti monoi moi mo sai. Moloi woi? Konoi no moloi yomu monoi, kumokisai amukonowo.” Ainoso ikuwanokino, amuwaso. ");
INSERT INTO amm_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Nosai no mo; Isiso mo na ikoki, “Amuwa no hani monoi tosinuwo? Noiyo. ");
INSERT INTO amm_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Apou Siyoli, yo no imono taikiyoki no, to mo noko kiyomona tumo somiso mo, nonani nokota no moloi aluwaimoniyo tumo monoi? Yani auso tumakimo, yausai waliyo na lusikaiyoimo, asi fokumomaiso. ");
INSERT INTO amm_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kotoni mulu lukasiko nokoyo kulukaikino, noino, “Koto mo noko komaso noko na aiyolokoimo.” Aino kulukaiki. Noko mo Apou Siyolini imo kwaimo itouniyaimakimo, yani auso na tumoimo. Tani imo sainakimo, na aluwaimonoimo. ");
INSERT INTO amm_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nokoyo Apou Siyoli pa ki manokinoso. Asa, Kotoni ausai amukono nokota asayosu mo Apou Siyoli yapoli na ki. ");
INSERT INTO amm_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Motuwa na timonukuwo. Mulumolo luwaimono nokota mo na tiyousi itouniyaimomoi, aniyopa poi poi. ");
INSERT INTO amm_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Asa mo tuo itouniyaimo komiyai. Yo noinomo aniyopa poi poi tosi itouniyaimo manonuwo. ");
INSERT INTO amm_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Moini aniyopano iyaliyo mana tuo ponoko manokino, nu somiso asimai. Mana tuo ponoko manokino, ulai kolikaliki, yau yau. ");
INSERT INTO amm_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Nisu mo tuo itouniyaimo komiyai kumokisai no amukonoki no. Noko mo nakimo, pa kalokaiyoiso, aniyopa poi poi yousi itouniyaimo manoimo. ");
INSERT INTO amm_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Asa mo amai tolokaino tuo itouniyaimo komiyai, kumokisai no amukonoki no. Noko mo ninani tuoso nakimo, aniyopa poi poi na yousi itouniyaimo manoimo. Tuo yo no anoninaki no, no mo yani au somu na. Asi asi noko nokolalo moiso na anoninoikuwomo, moiyo si itouniyaimo monoi, aniyopa poi poi.” Isiso mo siyokawi imo ainoso ikoki, toi kwalomai monoi kalo uku monoi. ");
INSERT INTO amm_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Nosai no mo; Yuto noko mo uo imo lukasikuwanokino, na ikuwanokino, “Moloi woi? Noko ni no, tani au somu no moloi amokoimo, woi? Moi no moloi no monoi, woi, tani au somu no?” ");
INSERT INTO amm_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Nosai no mo; Isiso mo siyokawi imo na ikoki, tota kalo monoi, “Motuwa na timonukuwo. Yo, asi asi noko nokolaloni noko siyoli nokota yani au somuso nomono somiso mo, moi no moloi si itouniyaimo mano monoi? Yani nako siko somiso mo, moi no moloi si itouniyaimo mano monoi? ");
INSERT INTO amm_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Noko mo yani au somuso nomonakimo, yani nako sikakimo, aniyopa poi poi na yousi itouniyaimo manoimo. Asi fokumakimo, asayo na lusikaiyoimo, yausai. ");
INSERT INTO amm_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ulai afonimaiso? Yani au somuyo moini muluso tamikomonukuwo. Yani nakoyo mani, muluso tamikomonukuwo. Amiya ami nali no. No monoi no. ");
INSERT INTO amm_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Noko mo yani au somuso nomonakimo, yani nako mani, sikakimo, asawoi tomoso tolokainoimo. Asa mani, tolo tomasimoimo, totawoi. ");
INSERT INTO amm_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Amai tolokaino nokota, Apou Siyoliyo imono taikiyoki, “Na pomoi.” Tani amiyo yo mani, amai totolokaino. Noinoso noko mo nomonakimo, na tolokainoimo, aniyopa poi poi. Asani amiyo na tolokainoimo. ");
INSERT INTO amm_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","No mo tuo itouniyaimo komiyai, kumokisai no amukonoki no. Aniyopano iyaliyo mana tuoso ponoko manokino, ulai kolikaliki, yau yau. Ninani tuo mo folo. Noko mo nomonakimo, aniyopa poi poi na tolokaino manoimo.” ");
INSERT INTO amm_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Isiso mo siyokawi imo aino na ikoki, tota kalo monoi. Kopanaumo noko nokolaloso ikoki, lotu nufaso aiyolokomai. ");
INSERT INTO amm_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Isiso mo siyokawi imo aino ikoki, totani au somuwoi totani nakowoi monoi. Ikoki mo; aluwai noko siyai mo iyamoki, “Wiyou, imo mo muluso nali no. Koi no moloi kwai itouniyaimo monoi?” ");
INSERT INTO amm_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Nosai no mo; Isiso mo na ikoki, “A, namoliyo talosimomononuwo?” Amuwa siki, tani imo monoi. Isisosu mo sai. No monoi no ikoki, “A, namoliyo talosimomononuwo? ");
INSERT INTO amm_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Yoi, asi asi noko nokolaloni noko siyoli nokota yo ifou amiyoso kwaimonakinuwomo, nosai no no moloi iyamoinuwomo? ");
INSERT INTO amm_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Nokoni amiyo aniyopa poi poi moloi yousi itouniyaimo mano monoi? Kotoni Mulu Itouniyaimo Nokotani amiyosu mo aniyopa poi poi tosi itouniyaimomoi, noko mo. Imo no timonukuwo no, nonani imoso kwaimonakinuwomo, aniyopa poi poi na si itouniyaimo manoinuwomo, Kotoni Mulu Itouniyaimo Nokotani amiyosu. ");
INSERT INTO amm_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Ulai moi siyai mo pa tomulumolo luwaimononuwoso.” Ulai afonimaiso ikoki? To mo sai. Tokusai to mo sai, mulumolo luwai somiso noko monoi. Uo nokoni auso kiyo nokota monoi mani, to mo sai. ");
INSERT INTO amm_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ti monoi ikoki, “No monoi no yasoi imonukuwo, “Apou Siyoliyo fasi somiso mo, noko no yani auso moloi aluwaimoniyo tumo monoi?” Aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Nosai no mo; Isisoni imo no kwaikino mo; aluwai noko siyaiyo namoliyo alosimokino, toso aluwai monoi mo wiyou iyamoki. ");
INSERT INTO amm_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Noko molo tiwoi nokoso na ikoki, “A, moi mani, tutukaimononuwo?” ");
INSERT INTO amm_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Nosai no mo; Saimo Pita mo Isisoso na imoki, “Noko Siyoli, noko siyani auso no moloi nu monoi? Nani imoso kwai itouniyaimakinokimo, aniyopa poi poi si itouniyaimo manoikimo. ");
INSERT INTO amm_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nonoso na tomulumolo luwai manonoki. Koi mo sai, Kotoyo na imo taikiyokini.” ");
INSERT INTO amm_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Nosai no mo na ikoki, “Noko molo tiwoi noko moiso asa mo na muwokaikinukuwo. Ulai moi nokota siya mo Sokolo Nokota Waini siyokutono na.” ");
INSERT INTO amm_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yutaso monoi yomuki, Saimo Isokailiyoni awitono monoi. Noko molo tiwoi mulumai nokota na, ulai uo nokoni auso namolisai kiyokoki. ");
INSERT INTO amm_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Nosai no mo; Isiso mo Kalili asimai liyaiyaloki. Yutiya asiso mano monoi mo wiyou yomuki. Yuto noko sisiyoli mo tukolo mulu yokino, no monoi no. ");
INSERT INTO amm_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Liyaiyaloki mo, Yuto nokoni mi fou fouko popo siya mo aumoifaso na potanoki. Nonani popomai fulomu nu pokololi manokino, Yolusolimo nokonu siyolimai. Aisamu saiso saiso mo ainoso na. ");
INSERT INTO amm_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Nomai no mo, Isisoni auwatono iyali mo na louwa imokino, “Oi, ninani asi na putukaimo. Yutiya asiso na pomoi, Yolusolimo nokonuso. No monoi no nokoyo mulu ifolaluwawoi mi anoso kwaiyoinimo, nani moloso aluwai noko nokolaloyo. ");
INSERT INTO amm_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Mulu ifolaluwawoi mi wosu woso no moloi ano monoi? Nokoyo noko nokolaloni molo timai tolo mulu monoi yo mo, Yolusolimo nokonu siyoliso ananumo. Mulu ifolaluwawoi mi na panano, noko nokolaloni molo timai.” Isisoni auwatono iyali mo aino na imokino. ");
INSERT INTO amm_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Toi mani, pa mulumolo luwaikinoso. No monoi no louwa imokino. ");
INSERT INTO amm_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ulai Isiso mo na ikoki, “Lolai no moloi mano monoi, yo no? Yo mano ulo mo amai. Moi mo folo, momaini muluyosu na tonu liyaiyalonuwo. ");
INSERT INTO amm_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Asi asi nokoyo moi monoi no moloi mulu atolokomo unu monoi? Asa monoisu mulu tatolokomo unumonono. Yo mo totaini molo koiyau monoi imo toposasokomoi. No monoi no mulu tatolokomo unumonono. ");
INSERT INTO amm_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Mi fou fouko popo na. Moi mo toku ponuwo. Yo mo namolisai. Yo mano ulo mo amai.” ");
INSERT INTO amm_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Aino na ikoki. Manowoi muwoi, Kalili asiso amai tolokainoki. ");
INSERT INTO amm_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Auwatono iyaliyo Yolusolimo nokonuso nuki mo; ulai Isiso mani, na manoki. Noko nokolaloni molo timai manowoi muwoi, wosu woso manoki. ");
INSERT INTO amm_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Yolusolimo nokonu siyolimai mi fou fouko siki mo, Yuto noko sisiyoliyo ikoliyalokino, iyamoki, “Noko no no, to no moiso woi?” ");
INSERT INTO amm_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Noko nokolalo molopoi ukouniyaikokaiki. Wosu woso imo lukasalo liyaikino, Isiso monoi aino imo. Siyaiyo iyamoki, “Noko itouniyaimo.” Siyaiyo wiyou iyamoki, nokoso ifoluwaikowo. ");
INSERT INTO amm_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Noko nokolaloni molo timai lukasowoi muwoi, wosu woso imo saso lukasokino. Yuto noko sisiyoli monoi nikokino, no monoi no. ");
INSERT INTO amm_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Mi fou fouko si manoki, ulo ulo. Ulo siyai mo amai. Nomai no mo Isiso mo lotu nu siyoliso na amiyoki, na aiyoloka tiki. ");
INSERT INTO amm_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yuto noko sisiyoli, toi mo mulumoloko manokino, na iyamoki, “Moloi woi? Sai siyoli no moloi tosaino? Nokoyo aiyolomowoi muwoi.” ");
INSERT INTO amm_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Nosai no mo; Isiso mo na ikoki, “Ni mo asani imo muwoi, Kotoni imo taiyolokomonukuwo. Na imono taikiyoki, “Yani imo pa aiyoloka kono.” ");
INSERT INTO amm_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Noko mo Kotoni muluso aluwai monoi yakimo, yani imo mani, sainoimo. Yani muluyosu poimo taiyolokomonukuwo, o, Kotoni imo poimo. ");
INSERT INTO amm_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Noko mo totani muluyosu imo lukasalo mo, to mo tota amu siyoloso kaluwai saso. Nokosu mo imo taikiyo nokotani siyolo kaluwaiyalo mo, to mo nonani nokotani muluyosu imo lukaso, ifoluwaikomalowoi muwoi, motu imo saso imo lukaso. ");
INSERT INTO amm_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Musi mo aniyopa imo ami na yomukaiki. Ulai hani monoi pa tukwai itouniyaimonuwoso? Kwai itouniyaimo nokota no yapoli poimo. Woi, yapoli muwoi. Asasu no ulai hani monoi tuwomononuwo, aniyopa imo kwai somiso foli monoi? Tukolomono mulu monoi no hani monoi tiyonuwo?” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ulai imokino, ukouniyaiko noko nokolaloyo, “Nono tukolo monoi mulu no noiwo nokoyo tiyono? Nono mo kwalu kwalu mulu na. Popuwayo na tuwokaini.” ");
INSERT INTO amm_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ulai ikoki, “Mi fou fouko ulomai mo mulu ifolaluwawoi mi siya saso ya anoki. Hani monoi tomulumoloko manonuwo? ");
INSERT INTO amm_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Nuwoi siya moi mani, nokokai alaloni au tuno na totokosonasiko manonuwo, mi fou fouko ulo ulomai mo. Ulai afonimaiso? Musiyo na yomukaiki, au tuno tokosonasiko monoi, Kotoso muwokokainoni monoi. Musiyo pakoso yomukiso. Aniyopatono iyaliyosu na iyamokaiki. ");
INSERT INTO amm_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Musini imo kulali mo wiyou tiyamonuwo, no monoi no nuwoi siya totokosonasiko manonuwo, mi fou fouko ulo ulomai. Ulai hani monoi mulu tatolokomo unumononuwo? Yo mani, mi itouniyaimo anoki, mi fou fouko ulomai. Nokoni au na itouniyaimokaiki. ");
INSERT INTO amm_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Noiyo kwailuwaikalo manoiwo, afonimaiso noiyo iyamoiwo, “Kwaimo muwoi, koiyau.” Iyamakinuwomo, imo motu saso pa iyamowo. Hani mo kwaimo somiso mo, na pa iyamowo, koiyau na. Hani mo itouniyaimo mo, na pa iyamowo, itouniyaimo na.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Nosai no mo; Yolusolimo noko nokolalo siyaiyo ikuwanalokino, “Oi, ni mo noko poimo, noko sisiyoliyo tukolo monoi no tiyono no. ");
INSERT INTO amm_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ulai na pokiwo. Noko nokolaloni molo timai imo tolukaso tolo, woi. Ulai nokotalo iyaliyo ufiyaimowoi muwoi? Nakomo iyamokaiki, to mo Kolaisowo, Kotoyo no muwokaiki no, Isolilo noko moi fasimoka tumo monoi. ");
INSERT INTO amm_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ulai moloi woi? Tani asiya asi koi mo sai. Kolaiso totayosu tumakimo, moisai poi tumoi, ulai moi no sai?” Aino na ikuwanokino, Yolusolimo noko nokolaloyo. ");
INSERT INTO amm_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Nosai no mo; Isiso mo siyoliso na ikoki, “A, moi no sai, yo no noi?” Lotu nu siyoliso aiyolokomai Isiso mo siyoliso na ikoki, “A, moi no sai, yo no noi? Moiyo tiyamonuwo, yani asiya asi moi mo saiwo. Yo mo niya totolokaino, ulai yani muluyo muwoi. Imo motu folo kiyo nokotayo na imono taikiyoki. Moisu mo tota monoi mo sai muwoi. ");
INSERT INTO amm_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Asasu mo sai. Yo mo tani ausai amukonoki. Na imono taikiyoki.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ikoki mo; nosai no mo; louwa kominalomanokino, nokoyo. Ulai moloi komi monoi? Kominalomano ulo mo amai toi. ");
INSERT INTO amm_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Ulai noko nokolalo siyaiyo na mulumolo luwaikino. Iyamoki, “Noko siyayo pamukono mo, Isisoni mi no moloi souwai monoi? Mulu ifolaluwawoi mi na tanalomoi, moini molo timai. Noko siyayo no moloi souwai monoi? Koi tiyamonoki, Isiso mo Kolaiso nali.” ");
INSERT INTO amm_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Aino iyamoki, noko nokolaloyo, Isiso monoi aino imo, wosu woso. Falisi moloso aluwai noko mo nonani imofaso kwaikino mo, polimano iyaliso iko taikiyokino, “Na pokomi kausiyanowo, ukou.” Falisi moloso aluwai nokowoi lotu samukuko noko sisiyoliwoi, toi mo polimano iyaliso iko taikiyokino, “Na pokomi kausiyanowo.” ");
INSERT INTO amm_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ulai Isiso mo na ikoki, “Yo mo fokufaso totolo tomasimonukuwo, nosai no ifou manoimo, imono taikiyo nokotani auso. ");
INSERT INTO amm_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Louwa ikolimonaloinuwomo, ulai pa kimonoinuwoso. Yani auso no moloi ti monoi, moi no?” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Nosai no mo; Yuto noko sisiyoli mo ikuwanokino, “Moloi monoi imoko, “Louwa ikolimonaloinuwomo.” Moiso manoimo, woi? Koliko nokoni asiso poimo, moini Yuto noko siyaiyo no tosi liyai no. Nakomo Koliko nokoso poi aiyolokanoi, noko nokonu nokoso. ");
INSERT INTO amm_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Moloi imoko monoi, “Louwa ikolimonaloinuwomo, ulai pa kimonoinuwoso. Yani auso no moloi nu monoi, moi no?” Aino imoko. Ulai imo folosai no moloi woi?” ");
INSERT INTO amm_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Nosai no mo; mi fou fouko popo mo aumoifaso uwai; ulo topimo, wasi popo ulo siyoli. Nomai no mo, Isiso mo na tolauki, imo siyoliso na lukasiko toloki, siyokawi imo na ikoki, “Noko mo iwo nukuwa uwoyakimo, asani auso sika tumumo. ");
INSERT INTO amm_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Noko mo mulumolo luwaimonakimo, tani mulusai mo iwo sisiyoli komiyai na tumoimo, aniyopa poi poi yousi itouniyaimo manoimo. Kotoni puko imoyo aino tiyomuko.” ");
INSERT INTO amm_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Isiso mo iwa iwo monoi pa ikokiso, Kotoni Mulu Itouniyaimo Nokota monoi na ikoki. Nonani nokotaso imo taikiyowoi muwoi, mulumolo luwai noko nokolaloni auso, amai. Isiso mo Kotoyo kawiyo yowoi muwoi, amai, no monoi no Kotoni Mulu Itouniyaimo Nokotaso imo taikiyowoi muwoi, amai na. ");
INSERT INTO amm_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Nosai no mo; Isisoni imo kwaikino mo; noko nokolalo siyaiyo iyamoki, “To mo Kotoni mulu lukasiko nokota siyoli, koi no tofoumo sinoki no.” ");
INSERT INTO amm_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Siyaiyo iyamoki, “To mo Kolaiso, noko no mo Kotoyo no muwokaiki no, moi fasimoka tumo monoi.” Ulai siyaiyo iyamoki, “Kolaiso muwoi. Kolaiso no Kalili asisai no moloi tumo monoi? ");
INSERT INTO amm_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kotoni puko imoyo na tiyomuko, noino, “Kolaiso, Kotoyo muwokai nokota, to mo Toiwi siyolini alisai auwoniyouwoimo, Pitolifimo nokonusai, Toiwini aniyopa nukutaisai.” ");
INSERT INTO amm_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","No monoi no noko nokolalo mo mulu mo tomoso muwoi, mulu fofamo na. ");
INSERT INTO amm_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Siyaiyo kominalomano monoi yokino. Ulai moloi komi monoi? ");
INSERT INTO amm_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Nosai no mo; polimano noko iyali mo noko sisiyolini auso ifou nuki, lotu samukuko noko sisiyoliwoi Falisi moloso aluwai nokowoi, totaini auso. Na ikokino, noko sisiyoliyo mo, “Hani monoi pa tokomi kawiyo tumonuwoso?” ");
INSERT INTO amm_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ulai polimano iyaliyo, “Wiyouwa wiyou, tani imo mo itouniyaimo saso. Noko siyayo aino lukasowoi muwoi, toku ainoso lolai.” ");
INSERT INTO amm_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Nosai no mo; Falisi moloso aluwai noko mo na ikokino, “Nakomo moi mani, na ifoluwainuwo, no monoi no tani imo mo na kwaimonuwo. ");
INSERT INTO amm_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Nokotalo iyali koi no ulai tomulumolo luwainoki? Falisi moloso aluwai noko no ulai tomulumolo luwaino? ");
INSERT INTO amm_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Wiyouwa wiyou, aino muwoi. Afonimai nokoyosu tomulumolo luwaino, sai somiso nokoyo. Musini imo ami mo sai muwoi, na uwokaikoimo.” ");
INSERT INTO amm_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikotimo, Falisi moloso aluwai nokota toku Isisoso no kiyanoki no, to mo na ikoki, siyokutono iyaliso, ");
INSERT INTO amm_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Hani foli monoi tuwonuwo? Moini aniyopa Musini imo amiyo tiyomuko, “Afonimaiso noiyo uwoyoiwo.” No monoi no tani imoso toku na pukwaimowo.” ");
INSERT INTO amm_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","53","Ulai alisiyolikino, “A, nono mani, Kalili nokota na? A, siyokunoso tofasini? Kotoni puko imoso na pokokalo, saino itouniyaimo monoi. Kotoni mulu lukasiko nokota no Kalili asisai no moloi auwono monoi?” Aino imokino, Falisi moloso aluwai noko mo. ");
INSERT INTO amm_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Nosai no mo; kiwawinokino, nuso nu liyaiki. Isiso totaso mo Oli yuso amiyoki. ");
INSERT INTO amm_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Nosai no mo; posasimai; lotu nu siyoliso ifou amukonoki. Noko nokolalo molopoi ukouniyaikokukino. Yousa konoki, na aiyolokoki. ");
INSERT INTO amm_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Nosai no mo; kosoko nukonu mo na kausiyo tikino, noko sisiyoli mo. Musini imo aiyoloko nokowoi Falisi moloso aluwai nokowoi toi mo kosoko nukonu mo Isisoni auso na kausiyo tikino, noko nokolaloni molo timai. ");
INSERT INTO amm_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Nosai no Isisoso na imokino, “Aiyolokomomoko nokota, nokoyo kosokomai kwaisono, no monoi no tokausiyo tumonoki. ");
INSERT INTO amm_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Musini imo amiyo tiyomuko, noino, “Kosoko nokolalo tomoki na pa salosokowo, yau yau.” Nonayo no moloi tiyomuni?” ");
INSERT INTO amm_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Isisoso mo aino na imokino, tani imo kwailuwai monoi. Tani imo foli monoi faumiko monoi yokino, no monoi no. Ulai Isiso mo fowakowoi muwoi, lolomi tanoki, asiso kumoki, naino muwoyo. ");
INSERT INTO amm_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ulai imalo manokino mo, na tolauki, na ikoki, “Molo koiyauso aluwai somiso nokota tolo mo, totayosu mo tomoki toku afolisu.” Aino na ikoki, ");
INSERT INTO amm_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ulai ti monoi lolomi tanoki, asiso kumoki. ");
INSERT INTO amm_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","No monoi no mo, imo mo kwaimokino mo, na utukaimalokino. Toku mo nokotalo iyali utukaimalokino. Nosai no noko komaso utukaimalokino, siyasonuso, ainoso hani Isiso saso amai toloki, nonini auso. ");
INSERT INTO amm_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Nosai no mo; Isiso mo tolauki, na isoki, “Woli, noko sisiyoli no moiso? A, imo no futo, pa tuwokainiso?” ");
INSERT INTO amm_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Na imoki, “Nasu, na utukaimonono.” Isiso mo, “Yo mani, imo mo futo. Na pomoi, ulai molo koiyauso ti monoi noiyo aluwaiyoi.” ");
INSERT INTO amm_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Nosai no mo; noko nokolaloso ulai ikoki, Isiso mo, “Yo mo saponi komiyai, asi asi noko nokolaloso na tofupiniyaimo koloko. Noko mo aluwaimonakimo, folosumai pa liyai manoiso, saponi moloso na aluwai manoimo, aniyopa poi poi.” ");
INSERT INTO amm_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ulai Falisi moloso aluwai nokoyo imokino, “Topokoni, nona amu monoi tiyomuni. Koi no moloi kwai monoi?” ");
INSERT INTO amm_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Nosai no mo; Isiso mo na ikoki, “A, topoko noiyo. Motu na. Asa amu monoi tiyomu, motu na. Na pukwaimono itouniyaimowo. Ulai afonimaiso? Yo mo sai, yani asiya asi mo. Moisu mo sai muwoi. Asi no manaki no, yo mo sai. Moisu mo sai muwoi. No monoi no yani imo na pukwaimonowo. ");
INSERT INTO amm_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Moi mo asini moloso aluwai noko na, no monoi no afonimaiso tiyamonuwo, noino, “Kwaimo muwoi, koiyau.” Yo mo afonimaiso pa tiyomukaiso. ");
INSERT INTO amm_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ulai nokoni molo koiyau foli monoi ya yomukai mo, yani imo mo motu yomukai. Ulai afonimaiso? Asani muluyo saso yomukaiwoi muwoi. Apou Siyoli no imono taikiyoki no, to mo na totolo fasimono. ");
INSERT INTO amm_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Moini aniyopa imoyo tiyomuko, noino, “Noko tiyo mulu tomoso yomukaiyakinomo, noko sisiyoliyo na kwaikowumo.” ");
INSERT INTO amm_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Apou koti mo noinoso na. Yo mo asa amu monoi tiyomukai. Apou Siyoli no imono taikiyoki no, to mo tiyomu fasimono.” Aino ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Nosai no mo imokino, “Apono no moiso?” Fowakoki, “Moi mo sai muwoi, asa monoi. Yani Apou monoi mani, moi mo sosoli. Asa monoi posainonuwo mo, yani Apou monoi mani, posainonuwo.” ");
INSERT INTO amm_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Aino na ikoki, lotu nu siyolimai aiyolokomai, Kotoni mi muwoni isikokaimosi pokilimai. Ulai nokoyo pa kominalomanokinoso. To kominalomano ulo mo amai, no monoi no. ");
INSERT INTO amm_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Nosai no mo; ti monoi na ikoki, Isiso mo, “Yo mo manoimo, na louwa ikolimonaloinuwomo. Yani auso no moloi ti monoi, moi no? Na kolikali kaiyoinuwomo, molo koiyauso aluwaimai.” ");
INSERT INTO amm_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","No monoi no mo, Yuto noko sisiyoliyo ikuwanokino, “Moloi woi? Moloi monoi imoko, “Yani auso no moloi ti monoi, moi no?” A, tota amu poi tukoloi?” ");
INSERT INTO amm_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ulai iko manoki, Isiso mo, na ikoki, “Moini asi kiyo mo asimai. Yani asi kiyo mo puwoso nali. Moi mo asimai tosinononuwo. Asa mo asimai pa tolokainoiso. ");
INSERT INTO amm_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Yasoi timonukuwo, moi kolikali imo mo. Kolikali kaiyoinuwomo, molo koiyauso aluwaimai. Ulai afonimaiso? Amai tolokaino nokota yoso mulumolo luwaimono somiso mo, na kolikali kaiyoinuwomo. Nasu, molo koiyau aluwaimai na kolikaliyoinuwomo.” ");
INSERT INTO amm_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ulai toiyo, “A, nono no noi?” Isiso mo, “Yo mo ninani nokota na, toku no imokinukuwo no. ");
INSERT INTO amm_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Yo mo momaini molo koiyau foli monoi yomu unalo monoi louwa. Ulai motuwa nokota no imono taikiyoki no, totani imo saso na timo manonukuwo, asi asi noko nokolalo moiso.” ");
INSERT INTO amm_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Aino ikoki. Ulai toi mo sai muwoi, totani Apitono Siyoli monoi yomu unuki mo. Toi mo sosoli. ");
INSERT INTO amm_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","No monoi no mo na ikoki, “Yoi, asi asi noko nokolaloni noko siyoli nokota yo mo a mokiso akaimona yakinuwomo, na sainoinuwomo, amai tolokaino nokota yo mo. Na sainoinuwomo, yo mo asani muluyoso pa yoiso. Apou Siyoliyo no aiyolomomonoki no, nonani imo saso na timonukuwo. ");
INSERT INTO amm_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Na imono taikiyoki, to mo. Yo mo awi alu muwoi, na totolo fasimono. Ulai afonimaiso? Tani muluyosu ya tiyomoi. Mulu mo waliyo, yo monoi mo.” Aino ikoki. ");
INSERT INTO amm_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Iko manoki mo, noko molopoi mulumolo luwaikino, lolaloso. ");
INSERT INTO amm_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Nosai no mo; Isiso mo Yuto nokoso ikoki, lolaloso mulumolo luwai nokoso, na ikoki, “Yani imo kwai manakinuwomo, yani woliya woli iyali, moi mo. ");
INSERT INTO amm_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","No monoi no Kota Koto monoi sainoinuwomo, motuwa motu monoi. Sainakinuwomo, noko koiyau monoi samiyaikiyoinuwomo.” ");
INSERT INTO amm_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ulai toiyo, “Hani monoi samiyaikiyo monoi timokoni? Noko koiyau no noi woi? Noko nokonu nokotani mi foloko mi pa tanoti manonokiso? Koi mo Apolofamoni alisai nali no.” ");
INSERT INTO amm_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ulai ikoki, Isiso mo, “Motuwa na timonukuwo. Molo koiyauso aluwai nokota mo samiyaikiyowoi muwoi, noko koiyauni nainomai na tiyousi. ");
INSERT INTO amm_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Noko koiyauni nainomai yousi mo, aniyopa poi poi no moloi yousi itouniyaimo monoi? Noko mo apitononi nainomai yousi mo, aniyopa poi poi na yousikaino, apitononi nainomai. ");
INSERT INTO amm_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Kotoni awitono asayo noinomo samiyaikiyakinuwomo, na samiyaikiyo manoinuwomo, aniyopa poi poi.” ");
INSERT INTO amm_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Iko manoki mo, na ikoki, “Yo mo sai, moi mo Apolofamoni alisai na. Ulai yani imo tokulalinuwo, tukolomono mulu na tiyonuwo. ");
INSERT INTO amm_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Yani Apouni auso ya no kokoki no, nonani hani monoi na timonukuwo. Moiyosu mo moini apononi imoso taluwai manonuwo.” Isiso mo aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ulai Isisoso na imokino, “Koi mo Apolofamoni alisai nali no.” Ulai Isisoyo, “Apolofamoni aliya alisai posinuwo mo, Apolofamoni moloso paluwainuwo. ");
INSERT INTO amm_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ulai tukolomono mulu na tiyonuwo. Hani monoi woi? Motu imo saso timonukuwo, imo motu Kotoyo no imonoki no. Hani monoi tukolomono mulu tiyonuwo? No mo Apolofamoni molo muwoi. ");
INSERT INTO amm_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Momaini apononi moloso taluwainuwo.” Ulai toiyo, “Koi mo uloliyo ali iyali muwoi. Koto tota saso mo koini Apou nali.” ");
INSERT INTO amm_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Nosai no mo; Isiso mo na ikoki, “Koto mo moini apono mo, yo monoi mani, mulu punumononuwo. Yo mo Kotoni ausai amukonoki, isoi tolokaina konoki. Asani muluyo pa amukonokiso, totayosu mo na imono taikiyoki. ");
INSERT INTO amm_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Hani monoi pa tosainonuwoso, yani imo no? Moi mo iyo mo uku, no monoi no. ");
INSERT INTO amm_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Apono mo Sokolo Nokota Wai, totani alalo, moi mo. Totani muluso na taluwai manonuwo. Noko tukuwoli nokota, to mo, tokusai ainoso lolai. Imo motu muluwoi muwoi, imo motu pa tolukasomoiso. Nokoso ifoluwaikalo imo mo tani ima imo na. Ulai afonimaiso? Noko ifoluwaikalo nokota siyoli na. Wiyouwa wiyou, noko ifoluwaiko noko komaso nokoni apitono na. ");
INSERT INTO amm_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Asasu mo motu imo na timonukuwo. No monoi no pa tukwaimononuwoso. ");
INSERT INTO amm_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Moi nokotayo no molo koiyau foli monoi no moloi yomu unumono monoi? Yo mo pa taluwaimoiso. Yo mo motu imo saso na timonukuwo. Hani monoi pa tukwaimononuwoso? ");
INSERT INTO amm_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Moi mo Kotoni noko nokolalo muwoi, no monoi no tani imo pa tukwainuwoso. Kotoni noko nokolalo mo tani imo na tukwai itouniyaimono.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Nosai no mo; Yuto noko mo alisiyolikino, imokino, “Somaliya nokota wai nono mo, kwalu kwalu mulu na. Popuwayo na tuwokaini. Nonayo na piyomu.” ");
INSERT INTO amm_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ulai na ikoki, “Popuwayo noiyo. Yo mo asani Apou auwosisimowoi muwoi, na tokisosomi. Moisu mo pa tokisosomimononuwoso, na tauwosisimomononuwo. ");
INSERT INTO amm_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Yo mo asa amu siyoloso pa tokaluwaiyaloso. Yani siyolo kaluwaimono nokota siya mo na tolo. Alisiyolimono foli monoi na uwokomoinuwomo. ");
INSERT INTO amm_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Motuwa na timonukuwo. Noko mo yani imoso aluwaiyakimo, pa kalokaiyoiso.” ");
INSERT INTO amm_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","“Topokoni.” Yuto noko mo imokino, “Topokoni. Wiyouwa wiyou, nono mo kwalu kwalu mulu na, popuwayo na tuwoni. Apolofamo mo na kaloki, yau. Kotoni mulu lukasiko noko iyali mani, na kolikaliki, yau yau. Ulai hani monoi tiyomuni, “Noko mo yani imoso aluwaiyakimo, pa kalokaiyoiso.” ");
INSERT INTO amm_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","A, aniyopa Apolofamoso no tosouwaini? To mo na kaloki, yau. Kotoni mulu lukasiko noko mani, na kolikaliki, yau yau. A, nona amu monoi tiyomuni, noko siyoliwo.” Ainoso na imokino. ");
INSERT INTO amm_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Nosai no mo; Isiso mo na ikoki, “Asa amu siyoloso kaluwaiyakimo, afonimaiso na yomoimo. Ulai yo muwoi, yani Apousu mo yani siyoloso na tokaluwaimono. Yani siyolo kaluwaimono nokota tota monoi tiyamo ununuwo, “Koini Koto na.” ");
INSERT INTO amm_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Moi mo to monoi mo sai muwoi. Asasu mo sai. Yo piyomu mo, “Yo mo sai muwoi,” pifoluwaikomonukuwo, moi komiyai potolo. Ulai yo mo sai, tani imoso na tukwai itouniyaimomoi. ");
INSERT INTO amm_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Moini aniyopano Apolofamo, to mo yo amukonoso kwaimono monoi mulu mo siyoli. Ulukukumo siyoli. Yo amukonoso na kwaimonoki, na molokiki, to mo.” ");
INSERT INTO amm_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ulai Yuto noko sisiyoliyo, “Apolofamo no moloi ki monoi, nono no? Nono mo autano saso, aisamu 50 mo souwaikowoi muwoi, amai.” ");
INSERT INTO amm_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Nosai no mo; Isiso mo na ikoki, “Motuwa na timonukuwo. Atinoyo Apolofamo mo kiwoi muwoi, yo mo na tolokainoki.” ");
INSERT INTO amm_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Aino no ikoki mo; tomoki ifoloko unukino, tukolo monoi louwa fi. Ulai na kukalokoki, lotu nu siyolisai lofuki. ");
INSERT INTO amm_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Nosai no mo; Isiso iyali mo moloso monoi nu liyaiki, molo kau kau nokotaso na kiya tumokino, atinoni nomoliwoisai molo kau kauso no kiki no. ");
INSERT INTO amm_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Isisoso imokino, siyokutono iyaliyo, “Oi, aiyolokomomoko nokota, ulai moloi monoi nokoni molo no kau kau no? Hani foli monoi? Totayo molo koiyauso aluwai foli monoi poimo, atino apitono noko tiyo molo koiyauso aluwai foli monoi poimo.” ");
INSERT INTO amm_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ulai Isiso mo na ikoki, “Yoi, molo koiyauso aluwai foli monoi muwoi. Totayo molo koiyauso aluwai foli monoi muwoi. Atino apitono noko ti mani, totiyo molo koiyauso aluwai foli monoi muwoi, Kotoni ami wiyoti monoi na, no monoi no molo kau kau auwonoki, Kotoyo itouniyaimokai wiyoti monoi. ");
INSERT INTO amm_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Saponimai mo Kotoni mi mo niya tano manokoni, yo no imono taikiyoki no, tani mi mo. Folosu mo na tumoimo. Folosumonomai no moloi ano monoi? ");
INSERT INTO amm_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Asiso ni tolomai yo mo saponi komiyai, na tofupiniyaimo koloko tolo, asi asi noko nokolaloso.” ");
INSERT INTO amm_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Ikoki mo; asiso na aso koloki. Usuwoyo asifawoi fofuwonoki, kupokoki, molo kau kau nokotani molo tiso na louwokomoki. ");
INSERT INTO amm_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Na imoki, “Na pomoi, iwo poloukano, Silowamo iwo toku iwofaso.” Silowamo imo folosai mo Kiyotaikiyo. No monoi no mo, iwo na loukanoki. Ifou tumoki mo, waliyo na foinalikoki. ");
INSERT INTO amm_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Nosai no mo; nokoyo kiya tumokino mo, ikuwanokino, “Foinaliko no moloi woi?” Molo kau kau nokota no mo, to mo muwoni monoi toku putolukomosiki. Muwoni monoi utoluko nokotaso ki nokoyo ikuwanokino, “Moloi foinaliko, woi? A, ni no muwoni monoi utoluko yousi nokota na?” Asi tomoso noko mani, imo tomoso na iyamoki. ");
INSERT INTO amm_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Siyaiyo iyamoki, “Nasu.” Siyaiyo iyamoki, “To muwoi, amu molo mo tomoso saso.” Ulai totayosu mo yomuki, “Asasu nali, yo mo muwoni utoluko nokota nali.” ");
INSERT INTO amm_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Imokino, “Ulai moloi foinalikoni?” ");
INSERT INTO amm_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Na fowakoki, “Noko no mo, tani siyolo mo Isiso, to mo asiwoi usuwowoi fofuwono, yani molo ti louwokomomono, imono, “Iwo poloukano, Silowamo iwo toku iwofaso. No monoi no iwo loukano. Louko uwai; na foinaliko, yo mo.” ");
INSERT INTO amm_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Imokino, “Nonani nokota no moiso?” Ulai totayo, “Ulai yo no sai?” ");
INSERT INTO amm_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Nosai no mo; toku molo kaukomokai nokota kawiyo tumokino, Falisi moloso aluwai nokoni auso. ");
INSERT INTO amm_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Mi fou fouko ulomai mo asiwoi usuwowoi fofuwonoki, molo kau kau nokota itouniyaimokaiki. Mi mo au, mi fou fouko ulomai mo. ");
INSERT INTO amm_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","No monoi no mo, Falisi moloso aluwai noko mani, na imokino, “Moloi foinalikoni?” Ikoki, “Noko mo molo tiso asi topamuyo akaikomomonoki. Asi topamu akaikomomonoki mo; yo mo iwoso loukanoki, nosai no na foinalikoki.” Aino ikoki, toku molo kaukomokai nokota mo. ");
INSERT INTO amm_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ulai iyamoki, Falisi moloso aluwai noko siyaiyo iyamoki, “Noko ni mo, to mo mi fou fouko ulomaisu mo mi tano. Koto no moloi imo taikiyo, woi?” Piyamoki, molo koiyau nokotawo. Siyaiyosu iyamoki, “A, molo koiyau nokota no mulu ifolaluwawoi mi no moloi analo mano monoi?” No monoi no mulu tomoso muwoi, mulu mo fofamo na. ");
INSERT INTO amm_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ulai ti monoi imokino, toku molo kaukomokai nokotaso na imokino, “Nani molo ti itouniyaimokai nokota monoi no moloi tiyomuni?” Na ikoki, “Kotoni mulu lukasiko nokota nali, to mo.” ");
INSERT INTO amm_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Ulai Yuto noko sisiyoli mo piyamoki, “Molo kau kau pa itouniyaimokaisowo, tokusai foinalikowo.” Na mulumoloko manokino, noko siyaso imo taikiyokino, “Atino apitono noko tiso pikano, tumowumo.” ");
INSERT INTO amm_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Tumokino mo; nosai no totiso na ikokino, “A, ni no motini aununo? Atinoni nomolisai molo kau kau, o? Motiyo na piyomuwo. Atinoni nomolisai molo kau kau uwo mo, lolai no moloi tofoinaliko? Na piyomuwo.” ");
INSERT INTO amm_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Toti mo na fowakokino, “Kotini alu nali. Molo kau kau nali tumo, atinoni nomolisai. ");
INSERT INTO amm_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Lolai no moloi foinaliko, woi, ulai koti no sai? Noiyo poimo itouniyaimokai, ulai koti no sai? Totaso na pimowo. To mo siyoli yasoi. Totayosu mo na imoinuwomo.” ");
INSERT INTO amm_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Atino apitono noko ti mo aino ikokino, kokoloko monoi. Yuto noko sisiyoli monoi nikokino. Ulai afonimaiso? Imo toku yasoi lukasokaikino, Isisoso mulumolo luwai nokoso alukiko monoi. Imo toku yasoi lukasokaikino, noino, “Noko mo noko nokolaloni molo timai yomakimo, “Isiso mo Kotoyo muwokai nokota Kolaiso,” aino yomakimo, ulai lotu nufaso no ti monoi no hani monoi tumo monoi?” Aino toku yasoi lukasokaikino, Yuto noko sisiyoli mo. ");
INSERT INTO amm_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","No monoi no atino apitono noko ti mo kokolokoki, na ikokino, “Kotini alu mo siyoli yasoi, totaso na pimowo.” ");
INSERT INTO amm_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Nosai no mo; toku molo kaukomokai nokotaso ti monoi aliyonikino, na imokino, “Nonoso itouniyaimokai nokota mo molo koiyauso aluwai nokota na. Koi mo sai. Nonayo piyomu. Koto Siyoli mo sai.” ");
INSERT INTO amm_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ulai totayo, “Molo koiyauso aluwai nokota poimo, ulai yo no sai? Siya hani saso yo mo sai. Toku mo yo mo molo kau kau, ulai lolai mo na tofoinaliko.” ");
INSERT INTO amm_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Nosai no mo imokino, “Moloi uwokini? Moloi itouniyaimokaikini?” ");
INSERT INTO amm_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ulai toku molo kaukomokai nokota mo ikoki, “Yasoi imonukuwo. A, iyo no uku, a? Ti monoi imo no hani monoi? A, moi mani, tani moloso aluwai mulu tiyonuwo?” Aino ikoki, Yuto noko sisiyoliso. ");
INSERT INTO amm_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Nosai no mo; na alisiyoliyalokino, imokino, “Nonayosu mo noko waini moloso taluwaini. Kokai mo Musini moloso na taluwai manonoki. ");
INSERT INTO amm_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Noko wai no no, to no moisai tumo, woi, ulai koi no sai. Noiyo poimo imo taikiyoki. Musi monoi koi mo sai, Kotoyo na imo taikiyoki.” ");
INSERT INTO amm_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Toku molo kaukomokai nokota mo na ikoki, “Ulai moloi monoi woi? Yani molo ti na itouniyaimomono kaiki. Ulai hani monoi pa tosainonuwoso, tumo monoi no? ");
INSERT INTO amm_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Moi mo sai. Koto mo molo koiyauso aluwai nokoni imoso kwaikowoi muwoi. Totani molo aluwai nokotasosu tukwaimo, na tofasi. ");
INSERT INTO amm_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Tokusai ainoso lolai, molo kau kau itouniyaimokai aino imo pakoso kwai manokikoniso, atinoni nomolisai molo kau kau itouniyaimokai nokota aino imo. ");
INSERT INTO amm_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Itouniyaimomono nokota mo Kotoyo imo taikiyo somiso mo, pa pitouniyaimomono kaiso.” Toku molo kaukomokai nokota mo aino na ikoki, Yuto noko sisiyoliso. ");
INSERT INTO amm_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Nosai no mo; uo imo imokino, “Molo koiyau nokota nali, nono mo. Anonini nomolisai molo koiyauso taluwai manoni. Hani monoi louwa taiyolokomomokoni?” Imokino mo; na usainiyaimokino. ");
INSERT INTO amm_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Nosai no mo; Isisoni auso imofa kolo koloma tumoki, toku molo kaukomokai nokota usainiyaimokino mo. Imofa kolo koloma tumoki mo; Isiso mo na ikoliyaloki. Kiya tumoki mo, na imoki, tota amu monoi yomuki, “Asi asi noko nokolaloni noko siyoli nokotaso no yapoli tomulumolo luwaini?” ");
INSERT INTO amm_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ulai totayo, “Noko Siyoli, to no noi, woi? Na pimono, yo mo na mulumolo luwaiyoimo.” ");
INSERT INTO amm_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Nosai no mo; Isiso mo na imoki, “Yasoi na tokimononi. No timonoki no, asasu mo nonani nokota nali.” ");
INSERT INTO amm_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nonani nokotayo mo na imoki, “Noko Siyoli, yo tomulumolo luwainoki.” Ainoso na imoki, alokomu losiyaiko unuki, na molokimoki. ");
INSERT INTO amm_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Nosai no mo; Isiso mo siyokawi imo na yomuki, noino, “Noko nokolalo wau monoi ya amukonoki, asiso. No monoi no molo kau kau noko mo na foinalikoinomo. Foinaliko noko, toi mo molo kau kau noko komiyai soimo, haniso pa kiyoinoso.” Ainoso na yomuki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Nosai no mo; Falisi moloso aluwai noko siyai, tani auso no siki no, toi mo imokino, “A, molo kau kau no noiwo? A, koi mani, molo kau kau na tokimokoni?” ");
INSERT INTO amm_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ulai ikoki, “Moi mo molo kau kau posinuwo mo, molo koiyau foli monoi pa puwokomonuwoso. Ulai na tiyamonuwo, “Koi mo molo kau kau noko muwoi, folosumai pa toliyainokiso.” Aino tiyamonuwo. Ulai folosu moloso na taluwai manonuwo. No monoi no folosu molo aluwai foli monoi na uwoyoinuwomo.” Isiso mo aino na ikoki, Falisi moloso aluwai nokoso. ");
INSERT INTO amm_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Nosai no mo; Isiso mo na ikoki, siyokawi imo mo, “Motuwa na timonukuwo. Nokoyo sipo kokiko uku itu lotiso loti somiso mo, to mo polamoko nokota nali. Sipo koki wosokiko nokota mo uowoi nali. ");
INSERT INTO amm_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Itu lotiso loti nokota mo sipo iyali samukuko nokota. ");
INSERT INTO amm_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Nonani nokota mo totumo mo, itu loti samuku nokotayo na tokolali unu. Koki poiso na toloti. Tani ko naso na tukwaimo itouniyaimono, sipo iyaliyo mo. Siyolo siyolo na tokolalalo, na tokoliyo fu, totani sipo mo. ");
INSERT INTO amm_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Koliyo fu uwai; na taluwainiyo tumono. Totani sipo mo totani imoso tukwaimono. Toi mo tani ko na mo sai, no monoi no taluwaino. ");
INSERT INTO amm_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Noko siyayo tumakimo, pa aluwaiyoinoso, na uloloimo. Tani ko na mo sai muwoi, no monoi no.” ");
INSERT INTO amm_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Siyokawi imo mo ainoso na ikoki, Isiso mo. Ulai toi mo ima imo mo sai muwoi. Toi mo sosoli. ");
INSERT INTO amm_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","No monoi no mo, Isiso mo ulai na ikoki, “Motuwa na timonukuwo. Asa mo sipo kokiko uku itu loti komiyai. ");
INSERT INTO amm_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Noko mo asa monoi toku no ti liyaiki no, toi komaso mo polamoko noko na, uo noko nali. Sipo iyali mo toini imoso kwaikowoi muwoi. ");
INSERT INTO amm_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Asa mo itu loti komiyai. Noko mo asani itu lotiso lotakimo, na samiyaikiyoimo. Ifou ifou amufu liyaiyoimo. Tiyawoi muwoi, nowoi nali no. ");
INSERT INTO amm_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Polamoko noko iyali monoi moi mo sai, topolamoka tumomosino. Sipo tukuwoli noko na, na tuwokaika tumomosino. Asasu mo fasika konoki. Ya noinomo sinono koiyaumowoi muwoi, na si itouniyaimo manoimo, aniyopa poi poi. ");
INSERT INTO amm_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Asa mo sipo samukuko nokota itouniyaimo komiyai. Sipo fasiko foli monoi nokoyo tukolomonakinomo, yo mo imowoi muwoi, waliyo. ");
INSERT INTO amm_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Noko mo noko siyani sipo samukuko mo, to mo sipo kiyo nokota muwoi. Suo foli monoi saso samukuko. Asikoiyo aluwouyo tumoso kwaiyakimo, sipo na lomu utukaikoimo. Nosai no aluwouyo sipo tukuwoliyoimo, siyai mo uloloimo. ");
INSERT INTO amm_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","To mo sipo muluwoi muwoi. Suo foli monoi saso tosamukuko. No monoi no lomuwoimo. ");
INSERT INTO amm_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Asasu mo sipo samukuko nokota itouniyaimo komiyai. Yo mo sai, asani sipo iyali monoi mo. Toi mani, yo monoi mo sai. ");
INSERT INTO amm_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","No mo noino. Apou Siyoli mo sai, yo monoi mo. Yo mani, to monoi mo sai. Sipo fasiko foli monoi tukolomonakinomo, yo mo imowoi muwoi, waliyo. ");
INSERT INTO amm_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Yo mo sipo siyai mani, yapoli na si. Kokiko ukukai siyaiso tosi liyai. Toi mani, ya kolisalomanoimo, na kiyoka tumoimo. Yani ko naso kwaimono itouniyaimoinomo. Tolomu nokowoi tomoso na ukouniyaikoimo. Asayosu mo komaso na samukuko manoimo. ");
INSERT INTO amm_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Nokoyo tukolomonakinomo, yo mo imowoi muwoi. No monoi no mo, yani Apou mo mulu tunumono. Ulai pa kalomonokaiyoiso. Yausai ifou na auwoniyouwoimo. ");
INSERT INTO amm_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Tukolomonakinomo, no mo nokoni muluyo muwoi, asani muluyosu nali. Yo mo alukiko ami mo yapoli, ulai pa alukikoiso. Yausai auwoniyou amiwoi mani, yapoli, yo mo. Ulai afonimaiso? Apouyo ainoso na imono taikiyoki.” Isiso mo ainoso na ikoki, Yuto noko sisiyoliso. ");
INSERT INTO amm_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ikoki mo; nonani imo monoi mani, mulu mo tomoso muwoi. Toi mo mulu mo fofamo, Yuto noko sisiyoli mo. ");
INSERT INTO amm_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Siyai mo piyamoki, “Kwalu kwalumowo. Popuwayo tuwokaiwo. Tani imo no moloi kwaimo monoi?” ");
INSERT INTO amm_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Siyaisu mo iyamoki, “A, popuwayo noiyo. No mo popuwayo uwokai nokotani imo muwoi. Popuwayo no molo kau kau noko no moloi ititounikai monoi?” ");
INSERT INTO amm_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Nosai no mo; fulomu popomai mo mi fou fouko popo siya fiyamosiki, Yolusolimo nokonu siyoliso. Aisamu saiso saiso mo lotu nu siyoli monoi pomolokima tumomosikino, noko nokolaloyo. ");
INSERT INTO amm_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Nonani popomai mo Isiso mo lotu nu siyolimai liyaiki, fulomu numai, nokoyo no pokaluwai manokino no, Solomononi Fulomu Nu. ");
INSERT INTO amm_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Nosai no mo; Yuto noko sisiyoli mo ukouniyaikokukino, na imokino, “Siyokawi imo saso lukaso nimoko no hani monoi? Ulai koi no sai? A, nono no Kolaiso na, Kotoyo no muwokaikini no, Isolilo noko koi fasimoka tumo monoi, a, nona na? Ima imo na pimoko.” ");
INSERT INTO amm_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Nosai no mo; Isiso mo na fowakoki, “Yasoi na imokinukuwo, ulai pa kwaimonokinuwoso. Yani Apouni amiyo mo mi tanomosi mo, no mo afonimaiso anowoi muwoi, na towiyolukomonukuwo, yo mo tota na. ");
INSERT INTO amm_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ulai momai mo yani koki poiso mo tu siwoi muwoi, no monoi no waliyo pa tomulumolo luwaimononuwoso. ");
INSERT INTO amm_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Yani sipo iyali mo yani ko naso tukwaimono itouniyaimono. Toi monoi mo yo mo sai. Na totanomomonono. ");
INSERT INTO amm_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","No monoi no uwokaikowoi muwoi. Ya noinomo aniyopa poi poi tosi itouniyaimomoi. Uo nokoyo moloi kolisa tumo monoi? Asani nainomai na tosinono. ");
INSERT INTO amm_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Yani Apouyo muwokokaimonoki. Komaso hani hani souwaiko nokotayo na muwokokaimonoki. Uo nokoyo no moloi kolisa tumo monoi? Yani Apouni nainomai na tosinono. ");
INSERT INTO amm_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Apou Siyoli koti mo tomoso na.” Ainoso na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Nosai no mo; Yuto noko mo ti monoi ifoloko unukino, tomoki mo, tukolo monoi louwa fi. ");
INSERT INTO amm_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ulai Isiso mo na ikoki, “Apou Siyoli mo na imono taikiyoki, no monoi no mi itouniyaimo ya tanalomosi, moini molo timai. A, mi itouniyaimo foli monoi tosalosomomononuwo, tomoki no?” ");
INSERT INTO amm_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ulai imokino, “Mi itouniyaimo foli monoi muwoi, Koto alisiyoli foli monoisu na tosalosomonoki. Nono mo noka nokosu. Ulai piyomuni, “Koto koti mo tomosowo.” Koto tomoso no moloi tolo monoi, nono no?” ");
INSERT INTO amm_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ulai Isiso mo, “Moini aniyopa imo ami Musiyo no kulukaiki no, no mo tiyomuko, noino, Kotoni imo mo, “Ya yomukaiki, moi mo kumoki tolomu noko sisiyoli na.” ");
INSERT INTO amm_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Koto mo ainoso yomu ukuki, noka noko monoi, moini aniyopa iyali monoi, noko no mo tani ami imo toku no ikokaikino no. Toi na kolaliki, kumoki tolomu noko sisiyoli mo. Motu na, Kotoni imo no nokoyo no moloi kulali monoi? ");
INSERT INTO amm_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ulai yo monoi no hani monoi timononuwo, Koto tomoso imo foli monoi no? No mo alisiyoli imo muwoi. Apou Siyoli mo tota monoi na muwomonokaiki. Asiso na imono taikiyoki. No monoi no ya timonukuwo, “Yo mo Kotoni awitono.” ");
INSERT INTO amm_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Yo mo yani Apouni mi ano somiso mo, noiyo mulumolo luwaimonoiwo. ");
INSERT INTO amm_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ulai Apouni mi ya anakimo, waliyo na pa mulumolokowo, nonani mi monoi mo. Yoso pa tomulumolo luwaimononuwoso. Apouni misu ya no tanomoi no, nonani mi monoi mo waliyo na pa mulumolokowo. No monoi no sainoinuwomo, Apou Siyoliyo tolo tomasimomono mo. Yo mani, tolo tomasimo.” Isiso mo aino na ikoki, Yuto noko sisiyoliso. ");
INSERT INTO amm_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Nosai no mo; ulai ti monoi louwa kominalomanokino. Ulai nainoyo moloi komi monoi? Na utukaikoki. ");
INSERT INTO amm_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ulai nosai no mo; Yotano iwo ausaimi tokosiyaiyo tiki, Iyonoyo toku iwoso no puluwakomosiki no. Nosoni tolokaina tiki. ");
INSERT INTO amm_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Noko nokolalo molopoi ti liyai manoki, iyamoki, “Iyono mo mulu ifolaluwawoi mi pa ano manokiso, koini molo timai mo. Ulai ninani nokota monoi no posasokoki no, nonani imo komaso mo motu.” Noko nokolaloyo aino iyamoki, ");
INSERT INTO amm_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","nonani asiso lolaloso na mulumolo luwaikino. ");
INSERT INTO amm_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Noko mo ai uwoki. Tani siyolo mo Lasolaso, Pitano nokota na. Pitano nokonu mo Moili noko tini nukutai na, Moiliwoi auwatono Matawoi. ");
INSERT INTO amm_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Moili no mo, ai nokota Lasolasoni inaitono, nonani nukonu mo Isiso Siyoli no louwoki no, kou woti iwo itouniyaimoyo. Totani fona tiso solukimoki, komu suwo sopoyo uwosuwakomoki. ");
INSERT INTO amm_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Auwatono ai uwoki mo, no monoi no nokolalo ti mo nokoso iko taikiyokino, “Isiso Siyoliso na pimanowo, tani wolitono itouniyaimo mo ai tuwo.” ");
INSERT INTO amm_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Isiso mo nonani imo kwaiki mo, na yomuki, “Ai tuwo. Ulai pa kalokaiyoiso. Koto Siyolini ami wiyoti monoi ai na tuwo. No monoi no Kotoni awitono yani siyolo mani, kaluwaimonaloinomo.” Aino na yomuki. ");
INSERT INTO amm_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Mata noko ti monoi mulu ukuki, Isiso mo, Lasolasowoi monoi. ");
INSERT INTO amm_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ulai somaiso manowoi muwoi. Lasolaso ai imoso kwaiki mo, somaiso manowoi muwoi, amoloki tiwoi mo amai na tanoki. ");
INSERT INTO amm_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Amoloki tiwoi mo uwai; nosai no mo siyokutono iyaliso na ikoki, “Yutiya asiso ifou niya tonukoni.” ");
INSERT INTO amm_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ulai toiyo, “Noko Siyoli, tino mo Yuto noko sisiyoliyo tomoki ifoloko unukini, louwa tukolokini. Hani monoi ifou tomanoni?” ");
INSERT INTO amm_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","10","Nosai no mo; Isiso mo siyokawi imo ikoki, “Nokoyo amolokimai liyai mo, na kitolomo. To mo saponiwoi muwoi, no monoi no. Ulai saponi mo foku muwoi, sopo na, somosaisai ainoso upimo totoi. Nokoyo ulomai liyaiyakimo, pa kitolomoiso, waliyo liyaiyaloimo. Uloni saponi na wi koloimo, molomaiso.” Siyokawi imo mo aino ikoki. Ima imo mo noino, Yuto noko sisiyoliyo no moloi alukimo monoi, tani mi no? ");
INSERT INTO amm_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Ikoki mo; na ikoki, “Moini woli Lasolaso mo ulololi totoi. Na tolusiyano, yo mo.” ");
INSERT INTO amm_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ulai siyokutono iyaliyo imokino, “Noko Siyoli, ulololi mo waliyo. No monoi no waliyo toloimo.” ");
INSERT INTO amm_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Aino imokino, mulumolokokino, “Ulololiya ulololi totoiwo.” Isisosu mo Lasolaso kalo monoi na yomuki. ");
INSERT INTO amm_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","No monoi no mo, ima imo na ikoki, “Lasolaso mo yasoi na kalo, yau. ");
INSERT INTO amm_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Yo mo tani auso piyousi mo, pa pokaloso. Ulai yani ami wiyononinoikuwomo, moiyo mulumolo luwaimono monoi. No monoi no ya tomoloki. Lasolaso yau niya tokiyanokoni.” ");
INSERT INTO amm_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Nosai no mo; Isisoni siyokutono Tomo mo ikoki. Nonani siyolo imo folosai mo noino, atinoyo komu tiwoi kokoki. To mo siyokutono iyaliso na ikoki, “Niya taluwaikoni. Uo nokoyo tukolakinomo, moi mani, tukuwolimoko tomasiwumo.” ");
INSERT INTO amm_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Pitano nokonu mo tiki mo, nokoyo imokino, “Taunoni fainisai ai unukino.” ");
INSERT INTO amm_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Pitano nokonu mo Yolusolimo nokonu siyoli mo aluwamai muwoi, aumoifaso nali. ");
INSERT INTO amm_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","No monoi no Yuto noko molopoiyo toku yasoi fu si fasiko sa tumokino, Mata noko tiso, Matawoi Moiliwoi. Auwatono mo yau, no monoi no fu si fasiko sa tumokino. ");
INSERT INTO amm_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Nosai no mo; nokoyo Mataso mo isoki, “Oi, Isiso mo molomai totumo.” Isoki mo; amusiyofuki, molomai kiya fuki. Moili mo numai sisokaisonoki. ");
INSERT INTO amm_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mata mo Isisoni au mo tumosoki mo, na imoki, “Noko Siyoli, nono mo isoni potolokainoni mo, yani auwa mo pa pokaloso. ");
INSERT INTO amm_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ulai waliyo na. Yo mo sai, hani ano monoi Kotoso utolumakinimo, totayo noinomo waliyo na anoinimo.” ");
INSERT INTO amm_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Nosai no mo na isoki, “Auwano mo na auwoniyouwoimo.” ");
INSERT INTO amm_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ulai Mata mo, “Yo mo sai. Asi fokumomaiso, yau yausai auwonoulumaiso yani auwa mani, na auwoniyouwoimo.” ");
INSERT INTO amm_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ulai Isisoyo, “Asa mo yau yausai lusokokai nokota. Asayo noinomo noko nokolalo tosi itouniyaimomoi, aniyopa poi poi. Mulumolo luwaimono nokota mo kalakimo, pakoso kalokaiyoiso, Kotoni auso yousi itouniyaimo manoimo, aniyopa poi poi. ");
INSERT INTO amm_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Aniyopa poi poi yousi itouniyaimo nokota mo mulumolo luwaimonakimo, to mo pa kalokaiyoiso. A, yani imo no waliyo tomulumolokoni?” ");
INSERT INTO amm_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","“Nasu.” Mata mo na imoki, “Noko Siyoli, yo mo waliyo na tomulumolo luwainoki. Nono mo Kotoni awitono Kolaiso, Kotoyo no muwokaikini no, asi asi noko nokolalo koi fasimoka tumo monoi.” Aino na imoki, Mata mo. ");
INSERT INTO amm_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Imoki mo; nosai no mo; ifou manosoki, auwatonoso wosu woso isanoki, Moiliso. Na isoki, “Aiyolokomomoko nokota mo yasoi tumo. To mo timono taikiyo, nonayo kiyano monoi.” ");
INSERT INTO amm_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Isoki mo; Moili mo somaiso auwonisiyouki, tani auso na manosoki. ");
INSERT INTO amm_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Isiso, to mo nokonuso lotiwoi muwoi, amai pofu toloki, Matayo toku no kwaiya fuki no. ");
INSERT INTO amm_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Yuto noko Moili no fu si fasisokino no, nusai toiyo aluwainisiyo fukino. Somaiso auwonisiyouso kwaisokino, amusiyofuso, no monoi no aluwainisiyo fukino, piyamoki, “Auwatononi yauso tosonukuyanowo.” ");
INSERT INTO amm_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Moili mo manosoki. Isiso mo kwaiya tumoki mo, tani fokutonomai losiyaikoki, na imoki, “Noko Siyoli, nono mo isoni potolokainoni mo, yani auwa mo pa pokaloso.” Aino imoki, ");
INSERT INTO amm_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","soniki. Isiso mo soniso kwaisoki mo, mulu mo yau. Yuto noko no aluwainisiyo tumokino no, toi mani, sonukuso kwaikoki. Mulu mo puwoso, mulu mo na kaloki. ");
INSERT INTO amm_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Na ikoki, “Ai unu asi no moiso?” Imokino, “Noko Siyoli, kuku, na pokiya tumo.” ");
INSERT INTO amm_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nosai no mo; Isiso mo na soniki. ");
INSERT INTO amm_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Yuto nokoyo ikuwanokino, “Soniso na pukwaiwo. Wiyou, to monoi mulu mo yau.” ");
INSERT INTO amm_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Siyaiyosu iyamoki, “Molo kau kau nokota monoiso itouniyaimokai, to mo. Noko ai nokota no hani monoi yau monoi no pa alukimoso?” Aino iyamoki. ");
INSERT INTO amm_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","No monoi no mo, Isiso mo ti monoi mulu mo puwoso, ai unuso manoki. Yu asi iso ai unukaikino. Tomoki siyoliyo itu loti ufiyaimokaikino. ");
INSERT INTO amm_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yu asi i mo tumoki mo, nokoso na ikoki, “Tomoki na pololomotaiwo.” Ulai Mata mo imoki, “Noko Siyoli, ulai moloi monoi woi?” Noko yauni inaitono Mata mo na imoki, “Moloi monoi woi? Noko yau woti mo wiyou. Taunoni fainisai na kaloki.” ");
INSERT INTO amm_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ulai Isisoyo mo, “A, yani imo no tofufolikomoni? Yasoi na imonoki, “Mulumolo luwaimonakinimo, Koto Siyolini amiso kiyoinimo.” ");
INSERT INTO amm_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Nosai no mo; tomoki na lolomotaikino. Lolomotaikino mo; Isiso mo na you foinalikoki, na imoki, “Apou, yani imo na tukwaimononi, no monoi no wafisu na timonoki. ");
INSERT INTO amm_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yo mo sai, yani imo mo saiso saiso na tukwaimono manoni. Noko nokolalo ni si no, toi mo sai muwoi. No monoi no timonoki, toi mulumolo luwaimono monoi, saino unumono monoi, nonayo imono taikiyokini.” ");
INSERT INTO amm_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Puwoso monoi imoki mo; yau nokotaso na aliyoniki, siyoliso na imoki, “Lasolaso, na pamufu.” ");
INSERT INTO amm_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nosai no na amufuki. Yau nokota mo na auwoniyouki, na amufuki. Wiyouwa wiyou, tunoyo yalokonokai na amufuki, naino fona yalokonokai. Amu molo mani, tunofayo yalokonokai. Isiso mo noko nokolaloso ikoki, “Na pofololokomowo, pimowo, manumo.” ");
INSERT INTO amm_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","No monoi no mo, Yuto noko molopoi mo Isisoso lolaloso mulumolo luwaikino. Ulai afonimaiso? Moiliso kosa tumokino mo, yausai lusikaiso na kwaikino, no monoi no. ");
INSERT INTO amm_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Siyaisu mo Falisi moloso aluwai nokoso ikanokino, ikokino, “Isiso mo noko yau lusikai.” ");
INSERT INTO amm_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Nosai no mo; nokotalo iyaliso aliyonikokino. Falisi moloso aluwai nokowoi lotu samukuko noko sisiyoliwoi, toiyo nokotalo iyali mo aliyonikokino, imo lukaso monoi. Ikuwanokino, “Moloi tiyokoni? Noko no mo, to mo mulu ifolaluwawoi mi tanomosi, noko nokolaloni molo timai. ");
INSERT INTO amm_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Wiyouwa wiyou, alukimo somiso mo, noko nokolalo komaso aluwaiyoinomo. Wonikaluso Lomo nokoyo amiyaikiyomoka tumoinomo, lotu nu siyoli aiko uwokaiya tumoino, toini fona wosuwoiso aiko soi, moini noko nokolalo mo.” Aino ikuwanokino. ");
INSERT INTO amm_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Nosai no mo; Kaiyofa ikoki. Isiso tukolomai nonani nokota mo totawoi lotu samukuko nokota siyoli na. Na ikoki, to mo, “A, moi no mulu no uwofa woi? ");
INSERT INTO amm_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Wonikaluso Lomo nokoyo uwokaikomomoka tumoinomo, Yuto noko moiso. Ulai noko siyayo moi kwalomai monoi kalakimo, no mo waliyo. Hani monoi moi no sai pakoso?” ");
INSERT INTO amm_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Aino na ikoki, Kaiyofa mo. Piyomuki, totani muluyosowo. Ulai totani muluyoso muwoi, Kotoni muluyosu nali no. Isiso tukolomai, nomai no mo Kaiyofa mo totawoi lotu samukuko nokota siyoli na, no monoi no posasokoki, Isiso kalo monoi mo. Yuto noko nokolalo kwalomai monoi kalo uku monoi, ainonani monoi posasokoki, Kaiyofa mo. ");
INSERT INTO amm_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Motu na. Ulai Yuto noko nokolalo monoi saso muwoi, Kotoni alalo komaso monoi nali no. Isoni ausoni no si liyai no, toi monoi mani, kwalomai monoi kalo uku na, si tomasimo monoi. ");
INSERT INTO amm_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nosai no mo; nokotalo iyaliso ikoki mo; imo na lukasokaikino. Isiso tukolo imo na lukasokaikino. ");
INSERT INTO amm_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","No monoi no Isiso no Yuto noko sisiyolini molo timai no moloi mano liyai monoi? Nu somiso asi kwasai sanoki, Isiso iyali mo, Ifolaimo nokonuso. ");
INSERT INTO amm_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Nosai no mo; Pasowa koloni wasi popo mo aumoifaso. Yuto noko nokolaloni mi fou fouko popo siyoli mo. Nomai no noko nokolalo molopoiyo totaini asi folo folo utukaiko liyaikino, Yolusolimo nokonu siyoliso nuki. Pasowa koloni wasiwoi muwoi, toku mo Kotoni molo timai iwo loukanokino, piyamoki, Kotoni imo mo futowo. Iwo louko somiso mo, Pasowa koloni wasi mo au au. No monoi no Yolusolimo nokonuso nuki, Pasowa popo mo aumoifaso. ");
INSERT INTO amm_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Yolusolimo mo tiki mo, Isisoso ikoliyalo manokino. Lotu nu siyoliso siki, na ikuwanokino, “Nakomo tumowoi muwoi. Koloni pa wasiya tumoiso poi. Na piyamowo.” ");
INSERT INTO amm_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Nokotalo iyaliyo imo ami toku yasoi ikokaikino, “Isisoso kiyakinuwomo, na pa imoka tumowo.” Aino toku yasoi ikokaikino, lotu samukuko noko sisiyoliwoi Falisi moloso aluwai nokowoi. ");
INSERT INTO amm_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Nosai no mo; Pasowa koloni wasiwoi muwoi, ulo toufo mo amai, nomai no mo Isiso mo Pitano nokonuso tumoki, Lasolasoni nukutaiso, noko no mo yausai toku no lusikaiki no. ");
INSERT INTO amm_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Nosai no mo; koloni no nikokino. Lasolasoyo no niko yousiki, Isiso iyaliwoi. Matayo wautiki. ");
INSERT INTO amm_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Amai no manokino mo, Moili mo kou woti iwo nau na asoki. Isisoni fona tiso na sololukikomaloki. Wiyou, kou woti iwo mo koufa muwoi, siyoliso na solukimoki. Kou woti iwo itouniyaima itouniyaimo, muwoni mo siyoli, wiyou. Isisoni fona tiso na louwokomoki, komu suwo sopoyo na uwosuwakomoki. Wiyou, nu mo woti itouniyaimo saso. ");
INSERT INTO amm_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Nosai no mo; siyokutono siya Yutaso yomuki, “Hani monoi tiyo?” Yutasoni siyolo siya mo Isokailiyo, Isisoni woliya wolitono muwoi, uo nokoni auso kiyo nokota na. ");
INSERT INTO amm_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Nonani nokota mo na yomuki, “Noni no hani monoi tiyo? Ninani kou woti iwo mo suo suomoko nokoso patikoni mo, suo mo muwoni mo siyoliso na ponimokono, ilolu somiso nokoso ponikalokoni. Wiyou, muwoni mo sisiyoli.” ");
INSERT INTO amm_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yutaso mo aino yomuki, topoko imo saso. Ilolu somiso noko monoi mulu mo kalowoi muwoi, muwoni polamoko monoi louwa fi. To mo muwoni samukuko nokota. Isiso iyalini muwoni posamukuko manoki. Nonani muwoni popolamoko watimosiki. ");
INSERT INTO amm_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Nosai no mo; Isiso mo na imoki, “Noni mo tofolo tolosu. Yo monoi toku akai unumonoki, kou woti iwo mo, yo louwomono monoi. Ulai afonimaiso? Nokoyo ai unumonoinomo. ");
INSERT INTO amm_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ilolu somiso nokowoi aniyopa poi poi tosi manonuwo. Yosu mo aniyopa poi poi pa totolo tomasimonukuwoso.” Isiso mo aino na imoki. ");
INSERT INTO amm_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Nomai no mo, Yuto noko molopoi nokoni auso imofa kolo koloma tumoki, “Isiso mo Pitano nokonuso tiyousi.” No monoi no kiyanokino. Isiso saso pa kiyanokinoso. Yausai lusikai nokota Lasolaso mani, kiyanokino. ");
INSERT INTO amm_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","No monoi no mo, lotu samukuko noko sisiyoliyo imo lukasokaikino, “Lasolaso mani, niya tukolo monoi.” ");
INSERT INTO amm_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Ulai afonimaiso? Afonimaiso muwoi, Yuto noko molopoiyo nokotalo iyalini imo kulalikino, Isisoso lolaloso mulumolo luwaikino, Lasolaso yausai lusikai monoi. ");
INSERT INTO amm_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Nosai no mo; amuwoisai noko nokolaloni auso imofa kolo koloma tumoki, “Isiso mo Yolusolimo moloso totumo.” Toku yasoi ukouniyaikokaiki, noko nokolalo molopoi mo, koloni wasi monoi. ");
INSERT INTO amm_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Nosai no mo; molo suwo na tokoso iyalokino, na iyo fukino, Isisoso molomai na kiya fukino, siyoliso na iyamaloki, “Na tomolokimokoni. Ninani nokota, Noko Siyolini amimai ni totumo no, tani siyolo na tokaluwaiyaloukoni. Isolilo noko nokolalo moini samukumoko nokotani siyolo na tokaluwaiyaloukoni.” Aino na iyamaloki, noko nokolaloyo. ");
INSERT INTO amm_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Nosai no mo; Isiso mo hosofa na kausiki, na yousikaina yoki, hosofani namoli tonimai. Na manoki, hosofa molosai. Ainoso nali, Kotoni puko imoyo tiyomuko, noino, ");
INSERT INTO amm_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Oi, Saiyono noko nokolalo moi mo noiyo kokolokomoiwo. Na pukwaiwo, moini samukukomo nokota siyoli mo na totumo, hoso uofani namoli toni molosai na totumo.” Aino tiyomuko, Kotoni puko imoyo, Yolusolimo noko nokolalo monoi. ");
INSERT INTO amm_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Isisoyo hosofa molosai tumomai mo siyokutono iyali mo nonani monoi mo mulumolokokaiwoi muwoi, toi mo sosoli. Namolisaisu, Isiso mo Kotoyo kawiyo yoki mo; nosai no Kotoni puko imo monoi mulumolokokaikino, to monoi no tiyomuko unu no, nokoyo no yo unukino no. ");
INSERT INTO amm_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Yausai lusikaiso kwaimo noko nokolalo toiyo toku yasoi posasolomaniyalo manokino, ai unusai aliyoni imo mo. ");
INSERT INTO amm_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","No monoi no mo, noko nokolalo molopoi mo kiya fukino. Mulu ifolaluwawoi mi ano imo toku yasoi kwaikino, no monoi no molomai kiya fukino. ");
INSERT INTO amm_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Falisi moloso aluwai nokosu, toiyo ikuwanokino, “Moloi woi? Moi no ulai moloi alukimo monoi? Wiyouwa wiyou, noko nokolalo komaso taluwai manono.” ");
INSERT INTO amm_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Koliko noko siyai mani, Pasowa koloni wasiya tumokino, Koto monoi molokima tumokino. ");
INSERT INTO amm_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Tiki mo; Filiposo ima tumokino. Filipo mo Pisaito nokota, Kalili asimai no toi no. Nonani nokotaso na ima tumokino, Koliko nokoyo, “Woli, Isisoso tokiya tumonoki.” ");
INSERT INTO amm_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Imokino mo; Filipo mo Anotoluso imanoki, “Noko mo Isisoso tokiya tumono.” Imoki mo; totiyo Isisoso imanokino, na imokino, “Noko mo tokiya tumoni.” ");
INSERT INTO amm_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Nosai no mo; Isiso mo na ikoki, “Aumoifaso asi asi noko nokolaloni noko siyoli nokota yani siyolo kaluwaimonoinomo. ");
INSERT INTO amm_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Motuwa na timonukuwo. Tuo u mo asiso usukunalo kono somiso mo, tuo tonofalo pa pauwonouluso. Tuo u mo noko yau komiyai asiso uwokai somiso mo, siyasu na potoi, tuo u saso. Ulai tuo u mo asimai ku uwokaiyakimo, tuo tonofalo auwoniyouwoimo, tuo u molopoiwoi na soimo. ");
INSERT INTO amm_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Noko mo tota amu mulu yo mo, aniyopa poi poi moloi yousi itouniyaimo monoi? Na kaloimo. Asimai tolo nokotasu mo tota amu mulu yo somiso mo, amai na yousikainoimo, aniyopa poi poi yousi itouniyaimo manoimo. ");
INSERT INTO amm_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Noko mo mi ano fasimono mo, na aluwaimonumo. Yani auso na tolumo. Noko mo asani mi ano fasimonakimo, yani Apouyo kisosomiyoimo.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Ulai na ikoki, “Mulu na tokalomono. Ulai Apouso yo no moloi imo monoi, uwokaimono noko alukiko monoi? Nokoyo uwokaimono monoi na amukonoki, yo mo.” ");
INSERT INTO amm_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Nosai no Kotoso imoki, “Apou, nani ami siyoli na powiyoti, noko nokolaloso. Nani siyolo kaluwaiyalou mo waliyo.” Imoki mo; ulai ko na mo kumokisai na you yomuki, “Yani ami mo yasoi na wiyotiki. Ulai ti monoi na wiyotiyoimo.” Ko na mo kumokisai ainoso na yomuki. ");
INSERT INTO amm_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Aumoifa si noko nokolaloyo kwaimokino mo, piyamoki, saukuwo. Siyaiyo iyamoki, “Kotoni kumoki nokotayo timowo.” ");
INSERT INTO amm_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ulai Isisoyo, “Asa fasimono monoi pa tiyomu taikiyoso, momaiso posaso wiyononi monoi na tiyomu taikiyo. ");
INSERT INTO amm_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Lolaimai mo Koto mo molo koiyau foli monoi na tiyomukai. Lolaimai asi asi nokoni samukuko nokota koiyau mo na tamiyaikiyo taikiyo. ");
INSERT INTO amm_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nokoyo akaimona yakinomo, yo mo noko nokolalo komaso na aliyonikoimo, asani auso ti liyai monoi.” ");
INSERT INTO amm_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Ainoso ikoki, a mokimai kalo imo mo. ");
INSERT INTO amm_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nosai no mo; noko nokolaloyo utolumokino, Kolaiso monoi, noko no mo Kotoyo no muwokaiki no, noko fasika tumo monoi. Na imokino, “Musini imo amiyo tiyomuko, Kolaiso mo aniyopa poi poi totolokaino. Ulai nono mo tiyomuni, asi asi noko nokolaloni noko siyoli nokota mo a mokiso akaiya yoinomo, nokoyo? Moloi woi? Asi asi noko nokolaloni noko siyoli nokota no noi woi? Ima imo na pimoko.” ");
INSERT INTO amm_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Nosai no mo; Isiso mo siyokawi imo tota amu monoi na ikoki, “Aumoifaso folosumono kukomoinuwomo. Saponi mo fokufaso amai na towi. Saponimaiso na poliyaiwo. Noko mo folosumai liyai mo, molo no moloi aluwai monoi? ");
INSERT INTO amm_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Fupiniyaimo kolokomomai saponi monoiso na pomulumolokowo. No monoi no moi mo saponiwoi na soinuwomo.” Isiso mo siyokawi imo aino na ikoki, nokoso. Ikoki mo; utukaikoki, na kukalokanoki. ");
INSERT INTO amm_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Isiso mo mulu ifolaluwawoi mi siyoli ano manoki, Noko nokolaloni molo timai analoki. Ulai pa mulumolo luwaikinoso. ");
INSERT INTO amm_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","No mo afonimaiso muwoi, Kotoni puko imoyo motu fiyamosi monoi, tani mulu lukasiko nokota Aisaiyayo toku no kumokaiki no, noino, “Noko Siyoli, koini imoso waliyo pa mulumolokokinoso. Noko Siyoli, nonani ami no moloi wiyoti monoi, iyo uku uku nokoso no?” Aino na kumokaiki. Namolisai mo motu na fiyamosiki. ");
INSERT INTO amm_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","No monoi no noko nokolalo no moloi mulumolo luwai monoi? Ulai afonimaiso? Nonani monoi imo siya mani, Aisaiyayo toku kumokaiki, noino, ");
INSERT INTO amm_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Koto totayo noinomo toini molo tiso kau kaukokai, mulu mo wapu wapu saso. Molo tiyo no hani no moloi ki monoi? Imo folosai no moloi saino monoi? Mulu no moloi alosoko monoi? Mulu palosokono mo, ya na pititounikai.” ");
INSERT INTO amm_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Aisaiyayo afonimaiso pa yomukaikiso. Isiso mo amukonowoi muwoi, tani ami siyoliso na kiki, no monoi no yomu unukaiki. ");
INSERT INTO amm_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Ulai nokotalo iyali siyai mani, na mulumolo luwaikino, noko sisiyoli molopoi. Ulai siyoliso iyamo unuwoi muwoi, wosu wososu mulumolo luwaikino. Falisi moloso aluwai noko monoi nikokino, iyamoki, “Wonikaluso lotu nufaso ti monoi alukikomomokoinomo.” ");
INSERT INTO amm_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Aino iyamoki. Ulai afonimaiso? Toi mo Kotoyo kisosomiko muluwoi muwoi, noko nokolaloyo kisosomiko mulu saso yokino. ");
INSERT INTO amm_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Nosai no mo; Isiso mo siyoliso ikoki, noko nokolaloso. Na ikoki, “Noko mo mulumolo luwaimonakimo, yo saso mulumolo luwaimonowoi muwoi, imono taikiyo nokotaso mani, mulumolo luwaiyoimo. ");
INSERT INTO amm_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Kimonakimo, imono taikiyo nokotaso na kiyoimo. ");
INSERT INTO amm_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Yo mo saponi komiyai wikaiya konoki. Noko mo mulumolo luwaimonakimo, folosumai pa yousikainoiso.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Ulai ikoki, “Noko mo yani imo kwai somiso mo, ulai yo mo imo kulali foli monoi pa tiyomukaiso. Yo mo molo koiyau foli monoi pa yoma konokiso. Asi asi noko nokolalo samiyaikiyo monoi amukonoki, yo mo. ");
INSERT INTO amm_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ulai imo kulali foli mo amai. Namoliyo alosimomono foli mo amai. Noko mo yani imoso kulaliyakimo, imo kulali foli monoi na uwoyoimo, asi fokumomaiso. Ulai afonimaiso? To mo sosoli muwoi, yo mo yasoi na imokaiki, suo foli monoi mo. ");
INSERT INTO amm_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","No mo motu nali. Yo mo asani muluyosu pa timonukuwoso. Apou Siyoliyo na imono taikiyoki, amiso na imonoki, “Imo na pa lukaso nika kono, noisu noisu.” ");
INSERT INTO amm_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Noko mo tani imoso kwai itouniyaimo mo, aniyopa poi poi yousi itouniyaimomoi. Ainonani yo mo sai. No monoi no Apou Siyolini imososo na timonukuwo, totayo no imonoki no.” Isiso mo ainoso na ikoki. ");
INSERT INTO amm_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pasowa koloni wasi popo mo aumoifaso. Nomai no mo; Isiso mo mulumolokoki, “Aumoifaso yo mo asi asi noko nokolaloso utukaikiyo yoimo, Apou Siyolini auso.” Asimai tolokainomai Isiso mo totani noko nokolalo monoi mulu uku manoki. Mulu uku manoki mo, mulu siyoliso na ukuki, ainoso mi uwai. ");
INSERT INTO amm_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Nosai no mo; Isiso iyali mo amolokimai no siki. Sokolo Nokota Waiyo Yutasoso toku yasoi imoki, “Isiso mo uo nokoni auso na pa kiyo taikiyo.” Wosu woso imo na, tani mulu poiso ainoso imoki, Yutasoso, Saimo Isokailiyoni awitonoso. ");
INSERT INTO amm_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Isiso mo sai, Apou Siyoliyo komaso hani mo tani nainomai yasoi na niki. Totani ausai amukonoki, aumoifaso ifou na amiyoimo. ");
INSERT INTO amm_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","No monoi no mo, amai no si manoki mo, Isiso mo na tolauki, fulomu tuno itouniyaimo asiyokaiki. Asiyokaiki mo; iwo louko tuno na atoliki. ");
INSERT INTO amm_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Iwo louko tuno atoliki mo; iwo solukiki, nau siyoliso, siyokutono iyalini fona na uluwakoki, iwo louko tunoyo uwosuwakoki, iwo louko tuno no atoliki no, nonaniyo na uwosuwakoki. ");
INSERT INTO amm_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Uluwako manoki mo; nosai no Saimo Pitani fona na louwa uluwakomoki. Ulai Pitayo imoki, “Noko Siyoli, nono no asani fona no moloi uluwakomomono monoi?” ");
INSERT INTO amm_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Nosai no mo; Isiso mo na imoki, “Ya ni tiyo no, lolai mo nono mo sai muwoi. Ulai namolisaisu nono mo sainoinimo.” ");
INSERT INTO amm_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ulai Pitayo, “Noiyo. Nono no moloi uluwakomomono monoi?” Ulai Isiso mo, “Uluwakomo somiso mo, pa tolo tomasimomonoiniso.” Siyokawi imo aino imoki, mulu itouniyaimokai monoi. ");
INSERT INTO amm_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Nosai no mo; Pita mo imoki, “Noko Siyoli, waliyo na, yani fona saso muwoi, yani naino mani, na puluwakomomono. Komuwoi nali.” ");
INSERT INTO amm_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Nosai no mo; Isiso mo siyokawi imo ulai na ikoki. “Noko mo iwo louko yasoi, to mo fona saso mo amai uluwakomo. Au mo tokumowoi muwoi, wofu. Noinoso moi mo mulu mo wofu wofu. Siyasu mo mulu mo wofuwoi muwoi, koiyau.” ");
INSERT INTO amm_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Aino na ikoki, siyokawi imo mo. To mo sai, uo nokoni auso kiyo taikiyo nokota monoi, no monoi no ikoki, “Siya mo mulu mo wofuwoi muwoi, koiyau.” ");
INSERT INTO amm_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Nosai no mo; fona uluwakoki mo; tuno toku no asiyokaiki no, ti monoi asisiki, na yousa konoki, na ikoki, “A, moi no sai hani monoi tiyo ununukuwo?” ");
INSERT INTO amm_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ti monoi ikoki, “Aiyolokomomoko nokota tokaluwaimono manonuwo. Noko Siyoli mani, na tokaluwaimono manonuwo. Motu na, yo mo noinoso na, tomoso. ");
INSERT INTO amm_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Yo mo Noko Siyoli nali, moi aiyolokomo nokota. Ulai yo mo moini fona uluwakomonukuwo. No monoi no moi mani, fona na pa uluwakuwanowo, na pa fasikuwano manowo. ");
INSERT INTO amm_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Yo mo noko fasiko molo na towiyononinukuwo. Yo ni tiyo ununukuwo no, tomoso na pa yowo. ");
INSERT INTO amm_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Motuwa na timonukuwo. Mi anononi nokotayo no totani samuku nokota no moloi souwai monoi? Ulai mi ano nokotayo no toso imo taikiyo nokotaso no moloi souwai monoi? ");
INSERT INTO amm_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Lolai mo moi mo sai, ninani monoi mo, ya timonukuwo. Noinoso yakinuwomo, na molokiyoinuwomo.” Ainoso na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ulai ti monoi na ikoki, “Yo mo moi komaso monoi pa tiyomuso. Moi, asayo no muwokomonukuwo no, moi komaso monoi yo mo sai. Ulai siyasu mo yani woliya woli muwoi. No mo afonimaiso muwoi, Kotoni puko imoyo motu fiyamosi monoi, to monoi no tiyomuko no, noino, “Noko ya tuo ni tono ni no, to mo na totowitolomomono, yani atolitolo na.” Aino na tiyomuko. ");
INSERT INTO amm_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Lolaisu toposaso wiyononinukuwo, yo uwomono monoi imo mo. Ulai afonimaiso? Uwomonakinomo, waliyo na mulumolo luwaimonoinuwomo, aniyopa tolokaino nokota yoso. ");
INSERT INTO amm_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Motuwa na timonukuwo. Noko mo asayo iko taikiyo nokoso iko mo, “Waliyo potiwo,” to mo yoso mani, imono, “Waliyo na potumo.” Yoso aino imono mo, imono taikiyo nokotaso mani, imo, tumumo.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Nosai no mo; Isiso mo ikoki mo; mulu mo na kaloki, na ikoki, “Motuwa na timonukuwo. Moi nokotayo uo nokoni auso na kiyomono taikiyoimo.” Isiso mo aino posaso wiyotiki. ");
INSERT INTO amm_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Moloi woi? Siyokutono iyali mo molo amiso kwaikuwanalokino, na mulumoloko manokino, “Noi monoi tiyomu unu, woi?” ");
INSERT INTO amm_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Siyokutono siya Isisoni wolitono itouniyaimo, to mo Isisoni auso yousikainoki, aumoifaso. ");
INSERT INTO amm_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Nonani nokotaso Saimo Pitayo afaiyomiki, wosu wososu imoki, “Na putolumo, noi monoi poi tiyomu unu.” ");
INSERT INTO amm_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Nosai no mo; to mo aumoifaso na usosumi yousa tumoki, “Noko Siyoli, noi monoi tiyomu ununi?” ");
INSERT INTO amm_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Isiso mo fowaki, “Yo mo ninani tuofa mo nauso tukolonoimo, nonani nokotaso na anoninoimo.” Ikoki mo; tuofa mo na tukolonoki, Yutasoso na anoniki, Saimo Isokailiyoni awitonoso. ");
INSERT INTO amm_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yutaso mo tuofa imoki kusomi. Anoki mo; Sokolo Nokota Waiyo uwoki, tani mulu poiso na lotiki. Isiso mo na imoki, “Mulu ni tiyoni no, somaiso na piyo.” Isiso mo aino na imoki, Yutasoso. ");
INSERT INTO amm_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ulai no si noko mo sai muwoi, mulumoloko manokino, “Hani imo woi?” ");
INSERT INTO amm_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Yutaso mo muwoni samukuko nokota. No monoi no siyai mo piyamoki, “Nakomo timo, koloni wasini hani hanisu iyanowo.” Siyai mo piyamoki, “Nakomo timo, ilolu somiso nokoso muwoni nikanowo.” ");
INSERT INTO amm_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yutaso mo tuofa waki mo, somaiso na amufuki. Amoloki nali. ");
INSERT INTO amm_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Nosai no mo; Yutaso amufuki mo; Isiso mo na ikoki, “Asi asi noko nokolaloni noko siyoli nokota yani siyolo mo aumoifaso kaluwaimonoinomo. Yo mo Koto Siyolini ami wiyotiyoimo, noko nokolaloso. ");
INSERT INTO amm_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nasu, yo mo Koto Siyolini ami wiyotiyoimo, noko nokolaloso, no monoi no to mani, wiyotiyoimo, awitono yani ami mo. Wiyouwa wiyou, Koto mo yani ami siyoli lolai siyaso wiyononinoinuwomo.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ulai ikoki, “Woli iyali, moi mo yani alalo komiyai. Fokufa saso amai totolo tomasimonukuwo. Utukaimakinukuwomo, louwa ikolimonaloinuwomo. Yuto noko sisiyoliso toku yasoi ikoki, noino, “Yani auso no moloi ti monoi, moi no?” Imo tomoso na timonukuwo.” ");
INSERT INTO amm_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nosai no mo; Isiso mo siyokutono iyaliso ulai na ikoki, “Imo ami tonofalo na timokainukuwo, noino, mulu na pukuwanowo. Ya mulu ni tununukuwo no, noinoso moi mani, mulu na pukuwanowo. ");
INSERT INTO amm_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Mulu ukuwanakinuwomo, noko nokolalo komasoyo saino unoinuwomo, yani moloso taluwainuwo mo.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Nosai no mo; Saimo Pitayo imoki, “Moiso manoinimo?” Isiso mo na imoki, “Konoimai no moloi aluwaimono monoi? Namolisaisu mo na aluwaimonoinimo, yani auso tumoinimo.” ");
INSERT INTO amm_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ulai Pita, “Ulai hani monoi konoimai no pa taluwainokiso? Nono fasi foli monoi nokoyo tukolomonakinomo, yo mo imowoi muwoi, waliyo.” ");
INSERT INTO amm_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ulai Isiso, “A, fasimono foli monoi tukolakinimo, a, nono no imowoi muwoi? Topokoni, no mo imo saso. Motuwa na timonoki. Konoi amolokimai kokalo imo yomu somisomai, taumai na yomumosoinimo, “Yo mo Isiso mo sai muwoi.” ");
INSERT INTO amm_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Nosai no mo; Isiso mo siyokutono iyaliso na ikoki, “Mulu mo noiyo kolikaliyoiwo. Kotoso na pa mulumolo luwaiwo. Asaso mani, na pa mulumolo luwaimonowo. ");
INSERT INTO amm_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Yani Apouni nu mo sisiyoli. Totani nu mo molopoi, wiyou. Yo mo moini nu na kololi fouma yoikuwomo. Apou mo nu sisiyoli somiso mo, moiso aino pa pimonukuwoso. ");
INSERT INTO amm_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Moini nu na kololi fouma yoikuwomo. No monoi no mo, ifou na amukonoimo, na kolisa konoikuwomo. Na koliyo yoikuwomo. No monoi no moi mo asani auso na sinono manoinuwomo. ");
INSERT INTO amm_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Molosu moi mo sai, molo no mo, ya no amiyaki no, yani nukutaiso.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Nosai no mo; Tomo mo Isisoso na imoki, “Noko Siyoli, moiso manoinimo? Koi mo sai muwoi, koi mo sosoli. Molo no moloi saino monoi, koi no?” ");
INSERT INTO amm_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Nosai no mo; Isiso mo na imoki, “Asasu mo molo no mo. Asani moloso aluwaiyakinuwomo, Kota Koto monoi na sainoinuwomo, aniyopa poi poi si itouniyaimo manoinuwomo. Molo mo siyasoso na. Noko mo Kotoni auso mano mo, molo siyaso moloi mano monoi? Asani moloso na aluwaiyumo. ");
INSERT INTO amm_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Toku moi mo sai muwoi. Yo monoi toku posaino unumononuwo mo, yani Apou monoi mani, posaino ununuwo. Lolaimaisu mo lolaloso na tosainonuwo, na tokinuwo.” Aino na imoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ulai Filipoyo imoki, “Noko Siyoli, Apono Siyoli na powiyomoko. No monoi no mulu mo waliyo, koi mo.” ");
INSERT INTO amm_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ulai Isiso, “Woli Filipo, nono mo yo monoi sai pakoso. Yo mo fai tino pa tolo tomasimo manokinukuwoso. Tokusai na tolo manoki. Noko mo yoso kimono mo, Apou Siyoliso mani, yasoi ki. Moloi imono monoi, Apou Siyoli wiyononi monoi no? ");
INSERT INTO amm_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Asa mo Apou Siyoliwoi totolo tomasimomoi. Apou Siyoli mani, na totolo tomasimomonomoi. A, yani imo no waliyo tomulumolokoni?” Isiso mo aino na imoki, Filiposo mo. Ulai ikoki, “Imo ni timonukuwo no, no mo yani muluyoso muwoi. Tolo tomasimomono nokotani mi na tano, yo mo, Apou Siyolini mi na. ");
INSERT INTO amm_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Yani imo na pukwaimonowo. Yo mo Apou Siyoliwoi na totolo tomasimomoi. Apou Siyoli mani, na totolo tomasimomonomoi. Ulai yani imo kwaimono somiso mo, Apouni mi ya no tanomoi no, nonani mi monoi mo waliyo na pa mulumolokowo. ");
INSERT INTO amm_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Motuwa na timonukuwo. Noko mo mulumolo luwaimonakimo, to mo yani mi komiyai na anoimo. Wiyouwa wiyou, mi sisiyoli na anoimo, yani mi na souwaiyoimo. Ulai afonimaiso? Yo mo Apou Siyolini auso amiyoimo. No monoi no moini imoso na kwaikomoikuwomo, na fasiyoikuwomo. ");
INSERT INTO amm_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Motu na, mulumolo luwaimono nokotayo mo Apou Siyoliso hani ano monoi utolumakimo, awitono ya na yoimo. No monoi no noko nokolaloso ya wiyotiyoimo, Apou Siyolini ami mo. Tani siyolo na kaluwaiyaloinomo. ");
INSERT INTO amm_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Mulumolo luwaimono noko moiyo haninoi monoi utolumomonakinuwomo, ya na yoimo.” Siyokutono iyaliso aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Nosai no mo; ulai ikoki, Isiso mo, “Mulu unumononuwo mo, yani imoso kwai itouniyaimonuwo. ");
INSERT INTO amm_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Yo mo Apou Siyoliso imoimo, “Noko fasiko nokota siya na pimo taikiyo.” Imakimo, fasiko nokotaso mo na imo taikiyoimo. Aniyopa poi poi tolo fasikoma konoinuwomo. ");
INSERT INTO amm_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Nonani nokotani siyolo mo Kotoni Mulu Itouniyaimo Nokota. Kota Koto na wiyononinoinuwomo. Asi asi noko nokolaloyo no nonani nokotaso no moloi imo monoi, “Waliyo potumo.” Toi mo kiwoi muwoi. Pa sainoinoso, to monoi. Moisu mo sai. Momaini auso na totolokaino. Momaini mulu poiso na tolokaina konoimo. ");
INSERT INTO amm_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Yo utukaimakinukuwomo, awi alalo komiyai pa soinuwoso. Yo mo ifou amai na tumoimo. ");
INSERT INTO amm_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Aumoifaso asi asi noko nokolaloyo kimonowoi muwoi. Moiyosu na kimonoinuwomo. Yo mo ti monoi na tolokainoimo, no monoi no. Moi mani, sinonoinuwomo. ");
INSERT INTO amm_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nomai no mo moi mo sainoinuwomo, moi si tomasikuwano monoi. Asa mo yani Apouwoi totolo tomasimomoi. Moi mo yowoi tosi tomasimomono manonuwo. Yo mo moiwoi totolo tomasikomo manonukuwo. ");
INSERT INTO amm_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Noko mo yani imo kwai itouniyaimo mo, mulu na unumono. Mulu unumonakimo, yani Apouyo mulu na unoimo. Yo mani, nonani nokota monoi mulu unoimo. Asa amu wiyononinoimo, nonani nokotani molo timai.” Isiso mo aino na ikoki, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Nosai no mo; Yutaso siyayo imoki, “Noko Siyoli.” No mo Yutaso Isokailiyo muwoi, Yutaso siyayo na imoki, “Noko Siyoli, ulai moloi monoi woi? Nono amu no koi saso no hani monoi wiyomokoinimo. Ulai asi asi noko nokolaloso no hani monoi pa wiyotiyoiniso?” Aino imoki, Yutaso siyayo. ");
INSERT INTO amm_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","24","Nosai no mo; Isiso mo na imoki, “Noko mo mulu unumono somiso mo, to mo yani imo mo pa kwaimonoiso. Nokosu mo mulu unumonakimo, yani imo na kwaimono itouniyaimoimo. Yani Apouyo mulu unoimo. Tani auso na tolokaina tumoikimo, Apou kotiyo. Imo ni timonukuwo no, ni mo yani imo muwoi. Apou Siyoliyo na imono taikiyoki, “Imo na polukasika kono.” Aino na imoki, Yutasoso. ");
INSERT INTO amm_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Nosai no mo; Isiso mo na ikoki, “Yo utukaikomo somisomai ninani hani komaso monoi na timonukuwo, yo tolo fasikomomai. ");
INSERT INTO amm_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ulai moiso fasikomo nokota siyaso mo Apou Siyoliyo na imo taikiyoimo, “Na pofasika kono.” Nonani fasikomo nokota mo Kotoni Mulu Itouniyaimo Nokota. Asani muluyosu mo Apou Siyoliyo na imo taikiyoimo. Komaso hani hani na aiyolokoma konoinuwomo. Yani imo komasoso ya no aiyolokomokinukuwo no, nonani imo mani, ti monoi na aiyolokoma konoinuwomo. Wonikaluso fufolikomoinuwomo. ");
INSERT INTO amm_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Mulu tomokiso pa si manowo. Yo utukaikomoikuwomo. Ulai asayo noinomo mulu tomokiso na sinonoinuwomo. Asi asi noko nokolaloyo afonimaiso tikuwanomosino, “Atiyaiso.” Ulai afonimaiso? Kokolo mulu nali. Ulai ya timonukuwo, mulu noiyo kolikaliyoiwo, noiyo kokolokomoiwo. ");
INSERT INTO amm_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Yo utukaikomoikuwomo, ulai ifou tumoimo. Nonani imo yasoi kwaimononuwo. Mulu unumononuwo mo, na molokinuwo. Ulai afonimaiso? Yo mo Apou Siyolini auso amiyoimo. To mo na tosouwaimono. ");
INSERT INTO amm_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Amiyo somisomai ainonani monoi toku na timonukuwo. No monoi no mo, na mulumolo luwaimonoinuwomo, yo amiyakimo. ");
INSERT INTO amm_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Isoiso pa imoikuwoso. Ulai afonimaiso? Asi asi nokoni samukuko nokota koiyau na tumoimo. Ulai yoso no moloi uwokaimono monoi? ");
INSERT INTO amm_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Yo mo tiyomu asi asi noko nokolalo mo saino unumonowumo, yo mo Apou Siyoli mulu na tunumoi, noinoso na tiyomoi, Apouyo no imonoki no. Moi soiwo, niya tonukoni.” Isiso mo ainoso na ikoki, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Isiso mo siyokawi imo na yomuki, “Yo mo a itouniyaimo komiyai. Apou mo a kiyo nokota komiyai. ");
INSERT INTO amm_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Touwo komiyai mo yani aumai si liyai. Touwo mo a wamowoi si somiso mo, to mo tokosoki taikiyo, na tosaloso. Touwo mo a wamowoi sakimo, nonani touwo mo tokosoki taikiyowoi muwoi, na tisuwo itouniyaimalo. Wiyou, a wamo molopoiwoi na soimo. ");
INSERT INTO amm_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Moi mo ititouni a touwo komiyai, yasoi na ititounikaikinukuwo. Imo no lukaso nikomokaikinukuwo no, nonani imoyo yasoi ititounikaikinukuwo. ");
INSERT INTO amm_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Moi mo yowoi tomoso si manakinuwomo, yo mani, moiwoi tomoso tolokainoimo. Touwo mo asiso usukuna kono mo, a wamowoi no moloi si monoi? A-mai tanokaino mo waliyo, a wamowoi na tosi. Noinoso moi mani, yowoi tomoso si somiso mo, mi itouniyaimo no moloi ano monoi, moi no? Yowoi tomoso si manakinuwomo, mi itouniyaimo anoinuwomo, ititouni a touwo komiyai a wamowoi soinuwomo. ");
INSERT INTO amm_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Yo mo a komiyai. Moi mo yani touwo komiyai. Noko mo utukaimono mo, yani mi no moloi ano monoi? Nokosu mo yowoi tomoso tolokaino mo, itouniyaimo a touwo komiyai a wamowoi toloimo. Yo mo tolo tomasimo mo, wiyou, to mo mi itouniyaimo na tano. ");
INSERT INTO amm_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Noko mo asawoi tomoso tolokaino somiso mo, to mo touwo komiyai, nokoyo no afoli no, na samo samomokai. Touwo samo samo mo nokoyo tikokaiyalono, taso tutuno, tayo tofofouko. ");
INSERT INTO amm_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Yowoi tomoso si manakinuwomo, Apou Siyoliso na pa utolumowo, hani ano mulu monoi. Yani imo kwai itouniyaimakinuwomo, totayo anoninoinuwomo, nonani hani moiyo no utolumakinuwo no. ");
INSERT INTO amm_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Mi itouniyaimo anakinuwomo, ititouni a touwo komiyai a wamowoi soinuwomo. Mi mo ainoso anakinuwomo, noko nokolaloyo saino unoinuwomo, moi mo yani moloso taluwainuwo. No monoi no yani Apouni siyolo na kaluwaiyaloinomo. ");
INSERT INTO amm_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Apou Siyoliyo mulu tunumono. Noinoso yo mani, mulu tununukuwo. Yo mo moi mulu nokota, asawoi tomoso na pa sinonowo. ");
INSERT INTO amm_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Yo mo Apouni imo tukwai itouniyaimomoi. No monoi no mulu tunumonomoi. Noinoso moi mani, yani imo kwai itouniyaimakinuwomo, mulu na unu manoikuwomo. ");
INSERT INTO amm_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ni timonukuwo no, no mo afonimaiso pa timonukuwoso. Moiyo yo komiyai moloki si monoi na timonukuwo. Yo komiyai molokiyakinuwomo, moini mulu mo moloki saso. ");
INSERT INTO amm_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Yani imo ami na pukwaimonowo. Mulu na pa ukuwanowo. Ya no tomulu ununukuwo no, noinoso na pa mulu ukuwanowo. ");
INSERT INTO amm_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Noko mo wolitono iyali monoi kalo ukakimo, to mo wolitono iyali mulu mo siyoli, wiyouwa wiyou. Mulu uku no mo, noko siyayo no moloi souwai monoi? ");
INSERT INTO amm_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Yani imoso kwai itouniyaimakinuwomo, yani woli iyali na kolaloikuwomo. ");
INSERT INTO amm_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Toku mo mi anomono noko kolalikinukuwo. Ulai mi anononi nokota mo noko siyolini mulu mo sai muwoi. Momaisu mo sai, yani mulu mo. Apouyo no imonoki no, yasoi na imokinukuwo. No monoi no woli iyali na tokolalinukuwo. ");
INSERT INTO amm_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Moiyo muwomonokaiwoi muwoi. Asayo na muwokomokaikinukuwo. Mi itouniyaimo anano monoi muwokomokaikinukuwo. Mi itouniyaimo anakinuwomo, ititouni a komiyai a wamowoi soinuwomo. Nonani mi ano monoi muwokomokaikinukuwo. No mo afonimai mi muwoi, aniyopa poi poi na tanoimo. No monoi no hani ano monoi Apou Siyoliso utolumakinuwomo, nonani hani totayo na anoninoinuwomo, mulumolo luwaimonakinuwomo. ");
INSERT INTO amm_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Yani imo ami na pukwaimonowo. Mulu na pa ukuwano manowo.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Ulai ikoki, Isiso mo, “Asi asi noko nokolaloyo mulu atolokomo unakinuwomo, noiyo fufolikomoiwo, yo mani, tokusai ainoso lolaiwoi mulu na tatolokomo unumonono. ");
INSERT INTO amm_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Asini moloso paluwainuwo mo, toiyo mulu pununuwo, woli iyali pokolalinuwo, toiyo. Ulai yo muwokomokaikinukuwo, toini mulumaiso koliyo fukinukuwo. No monoi no mulu tatolokomo ununuwo, asi asi noko nokolaloyo. ");
INSERT INTO amm_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ya no imonukuwo no, noiyo fufolikomoiwo, noino. Mi anononi nokotayo no totani samuku nokota no moloi souwai monoi? Uo nokoyo na tuwomonono. Noinoso moiso mani, uwokomoinuwomo. Yani imo kwai noko, toi mo moini imo mani, na kwaikomo itouniyaimoinuwomo. ");
INSERT INTO amm_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Na tomulumolo luwaimononuwo, no monoi no noko mo uwokaikomoinuwomo. Toi mo imono taikiyo nokota monoi mo sai muwoi. Toi mo sosoli. ");
INSERT INTO amm_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Yo mo ika kono somiso mo, Kotoyo molo koiyau foli monoi pa piyomuso. Ulai yo mo na ika konoki. Toi no moloi iyamo monoi, “Koi mo molo koiyau aluwai noko muwoi.” ");
INSERT INTO amm_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Noko mo mulu atolokomo unumono mo, yani Apou monoi mani, mulu atolokomo unu. ");
INSERT INTO amm_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Mi ya no analoki no, noko siyayo no moloi ano monoi? Yo noko nokolaloni molo timai ano somiso mo, Kotoyo molo koiyau foli monoi pa piyomuso. Ulai yapoli na kwaimonokino, mulu ifolaluwawoi mi anoso. Waliyo mulumolokowoi muwoi, mulu tatolokomo unumokono, Apou koti monoi. ");
INSERT INTO amm_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","No mo afonimaiso muwoi, aniyopatono imo amiyo motu fiyamosi monoi, imo no tiyomuko unumono no, noino, “Afonimaiso mulu atolokomo unumonokino.” ");
INSERT INTO amm_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Noko fasiko nokota siya mo yo mo Apou Siyolini ausai imo taikiyoimo. To mo Kota Koto wiyotiyoimo, noko nokolaloso. Tani siyolo mo Kotoni Mulu Itouniyaimo Nokota. Apou Siyolini ausai amukonakimo, asa monoi na posasoko wiyotiyoimo, noko nokolaloso. ");
INSERT INTO amm_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Momai mani, na pa posasoko wiyotiyalowo. Tokusai ainoso lolaiwoi na tosi tomasimomononuwo, no monoi no.” Isiso mo ainoso na ikoki, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ikoki mo; Isiso mo na ikoki, “Yo mo wiyou tiyomu, moiyo namoliyo alosimomono mo, no monoi no mo ninani hani komaso monoi na timonukuwo. ");
INSERT INTO amm_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Noko mo lotu nufaso ti monoi alukikomoinuwomo. Wiyouwa wiyou, nokoyo tukuwoliyakinuwomo, iyamoimo, Kotoni mi anowo. ");
INSERT INTO amm_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Apou Siyoli kotiso aluwaimokowoi muwoi, no monoi no uwokaikomoinuwomo. ");
INSERT INTO amm_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Uwokomakinuwomo, yani imo noiyo fufolikomoiwo, imo ni tikikomonukuwo no. Toku ninani monoi pa imokinukuwoso, ya potolo fasikomokinukuwo, no monoi no.” Isiso mo aino ikoki. ");
INSERT INTO amm_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Ikoki mo; ti monoi na ikoki, “Ulai yo mo aumoifaso utukaimoikuwomo, imono taikiyo nokotani auso ifou na amiyoimo. Ulai hani monoi pa timononuwoso, “Moiso tomanoni?” ");
INSERT INTO amm_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","A, yani imo monoi no mulu no yau yau, moi no? ");
INSERT INTO amm_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Motu na timonukuwo, moi fasikomo monoi utukaimoikuwomo. Moiso utukaimo somiso mo, noko fasiko nokota siya mo pa amukonoiso. Utukaimakinukuwomo, yo mo toso na imo taikiyoimo, “Na pofasika kono.” ");
INSERT INTO amm_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","11","Ta amukonakimo, asi asi noko nokolaloso ikikoimo, na ikoimo, “Hani monoi molo koiyauso taluwainuwo?” To mo aino ikoimo, ulai moloi fowa monoi, noko nokolaloyo no? Pa tomulumolo luwaimononoso, no monoi no. To mo asa monoi na ika konoimo, “Mulu ititounikai nokotaso no hani monoi pa tomulumolo luwainuwoso?” To mo aino ikoimo, ulai moloi fowa monoi, noko nokolaloyo no? Fowawoi muwoi. Ulai afonimaiso? Yo mo Apou Siyolini auso amiyoimo, toiso wiyoti monoi, totayo imono taikiyo. Uwofa kimonoinuwomo. Fasiko nokota no mo na ika konoimo, “Hani monoi tiyamonuwo, “Molo koiyau foli monoi pa uwomokoiso.” To mo asi asi noko nokolaloso aino ikoimo, ulai moloi fowa monoi, toi no? Fowawoi muwoi. Ulai afonimaiso? Toi samukuko nokota koiyau monoi mo Kotoyo yasoi yomukaiki, molo koiyau foli monoi imo mo. No monoi no.” Aino na ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Ikoki mo; ulai ikoki, “Yo mo isoiso louwa timonukuwo. Ulai konoimai moi no moloi saino itouniyaimo monoi? ");
INSERT INTO amm_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Ulai Kotoni Mulu Itouniyaimo Nokota mo na amukonoimo, Kota Koto wiyoti nokota mo. Amukonakimo, na aiyolokomo manoinuwomo, imo motu komaso mo. Totani muluyosu imo lukasowoi muwoi. Kotoni imo no tukwaimomoi no, nonani imo saso na lukaso nikomoinuwomo. Amuwoi tinoso no fiyamosokaki no, nonani hani na posasoko wiyononinoinuwomo. ");
INSERT INTO amm_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Asani imo posasoko wiyononinoinuwomo. No monoi no asani siyolo kaluwaiyaloinuwomo. ");
INSERT INTO amm_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Apou Siyoli koti mo mulu mo tomoso. No monoi no timonukuwo, noino, Kotoni Mulu Itouniyaimo Nokota mo asani imo posasoko wiyononinoinuwomo.” Isiso mo siyokutono iyaliso aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Ikoki mo; ulai ikoki, “Aumoifaso uwofa kimonoinuwomo, ainoso ainoso ainoso; nosai no fokufaso ti monoi na kimonoinuwomo.” Isiso mo aino na ikoki, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Nosai no mo; siyai mo ikuwanokino, “Imo folosai no moloi woi? Moloi monoi timoko, “Aumoifaso uwofa kimonoinuwomo.” Moloi monoi timoko, “Nosai no fokufaso ti monoi kimonoinuwomo.” Moloi monoi timoko, “Yo mo Apou Siyolini auso amiyoimo.” ");
INSERT INTO amm_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Noino ikuwano manokino, “Imo folosai no moloi woi? Aumoifaso na toi, moloi monoi yomu, woi? Tani imo mo koi mo sai muwoi, koi mo sosoli.” Siyokutono iyali mo aino ikuwano manokino. ");
INSERT INTO amm_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Isiso mo sai, toi mo utolumo monoi louwa, no monoi no ikoki, “A, yani imo folosai monoi tikuwanonuwo. Yo mo noino imonukuwo, “Aumoifaso uwofa kimonoinuwomo.” Nosai no mo noino imonukuwo, “Nosai no fokufaso ti monoi kimonoinuwomo.” Nakomo moi mo ninani imo folosai mo sai muwoi. ");
INSERT INTO amm_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Motuwa na timonukuwo. Na sosonunoinuwomo, sonukumonoinuwomo. Asi asi noko nokolaloyosu molokiyoinomo. Mulu mo kolikaliyoinuwomo. Ulai nosai no mo; wiyouwa wiyou, na molokiyoinuwomo. ");
INSERT INTO amm_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Moloi si? Noniyo alufa toki mo, mulu tokaloso, iyanoko monoi. Nosai no mo; siso uwai; iyanoko pa tomulumolokoso. Ulai afonimaiso? Alufa na toki. Siyoliso na tomoloki. ");
INSERT INTO amm_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Moi mani, noinoso na. Konoimai mo mulu tokolikalinuwo. Ulai yo mo ti monoi na kiya tumoikuwomo, nosai no siyoliso na molokimomonoinuwomo. Nonani moloki siyoli no nokoyo no moloi alukikomo monoi? Wiyou, na moloki si manoinuwomo. ");
INSERT INTO amm_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Nomai no asaso pa utolumomonoinuwoso. Motuwa na timonukuwo. Mulumolo luwaimono nokota mo hani ano monoi yani Apouso utolumakimo, to mo Apouyo na anoninoimo. ");
INSERT INTO amm_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Tokusai ainoso lolai Apouso pa imo manokinuwoso, “Yo mo Isisoso tomulumolo luwai, no monoi no na pofasimono.” Na pa utolumo manowo. Haninoi monoi utolumakinuwomo, waliyo na anoinuwomo. No monoi no moini mulu mo moloki saso.” Isiso mo siyokutono iyaliso aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Isiso mo ikoki mo; ulai ikoki, “Siyokawi imo tolukasi manonukuwo. Aumoifaso na toi, siyokawi imo pa lukasoiso, ima imo na posasoko wiyononinoikuwomo, yani Apou monoi aino imo. ");
INSERT INTO amm_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nomai no mo, momaiyosu mo Apou Siyoliwoi imo lukasoinuwomo. Mulumolo luwaimono noko moiyo utolumakinuwomo, na kwaikomoinuwomo. Yo mo pa utolumo unoikuwoso, momaiyosu mo na utolumoinuwomo. ");
INSERT INTO amm_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Apou Siyoli mo moi mulu na. Ulai afonimaiso? Yo monoi mulu tunumononuwo, tomulumolo luwaimononuwo, tiyamonuwo, “Isiso mo Kotoni ausai amukonoki.” ");
INSERT INTO amm_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Tani ausai na amukonoki, yo mo. Asiso tola konoki. Ulai aumoifaso mo asiso utukaimoimo, Apou Siyolini auso ifou na amiyoimo.” Isiso mo ainoso na ikoki, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Nosai no mo; siyokutono iyali mo imokino, “Lolaimai mo siyokawi imo pa timokoniso, ima imo na timokoni. ");
INSERT INTO amm_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Lolaimai mo na tosainonoki, nono mo komaso hani hani sai yasoi. Wiyou, nokoni mulu mani, nono mo sai. Nokoyo imo yomu somisomai nono mo tani mulu mo sai. No monoi no tomulumolo luwainoki, tiyamonoki, “Kotoni ausai amukonokini.” ");
INSERT INTO amm_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ulai Isisoyo na ikoki, “Amiso poimo tomulumolo luwaimononuwo. ");
INSERT INTO amm_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Na pukwaimonowo. Aumoifaso mo uloloinuwomo, momaini nu fofamoso kiwawinoinuwomo. Na utukaimonoinuwomo, asaso mo amai toloimo. Ulai yo mo awi alu muwoi, yani Apouyo totolo fasimonomoi. ");
INSERT INTO amm_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ni timonukuwo no, no mo afonimaiso pa timonukuwoso. Moiyo mulu tomokiso si monoi na timonukuwo. Asimai simai hani haniyo tuwo manonuwo. Ulai mulu mo noiyo kolikaliyoiwo. Asa mo asini ami yasoi na souwaiki, no monoi no.” Isiso mo siyokutono iyaliso ainoso na ikoki. ");
INSERT INTO amm_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Nosai no mo; siyokutono iyaliso ikoki mo; nosai no mo kumokiso you foinalikoki, Kotowoi imo lukasoki, na imoki, “Apou, uwokaimono popo mo aumoifaso na toi. Lolaiso nali uwokaimonoinomo. Yo mo nani aununo na. Noko nokolaloso na powiyoti, yani ami siyoli mo. No monoi no yo mani, wiyotiyoimo, nani ami siyoli mo. ");
INSERT INTO amm_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Nonayo noinomo noko nokolalo komaso mo yani fona wosuwoimai tosimoi. No monoi nosu aniyopa poi poi tosi itouniyaimomoi, muwokokaimono noko nokolalo mo. ");
INSERT INTO amm_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Aniyopa poi poi si itouniyaimo noko mo sai, nono mo Kota Koto na. Isiso Kolaiso yo no imono taikiyokini no, asa monoi mani, toi mo sai. ");
INSERT INTO amm_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Noino imono taikiyokini, “Yani mi na pano fasimona kono.” Imono taikiyokini mo; ya na uwaimo taikiya konoki, nani mi mo. Nani ami siyoli mo asi asi noko nokolaloso yasoi wiyotiki, nani siyolo na tokaluwaiyalonoki. ");
INSERT INTO amm_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Yo mani, asi auwoniyouwoi muwoi, yo mo ami siyoliwoi nani auso yousikainoki, nani saponi siyoli yakomai. Apou, ifou na pokawiyo yomono.” Kotoso aino na imoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Kotoso imoki mo; ulai na imoki, “Yo mo nono monoi aino imo posasokoki. Asi asi noko nokolalo no muwokokaimonokini no, toiso posasoko wiyotiki, nona monoi aino imo mo. Toi mo nani noko nokolalo na, ulai na muwokokaimonokini. Nani imo na tukwai itouniyaimo manono. ");
INSERT INTO amm_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Lolaimai mo toi mo sai, imono taikiyokini mo. Ya no tiyalo no, no mo yani amiyo muwoi, nani amiyo nali no. Toi mo sai na. ");
INSERT INTO amm_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ulai afonimaiso? Nono mo imono taikiyokini, “Yani imo na pika kono.” Nonani imo ya ikalo manoki mo, na kwai itouniyaimo manokino. Na tosaino unumonono, nani ausai na amukonoki. Ulai sosoli, toi no? Imono taikiyokini mo, ainonani monoi mo waliyo tomulumolokono. ");
INSERT INTO amm_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Nonani noko iyali monoi ya tutolumonoki. Asi asi noko nokolalo monoi pa timonokiso. No muwokokaimonokini no, toi monoisu na timonoki. Toi mo nani noko iyali, no monoi no. ");
INSERT INTO amm_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Yani noko mo nani nali. Nani noko mani, asani nali. Toi mo yani ami siyoli towiyotino, noko nokolaloso. ");
INSERT INTO amm_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Yo mo fokufaso amai totolo, asiso, nosai no nani auso na amiyoimo. Toisu mo asimai amai si manoimo. Apou Siyoli, itouniyaima itouniyaimo nokota nono mo. Yoso mulumolo luwaimono noko na pa samukuko, nani amiyo. Toku no amonokini no, nonani amiyo samukukakinimo, mulu mo tomoso na soimo, momati komiyai. ");
INSERT INTO amm_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Yo tolo fasikomai nani amiyo tosamukukomoi, ami no mo, nonayo no amonokini no. Yani nainomai tosinono. Toi mo uwokaikowoi muwoi, na tosamiyaikiyono. Siyasu mo na sofuwamomonoimo, na uwokaiyoimo. No monoi no nani puko imoyo motu na fiyamosiyoimo, to monoi no tiyomuko no. ");
INSERT INTO amm_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Yo mo nani auso na tamiyo. Amiyowoi muwoi, asiso amai tolomai, nimai no toku na timonoki, toiyo moloki si monoi, yo komiyai. Moloki muluwoi saso na suomo. No monoi no timonoki. ");
INSERT INTO amm_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Muwokokaimono nokoso mo nani imo na iko manoki, yo mo. Wiyouwa wiyou, asi asi noko nokolaloyo mulu tatolokomo ukuno. Asini molo koiyauso pa taluwainoso, no monoi no. Asa mani, asini molo koiyauso pa taluwaiso. ");
INSERT INTO amm_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Yo mo pa timonokiso, “Asisai pokoliyo yo.” Aino pa timonokiso. Ulai na timonoki, “Uo nokota koiyau wai monoi na pa samukuko.” ");
INSERT INTO amm_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Toi mo asini molo koiyauso pa taluwainoso. Yo mani, pa taluwaiso. ");
INSERT INTO amm_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Nona amu monoi na pomuwokokai, nani noko si monoi. Nani imo motu na pa aiyolokomoi, amiso si monoi. No monoi no, ititouniyaso na soimo. ");
INSERT INTO amm_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Nonayo imono taikiyokini, “Asi asi nokoso pika kono.” Noinoso ya na iko taikiyoki, “Asi asi nokoso na pa ikalowo.” ");
INSERT INTO amm_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Asa amu tomuwokai, nono monoi. Toi fasiko monoi, asa amu tomuwokai. No monoi no toi mani, muwokokaiyoinimo, nani noko si monoi, ititouniyaso na soimo.” Kotoso aino na imoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Siyokutono iyali monoi Kotoso imoki mo; ulai na imoki, “Toi monoi saso pa timonokiso. Mulumolo luwaimono noko komaso noko monoi mani, na timonoki, yani woli iyaliyo no ikakino no. ");
INSERT INTO amm_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ya tiyomu, mulu mo tomoso suomo. Apou, nono mo totolo tomasimomononi. Yo mani, totolo tomasimonoki. Noinoso toi mani, mulu mo tomoso suomo. Motiwoi mani, si tomasimomokowumo. No monoi no asi asi noko nokolaloyo mulumolo luwaimonoinomo, iyamoimo, “Isiso mo Kotoyo imo taikiyoki.” ");
INSERT INTO amm_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ami siyoliwoi tolo monoi muwomonokaikini. Noinoso toi mani, asayo muwokokaiki, ami sisiyoliwoi si monoi. No monoi no toi mani, mulu tomoso soimo, momati komiyai. ");
INSERT INTO amm_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Asa mo totolo tomasiko. Nono mani, totolo tomasimomononi. Ya tiyomu, toi mo mulu mo tomoso suomo. Mulu fofamo si mo kwaimo muwoi. Mulu tomoso si mo waliyo. No monoi no asi asi noko nokolaloyo sainoinomo, nonayo imono taikiyokini. Mulumolo luwaimono noko monoi mulu tukuni, yo mulu no tunumononi no, noinoso na mulu tukuni. ");
INSERT INTO amm_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Apou, nono mo noko nokolalo na muwokokaimonokini. Yo mo tiyomu, asani auso suomo. Ya utukaikakimo, toi mani, namolisai tuomo. Ami siyoliwoi toloso kwaimona yowumo. Wiyouwa wiyou, nani saponi siyoli yakomai yo na toloimo. Kumoki asi asi fonanikomowoi muwoi, nono mo muwomonokaikini, ami siyoliwoi tolo monoi. Mulu unumono monoi, na muwomonokaikini, no monoi no. ");
INSERT INTO amm_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Apou Siyoli, nono mo imo tiyomuni mo, motu imo saso tiyomuni. Asi asi noko mo nono monoi saino itouniyaimowoi muwoi. Toi mo sosoli. Asasu mo sai. Mulumolo luwaimono noko mani, toi mo sai. Toi mo sai, imono taikiyokini mo. ");
INSERT INTO amm_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Yo mo nono monoi aino imo na posasoko wiyotiki. Siyai mo amai na posasoko wiyotiyoimo. No monoi no toi mani, noko nokolalo mulu ukoinomo. Mulu no tunumononi no, noinoso toi mani, mulu na ukuwumo. Yo mo toiwoi tolo mulu na tiyo.” Kotoso aino na imoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Nosai no mo; Kotowoi imo lukaso uwai; Isiso iyali mo sauki, nuki. Nuki; Kitolo iwoso. Ausaimiso mo oli a wamo isi tu tanoki. Tokosiyaiyo tikino, isiso na tiki. ");
INSERT INTO amm_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Uo nokoni auso kiyoko nokota Yutaso, to mo nonani isi mo sai. Isiso iyaliyo saiso saiso pukouniyaiko mosikino. ");
INSERT INTO amm_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","No monoi no mo, nonani isiso na tumoki. Polimano noko iyali na koliyo tumoki, polimano noko iyaliwoi nokotalo iyalini mi anoti nokowoi. Mi anoti noko mo lotu samukuko nokowoi Falisi moloso aluwai nokowoi toiyo no iko taikiyokino no. Yutaso mo na koliyo tumoki. Toni lamowoi na kuloli tolika tumokino, kutalo tawoi lamu tawoi. ");
INSERT INTO amm_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Nosai no mo; Isiso mo na ikoki, “Noi tikoliya tumonuwo?” To mo sai, haniyo uwo mo. Amunoki, na ikoki, “Noi tikoliya tumonuwo?” ");
INSERT INTO amm_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Nosai no toiyo, “Isiso, Nasolito nokota.” “Asasu,” na ikoki, Isiso mo. Uo nokoni auso kiyoko nokota Yutaso, to mani, tolo tomasikoki. ");
INSERT INTO amm_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Isiso mo ikoki mo, “Asasu”, toi mo ifou asiyonuwanoki, na usukunalo konoki. ");
INSERT INTO amm_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ulai ikoki, “Noi tikoliya tumonuwo?” Ulai imokino, “Isiso Nasolito nokota tikoliya tumonoki.” ");
INSERT INTO amm_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Nosai no mo na ikoki, “Yasoi imonukuwo, asasu mo. Na kimona tumonuwo, yani woli iyali tofolo na nuwu.” ");
INSERT INTO amm_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Isiso mo aino ikoki, tani imoyo motu fiyamosi monoi, toku no yomukaiki no, noino, “Noko yoso no muwokokaimonokini no, toi mo uwokaikowoi muwoi, asani nainomai tosi.” ");
INSERT INTO amm_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Nosai no mo; Saimo Pita, to mo muwo sopowoi komi toli toloki mo, na kusomoniyouki, nokoni iyoso na tokoso kukiyowaiki, nainasai iyoso. Nokoni siyolo mo Malokaso, totawoi lotu samukuko nokota siyolini mi ano nokota na. ");
INSERT INTO amm_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ulai Isiso mo Pitaso na imoki, “Muwo sopo ifou na panali. Apou Siyolini imo no moloi kulali monoi, yo no? Nokoyo uwokaimono monoi na imono taikiyoki.” ");
INSERT INTO amm_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Nosai no mo; na komikaikino. Isiso mo na komikaikino, polimano noko iyaliwoi totawoi polimanotawoi Yuto noko sisiyolini mi anoti nokowoi. Na konosuwakaikino, ");
INSERT INTO amm_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Anasoni auso kiyomanokino, Kaiyofani amokitononi auso. Isiso tukolomai Kaiyofa mo totawoi lotu samukuko nokota siyoli. ");
INSERT INTO amm_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Nonani nokota mo Yuto noko sisiyoliso toku yasoi ikikokaiki, “Noko siyayo noko nokolalo kwalomai monoi kalo ukakimo, no mo waliyo.” ");
INSERT INTO amm_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Isiso mo polimano iyaliyo kominalomanokino mo; Pita noko ti mo tanokokino, Saimo Pitawoi siyokutono siyawoi. Nonani siyokutono mo totawoi lotu samukuko nokota siyoliyo sai, no monoi no tani kokikokai poiso tanokalo tiki. ");
INSERT INTO amm_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pitasu mo itu lotisai fu fou toloki. Siyokutono mo lotu samukuko nokota sai, no monoi no ifou lofuki, itu samuku nukonuso isoki, “Yo no woli no waliyo tokawiyo ti?” Aino isoki, nosai no Pita kawiyo tiki. ");
INSERT INTO amm_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ulai itu samuku nukonuyo Pitaso na imoki, “Nakomo nono mani, nu poiso tu tolo nokotani siyokutono na.” Ulai Pita mo na isoki, “Ya muwoi.” ");
INSERT INTO amm_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Fulomu nali, ta yolikaikino. Ta asi siki, mi ano nokowoi polimano nokowoi. Pita mani, toini auso toloki, ta asiki. ");
INSERT INTO amm_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Nosai no mo; totawoi lotu samukuko nokota siyoli mo Isisoso utolumaloki, “Nani siyokuno iyali no noiwo noko? Hani imo paiyoloko manani?” ");
INSERT INTO amm_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ulai Isiso mo, “Yo mo wosu woso imo pa iko manokiso. Noko nokolaloni molo timaisoso imo lukasikalo manoki, yo mo. Lotu nu lolofawoi lotu nu siyolimaiwoi, nosoni saso yo paiyoloko manoki, Yuto nokoyo ukouniyaikomosimai. ");
INSERT INTO amm_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Hani monoi timononi? Noko nokolaloso na pikano. Toi mo sai, ya no ikoki no.” Noko siyoliso aino imoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Imoki mo; nosai no polimanotayo na ifasiyaimoki. Tani auso tolokainoki, na ifasiyaimoki, imoki, “Siyoli nokotaso aino noiyo imoi. To mo lotu samukuko nokota siyoli na.” ");
INSERT INTO amm_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ulai Isisoyo imoki, “Yani imo mo koiyauso kwaimononi mo, ti monoi na piyomu unumono. Imo motu imoso yomu mo, hani monoi ifasiyaimomononi?” ");
INSERT INTO amm_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Anasoyo Isiso mo kiyomokaiki, Kaiyofani auso. Na konosuwakaiki, kiyomokaiki, totawoi lotu samukuko nokota siyolini auso. ");
INSERT INTO amm_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Nomai no mo, Saimo Pita mo tamai amai asi tolokainoki. Ta amai asi tolokainoki mo, nokoyo na imokino, “Nakomo nono mani, tani siyokutono na.” Ulai Pitayo, “Topokonuwo, yo muwoi.” ");
INSERT INTO amm_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ulai noko siyayo na imoki, “Isimaisu na kwainoki, tani auso toloso. Motu na piyomu.” Ainoso imoki, nokoyo. Nonani nokota mo totawoi lotu samukuko nokota siyolini mi anononi nokota. Iyo tokoso kukiyowai nokotani nako tomo. Pitayo iyo no tokoso kukiyowaiki no, totani nako tomoso nokota na. Nonani nokota mo Pitaso na imoki, “Isimaiso yo kwainoki, tani auso toloso.” ");
INSERT INTO amm_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ulai Pita mo na yomuki, “Topokoni.” Nosai no kokaloyo imo na yomuki. ");
INSERT INTO amm_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Nosai no mo; Yuto noko sisiyoliyo Isiso mo kominalomanokino, Kaiyofani ausai, komano nokota siyolini nu siyoliso na kiya tikino, Lomo nokotani nuso. Posasi na. No monoi no totaiyo nu poiso tiwoi muwoi. Ulai afonimaiso? Yuto noko mo noko nokonu nokoni nuso ti mo au au. Piyamoki, “Noko nokonu nokoni nuso tinoki mo, Pasowa koloni no konoiso no moloi wasi monoi, koi no?” ");
INSERT INTO amm_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","No monoi no mo, noko nokonu nokota siyoli no mo, tani siyolo mo Pailato, to mo lofuki. Na ika fuki, “Hani foli monoi tofaumimona tumonuwo?” ");
INSERT INTO amm_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Nosai no mo na imokino, “Uo nokota mo nani nainoso na tokiyoma tumonoki.” ");
INSERT INTO amm_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ulai Pailato mo ikoki, “Momaiyosu mo uo foli imo na polukasokaiyanowo, moini aniyopano imoyosu.” Ulai toi mo imokino, “Tukolo imo no moloi iyamo monoi, koi no? Au au na. Wiyou imo yasoi imokokinuwo.” ");
INSERT INTO amm_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ainoso imokino. No mo afonimaiso muwoi, Isisoni imoyo motu fiyamosi monoi, toku no yomuki no, tota tukolo monoi, noino, “A mokiso akaimona yoinomo.” ");
INSERT INTO amm_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Nosai no mo; Pailato mo nu siyoli poiso ifou lotiki, Isisoso na aliyoniki, loti monoi. Lotiki mo, Isisoso na imoki, “A, nono no Yuto noko nokolalo samukuko nokota siyoli na?” ");
INSERT INTO amm_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Nosai no mo; Isisoyo mo Pailatoso na imoki, “Noko siyayo poimo imoni, o, nonayosu poimo tiyomuni.” ");
INSERT INTO amm_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ulai Pailatoyo imoki, “Yoi, yo mo Yuto nokota muwoi. Lotu samukuko noko sisiyoliyo na kawiyo tumoni, nani asi nokoyo nali no. Hani foli monoi?” ");
INSERT INTO amm_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Nosai no mo; Isisoyo na imoki, “Yo mo asi asi samukuko noko sisiyoli komiyai muwoi. Toi komiyai posamukuko mo, Yuto noko sisiyoliso pa pokiyomonoso, mi anomono nokoyo na pitomimonono. Noko nokolalo ya no tosamukuko no, toi mo asimai sinono noko muwoi.” ");
INSERT INTO amm_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Pailatoyo imoki, “A, nono no noko nokolalo no yapoli na tosamukukoni?” Isiso mo na imoki, “Nasu, motu na tiyomuni. Noko nokolalo samukuko monoi na amukonoki, asiso. Imo motu imo posasoko monoi anoiyo na kimonoki. Noko mo motuwa motu imo monoi mulu yo mo, to mo yani imoso kwaimono itouniyaimo.” Isiso mo Pailatoso aino na imoki. ");
INSERT INTO amm_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ulai Pailatoyo yomuki, “Motuwa motu imo mo hani imo poimo.” Nosai no mo; imoki mo; Yuto noko sisiyolini auso ifou lofuki, na ika fuki, “To mo hani mo yowoi muwoi. Asa no uo foli monoi no moloi yomu monoi? ");
INSERT INTO amm_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ya tiyomu, na tokiyo. Pasowa koloni wasi popomai yo mo kalopulo noko siyasonuso tokolali uku taikiyomosi, moini auso. A, Yuto noko moi samukukomo nokota siyoliso kiyo taikiyo monoi tiyonuwo?” ");
INSERT INTO amm_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ulai toiyo imokino, “Totaso muwoi.” Siyoliso na imokino, “Totaso muwoi. Palopasoso na pokiyo, koini auso.” Ainoso na imokino, Palopasoso kiyo monoi. Nonani nokota mo uo nokota siyoli. ");
INSERT INTO amm_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Nosai no mo; Pailatoyo Isiso mo kiyokoki, polimano nokoso, na ikoki, “Moloyo na puwasowo.” Ikoki mo; na wasokino, polimano noko mo. ");
INSERT INTO amm_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Na alisiyolikino, yoku mo suwoi suwoi moloso poiyakimo unukino, no monoi no asisikaikomokino, komuso. Nakiyaiso tuno itouniyaimoyo na asisikaimokino, siyoli nokotani tuno na. ");
INSERT INTO amm_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Tani auso ifou ifou nuwaloki, na alisiyoliyalokino, imalokino, “Oi, woli, Yuto noko nokolalo samukuko nokota siyoli, nona kuo.” Aino alisiyoliyalokino, amu molosai na waso manokino. ");
INSERT INTO amm_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Nosai no mo; Pailato ulai ifou lofuki, na ika fuki, Yuto noko sisiyoliso, “Na pukwaimonowo. Moini auso tokawiyo funo, nokoyo. No monoi no na pa sainowo, to mo hani mo yowoi muwoi. Yo no uo foli monoi no moloi yomu monoi?” ");
INSERT INTO amm_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ikoki mo; Isiso mo na lofuki, suwoi suwoi yokuwoi nakiyaiso tuno sopowoi asisikaikomokaiyo fuki. Nosai no Pailato mo na ikoki, “Na pokiwo, ni tolo.” ");
INSERT INTO amm_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Ulai imokino, siyoliso na iyamaloki, “A mokimai na pukou ukou nikomokaiwo.” Lotu samukuko noko sisiyoli nokowoi toini mi anoti nokowoi, toi mo Isiso lofuso kwaikino, siyoliso na iyamo taikiyoki, “A mokimai na pukou ukou nikomokaiwo.” Ulai Pailato mo ikoki, “Momaiyosu na pokauwo, a mokimai na pukou ukou nikomokaiwo. Asa no uo foli monoi no moloi yomu monoi? To mo hani mo yowoi muwoi.” Aino ikoki, Pailato mo. ");
INSERT INTO amm_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Ulai Yuto noko sisiyoli mo na imokino, “Koini aniyopa imo amiyo tiyomuko, “Na potukolowo.” Tota amu monoi piyomuki, Kotoni awitonowo. Nonani kukamokokai foli monoi na kalumo.” ");
INSERT INTO amm_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Wiyou, Pailato mo nonani imo kwaiki mo, kokolo mulu mo siyoli, wiyou na. ");
INSERT INTO amm_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Nu siyoli poiso ifou lotiki, Isisoso ima tiki, na imoki, “Moisai tumokini?” Isisosu mo fowawoi muwoi, wosu woso na toloki. ");
INSERT INTO amm_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Nosai no Pailatoyo imoki, “Hani monoi fowamonowoi muwoi? Yani fiyo wosuwoimai na totoloni. Ya yomakimo, “Na pokiyowo,” nokoyo na kiyoinimo. Ulai ya yomakimo, “A mokimai pukou ukou nikomokaiwo,” nokoyo na tukoloinimo. Nonayo piyomu.” ");
INSERT INTO amm_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ulai Isisoyo mo imoki, “Koto totayo noinomo nani fiyo wosuwoimai yo totolo. Nonani kumoki tolomu nokotayo mo uo nokoso palukiko mo, nani fiyo wosuwoimai pa potoloso, yo mo. No monoi no nani uo mo koufasu. Nani auso kiyomono nokota, totani uo mo wiyou, siyoliso na uwoyoimo.” Isiso mo ainoso na imoki, Pailatoso. ");
INSERT INTO amm_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Nosai no mo; Pailato mo na louwa kiyoki, louwa kiyo manoki. Yuto noko sisiyolisu mo amai imalokino, siyoliso na imalokino, “Kiyakinimo, nono mo Lomo nokota siyoli Sisini wolitono muwoi. Noko siyayo yomakimo, “Yo mo noko nokolalo samukuko nokota siyoli,” to mo Sisini imo kulaliyoimo.” ");
INSERT INTO amm_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pailato mo nonani imo kwaiki mo, kiyowoi muwoi, nokoso ikoki, “Isiso pokausiya tiwo.” Aino ikoki, imo kwai monoi na yousanoki, tomoki tofu tofu nukutaimaiso. Nonani nukutai mo Hipolu imosai mo pokaluwai manokino, Kapota, Yuto nokoni imosai. Imo folosai mo Tomoki Tofu Tofu Nukutai. ");
INSERT INTO amm_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Pasowa sipo koloni foukai ulo, ulo yakomai mo Pailato mo imo kwai yousanoki. Yuto noko sisiyoliso na ikoki, “Moi samukukomo nokota siyoli na pokiwo.” ");
INSERT INTO amm_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Ulai siyoliso na imalokino, “Na pokauwo. Na pokauwo. A mokimai na pukou ukou nikomanowo.” Ulai Pailatoyo ikoki, “A, moi samukukomo nokota siyoli no a mokimai ukou ukou nikomo monoi na tiyamonuwo?” Toiyo imokino, “Koi mo samukumoko nokota mo siyasu, Lomo nokota siyoli Sisi saso.” Aino imokino, lotu samukuko noko sisiyoli nokoyo mo. ");
INSERT INTO amm_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Nosai no mo; Pailato mo polimano nokoso na ikoki, “Na pokauwo. A mokimai na pukou ukou nikomanowo.” Nosai no mo; polimano iyali mo Isiso mo na komi kaukino. ");
INSERT INTO amm_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Totani a moki na sokukiyo fuki, Kalokatoso. Hipolu imosai siyolo mo Kalokato, Yuto nokoni imosai na. Imo folosai mo noino, Komu Foli Yu. ");
INSERT INTO amm_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Na ukou ukou nikomokino, a mokimai. Noko tiwoi mani, ukou ukou nikokino, a moki a tiso. Isiso mo mulumai akaiya yokino. Noko siya mo nainasai. Siya mo sokonisai. ");
INSERT INTO amm_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Nosai no mo; Pailatoyo nokoso imoki, “Tani siyolo amai pokumo, pa akaiya yo, a mokiso.” Imoki mo; na kumoki, a mokiso akaiya yoki. Noino na yomukokaiki, “Isiso, Nasolito nokota, Yuto noko nokolalo samukuko nokota siyoli.” ");
INSERT INTO amm_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yuto noko molopoiyo ti liyai manoki, ku na you kokokino. A mokimai ukou ukou nikomokai mo aluwamai muwoi, nokonu siyoli mo aumoifaso. No monoi no noko molopoiyo ti liyai manoki, kuso you kokokino. Nonani ku mo taumai kulukaiki, Hipolu imosai, no mo Yuto nokoni imo, Lomo nokoni imowoi Koliko nokoni imosaiwoi. ");
INSERT INTO amm_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ulai Yuto noko sisiyoliyo Pailatoso imanokino, “Yuto noko nokolalo samukuko nokota siyoli noiyo kumoi. Tota amu monoi yomu, Yuto noko nokolalo samukuko nokota siyoliwo. Ainoso na pokumo.” No mo Yuto noko sisiyoli siyaiyo Pailatoso aino imokino, lotu samukuko noko sisiyoli nokoyo. ");
INSERT INTO amm_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Ulai Pailatoyo ikoki, “Tofolo, yo mo yasoi na kumokai.” ");
INSERT INTO amm_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Nosai no mo; polimano iyali mo Isiso a mokimai ukou ukou nikomokaikino mo, tani tuno totai amu na waukino. Toku yasoi asi uwokino. Tuno mo toitatimai kunolokokaikino, kunolokokai siyasonuso totai amu waukino. Pau tuno sopo saso mo amai. Nonani tuno mo topolimo somiso tuno, komaso na aya liyoukino. Puwosai ayalo konokino. ");
INSERT INTO amm_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Nonani tuno monoi ikuwanokino, “Tuno itouniyaimo nali. Noiyo poliyaliyaikoiwo. Tomoki lolofayo niya tosomaimo unukoni. Souwaimoko nokotayo anumo.” Aino na ikuwanokino. No mo afonimaiso muwoi, Kotoni puko imoyo motu fiyamosi monoi, Isiso monoi no tiyomuko unu no, noino, “Yani tuno wau ukuwanokino. Tuno sopo monoi na somaimo unukino.” Kotoni puko imoyo aino na tiyomuko. ");
INSERT INTO amm_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Isisoni atino iyali mo a moki aumoifaso posiki. Atinowoi atino siya Moili Kolopani noniwoi. Moili siya Makotalo nukonuwoi, toi mo aumoifaso na siki. ");
INSERT INTO amm_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Tani siyokutono itouniyaimo mani, potoloki, atinoni auso. Isiso mo toti ku tolokainoso kwaikoki mo, atinoso na isoki, “Anoi, nani aununo na poki.” Ainoso na iso unuki, totani siyokutono itouniyaimo monoi. ");
INSERT INTO amm_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Isoki mo; nosai no siyokutonoso na imoki, “Anoniso na pokoso.” No monoi no mo, nonani siyokutonoyo totani nuso na kausoki, nou niso monoi. ");
INSERT INTO amm_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Nosai no Isiso mo sai, tani mi mo uwai. No monoi no mo, na yomuki, “Yo mo iwo nukuwa tuwomono.” Afonimaiso pa yomukiso, Kotoni puko imoyo motu fiyamosi monoi na yomuki. ");
INSERT INTO amm_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Nau ku tasoki, itolo iwowoi. Nosai no somu somuyo solikaikokino, nokoyo, a sokumai na konosuwakokaikino, puwoso monoi na akiyo yokino, Isisoyo iwo moto motomuwako monoi. ");
INSERT INTO amm_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Nosai no mo; sikoki mo; Isiso mo na yomuki, “Yani mi mo uwai.” Yomuki mo; nosai no mo komu mo na usumiyo konoki, mulu mo futo, yau. ");
INSERT INTO amm_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Isiso kalomai mo koloni foukai ulo. Mi fou fouko ulo siyoli mo amuwoisai, no monoi no Yuto noko sisiyoliyo wiyou iyamoki noko yau yau a mokimai amai si mo, mi fou fouko ulomai mo. Pailatoso imanokino, “Koi mo tiyamonoki, a moki nokoni foto tofu uwoko monoi, somaiso kolikali monoi. Yau yau na iyo konowumo.” ");
INSERT INTO amm_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Pailatoyo yomuki, “Waliyo na.” Nosai no mo; polimano noko mo nokoni foto tofu uwokanokino. Isisowoi ukou ukou nikomokai tomasi nokota tini fotoso toku tofu uwokokino. Toku mo noko siyaso. Nosai no siya mani, tofu uwokino. ");
INSERT INTO amm_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ulai nosai no mo; Isisoni foto tiso louwa tofu uwokino. Ulai yau, yasoi na kaloki, no monoi no tofu uwowoi muwoi, ");
INSERT INTO amm_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","maiyosu na tukoliyonoki. Polimano nokotayo tani amolisai na tukoliyonoki, maiyo. Wiyou, lolai siyaso nakowoi iwowoi na amukonoki. ");
INSERT INTO amm_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Noko mo na kiki, no monoi no toposasoko. Imo motu na toposasoko. To mo sai, imo motu na. Moiso toposasoko wiyononinuwo, moiyo mani, waliyo mulumolo luwai monoi. ");
INSERT INTO amm_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","A moki nokota aino uwoki mo, no mo afonimaiso muwoi, Kotoni puko imoyo motu fiyamosi monoi nali no, no tiyomuko no, noino, “Tani mi mo pa tofu uwoyoinoso, loliso amai soimo.” ");
INSERT INTO amm_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Noko siyayo mani, toku kumokaiki, Kotoni pukoso, noino, “Maiyo tukoliyono nokotaso na you kiyoinomo.” Aino na tiyomuko, Kotoni puko imoyo mo. ");
INSERT INTO amm_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Nosai no mo; Yusifo, Alimatiyo nokota mo Pailatoso imanoki, na imoki, “Yo mo Isiso yau totokomonano, ai unano monoi.” Yusifo mo Isisoni moloso aluwai nokota na, wosu woso paluwai manoki. Yuto noko sisiyoli monoi kokolomoki, no monoi no. Nonani nokota mo Pailatoso imanoki, “Isiso yau ya ai unoimo.” Nosai no Pailatoyo imoki, “Waliyo na.” Imoki mo; nosai no Yusifo mo yasoi, Isiso yau mo ana tumoki. ");
INSERT INTO amm_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikotimo mani, aluwainiyo tumoki, Isisoso toku no kiyanoki no, amolokimai, nonani nokota mani, aluwainiyo tumoki. Aliyoli akiyo tumoki, inoso woti komutoiya wotiwoi. Aliyoli sokukiyo tumoki, wiyou, muwoli mo sisiyoli. ");
INSERT INTO amm_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Nonani noko ti mo Isiso yau na tokomona yokino, tuno sopo sopoyo na yalokonokino, aliyoliwoi. Noko yau yau aiko ukumai Yuto nokoyo aino piyo manokino. ");
INSERT INTO amm_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","A moki aumoifaso mo yu asi i na tanoki, isimaiso. Nonani yu asi i poiso noko yau toku akaiwoi muwoi, tonofalo nali. ");
INSERT INTO amm_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","No monoi no to yau na akaiya tikino, nonani yu asi iso. Yuto nokoni Pasowa koloni foukai ulo na, no monoi no Yusifo noko ti mo somaiso na akaiya tikino, aumoifa yu asi iso no mo. ");
INSERT INTO amm_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Nosai no mo; tinosai somosaiyamai, folosu mo amai, nomai no mo, Moili mo ai unu asi iso na manosoki, Makotalo nukonuyo mo. Yu asi i mo tumosoki mo, ai unu i ufiyaimo tomoki mo kolalikaiso na kiya tumoki. ");
INSERT INTO amm_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Nosai no mo; namoli ifouso monoi fumosanoki, Saimo Pita noko ti mo na ika tumoki, Saimo Pitawoi Isisoni siyokutono itouniyaimowoiso. Totiso na ika tumoki, “Oi, Noko Siyoli yau mo yasoi na alomanono. Yu asi i mo yau mo uwofa na kinoki. Koi mo sai muwoi, moiso monoi poimo alomanono. Koi mo sosoli.” ");
INSERT INTO amm_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ikoki mo; na amufukino, ai unu moloso monoi na manokino, Pita noko ti mo. ");
INSERT INTO amm_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Fufumuwanoki. Pitaso na souwaiki, siyokutonoyo mo. Toku na fiyamosiya tumoki, ai unuso. ");
INSERT INTO amm_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Na tu luluwaiki, tuno saso siso tu kokoki. Asi i poiso mo lotiwoi muwoi. ");
INSERT INTO amm_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Nosai no Saimo Pita, namolisai no tumoki mo, to mo na lotiki, asi iso. To mani, tuno siso na kokoki. ");
INSERT INTO amm_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Komumai yalokono tuno mani, na kiki. Tuno sopo sopo kwasai tanowoi muwoi, siyasai na tanoki, ikomokai. ");
INSERT INTO amm_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Nosai no toku fuma tumo nokota mani, na lotiki. Nonani siyokutono mo uwofa kiyaloki mo, na mulumolokoki, “Yausai na auwoniyou.” ");
INSERT INTO amm_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Isiso yausai auwoniyou monoi na, ainonani monoi mo Kotoni puko imoyo na tiyomuko. Totisu mo sai muwoi, nonani imo folosai mo, amai. ");
INSERT INTO amm_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Tuno kokokino mo; nuso ifou manokino. ");
INSERT INTO amm_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Moili mo yu asi iso fu soni tolosoki. Na sinaloki, na tu luluwaiki, yu asi iso na tu kiki. ");
INSERT INTO amm_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Oi, Kotoni kumoki noko tiso na tu kokoki, kumoki nokota ti tu yousiso. Wiyouwa wiyou, tuno kamo kamowoi. Isiso yau akokai kwalomai tu yousikainokino. Siya mo komusai. Siya mo fona tisai. ");
INSERT INTO amm_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Nonani noko ti mo na isokino, “Woli, hani monoi tosonini?” Moili mo, “Yani Noko Siyoli yau na alomanono. Yo mo sai muwoi, moiso poi alomanono.” Moili mo ainoso ikoki. ");
INSERT INTO amm_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ikoki mo; na alosiki, namoli moloso monoi na kiki, noko tolokainoso. Isiso mo na tolokusa tumoki. Ulai noni mo sai muwoi, piyomusoki, noko siyawo. ");
INSERT INTO amm_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Na isoki, “Woli, hani monoi tosonini? Noiso tikolini?” Isiso mo aino na isoki, ulai noni mo piyomusoki, isi samuku nokotawo. Na imoki, “Woli, na poimo alomanoni mo, na pimono, moiso akaiyanoni. Yo mo ananoimo.” ");
INSERT INTO amm_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ulai Isiso mo totani siyolo na kaluwaisoki, “Moili.” Na alosimoki, na imoki, “Laponi.” Yuto nokoni imosai na imoki, “Laponi,” Hipolu imosai. Nonani imo folosai mo aiyolokomomoko nokota. ");
INSERT INTO amm_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Nosai no mo; Isiso mo na isoki, “Noiyo komikaimonoi. Yo mo Apou Siyolini auso amai amiyoimo, no monoi no. Ulai yani woli iyaliso noinoso na pikano. Yo mo Apouni auso ifou amiyoimo. To mo yani Apou saso muwoi, momaini Apou na. Yani Koto saso muwoi, momaini Koto na.” Aino na isoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Nosai no mo; Moili, Makotalo nukonu mo imo posasokanoki. Isisoni siyokutono iyaliso na ikoki, “Yo mo Noko Siyoliso yasoi na ki.” Aino ikoki. Isisoyo no isoki no, nonani imo mani, na ikoki. ");
INSERT INTO amm_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Nosai no mo; amolokimai Isisoni siyokutono iyali mo nuso ukouniyaikokaiki. Itu mo na asikaikino. Yuto noko sisiyoli monoi kokolokoki, no monoi no. Ulai Isiso mo na tolo tomasika tiki, na ika tiki, “Mulu tomokiso na posiwo.” ");
INSERT INTO amm_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Aino na ikoki. Ikoki mo; nosai no naino ti uluo na wiyolukoki, amoli uluowoi na wiyotiki. Wiyouwa wiyou, Noko Siyoliso kikino mo, siyoliso na molokimokino. ");
INSERT INTO amm_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ulai na ikoki, “Mulu tomokiso na posiwo. Apou Siyoliyo imono taikiyoki, “Noko nokolaloni auso na pamukono.” Noinoso yo mani, na timo taikiyonukuwo, “Noko nokolaloso na pikalowo.” Isiso mo siyokutono iyaliso aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ikoki mo; na ufosikoki, na ikoki, “Kotoni Mulu Itouniyaimo Nokota mo ya na tanoninukuwo, fuo. ");
INSERT INTO amm_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Moiyo noko siyaso imo futo popomuwa somiso mo, Koto mani, pa popomuwayoiso, imo mo amai, molo koiyau monoi imo mo. Moisu mo popomuwayakinuwomo, Koto mani, imo mo futo nali no, molo koiyau monoi imo mo.” Isiso mo siyokutono iyaliso aino na ikoki. ");
INSERT INTO amm_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Isisoyo siyokutono iyaliso koka tumomai Tomo mo toiwoi yousiwoi muwoi. Noko molo tiwoi mulumai nokota na. Siyolo siya mo Titimaso. Nonani siyolo imo folosai mo noino, atinoyo komu tiwoi kokoki. ");
INSERT INTO amm_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","No monoi no siyokutono iyaliyo imokino, “Siyoli Nokota mo yasoi na kinoki.” Ulai Tomoyo, “Topokonuwo. Naino uluo koko somiso mo, waliyo pa mulumolo luwaiyoiso. Naino muwoyo mo simosiyo iso loti somiso mo, waliyo pa mulumolo luwaiyoiso. Nainoyo amoli uluo muluso noimo somiso mo, waliyo pa mulumolo luwaiyoiso.” ");
INSERT INTO amm_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nosai no mo; amoloki nano siya, 7 mo uwai; nomai no mo nuso ti monoi ukouniyaikoki. Tomo mani, na yousi tomasikoki. Itu mo na asikaikino. Itu asikaikino mo, ulai Isiso mo na tolo tomasika tiki, na ika tiki, “Mulu tomokiso na posiwo.” ");
INSERT INTO amm_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tomoso na imoki, “Naino muwoyo na pokomimono. Na pokoko, yani naino tiso. Nainoyo na ponoimo taikiyo, amoli uluoso na ponoimomono. Mulu tiwoi noiyo yoi. Na pomulumolo luwaimono.” ");
INSERT INTO amm_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Nosai no mo; Tomoyo na imoki, “Nono mo yani Siyoli Nokota na, yani Koto nali no.” ");
INSERT INTO amm_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Nosai no mo; Isiso mo na imoki, “A, tomulumolo luwaimononi? A, kimono monoi tomulumolo luwaimononi? Kimono somiso noko mo mulumolo luwaimonakinomo, toi mo siyoliso na molokiyoinomo.” Aino na imoki, Tomoso mo. ");
INSERT INTO amm_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Isiso mo mulu ifolaluwawoi mi na pano manoki, siyokutono iyalini molo timai. Mi siyai monoi ninani pukoso mo kuluwoi muwoi. Pounu pa kulukiso. ");
INSERT INTO amm_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Mi siyai monoisoso niya kulukai, moiyo Isisoso mulumolo luwai monoi, Kolaisoso, noko no mo Kotoyo no muwokaiki no, noko nokolalo moi fasikomomoka tumo monoi, Kotoni awitono nali. Nonani nokotaso mulumolo luwaiyakinuwomo, aniyopa poi poi na si itouniyaimo manoinuwomo. Ulai afonimaiso? Tani ami mo siyoli na. ");
INSERT INTO amm_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Nosai no mo; ulai na koka tumoki. Isiso mo siyokutono iyaliso ulai na koka tumoki, Taipiliyo iwo toku ilomai. Noino koka tumoki. ");
INSERT INTO amm_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Isisoni siyokutono iyali sinonoki. Saimo Pitawoi Tomo Titimasowoi, Titimaso imo folosai mo noino, atinoyo komu tiwoi kokoki, towoi na, Nataniyalowoi, Kano nokonu nokota, Kalili asimai no tanoki no, towoi na, Sipitini awitono noko tiwoi, toi sinonoki. Siyokutono noko ti mani, toini auso yousikainokino. ");
INSERT INTO amm_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Nosai no mo; Saimo Pita mo ikoki, “Yo mo la tokuowano.” Toiyo, “Koi mani, na taluwainoki.” Nosai no mo yasoi; ayou alomakokino. Kuowalo manokino kuowalo manokino, posasi; la mo iwoi muwoi, uwofa. ");
INSERT INTO amm_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Posasi; nosai no mo; Isiso mo na toloki, upoiso. Ulai siyokutono iyali mo sai muwoi, Isiso mo, piyamoki, noko siyawo. ");
INSERT INTO amm_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Siyoliso na tu ikoki, “Woli iyali, a, la no uwofa? A, la no iwoi muwoi, moi no?” Imokino, “Nasu, la mo iwoi muwoi, uwofa na.” ");
INSERT INTO amm_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Nosai no mo; na tu ikoki, “La imo mo nainasai na pokukiyo taikiyowo. No monoi no iyoinuwomo, la mo.” Aino na ikoki. Ikoki mo; la imo mo na kukiyo taikiyokino, wiyou, imo mo la saso, molopoi mo wiyou. La imo no ayou poiso no moloi akiyo yo monoi? ");
INSERT INTO amm_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Nosai no mo; Isisoni siyokutono itouniyaimoyo imoki, Pitaso, “Noko anu tu tolo mo, to mo moini Noko Siyoli nali.” Imoki mo; Saimo Pita mo tolauki, tani tuno sopo asisiki. Mi auwoniyoumai toku asiyokaiki. Tuno sopo asisiki mo, iwoso folamiyo konoki, upoiso sonaniyo tiki. ");
INSERT INTO amm_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Siyokutono iyali mo aluwaikino, ayou molosai, la imo mo namolisai na kiyo kiyo tumokino. Imo mo la saso. Upoi mo aluwamai muwoi, aumoifaso nali. ");
INSERT INTO amm_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Upoiso tiki mo, ta na kwaikino, la ta yoliso. Paluwa tuo mani, na tako. ");
INSERT INTO amm_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Nosai no mo; Isiso mo na ikoki, “La siyai na piyo tumowo, moiyo no inuwo no.” ");
INSERT INTO amm_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ikoki mo; Saimo Pitayo ayou poiso folamiyo konoki, la imo kiyo kiyo tumoki, upoiso. Imo mo la sisiyoli saso, 153, wiyouwa wiyou, ko kowaso. Ulai poliyaliyaikowoi muwoi, la imo mo. ");
INSERT INTO amm_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Nosai no mo; Isiso mo na ikoki, “Kuku, na pona tumowo.” Aino ikoki, ulai siyokutono iyali mo utolumo monoi nimokino. Utolumo monoi louwa, “Nono no noi?” Ulai utolumowoi muwoi, iyamoki, “Moini Noko Siyoli nali.” ");
INSERT INTO amm_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Nosai no mo; Isiso mo paluwa tuo iya tumoki, na wautiki. La mani, tomoso na. ");
INSERT INTO amm_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","No mo tau monoi nali koka tumoki. Yausai auwoniyou nokota mo tau monoi aino na koka tumoki, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Nosai no mo; no uwai; Isiso mo Saimo Pitaso na imoki, “Saimo, Iyononi awitono, a, mulu siyoliso tunumononi? A, nono no woli iyaliso tosouwaikoni?” Pitayo imoki, “Nono mo Noko Siyoli na. Nono mo sai, yo mo nona mulu na.” Nosai no Isiso mo na imoki, “Lolaloso mulumolo luwaimono noko nokolaloso na pa aiyoloko, sipo koloni uo komiyai nokoyo no tuwoliko no.” ");
INSERT INTO amm_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ulai ti monoi na imoki, Isisoyo mo, “Saimo, Iyononi awitono, a, nono no mulu tunumononi?” Nosai no Pitayo, “Nono mo Noko Siyoli na. Nono mo sai, yo mo nona mulu na.” Nosai no Isiso mo na imoki, “Mulumolo luwaimono noko nokolaloso na posamukuko, sipo koloni komiyai nokoyo no tosamukuko no.” ");
INSERT INTO amm_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ulai tau monoi na imoki, “Saimo, Iyononi awitono, a, nono no mulu tunumononi?” Tau monoi imoki, “Mulu tunumononi?” No monoi no Pita mo mulu mo yau, Isisoso na imoki, “Noko Siyoli, nono mo komaso hani hani mo sai. Nono mo sai, yo mo nona mulu na.” Nosai no Isisoyo mo na imoki, “Mulumolo luwaimono noko nokolaloso na pa aiyoloko, sipo koloni komiyai nokoyo no tuwoliko no. ");
INSERT INTO amm_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Motuwa na timonoki. Alu sokumai na popuwotolomosikini, nonani muluyoso poliyaiyalo manokini. Ulai noko waimai mo naino ti na akiyouwoinimo. Nokoyo konosuwakomo kaiyoinimo, na komi kauwoinimo. Mano monoi wiyou no yomakini no, nonani asiso na manoinimo.” ");
INSERT INTO amm_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Isiso mo ainoso na imoki. Ulai afonimaiso? Siyokawi imo na imoki, Pita tukolo monoi imo na. Pita tukolomai noko nokolaloyo Kotoni siyolo kaluwaiyalokino. Nosai no mo; imoki mo; Pitaso ulai na imoki, “Na paluwaimono.” ");
INSERT INTO amm_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Nosai no mo; Pita mo alosiki, namoli moloso kwaiki, Isisoni siyokutono itouniyaimoyo aluwaikoso. No mo noko no mo Isisoni auso toku no yousikainoki no, sipo koloni nomai. Toku yousikainoki mo, aumoifaso usosumi yousa tumoki, imoki, “Noko Siyoli, noiyo uo nokoni auso kiyoinimo?” ");
INSERT INTO amm_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Pita mo nonani nokotaso kiki mo, Isisoso imoki, “Noko Siyoli. To no moloi uwoyoinomo?” ");
INSERT INTO amm_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ulai fowaki, “No mo nani hani muwoi. Yani hani nali no. Yo ifou amukonakimo, to mo amai poi tolokainoi. Nonosu mo na pa aluwaimonomoi.” ");
INSERT INTO amm_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ainonani imo monoi imofa maliyali liyaiki. Mulumolo luwai nokoni auso imofa kolo koloma tumo liyaiki, “Noko no mo to mo kalo nokota muwoi.” Ulai Isiso mo pa yomukiso, kalo nokota muwoi, na yomuki, “Yo ifou amukonakimo, to mo amai poi tolokainoi. No mo nani hani muwoi, yani hani nali no.” ");
INSERT INTO amm_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Nonani nokotayosu mo Isiso monoi aino imo ni mo na toposasoko, na tokulukai. Koi mo sai, tani imo mo motu nali no. ");
INSERT INTO amm_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Isiso mo noisu noisu mi na panalo manoki. Siyai mo kuluwoi muwoi, siyaiso na kulukaiki. Ulai nokoyo tani mi ano monoi siyasonuso kulakimo, wiyouwa wiyou, ya tiyomu, asi asi mo puko saso, moiso isikokai monoi. ");
INSERT INTO amm_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Woli Tiyofila, yo mo nani puko na tokulunoninoki. Toku mo puko siya kulunonikinoki, Isiso aino imo puko, tani mi monoi. Isiso lolalosai no yo manoki no, no aiyoloko manoki no, ");
INSERT INTO amm_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ainoso hani Kotoyo kumokiso no kawiyo yoki no, nonani monoi toku kuluki. Toku mo siyokutono iyali muwokokaiki, Isiso mo, Kotoni imo lukasikalomano monoi. Kotoni Mulu Itouniyaimo Nokotayo tolo fasimai nonani nokoso imo amiso na lukasikoki, tani mi anononi monoi. Ainonani monoi toku yasoi kulunonikinoki, yo mo. ");
INSERT INTO amm_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Nosai no mo; Isiso mo uwokaikino mo; siyokutono iyaliso na kokanoki. Ulo ulo, 40, saiso saiso pokokanomosiki, imo polukasikanomosiki, Kotoyo samukumoko imo mo. No monoi no toi mo sai, yausai auwoniyouki mo, amai na tolo. ");
INSERT INTO amm_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Nosai no mo; tolo tomasikomai na ikikoki, “Yolusolimo nokonu siyoliso noiyo utukaimoiwo. Yani Apou mo toku yasoi yomukaiki, noko siyaso imo taikiyo monoi. Na pa foumowo. Yo mani, imo unukinukuwo. ");
INSERT INTO amm_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","No monoi no aumoifaso totani Mulu Itouniyaimo Nokotaso na imo taikiyoimo, momaini mulu poiso, muwokomokai monoi. Iyono totayo iwoso uluwakoki.” Aino ikoki, Isiso mo. ");
INSERT INTO amm_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Nosai no mo; ti monoi ukouniyaikoki mo, siyokutono iyali mo Isisoso imokino, “Noko Siyoli, a, lolai no Isolilo noko nokolalo koi no tosamukumoko toloni, moini aniyopa nokota siyoli komiyai?” ");
INSERT INTO amm_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Fowakoki, “No mo moini hani muwoi. Maniwoiso poimo, no mo Apou Siyolini hani na, totani muluyososu. ");
INSERT INTO amm_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Ulai na pukwaimonowo. Kotoni Mulu Itouniyaimo Nokota mo amukonoimo, amikoma konoinuwomo, momaini mulu poiso lotaloimo. No monoi no asa monoi aino imo posasoko wiyotiyaloinuwomo, Yolusolimo noko nokolalowoi Yutiya asi komaso noko nokolalowoi Somaliya asi noko nokolalowoiso ainoso hani asi asi noko nokolalo komasoso na posasoko wiyotiyaloinuwomo, asa monoi aino imo mo.” Isiso mo aino na ikoki, siyokutono iyaliso. ");
INSERT INTO amm_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Isiso mo nonani imo lukasiko uwai; totaini molo timai puwoso na amiyoki. Kumoki kopuyo ufiyaima konoki, uwofa na you kikino. ");
INSERT INTO amm_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Amai amiyo manoki mo, siyokutono iyali mo kumokiso pukwai siki, molo amiso. Ulai lolai siyaso noko ti mo toini auso na tolo tomasika tumokino. Totini tuno mo kamo kamoso na tolika tumokino. ");
INSERT INTO amm_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Na ikokino, “Kalili noko moi no kumokiso no hani monoi tukwailuwainuwo? Ninani Isiso mo Kotoyo kumokiso na kawiyo yowainuwo. Ulai to mo ifou mani, noinoso na amukonoimo, lolai ni tukwainuwo no, kumokiso amiyo molosai.” ");
INSERT INTO amm_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Nosai no mo; Isisoni siyokutono iyali mo yusai kunoki, Oli yusai. Yolusolimo nokonuso ifou nuki. Aluwamai muwoi, mi fou fouko ulomai waliyo no ponumosiki no, aumoifaso na. ");
INSERT INTO amm_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Nu mo tiki mo, nu komu wosuwoi nuso na yoki, no posimosiki no. Na sa yoki. Toini siyolo siyolo mo Pita, Iyono, Yamiso, Anotolu, Filipo, Tomo, Patolumiyo, Matiyu, Yamiso Alifiyani awitono, Saimo Siloto, Yutaso Yamiso siyani awitono. ");
INSERT INTO amm_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Nonani noko mo Kotowoi imo polukaso simosiki. Nokolalowoi Isisoni atino Moiliwoi auwatono iyaliwoi, toi mani, posi tomasikomosikino. ");
INSERT INTO amm_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Nosai no mo; Isisoso mulumolo luwai noko molopoi noko mani, sa tumoki, noko molopoi mo 120. Nosai no Pita mo na tolauki, na ikoki, ");
INSERT INTO amm_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Woli iyali, moini aniyopa Toiwiyo Kotoni pukoso toku kumokaiki, Kotoni Mulu Itouniyaimo Nokotani amiyo. Yutaso monoi kumokaiki, Isiso kausi nokoso wiyoti nokota monoi. No monoi no Kotoni puko imo mo motu na fiyamosiki, Toiwiyo toku no kumokaiki no. ");
INSERT INTO amm_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Yutaso, to mo koini imo lukasikalomano mi monoi toku muwokaiki, Isisoyo. Koini auso tolo tomasimomokoki.” Pita mo aino ikoki. ");
INSERT INTO amm_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ulai Yutaso mo uo noko fasikoki. Nonani foli monoi mo muwoni nikino. Muwoni nikino mo; asi suo suomokanoki, suo mo muwoni. Nosai no mo na usukunoki, nonani asimai mo, tani pautoso poliyaliyaiki, nomoli mo asiso usukunokoki. Yau. ");
INSERT INTO amm_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Nonani imo kolo kolomoki, Yolusolimo noko komaso nokoni auso. No monoi no asi mo Akilotamo asi pokaluwai manokino, toini imosai mo. Imo folosai mo noino, Nako Asi. ");
INSERT INTO amm_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Nosai no mo; Pita mo mulumolo luwai nokoso na ikoki, “No mo afonimaiso muwoi. Kotoni siyolo kaluwai si pukoyo tiyomuko, noino, “Ya tiyomu, tani nu mo nokoyo utukaimowumo. Noko uwofa koko monoi, moi mo.” Imo siya mo noino kumokaiki, “Noko siya mo tani mi kwalomai monoi anumo.” ");
INSERT INTO amm_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","No monoi no ya tiyomu, noko siya niya tomuwokaikoni. Iyonoyo noko uluwakosai ainoso hani Kotoyo kawiyo yoki mo, noko siyai mo na poliyai fasimokalo manokino, Isiso Siyoli koiwoi. Nonani nokoni mulumai nokota siya mo niya tomuwokaikoni, yausai auwoniyou aino imo posasoko fasimoko monoi.” Aino na ikoki, Pita mo. ");
INSERT INTO amm_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Nosai no mo; noko tiwoi kolalikino, Isisoso mulumolo luwai noko mo. Toi mulumai nokota ti na kolalikino. Noko siyani siyolo mo Yusifo, tani siyolo siya mo Pasopaso, siyolo siyasai mo Yasota. Noko siyani siyolo mo Matiyaso. ");
INSERT INTO amm_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Kolali uwai; nosai no Kotowoi imo na lukasokino, na imokino, “Noko Siyoli, nono mo nokoni mulu mo sai. No monoi no na powiyomoko, noiso muwokaini. ");
INSERT INTO amm_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Nonani nokota mo Yutasoni mi kwalomai monoi anoimo, nani imo lukasikalomano fasimokoimo. Yutaso, to mo nani miso utukaimoki, totani mulu koiyauso aluwai monoi yoki.” Mulumolo luwai noko mo ainoso imokino, Kotoso. ");
INSERT INTO amm_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Imokino mo; noko ti monoi na somaimo ukukino. Somaimo ukukino mo; Matiyasoyo mo souwaiki. No monoi no na muwokino, Kotoni imo lukasikalomano noko 11woi tolo fasiko monoi. ");
INSERT INTO amm_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Mi fou fouko ulo siya, Ponotikoso ulo pokaluwai manokino, nonani ulomai mo nuso ukouniyaikokaiki, Isisoso mulumolo luwai noko mo. ");
INSERT INTO amm_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Nosai no mo; lolai siyaso na umukoki, kumokisai na umuko taikiyoki. Moloi woi? Imonu siyolini umuko komiyai na kwaikino. Ukouniyaiko si nu mo umuko saso. ");
INSERT INTO amm_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ta i lolofa komiyai na kokalokino, imokaloso. Noko komaso nokoni auso fufoimuwanalo kono liyaiki, siyasonuso. ");
INSERT INTO amm_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Kotoni Mulu Itouniyaimo Nokota mo nokoni muluso amika konoki. Amika konoki mo; wiyouwa wiyou, asi asi nokoni imo folo folo imosai na lukasalokino, Kotoni Mulu Itouniyaimo Nokotani amiyo. ");
INSERT INTO amm_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Kotoni Mulu Itouniyaimo Nokota amukonomai, nomai no lotu aluwai noko molopoiyo Yolusolimo nokonu siyoliso posiki, Yuto noko na, asi asisai no ti liyaiki no. ");
INSERT INTO amm_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Nonani noko mo umukoso kwaikino mo, na ukouniyaika tumoki. Wiyouwa wiyou, naino foli iyo noko manokino. Ulai afonimaiso? Totaini imo folo folo imosai nokoyo lukasaloso kwaikalokino. ");
INSERT INTO amm_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Na kufaukaloki, mulumoloko manokino, iyamoki, “Moloi woi? Imo lukaso noko mo Kalili noko na. ");
INSERT INTO amm_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Moloi monoi woi? Momaini imo folo folo imosai na tukwaikalokoni. ");
INSERT INTO amm_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Moi mo imo tomoso muwoi, folo folo na. Moi siyai mo Patiyo noko, moi siyai mo Mitiyo noko, moi siyai mo Ilamo noko, moi siyai mo Misopotamiya nokowoi Yutiya nokowoi Kapotusiya nokowoi Ponato nokowoi Aisiya nokowoi ");
INSERT INTO amm_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Folikiya nokowoi Pamofiliya nokowoi Isipi nokowoi. Moi siyai mo Lipiyo asi noko, Sailini nokonu aumoifaso no tikikoni no. Moi siyai mo Lomo nokonusai awa tikikoni. ");
INSERT INTO amm_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Moi siyai mo Yuta Yuto noko, moi siyai mo noko nokonu noko, Yuto nokoni moloso no taluwaikoni no. Moi siyai mo Kolito noko, moi siyai mo Alapiya noko. Wiyouwa wiyou, momaini imo folo folo imosai na tukwaikalokoni, Kotoni mi siyoli monoi aino imo no toposasokalo manono no.” Aino iyamoki. ");
INSERT INTO amm_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Kufaukoki, na mulumoloko manokino, ikuwano manokino, “Ulai moloi monoi woi?” ");
INSERT INTO amm_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Noko siyaiyosu mo alisiyolikino, imo folo folo imosai lukasikalo nokoso, louwa iyamoki, “Iwo koiyauso yasoi sikono, tukwalu kwalukalo kuo.” ");
INSERT INTO amm_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Nosai no mo; Pita iyali sauki, noko molo tiwoi noko na. Pita mo imo siyoliso na ikauki, noko nokolaloso, “Woli iyali, Yuto nokowoi Yolusolimoso sa tumo nokowoi yani imo na pukwaimono itouniyaimowo. ");
INSERT INTO amm_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Hani monoi tiyamonuwo, kwalu kwalukomomoko imo no? Wiyou nali no. Somosai na. Iwo koiyau no somosaimai no moloi siko monoi? ");
INSERT INTO amm_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Ulai Kotoni mulu lukasiko nokota Yuwoloni imoyo lolaimai motu na tofiyamosi, toku no kumokaiki no, noino, ");
INSERT INTO amm_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Koto mo na tiyomu, “Asi fokumomaiso mo yani Mulu Itouniyaimo Nokota na ku ati taikiyoimo, noko nokolalo komasoso. No monoi no yani imo na posasokoinomo, aununo iyaliwoi atokino iyaliwoiyo. Moini alalo soku sokuso hani hani ya wiyolukoimo, solitonosai. Moini nokotalo iyali mani, solitonokoimo. ");
INSERT INTO amm_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Wiyou, mi anomono noko nokolaloso mani, ku atiyoimo, yani Mulu Itouniyaimo Nokota. Nasu, asi fokumakimo, nokowoi nokolalowoiso na ku atiyoimo. No monoi no yani imo na posasokoinomo. ");
INSERT INTO amm_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Yo mo mulu ifolaluwawoi mi na wiyolukaloimo, kumokisai. Asimaiso mani, analoimo, noko nokolaloni molo timai. Hani hani, nako, ta, tauku siyoliwoi na auwonoulu liyaiyoimo. ");
INSERT INTO amm_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ulo ta mo futo, amu mo nako komiyai wisiyonoimo. Nosai no mo, Siyoli Nokota mo na tumoimo. Wiyou, no mo ulukukumoso na. ");
INSERT INTO amm_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Nuwoi no noko mo Siyoli Nokotani siyolo kaluwaiyakimo, to mo na samiyaikiyoimo.” Toku nokotayo aino na kumokaiki.” ");
INSERT INTO amm_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Nosai no mo; Pita mo nonani imo lukasikoki mo; ti monoi na ikoki, “Woli iyali, Isolilo noko, yani imo na pukwaimonowo. Isiso, Nasolito nokota mo mulu ifolaluwawoi mi na panalo manoki, momaini molo timai. Wiyouwa wiyou, Kotoyo noinomo mi siyoli panalo manoki, momaini auso. No monoi no Kotoyo wiyononikinuwo, Isiso mo totayo yasoi muwokaiki mo. Momai mo sai. ");
INSERT INTO amm_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Noko no mo, to mo moiso kiyomo taikiyokinuwo, nokoyo. Ulai no mo afonimaiso muwoi, Kotoni muluyosu nali no. Kiyomo somisomai Koto mo sai. Momaiyosu na tukolokinuwo. Momaini muluyosu uo nokoyo a mokimai ukou ukou nikomokaikino, yau. ");
INSERT INTO amm_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ulai moloi ku tano monoi, yau asimai no? Wiyou nali no. Kotoyo yausai na lusikaiki, uwokai monoi na tosamiyaikiyo.” Pita mo aino na ikoki, noko nokolaloso. ");
INSERT INTO amm_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Nosai no mo; na ikoki, “Moini aniyopa Toiwiyo toku na kumo unuki, noino, “Siyoli Nokota yani auso tolokainoso kwaiki, yo mo. Yani naina nainosai na totolo fasimono. No monoi no pa tumanomomonoso. ");
INSERT INTO amm_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Yani mulu mo moloki saso, ulukukumo imo saso tolukaso. Kalomono mani, yo mo mulu mo waliyo, yo mo na tofou, na tomoloki tolo. ");
INSERT INTO amm_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ulai afonimaiso? Kalomonakimo, Aupoisolu Yuso pa kiyomonoiniso. Mulu tunumononi, pa utukaimonoiniso, pa popimomonoiso, yo mo. ");
INSERT INTO amm_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Yousi itouniyaimo molo na wiyomonokini. Nani auso yousakimo, wiyouwa wiyou, siyoliso molokimoikimo. Nonayo noinomo yani mulu mo moloki saso.” Aino toku kumokaiki, Toiwi mo.” ");
INSERT INTO amm_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pita mo Toiwini imo lukaso wiyotiki mo; nosai no mo; ulai ti monoi na ikoki, “Woli iyali, ima imo na timonukuwo, noino. Moini aniyopa, Toiwi mo tota amu monoi pa kumokiso, noko siya monoi na kumo unuki. Toiwi, tota mo kaloki, yau, yu asi iso na ai unukino. Nonani asi i mo amai niya toi. ");
INSERT INTO amm_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ulai Toiwi mo Kotoni mulu lukasiko nokota na, no monoi no to mo sai, Kotoyo auwolo unukaiki, imokaiki, “Asayo noinomo nani alisaino mo nona kwalomai monoi samukuko toloimo, noko nokolaloso.” ");
INSERT INTO amm_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Nonani imo yasoi kwaimoki mo; Toiwi mo namolisai fiyamosi monoi posasokoki, Kolaiso monoi, noko no mo Kotoyo no muwokaiki no, Isolilo noko nokolalo moi fasimoka tumo monoi. Na yomuki, noino, “Yausai na auwoniyouwoimo, Aupoisolu Yuso Kotoyo pa kiyokaiyoiso. Yau mo pa popimoiso.” Toiwi mo aino yomuki, ");
INSERT INTO amm_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Isiso monoi na yomuki, Isiso monoi nali. To mo yausai na lusikaiki, Kotoyo. Kokaini molo timai na kwaikinoki, koi komaso na. ");
INSERT INTO amm_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Yausai lusikaiki mo; Kotoyo kumokiso kawiyo yoki, tani auso, nainasai na tola yoki, noko siyoli na. No monoi no lolaimai mo tani Mulu Itouniyaimo Nokota na ku amoko, Apou Siyoliyo toku no imo unukaiki no. Ku amokoso ni tokimokalonuwo, imo folo folo imosai lukasoso na tukwai komomokalonuwo. ");
INSERT INTO amm_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Toiwi mo kumokiso pa amiyokiso. Noko siya monoi kumokaiki, “Siyoli Nokotayo yani Noko Siyoliso na imoki, “Yani nainasai na piyousikaino. ");
INSERT INTO amm_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Yousikaino manakinimo, ainoso hani nono uo noko mo nani fiyo wosuwoimai na soimo, yani amiyo.” Toiwiyo aino kumokaiki, ");
INSERT INTO amm_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","no monoi no ya timonukuwo, Isiso Siyoli monoi. Woli iyali, Isolilo noko nokolalo, yani imo na pukwaimono itouniyaimowo. Noko no mo, a mokimai no ukou ukou nikomokinuwo no, to mo Kolaiso Siyoli na, Kotoyo no muwokaiki no, Isolilo noko nokolalo moi fasimoka tumo monoi.” Noko nokolaloso aino na ikoki, Pita mo. ");
INSERT INTO amm_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Nosai no mo; ikoki mo; noko nokolalo mo mulu mo yau yau. Pita iyaliso na ikokino, “Woli iyali, moloi tiyonoki, woi?” ");
INSERT INTO amm_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Fowakoki, Pita mo, “Mulu na palosokalowo. Isiso Kolaisoso mulumolo luwaiyakinuwomo, iwoso na uluwayoikuwomo. No monoi no Koto mo molo koiyau monoi imo mo futo, totani Mulu Itouniyaimo Nokota na aninoinuwomo. ");
INSERT INTO amm_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Koto mo aniyopa iyali saso pa ikokaikiso, momaiwoi moini alisaino iyaliwoi monoi na yomukaiki. Noko nokonu noko monoi mani, na yomukaiki. Noko nokolalo komaso moini Koto Siyoliyo no aliyonikaki no, toi monoi mani, na yomukaiki.” Aino ikoki, Pitayo mo. ");
INSERT INTO amm_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Na posasoko wiyolukoki, na ikikoki, “Siyokuno iyalini molo koiyauso na putukaimowo.” ");
INSERT INTO amm_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Nosai no mo; noko siyai mo tani imo kwai itouniyaimokino, waliyo mulumolokokino. Kwaikino mo; Pita iyaliyo iwoso uluwakokino. No monoi no noko nokolalo molopoi molopoi, 3000, lolaloso si tomasika tumokino, Isisoso mulumolo luwai noko nokolalowoi. ");
INSERT INTO amm_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Nosai no mo; noko nokolalo tonofalo mo paiyoloko manokino, Kotoni imo lukasikalomano nokoyo. Wiyou pa iyamokiso. Mulu mo tomoso, toi mo. Pono nikuwanomosikino. Kotowoi imo polukasomosikino. ");
INSERT INTO amm_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Kotoni imo lukasikalomano nokoyo mulu ifolaluwawoi mi panalomosikino, noko nokolaloni molo timai. Wiyouwa wiyou, kwaikokino mo, na kokolokoki. ");
INSERT INTO amm_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Isisoso mulumolo luwai noko nokolalo komaso mo posi tomasikuwano manokino. Ilolu mani, tomoso na. ");
INSERT INTO amm_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Nuwoi siya mo iloluwoi asiwoi mo suo suomoko nokoso nikalokino, suo mo muwoni. Nonani muwoni mo ponikalo manokino, koloni ilolu somiso noko nokolaloso. ");
INSERT INTO amm_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ulo ulo, saiso saiso lotu nu siyoli nuso pukouniyaiko mosiki. Nu nuso tomoso pono nikuwano manokino. Wau ufolo muluwoi muwoi, ulukukumoso na pono nikuwano manokino. ");
INSERT INTO amm_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Kotoso pokisosomi manokino. Tolomu noko nokolalo mulu mo waliyo saso, toi monoi. Ulo ulo, saiso saiso Isisoso lolaloso mulumolo luwaiyalokino, noko nokolalo siyaiyo, na samiyaikiyo si tomasikoki. Noko Siyoliyo noinomo noko molopoi molopoi wiyou, na mulumolo luwaikino. ");
INSERT INTO amm_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Upimomai Yuto nokoyo Kotowoi imo polukasomosikino, saiso saiso. No monoi no Pita noko ti mani, lotu nuso imo lukasa yokino. Kotowoi imo lukasa yokino, Pitawoi Iyonowoi. ");
INSERT INTO amm_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Lotu nu siyoli itu loti siyamai mo noko piyousikainomosiki, fona nomolikomokai nokota na. Itu loti mo Ulukukumoso Itu Loti pokaluwai manokino. Atinoni nomoliwoisai fona nomolikomokai nali no. Ulo ulo, saiso saiso ponapoluniyo yomosikino, nokoyo. Muwoni monoi putolukomosiki, lotu nuso ti nokoso. ");
INSERT INTO amm_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Nosai no mo; Pita noko ti lotiso kwaikoki mo, na ikoki, “Muwoni na ponimonowo.” ");
INSERT INTO amm_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ikoki mo; Pita noko ti mo molo amiso kikino. Na imoki, Pitayo, “Na pokimoko.” ");
INSERT INTO amm_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Nosai no you kokoki, na mulumolokoki, “Muwoni na tonimonono.” ");
INSERT INTO amm_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ulai Pitayo, “Yo mo muwoni mo uwofa. Mulu ifolaluwawoi saso Kotoyo na amonoki. No monoi no na timonoki, Isiso Kolaiso Nasolito nokotani amiyo na potolau, na poliyai.” ");
INSERT INTO amm_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Aino na imoki, tani naina nainosai na kominiyouki. Wiyouwa wiyou, lolai siyaso fona mo ami ami. ");
INSERT INTO amm_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Na folamiyouki, na liyaiki, Pita noko tiso aluwaikiyo tiki, lotu nu siyoli poiso. Liyai manoki mo, na liyaiyaloki, tokai tokaimaloki, Kotoso na kisosomiyaloki. ");
INSERT INTO amm_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Noko nokolaloyo liyaiyaloso kwaikino, Kotoso kisosomi toloso. ");
INSERT INTO amm_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Moloi woi? Kufaukoki, na mulumoloko manokino, “Moloi woi? Muwoni utoluko nokota koiyau na, Ulukukumoso Itu Lotimai piyousikaino mana. Ulai moloi uwo, woi?” ");
INSERT INTO amm_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Itouniyaimokai nokota mo Pita noko tiso kulolaloki, Pitawoi Iyonowoiso. Amai kulolalo manoki mo, noko nokolalo mo fufumuwana tumoki. Na ukouniyaikokuka tumokino, lotu nu fulomu nuso, Solomononi Fulomu Nu no pokaluwaikino no. Naino foli iyo nokokino, na fufumuwana tumoki. ");
INSERT INTO amm_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Nosai no mo; Pita mo noko nokolaloso kokaloki, na ikoki, “Woli iyali, Isolilo noko, hani monoi tomulumolokalo manonuwo? Hani monoi molo amiso tukwaimokonuwo? Noko ni mo kotini amiyo pa toliyaiso. Ulai kotini mulu itouniyaimo muluyo pakoso toliyaiso. Wiyou nali no. ");
INSERT INTO amm_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Kotoyo Isisoni amiso na towiyononinuwo. Aniyopa iyali Apolofamowoi Isakowoi Yokopowoi, toini Kotoyo tani mi anononi nokota Isisoni ami na towiyononinuwo. Momaiyosu mo Isiso mo na kiyokinuwo, uo nokoni nainoso. Pailatoyo louwa kiyo taikiyoki mo, wiyou na iyamokinuwo. ");
INSERT INTO amm_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Molo itouniyaimoso aluwai kiyo nokota, Kotoyo no imo taikiyoki no, to monoi mo wiyou iyamokinuwo, Pailatoso imokinuwo, “Isiso muwoi, noko siya, noko tukolo nokota na pokiyomomoko.” ");
INSERT INTO amm_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","No monoi no momaiyo noinomo Isiso mo na tukolokino. Si itouniyaimo kiyo nokota na tukolokino, momaini muluyosu. Ulai Kotoyo na lusikaiki, yausai. Kokatini molo tiyo yasoi na kikinoki. ");
INSERT INTO amm_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ninani nokotaso na pokiwo. Moi mo sai yasoi tota mo. Afonimaiso itouniyaimokaiwoi muwoi, Isisoso mulumolo luwai monoi nali no. Noko itouniyaimo tolo, ulai afonimaiso? Isisoso mulumolo luwai monoi, no monoi no itouniyaimokai tolo, moini molo timai. ");
INSERT INTO amm_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Woli iyali, yo mo sai, moi mo sosoli, no monoi no Isisoso uwokinuwo. Noko sisiyoli mani, to monoi mo sai muwoi, sosoli. ");
INSERT INTO amm_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ulai afonimaiso pa uwokinuwoso, Kotoni imo motu fiyamosi monoi nali no, tani mulu lukasiko nokoyo toku no kulalokino no, to muwokai nokota monoi, noino, “Yani Kolaiso mo uwokaiyoinomo.” ");
INSERT INTO amm_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","No monoi no mo, mulu na palosokomowo, Kotoni molo itouniyaimoso na paluwaiwo. Ainoso yakinuwomo, to mo imo mo futo popomuwayoimo. ");
INSERT INTO amm_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Mulu mo ami amiwoi na soinuwomo, Noko Siyolini auso. Namolisai mo Kolaisoso ifou imo taikiyoimo, noko no mo, toku no muwokainonikinuwo no, Isolilo noko moi fasikoma tumo monoi. To mo Isiso nali. ");
INSERT INTO amm_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Kumokiso amai tiyou yousikainomoi, ainoso Kotoyo noinomo komaso hani hani tonufuwa uloloimo. No mo afonimaiso muwoi, toku yasoi yomukaiki, Koto mo. Tani mulu lukasiko noko ititouniyo ainonani monoi na kulalokino. ");
INSERT INTO amm_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","No monoi no moini aniyopa Musi mani, kumokaiki, toku no ikoki no, noino, “Yo mo Kotoni imo toposasokomoi. Noinoso noko siya mani, Koto Siyoliyo noinomo fiyamosiyoimo, tani imo posasoko monoi. Momaini alisai nali no fiyamosiyoimo. Tani imo noiyo kulaliyoiwo, na pa kwaimowo. ");
INSERT INTO amm_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Noko mo imo kwaimo somiso mo, siyokutono iyali utukaikumo, na uwokai.” Aino na kumokaiki, Musiyo, noko nokolaloso no ikoki no. ");
INSERT INTO amm_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Kotoni mulu lukasiko noko komaso noko, Samuwoilowoi ainoso hani namolisai nokowoi, toiyo lolai fiyamosi monoi na posasokalo liyai manokino. ");
INSERT INTO amm_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Aniyopa iyaliso no posasoko wiyolukokino no, no mo momai monoi mani, iyamokaiki. Kotoyo no auwolo ukukaiki no, no mo momai monoi mani. No monoi no moini aniyopa Apolofamoso na imoki, “Nani alisainoyo asi asi komaso noko nokolalo na fasikoimo.” ");
INSERT INTO amm_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","No monoi no mo, Kotoyo noinomo tani mi anononi nokota Isiso mo na fiyamosiki. Moini auso mo toku tumoki, na fasikoma tumokinuwo. Moi siyasonuso molo koiyauso utukaimo monoi na fasikoma tumokinuwo.” Aino na ikoki, Pita mo. ");
INSERT INTO amm_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita noko tiyo noko nokolaloso amai iko manokino mo, nokotalo iyali mo tiki, lotu samukuko nokowoi lotu nu polimano nokota siyoliwoi Satusi moloso aluwai nokowoi. ");
INSERT INTO amm_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Uo mulu na atoloka tumoki, totini imo monoi. Ulai afonimaiso? Kotoni imo lukasikalomano nokota ti mo noko nokolaloso aiyolokokino, ikokino, “Isiso mo yausai na auwoniyouki. Noinoso noko nokolalo mani, yau yausai auwonouloimo.” Aino iko manokino mo, ");
INSERT INTO amm_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","nokotalo iyaliyo na kuloli ilomanokino, Pitawoi Iyonowoiso. Kalopulo nuso na kiyokokino, iyamoki, “Upimo na toi, tofolo, amuwoiso.” ");
INSERT INTO amm_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Noko nokolalo molopoiyosu totini imo yasoi kwaikokino, Isisoso lolaloso na mulumolo luwaikino. No monoi no mulumolo luwai noko mo molopoi molopoi, 5000. ");
INSERT INTO amm_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Nosai no mo; amuwoisai Yuto noko sisiyoli mo Yolusolimo nokonu siyoliso ukouniyaikoki. Yuto noko samukuko nokowoi nokotalo iyaliwoi Musini imo sai sisiyoli nokowoi, toi mo ukouniyaikoki. ");
INSERT INTO amm_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Anaso mani, tumoki, totawoi lotu samukuko nokota siyoli mo. Kaiyofawoi Iyonowoi Alikosatowoi, toi mani, na tiki. Totawoi lotu samukuko nokota siyoli nokota koli, toi komaso si fasika tumokino. ");
INSERT INTO amm_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Nosai no mo Pita noko ti mo nokoyo toi mulumaiso koliyo tumokino, na ikokino, nokotalo iyaliyo mo, “Noiyo imo taikiyokinuwo? Noini amiyo uwonuwo?” ");
INSERT INTO amm_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ikokino mo; Pitani muluso amimoki, Kotoni Mulu Itouniyaimo Nokotayo, na fowakoki, “Apou iyali, noko sisiyoli, ");
INSERT INTO amm_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","a, noko koiyau nokota fasi foli monoi timokonuwo? A, itouniyaimokai monoi tutolumomokonuwo? ");
INSERT INTO amm_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Apou iyali, yani imo na pukwaimonowo. Isolilo noko komaso moi mani, yani imo na pukwaimonowo. Isisoni amiyosu waliyo na totolo, ninani nokota mo. Isiso Kolaiso, Nasolito nokota, totani amiyo waliyo na totolo, momaini molo timai. Ulai momaiyo Isiso mo a mokimai ukou ukou nikomokinuwo. Kotoyosu na lusikaiki, yausai. ");
INSERT INTO amm_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Motu na kumokaiki, toku nokoyo. Isiso monoi noino kumoki, siyokawi imo mo, “Nu kololi noko moiyo a moki mo afoli taikiyokinuwo, piyamokinuwo, afonimai a koiyauwo. Ulai nonani a moki mo na ikaiki, sopo i a na.” ");
INSERT INTO amm_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Motu nali no. Asi asi nokoyo noinomo moloi samiyaikiyo monoi, moi no? Toiyo noinomo samiyaikiyowoi muwoi, pa tosamiyaikiyokoniso. Isisoni amiyosu na tosamiyaikiyokoni. No monoi no Kotoni auso si itouniyaimo mano monoi.” Aino na ikoki, Pita mo. ");
INSERT INTO amm_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Nosai no mo; ikoki mo; noko sisiyoli mo mulumoloko manokino, “Ulai moloi monoi woi? Toti mo kokolokowoi muwoi, mulu mo ami amiso. Moloi tosainono, woi? Afonimai nokota ti na, sai nokoyo aiyolokowoi muwoi.” Mulumoloko manokino mo; na mulumolokokino, “Isisowoi liyai tomasimo manokino. No monoi no.” ");
INSERT INTO amm_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Totiso no moloi fowako monoi, noko sisiyoliyo no? Fona ti ititounikomokai nokotaso na kikino, totini auso waliyo toloso. ");
INSERT INTO amm_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","No monoi no mo, nokotalo iyali mo amiso ikokino, Pita noko tiso, “Na putukaimokowo.” Nosai no imo lukaso siki, ");
INSERT INTO amm_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ikuwanokino, “Moloi tiyokoni, woi, toti monoi no? Wiyou, mulu ifolaluwawoi mi yapoli na anano, Yolusolimo noko nokolaloni molo timai. Moi no wiyou no moloi iyamo monoi? ");
INSERT INTO amm_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ulai noko nokolalo tonufuwa nokoso ikalo mo wiyou. No monoi no totiso na tikikokoni, “Isiso aino imo noiyo ikaloiwo.” Imo mo aino lukasokaikino, nokotalo iyali mo. ");
INSERT INTO amm_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Nosai no mo; Pita noko tiso aliyonikokino, na louwa ikikokino, “Isiso aino imo noiyo posasoko manoiwo. Noko nokolaloso noiyo aiyolokaloiwo.” ");
INSERT INTO amm_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ulai Pita noko tiyo fowakokino, Pitawoi Iyonowoi, “Ulai kotiyo kwaimakinukuwomo, Kotoni imo na kulaliyoikimo. A, moiyo no moloi tomulumolokonuwo, a, Kotoni molo timai no waliyo? ");
INSERT INTO amm_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Kotini molo tiyo no kokokinoki no, imo no kwaimokinoki no, nonani aino imo niya toposasokalo manonoki.” ");
INSERT INTO amm_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Pita noko tiyo ikokino mo; noko sisiyoliyo ti monoi ikiko manokino, uo imo mo. Nosai no totiso ikokino, “Soi suwo, na pomanowo.” Aino ikokino, imo foli monoi pa uwokokinoso. Ulai afonimaiso? Noko nokolaloyo Kotoni siyolo kaluwaiyalokino, noko koiyau itouniyaimokai monoi. No monoi no. ");
INSERT INTO amm_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Noko no mo, Isisoni amiyo no itouniyaimokaiki no, noko nokolaloni molo timai, to mo alu muwoi, nokotalo na, aisamu mo 40. No monoi no noko nokolaloyo Kotoni siyolo kaluwaiyalokino. ");
INSERT INTO amm_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Nosai no mo; kiyokokino mo; Pita noko ti mo siyokutono iyalini auso manokino. Noko sisiyoliyo no ikikokino no, nonani imo ikanokino, siyokutono iyaliso, lotu samukuko noko sisiyoliwoi nokotalo iyaliwoiyo no ikikokino no, nonani imo na. ");
INSERT INTO amm_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Siyokutono iyali mo nonani imo kwaikino mo, Kotowoi imo na lukasokino. Mulu mo tomoso, na imokino, “Nono mo asi asi komaso asi samukuko nokota siyoli. Kumoki, asi asi, iwo na mulumolokokini, na auwonouluki. Kumokini hani haniwoi asini hani haniwoi iwoni hani haniwoi, komaso mo nonayo mulumolokokini, no monoi no auwonouluki. ");
INSERT INTO amm_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Koini aniyopa Toiwi, nani mi anononi nokota, to mo nani Mulu Itouniyaimo Nokotani amiyo toku na kumokaiki, noino, “Noko nokonu noko no uo mulu atoloko no hani monoi? Uo imo louwa lukaso si no hani monoi? ");
INSERT INTO amm_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Asi asi noko sisiyoli noko mo uo faiso monoi topuwotolono, na tukouniyaiko, Koto noko tiso na totukuwoliyanono, Koto Siyoliwoi totayo muwokai nokotawoi, totiso totukuwoliyanono, asi asi noko sisiyoli nokoyo mo.” Toiwiyo aino na kumokaiki. ");
INSERT INTO amm_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Motu na, noko mo ukouniyaikoki, uo imo lukaso unukaikino, Isiso monoi. Noko ti sisiyoli, Hilowoi Ponatiya Pailatowoi noko nokonu nokowoi Isolilo nokowoi, toi mo Yolusolimo nokonuso niya ukouniyaikoki. Uo imo iyamo unukaikino, nani mi anononi nokota Isiso itouniyaimo monoi, toku no muwokaikini no. ");
INSERT INTO amm_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Piyamoki, totaini muluyowo. Ulai nani muluyosu nali no, toku yasoi mulumolokokaikini, nani amiyosu. No monoi no uwokino. ");
INSERT INTO amm_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Noko Siyoli, koini imo na pukwaimoko. Noko sisiyoliyo uo imo imokoso yasoi na kwaikoni. Na pofasimoko. Nani mi anononi noko koini muluso na pamikomomoko, nani imo lukasikalo monoi. Wonikaluso aiko kokolokomomokoi. ");
INSERT INTO amm_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Nani imo lukasikalakinokimo, ai ai noko na pa kuloli, nani nainoyo, ititounikai monoi, nani Isiso itouniyaimoni amiyo. Mulu ifolaluwawoi mi na pano fasimokalo, noko nokolaloni molo timai, nani mi anononi nokota Isisoni amiyosu.” Isisoso mulumolo luwai noko mo aino na imokino, Kotoso. ");
INSERT INTO amm_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Imo lukaso uwai; ukouniyaiko nu mo nou nouyo komiyai umikoki. Kotoni Mulu Itouniyaimo Nokotayo totaini muluso amikaloki. Amikoki mo; Kotoni imo lukasikalokino, kokolokowoi muwoi, mulu mo ami amiso. ");
INSERT INTO amm_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Isisoso mulumolo luwai noko mo mulu mo tomoso. Ilolu monoi mani, wau folo muluwoi muwoi. Ilolu mo tomoso na. ");
INSERT INTO amm_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Kotoni imo lukasikalomano noko mo noko nokolaloso amai posasoko wiyoti manokino, iko manokino, “Isiso Siyoli mo yausai na auwoniyouki, koini molo timai.” Kotoyo siyoliso pofasiko manoki, Isisoso mulumolo luwai noko komaso nokoso. ");
INSERT INTO amm_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Siyai mo hani hani sofuwakowoi muwoi. Nuwoi noko mo suo suomoko nokoso awikalokino, suo mo muwoni. Asiwoi noko mani, tomoso na. Nonani muwoni iyo tumo liyaikino. ");
INSERT INTO amm_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","Kotoni imo lukasikalomano nokoni auso pisikokaiya tumomosikino, koloni ilolu somiso nokoso na ponikomosikino. ");
INSERT INTO amm_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Noinoso Yusifo mani, yoki. Siyolo siya mo Kotoni imo lukasikalomano nokoyo kaluwaikino, Panopaso. Imo folosai mo Hamukuko Nokota. To mo Saipolo nokota, Liwaini alisai. ");
INSERT INTO amm_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Nonani nokota mo asi kiyo nokota na. No monoi no asi mo suo suomoko nokotaso awimoki, suo mo muwoni. Nonani muwoni mo Kotoni imo lukasikalomano nokoni auso na iyo tumoki. ");
INSERT INTO amm_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ulai noko siya, tani siyolo mo Anonaiya, toti noniki, Sapailowoi, toti mani, asi mo suo suomoko nokotaso awimokino, suo mo muwoni. ");
INSERT INTO amm_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Awimokino mo; Anonaiya mo muwoni siyai wosu woso isikokaiki, totani auso. Noni mo sai. Siyaisu mo Kotoni imo lukasikalomano nokoni auso na iyo tumoki. ");
INSERT INTO amm_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ulai Pitayo imoki, “Anonaiya, hani monoi Sokolo Nokota Waini imo kwaimoni? Kotoni Mulu Itouniyaimo Nokotaso na tifoluwaini. Hani monoi asi muwoni siyai wosu woso isikokaikini? ");
INSERT INTO amm_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Asi awimo somisomai asi mo nani nali no. Asi awimokini mo; asi muwoni mani, nani muwoni na. Koiso muwoni nimoko monoi yakinimo, na pa nimoko. Wiyou yomakinimo, koi mo imowoi muwoi, tofolo. Ulai moloi monoi mulumolokokini, muwoni siyai wosu woso isikokai monoi no? Koi saso pa tifoluwaimokoniso. Koto mani, na tifoluwaini.” Pita mo aino na imoki, Anonaiyaso mo. ");
INSERT INTO amm_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Imoki mo; ulai Anonaiya mo na usukunoki, yau na kaloki. Nosai no alalo soku soku iyaliyo sauki, noko yau konosuwakaikino, tunoyo, na alomanokino, ai unanokino. Nonaninoi aino imo mo nokoyo posasokalokino. Wiyouwa wiyou, imofa no kwaikino no, siyoliso na kokolokoki. ");
INSERT INTO amm_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Nosai no mo; Anonaiya yau ai unukino mo; noni mo tumosoki. To mo sai muwoi, nokitono kalo mo. ");
INSERT INTO amm_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pita mo isoki, “A, moti no asi suo suomoko muwoni no noinoso na akonuwo?” Noni mo ifoluwaiki, na imoki, “Motu na, noinoso na.” ");
INSERT INTO amm_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Nosai no Pitayo, “Hani monoi Noko Siyolini Mulu Itouniyaimo Nokotaso louwa tifoluwainuwo, moti no? Na pukwaiko. Nani noko yau ai unu nokoni somoso na pukwaiko. Nono yau mani, noino na ana toinimo, aniyo foinimo.” Aino na isoki. ");
INSERT INTO amm_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Isoki mo; noni mo na usukunosoki, Pitani fokutonomai, yau na kalosoki. Alalo soku sokuyo nu poiso tiki mo, noni yau na kwaisokino, asiyo fukino, ai usanokino, nokitono yau kwamai. ");
INSERT INTO amm_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Wiyouwa wiyou, Isisoso mulumolo luwai noko nokolalo komasoyo kokolokoki. Imofa no kwaikino no, toi mani, siyoliso kokolokoki. ");
INSERT INTO amm_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Kotoni imo lukasikalomano noko mo mulu ifolaluwawoi mi panalo manokino, noko nokolaloni molo timai. Solomononi Fulomu Nuso pukouniyaikomosiki, Isisoso mulumolo luwai noko komasowoi. ");
INSERT INTO amm_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Mulumolo luwai somiso noko nokolaloyo pokisosomiko manokino. Ulai ukouniyaika tumo monoi nikokino. ");
INSERT INTO amm_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Noko nokolalo molopoi molopoi mo Siyoli Nokotaso mulumolo luwaiyalokino, nokowoi nokolalowoi. Lolaloso si tomasika tumokino, mulumolo luwai noko nokolalo siyaiwoi. ");
INSERT INTO amm_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","No monoi no mo, ai ai noko nokolalo mo na koliyo tumokino, nokoyo. Molomaiso isikokaiya tumokino, malomaiwoi kotisokomaiwoiso. Mulumolokokino, nokoyo, “Pita mo molosai liyaiyakimo, tani nayo poimo tumoi, ai ai nokoni auso mo.” ");
INSERT INTO amm_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Yolusolimo nokonu aumoifaso nokonu nokonu noko nokolalo mani, ukouniyaika tumo liyaiki. Ai ai nokowoi popuwa kopokoiyau nokowoi koliyo tumokino. Komaso mo ititounikai saso. ");
INSERT INTO amm_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Nosai no mo; totawoi lotu samukuko nokota siyoli tolauki. Siyokutono iyaliwoi sauki, Satusi moloso aluwai noko na. Foluwaliko mulu saso, toi mo, ");
INSERT INTO amm_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Kotoni imo lukasikalomano noko kolisanokino, kalopulo nuso na kiyokokino, noko kopokoiyau nokoni mulumaiso. ");
INSERT INTO amm_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ulai amolokimai, Noko Siyolini kumoki nokotayo kalopulo nu itu na kolala konoki. Kotoni imo lukasikalomano noko na koliyo fuki, ");
INSERT INTO amm_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","na ikoki, “Soi suwo, lotu nu siyoliso na ponuwo. Imo na poposasoko wiyotiyanowo, molo tonofalo molo aluwai imo mo.” Aino ikoki, kumoki nokotayo. ");
INSERT INTO amm_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ikoki mo; posasi; lotu nu siyoliso tiki, noko nokolaloso aiyoloka tikino. Nosai no mo; totawoi lotu samukuko nokota iyali mo tiki mo, nokotalo iyaliso aliyonikokino. Isolilo noko sisiyoli noko komaso noko aliyonikokino, ukouniyaiko monoi. Nosai no nokoso louwa iko taikiyokino, “Kalopulo noko na pokolisanowo.” ");
INSERT INTO amm_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Polimano nokoyo louwa kolisanokino. Ulai kalopulo nu poiso tiki mo, uwofa na kokokino. Ifou tiki, noko sisiyoli nokoso, na ika tumokino, ");
INSERT INTO amm_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Noko mo uwofa, woi. Kalopulo nu itu loti mo asikai. Samukuko nokoyo tofu si, itu loti kwamai. Ulai itu kolalinoki mo, noko mo uwofa na kokonoki, woi.” ");
INSERT INTO amm_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Nonani imo kwaikino mo, noko sisiyoli mo mulumoloko manokino, lotu nu polimano nokota siyoliwoi lotu samukuko noko sisiyoli nokowoi, toi mo mulumoloko manokino, iyamoki, “Moloi uwoko, woi?” ");
INSERT INTO amm_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Nosai no noko siyayo tumoki, na ika tumoki, “Kalopulo noko mo lotu nu siyoli poiso na totu si, noko nokolaloso taiyoloko si.” Aino ikoki, noko siyayo mo. ");
INSERT INTO amm_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Nosai no mo; polimano noko iyaliyo kolisanokino, wosu wososo. Uo uwokowoi muwoi, noko nokolalo monoi nikokino, iyamoki, “Wonikaluso tomoki salosomomokoinomo, aiko tukuwolimokoino.” ");
INSERT INTO amm_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Nosai no mo; polimano nokoyo Pita iyali mo koliyo tumokino mo; ikokino, “Nokotaloni molo timai na posiwo.” Nosai no totawoi lotu samukuko nokota siyoliyo louwa ikoki, ");
INSERT INTO amm_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Hani monoi tokulalimokonuwo? Na louwa ikimokinukuwo, “Isiso aino imo noiyo aiyolokoiwo.” Ulai hani monoi Yolusolimo noko nokolaloso taiyolokalo manonuwo? Hani monoi tofaumi unumokonuwo, tukolo foli monoi no?” ");
INSERT INTO amm_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ulai Pita iyaliyo fowakino, na ikokino, “Koi mo nokoni imo pa tukwaikonokiso, Kotoni imosu niya tukwaimonoki. ");
INSERT INTO amm_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Moiyo noinomo Isiso mo a mokimai ukou ukou nikomokaikino, yau. Ulai Kotoyo yausai na lusikaiki, aniyopa iyalini Kotoyosu. ");
INSERT INTO amm_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Kotoyo lusikaiki mo; totani auso kawiyo yoki, naina nainosai na tola yoki. Noko nokolalo samukuko nokota siyoli na. Samiyaikiyo kiyo nokota siyoli. Isolilo noko moi mulu alosokakikonimo, Koto mo molo koiyau monoi imo mo futo. ");
INSERT INTO amm_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Koini molo tiyo yasoi kikinoki. No monoi no toposasoko sinoki. Kotoni Mulu Itouniyaimo Nokotayo mani, noinoso na toposasoko. No mo Kotoyo atiki, totani imo kwai noko nokolaloso.” Pita iyaliyo aino na ikokino. ");
INSERT INTO amm_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Nosai no mo; Pita iyalini imo kwaikokino mo; wiyouwa wiyou, noko sisiyoli mo uo mulu mo sisiyoli, ta topi, tukuwoli monoi louwa. ");
INSERT INTO amm_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ulai noko siyoli siya, Falisi moloso aluwai nokota, tani siyolo mo Kamaliyalo, to mo tolauki. Musini imo aiyoloko nokota na, noko nokolaloyo no kisosomi manokino no. Nonani nokota mo nokotalo iyalini molo timai na tolauki, polimano nokoso ikoki, “Noko na pokoliyo fuwo, awa.” ");
INSERT INTO amm_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Koliyo fukino mo; nokotalo iyaliso na ikoki, “Woli iyali, Isolilo noko, atiyaiso, somaiso noiyo uwokoiwo. Awi, toku na pomulumoloko itouniyaimowo. ");
INSERT INTO amm_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Tino noko siya, tani siyolo mo Tiyuta, tota amu monoi piyomuki, noko siyoliwo. Noko molopoi nokoyo, 400, aluwaikino. Ulai nokoyo tukolokino, yau yasoi. Aluwai noko ulolo liyaiki. No monoi no tani mi mo futo. ");
INSERT INTO amm_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Nosai no komano nokoyo siyolo siyolo kolalimai noko siya na tumoki. Tani siyolo mo Yutaso, Kalili nokota na. Toso mani, aluwaiyalokino, noko nokolaloyo, nosai no uwokaiki. Aluwai noko ulolo liyaiki. ");
INSERT INTO amm_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","No monoi no ya tikikomonukuwo, lolai mani, tofolo na suomo. Nokoni muluyoso mi anono mo, mi mo futo. ");
INSERT INTO amm_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ulai Koto tani amimai mi anono mo, moiyo no moloi alukiko monoi? Wiyou. Wonikaluso Kotowoi aiko tukoluwanoinuwo.” Nokotalo iyaliso aino na ikoki, Kamaliyalo mo. ");
INSERT INTO amm_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Ikoki mo; tani imo kwaimokino. Kotoni imo lukasikalomano nokoso aliyonikokino, moloyo na wasoulikino. Ikikokino, “Isiso aino imo noiyo ikaloiwo.” Nosai no ikokino, “Soi suwo. Na ponuwo.” ");
INSERT INTO amm_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ikokino mo; Pita iyali mo utukaikokino, iyamoki, “Isisoso mulumolo luwai monoi tuwomokono, na tauwosisimomokono. Ulai koi no imowoi? Kotoyo tiyomu, haniyo uwomoko monoi pa tulosukomomokoso.” Aino iyamoki, siyoliso na molokikino. ");
INSERT INTO amm_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ulo ulo saiso saiso imo itouniyaimo polukasikalo mosikino. Noko nokolaloso pikomosikino, “Isiso mo Kolaiso, Kotoyo muwokai nokota, Isolilo noko nokolalo moi fasimoka tumoki.” Aino pikomosikino. Lotu nu siyoliwoi nu nuwoiso ifou ifou paiyolokalo liyai manokino. ");
INSERT INTO amm_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Nosai no mo; Isisoni moloso aluwai noko nokolalo mo molopoi ainoso hani molopoi molopoi. Siyai mo Yuta Yuto noko. Siyai mo Koliko imo noko. Nosai no Koliko imo nokoyo amuwaso alikokino, Yuta Yuto nokoso. Na iyamoki, “Koloni waumosimai koini susawi nokolalo mo tosofuwakomosi. Pa tuwauti itouniyaimo mosinoso.” ");
INSERT INTO amm_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","No monoi no Pita iyali, noko molo tiwoi noko na, toi mo Isisoni moloso aluwai noko komaso nokoso aliyonikokino, na ikokino, “Koi no Kotoni imo lukasikalo mi no moloi utukaimo monoi? Koloni no moloi wauti monoi, koi no? ");
INSERT INTO amm_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","No monoi no, woli iyali, noko nano siya, 7, na pomuwokowo, moi mulumai si nokoso. Noko nokolaloyo no tiyamo ukuno no, “Noko ititouni na,” toiso pomuwokowo. Kotoni Mulu Itouniyaimo Nokotayo mulu amikokai noko saso pomuwokowo, mulu iwoi nokososo. Toiso mo koloni wau mi monoi muwokokaiyoikimo. ");
INSERT INTO amm_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Koisu mo Kotowoi imo na tolukaso manonoki, tani imo na tolukasikalo manonoki.” Pita iyaliyo aino na ikokino. ");
INSERT INTO amm_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Nosai no mo; ukouniyaikokai noko nokolaloyo waliyo iyamoki. Noko nano siya, 7, na muwokokino, nonani mi ano monoi. Sitiwi muwokino, Isisoso amiso mulumolo luwai nokota, Kotoni Mulu Itouniyaimo Nokotayo muluso no amimokaiki no. Muwoko noko siyai siyolo siyolo mo Filipo, Polokulo, Naikano, Taimo, Pamino, Nikolaso. Nikolaso mo Anotiyoko nokota, Yuto iyalini moloso aluwai nokota na. Nonani noko nano siya, 7, na muwokokino. ");
INSERT INTO amm_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Kotoni imo lukasikalomano nokoni auso na kiyoka tumokino. Kiyokokino mo; Pita iyaliyo nainoyo kulolalokino, komumai. Kotoso utolumo ukukino, koloni wau mi ano monoi. ");
INSERT INTO amm_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Nosai no mo; Kotoni imo mo maliyali liyaiki. Yolusolimo noko nokolalo molopoiyo lolaloso mulumolo luwaikino, ainoso hani molopoi molopoi si liyaiki, Isisoni moloso aluwai noko nokolalo mo. Lotu samukuko noko molopoi mani, Isisoso lolaloso mulumolo luwaikino. ");
INSERT INTO amm_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Nosai no mo; Sitiwi mo mulu ifolaluwawoi mi siyoli na analoki, noko nokolaloni molo timai. Wiyouwa wiyou, Kotoyo na fasiyaloki, totani amiyo. ");
INSERT INTO amm_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ulai Yuto noko siyai mo uo imo ima tumokino, lotu nufa siyaso numosi noko mo. Toini lotu nufa siyolo mo Samiyaikiyo Nokoni Lotu Nufa. Ulai afonimaiso? Noko nokonu nokoni mi ano monoi tosamiyaikiyono, no monoi no. Nonani lotu aluwai noko iyali mo Sailini nokonuwoi Alikosatoliya nokonusaiwoi toku ti liyaiki. Siyai mo Silisiya asiwoi Aisiya asisaiwoi toku ti liyaiki, Yolusolimo nokonu siyoliso. Toi mo koyoso imo na lukasa tumokino, Sitiwiwoi. ");
INSERT INTO amm_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Ulai Sitiwi mo mulu mo iwoi. Kotoni Mulu Itouniyaimo Nokotayo fasiki, imo lukaso monoi mo, no monoi no ulai toi no moloi souwai monoi, tani imo no? Ima imo saso ikoki. ");
INSERT INTO amm_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Nosai no nokoso ainiko ifoluwaikokino, wosu woso ikokino, “Noino piyamo unuwo, “Sitiwi mo alisiyoli imo yapoli yomuki. Yasoi na kwaimokinoki. Musiwoi Kotowoiso alisiyolikoki.” ");
INSERT INTO amm_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Noko nokolaloyo nonani ifoluwaiko imo kwaikino mo, piyamoki, motuwo. Wiyou, uo mulu mo puwoso puwoso. Yuto noko sisiyoli nokowoi Musini imo sai sisiyoli nokowoi, toi mani, uo mulu na atolokoki. Nosai no mo; nonani uo noko mo Sitiwiso na komi kausiyanokino, nokotalo iyalini molo timaiso na kawiyo tumokino. ");
INSERT INTO amm_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Noko siyai mani, koliyo tumokino, ifoluwaiko fasika tumo monoi. Nonani noko iyaliyo noko sisiyoliso ifoluwaiko unukino, Sitiwi monoi, “Noko ni mo, to mo talisiyolikomoi, Kotoni lotu nu siyoliwoi Musini imo amiwoiso. ");
INSERT INTO amm_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Tani imo yapoli kwaimokinoki, yomuki, noino, “Isiso, Nasolito nokotayo mo lotu nu siyoli niya ulaloimo. Musini tokumi moloso namoliyo alosimoimo, molo tonufuwa wiyomokoimo.” Aino noko sisiyoliso ifoluwaiko unukino, Sitiwi monoi. ");
INSERT INTO amm_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Nosai no nokotalo iyaliyo Sitiwiso kwaikino, molo amisoso. Wiyou, tani amu molo mo kumoki nokotani amu molo komiyai. ");
INSERT INTO amm_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Nosai no mo; totawoi lotu samukuko nokota siyoli mo Sitiwiso na imoki, “Ni tofaumimonono no, imo motu poimo.” ");
INSERT INTO amm_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Nosai no mo; Sitiwi mo nokotalo iyaliso na ikoki, “Woli iyali, apou iyaliwoi, yani imo na pukwaimonowo. Moini aniyopa Apolofamoyo Misopotamiya asiso tolomai, Hilano nokonuso amai tolanoki mo, nomai no Koto mo tani ami wiyonina tumoki, ");
INSERT INTO amm_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","na imoki, “Tolomuso niya putukaimo. Siyokuno iyaliso na putukaiko. Yo mo asi siya na wiyononinoikimo. Na potolano.” ");
INSERT INTO amm_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","No monoi no Kalotiyo nokoni asi Misopotamiyaso utukaimokino, toi koli mo. Hilano nokonuso sanoki. Nosai no Apolofamoni apitono kaloki, yau. Apolofamo mo apitono mo yau; Kotoyo imo taikiyoki, imoki, “Na popuwotolo, na pomoi.” No monoi no tolomuso niya tumoki, moi ni tosikoni no. ");
INSERT INTO amm_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ulai asi mo pa anonikiso. Asi koufa mani, pa anonikiso. Ulai motu imo na imokaiki, “Amuwoi tinoso aninoikuwomo, nonowoi alisaino iyaliwoiso.” Ali somisomai aino na imoki, Kotoyo mo. ");
INSERT INTO amm_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Nosai no ti monoi na imoki, Kotoyo, “Nani alisaino iyali mo noko nokonu nokoni asiso sanoimo. Mi foloko mi anotiyoinomo, na uwokoinomo, tolomu nokoyo, ainoso hani aisamu molopoi molopoi, 400 mo uwai. ");
INSERT INTO amm_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Ulai asa mo mi foloko mi anoti foli monoi na uwokaikoimo, noko nokonu nokoso. Nosai no nani alisaino iyali mo utukaikiyo tumoinomo, isoni molokimomona tumoinomo.” ");
INSERT INTO amm_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Kotoyo aino imoki, nosai no nokoni au tuno tokosonasiko monoi imokaiki, Apolofamoso. No mo afonimaiso muwoi, Koto tota amu monoi muwokokai monoi. Nosai no Apolofamo mo awitono Isako kiki. Amoloki nano tiwoi, 8 uwai; Isakoni au tuno na tokosiyaimoki. Siyoli yasoi; Isakoyo awitono Yokopo kiki. Nosai no Yokopoyo awitono iyali noko molo tiwoi, 12, kokaloki. Toi mo moini aniyopa iyali sisiyoli na.” Aino na ikoki, Sitiwiyo mo. ");
INSERT INTO amm_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Nosai no mo; ti monoi na ikoki, “Ulai aniyopa iyali sisiyoliyo auwatono Yusifo monoi mo foluwaliyoluwaikino, suo suomoko nokoso ati taikiyokino, suo mo muwoni. Nosai no suo suomoko nokoyo kaukino, Isipi nokoni mi foloko mi anoti monoi. Ulai Isipi asi mo Kotoyo na tolo fasi manoki. ");
INSERT INTO amm_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Uwomosimai na pofasimosiki. Mulu iwoi na anoniki, no monoi no Isipi asi samuku nokota siyoli Falau mo mulu mo waliyo, to monoi, na imoki, “Woli itouniyaimo, yani Isipi asi na posamuku fasimono. Mi anomono noko nokolalo mani, posamukuko.” ");
INSERT INTO amm_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Nosai no mo; Sitiwi mo ti monoi na ikoki, “Tiya siyoli uwokokaiki. Isipi asimai koloni mo uwofa. Koinono asimai mani, uwofa na. Wiyouwa wiyou, tiya na kolikaliki. Aniyopa iyaliyo afonimaiso si manoki, Koinono asimai. ");
INSERT INTO amm_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Nosai no moini aniyopa Yokopo mo imofa kwaiki, noino, “Tokumi paluwa tuo mo amai si, Isipi asimai.” Kwaiki mo; awitono iyaliso totawoi monoi iko taikiyoki, paluwa tuo iyano monoi. ");
INSERT INTO amm_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ifou tiki mo; ulai ti monoi na iko taikiyoki, paluwa tuo iyano monoi. No monoi no yasoi; Isipi asi mo tiki mo, Yusifo mo auwatono iyaliso na ikoki, “Yo mo Yusifo, moini auwano na.” Nosai no Falauso imoki, “Ni mo yani auwa iyali na.” ");
INSERT INTO amm_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Nosai no auwatono iyaliso na iko taikiyoki, “Apouso na pimanowo, toi koli tuomo.” Yokopo koli mo tiso tiso muwoi, molopoi na, 75. ");
INSERT INTO amm_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","No monoi no mo, Yokopo koli mo Isipi asiso na sanoki. Si manoki si manoki; Yokopo mo kaloki. Awitono iyali mani, na kolikaliyaloki, yau yau. ");
INSERT INTO amm_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Toi yau yau mo Sikimo nokonuso ifou iyo tumokino, nokoyo. Apolofamoni yu asi iso aiko uka tumokino. Nonani yu asi i mo Apolofamoso toku yasoi awimokino, suo mo muwoni. Sikimo nokoyo awimokino, Hamoloni awitono iyaliyo.” Aino na ikoki, Sitiwiyo mo. ");
INSERT INTO amm_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Nosai no mo; ti monoi na ikoki, “Kotoyo toku no imokaiki no, Apolofamoso, nonani imoyo aumoifaso motu fiyamosimai, nomai no Apolofamoni alisaitono iyali molopoi molopoi siki, Isipi asimai. Aniyopatono iyaliso souwaikokino, molopoi nali. ");
INSERT INTO amm_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Nosai no noko siyoli siyayo Isipi noko samukuko nokota siyoli kwalomai monoi tola tumoki. Yusifo monoi mo sai muwoi. ");
INSERT INTO amm_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Aniyopa iyaliso kopokoiyauko manoki, Isolilo nokoso. Puwoko manoki, ikoki, “Alalo mala mo na pa salosomosiwo. Na kolikaliyumo, yau yau.” Aino na ikoki, Isipi nokota siyoliyo. ");
INSERT INTO amm_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Nomai no mo, noniyo alufa mo na kiki. Tani siyolo mo Musi. Ulukukumoso na, Kotoni molo timai. Amu mo tauwoi mo atino apitono noko tiyo no nikino. ");
INSERT INTO amm_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Nosai no iwoso akaiyanokino, posomaiso. Ulai Falau siyolini atokiyo Musi mo kausiya konoki, iwoso. Totani nuso na kawiyo tiki, nou ni monoi, yomusoki, “Asani alu.” ");
INSERT INTO amm_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Komu mo puwoso puwoso; mulu iwoi noko sisiyoliyo Isipi aniyopa imo aiyolomalokino. No monoi no Musi mo afonimai nokota muwoi, imo itouniyaimo lukaso nokota. Mi mani, amiso pano manoki.” Aino na ikoki, Sitiwiyo mo. ");
INSERT INTO amm_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Nosai no mo; ti monoi na ikoki, “Musi mo aisamu mo 40, nosai no mo na yomuki, “Woli iyaliso na tokokano, Isolilo nokoso.” ");
INSERT INTO amm_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Yasoi; Isolilo nokotaso na kwaiya tumoki, Isipi nokotayo uwoso. Nosai no siyokutono foli monoi na tukoloki, Isipi nokotaso, yau. ");
INSERT INTO amm_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Louwa mulumolokoki, “Woli iyaliyo tosaino unumonono, Kotoyo timono taikiyo, toi fasiko monoi.” Aino louwa mulumolokaloki, ulai siyokutono iyaliyo sai muwoi, sosoli na. ");
INSERT INTO amm_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Amuwoisai siyokutono iyaliso ti monoi koka tumoki mo, noko tiyo tukoluwanoso kwaika tumoki. Asisikuwano monoi louwa ikoki, “Noko ti, hani monoi totukoluwanonuwo? Moti mo wolinowoi nali.” ");
INSERT INTO amm_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ulai siyokutonoso uwo nokotayo usainiyaimoki, imoki, “Noiyo imo taikiyoni, koi samukumoko monoi no? A, uo foli monoi tiyomu unumokoni, kuo? ");
INSERT INTO amm_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Fai Isipi nokota tukolani. A, lolai louwa totukolomononi?” ");
INSERT INTO amm_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Musi mo nonani imo kwaiki mo, Isipi asisai lomuki, Mitiyo asiso tolanoki, noko nokonu nokoni asiso. Tolo manoki mo, alalo ti mo tiwoi kokoki.” Aino na ikoki, Sitiwiyo mo. ");
INSERT INTO amm_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Nosai no mo; ti monoi na ikoki, “Aisamu 40 mo uwai; kumoki nokota mo Musiso na kiya konoki, nu somiso asiso, Sainai yu aumoifaso. Afa touwomai ta imoko tolomai na tola konoki. ");
INSERT INTO amm_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Wiyouwa wiyou, Musi mo kwaiki mo, na mulumoloko manoki, aumoifaso amunoki, amiso ki monoi. Nosai no Noko Siyolini ko naso kwaimoki, noino, ");
INSERT INTO amm_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Asa mo aniyopano iyalini Koto. Apolofamowoi Isakowoi Yokopowoi, toini Koto na.” Imoki mo; wiyou, Musi mo kokolo mulu saso, na kumolokomoki, Kotoso pa kikiso. ");
INSERT INTO amm_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ulai Siyoli Nokotayo mo ti monoi imoki, “Fona su mo pasiyokaiko. Asi ni totoloni no, ni mo asani asi itouniyaimo nali no. ");
INSERT INTO amm_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Motu na, yo mo yani noko nokolaloso yapoli na tokoko, Isipi nokoyo uwokoso. Toi sosonuno na tukwaiko, yo mo. No monoi no asiso na tofasika kono. Na popuwotolo, Isipi asiso timo taikiyonoki. Na pokiyoko taikiyano.” Musiso aino na imoki, Kotoyo mo.” ");
INSERT INTO amm_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Nosai no mo; Sitiwi mo ti monoi na ikoki, “Noko no mo, Musi, to mo toku yasoi imokino, Isolilo nokoyo, “Noiyo imo taikiyoni, koi samukumoko monoi no? A, uo foli monoi tiyomu unumokoni?” Musiso toku yasoi aino imokino, no monoi no kulalikino. Ulai Kotoyo na imo taikiyoki, siyokutono iyali samukukano monoi, kiyoko taikiyano monoi. Ainonani monoi kumoki nokotayo na ima konoki, afa touwomai tolo nokotayo mo. ");
INSERT INTO amm_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Nosai no mo, yasoi; Musi mo mulu ifolaluwawoi mi siyoli na ananoki, Isipi noko nokolaloni molo timai. Nosai no siyokutono iyali na koliyonoki, Isipi asisai. Mulu ifolaluwawoi mi siyoli na analoki, Nakiyai Mamo Iwomaiso. Nu somiso asimai panalo manoki, aisamu mo 40. ");
INSERT INTO amm_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Nonani nokota, Musi, totayosu mo Isolilo nokoso na ikoki, noino, “Yo mo Kotoni imo toposasokomoi. Noinoso noko siya mani, Kotoyo imo taikiyoimo, tani imo posasoko monoi. Momaini alisaino na fiyamosiyoimo.” Kotoni puko imoyo tiyomuko, Musiyo no ikokaiki no.” ");
INSERT INTO amm_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Nosai no Sitiwi mo ti monoi na ikoki, “Musi totawoisu ukouniyaikoku siki, moini aniyopa iyaliyo, nu somiso asiso. Sainai yu tonimai kumoki nokotayo imo posasoko wiyoluma konoki. Noko mo nonani imo kwai mo, aniyopa poi poi yousi itouniyaimomoi. Moi monoi mani, na posasoko wiyolumoki. ");
INSERT INTO amm_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Aniyopa iyalisu mo tani imo pa kwaikinoso, na kulalikino. Isipi asiso ifou nu monoi yokino. ");
INSERT INTO amm_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Musini auwatono Alonoso imokino, “Isipi asisai kiyomoko nokota, to no moloi uwo, woi, Musi wai no? Ulai koi no sai? Yuso amai poi tiyou tolo. Tomoki na pokuwokomoko, tomoki mo kumoki tolomu noko komiyai. Molo monoi wiyomokowumo.” ");
INSERT INTO amm_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Nosai no tomoki kuwokino, polomoko uofa komiyai, piyamoki, samukukowo. Koloni mo taso utunonikino, piyamoki, molokiwo. Totaini tomoki kuwo mi monoi molokikino, na wasikino. ");
INSERT INTO amm_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","No monoi no mo, Koto mo namoliyo alosikoki, yomuki, “Tofolo suomo.” Wiyou, ulowoi amuw