﻿USE sofia;
DROP TABLE IF EXISTS sofia.amk_vpl;
CREATE TABLE amk_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES amk_vpl WRITE;
INSERT INTO amk_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesus Kristusi mani weriria na ne werengno Mananu Dauti tuti na ne werengno Abrahami ma. Ne ririafoi mani sonina: ");
INSERT INTO amk_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahami dawingno Isaki, Isaki dawingno Yakupi, Yakupi dawingno Yehudai, tuti kaisung suraya mansiari fosa kontai. ");
INSERT INTO amk_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yehudai dawingno Peresi tuti Serahi. Uinami dino Tamari. Peresi dawingno Hesroni, Hesroni dawingno Rami, ");
INSERT INTO amk_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Rami dawingno Aminadapi, Aminadapi dawingno Nahasoni, Nahasoni dawingno Salmoni, ");
INSERT INTO amk_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmoni dawingno Boasi, tuti Boasi nini inang dino Rahapi. Boasi dawingno Obeti, tuti Obeti inang dino Ruti. Obeti dawingno Isai, ");
INSERT INTO amk_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isai dawingno Mananu Dauti. Dauti dawingno Salomoi, tuti Salomoi nini inang dino Betsebai, Uriai ne wiwingfoi. ");
INSERT INTO amk_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomoi dawingno Rahabiami, Rahabiami dawingno Abiai, Abiai dawingno Asai, ");
INSERT INTO amk_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asai dawingno Yosafati, Yosafati dawingno Yorami, Yorami dawingno Usiai, ");
INSERT INTO amk_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiai dawingno Yotami, Yotami dawingno Ahasi, Ahasi dawingno Hiskiai, ");
INSERT INTO amk_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hiskiai dawingno Menaseri, Menaseri dawingno Amoni, Amoni dawingno Yosiai. ");
INSERT INTO amk_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosiai dawingno Yakoniasi tuti kaisung maneiru kontai, na rabuang bo Mananu Babeli kia kaiwasa Israeli foi to warang rorong fo. ");
INSERT INTO amk_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Tuti ne riria na rabuang bo enai na nu Babeli foi mani, toninai: Yakoniasi dawingno Sealtieli, Sealtieli dawingno Zerubabeli, ");
INSERT INTO amk_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerubabeli dawingno Abihuti, Abihuti dawingno Eliakimi, Eliakimi dawingno Asori, ");
INSERT INTO amk_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asori dawingno Zadoki, Zadoki dawingno Akimi, Akimi dawingno Elihuti, ");
INSERT INTO amk_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elihuti dawingno Elieseri, Elieseri dawingno Matani, Matani dawingno Yakupi, ");
INSERT INTO amk_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakupi dawingno Yusupi. Yusupi nini mani Mariai ne mang dine. Tuti Mariai nini dino dawingno Yesusi mano ahui we Kristusifoi ne. ");
INSERT INTO amk_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Ampafe na Abrahami paria sobu Dauti mani, ne ririafoi suraya boa. Na Dauti paria sobu kaiwasa Israeli foi sawai to nu Babeli foi mani ne ririafoi kontai suraya boa toyari ne. Na rabuang bo Mananu Babeli kia kaiwasa Israeli foi to warang rorong fo paria sobu Kristusi Mananu Mampariri foi saubaunungfo kontaio ne ririafoi da suraya boa. ");
INSERT INTO amk_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Yesusi saubaunungfo mani tonina. Rabuang bo inangno Mariai da we Yusupi fo, wiro une munu rorong siai kaharai mae, Mariai wearikang weia. Weo Nuaninu Mirarebana foi dino wedayari wearikang tonana fo. ");
INSERT INTO amk_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Yusupi nini mani inontaraio enerorong mesi dine, ampafe deyo deiaya wiwingfoi na mamunggasai, ambori Mariaio wiro mimaya na kaiwasa bitoya foi euremireafo fanai. ");
INSERT INTO amk_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Wape Yusupi enetituai we deyo niari tonanai mae, dirua mani demiai. Na ne amiai rorong foi deti Sempaisi ne wewai manei medu wei deyo, “Yusupe, Dauti ne ririane waune, dohonao mutai we ka Mariai we nemu wiwing fanai. Weo arikangno doa wei wani mani, Nuaninu Mirarebana faini andino wedaya tonana fe ne. ");
INSERT INTO amk_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ampafe i ambori minohi tuti kaisung manei, tuti kaisung nani bohoni wonong fino Yesusi, weo i ambori feriri ne kaiwasanei weru ene sasarinei ki.” ");
INSERT INTO amk_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ne nanai kai kawariai tonanai ambori mai kariri fianai aino Sempaisi medurai na ne nabifosara fo, amani, ");
INSERT INTO amk_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Kadawing sowaworua manei, ambori wearikang tuti minohi tuti kaisung manei. Kaisung nani esahui weo Imanueli.” (Imanueli mani kaiwo Iberani fine, dotu tono, “Allai weriria tata.”) ");
INSERT INTO amk_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Yusupi denawa doara mani dohong kariri kaiwo Sempaisi ne wewaifoi medura fo ampafe kia Mariai we ne wiwing. ");
INSERT INTO amk_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Wape wiro dena riati kahai paria Mariai minohi tuti kaisungfoi. Tuti Yusupi dohong wonong fino Yesusi. ");
INSERT INTO amk_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Yesusi saubaunung na bendari Betlehemi na nu Yudea foi, na rabuang bo Herodesi wemananu fo. Na rabuang bonani, inontarai esawai etato we awaha fosa, era na do wanang murang foi to bendari Yerusalemi ma. ");
INSERT INTO amk_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Na nanai etutang mai kaiwasafosa we arikangfoi, eteyo, “Arikangno arahi saubaunung we ambori wemananu we Yahudinesa fi didoni? Weo amewati ne awaha bei na do wanang murang foi, deinawiai we amea, dohona mani amera ma we amesomi wei.” ");
INSERT INTO amk_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Herodesi tarao kaiwofo nanai soiri we kaiwofo tuti enerorongfoi disani, tuti kaiwasa na Yerusalemi foi sentenang kontai. ");
INSERT INTO amk_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Mayeai demi imami baba fosa tuti mantaunau Hukumi Musai soi fosa, efanduhisa ma ainanaya dutansa deyo, “Na katai bodoni dino Mananu Mampariri Allai dereri foi saubaunung nai ne?” ");
INSERT INTO amk_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Eroa eteyo, “Na bendari Betlehemi, na nu Yudea foi, weo nabi manei soi kaririai deyo, ");
INSERT INTO amk_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Betleheme wau na nu Yudea wai, wiro kotui na bendari baba na nu Yudea foi kaha. Weo na wau ambori inontarai fuba manei dariai ki, andino fiebai we yu nehu inontarai Israeli fesa ne.’” ");
INSERT INTO amk_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ainanaya Mananu Herodesi sahu inontaraifosa ma, dutang berasa na mamunggasai we na rahida fiani ewati awahafoi ne. Weo enerorong we miung Mananu weworu nani. ");
INSERT INTO amk_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ampafe demisa era to Betlehemi deyo, “Mera wa metutang sauarai we arikangwai na mai. Masino mesobui mani, mera aha ma, metei kaririai we yau, ambori yau kontai ira wa isomi wei.” ");
INSERT INTO amk_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Etarami kaiwofo kaia era wa. Era wa mani, ewati nari awaha raminde ewatioi na do wanang murang foi aha, ampafe emararising paria, tuti era ria awahafoi paria fiotourai tete katai arikangfoi wiatai nai foi. ");
INSERT INTO amk_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Esuai to munufoi afui, ewati arikangfoi tuti inang Mariai. Ainanaya etisangkapa eawemibukafo tuti esomi wei. Tuti etaio fianggeng eha we etohonai wei fo, amani emasi, tuti fianggeng mirarebanaio niunsai mampori, ahui we kemenyani tuti muri fo. ");
INSERT INTO amk_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Mayeai Sempaisi denawiai na amiai rorong wesa, we wiro era wa we eteisaharai we Herodesi ahang fanai. Ampafe ehidori na rang siai rowei to ene nufoi aha. ");
INSERT INTO amk_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ainanaya inontaraifosa era wa, mayeai Sempaisi ne wewai manei medu we Yusupi na amiai rorong fo, deyo, “Herodesi enerorong we sera we arikangwai we miuni. Ampafe boabari wau, ka arikangwai tuti inana, muntowawu to Mesiri. Muntonayai na wanai paria imadu we wau aha.” ");
INSERT INTO amk_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Yusupi doabariri, diru nani kontaio kia arikangfoi tuti inanai itowawu to Mesiria. ");
INSERT INTO amk_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Itonayai na wanai pariao Herodesi mireha. Ampafe fianai aino Sempaisi medurai ria ne nabifi kawariai kaririaia, deyo, ");
INSERT INTO amk_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Rabuang bo Herodesi deitawanai we inontarai esawai etato awaha fosa etofari nanai, kesoua dang wawerahi. Ainanaya demi ne rai mamuna fosa na tapapa deyo, “Arikang mangno ene defuina boru to kofa na Betlehemi tantenang tuti munue wa ruramai na nana fosa mani, memunsa weruai.” Herodesi dohong kaiwo tonanai, weo titua kariri kaiwo mano esawai etato awaha fosa emadurai kariri rahida bo awahafoi kiawaria fo. ");
INSERT INTO amk_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Finanai kawariai kariri fianai aino nabi Yeremiai meduraia fo, amani dotu tonina: ");
INSERT INTO amk_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Na bendari Rama taramio esaia etaidu paria. Raheli sai ne arikangfosa, miaya we waworiri kaha, weo emarareha ampa.” ");
INSERT INTO amk_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Mayeai Herodesi mirehara, ainanaya Sempaisi ne wewai manei medu we Yusupi na ne amiai rorong foi, na nu Mesiri foi. ");
INSERT INTO amk_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Medu deyo, “Inontaraio eteyo emungno arikangwai nanisa emarareha ampa. Ampafe boa ka arikangwai tuti inanai, muntorarabera muntoru to nu Israeli foi aha.” ");
INSERT INTO amk_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ampafe Yusupifo doabariri, kia arikangfoi tuti inanai itora to nu Israeli foi. ");
INSERT INTO amk_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Wape mayeai taraoai we Herodesi antungno Arkelausi dautai aha yiwang tamanaifa we wemananu na nu Yudea foi, ampafe mitai we da to wanaia. Manamo Sempaisi dohong kaiwo wei na amiai rorong aha, ampafe da to nu Galilea foia. ");
INSERT INTO amk_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Na wanai niayai na bendari wonong fino Nazareti. Ampafe na tonanane kaiwo nabifosa emadu kariri Mananu Mampariri foi kawariai na mai, amani, ");
INSERT INTO amk_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Na rabuang bonani na katai wekamamiei minano foi na nu Yudea foi, Yohanesi mano webaptisi kaiwasa foi da wiuwu kaiwofo deyo, ");
INSERT INTO amk_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Metarabera mea weru mene sasariwa, weo Seng da ma we wemananu fe kikeu ampa.” ");
INSERT INTO amk_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yohanesi nini dino nabi Yesayai medu kariri deyo, “Inontarai manei sahu pampang na katai wekamamiei minano foi deyo, ‘Memainenang rang beng feai we Sempaisi, tuti menaria mimoya wei.’ ” ");
INSERT INTO amk_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Yohanesi mani ansung sensuna fo mani beng kaha mae na fiahung unta nuwawuru toyari nabi na fafongfa fosa ene ansung etatara fo. Ne aikapurufoi na andowa rerawa. Ne fidangfo mani manggofuni tuti aniwa ne maing terai. ");
INSERT INTO amk_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kaiwasa bitoya paria era wei ma, manea na bendari Yerusalemi, manea kontai na nu Yudea foi sentenang tuti manea na katai watai kefang na waya Yardeni foi. ");
INSERT INTO amk_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Era ma eteiai ene sasarifo tuti webaptisisa na waya Yardeni. ");
INSERT INTO amk_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Inontarai eweFarisi tuti Saduki bitoya kontai era weia ambori webaptisisa. Wape Yohanesi detisa nanafo, medu wesa deyo, “E, inontarai mewarami aipaya di mea, mene tarai toyari tawai memuna, dohona menemitituai we mera ma iwebaptisi mea terai tonanai ambori mekaharai weru Seng Allai ne aiboi katu ma da ma fo fe? ");
INSERT INTO amk_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Mae toyari aio webong beng, mea kontai meteinawiai na metohong toa wa we metarabera mea weru mene sasariwa ampa. ");
INSERT INTO amk_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Dohonao meteyo mea mani mene wereng di Abrahami ampafe ambori mekaharai weru Allai ne aiboifo fe. Mearomioai we Seng Allai mani mawa arora wei we niari riria Abrahami na kamamieinei kontai. ");
INSERT INTO amk_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Tamangfoi meinenang na ai newafoi we robani. Ampafe ai bodoni dino webong kaha mani, robani tuti kabioi to adia rorong fo. ");
INSERT INTO amk_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Iwebaptisi mea na mereha we fiainawiai we metarabera mea weru mene sasarifi ampa, wape mano da tua yau ma foi fiebai sewa yau tuti we irehu ne wai sapatu fo terai ki, wiro imai we inari finana kaha. Andino ambori webaptisi mea na Nuaninu Mirarebanai foi tuti na adia, amani niari mea memararebanai tarai. ");
INSERT INTO amk_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ne sosirufi meinenang na warangfo ampa tuti kifa pafoi ambori mirarebanai ki. Pa taraifoi fianduhi afui wiatai na munu rorongfo, mae nukahaifoi ambori kebioia dansoi na adia wiro fefe naea kaha.” ");
INSERT INTO amk_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Na rabuang bonani Yesusi da na nu Galilea foi to waya Yardeni we Yohanesia, tuti dutani we webaptisi i nai. ");
INSERT INTO amk_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Manamo Yohanesi deo deiaya fi deyoa fo ampafe medu wei deyo, “Wau fino webaptisi yau fe. Wape todoni ro ma we iwebaptisi wau nina?” ");
INSERT INTO amk_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Manamo Yesusi yoa wei deyo, “Towea kaha, weo na rang toninai turohong kariri fianai aino Allai dawi wea fo na mai.” Ainanaya webaptisi Yesusia. ");
INSERT INTO amk_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Webaptisi ia kai nanai, Yesusi dautai weru mereha rorong fo ayai. Na kutu siari nanai kontai rorafaisi tifai, tuti deti Allai Nuaninufoi ne tarai we muntung manei sea meu minohi sauwi. ");
INSERT INTO amk_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Mayeai tarao Allai raofuifoi medu na rorafaisi meu deyo, “Nehu Kaisung enehuwawuti fi dinani, kia enehurorongnei.” ");
INSERT INTO amk_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Mayeai Allai Nuaninufoi wiwiaing Yesusi to katai wekamamiei minano feai, we ambori Saminseni weanggariri. ");
INSERT INTO amk_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesusi niayai na nanai rahida piarua, wepuasa, wiro dampi kahai, ampafe wewisi paria. ");
INSERT INTO amk_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Na nanai mano Weanggari foi da ma weanggariri, medu wei deyo, “Taraie, Allai ne Kaisung di wau mani, bemi kamamieiwa wefiang we bang.” ");
INSERT INTO amk_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Manamo Yesusi yoa wei aha deyo, “Na Sempaisi ne Kaiwofo dotu tonina: ‘Inontarai eminohi etarang fo, na fiangfo titou kaha, mae na ohong kariri Seng Allai ne Kaiwo kiai ne kontai.’” ");
INSERT INTO amk_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Mayeai Saminseni kia Yesusi to bendari mirarebanaio Yerusalemia, na wanai dohoni minohi na Sempaisi ne Munufoi kuruinafo. ");
INSERT INTO amk_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Mayeai medu wei deyo, “Taraie Seng Allai ne Kaisung di wau mani, tawing wau tawai na ninai aweu, ambori wewaifosa esoru wau wori, tau aweu, mureha kaha. Weo Sempaisi ne Kaiwone rabuang bei dotu kariri wau tonina: ‘Allai ambori demi ne wewaifosa etamang we wau,’ tuti, ‘Etamang we wau na ewaramifo, ampafe tau kofafea kaha.’” ");
INSERT INTO amk_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Wape Yesusi yoa wei aha deyo, “Na Sengnei ne Kaiwone medurai kontai tonina: ");
INSERT INTO amk_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Mayeai Saminseni kia Yesusi to uai dedai bei nuwowongfo aha, tuti na nanai deinawi katai mananufo ewemananu naya fo kiai na nunei sentenang tuti ne mahikai fuba niai nai foi sentenang wei. ");
INSERT INTO amk_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Tuti medu wei deyo, “Tuang aweu womi we yaua mani, katai fuba botioi tuti ne fianggeng finanai kiai, yohoni kiai we wau.” ");
INSERT INTO amk_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Yesusi yoa wei aha deyo, “Saminseni, ro weru yau. Weo na Sempaisi ne Kaiwone dotu tonina: ‘Mesomi terai we Allai mene Sengfoi tuti metohong kariri ne Kaiwofo terai.’” ");
INSERT INTO amk_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ainanaya Saminsenifo pisuhirai weru Yesusi tuti wewai rabuangfoi da ma fiatari na fi dohong wea fo toyari fi we dang fo tonanai. ");
INSERT INTO amk_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Rabuang bo Yesusi taraoai we Yohanesi mano webaptisi kaiwasa foi, etafuria wiatai na munu aitamu rorong fo nanai, daraberahi to nu Galilea foia. ");
INSERT INTO amk_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Da weru ne munue Nazareti, awa niayai na bendari Kapernaumi na ruru Galilea foi dereungfo, amani na kataio weriria na Zebuloni tuti Naftali uru ma foi. ");
INSERT INTO amk_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Finanai kariri kaiwo nabi Yesayai medura fo, amani ");
INSERT INTO amk_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","deyo, “Zebuloni ne kataifoi tuti Naftali ne kataifoi, na rang bia to rurufoi arau fo, na waya Yardeni dereungfo na nu Galilea foi, amani kataio Yahudi kaha fosa bitoya enai naya fo. ");
INSERT INTO amk_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Kaiwasa enayai na mamantiti rorong fo ewati sambewarai fiebai bei ampa, mano mamantitifoi tebungsa fosa, Sambewarafoi dansaisa ampa.” ");
INSERT INTO amk_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Na rahida nanaifa aino Yesusi fioai borong medu deyo, “Metarabera mea weru mene sasariwa, weo Allai da ma we weMananu fe kikeu ampa.” ");
INSERT INTO amk_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Rahida bo Yesusi da na nafareng na ruru Galilea foi nani, detio manggaerang mandu, mambetahatui suruine, amani Simoni mano ahui kontai we Petrusi foi tuti ne tahatuio Andareasi. Umung erang na rurufoi. ");
INSERT INTO amk_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Medu we suru deyo, “Mura ma, muraria yau, ambori mutafu diang ahang kaha mae yeunau muru we mutafu inontarai we yau.” ");
INSERT INTO amk_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Na tatofang kutu nanai kontaio uwaramipa erangfo watai mae urariati. ");
INSERT INTO amk_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yesusi da paria aha mani, deti mambetahatui mandu kontai aha, amani Zebediusi ne arikang suruine, uwonomi fino Yakobusi tuti Yohanesi. Ukontai une wawafoi itoria itone erangfoi na itone wafoi. ");
INSERT INTO amk_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Yesusi sahu suru, tuti uru kontaio urutang riwanai ahang kaha mae, utubapa utamamifoi tuti wa itomungfi nai foi, uraria Yesusi. ");
INSERT INTO amk_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesusi da wari nu Galilea foi tuti deunau na munu agama Yahudi fo. Deiriri Kaiwo Mahikai fo kariri todoni Allai ambori weMananu ki. Kontai niari kaiwasa emaninang fosa ebeng weru maninang bodoni konta foi. ");
INSERT INTO amk_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Kaiwo kariri Yesusi fo dafai wariai na nu Siria foi sentenang, ampafe kaiwasa bitoya era ruhiai ma, eha inontarai fuba emaninang fosa tuti mano maninangfo wedaya esodai dadira fosa we Yesusi ma. Kaiwasa nuaninu karira dohonsa fosa, mano euremi marareha arora fosa, mano efaya fosa, kaiwasa fuba nani kiai Yesusi niarisa ebeng. ");
INSERT INTO amk_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Kaiwasa bitoya paria era ria Yesusi na rabuang bonani. Manea era na Galilea ma, manea na Dekapolisi, manea na Yerusalemi, manea na Yudea tuti manea kontai na waya Yardeni dereung do murang foi. ");
INSERT INTO amk_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Rabuang bo Yesusi deti kaiwasa bitoya foi nanai, dautai to wiwoi nuwowongfo ayai minohi nayai, mayeai ne inontarai erariati fosa era wei ma, ");
INSERT INTO amk_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ainanaya fioai borong medu deunausa deyo, ");
INSERT INTO amk_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Mano enumiruainso ene fieai ahang kaha tuti enemitawang te Allai fosa mani, esobu ne maifo ampa weo eaino eminohi we Seng Allai ne inontaraifosa na ne Mananu rorong fo ne. ");
INSERT INTO amk_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mano esaia etaidu fosa mani, esobu ne maifo weo Seng Allai ambori dufi euremikurufo ki. ");
INSERT INTO amk_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mano enemirorong tewawa fosa mani esobu ne maifo, weo Allai ambori dohong nunei wesa ki, kariri ne kaiwo arera fo. ");
INSERT INTO amk_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Mano etohong weai paria we enemirorong mesi na Allai urengrea fosa mani, esobu ne maifo, we Allai ambori dohong kariri fi etohong weai nanai wesa ki, amani dohonsa enemirorong mesi kaririai. ");
INSERT INTO amk_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mano earomio inontarai siai fo mani, esobu ne maifo, weo eaino ambori Allai arosa kontai ki. ");
INSERT INTO amk_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mano enemirorong mirarebanai fosa, esobu ne maifo, weo ambori ewati Allai ki. ");
INSERT INTO amk_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mano eha manang we kaiwasao emamuna wawerasa fosa fo mani, esobu ne maifo, weo Allai ambori yoa wesa we ne arikang ki. ");
INSERT INTO amk_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mano kaiwasa enari kangganisa weo enemirorong mesi kariri Allai ne Kaiwone fosa, ea kontai esobu ne maifo, weo Allai mioansa weo eaino eminohi we Seng Allai ne inontaraifosa na ne weMananu rorong fo ne. ");
INSERT INTO amk_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Mano inontarai eteibera mea, etei kanggani mea funomai, tuti mesodai dadirafea weo meraria yau ne mea mani, mesobu ne maifo. ");
INSERT INTO amk_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mefaraise tuti memararising, weo mesobu fiembaita fuba paria na Waidani. Mefaraise tonanai weo wiro memeiri mea mesodai dadirafo tonana kaha, weo mene tarai kariri nabi fafongfa fosa, weo mano enari kanggani mea ninisa ene werengfosa fafongfa enari kanggani nabifosa kontai tonanai kawuru ampa, ampafe finanai deinawiai we menari ne maifo, mai kariri nabi fafong fosa enari ne maifo.” ");
INSERT INTO amk_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Mea mani mene tarai toyari aio indawang fi nai we nunei. Masino aifoi meuwai ahang kaha mani, ohoni todoni wori meuwai aha ki? Nana mani wefieai ahang kahaia finanai, mae kabioi terai tuti inontarai etatahari. ");
INSERT INTO amk_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Mea kontai mene tarai toyario padamarangno we sambewa nunei. Bendario wiatai na wiwoi nuwowongfoi mani todoni kontaio wati pari rai. ");
INSERT INTO amk_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Tuti manei wiro kiai padamarang beia, mayeai yuai babeu beia tebung weduari nai kaha. Mae yuai padamarangfoi ayai sawai parai, ambori sambewa inontarai enayai na munu rorong fosa kiai. ");
INSERT INTO amk_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Tonanai kontai we mea, na metohong toa wau ne tarai toyario padamarang denggararu we sambewa kaiwasa, ambori inontarai siai ewati mene metohong toaio beng nana mani, etaparanding mene Dai na rorafaisi.” ");
INSERT INTO amk_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Dohonao meteyo ira ma weo yeiaya Hukumio Musai soi fo tuti Kaiwo nabifosa emadura fo fe. Bereri! Mae ira ma nina mani weo yeinawiaia kasau we waitawanai kariri fianai aino kaiwo nanai dotu wea foa. ");
INSERT INTO amk_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tarai, imadurai we mea mau, we nunei tuti rorafaisi wiro wioru kaharai mae hurupi kutu ketui todoni bei kontai ki, na Kaiwo Musai soi fo, wiro niai kaha, pariao fi dotu wea fo mai kaririai. ");
INSERT INTO amk_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ampafe mandoni dino deiaya hukumi fo bei na Kaiwo Musai soi fo, masino hukumi nani ketui todoni ki, tuti deunau inontarai siai we ea kontai eteiaya hukumifoi kontai tonana mani, ambori atori we inontarai tewawa pari dine na Allai ne weMananu rorong fo. Mae mandoni dino yoa weai, dohong kaririai tuti deunau inontarai siai we etohong kaririai konta mani, ambori atori we inontarai fuba na ne weMananu rorong fo ki. ");
INSERT INTO amk_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ampafe yeisaharai we mea, weo wiro menemirorong mesi sewa mantaunau Kaiwo Musai soi fosa tuti Farisifosa kaha mani, todoni kontaio mesuai to Allai ne weMananu rorong fo kaha rai.” ");
INSERT INTO amk_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Metaramioai ampa kariri fianai aino Allai medurai we tane werengfosara fo, amani deyo, ‘Memung inontarai funoma fanai, mandoni dino miung inontarai mani ambori sodai aiboifo ria Allai ki.’ ");
INSERT INTO amk_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Wape ninaia mani imadu mau yeyo, mandoni dino kesisou ne inontarai doroi manei mani, ambori sodai aiboifo ria Allai ki. Tuti mandoni dino deibera ne doroi manei mani, ambori kari to Majelisi Agama fosa we ehutu kaiwo kariri ki. Tuti mandoni dino kesou deibera inontarai siai manei deyo, ‘Weinggowui’ mani, wenani waramipari to Sorohao Adia Rorong foi. ");
INSERT INTO amk_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ampafe masino manei na mea boyo bohong nemu korbani we Allai, wape aromuoai we nemu doroifoi enerorong pirahai we wau, ");
INSERT INTO amk_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","nana mani tawingno nemu korbani nani wiatai na mesbao ohong korbani nai foi, mae ro wa weboyari ria nemu doroifoi akawuru wo, ambori barabera wau ma we bohong nemu korbanifoi we Allai ki. ");
INSERT INTO amk_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Masino nemu aiteta manei deyo dapa wau to mangkutu kaiwo fosa mani, wiro musobu mangkutu kaiwo nanisa kaharai mae na rang rabuang kontaio rurai we weboyari riati aha. Bereri mani, tarahai warapa wau to mangkutu kaiwo fosa rai. Tuti tarahai esoa wau to afai mamuna fosa tuti ea mani esoa wau to aitamu rorong fo. ");
INSERT INTO amk_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Tuti aromuaifa: na aitamu rorong fo watai paria bai nemu fiwaifoi paria kiai fino ro to borieife.” ");
INSERT INTO amk_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Metaramio kaiwo ninai kontai ampa, amani dotu tono: ‘Menayai ria wiwing siai fanai.’ ");
INSERT INTO amk_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Wape ninaia mani imadu we mea mau yeyo, mandoni dino deti wiwing siai manei tuti enerorongfoi dohong we niai riati, nana mani dohong sarawai, amani niai riati kawuru na enerorongfoi ampa. ");
INSERT INTO amk_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Masino uremu domoya wai wedaya nari sasari mani, ketafatini kobioi weru wau. Weo nemu taraiwai ne doni aino wedaya nari sasari nani kobioi mani beng sewa weru borarati wape ambori nemu taraiwai sentenang saukaha Soroha rorong foi ne. ");
INSERT INTO amk_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Tuti masino waramu rufi nai wai wedaya nari sasari mani, ferang kutui tuti kobioia. Weo nanai aino beng sewa borara nemu taraiwai ne doni aino wedaya sasari wai, wape ambori nemu taraiwai sentenang saukaha Soroha rorong foi fo.” ");
INSERT INTO amk_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Aunaufo weai kontai dotu toninai: ‘Mandoni dino dira ne wiwingfoi mani todoni kontaio niari surati bei kariri dirarifo tuti dohoni we wiwingfoi.’ ");
INSERT INTO amk_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Wape ninaifa mani imadu mau yeyo, mandoni dino dira ne wiwingfoi, wape wiro wiwingfoi dohong sarawai ria mang siai kaha, mayeai wiwingfoi ambori rirau siai aha mani, ne mang dirari foi wedayari dohong sara Sengnei ne Kaiwone masi kariri sasario manei niai ria wiwing siai fo. Tuti mandoni dino dau wiwing nani aha mani dohong sara Sengnei ne Kaiwo tonana fo kontai.” ");
INSERT INTO amk_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Metaramioai kontai ampa, kariri kaiwo raminde Allai medurai we tane werengfosara fo, deyo, ‘Wiro mefafora funoma fanai. Mefafora na Sempaisi arongreafo we menari fiea mani, finanai todoni kontai metohong kaririai.’ ");
INSERT INTO amk_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Wape ninaia mani imadu we mea mau yeyo, wiro mefafora fanai. Wiro mefafora na rorafaisi fanai, weo rorafaisi mani katai Allai minohi naya fine. ");
INSERT INTO amk_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Tuti dohonao mefafora kontai na nunei fanai, weo nunei mani katai awengfo doa naya fine. Ete mefafora na Yerusalemi fe, weo Yerusalemi mani, Mananu Fuba foi ne bendari dine. ");
INSERT INTO amk_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Tuti dohonao mefafora na menumiwa fe, weo mano menari tonana ne mea, mene mambiriufea kahai we menari menumirandaungwa kutu boyari kontaio biua ete niumetang. ");
INSERT INTO amk_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ampafe fi meteyoai nani antu mani, memadu terai meteyo, ‘Yo,’ mae antu kaha mani, memadu meteyo, ‘Bireri.’ Mae mefafora fanai weo nana mani, Saminseni dino wedaya metohong sasari na tonana ne.” ");
INSERT INTO amk_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Metaramio kaiwo dotu tonina ne ampa: ‘Ureng yiwang ureng, tuti dereng yiwang dereng.’ ");
INSERT INTO amk_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Wape ninaia mani imadu we mea mau yeyo, masino inontarai kerira manei memuna we mane wau mani, dohonao bapai ahang fe. Tuti manei bioipa taramurei domoya wai mani, bohong taramurei dowei wai kontaia bioipari. ");
INSERT INTO amk_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Tuti manei dapa wau to mangkutu kaiwo fosa we kia nemu ansung boriai wai mani, bohong nemu ansung siai wai wei kontai. ");
INSERT INTO amk_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Masino manei dawi wau we wodua fieai ro riati kiro bei mani, ro paria ahao kiro boru. ");
INSERT INTO amk_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Manei dedo wau we nemu fiea mani, bohong kaririaia. Tuti dohonao boiaya mano deyo kia fieai ria wau akawuru wori yiwang ahang foi fanai.” ");
INSERT INTO amk_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Metarami kaiwo ninai kontai ampa, amani: ");
INSERT INTO amk_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Wape ninaia mani imadu mau yeyo, menemiwawu mene aitetafosa, mewenadi tuti mano enari kanggani mea fosa. ");
INSERT INTO amk_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Weo na menari tonana ne mani, metohong kariri fio mai we Allai ne arikangne mea metohong kariria fo. Weo Dai nani dino enewawu mandoni kontai, doni dohong wofoi sambewa inontarai eharira fosa tuti mano ebeng fosa; tuti dohong metangfoi ming we inontarai enemirorong mesi fosa tuti mano enemirorong mesi kaha fosa kontai. ");
INSERT INTO amk_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Weo masino menemiwawu te mano enemiwawu mea fosa kontai tera mani, fiembaitai fianai aino mesobua ne? Weo mano efanduhi pajaki we Kaisari fosa ahusa we inontarai eharira saine, wape ea kontaio enemiwawu kontai tonana. Ampafe todoni kontaio menemiwawufo fuba sewasa. ");
INSERT INTO amk_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Tuti masino metohong mahikai we mene doroifosa tera mani, fibeng fianai aino menariao sewa kaiwasa bitoya foi ene enarifo ne? Weo kaiwasa na nu siaio etaroanso Allai kaha fosa kontaio enari tonana. Ampafe mea mani, todoni kontaio metohong beng we mene aitetafosa. ");
INSERT INTO amk_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Tonana mani, todoni kontai memasi, mai kariri mene Dai na rorafaisi mesi paria fo.” ");
INSERT INTO amk_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Yesusi medu aha deyo, “Metanansiau, menari karirio ne bengfo ete ne wetaraifo mani, dohonao menari parai na kaiwasa bitoya foi euremireafo, we ambori ewati fi menari nanai we efiai mea fanai. Weo menari tonana mani wiro mesobu fiembaitafo ria mene Dai na rorafaisi kaha. ");
INSERT INTO amk_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ampafe metohong fieai we mefata inontarai ene pari fi fosa mani, dohonao menari kariri inontarai enari fayafayarai fosa we enari finani na kaiwasa bitoya euremirea fo fanai, weo ea mani esahu tuti fibeng enari fo ambori kaiwasafoi ewatisa. Weo inontarai nanisa efaraise enari tonanai na munu agama Yahudi fo tuti na rangfo ete na katai kaiwasa bitoya era naya fo, ambori kaiwasafosa etaparandinsa. Mearomioaifa we inontarai tonana nesa esobu ene fiembaitafo na fi enari tonana fo ampa, amani na kaiwasa efiaisa tonana fo. ");
INSERT INTO amk_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Wape mea mani masino metohong fieai we mefata inontarai ene pari fi fosa mani, metohong worawai, dohonao mewarami dowei wai deitawang fi mewarami domoya wai dohona fo fanai. ");
INSERT INTO amk_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Todoni kontaio fi metohonai we mefata inontarai ene pari fi fosa naya fo, metohong worawai, ambori mene Dai mano deti fio dadiwa fo biai fi menari tonana fo ki.” ");
INSERT INTO amk_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Masino metutanai we Sempaisi mani, dohonao metutang kariri inontarai enari fayafayarai fosa fanai. Inontarai nanisa etutang Sempaisi mani, enemirorong piraise we era wa etoari na munu agama Yahudi fo tuti na rang borirufo, ambori kaiwasa ewatisa. Mearomioaifa we inontarai nanisa esobu ene fiembaitafo na fi enari tonana fo ampa, amani na kaiwasa efiaisa tonana fo. ");
INSERT INTO amk_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Wape meteo metutang Sempaisi mani, mesuai to mene munu rorong fo afui, mehafe mene rahutufo tuti metutang mene Dai wiro ati pari kahai nani. Ambori mene Dai mano deti fi menari worawai nani dohong fiembaitafo we mea. ");
INSERT INTO amk_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Kontai metutang Sempaisi mani dohonao metutawawera kaiwo memadura fo pampang kariri inontarai etaroanso Sempaisi kaha fosa fanai. Weo ea mani enemitituaitai eteyo emadu kaiwo bitoya mani, wedaya Sempaisi taraoai sewa tuti yoa we fi etutang wea fo ki. ");
INSERT INTO amk_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Dohonao mene tarai karirisa fanai, weo fianai aino metutang weai nanai, metutangna kaharai mae Dai deitawanai kawuru ampa. ");
INSERT INTO amk_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ampafe metutang tonina, ‘Amene Dai Wau na Waidani, Kadono wonomuwai atori we mirarebanai, ");
INSERT INTO amk_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Kadono nemu weMananuwa da ma, tuti nemu awiaio etohong kaririai na Waidani wa, ametohong kaririai na nunei kontai. ");
INSERT INTO amk_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Bohong fiang demoyarai we amea na rahida bonini. ");
INSERT INTO amk_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Boiai amene sasari ametohoni nei, kariri amea kontaio ameteiai inontarai ene sarawaio etohonai we amea fo. ");
INSERT INTO amk_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Dohonao tua amea ametohong kariri fi sofao weanggari amea we amenari sasarifo fanai, tuti tawing amea ambori amekaharai weru mano Kerira foi. Weo Wauno Mananu wemambiriu paria, mano ametato Wau we fitawafa. Antu.’ ");
INSERT INTO amk_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Weo meteiai mano enari sarawai we mea wasa mani, mene Dai na rorafaisi ambori deiai mene sasariwai kontai ki. ");
INSERT INTO amk_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Wape wiro meteiai inontarai siai ene sarawai kaha mani, mene Dai kontaio wiro deiai mene sasariwai kaha.” ");
INSERT INTO amk_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Meteo mewepuasa mani, dohonao mene tarai kariri inontaraio enari fayafayarai fosa we meuremi to ung fanai. Ea mani etua euremifo tonanai ambori etainawiai we kaiwasafoi we inontarai ewepuasa disa. Mearomioaifa we fi enari we inontarai ewatisa tonana fo, finanai wefiembaitai wesa ampa, amani na kaiwasa efiaisa tonana fo. ");
INSERT INTO amk_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Wape mea mewepuasa mani meruai meuremiwa tuti merari menumiwa, ");
INSERT INTO amk_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ambori manei wiro deitawang mea we mewepuasa wa fanai. Mae mene Dai na rorafaisi mano wiro ati pari kahai foi andi deitawanafo. Tuti Daio deitawang fio dadiwa fo nani ambori dohong fiembaitafo we mea ki.” ");
INSERT INTO amk_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Wiro mefanduhi ra na nunei karerai we mea fanai, weo ra nani ambori wohere dani, raima soi, tuti mananapi era ma etotafi ambori ehamananai. ");
INSERT INTO amk_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mae mefanduhi te ra na Waidani, weo na Waidani wohere dani kahai, raima soi kahai, tuti mananapi era wa etotafi ambori ehamananai kaha. ");
INSERT INTO amk_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Weo na doni mene rafoi wiatai naya mani, na nanai kontai menemirorongwai niayai nai.” ");
INSERT INTO amk_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Tauremine mani wepadamarang we tane tarainei. Ampafe masino meuremiwa mamarampoti mani, mene taraiwai sentenang dansairai. ");
INSERT INTO amk_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Mae meuremiwa fayou mani, mene taraiwai memantiti sentenang kontai. Ampafe masino sambewaraio nayai na mea wa mamantitia mani, memamantitia tuti ne mamantitifo sewa aha. ");
INSERT INTO amk_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Wiro inontarai manei wewoming we mananu mandu kaha. Weo nana mani ambori enewawu manei mae enerireu mano wei foi ki. Ete niari kariri manei ne kaiwofo mae kiobu tarang we mano wei foi nengfo ki. Tonanai kontaifa we mea, wiro mewewoming we Seng Allai tuti mewewomong we doi ruhia kaha.” ");
INSERT INTO amk_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Ampafe yeikaririai we mea yeyo, dohonao mearomikuayai we meminohi toa wa fe, amani kariri fianai aino metang fo tuti metunung fo fanai. Tuti wiro mearomikuayai we mene taraiwai fanai kariri fiani aino mesansungna wa fe. Weo mene ansengwai mani dedai sewa fiang tuti mene taraiwai dedai sewa ansungno mesansungna fo. ");
INSERT INTO amk_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Mewati kariri romufosa. Wiro etanang fi kahai, eteting fi kahai, tuti efanduhi fiang na munu etainunung fi naya fea kaha. Tonanai ki wape mene Dai na rorafaisi meinenang ene fiangfo wesa. Mea mani metadai sewa romufosa. ");
INSERT INTO amk_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Na mea kiai mandoni dino na ne arohuayai we minohi toa fo, wemambiriu we yabi ne ansengfoia deuroi kuteai aha ne? ");
INSERT INTO amk_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Tuti we fiani mearomikuayai we fi mesansungna fo wei ne? Mewati kariri kununumifoi we ne weainarifo. Ainari nani wiro dohong fi kaha, tuti sungfi kaha, wape Seng Allai niariri mahikai. ");
INSERT INTO amk_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Wape yeisaharai we mea mau, Mananu Salomoi kontaio ne ra bitoya tonanai, wape ansung sensungna fo kontaio wiro wea mehikai kariri ainarifo nani kaha. ");
INSERT INTO amk_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ninoio weainaria denteng nani, rahida nini sifu wape aha mani ferami aha we nunumi. Tonanai wape Allai miani mehikai paria. Nana mani, mano meroasoai turura kaha ne mea, ambori Allai sensung mea kontai ki. ");
INSERT INTO amk_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ampafe dohonao mearomikuayai tuti memadu meteyo, ‘Fianai aino ambori ametang ne?’ ete ‘Fianai aino ambori ametunung ne?’ Tuti, ‘Fianai aino ambori amesansungna ne?’ ");
INSERT INTO amk_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Weo, fi tonana ne, inontarai mano etaroanso Sempaisi kaha fo ansaino erurai esera wea ne. Wape mea mani, mene Dai na rorafaisi deitawanai ampa we fi tonana ne metohong weai paria. ");
INSERT INTO amk_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Wape mesera fafong we Allai ne weMananufo tuti we menemirorong mesi toyari ne dawiafo. Nanaia mani fi metohong weai nanai ambori Allai dohonai kontai ki. ");
INSERT INTO amk_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ampafe wiro mearomikuayai we fianai aino ambori mesobuai na rahida sua ahang foi fanai. Weo dadirao rahida bonini demoyarai we rahida bonini, wiro aromikuayai we rahida sua ahang foi fanai.” ");
INSERT INTO amk_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Wiro metinggai funong inontarai fanai ambori Seng Allai kontai wiro kiutu kaiwo kariri mea kaha. ");
INSERT INTO amk_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Weo fianai aino metinggairai we inontarai siai fo, ambori Allai kiutu kaiwo kariri mea nai kontai ki. Tuti mene metitua inontarai siai na metinggaisa nana fo, Allai yu we titua mea nayai kontai ki. ");
INSERT INTO amk_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","We fianie ai nukahai niayai na mene doroifoi urengfo mewati pari, mae airape niayai na meuremiwai mewatioi kahai nina? ");
INSERT INTO amk_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Todoni fino metei we mene doroifosa meteyo, ‘Doroie, ro ma ikabi ai nukahai niayai na uremuwai wo,’ wape airape niayai pampang na meuremuwa wiro mewatioi we mehabioi kaha. ");
INSERT INTO amk_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Inontarai menari fayafayarai ne meai ne, mehabio airape niayai na meuremiwa akawuru wo, ambori mewatipa ai nukahai niayai na mene doroifoi urengfo we mehabioai werui fe.” ");
INSERT INTO amk_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Wiro metohongno fio mararebana fo we fiawerafosa fanai, weo nana mani etaraberasa eharari mea aha. Tuti wiro mehabi mene mutiarafo we fiaifosa fanai, weo nana mani ambori etaraberasa etaha titawanai aha.” ");
INSERT INTO amk_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Metutang weai ambori ohonai ki; mesera weai ambori mesobuai ki; meboi rahutufo ambori fai we mea ki. ");
INSERT INTO amk_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Weo mano etutangna fosa ambori ohonai wesa ki; mano esera wea fosa ambori esobuai ki; tuti mano eboi rahutu fosa ambori fai wesa ki. ");
INSERT INTO amk_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Na mea kiai, mandoni dino ne arikangfoi dutang we roti mani dohong kamiei wei ne? ");
INSERT INTO amk_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ete dutang we diang mani dohong tawai wei ne? ");
INSERT INTO amk_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ampafe mea mewarami aipaya tonanai ki, wape mewaitawang metohong ne bengfo we mene arikangfosa. Nana mani mene Dai na Waidani ne dohonafo sewa weru mea aha. I ambori dohongno ne beng sewa fo we mano etutani fosa ki. ");
INSERT INTO amk_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Na fifiani kontaio, menari sua inontarai siai fosa, mai kariri metawi weai we ea kontai enari we mea fo. Weo Hukumi Musai soi fo tuti aunau nabifosa etaunauwa fo, weneung naya finanai.” ");
INSERT INTO amk_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Mesera we mesuai to Allai ne Mananu rorong fo mani, merurai we mesuai na rahutu dadira fo. Weo rahutu tuti rang to ne karirafo mani tirera tuti fiabai, tuti kaiwasa bitoya esuai nai. ");
INSERT INTO amk_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Mae rahutu tuti rang to numainufo mani ketui tuti dedira, tuti inontarai maneiru teai ansaino esobua ne.” ");
INSERT INTO amk_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Metanansiau we nabi tarai kahaio era we mea ma fosa. Ea mani, enari we inontarai eroaso yau tuti enemirorong denteng toyari domba, wape tarai we ea mani ene tarai toyari serigalao memuna. ");
INSERT INTO amk_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ampafe metaroansosa terai na fianai aino enari fo. Ne tarai kariri aibongfo, amani wai sirarami nei wiro webong angguri kahai tuti boburainei wiro webong andori kaha. ");
INSERT INTO amk_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Tonanai kontai we ai koi denteng foi mani, ne bongfoi denteng, mae ai koi kerira foi mani ne bongfoi kerira. ");
INSERT INTO amk_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Todoni kontaio, ai koi denteng foi wiro ne bongfoi kerira kaha, ete ai koi kerira foi mani wiro ne bongfoi denteng kaha. ");
INSERT INTO amk_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Mae ai koio ne bongfo denteng kaha foi, todoni kontaio robani tuti kabioi to adiafoi. ");
INSERT INTO amk_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ne tarai kariri aifoi we aroansoi na ne bongfoi, tonanai kontai we nabi tarai kahai nanisa ambori metaroansosa na fianai aino enari fo. ");
INSERT INTO amk_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Wiro mano sahu we Yau deyo, ‘Sengwa Wau, Sengwa Wau!’ andino ambori suai to Allai ne weMananufo na Waidani ne kaha, manta mano dohong kariri Dai na Waidani ne awiafo tera foi. ");
INSERT INTO amk_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Na rahida Allai kiutu kaiwo nai foi kaiwasa bitoya ambori emadu we yau eteyo, ‘Sengne Waune! Raminde nanai na wonomune ametairiri Allai ne Kaiwone toyari nabi fafong fosa etairiria fo, na wonomune ametata inggira bitoya nai, tuti na wonomune amenari fitantuma bitoya kontai nai mae?’ ");
INSERT INTO amk_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Wape rahida bonani ambori imadu parai wesa aha yeyo, ‘Wiro yeroang mea na ea kaha, inontarai mano menari fi karira ne mea, mera weru arohureane.’ ” ");
INSERT INTO amk_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ampafe mano tarao nehu kaiwofe ninai kiai tuti dohong kaririai na mai foi mani, ne tarai toyari inontaraio sewai niari ne munu doa na kamamieia mutu. ");
INSERT INTO amk_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ampafe rahida bo metangfoi miung, foafoi dautai tuti dedukafoi bia fo mani, wiro munufoi tibari kaha, weo sau tawang diri neungfoi na kamamieia mutu fefe. ");
INSERT INTO amk_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Mae mano tarao nehu kaiwone, wape dohong kariria kaha foi mani, ne tarai toyari inontaraio webonggoi foi, i biaung ne munufoi dohoni wiatai sauwai arora na ninuaing nuwowongfo. ");
INSERT INTO amk_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ampafe rahida bo metangfoi miung, foafoi dautai tuti dedukafoi bia tete munufoi mani, ambori sobariri. Tuti ne aikahiafoi kerirawa kiai aha.” ");
INSERT INTO amk_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesusi medua kai nana fo, kaiwasa bitoya etoari na nana fosa epapuhung paria we deunau toa fo. ");
INSERT INTO amk_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Weo Yesusi deunau kariri mano wemambiriu paria we deunau tonana, wiro deunau toyari kaiwo batangno ene mantaunau Kaiwo Musai soi fosa emadura fo kaha. ");
INSERT INTO amk_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesusi biari na wiwoifoi meufo, kaiwasa bitoya paria era riati. ");
INSERT INTO amk_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Na nanai inontarai meninang kusta manei da wei ma, tuti disangkapao awebukafo na awerengfo mae medu wei deyo, “Daie, wau wemambiriu ne, maya mani, nari yau yenteng weru nehu maninangnei.” ");
INSERT INTO amk_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ainanaya Yesusi suba warangfoa wa sauwi tuti medu wei deyo, “Yo, imaya. Bonteng to!” Tatofang kutu nanai kontaio maninang kusta foi niai werui tuti dentengna. ");
INSERT INTO amk_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ainanaya Yesusi medu wei aha deyo, “Aromuoaifa! Wiro boiriri fi inari ninai weo inontarai siai manei fanai, mae ro to imamifoia tuti butani we deti kariri nemu taraiwai we bontengna wa. Mayeai bohong korbanifeai we Allai we nemu bontengna wa kariri fianai aino Musai soia fo. Nana mani deinawiai we kaiwasa bitoya foi we bonteng ampa.” ");
INSERT INTO amk_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Rahida bo Yesusi da wa suai to bendari Kapernaumi fo, inontarai Yahudi kaha manei, i mani inontarai fuba yu rai mamuna Roma fosa manei dine, da wei ma, dutani deyo, ");
INSERT INTO amk_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Daie, fata yau wo, nehu womingfoi meninangnao fiaya, wiatai na nehu munufi fo tuti sodai dadira paria.” ");
INSERT INTO amk_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesusi yoa wei deyo, “Yo ambori ira wa inariri denteng ki.” ");
INSERT INTO amk_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Manamo inontaraifoi yoa wei deyo, “Daie roa fanai, weo imai we yemang we wau na nehu munufoi kaha. Ampafe modu kaiwofeai na waroi teraia, nana mani nehu womingfoi ambori denteng kaririai ki. ");
INSERT INTO amk_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Weo yau kontai nehu fuba isomi wei manei, tuti iru afai mamuna fea kontai. Ampafe imadu we manei yeyo, ‘Ro,’ nana mani da kaririai, tuti imadu we manei aha yeyo, ‘Ro ma,’ nana mani da kaririai ma. Ete we nehu mangfatafoi yeyo, ‘Nari fininai,’ nana mani niari kaririai. Yeitawanai we Dai Wau tonanai kontai. Fiani aino boyoa mani, kariria rai.” ");
INSERT INTO amk_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesusi tarao rai mamuna fuba foi medu tonanafo pepuhung paria. Ainanaya medu we mano erariati fosa deyo, “Kei! Inontarai nini andiarana ne. Na inontarai Israeli nesa kiai wiro iwati manei yoaso yau ne fuba kariri tonina kaharai. ");
INSERT INTO amk_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Yeisaharai we mea yeyo, kaiwasa bitoya ambori era na katai doni kontai na rea diru foi tuti rea aha foi ma, efanduhisa ria Abrahami, Isaki tuti Yakupi we etohong muniara na Allai ne weMananufo ki. ");
INSERT INTO amk_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Wape inontarai mano katai wemananu nani eneni fosa, ambori Allai sosa to boriei weru ne weMananufo to katai memantiti foi. Na wanai ambori esodai ne karirafo tuti esaia etamirai paria.” ");
INSERT INTO amk_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ainanaya Yesusi medu we rai mamuna foi deyo, “Barabera waua, we fianai aino roasoai nanai kaririai ampa.” Na tatofang kutu nanai kontai ne womingfoi dentengna. ");
INSERT INTO amk_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesusi da wa sobu Petrusi ne munufoi fo, detio Petrusi niong wiwini we meninang rirora wiatai na ne fatafoi. ");
INSERT INTO amk_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ampafe Yesusi warawa yu na warangfo, na tatofang kutu nanai kontaio maninangfoi niai weruria. Mayeai wiwingfoi doari ayai wesarawiri we Yesusi. ");
INSERT INTO amk_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Wofoi sawaia de weayewia nanai, kaiwasa eha ene inontarai inggira dohonsa bitoya we Yesusi ma. Tuti na kaiwo rabuang boyari kawuru mae Yesusi data inggirafoi kiai tuti niari kaiwasa emaninang wei fosa kiai ebeng. ");
INSERT INTO amk_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Fianai aino Yesusi niari nanai, mai kariri fio nabi Yesayai meduraia fo deyo, “Andino sodua tane tafanahangfe ne, tuti sodua tane maninangfi ne.” ");
INSERT INTO amk_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesusi deti kaiwasa bitoya paria era ma etoawariri, ampafe medu we ne inontarai ewesuraya mandu fosa demisa we etafai to ruru eneung dowei fo. ");
INSERT INTO amk_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mayeai mantaunau Kaiwo Musai soi fo manei da wei ma, medu wei deyo, “Dai Mantaunaune waune, yeo ira ria wau to katai bodoni kontaio dino ro oa fo.” ");
INSERT INTO amk_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ampafe Yesusi medu wei deyo, “Wintumang kamirei rorong nei ne kamirei we wiatai nai, tuti romunei kiai kontaio ne aisangging. Wape Kaisung Inontarai nei ne pari katai we wiatai nayai.” ");
INSERT INTO amk_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ainanaya Yesusi ne inontarai da riati manei kontai deyo, “Daie, boiai yau ira wa kio dai mireha isarai akawuru wo.” ");
INSERT INTO amk_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Manamo Yesusi deyo, “Ro ria yau, mae tua mano eroaso yau kaha fosa we esarai mano emarareha fosa ki.” ");
INSERT INTO amk_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Mayeai Yesusi dautai tuti ne inontarai ewesuraya mandu fosa to wafoi, ainanaya etafai to ruru eneung bo dowei foia. ");
INSERT INTO amk_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Etafaia mairabuang mayeai dedukafoi bia tantuma na rurufoi, andeisafoi dipuo wafoi tuti dutuwia adareti etaisui. Wape Yesusi wiata dena na wa rorongfo. ");
INSERT INTO amk_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ampafe ne inontaraifosa era wafui ebauni eteyo, “Daie, boari miai fata tata wo, tanai rai.” ");
INSERT INTO amk_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ainanaya Yesusi yoa wesa deyo, “We fianie mematai nina? Todonie meroasoa kahai nina?” Mayeai Yesusi doari ayai deikutu wanangfoi tuti andeisafoi, ainanaya rurufoi mering na tantumara. ");
INSERT INTO amk_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Yesusi ne inontarai ewesuraya mandu fosa epapuhung paria we fitantuma nanai. Ampafe emadu wawerasa eteyo, “Inontarai nini mani mandoni dine, donio sua wanangnei tuti andeisanei mani mering kaririai nina?” ");
INSERT INTO amk_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Etafaia sobu ruru eneung dowei foi na Gadara nanai, inontarai inggira dohong suru mandu ura na fafofo we Yesusi ma. Inontaraifo suru umamuna paria, ampafe manei wiro wemambiriu we da kefang suru kaha. ");
INSERT INTO amk_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ura mae usahu ureyo, “Allai ne Kaisungne waune boyo nari auru tofino? Wiro rahidane mai kaharai mae, boyo ro ma we ru aiboio auru mung kanggani auru finina e?” ");
INSERT INTO amk_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Waroi weru katai nani kahai mae, fiai rabuang bei enaya esung na nanai. ");
INSERT INTO amk_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ampafe inggirafosa etutang Yesusi paria eteyo, “Boyo bata amea to boriei mani, bemi amea amesuai to fino fiai rabuangfoia.” ");
INSERT INTO amk_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ainanaya Yesusi demisa, deyo, “Mera weruaia!” Ampafe inggirafosa era to boriei tuti esuai na fiai rabuangfoi. Ainanaya fiaifosa emito beyaria esea na katai kenataterafoi to rurufoi aweu tuti emarareha naya. ");
INSERT INTO amk_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Mano ewaitawang wedua fiai fosa emito to bendarifoia, eteisaharai kariri fianai aino ewatioai kai nanai we kaiwasafoi tuti kariri fianai aino inontarai mandu inggira dohong suru fo suru usodaira fo. ");
INSERT INTO amk_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ampafe kaiwasa fuba na bendari fosa emito we Yesusia. Ewatioi mani etanggoari paria we da weru ene kataifoi. ");
INSERT INTO amk_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Mayeai Yesusi dautai to wa etafai nai foi ayai, ainanaya etaraberasa etafai to ruru eneung dowei foi aha, amani to ne bendarifoi ahawaru. ");
INSERT INTO amk_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Na wanai inontarai manea eha inontarai fiaya wiatai na andaung wowongfo we Yesusi ma. Yesusi detio enari tonanafo deitawanai we eroasoafo fuba paria, ampafe medu we inontarai fiaya foi deyo, “Kaisungne waune, tawang enemurorongwaia mitu. Yeiai nemu sasarifi ampa.” ");
INSERT INTO amk_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ampafe mantaunau Kaiwo Musai soi fo maneiru teaio enayai na nanai fosa esaimumung wawerasa eteyo, “Inontarai nini deibera Seng Allai.” ");
INSERT INTO amk_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Wape Yesusi deitawang enemirorongfoi, ampafe medu wesa deyo, “We fianie menemitituai fi karira na menemirorongwai nina? ");
INSERT INTO amk_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Doni aino mawa ne: imadu yeyo, ‘Yeiai nemu sasarifi ampa,’ ete yeyo, ‘Boabari wau, ka nemu andaungwai, tuti roa’? ");
INSERT INTO amk_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Wape yeinawiai we mea, na yohong inontarainei denteng tonina ne, ambori mewaitawanai weo na nunei ninai, Kaisung Inontarai nei andino ne mambiriu we deiai sasari fine.” Ainanaya Yesusi medu we inontarai fiaya foi deyo, “Boabari wau, ruai nemu andaungwai, ro to nemu munufoia.” ");
INSERT INTO amk_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ainanaya inontaraifoi doabariri tuti daraberahi to ne munufoia. ");
INSERT INTO amk_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kaiwasa bitoya foi ewati fi kawariai nana fo ematai paria tuti etaparanding Allai eteyo, “Allai ne mambiriufo fuba paria! Tuti dohong ne mambiriu nanai we inontarainesa kawuru ampa.” ");
INSERT INTO amk_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Mayeai Yesusi da weru katai nani. Da wa mani detio inontarai fianduhi doi pajaki we parenta Kaisari fo manei wonong fino Matiusi, minohi na munu pajaki foi. Yesusi medu weia deyo, “Ro ria yau.” Anseung ahang kahai mae Matiusi doabariri tuti da ria Yesusi. ");
INSERT INTO amk_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Yesusi da wa minohi dampi na Matiusi ne munufoi nanai, inontarai efanduhi pajaki we parenta Kaisari fo efau tuti inontaraio kaiwasa bitoya foi esahusa we inontarai ewesasari fosa, era wa ewatai etampi ria Yesusi tuti ne inontarai ewesuraya mandu fosa. ");
INSERT INTO amk_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Inontarai eweFarisi maneiru ewati finanafo, etutang bera Yesusi ne inontarai dirisa fosa eteyo, “We fianie mene mantaunaufoi dampi ruhiai ria inontarai efanduhi pajaki we parenta Kaisari foi tuti inontarai ewesasari fosa ninai?” ");
INSERT INTO amk_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesusi tarao etutang tonanafo, yoa wesa deyo, “Inontarai etanteng nesa mani etohong we manggarawangnei kaha, mae mano emaninang fosa. ");
INSERT INTO amk_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ampafe mera wa menemitituai sauarai kariri kaiwo rabuang dotu na Kaiwofoi tonina ne: ‘Wiro yawi we inontarai etohong korbani fiahung we yau kaha, mae fi yawi pari wea fo mani, earomio inontarai siai.’ Weo wiro ira ma we isahu inontarai emararebana fosa kaha, mae ira we isahu inontarai sasari fosa.” ");
INSERT INTO amk_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Mayeai Yohanesi mano webaptisi kaiwasa foi ne inontarai erariati fosa, era ma emadu we Yesusi eteyo, “Todoni fino, amea tuti inontarai eweFarisi nesa amewepuasa, wape nemu inontarai eraria wau nesa bireri nina?” ");
INSERT INTO amk_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesusi yoa wesa deyo, “Tofino! Ne tarai kariri mandirau mang foi tuti ne inontarai wenotisa to ne muniara mandirau foi. Na rahida mandirau mang foi minohi riasa nanai enemirorongfoi fituaya rai e? Wape rahida we mandiraufoi niayai na nanai riasa ahang kaha foi ambori da ma ki, rabuang bonani dino ambori ewepuasa ki. Tonanai kontai, nina mani inayai riasa ampafe ewepuasa kaha, wape rahidao ambori ira werusa foi da ma ki, rahida nanai aino ewepuasa ki. ");
INSERT INTO amk_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Manei ne ansung mamo feai tai mani wiro dawa kobuai na ireu aburung waworu fea kaha, weo nana mani ireu aburung waworu fo yabi we ansungfo ambori ansung mamo fo mayabu fo fuba aha. ");
INSERT INTO amk_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Tonanai kontai we angguri waworu nei mani, wiro ariri to aderi sapi rerawa memo bei kaha, weo angguri weworu foi ambori wiwua wedaya aderi sapi rerawa memo foi tei. Nana mani anggurifo tibatara, aderi sapi rerawa foi kerirawa. Wape angguri weworu foi ariri tono aderi sapi rerawa weworu bei kontai, ambori aderi sapi rerawa foi tuti anggurifoi ubeng ruhiai.” ");
INSERT INTO amk_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesusi doa medu we Yohanesi ne inontarai erariati fosa tonana rai mae, inontarai wenunggamiei we munu agama Yahudi na kataifoi da wei ma. Disangkapa awebuka na awerengfo, tuti medu deyo, “Nehu kamitungfoi arahio mireha. Wape yutang we wau roa ruai waramuwara wa sauwi ambori suwi aha.” ");
INSERT INTO amk_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ainanaya Yesusi doabariri da riatia, tuti ne inontarai ewesuraya mandu fosa era kontai. ");
INSERT INTO amk_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Na rang rabuang, wiwing manei da ria Yesusi na kurufuifo, wiwing nani meninangno rika defairi tuti maninangfoi sodairi defuina suraya boru ampa. Da kefang Yesusia warangfoi disangso ne ansung awerengfo. ");
INSERT INTO amk_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Weo enetituaitai deyo, “Warahunei disangso ne ansungfo terai ki, ambori yenteng ki.” ");
INSERT INTO amk_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Na kutu warangfo disangso Yesusi ne ansungfo nanai, kiaberahi deti we wiwingfoi tuti medu wei deyo, “Kamitungne waune, tawang enemurorongwaia mitu, weo nemu roaso yau wa wedaya bonteng ampa.” Na kutu nanai kontaio wiwingfoi denteng. ");
INSERT INTO amk_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Mayeai Yesusi da wa sobu mano wenunggamiei we munu agama foi ne munufoia, na nanai deti inontarai ebui suling fosa tuti kaiwasa esai rayai fosa. ");
INSERT INTO amk_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Medu wesa deyo, “Mera to boriaia mehai, weo kamitungnei wiro mireha kaha, manta dena.” Ampafe emarari Yesusi paria. ");
INSERT INTO amk_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Data kaiwasa bitoya foi era to boriaia, mayeai Yesusi suai to rorong arikangfoi wiatai nai foi afui tuti yu na warangfo, na kutu nanai kontai kamitungfoi suwi aha. ");
INSERT INTO amk_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kaiwo kariri fitantuma Yesusi niari nanai defai wari nufoi sentenang. ");
INSERT INTO amk_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ainanaya Yesusi da weru munu nani fai. Da wa rang rabuang mani, inontarai uremifafa mandu ura riati mae usahu ureyo, “Dauti ne Kaisungwa wau, aromuo auru!” ");
INSERT INTO amk_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesusi suai to munu rorongfo ampafe ura wei awafui, ainanaya dutang suru deyo, “Muroasoai we inari muru mani muranteng rai e?” Ampafe uroa ureyo, “Yo, Daie, auroasoai.” ");
INSERT INTO amk_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ainanaya Yesusi waratawang uremifo tuti medu deyo, “Kariri muroasoawa finanai kawariai kaririaia.” ");
INSERT INTO amk_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Mayea mani uremifo tabau uwati nayai. Ainanaya Yesusi deretawang suru na tapapa we ambori urairiri finanai we manei fanai. ");
INSERT INTO amk_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Wape ura wa mani uwuwu Yesusi na katai nani sentenang. ");
INSERT INTO amk_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ainanaya inontaraifo suru ura wa mae inontarai manea eha weborotamu inggira dohoni manei we Yesusia. ");
INSERT INTO amk_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ainanaya Yesusi data inggirafoi weruri. Na tatofang kutu nanai kontai medu nari aha. Ampefe kaiwasa bitoya fosa epapuhing paria, tuti emadu eteyo, “Wiro fitantuma nina tawatioai na nu Israeli nei kaharai.” ");
INSERT INTO amk_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Wape Farisifosa emadu wawerasa eteyo, “Na mambiriu sobuai ria inggirafosa ene mano wenunggamiai foi data inggirafosa nina.” ");
INSERT INTO amk_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Ainanaya Yesusi da wariai deunau na munu agama Yahudi na bendari tuti munue nanaia kai. Deiriri Kaiwo Mahikai fo kariri Seng Allai da weMananu ma fo. Kontai niari kaiwasa esodai maninang bodoni konta fosa ebeng aha. ");
INSERT INTO amk_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yesusi deti kaiwasa bitoya foi nanai arosa paria, weo enemirorong fituayai tuti emararosung, ene tarai toyario domba ene pari mantahung. ");
INSERT INTO amk_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ainanaya medu we ne inontarai ewesuraya mandu fosa deyo, “Aibong etini foi bitoya, wape mano etetini fosa efau kaha, ");
INSERT INTO amk_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ampefe metutanai we mano wenunggamiai we fi etini foi ambori denatu mangfata efau we eteting aibongfo.” ");
INSERT INTO amk_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Rahida bei Yesusi sahu ne inontarai ewesuraya mandu fosa efanduhisa. Ainanaya dohong mambiriu wesa, we etata nuaninu kerira tuti enari mano emaninang fosa ebeng weru maninang esodairi foi tuti weru efanahangfo. ");
INSERT INTO amk_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Yesusi ne inontarai ewesuraya mandu dirisa we rasuli fosa mani ewonomi finina: reantenang mani Simoni (mano sahui we Petrusi foi), Andareasi (Simoni ne tahatuifoi), Yakobusi (Zebedeusi ne kaisungfoi), Yohanesi (Yakobusi ne tahatuifoi), ");
INSERT INTO amk_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipusi, Bartolomasi, Tomasi, Matiusi (mano fianduhi pajaki foi), Yakobusi (mano Alfiusi ne kaisungfoi), Tadeusi, ");
INSERT INTO amk_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoni (mano biriu we inontarai Israeli fosa etoa siai weru Romafosa), Yudas Iskariotio (mano ambori dewayang Yesusi foi). ");
INSERT INTO amk_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesusi demi ne inontarai suraya mandu fosa tuti deretawansa deyo, “Mera to katai inontarai Yahudi kaha fosa eminohi naya wa fanai, tuti wiro mesuai to bendari inontarai Samaria fosa fanai. ");
INSERT INTO amk_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Wape mera we domba enai fosa, nana mani inontarai Israelisa. ");
INSERT INTO amk_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Meteisaharai wesa weo Allai ne weMananufe kefang ampa. ");
INSERT INTO amk_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Menari inontarai emaninang etanteng, metuwi inontarai emarareha fosa esuwi aha, menari inontarai esobu fimaninang kusta fosa ebeng, tuti metata nuaninu kerira fo. Mambiriuo mesobuai tonana fo yohonai arora we mea, ampafe mea kontai menari tonanai arora we inontarai siai kontai. ");
INSERT INTO amk_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Mera mani, dohona meha doi emasi, doi peraki, ete doi tambaga fea fe. ");
INSERT INTO amk_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Dohonao meha rotangfeai ria mea na mene rang rorong wa fanai, meha ansung beru fanai, sapatu, tuti aitatohi fanai, weo mano erufi nesa mani, todoni kontaio esobu fio etohong wea fo ria mano erufi wesa fosa. ");
INSERT INTO amk_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Ampefe mera sobu bendari ete munuefea mani, mesera we inontarai mei we demang we mea tonanafo manei, ambori meminohi riati paria sobu mera nariai aha. ");
INSERT INTO amk_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Mera wa mesuai to munu nani mani, meteyo, ‘Kadeo Sengnei mioang mea.’ ");
INSERT INTO amk_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Inontarai mano ne munufoi nani demang we mea mani, mahikai moanai metohonai nanai nayai worusa. Wape efaraise we etamang we mea kaha mani, mene mahikai moanaio metohonai tonana fo tawera we mea nariai aha ma. ");
INSERT INTO amk_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Tuti na munue ete na bendarifo manea etamang we mea kaha ete emaya we etaramio mene kaiwofo kaha mani, mera werusa tuti mehafa titai kangganangfo weru meawemiwa. ");
INSERT INTO amk_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Mearomioaifa, weo rahida Seng Allai kiutu kaiwo kariri nunei fo, inontarai na bendari Sodomi tuti Gomora fosa, aiboi dohonai wesa fo sayayai sewa aiboi dohonai we mano wiro etamang we mea kahai nani sa fo.” ");
INSERT INTO amk_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Metarami fininai; yemi mea mera we mewuwu wonohunei fo, mene tarai toyari domba enayai rahang serigala rabuang; ampefe mesawai toyari tawai tuti menemirorong mesi toyari muntung. ");
INSERT INTO amk_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tuti metanansiau weduarai, weo ambori inontarai etafu mea tuti eha mea to Majelisi Agama fosara ambori eruba mea na wai na ene munu agama Yahudi fo ki. ");
INSERT INTO amk_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Tuti ambori eha mea tono mano ewewafonia fosa tuti mananufosa euremireafo, weo mea mani inontarai meraria yau di mea fefe. Nanaifa mani, metairiri Kaiwo Mahikai kariri yau fo we ea tuti weo inontarai etaroang Allai kaha fosa. ");
INSERT INTO amk_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Wape eha mea we etutang bera mea mani dohona mearomikuai we fiani aino memadura wa fe, ete todoni memadufo fe. Weo kaiwo fianai aino ambori memadurai na rabuang bonani fo Allai dohonai we mea we memadurai ki. ");
INSERT INTO amk_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Weo na tonanafo wiro meaino memadu fo kaha, mae Dai Allai Nuaninufoi andino medu na mea ne. ");
INSERT INTO amk_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","22","Rahidafo da ma mani, inontarainesa kiai ambori enemirireu mea weo mea mani inontarai meraria yau di mea fefe. Ambori inontarai etawayang ene doroi tera fosa we mano emunsa fosa ki, weo eraria yau fefe. Tuti wawa manei dewayang ne arikangfoi ki weo arikangfoi daria yau, kontai arikangfosa manea ambori etapa etamami einami fosa tuti etawayansa we ene aitetafosa ambori emungsa ki. Wape mandoni dino kikatawanai paria sobu werea naya fo mani, ambori kiaharai weru ne dadirafo ki. ");
INSERT INTO amk_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Ampefe inontarai enari kanggani mea na bendarifea mani mera to bendari siai feai aha. Yeisaharai we mea, wiro mera maino bendari na nu Israeli foa kai kaharai mae Kaisung Inontarai nei da kawuru ma ne. ");
INSERT INTO amk_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Inontarai sobu aunau nei wiro fiabai sewa ne mantaunaunei kaha. Tuti mangfatanei wiro fiabai sewa ne mananunei kaha. ");
INSERT INTO amk_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Mano sobu aunau foi ne tarai kariri ne mantaunaufoi mani demoyara to, tuti womingfoi ne tarai kariri ne mano yufi wei foia mani demoyara to. Mea mani mene Seng di Yau. Ampafe masino esahu Yau we iweBarsebuli nana mani eteikanggani mea sewa aha.” ");
INSERT INTO amk_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Dohona mematai inontarai tonana nesa fanai. Weo fio adiwara ne kiai ambori atioai ki, tuti fio ohonai we kaiwo werorong fo kiai kontai ambori tarami parai ki. ");
INSERT INTO amk_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Kaiwo imadurai we mea na dirufo, kaiwo nanai memadurai na rahidafo aha, tuti ne isaimumunai to metaramiwa, kaiwo nanai mesahututirai na kaiwasa bitoya foi aha. ");
INSERT INTO amk_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Tuti dohona mematai inontaraife weo emung tane tarainei, wape ene pari mambiriu we emung tanumianinunei. Mae memataiti dino Allai, weo I mani wemambiriu we miung tane tarainei tuti tanumianinunei na Soroha rorong foi ne. ");
INSERT INTO amk_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Romu sinsumiri mandu mani awayang suru we doi seni bei, wape manei wiro sau funomai to kahofa nuwowongfo meu na boriei weru Dai ne dawiafo kaha. ");
INSERT INTO amk_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Menumirandaungwai kiai kontai detori sentenang. ");
INSERT INTO amk_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Ampefe mematai fanai, weo mea mani metadai sewa romu sinsumirinesa.” ");
INSERT INTO amk_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Inontarai mandoni dino yoa na kaiwasa bitoya euremireafo we daria yau mani, yau kontai iroa wei na Dai Allai na rorafaisi urengreafo. ");
INSERT INTO amk_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Wape mandoni dino fefora na kaiwasa bitoya euremireafoa we daria yau kaha, nana mani yau kontai ifaforai we Dai Allai na rorafaisi urengreafo.” ");
INSERT INTO amk_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Dohona meteitarahio ira ma ninai ika mai we nunei fe, weo wiro ika mai kaha mae ika mamunafo. ");
INSERT INTO amk_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Weo ira ma ninai iwedaya wori: ‘Kaisung manei dapa tamanai ki, kamitung manei dapa inanai ki, tuti urawing manei dapa niong wiwini ki. ");
INSERT INTO amk_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tuti mano eweaiteta fuba sewa fosa mani, inontaraio na munurorong bonani fo mantaunsa.’ ");
INSERT INTO amk_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Inontarai mandoni dino enewawu tamana ete inanai sewa yau mani wiro mei we daria yau kaha. Tonanai kontai we mano enewawu ne kaisungfoi ete ne kamitungfoi sewa yau foi, wiro mesi kontai we daria yau kaha. ");
INSERT INTO amk_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Tuti inontarai mandoni dino miaya we sodua ne aitabafoi tuti daria yau kaha, amani wiro meinenang we eteiberahi, enari kanggani, tutu emuni toyari yau kaha mani, wiro mei we daria yau kaha. ");
INSERT INTO amk_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Mandoni dino derara mantauni ne ansengfoi sewa weru daria yau fo mani ambori ne ansengfoi wioru ki, mae mandoni dino na nufi ninai enewawu yau awao wonohune wedaya tarahi mireha kontai ki, i ambori sobu numainufo ki.” ");
INSERT INTO amk_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Mandoni dino demang we mea mani, i kontai demang we yau, tuti mandoni dino demang we yau mani, ambori demang we Dai, mano demi yau nei ki. ");
INSERT INTO amk_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Mandoni demang we nabi manei, weo i deitawanai we inontarai nani nabi dine, ambori sobu fiembaitafo mai kariri nabifo enengfo. Kontaio mandoni dino demang we inontarai enerorong mesi mani weo deitawanai we inontarai nani enerorong mesi dine ambori sobu fiembaitafo mai kariri inontarai enemirorong mesi fo enengfo. ");
INSERT INTO amk_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Tuti mandoni dino dohong mereha danunanang kuteai ki we nehu inontarai katui nei we daria yau fo mani, tarai, imadurai we mea mau yeyo, ne fiembaitafo wiro nai weruri kahai ki.” ");
INSERT INTO amk_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesusi dohong kaiwo we ne inontarai ewesuraya mandu fosa tonanaia fo, da weru katai nani we deunau tuti wiuwu Kaiwofo na bendari bitoya wa na nana fo. ");
INSERT INTO amk_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Rabuang bonani Yohanesi mano webaptisi kaiwasa foi niai na aitamu rorong fo tuti tarao kariri fianai aino Kristusi niari fo, ampafe demi ne inontarai maneiru teai itora wa itorutang bera Yesusi. ");
INSERT INTO amk_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Itorutani itoreyo, “Wau mani Mananu Mamparirio ambori ro ma foi di wau e, ete ametamang we inontarai siai manei e?” ");
INSERT INTO amk_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yesusi yoa we sitoru deyo, “Muntorarabera muntoru we Yohanesia muntoraikaririai wei kariri fianai aino muntotaramioa wa tuti muntowatioa wa. ");
INSERT INTO amk_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Mano euremifafa ewati, mano efaya etoa era, mano emaninang kusta ebeng, mano etarami pararo fosa etaramiofi, mano emarareha esuwi aha, tuti mano ene pari fi fosa iwuwu Kaiwo Mahikai fo wesa. ");
INSERT INTO amk_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tuti mano wiro enemirorong soriru we yau kaha fosa, esobu ne maifo.” ");
INSERT INTO amk_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Yohanesi ne inontaraifo sitoru itora wa, ainanaya Yesusi medu kariri Yohanesi we kaiwasa bitoya foi deyo, “Raminde nanai mera to katai wekamamiei minano foi we mewati fiani nai, mewati ninoi wanamba sowawerahi foi e? Bireri, we i mani, inontaraio yu kaiwo mutu dine! ");
INSERT INTO amk_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ampafe mera wa we mewati fiani, mano sensuni na ansung kaiwewa denteng foi e? Bireri, weo inontarai esansunsa na ansung tonana fo mani enayai na munu mananu fo terai. ");
INSERT INTO amk_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ampafe mandoni dino mera we mewatioi ne? Nabi manei e? Tarai, wape yeikaririaifa we mea yeyo mano mera we mewatioi nani mani fiabai sewa nabinesa kiai. ");
INSERT INTO amk_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Weo i mani andino Allai medu kaririai na ne Kaiwofo dotu tono: ‘Mewati ma! Yemi nehu inontaraio kia nehu kaiwone manei, da foni Wau. I ambori meinenang nemu rangfoi we Wau.’ ");
INSERT INTO amk_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Tarai, imadurai we mea mau yeyo, na inontarai fuba saubaunung na nunei nini, manei wiro fiabai sewa weru Yohanesi mano webaptisi nini kaha. Wape na ninai to fongna mani, inontarai mano ehatui sewa na Allai ne mananu rorong fo ansaino efabai sewa Yohanesi fo. ");
INSERT INTO amk_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Na siario Yohanesi dariai we wiuwu Kaiwo Mahikai kariri Allai ne weMananufo paria sobu ninaifa ne, inontarai ewemambiriu na Sengnei etairiri Allai ne weMananufo na wemambiriu paria, tuti kaiwasa efau etapai mae, efau kontai eroasoai tuti era riatai, amani inontaraio raminde eharira tuti emamuna fosa. ");
INSERT INTO amk_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Weo Yohanesi daria kaharai mae, na Hukumi Musai fo tuti Kaiwo nabifosa emadura fo, dotu kariri kawuru ampa we fi tonana ne ambori kawariai ki. ");
INSERT INTO amk_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Tuti memaya we metaramioai mani, yeikaririai we mea we Yohanesi mano webaptisi kaiwasa nini mani, Eliai dine, andino na Kaiwo Mararebana fo dotu kariri we ambori kiawariai aha ma fo. ");
INSERT INTO amk_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Mandoni dino wetarang mani, tarao kaiwo ninai.” ");
INSERT INTO amk_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Yesusi medu aha deyo, “Fiani andino iriwanso kariri inontarai rabuang bonini sa ne? Ea ene tarai toyari arikang eminohi na kondirora mae esahu wawerasa eteyo, ");
INSERT INTO amk_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Amerohi rarung mirising fo we mea, manamo memahai kaha, ameba kayowa wape wiro mesai kaha.’ ");
INSERT INTO amk_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Weo Yohanesi nini da ma mani, wepuasa tuti dunung angguri kaha, manamo meteyo, ‘I mani Saminseni niai nai.’ ");
INSERT INTO amk_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ainanaya Kaisung Inontarai nei da ma mani dampi, dunung, tuti memadu meteyo, ‘Mewati inontaraifoi denanggoing, meyeru biriu, tuti firao mano efanduhi pajaki we parenta Roma foi tuti inontarai sasari.’ Wape Seng Allai sewai sewa. Mano esomi wei fosa etainawi ne awaifo nanai na fimai etohong toa fo.” ");
INSERT INTO amk_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Yesusi niari fitantuma bitoya paria na bendari beiru teai, tonanai ki wape inontaraifosa wiro etaraberasa weru ene sasarifo kaha, wedaya deikangganisa deyo, ");
INSERT INTO amk_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Inontarai Korasimi mesobu ne karirafo rai! Tuti inontarai Betsaida ne mea kontai, mesobu ne karirafo konta rai. Weo fitantuma bitoyao inariri rahang mea tonina ne, masino inari na bendario boriai weru Israelinei, toyari Tirusi tuti Sidoni mani, inontarai na wana fosa etarabesa kawuru weru ene sasarifo tuti esansung ansung koya fo, eruai kangganangfoa watai na enumikamieifo ampa. ");
INSERT INTO amk_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Wape imadurai we mea mau yeyo, rahida bo Allai kiutu kaiwo kariri nunei nai foi, mesobu aiboi maraba sewa inontarai Tirusi tuti Sidoni fosa. ");
INSERT INTO amk_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Tuti mea na bendari Kapernaumi, menemitituai we metadai sewa paria sobu rorafaisi kontai ki, wape Allai ambori su mea beyari paria sobu katai Soroha rorong foi. Weo masino na Sodomi esobu fitantumafeai kariri ne inari rahang mea tonina fea mani, bendari nani wiro wioru kahai mae doari paria sobu ninai. ");
INSERT INTO amk_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Wape imadurai we mea mau yeyo, rahida bo Allai kiutu kaiwo kariri nunei nai foi, mesobu aiboi maraba sewa inontarai Sodomi fosa.” ");
INSERT INTO amk_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Rabuang bonani Yesusi wenadi deyo, “Dai, Seng mano ru rorawai tuti nunei Wau, yohong mahikai we Dai Wau, weo finani kiaio bodiwarai weru mano esawai tuti ewaitawang fi bitoya fosa, mae boinawiaia kasau we mano ene tarai kariri arikangnesa. ");
INSERT INTO amk_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Yo, tonanai, weo ne tonanane aino Dai enemuoa ne.” ");
INSERT INTO amk_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ainanaya Yesusi medu deyo, “Fi kiai na rorafaisi tuti na nunei, Dai dohonai we yau ampa. Kaisungnei mani, manei wiro deroani na mai kaha, manta Dai mantauni terai, tuti Dai kontai manei wiro deroani na mai kaha, manta ne Kaisungnei mantauni terai tuti inontarai mano Kaisungnei dirisa we deinawi Dai nani wesa fosa. ");
INSERT INTO amk_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Mano meawemi mewarami tafa tuti mesodua maraba na merurai paria we metohong kariri Hukumifoi wa mea, mera we Yau ma, Yau ambori iwedaya mea meweandeisei ki. ");
INSERT INTO amk_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Metohong kariri nehu kaiwone tuti mesobu aunau ria yau. Weo yau mani imanang tuti enehurorong tewawa, ambori mesobu mai na menumianinuwai tuti menemirorongwai weandeisei ki. ");
INSERT INTO amk_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Weo nehu kaiwone miawa we metohong kaririai tuti fi yohonai we mesoduata ne sayaiyai.” ");
INSERT INTO amk_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Na rabuang bonani, na rahida Sabati bei, amani rahida Yahudi fosa erufi nai kaha foi, teterai we Yesusi da riria romi potang fo. Ne inontarai erariati fosa ewati potangfoi nanai eteting bongfoi we etani, weo ewawisi fefe. ");
INSERT INTO amk_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Farisifosa ewati finana fo, emadu we Yesusi eteyo, “Botia, nemu inontarai eraria wau wasa etohong roaing kaiwo dotu wedua tarufi na rahida Sabati foi wanai.” ");
INSERT INTO amk_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Manamo Yesusi yoa wesa deyo, “Finana mani ne tarai toyari fi mananu Dauti niari na fafongfa na rahida bo i tuti ne mano erariati fosa ewawisi fo. Metato kariri kaiwo nana kaha e? ");
INSERT INTO amk_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Amani suai to Sempaisi ne Munufoi afui dangno roti etutang tutirai we Allaia fo tuti dohonai we ne mano erariati fosa etang kontai. Wape finanai, kariri hukum agama foi mani, imami erufi na Sempaisi ne Munufoi saino etang tera ne. ");
INSERT INTO amk_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Kontai, mewaitawanai we na rahida Sabati fo, imamifosa erufi na Sempaisi ne Munufoi mani, wedaya ea kontai etohong roaing Sabatifoi finana. Wape metatorai na hukum agama foi mani, wiro enari sarawa kaha. ");
INSERT INTO amk_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Imadurai we mea mau yeyo, na ninai manei fiabai sewa Munu Seng foi. ");
INSERT INTO amk_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kaiwofea dotu toninai: ‘Wiro yawi we inontarai etohong korbani fiahung we yau kaha, mae fi yawi pari wea fo mani, earomio inontarai siai.’ Ampafe masino metafu Sempasi ne Kaiwofo nanai na mai mani, wiro metinggai mano enari sarawa kaha nesa kaha. ");
INSERT INTO amk_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Weo Kaisung Inontarai nei weSeng we rahida Sabati nei kontai, ampafe wemambiriu weo deiriri kariri fianai aino na rahida Sabati nei mani inontarainesa enari fo, tuti fianai aino enari kaha fo.” ");
INSERT INTO amk_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ainanaya Yesusi da weru katai nani mae da wa suai to ene munu agama Yahudi bei. ");
INSERT INTO amk_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Na nanai deti inontarai manei warang bei mireha. Inontarai eweFarisi manea na nanai eteyo etinggai Yesusi we niari roaing Hukumi Musai soi fo, ampafe etutani eteyo, “Kariri Hukumi Musai soi fo mani, tanari inontarai etanteng na rahida Sabati ne konta ne?” ");
INSERT INTO amk_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesusi yoa wesa deyo, “Masino na mea, manei ne domba manei da wa saukaha kamirei berorong bei na rahida Sabati foi, nana mani fianai aino niari ne? Nana mani, wiro yurai we yuaisi weru kamirei rorong foi kaha e? Todoni kontaio yurai we yuaisi rai. ");
INSERT INTO amk_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Tonanaifa mani, dombanei dino dedai sewa inontarai fine ne? Bereri. Ampafe kariri Hukumifoi, nari ne bengfo na rahida Sabati foi mani, nana mani fi beng fine.” ");
INSERT INTO amk_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ainanaya Yesusi medu we inontarai warang bei mireha foi deyo, “Wi waramuwai ma.” Ainanaya inontaraifoi si warangfoi kaririaia, na tatofang kutu nanai kontai warangfoi denteng kariri bo dowei foi aha. ");
INSERT INTO amk_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Farisifosa ewati finanafo wiro eparaise kaha, mae era to boriei weru munu agama foi tuti emadu ruhi kaiwo we ambori emung Yesusi. ");
INSERT INTO amk_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesusi deitawang ene enemitituaitafo, ampafe da weru katai nani. Kaiwasa bitoya paria era riati tuti inontarai emaninang fosa bitoya paria niarisara etanteng aha. ");
INSERT INTO amk_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Deretawang kaiwasa bitoya foi suasa na tapapa paria we wiro etaiririai we inontarai siai kariri I we mandoni dine fo fanai. ");
INSERT INTO amk_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ambori na tonanane mai kariri fianai aino Allai medurai na nabi Yesayai deyo, ");
INSERT INTO amk_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Nehu mangfata yiriri dinini, Mano enehuwawuti tuti andino kia enehurorongnei. Ambori yohong Nuhuaninunei wei we isansoni nai, Tuti nehu ikutu kaiwo na masi ne, deirirai we kaiwasanei kiai na nu bodoni konta foi. ");
INSERT INTO amk_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","I wiro sawa funomai tuti kiobu funoma kaha, Tonanai kontai wiro tarami raofuifoi na rang bendari fo kaha. ");
INSERT INTO amk_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Toyari wiro fio kiutu ninoi robong adareti tikai sawai foi kaha, tuti wiro fefe padamarang denggararua de minong foi kaha, I wiro tiapa inontaraio ewemambiriu kaha, tuti manang we mano efanahang fosa, Pariao ne weMananu tarai fo kiraikobu Saminseni ne wemananu mamantiti fo. ");
INSERT INTO amk_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Tuti na mantauni wonongfo, kaiwasa na nunei sentenang enemitawanai ki.” ");
INSERT INTO amk_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Mayeai manea eha inontaraio nuaninu karira dohoni manei we Yesusi ma. Inontarai nani inggira wedayaria ureng fafa tuti borotamu. Ainanaya Yesusi niari weinggira dohoni nania denteng aha, ampafe medu tuti deti aha. ");
INSERT INTO amk_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kaiwasa bitoya fosa epapuhing paria we fitantuma nanai tuti emadu eteyo, “Inontarai nini, dohonao Mano esahui we Dauti ne Kaisungfoi dinini fe?” ");
INSERT INTO amk_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Wape Farisifosa etaramioaifa nanai emadu eteyo, “Na inggirafosa ene mananu Barsebuli wonongfo terai aino inontarai nini data inggirafosa.” ");
INSERT INTO amk_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesusi deitawang Farisifosa enemitituaitafo, ampafe medu wesa deyo, “Negara bei wiro weboyari kaha mae ebabausa tuti eweaiteta wawerasa, nana mani negara nani wiro da waroi ahang kaha, mae ambori wioru ki. Tonanai kontai we bendari bei ete munu rorong bei eweaiteta wawerasa mani, bendari ete munu rorong nani wiro doa pampang kahai ki. ");
INSERT INTO amk_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Tonanai kontai we Saminseni, masino Saminseni data Saminseni mantauni aha mani, deinawiai we Saminseni dapa bera mantauni tuti tiabau finanai. Nana mani ambori ne mananufo nayai mutu kaha mae wioru ki. ");
INSERT INTO amk_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Memadu meteyo na Barsebuli ne mambiriufo aino yata nuaninu karira fosa nai ne. Tonana mani na mandoni ne mambiriufo mene inontarai eraria mea fosa etata nuaninu karira fosa nai ne? Na fianai aino enari nanai deinawiai we fio metinggai yau wea ne tarai kaha. ");
INSERT INTO amk_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Wape yau mani yata nuaninu karira na Allai ne mambiriune, nana mani yeinawiai weo na yau mani, Seng Allai da ma we weMananu rahang mea ampa. ");
INSERT INTO amk_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Nuaninu karira fosa ene tarai kariri we-wemambiriu manei minohi na ne munufoi. Tuti manei wiro suai to ne munufoi afui we wewu ne rafoi kaharai, mae wenani tefu mambiriufoia wiorahi akawuru wo, ambori wewu ne rafoi ki. Ampafe na yata nuaninu karira to boriai yeinawiai we ikaraikobu Saminsenia. ");
INSERT INTO amk_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Manei sau we yau kaha mani, weaiteta we yau, tuti manei doa tuwa yau na ifanduhi inontarai fo kaha mani, wenani niari kanggani nehu fi inari ne weo kiataterai. ");
INSERT INTO amk_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Ampafe imadurai we mea mau yeyo, sasari fuba inontaraine enariri nei kiai kontai eteibera Allai fo, sasari tonana nei Allai deiairi ki, wape sasario eteibera Nuaninu Mirarebana foi mani, todoni kontaio Allai deiairi kaha. ");
INSERT INTO amk_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Tuti inontarai mano eteibera Kaisung Inontarai ne yau, ene sasari tonana foi Allai deiairi ki, wape eteibera Nuaninu Mirarebana foi mani, na todoni feai kontaio Allai deiai ene sasari tonana foi kaha, na nu bonini tuti nu weworu da aha ma foi kontai. ");
INSERT INTO amk_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Ai koi denteng foi mani bongfoi denteng, mae ai koi kerira foi mani bongfo kerira, ampafe aifoi denteng ete kerira, waitawani na ne bongfoi ki. ");
INSERT INTO amk_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Farisine meaine, inontarai mesaipaya di mea! Todonie, merurai we memadu kaiwo beng fo na meboromine, mae menemirorongfuisi kerira seipaya ninai? Weo fianai aino madurai na taboromi ne mani, finanai dariai na taenemirorongfuisi mandiei. ");
INSERT INTO amk_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Inontarai mano denteng foi niarifo beng, we enerorongfoi denteng fefe. Wape inontarai mano kerira foi niarifo karira, weo enerorongfoi kerira. ");
INSERT INTO amk_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Wape imadurai we mea mau yeyo, na rabuang bo Allai da ma we kiutu kaiwo weo kaiwasa nunei sentenang foi, inontarai mansiari-mansiari deiai kariri kaiwoariri medu funomi foi we Allai fo ki. ");
INSERT INTO amk_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Weo Allai kiutu kaiwo kariri mea fo titua na kaiwo memadura fo, we metohong sarawai ete bereri, ambori mesobu aiboi ete mehasau e.” ");
INSERT INTO amk_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ainanaya mantaunau Kaiwo Musai soi fo maneiru teai tuti Farisifosa etutang Yesusi eteyo, “Dai Mantaunaune waune, amefaraise we amewati nari fitantuma bei.” ");
INSERT INTO amk_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Wape Yesusi yoa wesa deyo, “Kaiwasa fuinini mesaipaya paria tuti mehurumitare mene Sengfoi, ne tarai toyari mang manei kurutare ne wiwingfoi tuti dohong we wiwing siai. Metutang we inari fitantumafeai we fiainawiai we mea kariri yau. Wape wiro inari fitantuma siai fea we mea kaha, mae fiainawiaio mewaitawanai na nabi Yunusia fo. ");
INSERT INTO amk_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Toyari nabi Yunusi we niayai na diang fiabai foi enengfoi rahida botoru diru botoru fo, tonanai kontai Kaisung Inontarai nei ambori niayai na kahofa rorong fo rahida botoru diru botoru kontai ki. ");
INSERT INTO amk_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Na rahida Allai kiutu kaiwo kariri nunei fo, inontarai Niniwe fosa ambori esuwi ria mea, mano na rabuang bonini ne mea, tuti etinggai mea kontai ki. Weo fafongfa nabi Yunusi medu wesa fo etaramioi, ampafe efotou enari sasarifo tuti etaraberasa weru ene sasarifoi ampa. Wape na ninai, na katai nini manei fiabai sewa nabi Yunusi ne, manamo wiro metaramioi kaha. ");
INSERT INTO amk_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Tonanai kontai we wiwing Mananuo na do wanangsai foi, i ambori suwi kontai ria inontarai mano na rabuang bonini ne mea we dinggai mea kontai ki. Weo wiwing Mananu nini da pari na nunei rea naya fo ma we sobu aunau mai na Mananu Salomoi mano sewai foi. Tuti na ninai, na katai nini manei fiabai sewa Mananu Salomoi ne, manamo wiro metaramioi kaha. ");
INSERT INTO amk_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Awao nuaninu kerira manei da to boriai weru inontarai manei mani, da wariai funomai to katai karira sarahiai weo sera we katai niai nayai, wape sobua kaha. ");
INSERT INTO amk_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Nana mani enetituai deyo, ‘Yarabera yau to nehu munu arahi ira werui foi aha.’ Tuti rahida bo daraberahia foi mani, sobuai we inontaraifoi ne tarai toyari munuo wiatai arora, fantamia mesi mirarebanai. ");
INSERT INTO amk_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ainanaya daraberahi aha kia eweituo eharira sewa mantauni. Mayeai esuai to inontaraifoi awafui enayai nai. Ampafe wedaya inontaraifoi ne minohi toa fo kerira sewa reantenangfo aha. Kaiwasa na fuininai mesaipaya ne mea, mesobu ne karira sewa fo tonana kontai ki.” ");
INSERT INTO amk_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesusi medu ria kaiwasa bitoya foi tonana rai mae, inanai tuti ne tahatuifosa era ma etoari na borieifo tuti eteyo emadu riati. ");
INSERT INTO amk_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ampafe inontarai manei medu wei deyo, “Daie, inamuai tuti nemu tahatuifosa etamang na borieife fo eteyo emadu ria wau.” ");
INSERT INTO amk_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Manamo Yesusi yoa we inontarai kia kaiwofo nani, deyo, “Mandoni dino isahui we nehu ai tuti mandoni saino isahusa we nehu tahatui ne?” ");
INSERT INTO amk_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ainanaya Yesusi si warang deinawi ne inontarai erariati fosa deyo, “Botia, nehu ai tuti nehu tahatui sai nina. ");
INSERT INTO amk_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Weo inontarai mandoni niari kariri nehu Dai Allai na rorafaisi ne dawiafo mani, andino isahui we nehu tahatui mang ne, nehu tahatui wiwing ne tuti nehu ai ne.” ");
INSERT INTO amk_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Rahida bonani kontai Yesusi da weru munufoi, mae da wa minohi na ruru Galilea foi dereungfo. ");
INSERT INTO amk_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Kaiwasa bitoya era wei ma efanduhisa wariri, ampafe dautai to wafeai awa dewohi nayai, mae kaiwasa bitoya foi minohi na reifo. ");
INSERT INTO amk_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ainanaya Yesusi deunausa fi bitoya na fiyiwansoai deyo, “Weniari romi manei kia aibongfei da wa we sanami. ");
INSERT INTO amk_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Da wa kifa aibongfoi nana mani, eai sawai na rangfoi, ampafe romufosa esifo ma etania kiaia. ");
INSERT INTO amk_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","6","Eai kontai sawai na kahofa wekamamiei wowongfo. Aibongfoi sikera sa rerorifoi tonanai meai, wape kameaia wofoi piara nanai siamorang aha, weo kahofafo demoyarai we newafo so aweu kaha fefe. ");
INSERT INTO amk_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Eai aha mani sawai na katai weninoi ababo foi, ampafe ninoi ababo foi sifu tamui tuti kehepania memasara. ");
INSERT INTO amk_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Wape aibongfeai aha mani sawai na kahofa beng fea, ampafe sifu biriayai paria dohona mani webong bitoya paria, wei wepiaring (100), wei kontai wepiatoru (60), wei aha mani wepiareiasura (30).” ");
INSERT INTO amk_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Medu tuarai aha deyo, “Mewemetarami mani metaramioai.” ");
INSERT INTO amk_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ainanaya Yesusi ne inontarai erariati fosa era kefani etutani eteyo, “We fianie bounau kaiwasa bitoya foi mani bounau na fiyiwansoai nina?” ");
INSERT INTO amk_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ampafe yoa wesa deyo, “Mea mani Allai dohong awai we mea, we mewaitawang kariri ne weMananu rorong fo tuti fi dediwara fo ampa, wape ea mani bireri. ");
INSERT INTO amk_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Weo mandoni dino sobu awaifo ria Allai kawurua fo, ambori sobuafo fuba aha. Wape mano sobua kaha foi, ne kutu nayai nai fo kontai kia weruri ki. ");
INSERT INTO amk_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Kaiwo ninai dohona mani yeunausa na fiyiwansoai, ambori, Ewatioai tonanai ki, wape ene tarai toyari euremifafa. Etaramioai, wape ene tarai toyari wetarami kobu, tuti etafura kaha. ");
INSERT INTO amk_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ampafe na kaiwasa nani fosa, mai kariri fianai aino raminde nabi Yesayai medurai deyo, ‘Metaramioaia metarami wawurai, wape mewaitawana na ea kaha, Mewatioaia mewati wawurai, wape metafurai na ea kaha. ");
INSERT INTO amk_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Weo kaiwasa nini enemitituaitafo rehabu ampa, ehobu etaramifo ampa, tuti etabung wedua euremifo ampa. Weo tonana kaha mani, tarahio euremifo ewati, etaramifo etaramioai, tuti enumikamieifo enemitituaitaifa, ambori etaraberasa weru ene sasarifoi we Yau aha ma, tuti inarisa ebeng aha.’ ” ");
INSERT INTO amk_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ainanaya Yesusi medu we ne inontarai erariati fosa aha deyo, “Wape mea mani mesobu ne maifo we meuremiwa tabau we mewati tuti metaramiwa saha we metaramioai na mai. ");
INSERT INTO amk_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Weo tarai, imadu we mea mau yeyo, na fafongfa nabi bitoya tuti inontarai enemirorong mesi fosa efau enemirorong dohong paria we ewati fiani aino mewatioai na kutu nina ne, wape wiro ewatioa kaha. Tuti we etarami fianai aino metaramioa ne, wape wiro etaramioa kaha.” ");
INSERT INTO amk_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Metarami kariri fiyiwansoai kariri mangkafa aibong nei ne kaiwo tarai ne ma. ");
INSERT INTO amk_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Aibong sawai na rangfoi mani, yiwanso inontaraio etarami Sempaisi ne Kaiwofo kariri todoni weMananufo, wape wiro etafu kaiwofo na mai kaha. Ampafe Saminseni, amani mano kerira foi, da ma dewa Kaiwo kafarai tonana fo weru enemirorongfoa. ");
INSERT INTO amk_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Mae aibong sawai na kahofa wekamamiei wowongfo mani, yiwangso mano etaramio Kaiwofo tuti na kutu nanai kontaio esobuai na enemirorong mirising. ");
INSERT INTO amk_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Wape Kaiwofo wiro wenewa na enemirorongfoi kaha, ampafe etawansa tourai mae esodai dadirafeai kariri ene eroasoai tonana foa mani, wiro etoaria mutu ahang kaha, mae esu to fuia. ");
INSERT INTO amk_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Aibongno sawai na katai weninoi ababo foi mani, yiwanso mano etaramio Kaiwofo, wape earomikuayai karerai we fi nunei tuti ra nunei sofa enemirorongfoi awao sau weai, ampafe finani kepang Kaiwofo paria wiro webong na sa ahang kaha. ");
INSERT INTO amk_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Wape aibong sawai na kahofa beng fo mani, yiwanso mano etarami Kaiwofo, etafurai tuti etonai afui naya mutu na enemirorongfoi. Na inontarai tonana fosa mani Kaiwofo webong paria na ea, ne tarai toyari aibongfoi we wetarai bitoya fo, wei awao we piaring (100), wei awa wepiatoru (60), tuti wei kontai awa we piareiasura (30).” ");
INSERT INTO amk_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesusi deiriri fiyiwansoai bei we kaiwasa bitoya foi aha mani, deyo, “Allai ne Mananu rorong fo ne tarai toyari finini; Weniari romi manei kifa potang bongfoi na ne romifoi. ");
INSERT INTO amk_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Wape denawa diru rabuangna mani ne aitetafoi dediwara kifa rambongfoi na romifoi ria potang bongfoi, ainanaya da wa. ");
INSERT INTO amk_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Na rahidao potangfoi sifua rerai we wetarai nanai, rambongfoi sifu riataia dedai kontaia. ");
INSERT INTO amk_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ainanaya weniari romi foi ne womingfosa emadu wei eteyo, ‘Daie, aibong kufari foi mani denteng mae, todoni rambongfoi sifu tamui wana?’ ");
INSERT INTO amk_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ainanaya wene romifoi yoa deyo, ‘Inontarai weaiteta we yau manei andino niari tonana ne.’ Ampafe ne womingfosa etutani aha eteyo, ‘Tonana mani amera wa amefating rambongfoi weruaia ne?’ ");
INSERT INTO amk_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Manamo yoa deyo, ‘Nana fanai, weo mefating rambongfoi mani, ambori mefating tuti potangfoi konta rai. ");
INSERT INTO amk_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Ampafe metawini sifu ria potangfoi kio rahida eting potangfoi nai foi wo. Na rahida bonani dino ambori imadu we mano etetini fosa yeyo, reantenangne mani mefanduhi rambongwai tuti meworahi we menunumi, mae potangwai mefanduhi we mehari to nehu munu fanduhi fi nai foi afui we wiatai nai.’ ” ");
INSERT INTO amk_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesusi deiriri fiyiwansoai bei kontai we kaiwasa bitoya foi aha mani medu deyo, “Allai ne Mananu rorong foi mani ne tarai toyari fiyiwansoai nini; Sawi bong bei, manei kiaria sanami na ne romifo. ");
INSERT INTO amk_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Tawaitawanai we sawi bongnei mani, ketui sewa raung ete fitantanang tatanami na romifoi ne bongfoi kiai. Wape sifua mani, andino fiabai sewa ne, weo werobong tuti wearirawang, ampafe romufosa wea mani esifo ma enari aisangging na arirawangfo.” ");
INSERT INTO amk_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesusi deiriri fiyiwansoai bei aha mani deyo, “Seng Allai ne Mananu rorong foi kontai ne tarai toyari fi dohong tepung dautai, amani ragi. Wiwing manei sariri aweu fiahi tamu tepung bitoya, wedaya tepungfoi dautai paria ketu loyang wiatai nai foi dereungfo.” ");
INSERT INTO amk_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesusi deunau kaiwasa bitoya foi mani deunau na fiyiwansoai terai, tuti siai weru fiyiwansoafo mani wiro medu fieai wesa kaha. ");
INSERT INTO amk_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ambori finanai mai kariri fianai aino nabifo manei meduraifa deyo, “Ifobai borohu imadu wesa na fiyiwansoafo ki, Iwuwu fi dadiwao na siari Allai niari nunei paria sobu ninai manei deitawana kaharai fo.” ");
INSERT INTO amk_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Mayeai Yesusi da weru kaiwasa bitoya foi tuti suai to munu bei, ampafe ne inontarai ewesuraya mandu fosa eraoia etutani eteyo, “Daie, boisaharai we amea kariri fiyiwanso rambongno sifu tamu potangnei.” ");
INSERT INTO amk_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesusi yoa deyo, “Inontarai kifa aibong denteng foi mani Kaisung Inontarai nei. ");
INSERT INTO amk_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Romifoi mani nunei dine, aibong denteng foi mani inontarai mano Allai sahusa we ne arikangno eminohi na ne weMananufoi fo saine, mae rambongfoi mani Saminseni ne arikangfo saine. ");
INSERT INTO amk_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Mano weaiteta da sanang rambong bongfoi mani, Saminseni mantauni dine. Rahida eting potangfoi naya fo mani, rahida nunei werea naya fo dine, tuti mano etetingfi fosa mani wewaifo saine. ");
INSERT INTO amk_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Toyari rambongfoi fanduhi tuti nunumi na adia rorong foi, tonanai kontai na rahida nunei werea naya fo. ");
INSERT INTO amk_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Kaisung Inontarai nei ambori demi ne wewaifosa efanduhi mano eharira fosa tuti mano ewedaya inontarai enari sasari fosa, ehasa weru ne Mananu rorong fo. ");
INSERT INTO amk_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Erusa esosa to adia rorong denggararu foi, na wanai esodai ne karirafo tuti esaia etamirai paria. ");
INSERT INTO amk_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Rahida bonani dino inontarai enemirorong mesi fosa esobu mai paria, toyari ene taraifoi keiwewa kariri wofaisi na ene Dai Allai ne Mananu rorong fo ki. Mandoni dino wetarang mani taraoai.” ");
INSERT INTO amk_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Allai ne Mananu rorong fo mani, ne tarai toyari ra dentengno dadiwa na kahofa rorong fo na romi bei. Inontarai manei sobu ra denteng nani, tuti sirayai na kahofa rorong fo nariai aha. Ainanaya piraise karerai we ra sobui nani, ampafe daraberahia dewayang ne ra minohi tutira foi kiaia mae wiori kahofa dediwa ra denteng foi nai nani aha. ");
INSERT INTO amk_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Kontai, Allai ne Mananu rorong fo mani ne tarai toyari inontarai dewayangfi manei sera we mutiarafo, amani mutiarao ne harga dedai fo. ");
INSERT INTO amk_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Serawa sobu mutiara ne harga dedai sewa beia, da wa dewayang nefi minohi tutira foa kai, tuti wiori mutiarafoia. ");
INSERT INTO amk_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Tonanai kontai Allai ne Mananu rorong fo ne tarai toyari erang kabioi na rawanangfo tuti miko mai diang bong foi. ");
INSERT INTO amk_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Erangfoi mikoa sefangna mani, mano ehabioi fosa erabiti to rei arei. Ainanaya eminohi mae etiri diangfoi, diangno ebeng fosa esonisa to nawang rorong fo, mae ne eharira fosa ehabisa. ");
INSERT INTO amk_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Tonanai kontai na rahida nunei werea naya fo. Wewaifosa era ma etiri inontarai eharira fosa weru inontarai mano enemirorong mesi fosa. ");
INSERT INTO amk_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ainanaya eso inontarai eharira fosa to adia rorong denggararu foi, na wana esodai ne karirafo tuti esaia etamirai paria.” ");
INSERT INTO amk_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ainanaya Yesusi dutang ne inontarai ewesuraya mandu fosa deyo, “Metafu finana kiai to ne?” Eroa eteyo, “Daie, ametafurai ampa.” ");
INSERT INTO amk_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ampafe medu wesa aha deyo, “Tonana mani, mantaunau Kaiwo Musai soi fosa, mano etafu aunau kariri todoni Allai weMananu fo nana mani, etaunau kaiwo beng na Hukumi fafong foi tuti Kaiwo Mahikai waworu kariri nehu rang waworu nei, ne tarai toyari inontarai manei ne munu bei, we kia ra waworu fo tuti mamo fo to boriei weru katai watai nai fo.” ");
INSERT INTO amk_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesusi deiriri kariri fiyiwansoaifoa kaia nanai, da weru katai nania. ");
INSERT INTO amk_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Amani daraberahi to ne munuefo aha. Na nanai deunau na munu agama Yahudi fo, ampafe kaiwasa bitoya fosa epapuhing paria, emadu eteyo, “Inontarai nini sobu awai tuti mambiriu tonina ne na doni e, we deunau toninai tuti niari fitantuma ninai? ");
INSERT INTO amk_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","I mani Yusupi mano sewai na niari fi na aifoi ne arikang dine mae? Inana mani wonong fino Maria mae? Tuti tawaitawanai we ne tahatui saino Yakobusi, Yusupi, Simoni tuti Yudasi mae? ");
INSERT INTO amk_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Tuti rorowingfo sitoru itominohi kontai na munuefe ninai mae? Ampafe sobu awai tuti mambiriu wanai kai na doni?” ");
INSERT INTO amk_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ampafe emaya wei kahai mae eteiayaria. Wape Yesusi medu wesa deyo, “Nabinesa na doni kontai inontarai etatosa paria, mantao na ene munuefo tuti ene arurarafosa teraio ansaino wiro etatosa kaha ne.” ");
INSERT INTO amk_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ampafe Yesusi wiro niari fitantuma bitoya kahai na nanai, weo eroasoa kaha fefe. ");
INSERT INTO amk_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Na kutu Herodesi mano wemananu na Galilea foi tarao kaiwo kariri Yesusi we wewonong tonanaifa fo, ");
INSERT INTO amk_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","medu we ne inontarai erufi wei fosa deyo, “Yohanesi mano webaptisi kaiwasa foi andino suwi na marareha rorong fe aha ma nina, doni wemambiriu we niari fitantumafe nina.” ");
INSERT INTO amk_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Herodesi enetituai tonanai, weo we beiru teaia fo demi ne inontarai etafu Yohanesi tuti eworahi etohoni afui wiatai na munu aitamu rorong foi, weo Yohanesi suari na rahida kia ne tafuai Pilipusi binengno Herodiasi we ne wiwingfo. ");
INSERT INTO amk_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Weo Yohanesi suari pampang deyo, “Rau nemu tafuai binengfoi tonana mani, nari roaing hukumifo paria tuti bohong sarawai paria.” ");
INSERT INTO amk_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ampafe Herodesi deo miung Yohanesi manamo mitai kaiwasa bitoya foi, we eteyo Yohanesi mani nabi dine fefe. ");
INSERT INTO amk_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Wape rahida bo dohonsua ne rahida saubaunungkamiei naya foi, Herodiasi ne kamitungfoi mikai na kaiwasa bitoya eminohi na muniarafoi nani sa earomireafo tuti mikai beng paria, dohonaia Herodesi piraise paria. ");
INSERT INTO amk_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ampafe Herodesi dererai na fefora deyo, “Fianai aino butang weai we wobua fo mani ambori yohong kaririai ki.” ");
INSERT INTO amk_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ainanaya inang deunauwi ampafe da wa medu deyo, “Bohong Yohanesi mano webaptisi kaiwasa foi nunggamieifoi we yau, biaini na rewangguai timba bei.” ");
INSERT INTO amk_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Herodesi tarao kaiwofe nanai enerorongfoi fituayai paria, manamo fefora kawuru na mano wenotisa fosa euremireafoa. Ampafe demi ne inontaraifosa enari kariri fianai aino kamitungfoi dawi wea fo. ");
INSERT INTO amk_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ainanaya demi ne inontaraifosa era wa eferangkutu Yohanesi rahanangfoi na aitamu rorong fo. ");
INSERT INTO amk_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ebiaing nunggamieifoi na rewangguai timba bei, ehari ma etohoni we kamitungfoi, ainanaya kiaria dohoni we inanai. ");
INSERT INTO amk_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Mayeai Yohanesi ne inontarai erariati fosa era wa eha Yohanesi nehofoa esarayai, ainanaya era wa eteisaha finanai we Yesusi. ");
INSERT INTO amk_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesusi tarao finanafo i tuti ne inontarai ewesuraya mandu fosa epusuhiai weru kaiwasa bitoya foi era wa etau wafeaia, etafai to katai minano bei. Wape kaiwasa bitoya foi etaramioai tonanafo, ea kontai era weru ene bendarifo era na rei ria Yesusi. ");
INSERT INTO amk_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Etafaia sobu nafarengfo Yesusi biari arei mani, deti kaiwasa bitoya foi we era kawuru ma enayai na nanai, detisa tonanafo arosa paria ampafe niari mano emaninang fosara etanteng. ");
INSERT INTO amk_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ramindenara mani ne inontaraifosa eraoia etutani eteyo, “Ramindena ampa, katainei minano, ampafe mahikai mani Dai bemi inontarai ninisa etaraberasa to, ambori ewawori fiangfeai na munue wa kahefang na ninai weai we etang.” ");
INSERT INTO amk_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Manamo Yesusi yoa wesa deyo, “Wiro era kaha, mae todoni kontaio meaino metohong fiang we etang.” ");
INSERT INTO amk_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ainanaya eroa we Yesusia eteyo, “Amene roti ring tuti diang mandu kawuru.” ");
INSERT INTO amk_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ampafe Yesusi medu deyo, “Meha rotiwa tuti diangwa suru we yau ma.” ");
INSERT INTO amk_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ainanaya demi kaiwasa bitoya fosa eminohi na ninoi wowong fo, mae kia roti ring fo tuti diang mandu fo, fioai ureng deti to rorafaisi tuti dutang tuti fiangfo we Allai. Mayeai fiobabau rotifo na warangfo dohong roti tuti diangfo we ne inontaraifosa ambori etatorai we kaiwasa bitoya foi. ");
INSERT INTO amk_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Tuti kaiwasafoi dampiao memosi beyari. Mayeai Yesusi ne inontaraifosa efanduhi fiang seari foi aha mani, dangno bayai suraya boru sefang. ");
INSERT INTO amk_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Kaiwasa fuba Yesusi dohoni dampi nani mani, ewepiaura wering wering (5.000) nana mani titou mangfosa tera finana, wiro ato tamu wiwing tuti arikang fosa kaha. ");
INSERT INTO amk_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Mayeaia mani Yesusi demi ne inontarai ewesuraya mandu fosa etau wafo etafai fafong to ruru eneung dowei foi ahawaru, mae arahio demi kaiwasa bitoya foi daraberahi aha. ");
INSERT INTO amk_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Kaiwasa bitoya foi era wa nanai, Yesusi meiri dautai to wiwoi bei na nanai ayai we wenadi nayai. Dirua mae Yesusi meiri na nana wo. ");
INSERT INTO amk_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Mae ne inontaraifosa etafaia sobu rurufoi rabuangna mani, andeisafoi miung wafoi paria, weo etapa kare wanang fiabai foi fefe. ");
INSERT INTO amk_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Dirufoi waroia rerai we aha rorong, tarahio araha ureng botoru, Yesusi bia da na mereha wowongfo wesara. ");
INSERT INTO amk_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Na kutu ewatiaoi we da na mereha wowongfo wesa ma nanai, ematai paria tuti ebibe eteyo, “Wori di wani!” ");
INSERT INTO amk_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Wape Yesusi sikahera medu wesa deyo, “Mematai fanai! Menemitawanai, we Yau ne!” ");
INSERT INTO amk_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ainanaya Petrusi medu deyo, “Sengne wau! Tarai wau aranane mani, bemi yau ira na mereha wowongne we wau mau.” ");
INSERT INTO amk_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesusi yoa deyo, “Ro ma.” Ainanaya Petrusi bia weru wafoi, da na mereha wowongfo we Yesusia. ");
INSERT INTO amk_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Wape Petrusi detioai we wanangfoi siayai weandeisa karerai nanai niuruainso wanangfoi we fibai karerai ampafe mitai, wedaya deisui aweu, tuti bibe deyo, “Sengne wau, fata yau!” ");
INSERT INTO amk_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Na kutu nanai Yesusi si warangfoa yuti mae medu wei deyo, “Petruse, inontarai roasoai turura kaha di wau. We fianie enemurorongwai soriru we yau nina?” ");
INSERT INTO amk_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ainanaya urautai ruhiai to wafoi ayai, tuti wanangfoi meringna. ");
INSERT INTO amk_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ampafe ne inontaraifosa esomi aweu ewatai, mae emadu eteyo, “Tarai we wau mani, Allai ne Kaisung di wau.” ");
INSERT INTO amk_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ewoa sobu ruru eneung dowei foia mani, etarafui na nafareng Genesareti. ");
INSERT INTO amk_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Kaiwasa bitoya fosa ewatioai we Yesusi dine, ampafe etanatu kaiwo to munue wa rurang bendarifo tantenang tuti eha inontarai emaninang fosa we Yesusia. ");
INSERT INTO amk_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Tuti etutang Yesusi we kadono yoa wesa we ewaramifo disangso te ne ansung awerengfo ki, tuti inontarai emaninangno enari tonana fosa ebengna ehaia. ");
INSERT INTO amk_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Mayeai inontarai eweFarisi meneiru teai tuti mantaunau Kaiwo Musai soi fosa, era na bendari Yerusalemi we Yesusi ma etutani eteyo, ");
INSERT INTO amk_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“We fiani e nemu inontarai eraria wau nesa etohong sara tane koangno weriria na tane werengfosa ma foi nina? Amani wiro eruai ewaramiwa kariri tane koangfoi kahai mae, etampi tuti ewarami werarika nanaifa nina?” ");
INSERT INTO amk_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Manamo Yesusi yoa wesa aha deyo, “We fiani e mea kontai metohong sara Allai ne Kaiwo demi mea we metohong kariria fo kontai nina, ambori metohong kariri koangno weriria na mene werengfosa ma foi nina? ");
INSERT INTO amk_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Weo Allai medu deyo, ‘Mesomi we mene dai tuti ai,’ tuti, ");
INSERT INTO amk_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Wape mea mani metaunau fi siaio na mene koangfo, amani meteyo, ‘Mandoni dino medu we ne dai ete ne ai deyo, “Fianai aino nehu ne, amani fi we yerara dai tuti ai muru naya ne, yohonai kawuru we Allai ampa,” ");
INSERT INTO amk_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","inontarai tonana nei kesau weru somi we ne wawafo suru na ne niari tonana fo.’ Na metaunau tonana ne, menemitatura Allai ne Kaiwone mae metohong kariri koangno mantaung mea menariri foi. ");
INSERT INTO amk_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Mea mani inontarai menari fayafayarai di mea, fianai aino Allai medurai ria nabi Yesayai kariri mea fo wetarai ampa, ");
INSERT INTO amk_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","amani medu deyo, ‘Inontarai ninisa esomi we Yau na eboromirawa arora, wape na enemirorongfoi niayai waroi weru Yaua. ");
INSERT INTO amk_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ene esomi we Yau fo wiro wefiea kaha, aunau etaunau we kaiwasa etohong kariria fo mani, inontarai nuneisa ene aunau fine terai, wiro nehu aunau fine kaha.’” ");
INSERT INTO amk_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ainanaya Yesusi sahu kaiwasa bitoya foi ma medu wesa deyo, “Metarami nari kaiwone tuti metafurai na mai. ");
INSERT INTO amk_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Fiangno taukaharai na fino taboromine to taenemifuisi afui ne mani, wiro kia rarika we tata ambori tamasi kahai na Allai arongreafo kaha, mae ne kawariai na taborominei mandiei fo aino kia rarika ne tuti wedaya tamasi kahai na arongreafo ne.” ");
INSERT INTO amk_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ainanaya Yesusi ne inontarai erariati fosa era weia tuti emadu wei eteyo, “Daie, boitawana kahai we kaiwo modura wa disang Farisifosa paria?” ");
INSERT INTO amk_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesusi yoa aha deyo, “Fitantanang kiaio Dai na rorafaisi sanang kaha fo mani, todoni kontaio fiating tuti newafoi kiai rai, wiro kutea naya kaha. ");
INSERT INTO amk_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Wiro menemititou we Farisifosa fanai, weo ea mani inontarai euremifafao ewiwiaing kaiwasa saine. Masino inontarai urengfafa foi bingno weurengfafa manei mani, ambori utau ruhiai tono kamirei bei ki.” ");
INSERT INTO amk_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ainanaya Petrusi medu aha deyo, “Daie, boikariri bau fiyiwansoai nini we amea.” ");
INSERT INTO amk_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesusi medu deyo, “Mea kontaio metafu fiyiwansoai nini konta kaharai e? ");
INSERT INTO amk_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Wiro mewaitawana kahai we fianai aino taukaharai na taborominei biari to taenemifuisi mani ambori takaheri sayarai aha ne ne? Finanai wiro kia rarika na Allai urengreafo we tata kaha. ");
INSERT INTO amk_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Wape fianai aino kawariai na taboromine, amani kaiwoariri fuba tamaduri nei, finanai kawariai na taenemirorongfuisi mandiei. Tuti finanai aino kia rarika we tata ne. ");
INSERT INTO amk_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Weo na taenemirorongfuisi, taenemitituai ne karirafo, tatohong we tamung inontarai, tanai ria wiwing ete mang siai, tamaninawa funomai, tahamananapi, tapampamu, tuti tatairiri inontarai siai. ");
INSERT INTO amk_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Fi tonana ne aino kia rarika we tata ne, wedaya tamasi kahai na Allai arongreafo ne, mae tatampi tuti tawarami taruaisi kaharai fo wiro kia rarika we tata kaha.” ");
INSERT INTO amk_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Mayeai Yesusi da weru katai nani to katai na bendari Tirusi tuti Sidoni. ");
INSERT INTO amk_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Na nanai wiwing Kanaani manei da we Yesusi ma, tuti medu wei sahu deyo, “Sengne waune, Dauti ne Kaisungne waune, aromuo yau! Weo nehu kamitungfoi nuaninu karira dohoni tuti dohonifo maraba paria.” ");
INSERT INTO amk_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Wiwingfoi sahu tonanai ki wape Yesusi fiobai borong kuteai wei kaha. Ainanaya ne inontarai ewesuraya mandu fosa era kefania etutani eteyo, “Daie bemi wiwingfoi da weru tatara. Weo i da ria tata mae kehobu paria fefe.” ");
INSERT INTO amk_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ampafe Yesusi yoa we wiwingfoi deyo, “Allai demi yau terai we inontarai Israeli fosa, weo ene tarai toyario domba niai weru ne bitoyafoi.” ");
INSERT INTO amk_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Manamo wiwingfoi da kefang Yesusia tuti disang kapa awebuka mae medu deyo, “Sengne waune, fata yau!” ");
INSERT INTO amk_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ainanaya Yesusi yoa wei deyo, “Beng kahai we ka rotio mainenamai we arikangnesa we etangfo, ka aha kabioai we fiawerafosa aha fo.” ");
INSERT INTO amk_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Manamo wiwingfoi yoa aha deyo, “Sengne waune, tarai, wape fiaweranesa kontaio etang roti nukahaio tarirawai na mejafoi aweufo kontai.” ");
INSERT INTO amk_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ampafe Yesusi medu wei aha deyo, “Wiwingwa wau, nemu roaso yau we Mananu Mampariri wa fuba paria. Ampafe fianai aino butang wea wa wobuai kaririai ampa.” Tuti na tatofang kutu nanai kontaio ne kamitungfoi denteng. ");
INSERT INTO amk_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesusi da weru katai nanifo, da wa werurang na nafareng na ruru Galilea foi. Tuti da wa dautai to wiwoi bei ayai minohi nai. ");
INSERT INTO amk_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ainanaya kaiwasa bitoya paria era wei ma, eha inontarai emaninang bitoya, amani inontarai era esoberaha fosa, mano euremifafa fosa, mano efaya fosa, mano eboromitamu fosa tuti mano emaninang siai wei fosa kontai. Kaiwasa fuba nani kiai ehasara eminohi na Yesusi awerengreafo tuti niarisa ebeng. ");
INSERT INTO amk_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ampafe kaiwasa fuba era ma nanisa epapuhung paria we ewati terai na euremireafo we inontarai anta eboromitamu fosa emadu aha, mano era esoberaha fosa era mimoya aha, mano efaya fosa etoa era, tuti mano euremifafa fosa ewati aha. Ampafe etaparanding Allaio inontarai Israeli fosa esomi wei foi. ");
INSERT INTO amk_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Mayeai Yesusi sahu ne inontarai ewesuraya mandu fosara, medu wesa deyo, “Arohuo kaiwasa bitoya nini paria, weo we rahida botorua fininai enayai na ninai pampang ria yau, tuti ene pari fiang we etang ampa. Ampafe imaya we yemisa etaraberasa na enemirorong kehabi to ene munu rorong fo aha kaha, weo nana mani ambori manea etawai na rang rabuang ki.” ");
INSERT INTO amk_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Ainanaya Yesusi ne inontarai ewesuraya mandu fosa emadu wei aha eteyo, “Daie, na katai wewui tonina nei wori, tasobu fiangfeai fuba we demoya kaiwasa fuba nini rai e?” ");
INSERT INTO amk_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesusi dutansa aha deyo, “Meha roti beiru wa?” Eroa wei eteyo, “Itu tuti diang katui kutu maneiru teai kontai.” ");
INSERT INTO amk_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ainanaya Yesusi demi kaiwasa bitoya foi eminohi na kahofa nuwowongfo. ");
INSERT INTO amk_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Mayeai kia roti itufo tuti diangfo sitoru, dohong mahikai we Allai. Ainanaya fioabau rotifo tuti diangfo, mayeai dohonaio ne inontarai ewesuraya mandu fosa, tuti etatorai we kaiwasa bitoya foi we etang. ");
INSERT INTO amk_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Kaiwasa bitoya foi etampi paria emamosi, mayeai ne inontarai ewesuraya mandu fosa efanduhi fiang sea foi aha mani dang nawang fiabai itu sefang aha. ");
INSERT INTO amk_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Kaiwasa fuba dampi nani mani, ewepiaura wering webea (4.000) nana mani titou mangfosa tera finana, wiro ato tamu wiwing tuti arikang fosa kaha. ");
INSERT INTO amk_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Mayeai Yesusi demi kaiwasa bitoya foi etaraberasa to ene munufo aha, mae I tuti ne inontarai suraya mandu fosa etautai to wafeai tuti etafai to katai watai kefang we bendari Magadania. ");
INSERT INTO amk_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Mayeai Farisi tuti Saduki manea era we Yesusi ma, we eweanggariri. Ampafe etutani we niari fiainawiai na rorafaisi bei wesa, ambori ewaitawanai we i mani da na Allai ma. ");
INSERT INTO amk_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Wape Yesusi yoa wesa deyo, “Wofoi sawa mani mewati kafafe na rorafaisi berika, nana mani metaroanai meteyo kameai mani wo pia rai. ");
INSERT INTO amk_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Tuti na kameaifo, wofoi dautai mewati rorafaisi berika tuti wekafafe paria, nana mani meteyo rahida nini weroharira rai. Mesawai paria we metaroang fi na rorafaisi tonanai, wape fi kawariai na rabuang bonini fo wiro mewaitawang metaroangna kaha. ");
INSERT INTO amk_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kaiwasa fuinini mesaipaya paria tuti mehurumitare mene Sengfoi, ne tarai toyari mang manei kurutare ne wiwingfoi tuti dohong we wiwing siai. Metutang we inari fitantumafeai we fiainawiai we mea kariri yau. Wape wiro inari fitantuma siai fea kaha, mae fianai aino mewaitawana na nabi Yunusia fo terai.” Yesusi medua kai nanai da weru sara. ");
INSERT INTO amk_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Na kutu etafaia sobu ruru eneung dowei fo nanai, Yesusi ne inontaraifosa arahio earomioai we eha pari roti. ");
INSERT INTO amk_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Na siari nanai kontaio Yesusi medu wesa deyo, “Mewaitawang weduarai tuti metanansiau we ragio na Farisifosa tuti Sadukifosa foi.” ");
INSERT INTO amk_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Yesusi ne inontaraifosa etarami medu tonanafo, emadu wawerasa eteyo, “Tarahio deitawanai we taha pari rotine ampafe medu tonanai nina.” ");
INSERT INTO amk_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Wape Yesusi deitawang kariri fianai aino emadura fo, ampafe medu wesa aha deyo, “Inontarai meroasoai turura kaha di mea. We fianie memadu wawera mea kariri meha pari rotife nina? ");
INSERT INTO amk_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Metaroana kaharai e? Mearomiporo fitantuma raminde inari na roti ring fo we kaiwasa ewepiaura wering wering fosa (5.000) etangfo ampa ne? Tuti seafoi dang bayai beiru? ");
INSERT INTO amk_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Tuti na roti itu fo we kaiwasa ewepiaura wering webea fosa (4.000) etangfo ne? Tuti ne seafoi dang nawang fuba beiru? ");
INSERT INTO amk_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Todoni fino metafu nehu kaiwone na mai kahai nina? Wiro rotifo aino imadu kariria ne kaha, mae fi imadu kariria fo mani yeyo, metanansiau we ragio na Farisifosa tuti Sadukifosa foi.” ");
INSERT INTO amk_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Yesusi medu tonanai wesara fo, arahio ewaitawanai we fi deretawansa wea fo mani, wiro we ragio nari roti naya foi kaha, mae we Farisi tuti Saduki fosa ene aunaufo. Weo etaunau we I mani wiro Allai demi we weMananu kaha fefe. ");
INSERT INTO amk_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Mayeai Yesusi da weru katai nani to katai kefang we bendari Kaisarea Filipi foi. Na nanai dutang bera ne inontarai erariati fosa deyo, “Kaiwasa bitoya foi emadu eteyo Kaisung Inontarai nei mani, mandoni dine?” ");
INSERT INTO amk_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ampafe eroa wei eteyo, “Manea eteyo Yohanesi mano webaptisi kaiwasa foi di wau, manea kontai eteyo nabio Eliai di wau, tuti manea kontai aha mani eteyo nabi Yeremiai di wau ete nabi siai fo manei di wau.” ");
INSERT INTO amk_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ainanaya Yesusi dutang barisa deyo, “Wape na mantaung mea mani meteyo mandoni di yau?” ");
INSERT INTO amk_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ampafe Simon Petrusi yoa wei aha deyo, “Daie! Wau mani Mananu Mampariri fi di wau, Allai mano darang we fitawafa foi ne Kaisung di wau.” ");
INSERT INTO amk_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ainanaya Yesusi medu we Simoni aha deyo, “Simoni, Yonai antungne wau ne, wobu ne maine paria. Weo fianai aino modurai ninai, wiro inontarai batang manei dino deisaha kaiwo nanai we waune kaha, mae Dai na rorafaisi andino deisahara ne. ");
INSERT INTO amk_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ampafe imadurai we wau yeyo, wau mani wonomu fino Petrusi, nana mani neta we kamiei mitubaru. Ampafe kariri kamiei inontaraifosa enariri we ebaung ene munufo sauwi fo ambori munufoi mitubaru, yau kontaio ibaung nehu jematinei na kamiei bonani amani na kaiwo tarai modura wa nanai. Ampafe mararehafoi ne mambiriufo kontai ki wape wedayari sawa kaha. ");
INSERT INTO amk_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Wauno ambori yohong rahutu to Allai ne Mananu rorong fo ne aisufo we wau ne. Ampafe fiani aino boiayarai na nunei mani, Allai na rorafaisi kontai deiayarai, tuti fianai aino roa weai na nunei mani, Allai na rorafaisi kontaio yoa weai.” ");
INSERT INTO amk_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ainanaya Yesusi deretawansa we dohonao ewuwuai we kaiwasa siai foi kariri i we weMananu Mampariri fo fe. ");
INSERT INTO amk_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Na rahida bonani to fongna fo, Yesusi meduraia kasau we ne inontarai erariati fosa weo todoni kontaio ambori da to Yerusalemi tuti sodai dadira bitoya ria mano ewewafonia fosa, imami baba fosa, tuti mantaunau Kaiwo Musai soi fosa. Tuti ambori emunia mireha, wape werahida botoru aha mani, suwi na marareha rorong foi aha ki. ");
INSERT INTO amk_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Manamo Petrusi yabi berahi to fui tuti suari deyo, “Sengne waune, kadono Allai warasaya ne tonanafo weru wau, ambori finanai wodaira fanai.” ");
INSERT INTO amk_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ampafe Yesusi deti berahai we Petrusi tuti suari deyo, “Ro weruai, wiro weSaminseni fanai. Weo nari toyari Saminsenie, rurai we weanggari yau ambori itawai tuti inari kariri Allai ne dawiane kaha fefe. Fianai aino enemutituaita ne, enemutituaitai kariri wau na weinontarai batang, wiro kariri fianai aino Allai enetituaita fo kaha.” ");
INSERT INTO amk_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ainanaya Yesusi medu we ne inontarai erariati fosa deyo, “Mandoni dino deyo daria yau mani, deiaya mantauni fi dohong weai na nunei fo, tuti sodua ne aitabafoi, amani meinenang we sodai dadira kariri yau, tuti daria yau pampang. ");
INSERT INTO amk_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Weo mandoni dino de derara mantauni ne ansengfoi sewa weru daria yau mani ambori ne ansengfoi wioru ki, mae mandoni dino na nufi ninai enewawu yau awao wonohune wedaya tarahi mireha kontai ki, i ambori sobu numainufo ki. ");
INSERT INTO amk_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Weo manei yurai we sobu nunei sentenang, wape ambori nuaninufoi wioru tuti sobu numainufo kaha mani, we fianie yurai karerai nina? Tuti fianai aino dohonai we yiwang nuaninufoi nai aha fo? ");
INSERT INTO amk_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Weo Kaisung Inontarai nei ambori daraberahi to nunei aha ma na Dai Allai ne sambewaraio dedai fo tuti ne wewai rabuangfoi ma ki. Rabuang bonani ambori dohong fiembaitafo we mansiari-mansiari kariri fi niari fo, beng ete karira. ");
INSERT INTO amk_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tarai, imadu we mea mau yeyo, na mano metoari na nina ne mea, manea wiro emarareha kahai paria ewati Kaisung Inontarai nei daraberahi weMananu na ne Mananu rorong fo ma.” ");
INSERT INTO amk_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Werahida wonang aha mani, Yesusi kia Petrusi, Yakobusi tuti ne tahatui Yohanesi suru, itorautai to uai dedai bei nuwowongfo ayai. Na nanai itomeiri sitoru kawurua. ");
INSERT INTO amk_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ainanaya na tantuma Yesusi ne taraifoi yiwani siai aha na itouremireafo. Urengfo sambewarai toyari wo tuti ne ansung satara fo bua karofaria kaiwewa. ");
INSERT INTO amk_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mayeai na tantuma itowati Musai tuti Eliai uroa umadu riati. ");
INSERT INTO amk_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ainanaya Petrusi medu funomai we Yesusi deyo, “Sengne waune, mahikai paria we tanayai na katai nini. Ampafe maya mani, inari warumai botoru we muntoru, amani bei we Dai wau, bei we Musai, tuti bei we Eliai.” ");
INSERT INTO amk_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Petrusi doa medu tonanai mae, na tantuma kafafe biua karofari bei sea ma sorusa. Na kafafe rorong fo rawafui bei medu deyo, “Nehu Kaisungno enehuwawuti fi dinini, andino kia enehurorong fine. Metaramididauwi.” ");
INSERT INTO amk_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Yesusi ne inontarai kia sitorufo sitoru itotaramio rawafuifoi nanai itotau aweu itorisang itorewomifo na kahofafo we itomatai paria fefe. ");
INSERT INTO amk_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ampafe Yesusi da we sitorua tuti suba warakehafoia disang sitoru mae medu deyo, “Muntoroa bari muntoru, muntomatai fanai.” ");
INSERT INTO amk_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Mayeai itofoai itouremi itowatia mani, itowati manei ahang kaha, mae Yesusi meiri terai. ");
INSERT INTO amk_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Itobiari na uai nuwowongfo aweufo nanai, Yesusi deretawang sitoru deyo, “Fianai aino anta muntowatioai nanai, dohonao muntoraisaharai we manei fe, mae nayai kio Kaisung Inontarai nei suwi na marareha rorong foi aha ma akawuru wo.” ");
INSERT INTO amk_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Yesusi ne inontarai kia sitoru fo itorutang berahi aha itoreyo, “Tonana mani we fiani e mantaunau Kaiwo Musai soi fosa eteyo, todoni kontaio Eliai da fafong ma akawuru wo?” ");
INSERT INTO amk_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ampafe Yesusi yoa we sitoru aha deyo, “Tarai, Eliai ambori da ma we meinenang maino fifiani kontai ki. ");
INSERT INTO amk_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Wape imadu mau yeyo, Eliai da kawuru ma ne, wape inontaraine etaroansoi kaha tuti enari kanggani kariri ene etawiafo. Kaisung Inontarai nei kontai ambori sodai dadira tonanai na ewarami rorong fo kontai ki.” ");
INSERT INTO amk_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yesusi medu tonanaia fo, arahio ne inontarai kia sitoru fo itowaitawanai we fianai aino medura fo, medu kariri Yohanesi mano webaptisi kaiwasa foi. ");
INSERT INTO amk_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Yesusi tuti ne inontarai kia sitoru fo itorarabera sitoru to kaiwasa bitoya foia nanai, inontarai manei da we Yesusia tuti disangkapa awebukafo na arongreafo. ");
INSERT INTO amk_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Tuti medu wei deyo, “Sengne waune, aromuo nehu kaisungfoi wo, i sodai maninangno kerira paria. Maninang ureng marareha arora foi dohoni wana mani, ne taraifoi tiapa beyari tuti kawawuai tipu na borongfo. Wedaya ea mani saukaha adia rorong fo tuti to mereha rorong fo. ");
INSERT INTO amk_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Ikari kawuru to nemu inontarai eraria wau nesa ampa, wape wiro ewemambiriu we enariri denteng kaha.” ");
INSERT INTO amk_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ampafe Yesusi medu we ne inontaraifosa deyo, “Meai arana ne? Kaiwasa fuinini mea, tarai weinontarai meroasoa di mea kaha tuti mera sarawai. Inai rahang mea tuti itawang yau we mea pari kidoni wori meroasoai ki? Meha arikangwai ma.” ");
INSERT INTO amk_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Na tapapa Yesusi sua nuaninu karira foi ambori da to boriei weru arikangfoi, tuti na kutu siari nanai kontaio denteng. ");
INSERT INTO amk_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Mayeai Yesusi ne inontarai erariati fosa titousa era weia, etutang bera Yesusi aha eteyo, “Daie, todonie amebiriu we ametata nuaninu karira foi kahai ninai?” ");
INSERT INTO amk_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesusi yoa wesa deyo, “Fio wedaya mebiriu we metata nuaninu karira nani kaha ne mani, wiro meroasoai turura kahai. Weo tarai, imadu we mea mau yeyo, sawi bongnei mani ketui paria, wape masino meroasoawa fuba kariri sawi bong bei mani, memadu we uai bei we tifatingna doari na katai siai bei mani, nana mani kaririai ki. Tuti fitantuma todoni feai kontaio menari ki.  ");
INSERT INTO amk_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Wape nuaninu karira ne tarai tonina nei mani, metatari na mewenadi tuti mewepuasa terai.” ");
INSERT INTO amk_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Na rahida bo Yesusi tuti ne inontarai erariati fosa efanduhisa na Galileafo, medu wesa deyo, “Kaisung Inontarai nei ambori etawayani to mano eharira fo ewarami rorong fo ki. ");
INSERT INTO amk_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Tuti emuni mireha, wape rahida botoru foi ambori suwi aha ki.” Ampafe ne inontarai erariati fosa enemirorong fituayai paria. ");
INSERT INTO amk_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Na rahida bo Yesusi tutu ne inontarai erariati fosa era wa sobu bendari Kapernaumi fo, na siari nanai mano efanduhi pajaki we Sempaisi ne Munufoi manea, era we Petrusia etutang berahi eteyo, “Nemu Mantaunaufoi biai pajaki we Sempaisi ne Munufoi ete bireri e?” ");
INSERT INTO amk_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ainanaya Petrusi yoa wesa deyo, “Yo, biai kontai.” Ampafe na kutu Petrusi daraberahi to munu Yesusi minohi nai foia fo, Yesusi dinteuwi deyo, “Simone, enemutituai tofino? Mandoni dino biai pajaki ete barasteng we mananu nunei sa ne? Mananufo ene inontarai ene katai na nana fosa ete inontarai aiseio enayai na nana fosa re?” ");
INSERT INTO amk_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Petrusi yoa deyo, “Inontarai aisei nesa.” Ampafe Yesusi yoa deyo, “Tonana mani mananufo ene inontarai bitoya fosa wiro ebai kaha. ");
INSERT INTO amk_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Wape ambori enemirorong pirahai we tata kaha mani, ro to ruru rausia we tukai nai. Ro arau mani diang mano foti reantenang wai mani, doi nayai na borongfe wa. Ampafe fobai borongwai tuti ka doi nanai ma we bai pajakio etutang wea fo nayai. Doi nanai demoyarai we bai pajaki we wau tuti yau nayai.” ");
INSERT INTO amk_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Na rabuang bonani Yesusi ne inontarai dirisa fosa era wei ma, etutani eteyo, “Daie, mandoni dino fiabai sewa na nemu weMananu rorong fai ne?” ");
INSERT INTO amk_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ainanaya Yesusi sahu arikang katui manei ma tuti dohonia doari na earomireafo. ");
INSERT INTO amk_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Medu wesa deyo, “Tarai, imadu we mea mau yeyo, mandoni dino wiro yiwang enerorongfoia ne tarai kariri arikang katui nini kaha mani, wiro suai to Allai ne Mananu rorong fo kaha. ");
INSERT INTO amk_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Tonana mani, mandoni dino yiwang enerorongfoi tewawa kariri arikang katui nini mani, andino fiabai sewa na nehu Mananu rorong fai ne. ");
INSERT INTO amk_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Mandoni dino demang we arikang tonina nesa na mai na wonohune mani, wenanai demang we yau kontai. ");
INSERT INTO amk_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Wape mandoni kontai, andino wedaya inontarai toyari arikang fininisa, amani mano eroaso yau nesa manei, niari sasari, nana mani ne mahikai sewa we wenani mani, kase kamiei fuba bei na rahanangfo tuti kabioi deisui na rawanang rausi. ");
INSERT INTO amk_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Karira pari we inontarai na nuneisa weo fi wedaya enari sasari fo bitoya paria. Tarai, we finanai kawariai na nunei, wape mano wedaya inontarai eroaso yau ahang kaha mani, sodai ne karirafo paria. ");
INSERT INTO amk_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Masino waramuwa ete awemuwa wedaya sasari we wau mani, ferangkutuai tuti kobioi weru wau. Weo ne beng sewa we wau fo mani, wobu numainufo na waramu ete awemu kaburufo, weru waramu tuti awemu fo nayai masi wape taukaha Adia danggararu we fitawafa foi fo. ");
INSERT INTO amk_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Tuti masino uremuwa wedaya sasari we wau mani, ketafatini kobioi weruai, weo ne beng sewa we wau mani wobu numainufo na uremu boyari fo weru uremufo unayai ruhiai wape ambori taukaha Sorohao Adia rorong foi fo.” ");
INSERT INTO amk_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Metanansiau we dohonao mesahutawang inontarai katui ninisa manei fe, weo wewaio ewaitawang weduasa fosa enayaia mutu na Dai Allai urengreafo pampang.  ");
INSERT INTO amk_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Weo Kaisung Inontarai nei da ma we feriri inontarai era saiworua fosa. ");
INSERT INTO amk_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Menemitituai tofino? Manei ne domba ewepiaring, manamo manei da sarawai ampafe niai, nana mani dohong todoni rai? I wiro niayai deitawang ne domba ewemansiri konta reti piaring fosa ahang kaha, mae todoni kontaio sawing ne efaufosa enayai na wiwoifoi mae da sera we mansiario niai foi. ");
INSERT INTO amk_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Tuti tarai, imadu we mea mau yeyo, masino sobui aha mani, piraisefo fuba sewa aha weru piraise we ne efauo enai kaha fosa. ");
INSERT INTO amk_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Dai na rorafaisi kontai ne tarai tonana. Miaya we inontarai katui toyari arikangfesa ninisa manei niai werui kaha.” ");
INSERT INTO amk_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Mane nemu doroi manei niari sarawai we wau mani, ro wei tuti na titou muru teraio wuari boinawi we fi sarawaio niari nanai. Masino tarao wau mani, wobui we nemu doroi dine nariai aha. ");
INSERT INTO amk_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Wape tarao wau kaha mani, ka nari inontarai itowemandu ete mantoru teai aha we ambori itomaduairai kariri ne kaiwo mumadura wa kontai ampafe na fifiani kontaio wiro enemiwawera weai ahang kahai, mae tarai dohong sarawai. ");
INSERT INTO amk_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Mae masino tarao sitoru konta kaha mani, ka kaiwofo aha modurai na jemati earomireafo aha. Tuti masino taraosa konta kaha mani, wahui we i inontaraio deroanso Allai kaha dine, ete toyari wefianduhi pajaki we parenta Roma foi dine. ");
INSERT INTO amk_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Tarai, imadu we mea mau yeyo, fianai aino na nunei meteyo enari fanai, Allai kontai yoa weai tonanai na rorafaisi. Tuti fianai aino meroa we enari na nunei, finanai Allai yoa weai kontai na rorafaisi. ");
INSERT INTO amk_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Tuti meroasoai kontaifa weo, na nufi ninai uwemandu na mea uenemirorong boyari we fieai tuti uwenadi urutang tutirai we Dai na rorafaisi, nana mani todoni kontaio Dai yoa we une nadi nani ki tuti dohong kaririai ki. ");
INSERT INTO amk_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Weo na doni kontai uwemandu ete mantoru itofanduhi itoru na wonohune mani, na nanai inayai rahansa kontai.” ");
INSERT INTO amk_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Mayeai Petrusi da we Yesusi ma tuti dutani deyo, “Sengne waune, masino nehu doroi manei niari sarafieai pampang we yau, nana mani paria webeiru yeiai ne sarawai nana ne? Paria sobu we beitu e?” ");
INSERT INTO amk_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesusi yoa wei deyo, “Bireri. Imadurai mau yeyo, wiro webeitu tera kaha, mae wepiatorua sura webeitu aha tuti sewa nanai aha. ");
INSERT INTO amk_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Weo Allai ne weMananufo mani, ne tarai kariri mananu manei deto kariri ne doio ne mangfata baba fosa eha fo. ");
INSERT INTO amk_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Rahida bo deto kariri ne doifo nanai, ne mangfata erufi wei fosa eha mangfata mano kia ne doi foi ma doari na arongreafo. Wenani kia doi bitoya paria (10.000 talenta) wape wiro biaita kaharai. ");
INSERT INTO amk_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Wemambiriu we yiwang ahang kaha ampafe mananufoi dohong kaiwo we ehari tuti ne wiwing, ne arikang, tuti ne ra minohi tutiri foi kiai we etawayanai, ambori doifo we yiwang ne doi kia fo nai aha. ");
INSERT INTO amk_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Ainanaya mangfatafoi disangkapa awebuka na mananufoi arongreafo, mae dutanai paria deyo, ‘Daie, kadeo bohong rahida we yau wo ambori iriwang nemu doine ki.’ ");
INSERT INTO amk_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Mananufoi aroi ampafe deiairi we wiro yiwang ne doi kia fo ahang kaha tuti sawini da wa. ");
INSERT INTO amk_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Mangfatafoi da to boriei weru munu mananu foia nanai, tate ne maniwowirio wemangfata kontai manei. Mangfata mano siai nani kia ne doi fuba turura kaha, amani doi dinari piaring (100 dinar) mae biaita kaharai. Ampafe yutawang mangfata kia ne doi dinari piaring nani tuti yukota rahanang mae medu wei deyo, ‘Bai kahai nehu doiwa.’ ");
INSERT INTO amk_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ainanaya mangfata mano mandu foi disangkapa awebuka aweu wiatai na arongreafo mae medu deyo, ‘Maniwowire, bomang kuteai ambori iriwang nemu doiwa ki.’ ");
INSERT INTO amk_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Manamo mangfata mano ne doifoi nani medu wei deyo, ‘Ye yemang aha kaha.’ Ampafe demi ne inontarai eharia esoari to aitamu rorong foa wiatai nai paria yiwang ne doifoa kai. ");
INSERT INTO amk_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Fianai aino mangfatafoi niari tonanai we ne doroifoi nanai, mangfata siaio erufi kontai we mananufoi manea ewatioai, ampafe enemitituai weai paria dohona mani era wa eteisaharai we mananufoi kariri fianai aino ene doroi mangfatafoi niari nanai. ");
INSERT INTO amk_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ainanaya mananufoi sahu ne mangfata niari tonana foi ma medu wei deyo, ‘Wau mangfata woipaya di wau! Nehu doi bitoya paria ka fo yeiairai we wiro baitai ahang kaha, weo ro ma womi na arohureane we yohong rahida we waufo. ");
INSERT INTO amk_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Todonie arohu wau tonanai, wape wiro aromu nemu doroifoi kariria kahai nina?’ ");
INSERT INTO amk_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Mananufoi kesou paria ampafe demi ne mangfatafosa eha inontaraifoia etohoni to mano eru aiboi fosa ewarami rorong foa, pariao biai bera ne doi anta kiari kiai fo.” ");
INSERT INTO amk_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesusi medua kai mani deituarai deyo, “Kariri fianai aino mananufoi niari we mangfata seipaya foi nanai, mea kontai masino meteiai mene doroifosa na menemirorong mesi kahai tonana mani, Dai Allai na rorafaisi kontai ambori niari tonanai we mea kiai ki.” ");
INSERT INTO amk_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesusi medu deunau kariri fi fuba nani kiaia nanai, da weru Galilea to nu Yudea foi na waya Yardeni dereung dowei fo awaru. ");
INSERT INTO amk_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Kaiwasa bitoya era riati, tuti na wana niari mano emaninang fosa ebeng aha. ");
INSERT INTO amk_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ainanaya Farisifosa era kefang Yesusia we eweanggariri, amani etutani ambori deiai Hukumi Musai soi fo. Ampafe etutani eteyo, “Kariri tane hukumi agama nei mani, mangfoi dira binengfoi funomai tonana rai e?” ");
INSERT INTO amk_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesusi yoa wesa deyo, “Metatorai na Sempaisi ne Kaiwofo kawuru ampa we na reantenang Allai niari inontaraine tata fo, niari manei wemang tuti manei wewiwing fo ampa. ");
INSERT INTO amk_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Tuti Allai kontai medu deyo, ‘Nanai wedaya mangfoi ambori sawing inang tamang suru tuti weboyari ria ne wiwingfoi, ambori ne tarai toyari une tarai boyari.’ ");
INSERT INTO amk_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Doni wiro uweboru ahang kahai mae uweboyari. Ampafe fianai aino Allai fianduhiai weboyaria fo, wiro inontarai manei kia tateraifa fanai.” ");
INSERT INTO amk_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ainanaya Farisifosa etutang bera Yesusi aha eteyo, “Tonana mani we fianie Musai dohongno hukumi deyo, mang manei dira binengfoi mani dohong te surati dirari foi we binengfoi tuti demi da werui nina?” ");
INSERT INTO amk_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesusi yoa wesa deyo, “Musai dohong kaiwofo tonanafo mani, weo deitawanai we menumikamiei mitubaru tuti dadira paria we metaramididau kaiwo aunau fo, ai wedaya mani Musai soi kaiwo kariri metira mene wiwingfosa tonanafo nina. Wape na reantenang Allai niari inontaraine tata fo, wiro tonana kaha. ");
INSERT INTO amk_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Wape imadurai mau yeyo, mandoni dino dira binengfoi mae binengfoi wiro dena ria mang siai kaha, ainanaya dau wiwing manei siai aha mani, wenani niari sasari, amani sasario dena ria wiwing siai fo.” ");
INSERT INTO amk_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ampafe Yesusi ne inontarai suraya mandu fosa emadu wei eteyo, “Masino mang tuti binengfoi mani une tarai tonana mani, denteng sewa mani tarirau fanai.” ");
INSERT INTO amk_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesusi yoa deyo, “Wiro inontarainesa kiai eroa we kaiwo memaduarai nana kaha, manta mano Allai dirisa tonanai tera fosa ansaino enari kariria ne. ");
INSERT INTO amk_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Weo inontarainesa, manea wiro erirau kaha, weo etaubau enumi ma fo ene tarai tonanai, wape manea aha mani, erirau kahai weo fieai ete inontarai siai manea enarikanggani eawemi rorong fo ambori wiro ewemambiriu we erirau kahai tonanai. Tuti manea aha mani erirau kahai we mantaungsa ehutuai tonanaifa we wiro erirau kaha, ambori ehasau we erurai erufi we Sempaisi na ne Mananu rorong fo terai. Mandoni dino wemambiriu we tefu kaiwo nina mani, tefuraia.” ");
INSERT INTO amk_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ainanaya, inontarai manea eha ene arikang manea ma, weo eteyo Yesusi yuai warangfoa wasausa tuti wenadi mioansa. Wape Yesusi ne inontaraifosa esuasa. ");
INSERT INTO amk_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ampafe Yesusi medu we ne inontaraifosa deyo, “Metawing arikangwasa era we yau ma, dohonao meteiweduasa fe, weo inontarai toyari arikangfesa nini saino esuai to Allai ne Mananu rorong fo ne.” ");
INSERT INTO amk_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ainanaya yuai warangfo wasausa tuti mioansa. Mayeai da to katai bei siaia. ");
INSERT INTO amk_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Rahida bei inontarai manei da we Yesusia tuti dutani deyo, “Dai Mantaunaune waune, fi beng fianai aino inari we ambori isobu numainufo ne?” ");
INSERT INTO amk_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesusi yoa deyo, “We fianie butang yau we fianai aino bengfo ninai? Mansiari kawuru andino denteng ne. Wape boyo wobu numainufo mani, bohong kariri te Allai ne Kaiwo dohonai we tatohong kariria fo.” ");
INSERT INTO amk_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Inontaraifoi dutang Yesusi aha deyo, “Kaiwo bo dotu todoni fo?” Yesusi yoa wei aha deyo, ");
INSERT INTO amk_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Womi we nemu dai tuti nemu ai,’ tuti, ");
INSERT INTO amk_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Bariboaifoi yoa deyo, “Kaiwoariri fuba nani yohong kaririai kawurua kai ampa, ne doni aino inari tara ne?” ");
INSERT INTO amk_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesusi medu wei aha deyo, “Ampafe boyo mosi na munohi toa fo we wobu numainufo mani, ro wa bowayang nemu ra munohi tutira wara kai tuti doiwa bohonai we inontarai ene pari fi fosa, nanaia mani wobu ra na Waidania finanai. Tuti nari tonanaia mani ro ma ro ria yau.” ");
INSERT INTO amk_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Inontaraifoi tarao kaiwo Yesusi medurai wei tonana fo, wiro doari ahang kahai mae da weru katai nani na enerorongfoi fituayai paria, we ne rafoi bitoya paria fefe. ");
INSERT INTO amk_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ainanaya Yesusi medu we ne inontarai erariati fosa deyo, “Yeisaharai we mea weo mawa kahai we inontarai ne ra bitoya manei suai to Allai ne Mananu rorong fo ki. ");
INSERT INTO amk_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kontai yeisaharai we mea, weo mawa sewa we unta manei suai kaha aniai kamirei bei weru inontarai ne ra bitoya manei suai to Allai ne Mananu Rorongfe fo.” ");
INSERT INTO amk_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yesusi ne inontarai ewesuraya mandu fosa etaramio kaiwofo nanai epapuhing paria, tuti emadu we Yesusi eteyo, “Tonana mani, mandoni dino mesi we sobu faririfo ne?” ");
INSERT INTO amk_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ainanaya Yesusi seitesa mae medu wesa deyo, “We inontarainesa, erurai na mantaungsa kontai mae esobua kahai arora wa, wape we Allai mani, fifiani kontaio mawa arora wei.” ");
INSERT INTO amk_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ainanaya Petrusi medu deyo, “Daie, boti fifiani kontaio ametawinaifa tuti ameraria wau, ampafe fiani aino amesobuai ria wau ne?” ");
INSERT INTO amk_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesusi medu wesa deyo, “Tarai, imadurai we mea mau yeyo, na rahida bo nu weworu Allai niariri aha foi da ma mani, Kaisung Inontarai nei ambori minohi na ne kadera mananuo sambewara dedai foi ki. Tuti mea kontai, nehu inontarai mewesuraya manduo meraria yau nini mea, ambori meminohi na kadera suraya boru fo kontai ria Kaisung Inontarai nei, tuti mehutu kaiwo kariri riria Israelio suraya boru fo ki. ");
INSERT INTO amk_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Tuti inontarai mandoni da weru ne munufoi ete ne doroi mang foi ete doroi wiwing foi ete tamana ete inana ete ne arikangfosa ete ne kahofafo, weo daria yau fo, ambori sobu fi sobuai ria Allai fo fuba webepiaring sewa aha weru ne sobuai na nuneifo ki, tuti sobu numainufo. ");
INSERT INTO amk_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Wape kaiwasa bitoyao na nunei ninai ewefonia fosa ambori enai to kurumifui ki, mae mano na nunei ninai enai to kurumifui fosa ambori ewefoniai ki.” ");
INSERT INTO amk_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yesusi medu aha deyo, “Allai ne Mananu rorong fo mani ne tarai toyari fiyiwansoai nini. Inontarai manei ne romi angguri bei. Kameai kutung doari da kameai sera we inontarai we erufi nai. ");
INSERT INTO amk_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Sobu inontaraifo maneara, tuti medua futuai riasa we biai we mansiari rahida bei mani, doi dinari bei, nana mani doi mai we ne fiembaitai rahida bei. Ainanaya demisa era wa enari ne romi angguri foia. ");
INSERT INTO amk_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Mayeai araha ureng indeatara mani, inontarai ne romi angguri foi da nariai aha tuti deti inontarai manea enai funomai na kondirorafoi. ");
INSERT INTO amk_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ampefe medu wesa deyo, ‘Mea kontai mera wa menari nehu romi angguri foi, tuti ibai mea fianai aino mai kariri fi meru fo ki.’ ");
INSERT INTO amk_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Ampafe era wa. Mayeai araha ureng suraya boru tuti araha ureng botoru aha, inontarai ne romifoi da sera we inontarai nariai aha. ");
INSERT INTO amk_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ramindena araha ureng ring mani da nariai aha to kondirorafoi tuti deti inontarai siai manea enai nai wape enari fiea kaha, ampefe medu wesa deyo, ‘We fiani meru fiea kahai, mae meminohi funomai na kondiroranei rahida bei sentenang nina?’ ");
INSERT INTO amk_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Emadu wei eteyo, ‘Wiro manei dohong fieai we ameru kaha.’ Ainanaya medu wesa deyo, ‘Tonana mani mea kontai mera wa merufi na nehu romi angguri foi.’ ");
INSERT INTO amk_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Ramindenara mani mano ne romi angguri foi medu we ne mandorifoi deyo, ‘Wahu inontarai erufi we yau wasa ambori baisa, amani na mano erufi wefuia wasa paria sobu mano erufi na kameai wasa.’ ");
INSERT INTO amk_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ampefe mandorifoi biai doi dinari bosiawarai we inontarai erufi na ramindena araha ureng ring fosa. ");
INSERT INTO amk_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ainanaya inontarai erufi na kameai fosa, ewaitarahio esobu doi fuba sewa mano erufi na ramindena fosa, manamo ea kontai esobu doi dinari bosiawarai. ");
INSERT INTO amk_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Esobu ene doifo mani, ehasou tuti ehutu mano demisa erufi wei foi na enemirorongfo. ");
INSERT INTO amk_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Eteyo, ‘Eh! Todoni fino amerufi maraba paria we rahida bei sentenang, tuti wonei sina amea na kameaifa paria sobu ramindena, wape bai amea mai kariri mano era wefuiai ma erufi we araha ureng boyari kawuru fosa ninai?’ ");
INSERT INTO amk_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Manamo mano ne romi foi medu we inontarai nanisa manei deyo, ‘Maniwowire! Wiro inari fisarawafeai we wau kaha. Weo tumadu ruhiai kawuru ampa we rufi we yau ne, ambori ibai wau rahida bei mani doi dinari bei. ");
INSERT INTO amk_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ka nemu doiwa tuti ro wa. Weo yeyo ibai mano yufi wefuai pari nini doi dinari bei kariri ibai wau ninai kontai. ");
INSERT INTO amk_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Weo fianai aino nehu ne, nehu mambiriu we yeyo yohonai todoni, kariri nehu awiafo. Ete enemurorong pirahai we warahu takahetuai funomai tonanafo ne?’ ” ");
INSERT INTO amk_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ainanaya Yesusi medu tuarai aha, deyo, “Tonanai kontai inontarai ewefonia fosa ambori enai to kurumifui ki, mae mano enai to kurumifui fosa ambori ewefoniai ki.” ");
INSERT INTO amk_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Rahida Yesusi tuti ne inontarai ewesuraya mandu fosa era to bendari Yerusalemi ayai fo, era wa mairabuang mani, fianduhisa mae medu wesa deyo, ");
INSERT INTO amk_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Metarami ma. Nina mani, tara to Yerusalemi ayai finina. Na wanai Kaisung Inontarai nei ambori manei dewayani we imami baba fosa tuti mantaunau Hukumi Musai soi fosa ki. Tuti ambori etohong aiboi marareha fo wei ki. ");
INSERT INTO amk_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Kontai etohoni to inontaraio etaroangno Allai kaha fosa we ambori eteiberahi, erarubati na wai, tuti epahui na aitabafoi. Wape rahida bo botoru foi, ambori suwi aha ki.” ");
INSERT INTO amk_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Mayeai Zebedeusi binengfoi tuti ne kaisungfo suru, amani Yakobusi tuti Yohanesi, itora we Yesusia. Disangkapa awebukafo na Yesusi arongreafo tuti dutani we fieai. ");
INSERT INTO amk_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Yesusi dutang wiwingfoi deyo, “Aie, fianai butang wea ne?” Wiwingfoi medu we Yesusi deyo, “Moduraia futuai we yau, we rahida ru wang Mananufo mani, bohong kataio mai fo we nehu kaisungne suru, amani manei minohi na waramu domoya wai tuti manei na waramu dowei wai.” ");
INSERT INTO amk_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesusi yoa we suru deyo, “Muwaitawang fianai aino murutang weai nina kaha. Weo mubiriu we murunung nano fi dadirao yunung nai nei e? Mubiriu we musodai dadira ambori isodairi foi konta rai e?” Uroa ureyo, “Aubiriu wea rai.” ");
INSERT INTO amk_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yesusi medu we suru deyo, “Nehu dadira nani murunung nai kontai. Nehu dadira nanai musodairi rai. Wape kariri mandoni dino ambori minohi na enehung domoya nei tuti na enehung dowei nei mani, yau wiro ikutu kaiwo kariri nana kaha. Katai nani Allai meinenami we inontarai kawuru ampa, amani mano diri suru kawuru we uminohi na nanaia fo.” ");
INSERT INTO amk_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Yesusi ne inontarai ewesura mano wei fosa etarami finanai ampefe ehasou mambetahatuifo suru paria. ");
INSERT INTO amk_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Mae Yesusi sahu kipasa ma, medu wesa deyo, “Mewaitawanaifa weo na kaiwasa etaroang Allai kaha fosa, amani Yahudi kaha fosa, mano ewenunggamiei we ene parentanei enari kanggani ene kaiwasafoi. Tuti mano ewewafoniai fosa etanggewa ene kaiwasafoi na tapapa. ");
INSERT INTO amk_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Wiro mene tarai tonana kaha, mae mandoni dino deyo fiebai sewa na mea fo mani, todoni kontaio wemangfata we mea. ");
INSERT INTO amk_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Tuti mano deyo wefoniai na mea fo mani, todoni kontaio wewoming we mea akawuru wo. ");
INSERT INTO amk_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Toyari Kaisung Inontarai nei kontaio wiro da ma we mefatari kaha, mae we fiata mea tuti we dohong ne taraifoi we feriri kaiwasa bitoya foi.” ");
INSERT INTO amk_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Rabuang bo Yesusi tuti ne inontarai ewesuraya mandu fosa era weru bendari Yeriho fo mani kaiwasa bitoya era ria Yesusi. ");
INSERT INTO amk_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tete inontarai uremifafa mandu uminohi na rang dereungfo na katai nani. Utaramioai we Yesusi da na nanafo usahu ureyo, “Sengno Dauti ne Kaisungne wau, aromuo auru!” ");
INSERT INTO amk_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Kaiwasa bitoya fosa esua suru we unemboru, manamo wiro utantumasa kaha, mae usahu mambiriu aha ureyo, “Sengno Dauti ne Kaisungwa waune, aromuo auru!” ");
INSERT INTO amk_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ainanaya Yesusi doa ukai tuti sahu suru ura weia tuti medu we suru deyo, “Fianai aino mureyo inari we muru ne?” ");
INSERT INTO amk_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Inontaraifo suru uroa we Yesusi ureyo, “Daie, aureyo auwati.” ");
INSERT INTO amk_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yesusi aro suru paria ampefe yuai warangfo waratawang uuremifo, na kutu nanai kontai uremifo tabau uwati. Ainanaya uraria Yesusia. ");
INSERT INTO amk_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Era wa kefang we Yerusalemi mani, esobu munue Betfage na wiwoi Saituni eneungfo. Na nanai Yesusi demi ne inontarai dirisa fosa uwemandu ura fafong. ");
INSERT INTO amk_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Medu we suru deyo, “Mura to munue watai na taaromife wanai, mura waroi afui kahai mae muwati manei tebuhi ne keledai manei doari na nanai tuti antungfoi. Murehuwi ambori muka suru we yau ma. ");
INSERT INTO amk_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Inontarai manei medu fieai we muru kariri fio munari nina mani, mumadu wei mureyo, ‘Sengnei dino demi auru auka suru weia ne,’ tuti yoa we muka suru ki.” ");
INSERT INTO amk_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Finanai kawariai ambori Sengnei ne Kaiwo nabifoi meduraia fo wetarai, amani, ");
INSERT INTO amk_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Boiririaifa we Kadawing Sioni foi, ‘Mewati! Mene Mananufi da we mea ma ne, I enerorong tewawa tuti dautai na keledai manei, amani keledai antung dine.’ ” ");
INSERT INTO amk_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ainanaya Yesusi ne inontaraifo suru ura wa tuti unari kariri Yesusi ne kaiwo dererai we surua fo. ");
INSERT INTO amk_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Uka keledaifoi tuti antungfoi we Yesusia mayeai ne inontaraifosa etohongno ene ansung boriai feai awiai ebuaisai na keledai kuruinafo suru, tuti Yesusi dautai ayai minohi sau keledai antungfoi. ");
INSERT INTO amk_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Kaiwasa bitoya paria eha ene ansungfoa ehafarai na rangfoi, manea kontai eharai ai totua fo tuti ehafarai kontai na rangfoi, ambori emaranding rangno Yesusi da nai foi. ");
INSERT INTO amk_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Kaiwasa bitoyao era na Yesusi arongfo tuti kurung fosa esahu eteyo, “Hosana! Fiai fuba we Dauti ne Kaisungnei. Moanafeai we Mano da na Sempaisi wonong ne! Hosana! Fiaifeai we Allai na katai dedai!” ");
INSERT INTO amk_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesusi suai to bendari Yerusalemi afui nanai, bendarifoi niukuayai paria na kaiwasafoi, etutang wawerasa we Yesusifo eteyo, “Inontarai mandoni dinini?” ");
INSERT INTO amk_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Kaiwasa bitoya foi eroa eteyo, “I mani, Yesusi, nabio na bendari Nazareti na nu Galilea foi dine.” ");
INSERT INTO amk_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ainanaya Yesusi suai to Allai ne Munufoi rofongfo tuti data kaiwasa mano etawayangfi tuti mano ewaworifi na nana fosa. Bebari ene mejao eriwang doi naya fo tuti kaderao mano etawayang muntung we korbani fosa eminohi naya fo. ");
INSERT INTO amk_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Tuti medu wesa deyo, “Na Allai ne Kaiwofo medu fieai, amani dotu tonina: ‘Nehu Mununei ahui we munuo wenadi nai,’ wape menariri wemunu mananapia.” ");
INSERT INTO amk_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Inontarai euremifafa tuti esoberahai fosa era wei to Sempaisi ne Munufoia, tuti niarisara ebeng. ");
INSERT INTO amk_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Wape imami baba fosa tuti mantaunau Kaiwo Musai soi fosa ewati kahai fitantuma Yesusi niari fo, kontai etaramio arikangfosa esahu na Sempaisi ne Munufoi eteyo, “Hosana! Fiaifeai we Dauti ne Kaisungne wau!” ampefe enemirorongfoi kerira Yesusi paria. ");
INSERT INTO amk_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ainanaya emadu wei eteyo, “Taramuo arikangnesa kaiwo emadurai nina e?” Yesusi yoa wesa deyo, “Yo, tarahuoa to! Wape mea mani, metatorai na Sengnei ne Kaiwofo kaharai e? Kaiwo dotu tono: ‘Na arikang eawemifang bararika fosa tuti arikang baba fosa, Wau moinenang fiaifo na eboromifo kawuru ampa.’” ");
INSERT INTO amk_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ainanaya Yesusi da werusa, da to munue Betania tuti dena na wanai. ");
INSERT INTO amk_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kamiai kutungfo Yesusi daraberahi to Yerusalemi aha, tuti na rang rorong fo wewisi. ");
INSERT INTO amk_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Kefang we rangfoi nanai deti ai urung rowei, ampefe da wa detioi, manamo aifoi webong kaha mae wereraung terai. Ampafe deikanggani aifoi deyo, “Aine wau, wiro webong ahang kahai we fitawafa.” Na tatofang kutu nanai kontaio aifoi reraung siamorang tuti memasara. ");
INSERT INTO amk_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Yesusi ne inontaraifosa epapuhing paria we ewati fi Yesusi niari nana fefe. Etutang wawerasa eteyo, “Todoni ai reraung siamorang tuti memasa sikerawa nanai?” ");
INSERT INTO amk_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesusi yoa wesa deyo, “Tarai, imadurai we mea mau yeyo, meroasoai tarai tuti menemirorong soriru kaha mani, fianai aino inari we ai urung fininai ambori menari kontai ki, tuti wiro nanai tera kaha, mae memadu we uai nini meteyo, ‘Tuwera weru katai nini tuti taukaha rawanang rausi!’ nana mani finanai kaririai. ");
INSERT INTO amk_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Meroasoa mani, fianai aino metutang weai na mewenadi we Allai fo, mesobuai ki.” ");
INSERT INTO amk_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Ainanaya Yesusi daraberahai to Allai ne Munufoi, amani suai awafui deunau na munu rofongfo. I doa deunau mae imami baba fosa tuti inontarai ewefoniai we Yahudi fosa era wei ma tuti etutani eteyo, “Na mandoni wonongne tuti ne mambiriune nari fi bitoya tonina fenina? Tuti mandoni dino yuai wau we nari fininaifa ne?” ");
INSERT INTO amk_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesusi yoa wesa deyo, “Yau kontai yutang bera mea we fieai, tuti finana meteisaharai we yau mani, ambori yeisaharai kontai we mea kariri na mandoni dino yuai yau we inari fininaifa ne ki. ");
INSERT INTO amk_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Meteisaharai we yau, weo Yohanesi mano webaptisi kaiwasa foi mani, mandoni dino yuaisi we webaptisi kaiwasa tonana ne? Allai ete inontarai nunei manei e?” Imami baba fosa tuti mano ewefoniai we Yahudi fosa emadu kaririai wawerasa eteyo, “Masino tateyo, ‘Allai dino yuaisi we niari finana ne,’ nana mani ambori dei we tata aha ma deyo, ‘Tonana mani, we fianie wiro meroaso Yohanesi kahai nina?’ ");
INSERT INTO amk_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Wape tateyo, ‘Inontarai batang manei andino yuaisi ne,’ nana mani tamatai kaiwasa bitoya foi we emamuna we tata ki, weo eroasoai we Yohanesi mani nabi manei dine fefe.” ");
INSERT INTO amk_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ampefe eroa we Yesusi eteyo, “Ameserawawerahai.” Ainanaya Yesusi medu wesa deyo, “Tonana mani yau kontai wiro yeikaririai we mea kaha weo mantei dino yuai yau we inari fi bitoya nini faini.” ");
INSERT INTO amk_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesusi medu deyo, “Menemitituai tofino: inontarai manei ne kaisung mandu. I da wa deisaharai we ne kaisung fuba foi deyo, ‘Kaisungne waune, rahida nini roa rufi na tone romi angguri foi.’ ");
INSERT INTO amk_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Arikangfoi yoa deyo, ‘Bereri, imarira,’ wape mayeai detua berahi paria we kaiwo medu we tamanai tonana fo tuti da wa yufi na romifoia. ");
INSERT INTO amk_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ainanaya wawafoi da we ne arikang fui foi aha medu wei deyo, ‘Kaisungne waune, rahida nini roa rufi na tone romi angguri foi.’ Arikang fui foi yoa we tamanai deyo, ‘Yo, Daie ira ki,’ wape wiro da kaha. ");
INSERT INTO amk_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Na arikangfo suru mantei dino dohong kariri tamang ne kaiwofo ne?” Eroa we Yesusi eteyo, “Mano fuba foi.” Ampefe Yesusi medu wesa deyo, “Tarai, imadurai we me mau yeyo, inontarai efanduhi pajaki we Kaisari tuti wiwing diru nesa ansaino esuai fafong to Allai ne Mananu rorong fo, mae mea mani bireri rai. ");
INSERT INTO amk_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Weo Yohanesi da ma we deinawiai we mea kariri rang mesi foi, tuti meroaso ne kaiwofo kaha. Wape mano efanduhi pajaki we Kaisari fosa tuti wiwing diru fosa eroasoi. Mewati tonanai ampa wape wiro metarabera mea weru mene sasariwai tuti meroasoi kaha.” ");
INSERT INTO amk_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesusi medu paria aha soirio fiyiwansoai bei siai aha, amani medu deyo, “Metaramio fiyiwansoai siai nini kontai. Wene kahofa manei, niari romi angguri bei, sanamia kiaia tuti yu worefoi wari romifoi sentenang. Kontai sirai kamirei we katai ehua anggurifoi nai tuti biaungno katai ne tarai toyari yawa dedai bei we ewaitawang wedua romi angguri foi nai. Mayeai sawing romifoi tono inontarai manea ewarami rorong fo, ambori anggurifoi wetarai mani, etato taraifoi maisa. Ainanaya mano ne romifoi dontai to nu siaia. ");
INSERT INTO amk_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tete rabuang bo romifoi wetarai fo, mano ne romifoi demi ne mangfata manea etontaia weo eha atorafo ria mano ewaitawang ne romi fosa. ");
INSERT INTO amk_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Manamo mano eru romifoi sa etafusa, eboi manei, emung manei, tuti esotati manei na kamiai. ");
INSERT INTO amk_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Mayeai mano ne romifoi demi nari ne mangfata manea aha, ea efau sewa mano fafong fosa, manamo mangfata nanisa kontaio eboisarao tafai kiasa, enari kangganisa toyarine. ");
INSERT INTO amk_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ainanaya mano ne romi foi demi ne kaisungfoi wesa, weo enetituai deyo, ‘Nehu kaisungnei mani, esomi wei rai.’ ");
INSERT INTO amk_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Manamo we eru romifoi sa ewati ne kaisungfoi we da ma fo nanai, emadu wawerasa eteyo, ‘Ne kaisung ambori sobu tamang fi minohi tutira fe andinini, ampafe tamunia mireha weruaia, ambori fianai aino tamang minohi tutira fo taha we tata.’ ");
INSERT INTO amk_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Etafuria tuti efafari to boriai weru romifoi awariai emuni nayai.” ");
INSERT INTO amk_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ainanaya Yesusi bera imami baba fosa tuti inontarai ewefoniai we Yahudi fosa aha deyo, “Tofino mano ne romi foi daraberahi ma mani fifiani aino dohonai we mano eru romifoi sa fo?” ");
INSERT INTO amk_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Eroa wei eteyo, “I ambori da ma tuti mingno inontaraio esaipaya nanisa weruai mae dohong romifoi we inontarai siai we eruti, amani mano tete rahida eteting angguri foi mani ambori etohong ne atorafo na mai weia fosa.” ");
INSERT INTO amk_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesusi medu wesa aha deyo, “Metato Sengnei ne Kaiwo arawang bo dotu tonina nei kaha rai e? Amani: ‘Kamieio mano enari munu nesa ehabioi fi, andi wekamiei reantenang we etang kamieifoi doa sauwi ampa. Sengnei andino niari finina, tuti fi mehikai paria na tauremine.’” ");
INSERT INTO amk_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yesusi medu nari aha deyo, “Ampafe yeisaharai we mea, weo Allai kia ne Mananufo weru mea tuti dohonai we kaiwasa siai esomi wei tuti etohong kariri ne dawiafo sa ki. ");
INSERT INTO amk_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Inontarai etawai na kamiei nani mani, eworu ki, tuti mantei dino kamiei nani sau kangguni mani ambori yoyaria wenukahai ki.” ");
INSERT INTO amk_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Imami baba fosa tuti Farisifosa etaramioai, ewaitawanai we Yesusi ne fiyiwansoaio medura fo reng wesa kariri todoni eteiayari we Mananu Mampariri foi fo. ");
INSERT INTO amk_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ampefe erurai we etafuri, manamo ematai we enari tonanai, weo ewaitawanai we kaiwasa bitoya foi eroasoai we Yesusi mani nabi dine. ");
INSERT INTO amk_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesusi medu we kaiwasa bitoya foi aha na fiyiwansoai bei, medu deyo, ");
INSERT INTO amk_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Allai ne Mananu rorong fo mani ne tarai toyari fiyiwansoai nini; Mananu manei niari muniara bei we dohonsua ne kaisungfoi weriraufo. ");
INSERT INTO amk_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Rahida bo muniarafoi ne diru neungfo we niariri fo, demi ne mangfatafosa era we mano wenotisara fosa we era to muniarafoia, manamo mano wenotisa fosa eteiaya mangfatafosa, we wiro era wa kaha. ");
INSERT INTO amk_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ainanaya mananufoi demi nari mangfata siai manea aha, tuti deyo ‘Meteisaharai we mano iwenotisa fosa weo, “Imainenang fiang we muniarafi ampa, amani sapi tuti sapi antung ebiriayai fesa imunsa ampa. Tuti fi siai imainenang mai ampa. Ampafe mera to muniara mandirau ne ma to.” ’ ");
INSERT INTO amk_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Wape mano wenotisa fosa wiro etantuma mangfatafo ene kaiwofo kaha, mae era we mansiawarai to ene fi eru foa, amani manei da to ne romifoi, manei siai aha da wa yufi siai. ");
INSERT INTO amk_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Tuti mano wei fosa etafu mangfatafosa enari kangganisa tuti emunsa. ");
INSERT INTO amk_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Mananufoi tarao finanane kesoua dang wawerahi paria ampefe denatu ne afai mamuna fosa we emung inontarai nanisa tuti enunung ene bendarifo. ");
INSERT INTO amk_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ainanaya sahu ne mangfatafosa, medu wesa deyo, ‘Muniarafi imainenami ampa, wape mano iwenotisa fosa emai we era to muniaranei ma kaha. ");
INSERT INTO amk_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ampafe mera kahairaia to rang fuba foi, weo mewenoti kaiwasa mandoni saino mesobusa na nana fosa ambori era to muniaranei ma.’ ");
INSERT INTO amk_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ampafe mangfatafosa era to rangfoia, eha inontarai esobusa na nana fosa to muniarafoia, amani inontarai eharira fosa tuti inontarai ebeng fosa. Ampefe munuo enari muniara nai foi sefang na kaiwasa wenotisa ma nanisa. ");
INSERT INTO amk_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Mayeai mananufoi da wafui we deti kaiwasafoi tuti deti inontarai manei sensung ansung mai we muniarafoi kaha. ");
INSERT INTO amk_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ainanaya dutang berahi deyo, ‘Maniwowire, todoni wonsung na ansung mai feai kaha, wape wuai to muniara mandiraufi mampui nina?’ Inontarai nani medu fiea kaha, nemboru terai. ");
INSERT INTO amk_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Mayeai mananufoi medu we ne mangfatafosa deyo, ‘Mewora inontarai nini aweng tuti warang, ambori mehabioi to boriai to katai mamantiti fo. Na wanai inontaraifosa ambori esobu ne karirafo tuti esaia etamirai paria.’ ” ");
INSERT INTO amk_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesusi kife ne kaiwo kariri fiyiwansoafoi deyo, “Inontarai wenotisa fosa efau, wape mano irisa fo mani efau turura kaha, tonanai kontai kaiwasa Allai wenotisa fosa bitoya, wape mano dirisa fosa bitoya kaha.” ");
INSERT INTO amk_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Mayeai inontarai eweFarisi fosa emadu ruhiai we todoni eweanggari Yesusi ambori medu sara kaiwofea. ");
INSERT INTO amk_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ainanaya etemi ene inontarai erariasa fosa manea tuti Herodesi ne inontarai manea era wa emadu we Yesusi eteyo, “Dai Mantaunaune waune, amewaitawanai we wau mani inontarai enemurorong mesi di wau tuti bounau ne wetaraifo kariri Seng Allai ne rangfo. Wiro tau funomai we kaiwo inontarai emadura fo kaha weo wiro womi we mano ewewonomi fosa kaha fefe. ");
INSERT INTO amk_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ampefe boisaharai we amea, kariri tane hukumifoi, mesi we tabai pajaki weo Mananu Kaisari ete bireri e?” ");
INSERT INTO amk_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Manamo Yesusi deitawang ene anggarifoi, ampefe medu deyo, “Inontarai menari fayafayarai di mea! We fianie meweanggari yau we metafu yau na nehu kaiwone nina? ");
INSERT INTO amk_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Yo, tonana mani meteinawiai we yau doi mebai pajaki nai wai.” Ainanaya etohong doi dinari bei wei, ");
INSERT INTO amk_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","tuti dutang berasa deyo, “Mandoni dino yabani na doi finina, tuti mandoni dino wonongfe watai nai ne?” ");
INSERT INTO amk_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Eroa wei eteyo, “Mananu Kaisari.” Yesusi medu wesa aha deyo, “Tonana mani metohonai we Mananu Kaisari fifiani aino Kaisari neng fo, tuti we Allai fifiani aino Allai neng fo.” ");
INSERT INTO amk_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Etarami Yesusi medu fenanai, epapuhing paria dohona mani era werui anina. ");
INSERT INTO amk_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Rahida nani kontai, inontarai maneiru teai na inontarai eweSaduki fosa era we Yesusia. Ea mani inontarai Yahudi saine, wape eroasoai we inontarai emarareha nesa wiro esuwi ahang kaha. Era wa weo etutang berahi, ");
INSERT INTO amk_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","eteyo, “Dai Mantaunaune waune, nabi Musai soi kaiwo ninai deyo, ‘Mang manei rirau wape sobu arikang kaharai mae mireha, nana mani ne tahatuifoi dau ne wiwingfoi aha, ambori dohong arikang we mano mireha nani ne ririafoi aha.’ ");
INSERT INTO amk_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ametaterai weo mambetahatui eweitu, mano fuba foi riraua, wape wiro une arikang kaharai mae mangfoi mireha weru wiwingfoia, ampafe mano suari foi dau ne wiwingfoi aha. ");
INSERT INTO amk_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ne tonanane, we ne tahatui mano suari foi, paria sobu mano fui pari foi kontai. ");
INSERT INTO amk_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ne fuiai pari fo wiwingfoi kontai mirehara. ");
INSERT INTO amk_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ampefe na rahida mansuwi-suwi foi mani, na mambetahatui eweitu nanisa, mantei dino wiwingfoi sahui we ne mang ne? Weo mambetahatui eweitu fosa erau wiwingfoi fefe.” ");
INSERT INTO amk_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesusi yoa wesa deyo, “Menemitituai sarawai paria, weo wiro metafu Sengnei ne Kaiwofo tuti meroaso ne mambiriufo kaha. ");
INSERT INTO amk_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Rahida bo mansuwi-suwi aha foi mani, kaiwasa wiro rirau ahang kaha, mae eminohi toyari wewai na Waidani. ");
INSERT INTO amk_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Wape kariri inontarai emarareha ne esuwi ahang fo mani, metato kaiwo Allai medura fo kahai e? Weo Allai deyo, ");
INSERT INTO amk_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Yau mani Allaio mene werengno Abrahami, Isaki tuti Yakupi esomi wei foi di Yau.’ Seng Allai nani mani wiro Seng we inontarai emarareha kaha, mae i mani Seng we inontarai etarang, tuti wiro inontarai emarareha fo saino esomi wei fo kaha, mae mano etarang fosa, ansaino esomi wei ne. Nanai deinawiai we Abrahami sitoru etarang aha na Waidani ampa.” ");
INSERT INTO amk_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kaiwasa bitoya foi pepuhing paria we etaramio Yesusi ne kaiwo aunau fo fefe. ");
INSERT INTO amk_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Farisifosa etaramioai we Yesusi ne kaiwofo wemambiriu paria dohona mani Sadukifosa emadu fiea ahang kaha, ampefe efanduhisa. ");
INSERT INTO amk_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Manei na ea, i mani mantaunau Kaiwo Musai soi fo manei dine, da wa dutang bera Yesusi, weo deo weanggariri fefe, ");
INSERT INTO amk_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","deyo, “Dai Mantaunaune waune, na Sempaisi ne Hukumine, kaiwo doni aino fuba sewa ne?” ");
INSERT INTO amk_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesusi yoa wei deyo, ");
INSERT INTO amk_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Kaiwo nana mani, kaiwo fuba na Hukumifoi tuti kaiwo reantenang foi dinani. ");
INSERT INTO amk_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Tuti hukumi boru foi mesi kariri nanai amani: ");
INSERT INTO amk_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Kaiwo fuba Musai soi fo tuti nabifosa esoi fo, weneung na hukumi boru ninai.” ");
INSERT INTO amk_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Inontarai eweFarisi fosa efanduhisa na nanai ampefe Yesusi dutang berasa deyo, ");
INSERT INTO amk_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Menemitituai fiani kariri Mananu Mampariri foi ne? Na mea mani, i weriria na mandoni?” Eroa eteyo, “I mani Dauti ne Kaisung dine.” ");
INSERT INTO amk_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Yesusi deyo, “Tonana mani, todoni Dauti mantauni, rahida bo Allai sensoni na Nuaninu Mirarebana foi, sahui we ne Seng nina? Weo deyo, ");
INSERT INTO amk_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Seng Allai nei medu we nehu Sengnei deyo, “Munohi na warahu domoya nei, pariao iwedaya nemu aitetanesa taha tawangsa kiai na awemuwai.” ’ ");
INSERT INTO amk_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ampafe Dauti mantauni sahu Mananu Mampariri foi we ne Sengfoi tonana mani, todonie i mani weriria terai na Dauti ma nina? Mae nanai deinawiai we Sengno Mamparirifoi dedai sewa Mananu Dauti tuti ne riria fo terai.” ");
INSERT INTO amk_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Wiro manei wemambiriu we yoa wei ahang kahai. Tuti nano rahida nani kontai inontarai ewearira we etutang Yesusi we fieai ahang kaha. ");
INSERT INTO amk_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ainanaya Yesusi medu we kaiwasa bitoya foi tuti we ne inontarai ewesuraya mandu fosa deyo, ");
INSERT INTO amk_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Mantaunau Kaiwo Musai soi fosa tuti Farisifosa esobu mambiriu we eteisaha Kaiwo Musai soi fo. ");
INSERT INTO amk_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ampafe kaiwo etaunauwai kariri Kaiwo Musai soi fo nanai, metaramioai tuti metohong kaririai na mai, wape wiro metohong kariri ene etohong toa fo fanai. Weo etaunau kariri kaiwofo, wape mantaunsa wiro etohong kariria kaha. ");
INSERT INTO amk_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Kaiwo dadira tuti maraba fo etohonai we inontarai siai, eteyo nari wani, nari nini fanai, etemisa we esoduatai ete we etohong kaririai, wape mantaunsa wiro ewaramiai inontarai nanisa kuteai we etohong kariria kaha. ");
INSERT INTO amk_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Fi kiai enari fo, enari we ambori inontarai siai ewatisa terai we ea mani inontarai eroasoai disa. Ehase kotakio soi Kaiwo Sengfo na erewomifo tuti na ewarami raongfo, kontai enari ireu abirarung fo tiawai na ansung boriei etatara fo, we deinawiai we ea mani inontarai efabai disa. ");
INSERT INTO amk_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ea kontai efaraise we na muniara bei mani, era wa eminohi na kadera we mano wenotisa to muniarafoi na fong pari fo, tuti na munu agama Yahudi fo mani esera we eminohi pari na kadera watai na fong pari fe fo. ");
INSERT INTO amk_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Eparaise paria we na kaiwasa bitoya foi, toyari na kondirorafoi, kaiwasa esomi wesa nayai tuti esahusa we ‘Rabi ete Mantaunau’. ");
INSERT INTO amk_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Wape mea mani dohonao merurai we inontarai esomi we mea tuti esahu mea we ‘Mantaunau’ fanai. Weo mene Mantaunau mansiari kawuru tuti mea kiai mesahu mea we doroi. ");
INSERT INTO amk_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Tuti wiro mesahu inontarai mandoni kontai na nuneisa na wang ‘Dai’ fanai, weo mansiari terai andino we mene Dai ne, amani Dai na rorafaisi. ");
INSERT INTO amk_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Tuti wiro inontarai manea esahu mea we meweNunggamiei fe, weo inontarai mansiari andino wenunggamiei we mea ne, amani Mananu Mampariri nei. ");
INSERT INTO amk_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Inontarai mandoni dino fiabai we mea mani todoni kontai wemangfata we mea wa. ");
INSERT INTO amk_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Mandoni dino yuai ne taraifoia weinontarai dedai mani, Allai ambori niariria tewawa ki, tuti mandoni dino niariria enerorong tewawa mani, ambori Allai yuaisia dedai ki. ");
INSERT INTO amk_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Mantaunau Hukumi Musai soi wa mea tuti Farisiwa mea, mesodai ne karira pari fo rai. Mea kiai mani inontarai menari fayafayara di mea, weo mekafe rahutu Allai ne Mananu Rorong foi ambori inontarai esuai nai fanai. Mantaung mea wiro mesuai afui kaha, mae metaba wedua inontaraio ete esuayai to Sempaisi ne Mananu rorong fo afui fosa kontai.  ");
INSERT INTO amk_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Mantaunau Hukumi Musai soi wa mea tuti Farisiwa mea, mesodai ne karira pari fo rai. Mea kiai mani inontarai menari fayafayara di mea, weo mepampamu wiwinafosa meha ene ra eminohi tutira fo. Tuti mewenadi mani mene nadifoi dewariroi, mesera we ambori kaiwasa bitoya fosa etato mea. Ampafe todoni kontaio mesodai aiboi maraba sewa fo rai. ");
INSERT INTO amk_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Mantaunau Hukumi Musai soi wa mea tuti Farisiwa mea, mesodai ne karira pari fo rai. Mea kiai mani inontarai menari fayafayara di mea, weo metafai wari rawanang rausi, tuti mera na rei, to katai bodoni kontai, we menari inontarai mansiari kawuru somi we Allai kariri mene metawiawa. Wape inontarai nani, metaunauwi we da ria mea na mai, pariao niari karirafo pari sewa mene menariwa, ambori sodai ne karirafo fuba sewa weru mea aha na Soroha rorong foi. ");
INSERT INTO amk_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Mano meuremifafao mewiwiang inontarai siai wa mea, mesodai ne karira pari fo rai. Weo metaunau meteyo, ‘Masino manei fefora na Sempaisi ne Munufoi mani, ne fefora nanai wiro wefiea kaha, wape fefora na fio emasio na Sempaisi ne Munufoi mani, ne feforafo todoni kontaio weworahi rai.’ ");
INSERT INTO amk_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Mano mewebonggoi tuti meuremifafa ne meaine! Fiani dino dedai sewa ne, emasifo ete Sempaisi ne Munuo wedaya emasi nani mirarebana foi e? ");
INSERT INTO amk_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Tuti metaunau inontarai kontai meteyo, ‘Manei fefora na Mesbao nunung korbani nai foi mani, wiro ne fefora nani wefiea kaha, wape fefora na korbanio ohonai we Sempaisi fo mani, ne fefora nani todoni kontaio weworahi.’ ");
INSERT INTO amk_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Inontarai meuremifafa wa meaine, finai aino dadai sewa ne, korbanifo ete mesbao wedaya korbanifoi mirarebana foi e? ");
INSERT INTO amk_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ampefe mandoni dino fefora na mesbafoi mani, i fefora na mesbafoi tuti fianai aino watai nai fo. ");
INSERT INTO amk_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Tuti mandoni dino fefora na Munu Seng foi mani, i fefora we Munu Seng foi tuti Mano niai nai foi. ");
INSERT INTO amk_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kontai mandoni fefora na rorafaisi, nana mani fefora na Allai ne kadera mananu minohi nai foi tuti na Mano minohi nai nani, amani Allai mantauni wonongfo. ");
INSERT INTO amk_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Mantaunau Hukumi Musai soi wa mea tuti Farisiwa mea, mesodai ne karira pari fo rai. Mea kiai mani inontarai menari fayafayara di mea, weo metohong kariri fi katui fo, wape fi fuba fo wiro metohong kariria kaha. Toyari finunsai burayang fo tuti fi we indawang fi naya fo, metohonai we Sempaisi ne perpuluhanfo, mai kariri mene koangfoi. Wape fi fuba fo kiai memarira we metohong kaririai tonana, amani wiro mehutu kaiwo na mesi kaha, mearomio inontarai kaha, tuti metohong kariri fi memadura fo pampang kaha. Ne beng pari fo mani, metohong kariri fi fuba ninai mae merurai we menari ne katuifo kontai. ");
INSERT INTO amk_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Mano meuremifafao mewiwiaing inontarai siai wa mea, na merurai we metohong kariri fi katui mae memarira we menari ne mai sewa fo mani, ne tarai kariri mewati borarafui manei na mene merehawa ambori mehabioi, wape unta fiabai manei metoni funomai. Nana mani merurai we metohong kariri fi katui na Sempaisi ne Hukumifoi, wape ne fubao todoni kontaio ohong kariria fo wiro metohong kariria kaha. ");
INSERT INTO amk_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Mantaunau Hukumi Musai soi wa mea tuti Farisiwa mea, mesodai ne karira pari fo rai. Mea kiai mani inontarai menari fayafayara di mea, weo mene nofi metunung naya wa tuti rewangguai metampi naya wa, meruai borieiwara mararebanai, wape ne rorongfo mani sefang na fi mai kaha fo, amani meuremi fiabai we ra paria tuti metenanggoing funomai. ");
INSERT INTO amk_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farisi meuremifafa ne mea! Reantanang mani meruai rurang nofi rorong wa tuti rewangguai rorongwa akawuru wo, ambori ne boriaiwa mararebanai kontai ki! ");
INSERT INTO amk_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Mantaunau Hukumi Musai soi wa mea tuti Farisiwa mea, mesodai ne karira pari fo rai. Mea kiai mani inontarai menari fayafayara di mea, weo mene tarai toyari fafo keri na ke bua ampefe boriaiwa bua karofaria mahikai wape ne rorongwausi sefang na inontarai eneina tuti ne piraro bitoya nai. ");
INSERT INTO amk_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Na tonanane kontai na mene tarai boriei wai mani, wati mea weinontarai menari ne wetaraifo di mea, wape na menemirorongwai mani, inontarai menari fayafayarai tuti meharira paria di mea. ");
INSERT INTO amk_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Mantaunau Hukumi Musai soi wa mea tuti Farisiwa mea, mesodai ne karira pari fo rai. Mea kiai mani inontarai menari fayafayara di mea, weo menari nabio na fafongfa emunsa fosa tuti inontarai enemirorong masi wei fosa kontai ene fafofo, menaria mahikai, ");
INSERT INTO amk_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","tuti memadu meteyo, ‘Masino, rabuang bonanai ameaino, toyari amene werengfosa, nana mani wiro amemung nabifosa kaha rai.’ ");
INSERT INTO amk_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Mae fi menari wa deinawiai we mea mani meweriria na inontarai emung nabi fafong fasa. Ampafe na kaiwo memadurai tonanafo meteinawiaia kasau ampa, weo mea kontai meweriria na mene werengno emung nabi tonana fosa, amani mea kontai mehontai na memung nabi fafongfa sa, weo meweriria na mene wereng nanisa ma fefe. ");
INSERT INTO amk_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Tonana mani, sasari ne seao mene werengfosao enari kaha fo, metohong kaririai to, pariao mai kaririaia. ");
INSERT INTO amk_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Inontaraio mewarami aipaya di mea, mene tarai toyari tawai memuna! Inontarai meharira toyari fefa. Todoni meteyo mekaharai weru aiboi ambori mesodairi na Soroha rorong foi ki? ");
INSERT INTO amk_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Yau ambori yemi nehu nabifo manea, inontarai esawai na Sempaisi ne Kaiwofo sa, tuti mantaunau Kaiwo Mahikai fosa we mea ma rai. Tuti inontarai nanisa, ambori manea memunsa tuti mepahusa na aitabafo, manea kontai merarubasa na munu agama Yahudi fo na wai weababo fo, tuti menumiaisa na bendari bei to bei we menari kangganisa. ");
INSERT INTO amk_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Na tonanafo ambori mesuang inontarai emasio etohong sarawa kaha fosa ene rika fuba tibata nano nunei tibaurai ma fo, wereantenang na Habel inontarai enerorong mesi foi, paria sobu Zakariai, Berekyai ne kaisungfoi, mano memuni na Sempaisi ne Munufoi, amani na Rorong Mirarebana foi tuti mesbafoi ne katai ruhi fo. Mano enemirorong mesio emarareha na mewaramiwa tuti na mene werengfosa ewaramifo fosa kiai, na reantenangfo pariao ninaifa ne mani, ene rikafo tau we mea. ");
INSERT INTO amk_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Tarai, imadurai we mea mau yeyo, finana kai inontarai fuinini mea mesoduati kiai rai.” ");
INSERT INTO amk_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Yerusaleme! Yerusalemi wo! Nabifosa kiai memunsa! Inontarai Sempaisi demisa era we mea ma fosa, meru kamieio sara emarareha. Webeiru teai mauwa yohong weai paria we ikaruhi mea kiai we yewawu mea, toyari manggohei inangfoi we tebung wedua ne arikangfosa na warapemafo suru, manamo memaya kaha tuti meteiaya yau. ");
INSERT INTO amk_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Mewati! Mene Munu Seng nei wiatai wewui ki, Allai wiro weriria mea ahang kaha. ");
INSERT INTO amk_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Weo yeisaharai we mea mau, na kutu ninai wiro mewati yau ahang kaha pariao memadu meteyo, ‘Moanafeai we mano ro na Sengnei wonongne wau.’ ” ");
INSERT INTO amk_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesusi da weru Sempaisi ne Munufoi mae ne inontarai erariati fosa era weia tuti emadu riati kariri Munu Seng foi ne mehikaifo. ");
INSERT INTO amk_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Manamo Yesusi medu wesa deyo, “Mewati Munufoi we mehikai paria ne ne? Tarai, imadurai we mea mau yeyo; Munu Sengno menemikandori wani ambori inontarai manea emeiria misuhi kiai, kamiei boyari kontaio wiro doa na ne katai doa nai foi ahang kahai ki.” ");
INSERT INTO amk_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Ainanaya da to wiwoi Saituni, da wa suki aweu minohi nanai, ne inontarai erariati fosa titousa eraoia emadu riati na mantaunsa eteyo, “Boikaririafa we amea, kidoni wori fi antanafa modurai nanai kawariai ki, tuti fiainawiai fianai aino kawariai we amewaitawanai kariri rahida barabera wau nai aha ma foi tuti rahida nunei werea naya fo ne?” ");
INSERT INTO amk_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesusi yoa wesa deyo, “Metanansiau weduarai ambori dohona inontarai etatofa mea fe. ");
INSERT INTO amk_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Weo inontarai bitoya ambori era ma eteyo emadu we mea na wonohune tuti eteyo, ‘Mananu Mampariri metamang wei nei di yau.’ Tuti na kaiwo emadurai tonanane etatofa kaiwasa bitoya kontai. ");
INSERT INTO amk_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kontai ambori metarami mamunafei, tuti kaiwasa emamuna wawerasa, wape dohonao mematai fanai. Ne tonanane todoni kontaio kawaria akawuru wo. Wape nanai wiro deinawiai we nunei werea nayai finana kaha. ");
INSERT INTO amk_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tonanai kontai parentafei ambori memuna we parentafei ki, tuti mananu manei ambori memuna we mananu siai manei ki. Na doni kontai ambori mundiei beba foi fio nai ki, tuti kaharifoi miung ki. ");
INSERT INTO amk_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ne nani kiai arahio fi reantenang finanai, ne tarai toyario wiwinsanaio amaina pirahai tantuma we dawing. ");
INSERT INTO amk_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Na rabuang bonani, inontarai eharira fosa etafu mea etohong mea tono inontarai ewarami rorong fo ambori enari kanggani mea tuti emung mea, tuti kaiwasa na nunei sentenang enemirireu mea weo mea mani inontarai meraria yau di mea fefe. ");
INSERT INTO amk_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Rabuang bo sonana nei mani inontarai bitoya eroaso yau ahang kaha mae ehurumitare yau tuti inontarai etawayang wawerasa, kontaio enemirireu wawerasa. ");
INSERT INTO amk_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Nabi tarai kaha bitoya ambori ehawariai ki, tuti etatofa kaiwasa bitoya. ");
INSERT INTO amk_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Inontarai enari ne karirafo bitoya sewa aha, wedaya kaiwasa bitoya wiro enemiwawusa ahang kaha. ");
INSERT INTO amk_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Wape mandoni dino doaria mutu paria sobu werea naya fo mani ambori sobu faririfo ki. ");
INSERT INTO amk_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Tuti Kaiwo Mahikai kariri Allai ne weMananufo, todoni kontaio wuwuai wari nunei sentenang, ambori kaiwasa na doni konta foi taraoai. Nanaia mani, nunei da wa sobu werea naya foa finanai.” ");
INSERT INTO amk_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ampafe rahida bo mewati mano kerira pari tuti wedaya ne karira pari fo foi, amani mano fafongfa nabi Danieli medu fafong kariria fo, mewatioi doa na Rorong Mirarebana pari foi na Munu Seng foi mani, amani kataio mesi we doa nai kaha foi, (kaiwo nani todoni kontai mano metatorai nini wa mea metafurai), ");
INSERT INTO amk_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","rabuang bonanai mani, inontarai enayai na Yudea fosa todoni kontaio ewawu ahera, emito to katai weuai fo we etadiwa nayai. ");
INSERT INTO amk_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Mano tete rabuang bonani niayai na ne munu refongfo wiro da wafui we kia fieai na munu rorongfo fanai. ");
INSERT INTO amk_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Mano niayai na romifoi, dohonao daraberahi to ne munufoi we kia fieai kontai fe. ");
INSERT INTO amk_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Rahida nana fo, rahida karira paria we wiwinsanaifosa tuti wiwingno etinsui ui, weo nana mani ewawu ahera kaha. ");
INSERT INTO amk_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Mewenadi we dohonao mewawu tete danunang rorong fo ete rahida Sabati fanai. ");
INSERT INTO amk_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Weo na rabuang bonani, dadirao ming kaiwasafoi nani, ne dadira fuba pari fine wiro kawariai na wea kaharai, na rahida reantenang nunei tibaura fo paria sobu ninai, tuti wiro kawariai na eai ahang kaha. ");
INSERT INTO amk_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Masino rahida nanai Allai fioukiraia tanang kaha mani, mansiari kontaio wiro kiaharai weru karira nana kaha. Wape Allai enetituai we ne inontarai dirisa fosa, wedaya fiouki rahida nanaia tanang. ");
INSERT INTO amk_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Rabuang bonani manei medu we mea deyo, ‘Mewati! Mananu Mampariri fi andinini!’ ete ‘Mewatia-andiwani!’ dohonao meroasoa fe. ");
INSERT INTO amk_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Weo mampariri tarai kaha fosa tuti nabi tarai kaha fosa ambori ehawariai ki. Ea ambori enari fi fuba bitoya paria tuti fitantuma bitoya we enari we etatofa mano Allai dirisa fosa kontai, masino ebiriu we enarisa tonanai. ");
INSERT INTO amk_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ampefe mearomioaifa, finanai kai wiro kawaria kaharai mae, yeikaririai kawuru we mea kai ampa, ambori metawa fanai. ");
INSERT INTO amk_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Ampefe inontaraifosa emadu mani eteyo, ‘Mewatia da ma niayai na katai minano tuti wekamamiaife fo,’ nana mani mera wa fanai, ete emadu eteyo, ‘Mewatioi na mununei, i niayai na rorong bo rorong pari fuisi,’ wiro meroasoa fanai. ");
INSERT INTO amk_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Weo Kaisung Inontarai nei ne da ma fo mani ne tarai toyari kaiwewa keiwewa na rorafaisi, ne sambewarafoi sambewarai na do wanang murang foi mani paria sobu do wanangfui foi. ");
INSERT INTO amk_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Fi mireha piro fei wiatai na doni mani, atio korowei esifo etari katai nani. Toyari nanai kontai, rahida ira nai aha ma foi mani, ati pari ki, wiro yediwa yau kaha.” ");
INSERT INTO amk_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Rabuang bo dadira fuba pari fo kiai mani, na tatofang kutu nanai kontai, ‘Wofaisi ambori memantiti ki, tuti embaifaisi sambewarai ahang kahai ki, awahafaisi ambori tiafating na rorafaisi tuti sawai ki, tuti fi wemambiriu na rorafaisi ambori dari babiaini ki.’ ");
INSERT INTO amk_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ainanaya fiainawiai kariri Kaisung Inontarai fo dariai na rorafaisi. Kaiwasa na nunei sentenang ematai esai etaidu, we Kaisung Inontarai nei ambori watioi we da na kafafefo na rorafaisi meu, ne tapapafo fuba paria tuti ne sambewaraio dadai fo fiabai. ");
INSERT INTO amk_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Tuti songgeri fuba foi dotu, ambori Kaisung Inontarai foi demi ne wewaifosa we efanduhi ne kaiwasa diriri foi na do wanang murang foi paria sobu do wanangfui foi, tuti na do wanangsai foi paria sobu do wanamba foi, kontai na rorafaisi reafea pari sobu reafeai.” ");
INSERT INTO amk_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Mesobu aunau na ai urung nei neo fiyiwansoanei, wati to aifoi we wedahamia kai, rerorifoi kiawariai aha mani, nana mani waitawanai we katu wori wemunudang ki. ");
INSERT INTO amk_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Tonanai kontai we mewatio finani kiai kawariai mani, mewaitawanai kontai we rahidafo kefang ampa. ");
INSERT INTO amk_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Tarai, imadurai we mea mau yeyo, inontarai na rabuang boninisa wiro emarareharao ehai kaharai mae finanai kawariai kawurua. ");
INSERT INTO amk_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Rorafaisi tuti nunei niai rai, wape nehu Kaiwone watai wenumainu.” ");
INSERT INTO amk_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Tonanai ki, wape kariri rahida tuti araha ureng beiru Kaisung Inontarai nei da nai ma fo, mandoni kontai deitawana kaha. Wewai na rorafaisa kontai ewaitawana kaha, Kaisung Inontarai nei kontai deitawana kaha, mae Dai mesiri andino deitawana ne. ");
INSERT INTO amk_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Rahida bo Kaisung Inontarai nei da nai ma foi mani ne tarai toyari na rabuang bo Noaki na fafong nanai. ");
INSERT INTO amk_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Weo rabuang bonani foafoi dautai kaharai mae kaiwasafosa etampi tuti etunung tuti erirau, tonanai paria sobu rahida bo Noaki suai to ne wa fiabai rorong fo, ");
INSERT INTO amk_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","tuti ewaitawang fianai aino ambori kawariafo kaha, paria foa fiabai foi dautai su foisa fo. Tonanai kontai we na rahida Kaisung Inontarai nei da nai ma fo. ");
INSERT INTO amk_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Na rahida da nai ma foi nani mani, mang mandu unaya urohong romi mani kia manei tuti manei niayai. ");
INSERT INTO amk_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Wiwing mandu utara ruhiai na anawahi bei, kia manei mae manei bereri. ");
INSERT INTO amk_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ampefe metanansiau, weo wiro mewaitawang rahida bo mene Sengnei da nai ma fo kaha rai. ");
INSERT INTO amk_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Mearomi finina, masino mano ne munufoi deitawanai we diru araha ureng beiru mani mananapifoi da ma we kiamanana ne fi minohi tutira fo mani, todoni kontai wiro dena kaha mae detawang weduara rai, wiro sua mananapifoi suai to ne munufoi rorongfo kaha. ");
INSERT INTO amk_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Tonanaifa, mea kontai memainenang metamang pampang, we Kaisung Inontarai nei da tantuma na rahida bo mewaitawana kaha foi ma ki.” ");
INSERT INTO amk_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Mandoni dino wemangfata mesi tuti sewai ne? Mandoni dino wemangfatao dohong kariri ne mambaisengfoi ne kaiwofo na mai, na rahida yuaisi wenunggamiai we mangfata mano wei fosa, ambori dohong fiang wesa na rahida neungfo ne? ");
INSERT INTO amk_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Denteng paria we mangfatao niari kariri ne mambaisengfoi ne kaiwofo na mai, ambori rahida mambaisengfoi daraberahi ma mani, sobu ne mangfatafoi we dohong kariri kaiwo demi wea fo. ");
INSERT INTO amk_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Tarai, imadurai we mea mau yeyo, mambaisengfoi ambori yuaisi wenungkamiai we ne fianggeng minohi tutira fo kai ki. ");
INSERT INTO amk_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Wape tarahai mangfatafoi kerira tuti enetituaitai na enerorongfoi deyo, ‘Nehu mambaisengfoi niaya waroi paria wiro daraberahi ahera ma kaha rai,’ ");
INSERT INTO amk_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ainanaya bioi mangfata mano siai fosa tuti dampi tuti dunung ria inontarai emayeru fosa. ");
INSERT INTO amk_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Mayeai mambaisengfoi daraberahi na rahida tuti araha ureng bo mananaioi foi, amani mangfatafoi wiro deitawana kaha foi. ");
INSERT INTO amk_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ampefe mambaisengfoi ambori miuni amani ferangkahutu mangfata kerira nani tuti soari tono katai inontarai enari fayafayara fosa ewatai nai fo. Na wanai ambori esodai ne karirafo tuti esaia etamirai paria ki.” ");
INSERT INTO amk_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Kaisung Inontarai nei rahida bo yarabera yau we iweMananu nai ma foi mani ne tarai toyari fiyiwansoai nini ki: kadawing ewesura emainenang ene oborifo, ambori era wa we etamang we mandiraufoi. ");
INSERT INTO amk_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Kadawing nanisa ewering ewebonggoi tuti ewering esawai. ");
INSERT INTO amk_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Kadawing ewebonggoi fosa eha ene oborifo, wape eha pari maning siai. ");
INSERT INTO amk_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Mae kadawing esawai fosa eha ene oborifo tuti emainenang ene maningfeai kontai. ");
INSERT INTO amk_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Mandiraufoi da ahera ma kaha, ampefe kadawing ewesura fo euremimamong ainanaya etenawa. ");
INSERT INTO amk_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Diru rabuangna mani inontarai manei sahu deyo, ‘Mandiraufi da ma to! Mera ma tatamang wei.’ ");
INSERT INTO amk_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Kadawing ewesura fosa etoa barisa, ehai ene oborifo. ");
INSERT INTO amk_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Kadawing ewebonggoi fosa emadu we mano esawai fosa eteyo, ‘Metohong maningfeai we amea, weo amene oborine deo fafe fefe.’ ");
INSERT INTO amk_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Kadawing esawai fosa eteyo, ‘Bireri, weo amene maningne demoyarai we ametatorai we mea konta kaha, ampefe mera wa mewori na mano dewayang maning foi.’ ");
INSERT INTO amk_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ainanaya kadawing ewebonggoi fosa era wa we ewori maningfo nanai, mandiraufoi sobu kataifoia. Kadawing emainenang fosa esuai ria mandiraufoi to katai muniara foi tuti ehafe rahutufoia. ");
INSERT INTO amk_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Waroi ahang kaha mae kadawing wei fosa era ma esahu eteyo, ‘Daie, Daine waune, fai rahutunei we amea!’ ");
INSERT INTO amk_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Manamo mandiraufoi yoa wesa deyo, ‘Yeroanso mea kaha.’ ” ");
INSERT INTO amk_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesusi medu kariri fiyiwansoaifoi awa kiai mani deyo, “Tonanaifa ampefe metanansiau, weo wiro mewaitawang rahida bodoni ete araha ureng beiru fo kaha.” ");
INSERT INTO amk_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Kaisung Inontarai nei rahida bo yarabera yau we iweMananu nai ma foi mani ne tarai toyari fiyiwansoai nini kontai. Amani mang manei de dontai to nu waroi. Donta kaharai mae sahu ruhi ne mangfatafosa, mayeai deto ne doi minohi tutira fo wesa we etawayang nayai we esera we ne faufea. ");
INSERT INTO amk_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Inontaraifoi dohonai we ne mangfatafosa kariri ene mambiriufo. Dohonai we manei doi emasi aderi ring sefang, manei aha mani dohongno doi emasi aderi boru sefang, tuti manei aha mani dohongno doi emasi aderi boyari sefang, ainanaya dontai to nu waroia. ");
INSERT INTO amk_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Mangfata mano sobu doi emasi aderi ring fo kia doifoia dewayangna mani, sobu doi emasi aderi ring nari aha. ");
INSERT INTO amk_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Tonanai kontai mangfata mano sobu doi emasi aderi boru fo dewayangna doifoia mani sobu doi emasi aderi boru kontai aha. ");
INSERT INTO amk_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Wape mangfata mano sobu doi emasi aderi boyari foi da wa sirai kamirei bei, ambori dediwa doifoi nayai. ");
INSERT INTO amk_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Waroi paria mayeai mambaisengfoi daraberahi aha ma, tuti dutang ne mangfatafo sitoru we ne doi yoaso sitoru we itorurai nai fo. ");
INSERT INTO amk_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Mangfata mano sobu doi emasi aderi ring fo kia ne doi emasi aderi sura fo da wafui tuti medu we ne mambaisengfoi deyo, ‘Mambaisengne wau, doi emasi aderi ring roaso yau yewayang naya fe ainina, boti ma, isobu doi emasi aderi ring aha.’ ");
INSERT INTO amk_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Mambaisengfoi medu wei deyo, ‘Mahikai paria! Wau mani mangfata mosi di wau, weo bohong kariri nehu yawiane na mai. Anta iroaso wau na fi katui tuti nariri na mai, ampafe ninaia mani yohong fi fuba feai we wau we rufi nai aha ki. Ro mampui naya puraise ria nemu mambaisengne yau.’ ");
INSERT INTO amk_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ainanaya mangfata mano sobu doi emasi aderi boru foi da naria aha fui tuti medu we mambaisengfoi deyo, ‘Mambaisengne wau, doi emasi aderi boru roaso yau we yewayang naya fe ainina, boti ma, yewayanaia mani isobu boru aha.’ ");
INSERT INTO amk_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Mambaisengfoi deyo, ‘Mahikai paria! Wau mani mangfata mosi di wau, weo bohong kariri nehu yawiane na mai. Anta iroaso wau na fi katui tuti nariri na mai, ampafe ninaia mani yohong fi fuba feai we wau we rufi nai aha ki. Ro mampui naya puraise ria nemu mambaisengne yau.’ ");
INSERT INTO amk_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ainanaya mangfata mano sobu doi emasi aderi boyari foi da naria aha fui medu deyo, ‘Mambaisengne wau, yeitawanai weo wau mani inontarai nemu kaiwo tapapa di wau, wau mani boting aibongfo mae tanami kaha, tuti ka fi na katai wiro rurai nai kaha. ");
INSERT INTO amk_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nana mani, imatai, ampefe ira wa isarai kamirei ambori yediwa nemu doine wa nayai. Ampafe boti ma, nemu doifi dinini.’ ");
INSERT INTO amk_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Mambaisengfoi medu wei deyo, ‘Wau mani mangfata korira tuti uremu marira we rufi di wau. Todoni e, boitawanai weo yau wiro yeting aibong mae itanang kaha tuti ika fi na katai wiro irurai naya fo kaha. ");
INSERT INTO amk_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Tonana mani todoni kontai ka doiwaia wia na bangki ambori dawing nayai, ambori yarabera yau tonina mani ika tamu antungfo.’ ");
INSERT INTO amk_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Mayeai mambaisengfoi medu we mangfata siai fosa aha deyo, ‘Ka doifo werui tuti bohonai we mangfata mano ne doi emasi aderi sura foi. ");
INSERT INTO amk_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Weo mano sobuai kawurua foi ambori sobuai fuba aha ki, ampafe nengfo fuba aha, wape mano sobu kuteai manamo niari kaririai kaha foi ne kutu nayai nai fo kontai ambori tafating werui ki. ");
INSERT INTO amk_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Tuti mangfata mano kerira tonananei mani, mehabioi to boriai to katai memantiti foi. Na wanai ambori sodai ne karirafo tuti saia damirai paria.’ ” ");
INSERT INTO amk_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Rahida bo Kaisung Inontarai nei daraberahi na ne sambewaraio dadai fo ma we weMananu foi tuti ne wewaifoi kiai era tutiri ma fo, I ambori minohi na kadera mananu foi na sambewaraio dadai na rorafaisi ki. ");
INSERT INTO amk_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Amani kaiwasa na nunei sentenang fianduhi na arongreafo, tuti ambori detosa we rabuang boru, kariri inontarai dehung fiahung foi we deto dombafosa weru kambingfosa. ");
INSERT INTO amk_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Dohong dombafosa, amani inontarai emararebanai fosa, enai na eneung domoya foi, tuti kambingfosa, amani inontarai eharira fosa, na eneung dowei foi. ");
INSERT INTO amk_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ainanaya Mananufoi medu we inontarai eminohi na eneung domoya fosa deyo, ‘Mano nehu Dai mioang mea ne mea, mera ma, mesuai to Mananu rorong meinenang we mea na nufi tibau nai foi ma foi. ");
INSERT INTO amk_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Weo rahida bo iwawisi foi metohong fiang we yau, tuti arohutataha mani, metohong mereha yunung, ira weinontarai aisei mau mani metohong katai we yau na mene munu rorong wai, ");
INSERT INTO amk_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","nehu pari ansung mani, mesansung yau, imaninang mani mefata yau, inai na aitamu rorong fo mani metuambawa yau.’ ");
INSERT INTO amk_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ainanaya inontarai enemirorong mesi fosa eroa eteyo, ‘Sengne waune, rahida bodoni amewati wau wowisi tuti ametohong fiang we wau, ete aromutataha ampefe ametohong mereha we bunung ne? ");
INSERT INTO amk_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Rahida bodoni amewati wau weinontarai aisei, ampefe ametamang we wau ametohong katai we wau ne? Rahida bodoni amewati wau nemu pari ansung tuti amesansung wau ne? ");
INSERT INTO amk_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Rahida bodoni amewati wau moninang ete wa na aitamu rorong ampefe amefata wau tuti ametuambawa wau ne?’ ");
INSERT INTO amk_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Mananufoi yoa wesa deyo, ‘Tarai, imadurai we mea mau yeyo, fianai aino menari we nehu doroio ne fiea kahai arorawa foi mani, menari we yau kontai.’ ");
INSERT INTO amk_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ainanaya Mananufoi medu we inontarai mano dowei fosa, deyo, ‘Mera weru urehureane weo Allai fefora mea ampa, ampefe mea mesuai to Adia danggararu we fitawafa foi, amani katai Allai meinenami weo Saminsenifoi tuti ne wewaifosa nai foi. ");
INSERT INTO amk_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Weo rahida bo iwawisi foi metohong fiang we yau kaha, tuti rahida bo arohutataha foi wiro metohong mereha we yunung kaha. ");
INSERT INTO amk_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Iweinontarai aisei mae metamang we yau kaha, nehu pari ansung mani wiro mesansung yau kaha. Imaninang tuti inai na aitamu rorong foi mani, wiro mefata yau kaha.’ ");
INSERT INTO amk_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ainanaya mani emadu eteyo, ‘Sengne waune, rahida bodoni amewati wau wowisi, ete aromutataha, ete weinontarai aisei, ete tata ansung kaha, ete moninang tuti nai na aitamu rorong foi mani, wiro amefata wau kaha ne?’ ");
INSERT INTO amk_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Mananufoi yoa wesa deyo, ‘Tarai, imadurai we mea mau yeyo, fianai aino wiro menari we nehu doroio ne fiea kahai arorawa foi mani, wiro menari we yau kahai kontai.’ ");
INSERT INTO amk_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Inontarai tonina nesa esuai to kataio odai ne karirafo naya fo we fitawafa, mae mano enemirorong mesi fosa mani esuai to numainufo.” ");
INSERT INTO amk_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesusi deunau fi fuba nani kiaia mani, medu we ne inontarai erariati fosa deyo, ");
INSERT INTO amk_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Mewaitawanai ampa, weo rahida boru aha mani tatohonsua rahida Paska foi. Tuti inontarai manei dewayang Kaisung Inontarai nei we ne aitetafosa ambori epahui na aitabafoi.” ");
INSERT INTO amk_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ainanaya imami baba fosa tuti mano ewewafoniai we Yahudi fosa efanduhisa na imami fuba Kayafasi ne munu fiabai foi. ");
INSERT INTO amk_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Emadu ruhiai we etafu Yesusi na mamunggasai we ambori emuni. ");
INSERT INTO amk_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Manamo emadu wawerasa eteyo, “Wiro tanari finanai na rahida Paska foi fanai, weo nana mani kaiwasa bitoya foi ehuaya etohona rai.” ");
INSERT INTO amk_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Na kutuo Yesusi niai na Betania na Simoni, mano raminde nanai meninang kusta foi, ne munufoi, ");
INSERT INTO amk_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","wiwing manei da wei ma. Wiwing nani kia maning niunsai mampori botori bei, maning nani ne harga dedai paria. Yesusi wiata dampi mae wiwingfoi sara bau nungkamiai na maning niunsai mampori fo. ");
INSERT INTO amk_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yesusi ne inontarai erariati fosa ewati finana ampefe ehasou eteyo, “We fianie mei funong maning niunsai mampori foi wana? ");
INSERT INTO amk_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Weo maning wani awayani mani ne harga dedai tuti doifo dohonai weo inontarai ene pari fi fosa.” ");
INSERT INTO amk_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesusi deitawang enumikamieifoi, ampefe deyo, “Metatawa wiwingnei we fiani? I niari fio mahikai fo we yau. ");
INSERT INTO amk_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Weo inontarai ene pari fi fosa mani, enayai rahang mea pampang na rahida neungne, wape yau mani yau wiro inayai rahang mea waroi ahang kahai ki. ");
INSERT INTO amk_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","I sara maning niunsai mampori nei na nehu tarainei tonina ne we meinenang nehu tarainei we ambori esarai fo. ");
INSERT INTO amk_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Tarai, imadurai we mea mau yeyo, na nunei sentenang, na katai doni kontai nehu Kaiwo Mahikai fo ewuwuai naya mani, fi wiwingfi niari ninai kontaio etaiririai ki ambori earomio kariri i.” ");
INSERT INTO amk_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ainanaya Yudas Iskarioti, manei na Yesusi ne inontarai ewesuraya mandu fosa, da we imami baba fosara. ");
INSERT INTO amk_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Medu wesa deyo, “Metohong fiani we yau ambori yewayang Yesusi we mea ne?” Ampefe ebaiti na doi peraki piareia sura. ");
INSERT INTO amk_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Na rahida bonani to fongna fo Yudasi sera we rahida mai we dewayang Yesusi nayai. ");
INSERT INTO amk_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Na rahida bo reantenang etohonsua muniara Roti Weragi Kaha foi, Yesusi ne inontarai ewesuraya mandu fosa eraoia etutani eteyo, “Daie, katai bodoni dino enemurorong niayai nai we amemainenang fiang Paska we wau nai ne?” ");
INSERT INTO amk_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesusi medu wesa deyo, “Mera wa mesuai to bendari Yerusalemi, we inontarai manei, tuti memadurai wei meteyo, ‘Mantaunaufoi medu deyo; Nehu rahidafe de kikeu to, ampefe yau tuti nehu inontarai eraria yau nesa ametohonsua Paskanei ruhiai na nemu mununei.’ ” ");
INSERT INTO amk_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ampefe ne inontaraifosa enari kariri fiani aino demisa wea fo, era wa emainenang fiang we Paskafoi. ");
INSERT INTO amk_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Diru nanifai Yesusi tuti ne inontarai ewesuraya mandu fosa ewatai na mejafoi etampi. ");
INSERT INTO amk_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ewatai etampi mae Yesusi medu wesa deyo, “Tarai, imadurai we mea mau yeyo, manei na mea ambori dewayang yau ki.” ");
INSERT INTO amk_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Etarami kaiwo fenanai enemirorong fituayai paria, ainanaya mansiari-mansiari dutang bari Yesusi aha deyo, “Daie, wiro yau kahai e?” ");
INSERT INTO amk_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesusi yoa wesa deyo, “Inontarai dewayang yau nei dino soang ne rotifo ria yau na rewangguai boyari ne. ");
INSERT INTO amk_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Tarai, Kaisung Inontarai nei ambori mireha kariri fianai aino fafongfa nabifosa esoi na Sempasi ne Kaiwofoa fo. Wape we mano dewayang Kaisung Inontarai neia mani, ambori sobu ne karirafo ki! Ne mahikai sewa we wenanifaini mani, wiro saubaunung to nunei ma fanai.” ");
INSERT INTO amk_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Yudasi, mano ambori dewayang Yesusi foi medu wei deyo, “Dai, Rabie, wiro yau kahai to?” Yesusi yoa deyo, “Yo, toyari wau boisaha bera mantaung wau aha ne.” ");
INSERT INTO amk_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Rabuang bo etampi foi, Yesusi kia rotifeai dutang Sempaisi dohong mahikai wei. Ainanaya fioabau rotifoi na warangfo tuti dohonai we ne inontaraifosa. Yu rotifo dohonai wesa tonanai mae medu wesa deyo, “Mehari mau tuti metani, weo nehu taraifi dinini.” ");
INSERT INTO amk_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Mayeai kia nofi soni angguri nai foi, dutang Sempaisi dohong mahikai wei. Ainanaya dohong anggurifoi na nofifoi aha wesa tuti medu deyo, “Metunung kiai na nofi nini. ");
INSERT INTO amk_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Angguri nini mani nehu rika dine, rikao na Kaiwo Areraio Allai dohonai we inontarainesara, rikao tiwowu we kaiwasa bitoya foi ambori Allai feriri ene sasarifo. ");
INSERT INTO amk_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Yeisaharaifa weo angguri nini wiro yunumi ahang kahai, paria yunung angguri weworu ria mea na Dai Allai ne Mananu rorong foi.” ");
INSERT INTO amk_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ainanaya erohi rarung rowei we efiai Sempaisi, mayeai era to wiwoi Saitunia. ");
INSERT INTO amk_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ainanaya Yesusi medu wesa deyo, “Diru bonini kontaio, mea kiai ambori mewawu taterai weru yau ki. Weo na Allai ne Kaiwofo dotu tono: ‘Imung ne mantahungfoi, tuti dombafosa ambori ewawu taterai ki.’ ");
INSERT INTO amk_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Wape rahida bo isuwi aha foi mani, ambori ira foni meara isobu mea na nu Galilea foi ki.” ");
INSERT INTO amk_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Petrusi yoa deyo, “Bereri kontai. Tarahio mano wei nesa, mae yau mani todoni kontaio iwawu weru wau kaha rai.” ");
INSERT INTO amk_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesusi medu wei deyo, “Tarai, imaduarai we wau mau yeyo, diru nini wiro manggohei bibe kaharai mae, fofora yau webetoru kawurua, amani boyo wiro boroanso yau kaha.” ");
INSERT INTO amk_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Petrusi yoa deyo, “Todoni kontai ki, paria imereha kontai ria wauo, ifafora wau na wea kaha rai!” Tuti ne inontarai mano wei fosao, emadu tonana kontai. ");
INSERT INTO amk_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ainanaya Yesusi tuti ne inontaraifosa era to katai bei wonong fino Getsemani. Na katai nani medu wesa deyo, “Meminohi na nina mae itaha tourai to wanaia iwenadi nai.” ");
INSERT INTO amk_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ainanaya kia Petrusi tuti Zebedeusi ne arikangfo suru, amani Yakobusi tuti Yohanesi, itora ruhiai riati, na siari nanafo niuruainso enerorongfoi fituayai tuti weansarai finanaya. ");
INSERT INTO amk_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ainanaya medu we sitoru deyo, “Enehurorongnei fituayai paria nehu tarai toyari yeyo imereha. Ampafe muntonayai na ninai tuti muntorena fanai mae muntowaitawang weduarai ria yau.” ");
INSERT INTO amk_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Yesusi saha tourai waroi kuteai weru sitoru, ainanaya suki aweu kioha boha arong tuti wenadi we Sempaisi, deyo, “Daie, wobu rangfeai mani, kadeo ruai fi miraba fuba isodairi nini weru yau, wape wiro kariri nehu yawiane fanai, mae kariri nemu bawiawa terai.” ");
INSERT INTO amk_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Mayeai daraberahi we ne inontarai kia sitoru fo itoru aha, wape da wa mani sobu sitoru we itorenawa itowaitawang mai kaha. Ampefe medu we Petrusi deyo, “Wiro muntowemambiriu we muntowaitawang weduarai araha ureng boyari ria yau kaha e? ");
INSERT INTO amk_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Muntowaitawang weduarai tuti muntorutang Sempaisi, ambori Saminseni weanggari muntoru fanai. Tarai we muntonumianinuwa biriu we dohong kariri ne bengfo, mae muntone taraiwa wemambiriu kaha.” ");
INSERT INTO amk_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesusi da weberu wenadi tuti deyo, “Daie, masino dadira nini tiwera weru yau kaha, mae todoni kontai isodairi mani, yo, kariri nemu bawiawa terai.” ");
INSERT INTO amk_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ainanaya daraberahi we ne inontaraifo sitoru aha. Wape da wa mani sobu sitoru we itorenawa, weo itouremi mamong paria fefe. ");
INSERT INTO amk_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ainanaya da weru itoru nari aha, nana mani webetoru we wenadi finana, amani wenadi dafu kaiwo iari fo. ");
INSERT INTO amk_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ainanaya daraberahi aha tuti medu we ne inontaraifo sitoru deyo, “Muntowatai muntorena nendai e? Muntowati! Rahidafe kikeu ampa we Kaisung Inontarai nei, mano dewayani foi soari to inontarai sasari fo ewaramirorongfo ampa. ");
INSERT INTO amk_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Muntoroabari muntoru ambori tora. Weo muntowati, mano dewayang yau fi da kawuru ma nina.” ");
INSERT INTO amk_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesusi doa medu tonanai we sitoru mae, Yudasi da wei ma. Yudasi nini mani Yesusi ne inontaraio ewesuraya mandu fo manei dine. Kaiwasa bitoya era riati ma, eha sondu tuti aiboi. Kaiwasa nanisa mani, mano imami baba fosa tuti mano ewewafoniai we Yahudi fosa, ansaino etemisa ne. ");
INSERT INTO amk_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Na antanafa, Yudasi mano dewayani foi medu wesara deyo, “Inontarai mandoni dino inunahi fo mani, inontarai dinani, metafuri.” ");
INSERT INTO amk_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ainanaya Yudasi da bau Yesusia tuti medu deyo, “Bengfeai we Dai Rabio Mantaunaune wau.” Mae suana niuna Yesusi. ");
INSERT INTO amk_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesusi yoa wei deyo, “Maniwowire, fi ro weai we yau ma ne, nari kariria to.” Mayeai inontarai fau fosa etaha afong, eru tawani tuti etafuria. ");
INSERT INTO amk_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Na kutu nanai inontarai daria Yesusi fo manei fiating ne sondufoi tuti ferang kutu imami fuba Kayafasi ne womingfoi tarandaungfoia fituayai. ");
INSERT INTO amk_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesusi medu wei deyo, “Tata nemu sonduwai nari aha fui, weo inontarai mandoni dino memuna na sondu mani ambori sobu mai kahai, mae mireha na ne tonana ne kontai ki. ");
INSERT INTO amk_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Dohonao boitarahi yutang Dai Allai mani fiata yau kaha rai e? Imaya mani yutani denatu wewai rabuang sewa weru rabuang suraya boru we fiata yau. ");
INSERT INTO amk_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Wape, Allai niari tonana mani, fianai aino medurai na ne Kaiwofo we fininai ambori kawariafo, wiro kawariai kariria kahai ki.” ");
INSERT INTO amk_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Na kutu nanai medu we kaiwasa bitoya foi deyo, “Mewaitarahio yau mani inontaraio mamuna di yau e, donio meha sondu tuti aiboi mera ma we metafu yau nai nina e? Rahida neungne inayai yeunau pampang ria mea na Sempaisi ne Munufoi rofongfo, mae wiro metafu yau kaha. ");
INSERT INTO amk_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Wape fi fuba nini kiai kawariai ambori fianai aino nabifosa etoia fo, mai kaririai.” Ainanaya ne inontarai erariati fosa kiai ewawu taterai werui anina. ");
INSERT INTO amk_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Mano etafu Yesusi fosa ehari to imami fuba Kayafasi ne munufoi, na nanai mantaunau Kaiwo Musai soi fosa tuti mano ewewafoniai we Yahudi fosa efanduhisa kawuru na nanaia, amani mano esahusa we Majelisi Agama. ");
INSERT INTO amk_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Petrusifo da ria Yesusi na waroi paria suai kontai to imami fuba Kayafasi ne munu dereungfo afui, tuti minohi ria inontarai ewaitawang munufoi sa, weo deti kariri fi enari we Yesusia werea naya fo. ");
INSERT INTO amk_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Imami baba fosa tuti Majelisi Agama fosa tantenang erurai paria we esobu inontaraio epampamu etinggai Yesusi we dohong sarawai ambori etohong aiboi marareha fo wei. ");
INSERT INTO amk_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Kaiwasa bitoya era ma we etinggai funong Yesusi, manamo wiro esobu kaiwo sarawa feai demoyarai we etohong aiboi marareha fo wei kaha. Ainanaya inontarai mandu ura afong uroa na euremireafo, ");
INSERT INTO amk_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","tuti ureyo, “Inontarai nini mani medu deyo, ‘Ibiriu we itota Sempaisi ne Munufoia kiai tuti ibauni na rahida botoru aha doa.’ ” ");
INSERT INTO amk_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ainanaya imami fuba foi doa tuti medu we Yesusi deyo, “Todonie boromu tibau we kaiwo fuba etinggai wau weai nini kahai wei ne?” ");
INSERT INTO amk_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Wape Yesusi fioai borong kutuea kahaia. Ainanaya imami fuba foi medu wei deyo, “Na Allai Mano Darang foi wonongne, boisaharai we amea we wau mani Mananu Mampariri foi, amani Allai ne Kaisungfoi di wau e?” ");
INSERT INTO amk_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesusi yoa wei deyo, “Tonanai kariri modurawa, wape yeisaharai we mea weo na rahida bowani mani mea kiai ambori mewati Kaisung Inontarai nei we minohi na Allai Mano weMambiriu foi warang domoya fo tuti da na kafafefo na rorafaisi meu.” ");
INSERT INTO amk_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ainanaya imami fuba foi kesou paria tuti fiosiabu ne ansungfo tuti medu deyo, “Ee! Inontarai nini deibera Allai! Kasau we tata ampa. Mandoni dino tatutani we medu kariri ne sarawafo aha ne? Weo metaramioai terai na metaramine we deibera Allaifo ampa, weo deyo I mani Seng Allai ne Kaisung dine. ");
INSERT INTO amk_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ampafe menemitituai tofino?” Eroa eteyo, “Inontarainei mesi we sobu aiboi marareha to!” ");
INSERT INTO amk_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ainanaya ehandio urengfo tuti eboi. Manea kontai eboipa tararei, ");
INSERT INTO amk_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","tuti emadu eteyo, “Mananu Mampariri ne wau, boroanai toyari nabi, boisaharai we amea mandoni dino bioi wau nei.” ");
INSERT INTO amk_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Petrusi minohi na munu dereung boriei fo mayeai mangfata wiwing manei da ma tuti medu wei deyo, “Yesusi inontarai Galilea foi ne inontarai erariati fe manei di wau to!” ");
INSERT INTO amk_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Wape Petrusi fefora na euremireafo deyo, “Yeitawang fi modura wa kaha.” ");
INSERT INTO amk_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ainanaya da to rahutu borongno esuai nai we munufoi afuifo nanai, mangfata wiwing siai manei detioi tuti medu we inontarai etoari na nana nesa deyo, “Inontarai nini kontai anta doari ria Yesusi inontarai Nazareti foi.” ");
INSERT INTO amk_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Manamo Petrusifo fefora beyari nariai aha deyo, “Tarai, inontarai wani wiro yeroansoi kaha!” ");
INSERT INTO amk_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Waroi ahang kaha mae inontarai etoari na nana nesa era we Petrusi tuti etutani eteyo, “Wiro bereri ahang kaha, mae wau mani inontarai ro ria Yesusife manei di wau, weo modune modu kariri ea fefe.” ");
INSERT INTO amk_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Petrusi feforawa mutu beyari deyo, “Kaiwo metinggai yau weai ninai, iserawa iru na wa amangwau, yau yeroanso inontarai wani na ea kaha.” Na tatofang siari nanai kontaio manggohei bibe finana. ");
INSERT INTO amk_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ainanaya Petrusi aro fianai aino Yesusi medurai weia fo, deyo, “Wiro manggohei bibe kaharai mae, fofora yau webetoru kawurua.” Ampafe da to boriai weru katai nani tuti saia wiro denteng ahang kaha. ");
INSERT INTO amk_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Kameai kutung mae imami baba fosa kiai tuti mano ewewafoniai we Yahudi fosa efanduhisa emadu ehutu kaiwo weo emung Yesusi. ");
INSERT INTO amk_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ainanaya era wa ewora Yesusi warangfo suru, eharia etohoni we Pilatusi gubernuri parenta Roma foi. ");
INSERT INTO amk_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Yudasi mano dewayang Yesusi foi detioai we etohong aiboi marareha fo we Yesusifo nanai, enerorong fituai paria, dohona mani kia doi peraki piareia surao imami baba fosa tuti mano ewewafoniai we Yahudi fosa ebaiti naya fo da wa dohong ene nari aha. ");
INSERT INTO amk_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Medu wesa deyo, “Inari sasari paria, weo yewayang inontaraio dohong sarawa kaha foi.” Manamo eroa weia eteyo, “Finana mani wiro fi we amea kaha, fi mantaung wau woduata fine.” ");
INSERT INTO amk_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Yudasi tarao emadu tonanafo, so doi nani awafui watai na Munu Seng foia, tuti da wa soro kota rahanangfoi mireha anina. ");
INSERT INTO amk_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Imami baba fosa eruru doi Yudasi soai afui fo, tuti emadu eteyo, “Doi nina mani doi sobuai we mung inontarai naya fine, ahuai we doi werika fine, ampefe kariri Hukumifoi mani wiro ohonai afui watai we Sempaisi ne Munufoi fanai.” ");
INSERT INTO amk_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ampefe emadu ruhiai we doifoa mani, etohonai we ewori kahofa aino wonong fino Kahofa Inontarai Niari Fi Na Kahofa Ura. Kahofa nanai etohonai we inontarai aisei enai nana fosa manea emarareha mani esaraisa nayai. ");
INSERT INTO amk_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Nanai wedaya paria sobu rahida bonini inontarai esahuai we Kahofa Rika. ");
INSERT INTO amk_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ne tonanane kawariai ambori nabi Yeremiai ne kaiwo medura fo wetarai amani, “Esobu doi peraki piareia sura, amani harga na nu Israeli fosa ehutuai we ebaiti naya fo. ");
INSERT INTO amk_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Tuti doi nanai etohonai we ewori kahofa inontarai niari fi na kahofa ura foi nayai, nanai aino Sengnei deinawiai we yaune ambori enari kaririai.” ");
INSERT INTO amk_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Yesusi doa na Pilatusi, gubernuri we parenta Roma foi arongreafo mani, dutang berahi deyo, “Taraie, wau weMananu we inontarai Yahudi fesa ne ne?” Yesusi yoa deyo, “Yo, tonanai kariri modurawa.” ");
INSERT INTO amk_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Wape imami baba fosa tuti mano ewewafoniai we Yahudi fosa emadu ehikatawanai we etinggai Yesusi pampang, manamo medu sobu kaiwofea kahaia. ");
INSERT INTO amk_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Dohona mani Pilatusi medu wei deyo, “Etinggai wau we nari fikarira bitoya tonina ne, wiro taramuoa kaha e?” ");
INSERT INTO amk_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Wape Yesusi wiro fioai borong kutea kahaia, wiro yoa kariri fi etinggairi naya fo bei kontai kahaia, wedaya Pilatusi pepuhung paria. ");
INSERT INTO amk_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Na rahida fuba Paska foi neungfo mani, gubernurifoi ne koang we deiai inontarai niai na aitamu rorong fo manei da to boriai, kariri kaiwasa bitoya fo ene etawiafo. ");
INSERT INTO amk_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Rahida bonani, inontarai wewonong na warang saipaya manei wiatai na aitamu rorong fo, wonong fino Yesus Barabasi. ");
INSERT INTO amk_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Kaiwasa bitoya fianduhi na wanai, ampafe Pilatusi dutang berasa deyo, “Mandoni dino itawini we mea ne: Barabasi, ete Yesusi mano ahui we Mananu Mampariri nei e?” ");
INSERT INTO amk_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilatusi medu tonanaifa we deitawanai weo imamifosa tuti mano ewewafoniai we Yahudi fosa enemirorong pirahai we Yesusi, donio ehari ma nina. ");
INSERT INTO amk_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Arahio Pilatusi da wa minohi na kadera kutu kaiwo nai foi we deo kiutu kaiwo mae binengfoi denatu kaiwoariri wei ma deyo, “Bonansiau, wiro bohong aiboifeai funomai we inontarai dohong sarawa kaha nani fanai. Weo inontarai manani dohonaia diruafa yemiai karira paria fefe.” ");
INSERT INTO amk_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Wape imami baba fosa tuti mano ewewafoniai we Yahudi fosa ewawori kaiwasa bitoya foi, dohona mani etutang we Pilatusi we ambori sawing Barabasi mae dohong aiboi marareha we Yesusi. ");
INSERT INTO amk_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ainanaya Pilatusi dutang bera kaiwasa bitoya foi aha deyo, “Na inontarai nini suru mandoni dino itawini we mea ne?” Manamo kaiwasa bitoya foi sahu deyo, “Barabasi.” ");
INSERT INTO amk_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilatusi deyo, “Tonanaifa mani fiani aino inari we Yesusi, mano ahui we Mananu Mampariri nei ne?” Esahu ruhiai kai eteyo, “Pahui na aitabafoi.” ");
INSERT INTO amk_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ampafe dei aha deyo, “Wape fisarawaio todoni fino niari ne?” Manamo esahu mambiriu nariai aha eteyo, “Pahui na aitabafoi!” ");
INSERT INTO amk_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Arahio Pilatusi urengfo tabau we yurai todoni kontaio wiro dapa kaiwasa bitoya foi aha kaha, kontai mimeatai we kaiwasa bitoya foi dohonao ehuaia etohona fe. Ampefe kia merehafeai ma yuai warangfo suru nai na kaiwasa bitoya foi euremireafo tuti medu deyo, “Yohong sarafieai kahai we inontarai nini ne rikane, mantaung mea mesoduata ne.” ");
INSERT INTO amk_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ampefe eroa wei eteyo, “Yo, inontarai nini ne rikanei tau we amea tuti amene arikangnesa ki!” ");
INSERT INTO amk_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ainanaya Pilatusi sawing Barabasi we kaiwasa bitoya foi, wape demi ne afai mamuna fosa eruba Yesusi tuti dohoni eharia we epahui na aitabafoi. ");
INSERT INTO amk_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Mayeai Gubernuri ne afai mamuna fo manea eha Yesusi to ene munu fiabai eminohi nai foi afui, ainanaya esahu ne afai mamuna fosa kiai we efanduhisa na nanai wari Yesusi. ");
INSERT INTO amk_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Etisu Yesusi ne ansungfo tuti etohong ansung barikao ne hargai dedai feaia satarai, nana mani, ansung boriei toyari ansungno mano ewemananu fosa esansunsa nai fo. ");
INSERT INTO amk_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Etaya sapewi mananu weababo bei na ai arirawang weababo fo, etohoni satarai na nungkamiaifoi, mayeai etohong aireafea yu weaitatohi mananu na warang domoya foi. Ainanaya etuang aweu etisangkapa eawemibukafo tuti eteiberahi eteyo, “Inontarai Yahudi ne ene mananune waune, amefiai wau!” ");
INSERT INTO amk_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ehandioi tuti eha aireafo werui aha, eboi bau nungkamiai nayai pampang. ");
INSERT INTO amk_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Emei kanggania kaia fo, etisu ansungfo werui mae etohong mantauni ne ansungfo nari aha satarai, ambori ehari era we epahui na aitabafoi. ");
INSERT INTO amk_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ainanaya Yesusifo eharia. Na rang rabuang ehanggungno inontarai manei arahio de suai to bendarifo, wonong fino Simoni, inontarai Kirene dine, erutawani etemi sodua Yesusi ne aitabafoi. ");
INSERT INTO amk_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Mayeai era sobu katai bei wonong na kaiwo Iberani mani Golgota, nana mani wonong fino katai Woming Nungkamiei. ");
INSERT INTO amk_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Na nanai etohoni dunung angguri enaririao pirandima, wape bororuaing anggurifoi nanai mani deiayari. ");
INSERT INTO amk_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Mayeai epahu Yesusi na aitabafoi, eruaisi ayai sawai, mayeai efating aikarai we etato ne ansungfoi maisa. ");
INSERT INTO amk_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Etato ansungfo mai eara, eminohi ewaitawang Yesusi na aitabafoi neungfo. ");
INSERT INTO amk_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Tuti na aitaba sau nai foi nungkamiaifoi esoi kaiwo etinggairi naya fo amani dotu tono, Yesusi, Mananu Inontarai Yahudi Dinini. ");
INSERT INTO amk_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Na katai nani kontai epahu inontarai mananapi mandu, manei na eneung dowei, manei na eneung domoya. ");
INSERT INTO amk_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Kaiwasa fuba da na nana foi ehimi enumi tuti eteiberahi eteyo, ");
INSERT INTO amk_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“E, inontarai boyo tota Sempaisi ne Mununei tuti rahida botoru ruaisi aha ne waune, waramupa karira ninai weru wau. Allai ne Kaisung di wau mani, bia weru aitabawai.” ");
INSERT INTO amk_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Tonanai kontai imami baba fosa tuti mantaunau kaiwo Musa soi fosa kontai mano ewewafoniai we Yahudi fosa eteibaberahi eteyo, ");
INSERT INTO amk_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“I mani feriri inontarai siai, wape wemambiriu we feriri bera mantauni kaha. I mani Mananu Israeli dine! Ha, tonana mani bia weru aitabafoi to, nana mani taroasoi finana. ");
INSERT INTO amk_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Yoaso Allai tuti medu deyo Allai ne Kaisung dine. Yo, tonana mani Allai miaya mani, andino feriri na kutu nina fe.” ");
INSERT INTO amk_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Na tonanane kontai, inontarai mananapi mandu epahu suru na nana ne, ureiberahi kontai. ");
INSERT INTO amk_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Tete rahida rabuang araha ureng suraya boru, na tantuma kataifoi memantiti sentenang paria sobu araha ureng botoru. ");
INSERT INTO amk_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Tuti tete ramindena araha ureng botoru foi, Yesusi bibe fuba deyo, “Eli, Eli, lama sabaktani?” nana mani deyo, “Dai Allai, Dai Allai, todoni tawing yau nina?” ");
INSERT INTO amk_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Inontarai maneiru teaio etoa kefang na nana fosa etaramio Yesusi bibe fo tuti eteyo, “Sahu we nabi Elia.” ");
INSERT INTO amk_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Inontarai manei na kaiwasa nanisa sikaherawa kia mandafeai, yorang na angguri sisasa feai, mayeai kia aifarang bei ma disanai nai, ainanaya subarai to Yesusi borongfo ayai. ");
INSERT INTO amk_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Wape inontarai mano wei fosa emadu eteyo, “Tawini! Tatamang tawatioai we Eliai da ma suki weru aitabafoi rai ete bireri e.” ");
INSERT INTO amk_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ainanaya Yesusi bibe fuba beyaria aha na rawafui tapapa, mayeai kiaharaia. ");
INSERT INTO amk_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Na siari nanai kontaio ireu aburung sau wetaba na Sempaisi ne Munufoi rorongfo miabu weberu, na yaifo paria sobu kofafo, tuti mundiei fiabai bei fio, wedaya kamirangfo tababau ");
INSERT INTO amk_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","tuti fafo tapapasa. Tuti inontarai emararebanaio emararehara fosa esuwi aha. ");
INSERT INTO amk_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Etariai na fafofo tonanai tuti inontarai nanisa kontai, rahida bo Yesusi suwi na marareha rorong fo aha fo, ea kontai era wa esuai to bendari Yerusalemi, na nanai kaiwasa bitoya ewatisa nayai. ");
INSERT INTO amk_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Mano wenunggamiei we rai mamuna fosa tuti ne afai mamuna ewaitawang wedua Yesusi fosa, epapuhing tuti ematai paria we ewati mundiai fio fo tuti fifuba nani kiai fefe, amani emadu eteyo, “Tarai, inontarai nini Allai ne Kaisung dine.” ");
INSERT INTO amk_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Na nanai wiwing bitoya raminde era ria Yesusi na Galilea ma we efatari fosa, etoa ewati kariri fi fuba kawariai nanai na waroi. ");
INSERT INTO amk_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Na wiwing nanisa mani, Maria Makdalenai, tuti Mariaio Yakobusi tuti Yusupi uinamifoi, tuti Zebedeusi ne arikangfo uinamifoi, itohontaifa. ");
INSERT INTO amk_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Dirua mani inontarai ne ra bitoya manei na bendari Arimatea dao Pilatusia. Inontarai nani wonong fino Yusupi tuti i kontai inontarai daria Yesusi manei dine. ");
INSERT INTO amk_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Dao Pilatusia tuti dutani we Yesusi ne taraifoi, ampafe Pilatusi dohong kaiwoariri we afai mamuna fosa, aninanaya etohong Yesusi ne taraifoi weia. ");
INSERT INTO amk_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Mayeai Yusupi kia Yesusi ne taraifoi tuti sensani na ireu ne harga dedai, amani ireu lineni dine. ");
INSERT INTO amk_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ainanaya dohong ne taraifoi wiatai na mantauni ne fafo waworu foi, fafo mantauni dahi na wiwoi wekamiei fo. Dedoi kamiei fiabai bei awa wia wedua fafo borongfoa akawuru wori da wa. ");
INSERT INTO amk_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maria Makdalena tuti Mariai mano siai foi uminohi na fafo borongfo. ");
INSERT INTO amk_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Kameai aha mani, rahida Sabati dine, imami baba fosa tuti Farisifosa era ruhiai we Pilatusia, ");
INSERT INTO amk_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","tuti emadu wei eteyo, “Mambaisengne wau ne, amearomioai we na inontarai sofa biriu foi darangne, medurai deyo, ‘Rahida bo botoru foi mani, isuwi aha ki.’ ");
INSERT INTO amk_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ampefe bemi inontarai ewaitawang wedua fafofoi paria rahida bo botoru foi. Dohona ne inontarai erariati fosa era wa ehamanana ne taraifoi fe, nana mani etaiririai eteyo, Yesusi suwi na marareha rorong fo ampa. Tatofa wefuiai nana mani, karira sewa ne fafong fo.” ");
INSERT INTO amk_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilatusi medu wesa deyo, “Meha nehu afai mamuna manea mera wa ambori ewaitawang fafofoi na mai.” ");
INSERT INTO amk_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ainanaya eha afai mamuna fosa era to Yesusi ne fafofoia, ewora tawang kamieifoi tuti etohong afai mamuna fosa etoa wari fafofoi. ");
INSERT INTO amk_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Rahida Sabati foi kiaia, na rahida Minggu kameai kutung Maria Makdalenai tuti Maria mano siai foi ura wa uwati fafofoi. ");
INSERT INTO amk_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Mayeai na tantuma mundiai fuba bei fio mambiriu, weo Allai ne wewai manei biari na rorafaisi meu, da to fafofoi dedoi kamiei wia kobu fafo borongfo, tuti minohi saui. ");
INSERT INTO amk_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Wewaifoi ne tarai dansairai toyari kaiwewa fenana, tuti ne ansungfo bua karofari tantenang. ");
INSERT INTO amk_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Afai mamuna ewaitawang fafofoi emataia erirorara tuti euremimakaha etawai aweu. ");
INSERT INTO amk_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ainanaya wewaifoi medu we wiwingfo suru deyo, “Wiro mumatai fanai, yeitawanai musera we Yesusi, mano epahui na aitabafoi. ");
INSERT INTO amk_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","I wiro wia na ninai ahang kaha, weo suwi ampa kariri medurai we meara fo, mura ma muwati katai anta wia nai nei. ");
INSERT INTO amk_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Tuti mura musaherawa muraiririai we ne inontarai erariati fosa, we i suwi ampa, tuti da fafongna demang ea na Galilea, ambori na wana ewatioi ki. Muaromio fi imadurai we muru ninai.” ");
INSERT INTO amk_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Wiwingfosuru umito weru fafofoi, umito na umatai wape kontai umirising, ampefe umito usaherawa weo uraiririai we Yesusi ne inontarai erariati fosa. ");
INSERT INTO amk_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Mayeai na tantuma Yesusi dario wiwingfosuru tuti medu we suru deyo, “Mahikaifeai.” Ainanaya ura kefania ufaung awengfo usomi wei. ");
INSERT INTO amk_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ainanaya Yesusi medu we suru deyo, “Mumatai fanai, mura wa muraiririai we nehu doroifosa ambori era to Galilea, na wana ewati yau ki.” ");
INSERT INTO amk_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Arahio wiwingfo suru ura mae, afai mamuna ewaitawang fafofoi manea etaraberasa to bendarifo tuti etaiririai we imami baba fosa kariri fifuba ewatioi nani kiai. ");
INSERT INTO amk_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ainanaya imami baba fosa era wa efanduhisa ria mano ewewafoniai we Yahudi fosa, emadua ehutu kaiwo ruhiai, ampefe etohong doi bitoya paria we ebai afai mamuna fosa nai. ");
INSERT INTO amk_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Tuti emadu wesa eteyo, “Metaiririai mani meteyo ‘Yesusi ne inontarai erariati fosa era diruai ma tuti ehamanana ne taraifi ampa, weo ametena fefe.’ ");
INSERT INTO amk_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Tuti masino Gubernuri Pilatusi tarao kaiwo mewuwuai kariri metena fo mani, ambori amemadu wei ki, ambori wiro mesobu aiboifea kaha.” ");
INSERT INTO amk_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ainanaya afai mamuna ewaitawang fafofoi eha doifoa tuti etohong kariri fifiani aino imami baba fosa etarerai wesa fo. Nanai wedaya kaiwo kairiri Yesusi we ne inontaraifosa era diruai ma ehamananai foi, kaiwo nanai dafai wariai na inontarai Yahudi fosa paria sobu rahida bonini. ");
INSERT INTO amk_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yesusi ne inontarai ewesuraya mansiri fosa era to wiwoi bei na Galilea, kariri ne kaiwo dererai wesara fo. ");
INSERT INTO amk_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Na wanai ewati Yesusi ampafe esomi wei, wape kontai manea enemirorong soriru we Yesusi dine ete bereri e. ");
INSERT INTO amk_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesusi da kefangsara tuti medu wesa deyo, “Dai Allai dohong mambiriu doni konta fo we yau, amani mambiriu kiai na rorafaisi tuti na nunei. ");
INSERT INTO amk_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ampefe mera wari nunei sentenang metaunau kaiwasa nunei kiai ambori eraria yau, tuti mewebaptisisa na Dai Allai wonongne, Kaisung Yesusi wonongne, tuti Nuaninu Mirarebana nei wonongne. ");
INSERT INTO amk_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Metaunausa ambori etohong kariri fifiani aino yemiai we mea wa, tuti mearomioai we iweriria mea pampang paria sobu nunei kiai naya fo.” ");
INSERT INTO amk_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kaiwo Mahikai kariri Yesus Kristusi, Allai ne Kaisungfoi, ainina. ");
INSERT INTO amk_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Amani Allai medu we ne Kaisungfoi, tuti nabi Yesayai soi kaririaia, ampafe dotu tonina: “Yemi nehu inontaraio kia nehu kaiwone manei, da foni Wau. I ambori meinenang nemu rangfoi we Wau.” ");
INSERT INTO amk_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Inontarai nani da sahu pampang na katai wekamamiei minano foi, deyo ‘Memainenang rang beng feai we Sempaisi, tuti menaria mimoya wei.’” ");
INSERT INTO amk_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Kariri kaiwo nanai fa, Yohanesi mano webaptisi kaiwasa foi kiawariaifa na katai wekamamiei minano foi tuti wiuwu kaiwofo, deyo, “Metarabera mea weru mene sasariwa tuti mewebaptisi, ambori Allai feriri mene sasariwa.” ");
INSERT INTO amk_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Kaiwasafoi kiai na nu Yudea foi tuti na bendari Yerusalemi era we Yohanesia. Era ma eteiai ene sasarifo tuti webaptisisa na waya Yardeni. ");
INSERT INTO amk_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Yohanesi nini ne ansung satara fo beng kaha, mae na fiahung unta nuwawuru, tuti ne aikapurufoi na andowa rerawa, toyari nabi na fafongfa fosa ene ansung etatara fo. Ne fidangfo mani manggofuni tuti aniwa ne maing terai. ");
INSERT INTO amk_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Neo kaiwo medura fininai, “Katu wori manei da tua yau ma. I fiebai sewa yau tuti we irehu ne wai sapatu fo terai ki, wiro imai we inari finana kaha. ");
INSERT INTO amk_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Iwebaptisi mea na mereha wape i ambori webaptisi mea na Nuaninu Mirarebana foi ki.” ");
INSERT INTO amk_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Na rabuang bo Yohanesi medu we kaiwasa bitoya foi nani, Yesusi da na bendari Nazareti na nu Galilea foi ma tuti Yohanesi webaptisi i na waya Yardeni foi. ");
INSERT INTO amk_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Na tatofang kutu Yesusi kiawariai na mereha rorongfe meai nanai, deti rorafaisi tifai tuti Allai Nuaninunei ne tarai wemuntung manei sea na rorafaisi meu minohi sauwi. ");
INSERT INTO amk_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Mayeai tarao Allai raofuifoi medu na rorafaisi meu deyo, “Wau mani nehu Kaisung enehuwawuti fi di Wau. Wau ka enehurorong fine.” ");
INSERT INTO amk_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Na tatofang kutu nanai kontaio Allai Nuaninufoi demi Yesusi da to katai wekamamiei minano foi. ");
INSERT INTO amk_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Niayai na nanai rahida piaru mae Saminseni weanggariri. Andowa fuba ahumi kaha fosa enayai riati na nanai tuti wewai fiatari na fi dohong wea fo na nanai. ");
INSERT INTO amk_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Mayeai Yohanesi mano webaptisi kaiwasa foi, etafuria wiatai na aitamu rorong fo. Amani, Yesusi da to nu Galilea foi, tuti wiuwu Allai ne Kaiwo Mahikai fo na nanai. ");
INSERT INTO amk_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Yesusi medu deyo, “Rahida metamang wea fe mai ampa, rahidao Allai da ma we weMananu fe kikeu ampa. Metarabera mea weru mene sasariwa tuti meroaso Allai ne Kaiwo Mahikai ne.” ");
INSERT INTO amk_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Rahida Yesusi da na nafarengfo na ruru Galilea foi nanai, detio manggaerang mandu, mambetahatui suruine, amani Simoni tuti Andareasi. Deti suru we umung erangfoi we utafu diang. ");
INSERT INTO amk_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ainanaya Yesusi medu we suru deyo, “Mura ma, muraria yau, ambori mutafu diang ahang kaha mae yeunau muru we mutafu inontarai we yau.” ");
INSERT INTO amk_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Na tatofang kutu nanai kontaio uwaramipa erangfo watai mae urariati. ");
INSERT INTO amk_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Yesusi da paria aha mani, deti mambetahatui mandu aha, uminohi na une wafoi mae uria une erangfo. Mambetahatui nani suru mani uwonomi fino Yakobusi tuti Yohanesi, uru mani Zebedeusi ne arikang suruine. ");
INSERT INTO amk_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Anseung ahang kahai mae Yesusi dutang suru kontai. Ampafe utubapa utamamifoi tuti mano erufi we sitoru fosa na wa emungfi nai foi, uraria Yesusi. ");
INSERT INTO amk_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesusi tuti ne inontarai diri sitoru fo itora wa sobu bendari Kapernaumi foi. Na rahida Sabati da aha ma foi Yesusi da to Yahudifosa ene munu agama foia deunau Allai ne Kaiwo Mahikai foi we kaiwasa bitoya foi. ");
INSERT INTO amk_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Kaiwasa etarami ne aunaufe nanisa epapuhung paria we deunau toa fo. Weo Yesusi deunau kariri mano wemambiriu paria we deunau tonana, wiro deunau toyari kaiwo batangno ene mantaunau Kaiwo Musai soi fosa emadura fo kaha. ");
INSERT INTO amk_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Na siari nanai kontaio inontarai nuaninu karira dohoni manei suai to munu agama foi tuti bibe sahu deyo, ");
INSERT INTO amk_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yesuse, inontarai Nazareti wa waune, bo nari fiani we amea ne? Ro ma weo bohong amea ameworua ne? Amewaitawanai we mandoni di wau, wau mani Mano Murarebanai, na Seng Allai ma fi di wau.” ");
INSERT INTO amk_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Manamo Yesusi somara nuaninu karira foi deyo, “Nemuboru, ro to woriai weru inontarai nini.” ");
INSERT INTO amk_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ainanaya nuaninu karira foi dotapa inontaraifoi aweu wiatai tuti bibe mambiriu beyari mayeai da to boriei weruria. ");
INSERT INTO amk_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kaiwasa na nana foi kiai epapuhung paria we fi ewatioai nanai, ampafe etutang wawerasa eteyo, “Ke! Fianai ainina? Kaiwo aunau waworu fine. Na mambiriufo demi nuaninu karira fosa era to boriei tuti nuaninu karira fosa etohong kaririai.” ");
INSERT INTO amk_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ampafe kaiwo kariri fianai aino Yesusi niari fo, anseung ahang kahai mae dafai wari nu Galilea foi sentenang. ");
INSERT INTO amk_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesusi tuti ne inontarai diri sitoru fo itora weru munu agama Yahudi foi, itora to Simoni tuti Andareasi une munufoia. Yakobusi tuti Yohanesi ura kontai riatai. ");
INSERT INTO amk_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Na munufoi Simoni niong wiwini meninang rirora wiatai na ne fatafoi. Na siari Yesusi tuti ne inontaraifo sitoru itora wafui nanai, inontarai manei deikaririai we Yesusi kariri wiwingfoi we meninangfo. ");
INSERT INTO amk_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ampafe Yesusi da wa yu na wiwingfoi warangfo tuti fiatari doabariria. Na tatofang kutu nanai kontaio maninangfoi niai, tuti wiwingfoi doabariri da wa wesarawiri wesa. ");
INSERT INTO amk_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Wofoi sawaia de weayewia nanai, kaiwasa eha inontarai maninang bitoya tuti mano inggira dohonsa fosa we Yesusi ma. ");
INSERT INTO amk_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ampafe kaiwasa fuba na bendarifoi efanduhisa na munufoi refongfo. ");
INSERT INTO amk_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ainanaya Yesusi niari kaiwasa fuba esodai mai maninang bong foi nanisara ebeng tuti data nuaninu karira bitoya weru kaiwasa nuaninu karira dohonsa fosa. Kontai Yesusi yoa we inggirafosa emadu kaha, we ewaitawang kariri i mani mandoni dine fefe. ");
INSERT INTO amk_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Kameai nanai mamantiti siarifo mae, Yesusi fiononami weru munufoi, da to katai manano na bendari dereung do boriei fo awa wenadi nayai. ");
INSERT INTO amk_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Wape Simoni tuti ne maniwowirifosa etoari meai era esera riati. ");
INSERT INTO amk_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Eserawa esobui nanai, emadu wei eteyo, “Daie, kaiwasanei kiai esera we wau.” ");
INSERT INTO amk_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Manamo Yesusi yoa deyo, “Mera ma tara to fong kariri tara weafo to bendari watai kefang na ninaifa ne, we ikorang nayai, weo finanai aino ira weai ma ne.” ");
INSERT INTO amk_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ampafe Yesusi da mai katitai na nu Galilea foi tuti kiorang na munu agama Yahudi fo, kontai data nuaninu karira bitoya weru inontarai nuaninu karira dohonsa fosa. ");
INSERT INTO amk_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ainanaya inontarai meninang kusta manei da we Yesusi ma, disangkapa awebuka na Yesusi arongreafo, mae dutani deyo, “Daie, wau wemambiriu ne, maya mani, nari yau yenteng weru nehu maninangnei.” ");
INSERT INTO amk_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Yesusi aro inontaraifoi paria ampafe suba warangfoa wa sauwi tuti medu wei deyo, “Yo, imaya. Bonteng to!” ");
INSERT INTO amk_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Tatofang kutu nanai kontaio maninang kusta foi niai werui tuti dentengna. ");
INSERT INTO amk_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ainanaya Yesusi demi da wa tuti deretawani deyo, ");
INSERT INTO amk_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Aromuoaifa! Wiro boiriri fi inari ninai weo inontarai siai manei fanai, mae ro to imamifoia tuti butani we deti kariri nemu taraiwai we bontengna wa. Mayeai bohong korbanifeai we Allai we nemu bontengna wa kariri fianai aino Musai soia fo. Nana mani deinawiai we kaiwasa bitoya foi we bonteng ampa.” ");
INSERT INTO amk_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Manamo inontaraifoi da wa deiririai we kaiwasafoi kariri fianai aino sodairai nanai, paria wedaya kaiwasa bitoya era weia. Ampafe Yesusi da parai to bendarifoi ahang kaha, mae niai na bendari dereung do boriei fo. Tonanai wape kaiwasa bitoya na doni kontai era weia. ");
INSERT INTO amk_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Rahida beiru teai aha mani Yesusi daraberahi to bendari Kapernaumi. Ampafe inontarai etaramioai we Yesusi da wa minohi na ne munu minohi nai fi fo. ");
INSERT INTO amk_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ampafe kaiwasa bitoya era wa etira paraia wiro katai fea watai arora kaha. Rahutu borong fo kontai wiro weai watai arora kaha. Ainanaya Yesusi medu Allai ne Kaiwofo we deunausa nayai. ");
INSERT INTO amk_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Yesusi doa medu tonanai mae, inontarai itowemana itoha wefiaya manei we Yesusia. ");
INSERT INTO amk_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Manamo kaiwasa bitoya karerai ampafe wiro itora kefang Yesusi afui kaha. Ampafe itoha wefiayafoi itorautai tutiri na tehi to munu wowongfo ayai. Ainanaya itotota munu nuwowongfo weai tete Yesusi doa naya fo, mayeai itotu wefiayafoi tuti andaung wiatai nai foi aweu wiatai na Yesusi arongreafo. ");
INSERT INTO amk_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesusi detio enari tonanafo deitawanai we eroasoafo fuba paria, ampafe medu we inontarai fiaya foi deyo, “Kaisungne waune, yeiai nemu sasarifi ampa.” ");
INSERT INTO amk_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Mantaunau Kaiwo Musai soi fo maneiru teaio eminohi na nana fosa enemitituaitai na enemirorong eteyo, ");
INSERT INTO amk_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“We fiani inontarai nini medu tonana? I deibera Allai, weo mandoni dino biriu we deiai sasari fine? Seng Allai mantauni terai.” ");
INSERT INTO amk_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Na kutu siari nanai kontaio Yesusi deitawang enemirorongfoi ampafe medu wesa deyo, “Todonie menemitituaitai tonanai na menemirorongwai nina? ");
INSERT INTO amk_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Doni aino mawa ne: imadu yeyo, ‘Yeiai nemu sasarifi ampa,’ ete yeyo, ‘Boabari wau, ka nemu andaungwai, tuti roa,’ ne? ");
INSERT INTO amk_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Wape yeinawiai we mea, na yohong inontarainei denteng tonina ne, ambori mewaitawanai weo na nunei ninai, Kaisung Inontarai nei andino ne mambiriu we deiai sasari fine.” Ainanaya Yesusi medu we inontarai fiaya foi deyo, ");
INSERT INTO amk_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“We wau mani, imadu mau yeyo, boabari wau, ruai nemu andaungwai, ro to nemu munufoia.” ");
INSERT INTO amk_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Na kutu nanai kontaio inontaraifoi doabariri, yuai ne andaungfoi tuti da to boriei na kaiwasa bitoya foi euremireafo. Kaiwasa fuba ewati fitantumafe nanisa kiai epapuhung paria, ampafe etaparanding Allai. Emadu eteyo, “Ke! Fianai kawaria nina? Ne toninane wiro tawatioai na wea kaha rai.” ");
INSERT INTO amk_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesusi daraberahi to nafareng ruru Galilea foi aha. Na wanai kaiwasa bitoya era weia tuti deunausa. ");
INSERT INTO amk_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Mayea Yesusi da nariai aha mani deti inontarai fianduhi doi pajaki we parenta Kaisari fo manei, minohi na munu pajaki foi, wonong fino Lewi. I mani Alfiusi ne kaisung dine. Yesusi medu weia deyo, “Ro ria yau.” Anseung ahang kahai mae Lewi doabariri tuti daria Yesusi. ");
INSERT INTO amk_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Yesusi da wa minohi dampi na Lewi ne munufoi nanai, mano efanduhi doi pajaki we parenta Kaisari fo efau paria tuti inontarai kaiwasa bitoya foi sahusa we inontarai ewesasari fosa, efanduhisa ria Yesusi kontai na nanai. Ewatai etampi ruhiai ria Yesusi tuti ne inontarai dirisa fosa weo kaiwasa efau paria era riati fefe. ");
INSERT INTO amk_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Mantaunau Kaiwo Musai soi fo maneiru teai, na Farisi rabuangfoi, ewati Yesusi we minohi dampi ria inontarai nanisa fo, etutang bera Yesusi ne inontarai dirisa fosa eteyo, “We fianie mene mantaunaufoi dampi ruhiai ria inontarai efanduhi pajaki we parenta Kaisari foi tuti inontarai ewesasari fosa ninai?” ");
INSERT INTO amk_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesusi tarao etutang tonanafo, yoa wesa deyo, “Inontarai etanteng nesa mani etohong we manggarawangnei kaha, mae mano emaninang fosa. Wiro ira ma weo isahu inontarai emararebana fosa kaha, mae ira we isahu inontarai ewesasari nesa.” ");
INSERT INTO amk_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Rahida bei Yohanesi mano webaptisi kaiwasa foi ne inontarai mano erariati fosa, tuti inontarai eweFarisi fosa ewepuasa. Ainanaya inontarai manea era ma etutang bera Yesusi eteyo, “We fianie Yohanesi mano webaptisi kaiwasa foi ne inontarai erariati fosa tuti Farisifosa ewepuasa, wape nemu inontarai eraria wau nesa bereri nina?” ");
INSERT INTO amk_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesusi yoa wesa deyo, “Tofino! Ne tarai kariri mandirau mang foi tuti ne inontarai wenotisa to ne muniara mandirau foi. Na rahida mandirau mang foi minohi riasa nanai ewepuasa rai e? ");
INSERT INTO amk_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Wape rahida we mandiraufoi niayai na nanai riasa ahang kaha foi ambori da ma ki, rabuang bonani dino ambori ewepuasa ki. Tonanai kontai, nina mani inayai riasa ampafe ewepuasa kaha, wape rahidao ambori ira werusa foi da ma ki, rahida nanai aino ewepuasa ki. ");
INSERT INTO amk_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Manei ne ansung mamo feai tai mani wiro dawa kobuai na ireu aburung waworu fea kaha, weo nana mani ireu aburung waworu fo yabi we ansungfo ambori ansung mamo fo mayabu fo fuba aha. ");
INSERT INTO amk_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Tonanai kontai we angguri waworu nei mani, wiro ariri to aderi sapi rerawa memo bei kaha, weo angguri weworu foi ambori wiwua wedaya aderi sapi rerawa memo foi tei. Nana mani anggurifo tibatara, aderi sapi rerawa foi kerirawa. Wape angguri weworu foi ariri tono aderi sapi rerawa weworu bei kontai.” ");
INSERT INTO amk_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Na rahida Sabati bei, amani rahida Yahudifosa erufi nai kaha dine, teterai we Yesusi era riria romi potang bei, ampafe ne inontarai erariati fosa etetingno potangfoi, etani. ");
INSERT INTO amk_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ampafe Farisi manea emadu eteyo, “We fianie nemu inontarai eraria wau wasa enari fi tonana fo na rahida Sabati nei nina? Enari tonana mani etohong roaing kaiwo dotu weduara fo.” ");
INSERT INTO amk_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Ainanaya Yesusi yoa wesa deyo, “Finana mani ne tarai toyari fi Mananu Dauti niari na fafongfa na rahida bo Abiatari weimami fuba foi. Metato kariri kaiwo nana kaha e? Amani i tuti ne mano erariati fosa ewawisi fo, ampafe suai to Sempaisi ne Munufoi afui dangno roti etutang tutirai we Allaia fo tuti dohonai we ne mano erariati fosa etang kontai. Wape finanai, kariri hukum agama foi mani, imami erufi na Sempaisi ne Munufoi saino etang tera ne.” ");
INSERT INTO amk_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ainanaya Yesusi medu aha deyo, “Rahida Sabati nei mani Allai niariri we fiata inontarainesa, wiro niari inontarainesa we etohong kariri rahida Sabati nei kaha. ");
INSERT INTO amk_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Ampafe Kaisung Inontarai nei weSeng we rahida Sabati nei kontai, ampafe wemambiriu weo deiriri kariri fianai aino na rahida Sabati nei mani inontarainesa enari fo, tuti fianai aino enari kaha fo.” ");
INSERT INTO amk_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Na rahida Sabati bei Yesusi daraberahi to munu agama Yahudi foi aha. Inontarai warang bei mireha manei niayai na nana. ");
INSERT INTO amk_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Tuti na nanai inontarai manea euremifo dingga Yesusi weo niari inontaraifoia denteng na rahida Sabati mani, ambori etinggairi, eteyo niari sarawai. Manamo Yesusi deitawang fi enemitituata fo. ");
INSERT INTO amk_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ampafe medu we mano warang bei mireha nani deyo, “Ro ma boari na fongne.” ");
INSERT INTO amk_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ainanaya dutang bera inontarai etoari na nana fosa deyo, “Kariri Hukumi Musai soi fo mani, ne doni aino tanari na rahida Sabati fine, tanari ne bengfo ete ne karirafo ne? Tafata inontarai ambori etarang, ete tamunsa re?” Kaiwofo disang inontaraifosa, ampafe manei deiobu kaiwofeai ahang kaha. ");
INSERT INTO amk_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Yesusi kesou, deti maino kaiwasafoi sentenang, wape enerorongfoi fituayai paria kontai we enumikamiei mitubaru fo. Ainanaya medu we mano meninang foi deyo, “Wi waramuwai ma.” Inontaraifoi si warangfoi kaririaia, na tatofang kutu nanai kontai warangfoi dentengna. ");
INSERT INTO amk_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Farisifosa ewati finanafo wiro eparaise kaha, mae era to boriei weru munu agama foi tuti emadu ruhiai ria Mananu Herodesi ne inontarai erariati fosa we ambori emungno Yesusi. ");
INSERT INTO amk_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Na nanai Yesusi tuti ne inontarai erariati fosa efusuhiai to ruru Galilea foia. Ampafe inontarai bitoya paria na Galilea era ria Yesusia. Wiro kaiwasa na nu Galilea foi tera kaha, mae na katai waroi fo kontai era ma, amani kaiwasa na nu Yudea foi, ");
INSERT INTO amk_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","tuti na bendari Yerusalemi, na nu Idumea foi, tuti kaiwasa na Yardeni dereung domurang foi. Kontai kaiwasa na katai watai kahefang na bendari Sidoni tuti Tirusi fo. Kaiwasa nani kiai era we Yesusi ma, we etaramio fianai aino niaria fo fefe. ");
INSERT INTO amk_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Kaiwasafoi bitoya karerai, ampafe Yesusi demi ne inontaraifosa emainenang wafeai wei, weo mimeatai we dohonao kaiwasa bitoya foi esawaria doa mimoya kaha fe. ");
INSERT INTO amk_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Weo na nanai niari kaiwasa bitoya ebeng, ampafe kaiwasa fuba meninang foi esawasa we ewarami disangso Yesusi ne taraifoi. ");
INSERT INTO amk_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Tuti inontarai nuaninu kerira dohonsa fosa, na doni kontaio ewati Yesusi mani, etawai aweu etisangkapa eawemibuka na arongreafo, ebibe esahu, “Wau mani Allai ne Kaisung di wau.” ");
INSERT INTO amk_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Wape na tapapa Yesusi sua nuaninu karira fosa we esahu tutiri fanai. ");
INSERT INTO amk_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Mayeai Yesusi dautai to wiwoi bei tuti sahu inontaraio enerorong dohong we dirisa fosa, tuti inontarai sahusa nanisa era weia. ");
INSERT INTO amk_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Tuti diri ewesuraya mandu na sa we ewerasuli fosa, dirisa we eweririati. Demisa era wa ewuwu Kaiwo Mahikai ne, ");
INSERT INTO amk_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","tuti dohong mambiriu wesa ambori etata nuaninu karira fosa. ");
INSERT INTO amk_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Inontarai suraya mandu nanisa ewonomi fino, Simoni mano sahui we Petrusi foi, ");
INSERT INTO amk_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakobusi tuti ne tahatui Yohanesi, uru mani Zebedeusi ne kaisung surui ne. (Inontarai nini suruino sahu suru kontai we Boargenesi amani netawe Kaisung Kadidu.) ");
INSERT INTO amk_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andareasi, Pilipusi, Bartolomasi, Matiusi, Tomasi, Yakobusi (Alfiusi ne kaisungfoi), Tadeusi, Simoni (mano biriu we inontarai Israeli fosa etoa siai weru Romafosa foi). ");
INSERT INTO amk_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Tuti Yudas Iskariotio mano ambori dewayang Yesusi foi. Mayeai Yesusi daraberahi to munu minohi nai foi aha. ");
INSERT INTO amk_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Na nanai kaiwasa bitoya era aha ma efanduhisa nayai. Kaiwasafoi bitoya paria wedaya Yesusi tuti ne inontaraifosa esobu rahida we etampi kaha. ");
INSERT INTO amk_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Yesusi ne terafosa etaramioai weo Yesus wiro dampi kaha, ampafe eteo era we ehari. Eteyo, “Yesusi toyari we fiauwo ampa.” ");
INSERT INTO amk_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mantaunau Hukumi Musai soi fosa, mano era na Yerusalemia fosa, emadu eteyo, “Yesusi mani, Barsebuli amani inggirafosa ene mananufoi donti, ampafe dohong mambiriu wei doni data inggirafosa nina.” ");
INSERT INTO amk_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ampafe Yesusi sahu kaiwasa bitoya foi ma tuti deiriri fiyiwansoafeai wesa. Deyo, “Tofino, Saminseninei data mantauni ne nuaninu karira ne rai e? ");
INSERT INTO amk_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Negara bei wiro weboyari kaha mae ebabausa tuti eweaiteta wawerasa, nana mani negara nani doa pampang rai e? ");
INSERT INTO amk_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Tonanai kontai na munu rorong bei, wiro eweboyari kaha mae eweaiteta wesa pampang, nana mani ambori munu rorong bonani wiro doa pampang kahai ki. ");
INSERT INTO amk_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Tonanai kontai we Saminseni, masino Saminseni dapa bera mantauni aha mani, ne munu rorong foi tiabau finanai. Nana mani ambori ne mananufo nayai mutu kaha mae wioru ki. ");
INSERT INTO amk_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Nuaninu karira fosa ene tarai kariri we-wemambiriu manei minohi na ne munufoi. Tuti manei wiro suai to ne munufoi afui we wewu ne rafoi kaharai, mae wenani tefu mambiriufoia wiorahi akawuru wo, ambori wewu ne rafoi ki. Ampafe na yata nuaninu karira to boriai ne yeinawiai we ikaraikobu Saminsenia. ");
INSERT INTO amk_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Tarai, imadurai we mea mau yeyo, sasari fuba inontaraine enariri nei kiai Allai deiairi ki, tuti eteibera Allai konta fo, mae sasari tonana nei Allai deiairi kontai. ");
INSERT INTO amk_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Wape eteibera Nuaninu Mirarebana foi mani, na todoni feai kontaio Allai deiai ene sasari tonana foi kaha. Weo sasari bonani mani sasario feriri na wea kaha dine.” ");
INSERT INTO amk_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Yesusi medu tonanai, we inontarai manea eteyo, “Nuaninu kerira foi sensoni i fefe.” ");
INSERT INTO amk_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Mayeai Yesusi inanai tuti ne tahatuifosa era wei ma. Etoari na borieifo, mae etanatu kaiwo ariri we Yesusi afui, ambori da to boriei. ");
INSERT INTO amk_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Na nanai kaiwasa bitoya paria eminohi wari Yesusi, tuti emadu wei eteyo, “Daie, inamuai tuti nemu tahatuifosa etamang na borieife fo eteyo emadu ria wau.” ");
INSERT INTO amk_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Manamo Yesusi yoa wesa deyo, “Mandoni saino isahusa we nehu ai tuti nehu tahatui ne?” ");
INSERT INTO amk_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ampafe seite kaiwasa eminohi wariri foi sentenang tuti medu wesa deyo, “Botia, nehu ai tuti nehu tahatui sai nina. ");
INSERT INTO amk_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Inontarai mandoni niari kariri nehu Dai Allai ne dawiafo mani, andino isahui we nehu tahatui mang ne, nehu tahatui wiwing ne, tuti nehu ai ne.” ");
INSERT INTO amk_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Na rahida bei Yesusi da wa deunau na ruru Galilea foi aha. Na nanai kaiwasa katui ahang kaha era wa efanduhisa wariri, ampafe dautai to wafeai awa dewohi nayai, mae kaiwasa bitoya foi minohi na reifo. ");
INSERT INTO amk_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ainanaya Yesusi deunausa na ne fiyiwansoai bitoya. Na ne aunaufo, medu wesa deyo, ");
INSERT INTO amk_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Metarami ma. Weniari romi manei kia aibongfei da wa we sanami. ");
INSERT INTO amk_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Da wa kifa aibongfoi nana mani eai sawai na rangfoi, ampafe romufosa esifo ma etania kiaia. ");
INSERT INTO amk_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","6","Eai kontai sawai na kahofa wekamamiei wowongfo. Aibongfoi sikera sa rerorifoi tonanai meai, wape kameaia wofoi piara nanai siamorang aha, weo kahofafo demoyarai we newafo so aweu kaha fefe. ");
INSERT INTO amk_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Eai aha mani sawai na katai weninoi ababo foi, ampafe ninoi ababo foi sifu tamui tuti kehepania memasara ampafe wiro webong kaha. ");
INSERT INTO amk_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Wape aibongfeai aha mani sawai na kahofa beng fea, ampafe sifu biriayai paria tuti webong beng, dohona mani webong bitoya paria, wei wepiareiasura (30), wei kontai wepiatoru (60), wei aha mani wepiaring (100).” ");
INSERT INTO amk_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesusi deiriri fiyiwansoafoia kiaia nanai, deituarai aha deyo, “Mewemetarami mani metaramioai.” ");
INSERT INTO amk_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Kaiwasa bitoya foi era tateraia. Yesusi mesiri nanai, ne inontarai ewesuraya mandu fosa tuti mano erariati fosa, etutani we deikariri kariri fiyiwansoi nani mani medu kariri fifiani? ");
INSERT INTO amk_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ampafe Yesusi yoa wesa deyo, “Mea mani Allai dohong awai we mea, we mewaitawang kariri ne weMananu rorong fo tuti fi dediwara fo ampa. Wape inontarai siai fosa yeunausa na fiyiwansoai terai, ");
INSERT INTO amk_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ambori, kariri kaiwo nabi Yesaiai soi fo, amani dotu tono: ‘Ambori ewatioaia ewati wawurai, wape etafura kaha. Etaramioaia etarami wawurai, wape ewaitawana kaha. Kaiwone ne tarai tonanai, ambori wiro etaraberasa we Allai ma tuti feriri ene sasarifoi fanai.’” ");
INSERT INTO amk_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Mayeai Yesusi medu wesa aha deyo, “Metafu fiyiwansoai nini kaha e? Tonana mani fiyiwansoa siai wei fo ambori metafurai todoni ki? ");
INSERT INTO amk_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Metarami ma. Mano da kifa aibong foi mani, wedeiriri Allai ne Kaiwofoi dine. ");
INSERT INTO amk_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Aibong sawai na rangfoi mani, yiwanso inontaraio etarami Sempaisi ne Kaiwofo kariri todoni weMananufo. Wape Saminseni da ma dewa Kaiwo etaramioa fo werusa. ");
INSERT INTO amk_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Mae ne tarai tonanai kontai we aibong sawai na kahofa wekamamiei wowongfo, amani yiwanso mano etarami Kaiwofo, tuti enemirorongfoi mirising weai. ");
INSERT INTO amk_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Wape Kaiwofo wiro wenewa na enemirorongfoi kaha, ampafe etawansa tourai mae esodai dadirafeai kariri ene eroasoai tonana foa mani, wiro etoaria mutu ahang kaha, mae esu to fuia. ");
INSERT INTO amk_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Mae aibongno sawai na katai weninoi ababo fo mani, yiwanso mano etarami Kaiwofo, ");
INSERT INTO amk_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","wape earomikuayai karerai we fi nunei tuti ra nunei sofa enemirorongfoi ao sau weai, tuti fianggeng bitoya enemitituai wei foi suai to enemirorongfoi afui, kepang Kaiwofo paria wiro webong na sa ahang kaha. ");
INSERT INTO amk_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Mae aibong sawai na kahofa beng fo mani, yiwanso mano etaramio Kaiwofo, etonai afui naya mutu na enemirorongfoi. Ne tarai toyari aibongfoi wetarai bitoya fo, wei wepiareiasura (30), wepiatoru (60), tuti wepiaring (100).” ");
INSERT INTO amk_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesusi medu aha soirio fiyiwansoai bei aha deyo, “Tofino mewatioai kawuru na weaifa we manei kiai padamarang bei tuti tebung weduari na babeu bei ampa ne, ete dediwari na fata arowawahifeai fa ampa ne? Ete padamarang nani yuaisi awiai sawai paraifa ne? ");
INSERT INTO amk_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Weo fio adiwara ne kiai ambori atioai ki, tuti fio ohonai we kaiwo werorong fo kiai kontai ambori tarami parai ki. ");
INSERT INTO amk_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ampafe mandoni dino wetarang mani taraoaifa.” ");
INSERT INTO amk_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ainanaya Yesusi medu aha deyo, “Ampafe menemitituai saua weai paria kariri fianai aino metaramioai ninai. Ampafe mene metitua we inontarai siai fo mani, Allai yu we titua mea nayai kontai ki, tuti ambori ne dohonai we mea fo fuba sewa aha ki. ");
INSERT INTO amk_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Weo mandoni dino sobu awaifo ria Allai kawurua fo, ambori sobuafo fuba aha. Wape mano sobua kaha foi, ne kutu nayai nai fo kontai kia weruri ki.” ");
INSERT INTO amk_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesusi medu pari aha deyo, “Allai ne weMananu rorong ne mani ne tarai toyario ninai: inontarai manei da wa sanang patibu na ne romifoi. ");
INSERT INTO amk_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Sanamia kiai, mayeai daraberahi to ne munufoia, diru rahida firandeng ne romifoi. Mae patibufoi sifu pampang paria wetarai. Ampafe wiro deitawang kariri todoni sifu fo tuti awa wetaraifo kaha. ");
INSERT INTO amk_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kahofa sanami nai foi andino wedayari wetaraifo, reantenang mani sa nenggaingfoi ariei, mayeai nebufoi, tourai aha mani ne bongfoi aha. ");
INSERT INTO amk_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Tuti masino patibufoi miraia mani, inontaraifoi da wa detinia.” ");
INSERT INTO amk_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Yesusi dutang berahai aha deyo, “Allai ne Mananu rorong foi mani ne tarai todoni e? Ete tariwansoi na fiyiwansoi todoni bei ne? ");
INSERT INTO amk_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ne tarai toyari fiyiwansoi nini. Sawi bong bei, manei kiariao sanami na ne romifoi. Tawaitawanai we sawi bongnei mani ketui sewa raung bong ninia kiai. ");
INSERT INTO amk_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Wape sifua mani, andino fiabai sewa ne, weo werobong tuti wearirawang, ampafe romufosa wea mani esifo ma enari aisangging na arirawangfo.” ");
INSERT INTO amk_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Yesusi deunau inontaraifosa mani, deunau na fiyiwansoi bitoya kariri fi ewaitawana fo. ");
INSERT INTO amk_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Na doni kontai Yesusi deunau inontarai siai fosa mani, deunau na fiyiwansoai. Wape medu we ne inontarai erariati fosa tera mani, deiriri bauraia kasau wesa. ");
INSERT INTO amk_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Na ramindena bonani kontaio, Yesusi medu we ne inontarai dirisa fosa deyo, “Tawo to ruru eneung dowaruai.” ");
INSERT INTO amk_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ainanaya ne inontarai ewesuraya mandu fosa etau ruhiai to wa Yesusi dewohi nai foi tuti ebari arawing, etafai weru kaiwasafoi. Wa siai wei fo kontai etafai riatai. ");
INSERT INTO amk_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Waroi ahang kahai mae dedukafoi bia, andeisafoi dipuo wafoi tuti dutuwia adareti etaisui. ");
INSERT INTO amk_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Wape na wodo wafui foi Yesusi dena deirukang airukang bei. Ne inontarai erariati fosa esahu ebauni, emadu wei eteyo “Dai Mantaunaune waune, tanai rai, mae enemutituai towea kaha e?” ");
INSERT INTO amk_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesusi doabariri somara wanangfoi, medu we rurufoi aweu deyo, “Nemuboru fotou biane to.” Ainanaya wanangfoi fiotou siafoa tuti rurufoi mering na tantumara. ");
INSERT INTO amk_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ainanaya medu wesa deyo, “Todonie mematai nina? Tuti todonie meroaso yau kahai nina?” ");
INSERT INTO amk_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ampafe ematai paria tuti emadu wawerasa eteyo, “Inontarai nini mani mandoni dine antu ne, donio sua wanangnei tuti andeisanei mani mering kaririai nina?” ");
INSERT INTO amk_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Mayeaia mani Yesusi tuti ne inontaraifosa etarafuio nafarengfo na ruru eneung dowei fo, na katai wonong fino Gerasa. ");
INSERT INTO amk_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesusi arahio soa awengfo to kataifoi aweu rai mae, mangno inggira dohonia wefiauwo manei kiawariai na fafo rorong fo da wei ma. ");
INSERT INTO amk_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Inontaraifoi niayai na nanai, weo manei kontaio wiro wemambiriu we yu weduari kaha. Worahi na wai besi fo tuti na forafo kontai mae mirari finanai. ");
INSERT INTO amk_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Weo kawurua ewora warang aweng na waia mutu tonanai, wape fi eworahi nai nanai fiokahutuai tuti fiokahirairai. Wemambiriu paria ampafe mandoni kontaio yu weduari kaha. ");
INSERT INTO amk_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Diru rahida niayai dari funomai na fafofo tuti na wiwoifo. Da mae sahu dohonai tuti tetuhing wawera ne taraifoi na kamamiei. ");
INSERT INTO amk_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Niayai da tonanai, paria deti Yesusi na waroi nanai mitoa disangkapa awebuka na arongreafo. ");
INSERT INTO amk_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ainanaya bibe na mambiriu deyo, “Yesuse, Allai mano dedai sewa nei ne Kaisungne Waune, boyo bohong yau tofino? Na Allai wonongne yeyo mung kanggani yau fanai.” ");
INSERT INTO amk_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","(Inontaraifoi medu tonanai, weo Yesusi medu wei kawuru ampa, deyo inggirane waune ro kahairai weru inontarai nini.) ");
INSERT INTO amk_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ainanaya Yesusi dutang berahi deyo, “Wonomu fidoni?” Yoa wei deyo, “Wonohu fino Raifi, weo amefau paria fefe.” ");
INSERT INTO amk_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Dutang Yesusi pampang deyo, wiro data inggirafosa era weru kataifoi fanai. ");
INSERT INTO amk_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Kefang na kataifoi, na wiwoi tarareifo mani, fiai rabuangnei enaya esung. ");
INSERT INTO amk_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ampafe inggirafosa etutang Yesusi paria eteyo, “Bomi amea amesuai to fiai rabuangfoia.” ");
INSERT INTO amk_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Yesusi yoa we fi eteyoa fo ampafe inggirafosa era to boriei, tuti esuai na fiai rabuangfoi. Wedaya fiai rabuangfoi, rerai we ewepiaura wesura (2.000), mito beyaria sea na katai kenataterafo to rurufoi aweu, mirarehara kiai anina. ");
INSERT INTO amk_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Mano ewaitawang wedua fiai fosa ewati fitantumafe nanafo emitoa etaiririai na bendarifoi tuti na munue watai ruramai na nana fo we kaiwasafoi. Ainanaya kaiwasa na munue fosa era wa ewati kariri finanai. ");
INSERT INTO amk_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Era mao Yesusia nanai ewati inontaraifoi we rai inggira foi da weruia, mae minohi sensunia tuti medu funomai aha kaha. Ampafe ematai. ");
INSERT INTO amk_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Mano ewati te fitantuma Yesusi niari we inontarai inggira dohoni foi, tuti fianai aino fiaifesa esodairai nana fo, eteikaririai kariri fianai aino ewati terai nanai we kaiwasa era ma fosa. ");
INSERT INTO amk_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ainanaya kaiwasa na kataifoi, ematai paria ampafe etutang Yesusi paria we dontai weru ene kataifoi. ");
INSERT INTO amk_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesusi deyo dau to wafoi mani, inontarai rai inggira foi tifa weruia nani dutanai paria we dontai riati. ");
INSERT INTO amk_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Manamo Yesusi deiayari deyo, “Barabera wau to nemu munufoi tuti to nemu terafosa mae boikaririaifa wesa kariri fianai aino Sempaisi niari we waua ninai, tuti kariri aroafo fuba funomai we waua wa.” ");
INSERT INTO amk_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ampafe inontaraifoi da wa, wiuwuo fianai aino sodaira fo tuti kariri fianai aino Yesusi niari wei fo na nu Dekapolisi foi sentenang. Tuti kaiwasafoi pepuhung paria we kaiwofo. ");
INSERT INTO amk_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Ampafe Yesusi daraberahi to rurufoi eneung dowei foi aha. Na nafarengfo kaiwasa bitoya era ma eminohi wariri na nanai. ");
INSERT INTO amk_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Mayeaia mani inontarai wenunggamiei we munu agama Yahudi manei da we Yesusi ma, i wonong fino Yairusi. Deti Yesusi nanai disangkapa awebuka na arongreafo, ");
INSERT INTO amk_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","tuti dutani na enetawani paria deyo, “Nehu kamitung mansiari foi meninangna adareti mireha. Wape yutang we wau roa ruai waramuwara wa sauwi ambori denteng aha tuti mireha fanai.” ");
INSERT INTO amk_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ampafe da riatia. Tuti kaiwasa bitoya era riati, ewaramisiayasa pariao ene tarai sopapari kontai. ");
INSERT INTO amk_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Na kaiwasa bitoya nani, wiwing manei meninangno rika defairi. Sodai maninang nani defuina suraya boru ampa. ");
INSERT INTO amk_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ne ra minohi tutira fo dohonaia kai we biai manggarawangfosa nayai, ambori enariri denteng. Sodai dadira bitoya na ewaramifo, wape enaria tafai kiasa mae ne maninangfoi miraba aha. ");
INSERT INTO amk_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Wiwingfoi tarao kaiwo bitoya kariri Yesusi ampa. Ampafe na kaiwasa bitoya foi nani, fiononami fantamai ria Yesusi na kurufuifo tuti warangfo disangso ne ansungfo. ");
INSERT INTO amk_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Weo enetituaitai deyo, “Warahunei disangso ne ansungfo terai ki, ambori yenteng ki.” ");
INSERT INTO amk_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Na kutu nanai kontaio rika defairi foi fiotouraia, tuti niuruainsoai we dentengna. ");
INSERT INTO amk_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Na kutu siari nanai kontai Yesusi niuruainsoai we mambiriufea kawariai nai to boriei. Ampafe deti wari kaiwasa bitoya foi tuti dutansa deyo, “Mandoni dino warang disangso nehu ansungfi ne?” ");
INSERT INTO amk_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ampafe ne inontarai erariati fosa eberahi aha eteyo, “Daie, botioai we kaiwasa bitoya nei esawasara adareti ro mimoya ahang kaha. Mae butanai we mandoni dino warang disangso wau fe nina e?” ");
INSERT INTO amk_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Manamo Yesusi miaya we taraoa kaha mae deti wari kaiwasa bitoya foi we mandoni dino warangfe disangso ne ansungfe fo. ");
INSERT INTO amk_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Wiwingfoi deitawanaifa we fianai aino sodairai nanai, tuti mitaia rirora. Saha afong disangkapa awebuka na Yesusi arongreafo, mae deiai kariri fianai aino anta niari fo. ");
INSERT INTO amk_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ainanaya Yesusi medu wei deyo, “Kamitungne waune, nemu roaso yau wa wedaya bonteng ampa. Ampafe ro na maia. Tuti maninangfi kiai weru wau ampa.” ");
INSERT INTO amk_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesusi doa medu tonana rai mae, inontarai maneiru teaio etemisa era na Yairusi, mano wenunggamiei we munu agama Yahudi foi, ne munufoi ma fosa, emadu we Yairusi eteyo, “Daie, nemu kamitungfi mireha ampa. Ampafe wiro ka anseung Dai Mantaunaunei ahang fanai.” ");
INSERT INTO amk_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesusi kiobu tarang we ene kaiwofo, mae medu we Yairusi deyo, “Mutai fanai, mae roasoai terai.” ");
INSERT INTO amk_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ainanaya Yesusi da paria, wape wiro yoa we manei da riati kaha, mae kia te Petrusi, Yakobusi tuti ne tahatuio Yohanesi. ");
INSERT INTO amk_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Era wa sobu mano wenunggamiei we munu agama foi ne munufoia nanai, deti kaiwasa bitoya foi esaia etaidu paria. ");
INSERT INTO amk_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ainanaya Yesusi suai afui suasa deyo, “Fianang dino mehobu tuti mesai wei ne? Arikangwai wiro mireha kaha, mae dena.” ");
INSERT INTO amk_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ampafe emarari Yesusi paria. Mamano datasa kiai era to boriei, ainanaya kia mambewangfo suru tuti ne inontarai kia sitoru fo sitoru, esuai to rorong arikangfoi wiatai nai foi afui. ");
INSERT INTO amk_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Yu na arikangfoi warangfo medu wei deyo, “Talita kum,” nana mani deyo “Kamitungne waune, boa to.” ");
INSERT INTO amk_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Na kutu nanai kontaio kamitungfoi doabariri tuti da (weo ne defuina suraya boru ampa). Mambewangfo suru tuti Yesusi ne inontaraifo sitoru itowati fitantuma nana ampafe itopapuhung paria. ");
INSERT INTO amk_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Wape na tapapa, Yesusi deipi sitoru we wiro itoraiririai we inontarai siai fanai. Ainanaya dei we suru deyo “Murohong arikangwai dampi.” ");
INSERT INTO amk_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Na katai nanai Yesusi daraberahi tuti ne inontarai dirisa fosa to ne munuefo aha. ");
INSERT INTO amk_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Na rahida Sabati foi, da wafui deunau na munu agama Yahudi foi. Kaiwasa bitoya paria efanduhisa na nanai. Etarami Yesusi ne aunaufe nanai epapuhung paria. Emadu wawerasa eteyo, “Inontarainei sobu aunau ria mandoni weo deunau nina? Tuti awai todoni fino wedayari biriu ninai? Tuti todoni niari fitantuma fenina? ");
INSERT INTO amk_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Waitarahio i mani mano deitawang niarifi na aifi dine mae? Tuti Mariai antungfi dine. I mani ne tahatui saino Yakobusi, Yosesi, Yudasi tuti Simoni ea mae? Tuti rorowingfo sitoru itominohi kontai na munuefe ninai mae?” Ampafe emaya wei kahai mae eteiayaria. ");
INSERT INTO amk_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ainanaya Yesusi medu wesa deyo, “Nabi manei na ne munuefo tuti na ne arurarafosa mani etatori kaha, wape na katai siai mani etatori.” ");
INSERT INTO amk_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Na katai nanai Yesusi niari fitantumafeai bitoya kaha, mae inontarai itomaninang maneiru teai aino niari sitoru itobengfo, amani na yuai warangfoa wasau sitoru tuti itobeng. ");
INSERT INTO amk_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","I pepuhung paria we todonie eroasoa kahai nina. Mayeai Yesusi da wari munue watai na nana fo tuti deunau nayai. ");
INSERT INTO amk_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Sahu ne inontarai ewesuraya mandu fosa ma, demisa wemandiru tuti dohong mambiriu wesa we etata nuaninu karira fosa nayai. ");
INSERT INTO amk_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Deretawansa deyo, “Dohonao meha fieai ria mea na mene rang rorong ne fe, mae meha te mene aitatohiwa terai. Fiang, rotang tuti doi, fi tonanane mani wiro meha fanai. ");
INSERT INTO amk_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Metata te mene sapatuwa, wape wiro mesansung ansung beru fanai.” ");
INSERT INTO amk_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Tuti medu tuarai aha deyo, “Na munuefeai manei dutang mea we meminohi riati na ne munufoi mani, meminohi na munu nani paria mera weru munue nanai. ");
INSERT INTO amk_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Wape mera wa munuefeai eteiaya mea tuti emaya we etarami mea kaha mani, mera weru munue nanai, tuti mehafatitai kangganang niayai na meawemiwa, we fianawiai wesa kariri Allai ambori deiayasa fo.” ");
INSERT INTO amk_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ainanaya inontarai ewesuraya mandu fosa era wa. Era wa ewuwu Kaiwo Mahikai fo we kaiwasafosa, we todoni kontaio esahera etauberasa weru ene sasarifoi. ");
INSERT INTO amk_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Na ene rang rorong fo nanai etata nuaninu karira bitoya, tuti esari maning saituni na inontarai emaninang enenumikamieifo tuti enarisa ebeng. ");
INSERT INTO amk_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kaiwo kariri fitantuma Yesusi tuti ne inontarai dirisa fosa enari fo dafai wariai pariao mananu Herodesi taraoai kontai, weo Yesusi wewonong paria fefe. Ampafe manea enemitituai we Yesusi eteyo, “I mani Yohanesi mano webaptisi kaiwasa foi dine, andino suwi na marareha rorong fe aha ma nina. Ampafe doni wemambiriu we niari fitantumafe nina.” ");
INSERT INTO amk_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Wape manea siai emadu eteyo, “I mani nabio Eliai dine.” Manea siai kontai eteyo, “I mani nabi kariri nabi fafong fasa manei dine.” ");
INSERT INTO amk_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Herodesi tarao kaiwofo nanai deyo, “Wiro manei siai ahang kahai mae, Yohanesi mano raminde yemi ehutu rahanangfi dine. Andino suwi aha ma nina.” ");
INSERT INTO amk_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Herodesi enetituaitafo tonina: Rahida beiru teai ampa, kia ne tafuai Pilipusi binengno Herodiasi ama dauti weruria fefe. Wedaya Yohanesi suari pampang deyo, “Rau nemu tafuai binengfoi tonana mani, nari roaing hukumifo paria tuti bohong sarawai paria.” Ampafe kaiwo nanai wedaya bineng Herodiasi enerong pirahai weo miung Yohanesi. Wape sobu rahida we niari tonana kaha, weo ne mangno Herodesi suari fefe. Herodesi dino demi etafu Yohanesi, eworahi wiatai na aitamu rorong foi weru Herodiasi. ");
INSERT INTO amk_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Weo Herodesi deitawanaifa we Yohanesi mani inontarai denteng dine, tuti Allai dino demi ma ne. Ampafe Herodesi mitai Yohanesi paria, dohona mani demi ne rai mamuna ewaitawang weduari na aitamu rorong fo. Tarao Yohanesi medu mani weansarai paria, wape piraise we ne kaiwofo kontai. ");
INSERT INTO amk_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Tonanai ki wape binengno Herodiasi sobu rahida kontai we miuni, amani na rabuang bo Herodesi dohonsua ne rahida saubaunung nai foi fo. Rahida bonani Herodesi dohong muniara we ne inontarai mano eru wang dadai na katai fosa, afai mamuna baba fosa tuti mano ewewafoniai we kaiwasa na nu Galilea fosa. ");
INSERT INTO amk_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Na muniarafoi Herodiasi antuwingfoi da wa mikai dari na euremireafo. Ne mikaifo kia enemirorongfoi paria, ampafe Herodesi medu wei deyo, “Fianai aino butang weai ria yau ne mani, yohoni kiai ki.” ");
INSERT INTO amk_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ampafe, Herodesi fefora deyo, “Fianai aino butang weai we wobua fo mani ambori yohong kaririai ki, pariao yohong nu iruti nini dowei we wau kontaio yohong kaririai ki.” ");
INSERT INTO amk_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ainanaya kamitungfoi da wa dutang inana deyo, “Aie, fianai aino mai we yutang weai fa ne?” Inang yoa wei deyo, “Fi butang weai fa mani Yohanesi mano webaptisi kaiwasa foi nunggamieifoi.” ");
INSERT INTO amk_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Tatofong kutu nanai kontai, kamitungfoi daraberahia medu we Herodesi deyo, “Yeyo na kutu ninai kontaio bohong Yohanesi mano webaptisi kaiwasafoi nunggamieifoi biaini na rewangguai timba bei we yau.” ");
INSERT INTO amk_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Herodesi tarao kaiwofe nanai enerorongfoi fituayai paria. Manamo fefora kawuru na mano wenotisa fosa euremireafoa, ampafe wiro deiayari ahang kaha. ");
INSERT INTO amk_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ampafe demi ne afai mamuna fo manei we kia Yohanesi nunggamieifoi ma. Ainanaya afai mamuna foi da to munu aitamu foia, ferang kutu Yohanesi rahanangfoi nayai. ");
INSERT INTO amk_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Mayeai biaini na rewangguai timba bei, kiari ma dohoni we kamitungfoi. Ainanaya kamitungfoi kiari aha dohoni we inana. ");
INSERT INTO amk_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Yohanesi ne inontarai erariati fosa etarami fianai aino sodairai nanafo, era wa eha nehofoa esarayaia. ");
INSERT INTO amk_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Mayeai Yesusi ne rasuli ewesuraya mandu fosa etaraberasa aha ma, tuti efanduhisa ria Yesusi aha. Eteikaririaifa kariri fi fuba enari fo tuti etaunauwa fo. ");
INSERT INTO amk_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Kaiwasa bitoya paria ne da ma foi da ma, ne daraberahifoi daraberahi, wedaya Yesusi tuti ne inontarai ewesuraya mandu fosa ewawisi wape esobu rahida we etampi kaha wo. Ampafe Yesusi medu we ne inontarai ewesuraya mandu fosa deyo “Mera ma tara to katai wewui bei, ambori tameiri tata mani metenasua mene taraiwa kuteai.” ");
INSERT INTO amk_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ainanaya etautai to wafeai etafai to katai wewui beia. ");
INSERT INTO amk_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Wape etafai nanai, kaiwasa bitoya foi ewatisa we etafaifo, tuti ewaitawang katai etafai wei foi. Ampafe kaiwasa bitoya na bendari nana fo emito ewerurang reifo, etamang na katai etafai wei foia. ");
INSERT INTO amk_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Etafaia sobu nafarengfo Yesusi biari arei mani, deti kaiwasa bitoya foi we era kawuru ma enayai na nanai, detisa tonanafo arosa paria, weo ene tarai toyariao domba ene pari mantahung. Ampafe deunau fi bitoya wesa. ");
INSERT INTO amk_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Deunauwa ramindenawa mani, ne inontaraifosa emadu wei eteyo, “Daie, katainei wewui tuti dirufi kefang ampa. ");
INSERT INTO amk_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ampafe mahikai mani bemi kaiwasanei etaraberasa aha, ambori ewawori fiang na bendari tuti munue watai ruramai na nina ne we etang.” ");
INSERT INTO amk_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Manamo yoa wesa deyo, “Todoni kontaio meaino metohong fiang we etang.” Ainanaya emadu wei eteyo, “Ampafe amera wa amewori rotio harga doi dinario piaring weberu (200) ma we kaiwasa fuba nini etani e?” ");
INSERT INTO amk_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ampafe Yesusi dutansa aha deyo, “Meha roti beirua? Mera wa mewatioai.” Ainanaya, era wa ewatioaia, tuti emadu we Yesusi eteyo, “Roti tarai ring tuti diang mandu.” ");
INSERT INTO amk_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ainanaya Yesusi demi kaiwasafoi we eminohi weraibuang na ninoi wowongfo. ");
INSERT INTO amk_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Rabuang bei mani ewepiaring, manea aha mani ewepiarua sura, ampafe eminohifo weraibuang tonanai. ");
INSERT INTO amk_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Mayeai Yesusi kia roti ring fo tuti diang mandu fo, fioai ureng deti to rorafaisi tuti dutang tuti fiangfo we Allai. Ainanaya fioabau rotifo na warangfo, ambori dohonai we ne inontaraifosa we etatorai we kaiwasa bitoya foi. Niari we diangfo suru tonanai kontai. ");
INSERT INTO amk_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tuti kaiwasafoi dampi ao memosi beyari. ");
INSERT INTO amk_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Mayeai ne inontaraifosa efanduhi fiang seari foi aha mani, dangno bayai suraya boru sefang. ");
INSERT INTO amk_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Wape kaiwasa fuba dampi foi mani, mangfosa terai ewepiaura wering wering (5.000). ");
INSERT INTO amk_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Na kutu nanai kontai Yesusi demi ne inontarai ewesuraya mandu fosa etau wafo etafai fafong to ruru eneung dowei foi ahawaru, amani to katai wonong fino Betsaida foi. Mae mantauni niayaifa, demi kaiwasa bitoya foi daraberahi aha. ");
INSERT INTO amk_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Kaiwasa bitoya foi da wa kiaia, mayeai dautai to wiwoifoi ayai wenadi nayai. ");
INSERT INTO amk_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Dirua mani, ne inontaraifosa etafaia sobu ruru rabuangna. Wape mantauni niayai na reifo wo. ");
INSERT INTO amk_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Deti arau mani etohong rireusa beyari we etapa kare wanang fiabai foi fefe. Dirufoi waroia rerai we aha rorong, tarahio araha ureng botoru, Yesusi bia da na mereha wowongfo wesara. Da wa kefang wesa nanai, niari toyari deyo da to fong werusa. ");
INSERT INTO amk_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Na kutu ewatioai we da na mereha wowongfo nanai, ewaitarahio wori dine. ");
INSERT INTO amk_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ampafe ematai ebibe. Weo ea kiai ewatiaoi tuti esoisa paria. Wape Yesusi sikahera medu wesa deyo, “Mematai fanai! Menemitawanai, we Yau ne.” ");
INSERT INTO amk_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ainanaya dautai to wa ewo nai foi ayai, tuti na kutu nanai kontaio wanangfo mering. Ampefe, epapuhung paria we fitantuma nanai. ");
INSERT INTO amk_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Epapuhung tonanai weo wiro ewaitawang tururai we Yesusi ne mambiriu we dohong kaiwasa bitoya etang roti tarai ring tuti diang mandu. Etafu finana kaha weo enumikamiei mitubaru fefe. ");
INSERT INTO amk_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ewoa sobu ruru eneung dowei foia mani, etarafui na nafareng Genesareti tuti etabuhi wafoi na nafarengfoi. ");
INSERT INTO amk_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Na kutu ebiari aweu nanafo, kaiwasa na nana fosa etaroang Yesusi. ");
INSERT INTO amk_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ainanaya emito maino munue na katai nana foi, etaiririai we kaiwasafoi we Yesusi dontaifa fo. Ampafe kaiwasafoi erufafiei inontarai emaninang fosa na andaung wowong ewatai naya fo, ehasa we Yesusia. ");
INSERT INTO amk_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Na katai doni kontai aino Yesusi daoa fo, na bendari ete na munuefo ne, na katai nanai kontaio eha inontarai emaninang fosa ewatai na katai kaiwasa fianduhi nai foi. Tuti etutang Yesusi we kadono yoa wesa we ewaramifo disangso te ne ansung awerengfo ki, tuti inontarai emaninangno enari tonana fosa ebengna ehaia. ");
INSERT INTO amk_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Na rahida bei inontarai eweFarisi manea tuti mantaunau Hukumi Musai soi fo manea ebiari na Yerusalemi meu, efanduhisa ria Yesusi. ");
INSERT INTO amk_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ewati Yesusi ne inontarai erariati fosa etampi, wape eruai ewarami kariri ene koang Yahudi foi kaha. ");
INSERT INTO amk_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Weo Farisifosa tuti inontarai Yahudi wei fosa etohong kariri koang nani na mai paria. Ampafe eruai ewaramifoa kariri koang Yahudi foi kaha mani, wiro eru fiangfo we etang kaha. ");
INSERT INTO amk_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Tuti masino etaraberasa weru kondirorafoi mani wiro etampi funoma kaha, mae eruai ewarami kariri ene koangfoi akawuru wo. Tuti fi siai bitoya kontai na koangno weriria na ene werengfesa ma foi erutawania mitu kontai. Toyari, koang kariri ruai fi ampi naya tuti fi nunumpi naya, tuti fisiai tonana fo. ");
INSERT INTO amk_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ampafe donio Farisifosa tuti mantaunau Hukumi Musai soi fosa etutangbera Yesusi eteyo, “We fianie nemu inontarai eraria wau wasa wiro eruai ewarami kariri tane koang Yahudi nei kaha, mae etampi tuti ewarami werarika wa ninai? Tuti we fianie etohong kariri tane koang weriria na tane werengfosa ma foi kahai nina?” ");
INSERT INTO amk_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Yesusi yoa wesa deyo, “Inontarai menari fayafayarai di mea, kaiwo fianai aino nabi Yesayai soi kariri mea ne wetarai ampa, amani, Allai medu deyo, ‘Inontarai ninisa esomi we Yau na eboromirawa arora, wape na enemirorongfoi niayai waroi weru Yaua. ");
INSERT INTO amk_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ene esomi we Yau fo wiro wefiea kaha, aunau etaunau we kaiwasa etohong kariria fo mani, inontarai nuneisa ene aunau fine terai, wiro nehu aunau fine kaha.’ ");
INSERT INTO amk_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Tonanai kontai, Allai ne Kaiwo demi mea we metohong kariria fo, metohong kariria kaha, mae mene koang weriria na mene werengfosa aino merutawanaia mutu ne.” ");
INSERT INTO amk_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ainanaya Yesusi medu aha deyo, “Mesawai paria we meteiaya Allai ne Hukumifo, ambori merutawang mene koangfoi. ");
INSERT INTO amk_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Weo Musai soi Kaiwofeai dotu tonina: ‘Mesomi we mene dai tuti ai,’ tuti, ");
INSERT INTO amk_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Wape mea mani metaunau fi siaio na mene koangfo, amani meteyo, ‘Manei medu we ne ne dai ete ne ai deyo, “Fianai aino nehu ne, amani fi we yerara dai tuti ai muru naya ne, yohonai kawuru wekorbani we Allai ampa”,’ ");
INSERT INTO amk_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","inontarai tonana nei nana mani meteiairi we wiro fiata ne wawafo suru ahang kaha finana. ");
INSERT INTO amk_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ampafe na mene aunau metohonai tonanai we mene inontaraifesa nanai, deinawiai we meteiaya Allai ne Hukumifo. Tuti fio ne tarai tonana ne, wea bitoya menari kontai.” ");
INSERT INTO amk_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ainanaya Yesusi sahu kaiwasa bitoya foi aha ma medu wesa deyo, “Metarami nari kaiwone kiai tuti metafurai na mai. ");
INSERT INTO amk_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Fianai aino tatonai na taborominei to taenemifuisi afui fo, wiro kia rarika we tata ambori tamasi kahai na Allai arongreafo kaha, mae ne kawariai na rorongfui to boriei ne aino kia rarika ne tuti wedaya tamasi kahai na arongreafo ne. ");
INSERT INTO amk_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ampafe mewemetarami mani metaramioai.” ");
INSERT INTO amk_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Mayeai Yesusi da weru kaiwasa bitoya foi to munu minohi nai foi, arahio suki aweu minohi tonanai mae, ne inontarai erariati fosa eberahi we fiyiwansoai anta deiriria fo aha. ");
INSERT INTO amk_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ainanaya Yesusi medu wesa deyo, “Ampafe mea kontai metafu fiyiwansoai nini konta kaharai e? Mewaitawana kahai we fianai aino na boriei ne taukaharai to taenemifuisi mani wiro kia karira we tata kaha ne ne? ");
INSERT INTO amk_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Mewaitawanai we fianai aino tatang ne mani taukaharai to taenemiwairifuisi, mayeai takaheri sayarai aha. Tuti fiang nanai wiro taukaharai to taenemirorong taenemitituai nai foi kaha. (Na kaiwo medurai nanai deinawiai we fiang ani ne kiai mani wiro tane wori wea ahang kaha, mae tahasau we tatani kiai.) ");
INSERT INTO amk_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ampafe fianai aino kawariai na manei enerorong enetituaitai nai foi to boriei ariei ne aino kia rarika wei ne. ");
INSERT INTO amk_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Weo na enerorongfuisi, enetituai ne karirafo, meninawa funomai, kiamananapi, miung inontarai, riraua mae niayai ria wiwing siai ete mang siai, ");
INSERT INTO amk_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ureng fiabai we ra, enetituai we ne karira fo, pempamu, meninawa funomai na kaiwasa euremireafo, deimameatai, deiriri inontarai siai, bioi arong, tuti webonggoi. ");
INSERT INTO amk_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Fi fuba kerira nani, kiawariai na inontarai manei enerorongfuisi mani, andino dohonia werarika na Allai urengreafo ne.” ");
INSERT INTO amk_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Mayeai Yesusi da weru katai nani, da to katai kefang we bendari Tirusi. Suai to munu bei na nana afui, tuti miaya we inontarai ewaitawani we niayai na nanafo kaha. Manamo mawa we dediwa ne taraifoi weru kaiwasafoi kaha. ");
INSERT INTO amk_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ainanaya, wiwing manei ne arikangfoi nuaninu kerira dohoni, tarao Yesusi weda ma fo, ampafe da wa disangkapa awebuka na arongreafo. ");
INSERT INTO amk_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Wiwingfoi mani, wiwing Yunani dine na nu Siro-Fenisia foi. I dutang Yesusi paria we data nuaninu kerira foi weru ne arikangfoi. ");
INSERT INTO amk_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ainanaya Yesusi medu wei deyo, “Manamo arikangnesa emamoi akawuru wo, weo ka ene fiangfo ohonai we fiawerafosa we etang mani, beng kaha.” ");
INSERT INTO amk_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Manamo wiwingfoi yoa wei aha deyo, “Daie, tarai! Manamo fiawera ewatai na meja arowawahi nesa kontaio etang fiang nukahai tarirawai aweu fo.” ");
INSERT INTO amk_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ainanaya Yesusi yoa wei aha deyo, “Barabera waua, weo kaiwo modura wa deinawi nemu roasoawa fuba paria. Nuaninu kerira foi da to boriei weru nemu arikangfoi ampa.” ");
INSERT INTO amk_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Wiwingfoi daraberahi to ne munufoia mani, deti ne arikangfoi we wiatai mamunggasai na fatafoi, tuti taraie nuaninu kerira foi da weruria. ");
INSERT INTO amk_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Mayeai Yesusi da weru bendari Tirusi, da paria werurang Sidoni we nu Galilea foi aha. Da na rangno wewu rahang nu Dekapolisi foi. ");
INSERT INTO amk_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Na nanai inontarai eha wetarang pararo manei we Yesusi ma, tarangfo wedayaria borongfo maraba kontai. Etutang Yesui we yuai warangfoa wasau wenani. ");
INSERT INTO amk_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ainanaya Yesusi kia wemeninangfoi utabera weru kaiwasa bitoya foia, mayeai suba warakeha boru rarang tarahamireifo suru, mayeai kendio warangfo tuti sa warakehafoi rarang borongfo afui, we waratawang taperengfoi. ");
INSERT INTO amk_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ainanaya Yesusi fioai ureng deti to rorafaisi, mayeai fioanseng mambiriu tuti medu we inontaraifoi deyo, “Efata,” na ene kaiwo mani, “Tifaia!” ");
INSERT INTO amk_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Ampafe wemeninangfoi tarangfo suru utafai tuti na kutu nanai kontaio taperengfoi finahang we medu na mai. ");
INSERT INTO amk_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ainanaya Yesusi sua kaiwasafoi we dohonao ewuwuai funomai we manei fe. Manamo Yesusi suasa tonanai pampang wape eafo ewuwuai pampang kontai we kaiwasa siai foi. ");
INSERT INTO amk_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Kaiwasa fuba etaramioai nanisa epapuhung paria. Emadu eteyo, “Ke, fi kiai niari fo beng. Mano etarami pararo fosa etarami saha, mano eboromitamu fosa emadu na mai.” ");
INSERT INTO amk_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Na rabuang bonani kaiwasa maranding paria era ma etaramididau Yesusi ne aunaufo. Enayai na nanai awa ene pari fiangna, ampafe Yesusi sahu ne inontarai ewesuraya mandu fosa ma medu wesa deyo, ");
INSERT INTO amk_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Arohuo kaiwasa bitoya nei paria weo enayai na ninai rahida botoru mau finina, tuti ene pari fiang ampa. ");
INSERT INTO amk_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Yeyo yemisa etaraberasa to ene munufo, wape ewawisi. Dohona etawai na rang rabuang fe. Weo manea era na katai waroi fo ma fefe.” ");
INSERT INTO amk_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ampafe Yesusi ne inontarai ewesuraya mandu fosa eroa wei eteyo, “Na katai manano tonina ne, ambori amesobu fiangfeaifa na doni, we demoya kaiwasa fuba nini ne?” ");
INSERT INTO amk_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Manamo Yesusi dutansa aha deyo, “Meha roti beiru wa?” Eroa wei eteyo, “Itu kawuru.” ");
INSERT INTO amk_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ampafe Yesusi demi kaiwasafoi minohi na kahofa nuwowongfo, mayeai kia roti itu fo ma, dohong mahikai we Allai. Ainanaya fioabau rotifo na warangfo, dohonai we ne inontarai dirisa fosa we etatorai we inontarai bitoya foi, ainanaya etohong kaririaia. ");
INSERT INTO amk_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Tuti ene diang kutung maneiru teai kontai, ampafe Yesusi mioanai kontai mayeai demisa etatorai aha. ");
INSERT INTO amk_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ainanaya kaiwasafoi etampia emamosia, mayeai Yesusi ne inontaraifosa efanduhi seafoi aha. Ne sea efanduhi foi mani dang bayai itu sefang aha. ");
INSERT INTO amk_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Kaiwasa bitoya dampi nani ewepiaura wering webea (4.000). Mayeai Yesusi demisa etaraberasa to ene munu rorong fo aha. ");
INSERT INTO amk_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Mayeai i tuti ne inontarai ewesuraya mandu fosa etautai to wafeai, etafai to Dalmanutara. ");
INSERT INTO amk_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farisi maneiru teai era we Yesusi ma tuti esawari. Enari tonana weo eweanggariri ambori niari fiainawiai na rorafaisi bei wesa ambori ewaitawanai we i mani da na Allai ma. ");
INSERT INTO amk_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesusi enetituaitai paria na enerorongfoi kariri ene roasoa kaha fo, ainanaya yoa wesa deyo, “Kaiwasa fuinini mesaipaya paria tuti mehurumitare mene Sengfoi, ne tarai toyari mang manei kurutare ne wiwingfoi tuti dohong we wiwing siai. We fiani metutang we inari fitantumafeai we fiainawiai we mea kariri yau nina? Tarai, imadu we mea mau yeyo, we kaiwasa fuinini mea mani, todoni kontaio wiro inari fintantuma siai fea we mea kaha.” ");
INSERT INTO amk_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ampafe Yesusi da weru Farisifosara, dautai to wa foi tuti etafai to ruru eneung dowaruai. ");
INSERT INTO amk_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Yesusi ne inontaraifosa earomiporo eha rotio demoyarai riasa na wafoi. Eha roti tarai boyari kawuru. ");
INSERT INTO amk_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Mayeai Yesusi deretawansa deyo, “Mewaitawang weduarai tuti metanansiau we ragio na Farisifosa tuti ne Herodesi foi.” ");
INSERT INTO amk_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ampafe ne inontaraifosa emadu wawerasa eteyo, “Dohonao medu tonanai weo tane pari rotine teai?” ");
INSERT INTO amk_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Yesusi deitawang fianai aino emadu wea fo, ampafe feasa aha deyo, “We fianie memadu we meha pari rotife nina? Wiro metafurai tuti mewaitawana kaharai e? Menemirorongwa mitubaru paria ne? ");
INSERT INTO amk_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Mewemeuremi wape todoni mewati kahai nina? Tuti mewemetarami wape todonie metaramioa kahai nina? Mearomiporohai ampa ne? ");
INSERT INTO amk_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Mearomiporo roti tarai ringno raminde ifoabauraifa tuti yohonai we inontarai ewepiaura wering wering fosa (5.000) etang fea ampa ne? Tuti ne seafoi mefanduhi ma mani dang bayai beiru?” Eroa eteyo, “Bayai suraya boru.” ");
INSERT INTO amk_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Tuti we roti ituo ifoabaurai ambori yohonai we inontarai ewepiaura wering webea (4.000) fosa etangfo ampa ne? Tuti etampia kaifo mani, ne seafoi bayai beiru?” Eroa wei kontai aha eteyo, “Bayai itu sefang.” ");
INSERT INTO amk_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ainanaya Yesusi medu wesa aha deyo, “Todonie paria ninai metafu kahai nina?” ");
INSERT INTO amk_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Mayeai etafaia sobu Betsaidara, na nanai manea ebing weureng fafa manei we Yesusi ma. Tuti etutani paria we yuai warangfoa wa sauwi ambori denteng. ");
INSERT INTO amk_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesusi yu na warangfo, binti ura to bendari dereung boriei fo. Mayeai kendio urengfosuru tuti waratawang suru. Ainanaya dutani aha deyo, “Botio fieaifa ete bireri e?” ");
INSERT INTO amk_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Inontaraifoi fioai ureng detia, mayeai medu we Yesusi aha deyo, “Iwati inontarai manea era, wape iwatisa ene tarai toyari ai.” ");
INSERT INTO amk_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Mayeai Yesusi waratawang urengfo aha, nanaya mani deti na maia tuti dentengna. ");
INSERT INTO amk_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ainanaya Yesusi medu wei deyo, “Barabera wau to nemu munufoi, dohonao ro to bendarifoi afui fe.” ");
INSERT INTO amk_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Mayeai Yesusi tuti ne inontarai erariati fosa era to munue watai na bendari Kaisarea Filipi foia. Na rang rabuang dutang berasa deyo, “Kaiwasanesa emadu eteyo mandoni di yau.” ");
INSERT INTO amk_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ampafe eroa wei eteyo, “Manea eteyo wau mani Yohanesi mano webaptisi kaiwasa fi di wau. Manea aha emadu eteyo nabio Eliai di wau. Manea aha mani eteyo nabi na fafongfa manei di wau.” ");
INSERT INTO amk_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ainanaya dutang berasa aha deyo, “Wape na mantaung mea mani meteyo mandoni di yau?” Petrusi yoa deyo, “Wau mani Mananu Mampariri fi di wau.” ");
INSERT INTO amk_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ampafe Yesusi deretawansa we dohonao ewuwuai we kaiwasa siai fo kariri i weMananu Mampariri fo fe. ");
INSERT INTO amk_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Mayeai Yesusi deunau ne inontarai ewesuraya mandu fosa deyo, “Todoni kontaio Kaisung Inontarai nei ambori sodai dadira bitoya ki. Mano ewewafoniai we Yahudi fosa, imami baba fosa, tuti mantaunau Hukumi Musai soi fosa, ambori eteiayari ki. Tuti emunia mireha, wape rahida botoru aha mani suwi aha ki.” ");
INSERT INTO amk_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Yesusi meduraia kasau we ne inontarai ewesuraya mandu fosa tonanai, wape Petrusi yu bera Yesusi to fui tuti suari deyo “Modu tonana fanai!” ");
INSERT INTO amk_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ampafe Yesusi kiaberahi deti we ne inontaraifosa, mayeai sua Petrusi na tapapa paria, deyo “Ro weruai, wiro weSaminseni fanai. Weo nemu kaiwo moduraifa ne mani, kariri Saminseni ne kaiwofo. Weo fi enemutituaita wa, wiro kariri Allai ne enetituaitafo kaha, wape kariri inontarai batang.” ");
INSERT INTO amk_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Mayeai Yesusi sahu kaiwasa bitoya foi tuti ne inontarai ewesuraya mandu fosa, medu wesa deyo, “Mandoni dino deyo daria yau mani, deiaya mantauni fi dohong weai na nunei fo, tuti sodua ne aitabafoi, amani meinenang we sodai dadira kariri yau, tuti daria yau pampang. ");
INSERT INTO amk_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Weo mandoni dino de derara mantauni ne ansengfoi sewa weru daria yau mani ambori ne ansengfoi wioru ki, mae mandoni dino na nufi ninai enewawu yau tuti nehu Kaiwo Mahikai ne, awao wonohune wedaya tarahi mireha kontai ki, i ambori sobu numainufo ki. ");
INSERT INTO amk_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ampafe manei yurai we sobu nunei sentenang, wape ambori nuaninufoi wioru tuti sobu numainufo kaha mani, we fianie yurai karerai nina? ");
INSERT INTO amk_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Tuti fianai aino dohonai we yiwang nuaninufoi nai aha fo? ");
INSERT INTO amk_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Kaiwasa fui nini mani, eroaso yau aha kaha tuti enari sasari bitoya, toyari mano etohong we wiwing siai ete mang siai aha fo. Manamo mandoni mimaya we yoa tuti yau tuti nehu Kaiwone, nana mani Kaisung Inontarai nei kontai mimaya we yoa tutiri ki. Niari tonanai na rabuang bo daraberahi na Dai Allai ne sambewaraio dadai fo to nunei aha ma. Na rahida bonani, wewai rabuang emararebana fosa eweririati ki.” ");
INSERT INTO amk_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesusi medu aha deyo, “Tarai, imadu we mea mau yeyo, na mano metoari na nina ne mea, manea wiro emarareha kahai paria ewati te Allai ne weMananufo da na mambiriu ma fo.” ");
INSERT INTO amk_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Werahida wonang aha mani Yesusi kia Petrusi, Yakobusi tuti Yohanesi, itora weru kaiwasa bitoya foi, itorautai to uai dedai bei ayai. Ainanaya na tantuma Yesusi ne taraifoi yiwani siai aha na itouremireafo. ");
INSERT INTO amk_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ansung satara fo kontai bua karofaria kaiwewa tantenang. Inontarai manei fia fieaia na soda kontaio wiro bua tonana kaha. ");
INSERT INTO amk_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Mayeai na tantuma itowati Eliai tuti Musai uroa umadu ria Yesusi na nanai. ");
INSERT INTO amk_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ainanaya Petrusi medu funomai we Yesusi deyo, “Dai Rabio Mantaunaune waune, mahikai paria we tonayai na katai nini. Mahikai mani antonari warumai botoru, ambori bei we Dai wau, bei we Musai, tuti bei we Eliai.” ");
INSERT INTO amk_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Petrusi medu tonanai we serawera kaiwo fiani aino medura fo, weo itomatai karera fefe. ");
INSERT INTO amk_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ainanaya kafafe biua karofari bei sea ma sorusa, mayeai na kafafe rorong fo rawafui bei medu deyo, “Nehu Kaisungno enehuwawuti fi dinini. Metaramididauwi.” ");
INSERT INTO amk_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Rawafuifoi medua kaifo, itowati wawerahai na kataifoi tonanai amani, itowati manei ahang kaha, mae itowati te Yesusi meiri we doa ne. ");
INSERT INTO amk_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ainanaya, itobiari weru uaifoi aweufo, Yesusi deretawang sitoru deyo, dohonao itoraisaharai funongno fi anta itowatioa fo we inontarai siai manei fe. Kio Kaisung Inontarai nei suwi na marareha rorong foi akawuru wo. ");
INSERT INTO amk_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ampafe itorohong kariri fianai aino Yesusi derera fo. Wape mantaung sitoru itomadu kariri kaiwo Yesusi medurai kariri suwi na marareha rorong foi aha ma fo. ");
INSERT INTO amk_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ainanaya itorutang bera Yesusi itoreyo, “We fianaie mantaunau Kaiwo Musai soi fosa emadu eteyo, todoni kontaio Eliai dino da fafong ma akawuru wori nina?” ");
INSERT INTO amk_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesusi yoa deyo, “Tarai we Eliai da fafong ma akawuru wo, weo da we meinenang fiani kontai. Wape we fiani soi na Allai ne Kaiwofo kariri Kaisung Inontarai nei, ‘Ambori sodai dadira bitoya tuti kaiwasa enemirireuwi ki’? ");
INSERT INTO amk_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Wape imadu mau yeyo, Eliai da kawuru ma ne, tuti kaiwasa emei kanggani kariri fianai aino enemitituaita fo. Finanai kawariai karirio kaiwo dotu na Allai ne Kaiwofo wei fo.” ");
INSERT INTO amk_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Ainanaya Yesusi tuti ne inontarai mantoru fo sitoru itosobu mano fau fosara nanai, itowati kaiwasa bitoya etoawari inontarai indeata wei fosa. Mae mantaunau Hukumi Musai soi fo maneiru teai, esawasa we fieaifa. ");
INSERT INTO amk_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Kaiwasa bitoya foi ewatio Yesusi nanai, epapuhung paria ainanaya emitoa etamang wei. ");
INSERT INTO amk_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yesusi dutang bera ne inontarai indeata wei fosa deyo, “Fiani dino mantaunau Hukumi Musai soi fosa era ma esawa mea wei ne?” ");
INSERT INTO amk_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Manei na kaiwasa bitoya foi yoa wei deyo, “Dai Mantaunaune waune, nehu arikangnei nuaninu kerira dohoni awa borotamu, ampafe ikari we wau ma. ");
INSERT INTO amk_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nuaninufoi deyo dohoni mani, kifasayari aweu riroyari na kahofa nuwowongfo, kawawuaifoi tipu na borongfo, mae samu dorengnao mutu tuti ne taraifoi tiapara apai aha kaha. Yutang nemu inontaraifosa we etata nuaninu kerira foi. Enari wei, wape ebiriu kaha.” ");
INSERT INTO amk_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ainanaya Yesusi medu ne inontaraifosa deyo, “Meai arana ne? Kaiwasa fui nini mea, tarai we inontarai meroasoa di mea kaha. Inai rahang mea tuti itawang yau we mea pari kidoni wori meroasoai ki?” Mayeai medu wesa aha deyo, “Meha arikangwai ma.” ");
INSERT INTO amk_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ainanaya eha arikangfoi we Yesusia. Wape nuaninufoi detia Yesusi nanai, fiokanggimi arikangfoi ne taraifoi beyari, wedaya sawai aweu riroyari na kahofa nuwowongfo, tuti kawawuaifoi tipu na borongfo. ");
INSERT INTO amk_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ainanaya Yesusi dutang bera arikangfoi tamanai deyo, “Nemu arikangnei sodai maninang nini waroi ampa ne?” Wawafoi yoa deyo, “Maninang nini sodairi na siario ketuifa. ");
INSERT INTO amk_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","We beiru teai mauwa nuaninunei yurai we deyo miuni, ampafe kifa sayari to adia rorong fo ete to mereha rorong fo.” Ampafe dutang Yesusi aha deyo, “Daie masino biriu we fata auru mani, kadeo aromuo auru tuti fata auru.” ");
INSERT INTO amk_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesusi medu wei aha deyo, “We fianie boyo masino ibiriu nina? Taramu ma, inontarai eroasoa nesa mani ebiriu we enari fifiani kontai.” ");
INSERT INTO amk_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Na siari nanai kontaio mano ne arikangfi meninangfoi, sai deyo, “Sengne waune iroasoai, wape iroasoane fuba kaha, ampafe fata yau ambori iroasoia mutu.” ");
INSERT INTO amk_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesusi deti kaiwasafoi we era riruhiai ma fo nanai, data nuaninu kerira foia, amani suari na tapapa deyo, “Nuaninu wedaya kaiwasa etarami pararo tuti eboromitamu ne waune, yemi wau we ro to boriei weru arikangnei tuti dohonao enemukahirai we wuai aha fui fe.” ");
INSERT INTO amk_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nuaninufoi bibe rireuwi tuti fiokanggimi arikangfoi ne taraifoi aha, mayeai da to boriei weru arikangfoia. Ainanaya arikangfoi miranding beyaria, ne tarai toyari mireha fenanai, ampafe kaiwasa bitoya fianduhi foi eteyo, “Arikangfi mireha ampa.” ");
INSERT INTO amk_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Wape Yesusi yuna warangfo tuti biauni doa. Ampafe arikangfoi doaria. ");
INSERT INTO amk_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ainanaya Yesusi da to ne munu minohi nai foi afui, ne inontarai ewesuraya mandu fosa, titousa era wa etutani eteyo, “Todonie amebiriu we ametata nuaninu kerira foi kahai nina?” ");
INSERT INTO amk_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yesusi yoa wesa deyo, “Nuaninuo ne tarai tonana nei, nari fifiani kontaio wiro atari naya kaha, mae utang we Sempaisi tera reto.” ");
INSERT INTO amk_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ainanaya, era weru katai nanai tuti era paria era na nu Galilea foi. Yesusi miaya we kaiwasa bitoya foi ewaitawang kariri era toa fo fanai. ");
INSERT INTO amk_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Weo deunau ne inontarai ewesuraya mandu fosa fefe. Medu wesa deyo, “Kaisung Inontarai nei ambori manei dewayani to inontarai ewarami rorong fo we emuni ki, wape rahida bo botoru foi mani suwi aha ki.” ");
INSERT INTO amk_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ne inontaraifosa etafu fianai aino medura fo kaha. Tonanai ki, wape ematai we etutang berahai aha. ");
INSERT INTO amk_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Mayeai era wa sobu Kapernaumia. Esuai to munufoi afui, mayeai Yesusi dutang berasa deyo, “Fianang dino anta na rang rabuang mani mesawa mea wei nanai?” ");
INSERT INTO amk_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Wiro manei deiobu kaiwofeai we Yesusi ahang kaha, weo anta na rang rabuangfo mani, esawasa we mandoni dino fiebai sewa fo fefe. ");
INSERT INTO amk_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Yesusi suki aweu minohi, mayeai sahu ne inontarai ewesuraya mandu fosa, medu wesa deyo, “Mano deyo andino ne fonia fo mani, todoni kontaio ne fui ki tuti wemangfata we mandoni kontai.” ");
INSERT INTO amk_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Mayeai Yesusi kia arikang katui manei ma, tuti dohong arikangfoi doari na earomireafo. Ainanaya fiaung arikangfoi mae medu wesa deyo, ");
INSERT INTO amk_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Mandoni dino demang we arikang tonina nesa na mai na wonohune mani, wenani demang we yau kontai. Tuti mandoni dino demang we yau mani, wiro demang we yau tera kaha, mae we mano demi yau foi kontai.” ");
INSERT INTO amk_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ainanaya Yohanesi medu we Yesusi deyo, “Dai Mantaunaune waune, amewati inontarai manei data nuaninu kerira na wonomune. Ampafe amesuari, weo i mani inontarai na tata manei dine kaha fefe.” ");
INSERT INTO amk_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Manamo Yesusi deyo, “Wiro meteiweduari fanai, weo wiro manei niari fitantumafeai na wonohune, na kutu nanai kontai deibera yau kaha. ");
INSERT INTO amk_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Weo mandoni dino dapa tata kaha mani, wenani sau we tata. ");
INSERT INTO amk_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Weo tarai, imadurai we mea mau yeyo, mandoni dino dohong mereha we metunung fo, weo inontarai meraria Mananu Mamparirinei di mea fefe, ne fiembaitafo wiro nai weruri kahai ki.” ");
INSERT INTO amk_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Mandoni kontai, andino wedaya inontarai toyari arikang fininisa, amani mano eroaso yau nesa manei, niari sasari, nana mani ne mahikai sewa we wenani mani, kase kamiei fuba bei na rahanangfo tuti kabioi deisui na rawanang rausi. ");
INSERT INTO amk_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Tuti masino waramuwai wedaya sasari we wau mani, ferang kutuia. Weo nanai aino beng sewa borara nemu taraiwai ne doni aino wedaya sasari wai, wape ambori nemu taraiwai sentenang saukaha tono Sorohao Adia rorong foi, amani Adia danggararu we fitawafa foi fo. ");
INSERT INTO amk_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Weo na Soroha rorong foi mani, adiafoi fefe na wea kaha tuti awatafoi mireha na wea kaha. ");
INSERT INTO amk_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Tuti masino nari sasari na awemuwa mani, ferangkutuai tuti kobioi weruai. Weo ne mahikai mani, awemu bei keburu mae wobu numainu. Mae dohonao awemu unai ruhiai wape wobu numainufo kaha, wape wobu Soroha rorong foi fe. ");
INSERT INTO amk_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Na wanai adiafoi fefe na wea kaha tuti awatafoi mireha na wea kaha. ");
INSERT INTO amk_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Masino nari sasari na uremu bei mani, ketafatini kobioi weruai. Weo ne mahikai mani, uremu bei kibe mae wobu Allai ne Mananu rorong fo. Mae dohonao uremuwa suru ubeng ruhiai wape wuai to Soroha rorong foi fe. ");
INSERT INTO amk_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Na wanai adiafoi fefe na wea kaha, tuti awata mireha na wea kaha. ");
INSERT INTO amk_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Weo Allai dohongno adiafoi weo mansiari mansiari, toyari ai indawang fiang nayai. ");
INSERT INTO amk_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ainei mani denteng, wape meuwai ahang kaha mani, todoni wori ohoni meuwai aha ki? Ampafe todoni kontaio mene tarai tonana, amani memeuwai, tuti meminohi ruhiai na mai.” ");
INSERT INTO amk_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Mayeai era weru katai nanai to waya Yardeni eneung dowei foi, amani nu Yudea foi. Na nanai kaiwasa bitoya kontai era aha eminohi wari Yesusi. Ampafe kariri fianai aino kaiwasa bitoya mani niari fo amani deunausa. ");
INSERT INTO amk_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Tuti Farisi maneiru teai era kefani we eweanggariri, amani etutani ambori deiai Hukumi Musai soi fo. Ampafe etutani eteyo, “Kariri tane hukumi agama nei mani, mangfoi dira binengfoi rai e?” ");
INSERT INTO amk_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Yesusi yoa wesa deyo, “Kaiwo fianai aino Musai deretawanai we mea fo?” ");
INSERT INTO amk_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Eroa wei eteyo, “Musai yoa we mandoni dino dira ne wiwingfoi mani, soi surati bei kariri dirarifo tuti dohoni we wiwingfoi ambori demi da weruia.” ");
INSERT INTO amk_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ainanaya Yesusi yoa wesa deyo, “Musai soi hukumi nini tonanai, weo deitawanai we menumikamiei mitubaru, metaramididau kaiwo aunau kaha fefe. ");
INSERT INTO amk_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Wape na reantenangfo, amani reantenang Allai niari nunei mani, kaiwofo dotu tofino: ‘Allai niari inontarainesa mang tuti wiwing.’ ");
INSERT INTO amk_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Nanai wedaya mangfoi ambori sawing inang tamang suru tuti weboyari ria ne wiwingfoi, ");
INSERT INTO amk_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ambori ne tarai toyari une tarai boyari.’ Ampafe wiro uweboru ahang kahai mae uweboyari. ");
INSERT INTO amk_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ampafe fianai aino Allai fianduhiai weboyaria fo, wiro inontarai manei kia tateraifa fanai.” ");
INSERT INTO amk_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Mayeai Yesusi ne inontarai dirisa fosa esuai to munu eminohi nai foi afui, etutang berahi kariri fi anta medura fo. ");
INSERT INTO amk_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ainanaya Yesusi medu wesa deyo, “Mandoni dino dira binengfoi tuti dau wiwing manei siai aha mani, wenani niari sasari we ne wiwing mano fafong foi, amani sasario dena ria wiwing siai fo. ");
INSERT INTO amk_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Tonanai kontai we wiwing dira ne mangfoi, mae dau mang siai ahang foi, i kontai niari sasario dena ria mang siai fo.” ");
INSERT INTO amk_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Na nanai inontarai manea eha ene arikangfosa we Yesusi ma, we yuai warangfoa wasausa tuti mioansa. Manamo Yesusi ne inontaraifosa esuasa. ");
INSERT INTO amk_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesusi deti ne inontaraifosa enari tonanafo, kesousa, tuti medu wesa deyo, “Metawing arikangwasa era we yau ma, dohonao meteiweduasa fe, weo inontarai toyari arikangfesa nini saino esuai to Allai ne Mananu rorong fo ne. ");
INSERT INTO amk_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Tarai, imadu we mea mau yeyo, inontaraio wiro yoasoai tuti niari enerorongfoia tewawa kariri arikang kaha mani, wiro suai to Seng Allai ne Mananu rorong fo kaha ki.” ");
INSERT INTO amk_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Yesusi medu tonanaia kaifo fiaung arikangfosa, mayeai yuai warangfoa wasausa tuti mioansa. ");
INSERT INTO amk_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Rabuang bo Yesusi tuti inontarai fosa ete era fo, inontarai manei mito we Yesusi ma. Inontarai nani suki aweu disangkapa awebuka na arongreafo tuti medu deyo, “Mantaunau bontengne waune, fianai aino inari we ambori isobu numainufo ne?” ");
INSERT INTO amk_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesusi yoa deyo, “We fianai e wahu yau we yenteng ninai? Wiro manei denteng kahai, mae Allai meiri kawuru. ");
INSERT INTO amk_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Allai ne Hukumi dohonai we tatohong kariria fo boitawanai ampa, amani: ‘Wiro mung inontarai fanai, bena ria wiwing siai fanai, wiro komananapi fanai, binggai inontarai na kaiwo wetarai kaha fo fanai, wiro totofa manei we ka ne fianggengfo fanai, womi we nemu dai tuti nemu ai.’” ");
INSERT INTO amk_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Inontaraifoi yoa wei deyo, “Dai Mantaunaune waune, kaiwoariri fuba nani yohong kariri kawuru na iwebariboaifa ampa.” ");
INSERT INTO amk_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ainanaya Yesusi enewawu inontaraifoi seiteri tuti medu wei deyo, “Sea fi beyari bohong kariria kaharai, amani ro wa bowayang nemu ra munohi tutira wara kai, tuti doiwa bohonai we inontarai ene pari fi fosa, nanaia mani wobu ra na Waidania finanai. Tuti nari tonanaia mani ro ma ro ria yau.” ");
INSERT INTO amk_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Inontaraifoi tarao kaiwofo nanai, arokuayai paria, weo ne ra bitoya karera fefe, ampafe da weru kataifoi na enerorong fituayai. ");
INSERT INTO amk_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Yesusi seite ne inontarai erariati fosa, medu wesa deyo, “Mawa kahai we inontarai ene ra bitoya nesa esuai to Seng Allai ne Mananu rorong fo ki.” ");
INSERT INTO amk_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Ne inontaraifosa epapuhung paria we kaiwo medurai tonana fo. Wape medu wesa aha deyo, “Arikangne meaine, tarai we mawa kahai we uai to Allai ne Mananu rorong fo. ");
INSERT INTO amk_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Weo mawa sewa we unta manei suai kaha aniai kamirei bei weru inontarai ne ra bitoya manei suai to Allai ne Mananu rorong fe fo.” ");
INSERT INTO amk_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kaiwo medura fo wedaya ea epapuhung paria, ampafe etutang berahi eteyo, “Tonana mani, mandoni dino mesi we sobu faririfo ne?” ");
INSERT INTO amk_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesusi seitesa tuti medu wesa deyo, “We inontarainesa mani finanai wiro ene mambiruifea we enari kaha, wape we Seng Allai mani fifiani kontaio mawa arora.” ");
INSERT INTO amk_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ainanaya Petrusi medu wei deyo, “Daie, boti fifiani kontaio ametawinaifa tuti ameraria wau!” ");
INSERT INTO amk_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Yesusi medu wesa aha deyo, “Tarai, imadurai we mea mau yeyo, inontarai mandoni da weru ne munufoi ete ne doroi mang foi ete doroi wiwing foi, ete ne wawafo suru, ete ne arikangfosa ete ne romifo, ambori daria yau tuti wiuwu nehu Kaiwo Maihikai ne, ");
INSERT INTO amk_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nana mani wenani ambori sobu fi bitoya na rabuang bonini ki, amani ne munu, ne terafosa, inanai, ne arikang tuti ne romifo. Tuti dadirafo sodairai kontai, mae rahida da ma wanai, ambori minohi we numainu. ");
INSERT INTO amk_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Wape kaiwasa bitoyao na nunei ninai ewefonia fosa ambori enai to kurumifui ki, mae mano na nunei ninai enai to kurumifui fosa ambori ewefoniai ki.” ");
INSERT INTO amk_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Etautai era pari to bendari Yerusalemi ayai. Yesusi sahara fituayai fafong werusa, ambori ne inontaraifosa era tuari aha ki. Ne inontaraifosa earomikuayai wei paria, tuti kaiwasa bitoya wei foi kontai mitai paria. Mayeai Yesusi sahu ne inontarai ewesuraya mandu fosa ma, deikaririai wesa kariri fianai aino ambori sodaira fo. ");
INSERT INTO amk_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Medu deyo, “Metarami ma. Nina mani, tara to Yerusalemi ayai finina. Na wanai Kaisung Inontarai nei ambori manei dewayani we imami baba fosa tuti mantaunau Hukumi Musai soi fosa ki. Tuti ambori etohong aiboi marareha fo wei, mayeai etohoni pari to inontaraio etaroangno Allai kaha fosa ewarami rorong fo. ");
INSERT INTO amk_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Inontarai nanisa ambori eteiberahi, ehandioi, erarubati na wai, tuti emuni mireha. Wape rahida bo botoru foi ambori suwi aha ki.” ");
INSERT INTO amk_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ainanaya Yakobusi tuti Yohanesi, amani Zebedeusi ne arikangfo suru, ura wa umadu we Yesusi ureyo, “Dai Mantaunaune waune, aureyo nari fieai we auru.” ");
INSERT INTO amk_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Dutang suru aha deyo, “Fianai aino mureyo inari we muru ne?” ");
INSERT INTO amk_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Uroa wei aha ureyo, “Aureyo moduraia futuai we auru, we rahida ru wang Mananu fo na nemu sambewaraio dadai fo mani, bohong kataio mai fo we auru, amani manei minohi na waramu domoya wai tuti manei na waramu dowei wai.” ");
INSERT INTO amk_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Wape Yesusi yoa we suru deyo, “Muwaitawang fianai aino murutang weai nina kaha. Mubiriu we murunung nano fi dadirao yunung nai nei tuti muwebaptisi kontai na dadirao isobu baptisi nai ne rai e? Mubiriu we musodai dadira ambori isodairi foi konta rai e?” ");
INSERT INTO amk_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Uroa wei ureyo, “Aubiriu wea rai.” Ampafe Yesusi medu we suru deyo, “Nehu dadira nani murunung nai kontai, tuti muru kontai muwebaptisi na dadirao iwebaptisi nai nei. Nehu dadira nanai musodairi rai. ");
INSERT INTO amk_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Wape kariri mandoni dino ambori minohi na enehung domoya nei tuti na enehung dowei nei mani, yau wiro ikutu kaiwo kariri nana kaha. Katai nani Allai meinenami we inontarai kawuru ampa, amani mano diri suru kawuru we uminohi na nanaia fo.” ");
INSERT INTO amk_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Yesusi ne inontarai ewesura mano wei fosa etarami finanai ampefe ehasou Yakobusi tuti Yohanesi suru paria. ");
INSERT INTO amk_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ampafe Yesusi sahu kipasa ma, medu wesa deyo, “Mewaitawanaifa weo na kaiwasa etaroang Allai kaha fosa, amani Yahudi kaha fosa, mano ewenunggamiei we ene parentanei, enari kanggani ene kaiwasafoi. Tuti mano ewewafoniai fosa etanggewa ene kaiwasafoi na tapapa. ");
INSERT INTO amk_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Wape wiro mene tarai tonana kaha, mae mandoni dino deyo fiebai sewa na mea fo mani, todoni kontaio wemangfata we mea. ");
INSERT INTO amk_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Tuti mano deyo wefoniai na mea fo mani, todoni kontaio wewoming we mea akawuru wo. ");
INSERT INTO amk_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Weo Kaisung Inontarai nei kontaio wiro da ma we mefatari kaha, mae we fiata mea tuti we dohong ne taraifoi we feriri kaiwasa bitoya foi.” ");
INSERT INTO amk_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Era wao sobu bendari Yeriho foi. Ainanaya Yesusi tuti ne inontarai erariati fosa tuti kaiwasa bitoya kontai, era weru bendari Yeriho foia nanai, esobu inontarai urengfafa manei minohi na rang dereung fo mae dedo we fi. Inontaraifoi wonong fino Bartemeusi, amani Timeusi antung dine. ");
INSERT INTO amk_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Na kutu taraoai we mano da ma nani mani Yesusi inontarai Nazaretifi dine nana ne, sahu deyo, “Yesusio, Dauti ne Kaisungwa waune, aromuo yau!” ");
INSERT INTO amk_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Kaiwasa bitoya fosa esuari we nemboru, manamo tentumasa kaha, mae sahu mambiriu aha deyo, “Dauti ne Kaisungwa waune, aromuo yau!” ");
INSERT INTO amk_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ampafe Yesusi doa ukai, medu deyo, “Mesahui ma.” Ainanaya esahu inontarai urengfafa foi, emadu wei eteyo, “Tawang enemurorongwai, boabari wau, weo Yesusi sahu wau.” ");
INSERT INTO amk_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Weurengfafafoi tarao kaiwofe nanai, warapa ne ansung boriei foa watai, mae soiri tuti mito we Yesusia. ");
INSERT INTO amk_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Da wa kefangna, Yesusi dutang berahi deyo, “Fianai aino boyo inari we wau ne?” Weurengfafafoi yoa wei deyo, “Dai Rabio Mantaunaune waune, yeyo iwati.” ");
INSERT INTO amk_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Yesusi medu wei aha deyo, “Barabera wau to nemu munufoi. Nemu roaso yau wa wedaya bonteng ampa.” Na tatofang kutu nanai kontaio urengfo tabau deti. Ainanaya da ria Yesusi na ne rang rorong foa. ");
INSERT INTO amk_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Era wa kefang we Yerusalemi mani, esobu munue Betfage tuti Betania na wiwoi Saituni eneungfo. Na nanai Yesusi demi ne inontarai dirisa fosa uwemandu ura fafong. ");
INSERT INTO amk_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Medu we suru deyo, “Mura to munue watai na taaromife wanai, mura waroi afui kahai mae muwati manei tebuhi ne keledai antung manei doari na nanai. Keledai nani manei wiro dau nai kaharai. Murehuwi mukari ma. ");
INSERT INTO amk_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Tuti masino manei dutang bera muru deyo, ‘Murehu keledaiwai we fiani,’ nana mani muroa wei mureyo, ‘Sengnei andino demi auru we aukari ne, wape ambori dohoni tibera ahera aha ma ki.’ ” ");
INSERT INTO amk_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Inontarai mandu fo suru ura kariri fianai aino Yesusi demi suru ura wea foa. Na wanai uwati keledai antung manei, wenengfoi tebuhiri doari na ne munu refongfo, na rang dereungfo. Tuti urehu keledaifoia. ");
INSERT INTO amk_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Inontarai etoari na nana fosa etutang bera suru eteyo, “Tofino! Murehu keledai antungwai we fiani?” ");
INSERT INTO amk_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Uroa wesa kariri fianai aino Yesusi medurai we surua fo. Ampafe inontaraifosa eroa we ukaria. ");
INSERT INTO amk_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ukari ura wa sobu Yesusifo, etohongno ene ansung boriai feai awiai ebuaisai na keledai kuruinafoi. Ainanaya Yesusi dautai ayai minohi sauwi. ");
INSERT INTO amk_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Kaiwasa bitoya paria eha ene ansungfoa ehafarai na rangfoi, manea kontai ebuai ai tutuba eha na romifo wa sau rangfoi, ambori emaranding rangno Yesusi da nai foi. ");
INSERT INTO amk_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Kaiwasa era foni Yesusi fosa tuti mano era na kurufui fosa, esahu kiai eteyo, ");
INSERT INTO amk_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Moanafeai we tane werengno Dauti ne Mananu rorongno ambori da ma ne ki! ");
INSERT INTO amk_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesusi suai to bendari Yerusalemi afui nanai, suai to Sempaisi ne Munufoi afui. Deti kariri kataifoi tonanai, wape dirufoi kikeu, ampafe i tuti ne inontarai ewesuraya mandu fosa etaraberasa to Betania aha. ");
INSERT INTO amk_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Kameaia, na rabuangno era weru Betaniafoi mani, Yesusi wewisi. ");
INSERT INTO amk_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Na waroi detiao ai urung rowei, sifu biriayai tuti reraungfoi kehe paria. Ampafe da wa detioi we webong ete bireri e? Wape da wa sobu neungfo mani, deti sobu bong kutu bei kahaia, mae reraungfoi terai. Weo rabuang bonani mani wiro ne diru neung we niaya kaharai. ");
INSERT INTO amk_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ainanaya Yesusi deikanggani aifoi deyo, “Na rahida bonini to fongna mani, wiro webong aha we manei dang nemu bongnei kaha.” Yesusi ne inontarai dirisa fosa etarami te kaiwo medurai nanai. ");
INSERT INTO amk_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Mayea mani era wa sobu Yerusalemia. Na nanai Yesusi suai to Sempaisi ne Munufoi rofongfo, tuti data kaiwasa mano etawayangfi tuti mano ewaworifi na nana fosa. Bebari ene mejao eriwang doi naya fo tuti kaderao mano etawayang muntung we korbani fosa eminohi naya fo. ");
INSERT INTO amk_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Tuti wiro yoa we manei kia fiawayanai da rurang munu dereungfo kaha. ");
INSERT INTO amk_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Mayeai deunausa deyo, “Na Allai ne Kaiwofo medu fieai, amani dotu tonina: ‘Nehu Mununei ahui we munuo inontarai nunei kiai ewenadi nai dine,’ wape menariri wemunu mananapia.” ");
INSERT INTO amk_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Imami baba fosa tuti mantaunau Kaiwo Musai soi fosa, etarami kaiwo Yesusi medura fo, ampafe esera we rang we emuni. Wape emataiti we kaiwasa bitoya epapuhung weo ne kaiwo aunau fo. ");
INSERT INTO amk_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Dirufoi de kikeu mani, Yesusi tuti ne inontarai suraya mandu fosa era weru bendarifoia. ");
INSERT INTO amk_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Kameaia mani Yesusi tuti ne inontaraifosa era wa era rurang ai urungfoi, wape ewatioi we memasa beyari na raindengfo paria sobu newafoi. ");
INSERT INTO amk_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ampafe Petrusi aroo fianai aino Yesusi medu we aifoi na ramindenafa tuti medu we Yesusi deyo, “Dai Mantaunaune waune, botia, ai urung ramindenafa boikanggani fi memasa ampa.” ");
INSERT INTO amk_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesusi yoa wesa deyo, “Meroaso Allai. ");
INSERT INTO amk_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Tarai, imadurai we mea mau yeyo, mandoni dino medu we uai nini deyo, ‘Tuwera weru katai nini tuti taukaha rawanang rausi!’ mae enerorong soriru kaha mae yoasoai na mutu, nana mani finanai kaririai wei. ");
INSERT INTO amk_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ampafe imadurai we mea mau yeyo, metutang we fieai ria Allai mani, meroasoai we finanai mesobuai ampa, nana mani ambori mesobuai ki. ");
INSERT INTO amk_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Tuti mewenadi metutang we Sempaisi, wape menemirorong pirahai we manei mani, meteiai wenani akawuru wo, nana mani ambori mene Dai na rorafaisi kontai feriri mene sasariwai. ");
INSERT INTO amk_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Wape wiro meteiai inontarai siai ene sarawa kaha mani, mene Dai na rorafaisi kontaio wiro deiai mene sasariwai kaha.” ");
INSERT INTO amk_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Mayeaia mani era wa sobu Yerusalemia. Na siario Yesusi da na Allai ne Munufoi rorongfo, na nanai imami baba fosa, mantaunau Hukumi Musai soi fosa, tuti mano ewefoniai we Yahudi fosa era we Yesusi ma. ");
INSERT INTO amk_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Etutang berahi eteyo, “Na mandoni wonongne tuti ne mambiriune nari fi bitoya tonina fenina? Tuti mandoni dino yuai wau we nari fininaifa ne?” ");
INSERT INTO amk_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yesusi medu wesa deyo, “Yau kontai yutang bera mea we fieai, tuti finanai meteisaharai we yau mani, ambori yeisaharai kontai we mea kariri na mandoni dino yuai yau we inari fininaifa ne ki. ");
INSERT INTO amk_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Meteisaharai we yau, weo Yohanesi mano webaptisi kaiwasa foi mani, mandoni dino yuaisi we webaptisi kaiwasa tonana ne? Allai ete inontarai nunei manei e?” ");
INSERT INTO amk_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Imami baba fosa tuti mano ewefoniai we Yahudi fosa emadu kaririai wawerasa eteyo, “Masino tateyo, ‘Allai dino yuaisi we niari finana ne,’ nana mani ambori dei we tata aha ma deyo, ‘Tonana mani, we fianie wiro meroaso Yohanesi kahai nina?’ ");
INSERT INTO amk_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Wape dadira kontai we tateyo inontarai nunei manei dino yuaisi ne,” weo ematai kaiwasa bitoya foi, we eroasoai we Yohanesi mani nabi tarai dine. ");
INSERT INTO amk_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ampefe eroa we Yesusi eteyo, “Ameserawawerahai.” Ainanaya Yesusi medu wesa deyo, “Tonana mani yau kontai wiro yeikaririai we mea kaha weo mantei dino yuai yau we inari fi bitoya nini faini.” ");
INSERT INTO amk_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Mayeai deiriri fiyiwansoai bei wesa aha, amani deyo, “Inontarai manei sanang ne romi angguri bei, sanamia kiaia, ainanaya yu wore wariria. Kontai sirai kamirei we katai ehua anggurifoi nai tuti biaungno katai ne tarai toyari yawa dedai bei we ewaitawang wedua romi angguri foi nai. Ainanaya dohoni we inontarai manea we ewaitawang weduari, ambori romifoi wetarai mani etohong eai we mano ne romifoi tuti etato ei maisa. Ainanaya mano ne romifoi dontai to nu siaia. ");
INSERT INTO amk_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Niayaia tete rabuang bo romifoi wetarai fo, demi ne mangfata manei dontai we kia ne atorafo ria mano ewaitawang ne romifoi fosa. ");
INSERT INTO amk_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Manamo mano eru romifoi sa etafu mangfatafoi, eboia denteng kaha tuti etatari daraberahi na warang arora aha. ");
INSERT INTO amk_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Mayeai mano ne romifoi demi ne mangfata manei siai aha, manamo mangfata nani kontai eboisabu nunggamiei tuti eteikanggani ne woria denteng kaha, mayeai etatari daraberahi na warang arora aha. ");
INSERT INTO amk_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ainanaya mano ne romifoi demi nari mangfata mano mantoru foi aha, manamo mangfata nani kontaio etouri kahai mae emunia mirehara. Enari pampang tonanai we mangfata fuba, mano ne romifi demisa era wa nanisa. Manea eboisa, wape manea kontai emunsara emarareha. ");
INSERT INTO amk_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Demi ne mangfatafosara ehaia, titou ne kaisung mansiari enewawuti foi terai, ampafe demi mae da aha weo enetituaitai deyo, ‘Nehu kaisungnei mani, esomi wei rai.’ ");
INSERT INTO amk_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Manamo we eru romifoi sa ewati ne kaisungfoi we da ma fo nanai, emadu wawerasa eteyo, ‘Ne kaisung ambori sobu tamang fi minohi tutira fe andinini, ampafe tamunia mireha weruaia, ambori fianai aino tamang minohi tutira fo taha we tata.’ ");
INSERT INTO amk_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Etafuria tuti emunia mayeai ehabioi ariei wiatai na romi dereungfo.” ");
INSERT INTO amk_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ainanaya Yesusi bera imami baba fosa tuti inontarai ewefoniai we Yahudi fosa aha deyo, “Tofino mano ne romifoi, fifiani aino ambori dohonai we mano eru romifoi sa fo? Todoni kontaio ambori daraberahi ma tuti miung mano yoasosa we eru ne romifoi sa ki, tuti dohong romifoi we inontarai siai manea aha we ewaitawani ki.” ");
INSERT INTO amk_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ainanaya Yesusi medu aha deyo, “Metato Sengnei ne Kaiwo arawang bo dotu tonina nei kaha rai e? Amani: ‘Kamieio mano enari munu nesa ehabioi fi, andi wekamiei reantenang we etang kamieifoi doa sauwi ampa. ");
INSERT INTO amk_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Sengnei andino niari finina, tuti fi mehikai paria na tauremine.’” ");
INSERT INTO amk_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ampafe mano ewefoniai we Yahudi fosa, etarami fiyiwansoi nani fo, erurai we etafu Yesusi weo ewaitawanai we Yesusi ne kaiwo medura fo reng wesa kariri todoni eteiayari we Mananu Mampariri foi fo. Manamo ebiriu kaha, weo ematai kaiwasa bitoya foi fefe. Ampafe wiro etoari ahang kaha, mae efononansa weru Yesusia. ");
INSERT INTO amk_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Esera we rang we etafu Yesusi, ampafe rahida bei etemi Farisi maneiru teai tuti Herodesi ne inontarai erariati fosa maneiru teai, era wa we eweanggari Yesusi na fi etutang wea fo. ");
INSERT INTO amk_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ampafe era wa etutang berahi eteyo, “Dai Mantaunaune waune, amewaitawanai we wau mani inontarai enemurorong mesi di wau. Amewaitawanai kontai we bounau na mai kariri fianai aino Seng Allai medurai we inontarainesa fo, wiro tau funomai we kaiwo inontarai emadura fo kaha weo wiro womi we mano ewewonomi fosa kaha fefe. Ampafe kariri tane hukumifoi, mesi we tabai pajaki weo Mananu Kaisari ete bireri e? Tatohonai ete bireri e?” ");
INSERT INTO amk_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Manamo Yesusi deitawang enemirorong kerira foi, ampafe medu wesa deyo “We fianie meweanggari yau we metafu yau na nehu kaiwone nina? Meteinawiai we yau doi mebai pajaki nai wai ambori yeti kaririai.” ");
INSERT INTO amk_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ampafe eteinawi doi dinari bei wei. Ainanaya Yesusi dutang berasa deyo, “Mandoni dino yabani na doi finina, tuti mandoni dino wonongfe watai nai ne?” Eroa eteyo, “Mananu Kaisari.” ");
INSERT INTO amk_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ainanaya Yesusi medu wesa aha deyo, “Tonana mani metohonai we Mananu Kaisari fifiani aino Kaisari neng fo, tuti we Allai fifiani aino Allai neng fo.” Mano eteyo eweanggari nanisa, epapuhung paria we ne kaiwofo. ");
INSERT INTO amk_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Mayeai inontarai maneiru teai na inontarai eweSaduki fosa era we Yesusi ma. Ea mani inontarai Yahudi saine, wape eroasoai we inontarai emarareha nesa wiro esuwi ahang kaha. Era wa weo etutang berahi eteyo, ");
INSERT INTO amk_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Dai Mantaunaune waune, nabi Musai soi kaiwo ninai we tata, soi deyo, ‘Mang manei rirau wape sobu arikang kaharai mae mireha, nana mani ne tahatuifoi dau ne wiwingfoi aha, ambori dohong arikang we mano mireha nani ne ririafoi aha.’ ");
INSERT INTO amk_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ametaterai weo mambetahatui eweitu, mano fuba foi riraua, wape wiro une arikang kaharai mae mangfoi mireha weru wiwingfoia. ");
INSERT INTO amk_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Mayeai ne tahatui mano suari foi dauo ne wiwingfoi aha, manamo i wiro ne arikang kaharai mae mireha kontai aha. ");
INSERT INTO amk_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ne tonanane we ne tahatui mano suari foi, paria sobu mano fui pari foi kontai. Ea kiai erau wiwingfoi wape ene arikang kaharai mae emararehara. Ne fuiai pari fo wiwingfoi kontai mirehara. ");
INSERT INTO amk_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ampefe na rahida mansuwi-suwi foi mani, na mambetahatui eweitu nani fosa, mantei dino ne wiwingfoi ne? Weo mambetahatui itu fosa erau ruhi wiwingfoi fefe.” ");
INSERT INTO amk_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesusi yoa wesa deyo, “Menemitituai sarawai paria, weo wiro metafu Sengnei ne Kaiwofo tuti meroaso ne mambiriufo kaha. ");
INSERT INTO amk_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Weo rahida bo mansuwi-suwi foi mani, wiro inontarainesa erirau ahang kaha mae eminohi toyari wewai na Waidani. ");
INSERT INTO amk_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Wape kariri inontarai emarareha ne esuwi ahang fo mani, metato Kaiwo Musai soi kariri ai yafui denggararu foi ete bireri e? Na kaiwo nanai, Allai medu we Musai deyo, ");
INSERT INTO amk_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Seng Allai nani mani wiro Seng we inontarai emarareha kaha, mae i mani Seng we inontarai etarang, tuti wiro inontarai emarareha fo saino esomi wei fo kaha, mae mano etarang fosa, ansaino esomi wei ne. Nanai deinawiai we Abrahami sitoru etarang aha na Waidani ampa. Tarai, menemitituawa sarawai paria.” ");
INSERT INTO amk_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Na nanai mantaunau Kaiwo Musai soi fo manei kontai da wa, doa mae taradidau Yesusi tuti Sadukifosa kaiwo emadura fo. Mantaunau Kaiwo Musai soi foi taraoai terai we Yesusi deisaha kariri fi etutang weai nanai na mai paria. Ampafe i kontai dutang fea Yesusi aha deyo, “Na Sempaisi ne Hukumine, kaiwo fianai aino ne reantenang pari ne?” ");
INSERT INTO amk_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Yesusi yoa wei deyo, “Kaiwo reantenang ne mani dotu tono: ‘Inontarai Israeline meaine, metarami ma, Allai mani tane Seng dine, tuti manei siai ahang kahai, mae meiri terai. ");
INSERT INTO amk_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Enemuwawu Sempaisi, nemu Allai, na enemurorongwai sentenang, na numuaninuwai sentenang, tuti na enemutituaitawa sentenang.’ ");
INSERT INTO amk_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Hukumi sua aha mani, ‘Enemuwawu inontarai siai kariri enemuwawu bera mantaung wau wa.’ Wiro kaiwofeai siai aha we sewa hukumi boru nina kaha.” ");
INSERT INTO amk_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ainanaya mantaunau Kaiwo Musai soi foi yoa we Yesusi deyo, “Dai Mantaunaune waune, tarai paria. Fianai aino modurai nanai antu, weo Seng Allai mani, meiri kawurua tuti wiro seng manei siai ahang kaha. ");
INSERT INTO amk_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Tuti todoni kontaio, inontarainesa enemiwawu Seng Allai na enemirorongfoi sentenang, na ene mambiriufo tantenang tuti enemitituaitafo. Tuti ea kontai enemiwawu inontarai siai kariri enemiwawu berasa fo. Finanai aino beng sewa korbanio nunumi foi tuti korbani siai weo ohoni we Allai foi ne.” ");
INSERT INTO amk_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesusi taraoai we mantaunau Hukumi Musai soi foi ne kaiwofo sewai pariara fo, ainanaya medu wei deyo, “Ninaia mani, adareti moinenang wuai to Seng Allai ne Mananu rorong fo.” Yesusi medu kaiwofoa kai tonanafo, wiro manei wemang we dutani we fieai siai ahang kaha. ");
INSERT INTO amk_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Yesusi doa mae deunau na Allai ne Munufoi rorongfo tonanai, mayeai dutang bera kaiwasa etaramididauwi fosa deyo, “Todonie mantaunau Hukumi Musai soi fosa eteyo Mananu Mampariri nei Dauti ne Kaisung dine nina? ");
INSERT INTO amk_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Weo Dauti mantauni, Allai Nuaninunei sensoni mani medu kariri deyo, ‘Seng Allai nei medu we nehu Sengnei deyo, “Munohi na warahu domoya nei, pariao iwedaya nemu aitetanesa taha tawangsa kiai na awemuwai.” ’ ");
INSERT INTO amk_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ampafe Dauti mantauni sahu Mananu Mampariri foi we ne Sengfoi tonana mani, todonie i mani weriria terai na Dauti ma nina? Mae nanai deinawiai we Sengno Mamparirifoi dedai sewa Mananu Dauti tuti ne riria tera fo.” Kaiwasa fianduhi na Sempaisi ne Munufoi nanisa eparaise paria we etarami Yesusi deunaufo. ");
INSERT INTO amk_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Medu wesa deyo, “Metanansiau we mantaunau Kaiwo Musai soi fosa. Ea mani emirising we esansung ansung dewariroi, era tutirai na kaiwasa bitoya foi earomireafo, toyari na kondirora, ambori kaiwasa bitoya nani esomi wesa. ");
INSERT INTO amk_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Emirising we etoa na katai mahikai na munu agama Yahudi fo rorongfo tutu na muniara bei mani, emirising we etiri katai mahikai na fong fo we eminohi nayai. ");
INSERT INTO amk_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Epampamu wiwinafosa we eha fi eminohi tutira fo, tuti ewenadi mani ene nadifoi dewariroi, ambori kaiwasa bitoya fosa etatosa we inontarai ebeng disa. Inontarai nanisa aiboi esobuai ria Sempaisi fo mani, maraba pari sewa rai.” ");
INSERT INTO amk_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Na Sempaisi ne Munufoi fo, Yesusi minohi arong we katai efanduhi doi we Sempaisi nai fo tuti seite kaiwasa ehabi doi to buruao efanduhi doi nai foi. Inontarai ene ra bitoya fosa bitoya etohong doi fuba. ");
INSERT INTO amk_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ainanaya wiwina ne pari fi manei da wa, kia ne doi seni boru, kiara soniai na buruao efanduhi doi nai foi. Doi seni nani suru une hargafo katui paria. ");
INSERT INTO amk_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ampafe Yesusi sahu ne inontarai ewesuraya mandu fosa ma, medu wesa deyo, “Tarai, yeisaharai we mea mau yeyo, wiwina nini faini fi dohonai we Sempaisi fo fuba sewa kaiwasa fuba wei foi kiai ene etohonafo. ");
INSERT INTO amk_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Weo ea kiai etohonai na ene ra bitoya foi, wape wiwinanei ne pari fi tonanai ki, wape dohong doi kutu wiatai we wiori fidang naya fo awa kiai.” ");
INSERT INTO amk_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Rabuang bo Yesusi era weru Sempaisi ne Munufoi fo, ne inontarai dirisa fosa manei da ma medu wei deyo, “Dai Mantaunaune waune, botia Sempaisi ne Munufoi denteng paria. Kamiei etana fo maihikai paria.” ");
INSERT INTO amk_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ainanaya Yesusi medu wei aha deyo, “Mewati Munufoi we mehikai paria ne ne? Munu Sengno menemikandori wani ambori inontarai manea emeiria misuhi kiai, kamiei boyari kontaio wiro doa na ne katai doa nai foi ahang kahai ki.” ");
INSERT INTO amk_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Mayeai Yesusi dautai to wiwoi Saituni ayai minohi na katai wiatai arong we Sempaisi ne Munufoi fo. Ainanaya Petrusi, Yakobusi, Yohanesi tuti Andareasi itora siaia itomadu riati. ");
INSERT INTO amk_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Itorutani itoreyo, “Boikaririafa we amea, kidoni wori fi antanafa modurai nanai kawariai ki, tuti finanaifa kawaria mani ne fiainawiafo todoni?” ");
INSERT INTO amk_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesusi yoa we sitoru deyo, “Metanansiau weduarai ambori dohona inontarai etatofa mea fe. ");
INSERT INTO amk_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Weo inontarai bitoya ambori era ma eteyo emadu we mea na wonohune tuti eteyo, ‘Mano metamang wei nei di yau.’ Tuti na kaiwo emadurai tonanane etatofa kaiwasa bitoya kontai. ");
INSERT INTO amk_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kontai ambori metarami mamunafei, tuti kaiwasa emamuna wawerasa, wape dohonao mematai fanai. Ne tonanane todoni kontaio kawaria akawuru wo. Wape nanai wiro deinawiai we nunei werea nayai finana kaha. ");
INSERT INTO amk_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tonanai kontai parentafei ambori memuna we parentafei ki, tuti mananu manei ambori memuna we mananu siai manei ki. Na doni kontaio ambori mundiei beba foi fio nai ki, tuti kahari miung ki. Ne nani kiai arahio fi reantenang finanai, ne tarai toyari wiwinsanaio amaina pirahai tantuma we dawing. ");
INSERT INTO amk_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Metanansiau, weo inontarai siai ambori etafu mea tuti efafa mea to Majelisi Agama fosa ki, kontai ambori eboi mea na munu agama Yahudi fo ki. Kontai ambori efafa mea to mano ewewafonia fosa tuti mananufosa earomireafo ki, weo meroaso yau tuti meraria yau fefe. Tuti na kutu nanai mesobu rahida we memadu kariri yau wesa finana. ");
INSERT INTO amk_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Weo todoni kontaio nehu Kaiwo Mahikai fo wuwuaifa we kaiwasa na nunei sentenang akawuru wo. ");
INSERT INTO amk_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Tuti masino etafu mea tuti eha mea to mano ehutu kaiwo fosa mani, dohonao mearomikuayai we kaiwo ariri fianai aino ambori memadura fo fe. Mae fianai aino menemitituaitai we memadura fo mani, memaduraia. Weo kaiwo ariri memadurai nanai, wiro mantaung meaino menemitituaitawa kaha, mae Allai Nuaninu Mirarebana nei andino deisahara ne. ");
INSERT INTO amk_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Inontarai ambori etawayang ene doroi tera fosa we inontarai siai we emunsa ki. Ne tonanane ambori kawariai kontai we wawa mangfoi dewayang ne arikangfoi ki, tuti arikangfoi ambori dapa ne wawafosuru tuti dewayang suru we inontarai siai we emung suru ki. ");
INSERT INTO amk_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Kaiwasanei kiai ambori enemirireu mea we meraria yau fefe. Wape mandoni dino doaria mutu paria sobu werea naya fo mani ambori sobu faririfo ki.” ");
INSERT INTO amk_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Rahida bo mewati mano kerira pari tuti wedaya ne karira pari fo foi doari na katai mesi we doa nai kaha foi ki, ambori wedaya Sempaisi ne Munufoi mesi kahai ki. (Kaiwo nani todoni kontai mano metatorai nini wa mea metafurai.) Rabuang bonani mewati fi karira nani mani, inontarai enayai na Yudea fosa todoni kontaio ewawu ahera, emito to katai weuai fo we etadiwa nayai. ");
INSERT INTO amk_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Mano tete rabuang bonani niayai na ne munu refongfo wiro da wafui we kia fieai na munu rorongfo fanai. ");
INSERT INTO amk_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Mano niayai na romifoi, dohonao daraberahi to ne munufoi we kia fieai konta fe. ");
INSERT INTO amk_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Rahida nana fo, rahida karira paria we wiwinsanaifosa tuti wiwingno etinsui ui fosa, weo nana mani ewawu ahera kaha. ");
INSERT INTO amk_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mewenadi we dohonao finanai tete danunang rorong fo fanai. ");
INSERT INTO amk_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Weo na rabuang bonani, dadirao miung kaiwasafoi nani, ne dadira fuba pari fine wiro kawariai na wea kaharai, na rahida reantenang Allai niari nunei fo paria sobu ninai, tuti wiro kawariai na eai ahang kaha. ");
INSERT INTO amk_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Masino rahida nanai Allai fioukiraia tanang kaha mani, mansiari kontaio wiro kiaharai weru karira nana kaha. Wape Allai enetituai we ne inontarai dirisa fosa, amani ne inontarai yuaisa fosa, wedaya fiouki rahida nanaia tanang. ");
INSERT INTO amk_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Rabuang bonani manei medu we mea deyo, ‘Mewati! Mananu Mampariri fi andinini!’ ete ‘Mewatia-andiwani!’ dohonao meroasoa fe. ");
INSERT INTO amk_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Weo mampariri tarai kaha fosa tuti nabi tarai kaha fosa ambori ehawariai ki. Ea ambori enari fi fuba bitoya paria tuti fitantuma bitoya we enari we etatofa mano Allai dirisa fosa kontai, masino ebiriu we enarisa tonanai. ");
INSERT INTO amk_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ampafe metanansiau. Finanai kai wiro kawaria kaharai mae, yeikaririai kawuru we mea kai ampa, ambori metawai fanai.” ");
INSERT INTO amk_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Rabuang bo esodai dadira fuba pari fo kiai mani, ‘Wofaisi ambori memantiti ki, tuti embaifaisi sambewarai ahang kahai ki, ");
INSERT INTO amk_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","awahafaisi ambori tiafating na rorafaisi tuti sawai ki, tuti fi wemambiriu na rorafaisi ambori dari babiaini ki.’ ");
INSERT INTO amk_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Finanaifa kawariai akawuru wori, Kaisung Inontarai nei ambori watioi we da na kafafefo na rorafaisi meu, ne tapapafo fuba paria tuti ne sambewaraio dadai fo fiabai. ");
INSERT INTO amk_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ambori demi ne wewaifosa we efanduhi ne kaiwasa diriri foi na do wanang murang foi paria sobu do wanangfui foi, tuti na do wanangsai foi paria sobu do wanamba foi, kontai na rorafaisi reafea pari sobu reafeai.” ");
INSERT INTO amk_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Fiyiwansoai kariri ai urung nei deinawi aunaufeai fa, amani wati to aifoi we wedahamia kai, rerorifoi kiawariai aha mani, nana mani waitawanai we katu wori wemunudang ki. ");
INSERT INTO amk_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Tonanai kontai we mewatio finani kiai kawariai mani, mewaitawanai kontai we rahidafo kefang ampa. ");
INSERT INTO amk_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Tarai, imadurai we mea mau yeyo, inontarai na rabuang boninisa wiro emarareharao ehai kaharai mae finanai kawariai kawurua. ");
INSERT INTO amk_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Rorafaisi tuti nunei niai rai, wape nehu Kaiwone watai wenumainu.” ");
INSERT INTO amk_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Tonanai ki, wape kariri rahida tuti araha ureng beiru Kaisung Inontarai nei da nai ma fo, mandoni kontai deitawana kaha. Wewai na rorafaisa kontai ewaitawana kaha, Kaisung Inontarai nei kontai deitawana kaha, mae Dai mesiri andino deitawana ne. ");
INSERT INTO amk_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ampafe todoni kontaio mewaitawang weduarai tuti metanansiau pampang, weo rahidafoi mewaitawana kaha fefe. ");
INSERT INTO amk_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Finanai ne tarai toyario, inontarai dontai to katai waroi. Donta kaharai mae, demi ne mangfatafosa we ewaitawang weduari, tuti deto fi eru fo maisa we enari. We mano deitawang wedua rahutu borongfoi deretawani we deitawang beng. ");
INSERT INTO amk_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ampafe metanansiau, weo wiro mewaitawang kidoni mano ne munufoini da nai ma fo kaha. Tarahio da na ramindenafo, ete diru rabuangfo ete rerai aha buafo, ete wofoi dauta fo te. ");
INSERT INTO amk_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Ambori masino daraberahi tantuma mani, dohonao memainenang kaha fe. ");
INSERT INTO amk_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Fianai aino imadurai we me mau ninai, imadurai kontai we kaiwasane kiai, amani metanansiau pampang.” ");
INSERT INTO amk_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Rahida boru aha mani, etohonsua muniara fuba inontarai Yahudi fosa etang Roti Weragi kaha foi, tuti rahida esahui we rahida Paska foi. Na rabuang bonani, imami baba fosa tutu mantaunau Kaiwo Musai soi fosa esera we rang we etafu Yesusi na mamunggasai we ambori emuni. ");
INSERT INTO amk_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Manamo emadu wawerasa eteyo, “Wiro tanari finanai na rahida Paska foi fanai, weo nana mani kaiwasa bitoya foi ehuaya etohona rai.” ");
INSERT INTO amk_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Na kutu nanai Yesusi niai na Betania na Simoni, mano raminde nanai meninang kusta foi, ne munufoi. Rabuang bo itorampi foi, wiwing manei da weia. Wiwingfoi kiao maning niunsai mampori botori bei, maning nani ne harga dedai paria. Bioi karai botori rahanang foia, tuti yuai maningfoi sara Yesusi nungfo nai. ");
INSERT INTO amk_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Inontarai maneiruo eminohi kontai na nana fosa ewati fi niari nana fo ehasouwi, ampafe emadu wawerasa eteyo, “We fianie wiwingfoi mei funong maning ne harga dedai tonina finina? ");
INSERT INTO amk_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ne mahikai mani, maningfoi dewayani tuti doifo dohonai we mano ene pari fi fosa. Weo maningfoi ne hargafo dedai paria amani doi dinario wepiaring webetoru (300) teai.” Ampafe ehasowi paria. ");
INSERT INTO amk_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Wape Yesusi medu wesa deyo, “Metawinia! We fianie metatawari tonanai nina? Fiani aino niari we yau ninai, fi mahikai fine. ");
INSERT INTO amk_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Weo inontarai ene pari fi nesa mani, enayai rahang mea pampang na rahida neungne, ampafe masino memaya mani rahida neungne kontaio mefatasa ki. Wape yau wiro inayai rahang mea waroi ahang kaha ki. ");
INSERT INTO amk_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Wiwing nini niari fio mai wei we niari we yau fo. I sara maning niunsai mampori nei na nehu tarainei tonina ne we meinenang nehu tarainei we ambori esarai fo. ");
INSERT INTO amk_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Tarai, imadurai we mea mau yeyo, na nunei sentenang, na katai doni kontai nehu Kaiwo Mahikai fo ewuwuai naya mani, fi wiwingfi niari ninai kontaio etaiririai ki ambori earomioai.” ");
INSERT INTO amk_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ainanaya Yudasi Iskarioti, manei na Yesusi ne inontarai ewesuraya mandu fosa, da we imami baba fosara we dewayang Yesusi wesa ki. ");
INSERT INTO amk_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Rabuang bo imamifosa etarami kaiwo fenana fo, eparaise paria tuti etarerai we ambori ebai Yudasi ki. Ampafe Yudasifo sera we rahida mai we dewayang Yesusi. ");
INSERT INTO amk_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Na rahida bo reantenang etohonsua muniara Roti Weragi Kaha foi, amani na rahida Yahudifosa emung domba we fiang Paska foi, Yesusi ne inontarai ewesuraya mandu fosa etutani eteyo, “Daie, katai bodoni dino enemurorong niayai nai we amemainenang fiang Paska we wau nai ne?” ");
INSERT INTO amk_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ainanaya Yesusi demi uwemandu na ea, medu we suru deyo, “Mura to bendarifoia, na wanai ambori musobu mang manei we kia babeu bei, sefang na merehara, mura riatia. ");
INSERT INTO amk_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Munu da wa suaioi foi mani, mura wa musuai nai kontai tuti mumadu we mano ne munufoi mureyo, ‘Dai Mantaunaufoi deyo, “Rorong bodoni dino yau tutu nehu inontarai eraria yau nesa ametang fiang Paska nai ne?” ’ ");
INSERT INTO amk_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Inontarai nani ambori deinawi rorong fiebai bei na yai fo we muru. Rorong nani meinenang ampa. Mumainenang fiang Paska na nanai we tata.” ");
INSERT INTO amk_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ainanaya inontarai mandu fosuru ura to bendarifoia. Na wanai fianai aino usobua fo, mai kariri fi Yesusi medurai we surua fo. Ampafe na katai nani umainenang fiang Paska foi we ea naia. ");
INSERT INTO amk_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Dirua mani Yesusi tuti ne inontarai ewesuraya mandu fosa era to munufoia. ");
INSERT INTO amk_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Era wa eminohi etampi tonanai, mayeai Yesusi medu wesa deyo, “Tarai, imadurai we mea mau yeyo, manei na mano tatampi ruhiai nini tata ambori dewayang yau ki.” ");
INSERT INTO amk_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Etarami kaiwo fenanai enemirorong fituayai paria, ainanaya mansiari-mansiari dutang bari Yesusi aha deyo, “Daie, wiro yau kahai e?” ");
INSERT INTO amk_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesusi yoa deyo, “Inontarai nini mani, inontarai suraya mandu ne mea manei dine, amani andino soang ne rotifo ruhiai ria yau na rewangguai boyari ne. ");
INSERT INTO amk_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Tarai, Kaisung Inontarai nei ambori mireha kariri fianai aino fafongfa nabifosa esoi na Sempasi ne Kaiwofoa fo. Wape we mano dewayang Kaisung Inontarai neia mani, ambori sobu ne karirafo ki! Ne mahikai sewa we wenanifaini mani, wiro saubaunung to nunei ma fanai.” ");
INSERT INTO amk_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Rabuang bo etampi foi, Yesusi kia rotifeai dutang Sempaisi dohong mahikai wei. Ainanaya fioabau rotifoi na warangfo, tuti dohonai wesa. Yu rotifo dohonai wesa tonanai mae medu wesa deyo, “Mehari mau tuti metani, weo nehu taraifi dinini.” ");
INSERT INTO amk_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Mayeai kia nofi soni angguri nai foi, dutang Sempaisi dohong mahikai wei. Ainanaya dohong anggurifoi na nofi foi aha, we etunumi. ");
INSERT INTO amk_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Mayeai Yesusi medu wesa deyo, “Angguri nini mani nehu rika dine, rikao na Kaiwo Areraio Allai dohonai we inontarainesara fo, rikao tiwowu we kaiwasa bitoya foi. ");
INSERT INTO amk_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Tarai, yeisaharai we mea mau yeyo, angguri nini wiro yunumi ahang kahai, paria yunung angguri weworu na Dai Allai ne Mananu rorong foi.” ");
INSERT INTO amk_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ainanaya erohi rarung rowei we efiai Sempaisi, mayeai era to Wiwoi Saitunia. ");
INSERT INTO amk_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Na rang rorong era to wiwoifoia fo, Yesusi medu wesa deyo, “Mea kiai ambori mewawu taterai weru yau ki. Weo na Allai ne Kaiwo dotu tono: ‘Imung ne mantahungfoi, tuti dombafosa ambori ewawu taterai ki.’ ");
INSERT INTO amk_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Wape rahida bo isuwi aha foi mani, ambori ira foni meara isobu mea na nu Galilea foi ki.” ");
INSERT INTO amk_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Manamo Petrusi yoa deyo, “Bereri kontai. Tarahio mano wei nesa, mae yau mani todoni kontaio iwawu weru wau kaha rai.” ");
INSERT INTO amk_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesusi yoa wei aha deyo, “Tarai, imaduarai we wau mau yeyo, diru nini wiro manggohei bibe weberu kaharai mae, fofora yau webetoru kawurua, amani boyo wiro boroanso yau kaha.” ");
INSERT INTO amk_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Manamo Petrusi kikatawanai deyo, “Todoni kontai ki, paria imereha kontai ria wau, ifafora wau na wea kaha rai!” Tuti mano wei fosao, emadu tonana kontai. ");
INSERT INTO amk_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ainanaya Yesusi tuti ne inontaraifosa era to katai bei wonong fino Getsemani. Na katai nanai Yesusi medu wesa deyo, “Meminohi na ninai mae itaha tourai to wanaia iwenadi nai.” ");
INSERT INTO amk_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ainanaya kia Petrusi, Yakobusi tuti Yohanesi itora ruhiai riati. Na siari nanafo nuruainso weansarai tuti enerorong fituayai finanaya. ");
INSERT INTO amk_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ampafe medu we sitoru deyo, “Enehurorong fituayai paria nehu tarai toyari yeyo imereha. Ampafe muntonayai na ninai tuti muntorena fanai mae muntowaitawang weduarai.” ");
INSERT INTO amk_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Yesusi saha tourai waroi kuteai weru sitoru, ainanaya disangkapa awebukafo tuti dutang Sempaisi. Dutanai deyo todoni mani wiro sodai ne dadira rorong fo fanai. ");
INSERT INTO amk_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Wenadi deyo, “Daie, Wau nari fiani kontai mawa arora. Kadeo ruai fi miraba fuba isodairi nini weru yau, wape wiro kariri nehu yawiane fanai, mae kariri nemu bawiawa terai.” ");
INSERT INTO amk_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Mayeai daraberahi we ne inontarai kia sitoru fo itoru aha, wape da wa mani deti sitoru we itorenawa itowaitawang mai kaha. Ampafe medu we Petrusi deyo, “Simone bena e? Yemi wau we bena fanai mae boitawang weduaraifa araha ureng tarai boyari kawuru, wape wiro wemambiriu wea kaha.” ");
INSERT INTO amk_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ainanaya medu aha deyo, “Muntowaitawang weduarai tuti muntorutang Sempaisi, ambori Saminseni weanggari muntoru fanai. Tarai we muntonumianinuwa biriu we dohong kariri ne bengfo, mae muntone taraiwa wemambiriu kaha.” ");
INSERT INTO amk_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Mayeai Yesusi da wa dutang Sempaisi aha we kaiwo anta dutang wea fo. ");
INSERT INTO amk_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Dutanai kaifo daraberahi we ne inontaraifo sitoru aha. Wape da wa mani sobu sitoru we itorenawa, weo itouremi mamong paria fefe. Ampafe itoserawawera fianai aino itore itomadurai we Yesusi ahang fo. ");
INSERT INTO amk_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Rabuang bo Yesusi daraberahi we sitoru webetoru fo, medu deyo, “Muntowatai muntorena nendai e? Mainanaya. Rahidafe kikeu ampa we Kaisung Inontarai nei, mano dewayani foi soari to inontarai sasari fo ewarami rorong fo ampa. ");
INSERT INTO amk_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Muntoroabari muntoru ambori tora. Weo muntowati, mano dewayang yau fi da kawuru ma nina.” ");
INSERT INTO amk_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesusi doa medu tonanai we sitoru mae, Yudasi da wei ma. Yudasi nini mani Yesusi ne inontaraio ewesuraya mandu fo manei dine. Kaiwasa bitoya era riati ma, eha sondu tuti aiboi. Kaiwasa nanisa mani, imami baba fosa, mantaunau Hukumi Musai soi fosa tuti mano ewenunggamiei we Yahudi fosa, ansaino etemisa ne. ");
INSERT INTO amk_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Na antanafa, Yudasi mano dewayani foi medu wesara deyo, “Inontarai mandoni dino inunahi fo mani, inontarai dinani, metafuri. Metafuri tuti mehari, wape mewaitawang weduaria.” ");
INSERT INTO amk_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Na kutu Yudasi da ma nanai, da bau Yesusi tuti medu wei deyo, “Dai Rabio Mantaunaune waune,” mae suana niuna Yesusi. ");
INSERT INTO amk_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ainanaya eru tawang Yesusi tuti etafuria. ");
INSERT INTO amk_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Wape inontarai etoa na nana fo manei fiating ne sondufoi, doara waru ferang kutu imami fuba Kayafasi ne womingfoi tarandaungfoia fituayaia. ");
INSERT INTO amk_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ainanaya Yesusi medu wesa deyo, “Mewaitarahio yau mani inontaraio mamuna di yau e, donio meha sondu tuti aiboi mera ma we metafu yau nai nina e? ");
INSERT INTO amk_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Rahida neungne inayai yeunau pampang ria mea na Sempaisi ne Munufoi rofongfo, mae wiro metafu yau kaha. Wape todoni kontaio menari tonanai, ambori mai kariri fianai aino dotu na Sempaisi ne Kaiwofea fo ne.” ");
INSERT INTO amk_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ainanaya Yesusi ne inontarai erariati fosa ewawu taterai weruria. ");
INSERT INTO amk_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Na nanai bariboai manei da ria Yesusi na kurufui fo, i sensang wedua ne taraifoi terai na ireu lineni bei, amani ireu ne harga dedai dine. ");
INSERT INTO amk_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Raifosa eteyo etafuri kontai, ampafe warapa ireufoi erutia mae mito arora wa. ");
INSERT INTO amk_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Mayeai eha Yesusi to imami fuba foi ne munufoia. Na nanai imami baba fosa, mano ewewafoniai we Yahudi fosa tuti mantaunau Hukumi Musai soi fosa efanduhisa kiai na nanaia, amani mano esahusa we Majelisi Agama. ");
INSERT INTO amk_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Petrusifo weriria Yesusi na waroi, paria suai kontai to imami fuba foi ne munu dereungfo afui. Na nanai deti inontarai ewaitawang munufoi sa eminohi eharuru adia, ampafe da wa minohi keruru adia kontai ria sa. ");
INSERT INTO amk_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Imami baba fosa tuti Majelisi Agama fosa tantenang erurai paria we esobu inontaraio epampamu etinggai Yesusi we dohong sarawai ambori etohong aiboi marareha fo wei. Manamo wiro esobu ne sarawafea kaha. ");
INSERT INTO amk_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Esahu inontarai bitoya kontai ma we etinggai funong Yesusi wape fianai aino emadurai nanai wiro emadu robong boyari kaha, ampafe wedaya etapa wawerasa. ");
INSERT INTO amk_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ainanaya manea siai etoaria emadu funong kaiwo kariri Yesusi, ");
INSERT INTO amk_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","eteyo, “Ametarami inontarai nini medu tonina, ‘Itota Sempaisi ne Munu inontarai enariri ninia kiai, wape rahida botoru aha mani iruai bei siai aha doa, amani bo wiro inontarai enariri kaha.’ ” ");
INSERT INTO amk_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Wape kaiwo emadurai nanai kontaio wiro emadu robong boyari kaha, ampafe kaiwofo dapa wawerahai kontai. ");
INSERT INTO amk_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ampafe imami fuba foi doari rahangsa kiai awiai tuti dutang Yesusi deyo, “Todonie boromu tibau we kaiwo fuba etinggai wau weai nini kahai wei ne?” ");
INSERT INTO amk_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Manamo wiro Yesusi medu sobu kaiwofea kahai mae nemboru terai. Ainanaya imami fuba foi dutang berahi aha deyo, “Wau mani Mananu Mamparirio, Kaisung Allai mano Dedai Mirarebana fi di wau e?” ");
INSERT INTO amk_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesusi yoa deyo, “Yau aranane, tuti mea kiai ambori mewati Kaisung Inontarai nei we minohi na Allai mano weMambiriu foi warang domoya fo tuti da na kafafefo na rorafaisi meu.” ");
INSERT INTO amk_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ampafe imami fuba foi kesou paria tuti fiosiabu ne ansungfo tuti medu deyo, “Kasau we tata ampa. Mandoni dino tatutani we medu kariri ne sarawafo aha ne? ");
INSERT INTO amk_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Weo metaramioai terai na metaramine we deibera Allaifo ampa, weo deyo I mani Seng Allai ne Kaisung dine. Ampafe memadu todoni?” Ea kiai emadu beyari we eteyo Yesusi dohong sarawai, ampafe sobu aiboi marareha fo. ");
INSERT INTO amk_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ainanaya inontarai maneiru teai etoaria ehandioi. Tuti etabung wedua urengfo, ambori eboi mae eteikanggani, eteyo, “Nabine waune, bento, boroanai toyari nabi, boisaharai we mandoni dino bioi wau nei.” Mano ewaitawang weduari fosa kontai eboi. ");
INSERT INTO amk_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Petrusi doa wawerahai na munu dereungfo tonanai, wiwingno fiata imami fuba foi manei da rurami. ");
INSERT INTO amk_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Deti Petrusi we minohi keruru adiafo nanai, deroang wei na mai paria, tuti medu wei deyo, “Yesusi inontarai Nazareti foi ne inontarai erariati fe manei di wau to.” ");
INSERT INTO amk_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Manamo Petrusi fefora deyo, “Iserawawerahi tuti iwaitawang fi modurai nina kaha.” Ainanaya Petrusi dari weru katai nani da to rahutu borong fuba foi aha. Na kutu siari nanai kontaio manggohei bibea. ");
INSERT INTO amk_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Mangfata wiwing foi deti Petrusi aha, ainanaya medu we mano etoari na nana fosa, deyo, “Inontaraio eraria Yesusi fe manei dinini.” ");
INSERT INTO amk_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Manamo Petrusi fefora toyarine. Mayeai inontarai etoari na nana fosa emadu we Petrusi aha eteyo, “Wiro bereri ahang kaha, mae wau mani inontarai ro ria Yesusife manei di wau, weo inontarai Galilea di wau fefe.” ");
INSERT INTO amk_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ainanaya Petrusifo doaria feforawa mutu deyo, “Kaiwo metinggai yau weai ninai, iserawa iru na wa amangwau, yau yeroanso inontarai mano meteoi nani kaha.” ");
INSERT INTO amk_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Na tatofang siari nanai kontaio, manggoheifoi bibe weberua. Ainanaya Petrusi aro kaiwo Yesusi medurai kawuru weia fo. Medurai deyo, “Wiro manggohei bibe weberu kaharai mae fofora yau webetoru kawurua.” Ampafe Petrusifo saia denteng ahang kahai we fio niaria fo. ");
INSERT INTO amk_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Kameai kutung, mano ehutu kaiwo we Yahudi fosa kiai, amani imami baba fosa, mano ewewafoniai we Yahudi fosa, tuti mantaunau Hukumi Musai soi fosa, esahera emadu ruhi kaiwo, ainanaya ewora Yesusi warangfo tuti eharia etohoni we Pilatusia. ");
INSERT INTO amk_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Na wanai Pilatusi dutang bera Yesusi deyo, “Taraie, wau weMananu we inontarai Yahudi fesa ne ne?” Yesusi yoa wei deyo, “Yo, tonanai kariri modurawa.” ");
INSERT INTO amk_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Imami baba fosa etinggai Yesusi na fi bitoya paria. ");
INSERT INTO amk_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ainanaya Pilatusi dutani aha deyo, “Maya we fobai boromuwai kaha e? Taramu fi inggairai bitoya paria eru eso wau nai mau ne kaha e?” ");
INSERT INTO amk_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Manamo Yesusi wiro medu sobu kaiwo kuteai ahang kaha, wedaya Pilatusi pepuhung paria. ");
INSERT INTO amk_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Na rahida fuba Paska foi neungfo mani, Pilatusi ne koang we sawingno inontarai ewatai na aitamu rorong fo manei da to boriei, kariri kaiwasa bitoya foi etiriafo. ");
INSERT INTO amk_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Inontarai manei wonong fino Barabasi, wiatai na aitamu rorong fo, weo miung inontarai kontai na rabuang bo emamuna we parenta Roma foi ne. ");
INSERT INTO amk_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Ampafe kaiwasa bitoya foi era ma we etutangno Pilatusi we sawingno mano ewatai na aitamu rorong fo manei, kariri fianai aino na fafongfo niaria fo. ");
INSERT INTO amk_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ainanaya Pilatusi dutansara deyo, “Memaya we itawingno Mananu Yahudi nei we mea re?” ");
INSERT INTO amk_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Weo Pilatusi deitawanaifa we imami baba fosa enemirorong pirahai we Yesusi ampafe doni ehari ma nina. ");
INSERT INTO amk_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Manamo imami baba fosa eha we kaiwasa bitoya foi enemirorongfoi ambori etanggewa Pilatusi we sawingno Barabasi wesa. ");
INSERT INTO amk_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ampafe Pilatusi medu we kaiwasa bitoya foi aha deyo, “Tonana mani inari fiani we inontaraio mesahui we Yahudinesa ene Mananufi ne?” ");
INSERT INTO amk_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ebibe kiai tantenang beyari eteyo, “Pahui na aitabafoi.” ");
INSERT INTO amk_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilatusi berasa aha deyo, “Wape fisarawaio todoni fino niari ne?” Manamo esahu mambiriu nariai aha eteyo, “Pahui na aitabafoi!” ");
INSERT INTO amk_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilatusi niari we sona kaiwasa bitoya foi enemirorongfoi ampafe sawingno Barabasi wesara. Mayeai demi inontarai eruba Yesusi, ainanaya dohoni wesara we epahui na aitabafoi. ");
INSERT INTO amk_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Mayeai Pilatusi ne afai mamuna fo manea eha Yesusi to ene munu fiabai eminohi nai foi afui, ainanaya esahu ne afai mamuna fosa kiai we efanduhisa na nanai wari Yesusi. ");
INSERT INTO amk_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ainanaya esansung Yesusi na ansung kehe rawanderio ne hargai dedai feaia satarai, nana mani, ansung boriei toyari ansungno mano ewemananufosa esansunsa nai fo. Tuti etaya fi na ai arirawang weababo fo bei wesapewi mananu ambori etatari na nungfoi. ");
INSERT INTO amk_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Mayeai enari anggari we esomi wei eteyo, “Inontarai Yahudi ne ene mananune waune, amefiai wau!” ");
INSERT INTO amk_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Eboi Yesusi nunggamieifoi na aitatohi tuti ehandioi, ainanaya etisangkapa eawemibuka mae esomi wei. ");
INSERT INTO amk_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Emei kanggania kaia fo, etisu ansung kehe rawanderi fo werui mae etohong mantauni ne ansungfo nari aha satarai. Mayeai ehari to boriei weru munufoi we epahui na aitabafoi. ");
INSERT INTO amk_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Na rang rorong era to katai epahu Yesusi nai foi, ehanggung inontarai manei na rang rabuang, inontarai nani arahi da na munuefeai to bendarifoi aha. Wonong fino Simoni, i inontarai Kirene dine, amani Aleksanderi tuti Rufusi utamami dine. Na nanai afai mamuna fosa erutawani etemi sodua Yesusi ne aitabafoi. ");
INSERT INTO amk_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ainanaya eha Yesusi to katai wonong fino Golgota, nana mani, Woming Nungkamiei. ");
INSERT INTO amk_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Na nanai eteyo etohong anggurio etadoanai na murifeai awa dunung, manamo Yesusi dunung kaha. ");
INSERT INTO amk_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Mayeai epahu Yesusi na aitabafoia, tuti ehabi onde we etato ne ansungfo maisa. ");
INSERT INTO amk_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Nanaya mani, kameai araha ureng indeata, epahu Yesusi na aitabafoi. ");
INSERT INTO amk_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Na aitaba nunggamieifoi esoi kaiwofea kariri fi etinggairi wea fo, amani dotu tono Mananu Inontarai Yahudi Dinini. ");
INSERT INTO amk_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Epahui sau rahang inontarai ukamananapi mandu, manei sau na eneung domoya foi tuti manei sau na eneung dowei foi. ");
INSERT INTO amk_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Na tonanane mai kariri Sempaisi ne Kaiwo dotu tono: ");
INSERT INTO amk_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Kaiwasa fuba da na nana foi ehimi enumi tuti eteiberahi eteyo, “E, inontarai boyo tota Sempaisi ne Mununei tuti rahida botoru ruaisi aha ne waune. ");
INSERT INTO amk_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Into wemambiriu tonana mani biari weru aitabawai tuti waramuira karira ninai weru wau.” ");
INSERT INTO amk_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Imami baba fosa tuti mantaunau Hukumi Musai soi fosa eteibera Yesusi kontai. Emadu wawerasa eteyo, “I mani feriri inontarai siai, wape wemambiriu we feriri bera mantauni kaha.” ");
INSERT INTO amk_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Tuti eteyo, “Masino i mani Israeline tane Mananuo weMananu Mampariri fi dine mani, tonana mani bia weru aitabafoi to, ambori tawati teraifa mani taroasoai.” Inontarai mandu epahu suru kontai fo suru urei kanggani Yesusi kontai. ");
INSERT INTO amk_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Tete rahida rabuang araha ureng suraya boru, na tantuma kataifoi memantiti sentenang paria sobu araha ureng botoru. ");
INSERT INTO amk_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Tuti tete ramindena araha ureng botoru foi, Yesusi bibe fuba deyo, “Eloi, Eloi, lama sabaktani?” nana mani deyo, “Dai Allai, Dai Allai, todoni tawing yau nina?” ");
INSERT INTO amk_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Inontarai maneiru teaio etoa kefang na nana fosa etaramio Yesusi bibe fo tuti eteyo, “Metaramia sahu we nabi Eliai.” ");
INSERT INTO amk_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Inontarai manei na kaiwasa nanisa sikaherawa kia mandafeai, yorang na angguri sisasa feai, mayeai kia aifarang bei ma disanai nai, ainanaya subarai to Yesusi borongfo ayai. Mae medu deyo, “Tatamang tawaitawanai we Eliai da ma suki weru aitabafoi rai ete bireri e?” ");
INSERT INTO amk_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ainanaya Yesusi bibe fuba beyaria aha na rawafui tapapa, mayeai kiaharaia. ");
INSERT INTO amk_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Na siari nanai kontaio ireu aburung sau wetaba na Sempaisi ne Munufoi rorongfo miabu weberu, na yaifo paria sobu kofafo. ");
INSERT INTO amk_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Rai mamuna ene mano wenunggamiei doari na nana foi, deti terai todoni Yesusi mireha toa fo nanai, medu deyo, “Tarai, inontarai nini Allai ne Kaisung dine!” ");
INSERT INTO amk_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Na nanai wiwing maneiru teai etoari na waroi ewati kariri fianai aino Yesusi sodaira fo. Wiwingfosa mantoru itowonomi fino Salome, Maria Makdalenai, tuti Maria Yakobusi mano katui tuti Yosesi uinamifoi. ");
INSERT INTO amk_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Wiwing nini sitoru na raminde Yesusi niayai na nu Galilea foi mani itora riati tuti itofatari ne. Tuti wiwing siai bitoya kontai efanduhisa na nanai. Wiwing nanisa era ria Yesusi kawuru ma enayai na bendari Yerusalemi ampa. ");
INSERT INTO amk_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Wofoi rerai we sawaia tuti nana mani rerai we rahida Sabati foi finana. Weo rahida bonani mani rahida mainenang fi we rahida Sabati foi fefe. ");
INSERT INTO amk_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ampafe inontarai manei wonong fino Yusupi, i inontarai na bendari Arimatea dine, da ma. I kontai yuo wang Majelisi Agama fo tuti kaiwasa esahu suari, tuti i yoasoa tuti demang na mai paria we rahida bo Allai weMananufo. Kia ne tarai da wa dutang Pilatusi we kia Yesusi ne taraifoi ambori sirai. ");
INSERT INTO amk_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilatusi taraoai we Yesusi mirehara fo nanai, pepuhung. Ampafe demi inontarai manei da wa sahu mano wenunggamiei we afai mamuna fosa ama dutang berahi we tarai e Yesusi mireha ampa ne. ");
INSERT INTO amk_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Mano wenunggamiei we afai mamuna fosa deikariri kariri ne mireha toa fo kai we Pilatusia, ampafe yoa we Yusupi ne kaiwo dutang wea foa. ");
INSERT INTO amk_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ainanaya Yusupi wiorio ireu lineni (ne harga dedai) beia, mayeai da wa su Yesusi na aitabafoi meu, sensani nayai. Mayeai kiaria dohoni wia na fafo dahi na wiwoi wekamiei dereung fo. Ainanaya, dedoi kamiei fiabai beia wia kobu fafo borongfoa. ");
INSERT INTO amk_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Maria Makdalenai tuti Mariai mano Yosesi inanai uwati te katai esarai nai foi kontai. ");
INSERT INTO amk_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Rahida Sabati foi kiaia fo, Maria Makdalenai, Mariai mano Yakobusi inanai tuti Salome, itowaworio finunsai mampori fo, itoha itora to fafo foi we itosara Yesusi ne taraifoi nai. ");
INSERT INTO amk_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ampafe kameai kutung na rahida bo reantenang, amani rahida Minggu foi, wofoi arahio fioairi, mae wiwingfo sitoru itora to fafofoia. ");
INSERT INTO amk_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Na rang rabuang itomadu wawera sitoru itoreyo, “Mandoni dino awa mani fiata totoru we dedoi kamieifoi weru fafo borongfo ne?” ");
INSERT INTO amk_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Weo kamieifoi fiabai paria fefe. Itomadu tonanai, mae itofobera itouremi itowatia mani, kamieifoi dedoia wia siai weru fafo borongfoi. ");
INSERT INTO amk_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ainanaya itosuai to fafofoi afui mani itowatio bariboai manei, ansung satara fo dewaroi bua karofari paria, minohi na eneung domoya fo. Ampafe itosoi sitoru paria. ");
INSERT INTO amk_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Bariboaifoi medu we sitoru deyo, “Muntomatai fanai, iwaitawanai we muntosera we Yesusi inontarai Nazareti mano epahui na aitabafoi nani. Manamo wiatai na ninai kaha, weo suwi ampa. Muntowati te katai etohoni wiatai nai fi dinini. ");
INSERT INTO amk_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ampafe muntora wa muntoraikaririai we ne inontarai erariati wasa, kontai Petrusi. Muntoraikaririai muntoreyo, ‘Da foni meara demang mea na nu Galilea fi fo. Na wanai ambori mewatioi ki, kariri kaiwo medurai we meara fo.’ ” ");
INSERT INTO amk_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ainanaya itora to boriei weru fafofoi nanai, itowawu, we itomataia itorirora fefe. Itowawua fo wiro itoraisaha sobu kaiwofo we manei ahang kaha, we itomatai karera fefe. ");
INSERT INTO amk_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Rahida Minggu kameai kutung Yesusi suwi na marareha rorong fea fo, dare deinawi ne tarai we ne inontaraifosa. Reantenang mani we Maria Makdalenai (Mariai nini andino raminde Yesusi data nuaninu kerira itu werui ne). ");
INSERT INTO amk_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ainanaya Mariai da wa deikaririai we Yesusi ne inontarai erariati fosa. Ea mani, enemirorong fituayai, esai we Yesusia. ");
INSERT INTO amk_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Etaramioai we Yesusi suwi na marareha rorong foi ampa tuti deinawi ne tarai we Mariai, wape wiro eroasoa kaha. ");
INSERT INTO amk_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Mayeai Yesusi deinawi ne tarai siai aha we ne inontarai mandu ura to munuefea fo. ");
INSERT INTO amk_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ampafe urarabera suru we mano efau fosa aha, we ureikaririai kariri Yesusi wesa. Manamo eroasoa kahai kontai. ");
INSERT INTO amk_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Yesusi ne inontaraifosa eminohi etampi tonanai, mayeai na tantuma Yesusi kiawariaiosa. Suasa we eroasoai turura kahai tuti enumikamieifoi mitubaru paria. Weo kaiwo etaramioai ria inontarai mano ewati te Yesusi we suwi ahang fosa fo wiro eroasoa kaha. ");
INSERT INTO amk_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ainanaya medu wesa deyo, “Mera wariai to nunei sentenang, we mewuwu nehu Kaiwo Mahikai we kaiwasafoi sentenang. ");
INSERT INTO amk_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Mandoni dino yoasoa kaha mani ambori sobu Sorohafoi, mae mandoni dino yoasoai tuti webaptisi mani ambori kiaharai weru Sorohafoi. ");
INSERT INTO amk_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Fiainawiai kariri eroasoafo mani, inontarai eroasoai nanisa ambori etata nuaninu kerira fosa na wonohune, tuti ambori emadu na inontarai siai ene kaiwofo. ");
INSERT INTO amk_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Kontai ambori eru tawaifosa wape esodai ne karirafea kaha tuti etunung fi memu foi wape memusa kaha. Tuti eruai ewaramifoa wasau inontarai emaninang fosa mani, ambori ebeng ki.” ");
INSERT INTO amk_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Seng Yesusi medu riasara kaifo, dautai to rorafaisia. Na nanai minohi na Seng Allai warang domoya foi. ");
INSERT INTO amk_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ampafe ne inontarai fosa etaraberasa tuti ewuwu ne Kaiwo Mahikai fo to katai doni kontai na nunei sentenang. Tuti Sengnei kontai sawing warang kaha, mae yufi riasa, deinawi ne tonanane na fitantuma fuba niari na sa fo. Antu. ");
INSERT INTO amk_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Wau, Teopilusi inongwa di wau, yau Lukasi yenatu kaiwoariri we Dai wau. Inontarai efau enemitituaitai erurai we etoi etang kaiwo kariri Seng Yesus Kristusi tuti fi niari rahang tata kawurua fo, ");
INSERT INTO amk_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","masi karirio fio mano wemangfata we Kaiwo Mahikai fo, amani mano na reantenang ewati teri fosa, fi etaiririai we tata fo. ");
INSERT INTO amk_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Mantaung yau kontaio irurai we iwaitawang kariri finanai kai na masi, na reantenang pari fo, ampafe enehutituaitai mai we yau kontai we isefa kaiwone na mai we Dai bohi Teopilusi wau mau. ");
INSERT INTO amk_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ambori wau boitawanai weo kaiwoariri etaunauwai we wau wa mani tarai antu. ");
INSERT INTO amk_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Rabuang bo Herodesi wemananu na Yudea fo, imami manei wonong fino Zakariai, nano Abiai ne imami rabuangfoi. Binengfoi kontai weriria na imami Haruni, wonong fino Elisabeti. ");
INSERT INTO amk_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Uru mani umai nano Seng Allai urengreafo, urohong kariri ne Hukumifoi tuti ne kaiwo pondoaia fo na mai. ");
INSERT INTO amk_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Wape une pari arikang, weo Elisabeti kirawahi, tuti uweinonggutung ampa. ");
INSERT INTO amk_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Na rahida bei Abiai ne imami rabuangfoi enari fi imami fo, amani Zakariai niari kontai weo Seng Allai. ");
INSERT INTO amk_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Mayeai ehabi onde, kariri imamifosa ene koang, weo mandoni dino da to Rorong Mirarebana foi na Munu Seng foi weo niunung finunsai mampori we Seng Allai. Aweu mani tatera fino Zakariai. ");
INSERT INTO amk_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Zakariai da afui niunung finunsai mampori fo mae kaiwasa bitoya efanduhisa na boriaifo tuti ewenadi. ");
INSERT INTO amk_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Mayeaia mani Zakariai detio Sempaisi ne wewai manei doa na mesbao niunung finunsai mampori naya fo eneung domoya fo. ");
INSERT INTO amk_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Zakariai detioi fo soiri tuti mitai. ");
INSERT INTO amk_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Manamo wewaifoi medu wei deyo, “Zakariae, mutai fanai. Weo nemu nadiwai Sempaisi taraoi tuti dohong kariri ampa. Binemu Elisabeti ambori minohi tuti kaisung manei ki. Bohong te wonong fino Yohanesi. ");
INSERT INTO amk_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Wau murarising tutu puraise rai, kontai kaiwasa bitoya wai emararising weo arikangwai, ");
INSERT INTO amk_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","weo weinontarai fuba na Sempaisi urengreafo. I mani wiro dunung angguri ete ye kaha. Arikang nini inang minohi tutiri kaharai mae Sempaisi Nuaninu Mirarebana foi sensoni kawuru na inang enemanabufoia. ");
INSERT INTO amk_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Arikang manani mani wedaya inontarai Israeli bitoya etarababerasa we Seng Allai, ene Mananufoi. ");
INSERT INTO amk_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","I mani da foni Sempaisi, wemambiriu kariri nabi Eliai. Ampafe dohong wawa enemirorong sawai we ene arikangfosa, tuti dohong inontarai era saiworuai etarababerasa we rang mesio inontarai emararebana fosa era nai foi. Nanaia mani deunau kaiwasafo ampafe emainenang etamang we ene Sengfoi.” ");
INSERT INTO amk_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ainanaya Zakariai medu we wewaifoi deyo, “Todoni iroaso finanai? Weo iweinonggutung ampa, tutio nehu wiwingfoi wewiwinggutung ampa.” ");
INSERT INTO amk_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Wewaifoi yoa wei aha deyo, “Modu tonana fanai. Wewai Gabrieli di yau. Yauno diru rahida yoa na Seng Allai arongfo ne, amani demi yau ma yeikariri kaiwo mahikai ninai we wau. ");
INSERT INTO amk_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Fi yeoai nina mani wetarai rai, manamo roasoa kaha, ampafe boromutamu rai. Modu fiea kaha pariao kaiwo ninai wetarai na ne rahida derera fo.” ");
INSERT INTO amk_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Kaiwasa demang we Zakariai na boriai foi enemitituaitai paria, weo niayai waroi karerai na Rorong Mirarebana foi. ");
INSERT INTO amk_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Mayeaia mani da to boriai, manamo borongfoi tibau wesa kaha, niari kaririai na warangfo terai. Arahio ewaitawanai weo deti fiainawiai bei na Rorong Mirarebana foi. Mae borotamu pampang wo. ");
INSERT INTO amk_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Mayeaia mani fi niari na Munu Seng foi kai finanaya, ainanaya tiwera tono ne munu rorong fo aha. ");
INSERT INTO amk_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Waroi aha kaha mae binengno Elisabeti doama, ampafe dediwari na munu rorongfo we embai ring. ");
INSERT INTO amk_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Deyo, “Ikarawahi pariao iwewiwinggutung, ampafe kia mamaya we yau. Wape nina mani ikarawahi ahang kaha. Seng Allai niari finini we yau. Dohong ne bengfo arora we yau ampafe imamaya na kaiwasa earomireafo ahang kaha.” ");
INSERT INTO amk_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabeti doama ne embai wonang mani, Seng Allai demio ne wewai manei, wonong fino Gabrieli, da to munuefeai na nu Galileai, wonong fino Nazareti. ");
INSERT INTO amk_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Da we kadawing sowaworua manei, wonong fino Mariai. Mariai nini da we mang manei wonong fino Yusupi, weriria na ne wawafoi, ene mananu Dauti. ");
INSERT INTO amk_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Mayeai wewaifoi da ma sobu Mariai tuti medu wei deyo, “Mahikaifeai we wau, wobu ne bengfo ampa. Sempaisi niai na wau.” ");
INSERT INTO amk_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mariai tarao kaiwofo nanai, soiri weai, enetituai na enerorongfoi we mahikai fianai aino wewaifi deyoa fo. ");
INSERT INTO amk_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Mayeai wewaifoi medu wei deyo, “Mariae, wau mutai fanai! Weo wobu bengfo ria Seng Allai ampa. ");
INSERT INTO amk_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Wau boama rai, ambori munohi tuti kaisung manei. Bohong te wonong fino Yesusi. ");
INSERT INTO amk_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Arikang manani mani fiebai wefuba, ahui we Sengno Dedai Mantaung ne Kaisung, tuti Seng Allai ambori yuaisi we Mananu fuba na ne wereng Dauti ne mananu rorong fo. ");
INSERT INTO amk_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","I ambori yu wemananu fuba we Yakupi ne ririafoi sentenang. Ne mananufo wiro werea na ea kaha.” ");
INSERT INTO amk_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ainanaya Mariai yoa we wewaifoi deyo, “Wape irirau kaharai mae, todoni e, boyo ambori iwearikang nina?” ");
INSERT INTO amk_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Wewaifoi medua deyo, “Sempaisi Nuaninufoi bia woru wau, ne tapapa nai woru wau, ampafe arikang munohi tutiri wai mani mirarebanaifa, tuti ahui weo Seng Allai ne Kaisung dine. ");
INSERT INTO amk_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Aromuo nemu tafuai Elisabeti, wewiwinggutung ampa. Eteyo kirawahia finana, wape ambori dawingno arikang manei ki, we ninaia mani doama to ne embai wonang ampa. ");
INSERT INTO amk_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Weo fifianai aino Seng Allai de niari fo mani, miawa arora wei.” ");
INSERT INTO amk_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mariai deya deyo, “Yau mani, Sempaisi ne woming di yau. Deyo fiani mani, yohong kaririai, ampafe fianai aino niari we yau ne mani tarai kariri boyoawara.” Ainanaya wewaifoi da werui anina. ");
INSERT INTO amk_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Waroi aha kahai mae Mariai sikera beyari da to munuefea na katai weuai, wa na nu Yudea foi. ");
INSERT INTO amk_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Da to Zakariai ne munufoi, da wa suai afui, dohong mahikai we Elisabeti. ");
INSERT INTO amk_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabeti tarao Mariai dohong mahikaifo, arikang niai nano enemanabufoi dota dohonai we piraise fefe, tuti Sempaisi Nuaninu dong Elisabeti. ");
INSERT INTO amk_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ainanaya sahu tutirai deyo, “Mariai! Wauno wobu mai fuba sewa wiwingne ameane, tuti arikang bawini wai mani sobu mai fuba rai. ");
INSERT INTO amk_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Tuti inontarai fuba di yau kaha mae, nehu Mananunei inangno da ma suambawa yau nina e? ");
INSERT INTO amk_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Aweo bohong mahikai ma tarahuoai nanane arikang niai nano enehumanabufuini piraisefe dota dohonai. ");
INSERT INTO amk_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Wau wobu ne bengfo paria weo roaso fiani aino Sempaisi deyoai ria wewaifoi fo wetarai rai.” ");
INSERT INTO amk_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ainanaya Maria deyo, “Yeparanding Sempaisi na enehurorongnei, ");
INSERT INTO amk_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","tuti imararising na nuhuaninunei we Seng Allai, nehu Mamparirifoi. ");
INSERT INTO amk_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Weo andino aro yau, tuti urengfo nai na ne womingno enehurorong tewawa ne yaune. Tarai weo na ninai to fongna mani, kaiwasanei kiai sentenang ambori esahu yau we mano isobu mai ne, ");
INSERT INTO amk_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","weo Seng Allai, mano weMambiriu sewa, niari fibeng fuba we yau ne. Wonongfo mani mararebanai. ");
INSERT INTO amk_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Riria bia we riria, Sempaisi aro inontarai mano emataiti fefe eroasoi fosa. ");
INSERT INTO amk_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Niari fi fuba paria na warang wemambiriru fo, Waraepa mano etawa fosa, ampafe fi enemitituaita fo etohong kariria kaha. ");
INSERT INTO amk_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Su mananufosa weru ene kadera mananu fo to kofara, mae yuaio inontarai enemirorong tewawa fosa. ");
INSERT INTO amk_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Dohong fiang beng weo inontarai ewawisi fosa ambori emamosi, mae datao inontarai ene ra fosa era arora, era ewarami era eawemi. ");
INSERT INTO amk_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Fiata ne womingno Israeli foi kawuru ampa, tuti aroporo Abrahami tuti ne ririane tata kaha, mae aro ne kaiwasa Israeline tata paria, aro tata wefitawafa, kariri dererai we tane werengfosara fo.” ");
INSERT INTO amk_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariai minohi ria Elisabeti na nanai we embai botoru teai, arahio daraberahi to ne munufoi aha. ");
INSERT INTO amk_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabeti ne rahidafo maia, minohi tutio kaisung manei. ");
INSERT INTO amk_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Mano munu warareng ruhia fosa tuti ne terafosa etaramioai weo Sempaisi deinawiai we aro Elisabeti paria, ampafe ea kontai eparaise riati. ");
INSERT INTO amk_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Arikangfoi neo rahida indeatorua mani, efanduhisa weo ewesunati kariri Yahudifosa ene koang, tuti ete etohoni wononso tamangno, Zakariai. ");
INSERT INTO amk_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Manamo inang medua deyo, “Bireri! Tatohoni wonong fino Yohanesi.” ");
INSERT INTO amk_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Emadu wei eteyo, “Manamo na nemu ririanei ma mani, wiro manei wonong tonana kaha.” ");
INSERT INTO amk_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ampafe ehamang kaririai na ewaramifo we Zakariai, weo borotamu ampafe etutang berahi we wang fiani aino de dohonai we ne arikangfoi fo. ");
INSERT INTO amk_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakariai dutang we kamiai toi nai bei, ainanaya soi aweu mani, “Wonong fino Yohanesi.” Kaiwasafoi pepuhung sentenang beyari. ");
INSERT INTO amk_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Na kutu iyari nanai, borongfoi tibau, medu aha, tutu fiai Seng Allai. ");
INSERT INTO amk_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Mano munu warareng ruhia fosa ematai tantenang beyari, ainanaya kaiwoaririfo etaiririai wario munuefo tantenang na katai weuai na Yudea. ");
INSERT INTO amk_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Kaiwasa etaramioa fosa enemitituai weai na enemirorong, tutu eteyo, “Arikang wani fiabai mani, wefiani rai?” Weo Sempaisi ne tapapa weririati. ");
INSERT INTO amk_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zakariai, arikangfoi tamana, andino Allai Nuaninu Mirarebanai donti, ampafe medu kariri Allai deyoafo, deyo, ");
INSERT INTO amk_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Fiaifeai we Seng Allai, Seng we inontarai Israeli ne tata, Weo da ma we feriri ne kaiwasanei ampa. ");
INSERT INTO amk_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Demi Mananu Mampariri wemambiriu manei da we tata, na ne womingno Dauti ne ririafoi. ");
INSERT INTO amk_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Na fafongfa Sempaisi dohong Kaiwo Arerai kawurua, watai ria ne nabi mano dirisa fosa, ");
INSERT INTO amk_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","weo sawing tata ambori takaharai weru tane aitetafosa, tuti weru mano enemirireu tata fosa ewaramirorongfo. ");
INSERT INTO amk_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Weo deinawi ne aroafo we tane werengfosa, tuti dohong kariri ne Kaiwo Arerai mararebanai nanai ki. ");
INSERT INTO amk_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Fefora we Abrahami, tatamamifoi, ");
INSERT INTO amk_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","tuti dererai weo wara-ai tata weru tane aitetafosa, ambori tatohong kariri tuti tasomi wei na tamatai kaha, ");
INSERT INTO amk_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","na taenemirorong mararebanai tuti taenemirorong mesi, na arongreafo na rahidao taminohi na nunei kiai ne.” ");
INSERT INTO amk_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ainanaya Zakariai medu we ne arikangfoi, deyo, “Nehu arikangwa wau, ambori esahu wau wenabi na Seng Allai mano Dedai Mantaung. Weo ro foni Sempaisi, weo bora rang wei, ambori bounau kaiwasanei ampafe emainenang etamang wei. ");
INSERT INTO amk_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ambori boisaharai we Seng Allai ne inontarai Israeli nesa, we ambori feririsa ki, weo deiai ene sasarifo ki. ");
INSERT INTO amk_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Weo Allai tane Sengnei mani aro tata na enerorong denteng foi, ampafe demi Mananufaini da ma we feriri tata nina. Toyari wo dautai na katai dedai, ");
INSERT INTO amk_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Sambewarai weo sambewa inontarai enayai na mamantiti rorong fo tuti na marareha rorong fo, tuti weo wiwiang tata ambori tara na ne rangno kia mai we tata fo.” ");
INSERT INTO amk_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Zakariai antungfoi fiabai to yai tuti enerorongfoi wemambiriu. Niayai na katai wekamamiei minano foi, pariao rahida deinawi ne tarai we inontarai Israeli fosa weo deiriri Sengnei ne Kaiwofo wesa. ");
INSERT INTO amk_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Na rahida bonani Kaisari Agustusi, mananu fuba we katai bitoya foi, mano niai na Roma foi, i dohong kaiwoariri weo kaiwasa na ne nufoi sentenang. Demisa weo era to ene katai siai weo etoi karirio ewonomifo we deto kariri. ");
INSERT INTO amk_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Arahi we beiri reantenangno deto ne kaiwasafoi finana, (nana mani Kireniusi wegubernuri na Siria). ");
INSERT INTO amk_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ambori Kaisari Agustusi ne kaiwasa etaraberasa wemansisiayawai to ene kataifoi weo etoi ewonomifo. ");
INSERT INTO amk_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Yusupi tuti Mariai kontai ura wiru bendari Nazareti na Galilea to Yudea. Ura to bendari Betlehemi, kataio fafongno Mananu Dauti inanai minohi tutiri naya fo. We Yusupi mani wewereng na Mananu Dauti. Ambori Yusupi soi uwonomifo. Mariai wiwing da wei foi rabuang bonani mani, doama finana. ");
INSERT INTO amk_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Usobu Betlehemi mae katai bereri we itoru na munufo, ampafe uminohi na munu fiahungfosa. Mayeai, Mariai ne rahidafo mai we minohi. Ainanaya minohi tuti arikang mang manei, arikang reatenang dine. Sensani na ireu abirarung tuti dohoni wiatai na katai fiahung etampi nayai. ");
INSERT INTO amk_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Na nanai, kefang we Betlehemi mani, katai webuayai bei. Na katai nani inontarai manea enai wedua ene fiahungfosa na diru. ");
INSERT INTO amk_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mayeai Sempaisi ne wewai manei da ma doa ruransa, tuti Sempaisi ne sambewaraio dadai foi doa worusa tantenang, ampafe ematai beyari. ");
INSERT INTO amk_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ainanaya wewaifoi medu wesa, deyo, “Mematai fanai, weo yeisaha kaiwo mirising weo mea kiai na nunei sentenang. ");
INSERT INTO amk_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Diru nini Mananu Mampariri manei dariai na Betlehemi. I mani, ahui we Kristusi, Seng dine. ");
INSERT INTO amk_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Yeikaririai we mea ambori mera wa mesera wei. Mera to Betlehemi mesera wei, mewatioi sensani na ireu abirarung tuti wiatai na katai fiahung etampi nayai. Nana mani, andine.” ");
INSERT INTO amk_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Na kutu nanai Seng Allai ne wewai rabuangnei ebia meu ehontai mano reantenang foi efiai Seng Allai eteyo, ");
INSERT INTO amk_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Sambewaraio Dadai feai we Dai Allai na katai dedai, tuti na nunei mano eha enemurorongwai esobu nemu maiwa.” ");
INSERT INTO amk_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Sempaisi ne wewaifosa etaraberasa to rorafaisia, ainanaya mantahung fiahung fosa etutang wawerasa eteyo, “Mera ma, tara to Betlehemi we tawatio fianai aino Sempaisi deinawiai na wana fo, toyari deisaharai we tatara ne.” ");
INSERT INTO amk_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Mayeai etahareniai awao esobu Mariai tutu Yusupi itoru aninai, ewati arikangfoi we wiatai na katai fiahung etampi naya fo. ");
INSERT INTO amk_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Era wa ewatioia nanai, ainanaya era wariai eteisaha kariri fianai aino etaramioai karirio arikangfoi fo, ");
INSERT INTO amk_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","tuti kaiwasa etaramioa fosa epapuhung paria we fianai aino mantahung fiahung fosa etaisahara fo. ");
INSERT INTO amk_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mae Mariai enetituai na enerorongfoi kariri finani kiai tuti yutawania mutu na enerorongfoi. ");
INSERT INTO amk_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Mayeai mantahung fiahung fosa etaraberasa tuti efiai Seng Allai we fianai aino etaramioai tuti ewatioa fo, tarai karirio Seng Allai ne wewaifoi deisaharai wesara fo. ");
INSERT INTO amk_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Arikangfoi ne rahida indeatorua mani, ewesunati tutu etohoni wonong fino Yesusi, wangno wewaifoi deisaharai we inanai nano doa wei ma kaha fo. ");
INSERT INTO amk_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Mariai ne rahida piaru we ruairuramifo mai, kariri fi Musai soi fo mani, Yusupi tutu Mariai uka une arikangfoi ura to Yerusalemi weo uroa tuturi we Sempaisi. ");
INSERT INTO amk_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Weo Kaiwo Sempaisi dohonai we Musai fo dotu tonina, “Arikang mang reantenang fosa mani, ohonsa we Sempaisi.” ");
INSERT INTO amk_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Uru kontaio ureo urohong romu muntung mandu ete afurang antung mandu weo mung suru wekorbani kariri Kaiwo Allai dohonai we Musai fo. ");
INSERT INTO amk_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Na rabuang bonani na Yerusalemi mani, inontarai manei wonong fino Simioni. I mani inontarai mesi dine, tuti dohong kariri Sempaisi ne Kaiwofo. Kontai demang we rahida bo Seng Allai sawing kaiwasa Israeli fosa weru mano etaha tawansa fosa. ");
INSERT INTO amk_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Sempaisi Nuaninu Mirarebana foi niayai nai, tutu deikaririai wei weo i mani mireha ahera kaha pariao detio Mananu Mampariri foi, kariri Sempaisi dererafo. ");
INSERT INTO amk_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Sempaisi Nuaninu Mirarebana foi wiwiaing Simioni da to Allai ne Munufoi refongfo. Na iyari nana mani, Yusupi tutu Mariai uka Yesusi we uroa tuturi we Sempaisi, kariri fi Musai soi fo. ");
INSERT INTO amk_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ainanaya Simioni kia arikangfoi ma yuti mae fiai Seng Allai, deyo, ");
INSERT INTO amk_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Sengwa wau, bohong kariri nemu kaiwo arera fe ampa, ampafe ka yau na mai mau. ");
INSERT INTO amk_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Weo Mampariri da na wau ma nei yeti teri na urehune ampa. ");
INSERT INTO amk_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Mampariri nini mani bohoni we kaiwasa nunei sentenang. ");
INSERT INTO amk_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","I mani soyari fidansairai we kaiwasa Yahudi kaha fosa ambori sambewa rangno esobu faririfo nayai. Tutuo andi wesambewaraio dedai we kaiwasa Israeli ne ameane.” ");
INSERT INTO amk_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Tamang inang suru utaramio kaiwo Simioni medurai kariri une arikangfoi fo mani, upapuhung paria. ");
INSERT INTO amk_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Mayeai Simioni medu kaiwo moang weo itoru tutu medu we Mariai deyo, “Seng Allai yuai arikang nini weo wedaya inontarai na Israeli manea etawai, tuti manea siai yuaisa esobu mai. I mani, inontarai bitoya etapai, ");
INSERT INTO amk_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ambori kaiwasanei sentenang ewaitawanai weo fi inontaraifosa enemitituaita fo mani kerira paria. Tuti Maria wau, enemurorongwai fituaiyao ne tarai toyari sonduo disang enemuaibongfuisi.” ");
INSERT INTO amk_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Na nanai kontai wiwing nabi manei, wonong fino Anai. Tamana mani Fanueli nano riria Aseri. Anai mani, wewiwinggutung paria, ne defuina piarara boa (84). Riraua defuina itu mani, ne mangfoi mireha werui, minohi wewiwina, rirau ahang kaha. Diru rahida da weru Munu Seng foi kaha, mae somi we Seng Allai pampang. Wenadi tutu wepuasa ampafe ne nadifo mutu. ");
INSERT INTO amk_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Na kutu nanai da mao itoru, ainanaya fiai Seng Allai, tutu medu kariri arikangfoi we kaiwasa bitoya, mano etamang weo rahida bo ewati Israelifosa ene Mananu Mampariri da na Seng Allai meu fo, deyo, “Mewati ma! Andinini, mano tatamang wei na Seng Allai meu nei.” ");
INSERT INTO amk_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yusupi tutu Mariai urohong kariri Kaiwo Allai dohonai we Musai fo kaia, amani uka arikangfoi uroa tutiri we Sempaisi we mioani. Ainanaya itorarabera itoru to itone bendari Nazareti na nu Galilea foi. ");
INSERT INTO amk_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Arikangfoi fiabai to yai tutio tiapa, kontai i mani sewai sewa, tutu Seng Allai ne bengfo nayai nai. ");
INSERT INTO amk_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Defuina neungne mani Yesusi ne wawa fo suru ura to Yerusalemi weo etohonsua rahida Paska foi, rahida fubao earomio Seng Allai fafongfa kia Israelifosa to boriai weru nu Mesiri foi. ");
INSERT INTO amk_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Yesusi ne defuina suraya borua mani, itora we itorohonsua rahida fuba foi, toyari ne etohonai fafongna fo. ");
INSERT INTO amk_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Etohonsua rahida fuba foi kaia mani, itorarabera itoru, wape Yesusi da riata kaha, niai na Yerusalemi. Inang tamang usera wawerahi, ");
INSERT INTO amk_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","mae umananaiyoai ureitarahio da ria kaiwasa bitoya eraruhia fosa. Ura wa kio ramindena wori, ambori usera wei ki, ria itone terafosa tuti arurarafosa. ");
INSERT INTO amk_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Manamo usobui kaha, ampafe urarabera uru to Yerusalemi aha, usera wei nayai. ");
INSERT INTO amk_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","We rahida botoru wori usobui na Munu Seng foi refongfo ki. Minohi rahang mantaunau Kaiwo Musai soi fosa, taradidausa tuti dutang wawerasa. ");
INSERT INTO amk_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Inontaraifosa etaramio Yesusi medu tutu dafu babau kaiwofo aha ma, ampafe epapuhung we ne awaifo. ");
INSERT INTO amk_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Ne wawafo suru uwatioifo upapuhung parai. Mayeai inang medu wei deyo, “Kaisungne wau, nari auru todoni finana? Tamamuai tutu yau auweansarai we wau fefe ausera paria.” ");
INSERT INTO amk_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Yesusi yoa we suru, deyo, “We fiani musera we yau nina? Muwaitawana kahae weo yau mani iminohi na Dai ne mununei rai?” ");
INSERT INTO amk_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Manamo utafu turu kaiwo Yesusi medura fo kaha. ");
INSERT INTO amk_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ainanaya Yesusi da ria suru itorarabera itoru to Nazareti, tuti taradidau suru. Fianai aino medurai tutu niari fo, inangno detioai ampafe soniai na enerorongfoi. ");
INSERT INTO amk_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesusi fiabai to yai tuti sewai sewa aha, kontai Seng Allai enewawu Yesusi, tuti inontarai eparaiseri. ");
INSERT INTO amk_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Defuina bo suraya ring na rabuang bo Kaisari Tiberiusi wemananu fo, amani Pontiusi Pilatusi wegubernuri na Yudea, tutu Herodesi Antipasi wemambaiseng na Galilea, ne tahatui Pilipusi wemambaiseng na Iturea tutu Trakonitisi, mae Lisaniasi wemambaiseng na Abilene. ");
INSERT INTO amk_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Mano uru wang imami fuba fo suru mani, Anasi tutu Kayafasi. Na defuina bonani andino Seng Allai medu we Zakariai antungno Yohanesi na katai minano wekamamiei. ");
INSERT INTO amk_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Ainanaya Yohanesi da to kataifoi sentenang rurang waya Yardeni, tutu wiuwu kaiwofo deyo, “Metarabera mea weru mene sasariwa, mewebaptisi, ambori Allai feriri mene sasariwa.” ");
INSERT INTO amk_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Nana mani wetarai kariri kaiwo nabi Yesayai soi fo, dotu tonina: “Inontarai manei sahu pampang na katai wekamamiei minano foi deyo, ‘Memainenang rang beng feai we Sempaisi, tuti menaria mimoya wei. ");
INSERT INTO amk_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Weenangwa tautawanaia mai, uai tuti wiwoi naria maikaburu. Rang takahapa naria mimoya, rang sanggangging araraya kasisau. ");
INSERT INTO amk_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Kaiwasa nunei sentenang ambori ewati Seng Allai feriri inontarainesa rai.’ ” ");
INSERT INTO amk_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Kaiwasa bitoya era we Yohanesi ma weo webaptisisa. Yohanesi medu wesa deyo, “E, inontarai mewarami aipaya di mea, mene tarai toyari tawai memuna, dohona menemitituai we mera ma iwebaptisi mea terai tonanai ambori mekaharai weru Seng Allai ne aiboi katu ma da ma fo fe? ");
INSERT INTO amk_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Mae toyari aio webong beng, mea kontai meteinawiai na metohong toa wa we metarabera mea weru mene sasariwa ampa. Dohonao meteyo mea mani mene wereng di Abrahami ampafe ambori mekaharai weru Allai ne aiboifo fe. Mearomioai we Seng Allai mani mawa arora we I we niari riria Abrahami na kamamieinei kontai. ");
INSERT INTO amk_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Tamangfoi meinenang na ai newafoi we robani. Ampafe ai bodoni dino webong kaha mani, robani tuti kabioi to adia rorong fo.” ");
INSERT INTO amk_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ampafe kaiwasafoi etutang bera Yohanesi eteyo, “Tonana mani amenari todoni?” ");
INSERT INTO amk_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Yohanesi yoa wesa deyo, “Inontarai manei ne ansung beru mani, dohong eai we mano ne pari foi, tuti mano ne fiang foi deto we mano ne pari fiang foi.” ");
INSERT INTO amk_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Mano efanduhi pajaki we Mananu Kaisari, ea kontai era we Yohanesi ma we webaptisisa. Etutani eteyo, “Mataunaune wau ne, amenari todoni?” ");
INSERT INTO amk_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Yohanesi yoa wesa deyo, “Mefanduhio pajaki mani, wiro fuba sewa Mananu Kaisari demi wea fo fanai.” ");
INSERT INTO amk_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Mano eru fimamuna fosa kontai etutani eteyo, “Amea mani, amenari todoni?” Yohanesi yoa wesa deyo, “Dohonao metohong tati inontaraifosa mewawu ene ra, tuti dohonao metohong babusa ambori meha ene doifo, mae mesobu doi ria mene babafosara mani, ainana to.” ");
INSERT INTO amk_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Kaiwasa bitoya foi enemitawanai tutuo etamang weo ene Mananu Mampariri foi, ampafe ewatioai tuti etarami fi Yohanesi deyoa foa nanai, enemitituaitai eteyo, “Dohonao Mananu Mampariri foi dine.” ");
INSERT INTO amk_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Manamo Yohanesi medu wesa deyo, “Yau mani iwebaptisi mea na mereha terai, mae manei datuwa yau, i mani fiabai sewa yau tuti we irehu ne wai sapatu fo terai ki, wiro imai we inari finana kaha. I mani webaptisi mea na Nuaninu Mirarebana foi tuti na adia, amani niari mea memararebanai tarai. ");
INSERT INTO amk_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ne sosirufi meinenang na warangfo ampa we kifa pafoi ambori mirarebanai. Pa taraifoi fianduhi afui wiatai na munu rorongfo, mae nukahaifoi ambori kebioia dansoi na adia wiro fefe naea kaha.” ");
INSERT INTO amk_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Yohanesi dohong kaiwo aunau fiabai tuti deiriri kariri Kaiwo Mahikai fo we kaiwasa bitoya foi. ");
INSERT INTO amk_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Manamo mayeaia mani deiua Herodes Antipasi, mano wemambaiseng na Galilea foi, weo dauo ne tafuai binengno Herodiasi ampa, tuti weo ne wara aipaya siai fo kontai. ");
INSERT INTO amk_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ampafe Herodesi kesou mambiriu aha, ainanaya demi ne raifosa etohong Yohanesi to aitamu rorong foa. ");
INSERT INTO amk_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Wiro Herodesi samuo Yohanesi na aitamu rorong kaharai, mae Yohanesi webaptisi kaiwasafoi, tuti na iyari nanai Yesusi kontai da ma we Yohanesi webaptisi. Yesusi webaptisi mae wenadi, na kutu nanai mae rorafaisi tifai, ");
INSERT INTO amk_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","tuti Sempaisi Nuaninufaisi, ne tarai toyari muntung manei, sea meu minohi sau Yesusi. Mayeai tarao Allai raofuifoi medu na rorafaisi meu deyo, “Wau mani nehu Kaisung enehuwawuti fi di Wau. Wau ka enehurorong fine.” ");
INSERT INTO amk_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Na reantenang Yesusi deunau tuti deiriri Sempaisi ne Kaiwofoa mani, ne defuina piareya sura teai. Inontaraifosa enemitituaitai weo i mani tamang di Yusupi, ");
INSERT INTO amk_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli tamangno Matati, ");
INSERT INTO amk_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Yanai tamangno Yusupi, ");
INSERT INTO amk_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai tamangno Mati, ");
INSERT INTO amk_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Yodai tamangno Yoanani, Yoanani tamangno Resai, ");
INSERT INTO amk_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri tamangno Marki, ");
INSERT INTO amk_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Eri tamangno Yesuai, Yesuai tamangno Erieseri, ");
INSERT INTO amk_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi tamangno Simioni, ");
INSERT INTO amk_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eriakimi tamangno Mereai, Mereai tamangno Mina, ");
INSERT INTO amk_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dauti tamangno Yesi, ");
INSERT INTO amk_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahasoni tamangno Aminadapi, Aminadapi tamangno Adimini, ");
INSERT INTO amk_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Yehudai tamangno Yakupi, Yakupi tamangno Isaki, ");
INSERT INTO amk_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahori tamangno Seruki, ");
INSERT INTO amk_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Serahi tamangno Kenani, Kenani tamangno Afahati, ");
INSERT INTO amk_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lameki tamangno Metusaraki, ");
INSERT INTO amk_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kenani tamangno Enosi, Enosi tamangno Seti, ");
INSERT INTO amk_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Allai Nuaninu Mirarebana foi suai afui niai na Yesusi, ainanaya Yesusi daraberahi na waya Yardeni. Nuaninu Mirarebana foi wiwiaini to katai wekamamiei minano fea, ");
INSERT INTO amk_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","niai na kataifoi we rahida piaru mae Saminseni weanggariri pampang. Rahida piaru fo mani dang fiea kaha, ampafe rahidafo kaia mani wewisi. ");
INSERT INTO amk_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ainanaya Saminseni medu we Yesusi deyo, “Taraie Allai ne Kaisung di wau mani, bemi kamieiwai wefiang.” ");
INSERT INTO amk_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Manamo Yesusi yoa wei aha deyo, “Na Sempaisi ne Kaiwofo dotu tonina: ‘Inontarai eminohi etarang fo, na fiangfo titou kaha.’” ");
INSERT INTO amk_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Mayeaia mani Saminseni kia Yesusi to uai dedai bei nuwowongfo, tutu tatofang kaha mae Saminseni deinawio katai mananufo ewemananu naya fo kiai na nunei sentenang wei. ");
INSERT INTO amk_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Tuti medu wei deyo, “Yohong wemananu tutuo fianggeng mehikai botioi nani we wau ki, weo finana mani ohonai we yau ampa, ampafe yohonai we inontarai mandoni dino enehurorong niai nai fo. ");
INSERT INTO amk_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ampafe womi we yau mani yohonai tantenang mau nemu.” ");
INSERT INTO amk_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Manamo Yesusi yoa weia deyo, “Sempaisi ne Kaiwo dotu toninai: ‘Mesomi terai we Allai mene Sengfoi, tuti metohong kariri ne Kaiwofo terai.’” ");
INSERT INTO amk_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ainanaya Saminseni kia Yesusi to Yerusalemia, dohoni minohi na Sempaisi ne Munufoi kuruinafo. Mayeai medu wei deyo, “Taraie Seng Allai ne Kaisung di wau mani, tawing wau tawai na ninai aweu, ambori wewaifosa esoru wau wori, tau aweu, mureha kaha. ");
INSERT INTO amk_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Weo Sempaisi ne Kaiwone rabuang bei dotu kariri wau tonina: ‘Allai ambori demi ne wewaifosa etamang we wau, tuti ewaitawang wau ki.’ ");
INSERT INTO amk_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","‘Etamang we wau na ewaramifo, ampafe tau kofafea kaha.’” ");
INSERT INTO amk_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Manamo Yesusi yoa weia deyo, “Na Sengnei ne Kaiwofo dotu tonina: ");
INSERT INTO amk_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Saminseni ne anggari bitoya niariri foi kai finanaya, ainanaya pisuhi ne tarai ahao, sera we rahida siai weo weanggariri aha. ");
INSERT INTO amk_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesusi daraberahi to nu Galilea tutu wemambiriu, weo Nuaninu Mirarebanai niai nai. Tutu wonongfoi defai wari kataifoi sentenang. ");
INSERT INTO amk_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Yesusi deunau Kaiwo Seng na Yahudifosa ene munu agama fo, ampafe kaiwasa bitoya efiai i. ");
INSERT INTO amk_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesusi daraberahi to Nazareti, ne munue fiabai naya fo. Toyari ne finiari na rahida Sabati neungfo da to munu agama Yahudi foi afui, ainanaya doa weo deto Kaiwo Seng fo. ");
INSERT INTO amk_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Etohong buku reraung kafariao nabi Yesayai soi fo weia. Fiorerawi aweu mani deti rabuang bo Yesayai soi tonina: ");
INSERT INTO amk_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Sempaisi Nuaninu niai na yau, we andi deinawi yau we yeikariri Kaiwo Mahikai we kaiwasa ene pari fi, tutu demi yau weo yeisaharai we kaiwasa tamui foi itawinsa, tutu kaiwasa euremifafa fosa, warahururang euremifo ambori ewati, tutu iruai kaiwasa tahatawansa fosa weru mano etohonsafo ea. ");
INSERT INTO amk_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Tutu yeisaharai weo Sempaisi ne rahida weo deinawi mano feriri kaiwasa foi da ma ne.” ");
INSERT INTO amk_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Mayeai kiafa bukufoi dohoni tiwera we mano da wa kiarioi ma foi, tutu suki aweu minohi. Kaiwasa bitoyao minohi na munu agama Yahudi fo rorongfoi ewati kai weia. ");
INSERT INTO amk_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ainanaya deunausa deyo, “Na rahida bonini mani, kaiwo rabuangno metaramioai ninai wetarai ampa.” ");
INSERT INTO amk_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Kaiwo deyoa fo mahikai paria ampafe epapuhung wape emadu wawerasa eteyo, “Inontarai wani mani Yusupi antung dine mae? Todoni fino sahui weo i mani mano mampariri dine nina?” ");
INSERT INTO amk_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ainanaya Yesusi medu wesa deyo, “Ambori memadu kaiwo netawea ne we yau, meteyo, ‘Ametaramio wau nari fitantuma bitoya na munue Kapernaumi. Tonana mani, nari na ninai kontai, na mantaung wau nemu munuene. Manggarawang di wau to. Wau nari inontarai ebeng ampa. Tonana mani, nari bera wau ambori bonteng ki.’ ” ");
INSERT INTO amk_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Dei tuwarai aha deyo, “Mearomioai. Kaiwasa na katai siai eroao nabi manei na mai, wape na mantauni ne munuefo wiro eroaoi kaha. ");
INSERT INTO amk_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Tarai tofino, na fafong nabi Eliaifa, amani wiro wemetang kaha, waroio defuina botoru aburung fea, ampafe kahari dohong nunei sentenang. Na rabuang bonani mani wiwina bitoya kontai na nu Israeli. ");
INSERT INTO amk_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Tonanai mae Seng Allai wiro demi Eliai da we yufata wiwina na nu Israeli kaha, mae da terai weo wiwina mansiari na munue Sarafati, na nu Sidoni. Wiwina nani mani wiro riria na Israeli kaha. ");
INSERT INTO amk_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Na rabuang bo nabi Elisai fo kontai, na nu Israeli mani inontarai bitoya emaninang kusta, manamo wiro Elisai niari inontarai Israeli nansa ebeng kaha. Mae niari inontarai mansiari terai denteng, amani Namani, inontarai Siria dine, wiro riria na Israeli kaha.” ");
INSERT INTO amk_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Inontarai Yahudi na munu agama foi etaramioafo ehasou beyari. ");
INSERT INTO amk_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Etoabarisa erutawang Yesusi efafari to boriai weru munuefo, ehari era wa weo ehabioi na katai kenatatera fo. ");
INSERT INTO amk_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Manamo Yesusi daraberahi da abu kaiwasafoi, da werusa anina. ");
INSERT INTO amk_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ainanaya Yesusi bia to munue Kapernaumi na nu Galileai, na wana mani deunau inontarai na rahida Sabati na munu agama foi. ");
INSERT INTO amk_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Epapuhung we ne aunaufo weo kaiwo medura fo mani kaiwo wemambiriu fine. ");
INSERT INTO amk_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Na munu agama Yahudi foi mani inontarai manei inggira etohoni, ampafe sahu dohonai, tutu inggirafosa emadu eteyo, ");
INSERT INTO amk_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ee! Yesuse, inontarai Nazareti wa waune, bo nari fiani we amea ne? Ro ma weo bohong amea ameworua ne? Amewaitawanai we mandoni di wau, wau mani Mano Murarebanai, na Seng Allai ma fi di wau.” ");
INSERT INTO amk_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Manamo Yesusi somara inggirafosa deyo, “Menemboru, mera to woriai weru inontarai nini.” Ainanaya inggirafosa etotapa inontaraifoi aweu, wiatai nano kaiwasa bitoya foi euremireafo, mae era weruia, wape enari kanggani kaha. ");
INSERT INTO amk_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Kaiwasa na nana foi kiai epapuhung paria we fi ewatioai nanai, tutu emadu wawerasa eteyo, “Kaiwone siai paria! Na ne mambiriufo tuti na tapapa demi nuaninu karira fosa era to boriei tuti nuaninu karira fosa etohong kaririai.” ");
INSERT INTO amk_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ainanaya Yesusi wonongfoi defai wari kataifoi sentenang. ");
INSERT INTO amk_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Mayeaia Yesusi da na munu agama Yahudi foi to Simon Petrusi ne munufoi. Simoni niongno wiwini meninang rirora, ampafe ne terafosa eteikaririai we Yesusi. ");
INSERT INTO amk_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yesusi da wa doa rurang wiwingfoi, mayeaia data fimaninangfoi weruia dentengna. Ainanaya doa meai wesarawiri ne terafosa tutu Yesusi. ");
INSERT INTO amk_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Wofoi sawaia de weayewia nanai, kaiwasafoi eha ene inontarai emaninang fimaninang bodoni konta foi, ehasa erao Yesusi ma. Dohong warangfo waratawansa ampafe ebengna. ");
INSERT INTO amk_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Tutu mano emaninang fo manea inggira dohonsa, ampafe inggirafo era to boriai kontai, tutu esahu eteyo, “Seng Allai ne Kaisung di wau!” Manamo Yesusi datasa tutu dei weduasa, deyo, “Menemboru!” Weo ewaitawanai we i mani Mananu Mampariri dine. ");
INSERT INTO amk_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Ahafo buara mani, Yesusi da weru munuefo to katai minano bei. Manamo kaiwasafosa esera awao esobuia. Ainanaya etei weduari eteyo, “Wiro ro weru amea fanai!” ");
INSERT INTO amk_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Manamo dei wesa deyo, “Bereri. Yau ye ira to munue siai fo kontaio weo yeiriri kariri Seng Allai ne Kaiwo Mahikai ne, weo aiwedaya mani Seng Allai demi yau ma nina.” ");
INSERT INTO amk_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Tutu deiriri kariri Kaiwo Mahikai nano munu agama Yahudi fo na nu Yudea foi. ");
INSERT INTO amk_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Rahida bei mani Yesusi doa nano ruruo Genesareti nafarengfo. Kaiwasa bitoya foi ewati we Yesusi. Ewatioi ewarami siayasa weo ete etaramio Seng Allai ne Kaiwofo. ");
INSERT INTO amk_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Yesusi deti wa roworu urawohi na nafarengfo, manamo mamung diang fosa ebia weru wafosuru tono nafarengfo ambori esonihing erangfo. ");
INSERT INTO amk_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesusi dautai to wafo rowei, Simoni, mano ahui we Simon Petrusi, ne wa dine, tuti dutang we Simoni deyo, “Tuba wanei kuteai weru nafarengnei awarau.” Ainanaya Yesusi minohi na wafoi mae deunau kaiwasa bitoya foi awarei. ");
INSERT INTO amk_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Deunaua kaya mani dei we Simoni deyo, “Wo to katai behuru foa muna erangwai nayai.” ");
INSERT INTO amk_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simoni yoa we Yesusi deyo, “Daie, diruafa awao kameai anina antomung ao antosobu fiea kaha. Manamo Dai bemi yau fefe imuna erangnei aha.” ");
INSERT INTO amk_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Itorohong kaririaia nanane, itomung diang katui kaha, bitoya beyari, awao erangfoi adareti mesiabu. ");
INSERT INTO amk_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ampafe itosahu we mano emung diang ruhia fosa na wa koiwei foi, esahusa eteyo, “Ee! Mewo ma. Tarabi ruhi erangnei.” Ampafe esoni diangfoi na wa roworu fo paria adareti uraisui. ");
INSERT INTO amk_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","9","Simon Petrusi tuti mamung diang fosa epapuhung beyari weo emung diangfoia bitoya sonanai. Simoni detioai nanafo da wa disang kapa awebuka na Yesusi arongfo, mayeai medu wei deyo, “Seng di wau, ro weru yau, weo inontarai sasari di yau.” ");
INSERT INTO amk_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Yakobusi tutu Yohanesi, Zebedeusi ne arikangfosuru, uruino ukontai Simonine, upapuhung kontai. Manamo Yesusi medu we Simoni deyo, “Mutai fanai! Na ninai to fona mani yohong wau mung wedua inontarai.” ");
INSERT INTO amk_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Simoni tutu mano emung diang ruhia fosa etuai wafo to reia, itorohong itone fianggengfoi sentenang suanaiya, mae itora ria Yesusi. ");
INSERT INTO amk_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Na rahida bei Yesusi niai na munuefea. Na nana mani inontarai manei maninang kusta foi sinsung ne rerawafoi sentenang. Deti Yesusifo disang kapa awebuka na arongfo mae dutani deyo, “Daie, wau wemambiriu ne, maya mani, nari yau yenteng weru nehu maninangnei.” ");
INSERT INTO amk_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesusi suba warangfoa wa sauwi tuti medu wei deyo, “Yo, imaya. Bonteng to!” Tatofang kutu nanai kontaio maninang kusta foi niai werui tuti dentengna. ");
INSERT INTO amk_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesusi deretawani deyo, “Aromuoaifa! Wiro boiriri fi inari ninai weo inontarai siai manei fanai, mae ro to imamifoia tuti butani we deti kariri nemu taraiwai we bontengna wa. Mayeai bohong korbanifeai we Allai we nemu bontengna wa kariri fianai aino Musai soia fo. Nana mani deinawiai we kaiwasa bitoya foi we bonteng ampa.” ");
INSERT INTO amk_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Wape kaiwoariri etairiri kariri Yesusi fo defai pari aha wari kataifoi, ampafe kaiwasa bitoya era ma weo etaramio medufo tuti weo niarisa ebeng weru ene fimaninangfo. ");
INSERT INTO amk_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ampafe eaia mani da to katai minano we wenadi nayai. ");
INSERT INTO amk_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Na rahida bei Yesusi deunau, amani inontarai eweFarisi tuti mantaunau Kaiwo Musai soi fosa eminohi kontai na nanai. Era na fino Yerusalemi tuti munue watai nano nu Galilea tuti na nu Yudea fo. Sempaisi ne mambiriufo nayai na Yesusi weo niari inontarai emaninang ebeng. ");
INSERT INTO amk_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Na rahida bonani mani inontarai manea eha inontarai fiaya wia na andaung wowong manei, erao Yesusi ma. Ete ehari era to munu rorongfo afui etohoni wiatai na Yesusi urengreafo, ");
INSERT INTO amk_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","manamo kaiwasa bitoya kareraia dadira. Ampafe ehari etautai na tehi boriai to munu nuwowongfo ayai. Ainanaya ebai munu nuwowongfoi etuki tuti ne andaung wiatai nai foi aweu rahang kaiwasa bitoya foi, na Yesusi urengreafo. ");
INSERT INTO amk_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesusi detio enari tonanafo deitawanai we eroasoafo fuba paria, ampafe medu we inontarai fiaya foi deyo, “Waune, yeiai nemu sasarifi ampa.” ");
INSERT INTO amk_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Manamo mantaunau Kaiwo Musai soi fosa tuti Farisifosa enemitituaitai na enemirorongfo, “Mandoni dino deibera Seng Allai nina? Mandoni dino biriu we deiai sasari fine? Seng Allai mantauni terai!” ");
INSERT INTO amk_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Manamo Yesusi deitawang enemirorongfoi kawurua ampafe medu wesa deyo, “Todonie menemitituaitai tonanai na menemirorongwai nina? ");
INSERT INTO amk_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Doni aino mawa ne: imadu yeyo, ‘Yeiai nemu sasarifi ampa,’ ete yeyo, ‘Boabari wau, ka nemu andaungwai, tuti roa’? ");
INSERT INTO amk_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Wape yeinawiai we mea, na inari inontarainei denteng tonina ne, ambori mewaitawanai weo na nunei ninai, Kaisung Inontarai nei andino ne mambiriu we deiai sasari fine.” Ainanaya Yesusi medu we inontarai fiaya foi deyo, “We wau mani, imadu mau yeyo, boabari wau, ruai nemu andaungwai, ro to nemu munufoia.” ");
INSERT INTO amk_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Na kutu nanai kontaio inontaraifoi doabariria doa na kaiwasafoi euremireafo, mayeai yuai ne andaungfoi, da to ne munu rorong foa mae deparanding Seng Allai. ");
INSERT INTO amk_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Kaiwasafoi epapuhung tantenang beyari, ampafe etaparanding Seng Allai. Tuti enemirorong mitai, ampafe emadu wawerasa eteyo, “Fitantuma fino tawatioai na rahida bonini nina!” ");
INSERT INTO amk_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Mayeaia Yesusi da weru munuefoa, deti inontarai manei wonong fino Lewi. Lewi mani inontarai fianduhi doi pajaki we parenta Kaisari dine, minohi na munu pajaki foi. Yesusi medu weia deyo, “Ro ria yau.” ");
INSERT INTO amk_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Anseung ahang kahai mae Lewi doabariri tuti sawing fi yu fo tantenang, da ria Yesusi. ");
INSERT INTO amk_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ainanaya Lewi dohong muniara fiabai paria bei weo Yesusi na ne munufoi. Inontarai efanduhi doi pajaki we parenta Kaisari fo efau paria, tuti inontarai siai kontai ewatai etampi ruhiai. ");
INSERT INTO amk_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Manamo Farisifosa tuti mantaunau Kaiwo Musai soi fosa enemioa kaha, ampafe emadu we Yesusi ne inontarai erariati fosa eteyo, “We fianie metampi tuti metunung ruhiai ria inontarai efanduhi pajaki we parenta Kaisari foi tuti inontarai ewesasari fosa ninai?” ");
INSERT INTO amk_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Mae Yesusi yoa wesa deyo, “Inontarai etanteng nesa mani etohong we manggarawangnei kaha, mae mano emaninang fosa. ");
INSERT INTO amk_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Wiro ira ma weo isahu inontarai emararebana fosa kaha, mae we isahu inontarai ewesasari, ambori etaraberasa weru ene sasarifoi.” ");
INSERT INTO amk_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Na nanai kontaio inontarai eparaise Yesusi kaha manea, etutang berahi, eteyo, “Mano eraria Yohanesi tuti mano eraria inontarai eweFarisi nesa, wea mani ewepuasa ampafe ene nadifo mutu. Manamo mano eraria wau wasa etampi etunung, mae esera wawera ewepuasa.” ");
INSERT INTO amk_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesusi yoa wesa deyo, “Tofino! Ne tarai kariri mandirau mang foi tuti ne inontarai wenotisa to ne muniara mandirau foi. Na rahida mandirau mang foi minohi riasa nanai ewepuasa rai e? ");
INSERT INTO amk_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Wape rahida we mandiraufoi niayai na nanai riasa ahang kaha foi ambori da ma ki, rabuang bonani dino ambori ewepuasa ki. Tonanai kontai, nina mani inayai riasa ampafe ewepuasa kaha, wape rahidao ambori ira werusa foi da ma ki, rahida nanai aino ewepuasa ki.” ");
INSERT INTO amk_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ainanaya Yesusi deiriri fiyiwansoai wesa deyo, “Wiro manei eneaya ansung waworu feai weo kiutu aha dawa kobu ansung mamo fo ne masabufo naya kaha. Weo kiutu ansung waworu fo, kontaio ansung waworu fo ne tarai kariri ansung mamo fo kaha. ");
INSERT INTO amk_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Tonanai kontai we angguri waworu nei mani, wiro ariri to aderi sapi rerawa memo bei kaha, weo angguri weworu foi ambori wiwua wedaya aderi sapi rerawa memo foi tei. Nana mani anggurifo tibatara, aderi sapi rerawa foi kerirawa. ");
INSERT INTO amk_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Wape angguri weworu foi todoni kontaio ariri tono aderi sapi rerawa weworu bei kontai. ");
INSERT INTO amk_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Kontaio mano dunung angguri mamo foi miaya weo dunung angguri weworu kaha, weo deyo, ‘Angguri memo nei andi denteng sewa.’ ” ");
INSERT INTO amk_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Na rahida Sabati bei, rahida Yahudifosa erufi nai kaha, teterai we Yesusi da riria romi potang bei, ampafe ne inontarai erariati fosa eteting potangfoi, awa esikoyari na ewaramifo, ambori etani. ");
INSERT INTO amk_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ampafe Farisi manea emadu eteyo, “We fiani menari fi tonana fo na rahida Sabatinei nina? Weo nana mani metohong roaing kaiwo dotu weduara fo.” ");
INSERT INTO amk_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ainanaya Yesusi yoa wesa deyo, “Finana mani ne tarai toyari fi Mananu Dauti niari na fafongfa na rahida bo i tuti ne mano erariati fosa ewawisi fo. Metato kariri kaiwo nana kaha e? ");
INSERT INTO amk_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Amani suai to Sempaisi ne Munufoi afui dangno roti etutang tutirai we Allaia fo tuti dohonai we ne mano erariati fosa etang kontai. Wape finanai, kariri hukum agama foi mani, imami erufi na Sempaisi ne Munufoi saino etang tera ne.” ");
INSERT INTO amk_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yesusi dei aha deyo, “Kaisung Inontarai nei wemananu weo deiriri kariri fifianai aino inontaraifo enari tutu enari kaha fo na rahida Sabati.” ");
INSERT INTO amk_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Na rahida Sabati siai bei mani, Yesusi da wa deunau na munu agama Yahudi bei. Na nana mani inontarai manei, warang bo domoya foi mireha. ");
INSERT INTO amk_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Farisifosa tuti mantaunau Kaiwo Musai soi fosa euremi dingga Yesusi, weo niari inontaraifoia denteng na rahida Sabati mani, ambori etinggai, eteyo niari sarawai. ");
INSERT INTO amk_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Manamo Yesusi deitawang fi enemitituaita fo. Ampafe medu we inontarai warang mireha foia deyo, “Ro ma, boa na fongne.” Ampafe doabariria, doa na fongfo. ");
INSERT INTO amk_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ainanaya Yesusi medu wesa deyo, “Yutang bera mea. Kariri fi Musai soi fo mani, ne doni aino tanari na rahida Sabati fine? Tanari ne bengfo ete ne karirafo ne? Tafata inontarai ambori etarang, ete tatuasa ao eworua ne?” ");
INSERT INTO amk_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Yesusi deti maino kaiwasafoi sentenang, ainanaya medu we inontarai meninang foi, deyo, “Wi waramuwai ma.” Inontaraifoi si warangfoi kaririaia, na tatofang kutu nanai kontai warangfoi dentengna. ");
INSERT INTO amk_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Wape Farisifosa tuti mantaunau Kaiwo Musai soi fo ehasou fuba paria, ainanaya emadu ruhi kaiwo weo fiani aino enari kanggani Yesusi naya fo. ");
INSERT INTO amk_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Na rahida bei Yesusi da tono wiwoi bei we wenadi nai. Wenadi we Seng Allai na diru nani sentenang. ");
INSERT INTO amk_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Kameai nani sahu ne inontarai erariati fosa eraoi ma, ainanaya diri ewesuraya mandu na sa. Inontarai ewesuraya mandu fosa sahusa weo rasuli, amani Inong Anatu na Sempaisi. ");
INSERT INTO amk_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ewonomi finina; Simoni mano sahui we Petrusi, tuti ne tahatui Andareasi, Yakobusi tuti Yohanesi, Pilipusi tutio Bartolomasi, ");
INSERT INTO amk_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiusi tuti Tomasi, Alfiusi antung Yakobusi, tuti Simoni (mano biriu we inontarai Israeli fosa etoa siai weru Romafosa), ");
INSERT INTO amk_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yakobusi antung Yudasi, tuti Yudas Iskarioti, mano ambori dewayang Yesusi foi. ");
INSERT INTO amk_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Mayeaia mani Yesusi tuti ne inontaraifosa ebia na wiwoifo to katai webuaya bei. Na katai nani mani kaiwasa siaio era riati fe manea etamang wei, kontai kaiwasa bitoya paria na nu Yudea foi tantenang, bendari Yerusalemi, tuti munue beru na nafareng rau, Tirusi tuti Sidoni. ");
INSERT INTO amk_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Era ma weo etaramio Yesusi deunaufo tuti waraira ene fimaninang, kontai mano inggira dohonsa fosa ambori ebeng. ");
INSERT INTO amk_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ampafe kaiwasafoi kiai, esera we eru na ne taraifoi, weo mambiriufei dari nai mandiai, ambori ebeng. ");
INSERT INTO amk_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Mayeai Yesusi seite ne inontarai erariati fosa aha kawuru, ambori dei wesa deyo, “Mano mene pari fiwa mea, mesobu ne maifo ampa weo meaino meminohi we Seng Allai ne inontaraifosa na ne Mananu rorong fo ne. ");
INSERT INTO amk_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Mano na ninai mewawisi ne mea, mesobu ne maifo, weo ambori memamosi ki. Mano na ninai mesai ne mea, mesobu ne maifo, weo ambori memiri ki. ");
INSERT INTO amk_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Mano meraria Kaisung Inontarai ne yau, wedaya inontarai enemirireu mea, etata mea, etei babera mea, tuti eteiaya mewonomiwa weo esahuai we fikarira fine, mea mani mesobu ne maifo. ");
INSERT INTO amk_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Enari tonana mani, mefaraise tuti memararising to, weo tarai tofino, mesobu fiembaitafo fuba paria na Waidani. Mefaraise tonanai weo wiro memeiri mea mesodai dadirafo tonana kaha, weo mene tarai kariri nabi fafongfa fosa, weo mano enari kanggani mea ninisa ene werengfosa fafongfa enari kanggani nabifosa kontai tonanai kawuru ampa, ampafe finanai deinawiai we menari ne maifo, mai kariri nabi fafong fosa enari ne maifo. ");
INSERT INTO amk_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Mano mene fiwa mea mani, mesobu ne karira rai, weo mesobu mararising na nunei ampa. ");
INSERT INTO amk_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Mano nina mani memamosi ne mea, mesobu ne karira rai, weo ambori mewawisi ki. Mano nina mani memiri ne mea, mesobu ne karira rai, weo ambori mearomikuayai tuti mesai ki. ");
INSERT INTO amk_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Mano mesobu fayai ria kaiwasa bitoya foi, mesobu ne karira rai, weo na fafongfa ene werengfosa efiai nabi tarai kaha fosa tonanai kontai.” ");
INSERT INTO amk_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Manamo yeisaharai we mea mauo, yeyo; Menemiwawu mene aitetafosa. Metohong beng we mano enemirireu mea fosa. ");
INSERT INTO amk_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Metohong mahikaifo we mano etei kanggani mea fosa; mewenadi we mano etarikang mea fosa. ");
INSERT INTO amk_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Manei bioipa metaramirei domoya wa mani, metohong metaramirei dowei wa kontaia bioiparai. Tuti manea etawa mene ansung boriai wa mani metohong mene ansung siai wa kontai. ");
INSERT INTO amk_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Manei dedo mea we mene fiea mani, metohong kaririaia. Tuti manea etawa mene fieai mani, metutang weai aha fanai. ");
INSERT INTO amk_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Na fifiani kontaio, menari sua inontarai siai fosa, mai kariri metawi weai we ea kontai enari we mea fo. ");
INSERT INTO amk_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Masino menemiwawu te mano enemiwawu mea fosa kontai tera mani, fiembaitai fianai aino mesobua ne? Weo inontarai sasari fosa kontaio enemiwawu inontarai mano enemiwawusa fosa. Ampafe todoni kontaio menemiwawufo fuba sewasa. ");
INSERT INTO amk_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Tuti metohong beng weo mano etohong beng we mea fosa terai, nana mani mesobu imbaitai fiani rai? Weo inontarai sasari fosa enari tonanai kontai. ");
INSERT INTO amk_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Metohong fieai, ra ete doi, we inontarai mano menemitawansa we eriwang aha. Nana mani mesobu fiembaitai fiani rai? Weo inontarai sasari fosa kontai, etohong fianggeng we inontarai mano enemitawansa fosa, ambori eriwang mani fuba kaririai aha. ");
INSERT INTO amk_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Wiro tonana kaha. Mae mea menemiwawu mene aitetafosa tuti metohong beng wesa. Metohong fieai wesa mani, wiro menemitawanai weo eriwang we mea aha ma fanai. Nanaya mani mene fiembaitafo fuba, tuti ambori ahu mea we Seng Mano Dedai Mantaung ne arikang dino mea. Weo Seng Allai mani, enewawu inontarai mano etohong mahikai kaha fosa, tuti mano ewarami aipaya fosa kontai. ");
INSERT INTO amk_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ampafe menemiwawu wawera mea, karirio metamamifaini enewawu kontai.” ");
INSERT INTO amk_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Wiro metinggai finong inontarai fanai, ampafe Seng Allai kontai kiutu kaiwo kariri mea kaha. Tuti wiro metohong maraba we inontarai siai fanai, ampafe Seng Allai dohong aiboi we mea kaha. Mae meteiai inontarai, ambori Seng Allai deiai mea kontai. ");
INSERT INTO amk_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Metohong finong fi we inontarai siai, ambori Seng Allai dohong finong fi we mea ki, ambori mesobu fiohonia fiabai fei ki, andino tituatia mikeu we mea. Weo mene metitua we inontarai siai fo mani, Allai yu we titua mea nayai kontai ki.” ");
INSERT INTO amk_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Mayea mani Yesusi deiriri kaiwo yiwansoa fo tonina, “Inontarai urengfafa manei, bing mano urengfafa manei kontai, nana mani ambori utau rarang kamirei bei ki. ");
INSERT INTO amk_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Inontarai sobu aunau ne wiro fiabai sewa ne mantaunaune kaha. Wape arikangfosa esobu aunau na mai pampang mani, ene tarai toyari ene mantaunaufoi. ");
INSERT INTO amk_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","We fianie ai nukahai niayai na mene doroifoi urengfo mewati pari, mae airape niayai na meuremiwai mewatioi kahai nina? ");
INSERT INTO amk_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Todoni fino metei we mene doroifosa meteyo, ‘Doroie, ro ma ikabi ai nukahai niayai na uremuwai wo,’ wape airape niayai pampang na meuremuwa wiro mewatioi we mehabioi kaha? Inontarai menari fayafayarai ne meai ne, mehabio airape niayai na meuremiwa akawuru wo, ambori mewatipa ai nukahai niayai na mene doroifoi urengfo we mehabioai werui fe.” ");
INSERT INTO amk_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Ai koi denteng foi mani, ne bongfoi denteng, mae ai koi kerira foi mani ne bongfoi kerira. ");
INSERT INTO amk_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Aifoi mani aroansoi na bongfoi. Wai sirarami nei wiro webong angguri kaha tuti boburainei wiro webong urung kaha. ");
INSERT INTO amk_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Inontaraine tata tonanai kontai. Inontarai mano denteng foi niarifo beng, we enerorongfoi denteng fefe. Wape inontarai mano kerira foi niarifo karira, weo enerorongfoi kerira. Weo fifiani aino dotu na borongfoi mani, finanai dari na enerorongfuisi mandiai. ");
INSERT INTO amk_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“We fianie mesahu yau we mene Seng, wape wiro metohong karirio fiani aino yeisaharai we mea ne nina kaha? ");
INSERT INTO amk_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Mano da ma tarao nehu kaiwo aunau ne, dohong kaririai na mai foi, amani yeisaharai we mea mau, mano nani mani ne tarai kariri mano niari munu. ");
INSERT INTO amk_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Niari ne munufoi mani, sirai aweu berorong ambori sau titawangno diri neungfo na kamamiai. Ampafe rahida bo wayafoi wefoa, foafoi dautaia sobu munufoi mani, deda bariri kaha, weo inontaraifoi niari amangfoi pepayai fefe. ");
INSERT INTO amk_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Wape inontarai mano tarao nehu kaiwone, mae dohong kariria kaha, i mani ne tarai kariri inontarai mano niari ne munufoi, niariri sau kahofa wowongfo terai. Foafoi sobuifo, deda bariria sawaia, ampafe aikahiafoi kerirawa kiaya.” ");
INSERT INTO amk_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesusi medu we kaiwasa bitoya foia kaia fo, da werusa suai to munue Kapernaumi afui. ");
INSERT INTO amk_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Na wana mani inontarai fuba yu rai mamuna manei, amani Mananu Kaisari ne inontarai Roma manei dine. Ne woming manei mani niari sauari paria. Womingfoi meninang ao adareti mireha. ");
INSERT INTO amk_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Inontarai fuba yu rai mamuna foi tarao Yesusi nanafo, demio inontarai ewewafong weo Yahudi fo manei itoru, itora we Yesusia, itorutani weo da wa ambori niari womingfoia denteng. ");
INSERT INTO amk_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Era wa esobu Yesusia, ainanaya etutani weo da riasa weo waraira maninangfoi weru womongfoi, eteyo, “Todoni mani waramuai inontaraio fuba yu rai mamuna foi, ");
INSERT INTO amk_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","weo i mani enewawu Yahudine tata, tuti andino niari munu agama foi we ameane.” ");
INSERT INTO amk_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ainanaya Yesusi da ria eara. Rerai we munufoia mani, inontarai fuba yu rai mamuna foi demi ne maniwowirifosa era ma eteisaharai we Yesusi eteyo, “Deyo, ‘Daie, wiro ro anseunai to nehu mununei ma fanai. Yau mani imai kaha weo yemang we Dai wau na nehu mununei. ");
INSERT INTO amk_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ai wedaya mani mantaung yau irao Dai wau ma kaha. Ampafe modu te kaiwofeaia, ambori nehu womingfoi denteng ki. ");
INSERT INTO amk_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Weo yau kontai nehu fuba isomi wei manei, tuti iru afai mamuna fea kontai. Ampafe imadu we manei yeyo, “Ro,” nana mani da kaririai, tuti imadu we manei aha yeyo, “Ro ma,” nana mani da kaririai ma. Ete we nehu mangfatafoi yeyo, “Nari fininai,” nana mani niari kaririai. Yeitawanai we Dai Wau tonanai kontai. Fiani aino boyoa mani, kariria rai.’ ” ");
INSERT INTO amk_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesusi tarao rai mamuna fuba foi medu tonanafo pepuhung paria. Deti berahai tuti medu we kaiwasa bitoya era riati fosa deyo, “Kei! Inontarai nini andiaranane. Na inontarai Israeli nesa kiai wiro iwati manei yoaso yau ne fuba kariri tonina kaharai.” ");
INSERT INTO amk_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ainanaya inontarai mano demi ea fosa, etaraberasa to munufo aha mani, womingfoi dentengna. ");
INSERT INTO amk_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Waroi ahang kaha mae, Yesusi da to munue wonong fino Naini. Ne inontarai suraya mandu fosa tuti kaiwasa siai kontai era riati. ");
INSERT INTO amk_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Da wa rerai we rahutu borong munue nanai, tete kaiwasa na munuefo eha bariboai mireha manei ariai we esarai. I mani, wiwina manei ne arikang dine, tuti meiri kawuru andinania. Kaiwasa nani era ria wiwinafoi. ");
INSERT INTO amk_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Mayeai Seng Yesusi detiao wiwinafoi, enerorongfoi sawai wei, aroi. Ainanaya medu wei deyo, “Wai fanai.” ");
INSERT INTO amk_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Mayeai da wa waratawang fatafoi. Ainanaya inontarai ehari fo efotousa etoa, Yesusi medua deyo, “Bariboaiwa waune, yemi wau, boabari wau.” ");
INSERT INTO amk_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Na tatofang kutu nanai bariboai nani doa bariria minohi, tuti medu wesa. Ainanaya Yesusi dohoni we inanaia. ");
INSERT INTO amk_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Kaiwasa fuba nani ematai tuti esomi we Seng Allai, etaparandini eteyo, “Nabi fuba manei da woru tata. Allai da kawuru ma weo dohong mai we ne kaiwasanei.” ");
INSERT INTO amk_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ainanaya Yesusi wonongfo etaiririai wari nu Yudea foi kontai munue watai waria fo tantenang. ");
INSERT INTO amk_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Mano eraria Yohanesi fosa etei kaririai we Yohanesi na aitamu rorong, kariri fiani aino Yesusi niari fo. Amani Yohanesi sahu ne inontaraifo mandu, ");
INSERT INTO amk_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ambori demi uru urao Yesusia urutani tonina, “Wau mani Mananu Mamparirio ambori ro ma foi di wau e, ete ametamang we inontarai siai manei e?” ");
INSERT INTO amk_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ampafe Yohanesi ne inontarai mandu fo ura we Yesusi tuti umadu wei ureyo, “Yohanesi mano webaptisi kaiwasa foi demi auru ma aurutang bera Dai wau, wauno mano ambori ro ma rai, kariri Seng Allai ne kaiwo arerafo, ete ametamang weo inontarai siai manei e?” ");
INSERT INTO amk_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Na rahida nani mani, Yesusi niari inontarai emaninang finomai bitoya ebeng, data inggira, tuti niari mano euremifafa ewati aha. ");
INSERT INTO amk_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ampafe Yesusi yoa deyo, “Murarabera muru we Yohanesi, murai kaririai wei, kariri fiani aino mutaramioai tuti muwatioa ne, mano euremifafa ewati, mano efaya etoa era, mano emaninang kusta ebeng, mano etarami pararo fosa etaramiofi, mano emarareha esuwi aha, tuti mano ene pari fi fosa iwuwu Kaiwo Mahikai fo wesa. ");
INSERT INTO amk_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Tuti mano wiro enemirorong soriru we yau kaha fosa, esobu ne maifo.” ");
INSERT INTO amk_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yohanesi ne inontaraifo ura wa, ainanaya Yesusi medu kariri Yohanesi we kaiwasa bitoya foi, deyo, “Raminde nanai mera to katai wekamamiei minano foi we mewati fiani nai, mewati ninoi wanamba sowawerahi foi e? Bireri, we i mani, inontaraio yu kaiwo mutu dine! ");
INSERT INTO amk_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ampafe mera wa we mewati fiani, mano sensuni na ansung kaiwewa denteng foi e? Bireri, weo inontarai esansunsa na ansung tonana fo tuti ene fi bitoya fosa mani enayai na munu mananu fo terai. ");
INSERT INTO amk_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ampafe mandoni dino mera we mewatioi ne? Nabi manei e? Tarai, wape yeikaririaifa we mea yeyo mano mera we mewatioi nani mani fiabai sewa nabinesa kiai. ");
INSERT INTO amk_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Weo i mani andino Allai medu kaririai na ne Kaiwofo dotu tono: ‘Mewati ma! Yemi nehu inontaraio kia nehu kaiwone manei, da foni Wau. I ambori meinenang nemu rangfoi we Wau.’” ");
INSERT INTO amk_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yesusi medu aha deyo, “Tarai, imadurai we mea mau yeyo, na inontarai fuba saubaunung na nunei nini, manei wiro fiabai sewa weru Yohanesi nini kaha. Wape na ninai to fong mani, inontarai mano ehatui sewa na Allai ne Mananu rorong fo ansaino efabai sewa Yohanesi fo.” ");
INSERT INTO amk_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Kaiwasa sentenang, kontai mano efanduhi pajaki we parenta Roma foi fosa etarababerasa weru ene sasarifoi ampa, ampafe Yohanesi webaptisisa ampa. Ampafe donio rabuang bo Yesusi medu fimai kariri Yohanesi mani, eroaoai paria. ");
INSERT INTO amk_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Wape inontarai eweFarisi tuti mantaunau Kaiwo Musai soi fosa, ea etarababerasa weru ene sasarifoi kaha, etaramididau kaiwo Yohanesi medura fo kaha, tuti wiro emaya we Yohanesi webaptisisa kaha. Ampafe donio fi Yesusi medu kariri Yohanesi fo mani, eroaoa kaha. ");
INSERT INTO amk_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ainanaya Yesusi medu aha deyo, “Fiani andino iriwanso kariri inontarai rabuang bonini sa ne? Etoyari fiani ne? ");
INSERT INTO amk_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ea ene tarai toyari arikang eminohi na pasari mae esahu wawerasa eteyo, ‘Amerohi rarung mirising fo we mea, manamo memahai kaha, ameba kayowa, wape wiro mesai kaha.’ ");
INSERT INTO amk_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Weo Yohanesi mano webaptisi nei nini da ma mani, wepuasa tuti dunung angguri kaha, manamo meteyo, ‘I mani Saminseni niai nai.’ ");
INSERT INTO amk_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ainanaya Kaisung Inontarai nei da ma mani dampi, dunung, tuti memadu meteyo, ‘Mewati inontaraifoi denanggoing, meyeru biriu, tuti firao mano efanduhi pajaki we parenta Roma foi tuti inontarai sasari.’ ");
INSERT INTO amk_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Wape Seng Allai sewai sewa. Mano esomi wei fosa etainawi ne awaifo nanai na fimai etohong toa fo.” ");
INSERT INTO amk_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Farisi manei, wonong fino Simoni, wenoti Yesusi weo da wa dampi na ne munufoi. Yesusi da wao Farisifoi ne munufoia, ampafe minohi dampi. ");
INSERT INTO amk_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Na munue nana mani wiwing manei, dohong sasari fiabai. Taraoai weo Yesusi dampi na Farisifoi ne munufoi, ampafe da oi ma, amani kiao maning ninsai mampori botori bei. ");
INSERT INTO amk_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Doa na Yesusi kurufuifo, rurang awerengfo mae sai, ampafe kifa urehurufo to Yesusi awerengfoa wawasa tantenang. Awa kawuru wori dufi Yesusi awerengfoa sarahiai nano nurandaungfoi, mayeai ninahai tuti sara na maning ninsai mampori foi. Niari tonana weo enewawu Yesusi, weo deitawanai ne sasari niaririfi Sempaisi deiairi ampa. ");
INSERT INTO amk_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Inontarai weFarisi wenoti Yesusi foi deti finanafo, dei na enerorong, deyo, “Inontarai nini nabi dine mani, deitawangno wiwingfoi mandoni dine, andino niariri tonanane. Weo i mani wiwing sasari dine.” ");
INSERT INTO amk_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Manamo Yesusi medu weia deyo, “Simone, ye imadu kaiwofea we wau.” Simoni yoa deyo, “Daie, moduraia.” ");
INSERT INTO amk_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Yesusi yiwanso kaiwofea deyo, “Inontarai mandu, amani uka doi ria mano ne doi manei. Manei kiao doi dinari piaring bering (500), tuti manei aha mani kia doi dinari piarua sura. ");
INSERT INTO amk_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Uru ruhiai, wiro ubiriu weo ubai doi uka fo kaha, ampafe mano nengfoi yabang sayarai. Mandoni, na inontarai mandu fosuru, andino enewawu mano ne doi foi sewa ne?” ");
INSERT INTO amk_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simoni yoa weia deyo, “Yau mani, yeo mano kia doi fuba sewa foi andino enewawu mano ne doi foi sewa ne.” Yesusi yoa aha deyo, “Antu! Enemutituaitawa tarai.” ");
INSERT INTO amk_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ainanaya Yesusi deti we wiwingfoia tuti medu we Simoni deyo, “Boti wiwing nini to ne? Ira to nemu mununei ma, amani bohong merehafea damang we iruai awehune kaha, wape wiwing nini yuai awehune na urehurune, tuti dufi aha sarahiai na nurandaungnei. ");
INSERT INTO amk_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Wau mani wiro bomang we yau weo nuna yau kariri tane koangnei kaha, wape wiwing nini wiro fiotou niuna awehurengne kaha, na iari antanafa ira to ninai ma ne. ");
INSERT INTO amk_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Wau mani wiro wara nuhunei na maningfea kaha, wape wiwing nini sara awehurengne na maning ninsai mampori. ");
INSERT INTO amk_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Tarai! Ne enewawufo fuba, weo ne sasari fuba niariri fi Sempaisi deiairi ampa. Wape mano oiairi fuba kaha mani, enewawufo fuba kahai kontai.” ");
INSERT INTO amk_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ainanaya Yesusi medu we wiwingfoia deyo, “Nemu sasarifi yeiairi ampa.” ");
INSERT INTO amk_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Inontarai siai mano eminohi etampi ruhiai ria Yesusi fosa emadu wawerasa eteyo, “Mandoni dinini, doni deiai sasarifi nina?” ");
INSERT INTO amk_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Manamo Yesusi dei we wiwingfoia deyo, “Weo wau roaso yau, ampafe wobu fariri ampa. Ro na maia.” ");
INSERT INTO amk_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Waroi kaharai mae, Yesusi da wariai na bendarifo tuti munuefo, deiriri Kaiwo Mahikai ne kariri Seng Allai da weMananu ma fo. Ne inontarai suraya mandu fosa erariati. ");
INSERT INTO amk_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Kontaio wiwing manea erariati, mano niari eara ebeng weru fimaninang finomai tuti inggirai. Ea mani, Mariai mano ahui we Makdalenaifoi (data inggira itu werui ampa); ");
INSERT INTO amk_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","kontai Yohanai, mano ne mang Kusai mano yufi weo Herodesi na munu mambaiseng foi; Sosanai, tuti wiwing siai bitoya kontai. Wiwingnesa efata Yesusi tuti mano erariati nesa, na mantaunsa ene fifo. ");
INSERT INTO amk_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kaiwasafoi da mutu we Yesusi ma, na munue finomai. Ampafe kaiwasafoi bitoya fianduhi na nanaiya, mayeai Yesusi deiriri fiyiwansoi bei we ea mani sonina, ");
INSERT INTO amk_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Weniari romi manei kia ne aibongfei da wa we sanami. Da wa kifa aibongfoi nanai mani eai sawai na rangfoi. Ampafe inontarai etaha riroyari tuti romu etani. ");
INSERT INTO amk_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Eai kontai sawai na katai wekamamiei. Sa rerorifoi, wape siamorang aha, weo kahofafo sarahiai karerai. ");
INSERT INTO amk_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Eai aha mani sawai na katai weninoi ababo foi, ampafe ninoi ababo foi sifu tamui tuti kehepania memasara. ");
INSERT INTO amk_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Wape aibong fei aha mani sawai na kahofa beng fea, ainanaya sifu ampafe niayaia bongnei bitoya, pariao piaring (100).” Yesusi deiriri fiyiwansoafoia kiaia mani, deya deyo, “Mewemetarami mani metaramioai!” ");
INSERT INTO amk_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Mano eraria Yesusi fosa etutang berahi we fiyiwansoai nani kariri fifiani. ");
INSERT INTO amk_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Yesusi yoa deyo, “Mea mani Allai dohong awai we mea, we mewaitawang kariri ne weMananu rorong fo tuti fi dediwara fo ampa. Wape inontarai siai fosa yeunausa na fiyiwansoai, ambori, ‘Ewatioai tonanai ki, wape ene tarai toyari euremifafa. Etaramioai, wape etafura kaha.’ ");
INSERT INTO amk_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Fiyiwansoafo ne kaiwo tarai finana: Aibongfoi mani yiwanso Seng Allai ne Kaiwone aine. ");
INSERT INTO amk_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Aibong sawai na rangfoi mani, riwanso inontarai mano etaramio Kaiwofoa. Wape Saminseni da ma, dewa Kaiwofo weru enemirorongfo ambori eroasoa fanai, ampafe esobu faririfo kaha. ");
INSERT INTO amk_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Tuti aibong sawai na kahofa wekamamiei wowong fo mani, riwanso mano etaramio Kaiwofo, esobuai na enemirorong mirising. Wape Kaiwofo wiro wenewa na enemirorongfoi kaha. Eroasoai tourai, mae fieai da ma sofara mani, esu to fuia. ");
INSERT INTO amk_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Tuti aibong sawai na katai weninoi ababo foi mani, riwanso mano etaramio Kaiwofo, wape earomikuayai karerai we fi nunei tuti ne rafo tuti ambori eminohi na mai na nunei fo. Ampafe finani kepang kaiwofo paria ne bongfoi wiro wetarai nariai na sa ahang kaha. ");
INSERT INTO amk_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Aibong sawai na kahofa beng fo mani, riwanso mano etaramio Kaiwofo, ainanaya etonai afui nayai na enemirorongno beng tuti mai fo. Ea erutawanai tuti kaiwofo wedayasa etohong beng na etawansa na mai, ne tarai kariri kahofa beng fea wedaya aibong sifu wetarai bitoya.” ");
INSERT INTO amk_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Wiro inontarai manei kiai padamarang bei, ainanaya tebuni na babeu, ete dohoni wiatai na fata arowawahifo kaha. Mae yuai padamarangfoi ayai sawai parai, ambori inontaraio era to munu rorongfo afui mani ewati sambewarafoi. ");
INSERT INTO amk_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Weo fio adiwara ne kiai ambori atioai ki, tuti fio ohonai we kaiwo werorong fo kiai kontai ambori tarami parai na kasau ki. ");
INSERT INTO amk_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ampafe menemitituai saua weai paria kariri fianai aino metaramioai ninai. Weo mandoni dino sobu awaifo ria Allai kawurua fo, ambori sobuafo fuba aha. Wape mano sobua kaha foi, ne kutuo enetituaitai we nengfo kontai kia weruri ki.” ");
INSERT INTO amk_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Yesusi inanai tuti ne tahatuifosa eraoi ma, wape era kefani ma kaha, weo kaiwasa bitoya karerai. ");
INSERT INTO amk_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ampafe inontarai manei medu we Yesusi deyo, “Daie, inamuai tuti nemu tahatuifosa etamang na borieife fo erurai we ehanggung wau.” ");
INSERT INTO amk_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Wape Yesusi yoa wei deyo, “Inontarai mano etaramio Seng Allai ne Kaiwofo tuti etohong kaririai, eaino isahusa we nehu ai tuti nehu tahatui.” ");
INSERT INTO amk_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Rahida bei mani Yesusi tuti mano erariati fosa etau wa rowei. Yesusi medu wesa deyo, “Tawo to ruru eneung dowaruai.” Ainanaya ewo anina. ");
INSERT INTO amk_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Etafai mae Yesusi wiata dena. Mayeai dedukafoi bia tantuma na rurufoi. Merehafoi dau wafoi, awao adareti etaisui. ");
INSERT INTO amk_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Mano eraria Yesusi fosa era wa ebauni. Emadu wei eteyo, “Daie, Daie, tanai rai!” Yesusi doari meai, ainanaya medua sua wanangfoi tuti andeisa peperami foi. Wanangfoi tuti andeisafoi meringna, ainanaya rurufoi mering na tantumara. ");
INSERT INTO amk_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ainanaya Yesusi medu we mano erariati fosa deyo, “Todonie wiro meroaso yau kahai nina?” Ea epapuhung tuti ematai. Ampafe emadu wawerasa eteyo, “Inontarai nini mani mandoni dine, doni sua wanangfoi tuti andeisafoi mani, mering kaririai.” ");
INSERT INTO amk_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesusi tuti ne inontarainesa etafai finanaya paria sobu katai Gerasa na ruru Galilea eneung dowaruai. ");
INSERT INTO amk_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","29","Na katai nani inontarai inggira dohoni manei. Inontaraifoi mani na munue nana. We beiru teai ampa mani inggira dohoni, ampafe warangfo tuti awengfo wora na wai besi tuti na fora tuti waitawang weduaria papayai, wape kehutui kontai, ambori inggirafoi kiari to katai manano fea. Tuti waroi ampa wiro sensuni kaha, tuti miaya we minohi na munufo kaha. Mae deo niayai terai na we winsaburungno etohonai we kubirifo. Yesusi bia da warei mani, inontarai inggira dohoni foi daoi ma. Detia Yesusifo bibe, mayeai sawaia disang kapari wiatai na Yesusi awerengfo. Mayeai Yesusi demi inggirafoi da to woriai werui, ampafe sahu, deyo, “Yesuse, Allai mano dedai sewa nei ne Kaisungne Waune, boyo bohong yau tofino? Todoni kontaio wiro mung kanggani yau fanai.” ");
INSERT INTO amk_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Yesusi dutang bera inontaraifoi deyo, “Wonomu fidoni?” Ampafe inggirafosa eroa, eteyo, “Amewonomi fino Raifi,” weo inggira bitoya paria enayai nai fefe. ");
INSERT INTO amk_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Inggirafosa etutang Yesusi paria, eteyo wiro datasa to Soroha rorong foi fanai. ");
INSERT INTO amk_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Kefang na kataifoi, na wiwoi tarareifo mani, fiai rabuang nei enaya esung. Inggirafosa etutang Yesusi paria eteyo miaya mani, demisa esuai na fiaifosa. Ampafe Yesusi yoa we fi etutana fo. ");
INSERT INTO amk_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ainanaya inggirafosa era to boriai tuti esuai na fiaifosa. Ampafe fiaifosa emito beyari esea na katai kenatatera fo to rurufoi aweu, emarareha naya. ");
INSERT INTO amk_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Mano ewaitawang wedua fiai fosa ewati fitantumafe nana fo emitoa etaiririai na bendarifoi tuti na munue watai ruramai na nanafo we kaiwasafoi. ");
INSERT INTO amk_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Ainanaya kaiwasa na munue fosa era wa ewati kariri finanai. Era mao Yesusi amani ewati inontaraifoi rai inggira foi da weruia, mae minohi rurang Yesusi awerengfo sensunia tuti medu finomai aha kaha. Ampafe ematai. ");
INSERT INTO amk_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Mano ewati te fitantuma Yesusi niari we inontarai inggira dohoni foi, eteikaririai kariri fianai aino ewati terai nanai we kaiwasa era ma fosa. ");
INSERT INTO amk_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ainanaya inontarai Gerasa fosa kiai, ematai tantenang paria, ampafe etutang Yesusi weo da weru ene kataifoi. Ainanaya Yesusi dautai to wafoi aha, we ete etafai. ");
INSERT INTO amk_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mayeai inontarai rai inggira foi tifa weruia nani dutang Yesusi paria weo dontai riati. Manamo Yesusi demi da wa medu wei deyo, ");
INSERT INTO amk_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Barabera wau to nemu munufoia tuti boiriri kariri fiani aino Seng Allai niari we wau ne.” Ampafe inontaraifoi da wa, wiuwuo fianai aino sodaira fo tuti kariri fianai aino Yesusi niari wei fo wari bendarifoi sentenang. ");
INSERT INTO amk_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesusi daraberahi to ruru eneung dowarui aha mani kaiwasafoi piraise, weo enaya etamang wei fefe. ");
INSERT INTO amk_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Mayeaia mani inontarai wenunggamiai na munu agama Yahudi bei na kataifoi, da we Yesusi ma. Wonong fino Yairusi. Disang kapa awebuka na Yesusi arongfo tuti dutani nano enetawanai beyari, ambori Yesusi da to ne munufoia. ");
INSERT INTO amk_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Weo ne kamitung tarai mansiari kawuru, fiabai ne defuina suraya boru ampa, meninangna adareti mireha. Ainanaya da to Yairusi ne munufoi mae kaiwasa na kataifoi sentenang da sawari ene tarai sopapari, weo efau fefe. ");
INSERT INTO amk_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Na kaiwasa bitoya nani, wiwing manei meninangno rika defairi. Sodai maninang nani defuina suraya boru ampa. Manggarawangfosa kontaio, wiro manei biriu we niariri denteng kaha. ");
INSERT INTO amk_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Wiwingfoi da kefang we Yesusi na kurufuifo, tuti warangfoi disangso ne ansung awerengfo. Na kutu nanai kontaio rika defairi foi fiotouraia. ");
INSERT INTO amk_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Yesusi dutang deyo, “Mandoni dino warang disangso yau ne?” Kaiwasafoi sentenang mani emadu eteyo, “Amea ma bereri.” Ainanaya Petrusi medua deyo, “Daie, kaiwasanei bitoya soru wari wau ampafe manta esawa wau.” ");
INSERT INTO amk_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Wape Yesusi deyo, “Wape manei warang disangso yau. Yeitawanai, weo nuhuruainsoai we mambiriufeai dariai na yau mau wa.” ");
INSERT INTO amk_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Wiwingfoi deitawanai weo Yesusi deitawang fi antanafa niari fo, ampafe mitaia rirora beyari, da ma disang kapa awebuka na Yesusi arongfo. Arahio deiririai na kaiwasa bitoya foi urengreafo, weo todonie dohong warangfoia disangso Yesusifo tuti ne maninangfoi wedenteng na kutu iari nana fo. ");
INSERT INTO amk_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Yesusi medu weia deyo, “Kamitungne waune, nemu roaso yau wa wedaya bonteng ampa. Ampafe ro na maia.” ");
INSERT INTO amk_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesusi doa medu tonana rai mae, inontarai etemi manei da na Yairusi, mano wenunggamiei we munu agama Yahudi foi, ne munu foi ma fo, medu deyo, “Daie, nemu kamitungfi mireha ampa. Ampafe wiro ka anseung Dai Mantaunaunei ahang fanai.” ");
INSERT INTO amk_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesusi taraoai nanafo medu we Yairusia deyo, “Mutai fanai, mae roasoai terai, tuti nemu kamitungfoi denteng ki.” ");
INSERT INTO amk_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Awao Yairusi ne munufoia mani, Yesusi datapio kaiwasafoi manei da riati afui fanai, mae manta Petrusi, Yohanesi, Yakobusi tuti arikangfoi inang tamang suru, itoru terai. ");
INSERT INTO amk_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Kaiwasafoi kiai saia deidu we arikang mireha foi. Manamo Yesusi medu deyo, “Mesai fanai, weo arikangwai mireha kaha, mae dena.” ");
INSERT INTO amk_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ampafe emarari Yesusi paria, weo ewaitawanai we kamitungfoi mireha kawuru ampa. ");
INSERT INTO amk_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Mayeai Yesusi yu na arikangfoi warangfo tuti medu wei deyo, “Arikangne wau, boa to!” ");
INSERT INTO amk_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Arikangfoi ne ansengfoi daraberahi wei aha ma, ainanaya doabariria nina. Awa kawuru wori Yesusi demisa weo etohong fidangfea we dang. ");
INSERT INTO amk_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ne wawafo suru upapuhung beyari. Manamo Yesusi deipi suru weo wiro uraisaha finiarifo we manei fanai. ");
INSERT INTO amk_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesusi sahu ne inontarai suraya mandu fo efanduhisa, ainanaya dohong tapapa tuti wemambiriu we ea, ambori etata inggira tuti enari fimaninang. ");
INSERT INTO amk_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Mayeaia mani demi ea era we enari inontarai maninang tuti etairiri kariri Seng Allai ne Mananu rorong fo. ");
INSERT INTO amk_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Yesusi medu we ea deyo, “Wiro meha fieai ria mea na rang rorong wa fanai. Wiro meha aitatohi, ete rotang, ete fiang, ete doi, ete ansung beru kaha. ");
INSERT INTO amk_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Na munu bodoni, etutang tawang mea mani, menayai nai paria mera weru munue nana. ");
INSERT INTO amk_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Wape na munuefea, eteiaya mea mani, awao mera weru munue nana mani, mehafa titai kangganang niayai na meawemiwa, we fiainawiai wesa kariri Allai ambori deiayasa fo.” ");
INSERT INTO amk_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Yesusi ne inontaraifosa era finanaya, era na munuefeai to munuefeai weo etairiri kariri Kaiwo Mahikai fo tuti enari we emaninang ebeng na kataifoi sentenang. ");
INSERT INTO amk_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Herodesi Antipasi mano wemambaiseng na nu Galilea foi, tarao fi Yesusi niariri na kataifoi sentenang, ampafe dohona serawawerahai. Weo manea eteyo Yohanesi mano webaptisi kaiwasa foi suwi na marareha rorong fe aha nina. ");
INSERT INTO amk_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Manea kontai eteyo nabi Eliai suwi aha ma nina. Manea siai kontai eteyo, nabi manei nafino nabi fuba fafong faini kiai andino suwi aha nina. ");
INSERT INTO amk_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Herodesi deyo, “Yohanesi mani yemi nehu inontarai eferang kutu rahanangfi ampa. Wape inontarai nini mandoni dine? Tarahuo kaiwo bitoya beyari kariri i ampa.” Ampafe Herodesi sera we deti Yesusi. ");
INSERT INTO amk_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yesusi ne inontarai suraya mandu fosa, amani ne rasulifosa, etaraberasa tuti etaiririai we Yesusi kariri fiani aino enari ampa. Yesusi dutansa we era riati, ainanaya era ruhiai to munue Betsaida weo enayai futuai na wana. ");
INSERT INTO amk_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Manamo, mayeai kaiwasafoi ewaitawang katai bo Yesusi daoi foi, ampafe enumi riati. Demang wesa era ma, ainanaya medu kariri Seng Allai ne Mananu rorong fo wesa tuti niari inontarai emaninang fo ebeng. ");
INSERT INTO amk_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Wofoi de sawaia mani, ne inontarai suraya mandu fo era Yesusi ma emadu wei, eteyo, “Daie, katainei minanai. Ampafe mahikai sewa mani, Dai bemisa era, ambori esera we fietang tuti katai etena naya fea, na bendari tuti munue watai riruramai na ninane.” ");
INSERT INTO amk_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Wape Yesusi yoa wesa, deyo, “Todoni kontaio meaino metohong fiang we etang.” Yesusi ne inontaraifosa eteyo, “Tane roti ring kawuru tuti diang mandu, mae amera wa amewori fiang we kaiwasanei reto.” ");
INSERT INTO amk_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Manamo Yesusi medu we ne inontaraifosa aha deyo, “Metemi inontarainesa eminohi werabuang, ewepiarua sura teai rabuang bei.” Mang titou mani piaura wering wering (5.000) teai. ");
INSERT INTO amk_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Yesusi ne inontaraifosa etohong kariri fiani aino deyoai we ea fo, etemi kaiwasa eminohi tonanai. ");
INSERT INTO amk_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ainanaya Yesusi kia roti ring fo tuti diang mandu fo, fioai ureng deti to rorafaisi tuti dutang tuti fiangfo we Allai. Mayeaia mani fiobabau roti tuti diangfo na warangfoa kawuru wori, dohoni ne inontarai erariati fosa weo etatorai we kaiwasa bitoya foi. ");
INSERT INTO amk_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tuti kaiwasafoi dampi ao memosi beyari. Mayeai Yesusi ne inontaraifosa efanduhi fiang seari foi mani, bayai suraya boru. ");
INSERT INTO amk_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Rahida bei mani, Yesusi mesiri wenadi we Sempaisi, mayeai ne inontaraifosa era wei ma. Yesusi dutang wesa deyo, “Kaiwasa bitoya foi emadu eteyo mantei di yau?” ");
INSERT INTO amk_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ne inontaraifosa eroa wei eteyo, “Manea eteyo Yohanesi mano webaptisi kaiwasa foi di wau. Manea kontai eteyo nabi Eliai di wau, tuti manea kontai eteyo wau mani nabi manei nano fafongfa suwi aha ma nina.” ");
INSERT INTO amk_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Yesusi dutansa aha deyo, “Wape na mantaung mea mani meteyo mandoni di yau?” Petrusi yoa deyo, “Daie! Wau mani Mananu Mampariri fi di wau.” ");
INSERT INTO amk_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ainanaya Yesusi deretawansa, demisa we dohonao ewuwuai we kaiwasa siai fo kariri i weMananu Mampariri fo fe. ");
INSERT INTO amk_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Mayeai medu aha deyo, “Kaisung Inontarai nei ambori sodai dadira bitoya ki. Imami baba fosa, tuti mantaunau Hukumi Musai soi fosa, ambori eteiayari ki. Tuti ambori emunia mireha, wape werahida botoru aha mani, suwi na marareha rorong foi aha ki.” ");
INSERT INTO amk_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ainanaya dei we kaiwasa fuba wani, deyo, “Mandoni dino deyo daria yau mani, deiaya mantauni fi dohong weai na nunei fo, tuti rahida neungne sodua ne aitabafoi, amani meinenang we sodai dadira kariri yau, tuti daria yau pampang. ");
INSERT INTO amk_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Weo mandoni dino de derara mantauni ne ansengfoi sewa weru daria yau mani ambori ne ansengfoi wioru ki, mae mandoni dino na nufi ninai enewawu yau awao wonohune wedaya tarahi mireha kontai ki, i ambori sobu numainufo ki. ");
INSERT INTO amk_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ampefe manei yurai we sobu nunei sentenang, wape ambori nuaninufoi wioru tuti sobu numainufo kaha mani, we fianie yurai karerai nina? ");
INSERT INTO amk_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Mandoni mimaya we yoa tuti yau, tuti nehu Kaiwone, nana mani Kaisung Inontarai nei kontai mimaya we yoa tutiri ki, na rahida bo da na ne sambewarai dadai fo, kontai Dai ne sambewarai dadai fo tuti wewaifosa. ");
INSERT INTO amk_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ampafe yeoai na kaiwo tarai we mano metoari na nina ne mea, manea wiro emarareha kahai paria ewati Seng Allai weMananu ki.” ");
INSERT INTO amk_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesusi deunau kaiwasafoia kawuru, werahida indeatoru aha mani, dau to uai bei aweai weo wenadi we Sempaisi, kia Petrusi, Yohanesi, Yakobusi. ");
INSERT INTO amk_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Dutanaia mayea urengfo siaiya tuti ne ansungfo bua karofari awa kaiwewa tantenang. ");
INSERT INTO amk_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Mayeai inontarai mandu uroa na sambewarai riati, umadu wei. Inontarai mandu nansuru mani, Musai kontai Eliai, nabi na fafongfa mandu aine. Itomadu karirio Yesusi weo da wa, mireha na Yerusalemifo, toyari nabifosa esoi kariria fo. ");
INSERT INTO amk_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ainanaya Petrusi konta mandu itora fo itoru itouremi mamong paria. Itoroabari itoru na mamong rorong foi, itowati Yesusi ne sambewaraio dedai foi awao keiwewa, tuti inontarai mandu uroa rurami. ");
INSERT INTO amk_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Inontarai mandu fo ure ura wiru Yesusi, mayeai Petrusi deyo, “Daie, mahikai paria we tanayai na katai nini. Mahikai mani antonari warumai botoru, ambori bei we Dai wau, bei we Musai, tuti bei we Eliai.” (Wape Petrusi enetituai kaiwo medura fo kaha.) ");
INSERT INTO amk_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Medu tonanaifara, mayeai kafafe biua karofari bei sea ma sorusa kiai awafui enai na kafafe rorong fo awa Petrusi, Yohanesi tuti Yakobusi itomatai beyari. ");
INSERT INTO amk_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Mayeai na kafafe rorong fo rawafui bei medu deyo, “Nehu Kaisung yiriri dinini. Metaramididauwi.” ");
INSERT INTO amk_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Raofuifoi dotu tuti kaiwofo kaiya, itowatia mani Yesusi meiri doa siai. Na rahida nani itonemboru mamunggasai, wiro itoreisaha obu fi kuteai we manea ahang kaha pariao waroi. ");
INSERT INTO amk_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Kameaia mani Yesusi tuti ne inontarai mantoru fo itobia na uaifoi meu. Mayeai kaiwasa bitoya foi dao Yesusi ma. ");
INSERT INTO amk_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mang manei sahu abu kaiwasa bitoya foi deyo, “Daie, boti nehu kaisungnei wo. Nehu arikang tarai kutu mansiari andiaranane. ");
INSERT INTO amk_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Awao inggirafoi dohoni ma mani, bibe tantuma, tuti ne tarai fiotatouri pariao urengfo baibuara, tuti borong kawawuai tipu. Inggirafoi wiro sawini na ea kaha, mae adareti dohoni pampang. ");
INSERT INTO amk_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kawuruao yutang Dai nemu inontaraiwasa we etata inggirafoi, manamo ebiriu kaha.” ");
INSERT INTO amk_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesusi yoa deyo, “Meai aranane? Kaiwasa fuinini mea, tarai weinontarai meroasoa di mea kaha tuti mera sarawai. Inai rahang mea tuti itawang yau we mea pari kidoni wori meroasoai ki? Ka nemu kaisungwai to ninai ma!” ");
INSERT INTO amk_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Arikangfoi da we Yesusi ma rai mae, inggirafoi biariri aweu tutu dohoni fiotatou ne taraifoi. Manamo Yesusi data inggirafoi to boriai, ampafe arikangfoi dentengna. Ainanaya dohoni tiwera we tamanai aha. ");
INSERT INTO amk_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Kaiwasafoi sentenang epapuhung we ewati Seng Allai ne mambiriufo fuba fefe. Kaiwasafoi pepuhung we fi Yesusi niari fo rai mae, Yesusi medu we ne inontaraifosa deyo, ");
INSERT INTO amk_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Mewati kaririai na mahikai tuti mearomiporo kaiwo yeoa ne fanai. Kaisung Inontarai nei ambori etohoni to mano ewarami aipaya fosa ewarami rorong fo ki.” ");
INSERT INTO amk_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Manamo mano eraria Yesusi fosa wiro enemitituai sobu kaiwo deyoa fo kaha. Fi nanai dohonai we kaiwo werorong we ea ambori enemitituai sobua fanai. Tuti ea kontai ewearira we etutang kariri kaiwofo we Yesusi. ");
INSERT INTO amk_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Yesusi ne inontaraifosa esawasa weo mantei dino fiabai na sa fo. ");
INSERT INTO amk_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesusi deitawang fi enemitituaita fo, ampafe kia arikang manei ma dohoni doa rurami. ");
INSERT INTO amk_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Ainanaya medu we ne inontaraifosa deyo, “Mandoni dino demang we arikangnei na mai na wonohune mani, wenani mani demang we yau kontai. Tuti mandoni dino demang we yau mani, demang we mano demi yau foi kontai. Weo mano ketui sewa nano mea kiai foi andino fiabai sewa ne.” ");
INSERT INTO amk_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Yohanesi deyo, “Daie, amewati inontarai manei data nuaninu kerira na Dai wonomune, ampafe ametei weduari, weo i mani wiro na tata kaha.” ");
INSERT INTO amk_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Wape Yesusi deyo, “Wiro meteiweduari fanai. Weo mandoni dino dapa mea kaha mani, wenani sau we mea.” ");
INSERT INTO amk_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Yesusi ne rahida neungfo rerai we dautai to Waidani, amani deiya futuai weo da to Yerusalemi. ");
INSERT INTO amk_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Ampafe demi ne inontarai era foni i. Mano demisa fosa era wa esuai na munuefeai na nu Samaria, weo emainenang fieai we Yesusi. ");
INSERT INTO amk_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Manamo inontarai na munue nanai emaya weo etamang we Yesusi kaha, weo ewaitawanai weo medua futuayai weo da to Yerusalemi fefe. ");
INSERT INTO amk_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Yesusi ne inontaraifo mandu, Yakobusi tuti Yohanesi uwaitawanafo, umadu weia ureyo, “Daie, maya mani, tatutang we adia na rorafaisi meuo, kaso inontaraifosara eworua ne?” ");
INSERT INTO amk_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Yesusi deti berahai, mae sua suru. ");
INSERT INTO amk_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Mayeaia mani, era to munue siai feaia. ");
INSERT INTO amk_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Yesusi tuti ne inontaraifosa era finanaya, mayeaia inontarai manei medu we Yesusi deyo, “Daie, yeo ira ria wau to katai bodoni kontaio dino ro oa fo.” ");
INSERT INTO amk_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesusi medu wei deyo, “Wintumangne mani ne kamirei we wiatai nai, tuti romunei kiai kontaio ne aisangging. Wape Kaisung Inontarai nei ne pari katai we wiatai nayai.” ");
INSERT INTO amk_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Mayeai Yesusi medu we inontarai manei siai aha deyo, “Ro ria yau.” Manamo inontaraifoi deyo, “Daie, boiai yau ira wa kio dai mireha isarai akawuru wo.” ");
INSERT INTO amk_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Wape Yesusi yoa deyo, “Ro ria yau, mae tua mano eroaso yau kaha fosa we esarai mano emarareha fosa ki. Wape wau, roa mani boisaha kariri Seng Allai ne Mananu rorong fo, weo Seng Allai wemananu ampa.” ");
INSERT INTO amk_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Manei siai kontai deyo, “Daie, ye ira ria wau, manamo boiai yau ira wa yutang we nehu terafosa akawuru wo.” ");
INSERT INTO amk_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Yesusi medu we inontaraifoia deyo, “Manei de daria yau mani, aroporo fi nunei, mae de daraberahi aro fi nunei mani, wenani mai we niarifi we Seng Allai ne Mananu rorong fo kaha.” ");
INSERT INTO amk_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Mayeaia mani Yesusi diri inontarai piatorua sura aha (70), ainanaya demisa era we mandirutiai, erafoni i to munue de daoa fo tantenang. ");
INSERT INTO amk_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Yesusi deya deyo, “Aibong etini foi bitoya, wape mano etetini fosa efau kaha, ampefe metutanai we mano wenunggamiai we fietini foi ambori denatu mangfata efau we eteting aibongfo. ");
INSERT INTO amk_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Yo, mera to! Metarami finina; yemi mea mera we mewuwu wonohunei fo, mene tarai toyari domba enayai rahang serigala rabuang. ");
INSERT INTO amk_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Wiro meha aderi ete rotang ete sapatu fanai. Meha kaiwone mera wa amani mera to fong terai, wiro mewati beraha fanai. ");
INSERT INTO amk_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Mera wa mesuai munu bei mani memadu fafong tonina, kadono mahikaifeai we mea na munu bonini. ");
INSERT INTO amk_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Na munu bonani manei enerorong denteng mani, mene mahikai beng metohona fo ambori nayai nai, mae inontarai denteng manei niayai na nana kaha mani, mahikai metohona fo nayai na inontaraifosa na munu bonani kaha. ");
INSERT INTO amk_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Menayai na munu boyari foi terai. Wiro metato na munu bei to munu bei aha fanai. Metang fiang fiani aino etohonai na nanai we mea fo, weo inontarai mano yufi foi mani sobu fiembaitai. ");
INSERT INTO amk_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Awao, mera wa munuefea, etutang tawang mea na mahikai mani, metang fiang fiani aino etohonai we mea na nana fo. ");
INSERT INTO amk_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Menari inontarai mano emaninang na munue nanaya ebeng, tuti meteisaharai we inontaraifosa, weo Seng Allai waroi kaha mae ambori da ma we wemananu we ea ki. ");
INSERT INTO amk_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Wape, mera wao munuefea, emaya weo etamang we mea kaha, eteiaya mea, nana mani, mera wa rangfoi ambori memadu tonina, ");
INSERT INTO amk_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Abu saha na ameawemi rengne na mene munuefi, amehafa titai, we kaiwoariri we mea, ampafe metanansiau, weo mea meteiaya Sempaisi ne Kaiwoaririfo. Wape mewaitawanai weo rahida neungfe kefang ampa, weo Seng Allai ambori wemananu we mea ki!’ ");
INSERT INTO amk_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Imadurai we mea mau yeyo, rahida bo Allai kiutu kaiwo kariri nunei nai foi, Seng Allai kesoufo fuba we inontarai nanisa, fuba sewa ne kasou dohonai na fafongfa we inontarai Sodomi fosa.” ");
INSERT INTO amk_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Inontarai Korasimi mesobu ne karirafo rai! Tuti inontarai Betsaida ne mea kontai, mesobu ne karirafo konta rai. Weo fitantuma bitoyao inariri rahang mea tonina ne, masino inari na bendario boriai weru Israelinei, toyari Tirusi tuti Sidoni mani, inontarai na wana fosa etaraberasa kawuru weru ene sasarifo tuti esansung ansung koya fo, eruai kangganangfoa watai na enumikamieifo ampa. ");
INSERT INTO amk_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Wape rahida bo Allai kiutu kaiwo kariri nunei nai foi, mesobu aiboi maraba sewa inontarai Tirusi tuti Sidoni fosa. ");
INSERT INTO amk_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Tuti mea na bendari Kapernaumi, menemitituai we metadai sewa paria sobu rorafaisi kontai ki, wape Allai ambori su mea beyari paria sobu katai Soroha rorong foi.” ");
INSERT INTO amk_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Mayeaia Yesusi medu we mano erariati fosa deyo, “Manei tarao mea mani, tarao yau. Mae deiaya mea mani, deiaya yau. Tuti mano deiaya yau foi mani, deiaya mano demi yau foi kontai.” ");
INSERT INTO amk_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Inontarai piatorua sura fosa (70), etaraberasa, na mararising aha ma. Emadu we Yesusi eteyo, “Daie, inggirafo etaramio amea weo ametemisa era to boriai weru inontarai, na Dai wonomune fefe.” ");
INSERT INTO amk_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Yesusi yoa deyo, “Yeti Saminseni sawai na rorafaisi toyari kaiwewa. ");
INSERT INTO amk_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Mewaitawanai weo mea kiai, yohong mambiriu we mea ampa, ambori mea, metaha tawang tawai tuti amafiahi, kontaio meharai kahobu Saminseni, tane aitetafoi ne mambiriufo, nano fi kerira fei sobu mane wau kaha. ");
INSERT INTO amk_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Tonanai wape dohona meparaise weo metata inggirafosa mani, etaramio mea fo fe. Mae ne beng pari mani, meparaise weo mewonomine Seng Allai soi na ne buku na Waidani ampa.” ");
INSERT INTO amk_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Na siari nanai kontai, Yesusi mirarising weo Nuaninu Mirarebana fo donti, ampafe deyo, “Dai, Seng mano ru rorawai tuti nunei Wau, yohong mahikai we Dai Wau, weo finani kiaio bodiwarai weru mano esawai tuti ewaitawang fi bitoya fosa, mae boinawiaia kasau we mano ene tarai kariri arikangnesa. Yo, tonanai, weo ne tonanane aino Dai enemuoa ne.” ");
INSERT INTO amk_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ainanaya Yesusi medu deyo, “Fi kiai na rorafaisi tuti na nunei, Dai dohonai we yau ampa. Kaisungnei mani, manei wiro deroani na mai kaha, manta Dai mantauni terai, tuti Dai kontai manei wiro deroani na mai kaha, manta ne Kaisungnei mantauni terai tuti inontarai mano Kaisungnei dirisa we deinawi Dai nani wesa fosa.” ");
INSERT INTO amk_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Mayeai Yesusi deti berahai we ne inontarai erariati fosa ambori medu we ea siai deyo, “Mea mani mesobu ne maifo we meuremiwa tabau we mewati te fininaia. ");
INSERT INTO amk_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Weo, imadu we mea mau yeyo, na fafongfa nabi bitoya tuti mananufosa efau enemirorong dohong paria we ewati fiani aino mewatioai na kutu nina ne, wape wiro ewatioa kaha. Tuti we etarami fianai aino metaramioa ne, wape wiro etaramioa kaha.” ");
INSERT INTO amk_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mayeaia mani mantaunau Hukumi Musai soi fo manei doari ayai dutang fea Yesusi, weo deo weanggariri fefe. Dutani deyo, “Dai Mantaunaune waune, inari fiani, ambori isobu mai na rahida fui tuti iminohia numainufo?” ");
INSERT INTO amk_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesusi yoa deyo, “Fiani aino etoi na Seng ne Kaiwone? Botori mani sodoni?” ");
INSERT INTO amk_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Inontaraifoi yoa deyo, “Yetori mani sonina: ‘Enemuwawu Sempaisi, nemu Allai, na enemurorongwai sentenang, na numuaninuwai sentenang, tuti na enemutituaitawa sentenang.’ Tuti yetori sonina kontai: ");
INSERT INTO amk_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Yesusi deyo, “Modurawa tarai. Bohong kaririai, angfino munohia numainu.” ");
INSERT INTO amk_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Manamo mano deunau fi Musai soi fo niari tofino i mani niari kaririaia mai ampa. Ampafe dutang Yesusi aha deyo, “Mandoni dino enehuwawuti ne?” ");
INSERT INTO amk_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesusi medu dohong rang wei, deyo, “Inontarai Yahudi manei, bia na Yerusalemi to Yeriho. Na rang rabuang mani, inontarai mamuna manea eboia adareti mireha, tuti etawa ne fianggengfoa kaia niai arora, era weruia mae wiatai na rangfoi tuti fari beba foi. ");
INSERT INTO amk_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Teterai weo, imami manei da na rang koinani kontai. Detiao inontaraifoi fo, tiberawa da na rangfoi eneung dowei. Ampafe da weruia. ");
INSERT INTO amk_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Mangfata imami fosa manei, weriria na Lewi, i kontai da na katai nani. Detiao inontaraifoi fo, da afuio de detioi, manamo kia bariri to rang eneung dowei foa, da weruia. ");
INSERT INTO amk_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Mayeaia mani inontarai Samaria manei, wiro Yahudi dine kaha, i da na nanai kontai. Detia inontaraifoi fo aroi fuba beyari. ");
INSERT INTO amk_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Da afui inontaraifoia, ainanaya yuai rurang fari beba foi na angguri ambori dohong maning soaifa, awa kawuru wori fiau weduarai ki. Mayeai yuai inontaraifoi to ne keledaifoi ayai wia sauwi, mae kiari da to munu ebaitai bei, weo niariri nayai. ");
INSERT INTO amk_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Kameaia mani kia doi dinari boru, da wa dohonaio mano ne munu foi, mae deyo, ‘Nariria denteng, mae boyo bohong fiani wei kontai mani, yarabera yau aha ma wori, ibaitai ki.’ ” ");
INSERT INTO amk_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ainanaya Yesusi deiriri fi airiri foia kiaya mani, dutania deyo, “Nano inontarai mantoru ne itoru mani, enemutituai we mandoni andino enewawu inontarai mano inontarai mamuna eboi foi ne?” ");
INSERT INTO amk_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Mantaunau Kaiwo Musai soi fo deyo, “Inontarai mano aro tutu fiata inontarai etohong fari oi foi.” Yesusi deya deyo, “Yo, roa mani bohong kaririai tonanai kontai.” ");
INSERT INTO amk_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Mayeaia mani Yesusi tuti ne inontaraifosa era pari aha esobu munuefeai. Na nana mani, wiwing manei wonong fino Martai, wenoti Yesusi to ne munufoia. ");
INSERT INTO amk_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Martai ne tahatui manei wonong fino Mariai. Mariai nini minohi rurang Yesusi mae taradidau ne aunaufo. ");
INSERT INTO amk_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Wape Martai dohona urewa beyari na munu rorongfo. Ampafe dao Yesusia tuti medu deyo, “Daie, wiro Dai boti Mariai kahai mae, sawing yau inari fi siai e? Bomi ma yufata yau wo!” ");
INSERT INTO amk_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Yesusi yoa deyo, “Martae, Martai wo! Wau mani enemumameatai ampafe bohona uremuwa towana, tonina. ");
INSERT INTO amk_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Manamo fi wenoti yau weai ma ne mani, boyo taramu yeiriri Kaiwo Sengne. Ampafe Mariai diri siri ne bengfe ampa, neo wiro ka werui aha kaha.” ");
INSERT INTO amk_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Na rahida bei Yesusi dutanai weo Sempaisi na katai bei. Dutanaia kai, ne inontarai erariati fosa manei dutania deyo, “Dai Waune, bounau amea we ametutanai we Sempaisine toyario Yohanesi deunau ne inontarai erariati fosa nana.” ");
INSERT INTO amk_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Ainanaya Yesusi dei wesa deyo, “Awao metutangna mani, metutang tonina: ‘Daie, Kadono wonomuwai atori we mirarebanai, Kadono nemu weMananuwa da ma. ");
INSERT INTO amk_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Bohong fiang demoyarai we amea na rahida neungne, ");
INSERT INTO amk_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","tuti boiai amene sasari ametohoni nei, kariri amea kontaio ameteiai mandoni kontai ene sarawaio etohonai we amea fo, tuti dohona tua amea ametohong kariri fi sofao weanggari amea amenari sasarifo fanai.’ ” ");
INSERT INTO amk_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesusi medu we inontarai erariati fosa ampafe ewaitawanai ewenadi pampang, deyo, “Manei na mea, ro to nemu maniwowirifoi ne munufoi, diru rabuang mae butani boyo, ‘Maniwowirife, bohongno taung botoru teai yau ma wo. ");
INSERT INTO amk_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Weo nehu maniwowiri manei arahi da na waroi ma, da sobu yau na nehu munufoi, manamo yohong fiangfea watai we dang kaha.’ ");
INSERT INTO amk_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Wape maniwowiri mano ro oi foi, tarahio medu na munu rorongfo mandiai deyo, ‘Ro ma totawa yau fanai! Ikafe rahutua tuti nehu arikangfe ametena ampa. Wiro imaya weo yoa aha kaha we yohong fieai we wau.’ ” ");
INSERT INTO amk_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Yesusi medu pari aha deyo, “Tofino ne maniwowiri di wau ki, wape miaya we doari miai dohong fieai we wau kaha. Manamo wau butani mutu, ampafe doari miaio dohong fi butang wea fo ki. ");
INSERT INTO amk_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ampafe yei mau yeyo; Metutang weai ambori ohonai ki, mesera weai ambori mesobuai ki; meboi rahutufo ambori fai we mea ki. ");
INSERT INTO amk_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Weo mano etutana fosa ambori ohonai wesa ki; mano esera wea fosa ambori esobuai ki; tuti mano eboi rahutu fosa ambori fai wesa ki. ");
INSERT INTO amk_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Na mea kiai mani, wawa mandoni dino ne arikangfoi dutang we diang mani, dohong tawai ne? ");
INSERT INTO amk_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ete dutang we manggohei aibong, wape tamang dohong amafiyahi manei ki? Bereri! ");
INSERT INTO amk_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ampafe mea mewarami aipaya tonanai ki, wape mewaitawang metohong ne bengfo we mene arikangfosa. Nana mani Dai na Waidani ne dohonafo sewa weru mea aha. Ambori dohongno Nuaninu Mirarebana foi weo mano etutani fosa ki.” ");
INSERT INTO amk_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Na rahida bei Yesusi data inggira manei weru weborotamu manei. Inggirafoi da to woriaia, ainanaya inontaraifoi medua nina. Kaiwasa bitoya foi pepuhung, ");
INSERT INTO amk_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","wape manea eteyo, “I mani data inggira weo sobu mambiriu na Barsebuli fefe; inggira ene mananufoi.” ");
INSERT INTO amk_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Inontarai siai fe manea kontai eweanggari Yesusi, ampafe etutani weo niari fiainawiaifea, ambori ewaitawang kanggunai weo Yesusi mani da na Seng Allai ma. ");
INSERT INTO amk_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Manamo Yesusi deitawang fi enemitituaita fo. Ampafe medu wesa deyo, “Negara bei wiro weboyari kaha mae ebabausa tuti eweaiteta wawerasa, nana mani negara nani wiro da waroi ahang kaha, mae ambori wioru ki. Ampafe munu rorong bei sonanai kontai. Eweaiteta wawerasa mani munu rorong bonani wioru ki. ");
INSERT INTO amk_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Tonanai kontai we Saminseni, masino Saminseni dapa bera mantauni mani tiabau finanai. Nana mani ambori ne mananufo nayai mutu kaha mae wioru ki. Mea kiai meteyo yata inggira weo nehu mambiriu na Barsebuli fefe. ");
INSERT INTO amk_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Wape tonana kaha. Ampafe tonana mani na mandoni ne mambiriufo mene inontarai eraria mea fosa etata nuaninu karira fosa nai ne? Na fianai aino enari nanai deinawiai we fio metinggai yau wea ne tarai kaha. ");
INSERT INTO amk_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Wape yau mani yata nuaninu karira na Allai ne mambiriune, nana mani yeinawiai weo na Yau mani, Seng Allai da ma we weMananu rahang mea ampa. ");
INSERT INTO amk_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Inontarai tiapa manei, tuti ne fimamunafo masi, ambori demang wedua ne munufoi, nana mani mananapi wiro eha manana ne fianggeng minohi tutira fo kutea kaha. ");
INSERT INTO amk_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Wape mano tiapa sewari manei miuni awao saha tawani, nana mani ambori mano tiapa sewari foi wewu ne fimamuna deparandina fo, tuti deto tate ne fianggeng minohi tutira fo. ");
INSERT INTO amk_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Manei sau we yau kaha mani, weaiteta we yau, tuti manei doa tuwa yau na ifanduhi inontarai fo kaha mani, wenani niari kanggani nehu fi inari ne weo kiataterai.” ");
INSERT INTO amk_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Awao nuaninu kerira manei da to boriai weru inontarai manei mani, da wariai funomai to katai karira sarahiai weo sera we katai niai nayai, tuti sobua kaha. Tonanaya mani deyo, ‘Yarabera yau to nehu munu arahi ira werui foi aha.’ ");
INSERT INTO amk_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Tuti bo daraberahia foi mani, sobuai we inontaraifoi ne tarai toyari munuo fantamia mesi mirarebanai. ");
INSERT INTO amk_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Ainanaya daraberahi aha kia eweituo eharira sewa mantauni. Mayeai esuai to inontaraifoi awafui enayai nai. Ampafe wedaya inontaraifoi ne minohi toa fo kerira sewa reantenangfo aha.” ");
INSERT INTO amk_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Yesusi medua kai tonanaya, mayeai wiwing manei na kaiwasa bitoya foi medu wei deyo, “Taraie, wiwing mano dawing wau tuti dohong uio wau wai, andi sobu mai ne.” ");
INSERT INTO amk_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Manamo Yesusi yoa wei deyo, “Yo! Wape mano sobu mai sewa mani, mano tarao Seng Allai ne Kaiwone tuti dohong kaririai.” ");
INSERT INTO amk_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Inontaraifosa etoa wari Yesusi, mae medu mutu deyo, “Kaiwasa fuinini warang aipaya paria. Metutang we inari fitantuma ambori mewaitawanai kanggunai weo yau mani ira na Seng Allai ma. Wape wiro inari fitantuma siai fea we mea kaha, mae fiainawiaio mewaitawana na nabi Yunusia fo. ");
INSERT INTO amk_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Toyario nabi Yunusi wefiainawiai we inontarai na munue Niniwe, tonanai kontai Kaisung Inontarai nei ambori wefiainawiai we kaiwasa fuinini ki. ");
INSERT INTO amk_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Na rahida Allai kiutu kaiwo kariri nunei fo, wiwing mananuo na do wanangsai foi, i ambori suwi kontai ria inontarai mano na rabuang bonini ne mea we dinggai mea kontai ki. Weo wiwing mananu nini da pari na nunei rea naya fo ma we sobu aunau mai na Mananu Salomoi mano sewai foi. Tuti na ninai, na katai nini manei fiabai sewa Mananu Salomoi ne, manamo wiro metaramioi kaha. ");
INSERT INTO amk_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Tonanai kontai, na rahida Allai kiutu kaiwo kariri nunei fo, inontarai Niniwe fosa ambori esuwi ria mea, mano na rabuang bonini ne mea, tuti etinggai mea kontai ki. Weo fafongfa nabi Yunusi medu wesa fo etaramioi, ampafe efotou enari sasarifo tuti etaraberasa weru ene sasarifoi ampa. Wape na ninai, na katai nini manei fiabai sewa nabi Yunusi ne, manamo wiro metaramioi kaha.” ");
INSERT INTO amk_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Wiro inontarai manei kiai padamarang bei, ainanaya tebuni na babeu, ete dohoni wiatai na fata arowawahi fo kaha. Mae yuai padamarangfoi ayai sawai parai, ambori inontaraio era to munu rorongfo afui mani ewati sambewarafoi. ");
INSERT INTO amk_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Meuremiwa mani wepadamarang we mene taraiwai. Ampafe masino meuremiwa mamarampoti mani, mene taraiwai sentenang dansairai. Mae meuremiwa fayou mani, mene taraiwai memantiti kontai. ");
INSERT INTO amk_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Tonana mani metanansiau, we dohona dansairai nai na mea wa fafe fe, ampafe mamantiti. ");
INSERT INTO amk_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Tofino nemu taraiwai sentenang sambewarai, mae wiro kuteai mamantiti kaha, nana mani nemu taraiwai sambewarai toyari padamara dansai wau.” ");
INSERT INTO amk_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Yesusi medua kaiya, mayeaia mani Farisi manei, wenoti weo dampi na ne munufoi. Ampafe Yesusi da wa dampi na nana. ");
INSERT INTO amk_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Farisifoi pepuhung weo deti Yesusi dampi, manamo wiro yuai warangfo kariri Yahudi ene koang kaha. ");
INSERT INTO amk_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ampafe Yesusi medu wei deyo, “Farisine mea mani, menari koang bitoya. Ne tarai kariri mene nofi metunung naya wa tuti rewangguai metampi naya wa, meruai borieiwara mararebanai, wape na do rorong niaya werarika nendai. Ne tonanane kontai we mea, mea mesera we memai na kaiwasa euremireafo, wape menemirorongfuisi mani sifayara denteng kahai tuti meuremi fiabai we doi. ");
INSERT INTO amk_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Mewebonggoi! Meteitarahio Seng Allai niari do woriai wa mani niari do rorong wa konta kaha e? ");
INSERT INTO amk_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Manamo fifuba meneng mani, metohonai we inontarai ene pari fi fosa. Nana mani mea memararebanai kiai. ");
INSERT INTO amk_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Farisine mea, karirafo we mea! Weo menari fikatui na mai, wape fifuba menariri kaha. Weo mene fitantanang wetarai mehari, toyari kaung, marisani, tuti fisisasa, metohong we Sempaisi ne perpuluhanfo, mai kariri mene koangfoi. Kaung buai sura mani ohong buai bei, tonanai kontai marisani tuti fisisasa. Finana mani fuba kaha wape menari kaririai. Mae fifuba sewa, toyari menemiwawu Seng Allai, tuti mehutu kaiwo na mesi, ne nanai menari kariria kaha. Ne beng pari fo mani, metohong kariri fi fuba ninai kiai mae merurai we menari ne katuifo kontai. ");
INSERT INTO amk_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Farisine mesobu ne karira rai! Weo mea mani mesera we mewe mewonomi, toyari na munu agama Yahudi fo mani mesera we meminohi pari na kadera watai na fong pari fe fo. Kontai meteyo kaiwasa esomi we mea na kaiwasa bitoya euremireafo, toyari na kondirora. ");
INSERT INTO amk_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Mesobu ne karira rai! Weo mene tarai toyari kubirio ne pari munu, ampafe inontarai etataharai, tuti esera wawerahi weo rorongfuisi mani piro.” ");
INSERT INTO amk_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Mantaunau Kaiwo Musai soi fo manei medu Yesusi deyo, “Dai Mantaunanune waune, modu tonana mani, boi kanggani amea finanai kontai!” ");
INSERT INTO amk_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesusi yoa deyo, “Yo! Mea kontai mesobu ne karira rai! Metohong kaiwo dadira tuti maraba we inontarai siai, meteyo nari wani, nari nini fanai, metemisa we esoduatai ete we etohong kaririai, wape mantaung mea wiro mewaramiairai weo inontarai mano ete etohong kaririai fosa kaha. ");
INSERT INTO amk_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Mantaunau Kaiwo Musai soi wa mea, mesobu ne karira rai! Weo menari riwang munu we nabifosa ene fafofo, mano mene werengfosa emunsa fo. ");
INSERT INTO amk_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ampafe na menari tonana fo, mantaung mea metainawiai we meroasoai tuti meroao fi mene werengfosa enaria fo; weo eaino emungno nabifosa tuti meaino menari riwang ene munu fafo fo. ");
INSERT INTO amk_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Nanai aino Seng Allai medu na ne awaifo, deyo, ‘Ambori yohong nabife manea tuti rasulio yemisa fe manea era wa; wape ambori kaiwasa emung manea, tuti enari kanggani manea ki.’ ");
INSERT INTO amk_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","51","Seng Allai niari tonanai, ambori mesuang nabifosa ene rika fuba tibata nano nunei tibaurai ma fo, wereantenang na Habeli, paria sobu Zakariai, mano memuni na Sempaisi ne Munufoi, amani na Rorong Mirarebana foi tuti mesbafoi ne katai ruhi fo. Ampafe yei we mea mau yeo, inontarai fuinini meaino mesuang mirabafoi ne. ");
INSERT INTO amk_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Mantaunau Kaiwo Musai soi ne mesobu ne karira rai! Weo meaino meru Sempaisi ne kaiwo aunau fo. Manamo mantaung mea wiro metohong kariria kaha. Mae metohong wedua mano ete esera we ewaitawana fosa kontai.” ");
INSERT INTO amk_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Mayeai Yesusi da weru kataifoia mae, mantaunau Kaiwo Musai soi fosa tuti Farisifosa enumi riati, mae emadu tatofari ambori Yesusi niaya medu pampang. ");
INSERT INTO amk_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Ete etofa wei medu, ambori etafu kaiwo medu sarawa feai riati. ");
INSERT INTO amk_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Kaiwasafoi piaura wesura, ewarami siayasa, awao manea etaha siau manea eawemine. Kaiwasafoi da ruhiai mae, Yesusi medu we ne inontarai erariati fosa deyo, “Metanansiau weo ragio na Farisifosa, amani enari toa fo, weo enari fayafayarafo. ");
INSERT INTO amk_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Wape fiani aino etadiwara fo ambori atioai ki, tuti fiani aino etohonai we kaiwo werorong ambori taramioai ki. ");
INSERT INTO amk_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Neo madurai na diru fo, ambori taramioai na rahida fo ki, tuti neo aimumunai na rorong kafe weduara fo ambori ahu tuturai ki.” ");
INSERT INTO amk_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Maniwowirife mearomioa! Dohona mematai mano emung te mene taraiwai, wape wiro ebiriu we enari fieai kontai ahang kaha. ");
INSERT INTO amk_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mahikai fefe yeinawiai we mea, weo mandoni dino memataiti ne. Mematai Seng Allai. Weo i mani miung, tuti biriu weo kebioai to Soroha rorong fo. Meroasoai, weo andino mematai teri ne. ");
INSERT INTO amk_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Romu sinsumiri ewering, awayansa weo doi seni boru. Tonanai mae wiro Seng Allai aroporo dewawu manei kaha. ");
INSERT INTO amk_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Menumirandaungwai kiai kontai detori sentenang. Ampefe mematai fanai, weo mea mani metadai sewa romu sinsumirinesa.” ");
INSERT INTO amk_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Mearomioai ninariai; Inontarai mandoni dino yoa na kaiwasa bitoya euremireafo we daria yau mani, Kaisung Inontarai nei kontaio yoa tutiri na Seng Allai ne wewaifosa euremireafo ki. ");
INSERT INTO amk_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Wape mandoni dino fefora na kaiwasa bitoya euremireafoa we daria yau kaha, yau kontaio ifaforai na Seng Allai ne wewaifosa euremireafo ki. ");
INSERT INTO amk_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Tuti inontarai mano eteibera Kaisung Inontarai ne yau, ene sasari tonana foi Allai deiairi ki, wape eteibera Nuaninu Mirarebana foi mani, na todoni feai kontaio Allai deiai ene sasari tonana foi kaha. ");
INSERT INTO amk_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Awao eha mea to munu agama Yahudi fo weo etinggai mea nayai, nano parentafoi ete mano eru mananu fosa, nana mani dohona mearomikuai we fiani aino menari fo ete memadura fo fe. ");
INSERT INTO amk_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Weo fiani aino memadura fo mani, ambori Seng Allai Nuaninu Mirarebana foi deunau mea nayai na ne rahida neungfo ki.” ");
INSERT INTO amk_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Inontarai manei na kaiwasa bitoya foi medu we Yesusi deyo, “Mantaunaune waune, boisaharai weo nehu tafuai ambori biau aune fianggengne dohongno eai we yau.” ");
INSERT INTO amk_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Manamo Yesusi medu wei deyo, “Mantei di yuai yau yoa rahang muru we yeto mune fianggengfe wa?” ");
INSERT INTO amk_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Mayeai Yesusi medu we kaiwasafoi deyo, “Metanansiau weo menemititawang fiwa, weo manei ne fianggengfoi bitoya ki, wape fianggeng nani kia mahikai wei kaha.” ");
INSERT INTO amk_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ainanaya Yesusi deiriri fiyiwansoai bei deyo, “Inontarai wene kahofa manei tuti ne roweangfoi bitoya paria. ");
INSERT INTO amk_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ainanaya enetituaitai na enerorongfoi deyo, ‘Fianai aino inari aha ne, weo nehu pari katai fiabai weo ifantang roweangnei sisuanai nayai.’ ");
INSERT INTO amk_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Mayea enetituaitai aha deyo, ‘Ira ma inari finina. Itota nehu munu aikahia sisuanai naya ne weo ketui, inaria fiabai aha, ambori ifantang nehu roweangnei tuti nehu aikahianei afui sisuanayai. ");
INSERT INTO amk_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nana mani enehutituaitai na enehurorongnei aha yeyo, “Nehu aikahianei bitoya sisuanai we fuina wedediru, ampafe iminohi, yampi, yunung, imararising.” ’ ");
INSERT INTO amk_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Wape Seng Allai medu deyo, ‘Wera wawerahai, boitawang fiea kaha! Diru nini mureha rai, aikahia fuba funtamia sisuanai nani we mandoni rai?’ ");
INSERT INTO amk_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Tonanaifa weo inontarai mano fianduhi ne aikahiafoi bitoya wei na nunei, wape dohong kariri Sempaisi ne Kaiwone kaha foi.” ");
INSERT INTO amk_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ainanaya Yesusi medu we mano erariati fosa deyo, “Ampafe yeikaririai we mea yeyo, dohonao mearomikuayai we meminohi toa wa fe, amani kariri fianai aino metang fo, tuti wiro mearomikuayai we mene taraiwai fanai kariri fiani aino mesansungna wa. ");
INSERT INTO amk_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Weo mene ansengwai mani dedai sewa fiang tuti mene taraiwai dedai sewa ansungno mesansungna fo. ");
INSERT INTO amk_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Menemitituai kariri romu raweifosa. Wiro etanang fi kahai, eteting fi kahai, tuti wiro ene munu etainunung fiang naya fea kaha. Tonanai ki wape Seng Allai meinenang ene fiangfo wesa. Mea mani metadai sewa romufosa. ");
INSERT INTO amk_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Na mea kiai mandoni dino na ne arohuayai we minohi toa fo, wemambiriu we yabi ne ansengfoia deuroi kuteai aha ne? ");
INSERT INTO amk_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Mebiriu weo menari fi katui tonana ne kaha mani, we fiani mearomikuayai weo fi siai fo nina? ");
INSERT INTO amk_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Mewati kariri kununumifoi we ne weainarifo. Ainari nani wiro dohong fi kaha tuti sunungfi kaha, wape Seng Allai niariri mahikai. Wape yeisaharai we mea mau, Mananu Salomoi kontaio ne ra bitoya tonanai, wape ansung sensungna fo kontaio wiro wea mehikai kariri ainarifo nani kaha. ");
INSERT INTO amk_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ninoio weainaria denteng nani, rahida nini sifu wape aha mani ferami aha we nunumi. Tonanai wape Allai miani mehikai paria. Nana mani ambori Allai sensung mea kontai ki, mano meroasoai turura kaha ne mea! ");
INSERT INTO amk_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ampafe, wiro mearomikuayai weo fi metang, tuti fi metunung wa fanai. ");
INSERT INTO amk_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Weo, fi tonanane, inontarai mano etaroanso Sempaisi kaha fo ansaino erurai esera wea ne. Wape mea mani, mene Dai na rorafaisi deitawanai ampa we fi tonana ne metohong weai paria. ");
INSERT INTO amk_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Wape mesera fafong we Allai ne weMananufo, nana mani fi metohong weai nanai ambori Allai dohonai kontai ki.” ");
INSERT INTO amk_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Mano mefau kahai ni mea, mematai fanai! Weo Seng Allai mirarising weo dohongno moang we mea na ne Mananu rorong fo, weo meroasoa fefe. ");
INSERT INTO amk_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Metawayang mene fi meminohi tutira wa ambori metohong ne doiwa we inontarai ene pari fi wasa. Nana mani mene ra suanai na Waidani, ra nani mani wiro mananapi eha mananai kaha, tuti wohere dani kaha. ");
INSERT INTO amk_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Weo na doni mene rafoi wiatai naya mani, na nanai kontai menemirorongwai niayai nai.” ");
INSERT INTO amk_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Metanansiau pampang. Ne tarai toyario mesansung tuti mene padamarawa danggararu pampang. ");
INSERT INTO amk_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Nana mani memainena toyari mangfata mano emainena etamang we ene mambaisengfoi, daraberahi na muniara mandirau foi. Mambaisengfoi daraberahi ma dutanai tuti bioi rahutufoi mani, mangfatafosa esahera efai rahutufoi wei. ");
INSERT INTO amk_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Mangfata mano etanansiau etamang wei fosa esobu mai ria mambaisengfoi. Tarai tofino, mambaisengfoi ambori demi mangfatafosa eminohi mae mantauni fiatasa aha. ");
INSERT INTO amk_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Mangfata mano etanansiau etamang fosa esobu mai weo mambaisengfoi sobusa etamang wei. Da na diru rabuang ete, rerai aha ete, wape emainenang pampang. ");
INSERT INTO amk_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Mearomi finina, masino mano ne munufoi deitawanai we diru araha ureng beiru mani mananapifoi da ma we kiamanana ne fi minohi tutira fo mani, todoni kontai wiro da to boriai kaha mae deitawang weduara rai, wiro sua mananapifoi suai to ne munufoi rorongfo kaha. ");
INSERT INTO amk_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Tonana mani mea kontai memainenang metamang pampang, we Kaisung Inontarai nei da tantuma na rahida bo waitawana kaha foi ma ki.” ");
INSERT INTO amk_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Petrusi dutanai deyo, “Sengne wau, firiwansoawa dotu we amea ete we kaiwasa bitoya nei e?” ");
INSERT INTO amk_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Sengfoi yoa deyo, “Mandoni dino wemangfata mesi tuti sewai ne? Mandoni dino wemangfatao dohong kariri ne mambaisengfoi ne kaiwofo na mai, na rahida yuaisi wenunggamiai we mangfata mano wei fosa, ambori dohong fiang wesa na rahida neungfo ne? ");
INSERT INTO amk_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Denteng paria we mangfatao niari kariri ne mambaisengfoi ne kaiwofo na mai, ambori rahida mambaisengfoi daraberahi ma mani, sobu ne mangfatafoi we dohong kariri kaiwo demi wea fo. ");
INSERT INTO amk_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Tarai, imadurai we mea mau yeyo, mambaisengfoi ambori yuaisi wenungkamiai we ne fianggeng minohi tutira fo kai ki. ");
INSERT INTO amk_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Wape tarahai mangfatafoi kerira tuti enetituaitai na enerorongfoi deyo, ‘Nehu mambaisengfoi niaya waroi paria wiro daraberahi ahera ma kaha rai,’ ainanaya bioi mangfata mano siai fosa, mang tutu wiwing, tuti dampi tuti dunung ria inontarai emayeru fosa. ");
INSERT INTO amk_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Mayeai mambaisengfoi daraberahi na rahida tuti araha ureng bo mananaioi foi, amani mangfatafoi wiro deitawana kaha foi. Ampefe mambaisengfoi ambori miuni amani ferangkahutu mangfata kerira nani tuti soari tono katai inontarai enari kariri Allai ne Kaiwo kaha fosa ewatai nai fo. ");
INSERT INTO amk_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Mangfata mano deitawang mambaisengfoi ne dawiafo wape meinena kaha, tuti dohong kariri mambaisengfoi ne dohong wea fo kaha, ambori rubati fuba ki. ");
INSERT INTO amk_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Wape mangfata mano sera wawera mambaisengfoi ne dawiafo, mae fui aha mani dohong sarawai ampafe rubati, nana mani rubati fuba kaha. Weo inontarai mandoni dino ohonafo fuba wei mani, ka riati fo fuba kontai. Tutu mandoni dino ainawiafo fuba wei mani utang wea fo fuba kontai.” ");
INSERT INTO amk_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yesusi medu kaiwo netawea fo deyo, “Ira ma weo iso adiafo to nunei meu we kesoi. Denteng mani adiafoi denggararu ampa, wape bereri rai. ");
INSERT INTO amk_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Isodua maraba fuba bitoya ki, ne tarai toyari iwebaptisi na dadira rorong, ampafe enehurorongnei iweansarai fafong pariao finani kiai ki. ");
INSERT INTO amk_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ampafe meteitarahio ira ma nina ika mai to nunei e? Bireri, mai kaha, mae aiteta. ");
INSERT INTO amk_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Na ninai to fong mani, munu rorong bei, ewering mani, ambori etapa wawerasa amani mantoru we mandu, ete mandu we mantoru. ");
INSERT INTO amk_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Eweboyari aha kaha. Tamang ambori dapa ne kaisungfoi, tutu kaisungfoi dapa tamanai ki. Inang ambori dapa ne kamitungfoi, tuti kamitungfoi dapa inanai ki. Niongno ambori dapa urawingfoi, tutu urawingfoi dapa niong wiwini ki.” ");
INSERT INTO amk_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesusi dei kontai we kaiwasa bitoya foi deyo, “Mewatio kafafe doa na do fui fo, amani meteyo, ‘Ambori wemetang ki!’ I wemetang kaririai. ");
INSERT INTO amk_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Menumiruainso wanang siayai na do wanansai foi, amani meteyo, ‘Ambori maninggapoi ki.’ I maninggapoi kaririai. ");
INSERT INTO amk_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Inontarai menari fayafayara di mea! Metafu kariri wanang, metang, maring, mewatioa na rorafaisi tuti nunei. Tonana mae, todonie, fi kawariai na rabuang bonini fo wiro mewaitawang metaroangna kaha?” ");
INSERT INTO amk_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Todonie metohong kariri ne mai ne kaha? ");
INSERT INTO amk_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Inontarai manei dinggai wau mani, wiro musobu mangkutu kaiwo nanisa kaharai mae na rang rabuang kontaio rurai we weboyari riati aha. Bereri mani, tarahai yabi wau to mangkutu kaiwo fosa rai. Tuti tarahai esoa wau to afai mamuna fosa tuti ea mani esoa wau to aitamu rorong fo. ");
INSERT INTO amk_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Tuti aromuaifa: na aitamu rorong fo watai paria bai nemu fiwaifoi paria kiai fino ro to borieife.” ");
INSERT INTO amk_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Na nanaifa inontarai manea era we Yesusi meai. Etaiririai we Yesusi karirio inontarai Galilea maneiruo, eha fiahung ne rika we etohonai we Allaifo kariri ene koang, na Sempaisi ne Munufoi. Manamo Pilatusi demi ne rai mamuna fosa, emunsa. ");
INSERT INTO amk_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Yesusi tefu aiririafoi, medu wesa aha deyo, “Menemitituai todoni weo fi inontarai Galilea fosa esobuai nanai? Mewaitarahio inontarai Galilea emarareha nansa, emarareha tonanane deinawiai we ene sasari fiabai sewa inontarai Galilea fuba wei foini fe? ");
INSERT INTO amk_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Bireri kontai! Wape mearomioaifa, weo metaraberahai weru sasari metohoni wai kaha mani, mea kiai ambori memarareha kariri ea tonanai ki. ");
INSERT INTO amk_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Tofidoni kontai we inontarai suraya indeatoruo emarareha na Siloami, na rahida bo menarafoi sautawansa fo? Mewaitarahio nana mani deinawiai kontai weo, ewesasari sewa inontarai siai enayai na Yerusalemi fosa re? ");
INSERT INTO amk_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Bereri kontai! Yeoai nari aha mau we metauberahai weru sasari metohoni wai kaha mani, mea kiai ambori memarareha kontai kariri ea ki.” ");
INSERT INTO amk_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Mayeai Yesusi deiriri fiyiwansoai nini kontai, deyo, “Inontarai manei ne ai urung rowei sifu na ne romifoi. Rahida bei da wa sera we aibongfoi. Manamo boyari kontaio wiro sobui kaha. ");
INSERT INTO amk_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ampafe medu we mano deitawang ne romi foi deyo, ‘Boti defuina botorua fininai, ira ma isera we urung bong na ai urungfoi, manamo boyari kontai wiro isobui kaha. Ampafe robang aifoi weruaia. I kia fiang mahikai weru kahofa wausinia kiai funomaia.’ ");
INSERT INTO amk_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Mano deitawang romifoi yoa wei deyo, ‘Daie, tawini doa defuina bonini ahang wo. Yau ambori itara wari kahofa doa naia fo tutu yohong fi indoaing kahofa feai aha. ");
INSERT INTO amk_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Tarahio defuina da aha ma wani webong. Mae bireri aha mani, yo, robani ki.’ ” ");
INSERT INTO amk_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Na rahida Sabati bei Yesusi deunau na munu agama Yahudi bei. ");
INSERT INTO amk_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Na nanaifa wiwing meninang amaina tikapa manei minohi na munu agama foi. Wiwingfoi meninangno defuina suraiya indeatoru kawurua, weo fikahai dohong ririwani, ampafe wiro da tirai ahang kaha. ");
INSERT INTO amk_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Na rabuang bo Yesusi deti wiwingfoi fo, medu wei deyo, “Wiwingne waune, rahida nini kontaio fimaninangwai da weru wau.” ");
INSERT INTO amk_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ainanaya Yesusi yuai warangfoa wasau wiwingfoi, na kutu nanai kontaio wiwingfoi dentengna, doa tirai, mayeai fiai Seng Allai. ");
INSERT INTO amk_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Mano wenungkamiei we munu agama foi kesou paria, weo Yesusi waraira maninangfoi weru wiwingfoi na rahida Sabati fefe. Ampafe medu we wiwingfoi tutu kaiwasa na munu agama rorongfoi deyo, “Na Kaiwo Musai soi fo deyo rahida wonang Allai dohonai we tanari fi nayai, mae rahida itu, Sabati mani, tafoai fitanarifo, tafiai te Sengnei. Ampafe mera na rahida wonang nanaifa ma weo waraira mene maninangwai nayai, wiro na rahida Sabati nei fanai.” ");
INSERT INTO amk_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Sengnei yoa deyo, “Mano mewenungkamiei na munu agama ne mea, mantaunau fi Musai soi fo mea, inontarai meweFarisi tutu mano mewewafoniai na inontarai Yahudi ne mea, mea kiai mepararasa webeyari. Weo metaunau we kaiwasa bitoya wiro enari fi na rahida Sabati nei fanai. Wape mea metohong kariri mene kaiwofo kaha. Mae na rahida Sabati fo, meha mene fiahungnesa weru wore rorong etoa naya fo, metohonsa etunung mereha tutu etampi. ");
INSERT INTO amk_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Wape na rahida bonini wiwing manei weriria na Abrahami ma, Saminseni dohoni meninang waroi kawuru mauwa, ete ne tarai toyari tebuhiri, defuina suraya indeatoru fininai. Tofino i wiro iforehu Saminseni ne amitabuhiri nani weru wiwingnei na rahida Sabati nei fanai e?” ");
INSERT INTO amk_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesusi ne kaiwo medura fo dohong ne aitetafosa emamaya paria, wape inontarai fiau wei foi kiai eparaise we ewati Yesusi fitantuma niari fo. ");
INSERT INTO amk_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Yesusi dutang bera kaiwasa bitoya foi aha deyo, “Allai ne Mananu rorong fo mani ne tarai todoni? Na fifiani ambori iriwansoi ne? ");
INSERT INTO amk_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ne tarai toyari fiyiwansoai nini: Sawi bong bei, manei kiariao sanami na ne romifoi. Sawi kamieinei mani ketui pari sewa raung ete fitantanangno tatanami na romi rorong nei kiai. Wape sifua fiebai weai, fiabai demoya we romu enari aisangging na arirawangfo.” ");
INSERT INTO amk_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesusi dutang berahai nariai aha, “Allai ne Mananu rorong fo mani, na fifiani kontai iriwansoi ne? ");
INSERT INTO amk_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ne tarai toyari fi dohong tepung dautai, amani ragi. Wiwing manei sariri aweu fiahi tamu tepung bitoya, wedaya tepungfoi dautai paria ketu loyang wiatai nai foi dereungfo.” ");
INSERT INTO amk_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Na rang rorong Yesusi da to Yerusalemi fo, da maino bendari tutu munuefo mae deunau nayai kontai. ");
INSERT INTO amk_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Mayeai inontarai manei dutang berahi deyo, “Tofino rabuang bo Sengnei wemananu nani fai mani, inontarai manea efau esobu mai ete bireri e?” ");
INSERT INTO amk_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","Yesusi yoa deyo, “Mesera we mesuai to Allai ne Mananu rorong fo mani, merurai we mesuai na rahutu dadira fo. Weo mearomuoaifa, inontarai bitoya erurai we esuai na rahutu nani manamo esobua kaha. ");
INSERT INTO amk_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Na rahida bo mano ne munu foi doaria kife rahutufoi, metoa na boriefo meboi rahutufoi mae meteyo, ‘Daie, fai rahutunei we amea ambori amera to rorong!’ Manamo yoa we mea ma deyo, ‘Yeroanso mea kaha. Mea mera na doni ma?’ ");
INSERT INTO amk_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ambo meroa wei aha meteyo, ‘Daie, boroanso amea kawuru ampa! Weo tatampi, tatunung mereha ruhiai kawuru ampa mae, kontaio bounau kawuru na fino amene munuefe ampa.’ ");
INSERT INTO amk_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Manamo mano ne munu foi medu aha deyo, ‘Yeroanso mea kaha. Mea mera na doni ma? Mera kahai weru ninaifa, inontarai menari sasarine mea.’ ");
INSERT INTO amk_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Na rahida bonani mewatio Abrahami, Isaki, Yakupi, kontai nabifosa kiai eminohi efaraise na fino Allai ne Mananu rorong foi. Wape mea ambori mesodai ne karirafo tuti mesaia metamirai paria, weo Allai data mea to boriei fefe. ");
INSERT INTO amk_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Kaiwasa bitoya ambori era na katai doni kontai na rea diru foi, na rea aha foi, na do wanamba foi tuti na do wanansai foi, efanduhisa we etohong muniara na Allai ne weMananufo ki. ");
INSERT INTO amk_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Anture, inontarai maneiruo na nunei ninai ewefonia fosa ambori enai to kurumifui ki, tuti maneiruo na nunei ninai enai to kurumifui fosa ambori ewefoniai ki.” ");
INSERT INTO amk_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Na rahida bonani kontai Farisi maneiru teai era we Yesusi ma emadu wei eteyo, “Nayai na nina fanai! Ro ahera to katai bei siai, weo Mambaiseng Herodesi deyo ming wau fefe.” ");
INSERT INTO amk_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Yesusi yoa deyo, “Mera wa meteikaririai we inontarai kerira nani, yeitawang fikerira de niari we yau fo, mae rahida beiru da aha ma wanai yata fikahai kontai inari inontarai emaninang ebeng, akawuru wori, fifiani aino ira weai we inari ne mani, inaria kai ki. ");
INSERT INTO amk_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Tonanai ki wape, rahida bonini kontai rahida beiru da aha ma wanai, nehu rang rorong iraoai to Yerusalemi ne iraoaia mai. Weo na Yerusalemi fafong nanai emung nabifosa nayai. Ampafe yauo emung yau nai konta rai. ");
INSERT INTO amk_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Yerusaleme! Yerusalemi wo! Nabifosa kiai memunsa! Inontarai Sempaisi demisa era we mea ma fosa, meru kamieio sara emarareha. Webeiru teai mauwa yohong weai paria we ikaruhi mea kiai we yewawu mea, toyari manggohei inangfoi we tebung wedua ne arikangfosa na warapemafo suru, manamo memaya kaha tuti meteiaya yau. ");
INSERT INTO amk_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Mewati! Mene Munu Seng nei mani, Allai wiro weriria mea nai ahang kaha. Tuti yeisaharai we mea mau, na kutu ninai wiro mewati yau ahang kaha pariao memadu meteyo, ‘Moanafeai we mano ro na Sengnei wonongne wau.’ ” ");
INSERT INTO amk_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Na rahida Sabati bei Yesusi da wa dampi ria Farisifo manei na ne munufoi, inontarai ne wafonia dine kontai na inontarai eweFarisi fosa. Na nanai inontaraifosa euremi nayai nai na mai kariri fifiani aino Yesusi niari fo. ");
INSERT INTO amk_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Mayeai inontarai bebara manei, fimaninangfoi dohong warang aweng wemereha na rorongfui, da we Yesusi ma. ");
INSERT INTO amk_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ainanaya Yesusi dutang berahai we mantaunau Kaiwo Musai soi fosa tutu Farisi eminohi nana fosa, deyo, “Na Kaiwo Musai soi we tata fo mani tofino? Na rahida Sabatinei mani, tanari inontarai emaninang we ebeng nai, ete nana fanai e?” ");
INSERT INTO amk_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Mantaunau Kaiwo Musai soi fosa tutu Farisifosa emadu fiea kaha mae enemboru terai. Mayeai Yesusi sahu inontarai meninang foi ma, yuai warangfoa wasau inontarai meninang foia, waraira maninangfoi weruria, mayeai demi da wa. ");
INSERT INTO amk_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Mayeai Yesusi medu we Farisifosa tutu mantaunau Kaiwo Musai soi fosa aha deyo, “Tofino we mea, manei na mea ne sapi manei saukaha kamirei wemereha bei, toyari sumuri, na rahida Sabati foi. Mano ne fiahung sawa foi minohi suati ete sikaherawa yuaisi na kutu iari nanai konta ne? Tawaitawanai weo yuaisi rai.” ");
INSERT INTO amk_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Manamo wiro manei yoa we Yesusi kariri fi medura fo aha kaha. ");
INSERT INTO amk_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Na nanai Yesusi deti inontarai notisa manea na munufoi mani, etiri katai mahikai sewa fo we eminohi nayai. Ampafe doni deiriri fiyiwansoai ninai wesa, deyo, ");
INSERT INTO amk_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Manei wenoti mea we muniara mandirau bei mani, dohonao mera wa mani metiri fatao mahikai sewa watai na fongfo weo meminohi naya fe. Weo tarahio mano ne muniara foi wenoti inontarai wewonong manei kontai to muniarafoi fe. ");
INSERT INTO amk_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Nana mani ambori mano ne muniarao wenoti muru ruhiai nani, da we wau mau deyo, ‘Waune, katai nini imainenami we mano iwenoti mambani.’ Nana mani ambori mumaya paria boabari wau ro ahao munohi nano katai fui pari foi. ");
INSERT INTO amk_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ampafe manei wenoti mea mani, metiri katai fui pari fo we meminohi nayai, ambori mano ne muniara foi da ma deti mea mani medu we mea deyo, ‘Maniwowire, ro ma munohi na kataio mehikai nini.’ Ampafe kaiwasa esomi we mea na bitoyafoi euremireafo. ");
INSERT INTO amk_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Weo mandoni dino yuai ne tarai dedai mani ambori tewawa ki, wape mandoni dino niariri ao tewawa mani ambori dedai ki.” ");
INSERT INTO amk_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Mayeai Yesusi medu we Farisi mano ne munu foi deyo, “Boyo nari muniara bei wenoti inontarai we metampi, na rahida ete diru ete, wiro wenoti nemu maniwowiri ete arurarai, ete mano meminohi ruhiaio ene fianggeng bitoya fosa fe. Weo nana mani ambori ea ewenoti wau kontai tonanai ki, ne tonanane bai wawerahai na finari nanaya. ");
INSERT INTO amk_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ampafe boyo nari muniara bei mani, wenoti inontaraio ene pari fi, inontaraio ene taraifo mesi kahai, inontaraio eawemi fananahang tutu inontaraio euremifafa. ");
INSERT INTO amk_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Nana mani wobu moang rai, weo inontarai nanisa wiro ebai nemu mahikai bohonai nana kaha. Mae nemu mahikai nanai ambori Allai biaitai ki, na rahida bo inontarai emai fosa esuwi na marareha rorong foi fo.” ");
INSERT INTO amk_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Inontarai manei dampi ruhiai kontai ria Yesusi na nana foi, tarao kaiwoariri Yesusi medura fo, ampafe medu deyo, “Inontarai mano ambori etampi ruhiai ria Seng Allaifoi na ne Mananu rorong fo, esobu mai paria!” ");
INSERT INTO amk_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Manamo Yesusi medu we inontaraifoia deyo, “Na rahida bei, inontarai manei niari muniara fiabai bei, tutu wenoti inontarai bitoya paria we ne muniarafoi. ");
INSERT INTO amk_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Rahida bo muniarafoi ne diru neungfo mai we nariri fo, inontaraifoi demi ne mano fiatari foi, da we mano wenotisara fosa, medu wesa deyo, ‘Mera ma, we fianggengfe mainenang ampa.’ ");
INSERT INTO amk_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Manamo mano wenotisa fosa kiai, na manei to manei eteiaio mangfatafoi. Mano reantenang foi medu we mangfatafoia deyo, ‘Yau arahio iwori nehu kahofafeai tutu ira we ye iwatioa fininai. Kosou yau fanai.’ ");
INSERT INTO amk_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Mano sua ahang foi medu deyo, ‘Arahio iwori sapi ewesura ma fininai we efata yau na nehu romifoi, tutu ira we yeo inari karirisa fininai. Ampafe kosou yau fanai.’ ");
INSERT INTO amk_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Manei aha mani deyo, ‘Yau arahio irirau ninai ampafe wiro ira mau kaha rai.’ ");
INSERT INTO amk_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Mangfatafoi daraberahi aha deikaririai we mano ne muniarafoi, kariri fifiani aino mano wenotisa fosa emadura fo. Ampafe mano ne muniara wenotisa foi kesou paria, medu we mangfatafoi deyo, ‘Ro kahairai to rang dereung, to katai ruhi na bendari fo. Ka inontarai ene pari fi, inontarai ene tarai mei kaha, inontarai euremifafa, tutu inontarai eawemi fananahang.’ ");
INSERT INTO amk_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Mangfatafoi da wa dohong kaririaia daraberahi aha ma deyo, ‘Daie, nemu kaiwofe yohong kaririai kawuru ampa, manamo katai bitoya wiatai arora nendai.’ ");
INSERT INTO amk_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Mano ne muniarafoi medu aha deyo, ‘Ro nariai aha to rang baba, tutuo rang ai rorong, na bendari dereung boriai fo, boa biaing inontaraiwasa era ma ambori nehu mununei sefang na kaiwasa. ");
INSERT INTO amk_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Aromuoaifa weo inontarai fuba iwenoti kawurua foi mansiri kontai wiro dang nehu fiangno muniara finini kaha.’ ” ");
INSERT INTO amk_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ainanaya Yesusi dao ne rang rorong daoa fo aha, tuti inontarai bitoya paria era ruhia riati. Yesusi daraberahi medu we ea deyo, ");
INSERT INTO amk_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Manei de daria yau, wape enewawu inanai, tamanai, ne wiwing, ne arikang, ne tahatui, ne tafuaisa, kontai ne tarai bo neng foi terai sewa yau mani, wiro daria yau kaha. ");
INSERT INTO amk_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Inontaraio mandoni dino miaya we sodua ne aitabafoi tuti daria yau kaha, amani wiro meinenang we eteiberahi, enari kanggani, tutu emuni toyari yau kaha mani, wiro daria yau kaha. ");
INSERT INTO amk_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ne tarai kariri finina. Inontarai manei na mea de biaung munu bei, wiro beyari nana mani niariri kaha, mae minohi deto kariri ne doi we niari munufoi nai foi akawuru wo. Tarahai ne doifo mai we niari ne munufoia kiai ete bireri e. ");
INSERT INTO amk_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Weo enefunomi niari amangfoi kawurua, wape ne doifo kaia, ampafe niari paria kiai kaha. Nana mani ambori inontarai fuba ewati fi niariri foia ambori emarari ki. ");
INSERT INTO amk_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Eteyo, ‘Tofino, inontarai nini biaung munu amangnei ao wia funomai tonanaia, wape wiro wedaya we niariria kiai kaha.’ ");
INSERT INTO amk_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ete, ne tarai kariri finina kontai. Mananu manei ne rai mamuna ewepiaura wering wesura (10.000), de era we emamuna we mananu siai manei. Wape mananu siai nani ne rai mamuna efau weberu sewa aha. Mananufoi wiro enefunomi kahai, minohi mae enetituai sauwarai we ne rai mamuna fosa, ewemambiriu weo emamuna we ene aiteta efau sewa fosa ete bireri e? ");
INSERT INTO amk_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Mae deitawanaifa weo ewemambiriu kaha mani, ne aitetafosa enai waroi mae demi manea kawurua etutang berahai we mananu siai nani. Etutanai we fifianai aino enetituaitaifa medurai we fio ambori mananu ne rai mamuna efau kaha foi dohong kaririai, ambori uenemirorong boyari.” ");
INSERT INTO amk_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ampafe Yesusi deyo, “Tonanai kontai we mea. Manei de daria yau mani enetituai sauwarai akawuru wo. Manei wiro sawing pari fi niari fo kai, kontai aroporoha kaha mani, wiro daria yau kaha.” ");
INSERT INTO amk_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Ainei mani mehikai we indawang fi nai, wape meuwai ahang kaha mani, ohoni todoni wori meuwai aha ki? ");
INSERT INTO amk_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Denteng ahang kahaia finana weo nari fifiani nai kontai aha. Ampafe kabi teri reto. Mewemetarami mani metarami saua kaiwo fino imadurai nina!” ");
INSERT INTO amk_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Na rahida bei, inontarai efanduhi pajaki we Mananu Kaisarifoi manea, tutu inontaraio siai bitoya kontai, era ma etaramididau Yesusi. Inontarai nansa, Yahudifosa esahusa we inontarai ene sasari fiabai disa. ");
INSERT INTO amk_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Ampafe inontarai eweFarisi tutu mantaunau Kaiwo Musai soi fosa ewatisa nana fo emadu wawerasa paria. Eteyo, “Is! Inontarai nini minohi ria inontaraio ebeng kahai tutu dampi ruhiai ria sa.” ");
INSERT INTO amk_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Yesusi tarao emadu tonana ne ampafe deiriri fiyiwansoai nini. ");
INSERT INTO amk_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Tofino na mea, manei ne domba ewepiaring, manamo manei da sarawai ampafe niai, nana mani dohong todoni rai? I wiro niayai deitawang ne domba ewemansiri konta reti piaring fosa ahang kaha, mae todoni kontaio sawing ne efaufosa enayai na katai minano foi mae da sera we mansiario niai foi paria sobui. ");
INSERT INTO amk_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Kontai sera wa sobui aha mani piraise paria, ampafe yuaisia wia sau warabiawafoi, kiari daraberahi aha. ");
INSERT INTO amk_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Mayeai sahu ruhi ne maniwowirifosa tutu mano ene munu wariruhia fosa, medu wesa deyo, ‘Mera ma tafaraise weo nehu dombafi niai ampa, manamo isobui kawuru aha ma ne.’ ");
INSERT INTO amk_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Na Waidani kontaio tonana, inontarai sasari manei daraberahi weru ne sasari rorong foi mani, Seng Allai piraise fuba paria, piraise sewao ewemansiri konta reti piaring mano eteyo ene pari sasari fosa.” ");
INSERT INTO amk_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ete, toyario fiyiwansoai nini kontai. Wiwing manei ne doi peraki sura. Doi peraki sura nana mani we ne gajio rahida sura finanai. Mayeai bei niai. Fifiani aino niari fo? I ambori kiai padamarang bei sambewa munufoi, tutu fintang aikahia munufoi, sera wei paria sobui aha. ");
INSERT INTO amk_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Na rahida bo sobu doifoi nani, sahu ruhio ne maniwowirifosa kontai mano ene munu wariruhia fosa, medu wesa deyo, ‘Mera ma tafaraise weo nehu doi niai fi isobui aha ma ne.’ ");
INSERT INTO amk_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Tonanai kontai inontarai seipaya manei daraberahi weru ne sasari foi mani, Allai ne wewai rabuang faisi efaraise fuba pari beyari.” ");
INSERT INTO amk_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesusi medu aha deyo, “Wawa manei, amani ne kaisung mandu. ");
INSERT INTO amk_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Mano fui foi medu we tamanai deyo, ‘Daie, nemu rao munohi tutirai fa, awao mureha mani auratorai mai we auru wa, rahida nini kontaio botoraifa bohong nehuwa ma.’ Ainanaya tamang deto rao minohi tutira fo weberu maino ne kaisungfo suru. ");
INSERT INTO amk_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","We rahida beiru teai aha mani, arikang mano fui foi dewayangno nengfo we doia, mayeai dong to nu waroi. Na wanai sifai ne doifoi we dampi, dunung, piraise, niari fi mai kahai kontai. ");
INSERT INTO amk_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Pariao rahida bo ne doifo kai foi, tete kahari fiebai pari beyari ming na kataifoi tentenang. I fo mayeai sodai ne dadirafo, dampi na mai kahai, sensung ansung mai aha kahai. ");
INSERT INTO amk_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ainanaya, da wa niari fi we inontarai na munuefo manei, amani wenani demi da wa, deitawang ne fiai rabuang foi na katai fiai etoa nai foi. ");
INSERT INTO amk_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","I wewisi paria ampafe deyo dang fiai ene fietang fo wea, weo wewisia tonanai wape wiro manei aroi dohong fiea dang kaha fefe. ");
INSERT INTO amk_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Mayeai arahio urengfo tabau, we deroanso fifiani aino niaria fo, ampafe medu deyo, ‘Inontarai bitoya erufi we dai fosa esobu fianang bitoya, wape yau na ninai adareti iwawisi ao imereha. ");
INSERT INTO amk_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Rahida bonini kontaio yarabera yau ira we dai aha. Na dai arongreafo imadu wei yeyo, “Daie, yohong sasari fiebai we Seng Allai tutu wau kawurua. ");
INSERT INTO amk_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ampafe wiro imai we wahu yau we nemu arikang ahang kaha. Yau ira ma weo nehu tarai toyario nemu inontaraio erufi we wau wasa.” ’ ");
INSERT INTO amk_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ainanaya daraberahi da we tamanai aha. Tamang doa na itone munufoi, na waroi detiaoi kawurua. Tamang aroi paria deti kahutu urehuru mae mito wei, awa sobui mayeai fiauni tutu ninahi. ");
INSERT INTO amk_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Arikangfoi medu we tamanai deyo, ‘Daie, yohong sasari fiebai kawuru we Seng Allai tutu wau ampa. Ampafe wiro imai we wahu yau we nemu arikang ahang kaha.’ ");
INSERT INTO amk_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Manamo tamang medu kutu ne kaiwofo, sahu inontarai erufi wei fosa deyo, ‘Mesahera meha ansung mahikai sewa feai ma mesansuni nayai, araha mehikai bei we metatari na warakehanei, tutu sapatu mahikai feai we metatarai na awengne. ");
INSERT INTO amk_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Menari kariri ne nanai amani, meha sapi ne arikangno biriayai manei, ama memuni. Rahida bonini kontaio tatohong muniara fuba, tatampi tafaraise. ");
INSERT INTO amk_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Weo nehu arikangnei mireha ampa, manamo suwi nari aha ma ninai, i niai ampa manamo isobui nari aha.’ Mayeai ea etohong muniarafoi. ");
INSERT INTO amk_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Wape arikang mano fuba foi mani niai nano romi. Mayeai ramindena ampafe daraberahi to munufo aha, da pariao kefang munufoi, tara to munufoia mani, tarapao musiki dotu fo tutu kaiwasa mikai foi eraomifuifoi. ");
INSERT INTO amk_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Ainanaya sahu tamang ne mangfatafosa manei ma dutang berahi deyo, ‘Fifiani dino menariri na munufoi wana?’ ");
INSERT INTO amk_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Mangfatafoi medu wei deyo, ‘Nemu tahatuifi daraberahi aha ma ne. Ampafe tamamuo anta demi amea amemung sapi antung biriayai manei, we tatohong muniara fuba, weo sobu antungfoi daraberahi na mai aha ma fefe.’ ");
INSERT INTO amk_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Arikang mano fuba foi tarao kaiwofo nana ne kesou paria, ampafe miaya we suai munufoi kaha. Mayeai tamang taraoi we doa na boriaifo, ampafe dari ariei weworiri ambori da to rorong. ");
INSERT INTO amk_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Manamo kesou medu we tamanai deyo, ‘Bo! Rahida neungne iminohi ria wau na defuina to defuina, irufi ao imereha we wau, modu kaiwofea mani yohong kaririai. Manamo fifiani aino bohonai we yau ne? Kambingne arora ki, wape wiro bohong sobu manei we inari muniara ria nehu maniwowiri sa kaha. ");
INSERT INTO amk_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Antumu mesi kahai nani dewayang fi munohi tutura wa we doi, kia doi nani dong to katai doboriai fo niai nayai, na wanai mei doifo na wiwing diru paria kai, mayeai daraberahi ma, wape wau mungno sapi antung fiebai biriayai weo bohong muniara fuba wei!’ ");
INSERT INTO amk_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Manamo tamang medu wei aha deyo, ‘Kaisungne waune, wau munohi pampang ria yau na ninai. Fifiani aino nehu ne nemu fi fine kontai. ");
INSERT INTO amk_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Wape nina mani nemu tahatuinei toyari mireha ampa, manamo suwi nariai aha ma ne. I niai ampa, manamo tasobui nari aha ma ninai, ampafe todoni kontaio tatohong muniara taparaise.’ ” ");
INSERT INTO amk_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesusi medu we ne inontarai erariati fosa deyo, “Inontarai ne ra bitoya manei, ne mangfata manei, yuaisi we deitawang ne rafoi, yurai tuturi sera weo ne faufo kontai aha. Manamo na rahida bei inontarai ne ra bitoya foi sobu kaiwoariri weo mangfatafoi sifai ne rafoi. ");
INSERT INTO amk_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ampafe sahu ne mangfatafoi ma, mayeai dutang berahi deyo, ‘Tarahuoai weo wiro nari sua nehu ranei na mai kaha, mae wufai funomi. Rahida nini kontaio bohonai we yau fi woi kariri nehu ranei we bohoni toa ne, kontaio fotourai weru boitawang nehu ranei.’ ");
INSERT INTO amk_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Ampafe mangfata deitawang ne rafoi enetituaitai, ‘Fiani aino inari na kutu ninaifa ne? Weo mano ifatai foi deiai yau weru fi yoasoaio yau we inari ne fefe. Inari romi nehu mambiriufea kaha, ira yedo weo fi na rang dereung imamaya.’ ");
INSERT INTO amk_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Mayeai enetituai obu mano eha fi riati fosa manamo wiro ebaita kaharai. Ampafe medu deyo, ‘O! Enehutituai rang bei, ambori ifotourai weru fi inari ne mani, nehu maniwowiri bitoya, kontaio emirising we iminohi ria ea, na ene munufo.’ ");
INSERT INTO amk_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ampafe mangfatafoi sahu mano ehao inontarai ne ra bitoya foi ne rafo, manamo ebaita kaharai fosa. Sahusa wemansiawarai ma dutang berasa. Medu we mano reantenang foi deyo, ‘Nemu fi baita kaharai beiru we mano ifatai foi?’ ");
INSERT INTO amk_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Inontaraifoi yoa deyo, ‘Maning ora babeu piaring (100).’ Mangfatafoi dohongno surati fi baita kaha foini we inontaraifoi aha, medu wei, deyo, ‘Munohi na nanaifa, wukahera woi riwangno fiwoi we maning ora babeu piaring na surati nani faini wa, weo babeu piarua sura (50).’ ");
INSERT INTO amk_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Mayeai medu we inontarai mano sua aha foi deyo, ‘Wau nemu fi baita kaharai beiru?’ Inontaraifoi yoa wei deyo, ‘Patibu karung piaura wering (1.000).’ Mangfatafoi dohongno surati fi baita kaha foini we inontaraifoi aha, medu wei, deyo, ‘Nemu surati kariri fi baita kaha wai dinini. Woi riwangno fiwoi we patibu karungno piaura wering na surati nani, riwani we karung piaura wera (800).’ ");
INSERT INTO amk_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Mano ne ra bitoya foi tarao kariri finiarifo, ampafe fiai ne mangfatafoi weo ne enetituaitafo, weo i sewai paria, we sera we rang weo ne maifo, na rahida bo fioairai weru fi yu fong fo. Weo inontarai eroaso Allai kaha nesa, esera we ra na nunei mani esawai paria, sewao inontarai eroasoa fosa, na esera weo rao Sempaisine.” ");
INSERT INTO amk_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Mayeai Yesusi medu aha deyo, “Metarami ma! Fianggengno Sengnei dohoni we mea na nu finini, menari suari na mai we mefata inontarai siai nai, karirio Seng Allai dawiafo. Ambori rahida bo mansuwi-suwi foi mani, fianggeng nunei kiai niai, wape mea mesobu mai na Waidani. ");
INSERT INTO amk_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Inontarai manei niari fi katui fo na mai mani, ambori yuaisi we niari fi fuba fo ki. Wape inontaraio niari fi katui fo na mai kaha mani, wiro yuaisi we niari fi fuba fo kahai kontai. ");
INSERT INTO amk_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ampafe na ra nunei wiro inontarai eroaso mea weo menari suari na mai kaha mani, mantei dino de yoaso rao tarai na Sengnei we mea ne? ");
INSERT INTO amk_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Kontaio manei siai ne fieaifa, yoasoaio mea we menari sua neng, manamo wiro menari suarai na mai kaha, nana mani Allai wiro dohong fieai we menari suarai ahang kaha. ");
INSERT INTO amk_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Wiro inontarai manei wewoming we mananu mandu kaha. Weo nana mani ambori enewawu manei mae enerireu mano wei foi ki. Ete niari kariri manei ne kaiwofo mae kiobu tarang we mano wei foi nengfo ki. Tonanai kontaifa we mea, wiro mewewoming we Seng Allai tuti mewewomong we doi ruhia kaha.” ");
INSERT INTO amk_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisifosa etaramio fifiani aino Yesusi yiwansoaia fo. Manamo emarari Yesusi ne kaiwofo, weo inontarai euremi fiebai we doi disa fefe. ");
INSERT INTO amk_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ainanaya Yesusi medu wesa deyo, “Mea mani inontarai merurai paria, ambori kaiwasafoi ewati fi menari wa tutu enemitituai weai, eteyo mea mani inontaraio metohong karirio Sengnei ne Kaiwo na mai di mea. Wape Allai deitawang menemirorongwai. Weo fifiani aino inontarai nuneisa esahuai we fi dedai tutu esomi weai fa, Allai eneoa kaha tutu sahuai we fi mai kaha. ");
INSERT INTO amk_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Hukumi Musai soi fo tutu kaiwo nabifosa emadura fo mani, wemambiriu pampang paria sobu rabuang bo Yohanesi deunau fo. Mae na nanai to fong ma mani, Kaiwo Mahikai kariri todoni Allai weMananu na demi Mananu Mampariri nei ma fo aino aiririai pampang ne. Kontai kaiwasa bitoya erurai we Sengnei yuaisa we ambori eminohi na Sempaisi ne Mananu rorong fo ki. ");
INSERT INTO amk_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Wape Seng Allai ne Kaiwo Musai soi fo tutu nabifo emadura fo wemambiriu wefitawafa, wiro hurupi kutu bei kontai oiayari kaha. ");
INSERT INTO amk_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Ampafe mandoni dino dira binengfoi tuti dau wiwing manei siai aha mani, wenani niari sasari, amani sasario dena ria wiwing siai fo. Tuti mandoni dino dau wiwing anta ne mangfoi dirari nani aha mani i kontai niari sasario dena ria wiwing siai fo.” ");
INSERT INTO amk_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Inontarai ne ra bitoya manei, sensuni na ansungno ne harga dedai paria, tutu rahida neungne dampi na mai kontai, wiro sobu dadirafea kaha. ");
INSERT INTO amk_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Na rahutu borong da nai to ne munu rorong foi afuifo, inontarai ne obu fiea kaha manei minohi fefiei derewawa, dedo we fiang nayai, wonong fino Lazarusi. Inontarai nani kahai bosi-bosi suang wari ne taraifoi sentenang, ampafe ne mambiriufeai ahang kaha. ");
INSERT INTO amk_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ifo, minohi na rahutu borongfo finanaia, we demang we tarahio inontarai ne ra bitoya foi dang ta fieai fa ete nukahaifea tarirawai aweu, etiri to borie ariei mani ambori yuru dang. Inontarai nani faini kontaio, fiawerafosa era erare kahai fuba suang na ne taraifoi nani. ");
INSERT INTO amk_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Waroi kahai mae inontarai ne obu fiea kaha foi mireha, mayeai wewaifosa eha ne nuaninufoi to katai mei, awa minohi na fata dedai rurang Abrahami. Inontarai ne ra bitoya foi kontaio mayea mani mireha kontai aha, ne inontarai esarai enari suari na mai. ");
INSERT INTO amk_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Wape na Soroha rorong fo sodai ne dadirafo paria. Na katai nani fioai ureng deti to yai awiai mani, detio Abrahami na katai waroi, kontai deti Lazarusi we minohi rurang Abrahami. ");
INSERT INTO amk_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Inontarai ne ra bitoya foi sahu we Abrahami deyo, ‘Dai Abrahame! Aromuo yau kite! Bomi Lazarusi yorang warakehawai na merehafeai, kia da ma ao wawasao rahukanangnei wo. Weo isodai ne dadira ne pari beyari na adia rorong nei fefe.’ ");
INSERT INTO amk_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Wape Abrahami yoa wei deyo, ‘Nehu kaisungwa wau, aromuoaifa, weo raminde munohi barang na nuwausi mani wobu ne bengfo paria. Wape Lazarusi sobu ne karirafo paria. Ampafe na ninaifa mani, i piraise we sobu mai na katai nini, tutu wau wobu ne karirawa na nanai. ");
INSERT INTO amk_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Kontaio katai nai nai wai tutu katai amenai nai nei, kenatateraio fiebai berorong paria, kiutu tata. Ambori wiro amea na ninai amera mau kahai, tutu mea na nanai wiro mera ma kahai.’ ");
INSERT INTO amk_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Inontarai ne ra fiebai foi medu we Abrahami aha deyo, ‘Daie, tonana mani yutang wau na mai mau weo, bemi Lazarusi da to dai ne munufoinia. ");
INSERT INTO amk_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Weo nehu tahatui ewering eminohi na dai ne munufi fo. Bomi Lazarusi dei kaririai wesa ambori ea kontaio wiro esobu katai kerira isobui nini konta fanai.’ ");
INSERT INTO amk_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abrahami yoa wei deyo, ‘Ea ene Kaiwo Musai soi fo tutu kaiwo nabifo esoi fo ampa. Ampafe etohong kariri te fifiani aino deinawiai tutu deunau kaririaia fo.’ ");
INSERT INTO amk_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Manamo inontarai ne ra fiebai foi yoa we Abrahami aha deyo, ‘Dai Abrahame! Kaiwo nanai tera mani demoyara kaha, wape inontarai mireha manei suwi na marareha rorong foi, da wa medu wesa mani, ambori etaraberasa weru sasari rorong etohoni foi ki.’ ");
INSERT INTO amk_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Wape Abrahami medu aha deyo, ‘Ea emaya we etarami Kaiwo Musai soi fo tutu nabifosa emadura fong kaha, tutu etohong kariria kaha mani, manei suwi na mararehafoi da wa medu wesa kontaio eroasoa kahai kontai ki.’ ” ");
INSERT INTO amk_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesusi medu we ne inontarai erariati fosa deyo, “Na nunei mani fi bitoya wedaya inontarai we enari sasari. Wape inontarai manei wedayarao inontarai siai enari sasari nani fai mani, ambori sobu ne karirafo rai. ");
INSERT INTO amk_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Inontarai mano wedaya inontarai siai enari sasari mani, ne mahikai sewa we wenani mani, kase kamiei fuba bei na rahanangfo tuti kabioi deisui na rawanangrausi. Weo inontaraifoi ambori sobu aiboi maraba fuba sewari aha ria Seng Allai. ");
INSERT INTO amk_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ampafe metanansiau! Mane nemu doroi manei dohong sasari mani, mesua wenani. Detua wawerahi we sasari dohonia nani mani, mefariri ne sasarifoi. ");
INSERT INTO amk_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Manei dohong sarafieai fa we mea pampang, toyari na rahida bei we beitu, wape wenani da mauo mea deiai ne sasari dohoni we mea nani, deyo, ‘Yetua we sasari yohonia fo’, mea kontaio mefariri ne sasarifoni.” ");
INSERT INTO amk_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Rasuli ewesuraya mandu fosa, emadu we Seng Yesusi, eteyo, “Sengne waune, bohong amea ameroasoaia mutu, ambori amea kontai amenari fi toyari wau nari wa.” ");
INSERT INTO amk_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Sengnei yoa wesa deyo, “Sawi bongnei mani ketui paria, wape mene meroasoawa fuba kariri sawi bong nani mani, mea kontai ambori menari fitantuma ki, toyario meteia ai rowei tifating tutu newa, awarauo doa na rawanangrau, ai nani tifating kaririai.” ");
INSERT INTO amk_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Yesusi medu we ne inontaraifosa aha, deyo, “Na mea manei ne woming manei. I da wa niai na romi ete deitawangno fiahung na kafa paria ramindena. Womingfoi daraberahi to munufo aha ma mani, mano ne womingfoi wiro medu wei deyo, ‘Fotou finariwa, munohi, bampi.’ ");
INSERT INTO amk_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Wape medu wei deyo, ‘Tata ansung mararebana feai, moinenang nehu fiyangwa tutu fata yau mae yampi paria kai wo. Ainanaya finariwa kai wori, bampi ki.’ ");
INSERT INTO amk_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Womingfoi niari kariri fifianai aino ne mano wewoming wei foi medura fo. Wape wiro fiai womingfoi kaha, weo inontarai yufi wei dine terai. ");
INSERT INTO amk_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Tonanai kontai we mea. Metohong kariri fifianai aino Seng Allai medurai we meara wa mani, memadu meteyo, ‘Manta ametohong kariri fifianai aino Sengnei demi amea amenari fo.’ ” ");
INSERT INTO amk_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Na Yesusi ne rang rorong da to Yerusalemifo, Yesusi da wa sobu katai rabuang na nu Samaria tutu nu Galilea. ");
INSERT INTO amk_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Da wa de suai munuefeai na nana fo mani, inontarai ewesura emaninang kusta fo, era we Yesusi ma. Etoari na waroi ");
INSERT INTO amk_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","esahu we Yesusi eteyo, “Dai Yesuse, aromuo amea to!” ");
INSERT INTO amk_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Na kutu siario Yesusi detisa nana fo medu wesa deyo, “Mera wa meteinawi mene taraiwai we imamifosa, tutu metutansa ewati kariri mene taraiwai.” Na rang rorong era we imamifosa foi, ea kiai ene fimaninangfoi niai werusa. ");
INSERT INTO amk_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Inontarai mansiri na ewesura nanisa, deti bera ne taraifoi deitawanai we fimaninangfoi niai weruri ampafe dentengna. Ainanaya daraberahi we Yesusi aha, piraise fiai Seng Allai. ");
INSERT INTO amk_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Na Yesusi arongreafo disang kapa awebuka, dohong mahikai wei. Inontarai nani fai mani, inontarai Samaria dine, wiro Yahudi kaha. ");
INSERT INTO amk_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Mayeai Yesusi medu deyo, “Tofino! Yeitarahi anta inontarai ewesura inarisa ebeng mae? Ewemansiri konta reti sura fe saidoni ampa? ");
INSERT INTO amk_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Todoni fino inontarai Yahudi kaha nini faini, andino daraberahi terai aha ma deparanding Seng Allai ninai?” ");
INSERT INTO amk_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ainanaya medu we inontaraifoi deyo, “Boabari wau, roa. Weo roaso yau ampafe bonteng ninai.” ");
INSERT INTO amk_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Inontarai eweFarisi maneiru teai etutang bera Yesusi eteyo, “Kidoni wori Allai da ma we wemananu we tata ki?” Yesusi yoa wesa deyo, “Rabuang bo Allai da ma we wemananu mani, wiro waitawanai na fiainawiaio atioai na nunei ete na rorafaisi kaha. ");
INSERT INTO amk_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ampafe wiro inontarai ambori emadu eteyo, ‘Mera ma mewati andinini!’ ete ‘Andiwani!’ Weo Seng Allai wemananu rahang mea kawuru ampa.” ");
INSERT INTO amk_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ainanaya Yesusi medu we mano erariati fosa deyo, “Ambori na rabuang bo da aha ma wani, merurai paria we mewati Kaisung Inontarai nei niai woru mea, na rahida boyari kontai ki, manamo mesobua kaha. ");
INSERT INTO amk_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ambori inontarai emadu we mea ki eteyo, ‘Mewatia niai na wanai,’ ete ‘Mewati ma niai na ninai!’ Wape dohonao meroasoaifa mera mesera wei fe. ");
INSERT INTO amk_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Weo Kaisung Inontarai nei ne rahida arera fo mai we da aha ma mani, ne tarai toyario kaiwewao keiwewari na rorafaisi, sambewarai na rearei paria sobu rearei. ");
INSERT INTO amk_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Wape reantenangfo mani, sodai ne karirafo bitoya paria, tutu inontarai na rabuang bonini eteiayari ki. ");
INSERT INTO amk_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Rabuang bo Kaisung Inontarai nei da aha ma weo wemananu foi mani, ne tarai kariri na rabuang bo Noaki na fafong nanaia fo. ");
INSERT INTO amk_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Amani rahida neungne inontarai etampi, etunung, erirau, paria sobu rahida bo Noaki suai to ne wa fiabai rorong fo, foa fubaterehai dautai sufoi nunei kontai inontaraifoi mirareha webuai kiai beyari. ");
INSERT INTO amk_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Kontai kariri rabuang bo Loti fa. Inontarai etampi, etunung, etawayang ewori fi, enari romi, enari munu. ");
INSERT INTO amk_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Wape rahida bo Loti da weru munue Sodomi fo mani, na kutu siari nanai kontaio adia tutu kamiei adia bia na rorafaisi meu, kaso bendarifoia wioru tutu inontaraifosa ehai beyari. ");
INSERT INTO amk_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ne tarai tonanai fa konta rai na rahida bo Kaisung Inontarai nei kiawariai aha ma fo. ");
INSERT INTO amk_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Toyarine, kaiwasanei esobu karira tantuma rai. Ampafe na rahida bonani inontarai manei minohi na ne munu refongfo mani, dohonao da wafui we kia ne fianggengfo na munu rorongfo fe, wape mito weru katai nani. Manei niayai na romifoi, dohonao daraberahi we ne fianggengfo to ne munufoi fe, wape mito weru katai nani. ");
INSERT INTO amk_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Mearomio fifianai aino Loti binengfoi sodairaia fo, weo enerorong dohong we ne munu tutu ne kataifoi weo ne maifo nai naya finanai. Ampafe deti berahai we kataifoinia, ainanaya wekamiei doaria. ");
INSERT INTO amk_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Mandoni dino derara mantauni ne ansengfoi sewa weru daria yau fo mani ambori ne ansengfoi wioru ki, mae mandoni dino na nufi ninai enewawu yau awao wonohune wedaya tarahi mireha kontai ki, i ambori sobu numainufo ki. ");
INSERT INTO amk_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Meroasoaifa! Na diru bonani, inontarai mandu uwa na fata bei mani, Sengnei yuai manei mae manei wiatai. ");
INSERT INTO amk_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Wiwing mandu utara ruhiai na anawahi bei, kia manei mae manei bireri. ");
INSERT INTO amk_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Mang mandu unai na romi, kia manei, manei bireri.” ");
INSERT INTO amk_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Mano eraria Yesusi fosa eberahi aha eteyo, “Sengne waune, finanai dariai na doni rai?” Yesusi yoa wesa deyo, “Fi mireha piro fei wiatai na doni mani, atio korowei esifo etari katai nani. Toyari nanai kontai, rahida ira nai aha ma foi mani, ati pari ki, wiro yediwa yau kaha.” ");
INSERT INTO amk_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Mayeai Yesusi deiriri fiyiwansoai nini we deunauo ne inontarai erariati fosa, ambori etutang Sempaisi we fiea mani enemitawanai, tarahi etutanai waroia manamo esobua kaharai, nana mani dohonao ewarami mururang ahera fe. ");
INSERT INTO amk_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Yesusi deyo, “Na bendari bei, inontarai manei eruaisi we andino kiutu kaiwo ne. Inontarai nani fai mani wiro mitai Seng Allai kahai, tutu i mani wiro tarao inontarai siai kaha kontai. ");
INSERT INTO amk_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Na nanai wiwina manei sodai kaiwoaririfeai. Ampafe wiwinafoi deikaririai we mano kiutu kaiwoariri foi, weo medu kariri neng, manamo wiro dohong kaririai ahera kaha. Ampafe wiwinafoi da weduari pampang, medu wei deyo, ‘Fata yau, modu we mano weaiteta we yau foi.’ ");
INSERT INTO amk_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","We beiru teaia, manamo mano kiutu kaiwo foi miaya we dohong kariri fi wiwinafoi deyoa fong kaha. Wape mayeai enetituaitai deyo, ‘Yau wiro imatai Sengnei kahai tutu wiro tarahuo sobu manei ahang kahai. ");
INSERT INTO amk_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Manamo wiwinanei da wedua yau pampang we ne kaiwofo, ampafe ne mahikai mani yohong kariri fifianai aino deyoa foa. Bireri ki mae ambori da tetawa yau pampang, dohong yaua isera wawera yohong toai ki.’ ” ");
INSERT INTO amk_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ainanaya Sengnei deyo, “Menemitituai we kaiwo mano kiutu kaiwoariri mesi kaha fi medura fo. ");
INSERT INTO amk_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","I wiro inontarai mesi kaha dine, wape niari ne bengfo we wiwinafoi. Nana mani Seng Allai ne mahikaifo sewari aha. I ambori fiata ne inontarai esodai ne dadirafo tutu etutani pampang kameai ramindena weo fi esodairai nana fo ki. ");
INSERT INTO amk_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Meroasoaifa! Allai ambori sikahera fiata ne inontaraifosa weru ne karirafo ki. Wape Kaisung Inontarai nei daraberahi to nunei aha ma mani, sobu inontarai eroasoa fea rai ete bireri e?” ");
INSERT INTO amk_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesusi deiriri fiyiwansoai nini aha, deiriri fo mani reng we mano esahu inontarai siai we emai kaha, mae ene tarai bo eneng foi di mei sewa fo. ");
INSERT INTO amk_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Yesusi deyo, “Na rahida bei, inontarai mandu ura taterai to Sempaisi ne Munufoi we uwenadi nai. Inontarai nani suru mani, Farisi manei tutu inontarai fianduhi pajaki we Mananu Kaisari foi manei. ");
INSERT INTO amk_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Na Sempaisi ne Munufoi rorong fo, Farisifoi doa futuayai siai na fong pari fo, mae wenadi deyo, ‘Seng Allae yohong mahikaifeai we wau, weo yau wiro nehu tarai kariri inontarai siaio esera we ene ra bitoya fosa kaha, etatofa biriu, ete emaninawa fosa kaha. Yohong mahikai kontai we nehu tarai kariri mano fianduhi pajaki we Mananu Kaisari foi wani kaha. ");
INSERT INTO amk_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Yau weminggu bei mani, iwepuasa weberu, tutu yohong fi isobuai feai na fi inari wau, we wau.’ ");
INSERT INTO amk_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Wape mano fianduhi pajaki we Mananu Kaisari foi mani, doari waroi na munu warabuka refui fo, waratawang arongfo tutu ureng toung ambori medu we Seng Allai deyo, ‘Seng Allae aromuo yau inontarai sasari karira nini yau.’ ” ");
INSERT INTO amk_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesusi deyo, “Yeisaharai we mea mau, inontarai nani suru uwenadi kai mani, inontarai fianduhi pajaki we Mananu Kaisari foi, andino Allai detori we beng riati aha ne, wiro Farisifoi kaha. Weo mandoni kontaio yuai ne taraifoia weinontarai dedai mani, Allai ambori niariria tewawa ki, tuti mandoni dino niariria enerorong tewawa mani, ambori Allai yuaisia dedai ki.” ");
INSERT INTO amk_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Yesusi doa deunau kaiwasa bitoya foi mae, inontarai manea eha ene arikang marareha manea, ehasa ma weo ete ambori Yesusi yuai warang wasausa tutu mioansa. Yesusi ne inontaraifosa ewati arikangfosa nana fo, ehasou ene wawafosa tuti esuasa. ");
INSERT INTO amk_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Manamo Yesusi sahu arikangfosa ma, mayeai medu we ne inontarai erariati fosa deyo, “Metawing arikangwasa era we yau ma, dohonao meteiweduasa fe, weo inontarai toyari arikangfesa nini saino esuai to Allai ne Mananu rorong fo ne. ");
INSERT INTO amk_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Tarai, imadu we mea mau yeyo, inontaraio wiro yoasoai tuti niari enerorongfoia tewawa kariri arikang kaha mani, wiro suai to Seng Allai ne Mananu rorong fo kaha ki.” ");
INSERT INTO amk_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Inontarai wenungkamiei we inontarai Yahudi fosa manei, ne ra bitoya, i dutang bera Yesusi, deyo, “Mantaunau bontengne waune, fianai aino inari we ambori isobu numainufo ne?” ");
INSERT INTO amk_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesusi yoa deyo, “We fiani e wahu yau we yenteng ninai? Wiro manei denteng kahai, mae Allai meiri kawuru. ");
INSERT INTO amk_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Allai ne Hukumio dohonai we tatohong kariria fo boitawanai ampa, amani: ");
INSERT INTO amk_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Inontaraifoi yoa wei deyo, “Kaiwoariri fuba nani yohong kariri kawuru na iwebariboaifa ampa.” ");
INSERT INTO amk_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesusi tarao inontarai ne ra bitoya foi medu tonana ne, ampafe medu wei aha deyo, “Sea fi beyari bohong kariria kaharai, bowayang nemu ra munohi tutira wara kai, tuti doiwa bohonai we inontarai ene pari fi fosa, nanaia mani wobu ra na Waidania finanai. Tuti nari tonanaia mani ro ma ro ria yau.” ");
INSERT INTO amk_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Manamo inontaraifoi tarao kaiwo Yesusi medurai wei fo, enerorongfoi fituayai webeyari, weo ne rafoi bitoya fefe. ");
INSERT INTO amk_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesusi deitawanai we inontaraifoi enerorong dohong we ne rafoi karerai, ampafe medu deyo, “Mawa kahai we inontarai ene ra bitoya nesa esuai to Seng Allai ne Mananu rorong fo. ");
INSERT INTO amk_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Weo mawa sewa we unta manei suai kaha aniai kamirei bei weru inontarai ne ra bitoya manei suai to Allai ne Mananu rorongfe fo.” ");
INSERT INTO amk_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Inontarai etaramioai we Yesusi medu tonana fo, etutang berahi aha eteyo, “Tonana mani, mandoni dino mesi we sobu faririfo ne?” ");
INSERT INTO amk_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesusi yoa deyo, “Fifianai aino inontaraine ene mambiriufea we enari kaha fo, wape we Allai mani finanai mawa arora.” ");
INSERT INTO amk_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ainanaya Petrusi medu wei deyo, “Daie, boti amene munu rorong fo kontaio ametawinaifa tuti ameraria wau!” ");
INSERT INTO amk_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesusi deyo, “Tarai, imadurai we mea mau yeyo, inontarai mandoni da weru ne munufoi, ete ne wiwing ne arikang, ne tahatui ne tafuai, ete ne wawafo suru, ambori yufi we Allai ne Mananu rorong fo, toyari mea ninai, ");
INSERT INTO amk_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","inontarai nanisa ambori sobu fi sobuai ria Allai fo fuba pari sewa aha weru ne sobuai na nuneifo ki, tuti sobu numainufo.” ");
INSERT INTO amk_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesusi fianduhi ne inontarai ewesuraya mandu fosa siai, mayeai medu wesa deyo, “Metarami ma. Nina mani, tara to Yerusalemi ayai finina. Na wanai fi fuba nabifosa esoi kaririai we Kaisung Inontarai nei, ambori sodairai ki. ");
INSERT INTO amk_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","I ambori manei dewayani we inontarai etaroangno Allai kaha fosa, ambori eteiberahi, enemirireuwi, tutu ehandioi. ");
INSERT INTO amk_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Ambori erarubati na wai, tuti emuni mireha. Wape rahida bo botoru foi mani, ambori suwi aha ki.” ");
INSERT INTO amk_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Fifianai aino Yesusi medura fo ne inontarai ewesuraya mandu fosa, ewaitawang sobu kutea kahaia. Kaiwo neung fo medu baurai wesa kaha. Ampafe esera wawera kaiwo medu wea fo. ");
INSERT INTO amk_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Rabuang bo Yesusi tutu ne inontaraifosa era wa rerai we bendari Yeriho foi mani, inontarai urengfafa manei minohi dedo we fi na rang dereung fo. ");
INSERT INTO amk_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Inontaraifoi tarao kaiwasa bitoya era ria Yesusi fosa etohong kataifoi niukuayai paria, ampafe dutang berahai deyo, “Fiea to, donio kataifi niukuaiyai karerai nina?” ");
INSERT INTO amk_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Inontarai na nana fosa emadu wei eteyo, “O, Yesusi inontarai Nazareti foi da na ninai ma.” ");
INSERT INTO amk_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ainanaya weurengfafafoi sahu deyo, “Yesuse! Dauti ne Kaisungwa waune, aromuo yau!” ");
INSERT INTO amk_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Inontarai era fonia fosa ehasouwi tutu etemi nemboru. Manamo tentumasa kaha mae sahu fo mambiriu aha, deyo, “Dauti ne Kaisungwa waune, aromuo yau!” ");
INSERT INTO amk_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesusi taraoai nanai doa ukai, tutu demi inontarai maneitoru itobing weurengfafafoi weia. Da wa kefangna, Yesusi dutang berahi deyo, ");
INSERT INTO amk_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Fianai aino boyo inari we wau ne?” Inontarai urengfafa foi yoa wei deyo, “Daie! Yeyo iwati.” ");
INSERT INTO amk_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesusi medu wei aha deyo, “Yo, tonana mani, boti to! Nemu roaso yau wa wedaya bonteng ampa.” ");
INSERT INTO amk_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Na tatofang kutu nanai kontaio urengfo tabau deti. Ainanaya da ria Yesusi tutu deparanding Seng Allai. Inontarai bitoya na nana fosa ewati fi Yesusi niari we mano urengfafa foi nana ne, ea kiai efiai Allai. ");
INSERT INTO amk_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesusi da wafui bendari Yeriho foi, de da pari ria bendarifoi pari to Yerusalemi. ");
INSERT INTO amk_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Na bendari nani mani, inontaraio wenungkamiei we mano efanduhi pajaki we Mananu Kaisari foi fosa, wonong fino Zakeusi. I mani, inontarai ne ra bitoya dine. ");
INSERT INTO amk_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","I dohong we deti inontaraio esahu we Yesusi foi, manamo kaiwasa bitoya etoa weduari, kontai i inontarai tewawa dine. ");
INSERT INTO amk_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ampafe mito foni kaiwasa bitoya foi, awa dautai na ai rowei na rang dereung fo we deti Yesusi, we katu mani da na nanaifa ma. ");
INSERT INTO amk_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Mayeai Yesusi da wa sobu katai nani, deti ayaioi tuti medu wei deyo, “Zakeuse, bia kahairai! Weo rahida nini kontaio ye ira to nemu munuwaini mau.” ");
INSERT INTO amk_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakeusi tarao kaiwo fenana fo, toyario turu pari wei na ai raingfo meu fe, tutu piraise paria we sobu Yesusi. ");
INSERT INTO amk_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Inontarai fuba ewatioai we Yesusi minohi ria Zakeusi na ne munufo, ampafe euremitaterai paria, emadu wawerasa, eteyo, “Is! I da wa minohi ria inontarai kerira.” ");
INSERT INTO amk_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Mayeai Zakeusi, na ne munufoi, doaria medu we Yesusi deyo, “Sengne waune, nehu ra iminohi tuturaifa ne, ambori yohong dowei we mano ene pari fi fosa, tutu inontarai itofasa ika ene doifeai kawurua mani, ambori ibai webea wesa aha.” ");
INSERT INTO amk_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ainanaya Yesusi deyo, “Abrahami ne riria di wau. Weo fi anta moduraia nana mani, na rahida bonini kontaio wau tutu nemu munu rorong ne, mesobu ne maifo ria Allai. ");
INSERT INTO amk_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Weo Kaisung Inontarai nei da ma weo sera we inontarai eraiworuai na sasari rorong fosa tutu feririsa.” ");
INSERT INTO amk_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Kaiwasafoi etoa etaramididau Yesusi we medufo, mayeai deiriri fiyiwansoai bei. Weo rabuang bonani mani da kefang we Yerusalemi, ampafe kaiwasafoi ewaitaraihio katu wo Allai da ma we wemananu we ea na nunei. ");
INSERT INTO amk_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ampafe Yesusi deyo, “Inontaraio wewafonia manei, deyo dong to nu waroi we eruaisi we mananu, ambori daraberahi aha ma weo wemananu na katai nanai ki. ");
INSERT INTO amk_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Donta kaharai mae, sahu ruhi ne mangfata ewesura fosa ma, mayeai dohonai wesa doi minasi boantenang. Medu tua fi dohonai nanai deyo, ‘Metawayang na doi yetorai we meara ninai, we mesera we ne faufo aha, paria sobu yarabera yau aha ma.’ ");
INSERT INTO amk_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Wape kaiwasa na katai nanai enemirireu inontaraifoi, ampafe dontai fafongna mae, etemi manea etong tuari aha emadu we ene mano fuba pari foi eteyo, ‘Amemaya we inontarai nini wemananu we amea kaha.’ ");
INSERT INTO amk_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Manamo ene mano fuba pari foi kiobu tarang, mae yuasi we mananua, mayeai daraberahi to ne kataifoi aha ma. Ainanaya sahu ne mangfatafosa ma, weo etei kaririai wei doi beiru aino esobuai ahang fo. ");
INSERT INTO amk_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Mangfata mano reantenang foi da wa medu wei deyo, ‘Daie, doi minasi boyari bohoni we yau nani, irurai tuturi tutu isobu sura aha.’ ");
INSERT INTO amk_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Mananufoi medu wei deyo, ‘Mahikai paria! Wau mani mangfata mosi di wau. Weo na fi katui iroaso wau, ampafe iruai wau we wenungkamiei we bendari sura.’ ");
INSERT INTO amk_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Mangfata mano sua foi da ma medu wei aha deyo, ‘Daie, doi boyari bohoni wai, irurai tuturia mani isobu ring.’ ");
INSERT INTO amk_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Mananufoi medu we ne mangfatafoi deyo, ‘Wau ambori wenungkamiei we bendari ring.’ ");
INSERT INTO amk_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Mangfata mano fui foi da aha ma medu deyo, ‘Daie, nemu doifi dinini, ikafa tawania mitu na ireu bei yediwari na nehu munufoi. ");
INSERT INTO amk_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Weo imatai wau. Weo wau mani, inontaraio nemu kaiwo tapapa di wau. Wau mani nemu te fiea kahai mae ka finanai, tutu wau mani tanang te fiea kahai mae roa beting finanai.’ ");
INSERT INTO amk_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Mananufoi medu wei deyo, ‘Wau mani mangfata korira di wau! Kariri nemu kaiwoariri modura wa, yohong aiboi we wau. Wau boitawanai we inontarai nehu kaiwo tapapa di yau, ika fi wiro nehu tera kahai, tutu yeting fi itanang tera kahai. ");
INSERT INTO amk_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Boitawanai tonana mani, ka doiwaia bohoni wia na bangki ambori dawing nayai. Ambori yarabera yau tonina mani ika tamu ne antungfo kontai. Wape wau nari tonana kaha.’ ");
INSERT INTO amk_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Mayeai mananufoi medu we inontarai etoari na nana nesa deyo, ‘Meha doifoi werui tutu metohoni we mangfata mano ne doi minasi sura foi.’ ");
INSERT INTO amk_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Manamo inontaraifosa eteyo, ‘Daie, i ne sura ampa mae?’ ");
INSERT INTO amk_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Mananufoi yoa wesa deyo, ‘Yeisaharai we mea mau yeyo, weo mano sobuai kawurua foi ambori sobuai fuba aha ki, ampafe nengfo fuba aha, wape mano sobu kuteai manamo niari kaririai kaha foi ne kutu nayai nai fo kontai ambori tafating werui ki. ");
INSERT INTO amk_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Tutu na ninaifa kontaio meha nehu aitetao emaya we iwemananu wesa kaha wasa ma. Memung kahai sa na urehureane!’ ” ");
INSERT INTO amk_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesusi medu kaiwofoa kai fo, i da foni sa to Yerusalemi. ");
INSERT INTO amk_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Era wa kefang munue Betfage tutu Betania na wiwoio Saituni, demi ne inontarai erariati fosa uwemandu, ura fafong. ");
INSERT INTO amk_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Medu we suru deyo, “Mura to munue watai na taaromife wanai, mura waroi afui kahai mae muwati manei tebuhi ne keledai antung manei doari na nanai. Keledai nani manei wiro dau nai kaharai. Murehuwi mukari ma. ");
INSERT INTO amk_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Masino manei dutang bera muru deyo, ‘Murehu keledaiwai we fiani?’ muroa wei mureyo, ‘Sengnei andi demi auru aukari ne.’ ” ");
INSERT INTO amk_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Inontarai mandu fo suru ura wa, fi usobua fo kariri fifianai aino Yesusi medurai we suru fo. ");
INSERT INTO amk_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ainanaya uroa urehu keledai antungfoi, mayeai mano neng foi dutang bera suru deyo, “Murehu keledaiwai we fiani?” ");
INSERT INTO amk_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Uroa we mano neng foi ureyo, “Sengnei dino demi auru aurehui aukari wei ne.” ");
INSERT INTO amk_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ainanaya uka keledai antungfoi we Yesusia. Mayeai etohongno ene ansung boriai feai awiai ebuaisai na keledai kuruinafoi, tutu efata Yesusi dautai ayai minohi sauwi. ");
INSERT INTO amk_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ainanaya Yesusi dautai na keledaifoi to Yerusalemia. Na rang rorong da naia fo, kaiwasa era riati fosa eha ene ansungfeai ehafarai na rangfoi, emaranding rangfoi ambori Yesusi da nai. ");
INSERT INTO amk_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Yesusi rerai we suai Yerusalemifo, na rang bia na wiwoi Saituni aweu fo, kaiwasa fuba era riati fosa esahu na eraomifui fiabai, esahu efiai Seng Allai tutu etohong mahikai wei, weo fitantuma fuba ewatioai na euremireafoa fo. ");
INSERT INTO amk_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ea esahu eteyo, ");
INSERT INTO amk_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Inontarai eweFarisi maneiru teaio era ria kaiwasafoi, ehasou etarami kaiwasafo esahu Yesusi we Mananu dine, ampafe emadu we Yesusi eteyo, “Dai Mantaunaune waune, bemi nemu inontarai era ria wau wasa enemboru.” ");
INSERT INTO amk_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Yesusi yoa deyo, “Meroasoaifa! Inontarai ninisa enemboru mani, kamamiei nini ambori sahu tutu kaiwone ki.” ");
INSERT INTO amk_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesusi da wao arong wao Yerusalemi tutu deti bendarifoi fo, sai we bendarifoi. ");
INSERT INTO amk_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Medu kariri kaiwasa Yerusalemi fo deyo, “Aroo! Tofino rahida bonini ewaitawang fifanai aino kia ne maifo ma ne mani, mahikai paria. Manamo ninaifa mani wiro ewatio ne maifo kahai. ");
INSERT INTO amk_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ea ambori esodai rabuang bo ene aitetafosa enari fi kahobu bendarifo, esorui, etata wahisa. ");
INSERT INTO amk_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ea ambori emei bendarifo we dorang kuru watai, tutu emung kaiwasafosa ki, tutu kamiei boyari kontaio wiro etuati wia sau ne katai wia nai foi kaha. Weo Seng Allai da kawuru ma weo feriri kaiwasa Yerusalemi fosa ampa, manamo emaya we etoaroansoi kaha.” ");
INSERT INTO amk_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesusi suai to Sempaisi ne Munufoi rofongfo, mayeai data mano etawayangfi na nana fosa. ");
INSERT INTO amk_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Mae medu wesa deyo, “Na Allai ne Kaiwofo medu fieai, amani dotu tonina: ");
INSERT INTO amk_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Rahida neungne Yesusi deunau na Sempaisi ne Munufoi. Imami baba fosa, mantaunau Kaiwo Musai soi fosa, tutu mano ewenungkamiei we inontarai Yahudi fosa, etohong we emuni weruai. ");
INSERT INTO amk_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Manamo esobu rangfeai we etohong kariri fi enemitituaitai nana kaha. Weo kaiwasa bitoya etaramioi pampang, tutu enemirorongfoi sau we ne kaiwoaririfo. ");
INSERT INTO amk_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Na rahida bei Yesusi deunau tutu deiriri Kaiwo Mahikai na Allai fo, we kaiwasafosa na Allai ne Munufoi refongfo. Imami baba fosa, mantaunau Kaiwo Musai soi fosa, tutu mano ewefoniai we Yahudi fosa, era ma emadu we Yesusi eteyo, ");
INSERT INTO amk_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","“Boi kaririai we amea, na mandoni wonongne tuti ne mambiriune nari fi bitoya tonina fenina? Tuti mandoni dino yuai wau we nari fininaifa ne?” ");
INSERT INTO amk_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesusi yoa deyo, “Yau kontai yutang bera mea we fieai. Meteisaharai we yau, ");
INSERT INTO amk_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","weo Yohanesi mano webaptisi kaiwasa foi mani, mandoni dino yuaisi we webaptisi kaiwasa tonana ne? Allai ete inontarai nunei manei e?” ");
INSERT INTO amk_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Mano ewenunggamiai we imami fosa tuti mano ewefoniai we Yahudi fosa emadu kaririai wawerasa eteyo, “Masino tateyo, ‘Allai dino yuaisi we niari finana ne,’ nana mani ambori dei we tata aha ma deyo, ‘Tonana mani, we fianie wiro meroaso Yohanesi kahai nina?’ ");
INSERT INTO amk_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Wape tateyo, ‘Inontarai batang manei andino yuaisi ne,’ nana mani ambori kaiwasa fuba eroaso kaiwo medura fo tutu etohong kariria fosa, eru kamieio tata ki. Weo ea eroasoaifa weo Yohanesi mani nabi manei dine.” ");
INSERT INTO amk_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ampafe eroa we Yesusi eteyo eserawawerahai, mantei dino yuaisi fo. ");
INSERT INTO amk_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ainanaya Yesusi medu wesa deyo, “Tonana mani yau kontai wiro yeikaririai we mea kaha weo mantei dino yuai yau we inari fi bitoya nini faini.” ");
INSERT INTO amk_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Yesusi deiririai we kaiwasa fuba fianduhi nana foi fiyiwansoai nini, deyo, “Inontarai manei sanang ne romi angguri bei, sanamia kiaia, dohoni inontarai manea ewaitawani, ambori romifoi wetarai mani, taraifoi etatori mai sa ki. Ainanaya mano ne romi foi dontai to nu siai, tutu awa niai waroi na wanai. ");
INSERT INTO amk_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Tete rabuang bo romifoi wetarai fo, mano ne romifoi demi ne mangfata manei dontaia weo kia ne atorafo ria mano ewaitawang ne romifoi fosa. Manamo mano eru romifoi sa etafu mangfatafoi, eboia denteng kaha tuti etatari daraberahi na warang arora aha. ");
INSERT INTO amk_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ainanaya mano ne romi foi demi nari ne mangfata manei siai nariai aha, manamo mangfata nani kontaio eboia tafai kiari, eteikanggani ne woria denteng kahaia, mayeai etemi daraberahi warang arora nariai aha. ");
INSERT INTO amk_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Mayeai mano ne romi foi demi nari mangfata mano mantoru foi aha. Manamo mangfatafoi da wa, eboi, toyari ne ahao tafai kiari, eruti esoi to fino romi dereung boriei fo ariei wia nayai. ");
INSERT INTO amk_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ainanaya mano ne romi foi deyo, ‘Fianai aino inari aha ne? O! Tonana mani yemi nehu kaisung teraio enehuwawuti neia. Weo i da wa mani, tarahai esomi wei rai.’ ");
INSERT INTO amk_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Manamo we eru romifoi sa ewati ne kaisungfoi we da ma fo nanai, emadu wawerasa eteyo, ‘Ne kaisung ambori sobu tamang fi minohi tutira fe andinini, ampafe tamunia mireha weruaia, ambori fianai aino tamang minohi tutira fo taha we tata.’ ");
INSERT INTO amk_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Etafuria tuti efafari to boriai weru romifoi awariai emuni nayai.” Ainanaya Yesusi bera kaiwasafoi aha deyo, “Tofino mano ne romi foi, fifiani aino ambori dohonai we mano eru romifoi sa fo? ");
INSERT INTO amk_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Todoni kontaio ambori daraberahi ma tuti miung mano yoasosa we eru ne romifoi sa ki, tuti dohong romifoi we inontarai siai manea aha we ewaitawani ki.” Kaiwasafosa etarami kaiwo Yesusi medura fo nanai, emadu wei aha eteyo, “Todoni kontaio nana fanai!” weo ewaitawanai weo Yesusi deinawiai we ene tarai kariri inontarai ewaitawang romi angguri fosa. ");
INSERT INTO amk_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Yesusi seitesa akawuru wo medu wesa deyo, “Tonana mani Sengnei Ne Kaiwo arawang bonini mani weneung todoni? Amani: ‘Kamieio mano enari munu nesa ehabioi fi, andi wekamiei reantenang we etang kamieifoi doa sauwi ampa.’ ");
INSERT INTO amk_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Inontarai etawai na kamiei nani mani, eworu ki, tuti mantei dino kamiei nani sau kangguni mani ambori yoyaria wenukahai ki.” ");
INSERT INTO amk_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Mantaunau Kaiwo Musai soi fo tutu imami baba fosa, ewaitawanai we Yesusi ne fiyiwansoai medura fo reng wesa kariri todoni eteiayari we Mananu Mampariri foi fo. Ampafe etohong we etafuri na kutu nanai kontai, manamo ematai kaiwasa bitoya foi weo kaiwasafoi eparaise na fi Yesusi meduraia fo. ");
INSERT INTO amk_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ampafe esera we rahida mai we etafuri. Ebaio inontarai manea, ambori enari parari weinontaraio etohong kariri Sengnei ne Kaiwofo, kontaio etemi inontarai nanisa eweanggari Yesusi na fi etutang wea fo. Ambori Yesusi yoa medu fi sara kaiwoariri na parenta Roma foi mani, etafuri na ne kaiwo nanai, tutu ehari to inontarai mano wegubernuri, na parenta Roma foi na katai nani, we i mani wemambiriu weo kiutu aiboi. ");
INSERT INTO amk_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ampafe inontaraio esobu fiembaitafo emadu we Yesusi eteyo, “Dai Mantaunaune waune, amewaitawanai weo kaiwoariri fuba modurai tutu bounau wai nanai wetarai. Amewaitawanai kontai we bounau na mai kariri fianai aino Seng Allai medurai we inontarainesa fo tuti wiro womi we mano ewewonomi fosa kaha fefe. ");
INSERT INTO amk_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ampafe kariri tane hukumifoi, mesi we tabai pajaki weo Mananu Kaisari ete bireri e?” ");
INSERT INTO amk_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Manamo Yesusi deitawang ene anggarifoi, ampafe medu deyo, ");
INSERT INTO amk_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Meteinawiai we yau doi mebai pajaki nai wai. Mandoni dino yabani na doi finina, tuti mandoni dino wonongfe watai nai ne?” Eroa wei eteyo, “Mananu Kaisari.” ");
INSERT INTO amk_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Yesusi medu wesa aha deyo, “Tonana mani metohonai we Mananu Kaisari fifiani aino Kaisari neng fo, tuti we Allai fifiani aino Allai neng fo.” ");
INSERT INTO amk_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Tuti na inontarai bitoya euremireafo, esobu obu fi sarawai kuteai ria Yesusi kaha. Ampafe enemboru terai mae epapuhung paria we ne kaiwofo. ");
INSERT INTO amk_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Inontarai maneiru tea na inontarai eweSaduki fosa era we Yesusi ma. Ea mani inontarai Yahudi saine, wape eroasoai we inontarai emarareha nesa wiro esuwi ahang kaha. ");
INSERT INTO amk_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Era wa weo etutang berahi eteyo, “Dai Mantaunaune waune, nabi Musai soi kaiwo ninai we tata, soi deyo, ‘Mang manei rirau wape sobu arikang kaharai mae mireha, nana mani ne tahatuifoi dau ne wiwingfoi aha, ambori dohong arikang we mano mireha nani ne ririafoi aha.’ ");
INSERT INTO amk_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ametaterai weo mambetahatui eweitu, mano fuba foi riraua, wape wiro une arikang kaharai mae mangfoi mireha weru wiwingfoia. ");
INSERT INTO amk_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Mayeai mano suari foi dau ne wiwingfoi aha, manamo wiro une arikang kaharai mae mangfoi mireha kontai. ");
INSERT INTO amk_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ne tonanane, we ne tahatui mano sua foi, paria sobu mano fui pari foi kontai. Ea kiai erau wiwingfoi wape ene arikang kaharai mae emararehara. ");
INSERT INTO amk_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ne fuiai pari fo wiwingfoi kontai mirehara. ");
INSERT INTO amk_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ampefe na rahida mansuwi-suwi foi mani, na mambetahatui eweitu nanisa, mantei dino ne wiwingfoi ne? Weo mambetahatui eweitu fosa erau ruhi wiwingfoi fefe.” ");
INSERT INTO amk_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesusi yoa wesa deyo, “Inontarai na nunei ninisa erirau, ");
INSERT INTO amk_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","wape inontarai eroasoai donio emasi na Allai arongreafo fosa esuwi na marareha rorong foi tutu eminohi na rabuang bo da aha ma wani faini mani, wiro erirau ahang kaha. ");
INSERT INTO amk_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ene tarai toyario wewai, tutu wiro emarareha ahang kaha. Ea mani Seng Allai ne arikang disa, weo Allai duwisa na marareha rorong foi fefe. ");
INSERT INTO amk_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Musai mantauni medurai tatarami paraifa weo inontarai emarareha nesa ambori esuwi aha ki. Na kaiwo soi karirio ai yafui denggararu foi fo, i sahu Sengnei we Allai Abrahami, Allai Isaki, tutu Allai Yakupi. ");
INSERT INTO amk_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Tonana mani, Seng Allai nani mani wiro Seng we inontarai emarareha kaha, mae i mani Seng we inontarai etarang, tuti wiro inontarai emarareha fo saino esomi wei fo kaha, mae mano etarang fosa, ansaino esomi wei ne. Nanai deinawiai we Abrahami sitoru etarang aha na Waidani ampa. Weo we Allai, inontarainei kiai etarang, na nunei kontai na rorafaisi.” ");
INSERT INTO amk_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Mantaunau Kaiwo Musai soi fo maneiru teai eteyo, “Daie, nemu kaiwo modura wa mahikai paria!” ");
INSERT INTO amk_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ampafe wiro ewemang we etutang bera Yesusi we fieai ahang kaha. ");
INSERT INTO amk_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Yesusi dutang berahai wesa deyo, “Todoni e, inontarai eteyoai we Mananu Mampariri nei mani Dauti ne Kaisung dine? ");
INSERT INTO amk_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Weo Dauti mantauni soi na bukuo Masmuri deyo, ‘Seng Allai medu weo nehu Sengnei deyo, “Munohi na warahu domoya nei, ");
INSERT INTO amk_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","pariao iwedaya nemu aitetanesa taha tawansa kiai na awemuwai.” ’ ");
INSERT INTO amk_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ampafe Dauti mantauni sahu Mananu Mampariri foi we ne Sengfoi tonana mani, todonie i mani weriria terai na Dauti ma nina? Mae nanai deinawiai we Sengno Mampariri foi dedai sewa Mananu Dauti tuti ne riria tera fo ne.” ");
INSERT INTO amk_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Kaiwasafoi etaramio Yesusi medufo tonanai mae, i medu we ne inontarai erariati fosa aha deyo, ");
INSERT INTO amk_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Metanansiau we mantaunauo Kaiwo Musai soi fosa. Ea mani emirising we esansung ansung dewariroi, era tuturai na kaiwasa bitoya foi euremireafo, toyari na kondirora, ambori kaiwasa bitoya nanai esomi wesa. Emirising we etoa na katai mahikai na munu agama Yahudi fo rorong tutu na muniara bei mani, emirising we etiri katai mahikai na fong fo we eminohi nayai. ");
INSERT INTO amk_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ea epampamu wiwinafosa weo eha fi eminohi tutura fo, tuti ewenadi mani ene nadifoi dewariroi, ambori kaiwasa bitoya fosa etatosa we inontarai ebeng disa. Inontarai nanisa aiboi esobuai na Sempaisi fo mani maraba pari sewa rai.” ");
INSERT INTO amk_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Na Sempaisi ne Munufoi rorongfoi, Yesusi deti inontaraio ene ra bitoya fosa etohong doi to kataio efanduhi doi we Sempaisi nai foi. ");
INSERT INTO amk_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Yesusi deti wiwina ne pari fi manei kontai, kia ne doi seni boru, dohong suru na buruao efanduhi doi nai foi. ");
INSERT INTO amk_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ainanaya Yesusi medu deyo, “Tarai, yeisaharai we mea mau yeyo, wiwina nini faini fi dohonai we Sempaisi fo fuba sewa kaiwasa fuba wei foi kiai. ");
INSERT INTO amk_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Weo ea kiai etohonai na ene ra bitoya foi, wape wiwinanei ne pari fi tonanai ki, wape dohong doi kutu wiatai we wiori fidang naya fo awa kiai.” ");
INSERT INTO amk_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yesusi ne inontarai manea emadu kaririai we Allai ne Munufoi wedentengfo, emarandini na kamiai marandinaio mehikai tutu na fianggengno kaiwasa etohonai we Seng Allai fo. ");
INSERT INTO amk_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Ainanaya Yesusi medu wesa deyo, “Ne rahidafe naya ne, weo fi mewatioai ninai kai, ambori inontarai boriai etotawi, ampafe misuhia kiai ki, wiro kamiei boyari kontaio wiro doa na ne katai doa nai foi ahang kahai ki.” ");
INSERT INTO amk_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Yesusi ne inontarai erariati fosa etarami ne kaiwofe nanisa, eberahai aha eteyo, “Dai Mantaunaune waune, kidoni wori fi antanafa modurai nanai kawariai ki, tuti finanaifa kawaria mani ne fiainawiafo todoni?” ");
INSERT INTO amk_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Yesusi deyo, “Metanansiau weduarai ambori dohona inontarai etatofa mea fe. Weo inontarai bitoya ambori era ma eteyo emadu we mea na wonohune tuti eteyo, ‘Mananu Mampariri metamang wei nei di yau. Nehu rahida arera fe mai ampa doni ira kaririai ma nina!’ Dohonao meroaso ene kaiwofo tutu meraria sa fe. ");
INSERT INTO amk_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Kontaio metarami kaiwo we kaiwasa enemirorong boyari kahai tutu emamuna wawerasa mani, dohonao mematai fe. Ne tonanane todoni kontaio kawariai akawuru wo. Wape nanai wiro deinawiai we nunei werea nayai finana kaha.” ");
INSERT INTO amk_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ainanaya Yesusi medu ne kaiwofo pampang deyo, “Parentafei ambori memuna we parentafei ki, tuti mananu manei ambori memuna we mananu siai manei ki. ");
INSERT INTO amk_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Na doni kontaio ambori mundiai beba foi fio nai ki, kahari tutu fimaninang ming ki. Ambori na rorafaisi, fi fuba mantaungno dohong kaiwasafoi mitaia mirareha foi ambori atioi ki. ");
INSERT INTO amk_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Wape wiro fifuba nani kiawaria kaharai mae, mea ambori inontarai siai erutawang mea, tutu enari kanggani mea ki. Etafu mea, eha mea to munu agama Yahudi fo ambori etutang wawera mea, tutu esoa mea to aitamu rorong fo. Kontaio ambori inontarai eha mea tono mananufosa, tutu mano ewewafonia fosa earomireafo, weo etutang bera mea tutu enari kanggani mea nai ki. Weo meroaso yau tuti meraria yau fefe. ");
INSERT INTO amk_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Nanaifa mani, rabuang mahikai we mea weo metairiri Kaiwo Mahikai na Allai fo finanai. ");
INSERT INTO amk_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Dohonao mearomikuayai we kaiwo fianai aino ambori memadura fo fe, mae menemitawanai. ");
INSERT INTO amk_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Weo imeiri yauno ambori yohonai fa we mea, kaiwoariri fianai aino memadura fo tutu sewaifo we mea, ampafe inontarai manei kontai na mene aitetafosa wiro esawa tutu esahu fora kaiwo memadurai nana kaha. ");
INSERT INTO amk_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Mea ambori mene wawafosa, mene terafosa, tutu mene maniwowirifosa, etawayang mea to mene aitetafosa ki. Na mea, manea ambori emunsa ki. ");
INSERT INTO amk_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Kaiwasanesa kiai ambori enemirireu mea weo meraria yau fefe. ");
INSERT INTO amk_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Tonanai ki, wape menumirandaung rowei kontaio wiro niai kaha. ");
INSERT INTO amk_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Wape mehikatawanaia mutu tuti metawang mea mani, ambori mesobu ne maifo ki.” ");
INSERT INTO amk_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Mewati Yerusalemi weo rai mamuna fea etoa wariria mani, mewaitawanai weo bendari nanai waroi ahang kahai mae ambori emeiria wioru ki. ");
INSERT INTO amk_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Na rahida bonani mani inontarai enayai na Yudea fosa todoni kontaio ewawu ahera, emito to katai weuai fo we etadiwa nayai. Mano enai na bendari Yerusalemi rorong fosa, todoni kontaio emito weru bendarifoi, tutu mano enai boriei weru bendarifoi, wiro era afui fanai. ");
INSERT INTO amk_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Weo rahida nanaifa mani, rahidao Sempaisi su aiboifo we Yerusalemi finanai, ambori mai kariri fifianai aino wa na Sempaisi ne Kaiwofia fo. ");
INSERT INTO amk_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Rahida nana fo, rahida karira paria we wiwinsanaifosa tuti wiwingno etinsui ui, weo nana mani ewawu ahera kaha. Nu bonini ambori sodai ne dadira fuba pari fo, tutu Sempaisi yu aiboio kaiwasa nini. ");
INSERT INTO amk_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Manea ambori emunsa na fimamuna, manea kontai ambori etafusa ehasa we inontaraio aitamu to nu waroi siai, tutu inontarai Yahudi kaha fosa ambori eru bendari Yerusalemi paria rahida Sempaisi dohonai wesara fo kai kaririaia.” ");
INSERT INTO amk_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Ambori na wofaisi, embaifaisi, tutu awahafaisa, ambori ati fiainawiafeai nai ki. Na nunei kaiwasanei kiai ambori ematai tutu enemirorong fituayai we dobarai pinang mantaung wiro atioi na wea kaharai, dohong rawanangrausi nikuayai paria. ");
INSERT INTO amk_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Inontarai ambori emataia emarareha weo fifianai aino ambori kiawariai sentenang na nunei ne, weo fi wemambiriu na rorafaisi ambori dari babiaini ki. ");
INSERT INTO amk_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Na rahida bonani faini dino atio Kaisung Inontarai nei, ambori watioi we da na kafafefo na rorafaisi meu, ne tapapafo fuba paria tuti ne sambewaraio dedai fo fiabai. ");
INSERT INTO amk_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Finanai de kawariafo mani, metoabari mea tutu meruai meuremiwa, weo katu mani mea ambori mesobu ne faririfo.” ");
INSERT INTO amk_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ainanaya Yesusi deiriri fiyiwansoai nini aha deyo, “Meuremifo nai na ai urung tutu ai siai wei fo. ");
INSERT INTO amk_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Aifo wedahami, rerorifoi kiawawariai aha mani, nana mani fiainawiaio katu wo wemunudang ki. Ampafe mewati finanai, mewaitawanai weo na katai bonini, nana mani rerai weo wemunudang finanai. ");
INSERT INTO amk_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Tonanai kontai, mewatio fiainawiai kiawawariaifa na rorafaisi mani, mewaitawanaifa weo rerai we Seng Allai da ma we wemananu finanai. ");
INSERT INTO amk_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Tarai, imadurai we mea mau yeyo, inontarai na rabuang boninisa wiro emarareharao ehai kaharai mae finanai kawariai kawurua. ");
INSERT INTO amk_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Rorafaisi tuti nunei niai rai, wape nehu Kaiwone watai wenumainu.” ");
INSERT INTO amk_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Mewaitawang mene taraiwai, dohonao meuremiwa karerai we metohong muniara tutu metunung ye fe, ete menemitituai karerai weo meminohi toa wau tutu fi meneni wausi fe. Weo finanai wedaya mea ambori wiro metohong kariri ne maifo kaha. Weo mene tarai karira tonanaifa mani, na rahida bonani mani memainenang kaha, tuti mesoi mea paria. ");
INSERT INTO amk_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Weo rahida bonani mani, kaiwasanei na nunei kiai ewatioai. ");
INSERT INTO amk_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Mewaitawang weduarai tutu mewenadi we Sempaisi pampang, ambori mesobu mambiriu we metawang mea na ne dadirao ambori mesobua fo na mai. Ambori mea kontaio memai na Kaisung Inontarai nei arongreafo.” ");
INSERT INTO amk_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Na rahidafo mani Yesusi deunau na Allai ne Munufoi, mae diru mani da to Yerusalemi boriaifo, da to wiwoi Saituni we niai nayai. ");
INSERT INTO amk_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Kamiai neungne, kaiwasafoi da to Allai ne Munufoi, weo etaramididauo Yesusi we deunaufo. ");
INSERT INTO amk_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Rahida fubao Inontarai Yahudi etang roti weragi kahai, esahui we rahida Paska, kefang we etohonsuari. ");
INSERT INTO amk_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Imami baba fosa tutu mantaunau Kaiwo Musai soi fosa, esera we emung Yesusi na mamunggasai, weo ematai kaiwasa bitoya foi fefe. ");
INSERT INTO amk_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Mayeai Saminseni sensoni Yudasi mano esahui kontai we Iskarioti foi, i mani Yesusi ne inontarai ewesuraya mandu fo manei dine. ");
INSERT INTO amk_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ampafe donio Yudasi da wa medu ria imami baba fosa tutu mano ewenungkamiei we ewaitawang Sempaisi ne Munufoi, kariri todoni i dewayang Yesusi wesa fo. ");
INSERT INTO amk_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Etaramioai nanai efaraise paria tutu etarerai we ambori etohong doi wei ki. ");
INSERT INTO amk_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Yudasi kontaio yoa we fi eteoa fo, tutu sera we rahida mai we dewayang Yesusi wesa na mamunggasai, wiro manei deitawana kaha. ");
INSERT INTO amk_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Rahida fuba Yahudio esahui we rahida Roti Weragi Kaha, ne diru neung mai we etohonsuari, tutu domba we fiang Paska foi muni wekorbani. ");
INSERT INTO amk_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ampafe Yesusi medu we Petrusi tutu Yohanesi deyo, “Mura wa mumainenang fiang Paska we tata.” ");
INSERT INTO amk_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ainanaya ubera Yesusi aha ureyo, “Na katai bodoni dino enemurorong niai nai we aumainenamai nai ne?” ");
INSERT INTO amk_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yesusi yoa deyo, “Mutarami ma! Mura wa musuai bendarifoi mani, muwatio inontarai mang manei, kia babeu bei, soni mereha kawuru nai, da to munu bei. Mura ria wenani to munufoia, ");
INSERT INTO amk_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","mumadu we mano ne munu foi mureyo, ‘Mantaunaufoi deyo, “Rorong bodoni dino yau tutu nehu inontarai eraria yau nesa ametang fiang Paska nai ne?” ’ ");
INSERT INTO amk_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Inontarai nani ambori deinawi rorong fiebai bei na yai fo we muru. Rorong nani meinenang ampa. Mumainenang fiang Paska na nanai we tata.” ");
INSERT INTO amk_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Ainanaya Petrusi tutu Yohanesi ura wa, mayeai usobu fi Yesusi deyoa fo kai na mai. Urufo umainenangno fiang Paska foi. ");
INSERT INTO amk_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Diru neungfo mai we etang fiang Paska foi, Yesusi minohi ria ne rasulifosa na katai etampi nai foi. ");
INSERT INTO amk_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Ainanaya Yesusi medu wesa deyo, “Wiro isodai ne dadirafo kaharai mae, yohong weai paria we yang fiang Paska nini ria mea! ");
INSERT INTO amk_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Meroasoaifa! Weo yang fiang Paska nini ahang kahai pariao Allai kia ne kaiwasafo esuai to ne Mananu rorong fo ki. Nana mani fiang Paska ne dotu wea fo mai kaririaia finana.” ");
INSERT INTO amk_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ainanaya Yesusi yuai kibi angguri foi, dutang Sempaisi dohong mahikai we Allai, mayeai medu deyo, “Meha anggurinei metatori, ");
INSERT INTO amk_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","weo mewaitawanai, na ninai to fona mani wiro yunung angguri nini ahang kahai pariao Allai ne Mananu Rorong fo atioi ki.” ");
INSERT INTO amk_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Mayeai Yesusi kia rotifoi, dutang Sempaisi dohong mahikai wei, fioabau rotifo na warangfo, mayeai dohonai wesa tutu medu deyo, “Nehu taraifi dinini. Nehu taraio yohoni we mea weo ifariri mea nai fi dinini. Menari kariri fininai we mearomio yau.” ");
INSERT INTO amk_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Etampi kaia, dohong nofi angguri foi wesa aha deyo, “Angguri nini mani Allai ne Kaiwo Arerai waworuo tebuhirai na nehu rikanei, rikao tiwowu we feriri mea. ");
INSERT INTO amk_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Wape mewati! Inontaraio dewayang yau fi minohi na ninai kontai ria yau ne! ");
INSERT INTO amk_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Kaisung Inontarai nei anture mireha rai, kariri Allai meduraia fo, wape mano dewayani foi mani sobu ne karirafo ki.” ");
INSERT INTO amk_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ainanaya etutang wawerasa, weo mantei na ea andino niari tonanane. ");
INSERT INTO amk_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Yesusi ne inontarai ewesuraya mandu fosa esawasa we mantei dino esahui we fiebai wesa fo. ");
INSERT INTO amk_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Yesusi medu wesa deyo, “Yahudi kaha fosa, amani kaiwasao etaroang Allai kaha fosa, ene mananufosa eru ene raifosa na kaiwo tapapa. Tonanai wape mano ewenungkamiei nanisa esahusa we mano etaba wedua raifoi. ");
INSERT INTO amk_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Wape mea mani wiro tonana fanai. Mae mantei dino fiebai we mea mani todoni kontaio niariria ketui, tutu mano wenungkamiei foi mani todoni kontaio ne tarai toyario mangfata. ");
INSERT INTO amk_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Mantei dino fiebai sewa ne, mano minohi dampi na mejafoini ete, mano wesarawiri foini e? Tawaitawanai we mano minohi na mejafoi. Yau mesahu yau we mene fuba di yau, wape inai rahang meane iwemangfata. ");
INSERT INTO amk_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Na dadira rorong isodaira kawurua fo, menai ria yau pampang. ");
INSERT INTO amk_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Toyario Dai yuai yau we iwemananu, tonanai kontai, yau ambori iruai mea ambori mewemananu ki. ");
INSERT INTO amk_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ampafe mea ambori metampi metunung ria yau na rabuang bo iwemananu foi ki. Kontaio mea ambori meminohi na kadera suraya boru fo kontai ria Kaisung Inontarai nei, tuti mehutu kaiwo kariri riria Israelio suraya boru fo ki.” ");
INSERT INTO amk_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“Simone, Simoni wo, taramu ma! Saminseni sobu rang we ambori weanggari mea ki, toyario patibu iriri weru rerawafoi, ampafe ne dentengfoi iriri siai weru ne kerirafoi. ");
INSERT INTO amk_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Wape yutang Sempaisi we Simone wau kawuru ampa, ambori roasoawa dawohi fanai. Kontaio barabera wau kawuru we yau aha ma mani, wau kontai bohong kaiwo we nemu doroiwasa ambori eroasoai kontai.” ");
INSERT INTO amk_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Petrusi yoa deyo, “Sengne waune, yau imainenang we isuaio aitamu rorong fo tutu imereha ria wau!” ");
INSERT INTO amk_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesusi yoa deyo, “Petruse, imadurai we wau mau yeyo, diru nini wiro manggohei bibe kaharai mae, fofora yau webetoru kawurua, amani boyo wiro boroanso yau kaha.” ");
INSERT INTO amk_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Mayeai Yesusi medu wesa deyo, “Raminde yemi mea mera fa, yeo mea re wiro meha doi, ansung tutu sapatu siai kaha, nanaifa ne metari we fi metang ete ansung we mesansunai fa ne?” Eroa wei eteyo, “Bereri.” ");
INSERT INTO amk_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yesusi medu wesa aha deyo, “Wape ninaifa mani, mante wauno nemu doifea mani ka, ete aderi ansung bei mani kari, tutu mante wauno nemu pari sondu mani, bowayang nemu ansung siai fea weo wori sondu nai. ");
INSERT INTO amk_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Tonanai weo Sempaisi ne Kaiwo arawang bo dotu kariri yau toninanei: ‘I esahui kontai we inontaraio kerira.’ Kaiwo kariri yau ninai, ambori wetarai kaririai ki. Weo fifianai aino esoi na Sempaisi ne Kaiwo fi kariri yau ne, isodairai kawuru maninai.” ");
INSERT INTO amk_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Yesusi ne inontarai suraya mandu fosa emadu wei aha eteyo, “Sengne waune, boti sondu abururu ne.” Yesusi yoa wesa deyo, “Demoyarai.” ");
INSERT INTO amk_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Kariri rahida beirua fo, Yesusi deunaua kai na rahidafo, mae diru mani da to wiwoi Saituni. Ne inontarai ewesuraya mansiri fosa era riati. ");
INSERT INTO amk_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Era wa sobu wiwoifoia mani medu wesa deyo, “Mewenadi we Allai, ambori mesobu Saminseni ne anggarifo mani, wiro metawai metohong sasari kaha.” ");
INSERT INTO amk_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Mayeai da waroi werusa kuteaia, waroifo toyari o kamieia sau naya fo, ainanaya disang kapa awebuka, wenadi we Seng Allai, deyo, ");
INSERT INTO amk_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Daie, maya mani, kadeo ruai fi miraba fuba isodairi nini weru yau, wape wiro kariri nehu yawiane fanai, mae kariri nemu bawiawa terai.” ");
INSERT INTO amk_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Wewai na rorafaisi manei da wei ma, dohong mambiriu wei. ");
INSERT INTO amk_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Yesusi nuruainso sodai ne marabafo fuba beyari na enerorongfoi, ampafe wenadifo werorong mambiriu aha. Amayafoi ne tarai toyario rika fenanai, tipu na ne taraifoi, deda to kofafo aweu. ");
INSERT INTO amk_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yesusi wenadia kai, daraberahi we ne inontaraifosa aha. Da wa mani detisa we etenawa emarareha, weo euremimamong paria, weo enemirorongfoi fituaya fefe. ");
INSERT INTO amk_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Ainanaya medu wesa deyo, “Todonie metena ninai? Metoabari mea mewenadi we Sempaisi, ambori Saminseni weanggari mea fanai.” ");
INSERT INTO amk_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesusi doa medu we ne inontaraifosa tonanai mae, rai manea era wei ma. Rai nanisa Yesusi ne inontarai ewesuraya mandu fosa manei dino kiasa ma ne, wonong fino Yudasi. Mayeai Yudasi da we Yesusi awa ninahi. ");
INSERT INTO amk_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Wape Yesusi medu wei deyo, “Yudase, nemu nuna yau ninai ambori boyo bowayang Kaisung Inontarai nei e?” ");
INSERT INTO amk_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yesusi ne inontarai ewesuraya mansiri enai na nana fosa, ewati finanaifara fo, emadu eteyo, “Amemamuna wesa na fimamunara ne?” ");
INSERT INTO amk_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ainanaya inontarai manei na sa, fiating ne sondufoi doa awaru ferang kutu imami fuba ne woming manei tarandaungfoia fituayai. ");
INSERT INTO amk_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Wape Yesusi deyo, “Nana fanai!” Ainanaya waratawang imami ne womingfoi tarandaungfoi tutu niariri denteng aha. ");
INSERT INTO amk_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Mayeai Yesusi medu we imami baba fosa tutu rai mamuna ewaitawang wedua Allai ne Munufoi, kontaio mano ewenungkamiei we Yahudi fosa deyo, “Mewaitaraihio yau mani inontarai mamuna di yau e, doni mera tutu fimamuna ma weo metafu yau nina e? ");
INSERT INTO amk_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Rahida neungne inai ria mea na Allai ne Munufoi, wiro metafu yau kaha. Wape dirufo mai we metohona fininai, diruo Saminseni deinawi ne mambiriufo.” ");
INSERT INTO amk_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Raifosa etafu Yesusi tutu ehari to Kayafasi imami fuba pari foi ne munufoi. Petrusi da riatai na waroi. ");
INSERT INTO amk_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Na munu dereungfo, manea eminohi eharuru adia bei na nanai, ampafe Petrusi kontaio da wa minohi keruru adiafoi ria sa. ");
INSERT INTO amk_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Mangfata wiwing manei deti Petrusifo urengfo nai nai, deroang wei, ainanaya medu deyo, “Inontarai nini kontaio anta doa ria Yesusi na wanai.” ");
INSERT INTO amk_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Manamo Petrusi fefora deyo, “Wiwingwa wau, yau yeroanso sobu inontarai nani kahai arorawa.” ");
INSERT INTO amk_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Tourai aha mani inontarai manei siai deti Petrusi, ampafe medu deyo, “Wau kontai Yesusi ne inontarai manei di wau.” Manamo Petrusi yoa aha deyo, “Bereri, yau mani bereri.” ");
INSERT INTO amk_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Tarahio we araha ureng bei teai aha mani, inontarai manei siai aha medufo kika tawanai beyari deyo, “Antu inontarai nini, inontarai da ria Yesusi manei dine, weo i inontarai Galilea manei dine fefe.” ");
INSERT INTO amk_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Manamo Petrusi yoa wei deyo, “Fianai aino modura wa? Fi modurai nanai iserawa iru na wa amang wau we beyari!” Na tatofang kutu Petrusi medu nanai, manggoheifoi bibea. ");
INSERT INTO amk_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Yesusi fiobera ureng deti rarang Petrusi urengfo. Ainanaya Petrusi aro fianai aino Seng Yesusi medurai weia fo, deyo, “Diru nini aha rorong, wiro manggohei bibe kaharai mae, fofora yau webetoru kawurua.” ");
INSERT INTO amk_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ainanaya Petrusi dari weru katai nanai tutu saia wiro denteng ahang kaha. ");
INSERT INTO amk_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Inontaraio ewaitawang Yesusi fosa, emei kanggani tutu eboia tafai kiari. ");
INSERT INTO amk_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Etabung wedua urengfo ambori etutang berahi eteyo, “Hai! Boyo nabi di wau ampafe bafu weaifa, mantei na amea andino bioi wau ne?” ");
INSERT INTO amk_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Kaiwo oiberahai bitoya beyari eru esoai rufang Yesusi. ");
INSERT INTO amk_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Kameaia mani eha Yesusi to Majelisi Agama efanduhisara fosa. Ea mani mano eruaisa na mano ewenungkamiei we Yahudi fosa, imami baba fosa, tutu mantaunau Kaiwo Musai soi fosa. ");
INSERT INTO amk_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Etutang berahi eteyo, “Boi kaririaifa we amea, wau mani Mananu Mampariri di wau e?” Yesusi yoa wesa deyo, “Yeikaririai we mea kontaio wiro meroasoa kaha. ");
INSERT INTO amk_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Tutu yutang bera mea kontaio, wiro metei kariri fieai we yau kaha rai. ");
INSERT INTO amk_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Wape na ninai to fongna mani, Kaisung Inontarai nei ambori minohi na Seng Allai mano weMambiriu sewa pari foi eneung domoya fo ki.” ");
INSERT INTO amk_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ea kiai emadu wei eteyo, “Tonana mani, wau mani Allai ne Kaisung di wau e?” Yesusi yoa wesa aha deyo, “Yo! Tonanai kariri memaduwa.” ");
INSERT INTO amk_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ampafe emadu eteyo, “Kasau we tata ampa. Mandoni dino tatutani we medu kariri ne sarawafo aha ne? Weo tatarami terai na borong nengfi ampa.” ");
INSERT INTO amk_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Majelisi Yahudi fosa kiai eha Yesusi to Pilatusi, gubernorifoi aha. ");
INSERT INTO amk_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Na nanai etinggai Yesusi. Eteyo, “Amesobu inontarai nini deunau kaiwasa bitoya foi we ne karirafo. I deunau kaiwasa we wiro ebai pajaki we Mananu Kaisari fanai. Tuti i deyo, i mani Kristusi, Mananu dine.” ");
INSERT INTO amk_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ampafe Pilatusi dutang bera Yesusi deyo, “Taraie, wau weMananu we inontarai Yahudi fesa ne ne?” Yesusi yoa wei deyo, “Yo, tonanai kariri modurawa.” ");
INSERT INTO amk_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ainanaya Pilatusi medu we imami baba fosa tutu kaiwasa bitoya foi deyo, “Yutang bariria manamo isobu fi kuteai we dohong sarawa kaha.” ");
INSERT INTO amk_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Wape eafo etoabiainai eteyo, “Deunau kaiwasa fuba na Yudea fosa we enari ne karirafo. Reantenang mani deunau na Galilea, manamo ninaia mani paria sobu katai boninia ninai.” ");
INSERT INTO amk_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilatusi tarao kaiwofo, berasa aha deyo, “Ampafe inontarai nini mani, inontarai Galilea dine ne?” ");
INSERT INTO amk_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pilatusi taraoai ria sa we Yesusi mani na Galilea, kataio Mambaiseng Herodesi yu naia fo kontai, ainanaya Pilatusi demisa eha Yesusi we Herodesia. Teteo nana mani niai na Yerusalemi finanai. ");
INSERT INTO amk_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodesi deti Yesusi nanafo mirarising karira, weo waroia tarao Yesusi we fi fuba niariri foi, kontai dohong we detioi paria. Enetawanaifa weo ambori Yesusi niari fitantumafeai detioai ki. ");
INSERT INTO amk_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Aiwedaya mani Herodesi bera Yesusifo bitoya paria, manamo Yesusi wiro fioai borong kutea kahai arorawa. ");
INSERT INTO amk_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Imami baba fosa tutu mantaunau Kaiwo Musai soi fosa, era wa etoa kontai na nanai, tutu etinggai Yesusifo ehikatawanai beyari. ");
INSERT INTO amk_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodesi tutu ne rai mamuna fosa emei kanggani Yesusi tutu enemirireuwi, esansuni na ansungno we inontarai fuba, mayeai demisa ehari we Pilatusi aha. ");
INSERT INTO amk_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Herodesi tutu Pilatusi uru, raminde nana mani uweaiteta, manamo na rahida bonani kontaio uweboyari aha. ");
INSERT INTO amk_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilatusi fianduhi imami baba fosa, mano ewewafonia fosa, tutu kaiwasa na nana foi kiai, ");
INSERT INTO amk_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","medu wesa deyo, “Meha inontarai nini we yau ma tutu meteyo i deunau kaiwasa bitoya we ne karirafo. Na mearomireane iberahia tonanai, manamo isobu fi metinggairi wea ne kutea kahaia. ");
INSERT INTO amk_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodesi kontaio medu tonanai, weo i kontaio denatu Yesusi nani toninai we tata ma. Inontarai nini wiro niari fi sarawa feai weo ambori sodai aiboio marareha fo kaha. ");
INSERT INTO amk_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ampafe irubati teraia mayeai itawinia da wa.” ");
INSERT INTO amk_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Medu tonana weo rahida fuba Paskao inontarai Yahudi fosa etohonsuari, na defuina neungfo mani, Pilatusi deiai inontarai niai na aitamu fo manei, da to boriai we kaiwasa bitoya foi aha. ");
INSERT INTO amk_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Manamo kaiwasa fuba etoari na nana fosa ehuayai, esahu eteyo, “Muni weruai! Tawing Barabasi we amea!” ");
INSERT INTO amk_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabasi mani, etafuri etohoni niai na aitamu rorong fo weo i wedaya kaiwasa bitoya foi emamuna na bendarifoi. Kontai i miung inontarai. ");
INSERT INTO amk_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilatusi deo sawing Yesusi, ampafe medu we kaiwasa bitoya foi aha. ");
INSERT INTO amk_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Manamo kaiwasa bitoya foi ehuayai esahu mambiriu aha eteyo, “Pahui na aitabafoi! Pahui na aitabafoi!” ");
INSERT INTO amk_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ainanaya webetoru finanai Pilatusi medu wesa aha deyo, “Wape fisarawaio todoni fino niari ne? Yau wiro isobuai we dohong sarawaio ambori sobu aiboi marareha fo kaha! Ampafe yau irarubati terai, mae itawini da wa.” ");
INSERT INTO amk_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Manamo nana mani arahio ehubisa mantaung finanai, weo todoni kontaio Yesusi epahui na aitabafoi. Donio fi etohong wea fo Pilatusi dohong kaririai. ");
INSERT INTO amk_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","25","Ainanaya Pilatusi kiutu kaiwofo we Yesusi sobu aiboi marareha foi, kariri kaiwasa bitoya foi ene awiafo, tutu sawing Barabasi wesa kariri ene etohong wea fo. I mani inontaraio etafuria wiana aitamu rorong fo weo wedaya kaiwasa emamuna tutu ming inontarai. Ampafe Pilatusi dohongno Yesusi we ne rai mamuna fosa weo enari kanggani karirio fianai aino kaiwasafosa enemitituaita fo. ");
INSERT INTO amk_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ainanaya Yesusifo eharia. Na rang rabuang ehanggungno inontarai manei, arahio da na munuefeai de suai tono bendarifoi, wonong fino Simoni, inontarai Kirene dine. Erutawani etawi mae sodua aitabafoi da ria Yesusi na kurufuifo. ");
INSERT INTO amk_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Kaiwasa bitoya era ria Yesusi na kurufuifo. Na kaiwasa bitoya nani, wiwing maneiru teai era riatai kontai. Wiwing nanisa esaia etaidu we Yesusi. ");
INSERT INTO amk_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Manamo Yesusi deti berahi wesa, medu deyo, “Wiwing Yerusalemiwa meaine! Mesai yau fanai, mae mesai mene tarai bo meneng wai tutu mene arikangwasa. ");
INSERT INTO amk_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Weo rabuang bo inontarai emamuna we Yerusalemi, nani faini dino ambori da ma ki. Na rabuang bonani faini dino inontarai emadu eteyo, ‘Denteng sewa weo wiwingno eharawahio esobu arikang kaha fosa, tutu mano wiro earomi ui kaha fosa.’ ");
INSERT INTO amk_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Na rabuang bonani faini dino, ‘Inontarai ambori emadu we uaifo eteyo, “Tirutawang amea!” tutu we wiwoifo, “Biritawang amea!”’ ");
INSERT INTO amk_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Weo we ai darama nei, inontarai enari toninaia, nana mani ai memasa nei mani, waitawang enariri toa ne ahang kaha! Ete, we yau inontarai nehu pari sasari, wape emung yau, enari kanggani yau toninai. Nana mani we mea inontarai mewesasarine mea, mesobu aiboi fuba sewa paria!” ");
INSERT INTO amk_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Inontarai siai mandu kontai, inontarai umamuna suruine, eha suru kontai we emung surua umereha kontai ria Yesusi. ");
INSERT INTO amk_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Era wa sobu kataio esahui we Woming Nungkamiei (nana mani, esahui we Golgota dine), epahu Yesusi tutu inontarai mamuna fosuru nayai, manei na dowei, manei na domoya, Yesusi na rabuang. ");
INSERT INTO amk_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ainanaya Yesusi wenadi deyo, “Daie, waramuai ene sasarifoi! Weo eserawawera fifianai aino enari ne.” ");
INSERT INTO amk_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Rai mamuna fosa, ehabi onde we etato Yesusi ne ansungfoi mai sa. Kaiwasa etoari na nana esairi, mae mano ewenungkamiei we inontarai Yahudi fosa eteibera Yesusi eteyo, “I mani deyo feriri inontarai siai, tonana mani feriri bera mantauni to, tarai we i mani Mananu Mamparirio Allai diriri ma!” ");
INSERT INTO amk_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Rai mamuna fosa kontai eteiberahi. Era wa etohong angguri sisasa feai wei, ");
INSERT INTO amk_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","tutu emadu eteyo, “Wau inontarai Yahudi ene Mananu di wau mani, foriri bera mantaung waua!” ");
INSERT INTO amk_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Na aitaba Yesusi sau nai nungkamieifoi, esoi kaiwo ninai, Mananu Inontarai Yahudi Dinini. ");
INSERT INTO amk_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Inontarai mamunao epahu suru na nana fo suru, manei deibera Yesusi. I medu deyo, “Boe! Yeitarahi wau mani Mananu Mampariri di wau mae? Tonana mani foriri bera wau tutu auru kontai!” ");
INSERT INTO amk_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Manamo inontarai mamuna mano wei foi sua ne maniwowirifoi deyo, “Mutai Allai kaha e? Wau kontaio emung wau mureha kariri i. ");
INSERT INTO amk_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Manamo aiboi tusobua ne karirio fikarira fianai aino tunaria fo. Wape i mani, wiro dohong sarafiea kahai kontai.” ");
INSERT INTO amk_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ainanaya medu we Yesusi deyo, “Yesuse, aromuo yau, na rabuang bo ro wemananu ma foi!” ");
INSERT INTO amk_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Yesusi medu wei deyo, “Roasoaifa, rahida bonini wau ambori munohi ria yau na katai denteng foi ki.” ");
INSERT INTO amk_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Tarahio araha ureng suraya boru rahida rabuang batang, na tantuma kataifoi memantiti sentenang paria sobu araha ureng botoru, ");
INSERT INTO amk_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","weo wofaisi wiro sambewarai ahang kaha. Ireu aburung sau wetaba na Sempaisi ne Munufoi rorongfo miabu weberu. ");
INSERT INTO amk_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ainanaya Yesusi bibe mambiriu beyari deyo, “Daie! To waramu rorong wa mampui, itawing nuhuaninunei!” Medua kaifo, kiaharaia. ");
INSERT INTO amk_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Rai mamuna fosa ene mano wenungkamiei foi, deti finanai terai na urengreafo, fiai Allai, tuti medu deyo, “Tarai, inontarai nini mani, inontarai mesi dine!” ");
INSERT INTO amk_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Kaiwasa fubao da ma seiri Yesusi fo, ewatio fio dariai na nana fo, ea kiai etaraberasa to ene munufo aha na enemirorong fituayai. ");
INSERT INTO amk_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Tutu Yesusi ne inontaraifosa, kontai wiwingno era ria Yesusi na Galilea ma fosa, etoa na waroi ewati fi fuba nani kiai. ");
INSERT INTO amk_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Inontarai manei wonong fino Yusupi, i mani na bendari Arimatea na nu Yudea. I mani, inontarai enerorong denteng dine, kaiwasa esahu suari kontai, tutu inontaraio demang we rahida bo Allai ne Mananu rorong fo ambori atioi fo. I kontaio yuo wang Majelisi Agama fo, wape wiro yoa we kaiwo ne maniwowirifosa ehutua fo tuti fi kangganiaio enari we Yesusi fo kaha. ");
INSERT INTO amk_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Yusupi nini da wao dutang Pilatusi, ambori dohongno Yesusi ne taraifoi wei. ");
INSERT INTO amk_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Mayeai suo Yesusi ne taraifoi weru aitaba epahui nai foi, ainanaya sensani na ireuo lineni ne harga dedai. Mayeai i dohoni wiatai na fafo o mantauni dahi na wiwoio wekamiai, fafofoi wiro esarai manei nai kaharai. ");
INSERT INTO amk_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Rahida bonani mani rahida Jumati dine, tutu wofoi de sawai ampafe rerai we rahida Sabati foi. ");
INSERT INTO amk_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Wiwingno era ria Yesusi na Galilea ma fosa, era ria Yusupi tutu ewati fafofoi. Ewatioai kontai weo dohong Yesusi wiatai toa fo na kamirei fafo rorong foi. ");
INSERT INTO amk_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Mayeai etaraberasa aha, ainanaya emainenang fininsai burayang tuti maning niunsai mampori weo esariai na Yesusi ne taraifoi. Wo sawaia, nana mani rahida Sabati foi finana, ampafe efotourai weru fi enari fo, weo etohonsua kariri Sempaisi ne Hukumi Musai soi fo. ");
INSERT INTO amk_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Na rahida Minggufoi, kamiai kutung, wiwingfosa eha fininsai burayang tuti maning nunsai mampori emainenangna fo, era to fafofoi. ");
INSERT INTO amk_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Na fafofoi ewatioai we kamiei etadoiria wedua kamirei borongfo, dedoi weru kamireifoi anina. ");
INSERT INTO amk_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ainanaya esuai to fafo rorong foi afui, wape wiro ewatio Seng Yesusi ne taraifoi na nana kaha. ");
INSERT INTO amk_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Masio etoari na nanai fo tutu enemitituaitai paria mae, inontarai mandu, na tantuma mao uroa ruransa. Amani une ansungfo toyari kaiwewa fenanai. ");
INSERT INTO amk_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Wiwingfosa ematai karira, ainanaya esomi ao ewatai, mae inontarai mandu fo suru umadu wesa ureyo, “Todoni e, mesera we inontaraio darang nei na kataio inontarai emarareha fesa ninai? ");
INSERT INTO amk_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","I wiro wia na nina kaha, weo suwi ampa! Mearomio fifianai aino medurai we mea kawurua fo na rabuang bo niayai na Galileafoi, ");
INSERT INTO amk_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","deyo, ‘Kaisung Inontarai nei, etohoni to mano ewarami aipaya fosa ewarami rorong fo ki. Emuni sau na aitabafoi, tutu rahida bo botoru foi wori, ambori suwi aha ki.’ ” ");
INSERT INTO amk_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ainanaya wiwingfosa arahio earomio Yesusi ne kaiwoariri medurai kawurua fo. ");
INSERT INTO amk_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Etaraberasa weru fafofoi fo, etairiri karirio fifianai aino ewatioai kai fo we inontarai ewesuraya mansiri fosa tutu we inontarai siaio eraria Yesusi fosa. ");
INSERT INTO amk_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Wiwingno eteikariri fi fuba ewatioai nanai we Yesusi ne rasulifosa, amani; Maria Makdalenai, Yohanai tutu Yakobusi inangno Mariai, kontai wiwing siaio era riasa fosa. ");
INSERT INTO amk_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Manamo eroaso kaiwo wiwingfosa etairiria fo kaha, eteyo wiwingfosa emadu funomai. ");
INSERT INTO amk_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Wape Petrusi doa bariri mito to fafofoi. Suang mae deti kariri kamirei fafo foi afui, ainanaya detio ireuo ansang Yesusi naya fosuru, ansuruino uwatai tera ne. Petrusi kiri tapereng beyari, ainanaya daraberahi aha, mae enerorongfoini berahai beyari we fi fianai aino detioa fo na fafofoia. ");
INSERT INTO amk_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Na rahida bonani kontaio inontarai eraria Yesusi fosa, uwemandu ura to munue Emausi. Emausi mani, tarahio kiro suraya boyari terai na Yerusalemi. ");
INSERT INTO amk_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Na rang rorong fo umadu kariri Yesusi ne mararehafoi tuti fi fubao kawariai ampa. ");
INSERT INTO amk_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Ura umadu kaririai tutu usewa weai to nanai mae, Yesusi mantauni da ma da ria suru. ");
INSERT INTO amk_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Uwati Yesusi we da ria surufo manamo fieai sau wedua uremifo ampafe uraroansoi kaha. ");
INSERT INTO amk_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ainanaya Yesusi medu we suru deyo, “Mura murairiri fiani na rang finina?” Uroaukai mae uremi toung. ");
INSERT INTO amk_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ainanaya manei na suru wonong fino Keliopasi, fia Yesusi aha deyo, “Dai wau mani, tarahio inontarai waworu na katai nini di wau fe? Weo wau wiro boitawangno fi enari kawuru na Yerusalemia fo kaha e?” ");
INSERT INTO amk_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesusi berahai aha deyo, “Fifianai aine?” Uroa wei ureyo, “Fio enari we Yesusi, inontarai na Nazareti foi. I mani nabi dine, kaiwo medura fo tutu fi niari fo wemambiriu paria. I mani, mai na Allai urengreafo, kontai mai na inontarai euremirea ne. ");
INSERT INTO amk_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","21","Ameafo amenemitawanai paria weo, andino ambori feriri Yahudine tata weru tane aitetafosa. Wape imami baba fosa tutu mano ewenungkamiei we inontarai Yahudi ne tata fosa, etohoni we rai mamuna Roma fosa, ampafe etohong aiboi marareha wei. Ambori epahui sau na aitabafoi ao mirehara. Kontaio, rahida bonini mani rahida botorua finanai na ne mararehafoi. ");
INSERT INTO amk_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Kontaio wiwing maneiru teai na amea, etohong amea amesioi amea paria. Weo kameai kutung fa era to ne fafofoia, ");
INSERT INTO amk_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","wape wiro esobu inong marareha foi kaha. Ainanaya etaraberasa aha ma, eteyo, ‘Amewatio wewai mandu, umadu ureyo, Yesusi suwi ampa.’ ");
INSERT INTO amk_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ainanaya maneiru teai na amea era to fafofoia, awa mani esobuaifa karirio fi wiwingfosa emaduraia fo, mae wiro ewati Yesusi kaha.” ");
INSERT INTO amk_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ainanaya Yesusi medu we suru deyo, “Muru mani anture muserawawerahai paria. We fiani e wiro muroaso fi nabifosa etoi fo kaha nina? ");
INSERT INTO amk_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Weo tarai tofino, Mananu Mampariri foi sodai ne marabafo akawuru wo Seng Allai yuaisi dohongno ne sambewaraio dedai fo wei ki.” ");
INSERT INTO amk_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Mayeai Yesusi deisaharai we suru, fifianai aino esoi na Sempaisi ne Kaiwofo kiai kariri ne tarai bo neng foi fo, amani na fio Musai soi fo, tutu na fi nabifosa esoi fo. ");
INSERT INTO amk_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Tonanai mae itora kefangno munue itora wea foa. Yesusi niari toyario de da paria, ");
INSERT INTO amk_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","manamo urei weduari. Umadu wei ureyo, “Diru fi kefang ampa, katu mani manantiti fine, ampafe torena na ninai ki aha wo.” Ampafe Yesusi suai munufoi afui weo dena na nanai. ");
INSERT INTO amk_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Dirua mani, minohi we dampi ria suru na nanai. Ainanaya kia rotifo dutang Allai dohong mahikai wei, tuti fioabau rotifo na warangfo, dohonai we suru. ");
INSERT INTO amk_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Mayeai arahio uremifo tabau, uraroansoai we Yesusi dinani. Manamo na kutu nanai kontaio niai weru uremireafo anina. ");
INSERT INTO amk_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ainanaya umadu wawera suru ureyo, “Tarai! Antanafa na rangfoi ma fo, medu deisaha kaiwoariri na Sengne ne Kaiwofo we turu nana fo, tuenemirorong mirising weai paria.” ");
INSERT INTO amk_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Na kutu iyari nanai kontaio, uroa bari suru, urarabera suru usahera to Yerusalemi aha. Na nanai usobuai weo inong anatu ewesuraya mansiari fosa efanduhisa ria kaiwasa fuba wei foi kiai. ");
INSERT INTO amk_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Emadu eteyo, “Taraito! Sengnei anture suwi aha ma ne! I deinawi ne taraifoi we Simoni.” ");
INSERT INTO amk_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ainanaya Yesusi ne inontarai mandu arahio ura aha ma nansuru, urairiri karirio fifianai aino usobuaifa na rang rorong ura naia fo, kontai tofino uraroanso Yesusi na kutu fioabau rotifo we itorang fo. ");
INSERT INTO amk_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Eminohi esewa we fi ewatioai tutu etaramioai nanai mae, na tantuma Yesusi mantauni doa rahansa tutu medu deyo, “Mararebanafeai we mea.” ");
INSERT INTO amk_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Esioisa tutu ematai, weo ewaitarahio ewati romoaninu. ");
INSERT INTO amk_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Manamo Yesusi medu wesa deyo, “We fiani e, mematai ninai? We fiani e, menemirorongwai soriru ninai? ");
INSERT INTO amk_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Mewati warahune tutu awehune weo matatine. Mewaitawanai weo yau aranane. Mewarami kariri nehu tarainei, tutu mewati nariai, weo romoaninunei mani ne pari tarai tutu neina, toyari ne mewatioai na yau ninai.” ");
INSERT INTO amk_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Yesusi medu tonanai wesa mae deinawio warangfo tutu awengfo wesa. ");
INSERT INTO amk_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Kontaio kature eroasoa kahai, weo efaraise karerai tutu ehiri ewarami. Yesusi dutang berasa deyo, “Mene fiangfea e?” ");
INSERT INTO amk_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ampafe etohong diang ora tarai bei we Yesusi. ");
INSERT INTO amk_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Yesusi kia diangfo ainanaya dani na euremireafo. ");
INSERT INTO amk_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Mayeai medu wesa deyo, “Fio raminde inai ria mea mani, imadurai kawuru we meara fo aininai. Weo fifianai aino toi na fi Musai soi fo, nabifosa tutu na Masmuri kariri yau fo kawari kaririai nina.” ");
INSERT INTO amk_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Mayeai Yesusi fiai ene enemitituaitafo, weo ewaitawangno fianai aino Sengne ne Kaiwofo medura fo. ");
INSERT INTO amk_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Medu wesa deyo, “Na Sengnei ne Kaiwofo soi weo, Mananu Mampariri nei todoni kontaio sodai ne marabafo, tutu suwi na mararehafoi na rahida botoru foi. ");
INSERT INTO amk_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Kontaio na Mananu Mampariri nei yau wonohunei, todoni kontaio aiririai we kaiwasa fuba na nunei kiai weo etaraberasa weru ene sasarifoi, tutu weo Allai waraira sasari. Tutu kaiwo ninai aiririai na nunei sentenang, reantenang mani na Yerusalemi. ");
INSERT INTO amk_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Meaino mera metairiri kariri fi mewatioai ninaifa ne. ");
INSERT INTO amk_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Tutu mantaung yauno ambori yenatuai we mea fianai aino nehu Dai dererai kawurua fo. Wape mea metamang pampang na bendari nini pariao Sempaisi ne tapapafo bia na rorafaisi meu niai woru mea.” ");
INSERT INTO amk_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Mayeai Yesusi kiasa era to boriai weru bendarifoi, paria kefang we munue Betania. Na nanai yuai warangfo mioansa. ");
INSERT INTO amk_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Niari fi nanai mae dau to rorafaisi awao ketai werusara. ");
INSERT INTO amk_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ea esomia emarareha wei, mayeai etaraberasa to Yerusalemi na enemirorong mirising paria, ");
INSERT INTO amk_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","tutu efiai Sempaisi pampang na Allai ne Munufo. ");
INSERT INTO amk_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Na reantenang pari nunei kaharai mae, Kaiwofoi niayai kawurua. Kaiwo nani niayai kawuru ria Allai ampa, tuti I mani Allai dine. ");
INSERT INTO amk_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Na reantenang pari fo niayai kontai ria Allai. ");
INSERT INTO amk_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Fi fuba nini kiai, Allai niariri na Kaiwofoi nani, tuti na fi fuba niayai kiai nini, boyari kontai wiro Allai niariri boriei weru I kaha. ");
INSERT INTO amk_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Kaiwofoi mani, ansengnei weneung nai, tuti ansengfoi dohong Sambewarafo we inontarainesa. ");
INSERT INTO amk_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Sambewarai nani dansairai na mamantitifo, tuti mamantitifoi wiro niariri fefe kaha. ");
INSERT INTO amk_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Inontarai Allai demi foi manei da ma, wonong fino Yohanesi. ");
INSERT INTO amk_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","I da ma we deiriri kariri fianai aino deti teri na urengfo kariri Sambewarai nani, ambori na i kaiwasanei kiai taraoai tuti yoasoai. ");
INSERT INTO amk_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Mantauni wiro Sambewarafoi dine kaha, mae manta da ma we deiriri kariri te Sambewarai nani. ");
INSERT INTO amk_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Kaiwofoi mani Sambewarai taraio sambewa inontarainesa kiai enemirorongfoi dine tuti da to nunei ma finanai. ");
INSERT INTO amk_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","I niayai na nunei, tuti andino Allai niari nunei nai ne, wape nunei deroansoi kaha. ");
INSERT INTO amk_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Da to ne kataifoi terai ma, wape ne inontaraifosa etamang wei kaha. ");
INSERT INTO amk_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Tonanai ki, wape we mandoni saino etamang wei tuti eroaso wonongfo mani, yuaisa esobu mambiriu we ahusa we Allai ne arikang disa. ");
INSERT INTO amk_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Amani arikangno wiro etaubau enumi na inontaraine eriraufo kaha tuti kariri ene etawiafo kaha, ete kariri mang manei ne dawiai we ambori sobu arikangfo kaha, mae etaubau enumi we Allai ne arikang disa na Allai mantauni terai. ");
INSERT INTO amk_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Kaiwofoi weinontarai batang ampa tuti niayai rahang tata. Amewatio ne sambewaraio dedai fo ampa, sambewarai dedaio Allai dohonai wei we ne Kaisung Mansiari dine fo. Tuti I mani Kaisungno da na Dai Allai na ne wetaraifo tuti ne bengno dohonai arora fo. ");
INSERT INTO amk_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Yohanesi da ma we deisaha kariri Kaiwofoi we mandoni dine fo we tata tuti sahu deyo, “Inontaraio imadu kariri yeyo, ‘Ambori inontarai manei datua yau aha ma ki, wape inontarai nani fiabai sewa yau, we wiro ira ma kaharai mae, I mani niayai kawuru ampa.’ Inontarai imadu kariri tonana foi andinini.” ");
INSERT INTO amk_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Weo I mani dohong ne bengfo fuba sewa ampa, tuti na ne bengno fuba sewa nanai, mioang tata pampang. ");
INSERT INTO amk_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Weo Sempaisi ne Hukumifoi tasobuai ria Musai. Wape Allai ne beng sewa fo tuti ne wetaraifo tasobuai ria Yesus Kristusi. ");
INSERT INTO amk_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Mandoni kontaio wiro deti Allai na ea kaha rai, mae Dai ne Kaisung Mansiario ne tarai kariri I tuti weboyari riati foi terai. Meiri andino deinawi Dai Allai we tata ne. ");
INSERT INTO amk_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Nini mani, kaiwo taraio Yohanesi medu kariri mantauni tuti kariri Yesusi fo na rabuang bo mano ewenunggamiei we Yahudi fosa na Yerusalemi etemi imami manea tuti inontarai Lewi manea, era we Yohanesia we etutang berahi eteyo, “Wau mani mandoni di wau?” ");
INSERT INTO amk_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Yohanesi feforawa kahai, mae deikariri parai wesa deyo, “Yau mani Mananu Mampariri foi di yau kaha.” ");
INSERT INTO amk_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ainanaya etutang berahi aha eteyo, “Tonana mani, mandoni di wau? Eliai di wau e?” Manamo medu wesa deyo, “Bereri.” Mayeai etutani aha eteyo, “Ampafe mandoni di wau? Nabio ambori da ma foi di wau e?” Yohanesi yoa wesa aha deyo, “Bereri.” ");
INSERT INTO amk_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ampafe etutang berahi nariai aha eteyo, “Tonana mani boikaririai we amea we mandoni di wau. Weo todoni kontaio ameteisaharai we mano etemi amea amera ma fosa, we wau mani mandoni di wau fo. Fianai aino modurai kariri mantaung wau ne?” ");
INSERT INTO amk_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ampafe Yohanesi yoa wesa na kaiwo nabi Yesayai fafongfa medura fo deyo, “Yau mani, mano isahu pampang na katai wekamamiei minano foi yeyo, ‘Memainenang rang beng feai we Sempaisi, Tuti menaria mimoya wei.’ ” ");
INSERT INTO amk_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Inontarai mano era ma nanisa mani, inontarai eweFarisi maneiru teai kontai ampafe etutani eteyo, ");
INSERT INTO amk_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Masino wau mani Mananu Mampariri foi di wau kaha, Eliai di wau kaha, tuti Nabifoi di wau kaha, tonana mani webaptisi inontarai we fiani?” ");
INSERT INTO amk_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Yohanesi yoa deyo, “Iwebaptisi na mereha, wape manei doa rahang mea wa, inontarai nani wiro metaroani kaha. ");
INSERT INTO amk_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Andino da tua yau ma, wape we irehu ne wai sapatu fo terai ki, wiro imai we inari finana kaha.” ");
INSERT INTO amk_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Finani kai kawariai na Betania, waya Yardeni eneung dowaruai, katai Yohanesi webaptisi nai foi. ");
INSERT INTO amk_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Kameaia mani, Yohanesi deti Yesusi da weia. Ainanaya Yohanesi medu deyo, “Mewati, Allai ne Domba Antungno ohonai wekorbani we yiwang inontarainesa ambori feriri sasari nunei fi di wani. ");
INSERT INTO amk_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Andino imadu kariri yeyo, ‘Ambori manei da tua yau ma ki, tuti fiabai sewa yau, weo itaubau nuhu kaharai mae, I mani niayai fitawa kawurua.’ ");
INSERT INTO amk_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Yau kontaio reantenangne mani wiro yeroansoi weMananu Mamparirio imadu kariria fo dine kaha. Wape ira ma we iwebaptisi inontarainesa na mereha ambori inontarai Israeli nesa kiai ewatioi tuti etaroansoi.” ");
INSERT INTO amk_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Yohanesi medu kontai tonina kariri fi deti teri foi, deyo, “Iwati Nuaninu Mirarebana foi ne tarai toyari muntung manei, biari na rorafaisi meu minohi sauwi pampang. ");
INSERT INTO amk_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Rabuang bonani yau kontaio yeroansoi weMananu Mampariri foi dine kaha, wape Allai mano demi yau iwebaptisi na mereha foi medu kawuru we yaua deyo, ‘Masino boti Nuaninu Mirarebana foi biari meu tuti minohi sau manei mani, wenani dino ambori webaptisi na Nuaninu Mirarebana foi ne.’ ");
INSERT INTO amk_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Iwati teri ampa, tuti yeisaha kariri yeyo, I mani Allai ne Kaisung dine.” ");
INSERT INTO amk_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Rahida sua aha foi mani Yohanesi doari na katai nani aha, doa tuti ne inontarai erariati fo uwemandu. ");
INSERT INTO amk_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Tuti na kutu detia Yesusi we da nana fo medu we suru deyo, “Muwatia! Allai ne Domba Antungfi diwani.” ");
INSERT INTO amk_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Yohanesi ne inontarai mandu fo suru utarami medu tonana fo, uroari ahang kahai mae ura ria Yesusia. ");
INSERT INTO amk_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesusi fiobera ureng deti afui mani, deti suru we ura riati fo, ainanaya dutang suru deyo, “Fianang dino musera wei ne?” Manamo umadu wei aha ureyo, “Rabie, munohi maidoni?” (Kaiwo Rabi fo mani neta we Mantaunau.) ");
INSERT INTO amk_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ainanaya Yesus medu we suru nariai aha deyo, “Mura ma, ambori muwati katai iminohi naya fo ki.” Ampafe ura wa ura riati tuti uwati kataio minohi naya fo. Rabuang bonani mani araha ureng boa tuti uminohi riati na nanai paria rahida bonani kiaia. ");
INSERT INTO amk_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Na inontarai manduo utarami Yohanesi ne kaiwofo tuti ura ria Yesusi nani suru mani, manei wonong fino Andareasi, i mani Simon Petrusi ne tahatui dine. ");
INSERT INTO amk_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andareasi nini sikera paria da sera we ne tafuaio Simonia tuti medu wei deyo, “Ausobu Mesiasi ampa!” (Mesiasi mani wang we Kristusi dine, amani Mananu Mamparirio Allai demi ma we yu fi kiai ne.) ");
INSERT INTO amk_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Ampafe kia Simoni we Yesusia. Yesusi seite Simoni mayeai medua wei deyo, “Simoni, Yonai antung di wau. Wau ambori esahu wau we Kefasi ki.” (Kefasi na kaiwo Iberani mani, masi we Petrusi na kaiwo Yunani, amani: Kamiei.) ");
INSERT INTO amk_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Kameai roainai aha mani, Yesusi kiutuai we da to Galileara. Da wa kaharai mae sobu Pilipusi tuti medu wei deyo, “Ro ria yau!” ");
INSERT INTO amk_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Pilipusi nini ne munue na Betsaida, katai Andareasi tuti Petrusi unayai nai foi kontai. ");
INSERT INTO amk_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Pilipusi da wa sobu inontarai manei aha, amani Natanieli tuti medu wei deyo, “Amesobui ampa, amani mano Musai deikariri na ne Kaiwo soi fo nani, tuti nabifosa etoi kariri foia fo. I mani Yesusi na Nazareti, Yusupi antungfoi.” ");
INSERT INTO amk_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Wape Natanieli medu deyo, “O! Fi bengfo da na Nazareti mae?” Ampafe Pilipusi medu wei deyo, “Ro ma boti teri.” ");
INSERT INTO amk_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesusi deti Natanieli da weia nanai, medu deyo, “Inontarai Israeli tarai fi diwani, inontaraio tatofane kuteai tataha nai kaha dine.” ");
INSERT INTO amk_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ampafe Natanieli medu we Yesusi aha deyo, “Na todonie boyo boroanso yau tonanai nina.” Yesusi yoa wei deyo, “Pilipusi sahu wau kaharai mae, iwati wau we munohi na ai urung neungfo.” ");
INSERT INTO amk_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Ainanaya Natanieli medu deyo, “Dai Rabio Mantaunaune waune, boroang yau tonana mani Allai ne Kaisung di wau! Israeli amene Mananu di wau!” ");
INSERT INTO amk_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Yesusi medu wei aha deyo, “Roasoai weo fitantumao yeyoai we iwati wau kawuru na ai urung arowawahi foi fo ne? Fi fuba sewa weru ninai ambori botioai ki!” ");
INSERT INTO amk_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ainanaya medu aha deyo, “Tarai antu! Imadurai we mea mau yeyo, ambori mewati rorafaisi tifai tuti Allai ne wewaifosa etautai ebia we Kaisung Inontarai nei ki.” ");
INSERT INTO amk_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Rahida boru aha mani, inontarai manei niari muniara mandirau bei na bendari Kana na nu Galilea foi, tuti Yesusi inang niayai na muniarafoi kontai. ");
INSERT INTO amk_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Mano niari muniara foi wenoti Yesusi tuti ne inontarai erariati fosa kontai to muniarafoia. ");
INSERT INTO amk_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Muniarafoi da pariao mayeai ene anggurifo kai, ainanaya Yesusi inang medu wei deyo, “Ene anggurife kai ampa.” ");
INSERT INTO amk_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Yesusi yoa we inanai deyo, “Aie, we fiani butang weaifa ria yau tonana? Weo wiro rahida we yeinawi mandoni di yau fo kaharai.” ");
INSERT INTO amk_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Manamo Yesusi inang medu we mansarawiri na muniara fosa deyo, “Fifianai aino medurai we mea wa menari kaririai.” ");
INSERT INTO amk_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Babeu wonang watai kefang na nanai, babeu nanai we ambori esoni mereha soai we eruai ea nayai kariri ene koang Yahudi foi. Babeufo bei mani kia mereha literi piaring rai (100). ");
INSERT INTO amk_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesusi medu we mansarawirifosa deyo, “Mesoni babeunea sayefang na mereha.” Ampafe esoniaia sefang na mereha kaririai. ");
INSERT INTO amk_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ainanaya Yesusi medu wesa deyo, “Into metutu merehawa kuteai meha we mano wenunggamiei we muniaraneia.” Ampafe eha merehafo kuteai we mano wenunggamiei we muniara foia, ");
INSERT INTO amk_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","tuti inontaraifoi bororuainso kariri merehao Yesusi yiwani weanggurifoia nanai, serawera angguri nani na doni ma, manta mansarawirifo saino ewaitawang tera ne. Ainanaya sahara medu we mandirau mangfoi deyo, ");
INSERT INTO amk_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“O, siai paria! Na doni kontai, na muniara tonina foi mani, angguri ne bengfo aino etohonai fafong we kaiwasafoi dunung ne, akawuru wori ne beng turura kaha fo ki. Wape nina mani, bohong angguri ne beng ninai watai paria arahi bohonai wefuiai mandiei nina!” ");
INSERT INTO amk_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Fitantuma nanai Yesusi niari na Kana na nu Galilea foi, wefitantuma reantenang pari na ne fiainawiai fuba niariri foi kiai. Na fitantuma nanai deinawi kariri ne sambewaraio dedai fo tuti ne inontarai erariati fosa eroasoi finanaia. ");
INSERT INTO amk_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Mayeai Yesusi da to bendari Kapernaumi ahaweu, inanai, ne tahatuifosa tuti ne inontarai erariati fosa era ruhiai to katai nani aha. Enayai we rahida beiru teai na bendari nani. ");
INSERT INTO amk_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Na rabuang bo Yahudifosa ene rahida fuba Paska foi rerai we etohonsuari fo, Yesusi dautai to Yerusalemi aweai. ");
INSERT INTO amk_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Na wanai, na Allai ne Munufoi rofongfo, deti inontaraio etawayang sapi, domba tuti romu muntung fosa eminohi etawayang na nanai, kontai mano eriwang doi fosa eminohi eriwang doi na Munu rorongfoi kontai. ");
INSERT INTO amk_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ampafe niari wai rarubatai bei, mayeai datasa weru Allai ne Munufoi; mano etawayang andowa fosa tuti ene sapi tuti domba fosa kontai, tuti mano eriwang doi fosa kifasiaya ene doifo to kahofa wowongfo aweu tuti bebari meja eminohi eriwang naya fo. ");
INSERT INTO amk_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","We mano etawayang muntung fosa medu wesa deyo, “Meruai fi metawayanai ninai weru katai nini, wiro menari nehu Dai ne Mununei we katai awayangfi nai fanai.” ");
INSERT INTO amk_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ampafe Yesusi ne inontarai erariati fosa earomio kariri kaiwo dotu na Kaiwo Mararebana fo, amani kaiwo Mananu Dauti tuti nabifosa emadu fafong kariri fi arahi Yesusi niari fo, amani dotu deyo, ");
INSERT INTO amk_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Mano ewewafoniai we Yahudi fosa etapa Yesusi eteyo, “Todonie enemutituai we nemu mambiriu we batasa tonanai? Fitantuma fianai aino boinawiai we amea, we nemu mambiriu we nari toninaifa ne?” ");
INSERT INTO amk_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ampafe Yesusi yoa wesa deyo, “Metota Sempaisi ne Mununeia wioru, tuti na rahida botoru kawuru mae ibauni aha mesi nariai aha.” ");
INSERT INTO amk_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Ainanaya Yahudifosa emadu wei eteyo, “Defuina piarua wonang (46) ambori Sempaisi ne Munu nini ebaunia kiai ki, wape boyo bauni na rahida tarai botoru kawuru e?” ");
INSERT INTO amk_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Wape Sempaisi ne munu Yesusi medu kariri foi mani, mantauni ne taraifoi. ");
INSERT INTO amk_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ampafe na fui, rahida botoru suwi na marareha rorong foi aha ma fo, arahio ne inontarai erariati fosa earomioaifa we finanai medurai kawuru kaririai ampa. Ampefe eroaso fianai aino dotu na Kaiwo Mararebana fo tuti fianai aino Yesusi medura fo. ");
INSERT INTO amk_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Rahida beiru teai niayai na bendari Yerusalemi na rahida Paska foi nanai, kaiwasa bitoya eroasoi, we ewati fitantuma bitoya niariri fo. ");
INSERT INTO amk_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Wape Yesusi mantauni wiro yoaso ea kaha, weo deroanso inontarainesa kiai enemirorongfoi fefe. ");
INSERT INTO amk_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Weo mandoni kontaio wiro medu kariri inontarainesa wei kaha, weo deitawang kariri inontaraine enemirorongfoini fefe. ");
INSERT INTO amk_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Farisi manei wonong fino Nikodemusi, i mani Yahudi ene Majelisi Agama fo manei dine, amani wenunggamiei kontai na agama Yahudi foi. ");
INSERT INTO amk_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Da diruai we Yesusi ma tuti medu wei deyo, “Dai Rabio Mantaunaune waune, amewaitawanai we wau mani Allai dino demi wau ma ne tuti ro wemantaunau ma. Weo mandoni kontaio wiro niari fitantuma nari nina kaha, Allai weriria wenani fino niari finana fe.” ");
INSERT INTO amk_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yesusi yoa deyo, “Tarai antu! Imadurai we mea mau yeyo, mandoni kontai wiro suai tono Allai ne weMananu rorong fo kaha, mae wenani saubaununggamiei riwanai akawuru wo.” ");
INSERT INTO amk_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ampafe Nikodemusi medu we Yesusi aha deyo, “Nana mani inontarai fiabai kawurua foi saubaununggamiei riwanai ahang rai e? Todoni wori suai to inang enemanabufoi afui we minohi tutiri riwanai aha ki?” ");
INSERT INTO amk_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Manamo Yesusi yoa deyo, “Tarai antu. Imadurai we mea mau yeyo, masino inontarai manei saubaununggamiei na mereha baptisi foi tuti na Allai Nuaninufoi kaha mani, wenani wiro suai to Allai ne Mananu rorong fo kaha ki. ");
INSERT INTO amk_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Inontaraine, weinontarai batangfo mani, saubaununggamiei na ne wawafo suru, wape na Sempaisi mani saubaununggamiei weworu na Allai Nuaninufoi. ");
INSERT INTO amk_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Dohonao popuhung we kaiwo imadurai yeyo, ‘Todoni kontaio metaubau menumikamiei riwanai ahangfo,’ fanai. ");
INSERT INTO amk_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Wanangnei siaya to katai doni deyo defai wea fo tuti taramuoi we nukuayafo, wape wiro boitawang siayai na doni ma fo kaha tuti siayai to doni fo kaha. Mano saubaununggamiei na Allai Nuaninufoi tonanai kontai, todoni saubaununggamieia weworu tonana fo tawaitawana kaha, nanai na Allai Nuaninufoi terai.” ");
INSERT INTO amk_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ainanaya Nikodemusi medu we Yesusi aha deyo, “Finanai kawariai todoni rai?” ");
INSERT INTO amk_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ampafe Yesusi yoa wei aha deyo, “Wau mani mantaunau Israeli di wau, wape todoni fino boitawang finana kahai nina? ");
INSERT INTO amk_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Tarai antu! Imadurai we mea mau yeyo, amemadu kariri fianai aino amewaitawana fo, tuti ametairiri kariri fianai aino amewati teri fo, wape wiro meroaso fi amemadurai tonana fo kaha. ");
INSERT INTO amk_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Yeiriri kariri finunei we mea, wape meroasoa kahai. Nana mani, yeiriri kariri fi na rorafaisi we mea fo, meroasoai todoni ki? ");
INSERT INTO amk_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Weo wiro inontaraine manei dautai to rorafaisi kaha, manta mano ibiari na rorafaisi meu ne yau, amani Kaisung Inontarai ne yau. ");
INSERT INTO amk_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Tuti ne tarai kariri fafongfa Musai yuai tawai tembaga foia dedai na katai wekamamiei fo ambori mano tawai ehirisa nanisa etarang, tonanai kontai Kaisung Inontarai nei todoni kontaio ruaisi dedai, ");
INSERT INTO amk_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ambori mandoni kontaio yoasoi mani sobu numainufo. ");
INSERT INTO amk_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Weo Allai enewawu nunei fuba paria, doni dohongno ne Kaisung Mansiari foi, ambori mandoni dino yoasoi mani wiro wioru kaha, mae sobuo numainufo. ");
INSERT INTO amk_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Weo Allai demi ne Kaisungfoi meufo wiro we kiutu kaiwo kariri nunei kaha, mae we feriri nunei na I. ");
INSERT INTO amk_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Mandoni dino yoasoi mani wiro sodai aiboifo kaha, mae mandoni dino yoasoi kaha mani, wenani aiboi sobua fo mani Allai kiutuai kariri ampa, weo wiro yoaso ne Kaisung Mansiari foi kaha fefe. ");
INSERT INTO amk_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Weyoasoa kahai nani, fi dapai we sobu aiboifo ainina: Sambewarafoi da kawuru to nunei ma ne, wape inontaraine etohong we mamantiti rorong fo sewa weru Sambewarafoi, weo enari ne karirafo fefe. ");
INSERT INTO amk_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Weo mandoni kontai andino niari ne karirafo mani, enerireu Sambewarafo, tuti wenani miaya we da to Sambewarafo kaha, weo mitai ne karira niari nanai kawariai ati para rai fefe. ");
INSERT INTO amk_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Wape mandoni dino niari kariri ne wetaraifo mani da to Sambewarafo, ambori wati parai we fianai aino niari nanai niari na Allai.” ");
INSERT INTO amk_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Mayeai Yesusi da tuti ne inontarai erariati fosa na bendari Yerusalemi to boriai awa enayai tourai na nu Yudea foi nani, tuti ewebaptisi kaiwasao eteyo erariati fosa na nanai. ");
INSERT INTO amk_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Mae Yohanesi kontai webaptisi kaiwasa na Ainoni kefang we Salimi, weo mereha bitoya na nana fefe. Inontarai era weia we webaptisisa nayai, ");
INSERT INTO amk_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","weo rabuang bonani wiro etafu Yohanesia wiatai na aitamu rorong foi kaharai. ");
INSERT INTO amk_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Rahida bei Yohanesi ne inontarai erariati fosa tuti inontarai Yahudi manei esawasa kariri todoni koangno eruairurangsarao emararebanafo kariri agama Yahudi fo. ");
INSERT INTO amk_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ainanaya era we Yohanesia tuti emadu wei eteyo, “Dai Rabio Mantaunaune waune, inontarai mano raminde doa ria wau na waya Yardeni eneung dowarua foi tuti boinawi kariri nani, ninaifa mani webaptisi kontai tuti kaiwasanei kiai era wei pampang.” ");
INSERT INTO amk_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Yohanesi yoa wesa deyo, “Inontarai manei sobu mambiriufeai we niari fieai mani, nanai na Allai na rorafaisi teraifa. ");
INSERT INTO amk_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Mantaung mea metaramioai ampa weo, raminde imadu yeyo, ‘Yau mani Mananu Mampariri nei di yau kaha, manta inontaraio Allai demi yau we ira foni foi di yau.’ ");
INSERT INTO amk_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mandirau wiwing foi mani, mandirau mang foi dino neni ne. Mandirau mang foi ne maniwowirio weririati foi mani doa demang wei, tuti tarao medu mani, firaise paria we tarao raofuifoi. Nehu tarai toyari ne maniworiri nani ampafe yau kontai ifaraise tonanai, tuti ninaia mani ifaraisefo fuba pari ampa weo inontarai efau era weia fefe. ");
INSERT INTO amk_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Andino todoni kontaio fiabai wewonong aha, tuti yau mani ambori iweinontarai katui tuti iwewonohu ahang kaha. ");
INSERT INTO amk_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Yesusi, mano da na dadaifo meu amani na rorafaisi meu mani, dedai sewa fifiani kontai. Mano da na nunei mani, inontarai nunei dine, tuti ne kaiwo medura fo dotu kariri fi nunei terai. Mano biari na rorafaisi meu mani ne yai sewa fi nunei kiai. ");
INSERT INTO amk_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Wenani meduairai kariri fianai aino deti teri fo tuti taraoa fo, wape manei wiro yoaso kaiwo medura fo kaha. ");
INSERT INTO amk_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Mae mandoni dino tarao kaiwo medura fo tuti yoasoa mani, wenani yoa weai we Allai mani wetarai. ");
INSERT INTO amk_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Weo Mano Allai demi mani, wenani dino deiriri Allai ne Kaiwofo ne, weo Allai dohong Nuaninufoi weia wiro werea na ea kaha. ");
INSERT INTO amk_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Dai enewawu ne Kaisungfoi tuti dohong fi kiai tono warang rorong fo ampa. ");
INSERT INTO amk_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Mandoni dino yoaso Kaisung nani mani, ambori sobu Waidani tuti minohi wenumainu. Wape mandoni dino deiaya Kaisungfoi mani, wenani sobu numainufo kaha, mae Allai ne kesou fuba fo nayai worui pampang we fitawafa.” ");
INSERT INTO amk_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Farisifosa etaramioai we Yesusi sobu inontarai erariati bitoya tuti webaptisisa weru Yohanesi. ");
INSERT INTO amk_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Wape Yesusi mantauni webaptisi kaha, mae ne inontarai erariati fosaino ewebaptisi ne.) ");
INSERT INTO amk_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ampafe Yesusi deitawanai we Farisifosa etaramio finanafo, da weru nu Yudea foi daraberahi to nu Galilea foi aha. ");
INSERT INTO amk_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Na ne rang rorong da to nu Galilea foi nani, da riria nu Samaria foi. ");
INSERT INTO amk_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Ainanaya Yesusi da wa sobu bendari bei wonong fino Sikhari, katai nani kefang we katai fafongfa Yakupi dohoni we antung Yusupi foi. ");
INSERT INTO amk_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yakupi ne kamirei mereha sirai foi wiatai na katai nani. Yesusi aweng tafa paria we era waroi fefe, ampafe da wa minohi na merehafoi dereungfo. Rabuang bonani rahida rabuang, tarahio araha ureng suraya boru rai. ");
INSERT INTO amk_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Yesusi ne inontarai erariati fosa era pari to bendarifoia we ewori fiang. Mayeai wiwing Samaria manei da ma we dutu mereha na mereha Yakupi sirai foi. Yesus medu wei deyo, “Bohong merehafeai we yau we yunung.” ");
INSERT INTO amk_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Wiwing Samaria foi pepuhung tuti yoa wei deyo, “Dai wau mani inontarai Yahudi di wau mae, todoni fino butang inontarai Samaria ne yau, we mereha ninai?” (Weo inontarai Yahudi nesa wiro efarao inontarai Samaria nesa kaha.) ");
INSERT INTO amk_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Manamo Yesusi yoa wei deyo, “Masino boitawang fianai aino Allai dohona fo tuti mandoni dino dutang wau we bohong mereha we dunung nina mani, ambori butani we mereha ki tuti i ambori dohong mereha darang fo we wau ki.” ");
INSERT INTO amk_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Ampafe wiwingfoi medu wei deyo, “Daie! Nemu pari fi utu mereha nai, tuti kamirei mereha nei berorong paria. Na doni wobu mereha darang fo nanai? ");
INSERT INTO amk_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Dai wau mani wiro fobai sewa amene werengno Yakupi e? Andi dohong kamirei mereha nini we amea tuti mantauni kia mereha we dunung nai, i kontai ne arikangfosa tuti ne fiahungfosa. Mae boyo fobai sewa Yakupi todoni e?” ");
INSERT INTO amk_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesusi yoa wei deyo, “Mandoni kontai, mano dunung mereha nini, rahanang tataha aha ki. ");
INSERT INTO amk_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Wape mandoni dino dunung mereha ambori yohonai wei fo mani, wiro rahanang tataha na eai ahang kaha. Mae mereha yohonai nanai, ambori wemereha ureng deda sabi pampang we numainufo.” ");
INSERT INTO amk_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ampafe wiwingfoi medu wei deyo, “Daie, bohong mereha nanai we yau, ambori rahukanang tataha ahang fanai, tuti wiro ira to ninai pampang aha ma we yutu mereha ahang kaha.” ");
INSERT INTO amk_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ainanaya Yesusi medu wei aha deyo, “Roa wahu wamuai, kari murarabera muru toninai ma.” ");
INSERT INTO amk_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Manamo wiwingfoi yoa wei deyo, “Yau mani nehu pari mang.” Ampafe Yesusi medu wei deyo, “Kaiwo modura kariri nemu pari mangwa mani tarai, ");
INSERT INTO amk_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","weo rau mang ringna fininai, tuti mangno minohi ria wau nani mani wiro nemu mang dine kaha. Na fininai, modu tarai nei.” ");
INSERT INTO amk_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ainanaya wiwingfoi medu deyo, “Daie! Nina mani kasau we yau ampa we wau mani nabi di wau! ");
INSERT INTO amk_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Inontarai Samaria ne amea, amene werengfosa esomi we Allai na uai nini, wape Yahudiwa mea meteyo, inontarai tasomi we Allai mani na Yerusalemi terai.” ");
INSERT INTO amk_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesusi medu aha deyo, “Roaso yau, we rahidafo ambori da ma ki, we inontaraine mesomi we Dai fo wiro na uai nini kaha, tuti wiro na Yerusalemi kaha. ");
INSERT INTO amk_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Inontarai Samaria ne mea mesomi we fi wiro metaroansoa kaha foi, wape Yahudine amea mani amesomi we mano ametaroansoi foi, weo Allai dererai we neo faririfo da na inontarai Yahudi ne amea. ");
INSERT INTO amk_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Wape rahidafo ambori da ma ki, tuti da kawuru ma ne, weo mano tarai esomi we Dai Allai esomi na Nuaninu Mirarebana foi tuti esomi na mai. Weo inontarai esomi wei tonana fosaino Dai dawi weai tonanai. ");
INSERT INTO amk_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Weo Allai mani Nuaninu dine, tuti mandoni kontaio somi wei mani, somi na Allai Nuaninufoi ne mambiriufo tuti somi na tarai wei.” ");
INSERT INTO amk_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Wiwingfoi medu wei deyo, “Iwaitawanai we Mananu Mamparirio ahui we Kristusi foi ambori da ma ki. Da ma mani ambori deikariri kariri finini kiai kaririai we amea ki.” ");
INSERT INTO amk_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesusi medu deyo, “Mano boyoi nini mani, Yaune, mano yoa imadu ria wau nina!” ");
INSERT INTO amk_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Na kutu nanai Yesusi ne inontaraifosa etaraberasa na bendarifoi ma. Epapuhung paria we ewati Yesusi medu ria wiwingfoi fo, wape na ea manei wiro dutang bera wiwingfoi deyo, “Fianai aino butani wea fo.” Ete etutangbera Yesusi eteyo, “We fiani modu ria wiwingfoi.” ");
INSERT INTO amk_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ampafe wiwingfoi sawingno babeu kiari foi wiatai mae mito to bendarifoia deikaririai we inontarai na nana fosa, ");
INSERT INTO amk_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","medu deyo, “Mera ma mewati inontaraio deikaririai we yau kariri fi kiaio raminde inariri foi. Tarahio i mani Mananu Mampariri foi dine fe.” ");
INSERT INTO amk_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ampafe inontaraifosa era weru bendarifoi to boriei we Yesusia. ");
INSERT INTO amk_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Na siari nanai kontai Yesusi ne inontarai erariati fosa etutani we etampi, eteyo, “Dai Rabio Mantaunaune waune, bampi.” ");
INSERT INTO amk_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Manamo yoa wesa deyo, “Nehu fiangfea ne, fiang nanai wiro mewaitawana kaha.” ");
INSERT INTO amk_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ampafe ne inontaraifosa etutang wawerasa eteyo, “Manei kia fiangfeai wei ma re?” ");
INSERT INTO amk_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ainanaya Yesusi medu deyo, “Nehu fiangne mani yohong kariri fianai aino mano demi yau foi dawi wea fo, tuti inari kariri fio demi yau we inari foa kai. ");
INSERT INTO amk_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Memadu meteyo, embai boa aha mani rahida we tateting fitatanangfo. Wape imadu we mea mau yeyo, mewati wari katai metoari naya wa tuti mewati to romifoa, fitantanangfi bioangna kiai ampa tuti meinenang we metetini ampa. ");
INSERT INTO amk_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Na ninaifa kontaio mano eteting fi fosa esobu ene fiembaitafo, tuti efanduhi fi etetinai nanai we esobu numainufo. Ampafe mano eteting fi fosa tuti mano anta etanang fosa efaraise ruhiai. ");
INSERT INTO amk_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Weo na fi toninane wetarai kariri kaiwo neta weai ninai amani, ‘Manei sanang fi tuti manei siai andino detinai.’ ");
INSERT INTO amk_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yemi mea mera we meteting fio wiro metanang kaha fo, inontarai siai ansaino etanang tuti erurai nai, tuti mera wa we metetingno fi wetarai nano ene fi eru fo nanai.” ");
INSERT INTO amk_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Inontarai Samaria bitoya na bendarifoi eroaso Yesusi, weo kaiwo wiwingfoi medurai fa deyo, “Fianai aino raminde nanai inaria fo, inontarai nini deisaha kaririaia kai beyari.” ");
INSERT INTO amk_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ampafe inontarai Samaria fosa era wa esobu Yesusi nanai, etutani we niayai na nanai riasa, ampafe Yesusi niayai na nanai rahida boru. ");
INSERT INTO amk_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Kaiwasa bitoya aha eroasoai we etarami te Yesusi mantauni ne kaiwo aunau medurai wesa fo fefe. ");
INSERT INTO amk_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Tuti emadu we wiwingfoi eteyo, “Ninaia mani ameroasoai ampa, wape wiro we kaiwo modurai we amea fo tera kaha, mae we mantaung amea ametarami terai we medufo tuti amewaitawanai we inontarai nani mani tarai Mananuo feriri nunei dine.” ");
INSERT INTO amk_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesusi ne rahida boru na Samariara nanai, mayeai da pari to nu Galilea foi aha. ");
INSERT INTO amk_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Weo mantauni raminde medurai kawuru ampa deyo, “Nabi manei na ne katai saubaunung nai foi, ne inontaraifosa wiro etatori kaha.” ");
INSERT INTO amk_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Ampafe na rahida da wa sobu nu Galilea foi nanai, inontarai na wana fosa etamang wei na enemirorong mirising, weo ewati te fitantuma fuba raminde niariri kiai na bendari Yerusalemi na rahida fuba Paska foi fo weo ea kontai anta era to wanai we etohonsua rahidafoi nai fefe. ");
INSERT INTO amk_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ampafe da paria sobu Kana na nu Galilea foi aha, kataio raminde niari merehafoia weangguri denteng pari fo. Na bendarifoi inontarai fuba na munu mananu foi manei, ne arikangfoi meninang na bendari Kapernaumi. ");
INSERT INTO amk_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Taraoai we Yesusi da na nu Yudea foi to Galilea foi ma nanai, da wei tuti dutani paria we da riatia niari ne arikangfoia denteng, weo meninangna adareti mireha fefe. ");
INSERT INTO amk_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ampafe Yesusi medu we inontaraifoi aha deyo, “Todoni e? Masino mewati fitantumafea tuti fiainawiaifea kaha mani, wiro meroasoai na ea kaha nina.” ");
INSERT INTO amk_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Wape inontarai fuba foi medu we Yesusi deyo, “Daie, ro na nehu arikangfi wiro mireha kahai wanaia.” ");
INSERT INTO amk_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yesusi medu wei aha deyo, “Roa, nemu arikangfoi darang ki.” Inontaraifoi yoaso Yesusi ne kaiwofo, ainanaya da wa. ");
INSERT INTO amk_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Na rang rabuang, ne mangfatafosa era weuwi ma eteisaharai wei eteyo, “Daie, nemu arikangfoi darang fo.” ");
INSERT INTO amk_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ainanaya dutang berasa deyo, “Araha ureng beiru mani denteng?” Eroa wei eteyo, “Ramindenafa, tarahio araha ureng boyari rahida rabuang mani ne tarai meninggapoi denunangfo niai.” ");
INSERT INTO amk_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Ainanaya inontaraifoi arooaifa we na araha ureng bonani dino Yesusi medu wei deyo, “Nemu arikangfoi darang ki.” Ampafe i tuti ne munu rorong foi sentenang eroaso Yesusi. ");
INSERT INTO amk_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Finana mani, fitantuma weberuo Yesusi niari na nu Galilea foi na rabuang bo daraberahi na nu Yudea foi ma fo ainana. ");
INSERT INTO amk_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Webeiru teai aha mani, rahida fuba Yahudi bei, ampafe Yesusi da to bendari Yerusalemi awiai. ");
INSERT INTO amk_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Na Yerusalemi kefang we kataio wonong Rahutu Domba foi, na nanai kuru mereha fiabai bei, na kaiwo Iberani mani wonong fino Betesda. Na rurang kuru mereha Betesda nani ne refongfo ring. ");
INSERT INTO amk_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Inontarai emaninang bitoya ewatai na munu refong nanai, manea euremifafa, manea era esoberasa, tuti manea kontai efaya. Inontarai nanisa kiai ewatai etamang we mereha na kurufoi wedohifo. ");
INSERT INTO amk_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Weo wea mani Sempaisi ne wewai manei biari na rorafaisi to kurufoi meu we nihing merehafoi. Tuti inontarai meninang mano saukaha merehafoi reantenang mani, ne maninangfoi niai weruri, maninang sodoni fei kontai ki. ");
INSERT INTO amk_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Na katai nani, mang manei meninangfo defuina piareia sura suraya indeatoru ampa (38). ");
INSERT INTO amk_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesusi detioi we wiatai na nanafo, tuti deitawanai we meninang tonana fo waroi ampa, ampafe dutang berahi deyo, “Boyo bonteng ne?” ");
INSERT INTO amk_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Inontarai meninang foi yoa wei deyo, “Daie, wiro manei minohi kefang na ninai we merehanei dohi mani, su yau to kurufoi aweu kaha. Tuti irurai we isawaya to kurufoia, wape manei ne fafong kawurua saukaharia.” ");
INSERT INTO amk_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yesusi medu wei aha deyo, “Boabari wau ruai nemu andaungwai tuti roa.” ");
INSERT INTO amk_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Na kutu nanai kontaio inontaraifoi denteng tuti yuai ne andaungfoi tuti da. Wape rahida bonani mani, rahida Sabati dine. ");
INSERT INTO amk_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ampafe mano ewenunggamiei we Yahudi fosa emadu we mano arahi denteng nani eteyo, “Rahida nini mani rahida Sabati dine. Tonana mani kariri hukumi na tane agamane mani wodua nemu andaungwai ro fanai.” ");
INSERT INTO amk_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Manamo inontaraifoi yoa wesa deyo, “Mano anta niari yau yenteng foi, andino medu we yau deyo, ‘Ruai nemu andaungwai tuti ro.’ ” ");
INSERT INTO amk_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ampafe etutang berahi eteyo, “Mano demi wau ruai nemu andaungwai tuti ro nani mani, mandoni dine?” ");
INSERT INTO amk_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Manamo inontarai dentengna nani wiro deitawang mandoni dino niariri denteng tonanafo kaha, weo Yesusi fiononami na kaiwasa bitoya foia fefe. ");
INSERT INTO amk_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Waroi aha kaha mae Yesusi sobu inontaraifoi na Sempaisi ne Munufoi rorongfo aha tuti medu wei deyo, “Ninaia mani bonteng ampa, ampafe wiro nari sasari ahang fanai, ambori wiro wodai ne karira pari sewa fo ahang kaha.” ");
INSERT INTO amk_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ainanaya inontaraifoi da wa deikaririai we mano ewenunggamiei we Yahudi fosa, we Yesusi dino niariri denteng tonana ne. ");
INSERT INTO amk_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Tuti na tonanane wedaya mano ewenunggamiei we Yahudi fosa erurai we enari kanggani Yesusi, weo niari fi tonana fo na rahida Sabatifoi fefe. ");
INSERT INTO amk_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Wape Yesusi medu wesa deyo, “Nehu Dai yufi paria sobu ninai, tuti yau kontai irufi kontai.” ");
INSERT INTO amk_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yesusi ne kaiwo medurai nanai wedayasa erurai mambiriu aha we emuni. Enari tonanafo wiro we dohong sara fi dotu na Hukumi Musai soi fo hukumi na ene agamafo kariri rahida Sabatifoi tera fo kaha, wape kontai we medu deyo Allai mani tamang dine fo, weo na tonanane yuaisi we ne tarai kariri Allai. ");
INSERT INTO amk_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Nanai wedaya Yesusi yoa wesa medu toninai deyo, “Tarai antu, imadurai we mea mau yeyo, Kaisungfoi wiro biriu we niari fieai na mantauni kaha, mae fio detioai ria Tamanai we niari fo fine. Weo fianai aino Tamang niari fo, finanai kontai aino Kaisungfoi niari ne. ");
INSERT INTO amk_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Weo Tamang enewawu ne Kaisungfoi tuti deinawi fi fuba mantauni niariri foi wei kiai. Tuti Tamanai kontai ambori deinawi fi niario fuba sewa weru ne nanaifa fo wei aha ki, nanai wedaya mea mepapuhung pari aha. ");
INSERT INTO amk_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Weo kariri Dai we duwi inontarai emarareha fosa tuti dohonsa etarang ahang fo, tonanai kontai we Kaisungfoi, mandoni dino eneoi we duwiri aha darang ahang fo ambori niariri darang tonanai ki. ");
INSERT INTO amk_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Dai wiro kiutu kaiwo kariri inontarai manei kaha, mae mambiriu we kutu kaiwo kariri inontarai tonanafo dohonai we Kaisungfoi ampa, ");
INSERT INTO amk_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ambori kaiwasanei kiai esomi we Kaisungfoi kariri esomi we Daifo. Mandoni dino somi we Kaisungfoi kaha mani, wiro somi we Dai mano demi Kaisungfoi da ma foi kaha. ");
INSERT INTO amk_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Tarai antu, imadurai we mea mau yeyo, mandoni dino tarao nehu kaiwone tuti yoaso Mano demi yau foi mani, sobu numainufo ampa tuti wiro sodai aiboifo konta kaha, weo wenani tiwera weru mararehafoi to arangfo ampa. ");
INSERT INTO amk_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Tarai antu, imadurai we mea mau yeyo, rahidafo ambori da ma ki, tuti da kawuru ma ne, we inontarai emarareha fosa ambori etarami Allai ne Kaisungfoi raofuifoi. Tuti mano etaramioi fosa ambori etarang ki. ");
INSERT INTO amk_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Weo Dai mantauni mani arangfoi weneung nai, tonanai kontai we I ambori dohongno mambiriu dohong arangfo nani we ne Kaisungfoi, ampafe arangfoi weneung nai kontai. ");
INSERT INTO amk_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Tuti dohong mambiriu kontai we ne Kaisungfoi we kiutu kaiwo, we I mani Kaisung Inontarai foi dine. ");
INSERT INTO amk_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Wiro mepapuhung we fi metaramioai nina fanai, weo rahidafo ambori da ma ki, inontarai emararehara fosa kiai ambori etarami raofuifoi, ");
INSERT INTO amk_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","tuti era to boriai weru ene fafo rorong fo, mano enari ne bengfo ambori etoabarisa we etarang we numainufo, wape mano enari ne karira fosa, ambori etoabarisa we esobu aiboifo.” ");
INSERT INTO amk_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Yau mani wiro iwemambiriu we inari fieaifa na mantaung yau nehu awiafo kaha. Ikutu kaiwo kariri fianai aino tarahuai na Allai fo. Tuti fianai aino ikutuai tonana fo mai, weo wiro yohong we ikutu kaiwo kariri nehu awiafo kaha, mae kariri Dai mano demi yau foi ne awiafo. ");
INSERT INTO amk_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Masino mantaung yau yeiririai yeisaharai we Allai andino demi yau ma ne, fi imaduairai nanai wiro wefiea kaha. ");
INSERT INTO amk_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Wape inontarai siai manei dino meduairai kariri yau ne, tuti iwaitawanai we fi medurai kariri yau nanai wetarai. ");
INSERT INTO amk_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Metemi inontarai we Yohanesia we etutang berahi tuti meduairai kariri ne wetaraifo. ");
INSERT INTO amk_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Fi medurai tonana ne, wiro isera we yeyo inontarai emaduairai kariri yau kaha, wape we ambori meroaso ne kaiwofo ambori mesobu faririfo. ");
INSERT INTO amk_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Yohanesi nini ne tarai kariri padamarangno denggararu tuti sambewarai. Tuti mefaraise menayai na sambewarai nani tourai fa. ");
INSERT INTO amk_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Wape fiainawiai kariri yau ne fuba sewa Yohanesi medura fo, amani fi kiaio Dai dohonai we yau we ambori inari kariria ne. Finanai kontai aino inari ninai, tuti finanai wefiainawiai kariri yau we Dai demi yau. ");
INSERT INTO amk_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Tuti Dai mano demi yau nei, andino meduairai kariri yau ne. Wiro metarami raofuifoi na ea kaha rai, urengfo terai kontaio wiro mewatioai na ea kaha rai, ");
INSERT INTO amk_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","tuti ne Kaiwofo wiro metanamai na menemirorongwai kaha, weo mano demi ma nini mani, wiro meroasoi kaha fefe. ");
INSERT INTO amk_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Merurai paria we metato Kaiwo Mararebana fo we ambori mewaitawanai na mai, weo mewaitarahio mesobu numainufo na Kaiwo nanai. Tuti Kaiwo Mararebanai nani medu deinawi kariri yau tonanai ki, ");
INSERT INTO amk_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","wape wiro memaya we mera we yau ma we mesobu arangfo kaha. ");
INSERT INTO amk_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Yau mani wiro isera we inontaraine mefiai yau kaha. ");
INSERT INTO amk_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Weo mea mani yeroanso mea, iwaitawanai we wiro menemiwawu Allai na menemirorongwai kaha. ");
INSERT INTO amk_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ira kawuru ma ne na Dai wonongfo ampa, tuti wiro metamang we yau kaha. Wape inontarai siai manei da na mantauni wonongfo ma mani, wenani metamang wei na mai. ");
INSERT INTO amk_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ampafe masino meparaise we mantaung mea mefiai bera mea, mae wiro mesera we Allai mano Mansiri foi we fiai mea kaha, nana mani ambori meroasoai todoni? ");
INSERT INTO amk_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Wape dohonao mewaitarahio yauno ambori yinggai mea na Dai arongreafo fe. Mae mano ambori dinggai mea mani Musai, mano menemitawani foi. ");
INSERT INTO amk_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Weo masino meroaso Musai tarai mani, todoni kontaio meroaso yau konta rai. Weo fianai aino Musai soi fo mani soi kariri yau. ");
INSERT INTO amk_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Wape masino meroaso fianai aino Musai soi fo kaha mani, todoni meroaso nehu kaiwo imaduraifa ne ki?” ");
INSERT INTO amk_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Mayeai Yesusi da to ruru Galilea foi eneung dowaruai, amani ruruo esahui we Rawanangno Tiberiasi foi. ");
INSERT INTO amk_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Kaiwasa bitoya paria na katai nani era riati, weo ewati fitantuma bitoyao Yesusi niariri foi, amani niari inontarai emaninang fosara ebeng fo. ");
INSERT INTO amk_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesusi dautai to wiwoifoi ayai minohi na nanai ria ne inontarai erariati fosa. ");
INSERT INTO amk_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Rabuang bonani mani rerai we rahida fuba Yahudi fosa esahui we rahida Paska foi. ");
INSERT INTO amk_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesusi fioai ureng deti wari katai doa nai foi tonanaia fo, deti kaiwasa bitoya paria era wei ma. Ampafe medu we Pilipusi deyo, “Tawori fiangfeai na doni we tatohong inontarai fuba nini kiai dampi ne?” ");
INSERT INTO amk_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Yesusi medu tonanafo we titua kariri Pilipusi ne yoasoafo, weo Yesusi mantauni deitawang fianai aino ambori niari fo ampa.) ");
INSERT INTO amk_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Pilipusi yoa wei aha deyo, “Roti ne harga doi dinari piaring weberu (200) kontaio wiro demoya inontarai fuba ninisa kaha, masino ene we marirahi kontai ki.” ");
INSERT INTO amk_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Yesusi ne inontarai erariati fo manei wonong fino Andareasi, i mani Simon Petrusi ne tahatuifoi dine, medu we Yesusi deyo, ");
INSERT INTO amk_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Kaisung manei na ninaifa ne, ne roti ring tuti diang mandu ne. Wape kutu tonanane we fiani rai we kaiwasa fuba tonina fine?” ");
INSERT INTO amk_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesusi medu deyo, “Metemi kaiwasawai minohi.” Katai nani weninoi ampafe kaiwasafoi minohi na kahofa nuwowongfo, kaiwasa nani titou mangfosa tera mani ewepiaura wering wering (5.000). ");
INSERT INTO amk_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ainanaya Yesusi kia rotifo ma dutang tutirai we Allai, dohong mahikai wei, ainanaya fioabau rotifo tuti detorai we kaiwasa bitoya foi. Niari tonanai kontai we diangfo tuti dohonsa etampi pariao emamosi paria. ");
INSERT INTO amk_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Kaiwasafoi dampia memosi beyari tonanaia, Yesusi medu we ne inontarai erariati fosa deyo, “Mefanduhi fiang sea wai, dohonao wea watai funoma fe.” ");
INSERT INTO amk_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Ainanaya efanduhi ne searifo na roti ring etani nani mani, bayai fuba suraya boru sefang. ");
INSERT INTO amk_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Rabuang bo kaiwasa bitoya foi deti fitantuma Yesusi niariri tonana foi nanai emadu eteyo, “Tarai inontarai nini mani, Nabio taenemitawani we da to nunei ma fi dine!” ");
INSERT INTO amk_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Yesusi deitawanai we kaiwasafoi da ma we etanggoari we eruaisi we mananu wesa, ampafe kidori ne taraifoi werusa to uaifoi aha. ");
INSERT INTO amk_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Dirua mani ne mano erariati fosa ebiari to rurufoi aweu, ");
INSERT INTO amk_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","tuti etauo wafeai etafai wanambafoi to Kapernaumia. Dirufoi waroi ampa wape Yesusi wiro da wesa ma kaharai. ");
INSERT INTO amk_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Etafai tonanai mayeai dobarafoi bia na rurufoi wedaya rurufoi weandeisa paria. ");
INSERT INTO amk_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ewo touraia meirabuang, tarahio kiro ring ete wonang teai weru reifo tonanai, mayeai ewati Yesusi da na ai wowongfo wesa to ene wafoia. Ewatioi nanai ematai paria. ");
INSERT INTO amk_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Wape Yesusi medu wesa deyo, “Mematai fanai, yaune!” ");
INSERT INTO amk_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ainanaya na enemirorong mirising etamang wei we dautai to ene wafoi, tuti na tatofang nanai kontai ene wafoi fong suba katai etafai wei foia. ");
INSERT INTO amk_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Kameaia mani, kaiwasa bitoyao niayai na ruru eneung dowei foi nani, ewatioai we wafeai na nanai konta kaha, mae wa rowoyario anta inontarai ewesuraya mandu fosa etauoi foi terai, tuti ewaitawanai we Yesusi wiro dautai riasa kaha, mae titou ne inontarai ewesuraya mandu fosa terai. Ampafe enemitituaitai paria. ");
INSERT INTO amk_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Mayeai wa roweiru teai dafai na bendari Tiberiasi kefang to katai ramindenafa Seng Yesusi dohong mahikai we Allai we rotifo tuti dohonaia kaiwasa bitoya foi etangfo. ");
INSERT INTO amk_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Rabuang bo kaiwasa bitoya foi ewatioai we Yesusi tuti ne inontarai erariati fosa enayai na nana kaha fo, ea kontai etautaio wa anta dafai ma nanai tuti etafai to bendari Kapernaumi we esera we Yesusi nayai. ");
INSERT INTO amk_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Na kutu kaiwasa bitoya foi esobu Yesusi na ruru eneung dowei fo nanai, etutang berahi eteyo, “Dai Rabio Mantaunaune waune, araha ureng beiru wobu katai nini?” ");
INSERT INTO amk_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesusi yoa wesa deyo, “Tarai antu! Imadurai we mea mau yeyo, mesera we yaune wiro we metafu fitantuma inari fo na mai kaha, wape we yohong mea metampia memamosia fo. ");
INSERT INTO amk_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Dohonao merufi we mesobu fiangno ambori kai tuti karira fo fanai, mae merufi we fiangno watai we fitawafa fo tuti dohong mea mesobu numainufo. Fiang nanai ambori Kaisung Inontarai nei dohonai we mea ki. Weo I mani, Dai Allai yuaisi we sobu ne mambiriufo tuti na tonanane deinawiai we yoa wei paria.” ");
INSERT INTO amk_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ainanaya etutang berahi eteyo, “Amenari fiani ambori ameru fio Allai dawi wea fo tonana ne?” ");
INSERT INTO amk_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesusi yoa wesa deyo, “Fi Allai dawiai we meru ne mani, meroaso mano Allai demi ma nei.” ");
INSERT INTO amk_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ampafe eroa wei aha eteyo, “Tonana mani fitantuma fiani aino bohonaifa we fiainawiai we amea ambori amewatioai tuti ameroaso wau ne? Fianai aino nari ne? ");
INSERT INTO amk_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Bohongno fiang we amea, amani fiang mannao amene werengfosa fafongfa etang na katai wekamamiei minano fo. Kariri kaiwo dotu kariri Musai fo deyo, ");
INSERT INTO amk_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ainanaya Yesusi yoa wesa aha deyo, “Tarai antu! Imadurai we mea mau yeyo, wiro Musai dino dohong roti na rorafaisi we meafo kaha, mae Dai andino dohong rotio tarai fo na rorafaisi meu ne. ");
INSERT INTO amk_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Weo Allai ne rotifo mani, rotio biari na rorafaisi meu fine tuti dohong arangfo we nunei.” ");
INSERT INTO amk_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Etaramio Yesusi medu tonanafo, etutani aha eteyo, “Dai Mantaunaune waune, bohongno roti nanai we amea pampang.” ");
INSERT INTO amk_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ampafe Yesusi medu wesa deyo, “Yauno iwerotio dohong inontaraine mea metarang ne. Mandoni kontai andino da we yau ma mani wiro wewisi ahang kahai we fitawafa, tuti mandoni kontai andino yoaso yau mani, wiro arongtataha na weai ahang kaha. ");
INSERT INTO amk_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Wape toyari anta yeisaharai we meara nanai, mewati yau kawuru ampa, tonanai ki mae meroasoa kaha ne rai. ");
INSERT INTO amk_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Kaiwasa fuba Dai dohonsa we yaua fosa ambori era we yau ma ki. Tuti mandoni kontaio andino da we yau ma fo, wiro ikabioi kaha. ");
INSERT INTO amk_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Weo ibiari na rorafaisi meu ne wiro we yohong kariri nehu awiane kaha, mae we yohong kariri mano demi yau foi, amani Allai, ne awiafo. ");
INSERT INTO amk_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Tuti mano demi yau foi ne awiafo ainina: ambori na kaiwasa fuba dohonsa we yau ma nanisa, manei wiro wioru fanai, wape ambori yuwisara esuwi aha na Rahida Wefuiai pari foi. ");
INSERT INTO amk_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Weo Dai ne dawiafo ainina, amani ambori mandoni kontai andino deti Kaisungfoi tuti yoasoi mani, sobu numainufo tuti ambori yuwiri aha na Rahida Wefuiai pari foi.” ");
INSERT INTO amk_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Inontarai Yahudi fosa ehutu Yesusi na enemirorong, weo medu deyo, “Yau mani rotio ibiari na rorafaisi meu di yau fo.” ");
INSERT INTO amk_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ampafe emadu eteyo, “Tofino? Mano medu nini mani Yesusio Yusupi antungfoi dine mae, inang tamang suru mani tataroanso suru ampa? Todoni fino medu deyo i mani roti biari na rorafaisi meu dine nina?” ");
INSERT INTO amk_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ainanaya Yesusi medu wesa deyo, “Mehutu yau fanai. ");
INSERT INTO amk_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Mandoni kontaio wiro wemambiriu we da we yau ma kaha, mae Dai, mano demi yau ma foi, kia wenani we yau ma reto, tuti mandoni dino da ma mani, ambori yuwiria suwi na Rahida Wefuiai pari foi ki. ");
INSERT INTO amk_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Na kaiwo nabifosa esoi fo dotu tonina: ‘Tuti ea kiai ambori Allai deunausa ki.’ Mandoni kontaio taraoai tuti sobu aunaufo ria Dai fo, da we yau ma. ");
INSERT INTO amk_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Na tonanafo wiro deinawiai we manei deti Dai kawuru ampa kaha. Weo manei wiro deti Dai kahaia, manta mano da na Allai ma foi terai, andino deti Dai ne. ");
INSERT INTO amk_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Tarai antu! Imadurai we mea mau yeyo, mandoni dino yoaso yau mani, sobu numainufo. ");
INSERT INTO amk_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Yau mani rotio dohong inontarai etarang foi di yau. ");
INSERT INTO amk_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Mene werengfosa fafongfa etangno manafoi na katai wekamamiei minano foi mae emarareha ampa. ");
INSERT INTO amk_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Wape rotio biari na rorafaisi meu ne andinini, tuti mandoni dino dangno roti nini mani, wenani wiro mireha kaha. ");
INSERT INTO amk_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yauno roti darangno biari na rorafaisi meu ne, amani rotio dohong arang foi. Mandoni dino dang roti nini mani ambori minohi we numainu. Roti nini mani nehu tarainei dine, tuti nehu tarainei, yohoni ki, ambori inontarainesa na nunei etarang.” ");
INSERT INTO amk_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Inontarai Yahudi fosa etaramio Yesusi medu tonanafo, esawa wawerasa tuti emadu eteyo, “Todoni fino inontarai nini deyo dohong ne taraifoi we tata we tatani nina?” ");
INSERT INTO amk_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ainanaya Yesusi medu wesa deyo, “Tarai antu! Imadurai we mea mau yeyo, masino wiro metang Kaisung Inontarai nei ne taraifoi tuti metunung ne rikafoi kaha mani, wiro metarang tarai kaha. ");
INSERT INTO amk_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Inontarai mano dang nehu tarainei tuti dunung nehu rikanei mani darang we numainu tuti ambori yuwiri na Rahida Wefuia foi ki. ");
INSERT INTO amk_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Weo nehu tarainei mani tarai fiang fine, tuti nehu rikanei mani tarai fiunung fine. ");
INSERT INTO amk_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Inontarai mano dang nehu tarainei tuti dunung nehu rikanei mani, weboyari ria yau pampang, tuti yau kontai iweboyari riati. ");
INSERT INTO amk_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Toyari Dai mano darang we fitawafa nani, demi yau, tuti yau kontai iminohi yarang na I, tonanai kontai we mano dang nehu tarainei, ambori na yau minohi darang. ");
INSERT INTO amk_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Roti biari na rorafaisi meu foi dinani, wiro roti kariri mene werengfosa fafongfa etani foi tuti emararehafo kaha. Mandoni dino dang roti nini mani ambori minohi darang we fitawafa.” ");
INSERT INTO amk_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Finanai kai Yesusi medurai na Kapernaumi, na rahida deunau na munu agama Yahudi foi fo. ");
INSERT INTO amk_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Etaramio Yesusi ne kaiwofo tonanaia fo, Yesusi ne inontarai erariati fosa bitoya emadu eteyo, “Kaiwone maraba paria we tata. Mandoni dino wemambiriu we taraoa ne!” ");
INSERT INTO amk_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesusi mantauni deitawanai we ne inontarai erariati fosa ehutuwi na enemirorongfoi we kaiwo medurai tonana fo, ampafe medu wesa deyo, “Meparaise we kaiwo anta imadura nana kaha e? ");
INSERT INTO amk_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Tonanaifa mani, todoni we mea rai e, na rahida mewati Kaisung Inontarai nei dautai to ne katai raminde biari nai meu foi ki? ");
INSERT INTO amk_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Allai Nuaninufoi andino dohong arangfo we nunei ne, inontarai nunei ene mambiriufo wiro wefiea kaha. Kaiwo imadurai we mea mau nina mani, kaiwo na Allai Nuaninufoi aine tuti kaiwo dohong arangfoi fine. ");
INSERT INTO amk_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Tonanai ki wape na mea manea wiro eroasoa kaha.” Yesusi medu tonanai, we na reantenangfo deitawanai kawuru we mandoni dino yoasoa kaha fo, tuti deitawanai kontai we mandoni dino ambori dewayani fo ampa. ");
INSERT INTO amk_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ainanaya medu aha deyo, “Nanai wedaya anta yeisaharai we mea yeyo: Mandoni kontaio wiro da we yau ma kaha, mae Dai kiari we yau ma reto.” ");
INSERT INTO amk_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Na rahida bonani to fongna fo, inontarai erariati fosa bitoya esu to fui tuti wiro erariati ahang kaha. ");
INSERT INTO amk_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ainanaya Yesusi dutang bera ne inontarai ewesuraya mandu dirisa fosa deyo, “Mea kontai, meteyo mera weru yau tonana e?” ");
INSERT INTO amk_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Petrusi yoa we Yesusi deyo, “Sengwa wau, mandoni dino amera wei aha ne? Nemu kaiwone terai aino dohong inontaraine tata tatarang we numainufo ne. ");
INSERT INTO amk_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ameroasoai tuti amewaitawanai tarai we wau mani Mano Murarebanai na Allai di wau.” ");
INSERT INTO amk_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesusi medu wesa deyo, “Imesiri yauno yiri mano mewesuraya mandu nini mea ne, tonanai ki wape manei na mea mani, weSaminseni dine.” ");
INSERT INTO amk_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Mano Yesusi medu kariri tonanai foi mani Yudasi, Simon Iskarioti antungfoi. Weo Yudasi nini mani manei na inontarai ewesuraya manduo Yesusi dirisa fosa dine, wape andino ambori dewayang Yesusi ki. ");
INSERT INTO amk_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Mayeai Yesusi da wari nu Galilea foi, weo miaya we da wa niayai na nu Yudea foi aha kaha, weo na wanai mano ewenunggamiei we Yahudi fosa erurai we emuni fefe. ");
INSERT INTO amk_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Rabuang bonani mani rerai we inontarai Yahudi fosa ene rahida fuba esahui we Rahida Warumai fo. ");
INSERT INTO amk_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Ampafe Yesusi ne tahatuifosa emadu wei eteyo, “Munohi pampang na ninai fanai, mae ro to nu Yudea foia, ambori nemu inontarai eraria wau fosa ewati fianai aino nari fo. ");
INSERT INTO amk_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Weo inontarai manei deyo ambori wewonong na kaiwasa bitoya foi mani, wiro fi niari fo niari worawa kaha. Masino nari fi tonana fo mani, boinawi nemu taraiwai we nunei we deitawanai!” ");
INSERT INTO amk_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Weo ne tahatuifo mantaunsa kontai wiro eroasoi weMananu Mampariri foi dine fo kaha. ");
INSERT INTO amk_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Manamo Yesusi medu wesa deyo, “Nehu rahida we yeinawi yau fo mai kaharai, wape we mea mani rahida fiani kontai mai we mea. ");
INSERT INTO amk_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Weo nunei wiro enerireu mea kaha, wape yau mani nunei enerireu yau, weo imadurai pampang kariri nunei we fi niari fo mani, fi karira fine. ");
INSERT INTO amk_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ampafe mera to Rahida fuba nania. Yau mani wiro ira riata kaharai, weo wiro nehu rahida mai kaharai.” ");
INSERT INTO amk_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yesusi medu tonanai we ne tahatuifosara, tuti mantauni niayai na nu Galilea foi. ");
INSERT INTO amk_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Wape Yesusi ne tahatuifosa era fafongna, mayeai mantauni na mamunggasai da riasa to Rahida fuba foi na Yerusalemi aha ambori kaiwasafoi wiro deitawana kaha. ");
INSERT INTO amk_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Na rahida etohonsua rahida fuba nani fo, mano ewenunggamiei we Yahudi fosa esera wei tuti etutang wawerahaifa eteyo, “Andi doni?” ");
INSERT INTO amk_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Tuti kaiwasa bitoya esaimumung wawerasa kariri i, manea eteyo, “I mani inontarai denteng dine.” Manea kontai eteyo, “Bereri! I sofa wawera kaiwasanei.” ");
INSERT INTO amk_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Tonanai ki wape manei wiro wemang we medu parai kariri i kaha, weo ematai mano ewenunggamiei we Yahudi fosa fefe. ");
INSERT INTO amk_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Etohonsua Rahida fuba foia meirabuang, mayeai Yesusi suai to Allai ne Munufoi afui, tuti deunau kaiwasafoi. ");
INSERT INTO amk_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Mano ewenunggamiei we Yahudi fosa epapuhung wei paria tuti emadu eteyo, “Inontarai nini sobu aunau na ea kaha, wape todoni fino deitawang fi bitoya paria kariri Sempaisi ne Kaiwofo nina?” ");
INSERT INTO amk_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Yesusi yoa wesa deyo, “Fio yeunauwai ninai wiro na mantaung yau kaha, mae na I, mano demi yau foi. ");
INSERT INTO amk_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Mandoni kontai deyo dohong kariri Allai ne dawiafo mani, deitawanaifa we nehu aunau ninai na Allai ete na mantaung yau e. ");
INSERT INTO amk_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Inontarai mano medu na mantauni foi mani, wenani sera we wewonong. Wape mano sera we mano demi foi ambori wewonong foi mani, inontarai nani mesi, wiro tetofa kaha. ");
INSERT INTO amk_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Allai ne Hukumifoi raminde Musai dohoni we mea ampa. Tonanai ki, wape na mea manei wiro dohong kariri Hukumi nana kaha. We fianie merurai we memung yau nina?” ");
INSERT INTO amk_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Kaiwasa bitoya foi eroa we Yesusi eteyo, “Wefiauou ampa! Mandoni dino deyo yurai we miung wau ne?” ");
INSERT INTO amk_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Yesusi yoa wesa aha deyo, “Inari fitantuma beyari na rahida Sabati foi, tuti wedaya mea kiai mepapuhung wea. ");
INSERT INTO amk_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Musai dohong kaiwofoa watai we todoni kontaio mewesunati. Mae tarai we sunati nani wiro na Musai ma kaha, mae na wawao ene fafongna fosa. Tuti arikang manei ne rahida we wesunati foi tete rahida Sabati bei mani, menemitituai towea kaha mae mewesunati na rahida Sabati nani kontai. ");
INSERT INTO amk_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Mewesunati arikang na rahida Sabati tonanai we ambori wiro metohong sara Kaiwo Musai soi kariri sunati foi fanai, tonana mani we fianie mehasou yau we inari inontarai manei ne taraifoi sentenang denteng na rahida Sabati foi nina? ");
INSERT INTO amk_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Wiro mehutu kaiwo kariri inontaraine kariri fio watioa fo ahang fanai, mae mehutu kaiwo mani na mai to.” ");
INSERT INTO amk_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Mayeai inontarai Yerusalemi maneiru teai emadu eteyo, “Inontarai nini dino esera wei we emuni ne mae? ");
INSERT INTO amk_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Wape mewati, doa medu na kaiwasa bitoya foi euremireafo na wiro mitai kahai, tuti manei wiro medu sobu kaiwofeai wei kaha! Tarahio tane mano ewenunggamiei we tata nesa ewaitawanai we I mani Mananu Mampariri dine foa fe? ");
INSERT INTO amk_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Wape inontarai nini tawaitawang kariri ne katai da nai ma fo ampa. Tuti tawaitawanai we Mananu Mampariri foi da ma mani, mandoni kontaio deitawang ne katai da nai ma fo kaha.” ");
INSERT INTO amk_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Yesusi doa deunau na Sempaisi ne Munufoi tonana fo, sahu na raofui fiabai deyo, “Tarai yau mani metaroanso yau tuti mewaitawang nehu katai ira nai ma fo. Wape wiro ira na mantaung yau nehu awiafo kaha, mae Mano wetarai foi andino demi yau ira ma ne, amani Mano metaroani kaha foi. ");
INSERT INTO amk_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","I mani yeroani, weo ira na I ma tuti andino demi yau ne.” ");
INSERT INTO amk_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Na siari nanai kontai erurai we etafuri, manamo manei wiro warakehafo disansoi kaha, weo wiro ne rahida we etafuri kaharai. ");
INSERT INTO amk_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Wape na kaiwasa fuba fianduhi nani, inontarai efau kontai eroasoi tuti emadu eteyo, “Mananu Mampariri foi da ma mani, niari fitantuma bitoya sewa weru fitantuma inontarai nini niari ninaifa ne?” ");
INSERT INTO amk_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farisifosa etaramioai we kaiwasa bitoya esaimumung kaiwo nanai kariri Yesusifo, ampafe ehontai imami baba fosa, etemi mano ewaitawang wedua Sempaisi ne Munufoi maneiru teai era wa we etafu Yesusi. ");
INSERT INTO amk_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ampafe Yesusi medu we kaiwasa bitoya foi deyo, “We rahida beiru teaifa inaya na ninaifa ria mea, tuti rahida nanai kaia mani ambori yarabera yau we Mano demi yau foi aha. ");
INSERT INTO amk_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ambori mesera we yau wape wiro mesobu yau kaha, tuti katai ambori inayai naya fo mani, wiro mera wa kaha rai.” ");
INSERT INTO amk_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ainanaya mano ewenunggamiei we Yahudi fosa emadu wawerasa eteyo, “Inontarai nini deyo da to katai bodonie doni tasobui kahai nina? Ete deyo dontai to katai waroi to inontarai Yahudio enayai na katai siai fo ria inontarai Yunani fosa we deunau inontarai Yunani fosa naya ne? ");
INSERT INTO amk_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Fianai medurai kontai deyo, ambori tasera wei wape wiro tasobui kaha tuti wiro tara to katai niayai nai foi kahai nina?” ");
INSERT INTO amk_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Na rahida bo wefuia foi, amani ene rahida fuba foi na Rahida Warumai nani, Yesusi doa na Sempaisi ne Munufoi tuti sahu deyo, “Mandoni dino arongtataha mani, da we yau ma we dunung. ");
INSERT INTO amk_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Mandoni dino yoaso yau mani, sobu fio na Kaiwo Mararebana fo dotu kariri fo tonina, ‘Na enerorongfoi, mereha wedaya numainufo ambori deda pampang nai ki.’ ” ");
INSERT INTO amk_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","(Na kaiwo nani Yesusi medu kariri Nuaninu Mirarebanaio ambori inontarai eroasoa fosa esobui foi. Weo pariao nanai Allai wiro dohong Nuaninu Mirarebana foi ma kaharai, weo wiro yuai Yesusia dedai sambewarai kaharai.) ");
INSERT INTO amk_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Inontarai maneiru teai na kaiwasa bitoya etarami Yesusi ne kaiwofo nanisa emadu eteyo, “Inontarai nini tarai Nabio ambori da ma foi dine.” ");
INSERT INTO amk_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Manea kontai emadu eteyo, “I mani Mananu Mamparirio Allai demi ma foi dine.” Wape manea aha mani eteyo, “Bereri, Mananu Mampariri nei wiro da na nu Galilea foi ma kaha! ");
INSERT INTO amk_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Weo kariri Kaiwo Mararebana fo mani, Mananu Mampariri nei mani weriria na Dauti ne ririafoi ma tuti na bendari Betlehemi, amani Dauti ne munue saubaunung nai fo.” ");
INSERT INTO amk_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Ampafe kaiwasa bitoya foi esawasa kariri Yesusi. ");
INSERT INTO amk_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Manea na sa eteyo etafuri, manamo manei wiro warakehafoi disansoi kaha. ");
INSERT INTO amk_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Rabuang bo mano ewaitawang wedua Sempaisi ne Munufoi, amani mano imami baba fosa tuti Farisifosa etemisa we etafu Yesusi fo etaraberasara nanai, mano etemisa fo etutang berasa eteyo, “We fianie wiro mehari ma kahai nina?” ");
INSERT INTO amk_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Manamo emadu eteyo, “Oh, wiro amewati manei medu kariri i na ea kaha rai!” ");
INSERT INTO amk_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ampafe Farisifosa emadu aha eteyo, “Tofino, inontarai nani sofa wawera mea konta ne? ");
INSERT INTO amk_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Mewatio mano ewenunggamiei we tata nesa manei yoasoi ampa ne? Ete Farisinesa kontai manei yoasoi ampa ne? Bereri! ");
INSERT INTO amk_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Wape kaisawa bitoya ninisa etaroanso Kaiwo Musai soi fo kaha, tuti todoni kontaio inontarai nanisa Allai deikangganisa ampa.” ");
INSERT INTO amk_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Inontarai manei na inontarai eweFarisi fosa wonong fino Nikodemusi, i mani raminde da kawuru we Yesusi ampa. Nikodemusi nini medu we Farisi mano wei fosa deyo, ");
INSERT INTO amk_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Kariri tane hukuminei mani, inontarai manei wiro utang berahi we taramioai tuti waitawang ne sarawafo kaharai mae ohong aiboifo fafong wei kawurua ne?” ");
INSERT INTO amk_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Ampafe Farisi mano wei fosa emadu wei eteyo, “Wau kontai inontarai Galilea di wau e? Boto Kaiwo Mararebana fo! Na nanai ambori boitawanai we nabi manei wiro da na Galilea ma kaha!” ");
INSERT INTO amk_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Emadu tonanaia kaia fo, ea kiai etaraberasa to ene munufoa. ");
INSERT INTO amk_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Wape Yesusi da to uai Saituni. ");
INSERT INTO amk_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Kameaia wofoi dautaia nanai, Yesusi doari kawuru na Sempaisi ne Munufoi aha, tuti kaiwasa bitoya era weia. Yesusi minohi na wanai mae deunausa. ");
INSERT INTO amk_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Na siari nanai mae mantaunau Kaiwo Musai soi fo manea tuti Farisi manea eha wiwing manei ma, wiwing nani esobui we niari maninawa dena ria mang siai. Etohoni doari rahansa, ");
INSERT INTO amk_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ainanaya emadu we Yesusi eteyo, “Mantaunaune waune, wiwing nini amesobui we niari maninawa dena ria mang siai. ");
INSERT INTO amk_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Na Kaiwo Musai soi fo medurai we wiwing tonina nei mani todoni kontaio ru kamiei soi paria mireha. Ampafe enemutituai todoni?” ");
INSERT INTO amk_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Etutang tonanaifa we esera we ambori Yesusi medu sarawa mani etinggairi we niari sarawai. Wape Yesusi suang terai, tuti soi kaiwo na kahofafo na warakehafo. ");
INSERT INTO amk_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Manamo etanggewari pampang, ampafe doaria doa tirai tuti medu wesa deyo, “Na mea kiai mandoni dino ne pari sasari mani, andino reantenang pari so wiwingnei na kamiei.” ");
INSERT INTO amk_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Yesusi medu tonanai mae, suang nariai aha soi kaiwo na kahofa nuwowongfo na warakehafoi. ");
INSERT INTO amk_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Etaramio Yesusi we medu tonanaifa nanai, mano etinggai wiwingfoi nanisa efouhisa wemansiawarai weru kataifoia, reantenang mani na mano fuba foi paria ehai weru kataifoia. Era wa ehaia sea Yesusi tuti wiwingfoi we doari na katai siari doa nai foi fo. ");
INSERT INTO amk_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ainanaya Yesusi doaria doa tirai tuti medu we wiwingfoi deyo, “Wiwingne wau, inontarai fuba anta nanisai doni ampa? Manei wiro dohong aiboifea tau we wau kaha e?” ");
INSERT INTO amk_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Wiwingfoi yoa we Yesusi deyo, “Daie, bereri.” Yesusi medu wei aha deyo, “Yau kontaio wiro yohong aiboifea tau we wau kaha. Ampafe roa, wape na ninai to fongna mani wiro nari sasarifo ahang fanai.” ");
INSERT INTO amk_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesusi medu we kaiwasa bitoya foi aha deyo, “Yau mani iwefisambewarai we nunei. Mandoni dino daria yau mani da na mamantitifo aha kaha, wape sobu samberawaio kia arangfo.” ");
INSERT INTO amk_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Farisifosa emadu wei eteyo, “Oh! Moduairai kariri mantaung wau terai, nemu kaiwowa wetarai kaha.” ");
INSERT INTO amk_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesusi yoa wesa deyo, “Masino imaduairai kariri mantaung yau terai ki, wape kaiwo imadurai ninai wetarai, weo iwaitawang na doni ira nai ma fo tuti to doni ira wea fo. Wape mea mani meserawawerahai paria, mewaitawang na doni ira nai ma fo ete to doni ira wea fo kaha. ");
INSERT INTO amk_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Mehutu kaiwone kariri todoni inontaraine menenemitituaitafo. Yau mani wiro ikutu kaiwo we inontarai manei kaha. ");
INSERT INTO amk_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Wape masino ikutu kaiwo we inontarai manei mani, kaiwo ikutuai nanai wetarai, weo imeiri yau kaha, mae Dai mano demi yau foi dino kiontai yau ne. ");
INSERT INTO amk_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Na mene Kaiwo Musai soi fo dotu tonina, ‘Uwemandu uwati te fieai tuti umadu kariria mani, kaiwo nanai ahuai we kaiwo wetarai fine.’ ");
INSERT INTO amk_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Yauno imaduairai kariri mantaung yau ne tuti Dai mano demi yau nei kontai meduairai kariri yau.” ");
INSERT INTO amk_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Ainanaya emadu we Yesusi aha eteyo, “Tamamu niai na doni?” Yesusi yoa wesa deyo, “Yau ete Dai, wiro metaroanso auru kaha. Weo masino metaroanso yau mani, metaroanso Dai kontai.” ");
INSERT INTO amk_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Kaiwo nanai Yesusi medurai na Sempaisi ne Munufoi, kefang we katai doi korbani fo watai nai fo. Medu tonanai wape manei wiro tefuri kaha, weo wiro ne rahida mai we etafuri kaharai. ");
INSERT INTO amk_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ainanaya Yesusi medu wesa nariai aha deyo, “Ambori ira weru mea, tuti mesera we yau ki, tuti ambori memarareha na mene sasariwai. To katai ira wei foi kontaio, wiro meraoia kaha rai.” ");
INSERT INTO amk_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Ampafe mano ewenunggamiei we Yahudi fosa emadu eteyo, “Tarahio deyo ming berahi fe, doni medu deyo, ‘To katai iraoi foi wiro mera wa kahai nina.’ ” ");
INSERT INTO amk_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ainanaya Yesusi medu wesa aha deyo, “Mea mani mera na kofane ma, wape yau mani ibiari na yaifai meu. Mera na nunei nini ma, wape yau mani wiro na nunei kaha. ");
INSERT INTO amk_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nanai wedaya anta imadu we mea mau yeyo, memarareha na mene sasariwa ki; weo masino meroasoai we ‘Yau mani mano ahui we YauNeYHWH foi dine’ kaha mani, ambori memarareha na mene sasariwai ki.” ");
INSERT INTO amk_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ainanaya etutang berahi aha eteyo, “Wau mani mandoni di wau tarai ne?” Yesusi medu wesa deyo, “Yau mani, mano kariri fianai anta imadurai na reantenangfo kawuru we meara fo di yau. ");
INSERT INTO amk_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Kaiwo bitoya paria yeyo imadurai kariri mea tuti ikutuai kariri mea. Wape Mano demi yau nei mani Mano mesi we taroasoi dine, tuti fianai aino tarahuoai riati fo, nanai aino imadurai we nunei ne.” ");
INSERT INTO amk_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ewaitawana kaha we fianai aino Yesusi medurai tonana fo kariri Dai. ");
INSERT INTO amk_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ampafe Yesusi medu wesa deyo, “Kio meruai Kaisung Inontarai neia dedai wori, mewaitawanai we YauNe fo ki, tuti ambori mewaitawanai we fi fuba inariri na nufi nini, wiro na mantaung yau kaha. Manta imadu te kariri fianai aino Dai deunauwai we yau fo. ");
INSERT INTO amk_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Tuti Mano demi yau foi weriria yaune, wiro sawing yau imeiri yau kaha, we inari fio eneoa fo pampang fefe.” ");
INSERT INTO amk_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Yesusi medu finanaia kai fo, kaiwasa bitoya eroasoi. ");
INSERT INTO amk_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Mayeai Yesusi medu we inontarai Yahudio eroasoia fosa deyo, “Masino metoaria mutu na nehu kaiwone mani, nehu inontarai di mea tarai, ");
INSERT INTO amk_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","tuti ambori metaroanso ne wetaraifoi, tuti ne wetarai nani ambori wedaya mea mehasau ki.” ");
INSERT INTO amk_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Ainanaya emadu wei eteyo, “Amea mani Abrahami ne riria di amea, wiro amewewoming we manei na ea kaha! Ampafe todonie modu we amea boyo, ambori amehasau nina?” ");
INSERT INTO amk_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Yesusi medu wesa deyo, “Tarai antu! Imadurai we mea mau yeyo, mandoni kontaio niari sasari foi mani, wewoming we sasarifoi. ");
INSERT INTO amk_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Tuti woming manei wiro ne katai na mano yuti foi ne munu rorong fo kaha, wape mantauni ne kaisungfoi mani, ne katai we fitawafa na munu rorong fo. ");
INSERT INTO amk_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ampafe masino Kaisungfoi wedaya mea mehasau mani, mehasau tarai tonanai. ");
INSERT INTO amk_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Iwaitawanai we mea mani Abrahami ne riria di mea, wape merurai we memung yau, weo nehu kaiwone ne katai na menemirorongwai kaha fefe. ");
INSERT INTO amk_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Fianai iwatioai ria Dai fo, finanai aino imadura ne. Tuti tonanai kontai we mea, metohong kariri fianai aino metaramioai ria mene daifoia fo.” ");
INSERT INTO amk_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Ainanaya eroa wei eteyo, “Amene dainei mani Abrahami dine!” Yesusi medu wesa nariai aha deyo, “Masino mene dai dino Abrahami mani, na todoni kontaio menari fianai aino Abrahami niari fo. ");
INSERT INTO amk_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Wape mea mani meteyo memung yau, amani mano imadu kaiwo wetarai itarahuoai ria Allai fo we mea mau ne yau. Abrahami wiro niari fi karira tonana ne kaha! ");
INSERT INTO amk_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Mea mani menari fianai aino mene daifoi niari fo terai.” Inontarai Yahudi fosa emadu wei aha eteyo, “Amea mani wiro arikang ninoi di amea kaha. Amene Daifoi mani mansiari amani Allai mesiri.” ");
INSERT INTO amk_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ainanaya Yesusi medu wesa deyo, “Masino Allai mene Dai dine mani, menemiwawu yau rai, weo ira na Allai ma tuti inayai na ninai nina. Kontai wiro ira na mantaung yau ma kaha, mae andi demi yau ma ne. ");
INSERT INTO amk_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Metafu nehu kaiwo imadura ne kaha, weo wiro mewemambiriu we metaramio nehu kaiwone kaha. ");
INSERT INTO amk_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Mea mani na mene daifoi ma, amani Saminseni, tuti memirising we metohong kariri mene daifoi ne fi dohong wea fo. Andino wemiung inontarai dine na reantenang parifoa ne tuti wiro dohong kariri ne wetaraifo kaha, weo na i mani wiro obu ne wetaraifeai nai kaha. Medu tetofa mani, finani medurai na mantauni ne taraifoi, weo i mani mano tetofa dine tuti tatofafoi weneung nai. ");
INSERT INTO amk_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Imadu ne wetaraifo tonanai ki, wape wiro meroaso yau kaha. ");
INSERT INTO amk_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Na mea mandoni wauno nemu fiainawiaifeai kariri yau we inari sasari ne? Masino imadu kariri ne wetaraifo mani, we fianie meroaso yau kahai nina? ");
INSERT INTO amk_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Allai ne inontarainesa mani, etaramio kaiwo Allai medura fo. Wape mea mani wiro Allai ne inontarai di mea kaha, nanai wedaya memaya we metarami ne kaiwofo kahai nina.” ");
INSERT INTO amk_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Inontarai Yahudi fosa emadu wei eteyo, “Kasau ampa we kaiwo anta amemadurai kariri wau nanai kaiwo wetarai fine, amani inontarai Samaria kerira di wau. Tarai, inggirai dohong wau.” ");
INSERT INTO amk_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Yesusi yoa wesa deyo, “Wiro inggirai dohong yau kaha. Yau mani isomi we Dai tuti wiro mesomi we yau kaha. ");
INSERT INTO amk_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Wiro isera we inontarai etaparanding yau kaha. Mae Manei andino dawiai we iwewonohu tonanafo ne, tuti I mani Mano kiutu kaiwo dine. ");
INSERT INTO amk_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Tarai antu! Imadurai we mea mau yeyo, mano dohong kariri nehu kaiwofo mani, wiro sodai mararehafoi kahai we fitawafa.” ");
INSERT INTO amk_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ainanaya inontarai Yahudi fosa emadu eteyo, “Nina mani amewaitawanai we wau mani tarai inggirai dohong wau! Weo Abrahami mantauni mireha ampa, tonanai kontai we nabifosa kiai. Wape modu boyo, ‘Inontarai mano dohong kariri nehu kaiwofo mani, wiro mireha na ea kaha.’ ");
INSERT INTO amk_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Oh! Wiro fobai sewa Abrahami, mano mirehara foi, kaha fe? Nabifosa kiai kontaio emarareha ampa. Tonana mani mandoni dino titua wau nai ne?” ");
INSERT INTO amk_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesusi yoa wesa deyo, “Masino yeparanding bera mantaung yau mani, finanai wefieai we yau kaha. Mano deparanding yau foi mani Dai, Dai nini dino mesahui we mene Allai dine nanai. ");
INSERT INTO amk_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Wiro metaroansoi kaha tonanai ki, wape yau mani yeroani. Tuti masino imadu yeyo wiro yeroansoi kaha, nana mani yau mani inontarai ipampamu paria di yau, ne tarai kariri mea. Yeroani tuti yohong kariri ne kaiwofo. ");
INSERT INTO amk_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Mene Dai Abrahami piraise paria we deti nehu rahidanei, tuti detioi kawuru ampa tuti mirising wei.” ");
INSERT INTO amk_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ainanaya inontarai Yahudi fosa emadu we Yesusi eteyo, “Wiro nemu defuina piarua sura kahai kontai, tuti boti Abrahami e?” ");
INSERT INTO amk_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yesusi medu wesa aha deyo, “Tarai antu! Imadurai we mea mau yeyo, wiro Abrahami saubaununggamiei kaharai mae, YauNe kawuru ampa.” ");
INSERT INTO amk_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ainanaya inontarai Yahudi fosa eha kamiei we eteyo esoi, manamo Yesusi dediwa werusa, ainanaya da weru Sempaisi ne Munufoia. ");
INSERT INTO amk_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesusi da wa mani deti inontarai manei, inontarai nani urengfafa na siari saubaununggamieifo. ");
INSERT INTO amk_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Yesusi ne inontarai erariati fosa etutang berahi eteyo, “Dai Rabio Mantaunaune waune, mandoni dino niari sasario wedaya inontarai nini urengfafa na siario saubaununggamieifo nina? Mantauni ete ne wawafo suru re?” ");
INSERT INTO amk_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesusi yoa wesa deyo, “Urengfafa tonana fo wiro mantauni ne sasarifoi ete ne wawafo une sasarifo wedaya tonanafo kaha, mae ambori Allai deinawi ne mambiriufo na i. ");
INSERT INTO amk_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Todoni kontaio tanari Mano demi yau nei ne finiarifo na rahidafo. Weo dirufoi ambori da ma, tuti mandoni kontaio wiro yufi kaha. ");
INSERT INTO amk_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Rahida inayai na nufi nina mani, yauno isambewa nufi ne.” ");
INSERT INTO amk_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yesusi medu tonanaia fo mayeai, kendi to kahofa nuwowongfo aweu, tuti fia kandifoi na kahofafo eai, yuaisai ayai piso inontaraifoi urengfo nayai, ainanaya medu wei deyo, ");
INSERT INTO amk_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","“Roa ruai uremuwa na kuru Siloami.” (Siloami nana mani Mano Demi.) Ampafe inontaraifoi da wa yuairurang urengfo na kurufoi. Niari tonanaia kai daraberahi ma fo, detia. ");
INSERT INTO amk_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ne ruramafosa tuti inontarai mano na fafong ewatioi we minohi dedo na rang dereung fosa, emadu kai eteyo, “Oh! Inontarai nini dino raminde minohi dedo we fi na rang dereung fo ne mae?” ");
INSERT INTO amk_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Manea eroa tubarai eteyo, “Tarai andi aranane.” Wape manea kontai eteyo, “Bereri, inontarai nini ureng kariri terai.” Wape mantauni medu wesa deyo, “Yau arana ne.” ");
INSERT INTO amk_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Ampafe emadu wei eteyo, “Todonie boti aha nina?” ");
INSERT INTO amk_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Yoa wesa aha deyo, “Inontarai mano wonong Yesusi foi fia kahofa kuteai na ne kandifoi, ainanaya yuaisai ma piso na urehune tuti medu deyo, ‘Roa ruairurang uremuwa na kuru Siloami.’ Ainanaya ira wa tuti iruairurang urehufo nayai nanai, iwati aha.” ");
INSERT INTO amk_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Etutani eteyo, “Inontarai nani andi doni?” Manamo yoa wesa deyo, “Isera wawerahai.” ");
INSERT INTO amk_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Rahida Yesusi niari kahofa fo, piso inontaraifoi urengfo naya deti nani mani, rahida Sabati dine. Ampafe inontarai arahi deti nani ehari to inontarai eweFarisi fosara. ");
INSERT INTO amk_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Farisifosa kontai etutang berahi kariri todonie deti aha nanai. Ampafe yoa wesa deyo, “Inontaraifoi piso kahofafeai na urehune, mayeai iruai ruramaia tuti iwati aha ninai.” ");
INSERT INTO amk_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Farisifo maneiru teai emadu eteyo, “Inontarai nani wiro da na Allai ma kaha, weo wiro dewawu rahida Sabati foi kaha fefe.” Manamo mano siai wei fosa emadu eteyo, “Inontarai wesasari manei niari fitantuma tonina fea rai e?” Ainanaya esawa wawerasa kariri. ");
INSERT INTO amk_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ampafe etutang bera mano anta urengfafa foi aha eteyo, “Fifianai aino enemutituaitaifa kariri inontarai nani faini ne? Weo wauno niari uremuwa beng tonanai.” Mano detia foi deyo, “I mani nabi dine.” ");
INSERT INTO amk_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Manamo mano ewenunggamiei we Yahudi fosa emaya we eroasoai we inontarai nani mani tarai mano raminde urengfo fafa na siari saubaununggamieifo tuti ninaia mani denteng aha foi dine kaha. Ampafe esahu ne wawafo suru ma, ");
INSERT INTO amk_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","tuti etutang bera suru eteyo, “Taraie mune arikangno urengfafa na siari saubaununggamieifo andi nini e? Todoni fino deti aha ninai?” ");
INSERT INTO amk_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ne wawafo suru umadu ureyo, “Ne auwaitawana mani, tarai aune arikang dine, tuti urengfo fafa na siari saubaununggamieifo. ");
INSERT INTO amk_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Wape todoni deti aha ninaifa mani, auwaitawana kaha. Tuti mandoni dino niariria deti toninai aha ne mani, auwaitawana kahai kontai. Metutang bera mantauni teraifa, fiabai ampa, ampafe mantauni ambori deikaririaifa ki.” ");
INSERT INTO amk_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Wawafo suru umadu tonanai we umatai mano ewenunggamiei we Yahudi fosa, weo ehutuai ampa we mandoni dino meduairai Yesusi weMananu Mampariri dine mani, wenani wiro da to munu agama Yahudi fo afui ahang kaha. ");
INSERT INTO amk_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Nanai wedaya mani wawafo suru umadu ureyo, “Fiabai ampa, metutang teri.” ");
INSERT INTO amk_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ainanaya esahu mano detia nani aha ma, esahui weberu finanaia, tuti emadu wei eteyo, “Fofora na Allai wonongfo we fianai moduraifa fo, modu te ne wetaraifo. Amewaitawanai we inontarai nani mani wesasari.” ");
INSERT INTO amk_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Inontaraifoi yoa wesa aha deyo, “Wesasari ete bereri ete, iwaitawana kaha. Wape fi beyari iwaitawana mani, raminde nanai urehufafa, wape nina mani iwati ampa.” ");
INSERT INTO amk_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ainanaya emadu wei nariai aha eteyo, “Niari fiani we wau? Niari uremuwa todoni e boti aha ninai?” ");
INSERT INTO amk_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Inontaraifoi medu wesa aha deyo, “Yeikaririai kawuru we mea ampa, wape memaya we metaramioa kaha. We fianie meteyo metaramioai nariai aha nina? Tarahio meteyo merariati konta fe?” ");
INSERT INTO amk_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ainanaya eteiberahi paria tuti eteyo, “Wau ro riati ne. Amea mani bereri! Amea mani inontarai ameraria Musa di amea. ");
INSERT INTO amk_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Amewaitawanai we Allai medu we Musai ampa. Wape kariri inontarai nani mani amewaitawang da nayai ma fo kaha.” ");
INSERT INTO amk_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Inontaraifoi medu aha deyo, “Nanai siai paria, dohong yau imarari paria. Weo meteyo mewaitawang katai da nai ma fo kaha, mae andi niari yaua iwati ampa. ");
INSERT INTO amk_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Tawaitawanai we wiro Allai tarao inontarai sasari fosa kaha, mae tarao te mano esomi wei tuti etohong kariri ne awia fosa. ");
INSERT INTO amk_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Na reantenang nunei tibaurai ma fo, wiro tataramio inontarai manei niari weurengfafa na siario saubaunungfo deti kaha rai. ");
INSERT INTO amk_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Masino inontarai nani na Allai ma kaha mani, wiro niari fiea kahai kontai.” ");
INSERT INTO amk_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Eroa wei eteyo, “Sasarine sefang na wau na siari taubau numuwai paria sobu ninai, mae boyo bounau amea re?” Ampafe na siari nanai to fongna fo eteiayari we wiro da to munu agama foi aha fui kaha. ");
INSERT INTO amk_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesusi taraoai we mano ewenunggamiei we Yahudi fosa eteiaya inontaraifoi we wiro da to munu agama Yahudi foi aha kaha. Ampafe sera we inontaraifoia sobui tuti medu wei deyo, “Roaso Kaisung Inontarai nei e?” ");
INSERT INTO amk_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Inontaraifoi bera Yesusi aha deyo, “Daie, mandoni dine? Boikariri we yau ambori iroasoi.” ");
INSERT INTO amk_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesusi yoa wei deyo, “Inontarai nani mani botioi ampa, tuti andino doa medu ria wau nina.” ");
INSERT INTO amk_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Inontaraifoi medu wei aha deyo, “Sengne waune iroasoai,” tuti somi wei. ");
INSERT INTO amk_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ainanaya Yesusi medu deyo, “Ira to nunei ma ninai we ikutu kaiwo, ambori mandoni kontaio urengfafafoi deti, tuti mano deti foi urengfafa.” ");
INSERT INTO amk_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farisi maneiru teaio enayai na nana fosa etaramio kaiwo Yesusi medurai tonana fo, ampafe emadu we Yesusi aha eteyo, “Ampafe boyo amea kontai ameuremifafa e?” ");
INSERT INTO amk_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yesusi yoa wesa deyo, “Masino meuremifafa mani, mewesasari kaha weo mewaitawang ne wetaraifo kaha fefe. Wape meteyo mewati, ampafe tonana mani mene sasariwai niayai pampang.” ");
INSERT INTO amk_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesusi medu aha deyo, “Tarai antu! Imadurai we mea mau yeyo, inontarai mandoni dino suai to rorong fiahung dombafo enayai nai foi afui, wape wiro suai na rahutufoi kaha, mae dautai kutuai na katai siai, wenani mani inontarai mananapi tuti dewa fi dine. ");
INSERT INTO amk_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Wape mano suai na rahutufoi to rorongfoi afui mani, wenani dino wemantahung we dombafosa ne. ");
INSERT INTO amk_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Inontarai tonana nei, mano deitawang wedua rahutufoi fiai rahutufoi wei tuti ne dombafosa etaramio raofuifoi. Sahu ne dombafosa mansiari-mansiari kariri ewonomifo tuti wiwiainsa to boriei. ");
INSERT INTO amk_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Dombafosa era to borieia ehaia mani, mantauni da fonisa mae dombafosa era riati na kurufuifo, weo etaroanso raofuifo fefe. ");
INSERT INTO amk_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Wape weinontarai aisei nei mani, dombafosa emaya we era riati kaha, kontai emito werui, weo etaroanso inontarai tonana fosa eraomifuifoi kaha fefe.” ");
INSERT INTO amk_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesusi deiriri fiyiwansoai nani wesa, wape etafu fianai aino yiwansoai tonanai wesa fo kaha. ");
INSERT INTO amk_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ampafe Yesusi medu nariai aha deyo, “Tarai antu! Imadurai we mea mau yeyo, yau mani rahutu we dombafosa foi di yau. ");
INSERT INTO amk_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Mano era foni yau kawurua fosa mani, ea kiai mananapi tuti mantawa fi saine, mae dombafosa wiro etarami eraomifuifo kaha. ");
INSERT INTO amk_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Yau mani rahutu di yau. Mandoni dino suai na yau mani, ambori sobu faririfo ki, i ambori suayai dariai tuti sobu ninoi kehe foi. ");
INSERT INTO amk_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Mananapinesa era terai ma we ehamananapi, we emung tuti we emei fi pariao woru. Wape yau mani ira ma we ambori esobu arangfo tuti esobuai na bitoya funomai. ");
INSERT INTO amk_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yau mani mantahung denteng foi di yau. Mantahung denteng foi dohong ne taraifoi we ne dombafosa. ");
INSERT INTO amk_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Mae inontarai mano yufi we sobu fiembaitai tuti wiro ne te dombafosa kaha foi, serigala manei mito ma we mingno dombafosa mani, ambori mito weru dombafosa tuti serigalafoi mingsa tuti kiatatesa. ");
INSERT INTO amk_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Inontarai nani mito weru dombafosa, weo i mani yufi terai we sobu fiembaitafo tuti wiro enetituai we dombafosa aha kaha. ");
INSERT INTO amk_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Yau mani mantahung denteng foi di yau. Yeroanso nehu dombafosa tuti nehu dombafosa etaroanso yau, ne tarai toyari Dai we deroanso yaufo tuti yau kontai yeroanso Dai. Tuti yohong nehu tarainei we nehu dombafosa. ");
INSERT INTO amk_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Wape yau kontai nehu domba siai fea kontai, domba nanisa wiro na domba rabuangno enayai na wore rorongfe ninisa kaha; domba nanisa todoni kontaio iwiwiainsa kontai tuti ambori etarami raohufuinei. Ea kiai ambori ewerabuang boyari ria ene mantahungnei. ");
INSERT INTO amk_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Dai enewawu yau we yohong nehu tarainei imireha ambori isobui aha fefe. ");
INSERT INTO amk_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mandoni kontaio wiro kia nehu taraifoi weru yau kaha, mae yohong nehu taraifoi imireha tonanafo kariri mantaung yau nehu awiafo. Nehu mambiriu we yohoni tonanai tuti nehu mambiriu kontai we ikari aha. Finana mani fio Dai demi yau weai we inari fine.” ");
INSERT INTO amk_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Yesusi medu tonanafo wedaya Yahudifosa wiro eweboyari ahang kaha mae esawasa. ");
INSERT INTO amk_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Bitoya na sa emadu eteyo, “Inggira dohoni tuti wefiauwou ampa! Ampafe tataramioi we fiani?” ");
INSERT INTO amk_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Manamo manea kontai emadu eteyo, “Inontaraio inggira dohoni nei mani wiro medu tonana kaha! Inggiranei niari inontarai urengfafa manei denteng rai e?” ");
INSERT INTO amk_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Waroi ahang kahai mae, tete rahida inontarai Yahudi fosa etansua Sempaisi ne Munufoi na bendari Yerusalemi. Na rabuang bonani mani tete danunanangfo ne diru neung finana. ");
INSERT INTO amk_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yesusi niayai da wawerahai na Allai ne Munufoi refongfo, amani refong esahuai we Refong Salomoi fo. ");
INSERT INTO amk_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ainanaya inontarai Yahudi fosa era etoa wari Yesusi. Emadu wei eteyo, “Tua amea amenemiwawera we wau kidoni wo? Masino Mananu Mampariri foi di wau mani, boikaririaia kasau we amea tonanai.” ");
INSERT INTO amk_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yesusi medu wesa deyo, “Yeisaharai kawuru we mea ampa wape meroasoa kaha. Fio inari na Dai wonongfo kai, finanai wefiainawiai we mea kariri yau ampa. ");
INSERT INTO amk_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Wape meroasoa kaha weo wiro mehontai na nehu domba rabuangfoi kaha fefe. ");
INSERT INTO amk_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nehu domba nanisa etaramio raohufuinei, tuti yeroansosa tuti era ria yau. ");
INSERT INTO amk_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Yohongno numainufo wesa tuti wiro esobu ne karirafo ahang kahai we fitawafa. Mandoni kontaio wiro dewasa weru warahune kaha. ");
INSERT INTO amk_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Dai mano dohonsa we yau foi, fiabai sewa mandoni kontai, tuti mandoni kontaio wiro dewasa weru Dai warangfo kaha. ");
INSERT INTO amk_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Dai tuti yau mani auwemansiari.” ");
INSERT INTO amk_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ainanaya inontarai Yahudi fosa eha kamieifo aha we eteyo eso Yesusi. ");
INSERT INTO amk_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Manamo Yesusi medu wesa deyo, “Fitantumao na Dai ma fo aino bitoya yeinawiai we mea ne. Na fi bitoya yeinawiai tonana fo, doni aino wedaya mea meteyo meru kamieio yau weai nina?” ");
INSERT INTO amk_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Inontarai Yahudi fosa emadu wei eteyo, “Ameteyo ameru kamieio wau toninafo, wiro we fi bengno nari fo kaha, mae we boibera Allai fo. Wau mani inontarai batang di wau, wape boyo wau mani Allai di wau.” ");
INSERT INTO amk_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ainanaya Yesusi medu wesa aha deyo, “Na mene Kaiwo Mararebana foi dotu kariri mene wawafosa, amani na kaiwo rabuangno Allai medu deyo, ‘Isahu mea kiai weseng di meara.’ ");
INSERT INTO amk_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Tawaitawanai we fianai dotu na Kaiwo Mararebana fo mani, kaiwo nanai wiro wioru kaha. Ampafe masino Kaiwo Mararebana fo deyo, ‘Seng di mea,’ tonanai we mano esobu kaiwo nani fosa mani, todoni kontai yau tonanai kontaia! ");
INSERT INTO amk_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Weo yau mani Dai Allai diri yau we mantauni nengfoi di yau, tuti demi yau to nunei meu. Tonana mani we fiani metinggai yau we yeibera Allai nina, na nehu kaiwo imadurai yeyo Allai ne Kaisung di yau fo nina? ");
INSERT INTO amk_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Masino inari kariri fianai aino Dai demi yau weai we inari fo kaha mani, wiro meroaso yau fanai. ");
INSERT INTO amk_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Wape masino inari kariri fio Dai demi yau wea fo tuti memaya we meroaso yau kaha, tonana mani meroaso te fianai aino inari nanai. Ambori na tonanane mewaitawanai tuti metafurai we Dai niayai na yau tuti yau kontai inayai na Dai.” ");
INSERT INTO amk_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ampafe erurai nariai aha we etafu Yesusi manamo kiaharai weru ewaramifoa. ");
INSERT INTO amk_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesusi daraberahi to waya Yardeni dereung dowei fo, to katai raminde Yohanesi webaptisi nai foi tuti niayai na nanai. ");
INSERT INTO amk_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Na nanai kaiwasa bitoya era weia. Emadu eteyo, “Yohanesi wiro niari fitantuma kutu boyari kahaia, wape fi kiaio medurai kariri inontarai nini fo wetarai ampa.” ");
INSERT INTO amk_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Tuti kaiwasa bitoya na nana fosa eroaso Yesusi we Mananu Mampariri na Allai dine. ");
INSERT INTO amk_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Inontarai manei wonong fino Lazarusi, minohi ria rorowingno Mariai tuti Martai suru na munue Betania na nu Yudea foi. Inontarai nani meninang. ");
INSERT INTO amk_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mariai nini mani wiwingno raminde sari maning nunsai mampori foi mae sara Yesusi awengfo tuti dufi na nurandaungfo foi dine. Tuti roromang dino Lazarusi mano meninang nani. ");
INSERT INTO amk_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ampafe rorowingfo suru uranatu kaiwo we Yesusia uraikaririai wei ureyo, “Sengwa waune, mano enemuwawuti nei meninang.” ");
INSERT INTO amk_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesusi tarao kaiwofo nanai medu deyo, “Fimaninang nani wiro kia marareha kaha, wape ambori deinawi Allai ne sambewaraio dedai fo, weo na maninang nani wedaya inontaraine etaparanding Allai ne Kaisungfoi.” ");
INSERT INTO amk_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesusi tarai enewawu Martai, Mariai tuti Lazarusi. ");
INSERT INTO amk_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Wape, tarao kaiwofo we Lazarusi meninang nanai, da ahera wa kaha, mae niayai rahida boru aha. ");
INSERT INTO amk_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Wape mayeaia mani medu we ne inontarai erariati fosa deyo, “Tatarabera tata to nu Yudea foi aha.” ");
INSERT INTO amk_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ampafe eroa wei eteyo, “Dai Rabio Mantaunaune waune! Ararafanai ninai, inontarai Yahudi fosa eteyo eru kamieio wau, tonanai mae boyo barabera wau to wanai aha nina e?” ");
INSERT INTO amk_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Manamo Yesusi yoa wesa deyo, “Mewaitawana kahai we na wofoi dautafo paria sobu sawafo mani, araha ureng suraya borufo ne? Mandoni dino da na rahidafo mani, wiro sodai kaha, weo deti fio sambewa nufi nini fefe. ");
INSERT INTO amk_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Wape da na dirufo mani sodai, weo sambewarafo nayai na i kaha.” ");
INSERT INTO amk_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesusi medu tonanai, mayeai medu aha deyo, “Tane maniwowirio Lazarusi dena ampa, wape ambori ira wa we ibauni ki.” ");
INSERT INTO amk_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Ampafe ne inontarai erariati fosa emadu eteyo, “Sengne waune, masino Lazarusi dena mani, ambori denteng ki.” ");
INSERT INTO amk_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Weo etafu sara Yesusi kaiwo medu tutirai we deyo, Lazarusi denafo, ewaitarahio dena tarai tonanai, wape Yesusi medu tonanafo mani deyo Lazarusi mireha. ");
INSERT INTO amk_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nanai wedaya Yesusi medu parai deyo, “Lazarusi mireha ampa. ");
INSERT INTO amk_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Wape ifaraise kontai weo wiro inayai na wanai tete ne tonanafo kaha fo. Weo nana mani beng paria we mea ambori meroasoai. Ampafe tara we Lazarusia.” ");
INSERT INTO amk_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tomasi, mano ahui kontai we Didimusi foi medu we ne maniwowiri eraria Yesusi fosa deyo, “Tara riati kontai, ambori tamarareha riati.” ");
INSERT INTO amk_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Rahida bo Yesusi sobu katai nani fo, Lazarusi mireha esaraia we rahida boa na fafo rorong foa. ");
INSERT INTO amk_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Betania mani watai kefang we bendari Yerusalemi, waroifo tarahio kiro botoru rai. ");
INSERT INTO amk_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Inontarai Yahudi bitoya era wa etuambawa Martai tuti Mariai uru, we enari unemirorongfoi mitubaru aha weo unemirorongfoi fituayai we uroromifoi fefe. ");
INSERT INTO amk_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Martai taraoai we Yesusi da wa nanai, dari weru munufoi da weu Yesusia, mae Mariai mani minohi na munu rorongfo. ");
INSERT INTO amk_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Martai medu we Yesusi deyo, “Sengne waune, masino nayai na nina fea reti, rorohunei wiro mireha kahai ki. ");
INSERT INTO amk_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Tonanai ki wape nina mani iwaitawanai we Allai ambori dohongno fianai kontai aino butani wea fo ki.” ");
INSERT INTO amk_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesusi medu we Martai deyo, “Roromuwai ambori suwi nariai aha ki.” ");
INSERT INTO amk_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Martai yoa wei aha deyo, “Iwaitawanai we na rahida Sempaisi kife nuneifo mani, Lazarusi ambori suwi aha ki.” ");
INSERT INTO amk_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Yesusi yoa wei aha deyo, “Yauno yohong anseng we kaiwasanei tuti yuwi inontarai emarareha nesara esuwi aha ne. Mandoni dino yoaso yau mani, mireha ki wape ambori darang aha. ");
INSERT INTO amk_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Tuti mano etarang nesa, amani mano eroaso yau fosa, wiro emarareha kahai we fitawafa. Roaso fininaifa ne?” ");
INSERT INTO amk_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Martai yoa wei deyo, “Yo, Sengne waune, iroasoai we wau mani Mananu Mampariri foi di wau, Allai ne Kaisungno dererai na fafongfa we ro to nunei ma foi di wau.” ");
INSERT INTO amk_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Martai medu tonanaia fo, mayeai da wa sahu ne tahatuio Mariai, seimumung wei deyo, “Dai mantaunaufoi niayai na wanafo, dutang we wau.” ");
INSERT INTO amk_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mariai tarao kaiwofo nanai, sikahera doa bariri tuti da we Yesusia. ");
INSERT INTO amk_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Rabuang bonani mani, Yesusi wiro da to munuefo afui kaha wo, mae minohi na katai anta sobu Martai naya fo. ");
INSERT INTO amk_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Inontarai Yahudio efanduhisa ria Mariai we etohong kaiwo wawori wei fosa, ewati Mariai doabariri tuti sikahera da to boriei tonanafo, ea kontai era riati. Weo ewaitarahio da to fafofo we sai nayai. ");
INSERT INTO amk_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mariai da wa sobu katai Yesusi minohi nai foi tuti detioi nanai, sau aweu wiatai na awerengfo tuti medu deyo, “Sengne waune! Masino nayai na nina fea reti, rorohunei mireha kahai ki.” ");
INSERT INTO amk_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Yesusi deti Mariai we saifo tuti inontarai Yahudi era riatia fosa kontai we esaifo nanai, enerorongfoi fituayai paria. ");
INSERT INTO amk_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ampafe dutang berasa deyo, “Metohoni wiatai na doni?” Eroa wei aha eteyo, “Sengne waune, ro ma botio katai wiatai nai foi.” ");
INSERT INTO amk_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ainanaya Yesusi saia. ");
INSERT INTO amk_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Ampafe inontarai Yahudi fosa emadu eteyo, “Mewatia, enewawu Lazarusi fuba paria.” ");
INSERT INTO amk_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Wape manea kontai emadu eteyo, “I mani inontaraio niari mano urengfafa foi deti aha, todoni fino wemambiriu we dirapa mararehafoi ambori wiro Lazarusi mireha kahai nina?” ");
INSERT INTO amk_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Yesusi enerorongfoi fituayai nariai aha, da sobuo fafofoa. Fafofoi mani kamirei kamiei dine, tabung wedua borongfo na kamiei fiabai. ");
INSERT INTO amk_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Medu deyo, “Metadoi kamieinei weruai!” Lazarusi mano mireha foi rorowingno Martai medu we Yesusi deyo, “Manamo, Sengne waune, piro ampa, weo araia ne rahida boa finina.” ");
INSERT INTO amk_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Manamo Yesusi medu we Martai aha deyo, “Taramuo kaiwo anta imadurai we wau yeyo, roasoa mani ambori boti Seng Allai ne sambewaraio dedai fo ki e?” ");
INSERT INTO amk_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ampafe mano era wa fosa etadoi kamieifoi weru kamirei borongfoa. Mayeai Yesusi fioai urengfo deti to rorafaisi tuti medu deyo, “Daie, yohong mahikai we wau weo taramuo yau ampa fefe. ");
INSERT INTO amk_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Iwaitawanai we taramuo yau pampang, wape na ninai kaiwasa bitoya etoawari yau ampafe yeyo imadu tonanai, ambori eroasoai we wauno bemi yau ma ne.” ");
INSERT INTO amk_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yesusi medu tonanaia kai fo, sahu na raofui fiabai deyo, “Lazaruse, ro to boriei mandiei!” ");
INSERT INTO amk_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Na tatofang kutu nanai, inontarai mirehara nani darang aha tuti kiawariai ariei, wape wiro da kifadei kaha, weo ne taraifoi ansania mutubaru na ireu biua fo rai fefe. Tuti urengfo tabung weduarai na ireuo fanahang tuti sayaha. Ainanaya Yesusi medu we kaiwasa fiau foi deyo, “Merehu ireu ansang ne taraifoi naya wa tuti ne tabung wedua urengfe naya wa, tuti metawini da wa.” ");
INSERT INTO amk_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ampafe inontarai Yahudi bitoyao era wa efata Mariai fosa ewati te fitantuma Yesusi niari tonana fo, ne faufosa eroaso Yesusi we ene Seng dine. ");
INSERT INTO amk_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Wape maneiru teai na sa era wa eteikaririai we Farisifosa kariri fitantuma Yesusi niari nanai. ");
INSERT INTO amk_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ainanaya imami baba fosa tuti Farisifosa esahu Majelisi Agama fosa ma efanduhisa tuti emadu eteyo, “Fianai aino tanari ne, we inontarai wani niari fitantuma tuti fiainawiai bitoya paria. ");
INSERT INTO amk_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Weo masino tatuati niari pampang tonana mani, ambori kaiwasa bitoya eroasoi. Tuti finanai wedaya inontarai Roma fosa era ma we emei Allai ne Munu Mirarebanai na Yerusaleminei tuti enari inontarai Israeli ne tatara taworu ki.” ");
INSERT INTO amk_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Manamo manei na sa amani Kayafasi, imamio na defuina bonani mani weimami fuba foi, medu wesa deyo, “Mewaitawang fiea kaha, ");
INSERT INTO amk_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","tuti mewaitawana kahai we mansiari mireha we kaiwasa bitoya foi, nanai beng sewa weru tane rai na nu Israeli ne emarareha tantenang fo ne.” ");
INSERT INTO amk_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kayafasi medu tonanafo, wiro medu na mantauni kaha, mae medu na wangno imami fuba yu na defuina bonani fo. Medu toyari nabi manei we ambori Yesusi mireha we inontarai na nu Israeli foi, ");
INSERT INTO amk_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","tuti wiro we nu Israeli foi tera kaha, mae we fianduhi Allai ne arikangno enayai tatera fosa kiai ambori fianduhisa weboyari na Allaifo. ");
INSERT INTO amk_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ampafe na rahida bonani to fongna fo emadu ruhiai eweboyari we emung Yesusi. ");
INSERT INTO amk_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ampafe Yesusi wiro kiawari parai na kaiwasa bitoya foi na inontarai Yahudi fosa euremireafo ahang kaha, wape dontai na nanai to katai kefang we katai sarahiai wewui fo, amani to bendario Efraimia. Niayai na wanai ria ne inontarai ewesuraya mandu fosa. ");
INSERT INTO amk_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Rabuang bonani mani, rerai we inontarai Yahudi fosa ene rahida Paska foi. Ampafe wiro etohonsua rahida Paska foi kaharai mae, kaiwasa bitoya na munuefo era kawurua to Yerusalemia we eruairuransara emararebanai kariri ene koangfoi. ");
INSERT INTO amk_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Na wanai kaiwasa nanisa esera we Yesusi tuti etoari na Allai ne Munufoi rorongfo mae emadu wawerasa eteyo, “Menemitituai tofino, Yesusi da kontai to rahida Paska nei ma rai e?” ");
INSERT INTO amk_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Tuti imami baba fosa tuti Farisifosa, etohong kaiwo pondoayai kawurua we mandoni dino deitawang Yesusi we niayai na doni mani, todoni kontaio deikaririai wesa ambori era wa etafuri. ");
INSERT INTO amk_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Rahida wonang aha werahida Paska foi, Yesusi da to munue Betania, amani Lazarusi mano raminde Yesusi duwiria suwi na marareha rorong foi ne munuefo. ");
INSERT INTO amk_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Na nanai Lazarusi itorohong muniara bei we etamang we Yesusi na munufoi. Martai wesarawiri wesa tuti Lazarusi tuti mano wenotisa fosa ewatai etampi ruhiai ria Yesusi. ");
INSERT INTO amk_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ainanaya Mariai kia maning niunsai mampori literi mairabuang feai ma. Maning nani mani enariri na ai newao niunsai mampori tuti ne harga dedai paria. Sari maningfoi to Yesusi awengfo aweu, ainanaya dufi na mantauni nurandaungfo aha. Maningfoi ne niunsai mampori fo wedaya munufoi sentenang niunsai mamporia. ");
INSERT INTO amk_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Wape Yudasi Iskarioti, Yesusi ne inontarai dariatio katu mani dewayani foi medu deyo, ");
INSERT INTO amk_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“We fianie maning ne harga dedai tonana nei wiro awayani obu doi dinari piaring webetoru (300), tuti doi nanai ohonai we mano ene pari fi fosa kahai nina?” ");
INSERT INTO amk_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Yudasi medu tonanafo, wiro weo urengfo nayai na mano ene pari fi fosa kaha, wape we i mani mananapi dine. Weo wea mani kia doio watai na ene kasifoi, doi nani andino yuti ne. ");
INSERT INTO amk_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Wape Yesusi medu deyo, “Metawing wiwingnei niari kariri fianai aino deyo niari ninai, weo fio niari tonina ne, meinenang yau we rahida imereha foi. ");
INSERT INTO amk_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Weo inontarai ene pari fi fosa mani, rahida neungne enayai ria mea, wape yau mani wiro inayai ria mea pampang kaha rai.” ");
INSERT INTO amk_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Inontarai Yahudi bitoya etaramioai we Yesusi niayai na Betania, ampafe era weia. Era wa fo wiro we ewati Yesusi tera kaha, mae we ewati Lazarusi kontai we Yesusi duwiria suwi na marareha rorong foi aha fo. ");
INSERT INTO amk_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ampafe imami baba fosa emadu ruhiai we emung Lazarusi kontai. ");
INSERT INTO amk_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Weo na i, inontarai Yahudi bitoya era werusa tuti eroaso Yesusi aha. ");
INSERT INTO amk_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Kameaia mani, kaiwasa bitoyao da kawurua we dohonsua rahida Paska foi etaramioai we Yesusi da to bendari Yerusalemia nanai, ");
INSERT INTO amk_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","eha kafadei baya fo, ainanaya era wa etamang wei. Yesusi da wa kiawariai nanai esahu na eraomifui fiabai eteyo, ");
INSERT INTO amk_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesusi sobu keledai antung manei, tuti dautai nai, ampafe mai kariri Sempaisi ne Kaiwo dotu deyo, ");
INSERT INTO amk_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Kadawing Sioni wa waune, mutai fanai! Botia, nemu Mananufoi da ma ne, dautai na keledai antung manei!” ");
INSERT INTO amk_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Rahida nanai, Yesusi ne inontarai ewesuraya mandu fosa etafu kaiwo dotu tonanafo na mai kaharai. Wape kio Allai yuai Yesusi dedai sambewarai na rahida suwiri na marareha rorong fo wori, arahio earomioai we fianai aino inontaraifosa enari we Yesusi nanai, Allai soi kawuru na Kaiwo Mararebana fo kariri ampa. ");
INSERT INTO amk_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Inontaraio raminde enayai na wanai ria Yesusi na rahida sahu Lazarusi na marareha rorong fo mandiei fosa, emadu kariri finanai pampang. ");
INSERT INTO amk_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Nanai wedaya kaiwasa bitoya foi da we Yesusia, weo etaramioai we andino niari fitantuma nana ne. ");
INSERT INTO amk_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ampafe Farisifosa emadu wawerasa eteyo, “Tawefieai ahang kaha! Weo tawatioai we nunei sentenang erariati ampa!” ");
INSERT INTO amk_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Na kaiwasa era wa we etohonsua rahida Paska foi nanisa mani, inontarai Yunani maneiru teai ehontai. ");
INSERT INTO amk_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Inontarai Yunani nanisa era wa emadu we Pilipusi eteyo, “Doroi waune, ametohong weai paria we amemadu ria Yesusi.” (Pilipusi nini mani na bendari Betsaida na nu Galilea foi.) ");
INSERT INTO amk_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ampafe Pilipusi da wa deikariri kaiwofo we Andareasi, tuti mayeai ura wa uraikarirai we Yesusi. ");
INSERT INTO amk_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Wape Yesusi medu deyo, “Rahidafe mai ampa we Kaisung Inontarai nei Allai yuaisia dedai sambewarai. ");
INSERT INTO amk_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Tarai antu! Imadurai we mea mau yeyo, masino patibu bong bei wiro memasa kahai tuti tanami toyari arai inontarai marareha na kahofafo kaha mani, weboyari pampang tonanai. Wape patibu bong boyari nani memasa tuti arai na kahofafoi mani, ambori tifu aha tuti wedaya bong bitoya aha. ");
INSERT INTO amk_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Mandoni dino enewawu mantauni ne ansengfoi ambori ne ansengfoi wioru ki, mae mandoni dino na nufi ninai wiro enewawu ne ansengfoi kaha, nana mani wenani dewawu ne ansengfoi we ambori sobu numainufo. ");
INSERT INTO amk_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Mandoni dino deyo wemangfata we yau mani, todoni kontaio da ria yau, tuti inayai na doni mani, mangfata nani niayai na nanai kontai. Mandoni dino fiata yau mani, Dai na rorafaisi somi we wenani. ");
INSERT INTO amk_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Enehurorongnei fituayai paria, wape yeyo imadu fiani? Imadu yeyo, ‘Daie, ka yau weru fi dadira ninaifa,’ ne? Wiro tonana kaha, weo we isodai dadira ninaifa aino wedaya ira weaifa ma ne. ");
INSERT INTO amk_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Daie, nari wonomuwai ao dedai sambewarai!” Ampafe raofui bei sahu na rorafaisi meu deyo, “Inari wonohune dedai sambewarai ampa, tuti inariri dedai sambewarai nariai aha.” ");
INSERT INTO amk_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Kaiwasa bitoyao etoari na nana fosa etarami raofuifoi, ampafe emadu eteyo, “Kadidu dine!” Wape manea kontai emadu eteyo, “Bereri! Wewai dino medu wei ne!” ");
INSERT INTO amk_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ainanaya Yesusi medu wesa deyo, “Raofui nani medufo, wiro we yau kaha, mae we mea. ");
INSERT INTO amk_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ninaia mani rahidafe mai we Allai kiutu kaiwo kariri nunei to. Tuti ninaifa kontaio Allai ambori so mananu nunei foi, amani mano kerira pari foi, to boriei. ");
INSERT INTO amk_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Tuti rahida eruai yaua itawai yedai na nunei fo mani, ambori irabi kaiwasanei kiai da we yau ma ki.” ");
INSERT INTO amk_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesusi medu tonanafo we deinawiai we todoni ambori mirehafo. ");
INSERT INTO amk_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ainanaya kaiwasa bitoya foi emadu wei eteyo, “Na Kaiwo Musai soi fo, amewaitawanai we Kristusio ahui we Mananu Mampariri foi mireha kahai mae minohi darang we fitawafa, ampafe todoni fino boyo, ‘Kaisung Inontarai nei todoni kontaio yuaisia dedai,’ nina? Tuti Kaisung Inontarai nei mani mandoni dine?” ");
INSERT INTO amk_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Yesusi medu wesa aha deyo, “Sambewaranei niayai ria mea na ninai we rahidafeai waroi aha kaha. Ampafe Sambewaranei niayai rahang mea nina ne rai mani, mera nai, bereri mani mamantitifoi soru mea rai. Weo mano da na mamantitifo mani, wiro deitawang da weafo kaha. ");
INSERT INTO amk_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Meroaso Sambewaranei na rahida Sambewara nani niayai rahang mea nina ne, ambori mewearikangno Sambewarai.” Yesusi medua kai tonanafo, da wa dediwa werusara. ");
INSERT INTO amk_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Yesusi niari fitantuma bitoya paria na inontarai Yahudi fosa euremireafo, tonanai ki wape wiro eroasoi kaha. ");
INSERT INTO amk_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Finanai ambori mai kariri Sempaisi ne Kaiwo nabi Yesayai medurai deyo, “Sengne waune, toyari manei wiro yoaso kaiwo amemadura ne kahaia. Tuti boinawi nemu mambiriufo wesa tonanai ki, mae eroasoa kaha ne rai.” ");
INSERT INTO amk_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Nanai wedaya wiro ewemambiriu we eroasoa kahai, weo Yesayai medurai kawuru kontai ampa deyo, ");
INSERT INTO amk_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Allai medu deyo, ‘Yau inari euremifoa kabe tuti enemirorongfoia mitubaru, ambori wiro ewati fi inari nanai na euremifo fanai, tuti etafurai na enemitituaitafo fanai. Ambori wiro etaraberasa we yau ma we inarisa ebeng fanai.’ ” ");
INSERT INTO amk_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Yesayai medu tonanai we deti Yesusi ne sambewaraio dedai fo kawuru ampa tuti medu kariri Yesusi tonanai. ");
INSERT INTO amk_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Tonanai ki wape mano ewenunggamiei we Yahudi fosa bitoya eroasoi kontai. Wape wiro eteiai ene eroasoai nanai para kaha, weo ematai Farisifosa we dohonao na tonanane etatasa weru munu agama fo fe. ");
INSERT INTO amk_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Weo mano ewenunggamiei we Yahudi nanisa esera terai we inontarai etaparandinsa, sewa weru Allai deparandinsa fo. ");
INSERT INTO amk_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ainanaya Yesusi sahu deyo, “Mandoni kontaio yoaso yau fo mani, wiro yoaso yau tera kaha, mae yoaso Mano demi yau foi, ");
INSERT INTO amk_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","tuti mandoni dino deti yau fo mani, wenani kontaio deti Mano demi yau ma foi. ");
INSERT INTO amk_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Weo ira to nunei ma nina ne we iweSambewarai, ambori mandoni saino eroaso yau fo mani, wiro enayai na mamantitifo aha fanai. ");
INSERT INTO amk_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Mandoni dino tarao nehu kaiwofo wape wiro dohong kariria kaha mani, wiro ikutu kaiwo kariri kaha. Weo wiro ira ma we ikutu kaiwo we nunei kaha, mae ira ma we ifariri nunei. ");
INSERT INTO amk_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Mandoni dino deiaya yau tuti wiro tarao nehu kaiwofo kaha mani, sobu aiboifo rai, weo nehu kaiwo imadura fo aino dinggairi tuti kiutu kaiwo kariri wenani na rahida Sempaisi kife nunei nai foi ne. ");
INSERT INTO amk_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Weo wiro imadu na mantaung yau kaha, wape Dai, mano demi yau foi, andino demi yau we imadu fianai aino todoni kontaio imadurai we meafo ne. ");
INSERT INTO amk_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Tuti iwaitawanai we ne kaiwo pondoai we inontarainesa fo dohonsa eminohi we numainu. Ampafe fianai aino imaduraifa fo, imadurai kariri kaiwo Dai demi yau we imadura fo.” ");
INSERT INTO amk_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Rerai we rahida Paska foi, Yesusi deitawanai we ne rahidafo mai we da weru nunei, daraberahi we Dai aha. Yesusi enewawu ne inontaraifosa paria, amani ne inontarai eroasoi enayai na nunei ninisa, tuti enewawusa pampang paria werea naya fo. ");
INSERT INTO amk_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Yesusi minohi dampi diruai ria ne inontarai ewesuraya mandu fosa tonanai, tuti Saminseni weanggariri Yudas Iskarioti, Simoni antungfoi kawurua, medu wei na enerorongfoi we ambori dewayang Yesusi. ");
INSERT INTO amk_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesusi deitawanai we Dai na rorafaisi dohongno mananufo wei ampa we yu fifiani kontai, tuti deitawanai kontai we da na Allai ma tuti ambori daraberahi we Allai aha. ");
INSERT INTO amk_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Ainanaya doari ayai, disu ne ansung boriei foi, tuti yu ireu aburung feaia wiora na enerabuangfo, ");
INSERT INTO amk_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","mayeai wiowu merehafeai na loyang bei tuti da mae yuairurang ne inontarai ewesuraya mandu fo eawemifo, tuti dufi eawemifo na ireu aburung wiorahi na enerabuangfo nanai. ");
INSERT INTO amk_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Niari finanai paria sobu Simon Petrusia mani, Simon Petrusi medu wei deyo, “Sengne waune, wiro ruairurang awehune kaha fe?” ");
INSERT INTO amk_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ampafe Yesusi medu wei deyo, “Fianai aino inari ninai wiro boitawana kaharai, wape ambori boitawanai ki.” ");
INSERT INTO amk_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Petrusi medu wei deyo, “Nana fanai, todoni kontaio wiro ruai awehune fanai!” Wape Yesusi medu wei deyo, “Masino iruairurang wau kaha mani, wiro kontai yau kaha.” ");
INSERT INTO amk_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Ampafe Simoni medu wei deyo, “Sengne waune, tonana mani wiro ruairurang awehune tera fanai, mae warahu tuti nuhukamieinei kontai!” ");
INSERT INTO amk_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Yesusi medu wei aha deyo, “Mandoni dino deriaia fo mani, mirarebanai kiai ampa, ampafe wiro yuairurang ne taraifoi ahang kaha, mae awengfo terai aino yuairurama ne. Tuti memararebanai ampa, wape wiro mehai tonana kaha.” ");
INSERT INTO amk_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(Yesusi deitawang mandoni dino ambori dewayani fo ampa, doni medu deyo, “Wiro meara mehai memararebana kahai” nina.) ");
INSERT INTO amk_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesusi yuairurang eawemifoa kaia, mayeai yuai ne ansung boriei fo aha sensuni tuti daraberahi to ne katai minohi nai foi aha. Ainanaya medu wesa deyo, “Mewaitawang fi arahi inari we mea ninaifa ne? ");
INSERT INTO amk_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Mesahu yau we Mantaunau tuti Seng, tuti kaiwo memadurai tonana fo tarai, weo yau mani Mantaunau tuti Seng di yau. ");
INSERT INTO amk_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ampafe masino yau mene Mantaunau tuti Seng di yau, tuti iruairurang meawemiwa weo iwewoming we mea tonana mani, mea kontai na todoni feai kontaio meruairurang wawera meawemiwa tonanai, amani mewewoming wawerahai we mea tonanai. ");
INSERT INTO amk_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Weo yohong fiainawiai nanai we mea ampa, ambori mea kontai menari kariri fianai aino inari we mea tonanaia fo. ");
INSERT INTO amk_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Tarai antu! Imadurai we mea mau yeyo, woming manei wiro dedai sewa mano yufi wei foi kaha, tuti mano emi foi wiro dedai sewa mano demi foi kaha. ");
INSERT INTO amk_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Mewaitawang fininai na mai ampa, ampafe metohong kaririaia mani, mesobu ne maifo rai.” ");
INSERT INTO amk_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Yesusi medu aha deyo, “Fianai aino imadurai ninai wiro kariri mea kiai kaha, weo iwaitawang mandoni saino yirisara fo. Wape fianai aino dotu na Kaiwo Mararebana fo todoni kontaio kaririai, amani: ‘Mano kionta yau dang nehu rotine mani, wenani ambori biari nehu rewangguainei ki.’ ");
INSERT INTO amk_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Finanai wiro kawaria kaharai mae yeikaririai fafong we mea, ambori finanai kariria mani, meroasoai we yau mani mano ahui we YauNe foi dine. ");
INSERT INTO amk_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Tarai antu! Imadurai we mea mau yeyo, mandoni dino demang we mano yemi foi na mai mani demang we yau kontai. Tuti mandoni dino demang we yau mani, demang we Mano demi yau foi.” ");
INSERT INTO amk_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesusi medu tonanaia kai fo, enerorongfoi fituayai paria tuti medu deyo, “Tarai antu! Imadurai we mea mau yeyo, manei na mea ambori dewayang yau ki.” ");
INSERT INTO amk_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ne inontarai erariati fosa ewati wawerasa na enemitituai paria we mandoni dino Yesusi deyoi tonanafo. ");
INSERT INTO amk_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Manei na ne inontarai ewesuraya mandu nanisa, amani mano Yesusi enewawuti foi, wiatai na eneung domoya fo sauo Yesusi. ");
INSERT INTO amk_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ampafe Simon Petrusi urekamani deyo, “Butang berahi, we mandoni dino deyoi tonanai nina!” ");
INSERT INTO amk_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Ainanaya mano wiatai sauo Yesusi nani deti we Yesusi tuti medu wei deyo, “Sengne waune, mandoni dino boyoi tonanai nina?” ");
INSERT INTO amk_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesusi yoa wei deyo, “Inontarai nani mani, andino irorang rotifoa tuti yohonai wei ne.” Medu tonanaia mayeai kia rotifo yorang na rewangguaifoa, ainanaya dohonai we Simon Iskariotio antungno Yudasia. ");
INSERT INTO amk_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Yudasi yu roti Yesusi dohonai tonanai weia fo nanai, enerorongfoi Saminseni sensonia. Ainanaya Yesusi medu wei deyo, “Fianai aino boyo nari wa mani, nari kahairaia.” ");
INSERT INTO amk_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Yesusi medu tonanai wape manei na ne inontarai eminohi etampi ruhiai nanisa wiro tefu fiani aino medurai tonanai we Yudasifo kaha. ");
INSERT INTO amk_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","We Yudasi yu ene kasi doi foi, ampafe mano etampi ruhiai nanisa ewaitarahio Yesusi demi we wiori fieai we rahida Paska foi ete demi we dohong fieai we inontarai ene pari fi fosa. ");
INSERT INTO amk_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Yudasi yu rotifo ria Yesusia nanai, mayeai doabariri tuti da to boriai sikaherawa. Rabuang bonani mani, diru kawurua. ");
INSERT INTO amk_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Yudasi da wa nanai, mayeai Yesusi medu we ne inontarai wei fosa deyo, “Ninaia mani Kaisung Inontarai nei, Allai yuaisi dedai sambewarai ampa, tuti na I wedaya inontaraine etaparanding Allai we dedai tuti mirarebanai. ");
INSERT INTO amk_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Masino na Kaisung Inontarai nei wedaya inontaraine etaparanding Allai mani, na I kontai wedaya Allai deparandini tonanai. Kontai Allai yuaisi dedai tuti mirarebanai ahera tonanai. ");
INSERT INTO amk_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Nehu arikangne meaine, wiro inayai waroi ria mea ahang kaha. Ambori mesera we yau ki, wape kariri fianai aino raminde imadurai we mano ewenunggamiei we Yahudi fosara nanai, tonanai kontai imadurai we mea aha, amani yeyo: To katai ira wei foi, todoni kontaio mane ro weia kaha rai. ");
INSERT INTO amk_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Yohong Kaiwo Pondoai waworu feai we mea amani: Menemiwawu wawera mea. Toyari yau we enehuwawu meafo, mea kontai menemiwawu wawera mea tonanai. ");
INSERT INTO amk_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Na tonanane, ambori kaiwasanei kiai ewaitawanai we nehu inontarai meraria yau di mea, amani na menemiwawu wawera mea fo.” ");
INSERT INTO amk_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Petrusi dutang bera Yesusi deyo, “Sengne waune, boyo ro todoni?” Yesusi yoa wei deyo, “To katai iraoi nini, na ninaifa mani wiro ro ria yau kaha rai, wape akawuru wori ro ria yau ki.” ");
INSERT INTO amk_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Simon Petrusi dutang berahi aha deyo, “Sengne waune, we fiani na nina mani ira ria wau kahai nina? Imainenang we imereha we wau!” ");
INSERT INTO amk_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Yesusi medu wei aha deyo, “Tarai we moinenang we mureha we yau e? Tarai antu! Imadurai we wau mau yeyo, wiro manggohei bibe kaharai wape fofora yau webetoru kawurua!” ");
INSERT INTO amk_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesusi medu paria aha deyo, “Wiro meweansarai fanai. Meroaso Allai, meroaso yau kontai. ");
INSERT INTO amk_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Na Dai ne munu rorong fo mani, katai bitoya we meminohi nai. Masino tonana kaha mani, todoni kontaio yeikaririai we mea ki. Weo ira to wanaia we imainenang katai we mea. ");
INSERT INTO amk_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Tuti ira to wanaia tuti imainenang kataifeai we meara mani, ambori yarabera yau we mea aha ma tuti ika mea to nehu kataifoia, ambori na katai doni inayai nai nana mani, mea kontai menayai na nanai. ");
INSERT INTO amk_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","To katai bodoni ira wei mani, mewaitawang rangfoi.” ");
INSERT INTO amk_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Ainanaya Tomasi medu we Yesusi deyo, “Sengne waune, amewaitawang to katai bodoni ro wei foi kaha, ampafe amewaitawang rang nani todoni?” ");
INSERT INTO amk_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesusi medu wei aha deyo, “Yauno iweRangne, mano iweTarai di yau, tuti mano Yohong Ansengfoi di yau. Mandoni kontaio da we Dai mani wiro na rang siai bei kaha, mae na yau terai. ");
INSERT INTO amk_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Masino metaroanso yau mani, metaroanso Dai kontai. Na ninai to fongna mani metaroani tuti mewatioi ampa.” ");
INSERT INTO amk_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Pilipusi dutang Yesusi aha deyo, “Sengne waune, boinawi Dai we amea, nana mani demoyara we ameara finanai.” ");
INSERT INTO amk_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ampafe Yesusi medu wei deyo, “Pilipuse, waroi mau wa inayai rahang mea, wape metaroanso yau kaharai e? Mandoni kontai andino deti yau mani, deti Dai kontai ampa, ampafe todonie modu boyo, yeinawi Dai nani we mea ninai? ");
INSERT INTO amk_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Roasoa kahai we Dai niayai na yau tuti yau kontai inayai na Daine ne? Fianai aino imadurai we mea ne, wiro imadurai na mantaung yau kaha, mae na Dai mano niayai na yaunei. Andino niari ne fi yu fo kai na yaune. ");
INSERT INTO amk_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Meroasoaifa we Dai niayai na yau tuti yau kontai inayai na I. Ete tonana kaha mani, kadono meroasoai weo mewati fitantumao inaria fo. ");
INSERT INTO amk_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Tarai antu! Imadurai we mea mau yeyo, mandoni kontai andino yoaso yau mani, ambori niari fianai aino inari ne kontai ki, tuti nanai tera kaha mae niari fi fuba sewa ne nanafo kontai ki. Weo ira we Dai aha. ");
INSERT INTO amk_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Tuti fianai aino metutang weai na wonohune mani, ambori inari kaririai ki, inari kariri finanai ambori iwedaya inontaraine etaparanding Dai. ");
INSERT INTO amk_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Masino metutang we fiani kontai we yau na wonohune mani, ambori yohong kaririai ki.” ");
INSERT INTO amk_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Masino menemiwawu yau mani, ambori metohong kariri nehu kaiwo pondoaia nanai. ");
INSERT INTO amk_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Yau ambori yutang Dai tuti I ambori dohong Mangfata siai manei we mea aha ma, ambori weriria mea we fitawafa. ");
INSERT INTO amk_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Mangfata nani mani Allai Nuaninufoi dine, I mani Nuaninuo deinawi ne wetaraifo. Nunei wiro demang wei kaha, weo wiro detioi kaha tuti deroani kaha. Wape mea mani metaroani, weo weriria mea tuti niayai na mea ki. ");
INSERT INTO amk_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Wiro itua mea meweawata kaha, mae ambori yarabera yau we mea aha ma ki. ");
INSERT INTO amk_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Waroi ahang kahai mae nunei ambori deti yau ahang kaha, wape mea mani ambori mewati yau. Yarang ampafe mea kontai ambori metarang ki. ");
INSERT INTO amk_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Na rahida bonani dino ambori mewaitawanai we iweboyari ria Dai, tuti meweboyari ria yau, tuti iweboyari ria mea. ");
INSERT INTO amk_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Mandoni kontai andino yu nehu kaiwo pondoaia ne tuti dohong kariria mani, wenani dino enewawu yaune. Tuti mandoni kontai andino enewawu yau, wenani Dai ambori enewawuti kontai ki, tuti yau kontai ambori enehuwawuti tuti yeinawi nehu tarainei wei ki.” ");
INSERT INTO amk_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yudasi (wiro Yudas Iskarioti kaha) dutang bera Yesusi deyo, “Sengne waune, we fianie boyo boinawi nemu taraiwai we wau mani Mananu Mampariri foi di wau we amea terai mae wiro we nunei sentenang kahai nina?” ");
INSERT INTO amk_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesusi yoa wei deyo, “Masino inontarai manei enewawu yau mani, inontarai nani dohong kariri nehu aunaune. Wenani Dai ambori enewawuti, tuti Dai tuti yau ambori aura weia tuti auminohi riati. ");
INSERT INTO amk_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Mandoni kontaio enewawu yau kaha mani, wiro dohong kariri nehu aunaune kaha. Aunauo metaramioai ria yau ninai, wiro na yau kaha, mae na Dai mano demi yau nei. ");
INSERT INTO amk_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Finanai kai imadurai we mea na inayai na nunei ria mea nina. ");
INSERT INTO amk_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Wape Mano Fiata foi, amani Nuaninu Mirarebana foi, andino Dai demi na wonohune ma we fiata mea. Nuaninu nani dino ambori deunau fikiai doni konta foi we meane, tuti ambori deretawang mea we fianai aino imadurai kawuru we meara fo. ");
INSERT INTO amk_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Ne maifo yohonai watai ria mea. Nehu maine yohonai we mea, tuti fianai aino yohonai ninai, wiro ne tarai kariri ne maio nunei dohonai we mea fo kaha. Dohona meweansarai tuti mematai fanai, mae meminohi na mai na nehu maine. ");
INSERT INTO amk_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Metaramioai we imadu yeyo, ira weru mea, wape yarabera yau we mea aha ma ki. Masino menemiwawu yau mani, mefaraise we ira ne. Weo ira we Dai, weo I mani fiabai sewa yau. ");
INSERT INTO amk_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Wiro fininai kawaria kaharai mae, imadurai fafong tonanai we mea, ambori finanai kawaria mani meroasoai. ");
INSERT INTO amk_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Wiro imadu kaiwofeai bitoya we mea ahang kahai, weo rahida mai we mananuo wenunggamiei we nunei da ma ne. I wiro ne mambiriufeai we yau kaha, ");
INSERT INTO amk_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","wape todoni kontaio finanai kawariai ambori nunei deitawanai we enehuwawu Dai tuti fiani kontai aino Dai demi yau wea fo yohong kaririai na mai. Into, metoabari mea tara weru katai nini.” ");
INSERT INTO amk_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesusi medu aha deyo, “Yau mani wai angguri robong tarai di yau, tuti Dai dino ne romi angguri foi ne. ");
INSERT INTO amk_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Angguri arawang sobaurai na yau foi, bodoni dino webong kaha mani ferangkutui tuti arawang bo webong foi derari ambori webong bitoya aha. ");
INSERT INTO amk_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Nehu aunau yeunauwai we mea ne wedaya mea memararebanaia mehai ampa. ");
INSERT INTO amk_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Todoni kontaio menayai na yau pampang, tuti yau kontai inayai na mea ki. Weo angguri arawangfoi siaia mani wiro webong kaha, mae sobaurai na robongfoi fino webong fe. Tonanai kontai we mea, masino menayai na yau kaha mani mewebong kaha. ");
INSERT INTO amk_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Yau mani wai angguri robong di yau tuti mea mani arawang di mea. Mandoni kontaio niayai na yau tuti yau kontai inayai na i mani, webong bitoya. Weo menayai boriei weru yau mani, wiro menari fiea kaha. ");
INSERT INTO amk_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Mandoni kontai wiro niayai na yau kaha mani, wenani kabioi to boriei ne tarai toyari arawangfoi ambori memasa, mayeai fanduhi tuti kabioi to adiafoi we kesoi. ");
INSERT INTO amk_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Masino menayai na yau tuti nehu aunaufo nayai na mea, nana mani fifiani kontai aino metutang wea fo, mesobuai. ");
INSERT INTO amk_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Masino mewebong bitoya mani wedaya inontarai etaparanding Dai paria tuti na tonanane kontai metainawiai we nehu inontarai meraria yau di mea. ");
INSERT INTO amk_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Toyari Dai we enewawu yau fo, yauo enehuwawu mea kontai tonanai. Menayaia mutu na nehu enehuwawufo nana to. ");
INSERT INTO amk_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Masino metohong kariri nehu kaiwo pondoaia fo mani, ambori menayai na nehu enehuwawufo, toyari yau we yohong kariri Dai ne kaiwo pondoaia fo tuti inayai na enewawufo nanai. ");
INSERT INTO amk_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Fininai kai yeikariria we mea tonanai, ambori nehu imirisingfo nayai na menemirorongwai, tuti memararisingwa mai. ");
INSERT INTO amk_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nehu kaiwo pondoai we mea finina: Menemiwawu wawera mea, kariri yau we enehuwawu mea fo. ");
INSERT INTO amk_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Mano enewawufo fuba sewa ne mani, inontarai mano dohong ne taraifoi mireha we ne maniwowirifosa foi. Wiro enewawufeai fuba sewa ne tonana fo kaha. ");
INSERT INTO amk_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Masino metohong kariri nehu kaiwo pondoai we mea fo na mai mani, nehu maniwowiri di mea. ");
INSERT INTO amk_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Wiro isahu mea we woming ahang kaha, weo womingfoi wiro deitawang fio ne inontarai yufi wei foi fi niari fo kaha. Wape isahu mea we nehu maniwowiri, weo fi kiaio tarahuoi ria Dai foi, yeisahari kiai we mea ampa. ");
INSERT INTO amk_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Wiro meaino metiri yau ne kaha, mae yauno yiri mea ne, tuti iruai mea we ambori mera tuti mewebong bitoya paria, tuti mene bong nanai wiro wioru kaha, mae niayai waroi. Na tonanane fianai aino metutang weai we Dai na wonohune mani, ambori dohonai we mea ki. ");
INSERT INTO amk_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Nehu kaiwo pondoai we metohong kariria fo aininai: Menemiwawu wawera mea.” ");
INSERT INTO amk_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Yesusi medu aha deyo, “Masino nunei enerireu mea mani, mearomioai we ne tonanane enerireu yau fafong ampa, akawuru wori mea ki. ");
INSERT INTO amk_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Masino nunei ne inontarai di mea mani, enewawu mea rai. Wape yiri mea weru nunei ampa, ampafe wiro nunei ne mea ahang kaha. Nanai wedaya nunei enerireu mea ninai. ");
INSERT INTO amk_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Mearomio fianai aino anta imadurai kawuru we meara fo amani, ‘Womingnei wiro fiabai sewa mano yufi wei foi kaha.’ Masino enari kanggani yaua mani, ambori enari kanggani mea, mano merufi we yau ne mea kontai ki. Masino etohong kariri nehu kaiwofo mani, ambori etohong kariri mene aunaufo kontai ki. ");
INSERT INTO amk_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Wape wonohunei wedaya enari kanggani mea tonanai, amani weo meraria yau fefe, weo nunei wiro deroanso Mano demi yau foi kaha fefe. ");
INSERT INTO amk_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Masino ira ma tuti imadu wesa kaha, nana mani wiro ewaitawanai we ewesasari kaha, wape ira ma imadu wesa ampa ampafe ninaia mani wiro ehidori weru ene sasari nani ahang kaha. ");
INSERT INTO amk_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Mandoni kontaio enerireu yau mani, wenani kontai enerireu Dai. ");
INSERT INTO amk_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Inari fitantuma bitoya na euremireafo ampa, fitantumao manei siai wiro niari na wea kaha rai. Masino inari tonanai rahangsa kaha mani, ewesasari kaha. Wape ninaia mani ewatio fitantumao inari fo tonanai ki, wape enemirireu yau tuti Dai kontai. ");
INSERT INTO amk_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Wape ne tonanane kawariai ambori mai kariri kaiwo dotu na ene Kaiwo Mararebana foi deyo, ");
INSERT INTO amk_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Mangfata ambori yemi da ma foi, amani Nuaninu Mirarebanai Wetaraio kewariai na Dai ma foi mani, I ambori meduairai kariri yau ki. ");
INSERT INTO amk_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Tuti mea kontaio memaduairai kariri yau, weo meweriria yau na reantenangfo paria sobu nina fefe.” ");
INSERT INTO amk_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Fininai kai yeikaririai we mea tonanai ambori wiro metawa fanai. ");
INSERT INTO amk_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ambori mano ewenunggamiei fosa etata mea weru munu agama Yahudi fo ki. Tuti ambori mano emung mea fosa enemitituai we enari tonanafo deinawiai we esomi we Allai tarai finanai. Rabuang bo inontarai enari tonanafo ambori kawariai ki. ");
INSERT INTO amk_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Enari tonanai we mea, weo wiro etaroanso Dai kontai yau kahaia. ");
INSERT INTO amk_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Wape imadurai fafong we mea tonanai ambori fininai kawariai aha mani, mewaitawanai we imadurai kawuru we mea ampa.” Yesusi medu aha deyo, “Fininai wiro imadurai we mea na reantenangfo kaha, weo inayai rahang mea ne rai. ");
INSERT INTO amk_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Wape ninaia mani, ira we Mano demi yau ma foi aha, tuti wiro manei na mea dutang deyo, ‘Ro todoni?’ ");
INSERT INTO amk_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Wape kaiwo imadurai toninaifa we mea ne wedaya menemirorongwai fituayai. ");
INSERT INTO amk_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Tonanai ki, wape kaiwo imadurai ninai tarai, amani masino ira weru mea mani, finanai kia bengfo sewa we mea. Weo ira wa kaha mani, Mangfatafoi da we mea ma kaha, wape ira wa fino yemi Mangfatafoi da we mea ma fe. ");
INSERT INTO amk_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Mangfata nani da ma mani, ambori wedaya nunei deroanai we niari sasari, deinawiai we nunei kariri ne masifo tuti nunei deitawanai we ambori Sempaisi kiutu kaiwo karirisa ki. ");
INSERT INTO amk_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Mangfata nani deinawi kariri ene sasarifoi weo eroaso yau kaha, ");
INSERT INTO amk_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","deinawi kariri ne masifo weo ira we Dai aha tuti wiro mewati yau ahang kaha, ");
INSERT INTO amk_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","tuti kariri Sempaisi we kiutu kaiwo kariri nuneifo weo Saminseni, mananu nunei, sobu aiboifo. ");
INSERT INTO amk_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Fi bitoya kontai yeyo imadu kariri we mea, wape nina mani wiro mewemambiriu we metamang wei kaharai. ");
INSERT INTO amk_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Wape Nuaninu nani, amani Nuaninu Mirarebanaio Wetarai foi, ambori wiwiaing mea we metaroanso ne wetaraifo. Wiro medu na mantauni kaha, mae fianai aino taraoaia fo aino medura ne, tuti ambori deikaririai we mea kariri fianai aino ambori kawariai na rahida fui wanai ahang fo. ");
INSERT INTO amk_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","I ambori deparanding yau, weo ambori medurai we mea fianai aino sobuai ria yau fo. ");
INSERT INTO amk_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Fi kiaio Dai neni foi, yau kontai nehu fi fine. Nanai wedaya imadu yeyo, I ambori medu fi kiaio sobui ria yau foi we mea ki.” ");
INSERT INTO amk_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Yesusi medu aha deyo, “Katu mani mewati yau ahang kaha, tuti katu aha mani mewati yau aha ki.” ");
INSERT INTO amk_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ne inontarai ewesuraya mandu fosa etarami kaiwofo nanai, emadu wawerasa eteyo, “Kaiwo todoni fino medurai deyo, ‘Katu mani mewati yau ahang kaha tuti katu aha mani ambori mewati yau aha nina’? Tuti deyo, ‘Ira we Dai aha nina’? ");
INSERT INTO amk_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Fianai aino medurai deyo, ‘Katu aha nina’? Tatafu kaiwo medurai tonana fo kaha.” ");
INSERT INTO amk_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesusi deitawanai we eteyo etutang berahi we kaiwofo, ampafe medu wesa deyo, “Kaiwo anta imadurai yeyo, ‘Katu aha mani wiro mewati yau ahang kaha, tuti katu aha mani ambori mewati yau aha ki’. Kaiwo nanai aino mesewa weai nina e? ");
INSERT INTO amk_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Tarai antu! Imadurai we mea mau yeyo, ambori mesai tuti metaidu, wape nunei ambori mirising. Ambori menemirorong fituayai, wape menemirorong fituayai nanai ambori yiwani na memararisingfo aha ki. ");
INSERT INTO amk_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Wiwinsanai manei ne rahidafo maia mani, amaina pirahai tuti arohuayai, wape minohi tuti arikangfoia kasaua mani, aroporo ne pirahafo tuti arohuayai nanaia, weo mirising we arikang manei saubaununggamiei to nunei fefe. ");
INSERT INTO amk_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Tonanai kontai we mea, ninaifa mani menemirorong fituayai, wape ambori isobu mea aha ki, ampafe wedaya memararising aha, tuti mandoni kontaio wiro wedaya memararising nanai nai weru mea kaha. ");
INSERT INTO amk_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Na rahida bonani mani, wiro metutang we fieai we yau ahang kaha. Imadurai na kaiwo tarai we mea ne, fiani kontai aino metutang weai na wonohune we Dai fo, finanai ambori Dai dohonai we mea ki. ");
INSERT INTO amk_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Paria sobu rahida bonini wiro metutang we fieai na wonohune we Dai kaharai. Ampafe metutanaia, ambori finanai mesobuai ki, ambori memararisingfo mai. ");
INSERT INTO amk_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Fi imadurai kai tonina ne, imadu na kaiwo netawea fo. Wape rahidao ambori imadu na kaiwo kasau beyari we mea foi ambori da ma ki. Rahida bonani wiro imadu na kaiwo netawea fo ahang kaha, mae imadua kasau we mea kariri Dai. ");
INSERT INTO amk_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Na rahida bonani ambori mewenadi na wonohune we Dai. Tuti wiro imadurai we mea yeyo yutang Dai we fieaifa we mea kaha. ");
INSERT INTO amk_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Weo Dai mantauni enewawu mea, weo menemiwawu yau ampa tuti meroasoai we ira na Allai ma fefe. ");
INSERT INTO amk_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Tarai we ira na Dai ma tuti ira to nunei ma. Wape ninaia mani, ira weru nunei aha tuti ira we Dai aha.” ");
INSERT INTO amk_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ainanaya Yesusi ne inontaraifosa emadu wei aha eteyo, “Ninaia mani wiro modu na kaiwo netawea fo ahang kaha, mae modu parai ampa. ");
INSERT INTO amk_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Ninaia mani amewaitawanai we fifiani kontaio boitawanaia kai tuti wiro manei bera wau we fieai ahang kaha. Nanai wedaya ameroasoai we wau mani ro na Allai ma.” ");
INSERT INTO amk_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Yesusi medu wesa aha deyo, “Ampafe meroasoai taraia finina e? ");
INSERT INTO amk_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Mearomioaifa! Rahidafo ambori da ma ki, tuti da kawuru ma ne, weo inontarai ewedaya mea mewawu taterai to mene kataifo tuti mewawu weru yaua imesiri yau. Tonanai ki wape wiro imesiri yau kaha, weo Dai weriria yau fefe. ");
INSERT INTO amk_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Fininai kai imadurai we mea tonanai, ambori menumiruainso ne maifo we meweboyari ria yau fefe. Na nunei ninai mesobu dadirafo we inontarai enari kanggani mea, wape metawang meara mutu, weo ikaraikobu nunei ampa!” ");
INSERT INTO amk_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesusi medu tonanaia kaifo, fioai ureng deti to rorafaisi tuti medu deyo, “Daie, rahidafe mai ampa. Ruai nemu Kaisungnei dedai sambewarai, ambori nemu Kaisungnei kontai wedaya wonomuwa dedai sambewarai kontai. ");
INSERT INTO amk_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Toyari bohong mananufo wei we yuo inontarainesa kiai fo ampa, tonanai kontai we I ambori dohong numainufo we mano Dai bohonsa weia fosa kontai. ");
INSERT INTO amk_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Minohi arang we numainufo ainina: Inontaraine etaroanso Dai wau, we mesiri wauno Allai tarai di Waune. Tuti etaroanso Yesus Kristusi mano Dai bemi ma nei. Nana mani minohi arang we numainufo ainanai. ");
INSERT INTO amk_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Inari Dai wonomuwai dedai tuti sambewarai na nunei ampa, amani na yohong kariri fianai aino Dai bemi yau weai we inari fo na maia fo. ");
INSERT INTO amk_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Tuti ninaifa mani, Daie, ruai yau yedai imararebanai na mantaung wau aromureawa, na sambewarai dedaio raminde nehu kawurua fo na nunei wiro tamui kaharai fo.” ");
INSERT INTO amk_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Yeinawi Dai wau kawuru we inontarai nunei ninisa ampa, amani inontaraio bohonsa we yaua fosa. Inontarai nanisa mani, nemu inontarai saine tuti bohonsa we yau ampa tuti etohong kariri nemu Kaiwowa ampa. ");
INSERT INTO amk_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ninaifara mani, ewaitawanai we fi kiaio bohonai we yau ne, finanai na Wau ma. ");
INSERT INTO amk_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Weo nemu Kaiwo bohonai we yau fo, imadurai kai wesa ampa tuti etamang weai na mai ampa. Ewaitawanai tarai we yau mani ira na Dai wau ma tuti eroasoai we wauno bemi yau ne. ");
INSERT INTO amk_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Iwenadi wesa. Wiro iwenadi we nunei kaha mae wesa terai, amani mano bohonsa we yau ma nesa, weo ea mani nemu inontarai saine. ");
INSERT INTO amk_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tuti mandoni kontai saino nehusa ne nemusa kontai, tuti mandoni kontai saino nemu sa wa nehu sa kontai. Tuti na tonanafo etaparanding wonohune dedai tuti sambewarai. ");
INSERT INTO amk_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Ninaifa mani ira we wau mau ne, wiro inayai na nunei ahang kaha, wape ea mani enayai na nunei ne. Daio murarebanawa Wau! Bowawusa na wonomu wemambiriu wa, amani wonomu wemambiriuo bohonai we yau kawurua wa, ambori eweboyari kariri turu we tuweboyari ne. ");
INSERT INTO amk_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Na siario inayaifa riasa na nunei ninai, yewawusa na wonomuwa amani mambiriuo bohonai we yau ma fo, yewawusa kawuru ampa tuti manei wiro niai kaha. Mano niai foi mani, mano kutuai kawuru kariri we ambori niai, tuti finanai ambori mai kariri kaiwo dotu na Kaiwo Mararebana foa fo. ");
INSERT INTO amk_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Ninaifa mani, ira we Dai wau aha mau tuti fininai kai imadurai na inayai na nunei nina, ambori emirising na mararising tarai yohonai wesa fo. ");
INSERT INTO amk_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Dai nemu Kaiwone yohonai kawuru wesa ampa tuti nunei enerireusa, weo ea mani wiro na nunei kaha, toyari yau we wiro na nunei kaha ne. ");
INSERT INTO amk_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Yutang wau ninai wiro we ambori kasa weru nunei kaha, mae we ambori borarasa weru mano kerira pari foi. ");
INSERT INTO amk_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ea mani wiro na nunei kaha, toyari yau we wiro na nunei kaha fo. ");
INSERT INTO amk_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Narisa emararebanai na ne wetaraifo; Ne wetaraifo mani, nemu Kaiwo Mararebana fo. ");
INSERT INTO amk_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Ne tarai toyari bemi yau to nunei ma fo, yau kontai yemisa to nuneia. ");
INSERT INTO amk_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","We ene maifo wedaya yohong nehu tarainei we wau terai, amani yohong kariri nemu awiawa, ambori na tonanane ea kontai ruaisa we nemu inontarai emararebanai.” ");
INSERT INTO amk_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Wiro iwenadi tuti ea tera kaha. Mae iwenadi kontai we inontarai ambori eroaso yau fosa, amani inontarai ninisa ansaino ewuwu kaiwo kariri yau wesa fo. ");
INSERT INTO amk_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Iwenadi ambori ea kiai eweboyari, kariri Dai wau weboyari ria yau tuti yau kontai iweboyari ria wau ninai. Tuti ambori eweboyari ria turu, ambori na tonanane nunei deitawanai we Dai wauno bemi yau to nunei ma ne. ");
INSERT INTO amk_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ne sambewarai dedaio Dai bohonai we yaua nanai, yohonai kawuru wesa ampa ambori ea kontai eweboyari kariri turu we tuweboyari nina. ");
INSERT INTO amk_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Yau iweboyari riasa tuti Dai wau weboyari ria yau, ambori eweboyari tarai. Na tonanane nunei ambori deitawanai we Dai wauno bemi yau ne tuti enemuwawusa kariri enemuwawu yau ninai. ");
INSERT INTO amk_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Daie, yohong weai paria we ambori mano bohonsa we yaua ninisa, eminohi ria yau na katai bodoni dino inayai nai fo, ambori ewatio nehu sambewaraio dedai fo, amani dadai mirarebanaio bohonai we yaua nanai, weo nari nunei kaharai mae, enemuwawu yau kawurua. ");
INSERT INTO amk_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Daio mosi wa waune! Nunei wiro deroanso wau kaha, wape yau mani yeroanso wau tuti inontarai ninisa ewaitawanai we Dai wau bemi yau ma ne. ");
INSERT INTO amk_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Tuti yeiriri wonomuwai wesa ambori etaroanso wau ampa tuti yeiririai pampang wesa tonanai, ambori Dai nemu enemuwawu yau wa nayaia mutu na enemirorongfoi tuti yauo iweboyari riasa pampang.” ");
INSERT INTO amk_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesusi wenadi tonanaia kaia fo, i tuti ne inontarai ewesuraya mansiari fosa era to waya sirarang Kidroni eneung dowei foia. Romi bei wiatai na nanai, ampafe Yesusi tuti ne inontaraifosa esuai to romifoi afui. ");
INSERT INTO amk_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yudasi, mano dewayang Yesusi foi, deitawang katai nani kontai, weo Yesusi tuti ne inontarai suraya mandu fosa wea mani era to katai nania fefe. ");
INSERT INTO amk_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ampafe Yudasi da to katai nania, kia afai mamuna Roma fosa manea tuti mano ewaitawang wedua Sempaisi ne Munufoi na Yerusalemifo manea, amani inontaraio imami baba fosa tuti Farisifosa etemisa fosa. Inontarai nanisa eha fimamuna, pelita tuti obori. ");
INSERT INTO amk_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesusi deitawang fi kiaio ambori sodaira fo, ampafe dariaia da weu inontarai nanisara tuti dutang berasa deyo, “Mandoni dino mesera wei ne?” ");
INSERT INTO amk_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Eroa wei aha eteyo, “Yesusi, inontarai Nazareti foi.” Ampafe Yesusi medu wesa aha deyo, “Yau nina.” Yudasi mano dewayani foi kontai doari na nanai riasa. ");
INSERT INTO amk_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Na kutu Yesusi medu deyo, “Yau nina,” tonanafo esu to fuia ehai beyari tuti etawai aweu ewatai na kahofa nuwowongfo. ");
INSERT INTO amk_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ainanaya Yesusi dutang berasa nariai aha deyo, “Mandoni dino mesera wei ne?” Ampafe emadu wei aha eteyo, “Yesusi, inontarai Nazareti foi.” ");
INSERT INTO amk_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesusi medu wesa aha deyo, “Anta imadurai ampa we yeyo, yaune. Masino yauno mesera we yaune mani, metawing nehu inontarainesa era wa.” ");
INSERT INTO amk_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Na tonanane ambori masi kariri kaiwo anta medurai deyo, “Inontaraio bohonsa we yau nesa, wiro itua manei sodai ne karirafo kaha.” ");
INSERT INTO amk_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ainanaya Simon Petrusi kia sondu aburuei, ampafe fiatini doa awaruo imami fuba foi ne womingfoi tarandaung domoya foi nanai fituayaia. Imami ne woming nani mani wonong fino Malkusi. ");
INSERT INTO amk_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ampafe Yesusi medu we Petrusi deyo, “Tata nemu sonduwai na ne kataiwai aha! Weo todoni kontaio yunung anggurio deinawi kariri dadirao Dai dohoni we yau ma nei rai.” ");
INSERT INTO amk_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ainanaya afai mamuna Roma fosa tuti ene mano wenunggamiei wesa foi kontai Yahudio mano Farisi fosa tuti mano ewenunggamiei we imami fosa etemisa fosa, etafu Yesusi tuti eworahi. ");
INSERT INTO amk_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Reantenang mani ehari to Hanasia, weo Hanasi mani Kayafasi nyong dine. Defuina bonani mani Kayafasi dino weimami fuba ne. ");
INSERT INTO amk_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Andino raminde deunau mano ewenunggamiei we Yahudi fosa deyo, “Ne beng sewa mani, inontarai mansiari mireha we kaiwasanei sentenang.” ");
INSERT INTO amk_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Petrusi tuti manei siai na Yesusi ne inontaraifosa ura ria Yesusia. Inontarai mano siai nani mani imami fuba foi deroansoi, ampafe suai kontai ria Yesusi to imamifoi ne munu refongfo afui. ");
INSERT INTO amk_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Mae Petrusi mani doari na rahutu borong boriei fo. Mano siai nani dariai ahariei tuti medu we wiwingno deitawang wedua rahutu borongfo nania, ainanaya kia Petrusi usuayai to rorongfo afui. ");
INSERT INTO amk_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Wiwing deitawang wedua rahutu borongfoi medu we Petrusi deyo, “Wau mani, mano etafuri wani ne inontarai erariati fosa manei di wau to?” Petrusi yoa wei deyo, “Yau mani, bereri.” ");
INSERT INTO amk_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Rabuang bonani mani, danunangfo ne diru neungfo ampafe mangfatafosa tuti mano ewaitawang wedua Sempaisi ne Munufoi na Yerusalemi fosa, eruru adia bei kawuru na nanai we eharuruwi. Petrusi kontai da wa doari riasa na nanai we keruru adiafoi kontai. ");
INSERT INTO amk_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Na siari nanai kontai, imami fuba foi dutang bera Yesusi kariri ne inontarai erariati fosa tuti kariri ne aunaufo. ");
INSERT INTO amk_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Yesusi yoa wei deyo, “Imadu parai na kaiwasa bitoya foi urengreafo. Yeunau pampang na munu agama Yahudi fo tuti na Sempaisi ne Munufoi na Yerusalemi, kataio inontarai Yahudi fosa kiai efanduhisa naya fo, wiro imadu wora fiea kaha. ");
INSERT INTO amk_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ampafe we fianie butang bera yau ninai? Butang bera mano etarami yau yeunau tonana fosa. Inontarai nanisa todoni kontaio ewaitawang fianai aino yeunauwai nana rai.” ");
INSERT INTO amk_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesusi medu tonanaifara fo, inontarai ewaitawang wedua Sempaisi ne Munufo manei biari awaru bioipa Yesusi tararei tuti medu wei deyo, “Imami fuba nei mani madu wei tonanaifa ne?” ");
INSERT INTO amk_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Yesusi medu we mano bioi foi deyo, “Masino kaiwo imadura ne imadu sarawa mani, boinawi kariri ne imadu sarawai nanai. Mae kaiwo imadura ne wetarai mani, we fianie boipa tarahurei nina?” ");
INSERT INTO amk_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ainanaya Hanasi denatu Yesusi to Kayafasi, imami fuba foi, na warangfo eworahia. ");
INSERT INTO amk_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon Petrusi doari mae keruru adiafoi na nanaifa wo. Ainanaya inontarai na nana fosa emadu wei eteyo, “Wau mani, inontarai wani ne inontarai erariati manei di wau to?” Petrusi fefora deyo, “Bereri, yau mani bereri.” ");
INSERT INTO amk_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ainanaya imami fuba foi ne mangfata manei, i mani imami ne womingno anta Petrusi ferangkutu tarangfoi ne tera dine, medu wei aha deyo, “Antanafa iwati wau we nayai kontai na romifoi riati to?” ");
INSERT INTO amk_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Mayeai Petrusi fefora aha deyo, “Bereri.” Na tatofang kutu nanai kontaio manggoheifoi bibe. ");
INSERT INTO amk_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Kameai kutungna mani, eha Yesusi na Kayafasi ne munufoi to gubernuri Roma foi ne munufoi aha. Inontarai Yahudi fosa wiro esuai to gubernuri ne munufoi afui kaha, weo ematai nana mani, kariri ene hukumifoi mani wedayasa ewerarika, weo eteyo etangno fiang Paska foi fefe. ");
INSERT INTO amk_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ampafe Pilatusi dariai ariei medu wesa na munufoi dereung boriei fo tuti dutang berasa deyo, “Fifianai aino metinggai inontarai nini wea ne?” ");
INSERT INTO amk_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Emadu we Pilatusi eteyo, “Masino inontarai nini dohong sarawa kaha mani, wiro amehari to aromureane ma kaha.” ");
INSERT INTO amk_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ampafe Pilatusi medu wesa aha deyo, “Meharia, mehutu kaiwo kariri i, kariri mene hukumi Yahudi wai.” Manamo inontarai Yahudi fosa emadu wei eteyo, “Mae kariri mene hukumi Roma wa mani amene pari haki we amehutu kaiwo we maneia sodai aiboi marareha fo.” ");
INSERT INTO amk_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ampafe na tonanane ambori mai kariri kaiwo Yesusi meduraia fo, amani medurai we deikariri kariri todoni mireha toa fo. ");
INSERT INTO amk_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ainanaya Pilatusi suai to ne munufoi afui tuti sahu Yesusia dutang berahi deyo, “Taraie, wau weMananu we inontarai Yahudi fesa ne ne?” ");
INSERT INTO amk_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesusi medu we Pilatusi aha deyo, “Kaiwo butanai tonina ne mani, kaiwo tabau na enemurorongfuisi mandiei fine ete mano siai etaisaharai we wau e?” ");
INSERT INTO amk_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilatusi kesou medu wei aha deyo, “Ampafe inontarai Yahudi di yau e? Mano etafu wau eha wau we yau ma nesa mani, nemu inontarai mene nu boyari fosa tuti imami baba fosa. Fisarawai fianai aino nari ampa ne?” ");
INSERT INTO amk_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Yesusi medu wei aha deyo, “Nehu mananune wiro na nunei kaha, weo masino na nunei mani, ambori na toninane nehu inontaraine erurai we emamuna tuti yau, ambori Yahudifosa wiro etafu yau kahai ki. Manamo tarai we nehu mananune wiro na nunei kaha!” ");
INSERT INTO amk_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ampafe Pilatusi dutang berahi aha deyo, “Aa! Tonana mani Mananu di wau e?” Yesusi medu wei aha deyo, “Moduwa tarai we boyo yau mani mananu di yau ne. Ne nanai wedaya itaubau nuhukamiei to nunei ma ninai tuti ira to nunei ma ninai, ambori imaduairai kariri ne wetaraifo. Tuti mandoni kontaio da na ne wetaraifo nani tarao yau.” ");
INSERT INTO amk_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilatusi medu wei aha deyo, “Ne wetarai fianai aino boyoa ne?” Ainanaya Pilatusi kiawariai na munu refongfo ahariei, medu we inontarai Yahudi fosa deyo, “Iberahia manamo wiro isobuai we dohong sarafiea kaha. ");
INSERT INTO amk_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Wape kariri fianai aino inari we mea na defuina neungne na rahida Paska tonina nei, amani yeiai inontaraio ewatai na aitamu rorong ne manei. Ampafe meteyo itawing mano ahui weMananu we inontarai Yahudi nei we mea re?” ");
INSERT INTO amk_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Manamo kaiwasa bitoya foi ebibe eteyo, “Bereri, wiro inontarai nani fanai, mae Barabasi!” (Barabasi mani, raminde nanai yurai na rabuangno etapa parenta Roma foi paria, tuti inontarai niari ne karirafo dine.) ");
INSERT INTO amk_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Mayeaia Pilatusi suai afui kia Yesusi ariei tuti demi ne afai mamuna fosa erubati. ");
INSERT INTO amk_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Afai mamuna fosa etanung sapewi weababo bei na ai arirawang weababo foi, tuti etatari na Yesusi nunggamieifoi. Esansuni na ansung borieio kehe rawanderi tuti ne harga dedai fo, ");
INSERT INTO amk_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","mae etaha afong webeiru teai we emarari esomi wei eteyo, “Inontarai Yahudi ne ene mananune waune, amefiai wau!” Ainanaya eboipa Yesusi tarareia. ");
INSERT INTO amk_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Mayeai Pilatusi kiawariai nariai ahariei tuti medu we kaiwasa bitoya foi aha deyo, “Mewati! Ikari mandiei yohoni we mea, ambori mewaitawanai we wiro isobuai we dohong sarafi kutuea kahaia.” ");
INSERT INTO amk_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Yesusi kiawariai ariei, na nunggamieifoi sata sapewi weababo foi tuti sensung ansung borieio kehe rawanderi tuti ne harga dedai fo. Mayeai Pilatusi medu wesa aha deyo, “Mewatia inontaraifoi.” ");
INSERT INTO amk_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Na kutu imami baba fosa tuti mano ewaitawang wedua Sempaisi ne Munu fosa ewatia Yesusi nanai, ebibe eteyo, “Pahui na aitabafoi! Pahui na aitabafoi!” Pilatusi medu wesa aha deyo, “Meharia tuti mantaung mea mepahui na aitabafoi, weo wiro isobu fisarawafeai na i kaha fefe.” ");
INSERT INTO amk_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Inontarai Yahudi fosa emadu we Pilatusi aha eteyo, “Amene hukumi, tuti kariri hukumi nani mani, todoni kontaio sobu aiboi marareha fo, weo medu deyo i mani Allai ne Kaisung dine fefe.” ");
INSERT INTO amk_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Rabuang bo Pilatusi tarao kaiwofo nanai, mitaifo fuba pari aha, ");
INSERT INTO amk_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","tuti suai to rorongfo ahafui demi eha Yesusi ahafui dutang berahi aha deyo, “Wau mani na doni ma?” Manamo Yesusi wiro yoa wei kaha. ");
INSERT INTO amk_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ampafe Pilatusi medu wei aha deyo, “Maya we roa we yau kaha e? Boitawana kahai we nehu mambiriu we ikutu kaiwo kariri waufo ne? Weo masino yeyo kosau weru aiboi nini mani kaririai, tuti yeyo wobu aiboi marareha fo mani, finanai kaririai.” ");
INSERT INTO amk_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Yesusi medu wei aha deyo, “Masino Sempaisi dohong mambiriu we wau tonana kaha mani, wiro wemambiriu we kutu kaiwo kariri yau kaha. Ampafe yeikaririai we wau, we mano soa yau to waramurorongfe ma nini mani, ne sasarifoi fiabai sewa wau.” ");
INSERT INTO amk_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilatusi tarao Yesusi we medu tonanafo, yurai paria we sawing Yesusi. Manamo inontarai Yahudi fosa ebibe mambiriu eteyo, “Masino tawing inontarai nani weru aiboi marareha mani, wiro wemaniwowiri we Kaisari kaha. Mandoni dino deyo i mani mananu dine mani, wenani weaiteta we Kaisari.” ");
INSERT INTO amk_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilatusi tarao emadu tonanafo, demi eha Yesusi ariei, mae minohi na kadera eminohi nai we ehutu kaiwo foi na kataio wonongno Litrostotosi (Nang Kamiei) ete na kaiwo Iberani mani esahui we Gabatafoi. ");
INSERT INTO amk_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Rahida bonani mani, rahida mainenang we kameaia mani rahida Paska foi, kontai tete araha ureng suraya boru rahida rabuang. Pilatusi medu we inontarai Yahudi fosa deyo, “Mewati mene mananunei!” ");
INSERT INTO amk_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Manamo ebibe mantaung eteyo, “Muni weruai! Muni weruai! Pahui na aitabafoi!” Ainanaya Pilatusi medu wesa deyo, “Masi we ipahu mene mananunei na aitabafoi e?” Imami baba fosa eteyo, “Amene mananu siai manei kaha, mae Kaisari mesiri kawuru!” ");
INSERT INTO amk_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ampafe Pilatusi dohong Yesusi wesara we epahui na aitabafoia. Ampafe eha Yesusi ria Pilatusia. ");
INSERT INTO amk_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Yesusi mantauni sodua ne aitabafoi, da to boriei to kataio wonong fino Woming Nungkamiei, na kaiwo Iberani mani esahui we Golgota. ");
INSERT INTO amk_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Na katai nani epahui na aitabafoi. Inontarai siai mandu kontai epahu suru riati, amani manei na domoya manei na dowei, mae Yesusi ne rabuang. ");
INSERT INTO amk_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatusi demisa etata kaiwofeai na aitabafoi nunggamieifo. Kaiwo nanai dotu tono, Yesusi Inontarai Nazareti, WeMananu We Inontarai Yahudi. ");
INSERT INTO amk_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Inontarai Yahudi bitoya etato kaiwofo, weo katai epahu Yesusi nai foi kefang we bendarifoi tuti kaiwofo esoi na kaiwo Iberani, kaiwo Latini, tuti na kaiwo Yunani fefe. ");
INSERT INTO amk_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ainanaya imami baba we Yahudi fosa emadu we Pilatusi eteyo, “Wiro woi boyo, ‘WeMananu we inontarai Yahudi’ fanai, mae woi boyo, ‘Medu deyo: Yau mani, inontarai Yahudi ene Mananu di yau.’ ” ");
INSERT INTO amk_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Manamo Pilatusi medu wesa aha deyo, “Fianai aino isoia fo, manei wiro yiwang ahang kaha.” ");
INSERT INTO amk_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Afai mamuna fosa epahu Yesusia kai na aitabafoia fo, mayeai eha ne ansungfoa etatorai webea maisa, mansiari-mansiari sobu beyari tuti eha ne ansung boriei foi kontai. Ansung nani wiro etawari kaha, mae esairi na nungfo paria sobu awerengfo. ");
INSERT INTO amk_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Nanai wedaya emadu wawerasa eteyo, “Wiro tasabu ansungnei fanai, mae tahabi onde wei we mandoni dino sobui ne.” Enari tonanafo ambori mai kariri fianai aino dotu na Kaiwo Mararebana fo deyo, “Etato nehu ansungfo maisa, tuti ehabi onde we nehu ansung boriei foi.” Finanai, afai mamuna fosa ansaino enari ne. ");
INSERT INTO amk_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Kefang we Yesusi ne aitabafoi, Yesusi inangno doari na nanai tuti wiwing manei kontai, amani inangno ne tahatui dine. Na nanai kontai Mariai Klopasi binengfoi tuti Maria Makdalenai uroari kontai. ");
INSERT INTO amk_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Yesusi fioai ureng detiao inanai tuti ne inontarai dariatio enewawuti foi doari rurang inanai nanafo, medu we inanai deyo, “Aie, nemu arikangfi andinani!” ");
INSERT INTO amk_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Mayeai medu we ne inontarai dariati foi deyo, “Inamu dinani!” Na siari nanai to fongna fo, Yesusi ne inontarai dariatio enewawuti foi kia Yesusi inanaia minohi riati na ne munufoi. ");
INSERT INTO amk_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Mayeai Yesusi deitawanai we fikiaio soduati foi kiai ampa, tuti ambori fianai aino dotu na Kaiwo Mararebana fo kaririai, doni medu deyo, “Arohutataha.” ");
INSERT INTO amk_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Na nanai nofi bei sefang na anggurio sisasa suanai. Ampafe erorangno mandafeai na anggurifoa, tuti etubarai na ai esahui we hisopifoi to Yesusi borongfo ayai. ");
INSERT INTO amk_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesusi sisu anggurifoa kaifo medu deyo, “Kai ampa.” Ainanaya Yesusi kirai rahanangfoi to kofa tuti sawing nuaninufoi we Sempaisi. ");
INSERT INTO amk_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Rahida bonanai mani rahida emainenang fi kiai we rahida Sabati foi, katu wofoi sawaia mani rahida Sabati foi da ma finanai. Tuti mano ewefoniai we Yahudi fosa wiro eroa we na rahida Sabati foi mani mano emarareha na aitaba fosa etawai na aitabafoi kaha. Kontai rahida Sabati bonani tete rahida fuba Yahudifosa etohonsuari bei dine. Ampafe mano ewefoniai we Yahudi fosa era we Pilatusia tuti etutani we ambori afai mamuna fosa eharaikobu mano itosobu aiboi marareha fo nani sitoru itoawemifoa ambori itomarareha ahera tuti etu sitoru weru aitabafoi we esarai sitoru weruai. ");
INSERT INTO amk_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Ampafe afai mamuna fo era wa eharaikobu inontarai manduo epahu suru na une aitabafo ria Yesusi fo uawemifo fafong. ");
INSERT INTO amk_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Mayeai eteyo etabera we Yesusia mani, ewatioi we mireha kawurua. Ampafe wiro eharaikobu awengfo kaha. ");
INSERT INTO amk_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Wape afai mamuna fo manei disang ti Yesusi eneungfo na wombua aburuei, tuti rika tuti mereha deda na kahaifoi ariei. ");
INSERT INTO amk_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Inontarai mano deti finanai terai na urengfo, andino soi kariria ne tuti meduai kariri kaiwofo ne, tuti deitawanai we kaiwo meduairai nanai kaiwo tarai fine, ambori mea kontai meroasoai. ");
INSERT INTO amk_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Weo finanai kawariai tonanai ambori mai kariri kaiwo dotu na Kaiwo Mararebana foa fo, amani: ");
INSERT INTO amk_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Tuti Kaiwofeai dotu kontai tono: ");
INSERT INTO amk_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Yesusi mirehara fo, mayeai Yusupi inontarai Arimatea foi da wa dutang Pilatusi we yoa wei we kia Yesusia sirai. (Yusupi nini mani Yesusi ne inontarai dariati manei dine, manamo mitai mano ewefoniai we Yahudi fosa ampafe wiro daria Yesusi para kaha.) Pilatusi yoa we fio dutani wea fo, ampafe da wa kia Yesusi ne taraifoi. ");
INSERT INTO amk_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemusi, mano raminde da diruai ma dutang Yesusi foi kontai da riatai. Nikodemusi nini kia maning nunsai mampori fo, amani maning enariri na muri tuti na gaharu foi. Maning nani mirabafo tarahio kiro piareia sura rai. ");
INSERT INTO amk_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Uka Yesusi ne taraifoia, usansani na ireuo ne harga dedai foi tamu finunsai mampori fo, kariri koangno Yahudi foi we manei mireha mani enariri tonana fo. ");
INSERT INTO amk_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Kefang we katai epahu Yesusi na aitabafoi nani mani, romi bei tuti na romi nani fafo waworuo wiro arai manei nai kaharai bei na nanai. ");
INSERT INTO amk_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Rahida bonani rahida Yahudifosa emainenang fi we rahida Sabati foi dine tuti katu mani wofoi sawai werahida Sabati foi aha, tuti fafofoi wiro waroi kaha, ampafe eha Yesusi ne taraifoia etohoni wiatai na nanai. ");
INSERT INTO amk_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Na rahida bo reantenang foi amani rahida Minggu foi, kameai kutung, rerai we ahafoi fiorarisi, Maria Makdalenai da to fafofoia. Deti kamiei etadoiria wiatai wedua kamirei borongfo dedoi weru kamirei borongfoa. ");
INSERT INTO amk_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ampafe mitoa sera we Simon Petrusi tuti Yesusi ne inontarai mano enewawuti foi, tuti medu we suru deyo, “Eha Sempaisi ne taraifoi weru fafofoi ampa, tuti amewaitawana kahai we eharia etohoni wiatai na doni fo.” ");
INSERT INTO amk_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ainanaya Petrusi tuti mano Yesusi enewawuti nani, umito to fafofoa. ");
INSERT INTO amk_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Umito ruhiaia, wape mano Yesusi enewawuti foi ne fafong weru Petrusi awa sobu fafofo. ");
INSERT INTO amk_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Detikaha fafofo afui tuti deti ireu esansang Yesusi nai foi wiatai na fafo rorongfo, wape suai afui kaha. ");
INSERT INTO amk_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simon Petrusi nefui ma suai to fafofo afui. Deti ireu esansang Yesusi nai foi wiatai na kataifoi, ");
INSERT INTO amk_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","tuti ireuo eworabau nunggamiei nai foi, dedoia wiatai siai. ");
INSERT INTO amk_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Mayeai mano anta ne fafong weru Petrusi to fafofoa foi suai kontai afui, detioai tuti yoasoai. ");
INSERT INTO amk_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Paria sobu rahida bonani wiro etafu fianai aino dotu na Kaiwo Mararebana fo we i ambori suwi na marareha rorong foi aha fo kaha.) ");
INSERT INTO amk_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ainanaya Yesusi ne inontarai urariati fo suru, urarabera suru aha. ");
INSERT INTO amk_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Wape Maria Makdalenai wiro da kahai, mae doari na fafo borongfo mae sai we Yesusi. Sai tonanai mae suang deti to fafo rorongfo afui, ");
INSERT INTO amk_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","tuti deti wewai mandu, usansung ansung buakarofari, uminohi na katai etohong Yesusi wiatai nai foi, manei na nunggamieifo, manei na awerengfo. ");
INSERT INTO amk_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Wewaifo suru urutang berahi ureyo, “Aie, wai we fiani e?” Mariai yoa we suru deyo, “Nehu Sengnei ehari ampa, tuti iwaitawana kaha we etohoni wiatai na doni ne.” ");
INSERT INTO amk_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Medu tonanaia, mayeai fiobera ureng deti to kurufui afui mani, deti Yesusi we doari na nanai. Wape deroani we Yesusi dine kaha. ");
INSERT INTO amk_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Yesusi dutani deyo, “Aie, fiani wai wei ne? Mandoni dino wera wei ne?” Mariai deitarahio mano deitawang wedua romifoi dine, ainanaya dutang bera Yesusi aha deyo, “Daie, masino wau kari ne mani, boikaririai we yau we bohoni wiatai na doni, ambori ira wa ikari.” ");
INSERT INTO amk_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Yesusi medu we Mariai deyo, “Mariae!” Mariai kia bariri deti we Yesusia, ainanaya medu na kaiwo Iberani deyo, “Rabunie!” (Nana mani, Mantaunau.) ");
INSERT INTO amk_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Yesusi medu wei deyo, “Wiro ru yau fanai, weo wiro yarabera yau we Daia kaharai fefe, wape ro wa boikaririai we nehu doroiwasa tuti modurai wesa boyo, ninaia mani yarabera yau we nehu Dai tuti mene Daifoi, we nehu Seng Allai tuti mene Seng Allai foi.” ");
INSERT INTO amk_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ampafe Mariai da wa deikaririai we Yesusi ne inontarai erariati fosa, deyo, “Iwati Sempaisi ampa,” tuti deisaharai wesa kariri fi kiaio medurai wei fo. ");
INSERT INTO amk_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Na rahida Minggu siari nani, amani dirua, Yesusi ne inontarai erariati fosa efanduhisa na munu bei tuti ehafe rahutufoa marareha, weo ematai mano ewefoniai we Yahudi fosa fefe. Na tantuma Yesusi da wa doari rahansa tuti medu wesa deyo, “Mararebanafeai we mea.” ");
INSERT INTO amk_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Medu wesa tonanaia fo, mayeai deinawi warafangfo tuti eneungfoi wesa. Ewati Sempaisi tonanafo emirising paria. ");
INSERT INTO amk_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ainanaya Yesusi medu wesa nariai aha deyo, “Bengfeai we mea. Toyari Dai demi yau fo, tonanai kontai we yemi mea.” ");
INSERT INTO amk_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Medu wesa tonanaia, mayeai fiurarang ansengfoi wesa tuti medu wesa aha deyo, “Mesobuo Allai Nuaninu Mirarebana nei mau. ");
INSERT INTO amk_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Masino meteiai inontarai manei ne sasarifoi mani, sasari nani kontaio Allai deiairi. Mae wiro meteiai manei ne sasarifoi kaha mani, Allai kontai deiari kaha.” ");
INSERT INTO amk_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Wape rahida bonani mani, Tomasi, Yesusi ne inontarai suraya mandu fosa manei, mano esahui kontai we Didimusi foi, wiro kiontaisa na kutu anta Yesusi kiawariaio sa nana kaha. ");
INSERT INTO amk_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ampafe Yesusi ne inontarai erariati mano fau fosa emadu wei eteyo, “Amewati Sengnei ampa.” Manamo Tomasi medu wesa deyo, “Masino iwati warafang epahu fo kaha tuti isa warahukehane naya kaha, kontai wiro isa warahune na eneung etisang na wombua fo kaha mani, todoni kontaio wiro iroasoa kaha.” ");
INSERT INTO amk_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Rahida minggu bei aha mani, Yesusi ne inontarai erariati fosa efanduhisa nariai aha na katai nani tuti Tomasi kiontai riasa. Rahutufo ehafea marareha, wape Yesusi da wafui doari rahansa. Medu wesa deyo, “Bengfeai we mea.” ");
INSERT INTO amk_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Mayeai medu we Tomasi deyo, “Tomase! Boti warahufangne tuti tata waramukehawai na nina. Tuti tuba waramuwa ma tatarai na enehuungnei. Tuti enemurorong soriru ahang fanai, mae roasoai!” ");
INSERT INTO amk_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ainanaya Tomasi medu we Yesusi aha deyo, “Nehu Sengne wau, nehu Allai wau!” ");
INSERT INTO amk_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Ampafe Yesusi medu wei deyo, “Boti te yau na uremune, ampafe roasoai nina. Mahikaifeai we mano ewatioa kahai, wape eroasoa fosa.” ");
INSERT INTO amk_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Fitantuma bitoya kontaio Yesusi niariri na ne inontarai erariati fosa earomireafo, wape wiro finani oia kiai na bukunei kaha. ");
INSERT INTO amk_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Wape finini kiai oi ne mani, we ambori meroasoai we Yesusi mani, Kristusi dine, amani Mananu Mamparirio da na Allai ma foi dine, Allai ne Kaisung dine, tuti na meroasoifo metarang na tarai tuti mesobu numainufo na wonongfo. ");
INSERT INTO amk_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Mayeai aha mani, Yesusi deinawi ne taraifoi aha we ne inontarai erariati fosa na ruru Tiberiasi. Finanai kawariafo tonina. ");
INSERT INTO amk_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Rahida bei mani, Simon Petrusi, Tomasi mano esahui we Didimusi foi, Natanieli na bendari Kana na nu Galilea foi, Zebedeusi ne arikangfo suru, tuti ne inontarai erariati fo mandu siai kontai, efanduhisa. ");
INSERT INTO amk_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Petrusi medu wesa deyo, “Yeyo ira we imung erang.” Mano wei fosa emadu wei eteyo, “Amera riatai.” Ampafe era wa etautaio wafoa. Wape diru nania kameai mani, wiro esobu diang mansiari kahaia. ");
INSERT INTO amk_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Wofoi deo dautai nanai, Yesusi doari na nafarengfo, wape etaroani we Yesusi dine fo kaha. ");
INSERT INTO amk_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesusi medu wesa deyo, “Nehu arikangwa meaine, mesobu diang manea re?” Eroa wei eteyo, “Bereri.” ");
INSERT INTO amk_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Yesusi medu wesa deyo, “Mehabi erangwai to domoyawa aha, ambori mesobu diang manea ki.” Ainanaya ehabi erangfoi na domoyafoa, wape wiro ewemambiriu we erabiti ahang kaha, weo miko diang bitoya karera fefe. ");
INSERT INTO amk_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ainanaya Yesusi ne inontarai mano enewawuti foi medu we Petrusi deyo, “Sengnei andi reisi!” Rabuang bo Simon Petrusi taraoai we Sengfoi andinani fo, sata ne ansungfo (weo anta disu ne ansungfo we miung we diang fefe) ainanaya yobuia. ");
INSERT INTO amk_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Yesusi ne inontarai mano wei fosa fo ewo riatai to nafarengfo arei. Katai emung nai foi to nafarengfo arei mani waroi kaha, tarahio meteri piaring tea rai, tuti erabi erangno sefang na diangfoi nani arei. ");
INSERT INTO amk_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Na kutu ewo arei esobu reifo nanai, ewati adia bei werahisengfo dedoria tonanai tuti na adia rahiseng nani, keso diang manea nai tuti rotifeai. ");
INSERT INTO amk_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesusi medu wesa deyo, “Meha diangno arahio metafusa nani manea ma.” ");
INSERT INTO amk_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ainanaya Simon Petrusi dautai to wafoi ayai tuti yabi erangfoi arei. Erangfoi sefang na diang beba, ne fiaufo piaringna piarua sura suraya mantoru (153), tuti bitoya tonanai ki wape erangfoi wiro miabu kaha. ");
INSERT INTO amk_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Mayeai Yesusi medu wesa aha deyo, “Mera ma tuti metampi.” Yesusi medu tonanai wesa fo, wiro ne inontaraifosa manei wiro dutang berahi aha deyo, “Mandoni di wau?” nanai ahang kaha, weo ewaitawanai we i mani Sengnei dine. ");
INSERT INTO amk_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Yesusi saha tourai afong kia rotifo dohonai wesa, ainanaya niari tonanai na diangfo kontai. ");
INSERT INTO amk_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesusi deinawi ne taraifoi wesa tonana, na rahida suwi na marareha rorong foi aha ma fo, paria sobu rahida bonani mani we betoru finanai. ");
INSERT INTO amk_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Etampi ao kai tonanaia fo, Yesusi medu we Simon Petrusi deyo, “Simoni, Yohanesi ne kaisungne waune, enemuwawu yau fuba sewa weru inontarai ninisa re?” Simon Petrusi yoa wei deyo, “Yo, Sengne wau boitawanai we enehuwawu wau.” Yesusi deyo, “Bowawu nehu dombafosa.” ");
INSERT INTO amk_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesusi dutang Simoni weberu aha deyo, “Simoni, Yohanesi ne kaisungne waune, tarai we enemuwawu yau e?” Simon Petrusi yoa wei aha deyo, “Yo, Sengne wau boitawanai we enehuwawu wau.” Ainanaya Yesusi medu wei aha deyo, “Bowawu nehu domba rabuangnei.” ");
INSERT INTO amk_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Mayeai Yesusi dutang bariri webetorufo aha deyo, “Simoni, Yohanesi ne kaisungne waune, tarai we enemuwawu yau e?” Simon Petrusi taraoai we Yesusi dutani tonanai we betorufoa nanai saia. Tuti medu we Yesusi aha deyo, “Sengne waune, wau mani boitawang maino fifiani kontai. Boitawanai we enehuwawu wau.” Ampafe Yesusi medu wei aha deyo, “Bowawu nehu domba rabuangnei. ");
INSERT INTO amk_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Tarai antu! Imadurai we mea mau yeyo, tarai we raminde webariboaine mani, mantaung wau wora kota enemurabuangwa, tuti ro to katai bodoni kontaio boyo ro wei foi. Wape weinongtawara mani, ambori tuba waramuwa we inontarai siaia tuti wenani wiora wau tuti kia wau to kataio maya wei kaha foi ki.” ");
INSERT INTO amk_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Yesusi medu kaiwo nanafo we deinawi kariri Petrusi, todoni ambori mireha we wedaya inontarai etaparanding Allai na mireha nana foi. Mayeai medu we Petrusi aha deyo, “Ro ria yau.” ");
INSERT INTO amk_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petrusi deti berahaia mani, deti Yesusi ne inontaraio ewesuraya mandu fo mano Yesusi enewawuti foi we da ria suru. (Yesusi ne inontarai nini dino raminde eminohi etampi ruhiaifa mani, sauo Yesusi tuti andino dutang berahi deyo, “Sengne waune, mano dewayang wau nei mani mandoni dine?” fo.) ");
INSERT INTO amk_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Na kutu Petrusi deti Yesusi ne inontaraifoi nanai, medu we Yesusi deyo, “Sengne waune, inontarai nini fianai aino ambori sobuaifa ne?” ");
INSERT INTO amk_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesusi yoa wei deyo, “Masino yeyo ambori minohi darang paria yarabera yau aha ma mani, wiro nemu fieai we modu wea kaha. Wape wau mani, ro ria yau.” ");
INSERT INTO amk_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ampafe nanai wedaya Yesusi ne inontarai mano wei fosa emadurai na sa we eteyo mano Yesusi enewawuti nani wiro mireha kaha. Wape Yesusi wiro deisaharai we wiro mireha kaha, mae medu deyo, “Masino yeyo ambori inontarai nani minohi darang paria yarabera yau aha ma mani, wiro nemu fieai we modu wea kaha.” ");
INSERT INTO amk_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Inontarai nani dino meduairai kariri fininai kai ne, tuti andino soi kariria ne tuti tawaitawanai we fianai aino medurai nanai tarai. ");
INSERT INTO amk_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Fi bitoya paria Yesusi niari kontai, wape finanai kai oi kariria mesi kiai mani, enehutituai tarahio nunei wiro demang we buku fuba oi kariri fi Yesusi niariri nani fo kaha. ");
INSERT INTO amk_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Teofilus inong mano bontengwa wau. Na nehu buku bo reantenang wai yeiririai we wau kawurua kai ampa, kariri fi Yesusi niari tuti deunauwaia fo, ");
INSERT INTO amk_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","na reantenang kutu yuai fi niari fo, paria sobu rahida bo dau to rorafaisi fo. Wiro dau to rorafaisi kaharai mae, na mambiriuo Seng Allai Nuaninu Mirarebana foi dohong kaiwoariri we ne rasuli dirisa fosa, kariri fianai aino enari fo. ");
INSERT INTO amk_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","I mani mireha na aitabafoi kawuru ampa, mae na rahida bo suwi nai nani paria rahida piaru da re deinawi ne taraifoi we rasulifosa tuti niari fi na euremireafo, ambori ewaitawanai weo anture suwi na marareha rorong foi ampa. Ewatioi, kontai medu wesa kariri todoni Allai weMananufo. ");
INSERT INTO amk_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Tuti rabuang bo i minohi etampi ruhiaifa mani, demisa deyo, “Mera weru Yerusalemi fanai, wape metamang na ninaifa pariao Dai dohongno fifianai aino dereraia fo, amani aino yeikaririai kawuru we meara nanai. ");
INSERT INTO amk_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Weo Yohanesi webaptisi kaiwasa na mereha terai, wape rahida beiru teai aha mani Seng Allai webaptisi mea na Nuaninu Mirarebana foi, amani sensoni mea ki.” ");
INSERT INTO amk_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ampafe rahida bo rasulifosa efanduhisa ria Yesusi nana fo, etutang bera Yesusi eteyo, “Sengne waune, tofino? Boyo bohong Yahudine amea we ametoa siai weru Romafosa, mano eru amea nesa finina e?” ");
INSERT INTO amk_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Medu wesa deyo, “Nanane mani, wiro fi weo mea mewaitawana fine kaha. Weo Dai meiri andino medu kiutu kaiwofo na ne mambiriufo ne. ");
INSERT INTO amk_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Wape mea, Nuaninu Mirarebana foi da we mea ma mani, ambori mesobu mambiriu ki. Ampafe fio mewati yau inari ne tuti fi yeunauwi we mea mani, metaiririai na bendari Yerusalemi nei, kontai na nu Yudea nei sentenang, tuti na nu Samaria foi, tuti katai siai paria sobu nunei werea naya fo.” ");
INSERT INTO amk_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yesusi medu kaiwofoa kai nanafo, Seng Allai yuaisi to rorafaisi na euremireafo, tutu kafafe weduari weru eara ampafe wiro ewatioi ahang kaha. ");
INSERT INTO amk_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Na siario etoa esairaria Yesusi dau to rorafaisi nana fo, tatofang kutu nanai kontaio, inontarai uwemandu uroa riasa. Ansung usansuna fo bua karofari webeyari. ");
INSERT INTO amk_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Umadu wesa ureyo, “Inontarai Galilea wa meaine, we fiani e metoari na katai kutu siari nani mae mewati we rorafaisi wei ne? Yesusi, mano mewatioi dau to rorafaisi na meuremirea fenani, ambori daraberahi aha ma ki. Daraberahi aha ma fo mani, na kafafe rorong, ne tarai mai kariri mewatioi dau to rorafaisi nanai.” ");
INSERT INTO amk_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Mayeai rasulifosa etaraberasa weru wiwoi Saituni to bendari Yerusalemi aha. Wiwoifoi wiata waroifo tarahi kiro bei teai weru Yerusalemi. ");
INSERT INTO amk_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Na Yerusalemi era to munu bo eminohi nai foi, ainanaya etautai to rorong bo yai pari foi. Rasulifosa mani, Petrusi, Yohanesi, Yakobusi, Andareasi, Pilipusi, Tomasi, Bartolomasi, Matiusi, Yakobusi mano Alfiusi ne arikangfoi, Simoni (mano biriu we inontarai Israeli fosa etoa siai weru Romafosa), tutu Yudasi mano Yakobusi ne kaisungfoi. ");
INSERT INTO amk_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Rasulifosa kiai, konta Mariai (Yesusi inanai), ne tahatuifosa, kontai wiwing maneiru teai (mano eraria Yesusi fosa), enemirorong boyari efanduhisa ewenadi pampang. ");
INSERT INTO amk_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Mano eroasoai efanduhia fosa mani ewepiaringnao piarei (120) teai. Rahida bei aha mani Petrusi doa rahansa medu wesa, ");
INSERT INTO amk_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","17","deyo, “Nehu doroi bohi ne meaine! Fiani aino fafongfa Nuaninu Mirarebana foi medu na Mananu Dauti, tuti Dauti soi kaririai na Sengnei ne Kaiwofo, kariri Yudasifo, nana mani mai kaririai ampa. Yudasi nani mani, tane inontarai manei dine, tuti i kontaio Sengnei diriria weo niari fi tanari ne kontai. Wape i mano kia inontaraio etafu Yesusi fosa dine. ");
INSERT INTO amk_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Yudasi nini sobu fiembaitai ria imamifosa weo fikarira pari niari fo, amani dewayang Yesusi fefe. Doi etohonai we fiembaitai nanai wiori kahofafeai nayai. I sawai, mireha, saupori eneng awa enewairifoi tirurang kiai to boriaia wia nayai. ");
INSERT INTO amk_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Kaiwasa fuba eminohi na Yerusalemi fosa ewaitawangno Yudasi ne mireha toa fo. Ampefe katai Yudasi wioriri nani, esahui na kaiwo ene etohoni wonongno Akeldama, nana mani Kahofa Rika. ");
INSERT INTO amk_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ne tonanane kai kariri kaiwo Dauti soi fo, na buku Masmuri, amani dotu toninai: ‘Ne katai minohi naya ne watai wawui, wiro manei minohi naya fanai.’ Ampefe soi toninai kontai: ");
INSERT INTO amk_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Petrusi medu aha deyo, “Ampefe rahida nini tatiri manei we yiwang Yudasi weo kiontai rasuline amea, we ametaiririai we kaiwasa bitoya nei weo Yesusi amewati teri na ameuremireane weo suwi na marareha rorong fi ampa. Mano tatiriri nei mani, manei na inontaraio tararia Seng Yesusi pampang ne tata to katai doni daoa fo, na rahida bo Yohanesi webaptisia fo, paria sobu dau to rorafaisi weru tata naya fo.” ");
INSERT INTO amk_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Amani mano efanduhisa nanisa, etainawi uwemandu, amani Yusupi, mano esahui we Barsabasi (esahui kontai we Yustusifoi), tutu manei aha mani, wonong fino Matiasi. ");
INSERT INTO amk_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ainanaya ewenadi, eteyo, “Sengne waune, wau boitawang kaiwasa enemirorongnei kiai ne. Rahida nini boinawiai we amea, na inontarai mandu nini suru, mantei dino biriri ");
INSERT INTO amk_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","weo werasuli yiwangno Yudasine. Weo Yudasi sawai weru rasulife ampa tuti mireha ampa.” ");
INSERT INTO amk_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Mayeai ehabi onde weo inontarai mandu fo suru, amani tetera fino Matiasi. Ampefe eruaisi we rasuli kiontai ria ewesuraya mansiri fosa. ");
INSERT INTO amk_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Rahida fuba Yahudi bei, amani Yahudifosa esahui weo rahida Pentakosta dine, amani inontarai eroasoa fosa efanduhisa na munu bei. ");
INSERT INTO amk_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Mayeai etaramio fiei dotu tantuma na rorafaisi, nikuayai toyario dobarai fenana. Ne nikuayafo bia meu kenggingno munu eminohi nai foi sentenang. ");
INSERT INTO amk_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Mayeai ewatio fi ne tarai toyario adia ureng fenanai tibohawai wari katai eminohi nai foi, tutu awao sioiriosa. ");
INSERT INTO amk_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Sengnei Nuaninu Mirarebana foi sensoni ea kiai tutu dohonsa emadu na kaiwo aisei bitoya paria, amani kaiwo ewaitawana kaha. ");
INSERT INTO amk_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Na rabuang bonani mani, inontarai Yahudi bitoya na nunei sentenang enayai na Yerusalemi. Ea inontarai eroaso Seng Allai. ");
INSERT INTO amk_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Rabuang bo etarami fi dotu foi nana fo, kaiwasa bitoya paria era ma efanduhisa. Ea kiai ehababerasa we etarami rasulifosa emadu na kaiwasa fuba da ma nani ene kaiwofo fefe. ");
INSERT INTO amk_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Epapuhung tuti enemiwawera weai, emadu eteyo, “Inontarai emadu ninsa mani, ea kiai inontarai Galilea saine mae! ");
INSERT INTO amk_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Tonana mani todonie tatarami terai weo emadu na tane kaiwofe kiai ninai? ");
INSERT INTO amk_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","11","Tata inontarai na nu Partia, Media, Elami, Mesopotamia, Yudea, Kapadokia, Pontusi, Asia, Frigia, Pamfilia, na Mesiri tutu katai na Libia kefang we bendari Kirene, na nu Kreta tutu na Arapi, manea kontai na bendari Roma. Tata mani inontarai Yahudi tuti wiro inontarai Yahudi kaha, wape tata kiai tane agama Yahudi. Tataramioai we emadu na tane kaiwone kiai, emadu kariri fitantuma Allai niari fo.” ");
INSERT INTO amk_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ea kiai epapuhung paria, etutang wawerasa, eteyo, “Fitantuma tawatioai ninai, taserawawerahai paria!” ");
INSERT INTO amk_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Wape manea eteiberahaifa eteyo, “Ah! Emayeru, ampefe emadu funomai.” ");
INSERT INTO amk_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ainanaya Petrusi doari ria Yesusi ne inontarai mano ewesuraya mansiari wei fosa, mayeai medu we kaiwasa bitoya foi na rawafui fiebai deyo, “Doroi bohi Yahudine meaine, tuti mano menayai na Yerusalemine meaine. Mefobibi metaramiwa we metarami nariaifa, weo yeyo yeikaririai we mea kariri fifianai aino rahida bonini mewatioai ninai. ");
INSERT INTO amk_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Inontarai ninisa wiro emayeru kariri meteyoawa kaha, weo kameaine rai arahio araha ureng indiata ninai. ");
INSERT INTO amk_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Wape fianai aino rahida bonini mewatioai ninai, Seng Allai medurai kawuru na fafongfa ria nabi Yoweli ampa. ");
INSERT INTO amk_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Amani Allai medu deyo, ‘Rerai we rahida Sengnei kife nunei foi mani, ambori yenatu Nuhuaninu Mirarebana nei we kaiwasanei sentenang ki. Ampafe mene arikangnesa, wiwing tuti mang, ambori emadu fio yohonai wesa we emadura fo, amani kariri fio ambori kawariai fo. Bariboaiwasa ambori ewati fiainawiaio yeinawiai wesa we ewatioa fo. Wawafosa ambori etamiei kariri amieio yohoni wesa foi ki. ");
INSERT INTO amk_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","We nehu womingnesa kontai, wiwing tuti mang, ambori yenatu Nuhuaninu Mirarebana nei na rahida bonani we sensonisa. Ambori emadu fio yohonai wesa we emadura fo, amani kariri fio ambori kawariai fo. ");
INSERT INTO amk_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ambori yeinawi fitantuma bitoya na rorafaisi, tuti fitantuma fiebai na kofa na nunei, toyari atio rika tuti adia, tuti riraung dautai tikahipa kontai ki. ");
INSERT INTO amk_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Wiro Rahida Fiebai Mirarebana foi, amani rahida Sengnei daraberahi nai ma foi kaharai mae, wofaisi ambori memantiti ki, tuti embaifaisi ambori berika kariri rika ki. ");
INSERT INTO amk_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Rabuang bonani mandoni dino sahu Sempaisi wonongfo mani ambori kiaharai weru ne karirafo.’ ");
INSERT INTO amk_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Doroi bohi inontarai Israeli ne meaine. Metaramio kaiwo fianai aino imadurai ninai kariri Yesusi na Nazareti foi. Na fitantuma fuba Seng Allai niari rahang mea na Yesusi, deinawiai kasau we mea weo yuaisi, demi biari we mea meu. Ne nanai mewaitawanai ampa. ");
INSERT INTO amk_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Kariri mantauni ne enetituaitafo kiutuai we dohong Yesusi we mea meu, wape memuni, amani metua inontarai eharira fosa epahui na aitabafoia mireha. ");
INSERT INTO amk_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Wape Seng Allai duwiri suwi na marareha rorong foi aha. Mararehafoi kiari, wape Allai fioresuwi weru warangfo, weo todoni kontaio mararehafoi yu weduari kaha rai. ");
INSERT INTO amk_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Yesusi nini dino raminde Dauti medu kariri kontai deyo, ‘Iwati Sengnei doari pampang na arohune, Da ria yau na warahu domoya nei, ampafe fiani kontaio dohong yau irirora kaha. ");
INSERT INTO amk_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Nanai wedaya enehurorongnei mirising, ifiai Sempaisi na borohunei, tuti iminohiwau enehutawang Sempaisi pampang. ");
INSERT INTO amk_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Weo wiro tua nuhuaninunei wiatai na marareha rorong foi kaha, tuti wiro tua nemu Mano Mirarebana ne yau inaia iworu na fafo rorong fo kaha. ");
INSERT INTO amk_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Boinawiai we yau ampa rangno da to numainufo. Ambori bohong yau ifaraise katui ahang kaha, weo weriria yau pampang fefe.’ ");
INSERT INTO amk_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Doroi bohine mea, tawaitawanai ampa weo tane werengno Dauti mireha ampa tuti esarai ampa, paria sobu rahida bonini ne fafofoi wia rahang tatane, ampafe fi medu kariri ne taraifoi we wioru kaha fo mani dotu we mantauni kaha, wape kariri manei siai. ");
INSERT INTO amk_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Wape nabi dine, ampafe deitawanai weo Seng Allai dereraia fefora tutirai, weo ambori yuai manei na ne riria rabuang foi we wemananu ki. ");
INSERT INTO amk_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Donio deti to fong medu kaririaifa weo Mananu Mampariri Seng Allai dereria foi ambori suwi na marareha rorong foi aha ki, amani medu deyo, ‘I wiro Seng Allai suati wiatai na marareha rorong foi kaha, tuti ne taraifoi wiro niaya wioru kaha.’ ");
INSERT INTO amk_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Yesusi nini mani Seng Allai duwiri na marareha rorong fi ampa. Finanai mani amewati terai na ameuremireane. ");
INSERT INTO amk_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Seng Allai yuaisia minohi na warang domoya fo, tuti sobu Nuaninu Mirarebana foi riati, ampafe denatui we amea meu kariri dereraia fo, donio rahida bonini Nuaninu Mirarebanai nani mewati teri na meuremine tuti metarami teri na metarami feninai. ");
INSERT INTO amk_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tarai Yesusi mani Seng dine, weo Dauti mantauni wiro dautai to rorafaisi kaha, wape medu kaririai deyo, ‘Seng Allai medu we nehu Sengnei deyo, “Munohi na warahu domoya ne, ");
INSERT INTO amk_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","pariao inari nemu aitetawausa etawaia ehai tuti esomia ehai we wau.”’ ");
INSERT INTO amk_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Ampafe nanai aino inontarai Israeline mea kiai todoni kontaio mewaitawang kepanai na mai we Yesusi mano mepahui sawai na aitaba finani, andino Allai yuaisi we Seng tuti we Mananu Mampariri ne.” ");
INSERT INTO amk_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Na kutu etarami kaiwo fenanai, etatua wawerasa paria. Ainanaya etutang bera Petrusi tuti rasuli mano wei fosa eteyo, “Tonana mani ambori ametohong todoni ki?” ");
INSERT INTO amk_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Petrusi yoa wesa deyo, “Metauberahai weru mene sasariwai. Tuti mansiari-mansiari wau webaptisi na Yesus Kristusi wonongne, ambori Seng Allai deiai mene sasariwai, tuti ambori mesobu Nuaninu Mirarebana foi riati. ");
INSERT INTO amk_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Weo Seng Allai ne dererai ninai dohonai we mea, mene arikangfosa tuti we mano enai na nu waroi fosa kiai, amani inontarai kiaio ambori Seng Allai, tane Sengnei, sahu ruhisa we erariati ma fosa.” ");
INSERT INTO amk_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Petrusi deikaririai wesa tonanai, tuti na kaiwoariri siai bitoya meduri foi kontai, deretawansa tuti deunausa we eroasoai, deyo, “Metanansiau, weo inontarai eharira fosa esobu aiboi maraba ki.” ");
INSERT INTO amk_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Kaiwasa bitoya eroaso fiani aino Petrusi medura fo, ainanaya ewebaptisi. Ampafe na rahida bonani kaiwasa eroasoa fosa efau ehontai aha, amani ewepiaura wering wetoru (3.000). ");
INSERT INTO amk_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Efanduhisa pampang we esobu aunaufo ria rasulifosa, we etampi ruhiai tuti we ewenadi ruhiai, tuti eweboyari riasa pampang. ");
INSERT INTO amk_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Seng Allai niari fitantuma bitoya paria ria rasulifosa, ampefe kaiwasa bitoya na Yerusalemi fosa ematai tutu esomi wei. ");
INSERT INTO amk_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Inontarai eroasoa fosa kiai eweboyari pampang. Fianai aino eneng fo esahuai we fi ene ruhiai. ");
INSERT INTO amk_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Ene ra eminohi tutira fo etawayanai, doifo etatorai mai sa kiai kariri fianai aino mansiari-mansiari ewepararura fo. ");
INSERT INTO amk_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Na rahida neungfo efanduhisa pampang na Allai ne Munufoi refongfoi, we ewenadi wei, kontai na ene munu rorong fo etampi ruhiai na enemirorong mei tuti mirising. ");
INSERT INTO amk_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Efiai Seng Allai pampang, tuti kaiwasafoi kiai enemirorong mirising wesa. Rahida neungfo Sempaisi sahu kaiwasa siai bitoya we ehontaisa, amani inontaraio arahi feririsa weru ene sasarifoi. ");
INSERT INTO amk_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Na rahida bei araha ureng botoru, amani rahida we Yahudifosa ewenadi. Ampefe Petrusi tuti Yohanesi ura to Sempaisi ne Munufoi we uwenadi nai. ");
INSERT INTO amk_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Na wanai, inontarai mang manei, fiaya na siario saubaununggamiai fa. Rahida neungne ne maniwowiri manea eharia minohi na rahutu borong esahuai we Rahutu Mehikai weo dedo we doi ria inontarai esuayai to Sempaisi ne Munufoi afuifo. ");
INSERT INTO amk_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Na kutu siario inontaraifoi deti Petrusi tuti Yohanesi ure usuayai to Sempaisi ne Munufoi fo, dutang suru we urohong doi wei. ");
INSERT INTO amk_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ampefe usaite inontaraifoi, mayea Petrusi medu wei deyo, “Boti we auru ma.” ");
INSERT INTO amk_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ainanaya inontaraifoi seiraria suru, enetawanai weo ambori sobu fieai ria suru. ");
INSERT INTO amk_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Manamo Petrusi medu wei deyo, “Nehu sobu doi bei kahai arorawa, wape fianai aino nayai ria yau ne, nanai aino ambori yohonai we wau. Na Yesus Kristusi inontarai Nazareti foi ne mambiriufo, boa ro!” ");
INSERT INTO amk_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ainanaya Petrusi yu na inontarai fiaya foi warang domoya foi tuti fiataria doabariri. Na tatofang kutu nanai kontai awengfo tuti aweng kamiei neung fo suru umutubaru. ");
INSERT INTO amk_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ainanaya i soiria doa tuti da towana toninai, mayeai da ria Petrusi tutu Yohanesi to Sempaisi ne Munufoi refongfo afui, da tutu sioiri fiai Seng Allai. ");
INSERT INTO amk_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Kaiwasa na nana fosa kiai ewatioi we da tutu fiai Seng Allaifo. ");
INSERT INTO amk_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Ainanaya etaroansoi we i mani inontaraio fiaya minohi dedo we fi na rahutu borong Rahutu Mehikai foi na Sempaisi ne Munufoi. Ampefe ehiri ewarami paria tutu esomi, weo ewati inontarai fiaya foi dentengna fefe. ");
INSERT INTO amk_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Inontarai nani weriria suru pampang, itosuai to Sempaisi ne Munufoi refongfo afui. Itoroari na refongno esahuai we Refong Salomo foi. Kaiwasafoi kiai na nanai emito kiai ma etoa wari sitoru weo epapuhung paria fefe. ");
INSERT INTO amk_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Petrusi deti kaiwasa bitoya foi nanai, medu wesa deyo, “Inontarai Israeline meaine. We fiani e mepapuhung kareraifa tuti mesaite antoru pampang ninai? Mewaitarahio na aune mambiriune ete na aurohong kariri Allai ne Kaiwone aino wedaya inontarai nini doabariri da nina e? ");
INSERT INTO amk_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Bireri, mae Allai mano tane werengfosa esomi wei foi, Allai Abrahami, Allai Isaki tuti Allai Yakupi, Allai nani dino yuai ne womingno Yesusia dedai sambewarai mantaung. Yesusi nani dino raminde metohoni to mano eru mananu fosa we emuni, tuti meteipari na Pilatusi arongreafo, amani na rabuang bo deyo sawini weru aiboifoi fo. ");
INSERT INTO amk_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","I mirarebanai tuti mei wape metapai tuti metanggewarai pampang ampafe Pilatusi sawini kaha, mae sawingno weming inontarai manei we mea. ");
INSERT INTO amk_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","I mani andino dohong anseng we tata kiai tuti tasobu numainufo riati, manamo memuni. Wape Allai duwiria suwi kawuru na marareha rorong fi ampa, ne nanai amewati terai na ameuremine tuti amemadu kaririai. ");
INSERT INTO amk_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Rahida bonini mewati terai na meuremine kiai kariri fifianai aino inontarai nini sodaira ne. I awengne mutubaru, wemambiriu we doa da aha nina ne, weo auroasoai na Yesusi wonongfo. Na Yesusi wonongfo nanai wedaya denteng na meuremirea feninai. ");
INSERT INTO amk_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Doroi meaine. Ninaifa amani iwaitawanai we fianai aino mea tuti mene mano ewewafoniai we mea wasa, fi menari we Yesusi nanai meserawawerahai. ");
INSERT INTO amk_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Wape na ne toninane donio, fianai aino Allai medurai kawuru na fafongfa ria ne nabifesara fo, weo Mananu Mampariri foi todoni kontaio sodai dadirafo ki, kaiwo nanai aino kawariai anina weo Allai andino wedaya tonanai. ");
INSERT INTO amk_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ampafe doroi mea kiai, metarabera mea weru mene sasariwai, mera we Allai aha ambori waraira mene sasariwai tuti dohong maifo we mea ki, amani Nuaninu Mirarebana foi dohong mea mearomiwa fanahang. ");
INSERT INTO amk_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Tuti ambori demi Yesusi da we mea aha ma, weo yuaisi kawuru we weMananu Mampariri we mea ampa. ");
INSERT INTO amk_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Yesusi nani minohi na rorafaisi terai paria Seng Allai niari fianggeng fuba nini kiai weworu aha, kariri fianai aino fafongfa medurai na ne nabi emararebana fosara foi. ");
INSERT INTO amk_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Yesusi nani Musai medurai kawuru kontai ampa deyo, ");
INSERT INTO amk_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Mandoni dino taradidau Nabifoi kaha mani, wenani ambori Allai warapari weru ne inontaraifosa tuti sodai karirafo.’ ");
INSERT INTO amk_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Tarai, nabi fubao emadu kariri Sempaisi ne Kaiwofe kawurua fosa, amani na nabi Samueli tuti nabi siaio era tuari aha ma fosa, ea kiai emadu kariri rabuang bonini. ");
INSERT INTO amk_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Sempaisi ne Kaiwo Areraio nabifesa emaduri nani, amani we mea. Na Allai ne Kaiwo Areraio meduri we mene werengno Abrahami mani dotu toninai: ‘Na nemu ririanei ambori imoang kaiwasanei kiai na nunei ki.’ Kaiwo arerai nanai we mea kontai. ");
INSERT INTO amk_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ampafe doni Allai yuai ne womingfoi, we demi da we Yahudine mea fafong ma, ambori mioang mea, amani dohong mea metarabera mea weru mene karira metohona fo.” ");
INSERT INTO amk_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Petrusi tuti Yohanesi uroa umadu ria inontaraifosa tonana rai mae, imamifosa tuti mano wenunggamiei weo mano ewaitawang wedua Sempaisi ne Munufoi fo, kontai inontarai eweSaduki fosa, era rufang uru ma. ");
INSERT INTO amk_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ehasou paria we umadurai weo kaiwasafosa weo, Yesusi suwi na marareha rorong fi ampa. Umadurai wesa ureyo, ne tonanane deinawiaifa we inontarai emarareha fosa ambori esuwi aha ki. ");
INSERT INTO amk_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ampafe etafu rasulifo suru eha suru to aitamu rorong fo, manamo diru ampefe uwa na aitamu rorong fo paria sobu kameai. ");
INSERT INTO amk_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Wape kaiwasa etarami rasulifo suru une aunaufo, bitoya paria eroasoa ampefe kaiwasa eroaso Seng Yesusi efau aha, tarahio ewepiaura weura wering teai (5.000). ");
INSERT INTO amk_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Ahara mani Majelisi Agama fosa efanduhisa na Yerusalemi. Ea mani mano ewenunggamiei weo Yahudi fosa, mano ewewafoniai fosa tuti mantaunau Kaiwo Musai soi fosa. ");
INSERT INTO amk_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Efanduhisa ria imami fuba Hanasi, kontai Kayafasi, Yohanesi, Aleksanderi tutu mano ene fami boyari ria imami fuba foi. ");
INSERT INTO amk_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Mayeai eha Petrusi tutu Yohanesi awa uroari na earomireafo etutang bera suru eteyo, “Muraikaririai we amea, todonie munari inontarai fiaya fi denteng nina? Na mambiriu fiani tuti na mandoni wonongne munari finanai?” ");
INSERT INTO amk_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ainanaya Seng Allai Nuaninu Mirarebana foi sensoni Petrusi, ampefe medu wesa deyo, “Dai mea, mano mewenunggamiai tutu mewewafoniai ne mea. ");
INSERT INTO amk_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Na rahida bonini auroari na meuremireane, metutang bera weo aunari fi mahikai weo aufata inontarai fiaya foi, tutu weo meteo mewaitawang kariri todonie aunariri denteng toa fo! ");
INSERT INTO amk_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Tonana mani metarami ma, mea kiai tuti inontarai Yahudi na nu Israeli ne tata kiai, todoni kontai mewaitawanai weo inontarai nini mewatioi we dentengna, doari na meuremireafe nina mani, na Yesus Kristusi inontarai Nazareti foi ne mambiriufo tutu wonong mananu fo. Yesusi nini mani, mea kiai mepahui na aitabafoi mireha, wape Allai dohoni suwi aha. ");
INSERT INTO amk_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesusi nini dino Sengnei ne Kaiwo arawang bonini dotu wei ne: ‘Kamieio mano menari munune mea, mehabioifi, andino wekamiei reantenang metang kamiei doa sauwi ampa.’ ");
INSERT INTO amk_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Weo Yesusi mesiri andino weMampariri we feriri inontaraife tatane. We na inonotarai fuba nunei sentenang wiro manei siai sobu mambiriu na Allai weo feriri tata kaha.” ");
INSERT INTO amk_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Majelisi Agama fosa ewaitawanai weo Petrusi tutu Yohanesi suru mani inontarai usewai kaha tutu usobu aunau dadai fea kaha, wape ewati suru mani umadu na mai tutu umatai kaha, nanafo epapuhung paria. Ainanaya ewaitawanai weo uru mani inontarai eraria Yesusi fe mandu aine. ");
INSERT INTO amk_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Wape wiro emadu fieai ahang kaha, weo inontarai ufataria denteng foi doari ria suru na euremireafo fefe. ");
INSERT INTO amk_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ampefe etemi rasulifo suru ura to boriei weru rorong eminohi nai foi, ainanaya emadu kariri fifianai aino enari we suru fo. ");
INSERT INTO amk_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Emadu eteyo, “Tanari fiani we inontarai nini suru? Weo kaiwasa na Yerusalemi nesa kiai ewaitawanai kawuru ampa we uru unari fitantuma fiebai paria. Fi unariri nani wiro tafaforai kaha. ");
INSERT INTO amk_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Wape ambori kaiwoaririne wuwuai na kaiwasa bitoya foi kaha mani, tahasou suru tutu tafafora wedua suru weo wiro urairiri Yesusi we manea ahang fanai.” ");
INSERT INTO amk_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ampefe esahu rasulifo suru mampui, etaretawang suru weo dohonao umadu tutu uraunau na Yesusi wonongne ahang fanai. ");
INSERT INTO amk_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Manamo Petrusi tutu Yohanesi uroa wesa ureyo, “Mantaung mea menemitituai weai, we fianai aino wetarai na Allai urengreafo ne; aurohong kariri mene kaiwone, ete aurohong kariri Seng Allai ne Kaiwone ne? ");
INSERT INTO amk_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Weo wiro amefotou amemadu kariri fifianai aino ametaramioai tutu amewati terai na ameuremireane, kariri fianai aino Yesusi medurai tutu niari fo.” ");
INSERT INTO amk_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Majelisi Agama fosa etaretawang surufo mamboni paria, ainanaya etawing uru ura wa. Weo eserawawerahai etohong aiboi fiani we suru, weo kaiwasafoi efiai tutu etaparanding Sempaisi paria we fitantuma unari fo. ");
INSERT INTO amk_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Inontarai mano sobu fitantuma fuba paria denteng nani ne defuina piaru ampa. ");
INSERT INTO amk_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Etawing Petrusi tutu Yohanesi ura to boriei nanafo, urarabera uru we une maniwowirifosa aha, urairiri fifianai aino imami baba fosa tutu mano ewenunggamiei we Yahudi fosa eteyoa fo. ");
INSERT INTO amk_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Etarami kaiwo fenana fo, ea kiai ewenadi we Sempaisi na enemirorong boyari. Ewenadi eteyo, “Mananu Sengne Wau, Wauno nari rorafaisi, airausi tutu reireisi, kontai fi niai nai foi sentenang ne. ");
INSERT INTO amk_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Na Numuaninu Mirarebana wai fafongfa modu kawuru ria amene werengno Dauti, nemu womingfoi, modu kariri kaiwasa ambori eweaiteta we Seng Yesusi, boyo, ‘Todonie inontarai Yahudi kaha fosa ehasou? Todonie kaiwasa fuba nunei enemitituai ne beng kaha fo ninai? Fio enari fo wiro wefiea kaha. ");
INSERT INTO amk_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Mananu na nunei sentenang emainena we emamuna, tutu mananufosa eweboyari we eweaiteta we Sengnei tutu Mananu Mampariri foi.’ ");
INSERT INTO amk_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Weo antu, Mananu Herodesi tutu Pontiusi Pilatusi ufanduhi inontaraio Yahudi kaha nesa, amani inontarai Roma nesa, tutu inontarai Israeli nesa kontai. Efanduhisa na bendari bonini eweboyari eweaiteta weo Yesusi nemu Mangfatao mei mirarebana foi, andino ruaisi weMananu Mampariri. ");
INSERT INTO amk_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Eweboyari we enari maino fisarawai, weo fafongfa wau na nemu mambiriuwa, modurai weo finanai ambori kawariai ki. Ampafe tarai, arahio kawariai ampa! ");
INSERT INTO amk_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Sengne wau boti ma, taramuo todoni etohong tati amea nina. Ampafe bohong mambiriu we amea, ambori ametairiri nemu kaiwone na mai tutu wiro amematai kaha. ");
INSERT INTO amk_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Bohong nemu mambiriuwa weo amea ambori amenari inontarai emaninang ebeng tutu amenari fitantuma siai bitoya we inontarai nunesa na Yesusi, nemu arikangno mei mirarebana foi, ne mambiriufo tutu na wonongfo.” ");
INSERT INTO amk_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ewenadia kai nanafo, ne tarai toyari mundiai fenanai, fio rirou katai eminohi nai foi. Ea kiai Nuaninu Mirarebana foi sensonisa ampafe esobu mambiriu paria tutu ematai kahai we etairiri Allai ne Kaiwo kariri Yesusi fo. ");
INSERT INTO amk_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Kaiwasa fuba eroasoai nanisa enemirorong boyari eminohi na mai. Na ea kiai manei ne fiea mani sahuai we ne fisiai kaha, mae fianai aino esobua fo esahuai we ene ruhiai. ");
INSERT INTO amk_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Na mambiriu fuba Allai dohonai we rasulifosa etaiririai we kaiwasa bitoya foi weo Seng Yesusi suwi weru marareha rorong fe ampa. Ampafe Allai mioang ea paria. ");
INSERT INTO amk_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Na ea kiai manei wiro sobu dadirafea kaha, weo wea mani, mano ene kahofa ete munu fosa etawayanai, ambori doi etawayang weai nanai ehara ");
INSERT INTO amk_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","etohonai we rasulifosa. Mayeai rasulifosa etato doi nanai we mano ene pari fi fosa. ");
INSERT INTO amk_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Yusupi kontai tonanai. I mani inontarai weriria na Lewi dine, na nu Siprusi. Rasulifosa esahui kontai weo Barnabasi ete Arikang Kia Mirising. ");
INSERT INTO amk_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","I dewayang ne kahofafo, ainanaya doi dewayang wea fo kiara dohonaio rasulifosa. ");
INSERT INTO amk_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Inontarai manei wonong fino Ananiasi, ne wiwing wonong fino Sapirai. Urawayang une kahofafeai. ");
INSERT INTO amk_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Doi urawayang wea fo, unemirorong boyari we urato kutuai weberu. Weai ma unemitawanai watai we uru, mae weai kiara dohonaio rasulifosa we etatorai. Medu wesa deyo, “Doi aurawayang wea fei nina kai.” ");
INSERT INTO amk_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ampafe Petrusi medu wei deyo, “Ananiasie, todoni fino tua Saminsenie sensoni enemurorongwai, paria doni totofa Allai Nuaninu fininai? Na mamunggasai boaria enemutawang doi bowayang weai na kahofa fenanai, bohong weaia watai we wau. ");
INSERT INTO amk_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Todoni fino enemutituai ne karira ninai na enemurorongwai meai we totofa tonanai ninai? Kahofafo nemu kahofa fine, bowayanai we doiwa nemu doi fine kontai. Ampafe bohong eai ete bereri ete, nanafo wiro totofa fanai. Boitarahio inontarai nune amea manei dino totofari ne ne? Wape Allai dino totofari ne!” ");
INSERT INTO amk_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananiasi tarao kaiwofe tonanafo, na tatofang kutu nanai kontaio sau aweu mirehara. Kaiwasa fuba etarami fio Ananiasi sodairi nana fo ematai karira. ");
INSERT INTO amk_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ainanaya bariboaifosa era ma esansangno Ananiasi, mayeai eruaisi to boriai ariei eharia esaraia. ");
INSERT INTO amk_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Tarahio araha ureng botoru teai aha mani, binengfoi da aha mampui. Wape i deitawangno fianai aino arahi ne mangfi sodaira fo kaha. ");
INSERT INTO amk_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Petrusi medu wei deyo, “Boikaririai we yau, doio wamu murawayang kahofa wea fo ne harga fininai beyari e?” Sapirai yoa deyo, “Yo! Ayaranane.” ");
INSERT INTO amk_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ainanaya Petrusi medu wei aha deyo, “Todoni fino wau tuti nemu mangfoi muweanggari Sempaisi Nuaninu Mirarebana fininai? Taramu ma! Bariboaio esarai wamua fesa etaraberasa kawuru ma ne, wau kontai eha wau esarai wau ahang fininai.” ");
INSERT INTO amk_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Tatofang kutu nanai kontaio, Sapirai mireha sau aweu wia na Petrusi arongreafo. Bariboaifosa era mampui ewatioi we mireha wiata fo, ampafe eruaisi ehari to borieia esarai rurang ne mangfoi. ");
INSERT INTO amk_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Ampafe inontarai eroasoa fosa tutu kaiwasa siai etarami fi karira Ananiasi bineng Sapirai usodairai nana fo, ematai karira. ");
INSERT INTO amk_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Rasulifosa enari fitantuma bitoya paria na kaiwasa bitoya foi euremireafo. Inontarai eroasoa fosa, enemirorong boyari efanduhisa na Sempaisi ne Munufoi refong esahuai we Serambi Salomoni fo. ");
INSERT INTO amk_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Kaiwasa siai emataisa paria ampafe wiro era wa efanduhisa ria mano eroasoa fosa ahang kaha. Tonanai ki, wape kaiwasa bitoya foi esahu suasa paria. ");
INSERT INTO amk_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Tuti rahida yiwang rahida inontarai bitoya paria, wiwing tuti mang, eroaso Sempaisi, ampafe ehontai riasa. ");
INSERT INTO amk_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kontai awa kaiwasa eruai inontarai emaninang fosa tutu andaung ete fata ewa naya fo, ehasa to rangfoia, ewa nai. Weo enemitituaitai eteyo, “Ambori Petrusi da na nanaifa mani, nuaninufoi tete inontarai emaninang nanisa, ambori ebeng ki.” ");
INSERT INTO amk_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Kaiwasa siai bitoya kontai era na bendari watai kefang we bendari Yerusalemi fo. Eha inontarai emaninang bitoya tutu mano inggira dohonsa fosa. Tutu inontarai emaninang nanisa, ea kiai rasulifosa enarisa ebeng. ");
INSERT INTO amk_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ainanaya imami fuba foi tuti mano erariati fosa, amani inontarai eweSaduki na katai nani saine, enemirorong pirahai we rasulifosa paria. ");
INSERT INTO amk_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ampafe etemi afai manea we etafu rasulifosa, tuti esoasa to aitamu fuba rorong fo. ");
INSERT INTO amk_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Wape diru nani Sempaisi ne wewai manei fiai rahutu aitamu fo, ainanaya kiasa to borieia, medu wesa deyo, ");
INSERT INTO amk_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Mera wa metoari na Sempaisi ne Munufoi refongfo tuti metaiririai na mai we inontarainesa kariri Allai ne Rang Weworu nei, amani rangno kia arangfo nei.” ");
INSERT INTO amk_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ampafe etohong kariri wewaifoi ne kaiwo arera fo. Kameai kutu era to Sempaisi ne Munufoi refongfoa etoa etaunau nayai. Kameai iari nanai kontai imami fuba foi tuti mano erariati fosa era to katai bei na Sempaisi ne Munufoi tuti esahu mano ewenunggamiei we Yahudi fosa efanduhisa, nana mani ahusa we Majelisi Agama. Mayeai etemi ene afai mamuna manea era wa eha rasulifosa na aitamufoi weo awa etutang berasa. ");
INSERT INTO amk_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Mano era wa fosa esuai tono munu aitamufoi afui, wape wiro ewati sobu rasulifosa kaha. Ampafe etaraberasa aha eteikaririai we Majelisi Agama fosa. ");
INSERT INTO amk_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Emadu eteyo, “Amera wa sobu munu aitamufoi mani, amewati rahutufo kafe na mai, tuti mano ewaitawang wedua mano ewa na aitamu rorong fosa etoari na rahutu borongfo ewaitawanai na mai. Wape rabuang bo amefai rahutufoi afui fo mani, amewati sobu manei ubong neung kutea kahaia.” ");
INSERT INTO amk_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Na kutuo mano wenunggamiei we mano ewaitawang Sempaisi ne Munufoi fosa tuti imami baba fosa etarami kaiwo fenana fo, eserawawera kaiwo emadurai fa tuti enemitituai paria. ");
INSERT INTO amk_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Mayeai tutuba inontarai manei da ma kia kaiwo nina, deyo, “Wawa bohine meaine, metarami ma. Inontarai mano meru aitamuosa nanisa etoa etaunau kaiwasa bitoya foi na Mununei refongfe fo.” ");
INSERT INTO amk_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ampafe mano wenunggamiei we deitawang Sempaisi ne Munufoi fo tuti ne arombawahifosa era wa eha rasulifosa to Majelisi Agama fosa aha. Wape wiro ehasa na tapapa kaha mae eha suasa, weo ematai kaiwasa bitoya foi, dohonao eru kamieio sa fe. ");
INSERT INTO amk_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ehasa afui etohonsa etoa na Majelisi Agama euremireafo. Ainanaya imami fuba foi dutang berasa, deyo, ");
INSERT INTO amk_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Amefafora wedua mea kawurua weo wiro metaunau kaiwasa na inontarai nani wonongfo ahang fanai. Tonanai ki wape metohong kariria kaha! Mene aunauwai metairiri na bendari Yerusalemi sentenang, kontai metoaria metinggai amea weo ameaino ametohona mani inontarai nani mireha ne.” ");
INSERT INTO amk_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Petrusi tuti rasuli wei fosa eroa eteyo, “Todoni kontaio ametohong kariri te fianai aino Allai deyoa fo terai wiro ametohong kariri inontarai manei kaha. ");
INSERT INTO amk_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Yesusi mano memunia mireha sau na aitaba finani, Allai mano tane werengfosa esomi wei foi, duwiria suwi na marareha rorong fi ampa. ");
INSERT INTO amk_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Kontai Allai yuaisi to warang domoya foi tuti dohoni we Mananu tuti Mampariri, ambori inontarai Israeline tata kiai todoni kontaio tatarabera tata weru tane sasarinei tuti Sengnei deiai tane sasarinei. ");
INSERT INTO amk_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ne nanai kiai amewati terai na ameuremireane ampafe ametairiri kaririai, tuti Nuaninu Mirarebanaio Allai dohoni we inontaraio etohong kariri ne Kaiwofo deinawiai we finanai kaiwo tarai fine.” ");
INSERT INTO amk_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Majelisi Agama fe etarami kaiwo fenana fo, erirora awao etang wawerasa beyari we emungno rasulifosa. ");
INSERT INTO amk_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Wape na Majelisi Agama fosa, Farisi manei wonong fino Gamalieli, mantaunau Kaiwo Musai soi fo manei dine, i kaiwasa etatori kontai. Doari ayai, demi rasulifosa era wariei etoa tourai na borieifoa kawuru wo. ");
INSERT INTO amk_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Ainanaya medu we Majelisi Agama fosa deyo, “Nehu inontarai bohi Israeline meaine. Menemitituai sauaraifa weo fianai aino ambori menari we inontarai ninisa ne. ");
INSERT INTO amk_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Weo raminde nanai inontarai manei wonong fino Teudasi, i niariri weinontarai fuba, tuti ne inontaraio erariati fosa tarahio ewepiaura weru (400) tea rai. Wape afai Roma fosa emuni ampafe ne mano erariati fosa era tateraia tuti ne finiarifo wefieai ahang kaha. ");
INSERT INTO amk_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Tourai aha mani, na rabuang bo eha kariri kaiwasa Yudea ewonomi we etato kaririai nani, amani inontarai Galilea manei, wonong fino Yudasi. I kontai deiaya fifianai aino parenta Roma fosa enari fo tuti wedaya kaiwasa bitoya erariati. Wape i emuni kontai tuti ne inontarai erariati fosa ewawu taterai wemansiawaraia. ");
INSERT INTO amk_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ampafe fianai aino rasulifesa enari nina mani, nehu kaiwo aunau fininaifa we mea. Fi enari fo tuti ene aunaufo da na Seng Allai ete na inontarai nunei terai e? Taserawawerahai! Ampafe tatamang tawati kaririai ki. Wiro menari fi karira feai wesa fanai! Metawinsa era wa! Weo fi enari ninai tuti ene aunaune na inontarai nunei mani, finanai nai rai! ");
INSERT INTO amk_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Wape ne nanai da na Seng Allai ma mani mebiriua todoni kontaio fi enari fo nai kaha. Mae tarahio nana mani memamuna weo Allai.” Majelisifosa eroao Gamalieli ne aunaufo. ");
INSERT INTO amk_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Esahu rasulifosa afui, etemi manea siai erarubasa tuti efafora weduasa weo wiro etaunau na Yesusi wonongfo ahang fanai. Mayeai etawinsa era wa. ");
INSERT INTO amk_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Rasulifosa era weru Majelisi Agama fosa wape eparaise paria, weo na Allai urengreafo emai we esodai dadirafo weo eraria Yesusi fefe. ");
INSERT INTO amk_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Wape rahida yiwang rahida, na Sempaisi ne Munufoi refongfo tuti na inontarai ene munufo, etaiririai tuti etaunau Kaiwo Mahikai fo pampang kariri Yesus Kristusi, we i mani Mananu Mampariri dine. ");
INSERT INTO amk_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Rahida yiwang rahida kaiwasa eraria Yesusi fosa bitoya pari aha. Ea mani inontarai Yahudi saine kiai, wape manea emadu te kaiwo ambe, amani kaiwo Yunani, manea emadu na ene kaiwo Iberani fo. Wape mano emadu na kaiwo Yunani fosa enemirorong tiawera we mano emadu kaiwo Iberani fosa eteyo, “Fianang tatohonai fa na rahida neungne weo fiata mano ene pari fi nesa mani, amene wiwinanesa wiro esobu ea kaha.” ");
INSERT INTO amk_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ampafe doni rasuli ewesuraya mandu fosa efanduhi kaiwasa eraria Yesusi fosara ehai, tuti emadu wesa eteyo, “Doroi bohine meaine, fiangne wedaya ameuremiwa weai we ametatorai awa wiro ametairiri nari Allai ne Kaiwone na mai kaha, nana mani beng kaha. ");
INSERT INTO amk_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ampafe metiri doroi eweitu na mea, amani inontaraio mewaitawansa weo Allai Nuaninufoi sensonisa, kontai esawai, ambori ansaino tatemisa we enari finanai, ");
INSERT INTO amk_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","weo amea amene fino, amewenadi tuti ametairiri te Allai ne Kaiwone.” ");
INSERT INTO amk_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Kaiwasafoi kiai eroa na fi rasulifosa eteyoa fo. Ainanaya etirio Stefanusi inontaraio yoaso kanggung Yesusi tuti Nuaninu Mirarebana foi sensoni. Kontai Pilipusi, Perkorusi, Nikanori, Timoni, Permenasi, tuti Nikolasi mano na bendari Antiokia; i mani inontarai Yahudi kaha, wape weagama Yahudi waroi kuteai ampa. ");
INSERT INTO amk_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Eteikariri inontarai eweitu fosa we rasulifosa, ainanaya rasulifosa ewenadi we Sempaisi, tuti ewarami tawansa ambori Sempaisi mioansa we fi enari fo. ");
INSERT INTO amk_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ampafe Seng Allai ne Kaiwone dafai wariai, tuti na bendari Yerusalemi fo kaiwasa bitoya aha eraria Yesusi, tuti imami bitoya kontai eroaso Yesusi. ");
INSERT INTO amk_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stefanusi nani mani, Allai dohong ne bengfo arora wei paria tuti dohong ne mambiriufo wei, ampafe niari fitantuma bitoya paria na kaiwasa bitoya euremireafo. ");
INSERT INTO amk_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Wape inontarai manea emamuna wei. Ea mani mano na munu agama Yahudi bei maneaine, amani esahui we Munu Agama Yahudio Kaiwasa Wewoming Ahang Kaha. Inontarai na munu agama nanisa mani inontarai Yahudi na bendari Kirene tuti Aleksandria, kontai inontarai Yahudi na nu Kilikia tuti Asia. Ea kiai eruhisa we Stefanusi. ");
INSERT INTO amk_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Wape fianai aino Stefanusi medura fo, emadu sobu kaiwofeai ahang kaha, weo Allai Nuaninufoi sensoni dohoni sewai paria. ");
INSERT INTO amk_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ampafe ebai inontarai manea na mamunggasai we epampamu etinggairi eteyo, “Ametaramio Stefanusi nani deibera nabi Musai tuti Allai.” ");
INSERT INTO amk_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Eha weinontarai enemirorongfo, tuti mano ewenunggamiei we Yahudi fosa kontai mantaunau Kaiwo Musai soi fosa. Ainanaya era wa etafu Stefanusi tuti ehari to Majelisi Agama fosa. ");
INSERT INTO amk_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Eha inontarai mano epampamu etinggai Stefanusi fosa kontai. Mano etinggai fosa emadu eteyo, “Inontarai nini wiro fiotou deibera Sempaisi ne Munu Mirarebana nei tuti Seng Allai ne Kaiwo Musai soi fo kaha. ");
INSERT INTO amk_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Weo ametaramioai kawuru ampa weo medu deyo, ‘Yesusi inontarai Nazareti foi ambori sota Sempaisi ne Mununei, tuti yiwang pario tane koangno weriria na Musai ma ne.’ ” ");
INSERT INTO amk_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Majelisi Agama fosa eminohi esaite Stefanusi. Tuti na kutu siari nanai urengfo sambewaraia toyari wewai ureng fenanai. ");
INSERT INTO amk_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ainanaya imami fuba foi dutang Stefanusi deyo, “Kaiwo inontaraifi medura fo wetarai e?” ");
INSERT INTO amk_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stefanusi meduai kaiwo etinggairi wea fo, deyo, “Dai mea tuti doroi meaine, metarami ma. Wiro tane werengno Abrahami da wa ne katai na bendari Harani kaharai mae, na rabuang bo minohi na nu Mesopotamia foi, Allai mano Dedai Sambewara foi da wa medu wei ");
INSERT INTO amk_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","deyo, ‘Ro weru nemu katainei tuti nemu teranesa. Ro to kataio ambori yeinawi we wau foi.’ ");
INSERT INTO amk_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ampafe Abrahami yuai aweng weru nu inontarai Kasdimi foi, deunaung to nu Harani foia. Minohi na nanai awa tamangno mireha, ainanaya Allai demi da weru Harani to katai nini ma, amani katai dino doroi tuti dai mea kiai meminohi nai nini. ");
INSERT INTO amk_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Rabuang bonani wiro Seng Allai dohong kahofafeai fa wei we sahuai fa we fine kaha, kahofa aburung kuteai kontaio wiro dohonai wei kaha. Na rabuang bonani mani Abrahami ne pari arikang, wape Allai dereraia mareha we ambori nu nini dohoni wei ki tuti we ne ririafosa ki. ");
INSERT INTO amk_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Kaiwo ninaifa aino medurai we Abrahami deyo, ");
INSERT INTO amk_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Wape inontarai siai nanisa iru aiboiosa, tuti ambori ika nemu ririafosa to boriei werusa ambori esomi we yau na ninai ki.’ ");
INSERT INTO amk_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ainanaya dohong Kaiwo Arera kariri sunatifo we Abrahami tuti medu wei deyo, ‘Mewesunati mene arikang mang wausa kiai. Menari tonana mani metainawiai we yau weo mea mani nehu inontarai di mea, tuti metohong kariri nehu Kaiwone.’ Ampafe rahida bo Isaki saubaununggamiei foi awa ne rahida indeatoru fo tamang Abrahami wesunati kaririai. Mayeai Isaki kontai wesunati ne kaisungno Yakupi. Tuti Yakupi kontai wesunati ne kaisung ewesuraya mandu fosa, amani ansaino ewewereng we Yahudife tata ninai. ");
INSERT INTO amk_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Na rabuang bonani tane wereng nanisa enemirorong pirahai we Yusupi, ampafe etawayania wewoming na nu Mesiri foi. Wape Allai weririati ");
INSERT INTO amk_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","donio kiaharai weru dadira fuba sodairi foi, tuti Allai dohong awai wei tuti dohoni biriu paria na rabuang bo da wa doari na Firauni Mesiri foi arongreafo. Ampafe Firauni dohong ne bengfo arora wei donio yoasoi tuti yuaisi we gubernuri we nu Mesiri foi tuti wenunggamiei we ne istanafoi. ");
INSERT INTO amk_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Mayeai kahari fiebai bei ming na nu Mesiri foi tuti na nu Kanani nei, ampafe kaiwasafoi kiai esobu dadira paria. Tane werengfosa kontai kahari minsa. ");
INSERT INTO amk_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ampafe rahida bo Yakupi taraoai we na Mesiri mani etawayang patibu naya fo, demi ne arikangno ewewereng we tata fosa era wa, amani era wereantenang pari finanai. ");
INSERT INTO amk_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Rabuang bo era weberu fo arahio Yusupi deikaririai wesa weo i mani ene tahatuifi dine tuti rahida bonani kontai Firauni Mesiri foi deitawang kariri Yusupi ne terafosa. ");
INSERT INTO amk_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Mayeai Yusupi denatu kaiwo we tamangno Yakupi we da tuti ne arikangfosa, amani Yusupi ne terafosa we era to Mesiri ma. Ea kiai efau fo ewepiatorua sura suraya ring (75). ");
INSERT INTO amk_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Ampafe Yakupi yuai aweng to Mesiri tuti niai na wanai paria i tuti tane werengfosa emarareha nayai. ");
INSERT INTO amk_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ene ririafosa eha ene neinafo to bendari Sikemi aha ma, tuti esarayai na fafo Abrahami fafongfa biaiti na doi katui kahai ria Hemori ne arikang rabuang foi na bendari Sikemi. ");
INSERT INTO amk_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Rabuang eai aha, amani rerai we Allai dohong kariri ne kaiwo dererai we Abrahami fo, tane werengfosa etawing separai bitoya pampang aha na nu Mesiri foi. ");
INSERT INTO amk_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Mayeaia mani Firauni siaio deroanso Yusupi kaha manei yu na nu Mesiri foi aha. ");
INSERT INTO amk_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Firauni weworu nani mei kanggani tanengfosa tuti tiapasa. Dawisa ehabi ene arikang marareha arahio etaubau enumi fosa we ewa funomaia emarareha. ");
INSERT INTO amk_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Rabuang bonani dino Musai saubaunungne, ne wawafo suru uwatioi we denteng paria, ampafe uradiwari embai botoru na une munu rorongfo. ");
INSERT INTO amk_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ainanaya rahida bo ukabioi foi Firauni antuwingfoi sobui ampafe kiari dehumi we ne arikang terai. ");
INSERT INTO amk_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ampafe Musai sobu aunau bitoya paria kariri aunau Mesiri foi, donio i wemambiriu paria na medufo tuti yufifo. ");
INSERT INTO amk_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Rabuang bo Musai ne defuina piaru fo, enerorongfoi tibau mandiei we da wa deti ne doroi inontarai Israeli fosa kariri eminohi toa fo. ");
INSERT INTO amk_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ainanaya deti nengfo manei we inontarai Mesiri fo manei niari kanggani kareri, ampafe doa rufang inontarai Mesiri foia miuni paria mirehara. ");
INSERT INTO amk_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Niari tonanafo deitarahio ambori nengfosa etaroang kaririai we Allai yuaisi we fiatasa kiasa weru ne karirafo. Manamo etaroang kariria kaha. ");
INSERT INTO amk_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Kameaia mani da aha deti inontarai Israeli mandu umung suru aha, ainanaya yurai we kia ruhi suru aha, deunau suru deyo, ‘Doroi murui ne. Muru mani aisei di muru kaha, ampafe wiro mumung muru fanai!’ ");
INSERT INTO amk_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Wape mano bioi ne doroi foi suang saya Musai to boriei, mae medu wei deyo, ‘Mandoni dino yuai wau we mananu tuti wemangkutu kaiwo we amea ne? ");
INSERT INTO amk_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Tarahio nari we boyo mung yau kariri ramindenafa mung inontarai Mesiri foi e?’ ");
INSERT INTO amk_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Na kutu Musai tarao fianai aino nengfi medurai wei nana fo mitai paria, ampafe wewu weru Mesiri, awa minohi waroi na nu Midiani. Na wanai rirau sobu ne kaisung mandu. ");
INSERT INTO amk_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Defuina piaru da aha ma, mayeai Sempaisi ne wewai manei da wei ma na katai wekamamiei wowong fo kefang we uai Sinai. Wewaifoi da ma na ai denggararu foi rorongfoi. ");
INSERT INTO amk_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Musai pepuhung paria we fi detioai nanai ampafe da kefanai we detioi na mai, ainanaya tarao Sengnei raofuifoi medu wei deyo, ");
INSERT INTO amk_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Yau mani mene werengfosa ene Sengfi di yau, amani mene werengno Abrahami, Isaki tuti Yakupi itone Sengfoi.’ Ampafe Musai mitai karira, paria wiro fioai ureng deti we kataifoi ahang kaha. ");
INSERT INTO amk_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Mayeai Sengnei medu wei aha deyo, ‘Fatingno sandari tatara wa, weo kahofa boa nayai nanai, kahofa mararebana fine. ");
INSERT INTO amk_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Iwatioai tuti urehu nayai kawuru na nehu inontaraifosa ene dadira rorong fo paria na nu Mesiri foi ampa. Tarahuo erawamifui esai foi tuti ene dadirafe nanai kawuru ampa, tuti ibiari meu we itawinsa weru ene dadirafo. Ampafe ro ma, yau ambori yemi wau we barabera wau to Mesiri aha we fatasa.’ ");
INSERT INTO amk_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Yo, Musai nini mani, Musaio Israelifosa eteiayari na kaiwo emadurai eteyo, ‘Mandoni dino yuai wau we mananu tuti we mangkutu kaiwo we amea ne?’ Tonanai wape andino Allai mantauni demi we wenunggamiei tuti wemampariri wesa, amani na rahida bo Allai demi ne wewaifoi darioi na ai denggararu foi rorongfo. ");
INSERT INTO amk_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Musai nani kia inontarai Israeli fosa to boriei weru nu Mesiri foi na fitantuma fuba niariri foi na wanai, kontai na Rawanang Berika foi tuti na katai wekamamiei wowong fo paria defuina piaru fo. ");
INSERT INTO amk_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","I kontai Musai mano medu we Israelifosa deyo, ‘Allai ambori diri Nabi manei rahang mea na mene ririanei we mea ma, ne tarai kariri diri yau fo.’ ");
INSERT INTO amk_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Musai dino wiwiaing kaiwasa Israeli fosa, amani tane werengfosa, na katai wekamamiei wowong fo, kontai wewaifoi da ma medu riati na uai Sinai nuwowongfo. Tuti andino sobu Kaiwo Kia Mai we tata fo ria Allai, we medurai we tata ne. ");
INSERT INTO amk_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Tonanai ki wape tane werengfosa emaya we etaramioi kaha, mae eteiayari tuti enemirorongfoi dohong we etaraberasa to Mesiri aha. ");
INSERT INTO amk_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Emadu we Haruni eteyo, ‘Nari aririwang manea we amesomi wesa we amene seng, ambori seng nani saino ewiwiang amea. Weo Musai nini wenunggamiei we amea kia amea na Mesiri ma, wape ninaifa amewaitawana kahai we fianai aino sodaira fo.’ ");
INSERT INTO amk_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ainanaya na siari nanai enari aririwangno sapi ne arikang manei, mayeai emung fiahung we etohonsa we korbani we aririwangfoi tuti etohong muniara we efiai mantaunsa fi enari nanai. ");
INSERT INTO amk_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ampafe Allai sawing warang werusa tuti suasa esomi we awaha na rorafaisi. Nanai kariri fianai aino mayeai mani nabifosa esoi ahang fo, amani dotu toninai: ");
INSERT INTO amk_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Enehutituai menari fieai we yau kaha, mae ne tarai karirio meriria munu seng Moloki tuti aririwang awaha Refani na mene rang rorong fo. Adareti toyari uru mani aririwang menari suru we seng we mesomi we suru. Ampafe, ambori iso mea waroi to inontarai eharira na nu Babeli foi we etaha tawang mea nai.’” ");
INSERT INTO amk_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Stefanusi medu pampang, medu kariri Sempaisi ne Munufoi, deyo, “Fafongfa, rabuang bo tane werengfosa enai na katai wekamamiei wowong fo mani, Allai demi Musai niari munu bei wei ambori esomi wei nai. Munu bonani mani era todoni kontaio eriati. Munufoi deinawiai weo Allai niayai rahangsa finanai. Enariri kariri fianai aino Allai deinawiai we Musaia fo. ");
INSERT INTO amk_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Tuti munu nani tane werengfosa eriati pampang, paria rabuang bo Yosuai kiasa eha katai taneni nini weru kaiwasa siai fosa ene mambiriufo, amani Allai data kaiwasa nanisa na tane werengfosa earomireafo. Munu nani wiatai na nanai paria rabuang bo Dauti yu mananu fo. ");
INSERT INTO amk_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Allai, mano Yakupi somi wei foi, deinawi ne bengfo arora we Dauti, ampafe Dauti dutani we biaung munu bei wei. ");
INSERT INTO amk_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Wape Allai ne Munufoi Mananu Salomoi andino biauni ne. ");
INSERT INTO amk_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Tonanai, wape Allai mano Dedai Sewa foi wiro minohi na munu inontaraine tanariri nei kaha, weo nabi manei soi kaririai deyo, ");
INSERT INTO amk_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Rorafaisi mani katai iminohi naya finanai tuti nunei mani katai we awehu doa naya fine. Munu fianang dino meteyo menariri we yaune tuti katai todoni dino ambori iminohi ukai nai ne? ");
INSERT INTO amk_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Yeitarahio na mantaung yau warahune, inari fianggeng fuba nini kiai ne mae?’” ");
INSERT INTO amk_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Medu aha deyo, “Mea mene tarai kariri inontarai siaio ene pari seng fosa. Menumikamiei mitubaru tuti mehobu metarami we Allai ne Kaiwone. Mea mene tarai kariri mene werengfosa, metapa Allai Nuaninu Mirarebana nei pampang. ");
INSERT INTO amk_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Na nabi rabuang fosa mandoni dino wiro mene werengfosa enari kanggani kaha ne? Kontai etoari aha emung inontarai mano fafongfa Allai demisa we emadu kariri Mano Mirarebana foi we da ma fo ne. Tuti na ninaifa inontarai nani da we mea ma, wape metawayani to mano eharira fosa, tuti memuni. ");
INSERT INTO amk_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Mesobu Allai ne Kaiwo Musai sobuai ria wewaifosa fo kawuru ampa, wape wiro metohong kariria kaha.” ");
INSERT INTO amk_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Majelisi Agama fosa etaramio kaiwoariri fuba meduri foi nanafo, ehasoua ehika ederemi wei. ");
INSERT INTO amk_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Wape Stefanusi mano Allai Nuaninu Mirarebana foi sensoni foi, deti we rorafaisi. Deti Allai ne sambewaraio dadai fo tuti Yesusi doa na Seng Allai warang domoya fo. ");
INSERT INTO amk_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Stefanusi medu deyo, “Mewati, iwati rorafaisi tifai tuti Kaisung Inontarai nei doari na Seng Allai warang domoya fo!” ");
INSERT INTO amk_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Majelisi Agama fosa ebibe ehobu wedua kaiwo medura fo tuti ehobu etarami weai. Na kutu nanai kontai eruhisa emamuna wei. ");
INSERT INTO amk_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Efafari to boriei weru bendarifoi, mayeai eru kamiei oi. Inontarai mano antao epampamu etinggairi nanisa etisu ene ansung boriei fo, etohonaia wa ria bariboai manei wonong fino Saulusi, ambori ene taraifo kesau we eru kamiei oi. ");
INSERT INTO amk_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Na siari eru kamiei oi nana fo, dutanai deyo, “Seng Yesuse, ka nuhuaninunei mau.” ");
INSERT INTO amk_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ainanaya sau aweu disang kapa awebuka, sahu mambiriu deyo, “Sengne waune, sasari enariri nini, dohonao bohoni sau wesa fe!” Medu kaiwofoao kai tonanafo i kiaharaia. ");
INSERT INTO amk_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Tuti Saulusi doa kontai na nanai, yoa we Stefanusi we emunifo. Rahida kutu siari nani kontaio enari kanggani inontarai eroasoai enai na Yerusalemi fosa finanaya, ampafe ewawu taterai we mansiawaraia, manea esinsung nu Yudea foi tuti manea na nu Samaria foi, mae rasulifo saino bireri ne. ");
INSERT INTO amk_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Mae Stefanusi nani mani, inontaraio ematai Allai manea, esaia etaidu wei tuti eharia esarai. ");
INSERT INTO amk_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Wape Saulusifo yurai we niari kanggani inontarai eroasoa fosa pampang ambori wedayasa eraria Yesusi ahang kaha. I suai mai munu bong we sera we inontarai eroasoa fosa, wiwing tuti mang, we tefusa, fiafasa to munu aitamu foi. ");
INSERT INTO amk_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Na doni kontaio inontaraio eroasoaio ewawu taterai nanisa era wariai etairiri Kaiwoariri Mahikai fo. ");
INSERT INTO amk_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Pilipusi biari to bendari na nu Samaria foi tuti deiririai we inontarai nanisa kariri todoni Yesusi mani Mananu Mampariri dine. ");
INSERT INTO amk_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Kaiwasao etarami Pilipusi ne kaiwofo tuti ewati fitantuma niari fo, bitoya na ea enemirorong sau we kaiwo medura fo, ");
INSERT INTO amk_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","weo inontarai bitoya inggira dohonsa fosa, inggirafo ebibe mantaung tuti era to boriei werusa. Inontaraio efaya tuti esoberaha fosa kontai efau paria niarisa ebeng. ");
INSERT INTO amk_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ampafe kaiwasa na bendari nani fosa efaraise paria. ");
INSERT INTO amk_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Na bendari nani kontai inontarai wesulapi manei, wonong fino Simoni. Waroi ampa ne sulapi niari fo wedaya kaiwasa bitoya na nu Samaria foi epapuhung wei. I bioi arong deyo wiro inontarai funoma dine kaha. ");
INSERT INTO amk_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Ampafe kaiwasa fubao na bendarifoi, inontarai fuba tuti inontarai katui, etau we ne kaiwofo tuti etaparandini eteyo, “Inontarai nini mani Allai ne mambiriufi dine, wewonong weo Mambiriu Fuba.” ");
INSERT INTO amk_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Waroi paria ne sulapifo wedaya kaiwasa bitoya foi epapuhung, donio erariati. ");
INSERT INTO amk_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Wape Pilipusi deiriri Kaiwo Mahikai fo wesa kariri todoni Allai weMananufo tuti kariri Yesus Kristusi Mampariri foi, donio eroasoai, ainanaya webaptisisa, wiwing tuti mang. ");
INSERT INTO amk_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simoni mantauni kontai yoasoai tuti Pilipusi webaptisi. Na rahida bonani, da riati pampang. Fitantuma fubao Pilipusi niari fo dohoni pepuhung paria. ");
INSERT INTO amk_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Na kutuo rasulifosa na Yerusalemi etaramioaifa weo inontarai Samaria fosa eroaso Sempaisi ne Kaiwofe kawurua fo etemi Petrusi tuti Yohanesi ura wesara. ");
INSERT INTO amk_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Na kutu siario usobusa fo, uwenadi wesa ambori Nuaninu Mirarebana foi sensonisa, ");
INSERT INTO amk_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","weo ea kiai mansiari kontaio wiro sobu Nuaninu Mirarebana foi kaharai, ea arahio Pilipusi webaptisisa terai na Yesus Kristusi wonongfo. ");
INSERT INTO amk_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ainanaya Petrusi tuti Yohanesi uruai uwaramifo awa wasau ea, donio esobu Nuaninu Mirarebana foi anina. ");
INSERT INTO amk_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simoni deti kahairaifa weo rasulifosuru uruai uwaramifoa wasau inontaraifosa, amani Nuaninu Mirarebana foi sensonisa. Ampafe donio de dohong doi we suru, ");
INSERT INTO amk_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","deyo, “Murohong mambiriu nanai weai we yau kontai ambori iruai warahua wasau manei mani, wenani sobu Nuaninu Mirarebana foi kontai.” ");
INSERT INTO amk_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Manamo Petrusi yoa wei deyo, “Wau tuti nemu doiwa woru weruai! Weo boitarahio Allai fi dohona fo mani wori na doi e? ");
INSERT INTO amk_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Enemurorongwai mei we Allai kaha, ampafe nemu hakifeai we wiro kontai amea na fi ameru ne kaha. ");
INSERT INTO amk_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ampafe barabera wau, tawing pario nemu karira enemutituaitawa, tuti butangno Sempaisi ambori tarahai waraira numukamiei kerira nani. ");
INSERT INTO amk_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Weo iwaitawanai we wau enemukadatai pampang tuti wau wewoming we sasari.” ");
INSERT INTO amk_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ainanaya Simoni medu we suru deyo, “Mufata yau muwenadi we Sempaisi ambori fi mumadurai nanai kiai wiro isodai sobu kutea fanai.” ");
INSERT INTO amk_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Petrusi tuti Yohanesi umadu kariri Yesusi tuti urairiri kariri Sempaisi ne Kaiwofoa, ainanaya urarabera suru to Yerusalemi aha. Tuti na rang rorong fo urairiri kariri Kaiwo Mahikai fo na munue bitoya na nu Samaria. ");
INSERT INTO amk_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Sempaisi ne wewai manei medu we Pilipusi deyo, “Pilipuse, ro! Ro to do wanansai to rangno bia na Yerusalemi tono Gasa foi.” (Rangfoi wewui wekamamiei wowong sirahiai.) ");
INSERT INTO amk_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Ampafe Pilipusifo da wa. Na wana sobu pegawai fuba manei na nu Etiopia, i na rang rorong wa daraberahi to ne kataifoi aha. Inontarai nani andi yufi we Kandake mananu wiwing na Etiopia foi, wenunggamiei we ne rafoi ne. Inontarai nani defai to Yerusalemia we somi we Allai ");
INSERT INTO amk_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","tuti arahi daraberahi aha. I minohi na ne oto kuda umito riwui rorongwa defai fantamai mae deto buku nabi Yesayai. ");
INSERT INTO amk_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Allai Nuaninufoi medu we Pilipusi deyo, “Ro we otofoia, ro riati.” ");
INSERT INTO amk_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Ainanaya Pilipusi da kefang otofoia, amani tarao inontaraifoi deto buku nabi Yesayai. Pilipusi dutang berahi deyo, “Daie! Fi botorai nanai boitawanaia?” ");
INSERT INTO amk_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Inontaraifoi yoa wei aha deyo, “Yeitawanai todoni, manei deikaririai we yau fino?” Ampafe dutani dau to oto rorong fo ayai minohi riati. ");
INSERT INTO amk_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Sempaisi ne Kaiwo rabuangno pegawaifoi detora fo ainina: “I ne tarai toyario dombao etafuri, erabitia we emuni, ne tarai toyario domba ne arikangno ehutu nuawurufo mani bibe kaha, tonanai i wetamui beyari. ");
INSERT INTO amk_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","I emei kanggani tuti wiro manei niariri na mai kaha. Ne ansengfoi efatini weru nunei, ampafe wiro ne ririafei aha weo manei kontaio deiriri kariri kaha.” ");
INSERT INTO amk_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Pegawaifoi dutani deyo, “Boikaririai we yau, mandoni dino nabifi medu kariri ninai? Medu kariri mantauni ete manei siai e?” ");
INSERT INTO amk_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ampafe Pilipusifo fioai borong medu, i kia kaiwo aririo pegawaifoi fidetorafo we kaiwo reantenang we deiriri Kaiwo Mahikai kariri Yesusi fo wei. ");
INSERT INTO amk_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Urafaia sobu kuru bei na rang rabuang, pegawaifoi medu wei deyo, “Botia mereha di wani! Fianai aino masi kahai we webaptisi yau ne?”  ");
INSERT INTO amk_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Pilipusi yoa deyo, “Roaso Yesusi tarai na enemurorongwai mani, iwebaptisi wau.” Pegawaifoi deyo, “Iroasoai tarai we Yesus Kristusi mani Allai ne Kaisung dine.” ");
INSERT INTO amk_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ainanaya demi mano kia ne otofoi weo fiotouri, ubiari to kurufoi aweu, ainanaya webaptisia. ");
INSERT INTO amk_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Na kutuo urau weru merehafoi fo, Allai Nuaninufoi kia Pilipusi na tatofang kutu nanai weru kataifoi, ampafe pegawaifoi wiro detioi ahang kaha, mae i defai to ne kataifoi na enerorong mirising paria. ");
INSERT INTO amk_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Tatofang tonanai mae Pilipusi niai na bendari Asdotia, tuti ne rang rorong daoa fo deiriri Kaiwo Mahikai kariri Yesusi na bendari fubao da maia fo paria sobu bendari Kaisarea rausi. ");
INSERT INTO amk_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Na rabuang bonani Saulusi dei kahera inontarai eraria Seng Yesusi fosa, meduraifa deyo minsa. I da we imami fuba foi ");
INSERT INTO amk_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","we dutani niari surati yoasoi bei, we da to mano ewenunggamiei we munu agama Yahudi watai na bendari Damsiki fosa, ambori sobu inontarai era na Rang Yesusi fe manea na nana mani, wiwing ete mang, tefusa tuti kiasa to Yerusalemi. ");
INSERT INTO amk_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Na ne rang rorong da to Damsikifo, da wa rerai we bendarifoi, tatofang kutu nanai sambewara bei na rorafaisi meu tibohawai wariri. ");
INSERT INTO amk_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","I sau aweu wiatai na kahofa nuwowongfo, ainanaya tarao manei rawafuifea medu wei deyo, “Sauluse, Saulusi wo! We fiani e nari kanggani yau ninai?” ");
INSERT INTO amk_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saulusi yoa aha deyo, “Sengne waune, mandoni di wau?” Rawafuifoi medu wei aha deyo, “Yau Yesusi mano nari kanggani fi di yau. ");
INSERT INTO amk_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Wape nina mani boabari wau roa wuaio bendarifoi. Na wanai ambori wobu kaiwoariri kariri fianai aino ambori nari ne.” ");
INSERT INTO amk_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Inontarai era ria Saulusi fosa esoisa, epapuhung paria wiro emadu obu kaiwofeai ahang kaha, weo etaramio rawafuifoi wape wiro ewati sobu manei kahaia. ");
INSERT INTO amk_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ainanaya doabariri tuti fiobau urengfo we deti, manamo urengfafara wiro deti fieai ahang kaha. Ampafe eru na warangfo tuti ebinti esuai to Damsiki. ");
INSERT INTO amk_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Rahida botoru wiro deti kaha, tuti dampi kaha, kontaio mereha arora ne dunung sobu kutea kahaia. ");
INSERT INTO amk_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Na Damsiki inontarai manei wonong fino Ananiasi, i inontarai daria Yesusi dine. Detio Seng Yesusi medu wei deyo, “Ananiase!” Ananiasi yoa wei deyo, “Sengne waune, yau ninai.” ");
INSERT INTO amk_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Sempaisi medu wei deyo, “Boabari wau, ro to rangno wonong fino Rang Mimoya, to Yudasi ne munufoi. Butanaifa na nanai we inontarai Tarsusi manei wonong fino Saulusi, we i wenadi we yaufo, ");
INSERT INTO amk_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","tuti na ne nadi rorong fo deti mang manei wonong fino Ananiasi, da weia tuti yuai warangfo wa sauwi ambori deti aha.” ");
INSERT INTO amk_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Manamo Ananiasi yoa wei aha deyo, “Sengne waune, tarahuo kaiwoariri bitoya kariri inontarai nani tuti ne niari fo, toyari niari kangganio nemu inontarai emararebanai na Yerusalemi fosa. ");
INSERT INTO amk_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Tuti andi nina mani kia surati bei ria imami baba fosa, da kawuru ma weo tefu inontarai ameroaso wau ne amea kiai.” ");
INSERT INTO amk_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Manamo Sempaisi medu wei aha deyo, “Tonanai ki, wape roa, weo inontarai nani mani yiriri kawuru ampa weo wewoming we yau, ambori deiriri wonohunei we kaiwasa siaio wiro Yahudi kaha fosa, tuti weo ene mananufosa, kontai weo inontarai Israeli nesa. ");
INSERT INTO amk_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Tuti yau ambori yeinawiai wei kariri ne maraba ambori sodaira fo weo deiriri wonohunei fefe.” ");
INSERT INTO amk_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Donio Ananiasifo da to munufoia da wafui. Yuai warangfo sau Saulusi medu wei deyo, “Sauluse, nehu doroi bohine waune. Seng Yesusi, mano botioi na rang rabuang na rahida bo ro nai ma nani, andi demi yau ira we wau ma nina, ambori boti aha, tuti Nuaninu Mirarebana foi sensoni wau.” ");
INSERT INTO amk_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Na tatofang kutu nanai kontaio fi niai kobu na urengfo, ne tarai toyario diang neuna fenanai, tifasa weru urengfo ampefe deti na mai aha. Ainanaya doa bariri, mayeai Ananiasi webaptisi. ");
INSERT INTO amk_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Tuti dampi aha ampafe ne taraifoi mitubaru aha. Saulusi niai na Damsiki rahida beiru teai aha ria mano eraria Yesusi fosa. ");
INSERT INTO amk_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ifo da finanaya to munu agama Yahudi fo tuti deiririaifa na nanai we Yesusi mani Allai ne Kaisung dine. ");
INSERT INTO amk_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Kaiwasa na nana fosa ehiri ewarami paria weo etaramioi medu tonana fo. Eteyo, “Waitarahio inontarai nini faini dino mingno inontarai eraria Yesusi fesa na Yerusalemifo mae? Kontai da to ninaifa ma ne mani, da wea fino tefu inontarai eroasoai na nina nesa weo kiasa to imami baba fosa mae?” ");
INSERT INTO amk_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Wape rahida yiwang rahida Saulusi kaiwo medura fo wemambiriu pari aha. Kaiwoariri medura fo deinawiai weo Yesusi tarai Mananu Mampariri dine, paria Yahudi enai na Damsiki fosa etaperemi tinang we beyari we kaiwofo. ");
INSERT INTO amk_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Rahida bitoya da wa, amani inontarai Yahudi fosa ehasou Saulusi we yoaso Yesusi fefe, ampafe eteiruhi kaiwo weo emuni. ");
INSERT INTO amk_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Ampafe diru rahida etamang wedua rahutu bendari borong fo. Manamo ene enarifo taraoaifa ampafe deitawanaia. ");
INSERT INTO amk_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ampafe diru bei Saulusi ne inontarai erariati fosa ehari, etuki na fino nawang bei, etuki roaino wore kamiei eruti wedua bendarifoi nai foi aweu. ");
INSERT INTO amk_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Saulusi da to Yerusalemia, i niari we kiontaio Yesusi ne inontarai erariati fosa, manamo ea kiai emataiti weo eroaso tururi kahai, weo dohonao i mani inontaraio daria Yesusi tarai dine kaha fe. ");
INSERT INTO amk_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Wape Barnabasi yoasoi ampafe kiari ura we rasulifosara, tuti deiririai wesa kariri todoni Saulusi deti Sempaisi na rang rabuang fo, tuti kariri medu wei fo. Deikaririai kontai kariri todoni Saulusi mitai kaha deiriri Yesusi wonongfo na Damsikifo. ");
INSERT INTO amk_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Donio Saulusi niayai riasa tuti kiorang Sempaisi wonongfo na mitai kahai wari bendari Yerusalemi tantenang. ");
INSERT INTO amk_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Kontai medu ria inontarai Yahudi mano emadu na kaiwo Yunani fosa kariri Yesusi awa esawasa, wape ea erurai we emuni. ");
INSERT INTO amk_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Doroio eroasoa fosa etaramioai we Yahudifosa ete emuni ampafe ewawuri to bendari Kaisarea arau, mayeai etanatui pari to bendari Tarsusi. ");
INSERT INTO amk_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ampafe donio jemati na nu Yudea foi sentenang, nu Galilea foi tuti Samaria foi eminohifo ematai Sempaisi tuti eminohi na mai, manea enari kangganisa ahang kaha. Allai Nuaninu Mirarebana foi fiatasa dohong enemirorongfoi fiabai, ampafe ewemambiriu aha, kontai efau aha. ");
INSERT INTO amk_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petrusi da wariai suambawa mano eroasoa fosa na kataifoi sentenang. Na rahida bei i suambawao Sempaisi ne inontarai emararebana fosa na bendari Lida foi. ");
INSERT INTO amk_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Na wanai sobu inontarai mang manei wonong fino Eneasi, inontarai nani fiaya defuna indeatorua finanai. I wia terai na ne fatafoi. ");
INSERT INTO amk_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Medu wei deyo, “Enease, Yesus Kristusi waraira maninangwai weru wau. Boabari wau tuti funtang fatao wa nai wai.” Na kutu nanai kontai Eneasi doabariri. ");
INSERT INTO amk_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Kaiwasa fuba eminohi na Lida tuti Saron fosa ewati Eneasi we dentengfo ampafe ea kiai eroaso Sempaisi. ");
INSERT INTO amk_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Na bendari Yope wiwing manei wonong fino Tabitai (wonong na kaiwo Yunani mani Dorkasi, neta we rusa). I mani inontarai daria Yesusi, tuti niari fi beng bitoya pampang tuti fiata inontarai ene pari fi fosa. ");
INSERT INTO amk_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Na rabuang bonani fai i meninang pariao mireha. Ainanaya wiwing mireha nani etohoni deriaia, eruaisi ao wiatai na rorong bo yai foi. ");
INSERT INTO amk_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Yope wiro waroi tururai weru Lida kaha, donio Yesusi ne inontarai erariati fosa na Yope etaramio Petrusi niai na Lida, ampafe etemi uwemandu ura weia, urutani ureyo, “Wukahera ro we amea ma.” ");
INSERT INTO amk_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ampafe Petrusi doabariri da ria suru. Itora wa sobu kataifoi ainanaya eha Petrusi to rorong bo yai foi. Wiwina na nana fosa kiai etoa wariri mae esai etainawi ansung dawa wesa fo wei. ");
INSERT INTO amk_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Petrusi demisa era wa ehai to boriei, ainanaya disang kapa awebuka tuti wenadi. Mayeai daraberahi arong we wiwing mireha foi tuti medu wei deyo, “Tabitae, boabari wau!” Ainanaya ureng tabau detia Petrusifo doabariri beyaria minohi. ");
INSERT INTO amk_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ainanaya Petrusi yu na warangfo tuti fiataria doa, mayeai sahu mano eroasoai tuti wiwina fosa, ainanaya dohong mano suwi na marareha rorong foi wesa aha. ");
INSERT INTO amk_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Kaiwoariri kariri fitantuma nanai dafai wari bendari Yope tantenang, ampafe inontarai bitoya eroaso Yesusi. ");
INSERT INTO amk_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Petrusi niai na nanai we rahida beiru teai ria inontarai manei wonong fino Simoni, i mani inontarai niari andowa rerawa we fisiai aha. ");
INSERT INTO amk_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Na Kaisarea inontarai Roma manei wonong fino Korneliusi. I mani afai mamuna dine, ne pangkatio kapteni. I tuti ne raifosa afai mamuna Italia disa. ");
INSERT INTO amk_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","I tuti ne munu rorong fosa kiai ematai Allai tuti esomi wei, kontai fiata inontarai Yahudi mano ene pari fi fosa bitoya paria, tuti wenadi pampang we Allai. ");
INSERT INTO amk_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Na rahida bei wofoi tiwerawa tarahio araha ureng botoru teai, detioai terai na urengfo weo Allai ne wewai manei da ma tuti dutani deyo, “Korneliuse!” ");
INSERT INTO amk_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Korneliusi seite wewaifoi mitai paria, mae medu wei deyo, “Daie, tofino?” Wewaifoi medu wei deyo, “Allai tarao nemu nadiwa ampa tuti detio enemurorong denteng we kaiwasa wai. Finari tonanane ne tarai we korbani we Allai, ampafe piraise we wau. ");
INSERT INTO amk_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ampafe na kutu iari ninai kontaio bemi inontarai maneitoru itora to Yope we itosahu Simoni we da ma, i wonong siai feai aino Petrusi. ");
INSERT INTO amk_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Minohi ria inontarai manei wonong fino Simoni, mano niari andowa rerawa we fi siai ahang foi na ne munufoi. Ne munufoi wiana wenafareng fine.” ");
INSERT INTO amk_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Na kutu siario wewaifoi da werui nanai, sahu ne mangfata na munufoi uwemandu tuti afai mamunao somi we Allai manei, amani mano weririati pampang foi. ");
INSERT INTO amk_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Deiriri kariri fianai aino detioa foa kai we itoru, ainanaya demi itoru itora to Yopea. ");
INSERT INTO amk_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Kameai weroa naia mani, rahida rabuang teaia, mano itorafo itoru itora wa rerai we munue Yope tonanai, Petrusi dau to munu minohi nai foi nuwowongfo ayai we wenadi. ");
INSERT INTO amk_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ainanaya wewisi paria tuti deo dampi. Ampafe fiangfo emainenamai tonanai mae, mayeai mani detio fiainawiaifeai ria Sempaisi. ");
INSERT INTO amk_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Detio rorafaisi tifai tuti detio fi ne tarai toyario ireu fiebai tirera Allai suki to nunei meu, sawai na warabuka boa fo. ");
INSERT INTO amk_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Na ireu rorong fo andowa Yahudifosa ene wori wea fo, na rabuang botoru, amani andowao eawemi boa, kontai ne efafa na earomi fo, tuti romufosa. ");
INSERT INTO amk_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ainanaya tarao manei raofuifeai medu wei deyo, “Petruse, boa! Muni ambori bani!” ");
INSERT INTO amk_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Petrusi yoa deyo, “Sengne waune, nana fanai! Weo fiang amene wori weai ninai, yang eai na wea kaha rai, weo fimai kaha fine fefe.” ");
INSERT INTO amk_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Manamo Sengnei medu wei aha deyo, “Fianai aino inaria mararebanaifa tuti mai we metang fo mani, wiro mesahuai we fimai kaha fine fanai.” ");
INSERT INTO amk_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Fi detioai nani Allai medu wei webetoru, mayeai ireufoi dau to rorafaisi aha. ");
INSERT INTO amk_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Petrusi weraia kerira, enetituai paria weo fi detioi foi. Masi minohi enetituai weai tonanai mae, mano Korneliusi demi sitoru itoroari kawuru na wore rahutu borong foa. ");
INSERT INTO amk_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ainanaya itosahu inontarai manei ma itorutang berahi itoreyo, “Inontarai mano wonongno Simon Petrusi nei minohi na nina e?” ");
INSERT INTO amk_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Petrusi masi minohi enetituai we fi detioa fo tonanai mae, Allai Nuaninufoi medu wei deyo, “Petruse, inontarai mantoru itora ma itosera we wau fo. ");
INSERT INTO amk_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ampafe wukera bia tuti dohonao enemuwawera weo ro ria itoru wa fe, weo yauno yemi itoru wa.” ");
INSERT INTO amk_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Donio Petrusi biari aweu tuti medu we itoru deyo, “Yauno muntosera we yau ne. Muntosera we yau we fiani?” ");
INSERT INTO amk_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Itoroa wei itoreyo, “Kapteno Korneliusi andi demi antoru antora ma ne. I inontarai enerorong mesi dine tuti mitai Allai, kontai inontarai Yahudi nesa kiai etatori paria. Allai ne wewai mirarebana manei da wa medu wei, weo demi we wau ma weo ro wei to ne munufoia ambori tarao fianai aino modurai wei fo.” ");
INSERT INTO amk_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ampafe Petrusi dutang sitoru itorena riati diru bonani na nanai. Kameaia Petrusi doari meai tuti da ria itoru. Doroi eroasoai na Yope fea kontai era riatai. ");
INSERT INTO amk_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Era na rahida bonani paria kameai aha arahio era sobu Kaisarea. Na nanai Korneliusi tuti ne terafosa kontai ne maniwowiri wenotisara fosa efanduhisa etamang wei kawurua. ");
INSERT INTO amk_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Petrusi da to munufoi afui, Korneliusi detiaoi na kutu siari nanai da weui tuti suki aweu disang kapa awebuka somi wei. ");
INSERT INTO amk_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Wape Petrusi yuna warangfo yabiti aweai doa tuti medu wei deyo, “Boabari wau, weo yau kontaio inontarai siari fe yau ne.” ");
INSERT INTO amk_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Medu wei tonanai mae usuai pari to munufoi afui. Na rorongfo detio kaiwasa bitoya efanduhisa kawurua. ");
INSERT INTO amk_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Ainanaya medu wesa deyo, “Mewaitawanai weo na Kaiwo Musai soi fo, medu weduarai weo inontarai Yahudi nesa wiro ameweboyari ria inontarai siaio Yahudi kaha fosa, toyari mea kontai. Wape Allai deinawiai kawuru we yau ampa weo wiro imameatai we inai we kaiwasa siai fanai, weo ea kontai wiro isahusa we inontarai emai kaha saine ahang fanai. ");
INSERT INTO amk_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Ai wedaya bemi weo yau we ira ma mani wiro imadu riwana kaha. Ampafe yeo iwaitawang fianai aino bemi we yaua ira weai ma ne.” ");
INSERT INTO amk_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Korneliusi yoa deyo, “Rahida botoru da wa fo, tarahio ramindena toninai, araha ureng botoru, iwenadi na munu iminohi nai nei. Na tantuma kutu nanai, mang manei doari na arohureane. Ansung sensuna fo kaiwewa paria. ");
INSERT INTO amk_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Medu we yau deyo, ‘Korneliuse, Allai yoa we nemu nadiwai ampa tuti deitawang todoni enemuwawu mano ene pari fi fosa ampa. ");
INSERT INTO amk_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ampafe bemi maneitoru itora to Yope, awa itosahu inontarai manei, wonong fino Simon Petrusi. I minohi sau ria inontaraio niari andowa rerawa, wonong fino Simoni, ne munufoi wiatai na wenafareng fine.’ ");
INSERT INTO amk_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Aino wedaya mani isahera yemi inontarai we itora mau itosahu wau. Tuti wau enemurorong denteng paria we ro ma. Nina mani amea kiai amefanduhi amea na Allai urengreane weo ametarami kariri fianai aino Allai demi wau moduri kiai we amea ne.” ");
INSERT INTO amk_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ainanaya Petrusi medu deyo, “Arahio ninai amani yeitawanaifa weo fianai aino Allai niari weo inontarainesa kiai ne amani masi. ");
INSERT INTO amk_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Inontarai da na nu bodoni kontai ki, Yahudi tuti wiro Yahudi kaha, wape mitai Seng Allai tuti dohong kariri ne bengfo amani Allai sahui we ne arikang kontai. ");
INSERT INTO amk_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Mea kiai mewaitawangno kaiwo neung kutu Seng Allai fafongfa medurai weo inontarai na nu Israeli fosa. Kaiwoariri nana mani deiriri karirio Kaiwo Mahikai kia mai we tata na Yesus Kristusi, amani i weSeng we inontarai fuba nini kiaia. ");
INSERT INTO amk_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Tuti mewaitawangno fifianai aino kawariai na nu Yudea foi sentenang, amani wereantenang na Galilea na rabuangno Yohanesi deiriri kariri baptisifo kaia fo. ");
INSERT INTO amk_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Nana mani kariri Yesusi inontarai Nazareti foi, Allai yuaisi tuti sensoni na Nuaninu Mirarebana foi tuti na ne mambiriufo. Kontai Yesusi nani da niari bengfo mai katitaifoa kai. Inontarai fuba Saminseni dohonsa fosa, niarisa ebeng, weo Seng Allai weririati. ");
INSERT INTO amk_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ameaino inontarai amewati terai na ameuremireane kariri fi niariri kiai foi na nu Yahudi foia tuti na bendari Yerusalemi. Tonanai ki wape emuni etohoni sau na aitabafoi. ");
INSERT INTO amk_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Wape werahida botoru Seng Allai duwiri na marareha rorong foi tuti deinawi we inontarainesa. ");
INSERT INTO amk_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Wiro inontarai fuba nini kiai ewatioi kaha, mae mano Allai diri amea fafong weo ametairiri wonongfo, ameaino amewatioi tera ne. Weo suwi na marareha rorong foi mani ametampi ruhiai riati. ");
INSERT INTO amk_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Tuti Yesusi demi amea ametairiri kaiwo nanai weo inontarainesa, tuti ametaiririai kontai weo andino Seng Allai yuaisi we mano kiutu kaiwo weo inontarai fuba minohi darang nei tuti inontarai fuba mirehara foi ne, ambori na rahida kife nunei Yesusi deto tatesa kiai, amani mano ambori esobu mai fosa siai tuti mano ambori esobu ne karira fosa siai. ");
INSERT INTO amk_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Andino nabifosa kiai emadu kariri eteyo, inontarai mandoni kontaio yoaso Yesusi mani, ambori Yesusi feriri ne sasarifoi na ne wonongfo ki.” ");
INSERT INTO amk_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Na kutu siari Petrusi doa medu wesa nanai, Nuaninu Mirarebana foi biari meu tuti sensoni mano Yahudi kahaio etarami kaiwofe nanisa kiai. ");
INSERT INTO amk_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Inontarai Yahudi eroaso Yesusio era ria Petrusi na Yope ma fosa, ea kiai epapuhung paria, weo ewati Allai dohong Nuaninu Mirarebana foi we inontarai siai konta fefe. ");
INSERT INTO amk_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Weo etarami terai weo inontarai nanisa emadu na kaiwo siai bitoya tuti efiai Seng Allai. ");
INSERT INTO amk_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Ainanaya Petrusi medu deyo, “Mewati inontarai ninisa esobu Nuaninu Mirarebana foi kontai mai kariri Yahudine tata ampa. Ampafe iwebaptisisa na mereha mani manei medu weduasa rai e?” ");
INSERT INTO amk_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ampafe demisa weo ewebaptisi na Yesusi Kristusi wonongfo. Mayeaia mani etutani weo minohi riasa rahida beiru teai aha. ");
INSERT INTO amk_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Rasulifosa tuti doroi eroasoai na nu Yudea foi sentenang etaramioai weo inontarai siaio Yahudi kaha fosa kontai etarami Allai ne Kaiwofo tuti eroasoai. ");
INSERT INTO amk_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ampafe rahida bo Petrusi da to Yerusalemia foi, inontarai Yahudi mano eroasoaia fosa ewekaiwo wei eteyo, ");
INSERT INTO amk_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“Todonie ro to inontaraio ewesunati kaha fosa ene munufoa wei ne? Kontai boaria bampi riasa nariai aha.” ");
INSERT INTO amk_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ampafe donio Petrusi deikaririai wesa na mai, karirio fi fuba sodaira fo pari na reantenangfo. ");
INSERT INTO amk_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","Medu deyo, “Rahida bei na munue Yope iwenadi, amani iwati fieai. Fi iwatioa fo mani ne tarai toa fino ireu aburung tirera Allai suki na rorafaisi meu, sau na warabuka boa fo rurang yau. ");
INSERT INTO amk_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Na kutu siari iwati afui oi nanai, iwati andowa mano eawemi boa fosa, tuti mano ahumi kaha fosa, tutio mano efafa na earomi fosa, tuti romuo yuainsowang kaha foi. ");
INSERT INTO amk_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ainanaya manei raofuifeai medu we yau deyo, ‘Petruse, boa! Muni ambori bani.’ ");
INSERT INTO amk_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Wape iroa wei aha yeyo, ‘Sengne waune, nana fanai. Weo fiang amene wori weai ninai, wiro yang eai na wea kaha rai weo fimai kaha fine fefe.’ ");
INSERT INTO amk_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Manamo raofuifoi medu na rorafaisi aha meu deyo, ‘Fianai aino inaria mararebanaifa tuti mai we metangfo mani wiro mesahuai we fimai kaha fine fanai.’ ");
INSERT INTO amk_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Fi iwatioai nanai iwatioai pari we betoru, ainanaya dau to rorafaisi weru yaua. ");
INSERT INTO amk_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Na kutu iari nanai kontai tete etemi inontarai itowemantoru itora na Kaisarea we yau ma, itosobu munu iminohi nai foi. ");
INSERT INTO amk_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ainanaya Seng Allai Nuaninufoi demi yau ira ria itoru na wiro enehuwawerahai ahang kaha. Doroio eroasoai ewewonang ninisa era ria yau to Kaisarea, tuti amea kiai amesuai to Korneliusi ne munufoia. ");
INSERT INTO amk_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Mayeai deiririai we amea kariri todoni deti wewai manei doa na ne munufoi rorongfo tuti medu deyo, ‘Bemi maneitoru itora to Yope itosahu inontarai manei wonong fino Simon Petrusi. ");
INSERT INTO amk_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","I ambori deikaririai we wau kariri todoni Allai ambori feriri wau tuti nemu munu rorong wai kiai ne.’ ” ");
INSERT INTO amk_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Petrusi medu pampang deyo, “Tuti na kutuo imadu kaiwofo tonana fo, Nuaninu Mirarebana foi bia aweu sensonisa, ne tarai toyari reantenangfe sensoni tata kawurua nanai. ");
INSERT INTO amk_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Arahio arohuoai weo, Sengnei raminde medurai kawuru ampa deyo, ‘Yohanesi webaptisi kaiwasa na mereha, wape ambori Seng Allai webaptisi mea na Nuaninufoi, amani sensoni mea ki.’ ");
INSERT INTO amk_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ampafe tarai ampa weo Nuaninu Mirarebanaio Allai dohonai we tatara fo na rabuang bo taroaso Seng Yesus Kristusi fo, dohonai mai kontai we inontarai Yahudi kaha fosa. Ampafe tonana mani ambori isua Seng Allai e?” ");
INSERT INTO amk_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Etarami kaiwo fenana fo, emadu awarai ahang kaha, mae efiai Allai. Eteyo, “Oh, tarai! Tonana mani inontarai Yahudi kaha fosa kontaio Allai dohong rang wesa weo etaraberasa weru ene sasarifoi ambori esodai ne maifo.” ");
INSERT INTO amk_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Rabuang bo Majelisi Agama fesa emung Stefanusi nanai, inontarai eroaso Yesusi fosa etawisa ewawu tateraia. Manea ewawu paria sobu nu Fenisia, manea kontai ewawu paria sobu nu Siprusi tuti bendari Antiokia. Na katai ewawuoai nanai etairiri Allai ne Kaiwofo we inontarai Yahudi fosa terai. ");
INSERT INTO amk_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Wape na inontarai eroasoai nanisa, amani inontarai Siprusi tuti Kirene, manea etontai to Antiokia tuti na nanai etairiri Kaiwo Mahikai kariri Seng Yesusi we inontarai Yahudi kahai emadu kaiwo Yunani fosa. ");
INSERT INTO amk_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Sengnei warang mananu fo weririasa ampafe kaiwasa bitoya eroasoai tuti etaraberasa we Sengnei aha. ");
INSERT INTO amk_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Kaiwo kariri nanai dafai paria sobu jemati na Yerusalemi fosa etaramioai kontai, ampafe etemi Barnabasi dontai to Antiokiara we detisa. ");
INSERT INTO amk_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Rahida bo dontaia sobu kataifoi, detio Allai dohong ne bengfo arora tuti mioang inontarai eroasoai na nana fosa ne, piraise paria tuti deunausa kontai we eroasoaia mutu. ");
INSERT INTO amk_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Barnabasi nini mani inontarai enerorong denteng dine tuti Nuaninu Mirarebana nei sensoni. Kontai yoaso Sengnei na mai ampafe wedaya kaiwasa bitoya eraria Sengnei. ");
INSERT INTO amk_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Mayeai dontai to bendari Tarsusi awa sera we Saulusi. ");
INSERT INTO amk_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Na wanai sobui kiari to Antiokia aha ma. Unayai ria jemati na nana fosa defuina bei sentenang, tuti uraunau jematifosa tuti kaiwasa siai bitoya kontai. Na Antiokia nanai aino inontarai eroaso Yesusi fosa ahusa we inontarai Kristeni reantenang pari. ");
INSERT INTO amk_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Rabuang bonani nabi manea era na Yerusalemi to Antiokiara. ");
INSERT INTO amk_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Na ea manei wonong fino Agabusi. Na Nuaninu Mirarebana foi ne mambiriufo doari aweai medu deyo, “Na nunei sentenang ambori kahari fiebai bei ming ki.” (Fi medurai nanai tarai kaririai, amani na rabuang bo Klaudiusi yu Mananu Kaisari fo.) ");
INSERT INTO amk_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ampafe inontarai eraria Yesusi na nana fosa kiai, emadu ruhiai we efanduhi doi, etanatuai we doroio eroasoai na nu Yudea fosa, mansiari-mansiari dohonai kariri fianai aino sobua fo. ");
INSERT INTO amk_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Fi emadurai nanai etohong kaririai, ainanaya etemi Barnabasi tuti Saulusi uka fi etohona fo, ukara urohonai we mano ewenunggamiei we jemati na nu Yudea fosa. ");
INSERT INTO amk_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Na rabuang bonani kontaio Mananu Herodesi tefu inontarai eroasoa manea we de niari kangganisa. ");
INSERT INTO amk_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Demi afai mamuna emungno Yakobusi, i mani Yohanesi ne tafuai dine, emuni na sondu. ");
INSERT INTO amk_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Na kutuo detioai we Yahudifosa enemirorong piraise weo fi niari fo nanai, demi ne afai mamuna etafu nari Petrusi aha. Petrusi etafuri fo mani tete rahida fuba Yahudifosa esahuai we Rahida Roti Weragi Kaha fine. ");
INSERT INTO amk_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Etafuria mayeai ehari to munu aitamu rorong foi. Afai mamuna fosa etatosa werabuang boa, we ewaitawang wedua Petrusi na nanai. Rabuang bei mani ewemana. Herodesi enetituaitai weo rahida Paska foi kiai wori, dutang wawera Petrusi na kaiwasa bitoya foi euremireafo ki. ");
INSERT INTO amk_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ampafe Petrusifo eru aitamuoi wiana munu aitamu foi, wape mano eroasoa fosa ewenadifo mambiriu wei paria we Allai. ");
INSERT INTO amk_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Diru bo kameai ma weo Herodesi sahu Petrusi weo dutang wawerahi fo, diru nani Petrusi dena, wape warang awengfo eru aitamuoai tuti afai mamuna mandu uroa wahi. Na rahutu borong fo manea kontai ewaitawang weduari nayai. ");
INSERT INTO amk_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Tatofang nanai Sempaisi ne wewai manei doari na nanai, tuti sambewara bei ma sambewa rorong foi sentenang. Wewaifoi nihingno Petrusi paria doabariri, ainanaya medu wei deyo, “Boabari wau ahera!” Na kutu nanai kontaio wai besio ewora warangfe nai foi tiparesuai. ");
INSERT INTO amk_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Mayeai wewaifoi medu wei aha deyo, “Tata nemu ansungwa tuti sapatuwa.” Ainanaya niari kaririai. Wewaifoi medu nariai aha deyo, “Wonsung nemu ansung boriai wai tuti ro ria yau.” ");
INSERT INTO amk_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ainanaya Petrusi da ria wewaifoi to boriai weru munu aitamu foi, wape deitarahio fifianai aino wewaifoi niari nanai wiro antu kaha, mae manta demiei arora. ");
INSERT INTO amk_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ura weru mano ewaitawang weduari fosa, mano reantenang fosa mayea mani mano sua fosa aha, ainanaya ura sobu rahutu besio wia to bendarifoi fo. Rahutufoi tifai na mantauni, ainanaya ura to boriei tuti ura ria rang bei paria rea fo. Tatofang kutu nanai wewaifoi niai weruia. ");
INSERT INTO amk_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Mayeai arahio Petrusi deitawangno fianai aino sodaira fo, ainanaya medu deyo, “Oh, ninaia mani arahio yeitawanai weo Sengnei taraie demi ne wewai manei kawuru ma weo waraira yau weru Herodesi ne mambiriufo tuti fikarira fuba kiaio Yahudifosa enemitawanaifa weo ambori isodairaifa ne.” ");
INSERT INTO amk_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Doae enetituaitai tonanai, mayeai da to Mariai, Yohanesi mano esahui kontai we Markusi foi inang, itone munufoia. Na nanai inontarai eroasoa bitoya efanduhisa ewenadi we Sempaisi. ");
INSERT INTO amk_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Petrusi bioi rahutu boriei foi, mangfata wiwing manei wonong fino Rodei, da we fiai rahutufoi. ");
INSERT INTO amk_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Awa mani deroanso Petrusi rawafuifoi weriwang beyari. Wape piraise karerai ampafe fiai rahutufoi kaha, mae sikahera daraberahi ahafui, deikaririai wesa deyo, “Petrusi doari na borieife fo.” ");
INSERT INTO amk_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Wape etei wei eteyo, “Mata wefiauwou fe.” Manamo Rodei kika tawanai we beyari weo anture Petrusi dine. Doni emadu eteyo, “Tarahi ne wewaio deitawani fi dine.” ");
INSERT INTO amk_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Esawasa tonanai mae, Petrusifo doa mae bioi rahutufoi pampang. Donio awa efai rahutufoi tuti ewatioi nanai ehiri ewarami webeyari. ");
INSERT INTO amk_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Petrusi kiamang tawansa na warangfo ambori enemboru, mayeai deiriri kariri todoni Sempaisi kiari weru munu aitamu foi fo. Ainanaya deyo, “Meteikariri fininai we Yakobusi tuti tane doroi manoei wasa.” Mayeaia mani da weru katai nanai to katai siai aha. ");
INSERT INTO amk_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Kameaia mani afai ewaitawang weduari fosa emadu kariria. Enemitituaia kai na wea kaha we fianai aino Petrusi sodaira fo. ");
INSERT INTO amk_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ainanaya Herodesi demi ne afaifosa era esera we Petrusi na mai, manamo wiro esera sobui kaha. Ampafe Herodesi sahu afai ewaitawang weduari fosa ma dutang berasa, ainanaya demi manea emunsa. Mayeaia mani Herodesi da weru nu Yudea tuti niai na Kaisarea waroi kutea. ");
INSERT INTO amk_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Na rabuang bonani Herodesi kesou inontarai Tirusi fosa tuti inontari Sidoni fosa paria. Ampafe donio ea ruhiai era wei etoari na arongreafo. Reantenang mani ewawori we Balastusi mano wenunggamiei we munu Herodesi foi, ampafe i sau wesa. Mayeai era wa etoari na Herodesi arongreafo, ainanaya etutani we eweboyari aha, weo nu eminohi nai foi eha fiang na Herodesi ne kataifoi fefe. ");
INSERT INTO amk_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Na rahida bo wenotia foi, Herodesi sensuni na ne ansung mananu fo, ainanaya minohi na ne kadera mananu foi, kiorang we ne rai bitoya foi. ");
INSERT INTO amk_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ne rai fuba etarami didauwi fosa ebibe tutiri eteyo, “Mano medu nini mani seng dine wiro inontarai batang kaha.” ");
INSERT INTO amk_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Na kutu nanai kontaio Sempaisi ne wewai manei bioi weo enerorongfoi dedai we sobu fiai na sa, kontai wiro somi we Allai kaha fefe. Ampafe kauboi dani pariao mireha. ");
INSERT INTO amk_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Donio Sempaisi ne Kaiwone dafai wariai to katai bitoya tuti efau eroasoaifa. ");
INSERT INTO amk_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Barnabasi tuti Saulusi unari fi unari fo kai, urarabera suru na Yerusalemi, tuti uka Yohanes Markusi kontai da ria suru. ");
INSERT INTO amk_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Na inontarai eroasoai na Antiokia fosa, na wanai nabifea tuti mantaunaufea, toyari Barnabasi, Simeoni mano wonong tatawa fino Kumetani, Lukiusi na Kirene, Menahemi (i mani Herodes Antipasi tamangno yuti kontai), tuti Saulusi. ");
INSERT INTO amk_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Na rabuang bo ewenadi we Sempaisi tuti ewepuasa fo, Nuaninu Mirarebana foi medu wesa deyo, “Metiri Barnabasi tuti Saulusi metohong suru terai we yau, ambori unari fi yohonai kawuru we surua fo.” ");
INSERT INTO amk_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ewepuasa tuti ewenadia kai fo, eruai ewaramia wasau suru, ewenadi we suru tuti etemi suru ura wa. ");
INSERT INTO amk_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Allai Nuaninu Mirarebana foi demi Barnabasi tuti Saulusi ampafe urong to bendari Seleukia arau. Na nanai urafai to nu Siprusi. ");
INSERT INTO amk_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Na rabuang bo usobu bendari Salamisi fo, urairiri Allai ne Kaiwofo na Yahudifosa ene munu agama fo. Yohanesi mano ahui we Markusi dontai kontai ria suru we fiata suru. ");
INSERT INTO amk_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Itora wari nufoi sentenang paria sobu bendari Pafosi. Na wanai itosobu inontarai Yahudi manei, wonong fino BarYesusi, ete na kaiwo Yunani esahui kontai we Elimasi. I inontaraio wesulapi dine tuti nabi wetarai kaha, ");
INSERT INTO amk_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","i kontai mangfata we gubernorifoi. Gubernuri yu na nufoi nani wonong fino Sergius Paulusi, i inontarai sewai dine. Sahu Barnabasi tuti Saulusi urua, weo enerorongfoi dohong we tarao Allai ne Kaiwofo. ");
INSERT INTO amk_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Wape Elimasi, mano wesulapi nani, yurai paria we pempamu gubernurifoi ambori wiro yoaso Yesusi fanai. ");
INSERT INTO amk_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ainanaya Saulusi mano esahui kontai we Paulusi foi, Nuaninu Mirarebana foi sensoni, ampafe seite Elimasi tuti medu wei deyo, ");
INSERT INTO amk_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Ne, Saminseni ne arikang di wau! Wau weaiteta we ne bengne, tuti purarasa webeyari. Todoni fino wiro fotou nari kanggani fibeng Allai niari we feriri inontaraifesa ninai? ");
INSERT INTO amk_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ninaifa mani boti, Sengnei ambori bioi wau! Ambori uremuwa fafa tourai, paria wiro boti wofaisi ahang kaha.” Na kutu nanai kontaio Elimasi nuruainso toyari ayewi tuti mamantiti bei ma wedua urengfo, ampafe da warafafarai sera we inontarai we binti. ");
INSERT INTO amk_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Gubernurifoi deti teraifa na urengreafo weo fianai aino Elimasi sodairai nana fo, yoaso Yesusi, weo Sempaisi ne Kaiwofo dohoni pepuhung paria. ");
INSERT INTO amk_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Paulusi tuti ne maniwowirifosa itorafai na bendari Pafosi to bendari Perga na nu Pamfilia. Na nanai Yohanes Markusi dontai weru sitoru, daraberahi to Yerusalemi aha. ");
INSERT INTO amk_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Na Perga itora paria aha to Antiokia na nu Pisidia. Mayeai na rahida Sabati foi itora wa itominohi na munu agama Yahudi foi. ");
INSERT INTO amk_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Na rabuang bo etato Kaiwo Musai soi fo tuti nabifosa esoi foa kai fo, mano ewenunggamiei we munu agama foi etemi inontarai na nana fosa etutang Paulusi tuti ne maniwowirifosa eteyo, “Amene doroi bohine muntorune, masino muntone kaiwo aunau feai we muntofata inontarai ninisa mani muntomadurai.” ");
INSERT INTO amk_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Ainanaya Paulusifo doari ayai, yuai warang wesa mayeai medu deyo, “Nehu doroi inontarai Israeli tuti mano Yahudi kahai na nu siaio mesomi we Allai ne meaine. Metarami nehu kaiwone wo. ");
INSERT INTO amk_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Allaio Israelifosa ene Sengfoi, diri tane werengfosa kawuru ampa tuti niarisa etawing separai fuba paria na rabuang bo enayai we inontarai aisei na nu Mesiri fo. Mayeai na ne mambiriufo kiasa to boriei weru Mesiri. ");
INSERT INTO amk_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","We defuina piarua fo, na katai wekamamiei wowong fo, enari fimai kahai pampang wape sawani wesa. ");
INSERT INTO amk_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kaiwasa siao ewerabuang itu ene katai na Kanani fosa, Allai minsa tuti deto ene kataifoi we kaiwasa Israeli fosa, ambori esahu katai nanai we enefi terai. ");
INSERT INTO amk_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ne nanai kiai dao defuina piaura weru awa piarua sura (450). Etato nu Kanani foi wesa akawuru, mayeai Allai yuai mangkutu kaiwo wesa, paria rabuang bo nabi Samueli daria fo. ");
INSERT INTO amk_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Mayeai etutang we esobu mananu manei, ampafe Allai dohong Kisi antungno Sauli na Benyamini ne ririafoi, we wemananu wesa. I yu mananufo defuina piaru. ");
INSERT INTO amk_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Sauli yu mananufo defuina piaru foa, mayeai Allai wara sayari weru ne mananufo. Ainanaya yuai nari Dauti, yiwani we mananu wesa aha. Tuti Dauti nini Allai medu kariri kawuru deyo, ‘Isobu Isai antungno Dauti kawuru we inontarai enehuoi dine kawuru ampa. Andino ambori niari kariri fi yawi wea fo na mai.’ ");
INSERT INTO amk_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Na Dauti nani ne ririafoi, Allai yuai Mananu Mampariri manei we inontarai Israeli nesa kariri ne kaiwo dereraia fo, amani Yesusi andino weMananu Mampariri ne. ");
INSERT INTO amk_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Wiro Yesusi niari fi na nunei kaharai mae, Yohanesi sahu kawuru we inontarai Israeli nesa we etaraberasa weru ene sasarifoi tuti webaptisisa. ");
INSERT INTO amk_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Tuti Yohanesi rerai we yufia kai nana fo, medu we kaiwasafosa deyo, ‘Menemitituaitai we mandoni di yau e? Yau mani wiro mano metamang wei fi di yau kaha. Bireri! Wape i ambori da tua yau aha ma ki, tuti we irehu ne wai sapatu fo terai ki, wiro imai we inari finana kaha.’ ");
INSERT INTO amk_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Doroi bohi meweriria na Abrahami ma ne mea, tuti mano Yahudi kahaio mematai Allai ne meaine, we tataino kaiwo kariri Allai feriri tata fo dohonai kawuru meu ne. ");
INSERT INTO amk_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Weo kaiwasa enayai na Yerusalemi fosa tuti ene mano ewenunggamiei fosa, ewaitawana kahai we Yesusi mani Mananu Mampariri dine, ampafe eteiayari tuti emuni. Ampafe kaiwo nabifosa emadurai na fafongfa nanai, amani kaiwo na Sabati neungfo etaramioaifa fo, wetarai kaririaia, na rahida bo emuni foi. ");
INSERT INTO amk_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Wiro esobu fi sarawa feai riati we sodai aiboi marareha fo kaha, tonanai ki wape etanggewa Pilatusi we dohong aiboi marareha fo wei. ");
INSERT INTO amk_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Tuti enari kariri fianai aino na kaiwo mararebana fo esoi kariria kai fo, etu ne taraifoi weru aitabafoi tuti eharia wiatai na fafo rorong fo. ");
INSERT INTO amk_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Wape Allai duwiria suwi na marareha rorong foi aha, ");
INSERT INTO amk_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","tuti rahida beirua fo deinawi ne taraifoi we ne inontarai mano erariati kawuru na Galilea to Yerusalemi ma fo. Inontarai nani saino ninaifa mani etairiri kaririai we kaiwasa Israeli fine. ");
INSERT INTO amk_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Ampafe na ninaifa ametairiri Kaiwo Mahikai nanai kontai we mea, amani fianai aino Seng Allai dererai kawuru we tane werengfia fo, ");
INSERT INTO amk_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","finanai niari kawuru we tane werengfosa ene ririane tata, amani na duwi Yesusi na marareha rorong foi aha ne. Kariri kaiwo dotu na Masmuri bo boru foi deyo, ‘Wau mani nehu Kaisung di wau, tuti na rahida bonini yeinawiai we kaiwasanei we yau mani tamamu di yau.’ ");
INSERT INTO amk_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Allai duwiri kawuru na marareha rorong fi ampa, tuti ne taraifoi wiro wioru kaha. Ne tonanane Allai medu kaririai kawuru deyo, ‘Fi kiaio mirarebanai tuti wiatai wenumainufo amani fafongfa yereri we Mananu Dautia foi, ");
INSERT INTO amk_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Na kaiwo siaio Dauti medurai kontai toninai, ");
INSERT INTO amk_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Dauti niari kariri fianai aino Allai demi niari fo na mai ampa, paria i mireha kontai ria ne werengfoi tuti esarai. Tuti ne taraifoi wioru ampa. ");
INSERT INTO amk_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Wape Yesusi mano Allai duwiri na marareha rorong foi, ne taraifoi wioru kaha. ");
INSERT INTO amk_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Ampafe doroi bohine mea, todoni kontaio mewaitawanaifa weo tane sasarinei Yesusi nini dino feriri ne. Nanai aino yeisaharai we meane. ");
INSERT INTO amk_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Weo Hukumi Musai soi fo wiro demoyara kaha we feriri sasarinei. Wape mandoni dino yoaso Yesusi mani, wenani beng ria Allai aha finanaia. ");
INSERT INTO amk_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ampafe meuremi nai nayai na mai, weo dohonao mesodai kaiwo nabifesa emadurai eteyo, ");
INSERT INTO amk_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Inontarai menemikadatai biriu ne meaine, meuremi nai nayai. Mea ambori mepapuhung paria we fi inari ne, wape memarareha. Weo na rabuang bonini inari fifuba, finani mani manei deisaharai we mea kontai, wiro meroasoa kaha.’” ");
INSERT INTO amk_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Rabuang bo Paulusi tuti Barnabasi ura to boriei weru munu agama foi fo, inontarai efanduhisa na munu agama fi nanisa etare suru aha weo rahida Sabati bo da aha ma foi mani urarabera suru aha ma, we urairiri Allai ne Kaiwofo wesa nari aha. ");
INSERT INTO amk_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Era to boriei, inontarai Yahudi tuti mano Yahudi kaha fosa mae eweagama Yahudi, bitoya paria era ria suru, ampafe uraunausa ambori eru tawang Seng Allai ne bengnea mutu. ");
INSERT INTO amk_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Na rahida Sabati da aha ma foi, adareti kaiwasa na bendarifoi kiai da ma weo etarami Sengnei ne Kaiwone. ");
INSERT INTO amk_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Na kutuo mano ewenunggamiei we Yahudi na nana fosa ewati kaiwasa bitoya foi nana fo, enemirorong pirahai paria. Eteibera Paulusi tuti etapa kaiwoariri fuba umadura fo. ");
INSERT INTO amk_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Wape Paulusi tuti Barnabasi urufo, umadu kaiwofo na umatai kaha, mae umadu parai we ea, ureyo, “Allai demi auru auka ne Kaiwoaririne we Yahudi mea akawuru wo. Wape memaya we meroasoa kaha, ampafe mantaung meaino meteiayarai, weo wiro memai we mesobu maring Waidani kaha. Ampafe na ninai kontaio aura weru mea to kaiwasa siai, amani inontarai Yahudi kaha fosa. ");
INSERT INTO amk_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Weo Sengnei dohong kaiwo pondoai we tata, amani medu toninai, ‘Yau isahu wau weadia weo sambewa inontarai siai Yahudi kaha fosa, ambori ka mai tuti foriri kaiwasa we nunei sentenang.’” ");
INSERT INTO amk_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Na kutuo inontarai Yahudi kaha fosa etaramioai nanai efaraise karira, tuti eteyo Sempaisi ne Kaiwo kariri Yesusi fo mahikai paria. Tuti inontarai Allai na fafongfa dirisa we esobu ne maifo tuti Waidanifo, inontarai nanisa eroasoai. ");
INSERT INTO amk_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Sempaisi ne Kaiwofo dafai wariai na katai nani sentenang. ");
INSERT INTO amk_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Wape inontarai Yahudi fosa eweanggari inontarai baba na bendarifoi tuti wiwingfosa, mano na inontarai dedai na bendarifoi ambori eweaiteta we Paulusi tuti Barnabasi, tuti etata suru weru ene kataifoi. ");
INSERT INTO amk_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ampafe rasulifo suru ukafasefa kangganang niai na uawemifo we urainawi kariri esobu ne karirafo ki. Ainanaya ura to bendari Ikoniumia. ");
INSERT INTO amk_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Mano eraria Yesusi na Antiokia fosa efaraise paria tuti Nuaninu Mirarebana foi sensonisa. ");
INSERT INTO amk_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Na Ikoniumi Paulusi tuti Barnabasi usodai fianai aino usodairai na bendari Antiokia fo. Na nanai kontai ura to munu agama Yahudi foi, ukorang Sengnei ne Kaiwone na mai paria, donio wedaya Yahudi tuti Yahudi kaha fosa bitoya eroaso Yesusi. ");
INSERT INTO amk_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Wape Yahudi mano emaya we eroasoa kaha fosa, ewuwu kaiwo karira kariri kaiwasa eroasoa fosa, ambori ewedaya kaiwasa Yahudi kaha fosa enemirorong kerira doroio eroasoa fosa. ");
INSERT INTO amk_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Tonanai ki wape Paulusi tuti Barnabasi unayai waroi kutea na nanai, tuti ukorang kariri Sempaisi na wiro umatai kahai wesa. Ampafe Sengnei kontai dohong mambiriu we suru we unari fitantuma bitoya. Finanai deinawiai we kaiwo ukoramai kariri ne beng fenanai, kaiwo wetarai fine. ");
INSERT INTO amk_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Wape kaiwasa na bendarifoi esawa wawerasa, ampafe manea etau we inontarai Yahudi fosa tuti manea kontai etau we rasulifo suru. ");
INSERT INTO amk_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ainanaya Yahudifosa kontai Yahudi kaha fosa tuti mano